﻿USE sofia;
DROP TABLE IF EXISTS sofia.kiw_vpl;
CREATE TABLE kiw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kiw_vpl WRITE;
INSERT INTO kiw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Aaba Tiopiro: Hiiro uubi-ro rimoi-do iiobodimo raarai, odii tauo piꞌatimo, ioromahoroi-da made himoꞌa uubi-ro idomai-da iaꞌaumoi-da ioroaduꞌutimo emerai-ha pirimaꞌaimo. ");
INSERT INTO kiw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aaꞌo rauri, Aaba Tiopiro, moo rio-ka ara madei ata ma riꞌati meaha, ka ma rotiodoai rooi-do, mabu ioromahoroi-da iiobodimo raarai mea hiꞌa-ha tauo piriooho. ");
INSERT INTO kiw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Moo-ro iibai rododiai mabu roo umoo hiꞌa ma iiꞌi-ri, roo turiaha iematomudioumo raarai, Iesu-ri ihaha-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heroda Iudea Pai iemidioi-da, pemidio Aiai poue iemaꞌatidioumo dubui ata, ruu pairai Sakaraia-ka, ruu Abaidia guui meree-ka, Aiai Dubuae omaꞌati paꞌai-da. Ruu ooboi Erisabeta, Aiai poue iemaꞌatidio dubui, Arori guui-da oobo-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Riiti oroiꞌioi mea oobo-ra dubu-raka Iehoma hohoi-da. Paidubui madei-re, ka Bubui-re ai-pimabedioido. ");
INSERT INTO kiw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Irai riiti meree bia, mabu Erisabeta kaaro-ka, kamia riiti paꞌuri hiꞌa-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Himio ata, Sakaraia himia paꞌai uubi rautu irudeme motoi-da omaꞌati himioi ioohiai-da, ruu poue omaꞌati ma aꞌai-ri, Iehoma hohoi-da, ");
INSERT INTO kiw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","pouei emaꞌati bubui pobodoumo, rii oorio paꞌaimo, aaꞌo omaꞌati ma aꞌai meree ma emeeꞌaumoi-ri poohoumo, ruu apuimoi-ka, ribo mea herei ma iitoi-ri, irudeme motoi rioi Dubuae totoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Aaꞌo himio mabui-da, ribo mea herei iitoi-da, turiaha uubi kekai-da ai-pirudemeumo. ");
INSERT INTO kiw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kaida poobodi ruui-do Paidubui arerui, herei iito totoi iha tui hapuoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaraia-ro ruu iemeeꞌai-da urio podaudio, ka ruu toei-ro aiha peidai. ");
INSERT INTO kiw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Irai arerui-ro ruu oduuꞌai-ka, “Toe aꞌaiꞌa, Sakaraia. Iehoma-ro, roo irudemeai tauo oromai maaka, roo ooboi Erisabeta-ro, roo meree emetei aꞌai ohio, ka pairai ita idodo, Ioare. ");
INSERT INTO kiw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Rooi-do geema geꞌii-ro ooꞌai aꞌai, kamia hiiro-hiiro uubi geꞌii aꞌai aꞌai kaumo Ioare oobodi-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mabu Paidubui, hohoi-da ruu erehe hiꞌa dubu-ro ooꞌai aꞌai. Ruu-ro mire obo idioꞌa. Ka ruu Dubuae Urioi-ro maamui topii haato imamiai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hiiro Isaraꞌera uubi imaimai aꞌai rii himia Paidubui, Iehomai-do. ");
INSERT INTO kiw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ka ruu Paidubui epuui-da odai aꞌai, urioi-re erehei-reida, himogabo dubui Eria aibo. Abeamiꞌoi kaukai ma imeheꞌeai, mereei rautu gaaꞌu-ha ma emidioumo. Ka ruu-ro iroroomidio tiatoi, imaimai aꞌai, mea emidio oroiꞌioi eito. Uubi imaumodii aꞌai, Paidubui ooꞌui eito.” ");
INSERT INTO kiw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaraia-ro arerui atohetai-ka, “Moo-ro ara raai ihahai, raꞌaibou-da umoo iiꞌi raꞌai? Moo dubu paꞌuri-ka, kamia moo ooboi rautu paꞌuri-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Arerui-ro ruu oduuꞌai-ka, “Moo Gabiriera-ka. Moo Iehoma hohoi-da rotii, ka moo ruu-ro rotiodoai ara made meai roo ma romoaduꞌoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Irai roo-ro, moo madei eidai bia, ara madei ihahai ruu himia hiꞌa himio mabui-da oobodiiꞌai. Mabu roo-ro madei eidai biai-ri, roo oroaduꞌuti oropoiꞌoi aꞌai. Roo piroha emidioi aꞌai, modau-die aaꞌo madei ihahai moobodii.” ");
INSERT INTO kiw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aatu himioi uubi pauo piraromoumo, Sakaraia irudeme motoi-da tutuu-ha iomotiimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ka ruu iohuuꞌoi-da, made aaꞌoi modobo bia uubi eito. Rii-ro umoo iiꞌi-ka, ruu aape raa tauo eaꞌa maaka, irudeme motoi-da. Ruu-ro rii-do madei aaꞌoi modobo tiatoi-ri, tui-da perememeꞌuio. ");
INSERT INTO kiw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ruu iirudemea himio mabui ioropoiꞌoi-da, ruu aiha paraimai motoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ipi-ro iopoꞌii-da, ruu ooboi Erisabeta topii emeeꞌai-ka, ka tu-hapuo (5) ome motoi haato pemidio. ");
INSERT INTO kiw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Erisabeta-ro aaꞌoi-ka, “Paidubui-ro ara raai tauo ododiai maaka mooi-do. Doꞌou ara himiou, ruu rioi tauo obodii maaka, ka moo uubi-ro ireemehiipodioumoi, ai-remahuꞌeta.” ");
INSERT INTO kiw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Erisabeta topii tikiti (6) omei ioohiai-da, Aiai Iehoma-ro arerui Gabiriera potiodoai, goꞌotoi Rasaretai-to Garereia goroi-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ruu made pomodau, Iosepa iomodabuaimo meree-behei eito. Ruu, rii Pai, Damida guui meree-ka. Meree-behei pairai, Maria-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Arerui ooꞌui-ka, ida paaꞌo, “Miroi roo rautu-ka! Paidubui, roo rautu-ka. Ruu geema hiꞌa geꞌii-ka rooi-do.” ");
INSERT INTO kiw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria iraromoi pauo pimidai arerui iaaꞌo madei-da, ka ruu rio-ka umoo ma iiꞌi madei ihahai. ");
INSERT INTO kiw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Arerui-ro aaꞌoi-ka, “Maria, toe aꞌaiꞌa. Aiai Iehoma geꞌii-ka rooi-do. ");
INSERT INTO kiw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Roo topii emeeꞌai aꞌai, ka ohio-meree ootoi aꞌai, ruu pairai ita ahoꞌoo, Iesu. ");
INSERT INTO kiw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ruu geema-ro ooꞌai aꞌai, ka ruu ahoꞌoi aꞌai kaumo ohu hiꞌai Paidubui Meree. Aiai Iehoma-ro ruu Pai ododiai aꞌai, ruu rariai Damida emerai. ");
INSERT INTO kiw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ka ruu Iakobo aramiꞌoi Pai emidioi aꞌai, ka ruu Pai erarai oropoiꞌoi aꞌai bia.” ");
INSERT INTO kiw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria-ro ruu madei pomoaimai, “Ararau mooi-do raꞌaibou oobodi maꞌai? Mabu moo dubu tama umoo bia.” ");
INSERT INTO kiw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Arerui-ro omoaimai-ka, “Dubuae Urioi-ro roo atimai aꞌai, Aiai Iehoma erarai, rooato, ooꞌai aꞌai, aaꞌo rau-ri, Dubuae mereei ahoꞌoi aꞌai kaumo, Iehoma meree. ");
INSERT INTO kiw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Iraromai, roo riamabiai Erisabeta, pooꞌa ruu paꞌuri, uubi aaꞌoi ruu kaaro-ka, irai doꞌou, ruu topii tikiti (6) omei-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ata raa aahuu bia Aiai Iehomai-do.” ");
INSERT INTO kiw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria-ro aaꞌoi-ka, “Moo Paidubui himoꞌa meree-ka. Roo aaꞌo emerai mooi-do ita oobodi.” Ka arerui-ro, ruu aiha pemeheai. ");
INSERT INTO kiw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tutuu bia, Maria hioi-to eremaumodi-ka, ioroi, roꞌoa-roꞌoa goꞌoto atai-to, Iudea goroi-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Hiei-da ruu odoroi-ka, Sakaraia motoi, Erisabeta geꞌii made emaꞌai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ka Erisabeta-ro, Maria geꞌii madei ioromai-da, ruu topii ioidio mereei geꞌii ai-piamuhiodidio. Ka Erisabeta Dubuae Urioi-ro aiha piimamiai, ");
INSERT INTO kiw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ida geema madei-to paaꞌo, “Roo turiaha upibaiꞌoi-da, Iehoma meai, geegai roo reꞌei-daka, roo topii emidio mereei-re. ");
INSERT INTO kiw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Moo raꞌu meai-ra, Paidubui maamui-ro moo ma raamiai? ");
INSERT INTO kiw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mabu, roo madei aaꞌoi-da moo topii emidio mereei geꞌii iapuhiodidio. ");
INSERT INTO kiw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Geꞌii-ka, roo boꞌu-ro iraromo pupuo eidai, Paidubui iaaꞌo madei ihahai oobodi aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ka Maria-ro aaꞌo-ka, “Moo kaukaui-da, Paidubui ai-remarahue; ");
INSERT INTO kiw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Moo urioi rautu geema geꞌii raꞌai, Aiai moo oitorai Dubui-ri, ");
INSERT INTO kiw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mabu ruu-ro, moo ruu himoꞌa meree, oobo behai, iraromai-ri. Doꞌou imodau iiꞌai aꞌai himioi, turiaha uubi-ro moo geꞌii-to ahoꞌoodioi aꞌai kaumo, ");
INSERT INTO kiw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","mabu Erara Aiai-ro, mooi-do aꞌai raara paipai-ri. Ruu pairai Dubuae-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ruu giiꞌepui odai aꞌai, roo boꞌu-ro memaabe ruui-do, doꞌou abeamiꞌoi eito, mereei eito, aramiꞌoi eito, rariamiꞌoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ruu tui-da paipai aiaꞌaia raara pidodiai, ka boiꞌo-ro oroomomioumo, rii himia iraromoi-da, ruu-ro iburuti-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ruu-ro pai erara iemidioumo uubi ai-pimooruodio, ka himoꞌoi pimioo. ");
INSERT INTO kiw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ruu-ro rioi goroꞌoro uubi meamea raarai-da piomoto, ii raara hiiro-hiiro uubi tutuu-ha pitiodoai. ");
INSERT INTO kiw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ruu-ro, ruu himoꞌa mereei, Isaraꞌera ai-pomoaabai, ruui-do giiꞌepu iraromoi piraromai, ");
INSERT INTO kiw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Aberahamo himia rariamiꞌoi eito iaraa-ha, rimo abeamiꞌoi eito iaaꞌo aiboi.” ");
INSERT INTO kiw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria, Erisabeta rautu, retoꞌa-gaaꞌu (3) ome aibo pemidio, ida paraimai goꞌotoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Erisabeta mereei araraꞌii-ka, mereei aiha pooto, ohio. ");
INSERT INTO kiw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ruu riaraamiꞌoi-re, ruu taitai uubi-reiro, ruu Paidubui-ro iomoaabai mea geegai ioroomaimoi-da, geꞌii paꞌaimo ruu rautu. ");
INSERT INTO kiw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Puura gaaꞌui ioroohodi didimoi, mereei tama ahiai idabuaimoi-ka, ka pairai ma idodoumo Sakaraia, ruu abeai pairai-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Irai ooto maamui-ro aaꞌoi-ka, “Abia, ruu pairai, Ioarei-to, ita ahoꞌoumo.” ");
INSERT INTO kiw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Rii-ro ruu oduuꞌaimoi-ka, “Roo riaraamiꞌoi-da, iire pairai ahoꞌoumo bia.” ");
INSERT INTO kiw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ka rii-ro mereei abeai ememeꞌuioi-ka, mereei ruu-ro boꞌui-to ahoꞌoi maꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ka Sakaraia erememeꞌuioi-ka iꞌati raa-ri. Ka rii urio podaudioumo ruu iꞌati-da, “Ruu pairai Ioare-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aaꞌo ipi haato, Sakaraia madei araꞌerai-ka, Aiai aiha pemarahue. ");
INSERT INTO kiw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Riiti taitai uubi, geega toe paꞌaimo, ka madei iodai-da roꞌoa-roꞌoa mati Iudeaito, uubi-ro aaꞌo raarai madei aiha poromoaꞌoiamo. ");
INSERT INTO kiw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Diamoi ioroomaimoi-da, uubi geemai-ro ai-piraromoumo, ida paraatomo, “Ara mereeu raꞌu-ro ooꞌai maꞌai?” Mabu ruu Paidubui erara meree-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dubuae Urioi-ro, Ioare abeai Sakaraia iimamiai-da, araibau peremamaihidio: ");
INSERT INTO kiw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ai-remarahue kaumo Paidubui Iehoma, Isaraꞌera uubi Urio Abeai, mabu ruu tauo ooꞌu maaka, ruu uubi oroiꞌioi eito ma imaimai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ruu-ro erehe hiꞌa ioitouti mereei tauo rimaꞌai maaka, Damida guui-da, Damida Iehoma himoꞌa meree-ka. ");
INSERT INTO kiw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Aiai-ro epuui-to dubuae himogabo uubi madei modoboi, ruu iereemamaihidio aiboi, ");
INSERT INTO kiw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ruu-ro rimo iahiꞌii aꞌai, rimoi-do boho uubi-re, kamia rimoi-do udo uubi-rei erehei goroi-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ruu-ro rimo rariamiꞌoi giiꞌepu pimaꞌai, mabu ruu-ro ai-piraromai rii rautu iereemedeeꞌaumo Dubuae madei. ");
INSERT INTO kiw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Rimo rariai Aberahamo rautu iereemedeeꞌaido madei, ");
INSERT INTO kiw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","rimo boho uubi erehei goroi-da ma riahiꞌii, ka ruu himoꞌa ma raꞌaimo toe tiato-ha. ");
INSERT INTO kiw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ka rimo ruu hohoi-da, dubuae-ra gamoꞌo-raida ma rodaumo, rimo oroiꞌioi aꞌai himioi-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ka roo, moo meree, roo ahoꞌoi aꞌai kaumo hoꞌu hiꞌai Paidubui himogabo dubu. Mabu roo Paidubui epuui-da odai aꞌai, ruu gaboi emaumodi, ");
INSERT INTO kiw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ruu uubi umoo ma imaꞌai, oroiꞌioi eito ma iiraimaimo, rii memihoi imapihiti-da. ");
INSERT INTO kiw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mabu Aiai geema giiꞌepu-ka rimoi-do, aaꞌo rau-ri rimo ioitouti aꞌai mereei oaho himioi hehei aibo oruoi aꞌai aromoi-da, ");
INSERT INTO kiw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","hehei-da ma emidioumoi-ri, duꞌi-da emidio uubi-re, ka oroihi duꞌi-da emidio uubi-re, ka rimo otoi gamoꞌo gaboi-da ma rimadaꞌuimo miroi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ka mereei pupuo-ha piiꞌi tuupi-re urioi-rei rautu, ka opuhe mati-da pemidio, ida didimoi-to poobodi uubi geemai eito, Isaraꞌeraato. ");
INSERT INTO kiw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aaꞌo himioi, Roma hepui paidubui, Kaisara Agusito-ro, erara made edeꞌai-ka, uubi gamara paira bukai-da, pairai ma ideꞌaumoi-ri, Roma hepu geemai goroi-da. ");
INSERT INTO kiw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Epuu paira imeꞌei-ka, Kurerio Suria hepui gamara iiemidioi-da. ");
INSERT INTO kiw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ka turiaha uubi aiha piiraimutimo, rii himia-himia rariamiꞌoi, goꞌoto-goꞌotoi eito, pairai ma imodoumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ka aaꞌo rau-ri Iosepa, Rasareta goꞌotoi emeheai-ka Garereiaato, odai Beterehemai-to, Iudea goroi-da ooꞌa. Ruu rariai Damida ioobodi goꞌotoi-ka. Mabu ruu Damida guui-da dubu-ka. ");
INSERT INTO kiw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ruu iodai-da, ruu iomodabuaimo ooboi Maria, ai-pomodau pairai gaaꞌu-ha ma ideꞌaidoi-ri. Maria topii irio hiꞌai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Beterehemaa-to, mereei aiha pararaꞌii, ");
INSERT INTO kiw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","kiauka, ruu boma mereei aiha pooto ohio, hipurai-da omoomai-ka, boromokaui duui iihodioumo ipuai-da, aiha pomutaꞌa. Mabu dima motoi-da, riiti emidio hiaꞌe tiato-ka. ");
INSERT INTO kiw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ka aaꞌo duoi, mamoei iaꞌe uubi aamiꞌa, aaꞌo goꞌotoi taitai hauꞌii-da, mamoei paꞌai dabi paꞌaimo. ");
INSERT INTO kiw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ida poobodi Paidubui Arerui, ka Iehoma erehe hiꞌa hehei-ro, rii turiaha imemiai-da, iha toei paꞌaimo. ");
INSERT INTO kiw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Irai Arerui-ro aaꞌo-ka, “Toe aꞌaimoꞌa, moo-ro riꞌo meai-re, kamia hiiro-hiiro uubi-ro geꞌii hiꞌa, ma aꞌaimo made rimomoꞌu. ");
INSERT INTO kiw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Doꞌo hiꞌau riꞌo oroiꞌioi eito imodai aꞌai mereei, Damida goꞌotoi-da tauo oobodi maaka, Iehoma-ro Iapui Paidubui, ruu Pai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ka riꞌo-ro umoo ma iiꞌimoi-ri emeeꞌai aꞌai kaumo, ruu hipurai-da omoomatidio, boromokau duu_i iihodioumo ipuai-da oidio.” ");
INSERT INTO kiw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ka tutuu bia hiiro hiꞌa areru oobodimoi-ka aromoi-da, ruu rautu oodabuaimoi-ka, Iehoma raahoaꞌei-da emarahueumoi-ka, ");
INSERT INTO kiw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Aromoi hoꞌu hiꞌai-da, Aiai Iehoma emarahueumo, kamia miroi hepui-da mooꞌa-ka, Aiai Iehoma-ro geꞌii imaꞌai uubi eito!” ");
INSERT INTO kiw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Arerui aromoi eito iraimaimoi-da, mamoei dabi uubi-ro, oromoaduꞌoi-ka, “Aiha rodau kaumo, Beterehemai-to, Paidubui-ro rimo made, imetiodoai raai emeeꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ka horehore-ha podaumo, Maria-ra Iosepa-rai imeꞌai-ka, meree gagei boromokaui duui iihodioumo ipuai-da poidio. ");
INSERT INTO kiw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Rii-ro iemeeꞌaumoi-da uubi imoaduꞌuti-ka, arerui-ro mereei iatomudio emerai. ");
INSERT INTO kiw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ka aaꞌo madei ioromidioumo uubi turiaha urio podaudioumo. ");
INSERT INTO kiw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria-ro aaꞌo raarai aiha piraromai moꞌui-da, ka pupuo hiꞌai-to piraromo. ");
INSERT INTO kiw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mamoei dabi uubi-ro Iehoma raahoaꞌei-da emarahue-ha piraimaimo. Mabu rii-ro turiaha ioromidioumo, kamia ieaꞌaumo raarai arerui-ro aiha iatomudio emerai-ha pimeeꞌaumo. ");
INSERT INTO kiw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Puura gaaꞌui iorohodi didimoi-da, mereei tamai ahiai-ka, pairai aiha pidodoumo Iesu. Arerui-ro iemaꞌai pairai-ka, ruu maamui topi-da orododiai tiatoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Riiti dubuae ma iiꞌidoi-ri, ieremaumodido himioi ioropoiꞌoi-da, Mose bubui-da iaaꞌo emerai, Iosepa-ra Maria-rairo ruu aiha pomodaido, Ierusaremai-to, ma oaꞌueumoi-ri Paidubui eito. ");
INSERT INTO kiw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Paidubui bubui-da iꞌatimo emerai, “Epuu tutuei ohio-ra, ma oaꞌuei Paidubui eito”. ");
INSERT INTO kiw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kamia ai-podaido, poue raa ma omomohuduaimoi-ri, Paidubui bubui ohidioi-ri, iaaꞌo emerai, badu-oti tiato-ro ooꞌaato, ka upi momoꞌooti-to. ");
INSERT INTO kiw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aaꞌo himioi Ierusaremaa-to pemidio dubu ata paira-ka Simiora, ruu mea hiꞌa-ka. Kamia Aiai ai-pemabeedio, ruu ai-pomoti Isaraꞌera uubi ma imoabai meree-ri. Dubuae Urioi ruu rautu-ka, ");
INSERT INTO kiw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ruui-do Dubuae Urioi-ro, tauo pomoaꞌeemia, ruu iihiai aꞌai bia, modau-die Paidubui iapui mereei memeeꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Urioi-ro Simiora iimaamiai-da, ruu aiha podoro irudeme motoi eito. Ka maamu-ra abea-rairo Iesu pahapahai iomooꞌuidoi-da, bubui iaaꞌo raarai idomoiatidioi, Simiora-ro mereei aiha poobai ruu tui-da, ka Iehomai-do geꞌii made aaꞌoi-ka, ");
INSERT INTO kiw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ara doꞌou, Aiai-o, roo ieremamaihidio madei ihahai tauo oobodi maaka, roo-ro moo, roo himoꞌa mereei, rotiodoai iihiai eito, miroi-da. ");
INSERT INTO kiw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mabu moo himia idomai-da tauo remeeꞌa maaka, uubi ioitouti aꞌai mereei. ");
INSERT INTO kiw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Roo-ro aiꞌoi eremaumodi, uubi abeai hohooi-da, ");
INSERT INTO kiw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","roo rioi, roo hehei Iesu-ro, imoaꞌemiai aꞌai, Iuda guui-da paira tiato uubi eito, kamia tomioi imomoꞌui aꞌai, roo himia uubi Isaraꞌerai-do.” ");
INSERT INTO kiw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Mereei maamu-ra abea-rai urio podaudioido, Simiora mereei-ri iaaꞌo raarai-da. ");
INSERT INTO kiw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiora-ro meai imaꞌai-ka riibi, ida paaꞌo mereei maamui Mariai-do, “Ara mereeꞌu Iehoma-ro papui, ruuato hiiro uubi Isaraꞌera-to iraahioi aꞌai kaumo, kamia hiiro uubi ireibuai aꞌai kaumo. Ruu Aiai reꞌei-da hooho-ro oroaꞌeemia, ka hiiro uubi-ro eremamaraiboi aꞌai kaumo, ");
INSERT INTO kiw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","kamia rii piro-piro iraromoi hauꞌi eito imobodii aꞌai. Ka eꞌa hiꞌua aibo pauo iraromoi-ro, roo himia hiꞌa kaukai amuai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ka hiei-da pemidio paꞌuri hiꞌa himogabo oobo ata, ruu pairai-ka Ara, Paruera meree-behei-ka, Asa guui-da. Ruu semeri (7) burio beha pemidio dubui rautu, ka doꞌou, ruu eiti-poa (84) burioi-ka, himui. Ruu-ro irudeme motoi emeheai bia, duo-ra himio-raida ruu-ro Iehoma ai-pemarahuedio, imaꞌui-re irudemei-rei rautu. ");
INSERT INTO kiw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aaꞌo himio mabui haato, ruu eredeꞌai-ka, kiauka Aiai eito keito made aaꞌoi-ka, ka mereei made imoaduꞌoi-ka turiaha goꞌoto-goꞌotoi ioroomotiimo uubi eito, Iehoma-ro Ierusarema-ra Isaraꞌera-ra uubi, ma ioitouti-ri. ");
INSERT INTO kiw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosepa-ra Maria-rai, Paidubui Bubui modoboi-da imaꞌaimo omaꞌati, ioropoiꞌoi-da rii ireheꞌeai-ka iiraimai, Garereia hepui eito, rii himia goꞌotoi Rasaretai-to. ");
INSERT INTO kiw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mereei pupuoi rautu-ha piiꞌi, ruu pupuo moꞌui geema-ha pooꞌa. Aiai meai, aiha pooꞌa ruuato. ");
INSERT INTO kiw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Turiaha burioi Orohodi mahuai eito, Iesu maamu-ra abea-rai ioroaꞌoiadioumo emerai, imidai-ka odai Ierusaremai-to. ");
INSERT INTO kiw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu tuero (12) burioi-da, rii odaumoi-ka mahuai eito, rii iꞌatidioumo emerai. ");
INSERT INTO kiw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mahuai ioropoiꞌo didimoi, rii aiha pireheꞌeaimo iraimai goꞌotoi eito, maamu-ra abea-rai umoo iiꞌi bia, meree ohioi Iesu aiha pemeheaimo Ierusaremaato. ");
INSERT INTO kiw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Riiti-ro ai-piraromoido tabai goroi-da imimadaꞌui, irai himio gaaꞌui didimoi-da pomahoroido ororoohoi riaraamiꞌoi-re uubi-rei tuia-tuiai. ");
INSERT INTO kiw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Irai riiti-ro emeeꞌaido bia. Aaꞌo rau-ri, ai-piraimaido Ierusaremai-to ruu oohoi. ");
INSERT INTO kiw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Retoꞌa-gaaꞌu (3) himioi didimoi-da pemeeꞌaido, ruu irudeme motoi-da, Iuda imatomudio uubi tuiai-da pemidio, iroomidio-ra iatohe-rai paꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ka turiaha uubi urio podaudioumo, ruu umooi iemeaꞌaumoi-da, mabu ruui-do iatoheumo madei, gamoꞌo-ha pimoaimuti. ");
INSERT INTO kiw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ruu maamu-ra abea-rairo iemeeꞌaidoi-da, pauo-ha piraromoido, kaida paaꞌo maamui-ro, “Moo meree, ireibai raꞌu-ri ododiai rimoiti-do? Roo abeai-re mooi-re, roo-ro hora kaukau ridodiai, roo oohoi-da.” ");
INSERT INTO kiw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu-ro madei imoaimai-ka, “Riꞌoiti-ro moo raꞌu-ri rooho duido, riꞌoiti umoo ma iiꞌi, moo abeai motoi-daka.” ");
INSERT INTO kiw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Irai riiti-do iaaꞌo madei, riiti-ro umoo eidaido bia. ");
INSERT INTO kiw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ka ruu rautu atuha piraimaibiimo Rasaretai-to. Ka riiti-ro ruu iotomuido madei ai-peidai. Ka ruu maamui-ro ara raarai aiha piraromo, ka pupuo-ha pideꞌa ruu kaukai-da. ");
INSERT INTO kiw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ka Iesu tuupi-re moꞌui-rei rautu, iha aahuu-aahuui pitoꞌa, Aiai Iehomai-re uubi-reiro ruu ihaha rioi pemaꞌaimo. ");
INSERT INTO kiw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Roma pai, Kaisara Tiberu, iemidio pipitiri (15) burioi-da, pemidio, Poroto Pirato, Iudea gamarai. Heroda ruu Garereia hepui pai-ka, ka ruu raamu-abeai, Piripi, Iturea-ra Tarakori-rai hepui pai-ka, Risaria ruu Abirere hepui pai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ka Arasi-ra Kaiopasi-rai, Iehomai-do poue emaꞌati uubi epuuhoroti-ka. Ka aaꞌo himioi Aiai Iehoma madei ooꞌui-ka, Sakaraia mereei Ioarei-do, opuhe mati-da. ");
INSERT INTO kiw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ka aaꞌo madei itooi-da aaꞌo-ha poroaꞌoia Ioridara oomoi hapuo-hapuoi, “Ireheꞌeaimo riꞌo memihoi reꞌei-da oboi-da ma imaaheemoi, ka Iehoma-ro riꞌo memihoi imapihiti aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tauo-ha piꞌati, Iehoma himogabo dubui Aisaia bukai-da, “Ata meree itoo aaꞌo opuhe mati-da, ‘Paidubui gaboi emaumodimo rooꞌo-ha, ruu ma ooꞌui. ");
INSERT INTO kiw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Roꞌoai boboi iiopoumo, roꞌoai ubu-ubui patapata idodiaimo, Kima gaboi ma iꞌimuti, gamoꞌo-ha ma iiꞌai, roꞌoai bobo-boboi ma imoopoi. ");
INSERT INTO kiw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ka Iehoma-ro, uubi ioitouti iotiodoai mereei, turiaha uubi-ro eaꞌai aꞌai kaumo.’” ");
INSERT INTO kiw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hiiro hiꞌa uubi iohai-ka, Ioarei-do, obo ma imaaheemoi-ri, ruu-ro rii-do aaꞌoi-ka, “Riꞌo auo-ka! Riꞌo boꞌu-ro imoaduꞌo Iehoma otiodoai toto aꞌai riiboi-da riꞌo odaudioi aꞌai kaumo? ");
INSERT INTO kiw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ire raarai ita idodiaimo, ka ruuato riꞌo-ro oroahuꞌomai aꞌai kaumo riꞌo memihoi-da tauo pireheꞌeaimo. Ka riꞌo himia ipituiai-da omahoroumoꞌa oromoaduꞌuti araibau, ‘Aberahamo riꞌo rariai-ka.’ Moo-ro riꞌo ai-riduuꞌai Iehoma-ro ara roꞌoa kopi-kopi-da Aberahamo koemai uubi idodiai modobo-ka! ");
INSERT INTO kiw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ibuoi tauo-ha peremaumodi, ruꞌai hipi-da ma iahioi-ri turiaha, mea hura aꞌai tiato ruꞌai iahioi aꞌai erai tuiai-da miheuꞌato.” ");
INSERT INTO kiw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ka uubi-ro ruu atohetai-ka, “Rimo raꞌaibou aꞌai-ra?” ");
INSERT INTO kiw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ioare-ro rii imoaimai-ka, “Boꞌu reꞌei-darie retoꞌa (2) teti, ata gaaꞌui ma emaꞌai hobou-ha mereei eito, kamia boꞌu reꞌei-darie dui, ma eremaꞌati.” ");
INSERT INTO kiw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kamia taketi imoamee uubi aamiꞌa, ooꞌumoi-ka, oboi-da ma imaaheemoi-ri, ka rii-ro ruu atohetai-ka, “Imatomudio dubu-o, rimo raꞌaibou aꞌai raꞌai duumo?” ");
INSERT INTO kiw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ruu-ro rii pimoaimai, “Roma gamarai bubui-ro iedeꞌa modoboi ohui-da imoamei bia.” ");
INSERT INTO kiw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Heamo uubi aamiꞌa-ro ruu atohetai-ka, “Rimo mia raꞌaibou-ra? Rimo raꞌaibou aꞌai-ra?” Ioare-ro rii imoaimai-ka, “Meree ata mori, erehe eito oaidai bia, kamia auma tiato mereei, ematuhuti aibo ahoꞌoi bia. Riꞌo himia taꞌii-ha ma imidai udo tiato-ha.” ");
INSERT INTO kiw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Uubi iraromoi, iioi omahoroi-ka, kamia rii ioroomotidioumo, Ioare Iehoma-ro, uubi imoabai-ri iapui mereei roꞌoamooꞌa-o? ");
INSERT INTO kiw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ka Ioare-ro rii turiaha iduuꞌai-ka, “Riꞌo moo-ro oboi-da rimaaheemo, irai meree ata raa mooꞌu. Moo ruu aibo bia, ruu geema-ka, moo mea bia ruu oto tamai imi ma romopimuti, ruu-ro riꞌo Dubuae Urioi-re, erai-reida, imaaheemoi aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ruu ruꞌa hurai itode kukui tui-da ai-oꞌapudio, ruꞌa hurai ma itodei-ri, meai ruu du motoi-da, ma iraahoꞌoi, ka memihoi oropoiꞌo tiato erai eito ma ipeduai.” ");
INSERT INTO kiw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Himia-himia emerai-da poaduꞌo, Ioare-ro paimeai, uubi eito, ka uubi ai-pimoaduꞌuti, rii ioroiꞌioumo emerai-da ma ireheꞌeaimo. ");
INSERT INTO kiw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Irai Ioare-ro pai dubui Heroda erehe madei-to pemaaꞌo, mabu ruu raamu-abeai, ooboi Herodia ai-poahiꞌi, kamia hiiro-hiiro memiho raara ai-paꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kamia Herodai-do memiho hiꞌa iiꞌi, Ioare ruu-ro duꞌi motoi-da pibiꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Turiaha uubi oboi imaaheemo didimoi-da, Iesu obo oaahemai-ka. Ka ruu iirudemeai-da, aromoi aiha paraꞌerai. ");
INSERT INTO kiw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ka Dubuae Urioi, ruiai emerai pooruo, ruu ohui-da emiꞌei-ka. Ida made ata aromoi-da paaꞌo, “Roo moo rio mereei-ka, moo iha geꞌii raꞌai rooi-do.” ");
INSERT INTO kiw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ka Iesu omaꞌati iiomahoroi, ruu teeti (30) burioi-ka. Uubi iraromoumoi ruu Iosepa mereei-ka. Iosepa Heri mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heri Matatu mereei-ka, Matatu Remi mereei-ka, Remi Mereki mereei-ka, Mereki Iarai mereei-ka, Iarai Iosepa mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosepa Matataia mereei-ka, Matataia Amosa mereei-ka, Amosa Rahumu mereei-ka, Rahumu Eseri mereei-ka, Eseri Ragai mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ragai Mahata mereei-ka, Mahata Matataia mereei-ka, Matataia Semeira mereei-ka, Semeira Ioseka mereei-ka, Ioseka Ioda mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ioda Iorara mereei-ka, Iorara Resa mereei-ka, Resa Serubabere mereei-ka, Serubabere Searetiere mereei-ka, Searetiere Reri mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Reri Mereki mereei-ka, Mereki Adi mereei-ka, Adi Kosama mereei-ka, Kosama Eramadama mereei-ka, Eramadama Eo mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eo Iosua mereei-ka, Iosua Eriesere mereei-ka, Eriesere Iorima mereei-ka, Iorima Matatu mereei-ka, Matatu Remi mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Remi Simiora mereei-ka, Simiora Iuda mereei-ka, Iuda Iosepa mereei-ka, Iosepa Iorama mereei-ka, Iorama Eriakimi mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakimi Merea mereei-ka, Merea Mera mereei-ka, Mera Matata mereei-ka, Matata Ratara mereei-ka, Ratara Damida mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Damida Iese mereei-ka, Iese Obeda mereei-ka, Obeda Boasi mereei-ka, Boasi Saramora mereei-ka, Saramora Rasora mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Rasora Amiradaba mereei-ka, Amiradaba Adamira mereei-ka, Adamira Ari mereei-ka, Ari Hesarora mereei-ka, Hesarora Perese mereei-ka, Perese Iuda mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iuda Iakobo mereei-ka, Iakobo Isaꞌako mereei-ka, Isaꞌako Aberahamo mereei-ka, Aberahamo Tera mereei-ka, Tera Rahora mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Rahora Seruga mereei-ka, Seruga Reu mereei-ka, Reu Perega mereei-ka, Perega Eba mereei-ka, Eba Sera mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sera Keirara mereei-ka, Keirara Apasada mereei-ka, Apasada Sema mereei-ka, Sema Roa mereei-ka, Roa Remeka mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Remeka Metusera mereei-ka, Metusera Eroka mereei-ka, Eroka Iareda mereei-ka, Iareda Maharera mereei-ka, Maharera Kerara mereei-ka, Kerara Erosi mereei-ka, ");
INSERT INTO kiw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Erosi Seta mereei-ka, Seta Adamu mereei-ka, Adamu Iehoma mereei-ka. ");
INSERT INTO kiw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu ereheꞌeai-ka, araimai Ioridara oomoi-da. Ka Dubuae Urioi-ro ruu iimamiai-da, aiha pomodau opuhe ipi eito. ");
INSERT INTO kiw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ka hiei-da Satari-ro pematuhuti poati (40) himioi-to. Aaꞌo himioi-da, ruu raa ata uuho bia, ka ruu iha dui boboi peereaꞌaa. ");
INSERT INTO kiw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ka Satari-ro aaꞌoi-ka ruui-do, “Roo Aiai Iehoma mereei-ro ooꞌaato? Ara roꞌoa kopi pupuo made ma emaꞌai, ka ruu du-ro orododiai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Irai Iesu-ro omoaimai-ka, “Iehoma made bukai-da, tauo piꞌatimo, ‘Uubi dui haato, oroiꞌioi aꞌai bia.’” ");
INSERT INTO kiw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kiauka, Satari-ro ruu omioi-ka, ohu hiꞌa mati atai-to, ka ruu-ro horehore-ha pomoaꞌemia turiaha ara hepui pai emidio erara raarai. ");
INSERT INTO kiw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Satari-ro ruu oduuꞌai-ka, “Moo-ro emaꞌai raꞌai rooi-do, turiaha erarai ara raarai rautu, mooi-do piremaꞌai ka moo-ro boꞌui-do emaꞌai riraromo, moo-ro emaꞌai raꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ka turiaha ara raarai roo-ro imidai aꞌai, roo aia mihimai, mooi-do emarahuei.” ");
INSERT INTO kiw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu-ro omoaimai-ka, “Iehoma made bukai-da, tauo piꞌatimo, ‘Roo Paidubui Iehoma-haido ma emarahuei, ka ruu omaꞌati behai-ha ma ododiai.’” ");
INSERT INTO kiw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kiauka Satari-ro ruu omodai-ka, Ierusaremai-to, ka irudeme motoi ohu hiꞌai-da itoꞌaidoi-ka, ida paaꞌo ruui-do, “Roo Aiai Iehoma mereei-ro ooꞌaato? Eemediꞌa goroi eito. ");
INSERT INTO kiw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mabu, Iehoma made bukai-da, tauo piꞌatimo, ‘Aiai Iehoma-ro ruu arerui made imaꞌaiꞌai, roo mea hiꞌa-ha ma emaabeumoi-ri.’ ");
INSERT INTO kiw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tauo piꞌatimo, ‘Rii-ro, roo oꞌapuai aꞌai kaumo, rii tui-da, ka roo otoi temeteme eidai aꞌai bia, roꞌoai-da.’” ");
INSERT INTO kiw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Irai Iesu-ro ruu omoaimai-ka, “Iehoma made bukai-da tauo piꞌatimo, ‘Roo Paidubui Iehoma, roo-ro emahibai-da, edeꞌai bia.’” ");
INSERT INTO kiw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ka Satari-ro Iesu ematuhuti turiaha ioropoiꞌoi-da, ruu-ro, Iesu emeheaibuai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kiauka Iesu ereheꞌeai-ka Garereiai-to araimai, ka Dubuae Urioi erarai ruuato aiha pooꞌa. Ka ruu pai aburai-ka turiaha aaꞌo mati iooꞌa modoboi. ");
INSERT INTO kiw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ruu-ro idabu motoi-da ai-pimatomudio, ka turiaha uubi-ro ruu ai-pemarahueumo. ");
INSERT INTO kiw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iesu odai-ka Rasaretai-to, ruu ioomotoumo mati eito. Ka Sabati himioi-da, ruu odai-ka idabu motoi eito, ruu iꞌatidio aiboi. Ruu eibuai-ka, Iehoma made bukai ma iaapoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ka himogabo dubui, Aisaia titi aiha pemaꞌaimo. Apopoi-ka, iꞌatimo mati aiha pemeeꞌa: ");
INSERT INTO kiw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Paidubui Dubuae Urioi moo rautu-ka, mabu ruu-ro moo ai-pirapui, mea madei aꞌamii uubi eito ma rimoaduꞌuti-ri. Ruu-ro moo ai-pirotiodoai, uubi made ma rimaꞌai-ri, rii duꞌi motoi-da iitohitiimoi, moo-ro iiahiꞌii raꞌai, ka idomai tiato uubi idomai ma iaamodiimo, ka pauo hiꞌa emidio oroiꞌioi reꞌei-da ma rimodaadeai, ");
INSERT INTO kiw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ka oaduꞌo himioi tauo oohiai maaka, Paidubui ruu himia uubi, oroiꞌioi eito ma imaimai-ri.” ");
INSERT INTO kiw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iesu-ro titi otohiti-ka, aiha pemaꞌai imoabai mereei eito, ka ruu aiha pemiꞌei. Idabu motoi rioi iemidioumo uubi, turiaha idomai ruu-hato piiꞌaa, ");
INSERT INTO kiw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ruu-ro rii-do, aaꞌoi-ka, “Ara titi-madei doꞌou ihahai tauo obodii maaka, moo-ro iriapoi-da, riꞌo-ro imoromidioumo emerai.” ");
INSERT INTO kiw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Rii turiaha-ro, ruu geꞌii pemaꞌaimo, kamia urio podaudioumo, ruu puꞌoi-da iohuꞌo made meai-da. Ka rii-ro aaꞌoi-ka, “Ruu Iosepa mereei-ra?” ");
INSERT INTO kiw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu-ro rii-do aaꞌoi-ka, “Moo umoo-ka, doꞌou riꞌo-ro, aaꞌoi aꞌai kaumo, ara obeegiri mooi-do, ‘Doketa, roo himiaha-ro, oodomoia.’ Riꞌo-ro moo ata oduuꞌai aꞌai kaumo, ‘Ata raa ma raꞌai-ri ara rimo himia goꞌotoi-da, Kaperaraumaato iorododiaimo aiboi, riꞌo-ro ioromidioumo emerai.’” ");
INSERT INTO kiw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iesu-ro aaꞌoi-ka, “Moo-ro riꞌo ihaha riduuꞌai araibau. Himogabo dubui ruu himia goꞌotoi-da, emabeumoi aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Moo iaha roromiidiioumo: ihaha-ka, Eria himioi-da, upi himui hiiro-ha pemidioumo Isaraꞌeraato, aaꞌo himioi mihae iaꞌuti bia retoꞌa-gaaꞌu (3) burioi-re tikiti (6) omei-reida, du tiato miomai-ro turiaha aaꞌo hepui aiha peidai. ");
INSERT INTO kiw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ka Eria otiodoai bia meree atai-do Isaraꞌera goroi-da, irai oobo himu atai-do podau, goꞌotoi Sarapetai-to, Sidoro hepui-da. ");
INSERT INTO kiw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ka hiiro hiꞌa tauo pemidioumo, mobibi gimoi rautu, Isaraꞌeraato, himogabo dubui Erisa himioi-da, irai gaaꞌubuo ata oodomoia bia, iiꞌi Suria dubui Ramari beha-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Idabu motoi uubi-ro iioromaimoi-da, rii turiaha udo paꞌaimo. ");
INSERT INTO kiw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Rii iireibuaumoi-da, Iesu aiha pohiꞌitimo, goꞌotoi kekai eito, ka ai-pomodaumo rii goꞌotoi iididimo roꞌoai ohui eito, rii rio-ka, ruu ohiꞌiodidioi roꞌoai dodoroi-da, ");
INSERT INTO kiw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","irai uubi tuiai aiha poroohodii, ka ruu himia gabo-ha podau. ");
INSERT INTO kiw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kiauka, Iesu aiha podau Kaperaraumai-to, goꞌoto ata-ka, Garereia goroi-da, ka Sabati himioi-da, uubi imatomudioi omahoroi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rii urio podaudioumo, ruu iimatomudio emerai-da, mabu ruu erehei rautu-ha poroaduꞌuti. ");
INSERT INTO kiw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Idabu motoi rioi-da pemidio, memiho urio rautu dubu ata. Ruu aapoꞌiai-ka, pai rautu madei-to, ");
INSERT INTO kiw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aaa, Rasareta Iesu-o, roo raꞌu rio maꞌai rimoato? Roo rimo imodoboai amooꞌu? Moo umoo-ka, roo boꞌu-ra: roo Aiai Dubuae himoꞌa mereei-ka!” ");
INSERT INTO kiw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu-ro erehei-to aaꞌoi-ka, “Piroha! Ohuuꞌo ara dubui-da.” Kiauka memiho urioi-ro, aaꞌo dubui aiha peheuꞌato, rii turiaha hoho reꞌei-da, ka aiha pohuꞌodidio ruuato, ruu omodoboa tiato-ha. ");
INSERT INTO kiw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Uubi urio podaudioumo, ka rii himia-ro ai-poroduꞌaitutiimo, “Raꞌaibou made raumo ara? Erehei-re pupuoi-rei rautu, ara dubui-ro, memiho urioi made imaꞌai-da, aiha ihuꞌodidioi-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ka Iesu pai, aiha paburai, aaꞌo hepui-da. ");
INSERT INTO kiw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Idabu motoi emeheai-ka Iesu, ka ai-podau Simora motoi eito. Simora emapua maamui hamamaa gimo paꞌai, ka rii-ro, Iesu oduuꞌaimoi-ka, ruu ma omoabaimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu odai-ka totoi kekai-da aiha potoꞌa, ka hamamaa gimoi made emaꞌai-ka, ruu ma emeheai-ri. Kiauka gimoi-ro, ruu iemeheai-da, ruu gaaꞌubuo-ha peibua, ka ruu-ro, rii iiho du imododia-ka. ");
INSERT INTO kiw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Himioi ioopiꞌoma didimoi-da, uubi-ro, Iesui-do imooꞌumoi-ka, turiaha boiꞌo-ro emidioumo, himia-himia gimoi rautu, ka ruu tui iiaꞌoi-ka rii ohui-da, ka rii turiaha meaha iiꞌimoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Memiho urioi hiiro uubiato pihuꞌotutiimo, ka pairautu madei-to paaꞌoumo, “Roo Aiai Iehoma mereei-ka.” Iesu-ro memiho urioi bubu made imaꞌai-ka, rii made aaꞌo tiato-ha ma iiꞌai-ri, mabu rii umoo iiꞌimoi-ka, ruu uubi imoabai-ri, iotiodoai mereei-ka. ");
INSERT INTO kiw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Himioi ioahoi-da, Iesu-ro, goꞌotoi emeheai-ka odai, muio-ipi eito. Ka uubi-ro omahoroi-ka ruu oohoi, ka rii-ro ruu iemeeꞌaumoi-da, rii-ro emahibai-ka ruu emadohoi, ruu-ro rii imeheaiꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Irai rii-do ruu-ro aaꞌoi-ka, “Moo-ro ma rimoaduꞌuti, Iehoma pai emidio erara mea madei, goꞌoto aamiꞌai pairi, mabu ire moo Aiai Iehoma-ro ododiai-ri irotiodoai omoaꞌati-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ka ruu-ro idabu motoi rioi-da, ai-pimatomudio, Iudeaato. ");
INSERT INTO kiw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Himio ata, Iesu Geresareta damoi kekai mioi-da potii, ida uubi ooꞌumoi-ka ruui-do, irai ai-poromotoꞌoimo Aiai Iehoma madei, oromidioi. ");
INSERT INTO kiw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ruu-ro retoꞌa (2) peeti imeꞌai-ka, mioi-da piaꞌoaimo, raa iobo uubi-ro pimeheaimo, ka rii pohoi pimoruꞌoumo. ");
INSERT INTO kiw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iesu oroi-ka aaꞌo peei atai-da, aaꞌo peei Simora peei-ka, ruu atohetai-ka, ma iꞌimaibuai-ri tuia aiboi eito. Iesu emiꞌei-ka peei rioi-da, ka uubi hiiroi, pimatomudio. ");
INSERT INTO kiw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kiauka, ruu oroaduꞌuti ioropoiꞌoi-da, Simorai-do aaꞌoi-ka, “Peei oabu gomoi eito, rooi-re, ka roo aamiꞌai-rei rautu, pohoi ma idobiaumo, raa ma iobomo.” ");
INSERT INTO kiw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simora-ro omoaimai-ka, “Epuudubu-o, rimo duo tutuui biai roroaꞌoia maakaumo, ata raa iobo bia. Irai roo-ro aaꞌoi-ri, pohoi idobiai raꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Rii-ro iodobiaumoi-da, hiiro hiꞌa raa piohiaimo, pohoi taitai-ka arahiuti. ");
INSERT INTO kiw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Imemeꞌuioi-ka, rii aamiꞌai pee atai rioi-da, rii imoabai ma ooꞌumoi-ri. Rii iooꞌumoi-da peeti, hiiro hiꞌa raa piomutimo, peeti taitai-ka ioruoi. ");
INSERT INTO kiw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ida Simora Petero-ro, iobodimo raai ieaꞌai-da, ruu popupopu pihimai, Iesu hohoo reꞌei-da, ida paaꞌo. “Odadeai moo reꞌei-da, Paidubu-o! Moo memiho dubu-ka!” ");
INSERT INTO kiw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ruui-re, ruu rautu aamiꞌai-rei, urio podaudioumo, rii ioboumo raa hiiroi iaꞌaumoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gaaꞌu aibo-ka, Simora aamiꞌai ihahai, Sebedi meree ohiooti-ka, Iemisi-ra Ioare-rai. Iesu-ro Simorai-do aaꞌoi-ka, “Toe aꞌaiꞌa, doꞌoi imodau ooꞌaiꞌai himioi, roo-ro uubi iohi aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Rii peeti itomaimoi-ka, mioi ohui eito, turiaha raarai imeheaimoi-ka, Iesu obodooi. ");
INSERT INTO kiw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Himio ata, Iesu goꞌoto ataato pemidio, ka hiei-da dubu ata, ruu tamai turiaha mobibi haaro piiꞌa, ruu-ro Iesu iemeeꞌai-da hohoo reꞌei-da ihimai-ka. Ruu oroaroi-ka, ida paaꞌo, “Paidubu-o, roo rio-ro ooꞌaato, moo odomoiai ka rodomoia.” ");
INSERT INTO kiw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu tui ruu ohui-da iaaꞌoai-ka, ida aaꞌo-ka, “Iee, moo rio-ka, doꞌo hiꞌau roo meaha-ka.” Kiauka mobibi gimoi-ro, ruu emeheai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ka Iesu-ro bubu made emaꞌai-ka, “Meree ata omoaduꞌoꞌa, gamoꞌo-ha odau poue emaꞌati dubui eito. Ka roo ruui-do oroahuꞌomai aꞌai. Poue ita aꞌai, Mose bubui-da, iaaꞌo modoboi. Ka uubi-ro umoo iiꞌi aꞌai kaumo, roo meaha-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Irai Iesu odii geega iiꞌi-ka, ka hiiro hiꞌa uubi ooꞌumoi-ka, ruu oromidioi, kamia gimoi-da ma idomoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Irai ruu odai-ka muio mati atai-to, irudemei-ri, ruu iꞌatidio aiboi. ");
INSERT INTO kiw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Himio ata, Iesu iimatomudioi-da, Pariseia uubi-re, ka bubui imatomudio uubi-rei, hiei-da pemidioumo, ioꞌumo uubi turiaha goꞌoto goꞌotoi-da Garereia goroi-da, ka Iudea goroi-daire, kamia Ierusaremaatoi-re. Paidubui erarai aiha pooꞌa, Iesu-ro, gimo uubi ma idomoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dubu aamiꞌa-ro, dabu mereei omooꞌumoi-ka, tioi rautu, tautapei-da, ka rii-ro emahibai-ka, omodoi-ri motoi rioi eito, Iesu hohoo reꞌei-da, ruu ma omutaꞌaumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Irai uubi hiiroi-ri, rii pauo pemeeꞌaumo ruu ibiiꞌai. Ka rii-ro ruu ai-pomioumo motoi ubui eito, hiaꞌe ododiai-ka ubui-da. Ka ruu omooruoi-ka tautapei-da, uubi tuiai-da, Iesu hoho reꞌei eito. ");
INSERT INTO kiw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesu-ro, rii pupuo iraromoi iimeaꞌai-da, ruu-ro dabu dubui eito aaꞌo-ka, “Dubu-o, roo memihoi tauo remapihiti maaka.” ");
INSERT INTO kiw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bubui imatomudio uubi-re, ka Pariseia uubi-reiro oomahoroi-ka rii himiai-do oromoaduꞌuti, “Boꞌu-rie ara Iehoma pairai omodoboa dubui? Iehoma beha-ka, memihoi imapihiti dubui.” ");
INSERT INTO kiw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu umoo iiꞌi-ka, rii iraromoi, ida aaꞌo-ka rii-do, “Raꞌu-ri miraromo duumo, ire raarai? ");
INSERT INTO kiw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Modobo bia-ra, araibau aaꞌoi, ‘Roo memihoi tauo emapihiti maaka,’ kamia modobo-ra aaꞌoi, ‘Eibua, ma imadaꞌui.’ ");
INSERT INTO kiw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Moo-ro imoahuꞌomai raꞌai riꞌoi-do, Uubihaubi mereei erara-ka, ara hepui-da, uubi memihoi ma imapihiti.” Kiauka ruu-ro aaꞌoi-ka dabu dubui eito, “Moo-ro ai-raaꞌo, eibua, roo tautapei ooꞌa tioi oꞌapuai, ka odau motoi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kiauka gaaꞌu-ha peibua rii turiaha hohoi-da, ruu iorobu tioi oꞌapuai-ka, odai motoi eito, Iehoma emarahue-ha. ");
INSERT INTO kiw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rii urio podaudioumo, ka Iehoma rii-ro ai-pemarahueumo iha toei rautu, ida paaꞌoumo, “Urio odaudio raara tauo riaꞌa maakaumo, ara himioi-da!” ");
INSERT INTO kiw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aaꞌo didimoi, Iesu odai-ka. Ida pemeeꞌa taketi imoamee dubui, pairai Remi, ruu ai-pemidio, taketi imoamee motoi-da. Iesu-ro aaꞌoi-ka, “Moo robodoo.” ");
INSERT INTO kiw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ka ruu eibuai-ka, turiaha raarai imeheai-ka, Iesu obodoi. ");
INSERT INTO kiw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kiauka Remi-ro, Iesu geema iiho omododiai-ka, ruu motoi-da, hiiro taketi imoamee uubi-re, ka uubi aamiꞌai-re, turiaha emiꞌeituti-ka iihoi. ");
INSERT INTO kiw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pariseia uubi-re, kamia bubui imatomudio uubi-reiro, pauo peaꞌaumo, ida paaꞌoumo, Iesu iimatomudio mereei eito, “Riꞌo iiho-ra idio-rai, memiho uubi-re, kamia taketi imoamee uubi-rei rautu, raꞌu-ri maꞌai duumo?” ");
INSERT INTO kiw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu-ro rii madei pimoaimai, “Gimo tiato uubi doketa rio aꞌai bia. Gimo uubi haa-ro oohoi aꞌai kaumo doketa. ");
INSERT INTO kiw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Moo irooꞌui mea emidio uubi iahoꞌoi ooꞌu bia ma ireheꞌeaimo, irai moo ai-pirooꞌu memiho uubi ma riduuꞌai, memiho oroiꞌioi-da ma ireheꞌeaimo.” ");
INSERT INTO kiw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aamiꞌa uubi-ro, Iesui-do aaꞌoi-ka, “Ioare iimatomudio uubi imaꞌui-ra, iirudeme rai geega-ha piꞌatidioumo, kamia Pariseia uubi-ro uubi iimatomudio uubi rautu, gaaꞌu emerai piꞌatidioumo. Irai roo obodoumo uubi, iiho-ra idio-rai aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu-ro rii madei pimoaimai, “Riꞌoi-do modobo-ra, riꞌo madei-da, oio idabuai oobo-ra dubu-rai idabuai eito, imiamaꞌue-ka uubi, iiho tiato ma emidioumo, oio idabuai oobo-ra dubu-rai, dubui riꞌo rautu emidioi-da? Abia. ");
INSERT INTO kiw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Irai himioi ooꞌui aꞌai, oio orobai oobo-ra dubu-rai, dubui rii reꞌei-da, ma omodadeai-ri. Aaꞌo himioi-da iamaꞌue uubi imaꞌui emidioi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu-ro, ara obeegiri imoaduꞌoi-ka, “Meree ata-ro, oio hipurai oaheꞌai aꞌai bia, pamo hipurai-da, ma oateai-ri. Ruu-ro aia mododiai, ruu-ro, oio hipurai raato tauo ododiai maaka, kamia oio hipurai-da, tauo hipurai oateai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kamia meree ata-ro, oio mire oboi aatei aꞌai bia tauo mire obo beumai-da. Aaꞌo emerai aia mododiai, oio mire oboi-ro, beumai apoꞌiai aꞌai, ka mire oboi hepui eito oruodi aꞌai, kamia beumai rautu memiho iiꞌi aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aaꞌo rau-ri, oio mire oboi, oio beumai haato, ma aatei. ");
INSERT INTO kiw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Meree ata-ro, oio mire oboi rio aꞌaiꞌai bia, tauo mire oboi idio didimoi-da. Ruu-ro aaꞌoi aꞌai, ‘Tauoi mea hiꞌa-ka.’” ");
INSERT INTO kiw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Iesu, uiti hauꞌi tuia-tuiai pimadaꞌui Sabati-da, ka ruu obodo uubi-ro uiti epu-epui imeꞌei-ka, tui-da ihiiꞌautiimoi-ka, ihai aiha piihoumo. ");
INSERT INTO kiw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aamiꞌa Pariseia-ro rii iatohetai-ka, “Raꞌu-ri maꞌai duumo, rimo bubui-da eremaabe raai, memiho-ka iibai aꞌai Sabati-da.” ");
INSERT INTO kiw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu-ro rii imoaimai-ka, “Riꞌo-ro tauo piapoumo, Damida raꞌu aꞌai, ruui-re, ruu aamiꞌai-rei, dui boboi-ro iiohiai-da. ");
INSERT INTO kiw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ruu odoroi-ka, Aiai Iehoma motoi rioi eito, poue iemaꞌaimo paramai eidai-ka, uuhoi-ka, ka aiha pimaꞌai ruu rautu dububaiꞌoi eito. Irai rimo bubui-ro ai-aaꞌo, Iehomai-do poue emaꞌai paramai, uuho beha meree-ro uuhoi aꞌai bia, poue emaꞌati mereei ata haa-ro uuhoi aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iesu-ro, omoopai-ka, “Uubihaubi mereei, ruu Sabati Paidubui-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabati ata, Iesu odoroi-ka, idabu motoi rioi eito. Ka ai-pimatomudio, ida dubu ata hiei-da pemidio ruu iha tui dabu-ka. ");
INSERT INTO kiw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pariseiaiꞌoi-re, kamia bubu imatomudio uubi aamiꞌai-reiro, rii rio-ka Iesu memiho raa ataato ma ememeeꞌaumo, ka Iesu ma emaaꞌoumo. Ka rii-ro taitai hiꞌa-ha paarodiomo, ruu-ro Sabati-da meree ata odomoiai amaꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Irai Iesu umoo iiꞌi-ka, rii raꞌu iraromoumo, ka tu dabu rautu dubui eito aaꞌoi-ka, “Eibua turiaha uubi hoho reꞌei-da otooꞌa.” Ruu eibuai-ka hiei-da aiha pitooꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ka Iesu-ro rii-do aaꞌoi-ka, “Moo-ro riꞌo ai-riatohetaii, rimo bubui-ro raꞌu rimapui Sabati-da ma raꞌaimo-rai, mea ododiai-ra ee, memiho ododiai-ra, oroiꞌioi omoabai-ra ee, omodoboai-ra?” ");
INSERT INTO kiw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ruu-ro rii turiaha iiarodio, ida paaꞌo, aaꞌo dubui eito, “Itutuai roo tui.” Ruu-ro aiha pododiai, ka ruu tui meaha iiꞌi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Irai rii pupuoi-to udo-ro, imidai-ka. Ka rii himia tuiai-da oromoaduꞌuti omahoroumoi-ka, rii-ro Iesu raꞌu omododiai maꞌai duumo. ");
INSERT INTO kiw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ata himioi, Iesu ioroi-ka roꞌoai ohui eito, irudemei. Ka duo tutuui hiei-da pirudeme Iehomai-do. ");
INSERT INTO kiw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Himioi ioahoi-da, ruu iimatomudio mereei iahoꞌootiai-ka, ruui-do. Ida piapui, tuero (12) uubi beha, ruu-ro pairai ai-pimaꞌai, iiapui made himoꞌa uubi. ");
INSERT INTO kiw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Rii pairai-ka, Simora (Iesu-ro ruu pairai ai-pahoꞌoo Petero) ka ruu riai Eridurui-re, Iemisi-re, Ioarei-re, Piripi-re, Bataromi-re, ");
INSERT INTO kiw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataioi-re, Tomasi-re, ka Iemisi (Arepeosi meree-ohioi-ka), Simora (ruu Serote paꞌai dubu-ka), ");
INSERT INTO kiw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iudasi (Iemisi meree-ohioi-ka), Iudasi Isikariota, Iesu oaꞌuei aꞌai mereei-ka. ");
INSERT INTO kiw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesu roꞌoai hoꞌui-da tuero (12) himoꞌa uubi rautu iooruoi-da, hamei-da otooꞌai-ka, ruu iimatomudio uubi hiiroi aaꞌo reꞌei-daka. Turiaha mati-mati-da iooꞌumo uubi geemai Iudea-toire, Ierusarema-toire, kamia tuia geegai barai iiꞌaa goꞌoto paipai, Taiai-re, Sidoroi-rei goroi-da. ");
INSERT INTO kiw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rii ai-pooꞌumo ruu oroomidioi, kamia gimoi-da rii ma iidomoi, memiho urioi-ro iimaꞌobeumo uubi rautu ai-pooꞌumo, ka aiha piidomo. ");
INSERT INTO kiw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Turiaha uubi-ro emahibai-ka ruu ahimodi, mabu erarai ruuato ai-pohuꞌo, ka rii turiaha aiha pidomo. ");
INSERT INTO kiw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu-ro ruu iimatomudio mereei iaꞌaa, ida paaꞌo, “Geꞌii-ka riꞌo boiꞌo-ra, raara tiatoi, Iehoma pai emidio erarai riꞌoido-ka! ");
INSERT INTO kiw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Geꞌii-ka riꞌo doꞌou rioi goroꞌoro-ra, riꞌo kaupaꞌe iiꞌi aꞌai kaumo! Geꞌii-ka riꞌo doꞌou idebi-ra, riꞌo mari aꞌai aꞌai kaumo! ");
INSERT INTO kiw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Geꞌii-ka riꞌo uubi-ro rio-tiato amimaꞌai duumo, aia miraibo duumo, ee amimehipo duumo, kamia aia maaꞌo duumo, riꞌo turiaha memiho uubi-ka, mabu Uubihaubi mereei obodoumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Riꞌo ibai-ha amimodoboa duumo, riꞌo geꞌii geema hiꞌa, hete rautu ma oroamauti, mabu geema hiꞌa taꞌii ai-oroomotii, aromoi-da. Rii himia rariamiꞌoi aibo-ka. Rii rariamiꞌoi-ro, aatu memiho raarai tauo piꞌatidioumo, Iehoma himogabo uubi eito. ");
INSERT INTO kiw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Memiho hiꞌa-ro ooꞌai aꞌai, riꞌo doꞌou raarai hiiro-hiiro uubi eito, mabu riꞌo pauo tiato oroiꞌioi-da tauo pemidioumo! ");
INSERT INTO kiw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Memiho hiꞌa-ro ooꞌai aꞌai, riꞌo doꞌou kaupaꞌe uubi eito, riꞌo rioi goroꞌoro aꞌai aꞌai kaumo! Memiho hiꞌa-ro ooꞌai aꞌai riꞌo boiꞌo-ro mari maꞌai duumo doꞌou, riꞌo giiꞌepu idebi aꞌai aꞌai kaumo! ");
INSERT INTO kiw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Memiho hiꞌa-ro ooꞌai aꞌai, riꞌo turiaha uubi-ro, geꞌii amimaꞌai duumo, mabu rii rariamiꞌoi-ro, gaaꞌu emerai raara piꞌatidioumo ierematuhutidioumo himogabo uubi eito. ");
INSERT INTO kiw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Irai riꞌo boiꞌo-ro roromidio duumo moo, riꞌo ai-riduuꞌai, riꞌoi-do boho uubi giiꞌepu-ha ma imaꞌai, meai-ha ma imododiai, riꞌoi-do udo aꞌai uubi-ri, ");
INSERT INTO kiw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","riꞌo boru made imaꞌai uubi-ri, Aiai Iehoma ma atohetai, ruu meai ma imaꞌai, kamia riꞌo memiho imododiai uubi eito, aiha ma irudemeai. ");
INSERT INTO kiw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Meree ata-ro, roo mapeho tamai aia maatotai, hapuo atai rautu ma ememeheꞌeai, maatotai-ka. Meree ata-ro, riꞌo gugaꞌo hipurai aia mimoaidai dubu-urioi rautu ma emaꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma imaꞌati, riꞌoi-do aamiꞌa raara-ri oroaro uubi eito, meree ata-ro, riꞌo ata raa aia mimaidai, oomaahoi bia. ");
INSERT INTO kiw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Riꞌo rioi aamiꞌai-ro, riꞌoi-do ma ododiaimo emerai, riꞌo haa-ro ma ododiai rii-do. ");
INSERT INTO kiw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Riꞌo giiꞌepu imaꞌai uubi behai giiꞌepu amimaꞌai duumo, ka raꞌu-ri eidai maꞌai duumo, riꞌo-ro mea taꞌii? Abia! Memiho uubi rautu, rii giiꞌepu imaꞌatidio uubi, giiꞌepu imaꞌatidio kaumo! ");
INSERT INTO kiw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kamia riꞌo meai, riꞌoi-do mea ododiai uubi behai eito amododiai duumo, raꞌu-ri eidai maꞌai duumo riꞌo-ro mea taꞌii? Abia! Memiho uubi rautu imiꞌatidio duumo aaꞌo emerai! ");
INSERT INTO kiw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ka riꞌo-ro aia mimaꞌai duumo, riꞌo tui imoaimai-ri iraromo uubi behai eito, raꞌu-ri eidai maꞌai duumo mea taꞌii? Abia! Memiho uubi-ro, aamiꞌa memiho uubi eito, imiꞌatidio duumo, gaaꞌu emerai, rii-ro imaꞌai modoboi-ha ma imoaimaimoi-ri! ");
INSERT INTO kiw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Abiarie! Riꞌoi-do boho uubi, riꞌo-ro giiꞌepu-ha ma imaꞌai, meai-ha ma imododiai, ka ma imaꞌai, irai omoaimai-ri, oroomotii bia. Riꞌo ibai amododiai duumo, taꞌii geema-ha ooꞌai aꞌai, ka riꞌo mia ohu hiꞌai Paidubui meree iiꞌi aꞌai kaumo. Mabu ruu giiꞌepu hiꞌa-ka, memiho uubi-re, kamia ruui-do, keito made aaꞌo tiato uubi-rei eito. ");
INSERT INTO kiw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ka riꞌo abeai Iehoma aibo, uubi giiꞌepu ma imaꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Uubi aamiꞌai aumai imaapoi bia, ka Iehoma-ro, riꞌo aumai imaapoi aꞌai bia. Aamiꞌai iahoꞌooi bia, rii aꞌai memihoi taꞌii ma aꞌaimoi-ri, ka Iehoma-ro riꞌo aꞌai memihoi taꞌii ma aꞌaimoi-ri, iahoꞌooi aꞌai bia. Aamiꞌai-ro riꞌoi-do aꞌai memihoi ma imapihiti, ka Iehoma-ro riꞌo memihoi imapihiti aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aamiꞌai eito ma imaꞌai, ka Iehoma-ro, riꞌoi-do imaꞌai aꞌai, ka riꞌo imaꞌai aꞌai huru haato modoboi-da, ka geema hiꞌa modoboi oruodii aꞌai riꞌo tui eito, riꞌo tui-da iꞌapudioi modobo tiatoi. Aamiꞌai eito riꞌo-ro imaꞌati emerai, Iehoma-ro riꞌoi-do imaꞌati aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ka Iesu-ro ara obeegiri imoaduꞌoi-ka, “Idomai tiato dubu atai-ro, idomai tiato dubu atai, omodai modobo bia, ruu-ro aia mododiai, riiti orohuꞌumoi aꞌai kaido boboi-da. ");
INSERT INTO kiw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Umooi ooho uubi-ro, rii imatomudio dubui umooi oohoodii aꞌai bia, irai turiaha uubi, ruu ematomudioi aia moropoiꞌo, ruu ematomudio dubui aibo iiꞌi aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Roo riaraamui idomai ooꞌaa ruꞌa horoi-ha, raꞌu-ri memaroꞌo, kamia roo himia idomai ooꞌaa ruꞌa ipi, ereaꞌaa bia-ra? ");
INSERT INTO kiw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Roo riaraamui eito aaꞌoi modobo bia, ‘Riaraamu-o, roo idomai ooꞌa ruꞌa horoi, ma arahuurai,’ kamia roo himia idomai ooꞌa ruꞌa ipi, eereaꞌaa bia-ra? Riꞌo daea uubi-ka! Epuui roo himia idomai ooꞌaa ruꞌa ipi-ha ma araahurai, ka roo-ro hauꞌi-ha iaꞌai aꞌai, roo riaraamui idomai ooꞌa ruꞌa horoi ma ahuurai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Mea hiꞌa ruꞌai-ro memiho hura imamirai aꞌai bia, kamia memiho ruꞌai-ro, mea hura imamirai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Turiaha ruꞌai, ruu himia imamirai hurai haato oibomai-ka, riꞌo-ro topo hiꞌa ruꞌa hurai, eepeeapeeai-da, idoꞌoi aꞌai bia, kamia mire hurai, iimuui-da idoꞌoi aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mea mereei-ro, imooꞌui aꞌai mea raarai, ruu kaukai-da irahoꞌoo mea raarai-da. Kamia memiho mereei-ro, imooꞌui aꞌai memiho raarai, ruu kaukai-da irahoꞌoo memiho raarai-da. Puꞌoi-da, oroaduꞌoi-ka, kaukai-da raꞌu hiiro-ro miiꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Riꞌo-ro moo raꞌu-ri rahoꞌoo duumo, ‘Paidubu-o, Paidubu-o’, irai mia riꞌo-ro, idodiaimo bia, moo-ro riꞌo imoaduꞌuti raarai. ");
INSERT INTO kiw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Meree ata mooi-do aia mooꞌu, ida aamoromidio moo madei, kaida aia midodiai moo aaꞌo raarai, moo-ro riꞌo imoaꞌemiai raꞌai, ruu raꞌaibou mereei-ra. ");
INSERT INTO kiw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ruu dubu ata aibo-ka, moto pididi, aboi boboi goro hiꞌa piobuti, motoi aahuu ma otii-ri. Oomoi borei iooꞌui-da, motoi amaꞌadeai-ka, irai aaꞌo motoi biai poohiai, oomuo bia, mabu motoi aahuu hiꞌa-ha pididi. ");
INSERT INTO kiw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kamia moo madei imoroomidio, irai moo aaꞌo raarai idodiai bia-ra, ruu dubu ata aibo-ka, motoi ididi, abo tiato, hepu behai-da. Borei-ro aaꞌo motoi iohiai-da, aiha piiraahiai, ka ruu iiraahiai-da, memiho hiꞌa ha piiꞌi!” ");
INSERT INTO kiw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu ara raarai turiaha oroaduꞌuti ioropoiꞌoi-da uubi eito, ruu odai-ka Kaperaraumai-to. ");
INSERT INTO kiw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hiei-da, Roma heamoi epuuhoro dubui-ro, rio pemaꞌatidio, ruu himia moto himoꞌa meree ata, gimo hiꞌa-ka, iihiai toto-ha paꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Heamoi epuuhoro dubui-ro, Iesu pai ioromai-da, Iuda epuuhoro uubi aamiꞌa itiodoai-ka, Iesu ma atohetaimoi-ri, ma ooꞌui-ri ruu himoꞌa mereei ma omodomoiai. ");
INSERT INTO kiw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Rii iooꞌumoi-da Iesui-do iha hiꞌa-ha oroarotiai-ka, “Mea hiꞌa-ka, roo-ro ruu ma omoabai. ");
INSERT INTO kiw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ruu-ro giiꞌepu imaꞌai rimo uubi, ka ruu himia-ha pididi idabu motoi, rimo-ri.” ");
INSERT INTO kiw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ka Iesu odai-ka, rii rautu. Ruu auꞌo bia motoi-da, heamo epuuhoro dubui-ro riaraamui itiodoai-ka, ruu ma oduuꞌaimoi-ri araibau, “Paidubu-o roo pauo iraromoꞌa, moo mea bia, roo ma odoro moo motoi rioi eito. ");
INSERT INTO kiw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aaꞌo rauri, moo himia iraromoi-da, moo modobo biai reereeaꞌa maaka, ma rooꞌu rooi-do. Irai made beha-ha aaꞌo, ka moo moto himoꞌa mereei ma oodomoiai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Moo roo aibo dubu ata-ka, epuuhoro uubi aamiꞌa goro ato-ka. Heamo uubi moo goroi-daka. Moo-ro arahiou aia roduuꞌai, ‘Odau!’ Ruu odai aꞌai. Kamia aure hiei aia roduuꞌai, ‘Ooꞌu,’ ooꞌui aꞌai. Moo himoꞌa mereei aia roduuꞌai ‘Ara raai ododiai,’ ruu-ro ododiai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ara madei Iesu-ro ioroomai-da urio podaudio. Ka ruu iobodoumo uubi iimeteai-da aaꞌo-ka, “Riꞌo moo-ro ai-riduuꞌai, Aiai eito pupuo iraromo meree ata, moo-ro, emeeꞌa bia araibau Isaraꞌera goroi-da.” ");
INSERT INTO kiw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Madei iomodaumo uubi ireheꞌeai-ka, iiraimai epuuhoro dubui motoi eito. Kaida pemeeꞌaumo ruu himoꞌa mereei mea tauo-ha piiꞌi. ");
INSERT INTO kiw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tutuu bia Iesu odai-ka, Raira goꞌotoi eito, ruu iimatomudio mereei rautu, geema uubi-ro pobodoumo. ");
INSERT INTO kiw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ruu goꞌotoi eito iidouti gaboi hohoi-da iereedeeꞌai-da, pimeeꞌa rituo mereei tuupi rautu, iooꞌumo uubi. Iihiai mereei, himu oobo ata, meree-ohio gaaꞌu-ka, ka rituoi rautu iooꞌumo uubi, maamu himui rautu gaaꞌu-ha piihuuꞌoumo. ");
INSERT INTO kiw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Paidubui-ro ruu iemeeꞌai-da, iha giiꞌepui pemaꞌai, ka ruu-ro aaꞌoi-ka, maamu himui eito, “Idebi aꞌaiꞌa.” ");
INSERT INTO kiw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ka ruu imadaꞌui-da, aihimodi-ka rituo mereei iorobu tautapei. Ka iomodaumo dububaiꞌoi aiꞌoi mitooꞌa duumo. Iesu-ro aaꞌoi-ka, “Meree dodobai-o, roo moo-ro ai-roduuꞌai, eibua.” ");
INSERT INTO kiw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iihiai mereei eibuai-ka, aiha pemiꞌei, ka ruu oroaduꞌuti oomahoroi-ka. Kiauka Iesu-ro, ruu aiha pemaꞌai maamui eito. ");
INSERT INTO kiw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Rii turiaha toei-ro imidai-da, Aiai aiha pemarahueumo, “Geema hiꞌa himogabo dubu tauo oobodi maaka, rimo tuiai-da.” Rii-ro aaꞌoumoi-ka, “Aiai tauo ooꞌu maaka, ruu uubi oroiꞌioi-da ma ideꞌai-ri.” ");
INSERT INTO kiw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iesu pai aburai-ka, turiaha Iudea hepui, aamiꞌa mati-mati rautu. ");
INSERT INTO kiw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioare Babatiso iomoaduꞌoumoi-da, ruu himia iimatomudio mereei-ro, Iesu iidodiai raarai, ka Ioare-ro iahoꞌootiai-ka retoꞌa (2) mereeti, iduuꞌai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Odaido, Paidubui atohetai, “Roo Aiai Iehoma-ro ooꞌu made ioaduꞌo mereei-ra, ee, dubu ata aromoti duumo?” ");
INSERT INTO kiw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Riiti iooꞌuidoi-da Iesui-do aaꞌoidoi-ka, “Uubi obo imaaheemo dubui, Ioare-ro, riitiodoai mama, roo ma ratohetaidoi-ri, ‘Roo ruu-ro ooꞌu made ioaduꞌo mereei-ra, ee, dubu ata aromotii duumo?’” ");
INSERT INTO kiw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aaꞌo himioi haato, Iesu-ro hiiro gimo uubi pidomo, tuupi goroi gimoi-da, memiho urioi iimobodidio, ka hiiro idomai duꞌi uubi, iaꞌai iimaꞌati. ");
INSERT INTO kiw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iesu-ro Ioare iimatomudio mereeti iduuꞌai-ka, “Iraimaido, ka ita omoaduoido Ioare, riꞌoiti imiaꞌaido raarai, kamia imiromidioido madei, idomai duꞌi, ai-iaꞌaa kaumo, oto memihoi ai-imadaꞌui kaumo, tamai mobibi gimo rautui, mea imiiꞌi duumo, hepatoi mumuroi, ai-iromidio kaumo, rituoi imireibuio duumo, oroiꞌioi eito, ka pai meai, irimoaduꞌuti, raara tiato uubi eito. ");
INSERT INTO kiw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Moo eaꞌa uubi-ro, rii iraromoi mooato irahio bia-ra, rii geꞌii-ha ma aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioare iimatomudio mereeti iodaido didimoi-da, Iesu-ro omahoroi-ka Ioare oaduꞌoi uubi geemai eito, “Riꞌo aaꞌo himioi iodaumoi-da Ioarei-do, opuhe mati-da, riꞌo-ro raꞌu eaꞌai iraromoumo? Ioare tataꞌoi paha gaaꞌu aibo, ruurui-ro eꞌimotatidioi-da, ma emeeꞌaumoi-ri agiraromoumo? Aabiarie. ");
INSERT INTO kiw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Riꞌo auꞌoi-da raꞌu eaꞌai odaumo? Dubu ata-ra, muari hiꞌa hipura rautu? Aaꞌo emerai hipura meameai, kamia mea oroiꞌioi-da emidio uubi imeꞌai aꞌai, ohu hiꞌa pai motoi-da! ");
INSERT INTO kiw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Moo romoaduꞌoumo, riꞌo raꞌu eaꞌai odaumo auꞌoi-da? Himogabo dubu-ra? Ie, iaha-ka, irai riꞌo-ro geega hiꞌai eaꞌa duumo, himogabo dubui-ro omiorai. ");
INSERT INTO kiw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ara Ioare ruu-ka, Iehoma made bukai-ro ai-aaꞌo: ‘Moo-ro otiodoai raꞌai himoꞌa mereei, roo epuui-da, roo gaboi ma omododia-ri.’” ");
INSERT INTO kiw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iesu-ro odabuai-ka, “Riꞌo moo-ro ai-riduuꞌai, Ioare geega-ka, ruu aibo ata, emidio bia epuui-to, kamia doꞌou, ara hepui-da. Irai keehibuo hiꞌai boꞌu-rie, Iehoma pai emidio erarai-da, ruu Ioare-ro omiorai-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Turiaha uubi-ro ruu ai-poroomaimo, rii-re kamia taketi imoamee uubi-reiro poromaimo, ka rii ai-poroahuomaimo, rii iraromoi Iehoma gaboi meaha-ka mabu rii Ioare-ro oboi-da ai-pimaaheemo. ");
INSERT INTO kiw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Irai Pariseia uubi-re kamia bubui imatomudio uubi-reiro Iehoma rioi ai-paraiboumo, rii himia rioi-ri, kaida rii rio tiato paꞌaimo, Ioare-ro, oboi-da imaaheemoi. ");
INSERT INTO kiw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iesu imatomudioi aiha podau, “Ka moo-ro doꞌou uubi raꞌuato idoboai raꞌai? Rii raꞌui aibo-ra? ");
INSERT INTO kiw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Rii hauꞌi tuiai-da emidio meree keeke aibo-ka. Aamiꞌai-ro aamiꞌai iduuꞌai-ka, ‘Rimo geꞌii raahoaꞌei iabotuti-da, riꞌo hete omaumo bia! Rimo idebi raahoaꞌei iabotuti-da, riꞌo idebi aꞌaimo bia!’ ");
INSERT INTO kiw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uubi obo imaaheemo dubui Ioare tauo pooꞌu, ruu imaꞌui iemidio kamia mire obo idio bia. Kaida riꞌo-ro paaꞌoumo, ‘Ruu memiho urio rautu-ka!’ ");
INSERT INTO kiw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Uubihaubi mereei tauo pooꞌu, ka ruu iiho kamia idio, ka riꞌo-ro paaꞌoumo, ‘Ara dubui ma eaꞌaumo, iiho-toto hiꞌa dubu-ka, kamia mire obo idio hiꞌa meree-ka. Ruu taketi imoamee uubi-re kamia memiho uubi-rei rautu, riaraamu-ka.’ ");
INSERT INTO kiw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Irai Iehoma umooi ieidaimo uubi-ro, ihahai imoaꞌeemiai aꞌai kaumo, rii oroiꞌio emerai-da.” ");
INSERT INTO kiw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pariseia dubui Simora-ro Iesu amaꞌuei-ka, ruu motoi-da du ma iihoumoi-ri. Ka Iesu odai-ka ruu motoi eito. Ka aiha pemiꞌeitutimo, iihoi. ");
INSERT INTO kiw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aaꞌo goꞌotoi-da memiho oroiꞌio oobo ata, ai-pemidio. Ruu-ro ai-poroomai Iesu Pariseia dubui motoi-da dui iihoi, kiauka ruu-ro ribo mea herei, gaigarua keehi rautu, ruu oomodai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iesu taitai haato potoꞌa otoi reꞌei-da, idebi imaꞌai-die idebi huoi-da otooti imimoruꞌo. Kiauka ruu epuui muhoi-da otoi iaditi-ka, otooti ihomeai-ka, ka ribo mea herei-da otoi imadouti-ka. ");
INSERT INTO kiw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ida Iesu ioꞌopai dubui-ro himia poromoaduꞌo, “Ara dubui ihaha Iehoma himogabo dubui ata-ro ooꞌaato, ruu umoo mei ooꞌa-ka ara ruuato ateai ooboi memiho oroiꞌio oobo-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kiauka Iesu-ro aaꞌoi-ka, “Simora, moo made keehi ata ararie rooi-do.” Simora-ro omoaimai-ka, “Ie, imatomudio dubu-o, romoaduꞌo.” ");
INSERT INTO kiw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu-ro aaꞌoi-ka, “Retoꞌa dubuoti, dubu atai-do abitore mori-ri paaꞌoido, atai K500, atai K50. ");
INSERT INTO kiw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aaꞌo dubuoti-ro, mori omoaimai modobo tiatoi-ri, abitorei ai-pimahurai. Aaꞌo dubu oti-da, rii abitorei imahurai dubui, ihaha boꞌu-ro rio emaꞌai maꞌai?” ");
INSERT INTO kiw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simora-ro omoaimai-ka, “Moo iraromoi-da abitorei geema-ha ioahurai mereei-ro rio emaꞌai aꞌai.” Iesu-ro aaꞌoi-ka, “Roo iaha aaꞌo.” ");
INSERT INTO kiw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ruu-ro aaꞌo ooboi eemeteai-ka, ida paaꞌo Simorai-do, “Ara ooboi roo-ro ameaꞌa? Moo roo motoi irodoroi-da, moo otoi imoruꞌo obo emaꞌai bia. Irai ruu idebi huoi-da rimoruꞌo maaka, ka ruu epuui muhoi-da riaditi toatoa-ha. ");
INSERT INTO kiw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Moo, roo motoi irodoroi-da, roo-ro moo ohomeai bia, irai ara ooboi-ro, moo ototi ihomei emahurai bia, moo irooꞌui-da imomahoroi-ka, imooꞌu doꞌou. ");
INSERT INTO kiw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Roo-ro moo epuui here ohiꞌauti bia. Irai ruu-ro moo ototi riboi mea hiꞌa herei-da rihiꞌauti. ");
INSERT INTO kiw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Moo-ro, roo ai-roduuꞌai, ara ooboi, hiiro memiho tauo remapihiti maaka. Aaꞌo rauri, ruu geema giiꞌepu oahuꞌomai, mooi-do. Irai boꞌu remapihiti keehibuo memiho, ruu keehibuo giiꞌepu oahuꞌomai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kiauka, Iesu-ro aaꞌo ooboi oduuꞌai-ka, “Roo memihoi tauo remapihiti maaka.” ");
INSERT INTO kiw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ruu rautu gaaꞌu-ha iihoumo uubi himia-ro aratohetai-ka, “Ara boꞌu-rie, uubi memihoi ma imapihiti?” ");
INSERT INTO kiw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ida Iesu-ro aaꞌo ooboi oduuꞌai-ka, “Roo himia pupuo iraromoi-ro, roo mea tauo ododiai maaka. Miroi-da odau.” ");
INSERT INTO kiw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aamiꞌa himioi didimoi-da, Iesu odai-ka goꞌoto goꞌotoi, pai meai madei Aiai Iehoma pai emidio erarai, imoaduꞌuti-ha. Ruu iobodoumo tuero (12) mereei rautu, ");
INSERT INTO kiw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ka aamiꞌa upibaiꞌoi, ruu-ro memiho urioi imobodidio, kamia gimoi-da idomoiatidioi rautu gaaꞌu-ha. Maria, paira atai Magadara, ruu reꞌei-da semeri (7) memiho urio pomobodidio, ");
INSERT INTO kiw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ioara, Heroda raarai iemeaꞌa dubui Kuda, ooboi-ka, Tusara, aamiꞌa upibaiꞌoi rautu ai-poromoabaimo, rii himia raarai-da, Iesu iimatomudio mereei ma imoabaimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Goꞌoto goꞌotoi-da, iorohoumo uubi aiha pororuꞌudio, ka turiaha ioodabuaimoi-da, Iesu-ro ara obeegiri imoaduꞌoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Dubu ata, raa mate hurai pipeduo, aamiꞌai oto gaboi-da pirahioumo, ka uubi-ro iatuꞌuti-ka, momoꞌoi iooꞌumoi-da aiha piihoumo. ");
INSERT INTO kiw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aamiꞌai roꞌoa-roꞌoa hepui-da pirahioumo, iiꞌimo irai, pahai ai-pirademeumo, obo tiatoi-ri, ka aiha poroihiimo. ");
INSERT INTO kiw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aamiꞌai oroꞌoro tamitami tuiai-da pirahioumo, iiꞌimo irai tamitami-ro ai-piaatioumo, ka aiha poroihimo. ");
INSERT INTO kiw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aamiꞌa hurai mea hepui-da pirahioumo, iiꞌimoi-da mea hiꞌa, iha paꞌaimo, patu gaaꞌu-gaaꞌui-da ai-pimeꞌaumo haridere (100) gaaꞌu aibo.” Aaꞌo madei iaaꞌo didimoi, Iesu-ro geema madei-to aaꞌoi-ka, “Roo iroomidio hepato rautu-ra, ka oroomidio.” ");
INSERT INTO kiw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ruu himia iimatomudio uubi-ro aiha patohetaimo, aaꞌoi-ka araibau, “Ara obeegiri raꞌu moroaduꞌo?” ");
INSERT INTO kiw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ka ruu-ro rii madei imoaimai-ka, “Piro-piro madei, Iehoma pai emidio erarai, tauo imaꞌai maaka, riꞌoi-do. Irai aamiꞌai eito, obeegiri-to rimoaduꞌuti, mabu rii-ro meaꞌa duumo, irai eaꞌai aꞌai bia, moromidio duumo, irai umoo iiꞌi aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ararie obeegiri oaꞌeemiai, raa matei Iehoma madei-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Raa matei oroaꞌoia oto gaboi-da irahioumoi, araibau-ka, madei imoromidio duumo uubi-ro, irai Satari ooꞌui-ka madei omodadeai, rii kaukai-da, rii-ro madei ihahai eidai mooꞌai-ri, kamia rii oroiꞌioi eidai toe. ");
INSERT INTO kiw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Raa matei roꞌoa-roꞌoa hepui-da irahioumoi araibau-ka: madei imoromidio duumo uubi-ro, geꞌii rautu, irai, madei kaukai goroi eito hipi odai bia. Rii-ro keehibuo iraromoi-ka, irai erematuhuti ooꞌui-da, rii irahioi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Oroꞌoro buꞌi-da iiraahioumoi, madei oromidioumoi-ka. Irai ipi-da, araibau raara-ro imomurudioi-ka: oroiꞌioi iraromo pauo, iiho-toto oroiꞌio, kamia hepui geꞌii. Ka rii aahuu iiꞌi modobo bia, mabu rii ai-piaatioumo oroꞌoro tami-ro aaꞌo rauri rii kaurau orobiꞌo ruꞌa hura aibo-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Raa mate hurai, mea hepui-da irahioumoi, araibau aaꞌo, madei rii-ro imoromidio duumo, ka mea eremaabei kaukai-da, aahuu ioohidioi-ka, raa matei iiꞌi-da, meamea hura-ro ma iohui emerai. ");
INSERT INTO kiw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Meree ata-ro, ramepai adiai-da ipuai-da atimai aꞌai bia, kamia edeꞌai aꞌai bia totoi goroi-da. Abia, ka aiha edeꞌa, ramepai himia totoi hoꞌui-da. Ka motoi eito iido uubi-ro, ramepai hehei eaꞌai aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Piro-piro raꞌu-ro mopiꞌomatidio, hehei-ro obodi aꞌai hauꞌi eito. Ka raꞌu momurudio, ruu memeeꞌa duumo, kamia momooꞌu duumo hehei eito. ");
INSERT INTO kiw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Roo-ro ara madei mea hiꞌa-ha ma oromidioi, mabu roo reꞌei-da raꞌu-ro mooꞌa, ruu hoꞌui-da, roo emaaꞌoai aꞌai. Kamia boꞌu meree reꞌe ato-ra tuahai, ruu reꞌei-da ooꞌa keehibuoi rautu turiaha omoahurai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu riamiꞌoi maamui rautu ai-podaumo ruui-do, ruu rautu ma odabuaimoi-ri, irai modobo bia, mabu uubi hiiro-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ata meree-ro aaꞌoi-ka Iesui-do, “Roo riamiꞌoi maamui rautu, raamomoti duumo kekai-da, rii rio-ka, roo ma emeeꞌaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Rii turiahai-do Iesu-ro aaꞌoi-ka, “Aiai Iehoma madei, boꞌu-ro moromidio, kamia, ruu rioi boꞌu-ro mododiai, moo maamu-ra riamiꞌo-raika.” ");
INSERT INTO kiw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ata himioi, Iesu oroi-ka peei-da, ruu himia iimatomudio uubi iduuꞌai-ka, “Ma raabumo damoi hapuoi eito.” Ka aiha pahiꞌiaimo aabui. ");
INSERT INTO kiw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iaabumoi-da, Iesu uro utaꞌai-ka. Tutuu bia tuomoi omumuai-ka tuiai-da, oboi araatei omahoroi-ka peei-da. Kiauka, rii oroihi modobo haato pideꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ruu iimatomudio uubi odai-ka Iesu oitorai, ida paaꞌoumo, “Paidubu-o, Paidubu-o! Rimo aiha oroihi raꞌai kaumo!” Iesu eibuai-ka, tuomo-ra aubo-rai erara made imaꞌai-ka, kiauka tuomo-ra aubo-rai aadohuti-ka, piroha iiꞌi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kiauka ruu-ro rii turiaha iduuꞌai-ka, “Heiꞌe-rie, riꞌo pupuo iraromoi?” Ka rii turiaha urio podaudioumo, ka toei hohoi-ha peremeeꞌaumo, ka hiei-da rii himia aratohei-ka, “Ara dubui boꞌu-rie? Tuomo-ra aubo-rairo, ruu madei-ha oroomai kaumo!” ");
INSERT INTO kiw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iesu iimatomudio uubi rautu iaabumoi-da, arioi-ka, Gerasaato, Garereia damoi hapuoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu iaramotoi-da memiho urio rautu dubui-ro emeeꞌai-ka, ruu aaꞌo mati-da dubu-ka. Tutuu hiꞌa poroaꞌoiadio hipura tiato-ha, kamia motoi-da emidioi modobo bia, oroihi uubi iruꞌumodioumo roꞌoa uuꞌui-da pemidiodio. ");
INSERT INTO kiw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ruu-ro Iesu iemeeꞌai-da, made geema aapoꞌiai-ka, Iesu otoi reꞌei-da irahiai-ka, ida paaꞌo geega madei-to, “Iesu, ohu hiꞌai Aiai meree! Roo raꞌu rio maꞌai mooato? Moo ai-roroaro rooi-do, moo ata riibo emaꞌaiꞌa!” ");
INSERT INTO kiw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ruu aaꞌo emerau paaꞌo, mabu Iesu-ro memiho urioi tauo piduuꞌai ruuato ma odadeaimoi-ri. Hiiro himio-ka, ruu memiho urioi-ro oaꞌoiai, uubi-ro emaꞌoidioi-ka, oto-ra tu-rai otohiti-ka aahuu hiꞌa imi-da. Irai iahiuti-ka, ka memiho urioi-ro omodai-ka opuhe mati eito. ");
INSERT INTO kiw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu-ro atohetai-ka ruu, “Roo pairai boꞌu-rie?” Ruu-ro omoaimai-ka, “Moo pairai-ka, ‘Hiiro’,” mabu hiiro memiho urio-ro pemidioumo ruuato. ");
INSERT INTO kiw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Memiho urioi-ro, Iesui-do oroaroi-ka, rii giimui-to iitiodoaiꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Aaꞌo reꞌeu-da boomo paꞌa geemai goꞌu paꞌaimo, roꞌoai tamai-da. Ka memiho urioi-ro oroarotiaimoi-ka, Iesui-ro, rii erara ma imaꞌai boomo paꞌai haito ma odaumoi-ri, kiauka Iesu-ro madei imaꞌai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aaꞌo dubui-da, rii ihuꞌodidioumoi-da, boomoi haato pimamiaꞌaiimo, ka turiaha aaꞌo boomo paꞌai, dodoroi iromodoimoi-da, aiha paaꞌumutimo. ");
INSERT INTO kiw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Boomoi dabi uubi-ro ieaꞌaumoi-da, rii hioi-to podaumo goꞌotoi-re kamia geemaꞌeema paꞌeai-rei, iemidioumo uubi imoaduꞌuti. ");
INSERT INTO kiw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Uubi odai-ka, ioobodi raai emeeꞌai. Rii iooꞌumoi-da Iesu emeeꞌai-ka, memiho urioi-ro iemeheaimo dubui, ruu oto reꞌei-da pemidio hipurai rautu, kamia mea hiꞌa iraromo moꞌui rautu. Ka rii toe peereaꞌaumo. ");
INSERT INTO kiw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Idomai-da ieaꞌaumo uubi-ro pimoaduꞌutimo, aamiꞌai, aaꞌo dubui ioodomoia emerai. ");
INSERT INTO kiw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ka turiaha Gerasa hepu geemai uubi-ro Iesu oarotiai-ka, ruu-ro rii ma imeheai-ri. Mabu rii toe hiꞌa paꞌaimo. Kiauka Iesu peei-da aiha poroo imaahiꞌiai. ");
INSERT INTO kiw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Memiho urioi-ro, iemeheaimo dubui-ro Iesu atohetai-ka, “Moo ai-rooꞌu, roo rautu.” Irai Iesu-ro aiha potiodoai, oduuꞌai-ka, ");
INSERT INTO kiw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Araimai, goꞌotoi eito, imoaduꞌuti, Iehoma-ro, rooi-do imododiai raai.” Ka ruu araimai-ka goꞌotoi, uubi imoaduꞌuti, Iesu-ro ruu iomododiai emerai. ");
INSERT INTO kiw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka Iesu iaraimai-da damoi hapuoi eito, uubi-ro geꞌii rautu poꞌopaimo, mabu rii ruu-ha pomotiimo. ");
INSERT INTO kiw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ida pooꞌu idabu motoi epuuhoro dubui Iairusi, Iesu emaabei-ri ihimai-ka, Iesu oto reꞌei-da, Iesui-do pupuoi-to oroaroi-ka ma odaidoi-ri, ruu motoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mabu ruu meree behei gaaꞌubuo hiꞌa-ka, burioi tuero-ka (12), iihiai tooto paꞌai. Iesu hiei eito iodai-da, uubi tuia-tuiai-ha pimadaꞌui. ");
INSERT INTO kiw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Rii tuiai-da tuero (12) burioi-to, ora gimo piꞌatidio oobou rautu-ka. Ruu turiaha iiꞌapudioi, tauo-ha pipoiꞌo, ruu ma odomoiamoi-ri uubi imaꞌati-da, irai ruu meree ata-ro ma odomoiai modobo bia. ");
INSERT INTO kiw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ka ruu iooꞌui-da, Iesu rautu iodaumo uubi iiꞌi-da, aiha porooꞌopai. Ka Iesu hipurai keehibuo iaihimodi-da, ruu iꞌatidio ora gimoi-ro aiha pemeheai, gaaꞌu hiꞌa-ha. ");
INSERT INTO kiw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu-ro aaꞌoi-ka, “O, moo boꞌu-ro rahimodi?” Rii turiaha ai-paratuhutimo. Petero-ro aaꞌoi-ka, “Epuudubu-o, roo rautu rimo hiiro uubi-ro rimadaꞌui kaumo, uubi roo rautu tamai imaraihimo duumo.” ");
INSERT INTO kiw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ida Iesu-ro aaꞌoi-ka, “Ie, moo meree ata-ro raihimodi, moo himia-ro umoo tauo riiꞌi maaka, moo erarai aamiꞌai-ro, emeheai-da.” ");
INSERT INTO kiw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aaꞌo ooboi umoo iiꞌi-ka, ruu tauo poibomai. Ka ruu aamohoꞌoo-ha pooꞌu, emaabei-ri ihimai-ka, Iesu hoho reꞌei-da. Turiaha uubi hohoi-da, Iesu omoaduꞌoi-ka, ruu-ro Iesu iaihimodi mabui, ka ruu gimoi gaaꞌu hiꞌa-ha ioroopoiꞌoi. ");
INSERT INTO kiw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iesu-ro aaꞌo ooboi eito aaꞌo-ka, “Moo meree-behe, roo pupuo iraromoi-ro, roo mea tauo ododiai maaka, miroi-da odau.” ");
INSERT INTO kiw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu aaꞌo madei ioroaduꞌuti-da, himoꞌa meree ata ooꞌui-ka, Iairusi motoi-da, “Roo meree-behei tauo iihiai maaka, imatomudio dubui aiha oomaimutiꞌa.” ");
INSERT INTO kiw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ka Iesu-ro, oroomai-ka. Ida paaꞌo, Iairusi-do, “Toe aꞌaiꞌa, roo iraromoi pupuo-ha ooꞌa. Ka ruu oodomoiaiꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iesu, Iairusi motoi-da iereedeeꞌai-da, ruu-ro uubi aamiꞌa iꞌopai bia, ruu rautu ma iidoumoi-ri, ii Petero, Ioare, Iemisi, kamia meree-behei maamu-ra abea-rai haa-ro piidoumo. ");
INSERT INTO kiw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Turiaha uubi giiꞌepu idebi paꞌaimo, meree-behei eito, ida paaꞌo Iesu-ro, “Idebi aꞌaimoꞌa, mereei iihiai bia, irai ruu uro orobu.” ");
INSERT INTO kiw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rii-ro ruu mari pemaꞌaimo, mabu rii umoo-ka, mereei rituo-ka. ");
INSERT INTO kiw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Irai Iesu-ro, ruu tui-da oꞌapuai-ka, ida pupuoi-to paaꞌo, “Moo meree, eibua.” ");
INSERT INTO kiw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ruu oroiꞌioi araimai-ka. Kiauka, ruu gaaꞌu hiꞌa-ha peibua, ida Iesu-ro iduuꞌai-ka, uuho raa ata ma emaꞌaimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abea-ra maamu-rai urio podaudioido, ida Iesu-ro iduuꞌai-ka, meree ata omoaduꞌoumoꞌai-ri, raꞌu-ro oobodii. ");
INSERT INTO kiw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu-ro, ruu tuero (12) iimatomudio mereei, iahoꞌootiai-ka, gaaꞌu-ha, erarai ma imaꞌai-ri. Memiho urioi ma ibodidioumoi-ri, kamia gimoi ma idomoumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ida rii itiodoai-ka, Aiai Iehoma pai emidio erarai ma imoaduꞌutimoi-ri, kamia gimoi ma idomoumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ka ruu-ro rii iduuꞌai-ka, “Tu hai-to odaumo, garaꞌu bia, ipi haaꞌo bia, du bia, mori bia, kamia teti ata bia. ");
INSERT INTO kiw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Riꞌo raati-da miꞌopai duumo, geꞌii rautu aaꞌo motoi haato ma emidioi, modau-die, riꞌo-ro aaꞌo goꞌotoi memeheai duumo. ");
INSERT INTO kiw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Riꞌo uubi-ro, geꞌii rautu iꞌopai tiato-ra, ire goꞌotoi ita emeheaimo, ka otoi tuoꞌoi ita imamahuruutiimo. Ka riꞌo-ro, rii iraromo imaꞌai aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ruu iimatomudio mereei emeheaimoi-ka, turiaha goꞌotoi pai meai imoaduꞌuti-ri, kamia uubi ma idomoiatidioumoi-ri, turiaha mati-da. ");
INSERT INTO kiw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aaꞌo himioi Garereia paidubui-ka Heroda, ruu-ro ai-piroomidio, turiaha raarai iorododiaimoi. Ka ruu pauo hiꞌa piraromo, mabu aamiꞌa uubi-ro iaaꞌoumoi, Ioare oboi-da imaaheemo dubui, ata paraimai oroiꞌioi eito. ");
INSERT INTO kiw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aamiꞌai-ro ai-paaꞌoumo, Eria-ro poobodii, kamia aamiꞌai-ro ai-paaꞌoumo, tauo hiꞌai himogabo dubui ata-ro paraimai oroiꞌioi eito. ");
INSERT INTO kiw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Heroda-ro aaꞌoi-ka, “Ioare epuui moo-ro pirahiai, irai moo iroomidio raarai, aꞌai dubui boꞌu-rie?” Ka ruu-ro ai-pemahibaituti, Iesu ma emeeꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesu iiapui made himoꞌa uubi iiraimaimoi-da, ruu omoaduꞌuti-ka, turiaha rii iaꞌaimo raarai. Ruu-ro, rii himia hiꞌa beha-ha iꞌopai-ka odai, goꞌoto atai-to, pairai Besaida. ");
INSERT INTO kiw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Uubi geemai-ro aaꞌo pai ioroomaimoi-da, Iesu obodoumoi-ka. Ruu-ro, geꞌii rautu piꞌopai imoaduꞌuti, Aiai Iehoma pai emidio erarai ooꞌaa emerai, kamia ruu-ro idomoiatidioi-ri, rio iaꞌaimo uubi ai-pidomoiatidio. ");
INSERT INTO kiw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Himioi ooꞌuoi iomahoroi-da, Iesu iimatomudio tuero (12) uubi ooꞌumoi-ka Iesui-do, ida poduuꞌaimo, “Uubi itiodoai ma odaumo, ara taitai goꞌoto-ra paꞌea-rai eito, iihoi-re irobu mati-re ma ioohoumo, mabu ara hiou opuhe mati-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Irai Iesu-ro rii-do aaꞌoi-ka, “Riꞌo himia-ro, iomotoumo uubi.” Rii-ro omoaimai-ka, “Turiaha rimo reꞌei-da iiꞌai, tu-hapuo (5) parama ipi beha-ka, retoꞌa raai-re. Roo rio-ra rimo-ro ma rodaumo ara uubi hiiroi du imemei?” ");
INSERT INTO kiw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Aaꞌo reꞌei-da paipi tauseri (5,000) aibo-ka, dububaiꞌo behai.) Iesu-ro aaꞌoi-ka, ruu iimatomudio mereei eito, “Uubi idomoiatidioumo, pipiti (50) aibo, paꞌa gaaꞌu-gaaꞌui-da, ma emiꞌeitutiimo.” ");
INSERT INTO kiw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iesu iaaꞌo emerai, ruu iimatomudio mereei-ro iododiaimo didimoi, ");
INSERT INTO kiw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iesu-ro, tu-hapuo (5) parama ipi, raati rautu iimidai-da, imaromiai-ka aromoi eito. Aaꞌo raarai-ri, Aiai Iehomai-do geꞌii made aaꞌoi-ka, aiha pihebuti imaꞌai-ka, ruu iobodoumo mereei eito, uubi ma imaꞌatiimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rii iihoumo kaupaꞌe hiꞌa. Ka Iesu iobodoumo uubi-ro, ioromoameheaimo riaꞌei, iidabuaimoi-da, tuero (12) rehai pidodiaimo. ");
INSERT INTO kiw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ata himioi Iesu ai-pirudemea himia gaaꞌu-ha, ida pooꞌumo ruu iimatomudio mereei, ruui-do. Ruu-ro rii iatohetai-ka, “Uubi aaꞌoi-da, moo boꞌu-rie?” ");
INSERT INTO kiw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rii-ro omoaimai-ka, “Aamiꞌai-ro ai-aaꞌo kaumo, roo Ioare-ka, uubi oboi-da, imaaheemo dubui-ka, aamiꞌai aaꞌoi Eria, kamia aamiꞌai aaꞌoi roo tauoi himogabo dubui ata-ro paraimai oroiꞌioi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ruu-ro rii iatohetai-ka, “Riꞌo mia? Riꞌo aaꞌoi-da, moo boꞌu-rie?” Petero-ro omoaimai-ka, “Roo Iehoma-ro iapui Paidubui-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ka Iesu-ro erehe hiꞌa ereemaabe made imaꞌai-ka, ara raai meree ata omoaduꞌoumoꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ka ruu-ro rii iduuꞌai-ka, “Uubihaubi mereei, memiho hiꞌa temeteme eidai aꞌai. Maraibo duumo, epuu otii uubi-ro, Iehoma poue emaꞌatidio uubi epuu uubi-re, kamia bubui imatomudio uubi-re. Ruu iihiai-da edeꞌai aꞌai kaumo. Irai didimoi-to, retoꞌa-gaaꞌu (3) himioi-da, ruu oitorai aꞌai oroiꞌioi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ka ruu-ro, rii turiahai-do aaꞌoi-ka, “Meree ata-ro, rio amaꞌai moo obodoi, ruu himia dodo ma ororiiꞌii, satauroi ma aaꞌotai, ka moo ma robodoi turiaha himioi. ");
INSERT INTO kiw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Roo boꞌu-ro miraromo, roo himia oroiꞌioi araahoꞌoi, ka aatoai aꞌai, irai boꞌu oroiꞌioi maatoai moo-ri, ruu oroiꞌioi arahoꞌoi aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Raꞌaibou mea-ro ooꞌai maꞌai, meree ata-ro hepu geegai ma eidai, kaida, ruu himia oroiꞌioi ma aatoai? Aaꞌa, mea bia! ");
INSERT INTO kiw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Uubi-ro moo hiipo aremaꞌai duumo, kamia moo imatomudioi-re, ka rii Uubihaubi mereei-ro, aaꞌo emerai hiipo imaꞌai aꞌai, ruu himia tomioi-re, Abeai tomioi-re, kamia dubuae arerui tomioi-rei, rautu ooꞌui aꞌai-da. ");
INSERT INTO kiw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Riꞌo moo-ro iaha hiꞌai riduuꞌai, riꞌo aamiꞌai araarie, oroihi aꞌai bia modau-die, Aiai Iehoma pai emidio erarai, memeeꞌa duumo.” ");
INSERT INTO kiw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ara madei iaaꞌoi-da, eiti (8) himio aibo, tauo poroohodi, Iesu-ro Petero, Ioare, kamia Iemisi iꞌopai-ka, iioi roꞌoai hoꞌui eito irudemeai. ");
INSERT INTO kiw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ruu irudemeai-da, hohoi ata aibo poroaꞌoomo, ka ruu hipurai rautu bereberei hehei aibo-ro pioohiai. ");
INSERT INTO kiw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aaꞌo ipi haato, retoꞌa dubuoti iobodidoi-ka, ruu rautu poroaduꞌutido, riiti Mose-ra, Eria-raika. ");
INSERT INTO kiw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aromoi tomioi rautu piobodiido, Iesu Ierusaremaato iihiai aꞌai emerai poroaduꞌutibiimo, Aiai Iehoma madei modoboi. ");
INSERT INTO kiw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petero aamiꞌai rautu uro hiꞌai pirobu, irai rii idomai iiaamodiimoi-da, ruu emeeꞌai-ka, tomioi rautu, retoꞌa dubuoti rautu potii. ");
INSERT INTO kiw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aaꞌo dubuoti-ro, Iesu iemeheaidoi haato, Petero-ro aaꞌoi-ka, Iesui-do, “Epuudubu-o, raꞌu meai-ra rimoibi araa-rie! Rimoibi-ro, retoꞌa-gaaꞌu (3) moto epuu imoamodoi raꞌai kaumo, roo himia, Mose himia, ka Eria himia.” (Ruu ihaha umoo bia ruu raꞌu aaꞌo). ");
INSERT INTO kiw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ruu ioroaduꞌuti-da dumo kopi aiha poobodi, duꞌi-ro rii iatimai-ka, ruu iimatomudio mereei iha toei paꞌaimo dumoi-ro rii iiatimai-da. ");
INSERT INTO kiw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kiauka made ata dumoi goroi-da aaꞌoi-ka, “Ara moo meree-ohioi-ka, ruu moo-ro ai-pirapui, ruui-do oromidioumo.” ");
INSERT INTO kiw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Madei ioropoiꞌo didimoi-da, Iesu aaꞌo dubuoti-ro emeheai-ka. Irai aaꞌo himioi, Iesu iimatomudio mereei-ro, iaꞌaumo raarai aiha piohiidioumo, meree ata omoaduꞌuti bia. ");
INSERT INTO kiw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Himio atai-da, Iesu rautu retoꞌa-gaaꞌu (3) iimatomudio uubi, roꞌoai-da piooꞌumo, ida uubi paꞌa geema-ro imeeꞌai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ida aaꞌo uubi tuiai-da, dubu ata-ro, geema madei-to paaꞌo, “Epuudubu-o! Roo moo-ro ai-roarotiai, moo meree-ohioi, gaaꞌu hiꞌa-ka, ma rememeeꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ruu memiho urioi-ro iimamiiai-da, made geega gaaꞌu aapoꞌiai-ka, eheuꞌatoi-ka hepui-da, iimoaimuti-ka, ka ipuugaahei iamootiai-ka. Ka memiho urioi-ro, ruu aaꞌo emerai omodoboadio, ka pauoi-to emeheai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Roo iimatomudio uubi tauo rimoarotiai maaka, irai rii-ro memiho urioi omobodiomai modobo bia.” ");
INSERT INTO kiw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu-ro omoaimai-ka, “Riꞌo moꞌui gamoꞌo hiꞌa tiato uubi-ka, Iehomai-do riꞌo pupuo iraromo kaukai, keeke hiꞌa-ka. Moo riꞌo rautu, raꞌaibou tutuu emidioi-ra? Moo haꞌima-ro tauo piroohiai, riꞌo pupuo iraromoi iiꞌimo bia.” Ruu-ro aaꞌo dubui eito aaꞌoi-ka, “Roo mereei omooꞌu, ara hiou eito.” ");
INSERT INTO kiw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Meree-ohioi iomooꞌumoi-da, memiho urioi-ro, hepui-da eheuꞌatoi-ka, iimoaimutii oomahoroi-ka. Iesu-ro pupuo madei-to memiho urioi obodiomai-ka, ka meree-ohioi aiha poodomoia, ka abeai eito meree-ohioi omoaimai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Turiaha uubi urio podaudioumo, Aiai Iehoma erehe erarai ieaꞌaumoi-da. Irai Iesu iaꞌai raarai uubi-ro geꞌii rautu, geema poomaabumo, kaida ruu himia iimatomudio mereei eito aaꞌoi-ka, ");
INSERT INTO kiw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Dodo iiꞌimoꞌa moo-ro riꞌo iduuꞌai aꞌai raai! Uubihaubi mereei imaꞌai aꞌai kaumo, uubi erarai eito.” ");
INSERT INTO kiw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Irai iimatomudio uubi umoo bia ara madei ihahai iaaꞌo emerai, mabu madei rii moꞌui-da ai-pimoapiꞌoma, kamia rii toe paꞌaimo ruu atohetai aaꞌo raarai hapuoi. ");
INSERT INTO kiw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iimatomudio mereei himia eemaaꞌoi oomahoroi-ka, riiato, boꞌu-ro ooꞌai maꞌai geema hiꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu umoo tauo-ha piiꞌi, rii moꞌui-da raꞌu iraromoumoi, ka ruu-ro, meree-keehi ata oꞌopai-ka, ruu taitai-da omotoboai-ka, ");
INSERT INTO kiw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","kaida aaꞌo-ka rii-do, “Ara meree-keehi boꞌu-ro moꞌopai, moo pairai-da, moo tauo roꞌopai maaka, kamia moo boꞌu-ro roꞌopai, moo irotiodoai mereei rautu tauo oꞌopai maaka. Mabu riꞌoato keehibuoi boꞌu-rie, ruu-ka geema hiꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioare-ro aaꞌoi-ka, “Paidubu-o, rimo-ro dubu ata reaꞌaa duumo, memiho urioi, roo pairai-da ibodiidio. Ka rimo-ro ruu ai-roduuꞌai duumo ma emahuurai-ri, mabu ruu rimo paꞌai-da bia.” ");
INSERT INTO kiw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu-ro aaꞌoi-ka ruui-do, kamia aamiꞌa iimatomudio mereei rautu, “Riꞌo-ro ruu emadohomaimoꞌa, mabu roo omoamoo tiatoi boꞌu-ra, ruu roo rautu-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu aromoi eito omio himioi taitai-ro ioohiai-da, ruu iraromo peidai, ka odai omahoroi-ka Ierusaremai-to. ");
INSERT INTO kiw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ka ruu-ro made himoꞌa uubi epuui-da itiodoai-ka, Samaria goꞌoto atai-to, ruu raara ma emaumodiimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Irai aaꞌo goꞌotoi uubi-ro, ruu oꞌopaimo bia, mabu rii umoo-ka, ruu didimoi-to Ierusaremai-to odai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ruu iimatomudio uubi-da, Iemisi-ra Ioare-rairo aaꞌo raai ieaꞌaidoi-da, rii-ro aaꞌoi-ka, “Paidubu-o, roo rio-ra rimo-ro erai ma rahoꞌoumo aromoi-da, ma ooruoi, rii ma iruuroi?” ");
INSERT INTO kiw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iesu-ro riiti iimeteai-ka, erehe madei-to imaaꞌo mamai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kiauka Iesu iimatomudio mereei rautu, aiha podaumo goꞌoto atai-to. ");
INSERT INTO kiw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Rii gaboi iimadaꞌuimo himioi haato, dubu ata-ro Iesui-do aaꞌoi-ka, “Roo raati odai maꞌai, moo-ro roo obodoi-ha raꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu-ro ruui-do aaꞌoi-ka, “Buꞌi umui medee uuꞌu rautu-ka. Kamia momoꞌoi toto rautu-ka, irai Uubihaubi mereei hora utaꞌa mati tiato-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ruu-ro aaꞌoi-ka, dubu atai eito, “Moo robodoo.” Irai aaꞌo dubui-ro aaꞌoi-ka, “Paidubu-o, epuui tauo, moo abeai uuꞌumai raaraimai.” ");
INSERT INTO kiw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu-ro omoaimai-ka, “Oroihi rii himia rituoi-ha ma oruuꞌumoi. Roo-mia odau Aiai Iehoma pai emidio erarai imoaduꞌuti.” ");
INSERT INTO kiw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Meree ata-ro aaꞌoi-ka, “Moo-ro roo obodoi raꞌai, irai tauo moo ai-raraimai, moo riaraamui giiꞌepu-umoo made imaꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu-ro, ruui-do aaꞌoi-ka, “Meree ata-ro, hepui auhioi oomahoroi-da, ruu aia mereemeteuti didimoi eito, ruu modobo bia, Aiai Iehoma pai erarai goroi-da emidioi.” ");
INSERT INTO kiw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aaꞌo didimoi-da Paidubui-ro iapui-ka, ata semeriti-tui (72), itiotuti-ka retoꞌa (2), retoꞌa (2), ruu epuui-da ma odaumoi-ri, ruu odai iieremaumodi mati-mati modobo. ");
INSERT INTO kiw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ruu-ro rii-do aaꞌoi-ka, “Paꞌeai raarai iiho modobo tauo poohiai, irai iaꞌuubo uubi retoꞌati-ka, paꞌeai raarai ihai ma idabuaimo. Ma irudemeai paꞌeai rautu mereei eito, ka ruu-ro iaꞌuubo uubi ma itiodoai. ");
INSERT INTO kiw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Odaumo! Riꞌo moo-ro ai-ritiodoai mamoe paha-paha aibo, buꞌi umui tuiai eito. ");
INSERT INTO kiw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mori ioidio haaꞌo, ipi haaꞌo, kamia oto tamai rautu, riꞌo-ro iꞌapudioumoꞌa. Gaboi ipi-da meree ata rautu tutuu-ha oroaduꞌuti bia. ");
INSERT INTO kiw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Riꞌo odai-da raati moto modoro, epuui aiha ma aaꞌoi, ‘Miroi ooꞌa, ara motoi-da.’ ");
INSERT INTO kiw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Miroi umoo meree-ra, riꞌo miroi ruu reꞌei-da ooꞌai aꞌai, ii miroi umoo tiato meree-ra, miroi ma oaimai riꞌo himiai-do. ");
INSERT INTO kiw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aaꞌo motoi-da ma emidioi, riꞌo raꞌu mimedeꞌa duumo ma iihoi, kamia ma idioi, mabu omaꞌati mereei taꞌii imidai aꞌai. Moto aamiꞌai-to oroaꞌoiai bia. ");
INSERT INTO kiw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Riꞌo goꞌoto atai-to aia modau duumo, ida aia mioꞌopai duumo, riꞌo hoho reꞌei-da ideꞌa, dui ma iihoi. ");
INSERT INTO kiw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Gimoi ma idomoiatidioi aaꞌo goꞌotoi-da, ka uubi ma iduuꞌai, ‘Aiai Iehoma pai emidio erarai riꞌo taitai-daka.’ ");
INSERT INTO kiw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ka riꞌo goꞌoto atai-to aia midoo duumo, ida geꞌii rautu ioꞌopaimo tiato-ra, ma odai gaboi ipi eito, ida ma aaꞌoi, ");
INSERT INTO kiw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Riꞌo goꞌotoi tuoꞌoi, rimo otoi-da imaratemoi, ai-rorotobiiti kaumo, riꞌo himiai-do. Irai ita iraromoumo, Aiai Iehoma pai emidio erarai riꞌo taitai eito, tauo ooꞌu maaka.’ ");
INSERT INTO kiw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Moo-ro riꞌo iaha hiꞌai riduuꞌai, aumai iimaapo himioi-da, Aiai-ro Sodoma iemaꞌai riiboi keehibuo-ka, irai ire goꞌotoi, geega riibo omiiꞌai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasi goꞌotoi-o, memiho hiꞌa-ro ooꞌai aꞌai, rooi-do! Besaida goꞌotoi-o, memihoi hiꞌa-ro ooꞌai aꞌai, rooi-do! Mabu riꞌo reꞌei-da, iaꞌaimo urio odaudio raarai, Taia-ra Sidoro-ra goꞌototi-da aꞌai ato, aaꞌo mati epuui uubi mei emiꞌeituti kaumo, idiꞌidi hipurai-da mei aatimo kaumo, tuoꞌoi-da, ida garadodoumo, mabu rii memihoi reꞌei-da tauo pireheꞌeaimo. ");
INSERT INTO kiw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Irai Aiai-ro Taia-ra Sidoro-ra goꞌototi iimaꞌai riiboi keehibuo-ka, irai aumai iimaapoi aꞌai himioi-da, riꞌo omiiꞌai aꞌai riiboi geema-ka. ");
INSERT INTO kiw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kaperarauma goꞌotoi-o, roo himia oroomioi amaꞌai aromoi eito? Bia, roo omooruoi-ha aꞌai, giimui-to.” ");
INSERT INTO kiw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ka Iesu-ro aaꞌoi-ka, ruu iimatomudio mereei eito, “Riꞌo boiꞌo-ro miroomidio duumo, ka moo iroromidio duumo, kamia riꞌo boiꞌo-ro miraibo duumo, moo araiboi aꞌai kaumo, kamia moo boiꞌo-ro raraibo duumo, rii-ro moo irotiodoai abeai rautu araiboi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ka iitiodai, semeriti-tu (72), dububaiꞌoi iha geꞌii rautu piiraimaimo, rii-ro aaꞌoi-ka, “Paidubu-o, rimo-ro memiho urioi, roo pairai-da, erehe irudemea made irimaꞌaimoi-da, rii-ro rimo aiha piriroomaimo.” ");
INSERT INTO kiw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu-ro rii iduuꞌai-ka, “Moo-ro, Satari aiha pireaꞌa aromoi-da, bereberei emerai piiraahiai. ");
INSERT INTO kiw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Oromidioumo! Riꞌo erarai tauo pirimaꞌai, auo-ra, duukorope-rai hoꞌu-hoꞌui, ma oroaꞌoiaumoi-ri, kamia riꞌo Boho Mereei pupuoi ma omoapoiꞌoumoi-ri, ka ata raa-ro, riꞌo temeteme imaꞌai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Irai geꞌii aꞌaimoꞌa, memiho urioi-ro riꞌo madei iiromidio duumoi-ri, ii geꞌii-ha ma aꞌai, mabu riꞌo pairai tauo-ha, paraꞌatiimo aromoi-da.” ");
INSERT INTO kiw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aaꞌo himioi haato, Iesu Dubuae Urioi-ro iimamiai-da, ruu geega geꞌii paꞌai, ida paaꞌo, “Aba-o, aromo-ra hepu-rai, Paidubu-o! Moo-ro, roo ai-remarahue, mabu roo-ro tauo pimoahuꞌomai ara raarai, umoo tiatoi uubi eito, irai umooi-re moꞌui uubi-rei, reꞌei-da, ai-pimopiꞌoma ara raarai. Ie, Aba-o, roo iraromo meai modoboi-da, tauo oobodii maakaumo. ");
INSERT INTO kiw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Moo Abeai-ro raarai turiaha piremaꞌai. Meree ata umoo bia, meree-ohioi boꞌu-rie, Abea behai umoo-ka, kamia meree ata umoo bia, Abeai boꞌu-rie, meree-ohio behai umoo-ka. Ka mereei-ro rio aꞌai ruu abeai aamiꞌa uubi eito ma imoaꞌemiai, ka rii-ro umoo iiꞌi aꞌai kaumo ruu.” ");
INSERT INTO kiw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kiauka Iesu ereheꞌeai-ka, ruu iimatomudio meree behai imoaduꞌuti, “Riꞌo meaha tauo iiꞌi maakaumo, doꞌou orododiai raarai, ma iaꞌaamoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Riꞌo ai-riduuꞌai, hiiro himogabo uubi-re, kamia Pai uubi-reiro, rio paꞌaimo, riꞌo iaꞌaa raarai ma iaꞌaumoi-ri, irai iaꞌaa bia, kamia riꞌo iromidioumo madei ma iromidioumo, irai iromidioumo bia.” ");
INSERT INTO kiw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bubui imatomudio dubui ata, rio-ka Iesu dii ma emedeeꞌai, ruu-ro atohetai-ka, “Imatomudio dubu-o, moo raꞌu aꞌai raꞌai tutuu oroiꞌioi ma reidai-ri?” ");
INSERT INTO kiw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu-ro ruu omoaimai-ka, “Iehoma made bukai-ro, raꞌaibou aaꞌo? Roo-ro oaꞌeemiai-da raꞌu moroaduꞌo?” ");
INSERT INTO kiw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aaꞌo dubui-ro omoaimai-ka, “Roo-ro Paidubui Iehoma, roo kaukai-re, roo urioi-re, roo pupuoi-re, roo iraromoi-re turiaha ma emaꞌai. Ka roo taitai mereei giiꞌepu ma emaꞌai, roo himia-ro giiꞌepu eremaꞌai aiboi.” ");
INSERT INTO kiw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu-ro aaꞌoi-ka, “Roo ihaha aaꞌo, ara raarai ita idodiai, roo oroiꞌioi aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Irai bubui imatomudio dubui rio-ka ruu himia iraromoi-da meai-to arahoꞌoi, ka Iesu atohetai-ka, “Moo taitai mereei boꞌu-rie?” ");
INSERT INTO kiw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu-ro odii ataato omoaimai-ka araibau, “Dubu ata ai-poodoi Ierusaremaato Ierikoi-to, ida piroi-ro poohiaimo, hipurai imomopimutimo, iaiꞌiiaumo aumo-aumoi aꞌai-da pemeeheaimo, rii odai. ");
INSERT INTO kiw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka aaꞌo himioi Aiai poue iemaꞌatidioumo dubui ata gaaꞌu, gaboi poodoi, irai aaꞌo dubui iemeeꞌai-da, aiha pemahee hapuoi-ha poodoii. ");
INSERT INTO kiw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Irudeme motoi-da imoabai dubu ata, gaaꞌu gaboi poodoi aatu emerai, aaꞌo dubui emeeꞌai-ka, ka aiha pemeeheai hapuoi-ha poohodii. ");
INSERT INTO kiw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Irai Samaria dubu ata, hiei-ha pooꞌu, ida aaꞌo dubui-ha pemeeꞌa, ka ruu-ro iemeeꞌai-da, ruu kaukai-da iha giiꞌepui peereaꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ruu-ro oomodai-ka, tamai ratoi iiꞌaa reꞌei mire obo-ra, here raai-da imimoruꞌo, umai itohiti-ka, aiha pomiꞌai ruu iomodau doriki-da aiha paaꞌoai, omodai-ka dima motoi-da aiha pedeꞌa, ka hiei-da peaꞌaamo. ");
INSERT INTO kiw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Himio atai, retoꞌa (2) mori huraati iruutiai-ka, motoi ieaꞌaa dubui emaꞌai-ka, ida poduuꞌai, ‘Meaha ita eaꞌaa, roo raꞌu eheuꞌai maꞌai ruuato, moo-ro omoaimai raꞌai arahiou hoꞌui-da.’” ");
INSERT INTO kiw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kiauka Iesu-ro madei opoiꞌoi-ka, “Roo iraromoi-da, retoꞌa-gaaꞌu (3) uubi-da piroi-ro iaiꞌiiaumo dubui tama taitai aibo mereei boꞌu-rie?” ");
INSERT INTO kiw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Bubui imatomudio dubui-ro aaꞌo-ka, “Ruu giiꞌepu iemaꞌai dubui-ka.” Iesu-ro aaꞌoi-ka, “Ka roo odau, gaaꞌu emerai ita aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka Iesu, ruu iimatomudio mereei rautu iodaumo gaboi ipi-da, pemeeꞌaumo, goꞌoto ata. Hiei-da oobo ata paira-ka, Mata, ruu-ro Iesu geꞌii rautu poꞌopai ruu motoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ruu ria meree-behei, pairai Maria, Paidubui hoho reꞌei haato peiꞌei, ka ruu imatomudio emerai-ha poroomidio. ");
INSERT INTO kiw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata geꞌii aꞌai bia, turiaha omaꞌati ruu himia haa-ro ma omaꞌati, kaida iooꞌui-da paaꞌo, “Paidubu-o, roo-ro emaabei meaha-ra? Moo ria meree-behei-ro ai-remeheai maaka, turiaha omaꞌati moo himia haa-ro ma romaꞌati-ri. Ruu oduuꞌai ma ooꞌui, moo ma romoabai!” ");
INSERT INTO kiw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Paidubui-ro, ruu madei pomoaimai, “Mata, Mata! Roo iraromoi pauo-ka, kamia auma-ka, roo iraromo raara hiiroi-da, ");
INSERT INTO kiw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","irai gaaꞌubuo geema hiꞌa raa rooi-do, roo-ro rio aꞌai. Maria ruu, mea hiꞌa raai rio iiꞌi maaka, ka omodadeai aꞌai bia ruu aaꞌo raai reꞌei-da.” ");
INSERT INTO kiw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ata himioi, Iesu ai-pirudemea mati ataato. Ka irudemeai ioropoiꞌoi-da, ruu iimatomudio mereei ata-ro aaꞌoi-ka, “Paidubu-o, rimo irudemeai ma rimatomudio, Ioare, iimatomudio mereei, iimatomudio emerai.” ");
INSERT INTO kiw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu-ro aaꞌoi-ka rii-do, “Irudemeai-da, araibau-ha ma irudemeai, Aba-o, Roo dubuae pairai ita emaabeumo; Roo pai emidio erarai mooꞌu-ka. ");
INSERT INTO kiw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Rimo himio gaaꞌu-gaaꞌu modobo dui, rimaꞌati. ");
INSERT INTO kiw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Rimo memihoi rimapihiti, mabu rimo-ro aamiꞌa uubi, rimoi-do aꞌai memihoi imapihiti-ka. Ka rimo imatuhuti raarai-da, ita rimomurudio.” ");
INSERT INTO kiw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iesu-ro aaꞌoi-ka, ruu iimatomudio mereei eito; “Roo-ro ma iraromo, roo riaraamu rautu-ra, ida ruui-do ma odau duoi tuia hiꞌai, ida ma aaꞌo, ‘Riaraamu-o, moo retoꞌa-gaaꞌu (3) du kopiato romoabai. ");
INSERT INTO kiw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Mabu moo riaraamu ata, auꞌo matiato ooꞌu maaka mooi-do, irai moo ata raa tiato-ka, ruu ma remaꞌai!’ ");
INSERT INTO kiw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kaida, rioi mereei-ro, araibau amaaꞌo, ‘Moo pauo emaꞌaiꞌa! Birii tauo romoopai maaka, moo mereei rautu uro mati-daka. Moo eibuai modobo bia, roo ata raa ma romoabai.’ ");
INSERT INTO kiw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Irai moo-ro riꞌo ai-riduuꞌai, ruu eibuai aꞌai bia, ruu roo riaraamui-ri, roo ata raa ma emaꞌai, irai roo-ro ruu aia matohe ata-atai hiipo tiato-ha, ruu eibuai aꞌai, roo aaꞌo raarai turiaha emaꞌai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ka moo-ro riꞌoi-do ai-raaꞌo, ma atoheitai, ka riꞌo-ro eidai aꞌai kaumo, ma oohoi, ka riꞌo-ro emeeꞌai aꞌai kaumo, birii ma aamaꞌedei, ka birii araꞌerai aꞌai riꞌoi-do. ");
INSERT INTO kiw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mabu boiꞌo-ro matohe duumo, rii-ro eidai aꞌai kaumo, boiꞌo-ro moohoo duumo, rii-ro emeeꞌai aꞌai kaumo, kamia birii araꞌerai aꞌai, birii amaaꞌede uubi eito. ");
INSERT INTO kiw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Riꞌo abeamiꞌoi eito modobo-ra, roo mereei auo ma emaꞌai, ruu raa-ri oroaroi-da? Bia, modobo bia! ");
INSERT INTO kiw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kamia duukoropei emaꞌai amaꞌai, ruu kokoro hurai-ri oroaroi-da? Bia, modobo bia! ");
INSERT INTO kiw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Irai riꞌo memihobaiꞌo umoo-ka, riꞌo mereei meamea raara imaꞌati. Aromoi Abeai, geema hiꞌa rio aꞌai, Dubuae Urioi imaꞌati, ruui-do oroaro uubi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu-ro memiho urioi iobodiomai-da, made oroaduꞌuti tiato dubui-da, memiho urioi aiha pohuuꞌodidio. Ka memiho urioi iohuuꞌodidioi-da, aaꞌo dubui oroaduꞌuti oomahoroi-ka. Ka turiaha uubi geemai, urio podaudioumo. ");
INSERT INTO kiw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Irai aamiꞌa uubi-ro paaꞌoumo, “Berisaburo-ro emaꞌai Iesu erarai, memiho urioi ma ibodiidio-ri. Ka Berisaburo turiaha memiho urioi epuuhoroi-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aamiꞌai, rii rio-ka Iesu ma emahibaimo, ka ruu atohetaimoi-ka, urio odaudio raa ata, ma obodii-ri. Ka rii umoo ma iiꞌimo, ruu erarai Iehoma reꞌei-da ooꞌu. ");
INSERT INTO kiw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Irai Iesu, umoo iiꞌi-ka, rii iiraromoumoi. Ruu-ro aaꞌoi-ka rii-do, “Hepu ata, ruu himia, aia moroaheuti rii himia heamo ma aꞌaimoi-ri, ara hepui tutuu ooꞌai aꞌai bia, gaaꞌu aibo-ka, dubu ata, motoi-da, meree Abea emidioi, aia goroaheuti, ara dubui motoi otii aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kamia Satari ruu himia paꞌai aia moroaheuti heamo ma aꞌaimoi-ri, ruu pai emidioi mati raꞌaibou ooꞌai maꞌai? Bia, modobo bia! Riꞌo-ro ai-aaꞌo kaumo, moo memiho urioi Berisaburo erarai-da riibodiidio. ");
INSERT INTO kiw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ha, moo Berisaburo erarai-da ariibodiidio, ka riꞌo iibodoumo uubi boꞌu erarai-da, iibodiidioumo memiho urioi? Rii Berisaburo erarai-da, ibodidioumo bia. Ka eaꞌai-da, riꞌo hobou aaꞌo kaumo! ");
INSERT INTO kiw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Irai moo-ro, memiho urioi, Aiai Iehoma erarai-da ariibodiidio, ka Iehoma Pai emidio erarai, riꞌoi-do tauo ooꞌu maaka. ");
INSERT INTO kiw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Pupuo dubui, heamo raarai rautu, modobo-hara, ruu himia motoi-da, ruu raarai meaha iiꞌai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Irai pupuo hiꞌa dubui-ro, ruu aia moohiai, ida ruu pupuoi aia momoapoiꞌo, ka ruu iimomotii heamo raarai oaidai aꞌai turiaha, ka aamiꞌa uubi eito, imaꞌati aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Roo, moo rautu bia-ra, ka roo-ro moo ihaha omoamoi aꞌai; meree ata, moo omoabai tiato-ra ibuꞌiidioi-da, ruu-ro iburuti aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Memiho urioi-ro, meree ata aia memeheai, ka ruu oroaꞌoiai-ka, toatoa hepui, hora ahue mati ma emeeꞌai-ri. Ida ata mati emeeꞌa tiato-ra, ruu-ro himiai-do aaꞌoi-ka, ‘Moo araimai rodau, moo himia motoi eito.’ ");
INSERT INTO kiw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ka ruu araimai-da, motoi emeeꞌai-ka, tomio-ha tauo-ha potobioumo. ");
INSERT INTO kiw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ka ruu ohuuꞌoi-ka kekai eito, ida imooꞌui-ka, aamiꞌa semeri (7) memiho hiꞌa urioi, ruu-ro omiorai, hiei-da ma emidioumoi-ri. Turiaha iidoi oropoiꞌoi-da, aaꞌo mereei memiho hiꞌai-da ereedeeꞌai-ka, ruu epuui-to iiemidio emerai oohodii-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesu, aaꞌo emerai iaaꞌoi-da, oobo ata-ro, paꞌai tuiai-da, geema madei-to paaꞌo, “Geꞌii-ka, roo ooto-ra, oomoto-rai iaꞌai ooboi!” ");
INSERT INTO kiw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Irai Iesu-ro, ruu madei omoaimai-ka. “Ie, irai geꞌii hiꞌa-ro ooꞌai aꞌai, Iehoma madei, oroomidio-ra, obodoo-rai aꞌai uubi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Uubi-ro Iesu iomaaꞌeumoi-da, ruu-ro aaꞌoi-ka, “Memiho hiꞌa-ka, doꞌou ara himioi uubi! Rii ai-oroaro kaumo, urio odaudio raa-ri, irai ata raa imaꞌai aꞌai bia. Ka moo-ro rii-do imaꞌai aꞌai raai Iora iaꞌai urio odaudio raa gaaꞌu behai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Aatu emerai-ka, himogabo dubui, Iora iaꞌai raai, Ririma uubi eito, ka Uubihaubi Mereei aaꞌo emerai raa-ha aꞌai aꞌai, doꞌou ara himioi uubi eito. ");
INSERT INTO kiw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aumai imaapoi aꞌai himioi, Seba pai ooboi otooꞌai aꞌai, doꞌou ara himioi uubi ma imehiipoi-ri, mabu ruu himia hepui-da, auꞌo pooꞌu, Soromori orootomu madei oroomidioi-ri, kamia riꞌo umoo-ra ara hioꞌou-da, ata raa, raa-rie. Moo-ro riꞌo ai-riduuꞌai Soromori pai-ro omioorai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aumai imaapoi aꞌai himio-da, Ririma uubi otooꞌai aꞌai kaumo, riꞌo imehiipoi-ri, mabu rii tauo pireheꞌeaimo memiho oroiꞌioi-da, Iora orootomui iiromidioumoi-da, ka riꞌo moo-ro umoo ridodiai, meree ata raa-rie Iora goro-ka, ruu hoꞌu-ka! ");
INSERT INTO kiw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Meree ata-ro ramepai adiai-da, opiꞌomai aꞌai bia, kamia ipuai goroi-da edeꞌai aꞌai bia. Bia modobo bia! Ruu-ro aiha edeeꞌai aꞌai ramepai ooꞌa reꞌei-da, uubi iidouti-da, hehei ma eaꞌaumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Roo idomai ramepai aibo-ka, roo tuupi eito. Roo idomai meaha-ra, ee-ka roo tuupi hehei-daka. Ii roo idomai memiho-ra, ee-ka roo tuupi duꞌi-daka. ");
INSERT INTO kiw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Meaha ma ereaꞌai, roo tuupi hehei duꞌi iiꞌi bia! ");
INSERT INTO kiw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Roo turiaha tuupi, hehe hiꞌai-dara, hapuo ata duꞌi ooꞌa bia-ra, ka turiaha hehe-haka, ramepai ma iradi emerai rooato.” ");
INSERT INTO kiw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu oroaduꞌuti ioropoiꞌoi-da, Pariseia dubu ata-ro, ai-paamaꞌue, ruu rautu ma iihoidoi-ri, ka ruu motoi iodoroi-da, aiha pemiꞌei, dui ma iihoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pariseia dubui urio podaudio Iesu ieaꞌai-da, dui iihoi-ha poomahoro, tui imoruꞌo tiatoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Paidubui-ro ruui-do aaꞌoi-ka, “Riꞌo Pariseia uubi, kapusi-ra mereki-rai kekai tamai imoruꞌo kaumo. Irai riꞌo goroi oroiꞌioi, iiho-toto, kamia memihoi geega-ka. ");
INSERT INTO kiw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Riꞌo amaamo-ka! Iehoma-ro kekai iododiai-da, rioi ododiai bia-ra? Ie, tauo pododiai. ");
INSERT INTO kiw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Irai kapusi-ra mereki-rai, rioi raarai, ma imaꞌati, raara tiato uubi eito. Ka riꞌoi-do turiaha raarai riiꞌimo tiato iiꞌai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pariseia uubi-o, memiho hiꞌa-ro ooꞌai aꞌai riꞌoi-do! Riꞌo-ro emaꞌatidio kaumo, Aiai Iehomai-do, modobo kerei, keekeebaiꞌo topo ribo raabari, kamia aamiꞌa raara paꞌeai-da. Irai riꞌo-ro, aamiꞌai eito gamoꞌo oroiꞌioi idodiaimo bia, ka riꞌo Aiai Iehomai-do, giiꞌepu aꞌaimo bia. Riꞌo-ro ire raarai aiha ma aꞌai, ka riꞌo iibodiidioumo bubui riꞌo-ro haꞌima aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pariseia uubi-o, memiho hiꞌa-ro, ooꞌai aꞌai, riꞌoi-do! Riꞌo rio-ka idabu mati-mati-da, hoho reꞌei totoi, kamia raarai oromoamee mati-da, imaabee rautu ma imoaduꞌutimo. ");
INSERT INTO kiw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Memiho hiꞌai ooꞌai aꞌai riꞌoi-do, mabu riꞌo, tu rato tiato egai boboi aibo-ka, uubi-ro umoo iiꞌi tiato-ha, hoꞌui ma oroaꞌoiaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bubui imatomudio dubui ata-ro, aaꞌoi-ka ruui-do, “Imatomudio dubu-o, roo-ro ireibai iaaꞌodioi-da, roo-ro rimo rautu, ai-rimaaꞌutidio!” ");
INSERT INTO kiw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu-ro omoaimai-ka, “Bubui imatomudio uubi-o, kamia memiho hiꞌa-ro ooꞌai aꞌai riꞌoi-do! Riꞌo-ro iaaꞌo kaumo, uubi hoꞌui-da riiboi, ka riibo hiꞌa-ka, imaꞌoiai modobo bia, irai roo himia-ro, tu hura gaaꞌu omiiꞌai aꞌai bia, rii ma imoabai riiboi-da. ");
INSERT INTO kiw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Memiho hiꞌa-ro ooꞌai aꞌai riꞌoi-do! Riꞌo-ro idodiai kaumo mea hiꞌa roꞌoa uuꞌui, oroihi himogabo uubi-ri, aaꞌo himogabo uubi, riꞌo rariamiꞌoi-ro piimotoumo. ");
INSERT INTO kiw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Riꞌo himia aꞌai raarai-da ai-oobodi kaumo, riꞌo rariamiꞌoi iaꞌaimo raarai, rio aꞌai kaumo. Rii-ro piimotoumo himogabo uubi, ka rii iruꞌumo roꞌoa uuꞌu boboi riꞌo-ro imititi kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Aaꞌo raꞌu-da, Iehoma mooꞌui umooi-da ai-paaꞌo, ‘Moo-ro, rii imetiodoai raꞌai himogabo uubi, kamia made imaꞌoia uubi, rii-ro aamiꞌai iimotoi aꞌai kaumo, ka aamiꞌai imodoboai aꞌai kaumo.’ ");
INSERT INTO kiw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ka doꞌou ara himioi uubi rii aumai-da ideꞌai aꞌai, mabu tauoi himogabo uubi, rii-ro iimotoumoi-ri hepui iododiai himioi-da, imooꞌu doꞌou. ");
INSERT INTO kiw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abera iaiꞌiia himioi-da, iooꞌu Sekaraia iaiꞌiiaumo, ruu poue totoi-re, ka dubuae hiꞌa mati-re, ipituiai-da, paiꞌiiaumo. Ie, riꞌo moo-ro ai-riduuꞌai, riꞌo doꞌou ara himiou uubi, rii-ri auma eidai aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Bubui imatomudio uubi-o, memiho hiꞌai ooꞌai aꞌai riꞌoi-do! Riꞌo-ro oꞌapudio kaumo moꞌui motoi birii aꞌeuti raai. Riꞌo himia iidoo bia, ka riꞌo-ro imomurudio kaumo, iido tooto aꞌaimo uubi!” ");
INSERT INTO kiw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu, aaꞌo mati iemeheai-da, bubui imatomudio uubi-re, kamia Pariseia uubi-reiro, riibo madei-to peemeehiipoumo, ka rii-ro hiiro hiꞌa raara ai-patoheumo. ");
INSERT INTO kiw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ruu oraꞌe pemedeꞌaumo, ruu memiho raa ata, aaꞌoato ma oohiaimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aatu himioi-da, hiiro hiꞌa tauseri (1,000) uubi gaaꞌu-ha ioodabuaimoi-da, aamiꞌa uubi, aamiꞌai hoꞌu-hoꞌui-da ai-potooꞌutiimo. Iesu-ro epuui-da ruu iimatomudio mereei eito aaꞌoi-ka, “Ita eremaabeumo, Pariseia uubi paramai iaupaituti tuoꞌoi aibo-ka, moo-ro ai-raaꞌo, rii daea uubi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Raꞌu momurudio, eremapotai aꞌai, kamia goro hiꞌai iipiꞌomatidioi, umoo iiꞌi aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kaida roo-ro duꞌi-da raꞌu maaꞌo, himioi tuia hiꞌai-da, oromidioi aꞌai kaumo, ka haadoai-to raꞌu maaꞌo, oropatidio ruuꞌai goroi-da, motoi ubui-da pairautu madei-to, aaꞌoi aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Moo-ro riꞌo moo riaraamui ai-riduuꞌai, toe aꞌaimoꞌa tuupi boiꞌo-ro aiꞌiiai maꞌai duumo rituo-ha, irai memiho raa ata ododiai aꞌai bia didimoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Riꞌo moo-ro imapui raꞌai, riꞌo-ro boꞌu toe emaꞌai maꞌai duumo, Iehoma toe ma emaꞌai, ruu erara-ka, ruu-ro aiꞌiia didimoi-da, riibo mati eito ma epeduai. Ie, riꞌo moo-ro ai-riduuꞌai ruu beha-ha toe ma emaꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Tu-hapuo (5) miroria, retoꞌa (2) mori hurai-to, ideꞌai amaꞌai? Ie, iaha-ka, Iehoma-ro gaaꞌubuo miroriai ata, dodo iiꞌi aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kamia roo epuui muhoi turiaha tauo piahoꞌouti, kaida toe aꞌai bia, roo muari hiꞌa-ka, turiaha miroriai aibo bia. ");
INSERT INTO kiw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Moo-ro riꞌo ai-riduuꞌai, boꞌu-ro maaꞌo turiaha uubi hoohoi-da, ruu mooi-doka, Uubihaubi Mereei-ro, gaaꞌu emerai aaꞌoi aꞌai rii-do, Iehoma arerui hohooi-da. ");
INSERT INTO kiw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Irai boiꞌo-ro raraibo duumo moo, turiaha uubi hoohoi-da, Uubihaubi Mereei-ro rii aaꞌo emerai iraiboi aꞌai Iehoma arerui hohooi-da. ");
INSERT INTO kiw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Meree ata boꞌu-ro maaꞌo omoamoo made ata, Uubihaubi Mereei eito, modobo-ka emapihiti, irai boꞌu-ro maaꞌo memiho omoamoo raara Dubuae Urioi eito, emapihiti aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Rii-ro riꞌo aia mimooꞌu duumo, idabu motoi uubi-re gamarai-re kamia aamiꞌa epuuhoro uubi hohooi-da iatohei, pauo iraromoi bia, riꞌo raꞌu aaꞌoi maꞌai duumo riꞌo himia oroomatuei ma aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mabu Dubuae Urioi-ro, riꞌo imatomudioi aꞌai aaꞌo himio mabui-da, riꞌo raꞌu aaꞌoi-rie.” ");
INSERT INTO kiw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dubu ata-ro uubi hiiroi tuiai-da paaꞌo Iesui-do, “Imatomudio dubu-o, moo raamui oduuꞌai, rimoiti abeai-ro irimoameheai raarai, ma roromotoodeaido.” ");
INSERT INTO kiw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu-ro ruu omoaimai-ka, “Dubu-o, moo erarai boꞌu-ro remaꞌai riꞌoiti raarai ipituiai-da ma rimotoodeai-ri?” ");
INSERT INTO kiw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ka Iesu-ro rii-do aaꞌoi-ka, “Meaha ereaꞌaumo, ka ita ereemaabeumo riꞌo himia, rurubu oroiꞌioi-da, mabu oroiꞌioi, ihahai uubi iraahoꞌoo raarai-da ododiai bia, iahoꞌouti bia, raꞌaibou raara hiiro meree-ra.” ");
INSERT INTO kiw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kaida pimoaduꞌo, Iesu-ro ara obeegiri, “Raara hiiro dubu ata hepu rautu-ka, aaꞌo hepui-da paꞌea raarai mea hiꞌa-ha piooumo. ");
INSERT INTO kiw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ruu himia-ro iraromoi oomahoroi-ka, ‘Moo paꞌea raarai iraahoꞌoo mati tiato-ka, moo raꞌu aꞌai raꞌai?’ ");
INSERT INTO kiw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ruu himia oromoaduꞌoi-ka, ‘Moo araibau aꞌai raꞌai, moo paꞌea raarai-re, kamia dui iiꞌa motoi iagogouti raꞌai, paipai ma riititi-ri, ka moo raa hurai-re, kamia aamiꞌa dui hiei-da iraahoꞌooi raꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ida, moo himiai-do ai-raaꞌo, moo raara hiiro dubu-ka! Moo rio aꞌai meamea raarai turiaha burioi iiꞌadioi aꞌai, pauo tiato oroiꞌioi ma reidai-ri iiho idioi ma raꞌai, geꞌii rautu ma remidio!’ ");
INSERT INTO kiw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Irai Iehoma-ro aaꞌoi-ka ruui-do, ‘Roo amaamo-ka! Doꞌou duoi roo oroiꞌioi oaidai raꞌai, ka roo ieremaumodi raarai turiaha boꞌu-ro imidai maꞌai, roo-ro imeheai aꞌai-da?’” ");
INSERT INTO kiw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ka Iesu-ro obeegiri opoiꞌoi-ka, “Araibau-ka, raara hiiro-hiiroi boiꞌo-ro moromomohi duumo, rii himia-haido, rii Iehoma hohoi-da, raara tiato-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kaida Iesu-ro paaꞌo, ruu iimatomudio mereei eito, riꞌo moo-ro ai-riduuꞌai, pauo iraromoi bia iiho dui eito, riꞌo ma oroiꞌioumoi-ri, kamia tuupi imaꞌoia hipurai eito! ");
INSERT INTO kiw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Oroiꞌioi ihaha raa-ka, duui aibo bia, kamia tuupi ihaha raa-ka, imaꞌoia hipurai aibo bia. ");
INSERT INTO kiw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Oaꞌoai ma iraromoumo, rii ruꞌa hura ioodouti bia, kamia paꞌea raa iaꞌuboumo bia, rii duu iraahoꞌoo moto tiato-ka, rii Iehoma-ro iomoto, riꞌo muari hiꞌa-ka, momoꞌoi aibo bia. ");
INSERT INTO kiw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Meaha-ra, riꞌo pauo iraromo rautu emidioi, pauo iraromoi-ro, roo oroiꞌioi keehibuo, tutuu omotutuomai amaꞌai? Abiarie. ");
INSERT INTO kiw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Roo-ro ara keehibuo raai ododiai modobo bia-ra, ka raꞌu-ri pauo iraromoi-ra, aamiꞌa raarai eito. ");
INSERT INTO kiw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ma iaꞌaumo buꞌi kopoi raꞌaibou miiꞌi duumo, rii omaꞌatimo bia, kamia hipura idodiaimo bia, rii himia-ri. Irai moo-ro riꞌo ai-riduuꞌai, Soromori hipurai tomioi aibo bia, kopoi tomioi, muari hiꞌa-ka. ");
INSERT INTO kiw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iehoma-ro iidodiai, buꞌi tataꞌoi tomioi, tataꞌoi doꞌou araarie, toutu uubi-ro, iipeduai aꞌai kaumo, erai-ro ma iruuroi-ri. Iehoma-ro rii hipurai imaꞌati emerai, riꞌo ihaha imaꞌati amaꞌai? Ie, ihaha imaꞌati aꞌai! Riꞌo pupuo iraromoi keeke hiꞌa-ka! ");
INSERT INTO kiw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Kamia raꞌuri-ha iraromoi-ra, iiho-ra, idioi-rai eito, pauo iraromoi bia. ");
INSERT INTO kiw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ara hepui-da, Iuda guui-da paira tiato uubi, turiaha himioi ai-iraromodio kaumo, aaꞌo raarai. Riꞌo abeai umoo-ka, riꞌo rio-ka aaꞌo raarai. ");
INSERT INTO kiw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kaida Iehoma pai emidio erarai ma iraromoi, ka ruu-ro ara hepui-da, riꞌo oroiꞌioi iraromo raarai, imaꞌati aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Toe aꞌaimoꞌa, paꞌa keehi-o, riꞌo Abeai geꞌii-ka, ruu Pai emidio erara ma imaꞌai-ri, riꞌoi-do. ");
INSERT INTO kiw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Turiaha riꞌo raarai ma ideꞌai oromoamei-ri, ka mori, raara tiato uubi ma imaꞌati. Oroaheꞌa tiato mori haaꞌo, ita eremaumodiimo, ka riꞌo mea irahoꞌoo raarai ita ideꞌaumo aromoi-da. Ka rii oropoiꞌoi aꞌai bia, mabu piro ata-ro imeꞌei aꞌai bia, kamia tete ata-ro itoeꞌauti aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Riꞌo kaukai iiꞌai aꞌai, meamea raarai iiꞌaa reꞌei-da. ");
INSERT INTO kiw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ma ereemaumodi, raꞌu-ro ooꞌui maꞌai eito, ka ma orododiai, oobodii aꞌai raarai eito, kamia ramepai ma adiai, ");
INSERT INTO kiw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","himoꞌa uubi-ro, rii epuuhoro dubui ma omotiimo emerai, oobo-ra dubu-rai idabuai mahuai reꞌei-da, ooꞌui aꞌai aiboi. Ruu araimai-da, birii amaaꞌedei aꞌai, ka birii gaaꞌu hiꞌa-ha ma emaꞌeraimo. ");
INSERT INTO kiw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Geꞌii hiꞌa-ka, himoꞌa uubi rii epuuhoro dubui-ro, oroiꞌioi-da amimeeꞌa ruu araimai-da, kamia tauo ageremaumodiimo! Moo-ro riꞌo ihaha riduuꞌai, ruu eremaumodi aꞌai, ka rii iduuꞌai aꞌai ma emiꞌeitutimoi-ri, ruu-ro ma iomotoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ruu duoi tuiai-da, kamia didimoi-to ooꞌui aꞌai-da, rii tauo ageremaumodiimo, ida amimeeꞌa, rii geꞌii hiꞌa-ka. ");
INSERT INTO kiw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kaida riꞌo umoo hiꞌa ma ooꞌai, motoi rautu mereei umoo-ra piroi, ooꞌui aꞌai himioi, ruu-ro omoaꞌuei aꞌai bia motoi ma ehebiai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ka riꞌo rautu ma eremaumodi, mabu Uubihaubi Mereei ooꞌui aꞌai himioi, riꞌo umoo ooꞌai aꞌai bia.” ");
INSERT INTO kiw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petero-ro atohetai ka, “Paidubu-o, ara obeegiri rimo behaido-ra, ee turiaha uubi rautu-ra?” ");
INSERT INTO kiw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Paidubui-ro omoaimai-ka, “Ka boꞌu-rie mea eremaabe emidioi, kamia moꞌui rautu himoꞌa mereei? Ruu beha-ka, epuuhoro dubui-ro, epuuhoro meree ododiai aꞌai motoi ma eaꞌai-ri, kamia aamiꞌa moto himoꞌa uubi duui ma imaꞌati-ri, duui imaꞌati himio hiꞌai-da. ");
INSERT INTO kiw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Geꞌii hiꞌa-ka, ire moto himoꞌa mereei, ruu epuuhoro dubui, araimai-da, ruu aaꞌo emerai aꞌai-da amemeeꞌa! ");
INSERT INTO kiw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ie, riꞌo moo-ro ai-riduuꞌai, moto epuuhoro dubui-ro, motoi himoꞌa mereei epuuhoro apui aꞌai, ruu raarai turiaha ma emeaꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Irai ire himoꞌa mereei-ro, ruu himiai-do aibau amaaꞌo, ‘Moo epuuhoro dubui, tutuu hiꞌa himio eidai ma araimai-ri.’ Kaida ruu-ro iimotoi amoomahuꞌuai, aamiꞌa moto himoꞌa upi dubui, iiho-ra idiorai-da imaꞌai, kamia amaamo oboi-da. ");
INSERT INTO kiw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kaida ruu epuuhoro dubui ata himioi ooꞌui aꞌai-da motoi eito, himoꞌa mereei-ro ruui-do omoti tiato himioi-da, kamia ruu umoo iiꞌi tiato himioi-da, epuuhoro dubui-ro ruu amaꞌadei aꞌai, ka otiodoai aꞌai iroomidio tiato uubi eito, rii rautu ma emidioi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Moto himoꞌa mereei umoo-ra, ruu epuuhoro dubui-ro, raꞌu omaꞌati emaꞌai, irai ruu-ro aꞌai bia, kamia ruu-ro ereemaumodi bia-ra, ka ruu pairautu hiꞌa ororihoi aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Irai moto himoꞌa mereei umoo bia-ra, ruu epuuhoro dubui-ro raꞌu omaꞌati emaꞌai, kamia ruu-ro memiho aia maꞌai, ruu modobo-ka, keehibuo aibo ororihoi. Hiiroi emaꞌai mereei eito, hiiro-ri oroaroi-ka. Kamia hiiro hiꞌa emaꞌai mereei eito, hiiro hiꞌa-ri oroaroi-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Moo ai-pirooꞌu hepu geemai erai-da adiai, ka moo rio-ka ara erai iradi ma oomahoroi! ");
INSERT INTO kiw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Moo temetemei-da ma romoꞌuumidioumoi-ri romotii, ka pauo iraromoi odai aꞌai moropoiꞌo! ");
INSERT INTO kiw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Riꞌo iraromoi-da, moo miroi aromooꞌu ara hepu geemai eito? Abiarie, miroi bia, irai himia orootoodei! ");
INSERT INTO kiw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Doꞌou ara ipi-da, imodau iiꞌai aꞌai himioi, maamu, abea, meree, tu-hapuoi-to orootoodei aꞌai kaumo, retoꞌa-gaaꞌui-ro (3) retoꞌai (2) imoamoi aꞌai kaumo, kamia retoꞌai-ro (2) retoꞌa-gaaꞌui (3) imoamoi aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Abeamiꞌoi-ro ohio mereei imoamoi aꞌai kaumo, ka ohio mereei-ro abeamiꞌoi imoamoi aꞌai kaumo. Maamiꞌoi-ro buhe mereei imoamoi aꞌai kaumo, ka buhe mereei-ro maamiꞌoi imoamoi aꞌai kaumo. Daamiꞌoi-ro eteamiꞌoi imoamoi aꞌai kaumo, ka eteamiꞌoi-ro daamiꞌoi imoamoi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu aaꞌoi-ka uubi eito, “Riꞌo-ro bubui aia meaꞌaa duumo, himioi ooruo hapuoi-da ioroi-da, riꞌo-ro gaaꞌu hiꞌa-ha aaꞌoi aꞌai kaumo, ‘Mihaei ooꞌui aꞌai,’ kiauka mihaei aiha ooꞌui-ka. ");
INSERT INTO kiw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kamia riꞌo-ro aia mereaꞌaa duumo, hapuo atai koroboi omumui-da, ka riꞌo-ro aaꞌoi-ka, ‘Mati erara-ro oohiai aꞌai.’ Kiauka, erarai-ro oohiai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Riꞌo daea uubi-ka! Riꞌo-ro hepu-ra aromo-rai imiaꞌaa duumo, riꞌo umoo-ka raꞌu-ro oobodi maꞌai, irai raꞌu mabu-ra riꞌo-ro ara himioi orododiai raarai ihahai umoo iiꞌi tiato? ");
INSERT INTO kiw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Riꞌo-ro himia ma eaꞌaumo, mea ododiai raai raꞌu-ra? ");
INSERT INTO kiw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Meree ata-ro, roo aia meemehiipo, pauoi-to ma emahibai idomoiai-ri, roo omodau toe-ka, bubu uubi hohooi eito. Roo-ro aꞌai tiato-ra, roo oaredioi aꞌai kaumo, bubu uubi hohoo reꞌei eito, ka ruu-ro roo imaꞌai aꞌai idi uubi eito. Kaida roo edeꞌai aꞌai kaumo, duꞌi motoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ka roo hieꞌei-da, emidioi aꞌai modau-die, roo iaraa mori gaaꞌui-da, taꞌii maꞌai-die.” ");
INSERT INTO kiw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aaꞌo himioi-da uubi aamiꞌa, hieꞌei-daka, rii-ro poduuꞌaimo Iesu, Pirato-ro Garereia uubi iimoto emerai, Iehomai-do poue raarai iemaꞌatidioumoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu-ro rii imoaimai-ka, “Ire Garereia uubi aaꞌo emerai gaboato agimotoumo, riꞌo iraromoi-da, rii memiho hiꞌa uubi-ra, aamiꞌa Garereia uubi rautu idoboai-da? ");
INSERT INTO kiw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Abiarie! Ka riꞌo moo-ro ai-riduuꞌai, riꞌo ireheꞌeai tiato-ra memihoi-da, riꞌo rii rautu oroihi aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Raꞌaibou-ra ire eitiri (18) uubi iimotoi Siroamua-to, moto tutuu ata iirahiai, rii hoꞌui-da? Riꞌo iraromoi-da rii memiho hiꞌa uubi-ra, aamiꞌa Ierusarema uubi rautu idoboai-da? ");
INSERT INTO kiw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Abiarie! Ka riꞌo moo-ro ai-riduuꞌai, riꞌo memihoi-da ireheꞌeai tiato-ra, ka riꞌo rii rautu oroihi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ka Iesu-ro rii ara obeegiri imoaduꞌoi-ka, “Dubu ata ai-pemidio, ruu hura iiho ruꞌa ata, mire paꞌeai-da potii. Ruu ai-poroaꞌoiadio ruꞌai hura ma imeeꞌai-ri, irai hura imeeꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ka ruu paꞌeai iemeaꞌa mereei eito aaꞌoi-ka, ‘Moo retoꞌa-gaaꞌu (3) burio tauo pirorooho, ara ruꞌai-da hura ma rimeeꞌai-ri, irai moo-ro, ata hura iohuiato imeeꞌa bia. Ita eꞌebo, ruu-ro hepui meai hobou eidai.’ ");
INSERT INTO kiw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Irai paꞌeai ieaꞌaa mereei-ro pomoaimai, ‘Dubu-o, tauo emeheai, burio gaaꞌu ata, moo-ro mabui emauhuuti raꞌai, ka romomoohi roro hepu ata-to. ");
INSERT INTO kiw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kaida ruꞌai hura amimamirai goroi burioi-da, meaha-ka, ii tuaha-ra, ka emeꞌeboi raꞌai.’” ");
INSERT INTO kiw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabati ataato, Iesu ai-pimatomudio idabu motoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ka oobo ata, memiho urioi-ro tuupi ai-paamia eitiri (18) burioi-to, hieꞌei-daka. Aaꞌo ooboi gamoꞌo-ha otooꞌai modobo bia. ");
INSERT INTO kiw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu-ro ruu iemeeꞌai-da, ahoꞌootiai-ka, ruu ma ooꞌui-ri, ida poduuꞌai, “Oobo-o, roo doꞌou gimoi-ro, emeheaiꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ka Iesu tui ruu hoꞌui-da ideꞌai-da, ruu aiha pitooꞌa gamoꞌo-ha, kiauka Iehoma emarahuei-ka. ");
INSERT INTO kiw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Irai, idabu motoi epuuhoro dubui, iha udoi paꞌai, Iesu-ro meree ata Sabati-da iodomoiai-ri, kaida ruu-ro aaꞌoi-ka uubi eito, “Rimoi-doi, tikiti (6) himio-ka ma romaꞌatimo, ka aaꞌo himioi-da, riꞌo ma ooꞌui idomoiatidioi-ri, ii Sabati-da ooꞌui bia!” ");
INSERT INTO kiw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Paidubui-ro rii imoaimai-ka, “Riꞌo daea uubi-ka! Riꞌo meree ata modobo-ka boromokau, kamia doriki, omohuuꞌoi kekai eito, Sabati-da obo ma idioi-ri! ");
INSERT INTO kiw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ka ara ooboi Aberahamo aramui-ka, Satari-ro paamia eitiri (18) burioi-to, ka ruu modobo-ka, Sabati-da odomoiai!” ");
INSERT INTO kiw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu-ro rii iimoaimai madei-ro, ruui-do heamo uubi hiipo hiꞌa-ha pidodiai, ii aamiꞌai geꞌii hiꞌai paꞌaimo, ruu iaꞌai raara meameai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iesu-ro aratohetai-ka, “Iehoma pai emidio erarai raꞌaibou-rie? Moo-ro raꞌu ato odoboai raꞌai? ");
INSERT INTO kiw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ka ruu araibau-ka, dubu ata-ro keehibuo hiꞌa ruꞌa hura, ma aroi hepui-da, ka aaꞌo raa matei iiꞌi-da, ruꞌa-ro amorododiai, ka momoꞌoi motoi aaꞌo ruꞌai ekei-da, ititi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ata Iesu-ro aratohetai-ka, “Iehoma pai emidio erarai, moo-ro raꞌu ato odoboai raꞌai? ");
INSERT INTO kiw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ka ruu araibau-ka, oobo ata-ro hiiro hiꞌa parama, paramai iaupai muramurai rautu ma iaꞌomei, ka paramai geema iiꞌi aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu goꞌoto-goꞌotoi, imatomudio-ha podau, ruu iodau modoboi Ierusaremai-to. ");
INSERT INTO kiw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Meree ata-ro Iesu atohetai-ka, “Paidubu-o, kiauka-ra, retoꞌati uubi beha-ra, ee aamiꞌai imoabai amaꞌai?” Iesu-ro aaꞌoi-ka rii-do, ");
INSERT INTO kiw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pauoi-to ma emahibai gohe keehi ma odoro, mabu hiiro uubi-ro emahibai aꞌai kaumo iidoi, irai modobo ooꞌai aꞌai bia, rii ma iidoumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Irai, motoi abeai eibuai-da birii aia momoopai, ka riꞌo birii amaꞌedei oomahoroi aꞌai kaumo, ida aaꞌoi aꞌai kaumo, ‘Epuuhoro dubu-o, rimo birii rimaꞌerai, ma riidoumo!’ Ruu-ro aaꞌoi aꞌai, ‘Moo umoo bia riꞌo, riꞌo raati-da mooꞌu duumo.’ ");
INSERT INTO kiw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kaida riꞌo-ro omoaimai aꞌai kaumo, ‘Rimo roo rautu iiho idioi piraꞌaimo, roo-ro pirimatomudio, rimo himia goꞌotoi-da!’ ");
INSERT INTO kiw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Irai ruu-ro ata aaꞌoi aꞌai, ‘Moo umoo bia riꞌo, riꞌo raati-da mooꞌu duumo, oodadeaimo moo reꞌei-da, riꞌo turiaha memiho raara idodiai uubi-ka!’ ");
INSERT INTO kiw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Aberahamo, Isaꞌako, Iakobo kamia Iehoma himogabo uubi iaꞌai aꞌai-da, Iehoma pai emidio erarai-da, riꞌo giri iimodoruuti rautu idebi iootoi aꞌai kaumo, riꞌo kekai eito iipeduai aꞌai-da. ");
INSERT INTO kiw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Uubi ooꞌui aꞌai kaumo turiaha mati-mati-da, emiꞌeituti aꞌai kaumo mahuai aꞌai-da, Iehoma pai emidio erarai-da. ");
INSERT INTO kiw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Amoromidio duumo, doꞌou boiꞌo-ra epuui-da, rii epuui-da iiꞌai aꞌai bia, kaida doꞌou boiꞌo-ra didimoi-da, rii epuui-da iiꞌai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Aaꞌo himioi-da, aamiꞌa Pariseia uubi iooꞌumoi-da, paaꞌoumo Iesui-do, “Roo ara mati ita emeeheai, ita odau mati atai-to, mabu Heroda rio-ka roo rituo-ha aiꞌiiai.” ");
INSERT INTO kiw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu-ro rii imoaimai-ka, “Odaumo ire buꞌi umui oduuꞌai, ‘Moo memiho urioi riibodidio, ka uubi rautu iridomoiatidio, doꞌou ara himioi-re toutui-re, ka aaꞌo didimoi-da, oropoiꞌoi aꞌai moo omaꞌati.’ ");
INSERT INTO kiw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Irai moo aiha rodau doꞌou, toutui-re, kamia ara himioti didimoi-re, mabu mea bia himogabo dubui, ata matiato iihiai, Ierusarema haato iihiai meaha-ka. ");
INSERT INTO kiw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ierusarema! Ierusarema! Roo-ro piimoto himogabo uubi, roꞌoa kopi-da iiamaꞌede, Iehoma-ro riꞌo iimetiodoai, made himoꞌa uubi! Hiiro himio, moo rio-ka, riꞌo turiaha, moo tamui-da ma rimoꞌomaatidio, kokoro maamui-ro, kokoro keekei imoꞌomaatidiodio emerai, ruu tamui goroi-da, irai riꞌo-ro moo omoaꞌue bia! ");
INSERT INTO kiw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Amoromidio duumo, riꞌo motoi muio iiꞌai aꞌai. Moo-ro riꞌo ihaha hiꞌai riduuꞌai, riꞌo-ro moo eaꞌai aꞌai bia modau-die, ida himio ata ooꞌui aꞌai, riꞌo-ro aaꞌoi aꞌai kaumo, ‘Iehoma meai ruu rautu-ka, boꞌu-ro mooꞌu Paidubui pairai-da.’” ");
INSERT INTO kiw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabati ata-to, Iesu ai-podau Pariseia uubi epuuhoro dubu ata, motoi-da ma iihoidoi-ri, kamia uubi-ro ihaha pemaꞌotidioumo, ruu aꞌai raa ma emeeꞌaumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Oto-ra tu-rai iaupaimo dubui hieꞌei-da emeeꞌai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kaida piatohetai Iesu-ro, bubui imatomudioumo uubi, Pariseia uubi rautu, “Rimo bubui-da modobo-ra, Sabati-da uubi idomoiatidioi, ee modobo bia-ra?” ");
INSERT INTO kiw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Irai rii piroha piiꞌimo. Iesu-ro aaꞌo dubui, oꞌapuai-ka, iodomoiatidio, ka aiha potiodoai. ");
INSERT INTO kiw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kaida piatohetai, “Sabati-da riꞌo meree ata meree ohioi, kamia boromokau, boboi-da aia moohuꞌumatidio, roo-ro hioi-to omioi amaꞌai?” ");
INSERT INTO kiw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Irai rii-ro, modobo bia ruu madei omoaimai. ");
INSERT INTO kiw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu-ro umoo iiꞌi-ka, iiamaꞌue uubi-ro totoi-da meamea mati-ha iarahoꞌoutimoi, ka ruu-ro obeegiri imoaduꞌoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Roo meree ata-ro aia maamaꞌue, oobo-ra dubu-ra idabuai mahuai eito, mea mati haato emiꞌei bia. Aamiꞌa himioi, oobodii aꞌai roo pai-ro omiorai pai, aamaꞌuei aꞌai kaumo, ");
INSERT INTO kiw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kaida riꞌoiti gaaꞌu-ha iamaꞌue mereei ooꞌui-da, roo oduuꞌai aꞌai, ‘Ire mati omoameheai.’ Kaida roo hiipo hiꞌai ereaꞌai aꞌai, ka roo goro hiꞌai-da emiꞌei aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kaida roo aia maamaꞌue duumo ma odai goro hiꞌai mati ataato ma emiꞌei, ka roo aamaꞌue mereei ooꞌui-da rooi-do aaꞌoi aꞌai, ‘Abeata-o, eibua ara mati eito.’ Ka roo pairai emaabei aꞌai kaumo aamiꞌa iiamaꞌue uubi hohoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Boiꞌo-ro morododiai duumo rii himia pai, rii iimoruoi aꞌai kaumo, kamia boiꞌo-ro iimoruoumo, rii pai idodiai aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ka Iesu-ro iiamaꞌue mereei eito aaꞌoi-ka, “Roo-ro himio tuia du, kamia adimo du, amimaꞌai, roo riaraamui iamaꞌuei bia, roo taitai hiꞌai uubi-re, roo riamiꞌoi-re, roo raamiꞌoi-re, roo ora-gaaꞌu-ha uubi-re, kamia roo raara hiiro riaraamui-re, mabu rii-ro roo kama aamaꞌuei aꞌai kaumo, aaꞌo emerau-da, roo taꞌii aꞌai aꞌai kaumo, roo raꞌu ododiai rii-do. ");
INSERT INTO kiw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Roo mahuai aꞌai-da, raara tiato uubi, dabu uubi, tuupi hapuoi ioroihiimo uubi, ka idomai tiato uubi ma iamaꞌuei, ");
INSERT INTO kiw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ka roo meai eidai aꞌai, mabu rii-ro roo kama omoaimai aꞌai bia. Iehoma-ro, roo taꞌii omoaimai aꞌai, meaha iemidioumo uubi rituoi-da ireibuai aꞌai himioi-da.” ");
INSERT INTO kiw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iiamaꞌue uubi ata-ro, gaaꞌu-ha iihoumo mati-da, ara madei ai-poromidio, ruu-ro aaꞌoi-ka Iesui-do, “Geꞌii hiꞌa-ro ooꞌai aꞌai mahuai-da emiꞌeituti aꞌai uubi eito, Iehoma pai emidio erarai-da!” ");
INSERT INTO kiw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu-ro aaꞌoi-ka ruui-do, “Dubu ata-ro geega mahua paꞌai, ka hiiro uubi piamaꞌue. ");
INSERT INTO kiw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mahuai himioi iohiai-da, ruu raa himoꞌa mereei otiodai-ka, ruu-ro iiamaꞌue uubi iduꞌaituti, ‘Ooꞌumo, raarai-da riꞌo turiaha tauo imaumodii maaka.’ ");
INSERT INTO kiw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Irai omahoroumoi-ka, iiorobodoumoi-da, aamiꞌa orohodi made aaꞌoi, epuui mereei-ro aaꞌoi-ka, ‘Moo hepu reidai-die, ida eaꞌai odai raꞌai, moo giiꞌepu madei roaidai.’ ");
INSERT INTO kiw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Atai-ro aaꞌoi-ka, ‘Moo teri (10) boromokau rimidai-die, moo ai-rodau rii imahibai, ida moo giiꞌepu madei roaidai.’ ");
INSERT INTO kiw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ata gaaꞌui-ro paaꞌo, ‘Moo ooboi doꞌou romia maaka, ida moo ooꞌui aꞌai bia.’ ");
INSERT INTO kiw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ka moto himoꞌa mereei iaraimai-da, turiaha raarai aiha pomoaduꞌuti epuuhoro dubui eito, ka ruu iha udoi paꞌai, ida paaꞌo, ruu moto himoꞌa mereei eito, ‘Hioi-to odau gabo geegai, kamia goꞌotoi gabo keekei eito, ka iꞌopo raara tiato uubi-re, tuupi hapuoi ioroihiimo uubi-re, dabu uubi-re, ka idomai iaꞌa tiato uubi-re.’ ");
INSERT INTO kiw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kiauka, moto himoꞌa mereei-ro aaꞌoi-ka, ‘Dubu atau-o, roo-ro imaaꞌo emerai tauo-ha orododiai maaka, irai ruuꞌai hiaꞌei imooꞌa.’ ");
INSERT INTO kiw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Epuuhoro dubui-ro aaꞌoi-ka, ruu moto himoꞌa mereei eito, ‘Odau, hepu geegai gaboi-re, ka aamiꞌa oto gaboi eito, uubi pupuoi-to iduꞌaituti, ma ooꞌumo moo motoi huru ma iiꞌi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Riꞌo moo-ro ai-riduuꞌai, moo-ro epuui-da iiriamaꞌue uubi mereei ata-ro moo adimo dui, topo odoboai aꞌai bia.’” ");
INSERT INTO kiw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Himio ataato, hiiro hiꞌa uubi Iesu rautu pimadaꞌuimo, ruu iereemeteai-da paaꞌo rii-do, ");
INSERT INTO kiw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Meree ata aia mooꞌu mooi-do, ida ruu moo-ro ematomudio meree iiꞌi amiraromo, ruu abea-ra maamu-raire, oobo-ra meree keeke-raire, raamiꞌo-ra mabiamiꞌo-raire, kamia ruu himia hiꞌa oroiꞌioi-re, kekai-da ma ideꞌai, ka ruu moo-ro ematomudio meree iiꞌi modobo-ka. ");
INSERT INTO kiw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Riꞌo boiꞌo-rie satauroi iaꞌotatidio tiato, kaida moo didimoi-da moo ma robodoumo, riꞌo modobo bia moo-ro imatomudio meree iiꞌimoi. ");
INSERT INTO kiw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Riꞌo meree ata moto tutuu ma ididi-ri aia meremaumodi, epuui-to roo emiꞌei aꞌai, ka emeꞌuioi aꞌai mori modoboi, roo moto tutuui ma opoiꞌoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kamia roo mori modobo bia-ra, roo moto tutuui opoiꞌoi aꞌai bia, goroi ododiai oropoiꞌoi-da, ka turiaha boiꞌo-ro meaꞌa duumo raꞌu-ro morododiai, roo mari emaꞌai aꞌai kaumo, mabu roo motoi opoiꞌo bia. ");
INSERT INTO kiw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Rii-ro aaꞌoi aꞌai kaumo, ‘Roo moto tutuui ididi tauo poomahoro, irai omaꞌati opoiꞌoi modobo bia.’ ");
INSERT INTO kiw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Gaaꞌu aibo-ka, paidubu ata aia moobodi teri tauseri (10,000) beha uubi rautu, ma araiꞌiai-ri paidubu atai tueriti tauseri (20,000) dubui rautu, ka ruu araiꞌiiai eito odau tiatoi-da, ruu emiꞌei aꞌai, ma iraromoi-ri, ruu pupuoi modobo-ra, ata paidubui rautu ma araiꞌiaidoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kamia ruu modobo tiato-ra, ka made himoꞌa uubi itiodoai aꞌai, paidubu atai ma emeeꞌaumoi-ri, ka miroi ma ododiaimo ruu taitai eito oohiꞌia tiatoi haato.” ");
INSERT INTO kiw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iesu-ro madei opoiꞌoi-ka, “Aaꞌo emerai gaboi-da, roo ioohiidio raarai imeheai bia-ra, roo modobo bia moo-ro ematomudio meree iiꞌi.” ");
INSERT INTO kiw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Damerai meai meaha-ka, irai ruu himia meai aia moropoiꞌo, ata gabo ooꞌa bia, damerai ruu himia meai ata ma orododiai. ");
INSERT INTO kiw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Aaꞌo damerai mea bia, raa matei imomohi hepu toꞌoi eito, iipeduai aꞌai kekai eito. Ida riꞌo hepato rautu-ra oromidioumo.” ");
INSERT INTO kiw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ata himioi taketi imoamee uubi, kamia aamiꞌa memiho oroiꞌio uubi rautu, ai-pooꞌumo Iesu oromidioi. ");
INSERT INTO kiw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ka Pariseia uubi, bubui imatomudio uubi rautu, piro-piro made aaꞌoi oomahoroumoi-ka, “Ara dubu, memiho uubi geꞌii rautu imiꞌopo, kamia rii rautu imiiho!” ");
INSERT INTO kiw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ka Iesu-ro rii ara obeegiri imoaduꞌoi oomahoroi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Riꞌo meree ata haridere gaaꞌu (100) mamoei ma iaꞌai, ida gaaꞌubuo ata ma araatoai, ka roo raꞌu aꞌai maꞌai? Ka roo-ro rairiti-rairi (99) imeheai aꞌai, hauꞌii-da. Ka odai aꞌai iaraatoai gaaꞌui oohoi, modau-die memeeꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Roo-ro emeeꞌai aꞌai-da, geꞌii hiꞌa rautu, berai-da aaꞌotai aꞌai, ");
INSERT INTO kiw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","momooꞌu-die goꞌotoi eito, kaida iahoꞌoi aꞌai roo riaraamui-re, roo taitai uubi-re gaaꞌu-ha, ida aaꞌoi aꞌai rii-do, ‘Moo geꞌii hiꞌa-ka, moo iaraatoai mamoei tauo remeeꞌa maaka. Ooꞌumo geꞌii ma raꞌaimo!’ ");
INSERT INTO kiw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aatu emerai-ka, riꞌo moo-ro ai-riduuꞌai, aromoi-da geꞌii hiꞌa-ro ooꞌai aꞌai, gaaꞌubuo hiꞌa memiho oroiꞌio mereei ereheꞌeai-da, imaabee rairiti-rairi (99) uubi geꞌii aibo bia, boiꞌo-ro iraromoumo, rii tauo pireheꞌeaimo.” ");
INSERT INTO kiw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kamia oobo ata teri (10) mori hura-hura rautu-ra, ida aamaatoai ata gaaꞌui, ruu raꞌu aꞌai maꞌai? Ruu-ro ramepai adiai aꞌai, ka ramepai hehei-da motoi otobioi aꞌai, mea hiꞌa-ha oohoi aꞌai, modau-die memeeꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ida ruu-ro emeeꞌai-da, ruu riamabiai-re, ruu riaraamui-re, kamia ruu taitai uubi-rei rautu, turiaha iahoꞌooi aꞌai gaaꞌu-ha, ida aaꞌoi aꞌai rii-do, ‘Moo geꞌii hiꞌai-ka, moo iaraatoai mori tauo remeeꞌa maaka. Ooꞌumo, geꞌii ma raꞌaimo!’ ");
INSERT INTO kiw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Aatu emerai-ka, riꞌo moo-ro ai-riduuꞌai, Iehoma arerui geꞌii hiꞌa-ka, gaaꞌubuo memiho oroiꞌio mereei ereheꞌeai-ri.” ");
INSERT INTO kiw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ida, Iesu-ro paaꞌo, “Dubu ata, ruu meree ohioti rautu-ka. ");
INSERT INTO kiw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Riai-ro aaꞌoi-ka ruui-do, ‘Aba-o, moo paira raarai romotoodeai doꞌou.’ Ka aaꞌo dubui-ro, ruu raarai itoodeai-ka riiti ipituiai-da, riiti paipai. ");
INSERT INTO kiw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Himio aamiꞌa, ioropoiꞌoumo didimoi-da, riai raarai mori-to pomoaameumo, ka aaꞌo mori rautu, goꞌotoi emeheꞌai-ka. Ruu aiha podau auꞌo hiꞌa hepu atai-to, ka mori aiha pipoiꞌo, ereemaabe tiato oroiꞌioi-da. ");
INSERT INTO kiw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ruu raarai ioropoiꞌoi haato, aaꞌo hepui-da, du tiato himioi oohiai-ka, ka aaꞌo himiou-da ruu ata raa oromoameheai bia. ");
INSERT INTO kiw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ka ruu odai-ka, aaꞌo hepui dubu atai-do, omaꞌati. Ka aaꞌo dubui-ro, ai-potiodoai ruu paꞌea geegai eito, boomoi ma emeaꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ruu dui bobo hiꞌa paꞌai, ka ruu rio-ka boomoi iihoumo birii hurai ma iihoi. Mabu meree ata-ro, ruu uuho raa ata emaꞌai bia, ma uuhoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iarai-da, ruu mooꞌui imaimai-ka, ida poromoaduꞌo ruu himiai-do, ‘Turiaha moo abeai eito taꞌii-ri omaꞌati uubi, geemaꞌeema hiꞌai imiiho duumo, irai moo ara hiou-da, dui boboi iihiai raꞌai! ");
INSERT INTO kiw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Moo eibuai aꞌai-da, odai raꞌai, moo Abeai eito, ida aaꞌoi raꞌai, “Aba-o, moo Iehomai-re, rooi-re, riꞌoiti hohoi-da, memiho piraꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Moo modobo bia roo-ro, roo mereei-to ma rahoꞌo, moo rooi-do taꞌii-ri omaꞌatimo meree gaaꞌu ata, aibo ita rododiai!”’ ");
INSERT INTO kiw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kiauka, ruu eibuai-ka, araimai abeai eito. “Ruu auꞌo hiꞌai haato, pemeeꞌa abeai-ro, ka kaukai-da giiꞌepu hiꞌa pemaꞌai, iaahootiai-da emaiꞌiimai-ka, aiha pohomeai. ");
INSERT INTO kiw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mereei-ro aaꞌo-ka, ‘Aba-o, moo Iehomai-re, rooi-re, riꞌoiti hohoi-da memiho piraꞌai, ida modobo bia moo, roo mereei-to ma rahoꞌoo.’ ");
INSERT INTO kiw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Irai abeai-ro, ruu moto himoꞌa uubi iahoꞌootiai-ka, ruu-ro aaꞌoi-ka, ‘Hioi-to, muari hiꞌa hipura, omomooꞌumo, ma atimaimo, tui kakahii garaa omioumo, oto tama omiourioumo. ");
INSERT INTO kiw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ka odaumo, mea hiꞌa daꞌodaꞌo, roro boromokau, omooꞌumo, aiꞌiiaumo, ka geꞌii, mahua rautu ma raꞌaimo! ");
INSERT INTO kiw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mabu, ara moo mereei, tauo piihiai, irai doꞌou ruu ai-oroiꞌio, ruu ai-paraatoai, irai ruu tauo remeeꞌa maaka.’ Kiauka, mahua-ra gama-rai aiha poromahoro. ");
INSERT INTO kiw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Aaꞌo himioi, raamu-abeai hauꞌii-daka. Ruu iaraimai-da, motoi taitai-ro ioohiai-da, gama-ra hete-rai diamoi-ha, piroomai. ");
INSERT INTO kiw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ka ruu-ro, moto himoꞌa meree atai, ahoꞌotiai-ka, ida, patohetai, ‘Raꞌu maꞌai duumo?’ ");
INSERT INTO kiw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Moto himoꞌa mereei-ro omoaimai-ka, ‘Roo riai, tauo araimai maaka motoi eito, ka roo abeai-ro, mea hiꞌa daꞌodaꞌo, roro boromokau aiꞌiia maaka, mabu roo riai mea hiꞌa-ha araimai maaka.’ ");
INSERT INTO kiw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Raamui iha udoi paꞌai, ka motoi eito odoro bia, ida pohuuꞌo abeai, oduuꞌai-ka, ma odoroi-ri rioi eito. ");
INSERT INTO kiw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Irai raamui-ro, ruu abeai omoaimai-ka, ‘Amoromidio, ara burio hiiroi, moo rooi-do piromaꞌati, taꞌii tiato-ha, roo moto himoꞌa meree aibo. Ka moo-ro, roo rio raa ata, ododiai tiato ooꞌa bia. Roo-ro, moo raꞌu remaꞌai? Gouti keehi ata bia, moo mahua ma raꞌai, moo riaraamui rautu. ");
INSERT INTO kiw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Irai, ara roo meree ohioi-ro, roo raarai imoi-da pomoapoiꞌo. Ka ruu imaraimai-da, mea hiꞌa daꞌodaꞌo, roro boromokau, emaiꞌiia maaka!’ ");
INSERT INTO kiw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Abeai-ro omoaimai-ka, ‘Moo meree, roo ara hiou-da emidio, moo rautu, turiaha himioi. Ka moo reꞌei iiꞌaa raarai, turiaha roo raara-ka! ");
INSERT INTO kiw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Irai meaha-ka, geꞌii ma raꞌaimo, mabu roo riai ai-piihiai, irai doꞌou ruu ai-oroiꞌio, ruu ai-paraatoai, irai ruu doꞌou tauo remeeꞌa maakaumo!.’” ");
INSERT INTO kiw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu-ro aaꞌoi-ka, ruu iimatomudio uubi eito, “Raara hiiro-hiiro dubu ata, ai-pemidio, ruu raa himoꞌa dubui-ro pemeaꞌaa raarai. Raara hiiro-hiiro dubui ai-poduuꞌaimo, ruu raarai iemeaꞌaa dubui-ro ruu raarai ai-pomohuꞌomai. ");
INSERT INTO kiw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kiauka, ruu ahoꞌootiai-ka rioi eito, ida paaꞌo, ‘Raꞌu-rie ara raau, moo-ro ai-riromidio, uubi reꞌei-da? Moo remaꞌai turiaha roo omaꞌati emerai geuai, mabu roo moo raara emeaꞌa meree aibo bia, doꞌou modau-die, ooꞌai aꞌai himioi eito.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ka raarai iemeaꞌaa dubui-ro, himia poromoaduꞌo, ‘Moo epuu dubui-ro, omodadeai aꞌai omaꞌati-da, moo raꞌu ododiai raꞌai? Moo pupuo hiꞌa bia, boboi iobuti, kamia moo hiipo-ka, uubi imoaroi. ");
INSERT INTO kiw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Iee, doꞌou moo umoo tauo riiꞌi maaka, moo raꞌu aꞌai raꞌai, ka moo omaꞌati emeheai-da, moo taitai uubi emidioi aꞌai kaumo, rii-ro moo rii motoi eito, geꞌii rautu oꞌopoi aꞌai kaumo.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ka raa himoꞌa dubui-ro, raarai iimaꞌati uubi iahoꞌoi-ka, ruu epuuhoro dubui, raarai ma omoaimutiimoi-ri. Ruu-ro meree atai atohetai-ka, ‘Roo reꞌei-da, moo epuuhoro dubui, raꞌaibou omoaimai-ro miiꞌa?’ ");
INSERT INTO kiw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ruu-ro omoaimai-ka. ‘Orime herei haridere (100) gaigarua.’ Raa himoꞌa mereei-ro poduuꞌai, ‘Roo omoaimai araa-rie, emiꞌei, ka pipiti-ha (50) iꞌati.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ka ruu-ro atai atohetai-ka, ‘Roo raꞌaibou omoaimai-ro mooꞌa?’ Ida ruu-ro omoaimai-ka, ‘Turiaha gaaꞌubuo tauseri (1,000), geegaꞌeega apoho uiti-ka.’ Ka raa himoꞌa mereei-ro, aaꞌoi-ka, ‘Roo omoaimai pepai araarie, eiti-haridere-ha (800) iꞌati.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Aaꞌo emerai iorododiaiai-da, memiho raara himoꞌa dubui, epuuhoro dubui-ro, ai-pemarahue, mabu raarai iemeaꞌaa dubui-ro, iododiai moꞌui, ruu-ro mea hiꞌa-ha, peaꞌaa. Ka ara hepui uubi moꞌui hiꞌa-ka, aamiꞌa uubi rautu raara idodiai, irai hehei uubi ibai bia.” ");
INSERT INTO kiw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kaida Iesu-ro paaꞌo, “Riꞌo moo-ro, ai-riduuꞌai, riꞌo himia riaraamu orododiaimo, ara hepui raarai rautu, ka aaꞌo raarai oropoiꞌoi aꞌai-da, riꞌo geꞌii rautu ma iiꞌopaimoi-ka, tutuu oroiꞌio motoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Boꞌu-rie, keeke raarai meaha imaaꞌotidioi, ka ruu-ro, geegaꞌeega raarai mea hiꞌa-ha, imaaꞌotidioi aꞌai. Kamia boꞌu-rie keeke raarai meaha imaaꞌotidio tiato, ka ruu-ro geegaꞌeega raarai mea hiꞌa-ha imaaꞌotidioi aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kamia ara hepui raarai, riꞌo-ro meaha imaaꞌotidio tiato-ra, ka riꞌo-ro meamea hiꞌa raarai meaha imaaꞌotidioi aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kamia dubii dubu ata, raarai riꞌo-ro emamaaꞌotidio tiato-ra, ka riꞌo himia raarai, imaꞌai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Raa himoꞌa mereei-ro, retoꞌa epuuhoro dubuoti, raa himoꞌa aꞌai modobo bia. Ruu-ro atai rio tiato emaꞌai aꞌai, ka ata behai rio emaꞌai aꞌai. Kamia roo-ro, Aiai Iehomai-re, mori-re, gaaꞌu-ha imoabai modobo bia.” ");
INSERT INTO kiw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pariseia uubi-ro, Iesu ioroaduꞌuti madei ioromidioumoi-da, mari pemaꞌaimo, mabu rii rio hiꞌa-ka mori, ");
INSERT INTO kiw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ida Iesu-ro aaꞌoi-ka, “Riꞌo aaꞌo uubi-ka, boiꞌo-ro miꞌatidio duumo, aamiꞌai idomai gaboi-da ma imarahueumoi-ri, irai Iehoma umoo-ka, riꞌo kaukai. Uubi-ro, riꞌo pai iraromo raarai, Iehoma idomai-da, hobou raa-ka. ");
INSERT INTO kiw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mose bubui-re, kamia himogabo uubi-ro iꞌatimoi-re, raꞌu iimatomudioumo imooꞌu, Ioare Bapatiso himioi eito, aaꞌo himiou didimoi-da, Aiai Iehoma pai emidio erarai, mea madei ai-pimoaduꞌutimo. Kamia hiiro uubi, pauoi-to iidoo toto aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Irai aahuu hiꞌa-ka, aromo-ra, hepu-rai, ma araatoaimo, ii modobo bia bubui hapuo keehi ata, omodadeai. ");
INSERT INTO kiw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Dubu ata ooboi aia memeheai, kaida oobo ata amomia, ruu imo aꞌai-ka, kamia boꞌu-ro momia emeheai ooboi, ruu rautu imo-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kaida pimoaduꞌo ara obeegiri Iesu-ro. “Raara hiiro-hiiro dubu ata, ai-porododiaitutidio, geemaꞌeema hiꞌa taꞌii hipurai-da, kamia ioroiꞌioi, hoꞌu hiꞌa poroiꞌio, turiaha himioi. ");
INSERT INTO kiw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kamia raara tiato dubu ata, ruu pairai, Rasaro, turiaha ruu tuupi umai haa-ro piiꞌa, ruu ai-poaꞌoiadioumo raara hiiro-hiiro dubui, birii eito. ");
INSERT INTO kiw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ruu rio aꞌai-ka, raara hiiro-hiiro dubui, araaho iiho du toꞌurei, ma iihoi-ri, kamia umui ooꞌumoi-ka, ruu umai ma ohomeumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ka raara tiato dubui iihiai-ka, ka arerui-ro, ruu urioi aiha pomodaumo Aberahamo taitai eito. Kaida raara hiiro-hiiro dubui rautu aiha piihiai, uuꞌumaimoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kaida, giimui uubi reꞌei-da, geega temeteme paꞌai, ida iimaromiai-da, pemeeꞌa Aberahamo auꞌo hiꞌai-da, Rasaro ruu kekai-da pemidio. ");
INSERT INTO kiw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kaida geega madei-to paaꞌo, ‘Aba Aberahamo, moo giiꞌepu remaꞌai! Rasaro otiodoai tu hurai oboi-da ma odobiai, ka moo totobei guuaꞌo ma rododiai, mabu moo temeteme hiꞌa-ka, ara erai tuiai-da.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Irai Aberahamo-ro, omoaimai-ka, ‘Moo meree, roo-ro amiraromo, roo ioroiꞌio himioi-da, rooi-do meamea hiꞌa raarai-ro piiꞌa, irai Rasaroi-do memiho hiꞌa raarai-ro, piiꞌa. Ka ruu doꞌou geꞌii-daka, ahiou-da, kamia roo, temetemei-daka, irehieꞌei-da. ");
INSERT INTO kiw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kamia ire gomo hiꞌa boboi ireirie rimo ipituiai-da, kaida boꞌu rio-rie ooꞌui, modobo bia, kamia modobo bia meree ata ma aabui roo hapuoi eito.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Raara hiiro-hiiro dubui-ro aaꞌoi-ka, ‘Aba Aberahamo, moo ai-roroaro, Rasaro otiodoai ma odai, moo abeai motoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Moo riamiꞌoi tu-hapuo (5) ohiobaiꞌo-ka, moo rio-ka ruu ma odai, rii umoo idodiai, rii ooꞌu toe-ka temeteme mati eito.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Aberahamo-ro aaꞌoi-ka, ‘Mose, kamia himogabo uubi, iꞌatimo madei rii umoo-ka, rii-ro ma oromidioi.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Raara hiiro-hiiro dubui-ro, omoaimai-ka, ‘Irai, Aba Aberahamo, meree ata aia meibua, iihiai-da, ka ma odai-ri, rii iduuꞌai, ka rii ireheꞌeai aꞌai kaumo, memihoi-da.’ ");
INSERT INTO kiw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Irai Aberahamo-ro aaꞌoi-ka, ‘Rii Mosei-re, kamia himogabo uubi-rei eito iroomidio tiato-ra, ka iihiai-da eibuai aꞌai mereei, madei oromidioi aꞌai bia.’” ");
INSERT INTO kiw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu-ro ruu iimatomudio mereei eito aaꞌoi-ka, “Uubi memihoi-da iiraahioi aꞌai raarai ai-iobodiituti kaumo, irai memiho hiꞌa-ro ooꞌai aꞌai, aaꞌo erematuhuti oomahoroi aꞌai mereei eito. ");
INSERT INTO kiw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Memiho-ka meree ata gigii-da, roꞌoa kopi geega otohiai, ka tibiri tuiai-da ma epeduai, irai memiho hiꞌa-ro ooꞌai aꞌai meree keehi ata boꞌu-ro momodau memiho raara ma aꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaida meaha ma ereaꞌai roo raꞌu maꞌai. “Kamia roo riaraamui memiho oroiꞌio amaꞌai, erehei-to ma otomui, ida ruu memiho oroiꞌioi aia memeheai, ka ruu memihoi ma emapihiti. ");
INSERT INTO kiw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kamia rooi-do memiho oroiꞌio amaꞌai, himio gaaꞌui goroi-da semeri (7) modoboi-to, ka orooho semeri (7) himio gaaꞌu-gaaꞌui-da, ruu-ro aia maaꞌotuti, ‘Moo memiho oroiꞌioi tauo pirimeheai’, ka roo-ro ruu memihoi ma emapihiti.” ");
INSERT INTO kiw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iiapui made himoꞌa uubi-ro aaꞌoi-ka, Paidubui eito, “Rimo pupuo iraromoi geegaꞌeega rimododiai.” ");
INSERT INTO kiw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Paidubui-ro imoaimai-ka, “Riꞌo pupuo iraromoi hiꞌuai hura keekei aibo-ra, ka riꞌo-ro ara ruꞌa geegai oduuꞌai aꞌai kaumo, ‘Roo aaꞌuubai hipi rautu turiaha, ka odau tibiri tuiai-da ma araraaro,’ ka ruu-ro, roo aaꞌo modoboi ododiai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Kamia riꞌo gaaꞌubuo ata, himoꞌa meree rautu-ra, ida hepui ma auhioi, ee, mamoei ma iaꞌai hauꞌii-da, ida aaꞌo reꞌei-da araimai-da, roo-ro ruu oduuꞌai amaꞌai, dui hioi-to ma iihoi-ri? ");
INSERT INTO kiw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Abiarie! Modobo bia! Roo-ro ruu oduuꞌai aꞌai, ‘Moo adimo dui remaumodii, meaha orododiai, ka roo dui iito hipurai oromio, ka moo roomoto, moo riiho-ka, riidio-ka, roo dui didimoi-to iihoi aꞌai.’ ");
INSERT INTO kiw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Himoꞌa mereei, iraromoi aꞌai bia epuuhoro dubui-ro, keito made ma emaꞌai ruu rioi ododiai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aaꞌo emerai-ka roo rautu, roo ododiai-ri oduuꞌai raarai turiaha aia midodiai, ma aaꞌoi, ‘Rimo raa himoꞌa uubi beha-ka, rimo himia omaꞌati raꞌai kaumo.’” ");
INSERT INTO kiw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu gaboi iimadaꞌui-da, Samaria-ra, Garereia-rai, ieremahiaimo hiaꞌei-ha podau, Ierusaremai-to. ");
INSERT INTO kiw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Iesu goꞌoto ata podoro, ida pimeeꞌa, teri (10) dububaiꞌo mobibi gimoi rautu, rii auꞌoi haato pitooꞌutiimo. ");
INSERT INTO kiw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ida pai rautu madei-to paaꞌoumo, “Iesu-o! Epuudubu-o! Rimo giiꞌepu rimaꞌai!” ");
INSERT INTO kiw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu-ro, rii iimeeꞌai-da piduuꞌai, “Odaumo, Iehomai-do poue emaꞌatidio dubui-ro, riꞌo ma imaꞌeemuti.” Ka rii iodaumo goroi haato, tamai oodomoiaumoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ata gaaꞌui-ro himia iereemeeꞌai-da, ruu tauo-ha poodomoia, ka ruu iaraimai-da Iesui-do, Iehoma geegaꞌeega madei-to, pemarahue. ");
INSERT INTO kiw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ruu iimohorai-ka, Iesu oto reꞌei-da, keito made aaꞌoi-ka. Aaꞌo dubui Samaria dubu-ka. ");
INSERT INTO kiw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu-ro aaꞌoi-ka, “Ire hiei-da turiaha imodomoiaumo teri-da (10), rairi (9), heiꞌe-ra? ");
INSERT INTO kiw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mabui raꞌu-rie, mati ata meree haa-ro araimai, Iehoma emarahuei?” ");
INSERT INTO kiw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iesu-ro aaꞌo-ka ruui-do, “Eibua, odau, roo pupuo iraromoi-ro, roo mea tauo ododiai maaka.” ");
INSERT INTO kiw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Himio ata, Pariseia uubi aamiꞌa-ro, Iesu atohetaimoi-ka, “Iehoma pai emidio erarai raa himiou ooꞌui maꞌai?” Ruu-ro, rii imoaimai-ka, “Iehoma pai emidio erarai, roo-ro eaꞌai-ri iraromo emerai-da, eaꞌai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Meree ata-ro, araibau aaꞌoi aꞌai bia, ‘Emeeꞌa araarie!’ Kamia, ‘Auꞌoirie!’ Mabu Iehoma pai emidio erarai riꞌo reꞌei-da ireirie.” ");
INSERT INTO kiw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ida Iesu-ro ruu iimatomudio uubi eito aaꞌoi-ka, “Himio ata ooꞌui aꞌai, roo-ro rio hiꞌa aꞌai aꞌai, Uubihaubi Mereei ooꞌui aꞌai himioi ma eaꞌai-ri, irai roo-ro eaꞌai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aamiꞌai-ro aaꞌoi aꞌai kaumo riꞌoi-do, ‘Emeeꞌaumo, auꞌoirie!’ Kamia, ‘Emeeꞌaumo araarie!’ Irai odai bia kekai eito oohoi. ");
INSERT INTO kiw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aromoi hapuo atai-da, bereberei aia meremabeai, ruu hehei-ro aromoi adiai aꞌai, ka hehei aabui aꞌai hapuo atai eito, ka Uubihaubi Mereei himioi-da, aaꞌo emerau orododiai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Irai epuui-da, ruu geema hiꞌa riibo, omiꞌai aꞌai, ka maraibo duumo, doꞌou ara himioi uubi-ro. ");
INSERT INTO kiw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Roa himioi-da, iooꞌa emerai ooꞌai aꞌai, Uubihaubi Mereei himioi-da. ");
INSERT INTO kiw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Turiaha uubi, iiho idioi paꞌaimo, upi dubu iiorooboumo, ida pooꞌu aaꞌo himioi, Roa oroi-ka pee geegai-da, borei iooꞌui-da turiaha uubi aiha piimoto, rituo-rituo-ha. ");
INSERT INTO kiw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Roti himioi-da, iooꞌa emerai, turiaha uubi iiho idio, oroomoamee, iodouti, kamia ititi paꞌaimo. ");
INSERT INTO kiw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Irai aaꞌo himioi-da, Roti-ro, Sodoma goꞌoto geegai iemeheai-da, erai erara hiꞌa roꞌoa kopi-kopi rautu, aromoi-da mihaei emerai paaꞌo, turiaha aiha piimoto. ");
INSERT INTO kiw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aaꞌo emerai orododiai aꞌai Uubihaubi Mereei himioi ooꞌui aꞌai-da. ");
INSERT INTO kiw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Aaꞌo himiou-da, meree ata motoi ubui-dara, ruu ooꞌuoi aꞌai bia, motoi rioi-da raarai ma imidai-ri. Aatu emerai meree ata hauꞌii-dara, ruu araimai aꞌai bia motoi eito, raarai ma imidai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Iraromaimo Roti, ooboi! ");
INSERT INTO kiw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Boiꞌo-ro miraromo duumo, rii oroiꞌioi iraahoꞌoi, iatoai aꞌai kaumo, kamia boiꞌo oroiꞌioi miatoai duumo, rii oroiꞌioi iraahoꞌoi aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Riꞌo moo-ro ai-riduuꞌai araibau, aaꞌo duoi-da, retoꞌa mereeti, gaaꞌu-ha irobui aꞌai, atai eidai aꞌai, atai emeheai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Retoꞌa (2) ooboti, raa-hurai iatuꞌuti aꞌai kaido, atai eidai aꞌai, atai emeheai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iimatomudio mereei-ro, Iesu atohetai-ka, “Heiꞌe-rie, Paidubu-o?” Ruu-ro imoaimai-ka, “Rituo tuupi ratii-darie, oaꞌoai odabuai aꞌai kaumo, hiꞌei-da.” ");
INSERT INTO kiw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ka Iesu-ro ruu iimatomudio mereei obeegiri imoaduꞌoi-ka, rii ma imatomudioi-ri, rii turiaha ma irudemeumo aiboi, ka irudemei-da rii haꞌima aꞌaimoꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iesu-ro aaꞌoi-ka, “Goꞌoto ata-to ai-pemidio bubui umoo hiꞌa dubu ata, Iehomai-do toe iꞌatidio bia, kamia uubi imaabeedio bia. ");
INSERT INTO kiw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ka oobo himu ata, aaꞌo goꞌotoi-da pemidio, ruu ai-poroohodio, aaꞌo dubui eito, ruu kiritooto iemaꞌatidio mereei bubui-da ma omodadeai-ri. Ruu-ro aaꞌoi-ka, ‘Moo romoabai, moo meree ata-ro kiritooto remaꞌatidio!’ ");
INSERT INTO kiw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tutuu himio, ruu rio tiato piꞌatidio omoabai, irai iarai-da, ruu himiai-do oromoaduꞌoi-ka, ‘Moo Iehomai-do toe iꞌatidio bia, kamia moo uubi imaabeedio bia, ");
INSERT INTO kiw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","irai ara oobo himui-ro, turiaha himioi moo aiha romorooho, aaꞌo rau-ri, moo-ro eaꞌai raꞌai ruu odomoiai bubui-da. Mabu moo-ro aꞌai tiato-ra, ruu aiha oroohoi aꞌai, ka iarai-da, moo haꞌima ododiai aꞌai!’” ");
INSERT INTO kiw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ka Paidubui-ro aaꞌoi-ka, “Oromidioumo, ire bubui umoo hiꞌa dubui aaꞌo raai, irai ruu memiho-ka. ");
INSERT INTO kiw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ida Iehoma-ro, ruu himia uubi bubui-da imoabai amaꞌai, ruu himio-ra duo-raida atohei-ri, ma imoabai-ri? Modobo-ka. Kamia ruu-ro rii emera-ha imoabai amaꞌai? Abiarie, modobo bia. ");
INSERT INTO kiw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Moo-ro riꞌo ai-riduuꞌai, rii rioi-da bubui-da imoabai aꞌai, ka hio hiꞌai-to ododiai aꞌai. Irai Uubihaubi Mereei ooꞌui aꞌai-da, pupuo iraromo moꞌui emeeꞌai amaꞌai ara hepui-da?” ");
INSERT INTO kiw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aamiꞌa uubi-ro ai-piraromoumo, rii beha mea-ka, rii iraromoi-da uubi amiꞌai mea bia, kaida pimoaduꞌo Iesu-ro, ara obeegiri. ");
INSERT INTO kiw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Retoꞌa dubuoti, ai-piioido irudeme motoi-da irudemeai, atai Pariseia dubu-ka, atai taketi imoamee dubui-ka. ");
INSERT INTO kiw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Ka Pariseia dubui ruu himia-ha pitooꞌa, iirudemeai-da paaꞌo, ‘Iehoma-o, moo keito raaꞌo rooi-do, moo turiaha uubi aibo bia, moo iiho-toto meree bia, moo erematuhuti meree bia, kamia moo imo-dubu bia, kamia moo aire taketi imoamee dubui aibo bia. ");
INSERT INTO kiw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Moo puura gaaꞌui goroi-da retoꞌa himio, imaꞌui emidioi-ka, kamia moo puura gaaꞌui goroi-da, imeeꞌatuti teri (10) raarai-da, gaaꞌubuoi roo emaꞌai-ka.’ ");
INSERT INTO kiw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Irai taketi imoamee dubui auꞌo aibo haato pitooꞌa, ruu hohoi imaromia bia aromoi eito, gomoi aramaꞌedeai-ka, ida paaꞌo, ‘Iehoma-o, moo giiꞌepu remaꞌai, moo memiho meree-ka.’” ");
INSERT INTO kiw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iesu-ro aaꞌoi-ka, “Riꞌo moo-ro ai-riduuꞌai, riiti iodaidoi-da himia-himia motoi eito, Iehoma hohoi-da mea hiꞌa iiꞌi mereei taketi iimoamee dubui-ka, Pariseia dubui bia. Boiꞌo-ro, moroomomiourio duumo, rii ioruoi aꞌai kaumo, kamia boiꞌo-ro, moromomoruodio duumo, rii iioi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Uubi aamiꞌai, meree keekei ai-pimooꞌumo, Iesu tui rii hoꞌui-da ma iaaꞌoi-ri, kaida iimatomudio mereei-ro, ieaꞌaumoi-da erehe madei-to pimaaꞌoumo, ");
INSERT INTO kiw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","irai, Iesu-ro meree keekei aiha piahoꞌoo, ida paaꞌo “Imeheaimo, meree keekei mooꞌumo-ka mooi-do, mabu Iehoma pai emidio erarai, rii aibo uubi-ro eidai aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Moo-ro riꞌo ihaha riduuꞌai, boꞌu-ro eidai tiato maꞌai, meree keehi aibo, Iehoma pai emidio erarai, ruu-ro odoroi aꞌai bia.” ");
INSERT INTO kiw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iuda epuuhoro dubu ata-ro, Iesu atohetai-ka, “Mea imatomudio dubu-o, moo raꞌu ododiai raꞌai tutuu oroiꞌioi ma reidai-ri?” ");
INSERT INTO kiw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu-ro, ruu atohetai-ka, “Roo-ro moo raꞌu-ri meai-to rahoꞌoo? Meree gaaꞌu ata mea bia, Iehoma beha-ka. ");
INSERT INTO kiw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Roo umoo-ka Iehoma bubui, ‘Imo aꞌai bia, maꞌoamo aꞌai bia, piro aꞌai bia, meree ata paira ematuhuti aibo, ahoꞌoi bia, roo maamu-ra, abea-rai, ma imaabei.’” ");
INSERT INTO kiw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aaꞌo dubui-ro omoaimai-ka, “Moo keehibuoi imooꞌu doꞌou, moo-ro ara bubui turiaha tauo pirimaabedio.” ");
INSERT INTO kiw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu-ro aaꞌo madei ioroomai-da, ruui-do aaꞌoi-ka, “Gaaꞌu hiꞌa raa ireirie, roo-ro ma ododiai, roo reꞌei-da iiꞌaa raarai turiaha taꞌii-to ita omameumo, ka mori raara tiato uubi ita imaꞌati, kaida roo-ro, meamea raarai imeeꞌai aꞌai aromoi-da, ka ooꞌu, moo robodo.” ");
INSERT INTO kiw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Irai aaꞌo dubui-ro, ara madei ioroomai-da, ruu giiꞌepu hiꞌa paꞌai, mabu ruu raara hiiro-hiiro dubu-ka. ");
INSERT INTO kiw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu-ro, ruu giiꞌepu hohoi ieaꞌai-da, paaꞌo, “Aahuu hiꞌa-ka, raara hiiro-hiiro mereei-ro, Iehoma pai emidio erarai goroi odoroi, ");
INSERT INTO kiw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","aahuu-ka kameroi, iroi gaꞌerei ma odoroi, kaida aahuu hiꞌa-ka raara hiiro-hiiro mereei-ro, Aiai Iehoma pai emidio erarai goroi odoroi.” ");
INSERT INTO kiw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ioromidioumo uubi-ro, ruu atohetaimoi-ka, “Ka roo aaꞌo raarai ihaha-ro ooꞌaato, tutuu oroiꞌioi boꞌu-ro eidai maꞌai?” ");
INSERT INTO kiw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu-ro imoaimai-ka, “Raꞌu-rie modobo tiato raai uubi eito, Iehomai-do modobo-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kaida Petero-ro aaꞌoi-ka, “Ka ma emeeꞌa, rimo goꞌoto-goꞌotoi ai-pirimeheaimo, roo ma robodoumoi-ri.” ");
INSERT INTO kiw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu-ro aaꞌoi-ka rii-do, “Moo-ro, riꞌo ihaha riduuꞌai, meree ata-ro, goꞌotoi aia memeheai, ooboi-re, riaraamui-re, maamu-ra abea-raire, kamia mereei-re, Iehoma pai emidio erarai iraromoi-ri, ");
INSERT INTO kiw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ruu-ro hiiro hiꞌa meai imidai aꞌai ara ooꞌa himioi-da, ka tutuu oroiꞌioi, emaꞌai aꞌai ooꞌui aꞌai himioi-da.” ");
INSERT INTO kiw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu-ro ruu iimatomudio tuero (12) mereei, imodadeai-ka kekai eito, ida paaꞌo rii-do, “Oromidioumo! Rimo ai-riioo kaumo Ierusaremai-to, ka turiaha raarai iaha hiꞌai oobodi aꞌai kaumo himogabo uubi-ro iꞌatimo emerai Uubihaubi Mereei-ri. ");
INSERT INTO kiw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ruu emaꞌai aꞌai kaumo Iuda guui-da paira tiato uubi eito, ka madei-da emerioi aꞌai kaumo, omomoruodioi aꞌai kaumo, ka oobei-da mamouti duumo. ");
INSERT INTO kiw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ka rii-ro ruu ororihoi aꞌai kaumo, ka maiꞌia duumo rituo-ha, irai retoꞌa-gaaꞌu (3) himioi didimoi-da, oroitorai aꞌai oroiꞌioi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Irai iimatomudio tuero (12) mereei-ro, umoo iiꞌimo bia, ruu turiaha iaaꞌo raarai, madei iha hiꞌai ai-pimoapiꞌoma rii reꞌei-da, kamia rii-ro umoo iiꞌimo bia, Iesu ioroaduꞌuti raarai. ");
INSERT INTO kiw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu Ieriko taitai ioohiai-da, idomai tiato dubu ata, gaboi barai-da pemidio, ai-poroarodio. ");
INSERT INTO kiw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kaida piromidio uubi hiiroi iorohotutimoi-da, ruu-ro araatoi-ka, “Raꞌu maꞌai duumo?” ");
INSERT INTO kiw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rii-ro ruu oduuꞌaimoi-ka, “Rasareta dubui Iesu-ro orohodi.” ");
INSERT INTO kiw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ruu-ro geema madei-to aaꞌoi-ka, “Damida mereei Iesu-o, moo giiꞌepu remaꞌai!” ");
INSERT INTO kiw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iesu hoho reꞌei imadaꞌuimo uubi-ro udoi-to ai-pemaaꞌoumo, ka oduuꞌaimoi-ka piroha ma iiꞌi-ri, irai pairautu hiꞌa madei-to aaꞌoi-ka, “Damida mereei-o, moo giiꞌepu remaꞌai!” ");
INSERT INTO kiw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu iimadaꞌui-da, otoꞌai-ka, ida paaꞌo, “Omooꞌumo,” ka omooꞌumoi-ka Iesu taitai eito, Iesu-ro atohetai-ka, ");
INSERT INTO kiw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Roo raꞌu rio maꞌai, moo-ro ma romododiai?” Ka ruu-ro omoaimai-ka, “Paidubu-o, moo rio-ka ma riaꞌa.” ");
INSERT INTO kiw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu-ro aaꞌoi-ka ruui-do, “Ka iaꞌa! Roo pupuo iraromoi-ro, tauo odomoia maaka.” ");
INSERT INTO kiw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ruu idomai gaaꞌu hiꞌa-ha odomoiai-ka, kiauka aiha pomahoro Iesu obodoi, Iehoma emarahue-ha. Turiaha uubi-ro ieaꞌaumoi-da, Iehoma aiha pemarahueumo. ");
INSERT INTO kiw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu Ieriko iodoroi-da, goꞌotoi tuiai imadaꞌui omahoroi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aaꞌo reꞌei-da taketi iimoamee uubi epuuhoro dubu ata pairai-ka, Sakaio, ruu raara hiiro-hiiro dubu-ka. ");
INSERT INTO kiw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ruu rio-ka Iesu ma emeeꞌai, ruu boꞌu-rie, uubi hiiroi tuiai-da, irai modobo bia mabu ruu komubuo dubu-ka ");
INSERT INTO kiw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aaꞌo raꞌu-ri, ruu hioi-to podau rii epuui-da gaabi aibo ruꞌai pioro Iesu ma eaꞌai-ri, mabu Iesu aaꞌo reꞌei gaboi-ha orohodi aꞌai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu aaꞌo mati eito iooꞌui-da, imaromiai-da paaꞌo Sakaioi-do, “Sakaio, oruo hioi-to, mabu moo roo motoi-da emidioi raꞌai ara himioi.” ");
INSERT INTO kiw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakaio hio hiꞌa-ha pooꞌuo, ka Sakaio-ro Iesu geꞌii hiꞌa rautu poꞌopai. ");
INSERT INTO kiw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Turiaha iomahoroi-da, ieaꞌaumo uubi piro-piro made aaꞌoumoi-ka, “Ara dubui ai-odau memiho dubui motoi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakaio iotoꞌai-da paaꞌo, Paidubui eito, “Paidubu-o, oromidio! Moo raarai itoodei raꞌai raara tiato uubi ma rimaꞌati-ri. Kamia moo-ro meree ata aia rematuhia, ruu iroaidai raai omoaimai raꞌai, kamia ata retoꞌa-gaaꞌu (3), ruu hoꞌui-da, taꞌii aꞌai raꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ka Iesu-ro aaꞌoi-ka, ruui-do, “Ara motoi eito omoaabai, oroiꞌioi tauo ooꞌu maaka, ara himioi-da. Mabu ara dubui Aberahamo aramui ata-ka. ");
INSERT INTO kiw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Uubihaubi mereei ai-pooꞌu iaratoaimoi iohoi, ka ma imooꞌui oroiꞌioi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ida uubi-ro ara madei ioromidioumoi-da, Iesu-ro iemahurai reꞌei-da omahoroi-ka, ida pimoaduꞌo ara obeegiri. Ruu taitai hiꞌa-ka Ierusaremaato, kaida rii-ro ai-piraromoumo Iehoma pai emidio erarai ihaha-ka, oobodi aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaida Iesu-ro paaꞌo, “Hoꞌu epuuhoro dubu ata, ai-podau auꞌo hiꞌa hepui-to, Pai ma edeeꞌaumoi-ri, ka didimoi-to ma araimai goꞌotoi eito, pai ma emidioi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ruu emeheai tiatoi-da, ruu tuuoti (10) moto himoꞌa uubi iahoꞌotiai-ka, mori gaaꞌu-gaaꞌui iimaꞌati-da, piduuꞌai, ‘Ita oroomaemeumo, ara mori-da, moo odai aꞌai muioi-da.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ruu himia uubi-ro, rio tiato pemaꞌaimo, ruu pai ma emidioi-ri, ka aaꞌo raꞌu-ri, made himoꞌa uubi pemetiodoaimo, didimoi-da, pai epuuhoro dubui, ma omoaduꞌoumoi-ri, ‘Rimo rio bia ara dubui, rimo pai emidioi.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Aaꞌo dubui paidubu tauo pododiaimo, kaida iaraimai-da, made edeꞌai-ka, ruu moto himoꞌa uubi ma oobodimoi-ri ruu hohoi-da, umoo ma iiꞌi-ri raꞌaibou idodiaimo. ");
INSERT INTO kiw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Epuu mereei ooꞌui-ka, ida paaꞌo, ‘Paidubu-o, moo tuuoti (10) mori hura-hura piridodiai, roo-ro iremaꞌai mori gaaꞌui-da.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ruu-ro aaꞌoi-ka, ‘Mea hiꞌa paꞌai. Roo mea moto himoꞌa meree-ka. Roo keeke raarai-da iraromoi ooꞌai-ri, roo moo-ro tuuoti (10) paipai goꞌoto epuuhoro edeꞌai raꞌai.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Epuui moto himoꞌa mereei didimoi mereei, ooꞌui-ka, ida paaꞌo, ‘Paidubu-o, moo-ro tu-hapuo (5) mori hura-hura piridodiai, roo-ro iremaꞌai mori gaaꞌui-da.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aaꞌo moto himoꞌa mereei eito, ruu-ro aaꞌoi-ka, ‘Roo tu-hapuo (5) paipai goꞌoto epuuhoro aꞌai aꞌai.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ata moto himoꞌa mereei ooꞌui-ka, ida paaꞌo, ‘Paidubu-o, ara-rie roo mori, moo-ro ai-piremedeeꞌa, hipura keehi-da iretebeai. ");
INSERT INTO kiw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mabu roo aahuu dubu-ka, kamia roromo-ka, moo rooi-do toe piraꞌai, roo raa bia, irai eidai-ka, idoꞌoi-ka roo-ro iodouti tiatoi.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ruu-ro aaꞌoi-ka aaꞌo mereei eito, ‘Roo memiho moto himoꞌa meree-ka! Moo-ro roo himia madei modoboi-da odoboai raꞌai! Roo umoo-ka moo aahuu dubu-ka, kamia roromo-ka, moo raa bia irai eidai-ka, idoꞌoi-ka moo-ro iiodouti tiatoi. ");
INSERT INTO kiw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kamia raꞌu mabu ato-ra, roo-ro moo mori iiꞌa motoi-da emedeꞌa tiato? Kaida moo-ro ma rimidai hoꞌui-da emaꞌoai mori rautu, iiraimai-da.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kaida ruu-ro iotimo uubi eito aaꞌoi-ka, ‘Mori omodadeaimo ruu reꞌei-da, ka emaꞌaimo tuuooti (10) mori hurai iꞌapudio moto himoꞌa mereei eito.’ ");
INSERT INTO kiw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Irai rii-ro paaꞌoumo, ‘Paidubu-o, ruu tuuoti (10) mori hura-hurai imiohidio!’ ");
INSERT INTO kiw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ruu-ro pimoaimai, ‘Moo-ro riꞌo ai-riduuꞌai, boꞌou reꞌei-da miiꞌa raarai, ka hiiroi ruui-do ma emaꞌai. Irai boꞌu-ra raara tiatoi, ka ruu reꞌei ooꞌa keehibuo rautu, turiaha ooaidai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ka, doꞌo hiꞌai, ire mooi-do heamo uubi, rii boiꞌo-ro rio tiato aꞌaimo, moo rii Paidubu ma riiꞌi, imooꞌumo, ahiou eito ma imotoumo moo hohoi-da.’” ");
INSERT INTO kiw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu aaꞌo madei iaaꞌo didimoi-da, ruu rii epuui-da pidiai Ierusaremai-to. ");
INSERT INTO kiw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ka ruu iooꞌui-da, Betapagi-re Betari-re goꞌotoi taitai, Orime roꞌoai-da, ruu iimatomudio mereei-da, retoꞌai (2) itiodoai-ka, epuui-da ma odaidoi-ri, ");
INSERT INTO kiw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ara madei rautu, “Odaido auoirie epuui ooꞌa goꞌotoi eito, riꞌoiti iidoi-da emeeꞌai aꞌai kaido otoꞌa hoho doriki ata orotohiatidioi-da, meree ata-ro emiꞌei bia ruu ohui-da. Ita omopimoido, ka ita omooꞌuido ara hiou eito. ");
INSERT INTO kiw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Meree ata-ro aia maraato, raꞌu-ri momopimo duumo, ita omoaduꞌoumo, ‘Epuuhoro dubui rio-ka.’” ");
INSERT INTO kiw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Iodaidoi-da, turiaha raarai Iesu-ro iaaꞌo emerai-ha pimeꞌaido. ");
INSERT INTO kiw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Riiti-ro doriki imi iomopimoidoi-da, doriki abeai-ro paaꞌo, riiti-do, “Raꞌu-ri momopimo duido riꞌoiti-ro?” ");
INSERT INTO kiw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Riiti-ro pomoaimaido, “Epuuhoro dubui rio-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ka riiti-ro doriki aiha pomodaido Iesui-do, riiti turiaha ohui hipura tutuꞌutui, doriki hoꞌui-da aiha pihoꞌoutido, Iesu omoabaidoi-ka, ma ioroi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesu doriki-da iooꞌui-da, uubi hipura tutuꞌutui aiha pihoꞌoutimo gaboi ipi-da. ");
INSERT INTO kiw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ruu iooꞌui-da Ierusarema taitai eito, Orime roꞌoai ioruodio gaboi-da, ruu iimatomudio uubi geemai-ro, Iehoma pairautu madei-to pemarahueumo, kamia keito made aaꞌoumoi-ka, rii-ro turiaha pai raarai iaꞌaumoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rii-ro paaꞌoumo, “Iehoma meai ai-ooꞌa, Paidubui-da, boꞌu-ro mooꞌu Iehoma pairai-da, kamia miroi ai-ooꞌa aromoi-da, ka hoꞌu hiꞌai Iehomai, ai-remarahue kaumo!” ");
INSERT INTO kiw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kaida aamiꞌa Pariseia uubi-ro paaꞌoumo uubi tuiai-da Iesui-do, “Imatomudio dubu-o, roo iimatomudio mereei erehe madei-to imaaꞌo piroha ma iiꞌimo!” ");
INSERT INTO kiw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu-ro imoaimai-ka, “Moo-ro riꞌo ai-riduuꞌai, rii piroha amiiꞌi duumo, roꞌoa kopi-kopi-ro geegaꞌeega made aaꞌoi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ruu iohiꞌiai-da goꞌoto geegai taitai eito, kaida ruu-ro ieaꞌai-da, idebi pemaꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ka ruu-ro aaꞌoi-ka, “O, riꞌo umoꞌu-ha umoo ita iiꞌimo, riꞌo geꞌebadi raꞌu-ro imomooꞌui maꞌai! Irai riꞌo-ro doꞌou eaꞌaa bia! ");
INSERT INTO kiw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Himio ata ooꞌui aꞌai, riꞌo boho uubi-ro, roꞌoa hepu marai-da iimoaaꞌei aꞌai kaumo, ka riꞌo rioi-da imomurai aꞌai kaumo, turiaha hapuo-hapuoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Riꞌo ihaha itoeꞌauti aꞌai kaumo, ka riꞌo hoai rioi uubi-re, roꞌoa kopi ata emeheai aꞌai bia, ruu himia boboi-da. Mabu riꞌo-ro oibomaimo bia, Iehoma iooꞌu himioi, riꞌo imoabai.” ");
INSERT INTO kiw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu irudeme motoi iodoroi-da, raarai ioromoameumo uubi ibodidioi omahoroi-ka kekai eito. ");
INSERT INTO kiw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ka rii iduuꞌai-ka, “Iehoma made bukai-da tauo piꞌatimo, ‘Moo motoi irudeme moto-ka,’ irai riꞌo-ro ai-pemeheꞌeaimo piroi opiꞌo mati-to!” ");
INSERT INTO kiw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Turiaha himioi Iesu ai-pimatomudiotuti, irudeme motoi-da. Ka Iehoma poue emaꞌati uubi epuuhoro uubi-re, bubui imatomudio uubi-re, kamia uubi epuuhoro uubi-re, rii rio-ka Iesu ma aiꞌiaumo. ");
INSERT INTO kiw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Irai rii-ro ruu ma aiꞌiaumo gabo emeemeꞌa bia, mabu turiaha uubi ruu-ha poromidioumo. Rii rio bia made ipi ata ihimoi. ");
INSERT INTO kiw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ata himioi Iesu irudeme motoi-da uubi pimatomudio, ka pai meai madei imoaduꞌuti-ka, Iehomai-do poue emaꞌatidio uubi epuuhoroiꞌoi-re, bubui imatomudio uubi-re, ka pai uubi-re turiaha ooꞌumoi-ka Iesui-do. ");
INSERT INTO kiw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kaida paaꞌoumo ruui-do, “Rimo ma riduuꞌai, raꞌu eraraato maꞌai roo-ro ara raarai? Boꞌu-ro emaꞌai roo erarai, ara raarai ma aꞌai-ri?” ");
INSERT INTO kiw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Iesu-ro rii pimoaimai, “Doꞌou moo-ro riꞌo ai-riatohetai, moo ma roduuꞌaimo, Ioare uubi oboi-da imaaheemo erarai Iehoma reꞌei-da agooꞌu, ee, uubi reꞌei-da agooꞌu?” ");
INSERT INTO kiw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Rii himia-ro omahoroi-ka oromoamoi, “Rimo-ro raꞌu aaꞌoi raꞌai duumo? Rimo-ro aia raaꞌo duumo, ‘Iehoma reꞌei-da pooꞌu,’ ruu-ro aaꞌoi aꞌai, ‘Ka raꞌu mabu-ra riꞌo pupuo iraromoi Ioareato ideꞌa, tiato?’ ");
INSERT INTO kiw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kamia rimo-ro araibau araaꞌo duumo, ‘Uubi reꞌei-da pooꞌu,’ ara uubi hiiroi-ro, rimo roꞌoa kopi-da iamaꞌadei aꞌai kaumo rituo-rituo-ha, mabu rii iraromoi-da umoo tauo piiꞌimo, Ioare himogabo dubu-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaida rii-ro pomoaimaimo, “Rimo umoo bia ara erarai aati-da ooꞌu.” ");
INSERT INTO kiw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kaida Iesu-ro paaꞌo rii-do, “Ka moo-ro riꞌo iduuꞌai aꞌai bia, raꞌu eraraato raꞌai ara raarai.” ");
INSERT INTO kiw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kaida pimoaduꞌo Iesu-ro uubi ara obeegiri, “Dubu ata, mire paꞌea pioodouti, ka imaꞌai-ka ma emeaꞌaumoi-ri uubi eito, ka goꞌotoi iemeheai-da, tutuu hiꞌa-ha pemidio iodau mati-da. ");
INSERT INTO kiw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Himioi iohiai-da mire hurai ma idoꞌoumoi-ri, himoꞌa mereei otiodoai-ka, ruu mire paꞌeai emeaꞌai imeheai uubi eito, ruu omotoodeai mire hurai ma emaꞌaimoi-ri, irai paꞌeai emeeꞌai imeheai uubi-ro himoꞌa mereei ai-pamoꞌoboumo, imotiodoaimo araimai tuhaito-ha. ");
INSERT INTO kiw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ka ata himoꞌa mereei otiodoai-ka, irai mire paꞌeai emeaꞌai imeheai uubi-ro ai-paiꞌiaumo, iemaꞌaumo, otiodaimoi-ka araimai tuhaito-ha. ");
INSERT INTO kiw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kaida potiodoai ata himoꞌa mereei, mire paꞌeai emeaꞌai imeheidio uubi-ro aiha pamaꞌadeumo, rato-ratoi rautu omohuꞌoi-ka kekai eito. ");
INSERT INTO kiw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kaida mire paꞌeai rautu mereei-ro paaꞌo, ‘Moo raꞌu aꞌai raꞌai? Moo himia hiꞌa meree ohioi otiodoai raꞌai, eaꞌai-da ihaha-ka, rii-ro ruu emaabei aꞌai kaumo.’ ");
INSERT INTO kiw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Irai mire paꞌeai eaꞌaumo uubi-ro iemeeꞌaumoi-da, rii himia poroduuꞌaimo, ‘Ara paꞌeai rautu dubui mereei-ka, ma raiꞌiaumo rituo-ha, ka ruu raarai, rimo raara-ro ma iiꞌai-ka.’ ");
INSERT INTO kiw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kiauka rii-ro, ruu omohuꞌoi-ka, mire paꞌei-da, rituo-ha imaiꞌiaumo.” Iesu-ro iatohetai-ka, “Ka raꞌaibou-rie, mire paꞌeai rautu mereei raꞌu aꞌai maꞌai mire paꞌeai eaꞌa uubi eito? ");
INSERT INTO kiw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ruu ooꞌui aꞌai, aaꞌo uubi rituo-ha mimoto-die, ka mire paꞌeai imaꞌai aꞌai aamiꞌa eaꞌa uubi-do.” Uubi-ro ara madei ioromaimoi-da, kaida paaꞌoumo, “Ihaha bia!” ");
INSERT INTO kiw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ka Iesu-ro rii hohoi iarodio ida piatohetai, “Irai Iehoma made bukai raꞌu oroaduꞌo toto maꞌai, ara made diamoi-da? ‘Roꞌoa kopi moto ititi uubi-ro memihoi-ri araiboi, oroameheai aꞌai, ka ruu emaabe roꞌoa kopi-ro orododiai aꞌai, rii turiahai-do.’ ");
INSERT INTO kiw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Turiaha uubi boiꞌo-ro mirahio duumo ara roꞌoa kopi hoꞌui-da, orotoeꞌauti aꞌai kaumo kerekere-ha, kamia ire roꞌoa kopi meree ata hoꞌu ato amirahiai, aaꞌo mereei patapata hiꞌa-ha ododiai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bubui imatomudio uubi-re, ka Aiai Iehomai-do poue emaꞌatidio epuuhoro uubi-re, ai-piraromoumo Iesu aiha ma oꞌapuaimo. Mabu rii umoo tauo piiꞌimo, Iesu-ro iimoaduꞌo obeegiri-da rii ai-pimooꞌamo, irai rii toe paꞌaimo uubi eito. ");
INSERT INTO kiw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ka rii-ro aꞌai emera pororohoumo. Rii-ro uubi aamiꞌa taꞌii paꞌaimo, Iesui-do ma orooahuꞌomaimo, rii aaꞌoi aꞌai madei iaha-ka. Kaida pitiodoaimo Iesu oraꞌe ma emedeꞌaumo aamiꞌa atohetaiato. Ka ma emaꞌaimo ruu Roma Gamarai erara aꞌai epuuhoro uubi tui eito. ");
INSERT INTO kiw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ara taꞌii iaꞌaimo uubi-ro paaꞌoumo Iesui-do, “Imatomudio Dubu-o, rimo umoo-ka roo aaꞌo raai-re, kamia imatomudioi-re, meaha-ka, rimo umoo-ka roo gaaꞌu emera-ka turiaha uubi eito, kamia Iehoma gaboi iha hiꞌai imatomudio. ");
INSERT INTO kiw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Rimo riduuꞌai, rimo himia bubui imoamoi araꞌai duumo, Gamara Kaisarai-do taketi aꞌai-da, ee, imoamoi aꞌai bia-ra?” ");
INSERT INTO kiw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Irai Iesu-ro umooi iiꞌi-da, rii erematuhuti, ida paaꞌo rii-do, ");
INSERT INTO kiw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moo meree ata-ro mori hura gaaꞌu ma romoahuꞌomai. Boꞌu paira-ra hoho-rai-ra ara?” Rii-ro pomoaimaimo, “Gamara Kaisara.” ");
INSERT INTO kiw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ka Iesu-ro paaꞌo, “Ka meaha-ka, Kaisara raai ma emaꞌai Kaisarai-do, Iehoma raai ma emaꞌai Iehomai-do.” ");
INSERT INTO kiw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hieꞌei-da uubi hohoi-da, ruu oraꞌe emedeꞌai modobo bia, ruu himia madei-da, ka rii madei iimoaimai emerai ioromidioumoi-da, hoho-ha peremeꞌaumo kiauka piroha piiꞌimo. ");
INSERT INTO kiw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi uubi-ro aaꞌoi, uubi oroihi-da ireibuai aꞌai bia, rii amiꞌa-ro ooꞌumoi-ka Iesui-do ida paaꞌoumo, ");
INSERT INTO kiw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Imatomudio dubu-o, Mose-ro ara bubui rimoi-do piꞌati, ‘Dubu ata aia miihiai, ida ooboi meree tiato-ha amemeheai, ruu riaraamui-ro oobo himui ma omiai, ka meree ma imeꞌaido, ka iihiai dubui mereei-to ma iahoꞌoumoi-ka.’ ");
INSERT INTO kiw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ai-pemidioumo riaraamui, turiaha semeri (7), epuu mereei oobo omiai-ka, irai meree imeeꞌa tiatoi haato piihiiai. ");
INSERT INTO kiw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ka ruu iobodoi-ro omiai-ka aaꞌo oobo himui. ");
INSERT INTO kiw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ka meree ipiai-ro omiai-ka, aatu emerai raaha-ro pobodi turiaha aaꞌo semeri (7) eito. Rii aiha poroihiimo meree imeꞌatuti tiatoi haato. ");
INSERT INTO kiw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Iarai aaꞌo oobo himui iihiai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kaida oroihii ireibuai aꞌai himioi-da oroiꞌioi eito, ruu boꞌu oobo-ro ooꞌai maꞌai? Mabu turiaha semeri (7) dubu-ro poromoameheumo.” ");
INSERT INTO kiw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu-ro pimoaimai rii, “Doꞌou ara himioi-da, upi dubui ai-orobo kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Boiꞌo-rie Iehoma aaꞌoi-da meai, rii ireibuai aꞌai kaumo ioroihimo reꞌei-da, ka emidioi aꞌai kaumo ooꞌui aꞌai himioi-da, irai rii oroboi aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Rii arerui aibo orododiai aꞌai kaumo, oroihi aꞌai bia. Rii Iehoma meree-ka, mabu rii ireibuai aꞌai kaumo oroiꞌioi eito. ");
INSERT INTO kiw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ka Mose himia-ro aahuu pododiai oroihi ireibuioi aꞌai kaumo oroiꞌioi eito. Erai-ro iiruro buꞌi ioaduꞌo made ipi-da Paidubu ai-poaduꞌo, ‘Aberahamo Iehomai-ka, Isaꞌako Iehomai-ka, kamia Iakobo Iehomai-ka.’ ");
INSERT INTO kiw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ruu oroiꞌio uubi Iehoma-ka, ruu oroihi uubi Iehoma bia, turiaha uubi ai-roroiꞌio kaumo Iehoma hohoi-da.” ");
INSERT INTO kiw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bubui imatomudio uubi aamiꞌai-ro paaꞌoumo, “Imatomudio Dubu-o! Roo madei oaimai mea hiꞌa-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kamia rii toe piraromoumo aamiꞌa atohetai made ma aaꞌoumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu-ro iatohetai-ka rii, “Raꞌaibou-da maaꞌo duumo, Aiai-ro iapui mereei, Damida aramui-ro ooꞌai aꞌai? ");
INSERT INTO kiw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kamia Damida himia-ro ai-paaꞌo rahoaꞌe bukai-da, ‘Paidubui-ro, moo Pai eito paaꞌo, “Emiꞌei ara hioꞌou-da, moo iha-tui hapuoi-da, ");
INSERT INTO kiw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","modau-die moo-ro roo boho uubi aia rideꞌa roo otoi goroi-da oto imoti toto aibo”’ ");
INSERT INTO kiw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ka raꞌaibou-darie ruu Damida aramui? Damida-ro ruu ai-poibomai ida pahoꞌo, ‘Paidubu.’” ");
INSERT INTO kiw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ka turiaha uubi ruu ioromidioumoi-da, Iesu-ro paaꞌo ruu iimatomudio mereei eito, ");
INSERT INTO kiw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Riꞌo ita eremabeumo bubui imatomudio uubi eito, boiꞌo-ro moroaꞌoiadio duumo muari hiꞌa hipura tutuꞌutui rautu, rii rio-ka imaabe rautu ma iꞌopoumo eremaro mati-da. Hoho reꞌei totoi rio-ha aꞌai-ka, idabu motoi-da ma emiꞌeitutimo, kamia meamea mati-ha ma iiohoumo mahuai-da. ");
INSERT INTO kiw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rii-ro imatuhutidio kaumo himu upibaiꞌoi, motoi piro ma imaꞌaimoi-ri. Kamia irudeme made tutuꞌutui aaꞌoi-ka ma imarahueumoi-ri! Rii imidai aꞌai riiboi memiho hiꞌa-ka!” ");
INSERT INTO kiw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu-ro, keka-kekai iarodioi-da piaꞌa, raara hiiro-hiiro uubi giiꞌepu raai idiꞌamoumoi-da, irudeme motoi mori idiꞌamo reꞌei-da. ");
INSERT INTO kiw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ida peaꞌa Iesu-ro raara tiato hiꞌa oobo himui-ro mori hura keeketi iiomiai-da. ");
INSERT INTO kiw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kaida ruu-ro paaꞌo, “Riꞌo moo-ro ihaha riduuꞌai, ara raara tiato oobo himui-ro edeꞌa geega hiꞌai aamiꞌai rautu idoboai-da. ");
INSERT INTO kiw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Turiaha uubi aamiꞌai giiꞌepu raai iemaꞌaimoi hiiroi-da pitoodemo, irai oobo himui ruu raara tiato hiꞌai-da pedeꞌa, ruu ma oroiꞌioi raai.” ");
INSERT INTO kiw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iimatomudio meree aamiꞌai irudeme motoi poaduꞌoumo, eaꞌai-da mea hiꞌa-ka, mea hiꞌa roꞌoa kopi-kopi-da pididimo, kamia tomio hiꞌa giiꞌepu raarai iemaꞌatimo emerai Iehomai-do. Kaida Iesu-ro paaꞌo, ");
INSERT INTO kiw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Turiaha riꞌo-ro ara miaꞌa duumo raarai, himio ata ooꞌui aꞌai, roꞌoa kopi gaaꞌu ata ruu himia boboi-da emeheai aꞌai bia, turiaha ipeduai aꞌai goroi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Rii-ro atohetaimoi-ka, “Imatomudio Dubu-o, ara raai raꞌu himio oobodi maꞌai? Ka raꞌu-ro oobodi maꞌai, aaꞌo raai oobodi aꞌai himioi taitai-da?” ");
INSERT INTO kiw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu-ro paaꞌo, “Ita eremabeumo, meree ata-ro imatuhiaꞌa, hiiro uubi moo pairai-da ooꞌui aꞌai kaumo, aaꞌoi aꞌai kaumo, ‘Moo ruu-ka!’ ka ‘Himioi tauo ohiai maaka!’ Irai rii ibodoumoꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Toe aꞌaimoꞌa, riꞌo-ro iromidioi aꞌai raarai, boho araiꞌia, kamia haharubuae aꞌai, araibau raarai aiha oobodi aꞌai kaumo hepui-da. Irai ara raarai-ro aaꞌo bia oropoiꞌoi himioi taitai-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ruu ioroaduꞌuti-da, paaꞌo, “Paꞌa atai-ro paꞌa atai heamo emaꞌai aꞌai, gaaꞌu hapuoi paꞌati araiꞌiai aꞌai kaido. ");
INSERT INTO kiw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ka memiho hiꞌa mumuꞌoi orohoi aꞌai kaumo, du tiato himioi, kamia himia-himia hoho gimoi iobodi aꞌai kaumo, turiaha mati-da, ka aromoi-da toe hiꞌa iobodi tiato raarai, iobodituti aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Moo mabu ato, ara raarai oobodi tiatoi-da, riꞌo iohii aꞌai kaumo, mimodoboa duumo, ka mideꞌa duumo, ma imahibaimoi-ri idabu motoi-da, ka mideꞌa duumo, duꞌi motoi-da, kaida imodai aꞌai kaumo pai uubi-re, epuuhoro uubi-rei hohoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka riꞌoi-do mea hiaꞌei-ro orododiai aꞌai, geua ma imoaduꞌoumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Raarai orododiai tiato himioi-da, iraromoi gaaꞌu-ha ma ideꞌai, ka roo iraromo hiiro-hiiro aꞌai aꞌai bia, roo himia-ro raꞌaibou oromoatuei maꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mabu riꞌo moo-ro mea made, kamia mooꞌui imaꞌai raꞌai, ka roo aaꞌoi aꞌai madei rii-do heamo meree ata-ro omotaumai modobo bia. ");
INSERT INTO kiw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Riꞌo abea maamui-ro, riꞌo raamiꞌoi-ro, riꞌo guu uubi-ro, ka riꞌo taitai riaraamui-ro, imaꞌai aꞌai kaumo epuuhoro uubi eito, aamiꞌai iimotoi aꞌai kaumo rituo-rituo-ha. ");
INSERT INTO kiw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Moo mabu ato, roo turiaha uubi-ro udo rautu araiboi aꞌai kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Irai riꞌo epuui-da, muho gaaꞌu ata araatoai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aahuu-ha ma ooti, ka riꞌo oroiꞌioi iapudioi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Iesu-ro paaꞌo, “Roo-ro eaꞌai aꞌai Ierusarema oomaaꞌei aꞌai kaumo, heamo uubi-ro, ka roo umoo-ha ita iiꞌi, taitai-ka Ierusarema otoeꞌauti. ");
INSERT INTO kiw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kaida boiꞌo-rie Iudeaato, ma odaudioi hioi-to roꞌoai eito, ka goꞌoto geegai-da boiꞌo-rie, ma odaudioi, ka boiꞌo-rie aamiꞌa mati-da, iidoi bia goꞌoto geegai eito. ");
INSERT INTO kiw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ka aaꞌo himioi Iehoma kamai araꞌai himioi-ka, Iehoma made bukai-da iꞌatimo emerai ihahai ma oobodi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aaꞌo himioi-da memiho hiꞌa-ro ooꞌai aꞌai, topii rautu upi-re, kamia meree guge rautu maamiꞌoi eito! Kaida, pauo hiꞌa oroiꞌioi ara hepu hoꞌui-da irahiai aꞌai, ka Iehoma udoi uubi eito aꞌai aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aamiꞌai hapuo-hapuoi hiꞌua eꞌakerei-ro iimotoi aꞌai, aamiꞌai itohiti aꞌai kaumo ma imodaumoi-ri aamiꞌa hepui eito. Iuda guui-da paira tiato uubi-ro Ierusarema atuꞌuti aꞌai kaumo, modau-die, rii himioi mohiai. ");
INSERT INTO kiw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Aamiꞌa aape raara iobodi aꞌai kaumo, himioi-da, omei-da, kamia oroꞌioi-da. Ara hepu geemai-da, emidioumo uubi, pauo hiꞌa iraromo rautu emidioi aꞌai kaumo, kamia toe aꞌai aꞌai kaumo, tibiri aubo geemaꞌeemai diamoi oromidioi aꞌai-da. ");
INSERT INTO kiw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aromoi iiꞌa raarai oomuoi aꞌai-da, uubi toei-da iimoaꞌobeaitutii aꞌai kaumo, rii omoti aꞌai-da, raꞌu-ro oobodi maꞌai duumo ara hepu geemai-da. ");
INSERT INTO kiw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kaida rii-ro eaꞌai aꞌai kaumo Uubihaubi Mereei dumoi goroi-da ooꞌui aꞌai, ruu himia erarai-re, kamia geega hiꞌa tomioi rautu. ");
INSERT INTO kiw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ara raarai orododiai omahoroi-da, ita itooꞌaumo, epuui ma imiꞌaimo, mabu riꞌo oroiꞌioi eidai taitai-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kaida rii pimoaduꞌo Iesu-ro ara obeegiri, “Ma iraromoumo, hura iihodio ruꞌai gaabii aibo, kamia aamiꞌa ruꞌai-re. ");
INSERT INTO kiw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Riꞌo-ro rii iaꞌai-da pahai ioboodi amomahoro duumo, roo umoo iiꞌi aꞌai, tuomoi himioi taitai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aatu emera gaboi-da, riꞌo-ro iaꞌai aꞌai kaumo ara raarai ooboodimoi aꞌai emerai, riꞌo umoo iiꞌi aꞌai kaumo Iehoma pai emidio erarai ooꞌui taitai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Moo-ro riꞌo ihaha riduuꞌai, ara raarai ooboodimoi aꞌai kaumo, doꞌou emidio uubi oroihi tiatoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aromo-ra hepu-rai oropoiꞌoi aꞌai kaumo, irai moo madei oropoiꞌoi aꞌai bia.” ");
INSERT INTO kiw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Meaha ma ereaꞌaumo, riꞌo kaukai iiho-ra, idio-ra geegaꞌeegai-da riibo idodiai bia, kamia kaukai iraromo hiiro-hiiroi-da riibo idodiai bia, ara hepui oroiꞌioi pauoi-ri, mabu aaꞌo himioi-ro riꞌo oraꞌei emerai iiohiai toe-ka. ");
INSERT INTO kiw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mabu aaꞌo himioi ooꞌui aꞌai, turiaha uubi eito, ara hepu geegai-da. ");
INSERT INTO kiw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Meaha ma ereaꞌai, kamia ma irudemei pupuoi-ri, ka riꞌo pupuo-ha oti aꞌai kaumo, iobodi aꞌai raarai goroi-da, kaida itoꞌai aꞌai kaumo Uubihaubi Mereei hohoi-da.” ");
INSERT INTO kiw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iesu irudeme motoi-da pimatomudiodio, himioi imatomudioi-da, ka adimoi-ro ohiai-da, odai-ka kekai eito, ka duoi Orime roꞌoai-da opoiꞌoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Turiaha himioi duoduo hiꞌai, turiaha uubi odai-ka irudeme motoi eito, ruu ma oromidioumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Iaupai tiato parama mahuai aꞌai himioi, taitai-ro ioohiai-da. Aaꞌo mahuai pairai-ka, Orohodi Mahua. ");
INSERT INTO kiw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Iehoma poue emaꞌatidio uubi epuuhoro uubi-re, ka bubui imatomudio uubi-re, rii toe paꞌaimo uubi eito. Kaida piroha gabo pomohooumo, Iesu rituo-ha ma aiꞌiaumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ka Satari-ro Iudasi iimamiiai-ka, ruu paira atai Isikariota, Iesu iimatomudio tuero (12) mereei ata-ka. ");
INSERT INTO kiw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ka Iudasi odai-ka, oroaduꞌuti poue emaꞌatidio uubi epuuhoro uubi-re, kamia irudeme motoi idomai uubi epuuhoroi rautu, raꞌaibou imaꞌai maꞌai ruu-ro, Iesu rii-do. ");
INSERT INTO kiw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rii geꞌii paꞌaimo, ka rii made gaaꞌu paaꞌoumo, ruu mori-to taꞌii aꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iudasi rio iiꞌi-ka, ida poomahoro, mea gabo ioohoi, Iesu raꞌaibou imaꞌai maꞌai rii-do, uubi umoo iiꞌi tiato-ha. ");
INSERT INTO kiw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Himioi oohiai-ka, iaupai tiato parama mahuai-ri, mamoe daꞌodaꞌo ma iimotoumoi-ri, Orohodi Mahuai eito. ");
INSERT INTO kiw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iesu-ro itiodoai-ka, Petero-ra, Ioare-rai, ara madei rautu, “Odaido, Orohodi iihoi ereemaumodi, ma riihoumo.” ");
INSERT INTO kiw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Riiti-ro atohetai-ka ruu, “Rimo-ro ratii-da ereemaumodi miraromo, roo-ro?” ");
INSERT INTO kiw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ruu-ro imoaimai-ka, “Riꞌoiti odai aꞌai-da, goꞌoto geegai-da, dubu ata obo gaigaruai omodai aꞌai, ruu-ro riꞌoiti imeeꞌai aꞌai. Ita obodoido, ruu odoroi aꞌai motoi rioi eito. ");
INSERT INTO kiw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ka ita aaꞌoido motoi rautu dubui eito, ‘Imatomudio dubui-ro ai-aaꞌo maaka rooi-do, “Heiꞌe-rie, ruu iimatomudio mereei rautu Orohodi Mahuai iihoi aꞌai ruuꞌai?”’ ");
INSERT INTO kiw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ka ruu-ro riꞌo imapui aꞌai geema ruuꞌa ata, emidioi-re, kamia iiho totoi-rei rautu, hoꞌui motoi ruuꞌai-da. Ka hieꞌei-da turiaha raarai ita ereemaumodiido.” ");
INSERT INTO kiw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ka riiti iodaidoi-da, raarai Iesu-ro iaaꞌo emerai-ha, pimeeꞌaido. Kiauka rii eremaumodi-ka, Orohodi Mahuai. ");
INSERT INTO kiw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Himio mabui ioohiai-da, Iesu iiho totoi taitai-da emiꞌei-ka, ruu iiapui made himoꞌa uubi rautu. ");
INSERT INTO kiw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ruu-ro aaꞌoi-ka rii-do, “Moo ihaha rio piraꞌai ara Orohodi Mahuai riꞌo rautu ma riihoi-ri, moo riiboi eidai tiatoi-da! ");
INSERT INTO kiw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kamia moo-ro riꞌo araibau riduuꞌai, ara mahuai moo-ro ata iihoi aꞌai bia, modau-die mahuai ihahai moobodi, Iehoma pai emidio erarai-da!” ");
INSERT INTO kiw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ka Iesu-ro mire koimoi eidai-ka, Iehomai-do keito made aaꞌoi-ka, kaida paaꞌo, “Eidaimo araa-rie, ka ereemaꞌatimo riꞌo himia-ro. ");
INSERT INTO kiw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ka moo-ro riꞌo ai-riduuꞌai, doꞌou moo-ro ara mire oboi ata idioi aꞌai bia, modau-die Iehoma pai emidio erarai mooꞌu-die.” ");
INSERT INTO kiw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ka ruu-ro parama hapuoi eidai-ka, Iehomai-do keito made aaꞌoi-ka, ehebiai-ka, rii-do imaꞌai-ka, ida paaꞌo, “Ara moo tuupi-ka, riꞌo-ri rimaꞌai, araibau ita iꞌatidioumo, moo ma riraromoumoi-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gaaꞌu emerai gaboi-da, mire koimoi imaꞌai-ka rii-do, iihoumo didimoi-da aaꞌoi-ka, “Ara mire koimoi Iehoma oio aaꞌoi-da rereemedeeꞌa kaumo, moo orai-da rahiai, riꞌo-ri oruodii. ");
INSERT INTO kiw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Irai ma emeeꞌaumo, gaaꞌubuo ata, moo oaꞌuei aꞌai mereei, ruu moo rautu-ka, araa-rie iiho totoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Uubihaubi Mereei iihiai aꞌai, Iehoma-ro orododiai iiraromo emerai, irai memiho hiꞌa-ro ooꞌai aꞌai, moo uubi eito oaꞌuei aꞌai mereei eito.” ");
INSERT INTO kiw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ka rii himia-ro araatohei oomahoroi-ka, riiato boꞌu-ro aꞌai maꞌai ibai. ");
INSERT INTO kiw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iimatomudio uubi himia oomahoroi-ka eemaaꞌoi, riiato uubi-ro boꞌu iraromai maꞌai duumo, ruu pai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu-ro aaꞌoi-ka rii-do, “Iuda guui-da paira tiato pai uubi, rii erara-ka rii himia uubi, ka erara uubi-ro, araahoꞌoo kaumo pairai, ‘uubi imoabai uubi’. ");
INSERT INTO kiw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Irai ara hiou gaboi bia riꞌoi-do, kaida, riꞌo tuiai-da geema mereei, keehibuo meree aibo ma iiꞌi, ka epuuhoro mereei, himoꞌa meree aibo, ma orododiai. ");
INSERT INTO kiw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Boꞌu-ra geemai, dui iiho beha emiꞌei mereei-ra, ee dui ereemaꞌati mereei-ra? Ie, emiꞌei mereei, irai moo riꞌo tuiai-da, ereemaꞌati meree-ka. ");
INSERT INTO kiw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Riꞌo ihaha tauo pemidioumo moo rautu, moo iremahibaitutiimo goroi-da. ");
INSERT INTO kiw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kaida moo Abeai-ro iremaꞌai pai erarai, riꞌo ma rimemeꞌeuatidioi-ri, ka moo-ro riꞌo, aatu erarai imaꞌai raꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Moo pai emidio erarai-da, riꞌo moo iiho totoi-da, iiho-ra, idio-rai aꞌai aꞌai kaumo, ka riꞌo pai uhui-da emiꞌeituti aꞌai-da, imemeꞌeuatidioi aꞌai kaumo, Isaraꞌera tuero (12) paꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iesu-ro aaꞌoi-ka, Simora Peteroi-do, “Simora, Simora, oromidio! Satari made tauo eidai maaka, riꞌo turiaha ma imahibaitutui-ri, ruꞌa hurai ma imamuhuꞌuuti emerai. ");
INSERT INTO kiw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Irai moo tauo rirudemea maaka roo-ri, Simora-o, roo pupuo iraromoi iiraahiaiꞌai-ri. Ka roo ereheꞌeai aꞌai-da mooi-do, roo riaraamui pupuo ita idodiai.” ");
INSERT INTO kiw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petero-ro omoaimai-ka, “Paidubu-o, roo aia modau duꞌi motoi eito, kamia iihiai eito, moo rautu-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu-ro omoaimai-ka, “Petero, roo ai-roduuꞌai, roo-ro moo retoꞌa-gaaꞌu (3) atuhe made aaꞌoi aꞌai, roo umoo bia moo, himioi ooaho taitai-da, kokoroi made aaꞌo tiatoi haato.” ");
INSERT INTO kiw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kaida Iesu-ro iatohetai-ka, ruu iimatomudio mereei, “Moo-ro riꞌo iiritiodoai-da, aaꞌo himioi mori ioidio haaꞌo, ipi haaꞌo kamia oto tama tiato, riꞌo reꞌei-da ata raa, agororoohoo?” Rii-ro omoaimai-ka, “Ata raa bia.” ");
INSERT INTO kiw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iesu-ro aaꞌoi-ka, “Irai doꞌou, boꞌu reꞌei-da mooꞌa mori ioidio haaꞌo, kamia ipi haaꞌo, ma eidai, ka boꞌu-rie heamo eꞌakere tiatoi, tuupi erara hipurai taꞌii-to ma edeeꞌai, ka gaaꞌubuo ma eidai. ");
INSERT INTO kiw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ka riꞌo moo-ro ai-riduuꞌai, Iehoma made bukai-da tauo piꞌatimo, ‘Ruu memiho uubi-da ai-poodabuai’, ihahai ma obodi moo-ri, mabu moo-ri, raꞌu iꞌatiimo, ihahai eito ai-obodii kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ka iimatomudio mereei-ro paaꞌoumo, “Paidubu-o, ma imeeꞌa, araa-rie retoꞌa heamo eꞌakereeti.” Ruu-ro imoaimai-ka, “Kiauka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu-ro goꞌoto geemai emeheai-ka, ruu iꞌatidio emerai, odai Orime Roꞌoai eito. Ka iimatomudio mereei ruu rautu podaumo. ");
INSERT INTO kiw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ka ruu aaꞌo mati-da iereedeeꞌai-da, ruu-ro aaꞌoi-ka rii-do, “Irudemeumo, mabu erematuhuti ooꞌui-da, riꞌo iiraahio toe-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kiauka, ruu araahuꞌiodoai-ka rii reꞌei-da, roꞌoa kopi ma eheuꞌai auꞌoi emerai, popu-popu iimohorai-ka irudemeai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ruu-ro aaꞌoi-ka, “Aba-o, roo rio-ra, ara temeteme koimoi omodadeai mooato, irai moo rioi obodooꞌa, roo rioi moo-ro eidai raꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ka aromoi areru ata oobodii-ka ruui-do, ka ruu pupuo emaꞌai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ka ruu kaukai-da geema riibo peidai, ka pupuo hiꞌai-to pirudemea, ka buaꞌeai orai aibo paramio, hepui eito. ");
INSERT INTO kiw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Irudeme reꞌei-da, otooꞌai-ka araimai, iimatomudio mereei reꞌei eito, ida pimeeꞌa, rii giiꞌepu iraromo pauoi-da, haꞌima uroi pirobu. ");
INSERT INTO kiw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ka ruu-ro aaꞌoi-ka rii-do, “Riꞌo raꞌu uro-ha mirobu? Ireibuaumo ma irudemeumo, ka erematuhuti ooꞌui-da, riꞌo iiraahio toe-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu ioroaduꞌuti haato pereedeꞌaumo uubi hiiroi, Iudasi-ro pimooꞌu, Iudasi tuero (12) iimatomudio mereei ata-ka. Ruu ooꞌui-ka Iesu ma ohomeai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ka Iesu-ro aaꞌoi-ka, “Iudasi, Uubihaubi Mereei roo-ro ohomeai-da amoaꞌue?” ");
INSERT INTO kiw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kamia iimatomudio mereei-ro, oobodi tooto iaꞌai rai ieaꞌaumoi-da, rii-ro Iesui-do aaꞌoi-ka, “Paidubu-o, rimo-ro heamo eꞌakerei-da, rii aia rimooto duumo?” ");
INSERT INTO kiw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kiauka rii gaaꞌubuo atai-ro, Iehoma poue emaꞌatidio uubi, epuuhoro dubui moto himoꞌa mereei, iha hapuoi hepatoi aiha patuiꞌa. ");
INSERT INTO kiw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Irai Iesu-ro aaꞌoi-ka, “Kiauka, ata aꞌaiꞌa.” Ruu-ro aaꞌo dubui hepatoi aihimodi-ka aiha poateai. ");
INSERT INTO kiw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Poue emaꞌatidio uubi epuuhoro uubi-re, ka irudeme motoi idomai uubi epuuhoro uubi-re, kamia pai uubi-reiro, pooꞌumo Iesu oohiai, Iesu-ro aaꞌoi-ka rii-do, “Riꞌo eꞌakerei-re, kamia eꞌai rautu ma ooꞌumo, moo riꞌo piro mereei-ra? ");
INSERT INTO kiw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Turiaha himioi, moo riꞌo rautu piremidio irudeme motoi-da, ka riꞌo-ro emahibaimo bia, moo oohiai. Irai doꞌou, riꞌo omaꞌati himioi-ka, duꞌi erarai ooꞌai-da.” ");
INSERT INTO kiw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ka rii-ro Iesu oohiaimoi-ka omodai, Iehoma poue emaꞌatidio uubi epuuhoro dubui motoi rioi eito, ka Petero-ro auoꞌauo-ha pobodoo. ");
INSERT INTO kiw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Erai adoroumoi-ka aaꞌo motoi ipituiai hauꞌii-da, ka Petero-ro imodabuai-ka erai iemaꞌoidioumo uubi. ");
INSERT INTO kiw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ka moto himoꞌa oobo ata-ro emeeꞌai-ka erai kekai-da, pupuo hiꞌai-to, taitai hiꞌai-da poibomatidio, ida paaꞌo, “Ara dubui Iesu rautu-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Irai Petero-ro atuhe made paaꞌo, “Oobo, moo umoo bia ruu.” ");
INSERT INTO kiw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ka ipi-ro iopoꞌi didimoi-da, dubu ata-ro Petero oibomai-ka, ida paaꞌo, “Roo rautu, rii ata-ka!” Irai Petero-ro pomoaimai, “Dubu-o, moo bia.” ");
INSERT INTO kiw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Himio mabu gaaꞌu iorohodi didimoi-da, dubu ata-ro erehei-to paaꞌo, “Ihaha-ka, ruu Iesu rautu ka, mabu ruu Garereia dubu-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Irai Petero-ro pomoaimai, “Dubu-o, roo raꞌu maaꞌoi, moo umoo bia!” Gaaꞌu hiꞌa-ha ruu ioroaduꞌuti goroi haato, kokoroi madei aaꞌoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ka Paidubui iereheꞌeai-da, gamoꞌo-ha emeeꞌai-ka Petero, kaida piraromai, Petero-ro, Paidubui iaaꞌo madei, “Roo-ro moo retoꞌa-gaaꞌu (3) atuhe made aaꞌoi aꞌai, roo umoo bia moo, himioi ooaho taitai-da, kokoroi made aaꞌo tiatoi haato.” ");
INSERT INTO kiw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ka Petero iohuuꞌoi-da, geega idebi paꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ka Iesu ioohiaimo uubi-ro ai-pomomoruodioumo, kamia iamaꞌedeumo. ");
INSERT INTO kiw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Rii-ro ruu idomai omopaimoi-ka, hipura kerei-da, ida erehei-to patoheemo, “Roo boꞌu-ro momihia? Ma ahoꞌoo!” ");
INSERT INTO kiw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ka rii-ro ruui-do, hiiro omodoboa made aaꞌoumoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Himioi ioahoi-da, pai uubi-re, Iehoma poue emaꞌatidio uubi epuuhoro uubi-re, ka bubui imatomudio uubi-re, iidabuaimoi-da gaaꞌu-ha, Iesu omooꞌumoi-ka oroaduꞌuti, hoho reꞌei eito. ");
INSERT INTO kiw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Rii-ro aaꞌoi-ka, “Rimo ma riduuꞌai, roo Iehoma-ro iapui mereei-ra, ha?” Ruu-ro rii imoaimai-ka, “Moo-ro riꞌo aia riduuꞌai, riꞌo-ro umooi eidai aꞌai bia, ");
INSERT INTO kiw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","kamia riꞌo moo-ro aia riatohetai, riꞌo-ro moo madei omoaimai aꞌai bia. ");
INSERT INTO kiw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Irai doꞌou odai aꞌai Uubihaubi Mereei, erara hiꞌa Aiai Iehoma iha tui hapuoi-da, emiꞌei aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rii turiaha-ro atohetaimoi-ka, “Roo Aiai Iehoma mereei-ra, ha?” Ka ruu-ro rii madei imoaimai-ka, “Ka riꞌo ruu aaꞌo kaumo, moo-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ka rii-ro aaꞌoi-ka, “Rimo rio bia aamiꞌa geua uubi, rimo-ro himia tauo roromai maakaumo ruu aaꞌo rai!” ");
INSERT INTO kiw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Turiaha paꞌai iireibuaumoi-da Iesu omodaumoi-ka Pirato hohoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ka ruu emaaꞌoi omahoroumoi-ka, “Ara dubui rimo-ro ai-roohiai maakaumo, mabu ruu-ro rimo uubi imoaduꞌuti madei-da kekai imodau, ruu-ro ai-imoaduꞌuti taketi aꞌai mooꞌai-ri Kaisarai-do, ka ruu-ro ai-aaꞌo ruu Aiai-ro iapui mereei-ka, ruu Paidubui-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pirato-ro Iesu atohetai-ka, “Roo Iuda uubi Paidubui-ra, ha?” Ka Iesu-ro ruu madei pomoaimai, “Roo ruu aaꞌo.” ");
INSERT INTO kiw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kaida Pirato-ro aaꞌoi-ka, Iehoma poue emaꞌatidio uubi epuuhoroi-re kamia uubi-rei eito, “Moo-ro auma ata ememeeꞌa bia ara dubui ma romodoboamoi-ri.” ");
INSERT INTO kiw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Irai rii-ro erehe rautu aaꞌoumoi-ka, “Ruu-ro Iudea uubi ruu imatomudio madei-da, ai-piapuhuti, Garereiaato pomahoro, kaida ooꞌu maaka ara hiou eito.” ");
INSERT INTO kiw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pirato-ro ara madei ioromai-da ruu-ro araatoi-ka, “Ara dubui Garereia dubu-ra, ha?” ");
INSERT INTO kiw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pirato umoo iiꞌi-da, Iesu Heroda Pai iiemidio hepui meree-ka, aaꞌo rau-ri ruu ai-potiodoai Herodai-do, mabu Heroda aaꞌo himioi Ierusaremaato-ka. ");
INSERT INTO kiw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroda iha geꞌii paꞌai Iesu iemeeꞌai-da, mabu Iesu pai tauo poromidio, ka tutuu hiꞌa pomoti ruu ma emeeꞌai-ri, Heroda-ro rio paꞌai, Iesu urio odaudio raa ata ma aꞌai, ka ruu-ro ma eaꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ka Heroda-ro Iesu hiiro hiꞌa raato patohe, irai Iesu-ro madei ata omoaimai bia. ");
INSERT INTO kiw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Iehoma poue emaꞌati uubi epuuhoroi-re, ka bubui imatomudio uubi-re, iiadomaimoi-ka, ida idodiaimoi-ka erehe erematuhuti made aamiꞌa, Iesu ma omoamomoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroda ruu himia heamo uubi rautu, Iesu ai-pemerioumo, ka eremabe tiato raara aamiꞌa iemaꞌaimo, mea hiꞌa hipura tutuu atimaimoi-ka, aiha potiodoaimo araimai Piratoi-do. ");
INSERT INTO kiw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aaꞌo himiou haato, Heroda-ra Pirato-rai riaraamu piiꞌiido, epuui-to ara rau obodi tiatoi-da riiti udo-udo pemidioido. ");
INSERT INTO kiw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pirato-ro turiaha iahoꞌoi-ka, Iehoma poue emaꞌatidio uubi epuuhoroiꞌoi-re, uubi epuuhoroiꞌoi-re, kamia uubi rautu turiaha gaaꞌu-ha, ");
INSERT INTO kiw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ida paaꞌo rii-do, “Riꞌo-ro ai-omooꞌu kaumo ara dubui mooi-do, ida aaꞌo kaumo, ara dubui-ro uubi kekai imodau. Irai moo-ro doꞌou riꞌo hohoi-da ruu eaꞌai-da, moo-ro ruu reꞌei-da ata raa memiho ememeeꞌa bia, riꞌo-ro ruu hobou ahoꞌoo kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroda-ro gaaꞌu emerai-ka, ruu-ro ata memiho ememeeꞌa bia, aaꞌo rauri otiodoai maaka araimai rimoi-do. Ara dubui-ro ata memiho raa ododiai bia ruu ma iihiai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kaida moo-ro, ruu oohiidioi raꞌai ma ororihoumoi-ri, ka omopiimoi raꞌai ma odai-ri.” ");
INSERT INTO kiw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Turiaha uubi-ro geega madei-to paaꞌoumo, “Iesu aiꞌiiaumo, rimo-ri Barabasi omopiimoumo.” ");
INSERT INTO kiw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabasi goꞌoto geegai goroi-da uubi haharubuae pidodiai, kamia ruu-ro meree ata rituo-ha ai-paiꞌiia, aaꞌo rau-ri ruu duꞌi motoi-da pibiꞌaumo.) ");
INSERT INTO kiw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pirato rio-ka Iesu omopiimoi, ka uubi ata iatohetai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Irai rii-ro geema madei-to paaꞌoumo, “Odoꞌaumo! Emadoumo! Odoꞌaumo ruu!” ");
INSERT INTO kiw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pirato madei retoꞌa-gaaꞌui (3) iaaꞌoi-da ruu-ro aaꞌoi-ka, “Ruu memiho aꞌai bia. Moo-ro ata raa ememeeꞌa bia, ruu ma iihiai-ri! Aaꞌo rau-ri moo-ro ruu ororihoi raꞌai, ka romopiimo.” ");
INSERT INTO kiw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Irai rii madei pairautu hiꞌa paaꞌoumo, Iesu aiha ma odoꞌaumoi-ri. Kiauka iarai-da rii iaaꞌoumo madei modobo aiha piiꞌi. ");
INSERT INTO kiw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pirato-ro aahuu ododia-ka uubi ioroaroumoi, Iesu ma aiꞌiaumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Rii-ro rio iaꞌaimo mereei, haharubuae iaꞌai kamia dubu ata iaiꞌiia rituo-ha, ruu-ro omopiimoi-ka, ohuuꞌoi-ri, duꞌi motoi-da. Ka Iesu ai-pimaꞌai rii rioi ma ododiaimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kiauka, heamo uubi-ro Iesu iomodaumoi-da, dubu ata emeeꞌaumoi-ka, satauroi emaaꞌotaimoi-ka, Iesu didimoi-da ma omodai-ri. Ruu pairai Simora-ka, Sairiri dubu-ka. Taitai-da mati ataato pooꞌu, goꞌoto geegai eito. ");
INSERT INTO kiw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hiiro hiꞌa uubi-ro pobodoumo, ka rii ipi tuiai-da aamiꞌa upibaiꞌoi Iesu didimoi-da, giiꞌepu idebi emaꞌai-ha pobodoumo. ");
INSERT INTO kiw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iesu-ro rii iimeteai-ka, ida paaꞌo, “Ierusarema upibaiꞌo! Moo idebi emaꞌaimoꞌa, irai riꞌo himiai-re riꞌo himia mereei-re idebi-ha eremaꞌaimo. ");
INSERT INTO kiw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mabu himioi ai-ooꞌu, uubi-ro aaꞌoi aꞌai kaumo, ‘Mea hiꞌai-ka kaaro upibaiꞌoi, meree iotuti tiatoi, kamia iomoto tiatoi!’ ");
INSERT INTO kiw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ire aaꞌo himiou-da, uubi-ro aaꞌoi aꞌai kaumo roꞌoai eito, ‘Rimo ohui-da irahiai!’ ka roꞌoa keekei eito aaꞌoi aꞌai kaumo, ‘Rimo riiateꞌemai!’ ");
INSERT INTO kiw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kaida araibau raarai aia morododiai duumo, moo oio ruꞌai aibo-ka. Moo memiho tiato-ka, irai moo aiꞌia toto aꞌai kaumo. Ka raꞌaibou ooꞌai maꞌai, riꞌoi-do? Riꞌo mia toatoa ruꞌai aibo-ka, erai-ro iruro.” ");
INSERT INTO kiw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Retoꞌa dubui, turiaha riiti piro-ka, gaaꞌu-ha pimodaumo, ma imadoumoi-ri, Iesu rautu. ");
INSERT INTO kiw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Rii iooꞌumoi-da mati ata-ka ai-pahoꞌoumo “epuu horo”, Iesu hiei-da podoꞌaumo, ka piro mereeti-re, atai ruu iha tui hapuoi-da, atai keaꞌi tui hapuoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesu-ro paaꞌo, “Aba-o, rii memihoi imapihiti! Rii umoo bia rii raꞌu maꞌai duumo.” Rii-ro kase orioumoi-ka, ruu hipurai, ma eremaꞌaimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ka uubi iotimoi-da ruu ieaꞌaumo, kaida Iuda epuuhoro uubi-ro ai-pemerioumo, “Ruu-ro aamiꞌai oroiꞌioi-da tauo pidiꞌaamo, ka ruu himia ma eredeꞌa oroiꞌioi-da, ruu Aiai Iehoma-ro iapui Paidubui-ro ooꞌaato!” ");
INSERT INTO kiw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ka heamo uubi-ro aatu emerai iemerioumoi-da, rii-ro didia mire obo emaꞌaimoi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ida paaꞌoumo, “Roo himia oromoabai, roo Iuda uubi Paidubui-ro ooꞌaato!” ");
INSERT INTO kiw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ruu-ro omiorai-da piꞌatimo ara madei, “Ara Iuda uubi Paidubui-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Iamitidio piro mereeti atai-ro pupuoi-to aaꞌoi-ka Iesui-do, “Roo Iehoma-ro iapui Paidubui-ra? Roo himia-ro oroiꞌioi-da eredeꞌa, ka rimoiti-re.” ");
INSERT INTO kiw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kamia piro atai-ro atai erehe rautu-ha pomoaimai, “Roo toe aꞌai bia-ra Aiai Iehomai-do? Rimoiti temetemei emera temeteme eidai ruu. ");
INSERT INTO kiw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Rimoiti himia iraꞌaido memihoi taꞌii rimidai kaido, irai ara dubui ata raa memiho ododiai bia.” ");
INSERT INTO kiw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kaida paaꞌo ruu-ro Iesui-do, “Iesu-o, roo pai emidio erarai rautu ooꞌui aꞌai-da, moo ita riraromo!” ");
INSERT INTO kiw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu-ro ruu omoaimai-ka, “Roo moo-ro ihahai roduuꞌai, doꞌou roo moo rautu emidioi aꞌai oropoiꞌo tiato oroiꞌio ooꞌa mati-da.” ");
INSERT INTO kiw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ka himio mabui epuui pikui ohiai taitai-da, himioi hehei aiha poropoiꞌo, duꞌi-ro hepu geemai aiha patimai iodau himio mabui retoꞌa-gaaꞌui-da (3) eredeꞌai-ka. Irudeme motoi iamitidio hipura geemai, aiha poroaheꞌa retoꞌa kere imorododiai. ");
INSERT INTO kiw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu-ro geema madei-to paaꞌo, “Aba-o, moo urioi roo tui eito ai-remaꞌai.” Ruu aaꞌo emerai iaaꞌoi haato piihiai. ");
INSERT INTO kiw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Heamo uubi epuuhoro dubui-ro ieaꞌai-da iorododiai raai, ruu-ro Iehoma aiha pemarahue, kaida paaꞌo, “Iaha-ka, ruu mea hiꞌa dubu-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ioodabuaimo uubi hiiroi-ro, ieaꞌaumoi-da iorododiai raai, iiraimaimoi-ka giiꞌepu idebi rautu moto-motoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iesu Garereiaato iobodoumo upibaiꞌoi-re, ruu umoo uubi-re, auꞌoi haato pitoꞌutimo, iaꞌaimo raarai ma iaꞌaumoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Dubu ata paira-ka Iosepa, Arimatea dubu-ka, goꞌoto ata-ka Iudea hepui-da. Ruu mea hiꞌa dubu-ka, ai-pomoti Iehoma pai emidio erarai ma ooꞌui-ri, kamia ruu oroaduꞌuti paira meree ata-ka, irai ruu orodabuai bia rii iatomudioumo aiboi-re, kamia iaꞌaimo raarai-reꞌei-da. ");
INSERT INTO kiw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ruu aiha podoro Pirato iemidio hohoi eito, Iesu tuupi-ri oroaroi-ka. ");
INSERT INTO kiw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kiauka Iesu tuupi omoruoi-ka satauroi-da, mea hipurai-da aupoi-ka, aiha pedeꞌa ioboboumo roꞌoa uuꞌui-da, epuui-to aaꞌo boboi-da rituo ata edeꞌa bia. ");
INSERT INTO kiw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aaꞌo himiou Paraide-ka, Sabati omahoroi taitai-ka. ");
INSERT INTO kiw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ka Garereiaato Iesu iobodoumo upibaiꞌoi, Iosepa rautu podaumo boboi ma emeeꞌaumoi-ri, ka ma eaꞌaumo, Iesu tuupi raꞌaibou edeꞌai maꞌai, boboi rioi-da. ");
INSERT INTO kiw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kiauka, rii iraimai-ka motoi eito, ribo mea raabari-re kamia herei-re ma eremaumodiimo tuupi eito. Sabati-da rii hora-ka, aiha pemidioumo bubui-ro iaaꞌo emerai. ");
INSERT INTO kiw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Puura ihai duoduo hiꞌai upibaiꞌoi ieremaumodiimo mea ribo raabari-re herei-re rautu podaumo roꞌoa uuꞌui eito. ");
INSERT INTO kiw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Rii-ro roꞌoa uuꞌui hohoi ioopatidio roꞌoa kopi kekai-da pemeeꞌaumo, tauo paraꞌerai. ");
INSERT INTO kiw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ka rii iidoumoi-ka, irai Paidubui Iesu tuupi emeeꞌaumo bia. ");
INSERT INTO kiw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ka rii mooꞌui hiiro-hiiro piraromoumo aaꞌo rai eito, ida retoꞌa dubuoti iobodidoi-ka hehe hiꞌa hipura rautu, rii kekai-da. ");
INSERT INTO kiw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ka iha toei rautu upibaiꞌoi ihimaimoi-ka, hepui eito, kaida aaꞌo dubuoti-ro aaꞌoidoi-ka upibaiꞌoi eito, “Oroiꞌio mereei rituo uubi reꞌei-da, raꞌu-ri moohoo duumo? ");
INSERT INTO kiw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ruu arahiou-da bia, ruu tauo eibua maaka! Amiraromo duumo, ruu-ro riꞌo iduuꞌai madei ruu Garereiaato riꞌo rautu iemidioi-da? ");
INSERT INTO kiw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Uubihaubi Mereei imaꞌai aꞌai kaumo memiho uubi eito, moodoꞌa duumo, ka retoꞌa-gaaꞌu (3) himioi didimoi-da, ruu oroitorai aꞌai oroiꞌioi eito.’” ");
INSERT INTO kiw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ka aaꞌo upibaiꞌoi-ro iraromaimoi-ka Iesu iaaꞌo madei. ");
INSERT INTO kiw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Rii roꞌoa uuꞌui-da iiraimaimoi-da, Iesu-ro iimatomudio iremeri (11) mereei uubi aamiꞌai rautu, turiaha raarai aiha pimoaduꞌutimo. ");
INSERT INTO kiw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Rii-ka Maria Magadara, Ioara, kamia Maria Iemisi maamui, ka upibaiꞌoi aamiꞌai-re, rii-ro pimoaduꞌoumo turiaha iiobodimo raarai iiapui made himoꞌa uubi eito. ");
INSERT INTO kiw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Irai rii-ro upibaiꞌoi madei eidaimo bia, mabu rii madei amaamo-ha pimeeꞌaumo. ");
INSERT INTO kiw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Irai Petero eibuai-ka, hio-ha podau roꞌoa uuꞌui eito, ruu ihimai-ka, ka ruu-ro Iesu iiaupoumo hipurai-ha pemeeꞌa, ata raa tiato-ha, ruu araimai-ka pauo hiꞌa iraromoi rautu ioobodiimo raarai-ri. ");
INSERT INTO kiw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Gaaꞌu himioi-da, Iesu iobodoumo uubi-da mereeti ata, ai-podaido goꞌoto ata Emausi-to, odoboai-da auꞌoi semeri (7) maire aibo-ka Ierusaremaato, ");
INSERT INTO kiw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ka riiti-ro himia poroaduꞌutiido turiaha irododiaimo raarai. ");
INSERT INTO kiw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Riiti oroaduꞌuti iatomudioido, goroi haato Iesu himia tauo-ha poohiꞌiai riiti taitai eito, ka gaaꞌu-ha pimadaꞌuibiimo. ");
INSERT INTO kiw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Riiti-ro Iesu ieaꞌaido, irai ata aibo-ka, oibomaido bia. ");
INSERT INTO kiw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu-ro aaꞌoi-ka riiti-do, “Raꞌu moroaduꞌuti duido, riꞌoiti imadaꞌui hobohoboi?” Riiti piroha potoꞌaido giiꞌepu hoho-ha. ");
INSERT INTO kiw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Atai, paira-ka Kiriopasi, ruu-ro Iesu atohetai-ka, “Roo Ierusaremai-to doꞌou-ha amooꞌu, roo umoo iiꞌi bia-ra iorohodi duumo himioti-da iiorododiai duumo raarai?” ");
INSERT INTO kiw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu-ro paraato, “Raꞌu raara-rie?” Riiti-ro pomoaimaido, “Iaꞌai duumo raarai Rasareta Iesui eito. Ruu himogabo dubu-ka, ruu madei-re, ruu iaꞌai raarai erara-ka Iehomai-re uubi-rei hohoi-da. ");
INSERT INTO kiw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Rimo imeiꞌimotatidio uubi-re, Iehoma poue emaꞌatidio epuuhoro uubi-reiro, ai-imaꞌai duumo ma aiꞌiaumoi-ri, ka iodoꞌa duumo. ");
INSERT INTO kiw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ka rimo-ro ai-piriraromoumo, ruu beha-ro Isaraꞌera oroiꞌioi-da edeꞌai aꞌai! Aamiꞌa raarai kekai-da, doꞌou retoꞌa-gaaꞌu (3) himioi-ka, ara raarai iobodi duumoi. ");
INSERT INTO kiw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kaida aamiꞌa upibaiꞌo-ro rimo paꞌai-da, rimo ai-rimaparuti duumo, rii duoduo hiꞌa odau duumo boboi eito, ");
INSERT INTO kiw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","irai rii-ro ruu tuupi emeeꞌaumo bia. Ka rii iiraimai duumoi-da, ai-aaꞌo duumo, arerui ai-oobodii maaka, kaida arerui-ro ai-aaꞌo ruu ai-oroiꞌio. ");
INSERT INTO kiw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Rimo paꞌai aamiꞌai-ro iodau duumoi-da boboi eito, raarai turiaha upibaiꞌoi-ro iaaꞌo duumo emerai-ha imeꞌa duumo, irai rii-ro Iesu eaꞌaumo bia.” ");
INSERT INTO kiw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kaida Iesu-ro paaꞌo riiti-do, “Riꞌo amaamo hiꞌa-ka! Riꞌo iraromoi emera hiꞌa-ka, himogabo uubi-ro turiaha iaaꞌoumo raarai pupuo iraromoi-da ma ideꞌai! ");
INSERT INTO kiw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Modobo-ka, Iehoma iapui mereei araibau memiho temeteme ma imidai, ida ma odoroi Iehoma tomioi goroi eito.” ");
INSERT INTO kiw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ka Iesu-ro iha meai-da imoaduꞌoi omahoroi-ka, titi-madei-ro, ruu iioaduꞌo emerai, Mose titi-da pomahoro, aiha podau turiaha himogabo uubi-ro, iꞌatimo titi aiha pipoiꞌo. ");
INSERT INTO kiw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ka riibi iooꞌumoi-da iodaumo goꞌotoi taitai eito, Iesu auꞌoi eito odau emera-ha podoboa. ");
INSERT INTO kiw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Irai riiti-ro aiha poduꞌaido, rimoiti rautu ooꞌu motoi eito, “Rimo rautu emidioi, himioi taitai hiꞌa-ka oropoiꞌoi aꞌai, ka mati duꞌi-ro ai-eidai.” Kiauka, ruu odai-ka rii rautu emidioi. ");
INSERT INTO kiw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ka ruu emiꞌei-ka iihoi, riiti rautu, paramai eidai-ka, keito made aaꞌoi-ka Iehomai-do, ka aiha pehebia, imaꞌai-ka rii-do. ");
INSERT INTO kiw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ka riiti idomai ihaha aiha piamodiido ruu oibomai-ka, irai Iesu riiti idomai gaboi haato paraatoai. ");
INSERT INTO kiw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Riiti himia oromoaduꞌoi-ka, “Ruu-ro rimoiti irimoaduꞌuti-da gaboi ipi-da, kaida titi-madei iha meai-da mia irimoaduꞌuti, iaha, rimo kaukai-da geꞌii erai emerai agiradi?” ");
INSERT INTO kiw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Riiti gaaꞌu hiꞌa-ha pireibuaido iraimai Ierusaremai-to, ka hieꞌei-da pimeeꞌaido iremeri (11) iimatomudio mereei gaaꞌu-ha poodabuaimo aamiꞌai rautu, ");
INSERT INTO kiw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ida iodabuaimo uubi-ro paaꞌoumo, “Paidubui, tauo eibua maaka, ihaha-ka! Ruu tauo oobodi maaka, Simorai-do!” ");
INSERT INTO kiw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ka epuui retoꞌai-ro, rii-do raꞌu-ro oobodi gabo ipi-da, imoaduꞌoi-ka, riiti-ro ioibomaido emerai, Paidubui-ro paramai iehebiai-da. ");
INSERT INTO kiw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Riiti-ro ararau ioroaduꞌoidoi-da, Iesu rii tuiai haato pitooꞌa, kaida paaꞌo rii-do, “Miroi riꞌo rautu-ka.” ");
INSERT INTO kiw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ka rii iha toei paꞌaimo, rii-ro ai-piraromoumo egai eaꞌa kaumo. ");
INSERT INTO kiw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Irai ruu-ro aaꞌoi-ka rii-do, “Riꞌo raꞌu urio modaudio duumo, kamia raꞌu-ri iraromo pauo maꞌai duumo? ");
INSERT INTO kiw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Moo tu-ra oto-rai reaꞌaumo, moo ihai-ka. Moo raihimoumo, riꞌo umoo iiꞌi aꞌai kaumo, mabu egai hiꞌo-ra horo-ra tiato-ka, riꞌo-ro mooato eaꞌa emerai.” ");
INSERT INTO kiw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ruu ibai iaaꞌoi-da, pimoahuꞌomai, ruu tu-ra oto-rai. ");
INSERT INTO kiw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rii geema geꞌii iraromo rautu, irai pupuo iraromoi-da aahuu ododiai modobo bia, kaida piatohetai, “Ara hiou-da, riꞌo iiho raara amiiꞌa?” ");
INSERT INTO kiw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Rii-ro ruu iruro-iruro raa emaꞌai-ka, ");
INSERT INTO kiw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ka aiha peidai, uuhoi-ri, rii idomai gaboi-da. ");
INSERT INTO kiw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kaida paaꞌo ruu-ro rii-do, “Ara moo iraaꞌo raarai-ka, moo riꞌo rautu iremidioi-da, turiaha moo iroaduꞌoumo titi, Mose bubui-da, ka himogabo uubi-ro iꞌatimo, Saramoaato, aaꞌo raarai ihahai eito obodi aꞌai kaumo.” ");
INSERT INTO kiw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kiauka ruu-ro rii mooꞌui iaꞌerai-ka, titi-madei umoo ma iiꞌimoi-ri. ");
INSERT INTO kiw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ida paaꞌo rii-do, “Ara iꞌatimo madei-ka, Iehoma-ro iapui mereei, memiho hiꞌa temetemei eidai aꞌai, ka rituoi-da eibua aꞌai, retoꞌa-gaaꞌu himioi-da. ");
INSERT INTO kiw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ka ruu pairai-da, Iehoma orotomu madei, oroiꞌioi imeheꞌeai, kamia memihoi imapihiti, ma imoaduꞌuti hepu gaaꞌu-gaaꞌu eito. Ierusaremaato, ma omahoroi. ");
INSERT INTO kiw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Riꞌo geua uubi-ka, turiaha ara raarai eito. ");
INSERT INTO kiw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Moo himia hiꞌa haa-ro otiodoai raꞌai riꞌoi-do, moo Abeai-ro riꞌo imaꞌai-ri, iimamaihidio raai. Irai omoti aꞌai kaumo goꞌoto geegai-da, modau-die erarai aia mooruo hoꞌui-da, ka riꞌo iatimai aꞌai.” ");
INSERT INTO kiw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kiauka, ruu-ro rii imohuꞌoi-ka goꞌoto geemai-da, Betari taitai eito, hiei-da ruu tui imiꞌai-ka, meai aiha pimaꞌai. ");
INSERT INTO kiw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ka meai imaꞌai haato, ruu omodadeai-ka, omioi aromoi eito. ");
INSERT INTO kiw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Rii-ro ruu iemarahueumo, kiauka aiha piraimaimo, iha geꞌii rautu, Ierusaremai-to. ");
INSERT INTO kiw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ka himio tutuꞌutui irudeme motoi-da pipoiꞌutimo, Iehoma pemarahueumo. ");
ALTER TABLE kiw_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
