﻿USE sofia;
DROP TABLE IF EXISTS sofia.kik_vpl;
CREATE TABLE kik_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kik_vpl WRITE;
INSERT INTO kik_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kĩambĩrĩria-inĩ kĩa maũndũ mothe, Ngai nĩombire igũrũ na thĩ. ");
INSERT INTO kik_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Hĩndĩ ĩyo thĩ ndĩarĩ ũrĩa yatariĩ na ndĩarĩ na kĩndũ, nayo nduma yarĩ igũrũ rĩa kũrĩa kũriku, nake Roho wa Ngai aareerete igũrũ rĩa maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Nake Ngai agĩathana, akiuga atĩrĩ, “Nĩkũgĩe ũtheri,” na gũkĩgĩa ũtheri. ");
INSERT INTO kik_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ngai akĩona atĩ ũtheri ũcio warĩ mwega, nake akĩgayũkania ũtheri na nduma. ");
INSERT INTO kik_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ngai agĩĩta ũtheri ũcio “mũthenya,” nayo nduma akĩmĩĩta “ũtukũ.” Na gũkĩgĩa hwaĩ-inĩ, na gũkĩgĩa rũciinĩ. Ũcio ũgĩtuĩka mũthenya wa mbere. ");
INSERT INTO kik_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nake Ngai agĩathana, akiuga atĩrĩ, “Nĩkũgĩe wariĩ mũnene gatagatĩ ka maaĩ ũgayũkanie maaĩ na marĩa mangĩ.” ");
INSERT INTO kik_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nĩ ũndũ ũcio Ngai agĩĩkĩra wariĩ ũcio na akĩgayũkania maaĩ marĩa maarĩ thĩ ya wariĩ ũcio na maaĩ marĩa maarĩ igũrũ rĩaguo. Na gũgĩtuĩka o ũguo. ");
INSERT INTO kik_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ngai agĩĩta wariĩ ũcio “matu mairũ.” Na gũkĩgĩa hwaĩ-inĩ na gũkĩgĩa rũciinĩ. Ũcio ũgĩtuĩka mũthenya wa keerĩ. ");
INSERT INTO kik_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nake Ngai agĩathana, akiuga atĩrĩ, “Maaĩ marĩa marĩ thĩ ya matu mairũ nĩ mongane handũ hamwe na kũgĩe thĩ nyũmũ.” Na gũgĩtuĩka o ũguo. ");
INSERT INTO kik_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ngai agĩĩta kũrĩa kũmũ “thĩ,” namo maaĩ marĩa maacookanĩrĩire akĩmeeta “maria.” Nake Ngai akĩona atĩ ũndũ ũcio warĩ mwega. ");
INSERT INTO kik_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ningĩ Ngai agĩathana, akiuga atĩrĩ, “Thĩ nĩ ĩmere mĩmera: Mĩmera ĩrĩa ĩciaraga mbeũ, na mĩtĩ ĩrĩa ĩciaraga matunda marĩ na mbeũ thĩinĩ, kũringana na mĩthemba yayo.” Na gũgĩtuĩka o ũguo. ");
INSERT INTO kik_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Thĩ ĩkĩmera mĩmera: Mĩmera ĩgũciara mbeũ kũringana na mĩthemba yayo, na mĩtĩ ĩgũciara matunda marĩ na mbeũ thĩinĩ kũringana na mĩthemba yayo. Nake Ngai akĩona atĩ ũndũ ũcio warĩ mwega. ");
INSERT INTO kik_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nakuo gũkĩgĩa hwaĩ-inĩ na gũkĩgĩa rũciinĩ. Ũcio ũgĩtuĩka mũthenya wa gatatũ. ");
INSERT INTO kik_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ningĩ Ngai agĩathana, akiuga atĩrĩ, “Nĩkũgĩe imũrĩ wariĩ-inĩ wa matu mairũ cia kũgayũkania mũthenya na ũtukũ, na irekwo ituĩke imenyithania cia imera, na mĩthenya na mĩaka. ");
INSERT INTO kik_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Na ituĩke imũrĩ wariĩ-inĩ ũcio wa matu mairũ, itũmage thĩ kũgĩage na ũtheri.” Na gũgĩtuĩka o ũguo. ");
INSERT INTO kik_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ngai nĩombire imũrĩ igĩrĩ nene. Kĩmũrĩ kĩrĩa kĩnenanene, nĩkĩo riũa, kĩarage mũthenya; nakĩo kĩmũrĩ kĩrĩa kĩninanini, nĩkĩo mweri, kĩarage ũtukũ. O na ningĩ akĩũmba njata. ");
INSERT INTO kik_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ngai agĩciiga wariĩ-inĩ wa matu mairũ itũmage thĩ kũgĩe ũtheri, ");
INSERT INTO kik_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ciarage mũthenya na ũtukũ, na igayũkanagie nduma na ũtheri. Nake Ngai akĩona atĩ ũndũ ũcio warĩ mwega. ");
INSERT INTO kik_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Na gũkĩgĩa hwaĩ-inĩ na gũkĩgĩa rũciinĩ. Ũcio ũgĩtuĩka mũthenya wa kana. ");
INSERT INTO kik_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ningĩ Ngai agĩathana, akiuga atĩrĩ: “Maaĩ nĩmaiyũrwo nĩ ciũmbe irĩ muoyo, nacio nyoni nĩciũmbũkagĩre igũrũ rĩa thĩ gũtuĩkania wariĩ wa matu mairũ.” ");
INSERT INTO kik_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Nĩ ũndũ ũcio Ngai akĩũmba ciũmbe iria nene cia iria-inĩ na kĩũmbe o gĩothe kĩrĩ muoyo na kĩongoyaga, ikĩiyũra maaĩ-inĩ kũringana na mĩthemba yacio, na nyoni o yothe ĩrĩ mathagu kũringana na mũthemba wayo. Nake Ngai akĩona atĩ ũndũ ũcio warĩ mwega. ");
INSERT INTO kik_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ngai agĩcirathima akiuga atĩrĩ, “Ciaranai mũingĩhe, mũiyũre maaĩ-inĩ marĩa marĩ maria-inĩ, nacio nyoni nĩcingĩhe thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Na gũkĩgĩa hwaĩ-inĩ na gũkĩgĩa rũciinĩ. Ũcio ũgĩtuĩka mũthenya wa gatano. ");
INSERT INTO kik_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ningĩ Ngai agĩathana, akiuga atĩrĩ, “Thĩ nĩĩgĩe ciũmbe irĩ muoyo kũringana na mĩthemba yacio: mahiũ, na ciũmbe iria ithiiagĩra thĩ, na nyamũ cia gĩthaka, o nyamũ kũringana na mũthemba wayo.” Na gũgĩtuĩka o ũguo. ");
INSERT INTO kik_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ngai akĩũmba nyamũ cia gĩthaka kũringana na mĩthemba yacio, na mahiũ kũringana na mĩthemba yamo, na ciũmbe ciothe iria ithiiagĩra thĩ kũringana na mĩthemba yacio. Nake Ngai akĩona atĩ ũndũ ũcio warĩ mwega. ");
INSERT INTO kik_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ningĩ Ngai agĩathana, akiuga atĩrĩ, “Nĩtũũmbei andũ na mũhianĩre witũ, mahaanane na ithuĩ, nao maathage thamaki cia iria na nyoni cia rĩera-inĩ, na mahiũ ma thĩ yothe, na maathage ciũmbe ciothe iria ithiiagĩra thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Nĩ ũndũ ũcio Ngai akĩũmba mũndũ ");
INSERT INTO kik_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ngai akĩmarathima, akĩmeera atĩrĩ, “Ciaranai mũingĩhe, mũiyũre thĩ na mũmĩtoorie. Athagai thamaki cia iria na nyoni cia rĩera-inĩ, na mwathage ciũmbe ciothe irĩ muoyo iria ithiiagĩra thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ningĩ Ngai akiuga atĩrĩ, “Nĩndamũhe mĩmera yothe ya thĩ ĩrĩa ĩciaraga mbeũ, na mũtĩ o wothe ũrĩa ũciaraga matunda marĩ mbeũ thĩinĩ. Ĩyo ĩgũtuĩka irio cianyu. ");
INSERT INTO kik_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na kũrĩ nyamũ ciothe cia gũkũ thĩ, na nyoni ciothe cia rĩera-inĩ, o na ciũmbe ciothe iria ithiiagĩra thĩ, na kĩndũ o gĩothe kĩrĩ mĩhũmũ ya muoyo-rĩ, ndaacihe mĩmera mĩruru yothe ĩtuĩke irio ciacio.” Na gũgĩtuĩka o ũguo. ");
INSERT INTO kik_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ngai akĩona atĩ kĩndũ kĩrĩa gĩothe oombĩte kĩarĩ kĩega mũno. Nakuo gũkĩgĩa hwaĩ-inĩ na gũkĩgĩa rũciinĩ. Ũcio ũgĩtuĩka mũthenya wa gatandatũ. ");
INSERT INTO kik_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Igũrũ na thĩ ikĩrĩka na ũgemu wacio wothe. ");
INSERT INTO kik_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Naguo mũthenya wa mũgwanja wakinya, Ngai agĩkorwo arĩkĩtie wĩra ũcio aarutaga; nĩ ũndũ ũcio Ngai akĩhurũka mũthenya ũcio wa mũgwanja kuuma wĩra-inĩ wake wothe. ");
INSERT INTO kik_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Nake Ngai akĩrathima mũthenya ũcio wa mũgwanja na akĩwamũra, tondũ nĩ mũthenya ũrĩa we aahurũkire kuuma wĩra-inĩ wothe ũrĩa aarutĩte wa ũũmbi. ");
INSERT INTO kik_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ũcio nĩguo ũhoro ũrĩa wĩgiĩ igũrũ na thĩ rĩrĩa ciombirwo. Rĩrĩa Jehova Ngai ombire thĩ na igũrũ-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","gũtiarĩ kahinga o na kamwe ga gĩthaka koonekete thĩ kana mũmera wa gĩthaka ũkamera. Nĩ tondũ Jehova Ngai ndoirĩtie mbura thĩ na gũtiarĩ mũndũ wa kũrĩma mũgũnda, ");
INSERT INTO kik_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","no tũrũũĩ twoimaga na thĩ na tũkaihũgia thĩ igũrũ guothe. ");
INSERT INTO kik_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Nake Jehova Ngai akĩũmba mũndũ kuuma rũkũngũ-inĩ rwa thĩ, na akĩmũhuhĩra mĩhũmũ ya muoyo maniũrũ-inĩ make, nake mũndũ ũcio akĩgĩa na muoyo. ");
INSERT INTO kik_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ningĩ Jehova Ngai nĩathondekete mũgũnda mwena wa irathĩro, o kũu Edeni; na kũu nĩkuo aigire mũndũ ũcio oombĩte. ");
INSERT INTO kik_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Nake Jehova Ngai agĩtũma thĩ ĩmere mĩtĩ ya mĩthemba yothe na ĩkũre. Yarĩ mĩtĩ mĩega ĩkĩoneka na maitho na yaciaraga matunda mega ma kũrĩa. Gatagatĩ ka mũgũnda ũcio nĩ haarĩ na mũtĩ wa muoyo, na mũtĩ wa ũmenyo wa gũkũũrana wega na ũũru. ");
INSERT INTO kik_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Na nĩ kwarĩ rũũĩ rwathereraga ruumĩte Edeni rũkaihũgia mũgũnda ũcio; ruoima Edeni rũkagayũkana rũgatuĩka njũũĩ inya. ");
INSERT INTO kik_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Rũũĩ rwa mbere rwĩtagwo Pishoni; na nĩruo rũthiũrũrũkaga bũrũri wothe wa Havila, kũrĩa kũrĩ thahabu. ");
INSERT INTO kik_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Thahabu ya bũrũri ũcio nĩ njega; ningĩ kũu no kũrĩ maguta manungi wega metagwo bendora, na tũhiga twa goro twĩtagwo onigithi.) ");
INSERT INTO kik_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Rũũĩ rwa keerĩ rwĩtagwo Gihoni; naruo rũthiũrũrũkaga bũrũri wothe wa Kushi. ");
INSERT INTO kik_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Rũũĩ rwa gatatũ rwĩtagwo Hidekela naruo rũgeragĩra mwena wa irathĩro wa bũrũri wa Ashuri. Naruo rũũĩ rwa kana rwĩtagwo Farati. ");
INSERT INTO kik_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Jehova Ngai akĩoya mũndũ ũcio oombĩte, akĩmũiga mũgũnda-inĩ ũcio wa Edeni aũrĩmage na aũmenyagĩrĩre. ");
INSERT INTO kik_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nake Jehova Ngai agĩatha mũndũ ũcio, akĩmwĩra atĩrĩ, “No ũrĩe maciaro ma mũtĩ o wothe ũrĩ mũgũnda ũyũ; ");
INSERT INTO kik_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","no rĩrĩ, ndũkanarĩe maciaro ma mũtĩ ũrĩa wa ũmenyo wa gũkũũrana wega na ũũru, nĩgũkorwo rĩrĩa ũkaamarĩa, ti-itherũ no gũkua ũgaakua.” ");
INSERT INTO kik_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ningĩ Jehova Ngai akiuga atĩrĩ, “Ti wega mũndũ ũyũ aikare arĩ wiki. Nĩngũmũmbĩra mũteithia ũrĩa ũmwagĩrĩire.” ");
INSERT INTO kik_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Na rĩrĩ, Jehova Ngai nĩ oombĩte nyamũ ciothe cia gĩthaka na nyoni cia rĩera-inĩ kuuma tĩĩri-inĩ. Agĩcirehe kũrĩ mũndũ ũcio one marĩĩtwa marĩa egũcitua; na ũrĩa mũndũ ũcio aatuire kĩũmbe o gĩothe kĩ muoyo, rĩu rĩgĩtuĩka rĩĩtwa rĩakĩo. ");
INSERT INTO kik_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Nĩ ũndũ ũcio mũndũ ũcio akĩhe mahiũ mothe marĩĩtwa, o na nyoni cia rĩera-inĩ na nyamũ ciothe cia gĩthaka. No Adamu ndooneirwo mũteithia ũmwagĩrĩire. ");
INSERT INTO kik_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Nĩ ũndũ ũcio Jehova Ngai agĩtũma mũndũ ũcio akome toro mũnene mũno; na rĩrĩa aakomete, Jehova Ngai akĩruta rũbaru rũmwe rwa mũndũ ũcio na agĩcookia nyama hau rwarĩ. ");
INSERT INTO kik_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Hĩndĩ ĩyo Jehova Ngai akĩũmba mũndũ-wa-nja kuuma rũbaru rũrĩa aarutĩte kũrĩ mũndũ ũcio na akĩrehe mũndũ-wa-nja ũcio kũrĩ we. ");
INSERT INTO kik_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Mũndũ ũcio akiuga atĩrĩ, “Hĩ! Rĩu-rĩ, rĩĩrĩ nĩ ihĩndĩ kuuma mahĩndĩ makwa, na nyama cia mwĩrĩ wakwa. Arĩĩtagwo mũndũ-wa-nja, tondũ aarutirwo kuuma kũrĩ mũndũ mũrũme.” ");
INSERT INTO kik_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Gĩkĩ nĩkĩo gĩtũmaga mũndũ mũrũme atige ithe na nyina, na anyiitane na mũtumia wake, nao magatuĩka mwĩrĩ ũmwe. ");
INSERT INTO kik_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Acio eerĩ, mũndũ ũcio na mũtumia wake, maarĩ njaga, na matiaconokaga. ");
INSERT INTO kik_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Na rĩrĩ, nyoka yarĩ na wara mũingĩ gũkĩra nyamũ ciothe cia gĩthaka iria Jehova Ngai oombĩte. Nyoka ĩyo ĩkĩũria mũndũ-wa-nja ũcio atĩrĩ, “Ti-itherũ Ngai nĩ oigire mũtikanarĩe maciaro kuuma mũtĩ o wothe wa mũgũnda ũyũ?” ");
INSERT INTO kik_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mũndũ-wa-nja ũcio agĩcookeria nyoka ĩyo atĩrĩ, “No tũrĩe matunda ma mĩtĩ ĩrĩa ĩrĩ mũgũnda ũyũ, ");
INSERT INTO kik_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","no Ngai aatwĩrire atĩrĩ, ‘Mũtikanarĩe matunda ma mũtĩ ũrĩa ũrĩ gatagatĩ ka mũgũnda ũyũ, na mũtikanaũhutie, nĩguo mũtigakue.’ ” ");
INSERT INTO kik_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","No nyoka ĩkĩĩra mũndũ-wa-nja ũcio atĩrĩ, “Ti-itherũ mũtingĩkua. ");
INSERT INTO kik_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","No Ngai nĩoĩ atĩ rĩrĩa mũkaarĩa matunda macio, maitho manyu nĩmakahingũka, mũtuĩke o ta Ngai, mũmenyage wega na ũũru.” ");
INSERT INTO kik_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Rĩrĩa mũndũ-wa-nja ũcio onire atĩ matunda ma mũtĩ ũcio maarĩ mega ma kũrĩa, na ma kwendeka makĩonwo na maitho, o na ma kwĩrirĩrio nĩ ũndũ wa kũũhĩgia mũndũ, agĩtua mamwe, akĩrĩa. Agĩcooka akĩhe mũthuuri wake, ũrĩa maarĩ nake, nake akĩrĩa. ");
INSERT INTO kik_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Hĩndĩ ĩyo maitho mao eerĩ makĩhingũka, nao makĩmenya atĩ maarĩ njaga; nĩ ũndũ ũcio magĩtumania mathangũ ma mũkũyũ, magĩĩthondekera kĩndũ gĩa kũhumbĩra njaga yao. ");
INSERT INTO kik_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Hwaĩ-inĩ rĩrĩa riũa rĩarurĩte-rĩ, mũndũ ũcio na mũtumia wake makĩigua makinya ma Jehova Ngai agĩceera kũu mũgũnda-inĩ, nao makĩĩhitha mĩtĩ-inĩ ya mũgũnda nĩguo Jehova Ngai ndakamone. ");
INSERT INTO kik_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","No Jehova Ngai agĩĩta mũndũ ũcio, akĩmũũria atĩrĩ, “Ũrĩ ha?” ");
INSERT INTO kik_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nake akĩmũcookeria atĩrĩ, “Niĩ ngũiguire ũgĩceera mũgũnda-inĩ ndeetigĩra tondũ nyuma njaga; nĩ ũndũ ũcio ndeehitha.” ");
INSERT INTO kik_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Nake Jehova akĩmũũria atĩrĩ, “Nũũ ũkwĩrire atĩ ũrĩ njaga? Kaĩ ũrĩĩte matunda ma mũtĩ ũrĩa ndagwaathire ngĩkwĩra ndũkanaũrĩe?” ");
INSERT INTO kik_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mũndũ ũcio akiuga atĩrĩ, “Mũndũ-wa-nja ũrĩa waheire ndũũranie nake nĩwe ũũheire matunda mamwe ma mũtĩ ũcio, na niĩ ndarĩa.” ");
INSERT INTO kik_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nake Jehova Ngai akĩũria mũndũ-wa-nja ũcio atĩrĩ, “Atĩ nĩ atĩa wĩkĩte?” Mũndũ-wa-nja ũcio akiuga atĩrĩ, “Nĩ nyoka ĩheenirie na niĩ ndarĩa matunda macio.” ");
INSERT INTO kik_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Nĩ ũndũ ũcio Jehova Ngai akĩĩra nyoka atĩrĩ, “Tondũ nĩwĩkĩte ũguo-rĩ, “Wee ũrogwatwo nĩ kĩrumi gũkĩra mahiũ mothe na gũkĩra nyamũ ciothe cia gĩthaka! Ũrĩthiiaga na nda, na ũrĩrĩĩaga rũkũngũ matukũ mothe ma muoyo waku. ");
INSERT INTO kik_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Na nĩngũtũma kũgĩe ũthũ gatagatĩ gaku na mũndũ-wa-nja ũyũ, na gatagatĩ ka rũciaro rwaku na rwake; nake nĩagakũhehenja mũtwe, nawe nĩũkamũgũtha ndiira ya kũgũrũ gwake.” ");
INSERT INTO kik_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ningĩ akĩĩra mũndũ-wa-nja ũcio atĩrĩ, “Nĩngũkũingĩhĩria ruo mũno hĩndĩ ya gũciara; ũrĩciaraga ciana na ruo. Merirĩria maku marĩkoragwo marĩ harĩ mũthuuriguo, nake nĩarĩgwathaga.” ");
INSERT INTO kik_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ningĩ Ngai akĩĩra Adamu atĩrĩ, “Tondũ nĩwathĩkĩire mũtumia waku, na warĩa matunda ma mũtĩ ũrĩa ndagwaathire, ngĩkwĩra atĩ, ‘Ndũkanarĩe,’ “Thĩ nĩyarumwo nĩ ũndũ waku; ũrĩrĩĩaga irio ciayo na ruo rwa mĩnoga matukũ mothe ma muoyo waku. ");
INSERT INTO kik_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ĩrĩgũciaragĩra mĩigua na mahiũ ma nyeki-inĩ, nawe ũrĩrĩĩaga mĩmera ya mũgũnda. ");
INSERT INTO kik_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ũrĩrĩĩaga irio cia thithino ya mĩnoga yaku, o nginya rĩrĩa ũgaacooka tĩĩri-inĩ, tondũ nokuo warutĩtwo; tondũ wee ũrĩ rũkũngũ na ũgaacooka o rũkũngũ-inĩ.” ");
INSERT INTO kik_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adamu agĩĩta mũtumia wake Hawa, tondũ nĩwe watuĩkire nyina wa arĩa othe matũũraga muoyo. ");
INSERT INTO kik_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Jehova Ngai agĩthondekera Adamu na mũtumia wake nguo cia njũũa, akĩmahumba. ");
INSERT INTO kik_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nake Jehova Ngai akiuga atĩrĩ, “Mũndũ ũyũ nĩatuĩkĩte o ta ũmwe witũ, akamenya wega na ũũru. Ndagĩrĩire gwĩtĩkĩrio atue matunda ma mũtĩ wa muoyo o namo, amarĩe nake atũũre nginya tene.” ");
INSERT INTO kik_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nĩ ũndũ ũcio Jehova Ngai akĩmũingata kuuma Mũgũnda wa Edeni athiĩ akarĩmage tĩĩri-inĩ kũrĩa aarutĩtwo. ");
INSERT INTO kik_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ngai aarĩkia kũrutũrũra mũndũ ũcio-rĩ, akĩiga akerubi mwena wa irathĩro wa Mũgũnda wa Edeni, o na rũhiũ rwa njora rwarĩrĩmbũkaga mwaki na rwahenagia mbarĩ ciothe, nĩ ũndũ wa kũgitĩra njĩra ya gũthiĩ mũtĩ-inĩ ũcio wa muoyo. ");
INSERT INTO kik_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nake Adamu agĩkoma na mũtumia wake Hawa, nake akĩgĩa nda, agĩciara Kaini. Nake akiuga atĩrĩ, “Ndĩkũgĩa na mwana wa kahĩĩ nĩ ũndũ wa gũteithio nĩ Jehova.” ");
INSERT INTO kik_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Thuutha ũcio agĩciara Habili, mũrũ wa nyina. Habili aarĩ mũrĩithi wa mbũri nake Kaini aarĩ mũrĩmi. ");
INSERT INTO kik_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Maikarĩte kwa ihinda-rĩ, Kaini akĩrehe maciaro mamwe ma mũgũnda marĩ igongona kũrĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","No Habili akĩrehe marigithathi mamwe marĩa manoru ma rũũru rwake. Nake Jehova agĩkenio nĩ Habili na igongona rĩake, ");
INSERT INTO kik_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","no ndaakenirio nĩ Kaini na igongona rĩake. Nĩ ũndũ ũcio Kaini akĩrakara mũno, na agĩtukia gĩthiithi. ");
INSERT INTO kik_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nake Jehova Ngai akĩũria Kaini atĩrĩ, “Ũrakarĩte nĩkĩ? Na nĩ kĩĩ gĩtũmĩte ũtukie gĩthiithi? ");
INSERT INTO kik_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ũngĩka ũrĩa kwagĩrĩire-rĩ, no wage gwĩtĩkĩrĩka? No ũngĩaga gwĩka ũrĩa kwagĩrĩire-rĩ, mehia makuoheirie mũrango-inĩ waku makĩenda gũgwatha; no wee no nginya ũmatoorie.” ");
INSERT INTO kik_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Thuutha ũcio Kaini akĩĩra mũrũ wa nyina Habili atĩrĩ, “Nĩtumagare tũthiĩ mũgũnda.” Na rĩrĩa maarĩ kũu mũgũnda, Kaini agĩtharĩkĩra mũrũ wa nyina Habili, akĩmũũraga. ");
INSERT INTO kik_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nake Jehova akĩũria Kaini atĩrĩ, “Arĩ ha mũrũ-wa-nyũkwa Habili?” Nake akĩmũcookeria atĩrĩ, “Niĩ ndiũĩ, kaĩ arĩ niĩ mũmenyereri wa mũrũ-wa-maitũ?” ");
INSERT INTO kik_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Jehova akĩmũũria atĩrĩ, “Nĩ atĩa wĩkĩte? Ta thikĩrĩria! Thakame ya mũrũ-wa-nyũkwa nĩĩrangaĩra ĩrĩ tĩĩri-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Na rĩrĩ, nĩũgwatĩtwo nĩ kĩrumi na ũkaingatwo mũgũnda ũrĩa waathamirie kanua kaguo kwamũkĩra thakame ya mũrũ-wa-nyũkwa kuuma guoko-inĩ gwaku. ");
INSERT INTO kik_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Rĩrĩa ũrĩũrĩmaga-rĩ, ndũgacooka gũgũciarĩra maciaro maguo. Ũgũtuĩka mũndũ ũtakindagĩria, wa kũũrũũraga gũkũ thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Nake Kaini akĩĩra Jehova atĩrĩ, “Iherithia rĩakwa nĩ inene gũkĩra ũrĩa ingĩhota gwĩtiiria. ");
INSERT INTO kik_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ũmũthĩ ũyũ nĩũranyingata kuuma mũgũnda ũyũ na ndũũre hithĩtwo ũthiũ waku; ngũtuĩka mũndũ ũtakindagĩria, wa kũũrũũraga gũkũ thĩ, na ũrĩa wothe ũkaanyona nĩakanjũraga.” ");
INSERT INTO kik_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","No Jehova akĩmwĩra atĩrĩ, “Aca, ti ũguo; mũndũ o na ũrĩkũ angĩkooraga Kaini, nĩakarĩhio maita mũgwanja.” Jehova agĩcooka agĩĩkĩra Kaini rũũri nĩgeetha ũrĩa wothe ũngĩmuona ndakamũũrage! ");
INSERT INTO kik_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Nĩ ũndũ ũcio Kaini akĩehera akiuma harĩ Jehova, na agĩtũũra bũrũri-inĩ wa Nodu, mwena wa irathĩro rĩa Edeni. ");
INSERT INTO kik_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kaini agĩkoma na mũtumia wake, na akĩgĩa nda, agĩciara Enoku. Hĩndĩ ĩyo Kaini nĩakaga itũũra inene, na aarĩkia kũrĩaka, akĩrĩĩta Enoku o ta ũrĩa mũriũ eetagwo. ");
INSERT INTO kik_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Nake Enoku agĩciarĩrwo Iradu, nake Iradu aarĩ ithe wa Mehujaeli, nake Mehujaeli aarĩ ithe wa Methushaeli, nake Methushaeli aarĩ ithe wa Lameku. ");
INSERT INTO kik_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lameku ũcio akĩhikia andũ-a-nja eerĩ, ũmwe eetagwo Ada na ũrĩa ũngĩ eetagwo Zila. ");
INSERT INTO kik_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada agĩciara Jabali; na nĩwe ithe wa andũ arĩa matũũraga hema-inĩ na marĩithagia mahiũ. ");
INSERT INTO kik_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mũrũ-wa nyina eetagwo Jubali; nake nĩwe ithe wa andũ arĩa othe mahũũraga inanda cia mũgeeto na makahuha mĩtũrirũ. ");
INSERT INTO kik_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila o nake aarĩ na mũriũ, nake eetagwo Tubali-Kaini, na nĩwe waturaga indo cia mĩthemba yothe cia gĩcango na cia kĩgera. Tubali-Kaini aarĩ na mwarĩ wa nyina wetagwo Naama. ");
INSERT INTO kik_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameku akĩĩra atumia ake atĩrĩ, “Ada na Zila, taa thikĩrĩriai; inyuĩ atumia a Lameku, ta iguai ciugo ciakwa. Nĩnjũragĩte mũndũ nĩ ũndũ wa kũndiihia, ngooraga mũndũ mwĩthĩ nĩ ũndũ wa kũnguraria. ");
INSERT INTO kik_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Angĩkorwo Kaini arĩhagĩrio maita mũgwanja-rĩ, Lameku nake akarĩhĩrio maita mĩrongo mũgwanja na mũgwanja.” ");
INSERT INTO kik_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nake Adamu agĩkoma na mũtumia wake rĩngĩ, nake agĩciara kaana ga kahĩĩ, na agĩgatua Sethi, akiuga atĩrĩ, “Ngai nĩaheete mwana ũngĩ handũ ha Habili, ũrĩa Kaini ooragire.” ");
INSERT INTO kik_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sethi o nake aarĩ na mũriũ wake, nake akĩmũtua rĩĩtwa Enoshu. Hĩndĩ ĩyo nĩrĩo andũ mambĩrĩirie gũkaĩra rĩĩtwa rĩa Jehova. ");
INSERT INTO kik_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ũyũ nĩguo ũhoro ũrĩa wandĩkĩtwo wĩgiĩ njiarwa cia Adamu. Hĩndĩ ĩrĩa Ngai oombire mũndũ-rĩ, amũũmbire na mũhianĩre wa Ngai. ");
INSERT INTO kik_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ngai aamoombire mũndũ mũrũme na mũndũ-wa-nja na akĩmarathima. Na aarĩkia kũmomba, akĩmeeta “mũndũ.” ");
INSERT INTO kik_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adamu aakinyia mĩaka igana na mĩrongo ĩtatũ-rĩ, akĩgĩa na mũriũ wamũtũkĩtie na wa mũhianĩre wake; nake akĩmũtua Sethi. ");
INSERT INTO kik_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Na thuutha wa Sethi gũciarwo-rĩ, Adamu agĩtũũra muoyo mĩaka ĩngĩ magana manana, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Mĩaka yothe ĩrĩa Adamu aatũũrire muoyo yarĩ mĩaka magana kenda na mĩrongo ĩtatũ, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sethi aakinyia mĩaka igana na ĩtano-rĩ, akĩgĩa na mũriũ wetagwo Enoshu. ");
INSERT INTO kik_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Na thuutha wa Enoshu gũciarwo-rĩ, Sethi agĩtũũra muoyo mĩaka ĩngĩ magana manana na mũgwanja na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Mĩaka yothe ĩrĩa Sethi aatũũrire muoyo yarĩ mĩaka magana kenda na ikũmi na ĩĩrĩ, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshu aakinyia mĩaka mĩrongo kenda-rĩ, akĩgĩa na mũriũ wetagwo Kenani. ");
INSERT INTO kik_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Na thuutha wa Kenani gũciarwo-rĩ, Enoshu agĩtũũra muoyo mĩaka ĩngĩ magana manana na ikũmi na ĩtano, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Mĩaka yothe ĩrĩa Enoshu aatũũrire muoyo yarĩ mĩaka magana kenda na ĩtano, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenani aakinyia mĩaka mĩrongo mũgwanja-rĩ, akĩgĩa na mũriũ wetagwo Mahalaleli. ");
INSERT INTO kik_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Na thuutha wa Mahalaleli gũciarwo-rĩ, Kenani agĩtũũra muoyo mĩaka ĩngĩ magana manana na mĩrongo ĩna, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Mĩaka yothe ĩrĩa Kenani aatũũrire muoyo yarĩ mĩaka magana kenda na ikũmi, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleli aakinyia mĩaka mĩrongo ĩtandatũ na ĩtano-rĩ, akĩgĩa na mũriũ wetagwo Jaredi. ");
INSERT INTO kik_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Na thuutha wa Jaredi gũciarwo-rĩ, Mahalaleli agĩtũũra muoyo mĩaka ĩngĩ magana manana na mĩrongo ĩtatũ, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mĩaka yothe ĩrĩa Mahalaleli aatũũrire muoyo yarĩ mĩaka magana manana na mĩrongo kenda na ĩtano, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jaredi aakinyia mĩaka igana na mĩrongo ĩtandatũ na ĩĩrĩ-rĩ, akĩgĩa na mũriũ wetagwo Enoku. ");
INSERT INTO kik_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Na thuutha wa Enoku gũciarwo-rĩ, Jaredi agĩtũũra muoyo mĩaka ĩngĩ magana manana, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Mĩaka yothe ĩrĩa Jaredi aatũũrire muoyo yarĩ mĩaka magana kenda na mĩrongo ĩtandatũ na ĩĩrĩ, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoku aakinyia mĩaka mĩrongo ĩtandatũ na ĩtano-rĩ, akĩgĩa na mũriũ wetagwo Methusela. ");
INSERT INTO kik_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Na thuutha wa Methusela gũciarwo-rĩ, Enoku agĩtũũra atwaranaga na Ngai mĩaka magana matatũ, akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Mĩaka yothe ĩrĩa Enoku aatũũrire muoyo yarĩ mĩaka magana matatũ na mĩrongo ĩtandatũ na ĩtano. ");
INSERT INTO kik_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enoku agĩtwarana na Ngai nginya akĩagwo tondũ Ngai nĩamuoire. ");
INSERT INTO kik_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methusela aakinyia mĩaka igana na mĩrongo ĩnana na mũgwanja-rĩ, akĩgĩa na mũriũ wetagwo Lameku. ");
INSERT INTO kik_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Na thuutha wa Lameku gũciarwo-rĩ, Methusela agĩtũũra muoyo mĩaka ĩngĩ magana mũgwanja na mĩrongo ĩnana na ĩĩrĩ, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Mĩaka yothe ĩrĩa Methusela aatũũrire muoyo yarĩ mĩaka magana kenda na mĩrongo ĩtandatũ na kenda, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameku aakinyia mĩaka igana na mĩrongo ĩnana na ĩĩrĩ-rĩ, akĩgĩa mwana wa kahĩĩ. ");
INSERT INTO kik_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Nake agĩgatua Nuhu, akiuga atĩrĩ, “Nĩarĩtũhooragĩria ruo rwa wĩra na mĩnoga ya moko maitũ rĩrĩa tũkũrĩma, tondũ Jehova nĩarumire thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Thuutha wa Nuhu gũciarwo-rĩ, Lameku agĩtũũra muoyo mĩaka ĩngĩ magana matano na mĩrongo kenda na ĩtano, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Mĩaka yothe ĩrĩa Lameku aatũũrire muoyo yarĩ mĩaka magana mũgwanja na mĩrongo mũgwanja na mũgwanja, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhu aakinyia ũkũrũ wa mĩaka magana matano-rĩ, akĩgĩa na ariũ ake na nĩo Shemu, na Hamu na Jafethu. ");
INSERT INTO kik_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Rĩrĩa andũ maambĩrĩirie kũingĩha thĩ na magĩciarĩrwo airĩtu-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ariũ a Ngai makĩona atĩ airĩtu a andũ maarĩ athaka, nao makĩhikia o ũrĩa mũndũ ethuuragĩra. ");
INSERT INTO kik_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nake Jehova akiuga atĩrĩ, “Roho wakwa ndegũtũũra agianaga na mũndũ nginya tene, tondũ mũndũ nĩ wa gũkua; matukũ make marĩkoragwo marĩ mĩaka igana na mĩrongo ĩĩrĩ.” ");
INSERT INTO kik_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na rĩrĩ, matukũ-inĩ macio, o na thuutha ũcio, rĩrĩa Anefili matũũraga gũkũ thĩ, nĩrĩo ariũ a Ngai maakomire na airĩtu a andũ na magĩciara ciana nao. Ciana icio nĩcio ciarĩ njamba cia tene na andũ arĩa maarĩ igweta. ");
INSERT INTO kik_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Jehova akĩona ũrĩa waganu wa andũ waingĩhĩte gũkũ thĩ, na atĩ merirĩria ma meciiria ma ngoro ciao maarĩ mooru hĩndĩ ciothe. ");
INSERT INTO kik_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Jehova akĩnyiitwo nĩ kĩeha nĩ ũndũ wa kũũmba mũndũ gũkũ thĩ, na ngoro yake ĩkĩiyũrwo nĩ ruo. ");
INSERT INTO kik_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Nĩ ũndũ ũcio Jehova akiuga atĩrĩ, “Nĩngũniina andũ, o arĩa niĩ ndombire, mathire kuuma thĩ, andũ na nyamũ, na ciũmbe iria ithiiagĩra thĩ, o na nyoni cia rĩera-inĩ, nĩgũkorwo ndĩ na kĩeha nĩ ũndũ wa gũciũmba.” ");
INSERT INTO kik_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","No Nuhu agĩĩtĩkĩrĩka maitho-inĩ ma Jehova. ");
INSERT INTO kik_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ũyũ nĩguo ũhoro wa Nuhu. Nuhu aarĩ mũndũ mũthingu, ũtaarĩ na ũcuuke kũrĩ andũ a hĩndĩ yake, na nĩatwaranaga na Ngai. ");
INSERT INTO kik_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu aarĩ na ariũ atatũ: nĩo Shemu, na Hamu na Jafethu. ");
INSERT INTO kik_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Thĩ nayo yarĩ thũku maitho-inĩ ma Jehova na yaiyũrĩtwo nĩ maũndũ ma ũhinya. ");
INSERT INTO kik_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ngai nĩonire ũrĩa thĩ yathũkĩte, nĩgũkorwo andũ othe a thĩ nĩmathũkĩtie mĩthiĩre yao. ");
INSERT INTO kik_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Nĩ ũndũ ũcio Jehova akĩĩra Nuhu atĩrĩ, “Nĩnduĩte itua kũniina andũ aya othe, nĩgũkorwo thĩ nĩ ĩiyũrĩtwo nĩ maũndũ ma ũhinya nĩ ũndũ wao. Ti-itherũ nĩngũmaniinanĩria hamwe na thĩ. ");
INSERT INTO kik_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nĩ ũndũ ũcio-rĩ, wĩyakĩre thabina ya mĩtĩ ya mĩthithinda; na ũthondeke tũnyũmba thĩinĩ, na ũmĩhake rami thĩinĩ na nja. ");
INSERT INTO kik_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Na ũkũmĩaka ũũ: Ũraihu wa thabina ũkorwo ũrĩ buti magana mana na mĩrongo ĩtano, na wariĩ wa buti mĩrongo mũgwanja na ithano na buti mĩrongo ĩna na ithano, kũraiha na igũrũ. ");
INSERT INTO kik_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ũmĩgite igũrũ, no ũtigie buti ĩmwe na nuthu mwena wa igũrũ wa thingo. Wĩkĩre mũrango mwena-inĩ wa thabina, na ũmĩake ĩrĩ na ngoroba ya thĩ, na ya gatagatĩ, na ya igũrũ. ");
INSERT INTO kik_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nĩngũrehe mũiyũro wa maaĩ gũkũ thĩ wa kũniina kĩndũ gĩothe kĩrĩ muoyo gũkũ thĩ, kĩũmbe o gĩothe kĩrĩ na mĩhũmũ ya muoyo thĩinĩ wakĩo. Indo ciothe irĩ thĩ nĩikũniinwo. ");
INSERT INTO kik_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","No nĩngũthondeka kĩrĩkanĩro nawe. Wee nĩũgatoonya thabina, wee mwene na ariũ aku na mũtumia waku, na atumia a ariũ aku. ");
INSERT INTO kik_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ningĩ nĩũkaingĩria ciũmbe cia mĩthemba yothe thĩinĩ wa thabina, o mũthemba ciũmbe igĩrĩ, wa njamba na wa nga, nĩguo itũũre muoyo, o hamwe nawe. ");
INSERT INTO kik_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","O mũthemba wa nyoni, na o mũthemba wa nyamũ ciothe na ciũmbe ciothe iria ithiiagĩra thĩ, nĩigooka kũrĩ we igĩrĩ igĩrĩ nĩguo itũũre muoyo. ");
INSERT INTO kik_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nĩũkamaatha mĩthemba yothe ya irio iria irĩĩagwo, ũciige irĩ irio ciaku na ciacio.” ");
INSERT INTO kik_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nuhu agĩĩka maũndũ mothe o ta ũrĩa Ngai aamwathĩte eeke. ");
INSERT INTO kik_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ningĩ Jehova akĩĩra Nuhu atĩrĩ, “Toonya thabina thĩinĩ, wee na nyũmba yaku yothe, tondũ nĩnyonete ũrĩ mũthingu rũciaro-inĩ rũrũ. ");
INSERT INTO kik_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Na ũtoonye thĩinĩ na nyamũ mũgwanja mũgwanja cia mĩthemba yothe ĩrĩa ĩtarĩ thaahu, o njamba na nga yayo, na igĩrĩ igĩrĩ cia mĩthemba yothe ĩrĩa ĩrĩ thaahu, o njamba na nga yayo, ");
INSERT INTO kik_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","o na ningĩ ũtoonye na nyoni mũgwanja mũgwanja cia mĩthemba yothe, o njamba na nga yayo, nĩgeetha mĩthemba yacio ĩtũũrio muoyo thĩ yothe. ");
INSERT INTO kik_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Thikũ mũgwanja kuuma rĩu, nĩnguuria mbura, yure gũkũ thĩ matukũ mĩrongo ĩna mũthenya na ũtukũ, na niine ciũmbe ciothe iria irĩ muoyo iria niĩ ndombire, ithire thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nake Nuhu agĩĩka ũrĩa wothe Mwathani aamwathĩte eeke. ");
INSERT INTO kik_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuhu aarĩ na mĩaka magana matandatũ rĩrĩa mũiyũro ũcio wa maaĩ waiyũrire thĩ. ");
INSERT INTO kik_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nake Nuhu na ariũ ake na mũtumia wake na atumia a ariũ ake magĩtoonya thabina morĩre mũiyũro ũcio wa maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Nyamũ igĩrĩ igĩrĩ iria itarĩ thaahu na iria irĩ thaahu cia nyoni o na cia ciũmbe ciothe iria ithiiagĩra thĩ, ");
INSERT INTO kik_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","njamba na nga-rĩ, igĩũka kũrĩ Nuhu igĩtoonya thabina, o ta ũrĩa Ngai aathĩte Nuhu. ");
INSERT INTO kik_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Na thuutha wa matukũ mũgwanja mũiyũro wa maaĩ ũkĩiyũra thĩ. ");
INSERT INTO kik_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Na rĩrĩ, mũthenya wa ikũmi na mũgwanja, mweri wa keerĩ, mwaka ũrĩa Nuhu akinyirie mĩaka magana matandatũ-rĩ, mũthenya ũcio nĩguo ithima cia maaĩ ciothe cia kũrĩa kũriku ciatuthũkire, nacio ihingo cia mũiyũro wa igũrũ ikĩhingũrwo. ");
INSERT INTO kik_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Nayo mbura ĩkiura thĩ matukũ mĩrongo ĩna, mũthenya na ũtukũ. ");
INSERT INTO kik_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Mũthenya o ro ũcio nĩguo Nuhu na ariũ ake, Shemu, na Hamu na Jafethu, hamwe na mũtumia wake na atumia a ariũ ake atatũ maatoonyire thabina. ");
INSERT INTO kik_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nao maarĩ na mĩthemba yothe ya nyamũ cia gĩthaka, o nyamũ kũringana na mũthemba wayo, na mahiũ mothe kũringana na mĩthemba yamo, na ciũmbe ciothe iria ithiiagĩra thĩ kũringana na mĩthemba yacio, na nyoni ciothe kũringana na mĩthemba yacio, na kĩndũ gĩothe kĩrĩ mathagu. ");
INSERT INTO kik_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ciũmbe ciothe iria irĩ mĩhũmũ ya muoyo igĩũka kũrĩ Nuhu igĩtoonya thabina igĩrĩ igĩrĩ. ");
INSERT INTO kik_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Nyamũ iria ciatoonyire thĩinĩ ciarĩ njamba na nga cia mĩthemba yothe ya indo iria irĩ muoyo, o ta ũrĩa Ngai aathĩte Nuhu. Nake Jehova akĩmũhingĩrĩria thĩinĩ. ");
INSERT INTO kik_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Handũ ha matukũ mĩrongo ĩna, mũiyũro ũcio ũgĩthiĩ na mbere kuongerereka thĩ, na o ũrĩa maaĩ macio maingĩhaga makĩoya thabina ĩyo na igũrũ mũno na ĩkĩreera igũrũ rĩa maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Maaĩ macio makĩambatĩra na makĩongerereka mũno gũkũ thĩ, nayo thabina ĩkĩreera maaĩ igũrũ. ");
INSERT INTO kik_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Maaĩ macio makĩambatĩra mũno igũrũ wa thĩ, nacio irĩma ciothe iria ndaaya na igũrũ gũkũ mũhuro wa matu guothe ikĩhumbĩrwo nĩmo. ");
INSERT INTO kik_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Maaĩ macio maambatire makĩhumbĩra irĩma na makĩria ma buti mĩrongo ĩĩrĩ. ");
INSERT INTO kik_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kĩndũ gĩothe kĩarĩ muoyo na gĩathiiaga gũkũ thĩ gĩgĩkua, nyoni, na mahiũ na nyamũ cia gĩthaka, na ciũmbe ciothe iria ciahunjĩte thĩ, o na andũ othe. ");
INSERT INTO kik_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kĩndũ gĩothe kĩarĩ thĩ nyũmũ na kĩarĩ na mĩhũmũ ya muoyo maniũrũ-inĩ makĩo gĩgĩkua. ");
INSERT INTO kik_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kĩndũ gĩothe kĩarĩ muoyo gũkũ thĩ guothe gĩkĩniinwo biũ; andũ na nyamũ na ciũmbe iria ithiiagĩra thĩ na nyoni cia rĩera-inĩ ikĩniinwo ciothe gũkũ thĩ. No Nuhu watigarire hamwe na andũ arĩa maarĩ nake thĩinĩ wa thabina. ");
INSERT INTO kik_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Maaĩ macio magĩikara mahumbĩrĩte thĩ matukũ igana rĩmwe na mĩrongo ĩtano. ");
INSERT INTO kik_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","No rĩrĩ, Ngai nĩaririkanire Nuhu o hamwe na nyamũ ciothe cia gĩthaka o na mahiũ marĩa mothe aarĩ namo thĩinĩ wa thabina, na agĩtũma rũhuho rũhurutane gũkũ thĩ, namo maaĩ makĩambĩrĩria kũhũa. ");
INSERT INTO kik_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nacio ithima cia kũrĩa kũriku na ihingo cia mũiyũro wa igũrũ ikĩhingwo, nayo mbura ĩgĩtiga kuura. ");
INSERT INTO kik_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Namo maaĩ magĩthiĩ makĩhũũaga, magĩthiraga thĩ. Thuutha wa matukũ igana na mĩrongo ĩtano-rĩ, maaĩ magĩkorwo manyihanyiihĩte, ");
INSERT INTO kik_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","naguo mũthenya wa ikũmi na mũgwanja wa mweri wa mũgwanja, thabina ĩkĩrũgama irĩma-inĩ cia Ararati. ");
INSERT INTO kik_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Maaĩ macio magĩthiĩ na mbere na kũhũa o nginya mweri wa ikũmi, na mũthenya wa mbere wa mweri wa ikũmi-rĩ, tũcũmbĩrĩ twa irĩma tũkĩambĩrĩria kuoneka. ");
INSERT INTO kik_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Na thuutha wa matukũ mĩrongo ĩna, Nuhu akĩhingũra ndirica ĩrĩa aakĩte thabina-inĩ, ");
INSERT INTO kik_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na akĩrekereria ihuru na nja, narĩo rĩgĩtũũra rĩũmbũkaga kũndũ na kũndũ o nginya rĩrĩa maaĩ maahũire thĩ. ");
INSERT INTO kik_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ningĩ akĩrekereria ndutura ĩthiĩ ĩkarore kana maaĩ nĩmahũĩte gũkũ thĩ. ");
INSERT INTO kik_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","No ndutura ĩyo ndĩonire handũ ha kũũmba tondũ thĩ yothe yaiyũrĩtwo nĩ maaĩ; nĩ ũndũ ũcio ĩgĩcooka thabina-inĩ kũrĩ Nuhu. Nake agĩtambũrũkia guoko akĩmĩoya, akĩmĩtoonyia thabina thĩinĩ kũu we aarĩ. ");
INSERT INTO kik_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ningĩ agĩeterera matukũ mangĩ mũgwanja, na maathira akĩrekereria ndutura rĩngĩ yume nja ya thabina. ");
INSERT INTO kik_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Rĩrĩa ndutura ĩyo yamũcookereire hwaĩ-inĩ-rĩ, yakuuĩte ithangũ rĩa mũtamaiyũ na mũkanye wayo, rĩatuĩtwo o hĩndĩ ĩyo! Nuhu agĩkĩmenya atĩ maaĩ nĩmahũĩte thĩ. ");
INSERT INTO kik_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nuhu agĩeterera matukũ mangĩ mũgwanja, agĩcooka akĩrekereria ndutura ĩyo yume nja rĩngĩ, no hĩndĩ ĩno ndĩigana kũmũcookerera. ");
INSERT INTO kik_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Na rĩrĩ, mũthenya wa mbere, mweri wa mbere wa mwaka ũrĩa Nuhu akinyirie mĩaka magana matandatũ na ũmwe-rĩ, mũthenya ũcio nĩguo maaĩ maahũire biũ gũkũ thĩ. Nake Nuhu akĩeheria kĩrĩa kĩagitĩte thabina, agĩkĩona atĩ thĩ nĩyaniarĩte. ");
INSERT INTO kik_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Gũgĩkinya mũthenya wa mĩrongo ĩĩrĩ na mũgwanja wa mweri wa keerĩ-rĩ, thĩ nĩyaniarĩte biũ. ");
INSERT INTO kik_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ningĩ Ngai akĩĩra Nuhu atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Uma thabina, wee na mũtumia waku, na ariũ aku na atumia ao. ");
INSERT INTO kik_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hingũrĩra mĩthemba yothe ya ciũmbe iria irĩ muoyo icio ũrĩ nacio: irĩ nyoni, na nyamũ, na ciũmbe iria ithiiagĩra thĩ, nĩgeetha ciongerereke thĩ, na iciarane cingĩhe gũkũ thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nĩ ũndũ ũcio Nuhu akiuma thabina hamwe na ariũ ake, na mũtumia wake, na atumia a ariũ ake. ");
INSERT INTO kik_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nyamũ ciothe na ciũmbe ciothe iria ithiiagĩra thĩ, na nyoni ciothe, na kĩndũ o gĩothe gĩthiiagĩra gũkũ thĩ, ciothe cikiuma thabina, mũthemba o mũthemba. ");
INSERT INTO kik_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nake Nuhu agĩakĩra Jehova kĩgongona, na akĩoya nyamũ imwe cia iria ciothe itarĩ thaahu, na nyoni iria itarĩ thaahu, akĩrutĩra Ngai igongona rĩa njino ho. ");
INSERT INTO kik_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Nake Jehova agĩkenio nĩ mũtararĩko ũcio, akiuga atĩrĩ na ngoro yake: “Ndirĩ hĩndĩ ngaacooka kũruma thĩ rĩngĩ nĩ ũndũ wa mũndũ, o na gũtuĩka merirĩria ma ngoro yake nĩ mooru kuuma ũnini-inĩ wake. Na ndirĩ hĩndĩ ngaacooka kũniina ciũmbe ciothe iria irĩ muoyo ta ũguo njĩkĩte. ");
INSERT INTO kik_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Mahinda mothe marĩa thĩ ĩgũtũũra-rĩ, kũrĩkoragwo na hĩndĩ ya kũhaanda na ya magetha, na hĩndĩ ya heho na ya ũrugarĩ, na hĩndĩ ya themithũ na ya gathano, na mũthenya na ũtukũ.” ");
INSERT INTO kik_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hĩndĩ ĩyo Ngai akĩrathima Nuhu na ariũ ake, akĩmeera atĩrĩ, “Ciaranai na mũingĩhe na mũiyũre thĩ. ");
INSERT INTO kik_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nyamũ ciothe cia thĩ, na nyoni cia rĩera-inĩ, ciothe nĩ irĩmwĩtigagĩra na imakage nĩ inyuĩ, ciũmbe ciothe iria ithiiagĩra thĩ, na thamaki ciothe cia iria-inĩ; nĩndacineana moko-inĩ manyu. ");
INSERT INTO kik_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kĩndũ gĩothe gĩtũũraga muoyo na gĩthiiaga-rĩ, gĩgũtuĩka irio cianyu. O ta ũrĩa ndamũheire mĩmera ĩrĩa mĩruru mũrĩĩage, rĩu nĩ ndamũhe indo ciothe ituĩke irio cianyu. ");
INSERT INTO kik_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“No rĩrĩ, mũtikanarĩe nyama irĩ na thakame, tondũ thakame nĩyo muoyo. ");
INSERT INTO kik_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Na ti-itherũ nĩngarĩhanĩria gũitwo gwa thakame yanyu. Ndĩmĩrĩhanĩrie o na kuuma kũrĩ nyamũ o na ĩrĩkũ. Nake mũndũ angĩita thakame ya mũndũ ũngĩ, o nake nĩakarĩhio thakame ĩyo. ");
INSERT INTO kik_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Mũndũ o wothe ũgaita thakame ya mũndũ ũngĩ, thakame yake o nayo ĩgaitwo nĩ mũndũ; nĩgũkorwo Ngai ombire mũndũ na mũhianĩre wake. ");
INSERT INTO kik_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","No inyuĩ-rĩ, ciaranai na mũingĩhe; muongerereke thĩ na mũiyũre kuo.” ");
INSERT INTO kik_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ningĩ Ngai akĩĩra Nuhu hamwe na ariũ ake atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Rĩu niĩ nĩngũthondeka kĩrĩkanĩro gĩakwa na inyuĩ, na njiaro cianyu iria igooka thuutha wanyu, ");
INSERT INTO kik_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","o na hamwe na kĩũmbe gĩothe kĩrĩ muoyo kĩa iria mũraarĩ nacio; nĩcio nyoni, na mahiũ o na nyamũ cia gĩthaka ciothe iria cioimire thabina hamwe na inyuĩ, ici nĩcio ciũmbe ciothe irĩ muoyo gũkũ thĩ. ");
INSERT INTO kik_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nĩndathondeka kĩrĩkanĩro gĩakwa na inyuĩ: Gũtirĩ hĩndĩ ĩngĩ muoyo wothe ũkaaniinwo na mũiyũro wa maaĩ; gũtirĩ hĩndĩ ĩngĩ gũkaagĩa mũiyũro wa maaĩ wa kũniina thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ningĩ Ngai akiuga atĩrĩ, “Gĩkĩ nĩkĩo kĩmenyithia gĩa kĩrĩkanĩro kĩrĩa ndĩrarĩkanĩra na inyuĩ na ciũmbe ciothe irĩ muoyo irĩ hamwe na inyuĩ, kĩrĩkanĩro kĩa njiarwa ciothe iria igooka: ");
INSERT INTO kik_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nĩndekĩra mũkũnga-mbura wakwa matu-inĩ, na nĩguo ũgũtuĩka kĩmenyithia gĩa kĩrĩkanĩro gatagatĩ gakwa na andũ a thĩ. ");
INSERT INTO kik_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Hĩndĩ ĩrĩa yothe ngaarehe matu igũrũ rĩa thĩ, naguo mũkũnga-mbura woneke matu-inĩ macio, ");
INSERT INTO kik_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nĩndĩĩririkanaga kĩrĩkanĩro gĩakwa gatagatĩ kanyu na niĩ, na gatagatĩ ga ciũmbe cia mĩthemba yothe iria itũũraga muoyo. Gũtirĩ hĩndĩ ĩngĩ maaĩ magatuĩka mũiyũro wa kũniina mĩoyo yothe. ");
INSERT INTO kik_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Rĩrĩa rĩothe mũkũnga-mbura ũrĩonekaga itu-inĩ-rĩ, ndĩĩwonaga ngaririkana kĩrĩkanĩro kĩrĩa gĩa gũtũũra nginya tene gatagatĩ ka Ngai na ciũmbe cia mĩthemba yothe iria itũũraga muoyo gũkũ thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nĩ ũndũ ũcio Ngai akĩĩra Nuhu atĩrĩ, “Gĩkĩ nĩkĩo kĩmenyithia gĩa kĩrĩkanĩro kĩrĩa ndathondeka gatagatĩ gakwa na kĩndũ gĩothe kĩrĩ muoyo gũkũ thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ariũ a Nuhu arĩa moimire thabina maarĩ Shemu, na Hamu na Jafethu. (Hamu nĩwe warĩ ithe wa Kaanani). ");
INSERT INTO kik_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Acio atatũ nĩo maarĩ ariũ a Nuhu, na kuuma kũrĩ o gũkiuma andũ arĩa othe maahurunjirwo thĩ yothe. ");
INSERT INTO kik_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu aarĩ mũrĩmi, na nĩahaandire mũgũnda wa mĩthabibũ. ");
INSERT INTO kik_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Rĩrĩa aanyuire ndibei ya mĩthabibũ ĩyo, akĩrĩĩo, na agĩkoma thĩinĩ wa hema yake atehumbĩrĩte. ");
INSERT INTO kik_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Hamu, ithe wa Kaanani, nĩonire njaga ya ithe, na akĩĩra ariũ a nyina eerĩ arĩa maarĩ nja. ");
INSERT INTO kik_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","No Shemu na Jafethu makĩoya nguo makĩigĩrĩra ciande; magĩthiĩ na kĩĩhutaatĩ, makĩhumbĩra njaga ya ithe. Mothiũ mao maahũgũkĩte na kũngĩ nĩguo matikoone njaga ya ithe wao. ");
INSERT INTO kik_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Rĩrĩa Nuhu aarĩĩũkirwo na akĩmenya ũrĩa mũriũ wake ũrĩa mũnini aamwĩkĩte-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","akiuga atĩrĩ, “Kaanani aronyiitwo nĩ kĩrumi! Agaatuĩka ngombo ya kũhinyĩrĩrio biũ nĩ ariũ a nyina.” ");
INSERT INTO kik_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ningĩ akiuga atĩrĩ, “Jehova arogaathwo, o we Ngai wa Shemu! Kaanani arotuĩka ngombo ya Shemu. ");
INSERT INTO kik_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ngai aroaramia mĩhaka ya Jafethu; Jafethu arotũũra hema-inĩ cia Shemu, na Kaanani arotuĩka ngombo yake.” ");
INSERT INTO kik_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Thuutha wa mũiyũro wa maaĩ gũthira-rĩ, Nuhu aatũũrire muoyo mĩaka magana matatũ na mĩrongo ĩtano. ");
INSERT INTO kik_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Mĩaka yothe ĩrĩa Nuhu aatũũrire muoyo yarĩ mĩaka magana kenda na mĩrongo ĩtano, agĩcooka agĩkua. ");
INSERT INTO kik_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ũyũ nĩguo ũhoro wa njiarwa cia Nuhu, nĩo Shemu, na Hamu, na Jafethu, arĩa o ene maagĩire na ariũ thuutha wa mũiyũro wa maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ariũ a Jafethu nĩ aya: Gomeri, na Magogu, na Madai, na Javani, na Tubali, na Mesheki, na Tirasi. ");
INSERT INTO kik_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ariũ a Gomeri nĩ aya: Ashikenazu, na Rifathu, na Togarima. ");
INSERT INTO kik_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ariũ a Javani nĩ aya: Elishahu, na Tarishishi, na Kitimu, na Rodanimu. ");
INSERT INTO kik_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Kuuma kũrĩ o gũkiuma andũ arĩa matũũraga ndwere-inĩ cia iria, o andũ na rũgongo rwao kũringana na mĩhĩrĩga yao, mabũrũri-inĩ mao, na o andũ na rũthiomi rwao.) ");
INSERT INTO kik_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Nao ariũ a Hamu nĩ aya: Kushi, na Miziraimu, na Putu, na Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ariũ a Kushi nĩ aya: Seba, na Havila, na Sabita, na Raama, na Sabiteka. Nao ariũ a Raama nĩ: Sheba, na Dedani. ");
INSERT INTO kik_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kushi nĩwe warĩ ithe wa Nimurodi, ũrĩa wakũrire agĩtuĩka njamba ya hinya ya ita gũkũ thĩ. ");
INSERT INTO kik_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Aarĩ mũguĩmi warĩ hinya mbere ya Jehova; na nĩkĩo kwĩragwo atĩrĩ, “O ta Nimurodi, mũguĩmi ũrĩ hinya mbere ya Jehova.” ");
INSERT INTO kik_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Matũũra ma mbere ma ũthamaki wake maarĩ Babeli, na Ereku, na Akadi na Kaline, kũu Shinaru. ");
INSERT INTO kik_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kuuma bũrũri ũcio wa Shinaru agĩthiĩ bũrũri wa Ashuri, nakuo kũu agĩaka matũũra ma Nineve, na Rehobothu-Iru, na Kala, ");
INSERT INTO kik_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","na Reseni, itũũra rĩrĩ gatagatĩ ka Nineve na Kala; rĩu nĩrĩo rĩarĩ itũũra inene. ");
INSERT INTO kik_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Nake Miziraimu nĩwe warĩ ithe wa Aludi, na Aanami, na Alehabi, na Anafituhi, ");
INSERT INTO kik_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","na Apathirusi, na Akasuluhi (Afilisti moimire kuuma harĩ o), na Akafitori. ");
INSERT INTO kik_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kaanani nĩwe warĩ ithe wa Sidoni irigithathi rĩake, na Ahiti, ");
INSERT INTO kik_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","na Ajebusi, na Aamori, na Agirigashi, ");
INSERT INTO kik_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","na Ahivi, na Ariki, na Asiniti, ");
INSERT INTO kik_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","na Aarivadi, na Azemari, na Ahamathi. Thuutha ũcio mĩhĩrĩga ya Kaanani ĩkĩhurunjũka, ");
INSERT INTO kik_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","mĩhaka ya Akaanani yoimĩte Sidoni ĩrorete Gerari ĩgakinya Gaza, ningĩ ĩkarora Sodomu, na Gomora, na Adima, na Zeboimu, o nginya Lasha. ");
INSERT INTO kik_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Acio nĩo ariũ a Hamu kũringana na mĩhĩrĩga yao, na thiomi ciao, marĩ ngʼongo ciao, na mabũrũri-inĩ mao. ");
INSERT INTO kik_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shemu o nake nĩaciarĩirwo ariũ ake. Mũrũ wa nyina na Shemu ũrĩa warĩ mũkũrũ eetagwo Jafethu. Shemu nĩwe warĩ ithe wa rũruka ruothe rwa ariũ a Eberi. ");
INSERT INTO kik_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ariũ a Shemu nĩ aya: Elamu, na Ashuri, na Arafakasadi, na Ludi, na Aramu. ");
INSERT INTO kik_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Nao ariũ a Aramu nĩ aya: Uzu, na Hulu, na Getheru, na Mesheki. ");
INSERT INTO kik_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arafakasadi nĩwe warĩ ithe wa Shela, nake Shela aarĩ ithe wa Eberi. ");
INSERT INTO kik_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberi nake nĩaciarĩirwo ariũ eerĩ: Ũmwe eetagwo Pelegu, tondũ hĩndĩ yake thĩ nĩyagayũkanire; mũrũ wa nyina eetagwo Jokitani. ");
INSERT INTO kik_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokitani nĩwe warĩ ithe wa Alimodadi, na Shelefu, na Hazarimavethu, na Jera, ");
INSERT INTO kik_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","na Hadoramu, na Uzali, na Dikila, ");
INSERT INTO kik_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","na Obali, na Abimaeli, na Sheba, ");
INSERT INTO kik_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","na Ofiri, na Havila, na Jobabu. Acio othe nĩo maarĩ ariũ a Jokitani. ");
INSERT INTO kik_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Rũgongo rũrĩa maatũũraga ruoimĩte Mesha rũgathiĩ rũrorete Sefari, kũu mwena wa irathĩro wa bũrũri ũrĩa ũrĩ irĩma. ");
INSERT INTO kik_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Acio nĩo ariũ a Shemu kũringana na mĩhĩrĩga yao, na thiomi ciao, marĩ ngʼongo ciao na mabũrũri-inĩ mao. ");
INSERT INTO kik_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ĩyo nĩyo mĩhĩrĩga ya ariũ a Nuhu kũringana na njiaro ciao, marĩ mabũrũri-inĩ mao. Kuuma kũrĩ o, ndũrĩrĩ ikĩhurunjũka thĩ yothe thuutha wa mũiyũro wa maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hĩndĩ ĩyo ya tene-rĩ, andũ othe a thĩ maarĩ na rũthiomi rũmwe na mwario o ũmwe. ");
INSERT INTO kik_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Na rĩrĩa andũ maathiiaga na mwena wa irathĩro, magĩkinya werũ-inĩ ũrĩa mwaraganu wa Shinaru, na magĩtũũra kuo. ");
INSERT INTO kik_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Nao makĩĩrana atĩrĩ, “Ũkai tũũmbe maturubarĩ na tũmacine wega.” Magĩtũmĩra maturubarĩ handũ ha mahiga, na rami handũ ha thimiti. ");
INSERT INTO kik_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ningĩ magĩcooka makiuga atĩrĩ, “Ũkai, rekei twĩyakĩre itũũra inene, rĩna mũthiringo mũraaya na igũrũ, ũkinye o matu-inĩ, nĩgeetha twĩgĩĩre igweta, na nĩguo tũtikaanahurunjwo thĩ yothe.” ");
INSERT INTO kik_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","No rĩrĩ, Jehova agĩikũrũka oke one itũũra rĩu na mũthiringo ũcio andũ acio maakaga. ");
INSERT INTO kik_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Jehova akiuga atĩrĩ na ngoro yake, “Angĩkorwo na ũndũ wa ũrũmwe wa kwaria rũthiomi rũmwe andũ aya nĩmambĩrĩria gwĩka ũũ-rĩ, gũtirĩ ũndũ makaabanga gwĩka ũkaamarema. ");
INSERT INTO kik_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ũkai, tũikũrũke tũkahĩngĩcanie rũthiomi rwao, nĩgeetha matigacooke kũiguithania mĩario mũndũ na ũrĩa ũngĩ.” ");
INSERT INTO kik_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Nĩ ũndũ ũcio, kuuma hau Jehova akĩmahurunja thĩ yothe, nao magĩtiga gwaka itũũra rĩu inene. ");
INSERT INTO kik_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Na nĩkĩo itũũra rĩu rĩetirwo Babeli, tondũ nĩkuo Jehova aahĩngĩcanĩirie rũthiomi rwa andũ a thĩ yothe. Kuuma kũu, Jehova akĩmahurunja thĩ yothe. ");
INSERT INTO kik_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ũyũ nĩguo ũhoro wa Shemu. Mĩaka ĩĩrĩ thuutha wa mũiyũro wa maaĩ-rĩ, rĩrĩa Shemu aarĩ na ũkũrũ wa mĩaka igana rĩmwe-rĩ, nĩguo aatuĩkire ithe wa Arafakasadi. ");
INSERT INTO kik_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Shemu aatũũrire muoyo mĩaka magana matano thuutha wa gũtuĩka ithe wa Arafakasadi, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Nake Arafakasadi aakinyia mĩaka mĩrongo ĩtatũ na ĩtano, agĩtuĩka ithe wa Shela. ");
INSERT INTO kik_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Na thuutha wa gũtuĩka ithe wa Shela, Arafakasadi agĩtũũra muoyo mĩaka ĩngĩ magana mana na ĩtatũ, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Nake Shela aakinyia mĩaka mĩrongo ĩtatũ, agĩtuĩka ithe wa Eberi. ");
INSERT INTO kik_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Na thuutha wa gũtuĩka ithe wa Eberi, Shela agĩtũũra muoyo mĩaka ĩngĩ magana mana na ĩtatũ, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Nake Eberi aakinyia mĩaka mĩrongo ĩtatũ na ĩna, agĩtuĩka ithe wa Pelegu. ");
INSERT INTO kik_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Na thuutha wa gũtuĩka ithe wa Pelegu, Eberi agĩtũũra muoyo mĩaka ĩngĩ magana mana na mĩrongo ĩtatũ, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Nake Pelegu aakinyia mĩaka mĩrongo ĩtatũ, agĩtuĩka ithe wa Reu. ");
INSERT INTO kik_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Na thuutha wa gũtuĩka ithe wa Reu, Pelegu agĩtũũra muoyo mĩaka ĩngĩ magana meerĩ na kenda na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Nake Reu aakinyia mĩaka mĩrongo ĩtatũ na ĩĩrĩ, agĩtuĩka ithe wa Serugu. ");
INSERT INTO kik_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Na thuutha wa gũtuĩka ithe wa Serugu, Reu agĩtũũra muoyo mĩaka ĩngĩ magana meerĩ na mũgwanja na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Nake Serugu aakinyia mĩaka mĩrongo ĩtatũ, agĩtuĩka ithe wa Nahoru. ");
INSERT INTO kik_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Na thuutha wa gũtuĩka ithe wa Nahoru, Serugu agĩtũũra muoyo mĩaka ĩngĩ magana meerĩ na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nake Nahoru aakinyia mĩaka mĩrongo ĩĩrĩ na kenda, agĩtuĩka ithe wa Tera. ");
INSERT INTO kik_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Na thuutha wa gũtuĩka ithe wa Tera, Nahoru agĩtũũra muoyo mĩaka ĩngĩ igana na ikũmi na kenda, na akĩgĩa na ciana ingĩ cia aanake na cia airĩtu. ");
INSERT INTO kik_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Thuutha wa Tera gũkinyia mĩaka mĩrongo mũgwanja, agĩtuĩka ithe wa Aburamu, na Nahoru na Harani. ");
INSERT INTO kik_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ũyũ nĩguo ũhoro wa Tera. Tera nĩwe warĩ ithe wa Aburamu, na Nahoru na Harani. Nake Harani agĩtuĩka ithe wa Loti. ");
INSERT INTO kik_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ithe wao Tera arĩ o muoyo-rĩ, Harani nĩakuire arĩ bũrũri-inĩ wa Uri-kwa-Akalidei, kũrĩa aaciarĩirwo. ");
INSERT INTO kik_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aburamu na Nahoru o eerĩ nĩmahikanirie. Mũtumia wa Aburamu eetagwo Sarai, nake mũtumia wa Nahoru eetagwo Milika; Milika aarĩ mwarĩ wa Harani. Harani nĩwe warĩ ithe wa Milika na Isika. ");
INSERT INTO kik_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Na rĩrĩ, Sarai aarĩ thaata; ndaarĩ na ciana. ");
INSERT INTO kik_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Nake Tera akĩoya mũriũ wake Aburamu, na Loti mũrũ wa mũrũwe Harani, na Sarai mũtumia wa mũriũ wake Aburamu; nao makiumagara hamwe moime bũrũri wa Uri-kwa-Akalidei mathiĩ Kaanani. No rĩrĩa maakinyire bũrũri wetagwo Harani, magĩtũũra kuo. ");
INSERT INTO kik_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera agĩtũũra muoyo mĩaka ĩngĩ magana meerĩ na ĩtano, na agĩkuĩra kũu Harani. ");
INSERT INTO kik_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nake Jehova nĩeerĩte Aburamu atĩrĩ, “Thaama uume bũrũri wanyu na ũtige andũ anyu, na nyũmba ya thoguo, ũthiĩ bũrũri ũrĩa ngaakuonia. ");
INSERT INTO kik_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Niĩ nĩngagũtua rũrĩrĩ rũnene, na nĩngakũrathima; nĩngatũma rĩĩtwa rĩaku rĩgĩe igweta, nawe nĩũgatuĩka kĩrathimo. ");
INSERT INTO kik_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nĩngarathima arĩa magaakũrathima, na ũrĩa o wothe ũgaakũruma na niĩ nĩngatũma anyiitwo nĩ kĩrumi; nao andũ othe a thĩ nĩmakarathimwo nĩ ũndũ waku.” ");
INSERT INTO kik_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Nĩ ũndũ ũcio Aburamu akiumagara agĩthiĩ, o ta ũrĩa Jehova aamwathĩte; nake Loti agĩthiĩ nake. Aburamu aarĩ na mĩaka mĩrongo mũgwanja na ĩtano rĩrĩa oimire Harani. ");
INSERT INTO kik_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nake nĩathiire na mũtumia wake Sarai, na Loti, mũriũ wa mũrũ wa nyina, na indo ciothe iria maagĩte nacio, na andũ arĩa maagĩte nao kũu Harani, na makiumagara marorete bũrũri wa Kaanani, na magĩkinya kuo. ");
INSERT INTO kik_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Aburamu agĩtuĩkanĩria bũrũri ũcio agĩkinya handũ haarĩ na mũtĩ mũnene wa More kũu Shekemu. Hĩndĩ ĩyo Akaanani nĩo maatũũraga bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nake Jehova akiumĩrĩra Aburamu, akĩmwĩra atĩrĩ, “Bũrũri ũyũ nĩguo ngaahe rũciaro rwaku.” Nĩ ũndũ ũcio Aburamu agĩakĩra Jehova kĩgongona hau, o we Jehova ũcio wamuumĩrĩire. ");
INSERT INTO kik_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Kuuma hau agĩthiĩ erekeire irĩma iria irĩ mwena wa irathĩro wa itũũra rĩa Betheli, na akĩamba hema yake, Betheli ĩgĩkorwo ĩrĩ mwena wa ithũĩro na itũũra rĩa Ai rĩrĩ mwena wa irathĩro. Hau nĩho aakĩire Jehova kĩgongona na agĩkaĩra rĩĩtwa rĩa Jehova. ");
INSERT INTO kik_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Thuutha-inĩ Aburamu akiumagara rĩngĩ agĩthiĩ na mbere na rũgendo arorete Negevu. ");
INSERT INTO kik_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Na rĩrĩ, nĩ kwagĩire ngʼaragu bũrũri ũcio, nake Aburamu agĩikũrũka athiĩ Misiri agaikare kuo kwa ihinda, tondũ ngʼaragu nĩ yarĩ nene mũno. ");
INSERT INTO kik_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Arĩ o hakuhĩ gũtoonya Misiri-rĩ, akĩĩra mũtumia wake Sarai atĩrĩ, “Nĩnjũũĩ atĩ ũrĩ mũndũ-wa-nja kĩĩrorerwa. ");
INSERT INTO kik_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Na rĩrĩ, andũ a Misiri makuona mekuuga atĩrĩ, ‘Ũyũ nĩ mũtumia wake,’ tondũ ũcio manjũrage no wee makũreke ũtũũre muoyo, makuoe. ");
INSERT INTO kik_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nĩ ũndũ ũcio wee uga atĩ ũrĩ mwarĩ wa baba, nĩgeetha ũhonokie muoyo wakwa na manjĩke wega nĩ ũndũ waku.” ");
INSERT INTO kik_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Rĩrĩa Aburamu aakinyire Misiri, andũ a Misiri makĩona atĩ mũtumia wake aarĩ kĩĩrorerwa biũ. ");
INSERT INTO kik_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Nao anene a Firaũni mamuona, makĩmũgaathĩrĩria kũrĩ Firaũni, na makĩmuoya makĩmũtwara nyũmba-inĩ yake ya ũthamaki. ");
INSERT INTO kik_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nake Firaũni agĩtuga Aburamu nĩ ũndũ wa Sarai, na Aburamu akĩgĩa na mbũri na ngʼombe, na ndigiri cia njamba na cia nga, ndungata cia arũme na cia airĩtu, na ngamĩĩra. ");
INSERT INTO kik_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","No Jehova akĩnyamaria Firaũni na nyũmba yake na mĩrimũ mĩũru nĩ ũndũ wa Sarai, mũtumia wa Aburamu. ");
INSERT INTO kik_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Nĩ ũndũ ũcio Firaũni agĩtũmanĩra Aburamu akĩmũũria atĩrĩ, “Nĩ atĩa ũũ ũnjĩkĩte? Nĩ kĩĩ kĩagiririe ũnjĩĩre atĩ ũyũ nĩ mũtumia waku? ");
INSERT INTO kik_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nĩ kĩĩ gĩatũmire uuge, ‘Ũyũ nĩ mwarĩ wa baba,’ na nĩkĩo ndaamuoire atuĩke mũtumia wakwa? Mũtumia waku nĩwe ũyũ! Muoye mũthiĩ!” ");
INSERT INTO kik_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hĩndĩ ĩyo Firaũni agĩathana akĩĩra andũ ake ũrĩa megwĩka Aburamu, nao makĩmumagaria arĩ na mũtumia wake na indo ciothe iria aarĩ nacio. ");
INSERT INTO kik_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Nĩ ũndũ ũcio Aburamu akĩambata akiuma Misiri agĩthiĩ Negevu, arĩ na mũtumia wake na indo ciothe iria aarĩ nacio, na Loti agĩthiĩ hamwe nake. ");
INSERT INTO kik_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aburamu nĩatongete mũno na ũtonga wa mahiũ, na wa betha, na wa thahabu. ");
INSERT INTO kik_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kuuma kũu Negevu nĩathiire kũndũ na kũndũ o nginya agĩkinya Betheli, o harĩa aambĩte hema yake rĩa mbere gatagatĩ ka Betheli na Ai, ");
INSERT INTO kik_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","na hau nĩho aakĩte kĩgongona ihinda rĩa mbere. Na Aburamu agĩkaĩra rĩĩtwa rĩa Jehova ho. ");
INSERT INTO kik_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Na rĩrĩ, Loti, ũrĩa matwaranaga na Aburamu, o nake aarĩ na ndũũru cia mbũri, na cia ngʼombe, na ndungata nyingĩ. ");
INSERT INTO kik_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Nĩ ũndũ ũcio bũrũri ũcio ndũngĩahotire kũmaigania ũrĩithio marĩ hamwe, nĩ tondũ indo ciao ciarĩ nyingĩ mũno, ũndũ matangĩahotire gũikarania hamwe. ");
INSERT INTO kik_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Na nĩ kwagĩire ngũĩ gatagatĩ ka arĩithi a Aburamu na arĩithi a Loti. Akaanani na Aperizi o nao maatũũraga o bũrũri-inĩ ũcio hĩndĩ ĩyo. ");
INSERT INTO kik_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Nĩ ũndũ ũcio Aburamu akĩĩra Loti atĩrĩ, “Nĩtũtige kũgĩa na ngũĩ gatagatĩ gaitũ nawe, kana gatagatĩ ka arĩithi aku na arĩithi akwa, nĩ tondũ tũrĩ andũ a nyũmba ĩmwe. ");
INSERT INTO kik_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Githĩ bũrũri ũyũ wothe ndũrĩ mbere yaku? Reke tũtigane. Wathiĩ mwena wa ũmotho, na niĩ ngũthiĩ mwena wa ũrĩo; wathiĩ mwena wa ũrĩo, na niĩ ngũthiĩ mwena wa ũmotho.” ");
INSERT INTO kik_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loti nĩatiirire maitho, akĩbaara, akĩona atĩ kĩaragana gĩothe kĩa Jorodani kĩarĩ na maaĩ maingĩ, gĩgakĩhaana o ta mũgũnda ũrĩa wa Jehova, na o ta bũrũri wa Misiri, ũrĩa ũngʼetheire Zoari. (Hĩndĩ ĩyo nĩ mbere ya Jehova kũnũha Sodomu na Gomora.) ");
INSERT INTO kik_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nĩ ũndũ ũcio Loti agĩĩthuurĩra kĩaragana kĩa Jorodani gĩothe na akiumagara erekeire irathĩro. Andũ acio eerĩ magĩtigana: ");
INSERT INTO kik_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aburamu agĩtũũra bũrũri wa Kaanani, nake Loti agĩtũũra matũũra-inĩ ma kĩaragana kĩu, akĩamba hema ciake hakuhĩ na Sodomu. ");
INSERT INTO kik_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Na rĩrĩ, andũ a Sodomu maarĩ aaganu, na makehagĩria Jehova mũno. ");
INSERT INTO kik_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Aburamu na Loti maatigana-rĩ, Jehova akĩĩra Aburamu atĩrĩ, “Ta tiira maitho maku na igũrũ ũrĩ o hau ũrĩ, ũrore mwena wa gathigathini na gũthini, irathĩro na ithũĩro. ");
INSERT INTO kik_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Bũrũri ũrĩa wothe ũkuona nĩngũkũhe ũtuĩke waku, na wa rũciaro rwaku nginya tene. ");
INSERT INTO kik_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nĩngaatũma rũciaro rwaku rũingĩhe o ta rũkũngũ rwa thĩ, na kũngĩkorwo kũrĩ mũndũ ũngĩhota gũtara rũkũngũ rwa thĩ-rĩ, o na rũciaro rwaku no rũgĩtarĩke. ");
INSERT INTO kik_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ũkĩra ũthiĩ, ũtuĩkanie bũrũri ũyũ ũraihu waguo na wariĩ waguo, tondũ nĩngũkũhe guo.” ");
INSERT INTO kik_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Nĩ ũndũ ũcio Aburamu akĩambũra hema ciake, agĩthiĩ gũtũũra hakuhĩ na mĩtĩ ĩrĩa mĩnene ya mĩgandi ya Mamure kũu Hebironi, na agĩakĩra Jehova kĩgongona hau. ");
INSERT INTO kik_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ihinda-inĩ rĩu, Amurafeli mũthamaki wa Shinaru, na Arioku mũthamaki wa Elasaru, na Kedorilaomeri mũthamaki wa Elamu, na Tidali mũthamaki wa Goimu, ");
INSERT INTO kik_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","nĩmathiire ita kũrũa na Bera mũthamaki wa Sodomu, na Birisha mũthamaki wa Gomora, na Shinabu mũthamaki wa Adima, na Shemeberi mũthamaki wa Zeboimu na mũthamaki wa Bela (na nokuo Zoari). ");
INSERT INTO kik_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Athamaki acio othe a gĩkundi gĩa keerĩ nĩmacookanĩrĩire hamwe Gĩtuamba-inĩ gĩa Sidimu (na nokuo Iria rĩa Cumbĩ). ");
INSERT INTO kik_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ihinda rĩa mĩaka ikũmi na ĩĩrĩ maatũire matungatagĩra Mũthamaki Kedorilaomeri, no mwaka-inĩ wa ikũmi na ĩtatũ makĩregana na watho wake. ");
INSERT INTO kik_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mwaka-inĩ wa ikũmi na ĩna-rĩ, Mũthamaki Kedorilaomeri na athamaki arĩa maarĩ hamwe nake magĩthiĩ makĩhoota Arefai kũu Ashiterothu-Karinaimu, na Azuzi kũu Hamu, na Aemi kũu Shave-Kiriathaimu, ");
INSERT INTO kik_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","nao Ahori makĩmahootera bũrũri-inĩ wa irĩma wa Seiru, o nginya Eli-Parani gũkuhĩ na werũ. ");
INSERT INTO kik_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ningĩ athamaki acio makĩgarũrũka, magĩthiĩ Eni-Mishipatu (na nokuo Kadeshi), magĩtooria rũgongo ruothe rwa Amaleki, o hamwe na Aamori arĩa maatũũraga kũu Hazazoni-Tamaru. ");
INSERT INTO kik_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ningĩ mũthamaki wa Sodomu, na mũthamaki wa Gomora, na mũthamaki wa Adima, na mũthamaki wa Zeboimu, na mũthamaki wa Bela (na nokuo Zoari) magĩthiĩ makĩhaarĩria ita rĩao rĩa mbaara o kũu Gĩtuamba-inĩ gĩa Sidimu, ");
INSERT INTO kik_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","mahũũrane na Kedorilaomeri mũthamaki wa Elamu, na Tidali mũthamaki wa Goimu, na Amurafeli mũthamaki wa Shinaru, na Arioku mũthamaki wa Elasaru, athamaki acio ana mahũũrane na athamaki acio angĩ atano. ");
INSERT INTO kik_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Na rĩrĩ, Gĩtuamba kĩu gĩa Sidimu kĩaiyũrĩte marima ma rami, na rĩrĩa athamaki a Sodomu na Gomora mooraga-rĩ, andũ amwe ao makĩgũa kuo nao arĩa angĩ makĩũrĩra irĩma-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Athamaki acio ana magĩtunyana indo ciothe cia Sodomu na Gomora o na irio ciakuo ciothe; magĩcooka magĩĩthiĩra. ");
INSERT INTO kik_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ningĩ magĩtaha Loti, mũriũ wa mũrũ wa nyina na Aburamu, na indo ciake, tondũ aatũũraga kũu Sodomu. ");
INSERT INTO kik_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Na rĩrĩ, mũndũ ũmwe wahonokete gũtahwo-rĩ, agĩũka na akĩĩra Aburamu ũrĩa Mũhibirania ũhoro ũcio. Na rĩrĩ, Aburamu aatũũraga hakuhĩ na mĩtĩ ĩrĩa mĩnene ya mĩgandi ya Mamure ũrĩa Mũamori, mũrũ wa nyina na Eshikoli na Aneri, na othe maarĩ rũmwe na Aburamu. ");
INSERT INTO kik_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Rĩrĩa Aburamu aiguire atĩ mũndũ ũcio wao nĩanyiitĩtwo agatahwo-rĩ, agĩĩta andũ magana matatũ na ikũmi na anana arĩa maarutĩtwo kũrũa mbaara na maaciarĩirwo gwake mũciĩ, makĩingatithia thũ icio o nginya Dani. ");
INSERT INTO kik_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ũtukũ-rĩ, Aburamu akĩgayania andũ ake mamatharĩkĩre, nake akĩmahoota na akĩmaingatithia nginya Hoba, itũũra rĩrĩ gathigathini wa Dameski. ");
INSERT INTO kik_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Aburamu agĩcookithia indo ciothe iria ciatahĩtwo, na Loti mũndũ ũcio wao, na indo ciake ciothe, hamwe na andũ-a-nja na andũ arĩa angĩ. ");
INSERT INTO kik_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Aburamu acooka kuuma kũhoota Kedorilaomeri na athamaki arĩa maarĩ rũmwe nake-rĩ, mũthamaki wa Sodomu agĩthiĩ kũmũtũnga Gĩtuamba-inĩ gĩa Shave (na no kĩo gĩĩtagwo Gĩtuamba-kĩa-Mũthamaki). ");
INSERT INTO kik_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Nake Melikisedeki mũthamaki wa Salemu akĩrehe mĩgate na ndibei. We aarĩ mũthĩnjĩri wa Mũrungu Ũrĩa-ũrĩ-Igũrũ-Mũno. ");
INSERT INTO kik_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Na akĩrathima Aburamu, akiuga atĩrĩ, “Aburamu arorathimwo nĩ Mũrungu Ũrĩa-ũrĩ-Igũrũ-Mũno, o we Mũmbi wa igũrũ na thĩ. ");
INSERT INTO kik_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ningĩ Mũrungu Ũrĩa-ũrĩ-Igũrũ-Mũno arogaathwo, o ũcio ũraneanire thũ ciaku moko-inĩ maku.” Nake Aburamu akĩhe Melikisedeki gĩcunjĩ gĩa ikũmi kĩa indo ciothe iria aatunyĩte athamaki arĩa ana. ");
INSERT INTO kik_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nake mũthamaki wa Sodomu akĩĩra Aburamu atĩrĩ, “Niĩ nengera o andũ tu, ũrigie na indo ituĩke ciaku.” ");
INSERT INTO kik_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","No Aburamu akĩĩra mũthamaki ũcio wa Sodomu atĩrĩ, “Nĩnyambararĩtie guoko gwakwa na igũrũ na ngehĩta na mwĩhĩtwa kũrĩ Jehova Mũrungu Ũrĩa-ũrĩ-Igũrũ-Mũno, Mũmbi wa igũrũ na thĩ, ");
INSERT INTO kik_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","atĩ ndingĩĩtĩkĩra kuoya kĩndũ o na kĩmwe gĩaku, o na karũrigi kana kamũkwa ga kĩraatũ, nĩgeetha ndũkanoige atĩrĩ, ‘Nĩ niĩ ndatongirie Aburamu.’ ");
INSERT INTO kik_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ndingĩĩtĩkĩra kuoya kĩndũ, o tiga kĩrĩa kĩrĩĩtwo nĩ andũ akwa, na igai rĩa andũ arĩa tũrathiĩte nao, na nĩo Aneri, na Eshikoli, na Mamure. Acio nĩmooe rũgai rwao.” ");
INSERT INTO kik_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Thuutha wa maũndũ macio, ndũmĩrĩri ya Jehova ĩgĩkinyĩra Aburamu na kĩoneki, akĩmwĩra atĩrĩ: “Aburamu, ndũgetigĩre. Niĩ nĩ niĩ ngo yaku, na nĩ niĩ kĩheo gĩaku kĩnene.” ");
INSERT INTO kik_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","No Aburamu akĩmũũria atĩrĩ, “Mwathani Jehova, hihi nĩ kĩĩ ũkũũhe, kuona atĩ ndirĩ mwana, na ũrĩa ũkaagaya mũciĩ ũyũ wakwa nĩ Eliezeri wa Dameski?” ");
INSERT INTO kik_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ningĩ Aburamu akiuga atĩrĩ, “Nĩwagĩte kũũhe ciana; nĩ ũndũ ũcio ndungata ya mũciĩ wakwa nĩyo ĩkaangaya.” ");
INSERT INTO kik_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Hĩndĩ ĩyo ndũmĩrĩri ya Jehova ĩgĩkinyĩra Aburamu, akĩĩrwo atĩrĩ, “Aca, Eliezeri tiwe ũgaakũgaya, no mũrũguo ũrĩa ũkoima mũthiimo waku nĩwe ũgaakũgaya.” ");
INSERT INTO kik_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Akiumia Aburamu nja, akĩmwĩra atĩrĩ, “Ta tiira maitho ũrore igũrũ na ũtare njata, angĩkorwo ti-itherũ no ũcitare.” Ningĩ akĩmwĩra atĩrĩ, “Ũguo nĩguo rũciaro rwaku rũkaigana.” ");
INSERT INTO kik_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Aburamu agĩĩtĩkia Jehova. Nake Jehova agĩkenio nĩ wĩtĩkio ũcio, akĩmũtua mũthingu. ");
INSERT INTO kik_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ningĩ akĩmwĩra atĩrĩ, “Nĩ niĩ Jehova ũrĩa wakũrutire bũrũri wa Uri-kwa-Akalidei, nĩgeetha ngũhe bũrũri ũyũ ũtuĩke igai rĩaku.” ");
INSERT INTO kik_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","No Aburamu akĩmũũria atĩrĩ, “Mwathani Jehova, ũngĩĩmenyithia nakĩ atĩ nĩũgatuĩka igai rĩakwa?” ");
INSERT INTO kik_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nĩ ũndũ ũcio Jehova akĩmwĩra atĩrĩ, “Ta ndeehera moori, na mbũri, na ndũrũme, na o ĩmwe yacio ĩkorwo ĩrĩ na mĩaka ĩtatũ, o hamwe na ndutura, na gĩcui kĩa ndirahũgĩ.” ");
INSERT INTO kik_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aburamu akĩrehera Jehova indo icio ciothe, agĩciatũrania njatũ igĩrĩ, na agĩciara mũhari, o rwatũ rũkaringana na rwatũ rũrĩa rũngĩ; no nyoni-rĩ, aaciũraga ndaaciatũranirie. ");
INSERT INTO kik_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Nacio nderi ikĩharũrũkĩra nyama icio, no Aburamu agĩcingata, agĩciũmbũra. ");
INSERT INTO kik_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Riũa rĩgĩthũa-rĩ, Aburamu agĩkoma toro mũnene, nayo nduma nene na ya kũmakania ĩkĩmũnyiita. ");
INSERT INTO kik_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ningĩ Jehova akĩmwĩra atĩrĩ, “Menya na ma atĩ njiaro ciaku nĩigatũũra irĩ ageni bũrũri ũtarĩ wacio, na nĩigatuuo ngombo na inyariirwo mĩaka magana mana. ");
INSERT INTO kik_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","No nĩngaherithia rũrĩrĩ rũu igatungata irĩ ngombo, na thuutha ũcio nĩikoima kuo irĩ na ũtonga mũingĩ. ");
INSERT INTO kik_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","No wee-rĩ, ũgaakua na thayũ, na ũgaathikwo ũrĩ na ũkũrũ mwega. ");
INSERT INTO kik_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Rũciaro-inĩ rwa kana-rĩ, njiaro ciaku nĩigacooka gũkũ, nĩgũkorwo mehia ma Aamori matikinyĩte harĩa ho.” ");
INSERT INTO kik_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Na rĩrĩ, riũa rĩathũa na kwagĩa nduma-rĩ, hakĩoneka nyũngũ ya mwaki yatoogaga ĩrĩ na kĩmũrĩ gĩkĩrĩrĩmbũka gĩgĩtuĩkanĩria gatagatĩ ka njatũ icio. ");
INSERT INTO kik_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Mũthenya ũcio, Jehova akĩrĩĩkanĩra na Aburamu kĩrĩkanĩro, akĩmwĩra atĩrĩ, “Nĩndahe njiaro ciaku bũrũri ũyũ, kuuma rũũĩ rwa Misiri nginya rũũĩ rũrĩa rũnene rwa Farati: ");
INSERT INTO kik_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","bũrũri wa Akeni, na wa Akenizi, na wa Akadimoni, ");
INSERT INTO kik_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na wa Ahiti, na wa Aperizi, na wa Arefai, ");
INSERT INTO kik_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na wa Aamori, na wa Akaanani, na wa Agirigashi, na wa Ajebusi.” ");
INSERT INTO kik_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Na rĩrĩ, Sarai mũtumia wa Aburamu ndaamũciarĩire ciana. No nĩ aarĩ na mũirĩtu Mũmisiri wamũtungatagĩra wetagwo Hagari; ");
INSERT INTO kik_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","tondũ ũcio Sarai akĩĩra Aburamu atĩrĩ, “Jehova nĩagirĩtie ngĩe na ciana. Thiĩ ũkome na ndungata yakwa ya mũirĩtu; hihi kwahoteka ngĩe na rũciaro nĩ ũndũ wake.” Nake Aburamu agĩĩtĩkania na ũrĩa Sarai oigire. ");
INSERT INTO kik_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Nĩ ũndũ ũcio, thuutha wa Aburamu gũkorwo atũũrĩte Kaanani mĩaka ikũmi-rĩ, mũtumia wake Sarai akĩoya Hagari Mũmisiri ũrĩa warĩ ndungata yake ya mũirĩtu, akĩmũneana kũrĩ mũthuuriwe atuĩke mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Nake Aburamu agĩkoma na Hagari, nake akĩgĩa nda. Na rĩrĩa aamenyire atĩ nĩagĩĩte nda-rĩ, akĩambĩrĩria kũnyarara Sarai mwathi wake. ");
INSERT INTO kik_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Hĩndĩ ĩyo Sarai akĩĩra Aburamu atĩrĩ, “Ũũru ũyũ ũrathĩĩnia-rĩ, ũrogũcookerera arĩ we. Ndaneanire ndungata yakwa moko-inĩ maku, na rĩu tondũ nĩĩmenyete atĩ ĩrĩ na nda, no kũũnyarara. Jehova arotũtuithania niĩ nawe.” ");
INSERT INTO kik_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aburamu akĩmũcookeria atĩrĩ, “Ndungata yaku ĩrĩ moko-inĩ maku. Ĩka nayo ũrĩa ũkuona kwagĩrĩire.” Nake Sarai akĩnyamaria Hagari mũno; nĩ ũndũ ũcio Hagari akĩmũũrĩra. ");
INSERT INTO kik_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mũraika wa Jehova agĩkora Hagari hakuhĩ na handũ haatherũkaga maaĩ werũ-inĩ; gathima kau kaarĩ mũkĩra-inĩ wa njĩra ĩrĩa ya gũthiĩ Shuri. ");
INSERT INTO kik_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Mũraika akĩmũũria atĩrĩ, “Hagari ndungata ya Sarai, uuma kũ na wathiĩ kũ?” Hagari akĩmũcookeria atĩrĩ, “Nĩ kũũrĩra ndĩroorĩra Sarai ũrĩa mwathi wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ningĩ mũraika wa Jehova akĩmwĩra atĩrĩ, “Cooka kũrĩ mũtumia ũcio mwathi waku na ũmwĩnyiihĩrie.” ");
INSERT INTO kik_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ningĩ mũraika agĩcooka akĩmwĩra atĩrĩ, “Nĩngaingĩhia njiaro ciaku ũndũ itagaatarĩka.” ");
INSERT INTO kik_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Mũraika wa Jehova ningĩ akĩmwĩra atĩrĩ: “Rĩu ũrĩ na nda, na nĩũgaciara kaana ga kahĩĩ, na ũgaagatua Ishumaeli. Nĩgũkorwo Jehova nĩaiguĩte ũhoro wa mĩnyamaro yaku. ");
INSERT INTO kik_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mũrũguo agaatuĩka wa mbũrũrũ ta ndigiri ya gĩthaka; guoko gwake gũgookagĩrĩra andũ othe, nao andũ othe mamũũkagĩrĩre: agaatũũra na ũthũ na ariũ a ithe othe.” ");
INSERT INTO kik_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nake Hagari akĩhe Jehova ũcio wamwarĩirie rĩĩtwa rĩĩrĩ: “Wee nĩwe Ngai ũrĩa ũnyonaga,” nĩgũkorwo oigire atĩrĩ, “Rĩu niĩ ndĩkuona Ũrĩa ũnyonaga.” ");
INSERT INTO kik_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nĩkĩo gĩthima kĩu gĩetirwo Biri-Lahai-Roi, na kĩrĩ o ho, kũu gatagatĩ ga Kadeshi na Beredi. ");
INSERT INTO kik_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nĩ ũndũ ũcio Hagari agĩciarĩra Aburamu mwana wa kahĩĩ, nake Aburamu agĩtua kaana kau aaciarĩirwo Ishumaeli. ");
INSERT INTO kik_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aburamu aarĩ wa mĩaka mĩrongo ĩnana na ĩtandatũ rĩrĩa Hagari aamũciarĩire Ishumaeli. ");
INSERT INTO kik_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Na rĩrĩ, rĩrĩa Aburamu aarĩ na ũkũrũ wa mĩaka mĩrongo kenda na kenda-rĩ, Jehova nĩamuumĩrĩire, akĩmwĩra atĩrĩ, “Niĩ nĩ niĩ Mũrungu Mwene-Hinya-Wothe; tũũra ũnjathĩkagĩra, na ũtarĩ na ũcuuke. ");
INSERT INTO kik_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Na niĩ nĩngũtũũria kĩrĩkanĩro gatagatĩ gakwa nawe, na nĩngaingĩhia mũigana waku mũno.” ");
INSERT INTO kik_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Aburamu agĩturumithia ũthiũ wake thĩ, nake Ngai akĩmwĩra atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Hakwa-rĩ, gĩkĩ nĩkĩo kĩrĩkanĩro gĩakwa nawe: Wee nĩũgatuĩka ithe wa ndũrĩrĩ nyingĩ. ");
INSERT INTO kik_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ndũgũcooka gwĩtwo Aburamu; ũrĩĩtagwo Iburahĩmu, nĩgũkorwo nĩngũtuĩte ithe wa ndũrĩrĩ nyingĩ. ");
INSERT INTO kik_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nĩngũtũma ũciare mũno; na ndũme ũtuĩke ithe wa ndũrĩrĩ nyingĩ, nao athamaki nĩmakoima thĩinĩ waku. ");
INSERT INTO kik_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nĩngũthondeka kĩrĩkanĩro gĩakwa kĩrĩ kĩrĩkanĩro gĩa gũtũũra tene na tene gatagatĩ gakwa nawe na njiaro ciaku iria igooka thuutha waku, na nginya njiarwa ciaku cia thuutha, nĩguo nduĩke Ngai waku na Ngai wa njiaro iria igooka thuutha waku. ");
INSERT INTO kik_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nĩngakũhe bũrũri ũyũ wothe wa Kaanani, kũrĩa ũrĩ mũgeni rĩu, ũtũũre ũrĩ igai rĩaku na rĩa njiaro ciaku iria igooka thuutha waku; na nĩngatuĩka Ngai wao.” ");
INSERT INTO kik_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ningĩ Ngai agĩcooka akĩĩra Iburahĩmu atĩrĩ, “Wee-rĩ, no nginya ũmenyagĩrĩre kĩrĩkanĩro gĩakwa, wee na njiaro iria igooka thuutha waku, harĩ njiarwa na njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Gĩkĩ nĩkĩo kĩrĩkanĩro gĩakwa nawe na njiaro iria igooka thuutha waku, kĩrĩkanĩro kĩrĩa ũrĩmenyagĩrĩra: Arũme othe thĩinĩ wanyu nĩmarĩruaga. ");
INSERT INTO kik_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mũrĩruaga nĩguo ũndũ ũcio ũtuĩke kĩmenyithia gĩa kĩrĩkanĩro gatagatĩ gakwa nawe. ");
INSERT INTO kik_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Harĩ njiarwa iria igooka thuutha, mũndũ mũrũme wothe thĩinĩ wanyu no nginya arue arĩ na ũkũrũ wa thikũ inyanya, kũrutia arĩa maciarĩtwo thĩinĩ wa nyũmba yaku kana arĩa magũrĩtwo na mbeeca kuuma kũrĩ andũ a kũngĩ-arĩa matarĩ a rũciaro rwaku. ");
INSERT INTO kik_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mũndũ ũcio, wagũciarĩrwo nyũmba-inĩ yaku kana wakũgũrwo na mbeeca ciaku-rĩ, no nginya arue. Kĩrĩkanĩro gĩakwa kĩa mĩĩrĩ yanyu gĩgũtuĩka kĩrĩkanĩro gĩa gũtũũra tene na tene. ");
INSERT INTO kik_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Mũndũ mũrũme wothe ũtarĩ mũruu, ũrĩa ũtaruithĩtio mwĩrĩ wake-rĩ, nĩakeherio harĩ andũ ao; ũcio ndahingĩtie kĩrĩkanĩro gĩakwa.” ");
INSERT INTO kik_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ningĩ Ngai akĩĩra Iburahĩmu atĩrĩ, “Ha ũhoro wa Sarai mũtumia waku-rĩ, ndũgũcooka kũmwĩta Sarai; arĩĩtagwo Sara. ");
INSERT INTO kik_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nĩngũmũrathima, na ti-itherũ nĩngũkũhe mwana wa kahĩĩ ũciarĩirwo nĩwe. Nĩngũmũrathima nĩguo atuĩke nyina wa ndũrĩrĩ; athamaki a ndũrĩrĩ makoima harĩwe.” ");
INSERT INTO kik_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Iburahĩmu agĩturumithia ũthiũ wake thĩ, agĩcooka agĩtheka, akĩĩyũria na ngoro atĩrĩ, “Mũndũ ũrĩ na mĩaka igana nĩegũciara mwana wa kahĩĩ? Sara no aciare mwana arĩ na mĩaka mĩrongo kenda?” ");
INSERT INTO kik_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Nake Iburahĩmu akĩĩra Ngai atĩrĩ, “Naarĩ korwo Ishumaeli atũũra arathimagwo nĩwe!” ");
INSERT INTO kik_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Nake Ngai akĩmũcookeria atĩrĩ, “Ĩĩ nĩguo, no mũtumia waku Sara nĩagagũciarĩra kahĩĩ, na nĩũgaagatua Isaaka. Nĩngathondeka kĩrĩkanĩro nake gĩa gũtũũra tene na tene harĩ njiaro ciake iria igooka thuutha wake. ");
INSERT INTO kik_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Na ha ũhoro wa Ishumaeli, nĩndakũigua: Ti-itherũ nĩngũmũrathima; nĩngũtũma aciarane, aingĩhe mũno. Nĩagatuĩka ithe wa aathani ikũmi na eerĩ, na nĩngamũtua rũrĩrĩ rũnene. ");
INSERT INTO kik_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","No kĩrĩkanĩro gĩakwa ngaathondeka na Isaaka, ũrĩa Sara egũgũciarĩra mwaka ũyũ ũgũũka, ihinda-inĩ ta rĩĩrĩ tũrĩ.” ");
INSERT INTO kik_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ngai aarĩkia kwaria na Iburahĩmu, akĩambata, akĩmũtiga. ");
INSERT INTO kik_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Mũthenya o ro ũcio, Iburahĩmu akĩoya mũriũ wake Ishumaeli, na arĩa othe maciarĩirwo gwake, o na arĩa magũrĩtwo na mbeeca ciake, mũndũ mũrũme wothe wa nyũmba yake, akĩmaruithia, o ta ũrĩa Ngai aamwĩrĩte. ");
INSERT INTO kik_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Iburahĩmu aarĩ wa mĩaka mĩrongo kenda na kenda rĩrĩa aaruire, ");
INSERT INTO kik_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","nake mũriũ wake Ishumaeli aarĩ wa mĩaka ikũmi na ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Iburahĩmu na mũriũ wake Ishumaeli maaruire hamwe mũthenya o ro ũcio. ");
INSERT INTO kik_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Na mũndũ mũrũme wothe thĩinĩ wa nyũmba ya Iburahĩmu, arĩa maciarĩirwo gwake, kana mũndũ wagũrĩtwo kuuma kũrĩ mũndũ wa kũngĩ, maaruanĩire hamwe nake. ");
INSERT INTO kik_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mũthenya ũmwe Jehova nĩ oimĩrĩire Iburahĩmu rĩrĩa aikarĩte mũromo-inĩ wa hema yake hakuhĩ na mĩtĩ ĩrĩa mĩnene ya mĩgandi ya Mamure, ihinda rĩa mĩaraho. ");
INSERT INTO kik_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Na rĩrĩ, Iburahĩmu aatiira maitho-rĩ, akĩona andũ atatũ marũgamĩte o hakuhĩ nake. Rĩrĩa aamoonire, akĩhiũha akiuma mũromo-inĩ wa hema yake, agĩthiĩ kũmatũnga, na agĩturumithia ũthiũ wake thĩ. ");
INSERT INTO kik_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Akiuga atĩrĩ, “Mwathi wakwa, angĩkorwo nĩndetĩkĩrĩka maitho-inĩ maku, ndũkahĩtũke ndungata yaku. ");
INSERT INTO kik_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Reke tũũĩ tũnini tũrehwo, na inyuĩ inyuothe mwĩthambe magũrũ na mũhurũke kĩĩruru-inĩ kĩa mũtĩ ũyũ. ");
INSERT INTO kik_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Na niĩ thiĩ ndĩmũrehere kĩndũ gĩa kũrĩa, nĩgeetha mũcookwo nĩ hinya, kuona atĩ nĩmwagĩũka kwa ndungata yanyu, nĩguo mũcooke mwĩthiĩre.” Makĩmũcookeria atĩrĩ, “Nĩ wega mũno, ĩka o ũguo woiga.” ");
INSERT INTO kik_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Nĩ ũndũ ũcio Iburahĩmu akĩhiũha agĩthiĩ hema-inĩ kũrĩ Sara, akĩmwĩra atĩrĩ, “Oya ibaba ithatũ cia mũtu ũrĩa mũhinyu wega, ũũkande na ũruge mĩgate naihenya.” ");
INSERT INTO kik_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ningĩ Iburahĩmu agĩtengʼera rũũru-inĩ, agĩthuura njaũ njega na njororo, akĩmĩnengera ndungata, nayo ĩkĩmĩthĩnja naihenya. ");
INSERT INTO kik_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ningĩ Iburahĩmu akĩmarehera iria imata na iria rĩa mwĩtha, na nyama cia njaũ ĩyo yathĩnjĩtwo, agĩciiga hau mbere yao. Nake akĩrũgama hakuhĩ nao mũtĩ-inĩ rĩrĩa maarĩĩaga. ");
INSERT INTO kik_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Maarĩkia kũrĩa makĩmũũria atĩrĩ, “Sara mũtumia waku-rĩ, arĩ kũ?” Iburahĩmu akĩmacookeria atĩrĩ, “Arĩ kũũrĩa hema thĩinĩ.” ");
INSERT INTO kik_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Nake Jehova akiuga atĩrĩ, “Ti-itherũ nĩngooka kũrĩ we rĩngĩ hĩndĩ o ta ĩno mwaka ũyũ ũroka, na Sara mũtumia waku nĩagaciara kaana ga kahĩĩ.” Nake Sara nĩathikagĩrĩria arĩ hau mũromo-inĩ wa hema ĩrĩa yarĩ thuutha wa Iburahĩmu. ");
INSERT INTO kik_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Na rĩrĩ, Iburahĩmu na Sara maarĩ akũrũ na magatindĩka mĩaka yao ma, nake Sara akahĩtũkia mĩaka ya gũciara. ");
INSERT INTO kik_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nĩ ũndũ ũcio, Sara agĩĩthekera, akĩĩyũria atĩrĩ, “Thuutha wa gũkũra ũũ-rĩ, na mwathi wakwa nĩ mũkũrũ-rĩ, no ngĩgĩe na gĩkeno kĩu?” ");
INSERT INTO kik_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nake Jehova akĩũria Iburahĩmu atĩrĩ, “Nĩ kĩĩ gĩatũma Sara atheke na eyũrie, ‘Ti-itherũ no ngĩe na mwana ndĩ mũkũrũ ũguo?’ ");
INSERT INTO kik_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kaĩ kũrĩ ũndũ ũngĩrema Jehova? Mwaka ũyũ ũroka-rĩ, nĩngacooka ihinda rĩrĩa rĩamũre, nake Sara nĩagaciara kaana ga kahĩĩ.” ");
INSERT INTO kik_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara agĩĩtigĩra mũno, nĩ ũndũ ũcio akĩheenania, akiuga atĩrĩ, “Niĩ ndinatheka.” Nowe Jehova akiuga atĩrĩ, “Nĩ ma nĩwatheka.” ");
INSERT INTO kik_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Rĩrĩa andũ acio mookĩrire mathiĩ-rĩ, makĩerekera na Sodomu, nake Iburahĩmu agĩtwarana nao amoimagarie. ");
INSERT INTO kik_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Hĩndĩ ĩyo Jehova akĩĩyũria atĩrĩ, “No hithe Iburahĩmu ũrĩa ndĩrenda gwĩka? ");
INSERT INTO kik_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ti-itherũ Iburahĩmu nĩagatuĩka rũrĩrĩ rũnene na rwa hinya, na ndũrĩrĩ ciothe cia thĩ nĩikarathimwo nĩ ũndũ wake. ");
INSERT INTO kik_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nĩgũkorwo nĩndĩmũthuurĩte nĩgeetha onagĩrĩrie ciana ciake, na nyũmba yake, na arĩa magooka thuutha wake, kũrũmagia mĩthiĩre ya Jehova na ũndũ wa gwĩkaga ũrĩa kwagĩrĩire, na kĩhooto, nĩgeetha Jehova akaahingĩria Iburahĩmu ũrĩa aamwĩrĩire.” ");
INSERT INTO kik_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ningĩ Jehova akiuga atĩrĩ, “Mũkayo wĩgiĩ Sodomu na Gomora nĩ mũnene mũno, naguo wĩhia wao nĩ mũũru mũno. ");
INSERT INTO kik_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Nĩ ũndũ ũcio niĩ nĩngũikũrũka thiĩ nyone kana ũũru ũrĩa mekĩte nĩũigana ikaya rĩrĩa rĩnginyĩire. Na aakorwo tiguo-rĩ, nĩngũmenya ũrĩa ngwĩka.” ");
INSERT INTO kik_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Nĩ ũndũ ũcio andũ acio makiuma hau magĩthiĩ merekeire Sodomu, no Iburahĩmu agĩtigwo arũgamĩte mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Nake Iburahĩmu agĩkuhĩrĩria Jehova akĩmũũria atĩrĩ, “Andũ arĩa athingu ũkũmaniinanĩria hamwe na arĩa aaganu? ");
INSERT INTO kik_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ĩ kũngĩkorwo kũrĩ na andũ mĩrongo ĩtano athingu itũũra-inĩ rĩu inene? Ti-itherũ no ũrĩniine na ndũrĩhonokie nĩ ũndũ wa andũ acio mĩrongo ĩtano athingu marĩ kuo? ");
INSERT INTO kik_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ũroaga gwĩka ũndũ ta ũcio, wa kũũraganĩria arĩa athingu hamwe na arĩa aaganu, arĩa athingu na arĩa aaganu ũmataranĩrie ũndũ ũmwe. Ũroaga gwĩka ũndũ ta ũcio! Mũtuanĩri ciira wa thĩ yothe-rĩ, githĩ ndagĩrĩirwo nĩ gwĩka ũrĩa kwagĩrĩire?” ");
INSERT INTO kik_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nake Jehova akiuga atĩrĩ, “Ingĩkora andũ mĩrongo ĩtano athingu kũu itũũra rĩu inene rĩa Sodomu-rĩ, nĩngũhonokia kũndũ kũu guothe nĩ ũndũ wao.” ");
INSERT INTO kik_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ningĩ Iburahĩmu akĩaria rĩngĩ, akiuga atĩrĩ: “Rĩu tondũ nĩngĩĩũmĩrĩirie nginya ndaaria na Mwathani, o na gũtuĩka ndĩ o rũkũngũ na mũhu-rĩ, atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ĩ hangĩaga andũ atano a acio mĩrongo ĩtano athingu? Nĩ ũngĩniina itũũra rĩu inene rĩothe nĩ ũndũ wa kwaga acio atano?” Jehova akĩmwĩra atĩrĩ, “Ingĩkora andũ mĩrongo ĩna na atano kuo, ndikũrĩniina.” ");
INSERT INTO kik_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","O rĩngĩ Iburahĩmu akĩmwarĩria akĩmũũria atĩrĩ, “Ĩ ũngĩkora andũ mĩrongo ĩna tu kuo?” Nake akiuga atĩrĩ, “Nĩ ũndũ wa acio mĩrongo ĩna-rĩ, ndikũrĩniina.” ");
INSERT INTO kik_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ningĩ Iburahĩmu akiuga atĩrĩ, “Mwathani aroaga kũrakara, no areke njarie. Ĩ ũngĩkora andũ mĩrongo ĩtatũ kuo?” Nake akĩmũcookeria atĩrĩ, “Ndikũrĩniina ingĩkora andũ mĩrongo ĩtatũ kuo.” ");
INSERT INTO kik_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Iburahĩmu akiuga atĩrĩ, “Rĩu tondũ nĩngĩĩũmĩrĩirie nginya ndaaria na Mwathani-rĩ, ĩ kũngĩoneka o andũ mĩrongo ĩĩrĩ kuo?” Nake Jehova akiuga atĩrĩ, “Nĩ ũndũ wa acio mĩrongo ĩĩrĩ, ndikũrĩniina.” ");
INSERT INTO kik_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ningĩ akiuga atĩrĩ, “Mwathani aroaga kũrakara no areke njarie rĩngĩ rĩmwe. Ĩ kũngĩoneka o andũ ikũmi kuo?” Nake Jehova agĩcookia, akiuga atĩrĩ, “Nĩ ũndũ wa acio ikũmi-rĩ, ndikũrĩniina.” ");
INSERT INTO kik_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Rĩrĩa Jehova aarĩkirie kwaria na Iburahĩmu, agĩĩthiĩra, nake Iburahĩmu agĩcooka mũciĩ. ");
INSERT INTO kik_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nao araika acio eerĩ magĩkinya Sodomu hwaĩ-inĩ, nake Loti aikarĩte kĩhingo-inĩ gĩa itũũra rĩu inene. Rĩrĩa aamoonire-rĩ, agĩũkĩra nĩguo amatũnge, na agĩturumithia ũthiũ wake thĩ. ");
INSERT INTO kik_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Akĩmeera atĩrĩ, “Aathi akwa, ndamũthaitha ũkai mũtoonye nyũmba ya ndungata yanyu. No mwĩthambe magũrũ na mũraarĩrĩre, na rũciinĩ tene mũrooke gũthiĩ na mbere na rũgendo rwanyu.” No-o makĩmũcookeria atĩrĩ, “Aca, ithuĩ tũkũraara nja kĩhaaro-inĩ.” ");
INSERT INTO kik_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Nowe Loti akĩmaringĩrĩria na hinya mũno mathiĩ gwake mũciĩ, nginya magĩtĩkĩra. Magĩthiĩ nake, magĩtoonya nyũmba gwake. Nake akĩmathondekera irio, akĩruga mĩgate ĩtaarĩ ndawa ya kũimbia, nao makĩrĩa. ");
INSERT INTO kik_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Matanathiĩ gũkoma-rĩ, arũme othe a kuuma ituri ciothe cia itũũra rĩu rĩa Sodomu, arĩa ethĩ na arĩa akũrũ, makĩrigiicĩria nyũmba ya Loti. ");
INSERT INTO kik_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Nao magĩĩta Loti, makĩmũũria atĩrĩ, “Andũ arĩa mookire gwaku ũtukũ ũyũ-rĩ, marĩ-kũ? Marehe na gũkũ nja, tũkome nao.” ");
INSERT INTO kik_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loti akiuma na nja amatũnge, na akĩhinga mũrango, ");
INSERT INTO kik_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","akĩmeera atĩrĩ, “Aca, arata akwa; mũtigeke ũndũ ũcio wa waganu. ");
INSERT INTO kik_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Atĩrĩrĩ, ndĩ na airĩtu akwa eerĩ matarĩ maakoma na mũndũ mũrũme. Rekei ndĩmarehe na gũkũ nja, na inyuĩ mwĩke o ũrĩa mũkwenda nao. No mũtigeke ũndũ o na ũrĩkũ kũrĩ andũ aya, tondũ mokĩte gwakwa na no nginya ndĩmagitĩre.” ");
INSERT INTO kik_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Nao makĩmũcookeria atĩrĩ, “Ehera.” Na makiuga atĩrĩ, “Mũndũ ũyũ ookire gũkũ arĩ mũgeni, na rĩu arenda gũtũciirithia! Wee nĩwe tũgwĩka ũũru gũkĩra acio!” Magĩkĩrĩrĩria kũhatĩrĩria Loti, na magĩkuhĩrĩria nĩguo moinange mũrango. ");
INSERT INTO kik_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","No ageni acio maarĩ thĩinĩ magĩtambũrũkia moko, makĩguucia Loti, makĩmũcookia nyũmba na makĩhinga mũrango. ");
INSERT INTO kik_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Magĩcooka makĩhũũra andũ acio maarĩ nja ya mũrango wa nyũmba, ethĩ na akũrũ, na ũtumumu nĩgeetha mage kuona mũrango. ");
INSERT INTO kik_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Andũ acio eerĩ makĩũria Loti atĩrĩ, “Ũrĩ na andũ angĩ aku gũkũ, ta arĩa mahikĩtie airĩtu aku, aanake kana airĩtu aku, kana mũndũ ũngĩ waku o wothe ũrĩ itũũra-inĩ rĩĩrĩ inene? Moimagarie muume gũkũ, ");
INSERT INTO kik_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","tondũ nĩtũkwananga kũndũ gũkũ. Mũkayo ũrĩa ũkaĩirwo Jehova okĩrĩre andũ a gũkũ nĩ mũnene mũno, na nĩatũtũmĩte tũũke tũrĩanange.” ");
INSERT INTO kik_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Nĩ ũndũ ũcio Loti akiumagara, agĩthiĩ akĩaria na athoni ake, arĩa maarĩ mahikie airĩtu ake. Akĩmeera atĩrĩ, “Mwĩhĩkei muume kũndũ gũkũ, nĩ ũndũ Jehova arĩ hakuhĩ kwananga itũũra rĩĩrĩ inene!” No athoni ake magĩĩciiria nĩ itherũ aamaringaga. ");
INSERT INTO kik_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Rũciinĩ ruoro rũgĩtema-rĩ, araika acio makĩhĩkahĩka Loti, makĩmwĩra atĩrĩ, “Wĩhĩke! Oya mũtumia waku na airĩtu aku eerĩ arĩa marĩ gũkũ, kana mũniinanĩrio na itũũra rĩĩrĩ rĩkĩherithio.” ");
INSERT INTO kik_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Rĩrĩa Loti aahindahindire-rĩ, andũ acio makĩmũnyiita guoko, na moko ma mũtumia wake na ma airĩtu ake eerĩ, na makĩmoimagaria o wega nginya nja ya itũũra rĩu inene, nĩgũkorwo Jehova nĩamaiguĩrĩire tha. ");
INSERT INTO kik_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Na maarĩkia kũmaruta nja ya itũũra, ũmwe wao akĩmeera atĩrĩ, “Mwĩtharei mũhonokie mĩoyo yanyu! Mũtikehũgũre, na mũtikarũgame handũ o na ha gũkũ kĩaragana-inĩ gĩkĩ! Ũrĩrai irĩma-inĩ, kana mũniinwo!” ");
INSERT INTO kik_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","No Loti akĩmeera atĩrĩ, “Aca, aathi akwa, ndamũthaitha! ");
INSERT INTO kik_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tondũ ndungata yanyu nĩ ĩtĩkĩrĩkĩte maitho-inĩ manyu, na nĩmũnyonetie ũtugi mũnene wa kũhonokia muoyo wakwa, no ndingĩhota kũũrĩra irĩma-inĩ; mwanangĩko ũyũ nĩũkũngorerera, na nĩngũkua. ");
INSERT INTO kik_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ta rorai, haarĩa harĩ na itũũra rĩrĩ hakuhĩ ingĩũrĩra, na nĩ inini. Rekei njũrĩre kuo, nĩ itũũra inini mũno, githĩ tiguo? Naguo muoyo wakwa nĩũkũhonoka.” ");
INSERT INTO kik_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Nake mũraika akĩmwĩra atĩrĩ, “Nĩ wega mũno, nĩngũkũiguĩra ihooya rĩu o narĩo; Ndikũharagania itũũra rĩu waria ũhoro warĩo. ");
INSERT INTO kik_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","No rĩrĩ, ũrĩra kuo na ihenya, nĩ ũndũ gũtirĩ ũndũ ingĩĩka nginya ũkinye kuo.” (Nĩkĩo itũũra rĩu rĩĩtagwo Zoari.) ");
INSERT INTO kik_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Loti agĩkinya Zoari-rĩ, riũa nĩrĩarĩkĩtie kũratha. ");
INSERT INTO kik_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nake Jehova akiurĩria Sodomu na Gomora mwaki wa ũbiriti uumĩte igũrũ kũrĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Nake akĩharagania matũũra macio manene, na kĩaragana kĩu gĩothe, o hamwe na arĩa othe maatũire matũũra-inĩ macio manene, o na mĩmera yothe ya bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","No mũtumia wa Loti nĩehũgũrire na thuutha, nake agĩtuĩka gĩtugĩ gĩa cumbĩ. ");
INSERT INTO kik_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Mũthenya ũyũ ũngĩ rũciinĩ tene-rĩ, Iburahĩmu agĩũkĩra na agĩcooka handũ harĩa aarũgamĩte mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Agĩcũthĩrĩria mwena wa Sodomu na Gomora, bũrũri wothe wa kĩaragana kĩu, nake akĩona ndogo ndumanu yambatĩte na igũrũ kuuma bũrũri-inĩ ũcio, ĩhaana ta ndogo yumĩte icua-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nĩ ũndũ ũcio, rĩrĩa Jehova aanangire matũũra macio manene ma kĩaragana kĩu, nĩaririkanire Iburahĩmu, na akĩruta Loti mwanangĩko-inĩ ũcio waharaganirie matũũra macio manene kũrĩa Loti atũire. ");
INSERT INTO kik_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Thuutha ũcio Loti akiuma Zoari, agĩthiĩ gũtũũra kĩrĩma-inĩ arĩ hamwe na airĩtu ake eerĩ, tondũ nĩetigĩrire gũikara Zoari. We na airĩtu ake eerĩ magĩtũũra ngurunga-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Mũthenya ũmwe-rĩ, mũirĩtu ũrĩa warĩ mũkũrũ akĩĩra ũrĩa warĩ mũnini atĩrĩ, “Ithe witũ nĩ mũkũrũ, na gũtirĩ mũndũ mũrũme ũrĩ hakuhĩ wa gũkoma na ithuĩ, ta ũrĩa arĩ mũtugo kũndũ guothe gũkũ thĩ. ");
INSERT INTO kik_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Reke tũhe ithe witũ ndibei anyue nĩgeetha tũkome nake, na tũtũũrie rũciaro rwitũ na ũndũ wa ithe witũ.” ");
INSERT INTO kik_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ũtukũ ũcio magĩtũma ithe wao anyue ndibei, na mũirĩtu ũrĩa mũkũrũ agĩtoonya na agĩkoma nake. Nowe Loti ndaamenyire rĩrĩa mũirĩtu aakomire kana rĩrĩa ookĩrire. ");
INSERT INTO kik_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Mũthenya ũyũ ũngĩ, mũirĩtu ũrĩa mũkũrũ akĩĩra ũrĩa mũnini atĩrĩ, “Hwaĩ ũtukũ nĩ niĩ ndĩrakomire na ithe witũ. Reke tũmũhe ndibei rĩngĩ anyue ũtukũ wa ũmũthĩ, nawe ũthiĩ ũkome nake, nĩgeetha tũtũũrie rũciaro rwitũ na ũndũ wa ithe witũ.” ");
INSERT INTO kik_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Nĩ ũndũ ũcio magĩtũma ithe wao anyue ndibei ũtukũ ũcio o naguo, nake mũirĩtu ũrĩa warĩ mũnini agĩtoonya agĩkoma nake. O rĩngĩ Loti ndaamenyire rĩrĩa mũirĩtu aakomire kana rĩrĩa ookĩrire. ");
INSERT INTO kik_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Nĩ ũndũ ũcio airĩtu acio eerĩ a Loti makĩgĩa nda na ithe wao. ");
INSERT INTO kik_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Mũirĩtu ũrĩa mũkũrũ agĩciara kahĩĩ na agĩgatua Moabi, na nĩwe ithe wa andũ a Moabi gwata ũmũthĩ. ");
INSERT INTO kik_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Mũirĩtu ũrĩa mũnini o nake agĩciara kahĩĩ, nake agĩgatua Beni-Ami, na nĩwe ithe wa Aamoni arĩa marĩ kuo nginya ũmũthĩ. ");
INSERT INTO kik_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Na rĩrĩ, Iburahĩmu nĩoimire kũu aarĩ, agĩthiĩ mwena wa Negevu, na agĩtũũra gatagatĩ ga Kadeshi na Shuri. Gwa kahinda nĩatũũrire Gerari ");
INSERT INTO kik_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","na arĩ kũu Iburahĩmu oigaga atĩrĩ ha ũhoro wa mũtumia wake Sara, “Ũyũ nĩ mwarĩ wa baba.” Tondũ ũcio Abimeleku mũthamaki wa Gerari agĩtũmanĩra Sara na akĩmuoya. ");
INSERT INTO kik_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","No rĩrĩ, Ngai akiumĩrĩra Abimeleku ũtukũ na kĩroto, akĩmwĩra atĩrĩ, “Wee-rĩ, no ta ũkuĩte tondũ mũndũ-wa-nja ũcio woete nĩ mũtumia wene.” ");
INSERT INTO kik_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","No Abimeleku ndaakoretwo akuhĩrĩirie Sara, nĩ ũndũ ũcio akĩũria atĩrĩ, “Mwathani, no wanange rũrĩrĩ rũtehĩtie? ");
INSERT INTO kik_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Githĩ ti we wanjĩĩrire, ‘Ũyũ nĩ mwarĩ wa baba?’ Na ningĩ o nake Sara githĩ ndoigire atĩrĩ, ‘Ũyũ nĩ mũrũ wa baba?’ Njĩkĩte ũndũ ũcio na ũrũngĩrĩru wa ngoro na moko matarĩ ũcuuke.” ");
INSERT INTO kik_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ningĩ Ngai akĩmwĩra atĩrĩ kĩroto-inĩ, “Ĩĩ, nĩnjũũĩ ũrekĩte ũguo na ũrũngĩrĩru wa ngoro, na nĩkĩo ndĩrakũgiririe ũnjĩhĩrie. Nĩkĩo itanareka ũmũhutie. ");
INSERT INTO kik_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Rĩu-rĩ, cookeria mũndũ ũcio mũtumia wake, nĩgũkorwo nĩ mũnabii, nake nĩegũkũhooera, na nĩũgũtũũra muoyo. No waga kũmũcookia-rĩ, ũmenye ti-itherũ wee nĩũgũkua, na andũ aku othe nĩmegũkua.” ");
INSERT INTO kik_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Mũthenya ũyũ ũngĩ rũciinĩ tene, Abimeleku agĩtũmanĩra anene ake othe, na aarĩkia kũmeera maũndũ marĩa mothe meekĩkĩte, andũ acio magĩĩtigĩra mũno. ");
INSERT INTO kik_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimeleku agĩcooka agĩĩta Iburahĩmu na akĩmũũria atĩrĩ, “Nĩ atĩa ũguo ũtwĩkĩte? Nĩ atĩa ngwĩhĩirie, nĩguo ũndeherere niĩ na ũthamaki wakwa ũũru mũnene ũguo? Ũnjĩkĩte maũndũ mataagĩrĩire gwĩkwo.” ");
INSERT INTO kik_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ningĩ Abimeleku akĩũria Iburahĩmu atĩrĩ, “Nĩ kĩĩ gĩatũmire wĩke ũguo?” ");
INSERT INTO kik_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iburahĩmu akĩmũcookeria atĩrĩ, “Ndeĩrire atĩrĩ, ‘Kũndũ gũkũ andũ matiĩtigĩrĩte Ngai, na nĩmekũnjũraga nĩ ũndũ wa mũtumia wakwa.’ ");
INSERT INTO kik_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","O na kũrĩ ũguo, ti-itherũ nĩ mwarĩ wa-baba, mũirĩtu wa baba; no tũtirĩ a nyina ũmwe, nĩkĩo aatuĩkire mũtumia wakwa. ");
INSERT INTO kik_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na rĩrĩa Ngai aandutire kuuma nyũmba-inĩ ya baba thiĩ ngorũũrage, ndeerire mũtumia wakwa atĩrĩ, ‘Ũũ nĩguo ũrĩnyonagia wendo waku: Kũrĩa guothe tũrĩthiiaga, uugage atĩrĩ ũhoro-inĩ ũnjĩgiĩ, “Ũyũ nĩ mũrũ wa baba.” ’ ” ");
INSERT INTO kik_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Iburahĩmu aarĩkia kwaria, Abimeleku akĩruta ngʼondu na ngʼombe, na ngombo cia arũme na cia andũ-a-nja, na agĩcihe Iburahĩmu, na akĩmũcookeria Sara mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ningĩ Abimeleku akĩmwĩra atĩrĩ, “Bũrũri wakwa ũrĩ mbere yaku; tũũra harĩa hothe ũngĩenda.” ");
INSERT INTO kik_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Nake Abimeleku akĩĩra Sara atĩrĩ, “Nĩngũhe mũrũ-wa-thoguo cekeri 1,000 cia betha ituĩke cia kũrĩhĩria ihĩtia rĩrĩa ũhĩtĩirio mbere ya andũ aya othe mũrĩ nao; we ndũrĩ ũũru wĩkĩte.” ");
INSERT INTO kik_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Nake Iburahĩmu akĩhooya Ngai, nake Ngai akĩhonia Abimeleku, na mũtumia wake, na ngombo ciake cia airĩtu nĩguo mahote gũciara ciana rĩngĩ, ");
INSERT INTO kik_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","nĩgũkorwo Jehova nĩahingĩte nda cia andũ-a-nja othe a nyũmba ya Abimeleku, makaaga kũgĩa ciana, nĩ ũndũ wa Abimeleku kuoya Sara mũtumia wa Iburahĩmu. ");
INSERT INTO kik_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nake Jehova agĩtuga Sara o ta ũrĩa oigĩte, na Jehova akĩhingĩria Sara kĩrĩkanĩro kĩrĩa aamwĩrĩire. ");
INSERT INTO kik_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara akĩgĩa nda, na agĩciarĩra Iburahĩmu kaana ga kahĩĩ ũkũrũ-inĩ wake, o ihinda rĩrĩa Jehova aamwĩrĩte. ");
INSERT INTO kik_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Iburahĩmu agĩtua kaana kau ga kahĩĩ aaciarĩirwo nĩ Sara, Isaaka. ");
INSERT INTO kik_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Na rĩrĩa mũriũ ũcio wake Isaaka akinyirie thikũ inyanya-rĩ, Iburahĩmu akĩmũruithia, o ta ũrĩa Ngai aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Iburahĩmu aarĩ na mĩaka igana rĩmwe rĩrĩa mũriũ wake Isaaka aaciarirwo. ");
INSERT INTO kik_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara akiuga atĩrĩ, “Ngai nĩatũmĩte theke, na mũndũ o wothe ũrĩiguaga ũhoro ũcio nĩarĩthekaga hamwe na niĩ.” ");
INSERT INTO kik_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Agĩcooka akiuga atĩrĩ, “Nũũ ũngĩerire Iburahĩmu atĩ Sara nĩakongithia ciana? No rĩrĩ, nĩndĩmũciarĩire kaana ga kahĩĩ ũkũrũ-inĩ wake.” ");
INSERT INTO kik_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nako kaana kau gagĩkũra na gagĩtigithio kuonga; naguo mũthenya ũrĩa Isaaka aatigithirio kuonga-rĩ, Iburahĩmu akĩrugithia iruga inene. ");
INSERT INTO kik_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","No Sara akĩona atĩ mũriũ wa Hagari ũrĩa Mũmisiri aaciarĩire Iburahĩmu aarĩ na kĩnyũrũri. ");
INSERT INTO kik_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Nake akĩĩra Iburahĩmu atĩrĩ, “Ingata ngombo ĩno ya mũndũ-wa-nja hamwe na mũriũ, tondũ mũriũ ũcio wa ngombo ĩyo ya mũndũ-wa-nja ndakagayana igai na mũriũ wakwa Isaaka.” ");
INSERT INTO kik_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Naguo ũhoro ũcio ũgĩthĩĩnia Iburahĩmu mũno tondũ wakoniĩ mũriũ. ");
INSERT INTO kik_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","No Ngai akĩmwĩra atĩrĩ, “Tiga gũthĩĩnĩka mũno nĩ ũndũ wa kĩmwana kĩu, na ndungata ĩyo yaku ya mũndũ-wa-nja. Thikĩrĩria ũrĩa wothe Sara egũkwĩra, tondũ rũciaro rũrĩa rũgeetanio nawe rũkoima harĩ Isaaka. ");
INSERT INTO kik_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","O na ningĩ nĩngatũma mũriũ wa ndungata ĩyo ya mũndũ-wa-nja atuĩke rũrĩrĩ rũnene, tondũ nĩ rũciaro rwaku.” ");
INSERT INTO kik_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Mũthenya ũyũ ũngĩ rũciinĩ tene Iburahĩmu akĩoya irio na mondo ya rũũa ĩrĩ na maaĩ, na agĩcinengera Hagari. Akĩmũigĩrĩra ciande-inĩ ciake, agĩcooka akĩmumagaria hamwe na kĩmwana kĩu. Nake Hagari agĩĩthiĩra, na agĩturĩrwo nĩ njĩra arĩ kũu werũ-inĩ wa Birishiba. ");
INSERT INTO kik_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Na rĩrĩa maaĩ marĩa maarĩ rũũa-inĩ maathirire-rĩ, Hagari akĩiga kĩmwana kĩu rungu rwa kĩhinga kĩmwe. ");
INSERT INTO kik_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Nake agĩthiiathiia, agĩikara thĩ handũ hataarĩ haraihu, ta ha rĩikia rĩa mũguĩ, tondũ eeciiririe atĩrĩ, “Ndingĩĩrorera kĩmwana gĩakwa gĩgĩkua.” Na aikarĩte hau hakuhĩ, akĩambĩrĩria kũgirĩka. ");
INSERT INTO kik_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nake Ngai akĩigua kĩmwana kĩu gĩkĩrĩra, nake mũraika wa Ngai agĩĩta Hagari arĩ kũu igũrũ akĩmũũria atĩrĩ, “Nĩ kĩĩ kĩragũthĩĩnia Hagari? Tiga gwĩtigĩra; Ngai nĩaiguĩte kĩrĩro gĩa kĩmwana kĩu kĩrĩ o hau kĩrĩ. ");
INSERT INTO kik_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tiira kĩmwana kĩu na igũrũ, na ũkĩnyiitĩrĩre na guoko, nĩgũkorwo nĩngagĩtua rũrĩrĩ rũnene.” ");
INSERT INTO kik_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hĩndĩ ĩyo Ngai akĩmũhingũra maitho, nake akĩona gĩthima kĩa maaĩ. Agĩthiĩ ho, akĩiyũria rũũa maaĩ, na akĩhe kĩmwana kĩu kĩnyue. ");
INSERT INTO kik_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ngai nĩakorirwo hamwe na kĩmwana kĩu o ũrĩa gĩakũraga. Gĩatũũrire werũ-inĩ, na gĩgĩtuĩka mũrathi na ũta. ");
INSERT INTO kik_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Hĩndĩ ĩyo aatũũraga Werũ-inĩ wa Parani-rĩ, nyina akĩmwethera mũtumia kuuma Misiri. ");
INSERT INTO kik_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ihinda-inĩ-rĩu Abimeleku na Fikolu mũnene wa mbũtũ ciake cia ita makĩĩra Iburahĩmu atĩrĩ, “Ngai arĩ hamwe nawe maũndũ-inĩ mothe marĩa wĩkaga. ");
INSERT INTO kik_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Rĩu-rĩ, wĩhĩte ũrĩ mbere ya Ngai atĩ ndũkanjuukanĩrĩra, kana ũcuukanĩre ciana ciakwa, o na kana njiaro ciakwa. Nyonagia ũtugi niĩ na bũrũri ũyũ we ũtũũraga ũrĩ mũgeni o ta ũrĩa niĩ nguonetie ũtugi.” ");
INSERT INTO kik_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Iburahĩmu agĩcookia atĩrĩ, “Nĩndehĩta.” ");
INSERT INTO kik_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ningĩ Iburahĩmu agĩtetia Abimeleku nĩ ũndũ wa gĩthima kĩa maaĩ kĩrĩa ndungata cia Abimeleku ciamũtunyĩte. ");
INSERT INTO kik_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","No Abimeleku akiuga atĩrĩ, “Ndiũĩ nũũ wĩkĩte ũndũ ũcio. Wee ndwanjĩĩrire, na ndaigua ũhoro ũcio ũmũthĩ.” ");
INSERT INTO kik_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Nĩ ũndũ ũcio Iburahĩmu akĩrehe ngʼondu na ngʼombe akĩhe Abimeleku, nao andũ acio eerĩ makĩgĩa na kĩrĩkanĩro. ");
INSERT INTO kik_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Iburahĩmu akĩamũra mĩatĩ mũgwanja kuuma rũũru-inĩ rwake. ");
INSERT INTO kik_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Nake Abimeleku akĩũria Iburahĩmu atĩrĩ, “Mĩatĩ ĩno mũgwanja-rĩ, wamĩamũra kuuma rũũru-inĩ nĩkĩ?” ");
INSERT INTO kik_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Iburahĩmu akĩmũcookeria atĩrĩ, “Ĩtĩkĩra kuoya mĩatĩ ĩno mũgwanja kuuma kũrĩ niĩ, ĩtuĩke ũira atĩ nĩ niĩ ndenjire gĩthima gĩkĩ.” ");
INSERT INTO kik_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tondũ ũcio handũ hau hagĩĩtwo Birishiba tondũ hau nĩ ho andũ acio eerĩ mehĩtĩire mwĩhĩtwa. ");
INSERT INTO kik_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Thuutha wa kũrĩkanĩra kĩrĩĩko kĩu kũu Birishiba, Abimeleku na Fikolu mũnene wa mbũtũ ciake cia ita, magĩcooka bũrũri wa Afilisti. ");
INSERT INTO kik_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nake Iburahĩmu akĩhaanda mũtĩ wa mũbinde kũu Birishiba, na agĩkaĩra rĩĩtwa rĩa Jehova, o we Mũrungu Ũrĩa-Ũtũũraga-Tene-na-Tene, arĩ handũ hau. ");
INSERT INTO kik_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Nake Iburahĩmu agĩikara bũrũri-inĩ ũcio wa Afilisti ihinda iraaya ma. ");
INSERT INTO kik_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Thuutha wa maũndũ macio-rĩ, Ngai nĩageririe Iburahĩmu. Ngai akĩmwĩta atĩrĩ, “Iburahĩmu!” Nake agĩcookia atĩrĩ, “Niĩ ũyũ haha.” ");
INSERT INTO kik_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Nake Ngai akĩmwĩra atĩrĩ, “Oya mũriũ waku, o we ũrĩa wa mũmwe Isaaka, ũrĩa wendete, ũthiĩ rũgongo rwa Moria, na ũmũrute ta igongona rĩa njino kuo kĩrĩma-inĩ kĩmwe kĩa iria ngaakuonia.” ");
INSERT INTO kik_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nĩ ũndũ ũcio mũthenya ũyũ ũngĩ rũciinĩ tene, Iburahĩmu agĩũkĩra, agĩtandĩka ndigiri yake. Akĩoya ndungata ciake igĩrĩ na mũriũ wake Isaaka. Aarĩkia gwatũra ngũ cia kũigana igongona rĩa njino-rĩ, akiumagara erekeire handũ harĩa Ngai aamwĩrĩte. ");
INSERT INTO kik_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mũthenya wa gatatũ, Iburahĩmu agĩtiira maitho na akĩona handũ hau harĩ o kũraya. ");
INSERT INTO kik_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Akĩĩra ndungata ciake atĩrĩ, “Ikaragai haha na ndigiri ĩno, na niĩ na kĩmwana gĩakwa tũthiĩ haarĩa tũkahooe Ngai, na tũcooke tũmũcookerere.” ");
INSERT INTO kik_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Iburahĩmu agĩkĩoya ngũ icio cia igongona rĩa njino, agĩciigĩrĩra mũriũ wake Isaaka, nake agĩkuua mwaki na kahiũ. Na rĩrĩa o eerĩ mathiiaga hamwe, ");
INSERT INTO kik_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaaka akĩaria, agĩĩta ithe Iburahĩmu atĩrĩ, “Baba!” Iburahĩmu akĩmũcookeria atĩrĩ, “Niĩ ũyũ, mũrũ wakwa.” Isaaka akiuga atĩrĩ, “Ndĩrona tũrĩ na mwaki na ngũ! No rĩrĩ, gatũrũme ka igongona rĩa njino karĩ ha?” ");
INSERT INTO kik_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Iburahĩmu agĩcookia atĩrĩ, “Mũrũ wakwa, Ngai we mwene nĩekũheana gatũrũme ka igongona rĩa njino.” Nao eerĩ magĩthiĩ na mbere marĩ hamwe. ");
INSERT INTO kik_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Maakinya handũ harĩa Ngai aamwĩrĩte-rĩ, Iburahĩmu agĩaka kĩgongona ho na akĩara ngũ igũrũ rĩakĩo. Agĩcooka akĩoha mũriũ wake Isaaka na akĩmũkomia kĩgongona-inĩ kĩu igũrũ rĩa ngũ. ");
INSERT INTO kik_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ningĩ akĩoya kahiũ, agĩtambũrũkia guoko gwake, oorage mũriũ. ");
INSERT INTO kik_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","No mũraika wa Jehova akĩmwĩta kuuma igũrũ, akiuga atĩrĩ, “Iburahĩmu! Iburahĩmu!” Nake Iburahĩmu agĩcookia atĩrĩ, “Niĩ ũyũ haha.” ");
INSERT INTO kik_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Akĩmwĩra atĩrĩ, “Ndũkahutie kĩmwana kĩu na guoko gwaku, na ndũgagĩĩke ũndũ o na ũrĩkũ. Rĩu nĩndamenya atĩ nĩwĩtigĩrĩte Ngai, tondũ ndũnarega kũruta mũrũguo, o we mũrũguo waku wa mũmwe, arĩ igongona.” ");
INSERT INTO kik_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Nake Iburahĩmu agĩtiira maitho, na hau kĩhinga-inĩ akĩona ndũrũme ĩnyiitĩtwo hĩa nĩ mĩrita. Agĩthiĩ ho, akĩoya ndũrũme ĩyo na akĩmĩruta ĩrĩ igongona rĩa njino handũ ha mũriũ. ");
INSERT INTO kik_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Nĩ ũndũ ũcio Iburahĩmu agĩĩta handũ hau Jehova-Nĩarĩheanaga. Na nginya ũmũthĩ kuugagwo atĩrĩ, “Kĩrĩma-inĩ kĩa Jehova-rĩ, nĩarĩtũheaga.” ");
INSERT INTO kik_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nake mũraika wa Jehova arĩ igũrũ, agĩĩta Iburahĩmu hĩndĩ ya keerĩ, ");
INSERT INTO kik_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","akĩmwĩra atĩrĩ, “Jehova ekuuga ũũ: Nĩndĩhĩtĩte na niĩ mwene, atĩ tondũ nĩwĩkĩte ũndũ ũyũ na ndũnarega kũndutĩra mũrũguo, o mũrũguo waku wa mũmwe-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ti-itherũ nĩngakũrathima na ndũme njiaro ciaku cingĩhe ta njata cia matu-inĩ na ta mũthanga ũrĩa ũrĩ hũgũrũrũ-inĩ cia iria. Njiaro ciaku nĩ ikegwatĩra matũũra marĩa manene ma thũ ciacio, ");
INSERT INTO kik_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","na nĩ ũndũ wa rũciaro rwaku, ndũrĩrĩ ciothe cia thĩ nĩikarathimwo, tondũ wee nĩũnjathĩkĩire.” ");
INSERT INTO kik_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nake Iburahĩmu agĩcookerera ndungata ciake, magĩthiĩ hamwe marorete Birishiba. Nake Iburahĩmu agĩtũũra kũu Birishiba. ");
INSERT INTO kik_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Thuutha wa maũndũ macio Iburahĩmu agĩkinyĩrwo nĩ ũhoro, akĩĩrwo atĩrĩ, “Milika o nake nĩagĩĩte na ciana; nĩaciarĩire mũrũ-wa-nyũkwa Nahoru ciana: ");
INSERT INTO kik_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uzu nĩwe wa irigithathi, na mũrũ wa nyina nĩ Buzu, na Kemueli (ithe wa Aramu), ");
INSERT INTO kik_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","na Kesedu, na Hazo, na Pilidashu, na Jidilafu, na Bethueli.” ");
INSERT INTO kik_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethueli nĩwe watuĩkire ithe wa Rebeka. Acio nĩo ariũ arĩa anana Milika aaciarĩire Nahoru, mũrũ wa nyina na Iburahĩmu. ");
INSERT INTO kik_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Thuriya yake, ĩrĩa yetagwo Reuma, o nayo yarĩ na ariũ ake, nĩo Teba, na Gahamu, na Tahashu na Maaka. ");
INSERT INTO kik_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara aatũũrire muoyo agĩkinyia mĩaka igana rĩmwe na mĩrongo ĩĩrĩ na mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Nake aakuĩrĩire Kiriathu-Ariba (na nokuo Hebironi), bũrũri-inĩ wa Kaanani; nake Iburahĩmu agĩthiĩ, agĩcakaĩra Sara na akĩmũrĩrĩra. ");
INSERT INTO kik_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ningĩ Iburahĩmu agĩũkĩra akiuma hau mwĩrĩ wa mũtumia wake warĩ, agĩthiĩ akĩarĩria Ahiti akĩmeera atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Niĩ ndĩ mũgeni na mũgendi gũkũ kwanyu. Nyenderiai handũ gũkũ ha gũthikana nĩgeetha hote gũthika mũtumia wakwa ũrĩa ũkuĩte.” ");
INSERT INTO kik_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Nao Ahiti magĩcookeria Iburahĩmu atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mũthuuri ũyũ, ta tũthikĩrĩrie. Wee ũrĩ mũthamaki ũrĩ hinya gatagatĩ-inĩ gaitũ. Thika mũtumia waku mbĩrĩra-inĩ ĩmwe ya iria njega ciitũ. Gũtirĩ mũndũ witũ ũngĩkũgiria mbĩrĩra ya gũthika mũtumia waku.” ");
INSERT INTO kik_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Iburahĩmu agĩũkĩra akĩinamĩrĩra mbere ya Ahiti, andũ acio ene bũrũri. ");
INSERT INTO kik_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Akĩmeera atĩrĩ, “Angĩkorwo nĩmwĩtĩkĩrĩte thike mũtumia wakwa-rĩ, gĩĩthikĩrĩriei, na mũthaithanĩrĩre kũrĩ Efironi mũrũ wa Zoharu, ");
INSERT INTO kik_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nĩguo anyenderie ngurunga ya Makipela, ĩrĩa yake ĩrĩ mũthia-inĩ wa gĩthaka gĩake. Mũũriei anyenderie na thogora ũrĩa ũmĩigana, ĩtuĩke handũ hakwa ha gũthikana gũkũ kwanyu.” ");
INSERT INTO kik_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Nake Efironi ũcio Mũhiti aikarĩte thĩ o hau gatagatĩ-inĩ ka andũ arĩa angĩ; tondũ ũcio agĩcookeria Iburahĩmu akĩiguagwo nĩ Ahiti othe arĩa mookĩte kĩhingo-inĩ gĩa itũũra rĩu rĩake. ");
INSERT INTO kik_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Akĩmwĩra atĩrĩ, “Aca, mwathi wakwa, thikĩrĩria; nĩndakũhe gĩthaka kĩu, na nĩndakũhe ngurunga ĩyo ĩrĩ thĩinĩ wakĩo. Ndakũhe andũ akwa makĩonaga. Thika mũtumia waku.” ");
INSERT INTO kik_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","O rĩngĩ Iburahĩmu akĩinamĩrĩra mbere ya andũ acio ene bũrũri, ");
INSERT INTO kik_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","na akĩarĩria Efironi andũ acio makĩiguaga, akĩmwĩra atĩrĩ, “Ĩtĩkĩra gũũthikĩrĩria. Nĩngũrĩha thogora wa gĩthaka kĩu. Amũkĩra mbeeca kuuma kũrĩ niĩ, nĩgeetha hote gũthika mũtumia wakwa kuo.” ");
INSERT INTO kik_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efironi agĩcookeria Iburahĩmu atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ta thikĩrĩria, mwathi wakwa; gĩthaka kĩu kĩngiuma cekeri magana mana ma betha, no rĩrĩ, kĩu nĩ kĩĩ gatagatĩ gaku na niĩ? Thiĩ ũthike mũtumia waku.” ");
INSERT INTO kik_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Iburahĩmu agĩĩtĩkĩra thogora wa Efironi na akĩmũthimĩra betha iria aagwetete andũ a Ahiti othe makĩiguaga; cekeri magana mana cia betha cia mũigana wa gĩthimo kĩa onjorithia. ");
INSERT INTO kik_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Nĩ ũndũ ũcio, gĩthaka kĩa Efironi kĩu kĩarĩ Makipela hakuhĩ na Mamure-gĩthaka na ngurunga ĩyo, na mĩtĩ yothe ĩrĩa yarĩ mĩhaka-inĩ ya gĩthaka kĩu ikĩgarũrĩrwo ");
INSERT INTO kik_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Iburahĩmu mbere ya Ahiti othe arĩa mookĩte kĩhingo-inĩ gĩa itũũra rĩu inene. ");
INSERT INTO kik_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Thuutha wa ũguo, Iburahĩmu agĩthika Sara mũtumia wake ngurunga-inĩ ĩyo yarĩ gĩthaka-inĩ kĩa Makipela hakuhĩ na Mamure (ĩrĩa ĩrĩ Hebironi), bũrũri-inĩ wa Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Nĩ ũndũ ũcio gĩthaka kĩu na ngurunga ĩyo yarĩ kuo ikĩgarũrĩrwo Iburahĩmu nĩ Ahiti irĩ handũ ha gũthikanaga. ");
INSERT INTO kik_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Na rĩrĩ, Iburahĩmu aarĩ mũkũrũ na agatindĩka mĩaka. Nake Jehova nĩamũrathimĩte maũndũ-inĩ make mothe. ");
INSERT INTO kik_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Nake akĩĩra ndungata ĩrĩa yarĩ nene mũciĩ-inĩ wake, o ĩrĩa yarũgamĩrĩire indo ciothe iria aarĩ nacio atĩrĩ, “Ta iga guoko gwaku rungu rwa kĩero gĩakwa. ");
INSERT INTO kik_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nĩngwenda wĩhĩte na rĩĩtwa rĩa Jehova, o we Ngai wa igũrũ na Ngai wa thĩ, atĩ ndũgethera mũrũ wakwa mũtumia kuuma kũrĩ airĩtu a Akaanani aya ndũũraga thĩinĩ wao, ");
INSERT INTO kik_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","no nĩũgathiĩ bũrũri-inĩ wakwa na kũrĩ andũ a nyũmba iitũ, na wethere mũrũ wakwa Isaaka mũtumia kũu.” ");
INSERT INTO kik_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ndungata ĩyo ĩkĩmũũria atĩrĩ, “Ĩ mũndũ-wa-nja ũcio angĩkaarega gũũka na niĩ bũrũri-inĩ ũyũ? Ngaacookia mũrũguo bũrũri ũrĩa woimire?” ");
INSERT INTO kik_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iburahĩmu akĩmwĩra atĩrĩ, “Menyerera, ndũkanacookie mũrũ wakwa kũu! ");
INSERT INTO kik_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jehova, o we Ngai wa igũrũ ũrĩa wandutire kuuma nyũmba ya baba na kuuma bũrũri ũrĩa ndaciarĩirwo na akĩnjarĩria na akĩnjĩĩra na mwĩhĩtwa atĩrĩ, ‘Rũciaro rwaku nĩngarũhe bũrũri ũyũ’ we nĩwe ũgaatũma mũraika wake mbere yaku nĩguo ũkoonera mũrũ wakwa mũtumia kuuma kuo. ");
INSERT INTO kik_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mũndũ-wa-nja ũcio angĩkaarega gũũka nawe-rĩ, ndũkoohwo nĩ mwĩhĩtwa ũyũ wakwa; no ndũkanacookie mũrũ wakwa kũu.” ");
INSERT INTO kik_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Nĩ ũndũ ũcio ndungata ĩyo ĩkĩiga guoko kwayo rungu rwa kĩero kĩa Iburahĩmu ũcio mwathi wayo, na ĩkĩĩhĩta na mwĩhĩtwa harĩ we kũringana na ũhoro ũcio. ");
INSERT INTO kik_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ndungata ĩyo ĩgĩcooka ĩkĩoya ngamĩĩra ikũmi cia mwathi wayo na ĩkiumagara ĩkuĩte mĩthemba yothe ya indo njega kuuma kũrĩ mwathi wayo. Ĩgĩthiĩ ĩgĩkinya itũũra rĩrĩa Nahoru aatũũraga mwena wa gathigathini-ithũĩro wa Mesopotamia. ");
INSERT INTO kik_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Nayo ĩgĩtũma ngamĩĩra ikome nja ya itũũra hakuhĩ na gĩthima kĩa maaĩ; kwarĩ kĩhwaĩ-inĩ rĩrĩa andũ-a-nja maathiiaga gũtaha maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ĩgĩcooka ĩkĩhooya, ĩkiuga atĩrĩ, “Wee Jehova, Ngai wa Iburahĩmu mwathi wakwa, tũma ngaacĩre ũmũthĩ na ũtuge mwathi wakwa Iburahĩmu. ");
INSERT INTO kik_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Rora, ndũgamĩte haha gĩthima-inĩ kĩa maaĩ, nao airĩtu a ene itũũra nĩ maroka gũtaha maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kũrotuĩka atĩrĩ, atĩ rĩrĩa ndĩrĩĩra mũirĩtu atĩrĩ, ‘Ndakũhooya, he ndigithũ yaku nyue maaĩ,’ nake oige atĩrĩ, ‘Nyua na nĩngũtahĩra o na ngamĩĩra ciaku,’ reke ũcio atuĩke nĩwe ũthuurĩire ndungata yaku Isaaka. Na ũndũ ũcio ũtũme niĩ menye atĩ nĩũtugĩte mwathi wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ĩtanarĩkia kũhooya-rĩ, Rebeka agĩũka akuuĩte ndigithũ kĩande-inĩ. Aarĩ mũirĩtu wa Bethueli mũrũ wa Milika, ũrĩa warĩ mũtumia wa Nahoru mũrũ wa nyina na Iburahĩmu. ");
INSERT INTO kik_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Mũirĩtu ũcio aarĩ mũthaka mũno, mũirĩtu gathirange; gũtirĩ mũndũ mũrũme wakomete nake. Agĩikũrũka gĩthima-inĩ kĩa maaĩ, akĩiyũria ndigithũ yake maaĩ, agĩcooka akĩambata rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nayo ndungata ĩyo ĩkĩhiũha ĩkamũtũnge, na ĩkĩmwĩra atĩrĩ, “Ndagũthaitha, he tũũĩ tũnini twa kũnyua kuuma ndigithũ-inĩ yaku.” ");
INSERT INTO kik_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nake agĩcookia atĩrĩ, “Mwathi wakwa, nyua,” nake akĩruta ndigithũ mũtwe na ihenya, akĩmĩnyiita na moko, na akĩmũhe maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Na aarĩkia kũmũhe maaĩ ma kũnyua, agĩcooka akiuga atĩrĩ, “Nĩngũtahĩra ngamĩĩra ciaku, o nacio o nginya ciiganie kũnyua.” ");
INSERT INTO kik_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Agĩkĩonoreria maaĩ marĩa maarĩ ndigithũ yake mũharatĩ-inĩ na ihenya, agĩcooka agĩtengʼera gĩthima-inĩ gũtaha maaĩ mangĩ, agĩtaha ma kũigana ngamĩĩra ciake ciothe. ");
INSERT INTO kik_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mũndũ ũcio akĩmwĩrorera atekwaria, nĩguo amenye kana Jehova nĩagacĩrithĩtie rũgendo rwake kana ndaarũgacĩrithĩtie. ");
INSERT INTO kik_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Rĩrĩa ngamĩĩra ciarĩkirie kũnyua maaĩ-rĩ, mũndũ ũcio akĩruta gĩcũhĩ kĩa iniũrũ gĩa thahabu kĩa ũritũ wa nuthu cekeri, na bangiri igĩrĩ cia thahabu cia ũritũ wa cekeri ikũmi, akĩmwĩkĩra. ");
INSERT INTO kik_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Agĩcooka akĩmũũria atĩrĩ, “Wee ũrĩ mwarĩ wa ũ? Ndagũthaitha ta njĩĩra atĩrĩ, mũciĩ gwa thoguo-rĩ, he handũ tũngĩrarĩrĩra?” ");
INSERT INTO kik_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Nake akĩmũcookeria atĩrĩ, “Niĩ ndĩ mwarĩ wa Bethueli, mũriũ ũrĩa Milika aaciarĩire Nahoru.” ");
INSERT INTO kik_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ningĩ akĩmwĩra atĩrĩ, “Tũrĩ na riya na nyeki nyingĩ, o na handũ wee ũngĩrarĩrĩra.” ");
INSERT INTO kik_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mũndũ ũcio akĩinamĩrĩra thĩ, akĩhooya Jehova, ");
INSERT INTO kik_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","akiuga atĩrĩ, “Jehova arogaathwo, o we Ngai wa Iburahĩmu mwathi wakwa, o ũcio ũtatigĩte kuonania ũtugi na wĩhokeku wake kũrĩ mwathi wakwa. Hakwa-rĩ, Jehova nĩandongoretie rũgendo-inĩ, akanginyia kwa andũ a nyũmba ya mwathi wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nake mũirĩtu ũcio agĩtengʼera, agĩthiĩ akĩhe andũ a nyũmba ya nyina ndeto icio. ");
INSERT INTO kik_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Na rĩrĩ, Rebeka aarĩ na mũrũ wa nyina wetagwo Labani, nake akiumagara ahiũhĩte, agĩthiĩ kũrĩ mũndũ ũcio hau gĩthima-inĩ kĩa maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Rĩrĩa onire gĩcũhĩ kĩu kĩa iniũrũ na bangiri irĩ moko-inĩ ma mwarĩ wa nyina, na aigua Rebeka akiuga ũrĩa mũndũ ũcio aamwĩrĩte-rĩ, agĩthiĩ kũrĩ mũndũ ũcio, akĩmũkora arũgamĩte harĩ ngamĩĩra ciake hakuhĩ na gĩthima kĩa maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Akĩmwĩra atĩrĩ, “Ũka tũthiĩ mũciĩ, wee ũrathimĩtwo nĩ Jehova. Ũrũgamĩte haha nja nĩkĩ? Nĩhaarĩirie nyũmba yaku na handũ ha ngamĩĩra.” ");
INSERT INTO kik_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nĩ ũndũ ũcio mũndũ ũcio agĩtoonya nyũmba, nacio ngamĩĩra ikĩaũrwo mĩrigo. Ngamĩĩra ikĩreherwo riya na nyeki, nake mũndũ ũcio na andũ arĩa aarĩ nao makĩreherwo maaĩ ma gwĩthamba magũrũ. ");
INSERT INTO kik_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ningĩ akĩreherwo irio, nowe akiuga atĩrĩ, “Niĩ ndingĩrĩa, itambĩte kũmwĩra ũndũ ũrĩa ũndehete gũkũ.” Nake Labani akĩmwĩra atĩrĩ, “Gĩtwĩre.” ");
INSERT INTO kik_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Nake agĩkiuga atĩrĩ, “Niĩ ndĩ ndungata ya Iburahĩmu.” ");
INSERT INTO kik_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","“Jehova nĩarathimĩte mwathi wakwa mũno, na nĩ atongete mũno. Nĩamũheete ngʼondu na ngʼombe, betha na thahabu, ndungata cia arũme na cia andũ-a-nja, na ngamĩĩra o na ndigiri. ");
INSERT INTO kik_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nake Sara mũtumia wa mwathi wakwa nĩamũciarĩire kĩmwana arĩ o mũkũrũ, nake nĩakĩheete indo ciake ciothe. ");
INSERT INTO kik_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nake mwathi wakwa agĩtũma ndĩĩhĩte akĩnjĩĩra atĩrĩ, ‘Ndũkanethere mũriũ wakwa mũtumia kuuma kũrĩ airĩtu a Akaanani, a gũkũ bũrũri ũyũ ndũũraga, ");
INSERT INTO kik_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","no ũthiĩ kũrĩ nyũmba ya baba na kũrĩ mũhĩrĩga wakwa, na ũrutĩre mũriũ wakwa mũtumia kuo.’ ");
INSERT INTO kik_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ningĩ ngĩũria mwathi wakwa atĩrĩ, ‘Ĩ mũndũ-wa-nja ũcio angĩrega gũũka na niĩ?’ ");
INSERT INTO kik_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Nake akĩnjookeria atĩrĩ, ‘Jehova ũrĩa ndũire thiiaga mbere yake, nĩagatũma mũraika wake athiĩ nawe, na atũme rũgendo rwaku rũgaacĩre, nĩgeetha ũkaarutĩra mũriũ wakwa mũtumia kuuma kũrĩ mũhĩrĩga wakwa na kuuma kũrĩ andũ a nyũmba ya baba. ");
INSERT INTO kik_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ningĩ wathiĩ kũrĩ mũhĩrĩga wakwa-rĩ, nĩũkohorwo kuuma kũrĩ mwĩhĩtwa wakwa; o na mangĩkaarega kũmũnengerana kũrĩ we, nĩũkohorwo kuuma kũrĩ mwĩhĩtwa ũcio wakwa.’ ” ");
INSERT INTO kik_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Agĩthiĩ na mbere, akiuga atĩrĩ, “Ũmũthĩ rĩrĩa nginyire gĩthima-inĩ kĩa maaĩ, njugire atĩrĩ, ‘Wee Jehova Ngai wa Iburahĩmu mwathi wakwa, ũngĩenda, ndagũthaitha, gaacĩrithia rũgendo rũrũ njũkĩte. ");
INSERT INTO kik_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ta kĩone, nũngiĩ haha gĩthima-inĩ kĩa maaĩ; mũirĩtu angĩũka gũtaha maaĩ na niĩ ndĩmwĩre atĩrĩ, “Ĩtĩkĩra nyue tũũĩ tũnini kuuma ndigithũ-inĩ yaku,” ");
INSERT INTO kik_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","nake angĩnjĩĩra atĩrĩ, “Nyua na nĩngũtahĩra ngamĩĩra ciaku o nacio,” nĩagĩtuĩke nĩwe mũndũ-wa-nja ũrĩa Jehova athuurĩire mũriũ wa mwathi wakwa.’ ");
INSERT INTO kik_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Itanarĩkia kũhooya ũguo na ngoro-rĩ, Rebeka oka arĩ na ndigithũ yake kĩande. Nake aikũrũka gĩthima-inĩ kĩa maaĩ, aataha maaĩ na niĩ ndamwĩra atĩrĩ, ‘Ndagũthaitha he maaĩ nyue.’ ");
INSERT INTO kik_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Aaruta ndigithũ yake kĩande o naihenya anjĩĩra atĩrĩ, ‘Nyua, na nĩngũnyuithia o na ngamĩĩra ciaku.’ Nĩ ũndũ ũcio ndanyua maaĩ na ahe ngamĩĩra o nacio. ");
INSERT INTO kik_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Na niĩ ndamũũria atĩrĩ, ‘Ũrĩ mwarĩ wa ũ?’ “Nake anjookeria atĩrĩ, ‘Ndĩ mwarĩ wa Bethueli mũrũ wa Nahoru, ũrĩa Milika aamũciarĩire.’ “Na niĩ ndakĩmwĩkĩra gĩcũhĩ iniũrũ, na bangiri moko, ");
INSERT INTO kik_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ndacooka ndainamĩrĩra ndahooya Jehova. Ndagatha Jehova, o we Ngai wa Iburahĩmu mwathi wakwa, ũrĩa ũndongoretie na njĩra ĩrĩa njagĩrĩru nyonere mũrũ wa mwathi wakwa mwarĩ wa mũriũ wa mũrũ wa nyina nake. ");
INSERT INTO kik_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Na rĩrĩ, angĩkorwo nĩ mũkuonania ũtugi na wĩhokeku kũrĩ mwathi wakwa, njĩĩrai; na angĩkorwo tiguo, mũnjĩĩre nĩgeetha na niĩ menye na kũrĩa ngũrora.” ");
INSERT INTO kik_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labani na Bethueli magĩcookia atĩrĩ, “Ũndũ ũyũ uumĩte kũrĩ Jehova; ithuĩ tũngĩgĩkwĩra atĩa? ");
INSERT INTO kik_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka nĩwe ũyũ; muoe mũthiĩ agatuĩke mũtumia wa mũriũ wa mwathi waku, o ta ũrĩa Jehova oigĩte.” ");
INSERT INTO kik_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Rĩrĩa ndungata ya Iburahĩmu yaiguire ũrĩa moigire, ĩkĩinamĩrĩra, ĩgĩturumithia ũthiũ wayo thĩ mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ningĩ ndungata ĩyo ĩkĩruta thahabu, na mathaga ma betha na nguo, na ĩgĩcihe Rebeka; ĩgĩcooka ĩkĩhe Labani mũrũ wa nyina, o na nyina, iheo cia goro. ");
INSERT INTO kik_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ndungata ĩyo na andũ arĩa yarĩ nao makĩrĩa na makĩnyua, na makĩraara kũu ũtukũ ũcio. Na rĩrĩa mookĩrire mũthenya ũyũ ũngĩ rũciinĩ tene, ĩkiuga atĩrĩ, “Rekei ndĩthiĩre kũrĩ mwathi wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","No Labani mũrũ wa nyina na mũirĩtu, o na nyina, makiuga atĩrĩ, “Reke mũirĩtu ũyũ aikare na ithuĩ ta matukũ ikũmi; mũcooke mũthiĩ.” ");
INSERT INTO kik_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","No yo ĩkĩmeera atĩrĩ, “Tigai kũngiria thiĩ, kuona atĩ Jehova nĩagacĩrithĩtie rũgendo rwakwa. Rekei ndĩthiĩre kũrĩ mwathi wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Nao makiuga atĩrĩ, “Rekei twĩte mũirĩtu tũmũũrie ũhoro ũcio.” ");
INSERT INTO kik_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Nĩ ũndũ ũcio magĩĩta Rebeka, makĩmũũria atĩrĩ, “Nĩũgũthiĩ na mũndũ ũyũ?” Nake akiuga atĩrĩ, “Nĩngũthiĩ.” ");
INSERT INTO kik_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Nĩ ũndũ ũcio magĩtĩkĩria Rebeka mwarĩ wa nyina ũcio ethiĩre, hamwe na mũmũrori, na ndungata ya Iburahĩmu na andũ ake. ");
INSERT INTO kik_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Nao magĩkĩrathima Rebeka makĩmwĩra atĩrĩ, “Mwarĩ wa maitũ, ũroingĩha ũtuĩke nyina wa ngiri maita ngiri, naruo rũciaro rwaku rũroĩgwatĩra ihingo cia thũ ciao.” ");
INSERT INTO kik_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Nake Rebeka na ndungata ciake, cia andũ-a-nja, makĩĩhaarĩria na makĩhaica ngamĩĩra, na magĩthiĩ na mũndũ ũcio. Nĩ ũndũ ũcio ndungata ĩyo ĩkĩoya Rebeka ĩgĩĩthiĩra. ");
INSERT INTO kik_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Na rĩrĩ, Isaaka nĩoimĩte Biri-Lahai-Roi, nĩ ũndũ aatũũraga Negevu. ");
INSERT INTO kik_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Hwaĩ-inĩ ũmwe-rĩ, nĩathiire na kũu mũgũnda-inĩ agecũũranganie, na aatiira maitho, akĩona ngamĩĩra ciũkĩte. ");
INSERT INTO kik_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","O nake Rebeka agĩtiira maitho akĩona Isaaka. Akiuma ngamĩĩra igũrũ, ");
INSERT INTO kik_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","na akĩũria ndungata ĩyo atĩrĩ, “Mũndũ ũrĩa ũrĩ kũũrĩa mũgũnda ũroka gũtũtũnga nũũ?” Ndungata ĩyo ĩgĩcookia atĩrĩ, “Nĩ mwathi wakwa.” Nake Rebeka akĩoya taama wake akĩĩhumbĩra. ");
INSERT INTO kik_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nayo ndungata ĩyo ĩkĩĩra Isaaka ũrĩa wothe yekĩte. ");
INSERT INTO kik_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Nake Isaaka agĩtoonyia Rebeka hema-inĩ ya nyina Sara, akĩmũhikia. Nĩ ũndũ ũcio agĩtuĩka mũtumia wake, na akĩmwenda; nake Isaaka akĩhoorerio ihooru rĩa gĩkuũ kĩa nyina. ");
INSERT INTO kik_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Thuutha ũcio Iburahĩmu nĩ aahikirie mũtumia ũngĩ, wetagwo Ketura. ");
INSERT INTO kik_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nake akĩmũciarĩra ariũ atandatũ, na nĩo Zimirani, na Jokishani, na Medani, na Midiani, na Ishibaku na Shua. ");
INSERT INTO kik_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokishani nĩwe warĩ ithe wa Sheba na Dedani; nacio njiaro cia Dedani nĩcio ciarĩ Aashuri, na Aletushi na Aleumi. ");
INSERT INTO kik_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Nao ariũ a Midiani maarĩ Efa, na Eferi, na Hanoku, na Abida na Elidaha. Acio othe maarĩ njiaro cia Ketura. ");
INSERT INTO kik_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Nake Iburahĩmu akĩgaĩra Isaaka indo ciothe iria aarĩ nacio. ");
INSERT INTO kik_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","No arĩ o muoyo-rĩ, akĩhe ariũ a thuriya ciake iheo, agĩcooka akĩmeheranĩria na mũriũ Isaaka magĩthiĩ na kũu bũrũri wa irathĩro. ");
INSERT INTO kik_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Mĩaka yothe ĩrĩa Iburahĩmu aatũũrire muoyo yarĩ mĩaka igana rĩmwe na mĩrongo mũgwanja na ĩtano. ");
INSERT INTO kik_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Iburahĩmu agĩtuĩkana na agĩkua arĩ mũthuuri mũniaru, arĩ mũkũrũ na akaingĩhia mĩaka, agĩthikwo hamwe na andũ ao arĩa maakuĩte. ");
INSERT INTO kik_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Nao ariũ ake, Isaaka na Ishumaeli, makĩmũthika ngurunga-inĩ ya Makipela hakuhĩ na Mamure, gĩthaka-inĩ kĩa Efironi mũrũ wa Zoharu ũrĩa Mũhiti, ");
INSERT INTO kik_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","gĩthaka kĩrĩa Iburahĩmu aagũrĩte kuuma kũrĩ Ahiti. Hau nĩho Iburahĩmu aathikirwo hamwe na Sara mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Thuutha wa gĩkuũ kĩa Iburahĩmu-rĩ, Ngai nĩarathimire mũriũ Isaaka ũrĩa watũũraga hakuhĩ na Biri-Lahai-Roi. ");
INSERT INTO kik_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ũyũ nĩguo ũhoro wa Ishumaeli mũrũ wa Iburahĩmu, ũrĩa waciarĩirwo Iburahĩmu nĩ Hagari ũrĩa Mũmisiri, ndungata ya Sara. ");
INSERT INTO kik_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Maya nĩmo marĩĩtwa ma ariũ a Ishumaeli, maandĩkĩtwo kũringana na ũrĩa maarũmanĩrĩire gũciarwo: Irigithathi rĩa Ishumaeli rĩarĩ Nebaiothu, rĩkarũmĩrĩrwo nĩ Kedari, na Adubeeli, na Mibisamu, ");
INSERT INTO kik_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","na Mishima, na Duma, na Masa, ");
INSERT INTO kik_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","na Hadadi, na Tema, na Jeturu, na Nafishu, na Kedema. ");
INSERT INTO kik_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Acio nĩo maarĩ ariũ a Ishumaeli, na macio nĩmo marĩĩtwa ma aathani ikũmi na eerĩ a mĩhĩrĩga yao kũringana na kũrĩa maatũũraga na kambĩ ciao. ");
INSERT INTO kik_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Mĩaka yothe ĩrĩa Ishumaeli aatũũrire muoyo yarĩ mĩaka igana rĩmwe na mĩrongo ĩtatũ na mũgwanja. Agĩcooka agĩtuĩkana agĩkua, na agĩthikwo hamwe na andũ ao arĩa maakuĩte. ");
INSERT INTO kik_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Njiaro cia Ishumaeli igĩtũũra kuuma Havila nginya Shuri, gũkuhĩ na mũhaka wa Misiri werekeire bũrũri wa Ashuri. Nao magĩtũũra na rũmena na ariũ arĩa angĩ othe a ithe wao. ");
INSERT INTO kik_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ũyũ nĩguo ũhoro wa Isaaka mũrũ wa Iburahĩmu. Iburahĩmu nĩwe waciarire Isaaka, ");
INSERT INTO kik_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","nake Isaaka aarĩ na mĩaka mĩrongo ĩna rĩrĩa aahikirie Rebeka, mwarĩ wa Bethueli ũrĩa Mũsuriata wa Padani-Aramu, na aarĩ mwarĩ wa nyina na Labani ũrĩa Mũsuriata. ");
INSERT INTO kik_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaaka agĩthaitha Jehova nĩ ũndũ wa mũtumia wake tondũ aarĩ thaata. Nake Jehova akĩigua mahooya make, na Rebeka mũtumia wake akĩgĩa nda. ");
INSERT INTO kik_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Natuo twana tũu tũkĩgianĩra kũu nda yake, nake akĩĩyũria atĩrĩ, “Ũndũ ũyũ ũrekĩka kũrĩ niĩ nĩkĩ?” Nĩ ũndũ ũcio agĩthiĩ gũtuĩria ũhoro harĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Nake Jehova akĩmwĩra atĩrĩ, “Ndũrĩrĩ igĩrĩ irĩ nda yaku, na andũ a mĩthemba ĩĩrĩ kuuma nda yaku nĩmagatigithanio; gĩthemba kĩmwe nĩgĩgakĩria kĩrĩa kĩngĩ hinya, na ũrĩa mũkũrũ nĩagatungatĩra ũrĩa mũnini.” ");
INSERT INTO kik_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Na rĩrĩa ihinda rĩake rĩakinyire rĩa gũciara, agĩkorwo nĩ tũhĩĩ twa mahatha aarĩ natuo nda. ");
INSERT INTO kik_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Karĩa kaambire gũciarwo kaarĩ gatune na mwĩrĩ wako wothe wahaanaga ta nguo ya maguoya; tondũ ũcio magĩgatua Esaũ. ");
INSERT INTO kik_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Thuutha ũcio mũrũ wa nyina agĩciarwo guoko gwake kũnyiitĩte ndiira ya Esaũ; tondũ ũcio agĩtuuo Jakubu. Isaaka aarĩ na mĩaka mĩrongo ĩtandatũ rĩrĩa Rebeka aaciarire twana tũu. ");
INSERT INTO kik_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Natuo tũmwana tũu tũgĩkũra, nake Esaũ agĩtuĩka mũguĩmi mũũgĩ, mũndũ wa werũ, no Jakubu aarĩ mũndũ mũhooreri, waikaraga hakuhĩ na mũciĩ. ");
INSERT INTO kik_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaaka eendete Esaũ tondũ nĩ eendete nyama cia ũguĩmi, no Rebeka eendete Jakubu. ");
INSERT INTO kik_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Mũthenya ũmwe Jakubu nĩarugaga gĩtoero kĩa ndengũ ndune, nake Esaũ agĩũka kuuma werũ-inĩ ahũtiĩ mũno. ");
INSERT INTO kik_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Akĩĩra Jakubu atĩrĩ, “Ta he gĩtoero kĩu ũraruga! Ndĩ mũhũtu mũno!” (Nĩkĩo gĩatũmire acooke gwĩtwo Edomu.) ");
INSERT INTO kik_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jakubu akĩmũcookeria atĩrĩ, “Amba ũnyenderie ũrigithathi waku!” ");
INSERT INTO kik_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Nake Esaũ akiuga atĩrĩ, “Ngirie gũkua, ũrigithathi ũyũ ũkaangʼuna na kĩ?” ");
INSERT INTO kik_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","No Jakubu akĩmwĩra atĩrĩ, “Amba wĩhĩte kũrĩ niĩ.” Nake akĩĩhĩta na mwĩhĩtwa, akĩenderia Jakubu ũrigithathi wake. ");
INSERT INTO kik_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Nake Jakubu akĩhe Esaũ mũgate na gĩtoero kĩa ndengũ. Nake akĩrĩa na akĩnyua, agĩcooka agĩũkĩra agĩĩthiĩra. Tondũ ũcio Esaũ akĩnyarara ũrigithathi wake. ");
INSERT INTO kik_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Na rĩrĩ, nĩ kwagĩire ngʼaragu ĩngĩ bũrũri-inĩ ũcio, tiga ĩrĩa ya mbere ya hĩndĩ ya Iburahĩmu, nake Isaaka agĩthiĩ Gerari kũrĩ Abimeleku mũthamaki wa Afilisti. ");
INSERT INTO kik_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Jehova akiumĩrĩra Isaaka, akĩmwĩra atĩrĩ, “Ndũgaikũrũke ũthiĩ Misiri; tũũra bũrũri o ũrĩa ndĩrĩkwĩra ũtũũre. ");
INSERT INTO kik_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ikara bũrũri-inĩ ũyũ kwa ihinda, na nĩngũkorwo hamwe nawe na nĩngũkũrathima. Nĩgũkorwo nĩwe na njiaro ciaku ngũhe mabũrũri maya mothe na hingie mwĩhĩtwa ũrĩa ndehĩtire kũrĩ thoguo Iburahĩmu. ");
INSERT INTO kik_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nĩngatũma njiaro ciaku cingĩhe ta njata cia matu-inĩ na nĩngamahe mabũrũri maya mothe, na nĩ ũndũ wa rũciaro rwaku, ndũrĩrĩ ciothe cia thĩ nĩikarathimwo, ");
INSERT INTO kik_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","tondũ Iburahĩmu nĩanjathĩkĩire na akĩrũmia ũrĩa ndendaga, akĩrũmĩrĩra maathani makwa, na matuĩro makwa ma kũrũmĩrĩrwo, na mawatho makwa.” ");
INSERT INTO kik_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Nĩ ũndũ ũcio Isaaka agĩikara o kũu Gerari. ");
INSERT INTO kik_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Rĩrĩa andũ a kũu maamũririe ũhoro wa mũtumia wake-rĩ, we akiuga atĩrĩ, “Nĩ mwarĩ wa baba,” tondũ nĩetigĩrire kuuga, “Nĩ mũtumia wakwa.” Eeciiririe atĩrĩ, “Andũ a gũkũ mahota kũnjũraga nĩ ũndũ wa Rebeka, tondũ aarĩ mũthaka.” ");
INSERT INTO kik_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Na thuutha wa Isaaka arĩkĩtie gũikara kũu kahinda karaihu-rĩ, Abimeleku mũthamaki wa Afilisti nĩacũthĩrĩirie nja na ndirica, nake akĩona Isaaka akĩhambata mũtumia wake Rebeka. ");
INSERT INTO kik_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Nĩ ũndũ ũcio Abimeleku agĩtũmanĩra Isaaka, akĩmũũria atĩrĩ, “Ti-itherũ ũyũ nĩ mũtumia waku! Nĩ kĩĩ gĩatũmire uuge atĩ, ‘Ũyũ nĩ mwarĩ wa baba’?” Isaaka akĩmũcookeria atĩrĩ, “Tondũ ndeciiririe ndahota kũũragwo nĩ ũndũ wake.” ");
INSERT INTO kik_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ningĩ Abimeleku akĩmũũria atĩrĩ, “Nĩ atĩa ũguo ũtwĩkĩte? Ĩ mũndũ mũrũme ũmwe wa gũkũ angĩrakorirwo akomete na mũtumia waku, nawe ũgĩtũme tũnyiitwo nĩ ihĩtia?” ");
INSERT INTO kik_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Nĩ ũndũ ũcio Abimeleku akĩruta watho kũrĩ andũ othe, akiuga atĩrĩ, “Mũndũ o na ũrĩkũ ũngĩthĩĩnia mũndũ ũyũ kana mũtumia wake no kũũragwo akooragwo.” ");
INSERT INTO kik_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nake Isaaka akĩhaanda irio bũrũri ũcio, na mwaka o ro ũcio akĩgetha maita igana, tondũ Jehova nĩamũrathimire. ");
INSERT INTO kik_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nake Isaaka agĩtonga, naguo ũtonga wake ũgĩthiĩ o ũkĩingĩhaga o nginya agĩtonga mũno. ");
INSERT INTO kik_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aarĩ na ndũũru nyingĩ cia mbũri na cia ngʼombe, na ndungata nyingĩ, o nginya Afilisti makĩmũiguĩra ũiru. ");
INSERT INTO kik_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tondũ ũcio, ithima iria ciothe ndungata cia ithe cienjete hĩndĩ ya ithe Iburahĩmu-rĩ, Afilisti magĩcithika, magĩciyũria tĩĩri. ");
INSERT INTO kik_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ningĩ Abimeleku akĩĩra Isaaka atĩrĩ, “Ũkĩra ũthiĩ, ũtweherere, tondũ nĩũgĩĩte na hinya mũno gũtũkĩra.” ");
INSERT INTO kik_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Nĩ ũndũ ũcio Isaaka agĩthaama, akĩehera kũu, agĩthiĩ kwamba hema Gĩtuamba-inĩ kĩa Gerari, na agĩtũũra kuo. ");
INSERT INTO kik_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaaka agĩthikũria ithima iria cienjetwo hĩndĩ ya ithe Iburahĩmu, o icio Afilisti maathikĩte thuutha wa Iburahĩmu gũkua, na agĩciĩta marĩĩtwa o marĩa ithe aacihete. ");
INSERT INTO kik_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Na rĩrĩ, ndungata cia Isaaka nĩcienjire kũu gĩtuamba-inĩ na igĩkora gĩthima kĩa maaĩ mega kuo. ");
INSERT INTO kik_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","No rĩrĩ, arĩithi a Gerari makĩnegenania na arĩithi a Isaaka, makĩmeera atĩrĩ, “Maaĩ maya nĩ maitũ!” Nake agĩĩta gĩthima kĩu Eseku, tondũ nĩmakararanirie nake. ");
INSERT INTO kik_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ningĩ ndungata icio ciake ikĩenja gĩthima kĩngĩ, no-o nakĩo makĩnegenanĩria, nake Isaaka agĩgĩĩta Sitina. ");
INSERT INTO kik_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nake agĩthaama kũu, agĩthiĩ akĩenja gĩthima kĩngĩ, na matianegenanirie na mũndũ. Nake agĩgĩĩta Rehobothu, akiuga atĩrĩ, “Rĩu Jehova nĩatũheete ũikaro mũiganu, na nĩtũgũtheeremera bũrũri-inĩ ũyũ.” ");
INSERT INTO kik_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Agĩcooka akiuma kũu, agĩthiĩ Birishiba. ");
INSERT INTO kik_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ũtukũ ũcio aakinyire kũu, Jehova akĩmuumĩrĩra, akĩmwĩra atĩrĩ, “Nĩ niĩ Ngai wa thoguo Iburahĩmu. Ndũkanetigĩre, tondũ ndĩ hamwe nawe; nĩngũkũrathima na nyingĩhie njiaro ciaku nĩ ũndũ wa Iburahĩmu ndungata yakwa.” ");
INSERT INTO kik_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isaaka agĩaka kĩgongona kũu, na agĩkaĩra rĩĩtwa rĩa Jehova. Akĩamba hema yake o kũu, nacio ndungata ciake ikĩenja gĩthima o kuo. ");
INSERT INTO kik_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hĩndĩ ĩyo Abimeleku agĩthiĩ kũrĩ Isaaka oimĩte Gerari, marĩ na Ahuzathu ũrĩa wamũtaaraga, na Fikolu mũnene wa ita ciake. ");
INSERT INTO kik_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaaka akĩmooria atĩrĩ, “Muoka kũrĩ niĩ nĩkĩ, kuona atĩ nĩmwathũũrire na mũkĩnyingata?” ");
INSERT INTO kik_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nao makĩmũcookeria atĩrĩ, “Nĩtuonete hatarĩ nganja atĩ Jehova arĩ hamwe nawe, na nĩ ũndũ ũcio tuoiga atĩrĩ, ‘Nĩ kwagĩrĩire tũgĩe na mwĩhĩtwa wa ũiguano gatagatĩ gaitũ’: ĩĩ, gatagatĩ gaitũ nawe. Reke tũgĩe na kĩrĩkanĩro nawe, ");
INSERT INTO kik_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","atĩ ndũgatwĩka ũũru, o ta ũrĩa o na ithuĩ tũtaagũthĩĩnirie, no hĩndĩ ciothe twagwĩkaga wega, na tũgĩkumagaria ũthiĩ na thayũ. Na rĩu nĩũrathimĩtwo nĩ Jehova.” ");
INSERT INTO kik_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaaka akĩmarugithĩria iruga, nao makĩrĩa na makĩnyua. ");
INSERT INTO kik_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Mũthenya ũyũ ũngĩ, rũciinĩ tene, andũ acio na Isaaka makĩĩhĩtanĩra mwĩhĩtwa mũndũ na ũrĩa ũngĩ. Isaaka agĩcooka akĩmoimagaria, magĩĩthiĩra, makĩmũtiga na thayũ. ");
INSERT INTO kik_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Mũthenya o ro ũcio maathiire, ndungata cia Isaaka igĩũka, ĩkĩmwĩra ũhoro wa gĩthima kĩrĩa cienjete, ikiuga atĩrĩ, “Nĩtwakinyĩra maaĩ!” ");
INSERT INTO kik_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Nake agĩĩta gĩthima kĩu Shiba, na nginya ũmũthĩ itũũra rĩu rĩtũũraga rĩĩtagwo Birishiba. ");
INSERT INTO kik_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaũ aakinyia mĩaka mĩrongo ĩna, akĩhikia Judithi mwarĩ wa Beeri ũrĩa Mũhiti, o na ningĩ akĩhikia Basemathu mwarĩ wa Eloni ũrĩa Mũhiti. ");
INSERT INTO kik_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Nao magĩtuĩka kĩhumo gĩa kĩeha kũrĩ Isaaka na Rebeka. ");
INSERT INTO kik_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Rĩrĩa Isaaka aakũrire na maitho make makĩaga hinya ũndũ atangĩahotire kuona-rĩ, agĩtũmanĩra Esaũ mũriũ wake ũrĩa mũkũrũ, akĩmwĩra atĩrĩ, “Mũrũ wakwa.” Nake Esaũ akĩmũcookeria atĩrĩ, “Niĩ ũyũ haha.” ");
INSERT INTO kik_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaaka akĩmwĩra atĩrĩ, “Rĩu niĩ ndĩ mũkũrũ na ndiũĩ mũthenya ũrĩa ingĩkua. ");
INSERT INTO kik_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Rĩu-rĩ, oya indo ciaku cia ũguĩmi; ũta na mĩguĩ yaku, na uumagare ũthiĩ werũ-inĩ ũkanguĩmĩre nyamũ cia gĩthaka. ");
INSERT INTO kik_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Thondekera irio njega iria nyendete na ũndehere ndĩe, nĩgeetha ngũrathime na kĩrathimo gĩakwa itanakua.” ");
INSERT INTO kik_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Na rĩrĩ, Rebeka agĩkorwo nĩathikĩrĩirie Isaaka akĩhe mũriũ Esaũ ũhoro ũcio. Na rĩrĩa Esaũ aathiire werũ-inĩ kũguĩma nyamũ nĩguo amĩinũkie-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka akĩĩra mũriũ Jakubu atĩrĩ, “Nĩ ndaigua thoguo akĩĩra Esaũ mũrũ wa nyũkwa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ndehere nyamũ ya kũguĩma na ũthondekere irio njega ndĩe, nĩgeetha ngũrathime na kĩrathimo gĩakwa ndĩ mbere ya Jehova itanakua.’ ");
INSERT INTO kik_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Rĩu, wee mũrũ wakwa-rĩ, thikĩrĩria wega na wĩke ũrĩa ngũkwĩra: ");
INSERT INTO kik_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Thiĩ rũũru-inĩ rwa mbũri ũndehere tũũri twĩrĩ twa mbũri tũrĩa twega biũ, nĩguo thondekere thoguo irio njega, o ta ũrĩa endaga ithondekwo. ");
INSERT INTO kik_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ũcooke ũcioe ũcitwarĩre thoguo arĩe nĩgeetha akũrathime na kĩrathimo gĩake atanakua.” ");
INSERT INTO kik_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","No Jakubu akĩĩra nyina Rebeka atĩrĩ, “Esaũ mũrũ wa maitũ nĩ wa mwĩrĩ ũrĩ guoya, na mwĩrĩ wakwa ndũrĩ guoya. ");
INSERT INTO kik_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ĩĩ baba angĩĩhaambata? Ingĩonekana ngĩmũheenia na niĩ ndĩĩreherere kĩrumi handũ ha kĩrathimo.” ");
INSERT INTO kik_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nyina akĩmwĩra atĩrĩ, “Mũrũ wakwa, reke kĩrumi kĩu kĩnjookerere, wee ĩka o ũrĩa ndĩrakwĩra; thiĩ ũndehere tũũri tũu.” ");
INSERT INTO kik_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Nĩ ũndũ ũcio Jakubu agĩthiĩ, akĩgĩĩra tũũri, na agĩtũrehere nyina, nake agĩthondeka irio njega o ta iria ithe eendete. ");
INSERT INTO kik_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ningĩ Rebeka akĩoya nguo iria ciarĩ njega cia Esaũ mũriũ wake ũrĩa mũkũrũ iria aarĩ nacio nyũmba agĩcihumba Jakubu mũriũ wake ũrĩa mũnini. ");
INSERT INTO kik_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Agĩcooka akĩhumbĩra moko make na ngingo kũrĩa gũtaarĩ guoya na njũũa cia tũũri tũu. ");
INSERT INTO kik_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Agĩcooka akĩnengera Jakubu mũriũ wake irio icio ciarĩ njega na mũgate ũrĩa aathondekete. ");
INSERT INTO kik_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Nake Jakubu agĩthiĩ kũrĩ ithe, akiuga atĩrĩ, “Baba.” Nake Isaaka agĩcookia atĩrĩ, “Niĩ ũyũ, mũrũ wakwa; wee nĩwe ũ?” ");
INSERT INTO kik_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakubu akĩĩra ithe atĩrĩ, “Nĩ niĩ Esaũ mũriũ waku wa irigithathi. Njĩkĩte o ta ũrĩa ũnjĩĩrire. Ndagũthaitha wĩtiire ũrĩe nyama imwe cia ũguĩmi wakwa nĩgeetha ũndathime na kĩrathimo gĩaku.” ");
INSERT INTO kik_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Nake Isaaka akĩũria mũriũ atĩrĩ, “Mũrũ wakwa, kaĩ waciona narua atĩa?” Nake akĩmũcookeria atĩrĩ, “Nĩ tondũ Jehova Ngai waku nĩaheire ũhootani.” ");
INSERT INTO kik_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ningĩ Isaaka akĩĩra Jakubu atĩrĩ, “Ta ũka hakuhĩ mũrũ wakwa, nĩguo ngũhambate menye kana ti-itherũ nĩwe Esaũ mũrũ wakwa kana tiguo.” ");
INSERT INTO kik_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Nĩ ũndũ ũcio Jakubu agĩkuhĩrĩria ithe Isaaka, nake akĩmũhambata, akiuga atĩrĩ, “Mũgambo nĩ wa Jakubu, no moko nĩ ma Esaũ.” ");
INSERT INTO kik_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Na ndaigana kũmũkũũrana tondũ moko make maarĩ na guoya ta ma mũrũ wa nyina Esaũ; nĩ ũndũ ũcio akĩmũrathima. ");
INSERT INTO kik_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","O rĩngĩ akĩmũũria atĩrĩ, “Ti-itherũ nĩwe mũrũ wakwa Esaũ?” Nake agĩcookia atĩrĩ, “Ĩĩ nĩ niĩ.” ");
INSERT INTO kik_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Agĩcooka akĩmwĩra atĩrĩ, “Mũrũ wakwa ndehere nyama imwe cia ũguĩmi waku ndĩe nĩgeetha ngũrathime na kĩrathimo gĩakwa.” Jakubu akĩmũrehera nake akĩrĩa, na akĩmũrehera ndibei na akĩnyua. ");
INSERT INTO kik_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ningĩ ithe Isaaka akĩmwĩra atĩrĩ, “Mũrũ wakwa, ũka haha ũũmumunye”. ");
INSERT INTO kik_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Nake agĩthiĩ harĩ we na akĩmũmumunya. Rĩrĩa Isaaka aiguire kĩheera kĩa nguo ciake, akĩmũrathima, akiuga atĩrĩ, “Hĩ, kĩheera kĩa mũrũ wakwa nĩ ta kĩheera gĩa gĩthaka kĩrĩa kĩrathimĩtwo nĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ngai arokũhe ime rĩa igũrũ o na ũnoru wa thĩ, na ũingĩ wa ngano na wa ndibei ya mũhihano. ");
INSERT INTO kik_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ndũrĩrĩ irogũtungatagĩra nayo mĩhĩrĩga ya andũ ĩkũinamagĩrĩre. Tuĩka mwathi wa ariũ a thoguo, nao ariũ a nyũkwa marokũinamagĩrĩra. Arĩa mangĩkũruma na kĩrumi marocookererwo nĩkĩo, nao arĩa magaakũrathima marorathimagwo.” ");
INSERT INTO kik_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Na rĩrĩ, Isaaka aarĩkia kũmũrathima na Jakubu aarĩkia kuuma harĩ ithe o ro ũguo-rĩ, mũrũ wa nyina Esaũ agĩũka kuuma kũguĩma. ");
INSERT INTO kik_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","O nake agĩthondeka irio njega na agĩcirehere ithe. Agĩcooka akĩmwĩra atĩrĩ, “Baba, wĩtiire ũrĩe nyama imwe cia ũguĩmi wakwa nĩgeetha ũndathime na kĩrathimo gĩaku.” ");
INSERT INTO kik_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Nake ithe Isaaka akĩmũũria atĩrĩ, “We nĩwe ũ?” Nake akĩmũcookeria atĩrĩ, “Nĩ niĩ Esaũ, mũrũ waku wa irigithathi.” ");
INSERT INTO kik_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaaka agĩkĩinaina mũno akĩũria atĩrĩ, “Nũũ ũcio ũngĩ ũkũguĩmĩte, na andehera nyama? Ndacirĩa o ro rĩu ũtanooka, na ndamũrathima, na ti-itherũ nĩ mũrathime.” ");
INSERT INTO kik_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Rĩrĩa Esaũ aiguire ciugo cia ithe, agĩtumũka na kĩrĩro kĩnene na kĩa ruo, akĩĩra ithe atĩrĩ, “Ndaathima! O na niĩ baba ndaathima!” ");
INSERT INTO kik_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","No ithe akĩmwĩra atĩrĩ, “Mũrũ wa nyũkwa okire na wara, aheenia, na oya kĩrathimo gĩaku.” ");
INSERT INTO kik_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaũ akiuga atĩrĩ, “Githĩ nĩ ma nĩkĩo etagwo Jakubu? Arĩ kũũheenia maita maya meerĩ; nĩoire ũrigithathi wakwa, na rĩu nĩoya kĩrathimo gĩakwa!” Agĩcooka akĩũria ithe atĩrĩ, “Ndũnandigĩria kĩrathimo o na kĩmwe?” ");
INSERT INTO kik_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaaka agĩcookeria Esaũ atĩrĩ, “Ndĩmũtuire mwathi waku na andũ ao othe ndaamatua ndungata ciake, na ndamũhe ngano na ndibei ya mũhihano imũtũũragie. Nĩ ũndũ ũcio nĩ atĩa ingĩhota gũgwĩkĩra, mũrũ wakwa?” ");
INSERT INTO kik_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaũ akĩũria ithe atĩrĩ, “Baba, ndũrĩ na kĩrathimo o na kĩmwe ũndigĩirie? Ndaathima o na niĩ, baba!” Na hĩndĩ ĩyo Esaũ akĩrĩra anĩrĩire. ");
INSERT INTO kik_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Nake ithe Isaaka akĩmũcookeria atĩrĩ, “Wee ũgaatũũraga kũraihu na ũnoru wa thĩ, kũraihu na ime rĩrĩa riumaga igũrũ. ");
INSERT INTO kik_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ũgaatũũragio nĩ rũhiũ rwa njora na nĩũgatungataga mũrũ wa nyũkwa. No rĩrĩ, rĩrĩa ũkaaremwo nĩgũkirĩrĩria-rĩ, nĩũkeruta icooki rĩake ngingo, ũrĩte.” ");
INSERT INTO kik_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esaũ agĩthũũra Jakubu nĩ ũndũ wa kĩrathimo kĩu aaheirwo nĩ ithe. Nake akiuga na ngoro atĩrĩ, “Matukũ ma gũcakaĩra baba makiriĩ gũkinya; maathira nĩguo ngooraga mũrũ wa maitũ Jakubu.” ");
INSERT INTO kik_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rĩrĩa Rebeka eerirwo ũrĩa Esaũ mũriũ ũcio wake mũkũrũ oigĩte, agĩtũmanĩra Jakubu mũriũ wake ũrĩa mũnini, akĩmwĩra atĩrĩ, “Esaũ mũrũ wa nyũkwa arehooreria marakara na gwĩciiria ũrĩa egũkũũraga. ");
INSERT INTO kik_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Rĩu mũrũ wakwa-rĩ, ĩka o ũrĩa ngũkwĩra. Thiĩ o ro rĩu ũũrĩre Harani, kwa mũrũ wa maitũ Labani. ");
INSERT INTO kik_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nawe ũikare nake kwa ihinda nginya mangʼũrĩ ma mũrũ wa nyũkwa mahũahũe. ");
INSERT INTO kik_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Rĩrĩa mũrũ wa nyũkwa agaatiga gũkũrakarĩra, na ariganĩrwo nĩ ũrĩa wamwĩkire-rĩ, nĩngagũtũmanĩra ũcooke mũciĩ. Ingĩkĩũrwo nĩ inyuĩ mũrĩ eerĩ mũthenya o ro ũmwe nĩkĩ?” ");
INSERT INTO kik_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ningĩ Rebeka akĩĩra Isaaka atĩrĩ, “Nĩnogetio nĩ mũtũũrĩre nĩ ũndũ wa andũ-a-nja aya a Ahiti. Jakubu angĩhikania kuuma kũrĩ andũ-a-nja aya a Ahiti a bũrũri ũyũ-rĩ, ta andũ-a-nja aya Esaũ ahikĩtie-rĩ, hatirĩ bata wa gũtũũra muoyo.” ");
INSERT INTO kik_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tondũ ũcio, Isaaka agĩĩta Jakubu akĩmũrathima na akĩmwatha, akĩmwĩra atĩrĩ, “Ndũkanahikie mũndũ-wa-nja wa kuuma gũkũ Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ũkĩra ũthiĩ Padani-Aramu, kwa nyũmba ya Bethueli ithe wa nyũkwa. Wĩcarĩrie mũtumia kuuma kũrĩ airĩtu a Labani, mũrũ wa nyina na nyũkwa. ");
INSERT INTO kik_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ngai Mwene-Hinya-Wothe arokũrathima na atũme ũciarane mũno na ũingĩhe o nginya ũgaatuĩka rũrĩrĩ rwa andũ aingĩ. ");
INSERT INTO kik_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ngai arokũhe kĩrathimo kĩrĩa aaheire Iburahĩmu hamwe na njiaro ciaku, nĩgeetha wĩgwatĩre bũrũri ũyũ ũratũũra rĩu ũrĩ ta mũgeni, o bũrũri ũyũ Ngai eerĩire Iburahĩmu.” ");
INSERT INTO kik_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isaaka akĩĩra Jakubu athiĩ, nake agĩthiĩ Padani-Aramu kwa Labani mũrũ wa Bethueli ũrĩa Mũsuriata, mũrũ wa nyina na Rebeka, nyina wa Jakubu na Esaũ. ");
INSERT INTO kik_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Na rĩrĩ, Esaũ nĩamenyire atĩ Isaaka nĩarathimĩte Jakubu na akamũtũma Padani-Aramu akahikanie kuo, na atĩ rĩrĩa aamũrathimire nĩamwathire, akĩmwĩra atĩrĩ, “Ndũkanahikie mũndũ-wa-nja wa kuuma gũkũ Kaanani.” ");
INSERT INTO kik_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","O na akĩmenya atĩ Jakubu nĩathĩkĩire ithe na nyina na nĩathiĩte Padani-Aramu. ");
INSERT INTO kik_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ningĩ Esaũ agĩkũũrana atĩ andũ-a-nja acio a Ahiti matiakenagia ithe, Isaaka; ");
INSERT INTO kik_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","nĩ ũndũ ũcio, agĩthiĩ gwa Ishumaeli na akĩhikia Mahalathu, mwarĩ wa nyina na Nebaiothu, mũirĩtu wa Ishumaeli mũriũ wa Iburahĩmu, akĩmuongerera harĩ atumia arĩa angĩ aarĩ nao. ");
INSERT INTO kik_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakubu oima Birishiba aathiire erekeire Harani. ");
INSERT INTO kik_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Na aakinya handũ hana-rĩ, akĩraarĩrĩra ho tondũ riũa nĩ rĩathũĩte. Akĩoya ihiga rĩmwe hau, agĩĩtiira narĩo mũtwe nĩguo akome. ");
INSERT INTO kik_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nake akĩroota, akĩona ngathĩ ĩturumĩte thĩ, na mũthia wayo ũgakinya igũrũ matu-inĩ, nao araika a Ngai mambataga magĩikũrũkaga nayo. ");
INSERT INTO kik_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Jakubu akĩona Jehova arũgamĩte igũrũ rĩa ngathĩ ĩyo akĩmwĩra atĩrĩ, “Nĩ niĩ Jehova, Ngai wa thoguo Iburahĩmu na Ngai wa Isaaka. Bũrũri ũyũ ũkomete nĩngakũhe, wee hamwe na njiaro ciaku. ");
INSERT INTO kik_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Njiaro ciaku ikaingĩha ta rũkũngũ rwa thĩ, na nĩũgatambũrũka na mwena wa ithũĩro, na mwena wa irathĩro, na wa gathigathini, o na wa gũthini. Andũ a mĩhĩrĩga yothe ya thĩ nĩmakarathimwo nĩ ũndũ waku, na nĩ ũndũ wa rũciaro rwaku. ");
INSERT INTO kik_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na niĩ ndĩ hamwe nawe, na nĩndĩkũmenyagĩrĩra kũrĩa guothe ũrĩthiiaga, na nĩngagũcookia bũrũri ũyũ. Ndigagũtiganĩria nginya ngaahingia maũndũ marĩa ndakwĩrĩra.” ");
INSERT INTO kik_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Rĩrĩa Jakubu ookĩrire, agĩĩciiria atĩrĩ, “Ti-itherũ Jehova arĩ handũ haha, na ndiikũũĩ.” ");
INSERT INTO kik_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Agĩkĩigua guoya, akiuga atĩrĩ, “Kaĩ handũ haha nĩ ha kũmakania-ĩ! Haha nĩho nyũmba ya Ngai; na gĩkĩ nĩkĩo kĩhingo kĩa igũrũ-kwa-Ngai.” ");
INSERT INTO kik_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mũthenya ũyũ ũngĩ rũciinĩ tene, Jakubu akĩoya ihiga rĩrĩa etiirĩte narĩo mũtwe, akĩrĩrũgamia ta gĩtugĩ, akĩrĩitĩrĩria maguta. ");
INSERT INTO kik_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Agĩcooka agĩĩta handũ hau Betheli, o na gũtuĩka mbere ĩyo itũũra rĩu rĩetagwo Luzu. ");
INSERT INTO kik_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ningĩ Jakubu akĩĩhĩta na mwĩhĩtwa, akiuga atĩrĩ, “Ngai angĩkorwo hamwe na niĩ, na aamenyerere rũgendo-inĩ rũrũ ndĩrathiĩ, na aaheage irio cia kũrĩa na nguo cia kwĩhumba, ");
INSERT INTO kik_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nĩguo ngaacooka nyũmba-inĩ ya baba na thayũ-rĩ, Jehova nĩagatuĩka Ngai wakwa, ");
INSERT INTO kik_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","narĩo ihiga rĩĩrĩ ndaarũgamia ta gĩtugĩ rĩgaatuĩka nyũmba ya Ngai, na kĩrĩa o gĩothe ũkaahe, nĩngakũhe gĩcunjĩ gĩa ikũmi.” ");
INSERT INTO kik_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Thuutha ũcio Jakubu agĩthiĩ na mbere na rũgendo rwake, agĩkinya bũrũri wa andũ a mwena wa irathĩro. ");
INSERT INTO kik_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Na rĩrĩ, akĩona gĩthima werũ-inĩ, na ndũũru ithatũ cia mbũri ikomete hakuhĩ nakĩo, tondũ cianyuithagio maaĩ kuuma gĩthima-inĩ kĩu. Narĩo ihiga rĩrĩa rĩakunĩkĩte mũromo wa gĩthima kĩu rĩarĩ inene mũno. ");
INSERT INTO kik_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Na ndũũru ciothe ciarĩkia kũrũrũngana hau, arĩithi nao maagaragaragia ihiga rĩkeherio mũromo-inĩ wa gĩthima, makahe ndũũru maaĩ. Magacooka magacookia ihiga handũ harĩo mũromo-inĩ wa gĩthima. ");
INSERT INTO kik_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakubu akĩũria arĩithi acio atĩrĩ, “Ariũ a baba, muumĩte kũ?” Nao makĩmũcookeria atĩrĩ, “Tuumĩte Harani.” ");
INSERT INTO kik_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Akĩmooria atĩrĩ, “Nĩ mũũĩ Labani mũrũ wa Nahoru?” Nao magĩcookia “Ĩĩ, nĩ tũmũũĩ.” ");
INSERT INTO kik_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ningĩ Jakubu akĩmooria atĩrĩ, “No mwega?” Makiuga atĩrĩ, “Ĩĩ, nĩ mwega. Na rĩrĩ, mwarĩ Rakeli-rĩ, nĩwe ũũrĩa ũroka na ngʼondu.” ");
INSERT INTO kik_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Nake Jakubu akĩmeera ũũ, “Atĩrĩrĩ, riũa rĩrĩ o igũrũ; na ti ihinda rĩa gũcookanĩrĩria ndũũru. Heei ngʼondu maaĩ, mũcooke mũthiĩ mũgacirĩithie.” ");
INSERT INTO kik_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nao makĩmũcookeria atĩrĩ, “Tũtingĩĩka ũguo o nginya ndũũru ciothe icookanĩrĩrio, narĩo ihiga rĩgaragario kuuma mũromo wa gĩthima, tũcooke tũhe ngʼondu maaĩ.” ");
INSERT INTO kik_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","O akĩmaragĩria-rĩ, Rakeli agĩkinya na ngʼondu cia ithe, tondũ aarĩ mũrĩithi. ");
INSERT INTO kik_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Rĩrĩa Jakubu onire Rakeli mwarĩ wa Labani, mũrũ wa nyina na nyina, na ngʼondu cia Labani, agĩthiĩ, akĩgaragaria ihiga, akĩrĩeheria mũromo-inĩ wa gĩthima na akĩhe ngʼondu cia mamawe maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ningĩ Jakubu akĩmumunya Rakeli, na akĩrĩra anĩrĩire. ");
INSERT INTO kik_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jakubu nĩeerĩte Rakeli atĩ nĩ metainwo na ithe, na atĩ aarĩ mũrũ wa Rebeka. Nĩ ũndũ ũcio Rakeli agĩtengʼera akĩĩra ithe ũhoro ũcio. ");
INSERT INTO kik_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labani aarĩkia kũigua ũhoro wa Jakubu, mũriũ wa mwarĩ wa nyina, akĩhiũha agĩthiĩ kũmũtũnga. Akĩmũhĩmbĩria akĩmũmumunya, na akĩmũtwara mũciĩ, na arĩ kũu mũciĩ Jakubu akĩhe Labani ũhoro ũcio wothe. ");
INSERT INTO kik_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Nake Labani akĩmwĩra atĩrĩ, “Ti-itherũ, ũrĩ wa mũthiimo wakwa na thakame yakwa.” Thuutha wa Jakubu gũikara nake mweri mũgima, ");
INSERT INTO kik_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Labani akĩmũũria atĩrĩ, “Ũrĩndutagĩra wĩra o ũguo tũhũ tondũ ũrĩ wa mbarĩ ciitũ? Njĩĩra mũcaara ũrĩa ũkwenda.” ");
INSERT INTO kik_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Na rĩrĩ, Labani aarĩ na airĩtu eerĩ; ũrĩa mũkũrũ eetagwo Lea, nake ũrĩa mũnini eetagwo Rakeli. ");
INSERT INTO kik_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea aarĩ na maitho mataarĩ na hinya, no Rakeli oombĩtwo arĩ kĩĩrorerwa na aarĩ mũthaka. ");
INSERT INTO kik_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakubu eendete Rakeli, nake akiuga atĩrĩ, “Nĩngũgũtungatĩra mĩaka mũgwanja, ũndĩhe na kũũhe Rakeli, mwarĩguo ũrĩa mũnini.” ");
INSERT INTO kik_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labani agĩcookia atĩrĩ, “Nĩ kaba ndĩmũheanĩte kũrĩ we gũkĩra ndĩmũhe mũndũ ũngĩ. Ikara gũkũ na niĩ, ũndungate.” ");
INSERT INTO kik_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Nĩ ũndũ ũcio Jakubu agĩtungata mĩaka mũgwanja nĩguo aheo Rakeli, no harĩ we yarĩ o ta matukũ manini nĩ ũndũ wa ũrĩa aamwendete. ");
INSERT INTO kik_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Mĩaka ĩyo yathira Jakubu akĩĩra Labani atĩrĩ, “Rĩu kĩĩhe mũtumia wakwa ndĩmũhikie, tondũ nĩndĩrarĩkirie ihinda rĩakwa rĩa gũtungata.” ");
INSERT INTO kik_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Nĩ ũndũ ũcio Labani agĩkĩũngania andũ a kũu othe, akĩmarugĩra iruga. ");
INSERT INTO kik_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","No rĩrĩa hwaĩ-inĩ wakinyire-rĩ, akĩoya mwarĩ Lea, akĩmũnengera Jakubu, nake Jakubu agĩkoma nake. ");
INSERT INTO kik_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ningĩ Labani akĩheana Zilipa, ndungata yake ya mũirĩtu kũrĩ mwarĩ ĩmũtungatagĩre. ");
INSERT INTO kik_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Na gwakĩa rũciinĩ-rĩ, Jakubu akĩona atĩ aaheetwo Lea! Tondũ ũcio Jakubu akĩũria Labani atĩrĩ, “Hĩ nĩ atĩa ũũ wanjĩka? Githĩ ndiragũtungatagĩra nĩ ũndũ wa Rakeli? Ũũheenetie nĩkĩ?” ");
INSERT INTO kik_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labani akĩmũcookeria atĩrĩ, “Ti mũtugo witũ gũkũ kũheana mũirĩtu ũrĩa mũnini ahike mbere ya ũrĩa mũkũrũ: ");
INSERT INTO kik_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Rĩĩkia kiumia kĩa mũirĩtu ũyũ wahikia, na nĩtũgũcooka tũkũhe o na ũcio ũngĩ mũnini, nawe ũndutĩre wĩra mĩaka ĩngĩ mũgwanja.” ");
INSERT INTO kik_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Nake Jakubu agĩĩka o ũguo. Akĩrĩkia kiumia kĩa Lea, nake Labani akĩmũnengera mwarĩ Rakeli atuĩke mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labani akĩheana Biliha, ndungata yake ya mũirĩtu, kũrĩ Rakeli ĩmũtungatagĩre. ");
INSERT INTO kik_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakubu agĩkoma na Rakeli o nake, na akĩenda Rakeli gũkĩra Lea. Na akĩrutĩra Labani wĩra mĩaka ĩngĩ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Rĩrĩa Jehova onire atĩ Lea ndendeetwo-rĩ, akĩhingũra nda yake, no Rakeli aarĩ thaata. ");
INSERT INTO kik_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea akĩgĩa nda na agĩciara kahĩĩ. Nake agĩgatua Rubeni, akiuga atĩrĩ, “Nĩ tondũ Jehova nĩonete mĩnyamaro yakwa. Ti-itherũ, rĩu mũthuuri wakwa nĩekũnyenda.” ");
INSERT INTO kik_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Na akĩgĩa nda rĩngĩ, na rĩrĩa aaciarire kahĩĩ, akiuga atĩrĩ, “Tondũ Jehova nĩaiguire atĩ ndirĩ mwende-rĩ, nĩaheete gaka o nako.” Nake agĩgatua Simeoni. ");
INSERT INTO kik_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","O rĩngĩ akĩgĩa nda na rĩrĩa aaciarire kahĩĩ, akiuga atĩrĩ, “Ihinda rĩĩrĩ mũthuuri wakwa no ekwĩohania na niĩ tondũ nĩndĩmũciarĩire ihĩĩ ithatũ.” Nĩ ũndũ ũcio agĩgatua Lawi. ");
INSERT INTO kik_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Agĩcooka akĩgĩa nda rĩngĩ, agĩciara kahĩĩ kangĩ, akiuga atĩrĩ, “Ihinda rĩĩrĩ nĩ ngũgooca Jehova.” Nĩ ũndũ ũcio agĩgatua Juda. Agĩcooka akĩrũgama kũgĩa ciana. ");
INSERT INTO kik_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rĩrĩa Rakeli onire atĩ ndaraciarĩra Jakubu ciana-rĩ, akĩiguĩra mwarĩ wa nyina ũiru. Nĩ ũndũ ũcio akĩĩra Jakubu atĩrĩ, “He ciana kana ngue!” ");
INSERT INTO kik_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakubu akĩrakario nĩ Rakeli akĩmũũria atĩrĩ, “Kaarĩ niĩ ndĩ ithenya rĩa Ngai ũrĩa ũkũimĩte ciana?” ");
INSERT INTO kik_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rakeli akĩmwĩra atĩrĩ, “Biliha ndungata yakwa ya mũirĩtu ĩrĩ haha; koma nayo nĩgeetha ĩnjiarĩre ciana, na niĩ ngĩe na nyũmba na ũndũ wayo.” ");
INSERT INTO kik_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Nĩ ũndũ ũcio akĩmũhe Biliha ndungata yake ya mũirĩtu ĩrĩ ta mũtumia wake. Jakubu agĩkoma nayo, ");
INSERT INTO kik_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","nake Biliha akĩgĩa nda, akĩmũciarĩra kahĩĩ. ");
INSERT INTO kik_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rakeli akiuga atĩrĩ, “Ngai nĩandĩhĩria na nĩaiguĩte gũthaithana gwakwa, na nĩaheete kahĩĩ.” Na tondũ ũcio, agĩgatua Dani. ");
INSERT INTO kik_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Biliha ndungata ĩyo ya Rakeli ĩkĩgĩa nda ĩngĩ, na ĩgĩciarĩra Jakubu kahĩĩ ga keerĩ. ");
INSERT INTO kik_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Nake Rakeli akiuga atĩrĩ, “Nĩ ngoretwo na kũgiana kũnene na mwarĩ wa maitũ, na nĩ hootanĩte.” Nĩ ũndũ ũcio agĩgatua Nafitali. ");
INSERT INTO kik_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Na rĩrĩa Lea onire atĩ nĩarũgamĩte kũgĩa ciana-rĩ, akĩoya Zilipa ndungata yake ya mũirĩtu akĩmĩhe Jakubu ĩrĩ ta mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nake Zilipa, ndungata ĩyo ya Lea, ĩgĩciarĩra Jakubu kahĩĩ. ");
INSERT INTO kik_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Nake Lea akiuga atĩrĩ, “Hĩ, kaĩ ũyũ nĩ mũnyaka-ĩ!” Nĩ ũndũ ũcio agĩgatua Gadi. ");
INSERT INTO kik_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilipa ndungata ĩyo ya Lea ĩgĩciarĩra Jakubu kahĩĩ ga keerĩ. ");
INSERT INTO kik_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ningĩ Lea akiuga atĩrĩ, “Kaĩ ndĩ mũkenu-ĩ! Andũ-a-nja marĩnjĩtaga ‘mũkenu.’ ” Nĩ ũndũ ũcio agĩgatua Asheri. ");
INSERT INTO kik_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Na rĩrĩ, hĩndĩ ya kũgetha ngano-rĩ, Rubeni agĩthiĩ mũgũnda-inĩ na akĩona mĩmera ya mandarĩki, na akĩrehera nyina Lea. Nake Rakeli akĩĩra Lea atĩrĩ, “Ndagũthaitha he mandarĩki mamwe ma mũrũguo.” ");
INSERT INTO kik_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Nake Lea akĩmũcookeria atĩrĩ, “Kaĩ arĩ ũndũ mũnini kũndunya mũthuuri wakwa? Rĩu ningĩ nĩũkuoya mandarĩki ma mũriũ wakwa o namo?” Rakeli akĩmwĩra atĩrĩ, “He mandarĩki ma mũrũguo, nake Jakubu akome nawe ũmũthĩ.” ");
INSERT INTO kik_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Na rĩrĩa Jakubu ookire hwaĩ-inĩ oimĩte mũgũnda-rĩ, Lea agĩthiĩ kũmũtũnga. Akĩmwĩra atĩrĩ, “No nginya ũkome na niĩ, tondũ nĩngũgũrire na mandarĩki ma mũriũ wakwa.” Nĩ ũndũ ũcio agĩkoma nake ũtukũ ũcio. ");
INSERT INTO kik_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nake Ngai akĩigua mahooya ma Lea, nake akĩgĩa nda na agĩciarĩra Jakubu kahĩĩ ga gatano. ");
INSERT INTO kik_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ningĩ Lea akiuga atĩrĩ, “Ngai nĩaheete kĩheo nĩ ũndũ wa kũheana ndungata yakwa ya mũirĩtu kũrĩ mũthuuri wakwa.” Nĩ ũndũ ũcio agĩgatua Isakaru. ");
INSERT INTO kik_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea agĩcooka akĩgĩa nda ĩngĩ, na agĩciarĩra Jakubu, kahĩĩ ga gatandatũ. ");
INSERT INTO kik_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ningĩ Lea akiuga atĩrĩ, “Ngai ekũhe kĩheo kĩa goro mũno. Rĩu mũthuuri wakwa nĩarĩheeaga gĩtĩĩo tondũ ndĩmũciarĩire ihĩĩ ithathatũ.” Nĩ ũndũ ũcio agĩgatua Zebuluni. ");
INSERT INTO kik_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Thuutha ũcio agĩciara mũirĩtu na akĩmũtua Dina. ");
INSERT INTO kik_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Thuutha ũcio Ngai akĩririkana Rakeli, akĩmũigua, na akĩhingũra nda yake. ");
INSERT INTO kik_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Nake akĩgĩa nda na agĩciara kahĩĩ, akiuga atĩrĩ, “Ngai nĩanjehereria thoni.” ");
INSERT INTO kik_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Nake agĩgatua Jusufu, akiuga atĩrĩ, “Ngai arohe kahĩĩ kangĩ!” ");
INSERT INTO kik_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Thuutha wa Rakeli gũciara Jusufu, Jakubu akĩĩra Labani atĩrĩ, “Ndekereria ndĩthiĩre, nĩguo njooke bũrũri witũ. ");
INSERT INTO kik_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Nengera atumia akwa na ciana ciakwa, arĩa ngũtungatĩire nĩ ũndũ wao, na niĩ ndĩthiĩre. Wee nĩũũĩ wĩra ũrĩa ngũrutĩire.” ");
INSERT INTO kik_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","No Labani akĩmwĩra atĩrĩ, “Angĩkorwo nĩnjĩtĩkĩrĩkĩte maitho-inĩ maku-rĩ, ndagũthaitha ikaranga. Nĩmenyete na ũndũ wa ũragũri atĩ Jehova nĩandathimĩte nĩ ũndũ waku.” ");
INSERT INTO kik_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Agĩthiĩ na mbere, akiuga atĩrĩ, “Njĩĩra mũcaara ũrĩa ũkwenda na nĩ ngũkũrĩha.” ");
INSERT INTO kik_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakubu akĩmũcookeria atĩrĩ, “Wee nĩũũĩ ũrĩa ngũrutĩire wĩra na ũrĩa menyereire mahiũ maku nginya makaingĩha. ");
INSERT INTO kik_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kĩrĩa kĩnini warĩ nakĩo itaanoka nĩkĩingĩhĩte mũno, nake Jehova nĩakũrathimĩte kũrĩa guothe ngoretwo. No rĩrĩ, ngeekĩra nyũmba yakwa ũndũ rĩ?” ");
INSERT INTO kik_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labani akĩmũũria atĩrĩ, “Ũkwenda ngũhe kĩ?” Jakubu akĩmũcookeria atĩrĩ, “Ndũkahe kĩndũ o na kĩ. Korwo no ũnjĩkĩre ũndũ ũyũ ũmwe tu, no thiĩ na mbere na kũrĩithia ndũũru ciaku na gũcimenyerera: ");
INSERT INTO kik_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Naguo ũndũ ũcio nĩ ũyũ: Njĩtĩkĩria thiĩ ndũũru-inĩ ciaku ciothe ũmũthĩ, na njeherie thĩinĩ wacio ngʼondu iria ciothe irĩ maara kana irĩ marooro, na ndũrũme ciothe iria njirũ na mbũri ciothe iria irĩ maara na irĩ maroro. Icio nĩcio igũtuĩka mũcaara wakwa. ");
INSERT INTO kik_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Naguo wĩhokeku wakwa nĩguo ũkaanjarĩrĩria thuutha-inĩ, rĩrĩa rĩothe ũngĩũka kuona mũcaara ũrĩa ũndĩhĩte. Mbũri o yothe ĩtarĩ maara kana maroro, kana ndũrũme o yothe ĩtarĩ njirũ, ingĩgaakorwo nacio, igaatuĩka nĩ cia ũici.” ");
INSERT INTO kik_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Nake Labani akiuga atĩrĩ, “Nĩndetĩkĩra; reke gũtuĩke o ro ũguo woiga.” ");
INSERT INTO kik_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mũthenya o ro ũcio-rĩ, Labani akĩeheria thenge ciothe iria ciarĩ maara na iria ciarĩ na maroro, na mĩgoma yothe ĩrĩa yarĩ maara na ĩrĩa yarĩ na marooro (iria ciothe ciarĩ na handũ herũ), na ndũrũme ciothe iria ciarĩ njirũ agĩcineana kũrĩ ariũ ake macirĩithagie. ");
INSERT INTO kik_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ningĩ agĩcieheranĩria na iria ingĩ na ũraihu wa rũgendo rwa mĩthenya ĩtatũ gatagatĩ gake na Jakubu. Nake Jakubu agĩthiĩ na mbere kũrĩithia ndũũru iria ingĩ cia Labani ciatigarire. ");
INSERT INTO kik_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","No rĩrĩ, Jakubu agĩtema thanju njigũ cia mũribina, na mũrothi, na cia mũarimaũ, agĩciĩkĩra mĩcoora mĩerũ na ũndũ wa kũnũra igoko agatũma werũ wa thĩinĩ wa thanju icio wonekane. ");
INSERT INTO kik_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Agĩcooka akĩiga thanju icio oonũrĩte mĩtaro-inĩ yothe ĩrĩa yanyuuagĩrwo maaĩ, nĩgeetha ikoragwo irĩ mbere ya mbũri rĩrĩa cioka kũnyua maaĩ. Rĩrĩa ndũũru icio ciakorwo irĩ na mũrukĩ na cioka kũnyua maaĩ-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","igakĩhaicanĩra hau mbere ya thanju icio. Thuutha ũcio igaciara tũũri tũrĩ na manyaga, kana maara, kana marooro. ");
INSERT INTO kik_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakubu akĩamũrania tũũri tũu kuuma rũũru-inĩ rwa Labani, na tũgetindia, no agatũma icio ingĩ ingʼethere iria ciarĩ na maroro na iria njirũ cia Labani. Nĩ ũndũ ũcio agĩĩthondekera ndũũru ciake mwene, na ndaacituranĩrire na cia Labani. ");
INSERT INTO kik_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Hĩndĩ ĩrĩa yothe mbũri iria ciarĩ na hinya ciagĩa na mũrukĩ-rĩ, Jakubu aigaga thanju icio mĩtaro-inĩ ya maaĩ mbere yacio, nĩgeetha cihaicanĩre hakuhĩ na thanju icio; ");
INSERT INTO kik_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","no ingĩakorirwo nĩ iria itaarĩ na hinya, ndaigaga thanju icio ho. Nĩ ũndũ ũcio mbũri iria ciarĩ mocu igĩtuĩka cia Labani, na iria ciarĩ hinya igĩtuĩka cia Jakubu. ");
INSERT INTO kik_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nĩ ũndũ wa gwĩka ũguo, mũndũ ũcio ti Jakubu agĩkĩrĩrĩria kũgĩa na indo nyingĩ, akĩgĩa na mahiũ maingĩ, na ndungata cia airĩtu na cia arũme, o na ngamĩĩra na ndigiri. ");
INSERT INTO kik_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakubu nĩaiguire ariũ a Labani makiuga atĩrĩ, “Jakubu nĩoete indo iria ciothe iraarĩ cia baba na ũtonga ũrĩa wothe arĩ naguo eyoneire kuuma indo-inĩ cia baba.” ");
INSERT INTO kik_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ningĩ Jakubu akĩona atĩ Labani ndaamwendete ta ũrĩa aamwendete mbere ĩyo. ");
INSERT INTO kik_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Nake Jehova akĩĩra Jakubu atĩrĩ, “Cooka bũrũri wa maithe manyu na kũrĩ andũ anyu, na nĩndĩrĩkoragwo hamwe nawe.” ");
INSERT INTO kik_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nĩ ũndũ ũcio Jakubu agĩtũmanĩra Rakeli na Lea mathiĩ kũrĩ we kũu werũ-inĩ kũrĩa mahiũ make maarĩ. ");
INSERT INTO kik_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Nake akĩmeera atĩrĩ, “Nĩnyonete atĩ wendo wa thoguo harĩ niĩ ti ta ũrĩa ararĩ naguo hau mbere, no Ngai wa baba nĩakoretwo hamwe na niĩ. ");
INSERT INTO kik_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Inyuĩ eerĩ nĩmũũĩ atĩ ndutĩire thoguo wĩra na hinya wakwa wothe, ");
INSERT INTO kik_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","no thoguo nĩaheenetie na akagarũra mũcaara wakwa maita ikũmi. No rĩrĩ, Ngai ndarĩ aamwĩtĩkĩria anjĩke ũũru. ");
INSERT INTO kik_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Thoguo angĩoigire atĩrĩ, ‘Mbũri iria irĩ maara nĩcio mũcaara waku,’ hĩndĩ ĩyo mahiũ mothe magaciara tũũri tũrĩ na maara; na angĩoigire atĩrĩ, ‘Iria irĩ marooro nĩcio mũcaara waku,’ namo mahiũ magaciara tũũri tũrĩ na marooro. ");
INSERT INTO kik_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nĩ ũndũ ũcio, Ngai nĩatunyĩte thoguo mahiũ make na akamaheana kũrĩ niĩ. ");
INSERT INTO kik_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ihinda rĩrĩa mahiũ maahaicanaga, rĩmwe nĩndarootire kĩroto na ndarora na igũrũ ngĩona atĩ thenge iria ciahaicaga mahiũ ciarĩ na manyaga, na ciarĩ na maara, o na ciarĩ na marooro. ");
INSERT INTO kik_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Nake mũraika wa Ngai akĩnjarĩria ndĩ kĩroto-inĩ, akĩnjĩĩra atĩrĩ, ‘Jakubu.’ Na niĩ ngĩcookia atĩrĩ, ‘Niĩ ũyũ haha.’ ");
INSERT INTO kik_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Nake akĩnjĩĩra atĩrĩ, ‘Ta tiira maitho na igũrũ wone atĩ thenge iria ciothe irahaica mahiũ nĩ iria irĩ na manyaga, na iria irĩ na maara, na iria irĩ na marooro; nĩgũkorwo nĩnyonete maũndũ marĩa mothe Labani agwĩkĩte. ");
INSERT INTO kik_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nĩ niĩ Ngai wa Betheli, kũrĩa waitĩrĩirie gĩtugĩ maguta, na nokuo wehĩtĩire na mwĩhĩtwa nĩ ũndũ wakwa. Rĩu uma bũrũri ũyũ narua ũcooke bũrũri ũrĩa waciarĩirwo.’ ” ");
INSERT INTO kik_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Nake Rakeli na Lea makĩmũcookeria atĩrĩ, “Ithuĩ-rĩ, no anga tũrĩ na kĩndũ kana igai indo-inĩ cia baba? ");
INSERT INTO kik_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Githĩ ndatũtuaga o ta tũrĩ andũ a kũngĩ? To gũtwendia aatwendirie, no rĩu nĩarĩkĩtie kũhũthĩra indo iria twagũrirwo nacio. ");
INSERT INTO kik_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ti-itherũ ũtonga ũrĩa wothe Ngai atunyĩte baba nĩ witũ na ciana ciitũ. Nĩ ũndũ ũcio ĩka ũrĩa wothe Ngai akwĩrĩte wĩke.” ");
INSERT INTO kik_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Nĩ ũndũ ũcio Jakubu akĩĩhaarĩria, akĩigĩrĩra ciana ciake na atumia ake igũrũ rĩa ngamĩĩra, ");
INSERT INTO kik_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","na akiumagaria mahiũ make mothe mathiĩ mbere yake hamwe na indo ciake ciothe iria aagĩte nacio kũu Padani-Aramu, nĩguo athiĩ kũrĩ ithe Isaaka o kũu bũrũri wa Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Hĩndĩ ĩyo, Labani aathiĩte kwenja ngʼondu ciake guoya-rĩ, Rakeli akĩiya ngai cia ithe cia mĩhianano. ");
INSERT INTO kik_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nĩ ũndũ ũcio Jakubu akĩheenia Labani ũcio Mũsuriata tondũ ndaamwĩrire nĩ kũũra aroora. ");
INSERT INTO kik_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Nake akĩũra na kĩrĩa gĩothe arĩ nakĩo, na aringa Rũũĩ rwa Farati, akĩerekera bũrũri wa irĩma wa Gileadi. ");
INSERT INTO kik_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mũthenya wa ĩtatũ kuuma Jakubu oora, Labani akĩĩrwo atĩ Jakubu nĩorĩte. ");
INSERT INTO kik_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Agĩkĩoya andũ a nyũmba yao, akĩingatana na Jakubu matukũ mũgwanja na akĩmũkinyĩra kũu bũrũri wa irĩma wa Gileadi. ");
INSERT INTO kik_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","No Ngai akiumĩrĩra Labani ũcio Mũsuriata kĩroto-inĩ, akĩmwĩra atĩrĩ, “Menya wĩre Jakubu ũndũ o na ũrĩkũ, ũrĩ mwega kana ũrĩ mũũru.” ");
INSERT INTO kik_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Na rĩrĩ, Jakubu aambĩte hema yake kũu bũrũri wa irĩma wa Gileadi rĩrĩa Labani aamũkinyĩrire, nake Labani na andũ a nyũmba yao makĩamba hema ciao kuo. ");
INSERT INTO kik_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Nake Labani akĩũria Jakubu atĩrĩ, “Nĩ atĩa ũũ wĩkĩte? Nĩũũheenetie, na ũgathiĩ na airĩtu akwa ta andũ matahĩtwo mbaara-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nĩ kĩĩ gĩatũmire ũre na hitho, na ũũheenie? Waregire kũnjĩĩra nĩkĩ, nĩguo ngumagarie na gĩkeno na gũkũinĩra nyĩmbo na ihembe na inanda cia mũgeeto? ");
INSERT INTO kik_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","O na ndwarekire mumunye ciana cia ciana ciakwa, kana njugĩre airĩtu akwa ũhoro. Nĩwĩkĩte ũndũ wa ũrimũ. ");
INSERT INTO kik_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ndĩ na hinya wa gũkũgera ngero; no rĩrĩ, ũtukũ wa ira Ngai wa thoguo aranjĩĩrire atĩrĩ, ‘Menya wĩre Jakubu ũndũ, ũrĩ mwega kana ũrĩ mũũru.’ ");
INSERT INTO kik_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Rĩu-rĩ, nĩumagarĩte nĩ ũndũ nĩũrerirĩria gũcooka nyũmba-inĩ ya thoguo. No rĩrĩ, ũrakĩiyire ngai ciakwa nĩkĩ?” ");
INSERT INTO kik_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakubu agĩcookeria Labani atĩrĩ, “Nĩndetigĩrire tondũ ndeciiririe wahota kũndunya airĩtu aku na hinya. ");
INSERT INTO kik_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","No rĩrĩ, ũrĩa ũgũkora arĩ na ngai ciaku-rĩ, ndegũtũũra muoyo. Tuĩria wone kana kũrĩ kĩndũ gĩaku ndĩ nakĩo andũ aya aitũ marĩ ho; na wakĩona-rĩ, ũkĩoe.” No Jakubu ndooĩ atĩ Rakeli nĩaiyĩte ngai icio. ");
INSERT INTO kik_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Nĩ ũndũ ũcio Labani agĩtoonya hema ya Jakubu, na hema ya Lea, o na hema ya ndungata iria igĩrĩ cia andũ-a-nja, no ndaigana kuona kĩndũ. Oima hema ya Lea, agĩtoonya ya Rakeli. ");
INSERT INTO kik_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rakeli oete ngai icio cia mĩhianano na agacikia matandĩko-inĩ ma ngamĩĩra thĩinĩ na akamaikarĩra. Labani akiururia kĩrĩa gĩothe kĩarĩ hema-inĩ ĩyo na ndaigana kuona kĩndũ. ");
INSERT INTO kik_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Nake Rakeli akĩĩra ithe atĩrĩ, “Mwathi wakwa, ndũkandakarĩre nĩ ũndũ ndinakũrũgamĩra; nĩgũkorwo nĩ maũndũ ma andũ-a-nja ndĩ namo.” Nĩ ũndũ ũcio akiururia no ndaigana kuona ngai icio. ");
INSERT INTO kik_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakubu agĩkĩrakara na agĩtetia Labani, akĩmũũria atĩrĩ, “Ihĩtia rĩakwa nĩ rĩrĩkũ? Nĩ rĩhia rĩrĩkũ njĩkĩte rĩtũmĩte ũnyingatithie ũguo? ");
INSERT INTO kik_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Rĩu tondũ nĩwoiruria indo ciakwa ciothe-rĩ, nĩ kĩĩ wona kĩa indo cia gwaku mũciĩ? Kĩige haha mbere ya andũ aya anyu na mbere ya andũ akwa nĩguo matũtuithanie ciira. ");
INSERT INTO kik_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ngũrutĩire wĩra mĩaka mĩrongo ĩĩrĩ. Ngʼondu ciaku na mbũri ciaku itirĩ ciahuna, na ndirĩ ndarĩa ndũrũme cia mahiũ maku. ");
INSERT INTO kik_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ningĩ ndirĩ ndakũrehera iria ciatambuuragwo nĩ nyamũ cia gĩthaka; no nĩ niĩ ndaarĩhaga ngathiĩ hathara. Ningĩ-rĩ, nĩwandĩhagia ĩrĩa yothe yaiywo kũrĩ mũthenya kana kũrĩ ũtukũ. ");
INSERT INTO kik_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ũguo nĩguo ndũũrĩte: Ndaarugagwo nĩ ũrugarĩ wa mũthenya na ngarĩĩo nĩ heho ya ũtukũ, naguo toro ũkĩnjũrĩra. ");
INSERT INTO kik_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ũguo nĩguo ndũũrĩte gwaku mũciĩ handũ-inĩ ha mĩaka ĩyo mĩrongo ĩĩrĩ. Ndakũrutĩire wĩra mĩaka ikũmi na ĩna nĩ ũndũ wa airĩtu aku eerĩ, na mĩaka ĩtandatũ nĩ ũndũ wa mahiũ maku; no rĩrĩ, wagarũrire mũcaara wakwa maita ikũmi. ");
INSERT INTO kik_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Korwo Ngai wa baba, o we Ngai wa Iburahĩmu na nĩwe wĩtigĩrĩtwo nĩ Isaaka, ndaraakoragwo hamwe na niĩ-rĩ, ti-itherũ ũngĩranyumagaririe moko matheri. No Ngai nĩonete gũthĩĩnĩka gwakwa na wĩra wa moko makwa, na nĩkĩo arakũrũithirie ũtukũ wa ira.” ");
INSERT INTO kik_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Nake Labani agĩcookeria Jakubu, akĩmwĩra atĩrĩ, “Atumia aya aku nĩ airĩtu akwa, ciana ici o nacio nĩ ciana ciakwa, namo mahiũ maya-rĩ, no mahiũ makwa. Kĩrĩa gĩothe ũroona nĩ gĩakwa. No rĩrĩ, nĩ atĩa ingĩhota gwĩka airĩtu aya akwa kana njĩke ciana ici maciarĩte ũmũthĩ? ");
INSERT INTO kik_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Rĩu gĩũke, reke tũgĩe na kĩrĩkanĩro niĩ nawe, na ũreke gĩtuĩke mũira gatagatĩ gaitũ.” ");
INSERT INTO kik_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nĩ ũndũ ũcio Jakubu akĩoya ihiga na akĩrĩhaanda ta gĩtugĩ. ");
INSERT INTO kik_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Akĩĩra andũ a nyũmba yake atĩrĩ, “Cookanĩrĩriai mahiga.” Nĩ ũndũ ũcio makĩũngania mahiga makĩmaiganĩrĩra hĩba, magĩcooka makĩrĩanĩra irio hau hakuhĩ na hĩba ĩyo. ");
INSERT INTO kik_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labani akĩmĩĩta Jagari-Sahadutha, nake Jakubu akĩmĩĩta Galeedi. ");
INSERT INTO kik_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Labani akiuga atĩrĩ, “Ũmũthĩ hĩba ĩno nĩ mũira gatagatĩ gakwa nawe.” Kĩu nĩkĩo gĩatũmire hetwo Galeedi. ");
INSERT INTO kik_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","O na ningĩ hagĩĩtwo Mizipa, tondũ oigire atĩrĩ, “Jehova arotũmenyagĩrĩra rĩrĩa tũraihanĩrĩirie. ");
INSERT INTO kik_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Wee ũngĩgaathĩĩnia airĩtu akwa kana ũmahikĩrĩrie atumia angĩ, o na hangĩgakorwo hatarĩ mũndũ ũngĩ-rĩ, ririkana atĩ Ngai nĩwe mũira gatagatĩ gakwa nawe.” ");
INSERT INTO kik_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ningĩ Labani akĩĩra Jakubu atĩrĩ, “Ĩno nĩ hĩba, na gĩkĩ nĩ gĩtugĩ kĩrĩa ndahaanda gatagatĩ gaku na niĩ. ");
INSERT INTO kik_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Hĩba ĩno nĩ mũira, na gĩtugĩ gĩkĩ nĩ mũira, atĩ ndigakĩra hĩba ĩno njũke mwena waku ngũgere ngero, na atĩ nawe ndũgakĩra hĩba ĩno, kana ũkĩre gĩtugĩ gĩkĩ ũũke mwena wakwa ũngere ngero. ");
INSERT INTO kik_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ngai wa Iburahĩmu, na Ngai wa Nahoru, o we Ngai wa ithe wao-rĩ, arotũtuithania ciira.” Nĩ ũndũ ũcio Jakubu akĩĩhĩta na mwĩhĩtwa rĩĩtwa-inĩ rĩa ũcio Wĩtigĩrĩtwo nĩ ithe Isaaka. ");
INSERT INTO kik_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jakubu akĩruta igongona kũu bũrũri-inĩ ũcio wa irĩma, na agĩĩta andũ a nyũmba yake marĩĩanĩre. Na marĩkia kũrĩa-rĩ, makĩraara o kũu. ");
INSERT INTO kik_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Mũthenya ũyũ ũngĩ rũciinĩ tene, Labani akĩmumunya ciana cia ciana ciake o na airĩtu ake, akĩmoigĩra ũhoro na akĩmarathima. Agĩcooka akĩmatiga agĩcooka gwake mũciĩ. ");
INSERT INTO kik_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakubu nĩathiire na mbere na rũgendo rwake, na agĩtũngwo nĩ araika a Ngai. ");
INSERT INTO kik_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Na rĩrĩa Jakubu aamoonire, akiuga atĩrĩ, “Ĩno nĩ mbũtũ ya Ngai!” Nĩ ũndũ ũcio agĩĩta handũ hau Mahanaimu. ");
INSERT INTO kik_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ningĩ Jakubu agĩtũma andũ mathiĩ mbere yake kũrĩ mũrũ wa nyina Esaũ kũu Seiru, bũrũri-inĩ wa Edomu. ");
INSERT INTO kik_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Akĩmataara, akĩmeera atĩrĩ, “Ũũ nĩguo mũgũthiĩ kwĩra mwathi wakwa Esaũ: ‘Ndungata yaku Jakubu ĩkuuga atĩrĩ, ndĩraikaraga na Labani, na ngoretwo kuo nginya rĩu. ");
INSERT INTO kik_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ndĩ na ngʼombe na ndigiri, na ngʼondu na mbũri, ndungata cia arũme na cia andũ-a-nja. Na rĩu ndagũtũmĩra ndũmĩrĩri, we mwathi wakwa, nĩgeetha njĩtĩkĩrĩke maitho-inĩ maku.’ ” ");
INSERT INTO kik_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Rĩrĩa atũmwo maacookire kũrĩ Jakubu makĩmwĩra atĩrĩ, “Nĩtũrathiire kũrĩ mũrũ wa nyũkwa Esaũ, na rĩu nĩarooka gũgũtũnga, na arĩ na andũ magana mana.” ");
INSERT INTO kik_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakubu akĩmaka mũno na akĩnyamarĩka, akĩgayania andũ arĩa aarĩ nao ikundi igĩrĩ, o na ndũũru cia mbũri na ndũũru cia ngʼombe o na ngamĩĩra nacio. ");
INSERT INTO kik_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Agĩĩciiria atĩrĩ, “Esaũ angĩũka atharĩkĩre gĩkundi kĩmwe-rĩ, gĩkundi kĩu kĩngĩ no kĩũre.” ");
INSERT INTO kik_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ningĩ Jakubu akĩhooya, akiuga atĩrĩ, “Wee Ngai wa baba Iburahĩmu, o Wee Ngai wa baba Isaaka, Wee Jehova ũrĩa wanjĩĩrire atĩrĩ, ‘Cooka bũrũri waku na wa andũ anyu, na nĩngatũma ũgaacĩre,’ ");
INSERT INTO kik_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ndirĩ mwagĩrĩru wa kuonio ũtugi ũyũ wothe na wĩhokeku ũrĩa ũnyonetie niĩ ndungata yaku. Ngĩringa Jorodani-rĩ, ndaarĩ o na rũthanju rwakwa rwiki, no rĩu nduĩkĩte ikundi igĩrĩ. ");
INSERT INTO kik_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ndagũthaitha honokia kuuma moko-inĩ ma mũrũ wa maitũ Esaũ, nĩgũkorwo nĩndĩretigĩra ndagoke gũũtharĩkĩra, niĩ hamwe na ciana ici, na manyina maacio. ");
INSERT INTO kik_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","No nĩ uugĩte atĩrĩ, ‘Ti-itherũ nĩngatũma ũgaacĩre na ndũme njiaro ciaku cingĩhe ta mũthanga wa iria-inĩ, ũrĩa ũtangĩtarĩka.’ ” ");
INSERT INTO kik_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Akĩraara hau ũtukũ ũcio, na kuuma kũrĩ kĩrĩa aarĩ nakĩo, agĩthuurĩra mũrũ wa nyina Esaũ kĩheo gĩkĩ; ");
INSERT INTO kik_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","mbũri magana meerĩ cia mĩgoma na thenge mĩrongo ĩĩrĩ, ngʼondu magana meerĩ na ndũrũme mĩrongo ĩĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ngamĩĩra mĩrongo ĩtatũ cia mĩgoma na njaũ ciacio, ngʼombe mĩrongo ĩna na ndegwa ikũmi, na ndigiri mĩrongo ĩĩrĩ cia mĩgoma na ikũmi cia njamba. ");
INSERT INTO kik_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Agĩcinengera ndungata ciake, o rũũru mwanya, na akĩĩra ndungata icio ciake atĩrĩ, “Thiiagai mbere yakwa, na mũtigithũkanie rũũru na rũũru rũrĩa rũngĩ.” ");
INSERT INTO kik_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ningĩ agĩtaara ũrĩa wamatongoretie, akĩmwĩra atĩrĩ, “Rĩrĩa mũrũ wa maitũ Esaũ arĩgũtũnga na akũũrie atĩrĩ, ‘Wee ũrĩ waũ? Na wathiĩ kũ? Na ũhiũ ũyũ wothe ũrĩ mbere yaku nĩ waũ?’ ");
INSERT INTO kik_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Nawe nĩũrĩmũcookeria ũmwĩre atĩrĩ, ‘Nĩ cia ndungata yaku Jakubu. Nĩ kĩheo gĩa kũhe mwathi wakwa Esaũ, na Jakubu arĩ thuutha witũ agĩũka.’ ” ");
INSERT INTO kik_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Agĩcooka agĩtaara wa keerĩ na wa gatatũ, na arĩa othe marũmagĩrĩra ndũũru icio, akĩmeera atĩrĩ, “Ũguo nĩguo mũrĩĩraga Esaũ mwamũtũnga. ");
INSERT INTO kik_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Na mũtikanaage kũmwĩra atĩrĩ, ‘Jakubu ndungata yaku arĩ thuutha witũ agĩũka.’ ” Tondũ eeciiririe atĩrĩ, “Ngũmũhooreria na iheo ici ngũtũma mbere yakwa; thuutha-inĩ ndamuona-rĩ, hihi ahota kũnyamũkĩra.” ");
INSERT INTO kik_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Nĩ ũndũ ũcio iheo icio Jakubu aaheanĩte igĩthiiaga mbere yake, nowe akĩraara kũu kambĩ ũtukũ ũcio. ");
INSERT INTO kik_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Na ũtukũ o ro ũcio, Jakubu agĩũkĩra, akĩoya atumia ake eerĩ, na ndungata iria igĩrĩ cia andũ-a-nja, na ariũ ake ikũmi na ũmwe, na akĩmaringĩria iringĩro rĩa Jaboku. ");
INSERT INTO kik_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Aarĩkia kũmaringia, akĩringia indo iria ciothe aarĩ nacio. ");
INSERT INTO kik_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nake Jakubu agĩtigwo arĩ o wiki, na hagĩũka mũndũ maagianire nake o nginya gũgĩthererũka. ");
INSERT INTO kik_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Na rĩrĩa mũndũ ũcio onire atĩ ndangĩmũhoota-rĩ, akĩmũhutia ihĩndĩ rĩa gĩtina gĩa kũgũrũ, nakuo kũgũrũ kwa Jakubu gũgĩthenyũkĩra hau gĩtina-inĩ, o makĩgianaga na mũndũ ũcio. ");
INSERT INTO kik_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Na mũndũ ũcio akĩmwĩra atĩrĩ, “Reke ndĩthiĩre tondũ nĩ gwathererũka.” No Jakubu akĩmũcookeria, akĩmwĩra atĩrĩ, “Ndingĩreka ũthiĩ ũtandathimĩte.” ");
INSERT INTO kik_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nake mũndũ ũcio akĩmũũria atĩrĩ, “Wĩtagwo atĩa?” Jakubu akĩmũcookeria atĩrĩ, “Njĩtagwo Jakubu.” ");
INSERT INTO kik_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ningĩ mũndũ ũcio akĩmwĩra atĩrĩ, “Ndũgũcooka gwĩtwo Jakubu, no ũrĩĩtagwo Isiraeli, tondũ nĩũgianĩte na Ngai o na andũ, na ũkahootana.” ");
INSERT INTO kik_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakubu akĩmwĩra atĩrĩ, “Ndagũthaitha, njĩĩra rĩĩtwa rĩaku.” Nowe akĩmũcookeria atĩrĩ, “Ũranjũũria rĩĩtwa rĩakwa nĩkĩ?” Agĩcooka akĩmũrathima marĩ o hau. ");
INSERT INTO kik_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Nĩ ũndũ ũcio Jakubu agĩĩta handũ hau Penieli, akiuga atĩrĩ, “Tondũ nĩnyonete Ngai ũthiũ kwa ũthiũ, na akahonokia muoyo wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Narĩo riũa rĩkĩmũrathĩra akĩhĩtũka hau Penieli, na nĩathuaga nĩ ũndũ nĩathenyũkĩtwo nĩ ihĩndĩ rĩa gĩtina gĩa kũgũrũ. ");
INSERT INTO kik_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nĩ tondũ ũcio, nginyagia ũmũthĩ ũyũ andũ a Isiraeli matirĩĩaga mũkiha ũrĩa ũnyiitanĩte na ihĩndĩ rĩa gĩtina gĩa kũgũrũ, tondũ ihĩndĩ rĩa gĩtina gĩa kũgũrũ kwa Jakubu rĩahutĩirio hakuhĩ na mũkiha ũcio. ");
INSERT INTO kik_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Na rĩrĩ, Jakubu agĩtiira maitho, akĩona Esaũ agĩũka arĩ na andũ ake magana mana; nĩ ũndũ ũcio akĩgayania ciana kũrĩ Lea na Rakeli na kũrĩ ndungata iria igĩrĩ cia andũ-a-nja. ");
INSERT INTO kik_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Akĩiga ndungata cia andũ-a-nja na ciana ciacio mbere, nake Lea na ciana ciake makĩrũmĩrĩra, nake Rakeli na Jusufu makĩrigia thuutha. ");
INSERT INTO kik_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nake we mwene akĩmatongoria, na rĩrĩa aakuhĩrĩirie mũrũ wa nyina, akĩinamĩrĩra, agĩturumithia ũthiũ wake thĩ maita mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","No Esaũ akĩhanyũka agatũnge Jakubu na akĩmũnyiita, akĩmũhĩmbĩria, akĩmũmumunya. Nao makĩrĩranĩra. ");
INSERT INTO kik_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ningĩ Esaũ agĩtiira maitho akĩona atumia na ciana. Akĩũria Jakubu atĩrĩ, “Andũ aya mũrĩ nao nĩ a ũ?” Jakubu agĩcookia atĩrĩ, “Ici nĩ ciana iria Ngai aheete ndungata yaku nĩ ũndũ wa ũtugi wake.” ");
INSERT INTO kik_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hĩndĩ ĩyo ndungata icio cia andũ-a-nja na ciana ciacio igĩkuhĩrĩria na makĩinamĩrĩra. ");
INSERT INTO kik_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea na ciana ciake makĩrũmĩrĩra, magĩũka na makĩinamĩrĩra. Marigĩrĩrio, Jusufu na Rakeli magĩũka, o nao makĩinamĩrĩra. ");
INSERT INTO kik_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaũ akĩũria atĩrĩ, “Nĩ kĩĩ gĩtũmi gĩa kũndũmĩra ikundi icio ndatũnga?” Nake Jakubu agĩcookia atĩrĩ, “Nĩgeetha njĩtĩkĩrĩke maitho-inĩ maku, wee mwathi wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","No Esaũ akiuga atĩrĩ, “Mũrũ wa maitũ, niĩ ndĩ na indo cia kũnjigana. Ikara na icio ũrĩ nacio wee mwene.” ");
INSERT INTO kik_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakubu akiuga atĩrĩ, “Aca, ndagũthaitha! Angĩkorwo nĩnjĩtĩkĩrĩkĩte maitho-inĩ maku-rĩ, amũkĩra kĩheo gĩkĩ kuuma kũrĩ niĩ. Nĩ ũndũ kuona ũthiũ waku no ta kuona ũthiũ wa Ngai, tondũ nĩ wanyamũkĩra na gĩkeno. ");
INSERT INTO kik_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ndagũthaitha ĩtĩkĩra kĩheo kĩu ũreheirwo, tondũ Ngai nĩanjĩkĩte wega, na ndĩ na indo cia kũnjigana.” Na tondũ Jakubu nĩamũringĩrĩirie-rĩ, Esaũ agĩciĩtĩkĩra. ");
INSERT INTO kik_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ningĩ Esaũ akĩmwĩra atĩrĩ, “Nĩtũthiĩ; nĩngũtwarana nawe.” ");
INSERT INTO kik_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","No Jakubu akĩmwĩra atĩrĩ, “Mwathi wakwa nĩoĩ atĩ twana tũtũ tũtirĩ na hinya, na no nginya menyerere ngʼondu na ngʼombe iria irongithia. Ingĩtwarwo na ihenya o na mũthenya ũmwe, nyamũ ciothe no ikue. ");
INSERT INTO kik_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nĩ ũndũ ũcio mwathi wakwa nĩathiiage mbere ya ndungata yake, na niĩ thiĩ o kahora kũringana na mũthiĩre wa ikundi ici, o na wa ciana, nginya rĩrĩa ngaakinya kwa mwathi wakwa kũu Seiru.” ");
INSERT INTO kik_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaũ akĩmwĩra atĩrĩ, “No kĩreke ngũtigĩre ndungata imwe ciakwa.” Jakubu akĩmũũria atĩrĩ, “Ũgwĩka ũguo nĩkĩ? Reke niĩ njĩtĩkĩrĩke maitho-inĩ ma mwathi wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Nĩ ũndũ ũcio Esaũ akĩhũndũka mũthenya o ro ũcio agĩthiĩ arorete Seiru. ");
INSERT INTO kik_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Nowe Jakubu, agĩthiĩ Sukothu, kũrĩa eyakĩire nyũmba, na agĩthondeka ciugũ cia mahiũ make. Nĩkĩo handũ hau hetagwo Sukothu. ");
INSERT INTO kik_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Thuutha wa Jakubu kuuma Padani-Aramu, agĩkinya o wega itũũra-inĩ rĩrĩa inene rĩa Shekemu kũu Kaanani, na akĩamba hema hakuhĩ na itũũra rĩu inene. ");
INSERT INTO kik_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nake akĩgũra gĩcunjĩ kĩa mũgũnda na betha igana rĩmwe kuuma kũrĩ ariũ a Hamoru ithe wa Shekemu, harĩa aambire hema yake. ");
INSERT INTO kik_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Agĩaka kĩgongona handũ hau, na agĩgĩĩta Eli-Elohe-Isiraeli. ");
INSERT INTO kik_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Na rĩrĩ, mũthenya ũmwe, Dina mũirĩtu ũrĩa Lea aaciarĩire Jakubu, nĩathiire gũceerera andũ-a-nja a bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Na rĩrĩa Shekemu mũrũ wa Hamoru ũrĩa Mũhivi, mũnene wa gĩcigo kĩu aamuonire, akĩmũnyiita, agĩkoma nake na hinya. ");
INSERT INTO kik_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Na ngoro yake ĩkĩguucĩrĩrio nĩ Dina mwarĩ ũcio wa Jakubu, na akĩenda mũirĩtu ũcio na akĩmwarĩria wega. ");
INSERT INTO kik_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Nake Shekemu akĩĩra ithe Hamoru atĩrĩ, “Njarĩrĩria harĩ ithe wa mũirĩtu ũyũ atuĩke mũtumia wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Rĩrĩa Jakubu aiguire atĩ mwarĩ Dina nĩarĩkĩtie gũthũkio-rĩ, na tondũ ariũ ake maarĩ gĩthaka-inĩ na mahiũ make, agĩkira na ũhoro ũcio o nginya rĩrĩa mainũkire. ");
INSERT INTO kik_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hĩndĩ ĩyo Hamoru ithe wa Shekemu agĩthiĩ kwaria na Jakubu. ");
INSERT INTO kik_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Nao ariũ a Jakubu nĩmainũkĩte kuuma mĩgũnda-inĩ maigua ũrĩa gwekĩkĩte. Nao makĩiyũrwo nĩ kĩeha na mangʼũrĩ, tondũ Shekemu nĩekĩte ũndũ wa thoni thĩinĩ wa Isiraeli, nĩ gũkoma na mwarĩ wa Jakubu, ũndũ ũrĩa ũtagĩrĩirwo nĩ gwĩkwo. ");
INSERT INTO kik_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","No Hamoru akĩmeera atĩrĩ, “Ngoro ya mũrũ wakwa Shekemu nĩĩguucĩrĩirio nĩ mwarĩ wanyu. Ndamũthaitha ĩtĩkĩrai amũhikie atuĩke mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Rekei tũhikanagie; mũtũheage airĩtu anyu na inyuĩ tũkamũheaga airĩtu aitũ. ");
INSERT INTO kik_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Inyuĩ no mũtũũre hamwe na ithuĩ; bũrũri ũyũ gũtirĩ handũ mũrigĩrĩirio. Tũũrai kuo, mwonjorithagie kuo, na mwĩgĩĩre na indo ciaguo.” ");
INSERT INTO kik_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ningĩ Shekemu akĩĩra ithe wa Dina na ariũ a ithe atĩrĩ, “Rekei njĩtĩkĩrĩke maitho-inĩ manyu na nĩngũmũhe o kĩrĩa gĩothe mũngĩnjĩtia. ");
INSERT INTO kik_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Njĩtiai rũracio rwa mũhiki na kĩheo kĩrĩa ingĩrehe, o mũigana ũrĩa mũngĩenda, na nĩngũrĩha o kĩrĩa gĩothe mũngĩnjĩtia. No ndamũthaitha mũũhe mũirĩtu ũyũ atuĩke mũtumia wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Na tondũ mwarĩ wa nyina Dina nĩarĩkĩtie gũthũkio-rĩ, ariũ a Jakubu rĩrĩa maaragia na Shekemu na ithe Hamoru, magĩcookia ũhoro ũcio na njĩra ya maheeni. ");
INSERT INTO kik_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Makĩmeera atĩrĩ, “Tũtingĩĩka ũndũ ta ũcio; tũtingĩheana mwarĩ witũ kũrĩ mũndũ ũtarĩ mũruu. Ũndũ ũcio no ũtuĩke wa gũtũnyararithia. ");
INSERT INTO kik_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tũkũmwĩtĩkĩria tondũ wa gĩtũmi o kĩmwe tu; inyuĩ mũtuĩke ta ithuĩ na ũndũ wa kũruithia arũme anyu othe. ");
INSERT INTO kik_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Hĩndĩ ĩyo nĩmũrĩhikagia airĩtu aitũ na nĩtũrĩhikagia airĩtu anyu. Nĩtũgũtũũrania na inyuĩ na tũtuĩke andũ amwe. ");
INSERT INTO kik_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","No angĩkorwo mũtigwĩtĩkĩra kũrua-rĩ, tũkuoya mwarĩ witũ twĩthiĩre.” ");
INSERT INTO kik_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ũhoro ũcio ũkĩoneka ũrĩ mwega nĩ Hamoru na mũriũ Shekemu. ");
INSERT INTO kik_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tondũ nĩwe warĩ mũtĩĩe mũno kũrĩ andũ othe a nyũmba ya ithe, mwanake ũcio ndaateire ihinda rĩa gwĩka ũrĩa moigire, tondũ nĩakenetio nĩ mwarĩ wa Jakubu. ");
INSERT INTO kik_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Nĩ ũndũ ũcio Hamoru na mũriũ Shekemu magĩthiĩ kĩhingo-inĩ gĩa itũũra rĩao inene makaarie na andũ ao a itũũra rĩu. ");
INSERT INTO kik_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Nao makiuga atĩrĩ, “Andũ aya nĩ arata aitũ; rekei matũũre bũrũri-inĩ witũ na monjorithagie kuo; bũrũri ũyũ nĩ mũnene wa kũmaigana. Ithuĩ no tũhikie airĩtu ao, nao no mahikie airĩtu aitũ. ");
INSERT INTO kik_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","No andũ acio mangĩtĩkĩra gũtũũrania na ithuĩ ta rũrĩrĩ rũmwe angĩkorwo arũme aitũ othe nĩmekũrua, o ta ũrĩa o maruĩte. ");
INSERT INTO kik_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Githĩ mahiũ mao, na indo ciao ciothe, o na nyamũ iria ingĩ ciao ciothe itigũgĩtuĩka ciitũ? Nĩ ũndũ ũcio rekei tũmetĩkĩre, na nĩ megũtũũrania na ithuĩ.” ");
INSERT INTO kik_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Arũme arĩa othe maathiĩte kĩhingo-inĩ gĩa itũũra rĩu inene magĩĩtĩkania na Hamoru na mũriũ Shekemu, na arũme othe a itũũra rĩu makĩrua. ");
INSERT INTO kik_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Thuutha wa mĩthenya ĩtatũ, hĩndĩ ĩrĩa othe maarĩ na ruo ariũ eerĩ a Jakubu, Simeoni na Lawi, ariũ a nyina na Dina, makĩoya hiũ ciao cia njora magĩtharĩkĩra itũũra rĩu hĩndĩ ĩrĩa rĩtekũũaga makĩũraga arũme othe. ");
INSERT INTO kik_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ningĩ makĩũraga Hamoru na mũriũ Shekemu na rũhiũ rwa njora, na makĩruta Dina nyũmba-inĩ ya Shekemu, magĩĩthiĩra. ");
INSERT INTO kik_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ariũ arĩa angĩ a Jakubu magĩkinya kũu ciimba ciarĩ, na magĩĩtahĩra indo cia itũũra rĩu mwarĩ wa ithe wao aathũkĩirio. ");
INSERT INTO kik_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Nao magĩtaha ndũũru cia mbũri na cia ngʼombe na ndigiri, na indo iria ingĩ ciao ciothe iria ciarĩ itũũra-inĩ rĩu inene, na iria ciarĩ mĩgũnda-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Na magĩkuua ũtonga wothe wa itũũra, na atumia othe na ciana, magĩtaha indo ciothe iria ciarĩ nyũmba-inĩ icio. ");
INSERT INTO kik_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Nake Jakubu akĩĩra Simeoni na Lawi atĩrĩ, “Nĩmwandehera thĩĩna nĩ ũndũ wa gũtũma menwo nĩ Akaanani na Aperizi, andũ arĩa matũũraga bũrũri ũyũ. Ithuĩ tũrĩ anini tũgĩtarwo, na mangĩnyiitana manjũkĩrĩre na matharĩkĩre-rĩ, niĩ na nyũmba yakwa no tũniinwo.” ");
INSERT INTO kik_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Nao makĩmũcookeria atĩrĩ, “Nĩkũraagĩrĩire atue mwarĩ wa maitũ ta mũmaraya?” ");
INSERT INTO kik_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Thuutha wa ũguo Ngai akĩĩra Jakubu atĩrĩ, “Ambata, ũthiĩ Betheli ũgatũũre kuo, na wakĩre Ngai kĩgongona kuo, o we ũrĩa wakuumĩrĩire rĩrĩa woragĩra mũrũ wa nyũkwa Esaũ.” ");
INSERT INTO kik_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Nĩ ũndũ ũcio Jakubu akĩĩra andũ a nyũmba yake, na arĩa othe maarĩ nao, atĩrĩ, “Eheriai ngai cia mĩhianano iria mũrĩ nacio, na mwĩtherie inyuĩ ene, na mwĩkĩre nguo ingĩ. ");
INSERT INTO kik_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mũcooke mũũkĩre, mũreke tũthiĩ twambate Betheli, ngaakĩre Ngai kĩgongona kuo, ũrĩa wanjĩtĩkire mũthenya ũrĩa ndaarĩ thĩĩna-inĩ, na ũrĩa ũkoretwo na niĩ kũrĩa guothe ndanathiĩ.” ");
INSERT INTO kik_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Nĩ ũndũ ũcio makĩnengera Jakubu ngai cia mĩhianano iria maarĩ nacio, na irengeeri iria ciarĩ matũ mao, nake Jakubu agĩcithika gĩtina-inĩ kĩa mũgandi kũu Shekemu. ");
INSERT INTO kik_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Nao makiumagara, magĩĩthiĩra, namo matũũra marĩa maamathiũrũrũkĩirie makĩnyiitwo nĩ guoya wa Ngai, nĩ ũndũ ũcio gũtirĩ o na ũmwe wamaingatithirie. ");
INSERT INTO kik_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakubu na andũ arĩa othe aarĩ nao magĩkinya Luzu (na nĩkuo Betheli), bũrũri-inĩ wa Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Agĩaka kĩgongona kũu, na agĩĩta handũ hau Eli-Betheli, tondũ hau nĩho Ngai aamwĩguũrĩirie rĩrĩa ooragĩra mũrũ wa nyina. ");
INSERT INTO kik_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nake Debora mũreri wa Rebeka agĩkua na agĩthikwo gĩtina-inĩ kĩa mũgandi mũhuro wa Betheli. Nĩ ũndũ ũcio handũ hau hagĩĩtwo Aloni-Bakuthu. ");
INSERT INTO kik_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Thuutha wa Jakubu gũcooka kuuma Padani-Aramu, Ngai akĩmuumĩrĩra rĩngĩ na akĩmũrathima. ");
INSERT INTO kik_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ngai akĩmwĩra atĩrĩ, “Rĩĩtwa rĩaku nĩ Jakubu, no ndũgũcooka gwĩtwo Jakubu rĩngĩ; ũrĩĩtagwo Isiraeli.” Nĩ ũndũ ũcio akĩmwĩta Isiraeli. ");
INSERT INTO kik_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nake Ngai akĩmwĩra atĩrĩ, “Niĩ nĩ niĩ Ngai Mwene-Hinya-Wothe; ciaranai na mũingĩhe. Rũrĩrĩ na gĩkundi kĩa ndũrĩrĩ nĩikoima harĩwe, na athamaki nĩmakoima mwĩrĩ-inĩ waku. ");
INSERT INTO kik_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Bũrũri ũrĩa niĩ ndaheire Iburahĩmu na Isaaka, o nawe nĩngakũhe guo, na nĩngaheana bũrũri ũyũ kũrĩ njiaro ciaku iria igooka thuutha waku.” ");
INSERT INTO kik_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hĩndĩ ĩyo Ngai akĩambata akĩmweherera kuuma handũ hau aamwaragĩria. ");
INSERT INTO kik_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakubu akĩhaanda gĩtugĩ kĩa ihiga handũ hau Ngai aarĩtie nake, agĩgĩitĩrĩria ndibei; agĩcooka agĩgĩitĩrĩria maguta. ");
INSERT INTO kik_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jakubu agĩĩta handũ hau Ngai aamwarĩirie Betheli. ");
INSERT INTO kik_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Thuutha ũcio Jakubu na andũ ake makiuma Betheli magĩthiĩ na mbere na rũgendo. Na matigairie hanini makinye Efiratha-rĩ, Rakeli akĩambĩrĩria kũrũmwo na agĩkorwo arĩ na thĩĩna mũingĩ mũno. ");
INSERT INTO kik_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Na tondũ aarĩ na thĩĩna mũingĩ mũno wa gũciara, mũmũciarithia akĩmwĩra atĩrĩ, “Tiga gwĩtigĩra, tondũ ũrĩ na kahĩĩ kangĩ.” ");
INSERT INTO kik_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Na atanatuĩkana, tondũ nĩ gũkua aakuaga, agĩtua kahĩĩ kau Beni-Oni. No ithe agĩgatua Benjamini. ");
INSERT INTO kik_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Nĩ ũndũ ũcio Rakeli agĩkua na agĩthikwo mũkĩra-inĩ wa njĩra ya gũthiĩ Efiratha (na nokuo Bethilehemu.) ");
INSERT INTO kik_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakubu akĩhaanda gĩtugĩ igũrũ rĩa mbĩrĩra yake, na nginya ũmũthĩ ũyũ gĩtugĩ kĩu nĩkĩo kĩonanagia mbĩrĩra ya Rakeli. ");
INSERT INTO kik_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isiraeli agĩthiĩ o na mbere na rũgendo na akĩamba hema yake mwena ũrĩa ũngĩ wa Migidali-Ederi. ");
INSERT INTO kik_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Hĩndĩ ĩyo Isiraeli aatũũraga bũrũri ũcio-rĩ, Rubeni agĩthiĩ, agĩkoma na Biliha, thuriya ya ithe, nake Isiraeli akĩigua ũhoro ũcio. Jakubu aarĩ na ariũ ikũmi na eerĩ: ");
INSERT INTO kik_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ariũ a Lea maarĩ: Rubeni irigithathi rĩa Jakubu, na Simeoni, na Lawi, na Juda, na Isakaru, na Zebuluni. ");
INSERT INTO kik_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ariũ a Rakeli maarĩ: Jusufu na Benjamini. ");
INSERT INTO kik_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ariũ a Biliha ndungata ya mũirĩtu ya Rakeli maarĩ: Dani na Nafitali. ");
INSERT INTO kik_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ariũ a Zilipa ndungata ya mũirĩtu ya Lea maarĩ: Gadi na Asheri. Acio nĩo maarĩ ariũ a Jakubu, arĩa aaciarĩirwo arĩ kũu Padani-Aramu. ");
INSERT INTO kik_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Na Jakubu agĩkinya mũciĩ kũrĩ ithe Isaaka kũu Mamure, hakuhĩ na Kiriathu-Ariba (nĩkuo Hebironi), kũrĩa Iburahĩmu na Isaaka maatũũrĩte. ");
INSERT INTO kik_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaaka aatũũrire muoyo mĩaka igana na mĩrongo ĩnana. ");
INSERT INTO kik_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Agĩcooka agĩtuĩkana agĩkua na agĩthikwo hamwe na andũ ao arĩa maakuĩte, arĩ mũkũrũ na arĩ na mĩaka mĩingĩ. Nao ariũ ake Esaũ na Jakubu makĩmũthika. ");
INSERT INTO kik_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Na rĩrĩ, ũyũ nĩguo ũhoro wa Esaũ (na nowe Edomu). ");
INSERT INTO kik_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaũ ahikirie atumia ake kuuma kũrĩ andũ-a-nja a Kaanani: Ada aarĩ mwarĩ wa Eloni ũrĩa Mũhiti, na Oholibama mwarĩ wa Ana ũrĩa warĩ mwarĩ wa Zibeoni ũrĩa Mũhivi, ");
INSERT INTO kik_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","o na ningĩ Basemathu ũrĩa warĩ mwarĩ wa Ishumaeli na mwarĩ wa nyina na Nebaiothu. ");
INSERT INTO kik_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada agĩciarĩra Esaũ Elifazu, na Basemathu agĩciara Reueli, ");
INSERT INTO kik_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","nake Oholibama agĩciara Jeushu, na Jalamu na Kora. Acio nĩo maarĩ ariũ a Esaũ, arĩa aaciarĩirwo kũu Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Na rĩrĩ, Esaũ akĩoya atumia ake na ariũ ake na airĩtu ake na andũ othe a nyũmba yake, o na mahiũ make na nyamũ iria ingĩ ciake, na indo ciothe iria aagĩte nacio kũu Kaanani, na agĩthiĩ bũrũri waraihanĩrĩirie na mũrũ wa nyina Jakubu. ");
INSERT INTO kik_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Indo ciao ciarĩ nyingĩ mũno ũndũ matangĩahotire gũikarania hamwe; bũrũri ũrĩa maatũũraga ndũngĩahotire kũmaigana eerĩ nĩ ũndũ wa mahiũ mao. ");
INSERT INTO kik_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Nĩ ũndũ ũcio Esaũ (na nowe Edomu) agĩthiĩ gũtũũra bũrũri wa irĩma wa Seiru. ");
INSERT INTO kik_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ũyũ nĩguo ũhoro wa Esaũ ithe wa andũ a Edomu kũu bũrũri-inĩ wa irĩma wa Seiru. ");
INSERT INTO kik_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Maya nĩmo marĩĩtwa ma ariũ a Esaũ: nĩ Elifazu, mũrũ wa Ada mũtumia wa Esaũ, na Reueli, mũrũ wa Basemathu mũtumia wa Esaũ. ");
INSERT INTO kik_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ariũ a Elifazu nĩ aya: nĩ Temani, na Omari, na Zefo, na Gatamu, na Kenazu. ");
INSERT INTO kik_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifazu mũrũ wa Esaũ o nake nĩ aarĩ na thuriya yetagwo Timina, ĩrĩa yamũciarĩire Amaleki. Acio nĩo maarĩ ariũ a mũrũ wa Ada mũtumia wa Esaũ. ");
INSERT INTO kik_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ariũ a Reueli nĩ aya: nĩ Nahathu, na Zera, na Shama, na Miza. Acio nĩo maarĩ ariũ a mũrũ wa Basemathu mũtumia wa Esaũ. ");
INSERT INTO kik_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ariũ a Esaũ arĩa aaciarĩirwo nĩ Oholibama mũtumia wake mwarĩ wa Ana ũrĩa warĩ mwarĩ wa Zibeoni: nĩ Jeushu, na Jalamu, na Kora. ");
INSERT INTO kik_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Nao aya nĩo maarĩ anene thĩinĩ wa njiaro cia Esaũ: Ariũ a Elifazu irigithathi rĩa Esaũ: Anene maarĩ Temani, na Omari, na Zefo, na Kenazu, ");
INSERT INTO kik_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","na Kora, na Gatamu, na Amaleki. Acio nĩo anene arĩa Elifazu aaciarĩire kũu Edomu; maarĩ a mũrũ wa Ada. ");
INSERT INTO kik_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ariũ a Reueli mũrũ wa Esaũ: Anene maarĩ Nahathu, na Zera, na Shama, na Miza. Aya nĩo anene arĩa Reueli aaciarĩire kũu Edomu; maarĩ a mũrũ wa Basemathu mũtumia wa Esaũ. ");
INSERT INTO kik_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ariũ a Oholibama mũtumia wa Esaũ: Anene maarĩ Jeushu, na Jalamu, na Kora. Aya nĩo anene arĩa maaciarirwo nĩ Oholibama mũtumia wa Esaũ mwarĩ wa Ana. ");
INSERT INTO kik_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Aya nĩo maarĩ ariũ a Esaũ (na nowe Edomu), na acio nĩo maarĩ anene ao. ");
INSERT INTO kik_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Aya nĩo maarĩ ariũ a Seiru ũrĩa Mũhori arĩa maatũũraga bũrũri ũcio: Lotani, na Shobali, na Zibeoni, na Ana, ");
INSERT INTO kik_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","na Dishoni, na Ezeri, na Dishani. Ariũ acio a Seiru nĩo maarĩ anene a Ahori kũu Edomu. ");
INSERT INTO kik_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ariũ a Lotani maarĩ: Hori, na Homani. Timina aarĩ mwarĩ wa nyina na Lotani. ");
INSERT INTO kik_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ariũ a Shobali maarĩ: Alivani, na Manahathu, na Ebali, na Shefo, na Onamu. ");
INSERT INTO kik_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ariũ a Zibeoni maarĩ: Aia, na Ana. Ũyũ nĩwe Ana ũrĩa wonire ithima cia maaĩ mahiũ werũ-inĩ rĩrĩa arĩithagia ndigiri cia ithe Zibeoni. ");
INSERT INTO kik_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ciana cia Ana ciarĩ: Dishoni, na Oholibama mwarĩ wa Ana. ");
INSERT INTO kik_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ariũ a Dishoni maarĩ: Hemudani, na Eshibani, na Itharani, na Cherani. ");
INSERT INTO kik_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ariũ a Ezeri maarĩ: Bilihani, na Zaavani, na Akani. ");
INSERT INTO kik_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ariũ a Dishani maarĩ Uzu, na Arani. ");
INSERT INTO kik_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Aya nĩo maarĩ anene a Ahori: nĩ Lotani, na Shobali, na Zibeoni, na Ana, ");
INSERT INTO kik_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","na Dishoni, na Ezeri, na Dishani. Acio nĩo maarĩ anene a Ahori, kũringana na ikundi ciao kũu bũrũri wa Seiru. ");
INSERT INTO kik_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Aya nĩo maarĩ athamaki arĩa maathamakaga Edomu o mbere ya Isiraeli gũtanagĩa na mũthamaki o na ũmwe: ");
INSERT INTO kik_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela mũrũ wa Beori nĩwe watuĩkire mũthamaki wa Edomu. Itũũra rĩake inene rĩetagwo Dinihaba. ");
INSERT INTO kik_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Rĩrĩa Bela aakuire, Jobabu mũrũ wa Zera wa kuuma Bozira agĩtuĩka mũthamaki ithenya rĩake. ");
INSERT INTO kik_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Rĩrĩa Jobabu aakuire, Hushamu wa kuuma bũrũri wa Atemani agĩtuĩka mũthamaki ithenya rĩake. ");
INSERT INTO kik_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Rĩrĩa Hushamu aakuire, Hadadi mũrũ wa Bedadi, ũrĩa wahootire Midiani kũu bũrũri wa Moabi, agĩtuĩka mũthamaki ithenya rĩake. Itũũra rĩake inene rĩetagwo Avithu. ");
INSERT INTO kik_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Rĩrĩa Hadadi aakuire, Samala wa kuuma Masereka agĩtuĩka mũthamaki ithenya rĩake. ");
INSERT INTO kik_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Rĩrĩa Samala aakuire, Shauli wa kuuma Rehobothu, kũu gũkuhĩ na Rũũĩ rwa Farati, agĩtuĩka mũthamaki ithenya rĩake. ");
INSERT INTO kik_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Rĩrĩa Shauli aakuire, Baali-Hanani mũrũ wa Akibori agĩtuĩka mũthamaki ithenya rĩake. ");
INSERT INTO kik_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Rĩrĩa Baali-Hanani mũrũ wa Akibori aakuire, Hadadi agĩtuĩka mũthamaki ithenya rĩake. Itũũra rĩake inene rĩetagwo Pau, na mũtumia wake eetagwo Mehetabeli mwarĩ wa Matiredi, ũrĩa warĩ mwarĩ wa Mezahabu. ");
INSERT INTO kik_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Aya nĩo maarĩ anene kuuma kũrĩ njiaro cia Esaũ, kũringana na marĩĩtwa mao, na mĩhĩrĩga, na ngʼongo ciao: Timina, na Aliva, na Jethethu, ");
INSERT INTO kik_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","na Oholibama, na Ela, na Pinoni, ");
INSERT INTO kik_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","na Kenazu, na Temani, na Mibizaru, ");
INSERT INTO kik_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","na Magidieli, na Iramu. Acio nĩo maarĩ anene a Edomu, kũringana na kũrĩa maatũũraga bũrũri-inĩ ũrĩa watuĩkĩte wao. Esaũ ũcio nĩwe warĩ ithe wa andũ a Edomu. ");
INSERT INTO kik_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakubu nĩatũũrire bũrũri-inĩ ũrĩa ithe aaikarĩte, nĩguo bũrũri wa Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ũyũ nĩguo ũhoro wa Jakubu. Jusufu arĩ mwanake mũnini wa mĩaka ikũmi na mũgwanja aarĩithagia mbũri marĩ na ariũ a ithe, na ariũ a Biliha, na ariũ a Zilipa, atumia a ithe, nake agĩtwarĩra ithe wao ũhoro mũũru ũkoniĩ ariũ a ithe. ");
INSERT INTO kik_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Na rĩrĩ, Isiraeli nĩendeete Jusufu gũkĩra ariũ arĩa angĩ ake othe, tondũ aamũciarire arĩ mũkũrũ; na nĩamũtumithĩirie kanjũ ya goro ngʼemie wega mũno. ");
INSERT INTO kik_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Na rĩrĩa ariũ a ithe moonire atĩ ithe nĩamwendete kũmakĩra-rĩ, makĩmũmena na matingĩamwarĩirie kiugo o na kĩmwe kĩega. ");
INSERT INTO kik_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ũtukũ ũmwe Jusufu nĩarootire kĩroto, na rĩrĩa eerire ariũ a ithe ũhoro wakĩo, makĩmũmena makĩria. ");
INSERT INTO kik_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Akĩmeera atĩrĩ, “Thikĩrĩriai ũhoro wa kĩroto gĩkĩ ndootete: ");
INSERT INTO kik_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tũrohaga itĩĩa cia ngano tũrĩ mũgũnda-inĩ, na o rĩmwe gĩtĩĩa gĩakwa kĩrehaanda na igũrũ, nacio itĩĩa cianyu irathiũrũrũkĩria gĩakwa, na irakĩinamĩrĩra.” ");
INSERT INTO kik_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ariũ a ithe makĩmũũria atĩrĩ, “Anga nĩũrenda gũtũthamakĩra? Anga ti-itherũ nĩũgatwatha?” Nao magĩkĩrĩrĩria kũmũmena nĩ ũndũ wa kĩroto kĩu gĩake, na nĩ ũndũ wa ciugo ciake. ");
INSERT INTO kik_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ningĩ Jusufu akĩroota kĩroto kĩngĩ, na akĩĩra ariũ a ithe ũhoro wakĩo. Akĩmeera atĩrĩ, “Thikĩrĩriai, nĩndĩrarootire kĩroto kĩngĩ, na ihinda rĩĩrĩ, ndĩrarootire riũa, na mweri, na njata ikũmi na ĩmwe ikĩnyinamĩrĩra.” ");
INSERT INTO kik_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Rĩrĩa eerire ithe o na ariũ a ithe ũhoro ũcio, ithe akĩmũkũma, akĩmũũria atĩrĩ, “Nĩ kĩroto kĩa mũthemba ũrĩkũ kĩu ũrotete? Anga nyũkwa, na niĩ, na ariũ a thoguo nĩtũgooka, na tũinamĩrĩre thĩ mbere yaku?” ");
INSERT INTO kik_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ariũ a ithe nĩmamũiguĩrĩire ũiru, no ithe agĩikara agĩĩciiragia ũhoro wa irooto icio. ");
INSERT INTO kik_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Na rĩrĩ, ariũ a ithe nĩmathiĩte kũrĩithia mbũri cia ithe wao gũkuhĩ na Shekemu, ");
INSERT INTO kik_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","nake Isiraeli akĩĩra Jusufu atĩrĩ, “O ta ũrĩa ũũĩ, ariũ a thoguo nĩmararĩithia mbũri gũkuhĩ na Shekemu. Ũka, nĩngũgũtũma kũrĩ o.” Nake akĩmũcookeria, akĩmwĩra atĩrĩ, “Ũguo noguo.” ");
INSERT INTO kik_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Nĩ ũndũ ũcio Isiraeli akĩmwĩra atĩrĩ, “Thiĩ ũkarore kana ariũ a thoguo marĩ o ho o wega, o ũndũ ũmwe na mbũri, na ũnjookerie ũhoro.” Nake akĩmũtũma kuuma Gĩtuamba-inĩ kĩa Hebironi. Rĩrĩa Jusufu aakinyire Shekemu, ");
INSERT INTO kik_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","mũndũ ũmwe akĩmuona akĩũrũũra mĩgũnda-inĩ, akĩmũũria atĩrĩ, “Nĩ kĩĩ ũracaria?” ");
INSERT INTO kik_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nake Jusufu agĩcookia atĩrĩ, “Nĩ ariũ a baba ndĩracaria. No ũnjĩĩre kũrĩa mararĩithia mbũri ciao?” ");
INSERT INTO kik_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mũndũ ũcio akĩmũcookeria atĩrĩ, “Nĩmoimĩte gũkũ. Ndĩraiguire makiuga atĩrĩ, ‘Rekei tũthiĩ Dothani.’ ” Nĩ ũndũ ũcio Jusufu akĩrũmĩrĩra ariũ a ithe, na akĩmakora hakuhĩ na Dothani. ");
INSERT INTO kik_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","No makĩmuona arĩ haraaya, na ataanakinya harĩa maarĩ, magĩciirĩra kũmũũraga. ");
INSERT INTO kik_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Makĩĩrana atĩrĩ, “Mũroti ũrĩa nĩokĩte! ");
INSERT INTO kik_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ũkai; rekei tũmũũrage na tũmũikie irima rĩmwe rĩa maya, na tuuge atĩ nĩ nyamũ njũru ĩmũrĩĩte. Nĩtũkĩone ũrĩa irooto icio ciake ikaahinga.” ");
INSERT INTO kik_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","No rĩrĩa Rubeni aiguire ũguo, akĩgeria kũhonokia Jusufu kuuma moko-inĩ mao. Akiuga atĩrĩ, “Rekei tũtige kũmũũraga. ");
INSERT INTO kik_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Mũtigaite thakame. Mũikiei irima-inĩ rĩĩrĩ rĩ gũkũ werũ-inĩ, no mũtikamwĩke ũũru.” Rubeni oigaga ũguo nĩgeetha amũhonokie kuuma kũrĩ o, nĩguo amũcookie kũrĩ ithe. ");
INSERT INTO kik_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Na rĩrĩa Jusufu aakinyire harĩ ariũ a ithe, makĩmũruta kanjũ yake ĩrĩa eekĩrĩte, o ĩrĩa yarĩ ya goro na ngʼemie wega mũno. ");
INSERT INTO kik_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Makĩmũnyiita, makĩmũikia irima rĩu. Na rĩrĩ, irima rĩu rĩarĩ rĩũmũ; rĩtiarĩ na maaĩ. ");
INSERT INTO kik_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Magĩcooka magĩikara thĩ kũrĩa irio ciao, magĩtiira maitho makĩona gĩkundi kĩnene kĩa Aishumaeli gĩgĩũka kiumĩte Gileadi. Ngamĩĩra ciao ciakuuithĩtio mahuti manungi wega, na ũbani, na ũũkĩ-wa-ngoma ũrĩa wĩtagwo manemane, na maikũrũkĩte mathiĩ matware indo icio Misiri. ");
INSERT INTO kik_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda akĩĩra ariũ a ithe atĩrĩ, “Nĩ uumithio ũrĩkũ tũkuona tũngĩũraga mũrũ wa ithe witũ na tũhithe gĩkuũ gĩake? ");
INSERT INTO kik_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Rekei tũmwenderie Aishumaeli aya, no tũtikamwĩke ũũru na moko maitũ, tondũ ũyũ nĩ mũrũ wa ithe witũ, tũrĩ a mũthiimo ũmwe na thakame o ĩmwe.” Nao ariũ a ithe magĩtĩkĩra. ");
INSERT INTO kik_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Nĩ ũndũ ũcio hĩndĩ ĩrĩa onjorithia acio Amidiani maahĩtũkagĩra hau, ariũ a ithe makĩruta Jusufu irima, na makĩmwendia cekeri mĩrongo ĩĩrĩ cia betha kũrĩ Aishumaeli acio, nao makĩmũtwara Misiri. ");
INSERT INTO kik_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rĩrĩa Rubeni aacookire irima-inĩ na akĩona atĩ Jusufu ndaarĩ ho, agĩtembũranga nguo ciake. ");
INSERT INTO kik_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Agĩcooka kũrĩ ariũ a ithe akĩmeera atĩrĩ, “Kamwana karĩa gatirĩ ho! Niĩ ngwĩka atĩa?” ");
INSERT INTO kik_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nao makĩoya kanjũ ya Jusufu, magĩthĩnja mbũri na magĩtobokia kanjũ ĩyo thĩinĩ wa thakame ĩyo. ");
INSERT INTO kik_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Magĩcooka makĩoya kanjũ ĩyo yagemetio, makĩmĩtwarĩra ithe wao makĩmwĩra atĩrĩ, “Kanjũ ĩno nĩ kũmĩona tũramĩonire. Mĩrore wega wone kana hihi nĩ kanjũ ĩrĩa ya mũrũguo.” ");
INSERT INTO kik_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Nake akĩmĩmenya, akiuga atĩrĩ, “Nĩ kanjũ ya mũrũ wakwa! Nyamũ njũru nĩĩmũrĩĩte. Ti-itherũ Jusufu nĩarĩkĩtie kũũragwo, agatambuurwo icunjĩ.” ");
INSERT INTO kik_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ningĩ Jakubu agĩtembũranga nguo ciake, agĩĩkĩra nguo ya ikũnia, na agĩcakaĩra mũriũ matukũ maingĩ. ");
INSERT INTO kik_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ariũ ake othe na airĩtu ake magĩũka kũmũhooreria, no akĩrega kũhoorerio, akiuga atĩrĩ, “Aca! Ngathiĩ mbĩrĩra kũrĩ mũrũ wakwa ngĩrĩraga.” Nĩ ũndũ ũcio ithe agĩthiĩ na mbere kũmũrĩrĩra. ");
INSERT INTO kik_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nao Amidiani acio makĩendia Jusufu kũu Misiri kũrĩ Potifaru, ũmwe wa anene a Firaũni, nake aarĩ mũrũgamĩrĩri wa arangĩri a Firaũni. ");
INSERT INTO kik_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ihinda-inĩ rĩu-rĩ, Juda agĩtiga ariũ a ithe agĩikũrũka agĩthiĩ gũikara na mũndũ wa Adulamu wetagwo Hira. ");
INSERT INTO kik_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Juda arĩ kũu agĩcemania na mwarĩ wa Mũkaanani wetagwo Shua. Akĩmũhikia na agĩkoma nake; ");
INSERT INTO kik_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","nake akĩgĩa nda na agĩciara kahĩĩ, gagĩtuuo Eri. ");
INSERT INTO kik_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Akĩgĩa nda ĩngĩ, agĩciara kahĩĩ kangĩ gagĩtuuo Onani. ");
INSERT INTO kik_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","O na ningĩ agĩciara kahĩĩ kangĩ, agĩgatua Shela. Aagaciarĩire kũu Chezibu. ");
INSERT INTO kik_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Maagimara Juda akĩgũrĩra Eri ũrĩa warĩ irigithathi rĩake, mũtumia wetagwo Tamaru. ");
INSERT INTO kik_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","No Eri, irigithathi rĩa Juda, aarĩ mwaganu maitho-inĩ ma Jehova; nĩ ũndũ ũcio Jehova akĩmũũraga. ");
INSERT INTO kik_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Nake Juda akĩĩra Onani atĩrĩ, “Koma na mũtumia wa mũrũ wa nyũkwa, ũmũhingĩrie ũrĩa wagĩrĩirwo nĩkũmwĩka ũrĩ mũrũ wa nyina na mũthuuri wake, nĩguo ũciarĩre mũrũ wa nyũkwa rũciaro.” ");
INSERT INTO kik_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Nake Onani nĩamenyaga atĩ rũciaro rũu rũtigatuĩka rwake; nĩ ũndũ ũcio o akoma na mũtumia wa mũrũ wa nyina, agaita mbeũ ya ũciari thĩ, nĩguo ndagaciarĩre mũrũ wa nyina rũciaro. ");
INSERT INTO kik_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ũndũ ũcio eekire warĩ mũũru maitho-inĩ ma Jehova; nĩ ũndũ ũcio o nake akĩũragwo nĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Juda akĩĩra Tamaru mũtumia wa mũriũ atĩrĩ, “Thiĩ ũtũũre ũrĩ wa ndigwa gwa thoguo mũciĩ nginya mũrũ wakwa Shela agimare.” Tondũ eeciiririe atĩrĩ, “O nake Shela ahota gũkua ta ariũ a nyina.” Nĩ ũndũ ũcio Tamaru agĩthiĩ gũtũũra mũciĩ gwa ithe. ");
INSERT INTO kik_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Thuutha wa ihinda iraaya, mũtumia wa Juda, mwarĩ wa Shua, agĩkua. Na kahinda ka macakaya gaathira na Juda athirwo nĩ kĩeha, akĩambata agĩthiĩ Timina kũrĩ andũ arĩa meenjaga ngʼondu ciake guoya, na agĩthiĩ hamwe na mũrata wake, Hira wa Adulamu. ");
INSERT INTO kik_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Na rĩrĩa Tamaru eerirwo atĩrĩ, “Ithe wa mũthuuriguo erekeire Timina kwenja ngʼondu ciake guoya,” ");
INSERT INTO kik_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","akĩruta nguo ciake cia mũtumia wa ndigwa, akĩĩhumbĩra na taama nginya ũthiũ nĩguo ndakae kũmenyeka, agĩikara thĩ itoonyero-inĩ rĩa Enaimu, rĩrĩa rĩarĩ njĩra-inĩ ya gũthiĩ Timina. Nĩgũkorwo nĩonire atĩ, o na gũtuĩka Shela aarĩ mũndũ mũgima, Juda ndaheanĩte Tamaru kũrĩ we atuĩke mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Rĩrĩa Juda aamuonire-rĩ, agĩĩciiria atĩ Tamaru aarĩ mũmaraya tondũ nĩehumbĩrĩte ũthiũ. ");
INSERT INTO kik_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Na tondũ ndooĩ atĩ aarĩ mũtumia wa mũriũ, agĩthiĩ harĩ we mũkĩra-inĩ wa njĩra, akĩmwĩra atĩrĩ, “Ũka, ĩtĩkĩra ngome nawe.” Mũtumia ũcio akĩmũũria atĩrĩ, “Na nĩ kĩĩ ũkũũhe nĩguo ngome nawe?” ");
INSERT INTO kik_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Juda akĩmũcookeria atĩrĩ, “Nĩngũgũtũmĩra koori kuuma rũũru-inĩ rwakwa.” Mũtumia ũcio akĩmũũria atĩrĩ, “Nĩũkũndigĩra kĩndũ gĩa kũrũgamĩrĩra kĩĩranĩro gĩaku nginya rĩrĩa ũgaakaneana?” ");
INSERT INTO kik_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Juda akĩmũũria atĩrĩ, “Ũkwenda ngũtigĩre kĩĩ gĩa kũrũgamĩrĩra?” Mũtumia ũcio akĩmũcookeria atĩrĩ, “Ndigĩra gĩcũhĩ kĩa rũũri rwaku na rũrigi rwakĩo, o na rũthanju rũu rũrĩ guoko-inĩ gwaku.” Nĩ ũndũ ũcio Juda agĩtigĩra mũtumia ũcio indo icio na agĩkoma nake; na Tamaru akĩgĩa nda yake. ");
INSERT INTO kik_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mũtumia ũcio aarĩkia gwĩthiĩra, akĩaũra taama wake, akĩĩhumba nguo ciake cia mũtumia wa ndigwa rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Rĩrĩa Juda atũmire mũratawe ũcio wa kũu Adulamu na koori nĩgeetha acookerio indo icio cia kũrũgamĩrĩra kuuma kũrĩ mũtumia ũcio-rĩ, ndaamuonire. ");
INSERT INTO kik_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Nake akĩũria andũ arĩa maatũũraga kũu atĩrĩ, “Arĩ ha mũmaraya ũrĩa ũraarĩ haha mũkĩra-inĩ wa njĩra ya gũthiĩ Enaimu?” Nao magĩcookia atĩrĩ, “Haha hatirĩ hakorwo na mũmaraya.” ");
INSERT INTO kik_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nĩ ũndũ ũcio agĩcooka kũrĩ Juda, akĩmwĩra atĩrĩ, “Niĩ ndinamuona. Hamwe na ũguo-rĩ, andũ arĩa matũũraga hau moigire atĩrĩ, ‘Haha hatirĩ hakorwo na mũmaraya.’ ” ");
INSERT INTO kik_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Nake Juda akiuga atĩrĩ, “Nĩakĩrekwo aikare na kĩrĩa arĩ nakĩo, kana tũtuĩke a gũthekererwo. Ningĩ-rĩ, nĩngũmũtũmĩire koori gaka, no ndũnamuona.” ");
INSERT INTO kik_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Thuutha wa mĩeri ĩtatũ, Juda akĩĩrwo atĩrĩ, “Tamaru mũtumia wa mũrũguo nĩehĩtie, akahũũra ũmaraya, na nĩ ũndũ ũcio arĩ na nda.” Juda akiuga atĩrĩ, “Mumiei mũmũrehe, acinwo akue!” ");
INSERT INTO kik_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Na rĩrĩa oimagio-rĩ, agĩtũma ndũmĩrĩri kũrĩ ithe wa mũthuuriwe, akĩmwĩra atĩrĩ, “Niĩ ndĩ na nda ya mũndũ ũrĩa mwene indo ici.” Agĩcooka akiuga atĩrĩ, “Ta rora kana no ũmenye nũũ mwene gĩcũhĩ gĩkĩ kĩ na mũhũũri, na rũrigi rũrũ, o na rũthanju rũrũ.” ");
INSERT INTO kik_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda agĩcimenya, na akiuga atĩrĩ, “Mũtumia ũyũ nĩ mũthingu kũngĩra; ekĩte ũguo nĩgũkorwo ndiamũheanire kũrĩ mũrũ wakwa Shela.” Juda ndaacookire gũkoma nake rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Rĩrĩa ihinda rĩake rĩakinyire rĩa gũciara-rĩ, kwarĩ na tũhĩĩ twĩrĩ twa mahatha nda yake. ");
INSERT INTO kik_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Na rĩrĩa aaciaraga-rĩ, kamwe gatuo gagĩcomora guoko; nake mũmũciarithia akĩoya uthi mũtune, akĩwoherera guoko-inĩ gwako, na akiuga atĩrĩ, “Ũyũ nĩwe woima mbere.” ");
INSERT INTO kik_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","No rĩrĩa aacookirie guoko na thĩinĩ, mũrũ wa nyina akiuma, nake mũciarithania akiuga atĩrĩ, “Githĩ nĩguo weturĩra njĩra!” Nake agĩtuuo Perezu. ");
INSERT INTO kik_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nake mũrũ wa nyina ũrĩa warĩ na uthi mũtune guoko-inĩ gwake akiuma, nake agĩtuuo Zera. ");
INSERT INTO kik_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Na rĩrĩ, Jusufu nĩaikũrũkirio o nginya bũrũri wa Misiri. Nake Potifaru, Mũmisiri ũmwe wa anene a Firaũni, na mũrũgamĩrĩri wa arangĩri a Firaũni, akĩmũgũra kuuma kũrĩ Aishumaeli arĩa maamũtwarĩte kũu. ");
INSERT INTO kik_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Nake Jehova aarĩ hamwe na Jusufu, nake akĩgaacĩra, na agĩtũũra nyũmba-inĩ ya Mũmisiri ũcio mwathi wake. ");
INSERT INTO kik_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Na rĩrĩa mwathi wake onire atĩ Jehova aarĩ hamwe nake, na atĩ Jehova nĩatũmĩte Jusufu agaacĩre maũndũ-inĩ mothe marĩa ekaga-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Jusufu agĩĩtĩkĩrĩka maitho-inĩ make na agĩtuĩka wa kũmũtungatĩra. Potifaru akĩmũtua mũrori wa nyũmba yake na akĩmwĩhokera ũmenyereri wa kĩrĩa gĩothe aarĩ nakĩo. ");
INSERT INTO kik_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Kuuma hĩndĩ ĩrĩa aamũtuire mũrori wa nyũmba yake na kĩrĩa gĩothe aarĩ nakĩo, Jehova akĩrathima nyũmba ya Mũmisiri ũcio nĩ ũndũ wa Jusufu. Kĩrathimo kĩa Jehova kĩarĩ igũrũ wa indo ciothe cia Potifaru, iria ciarĩ nyũmba o na iria ciarĩ mũgũnda. ");
INSERT INTO kik_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Nĩ ũndũ ũcio agĩtigĩra Jusufu indo ciothe iria aarĩ nacio acimenyagĩrĩre; rĩrĩa rĩothe Jusufu aarĩ mũrũgamĩrĩri-rĩ, Potifaru ndarũmbũyanagia na kĩndũ o nakĩ tiga o irio iria aarĩĩaga. Na rĩrĩ, Jusufu aarĩ mũthaka na wa mwĩrĩ mwega, ");
INSERT INTO kik_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","na thuutha wa ihinda, mũtumia wa mwathi wake akĩmwĩrirĩria, akĩmwĩra atĩrĩ, “Ũka ũkome na niĩ!” ");
INSERT INTO kik_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","No Jusufu akĩrega. Akĩmwĩra atĩrĩ, “Niĩ ndĩ mũrori-rĩ, mwathi wakwa ndarũmbũyanagia na kĩndũ o nakĩ kĩa nyũmba, indo iria ciothe arĩ nacio nĩanjĩĩhokeire ndĩcimenyagĩrĩre. ");
INSERT INTO kik_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Gũtirĩ mũndũ ũngĩ mũnene nyũmba ĩno ũngĩrĩte. Mwathi wakwa ndangirĩrĩirie kĩndũ o nakĩ, tiga wee wiki, tondũ ũrĩ mũtumia wake. Ndaakĩhota atĩa gwĩka ũndũ ta ũyũ wa waganu njĩhĩrie Ngai?” ");
INSERT INTO kik_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Na o na gũtuĩka nĩaringagĩrĩria Jusufu mũthenya o mũthenya akome nake-rĩ, Jusufu nĩaregire gũkoma nake o na kana gũkorwo hamwe nake. ");
INSERT INTO kik_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","No mũthenya ũmwe Jusufu nĩaingĩrire nyũmba kũruta wĩra wake, na gũtiarĩ ndungata o na ĩmwe ya nyũmba yarĩ kũu thĩinĩ. ");
INSERT INTO kik_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Mũtumia ũcio akĩnyiita nguo ya Jusufu, akĩmwĩra atĩrĩ, “Ũka ũkome na niĩ!” No Jusufu agĩtiga nguo yake guoko-inĩ kwa mũtumia ũcio, akiuma nyũmba akĩũra. ");
INSERT INTO kik_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Na rĩrĩa mũtumia ũcio onire atĩ Jusufu nĩatiga nguo yake guoko-inĩ gwake na oora-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","agĩĩta ndungata cia nyũmba yake, agĩciĩra atĩrĩ, “Ta kĩonei Mũhibirania ũyũ aarehirwo kũrĩ ithuĩ nĩgeetha atũnyarare! Egũũkĩte haha nĩguo akome na niĩ, na niĩ ndakaya. ");
INSERT INTO kik_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Na rĩrĩa aigua ngĩkaya ndeithio, aatiga nguo yake haha, oima nyũmba na oora.” ");
INSERT INTO kik_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nake agĩikara na nguo ĩyo nginya rĩrĩa mwathi wa Jusufu aainũkire. ");
INSERT INTO kik_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Nake mũtumia ũcio akĩmũhe rũgano rũu, akĩmwĩra atĩrĩ, “Ngombo ĩrĩa ya Mũhibirania, ĩrĩa watũreheire ĩgũũkĩte kũrĩ niĩ kũnyarara. ");
INSERT INTO kik_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","No rĩrĩa njugire mbu ndeithio, yatiga nguo ĩno harĩ niĩ, yoima nyũmba na yora.” ");
INSERT INTO kik_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Rĩrĩa mwathi wa Jusufu aiguire rũgano rũu aaheirwo nĩ mũtumia wake, rĩrĩa aamwĩrire, “Ũguo nĩguo ngombo yaku ĩnjĩkire,” agĩcinwo nĩ marakara. ");
INSERT INTO kik_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Nake mwathi wa Jusufu akĩnyiita Jusufu akĩmũikia njeera, kũndũ kũrĩa gwaikagio andũ arĩa oohe a mũthamaki. No hĩndĩ ĩyo Jusufu aarĩ kũu njeera-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Jehova aarĩ hamwe nake; akĩmũtuga na agĩtũma etĩkĩrĩke maitho-inĩ ma mũnene wa njeera. ");
INSERT INTO kik_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Nĩ ũndũ ũcio mũnene wa njeera agĩtua Jusufu mũrori wa arĩa othe moohetwo njeera, na agĩtuuo mũmenyereri wa maũndũ mothe marĩa meekagwo kũu. ");
INSERT INTO kik_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mũnene ũcio wa njeera ndaarũmbũyagia ũndũ o na ũmwe wa marĩa maamenyagĩrĩrwo nĩ Jusufu, tondũ Jehova aarĩ hamwe na Jusufu na akĩmũhe ũgaacĩru maũndũ-inĩ mothe marĩa ekaga. ");
INSERT INTO kik_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Thuutha ũcio-rĩ, mũndũ ũrĩa watwaragĩra mũthamaki ndibei, na mũndũ ũrĩa wathondekagĩra mũthamaki wa Misiri mĩgate-rĩ, makĩhĩtĩria mwathi wao, ũcio mũthamaki wa Misiri. ");
INSERT INTO kik_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Firaũni mũthamaki ũcio akĩrakario nĩ anene acio ake eerĩ, mũnene wa arĩa maamũtwaragĩra ndibei na mũnene wa arĩa maamũthondekagĩra mĩgate, ");
INSERT INTO kik_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","na akĩmahingĩrithia nyũmba ya mũnene wa arĩa arangĩri njeera, o ĩrĩa Jusufu oheetwo. ");
INSERT INTO kik_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mũnene wa arangĩri akĩmaneana kũrĩ Jusufu amarorage, nake Jusufu akĩmatungatĩra. Na thuutha wa gũikara kĩoho-inĩ kwa ihinda-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","o ũmwe wa acio eerĩ, ũrĩa watwaragĩra mũthamaki ndibei na mũthondeki wa mĩgate ya mũthamaki wa Misiri, o acio maahingĩirwo njeera, makĩroota irooto ũtukũ ũmwe, na o kĩroto kĩarĩ na mũtaũrĩre wakĩo. ");
INSERT INTO kik_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Rĩrĩa Jusufu aathiire kũrĩ o rũciinĩ rwa mũthenya ũyũ ũngĩ-rĩ, akĩona marĩ na kĩeha. ");
INSERT INTO kik_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Nĩ ũndũ ũcio akĩũria anene acio a Firaũni, o acio moohetwo hamwe nake nyũmba-inĩ ya mwathi wake, atĩrĩ, “Nĩ kĩĩ gĩtũmĩte mũtukie ithiithi cianyu ũmũthĩ?” ");
INSERT INTO kik_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nao makĩmũcookeria atĩrĩ, “Ithuĩ ithuerĩ nĩtũrotete irooto, na gũtirĩ mũndũ wa gũcitaũra.” Jusufu akĩmooria atĩrĩ, “Githĩ ũtaũri ti wa Ngai? Njĩĩrai irooto cianyu.” ");
INSERT INTO kik_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Nĩ ũndũ ũcio mũnene wa arĩa maatwaragĩra mũthamaki ndibei akĩĩra Jusufu kĩroto gĩake. Akĩmwĩra atĩrĩ, “Kĩroto-inĩ gĩakwa ndĩronire mũthabibũ ũrĩ mbere yakwa, ");
INSERT INTO kik_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","na ũraarĩ na honge ithatũ. Nacio iraaruta kĩro o ũguo iracanũka, nacio imanjĩka cia thabibũ irerua. ");
INSERT INTO kik_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na niĩ ndĩrakorwo nyiitĩte gĩkombe kĩa Firaũni na guoko, ndĩrooya thabibũ icio, ndĩraacihihĩra gĩkombe-inĩ kĩa Firaũni, na ndĩramũnengera.” ");
INSERT INTO kik_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jusufu akĩmwĩra atĩrĩ, “Ũtaũri wakĩo nĩ ũyũ: Honge icio ithatũ nĩ mĩthenya ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mĩthenya ĩtatũ ĩtanathira-rĩ, Firaũni nĩegũgũtũũgĩria na agũcookie wĩra-inĩ waku, na ũcooke kũnengagĩra Firaũni gĩkombe gĩake, o ta ũrĩa wekaga rĩrĩa warĩ mũmũhei ndibei. ");
INSERT INTO kik_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","No rĩrĩa maũndũ maku makaagaacĩra-rĩ, ũkandirikana ũnjiguĩre tha, ũngweete harĩ Firaũni, ũndute gũkũ njeera. ");
INSERT INTO kik_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tondũ nĩkũnyiitwo ndaanyiitirwo na hinya, ngĩrutwo bũrũri wa Ahibirania, na ningĩ o na gũkũ gũtirĩ ũndũ mũũru ndeekĩte wa gũtũma njikio njeera.” ");
INSERT INTO kik_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Na rĩrĩa mũnene wa arĩa athondeki mĩgate onire atĩ Jusufu nĩataũra kĩroto kĩu wega-rĩ, akĩĩra Jusufu atĩrĩ, “O na niĩ nĩndĩrarootete: Ndĩrakuuĩte ikabũ ithatũ cia mĩgate na mũtwe. ");
INSERT INTO kik_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Gĩkabũ kĩrĩa kĩrarigĩtie igũrũ kĩraarĩ na mĩgate ya mĩthemba yothe ĩthondekeirwo Firaũni; no nacio nyoni iramĩrĩĩaga ĩrĩ o gĩkabũ-inĩ ndĩgĩkuuĩte na mũtwe.” ");
INSERT INTO kik_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jusufu akĩmwĩra atĩrĩ, “Ũtaũri wakĩo nĩ ũyũ: Ikabũ icio ithatũ nĩ mĩthenya ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mĩthenya ĩtatũ ĩtanathira-rĩ, Firaũni nĩagagũtinithia mũtwe na akwambithie mũtĩ igũrũ. Nacio nyoni nĩikarĩa nyama cia mwĩrĩ waku.” ");
INSERT INTO kik_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Na rĩrĩ, mũthenya wa gatatũ warĩ wa kũririkana gũciarwo kwa Firaũni, nake akĩrugithĩria anene ake iruga inene. Nake akĩririkana mũnene wa arĩa maamũtwaragĩra ndibei na mũnene wa arĩa maamũthondekagĩra mĩgate mbere ya anene arĩa angĩ ake: ");
INSERT INTO kik_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Agĩcookia mũnene wa arĩa maamũtwaragĩra ndibei wĩra-inĩ wake, nĩgeetha acooke gũtwarĩra Firaũni gĩkombe rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","No rĩrĩ, mũnene wa arĩa maamũthondekagĩra mĩgate-rĩ, akĩmũcuria mũtĩ igũrũ o ta ũrĩa Jusufu aamerĩte ũtaũri-inĩ wake. ");
INSERT INTO kik_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","No mũnene ũcio wa arĩa maatwaragĩra Firaũni ndibei ndaigana kũririkana Jusufu; nĩariganĩirwo nĩwe. ");
INSERT INTO kik_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Na rĩrĩ, mĩaka ĩĩrĩ mĩgima yathira-rĩ, Firaũni akĩroota kĩroto: Akĩona arũgamĩte rũteere-inĩ rwa Rũũĩ rwa Nili; ");
INSERT INTO kik_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","na rĩrĩ, gũkiumĩra ngʼombe mũgwanja njega na noru kuuma thĩinĩ wa rũũĩ rũu, na igĩitĩka kũrĩa nyeki ithanjĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Thuutha wacio rĩ, hakiumĩra ngʼombe ingĩ mũgwanja, njongʼi na hĩnju, kuuma rũũĩ rũu rwa Nili, na ikĩrũgama mwena-inĩ harĩa icio ingĩ ciarũgamĩte hũgũrũrũ-inĩ cia rũũĩ. ");
INSERT INTO kik_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Na rĩrĩ, ngʼombe icio njongʼi na hĩnju ikĩrĩa ngʼombe iria mũgwanja njega na noru. Hĩndĩ ĩyo Firaũni akĩũrwo nĩ toro. ");
INSERT INTO kik_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ningĩ Firaũni agĩkoma rĩngĩ na akĩroota kĩroto gĩa keerĩ: Magira mũgwanja mega ma ngano, maiyũrĩte ngano, maakũraga kamũtĩ-inĩ kamwe ka ngano. ");
INSERT INTO kik_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Thuutha wamo gũgĩthethũka magira mangĩ mũgwanja ma ngano mahĩnju, mahaana ta macinĩtwo nĩ rũhuho rwa mwena wa irathĩro. ");
INSERT INTO kik_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Magira macio mahĩnju ma ngano makĩmeria magira marĩa mũgwanja maarĩ mega na maiyũrĩte ngano. Hĩndĩ ĩyo Firaũni akĩũrwo nĩ toro, agĩũkĩra agĩkora nĩ kũroota ekũrootaga. ");
INSERT INTO kik_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Rũciinĩ agĩtangĩka meciiria, na nĩ ũndũ ũcio agĩtũmanĩra andũ-ago othe na andũ arĩa oogĩ a Misiri. Firaũni akĩmeera irooto ciake, no gũtirĩ wao o na ũmwe wahotire kũmũtaũrĩra. ");
INSERT INTO kik_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Hĩndĩ ĩyo mũnene wa arĩa maamũtwaragĩra ndibei akĩĩra Firaũni atĩrĩ, “Ũmũthĩ nĩndaririkanio mahĩtia makwa. ");
INSERT INTO kik_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Hĩndĩ ĩmwe-rĩ, Firaũni nĩarakarĩtio nĩ ndungata ciake; na niĩ hamwe na mũnene wa arĩa athondeki mĩgate-rĩ, agĩtuohithia njeera nyũmba-inĩ ya mũnene wa arangĩri. ");
INSERT INTO kik_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ũtukũ ũmwe-rĩ, o ũmwe witũ akĩroota kĩroto, na o kĩroto kĩarĩ na ũtaũri wakĩo mwanya. ");
INSERT INTO kik_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Na rĩrĩ, kũu njeera twarĩ na mwanake Mũhibirania, ndungata ya mũnene wa arangĩri. Na ithuĩ tũkĩmwĩra irooto ciitũ, nake agĩtũtaũrĩra; akĩhe o mũndũ ũtaũri wa kĩroto gĩake. ");
INSERT INTO kik_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Namo maũndũ magĩkĩka o ta ũrĩa aatũtaũrĩire. Niĩ ngĩcookio wĩra-inĩ wakwa, nake mũndũ ũcio ũngĩ agĩcuurio mũtĩ igũrũ.” ");
INSERT INTO kik_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Nĩ ũndũ ũcio Firaũni agĩtũmanĩra Jusufu, nake akĩrutwo kũu njeera narua. Na aarĩkia kwĩyenja na kũruta nguo iria arĩ nacio na gwĩkĩra ingĩ-rĩ, agĩthiĩ mbere ya Firaũni. ");
INSERT INTO kik_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Nake Firaũni akĩĩra Jusufu atĩrĩ, “Ndĩrarootire kĩroto na gũtirĩ mũndũ ũrahota gũgĩtaũra. No nĩnjiguĩte gũkĩĩrwo atĩrĩ, wee ũngĩĩrwo kĩroto no ũhote gũgĩtaũra.” ");
INSERT INTO kik_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jusufu agĩcookeria Firaũni atĩrĩ, “Niĩ mwene ndingĩhota, no Ngai nĩekũhe Firaũni macookio marĩa arenda.” ");
INSERT INTO kik_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Hĩndĩ ĩyo Firaũni akĩĩra Jusufu atĩrĩ, “Kĩroto-inĩ gĩakwa-rĩ, ndĩrarũgamĩte hũgũrũrũ-inĩ cia Rũũĩ rwa Nili, ");
INSERT INTO kik_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","rĩrĩa haroimĩrire ngʼombe mũgwanja njega na noru kuuma rũũĩ, na iraitĩka kũrĩa kũu ithanjĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Thuutha wacio kũracooka kũroimĩra ngʼombe ingĩ mũgwanja hinyaru, njongʼi mũno na hĩnju. Ndirĩ ndona ngʼombe njongʼi ta icio bũrũri-inĩ wothe wa Misiri. ");
INSERT INTO kik_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nacio ngʼombe icio hĩnju na njongʼi irarĩa ngʼombe iria mũgwanja noru iria iroimĩrĩte mbere. ");
INSERT INTO kik_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","No rĩrĩ, o na ciarĩkia gũcirĩa-rĩ, gũtirĩ mũndũ ũngĩramenyire atĩ nĩirarĩĩte; tondũ ironekaga irĩ o njongʼi o ta mbere. Hĩndĩ ĩyo ndĩrokĩra. ");
INSERT INTO kik_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Ningĩ irooto-inĩ ciakwa-rĩ, nĩndĩronire magira mũgwanja mega ma ngano na maiyũrĩte ngano, magĩkũũra kamũtĩ-inĩ ka ngano. ");
INSERT INTO kik_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Thuutha wamo, magira mangĩ mũgwanja marathethũka, marĩ mahoohu na macinĩtwo nĩ rũhuho rwa mwena wa irathĩro. ");
INSERT INTO kik_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Namo magira macio mahĩnju marameria magira marĩa mũgwanja mega. Ndĩraheire andũ-ago ũhoro ũcio, no gũtirĩ o na ũmwe ũrahotire kũndaũrĩra irooto icio.” ");
INSERT INTO kik_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Nake Jusufu akĩĩra Firaũni atĩrĩ, “Irooto cia Firaũni cierĩ no kĩroto kĩmwe. Ngai nĩaguũrĩirie Firaũni ũrĩa akiriĩ gwĩka. ");
INSERT INTO kik_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ngʼombe iria mũgwanja njega nĩ mĩaka mũgwanja, na magira marĩa mũgwanja mega ma ngano nĩ mĩaka mũgwanja; kĩroto kĩu no kĩmwe. ");
INSERT INTO kik_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nacio ngʼombe icio mũgwanja hĩnju na njongʼi iria cioimĩrire thuutha nĩ mĩaka mũgwanja, na no taguo magira marĩa mũgwanja matarĩ ngano macinĩtwo nĩ rũhuho rwa mwena wa irathĩro: ĩyo nĩ mĩaka mũgwanja ya ngʼaragu. ");
INSERT INTO kik_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Na o ta ũrĩa ndeera Firaũni: Ngai nĩ oneetie Firaũni ũrĩa akiriĩ gwĩka. ");
INSERT INTO kik_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nĩgũgũkorwo na mĩaka mũgwanja ya bũthi mũnene bũrũri wothe wa Misiri, ");
INSERT INTO kik_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","no nĩgũgũcooka kũrũmĩrĩrwo nĩ mĩaka mũgwanja ya ngʼaragu. Naguo bũthi ũcio wothe wa Misiri nĩũkariganĩra, nayo ngʼaragu nĩĩkananga bũrũri ũyũ. ");
INSERT INTO kik_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Bũthi wa bũrũri ndũkaririkanwo, tondũ ngʼaragu ĩrĩa ĩgacooka kũgĩa nĩĩgakorwo ĩrĩ nene mũno. ");
INSERT INTO kik_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Gĩtũmi kĩa Firaũni aheo kĩroto kĩu maita meerĩ, nĩ tondũ Ngai nĩatuĩte nĩegwĩka ũndũ ũcio, na ekũwĩka o narua. ");
INSERT INTO kik_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Rĩu Firaũni nĩacarie mũndũ ũũĩ gũkũũrana maũndũ na mũndũ mũũgĩ, amũtue mũrũgamĩrĩri wa bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","O na ningĩ Firaũni nĩagĩthuure atabarĩri a bũrũri a kuoyaga gĩcunjĩ gĩa ithano kĩa magetha ma Misiri mĩaka-inĩ ĩyo mũgwanja ya bũthi. ");
INSERT INTO kik_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Nao nĩmacookanĩrĩrie irio icio ciothe cia mĩaka ĩyo mĩega ĩrooka, na ngano ĩyo ĩkorwo watho-inĩ wa Firaũni, ĩigwo matũũra-inĩ ĩrĩ irio. ");
INSERT INTO kik_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nacio irio icio ciagĩrĩire kũigwo irĩ mũthiithũ wa bũrũri, ikaahũthĩrwo hĩndĩ ĩrĩa ya mĩaka mũgwanja ya ngʼaragu ĩrĩa ĩkaagĩa Misiri, nĩgeetha bũrũri ndũkanathũkio nĩ ngʼaragu ĩyo.” ");
INSERT INTO kik_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Firaũni na anene ake makĩona mũbango ũcio ũrĩ mwega. ");
INSERT INTO kik_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Nĩ ũndũ ũcio Firaũni akĩmooria atĩrĩ, “No tuone mũndũ ũngĩ ta ũyũ, mũndũ ũrĩ na roho wa Ngai thĩinĩ wake?” ");
INSERT INTO kik_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Firaũni agĩkĩĩra Jusufu atĩrĩ, “Kuona atĩ Ngai nĩakũmenyithĩtie maũndũ maya mothe-rĩ, gũtirĩ mũndũ ũngĩ ũngĩkũũrana maũndũ na mũũgĩ ta we. ");
INSERT INTO kik_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Wee nĩwe ũkũrũgamĩrĩra nyũmba yakwa ya ũthamaki, na andũ akwa othe marĩathĩkagĩra watho waku. Ũndũ ngũgũkĩra naguo no atĩrĩ, niĩ nĩ niĩ Mũthamaki.” ");
INSERT INTO kik_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Nĩ ũndũ ũcio Firaũni akĩĩra Jusufu atĩrĩ, “Kuuma rĩu nĩndagũtua mũrũgamĩrĩri wa bũrũri wothe wa Misiri.” ");
INSERT INTO kik_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ningĩ Firaũni akĩruta gĩcũhĩ gĩake kĩa mũhũũri kuuma kĩara gĩake agĩgĩĩkĩra kĩara-inĩ kĩa Jusufu. Agĩcooka akĩmũhumba nguo cia gatani njega, na kĩrengeeri gĩa thahabu ngingo. ");
INSERT INTO kik_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ningĩ agĩtũma akuuo na ngaari yake ya ita, arĩ mũndũ wa keerĩ harĩ we wathani-inĩ, nao andũ magĩthiĩ makĩanagĩrĩra marĩ mbere yake atĩrĩ, “Eherai njĩra-inĩ!” Nĩ ũndũ ũcio Firaũni agĩtua Jusufu mũrũgamĩrĩri wa bũrũri wothe wa Misiri. ");
INSERT INTO kik_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ningĩ Firaũni akĩĩra Jusufu atĩrĩ, “Nĩ niĩ Firaũni, no rĩrĩ, hatarĩ na rũtha rwaku, gũtirĩ mũndũ ũgeeka ũndũ atarĩ na rũtha rwaku gũkũ Misiri guothe.” ");
INSERT INTO kik_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Nake Firaũni agĩĩta Jusufu Zafenathu-Panea, na akĩmũhe Asenathu mwarĩ wa Potifera, mũthĩnjĩri-ngai wa Onu, atuĩke mũtumia wake. Nake Jusufu agĩtuĩkania bũrũri wothe wa Misiri. ");
INSERT INTO kik_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jusufu aarĩ na mĩaka mĩrongo ĩtatũ rĩrĩa atoonyire ũtungata-inĩ wa Firaũni mũthamaki wa Misiri. Nake Jusufu akĩehera mbere ya Firaũni, agĩtuĩkania bũrũri wothe wa Misiri. ");
INSERT INTO kik_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Na rĩrĩ, ihinda rĩa mĩaka ĩyo mũgwanja ya bũthi, bũrũri ũcio ũgĩciara maciaro maingĩ mũno. ");
INSERT INTO kik_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Nake Jusufu agĩcookanĩrĩria irio ciothe cia bũrũri wa Misiri iria ciagĩire kuo mĩaka ĩyo mũgwanja ya bũthi, na agĩciigithia matũũra-inĩ marĩa manene. O itũũra inene akaiga irio iria ciakũragio mĩgũnda-inĩ ĩrĩa yarĩthiũrũrũkĩirie. ");
INSERT INTO kik_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Jusufu agĩkĩigithia ngano nyingĩ mũno, o ta mũthanga wa iria-inĩ; yarĩ nyingĩ mũno, o nginya agĩtiga kũiga maandĩko ma mũigana wayo tondũ ndĩngĩathimĩkire. ");
INSERT INTO kik_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mĩaka ya ngʼaragu ĩtaanakinya-rĩ, Jusufu nĩaciarĩirwo tũhĩĩ twĩrĩ nĩ Asenathu mwarĩ wa Potifera, mũthĩnjĩri-ngai wa Onu. ");
INSERT INTO kik_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jusufu agĩĩta irigithathi rĩake Manase, akiuga atĩrĩ, “Nĩ tondũ Ngai nĩatũmĩte ndiganĩrwo nĩ thĩĩna wakwa wothe na nyũmba ya baba yothe.” ");
INSERT INTO kik_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nako kahĩĩ ga keerĩ, agĩgeeta Efiraimu, akiuga atĩrĩ, “Nĩ tondũ Ngai nĩatũmĩte ngĩe na maciaro bũrũri-inĩ wa mĩnyamaro yakwa.” ");
INSERT INTO kik_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nayo mĩaka mũgwanja ya bũthi kũu Misiri ĩgĩthira, ");
INSERT INTO kik_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","na mĩaka mũgwanja ya ngʼaragu ĩkĩambĩrĩria, o ta ũrĩa Jusufu oigĩte. Kwarĩ na ngʼaragu mabũrũri-inĩ marĩa mangĩ mothe, no bũrũri wa Misiri wothe warĩ na irio. ");
INSERT INTO kik_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Na rĩrĩa andũ a Misiri othe maambĩrĩirie kũigua ngʼaragu-rĩ, magĩkaĩra Firaũni amahe irio. Nake Firaũni akĩmeera atĩrĩ, “Thiĩi kũrĩ Jusufu na mwĩke ũrĩa ekũmwĩra.” ");
INSERT INTO kik_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Rĩrĩa ngʼaragu yagĩire bũrũri wothe-rĩ, Jusufu akĩhingũra makũmbĩ ma irio, akĩenderia andũ a Misiri ngano, nĩgũkorwo ngʼaragu yarĩ nene mũno Misiri guothe. ");
INSERT INTO kik_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Namo mabũrũri mothe magĩũka Misiri kũrĩ Jusufu kũgũra ngano, tondũ ngʼaragu ĩyo yarĩ nene mũno thĩ yothe. ");
INSERT INTO kik_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Rĩrĩa Jakubu aamenyire atĩ Misiri nĩ kwarĩ na ngano, akĩĩra ariũ ake atĩrĩ, “Nĩ kĩĩ gĩtũmĩte mũikare o ro ũguo mũcũthanĩrĩirie?” ");
INSERT INTO kik_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Agĩthiĩ na mbere akĩmeera atĩrĩ, “Nĩnjiguĩte atĩ Misiri kũrĩ na ngano. Ikũrũkai kuo mũgatũgũrĩre irio, nĩgeetha tũtũũre muoyo tũtigakue.” ");
INSERT INTO kik_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Nao ariũ ikũmi a ithe na Jusufu magĩikũrũka, magĩthiĩ kũgũra ngano Misiri. ");
INSERT INTO kik_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","No Jakubu ndaatũmire Benjamini mũrũ wa nyina na Jusufu athiĩ na arĩa angĩ, tondũ nĩetigagĩra ndakone mũtino. ");
INSERT INTO kik_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nĩ ũndũ ũcio ariũ a Isiraeli magĩthiĩ marĩ hamwe na arĩa angĩ maathiĩte kũgũra ngano Misiri, tondũ bũrũri wa Kaanani o naguo warĩ na ngʼaragu. ");
INSERT INTO kik_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Na rĩrĩ, Jusufu nĩwe warĩ mwathi wa bũrũri wa Misiri na nĩwe wendagĩria andũ othe a bũrũri ngano. Nĩ ũndũ ũcio rĩrĩa ariũ a ithe maakinyire kuo-rĩ, makĩmũinamĩrĩra, magĩturumithia mothiũ mao thĩ. ");
INSERT INTO kik_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Na rĩrĩa Jusufu onire ariũ a ithe, o ro rĩmwe akĩmamenya, no agĩĩtua ndamooĩ na akĩmaarĩria arĩ na ũũru, akĩmooria atĩrĩ, “Mumĩte kũ?” Nao makĩmũcookeria atĩrĩ, “Tuumĩte bũrũri wa Kaanani tũgooka kũgũra irio.” ");
INSERT INTO kik_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","O na gũtuĩka Jusufu nĩamenyire ariũ a ithe-rĩ, o matiigana kũmũmenya. ");
INSERT INTO kik_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ningĩ akĩririkana irooto ciake iria aarootete imakoniĩ, akĩmeera atĩrĩ, “Inyuĩ mũrĩ athigaani! Mũũkĩte kũrora bũrũri witũ kũrĩa ũtarĩ mũgitĩre.” ");
INSERT INTO kik_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Nao makĩmũcookeria atĩrĩ, “Aca, mwathi witũ! Ndungata ciaku ciũkĩte o kũgũra irio tu. ");
INSERT INTO kik_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ithuĩ ithuothe tũrĩ ariũ a mũthuuri ũmwe. Ithuĩ ndungata ciaku tũrĩ andũ ehokeku, tũtirĩ athigaani.” ");
INSERT INTO kik_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Nake Jusufu akĩmeera atĩrĩ, “Aca! Mũũkĩte kũrora bũrũri witũ kũrĩa ũtarĩ mũgitĩre.” ");
INSERT INTO kik_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","No makĩmũcookeria atĩrĩ, “Ndungata ciaku ciarĩ andũ ikũmi na eerĩ, ariũ a mũthuuri ũmwe, ũrĩa ũtũũraga bũrũri wa Kaanani. Ũrĩa mũnini biũ nĩwe ũrĩ na baba rĩu, na ũmwe witũ ndarĩ ho.” ");
INSERT INTO kik_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Jusufu akĩmeera atĩrĩ, “No ta ũrĩa ndamwĩra: Inyuĩ mũrĩ athigaani! ");
INSERT INTO kik_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Na ũũ nĩguo mũkũmenyeka atĩ mũrĩ andũ a ma: Ti-itherũ, o ta ũrĩa Firaũni atũũraga muoyo-rĩ, mũtingiuma kũndũ gũkũ nginya ũrĩa mũnini wanyu oke. ");
INSERT INTO kik_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Tũmai ũmwe wanyu athiĩ agĩĩre mũrũ wa thoguo ũcio ũngĩ; inyuĩ aya angĩ nĩ mũgũikio njeera nĩgeetha ciugo cianyu icio mwarĩtie irorwo kana nĩ ũhoro wa ma. Mũngĩkorwo ũguo muugĩte tiguo-rĩ, o ta ũrĩa Firaũni atũũraga muoyo, inyuĩ mũrĩ athigaani!” ");
INSERT INTO kik_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nake akĩmaikia othe njeera, magĩikara kuo mĩthenya ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mũthenya wa ĩtatũ Jusufu akĩmeera atĩrĩ, “Tondũ ndĩ mwĩtigĩri Ngai-rĩ, ĩkai ũũ nĩguo mũtũũre muoyo: ");
INSERT INTO kik_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Angĩkorwo mũrĩ andũ ehokeku, ĩtĩkĩrai ũmwe wanyu aikare gũkũ njeera, na inyuĩ arĩa angĩ mũthiĩ mũtwarĩre andũ anyu ngano nĩ ũndũ wa ngʼaragu ĩrĩa marĩ nayo. ");
INSERT INTO kik_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","No rĩrĩ, no nginya mũndehere mũrũ wa thoguo ũcio mũnini biũ, nĩgeetha ciugo cianyu ciĩtĩkĩrĩke kũna atĩ nĩ cia ma, na nĩguo mũtigakue.” Nao magĩĩka o ũguo. ");
INSERT INTO kik_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Nao makĩĩrana atĩrĩ, “Ti-itherũ tũraherithio nĩ ũndũ wa mũrũ wa ithe witũ. Nĩtuonire ũrĩa aarĩ na thĩĩna rĩrĩa atũthaithaga tũhonokie muoyo wake, no tũkĩrega kũmũigua; na no kĩo tũnyiitĩtwo nĩ thĩĩna ũyũ.” ");
INSERT INTO kik_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni akĩmacookeria atĩrĩ, “Githĩ ndiamwĩrire mũtikehĩrie kamwana kau? No inyuĩ mũkĩrega gũũthikĩrĩria! Rĩu no nginya tũrĩhio thakame yake.” ");
INSERT INTO kik_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","No matiamenyaga atĩ Jusufu nĩaiguaga ũrĩa moigaga, tondũ we aatũmagĩra mũtabuti akĩmaarĩria. ");
INSERT INTO kik_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Jusufu akĩmahutatĩra akĩmeherera, akĩambĩrĩria kũrĩra; ningĩ agĩcooka agĩthiĩ akĩmaarĩria rĩngĩ. Akĩnyiitithia Simeoni akĩeherio harĩo na akĩohwo makĩonaga. ");
INSERT INTO kik_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Jusufu agĩathana makũnia mao maiyũrio ngano, na betha cia o mũndũ icookio ikũnia-inĩ rĩake, na maheo rĩĩgu wa rũgendo. Thuutha wa gwĩkĩrwo maũndũ macio, ");
INSERT INTO kik_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","makĩigĩrĩra ndigiri ciao mĩrigo ĩyo ya ngano na makiumagara. ");
INSERT INTO kik_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Harĩa maarũgamire mararĩrĩre-rĩ, ũmwe wao agĩtumũra ikũnia rĩake ahe ndigiri yake irio, nake akĩona betha ciake hau mũromo-inĩ wa ikũnia rĩake. ");
INSERT INTO kik_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Akĩĩra ariũ a ithe atĩrĩ, “Haiya, nĩnjookeirio betha ciakwa; ĩ ici haha ikũnia-inĩ rĩakwa.” Ngoro ciao ikĩnyiitwo nĩ ihooru na makĩrorana makĩinainaga, makĩũrania atĩrĩ, “Nĩ atĩa ũũ Ngai atwĩkĩte?” ");
INSERT INTO kik_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Na rĩrĩa maakinyire kũrĩ ithe wao Jakubu kũu bũrũri wa Kaanani-rĩ, makĩmwĩra maũndũ marĩa mothe monete. Makĩmwĩra atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mũndũ ũrĩa mwathi wa bũrũri ũcio aatwarĩirie na ũũru mũingĩ na agĩtũtua ta twathiĩte gũthigaana bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","No ithuĩ tũkĩmwĩra atĩrĩ, ‘Ithuĩ tũrĩ andũ ehokeku; tũtirĩ athigaani. ");
INSERT INTO kik_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Twarĩ andũ ikũmi na eerĩ, ariũ a mũthuuri ũmwe. Ũmwe ndarĩ ho, na ũrĩa mũnini biũ arĩ na ithe witũ kũu Kaanani.’ ");
INSERT INTO kik_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ningĩ mũndũ ũcio mwathi wa bũrũri agĩtwĩra atĩrĩ, ‘Gĩkĩ nĩkĩo gĩgũtũma menye kana mũrĩ andũ ehokeku: Ndigĩrai mũrũ wa thoguo ũmwe gũkũ, muoe irio mũthiĩ mũcitwarĩre andũ a nyũmba cianyu acio marĩ na ngʼaragu. ");
INSERT INTO kik_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","No mũndehere mũrũ wa thoguo ũrĩa mũnini biũ na noguo ngaamenya atĩ mũtirĩ athigaani, mũrĩ andũ ehokeku. Hĩndĩ ĩyo nĩngamũcookeria mũrũ wa thoguo, na nĩmũgetĩkĩrio kuonjorithagia bũrũri-inĩ ũyũ.’ ” ");
INSERT INTO kik_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Na rĩrĩa moonoragia makũnia mao-rĩ, o mũndũ agĩkora kĩohe kĩa betha ciake ikũnia-inĩ rĩake! Nao na ithe wao mona ciohe icio cia mbeeca, makĩmaka. ");
INSERT INTO kik_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ithe wao Jakubu akĩmeera atĩrĩ, “Mũrĩ kũũniinĩra ciana ciakwa. Jusufu ndarĩ ho, na Simeoni ndarĩ ho, na rĩu mũrenda kuoya Benjamini. Maũndũ maya mothe nĩ niĩ mokĩrĩire!” ");
INSERT INTO kik_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hĩndĩ ĩyo Rubeni akĩĩra ithe atĩrĩ, “Nĩũkooraga ariũ akwa eerĩ ingĩkaaga gũcookia Benjamini harĩwe. Reke akorwo ũmenyereri-inĩ wakwa, na nĩngamũcookia.” ");
INSERT INTO kik_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","No Jakubu akiuga atĩrĩ, “Mũrũ wakwa ndegũikũrũka athiĩ na inyuĩ; mũrũ wa nyina nĩ mũkuũ na nowe wiki ũtigarĩte. Angĩnyiitwo nĩ mũtino mũna rũgendo-inĩ rũu mũrathiĩ-rĩ, mwatũma mbuĩ ici ciakwa ithiĩ mbĩrĩra-inĩ na kĩeha.” ");
INSERT INTO kik_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Na rĩrĩ, ngʼaragu ĩyo ĩkĩneneha mũno bũrũri-inĩ wa Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Nĩ ũndũ ũcio rĩrĩa maarĩire ngano yothe ĩrĩa maagũrĩte Misiri ĩgĩthira-rĩ, ithe wao akĩmeera atĩrĩ, “Cookai Misiri rĩngĩ mũgatũgũrĩre irio ingĩ nini.” ");
INSERT INTO kik_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","No Juda akĩmwĩra atĩrĩ, “Mũndũ ũcio aatwĩhĩtĩire agĩtwĩra atĩrĩ, ‘Mũtikoona ũthiũ wakwa rĩngĩ tiga mũrũ wa thoguo ũcio ũngĩ akorirwo arĩ hamwe na inyuĩ.’ ");
INSERT INTO kik_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Akorwo nĩũgũtũtũma hamwe na mũrũ wa ithe witũ Benjamini, nĩtũgũikũrũka tũthiĩ tũkũgũrĩre irio. ");
INSERT INTO kik_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","No akorwo ndũkũmũtũma na ithuĩ, tũtigũikũrũka, tondũ mũndũ ũcio aatwĩrire atĩrĩ, ‘Mũtikoona ũthiũ wakwa rĩngĩ tiga no mũrũ wa thoguo akorirwo arĩ hamwe na inyuĩ.’ ” ");
INSERT INTO kik_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Nake Isiraeli akĩmooria atĩrĩ, Mwandehereire thĩĩna ũyũ nĩkĩ, na ũndũ wa kwĩra mũndũ ũcio atĩ nĩ mũrĩ na mũrũ wa ithe wanyu ũngĩ? ");
INSERT INTO kik_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Makĩmũcookeria atĩrĩ, “Mũndũ ũcio aatũũragia ciũria itũkoniĩ ithuĩ ene o na cia nyũmba ciitũ abarĩrĩire mũno. Agĩtũũria atĩrĩ, ‘Ithe wanyu arĩ o muoyo? Nĩ mũrĩ na mũrũ wa thoguo ũngĩ?’ Ithuĩ no gũcookia twacookagia ciũria ciake. Tũngĩamenyire atĩa atĩ no oige, ‘Thiĩi mũrehe mũrũ wa thoguo gũkũ?’ ” ");
INSERT INTO kik_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ningĩ Juda akĩĩra Isiraeli ithe atĩrĩ, “Njĩtĩkĩria thiĩ na kamwana gaka, na nĩtũgũthiĩ o ro rĩmwe, nĩgeetha wee na ithuĩ na ciana ciitũ tũtũũre muoyo, na tũtigakue. ");
INSERT INTO kik_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Niĩ mwene nĩngũmũrũgamĩrĩra wega; na nĩ niĩ ũkooria ũhoro wake. Ingĩkaaga kũmũcookia kũrĩ wee, na ndĩmũrũgamie mbere yaku-rĩ, nĩ ngaacookererwo nĩ ihĩtia rĩu matukũ ma muoyo wakwa wothe. ");
INSERT INTO kik_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ũrĩa kũrĩ nĩ atĩ, korwo tũtinatindĩrĩra ũhoro ũyũ tũngĩthiĩte rĩa keerĩ na tũgacooka.” ");
INSERT INTO kik_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Nake Isiraeli, ithe wao akĩmeera atĩrĩ, “Kũngĩkorwo no nginya athiĩ-rĩ, ĩkai ũũ: Ĩkĩrai maciaro marĩa mega mũno ma bũrũri ũyũ mondo-inĩ cianyu, mũikũrũkĩrie mũndũ ũcio marĩ kĩheo, na mahuti manini marĩa manungi wega na kaũũkĩ kanini, na ũbani na ũũkĩ-wa-ngoma ũrĩa wĩtagwo manemane, na njothi na rothi. ");
INSERT INTO kik_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Na mũkuue betha maita meerĩ, tondũ no nginya mũcookie betha iria ciacooketio mĩromo-inĩ ya makũnia manyu. No gũkorwo ũndũ ũcio wekirwo na mahĩtia. ");
INSERT INTO kik_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Oyai mũrũ wa thoguo o nake, mũcooke kũrĩ mũndũ ũcio o narua. ");
INSERT INTO kik_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nake Ngai Mwene-Hinya-Wothe arotũma mũiguĩrwo tha nĩ mũndũ ũcio, nĩgeetha etĩkĩre mũcooke na mũrũ wa thoguo wanyu ũcio ũngĩ o na Benjamini. Hakwa-rĩ, akorwo nĩ ngũkuĩrwo-rĩ, nĩ nguĩrwo.” ");
INSERT INTO kik_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Nĩ ũndũ ũcio andũ acio makĩoya iheo icio na betha maita meerĩ, na magĩthiĩ na Benjamini. Magĩikũrũka na ihenya Misiri na makĩĩneana kũrĩ Jusufu. ");
INSERT INTO kik_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Rĩrĩa Jusufu onire Benjamini arĩ hamwe nao-rĩ, akĩĩra mũnene wa nyũmba yake atĩrĩ, “Twara andũ aya gwakwa mũciĩ, ũthĩnje na ũthondeke irio cia mĩaraho; tondũ nĩ mekũrĩanĩra na niĩ mĩaraho.” ");
INSERT INTO kik_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nake mũndũ ũcio agĩĩka o ta ũrĩa Jusufu aamwĩrĩte, na akĩmatwara kwa Jusufu mũciĩ. ");
INSERT INTO kik_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nao andũ acio nĩmamakire maatwarwo gwake mũciĩ. Magĩĩciiria atĩrĩ, “Twarehwo gũkũ nĩ ũndũ wa betha iria ciacookirio makũnia-inĩ maitũ hĩndĩ ya mbere. Arenda gũtũtharĩkĩra atũtoorie na atũtue ngombo ciake, na oe ndigiri ciitũ.” ");
INSERT INTO kik_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tondũ ũcio makĩambata magĩthiĩ kũrĩ mũnene wa nyũmba ya Jusufu, makĩmwarĩria marĩ hau mũromo-inĩ wa nyũmba. ");
INSERT INTO kik_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Makĩmwĩra atĩrĩ, “Twagũthaitha mwathi witũ, nĩ tuokire gũkũ hĩndĩ ya mbere kũgũra irio. ");
INSERT INTO kik_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","No harĩa twarũgamire tũrarĩrĩre-rĩ, twatumũra makũnia maitũ o mũndũ agĩkora betha yake, o ũrĩa yoheetwo ĩrĩ mũromo-inĩ wa ikũnia. Nĩ ũndũ ũcio nĩ twacooka nacio. ");
INSERT INTO kik_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Na ningĩ nĩtuoka na betha ingĩ cia kũgũra irio. Tũtiũĩ nũũ wekĩrire betha ciitũ makũnia-inĩ maitũ.” ");
INSERT INTO kik_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Nake akĩmeera atĩrĩ, “Gũtirĩ na thĩĩna, tigai gwĩtigĩra. Ngai wanyu, o we Ngai wa ithe wanyu, nĩwe wamũheire kĩgĩĩna makũnia-inĩ manyu; betha cianyu nĩndacĩamũkĩire.” Agĩcooka akĩmarehera Simeoni. ");
INSERT INTO kik_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ningĩ mũnene ũcio wa nyũmba ya Jusufu akĩmatwara mũciĩ kwa Jusufu, akĩmahe maaĩ ma gwĩthamba magũrũ, na akĩhe ndigiri ciao gĩa kũrĩa. ");
INSERT INTO kik_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nao makĩhaarĩria iheo ciao cia kũhe Jusufu ooka mĩaraho, tondũ nĩmaiguĩte atĩ nĩmekũrĩa irio kuo. ");
INSERT INTO kik_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Rĩrĩa Jusufu ookire mũciĩ-rĩ, makĩmũhe iheo iria maarehete kũu nyũmba-inĩ, na makĩinamĩrĩra, magĩturumithia mothiũ mao thĩ mbere yake. ");
INSERT INTO kik_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nake akĩmahooya ũhoro, akĩmooria, “Mũkũrũ ũrĩa mwaheire ũhoro wake-rĩ, nĩ mũhoro? Arĩ o muoyo?” ");
INSERT INTO kik_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Makĩmũcookeria atĩrĩ, “Ndungata yaku ũcio ithe witũ arĩ o muoyo na ndarĩ na ũũru.” Nao makĩinamĩrĩra mamũhe gĩtĩĩo. ");
INSERT INTO kik_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Na aaroranga akĩona mũrũ wa nyina Benjamini, ũrĩa maaciaranĩirwo nake; akĩmooria atĩrĩ, “Ũyũ nĩwe mũrũ wa thoguo ũrĩa mũnini biũ, ũrĩa mwaheire ũhoro wake?” Agĩcooka akĩmwĩra atĩrĩ, “Mũrũ wakwa, Ngai arogũtuga.” ");
INSERT INTO kik_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Na rĩrĩ, aigua ta ekumwo nĩ ngoro nĩ kuona mũrũ wa nyina Benjamini-rĩ, Jusufu agĩkiuma na ihenya agĩthiĩ gũcaria handũ angĩrĩrĩra. Nake agĩthiĩ kanyũmba gake ga thĩinĩ akĩrĩrĩra kuo. ");
INSERT INTO kik_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Na aarĩkia gwĩthamba ũthiũ akiuma, akĩĩyũmĩrĩria, akiuga atĩrĩ, “Igai irio metha-inĩ.” ");
INSERT INTO kik_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Makĩigĩra Jusufu irio ciake arĩ wiki, na ariũ a ithe marĩ oiki, nao andũ a Misiri marĩ oiki, tondũ andũ a Misiri matingĩarĩanĩire na Ahibirania tondũ warĩ thaahu harĩo. ");
INSERT INTO kik_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Andũ acio maaikarĩtio mbere yake kũringana na ũkũrũ wao, kuuma irigithathi nginya ũrĩa warĩ mũnini biũ; nao makĩrorana o mũndũ na mũndũ nĩ kũgega. ");
INSERT INTO kik_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Rĩrĩa maihũrĩirwo irio kuuma metha-inĩ ya Jusufu-rĩ, rwĩga rwa Benjamini rwarĩ maita matano gũkĩra rwa arĩa angĩ. Nao makĩrĩa na makĩnyuuanĩra nake mategwĩtigĩra. ");
INSERT INTO kik_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nake Jusufu agĩatha mũnene wa nyũmba yake, akĩmwĩra atĩrĩ, “Iyũria makũnia ma andũ aya irio nyingĩ o ta ũrĩa mangĩhota gũkuua, na wĩkĩre betha ya mũndũ o mũndũ mũromo-inĩ wa ikũnia rĩake. ");
INSERT INTO kik_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ningĩ wĩkĩre gĩkombe gĩakwa kĩrĩa kĩa betha mũromo-inĩ wa ikũnia rĩa ũrĩa mũnini biũ wao, hamwe na betha cia ngano yake.” Nake mũnene ũcio agĩĩka o ũrĩa Jusufu aamwĩrire. ");
INSERT INTO kik_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Rũciinĩ gwakĩa-rĩ, andũ acio makiumagario hamwe na ndigiri ciao. ");
INSERT INTO kik_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Matanathiĩ kũraya na itũũra rĩu inene-rĩ, Jusufu akĩĩra mũnene wa nyũmba yake atĩrĩ, “Rũmĩrĩra andũ acio o rĩu, na wamakinyĩra ũmoorie atĩrĩ, ‘Mwarĩha wega na ũũru nĩkĩ? ");
INSERT INTO kik_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Githĩ gĩkombe gĩkĩ tikĩo mwathi wakwa anyuuaga nakĩo na akaragũra nakĩo? Ũndũ ũyũ mwĩkĩte nĩ ũndũ mũũru mũno.’ ” ");
INSERT INTO kik_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Na rĩrĩa aamakinyĩrire-rĩ, agĩcookera ciugo icio kũrĩ o. ");
INSERT INTO kik_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nao makĩmũũria atĩrĩ, “Mwathi witũ ekwaria maũndũ ta macio nĩkĩ? Ithuĩ ndungata ciaku tũroaga gwĩka ũndũ ta ũcio! ");
INSERT INTO kik_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ithuĩ o na nĩtũragũcookeirie betha iria twakorire mĩromo-inĩ ya makũnia maitũ kuuma bũrũri wa Kaanani; nĩ kĩĩ kĩngĩtũma tũiye betha kana thahabu kuuma nyũmba ya mwathi waku? ");
INSERT INTO kik_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ndungata o na ĩmwe yaku yakorwo ĩrĩ nakĩo-rĩ, no ĩgũkua, na ithuĩ aya angĩ tũtuĩke ngombo cia mwathi witũ.” ");
INSERT INTO kik_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Nake akiuga atĩrĩ, “Nĩ wega, nĩgũtuĩke o ũguo mwoiga. Ũrĩa ũgũkorwo nakĩo nĩwe ũgũtuĩka ngombo yakwa; inyuĩ arĩa angĩ mũtirĩ na ũcuuke.” ");
INSERT INTO kik_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","O mũndũ o mũndũ agĩikũrũkia ikũnia rĩake thĩ na ihenya na akĩrĩtumũra. ");
INSERT INTO kik_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Nake mũnene ũcio wa nyũmba ya Jusufu akĩambĩrĩria gũcaria gĩkombe, ambĩrĩirie harĩ ũrĩa mũkũrũ wao na akĩrĩkĩrĩria harĩ ũrĩa mũnini biũ. Nakĩo gĩkombe kĩu gĩkĩoneka ikũnia-inĩ rĩa Benjamini. ");
INSERT INTO kik_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Nao moona ũguo-rĩ, magĩtembũranga nguo ciao. Magĩcooka makĩhaicia mĩrigo yao ndigiri igũrũ magĩcooka na thuutha kũu itũũra-inĩ inene. ");
INSERT INTO kik_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Jusufu aarĩ o kũu nyũmba rĩrĩa Juda na ariũ a ithe maatoonyire kuo. Nao makĩĩgũithia thĩ mbere yake. ");
INSERT INTO kik_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jusufu akĩmooria atĩrĩ, “Nĩ ũndũ ũrĩkũ ũyũ mwĩkĩte? Kaĩ mũtooĩ atĩ mũndũ ta niĩ no ahote kũmenya maũndũ na njĩra ya ũragũri?” ");
INSERT INTO kik_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda akĩmũcookeria atĩrĩ, “Nĩ atĩa tũngĩĩra mwathi witũ? Tũngiuga atĩa? Tũngĩhota atĩa kuonania atĩ tũtiĩhĩtie? Ngai nĩwe ũguũrĩtie mahĩtia ma ndungata ciaku. Rĩu ithuĩ tũrĩ ngombo cia mwathi witũ, ithuothe ũndũ ũmwe na ũrĩa ũkorirwo na gĩkombe kĩu.” ");
INSERT INTO kik_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","No Jusufu akiuga atĩrĩ, “Ndĩroaga gwĩka ũndũ ta ũcio! Mũndũ ũrĩa ũkorirwo na gĩkombe kĩu nowe ũgũtuĩka ngombo yakwa. Inyuĩ aya angĩ, cookai kũrĩ ithe wanyu na thayũ.” ");
INSERT INTO kik_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","No Juda agĩthiĩ harĩ we, akiuga atĩrĩ, “Ndagũthaitha mwathi wakwa, ĩtĩkĩria ndungata yaku yarĩrie mwathi wakwa. Ndũkarakarĩre ndungata yaku o na gũtuĩka ũiganaine na Firaũni we mwene. ");
INSERT INTO kik_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mwathi wakwa, wee woririe ndungata ciaku atĩrĩ, ‘Nĩ mũrĩ ithe wanyu kana mũrũ wa thoguo wanyu ũngĩ?’ ");
INSERT INTO kik_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Na ithuĩ tũgĩgũcookeria atĩrĩ, ‘Tũrĩ na ithe witũ mũthuuri mũkũrũ mũno, na kũrĩ kamwana kanini aaciarĩirwo ũkũrũ-inĩ wake. Mũrũ-wa-nyina na kamwana kau nĩ mũkuũ, na nowe wiki wa ariũ a nyina ũtigarĩte, na ithe nĩamwendete mũno.’ ");
INSERT INTO kik_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Hĩndĩ ĩyo ũkĩĩra ndungata ciaku atĩrĩ, ‘Thiĩi mũmũikũrũkie mũmũrehe ndĩmwĩonere.’ ");
INSERT INTO kik_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Na ithuĩ tũkĩĩra mwathi witũ atĩrĩ, ‘Kamwana kau gatingiuma harĩ ithe; kangiuma harĩ we, ithe no gũkua angĩkua.’ ");
INSERT INTO kik_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","No wee werire ndungata ciaku atĩrĩ, ‘Tiga mũũkire na mũrũ wa thoguo ũcio mũnini biũ, mũtikoona ũthiũ wakwa rĩngĩ.’ ");
INSERT INTO kik_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na twainũka kũrĩ ndungata yaku ũcio ithe witũ, tũkĩmwĩra ũrĩa wee mwathi witũ woigĩte. ");
INSERT INTO kik_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ningĩ ithe witũ agĩtwĩra atĩrĩ, ‘Cookai, mũthiĩ mũgũre irio ingĩ nini.’ ");
INSERT INTO kik_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","No ithuĩ tũkĩmwĩra atĩrĩ, ‘Tũtingĩikũrũka kuo. No gũkorirwo nĩtũgũthiĩ na mũriũ waku ũyũ mũnini biũ. Tũtingĩona ũthiũ wa mũndũ ũcio tiga mũriũ waku ũyũ akorirwo na ithuĩ.’ ");
INSERT INTO kik_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Nayo ndungata yaku ũcio ithe witũ agĩtwĩra atĩrĩ, ‘Inyuĩ nĩmũũĩ atĩ mũtumia wakwa Rakeli aanjiarĩire ariũ eerĩ. ");
INSERT INTO kik_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ũmwe wacio nĩathiire na ndacooke, na niĩ ngiuga atĩrĩ, “Ti-itherũ nĩatambuurĩtwo nĩ nyamũ!” Na kuuma hĩndĩ ĩyo ndirĩ ndamuona rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mũngĩoya ũyũ ũngĩ nake akoone mũtino-rĩ, mwatũma mbuĩ ici ciakwa ithiĩ mbĩrĩra na kĩeha.’ ");
INSERT INTO kik_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Na rĩrĩ, kamwana gaka kangĩaga gũthiĩ na niĩ tũgacooka kũrĩ ndungata yaku ũcio baba, o baba ũcio muoyo wake wohanĩtio na muoyo wa kamwana gaka-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","oone atĩ kamwana gaka tũtirĩ nako, no gũkua agaakua. Ithuĩ ndungata ciaku tũgĩikũrũkie mbuĩ cia ithe witũ mbĩrĩra-inĩ na kĩeha. ");
INSERT INTO kik_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Niĩ ndungata yaku-rĩ, nĩnderutĩire kũrĩ baba gũkamenyerera. Ngiuga atĩrĩ, ‘Ingĩkaaga gũgacookia kũrĩ we-rĩ, nĩngacookererwo nĩ ihĩtia rĩĩrĩ ndĩ mbere ya baba, matukũ mothe ma muoyo wakwa!’ ");
INSERT INTO kik_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Na rĩu ndagũthaitha ũreke niĩ ndungata yaku ndigwo gũkũ nduĩke ngombo ya mwathi wakwa handũ ha kamwana gaka, na wĩtĩkĩrie kamwana gaka kainũke na ariũ a ithe. ");
INSERT INTO kik_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ingĩhota atĩa kũinũka kũrĩ baba itarĩ na kamwana gaka? Aca! Ndũkareke ngoone kĩeha kĩrĩa kĩngĩnyiita baba.” ");
INSERT INTO kik_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Hĩndĩ ĩyo Jusufu akĩremwo nĩ kwĩyũmĩrĩria mbere ya arĩa othe maamũtungataga, akĩanĩrĩra na mũgambo mũnene, akiuga atĩrĩ, “Andũ othe nĩmehere harĩ niĩ!” Tondũ ũcio, hatiarĩ mũndũ o na ũmwe warĩ na Jusufu rĩrĩa emenyithanirie kũrĩ ariũ a ithe. ");
INSERT INTO kik_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Na akĩrĩra anĩrĩire o nginya andũ a Misiri makĩmũigua, o na andũ a nyũmba ya Firaũni makĩigua ũhoro wa kĩrĩro kĩu. ");
INSERT INTO kik_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Jusufu akĩĩra ariũ a ithe atĩrĩ, “Nĩ niĩ Jusufu! Baba arĩ o muoyo?” No ariũ a ithe matiahotire kũmũcookeria, nĩgũkorwo nĩmamakĩte mũno marĩ mbere yake. ");
INSERT INTO kik_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ningĩ Jusufu akĩĩra ariũ a ithe atĩrĩ, “Ta nguhĩrĩriai.” Meeka ũguo-rĩ, akĩmeera atĩrĩ, “Nĩ niĩ mũrũ wa thoguo Jusufu, ũrĩa mwendirie Misiri! ");
INSERT INTO kik_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Na rĩu, mũtigathĩĩnĩke kana mwĩrakarĩre nĩkũnyendia gũkũ, tondũ nĩ Ngai wandũmire njũke mbere yanyu nĩgeetha honokie mĩoyo. ");
INSERT INTO kik_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Handũ-inĩ ha mĩaka ĩĩrĩ rĩu gũkoretwo na ngʼaragu bũrũri-inĩ, na mĩaka ĩtano ĩgũũka gũtigũkorwo na kũrĩma kana kũgetha. ");
INSERT INTO kik_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","No Ngai aandũmire mbere yanyu nĩguo ndũme matigari manyu matũũre gũkũ thĩ, na honokie mĩoyo yanyu na kũhonokania kũnene. ");
INSERT INTO kik_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Nĩ ũndũ ũcio-rĩ, ti inyuĩ mwandũmire gũkũ, no nĩ Ngai. Na nĩanduĩte ta ithe wa Firaũni, na mwathi wa nyũmba yake yothe o na mwathi wa bũrũri wothe wa Misiri. ");
INSERT INTO kik_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Na rĩu hiũhai mũcooke kũrĩ baba mũmwĩre atĩrĩ, ‘Ũũ nĩguo mũrũguo Jusufu ekuuga: Ngai nĩanduĩte mwathi wa bũrũri wa Misiri guothe. Ikũrũka ũũke kũrĩ niĩ; ndũgaikare. ");
INSERT INTO kik_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ũgũtũũra bũrũri wa Gosheni na ũkorwo ũrĩ hakuhĩ na niĩ, wee na ciana ciaku, na ciana cia ciana ciaku, na ndũũru ciaku cia mbũri na cia ngʼombe, na kĩrĩa gĩothe ũrĩ nakĩo. ");
INSERT INTO kik_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kũu nĩkuo ndĩrĩgũteithagĩria tondũ kũrĩ na mĩaka ĩngĩ ĩtano ya ngʼaragu ĩtigarĩte. Kwaga ũguo wee na nyũmba yaku na andũ arĩa othe makwĩgiĩ nĩmũgũtuĩka athĩĩnĩki.’ ");
INSERT INTO kik_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Inyuĩ nĩmũreyonera, o na Benjamini mũrũ wa maitũ akeyonera, atĩ nĩ niĩ mwene ndĩramwarĩria. ");
INSERT INTO kik_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Na mwĩre baba ũhoro wa gĩtĩĩo kĩrĩa gĩothe heetwo gũkũ Misiri, na ũrĩa wothe mwĩoneire, na mũikũrũkie baba gũkũ narua.” ");
INSERT INTO kik_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ningĩ akĩhĩmbĩria mũrũ wa nyina Benjamini na akĩrĩra, o nake Benjamini akĩmũhĩmbĩria akĩrĩraga. ");
INSERT INTO kik_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Na akĩmumunya ariũ a ithe othe na akĩmahĩmbĩria akĩrĩraga. Thuutha ũcio ariũ a ithe makĩaranĩria nake. ");
INSERT INTO kik_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Na rĩrĩa ũhoro ũcio waiguirwo nyũmba-inĩ ya ũthamaki ya Firaũni, atĩ ariũ a ithe na Jusufu nĩmokĩte-rĩ, Firaũni na anene ake othe magĩkena. ");
INSERT INTO kik_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Firaũni akĩĩra Jusufu atĩrĩ, “Ĩra ariũ a thoguo atĩrĩ, ‘Ĩkai ũũ: Igĩrĩrai nyamũ cianyu mĩrigo mũcooke bũrũri wa Kaanani, ");
INSERT INTO kik_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","na mũndehere ithe wanyu na andũ a nyũmba cianyu. Na niĩ nĩngamũhe kũndũ kũrĩa kwega mũno bũrũri-inĩ wa Misiri, na mũkenagĩre ũnoru wa bũrũri ũyũ.’ ");
INSERT INTO kik_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Ningĩ nĩwathĩrĩrio ũmeere atĩrĩ: ‘Ĩkai ũũ: Oyai makaari mamwe kuuma gũkũ Misiri nĩ ũndũ wa ciana na atumia anyu, mũgĩĩre ithe wanyu mũũke. ");
INSERT INTO kik_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Na mũtigatindanĩre na indo cianyu tondũ maũndũ mothe marĩa mega mũno ma Misiri megũtuĩka manyu.’ ” ");
INSERT INTO kik_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Nĩ ũndũ ũcio ariũ a Isiraeli magĩĩka o ro ũguo. Jusufu akĩmahe makaari o ta ũrĩa Firaũni aathanĩte na agĩcooka akĩmahe rĩĩgu wa rũgendo rwao. ");
INSERT INTO kik_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ningĩ akĩhe o mũndũ o mũndũ wao nguo njerũ, no Benjamini-rĩ, akĩmũhe betha magana matatũ, na nguo ithano cia kũgarũrĩra. ");
INSERT INTO kik_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na indo ici nĩcio aatũmĩire ithe: Ndigiri ikũmi ikuuĩte indo iria njega mũno cia Misiri, na ndigiri ingĩ ikũmi cia mĩgoma ikuuĩte ngano na mĩgate na rĩĩgu wake wa rũgendo. ");
INSERT INTO kik_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Agĩcooka akiumagaria ariũ a ithe, na magĩthiĩ akĩmeera atĩrĩ, “Mũtikanegenanie mũrĩ njĩra-inĩ!” ");
INSERT INTO kik_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Nĩ ũndũ ũcio makĩambata makiuma Misiri, magĩthiĩ magĩkinya kũrĩ ithe wao Jakubu kũu bũrũri-inĩ wa Kaanani. ");
INSERT INTO kik_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Nao makĩmwĩra atĩrĩ, “Jusufu arĩ o muoyo! Na nĩwe mwathi wa bũrũri wothe wa Misiri.” Jakubu akĩgegeara; akĩaga kũmetĩkia. ");
INSERT INTO kik_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","No rĩrĩa maamwĩrire maũndũ marĩa mothe Jusufu aamerĩte, na rĩrĩa onire makaari marĩa Jusufu aatũmĩte ma kũmũkuua mamũtware Misiri-rĩ, roho wa Jakubu ithe wao ũkĩarahũka. ");
INSERT INTO kik_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Nake Isiraeli akiuga atĩrĩ, “Nĩndetĩkia! Mũrũ wakwa Jusufu arĩ o muoyo. Nĩngũthiĩ ngamuone itanakua.” ");
INSERT INTO kik_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nĩ ũndũ ũcio Isiraeli akiumagara na indo ciothe iria aarĩ nacio, na aakinya Birishiba-rĩ, akĩrutĩra Ngai wa ithe Isaaka magongona. ");
INSERT INTO kik_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nake Ngai akĩarĩria Isiraeli na kĩoneki ũtukũ, akĩmwĩra atĩrĩ, “Jakubu! Jakubu!” Nake agĩcookia atĩrĩ, “Niĩ ũyũ haha.” ");
INSERT INTO kik_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ngai akiuga atĩrĩ, “Nĩ niĩ Ngai, Ngai wa thoguo. Ndũgetigĩre gũikũrũka ũthiĩ Misiri, tondũ nĩngagũtua rũrĩrĩ rũnene mũno kũu. ");
INSERT INTO kik_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","O na nĩngũikũrũkania nawe kũu Misiri, na ti-itherũ nĩ ngagũcookia gũkũ rĩngĩ. Nakuo guoko kwa Jusufu kuo kwene nĩkuo gũgaakũhinga maitho wakua.” ");
INSERT INTO kik_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hĩndĩ ĩyo Jakubu akiuma Birishiba, nao ariũ a Isiraeli magĩkuua ithe wao Jakubu na ciana ciao na atumia ao na makaari marĩa Firaũni aatũmĩte ma kũmũkuua. ");
INSERT INTO kik_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","O na ningĩ magĩthiĩ na mahiũ mao na indo iria ciothe maagĩĩte nacio marĩ kũu Kaanani, na Jakubu na rũciaro rwake ruothe magĩthiĩ Misiri. ");
INSERT INTO kik_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Aathiire Misiri na ariũ ake na tũmwana twa ariũ ake, agĩthiĩ na airĩtu ake na tũirĩtu twa airĩtu ake, ũguo nĩ kuuga rũciaro rwake ruothe. ");
INSERT INTO kik_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Maya nĩmo marĩĩtwa ma ariũ a Isiraeli (Jakubu na njiaro ciake) arĩa maathiire Misiri: Rubeni irigithathi rĩa Jakubu. ");
INSERT INTO kik_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ariũ a Rubeni maarĩ: Hanoku, na Palu, na Hezironi, na Karimi. ");
INSERT INTO kik_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ariũ a Simeoni maarĩ: Jemueli, na Jamini, na Ohadi, na Jakini, na Zoharu, na Shauli mũrũ wa mũtumia ũrĩa Mũkaanani. ");
INSERT INTO kik_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ariũ a Lawi maarĩ: Gerishoni, na Kohathu, na Merari. ");
INSERT INTO kik_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ariũ a Juda maarĩ: Eri, na Onani, na Shela, na Perezu, na Zera (no Eri na Onani nĩmakuĩrĩire bũrũri wa Kaanani.) Nao ariũ a Perezu maarĩ: Hezironi na Hamuli. ");
INSERT INTO kik_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ariũ a Isakaru maarĩ: Tola, na Puya, na Jashubu, na Shimuroni. ");
INSERT INTO kik_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ariũ a Zebuluni maarĩ: Seredi, na Eloni, na Jahaleeli. ");
INSERT INTO kik_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Acio nĩo ariũ arĩa Lea aaciarĩire Jakubu kũu Padani-Aramu, hamwe na mwarĩ Dina. Ariũ acio na airĩtu ake othe maarĩ mĩrongo ĩtatũ na atatũ. ");
INSERT INTO kik_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ariũ a Gadi maarĩ: Zifioni, na Hagi, na Shuni, na Eziboni, na Eri, na Arodi, na Areli. ");
INSERT INTO kik_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Nao Ariũ a Asheri maarĩ: Imuna, na Ishiva, na Ishivi, na Beria. Mwarĩ wa nyina aarĩ Sera. Ariũ a Beria maarĩ: Heberi na Malikieli. ");
INSERT INTO kik_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Icio nĩcio ciana iria ciaciarĩirwo Jakubu nĩ Zilipa, ũrĩa Labani aaheete mwarĩ Lea; ciothe ciarĩ ciana ikũmi na ithathatũ. ");
INSERT INTO kik_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ariũ a Rakeli mũtumia wa Jakubu maarĩ: Jusufu na Benjamini. ");
INSERT INTO kik_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Nake Jusufu arĩ kũu Misiri, nĩaciarĩirwo Manase na Efiraimu nĩ Asenathu mwarĩ wa Potifera, mũthĩnjĩri-ngai wa Onu. ");
INSERT INTO kik_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Nao ariũ a Benjamini maarĩ: Bela, na Bekeri, na Ashibeli, na Gera, na Naamani, na Ehi, na Roshu, na Mupimu, na Hupimu, na Aradi. ");
INSERT INTO kik_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Acio nĩo ariũ a Rakeli arĩa maaciarĩirwo Jakubu othe maarĩ andũ ikũmi na ana. ");
INSERT INTO kik_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Mũriũ wa Dani aarĩ: Hushimu. ");
INSERT INTO kik_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nao Ariũ a Nafitali maarĩ: Jahazeeli, na Guni, na Jezeri, na Shilemu. ");
INSERT INTO kik_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Acio nĩo ariũ arĩa maaciarĩirwo Jakubu nĩ Biliha ũrĩa Labani aaheete mwarĩ Rakeli, othe maarĩ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Andũ othe arĩa maathiire na Jakubu Misiri, arĩa maarĩ a njiaro ciake tũtegũtara atumia a ariũ ake, maarĩ andũ mĩrongo ĩtandatũ na atandatũ. ");
INSERT INTO kik_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Hamwe na ariũ arĩa eerĩ a Jusufu arĩa aaciarĩire Misiri, andũ a nyũmba ya Jakubu arĩa maathiire Misiri maarĩ mĩrongo mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nake Jakubu agĩtũma Juda athiĩ mbere yake kũrĩ Jusufu nĩgeetha athĩrĩrwo njĩra ya gũthiĩ Gosheni. Rĩrĩa maakinyire bũrũri wa Gosheni, ");
INSERT INTO kik_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jusufu akĩhaarĩria ngaari yake ya mbarathi, na agĩthiĩ Gosheni gũtũnga ithe Isiraeli. Na Jusufu aakinya o ũguo harĩ ithe, akĩmũhĩmbĩria na akĩrĩra ihinda inene. ");
INSERT INTO kik_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Nake Isiraeli akĩĩra Jusufu atĩrĩ, “Rĩu no ngĩkue, kuona atĩ nĩndeyonera niĩ mwene atĩ ũrĩ o muoyo.” ");
INSERT INTO kik_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hĩndĩ ĩyo Jusufu akĩĩra ariũ a ithe na andũ a nyũmba ya ithe atĩrĩ, Nĩngwambata thiĩ njarie na Firaũni, ndĩmwĩre atĩrĩ, Ariũ a baba, na nyũmba ya baba, arĩa maratũũraga bũrũri wa Kaanani, nĩmokĩte kũrĩ niĩ. ");
INSERT INTO kik_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Andũ acio nĩ arĩithi; marĩithagia mahiũ, na mokĩte na ndũũru ciao cia mbũri na cia ngʼombe, na indo ciothe ciao. ");
INSERT INTO kik_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Na rĩrĩa Firaũni arĩmwĩta na amũũrie atĩrĩ, “Inyuĩ mũrutaga wĩra ũrĩkũ?” ");
INSERT INTO kik_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mwagĩrĩirwo mũmũcookerie atĩrĩ, “Ithuĩ ndungata ciaku tũtũũraga tũrĩithagia mahiũ kuuma ũnini witũ, o ta ũrĩa maithe maitũ meekaga.” Hĩndĩ ĩyo nĩmũgetĩkĩrio mũtũũre mwena wa Gosheni, tondũ arĩithi othe moonagwo marĩ thaahu nĩ andũ a Misiri. ");
INSERT INTO kik_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jusufu agĩthiĩ akĩĩra Firaũni atĩrĩ, “Baba na ariũ a baba hamwe na ndũũru ciao cia mbũri na cia ngʼombe na indo ciao ciothe nĩmokĩte kuuma bũrũri wa Kaanani, na rĩu marĩ Gosheni.” ");
INSERT INTO kik_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ningĩ agĩthuura ariũ a ithe atano na akĩmatwara mbere ya Firaũni. ");
INSERT INTO kik_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firaũni akĩmooria atĩrĩ, “Mũrutaga wĩra ũrĩkũ?” Nao magĩcookeria Firaũni atĩrĩ, “Ithuĩ ndungata ciaku tũrĩ arĩithi, o ta ũrĩa maithe maitũ maarĩ.” ");
INSERT INTO kik_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ningĩ makĩmwĩra atĩrĩ, “Tũũkĩte gũikara gũkũ kwa ihinda, tondũ ngʼaragu ĩno nĩ nene kũu Kaanani, na ndũũru cia ndungata ciaku nĩ ciagĩte ũrĩithio. Nĩ ũndũ ũcio twagũthaitha wĩtĩkĩrie ndungata ciaku itũũre Gosheni.” ");
INSERT INTO kik_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Firaũni akĩĩra Jusufu atĩrĩ, “Thoguo na ariũ a thoguo mokĩte kũrĩ we, ");
INSERT INTO kik_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","na bũrũri wa Misiri ũrĩ mbere yaku; he thoguo na ariũ a thoguo mwena ũrĩa mwega mũno wa bũrũri ũyũ. Reke maikare Gosheni. Na rĩrĩ, angĩkorwo nĩũũĩ amwe ao marĩ na ũũgĩ wa mwanya-rĩ, matue arũgamĩrĩri a mahiũ makwa.” ");
INSERT INTO kik_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ningĩ Jusufu akĩrehe ithe Jakubu mbere ya Firaũni. Na Jakubu aarĩkia kũrathima Firaũni-rĩ, ");
INSERT INTO kik_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Firaũni akĩmũũria atĩrĩ, “Ũrĩ na mĩaka ĩigana?” ");
INSERT INTO kik_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Nake Jakubu akĩĩra Firaũni atĩrĩ, “Mĩaka yakwa ya kũũrũũra nĩ igana rĩmwe na mĩrongo ĩtatũ. Mĩaka yakwa ĩkoretwo ĩrĩ mĩnini na ya mĩtangĩko, na ndĩigana mĩaka ya kũũrũũra kwa maithe makwa.” ");
INSERT INTO kik_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jakubu agĩcooka akĩrathima Firaũni na akĩehera akiuma hau Firaũni aarĩ. ");
INSERT INTO kik_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Nĩ ũndũ ũcio Jusufu akĩhe ithe na ariũ a ithe ũtũũro kũu Misiri na akĩmahe mĩgũnda mwena ũrĩa mwega mũno wa bũrũri ũcio, rũgongo rwa Ramesese o ta ũrĩa Firaũni aathanĩte. ");
INSERT INTO kik_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ningĩ Jusufu nĩaheaga ithe na ariũ a ithe na andũ a nyũmba ya ithe othe irio kũringana na mũigana wa ciana ciao. ");
INSERT INTO kik_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Na rĩrĩ, gũtiarĩ irio mwena ũcio wothe, tondũ ngʼaragu yarĩ nene mũno; na Misiri na Kaanani cierĩ nĩ ciahinyĩrĩrĩkĩte nĩ ũndũ wa ngʼaragu ĩyo. ");
INSERT INTO kik_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Jusufu akĩũngania mbeeca iria ciothe ingĩonekire bũrũri wa Misiri na wa Kaanani, irĩ irĩhi rĩa ngano ĩrĩa andũ maagũraga, nake agĩcitwara nyũmba-inĩ ya ũthamaki ya Firaũni. ");
INSERT INTO kik_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Na rĩrĩa mbeeca cia andũ a Misiri na cia andũ a Kaanani ciathirire-rĩ, andũ a Misiri othe magĩthiĩ kũrĩ Jusufu, makĩmwĩra atĩrĩ, “Tũhe irio. Tũngĩgĩkua ũtwĩroreire nĩkĩ? Mbeeca ciitũ nĩithirĩte biũ.” ");
INSERT INTO kik_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Nake Jusufu akĩmacookeria atĩrĩ, “Ndeherai mahiũ manyu, na nĩngũmwenderia irio nĩ ũndũ wa mo tondũ mbeeca nĩ thiru.” ");
INSERT INTO kik_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Nĩ ũndũ ũcio magĩtwarĩra Jusufu mahiũ mao, nake akĩmakũũranĩria irio na mbarathi ciao, na ngʼondu na mbũri ciao, na ngʼombe na ndigiri ciao. Nake Jusufu akĩmateithĩrĩria mwaka ũcio wothe na irio, magĩcikũũrania na mahiũ mao mothe. ");
INSERT INTO kik_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Naguo mwaka ũcio wathira-rĩ, magĩũka kũrĩ we mwaka ũyũ ũngĩ, makĩmwĩra atĩrĩ, “Tũtingĩhota kũhitha mwathi witũ ũndũ, kuona atĩ mbeeca ciitũ nĩithirĩte, na mahiũ maitũ rĩu nĩ maku, na gũtirĩ kĩndũ gĩtigaire kĩa mwathi witũ tiga mĩĩrĩ iitũ na ithaka ciitũ. ");
INSERT INTO kik_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tũngĩgĩkua ũtwĩroreire nĩkĩ, ithuĩ na ithaka ciitũ hamwe? Tũgũranĩrie hamwe na ithaka ciitũ, ũtũhe irio, na ithuĩ na ithaka ciitũ tũtuĩke ngombo cia Firaũni. Tũhe mbeũ nĩgeetha tũtũũre muoyo, tũtigakue, na nĩguo bũrũri witũ ndũkanangĩke.” ");
INSERT INTO kik_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Nĩ ũndũ ũcio Jusufu akĩgũrĩra Firaũni bũrũri wothe wa Misiri. Nao andũ a Misiri makĩendia ithaka ciao, mũndũ o mũndũ, nĩ ũndũ ngʼaragu nĩyamahatĩrĩirie mũno. Naguo bũrũri wothe ũgĩtuĩka wa Firaũni. ");
INSERT INTO kik_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Nake Jusufu agĩgĩtua andũ ngombo kuuma mwena ũmwe wa Misiri nginya ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","No rĩrĩ, ndaigana kũgũra ithaka cia athĩnjĩri-ngai akuo, tondũ o maarĩ na igai maaheagwo nĩ Firaũni, na maarĩ na irio cia kũmaigana kuuma kũrĩ igai rĩu Firaũni aamaheaga. Kĩu nĩkĩo gĩatũmire mage kwendia ithaka ciao. ");
INSERT INTO kik_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Nake Jusufu akĩĩra andũ acio atĩrĩ, “Rĩu tondũ ũmũthĩ nĩndamũgũra hamwe na ithaka cianyu mũtuĩke a Firaũni-rĩ, mbeũ cianyu nĩcio ici; oyai mũkahaande mĩgũnda. ");
INSERT INTO kik_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","No rĩrĩa mũkaagetha, mũkaahe Firaũni gĩcunjĩ gĩa gatano. Icunjĩ icio ingĩ inya harĩ ithano no mwĩigĩre irĩ mbeũ cia kũhaanda na irio cianyu ene na cia nyũmba cianyu, na cia ciana cianyu.” ");
INSERT INTO kik_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Nao makiuga atĩrĩ, “Nĩwahonokia mĩoyo iitũ. Tũroogĩtĩkĩrĩka maitho-inĩ ma mwathi witũ; ithuĩ tũgũtũũra tũrĩ ngombo cia Firaũni.” ");
INSERT INTO kik_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nĩ ũndũ ũcio Jusufu akĩruta watho ũkoniĩ ithaka cia Misiri, na nĩũtũire nginya ũmũthĩ, atĩ gĩcunjĩ gĩa gatano kĩa magetha nĩ kĩa Firaũni. No ithaka cia athĩnjĩri-ngai akuo itaatuĩkire cia Firaũni. ");
INSERT INTO kik_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nao andũ a Isiraeli magĩtũũra Misiri bũrũri-inĩ wa Gosheni. Makĩgĩa na indo kuo na magĩciarana, makĩingĩha mũno. ");
INSERT INTO kik_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakubu aikarire Misiri mĩaka ikũmi na mũgwanja, nayo mĩaka yake ĩrĩa aatũũrire muoyo yarĩ mĩaka igana rĩmwe na mĩrongo ĩna na mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Na rĩrĩa ihinda rĩa Isiraeli rĩa gũkua rĩakuhĩrĩirie-rĩ, agĩtũmanĩra mũriũ wake Jusufu, akĩmwĩra atĩrĩ, “Angĩkorwo nĩnjĩtĩkĩrĩkĩte maitho-inĩ maku-rĩ, iga guoko gwaku rungu rwa kĩero gĩakwa, na ũnjĩĩre atĩ nĩũkanjĩka maũndũ ma ũtugi na ma wĩhokeku. Ndũkanaathike gũkũ Misiri, ");
INSERT INTO kik_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","no rĩrĩa ngaahurũka hamwe na maithe makwa, ũkanguua, ũndute Misiri, ũgaathike o harĩa mathikĩtwo.” Nake Jusufu akiuga atĩrĩ, “Nĩngeeka o ũguo woiga.” ");
INSERT INTO kik_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Nake Isiraeli akĩmwĩra atĩrĩ, “Wĩhĩte na mwĩhĩtwa.” Nake Jusufu akĩĩhĩta harĩ we na mwĩhĩtwa, nake Isiraeli akĩhooya enyiitĩrĩire mũthĩgi wake. ");
INSERT INTO kik_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Thuutha-inĩ ũcio Jusufu akĩĩrwo atĩrĩ, “Thoguo nĩ mũrũaru.” Nĩ ũndũ ũcio akĩoya ariũ ake eerĩ, Manase na Efiraimu, agĩthiĩ kũmũrora. ");
INSERT INTO kik_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Na rĩrĩa Jakubu eerirwo atĩrĩ, “Mũrũguo Jusufu nĩoka gũkuona,” Isiraeli akĩĩyũmĩrĩria, agĩikara thĩ ũrĩrĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakubu akĩĩra Jusufu atĩrĩ, “Ngai Mwene-Hinya-Wothe nĩanyumĩrĩire ndĩ Luzu bũrũri-inĩ wa Kaanani, na akĩndathima, ");
INSERT INTO kik_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","akĩnjĩĩra atĩrĩ, ‘Nĩngatũma ũciarane na ũingĩhe. Nĩngagũtua kĩrĩndĩ kĩa andũ, na nĩngaheana bũrũri ũyũ kũrĩ njiaro ciaku iria igooka thuutha waku ũtuĩke wacio tene na tene.’ ");
INSERT INTO kik_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Rĩu-rĩ, ariũ aku eerĩ arĩa maaciarĩirwo gũkũ Misiri itanooka kũrĩ we-rĩ, megũtuuo ta marĩ akwa; Efiraimu na Manase meegũtuĩka akwa, o ta ũrĩa Rubeni na Simeoni marĩ akwa. ");
INSERT INTO kik_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ciana iria ingĩ ũngĩciarĩrwo thuutha wao nĩ ciaku; kũrĩa makagaya mageetanagio na marĩĩtwa ma ariũ a ithe wao. ");
INSERT INTO kik_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Na rĩrĩa ndacookaga kuuma Padani, ngĩnyiitwo nĩ kĩeha gĩa gũkuĩrwo nĩ Rakeli kũu bũrũri-inĩ wa Kaanani tũrĩ o rũgendo-inĩ, hakuhĩ na Efiratha. Nĩ ũndũ ũcio ngĩmũthika hau mũkĩra-inĩ wa njĩra ya gũthiĩ Efiratha” (na nokuo Bethilehemu). ");
INSERT INTO kik_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Na rĩrĩa Isiraeli onire ariũ a Jusufu, akĩũria atĩrĩ, “Aya nĩ a?” ");
INSERT INTO kik_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jusufu akĩĩra ithe atĩrĩ, “Nĩ ariũ akwa arĩa Ngai aaheete ndĩ gũkũ”. Nake Isiraeli akiuga atĩrĩ, “Mareharehe harĩ niĩ ndĩmarathime.” ");
INSERT INTO kik_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Na rĩrĩ, maitho ma Isiraeli nĩmoorĩte nĩ gũkũra, na ndoonaga wega. Jusufu agĩkĩrehe ariũ ake hakuhĩ na Isiraeli, nake Jakubu akĩmamumunya na akĩmahĩmbĩria. ");
INSERT INTO kik_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isiraeli akĩĩra Jusufu atĩrĩ, “Ndieciragia nĩngona ũthiũ waku rĩngĩ, na rĩu Ngai nĩanjĩtĩkĩrĩtie nyone o na ciana ciaku.” ");
INSERT INTO kik_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nake Jusufu akĩmaruta maru-inĩ ma Isiraeli, akĩinamĩrĩria ũthiũ akĩũturumithia thĩ. ");
INSERT INTO kik_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Jusufu akĩoya ariũ ake eerĩ, Efiraimu arĩ mwena wake wa ũrĩo aamwerekeirie guoko-inĩ kwa ũmotho gwa Isiraeli, na Manase arĩ mwena wake wa ũmotho aamwerekeirie guoko-inĩ kwa ũrĩo gwa Isiraeli, akĩmarehe hakuhĩ nake. ");
INSERT INTO kik_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","No Isiraeli agĩtambũrũkia guoko gwake kwa ũrĩo agĩkũigĩrĩra mũtwe wa Efiraimu, o na gũtuĩka nĩwe warĩ mũnini, na akĩhĩtũkania moko make, akĩigĩrĩra guoko gwake kwa ũmotho mũtwe-inĩ wa Manase, o na gũtuĩka Manase nĩwe warĩ irigithathi. ");
INSERT INTO kik_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ningĩ akĩrathima Jusufu, akiuga atĩrĩ, “Ngai ũrĩa maithe makwa Iburahĩmu na Isaaka maatungatagĩra, Ngai ũrĩa ũkoretwo arĩ mũrĩithi wakwa mũtũũrĩre-inĩ wakwa wothe nginya ũmũthĩ, ");
INSERT INTO kik_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","na Mũraika ũrĩa ũũhonoketie kuuma mĩtino-inĩ yothe, arorathima imwana ici. Iroetanagio na rĩĩtwa rĩakwa, na ciĩtanagio na marĩĩtwa ma maithe makwa, Iburahĩmu na Isaaka, na maroingĩha mũno gũkũ thĩ.” ");
INSERT INTO kik_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Na rĩrĩa Jusufu onire atĩ ithe aigĩrĩire guoko gwake kwa ũrĩo mũtwe-inĩ wa Efiraimu-rĩ, ndaakenire; akĩnyiita guoko gwa ithe akweherie kuuma mũtwe-inĩ wa Efiraimu, akũigĩrĩre mũtwe-inĩ wa Manase. ");
INSERT INTO kik_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Jusufu akĩmwĩra atĩrĩ, “Aca, baba ũyũ nĩwe irigithathi; mũigĩrĩre guoko gwaku kwa ũrĩo mũtwe.” ");
INSERT INTO kik_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","No ithe akĩrega, akiuga atĩrĩ, “Nĩnjũũĩ ũguo mũrũ wakwa, nĩnjũũĩ. O nake nĩagatuĩka rũrĩrĩ, na nĩakaneneha. No rĩrĩ, mũrũ wa nyina ũrĩa mũnini nĩakaneneha kũmũkĩra, nacio njiaro ciake ituĩke gĩkundi kĩa ndũrĩrĩ.” ");
INSERT INTO kik_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Akĩmarathima mũthenya ũcio, akiuga atĩrĩ, “Isiraeli akaarathimanaga akĩgwetaga rĩĩtwa rĩaku akoiga atĩrĩ: ‘Ngai arotũma ũtuĩke o ta Efiraimu na Manase.’ ” Nĩ ũndũ ũcio akĩgweta Efiraimu mbere ya Manase. ");
INSERT INTO kik_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ningĩ Isiraeli akĩĩra Jusufu atĩrĩ, “Ndĩ hakuhĩ gũkua, no Ngai nĩegũkorwo hamwe na inyuĩ, na nĩakamũcookia bũrũri-inĩ wa maithe manyu. ");
INSERT INTO kik_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nawe, ũrĩ ta mwathi wa ariũ a thoguo-rĩ, nĩndakũhe rũgongo rwa bũrũri ũrĩa ndaatunyire Aamori na rũhiũ rwakwa rwa njora na ũta wakwa.” ");
INSERT INTO kik_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ningĩ Jakubu agĩtũmanĩra ariũ ake, akĩmeera atĩrĩ: “Cookanĩrĩrai haha nĩgeetha ndĩmwĩre ũrĩa gũgekĩka kũrĩ inyuĩ matukũ-inĩ marĩa magooka. ");
INSERT INTO kik_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ũnganai na mũthikĩrĩrie, inyuĩ ariũ a Jakubu; thikĩrĩriai Isiraeli ithe wanyu. ");
INSERT INTO kik_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rubeni, ũrĩ irigithathi rĩakwa, ũhoti wakwa, kĩonithania kĩa mbere kĩa hinya wakwa; ũkĩrĩte arĩa angĩ na gũtĩĩka, ũkamakĩra na hinya. ");
INSERT INTO kik_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Wagagĩte ta maaĩ, na nĩ ũndũ ũcio ndũgũcooka gũkĩra arĩa angĩ, tondũ nĩwahaicire ũrĩrĩ wa thoguo, ũgĩthaahia ũrĩrĩ wakwa. ");
INSERT INTO kik_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeoni na Lawi nĩ a nyina ũmwe, hiũ ciao cia njora nĩ indo cia mbaara cia ũhinya. ");
INSERT INTO kik_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ngoro yakwa ndũkanatoonye ndundu-inĩ yao, ndũkananyiitane na kĩũngano kĩao, nĩgũkorwo nĩmooragĩte andũ marakarĩte, na magatemanga ndegwa magũrũ macithuithie o ũrĩa mangĩendire. ");
INSERT INTO kik_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Marakara mao mahiũ mũno, na mangʼũrĩ mao matarĩ tha, maronyiitwo nĩ kĩrumi. Ngaamaharagania thĩinĩ wa Jakubu na ndĩmahurunjĩre thĩinĩ wa Isiraeli. ");
INSERT INTO kik_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, ariũ a thoguo nĩmagagũkumia; nakuo guoko gwaku nĩgũgatooria thũ ciaku; ariũ a thoguo nĩmagakũinamĩrĩra. ");
INSERT INTO kik_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, we ũrĩ kĩana kĩa mũrũũthi, mũrũ wakwa; we ũcookaga kuuma ũguĩmi-inĩ ũhũũnĩte ũguĩmi waku. O ta mũrũũthi-rĩ, ethunaga na agakoma thĩ, o ta mũrũũthi wa mũgoma-rĩ, nũũ ũngĩthĩgĩrĩria kũmwarahũra? ");
INSERT INTO kik_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Rũthanju rwa ũthamaki rũtikoima harĩ Juda, o na kana rũthanju rwa ũnene rũthenge gatagatĩ-inĩ ka magũrũ make, o nginya agooka ũrĩa mwene ruo, o we ũrĩa ũgaathĩkagĩrwo nĩ thĩ. ");
INSERT INTO kik_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Akoohagĩrĩra ndigiri yake mũthabibũ-inĩ, nayo njaũ yake ya ndigiri amĩohagĩrĩre rũhonge-inĩ rũrĩa rwega mũno. Agaathambagia nguo ciake na ndibei, na kanjũ ciake na ũtune wa thabibũ. ");
INSERT INTO kik_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Maitho make makaira gũkĩra ndibei, namo magego make merũhe gũkĩra iria. ");
INSERT INTO kik_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebuluni agaatũũra hũgũrũrũ-inĩ cia iria, na atuĩke handũ hega ha gũikaragwo nĩ marikabu; mĩhaka yake ĩgaakinya o Sidoni. ");
INSERT INTO kik_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakaru nĩ ndigiri ĩrĩa ĩrĩ hinya ĩkomete gatagatĩ ka mĩrigo ĩĩrĩ. ");
INSERT INTO kik_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Rĩrĩa akoona ũrĩa ũhurũko wake ũrĩ mwega, na ũrĩa bũrũri wake wagĩrĩte-rĩ, no rĩo akainamĩrĩria kĩande gĩake akuue mĩrigo, na etĩkĩre kũruta wĩra ũtarĩ mũcaara. ");
INSERT INTO kik_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani agaaciirĩrĩra andũ ake na kĩhooto, arĩ ta mũhĩrĩga ũmwe wa Isiraeli. ");
INSERT INTO kik_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dani agaatuĩka ta nyoka ĩrĩ mũkĩra-inĩ wa njĩra, atuĩke ta nduĩra ĩrĩ gacĩra-inĩ, ĩrĩa ĩrũmaga ndiira cia mbarathi, na tondũ ũcio mũmĩtwarithia akagũa na ngara. ");
INSERT INTO kik_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Wee Jehova-rĩ, njetereire kũhonokania gwaku. ");
INSERT INTO kik_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadi nĩagatharĩkĩrwo nĩ ikundi cia atunyani, nowe nĩagacitharĩkĩra aciingatithie. ");
INSERT INTO kik_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Irio cia Asheri nĩ cia kũguna mwĩrĩ; na akaaheanaga irio njega ingĩkenia mũthamaki. ");
INSERT INTO kik_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Nafitali nĩ ta thiiya ya mũgoma ĩrekereirio, ĩrĩa ĩciaraga tũthiiya tũthaka. ");
INSERT INTO kik_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Jusufu nĩ mũthabibũ ũrĩa ũciaraga, mũthabibũ ũrĩa ũciaraga ũrĩ hakuhĩ na gĩthima, ũrĩa honge ciaguo itambagĩrĩra rũthingo. ");
INSERT INTO kik_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Aikia a mĩguĩ nĩmamũtharĩkĩire marĩ na marũrũ; makĩmũikĩria mĩguĩ marĩ na ũũru mũingĩ. ");
INSERT INTO kik_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","No ũta wake ndwenyenyekire, moko make marĩ hinya magĩikara merũmĩtie nĩ ũndũ wa guoko kwa Mwene-Hinya wa Jakubu, na nĩ ũndũ wa Mũrĩithi, o we Ihiga rĩa Isiraeli, ");
INSERT INTO kik_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","nĩ ũndũ wa Ngai wa thoguo, ũrĩa ũgũteithagia, na tondũ wa Mwene-Hinya-Wothe, ũrĩa ũkũrathimaga na irathimo cia igũrũ, na irathimo cia kũrĩa kũriku mũhuro wa thĩ, o na irathimo cia nyondo na cia nda. ");
INSERT INTO kik_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Irathimo cia thoguo nĩ makĩria ma irathimo cia irĩma iria cia tene, na nĩ makĩria ma ũtonga wa tũrĩma tũrĩa tũkũrũ. Ici ciothe nĩirekwo ihurũke mũtwe-inĩ wa Jusufu, o thiithi-inĩ wa ũcio ũhaana ta mwana wa mũthamaki harĩ ariũ a ithe. ");
INSERT INTO kik_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamini ahaana ta njũũi ĩrĩa ngoroku; kĩroko-inĩ atambuuraga kĩrĩa aguĩmĩte, hwaĩ-inĩ akagayania kĩrĩa atahĩte.” ");
INSERT INTO kik_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ĩyo yothe nĩyo mĩhĩrĩga ĩrĩa ikũmi na ĩĩrĩ ya Isiraeli, na ũguo nĩguo ithe wao aameerire rĩrĩa aamarathimaga, akĩhe o mũndũ kĩrathimo kĩrĩa kĩamwagĩrĩire. ");
INSERT INTO kik_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ningĩ Jakubu akĩmahe mawatho maya: “Ndĩ hakuhĩ gũkua. Mũgaathika harĩa maithe makwa mathikĩtwo, ngurunga-inĩ ĩrĩa ĩrĩ gĩthaka-inĩ kĩa Efironi ũrĩa Mũhiti, ");
INSERT INTO kik_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ngurunga ĩrĩa ĩrĩ gĩthaka-inĩ kĩa Makipela hakuhĩ na Mamure kũu Kaanani, ĩrĩa Iburahĩmu aagũranĩirie na gĩthaka kĩu, ĩrĩ handũ ha gũthikana, kuuma kũrĩ Efironi ũrĩa Mũhiti. ");
INSERT INTO kik_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Hau nĩho Iburahĩmu na mũtumia wake Sara maathikirwo, na no ho Isaaka na Rebeka mũtumia wake maathikirwo, na no ho ndaathikire Lea. ");
INSERT INTO kik_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Gĩthaka kĩu na ngurunga ĩyo ciagũrirwo kuuma kũrĩ Ahethi.” ");
INSERT INTO kik_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nake Jakubu aarĩkia kũhe ariũ ake ũhoro ũcio-rĩ, agĩthuna magũrũ make arĩ o gĩtanda-inĩ, agĩtuĩkana, agĩcookanĩrĩrio kũrĩ andũ ao arĩa maakuĩte. ");
INSERT INTO kik_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nake Jusufu agĩkĩĩgũithia thĩ mbere ya ithe, akĩmũrĩrĩra na akĩmũmumunya. ");
INSERT INTO kik_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ningĩ agĩcooka agĩatha athondekani arĩa maarĩ ndungata ciake mathondeke mwĩrĩ wa ithe Isiraeli nĩguo ndũkabuthe. Nĩ ũndũ ũcio athondekani makĩmũthondeka, ");
INSERT INTO kik_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","handũ ha ihinda rĩa thikũ mĩrongo ĩna, tondũ rĩu nĩrĩo ihinda rĩrĩa rĩabatarainie rĩa kũũthondeka. Nao andũ a Misiri makĩmũcakaĩra matukũ mĩrongo mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Namo matukũ ma kũmũcakaĩra maathira-rĩ, Jusufu akĩĩra kĩama kĩa Firaũni atĩrĩ, “Angĩkorwo nĩnjĩtĩkĩrĩkĩte maitho-inĩ manyu-rĩ, njarĩrĩriai kũrĩ Firaũni. Mwĩrei atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Baba nĩatũmire ndĩĩhĩte na mwĩhĩtwa, akiuga atĩrĩ, “Ndĩ hakuhĩ gũkua; na ndakua ũgaathika mbĩrĩra-inĩ ĩrĩa niĩ mwene ndeyenjeire bũrũri-inĩ wa Kaanani.” Rĩu rekei nyambate thiĩ ngathike baba; na nĩngũcooka hũndũke.’ ” ");
INSERT INTO kik_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Nake Firaũni akĩmũtũmanĩra, akĩmwĩra atĩrĩ, “Ambata, ũthiĩ ũgathike thoguo, o ta ũrĩa aatũmire wĩhĩte.” ");
INSERT INTO kik_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Nĩ ũndũ ũcio Jusufu akĩambata agĩthiĩ gũthika ithe. Nao anene othe a Firaũni magĩthiĩ nake, andũ a gĩtĩĩo othe a kĩama kĩa Firaũni o na andũ arĩa atĩĩku a Misiri othe, ");
INSERT INTO kik_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","o hamwe na andũ othe a nyũmba ya Jusufu, na ariũ a ithe, na arĩa othe maarĩ a nyũmba ya ithe. No ciana ciki na ndũũru ciao cia mbũri na cia ngʼombe ciatigĩtwo Gosheni. ");
INSERT INTO kik_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Thigari cia ngaari cia ita na cia mbarathi o na cio igĩthiĩ nake. Kĩarĩ gĩkundi kĩnene mũno kĩa andũ. ");
INSERT INTO kik_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Nao maakinya ihuhĩro-inĩ rĩa ngano rĩa Atadi, hakuhĩ na Jorodani, makĩrĩra manĩrĩire marĩ na ruo; na hau Jusufu agĩcakaĩra ithe matukũ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Na rĩrĩa Akaanani arĩa maatũũraga kũu moonire macakaya macio hau ihuhĩro-inĩ rĩa ngano rĩa Atadi, makĩĩrana atĩrĩ, “Andũ a Misiri marĩ na igongona rĩa macakaya ma kĩeha.” Na nĩkĩo handũ hau hakuhĩ na Jorodani heetagwo Abeli-Miziraimu. ");
INSERT INTO kik_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nĩ ũndũ ũcio ariũ a Jakubu magĩĩka o ũrĩa aamaathĩte: ");
INSERT INTO kik_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Makĩmũkuua makĩmũtwara bũrũri wa Kaanani, na makĩmũthika ngurunga-inĩ ĩrĩa yarĩ gĩthaka-inĩ kĩa Makipela, hakuhĩ na Mamure, ĩrĩa Iburahĩmu aagũranĩirie na gĩthaka kĩu kĩrĩ handũ ha gũthikanwo kuuma kũrĩ Efironi ũrĩa Mũhiti. ");
INSERT INTO kik_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Thuutha wa gũthika ithe-rĩ, Jusufu agĩcooka Misiri hamwe na ariũ a ithe na arĩa othe maathiĩte nake gũthika ithe. ");
INSERT INTO kik_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Na rĩrĩa ariũ a ithe moonire atĩ ithe wao nĩakua, makiuga atĩrĩ, “Ĩ angĩkorwo Jusufu nĩatũũire atũiguagĩra ũũru, na atũrĩhie maũru marĩa mothe twamwĩkire?” ");
INSERT INTO kik_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Nĩ ũndũ ũcio magĩtũmana kũrĩ Jusufu makiuga atĩrĩ, “Thoguo atanakua nĩatigire oiga atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Ũũ nĩguo mũkeera Jusufu: ndagũthaitha ũrekere ariũ a thoguo mehia na mahĩtia marĩa meekire nĩ ũndũ nĩmagwĩkire ũũru mũno.’ Na rĩu twagũthaitha wohere ndungata cia Ngai wa thoguo mehia macio.” Na rĩrĩa ndũmĩrĩri yao yamũkinyĩire, Jusufu akĩrĩra. ");
INSERT INTO kik_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ariũ a ithe magĩcooka magĩthiĩ kũrĩ we, makĩĩgũithia thĩ mbere yake, makiuga atĩrĩ, “Tũrĩ ngombo ciaku.” ");
INSERT INTO kik_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","No Jusufu akĩmeera atĩrĩ, “Tigai gwĩtigĩra. Kaĩ niĩ akĩrĩ niĩ Ngai? ");
INSERT INTO kik_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Inyuĩ mwaciirĩte kũnjĩka ũũru, no Ngai aanjiirĩire ũndũ mwega nĩguo akinyanĩrie ũrĩa kũrekĩka rĩu, ũhoro wa kũhonokia mĩoyo ya andũ aingĩ. ");
INSERT INTO kik_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Nĩ ũndũ ũcio-rĩ, mũtigetigĩre. Nĩndĩĩmũheaga irio cianyu na cia ciana cianyu.” Nake akĩmomĩrĩria na akĩmarĩria wega. ");
INSERT INTO kik_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jusufu agĩikara Misiri, hamwe na andũ othe a nyũmba ya ithe. Aatũũrire muoyo mĩaka igana rĩmwe na ikũmi, ");
INSERT INTO kik_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","na akĩona rũciaro rwa gatatũ rwa ciana cia Efiraimu. O na ciana cia Makiru mũrũ wa Manase ciaciarwo nĩciaigĩrĩirwo maru-inĩ ma Jusufu. ");
INSERT INTO kik_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ningĩ Jusufu akĩĩra ariũ a ithe atĩrĩ, “Ndĩ hakuhĩ gũkua. No rĩrĩ, ti-itherũ Ngai nĩagooka kũmũrora amũteithie na amũrute kuuma bũrũri ũyũ, amũtware bũrũri ũrĩa erĩire Iburahĩmu, na Isaaka na Jakubu na mwĩhĩtwa.” ");
INSERT INTO kik_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Nake Jusufu agĩtũma ariũ a Isiraeli mehĩte na mwĩhĩtwa, akĩmeera atĩrĩ, “Ti-itherũ Ngai nĩagooka kũmũteithia, na hĩndĩ ĩyo yakinya no nginya mũgaakuua mahĩndĩ makwa kuuma kũndũ gũkũ.” ");
INSERT INTO kik_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nĩ ũndũ ũcio Jusufu agĩkua, arĩ na ũkũrũ wa mĩaka igana rĩmwe na ikũmi. Thuutha wa kũmũthondeka ndakabuthe, makĩmũiga ithandũkũ-inĩ rĩa gũthikwo narĩo o kũu Misiri.");
INSERT INTO kik_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Maya nĩmo marĩĩtwa ma ariũ a Isiraeli arĩa maathiire bũrũri wa Misiri hamwe na Jakubu, o mũndũ na andũ a nyũmba yake: ");
INSERT INTO kik_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Nao nĩ Rubeni, na Simeoni, na Lawi, na Juda; ");
INSERT INTO kik_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakaru, na Zebuluni na Benjamini; ");
INSERT INTO kik_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani na Nafitali; Gadi na Asheri. ");
INSERT INTO kik_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Njiaro cia Jakubu ciothe ciarĩ mĩrongo mũgwanja; nowe Jusufu, aarĩ bũrũri wa Misiri o na mbere ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Na rĩrĩ, Jusufu na ariũ a ithe othe, na rũciaro rũu ruothe rwa ihinda rĩu magĩkua, ");
INSERT INTO kik_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","no andũ a Isiraeli magĩciarana na makĩingĩha mũno, magĩtuĩka aingĩ makĩria, o nginya makĩiyũra bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Na rĩrĩ, mũthamaki ũngĩ ũtooĩ ũhoro wa Jusufu akĩambĩrĩria gũthamaka kũu bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Nake akĩĩra andũ ake atĩrĩ, “Onei, andũ a Isiraeli nĩmaingĩhĩte mũno makĩria, magatũkĩria hinya. ");
INSERT INTO kik_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Gĩũkei, no nginya tũmathiĩ na wara nĩguo matikae kũingĩha mũno gũkĩra ũũ, tondũ kũngĩgĩa mbaara, no manyiitane na thũ ciitũ na marũe na ithuĩ, na macooke moore moime bũrũri ũyũ.” ");
INSERT INTO kik_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nĩ ũndũ ũcio andũ a Misiri makĩmaigĩra arori a ngombo mamahinyĩrĩrie na ũndũ wa kũmarutithia wĩra wa hinya, nao andũ a Isiraeli magĩaka Pithomu na Ramesese marĩ matũũra manene ma kũigwo indo cia Firaũni. ");
INSERT INTO kik_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","No o ũrĩa maathiire na mbere kũhinyĩrĩrio-rĩ, noguo maaciaranire na makĩiyũra bũrũri-inĩ ũcio; nĩ ũndũ ũcio andũ a Misiri makĩambĩrĩria gwĩtigĩra andũ a Isiraeli mũno, ");
INSERT INTO kik_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","na makĩmahinyĩrĩria na wĩra matekũmaiguĩra tha. ");
INSERT INTO kik_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Andũ a Misiri magĩtũma mũtũũrĩre wa andũ a Isiraeli ũgĩe na ruo rũkĩru nĩ ũndũ wa wĩra mũritũ wa gũthondeka maturubarĩ na thimiti, hamwe na mawĩra ma mĩthemba yothe mĩgũnda-inĩ; andũ a Misiri maamahinyagĩrĩria matekũmaiguĩra tha mawĩra-inĩ mao mothe. ");
INSERT INTO kik_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mũthamaki wa bũrũri wa Misiri akĩĩra Shifira na Pua, aciarithania arĩa maateithagia atumia a Ahibirania, atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Rĩrĩa mũrĩteithagia atumia a Ahibirania makĩgĩa ciana, na mwamarora marĩ gĩtanda-inĩ gĩa kũgĩĩra mwana-rĩ, mũngĩona nĩ kahĩĩ kooragei, no kangĩkorwo karĩ kairĩtu, mũkareka gatũũre muoyo.” ");
INSERT INTO kik_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Na rĩrĩ, aciarithania acio tondũ nĩmetigĩrĩte Ngai, matiigana gwĩka ũrĩa mũthamaki wa bũrũri wa Misiri aamerĩte meke; makĩreka tũhĩĩ tũu tũtũũre muoyo. ");
INSERT INTO kik_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Nake mũthamaki ũcio wa bũrũri wa Misiri agĩĩta aciarithania acio, akĩmooria atĩrĩ, “Mwĩkĩte ũũ nĩkĩ? Nĩ kĩĩ gĩtũmĩte mũreke tũhĩĩ tũtũũre muoyo?” ");
INSERT INTO kik_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Nao aciarithania acio magĩcookeria Firaũni atĩrĩ, “Atumia a Ahibirania matihaana ta atumia a Misiri; o nĩ ahiũ magĩaga ciana aciarithania matanakinya.” ");
INSERT INTO kik_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Nĩ ũndũ ũcio Ngai agĩgĩtanahĩra aciarithania acio, nao andũ a Isiraeli makĩongerereka o na makĩingĩha makĩria. ");
INSERT INTO kik_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Na rĩrĩ, tondũ aciarithania acio nĩmetigĩrĩte Ngai, akĩmahe ciana ciao kĩũmbe. ");
INSERT INTO kik_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Nake Firaũni agĩatha andũ ake othe atĩrĩ: “Kahĩĩ o gothe gaaciarwo nĩ Mũhibirania no nginya mũgagaikia Rũũĩ rwa Nili, no mũreke kairĩtu o gothe gatũũre muoyo.” ");
INSERT INTO kik_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Na rĩrĩ, mũndũ ũmwe wa nyũmba ya Lawi nĩahikirie mũtumia wa mũhĩrĩga wa Alawii, ");
INSERT INTO kik_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","nake akĩgĩa nda, agĩciara kahĩĩ. Rĩrĩa onire kaarĩ kaana gathaka-rĩ, agĩkahitha nyũmba mĩeri ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","No rĩrĩa aaremirwo nĩgũkahitha rĩngĩ-rĩ, agĩgathondekera gĩkabũ gĩa ithanjĩ na agĩgĩthinga na rami. Agĩcooka agĩkomia kaana kau thĩinĩ wakĩo, agĩkahitha mathanjĩ-inĩ kũu hũgũrũrũ-inĩ cia Nili. ");
INSERT INTO kik_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mwarĩ wa nyina na kaana kau aarũgamaga haraaya nĩguo one ũndũ ũrĩa ũngĩgakora. ");
INSERT INTO kik_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Na rĩrĩ, mwarĩ wa Firaũni agĩikũrũka Nili nĩguo agethambe, nacio ndungata ciake ciaceerangaga kũu hũgũrũrũ-inĩ cia rũũĩ rũu. Nake akĩona gĩkabũ kĩu kũu ithanjĩ-inĩ, na agĩtũma ngombo yake ya mũirĩtu ĩkĩgĩĩre. ");
INSERT INTO kik_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Agĩkunũra gĩkabũ kĩu na akĩona kaana kau. Agĩkaiguĩra tha tondũ nĩkarĩraga. Nake akiuga atĩrĩ, “Gaka nĩ kaana kamwe ga twana twa Ahibirania.” ");
INSERT INTO kik_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Nake mwarĩ wa nyina na kaana kau akĩũria mwarĩ wa Firaũni atĩrĩ, “Ngacarie mũtumia ũmwe Mũhibirania akũrerere kaana gaka?” ");
INSERT INTO kik_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Nake agĩcookia atĩrĩ, “Ĩĩ, thiĩ.” Nake mũirĩtu ũcio agĩthiĩ, akĩgĩĩra nyina wa kaana kau. ");
INSERT INTO kik_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Mwarĩ wa Firaũni akĩmwĩra atĩrĩ, “Oya kaana gaka ũkanderere, nĩndĩrĩkũrĩhaga.” Nĩ ũndũ ũcio mũtumia ũcio akĩoya kaana kau agĩkarera. ");
INSERT INTO kik_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Rĩrĩa kaana kau gaakũrire-rĩ, agĩgatwarĩra mwarĩ wa Firaũni nako gagĩtuĩka ta mũriũ. Agĩgeeta Musa, akiuga atĩrĩ, “Nĩ tondũ ndakarutire maaĩ-inĩ.” ");
INSERT INTO kik_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Thuutha wa Musa gũtuĩka mũndũ mũgima-rĩ, mũthenya ũmwe nĩathiire gũceera harĩa andũ ao maarĩ, nake akĩmabaara makĩrutithio wĩra na hinya. Ningĩ akĩona Mũmisiri akĩhũũra Mũhibirania, ũmwe wa andũ ake mwene. ");
INSERT INTO kik_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nake acũthĩrĩria mĩena yothe na ndone mũndũ-rĩ, akĩũraga Mũmisiri ũcio, na akĩmũthika mũthanga-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Mũthenya ũyũ ũngĩ akiumagara na akĩona Ahibirania eerĩ makĩrũa. Akĩũria ũrĩa wogitanĩte atĩrĩ, “Ũraringa Mũhibirania wanyu nĩkĩ?” ");
INSERT INTO kik_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Nake mũndũ ũcio akĩmũũria atĩrĩ, “Nũũ wagũtuire mwathi na mũtuithania wa maciira maitũ? Anga nĩũreciiria kũnjũraga o ta ũrĩa ũrooragire Mũmisiri?” Nake Musa agĩĩtigĩra na agĩĩciiria atĩrĩ, “Ũrĩa ndĩrekire no nginya ũkorwo nĩũmenyekete.” ");
INSERT INTO kik_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Rĩrĩa Firaũni aiguire ũhoro ũcio, akĩgeria kũũragithia Musa, nowe Musa akĩũrĩra Firaũni agĩthiĩ gũtũũra Midiani, kũrĩa aikarire thĩ hakuhĩ na gĩthima. ");
INSERT INTO kik_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Na rĩrĩ, Jethero mũthĩnjĩri-ngai wa Midiani aarĩ na airĩtu ake mũgwanja, nao magĩũka gũtaha maaĩ na kũiyũria mĩharatĩ manyuithie rũũru rwa mbũri rwa ithe wao. ");
INSERT INTO kik_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Arĩithi amwe nĩmookire na makĩingata airĩtu acio, no Musa agĩũkĩra, akĩmateithũra na akĩhe ũhiũ wao maaĩ. ");
INSERT INTO kik_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Rĩrĩa airĩtu acio maainũkire kũrĩ ithe wao Reueli-rĩ, akĩmooria atĩrĩ, “Nĩ kĩĩ gĩatũma mũcooke narua ũguo ũmũthĩ?” ");
INSERT INTO kik_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Makĩmũcookeria atĩrĩ, “Mũmisiri ũmwe nĩatũteithũrire kũrĩ arĩithi; o na nĩwe ũtũtahĩire maaĩ na atũheera mbũri ciitũ maaĩ.” ");
INSERT INTO kik_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Jethero akĩmooria atĩrĩ, “Na akĩrĩ kũ?” “Mũmũtigire nĩkĩ? Thiĩi mũmwĩte, oke arĩĩanĩre na ithuĩ.” ");
INSERT INTO kik_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Nake Musa agĩĩtĩkĩra gũikara kwa mũndũ ũcio, nake akĩmũhe mwarĩ wetagwo Zipora amũhikie. ");
INSERT INTO kik_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Zipora agĩciara kaana ga kahĩĩ, nake Musa agĩgeeta Gerishomu, tondũ oigire atĩrĩ, “Nduĩkĩte mũgeni bũrũri wene.” ");
INSERT INTO kik_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Thuutha wa ihinda iraaya-rĩ, mũthamaki wa bũrũri wa Misiri nĩakuire. Andũ a Isiraeli magĩcaaya nĩ ũndũ wa ũkombo, na makĩrĩrĩra Ngai; nakĩo kĩrĩro kĩao atĩ mateithio nĩ ũndũ wa ũkombo gĩgĩkinyĩra Ngai. ");
INSERT INTO kik_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nake Ngai akĩigua gũcaaya kwao nake akĩririkana kĩrĩkanĩro gĩake na Iburahĩmu, na Isaaka na Jakubu. ");
INSERT INTO kik_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nĩ ũndũ ũcio Ngai akĩona gũtangĩka kwa andũ a Isiraeli, nake akĩrũmbũiya ũhoro wao. ");
INSERT INTO kik_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Na rĩrĩ, Musa nĩ kũrĩithia arĩithagia rũũru rwa mbũri rwa mũthoni-we Jethero, mũthĩnjĩri-ngai wa Midiani, nake agĩtongoria rũũru rũu rwa mbũri mwena ũũrĩa ũngĩ wa werũ kũraya ma, na agĩkinya Horebu, kĩrĩma-inĩ kĩa Ngai. ");
INSERT INTO kik_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Arĩ kũu-rĩ, akiumĩrĩrwo nĩ mũraika wa Jehova arĩ nĩnĩmbĩ-inĩ cia mwaki ikiuma kĩhinga-inĩ. Musa akĩona atĩ o na gũtuĩka kĩhinga nĩgĩakanaga-rĩ, gĩtiahĩaga. ");
INSERT INTO kik_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Nĩ ũndũ ũcio Musa agĩĩciiria atĩrĩ, “Nĩngũthiĩ ho nĩgeetha nyone ũndũ ũyũ mũgeni, menye kĩrĩa kĩragiria kĩhinga kĩhĩe.” ");
INSERT INTO kik_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Rĩrĩa Jehova onire atĩ nĩathiĩ hau gũcũthĩrĩria, Ngai akĩmwĩta arĩ kĩhinga-inĩ, “Musa! Musa!” Nake Musa agĩĩtĩka, akiuga atĩrĩ, “Niĩ ũyũ haha.” ");
INSERT INTO kik_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nake Ngai akĩmwĩra atĩrĩ, “Ndũgakuhĩrĩrie haha. Ruta iraatũ ciaku magũrũ, nĩgũkorwo handũ hau ũrũgamĩte nĩ handũ hatheru.” ");
INSERT INTO kik_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ningĩ akĩmwĩra atĩrĩ, “Niĩ nĩ niĩ Ngai wa thoguo, Ngai wa Iburahĩmu, Ngai wa Isaaka, o na Ngai wa Jakubu.” Kahinda kau Musa akĩhitha ũthiũ wake, tondũ nĩetigĩrire kũrora Ngai. ");
INSERT INTO kik_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Jehova akiuga atĩrĩ; “Ti-itherũ nĩnyonete mĩnyamaro ya andũ akwa kũu bũrũri wa Misiri. Nĩnjiguĩte kĩrĩro kĩao nĩ ũndũ wa arũgamĩrĩri a ngombo arĩa mamahinyagĩrĩria, na nĩngũrũmbũiya ũhoro wa kũnyamarĩka kwao. ");
INSERT INTO kik_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Nĩ ũndũ ũcio nĩnjikũrũkĩte nĩguo ndĩmateithũre kuuma moko-inĩ ma andũ a Misiri, ndĩmarute bũrũri ũcio, ndĩmatware bũrũri mwega na mwariĩ, bũrũri ũrĩ bũthi wa iria na ũũkĩ, kũrĩa gũtũũragwo nĩ Akaanani, na Ahiti, na Aamori, na Aperizi, na Ahivi, na Ajebusi. ");
INSERT INTO kik_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Na rĩu kĩrĩro kĩa andũ a Isiraeli nĩkĩnginyĩire, na nĩnyonete ũrĩa andũ a bũrũri wa Misiri maramahinyĩrĩria. ");
INSERT INTO kik_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Nĩ ũndũ ũcio, thiĩ. Ndĩragũtũma kũrĩ Firaũni ũkarute andũ akwa a Isiraeli moime bũrũri wa Misiri.” ");
INSERT INTO kik_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","No Musa akĩũria Ngai atĩrĩ, “Niĩ ndĩ ũ wa gũthiĩ kwa Firaũni ngarute andũ a Isiraeli moime bũrũri wa Misiri?” ");
INSERT INTO kik_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Nake Ngai agĩcookia atĩrĩ, “Ndĩrĩkoragwo hamwe nawe. Naguo ũndũ ũyũ nĩguo ũgaatuĩka kĩmenyithia gĩa atĩ nĩ niĩ ngũtũmĩte: Rĩrĩa ũkaaruta andũ a Isiraeli moime bũrũri wa Misiri, nĩmũkahooyagĩra Ngai kĩrĩma-inĩ gĩkĩ.” ");
INSERT INTO kik_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa akĩĩra Ngai atĩrĩ, “Ingĩthiĩ kũrĩ andũ a Isiraeli ndĩmeere atĩrĩ, ‘Nĩ Ngai wa maithe manyu wandũma kũrĩ inyuĩ,’ nao manjũũrie atĩrĩ, ‘Ngai ũcio etagwo atĩa?’ ngaamacookeria atĩa?” ");
INSERT INTO kik_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ngai akĩĩra Musa atĩrĩ, “NIĨ NDŨIRE O TA ŨRĨA NDŨIRE. Ĩra andũ a Isiraeli atĩrĩ, Ũrĩa wĩtagwo ‘NIĨ NDŨIRE nĩwe ũndũmĩte kũrĩ inyuĩ.’ ” ");
INSERT INTO kik_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ningĩ Ngai agĩcooka akĩĩra Musa atĩrĩ, “Ĩra andũ a Isiraeli atĩrĩ, ‘Jehova, o we Ngai wa maithe manyu, Ngai wa Iburahĩmu, na Ngai wa Isaaka na Ngai wa Jakubu nĩandũmĩte kũrĩ inyuĩ.’ Rĩĩrĩ nĩrĩo rĩĩtwa rĩakwa nginya tene, rĩĩtwa rĩrĩa ndĩĩririkanagwo narĩo kuuma njiarwa na njiarwa. ");
INSERT INTO kik_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Thiĩ, ũcookanĩrĩrie athuuri a Isiraeli, ũmeere atĩrĩ, ‘Jehova, Ngai wa maithe manyu o we Ngai wa Iburahĩmu, na Isaaka, na Jakubu nĩanyumĩrĩire akanjĩĩra atĩrĩ: Nĩndorete na ngoona maũndũ marĩa mwĩkĩtwo kũu bũrũri wa Misiri, ");
INSERT INTO kik_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","na nĩnduĩte nĩngũmũruta kuuma mĩnyamaro-inĩ yanyu kũu bũrũri wa Misiri, ndĩmũtware bũrũri wa Akaanani, na Ahiti, na Aamori, na Aperizi, na Ahivi, na Ajebusi, bũrũri ũrĩ bũthi wa iria na ũũkĩ.’ ");
INSERT INTO kik_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Athuuri acio a Isiraeli nĩmagagũthikĩrĩria. Ningĩ wee na athuuri acio nĩmũgathiĩ kũrĩ mũthamaki wa bũrũri wa Misiri na mũmwĩre atĩrĩ, ‘Jehova, o we Ngai wa Ahibirania, nĩarĩtie na ithuĩ. Nĩ ũndũ ũcio twĩtĩkĩrie tũthiĩ rũgendo rwa mĩthenya ĩtatũ werũ-inĩ tũkarutĩre Jehova Ngai witũ magongona.’ ");
INSERT INTO kik_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","No nĩnjũũĩ atĩ mũthamaki ũcio wa bũrũri wa Misiri ndakamwĩtĩkĩria mũthiĩ, tiga guoko gwakwa kwa hinya kũmũhatĩrĩirie gwĩka ũguo. ");
INSERT INTO kik_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nĩ ũndũ ũcio nĩngatambũrũkia guoko gwakwa hũũre andũ a Misiri na maũndũ mothe ma magegania marĩa ngeeka thĩinĩ wao. Thuutha ũcio, nĩakamwĩtĩkĩria mũthiĩ. ");
INSERT INTO kik_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Na nĩngatũma mwĩtĩkĩrĩke nĩ andũ a Misiri, nĩgeetha rĩrĩa mũkoimagara, mũtikanathiĩ moko matheri. ");
INSERT INTO kik_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mũndũ-wa-nja o wothe Mũisiraeli nĩakahooya mũndũ wa itũũra rĩake, na ahooe mũndũ-wa-nja o wothe matũũranagia nake gwake nyũmba indo cia betha na thahabu o na nguo, iria mũkaahumba ciana cianyu cia aanake na cia airĩtu. Na nĩ ũndũ ũcio nĩmũgataha andũ acio a Misiri.” ");
INSERT INTO kik_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa akĩmũcookeria atĩrĩ, “Ĩ mangĩrega kũnjĩtĩkia kana kũnjigua, na manjĩĩre atĩrĩ, ‘Jehova ndakuumĩrĩire?’ ” ");
INSERT INTO kik_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nake Jehova akĩmũũria atĩrĩ, “Nĩ kĩĩ kĩu ũrĩ nakĩo guoko?” Nake agĩcookia atĩrĩ, “Nĩ rũthanju.” ");
INSERT INTO kik_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Jehova akĩmwĩra atĩrĩ, “Rũikie thĩ.” Musa akĩrũikia thĩ, naruo rũgĩtuĩka nyoka, nake akĩmĩũrĩra. ");
INSERT INTO kik_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nake Jehova akĩmwĩra atĩrĩ, “Tambũrũkia guoko ũmĩnyiite mũtingʼoe.” Nĩ ũndũ ũcio Musa agĩtambũrũkia guoko akĩmĩnyiita, nayo ĩkĩgarũrũka, ĩgĩtuĩka rũthanju guoko-inĩ gwake. ");
INSERT INTO kik_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Nake Jehova akiuga atĩrĩ, “Ũndũ ũyũ nĩguo wa gũtũma metĩkie atĩ Jehova, o we Ngai wa maithe mao Ngai wa Iburahĩmu, na Ngai wa Isaaka, na Ngai wa Jakubu nĩakuumĩrĩire.” ");
INSERT INTO kik_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ningĩ Jehova akiuga atĩrĩ, “Ikia guoko nguo-inĩ yaku.” Nĩ ũndũ ũcio Musa agĩikia guoko nguo-inĩ yake, na rĩrĩa aakũrutire kwarĩ na mangũ, gũkeerũha ta ira. ");
INSERT INTO kik_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Jehova agĩcooka akĩmwĩra atĩrĩ, “Cookia guoko nguo-inĩ yaku.” Nĩ ũndũ ũcio Musa agĩcookia guoko nguo-inĩ, na rĩrĩa aakũrutire kwagarũrũkĩte gũkahaanana na mwĩrĩ ũcio ũngĩ wake. ");
INSERT INTO kik_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ningĩ Jehova akiuga atĩrĩ, “Mangĩaga gũgwĩtĩkia na kũrũmbũiya kĩama kĩa mbere, no gũkorwo nĩmagetĩkia gĩa keerĩ. ");
INSERT INTO kik_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","No mangĩaga gwĩtĩkia ciama ici cierĩ kana mage gũkũigua-rĩ, ũgaataha maaĩ kuuma Rũũĩ rwa Nili na ũmaite thĩ. Maaĩ macio ũgaataha kuuma rũũĩ nĩmagatuĩka thakame maitwo thĩ.” ");
INSERT INTO kik_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Musa akĩĩra Jehova atĩrĩ, “Wee, Mwathani, nĩũũĩ niĩ ndirĩ ndatuĩka mũndũ mwaria wega, kuuma o tene o na kuuma wambĩrĩria kwaria na niĩ ndungata yaku. Niĩ ndirĩ mĩtũkĩ ya mĩario, na ndĩ rũrĩmĩ rũritũ.” ");
INSERT INTO kik_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Jehova akĩmwĩra atĩrĩ, “Nũũ waheire mũndũ kanua? Nũũ ũtũmaga mũndũ aage kũigua kana aremwo nĩ kwaria? Nũũ ũtũmaga mũndũ one kana atuĩke mũtumumu? Githĩ ti niĩ, Jehova? ");
INSERT INTO kik_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Na rĩrĩ, thiĩ; nĩngakũhotithia kwaria na ngũrute ũrĩa ũkoiga.” ");
INSERT INTO kik_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","No Musa akiuga atĩrĩ, “Mwathani, ndagũthaitha tũma mũndũ ũngĩ akaarie.” ");
INSERT INTO kik_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Namo marakara ma Jehova makĩrĩrĩmbũkĩra Musa, akĩmũũria atĩrĩ, “Ĩ mũrũ wa nyũkwa Harũni, ũrĩa Mũlawii-rĩ, ndangĩaria? Nĩnjũũĩ no aarie wega. Arĩ njĩra-inĩ agĩũka gũgũtũnga, na nĩegũkena akuona. ");
INSERT INTO kik_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ũrĩmwaragĩria na ũkamwĩra ũrĩa ekuuga, na nĩngamũhotithia inyuĩ eerĩ kwaria, na ndĩmũrute ũrĩa mũgeeka. ");
INSERT INTO kik_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Nĩakaarĩria andũ handũ haku, na agaatuĩka taarĩ we kanua gaku, nawe ũtuĩke ta ũrĩ Ngai harĩ we. ");
INSERT INTO kik_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","No oya rũthanju rũrũ nĩguo ũhotage kũringa ciama naruo.” ");
INSERT INTO kik_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Nake Musa agĩcooka kwa Jethero mũthoni-we, akĩmwĩra atĩrĩ, “Njĩtĩkĩria njooke bũrũri wa Misiri kũrĩ andũ aitũ, ngarore kana nĩ kũrĩ matũire muoyo.” Jethero akiuga atĩrĩ, “Thiĩ, ndakũhoera thayũ.” ");
INSERT INTO kik_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Na rĩrĩ, Jehova nĩarĩirie Musa arĩ o kũu Midiani, akĩmwĩra atĩrĩ, “Cooka bũrũri wa Misiri, nĩgũkorwo andũ othe arĩa meendaga gũkũũraga nĩmakuĩte.” ");
INSERT INTO kik_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Nĩ ũndũ ũcio Musa akĩoya mũtumia wake na ariũ ake, akĩmahaicia ndigiri na makĩambĩrĩria rũgendo rwa gũcooka bũrũri wa Misiri. Nake akĩoya rũthanju rwa Ngai akĩrũnyiita na guoko. ");
INSERT INTO kik_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Jehova akĩĩra Musa atĩrĩ, “Wacooka bũrũri wa Misiri-rĩ, tigĩrĩra nĩ weka morirũ mothe marĩa ngũhotithĩtie gwĩka mbere ya Firaũni. No nĩngomia ngoro yake nĩgeetha ndagetĩkĩrie andũ mathiĩ. ");
INSERT INTO kik_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ningĩ wĩre Firaũni atĩrĩ, ‘Ũũ nĩguo Jehova ekuuga: Isiraeli nĩwe mũriũ wakwa wa irigithathi, ");
INSERT INTO kik_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","na nĩndakwĩrire atĩrĩ, “Reke mũriũ wakwa athiĩ akaahooe.” No nĩwaregire kũmwĩtĩkĩria athiĩ; nĩ ũndũ ũcio nĩngooraga mũriũ waku wa irigithathi.’ ” ");
INSERT INTO kik_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Marĩ handũ harĩa mararĩrĩire marĩ rũgendo-inĩ-rĩ, Jehova akiumĩrĩra Musa, na aarĩ hakuhĩ kũmũũraga. ");
INSERT INTO kik_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","No Zipora akĩoya kahiga kaarĩ kogĩ ta kahiũ, akĩruithia mũriũ, na akĩhutithia gĩkonde kĩu nyarĩrĩ cia Musa. Agĩcooka akĩmwĩra atĩrĩ, “Ti-itherũ ũrĩ mũthuuri wakwa wa thakame.” ");
INSERT INTO kik_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Nĩ ũndũ ũcio Jehova agĩtigana nake. (Hĩndĩ ĩyo mũtumia ũcio wake oigire “ũrĩ mũthuuri wakwa wa thakame” aaragia ũhoro wa irua.) ");
INSERT INTO kik_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nake Jehova akĩĩra Harũni atĩrĩ, “Thiĩ werũ-inĩ ũgathaagane Musa.” Nĩ ũndũ ũcio Harũni agĩtũnga Musa kĩrĩma-inĩ kĩa Ngai, akĩmũhĩmbĩria. ");
INSERT INTO kik_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Nake Musa akĩĩra Harũni ũrĩa wothe Jehova amũtũmĩte akoige, o na ningĩ ũhoro wa ciama ciothe iria aamwathĩte aringe. ");
INSERT INTO kik_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musa na Harũni magĩcookanĩrĩria athuuri a Isiraeli othe, ");
INSERT INTO kik_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","nake Harũni akĩmeera ũrĩa wothe Jehova eerĩte Musa. O na ningĩ Musa akĩringa ciama mbere yao; ");
INSERT INTO kik_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","nao magĩĩtĩkia. Na rĩrĩa maiguire atĩ Jehova nĩameciirĩtie na akona mĩnyamaro yao-rĩ, makĩinamĩrĩra, magĩthathaiya. ");
INSERT INTO kik_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Thuutha-inĩ Musa na Harũni nĩmathiire kũrĩ Firaũni, makĩmwĩra atĩrĩ, “Jehova, o we Ngai wa Isiraeli, oigĩte ũũ: ‘Reke andũ akwa mathiĩ, nĩgeetha makagĩe na gĩathĩ gĩakwa werũ-inĩ.’ ” ");
INSERT INTO kik_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Nake Firaũni akĩmooria atĩrĩ, “Jehova nĩwe ũ, atĩ ndĩmwathĩkĩre na ndekererie andũ a Isiraeli mathiĩ? Niĩ ndiũĩ Jehova na ndikũrekereria andũ a Isiraeli mathiĩ.” ");
INSERT INTO kik_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ningĩ makĩmwĩra atĩrĩ, “Ngai wa Ahibirania nĩatwarĩirie. Nĩ ũndũ ũcio twĩtĩkĩrie tũthiĩ rũgendo rwa mĩthenya ĩtatũ werũ-inĩ tũkarutĩre Jehova Ngai witũ magongona, kwaga ũguo no atũrehithĩrie mĩthiro kana atũniine na rũhiũ rwa njora.” ");
INSERT INTO kik_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","No mũthamaki wa bũrũri wa Misiri akĩmooria atĩrĩ, “Musa na Harũni, nĩ kĩĩ kĩratũma mũrute andũ wĩra-inĩ wao? Cookai wĩra-inĩ wanyu!” ");
INSERT INTO kik_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Nake Firaũni akiuga atĩrĩ, “Ta rorai, andũ a bũrũri rĩu nĩmaingĩhĩte, na inyuĩ nĩmũragiria marute wĩra.” ");
INSERT INTO kik_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Mũthenya o ũcio Firaũni agĩatha arũgamĩrĩri a ngombo o na nyabaara cia andũ, akĩmeera atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mũtigacooke kũhe andũ a Isiraeli nyeki ya gũthondeka maturubarĩ; nĩmathiĩ magecarĩrie nyeki o ene. ");
INSERT INTO kik_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","No mũmeere atĩ no nginya mathondeke maturubarĩ mũigana o ta wa mbere; mũtikamanyiihĩrie gĩthimo. Nĩ igũũta; nĩkĩo mararĩra makoiga atĩrĩ, ‘Nĩtũrekwo tũthiĩ tũkarutĩre Ngai witũ igongona.’ ");
INSERT INTO kik_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Maritũhĩriei wĩra nĩgeetha makoragwo makĩruta wĩra hĩndĩ ciothe, na mũtige gũthikĩrĩria ũhoro wa maheeni.” ");
INSERT INTO kik_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Nao arũgamĩrĩri a ngombo na nyabaara cia andũ magĩthiĩ makĩĩra andũ atĩrĩ, “Firaũni ekuuga ũũ: ‘Ndigũcooka kũmũhe nyeki rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Thiĩi mũgecarĩrie nyeki yanyu kũrĩa guothe mũrĩmĩona, no wĩra wanyu ndũkũnyihanyiihio o na hanini.’ ” ");
INSERT INTO kik_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Nĩ ũndũ ũcio andũ makĩhurunjũkĩra bũrũri wa Misiri guothe kũngania makoni ma ngano mamatũmĩre ta nyeki. ");
INSERT INTO kik_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Arũgamĩrĩri a ngombo makĩmahinyĩrĩria mũno, makameeraga atĩrĩ, “Rĩĩkiai wĩra ũrĩa mwagĩrĩirwo wa o mũthenya, o ta ũrĩa mwekaga rĩrĩa mwaheagwo nyeki.” ");
INSERT INTO kik_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Nao andũ a Isiraeli arĩa maarĩ nyabaara arĩa maathuurĩtwo nĩ anene a ngombo a Firaũni magakĩhũũragwo, makoorio atĩrĩ, “Nĩ kĩĩ kĩragiririe mũhingie mũigana wa maturubarĩ ma ira kana ma ũmũthĩ, ta ũrĩa mũrekaga mbere?” ");
INSERT INTO kik_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Nao andũ a Isiraeli arĩa maarĩ nyabaara magĩthiĩ kũrĩ Firaũni kũmũthaitha, makĩmũũria atĩrĩ: “Nĩ kĩĩ gĩtũmĩte wĩke ndungata ciaku maũndũ maya? ");
INSERT INTO kik_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ndungata ciaku itiraheo nyeki, na no tũrerwo, ‘Thondekai maturubarĩ!’ Ndungata ciaku nĩirahũũrwo, no andũ aku nĩo marĩ na mahĩtia.” ");
INSERT INTO kik_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Nake Firaũni agĩcookia atĩrĩ, “Igũũta ici! Inyuĩ mũrĩ igũũta! Nĩkĩo mũraikara mũkiugaga atĩrĩ, ‘Nĩtũrekwo tũkarutĩre Jehova igongona.’ ");
INSERT INTO kik_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Cookai wĩra-inĩ. Mũtikũheo nyeki, na no nginya mũthondeke mũigana wa maturubarĩ marĩa mwagĩrĩirwo.” ");
INSERT INTO kik_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nao andũ a Isiraeli arĩa maarĩ nyabaara makĩmenya atĩ maarĩ thĩĩna-inĩ rĩrĩa meerirwo atĩrĩ, “Mũtikũnyiihĩrio mũigana wa maturubarĩ marĩa mwagĩrĩirwo gũthondeka o mũthenya.” ");
INSERT INTO kik_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Rĩrĩa moimire harĩ Firaũni-rĩ, magĩkora Musa na Harũni arĩa maametereire, ");
INSERT INTO kik_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","nao anyabara acio makĩmeera atĩrĩ, “Jehova aromuona na amũtuĩre ciira! Mũtũmĩte tũtuĩke kĩndũ kĩnungu kũrĩ Firaũni na anene ake, na mũkamane rũhiũ rwa njora moko-inĩ mao matũũrage.” ");
INSERT INTO kik_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Musa agĩcooka kũrĩ, Jehova akĩmũũria atĩrĩ, “Mwathani, nĩ kĩĩ gĩtũmĩte ũrehithĩrie andũ aya thĩĩna? Gĩkĩ nĩkĩo gĩatũmire ũndũme? ");
INSERT INTO kik_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kuuma rĩrĩa ndaathiire kũrĩ Firaũni kũmwarĩria thĩinĩ wa rĩĩtwa rĩaku, nĩareheire andũ aya thĩĩna, nawe ũkaaga gũteithũra andũ aku o na hanini.” ");
INSERT INTO kik_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Rĩu nĩũkuona ũrĩa ngwĩka Firaũni: Nĩ tondũ wa guoko gwakwa kũrĩ hinya-rĩ, nĩakamarekereria mathiĩ; na ningĩ nĩ tondũ wa guoko gwakwa kũrĩ hinya, nĩakamaingata moime bũrũri wake.” ");
INSERT INTO kik_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ngai agĩcooka akĩĩra Musa atĩrĩ, “Nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nĩ niĩ ndoimĩrĩire Iburahĩmu, na Isaaka, o na Jakubu ndĩ Mũrungu Mwene-Hinya-Wothe, no matiamenyire na rĩĩtwa rĩu rĩakwa Jehova. ");
INSERT INTO kik_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","O na nĩndathondekire kĩrĩkanĩro gĩakwa nao atĩ nĩngamahe bũrũri wa Kaanani, kũrĩa maatũũraga marĩ ageni. ");
INSERT INTO kik_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Na makĩria-rĩ, nĩnjiguĩte gũcaaya kwa andũ a Isiraeli, arĩa matuĩtwo ngombo nĩ andũ a Misiri, na nĩndirikanĩte kĩrĩkanĩro gĩakwa nao. ");
INSERT INTO kik_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Nĩ ũndũ ũcio, ĩra andũ a Isiraeli atĩrĩ: ‘Niĩ nĩ niĩ Jehova, na nĩngamwaũra icooki rĩu mũigĩrĩirwo nĩ andũ a Misiri. Nĩngamuohora mũtige gũcooka gũtuĩka ngombo ciao, na nĩngamũkũũra ndambũrũkĩtie guoko na ciĩko nene cia ũtuanĩri ciira. ");
INSERT INTO kik_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ngaamuoya ta andũ akwa kĩũmbe, na nduĩke Ngai wanyu. Hĩndĩ ĩyo nĩmũkamenya atĩ nĩ niĩ Jehova Ngai wanyu ũrĩa wamũrutire icooki-inĩ rĩa andũ a Misiri. ");
INSERT INTO kik_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Na nĩngamũtwara bũrũri ũrĩa ndeeranĩire na mwĩhĩtwa nyambararĩtie guoko atĩ nĩngaahe Iburahĩmu, na Isaaka, o na Jakubu. Nĩguo ngũmũhe mũwĩgwatĩre ũtuĩke wanyu. Niĩ nĩ niĩ Jehova.’ ” ");
INSERT INTO kik_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Musa agĩkĩheana ũhoro ũcio kũrĩ andũ a Isiraeli, no matiamũiguire nĩ ũrĩa maakuĩte ngoro nĩkũhinyĩrĩrio nĩ ũkombo. ");
INSERT INTO kik_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Thiĩ wĩre Firaũni, mũthamaki wa bũrũri wa Misiri arekererie andũ a Isiraeli moime bũrũri wake.” ");
INSERT INTO kik_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","No Musa akĩĩra Jehova atĩrĩ, “Angĩkorwo andũ a Isiraeli matingĩnjigua-rĩ, nĩkĩ kĩngĩtũma Firaũni anjigue, kuona njaragia ngĩtondoiraga?” ");
INSERT INTO kik_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ngai nĩacookire akĩaria na Musa na Harũni ũhoro wĩgiĩ andũ a Isiraeli na Firaũni mũthamaki wa bũrũri wa Misiri na akĩmaatha marute andũ a Isiraeli moime bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Aya nĩo maarĩ atongoria a nyũmba ciao: Ariũ a Rubeni ũrĩa irigithathi rĩa Isiraeli maarĩ Hanoku na Palu, na Hezironi, na Karimi. Acio nĩo maarĩ mbarĩ cia Rubeni. ");
INSERT INTO kik_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ariũ a Simeoni maarĩ Jemueli, na Jamini, na Ohadi, na Jakini, na Sohari, na Shauli ũrĩa warĩ mũriũ wa mũtumia Mũkaanani. Acio nĩo maarĩ mbarĩ cia Simeoni. ");
INSERT INTO kik_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Maya nĩmo maarĩ marĩĩtwa ma ariũ a Lawi kũringana na maandĩko mao: Gerishoni, na Kohathu, na Merari. Lawi aatũũrire muoyo mĩaka 137. ");
INSERT INTO kik_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ariũ a Gerishoni kũringana na mbarĩ ciao maarĩ Libini na Shimei. ");
INSERT INTO kik_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ariũ a Kohathu maarĩ Amuramu, na Iziharu, na Hebironi, na Uzieli. Kohathu aatũũrire muoyo mĩaka 133. ");
INSERT INTO kik_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ariũ a Merari maarĩ Mahali na Mushi. Acio nĩo maarĩ mbarĩ cia Lawi kũringana na maandĩko mao. ");
INSERT INTO kik_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amuramu nĩahikirie mwarĩ wa nyina na ithe wetagwo Jokebedi, ũrĩa wamũciarĩire Harũni na Musa. Amuramu aatũũrire muoyo mĩaka 137. ");
INSERT INTO kik_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ariũ a Iziharu maarĩ Kora, na Nefegu, na Zikiri. ");
INSERT INTO kik_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ariũ a Uzieli maarĩ Mishaeli, na Elizafani, na Sithiri. ");
INSERT INTO kik_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Harũni nĩahikirie Elisheba, mwarĩ wa Aminadabu, o ũrĩa warĩ mwarĩ wa nyina na Nahashoni, nake akĩmũciarĩra Nadabu na Abihu, na Eleazaru, na Ithamaru. ");
INSERT INTO kik_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ariũ a Kora maarĩ Asiri, na Elikana, na Abiasafu. Acio nĩo mbarĩ cia Akora. ");
INSERT INTO kik_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazaru mũrũ wa Harũni nĩahikirie mũirĩtu ũmwe wa Putieli, nake akĩmũciarĩra Finehasi. Acio nĩo maarĩ atongoria a nyũmba cia Alawii, o mbarĩ o mbarĩ. ");
INSERT INTO kik_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Harũni o ũcio, marĩ na Musa, nĩo meerirwo nĩ Jehova atĩrĩ, “Rutai andũ a Isiraeli kuuma bũrũri wa Misiri kũringana na ikundi ciao.” ");
INSERT INTO kik_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Nĩo maarĩirie Firaũni, mũthamaki wa bũrũri wa Misiri, ũhoro wa kũruta andũ a Isiraeli kuuma bũrũri wa Misiri. Maarĩ Musa o ũcio na Harũni. ");
INSERT INTO kik_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Na rĩrĩ, hĩndĩ ĩrĩa Jehova aarĩirie Musa arĩ kũu bũrũri wa Misiri-rĩ, ");
INSERT INTO kik_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","aamwĩrire atĩrĩ, “Niĩ nĩ niĩ Jehova. Ĩra Firaũni mũthamaki wa bũrũri wa Misiri ũrĩa wothe ngũkwĩra.” ");
INSERT INTO kik_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","No Musa akĩĩra Jehova atĩrĩ, “Kuona njaragia ngĩtondoiraga-rĩ, Firaũni angĩkĩnjigua nĩkĩ?” ");
INSERT INTO kik_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, “We ngũtuĩte ta Ngai harĩ Firaũni, nake mũrũ wa nyũkwa Harũni egũtuĩka mũnabii waku. ");
INSERT INTO kik_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Wee ũriugaga ũrĩa wothe ndĩgwathaga, nake mũrũ wa nyũkwa Harũni nĩwe ũrĩĩraga Firaũni arekererie andũ a Isiraeli moime bũrũri wake. ");
INSERT INTO kik_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","No nĩngũtũma ngoro ya Firaũni yũme, na o na ndaingĩhia ciama ciakwa na morirũ gũkũ bũrũri wa Misiri-rĩ, ");
INSERT INTO kik_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ndakamũigua. Ningĩ nĩngatambũrũkia guoko gwakwa kũu bũrũri wa Misiri, na ndute ikundi cia andũ akwa a Isiraeli moime kuo na ũndũ wa ciĩko nene cia ũtuanĩri ciira. ");
INSERT INTO kik_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Nao andũ a Misiri nĩmakamenya atĩ niĩ nĩ niĩ Jehova, rĩrĩa ngataambũrũkia guoko gwakwa njũkĩrĩre bũrũri wa Misiri na ndute andũ a Isiraeli moime kuo.” ");
INSERT INTO kik_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musa na Harũni magĩĩka o ũrĩa Jehova aamaathĩte meke. ");
INSERT INTO kik_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Musa aarĩ na mĩaka mĩrongo ĩnana nake Harũni mĩaka mĩrongo ĩnana na ĩtatũ hĩndĩ ĩrĩa maaragia na Firaũni. ");
INSERT INTO kik_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Rĩrĩa Firaũni arĩmwĩra atĩrĩ, ‘Ringai kĩama,’ nawe Musa wĩre Harũni atĩrĩ, ‘Oya rũthanju rwaku, ũrũikie thĩ o hau mbere ya Firaũni,’ naruo rũtuĩke nyoka.” ");
INSERT INTO kik_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Nĩ ũndũ ũcio Musa na Harũni magĩthiĩ kũrĩ Firaũni, nao magĩĩka o ta ũrĩa maathĩtwo nĩ Jehova. Harũni agĩikia rũthanju rwake thĩ mbere ya Firaũni na anene ake, naruo rũgĩtuĩka nyoka. ");
INSERT INTO kik_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Nake Firaũni agĩĩta andũ arĩa oogĩ o na ago, na aringi ciama a Misiri, nao magĩĩka o ũguo magĩtũmĩra maũgĩ mao ma ũgo. ");
INSERT INTO kik_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","O mũndũ agĩikia rũthanju rwake thĩ na rũgĩtuĩka nyoka. No rũthanju rwa Harũni rũkĩmeria thanju ciao. ");
INSERT INTO kik_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","No rĩrĩ, ngoro ya Firaũni ĩkĩũma nake akĩrega kũmaigua, o ta ũrĩa Jehova oigĩte. ");
INSERT INTO kik_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ngoro ya Firaũni ndĩngĩororoa; nĩaregete kũrekereria andũ mathiĩ. ");
INSERT INTO kik_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Nĩũgathiĩ kũrĩ Firaũni rũciinĩ agĩthiĩ rũũĩ. Weterere mũcemanie nake hũgũrũrũ-inĩ cia Rũũĩ rwa Nili, na ũthiĩ na rũthanju rũrĩa rwagarũrũkĩte rũgatuĩka nyoka. ");
INSERT INTO kik_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ũcooke ũmwĩre atĩrĩ, ‘Jehova, o we Ngai wa Ahibirania, nĩandũmĩte ngwĩre ũũ: Rekereria andũ akwa mathiĩ nĩgeetha makandungatĩre marĩ werũ-inĩ. No nginya rĩu nĩũregete gũthikĩrĩria. ");
INSERT INTO kik_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Jehova ekuuga atĩrĩ: Ũndũ ũyũ nĩguo ũgũtũma ũmenye atĩ niĩ nĩ niĩ Jehova: Ngũgũtha maaĩ ma Rũũĩ rwa Nili na rũthanju rũrũ rũrĩ guoko-inĩ gwakwa, namo magarũrũke matuĩke thakame. ");
INSERT INTO kik_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Thamaki iria irĩ thĩinĩ wa Rũũĩ rwa Nili nĩigũkua, naruo rũũĩ rũnunge; andũ a Misiri maremwo nĩ kũnyua maaĩ maruo.’ ” ");
INSERT INTO kik_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Jehova akĩĩra Musa atĩrĩ, “Ĩra Harũni atĩrĩ, ‘Oya rũthanju rwaku na ũtambũrũkie guoko igũrũ rĩa maaĩ ma bũrũri wa Misiri, na igũrũ rĩa tũrũũĩ, na mĩtaro, na tũmaria o na kũrĩa guothe kũhingĩrĩrie maaĩ nakuo guothe gũtuĩke thakame. Thakame ĩkaiyũra kũndũ guothe bũrũri wa Misiri, o na kũu ndoo-inĩ cia mĩtĩ na mĩtũngi-inĩ ya mahiga.’ ” ");
INSERT INTO kik_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musa na Harũni magĩĩka o ũrĩa Jehova aathanĩte. Agĩkĩambararia rũthanju rwake arĩ mbere ya Firaũni na anene ake, nake akĩgũtha maaĩ ma Rũũĩ rwa Nili, namo maaĩ mothe makĩgarũrũka magĩtuĩka thakame. ");
INSERT INTO kik_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Thamaki iria ciarĩ Rũũĩ rwa Nili igĩkua, naruo rũũĩ rũkĩnunga ũũru mũno, nginya andũ a bũrũri wa Misiri makĩremwo nĩ kũnyua maaĩ maruo. Bũrũri wa Misiri wothe ũkĩiyũra thakame. ");
INSERT INTO kik_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","No aringi ciama a bũrũri wa Misiri magĩĩka maũndũ o ta macio na ũndũ wa maũgĩ mao ma ũgo, nayo ngoro ya Firaũni ĩkĩũma; akĩrega kũigua Musa na Harũni, o ta ũrĩa Jehova oigĩte. ");
INSERT INTO kik_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Handũ ha kũigua-rĩ, akĩhũndũka agĩthiĩ nyũmba-inĩ yake ya ũthamaki, na ndaigana kũrũmbũiya ũhoro ũcio ngoro-inĩ yake. ");
INSERT INTO kik_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Nao andũ othe a Misiri makĩenja ithima gũkuhĩ na Rũũĩ rwa Nili nĩguo mone maaĩ ma kũnyua, tondũ matingĩahotire kũnyua maaĩ ma rũũĩ rũu. ");
INSERT INTO kik_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mĩthenya mũgwanja nĩyahĩtũkire thuutha wa Jehova kũgũtha maaĩ ma Nili. ");
INSERT INTO kik_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Thiĩ kũrĩ Firaũni ũmwĩre atĩrĩ, ‘Jehova oigĩte ũũ: Rekereria andũ akwa mathiĩ, nĩgeetha makandungatĩre. ");
INSERT INTO kik_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ũngĩrega kũmarekereria mathiĩ, nĩngũhũũra bũrũri waku wothe na mũthiro wa ciũra. ");
INSERT INTO kik_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Rũũĩ rwa Nili rũkũiyũra ciũra. Igũũka ciambate o nginya nyũmba yaku ya ũthamaki o na nyũmba yaku ya toro o nginya ũrĩrĩ waku igũrũ, itoonye nyũmba cia anene aku, o na irũgĩrĩre andũ aku o ene, ikorwo kuo o na mariiko-inĩ maku na mĩharatĩ-inĩ ya gũkandĩrwo mũtu. ");
INSERT INTO kik_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ciũra icio ikũrũgĩrĩre na irũgĩrĩre andũ aku o na anene aku.’ ” ");
INSERT INTO kik_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ĩra Harũni atĩrĩ, ‘Tambũrũkia guoko gwaku na rũthanju igũrũ rĩa tũrũũĩ, na mĩtaro, na tũmaria, ũtũme ciũra ciũke bũrũri-inĩ wa Misiri.’ ” ");
INSERT INTO kik_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Nĩ ũndũ ũcio Harũni agĩtambũrũkia guoko gwake igũrũ rĩa maaĩ ma bũrũri wa Misiri, nacio ciũra ikiumĩra ikĩiyũra bũrũri. ");
INSERT INTO kik_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","No aringi ciama a bũrũri wa Misiri magĩĩka maũndũ o ta macio na ũndũ wa maũgĩ mao ma ũgo, o nao magĩtũma ciũra ciũke bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Firaũni agĩĩta Musa na Harũni, akĩmeera atĩrĩ, “Hooyai Jehova anjehererie na ehererie andũ akwa ciũra ici, na nĩngũrekereria andũ anyu mathiĩ makarutĩre Jehova magongona.” ");
INSERT INTO kik_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Musa akĩĩra Firaũni atĩrĩ, “Wee nĩwe ngũhe gĩtĩĩo gĩa gũtua ihinda rĩa gũkũhoera, wee na anene aku o na andũ aku nĩguo inyuĩ na nyũmba cianyu mwehererwo nĩ ciũra, itigare o iria irĩ thĩinĩ wa Rũũĩ rwa Nili.” ");
INSERT INTO kik_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Firaũni akiuga atĩrĩ, “Mũkaahooera rũciũ.” Nake Musa akĩmũcookeria atĩrĩ, “Nĩgũtuĩke ũguo woiga, nĩgeetha ũmenye atĩ gũtirĩ mũndũ ũhaana ta Jehova Ngai witũ. ");
INSERT INTO kik_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ciũra nĩcigũkweherera na ciehere nyũmba ciaku, cieherere anene aku na andũ aku; itigare o iria irĩ rũũĩ-inĩ rwa Nili.” ");
INSERT INTO kik_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Na rĩrĩa Musa na Harũni mehereire Firaũni, Musa agĩkaĩra Jehova ũhoro wĩgiĩ ciũra iria aarehithĩirie Firaũni. ");
INSERT INTO kik_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Nake Jehova agĩĩka o ũrĩa Musa aahooete. Ciũra iria ciarĩ nyũmba, na iria ciarĩ nja na iria ciarĩ mĩgũnda igĩkua. ");
INSERT INTO kik_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ikĩũnganio ikĩigwo irũndo, nacio ikĩnungia bũrũri. ");
INSERT INTO kik_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","No rĩrĩa Firaũni onire atĩ marĩkũhoorerwo nĩ thĩĩna-rĩ, akĩũmia ngoro na akĩrega kũigua Musa na Harũni, o ta ũrĩa Jehova oigĩte. ");
INSERT INTO kik_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ĩra Harũni atĩrĩ, ‘Tambũrũkia rũthanju rwaku ũgũthe rũkũngũ rũrĩa rũrĩ thĩ,’ na bũrũri-inĩ wothe wa Misiri-rĩ, rũkũngũ rũu rũgũtuĩka rwagĩ.” ");
INSERT INTO kik_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Nao magĩĩka ũguo; na rĩrĩa Harũni aatambũrũkirie guoko anyiitĩte rũthanju-rĩ, agũtha rũkũngũ naguo, rwagĩ rũgĩtambĩrĩra andũ na nyamũ. Rũkũngũ ruothe bũrũri-inĩ wa Misiri rũgĩtuĩka rwagĩ. ");
INSERT INTO kik_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","No hĩndĩ ĩrĩa aringi a ciama a bũrũri wa Misiri maageririe kũrehe rwagĩ na maũgĩ mao ma ũgo-rĩ, nĩmaremirwo. Naruo rwagĩ rũgĩtambĩrĩra andũ na nyamũ. ");
INSERT INTO kik_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Aringi acio a ciama makĩĩra Firaũni atĩrĩ, “Ũyũ nĩ hinya wa kĩara kĩa Ngai.” No Firaũni akĩũmia ngoro akĩrega kũigua, o ta ũrĩa Jehova oigĩte. ");
INSERT INTO kik_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ũkĩra rũciinĩ tene, uumĩrĩre Firaũni agĩthiĩ Rũũĩ rwa Nili, ũmwĩre atĩrĩ, ‘Jehova ekuuga ũũ: Rekereria andũ akwa mathiĩ nĩgeetha makandungatĩre. ");
INSERT INTO kik_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ũngĩaga kũreka mathiĩ-rĩ, ngũkũrehera mĩrumbĩ ya ngi, ndehere anene aku na andũ aku, o na ndĩcirehe nyũmba-inĩ cianyu. Nyũmba cia andũ a Misiri ikũiyũra ngi, o na ningĩ ciyũre thĩ kũrĩa guothe marĩ. ");
INSERT INTO kik_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘No rĩrĩ, mũthenya ũcio ngeeka ũndũ ũrĩ ngũrani bũrũri-inĩ wa Gosheni, kũrĩa andũ akwa matũũraga; gũtikagĩa na mĩrumbĩ ya ngi kũu, nĩgeetha ũmenye atĩ niĩ, Jehova, ndĩ bũrũri-inĩ ũyũ. ");
INSERT INTO kik_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nĩngekĩra ngũũrani gatagatĩ ka andũ akwa na aku. Rũciũ nĩrĩo kĩama gĩkĩ gĩgekĩka.’ ” ");
INSERT INTO kik_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Na ũguo noguo Jehova eekire. Ngi mĩrumbĩ mĩnene ikĩiyũra nyũmba ya ũthamaki ya Firaũni na igĩtoonya nyũmba cia anene ake, naguo bũrũri wa Misiri wothe ũkĩanangwo nĩ ngi icio. ");
INSERT INTO kik_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ningĩ Firaũni agĩĩta Musa na Harũni, akĩmeera atĩrĩ, “Thiĩi mũkarutĩre Ngai wanyu iruta gũkũ bũrũri-inĩ.” ");
INSERT INTO kik_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","No Musa akĩmwĩra atĩrĩ, “Gũtingĩagĩrĩra gwĩka ũguo. Magongona marĩa tũkũrutĩra Jehova Ngai witũ nĩ mekuoneka marĩ magigi nĩ andũ a Misiri. Tũngĩkĩruta magongona marĩ magigi maitho-inĩ mao-rĩ, githĩ matigũtũhũũra na mahiga nyuguto? ");
INSERT INTO kik_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","No nginya tũthiĩ rũgendo rwa mĩthenya ĩtatũ werũ-inĩ tũkarutĩre Jehova Ngai witũ magongona, o ta ũrĩa atwathĩte.” ");
INSERT INTO kik_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Firaũni akiuga atĩrĩ, “Nĩngũmũrekereria mũthiĩ mũkarutĩre Jehova Ngai wanyu magongona werũ-inĩ, no mũtigathiĩ kũraya mũno. Na rĩu, hooerai.” ");
INSERT INTO kik_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Musa agĩcookia atĩrĩ, “Ndaarĩkia kuuma harĩwe, nĩngũhooya Jehova, na rũciũ ngi nĩikoima kũrĩ Firaũni na anene ake, na andũ ake. No ũkĩmenyerere atĩ Firaũni ndageke ũndũ wa kũheenania rĩngĩ, na ũndũ wa kwaga kũrekereria andũ mathiĩ makarutĩre Jehova magongona.” ");
INSERT INTO kik_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Musa agĩkiuma harĩ Firaũni, akĩhooya Jehova, ");
INSERT INTO kik_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","nake Jehova agĩĩka ũrĩa Musa aamũhoire; nacio ngi ikĩeherera Firaũni, na anene ake, na andũ ake, na gũtirĩ ngi yatigarire. ");
INSERT INTO kik_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","No rĩrĩ, o na ihinda rĩĩrĩ Firaũni akĩũmia ngoro yake akĩrega kũrekereria andũ mathiĩ. ");
INSERT INTO kik_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Thiĩ kũrĩ Firaũni ũkamwĩre atĩrĩ, ‘Jehova, o we Ngai wa Ahibirania ekuuga ũũ: “Rekereria andũ akwa mathiĩ, nĩgeetha makandungatĩre.” ");
INSERT INTO kik_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ũngĩrega kũmarekereria, na ũthiĩ na mbere kũmarigĩrĩria-rĩ, ");
INSERT INTO kik_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","guoko kwa Jehova nĩgũkũrehithĩria ũhiũ waku ũrĩa ũrĩ ũrĩithio-inĩ mũthiro mũũru mũno kũrĩ mbarathi cianyu na ndigiri, na ngamĩĩra, na ngʼombe cianyu, na ngʼondu na mbũri. ");
INSERT INTO kik_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","No Jehova nĩagekĩra ngũũrani gatagatĩ ka ũhiũ wa andũ a Isiraeli na andũ a Misiri, nĩgeetha gũtikagĩe nyamũ ya Mũisiraeli ĩgũkua.’ ” ");
INSERT INTO kik_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Jehova agĩtua ihinda, na akiuga atĩrĩ, “Rũciũ Jehova nĩageeka ũndũ ũyũ gũkũ bũrũri-inĩ.” ");
INSERT INTO kik_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Na mũthenya ũyũ ũngĩ Jehova agĩgĩka o ũguo: Ũhiũ wothe wa andũ a Misiri ũgĩkua, no gũtirĩ nyamũ o na ĩmwe ya Mũisiraeli yakuire. ");
INSERT INTO kik_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Firaũni agĩtũma andũ magatuĩrie ũhoro, nao makĩona atĩ gũtiarĩ nyamũ o na ĩmwe ya andũ a Isiraeli yakuĩte. No rĩrĩ, ngoro yake ndĩororoire na ndaigana kũrekereria andũ mathiĩ. ");
INSERT INTO kik_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ningĩ Jehova akĩĩra Musa na Harũni atĩrĩ, “Oyai ngundi cia mbiro kuuma riiko rĩrĩa inene, nake Musa amĩikie igũrũ mbere ya Firaũni. ");
INSERT INTO kik_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Mbiro ĩyo nĩĩgatuĩka rũkũngũ rũhinyu, naruo rũiyũre bũrũri wothe wa Misiri, rũcooke rũtuĩke mahũha ma ironda mĩĩrĩ-inĩ ya andũ na ya nyamũ bũrũri-inĩ ũcio wothe.” ");
INSERT INTO kik_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Nĩ ũndũ ũcio magĩkĩoya mbiro kuuma riiko inene, makĩrũgama mbere ya Firaũni. Musa akĩmĩikia igũrũ, namo mahũha ma ironda makiumĩra mĩĩrĩ-inĩ ya andũ o na ya nyamũ. ");
INSERT INTO kik_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Aringi ciama a Misiri matingĩahotire kũrũgama mbere ya Musa nĩ ũndũ wa mahũha marĩa maarĩ namo, hamwe na andũ othe a bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","No Jehova akĩũmia ngoro ya Firaũni, akĩrega kũigua Musa na Harũni, o ta ũrĩa Jehova eerĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ũkĩra rũciinĩ tene, ũkarũgame mbere ya Firaũni ũmwĩre atĩrĩ, ‘Ũũ nĩguo Jehova Ngai wa Ahibirania ekuuga: Rekereria andũ akwa mathiĩ, nĩgeetha makahooe, ");
INSERT INTO kik_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","kana ihinda rĩĩrĩ ngũtũmĩre mĩthiro yakwa yothe ya hinya, we o hamwe na anene aku na andũ aku, nĩguo ũmenye atĩ gũtirĩ ũngĩ ũhaana ta niĩ gũkũ thĩ guothe. ");
INSERT INTO kik_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nĩgũkorwo nginya rĩu nĩingĩhotete gũtambũrũkia guoko gwakwa, ngakũhũũra na ngahũũra andũ aku na mũthiro ũrĩa ũngĩmũniinĩte inyuothe thĩ. ");
INSERT INTO kik_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","No ngũrũgamĩtie nĩ ũndũ wa gĩtũmi gĩkĩ kĩũmbe, atĩ nguonie hinya wakwa, na atĩ rĩĩtwa rĩakwa rĩhunjio thĩ yothe. ");
INSERT INTO kik_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","No wĩyũmĩtie kũhinyĩrĩria andũ akwa na ũkagiria mathiĩ. ");
INSERT INTO kik_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nĩ ũndũ ũcio-rĩ, rũciũ ihinda ta rĩĩrĩ ngoiria mbura ya mbembe njũru mũno, ĩtarĩ yoira ĩngĩ tayo gũkũ bũrũri wa Misiri kuuma rĩrĩa Misiri kwambĩrĩirie gũtũũrwo nginya rĩu. ");
INSERT INTO kik_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Gĩathane rĩu atĩ ũhiũ waku na indo ciothe iria ũrĩ nacio mũgũnda itoonyio handũ ingĩĩgitia, tondũ mbura ĩyo ya mbembe yoirĩra mũndũ o wothe ũrĩ nja kana nyamũ ĩtarehetwo mũciĩ o yothe na ĩrĩ kũu mũgũnda no ĩgũkua.’ ” ");
INSERT INTO kik_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Anene acio a Firaũni arĩa meetigĩrĩte kiugo kĩa Jehova makĩhiũha gũtoonyia ngombo ciao na ũhiũ wao nyũmba thĩinĩ. ");
INSERT INTO kik_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","No arĩa mateetigĩrire kiugo kĩa Jehova maatigire ngombo ciao na ũhiũ wao mĩgũnda-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Tambũrũkia guoko ũkũroretie matu-inĩ nĩgeetha mbura ya mbembe yure bũrũri wa Misiri guothe; yurĩre andũ, na nyamũ na yurĩre kĩndũ gĩothe kĩrakũra mĩgũnda-inĩ ya bũrũri wa Misiri.” ");
INSERT INTO kik_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Rĩrĩa Musa aatambũrũkirie rũthanju arũroretie matu-inĩ, Jehova agĩtũma kũgĩe na marurumĩ hamwe na mbura ya mbembe, naruo rũheni rũkĩhenũka thĩ. Nĩ ũndũ ũcio Jehova akiuria mbura ya mbembe kũu bũrũri wa Misiri; ");
INSERT INTO kik_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","mbura ya mbembe ĩgĩkiura, naruo rũheni rũkĩhenũka kũndũ guothe. Nĩkĩo kĩarĩ kĩhuhũkanio kĩrĩa kĩũru mũno kĩonekanĩte bũrũri wothe wa Misiri kuuma wambĩrĩria gũtũũrwo nĩ andũ. ");
INSERT INTO kik_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mbura ĩyo ya mbembe ĩkiura bũrũri wothe wa Misiri, ĩkiurĩra kĩndũ gĩothe kĩarĩ mũgũnda, andũ o hamwe na nyamũ; ĩgĩthũkia kĩndũ gĩothe kĩarĩ mũgũnda na ĩgĩkahũra mĩtĩ yothe. ");
INSERT INTO kik_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kũndũ kũrĩa mbura ĩyo ya mbembe ĩtoirire no bũrũri wa Gosheni, kũrĩa andũ a Isiraeli maarĩ. ");
INSERT INTO kik_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Nake Firaũni agĩĩta Musa na Harũni, akĩmeera atĩrĩ, “Ihinda rĩĩrĩ nĩnjĩhĩtie. Jehova nĩwe wa ma; niĩ na andũ akwa nĩtũhĩtĩtie. ");
INSERT INTO kik_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hooyai Jehova, nĩgũkorwo nĩtũiganĩtie marurumĩ na mbura ya mbembe iria tuonete. Nĩngũmũrekereria mũthiĩ; mũtigũikara gũkũ rĩngĩ.” ");
INSERT INTO kik_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa akĩmũcookeria atĩrĩ, “Ndoima itũũra rĩĩrĩ inene, nĩngũtambũrũkia moko hooe Jehova. Marurumĩ nĩmegũthira, na gũtigũkorwo na mbura ĩngĩ ya mbembe, nĩgeetha ũmenye atĩ thĩ nĩ ya Jehova. ");
INSERT INTO kik_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","No nĩnjũũĩ atĩ wee na anene aku mũtirĩ mũretigĩra Jehova Ngai.” ");
INSERT INTO kik_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Ũguta na cairi nĩciathũkirio, nĩ ũndũ cairi nĩyarutĩte magira, naguo ũguta ũkaruta kĩro. ");
INSERT INTO kik_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","No rĩrĩ, ngano o na guthemethu itiathũkirio, tondũ itiarĩ ngũrũ.) ");
INSERT INTO kik_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Hĩndĩ ĩyo Musa akĩehera harĩ Firaũni na akiuma nja ya itũũra inene. Agĩtambũrũkia moko amaroretie na kũrĩ Jehova; marurumĩ na mbura ya mbembe igĩthira, na gũtiacookire kuura. ");
INSERT INTO kik_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Rĩrĩa Firaũni onire atĩ mbura ya mbembe na marurumĩ nĩciathira akĩĩhia rĩngĩ; we na anene ake makĩũmia ngoro ciao. ");
INSERT INTO kik_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Nĩ ũndũ ũcio ngoro ya Firaũni yarĩ nyũmũ na ndangĩarekereirie andũ a Isiraeli mathiĩ, o ta ũrĩa Jehova aarĩtie na kanua ka Musa. ");
INSERT INTO kik_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Thiĩ kũrĩ Firaũni, nĩgũkorwo nĩnyũmĩtie ngoro yake na ngoro cia anene ake nĩgeetha ninge ciama ici ciakwa gatagatĩ-inĩ kao; ");
INSERT INTO kik_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","nĩguo mũkeeraga ciana cianyu na ciana ciacio ũrĩa ndokĩrĩire andũ a Misiri, na ũrĩa ndaringire ciama ciakwa gatagatĩ-inĩ kao, nĩguo mũmenye atĩ niĩ nĩ niĩ Jehova.” ");
INSERT INTO kik_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Nĩ ũndũ ũcio Musa na Harũni magĩthiĩ kũrĩ Firaũni makĩmwĩra atĩrĩ, “Jehova Ngai wa Ahibirania ekuuga ũũ: ‘Ũgũikara nginya rĩ ũregete kũnjĩnyiihĩria? Rekereria andũ akwa mathiĩ, nĩgeetha makandungatĩre. ");
INSERT INTO kik_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Warega kũmarekereria-rĩ, rũciũ nĩngarehithia ngigĩ bũrũri ũyũ wanyu. ");
INSERT INTO kik_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ikaiyũra thĩ, imĩhumbĩre yage kuoneka. Nĩikarĩa kĩrĩa gĩothe gĩtigĩtio nĩ mbura ya mbembe, o na irĩe mĩtĩ yothe ĩrĩa ĩrakũra mĩgũnda-inĩ yanyu. ");
INSERT INTO kik_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ikaiyũra nyũmba ciaku, na cia anene aku, na cia andũ othe a Misiri, ũndũ maithe manyu kana maguuka manyu matarĩ mona kuuma rĩrĩa mambĩrĩirie gũtũũra bũrũri ũyũ nginya rĩu.’ ” Nake Musa akĩgarũrũka akĩeherera Firaũni. ");
INSERT INTO kik_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Anene a Firaũni makĩmwĩra atĩrĩ, “Nĩ nginya rĩ mũndũ ũyũ egũtũũra arĩ mũtego harĩ ithuĩ? Rekereria andũ aya mathiĩ, nĩgeetha makahooe Jehova Ngai wao. Ndũramenya atĩ bũrũri wa Misiri nĩwanangĩtwo?” ");
INSERT INTO kik_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Musa na Harũni magĩcookio kũrĩ Firaũni. Nake akĩmeera atĩrĩ, “Thiĩi mũkahooe Jehova Ngai wanyu; no rĩrĩ, nĩ arĩkũ megũthiĩ?” ");
INSERT INTO kik_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa akĩmũcookeria atĩrĩ, “Tũgũthiĩ na andũ aitũ arĩa ethĩ o na arĩa akũrũ, tũthiĩ na aanake na airĩtu aitũ, na tũthiĩ na ũhiũ witũ wothe, tondũ tũrathiĩ gũkũngũĩra Jehova na iruga inene.” ");
INSERT INTO kik_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Firaũni akiuga atĩrĩ, “Hĩ! Kaĩ Jehova arogĩikara na inyuĩ ingĩmũrekereria mũthiĩ na atumia anyu na ciana cianyu-ĩ! Hatirĩ nganja mũrĩ na muoroto mũũru. ");
INSERT INTO kik_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Aca! Thiĩi o arũme oiki, mũthiĩ mũhooe Jehova, nĩgũkorwo ũguo nĩguo mũkoretwo mũkĩenda.” Nao Musa na Harũni makĩingatwo, makĩehera mbere ya Firaũni. ");
INSERT INTO kik_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Nake Jehova akĩĩra Musa atĩrĩ, “Tambũrũkia guoko gwaku igũrũ rĩa bũrũri wa Misiri nĩgeetha ngigĩ ciũke ciyũre bũrũri ũyũ wothe, nacio irĩe kĩndũ gĩothe kĩrakũra mĩgũnda-inĩ, kĩrĩa gĩothe gĩatigirio nĩ mbura ya mbembe.” ");
INSERT INTO kik_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Nĩ ũndũ ũcio Musa agĩtambũrũkia rũthanju rwake igũrũ rĩa bũrũri wa Misiri, nake Jehova agĩtũma rũhuho ruumĩte irathĩro rũhurutane kũu bũrũri ũcio mũthenya wothe na ũtukũ wothe. Gũgĩkinya rũciinĩ rũhuho rũu nĩ rwarehete ngigĩ. ");
INSERT INTO kik_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Nacio ngigĩ icio ikĩhithũkĩra bũrũri wa Misiri wothe na igĩikara kũndũ guothe bũrũri-inĩ irĩ nyingĩ mũno. Mbere ĩyo gũtiagĩte mũthiro wa ngigĩ ta ũcio na gũtikagĩa ũngĩ ta ũcio. ");
INSERT INTO kik_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ikĩhumbĩra thĩ yothe o nginya ĩkĩira. Ikĩrĩa kĩrĩa gĩothe gĩatigarĩtio nĩ mbura ya mbembe, kĩrĩa gĩothe gĩakũraga mĩgũnda o na matunda marĩa maarĩ mĩtĩ-inĩ. Gũtirĩ kĩndũ kĩigũ gĩatigarire mũtĩ-inĩ kana mũmera bũrũri-inĩ wothe wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Nake Firaũni agĩĩta Musa na Harũni narua, akĩmeera atĩrĩ, “Nĩnjĩhĩirie Jehova Ngai wanyu, o na inyuĩ nĩndĩmwĩhĩirie. ");
INSERT INTO kik_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Rĩu ndekerai mehia makwa o rĩngĩ na mũhooe Jehova Ngai wanyu anjehererie mũthiro ũyũ mũũru.” ");
INSERT INTO kik_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Hĩndĩ ĩyo Musa akĩeherera Firaũni agĩthiĩ akĩhooya Jehova. ");
INSERT INTO kik_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nake Jehova akĩgarũra rũhuho, akĩrũtua rũhuho rũnene rwa kuuma ithũĩro, naruo rũkĩũmbũra ngigĩ icio, rũgĩcitwara Iria-inĩ Itune. Gũtirĩ gakigĩ o na kamwe gaatigarire bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","No Jehova akĩũmia ngoro ya Firaũni, nake akĩrega kũrekereria andũ a Isiraeli mathiĩ. ");
INSERT INTO kik_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Tambũrũkia guoko ũkũroretie igũrũ matu-inĩ nĩgeetha nduma ĩiyũre bũrũri wa Misiri, nduma ĩngĩhutĩka.” ");
INSERT INTO kik_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Nĩ ũndũ ũcio Musa agĩtambũrũkia guoko akũroretie igũrũ matu-inĩ, nayo nduma nene ĩkĩiyũra bũrũri wa Misiri mĩthenya ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Gũtirĩ mũndũ ũngĩahotire kuona ũrĩa ũngĩ kana oime gwake handũ ha mĩthenya ĩtatũ. No andũ a Isiraeli, othe kũrĩa maikaraga kwarĩ na ũtheri. ");
INSERT INTO kik_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ningĩ Firaũni agĩĩta Musa, akĩmwĩra atĩrĩ, “Thiĩi mũkahooe Jehova. O na atumia anyu na ciana no mathiĩ na inyuĩ; no rĩrĩ, mũtige ndũũru cianyu cia mbũri na cia ngʼombe.” ");
INSERT INTO kik_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","No Musa akĩmwĩra atĩrĩ, “No nginya ũtwĩtĩkĩrie tũkarutĩre Jehova Ngai witũ magongona na maruta ma njino. ");
INSERT INTO kik_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ũhiũ witũ no nginya tũthiĩ naguo; gũtirĩ o na ihũngũ tũgũtiga na thuutha. No nginya tũhũthĩre imwe ciacio tũkĩhooya Jehova Ngai witũ, na tũtingĩmenya nĩ irĩkũ irĩbatarania mahooya-inĩ nginya tũkinye kũu.” ");
INSERT INTO kik_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","No Jehova akĩũmia ngoro ya Firaũni, nake akĩrega kũmarekereria mathiĩ. ");
INSERT INTO kik_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Firaũni akĩĩra Musa atĩrĩ, “Uma, ũnjeherere! Wĩmenyerere ndũkanooke mbere yakwa rĩngĩ! Mũthenya ũrĩa ũkoona ũthiũ wakwa, no gũkua ũgaakua.” ");
INSERT INTO kik_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa akĩmũcookeria atĩrĩ, “O ta ũguo woiga, ndigooka mbere yaku rĩngĩ.” ");
INSERT INTO kik_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Na rĩrĩ, Jehova nĩeerĩte Musa atĩrĩ, “Nĩngũrehere Firaũni na bũrũri wa Misiri mũthiro ũngĩ ũmwe. Thuutha ũcio, nĩakamũrekereria mũthiĩ mume gũkũ, na rĩrĩa ageeka ũguo, nĩkũmũingata akaamũingata biũ. ");
INSERT INTO kik_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ĩra arũme othe, o hamwe na andũ-a-nja mahooe andũ a matũũra mao indo cia betha na cia thahabu.” ");
INSERT INTO kik_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Jehova agĩtũma andũ acio metĩkĩrĩke nĩ andũ a Misiri, na Musa we mwene aarĩ mũtĩĩku mũno kũu bũrũri wa Misiri nĩ anene a Firaũni o na andũ arĩa angĩ.) ");
INSERT INTO kik_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Nĩ ũndũ ũcio Musa akiuga atĩrĩ, “Jehova ekuuga ũũ: ‘Kũrĩ ta ũtukũ gatagatĩ nĩngatuĩkania bũrũri wa Misiri wothe. ");
INSERT INTO kik_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Mwana wothe wa kahĩĩ wa irigithathi gũkũ bũrũri wa Misiri nĩagaakua, kwambĩrĩria irigithathi rĩa Firaũni, rĩrĩa rĩikaragĩra gĩtĩ kĩa ũnene, nginya irigithathi rĩa ngombo ya mũirĩtu, ũrĩa ũrutaga wĩra gĩthĩi-inĩ, na marigithathi mothe ma ngʼombe o namo. ");
INSERT INTO kik_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Nĩgũkaagĩa kĩrĩro kĩnene bũrũri wa Misiri wothe, kĩrĩro kĩũru gĩtarĩ gĩakorwo kuo, na gĩtakagĩa kuo rĩngĩ o na rĩ. ");
INSERT INTO kik_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","No gatagatĩ ka andũ a Isiraeli, gũtirĩ ngui ĩgaakũgĩra mũndũ, kana ĩkũgĩre nyamũ.’ Hĩndĩ ĩyo nĩũkamenya atĩ Jehova nĩekĩrĩte ngũũrani harĩ andũ a Misiri na andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Anene aya aku othe magooka kũrĩ niĩ, manyinamĩrĩre makiugaga atĩrĩ, ‘Thiĩ, we mwene o na andũ arĩa makũrũmĩrĩire!’ Thuutha ũcio nĩngathiĩ.” Hĩndĩ ĩyo Musa, acinĩtwo nĩ marakara, akĩeherera Firaũni. ");
INSERT INTO kik_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Jehova nĩeerĩte Musa atĩrĩ, “Firaũni nĩakarega gũkũigua, nĩgeetha morirũ makwa gũkũ bũrũri wa Misiri mongerereke.” ");
INSERT INTO kik_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musa na Harũni nĩmaringire morirũ maya mothe mbere ya Firaũni, no Jehova akĩũmia ngoro ya Firaũni, na ndaigana kũrekereria andũ a Isiraeli moime bũrũri-inĩ wake. ");
INSERT INTO kik_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Jehova akĩĩra Musa na Harũni marĩ kũu bũrũri wa Misiri atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mweri ũyũ nĩguo ũgũtuĩka mweri wa mbere harĩ inyuĩ, ũtuĩke mweri wa mbere wa mwaka wanyu. ");
INSERT INTO kik_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ĩrai andũ othe a Isiraeli atĩ mũthenya wa ikũmi mweri ũyũ, o mũndũ akanyiitĩra andũ a nyũmba yake gatũrũme; o nyũmba gatũrũme kamwe. ");
INSERT INTO kik_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nyũmba ĩngĩgakorwo ĩrĩ nini mũno, ũndũ ĩtangĩniina gatũrũme kamwe-rĩ, nĩmanyiitanĩre gatũrũme kamwe na nyũmba ĩrĩa mahakanĩte nayo, marĩkĩtie gwĩtara mũigana wao meturanĩire. Rorai na mũtue wega nĩ tũtũrũme tũigana tũkabatarania kũringana na mũrĩĩre wa o mũndũ. ");
INSERT INTO kik_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Nyamũ iria mũgũthuura no nginya ikorwo irĩ tũtũrũme twa ũkũrũ wa mwaka ũmwe, na itarĩ na kaũũgũ, na mũgaaciruta kuuma harĩ ngʼondu kana mbũri. ");
INSERT INTO kik_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Cimenyererei nginya mũthenya wa ikũmi na ĩna wa mweri, hĩndĩ ĩrĩa andũ othe a Isiraeli magaacithĩnja hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Hĩndĩ ĩyo makooya thakame ĩmwe ya tũtũrũme tũu, nao mamĩhake hingĩro-inĩ cia igũrũ na cia mĩena ya mũrango wa nyũmba ĩrĩa makaarĩĩra tũtũrũme tũu. ");
INSERT INTO kik_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ũtukũ o ũcio makaarĩa nyama icio ihĩhĩtio na mwaki, marĩĩanĩrie na nyeni ndũrũ na mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia. ");
INSERT INTO kik_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Mũtikanarĩe nyama irĩ njĩthĩ kana itherũkĩtio na maaĩ, no ihĩhio na mwaki, mũtwe, na magũrũ o na nyama cia nda. ");
INSERT INTO kik_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Mũtikanatigie imwe ciacio ikinyĩrie rũciinĩ; iria ingĩtigara nginya rũciinĩ, no nginya mũgaacicina. ");
INSERT INTO kik_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ũũ nĩguo mũkaarĩa nyama icio: mũkorwo mwĩhotorete mĩcibi yanyu njohero, na iraatũ cianyu irĩ magũrũ, na mĩtirima yanyu ĩrĩ moko. Mũgaacirĩa naihenya; ĩyo nĩyo Bathaka ya Jehova. ");
INSERT INTO kik_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“O ũtukũ ũcio nĩngatuĩkanĩria bũrũri wa Misiri, na nĩngooraga marigithathi mothe ma andũ na ma nyamũ, na nĩngatuĩra ngai cia bũrũri wa Misiri ciothe ciira. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Thakame ĩyo ĩgaatuĩka rũũri rwanyu nyũmba-inĩ iria mũgaakorwo mũrĩ, na rĩrĩa ngoona thakame-rĩ, no kũmũhĩtũka ngaamũhĩtũka. Gũtirĩ mũthiro ũkamũhutia hĩndĩ ĩrĩa ngaahũũra bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Mũthenya ũcio nĩmũrĩũririkanaga; ũkũngũyagĩrei harĩ njiarwa iria igooka ũrĩ wa gĩathĩ kĩa Jehova, ũrĩ ũndũ wathanĩtwo wa gũtũũra. ");
INSERT INTO kik_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ihinda rĩa mĩthenya mũgwanja, mũkaarĩĩaga mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia. Mũthenya wa mbere mũkeeheria ndawa ya kũimbia kuuma nyũmba cianyu, nĩgũkorwo mũndũ o wothe ũngĩrĩa kĩndũ kĩrĩ ndawa ya kũimbia kuuma mũthenya wa mbere nginya wa mũgwanja-rĩ, nĩakaingatwo eherio harĩ andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Gĩai na kĩũngano gĩtheru mũthenya wa mbere, na mũgĩe na kĩngĩ mũthenya wa mũgwanja. Mũtikanarute wĩra o na ũrĩkũ mĩthenya ĩyo, tiga o wa kũhaarĩria irio cia kũrĩĩo nĩ mũndũ wothe, ũguo noguo mũngĩĩka. ");
INSERT INTO kik_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Kũngũĩrai Gĩathĩ kĩa Mĩgate Ĩtarĩ Ndawa ya Kũimbia, tondũ nĩ mũthenya ũyũ kĩũmbe ndamũrutire mũrĩ ikundi kuuma bũrũri wa Misiri. Kũngũĩrai mũthenya ũyũ ũrĩ ũndũ wathanĩtwo wa gũtũũra nginya njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Mweri wa mbere mũrĩrĩĩaga mĩgate ĩtarĩ na ndawa ya kũimbia, kwambĩrĩria hwaĩ-inĩ wa mũthenya wa ikũmi na ĩna, nginya hwaĩ-inĩ wa mũthenya wa mĩrongo ĩrĩ na ũmwe. ");
INSERT INTO kik_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Handũ ha matukũ mũgwanja, gũtikoneke ndawa ya kũimbia mĩgate nyũmba-inĩ cianyu. Na rĩrĩ, mũndũ o wothe ũngĩrĩa kĩndũ kĩrĩ na ndawa ya kũimbia nĩakaingatwo athengio mũingĩ-inĩ wa Isiraeli, arĩ mũgeni, kana aciarĩtwo arĩ Mũisiraeli. ");
INSERT INTO kik_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Mũtikanarĩe kĩndũ gĩĩkĩrĩtwo ndawa ya kũimbia. Kũrĩa guothe mũgaatũũra, mũkaarĩĩaga mĩgate ĩtarĩ ndawa ya kũimbia.” ");
INSERT INTO kik_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Nake Musa agĩĩta athuuri a Isiraeli othe, akĩmeera atĩrĩ, “Thiĩi o narua mũgathuure nyamũ nĩ ũndũ wa nyũmba cianyu na mũthĩnje gatũrũme ka Bathaka. ");
INSERT INTO kik_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Oyai kĩohe kĩa mahuti ma mũthobi, mũgĩtobokie karaĩ-inĩ karĩ na thakame, mũcooke mũmĩhake hingĩro ya igũrũ ya mũrango, o na mĩena yeerĩ ya hingĩro cia mũrango. Gũtikagĩe mũndũ o na ũmwe wanyu ũkuuma nja ya nyũmba yake nginya rũciinĩ. ");
INSERT INTO kik_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Hĩndĩ ĩrĩa Jehova arĩtuĩkania bũrũri nĩguo orage andũ a Misiri-rĩ, nĩarĩona thakame ĩyo ĩrĩ igũrũ na mĩena ya hingĩro cia mĩrango, nake ahĩtũke mũromo wa nyũmba ĩyo, na nĩakagiria mũniinani atoonye nyũmba cianyu amũũrage. ");
INSERT INTO kik_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Athĩkĩrai ũrutani ũyũ taarĩ watho wa gũtũũra wathĩkagĩrwo nĩ inyuĩ na njiaro cianyu. ");
INSERT INTO kik_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Rĩrĩa mũgaatoonya bũrũri ũrĩa Jehova akaamũhe ta ũrĩa eranĩire-rĩ, mũkaamenyagĩrĩra gĩathĩ gĩkĩ. ");
INSERT INTO kik_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Na rĩrĩa ciana cianyu ikamũũria atĩrĩ, ‘Gĩathĩ gĩkĩ kiugĩte atĩa harĩ inyuĩ?’ ");
INSERT INTO kik_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mũgaaciĩra atĩrĩ, ‘Nĩ igongona rĩa Bathaka rĩa kũrutĩra Jehova, ũrĩa waagararire nyũmba cia andũ a Isiraeli kũu bũrũri wa Misiri, na akĩhonokia andũ a nyũmba ciitũ hĩndĩ ĩrĩa ooragire andũ a Misiri.’ ” Nao andũ makĩinamĩrĩria mothiũ mao, makĩhooya. ");
INSERT INTO kik_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Andũ a Isiraeli magĩgĩka o ũrĩa Jehova aathire Musa na Harũni. ");
INSERT INTO kik_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","O ũtukũ gatagatĩ Jehova akĩũraga marigithathi mothe kũu bũrũri wa Misiri, kwambĩrĩria irigithathi rĩa Firaũni, ũrĩa waikaragĩra gĩtĩ kĩa ũnene, nginya irigithathi rĩa mũndũ muohe ũrĩa warĩ njeera na marigithathi ma mahiũ mothe. ");
INSERT INTO kik_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Firaũni na anene ake othe o na andũ a Misiri othe, magĩũkĩra kũrĩ o ũtukũ, nakuo gũkĩgĩa kĩrĩro kĩnene kũu bũrũri wa Misiri, nĩgũkorwo gũtiarĩ nyũmba ĩtaarĩ na mũndũ wakuĩte. ");
INSERT INTO kik_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","O ũtukũ ũcio, Firaũni agĩĩta Musa na Harũni, akĩmeera atĩrĩ, “Ũkĩrai! Ehererai andũ akwa, inyuĩ o na andũ a Isiraeli othe! Thiĩi mũgatungatĩre Jehova o ta ũrĩa mũũrĩtie. ");
INSERT INTO kik_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Oyai ndũũru cianyu cia mbũri na cia ngʼombe o ta ũrĩa mũroigĩte na mũthiĩ. Na mũndathime o na niĩ.” ");
INSERT INTO kik_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Nao andũ a Misiri makĩhĩka andũ acio moime bũrũri ũcio na ihenya, nĩgũkorwo moigire atĩrĩ, “Kwaga ũguo, tũgũkua ithuothe!” ");
INSERT INTO kik_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Nĩ ũndũ ũcio andũ a Isiraeli makĩoya kĩmere kĩao gĩtanekĩrwo ndawa ya kũimbia, na magĩgĩkuua na ciande, nayo mĩharatĩ yoohereirwo nguo-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Nao andũ a Isiraeli magĩĩka o ta ũrĩa meerĩĩtwo nĩ Musa na makĩhooya andũ a Misiri mamahe indo cia betha na cia thahabu, o na nguo. ");
INSERT INTO kik_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Jehova agĩtũma andũ acio metĩkĩrĩke nĩ andũ a Misiri nao makĩmahe kĩrĩa gĩothe meetirie; nĩ ũndũ ũcio magĩtaha indo cia andũ a Misiri. ");
INSERT INTO kik_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Andũ a Isiraeli makĩambĩrĩria rũgendo kuuma Ramesese magĩthiĩ Sukothu. Arũme arĩa metwaraga na magũrũ maarĩ ta 600,000 hategũtarwo atumia na ciana. ");
INSERT INTO kik_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Na andũ angĩ aingĩ nĩmathiire na makĩambatania nao, hamwe na ndũũru nene cia mahiũ ma mbũri na ngʼombe. ");
INSERT INTO kik_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kĩmere kĩrĩa maarutĩte bũrũri wa Misiri nĩkĩo maatũmĩrire gũthondeka mĩgate ĩtarĩ ndawa ya kũimbia. Kĩmere kĩu gĩtiarĩ na ndawa ya kũimbia tondũ nĩkũingatwo maingatirwo bũrũri wa Misiri, na matiigana kũgĩa na ihinda rĩa kũhaarĩria irio ciao. ");
INSERT INTO kik_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ihinda rĩrĩa andũ a Isiraeli maatũũrire bũrũri wa Misiri nĩ mĩaka 430. ");
INSERT INTO kik_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Harĩa mĩaka ĩyo 430 yathirĩire-rĩ, mũthenya o ro ũcio, nĩguo ikundi ciothe cia andũ a Jehova cioimire bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tondũ ũtukũ ũcio nĩguo Jehova aikarire eiguĩte nĩguo amarute bũrũri wa Misiri-rĩ, na ũtukũ ũyũ nao andũ a Isiraeli othe nĩmarĩikaraga meiguĩte nĩguo matĩĩage Jehova njiarwa-inĩ ciothe iria igooka. ");
INSERT INTO kik_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Jehova akĩĩra Musa na Harũni atĩrĩ, “Maya nĩmo mawatho ma Bathaka: “Gũtirĩ mũgeni ũngĩrĩa Bathaka ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ngombo o yothe ũgũrĩte no ĩrĩe Bathaka ĩyo thuutha wa kũmĩruithia, ");
INSERT INTO kik_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","no mũrarĩrĩri kana mũruti wĩra wa mũcaara ndakanamĩrĩe. ");
INSERT INTO kik_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“No nginya ĩrĩĩagĩrwo thĩinĩ wa nyũmba o ĩmwe, mũtikanoimie nyama o na ĩrĩkũ nja ya nyũmba. Mũtikanoine ihĩndĩ o na rĩmwe rĩayo. ");
INSERT INTO kik_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Mũingĩ wothe wa Isiraeli no nginya ũkũngũĩre Bathaka. ");
INSERT INTO kik_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Mũgeni ũtũũrĩte thĩinĩ wanyu na nĩekwenda gũkũngũĩra Bathaka ya Jehova, no nginya aruithie arũme othe a nyũmba yake; thuutha ũcio nĩrĩo angĩkũngũĩra Bathaka ta mũndũ ũciarĩirwo bũrũri-inĩ. Gũtirĩ mũndũ mũrũme ũtarĩ mũruu ũngĩrĩa Bathaka. ");
INSERT INTO kik_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Watho o ũcio noguo ũgwatha arĩa maciarĩtwo marĩ a bũrũri, o na ageni arĩa matũũranagia na inyuĩ.” ");
INSERT INTO kik_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Andũ a Isiraeli othe magĩĩka o ũrĩa Jehova aathĩte Musa na Harũni. ");
INSERT INTO kik_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Na mũthenya o ro ũcio, Jehova akĩruta andũ a Isiraeli kuuma bũrũri wa Misiri na ikundi ciao. ");
INSERT INTO kik_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Nyamũrĩra marigithathi mothe ma twana twa tũhĩĩ. Maciaro ma mbere ma nda o yothe gatagatĩ-inĩ ka andũ a Isiraeli nĩ makwa, marĩ ma mũndũ kana ma nyamũ.” ");
INSERT INTO kik_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Nake Musa akĩĩra andũ atĩrĩ, “Ririkanagai mũthenya ũyũ, mũthenya ũrĩa mwoimire bũrũri wa Misiri, mũkiuma bũrũri wa ũkombo, tondũ Jehova nĩamũrutire kuo na guoko kwa hinya. Mũtikarĩĩage kĩndũ kĩrĩ na ndawa ya kũimbia. ");
INSERT INTO kik_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ũmũthĩ, mweri-inĩ ũyũ wa Abibu, nĩguo mũroimagara mũthiĩ. ");
INSERT INTO kik_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Rĩrĩa Jehova akaamũkinyia bũrũri wa Akaanani, na Ahiti, na Aamori, na Ahivi, na Ajebusi bũrũri ũrĩa eehĩtire mbere ya maithe manyu ma tene atĩ nĩakamũhe bũrũri ũrĩ bũthi wa iria na ũũkĩ-rĩ, mũkaamenyagĩrĩra gĩathĩ gĩkĩ mweri-inĩ ũyũ: ");
INSERT INTO kik_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ihinda rĩa mĩthenya mũgwanja mũkaarĩĩaga mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia na mũthenya wa mũgwanja mũthondeke iruga inene nĩ ũndũ wa Jehova. ");
INSERT INTO kik_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Rĩĩagai mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia ihinda rĩa mĩthenya ĩyo mũgwanja; gũtikoneke kĩndũ kĩrĩ na ndawa ya kũimbia gatagatĩ kanyu, kana ndawa ya kũimbia yoneke handũ o hothe mĩhaka-inĩ yanyu. ");
INSERT INTO kik_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Mũthenya ũcio o mũndũ ere mũriũ atĩrĩ, ‘Ndĩreka ũũ tondũ wa ũrĩa Jehova aanjĩkĩire rĩrĩa ndoimire bũrũri wa Misiri.’ ");
INSERT INTO kik_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Kũmenyerera mũthenya ũyũ nĩkuo kũrĩtuĩkaga ta rũũri guoko-inĩ gwaku, na kĩririkania ũthiũ-inĩ waku, atĩ watho wa Jehova nĩũrĩikaraga iromo-inĩ ciaku. Nĩgũkorwo Jehova nĩakũrutire bũrũri wa Misiri na guoko gwake kwa hinya. ");
INSERT INTO kik_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","No nginya mũrũmie watho ũyũ mwathane ihinda rĩaguo rĩakinya, mwaka o mwaka. ");
INSERT INTO kik_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Thuutha wa Jehova kũmũkinyia bũrũri wa Akaanani na amũhe guo, o ta ũrĩa eeranĩire na mwĩhĩtwa kũrĩ inyuĩ o na maithe manyu ma tene-rĩ, ");
INSERT INTO kik_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","nĩmũkahe Jehova maciaro ma mbere ma nda ciothe. Marigithathi ma njamba mothe ma ũhiũ wanyu nĩ ma Jehova. ");
INSERT INTO kik_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mũgaakũũraga irigithathi o rĩothe rĩa ndigiri na gatũrũme, no mũngĩaga kũrĩkũũra-rĩ, mũriune ngingo. Kũũragai marigithathi mothe manyu ma aanake. ");
INSERT INTO kik_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Matukũ-inĩ marĩa magooka, rĩrĩa mũrũguo agaakũũria atĩrĩ, ‘Ũũ nĩ kuuga atĩa?’ mwĩre atĩrĩ, ‘Jehova aatũrutire bũrũri wa Misiri, agĩtũruta bũrũri wa ũkombo, na guoko gwake kwa hinya. ");
INSERT INTO kik_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Rĩrĩa Firaũni omirie mũtwe akĩrega gũtũrekereria-rĩ, Jehova nĩooragire marigithathi ma bũrũri wa Misiri mothe, andũ o na nyamũ. Ũndũ ũcio nĩguo ũtũmaga ndutĩre Jehova igongona rĩa njamba ciothe iria ciambaga kuuma nda, na ngakũũra mũriũ wakwa wothe wa irigithathi. ");
INSERT INTO kik_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Naguo ũndũ ũcio ũrĩtuĩkaga ta rũũri guoko-inĩ gwaku, o na ũtuĩkage kĩonania gĩĩkĩrĩtwo ũthiũ-inĩ waku, atĩ Jehova nĩatũrutire bũrũri wa Misiri na guoko gwake kwa hinya.’ ” ");
INSERT INTO kik_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Rĩrĩa Firaũni aarekereirie andũ a Isiraeli mathiĩ-rĩ, Ngai ndaamatongoreirie njĩra-inĩ ya kũhĩtũkĩra bũrũri wa Afilisti, o na gũtuĩka ĩyo nĩyo yarĩ njĩra ĩrĩa nguhĩ. Nĩgũkorwo Ngai oigire atĩrĩ, “Mangĩcemania na mbaara-rĩ, maahota kwĩricũkwo, macooke bũrũri wa Misiri.” ");
INSERT INTO kik_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Nĩ ũndũ ũcio Ngai agĩgĩtongoria andũ acio mathiũrũrũkĩire njĩra ya werũ-inĩ merekeire Iria Itune. Andũ a Isiraeli maambatire makiuma bũrũri wa Misiri meeohete indo cia mbaara. ");
INSERT INTO kik_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Musa nĩakuuire mahĩndĩ ma Jusufu, nĩ ũndũ Jusufu nĩehĩtithĩtie ariũ a Isiraeli na mwĩhĩtwa. Oigĩte atĩrĩ, “Ti-itherũ Ngai nĩakamũteithia, na inyuĩ hĩndĩ ĩyo no nginya mũgaakuua mahĩndĩ makwa kuuma kũndũ gũkũ.” ");
INSERT INTO kik_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Thuutha wa kuuma Sukothu maambire kambĩ ciao Ethamu ndeere-inĩ cia werũ. ");
INSERT INTO kik_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Mũthenya, Jehova aathiiaga mbere yao arĩ gĩtugĩ-inĩ gĩa itu gĩa kũmoonereria njĩra, na ũtukũ-rĩ, aathiiaga mbere yao arĩ gĩtugĩ-inĩ kĩa mwaki amamũrĩkĩire njĩra, nĩgeetha mahote gũthiĩ mũthenya o na ũtukũ. ");
INSERT INTO kik_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gĩtugĩ gĩa itu mũthenya kana gĩtugĩ kĩa mwaki ũtukũ, gũtirĩ kĩeheraga handũ hakĩo mbere ya andũ acio. ");
INSERT INTO kik_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Ĩra andũ a Isiraeli macooke na thuutha, na mambe hema gũkuhĩ na Pi-Hahirothu, gatagatĩ ka Migidoli na iria. Nĩmambe hema hũgũrũrũ-inĩ cia iria, kũngʼethanĩra na Baali-Zefoni. ");
INSERT INTO kik_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Firaũni nĩageciiria atĩrĩ, ‘andũ a Isiraeli marĩ na kĩrigiicano no kũũrũũra marorũũra bũrũri-inĩ, mahingĩrĩirio nĩ werũ.’ ");
INSERT INTO kik_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Na nĩngomia ngoro ya Firaũni, nake nĩakamaingatithia. No niĩ mwene nĩngegĩĩra na riiri nĩ ũndũ wa Firaũni na mbũtũ yake yothe ya ita, nao andũ a Misiri nĩmakamenya atĩ niĩ nĩ niĩ Jehova.” Nĩ ũndũ ũcio andũ a Isiraeli magĩĩka o ũguo merĩtwo. ");
INSERT INTO kik_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Rĩrĩa mũthamaki wa bũrũri wa Misiri eerirwo atĩ andũ acio nĩmorĩte-rĩ, Firaũni na anene ake makĩĩricũkwo ũhoro ũcio, magĩkiuga atĩrĩ, “Hĩ! Tweka atĩa? Twarekereria andũ a Isiraeli mathiĩ na ithuĩ tuorĩrwo nĩ ũtungata wao?” ");
INSERT INTO kik_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Nĩ ũndũ ũcio akiuga ngaari yake ya ita ĩhaarĩrio, na agĩthiĩ na mbũtũ yake ya ita. ");
INSERT INTO kik_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Agĩthiĩ na ngaari cia ita 600 iria njega mũno, o hamwe na ngaari cia ita iria ingĩ ciothe cia bũrũri wa Misiri, ciothe irũgamĩrĩirwo nĩ anene. ");
INSERT INTO kik_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Jehova akĩũmia ngoro ya Firaũni mũthamaki wa bũrũri wa Misiri, na nĩ ũndũ ũcio akĩrũmĩrĩra andũ a Isiraeli na ihenya arĩa moimagarĩte makinyũkĩtie na ũcamba. ");
INSERT INTO kik_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Andũ a Misiri, hamwe na mbarathi ciothe cia Firaũni na ngaari cia ita, na andũ arĩa mathiiaga mahaicĩte mbarathi, na thigari, makĩrũmĩrĩra andũ a Isiraeli na ihenya makĩmakinyĩra harĩa maambĩte hema rũteere-inĩ rwa iria, hakuhĩ na Pi-Hahirothu kũngʼethera Baali-Zefoni. ");
INSERT INTO kik_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Firaũni akuhĩrĩria-rĩ, andũ a Isiraeli makĩĩhũgũra, makĩona andũ a Misiri mamoimĩte thuutha makĩmaka mũno, magĩkaĩra Jehova. ");
INSERT INTO kik_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Makĩĩra Musa atĩrĩ, “Nĩ mbĩrĩra gũtaarĩ bũrũri wa Misiri, nĩguo ũtũrehe tũkuĩre gũkũ werũ-inĩ? Nĩ atĩa ũũ ũtwĩkĩte ũgatũruta bũrũri wa Misiri? ");
INSERT INTO kik_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Githĩ tũtiakwĩrire tũrĩ o bũrũri wa Misiri atĩ ũtigane na ithuĩ, ũreke tũtungatĩre andũ a bũrũri wa Misiri? Kũngĩarĩ wega tũtungatĩre andũ a Misiri kũrĩ gũkuĩra werũ-inĩ!” ");
INSERT INTO kik_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa agĩcookeria andũ acio atĩrĩ, “Tigai gwĩtigĩra. Mwĩhaandei wega, na nĩmũkuona ũhonokio ũrĩa Jehova ekũmũrehere ũmũthĩ. Andũ a Misiri aya mũrona ũmũthĩ, mũtikamona rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jehova nĩekũmũrũĩrĩra, mũbatie o gũikara mũhooreire.” ");
INSERT INTO kik_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ũrangaĩra nĩkĩ? Ĩra andũ a Isiraeli mathiĩ na mbere. ");
INSERT INTO kik_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Oya rũthanju rwaku, na ũtambũrũkie guoko igũrũ wa iria ũgayanie maaĩ nĩgeetha andũ a Isiraeli matuĩkanĩrie iria-inĩ, mathiĩrĩire thĩ nyũmũ. ");
INSERT INTO kik_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nĩngũũmia ngoro cia andũ a Misiri nĩgeetha o nao mamarũmĩrĩre. Na nĩngegĩĩra riiri nĩ ũndũ wa Firaũni na mbũtũ yake ya ita, o na nĩ ũndũ wa ngaari ciake cia ita, o na andũ ake arĩa mathiiaga mahaicĩte mbarathi. ");
INSERT INTO kik_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Nao andũ a Misiri nĩmakamenya atĩ niĩ nĩ niĩ Jehova hĩndĩ ĩyo ngegĩĩra riiri nĩ ũndũ wa Firaũni, na ngaari ciake cia ita na andũ ake arĩa mathiiaga mahaicĩte mbarathi.” ");
INSERT INTO kik_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hĩndĩ ĩyo mũraika wa Ngai ũrĩa wathiiaga atongoretie mbũtũ ya thigari cia Isiraeli, akĩehera agĩcooka thuutha wao. Gĩtugĩ gĩa itu nakĩo gĩkiuma hau mbere, gĩkĩrũgama thuutha wao, ");
INSERT INTO kik_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","gĩkĩgĩa gatagatĩ ga thigari cia Misiri na cia Isiraeli. Ũtukũ wothe itu rĩu rĩgĩĩkĩra nduma mwena ũmwe, na ũtheri mwena ũrĩa ũngĩ; nĩ ũndũ ũcio gũtirĩ andũ makuhĩrĩirie arĩa angĩ ũtukũ wothe. ");
INSERT INTO kik_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ningĩ Musa agĩtambũrũkia guoko igũrũ wa iria, na ũtukũ wothe Jehova agĩtindĩka iria na thuutha na ũndũ wa rũhuho rwa kuuma mwena wa irathĩro, na agĩtũma hau hatuĩke thĩ nyũmũ. Maaĩ macio makĩgayũkana, ");
INSERT INTO kik_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","nao andũ a Isiraeli makĩringa iria mahĩtũkĩire thĩ nyũmũ, maaĩ marũgamĩte mwena wao wa ũrĩo na wa ũmotho. ");
INSERT INTO kik_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Nao andũ a Misiri makĩmarũmĩrĩra na ihenya, nacio mbarathi ciothe cia Firaũni na ngaari cia ita, na andũ arĩa mathiiaga mahaicĩte mbarathi makĩmarũmĩrĩra nginya iria-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Rũciinĩ ruoro rũgĩtema-rĩ, Jehova agĩcũthĩrĩria mbũtũ ya ita ya andũ a Misiri arĩ gĩtugĩ-inĩ kĩa mwaki na gĩa itu, nake akĩmĩrigiica. ");
INSERT INTO kik_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Agĩtũma magũrũ ma ngaari ciao cia ita macomoke nĩgeetha makorwo na thĩĩna wa gũcitwarithia. Nao andũ a Misiri makiuga atĩrĩ, “Nĩtũũrei twehere harĩ andũ aya a Isiraeli! Jehova nĩwe ũramarũĩrĩra kũrĩ andũ a Misiri.” ");
INSERT INTO kik_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Tambũrũkia guoko igũrũ wa iria nĩgeetha maaĩ macooke mahubanĩrie andũ a Misiri na ngaari ciao cia ita, na andũ arĩa mathiiaga mahaicĩte mbarathi.” ");
INSERT INTO kik_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Musa agĩtambũrũkia guoko gwake igũrũ wa iria, na gũgĩkĩa-rĩ, iria rĩgĩcooka gũtherera o ta mbere. Nao andũ a Misiri makĩgeria kũrĩũrĩra, no Jehova akĩmahubanĩria iria-inĩ thĩinĩ. ");
INSERT INTO kik_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Maaĩ magĩcookana, magĩthika ngaari cia ita na andũ arĩa mathiiaga mahaicĩte mbarathi; nĩo mbũtũ yothe ya Firaũni ĩrĩa yarũmĩrĩire andũ a Isiraeli iria-inĩ. Gũtirĩ o na ũmwe wao wahonokire. ");
INSERT INTO kik_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","No andũ a Isiraeli maaringire iria magereire njĩra nyũmũ, rũthingo rwa maaĩ rũrũgamĩte mwena wao wa ũrĩo na wa ũmotho. ");
INSERT INTO kik_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mũthenya ũcio Jehova akĩhonokia Isiraeli kuuma moko-inĩ ma andũ a Misiri, nao andũ a Isiraeli makĩĩonera ciimba cia andũ a Misiri kũu hũgũrũrũ-inĩ cia iria. ");
INSERT INTO kik_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Na rĩrĩa andũ a Isiraeli moonire hinya mũnene ũrĩa Jehova onirie andũ a Misiri-rĩ, andũ acio magĩĩtigĩra Jehova na makĩmwĩhoka o na makĩĩhoka Musa ndungata yake. ");
INSERT INTO kik_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Hĩndĩ ĩyo Musa na andũ a Isiraeli makĩinĩra Jehova rwĩmbo rũrũ: “Nĩngũinĩra Jehova, nĩgũkorwo nĩwe ũtũũgĩrĩtio mũno. Mbarathi amĩikĩtie iria-inĩ hamwe na mũmĩhaici. ");
INSERT INTO kik_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Jehova nĩwe hinya wakwa na rwĩmbo rwakwa; nĩwe ũtuĩkĩte ũhonokio wakwa. Nĩwe Ngai wakwa na nĩndĩĩmũgoocaga, Nĩwe Ngai wa baba na nĩndĩĩmũtũũgagĩria. ");
INSERT INTO kik_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Jehova nĩ njamba ya ita; Jehova nĩrĩo rĩĩtwa rĩake. ");
INSERT INTO kik_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ngaari cia ita cia Firaũni na mbũtũ yake aamĩikirie iria-inĩ. Anene arĩa ega mũno a Firaũni moorĩire maaĩ-inĩ ma Iria Itune. ");
INSERT INTO kik_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Maaĩ marĩa mariku nĩmamathikĩte; Nao magakĩrikĩra kũrĩa kũriku ta ihiga. ");
INSERT INTO kik_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Wee Jehova, guoko gwaku kwa ũrĩo kwarĩ gwa kũgegania, gũkagĩa hinya. Wee Jehova, guoko gwaku kwa ũrĩo nĩ gwathuthangire thũ. ");
INSERT INTO kik_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nĩ ũndũ wa ũnene waku wa magegania, nĩwakurumanirie arĩa magũũkĩrĩire. Nĩwaitũrũrire marakara maku mahiũ; makĩmacina taarĩ mahuti. ");
INSERT INTO kik_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na ũndũ wa mũrurumo wa mĩhũmũ ya maniũrũ maku-rĩ, maaĩ nĩmeiganĩrĩire hĩba. Makũmbĩ ma maaĩ makĩrũgama ta rũthingo; maaĩ ma kũrĩa kũriku makĩnyiitana gatagatĩ ka iria. ");
INSERT INTO kik_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Thũ nayo yetĩĩte, ĩkoiga atĩrĩ, ‘Nĩngamarũmĩrĩra na ihenya, ndĩmakinyĩre. Ngagayania indo iria matahĩte, ndĩĩhũũnĩrĩrie nacio. Nĩngũcomora rũhiũ rwakwa rwa njora, nakuo guoko gwakwa kũmaniine.’ ");
INSERT INTO kik_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","No wahuhire rũhuho rũkĩhurutana, narĩo iria rĩkĩmathika, makĩrika ta kĩgera maaĩ-inĩ maingĩ. ");
INSERT INTO kik_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Wee Jehova-rĩ, nũũ ũhaana tawe harĩ ngai ciothe? Nũũ ũhaana tawe, wee ũrĩ ũtheru wa magegania, wee wĩtigĩrĩtwo nĩ ũndũ wa riiri waku, wee wĩkaga maũndũ ma magegania? ");
INSERT INTO kik_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Watambũrũkirie guoko gwaku kwa ũrĩo, nayo thĩ ĩkĩmameria. ");
INSERT INTO kik_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Nĩ ũndũ wa wendo waku ũtathiraga, nĩũgũtongoria andũ arĩa ũkũũrĩte. Nĩũkamatongoria na ũndũ wa hinya waku, ũmatware nginya gĩikaro gĩaku gĩtheru. ");
INSERT INTO kik_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ndũrĩrĩ ikaigua, nacio ciinaine; ruo rũnyiite andũ a Filistia. ");
INSERT INTO kik_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Aathani a Edomu nĩmakamaka mũno, na atongoria a Moabi manyiitwo nĩ kũinaina, andũ a Kaanani makaiyũrwo nĩ maaĩ nda; ");
INSERT INTO kik_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","guoya na kĩmako nĩikamakinyĩrĩra. Na ũndũ wa hinya wa guoko gwaku-rĩ, makahaana ta ihiga matekwĩnyagunyia, nginya andũ aku, Wee Jehova, maringe, nginya andũ arĩa wegũrĩire maringe. ");
INSERT INTO kik_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ũkaamarehe thĩinĩ na ũmahaande kĩrĩma-inĩ kĩa igai rĩaku, o handũ harĩa, Wee Jehova, wombire hatuĩke gĩikaro gĩaku, handũ-harĩa-haamũre, harĩa Wee Jehova, wahaandire na moko maku. ");
INSERT INTO kik_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Jehova agaathamaka tene na tene.” ");
INSERT INTO kik_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Hĩndĩ ĩrĩa mbarathi cia Firaũni, na ngaari cia ita, na andũ arĩa maathiiaga mahaicĩte mbarathi maatoonyire iria-inĩ-rĩ, Jehova agĩcookania maaĩ ma iria, makĩmathika. No rĩrĩ, andũ a Isiraeli maatuĩkanirie iria-inĩ mathiĩrĩire thĩ nyũmũ. ");
INSERT INTO kik_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Hĩndĩ ĩyo Miriamu ũrĩa mũnabii mũndũ-wa-nja, mwarĩ wa nyina na Harũni, akĩoya kĩhembe gĩa kũinio, nao atumia othe makĩmuuma thuutha marĩ na ihembe ciao makĩinaga. ");
INSERT INTO kik_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriamu akĩmainĩra atĩrĩ: “Inĩrai Jehova, nĩgũkorwo nĩwe ũtũũgĩrĩtio mũno. Mbarathi amĩikĩtie iria-inĩ, hamwe na mũmĩhaici.” ");
INSERT INTO kik_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ningĩ Musa agĩtongoria Isiraeli kuuma Iria Itune magĩthiĩ Werũ wa Shuri. Magĩthiĩ rũgendo rwa mĩthenya ĩtatũ werũ-inĩ na matekuona maaĩ. ");
INSERT INTO kik_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Rĩrĩa maakinyire Mara, matingĩahotire kũnyua maaĩ makuo tondũ maarĩ marũrũ. (Nĩkĩo handũ hau hetagwo Mara.) ");
INSERT INTO kik_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Nĩ ũndũ ũcio andũ magĩtetia Musa, makiuga atĩrĩ, “Tũkũnyua kĩ?” ");
INSERT INTO kik_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Nake Musa agĩkaĩra Jehova, nake Jehova akĩmuonia kamũtĩ. Agĩgaikia maaĩ-inĩ, namo makĩgĩa mũcamo mwega. O hau Jehova agĩathana, akĩmathondekera watho na uuge wa kũrũmagĩrĩrwo, na akĩmagereria ho. ");
INSERT INTO kik_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Akiuga atĩrĩ, “Mũngĩthikĩrĩria mũgambo wa Jehova Ngai wanyu wega, na mwĩke maũndũ marĩa magĩrĩire maitho-inĩ make, mũngĩrũmbũiya maathani make na mũmenyerere wathani wake wothe-rĩ, ndikamũrehera mũrimũ o na ũmwe wa ĩrĩa ndareheire andũ a Misiri, nĩgũkorwo niĩ nĩ niĩ Jehova, ũrĩa ũmũhonagia.” ");
INSERT INTO kik_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ningĩ magĩkinya Elimu, harĩa haarĩ ithima ikũmi na igĩrĩ, na mĩtende mĩrongo mũgwanja, nao makĩamba hema hau hakuhĩ na maaĩ. ");
INSERT INTO kik_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Mũingĩ wothe wa Isiraeli nĩwoimagararire ũkiuma Elimu ũgĩkinya Werũ wa Sini, ũrĩa ũrĩ gatagatĩ ka Elimu na kĩrĩma gĩa Sinai, mũthenya wa ikũmi na ĩtano wa mweri wa keerĩ thuutha wao kuuma bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kũu werũ-inĩ, mũingĩ ũcio wothe nĩwatetirie Musa na Harũni. ");
INSERT INTO kik_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Andũ a Isiraeli makĩmeera atĩrĩ, “Naarĩ korwo Jehova aatũũragĩire bũrũri wa Misiri na guoko gwake! Kũu twaikaraga tũthiũrũrũkĩirie nyũngũ cia nyama, na tũkarĩĩaga o kĩrĩa gĩothe twendaga, no inyuĩ mũtũrehete gũkũ werũ-inĩ nĩguo mũũrage kĩũngano gĩkĩ gĩothe na ngʼaragu.” ");
INSERT INTO kik_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Hĩndĩ ĩyo Jehova akĩĩra Musa atĩrĩ, “Ngũmuurĩria mĩgate kuuma igũrũ ta mbura. Andũ mariumaga nja o mũthenya makongania mĩgate ya kũmaigana o mũthenya ũcio. Ngũmageria na njĩra ĩyo nyone kana nĩmekũrũmĩrĩra ũrutani wakwa. ");
INSERT INTO kik_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mũthenya wa gatandatũ-rĩ, marĩharagĩria kĩrĩa mainũkia, nakĩo gĩkoragwo kĩrĩ maita meerĩ ma kĩrĩa monganagia mĩthenya ĩrĩa ĩngĩ.” ");
INSERT INTO kik_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Nĩ ũndũ ũcio Musa na Harũni makĩĩra andũ othe a Isiraeli atĩrĩ, “Hwaĩ-inĩ-rĩ, nĩmũrĩmenya atĩ nĩ Jehova wamũrutire bũrũri wa Misiri, ");
INSERT INTO kik_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","na rũciinĩ nĩmũkona riiri wa Jehova, tondũ nĩaiguĩte ũrĩa mũmũtetetie. Ithuĩ tũkĩrĩ a, atĩ nĩguo mũtũtetie?” ");
INSERT INTO kik_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","O na ningĩ Musa akĩmeera atĩrĩ, “Nĩmũkamenya atĩ ũcio nĩ Jehova, rĩrĩa akaamũhe nyama mũrĩe hwaĩ-inĩ na amũhe mĩgate ĩrĩa yothe mũkwenda rũciinĩ, tondũ nĩaiguĩte ũrĩa mũmũtetetie. Ithuĩ tũkĩrĩ a? Ti ithuĩ mũratetia, no nĩ Jehova mũratetia.” ");
INSERT INTO kik_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ningĩ Musa akĩĩra Harũni atĩrĩ, “Ĩra mũingĩ wothe wa Isiraeli atĩrĩ, ‘Ũkai mbere ya Jehova, nĩgũkorwo nĩaiguĩte gũteta kwanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Hĩndĩ ĩrĩa Harũni aaragĩria mũingĩ wothe wa Isiraeli-rĩ, makĩrora na mwena wa werũ-inĩ, na kũu makĩona riiri wa Jehova ũrĩ itu-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Nĩnjiguĩte gũteta kwa andũ a Isiraeli. Meere atĩrĩ, ‘Hwaĩ-inĩ mũrĩrĩĩaga nyama na rũciinĩ mũkarĩa mĩgate mũkahũũna. Hĩndĩ ĩyo nĩmũkamenya atĩ niĩ, nĩ niĩ Jehova Ngai wanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Hwaĩ-inĩ ũcio gũgĩũka tũnyoni tũrĩa twĩtagwo tũmakia-arũme tũkĩiyũra kambĩ ciao. Naguo rũciinĩ kwarĩ ime rĩathiũrũrũkĩirie kambĩ ciao. ");
INSERT INTO kik_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ime rĩaitĩka-rĩ, gũkĩoneka tũthendũ twa gĩthiũrũrĩ tũhaana maaĩ magandie nĩ mbaa, tũgwĩte thĩ kũu werũ-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Rĩrĩa andũ a Isiraeli maatuonire, makĩũrania atĩrĩ, “Gĩkĩ nĩ kĩĩ?” nĩgũkorwo matiamenyaga nĩ kĩĩ. Musa akĩmeera atĩrĩ, “Nĩ mĩgate ĩrĩa Jehova amũheete mũrĩe. ");
INSERT INTO kik_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Jehova aathanĩte ũũ: ‘O mũndũ nĩonganie o ĩrĩa ĩkũmũigana. Oyagai o kĩbaba kĩmwe kĩa omeri kĩa o mũndũ wothe ũrĩ hema-inĩ cianyu.’ ” ");
INSERT INTO kik_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Andũ a Isiraeli magĩĩka o ta ũrĩa meerirwo; amwe makĩũngania mĩingĩ, na amwe makĩũngania mĩnini. ");
INSERT INTO kik_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Na rĩrĩa yathimirwo na kĩbaba kĩa omeri, gũkĩoneka atĩ ũrĩa wonganĩtie mĩingĩ-rĩ, ndaarĩ na mĩingĩ makĩria; nake ũrĩa wonganirie mĩnini, ndaarĩ na mĩnini makĩria. O mũndũ oonganĩtie mũigana wa ũrĩa aabataire. ");
INSERT INTO kik_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ningĩ Musa akĩmeera atĩrĩ, “Gũtikagĩe mũndũ ũkũiga kĩndũ o na kĩnini kĩayo nginya rũciinĩ.” ");
INSERT INTO kik_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","No rĩrĩ, amwe matiigana kũrũmbũiya ũrĩa Musa oigire; makĩĩigĩra ĩmwe yayo nginya rũciinĩ, nayo ĩgĩkorwo ĩiyũrĩte igunyũ na ĩkambĩrĩria kũnunga. Nĩ ũndũ ũcio Musa akĩrakario nĩo. ");
INSERT INTO kik_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","O rũciinĩ mũndũ o mũndũ nĩoyaga ĩrĩa abatairio nĩyo, narĩo riũa rĩahiũha ĩgatweka. ");
INSERT INTO kik_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Mũthenya wa gatandatũ-rĩ, nĩmoonganagia maita meerĩ; ibaba igĩrĩ cia omeri harĩ o mũndũ. Nao atongoria a mũingĩ magĩũka makĩĩra Musa ũhoro ũcio. ");
INSERT INTO kik_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Nake Musa akĩmeera atĩrĩ, “Ũũ nĩguo Jehova aathanĩte, ‘Rũciũ nĩ mũthenya wa kũhurũka, Thabatũ Theru ya Jehova. Nĩ ũndũ ũcio rugai ĩrĩa yothe mũkwenda kũruga, na mũcamũkie kĩrĩa gĩothe mũkwenda gũcamũkia. Kĩrĩa gĩgũtigara-rĩ, mũkĩige nginya rũciinĩ.’ ” ");
INSERT INTO kik_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Nĩ ũndũ ũcio makĩiga imwe nginya rũciinĩ, o ta ũrĩa maathĩtwo nĩ Musa, nacio itiigana kũnunga, kana kũgĩa na igunyũ. ");
INSERT INTO kik_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa akĩmeera atĩrĩ, “Cirĩei ũmũthĩ, tondũ ũmũthĩ nĩ mũthenya wa Thabatũ ya Jehova. Ũmũthĩ mũtigũciona igwĩte thĩ. ");
INSERT INTO kik_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mĩthenya ĩtandatũ nĩguo mũrĩciũnganagia, no mũthenya wa mũgwanja-rĩ, ũcio wa Thabatũ, gũtirĩkoragwo kũrĩ kĩndũ o na kĩ.” ");
INSERT INTO kik_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","No rĩrĩ, andũ amwe makiumagara mũthenya ũcio wa mũgwanja, magĩthiĩ gũciũngania, nao matiigana kuona kĩndũ. ");
INSERT INTO kik_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Nĩ nginya hĩndĩ ĩrĩkũ mũgũtũũra mũregete kũmenyerera maathani makwa na kũigua ũrutani wakwa? ");
INSERT INTO kik_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Menyai atĩ Jehova nĩamũheete Thabatũ; na nĩkĩo amũheaga mĩgate ya mĩthenya ĩĩrĩ mũthenya ũcio wa gatandatũ. Mũndũ o wothe nĩaikarage harĩa arĩ mũthenya ũcio wa mũgwanja; gũtikanagĩe mũndũ ũkumagara.” ");
INSERT INTO kik_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nĩ ũndũ ũcio andũ makĩhurũka mũthenya wa mũgwanja. ");
INSERT INTO kik_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Andũ a Isiraeli magĩĩta mĩgate ĩyo mana. Maarĩ merũ ta mbegũ cia korianda, na maacamaga ta tũmĩgate tũthondeketwo na ũũkĩ. ");
INSERT INTO kik_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa akiuga atĩrĩ, “Jehova aathanĩte atĩrĩ; ‘Oyai kĩbaba kĩa omeri ĩmwe ya mana na mũkĩige nĩ ũndũ wa njiarwa iria igooka thuutha, nĩgeetha makoona mĩgate ĩrĩa ndaamũheire mũrĩe mũrĩ werũ-inĩ, rĩrĩa ndamũrutire bũrũri wa Misiri.’ ” ");
INSERT INTO kik_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Nĩ ũndũ ũcio Musa akĩĩra Harũni atĩrĩ, “Oya ndigithũ na wĩkĩre omeri ĩmwe ya mana thĩinĩ wayo. Ningĩ ũcooke ũmĩige mbere ya Jehova ĩigĩrwo njiarwa iria igooka thuutha.” ");
INSERT INTO kik_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","O ta ũrĩa Jehova aathire Musa-rĩ, Harũni akĩiga mana mbere ya ithandũkũ rĩa Ũira, nĩguo matũũre ho. ");
INSERT INTO kik_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Andũ a Isiraeli maarĩire mana mĩaka mĩrongo ĩna nginya magĩkinya bũrũri ũrĩa watũũragwo nĩ andũ; maarĩire mana nginya rĩrĩa maakinyire mũhaka-inĩ wa Kaanani. ");
INSERT INTO kik_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Omeri ĩmwe ĩigana ta gĩcunjĩ gĩa ikũmi kĩa eba ĩmwe.) ");
INSERT INTO kik_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Mũingĩ wothe wa Isiraeli ũkiumagara kuuma Werũ wa Sini, ũkoimaga handũ hamwe ũgathiĩ harĩa hangĩ o ta ũrĩa Jehova aathanaga. Makĩamba hema ciao Refidimu, no gũtiarĩ maaĩ ma kũnyuuo nĩ andũ acio. ");
INSERT INTO kik_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Nĩ ũndũ ũcio andũ acio makĩnegenia Musa, makĩmwĩra atĩrĩ, “Tũhe maaĩ ma kũnyua.” Nake Musa akĩmacookeria atĩrĩ, “Mũranegenia nĩkĩ? Nĩ kĩĩ gĩgũtũma mũgerie Jehova?” ");
INSERT INTO kik_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","No andũ nĩmanyootire marĩ kũu, nao magĩtetia Musa makĩmũũria atĩrĩ, “Watũrutire bũrũri wa Misiri nĩkĩ, tũũke ũtũũrage na nyoota ithuĩ na ciana ciitũ na ũhiũ witũ?” ");
INSERT INTO kik_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Nake Musa agĩkaĩra Jehova akĩmũũria atĩrĩ, “Ngwĩka atĩa na andũ aya? Marĩ hakuhĩ kũhũũra na mahiga nyuguto.” ");
INSERT INTO kik_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Jehova agĩcookeria Musa, akĩmwĩra atĩrĩ, “Thiĩ mbere ya andũ aya. Thiĩi na athuuri amwe a Isiraeli na ũkuue rũthanju rũrĩa wagũthire Nili naruo. ");
INSERT INTO kik_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Niĩ ngũrũgama hau mbere yaku, o hau hakuhĩ na rwaro rwa ihiga kũu Horebu. Gũtha ihiga, na maaĩ nĩmekuuma thĩinĩ warĩo nĩguo andũ manyue.” Nĩ ũndũ ũcio Musa agĩĩka ũguo athuuri a Isiraeli makĩonaga. ");
INSERT INTO kik_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Nake agĩĩta handũ hau Masa na Meriba, tondũ nĩho andũ a Isiraeli maanegenirie na makĩgeria Jehova, makĩũragia atĩrĩ, “Ĩĩ Jehova arĩ hamwe na ithuĩ kana aca?” ");
INSERT INTO kik_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Andũ a Amaleki nĩmookire makĩhithũkĩra andũ a Isiraeli kũu Refidimu. ");
INSERT INTO kik_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Musa akĩĩra Joshua atĩrĩ, “Thuura andũ amwe aitũ mumagare mũkahũũrane na andũ a Amaleki. Rũciũ ngaarũgama kĩrĩma igũrũ nyiitĩte rũthanju rwa Ngai na guoko.” ");
INSERT INTO kik_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Nĩ ũndũ ũcio Joshua akĩhũũrana na andũ a Amaleki o ta ũrĩa Musa aathanĩte; nake Musa, na Harũni na Huri makĩhaica kĩrĩma-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Rĩrĩa rĩothe Musa akoragwo oete moko make na igũrũ-rĩ, andũ a Isiraeli makahootana, no rĩrĩa agũithia moko make, andũ a Amaleki makahootana. ");
INSERT INTO kik_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Rĩrĩa Musa aanogire moko-rĩ, makĩoya ihiga makĩiga thĩ akĩrĩikarĩra. Harũni na Huri magĩkĩnyiitĩrĩra moko make, o ũmwe akanyiitĩrĩra guoko kũmwe, na ũcio ũngĩ kũu kũngĩ. Nĩ ũndũ ũcio moko ma Musa magĩikara mambarairio nginya riũa rĩgĩthũa. ");
INSERT INTO kik_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Nĩ ũndũ ũcio Joshua akĩhoota mbũtũ cia andũ a Amaleki na rũhiũ rwa njora. ");
INSERT INTO kik_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Andĩka ũndũ ũyũ ibuku-inĩ rĩa gĩkũnjo ũrĩ ũndũ wa gũtũũra ũririkanagwo na ũreke Joshua aũigue, tondũ nĩngeheria rĩĩtwa rĩa Amaleki biũ nao matigacooka kũririkanwo gũkũ thĩ.” ");
INSERT INTO kik_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Musa agĩaka kĩgongona na agĩgĩĩta atĩrĩ “Jehova Nĩwe Bendera yakwa.” ");
INSERT INTO kik_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Akiuga atĩrĩ, “Nĩgũkorwo moko nĩmambararirio na igũrũ kwerekera gĩtĩ-inĩ kĩa ũnene kĩa Jehova. Jehova arĩhũũranaga na andũ a Amaleki kuuma njiarwa na njiarwa.” ");
INSERT INTO kik_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Na rĩrĩ, Jethero, ũrĩa warĩ mũthĩnjĩri ngai wa Midiani na mũthoni-we wa Musa, akĩigua maũndũ mothe marĩa Ngai eekĩire Musa na andũ ake a Isiraeli, na ũrĩa Jehova aarutire andũ a Isiraeli kuuma bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Thuutha wa Musa gũcookia mũtumia wake Zipora, mũthoni-we Jethero nĩamwamũkĩrire, ");
INSERT INTO kik_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","hamwe na ariũ ake eerĩ. Mũriũ ũmwe eetagwo Gerishomu, nĩgũkorwo Musa oigire atĩrĩ, “Nĩnduĩkĩte mũgeni bũrũri-inĩ wene”; ");
INSERT INTO kik_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","mũriũ ũcio ũngĩ eetagwo Eliezeri, nĩgũkorwo oigire atĩrĩ, “Ngai wa baba nĩwe warĩ mũteithia wakwa; nĩahonokirie kuuma rũhiũ-inĩ rwa Firaũni.” ");
INSERT INTO kik_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jethero, mũthoni-we wa Musa, hamwe na mũtumia wa Musa na ariũ ake, magĩũka kũrĩ we kũu werũ-inĩ, kũrĩa aambĩte hema hakuhĩ na kĩrĩma kĩa Ngai. ");
INSERT INTO kik_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jethero nĩamũtũmanĩire akoiga atĩrĩ, “Niĩ, mũthoni-guo Jethero, nĩndĩrooka kũrĩ we tũrĩ na mũtumia waku na ariũ aku eerĩ.” ");
INSERT INTO kik_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Nĩ ũndũ ũcio Musa agĩkiumagara agatũnge mũthoni-we, akĩinamĩrĩra, akĩmũmumunya. Makĩgeithania, na magĩcooka magĩtoonya hema thĩinĩ. ");
INSERT INTO kik_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa akĩhe mũthoni-we ũhoro wothe wa ũrĩa Jehova eekire Firaũni na andũ a Misiri nĩ ũndũ wa andũ a Isiraeli na, akĩmwĩra mathĩĩna mothe marĩa moonete rũgendo-inĩ, na ũrĩa Jehova aamahonoketie. ");
INSERT INTO kik_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jethero nĩakenirio nĩ kũigua maũndũ macio mothe mega marĩa Jehova eekĩire Isiraeli, nĩ ũndũ wa kũhonokia andũ a Isiraeli kuuma guoko-inĩ kwa andũ a Misiri. ");
INSERT INTO kik_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethero akiuga atĩrĩ, “Jehova arogoocwo, ũrĩa wamũteithũrire kuuma guoko-inĩ kwa andũ a Misiri na gwa Firaũni, na agĩteithũra andũ kuuma guoko-inĩ kwa andũ a Misiri. ");
INSERT INTO kik_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Rĩu niĩ nĩmenyete atĩ Jehova nĩ mũnene gũkĩra ngai iria ingĩ ciothe, nĩgũkorwo ũguo nĩguo eekire arĩa maahatĩrĩirie Isiraeli metĩĩte.” ");
INSERT INTO kik_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Hĩndĩ ĩyo Jethero, mũthoni-we wa Musa, akĩrehe maruta ma njino na magongona mangĩ ma kũrutĩra Ngai, nake Harũni agĩũka marĩ na athuuri othe a Isiraeli nĩguo marĩĩanĩre irio na mũthoni-we wa Musa, marĩ mbere ya Ngai. ");
INSERT INTO kik_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Mũthenya ũyũ ũngĩ Musa agĩikarĩra gĩtĩ nĩguo atuithanie andũ ciira, nao andũ makĩrũgama mamũthiũrũrũkĩirie kuuma rũciinĩ nginya o hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Rĩrĩa mũthoni-we onire wĩra ũrĩa wothe Musa aarutagĩra andũ, akĩmũũria atĩrĩ, “Nĩ wĩra ũrĩkũ ũyũ ũrarutĩra andũ aya? Nĩ kĩĩ gĩgũtũma ũrute wĩra wa gũtuithania ciira ũrĩ o wiki, nao andũ aya othe matindage marũngiĩ magũthiũrũrũkĩirie kuuma rũciinĩ nginya o hwaĩ-inĩ?” ");
INSERT INTO kik_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa akĩmũcookeria, akĩmwĩra atĩrĩ, “Tondũ andũ aya marokaga kũrĩ niĩ nĩguo mamenye wendi wa Ngai. ");
INSERT INTO kik_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Rĩrĩa rĩothe marĩ na ũndũ matekũiguanĩra, ũrehagwo kũrĩ niĩ, na niĩ ngamatuithania na ngamamenyithia uuge wa Ngai na mawatho make.” ");
INSERT INTO kik_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mũthoni-we wa Musa akĩmũcookeria, akĩmwĩra atĩrĩ, “Ũrĩa ũreka ti wega. ");
INSERT INTO kik_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Wee, na andũ aya marooka kũrĩ we nĩmũkwĩnogia na mĩnoga. Wĩra ũyũ nĩ mũritũ mũno makĩria harĩwe; ndũngĩũhota ũrĩ wiki. ");
INSERT INTO kik_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Rĩu-rĩ, ta thikĩrĩria ngũtaare, na Ngai aroikara nawe. Wee tuĩka mũtũmwo wa Ngai kũrĩ andũ aya, na ũkamũtwaragĩra maũndũ marĩa matekũiguanĩra. ");
INSERT INTO kik_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Marute uuge wa Ngai na mawatho make, na ũmoonie njĩra njega ya mũtũũrĩre na mawĩra marĩa magĩrĩire kũruta. ");
INSERT INTO kik_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","No rĩrĩ, thuura andũ marĩ na ũhoti kuuma andũ-inĩ aya, andũ etigĩri Ngai, na andũ ehokeku arĩa mathũire kwamũkĩra ihaki, na ũmatue anene a kũrũgamagĩrĩra ikundi cia ngiri, na ikundi cia magana, na ikundi cia mĩrongo ĩtano, na ikundi cia makũmi. ");
INSERT INTO kik_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Reke matuĩke a gũtuithania andũ aya ciira mahinda mothe, no makũrehagĩre maciira marĩa maritũ; marĩa mahũthũ makamatuithanagia arĩ o. Ũndũ ũcio nĩũgũkũhũthĩria mũrigo, tondũ nĩmarĩgayanaga nawe. ");
INSERT INTO kik_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ũngĩka ũguo na Ngai agwathe, nĩũrĩhotaga gwĩtiiria mĩnoga, na andũ aya othe marĩinũkaga maiganĩire.” ");
INSERT INTO kik_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa nĩathikĩrĩirie mũthoni-we na agĩĩka ũrĩa wothe aamũtaarire. ");
INSERT INTO kik_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Agĩthuura andũ marĩ na ũhoti kuuma Isiraeli guothe, akĩmatua atongoria a andũ acio; akĩmatua anene a ikundi cia ngiri, na ikundi cia magana, na ikundi cia mĩrongo ĩtano, na ikundi cia makũmi. ");
INSERT INTO kik_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Magĩtuĩka a gũtuithanagia andũ ciira hĩndĩ ciothe. Maciira marĩa maritũ magatwarĩra Musa, no marĩa mahũthũ magatuithanagia arĩ o. ");
INSERT INTO kik_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Musa agĩcooka akiugĩra mũthoni-we ũhoro, nake Jethero agĩcooka bũrũri wake mwene. ");
INSERT INTO kik_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Mweri wa gatatũ thuutha wa andũ a Isiraeli kuuma bũrũri wa Misiri, mũthenya o ũcio-rĩ, magĩkinya Werũ wa Sinai. ");
INSERT INTO kik_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Thuutha wa kuuma Refidimu, magĩtoonya werũ wa Sinai, nao andũ a Isiraeli makĩamba hema ciao kũu werũ-inĩ, magũrũ-inĩ ma kĩrĩma kĩu kĩa Sinai. ");
INSERT INTO kik_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ningĩ Musa akĩambata kĩrĩma-inĩ harĩ Ngai, nake Jehova akĩmwĩta arĩ kĩrĩma-inĩ, akĩmwĩra atĩrĩ, “Ũũ nĩguo ũkwĩra nyũmba ya Jakubu, na wĩre andũ a Isiraeli: ");
INSERT INTO kik_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Inyuĩ ene nĩmweyoneire ũrĩa Ndeekire bũrũri wa Misiri, o na ũrĩa ndahaanire ta ndamũkuuire na mathagu ma nderi, ngĩmũrehe harĩ niĩ. ");
INSERT INTO kik_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Na rĩrĩ, mũngĩnjathĩkĩra biũ na mũmenyerere kĩrĩkanĩro gĩakwa-rĩ, gatagatĩ-inĩ ka ndũrĩrĩ ciothe, inyuĩ mũgaatuĩka andũ akwa a goro. O na gũtuĩka thĩ yothe nĩ yakwa-rĩ, ");
INSERT INTO kik_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","inyuĩ mũgaatuĩka ũthamaki wakwa wa athĩnjĩri-Ngai na rũrĩrĩ rwamũre.’ Ciugo icio nĩcio ũkwĩra andũ a Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Nĩ ũndũ ũcio Musa agĩcooka, na agĩĩta athuuri arĩa matongoragia andũ, akĩmahe ũhoro wothe ũrĩa Jehova aamwathĩte ameere. ");
INSERT INTO kik_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Nao andũ acio magĩĩtĩkanĩria hamwe makiuga atĩrĩ, “Nĩtũgwĩka ũrĩa wothe Jehova oigĩte.” Nĩ ũndũ ũcio Musa agĩcookeria Jehova ũhoro ũrĩa moigire. ");
INSERT INTO kik_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Jehova akĩĩra Musa atĩrĩ, “Nĩngũũka kũrĩ inyuĩ ndĩ thĩinĩ wa itu itumanu, nĩgeetha andũ maanjigue ngĩaria nawe, nao nĩ megũtũũra makwĩhokete.” Musa agĩcooka akĩĩra Jehova ũrĩa andũ moigĩte. ");
INSERT INTO kik_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Nake Jehova akĩĩra Musa atĩrĩ, “Thiĩ kũrĩ andũ ũmatherie ũmũthĩ na rũciũ. Meere mathambie nguo ciao, ");
INSERT INTO kik_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","na makorwo mehaarĩirie mũthenya wa gatatũ, tondũ mũthenya ũcio Jehova nĩagaikũrũka igũrũ rĩa Kĩrĩma gĩa Sinai andũ othe makĩonaga. ");
INSERT INTO kik_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ĩkĩra mĩhaka ĩthiũrũrũkĩrie kĩrĩma, na ũmeere ũũ, ‘Mwĩmenyererei mũtikahaice kĩrĩma kana mũhutie magũrũ-inĩ ma kĩo. Ũrĩa wothe ũkaahutia kĩrĩma ti-itherũ nĩakooragwo. ");
INSERT INTO kik_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ti-itherũ nĩakahũũrwo na mahiga nyuguto, kana arathwo na mĩguĩ; hatirĩ guoko gũkaamũhutia. Ndagetĩkĩrio atũũre muoyo, arĩ mũndũ kana nyamũ.’ No rĩrĩa coro wa rũhĩa rwa ndũrũme ũrĩgamba, no rĩo marĩhaica kĩrĩma igũrũ.” ");
INSERT INTO kik_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Thuutha wa Musa gũikũrũka oimĩte kĩrĩma-inĩ agĩthiĩ kũrĩ andũ, akĩmatheria, nao magĩthambia nguo ciao. ");
INSERT INTO kik_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ningĩ akĩmeera atĩrĩ, “Mwĩhaarĩriei nĩ ũndũ wa mũthenya wa gatatũ. Mũtigakome na andũ-a-nja.” ");
INSERT INTO kik_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Rũciinĩ rwa mũthenya wa gatatũ, gũkĩgĩa ngwa o na heni, na itu itumanu rĩgĩikara igũrũ rĩa kĩrĩma, gũkĩiguuo mũgambo mũnene wa coro. Andũ othe arĩa maarĩ kambĩ, makĩinaina. ");
INSERT INTO kik_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Hĩndĩ ĩyo Musa agĩtongoria andũ kuuma kambĩ magacemanie na Ngai, nao makĩrũgama magũrũ-inĩ ma kĩrĩma. ");
INSERT INTO kik_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Kĩrĩma gĩa Sinai kĩahumbĩrĩtwo nĩ ndogo, tondũ Jehova aikũrũkire igũrũ wakĩo arĩ mwaki-inĩ. Nayo ndogo ĩgĩtoogororoka kuuma igũrũ rĩa kĩrĩma ta ndogo ĩkuuma riiko-inĩ inene; nakĩo kĩrĩma gĩgĩthingitha na hinya, ");
INSERT INTO kik_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","naguo mũgambo wa coro ũgĩkĩrĩrĩria kũneneha. Nake Musa akĩaria, naguo mũgambo wa Ngai ũkĩmũcookeria. ");
INSERT INTO kik_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Jehova agĩikũrũka igũrũ rĩa Kĩrĩma gĩa Sinai na agĩĩta Musa ahaice kũu kĩrĩma igũrũ. Nĩ ũndũ ũcio Musa akĩhaica, ");
INSERT INTO kik_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","nake Jehova akĩmwĩra atĩrĩ, “Ikũrũka na ũkaanie andũ matikehatĩrĩrie kwambata gũũka kuona Jehova, nĩguo aingĩ ao matigakue. ");
INSERT INTO kik_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","O na athĩnjĩri-Ngai arĩa me gũthengerera Jehova, no nginya metherie kana Jehova amahithũkĩre, amaniine.” ");
INSERT INTO kik_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa akĩĩra Jehova atĩrĩ, “Andũ matingĩhaica Kĩrĩma gĩa Sinai tondũ we mwene nĩwatũkaanirie, ũgĩtwĩra atĩrĩ, ‘Ĩkĩra mũhaka ũthiũrũrũkĩrie kĩrĩma, na ũkĩamũre gĩtuĩke gĩtheru.’ ” ");
INSERT INTO kik_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Jehova akĩmũcookeria atĩrĩ, “Ikũrũka, mwambate na Harũni. No athĩnjĩri-Ngai na andũ matikehatĩrĩrie kwambata mathiĩ kũrĩ Jehova kana amahithũkĩre amaniine.” ");
INSERT INTO kik_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Nĩ ũndũ ũcio Musa agĩikũrũka kũrĩ andũ acio, akĩmahe ũhoro ũcio. ");
INSERT INTO kik_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Nake Ngai akĩaria ciugo ici ciothe, akiuga atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nĩ niĩ Jehova Ngai waku, ũrĩa wakũrutire bũrũri wa Misiri, kuuma bũrũri wa ũkombo. ");
INSERT INTO kik_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ndũkanagĩe na ngai ingĩ tiga niĩ. ");
INSERT INTO kik_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Ndũkanethondekere mũhianano mũicũhie wa mũhianĩre wa kĩndũ o gĩothe kĩrĩ kũũrĩa igũrũ kana gũkũ thĩ, kana kĩrĩ maaĩ-inĩ marĩa marĩ mũhuro wa thĩ. ");
INSERT INTO kik_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ndũkanacinamĩrĩre kana ũcihooe, nĩgũkorwo niĩ, Jehova Ngai waku, ndĩ Ngai ũrĩ ũiru, herithagia ciana nĩ ũndũ wa mehia ma maithe mao nginya rũciaro rwa gatatũ na rwa kana rwa andũ arĩa maathũire, ");
INSERT INTO kik_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","no ngonania wendo kũrĩ njiarwa ngiri na ngiri cia andũ arĩa manyendete na magaathĩkĩra maathani makwa. ");
INSERT INTO kik_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Ndũkanagwete rĩĩtwa rĩa Jehova Ngai waku na itherũ, nĩgũkorwo Jehova ndagatua atĩ mũndũ ndehĩtie ũrĩa ũgwetaga rĩĩtwa rĩake na itherũ. ");
INSERT INTO kik_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Ririkanaga mũthenya wa Thabatũ ũwamũrage. ");
INSERT INTO kik_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Rutaga wĩra waku wothe mĩthenya ĩtandatũ, ");
INSERT INTO kik_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","no mũthenya wa mũgwanja nĩ Thabatũ ya Jehova Ngai waku. Mũthenya ũcio ndũkanarute wĩra o na ũrĩkũ, wee mwene, kana mũrũ-guo, kana mwarĩ-guo, kana ndungata yaku ya mũndũ mũrũme, kana ya mũndũ-wa-nja, kana ũhiũ waku, kana mũgeni ũrĩ gwaku mũciĩ. ");
INSERT INTO kik_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Nĩgũkorwo Jehova ombire igũrũ na thĩ, na iria rĩrĩa inene na indo ciothe iria irĩ kuo, na mĩthenya ĩtandatũ, no akĩhurũka mũthenya wa mũgwanja. Nĩ ũndũ ũcio Jehova akĩrathima mũthenya ũcio wa Thabatũ, akĩwaamũra. ");
INSERT INTO kik_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Tĩĩa thoguo na nyũkwa, nĩgeetha ũtũũre matukũ maingĩ bũrũri ũrĩa Jehova Ngai waku egũkũhe. ");
INSERT INTO kik_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Ndũkanoragane. ");
INSERT INTO kik_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Ndũkanatharanie. ");
INSERT INTO kik_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Ndũkanaiye. ");
INSERT INTO kik_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Ndũkanaigĩrĩre mũndũ ũrĩa ũngĩ kĩgeenyo. ");
INSERT INTO kik_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Ndũkanacumĩkĩre nyũmba ya mũndũ ũrĩa ũngĩ. Ndũkanacumĩkĩre mũtumia wa mũndũ ũngĩ, kana ũcumĩkĩre ndungata yake ya mũndũ mũrũme kana ya mũndũ-wa-nja, kana ndegwa yake kana ndigiri yake, o na kana kĩndũ gĩothe gĩake.” ");
INSERT INTO kik_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Rĩrĩa andũ maiguire marurumĩ, na makĩona rũheni, na makĩigua coro ũkĩgamba, na makĩona kĩrĩma gĩgĩtoga ndogo, makĩinaina nĩ guoya. Magĩikara o haraaya, ");
INSERT INTO kik_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","na makĩĩra Musa atĩrĩ, “Twarĩrie arĩ we, na nĩtũgũkũigua, no tiga kũreka twarĩrio nĩ Ngai, tũtigakue.” ");
INSERT INTO kik_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa akĩĩra andũ acio atĩrĩ, “Tigai gwĩtigĩra. Ngai okĩte kũmũgeria, nĩgeetha mũtũũre mwĩtigĩrĩte Ngai, mwagage kwĩhia.” ");
INSERT INTO kik_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Andũ acio magĩgĩikara o haraaya, nowe Musa agĩthengerera harĩa haarĩ nduma ndumanu, harĩa Ngai aarĩ. ");
INSERT INTO kik_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ĩra andũ a Isiraeli ũndũ ũyũ: ‘Nĩmweyonera inyuĩ ene atĩ ndaaria na inyuĩ ndĩ o igũrũ: ");
INSERT INTO kik_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Mũtikanathondeke ngai ingĩ cia kũhooyagwo hamwe na niĩ; mũtikanethondekere ngai cia betha kana ngai cia thahabu. ");
INSERT INTO kik_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Njakĩrai kĩgongona gĩa tĩĩri, na mũrutĩre ngʼondu na mbũri na ngʼombe cianyu ho irĩ magongona manyu ma njino na ma ũiguano. Kũrĩa guothe ngaatũma rĩĩtwa rĩakwa rĩtĩĩagwo, nĩndĩũkaga kũrĩ inyuĩ na ngamũrathima. ");
INSERT INTO kik_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Mũngĩnjakĩra kĩgongona kĩa mahiga, mũtigagĩake na mahiga marĩa maacũhie, nĩgũkorwo mũngĩgaatũmĩra kĩndũ gĩa gwacũhia nĩmũgagĩthaahia. ");
INSERT INTO kik_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Mũtikanahaice kĩgongona gĩakwa na ngathĩ, nĩguo njaga yanyu ndĩkanonekanĩre ho.’ ");
INSERT INTO kik_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Maya nĩmo mawatho marĩa ũkũhe andũ a Isiraeli: ");
INSERT INTO kik_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ũngĩgũra Mũhibirania arĩ ndungata, agaakũrutĩra wĩra mĩaka ĩtandatũ. No mwaka wa mũgwanja, nĩũkamũrekereria athiĩ, na ndagakũrĩha kĩndũ. ");
INSERT INTO kik_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Angĩgooka arĩ wiki, akaarekererio athiĩ arĩ o wiki; no angĩgooka arĩ na mũtumia, makaarekererio mathiĩ marĩ hamwe. ");
INSERT INTO kik_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Mwathi wa ndungata ĩyo angĩmĩhe mũtumia nake mũtumia ũcio amũciarĩre ciana cia aanake na airĩtu, mũtumia ũcio na ciana ciake magaatuĩka a mwathi ũcio wake, na no ndungata ĩyo ya mũndũ mũrũme ĩkaarekererio ĩthiĩ. ");
INSERT INTO kik_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“No ndungata ĩyo ĩngĩkaaria, ĩmwĩre atĩrĩ, ‘Nĩnyendete mwathi wakwa, na mũtumia wakwa na ciana na ndikwenda kũrekererio thiĩ,’ ");
INSERT INTO kik_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","hĩndĩ ĩyo mwathi wa ndungata ĩyo nĩakamĩtwara mbere ya atuithania ciira. Akaamĩtwara mũrango-inĩ, kana hingĩro-inĩ ya mũrango, na amĩtũre gũtũ na mũkuha. Nayo ndungata ĩyo ĩgaatuĩka ya mwathi ũcio matukũ ma muoyo wayo wothe. ");
INSERT INTO kik_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Mũndũ angĩendia mwarĩ agatuĩke ndungata, ndĩkarekererio ĩthiĩ ta ũrĩa ndungata cia arũme ciĩkagwo. ");
INSERT INTO kik_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ĩngĩaga gũkenia mwathi ũrĩa wamĩthuurĩte, no nginya etĩkĩre ndungata ĩyo ĩkũũrwo. Ndarĩ na kĩhooto gĩa kwendia ndungata ĩyo kũrĩ ageni, tondũ nĩagĩte kwĩhokeka harĩ yo. ");
INSERT INTO kik_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Angĩmĩũrĩria mũriũ, no nginya amĩtue ta ĩrĩ mwarĩ wake mwene. ");
INSERT INTO kik_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Mũriũ angĩhikia mũtumia ũngĩ, ndakaime ũrĩa wa mbere irio na nguo, na ndakamũime kĩhooto gĩake ta mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Angĩaga kũmũhingĩria maũndũ maya matatũ-rĩ, akĩrekererio athiĩ, gũtarĩ na mbeeca ikũrĩhwo. ");
INSERT INTO kik_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Mũndũ ũrĩa ũngĩgũtha mũndũ amũũrage, ti-itherũ o nake no akooragwo. ");
INSERT INTO kik_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","No rĩrĩ, angĩkorwo ekĩte ũguo atekwenda-rĩ, no gũtuĩke nĩ Ngai ũtũmĩte ũndũ ũcio wĩkĩke, nake mũndũ ũcio nĩakoorĩra kũndũ kũrĩa ngaathuura. ");
INSERT INTO kik_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","No mũndũ angĩtũmĩra mawara na oorage mũndũ ũrĩa ũngĩ akĩendaga-rĩ, mweheriei kĩgongona-inĩ gĩakwa, na mũmũũrage. ");
INSERT INTO kik_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Mũndũ ũrĩa ũngĩtharĩkĩra ithe kana nyina no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Mũndũ ũngĩiya mũndũ ũngĩ na hinya akamwendie, kana o na anyiitwo arĩ nake atanamwendia-rĩ, no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Mũndũ ũrĩa ũngĩruma ithe kana nyina no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Andũ mangĩũgitana na ũmwe aringe ũrĩa ũngĩ na ihiga kana na ngundi na aage gũkua, no akome ũrĩrĩ kwa ihinda-rĩ, ");
INSERT INTO kik_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ũcio mũringani ndagacookererwo nĩ mahĩtia angĩkorwo ũrĩa waringĩtwo nĩakehota na etware nja na mũtirima wake. No rĩrĩ, no nginya arĩhe mahinda ma mũndũ ũcio mũtihie marĩa morĩte na one atĩ nĩahona biũ. ");
INSERT INTO kik_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Mũndũ angĩhũũra ngombo yake ya mũndũ mũrũme kana ya mũndũ-wa-nja na rũthanju, nayo ngombo ĩyo ĩkue nĩ ihũũra rĩu-rĩ, no nginya aherithio, ");
INSERT INTO kik_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","no ndangĩherithio ngombo ĩyo ĩngĩarahũka thuutha wa mũthenya ũmwe kana ĩĩrĩ, tondũ ngombo ĩyo nĩ kĩndũ gĩake. ");
INSERT INTO kik_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Andũ mangĩkorwo makĩrũa, maringe mũtumia ũrĩ nda, ahune no ndagĩe na thĩĩna ũngĩ-rĩ, ũrĩa ũmũringĩte nĩakarĩha kĩrĩa gĩothe mũthuuri wa mũtumia ũcio ageetia, igooti rĩetĩkĩria. ");
INSERT INTO kik_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","No mũtumia ũcio angĩtihio ũũru, muoyo nĩũrĩhagio na muoyo, na ");
INSERT INTO kik_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","riitho rĩrĩhagio na riitho, na igego rĩrĩhagio na igego, na guoko kũrĩhagio na guoko, na kũgũrũ kũrĩhagio na kũgũrũ, na ");
INSERT INTO kik_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ihĩa rĩrĩhagio na ihĩa, na itihia rĩrĩhagio na itihia, naruo rũhara rũrĩhagio na rũhara. ");
INSERT INTO kik_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Mũndũ angĩgũtha ndungata ya mũndũ mũrũme kana ya mũndũ-wa-nja riitho narĩo rĩthũke-rĩ, no nginya akaarekereria ndungata ĩyo ĩĩthiĩre, ũndũ ũcio ũtuĩke nĩguo irĩhi rĩa riitho. ");
INSERT INTO kik_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Na angĩkũũra igego rĩa ndungata ya mũndũ mũrũme kana ya mũndũ-wa-nja, no nginya arekererie ndungata ĩyo ĩĩthiĩre, ũndũ ũcio ũtuĩke nĩguo irĩhi rĩa igego. ");
INSERT INTO kik_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ndegwa ĩngĩtheeca mũndũ mũrũme kana mũndũ-wa-nja na rũhĩa akue, ndegwa ĩyo no nginya ĩhũũrwo na mahiga nginya ĩkue, na nyama ciayo itikarĩĩo. No mwene ndegwa ndangĩũrio. ");
INSERT INTO kik_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","No rĩrĩ, angĩkorwo ndegwa ĩyo nĩĩmenyerete gũtheeca andũ na rũhĩa, na mwene nĩamenyithĩtio ũhoro ũcio nake akaaga kũmĩhingĩra, nayo ĩcooke yũrage mũndũ mũrũme kana mũndũ-wa-nja-rĩ, ndegwa ĩyo no nginya ĩhũũrwo na mahiga ĩkue, na mwene o nake no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Na rĩrĩ, angĩtuĩka nĩ gwĩtio irĩhi-rĩ, no akũũre muoyo wake na kũrĩha kĩrĩa gĩothe angĩĩtio. ");
INSERT INTO kik_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Watho ũyũ noguo ũrũgamĩrĩire ndegwa ĩngĩtheeca mwanake kana mũirĩtu wa mũndũ na rũhĩa. ");
INSERT INTO kik_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ndegwa ĩngĩtheeca ngombo ya mũndũ mũrũme kana mũndũ-wa-nja, mwene no nginya arĩhe cekeri mĩrongo ĩtatũ cia betha kũrĩ mwathi wa ngombo ĩyo, nayo ndegwa ĩyo no nginya ĩhũũrwo na mahiga. ");
INSERT INTO kik_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Mũndũ angĩkunũra irima, kana enje rĩmwe na aage kũrĩkunĩka, nayo ndegwa kana ndigiri ĩgwe thĩinĩ warĩo, ");
INSERT INTO kik_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mwene irima rĩu no nginya arĩhe hathara ĩyo; no nginya arĩhe mwene nyamũ, nayo nyamũ ĩyo ĩkuĩte ĩtuĩke yake. ");
INSERT INTO kik_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ndegwa ya mũndũ ĩngĩtihia ndegwa ya mũndũ ũngĩ ĩkue, andũ acio nĩmakendia ndegwa ĩrĩa ĩrĩ muoyo, magayane mbeeca na magayane nyamũ ĩyo ĩkuĩte. ");
INSERT INTO kik_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","No rĩrĩ, kũngĩkorwo nĩkũmenyekete atĩ ndegwa ĩyo nĩĩmenyerete gũtheecana na rũhĩa, nake mwene akaaga kũmĩhingĩra-rĩ, no nginya mwene arĩhe, nyamũ ĩrĩhio na nyamũ ĩngĩ, na ĩrĩa ĩkuĩte ĩtuĩke yake. ");
INSERT INTO kik_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Mũndũ angĩiya ndegwa kana ngʼondu, na amĩthĩnje kana amĩendie-rĩ, no nginya arĩhe ndegwa ithano nĩ ũndũ wa ndegwa ĩyo na ngʼondu inya nĩ ũndũ wa ngʼondu ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Mũici angĩnyiitwo agĩtua nyũmba nake agũthwo akue-rĩ, mũmũgũthi ndarĩ na ihĩtia rĩa gũita thakame; ");
INSERT INTO kik_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","no ũndũ ũcio ũngĩkĩka thuutha wa riũa kũratha, mũndũ ũcio wagũthana arĩ na ihĩtia rĩa gũita thakame. “Mũici no nginya arĩhe kĩrĩa aiyĩte, no angĩkorwo ndarĩ na kĩndũ, no nginya endio nĩguo kĩrĩa aiyĩte kĩrĩhwo. ");
INSERT INTO kik_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Nyamũ ĩrĩa ĩiyĩtwo ĩngĩonekana ĩrĩ muoyo moko-inĩ make, ĩrĩ ndegwa kana ndigiri kana ngʼondu no nginya arĩhe maita meerĩ. ");
INSERT INTO kik_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Mũndũ angĩrĩithia ũhiũ wake mũgũnda wene o na kana arĩithie mũgũnda wene wa mĩthabibũ, aũrekererie ũrĩe mũgũnda wa mũndũ ũngĩ-rĩ, no nginya arĩhe na indo iria njega cia mũgũnda wake o na arĩhe na thabibũ iria njega mũno cia mũgũnda wake. ");
INSERT INTO kik_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Mwaki ũngĩtuthũka na ũcine ihinga cia mĩigua nginya ũkinyĩre itĩĩa cia ngano kana ngano ĩrũngiĩ, kana ũcine mũgũnda wothe, mwakia wa mwaki ũcio no nginya arĩhe ngano ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Mũndũ angĩhithia mũndũ wa itũũra rĩake betha kana indo amũigĩre-rĩ, nacio indo icio ciywo kuuma nyũmba yake, mũici ũcio angĩnyiitwo no nginya arĩhe indo icio maita meerĩ. ");
INSERT INTO kik_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","No mũici ũcio angĩaga kũnyiitwo, mwene nyũmba no nginya athiĩ mbere ya aciirithania nĩguo kũmenyeke kana nĩwe ũiyĩte indo icio cia mũndũ ũcio ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ha ũhoro o wothe wa mũndũ gũkorwo na kĩndũ na njĩra ĩrĩa ĩtagĩrĩire, kĩrĩ ndegwa, kana ndigiri, kana ngʼondu, kana nguo, kana kĩndũ kĩngĩ gĩothe kĩũrĩte kĩrĩa mũndũ ũngĩ angiuga atĩrĩ, ‘Kĩndũ gĩkĩ nĩ gĩakwa,’ andũ acio eerĩ no nginya marehe ũhoro wao mbere ya aciirithania. Mũndũ ũrĩa aciirithania magatua atĩ nĩehĩtie-rĩ, no nginya arĩhe mũndũ ũcio ũngĩ maita meerĩ. ");
INSERT INTO kik_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Mũndũ angĩhithia mũndũ wa itũũra rĩake ndigiri, kana ndegwa, kana ngʼondu kana nyamũ o yothe amũigĩre, nayo ĩkue, kana ĩtihio, kana ĩiywo, hatarĩ mũndũ ũroona-rĩ, ");
INSERT INTO kik_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ũhoro ũcio wao ũgaatuuo na njĩra ya kwĩhĩta mwĩhĩtwa mbere ya Jehova atĩ ũrĩa ũhithĩtio tiwe ũiyĩte indo icio. Mwene nake etĩkĩre mwĩhĩtwa ũcio, na hatikagĩa ũhoro wa kũrĩhania. ");
INSERT INTO kik_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","No angĩkorwo nyamũ nĩkũiywo yaiirwo kuuma kũrĩa yahithĩtio-rĩ, no nginya mũndũ ũcio arĩhe mwene. ");
INSERT INTO kik_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Angĩkorwo yatambuurirwo nĩ nyamũ cia gĩthaka, nĩakonania matigari matuĩke ũira, na ndakaarĩhio nyamũ ĩyo ĩtambuurĩtwo nĩ nyamũ. ");
INSERT INTO kik_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Mũndũ angĩgwatio nyamũ ya mũndũ ũngĩ, nayo ĩtihio kana ĩkue mwene atarĩ hakuhĩ, no nginya amĩrĩhe. ");
INSERT INTO kik_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","No nyamũ ĩyo ĩngĩkorwo ĩrĩ na mwene-rĩ, ũrĩa ũgwatĩtio ndangĩmĩrĩha. Angĩkorwo nyamũ nĩgũkomborithio yakomborithĩtio, mbeeca iria ĩkomboretwo nĩirĩhĩte hathara ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Mũndũ angiuha mũirĩtu gathirange ũtoorĩtio kũhikio, nake akome nake, no nginya arĩhe rũracio, nake mũirĩtu ũcio atuĩke mũtumia wake. ");
INSERT INTO kik_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ithe wa mũirĩtu angĩrega biũ kũmũheana kũrĩ mũndũ ũcio, no nginya mũndũ ũcio arĩhe rũracio rwa airĩtu gathirange. ");
INSERT INTO kik_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Mũtigetĩkĩrie mũndũ-wa-nja mũrogi atũũre muoyo. ");
INSERT INTO kik_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Mũndũ ũngĩgwata nyamũ no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Mũndũ ũkaarutĩra ngai ingĩ iruta tiga Jehova nĩakaniinwo. ");
INSERT INTO kik_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Mũtigeke mũgeni ũũru kana mũmũhinyĩrĩrie, nĩgũkorwo o na inyuĩ mwarĩ ageni bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Mũtikanahinyĩrĩrie mũtumia wa ndigwa kana mwana wa ngoriai. ");
INSERT INTO kik_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Mũngĩĩka ũguo nao mangaĩre, hatirĩ nganja nĩngaigua kĩrĩro kĩao. ");
INSERT INTO kik_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nĩngacinwo nĩ marakara, na nĩngamũũraga na rũhiũ rwa njora, nao atumia anyu matuĩke a ndigwa na ciana cianyu ituĩke cia ngoriai. ");
INSERT INTO kik_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ũngĩkombera mũndũ ũmwe wakwa gatagatĩ-inĩ kanyu mbeeca abatairio nĩcio-rĩ, ndũgatuĩke ta mũkombanĩri wa mbeeca; ndũkamũrĩhie uumithio wacio. ");
INSERT INTO kik_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Mũndũ ũngĩ angĩkũnengera nguo yake ya igũrũ ĩrũgamĩrĩre thiirĩ, mũcookerie riũa rĩtanathũa, ");
INSERT INTO kik_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","tondũ noyo arĩ nayo ya kwĩhumbĩra. Angĩkĩĩhumbĩra nakĩ agĩkoma? Angaĩra, nĩngamũigua, nĩgũkorwo ndĩ mũigua tha. ");
INSERT INTO kik_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Ndũkanarume Ngai kana ũrume mũnene wa andũ anyu. ");
INSERT INTO kik_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ndũgacerithĩrie maruta kuuma makũmbĩ-inĩ maku kana mahihĩro-inĩ maku ma ndibei. “No nginya ũũheage marigithathi ma ariũ aku. ");
INSERT INTO kik_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Wĩkage o ũguo mwena-inĩ wĩgiĩ ngʼombe na ngʼondu ciaku. Iria ciaciarwo ũrekage igaikara na manyina mĩthenya mũgwanja, mũthenya wa ĩnana ũgacineana kũrĩ niĩ. ");
INSERT INTO kik_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Inyuĩ mũgũtuĩka andũ akwa aamũre. Nĩ ũndũ ũcio mũtikanarĩe nyama cia nyamũ ndamburange nĩ nyamũ cia gĩthaka; ciikagĩriei ngui. ");
INSERT INTO kik_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Ndũkanamemerekie ndeto cia maheeni. Ndũgateithĩrĩrie mũndũ mwaganu na ũndũ wa kũrũgamĩrĩra ũira wa maheeni. ");
INSERT INTO kik_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Ndũkarũmanĩrĩre na mũingĩ gwĩka ũũru. Ũngĩruta ũira igooti-inĩ, ndũkogomie kĩhooto ũkĩnyiitanĩra na mũingĩ, ");
INSERT INTO kik_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","na ndũkonanie kĩmenyano harĩ mũndũ mũthĩĩni ciira-inĩ wake. ");
INSERT INTO kik_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ũngĩona ndegwa kana ndigiri ya mũndũ mũrĩ ũthũ nake yũrĩte-rĩ, tigĩrĩra atĩ nĩwamĩcookia kũrĩ we. ");
INSERT INTO kik_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ũngĩona ndigiri ya mũndũ ũgũthũire ĩgwĩte ĩkaremererwo nĩ mũrigo wayo-rĩ, ndũkamĩtige hau; no nginya ũmũteithie kũmĩũkĩria. ");
INSERT INTO kik_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ndũkanaime andũ anyu arĩa athĩĩni kĩhooto ciira-inĩ wao. ");
INSERT INTO kik_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ndũkahutanie na thitango ya maheeni, na ndũkoorage mũndũ ũtarĩ na mahĩtia kana mũndũ mwĩhokeku, nĩgũkorwo ndikarekereria mũndũ mwĩhia. ");
INSERT INTO kik_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ndũkoe ihaki, nĩgũkorwo ihaki nĩrĩtũmaga arĩa monaga matuĩke atumumu, na rĩkoogomia ciugo cia andũ arĩa athingu. ");
INSERT INTO kik_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Ndũkahatĩrĩrie mũgeni; inyuĩ nĩmũũĩ ũrĩa mũgeni aiguaga, tondũ mwarĩ ageni bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Haandaga irio mĩgũnda yaku mĩaka ĩtandatũ, na ũkagetha irio iria iciarĩte mĩaka ĩyo, ");
INSERT INTO kik_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","no mwaka wa mũgwanja ũkarekaga mũgũnda ũikare ũguo ũtarĩmĩtwo na ũtekũhũthĩrwo. Nao arĩa athĩĩni gatagatĩ ka andũ anyu makonaga irio kuuma mũgũnda ũcio, nacio nyamũ cia gĩthaka ikarĩĩaga kĩrĩa marĩtigagia. Ĩkaga o ũguo na mũgũnda waku wa mĩthabibũ na wa mĩtamaiyũ. ");
INSERT INTO kik_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Rutaga wĩra waku mĩthenya ĩtandatũ, no mũthenya wa mũgwanja ndũkanarute wĩra, nĩgeetha ndegwa na ndigiri yaku ihurũke, nayo ngombo ĩrĩa ĩciarĩirwo gwaku, kana mũgeni, o nao magĩage na ihinda rĩa kũnogoka. ");
INSERT INTO kik_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Menyagĩrĩra wĩkage maũndũ marĩa mothe ngwĩrĩte. Ndũkanagwete marĩĩtwa ma ngai ingĩ; ndũkareke maiguuo makĩgwetwo na kanua gaku. ");
INSERT INTO kik_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Gĩagai na gĩathĩ gĩa gũkũngũĩra maita matatũ o mwaka. ");
INSERT INTO kik_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Kũngũyagĩra Gĩathĩ kĩa Mĩgate Ĩtarĩ na Ndawa ya Kũimbia; handũ ha mĩthenya mũgwanja ũrĩĩage mĩgate ĩtarĩ na ndawa ya kũimbia, o ta ũrĩa ndagwaathire. Ĩkaga ũndũ ũyũ hĩndĩ ĩrĩa ĩtuĩtwo mweri-inĩ wa Abibu, tondũ nĩ mweri-inĩ ũcio woimire bũrũri wa Misiri. “Gũtikanagĩe mũndũ ũrĩũkaga mbere yakwa moko matheri. ");
INSERT INTO kik_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Kũngũyagĩra Gĩathĩ kĩa Magetha na maciaro ma mbere ma irio iria ũhaandĩte mĩgũnda yaku. “Kũngũyagĩra Gĩathĩ kĩa Igetha mũthia-inĩ wa mwaka, rĩrĩa ũgũcookanĩrĩria irio ciaku kuuma mũgũnda. ");
INSERT INTO kik_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Arũme othe nĩmarĩthiiaga mbere ya Mwathani Jehova maita matatũ o mwaka. ");
INSERT INTO kik_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Ndũkanandutĩre thakame ya igongona hamwe na kĩndũ kĩrĩ na ndawa ya kũimbia. “Maguta ma maruta makwa ma gĩathĩ matikaigwo nginya rũciinĩ. ");
INSERT INTO kik_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Rehaga indo iria njega cia maciaro ma mbere nyũmba-inĩ ya Jehova Ngai waku. “Ndũkanaruge koori na iria rĩa nyina. ");
INSERT INTO kik_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Na rĩrĩ, niĩ nĩndĩratũma mũraika athiĩ mbere yanyu, amũrangĩre njĩra-inĩ na amũkinyie handũ harĩa ndĩmũhaarĩirie. ");
INSERT INTO kik_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Iguagai na mwathĩkagĩre ũrĩa ekũmwĩra. Mũtikanamũkararie tondũ ndakamũrekera ũremi wanyu, nĩgũkorwo Rĩĩtwa rĩakwa rĩrĩ thĩinĩ wake. ");
INSERT INTO kik_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mũngĩmũigua kũna ũrĩa aroiga, na mwĩke ũrĩa wothe ngaamwĩra, nĩngatuĩka thũ kũrĩ thũ cianyu, na njũkĩrĩre arĩa makaamũũkĩrĩra. ");
INSERT INTO kik_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mũraika wakwa nĩagathiĩ mbere yanyu, na amũkinyie bũrũri wa Aamori, na Ahiti, na Aperizi, na Akaanani, na Ahivi, na Ajebusi, na niĩ nĩngamaniina biũ. ");
INSERT INTO kik_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Mũtikanainamĩrĩre ngai ciao, kana mũcihooe, kana mũrũmĩrĩre mĩtugo yao. No nginya mũcianange, nayo mĩhianano ya ngai ciao cia mahiga mũmiunange tũcunjĩ. ");
INSERT INTO kik_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Hooyagai Jehova Ngai wanyu nake, nĩarĩrathimaga irio cianyu na maaĩ manyu. Nĩndĩĩmweheragĩria mĩrimũ gatagatĩ-inĩ kanyu, ");
INSERT INTO kik_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","na gũtirĩ mũndũ ũkaahuna kana atuĩke thaata bũrũri-inĩ wanyu. Nĩndĩĩmũkinyagĩria matukũ marĩa mwathĩrĩirio ma gũtũũra muoyo. ");
INSERT INTO kik_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nĩngũtũma kĩmakania gĩakwa mbere yanyu, na ndũme ndũrĩrĩ iria mũrĩĩkoragĩrĩra inyiitwo nĩ kĩrigiicano. Nĩndĩtũmaga thũ cianyu imũũragĩre. ");
INSERT INTO kik_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nĩngatũma magi mbere yanyu, maingate Ahivi, na Akaanani na Ahiti mamweherere. ");
INSERT INTO kik_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","No rĩrĩ, ndikamaingata o mwaka ũmwe, tondũ bũrũri wahota gũcooka gĩthaka, nacio nyamũ cia gĩthaka imũingĩhĩre mũno. ");
INSERT INTO kik_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ndĩmaingataga o kahora o kahora, nginya rĩrĩa mũkaingĩha mũhote kwĩnyiitĩra bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Nĩngekĩra mĩhaka yanyu kuuma Iria Itune, ndĩmĩikũrũkie nginya Iria rĩa Afilisti, na kuuma werũ-inĩ nginya Rũũĩ rwa Farati. Andũ arĩa maikaraga kũu nĩngamaneana moko-inĩ manyu, na inyuĩ mũmaingate mamweherere. ");
INSERT INTO kik_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mũtikagĩe na kĩrĩkanĩro nao kana na ngai ciao. ");
INSERT INTO kik_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Mũtikareke matũũre bũrũri-inĩ wanyu; nĩ tondũ no matũme mũnjĩhĩrie, nĩ tondũ kũhooya ngai icio ciao ti-itherũ nĩgũkamũtoonyia mũtego-inĩ.” ");
INSERT INTO kik_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Nake Jehova akĩĩra Musa atĩrĩ, “Ambata, ũũke kũrĩ Jehova, wee na Harũni, na Nadabu, na Abihu, na athuuri mĩrongo mũgwanja a Isiraeli, mũinamĩrĩre mũhooe mũrĩ haraaya, ");
INSERT INTO kik_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","no Musa wiki ũgaakuhĩrĩria Jehova; acio angĩ matigooke hakuhĩ. Nao andũ acio angĩ a Isiraeli matikambate nawe.” ");
INSERT INTO kik_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Nake Musa agĩthiĩ na akĩĩra andũ ciugo ciothe cia Jehova na mawatho make, nao andũ magĩĩtĩkanĩria na mũgambo ũmwe, makiuga atĩrĩ, “Ũrĩa wothe Jehova oigĩte, nĩtũgwĩka.” ");
INSERT INTO kik_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Nake Musa akĩandĩka ũhoro wothe ũrĩa Jehova aarĩtie. Mũthenya ũyũ ũngĩ agĩũkĩra rũciinĩ tene, agĩaka kĩgongona magũrũ-inĩ ma kĩrĩma, na akĩrũgamia itugĩ ikũmi na igĩrĩ cia mahiga irũgamĩrĩire mĩhĩrĩga ikũmi na ĩĩrĩ ya Isiraeli. ");
INSERT INTO kik_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ningĩ agĩtũma aanake amwe a Isiraeli, nao makĩruta magongona ma njino, na magĩthĩnja tũtegwa tũrĩ igongona rĩa ũiguano kũrĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Musa akĩoya nuthu ya thakame yatuo akĩmĩĩkĩra mbakũri-inĩ, na nuthu ĩrĩa ĩngĩ akĩmĩminjaminjĩria kĩgongona kĩu. ");
INSERT INTO kik_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ningĩ akĩoya Ibuku rĩa Kĩrĩkanĩro, na akĩrĩthomera andũ. Nao andũ magĩĩtĩkanĩria, makiuga atĩrĩ, “Nĩtũgwĩka ũrĩa wothe Jehova oigĩte; nĩtũgwathĩka.” ");
INSERT INTO kik_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Musa agĩcooka akĩoya thakame ĩyo, akĩmĩminjaminjĩria andũ, na akiuga atĩrĩ, “Ĩno nĩ thakame ya kĩrĩkanĩro kĩrĩa Jehova aarĩkanĩire na inyuĩ kũringana na ciugo ici ciothe.” ");
INSERT INTO kik_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musa na Harũni, na Nadabu na Abihu hamwe na athuuri acio mĩrongo mũgwanja a Isiraeli makĩambata, ");
INSERT INTO kik_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","na makĩona Ngai wa Isiraeli. Rungu rwa makinya make haarĩ handũ haakĩtwo wega na mahiga ma yakuti ya bururu, matherete o ta igũrũ rĩo rĩene. ");
INSERT INTO kik_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","No Jehova ndaigana kũhũũra atongoria acio a Isiraeli; nĩmoonire Ngai, na makĩrĩa na makĩnyua. ");
INSERT INTO kik_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nake Jehova akĩĩra Musa atĩrĩ, “Ambata, ũũke kũrĩ niĩ kĩrĩma igũrũ, na ũikare ho, na nĩngũcooka ngũnengere ihengere cia mahiga, irĩ na maandĩko ma watho na maathani marĩa nyandĩkĩte nĩguo ũmarutage andũ a Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ningĩ Musa akiumagara marĩ na mũteithĩrĩria wake Joshua, nake Musa akĩambata kĩrĩma-inĩ kĩa Ngai. ");
INSERT INTO kik_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Akĩĩra athuuri acio atĩrĩ, “Twetererei haha nginya rĩrĩa tũgaacooka. Harũni na Huri marĩ hamwe na inyuĩ, mũndũ o wothe ũrĩa ũngĩgĩa na ciira nĩathiiage kũrĩ o.” ");
INSERT INTO kik_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Rĩrĩa Musa aambatire kĩrĩma-inĩ, itu rĩkĩhumbĩra kĩrĩma, ");
INSERT INTO kik_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","naguo riiri wa Jehova ũgĩikara igũrũ rĩa Kĩrĩma gĩa Sinai. Kĩrĩma gĩkĩhumbĩrwo nĩ itu rĩu mĩthenya ĩtandatũ, na mũthenya wa mũgwanja Jehova agĩĩta Musa arĩ itu-inĩ rĩu. ");
INSERT INTO kik_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","andũ a Isiraeli moonaga riiri wa Jehova ũtariĩ ta mwaki wa kũniinana ũrĩ kĩrĩma igũrũ. ");
INSERT INTO kik_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Hĩndĩ ĩyo Musa agĩtoonya itu-inĩ o akĩambataga kĩrĩma. Agĩikara kũu kĩrĩma-inĩ matukũ mĩrongo ĩna, ũtukũ na mũthenya. ");
INSERT INTO kik_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ĩra andũ a Isiraeli mandehere iruta. Nĩwe ũkwamũkĩra iruta rĩu handũ hakwa kuuma kũrĩ mũndũ o wothe ũrĩa ngoro yake ĩkwenda kũheana. ");
INSERT INTO kik_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Maruta marĩa ũrĩamũkagĩra kuuma kũrĩ o nĩmo maya: thahabu, na betha na gĩcango; ");
INSERT INTO kik_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa njega, o na guoya wa mbũri; ");
INSERT INTO kik_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","na njũa cia ndũrũme itoboketio rangi-inĩ mũtune, na njũa cia pomboo, na mbaũ cia mũgaa; ");
INSERT INTO kik_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","na maguta ma mũtamaiyũ ma gwakia tawa; na mahuti manungi wega ma gũthondeka maguta ma gũitanĩrĩrio, na ũbumba ũrĩa mũnungi wega; ");
INSERT INTO kik_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","na tũhiga twa onigithi, na tũhiga tũngĩ twa goro twa gwĩkĩrwo ebodi-inĩ na gakuo ga gĩthũri. ");
INSERT INTO kik_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Ningĩ ũnjakithĩrie handũ haamũre, na niĩ nĩngatũũranagia nao. ");
INSERT INTO kik_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Thondekai hema ĩno nyamũre, na mwĩkĩre indo cia thĩinĩ kũringana na mũhano ũrĩa ngũkuonia. ");
INSERT INTO kik_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Nĩmathondekere ithandũkũ rĩa mbaũ cia mũgaa. Ũraihu warĩo ũkorwo ũrĩ mĩkono ĩĩrĩ na nuthu, na kwarama kwarĩo gũkorwo kũrĩ mũkono ũmwe na nuthu, na kũraiha na igũrũ kwarĩo gũkorwo nĩ mũkono ũmwe na nuthu. ");
INSERT INTO kik_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ithandũkũ rĩu rĩgemio na thahabu therie mĩena yeerĩ nja na thĩinĩ, na mũrĩtirihe na mũcibi wa thahabu mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Rĩtwekerie icũhĩ inya cia thahabu, na ũcioherere magũrũ-inĩ marĩo mana, icũhĩ igĩrĩ mwena ũmwe na icũhĩ igĩrĩ mwena ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ũcooke ũthondeke mĩtĩ mĩraaya ya mũgaa ũmĩgemie na thahabu. ");
INSERT INTO kik_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Toonyia mĩtĩ ĩyo mĩraaya icũhĩ-inĩ iria irĩ mĩena ya ithandũkũ nĩgeetha rĩkuuĩkage. ");
INSERT INTO kik_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mĩtĩ ĩyo mĩraaya ĩrekwo ĩikarage icũhĩ-inĩ cia ithandũkũ rĩĩrĩ, na ndĩkeheragio. ");
INSERT INTO kik_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ũcooke wĩkĩre thĩinĩ wa ithandũkũ rĩu Ũira, ũrĩa ngũkũhe. ");
INSERT INTO kik_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Thondeka gĩtĩ gĩa tha gĩa thahabu therie, gĩkorwo kĩrĩ kĩa ũraihu wa mĩkono ĩĩrĩ na nuthu, na wariĩ wa mũkono ũmwe na nuthu. ");
INSERT INTO kik_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Na ũture makerubi meerĩ ma thahabu, ũmekĩre mĩthia-inĩ ya gĩtĩ kĩu gĩa tha. ");
INSERT INTO kik_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Thondeka ikerubi rĩmwe rĩikare mũthia-inĩ ũmwe, na ikerubi rĩu rĩngĩ rĩikare mũthia-inĩ ũrĩa ũngĩ wa gĩtĩ gĩa tha; thondeka makerubi macio maanyiitanĩte na gĩtĩ gĩa tha mĩthia-inĩ yeerĩ. ");
INSERT INTO kik_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Makerubi macio makorwo matambũrũkĩtie mathagu mamo na igũrũ, magathiĩka gĩtĩ kĩu gĩa tha namo. Makerubi macio makorwo maroranĩte, na marorete gĩtĩ kĩu gĩa tha. ");
INSERT INTO kik_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Igĩrĩra gĩtĩ kĩu gĩa tha igũrũ rĩa ithandũkũ, na wĩkĩre thĩinĩ wa ithandũkũ rĩu Ũira ũrĩa ngũkũhe. ");
INSERT INTO kik_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Na hau igũrũ wa gĩtĩ gĩa tha, gatagatĩ ka makerubi macio meerĩ marĩ igũrũ wa ithandũkũ rĩa Ũira nĩngacemania nawe ngũhe maathani makwa mothe nĩ ũndũ wa andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Thondeka metha na mbaũ cia mũgaa, ũraihu wayo ũkorwo ũrĩ wa mĩkono ĩĩrĩ, na wariĩ wayo ũkorwo ũrĩ wa mũkono ũmwe, na kũraiha na igũrũ ĩkorwo ĩrĩ na mũkono ũmwe na nuthu. ");
INSERT INTO kik_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ũmĩgemie na thahabu therie, na ũmĩtirihe na mũcibi wa thahabu. ");
INSERT INTO kik_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Mĩthondekere karũbaũ gaceke ka wariĩ wa rũhĩ gathiũrũrũkĩrie metha ĩyo, na ũgatirihe na mũcibi wa thahabu. ");
INSERT INTO kik_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Thondekera metha ĩyo icũhĩ inya cia thahabu, ũcioherere koona-inĩ iria inya o harĩa magũrũ macio mana marĩ. ");
INSERT INTO kik_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Icũhĩ icio ikorwo irĩ hakuhĩ na mũcibi wa karũbaũ karĩa gaceke, nĩgeetha inyiitagĩrĩre mĩtĩ ĩrĩa ya gũkuuaga metha ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Thondeka mĩtĩ mĩraaya ya mbaũ cia mũgaa, ũmĩgemie na thahabu na ũkuuage metha nayo. ");
INSERT INTO kik_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Na ũthondeke thaani ciayo, na thaani nene cia thahabu therie na ndigithũ, na mbakũri cia gũitaga maruta. ");
INSERT INTO kik_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Iga mĩgate ĩrĩa ĩigagwo mbere yakwa igũrũ rĩa metha ĩyo, nayo ĩikarage hau mbere yakwa mahinda mothe. ");
INSERT INTO kik_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Thondeka mũtĩ wa kũigĩrĩrwo matawa ma thahabu therie, kĩrũgamo o na gĩtina kĩaguo iturwo inyiitanĩte; ikombe ciaguo ihaana ta mahũa, na tũkonyo twaguo o na mahũa ikorwo irĩ kĩndũ kĩmwe inyiitanĩte naguo. ");
INSERT INTO kik_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Honge ithathatũ ciumĩre mĩena-inĩ ya mũrũgamo wa mũtĩ ũcio wa kũigĩrĩrwo matawa, ithatũ mwena ũmwe na ithatũ mwena ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ikombe ithatũ iturĩtwo na mũhiano wa mahũa ma mũrothi irĩ na tũkonyo na mahũa ikorwo irĩ rũhonge-inĩ rũmwe, nacio ithatũ ikorwo rũu rũngĩ; honge icio ciothe ithathatũ ikorwo ihaana o ũguo, ciumĩte mũtĩ-inĩ ũcio wa kũigĩrĩrwo matawa. ");
INSERT INTO kik_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Na mũtĩ-inĩ ũcio wa kũigĩrĩra matawa hagĩe ikombe inya cia mũhiano wa mahũa ma mũrothi irĩ na tũkonyo na mahũa. ");
INSERT INTO kik_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Gakonyo kamwe gakorwo karĩ rungu rwa honge cia mbere igĩrĩ ciumĩte mũrũgamo-inĩ wa mũtĩ ũcio wa kũigĩrĩrwo matawa, nako gakonyo ga keerĩ kagĩe rungu rwa honge cia keerĩ igĩrĩ, nako gakonyo ga gatatũ kagĩe thĩ wa honge cia gatatũ igĩrĩ, ciothe nĩ honge ithathatũ. ");
INSERT INTO kik_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Tũkonyo tũu na honge icio ikorwo irĩ kĩndũ kĩmwe na mũtĩ ũcio wa kũigĩrĩrwo matawa, iturĩtwo na thahabu therie. ");
INSERT INTO kik_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Ningĩ ũthondeke matawa mũgwanja maguo na ũmaigĩrĩre igũrũ rĩaguo nĩgeetha mamũrĩke hau mbere ya guo. ");
INSERT INTO kik_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Magathĩ ma gũtinia ndaambĩ na thaani cia mũrarĩ wa ndaambĩ ikorwo irĩ cia thahabu therie. ");
INSERT INTO kik_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Taranda ya thahabu therie ĩhũthĩrwo gũthondeka mũtĩ wa kũigĩrĩrwo matawa o na indo icio ciothe. ");
INSERT INTO kik_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ũtigĩrĩre atĩ nĩwacithondeka kũringana na mũhianĩre ũrĩa wonirio ũrĩ kĩrĩma-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Thondeka hema nyamũre ĩrĩ na itambaya ikũmi cia gũcuurio itumĩtwo na gatani yogothetwo wega ya ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na igemio na makerubi nĩ mũtumi mũũgĩ na wĩra ũcio. ");
INSERT INTO kik_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Itambaya icio cia gũcuurio ciothe ikorwo ciiganaine, mĩkono mĩrongo ĩĩrĩ na ĩnana kũraiha na mĩkono ĩna kwarama. ");
INSERT INTO kik_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Itambaya ithano-rĩ, itumanio hamwe, na icio ingĩ ithano itumanio hamwe. ");
INSERT INTO kik_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kundĩka ciana cia gĩtambaya kĩa rangi wa bururu mũthia-inĩ wa gĩtambaya gĩa gũcuurio kĩrĩa kĩrĩ mũico wa mwena ũmwe, na wĩke o ro ũguo harĩ gĩtambaya kĩa mũico kĩa mwena ũcio ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Kundĩka ciana mĩrongo ĩtano gĩtambaya-inĩ kĩmwe gĩa gũcuurio, na ingĩ mĩrongo ĩtano gĩtambaya-inĩ kĩa mũico kĩa mwena ũcio ũngĩ, na ũringithanie o kĩana na kĩrĩa kĩngĩ. ");
INSERT INTO kik_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ningĩ ũthondeke ngathĩka mĩrongo ĩtano cia thahabu, na ũcihũthĩre na kuohithania itambaya icio cia gũcuurio nĩguo hema ĩyo nyamũre ĩtuĩke kĩndũ kĩmwe. ");
INSERT INTO kik_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Tuma itambaya ikũmi na kĩmwe cia guoya wa mbũri ituĩke hema ya kũhumbĩra hema ĩrĩa nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Itambaya icio ciothe ikũmi na kĩmwe ikorwo ciiganaine, ikorwo irĩ mĩkono mĩrongo ĩtatũ kũraiha na mĩkono ĩna kwarama. ");
INSERT INTO kik_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tumania itambaya ithano cia icio cia gũcuurio ituĩke kĩndũ kĩmwe, nacio icio ingĩ ithathatũ itumanio hamwe. Kũnja gĩtambaya gĩa gatandatũ maita meerĩ mwena wa mbere wa hema. ");
INSERT INTO kik_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kundĩka ciana mĩrongo ĩtano mũthia-inĩ wa itambaya cia gũcuurio cia mwena ũmwe, ningĩ wĩke o ũguo mũthia-inĩ wa itambaya icio cia mwena ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ningĩ ũthondeke ngathĩka mĩrongo ĩtano cia gĩcango, na ũcitoonyie ciana-inĩ nĩgeetha hema ĩyo ĩtuĩke kĩndũ kĩmwe. ");
INSERT INTO kik_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Harĩ ũraihu wa gĩtambaya gĩa gũcuurio ũrĩa ũngĩtigara, nuthu ya gĩtambaya kĩrĩa gĩtigaire nĩ gĩcunjuure mwena wa thuutha wa hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Itambaya cia gũcuurio cia hema ikorwo iraihĩte kũrĩ icio ingĩ na mũkono ũmwe mĩena yeerĩ; kĩrĩa gĩgũtigara gĩcunjuure kĩhumbĩre mĩena ya hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Thondekera hema ĩyo kĩandarũa kĩa njũa cia ndũrũme itoboketio rangi-inĩ mũtune igatunĩha, na igũrũ wakĩo ũkĩhumbĩre na njũa cia pomboo. ");
INSERT INTO kik_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Thondeka mbaũ cia kũrũgama cia mũtĩ wa mũgaa cia gwaka hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","O rũbaũ-inĩ rũkorwo rũrĩ rwa mĩkono ikũmi kũraiha na mũkono ũmwe na nuthu kwarama, ");
INSERT INTO kik_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","mbaũ icio igĩe na tũhocio tũcomokete tũigananĩirie. Thondeka mbaũ icio ciothe cia Hema-ĩrĩa-Nyamũre na njĩra ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Thondeka mbaũ mĩrongo ĩĩrĩ cia mwena wa gũthini wa hema ĩyo nyamũre, ");
INSERT INTO kik_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","na ũthondeke itina cia betha mĩrongo ĩna cia gũikarĩrwo nĩ mbaũ icio mĩrongo ĩĩrĩ, o rũbaũ rũmwe rũgaikarĩra itina igĩrĩ, o rũmwe rũkorwo rũrĩ rungu rwa kahocio. ");
INSERT INTO kik_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ningĩ mwena ũcio ũngĩ, mwena wa gathigathini wa hema ĩyo nyamũre, thondeka mbaũ mĩrongo ĩĩrĩ ");
INSERT INTO kik_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","na itina mĩrongo ĩna cia betha o igĩrĩ igaikarĩrwo nĩ rũbaũ rũmwe. ");
INSERT INTO kik_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Thondeka mbaũ ithathatũ cia mwena wa na thuutha, nĩguo mwena wa mũthia wa ithũĩro wa hema ĩyo nyamũre, ");
INSERT INTO kik_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","na ũthondeke mbaũ igĩrĩ cia koine cia mwena wa na thuutha. ");
INSERT INTO kik_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Koine-inĩ icio cierĩ no nginya ikorwo irĩ mbaũ igĩrĩ igĩrĩ kuuma thĩ nginya igũrũ, na ciohanio na mũrĩnga ũmwe; koine cierĩ igakorwo itariĩ ũguo. ");
INSERT INTO kik_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Nĩ ũndũ ũcio hegũkorwo na mbaũ inyanya, na itina ikũmi na ithathatũ cia betha, o igĩrĩ igaikarĩrwo nĩ rũbaũ rũmwe. ");
INSERT INTO kik_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Ningĩ ũthondeke mĩgamba ya mbaũ cia mũgaa: ĩtano yayo nĩ ũndũ wa mbaũ cia mwena ũmwe wa hema ĩyo nyamũre, ");
INSERT INTO kik_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","na ĩtano nĩ ũndũ wa mbaũ cia mwena ũcio ũngĩ, na ĩtano nĩ ũndũ wa mbaũ cia mwena wa ithũĩro mũthia-inĩ ũrĩa wa na thuutha wa hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Mũgamba wa gatagatĩ uume mũthia ũmwe nginya ũrĩa ũngĩ, ũgereire gatagatĩ ka mbaũ icio. ");
INSERT INTO kik_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Gemia mbaũ icio na thahabu, na ũthondeke mĩrĩnga ya thahabu ya kũnyiitĩrĩra mĩgamba ĩyo. O nayo mĩgamba ĩyo nĩĩgemio na thahabu. ");
INSERT INTO kik_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Aka hema ĩyo nyamũre kũringana na mũhianĩre ũrĩa wonirio rĩrĩa warĩ kĩrĩma-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tuma gĩtambaya gĩa gũcuurio kĩa ndigi cia rangi wa bururu, na cia rangi wa ndathi na cia rangi mũtune ta gakarakũ, na cia gatani ĩrĩa yogothetwo wega na ĩkagemio na makerubi nĩ mũbundi mũũgĩ. ");
INSERT INTO kik_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Cuuria gĩtambaya kĩu na tũcuurio twa thahabu ikĩngĩ-inĩ inya cia mũgaa iria igemetio na thahabu, na ikarũgama igũrũ rĩa njikarĩro inya cia betha. ");
INSERT INTO kik_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Cuuria gĩtambaya kĩu gĩa gũcuurio na ngathĩka, na ũcooke ũige ithandũkũ rĩa Ũira thuutha wa gĩtambaya kĩu gĩa gũcuurio. Gĩtambaya kĩu gĩa gũcuurio kĩhakanie Handũ-harĩa-Hatheru na Handũ-harĩa-Hatheru-Mũno. ");
INSERT INTO kik_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Igĩrĩra gĩtĩ gĩa tha igũrũ rĩa ithandũkũ rĩa Ũira thĩinĩ wa Handũ-harĩa-Hatheru-Mũno. ");
INSERT INTO kik_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Iga metha nja ya gĩtambaya kĩu gĩa gũcuurio mwena wa gathigathini wa hema ĩyo nyamũre, naguo mũtĩ wa kũigĩrĩra matawa ũũige mwena wa gũthini ũngʼethanĩre na metha ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Itoonyero-inĩ rĩa hema, thondeka gĩtambaya gĩa gũcuurio kĩa rangi wa bururu, na rangi wa ndathi, na rangi mũtune ta gakarakũ, na gatani ĩrĩa yogothetwo wega, kĩgemetio nĩ mũgemia mũũgĩ. ");
INSERT INTO kik_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Thondekera gĩtambaya kĩu gĩa gũcuurio tũcuurio twa thahabu na itugĩ ithano cia mũgaa igemetio na thahabu. Na ũcitwekerie itina ithano cia gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Aka kĩgongona na mbaũ cia mũgaa, kĩa mĩkono ĩtatũ kũraiha na igũrũ; gĩkorwo kĩiganaine mĩena yothe, mĩkono ĩtano kũraiha na mĩkono ĩtano kwarama. ");
INSERT INTO kik_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Thondeka hĩa inya, o rũmwe koine-inĩ ĩmwe ya kĩgongona, nĩgeetha hĩa icio na kĩgongona ikorwo irĩ kĩndũ kĩmwe, nakĩo kĩgongona kĩu ũkĩgemie na gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Thondeka indo ciothe cia kĩgongona irĩ cia gĩcango, ũgĩthondekere nyũngũ cia kũrutaga mũhu, na icakũri na mbakũri cia gwĩkĩrwo thakame ya kũminjaminja, na njibe cia kũnyiita nyama, na ngĩo cia mwaki. ");
INSERT INTO kik_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Thondekera kĩgongona kĩu gĩtara, na ningĩ ũthondeke mũkwa wa gĩcango, na ũthondeke mĩrĩnga ya gĩcango, o ũmwe wĩkĩrwo koine-inĩ iria inya cia mũkwa ũcio. ");
INSERT INTO kik_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ũige gĩtara kĩu rungu wa muoho wa kĩgongona nĩgeetha rũkinye nuthu ya ũraihu wa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Thondeka itugĩ cia mũgaa nĩ ũndũ wa kĩgongona na ũcigemie na gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Itugĩ icio itoonyio mĩrĩnga-inĩ ĩyo nĩgeetha ĩgakoragwo ĩikarĩire mĩena-inĩ yeerĩ ya kĩgongona hĩndĩ ya gũgĩkuua. ");
INSERT INTO kik_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Thondeka kĩgongona kĩu na mbaũ nĩguo kĩgĩe na irima gatagatĩ. Ũgĩthondeke o ta ũrĩa wonirio rĩrĩa warĩ kĩrĩma-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Thondeka nja ya hema ĩrĩa nyamũre; mwena wa gũthini ũkorwo ũrĩ wa mĩkono igana kũraiha na ũgĩe na itambaya cia gũcuurio cia gatani ũrĩa mwogothe wega, ");
INSERT INTO kik_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ũkorwo na itugĩ mĩrongo ĩĩrĩ na itina mĩrongo ĩĩrĩ cia gĩcango, irĩ na tũcuurio na tũmĩkwa twa betha itugĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Mwena wa gathigathini o naguo ũkorwo ũrĩ na mĩkono igana kũraiha na ũgĩe na itambaya cia gũcuurio, ũgĩe na itugĩ mĩrongo ĩĩrĩ na itina mĩrongo ĩĩrĩ cia gĩcango, irĩ na tũcuurio na tũmĩkwa twa betha itugĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Mwena wa ithũĩro wa nja ĩyo ũkorwo ũrĩ wa mĩkono mĩrongo ĩtano kwarama na ũgĩe na itambaya cia gũcuurio na itugĩ ikũmi na itina ikũmi. ");
INSERT INTO kik_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Mwena wa irathĩro, kwerekera kũrĩa riũa rĩrathagĩra, nja ĩyo ĩkorwo ĩrĩ ya wariĩ wa mĩkono mĩrongo ĩtano. ");
INSERT INTO kik_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Itambaya cia gũcuurio ikorwo irĩ cia ũraihu wa mĩkono ikũmi na ĩtano na ikorwo irĩ mwena ũmwe wa itoonyero rĩa nja ĩyo, na ikorwo na itugĩ ithatũ na itina ithatũ, ");
INSERT INTO kik_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","na itambaya ingĩ cia gũcuurio cia ũraihu wa mĩkono ikũmi na ĩtano ikorwo mwena ũcio ũngĩ wa itoonyero, na ikorwo irĩ na itugĩ ithatũ na itina ithatũ. ");
INSERT INTO kik_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Naguo ũhoro wa itoonyero rĩa nja ĩyo, wĩkĩre gĩtambaya gĩa gũcuurio gĩkorwo kĩrĩ kĩa ũraihu wa mĩkono mĩrongo ĩĩrĩ, kĩa ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa yogothetwo wega, wĩra wa mũgemia mũũgĩ, na gĩkorwo na itugĩ inya na itina inya. ");
INSERT INTO kik_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Itugĩ ciothe gũthiũrũrũkĩria nja ĩyo, igĩe na tũmĩkwa na tũcuurio twa betha na itina cia gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Nja ĩyo ĩkorwo na ũraihu wa mĩkono igana, na mĩkono mĩrongo ĩtano kwarama, na ĩkorwo na itambaya cia gũcuurio cia gatani yogothetwo wega ya mĩkono ĩtano kũraiha na igũrũ, na ĩrĩ na itina cia gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Indo iria ingĩ ciothe cia gũtũmĩrwo wĩra-inĩ wa hema ĩrĩa nyamũre, irĩ cia wĩra o na ũrĩkũ, o hamwe na higĩ cia kwamba hema na cia nja ciothe, nĩikorwo irĩ cia gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Atha andũ a Isiraeli makũrehere maguta marĩa makeere wega ma ndamaiyũ hihe ma gũkũheaga ũtheri, nĩgeetha matawa maikarage maakanĩte. ");
INSERT INTO kik_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Thĩinĩ wa Hema-ya-Gũtũnganwo, nja ya gĩtambaya gĩa gũcuurio kĩrĩa kĩrĩ mbere ya ithandũkũ rĩa Ũira, Harũni na ariũ ake nĩmaigage matawa maakanĩte mbere ya Jehova kuuma hwaĩ-inĩ o nginya rũciinĩ. Ũndũ ũyũ ũtuĩke watho wa kũrũmagĩrĩrwo tene na tene thĩinĩ wa Isiraeli njiarwa-inĩ ciothe iria igooka. ");
INSERT INTO kik_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Tũmanĩra Harũni mũrũ wa nyũkwa oke harĩwe kuuma gatagatĩ ka andũ a Isiraeli, hamwe na ariũ ake Nadabu na Abihu, na Eleazaru na Ithamaru, nĩgeetha mandungatagĩre marĩ athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tumĩra Harũni mũrũ wa nyũkwa nguo nyamũre, cia kũmũnenehagia na kũmũtĩĩithagia. ");
INSERT INTO kik_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Arĩria mabundi marĩa marĩ na ũũgĩ wa gũtuma, nguo arĩa niĩ heete ũũgĩ maũndũ-inĩ ta macio, nĩguo matumĩre Harũni nguo cia kwĩhumba akĩamũrwo, nĩguo andungatagĩre arĩ mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Nacio ici nĩcio nguo iria megũtuma: gakuo ga gĩthũri, na ebodi, na nguo ndaaya, na kanjũ ya taama ngʼemie wega, na kĩremba, na mũcibi. Nguo ici nyamũre megũcitumĩra Harũni mũrũ wa nyũkwa na ariũ ake nĩguo mandungatagĩre marĩ athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Nĩ mahũthĩre thahabu, na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, hamwe na gatani ĩrĩa njega. ");
INSERT INTO kik_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Tuma ebodi ya ndigi cia rangi wa thahabu na ndigi cia rangi wa bururu, na cia rangi wa ndathi na cia rangi mũtune ta gakarakũ na ya gatani ĩrĩa yogothetwo wega, wĩra wa mũbundi mũũgĩ. ");
INSERT INTO kik_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Nĩ wega ebodi ĩyo ĩgĩe na tũmĩkwa twĩrĩ twa kũmĩnyiitithanĩria ciande-inĩ, tũtumĩrĩirwo mĩthia-inĩ yeerĩ yayo nĩgeetha ndaamĩ ciayo cierĩ inyiitane. ");
INSERT INTO kik_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Naguo mũcibi wayo wa njohero ũrĩa mũtume wega ũkorwo ũhaana tayo na ũrĩ wa gĩcunjĩ kĩmwe na ebodi ĩyo na ũthondeketwo na ndigi cia rangi wa thahabu, na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, hamwe na gatani njogothe wega. ");
INSERT INTO kik_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Oya tũhiga twĩrĩ twa onigithi ũkurure marĩĩtwa ma ariũ a Isiraeli igũrũ rĩatuo ");
INSERT INTO kik_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","marũmanĩrĩire ũrĩa maaciarirwo, ũkurure marĩĩtwa matandatũ kahiga-inĩ kamwe, na matandatũ kau kangĩ. ");
INSERT INTO kik_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kurura marĩĩtwa ma ariũ a Isiraeli tũhiga-inĩ tũu twĩrĩ ta ũrĩa mũrengi wa tũhiga twa goro akururaga kahengere ga gwĩkĩra mũhũũri. Ũcooke ũtũtumĩrĩre tũkonyo-inĩ twa thahabu, ");
INSERT INTO kik_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","na ũtuoherere ndaamĩ-inĩ cia kĩande cia ebodi, tũrĩ tũhiga twa kĩririkania kĩa ariũ a Isiraeli. Harũni nĩarĩkuuaga marĩĩtwa macio ciande-inĩ ciake matuĩke kĩririkania mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Thondeka tũkonyo tũgemu twa thahabu ");
INSERT INTO kik_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","na irengeeri igĩrĩ cia thahabu therie, ihaana ta mũkanda, nacio ũcinyiitithanie na tũkonyo tũu. ");
INSERT INTO kik_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Thondekithia gakuo ga gĩthũri ga gwĩkagĩrwo ituĩro-inĩ rĩa ciira, nako gatumwo nĩ mũtumi mũũgĩ. Gathondeke ta ebodi: karĩ ka ndigi cia rangi wa thahabu na ka ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ na gatani ĩrĩa yogothetwo wega. ");
INSERT INTO kik_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Gakuo kau gakorwo kaiganaine mĩena yothe ĩna inji kenda kũraiha na inji kenda kwarama, na koinanĩrwo maita meerĩ. ");
INSERT INTO kik_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ũcooke ũgatumĩrĩre mĩhari ĩna ya tũhiga twa goro. Mũhari wa mbere hakorwo kahiga ka wakiki ũrĩa mũtune, na ka yakuti ĩrĩa ĩhaana ngoikoni, na ka baregethu; ");
INSERT INTO kik_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","mũhari wa keerĩ ũtumĩrĩre kahiga ga thumarati, na ka yakuti ĩrĩa ya rangi wa bururu, na ka arimathi; ");
INSERT INTO kik_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","mũhari wa gatatũ ũtumĩrĩre kahiga ka wakiki ũrĩa wa bururu, na ka yacimu, na ka amethuthito; ");
INSERT INTO kik_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","naguo mũhari wa kana ũtumĩrĩrwo kahiga ga thumarati ĩrĩa theru, na ka onigithi, na ka njathibi. Ũtũtumĩrĩre tũkonyo-inĩ tũgemu twa thahabu. ");
INSERT INTO kik_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Hagĩkorwo harĩ na tũhiga ikũmi na twĩrĩ, o kamwe karũgamĩrĩre marĩĩtwa ma ariũ a Isiraeli, o kamwe gakururwo rĩĩtwa rĩa mũhĩrĩga ũmwe wa ĩrĩa ikũmi na ĩĩrĩ ya Isiraeli, o ta ũrĩa kahengere ka mũhũũri gakururagwo. ");
INSERT INTO kik_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Thondekera gakuo kau ga gĩthũri irengeeri njogothe cia thahabu therie ihaana ta mũkanda. ");
INSERT INTO kik_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Gathondekere mĩrĩnga ĩĩrĩ ya thahabu, ũmĩoherere mĩthia-inĩ ĩĩrĩ ya gakuo kau ga gĩthũri. ");
INSERT INTO kik_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ohania irengeeri igĩrĩ cia thahabu mĩrĩnga-inĩ hau mĩthia-inĩ ya gakuo ga gĩthũri, ");
INSERT INTO kik_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","nayo mĩthia ĩrĩa ĩngĩ ya irengeeri yohithanio na tũkonyo tũrĩa twĩrĩ, ũmĩnyiitithanie na ndaamĩ cia kĩande cia ebodi mwena wa na mbere. ");
INSERT INTO kik_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Thondeka mĩrĩnga ĩĩrĩ ya thahabu ũmĩnyiitithanie na mĩthia ĩrĩa ĩngĩ ĩĩrĩ ya gakuo ga gĩthũri mwena wa na thĩinĩ kũrigania na ebodi. ");
INSERT INTO kik_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Thondeka mĩrĩnga ĩngĩ ĩĩrĩ ya thahabu na ũmĩnyiitithanie magũrũ-inĩ ma ndaamĩ cia kĩande mwena-inĩ wa mbere wa ebodi, hakuhĩ na rũtumo, igũrũ hanini wa mũcibi wa njohero ya ebodi. ");
INSERT INTO kik_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Mĩrĩnga ya gakuo ga gĩthũri ĩrĩohithanagio na mĩrĩnga ya ebodi na rũrigi rwa bururu, na inyiitithanio na mũcibi wa njohero, nĩgeetha gakuo ga gĩthũri gatikarekanie na ebodi. ");
INSERT INTO kik_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Rĩrĩa rĩothe Harũni arĩĩtoonyaga Handũ-harĩa-Hatheru, arĩkuuaga marĩĩtwa ma ariũ a Isiraeli marĩ gĩthũri-inĩ gĩake gakuo-inĩ ga gĩthũri ga ituĩro rĩa ciira, arĩ kĩririkania gĩa gũtũũra mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ningĩ wĩkĩre Urimu na Thumimu thĩinĩ wa gakuo kau ga gĩthũri, nĩgeetha ciikarage gĩthũri-inĩ kĩa Harũni rĩrĩa rĩothe arĩĩtoonyaga agathiĩ mbere ya Jehova. Ũguo nĩguo Harũni arĩkuuaga ũhoti wa gũtuagĩra andũ a Isiraeli ciira gĩthũri-inĩ gĩake arĩ mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Tuma nguo ndaaya ya ebodi ya taama wa bururu mũtheri, ");
INSERT INTO kik_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","na ĩkorwo na harũkĩrio ya mũtwe gatagatĩ kayo. Ĩkorwo ĩtirihĩtwo mĩthia-inĩ ta kara ya ngingo gũthiũrũrũkĩria iharũkĩrio rĩu rĩa mũtwe, nĩgeetha ndĩgatarũke. ");
INSERT INTO kik_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Thondeka tũcunjuura tũtariĩ ta matunda ma makomamanga twa ndigi cia rangi wa bururu, na rangi wa ndathi, na rangi mũtune ta gakarakũ gũthiũrũrũka rũtumo rwa magũrũ-inĩ rwa nguo ĩyo, tũhakanĩtio na ngengere cia thahabu. ");
INSERT INTO kik_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ngengere cia thahabu na makomamanga macio mathiĩ mahakanĩtio gũthiũrũrũka rũtumo rwa magũrũ-inĩ rwa nguo ĩyo ndaaya. ");
INSERT INTO kik_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Harũni no nginya ehumbage nguo ĩyo hĩndĩ ciothe rĩrĩa egũtungata. Ngengere nĩirĩiguagwo ikĩgamba rĩrĩa egũtoonya Handũ-harĩa-Hatheru o hau mbere ya Jehova na rĩrĩa ekuuma ho, nĩgeetha ndagakue. ");
INSERT INTO kik_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Thondeka gatanji ga thahabu therie, na ũgakurure ta ũrĩa mũhũũri ũkururagwo, ũkurure ciugo ici: MŨTHERU MWAMŨRĨRE JEHOVA. ");
INSERT INTO kik_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Koherere rũrigi rwa rangi wa bururu nĩguo ũkanyiitithanie na kĩremba, gakorwo karĩ mwena wa mbere wa kĩremba. ");
INSERT INTO kik_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Karĩkoragwo karĩ thiithi-inĩ wa Harũni, nake agakuuaga mahĩtia makoniĩ iheo iria theru, iria andũ a Isiraeli mangĩkorwo mamũrĩire Jehova, o na irĩ cia mũthemba o na ũrĩkũ. Gatanji kau gakoragwo karĩ thiithi-inĩ wa Harũni hĩndĩ ciothe nĩgeetha magetĩkĩrĩkaga nĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Kanjũ nĩĩtumwo ĩrĩ ya gatani ĩrĩa njega mũno, o na ũtume kĩremba na gatani ĩrĩa njega mũno. Mũcibi ũtumwo nĩ mũgemia ũrĩa mũũgĩ na wĩra ũcio. ");
INSERT INTO kik_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Tumĩra ariũ a Harũni kanjũ, na mĩcibi, na tũmĩcibi twa kĩongo, cia gũtũma manenehagio na maheagwo gĩtĩĩo. ");
INSERT INTO kik_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Warĩkia kũhumba mũrũ wa nyũkwa na ariũ ake nguo icio-rĩ, ũmaitĩrĩrie maguta na ũmaamũre. Ũmaamũre nĩgeetha mandungatagĩre marĩ athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Matumithĩrie thuruarĩ cia thĩinĩ cia gatani, cia kũhumbĩra njaga ya mĩĩrĩ yao kuuma njohero nginya ciero-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Harũni na ariũ ake no nginya maciĩhumbage rĩrĩa rĩothe marĩtoonyaga Hema-ya-Gũtũnganwo kana magĩthengerera kĩgongona marutĩre wĩra Handũ-harĩa-Hatheru nĩgeetha matikahĩtie, nao makue. “Ũyũ nĩũtuĩke watho wa kũrũmagĩrĩrwo tene na tene nĩ Harũni na njiaro ciake. ");
INSERT INTO kik_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Na rĩrĩ, ũũ nĩguo ũgwĩka nĩgeetha wamũre Harũni na ariũ ake, nĩguo mandungatagĩre marĩ athĩnjĩri-Ngai: Oya gategwa kamwe na ndũrũme igĩrĩ itarĩ kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Na kuuma mũtu-inĩ mũhinyu mũno wa ngano ũtarĩ ndawa ya kũimbia, ũthondeke mĩgate na keki itukanĩtio na maguta na tũmĩgate tũhũthũ tũhakĩtwo maguta. ");
INSERT INTO kik_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ĩkĩra indo icio gĩkabũ-inĩ na ũcinenganĩre ũguo hamwe na ndegwa ĩyo na ndũrũme icio cierĩ. ");
INSERT INTO kik_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ũcooke ũrehe Harũni na ariũ ake itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, ũmathambie na maaĩ. ");
INSERT INTO kik_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Oya nguo icio, ũhumbe Harũni kanjũ, na nguo ndaaya ya ebodi, na ebodi yo nyene na gakuo ga gĩthũri. Muohe ebodi na mũcibi wayo wa njohero ũrĩa mũtume wega. ");
INSERT INTO kik_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mwĩkĩre kĩremba mũtwe, nako gatanji karĩa kaamũre ũgekĩre kĩremba-inĩ kĩu. ");
INSERT INTO kik_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Oya maguta ma gũitanĩrĩrio ũmũitĩrĩrie mũtwe ũmwamũre. ");
INSERT INTO kik_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Rehe ariũ ake na ũmahumbe kanjũ, ");
INSERT INTO kik_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","na ũmoohe tũmĩcibi twa mũtwe. Ningĩ wohe Harũni na ariũ ake mĩcibi. Ũthĩnjĩri-Ngai nĩ wao ũrĩ watho wa kũrũmagĩrĩrwo tene na tene. Ũguo nĩguo ũkaamũra Harũni na ariũ ake. ");
INSERT INTO kik_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Rehe ndegwa ĩyo mwena wa mbere wa Hema-ya-Gũtũnganwo, nake Harũni na ariũ ake mĩigĩrĩre moko mao mũtwe wayo. ");
INSERT INTO kik_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ũcooke ũmĩthĩnjĩre mbere ya Jehova o hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ningĩ woe thakame ĩmwe ya ndegwa ĩyo, ũmĩhake hĩa cia kĩgongona na kĩara gĩaku, ĩyo ĩngĩ ũmĩite gĩtina-inĩ gĩa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ningĩ woe maguta mothe marĩa mahumbĩire nyama cia nda, na marĩa mahumbĩire ini, na higo cierĩ na maguta ma cio ũmacinĩre hau kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","No nyama cia ndegwa ĩyo hamwe na rũũa na mahu ũcicinĩre nja ya kambĩ. Rĩu nĩ iruta rĩa mehia. ");
INSERT INTO kik_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Oya ndũrũme ĩmwe nake Harũni na ariũ ake mamĩigĩrĩre moko mao mũtwe igũrũ wayo. ");
INSERT INTO kik_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Mĩthĩnje na woe thakame, ũmĩminjaminjĩrie kĩgongona mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tinangia ndũrũme tũcunjĩ, na ũthambie nyama cia nda, na magũrũ mayo, ũciige hamwe na mũtwe na tũcunjĩ tũu tũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ũcooke ũcinĩre ndũrũme ĩyo yothe igũrũ wa kĩgongona. Rĩu nĩ iruta rĩa njino rĩa kũrutĩra Jehova, rĩrĩ mũtararĩko mwega rĩrutĩirwo Jehova, rĩrĩ iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Oya ndũrũme ĩyo ĩngĩ, nake Harũni na ariũ ake mamĩigĩrĩre moko mao mũtwe. ");
INSERT INTO kik_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Mĩthĩnje, woe thakame ĩmwe yayo ũmĩhake moni cia matũ ma ũrĩo ma Harũni na ariũ ake o na ciara iria nene cia moko mao ma ũrĩo, na ciara iria nene cia magũrũ mao ma ũrĩo. Ũcooke ũminjaminjĩrie kĩgongona thakame mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Na woe thakame ĩmwe kuuma kĩgongona-inĩ na maguta ma gũitanĩrĩrio ũciminjaminjĩrie Harũni na nguo ciake, na ariũ ake na nguo ciao. Hĩndĩ ĩyo Harũni na ariũ ake hamwe na nguo ciao nĩmagatuĩka aamũre. ");
INSERT INTO kik_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Oya maguta mamwe ma ndũrũme ĩyo, maguta ma mũtingʼoe ũrĩa mũnoru, na maguta marĩa mahumbĩire nyama cia nda, na maguta marĩa mahumbĩire ini, na higo cierĩ na maguta ma cio, na kĩero kĩa mwena wa ũrĩo. (Ĩyo nĩyo ndũrũme ya igongona rĩa kwamũrana.) ");
INSERT INTO kik_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kuuma gĩkabũ-inĩ kĩa mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia kĩrĩa kĩrĩ mbere ya Jehova, oya mũgate ũmwe na keki ĩthondeketwo na maguta, na woe kamũgate kahũthũ. ");
INSERT INTO kik_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Indo ici ciothe cineane moko-inĩ ma Harũni na ariũ ake, ũcooke ũcithũngũthie mbere ya Jehova ĩrĩ Igongona rĩa gũthũngũthio. ");
INSERT INTO kik_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ningĩ ũcooke woe indo icio kuuma moko-inĩ mao, ũcicinĩre kĩgongona-inĩ igũrũ hamwe na iruta rĩa njino, ituĩke mũtararĩko mwega harĩ Jehova, rĩrĩ iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Warĩkia kũruta gĩthũri kĩa ndũrũme ĩyo ya kĩamũrano kĩa Harũni, gĩthũngũthie mbere ya Jehova rĩrĩ iruta rĩa gũthũngũthio, nakĩo gĩtuĩke rwĩga rwaku. ");
INSERT INTO kik_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Amũra icunjĩ cia ndũrũme ĩyo ya kĩamũrano iria irĩ cia Harũni na ariũ ake nacio nĩ: gĩthũri kĩrĩa gĩathũngũthĩtio na kĩero kĩrĩa kĩaheanĩtwo. ");
INSERT INTO kik_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Indo icio ituĩke rwĩga rwa kũheagwo Harũni na ariũ ake nĩ andũ a Isiraeli hĩndĩ ciothe. Nĩrĩo iruta rĩrĩa andũ a Isiraeli marĩrutagĩra Jehova kuuma maruta-inĩ ma ũiguano. ");
INSERT INTO kik_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Nguo iria nyamũre cia Harũni igũtuĩka cia njiaro ciake, nĩgeetha magaitagĩrĩrio maguta na makaamũragwo maciĩhumbĩte. ");
INSERT INTO kik_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mũriũ ũrĩa ũkamũgaya atuĩke mũthĩnjĩri-Ngai na oke gũtungata thĩinĩ wa Handũ-Harĩa-Hatheru, Hema-inĩ-ya-Gũtũnganwo arĩĩhumbaga nguo icio mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Oya ndũrũme ĩyo ya kĩamũrano nacio nyama ciayo ũcirugĩre handũ harĩa hatheru. ");
INSERT INTO kik_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Harũni na ariũ ake marĩrĩagĩra nyama cia ndũrũme ĩyo na mĩgate kuuma gĩkabũ-inĩ o hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Nĩmarĩrĩĩaga indo icio irutĩtwo cia horohio nĩ ũndũ wa kwamũrwo kwao na gũtherio. No itikanarĩĩo nĩ mũndũ ũngĩ, nĩ ũndũ nĩ theru. ");
INSERT INTO kik_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Na rĩrĩ, nyama cia ndũrũme ĩyo ya kĩamũrano kana mĩgate ingĩtigara nginya rũciinĩ-rĩ, nĩicinwo. Itikanarĩĩo tondũ nĩ theru. ");
INSERT INTO kik_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ĩka Harũni na ariũ ake maũndũ mothe marĩa ngwathĩte, na ũniine mĩthenya mũgwanja ũkĩmaamũra. ");
INSERT INTO kik_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Rutagai ndegwa ĩmwe o mũthenya, ĩrĩ iruta rĩa mehia rĩa kũhorohanĩria. Theria kĩgongona na ũndũ wa gũkĩhoroheria na gũgĩitĩrĩria maguta, ũkĩamũre. ");
INSERT INTO kik_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Gĩa na horohio ya kĩgongona mĩthenya mũgwanja ya gũkĩamũra. Thuutha ũcio kĩgongona kĩu nĩgĩgũtuĩka gĩtheru mũno, nakĩo kĩrĩa gĩothe kĩrĩkĩhutagia kĩrĩtuĩkaga gĩtheru. ");
INSERT INTO kik_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Gĩkĩ nĩkĩo kĩndũ kĩrĩa ũrĩĩrutaga hĩndĩ ciothe kĩgongona-inĩ o mũthenya: tũtũrũme twĩrĩ, o kamwe ka ũkũrũ wa mwaka ũmwe. ");
INSERT INTO kik_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Gatũrũme kamwe gakarutwo rũciinĩ na karĩa kangĩ hwaĩ-inĩ kũrĩ mairia. ");
INSERT INTO kik_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Gatũrũme ka mbere gakarutanagĩrio na mũtu mũhinyu mũno gĩcunjĩ gĩa ikũmi kĩa eba ũtukanĩtio na maguta ma mũtamaiyũ gacunjĩ ka inya ka hini ĩmwe na ndibei gacunjĩ ka inya ka hini ĩmwe, irĩ kĩndũ gĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ruta gatũrũme kau kangĩ igongona hwaĩ-inĩ kũrĩ mairia, hamwe na iruta rĩa mũtu na rĩa kĩndũ gĩa kũnyuuo o ta cia rũciinĩ, arĩ guo mũtararĩko mwega, rĩrĩ iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Harĩ njiaro iria igooka, iruta rĩĩrĩ rĩa njino rĩkaarutagwo hĩndĩ ciothe itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo mbere ya Jehova. Hau nĩho ndĩĩcemanagia nawe na njaragie nawe; ");
INSERT INTO kik_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ningĩ hau no ho ndĩcemanagia na andũ a Isiraeli, naho nĩhakaamũrwo nĩ riiri wakwa. ");
INSERT INTO kik_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Nĩ ũndũ ũcio nĩngamũra Hema-ĩyo-ya-Gũtũnganwo na kĩgongona na nyamũre Harũni na ariũ ake mandungatagĩre marĩ athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ningĩ nĩngatũũrania na andũ a Isiraeli na nduĩke Ngai wao. ");
INSERT INTO kik_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Nĩmakamenya atĩ niĩ nĩ niĩ Jehova Ngai wao, ũrĩa wamarutire bũrũri wa Misiri nĩgeetha ndũũranagie nao. Niĩ nĩ niĩ Jehova Ngai wao. ");
INSERT INTO kik_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Thondeka kĩgongona kĩa mbaũ cia mũgaa gĩa gũcinagĩra ũbumba. ");
INSERT INTO kik_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Nĩgĩkorwo kĩiganaine mĩena yothe mũkono ũmwe kũraiha na mũkono ũmwe kwarama na mĩkono ĩĩrĩ kũraiha na igũrũ, hĩa ciakĩo ituĩke kĩndũ o ro kĩmwe na kĩgongona. ");
INSERT INTO kik_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kĩgemie igũrũ, o na mĩena yothe, o na hĩa ciakĩo, na thahabu therie, na ũgĩtirihe na mũcibi wa thahabu ũgĩthiũrũrũkĩrie. ");
INSERT INTO kik_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Thondekera kĩgongona kĩu mĩrĩnga ĩĩrĩ, ũmĩoherere thĩ wa mũcibi ũcio, ĩĩrĩ mwena ũmwe, na ĩĩrĩ mwena ũrĩa ũngĩ ĩnyiitagĩrĩre mĩtĩ ĩrĩa mĩraaya ĩtũmagĩrwo gũgĩkuua. ");
INSERT INTO kik_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Thondeka mĩtĩ mĩraaya ya mbaũ cia mũgaa, na ũmĩgemie na thahabu. ");
INSERT INTO kik_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Iga kĩgongona kĩu mbere ya gĩtambaya gĩa gũcuurio kĩrĩa kĩrĩ mbere ya ithandũkũ rĩa Ũira, mbere ya gĩtĩ gĩa tha kĩrĩa kĩrĩ igũrũ rĩa ithandũkũ rĩa Ũira, harĩa ngaacemania nawe. ");
INSERT INTO kik_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Harũni no nginya acinĩre ũbumba mũnungi wega hau igũrũ rĩa kĩgongona o rũciinĩ rĩrĩa egũthondeka matawa. ");
INSERT INTO kik_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","No nginya acine ũbumba rĩngĩ agĩakia matawa hwaĩ-inĩ kũrĩ mairia, nĩgeetha ũbumba ũikarage ũgĩcinagwo mahinda mothe mbere ya Jehova, njiarwa na njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ndũkanacinĩre ũbumba wa mũthemba ũngĩ kĩgongona-inĩ gĩkĩ kana ũrutĩre ho iruta rĩa njino, kana rĩa mũtu, na ndũkanaitĩrĩrie iruta rĩa kũnyuuo igũrũ rĩakĩo. ");
INSERT INTO kik_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Harũni nĩarutage horohio hĩa-inĩ cia kĩgongona kĩu o mwaka riita rĩmwe. Horohio ĩno ya o mwaka no nginya ĩrutagwo na thakame ya iruta rĩa kũhoroheria mehia, nginya njiarwa iria igooka. Horohio ĩyo nĩ igongona itheru mũno harĩ Jehova.” ");
INSERT INTO kik_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hĩndĩ ĩyo Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Rĩrĩa ũgũtara andũ a Isiraeli-rĩ, o mũndũ no nginya arutagĩre Jehova kĩndũ gĩa gũkũũra muoyo wake rĩrĩa egũtarwo. Na gũtirĩ mũthiro ũkaamakora ũkĩmatara. ");
INSERT INTO kik_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Mũndũ o wothe ũrĩkĩraga agathiĩ mwena wa andũ arĩa marĩkĩtie gũtarwo, nĩarĩrutaga nuthu ya cekeri kũringana na ũrĩa cekeri ya harĩa haamũre ĩtariĩ ĩrĩa ĩrĩ na ũritũ wa geera mĩrongo ĩĩrĩ. Nuthu ĩyo ya cekeri nĩ iruta kũrĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Arĩa othe marĩkĩraga magathiĩ mwena wa arĩa marĩkĩtie gũtarwo, marĩ na ũkũrũ wa mĩaka mĩrongo ĩĩrĩ na makĩria, no nginya maheage Jehova iruta rĩu. ");
INSERT INTO kik_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Arĩa atongu matirĩheanaga makĩria ya nuthu ya cekeri, nao arĩa athĩĩni matirĩheanaga kĩndũ kĩnini gũkĩra nuthu ya cekeri hĩndĩ ya kũrutĩra Jehova horohio ya mĩoyo yao. ");
INSERT INTO kik_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Amũkĩra mbeeca cia horohio kuuma kũrĩ andũ a Isiraeli nawe ũcihũthĩre ũtungata-inĩ wa Hema-ya-Gũtũnganwo. Ũguo ũgaatuĩka kĩririkano kĩa andũ a Isiraeli mbere ya Jehova makĩrutĩra mĩoyo yao horohio.” ");
INSERT INTO kik_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Thondeka kĩraĩ gĩa gwĩthambagĩra gĩa gĩcango, kĩrĩ na kĩgũrũ gĩakĩo gĩa gĩcango. Ũkĩige gatagatĩ ka Hema-ya-Gũtũnganwo na kĩgongona, na ũgĩĩkĩre maaĩ. ");
INSERT INTO kik_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Harũni na ariũ ake marĩĩthambaga moko mao na nyarĩrĩ na maaĩ macio. ");
INSERT INTO kik_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Rĩrĩa rĩothe marĩtoonyaga Hema-ya-Gũtũnganwo, marĩĩthambaga na maaĩ nĩgeetha matigakue. O na ningĩ rĩrĩa mathengerera kĩgongona nĩguo marutĩre Jehova iruta rĩa gũcinwo na mwaki, ");
INSERT INTO kik_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","marĩĩthambaga moko na nyarĩrĩ nĩgeetha matigakue. Ũndũ ũcio ũgaatuĩka watho wa kũrũmĩrĩrwo tene na tene nĩ Harũni na njiaro ciake, na njiarwa ciao ciothe iria igooka.” ");
INSERT INTO kik_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Oya mahuti maya manungi wega: cekeri 500 cia manemane ĩrĩa ndwekie, nuthu yamo (nacio icio nĩ cekeri 250) cia ndarathini nungi wega, na cekeri 250 cia karamathi nungi wega, ");
INSERT INTO kik_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","cekeri 500 cia mwĩnũ, ciothe kũringana na cekeri ya handũ-harĩa-haamũre, na hini ya maguta ma mĩtamaiyũ. ");
INSERT INTO kik_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Indo ici ũcithondeke ituĩke maguta matheru ma gũitanĩrĩrio matukanĩtio makanunga wega marutĩirwo wĩra nĩ mũthondeki mũũgĩ wa maguta. Macio matuĩke maguta matheru ma gũitanagĩrĩrio. ");
INSERT INTO kik_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ningĩ ũhũthĩre maguta macio gũitĩrĩria Hema-ya-Gũtũnganwo, na ithandũkũ rĩa Ũira, ");
INSERT INTO kik_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","na metha na indo ciayo ciothe, na mũtĩ wa kũigĩrĩrwo matawa na indo ciaguo, na kĩgongona gĩa gũcinĩra ũbumba, na ");
INSERT INTO kik_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kĩgongona kĩa iruta rĩa njino na indo ciakĩo ciothe, na kĩraĩ na kĩgũrũ gĩakĩo. ");
INSERT INTO kik_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Nĩũgaciamũra nĩgeetha ituĩke theru mũno makĩria, nakĩo kĩrĩa gĩothe gĩgacihutia nĩgĩgatuĩka gĩtheru. ");
INSERT INTO kik_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Itĩrĩria Harũni na ariũ ake maguta ũmaamũre nĩgeetha mandungatagĩre marĩ athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ĩra andũ a Isiraeli atĩrĩ, ‘Maya nĩmo maguta makwa marĩa matheru ma gũitanagĩrĩrio ma njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ndũkanamaitĩrĩrie mĩĩrĩ ya arũme, na ndũkanathondeke maguta mangĩ na mũthondekere ũcio. Nĩ matheru na nĩ wega ũmatuage atĩ nĩ matheru. ");
INSERT INTO kik_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Mũndũ wothe ũrĩthondekaga maguta manungi wega mahaana ta maya, na mũndũ o wothe ũngĩmaitĩrĩria mũndũ ũtarĩ mũthĩnjĩri-Ngai, nĩakaingatwo kuuma kũrĩ andũ ao.’ ” ");
INSERT INTO kik_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Oya mahuti manungi wega marĩa metagwo thitakiti, na onuka na garibane, hamwe na ũbani ũrĩa mwega mũno, mothe mathimĩtwo maiganaine, ");
INSERT INTO kik_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","na ũthondekithie magĩe na mũtararĩko mwega wa ũbumba; wĩra ũcio ũrutwo nĩ mũthondeki mũũgĩ wa maguta. Makorwo mekĩrĩtwo cumbĩ, na marĩ matheru na makaamũrwo. ");
INSERT INTO kik_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Thĩithia mahuti mamwe matuĩke mũtu, naguo ũũige mbere ya ithandũkũ rĩa Ũira thĩinĩ wa Hema-ya-Gũtũnganwo, harĩa ndĩĩcemanagia nawe. Ũgaakorwo ũrĩ mũtheru mũno harĩwe. ");
INSERT INTO kik_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Mũtikanethondekere ũbumba wa mũthemba ũyũ nĩ ũndũ wa inyuĩ ene; ũtuagei mũtheru nĩ ũndũ wa Jehova. ");
INSERT INTO kik_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Mũndũ o na ũrĩkũ ũrĩa ũgathondeka ũngĩ taguo nĩguo ekenagie na mũtararĩko waguo nĩakaingatwo kuuma kũrĩ andũ ao.” ");
INSERT INTO kik_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ta rora wone, nĩthuurĩte Bezaleli mũrũ wa Uri ũrĩa mũriũ wa Huri wa mũhĩrĩga wa Juda, ");
INSERT INTO kik_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","na nĩndĩmũiyũrĩtie na Roho wa Ngai, na ũũgĩ na ũhoti na ũmenyo mawĩra-inĩ ma mĩthemba yothe ya moko; ");
INSERT INTO kik_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ya gũcora mĩcoro ya ũũgĩ indo-inĩ cia thahabu, na betha na gĩcango, na ");
INSERT INTO kik_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","gwacũhia tũhiga twa goro twa gũthecererwo indo-inĩ, na kũruta wĩra wa gũkaaya mbaũ, na kũruta mawĩra ma mĩthemba yothe ya ũbundi. ");
INSERT INTO kik_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","O na rĩrĩ, nĩthuurĩte Oholiabu mũrũ wa Ahisamaku, wa mũhĩrĩga wa Dani, nĩguo ateithagie Bezaleli wĩra. Ningĩ nĩheete mabundi mothe ũũgĩ wa gũthondeka indo ciothe iria ngwathĩte: ");
INSERT INTO kik_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","nacio nĩ Hema-ya-Gũtũnganwo, na ithandũkũ rĩa Ũira, na gĩtĩ gĩa tha kĩrĩa kĩrĩ igũrũ rĩarĩo, na indo iria ingĩ ciothe cia hema, ");
INSERT INTO kik_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","nacio nĩ metha na indo ciayo, na mũtĩ wa thahabu therie wa kũigĩrĩrwo matawa na indo ciaguo ciothe, na kĩgongona gĩa gũcinĩra ũbumba, na ");
INSERT INTO kik_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kĩgongona kĩa iruta rĩa njino na indo ciakĩo, na kĩraĩ na kĩgũrũ gĩakĩo, ");
INSERT INTO kik_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","o na nguo iria ndume, iria theru cia kwĩhumbwo nĩ Harũni ũrĩa mũthĩnjĩri-Ngai na nguo cia kwĩhumbwo nĩ ariũ ake rĩrĩa megũtungata marĩ athĩnjĩri-Ngai, ");
INSERT INTO kik_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","na maguta ma gũitanĩrĩrio, na ũbumba mũnungi wega wa Handũ-harĩa-Hatheru. Mathondeke indo icio o ta ũrĩa ngwathĩte.” ");
INSERT INTO kik_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Ĩra andũ a Isiraeli ũũ: ‘No nginya mũrũmagie Thabatũ ciakwa. Rũrũ nĩruo rũgatuĩka rũũri gatagatĩ gakwa na inyuĩ njiarwa iria igooka, nĩguo mũmenye atĩ niĩ nĩ niĩ Jehova ũrĩa ũmũtheragia. ");
INSERT INTO kik_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Menyagĩrĩrai Thabatũ tondũ nĩ mũthenya mũtheru harĩ inyuĩ. Mũndũ ũngĩũthaahia no nginya ooragwo; mũndũ ũngĩruta wĩra mũthenya ũcio nĩakaingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Wĩra nĩũrutagwo mĩthenya ĩtandatũ, no mũthenya wa mũgwanja nĩ Thabatũ theru ya Jehova ya andũ kũhurũka. Ũrĩa wothe ũkaaruta wĩra mũthenya wa Thabatũ no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","andũ a Isiraeli nĩmathĩkagĩre Thabatũ, mamĩkũngũyagĩre ĩtuĩke kĩrĩkanĩro gĩa gũtũũra njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Rũrũ nĩruo rũgaatuĩka rũũri gatagatĩ gakwa na andũ a Isiraeli nginya tene, nĩgũkorwo Jehova ombire igũrũ na thĩ na mĩthenya ĩtandatũ na mũthenya wa mũgwanja ndaigana kũruta wĩra, akĩhurũka.’ ” ");
INSERT INTO kik_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Rĩrĩa Jehova aarĩkirie kwaria na Musa kũu igũrũ rĩa Kĩrĩma gĩa Sinai, akĩmũnengera ihengere icio igĩrĩ cia Ũira, o ihengere icio cia mahiga, o icio ciandĩkĩtwo na kĩara kĩa Ngai. ");
INSERT INTO kik_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Rĩrĩa andũ moonire atĩ Musa nĩaikarire mũno ataikũrũkĩte kuuma kĩrĩma-inĩ, magĩcookanĩrĩra harĩ Harũni makĩmwĩra atĩrĩ, “Ũka, tũthondekere ngai iria irĩtũtongoragia. Ha ũhoro wa mũndũ ũyũ ũgwĩtwo Musa, ũrĩa watũrutire bũrũri wa Misiri, tũtiũĩ ũrĩa oonete.” ");
INSERT INTO kik_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Harũni akĩmacookeria akĩmeera atĩrĩ, “Rutai icũhĩ cia thahabu iria irĩ matũ ma atumia anyu, na aanake na airĩtu anyu mũndehere.” ");
INSERT INTO kik_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Nĩ ũndũ ũcio andũ othe makĩruta icũhĩ cia thahabu icio ciarĩ matũ-inĩ mao magĩcirehere Harũni. ");
INSERT INTO kik_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Nake akĩoya indo iria maamũreheire, agĩcitwekia agĩtũmĩra indo cia ũbundi gũcithondeka mũhianano wa njaũ. Nao andũ makiuga atĩrĩ, “Ici nĩcio ngai ciaku, wee Isiraeli, iria ciakũrutire bũrũri wa Misiri.” ");
INSERT INTO kik_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Rĩrĩa Harũni onire ũguo, agĩaka kĩgongona mbere ya njaũ ĩyo, na akĩanĩrĩra, akiuga atĩrĩ, “Rũciũ nĩgũgakorwo na gĩathĩ kĩa Jehova.” ");
INSERT INTO kik_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nĩ ũndũ ũcio mũthenya ũyũ ũngĩ andũ magĩũkĩra rũciinĩ tene, makĩruta magongona ma njino na ma ũiguano. Thuutha ũcio magĩikara thĩ kũrĩa na kũnyua, magĩcooka magĩũkĩra kũina na gwĩkenia. ");
INSERT INTO kik_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nake Jehova akĩĩra Musa atĩrĩ, “Ikũrũka, tondũ andũ aku arĩa warutire bũrũri wa Misiri nĩmethũkĩtie. ");
INSERT INTO kik_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nĩmagarũrũkĩte narua magatiga ũrĩa ndaamathĩte, na nĩmethondekeire mũhianano wa gũtwekio ũhaana njaũ. Nĩmaũinamĩrĩire na makaũrutĩra iruta makiugaga atĩrĩ, ‘Ici nĩcio ngai ciaku, wee Isiraeli, iria ciakũrutire bũrũri wa Misiri.’ ” ");
INSERT INTO kik_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Jehova akĩĩra Musa atĩrĩ, “Nĩnyonete andũ aya, nĩ andũ momĩtie ngingo. ");
INSERT INTO kik_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Rĩu tigana na niĩ nĩgeetha marakara makwa mamarĩrĩmbũkĩre, nĩgeetha ndĩmaniine. Nĩngacooka ngũtue rũrĩrĩ rũnene.” ");
INSERT INTO kik_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","No Musa agĩthaitha Jehova Ngai wake, akĩmwĩra atĩrĩ, “Wee Jehova, ũngĩcinwo nĩ marakara ũũkĩrĩre andũ aku nĩkĩ, o arĩa warutire kuuma bũrũri wa Misiri na guoko gwaku kũrĩ ũhoti na ũkĩmaruta kuo na hinya mũnene? ");
INSERT INTO kik_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nĩ kĩĩ kĩngĩtũma andũ a Misiri moige atĩrĩ, ‘Aamarutire bũrũri wa Misiri arĩ na muoroto wa kũmeka ũũru amooragĩre irĩma-inĩ, na amaniine mathire gũkũ thĩ’? Tiga kũrakara mũno; wĩricũkwo ndũkarehere andũ aku mwanangĩko. ");
INSERT INTO kik_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ririkana ndungata ciaku Iburahĩmu, na Isaaka, na Isiraeli, arĩa wee wehĩtire kũrĩ o na mwĩhĩtwa ũkĩĩgwetaga, ũkiuga atĩrĩ: ‘Nĩngatũma njiaro ciaku cingĩhe ta njata cia matu-inĩ, na nĩngaahe njiaro ciaku bũrũri ũyũ wothe ũrĩa ndaamerĩire, naguo ũgaatuĩka igai rĩao nginya tene.’ ” ");
INSERT INTO kik_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hĩndĩ ĩyo Jehova akĩĩricũkwo, na ndaigana kũrehere andũ ake mwanangĩko ũrĩa oigĩte atĩ nĩekũmarehera. ");
INSERT INTO kik_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Musa akĩhũndũka, agĩikũrũka kuuma kĩrĩma igũrũ akuuĩte ihengere icio igĩrĩ cia Ũira na moko make. Ciarĩ nyandĩke mĩena yeerĩ, mbere na thuutha. ");
INSERT INTO kik_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ihengere icio ciarĩ wĩra wa Ngai; maandĩko macio maarĩ maandĩko ma Ngai makururĩtwo ihengere-inĩ icio. ");
INSERT INTO kik_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Rĩrĩa Joshua aiguire inegene rĩa andũ makiugĩrĩria akĩĩra Musa atĩrĩ, “Kũrĩ mbugĩrĩrio ya mbaara kambĩ-inĩ.” ");
INSERT INTO kik_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Musa akĩmũcookeria atĩrĩ, “Ti mĩgambo ya ũhootani, na ti mĩgambo ya kũhootwo; nĩ mĩgambo ya kũina ndĩraigua.” ");
INSERT INTO kik_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Rĩrĩa Musa akuhĩrĩirie kambĩ, na akĩona njaũ na ndũrũhĩ ĩrĩa yarĩ kũndũ kũu, agĩcinwo nĩ marakara, nake agĩikia ihengere icio thĩ, ikiunĩkanga icunjĩ o hau magũrũ-inĩ ma kĩrĩma. ");
INSERT INTO kik_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Nake akĩnyiita njaũ ĩyo maathondekete, akĩmĩcina na mwaki, agĩcooka akĩmĩthĩa, ĩgĩtuĩka mũtu, akĩũikia maaĩ-inĩ na agĩatha andũ a Isiraeli manyue maaĩ macio. ");
INSERT INTO kik_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Nake Musa akĩũria Harũni atĩrĩ, “Andũ aya maragwĩkire atĩa nĩgeetha ũmatoonyie mehia-inĩ manene ũũ?” ");
INSERT INTO kik_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Nake Harũni akĩmũcookeria, akĩmwĩra atĩrĩ, “Tiga kũrakara, mwathi wakwa; wee nĩũũĩ ũrĩa andũ aya mendete gwĩka ũũru. ");
INSERT INTO kik_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Maanjĩĩrire atĩrĩ, ‘Tũthondekere ngai iria irĩtũtongoragia. Ha ũhoro wa mũndũ ũyũ ũgwĩtwo Musa, ũrĩa watũrutire bũrũri wa Misiri-rĩ, tũtiũĩ ũrĩa oonire.’ ");
INSERT INTO kik_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nĩ ũndũ ũcio ngĩmeera atĩrĩ, ‘Ũrĩa wothe ũrĩ na mathaga ma thahabu, nĩarute.’ Nao makĩĩnengera indo icio cia thahabu, ngĩciikia riiko, nacio ikiuma njaũ ĩno!” ");
INSERT INTO kik_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa akĩona atĩ andũ nĩmakararĩtie, na atĩ Harũni nĩamarekereirie meke ũrĩa mekwenda, nginya magaatuĩka andũ a gũthekagĩrĩrwo nĩ thũ ciao. ");
INSERT INTO kik_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Nĩ ũndũ ũcio akĩrũgama itoonyero-inĩ rĩa kambĩ, akiuga atĩrĩ, “Ũrĩa wothe ũrĩ mwena wa Jehova-rĩ, nĩoke haha.” Nao Alawii othe makĩrũgama mwena wake. ");
INSERT INTO kik_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Nake akĩmeera atĩrĩ, “Jehova Ngai wa Isiraeli ekuuga atĩrĩ, ‘O mũndũ nĩeyohe rũhiũ rwa njora njohero. Hungurai kambĩ ĩno kuuma mwena ũmwe nginya ũrĩa ũngĩ, o mũndũ nĩoorage mũrũ wa nyina na oorage mũratawe na mũndũ wa itũũra rĩake.’ ” ");
INSERT INTO kik_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Alawii magĩĩka ta ũrĩa maathirwo nĩ Musa, na mũthenya ũcio gũkĩũragwo andũ ta 3,000. ");
INSERT INTO kik_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Nake Musa akiuga atĩrĩ, “Nĩmwarĩkia kwamũrĩrwo Jehova ũmũthĩ, nĩgũkorwo nĩmwareganire na ariũ anyu na mũkĩregana na arĩa mũciaranĩirwo nao, na Jehova nĩamũrathima ũmũthĩ.” ");
INSERT INTO kik_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mũthenya ũyũ ũngĩ Musa akĩĩra andũ atĩrĩ, “Nĩmwĩhĩtie mũno. No rĩu, nĩngwambata kũrĩ Jehova; hihi no kũhoteke ndĩmũrutĩre horohio nĩ ũndũ wa rĩhia rĩanyu.” ");
INSERT INTO kik_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Nĩ ũndũ ũcio Musa agĩcooka kũrĩ Jehova, akĩmwĩra atĩrĩ, “Hĩ, kaĩ andũ aya nĩmekĩte rĩhia inene-ĩ! Nĩmethondekeire ngai cia thahabu. ");
INSERT INTO kik_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","No rĩu-rĩ, ndagũthaitha marekere mehia mao; angĩkorwo ndũkũmarekera, o na niĩ tharia ibuku-inĩ rĩrĩa wandĩkĩte andũ aku.” ");
INSERT INTO kik_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nake Jehova agĩcookeria Musa atĩrĩ, “Ũrĩa wothe ũnjĩhĩirie, nĩngamũtharia ibuku-inĩ rĩakwa. ");
INSERT INTO kik_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Rĩu gĩthiĩ, ũtongorie andũ acio mathiĩ bũrũri ũrĩa ndaaririe ũhoro waguo, nake mũraika wakwa nĩakamũtongoria. Na rĩrĩ, hĩndĩ ya kũmaherithia yakinya-rĩ, no ngaamaherithia nĩ ũndũ wa mehia mao.” ");
INSERT INTO kik_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nake Jehova akĩhũũra andũ acio na mũthiro nĩ tondũ wa ũrĩa meekire na njaũ ĩyo yathondeketwo nĩ Harũni. ");
INSERT INTO kik_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Umai handũ haha, wee na andũ arĩa warutire kuuma bũrũri wa Misiri, mwambate bũrũri ũrĩa nderĩire Iburahĩmu, na Isaaka na Jakubu na mwĩhĩtwa ngiuga atĩrĩ, ‘Nĩngaũhe njiaro ciaku.’ ");
INSERT INTO kik_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nĩngũtũma mũraika mbere yanyu na nĩngaingata Akaanani, na Aamori, na Ahiti, na Aperizi, na Ahivi, na Ajebusi. ");
INSERT INTO kik_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ambatai mũthiĩ bũrũri ũcio ũrĩ bũthi wa iria na ũũkĩ. No niĩ ndigathiĩ na inyuĩ, tondũ mũrĩ andũ momĩtie ngingo na ndahota kũmũniinĩra njĩra-inĩ.” ");
INSERT INTO kik_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Rĩrĩa andũ acio maiguire ciugo icio cia kũmathĩĩnia ngoro, makĩambĩrĩria gũcakaya na gũtirĩ mũndũ wacookire kwĩhumba mathaga. ");
INSERT INTO kik_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Nĩgũkorwo Jehova nĩeerĩte Musa atĩrĩ, “Ĩra andũ a Isiraeli atĩrĩ, ‘Inyuĩ mũrĩ andũ momĩtie ngingo. Ingĩtwarana na inyuĩ o na kahinda kanini, ndahota kũmũniina. Rĩu rutai mathaga manyu, na nĩngũmenya ũrĩa ngwĩka na inyuĩ.’ ” ");
INSERT INTO kik_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Nĩ ũndũ ũcio andũ a Isiraeli makĩrutĩra mathaga mao hau kĩrĩma-inĩ kĩa Horebu. ");
INSERT INTO kik_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Na rĩrĩ, Musa nĩamenyerete kuoya hema akamĩamba nja ya kambĩ ĩyo handũ haraaya na kambĩ, akamĩĩta “Hema-ya-Gũtũnganwo.” Mũndũ o wothe ũngĩendire gũtuĩria ũhoro kũrĩ Jehova, aathiiaga hema-inĩ ĩyo ya gũtũnganwo kũu nja ya kambĩ. ");
INSERT INTO kik_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Na rĩrĩa rĩothe Musa aathiiaga hema-inĩ, andũ othe mookĩraga makarũgama nja ya hema ciao, magacũthĩrĩria Musa nginya rĩrĩa arĩtoonya hema ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Musa agĩtoonya hema ĩyo, gĩtugĩ gĩa itu gĩaikũrũkaga gĩgaikara itoonyero-inĩ Jehova akĩaria na Musa. ");
INSERT INTO kik_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Rĩrĩa andũ mona gĩtugĩ kĩu gĩa itu kĩrũgamĩte itoonyero-inĩ rĩa hema ĩyo, othe maarũgamaga makahooya o mũndũ arĩ itoonyero-inĩ rĩa hema yake. ");
INSERT INTO kik_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Jehova agakĩaria na Musa makĩonanaga ũthiũ kwa ũthiũ o ta ũrĩa mũndũ maaragia na mũratawe. Thuutha ũcio Musa agacooka kambĩ, no Joshua mũrũ wa Nuni, mwanake ũrĩa wamũteithagia, ndoimaga hema-inĩ ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa akĩĩra Jehova atĩrĩ, “Ũkoretwo ũkĩnjĩĩra atĩrĩ, ‘Tongoria andũ aya,’ no ndũũmenyithĩtie ũrĩa ũkũndũmĩra tũthiĩ nake. Nĩũnjĩrĩte atĩrĩ, ‘Nĩngũũĩ na rĩĩtwa, na wĩ mwĩtĩkĩrĩku harĩ niĩ.’ ");
INSERT INTO kik_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Angĩkorwo nĩũkenetio nĩ niĩ, menyithia njĩra ciaku nĩgeetha ngũmenye na thiĩ na mbere gwĩtĩkĩrĩka nĩwe. Ririkana atĩ rũrĩrĩ rũrũ nĩ andũ aku.” ");
INSERT INTO kik_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Jehova akĩmũcookeria atĩrĩ, “Niĩ Mwene nĩngũtwarana na inyuĩ na ndĩmũhe ũhurũko.” ");
INSERT INTO kik_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Nake Musa akĩmwĩra atĩrĩ, “Angĩkorwo ndũgũtwarana hamwe na ithuĩ, ndũgatũme tuume haha. ");
INSERT INTO kik_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Mũndũ o na ũrĩkũ angĩkĩmenya atĩa atĩ nĩũkenetio nĩ niĩ, na ũgakenio nĩ andũ aku, tiga no ũtwaranire na ithuĩ? Nĩ kĩĩ kĩngĩ kĩngĩonania ngũũrani yakwa na ya andũ aku kuuma kũrĩ andũ arĩa angĩ othe marĩ thĩ ĩno?” ");
INSERT INTO kik_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Nake Jehova akĩĩra Musa atĩrĩ, “Nĩngwĩka o ũrĩa ũnjũũrĩtie njĩke, tondũ nĩngenetio nĩwe, na nĩngũũĩ na rĩĩtwa rĩaku.” ");
INSERT INTO kik_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ningĩ Musa akiuga atĩrĩ, “Nyonia riiri waku ũrĩa ũtariĩ.” ");
INSERT INTO kik_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nake Jehova akĩmwĩra atĩrĩ, “Nĩngũtũma wega wakwa wothe ũhĩtũkĩre mbere yaku, na nĩngwanĩrĩra rĩĩtwa rĩakwa, Jehova, mbere yaku: Nĩndĩiguagĩra tha ũrĩa ndenda kũiguĩra tha, na nĩndĩcaayagĩra ũrĩa ndenda gũcaĩra.” ");
INSERT INTO kik_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","No Jehova akiuga atĩrĩ, “Ndũngĩona ũthiũ wakwa, nĩgũkorwo gũtirĩ mũndũ ũngĩona ũthiũ wakwa na acooke atũũre muoyo.” ");
INSERT INTO kik_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ningĩ Jehova akiuga atĩrĩ, “Nĩ harĩ handũ hakuhĩ na niĩ, harĩa ũngĩrũgama igũrũ rĩa mwaro rwa ihiga. ");
INSERT INTO kik_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Rĩrĩa riiri wakwa ũrĩkorwo ũkĩhĩtũkĩra hau-rĩ, nĩndĩgũtoonyia mwanya-inĩ wa rwaro rũu rwa ihiga, ngũhumbĩre na guoko gwakwa nginya hĩtũke handũ hau. ");
INSERT INTO kik_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Rĩrĩa ndĩrĩeheria guoko gwakwa, nawe nĩũrĩnyona na thuutha; no ũthiũ wakwa ndũngĩonwo.” ");
INSERT INTO kik_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nake Jehova akĩĩra Musa atĩrĩ, “Icũhia ihengere igĩrĩ cia mahiga o ta iria cia mbere, na nĩngũciandĩka ciugo iria ciaandĩkĩtwo ihengere-inĩ iria cia mbere, iria woragire. ");
INSERT INTO kik_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Wĩhaarĩrie rũciinĩ, ũcooke wambate kĩrĩma gĩa Sinai. Ũrũgame mbere yakwa hau kĩrĩma igũrũ. ");
INSERT INTO kik_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Gũtikagĩe mũndũ ũkwambatania hamwe nawe kana onekane handũ o hothe kũu kĩrĩma-inĩ; o na gũtikagĩe ndũũru cia mbũri kana cia ngʼombe ingĩrĩithio kũu mbere ya kĩrĩma.” ");
INSERT INTO kik_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Nĩ ũndũ ũcio Musa agĩicũhia ihengere igĩrĩ cia mahiga o ta iria cia mbere na akĩroka kwambata kĩrĩma gĩa Sinai rũciinĩ tene, o ta ũrĩa Jehova aamwathĩte; agĩthiĩ akuuĩte ihengere icio igĩrĩ na moko. ");
INSERT INTO kik_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nake Jehova agĩikũrũka arĩ itu-inĩ, akĩrũgama hau harĩ we, na akĩanĩrĩra rĩĩtwa rĩake, Jehova. ");
INSERT INTO kik_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Agĩkĩhĩtũkĩra mbere ya Musa akĩanagĩrĩra akoiga atĩrĩ, “Jehova, Jehova, Ngai ũrĩa mũcaayanĩri na mũtugi, ũtahiũhaga kũrakara, ũiyũrĩtwo nĩ wendani na wĩhokeku, ");
INSERT INTO kik_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ũtũũragia wendani kũrĩ andũ ngiri na ngiri, na akohanagĩra waganu, na ũremi, o na mehia. No rĩrĩ, ndaagaga kũherithia arĩa mehĩtie; nĩaherithagia ciana na ciana ciacio nĩ ũndũ wa mehia ma maithe mao, nginya rũciaro rwa gatatũ na rwa kana.” ");
INSERT INTO kik_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Musa agĩkĩinamĩrĩra thĩ o rĩmwe, akĩhooya. ");
INSERT INTO kik_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Akiuga atĩrĩ, “Wee Mwathani, angĩkorwo nĩnjĩtĩkĩrĩkĩte maitho-inĩ maku, ndagũthaitha Mwathani twarana na ithuĩ. O na gũtuĩka aya nĩ andũ momĩtie ngingo-rĩ, tuohere waganu witũ o na mehia maitũ, na ũtũme tũtuĩke igai rĩaku.” ");
INSERT INTO kik_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ningĩ Jehova akiuga atĩrĩ, “Nĩngũgĩa na kĩrĩkanĩro nawe. Nĩndĩrĩĩkaga morirũ matarĩ mekwo rũrĩrĩ-inĩ o na rũrĩkũ thĩinĩ wa thĩ yothe mbere ya andũ aya aku othe. Andũ arĩa mũtũũranagia nao nĩmakeyonera ũrĩa niĩ, Jehova, ngeeka ũndũ wa kũmakania nĩ ũndũ waku. ");
INSERT INTO kik_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Athĩkĩra ũrĩa ngũgwatha ũmũthĩ. Nĩngarutũrũra Aamori, na Akaanani, na Ahiti, na Aperizi, na Ahivi na Ajebusi mbere yaku makweherere. ");
INSERT INTO kik_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wĩmenyerere ndũkagĩe kĩrĩĩko na andũ arĩa matũũraga bũrũri-inĩ ũcio ũrathiĩ, matigatuĩke mũtego harĩwe. ");
INSERT INTO kik_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Nĩmũkoinanga igongona ciao, na mũthethere mahiga mao maamũre, na mũtemange itugĩ ciao cia Ashera. ");
INSERT INTO kik_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Mũtikanahooe ngai ĩngĩ o na ĩrĩkũ, nĩgũkorwo Jehova, ũrĩa rĩĩtwa rĩake arĩ Mũigua Ũiru, nĩ Ngai ũrĩ ũiru. ");
INSERT INTO kik_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Mwĩmenyererei mũtikagĩe kĩrĩĩko na andũ arĩa matũũraga bũrũri-inĩ ũcio; nĩgũkorwo rĩrĩa maahũũra ũmaraya na ngai ciao na magacirutĩra iruta, nĩmarĩmwĩtaga, na inyuĩ nĩmũrĩrĩĩaga indo cia magongona macio mao. ");
INSERT INTO kik_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Na rĩrĩa mũngĩthuura airĩtu amwe ao matuĩke atumia a aanake anyu, nao airĩtu acio mahũũre ũmaraya na ngai ciao, nĩmakonereria ariũ anyu gwĩka ũguo. ");
INSERT INTO kik_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Ndũkanathondeke mĩhianano ya gũtwekio. ");
INSERT INTO kik_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Kũngũyagĩra Gĩathĩ kĩa Mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia. Handũ-inĩ ha mĩthenya mũgwanja, rĩĩagai mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia, o ta ũrĩa ndaamwathire. Ĩkagai ũndũ ũyũ ihinda rĩaguo rĩakinya mweri-inĩ wa Abibu, nĩgũkorwo nĩguo mweri ũrĩa mwoimire bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Irigithathi rĩa nda o yothe nĩ rĩakwa, hamwe na marigithathi mothe ma njamba ma mahiũ manyu, marĩ ma kuuma ndũũru-inĩ cia ngʼombe kana cia mbũri. ");
INSERT INTO kik_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Irigithathi rĩa ndigiri ũrĩrĩkũũraga na gatũrũme, no ũngĩaga kũrĩkũũra, riune ngingo. Nao ariũ aku a marigithathi ũmakũũrage. “Gũtikanagĩe mũndũ o na ũmwe ũrĩũkaga mbere yakwa moko matheri. ");
INSERT INTO kik_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Rutaga wĩra mĩthenya ĩtandatũ, no mũthenya wa mũgwanja ũhurũkage; o na hĩndĩ ya icimba na ya magetha no nginya ũhurũke. ");
INSERT INTO kik_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Kũngũyagĩra Gĩathĩ-gĩa-Ciumia, na maciaro ma mbere ma magetha ma ngano, na Gĩathĩ-gĩa-Gũcookereria irio makũmbĩ-inĩ mũthia-inĩ wa mwaka. ");
INSERT INTO kik_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Arũme anyu othe no nginya mokage mbere ya Mwathani Jehova, o we Ngai wa Isiraeli, maita matatũ o mwaka. ");
INSERT INTO kik_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Nĩngarutũrũra ndũrĩrĩ imweherere, na nĩnganenehia mĩhaka ya bũrũri wanyu na gũtirĩ mũndũ ũgaacumĩkĩra bũrũri wanyu rĩrĩa mũrĩkoragwo mũkĩambata maita matatũ o mwaka mbere ya Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Ndũkanandutĩre thakame ya igongona ĩtukanĩte na kĩndũ gĩĩkĩre ndawa ya kũimbia, na mũtikanareke kĩndũ kĩa igongona rĩa Bathaka kĩraare nginya rũciinĩ. ");
INSERT INTO kik_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Rehagai maciaro ma mbere marĩa mega mũno ma mĩgũnda yanyu, mũmarehage nyũmba ya Jehova Ngai wanyu. “Mũtikanaruge koori na iria rĩa nyina.” ");
INSERT INTO kik_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Andĩka ciugo ici, nĩgũkorwo kũringana na ciugo ici, nĩndagĩa na kĩrĩkanĩro nawe o na Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa aikarire na Jehova hau matukũ mĩrongo ĩna, mũthenya na ũtukũ, atekũrĩa irio kana akanyua maaĩ. Na agĩkĩandĩka ihengere-inĩ icio ciugo cia kĩrĩkanĩro kĩu, na nĩcio Maathani marĩa Ikũmi. ");
INSERT INTO kik_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Rĩrĩa Musa aikũrũkire kuuma kĩrĩma gĩa Sinai arĩ na ihengere igĩrĩ cia Ũira moko-inĩ make, ndaamenyaga atĩ ũthiũ wake nĩwakengaga nĩ ũndũ nĩarĩtie na Jehova. ");
INSERT INTO kik_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Rĩrĩa Harũni na andũ a Isiraeli othe moonire Musa, ũthiũ wake nĩwakengaga, nao magĩĩtigĩra kũmũkuhĩrĩria. ");
INSERT INTO kik_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","No Musa akĩmeeta; nĩ ũndũ ũcio Harũni na atongoria othe a mũingĩ magĩcooka harĩ we, nake akĩmaarĩria. ");
INSERT INTO kik_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Thuutha ũcio andũ a Isiraeli othe makĩmũkuhĩrĩria, nake akĩmahe mawatho mothe marĩa Jehova amũheete kũu Kĩrĩma-inĩ gĩa Sinai. ");
INSERT INTO kik_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Rĩrĩa Musa aarĩkirie kũmaarĩria, akĩĩhumbĩra ũthiũ wake na taama wa kwĩhumbĩra ũthiũ. ");
INSERT INTO kik_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","No rĩrĩa rĩothe aatoonyaga harĩ Jehova maranĩrie, nĩarutaga taama ũcio wa kwĩhumbĩra ũthiũ nginya oime ho. Na rĩrĩa oka kũrĩ andũ a Isiraeli na aameera ũrĩa aathĩtwo, ");
INSERT INTO kik_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","makona ũthiũ wake o ũkengete. Nake Musa agacookia taama ũcio wa kwĩhumbĩra ũthiũ nginya rĩrĩa rĩngĩ agaathiĩ kwaria na Jehova. ");
INSERT INTO kik_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Musa nĩonganirie mũingĩ wothe wa andũ a Isiraeli, akĩmeera atĩrĩ, “Maya nĩmo maũndũ marĩa Jehova aamwathĩte mwĩkage: ");
INSERT INTO kik_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Wĩra nĩũrutagwo mĩthenya ĩtandatũ, no mũthenya wa mũgwanja ũrĩkoragwo ũrĩ mũthenya wanyu mũtheru, Thabatũ ya Jehova ya kũhurũka. Ũrĩa ũkaaruta wĩra mũthenya ũcio no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Mũtigaakagie mwaki mũthenya ũcio wa Thabatũ kũrĩa guothe mũrĩtũũraga.” ");
INSERT INTO kik_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Musa akĩĩra mũingĩ wothe wa andũ a Isiraeli atĩrĩ, “Ũũ nĩguo Jehova aathanĩte: ");
INSERT INTO kik_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Rutĩrai Jehova maruta kuuma indo-inĩ iria mũrĩ nacio. Mũndũ ũrĩa wothe ũkũigua akĩenda, nĩarehere Jehova iruta rĩa thahabu, na rĩa betha na rĩa gĩcango; ");
INSERT INTO kik_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","na rĩa ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ; o na gatani ĩrĩa njega; na guoya wa mbũri; ");
INSERT INTO kik_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","njũa cia ndũrũme itoboketio rangi-inĩ mũtune igatunĩha, na njũa cia pomboo; na mbaũ cia mũgaa; ");
INSERT INTO kik_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","na maguta ma mũtamaiyũ ma gwakia tawa; na mahuti manungi wega ma gwĩkĩrwo maguta-inĩ ma gũitanĩrĩrio, na ma ũbumba ũrĩa mũnungi wega; ");
INSERT INTO kik_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","na tũhiga twa onigithi na tũhiga tũngĩ twa goro twa gũtumĩrĩrwo nguo ya ebodi na gakuo ga gĩthũri. ");
INSERT INTO kik_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Arĩa othe marĩ na ũũgĩ wa ũbundi gatagatĩ-inĩ kanyu, nĩmoke mathondeke indo ciothe iria Jehova aathanĩte, nacio nĩ: ");
INSERT INTO kik_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Hema ĩrĩa nyamũre na hema yayo o na kĩndũ gĩa kũmĩhumbĩra, na ngathĩka cia kũnyiita, na mbaũ ciakĩo, na mĩgamba yakĩo, na itugĩ na itina ciayo; ");
INSERT INTO kik_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","na ithandũkũ rĩa kĩrĩkanĩro hamwe na mĩtĩ yarĩo, na gĩtĩ gĩa tha, hamwe na gĩtambaya gĩa gũcuurio kĩrĩa gĩa kũhakania; ");
INSERT INTO kik_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","metha na mĩtĩ yayo, na indo ciayo ciothe, hamwe na mĩgate ya kũigwo mbere ya Jehova, ");
INSERT INTO kik_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","na mũtĩ wa kũigĩrĩrwo matawa ma kũmũrĩkaga, hamwe na indo ciaguo, na matawa hamwe na maguta ma kũmaakia; ");
INSERT INTO kik_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","na kĩgongona kĩa ũbumba na mĩtĩ yakĩo, na maguta ma gũitanĩrĩrio, na ũbumba mũnungi wega; na gĩtambaya gĩa gũcuurio mũrango-inĩ wa itoonyero-inĩ rĩa hema ĩyo nyamũre; ");
INSERT INTO kik_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","na kĩgongona kĩa iruta rĩa njino hamwe na gĩtara gĩakĩo gĩa gĩcango, na mĩtĩ yakĩo, na indo ciakĩo ciothe; na kĩraĩ gĩa gĩcango na kĩgũrũ gĩakĩo; ");
INSERT INTO kik_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","na itambaya cia gũcuurio cia itoonyero rĩa nja hamwe na itugĩ na itina ciacio na gĩtambaya gĩa gũcuurio gĩa itoonyero rĩa kuuma nja ya hema ");
INSERT INTO kik_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","na higĩ cia hema ĩrĩa nyamũre, na cia nja yayo, na mĩkanda yayo; ");
INSERT INTO kik_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","na nguo ndume cia kwĩhumbagwo mũndũ agĩtungata arĩ handũ-harĩa-haamũre; nĩcio nguo iria nyamũre cia Harũni ũrĩa mũthĩnjĩri-Ngai o na cia ariũ ake rĩrĩa megũtungata marĩ athĩnjĩri-Ngai.” ");
INSERT INTO kik_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Naguo mũingĩ wothe wa andũ a Isiraeli ũkĩehera harĩ Musa, ");
INSERT INTO kik_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","na mũndũ o wothe ũrĩa weyendeire na ngoro yake yahĩĩahĩaga, nĩokire na akĩrehera Jehova kĩndũ gĩa kũmũrutĩra nĩ ũndũ wa wĩra wa hema-ya-Gũtũnganwo na mawĩra mayo mothe, o na nĩ ũndũ wa nguo iria nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Arĩa maiguire metĩkĩra ũhoro ũcio, arũme na andũ-a-nja o ũndũ ũmwe, nĩmookire na makĩrehe mathaga ma thahabu ma mĩthemba yothe: namo nĩ mbini ngʼemie cia gwĩkĩrwo nguo-inĩ, na icũhĩ cia matũ, na icũhĩ cia ciara na mathaga mangĩ. Othe nĩmarehire thahabu yao ĩtuĩke iruta rĩa gũthũngũthio harĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ũrĩa wothe warĩ na ndigi cia rangi wa bururu, kana cia rangi wa ndathi, kana cia rangi mũtune ta gakarakũ, kana gatani ĩrĩa njega, kana guoya wa mbũri, kana njũa cia ndũrũme itoboketio rangi-inĩ mũtune igatunĩha, kana njũa cia pomboo, nĩacireehire. ");
INSERT INTO kik_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Andũ arĩa maarehire iruta rĩa betha kana rĩa gĩcango, maarĩrehire rĩrĩ iruta harĩ Jehova, na ũrĩa wothe warĩ na mbaũ cia mũgaa nĩ ũndũ wa wĩra ũcio nĩacireehire. ");
INSERT INTO kik_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Mũndũ-wa-nja o wothe warĩ mũũgĩ wĩra-inĩ wa kuogotha ndigi na moko make, akĩrehe kĩrĩa ogothete, ndigi cia rangi wa bururu, kana cia rangi wa ndathi, kana cia rangi mũtune ta gakarakũ, kana gatani ĩrĩa njega. ");
INSERT INTO kik_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Nao andũ-a-nja othe arĩa meyendeire na nĩ maarĩ na ũũgĩ ũcio, nĩmoogothire ndigi cia guoya wa mbũri. ");
INSERT INTO kik_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Atongoria marehire tũhiga twa onigithi na tũhiga tũngĩ twa goro tũtumĩrĩrwo nguo-inĩ ya ebodi na gakuo ga gĩthũri. ");
INSERT INTO kik_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Nĩmacookire makĩrehe mahuti manungi wega, na maguta ma mĩtamaiyũ ma gwakia tawa, na maguta ma gũitanĩrĩrio o na ma gũthondeka ũbumba ũrĩa mũnungi wega. ");
INSERT INTO kik_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Andũ a Isiraeli othe, arũme na andũ-a-nja arĩa meyendeire, nĩmareheire Jehova maruta ma kwĩyendera nĩ ũndũ wa wĩra ũrĩa Jehova aamaathĩte na kanua ka Musa marute. ");
INSERT INTO kik_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ningĩ Musa akĩĩra andũ a Isiraeli atĩrĩ, “Onei, Jehova nĩathuurĩte Bezaleli mũrũ wa Uri ũrĩa mũriũ wa Huri, wa mũhĩrĩga wa Juda, ");
INSERT INTO kik_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","na nĩamũiyũrĩtie na Roho wa Ngai, na ũũgĩ, na ũhoti, na ũmenyo wa mawĩra mothe ma ũbundi ");
INSERT INTO kik_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","nĩgeetha athugunde mĩcoro ya ũũgĩ ya indo-inĩ cia thahabu, na betha, na gĩcango, ");
INSERT INTO kik_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","na gwacũhia tũhiga twa goro twa gũthecererwo indo-inĩ, na kũruta wĩra wa gũkaaya mbaũ, na kũruta mawĩra ma mĩcoro ma mĩthemba yothe ya ũbundi. ");
INSERT INTO kik_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Na eerĩ, we marĩ na Oholiabu mũrũ wa Ahisamaku wa mũhĩrĩga wa Dani, nĩamaheete ũhoti wa kũruta andũ arĩa angĩ. ");
INSERT INTO kik_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Nĩamaiyũrĩtie na ũũgĩ wa kũruta mawĩra mothe, marĩ mabundi, na acori, na agemia na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa njega, o na atumi: othe marĩ mabundi moogĩ, na acori oogĩ. ");
INSERT INTO kik_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Nĩ ũndũ ũcio Bezaleli, na Oholiabu, na mũndũ o wothe warĩ mũũgĩ na wĩra, arĩa Jehova aheete ũũgĩ na ũhoti wa kũmenya kũruta wĩra ũcio wothe wa gwaka handũ-harĩa-haamũre, makĩruta wĩra ũcio o ta ũrĩa Mwathani aathanĩte ũrutwo.” ");
INSERT INTO kik_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ningĩ Musa agĩĩta Bezaleli na Oholiabu na mũndũ o wothe warĩ mũũgĩ, ũrĩa Jehova aheete ũhoti, na ũrĩa warĩ na wendo wa gũũka kũruta wĩra ũcio. ");
INSERT INTO kik_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Nao makĩamũkĩra kuuma kũrĩ Musa maruta mothe marĩa andũ a Isiraeli maarehete ma kũruta wĩra wa gwaka handũ-harĩa-haamũre. Nao andũ magĩthiĩ o na mbere kũrehe maruta ma kwĩyendera rũciinĩ o rũciinĩ. ");
INSERT INTO kik_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Nĩ ũndũ ũcio mabundi mothe marĩa maarĩ na ũũgĩ, arĩa maarutaga wĩra wothe wa gwaka handũ-harĩa-haamũre, makĩamba gũtiga wĩra wao, ");
INSERT INTO kik_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","na makĩĩra Musa atĩrĩ, “Andũ nĩmararehe indo makĩria ya iria ibatarainie wĩra-inĩ ũrĩa Jehova aathanĩte ũrutwo.” ");
INSERT INTO kik_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Nake Musa akĩruta watho, nao magĩtwara ũhoro ũcio kambĩ-inĩ guothe: “Gũtirĩ mũndũ mũrũme kana mũndũ-wa-nja ũgũcooka kũrehe iruta rĩngĩ nĩ ũndũ wa handũ-harĩa-haamũre.” Nĩ ũndũ ũcio andũ makĩrigĩrĩrio gũcooka kũrehe indo ingĩ, ");
INSERT INTO kik_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","tondũ indo iria maarĩ nacio ciarĩ nyingĩ makĩria ma iria ciabatarainie kũruta wĩra ũcio wothe. ");
INSERT INTO kik_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Andũ othe arĩa maarĩ oogĩ thĩinĩ wa aruti a wĩra magĩthondeka hema nyamũre na itambaya ikũmi cia gũcuurio itumĩtwo na gatani yogothetwo wega na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na ikĩgemio na makerubi nĩ mũtumi mũũgĩ wa wĩra ũcio. ");
INSERT INTO kik_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Itambaya ciothe cia gũcuurio nĩciaiganaine, ciarĩ cia mĩkono mĩrongo ĩĩrĩ na ĩnana kũraiha, na mĩkono ĩna kwarama. ");
INSERT INTO kik_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Makĩnyiitithania itambaya ithano hamwe, na magĩĩka o ro ũguo na icio ingĩ ithano. ");
INSERT INTO kik_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ningĩ magĩkundĩka ciana cia gĩtambaya kĩa rangi wa bururu mũthia-inĩ wa gĩtambaya gĩa gũcuurio kĩrĩa kĩrĩ mũico-inĩ wa mwena ũmwe, na magĩĩka o ro ũguo harĩ gĩtambaya gĩa gũcuurio kĩa mũico kĩa mwena ũcio ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Magĩcooka magĩkundĩka ciana ingĩ mĩrongo ĩtano gĩtambaya-inĩ kĩmwe gĩa gũcuurio kĩa mwena ũmwe, na ingĩ mĩrongo ĩtano gĩtambaya-inĩ gĩa gũcuurio kĩa mũico kĩa mwena ũcio ũngĩ, o kĩana kĩringaine na kĩrĩa kĩngĩ. ");
INSERT INTO kik_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ningĩ magĩthondeka ngathĩka mĩrongo ĩtano cia thahabu na magĩcihũthĩra kũohithania itambaya icio cia gũcuurio cia mĩena yeerĩ, nĩ ũndũ ũcio hema ĩyo nyamũre ĩgĩtuĩka kĩndũ kĩmwe. ");
INSERT INTO kik_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ningĩ magĩtuma itambaya cia gũcuurio ikũmi na kĩmwe cia guoya wa mbũri igĩtuĩka cia kũhumbĩra hema ĩrĩa nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Itambaya icio ciothe cia gũcuurio ikũmi na kĩmwe nĩciaiganaine; ciarĩ cia mĩkono mĩrongo ĩtatũ kũraiha, na mĩkono ĩna kwarama. ");
INSERT INTO kik_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Magĩtumithania itambaya ithano cia gũcuurio igĩtuĩka kĩndũ kĩmwe, na cio icio ingĩ ithathatũ igĩtumithanio hamwe. ");
INSERT INTO kik_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ningĩ magĩkundĩka ciana mĩrongo ĩtano mũthia-inĩ wa gĩtambaya gĩa gũcuurio kĩa mũico kĩa mwena ũmwe, na magĩĩka o ũguo mũthia-inĩ wa gĩtambaya gĩa gũcuurio kĩa mũico kĩa mwena ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ningĩ magĩthondeka ngathĩka mĩrongo ĩtano cia gĩcango cia kuohania hema ĩtuĩke kĩndũ kĩmwe. ");
INSERT INTO kik_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Magĩcooka magĩthondekera hema kĩhumbĩri kĩa njũa cia ndũrũme itoboketio rangi-inĩ mũtune igatunĩha, na igũrũ wakĩo hakĩhumbĩrwo na njũa cia pomboo. ");
INSERT INTO kik_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ningĩ magĩthondeka buremu cia kũmĩrũgamia cia mbaũ cia mũtĩ wa mũgaa nĩ ũndũ wa hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","O buremu yarĩ ya mĩkono ikũmi kũraiha, na mũkono ũmwe na nuthu kwarama, ");
INSERT INTO kik_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","natuo tũhocio tũgĩcomoka tũigananĩirie. Maathondekire buremu ciothe cia hema ĩyo nyamũre na njĩra ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ningĩ magĩthondeka buremu mĩrongo ĩĩrĩ cia mwena wa gũthini wa hema ĩyo nyamũre, ");
INSERT INTO kik_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","na magĩthondeka itina mĩrongo ĩna cia betha cia gwĩkĩrwo rungu rwacio; o itina igĩrĩ ikanyiitĩrĩra buremu ĩmwe, rungu rwa kahocio kamwe. ");
INSERT INTO kik_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Cia mwena ũcio ũngĩ, mwena wa gathigathini wa hema ĩyo nyamũre, magĩthondeka buremu mĩrongo ĩĩrĩ ");
INSERT INTO kik_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","na itina mĩrongo ĩna cia betha, o igĩrĩ igaikarĩrwo nĩ buremu ĩmwe. ");
INSERT INTO kik_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ningĩ magĩthondeka buremu ithathatũ cia mwena wa na thuutha, nĩguo mwena wa mũthia wa ithũĩro wa hema ĩyo nyamũre, ");
INSERT INTO kik_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","na buremu igĩrĩ igĩthondekwo nĩ ũndũ wa tũkoine-inĩ twa hema ĩyo nyamũre cia mwena wa na thuutha. ");
INSERT INTO kik_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Koine-inĩ ici cierĩ, buremu ciarĩ igĩrĩ igĩrĩ, kuuma thĩ nginya igũrũ, ikoohanio na mũrĩnga ũmwe; nacio cierĩ igakorwo ihaanaine. ");
INSERT INTO kik_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nĩ ũndũ ũcio haarĩ na buremu inyanya na itina ikũmi na ithathatũ cia betha; o igĩrĩ igaikarĩrwo nĩ buremu ĩmwe. ");
INSERT INTO kik_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Magĩcooka magĩthondeka mĩgamba ya mbaũ cia mũgaa: ĩtano yayo nĩ ũndũ wa buremu cia mwena ũmwe wa hema ĩyo nyamũre, ");
INSERT INTO kik_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","na ĩtano nĩ ũndũ wa buremu cia mwena ũcio ũngĩ, na ĩtano nĩ ũndũ wa buremu cia mwena wa ithũĩro, mũthia-inĩ wa na thuutha wa hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Maathondekire mũgamba wa gatagatĩ uumĩte mũthia ũmwe nginya ũrĩa ũngĩ hau gatagatĩ ga buremu icio. ");
INSERT INTO kik_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Nĩmagemirie buremu icio na thahabu, na magĩthondeka mĩrĩnga ya thahabu ya kũnyiitĩrĩra mĩgamba ĩyo. Magĩcooka makĩgemia mĩgamba ĩyo na thahabu. ");
INSERT INTO kik_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Nĩmatumire gĩtambaya gĩa gũcuurio kĩa ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa njogothe wega, na gĩkĩgemio na makerubi nĩ mũbundi mũũgĩ. ");
INSERT INTO kik_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Makĩmĩthondekera itugĩ inya cia mbaũ cia mĩgaa na magĩcigemia na thahabu. Magĩcooka magĩthondeka tũcuurio twa thahabu, na magĩtwekia itina inya ciacio cia betha. ");
INSERT INTO kik_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Itoonyero-inĩ rĩa hema makĩrĩthondekera gĩtambaya gĩa gũcuurio kĩa ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa njogothe wega, nakĩo kĩagemetio nĩ mũgemia mũũgĩ; ");
INSERT INTO kik_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","na magĩthondeka itugĩ ithano irĩ na tũcuurio twacio. Makĩgemia itugĩ icio na igũrũ na mĩcibi yacio na thahabu, na magĩcithondekera itina ithano cia gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleli nĩathondekire ithandũkũ rĩa kĩrĩkanĩro rĩa mbaũ cia mũgaa, mũigana wa mĩkono ĩĩrĩ kũraiha, na mũkono ũmwe na nuthu kwarama, na mũkono ũmwe na nuthu kũraiha na igũrũ. ");
INSERT INTO kik_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Akĩrĩgemia na thahabu therie thĩinĩ na nja, na akĩrĩtiriha na mũcibi wa thahabu mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Nĩarĩtwekeirie icũhĩ inya cia thahabu na agĩciohania na magũrũ marĩo mana, o icũhĩ igĩrĩ mwena ũmwe na icũhĩ igĩrĩ mwena ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ningĩ agĩthondeka mĩtĩ mĩraaya ya mũgaa na akĩmĩgemia na thahabu. ");
INSERT INTO kik_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Agĩcooka agĩtoonyia mĩtĩ ĩyo mĩraaya mĩrĩnga-inĩ ĩyo yarĩ mĩena-inĩ ya ithandũkũ ĩrĩ ya kũrĩkuua. ");
INSERT INTO kik_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Nĩarĩthondekeire gĩtĩ gĩa tha gĩa thahabu, therie kĩa ũraihu wa mĩkono ĩrĩ na nuthu, na wariĩ wa mũkono ũmwe na nuthu. ");
INSERT INTO kik_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Agĩcooka agĩtura makerubi meerĩ ma thahabu akĩmekĩra mĩthia-inĩ ya gĩtĩ kĩu gĩa tha. ");
INSERT INTO kik_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Nĩathondekire ikerubi rĩmwe rĩikare mũthia-inĩ ũmwe na ikerubi rĩu rĩngĩ rĩikare mũthia-inĩ ũrĩa ũngĩ; mĩthia-inĩ ĩyo yeerĩ akĩmathondeka marĩ kĩndũ kĩmwe na gĩtĩ gĩa tha. ");
INSERT INTO kik_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Mathagu ma makerubi macio matambũrũkĩtio na igũrũ, magathiĩka gĩtĩ kĩu gĩa tha. Makerubi macio maathondeketwo maroranĩte, na marorete gĩtĩ kĩu gĩa tha. ");
INSERT INTO kik_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Nĩmathondekire metha ya mbaũ cia mũgaa, ũraihu wayo warĩ mĩkono ĩĩrĩ, na wariĩ wayo warĩ mũkono ũmwe, na kũraiha na igũrũ kwayo kwarĩ mũkono ũmwe na nuthu. ");
INSERT INTO kik_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ningĩ makĩmĩgemia na thahabu therie, na makĩmĩtiriha na mũcibi wa thahabu. ");
INSERT INTO kik_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Magĩcooka makĩmĩthondekera karũbaũ gaceke ka wariĩ wa rũhĩ, gagĩthiũrũrũkĩria metha ĩyo, na magĩgatiriha na mũcibi wa thahabu. ");
INSERT INTO kik_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Magĩtwekeria metha ĩyo mĩrĩnga ĩna ya thahabu, na makĩmĩoherera koine-inĩ inya ciayo, o harĩa magũrũ mayo mana maarĩ. ");
INSERT INTO kik_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Icũhĩ icio ciekĩrirwo hakuhĩ na mũcibi wa karũbaũ karĩa gaceke, nĩgeetha ĩnyiitagĩrĩre mĩtĩ ĩrĩa mĩraaya yahũthagĩrwo gũkuua metha ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mĩtĩ ĩyo mĩraaya ya gũkuua metha yarĩ ya mbaũ cia mũgaa, na ĩkagemio na thahabu. ");
INSERT INTO kik_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ningĩ magĩthondeka indo cia thahabu therie, cia kũigagĩrĩrwo metha, na nacio nĩ: thaani, na thaani nene, na mbakũri, na ndigithũ cia gũitaga iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Nĩmathondekire mũtĩ wa kũigĩrĩrwo matawa wa thahabu therie. Mũrũgamo waguo na gĩtina kĩaguo igĩturwo inyiitanĩte o hamwe na ikombe ciaguo na mahũa maguo, na tũkonyo twaguo; ciothe igĩkorwo irĩ kĩndũ kĩmwe naguo. ");
INSERT INTO kik_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mũtĩ ũcio warĩ na honge ithathatũ ciumĩte mĩena-inĩ ya mũrũgamo wa mũtĩ ũcio wa kũigĩrĩrwo matawa; ithatũ mwena ũmwe, na ithatũ mwena ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ikombe ithatũ ciaturĩtwo ihaana ta mahũa ma mũrothi, irĩ na tũkonyo na mahũa, igakorwo rũhonge-inĩ rũmwe, nacio ithatũ igakorwo rũhonge-inĩ rũu rũngĩ; honge icio ciothe ithathatũ ciahaanaga ũguo ciumĩte mũtĩ-inĩ ũcio wa kũigĩrĩrwo matawa. ");
INSERT INTO kik_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na mũtĩ-inĩ ũcio wa kũigĩrĩrwo matawa haarĩ na ikombe inya ciathondeketwo ihaana ta mahũa ma mũrothi, irĩ na tũkonyo na mahũa. ");
INSERT INTO kik_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Gakonyo kamwe kaarĩ rungu rwa honge igĩrĩ ciumĩte mũrũgamo-inĩ wa mũtĩ ũcio wa kũigĩrĩrwo matawa, nako gakonyo ga keerĩ kaarĩ rungu rwa honge cia keerĩ igĩrĩ, na gakonyo ga gatatũ kaarĩ rungu rwa honge cia gatatũ igĩrĩ; ciothe ciarĩ honge ithathatũ. ");
INSERT INTO kik_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Tũkonyo na honge ciarĩ kĩndũ kĩmwe na mũtĩ ũcio wa kũigĩrĩrwo matawa, iturĩtwo kuuma thahabu therie. ");
INSERT INTO kik_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Nĩmathondekire matawa mũgwanja maguo, o ũndũ ũmwe na magathĩ ma gũtinia ndaambĩ, na thaani cia mũrarĩ wa ndaambĩ, cia thahabu therie. ");
INSERT INTO kik_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Maahũthĩrire taranda ĩmwe ya thahabu therie gũthondeka mũtĩ ũcio wa kũigĩrĩrwo matawa na indo ciaguo ciothe. ");
INSERT INTO kik_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Nĩmathondekire kĩgongona gĩa gũcinĩra ũbumba na mbaũ cia mũgaa. Kĩaiganaine mĩena yothe, mũigana wa mũkono ũmwe kũraiha, na mũkono ũmwe kwarama, na mĩkono ĩĩrĩ kũraiha na igũrũ. Hĩa ciakĩo ciarĩ kĩndũ kĩmwe na kĩgongona. ");
INSERT INTO kik_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Magĩkĩgemia igũrũ na mĩena yothe o na hĩa ciakĩo na thahabu therie na magĩgĩtiriha na mũcibi wa thahabu ũgĩgĩthiũrũrũkĩria. ");
INSERT INTO kik_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Magĩthondeka mĩrĩnga ĩĩrĩ ya thahabu mũhuro wa mũcibi ũcio, ĩĩrĩ mwena ũmwe na ĩĩrĩ mwena ũrĩa ũngĩ. Mĩrĩnga ĩyo nĩyo yatoonyagio mĩtĩ ĩrĩa mĩraihu yatũmagĩrwo gũgĩkuua. ");
INSERT INTO kik_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Magĩcooka magĩthondeka mĩtĩ ĩngĩ mĩraaya ya mũgaa na makĩmĩgemia na thahabu. ");
INSERT INTO kik_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","O na ningĩ magĩthondeka maguta matheru ma gũitanĩrĩrio na ũbumba mũnungi wega ũrĩa mũtherie, wĩra wa mũthondeki mũũgĩ wa maguta. ");
INSERT INTO kik_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Nĩmakire kĩgongona kĩa iruta rĩa njino kĩa mbaũ cia mũgaa, kĩa mĩkono ĩtatũ kũraiha na igũrũ; kĩaiganaine mĩena yothe; mĩkono ĩtano kũraiha na mĩkono ĩtano kwarama. ");
INSERT INTO kik_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Nĩmathondekire hĩa inya, o rũmwe koine-inĩ ĩmwe ya kĩgongona, nĩ ũndũ ũcio hĩa icio na kĩgongona igĩtuĩka kĩndũ kĩmwe, na makĩgemia kĩgongona kĩu na gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Nĩmathondekire indo ciakĩo ciothe irĩ cia gĩcango; na nĩcio nyũngũ, na icakũri, na mbakũri cia wĩra wa kũminjaminjĩria, na njibe cia nyama, na ngĩo cia mwaki. ");
INSERT INTO kik_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Nĩmathondekire kĩrũtara gĩa kĩgongona gĩa gĩcango, gĩa kũigwo rungu rwa muoho wakĩo, rũkinye nuthu ya ũraihu wa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Magĩtwekia mĩrĩnga ya gĩcango ya kũnyiitĩrĩra mĩtĩ ĩrĩa mĩraaya ya koine inya cia kĩrũtara gĩa gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Magĩthondeka mĩtĩ mĩraaya ya mbaũ cia mũgaa na magĩcigemia na gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Magĩtoonyia itugĩ icio mĩrĩnga-inĩ nĩguo ikoragwo mĩena-inĩ ya kĩgongona nĩ ũndũ wa gũgĩkuua. Maagĩthondekire na mbaũ, kĩrĩ na ihoro thĩinĩ. ");
INSERT INTO kik_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Nĩmathondekire kĩraĩ gĩa gwĩthambĩra gĩa gĩcango na kĩgũrũ gĩakĩo gĩa gĩcango kuuma icicio-inĩ cia andũ-a-nja arĩa maarutaga wĩra itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Thuutha ũcio magĩthondeka nja ya hema ĩyo nyamũre. Mwena wa gũthini ũgĩĩkĩrwo ũrĩ wa mĩkono igana kũraiha, na warĩ na itambaya cia gũcuurio cia gatani yogothetwo wega. ");
INSERT INTO kik_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Itambaya icio ciarĩ na itugĩ mĩrongo ĩĩrĩ, na itina ciacio mĩrongo ĩĩrĩ cia gĩcango, na tũcuurio na tũmĩkwa twa betha, twĩkĩrĩtwo itugĩ-inĩ icio. ");
INSERT INTO kik_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Mwena wa gathigathini o naguo warĩ wa mĩkono igana kũraiha, na warĩ na itugĩ mĩrongo ĩĩrĩ na itina ciacio mĩrongo ĩĩrĩ cia gĩcango, na warĩ na tũcuurio na tũmĩkwa twa betha twĩkĩrĩtwo itugĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Mwena wa ithũĩro wa nja ĩyo warĩ wa mĩkono mĩrongo ĩtano kwarama na warĩ na itambaya cia gũcuurio, na itugĩ ikũmi na itina ikũmi na warĩ na tũcuurio na tũmĩkwa twa betha twĩkĩrĩtwo itugĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Mwena wa irathĩro o naguo warĩ wa mĩkono mĩrongo ĩtano kwarama. ");
INSERT INTO kik_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Itambaya cia gũcuurio ciarĩ cia ũraihu wa mĩkono ikũmi na ĩtano, na ciarĩ mwena ũmwe wa itoonyero rĩa nja ĩyo, irĩ na itugĩ ithatũ na itina ithatũ; ");
INSERT INTO kik_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","na itambaya cia gũcuurio ciarĩ cia ũraihu wa mĩkono ikũmi na ĩtano na ciarĩ mwena ũcio ũngĩ wa itoonyero, irĩ na itugĩ ithatũ na itina ithatũ. ");
INSERT INTO kik_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Itambaya ciothe cia gũcuurio iria ciathiũrũrũkĩirie nja ciarĩ cia gatani yogothetwo wega. ");
INSERT INTO kik_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Itina cia itugĩ icio ciarĩ cia gĩcango. Tũcuurio na tũmĩkwa tũrĩa twekĩrĩtwo itugĩ-inĩ twarĩ twa betha na igũrũ wacio ciagemetio na betha; Nĩ ũndũ ũcio itugĩ ciothe cia nja ĩyo ciarĩ na tũmĩkwa twa betha. ");
INSERT INTO kik_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Itambaya cia gũcuurio cia itoonyero rĩa nja ĩyo ciarĩ cia ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa njogothe wega; wĩra wa mũgemia mũũgĩ. Yarĩ ya mĩkono mĩrongo ĩĩrĩ kũraiha, na mĩkono ĩtano kũraiha na igũrũ, o ta ũrĩa itambaya cia gũcuurio cia nja ĩyo ciatariĩ. ");
INSERT INTO kik_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","na ĩgĩkorwo na itugĩ inya na itina inya cia gĩcango. Tũcuurio na tũmĩkwa twacio twarĩ twa betha, na igũrũ wacio ciagemetio na betha. ");
INSERT INTO kik_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Higĩ ciothe cia hema ĩyo nyamũre na cia nja ĩrĩa yamĩthiũrũrũkĩirie ciarĩ cia gĩcango. ");
INSERT INTO kik_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ũyũ nĩguo mũigana wa indo iria ciahũthĩrirwo gwaka hema ĩyo nyamũre, Hema-ĩrĩa-ya-Ũira, iria ciandĩkirwo nĩ Alawii o ta ũrĩa Musa aathanĩte matongoretio nĩ Ithamaru mũrũ wa Harũni ũrĩa mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(Bezaleli mũrũ wa Uri, ũrĩa warĩ mũrũ wa Huri, wa mũhĩrĩga wa Juda, nĩathondekire kĩrĩa gĩothe Jehova aathĩte Musa; ");
INSERT INTO kik_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","nake aarĩ hamwe na Oholiabu mũrũ wa Ahisamaku, wa mũhĩrĩga wa Dani, ũrĩa warĩ mũbundi na mũcori mũũgĩ, na wamenyete kũgemia na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa njega.) ");
INSERT INTO kik_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Mũigana wa thahabu yothe ĩrĩa yarutirwo kuuma kũrĩ iruta rĩa gũthũngũthio ĩrĩa yahũthĩrirwo kũruta wĩra wothe wa handũ-harĩa-haamũre, yarĩ taranda 29 na cekeri 730, kũringana na cekeri ya handũ-harĩa-haamũre. ");
INSERT INTO kik_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Betha ĩrĩa yarehirwo nĩ mũingĩ ũrĩa watarirwo hĩndĩ ya itarana yarĩ taranda 100 na cekeri 1,775, kũringana na cekeri ya handũ-harĩa-haamũre, ");
INSERT INTO kik_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","o mũndũ aarutĩte beka ĩmwe, nayo nĩ ũndũ ũmwe na nuthu ya cekeri, kũringana na cekeri ya handũ-harĩa-haamũre, nayo yarutirwo nĩ mũndũ o wothe wakĩraga agathiĩ harĩ arĩa maatarĩtwo, arĩa maarĩ na ũkũrũ wa mĩaka mĩrongo ĩĩrĩ na makĩria, nao othe maarĩ arũme 603,550. ");
INSERT INTO kik_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Taranda icio 100 cia betha ciahũthĩrirwo gũtwekia itina cia handũ-harĩa-haamũre na itina cia itambaya cia gũcuurio; taranda 100 igĩaka itina 100, ũguo nĩ ta kuuga taranda ĩmwe ĩgaaka gĩtina kĩmwe. ");
INSERT INTO kik_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Nĩmahũthĩrire cekeri icio 1,775 gũthondeka tũcuurio twa itugĩ, na kũgemia itugĩ na igũrũ, na gũthondeka tũmĩkwa twacio. ");
INSERT INTO kik_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Gĩcango kĩrĩa kĩarutĩtwo kuuma iruta rĩa gũthũngũthio kĩarĩ gĩa taranda 70 na cekeri 2,400. ");
INSERT INTO kik_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Maahũthĩrire gĩcango kĩu na gũthondeka itina cia itoonyero rĩa Hema-ya-Gũtũnganwo, na gwaka kĩgongona gĩa gĩcango hamwe na kĩrũtara gĩakĩo gĩa gĩcango na indo ciakĩo ciothe, ");
INSERT INTO kik_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","na gwaka itina cia nja ĩrĩa yamĩthiũrũrũkĩirie na itina iria cia itoonyero rĩayo, na higĩ ciothe cia hema ĩyo nyamũre, na higĩ cia nja ĩrĩa yamĩthiũrũrũkĩirie. ");
INSERT INTO kik_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nĩmatumire nguo na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, cia kũrutaga wĩra nacio handũ-harĩa-haamũre. Magĩcooka magĩtumĩra Harũni nguo theru, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nĩmatumire ebodi na ndigi cia rangi wa thahabu, na ndigi cia rangi wa bururu, na cia rangi wa ndathi na cia rangi mũtune ta gakarakũ, na cia gatani ĩrĩa yogothetwo wega. ");
INSERT INTO kik_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Nĩmahũũrire thahabu makĩmĩtua tũbaati tũhũthu, magĩtũtinangia nguucio cia gũtumanio na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa njega, wĩra wa mũbundi mũũgĩ. ");
INSERT INTO kik_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ningĩ nĩmatumire ndaamĩ cia ciande cia ebodi, nacio ikĩohererwo koine-inĩ igĩrĩ ciayo, nĩguo inyiitithanio nayo. ");
INSERT INTO kik_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Naguo mũcibi wayo wa njohero watumĩtwo wega ũkahaanana nayo, na warĩ o gĩcunjĩ kĩmwe na ebodi, na ũgathondekwo na ndigi cia rangi wa thahabu, na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa yogothetwo wega, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Nao magĩtumĩrĩra tũhiga twa onigithi tũkonyo-inĩ twa thahabu, na magĩtũkurura marĩĩtwa ma ariũ a Isiraeli, o ta ũrĩa mũndũ akururaga kahengere ka mũhũũri. ");
INSERT INTO kik_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Magĩcooka magĩtuoherera ndaamĩ-inĩ cia ciande cia ebodi tũrĩ twa kĩririkania kĩa ariũ a Isiraeli, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Magĩthondeka gakuo ga gwĩkĩrwo ga gĩthũri; karĩ wĩra wa mũbundi mũũgĩ. Magĩgathondeka o ta ebodi ĩyo: karĩ ga thahabu, na ka ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, na gatani ĩrĩa yogothetwo wega. ");
INSERT INTO kik_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Gakuo kau kaiganaine mĩena yothe ĩna, karĩ ka inji kenda kũraiha na inji kenda kwarama, na gakoinanĩrwo maita meerĩ. ");
INSERT INTO kik_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ningĩ magĩgatumĩrĩra mĩhari ĩna ya tũhiga twa goro. Mũhari wa mbere magĩtumĩrĩra kahiga ka wakiki ũrĩa mũtune, na ka yakuti ĩrĩa ĩhaana ngoikoni, na ka baregethu; ");
INSERT INTO kik_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","mũhari wa keerĩ magĩtumĩrĩra kahiga ga thumarati, na ka yakuti ĩrĩa ya rangi wa bururu, na ka arimathi; ");
INSERT INTO kik_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","mũhari wa gatatũ magĩtumĩrĩra kahiga ka wakiki ũrĩa wa bururu, na ka yacimu, na ka amethuthito; ");
INSERT INTO kik_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","mũhari wa kana magĩtumĩrĩra kahiga ga thumarati ĩrĩa theru, na ka onigithi, na ka njathibi. Natuo tũgĩtumĩrĩrwo tũkonyo-inĩ tũgemie twa thahabu. ");
INSERT INTO kik_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Tũgĩkorwo tũrĩ tũhiga ikũmi na twĩrĩ, o kamwe gakarũgamĩrĩra rĩmwe rĩa marĩĩtwa ma ariũ a Isiraeli, o kamwe gagakururwo rĩĩtwa rĩa mũhĩrĩga ũmwe wa ĩrĩa ikũmi na ĩĩrĩ ya Isiraeli, o ta ũrĩa kahengere ka mũhũũri gakururagwo. ");
INSERT INTO kik_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nĩmathondekeire gakuo kau ga gĩthũri mĩgathĩ ya thahabu therie, ĩhaana ta mũkanda. ");
INSERT INTO kik_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ningĩ magĩthondeka tũkonyo twĩrĩ tũgemie twa thahabu, na mĩrĩnga ĩĩrĩ ya thahabu, na makĩoherera mĩrĩnga ĩyo koine-inĩ igĩrĩ cia gakuo kau ga gĩthũri. ");
INSERT INTO kik_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Makĩnyiitithania mĩgathĩ ĩyo ĩĩrĩ ya thahabu na mĩrĩnga ĩrĩa yarĩ koine-inĩ cia gakuo kau ga gĩthũri, ");
INSERT INTO kik_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","na mĩthia ĩrĩa ĩngĩ ya mĩgathĩ makĩmĩnyiitithania na tũkonyo tũu twĩrĩ twarĩ tũgemie twa thahabu, magĩtuohania na ndaamĩ cia kĩande kĩa ebodi mwena wa mbere. ");
INSERT INTO kik_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Magĩthondeka mĩrĩnga ĩĩrĩ ya thahabu na makĩmĩnyiitithania na koine igĩrĩ cia gakuo ga gĩthũri mũico-inĩ wa na thĩinĩ, kũrigania na ebodi. ");
INSERT INTO kik_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Magĩcooka magĩthondeka mĩrĩnga ĩngĩ ĩĩrĩ ya thahabu na makĩmĩnyiitithania na mwena wa magũrũ-inĩ ma ndaamĩ cia kĩande mwena-inĩ wa mbere wa ebodi, hakuhĩ na rũtumo, igũrũ hanini wa mũcibi wa ebodi. ");
INSERT INTO kik_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Makĩohania mĩrĩnga ya gakuo ga gĩthũri kũrĩ mĩrĩnga ya ebodi na rũrigi rwa rangi wa bururu, magĩcinyiitithania na mũcibi wa njohero nĩgeetha gakuo ga gĩthũri gatikarekanie na ebodi, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Nĩmatumire nguo ndaaya ya ebodi ya taama wa bururu mũtheri, nayo yatumĩtwo nĩ mũtumi mũũgĩ. ");
INSERT INTO kik_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Yarĩ na harũkĩrio ya gũtoonyeria mũtwe gatagatĩ kayo, ningĩ ĩgĩtirihwo mĩthia-inĩ ta kara, nĩgeetha ndĩgatarũke. ");
INSERT INTO kik_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ningĩ magĩthondeka tũcunjuura tũtariĩ ta matunda ma makomamanga, twa ndigi cia rangi wa bururu, na twa ndigi cia rangi wa ndathi, na twa rangi mũtune ta gakarakũ, na gatani ĩrĩa yogothetwo wega, tũgĩthiũrũrũka rũtumo rwa magũrũ-inĩ ma nguo ĩyo ndaaya. ");
INSERT INTO kik_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Magĩcooka magĩthondeka ngengere cia thahabu therie magĩcitumĩrĩra rũtumo-inĩ rũu gatagatĩ ga tũcunjuura tũu tũhaana matunda ma makomamanga. ");
INSERT INTO kik_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ngengere na tũcunjuura tũu tũhaana matunda ma makomamanga igĩthiĩ ihakanĩtio gũthiũrũrũka rũtumo rwa nguo ĩyo ndaaya; ya kwĩhumbwo nĩ mũndũ agĩtungata, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Nĩmatumĩire Harũni na ariũ ake kanjũ cia gatani njega, itumĩtwo nĩ mũtumi mũũgĩ. ");
INSERT INTO kik_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Makĩmatumĩra iremba cia gatani njega, na tũkũbia twa gatani, na thuruarĩ cia thĩinĩ cia gatani ĩrĩa yogothetwo wega. ");
INSERT INTO kik_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Mũcibi warĩ wa gatani ĩrĩa njogothe wega na ndigi cia rangi wa bururu, na cia rangi wa ndathi, na cia rangi mũtune ta gakarakũ, wĩra wa mũgemia mũũgĩ, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Magĩthondeka gatanji kaamũre ga thahabu therie, na igũrũ rĩako magĩkurura, o ta ũrĩa mũhũũri ũkururagwo, ciugo ici: MŨTHERU MWAMŨRĨRE JEHOVA. ");
INSERT INTO kik_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ningĩ makĩoherera gatanji kau na rũrigi rwa rangi wa bururu, magĩkanyiitithania na kĩremba, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Nĩ ũndũ ũcio wĩra wothe wa gwaka hema ĩyo nyamũre na Hema-ya-Gũtũnganwo ũkĩrĩka. Andũ a Isiraeli magĩĩka maũndũ mothe o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ningĩ makĩrehe hema ĩyo nyamũre kũrĩ Musa: hema na indo ciayo ciothe na ngathĩka ciayo, na buremu, na mĩgamba, na itugĩ na itina ciayo; ");
INSERT INTO kik_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","na kĩhumbĩri kĩa njũa cia ndũrũme itoboketio rangi-inĩ mũtune, igatunĩha, na kĩhumbĩri kĩa njũa cia pomboo, na gĩtambaya gĩa gũcuurio gĩa kũhakania; ");
INSERT INTO kik_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ithandũkũ rĩa Ũira na mĩtĩ mĩraaya yarĩo, hamwe na gĩtĩ gĩa tha; ");
INSERT INTO kik_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","metha na indo ciayo ciothe, na mĩgate ya kũigwo Mbere ya Jehova; ");
INSERT INTO kik_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","mũtĩ wa thahabu therie wa kũigĩrĩrwo matawa, hamwe na mĩhari ya matawa na indo ciaguo ciothe, o na maguta ma kũmaakia; ");
INSERT INTO kik_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","kĩgongona gĩa thahabu, na maguta ma gũitanĩrĩrio, na ũbumba mũnungi wega, na gĩtambaya gĩa gũcuurio gĩa itoonyero-inĩ rĩa hema; ");
INSERT INTO kik_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kĩgongona gĩa gĩcango hamwe na kĩrũtara gĩakĩo gĩa gĩcango na itugĩ ciakĩo na indo ciakĩo ciothe; na kĩraĩ gĩa gwĩthambĩra na kĩgũrũ gĩakĩo; ");
INSERT INTO kik_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","itambaya cia gũcuurio cia nja, na itugĩ ciacio, na itina ciacio, na gĩtambaya gĩa gũcuurio gĩa itoonyero rĩa kuuma nja wa hema; na mĩkanda na higĩ cia nja; na indo ciothe cia hema ĩrĩa nyamũre, na Hema-ya-Gũtũnganwo; ");
INSERT INTO kik_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","na nguo ndume cia kwĩhumbwo nĩ mũndũ agĩtungata thĩinĩ wa handũ-harĩa-haamũre, nguo iria theru cia Harũni ũrĩa mũthĩnjĩri-Ngai, o na cia ariũ ake cia kwĩhumba rĩrĩa mekũruta wĩra wa mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Andũ a Isiraeli maarutire wĩra wothe o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa akĩona wĩra ũrĩa warutĩtwo nake akĩona atĩ nĩmaũrutĩte o ta ũrĩa Jehova aathanĩte. Nĩ ũndũ ũcio Musa akĩmarathima. ");
INSERT INTO kik_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ũgaaka hema ĩyo nyamũre, nĩo Hema-ya-Gũtũnganwo, mũthenya wa mbere wa mweri wa mbere. ");
INSERT INTO kik_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Nĩũkaiga ithandũkũ rĩa Ũira thĩinĩ wayo, na ũhakanie ithandũkũ rĩu na gĩtambaya gĩa gũcuurio. ");
INSERT INTO kik_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ningĩ nĩũgatoonyia metha na ũmĩigĩrĩre indo ciayo, na ũcibange wega. Ningĩ ũtoonyie mũtĩ wa tawa, na ũũigĩrĩre matawa maguo. ");
INSERT INTO kik_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ningĩ ũige kĩgongona gĩa thahabu gĩa gũcinĩrwo ũbumba mbere ya Ithandũkũ rĩu rĩa Ũira, na wĩkĩre gĩtambaya gĩa gũcuurio itoonyero-inĩ rĩa hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Iga kĩgongona kĩa maruta ma njino mbere ya itoonyero rĩa hema ĩyo nyamũre, na nĩyo Hema-ya-Gũtũnganwo; ");
INSERT INTO kik_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ũige kĩraĩ gĩa gwĩthambĩrwo gatagatĩ ka Hema-ya-Gũtũnganwo na kĩgongona, na ũgĩĩkĩre maaĩ. ");
INSERT INTO kik_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Aka nja ĩmĩthiũrũrũkĩrie, na wĩkĩre gĩtambaya gĩa gũcuurio itoonyero-inĩ rĩa nja ĩyo. ");
INSERT INTO kik_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Oya maguta ma gũitanĩrĩrio, na ũitĩrĩrie hema ĩyo nyamũre na kĩrĩa gĩothe kĩrĩ thĩinĩ wayo; mĩamũre na indo ciayo ciothe, na nĩĩgatuĩka theru. ");
INSERT INTO kik_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ningĩ ũitĩrĩrie maguta kĩgongona kĩa maruta ma njino na indo ciakĩo ciothe; wamũre kĩgongona kĩu, nakĩo nĩgĩgatuĩka gĩtheru mũno. ");
INSERT INTO kik_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Itĩrĩria kĩraĩ gĩa gwĩthambĩrwo na kĩgũrũ gĩakĩo maguta, ũciamũre. ");
INSERT INTO kik_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Rehe Harũni na ariũ ake itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, na ũmathambie na maaĩ. ");
INSERT INTO kik_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ningĩ ũhumbe Harũni nguo iria theru, ũmũitĩrĩrie maguta, na ũmwamũre nĩguo andungatĩre arĩ mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Rehe ariũ ake, ũmahumbe kanjũ. ");
INSERT INTO kik_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Maitĩrĩrie maguta o ta ũrĩa ũitĩrĩirie ithe wao, nĩguo mandungatĩre marĩ athĩnjĩri-Ngai. Gũitĩrĩrio maguta kwao nĩkũmatoonyia ũtungata-inĩ wa ũthĩnjĩri-Ngai ũrĩa ũgũtũũra njiarwa-inĩ ciothe iria igooka.” ");
INSERT INTO kik_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Nake Musa agĩĩka maũndũ mothe o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Nĩ ũndũ ũcio hema ĩyo nyamũre ĩgĩakwo mũthenya wa mbere wa mweri wa mbere, mwaka-inĩ wa keerĩ. ");
INSERT INTO kik_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Rĩrĩa Musa aakire hema ĩyo nyamũre, nĩaigire itina handũ ha cio, na akĩrũgamia buremu, agĩtoonyia mĩgamba na akĩrũgamia itugĩ. ");
INSERT INTO kik_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ningĩ agĩtambũrũkia hema igũrũ rĩa hema ĩyo nyamũre na akĩigĩrĩra kĩhumbĩri igũrũ rĩa hema o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Agĩcooka akĩoya ihengere cia Ũira, na agĩciiga thĩinĩ wa ithandũkũ rĩa kĩrĩkanĩro. Akĩnyiitithania mĩtĩ ĩrĩa mĩraaya na ithandũkũ, na akĩiga gĩtĩ gĩa tha igũrũ rĩa ithandũkũ rĩu. ");
INSERT INTO kik_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ningĩ akĩrehe ithandũkũ rĩa kĩrĩkanĩro thĩinĩ wa hema ĩyo nyamũre, na agĩĩkĩra gĩtambaya gĩa kũhakania na akĩhakania ithandũkũ rĩa Ũira o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Musa akĩiga metha thĩinĩ wa Hema-ya-Gũtũnganwo mwena wa gathigathini wa hema ĩyo nyamũre, nja ya gĩtambaya gĩa gũcuurio ");
INSERT INTO kik_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","na akĩigĩrĩra mĩgate igũrũ rĩayo o hau mbere ya Jehova, o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Akĩiga mũtĩ wa kũigĩrĩrwo matawa thĩinĩ wa Hema-ya-Gũtũnganwo ũngʼetheire metha mwena wa gũthini wa hema ĩyo nyamũre, ");
INSERT INTO kik_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","na agĩakia matawa macio mbere ya Jehova, o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Musa agĩtoonyia kĩgongona gĩa thahabu thĩinĩ wa Hema-ya-Gũtũnganwo hau mbere ya gĩtambaya gĩa gũcuurio, ");
INSERT INTO kik_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","na agĩcinĩra ũbumba ũrĩa mũnungi wega ho o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ningĩ agĩcuuria gĩtambaya itoonyero-inĩ rĩa hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ningĩ akĩiga kĩgongona kĩa maruta ma njino hakuhĩ na itoonyero rĩa hema ĩyo nyamũre, nĩyo Hema-ya-Gũtũnganwo, na akĩrutĩra magongona ma njino igũrũ rĩakĩo o na magongona ma ngano, o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Nĩaigire kĩraĩ gĩa gwĩthambĩrwo gatagatĩ ka Hema-ya-Gũtũnganwo na kĩgongona na agĩgĩĩkĩra maaĩ ma gwĩthamba, ");
INSERT INTO kik_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","nake Musa na Harũni na ariũ ake magĩtũmĩra maaĩ macio gwĩthamba moko na magũrũ. ");
INSERT INTO kik_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Nĩmethambaga hĩndĩ ciothe magĩtoonya Hema-ya-Gũtũnganwo kana magĩkuhĩrĩria kĩgongona o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ningĩ Musa agĩaka nja gũthiũrũrũka hema ĩyo nyamũre na kĩgongona na agĩĩkĩra gĩtambaya gĩa gũcuurio itoonyero rĩa nja ĩyo. Na nĩ ũndũ ũcio Musa akĩrĩkia wĩra ũcio. ");
INSERT INTO kik_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Hĩndĩ ĩyo itu rĩkĩhumbĩra Hema-ya-Gũtũnganwo, naguo riiri wa Jehova ũkĩiyũra hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa ndangĩahotire gũtoonya Hema-ya-Gũtũnganwo tondũ itu rĩaikarĩte igũrũ rĩayo, naguo riiri wa Jehova ũkaiyũra hema ĩyo nyamũre. ");
INSERT INTO kik_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ngʼendo-inĩ ciothe cia andũ a Isiraeli-rĩ, hĩndĩ ĩrĩa yothe itu rĩoyagwo na igũrũ kuuma hema ĩyo nyamũre, nĩguo moimagaraga; ");
INSERT INTO kik_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","no itu rĩĩaga kuoywo na igũrũ, nao makaaga kuumagara, nginya mũthenya ũrĩa rĩkoywo na igũrũ. ");
INSERT INTO kik_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Nĩ ũndũ ũcio itu rĩa Jehova rĩaikaraga igũrũ wa hema ĩyo nyamũre mũthenya, naguo mwaki wakoragwo itu-inĩ rĩu ũtukũ, rĩgakĩonagwo nĩ nyũmba yothe ya Isiraeli mahinda mothe ngʼendo-inĩ ciao ciothe.");
INSERT INTO kik_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Nake Jehova agĩĩta Musa akĩmwarĩria arĩ Hema-inĩ-ya-Gũtũnganwo, akĩmwĩra atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Rĩrĩa mũndũ wanyu o na ũrĩkũ arĩĩrutagĩra Jehova iruta, nĩarehage maruta ma nyamũ kuuma rũũru-inĩ rwa ngʼombe o na kana rwa mbũri. ");
INSERT INTO kik_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Angĩkorwo iruta rĩu nĩ iruta rĩa njino kuuma rũũru-inĩ rwa ngʼombe-rĩ, nĩarutage nyamũ ya njamba ĩtarĩ na kaũũgũ. No nginya amĩneane mũromo-inĩ wa Hema-ya-Gũtũnganwo nĩgeetha etĩkĩrĩke harĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Mũndũ ũcio akaigĩrĩra guoko gwake igũrũ rĩa mũtwe wa nyamũ ĩyo ya iruta rĩa njino, nayo nĩĩgetĩkĩrwo handũ-inĩ hake, ĩtuĩke ya kũmũhoroheria. ");
INSERT INTO kik_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Nake nĩagethĩnjĩra gategwa kau arĩ mbere ya Jehova, nao ariũ a Harũni arĩa athĩnjĩri-Ngai moe na marehe thakame yako, mamĩminjaminjĩrie kĩgongona mĩena yothe mũromo-inĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Nĩakaruta nyamũ ĩyo ya iruta rĩa njino rũũa na amĩtinangie tũcunjĩ. ");
INSERT INTO kik_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ariũ a Harũni ũcio mũthĩnjĩri-Ngai nĩmagaakia mwaki igũrũ rĩa kĩgongona na maare ngũ igũrũ rĩa mwaki ũcio. ");
INSERT INTO kik_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ningĩ ariũ a Harũni, acio athĩnjĩri-Ngai, matandaiye tũcunjĩ tũu twa gategwa, o ro hamwe na mũtwe na maguta, igũrũ rĩa ngũ icio irakanĩra hau kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ningĩ no nginya athambie nyama cia nda na mathagiro na maaĩ nake mũthĩnjĩri-Ngai acicinĩre ciothe hau kĩgongona-inĩ. Nĩ iruta rĩa njino, iruta rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Angĩkorwo iruta rĩu rĩa njino nĩ kuuma rũũru-inĩ, rĩrĩ iruta rĩa ngʼondu kana rĩa mbũri, akaaruta nyamũ ya njamba ĩtarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Nake akaamĩthĩnja arĩ mbere ya Jehova, hau mwena wa gathigathini wa kĩgongona, nao ariũ a Harũni, acio athĩnjĩri-Ngai, moe thakame yayo, mamĩminjaminjĩrie kĩgongona kĩu mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Nĩagatinangia nyamũ ĩyo tũcunjĩ, nake mũthĩnjĩri-Ngai atandaiye tũcunjĩ tũu twa nyamũ ĩyo, o ro hamwe na mũtwe na maguta, igũrũ rĩa ngũ icio irakanĩra hau kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ningĩ no nginya athambie nyama cia nda na mathagiro na maaĩ, nake mũthĩnjĩri-Ngai amĩrehe yothe na amĩcinĩre hau kĩgongona-inĩ. Nĩ iruta rĩa njino, iruta rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Angĩkorwo iruta rĩu rĩa njino rĩa kũrutĩra Jehova nĩ rĩa nyoni-rĩ, akaaruta ndirahũgĩ, kana kĩana kĩa ndutura. ");
INSERT INTO kik_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Nake mũthĩnjĩri-Ngai nĩakamĩrehe kĩgongona-inĩ, amĩthiore ngingo ĩtinĩke mũtwe, amĩcinĩre kĩgongona igũrũ; nayo thakame yayo ĩitwo hau mwena-inĩ wa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","No ambe arute kabutu kayo hamwe na kĩrĩa gĩothe kĩrĩ thĩinĩ wako, agaikie mwena-inĩ wa irathĩro wa kĩgongona, harĩa mũhu ũitagwo. ");
INSERT INTO kik_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Nĩakamĩatũrania, na ũndũ wa kũguucia mathagu atekũmĩtinania biũ, nake mũthĩnjĩri-Ngai amĩcinĩre igũrũ rĩa ngũ icio irakanĩra igũrũ rĩa kĩgongona. Nĩ iruta rĩa njino, rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Hĩndĩ ĩrĩa mũndũ arĩrehagĩra Jehova iruta rĩa ngano-rĩ, iruta rĩake no nginya rĩkorwo rĩrĩ rĩa mũtu ũrĩa mũhinyu mũno. Nĩaũitĩrĩrie maguta na awĩkĩre ũbani, ");
INSERT INTO kik_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","acooke aũtwarĩre ariũ a Harũni acio athĩnjĩri-Ngai. Mũthĩnjĩri-Ngai nĩakarũma ngundi ya mũtu ũcio mũhinyu mũno ũrĩ na maguta hamwe na ũbani ũcio wothe, na aũcinĩre igũrũ rĩa kĩgongona ũtuĩke gĩcunjĩ gĩa kĩririkano, ũrĩ iruta rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Mũtu ũrĩa ũrĩtigaraga wa iruta rĩu rĩa mũtu nĩ wa Harũni na ariũ ake; nĩ gĩcunjĩ gĩtheru mũno kĩa iruta rĩrĩa rĩrutĩirwo Jehova na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Mũngĩrehe iruta rĩa mũtu rĩhĩhĩirio riiko, nĩrĩkorwo rĩrĩ rĩa mũtu mũhinyu mũno, keki irugĩtwo itarĩ na ndawa ya kũimbia, itukanĩtio na maguta, kana tũmĩgate tũhũthũ tũtarĩ na ndawa ya kũimbia tũhakĩtwo maguta. ");
INSERT INTO kik_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Angĩkorwo iruta rĩanyu rĩa mũtu nĩ mũgate ũkarangĩirwo igũrũ wa rũgĩo-rĩ, no nginya ũthondekwo na mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, na ũtarĩ na ndawa ya kũimbia. ");
INSERT INTO kik_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ũwenyũrange cienyũ, ũũitĩrĩrie maguta; rĩu nĩ iruta rĩa mũtu. ");
INSERT INTO kik_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Igongona rĩanyu rĩa mũtu rĩngĩgakorwo nĩ mũgate ũkarangĩirwo igũrũ rĩa rũgĩo-rĩ, igongona rĩu nĩrĩthondekwo na mũtu ũrĩa mũhinyu mũno na maguta. ");
INSERT INTO kik_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Reherai Jehova iruta rĩa mũtu rĩthondeketwo na indo icio; rĩneanwo kũrĩ mũthĩnjĩri-Ngai, nake arĩtware kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Mũthĩnjĩri-Ngai nĩakaruta gĩcunjĩ gĩa kĩririkano kuuma iruta rĩu rĩa mũtu na arĩcinĩre igũrũ rĩa kĩgongona kĩu, rĩrĩ iruta rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Mũtu ũrĩa ũrĩtigaraga wa iruta rĩu rĩa mũtu nĩ wa Harũni na ariũ ake; nĩ gĩcunjĩ gĩtheru mũno kĩa iruta rĩrĩa rĩrutĩirwo Jehova na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Iruta o rĩothe rĩa mũtu rĩrĩa mũrĩrehagĩra Jehova no nginya rĩthondekagwo rĩtarĩ na ndawa ya kũimbia, nĩgũkorwo mũtigaacina ndawa ya kũimbia kana ũũkĩ mũkĩrutĩra Jehova iruta rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Indo icio no mũcirutĩre Jehova irĩ iruta rĩa maciaro ma mbere, no itikarutwo kĩgongona-inĩ irĩ ta mũtararĩko mwega. ");
INSERT INTO kik_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Nĩ mũgekĩraga cumbĩ maruta-inĩ manyu mothe ma mũtu. Mũtikanaage gwĩkĩra cumbĩ wa kĩrĩkanĩro kĩa Ngai wanyu maruta-inĩ manyu ma mũtu; ĩkĩragai cumbĩ maruta-inĩ manyu mothe. ");
INSERT INTO kik_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Mũngĩkarehere Jehova iruta rĩa mũtu rĩa maciaro ma mbere-rĩ, heanai mũtu wa ngano ya mũgethano ĩrĩ hĩhie na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Na mwĩkĩre maguta na ũbani igũrũ rĩayo; rĩu nĩ iruta rĩa mũtu. ");
INSERT INTO kik_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Mũthĩnjĩri-Ngai nĩagacina gĩcunjĩ gĩa kĩririkano kĩa ngano thĩye ĩrĩ na maguta hamwe na ũbani wothe, rĩrĩ iruta rĩrutĩirwo Jehova na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Iruta rĩa mũndũ rĩngĩkorwo nĩ iruta rĩa ũiguano-rĩ, nake arute nyamũ rũũru-inĩ rwa ngʼombe, ĩrĩ ya njamba kana ya nga, nĩakĩnengere Jehova nyamũ ĩtarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Mũndũ ũcio nĩaigĩrĩre guoko gwake igũrũ rĩa mũtwe wa nyamũ ĩyo ya iruta rĩake, na acooke amĩthĩnjĩre hau mũromo-inĩ wa Hema-ya-Gũtũnganwo. Nao ariũ a Harũni, athĩnjĩri-Ngai, nĩmakaminjaminjĩria kĩgongona thakame yayo mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Kuuma iruta-inĩ rĩu rĩa ũiguano, nĩakarutĩra Jehova nyama imwe cia gũcinwo na mwaki: nacio nĩ rũambũ rũrĩa ruothe rũhumbĩire nyama cia nda na rũrĩa rũnyiitaine nacio, ");
INSERT INTO kik_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","higo cierĩ hamwe na maguta marĩa macihumbĩire hakuhĩ na honge, na maguta marĩa mahumbĩire ini, amarutanĩrie na higo icio. ");
INSERT INTO kik_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Nao ariũ a Harũni macicinĩre kĩgongona-inĩ igũrũ, ciigĩrĩirwo igũrũ rĩa iruta rĩu rĩa njino rĩrĩa narĩo rĩigĩrĩirwo igũrũ rĩa ngũ irakana, rĩrĩ iruta rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Mũndũ angĩkaaruta nyamũ rũũru-inĩ rwa mbũri, ĩrĩ ya kũrutĩra Jehova iruta rĩa ũiguano, nĩakaruta ndũrũme kana mwatĩ itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Angĩkaaruta gatũrũme-rĩ, nĩagakaneana mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Nĩakaigĩrĩra guoko gwake igũrũ rĩa mũtwe wa nyamũ ĩyo ya iruta rĩake, na acooke amĩthĩnjĩre mbere ya Hema-ya-Gũtũnganwo. Nao ariũ a Harũni moe thakame yako mamĩminjaminjĩrie kĩgongona kĩu mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kuuma harĩ iruta rĩu rĩa ũiguano, nĩakarutĩra Jehova nyama imwe cia gũcinwo na mwaki: nacio nĩ maguta mako, na mũtingʼoe wothe ũrĩa mũnoru ũtinĩirio gĩtina-inĩ kĩa rũcuthĩ, na maguta ma rũambũ mothe marĩa mahumbĩire nyama cia nda, na marĩa manyiitaine nacio, ");
INSERT INTO kik_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","higo cierĩ hamwe na maguta marĩa macihumbĩire hakuhĩ na honge, na marĩa mahumbĩire ini, amarutanĩrie na higo icio. ");
INSERT INTO kik_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Nake mũthĩnjĩri-Ngai nĩagacicinĩra kĩgongona-inĩ irĩ irio, rĩĩrĩ nĩ iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Na angĩkorwo iruta rĩake nĩ mbũri, nĩamĩneane mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Nĩaigĩrĩre guoko gwake igũrũ rĩa mũtwe wayo, na acooke amĩthĩnjĩre mbere ya Hema-ya-Gũtũnganwo. Nao ariũ a Harũni moe thakame yayo, mamĩminjaminjĩrie kĩgongona mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kuuma harĩ kĩrĩa akaaheana, nĩakarutĩra Jehova iruta rĩa gũcinwo na mwaki: na nĩ maguta mothe ma rũambũ marĩa mahumbĩrĩte nyama ciothe cia nda na marĩa manyiitaine nacio, ");
INSERT INTO kik_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","higo cierĩ na maguta marĩa macihumbĩire hakuhĩ na honge, na maguta marĩa mahumbĩire ini, amarutanĩrie na higo icio. ");
INSERT INTO kik_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Nake mũthĩnjĩri-Ngai nĩagacicinĩra kĩgongona-inĩ irĩ irio, rĩĩrĩ nĩ iruta rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega. Maguta mothe nĩ ma Jehova. ");
INSERT INTO kik_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Ũndũ ũyũ ũgaatuĩka watho wa gũtũũra ũrũmagĩrĩrwo nĩ njiaro iria igooka, kũrĩa guothe mũgaatũũra: Mũtikanarĩe maguta kana thakame.’ ” ");
INSERT INTO kik_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Nake Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Ĩra andũ a Isiraeli ũũ: ‘Rĩrĩa mũndũ o na ũrĩkũ angĩĩhia atekwenda, na eke ũndũ ũrĩa mũkananie thĩinĩ wa maathani mothe ma Jehova: ");
INSERT INTO kik_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Kũngĩkorwo nĩ mũthĩnjĩri-Ngai ũrĩa mũitĩrĩrie maguta wĩhĩtie na atũme andũ mahĩtie-rĩ, no nginya arehere Jehova ndegwa ĩtarĩ ngũrũ na ĩtarĩ na kaũũgũ, ĩrĩ iruta rĩa kũhoroheria mehia macio ekĩte. ");
INSERT INTO kik_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","No nginya aneane ndegwa ĩyo mũromo-inĩ wa Hema-ya-Gũtũnganwo arĩ mbere ya Jehova. Nĩakaigĩrĩra guoko gwake igũrũ rĩa mũtwe wayo, na acooke amĩthĩnjĩre hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ningĩ mũthĩnjĩri-Ngai ũcio mũitĩrĩrie maguta nĩakoya thakame ĩmwe ya ndegwa ĩyo amĩtware thĩinĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Na nĩagatobokia kĩara gĩake thakame-inĩ ĩyo, aminjaminje ĩmwe yayo mbere ya Jehova maita mũgwanja, hau mbere ya gĩtambaya kĩrĩa gĩa gũcuurio kĩa handũ-harĩa-haamũre. ");
INSERT INTO kik_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ningĩ mũthĩnjĩri-Ngai ũcio nĩakoya thakame ĩmwe ahake hĩa cia kĩgongona kĩa ũbani ũrĩa mũnungi wega kĩrĩa kĩrĩ mbere ya Jehova kũu Hema-inĩ-ya-Gũtũnganwo. Thakame ya ndegwa ĩyo ĩrĩa ĩgaatigara nĩakamĩita thĩ gĩtina-inĩ gĩa kĩgongona kĩa iruta rĩa njino hau mũromo-inĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Nĩakaruta maguta mothe ma ndegwa ĩyo ya igongona rĩa kũhoroherio mehia, namo nĩmo rũambũ rũrĩa ruothe rũhumbĩire nyama cia nda na rũrĩa rũnyiitaine nacio, ");
INSERT INTO kik_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","higo cierĩ hamwe na maguta marĩa macihumbĩire hakuhĩ na honge, na maguta marĩa mahumbĩire ini, amarutanĩrie na higo icio, ");
INSERT INTO kik_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","akaaruta maguta macio o ta ũrĩa marutagwo ndegwa ĩrĩa ĩthĩnjagwo ĩrĩ iruta rĩa ũiguano. Nake mũthĩnjĩri-Ngai nĩagacicinĩra kĩgongona-inĩ kĩa igongona rĩa njino, ");
INSERT INTO kik_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","na rũũa rwa ndegwa ĩyo, na nyama ciayo ciothe hamwe, na mũtwe na mathagiro, na nyama cia nda na mahu, ");
INSERT INTO kik_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ũguo nĩ ta kuuga nyama icio ingĩ ciothe cia ndegwa ĩyo, no nginya agaaciruta nja ya kambĩ, acitware handũ hatarĩ thaahu, harĩa mũhu ũitagwo, na acicinĩre na mwaki wa ngũ hau mũhu-inĩ ũcio. ");
INSERT INTO kik_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Na kĩrĩndĩ gĩothe kĩa Isiraeli kĩngĩkehia gĩtekwenda, gĩĩke ũndũ ũrĩa mũkananie thĩinĩ wa maathani mothe ma Jehova, o na angĩkorwo kĩrĩndĩ kĩu gĩtiũĩ ũndũ ũcio, nĩkĩhĩtĩtie. ");
INSERT INTO kik_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Rĩrĩa gĩkaamenya mehia marĩa gĩĩkĩte, kĩũngano kĩu nĩgĩkaruta gategwa ka igongona rĩa kũhoroherio mehia, kaneanwo mbere ya Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Athuuri a kĩrĩndĩ kĩu nĩmakaigĩrĩra moko mao igũrũ rĩa mũtwe wa ndegwa ĩyo mbere ya Jehova, nayo ndegwa ĩyo ĩthĩnjĩrwo o ro hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Ningĩ mũthĩnjĩri-Ngai ũcio mũitĩrĩrie maguta nĩakoya thakame ĩmwe ya ndegwa ĩyo amĩtoonyie thĩinĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Nĩagatobokia kĩara gĩake thakame-inĩ ĩyo, amĩminjaminje mbere ya Jehova maita mũgwanja hau mbere ya gĩtambaya kĩrĩa gĩa gũcuurio. ");
INSERT INTO kik_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Nĩakoya thakame ĩmwe ahake hĩa cia kĩgongona kĩrĩa kĩrĩ hau mbere ya Jehova kũu Hema-inĩ-ya-Gũtũnganwo. Thakame ĩrĩa ĩgaatigara nĩakamĩita thĩ gĩtina-inĩ gĩa kĩgongona kĩa iruta rĩa njino hau mũromo-inĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Nĩakamĩruta maguta mayo mothe amacinĩre igũrũ rĩa kĩgongona, ");
INSERT INTO kik_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","na eke ndegwa ĩyo o ta ũrĩa eekire ndegwa ya iruta rĩa kũhoroherio mehia. Ũguo nĩguo mũthĩnjĩri-Ngai akamahoroheria mehia mao, nao nĩmakarekerwo. ");
INSERT INTO kik_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Ningĩ nĩakoimia ndegwa ĩyo amĩtware nja ya kambĩ na amĩcine o ta ũrĩa aacinire ndegwa ĩrĩa ya mbere. Rĩu nĩrĩo igongona rĩa kũhoroheria mehia ma kĩrĩndĩ kĩu. ");
INSERT INTO kik_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Rĩrĩa mũtongoria angĩĩhia atekwenda, na eke ũndũ ũrĩa mũkananie thĩinĩ wa maathani mothe ma Jehova Ngai wake, nĩahĩtĩtie. ");
INSERT INTO kik_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Rĩrĩa angĩmenyithio mehia marĩa ekĩte, no nginya arehe thenge ĩtarĩ na kaũũgũ ĩrĩ iruta rĩake. ");
INSERT INTO kik_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Nĩakaigĩrĩra guoko gwake igũrũ rĩa mũtwe wa thenge ĩyo na acooke amĩthĩnjĩre harĩa iruta rĩa njino rĩthĩnjagĩrwo hau mbere ya Jehova. Rĩĩrĩ nĩrĩo iruta rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Nake mũthĩnjĩri-Ngai nĩakoya thakame ĩmwe ya iruta rĩu rĩa mehia na kĩara gĩake, na amĩhake hĩa cia kĩgongona kĩa iruta rĩa njino, nayo thakame ĩyo ĩngĩ amĩite gĩtina-inĩ gĩa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ningĩ nĩagacinĩra maguta mothe kĩgongona-inĩ igũrũ o ta ũrĩa aacinire maguta ma iruta rĩa ũiguano. Ũguo nĩguo mũthĩnjĩri-Ngai akaahoroheria mehia ma mũndũ ũcio, nake nĩakarekerwo. ");
INSERT INTO kik_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Mũndũ ũmwe thĩinĩ wa kĩrĩndĩ angĩĩhia atekwenda na eke ũndũ ũrĩa mũkananie thĩinĩ wa maathani mothe ma Jehova, nĩahĩtĩtie. ");
INSERT INTO kik_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Rĩrĩa angĩmenyithio amenye mehia marĩa ekĩte, no nginya arehe harika ĩtarĩ na kaũũgũ arĩ iruta rĩake nĩ ũndũ wa mehia macio ekĩte. ");
INSERT INTO kik_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Nĩakaigĩrĩra guoko gwake igũrũ rĩa mũtwe wa harika ĩyo ya iruta rĩa kũhoroherio mehia, na amĩthĩnjĩre harĩa iruta rĩa njino rĩthĩnjagĩrwo. ");
INSERT INTO kik_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Nake mũthĩnjĩri-Ngai nĩakoya thakame ĩmwe na kĩara gĩake, na amĩhake hĩa cia kĩgongona kĩa iruta rĩa njino, nayo thakame ĩyo ĩngĩ amĩite gĩtina-inĩ gĩa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Nĩakaruta maguta mothe o ta ũrĩa maguta marutagwo kuuma iruta rĩa ũiguano, nake mũthĩnjĩri-Ngai nĩakamacinĩra kĩgongona-inĩ igũrũ matuĩke mũtararĩko mwega wa gũkenia Jehova. Ũguo nĩguo mũthĩnjĩri-Ngai akaahoroheria mũndũ ũcio, nake nĩakarekerwo. ");
INSERT INTO kik_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Angĩkaarehe kagondu karĩ iruta rĩake rĩa kũhoroherio mehia, nĩakarehe kamwatĩ gatarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Nĩakaigĩrĩra guoko gwake igũrũ rĩa mũtwe wako, na agathĩnje gatuĩke iruta rĩa kũhoroherio mehia, agathĩnjĩre harĩa iruta rĩa njino rĩthĩnjagĩrwo. ");
INSERT INTO kik_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Nake mũthĩnjĩri-Ngai nĩakoya thakame ĩmwe ya iruta rĩu rĩa mehia na kĩara gĩake, nayo amĩhake hĩa cia kĩgongona kĩa iruta rĩa njino, nayo thakame ĩyo ĩngĩ amĩite gĩtina-inĩ gĩa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Nĩakaruta maguta mothe, o ta ũrĩa maguta marutagwo kuuma kũrĩ kagondu ka iruta rĩa ũiguano, na mũthĩnjĩri-Ngai nĩakamacinĩra kĩgongona-inĩ, maigĩrĩirwo igũrũ rĩa maruta marĩa marutĩirwo Jehova na mwaki. Ũguo nĩguo mũthĩnjĩri-Ngai akaamũhoroheria nĩ ũndũ wa mehia marĩa ekĩte, nake nĩakarekerwo. ");
INSERT INTO kik_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Mũndũ angĩaga kũruta ũira rĩrĩa etĩtwo arute ũira igũrũ rĩa ũndũ oonete kana akaigua, mũndũ ũcio nĩehĩtie, na nĩagacookererwo nĩ wĩhia ũcio wake. ");
INSERT INTO kik_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Kana mũndũ angĩhutia kĩndũ o nakĩ kĩrĩ thaahu, kĩrĩ kĩimba kĩa nyamũ ya gĩthaka ĩrĩ thaahu kana kĩa ũhiũ ũrĩ thaahu, kana gĩa ciũmbe iria itambaga thĩ irĩ thaahu, o na aakorwo ndooĩ ũndũ ũcio, mũndũ ũcio nĩanyiitĩtwo nĩ thaahu na nĩahĩtĩtie. ");
INSERT INTO kik_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ ‘Kana angĩhutia kĩndũ kĩrĩ thaahu kiumĩte harĩ mũndũ, kĩndũ o nakĩ kĩrĩa kĩngĩmũthaahia, o na akorwo ũndũ ũcio ndaũũĩ-rĩ, hĩndĩ ĩrĩa akaaũmenya, nĩagatuĩka nĩahĩtĩtie. ");
INSERT INTO kik_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“ ‘Kana mũndũ angĩĩhĩta gwĩka ũndũ o na ũrĩkũ atawĩcirĩtie wega, ũrĩ ũndũ mwega kana mũũru, ũndũ-inĩ o wothe ũrĩa mũndũ angĩhiũha kwĩhĩta, o na angĩkorwo atekũũmenya-rĩ, rĩrĩa akaaũmenya, nĩagatuĩka nĩahĩtĩtie ũndũ-inĩ ũcio. ");
INSERT INTO kik_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“ ‘Rĩrĩa mũndũ ahĩtĩtie na njĩra ĩmwe ya macio-rĩ, no nginya oimbũre ũndũ ũrĩa ehĩtie naguo, ");
INSERT INTO kik_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","na nĩ ũndũ wa rĩĩhia rĩu ekĩte, no nginya arehere Jehova kamwatĩ kana mbũri kuuma rũũru-inĩ, rĩrĩ iruta rĩa kũhoroherio mehia; nake mũthĩnjĩri-Ngai nĩakamũhoroheria mehia make. ");
INSERT INTO kik_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Angĩkorwo ndangĩona kagondu, nĩakarehera Jehova ndirahũgĩ igĩrĩ kana tũtutuura twĩrĩ, rĩrĩ irĩhi rĩa wĩhia wake, ĩmwe ĩrĩ ya iruta rĩa kũhoroherio mehia na ĩrĩa ĩngĩ ĩrĩ ya iruta rĩa njino. ");
INSERT INTO kik_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Nĩagacirehera mũthĩnjĩri-Ngai, ũrĩa ũkaamba kũruta ĩrĩa ya iruta rĩa kũhoroherio mehia. Nĩakamĩthiora ngingo yunĩke no ndakamĩtinanie, ");
INSERT INTO kik_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","na nĩagacooka aminjaminje thakame ĩmwe ya iruta rĩu rĩa mehia mwena-inĩ wa kĩgongona, na thakame ĩyo ĩngĩ amĩite thĩ gĩtina-inĩ gĩa kĩgongona. Rĩu nĩrĩo iruta rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Mũthĩnjĩri-Ngai nĩagacooka arute ĩyo ĩngĩ ĩrĩ iruta rĩa njino o ta ũrĩa gũtuĩtwo, na amũhoroherie mehia marĩa ekĩte, nake nĩakarekerwo. ");
INSERT INTO kik_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘No rĩrĩ, angĩkorwo ndangĩona ndirahũgĩ igĩrĩ kana tũtutuura twĩrĩ, nĩakĩrute gĩcunjĩ gĩa ikũmi kĩa eba ya mũtu ũrĩa mũhinyu mũno ũrĩ iruta rĩa mehia make. Ndakawĩkĩre maguta kana ũbani, nĩ ũndũ rĩu nĩ iruta rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Nĩakaũtwarĩra mũthĩnjĩri-Ngai, nake arũme ngundi yaguo ũtuĩke gĩcunjĩ gĩa kĩririkano acooke aũcinĩre kĩgongona-inĩ igũrũ rĩa maruta marĩa marutĩirwo Jehova na mwaki. Rĩu nĩrĩo iruta rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ũguo nĩguo mũthĩnjĩri-Ngai akaahoroheria mũndũ ũcio rĩĩhia o rĩothe rĩa macio angĩkorwo ekĩte, nake nĩakarekerwo. Matigari ma iruta rĩu magaatuĩka ma mũthĩnjĩri-Ngai, o ta ũrĩa gwĩkagwo hĩndĩ ya iruta rĩa mũtu.’ ” ");
INSERT INTO kik_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ningĩ Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Hĩndĩ ĩrĩa mũndũ angĩhĩtia na ehie atekwenda wĩhia ũkoniĩ indo iria nyamũrĩre Jehova-rĩ, nĩakarehera Jehova ndũrũme ĩrĩ iruta rĩa irĩhi rĩa ihĩtia kuuma rũũru-inĩ, ndũrũme ĩtarĩ na kaũũgũ, ĩkorwo ĩrĩ ya thogora ũrĩa mũiganĩru wa betha, kũringana na cekeri ya handũ-harĩa-haamũre. Rĩu nĩrĩo iruta rĩa ihĩtia. ");
INSERT INTO kik_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","No nginya arĩhe irĩhi nĩ ũndũ wa ũndũ ũrĩa aagĩte kũhingia ũkoniĩ indo iria nyamũre, na ongerere gĩcunjĩ gĩa ithano gĩa thogora wa kĩndũ kĩu ararĩha, na acinengere mũthĩnjĩri-Ngai ciothe, ũrĩa ũkamũhoroheria na ndũrũme ĩyo ya iruta rĩa mahĩtia, nake nĩakarekerwo. ");
INSERT INTO kik_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Mũndũ angĩĩhia eke ũndũ ũrĩa mũkananie thĩinĩ wa maathani mothe ma Jehova o na angĩkorwo ndaraũmenya-rĩ, nĩagacookererwo nĩ mahĩtia macio ekĩte. ");
INSERT INTO kik_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Nĩakarehera mũthĩnjĩri-Ngai ndũrũme ya iruta rĩa mahĩtia kuuma rũũru-inĩ, ndũrũme ĩtarĩ na kaũũgũ na ya thogora ũrĩa wagĩrĩire. Ũguo nĩguo mũthĩnjĩri-Ngai akaahoroheria mũndũ ũcio nĩ ũndũ wa mahĩtia marĩa ekĩte atekwenda, nake nĩakarekerwo. ");
INSERT INTO kik_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Rĩu nĩrĩo iruta rĩa mahĩtia; ti-itherũ mũndũ ũcio nĩahĩtĩirie Jehova.” ");
INSERT INTO kik_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Mũndũ o wothe angĩĩhia aage kwĩhokeka harĩ Jehova na ũndũ wa kũheenia mũndũ ũrĩa ũngĩ igũrũ rĩa kĩndũ ehokeirwo kana atigĩirwo amenyerere, kana kĩndũ kĩiyĩtwo, kana amũheenie, ");
INSERT INTO kik_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","kana angĩona kĩndũ kĩũrĩte na aheenanie ũhoro wakĩo, kana ehĩte na maheeni, kana eke rĩĩhia o rĩothe rĩrĩa rĩĩhagio nĩ andũ, ");
INSERT INTO kik_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","rĩrĩa angĩkorwo ehĩtie ũguo na atuĩke mũhĩtia-rĩ, no nginya acookie kĩrĩa aiyĩte, kana atunyanĩte, kana kĩrĩa ehokeirwo, kana kĩndũ kĩorĩte agĩkĩona, ");
INSERT INTO kik_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","kana ũndũ wothe ehĩtĩte na maheeni ũhoro-inĩ wakĩo. No nginya agaacookia kĩndũ kĩu gĩothe o ũrĩa kĩaiganaga, na ongerere gĩcunjĩ gĩa ithano gĩa thogora wakĩo, na ciothe acinengere mwene mũthenya ũrĩa akaaneana iruta rĩake rĩa mahĩtia. ");
INSERT INTO kik_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Nĩakarehera mũthĩnjĩri-Ngai irĩhi, ũguo nĩ kuuga arute kĩndũ gĩake gĩa kũrutĩrwo Jehova nĩ ũndũ wa mahĩtia make, arute ndũrũme kuuma rũũru-inĩ, ndũrũme ĩtarĩ na kaũũgũ na ya thogora ũrĩa wagĩrĩire. ");
INSERT INTO kik_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ũguo nĩguo mũthĩnjĩri-Ngai akaahoroheria mũndũ ũcio mehia hau mbere ya Jehova, nake nĩakarekerwo ũndũ o wothe wa marĩa ekĩte wa gũtũma atuĩke mũhĩtia.” ");
INSERT INTO kik_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Atha Harũni na ariũ ake, ũmeere ũũ: ‘Ĩno nĩyo mĩtabarĩre ya iruta rĩa njino: Iruta rĩa njino rĩrĩraaraga riiko hau kĩgongona-inĩ igũrũ ũtukũ wothe o nginya rũciinĩ, naguo mwaki ũikare ũgĩakanaga hau kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ningĩ mũthĩnjĩri-Ngai nĩakehumba nguo ciake cia gatani, o na nguo cia thĩinĩ cia gatani iriganĩtie na mwĩrĩ wake; nake nĩakeheria mũhu wa iruta rĩu rĩa njino rĩrĩa rĩcinĩtwo nĩ mwaki wa kĩgongona na aũige mwena-inĩ wa kĩgongona kĩu. ");
INSERT INTO kik_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ningĩ acooke arute nguo icio, ehumbe ingĩ, eherie mũhu ũcio aũtware nja ya kambĩ handũ hatarĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Mwaki ũrĩa ũrĩ kĩgongona-inĩ no nginya ũikare o ũgĩakanaga; ndũkanarekwo ũhore. Hĩndĩ ciothe o rũciinĩ, mũthĩnjĩri-Ngai nĩarĩongagĩrĩra ngũ, na nĩarĩtandayagia iruta rĩu rĩa njino igũrũ rĩa mwaki ũcio, na acinĩre maguta ma maruta ma ũiguano ho. ");
INSERT INTO kik_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Mwaki ũcio no nginya ũikare o ũgĩakanaga kĩgongona-inĩ hĩndĩ ciothe; ndũkanarekwo ũhore. ");
INSERT INTO kik_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Ĩno nĩyo mĩtabarĩre ya iruta rĩa mũtu: Ariũ a Harũni nĩmarĩũrehaga mbere ya Jehova, hau mbere ya kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Mũthĩnjĩri-Ngai nĩarĩrũmaga ngundi ya mũtu ũcio mũhinyu mũno ũrĩ na maguta, hamwe na ũbani wothe ũrĩ iruta-inĩ rĩu rĩa mũtu, na acinĩre gĩcunjĩ gĩa kĩririkano hau kĩgongona-inĩ kĩrĩ mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Nake Harũni na ariũ ake marĩĩage ũrĩa ũrĩtigaraga, no ũrĩĩagwo ũtarĩ na ndawa ya kũimbia, na ũrĩĩagĩrwo handũ hatheru; maũrĩagĩre nja ya Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Mũtu ũcio ndũkanarugwo na ndawa ya kũimbia; ndĩmaheete ũrĩ gĩcunjĩ kĩao kĩa maruta marĩa njinagĩrwo na mwaki. O ta ũrĩa iruta rĩa kũhoroherio mehia na iruta rĩa mahĩtia marĩ matheru mũno makĩria, no taguo iruta rĩĩrĩ rĩrĩ itheru mũno makĩria. ");
INSERT INTO kik_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Mũndũ mũrũme o wothe wa rũciaro rwa Harũni no aũrĩe. Nĩ gĩcunjĩ gĩake kĩa hĩndĩ ciothe kĩa maruta marĩa marĩcinagĩrwo Jehova na mwaki harĩ njiarwa iria igooka. Kĩrĩa gĩothe gĩkaahutia maruta macio nĩgĩgatuĩka gĩtheru.’ ” ");
INSERT INTO kik_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Rĩĩrĩ nĩrĩo iruta rĩrĩa Harũni na ariũ ake marĩrehagĩra Jehova mũthenya ũrĩa egũitĩrĩrio maguta: nĩ gĩcunjĩ gĩa ikũmi kĩa eba ĩmwe ya mũtu ũrĩa mũhinyu mũno, ũrĩ iruta rĩrĩa rĩrutagwo rĩa mũtu, nuthu ĩmwe rũciinĩ na ĩrĩa ĩngĩ hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ũũkarange na maguta rũgĩo-inĩ; ũũrehe ũtukanĩtio wega, na ũneane iruta rĩu rĩa mũtu rĩenyũrangĩtwo cienyũ, rĩtuĩke mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mũriũ ũrĩa ũgaacooka ithenya rĩake arĩ mũthĩnjĩri-Ngai mũitĩrĩrie maguta nĩwe ũkaarĩhaarĩria. Gĩkĩ nĩ gĩcunjĩ kĩa Jehova kĩa hĩndĩ ciothe, nakĩo kĩrĩcinagwo biũ. ");
INSERT INTO kik_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Iruta o rĩothe rĩa mũtu rĩrutĩtwo nĩ mũthĩnjĩri-Ngai rĩrĩcinagwo biũ; rĩtikanarĩĩo.” ");
INSERT INTO kik_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Ĩra Harũni na ariũ ake atĩrĩ, ‘Ĩno nĩyo mĩtabarĩre ya iruta rĩa kũhoroherio mehia: Iruta rĩu rĩrĩthĩnjagĩrwo mbere ya Jehova o harĩa iruta rĩa njino rĩthĩnjagĩrwo; rĩĩrĩ nĩ iruta itheru mũno makĩria. ");
INSERT INTO kik_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Nake mũthĩnjĩri-Ngai ũrĩa ũkaahorohanĩria mehia narĩo nĩwe ũkaarĩrĩa; na rĩrĩĩagĩrwo handũ harĩa hatheru, nja ya Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Kĩrĩa gĩothe gĩkaahutia nyama icio gĩgaatuĩka gĩtheru, na thakame o yothe ĩkaaminjũkĩra nguo no nginya ũkaamĩthambĩria handũ hatheru. ");
INSERT INTO kik_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Nayo nyũngũ ya rĩũmba ĩrĩa ĩkaaruga nyama icio no nginya yũragwo; no ingĩkaarugwo na nyũngũ ya gĩcango-rĩ, nyũngũ ĩyo nĩĩgakumuthwo, ĩcooke ĩkamũrwo na maaĩ. ");
INSERT INTO kik_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Mũndũ mũrũme o wothe wa nyũmba ya mũthĩnjĩri-Ngai no arĩe nyama icio; iruta rĩu nĩ itheru mũno makĩria. ");
INSERT INTO kik_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","No iruta o rĩothe rĩa mehia rĩrĩa thakame yarĩo ĩtwarĩtwo thĩinĩ wa Hema-ya-Gũtũnganwo, ĩrĩ ya kũhorohanĩria thĩinĩ wa Handũ-Harĩa-Hatheru-rĩ, rĩtikanarĩĩo; no nginya rĩcinwo. ");
INSERT INTO kik_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Ĩno nĩyo mĩtabarĩre ya iruta rĩa irĩhi rĩa mahĩtia, narĩo nĩ itheru mũno makĩria: ");
INSERT INTO kik_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Iruta rĩu rĩa irĩhi rĩa mahĩtia rĩgaathĩnjagĩrwo o harĩa iruta rĩa njino rĩthĩnjagĩrwo, na thakame yarĩo ĩminjaminjĩrio kĩgongona mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Nake mũthĩnjĩri-Ngai nĩarĩrutaga maguta mothe marĩo: maguta ma mũtingʼoe ũrĩa mũnoru, na maguta marĩa mahumbĩire nyama cia nda, ");
INSERT INTO kik_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","higo cierĩ na maguta ma cio marĩa macihumbĩire hakuhĩ na honge, na maguta marĩa mahumbĩire ini, marutanagĩrio na higo icio. ");
INSERT INTO kik_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Nake mũthĩnjĩri-Ngai nĩakamacinĩra kĩgongona-inĩ, matuĩke iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki. Rĩu nĩrĩo iruta rĩa irĩhi rĩa mahĩtia. ");
INSERT INTO kik_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Mũndũ mũrũme o wothe wa nyũmba ya mũthĩnjĩri-Ngai no arĩe nyama cia iruta rĩu, na no nginya rĩrĩĩrwo handũ hatheru; nĩ iruta itheru mũno makĩria. ");
INSERT INTO kik_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Watho wa iruta rĩa kũhoroherio mehia na wa iruta rĩa irĩhi rĩa mahĩtia no ũmwe: nyama ciamo nĩ cia mũthĩnjĩri-Ngai ũrĩa ũkũhorohanĩria nacio. ");
INSERT INTO kik_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Mũthĩnjĩri-Ngai ũrĩa ũraruta iruta rĩa njino rĩa mũndũ o wothe we no arigie na rũũa. ");
INSERT INTO kik_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Iruta rĩothe rĩa mũtu rĩrugĩirwo riiko-inĩ kana rĩgakarangwo na rũgĩo kana na kĩbaati nĩ rĩa mũthĩnjĩri-Ngai ũrĩa ũrĩrĩrutagĩra Jehova, ");
INSERT INTO kik_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","narĩo iruta o rĩothe rĩa mũtu ũtukanĩtio na maguta kana rĩtarĩ maguta o narĩo nĩ rĩa ariũ othe a Harũni, marĩgayane rĩiganaine. ");
INSERT INTO kik_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Ĩno nĩyo mĩtabarĩre ya iruta rĩa ũiguano rĩrĩa mũndũ angĩneana kũrĩ Jehova: ");
INSERT INTO kik_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Angĩkorwo ekũruta nĩ ũndũ wa gũcookia ngaatho-rĩ, nĩ arutanĩrie iruta rĩu rĩa gũcookia ngaatho hamwe na tũmĩgate tũrugĩtwo tũtarĩ na ndawa ya kũimbia tũtukanĩtio na maguta na tũmĩgate tũrĩa tũhũthũ tũrugĩtwo tũtarĩ na ndawa ya kũimbia tũrĩ tũhake maguta, na tũmĩgate twa mũtu ũrĩa mũhinyu mũno, ũkimanĩtio wega na ũgatukanio na maguta. ");
INSERT INTO kik_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ningĩ hamwe na iruta rĩake rĩa ũiguano rĩa gũcookia ngaatho-rĩ, nĩakarĩrutanĩria na tũmĩgate tũrugĩtwo na ndawa ya kũimbia. ");
INSERT INTO kik_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Nĩakarehe o kĩndũ kĩmwe kĩmwe kĩrĩ iruta, kĩheo kĩheanĩtwo harĩ Jehova; nĩ kĩa mũthĩnjĩri-Ngai ũrĩa ũminjaminjaga thakame ĩyo ya iruta rĩu rĩa ũiguano. ");
INSERT INTO kik_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Nyama icio cia iruta rĩu rĩake rĩa ũiguano rĩa gũcookia ngaatho no nginya irĩĩo mũthenya o ro ũcio ikaarutĩrwo Jehova; ndakanatigie gĩcunjĩ o na kĩmwe gĩkinyie rũciinĩ. ");
INSERT INTO kik_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘No rĩrĩ, angĩkorwo iruta rĩake riumanĩte na ũndũ wa mwĩhĩtwa ehĩtĩte, kana nĩ rĩa kwĩyendera-rĩ, iruta rĩu rĩkaarĩĩo mũthenya o ro ũcio akaarĩruta, no kĩrĩa gĩothe gĩgaatigara no kĩrĩĩo mũthenya ũyũ ũngĩ. ");
INSERT INTO kik_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nyama ciothe cia igongona rĩu ĩngĩtigara ĩkinyie mũthenya wa gatatũ-rĩ, no nginya ĩcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Nyama cia iruta rĩa ũiguano ingĩrĩĩo mũthenya wa gatatũ-rĩ, iruta rĩu rĩtigetĩkĩrĩka. Mũndũ ũcio ũrĩrutĩte agaatarwo ta atarutĩte kĩndũ, tondũ ti rĩtheru; ũrĩa wothe ũkaarĩa o na kanini karĩo nĩagacookererwo nĩ wĩhia ũcio. ");
INSERT INTO kik_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Nyama iria ingĩhutania na kĩndũ o ro gĩothe kĩrĩ na thaahu itikanarĩĩo; no nginya icinwo na mwaki. No nyama icio ingĩ mũndũ o ro wothe ũtethaahĩtie no acirĩe. ");
INSERT INTO kik_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","No mũndũ o wothe wĩthaahĩtie angĩkaarĩa nyama cia iruta rĩu rĩa ũiguano rĩrutĩirwo Jehova-rĩ, mũndũ ũcio no nginya akaingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Mũndũ o wothe angĩkaahutia kĩndũ kĩrĩ na thaahu, arĩ thaahu uumĩte harĩ mũndũ, kana nyamũ ĩrĩ na thaahu, kana kĩndũ o ro gĩothe kĩũru biũ kĩrĩ na thaahu, na acooke arĩe nyama o yothe ya iruta rĩu rĩa ũiguano rĩrutĩirwo Jehova-rĩ, mũndũ ũcio no nginya aingatwo kuuma kũrĩ andũ ao.’ ” ");
INSERT INTO kik_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Ĩra andũ a Isiraeli atĩrĩ, ‘Mũtikanarĩe maguta o na marĩkũ, ma ngʼombe kana ma ngʼondu, o na kana ma mbũri. ");
INSERT INTO kik_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mũngĩgaakora nyamũ ĩkuĩte, kana ĩkooragwo nĩ nyamũ cia gĩthaka, maguta mayo no mahũthĩrwo na ũndũ ũngĩ o wothe, no mũtikanamarĩe. ");
INSERT INTO kik_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Mũndũ o wothe angĩrĩa maguta ma nyamũ ĩrutĩirwo Jehova iruta rĩa gũcinwo na mwaki, no nginya aingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Na kũrĩa guothe mũgaatũũra-rĩ, mũtikanarĩe thakame ya mũthemba o na ũrĩkũ, ĩrĩ ya nyoni kana ya nyamũ. ");
INSERT INTO kik_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Mũndũ o wothe angĩkaarĩa thakame, no nginya aingatwo kuuma kũrĩ andũ ao.’ ” ");
INSERT INTO kik_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Ĩra andũ a Isiraeli atĩrĩ, ‘Mũndũ o wothe ũngĩrehere Jehova iruta rĩa ũiguano, akaarehe gĩcunjĩ kĩarĩo kĩrĩ igongona rĩake mwene kũrĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Kĩrĩa akaaruta agaakĩrehe na moko make we mwene gĩtuĩke iruta rĩa kũrutĩrwo Jehova na gũcinwo na mwaki; nĩakarehe maguta, hamwe na gĩthũri, na agĩthũngũthie mbere ya Jehova gĩtuĩke iruta rĩa gũthũngũthio. ");
INSERT INTO kik_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Mũthĩnjĩri-Ngai nĩagaacinĩra maguta macio kĩgongona-inĩ, no gĩthũri gĩtuĩke kĩa Harũni na ariũ ake. ");
INSERT INTO kik_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","No nginya mũheage mũthĩnjĩri-Ngai kĩero kĩa ũrĩo kĩa maruta manyu ma ũiguano kĩrĩ kĩheo kĩanyu kũrĩ o. ");
INSERT INTO kik_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Mũriũ wa Harũni ũrĩa ũrahorohanĩria na thakame na maguta ma iruta rĩu rĩa iruta rĩa ũiguano-rĩ, nĩakaheo kĩero kĩa mwena wa ũrĩo kĩrĩ rwĩga rwake. ");
INSERT INTO kik_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Kuuma harĩ iruta rĩa ũiguano rĩa andũ a Isiraeli, nĩnjoete gĩthũri kĩrĩa gĩthũngũthĩtio, na kĩero kĩrĩa kĩneanĩtwo kũrĩ niĩ, ngacihe Harũni ũrĩa mũthĩnjĩri-Ngai na kũrĩ ariũ ake ituĩke rwĩga rwao rwa hĩndĩ ciothe kuuma kũrĩ andũ a Isiraeli.’ ” ");
INSERT INTO kik_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Gĩkĩ nĩkĩo gĩcunjĩ kĩa maruta marĩa maarutagĩrwo Jehova macinĩtwo na mwaki, kĩrĩa kĩagaĩirwo Harũni na ariũ ake mũthenya ũrĩa maamũrirwo matungatagĩre Jehova marĩ athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Mũthenya ũrĩa maaitĩrĩirio maguta, Jehova nĩathanire atĩ andũ a Isiraeli mamaheage nyama icio hĩndĩ ciothe ituĩke rwĩga rwao nginya njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ĩno nĩyo mĩtabarĩre ya maruta ma njino, na ma mũtu, na ma kũhoroherio mehia, na ma mahĩtia, na ma kĩamũrano, na ma ũiguano, ");
INSERT INTO kik_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","marĩa Jehova aaheire Musa arĩ Kĩrĩma-inĩ gĩa Sinai, mũthenya ũrĩa aathire andũ a Isiraeli marehagĩre Jehova maruta mao kũu Werũ-inĩ wa Sinai. ");
INSERT INTO kik_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Rehe Harũni na ariũ ake, na nguo ciao, na maguta ma gũitanĩrĩrio, na ndegwa ya iruta rĩa kũhoroherio mehia, na ndũrũme igĩrĩ, na gĩkabũ kĩa mĩgate ĩrugĩtwo ĩtarĩ na ndawa ya kũimbia, ");
INSERT INTO kik_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ũcooke ũcookanĩrĩrie kĩũngano gĩothe kĩa andũ a Isiraeli mũromo-inĩ wa Hema-ya-Gũtũnganwo.” ");
INSERT INTO kik_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa agĩĩka o ta ũrĩa Jehova aamwathĩte, nakĩo kĩũngano kĩu gĩgĩcookanĩrĩra mũromo-inĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Nake Musa akĩĩra kĩũngano kĩu atĩrĩ, “Ũũ nĩguo Jehova aathanĩte gwĩkwo” ");
INSERT INTO kik_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Nake Musa akĩrehe Harũni na ariũ ake hau mbere, akĩmathambia na maaĩ. ");
INSERT INTO kik_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Agĩcooka akĩhumba Harũni kanjũ, na akĩmuoha mũcibi, na akĩmũhumba nguo ĩrĩa ya igũrũ ndaaya, na akĩmwĩkĩra ebodi. Ningĩ akĩmuoherera ebodi na mũcibi wa njohero ũrĩa watumĩtwo wega; nĩ ũndũ ũcio ũkĩohererwo harĩ we, akĩmũhotora naguo. ");
INSERT INTO kik_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Agĩcooka akĩmwĩkĩra gakuo ga gĩthũri, na gakuo-inĩ kau agĩĩkĩra Urimu na Thumimu. ");
INSERT INTO kik_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Ningĩ akĩoha Harũni kĩremba mũtwe, na agĩĩkĩra gathuuma ga thahabu, nako nĩ tanji nyamũre, akĩmĩĩkĩra mwena wa mbere wa kĩremba o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ningĩ Musa akĩoya maguta marĩa ma gũitanĩrĩrio na akĩmaitĩrĩria Hema-ĩrĩa-Nyamũre na kĩrĩa gĩothe kĩarĩ thĩinĩ wayo, na nĩ ũndũ ũcio agĩciamũra. ");
INSERT INTO kik_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Nĩaminjaminjĩirie kĩgongona kĩu maguta mamwe ma macio maita mũgwanja, agĩitĩrĩria kĩgongona kĩu maguta hamwe na indo ciakĩo ciothe, na mbakũri hamwe na mĩrũgamo yakĩo, agĩciamũra. ");
INSERT INTO kik_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Nĩaitĩrĩirie Harũni maguta mamwe mũtwe akĩmũitĩrĩria maguta nĩgeetha amwamũre. ");
INSERT INTO kik_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ningĩ akĩrehe ariũ a Harũni hau mbere na akĩmahumba kanjũ, akĩmooha mĩcibi na akĩmekĩra tũkũbia mũtwe, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ningĩ akĩneana ndegwa ya iruta rĩa kũhoroherio mehia, nake Harũni na ariũ ake makĩigĩrĩra moko mao igũrũ rĩa mũtwe wa ndegwa ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Musa agĩthĩnja ndegwa ĩyo, na akĩoya thakame ĩmwe yayo na kĩara gĩake, akĩmĩhaka hĩa ciothe cia kĩgongona nĩgeetha atherie kĩgongona. Agĩcooka agĩita thakame ĩyo ĩngĩ gĩtina-inĩ gĩa kĩgongona. Nĩ ũndũ ũcio agĩkĩamũra nĩguo akĩhoroherie. ");
INSERT INTO kik_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ningĩ Musa akĩoya maguta mothe marĩa maahumbĩire nyama cia nda, na marĩa maahumbĩire ini, na higo cierĩ na maguta ma cio, akĩmacinĩra kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","No ndegwa ĩyo, hamwe na rũũa rwayo na nyama ciayo na mahu mayo agĩcicinĩra nja ya kambĩ, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Agĩcooka akĩneana ndũrũme ya iruta rĩa njino, nake Harũni na ariũ ake makĩigĩrĩra moko mao igũrũ rĩa mũtwe wa ndũrũme ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Musa agĩcooka agĩthĩnja ndũrũme ĩyo, na akĩminjaminjĩria thakame yayo mĩena yothe ya kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Agĩcooka agĩtinangia ndũrũme ĩyo icunjĩ, na agĩcina mũtwe na icunjĩ icio na maguta. ");
INSERT INTO kik_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Musa nĩathambirie nyama cia nda na mathagiro na maaĩ, na agĩcinĩra ndũrũme ĩyo yothe kĩgongona-inĩ, ĩgĩtuĩka iruta rĩa njino rĩrĩ na mũtararĩko mwega, narĩo nĩ iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ningĩ Musa akĩneana ndũrũme ĩyo ĩngĩ, nĩyo ndũrũme ya kĩamũrano, nake Harũni na ariũ ake makĩigĩrĩra moko mao igũrũ rĩa mũtwe wayo. ");
INSERT INTO kik_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Musa agĩthĩnja ndũrũme ĩyo, na akĩoya thakame ĩmwe yayo akĩmĩhaka moni ya gũtũ kwa ũrĩo kwa Harũni, na kĩara gĩake kĩrĩa kĩnene gĩa guoko gwake kwa ũrĩo, na kĩara gĩake kĩrĩa kĩnene gĩa kũgũrũ gwake kwa ũrĩo. ");
INSERT INTO kik_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ningĩ Musa akĩrehe ariũ a Harũni hau mbere, na akĩmahaka thakame ĩmwe moni cia matũ mao ma ũrĩo, na ciara ciao iria nene cia moko mao ma ũrĩo, na ciara ciao iria nene cia magũrũ mao ma ũrĩo. Ningĩ akĩminjaminjĩria kĩgongona thakame mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Agĩcooka akĩoya maguta, maguta ma mũtingʼoe mũnoru, na maguta mothe marĩa mahumbĩire nyama cia nda, na marĩa mahumbĩire ini, na higo cierĩ na maguta ma cio, o na kĩero kĩa mwena wa ũrĩo. ");
INSERT INTO kik_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ningĩ kuuma gĩkabũ-inĩ kĩa mĩgate ĩrĩa yarugĩtwo ĩtarĩ ndawa ya kũimbia, kĩrĩa kĩarĩ hau mbere ya Jehova, akĩoya kamũgate, na kamũgate kangĩ kaarugĩtwo na maguta, na kamũgate kangĩ kahũthũ; agĩtũigĩrĩra igũrũ rĩa icunjĩ cia maguta macio na kĩero-inĩ kĩu kĩa ũrĩo. ");
INSERT INTO kik_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Indo icio ciothe agĩciigĩrĩra moko-inĩ ma Harũni na ma ariũ ake, agĩcithũngũthĩria mbere ya Jehova ituĩke iruta rĩa gũthũngũthio. ");
INSERT INTO kik_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ningĩ Musa agĩcooka agĩcioya kuuma moko-inĩ mao, agĩcicinĩra kĩgongona-inĩ igũrũ rĩa iruta rĩa njino, irĩ iruta rĩa kĩamũrano rĩrĩ na mũtararĩko mwega, nĩrĩo iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Musa agĩcooka akĩoya gĩthũri kĩrĩ rwĩga rwake thĩinĩ wa ndũrũme ĩyo ya kĩamũrano, agĩgĩthũngũthĩria mbere ya Jehova gĩtuĩke iruta rĩa gũthũngũthio, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ningĩ Musa akĩoya maguta mamwe ma macio ma gũitanĩrĩrio, na thakame ĩmwe kuuma kĩgongona-inĩ agĩciminjaminjĩria Harũni hamwe na nguo ciake, na ariũ ake hamwe na nguo ciao. Nĩ ũndũ ũcio akĩamũra Harũni na nguo ciake, na ariũ ake na nguo ciao. ");
INSERT INTO kik_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ningĩ Musa akĩĩra Harũni na ariũ ake atĩrĩ, “Rugĩrai nyama icio itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo na mũcirĩĩre o hau hamwe na mĩgate kuuma gĩkabũ-inĩ kĩa iruta rĩa kĩamũrano, o ta ũrĩa njathanĩte ngoiga atĩrĩ, ‘Harũni na ariũ ake nĩmacirĩĩage.’ ");
INSERT INTO kik_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ningĩ mũcooke mũcine nyama na mĩgate ĩrĩa ĩgũtigara. ");
INSERT INTO kik_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Mũtikehere itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo ihinda rĩa mĩthenya mũgwanja, nginya matukũ manyu ma kwamũrwo mahinge, nĩ ũndũ kwamũrwo kwanyu gũgaikara mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ũrĩa gwĩkĩtwo ũmũthĩ, gwathanĩtwo nĩ Jehova nĩguo mũhoroherio. ");
INSERT INTO kik_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","No nginya mũikare itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo mĩthenya mũgwanja, mũthenya na ũtukũ, nĩguo mũhingie ũrĩa Jehova arenda, nĩguo mũtigakue; nĩgũkorwo ũguo nĩguo njathĩtwo.” ");
INSERT INTO kik_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Nĩ ũndũ ũcio Harũni na ariũ ake magĩĩka maũndũ marĩa mothe Jehova aathĩte Musa mekwo. ");
INSERT INTO kik_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Mũthenya wa ĩnana wakinya, Musa agĩĩta Harũni na ariũ ake, na athuuri a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Akĩĩra Harũni atĩrĩ, “Oya njaũ ya ndegwa ya iruta rĩaku rĩa kũhoroherio mehia na ndũrũme ya iruta rĩaku rĩa njino, cierĩ itigakorwo na kaũũgũ, ũcineane hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ũcooke wĩre andũ a Isiraeli atĩrĩ: ‘Oyai thenge ya iruta rĩa kũhoroherio mehia, na gacaũ na gatũrũme, twerĩ twa ũkũrũ wa mwaka ũmwe na tũtarĩ na kaũũgũ, tũtuĩke iruta rĩa njino, ");
INSERT INTO kik_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","na muoye ndegwa na ndũrũme cia iruta rĩa ũiguano irutwo igongona mbere ya Jehova, hamwe na iruta rĩa mũtu ũtukanĩtio na maguta. Nĩgũkorwo ũmũthĩ Jehova nĩekũmuumĩrĩra.’ ” ");
INSERT INTO kik_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Nao magĩtwara indo icio Musa aathanĩte irutwo mbere ya Hema-ya-Gũtũnganwo, nakĩo kĩũngano kĩa andũ a Isiraeli gĩothe gĩgĩkuhĩrĩria, gĩkĩrũgama hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa agĩcooka akĩmeera atĩrĩ, “Ũũ nĩguo Jehova aathanĩte mwĩke, nĩguo riiri wa Jehova ũmuumĩrĩre.” ");
INSERT INTO kik_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa akĩĩra Harũni atĩrĩ, “Ũka kĩgongona-inĩ ũrute igongona rĩaku rĩa kũhoroherio mehia na iruta rĩaku rĩa njino, wĩhoroherie wee mwene na ũhoroherie andũ aya; ũcooke ũrute igongona rĩa indo iria andũ marehete ũmahoroherie, o ta ũrĩa Jehova aathanĩte.” ");
INSERT INTO kik_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Nĩ ũndũ ũcio Harũni agĩũka kĩgongona-inĩ, agĩthĩnja gacaũ ka iruta rĩa kũhoroherio mehia, nĩ ũndũ wake mwene. ");
INSERT INTO kik_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ariũ ake makĩmũrehere thakame ĩyo, nake agĩtobokia kĩara gĩake thakame-inĩ ĩyo, akĩmĩhaka hĩa cia kĩgongona; nayo thakame ĩyo ĩngĩ akĩmĩita hau gĩtina-inĩ gĩa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Agĩcooka agĩcinĩra maguta hau kĩgongona igũrũ, na higo cierĩ na maguta marĩa mahumbĩire ini, ma kuuma iruta-inĩ rĩu rĩa kũhoroherio mehia, o ta ũrĩa Jehova aathĩte Musa; ");
INSERT INTO kik_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","nacio nyama cia iruta rĩu na rũũa agĩcicinĩra nja ya kambĩ. ");
INSERT INTO kik_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ningĩ agĩthĩnja iruta rĩa njino. Nao ariũ ake makĩmũnengera thakame ĩyo, nake akĩmĩminjaminjĩria kĩgongona mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Nao makĩmũnengera iruta rĩu rĩa njino gĩcunjĩ kĩmwe gwa kĩmwe, o hamwe na mũtwe, nake agĩcicinĩra kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ningĩ agĩthambia nyama cia nda na mathagiro na agĩcicinĩra igũrũ rĩa iruta rĩa njino hau kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ningĩ Harũni akĩrehe iruta rĩrĩa rĩarĩ rĩa kũrutĩrwo andũ. Akĩoya thenge ĩrĩa ya kũrutĩrwo andũ ĩrĩ iruta rĩa kũmahoroheria mehia akĩmĩthĩnja akĩmĩruta nĩ ũndũ wa iruta rĩa kũhoroheria mehia, o ta ũrĩa ekĩte ĩyo ya mbere. ");
INSERT INTO kik_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Harũni akĩrehe iruta rĩu rĩa njino akĩrĩruta o ta ũrĩa gwatuĩtwo. ");
INSERT INTO kik_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Agĩcooka akĩrehe iruta rĩa mũtu, akĩrũma ngundi yaguo, na akĩũcinĩra igũrũ rĩa kĩgongona hamwe na iruta rĩa njino rĩa rũciinĩ. ");
INSERT INTO kik_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Ningĩ agĩthĩnja ndegwa na ndũrũme irĩ iruta rĩa ũiguano nĩ ũndũ wa andũ. Ariũ ake makĩmũnengera thakame yacio, nake akĩmĩminjaminjĩria kĩgongona mĩena yothe. ");
INSERT INTO kik_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","No maguta ma ndegwa, na ma ndũrũme, na ma mũtingʼoe mũnoru, na ma rũambũ, na higo cierĩ na maguta marĩa mahumbĩire ini, ");
INSERT INTO kik_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","icio magĩciigĩrĩra ithũri-inĩ, nake Harũni agĩcinĩra maguta macio kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Harũni agĩcooka agĩthũngũthia ithũri icio na kĩero kĩa mwena wa ũrĩo mbere ya Jehova ĩrĩ iruta rĩa gũthũngũthio, o ta ũrĩa Musa aathanĩte. ");
INSERT INTO kik_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ningĩ Harũni akĩambararia moko make amaroretie na kũrĩ andũ akĩmarathima. Na tondũ nĩarĩkĩtie kũruta iruta rĩu rĩa kũhoroherio mehia, na iruta rĩa njino, na iruta rĩa ũiguano, agĩikũrũka kuuma kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa na Harũni magĩthiĩ magĩtoonya Hema-inĩ-ya-Gũtũnganwo. Rĩrĩa moimire nja, makĩrathima andũ; naguo riiri wa Jehova ũkiumĩrĩra andũ othe. ");
INSERT INTO kik_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mwaki ũkiuma harĩ Jehova ũgĩcina iruta rĩu rĩa njino na maguta marĩa maarĩ kĩgongona-inĩ. Na rĩrĩa andũ othe maawoonire makĩanĩrĩra nĩ gũkena, makĩinamĩrĩra maturumithĩtie mothiũ mao thĩ. ");
INSERT INTO kik_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Na rĩrĩ, ariũ a Harũni, nĩo Nadabu na Abihu, nĩmoire ngĩo ciao cia ũbani, magĩciĩkĩra mwaki na makĩongerera ũbani; na makĩrehe mwaki ũteetĩkĩrĩtio mbere ya Jehova, ũrĩa wareganĩte na watho wa Jehova. ");
INSERT INTO kik_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Nĩ ũndũ ũcio mwaki ũkiuma kũrĩ Jehova, ũkĩmaniina, nao magĩkuĩra o hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ningĩ Musa akĩĩra Harũni atĩrĩ, “Ũndũ ũyũ nĩguo Jehova aaririe, rĩrĩa oigire atĩrĩ: “ ‘Gatagatĩ-inĩ ka andũ arĩa marĩĩthengagĩrĩra, nĩndĩrĩĩonanagia ndĩ mũtheru; nĩndĩrĩtĩĩagwo mbere ya andũ othe.’ ” Nake Harũni agĩkira ki. ");
INSERT INTO kik_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa agĩĩta Mishaeli na Elizafani, ariũ a Uzieli, ithe mũnini wa Harũni, akĩmeera atĩrĩ, “Ũkai haha, muoye ciimba cia ariũ a ithe wanyu, mũciumie nja ya kambĩ haraihu na itoonyero rĩa handũ-harĩa-haamũre.” ");
INSERT INTO kik_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Nĩ ũndũ ũcio magĩũka, makĩmakuua, marĩ o na kanjũ ciao, makĩmatwara nja ya kambĩ, o ta ũrĩa Musa aathanĩte. ");
INSERT INTO kik_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ningĩ Musa akĩĩra Harũni na ariũ ake Eleazaru na Ithamaru atĩrĩ, “Mũtikanareke njuĩrĩ cianyu ciikare itarĩ njanũre, kana mũtembũrange nguo cianyu, nĩguo mũtigakue, na mũtũme Jehova arakarĩre kĩrĩndĩ gĩkĩ gĩothe. No rĩrĩ, rekei andũ a nyũmba yanyu, nyũmba yothe ya Isiraeli, macakaĩre acio Jehova aniinĩte na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mũtikehere itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo nĩguo mũtigakue, tondũ nĩmũitĩrĩirio maguta ma Jehova.” Nĩ ũndũ ũcio magĩĩka o ta ũrĩa Musa aameerire. ");
INSERT INTO kik_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ningĩ Jehova akĩĩra Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Wee na ariũ aku-rĩ, mũtikananyue ndibei kana kĩndũ o gĩothe kĩngĩtũma mũndũ arĩĩo rĩrĩa rĩothe mũrĩtoonyaga Hema-ya-Gũtũnganwo, nĩguo mũtigakue. Ũndũ ũcio nĩ ũtuĩke watho mwandĩke wa gũtũũra nginya njiarwa-inĩ iria igooka. ");
INSERT INTO kik_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","No nginya mũkũũranage indo iria nyamũre na iria itarĩ nyamũre, o na iria irĩ thaahu na iria itarĩ thaahu, ");
INSERT INTO kik_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","na no nginya mũrutage andũ a Isiraeli watho wothe wa kũrũmagĩrĩrwo, ũrĩa Jehova aamaheire na kanua ka Musa.” ");
INSERT INTO kik_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ningĩ Musa akĩĩra Harũni na ariũ ake arĩa maatigaire, nĩo Eleazaru na Ithamaru, atĩrĩ, “Oyai iruta rĩu rĩa mũtu rĩatigarĩte kuuma harĩ maruta marĩa maarutĩirwo Jehova ma gũcinwo na mwaki, mũrĩrĩe rĩthondeketwo rĩtarĩ na ndawa ya kũimbia, mũrĩĩre hau mwena-inĩ wa kĩgongona, nĩ ũndũ nĩ iruta rĩtheru mũno makĩria. ");
INSERT INTO kik_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mũrĩrĩĩre handũ hatheru, tondũ nĩ rwĩga rwaku na rwa ariũ aku kuuma maruta-inĩ marĩa marutĩirwo Jehova ma gũcinwo na mwaki; tondũ ũguo nĩguo njathĩtwo. ");
INSERT INTO kik_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","No wee, na ariũ aku na airĩtu aku no mũrĩe gĩthũri kĩrĩa gĩathũngũthĩtio, na kĩero kĩrĩa kĩaheanĩtwo. Mũcirĩĩre handũ hatarĩ thaahu; icio nĩwe ũheetwo hamwe na ciana ciaku ituĩke rwĩga rwanyu rwa maruta ma ũiguano ma andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kĩero kĩu kĩarutĩtwo, na gĩthũri kĩu gĩathũngũthĩtio, no nginya irehanĩrio na maguta ma maruta ma gũcinwo na mwaki, na ithũngũthio mbere ya Jehova, ituĩke igongona rĩa gũthũngũthio. Rũrũ nĩruo rwĩga rwaku na rwa ciana ciaku hĩndĩ ciothe, o ta ũrĩa Jehova aathanĩte.” ");
INSERT INTO kik_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Rĩrĩa Musa oorĩrĩirie ũhoro wa mbũri ĩrĩa ya iruta rĩa kũhoroherio mehia, na akĩmenya atĩ nĩyarĩkĩtie gũcinwo biũ-rĩ, akĩrakarĩra Eleazaru na Ithamaru, ariũ a Harũni arĩa maatigaire, akĩmooria atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Nĩ kĩĩ kĩgiririe mũrĩĩre iruta rĩu rĩa kũhoroheria mehia handũ-harĩa-haamũre? Nĩ iruta itheru mũno makĩria; mwaheirwo iruta rĩu rĩa kweheragia mahĩtia ma kĩrĩndĩ rĩrĩa mũkũmahoroheria hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Kuona atĩ thakame yayo ndĩnatoonyio thĩinĩ wa Handũ-hau-Hatheru-rĩ, nĩmũkwagĩrĩirwo nĩkũrĩĩra mbũri ĩyo Handũ-hau-Haamũre, o ta ũrĩa ndaathanire.” ");
INSERT INTO kik_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Harũni agĩcookeria Musa, akĩmwĩra atĩrĩ, “Ũmũthĩ nĩmarutire igongona rĩao rĩa kũhoroherio mehia, na iruta rĩao rĩa njino hau mbere ya Jehova, no maũndũ ta macio o na niĩ manangora. Ingĩkũrĩĩte iruta rĩu rĩa kũhoroherio mehia ũmũthĩ-rĩ, ũndũ ũcio nĩũngĩkenirie Jehova?” ");
INSERT INTO kik_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Hĩndĩ ĩrĩa Musa aiguire ũhoro ũcio-rĩ, akĩiganĩra. ");
INSERT INTO kik_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Nake Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Ĩrai andũ a Isiraeli ũũ, ‘Gatagatĩ-inĩ ka nyamũ ciothe iria irĩ bũrũri-inĩ-rĩ, ici nĩcio mũngĩrĩa: ");
INSERT INTO kik_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","No mũrĩe nyamũ o yothe ĩrĩ mahũngũ marekanĩtie gatagatĩ biũ na ĩcookagia ithagumia. ");
INSERT INTO kik_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Nĩ kũrĩ nyamũ imwe icookagia o ithagumia tu, na ingĩ irĩ o mahũngũ marekanĩtie; icio mũtikanacirĩe. Ngamĩĩra o na aakorwo nĩĩcookagia ithagumia-rĩ, mahũngũ mayo matirekanĩtie; ĩyo ĩrĩ thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Gĩkami o na aakorwo nĩgĩcookagia ithagumia-rĩ, mahũngũ makĩo matirekanĩtie; kĩu kĩrĩ thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Mbũkũ o na aakorwo nĩĩcookagia ithagumia-rĩ, mahũngũ mayo matirekanĩtie; ĩyo ĩrĩ thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nayo ngũrwe o na akorwo mahũngũ mayo nĩmarekanĩtie biũ-rĩ, ndĩcookagia ithagumia; ĩyo ĩrĩ thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Mũtikanarĩe nyama ciacio kana mũhutie ciimba ciacio; icio irĩ thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Harĩ ciũmbe ciothe iria itũũraga maaĩ-inĩ ma iria na ma tũrũũĩ-rĩ, no mũrĩe ciothe iria irĩ mathagu manyiitaine na nĩ irĩ ngaracũ mwĩrĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","No ciũmbe ciothe iria irĩ iria-inĩ kana tũrũũĩ-inĩ, na itirĩ mathagu manyiitaine o hamwe na ngaracũ mwĩrĩ, irĩ imwe cia iria ithiiaga irĩ hamwe, kana irĩ ciothe cia iria irĩ muoyo kũu maaĩ-inĩ; no nginya mũcithũũre biũ. ");
INSERT INTO kik_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Na tondũ no nginya mũcithũũre-rĩ, mũtikanarĩe nyama ciacio, na no nginya mũthũũre ciimba ciacio biũ. ");
INSERT INTO kik_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Kĩndũ o gĩothe gĩtũũraga maaĩ-inĩ na gĩtirĩ mathagu manyiitaine kana ngaracũ mwĩrĩ, nĩciagũthũũrwo nĩ inyuĩ biũ. ");
INSERT INTO kik_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Ici nĩcio nyoni iria mwagĩrĩirwo nĩgũthũũra na mũtangĩrĩa tondũ nĩ thũũre; nacio nĩ nderi, na ndiyũ, na ndiyũ iria njirũ, ");
INSERT INTO kik_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","na hũngũ ĩrĩa ndune, na mũthemba o wothe wa hũngũ iria njirũ, ");
INSERT INTO kik_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","na mahuru mothe, ");
INSERT INTO kik_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","na ndundu ĩrĩa ĩrĩ rũhĩa, na ndundu ĩrĩa ĩgambaga, na nyoni ya iria-inĩ ĩrĩa ĩrĩ mathagu maraaya, na mũthemba o wothe wa rwĩgĩ, ");
INSERT INTO kik_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","na gatundu karĩa kanini, na nyoni ya iria-inĩ ĩrĩa ĩrĩ ngingo ndaaya, na ndundu ĩrĩa nene, ");
INSERT INTO kik_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","na ndundu ĩrĩa njerũ, na ndundu ya werũ-inĩ, na hũngũ ya iria-inĩ, ");
INSERT INTO kik_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","na karoga-ngunũ, na mĩthemba yothe ya cũcũ-wa-njoka, na hudihuda, o na rũhuhu. ");
INSERT INTO kik_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Tũnyamũ tuothe tũrĩa tũmbũkaga na tũthiiagĩra thĩ na magũrũ mana nĩ mwagĩrĩirwo nĩ gũtũthũũra mũno. ");
INSERT INTO kik_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","No nĩ kũrĩ tũnyamũ tũmwe tũrĩ mathagu na tũthiiaga na magũrũ mana tũrĩa mũngĩrĩa; natuo nĩ tũrĩa tũrĩ na magũrũ marĩ nyunĩro ma gũtũteithia kũrũga. ");
INSERT INTO kik_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Thĩinĩ wa tuo no mũrĩe mĩthemba yothe ya ngigĩ, na ndararĩki, na ngiria, o na kana ndaahi. ");
INSERT INTO kik_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","No tũnyamũ tũu tũngĩ tuothe tũrĩ mathagu na tũrĩ na magũrũ mana no nginya mũtũthũũre mũno. ");
INSERT INTO kik_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Nĩmũgethaahia na maũndũ maya; ũrĩa wothe ũngĩhutia ciimba ciatuo agaatinda arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Mũndũ o wothe ũkooya kĩimba gĩatuo no nginya athambie nguo ciake, na nĩagatinda arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Nyamũ o yothe ĩrekanĩtie mahũngũ no matirekanĩtie biũ, kana ĩrĩa ĩtacookagia ithagumia, ĩyo ĩrĩ thaahu harĩ inyuĩ; mũndũ o wothe ũkaahutia kĩimba kĩa ĩmwe yacio nĩakanyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Harĩ nyamũ ciothe iria ithiiaga na magũrũ mana-rĩ, iria ikinyaga na ithu irĩ thaahu harĩ inyuĩ; mũndũ ũrĩa wothe ũkaahutia ciimba ciacio agaatinda arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Mũndũ o wothe ũngĩoya ciimba ciacio no nginya athambie nguo ciake, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. Icio irĩ thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Harĩ nyamũ ciothe iria ithiiagĩra thĩ, ici nĩcio irĩ thaahu harĩ inyuĩ: mũrũngũru na mbĩa, na njagathi iria nene cia mĩthemba yothe, ");
INSERT INTO kik_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","na gĩthenyũka, na kĩgurumũki, na njagathi, na gĩcagathi kĩrĩa kĩa mahiga-inĩ, na kĩĩmbu. ");
INSERT INTO kik_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Harĩ iria ciothe ithiiagĩra thĩ, ici irĩ thaahu harĩ inyuĩ. Mũndũ o wothe ũngĩcihutia ikuĩte-rĩ, agaatinda arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Rĩrĩa ĩmwe yacio ĩngĩkua na ĩgũĩre kĩndũ, kĩndũ kĩu o na kĩngĩkorwo kĩrĩ kĩa wĩra ũrĩkũ, nĩgĩkanyiitwo nĩ thaahu, o na aakorwo gĩthondeketwo na mbaũ, kana gĩtambaya, kana rũũa kana ikũnia. Nĩkĩrindwo maaĩ-inĩ; gĩgaakorwo kĩrĩ na thaahu o nginya hwaĩ-inĩ, na nĩgĩgacooka gĩthirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Nyamũ ĩmwe ya icio ĩngĩgũa thĩinĩ wa nyũngũ ya rĩũmba-rĩ, kĩndũ kĩrĩa gĩothe kĩrĩ thĩinĩ wayo nĩgĩkanyiitwo nĩ thaahu, na no nginya mũũrage nyũngũ ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Irio o ciothe ingĩrĩĩo no ikorwo irĩ na maaĩ moimĩte nyũngũ-inĩ ta ĩyo irĩ na thaahu, na kĩndũ o gĩothe gĩa kũnyuuo kiumĩte thĩinĩ wayo kĩrĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Kĩndũ o gĩothe kĩngĩkaagwĩrwo nĩ kĩimba kĩmwe gĩacio, nĩgĩkanyiitwo nĩ thaahu; riiko kana nyũngũ ya kũruga no nginya ciũragwo. Indo icio irĩ na thaahu, nacio indo icio nĩigatuĩka thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","No rĩrĩ, gĩthima kana irima rĩa maaĩ, icio itingĩnyiitwo nĩ thaahu, no mũndũ o wothe ũkaahutia kĩimba kĩmwe kĩa indo icio irĩ thaahu nĩakanyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kĩimba kĩngĩkaagwĩra mbeũ o na irĩkũ cia kũhaandwo, itikanyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","No mbeũ icio ingĩkorwo irindĩtwo maaĩ-inĩ, nakĩo kĩimba gĩcigũĩre, mbeũ icio irĩ na thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Nyamũ ĩrĩa mwĩtĩkĩrĩtio kũrĩa ĩngĩkua, mũndũ o wothe ũkaahutia kĩimba kĩayo agaatinda arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Mũndũ o wothe ũngĩrĩa nyama cia kĩimba kĩu no nginya athambie nguo ciake, nake agaatinda arĩ na thaahu o nginya hwaĩ-inĩ. Mũndũ o wothe ũngĩoya kĩimba kĩu no nginya athambie nguo ciake, nake atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Kĩũmbe gĩothe kĩrĩa gĩtambaga thĩ nĩgĩthũũre; ti gĩa kũrĩĩo. ");
INSERT INTO kik_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Mũtikanarĩe kĩũmbe gĩothe kĩrĩa gĩtambaga thĩ, kana gĩthiiaga na nda, kana na magũrũ mothe mana, kana magũrũ maingĩ; icio mũcithũũre mũno. ");
INSERT INTO kik_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Mũtikanethaahie na kĩũmbe o na kĩmwe gĩacio. Mũtikaneĩkĩre thaahu nĩ ũndũ wacio kana mũreke imũgwatie thaahu. ");
INSERT INTO kik_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Niĩ nĩ niĩ Jehova Ngai wanyu; mwĩamũrei na mwĩtherie, tondũ niĩ ndĩ mũtheru. Mũtikanethaahie na kĩũmbe o gĩothe kĩrĩa gĩtambaga thĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Niĩ nĩ niĩ Jehova ũrĩa wamũrutire kuuma bũrũri wa Misiri nduĩke Ngai wanyu; nĩ ũndũ ũcio mwĩtheriei, tondũ niĩ ndĩ mũtheru. ");
INSERT INTO kik_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Macio nĩmo mawatho marĩa makoniĩ nyamũ, na nyoni, na kĩndũ gĩothe kĩrĩ muoyo kĩrĩa gĩthiiagĩra maaĩ-inĩ, na kĩũmbe o ro gĩothe kĩrĩa gĩtambaga thĩ. ");
INSERT INTO kik_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","No nginya mũkũũranage nyamũ iria irĩ thaahu na iria itarĩ thaahu, na mũkũũranage ciũmbe iria irĩ muoyo ingĩrĩĩo na iria itangĩrĩĩo.’ ” ");
INSERT INTO kik_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Ĩra andũ a Isiraeli ũũ: ‘Mũndũ-wa-nja angĩgĩa nda aciare kahĩĩ, nĩagaikara arĩ na thaahu mĩthenya mũgwanja o ta ũrĩa aikaraga arĩ na thaahu ihinda rĩake rĩa mweri. ");
INSERT INTO kik_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Na mũthenya wa kanana wakinya, kahĩĩ kau nĩgakaaruithio. ");
INSERT INTO kik_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Nake mũndũ-wa-nja ũcio no nginya eterere mĩthenya mĩrongo ĩtatũ na ĩtatũ nĩguo atherio thaahu wa kuura thakame. Ndakanahutie kĩndũ kĩamũre kana atoonye handũ-harĩa-haamũre o nginya matukũ ma gũtherio gwake mathire. ");
INSERT INTO kik_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","No angĩciara mwana wa kairĩtu, agaaikara arĩ na thaahu ciumia igĩrĩ, o ta ũrĩa aikaraga arĩ na thaahu ihinda rĩake rĩa mweri. Ningĩ no nginya eterere mĩthenya mĩrongo ĩtandatũ na ĩtandatũ nĩguo atherio thaahu wa kuura thakame. ");
INSERT INTO kik_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Hĩndĩ ĩrĩa matukũ make ma gũtherio, marĩ ma kahĩĩ kana ma kairĩtu, makahinga-rĩ, nĩakarehera mũthĩnjĩri-Ngai gatũrũme ka mwaka ũmwe hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, karĩ iruta rĩa njino, na atware gatutura kana ndirahũgĩ ya iruta rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Nake mũthĩnjĩri-Ngai nĩagacirutĩra hau mbere ya Jehova nĩguo amũhoroherie, nake mũndũ-wa-nja ũcio nĩagathirwo nĩ thaahu wa kuuma gwa thakame. “ ‘Macio nĩmo mawatho ma mũndũ-wa-nja ũrĩa ũciarĩte kahĩĩ kana kairĩtu. ");
INSERT INTO kik_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Angĩkorwo ndangĩhota kũruta gatũrũme, nĩakaruta ndirahũgĩ igĩrĩ kana tũtutuura twĩrĩ, kamwe ka iruta rĩa njino na karĩa kangĩ ka iruta rĩa kũhoroherio mehia. Ũguo nĩguo mũthĩnjĩri-Ngai akaamũhoroheria, nake mũndũ-wa-nja ũcio nĩagathera.’ ” ");
INSERT INTO kik_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ningĩ Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Hĩndĩ ĩrĩa mũndũ o wothe angĩgĩa na handũ haimbu, kana mũtũnda, kana handũ hakaragacũku ngoothi-inĩ yake, harĩa hangĩtuĩka mũrimũ wa ngoothi ũngĩgwatanio-rĩ, no nginya atwarwo kũrĩ Harũni, ũrĩa mũthĩnjĩri-Ngai, kana kũrĩ ũmwe wa ariũ ake ũrĩa mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Nake mũthĩnjĩri-Ngai arore kĩronda kĩu kĩrĩ ngoothi-inĩ yake, na angĩkorwo njuĩrĩ ya handũ hau harũaru nĩĩgarũrũkĩte ĩkerũha, na kĩronda kĩu kĩonwo kĩrikĩire thĩinĩ wa mwĩrĩ gũkĩra harĩa ngoothi yakinya-rĩ, ũcio nĩ mũrimũ wa ngoothi ũngĩgwatanio. Nake mũthĩnjĩri-Ngai aarĩkia kũmũrora, nĩagacooka atue atĩ mũndũ ũcio arĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Angĩkorwo kĩmeni kĩu arĩ nakĩo ngoothi-inĩ yake nĩkĩerũhĩte na gĩtirikĩire ngoothi-inĩ, nayo njuĩrĩ yaho ndĩerũhĩte-rĩ, mũthĩnjĩri-Ngai nĩakaiga mũndũ ũcio mũrũaru handũ mwanya mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Mũthenya wa mũgwanja, mũthĩnjĩri-Ngai nĩakamũrora na angĩkoona atĩ kĩronda gĩtigarũrũkĩte na gĩtithegeete-rĩ, nĩakamũiga handũ mwanya mĩthenya ĩngĩ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mũthenya wa mũgwanja mũthĩnjĩri-Ngai, nĩakamũrora o rĩngĩ, na angĩkorwo kĩronda kĩu nĩkĩrathira na gĩtithegeete ngoothi-inĩ-rĩ, mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio ndarĩ na thaahu; ĩyo no mĩtũnda. Mũndũ ũcio no nginya athambie nguo ciake, nake nĩagathera, athirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","No mũtũnda ũcio ũngĩthegea ngoothi-inĩ yake thuutha wa kwĩonania harĩ mũthĩnjĩri-Ngai, nĩguo atuĩke ndarĩ na thaahu, no nginya acooke kũrĩ mũthĩnjĩri-Ngai rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Mũthĩnjĩri-Ngai ũcio nĩakamũrora, na angĩkorwo mũtũnda ũthegeete ngoothi-inĩ, nĩakamũtua atĩ arĩ na thaahu; ũcio nĩ mũrimũ wa ngoothi ũrĩa ũngĩgwatanio. ");
INSERT INTO kik_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Rĩrĩa mũndũ o wothe angĩgĩa na mũrimũ wa ngoothi ũngĩgwatanio-rĩ, no nginya atwarwo harĩ mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Mũthĩnjĩri-Ngai nĩakamũrora, na hangĩkorwo harĩ na handũ haimbu hakeerũha ngoothi-inĩ hagatũma njuĩrĩ yerũhe, na angĩkorwo handũ hau haimbu nĩhatũrĩkĩte hakagĩa kĩronda-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ũcio nĩ mũrimũ wa ngoothi ũtangĩhona, nake mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio arĩ na thaahu. Ndakamũiga handũ mwanya, tondũ mũndũ ũcio nĩarĩkĩtie kũgĩa na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“No rĩrĩ, mũrimũ ũcio ũngĩhunja ngoothi-inĩ yake yothe, na harĩa hothe mũthĩnjĩri-Ngai angĩhota kuona oone atĩ mũrimũ ũcio ũiyũrĩte ngoothi-inĩ ya mũndũ ũcio mũrũaru kuuma mũtwe nginya magũrũ-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","mũthĩnjĩri-Ngai ũcio nĩakamũrora, na aakorwo mũrimũ ũcio nĩ ũiyũrĩte mwĩrĩ wake wothe, nĩagatua atĩ mũndũ ũcio ndarĩ na thaahu. Kuona atĩ nĩerũhĩte kũndũ guothe-rĩ, ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","No hĩndĩ ĩrĩa yothe mũndũ ũcio angĩonwo arĩ na ironda-rĩ, nĩagatuĩka arĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Rĩrĩa mũthĩnjĩri-Ngai angĩona kĩronda-rĩ, nĩagatua atĩ mũndũ ũcio arĩ na thaahu. Kĩronda kĩu kĩrĩ na thaahu; mũndũ ũcio arĩ na mũrimũ ũngĩgwatanio. ");
INSERT INTO kik_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","No kĩronda kĩu kĩngĩgarũrũka kĩerũhe, no nginya mũndũ ũcio athiĩ harĩ mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Nake mũthĩnjĩri-Ngai ũcio nĩakamũrora, na aakorwo ironda nĩcierũhĩte-rĩ, mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio mũrũaru ndarĩ na thaahu, nake nĩagatuĩka ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Rĩrĩa mũndũ angĩgĩa na ihũha ngoothi-inĩ yake na rĩcooke rĩhone, ");
INSERT INTO kik_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","naho hau ihũha rĩraarĩ haimbe na herũhe, kana hagĩe na kameni gatune-rĩ, no nginya athiĩ akeyonanie kũrĩ mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Mũthĩnjĩri-Ngai ũcio nĩakarora handũ hau, na hangĩoneka nĩ harikĩire gũkĩra ngoothi, na njuĩrĩ ciaho ikerũha, mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio arĩ na thaahu. Nĩ mũrimũ wa ngoothi ũngĩgwatanio ũtuthũkĩte harĩa ihũha rĩu rĩraarĩ. ");
INSERT INTO kik_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","No, mũthĩnjĩri-Ngai angĩrora handũ hau one hatirĩ na njuĩrĩ njerũ thĩinĩ waho, na hatirikĩire gũkĩra ngoothi, na nĩhahohete-rĩ, hĩndĩ ĩyo mũthĩnjĩri-Ngai nĩakamũiga handũ mwanya ihinda rĩa mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kũngĩkorwo kĩronda kĩa ihũha rĩu nĩkĩrathegea ngoothi-inĩ, mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio arĩ na thaahu; ũcio nĩ mũrimũ ũngĩgwatanio. ");
INSERT INTO kik_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","No handũ hau hangĩkorwo hatigarũrũkĩte na hatithegeete, kĩu no kĩrema kĩa ihũha, nake mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Mũndũ angĩgĩa na ihĩa ngoothi-inĩ yake, narĩo ihĩa rĩu rĩgĩe na kĩronda gĩtunĩhe kana kĩerũhe-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","mũthĩnjĩri-Ngai ũcio nĩakarora handũ hau, na angĩkorwo njuĩrĩ ciaho nĩcierũhĩte, na hakorwo hakĩoneka harikĩire gũkĩra ngoothi-rĩ, ũcio nĩ mũrimũ ũngĩgwatanio ũtũrĩkĩire ihĩa-inĩ rĩu. Nake mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio arĩ na thaahu; ũcio nĩ mũrimũ wa ngoothi ũngĩgwatanio. ");
INSERT INTO kik_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","No mũthĩnjĩri-Ngai angĩkaarora one atĩ hatirĩ na njuĩrĩ njerũ kĩrema-inĩ kĩu na ti harikĩru gũkĩra ngoothi yake na nĩhahohete-rĩ, thuutha ũcio mũthĩnjĩri-Ngai nĩakamũiga handũ mwanya mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Mũthenya wa mũgwanja mũthĩnjĩri-Ngai nĩakamũrora rĩngĩ, naguo mũrimũ ũcio ũngĩkorwo nĩũrathegea ngoothi-inĩ-rĩ, mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio arĩ na thaahu; ũcio nĩ mũrimũ wa ngoothi ũngĩgwatanio. ");
INSERT INTO kik_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","No handũ hau hangĩkorwo hatigarũrũkĩte, na hatithegeete ngoothi-inĩ, no nĩhahohete, ũcio nĩ ũimbu wa ihĩa rĩu, nake mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio ndarĩ na thaahu; kĩu no kĩrema kĩa ihĩa. ");
INSERT INTO kik_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Mũndũ mũrũme kana mũndũ-wa-nja angĩkorwo na kĩronda mũtwe kana kĩreru-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","mũthĩnjĩri-Ngai nĩakarora kĩronda kĩu, na kĩngĩoneka kĩrikĩire gũkĩra ngoothi, nayo njuĩrĩ yaho ĩkorwo nĩ ya rangi wa ngoikoni, na ĩkorwo ĩrĩ njeke, mũthĩnjĩri-Ngai nĩagatua atĩ mũndũ ũcio arĩ na thaahu; ũcio nĩ ũhere, nĩ mũrimũ wa mangũ ma mũtwe kana ma kĩreru. ");
INSERT INTO kik_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","No hĩndĩ ĩrĩa mũthĩnjĩri-Ngai angĩrora kĩronda kĩa mũthemba ũcio, na gĩkorwo ti kĩrikĩru gũkĩra ngoothi, na hatirĩ njuĩrĩ njirũ thĩinĩ wakĩo, hĩndĩ ĩyo mũthĩnjĩri-Ngai nĩakaiga mũndũ ũcio mũrũaru handũ mwanya mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Mũthenya wa mũgwanja, mũthĩnjĩri-Ngai ũcio nĩakarora kĩronda kĩu rĩngĩ na angĩkorwo ũhere ũcio ndũthegeete na hatirĩ njuĩrĩ cia rangi wa ngoikoni, na gĩtikuoneka kĩrikĩire gũkĩra ngoothi-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","no nginya mũndũ ũcio enjwo tiga o harĩa harũaru, nake mũthĩnjĩri-Ngai nĩakamũiga handũ mwanya mĩthenya ĩngĩ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Mũthenya wa mũgwanja, mũthĩnjĩri-Ngai ũcio nĩakarora ũhere ũcio o rĩngĩ, na angĩkorwo ndũthegeete ngoothi-inĩ na ndũkuoneka ũrikĩire gũkĩra ngoothi-rĩ, mũthĩnjĩri-Ngai ũcio nĩagatua atĩ mũndũ ũcio ndarĩ na thaahu. No no nginya athambie nguo ciake, na nĩagatuĩka ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","No, ũhere ũcio, ũngĩthegea ngoothi-inĩ thuutha wa mũndũ ũcio gũtuuo atĩ ndarĩ na thaahu-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","mũthĩnjĩri-Ngai ũcio nĩakamũrora na angĩkorwo ũhere ũcio nĩũthegeete ngoothi-inĩ, mũthĩnjĩri-Ngai ũcio ndakabatario nĩkũrora njuĩrĩ cia rangi wa ngoikoni; mũndũ ũcio arĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","No mũthĩnjĩri-Ngai angĩkoona atĩ hatirĩ na ũgarũrũku na nĩhamerete njuĩrĩ njirũ, ũhere ũcio nĩũhonete. Mũndũ ũcio ndarĩ na thaahu, nake Mũthĩnjĩri-Ngai nĩakamũtua ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Hĩndĩ ĩrĩa mũndũ mũrũme kana mũndũ-wa-nja angĩgĩa na tũmeni twerũ ngoothi-inĩ-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","mũthĩnjĩri-Ngai nĩagatũrora, na tuo tũngĩkorwo ti twerũ mũno-rĩ, ũcio nĩ mũtũnda ũtangĩrwaria mũndũ ũtuthũkĩte ngoothi-inĩ; mũndũ ũcio ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Hĩndĩ ĩrĩa mũndũ angĩmunyũka njuĩrĩ na agĩe na kĩhara-rĩ, ũcio ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Angĩkorwo amunyũkĩte njuĩrĩ ĩrutĩtie na thiithi akagĩa kĩhara kĩa na mbere, ũcio ndarĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","No angĩkorwo arĩ na kĩronda gĩtune kĩhara-inĩ kana thiithi-inĩ wake-rĩ, ũcio nĩ mũrimũ ũngĩgwatanio ũratuthũka kĩhara-inĩ kana thiithi-inĩ wake. ");
INSERT INTO kik_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Mũthĩnjĩri-Ngai nĩakamũrora, na angĩkorwo kĩronda kĩu kĩimbĩte kĩhara-inĩ kana thiithi-inĩ nĩ gĩtune gĩkahaana ta mũrimũ wa ngoothi ũngĩgwatanio-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","mũndũ ũcio nĩ mũrũaru na arĩ na thaahu. Mũthĩnjĩri-Ngai nĩakamũtua arĩ na thaahu nĩ ũndũ wa kĩronda kĩu kĩrĩ mũtwe wake. ");
INSERT INTO kik_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Mũndũ ũrĩ na mũrimũ ta ũcio ũngĩgwatanio-rĩ, no nginya ehumbe nguo ndarũku, na arekererie njuĩrĩ yake, na ahumbĩre kanua gake, athiĩ akĩanagĩrĩra akiugaga atĩrĩ, ‘Ndĩ na thaahu! Ndĩ na thaahu!’ ");
INSERT INTO kik_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Rĩrĩa rĩothe mũndũ ũcio arĩ na mũrimũ ũcio, arĩkoragwo arĩ na thaahu. No nginya atũũrage wiki, na no nginya atũũrage nja ya kambĩ. ");
INSERT INTO kik_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Nguo o na ĩrĩkũ ĩngĩguma, ĩrĩ ya guoya wa ngʼondu kana ya gatani, ");
INSERT INTO kik_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kana ya taama o wothe ũtumĩtwo na ndigi njogothe kana taama wa gatani, kana guoya wa ngʼondu, kana rũũa o ruothe, kana kĩndũ o gĩothe gĩthondeketwo na rũũa-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","na angĩkorwo ũgumu ũcio ũrĩ nguo-inĩ, kana rũũa-inĩ, kana taama-inĩ wa ndigi njogothe, kana taama-inĩ o wothe mũtume, kana kĩndũ-inĩ o gĩothe gĩtumĩtwo na rũũa-rĩ, ũgumu ũcio ũngĩkorwo na rangi ta wa nyeki nduru kana mũtune, ũcio nĩ ũgumu ũrathegea, na no nginya wonio mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Mũthĩnjĩri-Ngai nĩakarora ũgumu ũcio, na aige kĩndũ kĩu kĩrĩ na ũgumu handũ mwanya mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Mũthenya wa mũgwanja nĩakarora kĩndũ kĩu, na angĩkorwo ũgumu ũcio nĩũthegeete nguo-inĩ, kana ndigi-inĩ njogothe, kana taama-inĩ mũtume, kana rũũa-inĩ, rũrĩ rwa kũrutĩrwo wĩra o na ũrĩkũ, ũcio nĩ ũgumu wa kwananga; kĩndũ kĩu kĩrĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","No nginya acine nguo ĩyo, kana ndigi icio njogothe, kana taama ũcio mũtume na guoya wa ngʼondu kana gatani, kana kĩndũ kĩngĩ gĩothe kĩa rũũa rũrĩa rũgwatie ũgumu ũcio, nĩ ũndũ ũgumu ũcio nĩ wa kwananga; kĩndũ kĩu no nginya gĩcinwo. ");
INSERT INTO kik_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“No rĩrĩ, rĩrĩa mũthĩnjĩri-Ngai angĩrora kĩndũ kĩu, ũgumu ũcio ũkorwo ndũthegeete nguo-inĩ ĩyo, kana ndigi-inĩ icio njogothe kana taama-inĩ ũcio mũtume, kana kĩndũ kĩa rũũa-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","nĩagaathana kĩndũ kĩu kĩgwatĩtio ũgumu gĩthambio. Ningĩ nĩagakĩiga handũ mwanya mĩthenya ĩngĩ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Thuutha wa kĩndũ kĩu kĩgwatie ũgumu gũthambio-rĩ, mũthĩnjĩri-Ngai nĩagakĩrora, na angĩkorwo ũgumu ũcio ndũrĩ ũndũ ũgarũrũkĩte, o na gũtuĩka ndũthegeete-rĩ, kĩndũ kĩu kĩrĩ na thaahu. Nĩgĩcinwo na mwaki, o na aakorwo ũgumu ũnyiitĩte mwena ũmwe kana ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Hĩndĩ ĩrĩa mũthĩnjĩri-Ngai angĩrora kĩndũ kĩu na akore ũgumu ũcio ũnyihanyiihĩte thuutha wa kĩndũ kĩu gũthambio-rĩ, nĩagatembũra nguo ĩyo eherie hau he na ũgumu kuuma nguo-inĩ ĩyo, kana rũũa-inĩ, kana ndigi-inĩ icio njogothe, kana taama-inĩ ũcio mũtume. ");
INSERT INTO kik_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","No ũgumu ũcio ũngĩcooka woneke nguo-inĩ, kana harĩ ndigi icio njogothe, kana taama ũcio mũtume, kana kĩndũ kĩa rũũa, ũgumu ũcio nĩgũthegea ũrathegea, na kĩrĩa gĩothe kĩrĩ na ũgumu ũcio no nginya gĩcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Nguo ĩyo, kana ndigi icio njogothe, kana taama mũtume, kana kĩndũ kĩa rũũa kĩrĩa gĩthambĩtio gĩkaniinwo ũgumu ũcio no nginya gĩthambio rĩngĩ, na nĩ gĩgaathirwo nĩ thaahu.” ");
INSERT INTO kik_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Macio nĩmo mawatho marĩa makoniĩ indo inyiitĩtwo nĩ ũgumu, irĩ cia guoya wa ngʼondu, kana taama wa gatani, kana ndigi njogothe, kana taama mũtume, kana kĩndũ o gĩothe kĩa rũũa, nĩmo mawatho ma gũtua kana indo icio irĩ na thaahu kana itirĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Maya nĩmo mawatho makoniĩ mũndũ mũrũaru hĩndĩ yake ya gũtherio thaahu, rĩrĩa aarehwo kũrĩ mũthĩnjĩri-Ngai: ");
INSERT INTO kik_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Mũthĩnjĩri-Ngai nĩakoima nja ya kambĩ amũrore. Angĩkorwo mũndũ ũcio nĩahonete mũrimũ ũcio wa kũgwatanio wa ngoothi, ");
INSERT INTO kik_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","mũthĩnjĩri-Ngai nĩagaathana areherwo nyoni igĩrĩ irĩ muoyo na itarĩ na thaahu, na kamũtĩ ka mũtarakwa, na rũrigi rwa rangi wa gakarakũ, na mũthobi irehwo nĩ ũndũ wa mũndũ ũcio ũgũtherio. ");
INSERT INTO kik_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Mũthĩnjĩri-Ngai acooke aathane atĩ nyoni ĩmwe yacio ĩthĩnjĩrwo igũrũ rĩa nyũngũ ya rĩũmba ĩrĩ na maaĩ matahĩtwo o hĩndĩ ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ningĩ acooke oe nyoni ĩyo ĩrĩ muoyo, amĩtobokie, hamwe na kamũtĩ kau ka mũtarakwa, na rũrigi rũu rwa gakarakũ na mũthobi thĩinĩ wa thakame ya nyoni ĩyo ĩthĩnjĩirwo igũrũ wa maaĩ macio matahĩtwo o hĩndĩ ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Mũthĩnjĩri-Ngai nĩakaminjĩria mũndũ ũcio ũratherio mũrimũ ũcio ũngĩgwatanio thakame ĩyo maita mũgwanja, na acooke oige atĩ mũndũ ũcio ndarĩ na thaahu. Ningĩ acooke arekererie nyoni ĩyo ĩngĩ ĩrĩ muoyo yũmbũke ĩthiĩ werũ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Mũndũ ũcio ũtheretio no nginya athambie nguo ciake, no nginya enjwo njuĩrĩ yake yothe na ethambe na maaĩ nĩguo athirwo nĩ thaahu. Thuutha ũcio, no atoonye kambĩ; no rĩrĩ, no nginya aikare nja ya hema yake mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Mũthenya wa mũgwanja no nginya enjwo njuĩrĩ yake yothe; no nginya enjwo mũtwe, na nderu, na ngobe, na njuĩrĩ iria ingĩ ciake ciothe. Na no nginya athambie nguo ciake na ethambe na maaĩ, nake nĩagathirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Mũthenya wa kanana wakinya, no nginya atwarĩre mũthĩnjĩri-Ngai tũtũrũme twĩrĩ na kamwatĩ, o kamwe ka ũkũrũ wa mwaka ũmwe, na ciothe ikorwo itarĩ na kaũũgũ, atware hamwe na icunjĩ ithatũ cia ikũmi cia eba ya mũtu mũhinyu ũtukanĩtio na maguta nĩ ũndũ wa iruta rĩa mũtu, na kabakũri kamwe ka maguta. ");
INSERT INTO kik_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Mũthĩnjĩri-Ngai ũrĩa ũgaatua atĩ mũndũ ũcio ndarĩ na thaahu nĩagatwara mũndũ ũcio ũratherio hamwe na maruta make mbere ya Jehova hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Ningĩ mũthĩnjĩri-Ngai ũcio nĩakoya gatũrũme kamwe gatuo, akarute karĩ iruta rĩa mahĩtia, hamwe na kabakũri kau ka maguta; nĩagacithũngũthĩria hau mbere ya Jehova ituĩke iruta rĩa gũthũngũthio. ");
INSERT INTO kik_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Nĩagathĩnjĩra gatũrũme kau handũ harĩa hatheru, harĩa iruta rĩa kũhoroherio mehia na iruta rĩa njino ithĩnjagĩrwo. O ta ũrĩa iruta rĩa kũhoroherio mehia rĩrĩ rĩa mũthĩnjĩri-Ngai-rĩ, no taguo iruta rĩa mahĩtia rĩrĩ rĩake, rĩu nĩ iruta itheru mũno makĩria. ");
INSERT INTO kik_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Mũthĩnjĩri-Ngai ũcio nĩakoya thakame ĩmwe ya iruta rĩu rĩa mahĩtia na amĩhake moni ya gũtũ kwa ũrĩo kwa mũndũ ũcio ũratherio, na kĩara kĩrĩa kĩnene gĩa guoko gwake kwa ũrĩo, na kĩara kĩrĩa kĩnene gĩa kũgũrũ gwake kwa ũrĩo. ");
INSERT INTO kik_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Mũthĩnjĩri-Ngai nĩagacooka oe maguta mamwe marĩa marĩ kabakũri-inĩ amaitĩrĩre rũhĩ rwake rwa mwena wa ũmotho, ");
INSERT INTO kik_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","acooke atobokie kĩara gĩake kĩa muoroto kĩa ũrĩo maguta-inĩ macio marĩ rũhĩ rwake, aminjaminje maguta mamwe ma macio marĩ kĩara gĩake mbere ya Jehova maita mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Mũthĩnjĩri-Ngai ũcio nĩakoya maguta mamwe ma marĩa matigaire rũhĩ rwake amahake moni ya gũtũ kwa ũrĩo kwa mũndũ ũcio ũratherio, na kĩara kĩrĩa kĩnene gĩa guoko gwake kwa ũrĩo, na kĩara kĩrĩa kĩnene gĩa kũgũrũ gwake kwa ũrĩo, igũrũ rĩa thakame ĩyo ya iruta rĩa mahĩtia. ");
INSERT INTO kik_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Namo maguta macio mangĩ marĩ rũhĩ rwake, mũthĩnjĩri-Ngai nĩakamahaka mũtwe wa mũndũ ũcio ũratherio nĩguo amũhoroherie hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Ningĩ mũthĩnjĩri-Ngai nĩakaruta igongona rĩa kũhoroherio mehia ahoroherie mũndũ ũcio ũratherio thaahu wake. Thuutha ũcio, mũthĩnjĩri-Ngai nĩagathĩnja iruta rĩa njino ");
INSERT INTO kik_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","na arĩrutĩre kĩgongona-inĩ, hamwe na iruta rĩa mũtu nĩguo amũhoroherie, nake athirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“No rĩrĩ angĩkorwo mũndũ ũcio nĩ mũthĩĩni na ndangĩhota kũruta indo icio, no nginya arute gatũrũme kamwe gatuĩke iruta rĩa mahĩtia rĩa gũthũngũthio nĩguo rĩmũhoroherie, hamwe na gĩcunjĩ gĩa ikũmi kĩa eba ya mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, rĩtuĩke iruta rĩa mũtu, na kabakũri ka maguta, ");
INSERT INTO kik_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","na ndirahũgĩ igĩrĩ kana tũtutuura twĩrĩ, o iria angĩhota kũruta, ĩmwe ĩtuĩke ya iruta rĩa kũhoroherio mehia, na ĩrĩa ĩngĩ ya iruta rĩa njino. ");
INSERT INTO kik_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Mũthenya wa kanana wakinya no nginya acirehe kũrĩ mũthĩnjĩri-Ngai hau itoonyero rĩa Hema-ya-Gũtũnganwo nĩgeetha athererio hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Nake mũthĩnjĩri-Ngai nĩakoya gatũrũme kau ka iruta rĩa mahĩtia, hamwe na kabakũri ka maguta, acithũngũthĩrie mbere ya Jehova ituĩke iruta rĩa gũthũngũthio. ");
INSERT INTO kik_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Nĩagathĩnja gatũrũme ka iruta rĩa mahĩtia na acooke oe thakame ĩmwe yako amĩhake moni ya gũtũ kwa ũrĩo kwa mũndũ ũcio ũratherio, na amĩhake kĩara kĩrĩa kĩnene gĩa guoko gwake kwa ũrĩo na kĩara kĩrĩa kĩnene gĩa kũgũrũ gwake kwa ũrĩo. ");
INSERT INTO kik_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Mũthĩnjĩri-Ngai nĩagekĩra maguta mamwe rũhĩ rwa mwena wake wa ũmotho, ");
INSERT INTO kik_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","na aminjaminje maguta mamwe ma macio marĩ rũhĩ rwake na kĩara kĩa muoroto gĩa guoko gwake kwa ũrĩo, hau mbere ya Jehova, maita mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Maguta mamwe ma macio marĩ rũhĩ rwake amahake o harĩa aahakĩte thakame ya iruta rĩa mahĩtia, moni-inĩ ya gũtũ kwa ũrĩo kwa mũndũ ũcio ũratherio, na kĩara kĩrĩa kĩnene gĩa guoko gwake kwa ũrĩo na kĩara kĩrĩa kĩnene gĩa kũgũrũ gwake kwa ũrĩo. ");
INSERT INTO kik_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Namo maguta macio mangĩ marĩ rũhĩ rwake, mũthĩnjĩri-Ngai nĩakamahaka mũtwe wa mũndũ ũcio ũratherio, nĩguo amũhoroherie hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Ningĩ nĩakaruta igongona rĩa ndirahũgĩ kana tũtutuura, o iria mũndũ ũcio angĩhota kũruta, ");
INSERT INTO kik_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ĩmwe ĩrĩ iruta rĩa kũhoroherio mehia na ĩyo ĩngĩ ĩrĩ iruta rĩa njino, o hamwe na iruta rĩa mũtu. Ũguo nĩguo mũthĩnjĩri-Ngai akaahoroheria mũndũ ũcio ũratherio hau mbere ya Jehova.” ");
INSERT INTO kik_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Macio nĩmo mawatho makoniĩ mũndũ o wothe ũrĩa ũrĩ na mũrimũ wa ngoothi ũngĩgwatanio, na ndangĩhota kũruta iruta rĩrĩa rĩathanĩtwo rĩa gũtherio gwake. ");
INSERT INTO kik_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ningĩ Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Rĩrĩa mũgaakinya bũrũri wa Kaanani, ũrĩa ngũmũhe ũtuĩke igai rĩanyu, na niĩ njĩkĩre ũgumu ũgũthegea nyũmba thĩinĩ bũrũri-inĩ ũcio-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","mwene nyũmba ĩyo no nginya athiĩ akeere mũthĩnjĩri-Ngai atĩrĩ, ‘Nĩnyonete kĩndũ kĩhaana ta ũgumu thĩinĩ wa nyũmba yakwa.’ ");
INSERT INTO kik_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Mũthĩnjĩri-Ngai ũcio nĩagaathana indo ciothe irutwo nyũmba ĩyo atanatoonya kũrora ũgumu ũcio, nĩgeetha gũtikagĩe kĩndũ o na kĩmwe kĩrĩ nyũmba ĩyo kĩngĩtuuo atĩ kĩrĩ na thaahu. Thuutha wa ũguo mũthĩnjĩri-Ngai nĩagatoonya arore nyũmba ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Nĩakarora ũgumu rũthingo-inĩ, na aakorwo rũrĩ na tũrima twa rangi ta wa nyeki nduru kana wa rangi mũtune tũhaana ta tũtoonyete thĩinĩ wa rũthingo-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","mũthĩnjĩri-Ngai ũcio nĩakoima nja ya nyũmba ĩyo na acooke amĩhinge gwa kahinda ka mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Mũthenya wa mũgwanja wakinya, mũthĩnjĩri-Ngai nĩagacooka athiĩ arore nyũmba ĩyo. Angĩona ũgumu ũcio nĩũthegeete thingo-inĩ, ");
INSERT INTO kik_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","nĩagaathana mahiga marĩa marĩ na ũgumu mamomorwo na mateo handũ hatarĩ hatheru na kũu nja ya itũũra. ");
INSERT INTO kik_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Nĩagaathana thingo ciothe ikũrũrwo mwena wa na thĩinĩ, namo makũrũro macio mateo kĩara-inĩ na kũu nja ya itũũra. ");
INSERT INTO kik_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ningĩ moe mahiga mangĩ make namo mathenya macio mamomoretwo, na macooke moe rĩũmba rĩerũ mathinge nyũmba ĩyo narĩo. ");
INSERT INTO kik_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ũgumu ũcio ũngĩcooka woneke rĩngĩ nyũmba-inĩ ĩyo, thuutha wa mahiga macio kũmomorwo, na thingo icio gũkũrũrwo na igathiingwo rĩngĩ-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","mũthĩnjĩri-Ngai nĩagacooka athiĩ amĩrore rĩngĩ, na angĩona ũgumu ũcio nĩũthegeete nyũmba-inĩ ĩyo, ũcio nĩ ũgumu wa kwananga; nyũmba ĩyo ĩrĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","No nginya ĩmomorwo: mahiga mayo, na mbaũ, na thingo ciothe, nacio indo icio itwarwo handũ hatarĩ hatheru na kũu nja ya itũũra. ");
INSERT INTO kik_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Mũndũ o wothe ũngĩtoonya nyũmba ĩyo hĩndĩ ĩyo ĩrĩ hinge nĩakanyiitwo nĩ thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Mũndũ o wothe ũngĩkoma kana arĩĩre irio nyũmba ĩyo, no nginya athambie nguo ciake. ");
INSERT INTO kik_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“No rĩrĩ, mũthĩnjĩri-Ngai angĩũka kũmĩrora akore atĩ ũgumu ũcio ndũthegeete thuutha wa nyũmba ĩyo gũthingwo rĩngĩ-rĩ, nĩagatua atĩ nyũmba ĩyo ndĩrĩ na thaahu, nĩgũkorwo ũgumu ũcio nĩũthirĩte. ");
INSERT INTO kik_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Nĩgeetha atherie nyũmba ĩyo, nĩakoya nyoni igĩrĩ, na kamũtĩ ka mũtarakwa, na rũrigi rwa rangi wa gakarakũ, na mũthobi. ");
INSERT INTO kik_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Nĩagathĩnjĩra nyoni ĩmwe ya icio igũrũ rĩa nyũngũ ya rĩũmba ĩrĩ na maaĩ matahĩtwo o hĩndĩ ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Acooke oe kamũtĩ ka mũtarakwa, na mũthobi, na rũrigi rwa rangi wa gakarakũ na nyoni ĩyo ĩrĩ muoyo, acitobokie thĩinĩ wa thakame ĩyo ya nyoni ĩyo thĩnje, na maaĩ-inĩ macio matahĩtwo o hĩndĩ ĩyo, aminjaminjĩrie nyũmba ĩyo maita mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Nĩagatheria nyũmba ĩyo na thakame ya nyoni ĩyo, na maaĩ macio matahĩtwo o hĩndĩ ĩyo, na nyoni ĩyo ĩrĩ muoyo, na kamũtĩ kau ka mũtarakwa, na mũthobi ũcio, na rũrigi rũu rwa rangi wa gakarakũ. ");
INSERT INTO kik_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Acooke arekererie nyoni ĩyo ĩrĩ muoyo yũmbũke ĩthiĩ na kũu werũ-inĩ, nja ya itũũra. Ũguo nĩguo akaahoroheria nyũmba ĩyo, nayo nĩĩgathirwo nĩ thaahu.” ");
INSERT INTO kik_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Macio nĩmo mawatho makoniĩ mũrimũ o ro wothe wa ngoothi ũrĩa ũngĩgwatanio, na ũhere, ");
INSERT INTO kik_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","na ũgumu ũrĩ nguo-inĩ kana thĩinĩ wa nyũmba, ");
INSERT INTO kik_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","na handũ haimbu, na handũ harĩ na mũtũnda, kana handũ hakaragacũku, ");
INSERT INTO kik_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","nĩguo kũmenyekage rĩrĩa kĩndũ gĩtarĩ na thaahu na rĩrĩa kĩrĩ na thaahu. Macio nĩmo mawatho makoniĩ mĩrimũ ya ngoothi ĩrĩa ĩngĩgwatanio, na makoniĩ ũgumu. ");
INSERT INTO kik_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Nake Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Arĩriai andũ a Isiraeli, mũmeere ũũ: ‘Rĩrĩa mũndũ mũrũme o wothe angĩkorwo akiura kuuma njaga-inĩ yake, kuura kũu nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Mũndũ ũcio arĩkoragwo arĩ na thaahu hĩndĩ ĩrĩa angĩkorwo akiura hĩndĩ ciothe, o na kana angĩtiga kuura. Kuura kũu arĩ nakuo kũrĩĩtũmaga athaahe na njĩra ici: ");
INSERT INTO kik_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Ũrĩrĩ o wothe mũndũ ũcio ũkuura angĩkomera nĩũkanyiitwo nĩ thaahu, na kĩndũ o gĩothe kĩrĩa angĩikarĩra nĩgĩkanyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Mũndũ ũrĩa ũngĩhutia ũrĩrĩ ũcio no nginya athambie nguo ciake na ethambe na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Mũndũ o wothe ũngĩikarĩra kĩndũ gĩikarĩirwo nĩ mũndũ ũcio ũroira, no nginya athambie nguo ciake na ethambe na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Mũndũ o wothe ũngĩhutia mũndũ ũcio ũroira no nginya athambie nguo ciake na ethambe na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Mũndũ ũcio ũroira angĩtuĩra mũndũ ũtarĩ na thaahu mata-rĩ, mũndũ ũcio no nginya athambie nguo ciake na ethambe na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Matandĩko mothe marĩa mũndũ ũcio ũroira angĩikarĩra akuuĩtwo nĩ nyamũ, nĩmakanyiitwo nĩ thaahu, ");
INSERT INTO kik_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","nake mũndũ o wothe ũngĩhutia kĩndũ o na kĩmwe gĩikarĩre nĩ mũndũ ũcio, nĩakanyiitwo nĩ thaahu o nginya hwaĩ-inĩ; ũrĩa wothe ũngĩũngania indo icio no nginya athambie nguo ciake na ethambe na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Mũndũ ũcio ũkuura angĩhutia mũndũ atethambĩte moko na maaĩ, mũndũ ũcio ahutia no nginya athambie nguo ciake na ethambe na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Nyũngũ ya rĩũmba ĩrĩa mũndũ ũcio angĩhutia, no nginya yũragwo, na kĩndũ gĩothe kĩa mbaũ no nginya gĩkamũrwo na maaĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Rĩrĩa mũndũ ũcio angĩhonio mũrimũ ũcio wa kuura, nĩageterera mĩthenya mũgwanja nĩguo ambĩrĩrie gũtherio gwake; no nginya athambie nguo ciake na ethambe na maaĩ, matahĩtwo o hĩndĩ ĩyo, nake nĩagathirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Mũthenya wa kanana wakinya, no nginya arute ndirahũgĩ igĩrĩ kana tũtutuura twĩrĩ, athiĩ mbere ya Jehova hau itoonyero rĩa Hema-ya-Gũtũnganwo na acinengere mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Nake mũthĩnjĩri-Ngai nĩagaciruta igongona, ĩmwe ĩrĩ iruta rĩa kũhoroherio mehia na ĩrĩa ĩngĩ irĩ iruta rĩa njino. Ũguo nĩguo akaahoroheria mũndũ ũcio hau mbere ya Jehova, nĩ ũndũ wa kuura gwake. ");
INSERT INTO kik_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Rĩrĩa mũndũ mũrũme angiumwo nĩ hinya wa arũme, no nginya ethambe mwĩrĩ wothe na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Nguo o yothe kana rũũa ingĩitĩkĩrwo nĩ hinya wa arũme handũ, no nginya ithambio na maaĩ, na itiinde irĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Rĩrĩa mũndũ mũrũme akomania na mũndũ-wa-nja, nake oimwo nĩ hinya wa arũme, o eerĩ no nginya methambe na maaĩ, nao matiinde marĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Rĩrĩa mũndũ-wa-nja ekuura ihinda-inĩ rĩake rĩa mweri, nĩagaikara mĩthenya mũgwanja arĩ na thaahu, nake mũndũ o wothe ũngĩmũhutia, atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Kĩndũ o gĩothe angĩkomera ihinda-inĩ rĩake rĩa mweri nĩgĩkanyiitwo nĩ thaahu, na kĩndũ o gĩothe angĩikarĩra nĩgĩkanyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Mũndũ o wothe ũngĩhutia ũrĩrĩ wake no nginya athambie nguo ciake na ethambe mwĩrĩ na maaĩ, nake atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Mũndũ o wothe ũngĩhutia kĩndũ o gĩothe aikarĩire no nginya athambie nguo ciake na ethambe mwĩrĩ na maaĩ, nake atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kĩndũ kĩu kĩngĩkorwo nĩ ũrĩrĩ, kana o kĩndũ kĩngĩ mũndũ-wa-nja ũcio aikarĩire, hĩndĩ ĩyo mũndũ wothe angĩkĩhutia, nĩagatinda arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Mũndũ mũrũme angĩkoma nake na ahutio nĩ thakame ya ihinda rĩake rĩa mweri, nĩagaikara arĩ na thaahu mĩthenya mũgwanja; naguo ũrĩrĩ o wothe angĩkomera nĩũkanyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Rĩrĩa mũndũ-wa-nja angiura thakame ategũtigithĩria mĩthenya mĩingĩ ihinda rĩtarĩ rĩake rĩa mweri, kana kuura kũngĩ gũkĩrĩte ihinda rĩake rĩa mweri, nĩagaikara arĩ na thaahu rĩrĩa rĩothe ekuura ũguo, o ta ũrĩa akoragwo arĩ na thaahu ihinda-inĩ rĩake rĩa mweri. ");
INSERT INTO kik_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ũrĩrĩ wothe ũrĩa angĩkoma rĩrĩa rĩothe ekuura ũguo, nĩũkanyiitwo nĩ thaahu, o ta ũrĩa ũrĩrĩ wake ũkoragwo na thaahu ihinda-inĩ rĩake rĩa mweri, na kĩrĩa gĩothe angĩikarĩra nĩ gĩkaanyiitwo nĩ thaahu, o ta ũrĩa gũkoragwo ihinda-inĩ rĩake rĩa mweri. ");
INSERT INTO kik_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Mũndũ o wothe angĩcihutia nĩakanyiitwo nĩ thaahu; nake no nginya athambie nguo ciake na ethambe mwĩrĩ na maaĩ, na atiinde arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Aarĩkia gũtiga kuura, nĩageterera mĩthenya mũgwanja, na thuutha ũcio nĩagathirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Mũthenya wa kanana wakinya, no nginya arute ndirahũgĩ igĩrĩ kana tũtutuura twĩrĩ, acirehere mũthĩnjĩri-Ngai hau itoonyero rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Mũthĩnjĩri-Ngai nĩakaruta ĩmwe ĩrĩ iruta rĩa kũhoroherio mehia, nayo ĩyo ĩngĩ ĩrĩ iruta rĩa njino. Ũguo nĩguo mũthĩnjĩri-Ngai akaamũhoroheria hau mbere ya Jehova nĩ ũndũ wa thaahu wa kuura kũu gwake. ");
INSERT INTO kik_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘No nginya mwehanĩrĩrie andũ a Isiraeli na indo iria ingĩmagwatia thaahu, nĩgeetha matikanakue marĩ na thaahu nĩ ũndũ wa gũthaahia gĩikaro gĩakwa kĩrĩa kĩrĩ gatagatĩ kao.’ ” ");
INSERT INTO kik_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Macio nĩmo mawatho marĩa makoniĩ mũndũ ũrĩa ũkuura, na ma mũndũ o wothe ũrĩa ũnyiitĩtwo nĩ thaahu nĩ ũndũ wa kuumwo nĩ hinya wa arũme, ");
INSERT INTO kik_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","na ma mũndũ-wa-nja nĩ ũndũ wa ihinda rĩake rĩa mweri, na ma mũndũ mũrũme kana mũndũ-wa-nja ũrĩa ũkuura, na ma mũndũ mũrũme ũrĩa ũngĩkoma na mũndũ-wa-nja ũrĩa ũrĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Nake Jehova akĩarĩria Musa thuutha wa gĩkuũ kĩa ariũ arĩa eerĩ a Harũni arĩa maakuire rĩrĩa mookire magĩkuhĩrĩria mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Jehova akĩĩra Musa atĩrĩ: “Ĩra mũrũ wa nyũkwa Harũni ndagatoonyage o rĩrĩa enda Handũ-harĩa-Hatheru-Mũno, hau thuutha wa gĩtambaya gĩa gũcuuria kĩrĩa kĩrĩ mbere ya gĩtĩ gĩa tha kĩrĩa kĩrĩ igũrũ wa ithandũkũ rĩa kĩrĩkanĩro ndakae gũkua, tondũ hau nĩho ndĩyumagĩria ndĩ thĩinĩ wa itu hau igũrũ wa gĩtĩ gĩa tha. ");
INSERT INTO kik_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Ũũ nĩguo Harũni arĩĩtoonyaga harĩa haamũre: arĩĩtoonyaga na gategwa ka iruta rĩa kũhoroherio mehia, na ndũrũme ĩmwe ya iruta rĩa njino. ");
INSERT INTO kik_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Nĩarĩhumbaga kanjũ ya gatani ĩrĩa nyamũre, na thuruarĩ cia thĩinĩ cia gatani iriganie na mwĩrĩ wake, nĩarĩĩhotoraga mũcibi ũrĩa wa gatani, na akeoha kĩremba kĩrĩa gĩa gatani. Icio nĩcio nguo iria nyamũre; nĩ ũndũ ũcio no nginya ethambe na maaĩ mbere ya gũciĩhumba. ");
INSERT INTO kik_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Nĩakoya thenge igĩrĩ cia iruta rĩa kũhoroherio mehia, na ndũrũme ya iruta rĩa njino kuuma kũrĩ kĩrĩndĩ kĩa andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Harũni nĩakaruta ndegwa ĩyo ĩrĩ iruta rĩa kũhoroherio mehia make mwene nĩguo ehoroherie we mwene na nyũmba yake. ");
INSERT INTO kik_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ningĩ nĩakoya thenge icio cierĩ acineane hau mbere ya Jehova itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Nĩagacuukĩra thenge icio cierĩ mĩtĩ, ũmwe nĩ wa Jehova, naguo ũcio ũngĩ nĩ wa mbũri ya kũrekererio ĩkuuithĩtio mehia. ");
INSERT INTO kik_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Harũni nĩakaruta thenge ĩrĩa ĩkaagũĩrwo nĩ mũtĩ wa mwena wa Jehova, amĩrute ĩrĩ igongona rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","No thenge ĩrĩa ĩkaagũĩrwo nĩ mũtĩ ĩtuĩke ya kũrekererio ĩkuuithĩtio mehia nĩĩkaneanwo mbere ya Jehova ĩrĩ muoyo, ĩtuĩke ya kũhorohanĩria, na ũndũ wa kũmĩrekereria ĩĩthiĩre werũ-inĩ, ĩrĩ yo ya kũrekererio ĩkuuithĩtio mehia. ");
INSERT INTO kik_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Harũni nĩakarehe ndegwa ĩyo ĩtuĩke ya iruta rĩa mehia make mwene, nĩguo ehoroherie we mwene na nyũmba yake, na nĩagathĩnja ndegwa ĩyo nĩ ũndũ wa iruta rĩa kũhoroherio mehia make mwene. ");
INSERT INTO kik_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Nĩakoya rũgĩo rwa ũbani rũiyũrĩtio makara ma mwaki marutĩtwo kĩgongona-inĩ mbere ya Jehova, na ngundi igĩrĩ cia ũbani mũhinyu ũrĩa ũtararĩkaga wega, na acitware na kũu thuutha wa gĩtambaya gĩa gũcuurio. ");
INSERT INTO kik_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Nĩagekĩra ũbani ũcio mwaki-inĩ mbere ya Jehova, nayo ndogo ya ũbani ũcio nĩĩgathiĩka gĩtĩ kĩu gĩa tha, kĩu kĩrĩ igũrũ rĩa ithandũkũ rĩa Ũira, nĩguo ndagakue. ");
INSERT INTO kik_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Ningĩ nĩakoya thakame ĩmwe ya ndegwa ĩyo na kĩara gĩake, amĩminjaminje mwena wa mbere wa gĩtĩ kĩu gĩa tha; ningĩ nĩakaminjaminja ĩmwe yayo na kĩara gĩake maita mũgwanja hau mbere ya gĩtĩ kĩu gĩa tha. ");
INSERT INTO kik_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Ningĩ nĩagathĩnja thenge ĩrĩa ya iruta rĩa kũhoroherio mehia makoniĩ andũ acio, na atware thakame yayo thuutha wa gĩtambaya gĩa gũcuurio, eke nayo o ta ũrĩa eekire thakame ya ndegwa ĩyo: amĩminjaminje igũrũ rĩa gĩtĩ kĩu gĩa tha o na mbere yakĩo. ");
INSERT INTO kik_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ũguo nĩguo akaahoroheria Handũ-harĩa-Hatheru-Mũno tondũ wa thaahu na ũremi wa andũ a Isiraeli, kũringana na mehia mao mothe. Na ũguo noguo ageeka nĩ ũndũ wa Hema-ya-Gũtũnganwo, ĩrĩa ĩrĩ gatagatĩ kao na thaahu wao. ");
INSERT INTO kik_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Gũtirĩ mũndũ o na ũrĩkũ ũgaakorwo thĩinĩ wa Hema-ya-Gũtũnganwo kuuma ihinda rĩrĩa Harũni agaathiĩ kũhoroheria Handũ-harĩa-Hatheru-Mũno nginya hĩndĩ ĩrĩa akoima ho, arĩkĩtie kwĩhoroheria we mwene, na akahoroheria nyũmba yake na akahoroheria kĩrĩndĩ gĩothe gĩa Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Ningĩ nĩakoima athiĩ kĩgongona-inĩ kĩrĩa kĩrĩ hau mbere ya Jehova akĩhoroherie. Nĩakoya thakame ĩmwe ya ndegwa ĩyo, na thakame ĩmwe ya thenge, amĩhake hĩa ciothe cia kĩgongona kĩu. ");
INSERT INTO kik_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Nĩakaminjaminja thakame ĩmwe na kĩara gĩake igũrũ rĩakĩo maita mũgwanja, agĩtherie na akĩamũre nĩguo gĩthirwo nĩ thaahu wa andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Harũni aarĩkia kũhoroheria Handũ-harĩa-Hatheru-Mũno, na Hema-ya-Gũtũnganwo na kĩgongona kĩu, nĩakarehe thenge ĩrĩa ĩrĩ muoyo. ");
INSERT INTO kik_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Nĩakaigĩrĩra moko make meerĩ igũrũ rĩa mũtwe wa thenge ĩyo ĩrĩ muoyo, na oimbũrĩre hau igũrũ rĩayo waganu wothe na ũremi wa andũ a Isiraeli, oimbũre mehia mao mothe, amacookererie igũrũ rĩa mũtwe wayo. Nĩakarekereria thenge ĩyo ĩĩthiĩre werũ-inĩ ĩmenyereirwo nĩ mũndũ ũrĩa ũthuurĩirwo wĩra ũcio. ");
INSERT INTO kik_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Thenge ĩyo nĩĩgakuuithio mehia mao mothe, ĩmatware kũndũ kũrĩa gũtatũũragwo nĩ Andũ; nake mũndũ ũcio nĩakarekereria thenge ĩyo na kũu werũ-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Harũni nĩagacooka atoonye Hema-ya-Gũtũnganwo arute nguo icio cia gatani iria eekĩrire mbere ya gũtoonya Handũ-harĩa-Hatheru-Mũno, nake acitige kuo. ");
INSERT INTO kik_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Nĩagethamba mwĩrĩ na maaĩ, arĩ handũ hatheru na acooke ehumbe nguo ciake cia ndũire. Acooke oime nja na erutĩre iruta rĩa njino nĩ ũndũ wake mwene, na arute iruta rĩa njino nĩ ũndũ wa andũ, nĩguo ehoroherie we mwene na ahoroherie andũ arĩa angĩ. ");
INSERT INTO kik_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ningĩ nĩagacinĩra maguta ma iruta rĩa kũhoroherio mehia igũrũ rĩa kĩgongona. ");
INSERT INTO kik_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Mũndũ ũcio ũrekagĩrĩria thenge ĩyo ya gũkuuithio mehia no nginya athambie nguo ciake na ethambe mwĩrĩ na maaĩ; thuutha ũcio acooke atoonye kambĩ. ");
INSERT INTO kik_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ndegwa ĩyo na thenge, iria cia iruta rĩa kũhoroherio mehia, iria thakame yacio yatwarĩtwo Handũ-harĩa-Hatheru-Mũno ya kũhorohanĩria, no nginya ciumio nja ya kambĩ; njũa ciacio na nyama, na mahu ciothe icinwo ihĩe biũ. ");
INSERT INTO kik_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Mũndũ ũrĩa ũgacicina no nginya agaathambia nguo ciake na ethambe mwĩrĩ na maaĩ; thuutha ũcio no acooke atoonye kambĩ. ");
INSERT INTO kik_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Ũndũ ũyũ ũgũtuĩka watho mwandĩke wa kũrũmagĩrĩrwo hĩndĩ ciothe nĩ inyuĩ: Mũthenya wa ikũmi mweri-inĩ wa mũgwanja no nginya mwĩimage irio, na mũtikarutage wĩra o na ũrĩkũ, arĩ mũndũ ũciarĩirwo bũrũri wanyu, kana arĩ mũgeni ũrĩa ũtũũranagia na inyuĩ, ");
INSERT INTO kik_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","tondũ mũthenya ũcio nĩmũkahoroherio, nĩguo mũtherio. Hĩndĩ ĩyo nĩmũgatherio kuuma kũrĩ mehia manyu mothe mũrĩ hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ĩyo nĩ Thabatũ ya kũhurũka, na no nginya mwĩimage irio; ũyũ nĩ watho mwandĩke wa kũrũmagĩrĩrwo hĩndĩ ciothe. ");
INSERT INTO kik_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Mũthĩnjĩri-Ngai ũrĩa mũitĩrĩrie maguta na akaamũrwo gũcooka ithenya rĩa ithe ta mũthĩnjĩri-Ngai ũrĩa mũnene nĩwe ũkaahoroheria andũ. Nĩakehumbaga nguo iria nyamũre cia gatani ");
INSERT INTO kik_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","na ahoroherie Handũ-harĩa-Hatheru-Mũno, na Hema-ya-Gũtũnganwo, na kĩgongona, na athĩnjĩri-Ngai, na andũ othe a mũingĩ wa Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Ũndũ ũyũ ũgũtuĩka watho mwandĩke wa kũrũmagĩrĩrwo hĩndĩ ciothe nĩ inyuĩ; horohio ĩrĩrutagwo riita rĩmwe o mwaka nĩ ũndũ wa mehia mothe ma andũ a Isiraeli.” Na gũgĩĩkwo o ta ũrĩa Jehova aathĩte Musa gwĩkagwo. ");
INSERT INTO kik_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Arĩria Harũni, na ariũ ake na andũ othe a Isiraeli, ũmeere atĩrĩ: ‘Ũũ nĩguo Jehova aathanĩte: ");
INSERT INTO kik_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Mũndũ o wothe Mũisiraeli ũrĩĩrutaga igongona rĩa ndegwa, kana rĩa gatũrũme, kana rĩa mbũri thĩinĩ wa kambĩ kana nja ya kambĩ, ");
INSERT INTO kik_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","handũ ha kũrĩrehe itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, arĩrute rĩrĩ igongona rĩa kũrutĩrwo Jehova hau mbere ya Hema-ĩrĩa-Nyamũre ya Jehova-rĩ, mũndũ ũcio nĩagatuuo arĩ na mahĩtia ma gũita thakame; mũndũ ũcio nĩaitĩte thakame, na no nginya aingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ũndũ ũyũ nĩwagũtũma andũ a Isiraeli matwaragĩre Jehova magongona marĩa rĩu mararutĩrwo werũ-inĩ. No nginya mamarehagĩre mũthĩnjĩri-Ngai, ũguo nĩ kuuga kũrĩ Jehova, hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, marutwo marĩ maruta ma ũiguano. ");
INSERT INTO kik_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Mũthĩnjĩri-Ngai nĩakaminjaminja thakame kĩgongona-inĩ kĩa Jehova hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, na acine maguta marĩ mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Matikanacooke o na rĩ kũruta magongona mao o na marĩkũ kũrĩ mĩhianano ya mbũri ĩrĩa mahũũraga ũmaraya nayo. Ũyũ nĩ watho mwandĩke wa kũrũmagĩrĩrwo hĩndĩ ciothe kũrĩ o, na kũrĩ njiarwa iria igooka.’ ");
INSERT INTO kik_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Meere atĩrĩ: ‘Mũisiraeli o wothe, kana mũgeni o na ũrĩkũ ũtũũranagia nao, ũkaaruta iruta rĩa njino, kana arute igongona, ");
INSERT INTO kik_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","na ndarĩtware hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo arĩrutĩre Jehova-rĩ, mũndũ ũcio no nginya aingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Mũisiraeli wothe kana mũgeni o wothe ũtũũranagia nao ũkaarĩa thakame o yothe, nĩngahũgũkĩra mũndũ ũcio ũrĩĩte thakame, na nĩngamũingata kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nĩgũkorwo muoyo wa kĩũmbe ũrĩ thĩinĩ wa thakame, na nĩyo ndĩmũheete mwĩhorohagĩrie nayo kĩgongona-inĩ; thakame nĩyo ĩhorohagĩria muoyo wa mũndũ. ");
INSERT INTO kik_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Nĩ ũndũ ũcio ngwĩra andũ a Isiraeli atĩrĩ, “Gũtirĩ mũndũ o na ũmwe thĩinĩ wanyu wagĩrĩirwo nĩ kũrĩa thakame, o na mũgeni ũrĩa ũtũũranagia na inyuĩ ndakanarĩe thakame.” ");
INSERT INTO kik_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Mũisiraeli o wothe, kana mũgeni o wothe ũtũũranagia na inyuĩ, ũkaaguĩma nyamũ kana nyoni o yothe ĩngĩrĩĩo, no nginya agaita thakame yayo thĩ, acooke amĩthike na tĩĩri, ");
INSERT INTO kik_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","tondũ muoyo wa kĩũmbe gĩothe nĩ thakame yakĩo. Nĩkĩo njĩrĩĩte andũ a Isiraeli atĩrĩ, “Mũtikanarĩe thakame ya kĩũmbe o gĩothe, tondũ muoyo wa kĩũmbe nĩ thakame yakĩo; mũndũ o wothe ũngĩmĩrĩa no nginya aingatwo.” ");
INSERT INTO kik_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Mũndũ o wothe, arĩ wa gũciarĩrwo bũrũri wanyu kana arĩ mũgeni, angĩkaarĩa nyamũ ĩkuĩte kana ĩtambuurangĩtwo nĩ nyamũ cia gĩthaka-rĩ, no nginya agaathambia nguo ciake na ethambe na maaĩ, na atiinde na thaahu nginya o hwaĩ-inĩ; thuutha ũcio nĩagathirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","No angĩkaaga gũthambia nguo ciake na aage gwĩthamba-rĩ, nĩagacookererwo nĩ ũũru ũcio wake.’ ” ");
INSERT INTO kik_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Mũtikaneke maũndũ marĩa andũ a Misiri, kũrĩa mwatũũraga, meekaga, na mũtikaneke maũndũ marĩa mekagwo bũrũri wa Kaanani, kũrĩa ndĩramũtwara. Mũtikarũmĩrĩre mĩthiĩre yao. ");
INSERT INTO kik_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","No nginya mwathĩkagĩre mawatho makwa na mũmenyagĩrĩre gwathĩkĩra kĩrĩra kĩa watho wakwa wa kũrũmĩrĩrwo. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Tũũrai mũrũmĩtie kĩrĩra kĩa watho wakwa wa kũrũmĩrĩrwo, na mawatho makwa, nĩgũkorwo mũndũ ũrĩa ũrĩĩmathĩkagĩra nĩarĩtũũrio muoyo nĩmo. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Gũtirĩ mũndũ o na ũrĩkũ ũgaathengerera mũndũ wa nyũmba yake nĩguo makomanie; niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Ndũkanaconorithie thoguo nĩ ũndũ wa gũkoma na nyũkwa. Ũcio nĩ nyũkwa; ndũkanakome nake. ");
INSERT INTO kik_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Ndũkanakome na mũtumia wa thoguo; ũguo nĩ gũconorithia thoguo. ");
INSERT INTO kik_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Ndũkanakome na mwarĩ wa nyũkwa, kana mwarĩ wa thoguo ũrĩa mũciarĩtwo nĩ ithe ũmwe kana mwarĩ wa nyũkwa ũrĩa mũtarĩ a ithe ũmwe. ");
INSERT INTO kik_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Ndũkanakome na mwarĩ wa mũrũguo kana mwarĩ wa mwarĩguo; ũguo nĩ gwĩconorithia. ");
INSERT INTO kik_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Ndũkanakome na mwarĩ wa mũndũ-wa-nja wa thoguo, ũrĩa ũciarĩtwo nĩ thoguo; ũcio no ta mwarĩ wa nyũkwa. ");
INSERT INTO kik_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Ndũkanakome na mwarĩ wa nyina na thoguo; ũcio nĩ mũndũ wa nyũmba ya thoguo. ");
INSERT INTO kik_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Ndũkanakome na tataguo, ũcio nĩ mũndũ wa nyũmba ĩmwe na nyũkwa. ");
INSERT INTO kik_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Ndũkanaconorithie mũrũ wa nyina na thoguo, na ũndũ wa gũthengerera mũtumia wake nĩguo mũkomanie; ũcio nĩ tataguo. ");
INSERT INTO kik_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Ndũkanakome na mũtumia wa mũrũguo. Ũcio nĩ mũtumia wa mũrũguo; ndũkanakome nake. ");
INSERT INTO kik_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Ndũkanakome na mũtumia wa mũrũ wa nyũkwa; ũguo nĩgũconorithia mũrũ wa nyũkwa. ");
INSERT INTO kik_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Ndũkanakome na mũndũ-wa-nja ũcooke ũkome na mwarĩ. Ndũkanakome na mwarĩ wa mũriũ, kana mwarĩ wa mwarĩ; acio nĩ andũ a nyũmba yake. Ũcio nĩ waganu. ");
INSERT INTO kik_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Ndũkanahikie mwarĩ wa nyina na mũtumia waku atuĩke mũiru wa mũtumia waku, ũkomage nake mũtumia waku arĩ muoyo. ");
INSERT INTO kik_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Ndũkanathengerere mũndũ-wa-nja mũkomanie rĩrĩa arĩ na thaahu wa hĩndĩ yake ya mweri. ");
INSERT INTO kik_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Ndũkanakome na mũtumia wa mũndũ ũngĩ, ndũgethaahie nake. ");
INSERT INTO kik_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Mũtikananeane ciana cianyu irutĩrwo Moleku igongona, mũtikanathaahie rĩĩtwa rĩa Ngai wanyu. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Ndũkanakome na mũndũ mũrũme ta ũrĩa mũndũ akomaga na mũndũ-wa-nja; ũndũ ũcio ũrĩ magigi. ");
INSERT INTO kik_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Ndũkanakome na nyamũ nawe wĩthaahie nayo. Mũndũ-wa-nja ndakanetware harĩ nyamũ akome nayo; gwĩka ũguo nĩ waganu mũkĩru njano. ");
INSERT INTO kik_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Mũtikanethaahie na ũndũ o na ũmwe wa macio, tondũ ũguo nĩguo ndũrĩrĩ iria ngũingata imweherere ciethaahirie. ");
INSERT INTO kik_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","O naguo bũrũri nĩwathaahirio; nĩ ũndũ ũcio ngĩũherithĩria mehia maguo, naguo bũrũri ũcio ũgĩtahĩka arĩa maatũũraga kuo. ");
INSERT INTO kik_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","No inyuĩ, no nginya mũrũmie kĩrĩra kĩa watho wa kũrũmĩrĩrwo, na mawatho makwa. Andũ arĩa maciarĩirwo bũrũri wanyu, kana ageni arĩa matũũranagia na inyuĩ, matikaneke ũndũ o na ũrĩkũ wa macio marĩ magigi, ");
INSERT INTO kik_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","nĩgũkorwo maũndũ macio mothe nĩmo meekagwo nĩ andũ arĩa maatũũraga bũrũri ũcio mbere yanyu, naguo bũrũri ũcio ũkĩnyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","O na inyuĩ mũngĩgwatia bũrũri ũcio thaahu, nĩũkamũtahĩka o ta ũrĩa watahĩkire arĩa maatũũraga kuo mbere yanyu. ");
INSERT INTO kik_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Mũndũ o wothe ũngĩka ũndũ o na ũmwe wa maũndũ macio marĩ magigi, andũ ta acio no nginya maingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Rũmiai maũndũ marĩa ndĩmwathĩte na mũtikanarũmĩrĩre mĩtugo ĩyo ĩrĩ magigi, ĩrĩa yekagwo mũtaanoka, na mũtikanethaahie nayo. Niĩ nĩ niĩ Jehova Ngai wanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Arĩria kĩũngano gĩothe kĩa Isiraeli, ũmeere atĩrĩ, ‘Tuĩkai atheru tondũ niĩ, Jehova Ngai wanyu, ndĩ mũtheru. ");
INSERT INTO kik_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘O mũndũ wanyu no nginya atĩĩe nyina na ithe, na no nginya mũrũmagie Thabatũ ciakwa. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Mũtikanandirike, mũhooyage mĩhianano kana mwĩthondekere ngai cia kĩgera gĩtweketio. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Rĩrĩa mũkũrutĩra Jehova igongona rĩa ũiguano, rĩrutagei na njĩra ĩrĩa ĩngĩtũma igongona rĩu rĩanyu rĩĩtĩkĩrĩke. ");
INSERT INTO kik_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Igongona rĩu mũrĩrĩĩage o mũthenya ũcio rĩarutwo, kana mũthenya ũyũ ũngĩ; kĩndũ o gĩothe kĩa rĩo kĩngĩtigara gĩkinyie mũthenya wa gatatũ, no nginya gĩcinwo kĩhĩe biũ. ");
INSERT INTO kik_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kĩndũ o na kĩrĩkũ kĩarĩo kĩngĩkaarĩĩo mũthenya wa gatatũ, igongona rĩu ti rĩtheru na rĩtigetĩkĩrwo. ");
INSERT INTO kik_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Mũndũ o wothe ũngĩrĩrĩa mũthenya wa gatatũ, nĩagacookererwo nĩ ũũru ũcio ekĩte, tondũ nĩathaahĩtie kĩndũ kĩarutĩirwo Jehova kĩrĩ gĩtheru; mũndũ ũcio no nginya aingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Rĩrĩa mũkũgetha irio bũrũri-inĩ wanyu, mũtikanagethe nginya ndeere-inĩ cia mĩgũnda yanyu, o na mũtikanonganie rũitĩki rwa magetha manyu. ");
INSERT INTO kik_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mũtigacookage rĩngĩ kũhaara mĩgũnda-inĩ yanyu ya mĩthabibũ, o na mũtikahaarage thabibũ iria igũĩte thĩ. Citigagĩriei andũ arĩa athĩĩni na arĩa ageni. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Mũtikanaiye. “ ‘Mũtikanaheenanie. “ ‘Mũndũ ndakanaheenie ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Mũtikanehĩte na maheeni mũkĩgwetaga rĩĩtwa rĩakwa, na nĩ ũndũ ũcio mũthaahie rĩĩtwa rĩa Ngai wanyu. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Mũtikaheenie mũndũ ũrĩa ũngĩ, muoe indo ciake kana mũmũtunye indo ciake. “ ‘Mũtikanaikarie mũcaara wa mũruti wa wĩra ũkinyie rũciũ. ");
INSERT INTO kik_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Mũtikanarume mũndũ ũtaiguaga, kana mũigĩre mũtumumu kĩndũ gĩa kũmũhĩnga, no mwĩtigagĩrei Ngai wanyu. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Mũtikanoogomie kĩhooto; ndũkanacaĩre mũndũ tondũ nĩ mũthĩĩni kana mũndũ mũnene ũrĩ igweta, no tuagĩrai mũndũ ũrĩa ũngĩ ciira na kĩhooto. ");
INSERT INTO kik_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Mũtikanorũũre mũgĩcambanagia gatagatĩ-inĩ ka andũ anyu. “ ‘Mũtikaneke ũndũ ũngĩrehere mũndũ ũrĩa ũngĩ ũgwati. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Ndũkanathũũre mũrũ wa thoguo ngoro-inĩ yaku. Kaanagia mũndũ ũrĩa ũngĩ maũndũ ũtekũhithĩrĩra nĩgeetha ndũkanagwatanĩre nake mahĩtia-inĩ make. ");
INSERT INTO kik_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Ndũkanerĩhĩrie kana ũtume mũndũ wanyu ũthũ, no endaga mũndũ ũrĩa ũngĩ o ta ũrĩa wĩyendete wee mwene. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Rũmagiai uuge wakwa. “ ‘Ndũkanaciarithanie nyamũ itarĩ cia kĩruka kĩmwe. “ ‘Ndũkanahaande mũgũnda waku mbeũ mĩthemba ĩĩrĩ. “ ‘Ndũkanehumbe nguo ĩtumĩtwo na ndigi mĩthemba ĩĩrĩ ĩtahaanaine. ");
INSERT INTO kik_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Mũndũ mũrũme angĩkoma na mũndũ-wa-nja ngombo, nake aakorwo nĩmũũrie nĩ mũndũ ũngĩ, no ndakũũrĩtwo kana akarekererio, no nginya maherithio ta ũrĩa kwagĩrĩire. No matikooragwo, tondũ mũndũ-wa-nja ũcio ndatigĩte gũtuĩka ngombo. ");
INSERT INTO kik_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Nake mũndũ mũrũme ũcio-rĩ, no nginya arute ndũrũme, amĩtware itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo ĩtuĩke iruta rĩa kũrutĩrwo Jehova rĩa kũhoroherio mahĩtia. ");
INSERT INTO kik_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Mũthĩnjĩri-Ngai nĩakahoroheria mũndũ ũcio na ndũrũme ĩyo ya iruta rĩa mahĩtia, ĩrutĩrwo hau mbere ya Jehova nĩ ũndũ wa rĩĩhia rĩu ehĩtie, nake nĩakarekerwo rĩĩhia rĩake. ");
INSERT INTO kik_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Rĩrĩa mũgaatoonya bũrũri ũcio wa Kaanani, na mũhaande mĩtĩ ya mĩthemba yothe ĩciaraga maciaro-rĩ, nĩ mũgaatua atĩ maciaro macio marĩ na thaahu. Ihinda rĩa mĩaka ĩtatũ nĩmũkamatua atĩ marĩ na thaahu, na matikanarĩĩo. ");
INSERT INTO kik_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mwaka wa kana, maciaro mothe mayo nĩmagatuĩka matheru, matuĩke maruta ma kũgoocithia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","No mwaka wa gatano, no mũrĩe maciaro mayo. Ũguo nĩguo magetha manyu makoongerereka. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Mũtikanarĩe nyama ĩrĩ na thakame thĩinĩ wayo. “ ‘Mũtigekage maũndũ ma kũragũra kana ma kũrogana. ");
INSERT INTO kik_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Mũtikanenje njuĩrĩ cianyu thikĩrĩrio-inĩ kana mũrenge mĩthia ya nderu cianyu. ");
INSERT INTO kik_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Mũtikanetemange mĩĩrĩ yanyu nĩ ũndũ wa andũ arĩa akuũ, kana mwĩkĩre marũũri mĩĩrĩ-inĩ yanyu. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Ndũkanaagithie mwarĩguo gĩtĩĩo na ũndũ wa kũmũrekereria atuĩke mũmaraya, kana ũndũ ũcio ũtũme bũrũri ũgarũrũkĩre ũmaraya, na ũiyũrwo nĩ waganu. ");
INSERT INTO kik_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Menyagĩrĩrai Thabatũ ciakwa, na mũtĩĩage handũ hakwa harĩa haamũre. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Mũtikanatuĩrie maũndũ kũrĩ andũ arĩa marĩ maroho ma kũragũra kana arogi, nĩgũkorwo nĩmakamũgwatia thaahu. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Rũgamagĩrai andũ arĩa akũrũ, mũmatĩĩage; heagai andũ arĩa akũrũ gĩtĩĩo, na mwĩtigagĩre Ngai wanyu. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Hĩndĩ ĩrĩa mũgeni aatũũrania na inyuĩ bũrũri-inĩ wanyu, mũtikanamwĩke ũũru. ");
INSERT INTO kik_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Mũgeni ũrĩa ũtũũranagia na inyuĩ no nginya atuagwo taarĩ mũndũ ũciarĩirwo bũrũri wanyu. Mwendei ta ũrĩa mwĩendete inyuĩ ene, nĩgũkorwo o na inyuĩ mwarĩ ageni bũrũri wa Misiri. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Mũtikahũthagĩre ithimi itarĩ cia kĩhooto rĩrĩa mũgũthima ũraihu, kana ũritũ, kana ũingĩ. ");
INSERT INTO kik_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Hũthagĩrai ithimi cia kĩhooto, na mahiga ma gũthima ma kĩhooto, na eba ya kĩhooto, na hini ya kĩhooto. Niĩ nĩ niĩ Jehova Ngai wanyu ũrĩa wamũrutire bũrũri wa Misiri. ");
INSERT INTO kik_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Rũmagiai irĩra ciakwa cia watho ciothe na mawatho makwa mothe, na mũmarũmagĩrĩre. Niĩ nĩ niĩ Jehova.’ ” ");
INSERT INTO kik_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ĩra andũ a Isiraeli atĩrĩ: ‘Mũisiraeli o wothe kana mũgeni o wothe ũrĩa ũtũũraga bũrũri wa Isiraeli ũkaaheana ũmwe wa ciana ciake kũrĩ ngai ĩrĩa ĩtagwo Moleku, no nginya akooragwo. Mũingĩ wothe nĩ ũkaamũhũũra na mahiga nyuguto. ");
INSERT INTO kik_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nĩngahũgũkĩra mũndũ ũcio, na nĩngamũingata kuuma kũrĩ andũ ao; tondũ wa kũheana ciana ciake kũrĩ Moleku, nĩathaahĩtie handũ hakwa harĩa haamũre na agathaahia rĩĩtwa rĩakwa itheru. ");
INSERT INTO kik_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Mũingĩ ũcio wa andũ ũngĩkaaga kũherithia mũndũ ũcio ũheanĩte ũmwe wa ciana ciake kũrĩ Moleku, mage kũmũũraga-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","nĩngahũgũkĩra mũndũ ũcio, hamwe na andũ a nyũmba yake, na ndĩmaingate kuuma kũrĩ andũ ao, we mwene na arĩa othe mamũrũmagĩrĩra na kũhũũra ũmaraya na Moleku. ");
INSERT INTO kik_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Nĩngahũgũkĩra mũndũ ũrĩa ũtuĩragia maũndũ kuuma kũrĩ andũ arĩa marĩ na maroho ma kũragũra na kuuma kũrĩ arogi, nĩguo ahũũre ũmaraya na ũndũ wa kũmarũmĩrĩra, na nĩngamũingata kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Mwĩyamũrei mũtuĩke atheru tondũ niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Rũmagiai irĩra ciakwa cia watho na mũcirũmagĩrĩre. Niĩ nĩ niĩ Jehova, ũrĩa ũmũtheragia. ");
INSERT INTO kik_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Mũndũ o wothe ũngĩruma ithe kana arume nyina, no nginya ooragwo. Nĩarumĩte ithe kana akaruma nyina, na thakame yake nĩĩkamũcookerera. ");
INSERT INTO kik_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Mũndũ mũrũme angĩtharia na mũtumia wa mũndũ ũngĩ, atharie na mũtumia wa mũndũ wa itũũra rĩake, itharia icio cierĩ, mũndũ mũrũme ũcio na mũtumia, no nginya mooragwo. ");
INSERT INTO kik_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Mũndũ mũrũme angĩkoma na mũtumia wa ithe, nĩaconorithĩtie ithe. Mũndũ mũrũme ũcio na mũtumia ũcio eerĩ no nginya mooragwo; thakame yao nĩĩkamacookerera. ");
INSERT INTO kik_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Mũndũ mũrũme angĩkoma na mũtumia wa mũriũ, eerĩ no nginya mooragwo. Ũndũ ũcio mekĩte nĩ waganu ũkĩrĩte njano; thakame yao nĩĩkamacookerera. ");
INSERT INTO kik_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Mũndũ mũrũme angĩkoma na mũndũ mũrũme ũngĩ ta ũrĩa mũndũ akomaga na mũndũ-wa-nja-rĩ, andũ acio eerĩ nĩmekĩte ũndũ ũrĩ magigi. No nginya mooragwo; thakame yao nĩĩkamacookerera. ");
INSERT INTO kik_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Mũndũ mũrũme angĩhikia mũndũ-wa-nja na ahikie nyina, ũcio nĩ waganu. Mũndũ mũrũme ũcio na andũ-a-nja acio eerĩ no nginya macinwo na mwaki, nĩgeetha gũtikanakorwo na waganu thĩinĩ wanyu. ");
INSERT INTO kik_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Mũndũ mũrũme angĩkoma na nyamũ-rĩ, no nginya mũndũ ũcio ooragwo, na no nginya mũũrage nyamũ ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Mũndũ-wa-nja angĩĩtwarĩrĩra harĩ nyamũ nĩguo akome nayo-rĩ, nĩmũkooraga mũndũ-wa-nja ũcio hamwe na nyamũ ĩyo. No nginya mũndũ-wa-nja ũcio ooragwo na nyamũ ĩyo yũragwo; thakame yake nĩĩkamũcookerera, na thakame ya nyamũ ĩyo ĩmĩcookerere. ");
INSERT INTO kik_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Mũndũ mũrũme angĩhikia mwarĩ wa ithe, arĩ mwarĩ wa ithe kana wa nyina, na makomanie, icio nĩ njono. No nginya maingatwo mehere kuuma kũrĩ andũ ao. Nĩaconorithĩtie mwarĩ wa ithe. Na nĩagacookererwo nĩ ũũru ũcio ekĩte. ");
INSERT INTO kik_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Mũndũ mũrũme angĩkoma na mũndũ-wa-nja hĩndĩ yake ya mweri, nĩaguũria riurĩro rĩake, o nake mũndũ-wa-nja ũcio agakĩguũria riurĩro rĩa thakame yake. Andũ acio eerĩ nĩmakaingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Ndũkanakome na tataguo kana mwarĩ wa nyina na thoguo, nĩ ũndũ gwĩka ũguo nĩ gũconorithia mũndũ ũrĩa mũrĩ rũrĩra; inyuĩ eerĩ nĩmũgacookererwo nĩ ũũru ũcio mwĩkĩte. ");
INSERT INTO kik_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Mũndũ angĩkoma na tatawe-rĩ, nĩaconorithĩtie mamawe. Nĩmagacookererwo nĩ ũũru ũcio mekĩte; magaakua matarĩ magĩa mwana. ");
INSERT INTO kik_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Mũndũ angĩhikia mũtumia wa mũrũ wa nyina ũcio nĩ thaahu, nĩaconorithĩtie mũrũ wa nyina. Megũtũũra matarĩ magĩa mwana. ");
INSERT INTO kik_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Rũmagiai irĩra ciakwa ciothe cia watho, na mawatho makwa mũmarũmagĩrĩre, nĩguo mũtũũre bũrũri ũrĩa ndĩramũtwara, na nĩgeetha ndũkanamũtahĩke. ");
INSERT INTO kik_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Mũtikanatũũre kũringana na mĩtugo ya ndũrĩrĩ iria ngũingata imweherere. Ndacimenire nĩ tondũ nĩciekire maũndũ macio mothe. ");
INSERT INTO kik_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","No niĩ ngĩmwĩra atĩrĩ, “Nĩmũkegwatĩra bũrũri wao; nĩngamũhe guo ũtuĩke igai rĩanyu, bũrũri ũrĩ bũthi wa iria na ũũkĩ.” Niĩ nĩ niĩ Jehova Ngai wanyu, ũrĩa wamwamũrire kuuma kũrĩ ndũrĩrĩ. ");
INSERT INTO kik_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Nĩ ũndũ ũcio no nginya mũkũũranage nyamũ iria itarĩ thaahu na iria irĩ thaahu, na nyoni iria itarĩ thaahu na iria irĩ thaahu. Mũtikanethaahie na nyamũ kana nyoni o na ĩrĩkũ, kana kĩndũ o gĩothe gĩthiiagĩra thĩ, iria ciothe ndaamũranirie tondũ irĩ thaahu harĩ inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","No nginya mũtuĩke atheru harĩ niĩ, tondũ niĩ, Jehova, ndĩ mũtheru, na nĩndĩmwamũranĩtie na ndũrĩrĩ iria ingĩ mũtuĩke akwa kĩũmbe. ");
INSERT INTO kik_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Mũndũ mũrũme kana mũndũ-wa-nja ũrĩ maroho marĩa maragũraga kana mũrogi thĩinĩ wanyu, no nginya makooragwo. Mũmahũũre na mahiga nyuguto. Thakame yao nĩĩkamacookerera.’ ” ");
INSERT INTO kik_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Nake Jehova akĩĩra Musa atĩrĩ, “Arĩria athĩnjĩri-Ngai, nĩo ariũ a Harũni, ũmeere atĩrĩ: ‘Mũthĩnjĩri-Ngai ndakanethaahie nĩ ũndũ wa mũndũ wao ũkuĩte, ");
INSERT INTO kik_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","tiga no akorirwo arĩ mũndũ wa nyũmba yake, ta nyina kana ithe, kana mũriũ kana mwarĩ, kana mũrũ wa nyina, ");
INSERT INTO kik_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kana mwarĩ wa nyina ũtarĩ mũhiku ũrĩa ateithagia nĩ ũndũ ndarĩ na mũthuuri, nĩ ũndũ wake-rĩ, no ethaahie. ");
INSERT INTO kik_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ndakanethaahie nĩ ũndũ wa athoni ake, na nĩ ũndũ ũcio anyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Athĩnjĩri-Ngai matikanenjwo mĩtwe, kana marengerere mĩthia ya nderu ciao kana metemange mĩĩrĩ yao nĩ ũndũ wa gũkuĩrwo. ");
INSERT INTO kik_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","No nginya makorwo marĩ atheru harĩ Ngai wao, na matikanathaahie rĩĩtwa rĩa Ngai wao. Tondũ nĩo matwaragĩra Jehova indo iria arutĩirwo irĩ iruta rĩa njino, nĩcio irio cia Ngai wao, no nginya makorwo marĩ atheru. ");
INSERT INTO kik_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Athĩnjĩri-Ngai matikanahikie andũ-a-nja arĩa methaahĩtie na ũmaraya, kana arĩa matiganĩte na athuuri ao, tondũ athĩnjĩri-Ngai nĩ atheru harĩ Ngai wao. ");
INSERT INTO kik_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Matuagei atheru, tondũ nĩo marutagĩra Ngai wanyu irio iria arutĩirwo igongona. Matuagei atheru, tondũ niĩ Jehova ndĩ mũtheru, o niĩ ũrĩa ũmũtheragia. ");
INSERT INTO kik_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Mwarĩ wa mũthĩnjĩri-Ngai angĩĩthaahia na gũtuĩka mũmaraya, nĩaconorithĩtie ithe; no nginya acinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Mũthĩnjĩri-Ngai ũrĩa mũnene, ũrĩa ũrĩ gatagatĩ ka ariũ-a-ithe, na ũitĩrĩirio maguta mũtwe na akaamũrwo nĩguo ehumbage nguo cia ũthĩnjĩri-Ngai, ndakanarekererie njuĩrĩ yake ĩikare ĩtarĩ njanũre kana atembũrange nguo ciake. ");
INSERT INTO kik_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ndakanatoonye handũ harĩ kĩimba. Ndakanethaahie o na aakorwo nĩ ũndũ wa ithe kana nyina, ");
INSERT INTO kik_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","o na ndakanoime handũ-harĩa-haamũre ha Ngai wake, kana ahathaahie, tondũ nĩamũrĩtwo, agaitĩrĩrio maguta ma Ngai wake. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Mũndũ-wa-nja ũrĩa akaahikia no nginya agaakorwo arĩ mũirĩtu gathirange. ");
INSERT INTO kik_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ndakanahikie mũtumia wa ndigwa, kana mũtumia matiganĩte na mũthuuriwe, kana mũndũ-wa-nja wĩthaahĩtie na ũmaraya, no akaahikia mũirĩtu gathirange wa andũ ao, ");
INSERT INTO kik_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","nĩgeetha ndakanathaahie rũciaro rwake gatagatĩ ka andũ ao. Niĩ nĩ niĩ Jehova, ũrĩa ũmũtheragia.’ ” ");
INSERT INTO kik_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Ĩra Harũni atĩrĩ: ‘Harĩ njiarwa iria igooka, gũtirĩ mũndũ wa njiaro ciaku ũrĩ na kaũũgũ ũgaakuhĩrĩria nĩguo arutĩre Ngai wake irio cia igongona. ");
INSERT INTO kik_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Gũtirĩ mũndũ o na ũmwe ũrĩ na kaũũgũ ũgaakuhĩrĩria: mũndũ mũtumumu kana gĩthua, kana mũndũ mũthũku ũthiũ, kana ũrĩ na wonje, ");
INSERT INTO kik_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","mũndũ mwonju kũgũrũ kana guoko, ");
INSERT INTO kik_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","mũndũ ũrĩ iguku kana mũhomu, mũndũ ũrĩ na kaũũgũ ka riitho, kana mũndũ ũrĩ na ironda iratogota kana iroira, kana mũthũku nyee. ");
INSERT INTO kik_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Gũtirĩ mũndũ wa njiaro cia Harũni ũrĩa mũthĩnjĩri-Ngai ũrĩ kaũũgũ ũgaakuhĩrĩria nĩguo atware maruta marĩa marutĩirwo Jehova ma njino. Ũcio ũrĩ na kaũũgũ ndakanakuhĩrĩrie atĩ nĩguo arute irio icio cia Ngai wake cia igongona. ");
INSERT INTO kik_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","We no arĩe irio iria theru mũno cia Ngai wake, o na irio iria theru; ");
INSERT INTO kik_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","no rĩrĩ, nĩ ũndũ wa ũũgũ ũcio wake, ndakanakuhĩrĩrie gĩtambaya gĩa gũcuurio kana athengerere kĩgongona, nĩgeetha ndagathaahie handũ hau hakwa harĩa haamũre. Niĩ nĩ niĩ Jehova, ũrĩa ũmatheragia.’ ” ");
INSERT INTO kik_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Nĩ ũndũ ũcio Musa akĩĩra Harũni na ariũ ake ũguo, o na akĩĩra andũ a Isiraeli othe. ");
INSERT INTO kik_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Ĩra Harũni na ariũ ake matĩĩage maruta marĩa matheru marĩa andũ a Isiraeli maanyamũrĩire, nĩgeetha matikanathaahie rĩĩtwa rĩakwa itheru. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Meere atĩrĩ, ‘Njiarwa iria igooka thuutha, mũndũ o na ũrĩkũ wa njiaro cianyu angĩgakorwo ethaahĩtie, nake akuhĩrĩrie maruta marĩa matheru marĩa andũ a Isiraeli maamũrĩire Jehova, mũndũ ũcio no nginya aingatwo, ehere mbere yakwa. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Mũndũ wa njiaro cia Harũni angĩkorwo arĩ na mũrimũ wa ngoothi ũngĩgwatanio, kana mwĩrĩ wake ũkoira, ndakaarĩa indo iria theru irutĩtwo cia maruta, nginya agaathirwo nĩ thaahu. Ningĩ nĩakanyiitwo nĩ thaahu angĩkaahutia kĩndũ gĩthaahie nĩ kĩimba, kana ahutie mũndũ o wothe ũrĩa uumĩtwo nĩ hinya wa arũme, ");
INSERT INTO kik_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o na kana angĩhutia kĩndũ o gĩothe kĩrĩa gĩtambaga thĩ kĩrĩa kĩngĩmũgwatia thaahu, kana ahutie mũndũ o na ũrĩkũ ũngĩtũma anyiitwo nĩ thaahu, o na thaahu ũcio ũngĩkorwo nĩ ũrĩkũ. ");
INSERT INTO kik_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Mũndũ ũrĩa ũngĩhutia kĩndũ o na kĩrĩkũ ta kĩu nĩakanyiitwo nĩ thaahu o nginya hwaĩ-inĩ. Ndakanarĩe kĩndũ o na kĩrĩkũ kĩa maruta marĩa maamũre, no akorirwo ethambĩte mwĩrĩ na maaĩ. ");
INSERT INTO kik_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Riũa rĩathũa nĩagathirwo nĩ thaahu, na thuutha ũcio no arĩe maruta marĩa maamũre, tondũ nĩcio irio ciake. ");
INSERT INTO kik_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ndakanarĩe nyama cia nyamũ ĩkuĩte, kana nyama cia nyamũ ĩtambuurĩtwo nĩ nyamũ cia gĩthaka, nĩguo ndakae gũthaahio nĩcio. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Athĩnjĩri-Ngai nĩmarũmagie mawatho makwa nĩgeetha matikahĩtagie, nao makue nĩ ũndũ wa kwaga gũtĩĩa mawatho macio. Niĩ nĩ niĩ Jehova ũrĩa ũmatheragia. ");
INSERT INTO kik_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Gũtirĩ mũndũ o na ũrĩkũ ũtarĩ wa nyũmba ya mũthĩnjĩri-Ngai wagĩrĩirwo nĩ kũrĩa maruta marĩa matheru, o na mũgeni wa mũthĩnjĩri-Ngai, kana mũruti wa wĩra gwake o nao matigacirĩe. ");
INSERT INTO kik_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","No mũthĩnjĩri-Ngai angĩgũra ngombo na mbeeca, kana ngombo ĩciarĩrwo gwake mũciĩ, ngombo ĩyo no ĩrĩe irio ciake. ");
INSERT INTO kik_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Mwarĩ wa mũthĩnjĩri-Ngai angĩhikio nĩ mũndũ ũtarĩ mũthĩnjĩri-Ngai, ndakanarĩe kĩndũ o na kĩmwe kĩa maruta macio matheru. ");
INSERT INTO kik_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","No mwarĩ wa mũthĩnjĩri-Ngai angĩtuĩka mũtumia wa ndigwa, kana matigane na mũthuuriwe na ndarĩ ciana, nake acooke agaikare gwa ithe o ta rĩrĩa aarĩ mwĩthĩ, no arĩe irio icio nyamũre cia ithe. No mũndũ ũtetĩkĩrĩtio, ndakanarĩe kĩndũ o na kĩmwe gĩacio. ");
INSERT INTO kik_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Mũndũ o wothe angĩrĩa maruta matheru atekũmenya, no nginya acookerie mũthĩnjĩri-Ngai kĩndũ kĩu kĩamũre arĩĩte na ongerere gĩcunjĩ gĩa gatano gĩa thogora wakĩo. ");
INSERT INTO kik_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Athĩnjĩri-Ngai matikanathaahie maruta marĩa matheru marĩa andũ a Isiraeli marutagĩra Jehova, ");
INSERT INTO kik_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","na ũndũ wa kũmetĩkĩria marĩe maruta macio matheru, na ũguo ũtũme mũcookererwo nĩ mahĩtia marĩa mũngĩrĩhio. Niĩ nĩ niĩ Jehova ũrĩa ũmatheragia.’ ” ");
INSERT INTO kik_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Arĩria Harũni na ariũ ake, na warĩrie andũ a Isiraeli othe, ũmeere atĩrĩ: ‘Mũndũ o na ũrĩkũ thĩinĩ wanyu, arĩ Mũisiraeli kana arĩ mũgeni ũtũũraga Isiraeli, angĩkaarutĩra Jehova kĩheo kĩa iruta rĩa njino nĩ ũndũ wa kũhingia mwĩhĩtwa, kana kĩrĩ kĩa iruta rĩa kwĩyendera, ");
INSERT INTO kik_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","no nginya akaaruta njamba ĩtarĩ na kaũũgũ kuuma kũrĩ ngʼombe, kana ngʼondu, kana mbũri, nĩgeetha kĩheo kĩu gĩĩtĩkĩrĩke handũ-inĩ hanyu. ");
INSERT INTO kik_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Mũtikanarehe kĩndũ o na kĩrĩkũ kĩrĩ na kaũũgũ, tondũ gĩtigeetĩkĩrĩka handũ-inĩ hanyu. ");
INSERT INTO kik_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Rĩrĩa mũndũ arĩĩrutaga kĩndũ kiumĩte rũrũ-inĩ rwake rwa ngʼombe kana rwa mbũri, kĩrĩ kĩa iruta rĩa ũiguano rĩa kũrutĩrwo Jehova, nĩguo ahingie mwĩhĩtwa wa mwanya, kana kĩa iruta rĩa kwĩyendera, no nginya gĩkoragwo gĩtarĩ na kaũũgũ kana kameni nĩguo gĩĩtĩkĩrĩke. ");
INSERT INTO kik_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Mũtikanarutĩre Jehova nyamũ ndumumu kana ndihie, kana ĩrathua, kana kĩndũ o gĩothe kĩrĩ na mbatata, kana kĩrĩ na ironda iratogota kana iroira. Mũtikanaigĩrĩre o na ĩmwe ya icio kĩgongona-inĩ ĩtuĩke ya iruta rĩa gũcinwo na mwaki harĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","No rĩrĩ, no mũrute ndegwa, kana ngʼondu nyonju kana homu, ĩrĩ ya igongona rĩa kwĩyendera, no ĩyo ndĩngĩtĩkĩrwo ĩtuĩke ya kũhingia mwĩhĩtwa. ");
INSERT INTO kik_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Mũtikanarutĩre Jehova nyamũ ĩrĩa ĩtihĩtio nyee, kana ĩkamendereka, kana ndarũre, kana hakũre. Mũtikanarute magongona ta macio bũrũri-inĩ wanyu, ");
INSERT INTO kik_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","na mũtikanamũkĩre nyamũ ta icio kuuma kũrĩ mũndũ mũgeni atĩ nĩguo mũcirute ituĩke irio cia Ngai wanyu. Nyamũ ta icio itingĩtĩkĩrĩka handũ-inĩ hanyu, nĩ ũndũ nĩ nyonju, na irĩ na ũũgũ.’ ” ");
INSERT INTO kik_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Rĩrĩa gacaũ, kana gatũrũme, kana koori gaaciarwo, karĩikaraga na nyina mĩthenya mũgwanja. Kuuma mũthenya wa kanana na thuutha ũcio, nĩgagetĩkĩrĩka gatuĩke iruta rĩa gũcinwo na mwaki harĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Mũtikanathĩnje ngʼombe kana ngʼondu hamwe na mwana wayo mũthenya ũmwe. ");
INSERT INTO kik_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Rĩrĩa mũkũruta igongona rĩa gũcookeria Jehova ngaatho, rĩrutagei na njĩra ya gũtũma rĩtĩkĩrĩke nĩ ũndũ wanyu. ");
INSERT INTO kik_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","No nginya rĩrĩĩo mũthenya o ro ũcio rĩarutwo; mũtikanatigie kĩndũ kĩarĩo gĩkinyie rũciinĩ. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Rũmagiai maathani makwa na mũmarũmagĩrĩre. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mũtikanathaahie rĩĩtwa rĩakwa itheru. No nginya andũ a Isiraeli mamenyage atĩ ndĩ mũtheru. Niĩ nĩ niĩ Jehova ũrĩa ũmũtheragia, ");
INSERT INTO kik_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","na ũrĩa wamũrutire bũrũri wa Misiri nduĩke Ngai wanyu. Niĩ nĩ niĩ Jehova.” ");
INSERT INTO kik_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Ici nĩcio ciathĩ ciakwa iria ciathanĩtwo, o iria ciathanĩtwo cia Jehova, iria mũkaahunjanĩria ũhoro wacio atĩ nĩ ciũngano theru. ");
INSERT INTO kik_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Kũrĩ na mĩthenya ĩtandatũ rĩrĩa mũngĩruta wĩra, no mũthenya wa mũgwanja nĩ Thabatũ ya kũhurũka, mũthenya wa kĩũngano gĩtheru. Mũtikanarute wĩra o na ũrĩkũ; kũrĩa guothe mũgaatũũra, ĩyo nĩ Thabatũ ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Ici nĩcio ciathĩ iria ciathanĩtwo cia Jehova, nĩcio ciũngano iria theru, iria mũrĩhunjanagĩria mahinda ma cio makinya. ");
INSERT INTO kik_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Bathaka ya Jehova ĩrĩambagĩrĩria hwaĩ-inĩ kwaira, mũthenya wa ikũmi na ĩna wa mweri wa mbere. ");
INSERT INTO kik_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Mũthenya wa ikũmi na ĩtano, wa mweri ũcio nĩguo gĩathĩ kĩa Jehova kĩa Mĩgate ĩtarĩ Mĩĩkĩre Ndawa ya Kũimbia kĩrĩambagĩrĩria, na kwa ihinda rĩa mĩthenya mũgwanja no nginya mũrĩĩage mĩgate ĩtarĩ na ndawa ya kũimbia. ");
INSERT INTO kik_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Mũthenya wa mbere mũgĩe na kĩũngano gĩtheru, na mũtikarute wĩra ũrĩa mũrutaga. ");
INSERT INTO kik_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mĩthenya mũgwanja rutagĩrai Jehova iruta rĩa gũcinwo na mwaki. Na mũthenya wa mũgwanja, mũgĩage na kĩũngano gĩtheru, na mũtikanarute wĩra ũrĩa mũrutaga.’ ” ");
INSERT INTO kik_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Rĩrĩa mũgaatoonya bũrũri ũcio ngũmũhe na mũgethe magetha maguo, nĩmũkarehere mũthĩnjĩri-Ngai kĩohe kĩa mbere kĩa ngano ĩrĩa mũkaagetha. ");
INSERT INTO kik_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Nake athũngũthie kĩohe kĩu mbere ya Jehova nĩguo gĩĩtĩkĩrĩke handũ-inĩ hanyu; mũthĩnjĩri-Ngai agagĩthũngũthia mũthenya ũrĩa ũrũmĩrĩire Thabatũ. ");
INSERT INTO kik_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Mũthenya ũcio mũgaathũngũthia kĩohe kĩu, no nginya mũkaarutĩra Jehova iruta rĩa njino rĩa gatũrũme ka ũkũrũ wa mwaka ũmwe gatarĩ na kaũũgũ, ");
INSERT INTO kik_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","hamwe na iruta rĩarĩo rĩa mũtu wa gĩthimi gĩa icunjĩ igĩrĩ cia ikũmi cia eba ĩmwe ya mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, nĩrĩo iruta rĩrutĩirwo Jehova rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega, na iruta rĩa kũnyuuo, rĩrĩ gacunjĩ kamwe ka inya ka hini ĩmwe ya ndibei. ");
INSERT INTO kik_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Mũtikanarĩe mũgate o na ũrĩkũ, kana ngano ya kũhĩĩhio, kana ya mũgethano, o nginya mũthenya ũrĩa mũkaarehera Ngai wanyu iruta rĩĩrĩ. Ũndũ ũyũ ũtuĩke watho mwandĩke wa gũtũũra nginya kũrĩ njiarwa iria igooka, kũrĩa guothe mũgaatũũra. ");
INSERT INTO kik_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Kuuma mũthenya ũrĩa ũrũmĩrĩire Thabatũ, mũthenya ũrĩa mwatwarire kĩohe kĩa iruta rĩa gũthũngũthio, mũgatara ciumia ingĩ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Mũtare matukũ mĩrongo ĩtano kuuma mũthenya ũrĩa ũrũmĩrĩire Thabatũ ya kũhingithia mũgwanja, mũcooke mũrutĩre Jehova iruta rĩa mũtu wa ngano ya mũgethano. ");
INSERT INTO kik_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Kuuma kũrĩa guothe mũtũũraga, mũrehe mĩgate ĩĩrĩ ĩthondeketwo na tũcunjĩ twĩrĩ twa ikũmi twa eba ĩmwe ya mũtu ũrĩa mũhinyu mũno, ĩrugĩtwo na ndawa ya kũimbia, ĩtuĩke ya iruta rĩa gũthũngũthio rĩa maciaro ma mbere marutĩirwo Jehova. ");
INSERT INTO kik_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Rutanĩriai mĩgate ĩyo na tũtũrũme mũgwanja, o kamwe karĩ na ũkũrũ wa mwaka ũmwe, na tũtarĩ na kaũũgũ, na gategwa kamwe, na ndũrũme igĩrĩ. Nacio igaatuĩka iruta rĩa njino rĩrutĩirwo Jehova, hamwe na maruta macio ma mũtu na ma kũnyuuo, rĩĩrĩ nĩ iruta rĩa gũcinwo na mwaki, rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Mũcooke mũrute thenge ĩmwe ya igongona rĩa kũhoroherio mehia, na tũtũrũme twĩrĩ, o kamwe karĩ na ũkũrũ wa mwaka ũmwe, twa iruta rĩa ũiguano. ");
INSERT INTO kik_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Mũthĩnjĩri-Ngai nĩagathũngũthia tũtũrũme tũu tweerĩ mbere ya Jehova, tũtuĩke iruta rĩa gũthũngũthio, hamwe na mĩgate ĩyo ya maciaro ma mbere. Macio nĩ maruta matheru marutĩirwo Jehova nĩ ũndũ wa mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Mũthenya o ro ũcio, nĩmũkahunjanĩria kĩũngano gĩtheru, na mũtikanarute wĩra ũrĩa mũrutaga. Ũyũ nĩguo ũgaatuĩka watho mwandĩke wa gũtũũra nginya harĩ njiarwa iria igooka, o kũrĩa guothe mũgaatũũra. ");
INSERT INTO kik_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Rĩrĩa mũkaagetha irio bũrũri-inĩ wanyu, mũtikanagethe nginya ndeere-inĩ cia mĩgũnda yanyu, o na mũtikanonganie rũitĩki rwa magetha manyu. Rũtigagĩriei andũ arĩa athĩĩni na arĩa ageni. Niĩ nĩ niĩ Jehova Ngai wanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Ĩra andũ a Isiraeli atĩrĩ: ‘Mũthenya wa mbere wa mweri wa mũgwanja-rĩ, nĩmũrĩgĩaga na mũthenya wa kũhurũka, kĩũngano gĩtheru, na ũririkanagwo na ũndũ wa kũhuha tũrumbeta. ");
INSERT INTO kik_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Mũtikanarute wĩra ũrĩa mũrutaga, no mũrutagĩre Jehova iruta rĩa gũcinwo na mwaki.’ ” ");
INSERT INTO kik_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Mũthenya wa ikũmi wa mweri ũyũ wa mũgwanja, nĩguo Mũthenya wa Kũhoroherio Mehia. Mũgĩage na kĩũngano gĩtheru na mwĩimage irio, na mũrutagĩre Jehova iruta rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Mũtikanarute wĩra mũthenya ũcio, tondũ nĩguo Mũthenya wa Kũhoroherio Mehia, hĩndĩ ĩrĩa mũrahoroherio mehia mbere ya Jehova-Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Mũndũ o na ũrĩkũ ũrĩa ũtakeima irio mũthenya ũcio nĩakaingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Mũndũ o wothe ũkaaruta wĩra mũthenya ũcio nĩngamũniina kuuma thĩinĩ wa andũ ao. ");
INSERT INTO kik_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Mũtikanarute wĩra o na ũrĩkũ. Ũyũ ũgũtuĩka watho mwandĩke wa gũtũũra nginya harĩ njiarwa iria igooka, o kũrĩa guothe mũgaatũũra. ");
INSERT INTO kik_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ĩyo nĩ Thabatũ yanyu ya kũhurũka, na no nginya mwĩime irio. Kuuma hwaĩ-inĩ wa mũthenya wa kenda wa mweri o ro ũcio nginya hwaĩ-inĩ wa mũthenya ũcio ũngĩ, nĩmũrĩmenyagĩrĩra Thabatũ yanyu.” ");
INSERT INTO kik_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Ĩra andũ a Isiraeli atĩrĩ: ‘Mũthenya wa ikũmi na ĩtano wa mweri wa mũgwanja nĩguo Gĩathĩ kĩa Jehova gĩa Ithũnũ gĩkaambĩrĩria, na gĩgaaikara mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Mũthenya wa mbere nĩ wa kĩũngano gĩtheru; mũtikanarute wĩra ũrĩa mũrutaga. ");
INSERT INTO kik_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Mĩthenya mũgwanja mũkaarutagĩra Jehova maruta ma gũcinwo na mwaki, naguo mũthenya wa ĩnana-rĩ, mũgĩe na kĩũngano gĩtheru, na mũrutĩre Jehova iruta rĩa gũcinwo na mwaki. Mũthenya ũcio nĩguo wa kũhinga kĩũngano; mũtikanarute wĩra ũrĩa mũrutaga. ");
INSERT INTO kik_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Ici nĩcio ciathĩ cia Jehova iria ciathanĩtwo, iria mũkaahunjanĩria irĩ ciũngano theru cia kũrehere Jehova maruta ma gũcinwo na mwaki, na nĩmo maruta ma njino, na maruta ma mũtu, na magongona na maruta ma kũnyuuo marĩa marĩbataranagia o mũthenya. ");
INSERT INTO kik_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Maruta maya nĩ ma kuongererwo harĩ marĩa mangĩ ma Thabatũ cia Jehova na nyongerera ya iheo cianyu na kĩrĩa gĩothe mwĩranĩire na mwĩhĩtwa, na maruta mothe ma kwĩyendera marĩa mũrutagĩra Jehova.) ");
INSERT INTO kik_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Nĩ ũndũ ũcio, kwambĩrĩria mũthenya wa ikũmi na ĩtano wa mweri wa mũgwanja, mwarĩkia kũgetha irio bũrũri-inĩ, nĩ mũgaakũngũĩra gĩathĩ kĩu kĩa Jehova mĩthenya mũgwanja. Mũthenya wa mbere nĩ wa kũhurũka, na mũthenya wa ĩnana o naguo no wa kũhurũka. ");
INSERT INTO kik_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Mũthenya wa mbere nĩmũkooya maciaro marĩa mega mũno ma mĩtĩ, na mathĩgĩ ma mĩtende, na honge cia mĩtĩ ĩrĩa ĩrĩ na mathangũ maingĩ, na cia mĩtĩ ĩrĩa ĩmeraga tũrũũĩ-inĩ, na mũkene mũrĩ mbere ya Jehova Ngai wanyu mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kũngũyagĩrai ũndũ ũyũ arĩ gĩathĩ kĩa Jehova mĩthenya mũgwanja o mwaka. Ũndũ ũyũ nĩ ũtuĩke watho mwandĩke wa gũtũũra nginya harĩ njiarwa iria igooka; kũngũyagĩrai ũndũ ũcio mweri-inĩ wa mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ikaragai ithũnũ-inĩ mĩthenya mũgwanja. Andũ a Isiraeli arĩa othe maciarĩirwo Isiraeli magaaikaraga ithũnũ-inĩ, ");
INSERT INTO kik_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","nĩ ũndũ ũcio njiaro cianyu nĩikamenya atĩ nĩ niĩ ndaatũmire andũ a Isiraeli maikare ithũnũ-inĩ hĩndĩ ĩrĩa ndaamarutire bũrũri wa Misiri. Niĩ nĩ niĩ Jehova Ngai wanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Nĩ ũndũ ũcio Musa akĩanĩrĩra kũrĩ andũ a Isiraeli ũhoro wa ciathĩ icio ciathanĩtwo cia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Atha andũ a Isiraeli makũrehere maguta marĩa makeere wega ma ndamaiyũ hihe ma gũkũheaga ũtheri, nĩgeetha matawa maikarage maakanĩte hĩndĩ ciothe. ");
INSERT INTO kik_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Nja ya gĩtambaya gĩa gũcuurio kĩrĩa kĩrĩ mbere ya ithandũkũ rĩa Ũira o kũu Hema-inĩ-ya-Gũtũnganwo-rĩ, Harũni nĩamenyagĩrĩre matawa macio mbere ya Jehova kuuma hwaĩ-inĩ o nginya rũciinĩ, hĩndĩ ciothe. Ũndũ ũyũ ũgaatuĩka watho mwandĩke wa gũtũũra wa njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Matawa macio marĩ mbere ya Jehova, o macio maigĩrĩirwo mũtĩ-inĩ wa matawa wa thahabu ĩrĩa therie no nginya mamenyagĩrĩrwo hĩndĩ ciothe. ");
INSERT INTO kik_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Oya mũtu ũrĩa mũhinyu mũno, ũthondeke mĩgate ikũmi na ĩĩrĩ, o mũgate ũmwe ũrugwo na tũcunjĩ twĩrĩ twa ikũmi twa eba ĩmwe. ");
INSERT INTO kik_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ũcooke ũmĩare mĩhari ĩĩrĩ, o mũhari mĩgate ĩtandatũ, ũmĩigĩrĩre igũrũ rĩa metha ya thahabu therie hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Na o mũhari-inĩ nĩhaigwo ũbani ũrĩa mũtherie ũtuĩke gĩcunjĩ gĩa kĩririkano ũrũgamĩrĩire mĩgate ĩyo, na ũtuĩke iruta rĩa njino rĩrutĩirwo Jehova na mwaki. ");
INSERT INTO kik_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Mĩgate ĩyo nĩ ĩigagwo mbere ya Jehova hĩndĩ ciothe, o Thabatũ o Thabatũ, ĩrũgamagĩrĩre andũ a Isiraeli, ĩtuĩke kĩrĩkanĩro gĩa gũtũũra. ");
INSERT INTO kik_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Mĩgate ĩyo nĩ ya Harũni na ariũ ake, nao mamĩrĩagĩre handũ hatheru, nĩ tondũ mĩgate ĩyo nĩ gĩcunjĩ gĩtheru mũno harĩ rwĩga rwao rwa maruta marĩa marutĩirwo Jehova ma gũcinwo na mwaki.” ");
INSERT INTO kik_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Na rĩrĩ, mũrũ wa mũtumia Mũisiraeli, no ithe aarĩ Mũmisiri, nĩathiire gũceerera andũ a Isiraeli, nake mũndũ ũcio na Mũisiraeli makĩrũa marĩ kũu kambĩ. ");
INSERT INTO kik_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ũcio mũrũ wa mũtumia Mũisiraeli nĩarumire Rĩĩtwa rĩa Ngai na kĩrumi; nĩ ũndũ ũcio makĩmũtwarĩra Musa. (Nyina wa mũndũ ũcio eetagwo Shelomithu, mwarĩ wa Dibiri ũrĩa Mũdani.) ");
INSERT INTO kik_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Makĩmũikia thĩinĩ, makĩmũrangĩra nginya rĩrĩa mangĩamenyire wega wendi wa Jehova. ");
INSERT INTO kik_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Nake Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Twara mũrumani ũcio nja ya kambĩ. Andũ arĩa othe maamũiguire akĩrumana mamũigĩrĩre moko mũtwe, nakĩo kĩũngano gĩothe kĩmũhũũre na mahiga nyuguto. ");
INSERT INTO kik_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ĩra andũ a Isiraeli atĩrĩ, ‘Mũndũ o na ũrĩkũ angĩkaaruma Ngai wake, no nginya agaacookererwo nĩ ũũru ũcio ekĩte: ");
INSERT INTO kik_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Mũndũ o na ũrĩkũ ũkaaruma rĩĩtwa rĩa Jehova no nginya akooragwo. Kĩũngano gĩothe gĩa Isiraeli no nginya gĩkaamũhũũra na mahiga nyuguto. Aakorwo arĩ mũgeni kana arĩ mũndũ ũciarĩirwo bũrũri-inĩ wanyu, rĩrĩa akaaruma Rĩĩtwa rĩu rĩa Jehova, no nginya akooragwo. ");
INSERT INTO kik_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Mũndũ o na ũrĩkũ angĩkooraga mũndũ ũngĩ, no nginya nake akooragwo. ");
INSERT INTO kik_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Mũndũ o na ũrĩkũ angĩũraga nyamũ ya mũndũ ũrĩa ũngĩ, no nginya akaamĩrĩha, nyamũ ĩrĩhwo na nyamũ ĩngĩ. ");
INSERT INTO kik_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Mũndũ o na ũrĩkũ angĩgatiihia ũrĩa ũngĩ, o ũrĩa ekanĩte no nginya nake ekwo o ũguo: ");
INSERT INTO kik_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Mũndũ oina mũndũ ũrĩa ũngĩ ihĩndĩ, nake akoinwo ihĩndĩ, riitho rĩrĩhagio na riitho, igego rĩrĩhagio na igego. O ũrĩa mũndũ atiihĩtie mũndũ ũngĩ, o nake atiihio o ro ũguo. ");
INSERT INTO kik_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Mũndũ ũrĩa ũkooraga nyamũ nĩakamĩrĩha, no ũrĩa ũkooraga mũndũ ũrĩa ũngĩ no nginya akooragwo. ");
INSERT INTO kik_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Mũrĩkoragwo na watho o ro ũmwe ũkoniĩ mũgeni na mũndũ ũrĩa ũciarĩirwo bũrũri wanyu. Niĩ nĩ niĩ Jehova Ngai wanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Nake Musa akĩarĩria andũ a Isiraeli, nao magĩtwara mũndũ ũcio warumĩte Ngai nja ya kambĩ, makĩmũhũũra na mahiga nyuguto. Nao andũ a Isiraeli magĩĩka o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Nake Jehova akĩĩra Musa Kĩrĩma-inĩ gĩa Sinai atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ, ‘Hĩndĩ ĩrĩa mũgaatoonya bũrũri ũrĩa ngaamũhe-rĩ, bũrũri ũcio guo mwene no nginya ũkaagĩaga na Thabatũ ĩrĩa yamũrĩirwo Jehova. ");
INSERT INTO kik_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Mũkaahaandaga mĩgũnda yanyu mĩaka ĩtandatũ, na mũcehage mĩgũnda yanyu ya thabibũ mũkamĩcehaga mĩaka ĩtandatũ mũgĩcookanagĩrĩria maciaro mayo. ");
INSERT INTO kik_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","No mwaka wa mũgwanja wakinya, bũrũri ũcio nĩũkagĩa na Thabatũ ya kũhurũka, Thabatũ yamũrĩirwo Jehova; mũtikanahaande kĩndũ mĩgũnda kana mũcehe mĩthabibũ yanyu. ");
INSERT INTO kik_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Irio iria ikeemeria, nĩcio cia maitĩka-rĩ, mũtikanacigethe kana mũgethe thabibũ cia mĩthabibũ yanyu ĩyo ĩtarĩ mĩrutĩre wĩra. Bũrũri ũcio no nginya ũkaagĩa na mwaka wa kũhurũka. ");
INSERT INTO kik_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Kĩrĩa gĩothe bũrũri ũcio ũgaaciara mwaka-inĩ ũcio wa Thabatũ gĩgaatuĩka irio cianyu, inyuĩ ene na cia ndungata cianyu cia arũme na cia andũ-a-nja, na cia aruti anyu a wĩra wa mũcaara, na mũraarĩrĩri ũrĩa mũikaranĩtie nake, ");
INSERT INTO kik_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","o hamwe na mahiũ manyu na nyamũ cia gĩthaka iria itũũraga bũrũri wanyu. Kĩrĩa gĩothe bũrũri ũcio ũgaaciara no kĩrĩĩo. ");
INSERT INTO kik_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Tarai Thabatũ mũgwanja cia mĩaka, mĩaka mũgwanja maita mũgwanja, nĩguo Thabatũ icio mũgwanja cia mĩaka ihinge mĩaka mĩrongo ĩna na kenda. ");
INSERT INTO kik_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ningĩ mũcooke mũhuhe karumbeta kũndũ guothe mũthenya wa ikũmi wa mweri wa mũgwanja; Mũthenya wa Kũhoroherio Mehia, mũkaahuha karumbeta kũndũ guothe bũrũri-inĩ wanyu. ");
INSERT INTO kik_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Amũrai mwaka ũcio wa mĩrongo ĩtano, na mũhunjanĩrie ũhoro wa kũohorwo kwa andũ othe arĩa matũũraga bũrũri ũcio wothe. Mwaka ũcio ũgaatuĩka wa Jubilii nĩ ũndũ wanyu; o mũndũ wanyu nĩagacooka kũrĩa ithaka cia nyũmba yao irĩ, na kũrĩa andũ a mũhĩrĩga wao marĩ. ");
INSERT INTO kik_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Mwaka ũcio wa mĩrongo ĩtano ũgaatuĩka wa Jubilii kũrĩ inyuĩ; mũtikanahaande na mũtikanagethe kĩrĩa gĩĩkũrĩtie kĩo kĩene, kana mũgethe mĩthabibũ ĩrĩa ĩtarĩ mĩrutĩre wĩra. ");
INSERT INTO kik_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Nĩgũkorwo ĩyo nĩ Jubilii, na nĩyo ĩgaatuĩka theru kũrĩ inyuĩ; rĩĩagai o kĩrĩa gĩĩkũrĩtie mĩgũnda-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Mwaka-inĩ ũyũ wa Jubilii, o mũndũ no nginya acooke gĩthaka-inĩ gĩake. ");
INSERT INTO kik_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Mũngĩkenderia mũndũ wa bũrũri wanyu mũgũnda kana mũgũre mũgũnda kũrĩ we, mũtikanaheenanie mũndũ na ũrĩa ũngĩ. ");
INSERT INTO kik_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Mũrĩgũraga mũgũnda wa mũndũ wa bũrũri wanyu kũringana na ũrĩa mĩaka ĩthirĩte thuutha wa Jubilii. Nake mwendia akaawendagia kũringana na mĩaka ĩrĩa ĩgakorwo ĩtigarĩte ya magetha. ");
INSERT INTO kik_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Mĩaka ĩngĩkorwo ĩtigarĩte mĩingĩ, mũkongerera thogora, na mĩaka ĩngĩkorwo ĩtigarĩte mĩnini, mũkanyiihia thogora, nĩ ũndũ kĩrĩa arakwenderia nĩ mũigana wa magetha. ");
INSERT INTO kik_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Mũtikanaheenanie mũndũ na ũrĩa ũngĩ, no mwĩtigagĩre Ngai wanyu. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Rũmagĩrĩrai kĩrĩra kĩa watho wakwa na mwĩmenyagĩrĩre nĩguo mwathĩkagĩre mawatho makwa, na inyuĩ nĩ mũgaatũũra bũrũri ũcio mũrĩ na thayũ. ");
INSERT INTO kik_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Naguo bũrũri ũcio nĩũgaciaraga maciaro maguo, na inyuĩ nĩmũkarĩĩaga mũkahũũna na mũtũũre kuo mũrĩ na thayũ. ");
INSERT INTO kik_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mwahota kũũria atĩrĩ, “Tũkaarĩa kĩ mwaka wa mũgwanja aakorwo tũtikahaanda kana tũgethe?” ");
INSERT INTO kik_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Nĩngamũtũmĩra kĩrathimo mwaka-inĩ ũcio wa gatandatũ nĩguo mĩgũnda yanyu ĩgaaciara maciaro ma kũmũigana mĩaka ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mũkĩhaanda mwaka-inĩ wa kanana, mũkaarĩĩaga irio iria mwaigĩte mũthiithũ, na mũgaacirĩa nginya mũgethe maciaro ma mwaka wa kenda. ");
INSERT INTO kik_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Mĩgũnda ndĩkanendio biũ, tondũ bũrũri nĩ wakwa na inyuĩ mũrĩ o ageni kuo, na nĩ niĩ ndĩmũkomborithĩtie. ");
INSERT INTO kik_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Bũrũri wothe ũrĩa mwĩnyiitĩire ũgaatuĩka wanyu, no nginya kũgĩe na mweke wa gũkũũraga mĩgũnda ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Mũndũ wa bũrũri wanyu angĩthĩĩna na endie gĩcunjĩ kĩa mũgũnda wake, mũndũ ũrĩa wa hakuhĩ mũno wa nyũmba yake nĩagooka na akũũre mũgũnda ũcio mũndũ wao eendetie. ");
INSERT INTO kik_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","No rĩrĩ, mũndũ angĩkorwo ndarĩ na mũndũ wa kũmũkũũrĩra mũgũnda, na we mwene atonge agĩe na indo ciiganĩte kũũkũũra, ");
INSERT INTO kik_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","nĩwe ũgaatua thogora kũringana na mĩaka ĩrĩa mĩthiru kuuma rĩrĩa aawendirie, na acookie mbeeca icio ingĩ kũrĩ mũndũ ũrĩa eendeirie; thuutha ũcio no acooke mũgũnda-inĩ wake. ");
INSERT INTO kik_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","No angĩaga kũgĩa na indo cia kũmũrĩha-rĩ, gĩcunjĩ kĩrĩa eendirie gĩgũtũũra kĩrĩ kĩa mũgũri nginya Mwaka wa Jubilii. Gĩgaacookio hĩndĩ ya Jubilii, na hĩndĩ ĩyo no acooke gĩthaka-inĩ gĩake. ");
INSERT INTO kik_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Mũndũ angĩkeendia nyũmba ĩrĩ itũũra-inĩ inene rĩirigĩre, nĩarĩkoragwo arĩ na kĩhooto gĩa kũmĩkũũra ihinda rĩa mwaka mũgima kuuma amĩendia. Thĩinĩ wa ihinda rĩu no amĩkũũre. ");
INSERT INTO kik_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ĩngĩaga gũkũũrwo mwaka ũmwe ũtanathira, nyũmba ĩyo ĩrĩ itũũra-inĩ inene rĩirigĩre nĩĩgatuĩka ya mũmĩgũri na njiaro ciake nginya tene. Nyũmba ĩyo ndĩgaacookerio mwene Mwaka wa Jubilii. ");
INSERT INTO kik_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","No nyũmba cia tũtũũra-inĩ tũrĩa tũtarĩ tũirigĩre, irĩtuagwo ta mĩgũnda ya kũndũ gũtarĩ kũirige. Icio no ikũũrwo, na nĩ igaacookio Mwaka wa Jubilii. ");
INSERT INTO kik_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Alawii hĩndĩ ciothe nĩ marĩ na kĩhooto gĩa gũkũũraga nyũmba ciao iria irĩ matũũra-inĩ ma Alawii, marĩa megwatĩire. ");
INSERT INTO kik_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Nĩ ũndũ ũcio indo cia Alawii no ikũũrwo, ũguo nĩ ta kuuga atĩ, nyũmba nyendie itũũra-inĩ o rĩothe rĩao, nĩĩgacookio Mwaka wa Jubilii, tondũ nyũmba iria irĩ matũũra-inĩ ma Alawii nĩcio igai rĩao thĩinĩ wa andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","No ithaka cia ũrĩithio cia matũũra mao itikanendio; icio nĩ ciao nginya tene. ");
INSERT INTO kik_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Mũndũ wa bũrũri wanyu angĩthĩĩna nginya aremwo nĩ kwĩrũgamĩrĩra gatagatĩ kanyu, mũteithagiei o ta ũrĩa mũngĩteithia mũgeni kana mũndũ ũrarĩrĩire kwanyu, nĩgeetha ahote gũtũũrania na inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Mũtikanamũrĩhie uumithio o na ũrĩkũ, no mwĩtigagĩre Ngai wanyu, nĩgeetha mũndũ wa bũrũri wanyu ahote gũtũũrania na inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Mũtikanamũkombere mbeeca nĩguo acookie na maciaro, kana mũmwenderie irio nĩguo muone uumithio. ");
INSERT INTO kik_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Niĩ nĩ niĩ Jehova Ngai wanyu, ũrĩa wamũrutire bũrũri wa Misiri nĩguo ndĩmũhe bũrũri wa Kaanani na nduĩke Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Mũndũ wa bũrũri wanyu angĩthĩĩna arĩ gatagatĩ kanyu, nake eyendie harĩ inyuĩ, mũtikanamũrutithie wĩra ta ngombo. ");
INSERT INTO kik_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Mũkaamũtua ta mũruti wa wĩra wa mũcaara kana ta mũndũ ũrarĩrĩire kwanyu; mũndũ ũcio akaamũrutĩra wĩra nginya Mwaka wa Jubilii. ");
INSERT INTO kik_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Thuutha ũcio mũndũ ũcio na ciana ciake nĩmakarekererio, nake acooke kũrĩ andũ a mũhĩrĩga wake, na gĩthaka-inĩ kĩa maithe make ma tene. ");
INSERT INTO kik_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Tondũ andũ a Isiraeli nĩ ndungata ciakwa, iria ndaarutire bũrũri wa Misiri, matikanendio matuĩke ngombo. ");
INSERT INTO kik_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Mũtikamaathage mũtekũmaiguĩra tha, no mwĩtigagĩrei Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Ngombo cianyu cia arũme na cia andũ-a-nja iriumaga ndũrĩrĩ-inĩ iria imũrigiicĩirie; kuuma kũrĩ ndũrĩrĩ icio no mũgũrage ngombo. ");
INSERT INTO kik_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","O na ningĩ no mwĩgũrĩre ngombo kuuma kũrĩ andũ arĩa mararĩrĩire kwanyu na kuuma kũrĩ andũ a mĩhĩrĩga yao arĩa maciarĩirwo bũrũri wanyu, nao matuĩke indo cianyu. ");
INSERT INTO kik_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Andũ acio no mũmeegaĩre kũrĩ ciana cianyu matuĩke igai rĩrĩa mũmagaĩire, na no mũmatue ngombo rĩrĩa rĩothe marĩ muoyo, no mũtikanaathe andũ anyu a Isiraeli mũtekũmaiguĩra tha. ");
INSERT INTO kik_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘No rĩrĩ, mũgeni kana mũndũ ũrĩa ũrarĩrĩire kwanyu angĩtonga arĩ gatagatĩ kanyu, nake mũndũ wa bũrũri wanyu athĩĩne na eyendie kũrĩ mũgeni ũrĩa ũtũũranĩtie na inyuĩ, kana kũrĩ mũndũ wa mũhĩrĩga wa mũndũ ũcio mũgeni-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","mũndũ ũcio no arĩkoragwo arĩ na kĩhooto gĩa gũkũũrwo thuutha wa kwĩyendia. Mũndũ wa nyũmba yao no amũkũũre: ");
INSERT INTO kik_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ithe mũnini kana ithe mũkũrũ, kana mũrũ wa ithe, kana mũndũ wa rũrĩra rwa mũhĩrĩga wao no amũkũũre; kana we mwene angĩgaacĩra, no ekũũre. ");
INSERT INTO kik_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Mũndũ ũcio na mũmũgũri magaatara ihinda rĩrĩa rĩthiru kuuma mwaka ũrĩa eyendirie nginya rĩrĩa Mwaka wa Jubilii ũgaakinya. Thogora wa kũrekererio gwake ũkaaringana na irĩhi rĩa mũndũ wa mũcaara thĩinĩ wa mĩaka ĩyo. ");
INSERT INTO kik_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Angĩkorwo nĩ mĩaka mĩingĩ ĩtigarĩte, nĩakarĩha gĩcunjĩ kĩnene gĩa thogora ũrĩa aagũrĩtwo naguo. ");
INSERT INTO kik_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","No angĩkorwo no mĩaka mĩnini ĩtigarĩte Mwaka wa Jubilii ũkinye, ĩyo noyo agaatara arĩhe gũkũũranio gwake kũringana na ũrĩa kwagĩrĩire. ");
INSERT INTO kik_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Agaatuuo ta mũndũ wa mũcaara mwaka o mwaka; na no nginya mũmenyagĩrĩre atĩ mũmũgũri ndarĩmwathaga atekũmũiguĩra tha. ");
INSERT INTO kik_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘O na angĩaga gũkũũrwo na njĩra ĩmwe ya icio, we na ciana ciake no nginya makaarekererio Mwaka wa Jubilii wakinya, ");
INSERT INTO kik_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","nĩgũkorwo andũ a Isiraeli nĩ ndungata ciakwa. Acio nĩ ndungata ciakwa, iria ndaarutire bũrũri wa Misiri. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Mũtikanethondekere mĩhianano kana mwĩrũgamirie mũhianĩre wa kĩndũ kana ihiga rĩamũre rĩa kũhooywo, mũtikaige ihiga rĩacũhie bũrũri-inĩ wanyu atĩ nĩguo mũrĩinamagĩrĩre. Niĩ nĩ niĩ Jehova Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Menyagĩrĩrai Thabatũ ciakwa na mũtĩĩage handũ hakwa harĩa haamũre. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Mũngĩrũmĩrĩra kĩrĩra kĩa watho wakwa na mũmenyagĩrĩre gwathĩkagĩra maathani makwa, ");
INSERT INTO kik_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nĩngamuuragĩria mbura imera ciayo ciakinya, na mĩgũnda yanyu nĩrĩciaraga irio, nayo mĩtĩ ya mĩgũnda yanyu ĩciarage maciaro mayo. ");
INSERT INTO kik_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Mũrĩhũũraga ngano yanyu mũgakinyĩria magetha ma thabibũ, namo magetha ma thabibũ magakinyĩria hĩndĩ ya mahaanda, na mũrĩrĩĩaga irio mũkahũũna, na mũtũũre bũrũri wanyu mũrĩ na thayũ. ");
INSERT INTO kik_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Nĩngatũma bũrũri wanyu ũgĩe na thayũ, na mũrĩkomaga gũtarĩ mũndũ ũngĩtũma mwĩtigĩre. Nĩnganiina nyamũ njũru ciehere bũrũri-inĩ wanyu. Nacio itigacooka kuoneka bũrũri-inĩ wanyu. ");
INSERT INTO kik_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Nĩmũkaingatithia thũ cianyu, na mũcihoote mbaara-inĩ. ");
INSERT INTO kik_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Andũ atano anyu makaahũũra andũ igana, nao andũ anyu igana makaahũũra andũ ngiri ikũmi, nacio thũ nĩ mũgaacihoota mũciũrage na rũhiũ rwa njora. ");
INSERT INTO kik_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Nĩngamuonia ũtugi wakwa, na ndũme mũciarane na mũingĩhe, na nĩngatũũria kĩrĩkanĩro gĩakwa na inyuĩ. ");
INSERT INTO kik_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mũgaakoragwo o mũkĩrĩa magetha ma mwaka mũthiru nginya rĩrĩa mũkaamaruta nja nĩguo mũgĩe na handũ ha kũiga magetha marĩa maragethwo. ");
INSERT INTO kik_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ngaiga gĩikaro gĩakwa gatagatĩ kanyu, na ndikamũthũũra. ");
INSERT INTO kik_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ngaathiiaga ndĩ gatagatĩ kanyu, nduĩke Ngai wanyu, na inyuĩ mũtuĩke andũ akwa. ");
INSERT INTO kik_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Niĩ nĩ niĩ Jehova Ngai wanyu, ũrĩa wamũrutire bũrũri wa Misiri, nĩguo mũtige gũtuĩka ngombo cia andũ a Misiri; ndoinangire macooki ma ngingo cianyu ngĩtũma mũhotage gũthiĩ mwĩhaandĩte wega. ");
INSERT INTO kik_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘No mũngĩkaaga kũnjigua, mwage kũhingia maathani macio mothe, ");
INSERT INTO kik_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","na mũngĩrega kĩrĩra gĩakwa kĩa watho na mũthũũre mawatho makwa, na mwage kũhingia maathani makwa, na nĩ ũndũ ũcio mũthũkie kĩrĩkanĩro gĩakwa-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Niĩ na niĩ nĩngamwĩka maũndũ maya: Nĩngamũrehere kĩmako, na ndĩmũrehere ndwari cia kũmũniina na ũndũ wa kũhiũha kwa mĩĩrĩ kũrĩa gũkaamũte maitho, na gũtũme mũũrwo nĩ hinya. Mũkaahaanda mbeũ tũhũ, nĩ ũndũ ikaarĩagwo nĩ thũ cianyu. ");
INSERT INTO kik_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nĩngamũrũithia ndĩmũũkĩrĩre nĩguo mũhootwo nĩ thũ cianyu; arĩa mamũthũire nĩo makaamwathaga, na mũkooraga hatarĩ mũndũ ũmũingatithĩtie. ");
INSERT INTO kik_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Angĩkorwo o na mwekwo maũndũ macio mũtikanjigua-rĩ, ngaakĩrĩrĩria kũmũherithia nĩ ũndũ wa mehia manyu maita mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nĩnganiina rũngʼathio rwa mwĩtĩĩo wanyu, na ndũme matu matuĩke ta cuuma, nayo thĩ yũme ĩtuĩke ta gĩcango. ");
INSERT INTO kik_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mũkaahũthĩra hinya wanyu o tũhũ, tondũ tĩĩri wanyu ndũkagethwo kĩndũ, kana mĩtĩ ya bũrũri wanyu ĩciare maciaro mayo. ");
INSERT INTO kik_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Ningĩ mũngĩthiĩ na mbere na mĩthiĩre ya kũnemera, na mwage kũnjigua, nĩngakĩrĩrĩria kũmũingĩhĩria mahũũra mangĩ maita mũgwanja o ũrĩa mehia manyu magĩrĩirwo nĩ kũherithio. ");
INSERT INTO kik_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nĩngamũrehere nyamũ cia gĩthaka imũũkĩrĩre, nacio imũtunye ciana cianyu, na iniine ngʼombe cianyu, o na itũme mũigana wanyu ũnyiihe ũũ atĩ barabara cianyu ciage andũ. ");
INSERT INTO kik_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Ningĩ kũngĩkorwo o na mwekwo maũndũ macio no mũkaarega kũnjookerera na mũgĩthiĩ na mbere kũnjũkĩrĩra-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","niĩ na niĩ nĩngamũũkĩrĩra, na nĩngakĩrĩrĩria kũmũhũũra nĩ ũndũ wa mehia manyu maita mangĩ mũgwanja. ");
INSERT INTO kik_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nĩngamũrehithĩria rũhiũ rwa njora rũrĩhĩrie kĩrĩkanĩro kĩrĩa mũthũkĩtie. Muorĩra matũũra-inĩ marĩa manene manyu, nĩngamũrehithĩria mũthiro thĩinĩ wanyu, na ndĩmũrekererie moko-inĩ ma thũ cianyu. ");
INSERT INTO kik_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Rĩrĩa ngaamwehereria makũmbĩ manyu ma irio, andũ-a-nja ikũmi makaarugagĩra mĩgate yanyu riiko rĩmwe, nao macooke kũmũrehera mĩgate ĩyo ĩthimĩtwo na ratiri. Mũkaamĩrĩĩaga na mũtihũũne. ");
INSERT INTO kik_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Ningĩ kũngĩkorwo o na mwekwo maũndũ macio mũtikanjigua-rĩ, no mũthiĩ o na mbere kũnjũkĩrĩra, ");
INSERT INTO kik_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","niĩ na niĩ nĩngamũũkĩrĩra na marakara na niĩ mwene ngĩrĩrĩrie kũmũherithia maita mangĩ mũgwanja nĩ ũndũ wa mehia manyu. ");
INSERT INTO kik_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mũkaarĩĩaga nyama cia ariũ na aarĩ anyu. ");
INSERT INTO kik_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Ningĩ nĩngananga kũndũ kwanyu kũrĩa gũtũũgĩru, na ndemange magongona manyu ma ũbani na njooke njigĩrĩre ciimba cianyu igũrũ rĩa mĩhianano ĩyo yanyu ĩtarĩ muoyo, na ndĩmũthũũre. ");
INSERT INTO kik_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Matũũra manyu marĩa manene nĩngamananga na handũ hanyu harĩa haamũre ndĩhoonũhe, o na ndigakenio nĩ mũtararĩko mwega wa maruta manyu. ");
INSERT INTO kik_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nĩngonũha bũrũri ũcio, nginya thũ cianyu iria itũũraga kuo igege. ");
INSERT INTO kik_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nĩngamũharagania ndũrĩrĩ-inĩ na njomore rũhiũ rwakwa rwa njora ndĩmũingatithie. Naguo bũrũri wanyu ndĩũnũhe, namo matũũra manyu marĩa manene ndĩmanange. ");
INSERT INTO kik_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Thuutha ũcio, bũrũri ũcio nĩũgakenera mĩaka ya Thabatũ hĩndĩ ĩyo yothe ũgaakorwo ũkirĩte ihooru, na inyuĩ mũrĩ bũrũri-inĩ wa thũ cianyu; naguo bũrũri nĩũkahurũka, na ũkenere thabatũ ciaguo. ");
INSERT INTO kik_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ihinda rĩrĩa bũrũri ũcio ũgaakorwo ũkirĩte ihooru, nĩũkahurũka kũrĩa wagĩte kũhurũka hĩndĩ ya Thabatũ iria mwatũũrĩte kuo. ");
INSERT INTO kik_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Nao arĩa anyu magaatigara, nĩngatũma ngoro ciao inyiitwo nĩ guoya marĩ mabũrũri-inĩ macio ma thũ ciao, o nginya ithangũ rĩabarabario nĩ rũhuho rĩgatũma moore. Nao makooraga o ta ũrĩa mũndũ ooragĩra rũhiũ rwa njora, na nĩmakagũũaga o na gũtarĩ mũndũ ũmaingatithĩtie. ");
INSERT INTO kik_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Makaahĩnganaga makĩũra o ta andũ maroorĩra rũhiũ rwa njora o na gũtarĩ mũndũ ũmaingatithĩtie. Nĩ ũndũ ũcio mũtikahota gwĩtiiria thũ cianyu. ");
INSERT INTO kik_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mũgaathirĩra kũu ndũrĩrĩ-inĩ; bũrũri wa thũ cianyu ũkaamũrĩa ũmũniine. ");
INSERT INTO kik_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Nao andũ anyu arĩa magaatigara nĩmakoorwo nĩ hinya marĩ kũu bũrũri-inĩ ũcio wa thũ ciao nĩ ũndũ wa mehia mao; o na ningĩ nĩ ũndũ wa mehia ma maithe mao, nĩ makoorwo nĩ hinya. ");
INSERT INTO kik_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘No mangĩkoimbũra mehia mao na mehia ma maithe mao, o na mehia ma kũnemera na ma kũnjũkĩrĩra, ");
INSERT INTO kik_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","kũrĩa gwatũmire ndĩmookĩrĩre nginya ngĩmatwarithia bũrũri wa thũ ciao, thuutha ũcio rĩrĩa ngoro icio ciao nyũmũ ikenyiihia na ciĩtĩkĩre ihũũra rĩa mehia mao-rĩ, ");
INSERT INTO kik_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nĩngaririkana kĩrĩkanĩro gĩakwa na Jakubu, na kĩrĩkanĩro gĩakwa na Isaaka, na kĩrĩkanĩro gĩakwa na Iburahĩmu, na ndirikane bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Nĩgũkorwo bũrũri ũcio nĩũgatiganĩrio nĩo, naguo nĩũgakenera Thabatũ ciaguo rĩrĩa ũgaakira ihooru ũtarĩ nao. Nĩmakarĩhio mehia mao nĩ ũndũ nĩmaregire mawatho makwa na magĩthũũra kĩrĩra gĩakwa kĩa watho. ");
INSERT INTO kik_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","No rĩrĩ, o na gũtariĩ ũguo, hĩndĩ ĩyo marĩ bũrũri-inĩ wa thũ ciao, ndikamarega kana ndĩmathũũre biũ ũndũ ũngĩtũma ndĩmaniine biũ, thũkie kĩrĩkanĩro gĩakwa nao. Niĩ nĩ niĩ Jehova Ngai wao. ");
INSERT INTO kik_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","No nĩ ũndũ wao, nĩngaririkana kĩrĩkanĩro gĩakwa na maithe mao, arĩa ndaarutire bũrũri wa Misiri mbere ya ndũrĩrĩ nĩgeetha nduĩke Ngai wao. Niĩ nĩ niĩ Jehova.’ ” ");
INSERT INTO kik_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Icio nĩcio irĩra cia watho wa kũrũmĩrĩrwo, na matuĩro ma ciira na mawatho marĩa Jehova aarĩkanĩire na andũ a Isiraeli Kĩrĩma-inĩ gĩa Sinai, akĩĩra Musa amamenyithanie kũrĩ andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Mũndũ o wothe angĩkeehĩta mwĩhĩtwa wa mwanya wa kwamũrĩra Jehova andũ, na ũndũ wa kũruta indo iria ciiganĩire iruta rĩu, ");
INSERT INTO kik_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","nĩũgaatua irĩhi rĩa mũndũ mũrũme wa kuuma mĩaka mĩrongo ĩĩrĩ nginya mĩaka mĩrongo ĩtandatũ rĩkorwo rĩrĩ cekeri mĩrongo ĩtano cia betha, kũringana na cekeri ya handũ-harĩa-haamũre, ");
INSERT INTO kik_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","na aakorwo nĩ mũndũ-wa-nja, ũgaatua irĩhi rĩkorwo rĩrĩ cekeri mĩrongo ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Aakorwo nĩ mũndũ wa kuuma mĩaka ĩtano nginya mĩrongo ĩĩrĩ, ũgaatua irĩhi rĩa mũndũ mũrũme rĩtuĩke nĩ cekeri mĩrongo ĩĩrĩ, na irĩhi rĩa mũndũ-wa-nja nĩ cekeri ikũmi. ");
INSERT INTO kik_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Aakorwo nĩ mũndũ wa kuuma mweri ũmwe nginya mĩaka ĩtano, ũgaatua irĩhi rĩa kahĩĩ rĩtuĩke nĩ cekeri ithano cia betha, na irĩhi rĩa kairĩtu nĩ cekeri ithatũ cia betha. ");
INSERT INTO kik_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Aakorwo nĩ mũndũ wa mĩaka mĩrongo ĩtandatũ kana makĩrĩa, ũgaatua irĩhi rĩa mũndũ mũrũme rĩtuĩke nĩ cekeri ikũmi na ithano, na rĩa mũndũ-wa-nja nĩ cekeri ikũmi. ");
INSERT INTO kik_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Angĩkorwo mũndũ ũrĩa wĩhĩtĩte mwĩhĩtwa nĩ mũthĩĩni mũno ndaangĩhota kũrĩha irĩhi rĩrĩa rĩtuĩtwo, nĩagatwara mũndũ ũcio kũrĩ mũthĩnjĩri-Ngai, ũrĩa ũgaatua irĩhi rĩrĩa mũndũ ũcio wĩhĩtĩte mwĩhĩtwa angĩhota kũrĩha. ");
INSERT INTO kik_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Angĩkorwo kĩndũ kĩrĩa eeranĩire na mwĩhĩtwa nĩ nyamũ ĩngĩĩtĩkĩrĩka ĩrĩ iruta kũrĩ Jehova, nyamũ ta ĩyo ĩheanĩtwo kũrĩ Jehova ĩrĩtuĩkaga nĩ nyamũre. ");
INSERT INTO kik_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Ndakanamĩkũũranie kana amĩgarũranie, aige ĩrĩa njega ithenya rĩa ĩrĩa njũru, kana aige ĩrĩa njũru ithenya rĩa ĩrĩa njega; angĩgakũũrania nyamũ ĩyo na ĩngĩ, cierĩ ĩyo ya mbere na ĩyo ya gũkũũranio nĩigatuĩka nyamũre. ");
INSERT INTO kik_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Angĩkorwo kĩndũ kĩu ehĩtĩte kũruta nĩ nyamũ ĩrĩ na thaahu, ĩrĩa ĩtangĩĩtĩkĩrĩka ĩrĩ iruta kũrĩ Jehova, nyamũ ĩyo no nginya ĩtwarĩrwo mũthĩnjĩri-Ngai, ");
INSERT INTO kik_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ũrĩa ũgaatua kana nĩ njega kana ti njega. Thogora ũrĩa mũthĩnjĩri-Ngai agaatua, ũcio nĩguo ũgaatuĩka thogora wayo. ");
INSERT INTO kik_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Angĩkorwo mwene no ende gũkũũra nyamũ ĩyo, no nginya ongerere gĩcunjĩ kĩngĩ gĩa ithano harĩ thogora ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Mũndũ angĩamũra nyũmba yake ĩrĩ kĩndũ kĩamũrĩirwo Jehova, mũthĩnjĩri-Ngai nĩagatua itua kana nĩ njega kana ti njega. Thogora ũrĩa mũthĩnjĩri-Ngai agaatua, ũcio nĩguo ũgaatuĩka thogora wayo. ");
INSERT INTO kik_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mũndũ ũrĩa wamũrĩte nyũmba yake angĩmĩkũũra-rĩ, no nginya ongerere gĩcunjĩ kĩngĩ gĩa ithano gĩa thogora wayo, nayo nyũmba ĩyo nĩĩgatuĩka yake rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Angĩkorwo mũndũ nĩakamũrĩra Jehova gĩcunjĩ kĩa mũgũnda wa nyũmba yao, thogora waguo ũgaatuuo kũringana na mbeũ iria ingĩhaandwo, nacio nĩ cekeri mĩrongo ĩtano cia betha, iria arĩ kĩbaba kĩmwe kĩa omeri ya mbeũ cia cairi. ");
INSERT INTO kik_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Angĩkaamũra mũgũnda wake Mwaka-inĩ wa Jubilii, thogora ũrĩa ũtuĩtwo nĩguo ũgaatuĩka thogora waguo. ");
INSERT INTO kik_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","No angĩamũra mũgũnda wake thuutha wa Jubilii, mũthĩnjĩri-Ngai nĩagatua thogora kũringana na mĩaka ĩrĩa ĩtigarĩte Jubilii ĩrĩa ĩngĩ ĩgĩgaakinya, naguo thogora waguo nĩũkanyihanyiihio. ");
INSERT INTO kik_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Mũndũ ũcio wamũrĩte mũgũnda wake angĩenda kũũkũũra, nĩakongerera gĩcunjĩ kĩngĩ gĩa ithano harĩ thogora waguo, mũgũnda ũcio ũcooke ũtuĩke wake rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","No rĩrĩ, angĩkorwo ndegũkũũra mũgũnda ũcio, kana aakorwo nĩawendeirie mũndũ ũngĩ, mũgũnda ũcio ndũrĩ hĩndĩ ũgaakũũrwo o na rĩ. ");
INSERT INTO kik_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Rĩrĩa mũgũnda ũcio ũkaarekererio Mwaka-inĩ wa Jubilii, nĩũgatuĩka mwamũre, o ta mũgũnda wamũrĩirwo Jehova; ũgaatuĩka mũgũnda wa athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Ningĩ mũndũ angĩkaamũrĩra Jehova mũgũnda ũrĩa agũrĩte, na ti mũgũnda wa nyũmba yao, ");
INSERT INTO kik_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","mũthĩnjĩri-Ngai nĩagatua thogora waguo nginya Mwaka wa Jubilii, nake mũndũ ũcio nĩakarĩha irĩhi rĩu mũthenya ũcio taarĩ kĩndũ kĩamũrĩirwo Jehova. ");
INSERT INTO kik_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Mwaka-inĩ wa Jubilii, mũgũnda ũcio nĩũgacookerera mwene ũrĩa wamwendeirie, ũrĩa warĩ mwene mũgũnda ũcio. ");
INSERT INTO kik_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Thogora wothe ũrĩtuagwo kũringana na cekeri ya handũ-harĩa-haamũre, nacio nĩ geera mĩrongo ĩĩrĩ harĩ cekeri ĩmwe. ");
INSERT INTO kik_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Na rĩrĩ, gũtirĩ mũndũ ũngĩamũrĩra Jehova irigithathi rĩa nyamũ, nĩ ũndũ marigithathi mothe nĩ ma Jehova; arĩ ndegwa, kana ngʼondu, icio nĩ cia Jehova. ");
INSERT INTO kik_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Angĩkorwo nĩ nyamũ ĩmwe ya iria irĩ thaahu, no amĩgũre na thogora ũrĩa ĩtuĩrĩirwo, ongerere gĩcunjĩ kĩngĩ gĩa ithano harĩ thogora ũcio. Aakorwo ndekũmĩkũũra, nyamũ ĩyo nĩĩkeendio na thogora ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘No gũtirĩ kĩndũ kĩa mũndũ kĩrĩa aamũrĩire Jehova, arĩ mũndũ, kana nyamũ, kana mũgũnda wa nyũmba yao, kĩngĩendio kana gĩkũũrwo; indo ciothe ciamũrĩirwo Jehova nĩ nyamũre harĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Na rĩrĩ, gũtirĩ mũndũ wamũrĩirwo kũũragwo ũngĩkũũrwo; no nginya ooragwo. ");
INSERT INTO kik_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Gĩcunjĩ gĩa ikũmi kĩa indo ciothe cia kuuma mũgũnda, arĩ ngano ya mũgũnda kana maciaro ma mĩtĩ, nĩ kĩa Jehova; gĩcunjĩ kĩu kĩamũrĩirwo Jehova. ");
INSERT INTO kik_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Mũndũ angĩgakũũra gĩcunjĩ gĩake gĩa ikũmi, no nginya akongerera gĩcunjĩ kĩngĩ gĩa ithano harĩ thogora ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Gĩcunjĩ gĩa ikũmi gĩothe kĩa rũũru rwa ngʼombe kana rwa mbũri, nyamũ ya ikũmi yothe ĩrĩa ĩhĩtũkagĩra rungu rwa rũthanju rwa mũrĩithi nĩĩkamũrĩrwo Jehova. ");
INSERT INTO kik_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Mũndũ ndagathuure ĩrĩa njega kana ĩrĩa njũru, kana akũũranie. Angĩgakũũrania nyamũ ĩyo na ĩngĩ, cierĩ, ya mbere na ĩyo ya gũkũũranio, nĩ igaatuĩka nyamũre, na icio itingĩkũũrwo.’ ” ");
INSERT INTO kik_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Macio nĩmo maathani marĩa Jehova aaheire Musa Kĩrĩma-inĩ gĩa Sinai makoniĩ andũ a Isiraeli.");
INSERT INTO kik_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Na rĩrĩ, Jehova akĩarĩria Musa arĩ Hema-inĩ ya Gũtũnganwo kũu Werũ-inĩ wa Sinai mũthenya wa mbere wa mweri wa keerĩ, mwaka-inĩ wa keerĩ kuuma andũ a Isiraeli moima bũrũri wa Misiri. Akĩmwĩra atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Tara kĩrĩndĩ gĩothe kĩa andũ a Isiraeli, ũmatare na mbarĩ ciao, na nyũmba ciao ũrĩa itariĩ, mũndũ mũrũme o mũndũ mũrũme andĩkwo rĩĩtwa rĩake. ");
INSERT INTO kik_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Wee mũrĩ na Harũni mũtare ikundi cia arũme othe arĩa marĩ Isiraeli, arĩa makinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩhota gũthiĩ ita-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Mũndũ ũmwe kuuma o mũhĩrĩga, na akorwo arĩ mũtongoria wa nyũmba yao, nĩo mekũmũteithia. ");
INSERT INTO kik_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Maya nĩmo marĩĩtwa ma andũ arĩa marĩmũteithagĩrĩria: kuuma mũhĩrĩga wa Rubeni, nĩ Elizuru mũrũ wa Shedeuru; ");
INSERT INTO kik_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kuuma mũhĩrĩga wa Simeoni, nĩ Shelumieli mũrũ wa Zurishadai; ");
INSERT INTO kik_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","kuuma mũhĩrĩga wa Juda, nĩ Nahashoni mũrũ wa Aminadabu; ");
INSERT INTO kik_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","kuuma mũhĩrĩga wa Isakaru, nĩ Nethaneli mũrũ wa Zuaru; ");
INSERT INTO kik_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kuuma mũhĩrĩga wa Zebuluni, nĩ Eliabu mũrũ wa Heloni; ");
INSERT INTO kik_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kuuma ariũ a Jusufu: kuuma Efiraimu, nĩ Elishama mũrũ wa Amihudu; kuuma Manase, nĩ Gamalieli mũrũ wa Pedazuru; ");
INSERT INTO kik_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kuuma mũhĩrĩga wa Benjamini, nĩ Abidani mũrũ wa Gideoni; ");
INSERT INTO kik_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","kuuma mũhĩrĩga wa Dani, nĩ Ahiezeri mũrũ wa Amishadai; ");
INSERT INTO kik_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kuuma mũhĩrĩga wa Asheri, nĩ Pagieli mũrũ wa Okirani; ");
INSERT INTO kik_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kuuma mũhĩrĩga wa Gadi, nĩ Eliasafu mũrũ wa Deueli; ");
INSERT INTO kik_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","kuuma mũhĩrĩga wa Nafitali, nĩ Ahira mũrũ wa Enani.” ");
INSERT INTO kik_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Acio nĩo andũ arĩa maathuurirwo kuuma kũrĩ kĩrĩndĩ gĩa Isiraeli, marĩ atongoria a mĩhĩrĩga ya maithe mao ma tene. Nĩo maarĩ atongoria a mĩhĩrĩga ya Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musa na Harũni makĩoya andũ acio maaheetwo marĩĩtwa mao. ");
INSERT INTO kik_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Magĩcooka magĩĩta kĩrĩndĩ gĩothe hamwe mũthenya wa mbere wa mweri wa keerĩ. Andũ makĩonania rũruka rwao kũringana na mbarĩ na nyũmba ciao, nao arũme arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria makĩandĩkwo, o mũndũ o mũndũ na rĩĩtwa rĩake, ");
INSERT INTO kik_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","o ta ũrĩa Jehova aathĩte Musa. Nĩ ũndũ ũcio akĩmatara marĩ kũu Werũ-inĩ wa Sinai: ");
INSERT INTO kik_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Kuuma njiaro-inĩ cia Rubeni, mũriũ wa irigithathi wa Isiraeli: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Kuuma mũhĩrĩga wa Rubeni maarĩ andũ 46,500. ");
INSERT INTO kik_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kuuma njiaro-inĩ cia Simeoni: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, magĩtarwo na makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Kuuma mũhĩrĩga wa Simeoni maarĩ andũ 59,300. ");
INSERT INTO kik_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kuuma njiaro-inĩ cia Gadi: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Kuuma mũhĩrĩga wa Gadi maarĩ andũ 45,650. ");
INSERT INTO kik_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kuuma njiaro-inĩ cia Juda: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Kuuma mũhĩrĩga wa Juda maarĩ andũ 74,600. ");
INSERT INTO kik_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kuuma njiaro-inĩ cia Isakaru: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Kuuma mũhĩrĩga wa Isakaru maarĩ andũ 54,400. ");
INSERT INTO kik_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kuuma njiaro-inĩ cia Zebuluni: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ kana makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Kuuma mũhĩrĩga wa Zebuluni maarĩ andũ 57,400. ");
INSERT INTO kik_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kuuma kũrĩ ariũ a Jusufu: Kuuma njiaro-inĩ cia Efiraimu: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Kuuma mũhĩrĩga wa Efiraimu maarĩ andũ 40,500. ");
INSERT INTO kik_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kuuma njiaro-inĩ cia Manase: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Kuuma mũhĩrĩga-inĩ wa Manase maarĩ andũ 32,200. ");
INSERT INTO kik_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kuuma njiaro-inĩ cia Benjamini: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Kuuma mũhĩrĩga wa Benjamini maarĩ andũ 35,400. ");
INSERT INTO kik_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kuuma njiaro-nĩ cia Dani: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Kuuma mũhĩrĩga wa Dani maarĩ andũ 62,700. ");
INSERT INTO kik_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kuuma njiaro-inĩ cia Asheri: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Kuuma mũhĩrĩga wa Asheri maarĩ andũ 41,500. ");
INSERT INTO kik_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kuuma njiaro-inĩ cia Nafitali: Arũme othe arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ kana makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, makĩandĩkwo o mũndũ o mũndũ na rĩĩtwa rĩake, kũringana na maandĩko ma mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Kuuma mũhĩrĩga wa Nafitali maarĩ andũ 53,400. ");
INSERT INTO kik_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Acio nĩo andũ arĩa maatarirwo nĩ Musa na Harũni na atongoria arĩa ikũmi na eerĩ a Isiraeli, o ũmwe wao arũgamĩrĩire nyũmba yake. ");
INSERT INTO kik_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Andũ othe a Isiraeli arĩa maakinyĩtie mĩaka mĩrongo ĩĩrĩ kana makĩria, arĩa mangĩahotire gũthiĩ ita-inĩ, magĩtarwo kũringana na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Andũ acio othe marĩ hamwe maarĩ 603,550. ");
INSERT INTO kik_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","No rĩrĩ, andũ a nyũmba ya mũhĩrĩga wa Lawi matiataranĩirio hamwe na andũ arĩa angĩ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Jehova nĩeerĩte Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Mũtigatare andũ a mũhĩrĩga wa Lawi kana mũmataranĩrie na andũ arĩa angĩ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Handũ ha ũguo-rĩ, amũrai Alawii matuĩke arori a hema ya Ũira, mamenyagĩrĩre indo ciothe ciayo, na kĩndũ o gĩothe kĩa hema ĩyo. Nĩo marĩkuuaga hema ĩyo o na indo ciothe ciayo; na mamĩmenyagĩrĩre na mamĩthiũrũrũkagĩrie na hema ciao. ");
INSERT INTO kik_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Rĩrĩa rĩothe hema ĩyo ĩgũthaamio, Alawii acio nĩo marĩmĩambũraga, na rĩrĩa rĩothe hema ĩyo ĩĩkwambwo-rĩ, Alawii acio nĩo marĩmĩambaga. Mũndũ ũngĩ o na ũrĩkũ angĩkamĩkuhĩrĩria nĩakooragwo. ");
INSERT INTO kik_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Andũ a Isiraeli marĩambaga hema ciao kũringana na ikundi ciao, o mũndũ kambĩ-inĩ yake harĩa bendera yake ĩrĩ. ");
INSERT INTO kik_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","No rĩrĩ, Alawii marĩambaga hema ciao mathiũrũrũkĩirie hema ya Ũira nĩgeetha kĩrĩndĩ kĩu kĩa Isiraeli gĩtigakorererwo nĩ mangʼũrĩ ma Ngai. Alawii nĩo marĩĩhokagĩrwo ũmenyereri wa hema ĩyo ya Ũira.” ");
INSERT INTO kik_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Nao andũ a Isiraeli magĩĩka maũndũ macio o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nake Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Andũ a Isiraeli nĩmambage hema ciao irigiicĩirie Hema-ya-Gũtũnganwo no irĩ haraaya nayo, o mũndũ arĩ harĩa bendera yake ĩrĩ ĩrĩa ĩrĩ na marũũri ma nyũmba yao.” ");
INSERT INTO kik_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Mwena wa irathĩro, kũrĩa riũa rĩrathagĩra-rĩ, nĩho ikundi cia kambĩ ya mũhĩrĩga wa Juda ikaamba hema harĩa bendera yao ĩrĩ. Mũtongoria wa andũ a Juda nĩ Nahashoni mũrũ wa Aminadabu. ");
INSERT INTO kik_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Gĩkundi gĩake nĩ kĩa andũ 74,600. ");
INSERT INTO kik_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Mũhĩrĩga wa Isakaru ũkaamba hema ciao mariganĩtie na andũ a Juda. Mũtongoria wa andũ a Isakaru nĩ Nethaneli mũrũ wa Zuaru. ");
INSERT INTO kik_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Gĩkundi gĩake nĩ kĩa andũ 54,400. ");
INSERT INTO kik_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Mũhĩrĩga wa Zebuluni nĩguo ũgaacookerera. Mũtongoria wa andũ a Zebuluni nĩ Eliabu mũrũ wa Heloni. ");
INSERT INTO kik_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Gĩkundi gĩake nĩ kĩa andũ 57,400. ");
INSERT INTO kik_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Andũ othe arĩa maagaĩirwo gũikara kambĩ ya Juda, kũringana na ikundi ciao-rĩ, nĩ andũ 186,400. Acio nĩo makaamba kuumagara. ");
INSERT INTO kik_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Mwena wa gũthini nĩho ikundi cia kambĩ ya mũhĩrĩga wa Rubeni igaakorwo, harĩa bendera yao ĩrĩ. Mũtongoria wa andũ a Rubeni nĩ Elizuru mũrũ wa Shedeuru. ");
INSERT INTO kik_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Gĩkundi gĩake nĩ kĩa andũ 46,500. ");
INSERT INTO kik_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Mũhĩrĩga wa Simeoni ũkaamba hema ciao mariganĩtie na Rubeni. Mũtongoria wa andũ a Simeoni nĩ Shelumieli mũrũ wa Zurishadai. ");
INSERT INTO kik_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Gĩkundi gĩake nĩ kĩa andũ 59,300. ");
INSERT INTO kik_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Mũhĩrĩga wa Gadi nĩguo ũgũcookerera. Mũtongoria wa andũ a Gadi nĩ Eliasafu mũrũ wa Deueli. ");
INSERT INTO kik_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Gĩkundi gĩake nĩ kĩa andũ 45,650. ");
INSERT INTO kik_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Andũ othe arĩa magaĩirwo gũikara kambĩ ya Rubeni, kũringana na ikundi ciao-rĩ, nĩ andũ 151,450. Acio nĩo magaatuĩka a keerĩ kuumagara. ");
INSERT INTO kik_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Nayo Hema-ya-Gũtũnganwo na kambĩ ya Alawii moimagare marĩ gatagatĩ ga kambĩ icio ingĩ. Makoimagara marũmanĩrĩire kũringana na ũrĩa hema cia kambĩ ciao ciambĩtwo, o kambĩ ĩrĩ handũ hayo nyene o harĩa bendera yao ĩrĩ. ");
INSERT INTO kik_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Mwena wa ithũĩro nĩkuo ikundi cia kambĩ ya mũhĩrĩga wa Efiraimu igũkorwo, o harĩa bendera yao ĩrĩ. Mũtongoria wa andũ a Efiraimu nĩ Elishama mũrũ wa Amihudu. ");
INSERT INTO kik_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Gĩkundi gĩake nĩ kĩa andũ 40,500. ");
INSERT INTO kik_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Mũhĩrĩga wa Manase nĩguo ũkũrigania nao. Mũtongoria wa andũ a Manase nĩ Gamalieli mũrũ wa Pedazuru. ");
INSERT INTO kik_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Gĩkundi gĩake nĩ kĩa andũ 32,200. ");
INSERT INTO kik_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Mũhĩrĩga wa Benjamini nĩguo ũgũcookerera. Mũtongoria wa andũ a Benjamini nĩ Abidani mũrũ wa Gideoni. ");
INSERT INTO kik_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Gĩkundi gĩake nĩ kĩa andũ 35,400. ");
INSERT INTO kik_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Andũ othe arĩa maagaĩirwo gũikara kambĩ ya Efiraimu, kũringana na ikundi ciao-rĩ, nĩ andũ 108,100. Acio nĩo marĩthiiaga marĩ a gatatũ. ");
INSERT INTO kik_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Mwena wa gathigathini nĩkuo ikundi cia kambĩ ya mũhĩrĩga wa Dani igũkorwo, harĩa bendera yao ĩrĩ. Mũtongoria wa andũ a Dani nĩ Ahiezeri mũrũ wa Amishadai. ");
INSERT INTO kik_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Gĩkundi gĩake nĩ kĩa andũ 62,700. ");
INSERT INTO kik_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Mũhĩrĩga wa Asheri ũkaamba hema ciao mariganĩtie nao. Mũtongoria wa andũ a Asheri nĩ Pagieli mũrũ wa Okirani. ");
INSERT INTO kik_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Gĩkundi gĩake nĩ kĩa andũ 41,500. ");
INSERT INTO kik_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Mũhĩrĩga wa Nafitali nĩguo ũgũcookerera. Mũtongoria wa andũ a Nafitali nĩ Ahira mũrũ wa Enani. ");
INSERT INTO kik_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Gĩkundi gĩake nĩ kĩa andũ 53, 400. ");
INSERT INTO kik_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Andũ othe arĩa magaĩirwo gũikara kambĩ ya Dani nĩ andũ 157,600. Acio nĩo magaakorwo marĩ a mũthia kuumagara, marĩ harĩa bendera ciao irĩ. ");
INSERT INTO kik_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Acio nĩo andũ a Isiraeli, arĩa maatarirwo kũringana na nyũmba ciao. Arĩa othe maarĩ kambĩ-inĩ kũringana na ikundi ciao-rĩ, maarĩ andũ 603,550. ");
INSERT INTO kik_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","No rĩrĩ, Alawii matiataranĩirio na andũ arĩa angĩ a Isiraeli, ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Nĩ ũndũ ũcio andũ a Isiraeli magĩĩka maũndũ mothe marĩa Jehova aathĩte Musa, na tondũ ũcio maambire hema harĩa bendera ciao ciarĩ, na ũguo noguo moimagarire, o mũtongoria na andũ a mũhĩrĩga wake na nyũmba yake. ");
INSERT INTO kik_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ũyũ nĩguo ũhoro wa njiaro cia Harũni na Musa hĩndĩ ĩrĩa Jehova aaririe na Musa Kĩrĩma-inĩ gĩa Sinai. ");
INSERT INTO kik_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Marĩĩtwa ma ariũ a Harũni maarĩ Nadabu ũrĩa warĩ irigithathi, na Abihu, na Eleazaru, na Ithamaru. ");
INSERT INTO kik_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Macio nĩmo marĩĩtwa ma ariũ a Harũni, nao maarĩ athĩnjĩri-Ngai aitĩrĩrie maguta, arĩa maamũrĩtwo matungatage marĩ athĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Na rĩrĩ, Nadabu na Abihu nĩmakuire marĩ mbere ya Jehova rĩrĩa maarutaga igongona na mwaki ũtarĩ mwĩtĩkĩrie mbere yake Werũ-inĩ wa Sinai. Matiarĩ na ciana cia aanake; nĩ ũndũ ũcio, Eleazaru na Ithamaru nĩo maatungataga marĩ athĩnjĩri-Ngai hĩndĩ ĩrĩa yothe ithe wao Harũni aarĩ muoyo. ");
INSERT INTO kik_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Rehe andũ a mũhĩrĩga wa Lawi ũmaneane kũrĩ Harũni mũthĩnjĩri-Ngai, nĩguo mamũteithagie. ");
INSERT INTO kik_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Marĩĩrutaga wĩra wa kũmũtungatĩra, na matungatagĩre kĩrĩndĩ kĩu gĩothe hau Hema-inĩ-ya-Gũtũnganwo na ũndũ wa kũruta wĩra wa hema ĩyo. ");
INSERT INTO kik_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Nao marĩmenyagĩrĩra indo ciothe cia Hema-ya-Gũtũnganwo, mahingagie maũndũ marĩa magĩrĩire nĩ gwĩkwo nĩ andũ a Isiraeli na ũndũ wa kũruta wĩra wa hema ĩyo. ");
INSERT INTO kik_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Neana Alawii acio kũrĩ Harũni na ariũ ake; nĩo andũ a Isiraeli arĩa mekũneanwo kũrĩ we biũ. ");
INSERT INTO kik_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Amũra Harũni na ariũ ake matungatage marĩ athĩnjĩri-Ngai; mũndũ ũngĩ o wothe ũrĩa ũrĩkuhagĩrĩria harĩa haamũre no nginya ooragwo.” ");
INSERT INTO kik_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Niĩ nĩ niĩ thuurĩte Alawii kuuma kũrĩ andũ a Isiraeli ithenya rĩa marigithathi ma arũme arĩa marigithathĩtwo nĩ andũ-a-nja othe a Isiraeli. Alawii nĩ akwa, ");
INSERT INTO kik_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","nĩgũkorwo marigithathi mothe nĩ makwa. Hĩndĩ ĩrĩa ndooragire marigithathi mothe ma Misiri, noguo ndeyamũrĩire marigithathi mothe ma Isiraeli, marĩ ma mũndũ kana ma nyamũ. Macio nĩ makwa kĩũmbe. Niĩ nĩ niĩ Jehova.” ");
INSERT INTO kik_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ningĩ Jehova akĩĩra Musa kũu Werũ-inĩ wa Sinai atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Tara Alawii kũringana na nyũmba ciao na mbarĩ ciao. Tara arũme othe arĩa makinyĩtie mweri ũmwe na makĩria.” ");
INSERT INTO kik_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Nĩ ũndũ ũcio, Musa akĩmatara o ta ũrĩa aathĩtwo nĩ kiugo kĩa Jehova. ");
INSERT INTO kik_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Maya nĩmo marĩĩtwa ma ariũ a Lawi: Nĩ Gerishoni, na Kohathu, na Merari. ");
INSERT INTO kik_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Maya nĩmo marĩĩtwa ma mbarĩ cia Agerishoni: Nĩ Libini na Shimei. ");
INSERT INTO kik_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Mbarĩ cia Akohathu ciarĩ: Amuramu, na Iziharu na Hebironi, na Uzieli. ");
INSERT INTO kik_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Mbarĩ cia Amerari: ciarĩ Mahali na Mushi. Ici nĩcio ciarĩ mbarĩ cia Alawii, kũringana na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gerishoni aarĩ na mbarĩ cia Alabini na Ashimei; ici nĩcio ciarĩ mbarĩ cia Agerishoni. ");
INSERT INTO kik_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Arũme arĩa othe maakinyĩtie mweri ũmwe na makĩria arĩa maatarirwo maarĩ andũ 7,500. ");
INSERT INTO kik_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Mbarĩ icio cia Agerishoni ciarĩ ciambe hema ciao mwena wa ithũĩro, thuutha wa Hema-ĩrĩa-Nyamũre. ");
INSERT INTO kik_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Mũtongoria wa nyũmba cia Agerishoni aarĩ Eliasafu mũrũ wa Laeli. ");
INSERT INTO kik_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Hau Hema-inĩ-ya-Gũtũnganwo-rĩ, Agerishoni nĩo maarĩ na wĩra wa kũmenyerera Hema-ĩyo-Nyamũre na hema, na ciandarũa cia kũmĩhumbĩra, na gĩtambaya gĩa gũcuurio itoonyero rĩa Hema-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","na itambaya cia gũcuurio cia kũirigĩra nja, na gĩtambaya gĩa gũcuurio gĩa itoonyero rĩa nja ĩrĩa ĩthiũrũkĩirie Hema ĩyo nyamũre na kĩgongona na mĩhĩndo, na indo ciothe iria ikonainie na wĩra wacio. ");
INSERT INTO kik_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohathu aarĩ na mbarĩ cia Aamuramu, na Aiziharu, na Ahebironi, na Auzieli; icio nĩcio ciarĩ mbarĩ cia Akohathu. ");
INSERT INTO kik_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Arũme arĩa othe maakinyĩtie mweri ũmwe na makĩria maarĩ andũ 8,600. Wĩra wa Akohathu warĩ wa kũmenyerera harĩa haamũre. ");
INSERT INTO kik_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Mbarĩ cia Akohathu ciarĩ ciambage hema mwena wa gũthini wa Hema-ĩrĩa-Nyamũre. ");
INSERT INTO kik_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Mũtongoria wa nyũmba cia mbarĩ cia Akohathu aarĩ Elizafani mũrũ wa Uzieli. ");
INSERT INTO kik_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Wĩra wao warĩ wa kũmenyerera ithandũkũ rĩa kĩrĩkanĩro, na metha, na mũtĩ ũrĩa wa kũigĩrĩrwo matawa, na igongona, na indo cia gũtũmĩrwo harĩa haamũre, na gĩtambaya gĩa gũcuurio gĩa kũhakania, o na indo ciothe ciakonainie na mũhũthĩrĩre wacio. ");
INSERT INTO kik_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Mũtongoria mũnene wa Alawii aarĩ Eleazaru mũrũ wa Harũni, ũrĩa mũthĩnjĩri-Ngai. Nĩwe watuirwo mũrũgamĩrĩri wa arĩa maamenyagĩrĩra harĩa haamũre. ");
INSERT INTO kik_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari aarĩ na mbarĩ cia Amahali na Amushi; icio nĩcio ciarĩ mbarĩ cia Merari. ");
INSERT INTO kik_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Arũme arĩa othe maatarirwo arĩa maakinyĩtie mweri ũmwe na makĩria maarĩ andũ 6,200. ");
INSERT INTO kik_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Mũtongoria wa nyũmba cia mbarĩ ya Merari aarĩ Zurieli mũrũ wa Abihaili; nao maarĩ maambage hema mwena wa gathigathini wa Hema-ĩrĩa-Nyamũre. ");
INSERT INTO kik_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Amerari maamũrirwo mamenyagĩrĩre buremu ya hema ĩrĩa yaamũrĩtwo, na mĩgĩĩko yayo, na itugĩ, na itina ciacio, o na indo ciothe ciayo cia wĩra, na indo ciothe ciakonainie na mũhũthĩrĩre wacio, ");
INSERT INTO kik_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","o na mamenyagĩrĩre itugĩ iria ciirigĩte nja yayo hamwe na itina ciacio, na higĩ cia hema na mĩhĩĩndo yayo. ");
INSERT INTO kik_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa na Harũni na ariũ ake maarĩ mambage hema ciao mwena wa irathĩro wa Hema-ĩyo-Nyamũre, mangʼetheire irathĩro, o hau mbere ya Hema-ya-Gũtũnganwo. Wĩra wao warĩ wa kũmenyerera harĩa haamũre ithenya rĩa andũ a Isiraeli. Mũndũ ũngĩ o wothe ũngĩakuhĩrĩirie hau haamũre aarĩ ooragwo. ");
INSERT INTO kik_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Alawii arĩa othe maatarirwo ta ũrĩa Jehova aathĩte Musa na Harũni kũringana na mbarĩ ciao, hamwe na arũme othe arĩa maakinyĩtie mweri ũmwe na makĩria, maarĩ andũ 22,000. ");
INSERT INTO kik_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Nake Jehova akĩĩra Musa atĩrĩ, “Tara marigithathi ma arũme othe ma andũ a Isiraeli arĩa makinyĩtie mweri ũmwe na makĩria, na wandĩke marĩĩtwa mao. ");
INSERT INTO kik_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nyamũrĩra Alawii handũ ha marigithathi mothe ma andũ a Isiraeli; o naguo ũhiũ wa Alawii ũwaamũre handũ ha marigithathi mothe ma mahiũ ma andũ a Isiraeli. Niĩ nĩ niĩ Jehova.” ");
INSERT INTO kik_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Nĩ ũndũ ũcio Musa agĩtara marigithathi mothe ma andũ a Isiraeli, o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Marigithathi mothe ma arũme arĩa maakinyĩtie mweri ũmwe na makĩria, maandĩkwo na marĩĩtwa mao, maarĩ andũ 22,273. ");
INSERT INTO kik_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Amũra Alawii handũ ha marigithathi mothe ma andũ a Isiraeli, naguo ũhiũ wa Alawii ũwaamũre handũ ha mahiũ mao. Alawii megũtuĩka akwa. Niĩ nĩ niĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Gũkũũra marigithathi macio 273 ma andũ a Isiraeli, acio makĩrĩte mũigana wa Alawii-rĩ, ");
INSERT INTO kik_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","oya cekeri ithano irũgamĩrĩre o mũndũ, kũringana na cekeri ya handũ-harĩa-haamũre, ĩrĩa ũritũ wayo ũrĩ gera mĩrongo ĩĩrĩ. ");
INSERT INTO kik_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Mbeeca icio cia gũkũũra andũ a Isiraeli acio makĩrĩte-rĩ, cinengere Harũni na ariũ ake.” ");
INSERT INTO kik_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Nĩ ũndũ ũcio Musa akĩũngania mbeeca cia gũkũũra andũ acio maakĩrĩte mũigana wa andũ arĩa maakũũrĩtwo nĩ Alawii. ");
INSERT INTO kik_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Kuuma kũrĩ marigithathi ma andũ a Isiraeli, akĩũngania betha ya ũritũ wa cekeri 1,365 kũringana na cekeri ya handũ-harĩa-haamũre. ");
INSERT INTO kik_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Musa akĩnengera Harũni na ariũ ake mbeeca icio ciakũũrĩte andũ, o ta ũrĩa aathĩtwo nĩ kiugo kĩa Jehova. ");
INSERT INTO kik_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Jehova akĩĩra Musa na Harũni atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Thĩinĩ wa Alawii-rĩ, tarai rũhonge rwa Akohathu kũringana na mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Mũtare arũme othe a ũkũrũ wa kuuma mĩaka mĩrongo ĩtatũ nginya mĩaka mĩrongo ĩtano arĩa mokaga gũtungata wĩra-inĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Ũyũ nĩguo wĩra wa Akohathu thĩinĩ wa Hema-ya-Gũtũnganwo: wĩra wao nĩ kũmenyerera indo iria theru mũno. ");
INSERT INTO kik_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Rĩrĩa kambĩ ĩgũthaama-rĩ, Harũni na ariũ ake marĩtoonyaga thĩinĩ wa hema ĩyo makaruta gĩtambaya gĩa gũcuurio gĩa kũhakania na makahumbĩra ithandũkũ rĩa Ũira nakĩo. ");
INSERT INTO kik_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ningĩ marĩhumbĩre na gĩthii kĩa njũũa cia pomboo, na maare gĩtambaya kĩa rangi wa bururu mũtheri igũrũ rĩacio, na matoonyie mĩtĩ ya kũrĩkuua handũ hayo. ");
INSERT INTO kik_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Nao maare gĩtambaya kĩa rangi wa bururu igũrũ rĩa metha ya mĩgate ĩrĩa ĩigagwo mbere ya Jehova, na mamĩigĩrĩre thaani, na thaani, nene na mbakũri, na ndigithũ cia magongona ma kũnyuuo; na mĩgate ĩrĩa ĩigagwo hau hĩndĩ ciothe ĩikare o hau igũrũ. ");
INSERT INTO kik_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Macooke maigĩrĩre gĩtambaya kĩa rangi wa gakarakũ igũrũ rĩa indo icio na ningĩ mahumbĩre gĩtambaya kĩu na njũũa cia pomboo, na matoonyie mĩtĩ ya kũrĩkuua handũ hayo. ");
INSERT INTO kik_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Ningĩ moe gĩtambaya kĩa rangi wa bururu, mahumbĩre mũtĩ ũrĩa wa kũigĩrĩrwo matawa marĩa mamũrĩkaga, hamwe na matawa maguo, na magathĩ ma gũtinia ndaambĩ, na thaani cia mũrarĩ wa ndaambĩ, na ndigithũ cia gwĩkĩrwo maguta ma matawa macio. ");
INSERT INTO kik_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ningĩ makũnje mũtĩ ũcio na indo ciaguo ciothe ciohetwo na gĩthii kĩa njũũa cia pomboo, na macigĩrĩre igũrũ rĩa gĩkuui gĩacio. ");
INSERT INTO kik_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Nĩ maare gĩtambaya kĩa rangi wa bururu igũrũ rĩa kĩgongona gĩa thahabu, na makĩhumbĩre na gĩthii kĩa njũũa cia pomboo, na matoonyie mĩtĩ ĩrĩa ya gũgĩkuua handũ hayo. ");
INSERT INTO kik_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Ningĩ moe indo ciothe iria ihũthagĩrwo ũtungata-inĩ wa handũ-harĩa-haamũre, macikũnje na gĩtambaya kĩa rangi wa bururu, macihumbĩre na gĩthii kĩa njũũa cia pomboo, na maciigĩrĩre igũrũ rĩa gĩkuui gĩacio. ");
INSERT INTO kik_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Ningĩ nĩ marute mũhu kuuma kĩgongona-inĩ gĩa gĩcango, na maare gĩtambaya kĩa rangi wa ndathi igũrũ rĩakĩo. ");
INSERT INTO kik_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ningĩ maigĩrĩre indo ciothe iria ihũthagĩrwo gũtungata kĩgongona-inĩ, nacio nĩ hamwe na ngĩo cia mwaki, na njibe, na icakũri, na mbakũri cia kũminjaminjĩria. Igũrũ rĩakĩo nĩ maare gĩthii kĩa njũũa cia pomboo na matoonyie mĩtĩ ya gũgĩkuua handũ hayo. ");
INSERT INTO kik_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Thuutha wa Harũni na ariũ ake kũrĩĩkia kũhumbĩra indo ciothe theru o na indo ciothe nyamũre, na rĩrĩa andũ a kambĩ mehaarĩria gũthaama-rĩ, ariũ a Akohathu nao moke makuue indo icio. No matikanahutie indo icio nyamũre matigakue. Akohathu acio nĩo magaakuua indo iria irĩ thĩinĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleazaru mũrũ wa Harũni, ũrĩa mũthĩnjĩri-Ngai, nĩwe ũrĩmenyagĩrĩra maguta ma gwakia tawa, na ũbumba ũrĩa ũnungaga wega, na mũtu ũrĩa ũrutagwo hĩndĩ ciothe, o na maguta marĩa maitanagĩrĩrio. Nĩwe ũrĩmenyagĩrĩra Hema-ĩyo-Nyamũre ĩrĩ yothe na indo iria ciothe irĩ thĩinĩ wayo, nĩcio indo iria nyamũre ciĩkĩrĩtwo kuo, na indo cia wĩra.” ");
INSERT INTO kik_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Menyererai mbarĩ cia mũhĩrĩga wa Akohathu matikaneherio kuuma kũrĩ Alawii. ");
INSERT INTO kik_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Nĩguo matũũre muoyo na matikae gũkua rĩrĩa mangĩkuhĩrĩria indo iria theru mũno-rĩ, mekagĩrei ũũ: Harũni na ariũ ake nĩo marĩtoonyaga handũ harĩa hatheru, na makagaĩra o mũndũ wĩra wake na kĩrĩa egũkuua. ");
INSERT INTO kik_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","No ariũ a Kohathu matikanatoonye thĩinĩ kuona indo iria theru o na hanini, nĩguo matigaakue.” ");
INSERT INTO kik_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Tara Agerishoni o nao kũringana na nyũmba ciao na mbarĩ ciao. ");
INSERT INTO kik_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ũtare arũme othe a ũkũrũ wa kuuma mĩaka mĩrongo ĩtatũ nginya mĩaka mĩrongo ĩtano arĩa mokaga gũtungata wĩra-inĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Ũyũ nĩguo ũtungata wa mbarĩ cia Agerishoni rĩrĩa mekũruta wĩra na gũkuua mĩrigo: ");
INSERT INTO kik_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Nĩo marĩkuuaga itambaya cia gũcuurio cia Hema-ĩrĩa-Nyamũre, na Hema-ya-Gũtũnganwo, na indo cia kũmĩhumbĩra, o na gĩthii kĩa njũũa cia pomboo cia kũmĩhumbĩra na igũrũ, na itambaya cia gũcuurio cia itoonyero rĩa Hema-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","na itambaya cia gũcuurio iria cia kũirigĩra nja ĩrĩa ĩthiũrũrũkĩirie Hema-ĩyo-Nyamũre na kĩgongona, na gĩtambaya gĩa gũcuurio gĩa itoonyero-inĩ, na mĩhĩndo na indo ciothe itũmagĩrwo ũtungata-inĩ wayo. Agerishoni acio nĩo marĩrutaga wĩra wothe ũrĩa wagĩrĩire kũrutwo na indo icio. ");
INSERT INTO kik_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Ũtungata wao wothe, ũrĩ wa gũkuua mĩrigo kana wa kũruta wĩra ũngĩ, ũrĩĩrutagwo ũtongoretio nĩ Harũni na ariũ ake. Nĩ inyuĩ mũrĩmagayagĩra wĩra wao wa kĩrĩa gĩothe marĩkuuaga. ");
INSERT INTO kik_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ũcio nĩguo ũtungata wa mbarĩ ya Agerishoni Hema-inĩ-ya-Gũtũnganwo. Wĩra wao ũrĩĩrutagwo ũtongoretio nĩ Ithamaru mũrũ wa Harũni, ũrĩa mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Tara Amerari kũringana na mbarĩ na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Tara arũme othe a ũkũrũ wa kuuma mĩaka mĩrongo ĩtatũ nginya mĩaka mĩrongo ĩtano arĩa mokaga gũtungata wĩra-inĩ wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ũyũ nĩguo wĩra wao ũrĩa marĩrutaga magĩtungata Hema-inĩ-ya-Gũtũnganwo: wĩra wao nĩ gũkuuaga buremu cia Hema-ĩyo-Nyamũre, na mĩgĩĩko yayo, na itugĩ na itina ciacio, ");
INSERT INTO kik_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","o ũndũ ũmwe na itugĩ iria ciirigĩte nja hamwe na itina ciacio, na higĩ cia hema na mĩhĩndo, na indo ciothe ciacio na kĩndũ gĩothe gĩkonainie na kũruta wĩra ũcio. Gayagĩra o mũndũ indo iria agĩrĩirwo nĩ gũkuua. ");
INSERT INTO kik_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ũcio nĩguo ũtungata wa mbarĩ ya Amerari rĩrĩa marĩrutaga wĩra Hema-inĩ-ya-Gũtũnganwo, matongoretio nĩ Ithamaru mũrũ wa Harũni, ũrĩa mũthĩnjĩri-Ngai.” ");
INSERT INTO kik_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Na rĩrĩ, Musa, na Harũni, na atongoria a kĩrĩndĩ nĩmatarire Akohathu acio kũringana na mbarĩ na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Arũme othe a ũkũrũ wa kuuma mĩaka mĩrongo ĩtatũ nginya mĩaka mĩrongo ĩtano arĩa mookire gũtungata wĩra-inĩ wa Hema-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","matarĩtwo na mbarĩ ciao, maarĩ andũ 2,750 ");
INSERT INTO kik_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ũcio nĩguo warĩ mũigana wa andũ othe arĩa maarĩ a mbarĩ cia Akohathu arĩa maatungataga thĩinĩ wa Hema-ya-Gũtũnganwo. Musa na Harũni maamatarire kũringana na ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Agerishoni maatarirwo kũringana na mbarĩ na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Arũme othe a ũkũrũ wa kuuma mĩaka mĩrongo ĩtatũ nginya mĩaka mĩrongo ĩtano arĩa mookire gũtungata wĩra-inĩ wa Hema-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","matarĩtwo na mbarĩ na nyũmba ciao, maarĩ andũ 2,630. ");
INSERT INTO kik_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ũcio nĩguo warĩ mũigana wa mbarĩ cia Agerishoni arĩa maatungataga thĩinĩ wa Hema-ya-Gũtũnganwo. Musa na Harũni maamatarire kũringana na watho wa Jehova. ");
INSERT INTO kik_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Amerari maatarirwo kũringana na mbarĩ na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Arũme othe a ũkũrũ wa kuuma mĩaka mĩrongo ĩtatũ nginya mĩaka mĩrongo ĩtano arĩa mookire gũtungata wĩra-inĩ wa Hema-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","matarĩtwo na mbarĩ ciao, maarĩ andũ 3,200. ");
INSERT INTO kik_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ũcio nĩguo warĩ mũigana wa mbarĩ cia Amerari. Musa na Harũni maamatarire kũringana na ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Nĩ ũndũ ũcio, Musa na Harũni na atongoria a Isiraeli magĩtara Alawii othe kũringana na mbarĩ ciao na nyũmba ciao. ");
INSERT INTO kik_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Arũme othe a ũkũrũ wa kuuma mĩaka mĩrongo ĩtatũ nginya mĩaka mĩrongo ĩtano arĩa mookire kũruta wĩra wa gũtungata na gũkuua Hema-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","mũigana wao warĩ andũ 8,580. ");
INSERT INTO kik_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Kũringana na watho wa Jehova ũrĩa aathĩte Musa, mũndũ o mũndũ nĩagayagĩrwo wĩra wake, na akeerwo kĩrĩa egũkuua. Ũguo nĩguo maatarirwo, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Atha andũ a Isiraeli maingate kuuma kambĩ-inĩ yao mũndũ o wothe ũrũarĩte mũrimũ wa ngoothi ũrĩa ũngĩgwatanio, kana mũndũ ũrĩ na handũ o na ha he kuura, kana mũndũ ũrĩ na thaahu nĩ ũndũ wa kũhutia kĩimba. ");
INSERT INTO kik_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ingata arũme o na andũ-a-nja; ũmaingate nja ya kambĩ nĩguo matigathaahie kambĩ yao kũrĩa niĩ ndũũranagia na inyuĩ.” ");
INSERT INTO kik_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ũguo noguo andũ a Isiraeli meekire; makĩruta andũ acio nja ya kambĩ. Magĩĩka o ũrĩa Jehova aathĩte Musa gwĩkwo. ");
INSERT INTO kik_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Ĩra andũ a Isiraeli atĩrĩ, ‘Rĩrĩa mũndũ mũrũme kana mũndũ-wa-nja angĩhĩtĩria mũndũ ũrĩa ũngĩ na njĩra o yothe, na nĩ ũndũ ũcio aage kwĩhokeka harĩ Jehova-rĩ, mũndũ ũcio nĩ mũhĩtia, ");
INSERT INTO kik_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","na no nginya oimbũre mehia marĩa ekĩte. No nginya arute irĩhi rĩothe nĩ ũndũ wa mahĩtia macio make, na ongerere gĩcunjĩ gĩa ithano kũrĩ irĩhi rĩu, anengere mũndũ ũcio ahĩtĩirie. ");
INSERT INTO kik_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","No mũndũ ũcio angĩkorwo ndarĩ na mũndũ wa nyũmba yao ũrĩa ũngĩrĩhwo nĩ ũndũ wa ihĩtia rĩu, irĩhi rĩu rĩrĩtuĩkaga rĩa Jehova, na no nginya rĩnengerwo mũthĩnjĩri-Ngai rĩrĩ hamwe na ndũrũme ya kũrutwo igongona rĩa horohio nĩ ũndũ wake. ");
INSERT INTO kik_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Maruta mothe maamũre marĩa andũ a Isiraeli marĩrehagĩra mũthĩnjĩri-Ngai-rĩ, marĩtuĩkaga make. ");
INSERT INTO kik_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Iheo cia o mũndũ iria nyamũre nĩ ciake we mwene, no kĩrĩa angĩhe mũthĩnjĩri-Ngai, gĩgaatuĩka kĩa mũthĩnjĩri-Ngai ũcio.’ ” ");
INSERT INTO kik_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Mũtumia wa mũndũ angĩhĩngĩcania mĩthiĩre yake, atuĩke ti mwĩhokeku harĩ we ");
INSERT INTO kik_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","na ũndũ wa gũkoma na mũndũ ũngĩ, na ũndũ ũcio ũhithwo mũthuuriwe na thaahu wake wage kũmenyeka (tondũ hatirĩ mũira wa kũmuumbũra, na ndaakorereirwo agĩĩka ũndũ ũcio-rĩ), ");
INSERT INTO kik_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","na mũthuuriwe aiguĩre mũtumia wake ũiru na amwĩkũũĩre atĩ nĩethaahĩtie, kana amũiguĩre ũiru na amwĩkũũĩre o na akorwo atethaahĩtie, ");
INSERT INTO kik_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","hĩndĩ ĩyo nĩatware mũtumia wake harĩ mũthĩnjĩri-Ngai. Ningĩ no nginya atware gĩcunjĩ gĩa ikũmi kĩa eba ĩmwe ya mũtu wa cairi nĩ ũndũ wa mũtumia wake. Ndagaitĩrĩrie mũtu ũcio maguta kana awĩkĩre ũbumba, nĩ ũndũ rĩu nĩ iruta rĩa mũtu rĩrutagwo nĩ ũndũ wa ũiru, iruta rĩa mũtu rĩa kĩririkano, rĩa kũririkanania ihĩtia rĩu. ");
INSERT INTO kik_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Mũthĩnjĩri-Ngai nĩagatwara mũtumia ũcio amũrũgamie mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Acooke oe maaĩ maamũre marĩ ndigithũ-inĩ ya rĩũmba, na ahakũre rũkũngũ hau thĩ ya Hema-ĩrĩa-Nyamũre arwĩkĩre maaĩ-inĩ macio. ");
INSERT INTO kik_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Mũthĩnjĩri-Ngai aarĩkia kũrũgamia mũtumia ũcio mbere ya Jehova, nĩakamuohora njuĩrĩ yake, acooke amũnengere iruta rĩu rĩa kĩririkano rĩa mũtu nĩ ũndũ wa ũiru arĩnyiite na moko, nake mũthĩnjĩri-Ngai we mwene akorwo anyiitĩte maaĩ macio marũrũ marĩa marehaga kĩrumi. ");
INSERT INTO kik_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Mũthĩnjĩri-Ngai acooke ehĩtithie mũtumia ũcio, amwĩre atĩrĩ, “Angĩkorwo hatirĩ mũndũ ũngĩ ũkomete nawe, na ndũhĩngĩcanĩtie mĩthiĩre yaku ũgethaahia hĩndĩ ĩrĩa ũrĩ na mũthuuri-rĩ, maaĩ maya marũrũ marĩa marehaga kĩrumi maroaga gũgwĩka ũũru. ");
INSERT INTO kik_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","No angĩkorwo nĩũhĩngĩcanĩtie mĩthiĩre yaku ũrĩ na mũthuuri na ũgethaahia nĩ ũndũ wa gũkoma na mũndũ ũngĩ tiga mũthuuriguo-rĩ,” ");
INSERT INTO kik_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","hĩndĩ ĩyo mũthĩnjĩri-Ngai nĩakehĩtithia mũtumia ũcio na mwĩhĩtwa ũyũ ũrehanagĩra kĩrumi, oige atĩrĩ, “Jehova arotũma andũ anyu makũrume na magũkaane, rĩrĩa agaatũma kĩero gĩaku kĩhinyare na nda yaku ĩimbe. ");
INSERT INTO kik_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Namo maaĩ maya marehaga kĩrumi marotoonya mwĩrĩ waku, nayo nda yaku ĩimbe na kĩero gĩaku kĩhinyare.” “ ‘Nake mũtumia ũcio acooke oige atĩrĩ, “Ameni, nĩgũtuĩke ũguo.” ");
INSERT INTO kik_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Mũthĩnjĩri-Ngai nĩakandĩka irumi icio ibuku-inĩ rĩa gĩkũnjo, acooke acithambĩrie maaĩ-inĩ macio marũrũ. ");
INSERT INTO kik_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Nĩagatũma mũtumia ũcio anyue maaĩ macio marũrũ marehaga kĩrumi, namo maaĩ macio mamũtoonye na matũme aigue ruo rũnene mũno. ");
INSERT INTO kik_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Mũthĩnjĩri-Ngai acooke oe iruta rĩu rĩa mũtu nĩ ũndũ wa ũiru kuuma moko-inĩ ma mũtumia ũcio, arĩthũngũthie mbere ya Jehova, na acooke arĩrehe kĩgongona-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Ningĩ mũthĩnjĩri-Ngai ũcio arũme ngundi ĩmwe ya mũtu ũcio ũrutĩtwo ũrĩ wa kĩririkano na aũcinĩre igũrũ rĩa kĩgongona; thuutha ũcio atũme mũtumia ũcio anyue maaĩ macio. ");
INSERT INTO kik_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Angĩkorwo nĩethaahĩtie na ti mwĩhokeku harĩ mũthuuriwe-rĩ, rĩrĩa akaanyuithio maaĩ macio marehaga kĩrumi, nĩ makaamũtoonya matũme aigue ruo rũnene mũno, na nda yake ĩimbe na kĩero gĩake kĩhinyare, nake atuĩke thaahu kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","No rĩrĩ, angĩkorwo mũtumia ũcio ndethaahĩtie na akorwo nĩ mũthingu-rĩ, ndagatuuo mũhĩtia, na nĩakahota kũgĩa na ciana. ");
INSERT INTO kik_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Ũyũ nĩguo watho wa ũiru rĩrĩa mũtumia angĩhĩngĩcania mĩthiĩre yake, ethaahie o arĩ na mũthuuri, ");
INSERT INTO kik_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","kana rĩrĩa mũndũ mũrũme angĩnyiitwo nĩ ũiru nĩ ũndũ nĩegwĩkũũa mũtumia ũcio wake. Mũthĩnjĩri-Ngai arĩmũrũgamagia mbere ya Jehova na arũmĩrĩre watho ũcio wothe. ");
INSERT INTO kik_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mũthuuriwe nĩagatuuo ndarĩ na ihĩtia o na rĩrĩkũ, no mũtumia ũcio nĩwe ũgaacookererwo nĩ mehia make.’ ” ");
INSERT INTO kik_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Mũndũ mũrũme kana mũndũ-wa-nja angĩenda kwĩhĩta mwĩhĩtwa wa mwanya, ũrĩ mwĩhĩtwa wa kwĩyamũrĩra Jehova atuĩke Mũnaziri, ");
INSERT INTO kik_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","no nginya atige kũnyua ndibei o na indo iria ingĩ ngagatu cia kũnyua, na ndakananyue thiki ĩthondeketwo kuuma kũrĩ ndibei kana kĩndũ kĩngĩ kĩgagatu gĩa kũnyua. Ndakananyue maaĩ ma thabibũ, kana arĩe thabibũ, kana thabibũ iria nyũmithie. ");
INSERT INTO kik_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Hĩndĩ ĩrĩa yothe arĩkoragwo arĩ Mũnaziri, ndakanarĩe kĩndũ gĩa kuuma he mũthabibũ, irĩ mbegũ kana makoni. ");
INSERT INTO kik_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Ihinda rĩothe rĩa mwĩhĩtwa ũcio wa kwĩyamũra, ndakanenjwo mũtwe. No nginya aikarage arĩ mũtheru o nginya ihinda rĩake rĩa kwĩyamũrĩra Jehova rĩthire; no nginya areke njuĩrĩ cia mũtwe wake ikũre iraihe. ");
INSERT INTO kik_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ihinda rĩu rĩothe eyamũrĩire Jehova ndakanakuhĩrĩrie kĩimba. ");
INSERT INTO kik_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","O na ithe, kana nyina, kana mũrũ wa nyina, kana mwarĩ wa nyina angĩkua, ndakanethaahie nĩ ũndũ wao, tondũ arĩ na rũũri rwa kwĩyamũrĩra Ngai mũtwe. ");
INSERT INTO kik_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ihinda rĩothe rĩa kwĩyamũra gwake arĩkoragwo aamũrĩirwo Jehova. ");
INSERT INTO kik_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Mũndũ angĩkua gĩkuũ kĩa narua arĩ ho, naguo ũndũ ũcio ũthaahie njuĩrĩ ĩrĩa aamũrĩte, no nginya enjwo mũtwe mũthenya wake wa gũtherio, na nĩguo wa mũgwanja. ");
INSERT INTO kik_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ningĩ mũthenya wa ĩnana no nginya atware ndirahũgĩ igĩrĩ kana tũtutuura twĩrĩ harĩ mũthĩnjĩri-Ngai hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Nake mũthĩnjĩri-Ngai arute ĩmwe ĩtuĩke igongona rĩa kũhoroherio mehia, nayo ĩyo ĩngĩ ĩtuĩke nĩ iruta rĩa njino nĩguo ahoroherio, nĩ ũndũ nĩehĩtie nĩgũkorwo arĩ hamwe na kĩimba. Mũthenya o ro ũcio no nginya aamũrĩre Jehova mũtwe wake rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","No nginya eyamũrĩre Jehova ihinda rĩu rĩa kwĩyamũra, na no nginya arute gatũrũme ka mwaka ũmwe gatuĩke ka igongona rĩa mahĩtia. Mĩthenya ĩrĩa mĩhĩtũku ndĩgũtarwo, tondũ nĩathaahirio ihinda rĩrĩa eyaamũrĩte. ");
INSERT INTO kik_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Na rĩrĩ, ũyũ nĩguo watho wa Mũnaziri ihinda rĩake rĩa kwĩyamũrĩra Ngai rĩathira. Nĩakarehwo itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Hau nĩho akaarehe maruta make harĩ Jehova, namo nĩ: gatũrũme ka mwaka ũmwe gatarĩ na kaũũgũ gatuĩke ka iruta rĩa njino, na kamwatĩ ka mwaka ũmwe karĩ igongona rĩa kũhoroheria mehia, na ndũrũme ĩmwe ĩtarĩ na kaũũgũ ĩrĩ iruta rĩa ũiguano, ");
INSERT INTO kik_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","hamwe na maruta ma mũtu na maruta ma kũnyuuo, na gĩkabũ kĩa mĩgate ĩtarĩ na ndawa ya kũimbia, na keki cia mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, na tũmĩgate tũhũthũ tũhakĩtwo maguta. ");
INSERT INTO kik_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Mũthĩnjĩri-Ngai nĩakaiga indo icio mbere ya Jehova, na acooke arute igongona rĩa kũhoroheria mehia o na iruta rĩa njino. ");
INSERT INTO kik_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Nĩakarehe gĩkabũ kĩu kĩa mĩgate ĩtarĩ mĩimbie na arute ndũrũme ĩyo ĩrĩ igongona rĩa ũiguano kũrĩ Jehova, hamwe na igongona rĩayo rĩa mũtu na rĩa indo cia kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Ningĩ hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, Mũnaziri no nginya enjwo njuĩrĩ ĩrĩa aamũrĩte. Nĩakoya njuĩrĩ ĩyo na amĩikie mwaki-inĩ ũrĩa ũrĩ rungu rwa igongona rĩu rĩa ũiguano. ");
INSERT INTO kik_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Thuutha wa Mũnaziri ũcio kwenjwo njuĩrĩ yake ya kwĩyamũra, mũthĩnjĩri-Ngai nĩ akoya kĩande gĩtherũkĩtio kĩa ndũrũme ĩyo, na keki na tũmĩgate tũrĩa tũhũthũ kuuma gĩkabũ-inĩ kĩu, cierĩ itarĩ ndawa ya kũimbia. ");
INSERT INTO kik_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Mũthĩnjĩri-Ngai acooke acithũngũthie mbere ya Jehova, ituĩke igongona rĩa gũthũngũthio; nĩ nyamũre, na nĩ cia mũthĩnjĩri-Ngai, hamwe na gĩthũri kĩrĩa gĩthũngũthĩtio, o na kĩero kĩrĩa kĩrutĩtwo. Thuutha ũcio Mũnaziri no anyue ndibei. ");
INSERT INTO kik_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Ũcio nĩguo watho wa Mũnaziri ũrĩa wĩhĩtaga kũrutĩra Jehova indo kũringana na ũrĩa eyaamũrĩte, hamwe na kĩrĩa kĩngĩ gĩothe angĩhota kũruta. No nginya ahingie mwĩhĩtwa ũrĩa ehĩtĩte, kũringana na watho wa Mũnaziri.’ ” ");
INSERT INTO kik_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ĩra Harũni na ariũ ake atĩrĩ, ‘Ũũ nĩguo mũrĩrathimaga andũ a Isiraeli. Meragei atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Jehova arokũrathima, na akũmenyagĩrĩre; ");
INSERT INTO kik_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Jehova arotũma ũthiũ wake ũkwarĩre, na agũkinyagĩrie wega wake; ");
INSERT INTO kik_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Jehova arogũtiirĩra gĩthiithi gĩake, na akũhe thayũ.” ’ ");
INSERT INTO kik_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Nĩ ũndũ ũcio athĩnjĩri-Ngai nĩmarĩgwetaga rĩĩtwa rĩakwa kũrĩ andũ a Isiraeli, na niĩ nĩndĩĩmarathimaga.” ");
INSERT INTO kik_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Rĩrĩa Musa aarĩkirie kũhaanda Hema-ĩrĩa-Nyamũre, nĩamĩitĩrĩirie maguta o na akĩmĩamũrĩra Jehova hamwe na indo ciayo ciothe. Ningĩ agĩitĩrĩria kĩgongona maguta, na agĩkĩamũra hamwe na indo ciakĩo ciothe. ");
INSERT INTO kik_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ningĩ atongoria a Isiraeli, atongoria a nyũmba ciao arĩa maarĩ atongoria a mĩhĩrĩga arĩa maarũgamĩrĩire andũ arĩa maatarĩtwo, makĩrehe maruta. ");
INSERT INTO kik_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Maareheire Jehova iheo ikuuĩtwo nĩ ngaari ithathatũ cia ngʼombe irĩ humbĩre, hamwe na ndegwa ikũmi na igĩrĩ, ndegwa ĩmwe ĩkarutwo nĩ o mũtongoria, na ngaari ĩmwe ĩkarutwo nĩ atongoria eerĩ. Indo icio nĩcio maarehire mbere ya Hema-ĩrĩa-Nyamũre. ");
INSERT INTO kik_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Nake Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ĩtĩkĩra indo icio kuuma kũrĩ o, nĩguo ihũthĩrwo wĩra-inĩ wa Hema-ya-Gũtũnganwo. Ũciheane kũrĩ Alawii o ta ũrĩa wĩra wa mũndũ o mũndũ ũkũbatara.” ");
INSERT INTO kik_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Nĩ ũndũ ũcio Musa akĩoya ngaari icio na ndegwa icio agĩciheana kũrĩ Alawii. ");
INSERT INTO kik_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Aaheire Agerishoni ngaari igĩrĩ na ndegwa inya, o ta ũrĩa wĩra wao wabataraga, ");
INSERT INTO kik_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ningĩ akĩhe Amerari ngaari inya na ndegwa inyanya, o ta ũrĩa wĩra wao wabataraga. Othe maatongoragio nĩ Ithamaru mũrũ wa Harũni, ũrĩa mũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","No Musa ndaigana kũhe Akohathu kĩndũ o nakĩ, tondũ wĩra wao warĩ wa gũkuuaga indo iria nyamũre na ciande ciao, nĩgũkorwo ũcio nĩguo warĩ wĩra ũrĩa meehokeirwo. ");
INSERT INTO kik_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Rĩrĩa kĩgongona gĩaitĩrĩirio maguta, atongoria nĩmarehire maruta mao nĩguo kĩamũrwo, na makĩmaiga mbere ya kĩgongona kĩu. ");
INSERT INTO kik_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nĩ ũndũ Jehova nĩeerĩte Musa atĩrĩ, “O mũthenya, mũtongoria ũmwe arĩrehaga maruta make nĩ ũndũ wa kwamũrwo gwa kĩgongona.” ");
INSERT INTO kik_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Mũndũ ũrĩa warehire maruta make mũthenya wa mbere aarĩ Nahashoni mũrũ wa Aminadabu wa mũhĩrĩga wa Juda. ");
INSERT INTO kik_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩmwe rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe yaiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, Nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Nahashoni mũrũ wa Aminadabu. ");
INSERT INTO kik_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Mũthenya wa keerĩ Nethaneli mũrũ wa Zuaru, mũtongoria wa Aisakaru, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩmwe rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe yaiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Nethaneli mũrũ wa Zuaru. ");
INSERT INTO kik_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Mũthenya wa gatatũ Eliabu mũrũ wa Heloni, mũtongoria wa andũ a Zebuluni, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩmwe rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe yaiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Eliabu mũrũ wa Heloni. ");
INSERT INTO kik_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Mũthenya wa kana, Elizuru mũrũ wa Shedeuru, mũtongoria wa andũ a Rubeni, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩmwe rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya kũminjaminjĩria ya betha ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe yaiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Elizuru mũrũ wa Shedeuru. ");
INSERT INTO kik_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Mũthenya wa gatano, Shelumieli mũrũ wa Zurishadai, mũtongoria wa andũ a Simeoni, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe ĩiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano, na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Shelumieli mũrũ wa Zurishadai. ");
INSERT INTO kik_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Mũthenya wa gatandatũ Eliasafu mũrũ wa Deueli, mũtongoria wa andũ a Gadi, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe iĩyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano, na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Eliasafu mũrũ wa Deueli. ");
INSERT INTO kik_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Mũthenya wa mũgwanja Elishama mũrũ wa Amihudu, mũtongoria wa andũ a Efiraimu, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Indo iria aarutire ciarĩ thaani ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe ĩiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano, na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Elishama mũrũ wa Amihudu. ");
INSERT INTO kik_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Mũthenya wa kanana Gamalieli mũrũ wa Pedazuru, mũtongoria wa andũ a Manase, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe ĩiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano, na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Gamalieli mũrũ wa Pedazuru. ");
INSERT INTO kik_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Mũthenya wa kenda, Abidani mũrũ wa Gideoni, mũtongoria wa andũ a Benjamini, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe ĩiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano, na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Abidani mũrũ wa Gideoni. ");
INSERT INTO kik_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Mũthenya wa ikũmi Ahiezeri mũrũ wa Amishadai, mũtongoria wa andũ a Dani, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe ĩiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano, na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Ahiezeri mũrũ wa Amishadai. ");
INSERT INTO kik_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Mũthenya wa ikũmi na ũmwe, Pagieli mũrũ wa Okirani, mũtongoria wa andũ a Asheri, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe ĩiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Pagieli mũrũ wa Okirani. ");
INSERT INTO kik_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Mũthenya wa ikũmi na ĩĩrĩ Ahira mũrũ wa Enani, mũtongoria wa andũ a Nafitali, nake akĩrehe maruta make. ");
INSERT INTO kik_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Indo iria aarutire ciarĩ thaani ĩmwe ya betha ya ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri ĩmwe ya betha ya kũminjaminjĩria ya ũritũ wa cekeri mĩrongo mũgwanja, cierĩ kũringana na gĩthimo gĩa cekeri ya harĩa haamũre, na o ĩmwe ĩiyũrĩtio mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta, ũrĩ iruta rĩa mũtu; ");
INSERT INTO kik_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","na thaani ĩmwe nene ya thahabu ya ũritũ wa cekeri ikũmi, ĩiyũrĩtio ũbumba; ");
INSERT INTO kik_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","na gategwa kamwe, na ndũrũme ĩmwe, na gatũrũme kamwe ka mwaka ũmwe, nĩ ũndũ wa iruta rĩa njino; ");
INSERT INTO kik_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","na thenge ĩmwe ya igongona rĩa kũhoroherio mehia; ");
INSERT INTO kik_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","na ndegwa igĩrĩ, na ndũrũme ithano, na thenge ithano, na tũtũrũme tũtano twa mwaka ũmwe, irutwo irĩ igongona rĩa ũiguano. Ici nĩcio indo iria ciarutirwo nĩ Ahira mũrũ wa Enani. ");
INSERT INTO kik_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Maya nĩmo maarĩ maruta ma atongoria a andũ a Isiraeli nĩ ũndũ wa kwamũrwo gwa kĩgongona rĩrĩa gĩaitagĩrĩrio maguta: ciarĩ thaani cia betha ikũmi na igĩrĩ na mbakũri cia betha cia kũminjaminjĩria ikũmi na igĩrĩ na thaani nene cia thahabu ikũmi na igĩrĩ. ");
INSERT INTO kik_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Thaani o ĩmwe ya betha yarĩ na ũritũ wa cekeri igana rĩa mĩrongo ĩtatũ, na mbakũri o ĩmwe ya kũminjaminjĩria yarĩ na ũritũ wa cekeri mĩrongo mũgwanja. Thaani cia betha ciothe ciarĩ na ũritũ wa cekeri ngiri igĩrĩ na magana mana, kũringana na gĩthimo gĩa cekeri ya harĩa haamũre. ");
INSERT INTO kik_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Thaani iria nene ikũmi na igĩrĩ cia thahabu ciyũrĩtio ũbumba ciarĩ na ũritũ wa cekeri ikũmi o ĩmwe, kũringana na gĩthimo gĩa cekeri ya harĩa haamũre. Thaani icio nene cia thahabu ciothe ciarĩ na ũritũ wa cekeri igana rĩa mĩrongo ĩĩrĩ. ");
INSERT INTO kik_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Mũigana wothe wa nyamũ cia kũrutwo igongona rĩa njino warĩ tũtegwa ikũmi na twĩrĩ, na ndũrũme ikũmi na igĩrĩ na tũtũrũme ikũmi na twĩrĩ twa mwaka ũmwe, hamwe na maruta ma cio ma mũtu. Thenge ikũmi na igĩrĩ ciarutirwo irĩ igongona rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Mũigana wa nyamũ ciothe cia igongona rĩa ũiguano ciarĩ ndegwa mĩrongo ĩĩrĩ na inya, na ndũrũme mĩrongo ĩtandatũ, na thenge mĩrongo ĩtandatũ, na tũtũrũme mĩrongo ĩtandatũ twa mwaka ũmwe. Macio nĩmo maarĩ maruta ma kwamũrwo gwa kĩgongona thuutha wa kĩarĩkia gũitĩrĩrio maguta. ");
INSERT INTO kik_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Rĩrĩa Musa atoonyire Hema-ya-Gũtũnganwo kwaria na Jehova-rĩ, nĩaiguire mũgambo ũkĩmwarĩria kuuma gatagatĩ ka makerubi marĩa meerĩ maarĩ igũrũ rĩa gĩtĩ gĩa tha, igũrũ rĩa ithandũkũ rĩa Ũira. Nake Jehova akĩmwarĩria. ");
INSERT INTO kik_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Arĩria Harũni, ũmwĩre atĩrĩ, ‘Hĩndĩ ĩrĩa ũrĩbangaga matawa marĩa mũgwanja, mabangage nĩguo ũtheri wamo waragĩre mwena wa na mbere wa mũtĩ ũcio wa kũigĩrĩrwo matawa.’ ” ");
INSERT INTO kik_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harũni agĩĩka o ta ũguo; akĩbanga matawa macio amaroretie mwena ũrĩa ũtheri wamo watheragĩra hau mbere ya mũtĩ ũcio maaigagĩrĩrwo, o ta ũrĩa Jehova aathĩte Musa gwĩkwo. ");
INSERT INTO kik_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Mũtĩ ũcio wa kũigĩrĩrwo matawa wathondeketwo ũũ: wathondeketwo na thahabu ya gũturwo, kuuma gĩtina-inĩ kĩaguo o nginya kũrĩa mahũa maguo maarĩ. Mũhianĩre wa mũtĩ ũcio wa kũigĩrĩrwo matawa wathondeketwo o ta ũrĩa mũhianĩre waguo wonetio Musa nĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Nake Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Oya Alawii ũmeherie kuuma kũrĩ andũ arĩa angĩ a Isiraeli, ũmatherie mathirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ũkĩmatheria ũgeekaga ũũ: Maminjaminjĩrie maaĩ ma kũmatheria thaahu; macooke menje njuĩrĩ cia mĩĩrĩ yao kũndũ guothe na mathambie nguo ciao, nĩguo metherie. ");
INSERT INTO kik_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ningĩ ũreke moe gategwa hamwe na iruta rĩako rĩa mũtu ũrĩa mũhinyu mũno ũtukanĩtio na maguta; nawe ũcooke woe gategwa kangĩ ga keerĩ ga kũrutwo igongona rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ũrehe Alawii acio mbere ya Hema-ya-Gũtũnganwo, na ũcooke wĩte kĩrĩndĩ gĩothe kĩa andũ a Isiraeli hamwe. ");
INSERT INTO kik_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ũrehe Alawii acio mbere ya Jehova, nao andũ a Isiraeli mamaigĩrĩre moko mĩtwe. ");
INSERT INTO kik_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Nake Harũni arutĩre Jehova Alawii acio hau mbere yake taarĩ igongona rĩa gũthũngũthio rĩrutĩtwo nĩ andũ a Isiraeli, nĩguo maikarage mehaarĩirie kũruta wĩra wa Jehova. ");
INSERT INTO kik_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Thuutha ũcio Alawii maigĩrĩre moko mao mĩtwe ya ndegwa icio, ũcirutĩre Jehova, ĩmwe ĩtuĩke ya igongona rĩa kũhoroherio mehia na ĩyo ĩngĩ ĩtuĩke iruta rĩa njino, nĩgeetha Alawii mahoroherio. ");
INSERT INTO kik_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Reke Alawii marũgame mbere ya Harũni na ariũ ake, na ũcooke ũmarutĩre Jehova taarĩ igongona rĩa gũthũngũthio. ");
INSERT INTO kik_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ũguo nĩguo ũkaamũra Alawii, ũmeherie kuuma kũrĩ andũ arĩa angĩ a Isiraeli, nao Alawii acio matuĩke akwa. ");
INSERT INTO kik_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Warĩkia gũtheria Alawii acio na kũmaruta matuĩke ta igongona rĩa gũthũngũthio-rĩ, nĩmarutage wĩra wao Hema-inĩ-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Acio nĩo andũ a Isiraeli arĩa mekũheanwo kũrĩ niĩ biũ. Ndĩmeyoeire marĩ akwa ithenya rĩa marigithathi ma ciana cia tũhĩĩ kuuma kũrĩ mũtumia o wothe Mũisiraeli. ");
INSERT INTO kik_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Irigithathi o rĩothe rĩa njamba gũkũ Isiraeli, kana nĩ rĩa mũndũ kana nĩ rĩa nyamũ-rĩ, nĩ rĩakwa. Rĩrĩa ndooragire marigithathi mothe kũu bũrũri wa Misiri-rĩ, hĩndĩ ĩyo nĩguo ndaamaamũrire matuĩke akwa mwene. ");
INSERT INTO kik_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Na niĩ nĩ njoete Alawii ithenya rĩa marigithathi mothe ma ciana cia tũhĩĩ thĩinĩ wa Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Thĩinĩ wa andũ a Isiraeli othe-rĩ, nĩheanĩte Alawii matuĩke iheo kũrĩ Harũni na ariũ ake, na marutage wĩra Hema-inĩ-ĩno-ya-Gũtũnganwo handũ ha andũ a Isiraeli, na mamahorohagĩrie nĩgeetha andũ a Isiraeli matikae kũniinwo na mũthiro hĩndĩ ĩrĩa mangĩkuhĩrĩria handũ-harĩa-haamũre.” ");
INSERT INTO kik_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Musa, na Harũni marĩ na kĩrĩndĩ kĩu gĩothe kĩa andũ a Isiraeli magĩĩka Alawii o ta ũguo Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Alawii acio magĩĩtheria na magĩthambia nguo ciao. Harũni nake agĩcooka akĩmaruta ta igongona rĩa gũthũngũthio mbere ya Jehova, na akĩmahoroheria nĩguo amatherie. ");
INSERT INTO kik_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Thuutha ũcio, Alawii magĩtoonya Hema-inĩ-ĩyo-ya-Gũtũnganwo marutage wĩra wao marũgamĩrĩirwo nĩ Harũni na ariũ ake. Magĩĩka Alawii acio o ta ũrĩa Jehova aathĩte Musa gwĩkwo. ");
INSERT INTO kik_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Ũndũ ũyũ nĩguo ũkoniĩ Alawii: Atĩrĩ, arũme othe arĩa mahingĩtie mĩaka mĩrongo ĩĩrĩ na ĩtano na makĩria nĩo marĩũkaga kũruta wĩra Hema-inĩ-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","no mahingia mĩaka mĩrongo ĩtano-rĩ, no nginya mahurũke kuuma wĩra ũcio wao wa gũtungata, matigacooke kũruta wĩra. ");
INSERT INTO kik_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","No rĩrĩ, no mateithagĩrĩrie ariũ a ithe wao rĩrĩa mekũruta wĩra Hema-inĩ-ya-Gũtũnganwo, no-o ene matikarute wĩra ũcio. Ũguo nĩguo ũrĩgayagĩra Alawii wĩra ũrĩa marĩrutaga.” ");
INSERT INTO kik_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Nake Jehova akĩarĩria Musa kũu Werũ-inĩ wa Sinai mweri-inĩ wa mbere wa mwaka wa keerĩ thuutha wa andũ a Isiraeli kuuma bũrũri wa Misiri, akĩmwĩra atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Ĩra andũ a Isiraeli makũngũyagĩre Gĩathĩ-kĩa-Bathaka ihinda rĩrĩa rĩtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Kũngũyagĩrai gĩathĩ kĩu ihinda rĩrĩa rĩtuĩtwo, hwaĩ-inĩ wa mũthenya wa ikũmi na ĩna wa mweri ũyũ, kũringana na mawatho makĩo mothe na mũtabarĩre wakĩo.” ");
INSERT INTO kik_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Nĩ ũndũ ũcio Musa akĩĩra andũ a Isiraeli makũngũĩre Gĩathĩ-kĩa-Bathaka. ");
INSERT INTO kik_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Nao magĩĩka o ro ũguo kũu Werũ-inĩ wa Sinai hwaĩ-inĩ wa mũthenya wa ikũmi na ĩna wa mweri wa mbere. Andũ a Isiraeli magĩĩka maũndũ mothe o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","No amwe ao matingĩakũngũĩire Gĩathĩ-kĩa-Bathaka mũthenya ũcio nĩ ũndũ nĩmagwatĩtwo nĩ thaahu nĩ ũndũ wa kũhutania na kĩimba kĩa mũndũ. Nĩ ũndũ ũcio magĩũka kũrĩ Musa na Harũni mũthenya o ro ũcio ");
INSERT INTO kik_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","makĩĩra Musa atĩrĩ, “Nĩ tũnyiitĩtwo nĩ thaahu nĩ ũndũ wa kũhutania na kĩimba kĩa mũndũ, no nĩ kĩĩ gĩgũtũma tũgirio kũneana indo cia kũrutĩra Jehova tũrĩ hamwe na andũ a Isiraeli arĩa angĩ ihinda rĩrĩa rĩtuĩtwo?” ");
INSERT INTO kik_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Musa akĩmacookeria atĩrĩ, “Etererai nyambe nduĩrie ũhoro wa ũrĩa Jehova egwathana ũhoro wanyu.” ");
INSERT INTO kik_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Jehova agĩcooka akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Ĩra andũ a Isiraeli atĩrĩ: ‘Rĩrĩa mũndũ wanyu o na ũrĩkũ kana njiaro cianyu marĩ na thaahu nĩ ũndũ wa kũhutania na kĩimba kĩa mũndũ, kana akorwo arĩ rũgendo-inĩ-rĩ, mũndũ ũcio o nake no akũngũĩre Gĩathĩ-kĩa-Bathaka ya Jehova. ");
INSERT INTO kik_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Marĩkũngũyagĩra gĩathĩ kĩu hwaĩ-inĩ wa mũthenya wa ikũmi na ĩna wa mweri wa keerĩ. Marĩrĩĩaga gatũrũme na mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia na nyeni ndũrũ. ");
INSERT INTO kik_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Matikanatigie gacunjĩ o na kamwe karaare nginya rũciinĩ kana moine ihĩndĩ rĩako o na rĩmwe. Rĩrĩa megũkũngũĩra Gĩathĩ-kĩa-Bathaka ĩyo no nginya marũmagĩrĩre mũtabarĩre wakĩo wothe. ");
INSERT INTO kik_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","No mũndũ angĩkorwo ndarĩ na thaahu, na ndathiĩte rũgendo, na aage gũkũngũĩra Gĩathĩ-kĩa-Bathaka, mũndũ ũcio nĩakaingatwo athengio kuuma kũrĩ andũ ao, nĩ ũndũ ndaareheire Jehova indo iria arutagĩrwo ihinda rĩrĩa rĩtuĩtwo. Mũndũ ũcio nĩagacookererwo nĩ mehia make mwene. ");
INSERT INTO kik_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Mũgeni ũikaranĩtie na inyuĩ na ende gũkũngũĩra Gĩathĩ-kĩa-Bathaka ya Jehova-rĩ, no nginya eke ũguo kũringana na watho na mũtabarĩre wakĩo. No nginya mũgĩage na mĩtabarĩre ya mũthemba ũmwe kũrĩ mũgeni na kũrĩ mũndũ ũrĩa ũciarĩirwo bũrũri wanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Mũthenya ũrĩa Hema-ĩrĩa-Nyamũre, o Hema-ĩyo-ya-Ũira yaambirwo-rĩ, itu rĩkĩmĩhumbĩra. Kuuma hwaĩ-inĩ nginya rũciinĩ itu rĩu rĩarĩ igũrũ rĩa Hema-ĩyo-Nyamũre na itu rĩu rĩkoonagwo rĩhaana ta mwaki. ");
INSERT INTO kik_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ũguo nĩguo gwathiire na mbere gũikara; itu rĩkamĩhumbĩra ũtukũ na rĩkoonagwo rĩhaana ta mwaki. ");
INSERT INTO kik_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Hĩndĩ ĩrĩa yothe itu rĩu rĩeheraga kuuma harĩ hema ĩyo, andũ a Isiraeli makoimagara magathiĩ; na rĩrĩ, itu rĩu rĩarũgamĩra handũ, andũ a Isiraeli makaamba hema ciao ho. ");
INSERT INTO kik_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Jehova aathana-rĩ, andũ a Isiraeli makoimagara magathiĩ, na aathana rĩngĩ makaamba hema ciao. Hĩndĩ ĩrĩa yothe itu rĩu rĩaikara igũrũ rĩa Hema-ĩyo-Nyamũre, maikaraga o hau kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Hĩndĩ ĩrĩa itu rĩaikara igũrũ rĩa Hema-ĩyo-Nyamũre kahinda karaaya-rĩ, andũ a Isiraeli magaathĩkĩra Jehova na makaaga kuumagara. ");
INSERT INTO kik_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mahinda mamwe itu rĩu rĩaikaraga igũrũ rĩa Hema-ĩyo-Nyamũre o matukũ manini; no Jehova aathana makaamba hema, na ningĩ aathana, makoimagara magathiĩ. ");
INSERT INTO kik_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Mahinda mamwe itu rĩu rĩaikaraga o kuuma hwaĩ-inĩ nginya rũciinĩ, na itu rĩehera rũciinĩ-rĩ, makoimagara magathiĩ. Kana nĩ mũthenya kana nĩ ũtukũ, hĩndĩ o yothe itu rĩu rĩehera nao makoimagara magathiĩ. ");
INSERT INTO kik_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Itu rĩu rĩngĩaikarire igũrũ rĩa hema ĩyo mĩthenya ĩĩrĩ, kana mweri, kana mwaka, andũ a Isiraeli maikaraga kũu kambĩ, na matingĩoimagarire mathiĩ, no itu rĩu rĩehera makoimagara magathiĩ. ");
INSERT INTO kik_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Jehova aathana makaamba hema, na ningĩ Jehova aathana makoimagara magathiĩ. Maathĩkagĩra watho wa Jehova kũringana na ũrĩa aathaga Musa. ");
INSERT INTO kik_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Thondeka tũrumbeta twĩrĩ, ũtũthondeke na betha ndure, tũhũthagĩrwo gwĩtaga kĩrĩndĩ hamwe, o na twa gwĩta andũ moime kambĩ moimagare mathiĩ. ");
INSERT INTO kik_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Hĩndĩ ĩrĩa tũrumbeta tweerĩ twahuhwo hamwe, kĩrĩndĩ gĩothe gĩkongana harĩwe hau itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Angĩkorwo no karumbeta kamwe kahuhwo-rĩ, atongoria, nĩo anene a mbarĩ cia Isiraeli, nĩo marĩũnganaga harĩwe. ");
INSERT INTO kik_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Rĩrĩa karumbeta kahuhwo na mũgambo mũnene, mĩhĩrĩga ĩrĩa ĩikarĩte mwena wa irathĩro ĩkoimagara. ");
INSERT INTO kik_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Karumbeta ga keerĩ kahuhwo na mũgambo mũnene, andũ a kambĩ cia mwena wa gũthini makoimagara. Mũgambo ũcio mũnene nĩguo kĩmenyithia gĩa kuumagara. ");
INSERT INTO kik_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Nĩgeetha kĩrĩndĩ kĩũngane-rĩ, huhagai tũrumbeta, no ti na mĩhuhĩre ta ĩyo ĩngĩ. ");
INSERT INTO kik_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Ariũ a Harũni, acio athĩnjĩri-Ngai, nĩo marĩhuhaga tũrumbeta tũu. Ũndũ ũcio ũtuĩke watho wa gũtũũrio nĩ inyuĩ na njiarwa iria igooka. ");
INSERT INTO kik_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Rĩrĩa mũgũthiĩ mbaara ĩrĩ bũrũri wanyu kĩũmbe mũkarũe na thũ iria imũhinyagĩrĩria-rĩ, huhagai tũrumbeta na mũgambo mũnene. Hĩndĩ ĩyo Jehova Ngai wanyu nĩakamũririkana na amũhonokie kuuma kũrĩ thũ cianyu. ");
INSERT INTO kik_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ningĩ mahinda manyu ma gũkena, nĩmo ma ciathĩ cianyu iria njathane, na ciathĩ cia Karũgamo ka Mweri, nĩ mũrĩhuhaga tũrumbeta nĩ ũndũ wa maruta ma njino na maruta ma ũiguano, na nĩmo magaatuĩka kĩririkano kĩanyu mbere ya Ngai wanyu. Niĩ nĩ niĩ Jehova Ngai Wanyu.” ");
INSERT INTO kik_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Mũthenya wa mĩrongo ĩĩrĩ wa mweri wa keerĩ mwaka-inĩ wa ĩĩrĩ, itu nĩrĩeherire kuuma hema-inĩ ĩrĩa nyamũre ya Ũira. ");
INSERT INTO kik_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Nao andũ a Isiraeli makiumagara kuuma Werũ wa Sinai magĩthiĩ kuuma handũ hamwe nginya harĩa hangĩ, o nginya rĩrĩa itu rĩu rĩarũgamire Werũ-inĩ wa Parani. ");
INSERT INTO kik_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Nao makiumagara, arĩ riita rĩa mbere, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ikundi cia kambĩ ya Juda nĩcio cioimagarire mbere, irũmĩrĩire bendera yao. Nake Nahashoni mũrũ wa Aminadabu nĩwe warĩ mũtongoria wao. ");
INSERT INTO kik_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethaneli mũrũ wa Zuaru nĩwe warĩ mũtongoria wa gĩkundi kĩa mũhĩrĩga wa Isakaru, ");
INSERT INTO kik_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","nake Eliabu mũrũ wa Heloni nĩwe warĩ mũtongoria wa gĩkundi kĩa mũhĩrĩga wa Zebuluni. ");
INSERT INTO kik_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ningĩ Hema-ĩrĩa-Nyamũre ĩkĩambũrwo, nao Agerishoni na Amerari, arĩa maamĩkuuaga, makiumagara. ");
INSERT INTO kik_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Nacio ikundi cia kambĩ ya Rubeni ikĩrũmĩrĩra ikundi cia Juda, irũmĩrĩire bendera yao. Elizuru mũrũ wa Shedeuru nĩwe warĩ mũtongoria wao. ");
INSERT INTO kik_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shelumieli mũrũ wa Zurishadai nĩwe warĩ mũtongoria wa gĩkundi kĩa mũhĩrĩga wa Simeoni, ");
INSERT INTO kik_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","nake Eliasafu mũrũ wa Deueli nĩwe warĩ mũtongoria wa gĩkundi kĩa mũhĩrĩga wa Gadi. ");
INSERT INTO kik_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Nao Akohathu makiumagara makuuĩte indo iria nyamũre. Hema-ĩrĩa-Nyamũre yarĩ ĩkorwo yaambĩtwo matanakinya. ");
INSERT INTO kik_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Nacio ikundi cia kambĩ ya Efiraimu ikĩrũmĩrĩra ikundi cia Rubeni, irũmĩrĩire bendera yao. Elishama mũrũ wa Amihudu nĩwe warĩ mũtongoria wao. ");
INSERT INTO kik_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli mũrũ wa Pedazuru nĩwe warĩ mũtongoria wa gĩkundi kĩa mũhĩrĩga wa Manase, ");
INSERT INTO kik_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","nake Abidani mũrũ wa Gideoni nĩwe warĩ mũtongoria wa gĩkundi kĩa mũhĩrĩga wa Benjamini. ");
INSERT INTO kik_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Kũrigĩrĩria-rĩ, ikundi cia kambĩ ya Dani ikiumagara irĩ thuutha wa icio ingĩ ciothe, ikiumagara ĩrũmĩrĩire bendera yao. Ahiezeri mũrũ wa Amishadai nĩwe warĩ mũtongoria wao. ");
INSERT INTO kik_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli mũrũ wa Okirani nĩwe watongoragia gĩkundi kĩa mũhĩrĩga wa Asheri, ");
INSERT INTO kik_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","nake Ahira mũrũ wa Enani nĩwe watongoragia gĩkundi kĩa mũhĩrĩga wa Nafitali. ");
INSERT INTO kik_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ũguo nĩguo ikundi cia andũ a Isiraeli ciarũmanĩrĩire ikiumagara. ");
INSERT INTO kik_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Na rĩrĩ, Musa akĩĩra Hobabu mũrũ wa Reueli ũrĩa Mũmidiani ũrĩa warĩ mũthoni-we atĩrĩ, “Nĩtũroimagara tũthiĩ kũrĩa Jehova aatwĩrire ũhoro wakuo atĩrĩ, ‘Nĩngamũhe kũndũ kũu.’ Ũka tũthiĩ nawe, na nĩtũgũgwĩka maũndũ mega, nĩ ũndũ Jehova nĩerĩire Isiraeli maũndũ mega.” ");
INSERT INTO kik_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobabu akĩmũcookeria atĩrĩ, “Aca, ndigũũka; no ngũcooka bũrũri witũ na kũrĩ andũ aitũ.” ");
INSERT INTO kik_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","No Musa akĩmwĩra atĩrĩ, “Ndagũthaitha ndũgatũtige. Wee nĩũũĩ kũndũ kũrĩa tũngĩamba hema ciitũ gũkũ werũ-inĩ, na no ũtuĩke maitho maitũ. ");
INSERT INTO kik_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ũngĩtwarana na ithuĩ-rĩ, nĩtũrĩkũgayagĩra kĩrĩa gĩothe kĩega Jehova arĩtũheaga.” ");
INSERT INTO kik_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Nĩ ũndũ ũcio makiumagara moimĩte hau kĩrĩma-inĩ kĩa Jehova, magĩthiĩ rũgendo rwa mĩthenya ĩtatũ. Narĩo ithandũkũ rĩa kĩrĩkanĩro kĩa Jehova rĩgĩthiĩ rĩmatongoretie mĩthenya ĩyo ĩtatũ, nĩguo rĩkamacarĩrie handũ ha kũhurũka. ");
INSERT INTO kik_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Narĩo itu rĩa Jehova rĩakoragwo igũrũ rĩao o mũthenya makiumagara kuuma kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Hĩndĩ ĩrĩa yothe ithandũkũ rĩoimagario, Musa akoiga atĩrĩ, “Jehova, arahũka! Thũ ciaku irohurunjũka; thũ ciaku irokũũrĩra.” ");
INSERT INTO kik_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Hĩndĩ ĩrĩa rĩaigwo thĩ, akoiga atĩrĩ, “Jehova cookerera ngiri ici cia Isiraeli itangĩtarĩka.” ");
INSERT INTO kik_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Na rĩrĩ, andũ a Isiraeli magĩteta nĩ ũndũ wa moritũ mao, nakuo gũteta kwao gũkĩiguuo nĩ Jehova, na rĩrĩa aamaiguire, agĩakanwo nĩ marakara, naguo mwaki ũkiuma kũrĩ Jehova, ũgĩakana gatagatĩ kao, na ũgĩcina ndeere imwe cia kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Rĩrĩa andũ acio maakaĩire Musa, Musa akĩhooya Jehova, naguo mwaki ũcio ũkĩhora. ");
INSERT INTO kik_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nĩ ũndũ ũcio handũ hau hagĩĩtwo Tabera, tondũ mwaki ũcio woimĩte kũrĩ Jehova nĩwakanĩte gatagatĩ kao. ");
INSERT INTO kik_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Kĩrĩndĩ kĩrĩa kĩarũmanĩrĩire nao makiuma bũrũri wa Misiri gĩkĩambĩrĩria kwĩrirĩria irio cia mĩthemba ĩngĩ, na o rĩngĩ andũ a Isiraeli makĩambĩrĩria kũrĩra, makiuga atĩrĩ, “Naarĩ korwo tũrĩ na nyama cia kũrĩa! ");
INSERT INTO kik_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nĩtũkũririkana thamaki iria twarĩĩaga kũu bũrũri wa Misiri tũtekũgũra, o na marenge ma mĩthemba mĩthemba, na itũngũrũ cia mahuti, na itũngũrũ iria ndungu, o na itũngũrũ thumu. ");
INSERT INTO kik_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","No rĩu, tũtirĩ na wendo wa kũrĩa; na tũtirĩ kĩndũ o nakĩ tuonaga, tiga o mana maya moiki!” ");
INSERT INTO kik_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana macio maahaanaga ta mbegũ cia mũtĩ ũrĩa wĩtagwo korianda, na mũhianĩre wamo watariĩ ta bedola. ");
INSERT INTO kik_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Andũ maathiiaga makamongania, magacooka makamathĩa na gĩthĩi kĩa moko, kana makamahũrĩra ndĩrĩ-inĩ na mũũthĩ. Maamarugaga na nyũngũ kana magathondeka tũmĩgate. Na maacamaga ta kĩndũ gĩthondeketwo na maguta ma mũtamaiyũ. ");
INSERT INTO kik_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Rĩrĩa kwagĩa ime ũtukũ kũu kambĩ-inĩ, mana macio makagũanĩra narĩo. ");
INSERT INTO kik_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa nĩaiguire andũ a nyũmba ciothe makĩrĩra, o mũndũ arĩ mũromo-inĩ wa hema yake. Nake Jehova nĩarakarire mũno makĩria, na Musa agĩthĩĩnĩka. ");
INSERT INTO kik_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Akĩũria Jehova atĩrĩ, “Nĩ kĩĩ gĩtũmĩte ũrehere ndungata yaku thĩĩna ũyũ? Nĩ atĩa njĩkĩte ũkaaga gũgũkenia nĩguo ũnjigĩrĩre mũrigo wa andũ aya othe? ");
INSERT INTO kik_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kaĩ arĩ niĩ ithe wao? Kaĩ arĩ niĩ ndaamaciarire? Nĩ kĩĩ kĩratũma ũnjĩĩre ndĩmakuue na moko makwa, ta ũrĩa mũreri wa mwana akuuaga kaana ka rũkenge, ndĩmatware bũrũri ũrĩa werĩire maithe mao ma tene na mwĩhĩtwa? ");
INSERT INTO kik_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ingĩruta nyama cia kũhe andũ aya othe kũ? Marandĩrĩra makiugaga atĩrĩ, ‘Tũhe nyama tũrĩe!’ ");
INSERT INTO kik_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ndingĩhota gũkuua andũ aya othe ndĩ nyiki; mũrigo ũyũ nĩ mũritũ mũno kũrĩ niĩ. ");
INSERT INTO kik_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Angĩkorwo ũguo nĩguo ũkũnjĩka-rĩ, njũraga o ro rĩu, angĩkorwo nĩnjĩtĩkĩrĩkĩte nĩwe, na ndũkareke nyone mwanangĩko wakwa mwene.” ");
INSERT INTO kik_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Nake Jehova akĩĩra Musa atĩrĩ: “Ndehere athuuri mĩrongo mũgwanja a Isiraeli arĩa wee ũũĩ atĩ nĩ atongoria na anene thĩinĩ wa andũ aya. Ũmarehe Hema-inĩ-ya-Gũtũnganwo, nĩguo marũgame hau hamwe nawe. ");
INSERT INTO kik_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Niĩ na niĩ nĩngũikũrũka ngwarĩrie ho, njoe Roho ũrĩa ũrĩ naguo na ndĩmekĩre Roho ũcio. Nao nĩmarĩgũteithagia gũkuua mũrigo wa andũ aya nĩgeetha ndũkaũkuuage ũrĩ wiki. ");
INSERT INTO kik_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Ningĩ wĩre andũ atĩrĩ, ‘Mwĩtheriei, mwĩhaarĩrie nĩ ũndũ wa rũciũ, rĩrĩa mũkaarĩa nyama. Jehova nĩaramũiguire rĩrĩa mũrarĩraga, mũkiugaga atĩrĩ, “Naarĩ korwo tũrĩ na nyama cia kũrĩa! Maũndũ maitũ maarĩ mega rĩrĩa twarĩ bũrũri wa Misiri!” Rĩu-rĩ, Jehova nĩekũmũhe nyama, na nĩmũgũcirĩa. ");
INSERT INTO kik_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Na rĩrĩ, mũtigũcirĩa o mũthenya ũmwe, kana mĩthenya ĩĩrĩ, kana ĩtano, kana ikũmi, kana mĩthenya mĩrongo ĩĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","no mũgũcirĩa mweri mũgima, o nginya ciume na maniũrũ manyu, na inyuĩ mũcinyire, nĩ ũndũ nĩmũregete Jehova ũrĩa ũrĩ hamwe na inyuĩ, na mũkarĩra mũrĩ mbere yake, mũkiugaga atĩrĩ, “Nĩ kĩĩ gĩatũmire tuume bũrũri wa Misiri?” ’ ” ");
INSERT INTO kik_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","No Musa akĩĩra Jehova atĩrĩ, “Andũ arĩa ndĩ nao haha nĩ ngiri magana matandatũ arĩa maretwara na magũrũ, nawe woiga atĩ, ‘Nĩngũmahe nyama cia kũrĩa mweri mũgima!’ ");
INSERT INTO kik_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Andũ aya o na mangĩthĩnjĩrwo ndũũru cia mbũri na cia ngʼombe-rĩ, no imaigane? O na mangĩtegerwo thamaki ciothe cia iria-inĩ-rĩ, no imaigane?” ");
INSERT INTO kik_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Jehova agĩcookeria Musa atĩrĩ, “Anga hinya wa guoko kwa Jehova nĩũnyiihĩte? Rĩu wee, nĩũkuona kana ũrĩa njugĩte nĩũkahingio kana ndũkahingio.” ");
INSERT INTO kik_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Nĩ ũndũ ũcio Musa akiuma nja, akĩĩra andũ acio ũrĩa Jehova oigĩte. Nake agĩcookanĩrĩria athuuri amwe ao mĩrongo mũgwanja, akĩmarũgamia marigiicĩirie Hema ĩyo. ");
INSERT INTO kik_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Nake Jehova agĩikũrũka na itu akĩaria na Musa, akĩoya Roho ũrĩa warĩ thĩinĩ wa Musa, na agĩĩkĩra Roho ũcio thĩinĩ wa athuuri acio mĩrongo mũgwanja. Rĩrĩa Roho okire igũrũ rĩao-rĩ, makĩratha mohoro, no matiacookire gwĩka ũguo hĩndĩ ĩngĩ. ");
INSERT INTO kik_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","No rĩrĩ, andũ eerĩ, nĩo Elidadi na Medadi, nĩmatigĩtwo kambĩ. Nao nĩmandĩkĩtwo hamwe na athuuri acio angĩ no matiathiĩte Hema-inĩ ĩyo. No rĩrĩ, Roho nĩ okire igũrũ rĩao, nao makĩratha mohoro marĩ kũu kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Mwanake ũmwe agĩtengʼera akĩĩra Musa atĩrĩ, “Elidadi na Medadi nĩmararatha mohoro kũu kambĩ.” ");
INSERT INTO kik_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Joshua mũrũ wa Nuni, ũrĩa wateithagia Musa kuuma arĩ mũnini, akĩarĩria Musa, akĩmwĩra atĩrĩ, “Musa, mwathi wakwa, makaanie!” ");
INSERT INTO kik_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","No Musa akĩmũcookeria atĩrĩ, “Kaĩ ũkũigua ũiru nĩ ũndũ wakwa? Niĩ ingĩenda andũ othe a Jehova makorwo marĩ anabii, na atĩ Jehova amekĩre Roho wake!” ");
INSERT INTO kik_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Thuutha ũcio Musa na athuuri acio a Isiraeli magĩcooka kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Na rĩrĩ, rũhuho rũkiuma harĩ Jehova, rũkĩrehe tũmakia-arũme kuuma iria-inĩ. Rũgĩtũgũithia tũthiũrũrũkĩirie mĩena yothe ya kambĩ buti ithatũ kuuma thĩ, handũ ha itĩĩna rĩa rũgendo rwa mũthenya mũgima mbarĩ ciothe. ");
INSERT INTO kik_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mũthenya ũcio wothe na ũtukũ, na mũthenya ũcio ũngĩ wothe, andũ acio makiumagara makĩũngania tũmakia-arũme. Gũtirĩ mũndũ wonganirie thuutha wa homeri ikũmi. Ningĩ magĩtwanĩka gũthiũrũrũkĩria kambĩ yothe. ");
INSERT INTO kik_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","No rĩrĩ, rĩrĩa nyama icio ciarĩ tũnua-inĩ twao, o na itarĩ ndanuke-rĩ, marakara ma Jehova magĩakanĩra andũ acio, akĩmahũũra na mũthiro mũnene. ");
INSERT INTO kik_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Tondũ ũcio handũ hau hagĩĩtwo Kibirothu-Hataava, nĩ ũndũ hau nĩho maathikire andũ arĩa maaiguĩte thuti ya irio ingĩ. ");
INSERT INTO kik_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kuuma Kibirothu-Hataava, andũ acio nĩmathiire rũgendo, magĩkinya Hazerothu, magĩikara kuo. ");
INSERT INTO kik_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Nao Miriamu na Harũni magĩtetia Musa, nĩ ũndũ wa mũtumia wake Mũkushi, nĩgũkorwo Musa nĩ ahikĩtie Mũkushi. ");
INSERT INTO kik_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ningĩ nao mooragia atĩrĩ, “Anga Jehova angĩaria o na Musa wiki? Githĩ o na ithuĩ to atwarĩrie?” Nake Jehova akĩigua ndeto icio. ");
INSERT INTO kik_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Na rĩrĩ, Musa aarĩ mũndũ mwĩnyiihia mũno, mwĩnyiihia gũkĩra andũ arĩa angĩ othe gũkũ thĩ). ");
INSERT INTO kik_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","O rĩmwe Jehova akĩĩra Musa na Harũni na Miriamu atĩrĩ, “Inyuĩ atatũ umai mũũke Hema-inĩ ĩyo-ya-Gũtũnganwo.” Nĩ ũndũ ũcio othe atatũ makiuma magĩthiĩ ho. ");
INSERT INTO kik_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ningĩ Jehova agĩikũrũka arĩ thĩinĩ wa gĩtugĩ gĩa itu, akĩrũgama itoonyero-inĩ rĩa Hema ĩyo, na agĩĩta Harũni na Miriamu. Na eerĩ magĩthiathia harĩ we, ");
INSERT INTO kik_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","nake akĩmeera atĩrĩ, “Thikĩrĩriai ciugo ciakwa: “Rĩrĩa mũnabii wa Jehova arĩ gatagatĩ-inĩ kanyu-rĩ, niĩ nĩndĩĩmwĩguũragĩria na cioneki, na ngamwarĩria na irooto. ");
INSERT INTO kik_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","No ha ũhoro wa Musa ndungata yakwa ndiĩkaga ũguo; we nĩ mwĩhokeku thĩinĩ wa nyũmba yakwa yothe. ");
INSERT INTO kik_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Musa-rĩ, twaranagĩria nake ũthiũ kwa ũthiũ, tũkaaranĩria ũhoro mũtaũku, na ndimwaragĩria na thimo; na nĩwe wonaga ũrĩa Jehova atariĩ. Nĩ kĩĩ kĩgiririe mwĩtigĩre gũtetia Musa ndungata yakwa?” ");
INSERT INTO kik_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Nake Jehova agĩcinwo nĩ marakara nĩ ũndũ wao, agĩthiĩ akĩmatiga. ");
INSERT INTO kik_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Rĩrĩa itu rĩu rĩeherire igũrũ rĩa Hema ĩyo, Miriamu agĩkorwo aarũgamĩte o ro hau, arĩ na mangũ, akerũha o ta ira. Nake Harũni ehũgũra akĩona atĩ Miriamu aarĩ na mangũ; ");
INSERT INTO kik_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","nake akĩĩra Musa atĩrĩ, “Ndagũthaitha, mwathi wakwa, ndũgatũrũithĩrie wĩhia ũcio twĩkĩte na ũrimũ. ");
INSERT INTO kik_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ndũkareke ahaane ta kĩhuno kiumĩte nda ya nyina mwĩrĩ wakĩo ũbuthĩte mwena ũmwe.” ");
INSERT INTO kik_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Nĩ ũndũ ũcio Musa agĩkaĩra Jehova, akiuga atĩrĩ, “Wee Ngai, ndagũthaitha, mũhonie!” ");
INSERT INTO kik_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Nake Jehova agĩcookeria Musa, akĩmwĩra atĩrĩ, “Korwo ithe nĩamũtuĩrĩire mata ũthiũ-rĩ, githĩ ndangĩaikarire na thoni matukũ mũgwanja? Mũhingĩrĩriei na kũu nja ya kambĩ matukũ mũgwanja; na thuutha ũcio no acookio kambĩ.” ");
INSERT INTO kik_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Nĩ ũndũ ũcio Miriamu akĩhingĩrĩrio na kũu nja ya kambĩ ĩyo matukũ mũgwanja, nao andũ acio angĩ matiathiire na mbere na rũgendo nginya rĩrĩa Miriamu aacookirio kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Thuutha ũcio, andũ acio a Isiraeli makiuma Hazerothu magĩthiĩ makĩamba hema ciao Werũ-inĩ wa Parani. ");
INSERT INTO kik_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Tũma arũme amwe mathiĩ magathigaane bũrũri wa Kaanani, ũrĩa ngũhe andũ a Isiraeli. Tũma mũtongoria ũmwe wao, kuuma o mũhĩrĩga o mũhĩrĩga wa maithe mao.” ");
INSERT INTO kik_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Nake Musa agĩathĩkĩra watho wa Jehova, na agĩtũma andũ acio kuuma Werũ wa Parani. Andũ acio othe maarĩ atongoria a andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Maya nĩmo marĩĩtwa ma atongoria acio: kuuma mũhĩrĩga wa Rubeni, aarĩ Shamua mũrũ wa Zakuri; ");
INSERT INTO kik_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","kuuma mũhĩrĩga wa Simeoni, aarĩ Shafati mũrũ wa Hori; ");
INSERT INTO kik_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","kuuma mũhĩrĩga wa Juda, aarĩ Kalebu mũrũ wa Jefune; ");
INSERT INTO kik_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","kuuma mũhĩrĩga wa Isakaru, aarĩ Igali mũrũ wa Jusufu; ");
INSERT INTO kik_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","kuuma mũhĩrĩga wa Efiraimu, aarĩ Hoshea mũrũ wa Nuni; ");
INSERT INTO kik_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","kuuma mũhĩrĩga wa Benjamini, aarĩ Paliti mũrũ wa Rafu; ");
INSERT INTO kik_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","kuuma mũhĩrĩga wa Zebuluni, aarĩ Gadieli mũrũ wa Sodi; ");
INSERT INTO kik_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","kuuma mũhĩrĩga wa Manase (na nĩguo mũhĩrĩga wa Jusufu), aarĩ Gadi mũrũ wa Susi; ");
INSERT INTO kik_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","kuuma mũhĩrĩga wa Dani, aarĩ Amieli mũrũ wa Gemali; ");
INSERT INTO kik_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","kuuma mũhĩrĩga wa Asheri, aarĩ Sethuri mũrũ wa Mikaeli; ");
INSERT INTO kik_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","kuuma mũhĩrĩga wa Nafitali, aarĩ Nahabi mũrũ wa Vofisi; ");
INSERT INTO kik_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","kuuma mũhĩrĩga wa Gadi, aarĩ Geueli mũrũ wa Maki. ");
INSERT INTO kik_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Macio nĩmo marĩĩtwa ma andũ arĩa Musa aatũmire magathigaane bũrũri ũcio. Nake Musa akĩgarũra rĩĩtwa rĩa Hoshea mũrũ wa Nuni akĩmũtua Joshua. ");
INSERT INTO kik_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Rĩrĩa Musa aatũmire andũ acio magathigaane bũrũri wa Kaanani, aameerire atĩrĩ, “Ambatai mũtuĩkanĩrie Negevu, mũthiĩ bũrũri ũcio ũrĩ irĩma. ");
INSERT INTO kik_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Tuĩriai bũrũri ũcio ũrĩa ũtariĩ, muone kana andũ akuo marĩ na hinya kana matirĩ hinya, o na kana nĩ aingĩ kana nĩ anini. ");
INSERT INTO kik_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ningĩ mũmenye bũrũri ũcio matũũraga ũhaana atĩa? Nĩ mwega kana nĩ mũũru? Matũũraga matũũra ma mũthemba ũrĩkũ? Nĩ mairigĩre na thingo cia hinya kana ti mairigĩre? ");
INSERT INTO kik_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Tĩĩri wakuo ũtariĩ atĩa? Nĩ mũnoru kana nĩ mũhĩnju? Kũrĩ mĩtĩ kana gũtirĩ? Geriai mũno mũrehe maciaro mamwe ma bũrũri ũcio.” (Hĩndĩ ĩyo nĩguo mĩthabibũ yaambagĩrĩria kwĩrua.) ");
INSERT INTO kik_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Tondũ ũcio makĩambata magĩthigaana bũrũri ũcio kuuma Werũ wa Zini nginya Rehobu, merekeire Lebo-Hamathu. ");
INSERT INTO kik_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Mambatire matuĩkanĩirie Negevu na magĩkinya Hebironi kũrĩa Ahimani, na Sheshai, na Talimai, njiaro cia Anaki, maatũũraga. (Itũũra rĩa Hebironi rĩakĩtwo mĩaka mũgwanja mbere ya itũũra rĩa Zoani gwakwo bũrũri-inĩ wa Misiri.) ");
INSERT INTO kik_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Rĩrĩa maakinyire Kĩanda gĩa Eshikoli, magĩtema rũhonge rwarĩ na kĩmanjĩka kĩmwe gĩa thabibũ. Andũ eerĩ ao makĩrũkuuanĩra na mũtĩ, hamwe na makomamanga mamwe, na ngũyũ. ");
INSERT INTO kik_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Naho handũ hau hagĩĩtwo Kĩanda gĩa Eshikoli nĩ ũndũ wa kĩmanjĩka kĩu gĩa thabibũ kĩrĩa andũ a Isiraeli acio maatemire ho. ");
INSERT INTO kik_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Matukũ mĩrongo ĩna mathira magĩcooka kuuma gũthigaana bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Nao magĩcooka kũrĩ Musa, na Harũni na kĩrĩndĩ gĩothe kĩa andũ a Isiraeli kũu Kadeshi o kũu Werũ-inĩ wa Parani. Kũu makĩhe Musa na Harũni, na kĩũngano gĩothe ũhoro ũcio na makĩmoonia maciaro ma bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Makĩhe Musa ũhoro ũyũ: “Nĩtwatoonyire bũrũri ũrĩa watũtũmire, naguo nĩ bũrũri ũrĩ bũthi wa iria na ũũkĩ! Maya nĩmo maciaro maguo. ");
INSERT INTO kik_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","No rĩrĩ, andũ arĩa matũũraga kũu marĩ hinya, na matũũra mao nĩmairigĩre na thingo cia hinya, na nĩ manene mũno. O na ningĩ nĩtuonire njiaro cia Anaki kuo. ");
INSERT INTO kik_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Aamaleki matũũraga kũu Negevu; Ahiti, na Ajebusi, na Aamori matũũraga bũrũri ũrĩa ũrĩ irĩma; Akaanani nao matũũraga ndwere-inĩ cia iria na hũgũrũrũ-inĩ cia Rũũĩ rwa Jorodani.” ");
INSERT INTO kik_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Nake Kalebu agĩkiria andũ acio o hau mbere ya Musa, akiuga atĩrĩ, “Nĩtwagĩrĩirwo nĩ kwambata tũthiĩ twĩnyiitĩre bũrũri ũcio, nĩ ũndũ no tũhote gwĩka ũguo.” ");
INSERT INTO kik_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","No andũ arĩa maambatĩte nake makiuga atĩrĩ, “Tũtingĩtharĩkĩra andũ acio, marĩ na hinya gũtũkĩra.” ");
INSERT INTO kik_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Nao makĩhunjia ũhoro mũũru kũrĩ andũ a Isiraeli ũkoniĩ bũrũri ũcio maathigaanĩte. Makiuga atĩrĩ, “Bũrũri ũcio tũrathigaanire nĩ bũrũri ũgũtambuura andũ arĩa matũũraga kuo ũkamaniina biũ. Andũ arĩa othe tuonire kuo nĩ anene mũno. ");
INSERT INTO kik_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nĩtuonire Anefili kuo (njiaro cia Anaki, a kĩruka kĩa Anefili). Tweyonaga tũhaana ta ndaahi, o nao moonaga tũhaana o ta cio.” ");
INSERT INTO kik_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ũtukũ ũcio andũ othe a kĩrĩndĩ gĩa Isiraeli makĩrĩra maanĩrĩire na mũgambo mũnene. ");
INSERT INTO kik_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Andũ acio othe a Isiraeli makĩnuguna nĩ ũndũ wa Musa na Harũni, na kĩũngano kĩu gĩothe gĩkĩmeera atĩrĩ, “Naarĩ korwo twakuĩrĩire Misiri! Kana werũ-inĩ ũyũ! ");
INSERT INTO kik_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nĩ kĩĩ gĩgũtũma Jehova atũrehe bũrũri ũyũ atũrekererie tũũragwo na rũhiũ rwa njora? Atumia aitũ na ciana ciitũ megũtuĩka a gũtahwo. Githĩ wega ti tũcooke bũrũri wa Misiri?” ");
INSERT INTO kik_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Nao makĩĩrana mũndũ na ũrĩa ũngĩ atĩrĩ, “Twagĩrĩirwo nĩ tũthuure mũtongoria tũcooke bũrũri wa Misiri.” ");
INSERT INTO kik_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Hĩndĩ ĩyo Musa na Harũni makĩĩgũithia maturumithĩtie mothiũ mao thĩ mbere ya kĩũngano kĩu gĩothe kĩa andũ a Isiraeli kĩrĩa kĩagomanĩte hau. ");
INSERT INTO kik_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Joshua mũrũ wa Nuni na Kalebu mũrũ wa Jefune, arĩa maarĩ hamwe na arĩa maathiĩte gũthigaana bũrũri ũcio magĩtembũranga nguo ciao. ");
INSERT INTO kik_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Makĩĩra kĩũngano kĩu gĩothe kĩa andũ a Isiraeli atĩrĩ, “Bũrũri ũrĩa twatuĩkanĩirie na tũkĩũthigana, nĩ bũrũri mwega mũno makĩria. ");
INSERT INTO kik_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Jehova angĩkorwo nĩakenetio nĩ ithuĩ, nĩegũtũtongoria tũtoonye bũrũri ũcio, bũrũri ũcio ũiyũrĩte bũthi wa iria na ũũkĩ, na nĩegũtũhe guo ũtuĩke witũ. ");
INSERT INTO kik_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","No rĩrĩ, mũtikaremere Jehova. Na mũtigetigĩre andũ a bũrũri ũcio, nĩ ũndũ tũkũmameria biũ. Ũgitĩri wao nĩ mweherie, no Jehova arĩ hamwe na ithuĩ. Mũtikametigĩre.” ");
INSERT INTO kik_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","No kĩũngano kĩu gĩothe gĩkĩaria ũhoro wa kũmahũũra na mahiga nyuguto. Hĩndĩ ĩyo riiri wa Jehova ũkiumĩrĩra andũ othe a Isiraeli hau Hema-inĩ ya Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Nake Jehova akĩũria Musa atĩrĩ, “Andũ aya megũtũũra maanyararĩte nginya-rĩ? Megũtũũra maregete kũnjĩtĩkia nginya-rĩ, o na ningĩte ciama nyingĩ ũguo gatagatĩ kao? ");
INSERT INTO kik_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nĩngũmahũũra na mũthiro ndĩmaniine, no wee ngũgũtua rũrĩrĩ rũnene na rũrĩ na hinya kũmakĩra.” ");
INSERT INTO kik_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Musa akĩĩra Jehova atĩrĩ, “Andũ a Misiri nĩmakaigua ũhoro ũcio! Nĩwe warutire andũ aya makiuma gatagatĩ kao na ũndũ wa ũhoti waku. ");
INSERT INTO kik_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Nao nĩmakeera aikari a bũrũri ũyũ ũhoro ũcio. Nĩmaiguĩte atĩ Wee, O Wee Jehova-rĩ, ũkoragwo na andũ aya, na atĩ Wee Jehova, wanonwo ũthiũ kwa ũthiũ, na atĩ itu rĩaku rĩikaraga igũrũ rĩao, o na atĩ Wee ũthiiaga mbere yao thĩinĩ wa gĩtugĩ kĩa itu mũthenya na ũrĩ thĩinĩ wa gĩtugĩ kĩa mwaki ũtukũ. ");
INSERT INTO kik_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ũngĩũraga andũ aya othe o ro rĩmwe-rĩ, ndũrĩrĩ iria ciiguĩte ũhoro ũyũ waku nĩikoiga atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Jehova nĩaremirwo nĩgũkinyia andũ aya bũrũri ũrĩa aamerĩire na mwĩhĩtwa; nĩ ũndũ ũcio akĩmooragĩra werũ-inĩ.’ ");
INSERT INTO kik_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Na rĩrĩ, hinya wa Mwathani ũrokĩonekana o ta ũrĩa ugĩte, atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Jehova ndahiũhaga kũrakara, aiyũrĩtwo nĩ wendo, na nĩohanagĩra mehia na ũremi. No ndaagaga kũherithia mũndũ ũrĩa wĩhĩtie; nĩaherithagia ciana nĩ ũndũ wa mehia ma maithe nginya rũciaro rwa gatatũ na rwa kana.’ ");
INSERT INTO kik_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Kũringana na wendo waku mũnene-rĩ, ohera andũ aya mehia mao, o ta ũrĩa wanamarekera kuuma hĩndĩ ĩrĩa moimire bũrũri wa Misiri nginya rĩu.” ");
INSERT INTO kik_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Jehova akĩmũcookeria atĩrĩ, “Nĩ ndamarekera o ta ũguo woria. ");
INSERT INTO kik_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","No rĩrĩ, ti-itherũ o ta ũrĩa niĩ ndũũraga muoyo, na ti-itherũ o ta ũrĩa riiri wa Jehova ũiyũrĩte thĩ yothe-rĩ, ");
INSERT INTO kik_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","gũtirĩ o na ũmwe wa andũ arĩa moonire riiri wakwa na ciama iria ndaringĩire kũu bũrũri wa Misiri o na gũkũ werũ-inĩ, no makĩĩnemera na makĩĩngeria maita ikũmi-rĩ, ");
INSERT INTO kik_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","gũtirĩ o na ũmwe wa acio ũkoona bũrũri ũcio nderĩire maithe mao ma tene na mwĩhĩtwa. Gũtirĩ o na ũmwe wao wa arĩa maanyararĩte ũkaawona. ");
INSERT INTO kik_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","No tondũ ndungata yakwa Kalebu arĩ na roho wa mũthemba ũngĩ na nĩanũmagĩrĩra na ngoro yake yothe, nĩngamũtwara bũrũri ũcio aathiĩte, nacio njiaro ciake nĩikaũgaya. ");
INSERT INTO kik_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Na tondũ andũ a Amaleki na a Kaanani matũũraga cianda-inĩ-rĩ, rokai kũgarũrũka mumagare mũrorete na werũ-inĩ, mũthiĩ na njĩra ya Iria Itune.” ");
INSERT INTO kik_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Nake Jehova akĩĩra Musa na Harũni atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Nĩ nginya hĩndĩ ĩrĩkũ kĩrĩndĩ gĩkĩ kĩaganu gĩgũtũũra kĩĩnugunagĩra? Nĩnjiguĩte mateta ma anugunĩki aya a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Nĩ ũndũ ũcio meere atĩrĩ, ‘Jehova ekuuga ũũ: Ti-itherũ o ta ũrĩa niĩ ndũũraga muoyo-rĩ, nĩ ngũmwĩka o maũndũ macio njiguĩte mũkĩaria. ");
INSERT INTO kik_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ciimba cianyu ikaagũa werũ-inĩ ũyũ, inyuĩ arĩa othe mũrĩ na ũkũrũ wa mĩaka mĩrongo ĩĩrĩ na makĩria arĩa mwatarirwo hĩndĩ ya itarana na arĩa manugunĩte nĩ ũndũ wakwa. ");
INSERT INTO kik_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Gũtirĩ o na ũmwe wanyu ũgatoonya bũrũri ũcio ndehĩtire nyambararĩtie guoko atĩ nĩũgatuĩka wanyu, tiga o Kalebu mũrũ wa Jefune, na Joshua mũrũ wa Nuni. ");
INSERT INTO kik_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","No ha ũhoro wa ciana cianyu iria mwoigire atĩ nĩ igaatahwo-rĩ, nĩngamakinyia kuo makenagĩre bũrũri ũcio mũregete. ");
INSERT INTO kik_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","No inyuĩ-rĩ, ciimba cianyu ikaagũa werũ-inĩ ũyũ. ");
INSERT INTO kik_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ciana cianyu igũtuĩka arĩithi gũkũ werũ-inĩ mĩaka mĩrongo ĩna, igĩthĩnĩkaga nĩ ũndũ wa kwaga kwĩhokeka kwanyu, nginya rĩrĩa kĩimba kĩanyu kĩa mũthia gĩkaagũa werũ-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mĩaka mĩrongo ĩna, o mwaka ũmwe ũrũgamĩrĩire mũthenya ũmwe wa mĩthenya mĩrongo ĩna ĩrĩa mwathigaanire bũrũri ũcio, mĩaka ĩyo nĩyo mũgaathĩnĩka nĩ ũndũ wa mehia manyu, na mũmenye ũũru wa gũũkĩrĩrwo nĩ niĩ.’ ");
INSERT INTO kik_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Niĩ Jehova nĩ niĩ njarĩtie, na ti-itherũ nĩngeeka maũndũ macio kũrĩ kĩrĩndĩ gĩkĩ gĩothe kĩaganu, kĩrĩa gĩĩcookanĩrĩirie hamwe kĩnjũkĩrĩre. Gĩgaathirĩra werũ-inĩ ũyũ; gũkũ nĩkuo gĩgaakuĩra.” ");
INSERT INTO kik_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Nĩ ũndũ ũcio, andũ arĩa Musa aatũmĩte magathigaane bũrũri ũcio wa Kaanani, o acio macookire na magĩtũma kĩrĩndĩ gĩothe kĩnugunĩre Musa nĩkũmemerekia ũhoro mũũru wa bũrũri ũcio, ");
INSERT INTO kik_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","andũ acio mamemerekirie ũhoro ũcio mũũru wa bũrũri ũcio makĩhũũrwo na mũthiro, magĩkuĩra hau mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Harĩ andũ arĩa maathiĩte gũthigaana bũrũri ũcio, no Joshua mũrũ wa Nuni, na Kalebu mũrũ wa Jefune maatigarire. ");
INSERT INTO kik_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Rĩrĩa Musa aaheire andũ othe a Isiraeli ũhoro ũcio, makĩgirĩka mũno. ");
INSERT INTO kik_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mũthenya ũyũ ũngĩ rũciinĩ tene makĩambata marorete bũrũri ũrĩa ũrĩ irĩma. Makiuga atĩrĩ, “Nĩtwĩhĩtie, nĩtũkwambata tũthiĩ nginya kũrĩa Jehova aatwĩrĩire.” ");
INSERT INTO kik_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","No Musa akĩmooria atĩrĩ, “Mũraremera watho wa Jehova nĩkĩ? Ũndũ ũyũ ndũngĩgaacĩra! ");
INSERT INTO kik_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mũtikambate tondũ Jehova ndarĩ hamwe na inyuĩ. Nĩmũkũhootwo nĩ thũ cianyu, ");
INSERT INTO kik_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","nĩgũkorwo andũ a Amaleki na Akaanani nĩmakarũa na inyuĩ kũu. Nĩ ũndũ nĩ mũhutatĩire Jehova, nake ndegũkorwo hamwe na inyuĩ, na nĩmũkũũragwo na rũhiũ rwa njora.” ");
INSERT INTO kik_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","No rĩrĩ, nĩ ũndũ wa mwĩĩro wao, makĩambata marorete bũrũri ũrĩa ũrĩ irĩma o na gũkorwo Musa ndoimire kambĩ o na kana ithandũkũ rĩa kĩrĩkanĩro kĩa Jehova rĩkiuma kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","No rĩrĩ, andũ a Amaleki na Akaanani arĩa maatũũraga bũrũri ũcio ũrĩ irĩma, magĩikũrũka, makĩmatharĩkĩra, na makĩmahũũra mamaikũrũkĩtie o nginya Horoma. ");
INSERT INTO kik_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Thuutha wa gũtoonya bũrũri ũrĩa ngũmũhe ũtuĩke mũciĩ wanyu, ");
INSERT INTO kik_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","na mũrutĩre Jehova maruta ma njino kuuma rũũru rwa ngʼombe kana rwa mbũri, matuĩke mũtararĩko wa gũkenia Jehova, marĩ maruta ma njino, kana magongona, nĩ ũndũ wa mĩĩhĩtwa ya mwanya, kana maruta ma kwĩyendera kana maruta ma ciathĩ-rĩ, ");
INSERT INTO kik_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ũrĩa ũrĩĩrehaga iruta rĩake, arĩĩrutagĩra Jehova iruta rĩa mũtu gĩcunjĩ gĩa ikũmi kĩa eba ĩmwe ya mũtu mũhinyu mũno, ũtukanĩtio na gĩcunjĩ kĩa inya kĩa hini ĩmwe ya maguta. ");
INSERT INTO kik_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Harĩ o gatũrũme ka iruta rĩa njino kana igongona, haaragĩria gĩcunjĩ kĩa inya kĩa hini ĩmwe ya ndibei ĩrĩ iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Igongona rĩa ndũrũme-rĩ, haarĩria igongona rĩa mũtu icunjĩ igĩrĩ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno, ũtukanĩtio na gĩcunjĩ gĩa ithatũ kĩa hini ĩmwe ya maguta, ");
INSERT INTO kik_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","na gĩcunjĩ gĩa ithatũ kĩa hini ĩmwe ya ndibei ĩrĩ iruta rĩa kũnyuuo. Rĩrutei rĩrĩ mũtararĩko wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Rĩrĩa mũkũhaarĩria gategwa nĩ ũndũ wa iruta rĩa njino kana igongona, nĩ ũndũ wa mwĩhĩtwa wa mwanya kana iruta rĩa ũiguano rĩrutĩirwo Jehova-rĩ, ");
INSERT INTO kik_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","rehagai hamwe na ndegwa ĩyo iruta rĩa mũtu icunjĩ ithatũ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno, ũtukanĩtio na nuthu ya hini ĩmwe ya maguta. ");
INSERT INTO kik_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","O na ningĩ rehagai nuthu ya hini ĩmwe ya ndibei ĩrĩ iruta rĩa kũnyuuo. Narĩo igongona rĩu rĩgatuĩka iruta rĩa njino rĩrĩ mũtararĩko wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Ndegwa kana ndũrũme o yothe, kana gatũrũme kana koori o gothe, irĩhaaragĩrio o ro ũguo. ");
INSERT INTO kik_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ĩkagai ũguo harĩ o ĩmwe yacio ya iria ciothe mũrĩharagĩria. ");
INSERT INTO kik_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Mũndũ wothe ũciarĩirwo kwanyu no nginya ekage maũndũ macio ũguo rĩrĩa arĩrehaga iruta rĩa gũcinwo na mwaki rĩrĩ mũtararĩko wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nĩ ũndũ wa njiarwa iria igooka, rĩrĩa rĩothe mũgeni kana mũndũ ũngĩ o wothe ũtũũranĩtie na inyuĩ arĩĩrutaga iruta rĩa gũcinwo na mwaki rĩrĩ mũtararĩko wa gũkenia Jehova-rĩ, no nginya ekage o ta ũrĩa inyuĩ mwĩkaga. ");
INSERT INTO kik_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kĩrĩndĩ gĩkĩ kĩrĩkoragwo na watho o ũmwe wanyu na harĩ mũgeni ũrĩa ũtũũranĩtie na inyuĩ; ũyũ nĩ watho wa gũtũũra nĩ ũndũ wa njiarwa iria igooka. Inyuĩ na mũgeni mũrĩkoragwo mũrĩ o ũndũ ũmwe maitho-inĩ ma Jehova. ");
INSERT INTO kik_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mawatho mamwe na mwathanĩre ũmwe nĩguo ũrĩhũthagĩrwo harĩ inyuĩ na harĩ mũgeni ũrĩa ũtũũranĩtie na inyuĩ.’ ” ");
INSERT INTO kik_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ningĩ Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Rĩrĩa mũgatoonya bũrũri ũrĩa ndĩramũtwara, ");
INSERT INTO kik_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","na mũrĩe irio cia bũrũri ũcio, heanai imwe ciacio irĩ iruta harĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Nĩ mũkaaruta tũmĩgate kuuma mũtu-inĩ wanyu ũrĩa mũgaathĩa rĩa mbere na mũtũheane tũrĩ iruta kĩhuhĩro-inĩ kĩa ngano. ");
INSERT INTO kik_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Nĩmũkaheanaga iruta rĩrĩ rĩa mũtu ũrĩa mũgathĩa rĩa mbere kũrĩ Jehova njiarwa-inĩ cianyu ciothe iria igooka thuutha. ");
INSERT INTO kik_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Na rĩrĩ, mũngĩkaaga kũrũmĩrĩra rĩathani o na rĩmwe rĩa maya Jehova aaheire Musa mũtekwenda-rĩ, ");
INSERT INTO kik_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","rĩathani o rĩothe Jehova aamũheire na kanua ka Musa kuuma mũthenya ũrĩa Jehova aamaheanire na kũrũmĩrĩra nginya njiarwa iria igooka, ");
INSERT INTO kik_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","na ũndũ ũcio ũngĩkorwo wĩkĩtwo mũtekwenda, kĩrĩndĩ gĩtekũmenya ũhoro ũcio, hĩndĩ ĩyo kĩrĩndĩ gĩothe nĩgĩkaruta gategwa gatuĩke igongona rĩa njino rĩna mũtararĩko wa gũkenia Jehova, hamwe na maruta ma mũtu na ma kũnyuuo, marĩa matuĩtwo, na thenge ya igongona rĩa kũhoroheria mehia. ");
INSERT INTO kik_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Mũthĩnjĩri-Ngai nĩakahoroheria kĩrĩndĩ kĩu gĩothe kĩa andũ a Isiraeli, na nĩmakarekerwo, nĩgũkorwo ũndũ ũcio ndwarĩ wa rũtũrĩko, na nĩ ũndũ wa kũrutĩra Jehova iruta rĩa gũcinwo na mwaki rĩa mahĩtia mao, na iruta rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Kĩrĩndĩ gĩothe kĩa andũ a Isiraeli na ageni arĩa matũũranagia nao nĩmakarekerwo, nĩ ũndũ andũ othe mehĩtie matekwenda. ");
INSERT INTO kik_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘No kũngĩkorwo no mũndũ ũmwe wĩhĩtie atekwenda, no nginya arehe kaharika ka mwaka ũmwe ka igongona rĩa kũhoroherio mehia. ");
INSERT INTO kik_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Mũthĩnjĩri-Ngai nĩakahoroheria mũndũ ũcio wĩhĩtie atekwenda hau mbere ya Jehova na aarĩkia kũhoroherio, nĩakarekerwo. ");
INSERT INTO kik_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Watho o ro ũmwe nĩguo ũrĩhũthagĩrwo harĩ mũndũ o wothe ũkehia atekwenda, arĩ Mũisiraeli ũciarĩirwo kwanyu kana arĩ mũgeni. ");
INSERT INTO kik_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘No mũndũ ũrĩa ũkehia na rũtũrĩko akĩendaga, arĩ wa gũciarĩrwo kwanyu kana arĩ mũgeni, ũcio nĩarumĩte Jehova, na mũndũ ũcio no nginya aingatwo kuuma kũrĩ andũ ao. ");
INSERT INTO kik_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Nĩ ũndũ nĩ amenete kiugo kĩa Jehova na akoina maathani make, mũndũ ũcio ti-itherũ no nginya aingatwo biũ naguo wĩhia wake nĩũkamũcokerera.’ ” ");
INSERT INTO kik_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Hĩndĩ ĩrĩa andũ a Isiraeli maarĩ werũ-inĩ, kũrĩ mũndũ wonirwo akiuna ngũ mũthenya wa Thabatũ. ");
INSERT INTO kik_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Arĩa maamuonire akiuna ngũ makĩmũtwara kũrĩ Musa na Harũni, o na kũrĩ kĩũngano kĩu gĩothe gĩa Isiraeli, ");
INSERT INTO kik_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","na makĩmũhingĩra nĩ ũndũ gũtiamenyekaga ũrĩa agĩrĩirwo nĩ gwĩkwo. ");
INSERT INTO kik_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Nake Jehova akĩĩra Musa atĩrĩ, “Mũndũ ũcio no nginya akue. Kĩũngano gĩothe kĩa Isiraeli no nginya kĩmũhũũre na mahiga nyuguto nja ya kambĩ.” ");
INSERT INTO kik_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Nĩ ũndũ ũcio kĩũngano kĩu gĩkĩmũtwara nja ya kambĩ gĩkĩmũhũũra na mahiga nyuguto agĩkua, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Arĩria andũ a Isiraeli, ũmeere atĩrĩ: ‘Njiarwa-inĩ ciothe iria igooka, nĩmũgatumagĩrĩra ciohe cia ndigi koine-inĩ ka nguo cianyu, o kĩohe gĩkohererwo na rũrigi rwa rangi wa bururu. ");
INSERT INTO kik_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ciohe icio nĩcio mũrĩroraga nĩguo mũririkanage maathani mothe ma Jehova, nĩguo mũmathĩkagĩre, mũtikanahũũre ũmaraya na ũndũ wa kũrũmĩrĩra merirĩria ma ngoro o na kana maitho manyu. ");
INSERT INTO kik_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ningĩ nĩmũkaririkanaga gwathĩkagĩra maathani makwa mothe na mũtuĩke andũ mamũrĩirwo Ngai wanyu. ");
INSERT INTO kik_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Niĩ nĩ niĩ Jehova Ngai wanyu, ũrĩa wamũrutire bũrũri wa Misiri nĩguo nduĩke Ngai wanyu. Niĩ nĩ niĩ Jehova Ngai wanyu.’ ” ");
INSERT INTO kik_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Na rĩrĩ, Kora mũrũ wa Iziharu, mũrũ wa Kohathu, ũrĩa warĩ mũrũ wa Lawi, marĩ na andũ amwe a mũhĩrĩga wa Rubeni nĩo Dathani na Abiramu, ariũ a Eliabu, na Oni mũrũ wa Pelethu, magĩtuĩka a kũngʼathia. ");
INSERT INTO kik_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Nao magĩũkĩrĩra Musa. Hamwe nao haarĩ arũme a Isiraeli 250, atongoria mooĩkaine a kĩrĩndĩ kĩu arĩa maathuurĩtwo marĩ a kĩama. ");
INSERT INTO kik_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Nao magĩũka marĩ gĩkundi makararie Musa na Harũni, makĩmeera atĩrĩ, “Inyuĩ nĩmwĩtũgĩrĩtie mũno! Kĩrĩndĩ gĩkĩ gĩothe nĩ gĩtheru, mũndũ o mũndũ, nake Jehova arĩ hamwe nao. Nĩ kĩĩ gĩtũmĩte mwĩtũũgĩrie igũrũ rĩa kĩũngano gĩkĩ kĩa Jehova?” ");
INSERT INTO kik_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Rĩrĩa Musa aiguire ũguo-rĩ, akĩgũa, agĩturumithia ũthiũ thĩ. ");
INSERT INTO kik_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ningĩ agĩcooka akĩĩra Kora na arũmĩrĩri ake othe atĩrĩ: “Rũciinĩ, Jehova nĩakonania nũũ wake na nũũ mũtheru, na nĩakareka mũndũ ũcio amũkuhĩrĩrie. Mũndũ ũrĩa agaathuura, ũcio nĩwe akaareka amũkuhĩrĩrie. ");
INSERT INTO kik_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Wee Kora na arũmĩrĩri aku othe, ũũ nĩguo mũgeeka: mũkoya ngĩo cia gũcinĩra ũbumba, ");
INSERT INTO kik_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","na rũciũ mũciĩkĩre mwaki na ũbumba mũrĩ mbere ya Jehova. Mũndũ ũrĩa Jehova agaathuura-rĩ, ũcio agaatuĩka nĩwe mũtheru. Inyuĩ Alawii nĩmwĩtũgĩrĩtie mũno!” ");
INSERT INTO kik_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Ningĩ Musa akĩĩra Kora atĩrĩ, “Ta thikĩrĩriai inyuĩ Alawii! ");
INSERT INTO kik_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Anga mũtiganĩire nĩ Ngai wa Isiraeli kũmwamũrania na kĩrĩndĩ kĩrĩa kĩngĩ gĩothe kĩa andũ a Isiraeli, akamũrehe hakuhĩ nake nĩgeetha mũrutage wĩra hema-inĩ ĩrĩa nyamũre ya Jehova, na mũrũgamage mbere ya kĩrĩndĩ mũgĩtungatagĩre? ");
INSERT INTO kik_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Inyuĩ hamwe na Alawii othe a thiritũ yanyu nĩamũrehete hakuhĩ nake, no rĩu mũrageria kuoya wĩra wa ũthĩnjĩri-Ngai o naguo. ");
INSERT INTO kik_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Wee na arũmĩrĩri aku othe mũnganĩte hamwe mũũkĩrĩre Jehova. Harũni nũũ atĩ nĩguo mũnugune nĩ ũndũ wake?” ");
INSERT INTO kik_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Musa agĩcooka agĩĩta Dathani na Abiramu, ariũ a Eliabu. No-o makiuga atĩrĩ, “Tũtigũũka! ");
INSERT INTO kik_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Anga ti kũiganu atĩ nĩwatũrutire bũrũri warĩ bũthi wa iria na ũũkĩ ũũke ũtũũragĩre werũ-inĩ ũyũ? Rĩu ningĩ ũrenda gũtwatha? ");
INSERT INTO kik_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ningĩ-rĩ, ndũrĩ ũratũkinyia bũrũri ũrĩ na bũthi wa iria na ũũkĩ, kana ũgatũhe igai rĩa ithaka na mĩgũnda ya mĩthabibũ. Nĩ ũgũkũũra andũ aya maitho ũmaheenie? Aca, tũtigũũka!” ");
INSERT INTO kik_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Nake Musa akĩrakara mũno, akĩĩra Jehova atĩrĩ, “Ndũgetĩkĩre maruta mao. Niĩ ndioete o na ndigiri kuuma kũrĩ o, o na ndihĩtĩirie mũndũ wao o na ũmwe.” ");
INSERT INTO kik_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Ningĩ Musa akĩĩra Kora atĩrĩ, “Wee na arũmĩrĩri aku othe mũgooka mbere ya Jehova rũciũ, wee, nao, na Harũni. ");
INSERT INTO kik_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","O mũndũ nĩakoya rũgĩo rwake na arwĩkĩre ũbumba, ngĩo ciothe nĩ 250, na mũcirehe mbere ya Jehova. Wee, na Harũni, o na inyuĩ mũrehe ngĩo cianyu.” ");
INSERT INTO kik_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Nĩ ũndũ ũcio o mũndũ akĩoya rũgĩo rwake, akĩrwĩkĩra mwaki na ũbumba, na makĩrũgamania mbere ya Musa na Harũni itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Rĩrĩa Kora aarĩkirie gũcookereria arũmĩrĩri ake othe nĩguo makararie Musa na Harũni marũngiĩ itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo-rĩ, riiri wa Jehova ũkiumĩrĩra kĩũngano kĩu gĩothe. ");
INSERT INTO kik_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Nake Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Mwĩyamũraniei na kĩũngano gĩkĩ nĩguo ndĩkĩniine o ro rĩmwe.” ");
INSERT INTO kik_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","No Musa na Harũni makĩĩgũithia magĩturumithia mothiũ mao thĩ makĩanĩrĩra makiuga atĩrĩ, “Wee Ngai, Ngai wa Maroho ma andũ othe, kaĩ ũngĩrakarĩra kĩũngano gĩkĩ gĩothe hĩndĩ ĩrĩa arĩ o mũndũ ũmwe wĩhĩtie?” ");
INSERT INTO kik_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ĩra kĩũngano gĩothe atĩrĩ, ‘Eherai kuuma hema-inĩ cia Kora na Dathani na Abiramu.’ ” ");
INSERT INTO kik_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa agĩũkĩra, agĩthiĩ kũrĩ Dathani na Abiramu, nao athuuri a Isiraeli makĩmũrũmĩrĩra. ");
INSERT INTO kik_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Nake agĩkaania kĩũngano kĩu, agĩkĩĩra atĩrĩ, “Ehererai hema cia andũ aya aaganu! Mũtikahutie kĩndũ o na kĩmwe kĩao, nĩguo mũtikaniinwo nĩ ũndũ wa mehia mao mothe.” ");
INSERT INTO kik_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Nĩ ũndũ ũcio andũ makĩeherera hema icio cia Kora na Dathani na Abiramu. Dathani na Abiramu nĩ moimĩte makarũgama na atumia ao, na ciana cia ngenge itoonyero-inĩ rĩa hema ciao. ");
INSERT INTO kik_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ningĩ Musa akiuga atĩrĩ, “Ũndũ ũyũ nĩguo ũgũtũma mũmenye atĩ Jehova nĩwe ũndũmĩte njĩke maũndũ maya mothe, na atĩ rĩtiarĩ ithugunda rĩakwa: ");
INSERT INTO kik_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Andũ aya mangĩkua gĩkuũ kĩa ndũire-rĩ, o na kana mone maũndũ o ta marĩa makoraga andũ othe-rĩ, nĩmũkũmenya atĩ ti Jehova ũndũmĩte. ");
INSERT INTO kik_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","No Jehova angĩrehe ũndũ ũngĩ mwerũ biũ, nayo thĩ yathamie kanua kayo ĩmamerie hamwe na indo ciao ciothe, na mathiĩ mbĩrĩra-inĩ marĩ muoyo, nĩmũkamenya atĩ andũ aya nĩ manyararĩte Jehova.” ");
INSERT INTO kik_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Na rĩrĩ, Musa aarĩkia kuuga ũguo wothe, thĩ ĩgĩatũka hau maarĩ. ");
INSERT INTO kik_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Nayo thĩ ĩgĩathamia kanua kayo ĩkĩmameria, hamwe na andũ ao na arũmĩrĩri othe a Kora, na indo ciao ciothe. ");
INSERT INTO kik_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Nao magĩikũrũka mbĩrĩra marĩ muoyo hamwe na indo ciao ciothe; nayo thĩ ĩkĩmahumbĩra, magĩkua, magĩthengio kĩrĩndĩ-inĩ kĩu. ");
INSERT INTO kik_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Nĩ ũndũ wa kĩrĩro kĩao, andũ othe a Isiraeli arĩa maamarigiicĩirie makĩũra, makĩanagĩrĩra atĩrĩ, “O na ithuĩ thĩ nĩĩgũtũmeria!” ");
INSERT INTO kik_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Naguo mwaki ũkiuma kũrĩ Jehova ũgĩcina andũ acio 250 arĩa maarehete ũbumba. ");
INSERT INTO kik_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ĩra Eleazaru mũrũ wa Harũni, ũrĩa mũthĩnjĩri-Ngai, oe ngĩo icio cia gũcinĩrwo ũbumba, acieherie hau irahĩĩra, na ahurunje makara macio handũ haraaya, nĩ ũndũ ngĩo icio nĩ nyamũre, ");
INSERT INTO kik_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ngĩo icio cia andũ acio makuĩte nĩ ũndũ wa mehia mao. Ngĩo icio nĩiturwo ituĩke mabati ma kũhumbĩra kĩgongona, nĩ ũndũ nĩciarehetwo mbere ya Jehova, na igatuĩka nyamũre. Nacio nĩ ituĩke kĩmenyithia harĩ andũ a Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Nĩ ũndũ ũcio Eleazaru ũrĩa mũthĩnjĩri-Ngai akĩoya ngĩo icio cia gĩcango ciarehetwo nĩ andũ acio maacinĩtwo, nake agĩciturithia ituĩke cia kũhumbĩra kĩgongona, ");
INSERT INTO kik_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","agĩĩka o ta ũrĩa Jehova aathĩrĩire Musa. Ũndũ ũyũ warĩ wa kũririkania andũ a Isiraeli atĩ gũtirĩ mũndũ o na ũrĩkũ, tiga wa rũciaro rwa Harũni, wagĩrĩirwo nĩ gũũka gũcina ũbumba mbere ya Jehova, kana atuĩke ta Kora na arũmĩrĩri ake. ");
INSERT INTO kik_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Mũthenya ũyũ ũngĩ, kĩrĩndĩ gĩothe kĩa andũ a Isiraeli gĩgĩtetia Musa na Harũni, gĩkĩmeera atĩrĩ, “Inyuĩ nĩ mũũragĩte andũ a Jehova.” ");
INSERT INTO kik_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Na rĩrĩa kĩũngano kĩu gĩecookanĩrĩirie gĩũkĩrĩre Musa na Harũni, o na gĩkĩerekera na kũrĩa Hema-ya-Gũtũnganwo yarĩ-rĩ, o rĩmwe itu rĩkĩhumbĩra hema ĩyo, naguo riiri wa Jehova ũkĩonekana. ");
INSERT INTO kik_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Nao Musa na Harũni magĩthiĩ hau mbere ya Hema-ya-Gũtũnganwo, ");
INSERT INTO kik_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Ehererai mume kĩũngano-inĩ gĩkĩ nĩguo ndĩkĩniine o ro rĩmwe.” No-o makĩĩgũithia thĩ, na magĩturumithia mothiũ mao thĩ. ");
INSERT INTO kik_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ningĩ Musa akĩĩra Harũni atĩrĩ, “Oya rũgĩo rwaku ũrwĩkĩre ũbumba hamwe na mwaki wa kuuma kĩgongona-inĩ, na ũthiĩ narua kĩũngano-inĩ kĩu ũkĩhoroherie. Mangʼũrĩ moimĩte kũrĩ Jehova; mũthiro nĩwambĩrĩirie kũmaniina.” ");
INSERT INTO kik_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Nĩ ũndũ ũcio Harũni agĩĩka o ta ũrĩa Musa aamwĩrire, agĩtengʼera agĩtoonya thĩinĩ wa kĩũngano kĩu. Mũthiro nĩwarĩĩkĩtie kwambĩrĩria thĩinĩ wa andũ, no Harũni akĩruta ũbumba akĩmahoroheria. ");
INSERT INTO kik_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Akĩrũgama gatagatĩ ka andũ arĩa maarĩ muoyo na arĩa maakuĩte, naguo mũthiro ũgĩthira. ");
INSERT INTO kik_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","No andũ 14,700 magĩkua nĩ ũndũ wa mũthiro ũcio, kuonganĩrĩria na andũ arĩa maakuĩte nĩ ũndũ wa Kora. ");
INSERT INTO kik_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Thuutha ũcio Harũni agĩcooka kũrĩ Musa itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo, tondũ mũthiro ũcio nĩwathirĩte. ");
INSERT INTO kik_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Arĩria andũ a Isiraeli, wĩtie thanju ikũmi na igĩrĩ, rũmwe kuuma kũrĩ o mũtongoria wa mĩhĩrĩga ya maithe mao. Andĩka rĩĩtwa rĩa o mũndũ rũthanju-inĩ rwake. ");
INSERT INTO kik_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Rũthanju rwa Lawi ũrwandĩke rĩĩtwa rĩa Harũni, nĩ ũndũ no nginya kũgĩe na rũthanju rũmwe rwa mũtongoria wa o mũhĩrĩga wa maithe mao ma tene. ");
INSERT INTO kik_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Igaai thanju icio thĩinĩ wa Hema-ya-Gũtũnganwo hau mbere ya ithandũkũ rĩa Ũira, harĩa ndũnganaga nawe. ");
INSERT INTO kik_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Rũthanju rwa mũndũ ũrĩa niĩ ngaathuura nĩrũgũthundũka, na niĩ ndĩyehererie kũnuguna gũkũ ũnugunagĩrwo hĩndĩ ciothe nĩ andũ a Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Nĩ ũndũ ũcio Musa akĩarĩria andũ a Isiraeli, nao atongoria ao makĩmũnengera thanju ikũmi na igĩrĩ, o rũmwe kuuma mũtongoria wa o mũhĩrĩga wa maithe mao ma tene, naruo rũthanju rwa Harũni rwarĩ hamwe nacio. ");
INSERT INTO kik_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Nake Musa akĩiga thanju icio mbere ya Jehova kũu Hema-inĩ-ya-Ũira. ");
INSERT INTO kik_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Mũthenya ũyũ ũngĩ-rĩ, Musa agĩtoonya thĩinĩ wa Hema-ya-Ũira akĩona atĩ rũthanju rwa Harũni, rũrĩa rwarũgamĩrĩire nyũmba ya Lawi, to gũthundũra rwathundũrĩte, no nĩ rwathuunĩte rũkaruta kĩro, na rũgaciara ndothi. ");
INSERT INTO kik_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Nake Musa akĩruta thanju icio nja, kuuma hau mbere ya Jehova, agĩciiga mbere ya andũ a Isiraeli othe. Nao magĩcirora, o mũndũ akĩoya rũthanju rwake mwene. ");
INSERT INTO kik_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Cookia rũthanju rwa Harũni hau mbere ya Ithandũkũ rĩa Ũira, rũigwo rũrĩ kĩmenyithia kũrĩ andũ acio aremi. Ũndũ ũyũ nĩguo ũkaaniina kũnuguna kwao kũrĩ niĩ, nĩgeetha matigakue.” ");
INSERT INTO kik_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Nake Musa agĩĩka o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Andũ a Isiraeli makĩĩra Musa atĩrĩ, “Nĩtũgũkua! Ithuothe nĩtũũrĩte! ");
INSERT INTO kik_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mũndũ o wothe o na ũngĩkuhĩrĩria Hema-ĩyo-Nyamũre ya Jehova nĩegũkua. Kaĩ tũgũgĩkua ithuothe?” ");
INSERT INTO kik_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Nake Jehova akĩĩra Harũni atĩrĩ, “Wee, na ariũ aku, na andũ a nyũmba ya thoguo, nĩ inyuĩ mũrĩcookagĩrĩrwo nĩ mahĩtia marĩa mangĩĩkwo makoniĩ handũ-harĩa-haamũre, na wee na ariũ aku inyuĩ nĩ inyuĩ mũrĩcookagĩrĩrwo nĩ mahĩtia marĩa mangĩĩkwo makoniĩ wĩra wa ũthĩnjĩri-Ngai. ");
INSERT INTO kik_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Rehe Alawii a mbarĩ yanyu, a mũhĩrĩga wa maithe manyu, nĩguo manyiitane na inyuĩ na mamũteithagĩrĩrie rĩrĩa wee na ariũ aku mũgũtungata mbere ya Hema-ya-Ũira. ");
INSERT INTO kik_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Acio nĩwe marĩathĩkagĩra na marutage wĩra wothe wa Hema ĩyo, no matikanakuhĩrĩrie indo cia handũ hau haamũre kana kĩgongona, kana wee hamwe nao mũkue. ");
INSERT INTO kik_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Marĩrutithanagia wĩra na inyuĩ na mamenyagĩrĩre Hema-ya-Gũtũnganwo, marutage wĩra wothe wa Hema ĩyo na gũtikagĩe na mũndũ ũngĩ o wothe ũngĩkuhĩrĩria harĩa mũrĩ. ");
INSERT INTO kik_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Nĩ wĩra wanyu kũmenyerera handũ hau haamũre o na kĩgongona, nĩguo mangʼũrĩ ma Jehova matikanakinyĩre andũ a Isiraeli rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Niĩ mwene nĩthuurĩte Alawii athiritũ anyu kuuma thĩinĩ wa andũ a Isiraeli matuĩke kĩheo kĩanyu, maamũrĩirwo Jehova nĩguo marutage wĩra wa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","No rĩrĩ, no wee na ariũ aku mũrĩĩtungataga ta athĩnjĩri-Ngai maũndũ-inĩ mothe ma kĩgongona, na mũtungatage o na mwena ũcio ũngĩ wa gĩtambaya kĩu gĩa kũhakania. Niĩ nĩndamũhe ũtungata wa ũthĩnjĩri-Ngai ta kĩheo. Mũndũ ũngĩ o wothe ũngĩkuhĩrĩria handũ hau haamũre no nginya ooragwo.” ");
INSERT INTO kik_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ningĩ Jehova akĩĩra Harũni atĩrĩ, “Niĩ mwene nĩngũtuĩte mũmenyereri wa maruta marĩa ndehagĩrwo; maruta mothe maamũre marĩa andũ a Isiraeli marĩndutagĩra nĩ ndakũhe wee na ariũ aku matuĩke gĩcunjĩ gĩaku na rũgai rwaku rwa mahinda mothe. ");
INSERT INTO kik_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Wee ũrĩheagwo gĩcunjĩ kĩa maruta marĩa maamũre mũno marĩa matarĩ ma gũcinwo na mwaki. Kuuma kũrĩ iheo ciothe iria andũ a Isiraeli marĩndutagĩra irĩ maruta maamũre mũno, marĩ ma mũtu, kana ma kũhoroherio mehia, kana maruta ma mahĩtia, gĩcunjĩ kĩu nĩ gĩaku na ciana ciaku. ");
INSERT INTO kik_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Rĩĩaga gĩcunjĩ kĩu ta kĩndũ kĩamũre mũno; mũndũ mũrũme o wothe wa nyũmba yaku nĩagakĩrĩĩaga. Wee no nginya ũtuage atĩ gĩcunjĩ kĩu nĩ kĩamũre. ");
INSERT INTO kik_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“O na ningĩ ici no ciaku: kĩrĩa gĩothe kĩamũrĩtwo kuuma iheo ciothe cia gũthũngũthio cia andũ a Isiraeli. Icio nĩndakũhe wee, na ariũ aku, na airĩtu aku, ituĩke rũgai rwaku rwa hĩndĩ ciothe. Mũndũ o wothe wa nyũmba yaku ũtarĩ na thaahu no acirĩe. ");
INSERT INTO kik_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Nĩndakũhe maguta mothe marĩa mega mũno ma mũtamaiyũ na ndibei yothe ĩrĩa njega mũno ya mũhihano, na ngano ĩrĩa maheaga Jehova ĩrĩ maciaro ma mbere ma magetha mao. ");
INSERT INTO kik_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Maciaro mothe ma bũrũri ma mbere marĩa marĩrehagĩra Jehova marĩtuĩkaga maku. Mũndũ o wothe wa nyũmba yaku ũtarĩ thaahu no amarĩe. ");
INSERT INTO kik_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Kĩndũ gĩothe kĩrĩ Isiraeli kĩrĩa kĩamũrĩirwo Jehova nĩ gĩaku. ");
INSERT INTO kik_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Marigithathi mothe, marĩ ma andũ kana ma nyamũ, marĩa marĩrutagĩrwo Jehova nĩ maku. No rĩrĩ, no nginya ũkũũrithagie irigithathi rĩothe rĩa kahĩĩ, na ũkũũrithagie irigithathi rĩa njamba rĩa nyamũ iria irĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Marigithathi macio marĩ ma mweri ũmwe, no nginya ũkaamakũũrithia na thogora wa gũkũũrana ũrĩa ũtuĩtwo wa cekeri ithano cia betha, kũringana na cekeri ya handũ-harĩa-haamũre, ĩrĩa ĩrĩ na ũritũ wa geera mĩrongo ĩĩrĩ. ");
INSERT INTO kik_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“No mũtikanakũũrithie marigithathi ma ndegwa, kana ma ngʼondu, kana ma mbũri; icio nĩ nyamũre. Thakame yacio nĩĩminjaminjagwo kĩgongona-inĩ igũrũ, na maguta ma cio macinwo na mwaki nĩguo matuĩke igongona rĩ na mũtararĩko wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Nyama ciacio nĩ ciaku, o ta ũrĩa gĩthũri kĩa igongona rĩa gũthũngũthio na kĩero kĩa ũrĩo irĩ ciaku. ");
INSERT INTO kik_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Kĩrĩa gĩothe kĩamũragĩrwo Jehova nĩ andũ a Isiraeli kĩrĩ kĩamũre nĩndakũhe wee mwene, na ariũ aku, na airĩtu aku, kĩrĩ rũgai rwaku rwa hĩndĩ ciothe. Nĩkĩo kĩrĩkanĩro gĩa tene na tene gĩa cumbĩ mbere ya Jehova kũrĩ wee na njiaro ciaku.” ");
INSERT INTO kik_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ningĩ Jehova akĩĩra Harũni atĩrĩ, “Wee ndũgakorwo na igai bũrũri-inĩ wao, kana ũgĩe na rũgai thĩinĩ wao; niĩ nĩ niĩ rũgai rwaku o na igai rĩaku thĩinĩ wa andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Nĩndahe Alawii icunjĩ ciothe cia ikũmi thĩinĩ wa Isiraeli, arĩ rĩo igai rĩao nĩ ũndũ wa wĩra ũrĩa marutaga rĩrĩa megũtungata Hema-inĩ-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Kuuma rĩu andũ a Isiraeli matigakuhagĩrĩrie Hema-ya-Gũtũnganwo, kana macookererwo nĩ mehia mao, nao makue. ");
INSERT INTO kik_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Alawii nĩo marĩrutaga wĩra Hema-inĩ-ya-Gũtũnganwo na nĩo marĩcookagĩrĩrwo nĩ mahĩtia marĩa meekĩirwo hau. Ũyũ nĩ watho wa gũtũũrio nĩ njiaro iria igooka. Matikagĩa na igai thĩinĩ wa andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Handũ ha ũguo-rĩ, ngũhe Alawii icunjĩ cia ikũmi iria andũ a Isiraeli marehaga irĩ maruta kũrĩ Jehova ituĩke igai rĩao. Nĩkĩo ndoigire igũrũ rĩao atĩrĩ: ‘Matikagĩa na igai thĩinĩ wa andũ a Isiraeli.’ ” ");
INSERT INTO kik_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Arĩria Alawii, ũmeere atĩrĩ: ‘Rĩrĩa mwamũkĩra icunjĩ cia ikũmi kuuma kũrĩ andũ a Isiraeli iria ndĩmũheete arĩ cio igai rĩanyu-rĩ, no nginya mũrehage gĩcunjĩ gĩa ikũmi gĩa gĩcunjĩ kĩu, kĩrĩ iruta kũrĩ Jehova. ");
INSERT INTO kik_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Maruta manyu marĩtuĩkaga ta ngano ĩrĩa ĩrutĩtwo kĩhuhĩro-inĩ, kana ndibei ĩrĩa ĩrutĩtwo kĩhihĩro-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ũguo nĩguo o na inyuĩ mũrĩrutagĩra Jehova iruta kuuma kũrĩ icunjĩ cia ikũmi iria mũrĩamũkagĩra ciumĩte kũrĩ andũ a Isiraeli. Kuuma kũrĩ icunjĩ icio cia ikũmi, no nginya mũnengagĩre Harũni mũthĩnjĩri-Ngai gĩcunjĩ kĩa Jehova. ");
INSERT INTO kik_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","No nginya mũkarutagĩra Jehova gĩcunjĩ kĩrĩa kĩega mũno na kĩrĩa kĩamũre mũno kĩa indo ciothe iria mũheetwo.’ ");
INSERT INTO kik_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Ĩra Alawii atĩrĩ, ‘Rĩrĩa mwaruta gĩcunjĩ kĩrĩa kĩega mũno-rĩ, kĩrĩtuĩkaga ta iruta rĩanyu riumĩte kĩhuhĩro-inĩ kĩa ngano kana kĩhihĩro-inĩ kĩa ndibei. ");
INSERT INTO kik_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Inyuĩ na andũ a nyũmba cianyu no mũrĩĩre icio ingĩ handũ o hothe, nĩgũkorwo ũcio nĩ mũcaara wanyu nĩ ũndũ wa wĩra wanyu kũu Hema-inĩ-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Nĩ ũndũ wa kũruta gĩcunjĩ kĩu kĩega mũno gĩacio, mũtigaatuĩrwo mahĩtia nĩ ũndũ wa ũndũ ũyũ; na ningĩ mũtigathaahia maruta marĩa maamũre ma andũ a Isiraeli, na nĩ ũndũ ũcio mũtigaakua.’ ” ");
INSERT INTO kik_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Ũndũ ũyũ nĩ wa kũrũmĩrĩrwo thĩinĩ wa watho ũrĩa Jehova aathanĩte: Ĩra andũ a Isiraeli makũrehere moori ndune ĩtarĩ kaũũgũ kana kameni, na ĩtarĩ yekĩrwo icooki. ");
INSERT INTO kik_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mũmĩnengere Eleazaru, ũrĩa mũthĩnjĩri-Ngai; ĩtwarwo nja ya kambĩ, na ĩthĩnjĩrwo hau mbere yake. ");
INSERT INTO kik_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Nake Eleazaru, ũcio mũthĩnjĩri-Ngai, oe thakame na kĩara gĩake, na amĩminjaminje maita mũgwanja amĩroretie na mwena wa mbere wa Hema-ya Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Nayo moori ĩyo ĩcinwo yothe akĩonaga, ũguo nĩ kuuga rũũa rwayo, na nyama, na thakame, o na taatha wayo. ");
INSERT INTO kik_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Mũthĩnjĩri-Ngai ũcio oe rũkũ rwa mũtarakwa, na mũthobi, na guoya wa rangi wa gakarakũ, aciikie igũrũ wa moori ĩyo ĩrahĩa. ");
INSERT INTO kik_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Thuutha wa ũguo mũthĩnjĩri-Ngai ũcio no nginya athambie nguo ciake na ethambe mwĩrĩ na maaĩ. Thuutha ũcio no acooke kambĩ, no arĩ na thaahu o nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Mũndũ ũrĩa ũrĩcinaga moori ĩyo no nginya athambie nguo ciake na ethambe mwĩrĩ na maaĩ, na o nake atiinde arĩ na thaahu nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Mũndũ ũtarĩ na thaahu acooke ahakũre mũhu ũcio wa moori ĩyo na aũige handũ hatarĩ na thaahu nja ya kambĩ. Mũhu ũcio ũigagwo nĩ kĩrĩndĩ kĩa andũ a Isiraeli, nĩgeetha ũhũthagĩrwo maaĩ-inĩ ma kũniina thaahu; ũcio nĩguo wa gũtheranagia kuuma mehia-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Mũndũ ũrĩa ũrĩhakũraga mũhu wa moori ĩyo, no nginya athambie nguo ciake, o nake atiinde arĩ na thaahu nginya hwaĩ-inĩ. Ũndũ ũyũ nĩ watho wa gũtũũra harĩ andũ a Isiraeli na ageni arĩa matũũranagia nao. ");
INSERT INTO kik_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Mũndũ ũrĩa ũngĩhutia kĩimba kĩa mũndũ o na ũrĩkũ arĩikaraga arĩ na thaahu mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","No nginya etherie na maaĩ mũthenya wa gatatũ, na mũthenya wa mũgwanja; hĩndĩ ĩyo athirwo nĩ thaahu. No angĩaga gwĩtheria mũthenya wa gatatũ na wa mũgwanja, ndagaathirwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Mũndũ o wothe ũngĩhutia kĩimba kĩa mũndũ o na ũrĩkũ na aage gwĩtheria, ũcio nĩathaahĩtie Hema-ĩrĩa-Nyamũre ya Jehova. Mũndũ ũcio no nginya aingatwo oime Isiraeli. Tondũ ndaminjaminjĩirio maaĩ ma kũniina thaahu, mũndũ ũcio arĩ na thaahu; thaahu wake ndũthirĩte. ");
INSERT INTO kik_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Ũyũ nĩguo watho wa kũrũmĩrĩrwo rĩrĩa mũndũ akuĩra hema-inĩ: Mũndũ o na ũrĩkũ ũngĩtoonya hema ĩyo, mũndũ o na ũrĩkũ ũrĩa ũgaakorwo thĩinĩ wayo-rĩ, nĩakanyiitwo nĩ thaahu mĩthenya mũgwanja, ");
INSERT INTO kik_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","nakĩo kĩndũ o gĩothe kĩa nyũmba gĩgaakorwo gĩtarĩ gĩkunĩke nĩgĩkanyiitwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Mũndũ o na ũrĩkũ ũrĩ na kũu nja ũngĩhutia mũndũ ũragĩtwo na rũhiũ rwa njora kana mũndũ ũkuĩte gĩkuũ kĩa ndũire, kana mũndũ o wothe ũngĩhutia ihĩndĩ rĩa mũndũ kana mbĩrĩra, ũcio nĩakanyiitwo nĩ thaahu mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Nĩ ũndũ wa mũndũ ũrĩ na thaahu, ĩkĩra mũhu wa moori ĩrĩa yacinĩtwo ĩrĩ ya gũtherania ndigithũ-inĩ, naguo ũitĩrĩrio maaĩ matahĩtwo o hĩndĩ ĩyo. ");
INSERT INTO kik_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Nake mũndũ ũtarĩ na thaahu nĩoe mũthobi aũtobokie maaĩ-inĩ macio, na aminjaminjĩrie hema ĩyo na indo ciayo ciothe, na andũ arĩa maarĩ kũu thĩinĩ. Ningĩ no nginya aminjaminjĩrie mũndũ ũrĩa wothe ũhutĩtie ihĩndĩ rĩa mũndũ, kana mbĩrĩra, kana mũndũ ũragĩtwo, kana mũndũ ũkuĩte gĩkuũ kĩa ndũire. ");
INSERT INTO kik_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Mũndũ ũrĩa ũtarĩ na thaahu nĩakaminjaminjĩria mũndũ ũcio ũrĩ na thaahu maaĩ macio mũthenya wa gatatũ na wa mũgwanja, naguo mũthenya wa mũgwanja nĩguo akamũtheria. Nake mũndũ ũcio ũgũtherio no nginya athambie nguo ciake na ethambe mwĩrĩ na maaĩ, naguo hwaĩ-inĩ ũcio nĩagakorwo athirĩtwo nĩ thaahu. ");
INSERT INTO kik_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","No rĩrĩ, mũndũ ũrĩ na thaahu angĩaga gwĩtheria, no nginya aingatwo kuuma kũrĩ kĩrĩndĩ, nĩ ũndũ nĩathaahĩtie handũ-harĩa-haamũre ha Jehova. Nĩgũkorwo ndaminjaminjĩirio maaĩ ma kũniina thaahu, nĩ ũndũ ũcio arĩ na thaahu. ");
INSERT INTO kik_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ũyũ nĩ watho wao wa gũtũũra. “Mũndũ ũcio wakũminjaminjanĩria maaĩ macio ma kũniina thaahu no nginya o nake athambie nguo ciake, na mũndũ o wothe ũngĩhutia maaĩ macio ma kũniina thaahu nĩagatinda arĩ na thaahu nginya hwaĩ-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kĩndũ gĩothe mũndũ ũrĩ na thaahu akaahutia nĩgĩkanyiitwo nĩ thaahu, na mũndũ ũrĩa ũngĩhutia kĩndũ kĩu nĩagatinda arĩ na thaahu nginya hwaĩ-inĩ.” ");
INSERT INTO kik_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Na rĩrĩ, mweri wa mbere, kĩrĩndĩ gĩothe kĩa andũ a Isiraeli gĩgĩkinya kũu Werũ-inĩ wa Zini, na gĩgĩikara Kadeshi. Nake Miriamu agĩkuĩra kũu na agĩthikwo o ro kuo. ");
INSERT INTO kik_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Na rĩrĩ, handũ hau hatiarĩ maaĩ ma kũnyuuo nĩ kĩrĩndĩ, nao andũ acio makĩũngana, magĩũkĩrĩra Musa na Harũni. ");
INSERT INTO kik_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Makĩnegenia Musa, makiuga atĩrĩ, “Naarĩ korwo nĩtwakuire rĩrĩa ariũ a ithe witũ maakuire marĩ mbere ya Jehova! ");
INSERT INTO kik_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Nĩ kĩĩ gĩatũmire mũrehe kĩrĩndĩ kĩa Jehova werũ-inĩ ũyũ, nĩguo ithuĩ na mahiũ maitũ tũkuĩre gũkũ? ");
INSERT INTO kik_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Mwatũrutire bũrũri wa Misiri nĩkĩ, mũgĩtũrehe kũndũ gũkũ kũũru ũũ? Gũkũ gũtirĩ ngano kana ngũyũ, kana thabibũ, kana makomamanga. O na gũtirĩ maaĩ ma kũnyua!” ");
INSERT INTO kik_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa na Harũni makiuma hau kĩungano kĩarĩ, magĩthiĩ nginya o itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo makĩĩgũithia na magĩturumithia mothiũ mao thĩ, naguo riiri wa Jehova ũkĩmoimĩrĩra. ");
INSERT INTO kik_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Oya rũthanju rwaku, nawe na mũrũ wa nyũkwa Harũni mũcokanĩrĩrie kĩrĩndĩ kĩu hamwe. Arĩria rwaro rũrũ rwa ihiga makwĩroreire, na nĩrũkuuma maaĩ. Nawe ũrutĩre kĩrĩndĩ maaĩ rwaro-inĩ rũrũ rwa ihiga, nĩgeetha kĩnyue hamwe na mahiũ ma kĩo.” ");
INSERT INTO kik_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Nĩ ũndũ ũcio Musa akĩoya rũthanju akĩrũruta hau mbere ya Jehova, o ta ũrĩa Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Nake Musa na Harũni magĩcokanĩrĩria kĩrĩndĩ kĩu hamwe hau mbere ya rwaro rwa ihiga, na Musa akĩmeera atĩrĩ, “Ta thikĩrĩriai, inyuĩ aremi aya, no nginya tũmũrutĩre maaĩ kuuma rwaro-inĩ rũrũ rwa ihiga?” ");
INSERT INTO kik_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Musa agĩcooka akĩoya guoko gwake na igũrũ, akĩgũtha rwaro rũu rwa ihiga na rũthanju rwake maita meerĩ. Maaĩ makĩbororoka, nakĩo kĩrĩndĩ kĩu gĩkĩnyua, o na mahiũ makĩo makĩnyua. ");
INSERT INTO kik_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","No Jehova akĩĩra Musa na Harũni atĩrĩ, “Tondũ mũtinanjĩtĩkia nĩguo muonanie atĩ niĩ ndĩ mũtheru, mũtũme heo gĩtĩĩo maitho-inĩ ma andũ a Isiraeli, inyuĩ mũtigaakinyia kĩrĩndĩ gĩkĩ bũrũri ũrĩa ndĩmaheete.” ");
INSERT INTO kik_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Macio nĩmo maarĩ maaĩ ma Meriba, kũrĩa andũ a Isiraeli maatetanirie na Jehova na kũrĩa eyonanirie atĩ nĩ mũtheru thĩinĩ wao. ");
INSERT INTO kik_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Musa agĩtũma andũ kuuma Kadeshi mathiĩ kũrĩ mũthamaki wa Edomu, makamwĩre atĩrĩ: “Mũrũ wa nyũkwa Isiraeli oiga atĩrĩ: Wee nĩũũĩ mathĩĩna marĩa mothe tũkoretwo namo. ");
INSERT INTO kik_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Maithe maitũ ma tene nĩmaikũrũkire magĩthiĩ bũrũri wa Misiri, na ithuĩ tũgĩtũũra kuo mĩaka mĩingĩ. Andũ a Misiri nĩmatũhiinyĩrĩirie mũno ithuĩ ene o na maithe maitũ, ");
INSERT INTO kik_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","no rĩrĩa twakaĩire Jehova-rĩ, nĩaiguire kĩrĩro giitũ nake agĩtũma mũraika agĩtũruta kũu bũrũri wa Misiri. “Na rĩu tũrĩ gũkũ Kadeshi, itũũra rĩrĩa rĩ mũthia-inĩ wa bũrũri waku. ");
INSERT INTO kik_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ndagũthaitha ũtwĩtĩkĩrie tũtuĩkanĩrie bũrũri waku. Tũtikũgerera mĩgũnda-inĩ ya irio, kana ya mĩthabibũ, kana tũnyue maaĩ ma gĩthima o na kĩmwe. Tũkũgerera njĩra ĩrĩa nene ya mũthamaki, na tũtigũkerũra na mwena wa ũrĩo o na kana wa ũmotho, o nginya tũtuĩkanie bũrũri waku.” ");
INSERT INTO kik_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","No Edomu akĩmũcookeria atĩrĩ: “Ndũgũtuĩkanĩria gũkũ; na ũngĩgeria-rĩ, tũkuumagara tũmũtharĩkĩre na rũhiũ rwa njora.” ");
INSERT INTO kik_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Andũ a Isiraeli acio makĩmũcookeria atĩrĩ, “Ithuĩ tũkũgerera o njĩra ĩrĩa nene, na ithuĩ ene kana mahiũ maitũ tũngĩnyua maaĩ manyu-rĩ, nĩtũkũrĩha. Tũrenda o tũtuĩkanie tũthiĩte na magũrũ tu hatarĩ ũndũ ũngĩ.” ");
INSERT INTO kik_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ningĩ Edomu agĩcookia atĩrĩ: “Aca, mũtigũtuĩkanĩria gũkũ.” Hĩndĩ ĩyo Edomu akiumagara akamatharĩkĩre, arĩ mbũtũ nene ĩna hinya mũingĩ. ");
INSERT INTO kik_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Tondũ Edomu ndaametĩkĩririe matuĩkanĩrie bũrũri wao-rĩ, andũ a Isiraeli makĩhũndũka, magĩtigana nao. ");
INSERT INTO kik_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kĩrĩndĩ gĩothe kĩa andũ a Isiraeli gĩkiuma kũu Kadeshi na magĩkinya Kĩrĩma-inĩ kĩa Horu. ");
INSERT INTO kik_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Marĩ kũu Kĩrĩma-inĩ kĩa Horu, hakuhĩ na mũhaka wa Edomu, Jehova akĩĩra Musa na Harũni atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Rĩu Harũni nĩegũkua. Ndegũtoonya bũrũri ũrĩa ngũhe andũ a Isiraeli, nĩ ũndũ inyuĩ eerĩ nĩmwaremeire watho wakwa kũu maaĩ-inĩ ma Meriba. ");
INSERT INTO kik_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Oya Harũni na mũriũ Eleazaru, ũmatware Kĩrĩma-igũrũ kĩa Horu. ");
INSERT INTO kik_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ũrute Harũni nguo ciake, ũcihumbe mũriũ Eleazaru, nĩ ũndũ Harũni nĩegũkua, na egũkuĩra o ro kũu.” ");
INSERT INTO kik_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa agĩĩka o ta ũrĩa Jehova aamwathĩte; makĩambata Kĩrĩma-inĩ kĩa Horu makĩonagwo nĩ kĩrĩndĩ kĩu gĩothe. ");
INSERT INTO kik_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Musa akĩruta Harũni nguo ciake, agĩcihumba mũriũ Eleazaru. Nake Harũni agĩkuĩra kũu kĩrĩma igũrũ. Nake Musa na Eleazaru magĩikũrũka makiuma kũu kĩrĩma igũrũ, ");
INSERT INTO kik_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","na rĩrĩa kĩrĩndĩ kĩu kĩamenyire atĩ Harũni nĩakuĩte, andũ othe a nyũmba ya Isiraeli makĩmũcakaĩra mĩthenya mĩrongo ĩtatũ. ");
INSERT INTO kik_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Na rĩrĩ, rĩrĩa mũthamaki Mũkaanani wa Aradi, ũrĩa watũũraga Negevu, aiguire atĩ Isiraeli nĩokagĩra njĩra ya Atharimu, agĩthiĩ agĩtharĩkĩra andũ a Isiraeli, na agĩtaha amwe ao. ");
INSERT INTO kik_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Nao andũ Isiraeli makĩĩhĩta na mwĩhĩtwa ũyũ harĩ Jehova makiuga atĩrĩ: “Ũngĩneana andũ aya moko-inĩ maitũ-rĩ, nĩtũkananga matũũra mao marĩa manene biũ.” ");
INSERT INTO kik_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Nake Jehova akĩigua ihooya rĩa andũ a Isiraeli na akĩneana andũ acio a Kaanani kũrĩ o. Nao makĩananga andũ acio biũ hamwe na matũũra mao; nĩ ũndũ ũcio handũ hau hagĩĩtwo Horoma. ");
INSERT INTO kik_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Nao andũ a Isiraeli makĩnyiita rũgendo kuuma Kĩrĩma kĩa Horu magereire njĩra ya gũthiĩ Iria Itune, nĩguo mathiũrũrũke bũrũri wa Edomu. No andũ acio magĩthethũka marĩ njĩra-inĩ; ");
INSERT INTO kik_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","nao magĩũkĩrĩra Ngai o na Musa na mĩario makiuga atĩrĩ, “Mwatũrutire bũrũri wa Misiri tũũke tũkuĩre gũkũ werũ-inĩ nĩkĩ? Gũkũ gũtirĩ irio! Na gũtirĩ maaĩ! O na nĩtũthũire irio ici itarĩ kĩene!” ");
INSERT INTO kik_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Nake Jehova akĩmatũmĩra nyoka ciarĩ na thumu; ikĩrũma andũ a Isiraeli, na aingĩ ao magĩkua. ");
INSERT INTO kik_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Andũ acio magĩthiĩ kũrĩ Musa makĩmwĩra atĩrĩ, “Nĩtwehirie rĩrĩa twaaririe tũgĩũkĩrĩra Jehova hamwe nawe. Hooya nĩguo Jehova atwehererie nyoka ici.” Nĩ ũndũ ũcio Musa akĩhoera andũ acio. ");
INSERT INTO kik_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Nake Jehova akĩĩra Musa atĩrĩ, “Thondeka nyoka ũmĩcuurie gĩtugĩ igũrũ; mũndũ o wothe ũrĩĩrũmagwo-rĩ, aamĩrora nĩarĩtũũraga muoyo.” ");
INSERT INTO kik_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Nĩ ũndũ ũcio Musa agĩthondeka nyoka ya gĩcango, akĩmĩcuuria gĩtugĩ igũrũ. Na rĩrĩ, hĩndĩ ĩrĩa mũndũ o wothe aarũmwo nĩ nyoka na aarora nyoka ĩyo ya gĩcango, agatũũra muoyo. ");
INSERT INTO kik_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Andũ a Isiraeli makiumagara, magĩthiĩ makĩamba hema ciao Obothu. ");
INSERT INTO kik_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ningĩ makiuma Obothu magĩthiĩ Iye-Abarimu, makĩamba hema ciao werũ-inĩ ũrĩa ũngʼethanĩire na Moabi mwena wa irathĩro. ");
INSERT INTO kik_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kuuma kũu magĩthiĩ na mbere, makĩamba hema ciao Kĩanda kĩa Zeredi. ");
INSERT INTO kik_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Moimagara kuuma kũu makĩamba hema kũrigania na Rũũĩ rwa Arinoni, kũu werũ ũrĩa ũthiĩte nginya bũrũri wa Aamori; nĩgũkorwo Rũũĩ rwa Arinoni nĩruo rwarĩ mũhaka wa Moabi na Aamori. ");
INSERT INTO kik_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Na nĩkĩo Ibuku rĩa Mbaara cia Jehova riugĩte atĩrĩ: “ … Wahebu thĩinĩ wa Sufa, na mĩkuru, Arinoni ");
INSERT INTO kik_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","na igaragaro-inĩ cia mĩkuru ĩrĩa ithiĩte o nginya kũu Ari, na ĩgatwarana na mũhaka wa Moabi.” ");
INSERT INTO kik_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Kuuma kũu magĩthiĩ na mbere nginya kũu Biri, gĩthima-inĩ harĩa Jehova erire Musa atĩrĩ, “Cookereria andũ hamwe na nĩngũmahe maaĩ.” ");
INSERT INTO kik_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Hĩndĩ ĩyo Isiraeli makĩina rwĩmbo rũrũ: “Therũka maaĩ, wee gĩthima gĩkĩ! Inyuĩ na inyuĩ inai ũhoro wakĩo, ");
INSERT INTO kik_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ũhoro wa gĩthima kĩrĩa anene menjete, kĩrĩa gĩathikũririo nĩ andũ arĩa marĩ igweta, andũ arĩa marĩ igweta marĩ na njũgũma cia ũnene na mĩthĩĩgi yao.” Ningĩ makiuma werũ-inĩ magĩthiĩ Matana, ");
INSERT INTO kik_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kuuma Matana magĩthiĩ Nahalieli, kuuma Nahalieli magĩthiĩ Bamothu, ");
INSERT INTO kik_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","na kuuma Bamothu magĩthiĩ kĩanda kĩa Moabi, kũrĩa gacũmbĩrĩ ka Pisiga kangʼetheire werũ ũrĩa ũtarĩ kĩndũ. ");
INSERT INTO kik_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isiraeli nĩatũmire andũ kũrĩ Sihoni mũthamaki wa Aamori makamwĩre atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Twĩtĩkĩrie tũtuĩkanĩrie bũrũri wanyu. Tũtigũtoonya mĩgũnda yanyu ya irio, kana ya mĩthabibũ, kana tũnyue maaĩ kuuma gĩthima o na kĩmwe. Tũkũgerera njĩra ĩrĩa nene ya mũthamaki o nginya tũtuĩkanie bũrũri wanyu.” ");
INSERT INTO kik_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","No Mũthamaki Sihoni akĩgiria andũ a Isiraeli mahĩtũkĩre bũrũri wake. We onganirie mbũtũ ciake ciothe cia ita, akiumagara agĩthiĩ werũ-inĩ agatharĩkĩre andũ a Isiraeli. Rĩrĩa aakinyire Jahazu-rĩ, akĩhũũrana na andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","No andũ a Isiraeli makĩmooraga na hiũ cia njora na magĩtunya mũthamaki ũcio bũrũri wake kuuma Arinoni nginya Jaboku, no maakinyire o mũhaka-inĩ wa andũ a Amoni, tondũ warĩ mũirige na hinya mũno. ");
INSERT INTO kik_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isiraeli agĩtunya Aamori matũũra mothe mao marĩa manene na magĩtũũra kuo, o hamwe na Heshiboni na tũtũũra tuothe tũrĩa twarigainie nakuo. ");
INSERT INTO kik_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshiboni nĩrĩo rĩarĩ itũũra inene rĩa Sihoni mũthamaki wa Aamori, ũrĩa warũĩte na mũthamaki wa Moabi ũrĩa waathanaga mbere ĩyo, na akamũtunya bũrũri wake wothe o nginya Arinoni. ");
INSERT INTO kik_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Kĩu nĩkĩo gĩtũmaga aini a marebeta moige atĩrĩ: “Ũkaai Heshiboni nĩgeetha rĩakwo rĩngĩ; itũũra inene rĩa Sihoni nĩrĩcokererio. ");
INSERT INTO kik_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Mwaki nĩwoimire kũu Heshiboni, rũrĩrĩmbĩ rũkiuma itũũra inene rĩa Sihoni. Ũkĩniina itũũra rĩa Ari Moabi, o atũũri a kũrĩa gũtũũgĩru kwa Arinoni. ");
INSERT INTO kik_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Kaĩ ũrĩ na haaro, wee Moabi-ĩ! Inyuĩ andũ a Kemoshu! Kaĩ mũrĩ aanange-ĩ. Nĩarekereirie ariũ ake magatuĩka eethari, o na airĩtu ake akĩmarekereria matahwo nĩ Sihoni mũthamaki wa Aamori. ");
INSERT INTO kik_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“No ithuĩ nĩtũmangʼaũranĩtie; Heshiboni kwanangĩtwo guothe nginya o Diboni. Tũmamomorete tũgakinya Nofa, itũũra rĩrĩa rĩkuhanĩrĩirie na Medeba.” ");
INSERT INTO kik_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nĩ ũndũ ũcio andũ a Isiraeli magĩtũũra bũrũri ũcio wa Aamori. ");
INSERT INTO kik_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Thuutha wa Musa gũtũma andũ magathigaane Jazeri, andũ a Isiraeli magĩtunyana tũtũũra tũrĩa twarigiicĩirie itũũra rĩu, na makĩingata Aamori arĩa maarĩ kuo. ");
INSERT INTO kik_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ningĩ makĩgarũrũka, makĩambata na njĩra marorete Bashani, nake Ogu mũthamaki wa Bashani na mbũtũ ciake ciothe cia ita makiumagara makahũũrane na Isiraeli kũu Edirei. ");
INSERT INTO kik_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Nake Jehova akĩĩra Musa atĩrĩ, “Ndũkamwĩtigĩre, nĩ ũndũ nĩndĩmũneanĩte moko-inĩ maku, hamwe na mbũtũ ciake ciothe cia ita, o na bũrũri wake. Mwĩke o ũrĩa wekire Sihoni mũthamaki wa Aamori, ũrĩa waathanaga Heshiboni.” ");
INSERT INTO kik_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Nĩ ũndũ ũcio makĩũraga Mũthamaki Ogu hamwe na ariũ ake, o na mbũtũ ciake ciothe cia ita, mategũtigia mũndũ o na ũmwe muoyo. Nao andũ a Isiraeli makĩĩgwatĩra bũrũri wake. ");
INSERT INTO kik_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Ningĩ andũ a Isiraeli makĩnyiita rũgendo marorete werũ wa Moabi na makĩamba hema ciao hũgũrũrũ-inĩ cia Rũũĩ rwa Jorodani mũrĩmo wa itũũra rĩa Jeriko. ");
INSERT INTO kik_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Na rĩrĩ, Balaki mũrũ wa Ziporu nĩonete maũndũ marĩa mothe Isiraeli meekĩte Aamori, ");
INSERT INTO kik_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","nao andũ a Moabi magĩĩtigĩra mũno nĩ ũndũ nĩ kwarĩ na andũ aingĩ mũno. Ti-itherũ, andũ a Moabi maiyũrĩtwo nĩ guoya nĩ ũndũ wa andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Andũ a Moabi makĩĩra athuuri a Midiani atĩrĩ, “Mũingĩ ũyũ ũkũrĩa indo ciothe iria itũrigiicĩirie, o ta ũrĩa ndegwa ĩrĩĩaga nyeki ya gĩthaka.” Nĩ ũndũ ũcio Balaki mũrũ wa Ziporu, ũrĩa warĩ mũthamaki wa Moabi ihinda rĩu, ");
INSERT INTO kik_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","agĩtũmanĩra Balamu mũrũ wa Beori, ũrĩa warĩ Pethori, hakuhĩ na Rũũĩ rwa Farati, kũu bũrũri wao. Balaki akĩmwĩra atĩrĩ: “Harĩ na andũ mokĩte moimĩte bũrũri wa Misiri; nao maiyũrĩte bũrũri ũyũ wothe, na maikarĩte o hakuhĩ na niĩ. ");
INSERT INTO kik_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ndagũthaitha ũka ũnumĩre andũ aya manyiitwo nĩ kĩrumi, nĩ ũndũ marĩ na hinya mũno kũngĩra. Ũngĩmaruma kwahoteka ndĩmahoote na ndĩmarutũrũre moime bũrũri ũyũ. Nĩ ũndũ nĩnjũũĩ atĩ arĩa warathima nĩmarathimagwo, nao arĩa waruma nĩ manyiitagwo nĩ kĩrumi.” ");
INSERT INTO kik_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Nao athuuri a Moabi na a Midiani magĩthiĩ makuuĩte irĩhi rĩa kũragũrĩrwo. Maakinya kũrĩ Balamu, makĩmũhe ũhoro ũrĩa Balaki oigĩte. ");
INSERT INTO kik_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Nake Balamu akĩmeera atĩrĩ, “Raraai gũkũ ũmũthĩ, na nĩngamũcookeria macookio marĩa Jehova ekũhe.” Nĩ ũndũ ũcio anene a Moabi makĩraarania nake. ");
INSERT INTO kik_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Nake Ngai agĩkora Balamu akĩmũũria atĩrĩ, “Andũ aya mũrĩ nao nĩ a?” ");
INSERT INTO kik_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balamu agĩcookeria Ngai atĩrĩ, “Balaki mũrũ wa Ziporu, mũthamaki wa Moabi, nĩwe ũrandeheire ndũmĩrĩri ĩno: ");
INSERT INTO kik_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Kũrĩ andũ moimĩte bũrũri wa Misiri makaiyũra bũrũri ũyũ wothe. Ndagũthaitha ũũke ũnumĩre o manyiitwo nĩ kĩrumi, no gũkorwo no hũũrane nao ndĩmaingate moime bũrũri ũyũ!’ ” ");
INSERT INTO kik_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","No Ngai akĩĩra Balamu atĩrĩ, “Ndũgũthiĩ nao. Ndũkarume andũ acio, tondũ nĩ andũ arathime.” ");
INSERT INTO kik_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Rũciinĩ rũrũ rũngĩ, Balamu agĩũkĩra, akĩĩra anene acio a Balaki atĩrĩ, “Cookai bũrũri wanyu kĩũmbe, nĩ ũndũ Jehova nĩarega kũnjĩtĩkĩria tũthiĩ na inyuĩ.” ");
INSERT INTO kik_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Nĩ ũndũ ũcio anene a Moabi magĩcooka kũrĩ Balaki makĩmwĩra atĩrĩ, “Balamu nĩarega gũũka na ithuĩ.” ");
INSERT INTO kik_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ningĩ Balaki agĩtũma anene angĩ aingĩ makĩria na maarĩ igweta gũkĩra acio a mbere. ");
INSERT INTO kik_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Nao magĩthiĩ kũrĩ Balamu makĩmwĩra atĩrĩ: “Ũũ nĩguo Balaki mũrũ wa Ziporu ekuuga: Ndũgetĩkĩre ũndũ o na ũrĩkũ ũgirie ũũke kũrĩ niĩ, ");
INSERT INTO kik_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","tondũ nĩngũkũrĩha wega mũno, na njĩke ũrĩa wothe ũngiuga. Ndagũthaitha ũka ũnumĩre andũ aya.” ");
INSERT INTO kik_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","No Balamu akĩmacookeria atĩrĩ, “O na Balaki angĩĩhe nyũmba yake ya ũnene ĩiyũrĩtio betha na thahabu-rĩ, ndingĩĩka ũndũ o na ũrĩkũ, mũnene kana mũnini, wagararĩte watho wa Jehova Ngai wakwa. ");
INSERT INTO kik_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Na rĩrĩ, raraai gũkũ ũmũthĩ, o ta ũrĩa acio angĩ mareekire, na nĩngũtuĩria ũndũ ũrĩa ũngĩ Jehova ekũnjĩĩra.” ");
INSERT INTO kik_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ũtukũ ũcio Ngai nĩakorire Balamu, akĩmwĩra atĩrĩ, “Tondũ andũ aya nĩ mokĩte gũgwĩta, thiĩ nao, no wĩke o ũrĩa wiki ngũkwĩra.” ");
INSERT INTO kik_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balamu agĩũkĩra rũciinĩ, agĩtandĩka ndigiri yake, na agĩthiĩ na anene acio a Moabi. ");
INSERT INTO kik_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","No Ngai nĩarakarire mũno athiĩ, na mũraika wa Jehova akĩrũgama njĩra nĩguo amũgirĩrĩrie gũthiĩ. Balamu aahaicĩte ndigiri yake, na ndungata ciake igĩrĩ ciarĩ hamwe nake. ");
INSERT INTO kik_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Na rĩrĩa ndigiri yoonire mũraika wa Jehova arũngiĩ njĩra, acomorete rũhiũ rwa njora, na arũnyiitĩte na guoko, ĩkĩgarũrũka, ĩgĩtoonya mũgũnda. Nake Balamu akĩmĩhũũra nĩguo ĩcooke njĩra. ");
INSERT INTO kik_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Nake mũraika wa Jehova akĩrũgama njĩra-inĩ yarĩ njeke gatagatĩ ka mĩgũnda ĩĩrĩ ya mĩthabibũ, na o mũgũnda warĩ mũirige. ");
INSERT INTO kik_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Rĩrĩa ndigiri yoonire mũraika wa Jehova-rĩ, ĩkĩĩhatĩrĩria rũthingo-inĩ, ĩkĩhinyĩrĩria kũgũrũ kwa Balamu rũthingo-inĩ rũu. Nĩ ũndũ ũcio akĩmĩhũũra rĩngĩ. ");
INSERT INTO kik_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ningĩ mũraika wa Jehova agĩthiĩ mbere akĩrũgama handũ haarĩ haceke hataarĩ na handũ ha kwĩgarũrĩra, na mwena wa ũrĩo kana wa ũmotho. ");
INSERT INTO kik_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Rĩrĩa ndigiri yoonire mũraika wa Jehova hau, ĩgĩkoma thĩ Balamu arĩ o igũrũ rĩayo, nake akĩrakara akĩmĩhũũra na rũthanju rwake. ");
INSERT INTO kik_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Nake Jehova agĩtumũra kanua ka ndigiri, nayo ĩkĩũria Balamu atĩrĩ, “Nĩatĩa ngwĩkĩte tondũ wahũũra maita maya matatũ?” ");
INSERT INTO kik_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balamu akĩmĩcookeria atĩrĩ, “Wee ũnduĩte kĩrimũ! Korwo nyuma na rũhiũ rwa njora guoko-inĩ, ingĩakũraga o ro rĩu.” ");
INSERT INTO kik_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Nayo ndigiri ĩkĩũria Balamu atĩrĩ, “Githĩ niĩ ti niĩ ndigiri yaku, ĩrĩa ũtũire ũhaicaga nginya ũmũthĩ? Nĩmenyerete gũgwĩka ta ũũ?” Balamu akiuga atĩrĩ, “Aca.” ");
INSERT INTO kik_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Nake Jehova akĩhingũra maitho ma Balamu, nake akĩona mũraika wa Jehova arũngiĩ njĩra-inĩ acomorete rũhiũ rwa njora. Nĩ ũndũ ũcio akĩinamĩrĩra na akĩĩgũithia, agĩturumithia ũthiũ wake thĩ. ");
INSERT INTO kik_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mũraika wa Jehova akĩmũũria atĩrĩ, “Nĩ kĩĩ gĩatũma ũhũũre ndigiri yaku maita macio matatũ? Njũkĩte haha ngũhingĩrĩrie nĩ ũndũ mĩthiĩre yaku nĩ ya ũremi maitho-inĩ makwa. ");
INSERT INTO kik_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ndigiri ĩnyonire, yanjeherera maita macio matatũ. Korwo ndĩnanjeherera, hatirĩ nganja nĩingĩgũkũũragĩte, no yo nĩingĩamĩhonokia.” ");
INSERT INTO kik_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balamu akĩĩra mũraika ũcio wa Jehova atĩrĩ, “Nĩnjĩhĩtie. Ndikũũĩ atĩ nĩũkũrũgamĩte njĩra-inĩ ũhingĩrĩirie. Na rĩrĩ, ũngĩkorwo ndũkenete-rĩ, nĩngũhũndũka.” ");
INSERT INTO kik_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mũraika ũcio wa Jehova akĩĩra Balamu atĩrĩ, “Thiĩ na andũ acio, no uuge o ro ũrĩa ngũkwĩra.” Nĩ ũndũ ũcio Balamu agĩthiĩ na anene acio a Balaki. ");
INSERT INTO kik_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Rĩrĩa Balaki aiguire atĩ Balamu nĩarooka, agĩthiĩ kũmũtũnga itũũra-inĩ rĩa Moabi, mũhaka-inĩ wa Arinoni, o kũu mũhaka wa bũrũri wake. ");
INSERT INTO kik_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaki akĩũria Balamu atĩrĩ, “Githĩ ndiagũtũmanĩire ũũke narua? Nĩ kĩĩ kĩagiririe ũũke? Anga ndingĩhota gũkũrĩha?” ");
INSERT INTO kik_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balamu agĩcookia atĩrĩ, “Nĩ wega, nĩndagĩũka. No rĩrĩ, niĩ no njuge o ũrĩa ngwenda? Niĩ ngwaria o ũrĩa Ngai angĩnjĩĩra njarie.” ");
INSERT INTO kik_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Hĩndĩ ĩyo Balamu na Balaki magĩthiĩ Kiriathu-Huzothu. ");
INSERT INTO kik_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaki akĩruta igongona rĩa ngʼombe na ngʼondu, na akĩhe Balamu na anene arĩa maarĩ nake nyama imwe. ");
INSERT INTO kik_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kwarooka gũkĩa-rĩ, Balaki akĩoya Balamu makĩambata nginya Bamothu-Baali, na marĩ kũu Balamu akĩona gĩcunjĩ kĩmwe kĩa andũ acio. ");
INSERT INTO kik_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Nake Balamu akĩĩra Balaki atĩrĩ, “Njakĩra igongona mũgwanja haha, na ũhaarĩrie ndegwa mũgwanja na ndũrũme mũgwanja.” ");
INSERT INTO kik_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki agĩĩka o ũrĩa Balamu oigĩte, na igũrũ rĩa o kĩgongona-inĩ makarutĩra igongona rĩa ndegwa ĩmwe na ndũrũme ĩmwe. ");
INSERT INTO kik_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ningĩ Balamu akĩĩra Balaki atĩrĩ, “Wee ikara haha hakuhĩ na iruta rĩaku nyambe thiĩ keheri-inĩ. Hihi Jehova nĩegũũka acemanie na niĩ. Ũndũ ũrĩa wothe ekũnguũrĩria nĩngũkwĩra.” Nake agĩthiĩ handũ hatheri hatũũgĩru. ");
INSERT INTO kik_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ngai agĩcemania nake hau, nake Balamu akĩmwĩra atĩrĩ, “Nĩhaarĩirie igongona mũgwanja, na o kĩgongona-inĩ ngaruta ndegwa ĩmwe na ndũrũme ĩmwe.” ");
INSERT INTO kik_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Nake Jehova agĩĩkĩra ndũmĩrĩri yake kanua ka Balamu, akĩmwĩra atĩrĩ, “Cooka kũrĩ Balaki ũmũhe ndũmĩrĩri ĩno.” ");
INSERT INTO kik_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Tondũ ũcio Balamu agĩcooka kũrĩ Balaki, akĩmũkora arũngiĩ hakuhĩ na igongona rĩake, marĩ hamwe na anene othe a Moabi. ");
INSERT INTO kik_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Nake Balamu akĩaria ndũmĩrĩri yake, akiuga atĩrĩ: “Balaki andehithĩtie kuuma bũrũri wa Aramu, mũthamaki wa Moabi akanduta kuuma irĩma-inĩ cia mwena wa irathĩro. Akoiga atĩrĩ, ‘Ũka ũnumĩre Jakubu; ũka ũthitange Isiraeli.’ ");
INSERT INTO kik_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ndaakĩhota atĩa kũruma arĩa Ngai atarumĩte? Ndaakĩhota atĩa gũthitanga arĩa Jehova atathitangĩte? ");
INSERT INTO kik_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kuuma tũcũmbĩrĩ twa ndwaro cia mahiga nĩndĩramoona, kuuma kũrĩa gũtũũgĩru nĩndĩramoona. Ndĩrona andũ matũũraga meikarĩtie, nao matiĩtaraga atĩ o nĩ amwe a ndũrĩrĩ. ");
INSERT INTO kik_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Nũũ ũngĩhota gũtara rũkũngũ rwa Jakubu, kana atare gĩcunjĩ kĩa inya kĩa Isiraeli? Rekei ngue gĩkuũ kĩa arĩa athingu, na marigĩrĩrio makwa-rĩ, marotuĩka ta mao!” ");
INSERT INTO kik_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaki akĩũria Balamu atĩrĩ, “Wanjĩka atĩa? Ngũrehire ũnumĩre thũ ciakwa, no ndũrĩ ũreka ũndũ o tiga kũmarathima!” ");
INSERT INTO kik_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balamu akĩmũũria atĩrĩ, “Githĩ ndiagĩrĩirwo njarie o kĩrĩa Jehova ekĩrĩte kanua-inĩ gakwa?” ");
INSERT INTO kik_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ningĩ Balaki akĩmwĩra atĩrĩ, “Ũka tũthiĩ nawe handũ hangĩ harĩa ũkũmoona; ũkũmoona o gĩcunjĩ kĩmwe kĩao, no ti othe hamwe. Na ũrĩ hau ũnumĩre andũ acio.” ");
INSERT INTO kik_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Nĩ ũndũ ũcio akĩmũtwara gĩthaka-inĩ gĩa Zofimu, gacũmbĩrĩ ga Kĩrĩma kĩa Pisiga, naho hau agĩaka igongona mũgwanja, na o kĩgongona-inĩ agĩthĩnjĩra ndegwa ĩmwe na ndũrũme ĩmwe. ");
INSERT INTO kik_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balamu akĩĩra Balaki atĩrĩ, “Wee ikara haha hakuhĩ na iruta rĩaku nyambe thiĩ ngacemanie nake haarĩa.” ");
INSERT INTO kik_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Jehova agĩcemania na Balamu, agĩĩkĩra ndũmĩrĩri kanua gake, akĩmwĩra atĩrĩ, “Cooka kũrĩ Balaki ũmũhe ndũmĩrĩri ĩno.” ");
INSERT INTO kik_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Tondũ ũcio Balamu agĩcooka kũrĩ Balaki na akĩmũkora arũngiĩ hakuhĩ na iruta rĩake, marĩ hamwe na anene a Moabi. Balaki akĩmũũria atĩrĩ, “Jehova oiga atĩa?” ");
INSERT INTO kik_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balamu agĩcooka akĩaria ndũmĩrĩri yake, akiuga atĩrĩ: “Arahũka, wee Balaki na ũigue; Thikĩrĩria, wee mũrũ wa Ziporu. ");
INSERT INTO kik_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Ngai ti mũndũ, atĩ nĩguo aheenanie, o na ti mũrũ wa mũndũ, atĩ nĩguo ericũkwo. No oige ũndũ na ndawĩĩke? No eranĩre ũndũ na ndaũhingie? ");
INSERT INTO kik_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Niĩ njathĩtwo ndathimane; nake arathimanĩte-rĩ, ndingĩhota kũgarũra ũndũ ũcio. ");
INSERT INTO kik_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Gũtirĩ mũtino wonekete harĩ Jakubu, gũtirĩ ihooru rĩonetwo thĩinĩ wa Isiraeli. Jehova Ngai wao arĩ hamwe nao; kayũ ka mũthamaki karĩ thĩinĩ wao. ");
INSERT INTO kik_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Ngai nĩamarutire bũrũri wa Misiri; marĩ na hinya o ta ndegwa ya gĩthaka. ");
INSERT INTO kik_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Gũtirĩ ũrogi ũngĩũraga Jakubu, gũtirĩ ũragũri ũngĩthũkia Isiraeli. Rĩu ha ũhoro wa Jakubu na wa Isiraeli kũrĩĩranagwo atĩrĩ, ‘Ta kĩonei ũrĩa Ngai ekĩte!’ ");
INSERT INTO kik_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Andũ acio maarahũkaga ta mũrũũthi wa nga; mookagĩra ta mũrũũthi wa njamba, ũrĩa ũtangĩhurũka ũtarĩĩte kĩrĩa ũnyiitĩte, na ũkanyua thakame ya kĩrĩa ũragĩte.” ");
INSERT INTO kik_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ningĩ Balaki akĩĩra Balamu atĩrĩ, “Ndũkamarume o na atĩa, na ndũkamarathime o na atĩa!” ");
INSERT INTO kik_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balamu akĩmũcookeria atĩrĩ, “Githĩ ndiakwĩrire no nginya njĩke ũrĩa wothe Jehova oigĩte?” ");
INSERT INTO kik_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ningĩ Balaki akĩĩra Balamu atĩrĩ, “Ũka tũthiĩ ngũtware handũ hangĩ. Hihi Ngai no agwĩtĩkĩrie ũnumĩre andũ aya ũrĩ hau.” ");
INSERT INTO kik_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balaki akĩoya Balamu akĩmũtwara kĩrĩma igũrũ kĩa Peoru, kũngʼethera Werũ ũrĩa ũtarĩ kĩndũ. ");
INSERT INTO kik_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Nake Balamu akĩmwĩra atĩrĩ, “Njakĩra igongona mũgwanja haha, na ũhaarĩrie ndegwa mũgwanja na ndũrũme mũgwanja.” ");
INSERT INTO kik_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaki agĩĩka o ta ũrĩa Balamu oigĩte, na o kĩgongona-inĩ agĩthĩnjĩra ndegwa ĩmwe na ndũrũme ĩmwe. ");
INSERT INTO kik_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Na rĩrĩ, rĩrĩa Balamu onire atĩ Jehova nĩakenaga nĩ kũrathima Isiraeli-rĩ, ndaacookire kũrũmĩrĩra ũragũri ta ũrĩa ekaga mahinda macio mangĩ, no ehũgũrire akĩrora werũ-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Rĩrĩa Balamu eroreire akĩona ũrĩa Isiraeli maambĩte hema kũringana na mĩhĩrĩga yao-rĩ, akĩiyũrwo nĩ Roho wa Ngai, ");
INSERT INTO kik_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","nake akĩaria ndũmĩrĩri yake, akiuga atĩrĩ: “Ĩno nĩyo ndũmĩrĩri ya Balamu mũrũ wa Beori, ndũmĩrĩri ya mũndũ ũrĩa riitho rĩake rĩonaga wega, ");
INSERT INTO kik_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ndũmĩrĩri ya mũndũ ũrĩa ũiguaga ciugo cia Ngai, ũrĩa wonaga kĩoneki kuuma kũrĩ Mwene-Hinya-Wothe, ũrĩa ũgũũaga agakoma thĩ, namo maitho make makahingũka: ");
INSERT INTO kik_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Kaĩ hema ciaku, wee Jakubu, nĩ thaka-ĩ, o na ciikaro ciaku igagĩthakara, wee Isiraeli-ĩ! ");
INSERT INTO kik_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Igĩtambũrũkĩte o ta cianda, ikahaana ta mĩgũnda ĩrĩ hũgũrũrũ cia rũũĩ-inĩ, itariĩ ta mĩtĩ ya thubiri ĩhaandĩtwo nĩ Jehova, o na ta mĩtarakwa ĩrĩ hakuhĩ na maaĩ. ");
INSERT INTO kik_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Maaĩ makaiyũra ndoo ciao nginya maitĩke; o nayo mbegũ yao ĩgakorwo na maaĩ maingĩ. “Mũthamaki wao akaaneneha gũkĩra Agagi; ũthamaki wao nĩũgaatũgĩrio. ");
INSERT INTO kik_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Ngai aamarutire bũrũri wa Misiri; marĩ na hinya ta wa ndegwa ya gĩthaka. Matambuuraga ndũrĩrĩ iria imathũire, na makoinanga mahĩndĩ ma cio tũcunjĩ; macitheecaga na mĩguĩ yao. ");
INSERT INTO kik_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","O ta mũrũũthi, methunaga magĩkoma, o ta mũrũũthi wa mũgoma, nũũ ũngĩgeria kũmaarahũra? “Arĩa makũrathimaga marorathimwo, nao arĩa makũrumaga maronyiitwo nĩ kĩrumi!” ");
INSERT INTO kik_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Nake Balaki agĩcinwo nĩ marakara nĩ ũndũ wa Balamu. Akĩhũũra hĩ ciake, akĩmwĩra atĩrĩ, “Ndagwĩtire ũnumĩre thũ ciakwa, no wee ũcirathimĩte maita macio matatũ. ");
INSERT INTO kik_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Na rĩrĩ, ũkĩra o rĩu ũinũke! Ndoigĩte nĩngũkũrĩha wega mũno, no Jehova nĩagirĩtie ũrĩhwo.” ");
INSERT INTO kik_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balamu agĩcookeria Balaki atĩrĩ, “Githĩ ndierire andũ arĩa wandũmĩire atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘O na Balaki angĩĩhe nyũmba yake ya ũthamaki ĩiyũrĩtio betha na thahabu, ndingĩhota gwĩka ũndũ wakwa mwene, mwega kana mũũru, njagarare watho wa Jehova; no nginya njuge ũrĩa Jehova oigĩte’? ");
INSERT INTO kik_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Na rĩrĩ, niĩ nĩngũcooka o kũrĩ andũ aitũ, no ũka, ngũmenyithie ũrĩa andũ aya mageeka andũ aku matukũ marĩa magooka.” ");
INSERT INTO kik_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ningĩ akĩaria ndũmĩrĩri yake, akiuga atĩrĩ: “Ĩno nĩyo ndũmĩrĩri ya Balamu mũrũ wa Beori, ndũmĩrĩri ya mũndũ ũrĩa riitho rĩake rĩonaga wega, ");
INSERT INTO kik_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ndũmĩrĩri ya mũndũ ũrĩa ũiguaga ciugo cia Ngai, ũrĩa ũrĩ na ũmenyo uumĩte kũrĩ Ũrĩa-ũrĩ-Igũrũ-Mũno, ũrĩa wonaga kĩoneki kuuma kũrĩ Mwene-Hinya-Wothe, ũrĩa ũgũũaga agakoma thĩ, namo maitho make makahingũka, ekuuga ũũ: ");
INSERT INTO kik_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Nĩndĩramuona, no ti rĩu; nĩndĩmũcũthĩrĩirie, no ndarĩ hakuhĩ. Njata nĩĩkoima kũrĩ Jakubu; njũgũma ya ũnene yume kũrĩ Isiraeli. Nĩakahehenja mothiũ ma Moabi, na ahehenje, mahĩndĩ ma mĩtwe ya ariũ othe a Shethu. ");
INSERT INTO kik_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edomu nĩgũkahootwo; Seiru, thũ yake, nĩakahootwo, no Isiraeli agakĩrĩrĩria kũgĩa na hinya. ");
INSERT INTO kik_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mwathani mũnene akoima kũrĩ Jakubu na aanange andũ arĩa magaakorwo matigaire a itũũra inene.” ");
INSERT INTO kik_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ningĩ Balamu akĩona Amaleki, na akĩaria ndũmĩrĩri yake, akiuga atĩrĩ: “Amaleki nĩwe warĩ wa mbere harĩ ndũrĩrĩ, no marigĩrĩrio-inĩ nĩakanangwo.” ");
INSERT INTO kik_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ningĩ akĩona Akeni, na akĩaria ndũmĩrĩri yake, akiuga atĩrĩ: “Gĩikaro gĩaku nĩ kĩgitĩre, gĩtara gĩaku gĩakĩtwo thĩinĩ wa rwaro rwa ihiga; ");
INSERT INTO kik_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","no rĩrĩ, inyuĩ andũ a Akeni nĩmũkanangwo hĩndĩ ĩrĩa Ashuri makaamũtaha.” ");
INSERT INTO kik_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ningĩ akĩaria ndũmĩrĩri yake, akiuga atĩrĩ: “Hĩ! Nũũ ũngĩtũũra muoyo rĩrĩa Ngai areka ũguo? ");
INSERT INTO kik_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Meeri nĩigooka ciumĩte hũgũrũrũ-inĩ cia Kitimu; nĩigatooria Ashuri o na Eberi, no rĩrĩ, o nacio nĩikaanangwo.” ");
INSERT INTO kik_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Nake Balamu agĩgĩũkĩra, akĩinũka gwake mũciĩ, nake Balaki agĩthiĩ na njĩra ciake. ");
INSERT INTO kik_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Hĩndĩ ĩrĩa andũ a Isiraeli maikaraga Shitimu-rĩ, arũme a Isiraeli makĩambĩrĩria gũtharia na andũ-a-nja a Moabi, ");
INSERT INTO kik_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","arĩa mameetaga magongona-inĩ ma ngai ciao. Andũ acio a Isiraeli makĩrĩa na makĩinamĩrĩra mbere ya ngai icio. ");
INSERT INTO kik_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Nĩ ũndũ ũcio andũ a Isiraeli makĩnyiitanĩra nao kũhooya ngai ya Baali ya Peori. Namo marakara ma Jehova makĩmarĩrĩmbũkĩra. ");
INSERT INTO kik_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Jehova akĩĩra Musa atĩrĩ, “Oya atongoria othe a andũ aya, ũmoorage na ũmaanĩke mũthenya barigici mbere ya Jehova, nĩguo marakara mahiũ ma Jehova matigakinyĩrĩre andũ a Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Nĩ ũndũ ũcio Musa akĩĩra aciirithania a Isiraeli atĩrĩ, “O mũndũ wanyu no nginya oorage arũme anyu arĩa manyiitanĩire na andũ a Moabi kũhooya Baali ya Peori.” ");
INSERT INTO kik_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","O hĩndĩ ĩyo mũndũ mũrũme Mũisiraeli akĩrehe mũndũ-wa-nja Mũmidiani mũciĩ gwake akĩonagwo nĩ Musa na kĩũngano kĩu gĩothe gĩa Isiraeli, o hĩndĩ ĩrĩa maarĩragĩra itoonyero-inĩ rĩa Hema-ya-Gũtũnganwo. ");
INSERT INTO kik_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Rĩrĩa Finehasi mũrũ wa Eleazaru, mũrũ wa Harũni ũrĩa mũthĩnjĩri-Ngai, onire ũndũ ũcio-rĩ, akiuma kĩũngano-inĩ kĩu, akĩoya itimũ, ");
INSERT INTO kik_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","akĩrũmĩrĩra Mũisiraeli ũcio nginya hema-inĩ yake. Akĩmatheeca na itimũ rĩu, akĩmatũrĩkania eerĩ, itimũ rĩu rĩgĩtũrĩkania Mũisiraeli ũcio o na rĩgĩtheeca mũndũ-wa-nja ũcio. Hĩndĩ ĩyo mũthiro ũcio wokĩrĩire andũ a Isiraeli ũgĩthira; ");
INSERT INTO kik_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","no andũ arĩa maakuire nĩ ũndũ wa mũthiro ũcio maarĩ andũ 24,000. ");
INSERT INTO kik_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehasi, mũrũ wa Eleazaru, mũrũ wa Harũni ũrĩa mũthĩnjĩri-Ngai, nĩatũmĩte marakara makwa meherere andũ a Isiraeli; nĩ ũndũ nĩahĩahĩire ngoro o ta ũrĩa ndaiguite nĩ ũndũ wa gĩtĩĩo gĩakwa thĩinĩ wao, na nĩ ũndũ ũcio o na ndahĩahĩa ndiamaniinire. ");
INSERT INTO kik_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Nĩ ũndũ ũcio ĩra Finehasi atĩrĩ, nĩ ngũthondeka kĩrĩkanĩro gĩakwa gĩa thayũ nake. ");
INSERT INTO kik_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","We na njiaro ciake nĩ makagĩa na kĩrĩkanĩro gĩa gũtũũra kĩa ũthĩnjĩri-Ngai, nĩ ũndũ nĩahĩahĩire ngoro nĩ ũndũ wa gĩtĩĩo kĩa Ngai wake, na akĩhoroheria andũ a Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Mũisiraeli ũcio woragirwo marĩ na mũndũ-wa-nja Mũmidiani eetagwo Zimuri mũrũ wa Salu, mũtongoria wa nyũmba ya Asimeoni. ");
INSERT INTO kik_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Nake mũndũ-wa-nja ũcio Mũmidiani woragirwo, eetagwo Kozibi mwarĩ wa Zuru, mũnene wa mũhĩrĩga thĩinĩ wa nyũmba ĩmwe ya Amidiani. ");
INSERT INTO kik_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Tua andũ a Midiani thũ cianyu na ũmoorage, ");
INSERT INTO kik_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","tondũ nĩmamũtuire thũ ciao rĩrĩa maamũheenirie ũhoro-inĩ wa kũhoera kũu Peori na wa mwarĩ wa nyina wao Kozibi, mwarĩ wa mũtongoria Mũmidiani, mũndũ-wa-nja ũrĩa woragirwo rĩrĩa mũthiro wokire nĩ ũndũ wa Peori.” ");
INSERT INTO kik_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Na rĩrĩ, thuutha wa mũthiro ũcio Jehova akĩĩra Musa na Eleazaru mũrũ wa Harũni, ũrĩa mũthĩnjĩri-Ngai atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Tarai kĩrĩndĩ gĩothe kĩa andũ a Isiraeli kũringana na nyũmba ciao, andũ arĩa othe maakinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, arĩa mangĩhota gũthiĩ ita-inĩ marĩ mbũtũ cia Isiraeli.” ");
INSERT INTO kik_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Nĩ ũndũ ũcio, Musa na Eleazaru ũrĩa mũthĩnjĩri-Ngai makĩarĩria andũ a Isiraeli kũu werũ-inĩ wa Moabi hakuhĩ na Rũũĩ rwa Jorodani mũrĩmo wa Jeriko, makĩmeera atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Tarai andũ arĩa makinyĩtie mĩaka mĩrongo ĩĩrĩ na makĩria, o ta ũrĩa Jehova aathĩte Musa.” Aya nĩo andũ a Isiraeli arĩa moimire bũrũri wa Misiri: ");
INSERT INTO kik_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Njiaro cia Rubeni, irigithathi rĩa Isiraeli ciarĩ ici: kuuma kũrĩ Hanoku, nĩ mbarĩ ya Ahanoku; kuuma kũrĩ Palu, nĩ mbarĩ ya Apalu; ");
INSERT INTO kik_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","kuuma kũrĩ Hezironi, nĩ mbarĩ ya Ahezironi; kuuma kũrĩ Karimi, nĩ mbarĩ ya Akarimi. ");
INSERT INTO kik_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Icio nĩcio mbarĩ cia Rubeni; arĩa maatarirwo maarĩ andũ 43,730. ");
INSERT INTO kik_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Mũrũ wa Palu arĩ Eliabu, ");
INSERT INTO kik_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","nao ariũ a Eliabu maarĩ Nemueli, na Dathani, na Abiramu. Dathani na Abiramu nĩo maarĩ anene a kĩrĩndĩ, na nĩo maaremeire Musa na Harũni na maarĩ amwe a arũmĩrĩri a Kora rĩrĩa maaremeire Jehova. ");
INSERT INTO kik_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Nayo thĩ ĩgĩathamia kanua kayo ĩkĩmameria hamwe na Kora, ũrĩa arũmĩrĩri ake maakuire rĩrĩa mwaki wacinire arũme arĩa 250. Nao magĩtuĩka kĩonereria gĩa gũkaania arĩa angĩ. ");
INSERT INTO kik_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","No rĩrĩ, rũciaro rwa Kora rũtiathirire. ");
INSERT INTO kik_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Nacio njiaro cia Simeoni kũringana na mbarĩ ciao nĩ ici: kuuma kũrĩ Nemueli, nĩ mbarĩ ya Anemueli; kuuma kũrĩ Jamini, nĩ mbarĩ ya Ajamini; kuuma kũrĩ Jakini, nĩ mbarĩ ya Ajakini; ");
INSERT INTO kik_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","kuuma kũrĩ Zera, nĩ mbarĩ ya Azera; kuuma kũrĩ Shauli, nĩ mbarĩ ya Ashaulu. ");
INSERT INTO kik_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Icio nĩcio ciarĩ mbarĩ cia Simeoni; nao maarĩ andũ 22,200. ");
INSERT INTO kik_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Nacio njiaro cia Gadi kũringana na mbarĩ ciao nĩ ici: kuuma kũrĩ Zefoni, nĩ mbarĩ ya Azefoni; kuuma kũrĩ Hagi, nĩ mbarĩ ya Ahagi; kuuma kũrĩ Shuni, nĩ mbarĩ ya Ashuni; ");
INSERT INTO kik_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","kuuma kũrĩ Ozini, nĩ mbarĩ ya Aozini; kuuma kũrĩ Eri, nĩ mbarĩ ya Aeri; ");
INSERT INTO kik_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","kuuma kũrĩ Arodi, nĩ mbarĩ ya Aarodi; kuuma kũrĩ Areli, nĩ mbarĩ ya Aareli. ");
INSERT INTO kik_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Icio nĩcio ciarĩ mbarĩ cia Gadi; arĩa maatarirwo maarĩ andũ 40,500. ");
INSERT INTO kik_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eri na Onani, maarĩ ariũ a Juda, no maakuĩrĩire Kaanani. ");
INSERT INTO kik_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Nacio njiaro cia Juda kũringana na mbarĩ ciao nĩ ici: kuuma kũrĩ Shela, nĩ mbarĩ ya Ashela; kuuma kũrĩ Perezu, nĩ mbarĩ ya Aperezu; kuuma kũrĩ Zera, nĩ mbarĩ ya Azera. ");
INSERT INTO kik_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Nacio njiaro cia Perezu ciarĩ ici: kuuma kũrĩ Hezironi, nĩ mbarĩ ya Ahezironi; kuuma kũrĩ Hamuli, nĩ mbarĩ ya Ahamuli. ");
INSERT INTO kik_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Icio nĩcio ciarĩ mbarĩ cia Juda; arĩa maatarirwo maarĩ andũ 76,500. ");
INSERT INTO kik_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Nacio njiaro cia Isakaru kũringana na mbarĩ ciao ciarĩ ici: kuuma kũrĩ Tola, nĩ mbarĩ ya Atola; kuuma kũrĩ Puva nĩ mbarĩ ya Apuva; ");
INSERT INTO kik_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","kuuma kũrĩ Jashubu, nĩ mbarĩ ya Ajashubu; kuuma kũrĩ Shimuroni, nĩ mbarĩ ya Ashimuroni. ");
INSERT INTO kik_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Icio nĩcio ciarĩ mbarĩ cia Isakaru; arĩa maatarirwo maarĩ andũ 64,300. ");
INSERT INTO kik_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Nacio njiaro cia Zebuluni kũringana na mbarĩ ciao ciarĩ ici: kuuma kũrĩ Seredi, nĩ mbarĩ ya Aseredi; kuuma kũrĩ Eloni nĩ mbarĩ ya Aeloni, na kuuma kũrĩ Jahaleeli, nĩ mbarĩ ya Ajahaleeli. ");
INSERT INTO kik_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Icio nĩcio ciarĩ mbarĩ cia Zebuluni; arĩa maatarirwo maarĩ andũ 60,500. ");
INSERT INTO kik_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Nacio njiaro cia Jusufu kũringana na mbarĩ ciao kuuma kũrĩ Manase na Efiraimu ciarĩ ici: ");
INSERT INTO kik_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Njiaro cia Manase: kuuma kũrĩ Makiru, nĩ mbarĩ ya Amakiru (Makiru nĩwe warĩ ithe wa Gileadi); kuuma kũrĩ Gileadi nĩ mbarĩ ya Agileadi. ");
INSERT INTO kik_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ici nĩcio njiaro cia Gileadi: kuuma kũrĩ Iezeri, nĩ mbarĩ ya Aiezeli; kuuma kũrĩ Heleku, nĩ mbarĩ ya Aheleku; ");
INSERT INTO kik_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","kuuma kũrĩ Asirieli, nĩ mbarĩ ya Aasirieli; kuuma kũrĩ Shekemu, nĩ mbarĩ ya Ashekemu; ");
INSERT INTO kik_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kuuma kũrĩ Shemida, nĩ mbarĩ ya Ashemida; kuuma kũrĩ Heferi, nĩ mbarĩ ya Aheferi. ");
INSERT INTO kik_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Zelofehadi mũrũ wa Heferi ndaarĩ na aanake, no airĩtu atheri, namo marĩĩtwa mao maarĩ Mahala, na Noa, na Hogila, na Milika, na Tiriza.) ");
INSERT INTO kik_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Icio nĩcio ciarĩ mbarĩ cia Manase, arĩa maatarirwo maarĩ andũ 52,700. ");
INSERT INTO kik_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ici nĩcio njiaro cia Efiraimu kũringana na mbarĩ ciao: kuuma kũrĩ Shuthela, nĩ mbarĩ ya Ashuthela; kuuma kũrĩ Bekeri, nĩ mbarĩ ya Abekeri; kuuma kũrĩ Tahani nĩ mbarĩ ya Atahani. ");
INSERT INTO kik_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ici nĩcio ciarĩ njiaro cia Shuthela; kuuma kũrĩ Erani, nĩ mbarĩ ya Aerani. ");
INSERT INTO kik_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ici nĩcio ciarĩ mbarĩ cia Efiraimu; arĩa maatarirwo maarĩ andũ 32,500. Icio nĩcio njiaro cia Jusufu kũringana na mbarĩ ciao. ");
INSERT INTO kik_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Nacio njiaro cia Benjamini kũringana na mbarĩ ciao ciarĩ ici: kuuma kũrĩ Bela, nĩ mbarĩ ya Abela; kuuma kũrĩ Ashibeli, nĩ mbarĩ ya Aashibeli; kuuma kũrĩ Ahiramu, nĩ mbarĩ ya Aahiramu; ");
INSERT INTO kik_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","kuuma kũrĩ Shefufamu, nĩ mbarĩ ya Ashefufamu; kuuma kũrĩ Hufamu, nĩ mbarĩ ya Ahufamu. ");
INSERT INTO kik_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Nacio njiaro cia Bela kuuma kũrĩ Aridi na Naamani ciarĩ ici: kuuma kũrĩ Aridi, nĩ mbarĩ ya Aaridi; na kuuma kũrĩ Naamani nĩ mbarĩ ya Anaamani. ");
INSERT INTO kik_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ici nĩcio ciarĩ mbarĩ cia Benjamini; arĩa maatarirwo maarĩ andũ 45,600. ");
INSERT INTO kik_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Nacio njiaro cia Dani kũringana na mbarĩ ciao ciarĩ ici: kuuma kũrĩ Shuhamu nĩ mbarĩ ya Ashuhamu. Icio nĩcio ciarĩ mbarĩ ya Dani. ");
INSERT INTO kik_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Acio othe maarĩ a mbarĩ cia Ashuhamu: na arĩa maatarirwo maarĩ andũ 64,400. ");
INSERT INTO kik_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Nacio njiaro cia Asheri kũringana na mbarĩ ciao ciarĩ ici: kuuma kũrĩ Imuna, nĩ mbarĩ ya Aimuna; kuuma kũrĩ Ishivi, nĩ mbarĩ ya Aishivi; kuuma kũrĩ Beria, nĩ mbarĩ ya Aberia; ");
INSERT INTO kik_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","nao aya nĩo maarĩ a njiaro cia Beria: kuuma kũrĩ Heberi, nĩ mbarĩ ya Aheberi; na kuuma kũrĩ Malikieli, nĩ mbarĩ ya Amalikieli. ");
INSERT INTO kik_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(Asheri aarĩ na mwarĩ wetagwo Sera.) ");
INSERT INTO kik_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Icio nĩcio ciarĩ mbarĩ cia Asheri; arĩa maatarirwo maarĩ andũ 53,400. ");
INSERT INTO kik_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nacio njiaro cia Nafitali kũringana na mbarĩ ciao ciarĩ ici: kuuma kũrĩ Jahazeeli, nĩ mbarĩ ya Ajahazeeli; kuuma kũrĩ Guni, nĩ mbarĩ ya Aguni; ");
INSERT INTO kik_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","kuuma kũrĩ Jezeri, nĩ mbarĩ ya Ajezeri; kuuma kũrĩ Shilemu, nĩ mbarĩ ya Ashilemu. ");
INSERT INTO kik_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ici nĩcio ciarĩ mbarĩ cia Nafitali; arĩa maatarirwo maarĩ andũ 45,400. ");
INSERT INTO kik_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Mũigana wa arũme acio othe a Isiraeli maarĩ andũ 601,730. ");
INSERT INTO kik_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Bũrũri ũyũ nĩguo makagaĩrwo ũtuĩke igai rĩao kũringana na mũigana wa marĩĩtwa mao. ");
INSERT INTO kik_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Andũ arĩa aingĩ ũmagaĩre igai inene, nao arĩa maanyiiha ũmagaĩre igai inini; o mũhĩrĩga ũheo igai rĩaguo kũringana na mũigana wa andũ arĩa maandĩkĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Na ũmenyerere wega atĩ, bũrũri ũyũ ũkaaheanwo na ũndũ wa gũcuuka mĩtĩ. Kĩrĩa o gĩkundi gĩkaagaya gĩkaringana na marĩĩtwa ma mĩhĩrĩga ya maithe mao ma tene. ");
INSERT INTO kik_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","O igai rĩkaheanwo na ũndũ wa gũcuuka mĩtĩ kũrĩ ikundi iria nene na iria nini.” ");
INSERT INTO kik_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Aya nĩo Alawii arĩa maatarirwo kũringana na mbarĩ ciao: kuuma kũrĩ Gerishoni, nĩ mbarĩ ya Agerishoni; kuuma kũrĩ Kohathu, nĩ mbarĩ ya Akohathu; kuuma kũrĩ Merari, nĩ mbarĩ ya Amerari. ");
INSERT INTO kik_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","O nacio ici ciarĩ mbarĩ cia Alawii: mbarĩ ya Alibini, na mbarĩ ya Ahebironi, na mbarĩ ya Amahali, na mbarĩ ya Amushi, na mbarĩ ya Akora. (Kohathu aarĩ guka wa Amuramu; ");
INSERT INTO kik_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","nake mũtumia wa Amuramu eetagwo Jokebedi, wa rũciaro rwa Lawi, waciarĩirwo Alawii kũu bũrũri wa Misiri. Nake Jokebedi agĩciarĩra Amuramu Harũni, na Musa, na mwarĩ wa nyina wao Miriamu. ");
INSERT INTO kik_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Harũni nĩwe warĩ ithe wa Nadabu na Abihu na Eleazaru na Ithamaru. ");
INSERT INTO kik_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","No Nadabu na Abihu nĩmakuire rĩrĩa maarutĩire Jehova igongona na mwaki ũtaarĩ mwĩtĩkĩrie.) ");
INSERT INTO kik_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Alawii othe arũme a ũkũrũ wa mweri ũmwe na makĩria arĩa maatarirwo maarĩ andũ 23,000. Matiataranĩirio hamwe na andũ a Isiraeli arĩa angĩ tondũ matiagaire kĩndũ hamwe na andũ arĩa angĩ. ");
INSERT INTO kik_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Acio nĩo maatarirwo nĩ Musa na Eleazaru ũrĩa mũthĩnjĩri-Ngai rĩrĩa maatarĩire andũ a Isiraeli werũ-inĩ wa Moabi hũgũrũrũ-inĩ cia Rũũĩ rwa Jorodani, mũrĩmo ũyũ wa Jeriko. ");
INSERT INTO kik_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Hatiarĩ o na ũmwe wa arĩa matarĩtwo nĩ Musa na Harũni ũrĩa mũthĩnjĩri-Ngai, hĩndĩ ĩrĩa maatarĩire andũ a Isiraeli werũ-inĩ wa Sinai. ");
INSERT INTO kik_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Nĩ ũndũ Jehova nĩeerĩte andũ a Isiraeli atĩ ti-itherũ no nginya makuĩre werũ-inĩ, na gũtirĩ o na ũmwe wao watigarire, tiga no Kalebu mũrũ wa Jefune, na Joshua mũrũ wa Nuni. ");
INSERT INTO kik_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Na rĩrĩ, airĩtu acio a Zelofehadi mũrũ wa Heferi mũrũ wa Gileadi, mũrũ wa Makiru, mũrũ wa Manase maarĩ a mbarĩ cia Manase mũrũ wa Jusufu. Marĩĩtwa ma airĩtu acio maarĩ Mahala, na Noa, na Hogila, na Milika, na Tiriza. Nĩmathiire, magĩkuhĩrĩria ");
INSERT INTO kik_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","itoonyero rĩa Hema-ya-Gũtũnganwo, makĩrũgama mbere ya Musa, na Eleazaru ũrĩa mũthĩnjĩri-Ngai, na mbere ya atongoria, o na kĩũngano gĩothe gĩa Isiraeli, makiuga atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Ithe witũ aakuĩrĩire werũ-inĩ. Ndaarĩ ũmwe wa arũmĩrĩri a Kora, arĩa manyiitanire mokĩrĩre Jehova, no aakuire nĩ ũndũ wa mehia make mwene na ndaarĩ na aanake. ");
INSERT INTO kik_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Nĩ kĩĩ gĩgũtũma rĩĩtwa rĩa awa rĩniinwo mbarĩ-inĩ yao, nĩ ũndũ atĩ ndaarĩ na mwanake? Tũhei igai hamwe na andũ a nyũmba ya ithe witũ.” ");
INSERT INTO kik_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Nĩ ũndũ ũcio Musa agĩtwarĩra Jehova ũhoro ũcio wao, ");
INSERT INTO kik_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","nake Jehova akĩmwĩra atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Ũguo airĩtu a Zelofehadi maroiga nĩ kĩhooto. Ti-itherũ nĩ wega ũmaheanĩrie igai rĩao na andũ a nyũmba ya ithe wao, o narĩo igai rĩa ithe wao ũmahe. ");
INSERT INTO kik_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Ĩra andũ a Isiraeli atĩrĩ, ‘Mũndũ angĩkua na ndatige mwana wa kahĩĩ, mwarĩ nĩaheo igai rĩake. ");
INSERT INTO kik_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Angĩgakorwo atarĩ na mũirĩtu-rĩ, heagai ariũ a nyina igai rĩake. ");
INSERT INTO kik_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Angĩgakorwo atarĩ na ariũ a nyina-rĩ, heagai ariũ a nyina na ithe igai rĩake. ");
INSERT INTO kik_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Angĩkorwo ithe ndaarĩ na ariũ a nyina-rĩ, heagai mũndũ wa mbarĩ yao ũrĩa marĩ a igai rĩake, nĩguo rĩtuĩke rĩake. Ũndũ ũcio ũgũtuĩka watho wa kũrũmagĩrĩrwo nĩ andũ a Isiraeli, o ta ũrĩa Jehova aathire Musa.’ ” ");
INSERT INTO kik_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ningĩ Jehova akĩĩra Musa atĩrĩ, “Ũkĩra wambate kĩrĩma-inĩ gĩkĩ, kũu rũgongo rwa Abarimu, wĩrorere bũrũri ũrĩa heete andũ a Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Warĩkia kũwona, we nĩũgũkua o ta ũrĩa Harũni mũrũ wa nyũkwa aakuire, na ũcookanĩrĩrio na andũ anyu, ");
INSERT INTO kik_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","nĩgũkorwo rĩrĩa kĩrĩndĩ kĩanemeire hau maaĩ-inĩ ma Werũ wa Zini, wee na Harũni inyuĩ eerĩ mũtiathĩkĩire watho wakwa, nĩmwagire kũndĩĩithia nĩguo muonanie atĩ ndĩ mũtheru mbere ya maitho mao.” (Maaĩ macio nĩ marĩa ma Meriba Kadeshi, Werũ-inĩ wa Zini.) ");
INSERT INTO kik_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Musa akĩĩra Jehova atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Jehova-Ngai wa maroho ma andũ othe, nĩagĩthuure mũndũ atuĩke mũrori wa kĩrĩndĩ gĩkĩ, ");
INSERT INTO kik_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","atwaranage nakĩo gĩkiumagara na gĩkĩinũka, ũrĩa ũrĩgĩtongoragia gĩgĩthiĩ na gĩgĩcooka, nĩguo kĩrĩndĩ gĩkĩ kĩa Jehova gĩtigatuĩke ta ngʼondu itarĩ na mũrĩithi.” ");
INSERT INTO kik_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Nĩ ũndũ ũcio Jehova akĩĩra Musa atĩrĩ, “Oya Joshua mũrũ wa Nuni, mũndũ ũrĩ na roho thĩinĩ wake, na ũmũigĩrĩre guoko gwaku. ");
INSERT INTO kik_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Mũrũgamie mbere ya Eleazaru ũrĩa mũthĩnjĩri-Ngai, na mbere ya kĩũngano gĩothe ũmũtue mũtongoria wao hau mbere yao. ");
INSERT INTO kik_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ũmũhe ũhoti ũmwe waku, nĩgeetha kĩrĩndĩ gĩothe kĩa andũ a Isiraeli kĩmwathĩkagĩre. ");
INSERT INTO kik_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Nake arũgamage mbere ya Eleazaru ũcio mũthĩnjĩri-Ngai, ũrĩa ũrĩmũtuĩragĩria ũhoro na ũndũ wa kũũria Urimu mbere ya Jehova. Rĩrĩa aathana, hamwe na kĩrĩndĩ gĩothe kĩa andũ a Isiraeli makoimagara, ningĩ aathana rĩngĩ makainũka.” ");
INSERT INTO kik_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Musa agĩĩka o ta ũguo Jehova aamwathĩte. Akĩoya Joshua, na akĩmũrũgamia mbere ya Eleazaru ũrĩa mũthĩnjĩri-Ngai o na mbere ya kĩũngano kĩu gĩothe. ");
INSERT INTO kik_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ningĩ akĩmũigĩrĩra moko make na akĩmũtua mũtongoria wao o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“He andũ a Isiraeli watho ũyũ, ũmeere atĩrĩ: ‘Menyagĩrĩrai muone atĩ nĩ mwandehere irio cia maruta makwa ma gũcinwo na mwaki ihinda rĩrĩa rĩagĩrĩire, irĩ mũtararĩko mwega wa kũngenia.’ ");
INSERT INTO kik_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Meere atĩrĩ, ‘Rĩĩrĩ nĩrĩo iruta rĩa gũcinwo na mwaki rĩrĩa mũrĩrehagĩra Jehova: nĩ tũtũrũme twĩrĩ, o kamwe ka ũkũrũ wa mwaka ũmwe, tũtarĩ na kaũũgũ, rĩtuĩke igongona rĩa kũrutagwo rĩa njino hĩndĩ ciothe o mũthenya. ");
INSERT INTO kik_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Haaragĩriai gatũrũme kamwe rũciinĩ, na karĩa kangĩ hwaĩ-inĩ kũrĩ mairia, ");
INSERT INTO kik_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","hamwe na iruta rĩa mũtu gĩcunjĩ gĩa ikũmi kĩa eba ĩmwe ya mũtu mũhinyu mũno, ũtukanĩtio na gĩcunjĩ gĩa kana kĩa hini ĩmwe ya maguta mahihĩtwo kuuma kũrĩ ndamaiyũ. ");
INSERT INTO kik_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Rĩu nĩrĩo igongona rĩa njino rĩa hĩndĩ ciothe rĩrĩa rĩaathanirwo Kĩrĩma-inĩ gĩa Sinai, rĩrĩ mũtararĩko mwega, igongona rĩrutĩirwo Jehova rĩa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Nakĩo kĩndũ gĩa kũnyuuo kĩrĩa kĩrĩrutanagĩrio na igongona rĩu kĩrĩkoragwo kĩrĩ gĩcunjĩ gĩa kana kĩa hini ĩmwe ya ndibei ngagatu harĩ o gatũrũme kamwe. Itagĩrai Jehova iruta rĩu rĩa kũnyuuo handũ-harĩa-haamũre. ");
INSERT INTO kik_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Haragĩriai gatũrũme ga keerĩ hwaĩ-inĩ kũrĩ mairia hamwe na iruta rĩa mũtu o na iruta rĩa kĩndũ gĩa kũnyuuo o ta ũrĩa mũharagĩria rĩa rũciinĩ. Rĩu nĩrĩo igongona rĩa gũcinwo na mwaki rĩrĩ na mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Mũthenya wa thabatũ-rĩ, rutagai iruta rĩa tũtũrũme twĩrĩ, o kamwe ka ũkũrũ wa mwaka ũmwe, tũtarĩ na kaũũgũ, hamwe na kĩndũ kĩa iruta rĩa kũnyuuo, na iruta rĩa mũtu icunjĩ igĩrĩ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta. ");
INSERT INTO kik_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Rĩĩrĩ nĩrĩo igongona rĩa njino rĩa kũrutagwo o mũthenya wothe wa Thabatũ, hamwe na igongona rĩa njino rĩa hĩndĩ ciothe, na iruta rĩa kĩndũ kĩarĩo gĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Kĩambĩrĩria kĩa o mweri-rĩ, rutagĩrai Jehova igongona rĩa njino rĩa tũtegwa twĩrĩ na ndũrũme ĩmwe na tũtũrũme mũgwanja o kamwe ka ũkũrũ wa mwaka ũmwe, tuothe tũtarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Harĩ o ndegwa hagĩage na iruta rĩa mũtu icunjĩ ithatũ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno, ũtukanĩtio na maguta; na harĩ ndũrũme hagĩe iruta rĩa mũtu icunjĩ igĩrĩ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta; ");
INSERT INTO kik_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","na harĩ o gatũrũme hagĩage na iruta rĩa mũtu gĩcunjĩ gĩa ikũmi kĩa eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta. Rĩrĩ nĩ igongona rĩa njino, rĩrĩ na mũtararĩko mwega, rĩrutĩirwo Jehova na ũndũ wa gũcinwo na mwaki. ");
INSERT INTO kik_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Harĩ o ndegwa nĩ harĩkoragwo na iruta rĩa kũnyuuo rĩa nuthu ya hini ĩmwe ya ndibei; na harĩ ndũrũme, nĩ gĩcunjĩ gĩa ithatũ kĩa hini ĩmwe; na harĩ o gatũrũme, nĩ gĩcunjĩ kĩa inya kĩa hini ĩmwe. Rĩu nĩrĩo igongona rĩa njino rĩa o mweri rĩrĩa rĩrĩrutagwo o karũgamo ka mweri, mwaka wothe. ");
INSERT INTO kik_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Hamwe na igongona rĩa njino rĩu rĩa hĩndĩ ciothe na kĩndũ kĩarĩo gĩa kũnyuuo, Jehova nĩarĩrutagĩrwo thenge ĩmwe ĩrĩ ya igongona rĩa kũhoroheria mehia. ");
INSERT INTO kik_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Mũthenya wa ikũmi na ĩna wa mweri wa mbere nĩrĩo mũrĩkoragwo na Bathaka ya Jehova. ");
INSERT INTO kik_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Mũthenya wa ikũmi na ĩtano wa mweri ũcio nĩguo mũrĩgĩaga na gĩathĩ; mĩthenya mũgwanja mũrĩĩage mĩgate ĩtarĩ mĩĩkĩre ndawa ya kũimbia. ");
INSERT INTO kik_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Mũthenya wa mbere mũgĩage na kĩũngano kĩamũre na mũtikarutage wĩra wa ndũire. ");
INSERT INTO kik_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Rehagĩrai Jehova iruta rĩa gũcinwo na mwaki, igongona rĩa njino rĩa tũtegwa twĩrĩ, na ndũrũme ĩmwe na tũtũrũme mũgwanja o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Harĩ o ndegwa ĩmwe haaragĩriai iruta rĩa mũtu gĩcunjĩ gĩa ithatũ gĩa ikũmi kĩa eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta; harĩ ndũrũme gĩcunjĩ kĩa igĩrĩ gĩa ikũmi; ");
INSERT INTO kik_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","na harĩ o gatũrũme gĩcunjĩ kĩmwe gĩa ikũmi. ");
INSERT INTO kik_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Na mũrutage thenge ĩmwe ĩrĩ igongona rĩa kũmũhoroheria mehia. ");
INSERT INTO kik_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Haaragĩriai icio hamwe na maruta ma rũciinĩ ma njino marĩa ma hĩndĩ ciothe. ");
INSERT INTO kik_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Ũguo nĩguo mũrĩharagĩria irio cia gũcinwo na mwaki o mũthenya matukũ mũgwanja nĩguo ituĩke mũtararĩko mwega wa gũkenia Jehova; rĩrĩharagĩrio hamwe na igongona rĩa njino rĩa hĩndĩ ciothe na iruta rĩarĩo rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Mũthenya wa mũgwanja mũgĩage na kĩũngano kĩamũre, na mũtikarutage wĩra wa ndũire. ");
INSERT INTO kik_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Mũthenya wa kũruta maciaro ma mbere, rĩrĩa mũrehagĩra Jehova maruta ma ngano ya mũgethano hĩndĩ ya Gĩathĩ gĩa Ciumia-rĩ, gĩagai na kĩũngano kĩamũre, na mũtikarutage wĩra wa ndũire. ");
INSERT INTO kik_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Rehagai igongona rĩa njino rĩa tũtegwa twĩrĩ, na ndũrũme ĩmwe, na tũtũrũme mũgwanja o kamwe ka ũkũrũ wa mwaka ũmwe, rĩtuĩke mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Na harĩ o ndegwa hakorwo na iruta rĩa mũtu rĩa icunjĩ ithatũ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta; nayo ndũrũme ĩrutanĩrio na icunjĩ igĩrĩ cia ikũmi, ");
INSERT INTO kik_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","na gĩcunjĩ kĩmwe gĩa ikũmi kĩrutagwo harĩ o gatũrũme ga tũu mũgwanja. ");
INSERT INTO kik_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Mũcirutanĩrie na thenge ĩmwe ya kũmũhoroheria mehia. ");
INSERT INTO kik_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Haaragĩriai icio hamwe na indo ciacio cia kũnyuuo, hamwe na igongona rĩa njino rĩa hĩndĩ ciothe na maruta marĩo ma mũtu. Na mũmenyagĩrĩre nyamũ icio itikanakorwo na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Mũthenya wa mbere wa mweri wa mũgwanja, gĩagai na kĩũngano kĩamũre na mũtikarute wĩra wa ndũire. Nĩ mũthenya wanyu wa kũhuhaga tũrumbeta. ");
INSERT INTO kik_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Haaragĩriai igongona rĩa njino, rĩa gategwa kamwe na ndũrũme ĩmwe na tũtũrũme mũgwanja o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ, irĩ ta mũtararĩko mwega wa gũkenia Jehova. ");
INSERT INTO kik_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Na harĩ o ndegwa ĩyo hakorwo na iruta rĩa mũtu icunjĩ ithatũ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta; nayo ndũrũme ĩrutanĩrio na icunjĩ igĩrĩ cia ikũmi; ");
INSERT INTO kik_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","na o gĩcunjĩ kĩmwe gĩa ikũmi kĩrutagwo harĩ o gatũrũme ga tũu mũgwanja. ");
INSERT INTO kik_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũmũhoroheria mehia. ");
INSERT INTO kik_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Icio nĩ cia kuongererwo harĩ magongona ma njino ma o mweri, na ma o mũthenya, hamwe na maruta macio ma mũtu na ma indo cia kũnyuuo o ta ũrĩa ũtuĩtwo. Macio nĩ maruta marutĩirwo Jehova macinĩtwo na mwaki, marĩ na mũtararĩko wa kũnunga wega. ");
INSERT INTO kik_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Mũthenya wa ikũmi wa mweri ũyũ wa mũgwanja, gĩagai na kĩũngano gĩtheru. No nginya mwĩimage irio na mũtikarute wĩra. ");
INSERT INTO kik_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Rehagai igongona rĩa njino rĩna mũtararĩko mwega wa gũkenia Jehova rĩa gategwa kamwe na ndũrũme ĩmwe, na tũtũrũme mũgwanja o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Hamwe na ndegwa ĩyo haragĩriai iruta rĩa mũtu icunjĩ ithatũ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta; nayo ndũrũme ĩrutanĩrio na icunjĩ igĩrĩ cia ikũmi; ");
INSERT INTO kik_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","na gĩcunjĩ kĩmwe gĩa ikũmi kĩrutagwo harĩ o gatũrũme ga tũu mũgwanja. ");
INSERT INTO kik_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroheria mehia, yongererwo harĩ igongona rĩa horohio, na igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu, na maruta mao ma kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Mũthenya wa ikũmi na ĩtano mweri wa mũgwanja, gĩagai na kĩũngano kĩamũre na mũtikarute wĩra wa ndũire. Kũngũĩrai Jehova na gĩathĩ mĩthenya mũgwanja. ");
INSERT INTO kik_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Rehagai maruta ma gũcinwo na mwaki marĩ na mũtararĩko mwega wa gũkenia Jehova, igongona rĩa njino rĩa tũtegwa ikũmi na tũtatũ, na ndũrũme igĩrĩ, na tũtũrũme ikũmi na tũna o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Harĩ o ndegwa icio ikũmi na ithatũ-rĩ, haragĩriai iruta rĩa mũtu icunjĩ ithatũ cia ikũmi cia eba ĩmwe ya mũtu mũhinyu mũno ũtukanĩtio na maguta; harĩ o ndũrũme ĩmwe ya icio igĩrĩ, irutanĩrio na icunjĩ igĩrĩ cia ikũmi; ");
INSERT INTO kik_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","na gĩcunjĩ kĩmwe gĩa ikũmi kĩrutagwo harĩ o gatũrũme ga tũu ikũmi na tũna. ");
INSERT INTO kik_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu na iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Mũthenya wa keerĩ, haaragĩriai tũtegwa ikũmi na twĩrĩ, na ndũrũme igĩrĩ, na tũtũrũme ikũmi na tũna o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Hamwe na ndegwa na ndũrũme, na tũtũrũme tũu, haaragĩriai maruta macio ma mũtu na maruta ma kũnyuuo kũringana na mũigana ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu na iruta rĩao rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Mũthenya wa gatatũ-rĩ, haaragĩriai ndegwa ikũmi na ĩmwe, na ndũrũme igĩrĩ, na tũtũrũme ikũmi na tũna o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Hamwe na ndegwa, na ndũrũme, na tũtũrũme tũu, mũhaaragĩriei maruta macio ma mũtu, na maruta ma kũnyuuo kũringana na mũigana ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu na iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Mũthenya wa kana-rĩ, haaragĩriai ndegwa ikũmi, na ndũrũme igĩrĩ, na tũtũrũme ikũmi na tũna o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Hamwe na ndegwa, na ndũrũme, na tũtũrũme tũu, haaragĩriai maruta macio ma mũtu na maruta ma kũnyuuo kũringana na mũigana ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu na iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Mũthenya wa gatano, haaragĩriai ndegwa kenda, na ndũrũme igĩrĩ, na tũtũrũme ikũmi na tũna o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Hamwe na ndegwa na ndũrũme, na tũtũrũme tũu, haaragĩriai maruta macio ma mũtu na maruta ma kũnyuuo kũringana na mũigana ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Mũthenya wa gatandatũ-rĩ, haaragĩriai ndegwa inyanya, na ndũrũme igĩrĩ, na tũtũrũme ikũmi na tũna o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Hamwe na ndegwa, na ndũrũme, na tũtũrũme tũu, haaragĩriai maruta macio ma mũtu na maruta ma kũnyuuo kũringana na mũigana ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu na iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Mũthenya wa mũgwanja, haaragĩriai ndegwa mũgwanja, na ndũrũme igĩrĩ, na tũtũrũme ikũmi na tũna o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Hamwe na ndegwa, na ndũrũme, na tũtũrũme tũu, haaragĩriai maruta macio ma mũtu na maruta ma kũnyuuo kũringana na mũigana ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu na iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Mũthenya wa kanana-rĩ, gĩagai na kĩũngano na mũtikarute wĩra wa ndũire. ");
INSERT INTO kik_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Rehagai iruta rĩa gũcinwo na mwaki rĩrĩ mũtararĩko mwega wa gũkenia Jehova, igongona rĩa njino rĩa ndegwa ĩmwe, na ndũrũme ĩmwe, na tũtũrũme mũgwanja o kamwe ka ũkũrũ wa mwaka ũmwe, ciothe itarĩ na kaũũgũ. ");
INSERT INTO kik_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Hamwe na ndegwa, na ndũrũme, na tũtũrũme tũu, haaragĩriai maruta macio ma mũtu na maruta ma kũnyuuo kũringana na mũigana ũrĩa ũtuĩtwo. ");
INSERT INTO kik_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Mũcirutanĩrie na thenge ĩmwe ĩrĩ igongona rĩa kũhoroherio mehia, yongererwo harĩ igongona rĩa njino rĩa hĩndĩ ciothe, hamwe na iruta rĩa mũtu na iruta rĩa kũnyuuo. ");
INSERT INTO kik_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Hamwe na mwĩhĩtwa na maruta manyu ma kwĩyendera-rĩ, haaragĩriai indo icio nĩ ũndũ wa Jehova ciathĩ-inĩ cianyu iria ciathanĩtwo: na nĩcio maruta manyu ma njino, na maruta ma mũtu, na maruta ma kũnyuuo, na maruta ma ũiguano.’ ” ");
INSERT INTO kik_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Musa akĩĩra andũ a Isiraeli maũndũ marĩa mothe Jehova aamwathĩte. ");
INSERT INTO kik_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Musa akĩĩra atongoria a mĩhĩrĩga ya Isiraeli atĩrĩ: “Ũũ nĩguo Jehova aathanĩte: ");
INSERT INTO kik_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Rĩrĩa mũndũ angĩĩhĩta mwĩhĩtwa harĩ Jehova kana ehĩte mwĩhĩtwa wa kwĩhinga mũhingo na ũndũ wa kĩĩranĩro, ndakanericũkwo, na no nginya eke maũndũ marĩa mothe ehĩtĩte. ");
INSERT INTO kik_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Rĩrĩa mũirĩtu ũrĩ gwa ithe mũciĩ angĩĩhĩta mwĩhĩtwa kũrĩ Jehova, kana ehinge na mũhingo na ũndũ wa kĩĩranĩro, ");
INSERT INTO kik_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","nake ithe aigue ũhoro wa mwĩhĩtwa ũcio wake, kana kĩĩranĩro kĩu, no aage kũmwĩra ũndũ hĩndĩ ĩyo, mĩĩhĩtwa yake yothe, na kĩĩranĩro kĩrĩa gĩothe ehingĩte nakĩo we mwene, nĩigatũũra. ");
INSERT INTO kik_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","No ithe angĩmũkaania aigua ũhoro wa mĩĩhĩtwa ĩyo, hatirĩ o na kĩmwe kĩa mĩĩhĩtwa ĩyo yake, kana ciĩranĩro icio ehingĩte nacio we mwene, igatũũra; nake Jehova nĩakamũrekera nĩ ũndũ ithe nĩamũgirĩtie eke ũndũ ũcio. ");
INSERT INTO kik_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“No angĩhika arĩkĩtie kwĩhĩta, kana thuutha wa kwĩranĩra ũndũ na kanua gake ateciirĩtie ũhoro wa kĩĩranĩro kĩu ehingĩte nakĩo, ");
INSERT INTO kik_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","nake mũthuuriwe aigue ũhoro ũcio na aage kũmwĩra ũndũ, hĩndĩ ĩyo mĩĩhĩtwa yake kana ciĩranĩro icio ehingĩte nacio we mwene nĩigatũũra. ");
INSERT INTO kik_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","No mũthuuriwe angĩmũkaania rĩrĩa aigua ũhoro wa mĩĩhĩtwa ĩyo, nĩakeheria mwĩhĩtwa ũcio ũmuohete, kana kĩĩranĩro kĩrĩa ehingĩte nakĩo we mwene ateciirĩtie, nake Jehova nĩakamũrekera. ");
INSERT INTO kik_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Mwĩhĩtwa o wothe kana ũndũ ũrĩa mũtumia wa ndigwa kana mũtumia ũrĩa ũtiganĩte na mũthuuriwe angĩkorwo ehĩtĩte nĩatũũre aũrũmĩtie. ");
INSERT INTO kik_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Mũtumia ũrĩ na mũthuuriwe angĩĩhĩta kana ehinge we mwene na kĩĩranĩro kĩa mwĩhĩtwa, ");
INSERT INTO kik_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","nake mũthuuriwe aigue ũhoro ũcio, no aage kũmwĩra ũndũ kana aage kũmũgiria, hĩndĩ ĩyo mĩĩhĩtwa yake yothe, kana ciĩranĩro iria ehingĩte nacio we mwene, nĩigatũũra. ");
INSERT INTO kik_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","No mũthuuriwe angĩregana na ũhoro ũcio hĩndĩ ĩyo aũigua-rĩ, hatirĩ o na kĩmwe kĩa mĩĩhĩtwa kana ciĩranĩro iria ciumĩte kanua gake igaatũũra. Mũthuuriwe nĩareganĩte nacio, nake Jehova nĩakamũrekera. ");
INSERT INTO kik_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Mũthuuriwe no etĩkĩre kana aregane na mwĩhĩtwa o wothe ũrĩa angĩĩhĩta kana kĩĩranĩro kĩrĩa eranĩire na mwĩhĩtwa gĩa kwĩrega we mwene. ");
INSERT INTO kik_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","No mũthuuriwe angĩaga kũmwĩra ũndũ igũrũ rĩa ũhoro ũcio mũthenya o mũthenya, nĩetĩkĩrĩte mĩĩhĩtwa yake kana ciĩranĩro iria imuohete. Nĩetĩkĩrĩte maũndũ macio nĩ ũndũ wa kwaga kũmwĩra ũndũ rĩrĩa aigua ũhoro ũcio. ");
INSERT INTO kik_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","No angĩrega maũndũ macio thuutha hanini, aarĩkia kũmaigua, nĩwe ũngĩcookererwo nĩ mahĩtia ma mũtumia wake.” ");
INSERT INTO kik_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Macio nĩmo mawatho marĩa Jehova aaheire Musa makoniĩ mũndũ na mũtumia wake, na makoniĩ ithe na mwarĩ ũrĩa ũrĩ gwake mũciĩ. ");
INSERT INTO kik_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Nake Jehova akĩĩra Musa atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Rĩhĩria andũ a Isiraeli harĩ andũ a Midiani. Na thuutha ũcio nĩũgũcooka ũkue.” ");
INSERT INTO kik_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Nĩ ũndũ ũcio Musa akĩĩra andũ acio atĩrĩ, “Andũ amwe anyu nĩmeohe indo ciao cia mbaara mathiĩ makahũũrane na andũ a Midiani nĩguo marĩhĩrie Jehova kũrĩ o. ");
INSERT INTO kik_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Tũmai andũ 1,000 kuuma kũrĩ o mũhĩrĩga wa Isiraeli mbaara-inĩ.” ");
INSERT INTO kik_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Nĩ ũndũ ũcio andũ 12,000 meeohete indo cia mbaara, o 1,000 kuuma kũrĩ o mũhĩrĩga, makĩneanwo kuuma mĩhĩrĩga ya Isiraeli. ");
INSERT INTO kik_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Musa akĩmatũma mbaara-inĩ, o 1,000 kuuma harĩ o mũhĩrĩga, marĩ hamwe na Finehasi mũrũ wa Eleazaru ũrĩa mũthĩnjĩri-Ngai, ũrĩa wakuuire indo cia handũ-harĩa-haamũre, o na tũrumbeta twa kũhuhwo. ");
INSERT INTO kik_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Nao makĩhũũrana na andũ a Midiani o ta ũrĩa Jehova aathĩte Musa, na makĩũraga arũme othe. ");
INSERT INTO kik_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Gatagatĩ ka arĩa mooragire nĩ Evi, na Rekemu, na Zuru, na Huri, na Reba, athamaki arĩa atano a Midiani. O na ningĩ nĩmooragire Balamu mũrũ wa Beori na rũhiũ rwa njora. ");
INSERT INTO kik_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Nao andũ a Isiraeli magĩtaha andũ-a-nja a Midiani na ciana, na magĩkuua ndũũru ciothe cia andũ a Midiani cia ngʼombe na cia mbũri, na magĩtaha indo iria ingĩ ciothe. ");
INSERT INTO kik_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Magĩcina matũũra mothe kũrĩa andũ a Midiani maatũũrĩte, o ũndũ ũmwe na kambĩ ciao. ");
INSERT INTO kik_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Magĩkuua indo ciothe iria maatahĩte na iria maatunyanĩte hamwe na andũ na nyamũ, ");
INSERT INTO kik_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","na magĩtwara andũ arĩa matahĩtwo na indo icio maatunyanĩte, na iria maatahĩte kũrĩ Musa na kũrĩ Eleazaru ũrĩa mũthĩnjĩri-Ngai na kũrĩ kĩũngano kĩa andũ a Isiraeli kũu kambĩ yarĩ werũ-inĩ wa Moabi, hũgũrũrũ-inĩ cia Rũũĩ rwa Jorodani mũrĩmo wa Jeriko. ");
INSERT INTO kik_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Musa, na Eleazaru ũrĩa mũthĩnjĩri-Ngai na atongoria othe a kĩrĩndĩ magĩthiĩ kũmatũnga nja ya kambĩ. ");
INSERT INTO kik_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Musa akĩrakarĩra anene a mbũtũ icio cia ita na atongoria a mbũtũ cia o ngiri, ngiri, na atongoria a mbũtũ cia o igana, igana, arĩa moimĩte mbaara-inĩ. ");
INSERT INTO kik_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Akĩmooria atĩrĩ, “Kaĩ mwĩtĩkĩrĩtie andũ a nja othe matũũre muoyo? ");
INSERT INTO kik_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Acio nĩo maarũmĩrĩire mataaro ma Balamu, na nĩo maatũmire andũ a Isiraeli matirike Jehova ũhoro-inĩ ũrĩa wekĩkire kũu Peori, naguo ũndũ ũcio ũkĩrehithĩria andũ a Jehova mũthiro. ");
INSERT INTO kik_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Nĩ ũndũ ũcio, ũragai tũhĩĩ tuothe. Na ningĩ mũũrage mũndũ-wa-nja wothe ũrĩ wakoma na mũndũ mũrũme, ");
INSERT INTO kik_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","no mwĩhonokerie mũirĩtu o wothe ũrĩa ũtarĩ wakoma na mũndũ mũrũme. ");
INSERT INTO kik_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Inyuothe arĩa mũũragĩte mũndũ o wothe kana mũkahutia mũndũ o wothe mũũrage no nginya mũikare nja ya kambĩ mĩthenya mũgwanja. Mũthenya wa ĩtatũ na wa mũgwanja, no nginya mwĩtherie inyuĩ ene na arĩa mũtahĩte. ");
INSERT INTO kik_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Theriai nguo ciothe, o ũndũ ũmwe na kĩndũ gĩothe gĩthondeketwo na rũũa, kana guoya wa mbũri kana mbaũ.” ");
INSERT INTO kik_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Ningĩ Eleazaru ũrĩa mũthĩnjĩri-Ngai akĩĩra thigari iria ciathiĩte mbaara-inĩ atĩrĩ, “Watho ũrĩa Jehova aaheire Musa uugĩte atĩrĩ: ");
INSERT INTO kik_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Thahabu, na betha, na gĩcango, na kĩgera, na ibati, na rũbũũa ");
INSERT INTO kik_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","na kĩndũ o gĩothe kĩngĩhota gwĩtiiria mwaki, no nginya kĩhĩtũkagĩrio mwaki-inĩ nĩgeetha gĩthirwo nĩ thaahu. No rĩrĩ, no nginya gĩcooke gĩtherio na maaĩ marĩa ma kũniina thaahu. Nakĩo kĩndũ gĩothe gĩtangĩĩtiiria mwaki no nginya kĩhĩtũkĩrio maaĩ-inĩ macio. ");
INSERT INTO kik_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Mũthenya wa mũgwanja-rĩ, thambiai nguo cianyu na inyuĩ nĩ mũgaathirwo nĩ thaahu. Thuutha ũcio no mũtoonye kambĩ.” ");
INSERT INTO kik_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Nake Jehova akĩĩra Musa atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Wee na Eleazaru ũrĩa mũthĩnjĩri-Ngai na atongoria a nyũmba cia kĩrĩndĩ gĩkĩ no nginya mũtare andũ othe na nyamũ iria ciatahirwo. ");
INSERT INTO kik_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Gayaniai indo cia iria ndahe gatagatĩ ga thigari iria ciathiĩte mbaara-inĩ na kĩrĩndĩ kĩrĩa kĩngĩ. ");
INSERT INTO kik_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kuuma kũrĩ thigari iria ciarũire mbaara, rutai gĩcunjĩ kĩa Jehova, kĩndũ kĩmwe thĩinĩ wa indo magana matano, marĩ andũ, kana ngʼombe, kana ndigiri, kana ngʼondu, o na kana mbũri. ");
INSERT INTO kik_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Oya gĩcunjĩ gĩkĩ kuuma harĩ nuthu ya igai rĩao mũkĩnengere Eleazaru ũrĩa mũthĩnjĩri-Ngai kĩrĩ gĩcunjĩ kĩa Jehova. ");
INSERT INTO kik_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Kuuma kũrĩ nuthu ya gĩcunjĩ kĩa andũ a Isiraeli, thuura kĩndũ kĩmwe kuuma harĩ o gĩkundi kĩa mĩrongo ĩtano, kĩrĩ kĩa andũ, kana ngʼombe, kana ndigiri, kana ngʼondu, kana mbũri o na kana nyamũ ingĩ. Cinengere Alawii arĩa wĩra wao ũrĩ kũmenyerera Hema-ĩrĩa-Nyamũre ya Jehova.” ");
INSERT INTO kik_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Nĩ ũndũ ũcio Musa na Eleazaru ũrĩa mũthĩnjĩri-Ngai magĩĩka o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Indo cia gũtahwo cia iria ciatigarĩte kuuma kũrĩ indo iria ciatunyanĩtwo nĩ thigari ciarĩ ngʼondu 675,000, ");
INSERT INTO kik_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","na ngʼombe 72,000, ");
INSERT INTO kik_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","na ndigiri 61,000 ");
INSERT INTO kik_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","na andũ-a-nja 32,000 arĩa mataakomete na mũndũ mũrũme. ");
INSERT INTO kik_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nuthu ya igai rĩa andũ arĩa maarũĩte mbaara-inĩ ciarĩ: ngʼondu 337,500, ");
INSERT INTO kik_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","na kuuma harĩ icio Jehova akĩrutĩrwo ngʼondu 675; ");
INSERT INTO kik_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","nacio ngʼombe ciarĩ 36,000 na kuuma harĩ icio Jehova akĩrutĩrwo ngʼombe 72; ");
INSERT INTO kik_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","nacio ndigiri ciarĩ 30,500, na kuuma harĩ icio Jehova akĩrutĩrwo ndigiri 61; ");
INSERT INTO kik_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","andũ maarĩ 16,000, na kuuma kũrĩ o Jehova akĩrutĩrwo andũ 32. ");
INSERT INTO kik_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Musa akĩnengera Eleazaru ũrĩa mũthĩnjĩri-Ngai gĩcunjĩ kĩa Jehova, o ta ũrĩa Jehova aathĩte Musa. ");
INSERT INTO kik_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Nuthu ĩrĩa yarĩ ya andũ a Isiraeli, ĩrĩa Musa aamũranĩtie na arĩa maathiĩte mbaara-inĩ, ");
INSERT INTO kik_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","nuthu ĩrĩa yaheirwo kĩrĩndĩ ciarĩ ngʼondu 337,500, ");
INSERT INTO kik_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","nacio ngʼombe ciarĩ 36,000, ");
INSERT INTO kik_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","nacio ndigiri ciarĩ 30,500, ");
INSERT INTO kik_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","nao andũ maarĩ 16,000. ");
INSERT INTO kik_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kuuma kũrĩ nuthu ĩrĩa yaheirwo andũ a Isiraeli, Musa agĩthuura mũndũ ũmwe kuuma kũrĩ andũ mĩrongo ĩtano, na nyamũ ĩmwe kuuma kũrĩ nyamũ mĩrongo ĩtano, o ta ũrĩa Jehova aamwathĩte, na agĩcihe Alawii arĩa wĩra wao warĩ kũmenyerera Hema-ĩrĩa-Nyamũre ya Jehova. ");
INSERT INTO kik_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Ningĩ anene arĩa matongoragia mbũtũ cia ita, acio maathaga ikundi cia o ngiri ngiri, na ikundi cia o igana igana, magĩthiĩ harĩ Musa, ");
INSERT INTO kik_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","nao makĩmwĩra atĩrĩ, “Ndungata ciaku nĩitarĩte thigari iria twathaga na hatirĩ o na ũmwe ũtarĩ ho. ");
INSERT INTO kik_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Nĩ ũndũ ũcio nĩtwarehe indo ici cia thahabu ituĩke iruta riitũ kũrĩ Jehova iria o ũmwe witũ eegwatĩire, nacio nĩ icũhĩ cia moko na bangiri cia moko, na icũhĩ cia ciara, na cia matũ, na mĩgathĩ ya ngingo, nĩguo twĩhoroherie mbere ya Jehova.” ");
INSERT INTO kik_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Musa na Eleazaru ũrĩa mũthĩnjĩri-Ngai makĩamũkĩra thahabu ĩyo kuuma kũrĩ o, indo icio ciothe ciaturĩtwo wega. ");
INSERT INTO kik_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Thahabu yothe ĩrĩa yoimire kũrĩ anene a ikundi cia o ngiri, ngiri na anene a ikundi cia o igana, igana ĩrĩa Musa na Eleazaru maatwarĩire Jehova kĩrĩ kĩheo, yarĩ ya ũritũ wa cekeri 16,750. ");
INSERT INTO kik_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","O mũthigari nĩetahĩire indo ciake. ");
INSERT INTO kik_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Musa na Eleazaru ũrĩa mũthĩnjĩri-Ngai makĩamũkĩra thahabu ĩyo kuuma kũrĩ anene a ikundi cia o ngiri, ngiri na anene a ikundi cia o igana, igana magĩcirehe Hema-inĩ ya Gũtũnganwo ituĩke kĩririkania harĩ andũ a Isiraeli mbere ya Jehova. ");
INSERT INTO kik_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Na rĩrĩ, andũ a mĩhĩrĩga ya Rubeni na Gadi, arĩa maarĩ na ndũũru nene cia ngʼombe na cia mbũri, nĩmoonire atĩ mabũrũri ma Jazeri na Gileadi maarĩ mega na mahiũ mao. ");
INSERT INTO kik_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Nĩ ũndũ ũcio magĩthiĩ kũrĩ Musa na Eleazaru ũrĩa mũthĩnjĩri-Ngai, o na kũrĩ atongoria a kĩrĩndĩ, makiuga atĩrĩ, ");
INSERT INTO kik_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarothu, na Diboni, na Jazeri, na Nimura, na Heshiboni, na Eleale, na Sebamu, na Nebo, o na Beoni, ");
INSERT INTO kik_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","bũrũri ũyũ Jehova aatooririe andũ akuo mbere ya andũ a Isiraeli, nĩ kũndũ kwega kwa mahiũ, na ithuĩ ndungata ciaku tũrĩ na mahiũ.” ");
INSERT INTO kik_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Makiuga atĩrĩ, “Angĩkorwo nĩtwĩtĩkĩrĩkĩte harĩ inyuĩ-rĩ, rekei bũrũri ũyũ ũheo ndungata cianyu ũtuĩke witũ. Mũtigatũme tũringe Rũũĩ rwa Jorodani.” ");
INSERT INTO kik_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Musa akĩũria andũ a Gadi na a Rubeni atĩrĩ, “Andũ anyu no mathiĩ ita-inĩ mamũtige mũikarĩte gũkũ? ");
INSERT INTO kik_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Nĩ kĩĩ gĩgũtũma mũũrage ngoro cia andũ a Isiraeli nĩguo matikaringe rũũĩ matoonye bũrũri ũrĩa Jehova amaheete? ");
INSERT INTO kik_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ũguo noguo maithe manyu meekire hĩndĩ ĩrĩa ndaamarekirie kuuma Kadeshi-Barinea mathiĩ magathigaane bũrũri ũcio. ");
INSERT INTO kik_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Thuutha wa kwambata, magĩkinya kĩanda kĩa Eshikoli na makĩĩrorera bũrũri ũcio-rĩ, nĩmatũmire andũ a Isiraeli makue ngoro makĩaga gũtoonya bũrũri ũrĩa Jehova amaheete. ");
INSERT INTO kik_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Jehova agĩcinwo nĩ marakara mũthenya ũcio, akĩĩhĩta na mwĩhĩtwa ũyũ: ");
INSERT INTO kik_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Nĩ ũndũ nĩmagĩte kũnũmĩrĩra na ngoro ciao kũna, hatirĩ mũndũ o na ũmwe wa ũkũrũ wa mĩaka mĩrongo ĩĩrĩ na makĩria wa arĩa moimire bũrũri wa Misiri ũkoona bũrũri ũrĩa nderĩire Iburahĩmu na Isaaka, o na Jakubu na mwĩhĩtwa, ");
INSERT INTO kik_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","gũtirĩ o na ũmwe tiga Kalebu mũrũ wa Jefune, ũrĩa Mũkenizi, na Joshua mũrũ wa Nuni, nĩ ũndũ nĩmarũmĩrĩire Jehova na ngoro ciao kũna.’ ");
INSERT INTO kik_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Jehova agĩcinwo nĩ marakara nĩ ũndũ wa Isiraeli, nake agĩtũma morũũre werũ-inĩ mĩaka mĩrongo ĩna, o nginya rĩrĩa rũciaro rũu ruothe rwehĩtie maitho-inĩ make rwathirire. ");
INSERT INTO kik_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Na rĩrĩ, mũrĩ haha inyuĩ, inyuĩ rũciaro rũrũ rwa ehia, mũcookete ithenya rĩa maithe manyu nĩguo mũtũme Jehova akĩrĩrĩrie kũrakarĩra Isir