﻿USE sofia;
DROP TABLE IF EXISTS sofia.kij_vpl;
CREATE TABLE kij_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kij_vpl WRITE;
INSERT INTO kij_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kala vitouula tuta matutona Yaubada ibubuli vavagi komwaidona walakaiwa deli watanawa, ");
INSERT INTO kij_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","e baisa ovalu watanawa gala avai vavagi isisu. Paila komwaidona vilouwokuva wala, e gala kwaitala avai migila isisu ambaisa ambaisa. Mesinaku bolitawokuva wala isisu, saina vakaigaga milaveta ikuboli vavagi komwaidona, e dubilikitakita wala isisu. Mitaga Yaubada la peula myala ititavina ambaisa ambaisa odabala sopi. ");
INSERT INTO kij_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Yaubada ikaibiga, kawala, “Ibodi tuta baisa lumalama bikaloubusi.” E lumalama ikaloubusi, ");
INSERT INTO kij_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","e Yaubada saina iyomwasali nanola avaka bogwa leigisi. Mapaila Yaubada ikelituli lumalama, itavilevi lumalama metoya dudubila. ");
INSERT INTO kij_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","E Yaubada lumalama idoki yagala Yam, dudubila yagala Bogi. E bogwa leibogi, eiyam kaukwau, baisa yam kwaimatala. ");
INSERT INTO kij_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","E Yaubada ikaibiga, kawala, “Ibodi basaili avaka bitavilevi sopi, e kaitala kabosilaboda makawala kailuya kaiveka, kidamwa sopi kabala ituwoli ituwoli bisisu.” E bogwa ikaloubusi makawala. Yaubada isaili kabosilaboda makawala kailuya kaiveka, e itavilevi sopi watanawa e walakaiwa. ");
INSERT INTO kij_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","E kabosilaboda makaina idoki yagala labuma, e bogwa leibogi, eiyam kaukwau, baisa yam kwaiyuwela. ");
INSERT INTO kij_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","E Yaubada ikaibiga, kawala, “Ibodi sopi watanawa bitabai bititayelu bila ambaisa okabala, e pwaipwaia biyoulapula.” E bogwa ikaloubusi makawala. ");
INSERT INTO kij_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","E pwaipwaia idoki yagala Valu Watanawa. E sopi leila isisu okabala idoki yagala Bolita. E Yaubada saina iyomwasali nanola avaka bogwa leigisi. ");
INSERT INTO kij_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","E Yaubada ikaibiga, kawala, “Ibodi kai kasi gigisa migawelu migawelu bisusinasi ovalu watanawa - makaisina takamkoma, avaka avaka biuwasi isim waitunesi, e avaka avaka biuwasi isim kawailuwasi.” E bogwa ikaloubusisi makawala. ");
INSERT INTO kij_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","E mapaila valu watanawa isusinasi kai kasi gigisa migawelu migawelu, e Yaubada saina iyomwasali nanola avaka bogwa leigisi. ");
INSERT INTO kij_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","E bogwa leibogi eiyam kaukwau, baisa yam kwaitolula. ");
INSERT INTO kij_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","E Yaubada ikaibiga, kawala, “Ibodi kaitapa wa labuma bikelituli yam deli bogi, e deli bikibuboti kala yam taitu, kabosigugula e deli kweluvala paka kala tuta. ");
INSERT INTO kij_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","E bikatasi metoya wa labuma, paila bisimitali valu watanawa.” E bogwa ikaloubusi makawala. ");
INSERT INTO kij_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","E Yaubada ibubuli kaiyu kaitapa kaivakaveka, kalasia bikaraiwaga otutala yam, e tubukona bikaraiwaga otutala bogi. E tuvaila ibubuli utuyam. ");
INSERT INTO kij_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Oluvi isaili kaitapa makaisina wa labuma paila bisimitali valu watanawa, ");
INSERT INTO kij_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","paila bikaraiwagasi tutala wa yam wa bogi, e deli bitavilevi metoya lumalama deli dudubila. E Yaubada saina iyomwasali nanola avaka bogwa leigisi. ");
INSERT INTO kij_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","E bogwa leibogi, eiyam kaukwau, baisa yam kwaivasila. ");
INSERT INTO kij_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","E Yaubada ikaibiga, kawala, “Ibodi sopi bikasewoki nammomova migawelu migawelu, e deli gawata bikasewoki mauna nayoyowa.” ");
INSERT INTO kij_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","E Yaubada ibubuli mimilisi dokanikani, e maunela bolita kasi gigisa migawelu migawelu, e deli mauna nayoyowa kasi gigisa migawelu migawelu. E Yaubada saina iyomwasali nanola avaka bogwa leigisi. ");
INSERT INTO kij_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ikabwaili minasina komwaidona, e iluki minasina isisuaisi obolita kidamwa biunigeyaisi bimiliaki bolita. E iluki mauna nayoyowa biunigeyaisi bimiliaki valu. ");
INSERT INTO kij_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","E bogwa leibogi, eiyam kaukwau, baisa yam kwailimala. ");
INSERT INTO kij_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","E Yaubada ikaibiga, kawala, “Ibodi maunela odabala pwaipwaia kasi gigisa migawelu migawelu bikaloubusisi, nabubolodila deli nabulutuvalu, navakaveka deli nakikekita.” E bogwa ikaloubusi makawala. ");
INSERT INTO kij_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","E bogwa Yaubada ibubuli komwaidona, e saina iyomwasali nanola avaka bogwa leigisi. ");
INSERT INTO kij_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","E Yaubada ikaibiga, kawala, “Baisa tuta bitabubulaisi tomota matausina igau migisi kasi gigisa deli goli kasi bububula komwaidona makawala wala yakidasi. Matausina bikaraiwogaisi yena, mauna nayoyowa deli goli mauna komwaidona nabulutuvalu deli nabubolodila, navakaveka deli nakikekita.” ");
INSERT INTO kij_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","E mapaila Yaubada ibubuli tomota e migisi kasi gigisa makawala matauna kala gigisa. Ibubuli tau deli vivila. ");
INSERT INTO kij_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ikabwaili matausina e ikaibiga, kawala, “Ibodi litumia bidalasi kidamwa biunigeyaisi tubumia, e bitokwabitamsi paila valu watanawa kala kaisisu. Bavigakaimi bukutokwaraiwagasi paila yena, mauna nayoyowa, deli goli komwaidona maunela lawodila. ");
INSERT INTO kij_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Bogwa lasaili avaka avaka isim waitunesi deli avaka avaka isim kawailuwasi, paila bukukwamkwamsi. ");
INSERT INTO kij_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Pailaga mauna nabubolodila deli mauna nayoyowa bogwa lasaili mnumonu deli kai yekwesisi paila bikamkwamsi.” E bogwa ikaloubusi makawala. ");
INSERT INTO kij_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yaubada igisi komwaidona avaka bogwa ibubuli e saina iyomwasali nanola. E bogwa eibogi, eiyam kaukwau, baisa yam kwailima kwaitalela. ");
INSERT INTO kij_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","E mapaila Yaubada ivigimkulovi kala bububula vavagi komwaidona walakaiwa deli watanawa. ");
INSERT INTO kij_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","E kwailima kwaiyuwela yam Yaubada eivinaku la bububula komwaidona baisa avaka leiuvagi, e ivaiwasiga paisewa. ");
INSERT INTO kij_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","E bogwa ikabwaili yam kwailima kwaiyuwela e ikatupaliga makwaina yam kwaiveka paila matutowena leivigimkulovi bububula, e ivaiwasi. ");
INSERT INTO kij_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Baisa makawala goli leivigaki leibubuli walakaiwa deli watanawa ambaisa ambaisa vavagi komwaidona. Tutala Guyau Yaubada ibubuli vavagi komwaidona walakaiwa deli watanawa, ");
INSERT INTO kij_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","e gala avai kai isisu odabala pwaipwaia. Paila uula Yaubada gala wala biwitali kuna, e tuvaila gala availa bibiguli makwaina pwaipwaia. ");
INSERT INTO kij_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mitaga sopi biludulodu metoya olumoulela pwaipwaia biiyopututu. ");
INSERT INTO kij_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","E Guyau Yaubada iyeili sitana pwaipwaia metoya opwaipwaia e ivigaki taitala tau. E ikayoki yagisa deli momova okabulula, e matauna tau ivitouula la momova. ");
INSERT INTO kij_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","E Guyau Yaubada ibiguli buyagu makubilana Ideni opilibomatu, e baisa isaili matauwena tau leibubuli. ");
INSERT INTO kij_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","E Guyau Yaubada ivali kai kaiminibwaita kasi gigisa migawelu migawelu isusinasi iuwasi kawailuwa bwaina sainela. E oluwalela makwaina bagula kaiyu kai itotusi, kaitala makaina kaila momova, e kaiyuwela makaiwena uulela kabitam paila vavagi bwaina deli vavagi gaga. ");
INSERT INTO kij_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","E sakala ititayelu olopola Ideni, e ivinumli bagula makwaina. Metoya baisa Ideni ikatuvi ivigaki waya kaduyovasi. ");
INSERT INTO kij_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kaduyomatala waya makaduyona yagala Pisoni, ititayelu olopola mapilana valu Abila. ");
INSERT INTO kij_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Goula kwevivivila ikanaiki baisa, e bulami maiina saina simasimina, deli dakuna kwekavikavila mwau mipusi.) ");
INSERT INTO kij_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kaduyuwela waya yagala Gioni ititayelu olopola mapilana valu Kusa. ");
INSERT INTO kij_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kaduyotolula waya yagala Tegirisi, makaduyona ititayelu mapilana Asiria opilibomatu. E kaduyovasila waya makaduyona Yupereiti. ");
INSERT INTO kij_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","E Guyau Yaubada isaili tau matauna olopola buyagu Ideni paila bibiguli deli biyamati. ");
INSERT INTO kij_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","E Guyau Yaubada iluki matauna, kawala, “Ibodaim bukukoma kai kaiuwala komwaidona olopola bagula, ");
INSERT INTO kij_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mesinaku wala makaina kai uulela kabitam paila vavagi bwaina deli vavagi gaga. Gala ibodi bukukoma kaiuwala kai makaina. Kidamwa bukukoma, yam makwaina wala bukukwaliga.” ");
INSERT INTO kij_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","E Guyau Yaubada ikaibiga, kawala, “Ka, gala avaka kala bwaina tau matauna kalamwaleta wala bisisu. Bogwa babubuli taitala lubaila kidamwa bipilasi matauna.” ");
INSERT INTO kij_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Mapaila iyeili sitana pwaipwaia metoya opwaipwaia, e ivigaki mauna nasigisagina deli nayoyowa kasi gigisa migawelu migawelu. E imai minasina bimaisi omatala tau kidamwa bisaiki igasi. E makawala goli komwaidona minasina isim wala igasi. ");
INSERT INTO kij_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Matauna tau bisaiki igasi komwaidona mauna nayoyowa deli nasigisagina. Mitaga gala goli natana minasina isisu bisaiki lubaila kidamwa bipilasi matauna. ");
INSERT INTO kij_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","E oluvi Guyau Yaubada ikaraiwogi matauna tau bimisiwoya sainela. Tutala immasisi, e Guyau Yaubada ikisasi visiala kaitala e oluvi iluvisosuvau wowola matauwena. ");
INSERT INTO kij_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ikau visiala ivigaki natana vivila e ivakouli minana imiaki matauna. ");
INSERT INTO kij_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","E tau matauna ikaibiga, kawala, “Ka, bogwa labani taitala migima migitinidesi wala. Totuwanela metoya ototuwanegu, e vilionala metoya ovilionegu. Bogwa ladoki minana yagala ‘Vivila’ paila uula eisunapula metoya baisa tau.?? ");
INSERT INTO kij_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Baisa uula tau bisilavi tamala inala, bivakouli la kwava, e kasitaiyu bivigakaisi uwosi makawala taitala. ");
INSERT INTO kij_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","E kasitaiyu wala tau sola vivila tokikimwadu wala, mitaga gala wala immosilasi. ");
INSERT INTO kij_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","E baisa tuta minana keiyuna saina nakabitam mitaga la katuduvidavi saina ikalisuwoli mauna komwaidona avaka Guyau Yaubada ibubuli. E keiyuna ikatupoi minana vivila, kawala, “Ve! Ki - mokwitala Yaubada eilukwaimi gala bukukwamsi kawailuwala kaitala kai metoya olopola bagula?” ");
INSERT INTO kij_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","E minana ivitakaula, kawala, “Ibodi bakakoma avai kai avai kai kaiuwasi olopola bagula makwaina. ");
INSERT INTO kij_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mesinaku wala makaina kai oluwalela bagula Yaubada ilukwaima galaga bakakoma kaiuwala makaina, kaina bakakabikoni. Kidamwa bakavagi makawala, e igau bakakaliga kamataiyu.” ");
INSERT INTO kij_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Keiyuna ikaibiga, kawala, “Ve! Mabigana biga gala mokwita, gala wala bukukwaligasi. ");
INSERT INTO kij_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yaubada ilivala baisa uula inikoli tuta matutona bukukomasi yokomi makawala wala Yaubada, paila bukunikolaisi vavagi bwaina deli vavagi gaga.” ");
INSERT INTO kij_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Vivila igisi kai makaina saina kaiminabwaita, deli idoki kawailuwala kala kamkwam bwaina, e magila wala bibani kabitam. Mapaila minana ikau mimilisi ikoma. Oluvi isaiki la mwala, e deli ikam. ");
INSERT INTO kij_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tutala eikamsi iwokuva, e itapuloki ninasi, e ikatetasi kidamwa tokikimwadu matausina. E mapaila ikauwaisi yekwesila kai ibisitukwaisi e isikamsi. ");
INSERT INTO kij_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Koyavi makwaina ilagaisi Guyau Yaubada ililoula olumoulela bagula, e mapaila isipepunisi metoya omatala matauna oyalela kai. ");
INSERT INTO kij_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mitaga Guyau Yaubada idou matauna tau, kawala, “Mwa! Ambaisa yoku?” ");
INSERT INTO kij_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ivitakauloki, kawala, “Alagaim olumoulela bagula, e agu kokola asipepuni metoya baisa yoku, paila yeigu tokimwadu wala.” ");
INSERT INTO kij_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","E Yaubada ikatupoi, kawala, “Availa ilukwaimi baisa lokukikimwadusi? Ki, kukomasi makwaina kawailuwa, makwaina lalukwaimi gala bukukomasi?” ");
INSERT INTO kij_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","E matauna ivitakauloki, kawala, “Minawenala vivila bogwa lokusaili kamataiyu, e minawena leisakaigu kawailuwa makwaina, e lakoma.” ");
INSERT INTO kij_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","E Guyau Yaubada ikatupoi minana, kawala, “Avaka paila lokuvagi baisa?” E minana ivitakauloki, kawala, “Keiyuna isipulokaigu e akoma.” ");
INSERT INTO kij_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","E Guyau Yaubada iluki minana keiyuna, kawala, “Yoku bukubani mipuki paila baisa. Yoku wala kammwaleta oluwalaisi mauna komwaidosi bukubani makwaina mipuki. Lagaila e tuta komwaidona bukusigisagina metoya olopom e deli bukukwamkwam tubumyou tuta komwaidona avai tuta m momova isisu. ");
INSERT INTO kij_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","E bavigakaimi yoku deli vivila tilaula bisisu oluwalaimi. Vivila dalela deli yoku dalem komwaidosi bitilaulasi. Vivila dalela bikatumkumku pwanetam, e yoku bukugadi kaigadula kaikesi.” ");
INSERT INTO kij_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","E iluki vivila, kawala, “Igau bakatumkulovi kam mwau bila om susuma, e kam mmayuyu avai tuta m valulu. Ilagoli tuta tuta bukunanamsa peula paila m mwala, mitaga matauna kam todabala.” ");
INSERT INTO kij_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","E iluki tau, kawala, “Ki, yoku bogwa lokunakaigali m kwava la biga, e lokukoma makwaina kawailuwa. E makwaiwena lalukwaim gala bukukoma baisa tuta. Paila baisa avaka bogwa lokuvagi e pwaipwaia bogwa bivigaki mwau baisa yoku. Tuta oluvi bukupaisewa peula paila m kwaisisu, e bukubagula titoulem kʹam e bukukwam. ");
INSERT INTO kij_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Paila bogwa mnumonu gaga deli kaitasusila toyo kaigunigwaini bisusinasi, deli yoku bogwa kanipugwa kalagila bukukwam. ");
INSERT INTO kij_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","E igau yoku bukupaisewa peula bipolu kam kwapololu. Bukubiguli avaka avaka kam kawailuwa, tatoula wala bukukwaimilavau opwaipwaia baisa labubulaim. E yoku bogwa labubulaim metoya opwaipwaia e igau bukumila pwaipwaia tuvaila.” ");
INSERT INTO kij_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","E Adam idoki yagala la kwava Ibi. Paila minawena tomota komwaidona mina watanawa inasi. ");
INSERT INTO kij_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","E Guyau Yaubada ivigaki kasi kakapula Adam sola la kwava metoya mauna kanuvinesi, e ivisikoma matausina. ");
INSERT INTO kij_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","E Guyau Yaubada ikaibiga, kawala, “Tuta baisa tau matauna makawala wala yakidasi, e eitapuloki nanola paila avaka bwaina deli avaka gaga. Galaga batagwala bikam kaiuwala metoya makaina kaila momova. Paila kidamwa bikoma, la momova bogwa bikanuvagasi.” ");
INSERT INTO kij_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Mapaila Guyau Yaubada iyabi matauna isilavi makubilana Ideni, ivigaki matauna bibiguli pwaipwaia makwaina, ambaisa goli Yaubada eibubuli matauna. ");
INSERT INTO kij_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","E mapilana opilibomatu bagula otokwedala Yaubada isaili mimilisi tommomova, deli kavitala puluta kavilululu makavina tuta komwaidona bititavina ambaisa ambaisa wala. E baisa kala silaboda gala availa bimakaia katitaikinela makaina kaila momova. ");
INSERT INTO kij_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","E oluvi Adam imasisisi sola la kwava e minana bogwa isuma. E iuni latula tau, e ikaibiga, kawala, “Metoya Guyau la pilasi bogwa labani taitala latugu.” Mapaila ivabu yagala e idoki matauna Keni. ");
INSERT INTO kij_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","E igau oluvi minana iviluluvau taiyuwela latula tau, matauna yagala Eibeli. Eibeli matauna toyamata sipi, mitaga Keni matauna tobigubagula. ");
INSERT INTO kij_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Igau oluvi Keni imai mimilisi la tayoyuwa e isemakavi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Mitaga Eibeli imai natana la sipi latula kuluta, e ikatumati minana e isemakavi makabilasina kabilipusoposa baisa Guyau. E Guyau saina ikabwaili Eibeli deli la semakavi. ");
INSERT INTO kij_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mitaga ipaiki Keni deli la semakavi. Keni saina igibuluwa e itakulukulu deli kala leiya. ");
INSERT INTO kij_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","E Guyau iluki Keni, kawala, “Avaka paila kam leiya? Avaka paila m takulukulu e migim eidavila? ");
INSERT INTO kij_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kidamwa bogwa lokuvagi vavagi duwosisia, ibodaim bukugigila. Mitaga lokuvagi vavagi gaga, e mitugaga bogwa eititayaya om lulu. E mitugaga magila bikaraiwogaim, mitaga yoku ibodaim bukutuma mitugaga.” ");
INSERT INTO kij_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","E Keni iluki bodala Eibeli, ikaibiga, kawala, “Bitala obaleku.” Tuta makwaina bogwa ilosi obaleku, Keni itovilaki bodala e ikatumati matauna. ");
INSERT INTO kij_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Guyau ikatupoi Keni, kawala, “Ambaisa bodam Eibeli?” Ivitakauloki ikaibiga, kawala, “Gala anikoli. Avaka kudoki, ki, yeigu bodagu kala toyamata kaina?” ");
INSERT INTO kij_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","E Guyau ikaibiga, kawala, “Avaka uula bogwa kuvagi vavagi makwaina saina gaga sainela? Bodam buyavila ikayubabai baisa yeigu metoya opwaipwaia, makawala kaigila idoudou paila kaimapu. ");
INSERT INTO kij_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Mapaila yoku bavabwaim watanawa deli isim kam bulubolata, e gala tuvaila bukubagula pwaipwaia makwaina. Paila bodam buyavila bogwa ikogiaki pwaipwaia makawala pwaipwaia isim wodola, e tutala kukwatumati bodam, e pwaipwaia ikapogega bimom wala buyavi. ");
INSERT INTO kij_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Kidamwa bukuvigikoni kudoki bukuvaula kawailuwa metoya opwaipwaia makwaina, gala bukubani kabinaisi. E deli yoku bukuvagi togumayobu wala gala isim m kwabosisu mitaga bukutitavina wala ovalu watanawa komwaidona.” ");
INSERT INTO kij_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","E Keni iluki Guyau, kawala, “Saina mwau baisa yeigu paila mipuki makwaina bakeula. ");
INSERT INTO kij_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lokuyabaigu metoya omatam e gala tuvaila batobigubagula. E yeigu bivagi togumayobu gala tolegu e batitavina wala baisa ovalu watanawa. Kidamwa availa bibodaigu ambaisa, bikatumataigu wala.” ");
INSERT INTO kij_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mitaga Guyau iluki matauna, kawala, “Gala. Kidamwa availa bikatumataim, matauna bibani kala mipuki mapula bikeula sivalima sivayu.” Mapaila Guyau isaili kala kabutuvatusi baisa Keni, kidamwa availa bibodi matauna, gala bikatumati. ");
INSERT INTO kij_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","E mapaila Keni itokaia isilavi Guyau. E ila imili valu mapilana idokaisi Lomakava, baisa mapilana Ideni opilibomatu. ");
INSERT INTO kij_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","E Keni sola la kwava iunaisi litusi tau, idokaisi matauna yagala Inoki. Oluvi Keni ibudi valu makwaina idoki mapilana tuvaila Inoki, makawala goli yagala latula. ");
INSERT INTO kij_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inoki latula tau idoki yagala Irada, matauna latula yagala Meuyeili e Meuyeili latula tau idoki yagala Metuseili, e Metuseili latula Lameki. ");
INSERT INTO kij_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Matauna Lameki ivilayawa la kukova nayu, natana la kwava yagala Ada, e nayuwela Sila. ");
INSERT INTO kij_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","E minana Ada ivilulu Yabali, matauna tubusi matausina isim wonesia bulutuvalu deli isisuaisi obuliyoyova. ");
INSERT INTO kij_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Matauna bodala yagala Yubali e matauwena tubusi komwaidosi tomwasawa gita deli loloni. ");
INSERT INTO kij_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Minana Sila ivilulu latula tau yagala Tubali Keni, matauna kala tobubuli tanumnumta barasi deli aiyani. E Tubali Keni luleta Naama. ");
INSERT INTO kij_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lameki iluki la kukova, kawala, “Yokomi Ada som Sila, kulagaigusi. Bogwa lakatumati toulatila paila matauna iwaigu. ");
INSERT INTO kij_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kidamwa availa bikatumati Keni, e ibodi wala kaimapula tailima taiyu bikaligasi. E ka, kidamwaga availa bikatumataigu, ibodi wala kaimapugu bikaligasi tailuwolima tailuwoyu tailima taiyu.” ");
INSERT INTO kij_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam sola la kwava iunaisi tuvaila taitala litusi tau. Ikaibiga minana, kawala, “Yaubada bogwa isakaigu latugu tau, kaimapula Eibeli, matauna Keni eikatumati.” E minana ivabu yagala idoki Seti. ");
INSERT INTO kij_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","E Seti iuni latula ivabu yagala idoki Inosi. E tuta makwaina tomota ivitouulasi bikavitagaisi Yaubada yagala igibumaboma paila si tapwaroru. ");
INSERT INTO kij_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Baisa yagasi matausina Adam tubula. (Avai tuta Yaubada eibubuli mina watanawa ibubuli makawala kala gigisa titoulela. ");
INSERT INTO kij_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Matauna ibubuli matausina tau deli vivila, ikabwaili matausina e idoki yagasi “Tomota.”) ");
INSERT INTO kij_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Avai tuta Adam kala taitu iboda 130, matauna iuni guditala latula tau magudina kala gigisa makawala titoulela, e ivabu yagala Seti. ");
INSERT INTO kij_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","E igau Adam isisu tuvaila 800 taitu. E matauna tuvaila iunai litula, ");
INSERT INTO kij_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","e kala taitu komwaidona iboda 930 matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Avai tuta Seti kala taitu iboda 105, matauna iuni guditala latula tau, yagala Inosi, ");
INSERT INTO kij_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","e igau isisu tuvaila 807 taitu. E matauna tuvaila iunai litula, ");
INSERT INTO kij_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","e kala taitu komwaidona iboda 912 matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Avai tuta Inosi kala taitu iboda 90, matauna iuni guditala latula tau, yagala Kenani, ");
INSERT INTO kij_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","e isisu tuvaila 815 taitu. E matauna tuvaila iunai litula, ");
INSERT INTO kij_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","e kala taitu komwaidona iboda 905, matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Avai tuta Kenani kala taitu iboda 70, matauna iuni guditala latula tau, yagala Maalaleli, ");
INSERT INTO kij_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","e isisu tuvaila 840 taitu. E matauna tuvaila iunai litula, ");
INSERT INTO kij_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","e kala taitu komwaidona iboda 910 matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Avai tuta Maalaleli kala taitu iboda 65, e matauna iuni guditala latula tau, yagala Yaredi. ");
INSERT INTO kij_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","E isisu tuvaila 830 taitu. E matauna tuvaila iunai litula, ");
INSERT INTO kij_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","e kala taitu komwaidona iboda 895 matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Avai tuta Yaredi kala taitu iboda 162 matauna iuni guditala latula tau, yagala Inoki, ");
INSERT INTO kij_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","e isisu tuvaila 800 taitu. E matauna tuvaila iunai litula, ");
INSERT INTO kij_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","e kala taitu komwaidona iboda 962 matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Avai tuta Inoki kala taitu iboda 65 matauna iuni guditala latula tau, yagala Metusela. ");
INSERT INTO kij_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","E Inoki isisu tuvaila 300 taitu, e iveyawa deli Yaubada. E matauna tuvaila iunai litula; ");
INSERT INTO kij_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","matauna kala taitu komwaidona iboda 365. ");
INSERT INTO kij_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Matauna itugwali la tuta komwaidona deli wala Yaubada, e oluvi matauna itamwaumakava wala, paila Yaubada bogwa leikau matauna leilau. ");
INSERT INTO kij_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Avai tuta Metusela kala taitu iboda 187, matauna iuni guditala latula tau, yagala Lameki, ");
INSERT INTO kij_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","e isisu tuvaila 782 taitu. E matauna tuvaila iunai litula ");
INSERT INTO kij_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","e kala taitu komwaidona iboda 969 matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Avai tuta Lameki kala taitu iboda 182, matauna iuni guditala latula tau, ");
INSERT INTO kij_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","e ikaibiga kawala, “Metoya pwaipwaia makwaina, makwaina goli Guyau eibuloti e gwadi magudina igau bikiminum komwaidona kada mmayuyusi metoya komwaidona da pwaitukulasi,” mapaila ivabu yagala Nowa. ");
INSERT INTO kij_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lameki isisu tuvaila 595 taitu. Matauna tuvaila iunai litula ");
INSERT INTO kij_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","e kala taitu komwaidona iboda 777 matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Avai tuta Nowa kala taitu iboda 500, matauna iunai litula taitolu, yagasi Sem, Am, deli Yapeta. ");
INSERT INTO kij_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Omitibogwa, tomotala valu watanawa igalasi ilosi ambaisa ambaisa ovalu komwaidona. E tuta matutona bidubadu kapugopugula idalasi. ");
INSERT INTO kij_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","E mimilisi mina walakaiwa igisaisi minasina saina naminibwaita, mapaila ikauwaisi minasina availa availa nambwailisi. ");
INSERT INTO kij_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","E Guyau Yaubada ikaibiga, kawala, “Gala batagwala tomota si momova bikanigaga baisa ovalu watanawa. Ibodi wala tomota bibodaisi kaliga. Ka, metoya tuta baisa wala batagwala mina watanawa kasi taitu biboda lakatutala kweluwoyu, e gala availa bikalisuwoli baisa.” ");
INSERT INTO kij_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Wa yam makwaisina, e oluvi, mimilisi mina watanawa isisuaisi saina touwonaku saina topapeula matausina. Paila matausina dalesi mina walakaiwa goli. E matausina tommoyabogwa topapeula goli tokinabogwa ivagaisi bidubadu vavagi siligaga, e mapaila yam lagaila taluluwaisi matausina. ");
INSERT INTO kij_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tuta makwaina Guyau bogwa igisi mina watanawa si bubunela saina gaga deli si nanamsa gaga oninasi tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","E Guyau nanola ikivili paila ibubuli tomota isaili odabala pwaipwaia. Saina ikapisiki lopola paila la bububula, ");
INSERT INTO kij_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","e ikaibiga, kawala, “Bogwa laninavila paila labubuli mina watanawa tomotala deli maunela. Mapaila bakatudoum tomota komwaidosi deli mauna nasigisagina e deli mauna nayoyowa.” ");
INSERT INTO kij_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mitaga Guyau ininabwaila paila Nowa. ");
INSERT INTO kij_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Baisa makawala Nowa liliula. Nowa iuni litula tauwau kasitaitolu, Am, Sem, Yapeta. Nowa gala isim la sula, e matauna kalamwaleta tobwaila ola tubwa matubona. Tuta komwaidona Yaubada isivadulisi kasitaiyu Nowa. ");
INSERT INTO kij_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mitaga komwaidosi tomota imitugagasi omatala Yaubada, e si lakaipota ikaligiaki valu komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Yaubada imitakavati valu watanawa, e bogwa igisi saina mitugaga, paila tomota komwaidosi ibububunasi deli mitugaga tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Yaubada iluki Nowa, kawala, “Bogwa lanagi kidamwa bakatumtuwoli komwaidosi mina watanawa. Bakatudoum komwaidosi matausina paila saina si lakaipota ikasewoki valu watanawa. ");
INSERT INTO kij_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kula kunevi kai bwaina e kuteya m waga. Kusaili kalitutila olumoulela e kukwaibasi olumoulela deli otapwala. ");
INSERT INTO kij_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kuuvi waga uvaluwolima uvaluwotala uvalima uvatala kala wonaku, e deli uvaluwotala uvatala kala beiyaya e uvalima uvatala kala woloula. ");
INSERT INTO kij_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Odabala bisim kala sasa biboda katupwaila yamila oluviga katuvala. E makaina waga buligatolu e opapala kusaili kabosusuvi. ");
INSERT INTO kij_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Paila igau bawitali dadoya bitayelu odabala pwaipwaia bikatudidaimi vavagi komwaidona kwemmomova. E vavagi komwaidona kwemmomova odabala pwaipwaia bikaligasi, ");
INSERT INTO kij_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","mesinaku wala yokomi deli litumwa gala bukukwaligasi, paila bogwa bakabutaimi. Kusuvi wa waga deli m kwava e litumwa tauwau deli si kukova. ");
INSERT INTO kij_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Kulau wa waga mauna nammwala deli nauvila kasi gigisa migawelu migawelu metoya nasigisagina deli nayoyowa, e bukuyamati bimwamovasi. ");
INSERT INTO kij_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kukwedidagi kami kalaga, deli mauna kasi kawailuwa migawelu migawelu.” ");
INSERT INTO kij_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nowa bogwa ivagi vavagi komwaidona makawala Yaubada ikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Guyau ikaibiga baisa Nowa, kawala, “Bogwa lamitakavati mina watanawa komwaidosi, e lavitusaim kidamwa yoku kammwaleta wala m bubunela duwosisia. Mapaila bukusilasi kusuvisi olopola waga deli litumwa komwaidosi. ");
INSERT INTO kij_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Minasina mauna ibodaimi bukukwamkomasi bukukwau nalima nayu nammwala deli si kukova metoya migatala migatala minasina, e kukwedidagi. Mitaga minasina bomikikila bukukwamkomasi ibodi wala bukukwau natana wala namwala sola la kwava metoya migatala migatala, e kukwedidagi minasina makawala. ");
INSERT INTO kij_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","E tuvaila kukwau nalima nayu nammwala deli si kukova metoya migatala migatala minasina nayoyowa e kukwedidagi. Bukuvagaisi makawala kidamwa komwaidosi mauna minasina bisisuaisi nammomova. Mwada goli igau bikaimilavausi bilosi odabala pwaipwaia, e baisa mauna nasigisagina migawelu migawelu bivilulaisi, e makawala wala minasina nayoyowa bipousi, makawala tokinabogwa. ");
INSERT INTO kij_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Igau kwailima kwaiyu yam biwokuva, bawitali kuna, bikunokuna kweluwovasi yam deli bogi, kidamwa bakatudidaimi komwaidona kwemmomova avaka avaka labubuli.” ");
INSERT INTO kij_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","E Nowa bogwa ivagi vavagi komwaidona makawala Guyau ikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Tuta makwaina valu watanawa idadoya, e Nowa bogwa kala taitu lakatulima lakatutala. ");
INSERT INTO kij_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","E matauna la kwava deli litusia tauwau deli si kukova isilasi isuvisi wa waga olopola kidamwa bikwalasi paila dadoya. ");
INSERT INTO kij_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Mapaila Nowa ilau minasina mauna nasigisagina deli mauna nayoyowa wa waga makawala Yaubada la karaiwaga. E migawelu migawelu ikau natana namwala sola navivila, kaina minasina ibodi kamkwam kaina bomikikila kamkwam. ");
INSERT INTO kij_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Kwailima kwaiyu yam oluvi, dadoya iviloubusi. ");
INSERT INTO kij_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Tuta makwaina Nowa kala taitu iboda lakatulima lakatutala, e tubukona nayuwela kala yam kweluwotala kwailima kwaiyu, e oluvi itilibwabwau ovalu watanawa kala utuwotu komwaidona igigibwabulasi e labuma ponanela iulaim e dadoya ititayelu. ");
INSERT INTO kij_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","E kuna ikapusi ovalu watanawa kweluwovasi yam deli bogi. ");
INSERT INTO kij_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Yam makwaina wala Nowa deli la kwava ipelasi wa waga deli litusia taitolu Sem, Am, Yapeta, deli si kukova. ");
INSERT INTO kij_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","E, isuvisi deli mauna migawelu migawelu nabulutuvalu deli nabubolodila navakaveka deli nakikekita migawelu migawelu mauna nayoyowa. ");
INSERT INTO kij_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Mauna nammwala deli navivila migawelu migawelu minasina nammomova isusuvisi deli Nowa, ");
INSERT INTO kij_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","makawala Yaubada bogwa ikaraiwogi. Bogwa isuvisi deli Nowa, e oluvi Yaubada ikatubodi yoyu. ");
INSERT INTO kij_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","E dadoya isisu wala kweluwovasi yam deli saina talia kwaiveka gagabila waga makaina bikopuwi. ");
INSERT INTO kij_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Tuvaila goli sopi itiligougwau waga makaina ibubeu wala odabala dadoya. ");
INSERT INTO kij_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Dadoya itiligougwau ikatukuwosi koya kweuwonakusi. ");
INSERT INTO kij_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bogwa talia saina kwaiveka imili bolita kala malola odabala koya imwena iboda uvavasi. ");
INSERT INTO kij_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tuvaila komwaidona bubuli makwaisina kwemmomova idoumsi wala mauna nayoyowa deli mauna nasigisagina e deli tomota. ");
INSERT INTO kij_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Komwaidona avaka avaka deli si yagisa idoumlabasi wala. ");
INSERT INTO kij_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tuta makwaina Guyau bogwa eikatudoum bubuli komwaidona ovalu watanawa, tomota, mauna nasigisagina deli mauna nayoyowa e kesalaga imovasi baisa Nowa deli litula deli goli minasina wa waga olopola. ");
INSERT INTO kij_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","E dadoya gala sitana ibusi, isisu wala kala bawa yam lakatutala kweluwolima, e oluvi ivitouula bibusi. ");
INSERT INTO kij_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Yaubada gala ilumwelavi Nowa deli komwaidona minasina mauna isisuaisi deli matauna wa waga. E mapaila iwitali yagila biuu, e sopi ivitouula ibubusi. ");
INSERT INTO kij_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tuvaila tulubwabwau kala utuwotu deli dadoya kala ponana metoya wa labuma ikatubodi, e kuna iwokuva idodewa. ");
INSERT INTO kij_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Lakatutala kweluwolima yam sopi bogwa eibubusi watanawa. ");
INSERT INTO kij_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tubukona nalima nayuwela kala yam kweluwotala kwailima kwaiyu, waga makaina isila odabala koya Ararata. ");
INSERT INTO kij_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","E bogwa eiboda naluwotalela tubukona kala yam ikugwa dubasi wala koya iyoulapulasi mitaga sopi igau wala ibubusi. ");
INSERT INTO kij_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Kweluwovasi yam bogwa leiwokuva e Nowa iulaim waga tabodala kaduyokekita. ");
INSERT INTO kij_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","E iwitali sikweikwa ila, mitaga gala ikaimilavau iyoyowa wala ititavina igauga sopi imidamada. ");
INSERT INTO kij_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","E oluvi Nowa iwitali bubuna ila bigisi sopi kaina bogwa eimada. ");
INSERT INTO kij_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mitaga sopi igau wala ikuboli pwaipwaia e bubuna gala sitana ibani paila bitoli, e iyowa ikaimilavau wa waga e Nowa iyosali yamala ikau isewoya wa waga. ");
INSERT INTO kij_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Itulotula tuvaila kwailima kwaiyu yam oluvi iwitalivau bubuna ila. ");
INSERT INTO kij_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Eikoyavi ikaimilavau owodola ikavitau olibe yekwesila yatubovau e Nowa bogwa inikoli sopi bogwa eimada. ");
INSERT INTO kij_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Itulotula kwailima kwaiyu yam tuvaila, e oluvi iwitalivau bubuna ila. Tuta matutona gala ikaimilavau. ");
INSERT INTO kij_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Lakatulima lakatutala kwaitala Nowa kala taitu e tubukona kala vitouula e yamla kwaitala, e sopi bogwa imada. Nowa waga kala yoyu iulaim e itadoyai igisi pwaipwaia dabala sitana imada. ");
INSERT INTO kij_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","E tubukona nayuwela kala yam kweluwoyu kwailima kwaiyu e pwaipwaia bogwa ilubulabu. ");
INSERT INTO kij_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","E Yaubada iluki Nowa, ikaibiga, kawala, ");
INSERT INTO kij_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Kusunapulasi metoya wa waga, yoku, m kwava, litumwa tauwau deli si kukova. ");
INSERT INTO kij_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bukusunupuloi mauna komwaidona nayoyowa deli nasigisagina. Paila igau tuta oluvi bidalasi ovalu watanawa bikaligiaki.” ");
INSERT INTO kij_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Bogwa isunapulasi Nowa sola la kwava litusia tauwau deli si kukova. ");
INSERT INTO kij_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Komwaidona mauna nasigisagina deli nayoyowa isunapulasi metoya wa waga ilokaiasi osi boda migatala migatala. ");
INSERT INTO kij_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nowa ikaliai kabolula bigabu lula baisa Guyau. Inagi bikau migatala migatala metoya minasina nasigisagina deli nayoyowa, e ivigaki lula. Ikatumati minasina, e namwaidosi igibuki lula. ");
INSERT INTO kij_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Guyau isikoni maiina saina iyebwaili, e titoulela ikaibiga, kawala, “Gala tuvaila watanawa tomotala bakatudoumvau, paila avaka tomota bogwa eivagaisi. Paila bogwa lanikoli matausina metoya osi tuta tubovau si nanamsa gaga wala. E gala tuvaila bakatudoum vavagi kwemmomova ovalu watanawa makawala bogwa lavigaki tuta matutona. ");
INSERT INTO kij_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","E bogwa makawala valu watanawa tutala, bogwa bisisu kweluvala sopu kweluvala tayoyuwa. E tuta komwaidona bukulumkolaisi kala tuta tula kala tuta yuviyavi. Bogwa bisisu kweluvala tula kweluvala yuviyavi, e yam deli bogi gala wala biwokuva.” ");
INSERT INTO kij_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Yaubada ibigibwaili Nowa deli litula, ikaibiga, kawala, “Magigu bukuunaisi litumia bibidubadu e bidalasi bimiliaki valu watanawa komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mauna nasigisagina deli nayoyowa, deli yena bikukolaimi. Komwaidona minasina wala mi kabokwaraiwaga. ");
INSERT INTO kij_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Baisa tuta gagabila bukukwatumkulovaisi uvagila kamkwam metoya wa bagula, e bukukwamsi deli viliona. Paila baisa tuta asakaimi komwaidona minasina bukuvigakaisi kʹami. ");
INSERT INTO kij_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Kwaitala wala vavagi viliona kabilibuyavi gala bukukomasi. Uula lasilibodaimi paila momova isisu obuyavi. ");
INSERT INTO kij_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kidamwa avai tau bikatumati sola, matauna bibani mipuki. Kidamwa natana mauna bikamati tomota, bibani mipuki bikaliga. ");
INSERT INTO kij_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Paila yeigu Yaubada abubuli tomota makawala kaikobugu. Mapaila availa bikatumati taitala tomota, e sala bikeulasi lugwa bikatumataisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Ibodi bukuunaisi litumia bibidubadu e tubumia bimiliaki valu watanawa komwaidona.” ");
INSERT INTO kij_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Yaubada iluki Nowa deli litula tauwau, ");
INSERT INTO kij_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","kawala, “Baisa tuta bakabutu baisa yokomi deli tubumia, ");
INSERT INTO kij_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","deli komwaidona bubuli kwemmomova mauna nayoyowa deli nasigisagina deli vavagi komwaidona eisunapulasi metoya wa waga deli yokomi. ");
INSERT INTO kij_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Bakabutu baisa yokomi - metoya wa biga mabigasina, ka, akatotila kidamwa gala tuvaila bayogagi bubuli kwemmomova metoya odadoya, e gala tuvaila dadoya bikodidaimi valu watanawa. ");
INSERT INTO kij_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Baisa kabutuvitusila makwaina kabutu gala biwokuva baisa lavagi deli yokomi toyo bubuli kwemmomova, ");
INSERT INTO kij_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","baisa tuta lasaili makaina lubakaidoga olowalowa e baisa kala kabutuvatusi ulo kabutu baisa valu watanawa. ");
INSERT INTO kij_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","E avai tuta bamai lowalowa ovalu watanawa e bogwa bisisu lubakaidoga olowalowa, ");
INSERT INTO kij_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","baluluwai ulo biga katotila baisa yokomi deli bubuli komwaidona kidamwa gala tuvaila bakatudoum bubuli komwaidona metoya odadoya. ");
INSERT INTO kij_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Avai tuta lubakaidoga bitokaia olowalowa e yeigu bagisi e baluluwai makwaina kabutu gala biwokuva avaka lakabutu deli bubuli komwaidona kwemmomova odabala pwaipwaia. ");
INSERT INTO kij_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ka, baisa kabutuvatusi ulo biga katotila metoya baisa yeigu deli bubuli komwaidona ovalu watanawa.” ");
INSERT INTO kij_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","E matausina Nowa litula isunapulasi metoya wa waga, yagasi Sem, Am, Yapeta. (Matauna Am latula yagala Kenani.) ");
INSERT INTO kij_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Matausina kasitaitolu litula Nowa dalesi idalasi ikaligiaki komwaidona valu watanawa. ");
INSERT INTO kij_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa matauna tobigubagula, e matauna goli tovaulabogwa matamna waini. ");
INSERT INTO kij_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","E avai tuta matauna imom waini, baisa sopila peula, iwaiya kaibotutu e itaneku kala kwama e tokimwadu ikanukwenu ola bwala. ");
INSERT INTO kij_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","E avai tuta Am matauna tamala Kenani igisi tamala tokimwadu ikanukwenu, isunapula iluki sala. ");
INSERT INTO kij_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sem sola Yapeta ikauwaisi yatala kwama isailasi ovilavasi e itotuboulolasi ilokaisi tupwasi e ilokaiasi tumasi ivakanunuvaisi paila gala magisi bigisaisi tumasi tokimwadu. ");
INSERT INTO kij_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tuta makwaina Nowa ikaluyuvisi nanola ilagi avaka latula molagwadi ivigaki baisa matauna, ");
INSERT INTO kij_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ikaibiga, kawala, “Abuloti Kenani. Ibodi matauna bitopaisewa baisa tuwala. ");
INSERT INTO kij_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Bitayakawolaisi Guyau Sem la Yaubada. Sem bivigaki Kenani la topaisewa. ");
INSERT INTO kij_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ibodi Yaubada bivigaki Yapeta tubula bidalasi. Ibodi tubula bisisuaisi deli Sem tubula. E Yapeta bivigaki Kenani la topaisewa.” ");
INSERT INTO kij_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Dadoya bogwa leiwokuva e Nowa isisu iboda lakatutolu kweluwolima taitu. ");
INSERT INTO kij_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nowa kala taitu iboda lakatulima lakatuvasi kweluwolima e oluvi ikaliga wala. ");
INSERT INTO kij_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Matausina Nowa litula, Sem, Am, Yapeta. Matausina iunaisi litusia avai tuta dadoya leiwokuva. ");
INSERT INTO kij_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yapeta litula - Goma, Magogi, Madai, Yavani, Tubali, Meseki, deli Tirasi - matausina tubusia yagasi eitakasaisi makawala. ");
INSERT INTO kij_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Goma dalela mina Asikenasi, Ripati, deli Togama. ");
INSERT INTO kij_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavani dalela mina Elisa, Sipeini, Saipirosi, deli Rodesi; ");
INSERT INTO kij_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","matausina tubusia mabudona isisuaisi okowolawa deli wa simla. Matausina tubula Yapeta, isisuaisi dala ituwoli deli valu ituwoli, boda kwaitala kwaitala ililivalasi obonasi titoulesi. ");
INSERT INTO kij_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Am litula - Kusa, Itipita, Libia, deli Kenani - matausina tubusia yagasi eitakasaisi makawala. ");
INSERT INTO kij_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","E Kusa dalela mina Seba, Abila, Sabita, Raama, deli Sabiteka. E Raama dalela mina Seba deli mina Dedani. ");
INSERT INTO kij_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","E Kusa taitala latula yagala Nimrodi, matauna saina topeula valu watanawa iyoligigai komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","E metoya Guyau ola pilasi matauna ivigaki saina kala tovagi waiga, e baisa uula tomota ililivalasi kawasi, “Ibodi Guyau bivigakaim kam tovagi waiga makawala Nimrodi!” ");
INSERT INTO kij_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Okabovitouula, la kabokaraiwaga ilokaia Babiloni, Ereki, deli Akadi kwaitolu wala valu makwaisina isisuaisi mapilana Babilonia. ");
INSERT INTO kij_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","E metoya mapilana valu matauna ilokaia Asiria e ibudi valu mapilasina, Niniba, Reyoboti Iri, Kala ");
INSERT INTO kij_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","deli Reseni, makwaina valu itowalai Niniba deli vilouvekala Kala. ");
INSERT INTO kij_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","E Itipita dalela mina Lidia, mina Anam, mina Leyabi, mina Napitu, ");
INSERT INTO kij_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","mina Patirusi, mina Kasilu, deli mina Kiriti (matausina tubusia mina Pilisitia). ");
INSERT INTO kij_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","E Kenani litula - molitomoya Saidoni, e deli Eti - molagwadi matausina tubusia yagasi eitakasaisi makawala. ");
INSERT INTO kij_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kenani matauna tubula mina Yebusi, mina Amora, mina Gigasa ");
INSERT INTO kij_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","mina Ivi, mina Aka, mina Sini, ");
INSERT INTO kij_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","mina Abadi, mina Semara, deli mina Amati. E Kenani dalela iunigeyaisi e isipitalaisi valu. ");
INSERT INTO kij_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Mina Kenani kasi kaligei ila itobu Saidoni isuwa opilibolimila ila Gerara katitaikinela Gasa, e isuwa opilibomatu ila mapilana Sodom, Gomora, Adima, Seboiim katitaikinela Lasa. ");
INSERT INTO kij_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Matausina tubula Am isisuaisi dala ituwoli deli valu ituwoli, boda kwaitala kwaitala ililivalasi obonasi titoulesi. ");
INSERT INTO kij_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yapeta tuwala Sem, e matauna Sem tubusi komwaidosi mina Iberu. ");
INSERT INTO kij_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem litula - Elam, Asuri, Apakisadi, Luda, deli Aram - matausina tubusia yagasi eitakasaisi makawala. ");
INSERT INTO kij_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram tubula matausina mina Usa, Uli, Geteri, deli Meseka, ");
INSERT INTO kij_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apakisadi latula Sela, e matauna latula Eba. ");
INSERT INTO kij_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eba litula taiyu: taitala yagala Pelegi, paila uula igau ola tuta mina watanawa ilivisisi. E taiyuwela yagala Yokitani. ");
INSERT INTO kij_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","E Yokitani tubula mina Alomodadi, mina Selepa, mina Asarimaveta, mina Yera, ");
INSERT INTO kij_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","mina Adoram, mina Usali, mina Dikila, ");
INSERT INTO kij_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","mina Obali, mina Abimaeli, mina Siba, ");
INSERT INTO kij_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","mina Opira, mina Abila, deli mina Yobabi. Komwaidosi wala tubula Yokitani. ");
INSERT INTO kij_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Valu makwaisina ambaisa isisuaisi eivitouula Mesa e ila itobu Separa mapilana wa koya opilibomatu. ");
INSERT INTO kij_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Matausina Sem tubula isisuaisi dala ituwoli, deli valu ituwoli, boda kwaitala kwaitala ililivalasi obonasi titoulesi. ");
INSERT INTO kij_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","E komwaidona tomota mabudosina Nowa wala tubula, makawala boda kwaitala kwaitala, e makawala goli kala takasa metoya otubusia taitala taitala. Avai tuta dadoya leiwokuva boda komwaidona ovalu watanawa idalasi metoya Nowa litula. ");
INSERT INTO kij_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Omitibogwa, tomotala valu watanawa komwaidona bonasi kaigitinidesi wala, e si biga komwaidona makawala wala. ");
INSERT INTO kij_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ililoulasi mapilana opilibomatu e ibanaisi kwaitala kabayatila mapilana Babiloni, e ibudaisi valu isikailisi baisa. ");
INSERT INTO kij_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ilivalasi taitala baisa taitala, kawasi, “Ka, ibodi bitakauwaisi mlomwaluva pwaipwaia bitagabwaisi bikasai bimili dakuna.” E mapaila ikepupolaisi imili dakuna e ikikaliaisi, deli si kaibasi pwadidiweta pikipaki. ");
INSERT INTO kij_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ikaibigasi, kawasi, “E ka, bitakaliaiisi valu vilouveka deli kwaitala bwala bitakaliaiisi olopola makawala liku, bitatakasaisi bila ikapituki labuma. E mina watanawa biyakawolaidasi, e taga bitabutusi ambaisa ambaisa ovalu watanawa komwaidona.” ");
INSERT INTO kij_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","E baisa tuta Guyau ibusi ima bigisi makwaina valu vilouveka deli makaina liku avaka tomota eikaliaiisi. ");
INSERT INTO kij_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","E Guyau ikaibiga, kawala, “Ka, matausina tomota budotala wala e bonasi ililivalasi kaigitinidesi wala! E baisa avaka eiuvagaisi kala vitouula wala. Igau goli gagabila bivagaisi avaka avaka ikikau ninasi. ");
INSERT INTO kij_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ibodi bitabusisi tawaisi takipinigwaisi bonasi e taga bikatetasi avaka sesia ililivalaisi.” ");
INSERT INTO kij_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Mapaila Guyau ikatugai matausina ilosi ovalu watanawa komwaidona e iligaimwaisi wala kaliai. ");
INSERT INTO kij_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","E valu mapilana idokaisi Babiloni paila uula Guyau eikipinigu bonasi tolesi mapilana valu e ikatugai matausina ilosi ambaisa ambaisa. ");
INSERT INTO kij_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Baisa Sem tubula liliusi. Tutala dadoya bogwa leiwokuva, e kwaiyu taitu tuvaila, Sem kala taitu bogwa eiboda 100, matauna iuni guditala latula tau, yagala Apakisadi. ");
INSERT INTO kij_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","E igau matauna isisu tuvaila 500 taitu, e matauna tuvaila iunai litula. ");
INSERT INTO kij_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Avai tuta Apakisadi kala taitu iboda 35, matauna iuni guditala latula tau yagala Sela, ");
INSERT INTO kij_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","e igau, matauna isisu tuvaila 403 taitu, e iunai tuvaila litula. ");
INSERT INTO kij_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Avai tuta Sela kala taitu iboda 30, matauna iuni guditala latula tau, yagala Eba, ");
INSERT INTO kij_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","e igau matauna isisu tuvaila 403 taitu, e tuvaila iunai litula. ");
INSERT INTO kij_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Avai tuta Eba kala taitu iboda 34, matauna iuni guditala latula tau yagala Pelegi, ");
INSERT INTO kij_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","e igau matauna isisu tuvaila 403 taitu, e tuvaila iunai litula. ");
INSERT INTO kij_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Avai tuta Pelegi kala taitu bogwa eiboda 30, matauna iuni guditala latula tau yagala Reu, ");
INSERT INTO kij_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","e igau isisu tuvaila 209 taitu, e tuvaila iunai litula. ");
INSERT INTO kij_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Avai tuta Reu kala taitu bogwa eiboda 32, matauna iuni guditala latula tau yagala Serugi, ");
INSERT INTO kij_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","e igau isisu tuvaila 207 taitu, e iunai tuvaila litula. ");
INSERT INTO kij_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Avai tuta Serugi kala taitu bogwa eiboda 30, matauna iuni guditala latula tau, yagala Nayo, ");
INSERT INTO kij_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","e igau isisu tuvaila 200 taitu e tuvaila iunai litula. ");
INSERT INTO kij_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Avai tuta Nayo kala taitu bogwa eiboda 29, matauna iuni guditala latula tau, yagala Tira, ");
INSERT INTO kij_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","e igau, matauna isisu tuvaila 119 taitu, e tuvaila iunai litula. ");
INSERT INTO kij_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Avai tuta Tira kala taitu bogwa eiboda 70, matauna iuni litula, Eberam, Nayo, deli Erana. ");
INSERT INTO kij_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Baisa Tira tubula liliusi. E Tira litula Eberam, Nayo, Erana. E Erana latula yagala Lota. ");
INSERT INTO kij_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Erana ikaliga oviloutabula Ura, baisa mapilana Babilonia, e tamala igau wala tomomova isisu. ");
INSERT INTO kij_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Eberam la kwava yagala Serai, Nayo la kwava yagala Milika. E minana Milika deli bodala Isika tumasi Erana. ");
INSERT INTO kij_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","E mitaga Serai minana nakaliga, gala taitala latula. ");
INSERT INTO kij_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tira ivakouli latula Eberam deli tabula Lota matauna Erana latula, e yawala Serai minana Eberam la kwava, e deli matausina isilavaisi ovilouveka Ura mapilana Babilonia mwada bilosiga Kenani. E ilosi iviloubusisi valu Erana, e baisa isisuaisi. ");
INSERT INTO kij_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","E Tira isisu mapilana Erana kala taitu iboda lakatuyu kwailima, oluvi ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","E Guyau ikaibiga baisa Eberam, kawala, “Kusilavi baisa, m valu tatoum, veyamwa, e deli tamam la viloutoula kulokaiaga makwaina pwaipwaia bavitulokaim. ");
INSERT INTO kij_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","E basakaim tubumwa bibidubadu e tomota budoveka bikaloubusisi. E bayebwailim deli bavigaki yagam bikaligiaki kidamwa yoku tomitakwai. ");
INSERT INTO kij_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bamitukwaii matausina availa availa imitukwaiyaimsi, mitaga bakaluwou matausina availa availa bikaluwouwaimsi. E bamitukwaii komwaidosi mina watanawa metoya baisa yoku.” ");
INSERT INTO kij_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kweluwolima kweluwoyu kwailima kala taitu Eberam, e makwaina tuta ivitouula isilavi Erana makawala Guyau iluki matauna. E Lota deli matauna ilokaiasi. ");
INSERT INTO kij_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Eberam ivakouli la kwava Serai, deli bodala latula Lota deli komwaidona si guguwa deli la ula komwaidona isoguguwasi metoya Erana bilokaiasi Kenani. E tuta makwaina bogwa iviloubusisi Kenani, ");
INSERT INTO kij_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Eberam iluluvapela mapilana igau iviloubusi mapilana Sekem. E baisa goli valu bumaboma yagala Morei, e kaitala kai kaibumaboma itotu. E tuta matutona mina Kenani isisuaisi baisa. ");
INSERT INTO kij_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","E Guyau iyoumatila baisa Eberam ikaibiga, kawala, “Ka, valu mapilana bogwa basaiki tubumwa.” E tuta matutona wala Eberam ikaliai kabolula baisa Guyau, matauwena eiyoumatila baisa Eberam. ");
INSERT INTO kij_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Oluvi isaitaula ila mapilana opilibolimila e ibudi la kabosikaiwa baisa. Mapilana Beteli isisu opilikwaibwaga, deli mapilana Ai isisu opilibomatu. E Eberam isisu wa koya makwaisina oluwalaisi mapilasina valu. E baisa tuvaila ikaliai kabolula e itapwaroru baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","E oluvi isaitaula ila ambaisa ambaisa e ililoula bila mapilana Kenani opilibolimila. ");
INSERT INTO kij_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Mitaga mapilana Kenani molusaula eikaloubusi. E molusaula saina vakaigaga, mapaila Eberam isaitaula wala ilokaia opilibolimila iviloubusi Itipita, mwada tuta pikekita wala bisisu baisa. ");
INSERT INTO kij_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Avai tuta bogwa ivakatitaikina biluvipeili kaligeila Itipita ikaibiga baisa la kwava Serai, kawala, “Yoku vivila naminabwaita. ");
INSERT INTO kij_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Avai tuta mina Itipita bigisaimsi binikolaisi yoku ulo kwava e bikatumataigusi, e yokugwa bukubwaina. ");
INSERT INTO kij_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ka, ibodi bukuluki matausina kidamwa yoku luguta, e mapaila bitagwalasi yeigu basisu tomomova, e bimitukwaiyaigusi paila uula yoku.” ");
INSERT INTO kij_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Avai tuta iluvipeili kaligei ila Itipita e mina Itipita igisaisi mokwita wala la kwava saina naminabwaita. ");
INSERT INTO kij_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","E mimilisi tokwaraiwaga igisaisi minana e ilukwaisi guyau paila minana, paila saina naminabwaita, mapaila ivakoulisi minana ilauwaisi ola ligisa. ");
INSERT INTO kij_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","E guyau iyebwaili Eberam paila uula minana isaiki yuwovila sipi deli gota, bulumakau, ase, la ula, e deli kameli. ");
INSERT INTO kij_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","E mitaga tuta makwaina guyau bogwa ivakouli Serai ivigaki la kwava, e Yaubada iwitali bidubadu lelia mwau baisa matauna deli ligisa makwaina kala tosisu. ");
INSERT INTO kij_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","E oluvi guyau iwitali biga magila Eberam. E ikatupoi matauna, kawala, “Avaka lokuvagi baisa yeigu? Avaka paila gala kulukwaigu kidamwa minana m kwava? ");
INSERT INTO kij_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mitaga lokukwaibiga mwada minana lumta, e oluvi kutagwala avakouli minana avigaki ulo kwava. Ka, minawena m kwava isisu wala. Kulau bukulosi.” ");
INSERT INTO kij_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","E guyau ikaraiwogi la touwata ikauwaisi Eberam ikogalaisi matauna bisilavi Itipita deli la kwava deli goli komwaidona la guguwa. ");
INSERT INTO kij_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Eberam isilavi mapilana Itipita opiliyavata, e ila mapilana Kenani opilibolimila. E deli ilau la kwava deli komwaidona la guguwa. E matauna Lota deli ililoulasi. ");
INSERT INTO kij_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Eberam matauna saina bidubadu la guguwa, la sipi, la gota deli la bulumakau, e deli goli la siliba la goula. ");
INSERT INTO kij_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","E isilavi baisa, magila bila Beteli. Ililoula ila valu ituwoli ituwoli igau tutala iviloubusi valu makwaina omitibogwa eisisuaisi, baisa oluwalaisi Beteli deli Ai. ");
INSERT INTO kij_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","E mapilana kabolula eikaliibogwi isisu. Mapaila mapilana valu itapwaroru baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lota tuvaila isim la sipi la gota deli la bulumakau. Tuvaila goli litula tatoula deli la ula bidubadu. ");
INSERT INTO kij_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Mapaila mnumonu gala ibodi wa kwabila paila kasitaiyu matausina bisisuaisi gulitinidesi. Paila saina bidubadu si mauna. ");
INSERT INTO kij_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Mapaila vatai deli yowai itokaia oluwalaisi matausina eiyamataisi Eberam la mauna, deli matausina eiyamataisi Lota la mauna. (Wa tuta matutona mina Kenani deli mina Peresi isisuaisi valu mapilana.) ");
INSERT INTO kij_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","E Eberam ikaibiga baisa Lota, kawala, “Anigadaim taga vatai deli kominimani bisisu oluwalaida baisa ulo towotetila deli m towotetila. Paila yakida dala dilatala wala. ");
INSERT INTO kij_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ibodi bitatavilevi boda. Yoku bukunagi ammakabulona magim. E yoku bukula makabulona, e yeigu bala kabuluyuwela.” ");
INSERT INTO kij_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lota igigisi kwabila komwaidona e oluvi igisi saina kaduwonaku mapilana Yoridani oitayatila saina kwaiveka bilokaia Sowa. Baisa saina bidubadu sopi makawala Guyau la Bagula, kaina makawala pwaipwaiala Itipita. (Baisa Guyau igau gala bikatumtuwoli valu makwaisina Sodom deli Gomora.) ");
INSERT INTO kij_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Mapaila Lota inagi komwaidona oitayatilela Yoridani paila titoulela. E ilokaia opilibomatu. Baisa makawala matausina taiyu tauwau eilivisisi. ");
INSERT INTO kij_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Eberam isisu mapilana Kenani, mitaga Lota isikaili oitayatila ovilouvakaveka oluwalaisi, e ibudi la kabosikaiwa katitaikinela Sodom. ");
INSERT INTO kij_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tomota matausina si bubunela saina gaga e imitugagasi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Tuta makwaina Lota bogwa leila, e Guyau ikaibiga baisa Eberam, kawala, “Kutotu baisa e kutitovila kumitakavati ambaisa ambaisa, kuvitusi bibwaina. ");
INSERT INTO kij_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Paila bogwa basakaimi yoku deli tubumwa komwaidona pwaipwaia avaka lokugisi, e bukuvigakaisi mi vavagi gala wala biwokuva, bikanigaga. ");
INSERT INTO kij_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Bogwa basakaim tubumwa saina bidubadu, gala igagabila availa bikalau komwaidosi matausina. Makawala kala mwau gala gagabila availa bikalawa tubumyou komwaidona ovalu watanawa. ");
INSERT INTO kij_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tuta baisa, kula kuvakawoli pwaipwaia komwaidona paila igau basakaim makwaisina komwaidona paila yoku titoulem.” ");
INSERT INTO kij_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Mapaila Eberam iluvipeili la bwala ilau katitaikinela makaina kai kaibumaboma baisa Mamira mapilana Ebironi. E baisa ikaliai kabolula paila Guyau. ");
INSERT INTO kij_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","E taivasi gweguya isisuaisi mapilana, magisi bikabiliasi deli tailima gweguya ituwoli. E kasitaivasi gweguya yagasi Amrapela guyoula Babilonia, Arioka guyoula Elasa, Kedolauma guyoula Elam, e Tidali guyoula Goyim. E kasi tilaula tailima gweguya yagasi Bera guyoula Sodom, Birisa guyoula Gomora, Sina guyoula Adima, Semeba guyoula Seboiim, e taitala tuvaila guyoula Bela (kainaga Sowa). ");
INSERT INTO kij_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Paila kasitailima gweguya ivigakaisi si tokwabilia boda budotala, e itogugulasi oItayatilela Sidim, mapilana valu baisa tuta tadokaisi Milaveta Pilamata. ");
INSERT INTO kij_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Paila omitibogwa guyau matauna Kedolauma eiguyoi matausina eiboda kweluwotala kwaiyu taitu. Mitaga taitu kweluwotala kwaitolula eipakaisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","E taitu makwaina oluvi, matauna si guyau Kedolauma deli sala leimaisi deli si tokwabilia, e itomgwagasi odubasi mina Repa mapilana Asiteroti Kanaim, mina Susa mapilana Am, mina Ema mapilana Kiriataim ");
INSERT INTO kij_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","e mina Ora mapilana Edom okoyala. E ibokavilaisi komwaidosi matausina ilosi igau itotusi mapilana Eliparana oviloupakala opapala. ");
INSERT INTO kij_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","E oluvi itovilasi ikaimilavausi mapilana Kadesi. (Mitaga omitibogwa mapilana idokaisi yagala Enimisipata.) Mapaila iyoulisi komwaidona si valu mina Amaleki, e itomgwagasi odubasi mina Amora tolesi Asasoni Tamari. ");
INSERT INTO kij_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","E oluvi goli kabilia makwaina itokaia. Matausina guyousi Sodom, Gomora, Adima, Seboiim e Bela si tokwabilia itogugulasi, e ikatubaiasasi oItayatilela Sidim e ikabiliasi makawala ");
INSERT INTO kij_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","baisa matausina guyousi Elam, Goyim, Babiloni e Elasa. E guyau tailima ikabiliasi makawala baisa guyau taivasi. ");
INSERT INTO kij_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","E kasitailima gweguya mwada bisakaulasi. Mitaga mapilana valu ikasewa pwadidiweta saina pikipaki avaka tomota ikilikelisi bivigakaisi si kaibasi. E gweguyala Sodom deli Gomora ivigikonaisi bisakaulasi metoya kabilia, e ikikapusisi olumoulela pwadidiweta okabosilagi. E gweguya kasitaitolu isakaulasi ilosi wa koya ikwalasi wala. ");
INSERT INTO kij_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Matausina taivasi gweguya ikauwaisi komwaidona guguwa metoya Sodom deli Gomora, deli kaula, e ilosi. ");
INSERT INTO kij_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lota, matauna Eberam bodala latula, matauna isisu Sodom. E mapaila ivakoulisi matauna deli la guguwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mitaga taitala tau ila ikamituli komwaidona baisa Eberam matauna guma Iberu isisu katitaikinela makaina kai kaibumaboma. E tolikai yagala Mamira matauna tolela Amora. E matauna Mamira budala yagasi Esikoli, Aneri, e kasitaitolu goli deli Eberam bivigakaisi si tokwabilia budotala. ");
INSERT INTO kij_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eberam bogwa ilagi bodala latula iyosisi e idou ikatuguguli komwaidona matausina tokabilia ola valu, kasi bawa lakatutolu tailuwotala tailima taitolu matausina ivakulaisi taivasi gweguya okedala bilokaia Dani. ");
INSERT INTO kij_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","E matauna ivili la tokwabilia budotala budotala e wa bogi iwaiyasi kasi vituvatu. E bogwa leitomgwagasi. E ibokavilaisi matausina ilauwaisi Oba mapilana Damasiko opiliyavata. ");
INSERT INTO kij_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","E vavagi komwaidona makwaisina leikauwaisi ikaimilivau. E ikaimilivau Lota, e la guguwa komwaidona deli vivila, e tuvaila mimilisi tokwatupipi. ");
INSERT INTO kij_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Eberam bogwa itomgwaga kabilia baisa Kedolauma deli matausina gweguya, ikeiita ima. E Sodom guyoula ila ibodi matauna, oItayatilela Sabe. (Tuvaila idokaisi Guyau la Itayatila.) ");
INSERT INTO kij_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melikisedeki matauna guyoula Salem, tuvaila tolula baisa Yaubada Towalakaiwa Sainela, imai beredi deli waini baisa Eberam. ");
INSERT INTO kij_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ibigibwaili matauna deli ikaibiga, kawala, “E, ibodi Yaubada Towalakaiwa Sainela, matauna ibubuli labuma toyo watanawa, bikabwaili Eberam. ");
INSERT INTO kij_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ibodi bitayakawolaisi Yaubada Towalakaiwa Sainela matauna bogwa isakaim peula lokukwalisau kam tilaula.” E Eberam ikouguguli la guguwa komwaidona guloluwotala e ivili gulotala isaiki Melikisedeki. ");
INSERT INTO kij_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Guyoula Sodom ikaibiga baisa Eberam, kawala, “Kuyosi avai guguwa bogwa eilebwaisi metoya baisa yeigu mitaga ulo tomota komwaidosi kukwaimali kusakaigu.” ");
INSERT INTO kij_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Eberam ivitakauloki, kawala, “Alivala biga mokwita omatala Guyau matauna saina Towalakaiwa Yaubada, matauna ibubuli labuma deli watanawa, ");
INSERT INTO kij_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","gala kwaitala m guguwa bayusi, gala kaina yatala wotunu kaina katubukolela kaikila kaigigila. Ka, bakaimali komwaidona m guguwa. Mapaila gala igagabila igau bukulivala, kawam ‘Ka Eberam la guguwa eibidubadu, e uulotoula yeigu.’ ");
INSERT INTO kij_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Gala bakoumakavi kwaitala vavagi paila titoulegu metoya baisa yoku, mesinaku wala avaka ulo tokwabilia bogwa eikomasi. Mitaga ibodi matausina deli lakalosi, Aneri, Esikoli, Mamira bikauwaisi kasi vilavila.” ");
INSERT INTO kij_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Oluvi Eberam igisi kilisala, e ilagi Guyau iluki matauna, kawala, “Mwa! Eberam, taga bukukokola. Bogwa bakolaim mwada gala avai kabosilagi biyogagaim, e basakaim kam mapu kwaiveka.” ");
INSERT INTO kij_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Mitaga Eberam ivitakauloki, kawala, “Mwa! Guyau Yaubada, ki, m mapu makwaina avaka kala bwaina baisa yeigu? Paila gala isim litugwa. Ka, taitala wala bikau kaikeyagu, matauwena Eliesa guma Damasiko. ");
INSERT INTO kij_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Yoku gala kusakaigu litugwa, e taitala ulo ula bikau kaikeyagu.” ");
INSERT INTO kij_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","E ilagi Guyau ilukivau matauna, kawala, “Ka, matauna Eliesa m ula gala wala bikau kaikeyam, paila latum tatoum wala bikau makwaina.” ");
INSERT INTO kij_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","E Guyau ivakouli matauna isunapulasi okoukweda, e ikaibiga, kawala, “Kumitakavati labuma. Kuvigikoni bukukwalau kasi bawa utuyam. Paila ka, tubumwa bidalasi kasi bawa makawala minasina.” ");
INSERT INTO kij_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Eberam idubumi Guyau e mauula iyomwasali nanola e Guyau ikabwaili matauna. ");
INSERT INTO kij_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","E Guyau iluki matauna, kawala, “Yeigu wala Guyau yeigula lavisunupuloiyaim metoya Ura mapilana Babilonia, e lasakaim makwaina valu, lavigaki makawala m vavagi titoulem.” ");
INSERT INTO kij_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mitaga ivitakauloki matauna, kawala, “Guyau Yaubada, ammakawala gagabila banikoli kidamwa baisa ulo vavagi tatougu?” ");
INSERT INTO kij_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Iluki matauna, kawala, “Kumiakaigu natana bulumakau, natana gota, deli natana sipi namwala, natana natana kasi taitu kwaitolu, e deli natana bubunerora, e natana bubuna.” ");
INSERT INTO kij_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eberam imai komwaidona minasina baisa Yaubada. Oluvi itaviki pilayu, e itakasi kasayu. Mitaga bubuna gala wala itavi. ");
INSERT INTO kij_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Deli avai tuta mluveka italakapusisi mwada bikomasi minasina, Eberam ibokavili ilosi. ");
INSERT INTO kij_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","E avai tuta kalasia bogwa bisalili, Eberam ikenu imisiwoya wala, e kabovitukokola ibusi baisa matauna e ikokoluvagasi. ");
INSERT INTO kij_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","E Guyau ikaibiga baisa matauna, kawala, “Igau makateki dalem bivagaisi gilagala baisa valu ituwoli. Deli, bivigakaisi si ula, deli si sisu mwau sainela taitu kala bawa kwelakatuvasi. ");
INSERT INTO kij_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mitaga igau bamipuki kabokwaraiwaga makwaina availa eivaulaisi matausina. E avai tuta bisilavaisi makwaina valu, bikauwaisi bidubadu veiguwa deli matausina. ");
INSERT INTO kij_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pailaga yoku bukusisu wala bila bibodi kam tomoya mokwita, e bukukwaliga bogwala lokukwam kalagila vakota e bibakwaimsi. ");
INSERT INTO kij_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Makawala tubuvasisi biwokuva e oluviga bikeiitasi baisa, paila yeigu gala babokavili mina Amora bisunapulasi igau wala saina bimitugagasi e ibodi bibanaisi mipuki.” ");
INSERT INTO kij_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","E kalasia bogwa isalili, e idudubila, kubowala kulia deli visigala kova, e kaitapa ilululu, saina nanakwa iyoumatilasi e ilosi oluwalaisi makasasina mauna. ");
INSERT INTO kij_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","E, tuta matutowena goli, mapilana valu Yaubada ikabutu baisa Eberam, e iluki, kawala, “Bogwa lakatotila igau dalem biyoulisi pwaipwaia okaligeila Itipita bila bila ee - kaduyoveka waya Yupereiti e baisa bitobu. ");
INSERT INTO kij_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Makawala wala si valu mina Keini, mina Kenisi, mina Kadimoni, ");
INSERT INTO kij_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","mina Itai, mina Peresi, mina Repa, ");
INSERT INTO kij_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","mina Amora, mina Kenani, mina Gigasa, e mina Yebusi.\" ");
INSERT INTO kij_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Eberam la kwava Serai nakaliga, gala ibodi bibani taitala latula. Mitaga minana bogwa eisisii natana vivila la ula, minana vilela Itipita yagala Ega. ");
INSERT INTO kij_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Mapaila Serai iluki Eberam ikaibiga, kawala, “Ka, Guyau eisisilibodaigu metoya unai gugwadi. E avaka kala silaboda, ki, gala ibodi bukumisii minana ulo ula? Kaina goli minana bibani gwadi paila yeigu.” E Eberam itagwala avaka Serai bogwa ilivala. ");
INSERT INTO kij_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Mapaila Serai isaiki Ega baisa matauna e kasitaiyu bisisuaisi bivigaki makawala la kwava. (Bogwa isunapula makawala wa tuta makwaina Eberam isisu mapilana Kenani kweluwotala taitu.) ");
INSERT INTO kij_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Eberam imisii Ega e minana isuma. Tuta makwaina bogwa inikoli leisuma, minana nanola saina walakaiwa deli la kalawou, e ikakululu Serai. ");
INSERT INTO kij_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","E Serai iluki Eberam, ikaibiga, kawala, “Ka, baisa m pakula, uula baisa Ega la kalawou deli ikakululaigu. Ka yeigu titoulegu asakaim minana mitaga tuta makwaina bogwa inikoli leisuma minana ikaluwouwaigu deli ikakululaigu. Ibodi Guyau binagi availa duwosisia, yoku kaina yeigu.” ");
INSERT INTO kij_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eberam ivitakauloki minana, ikaibiga, kawala, “Makawala goli baisa bwaina sainela, minana m ula e deli iuwotetila m kwaraiwaga osikowala, e kuvagi avaka nanom baisa minana.” E Serai saina iyogagi minana sainela, mapaila Ega isilavi minana, isakaula. ");
INSERT INTO kij_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","E Guyau la anelosi ibodi Ega outuwotu baisa oviloupakala, okedala bila mapilana Sura. ");
INSERT INTO kij_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","E ikaibiga, kawala, “Ve, Ega! Serai la ula yoku. Ambaisa mokutoya lokuma deli ambaisa bukula?” E minana ivitakauloki, kawala, “Yeigu lasakaula metoya baisa ulo giyouvila.” ");
INSERT INTO kij_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","E anelosi ikaibiga, kawala, “Kukweiita baisa minana, e bivaulaim.” ");
INSERT INTO kij_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","E oluvi ikaibiga, kawala, “Basakaim tubumwa saina bidugaga sainela, gala gagabila availa bikalau matausina. ");
INSERT INTO kij_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Yoku igau bukuuni taitala latum tau, e bukudoki yagala Isimeili, paila Guyau bogwa eilagi m valam uula nanom saina kala mmayuyu. ");
INSERT INTO kij_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mitaga latum bisisu makawala ase bulukilova. E matauna bivigaki kala leiya baisa tomota komwaidona, e tomota komwaidona bivigakaisi kasi leiya baisa matauna. Matauna bitavilevi dalela komwaidosi.” ");
INSERT INTO kij_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","E Ega ililivala titoulela, kawala, “Ki bogwa mokwita lagisi Yaubada, e gagabila basisu wala namomova yeigu e balivali paila baisa?” Mapaila minana idoki Guyau matauna eibigitoni minana yagala, “Yaubada matauna Togigisa.” ");
INSERT INTO kij_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Baisa uula tomota idokaisi utuwotu makwaina eitowala mapilana Kadesi deli mapilana Beredi yagala, “Utuwotula Tomomova Matauna Igigisaigu.” ");
INSERT INTO kij_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","E Ega ivilulu taitala Eberam latula tau, e idoki matauna yagala Isimeili. ");
INSERT INTO kij_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","E tuta makwaina Eberam kala taitu kweluwolima kweluwotolu kwailima kwaitala. ");
INSERT INTO kij_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tutala Eberam kala taitu kweluwolima kweluwovasi kwailima kwaivasi, e Guyau iyoumatila baisa matauna, ikaibiga, kawala, “Yeigu Yaubada Topeuligaga. Tuta komwaidona bukukwabikuwolaigu, e bukuvagi bwaina baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Yeigu bakabutaim deli basakaim kala bawa tubumwa bidalasi.” ");
INSERT INTO kij_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Eberam ikavagina deli migila opwaipwaia. E Guyau Yaubada ikaibiga, ");
INSERT INTO kij_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","kawala, “Yeigu bakabutaim makwaina. akatotila wala kidamwa yoku tubusi bidubadu mina watanawa. ");
INSERT INTO kij_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Yagam gala tuvaila badokaim Eberam, mitaga Eberaam, paila bavigakaim yoku tubusi bidubadu mina watanawa. ");
INSERT INTO kij_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Basakaim yoku bidubadu tubumwa bidalasi, mimilisi matausina igau biguyausi. Paila tubumwa bogwa bidalasi saina bidugaga, e mapaila tomota ituwoli bona ituwoli bona bikaloubusisi. ");
INSERT INTO kij_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Ka, baisa ulo biga katotila bayamati baisa yoku deli baisa tubumwa avai tubwa avai tubwa, kidamwa ulo kabutu gala biwokuva, bikanigaga wala, Yeigu goli m Yaubada deli si Yaubada tubumwa. ");
INSERT INTO kij_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Paila mapilana valu tuta baisa kusisuaisi makawala togilagala, mitaga igau wala basakaim deli basaiki tubumwa. E mapilawena Kenani pilamwaidona tubumwa bivigakaisi viloutabusi e bikanigaga goli. E yeigu goli si Yaubada.” ");
INSERT INTO kij_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Yaubada iluki Eberaam, kawala, “Ibodi goli yokomi tuvaila bukutagwalasi bukuyamataisi baisa avaka lakabutaimi yoku deli tubumwa avai tubwa avai tubwa. ");
INSERT INTO kij_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ibodi wala yoku deli tubumwa komwaidomi bukutagwalasi bukubobwaisi tau taitala taitala oluwalaimi. ");
INSERT INTO kij_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Baisa kami bobu bogwa bikibuboti kidamwa lakabutaimi makawala. Metoya tuta baisa ibodi bukubobwaisi gugwadi tauwau okala yam kwailima kwaitolu. Tuvaila ibodi bukubobwaisi magudisina mi ula tauwau availa availa eikaloubusisi omi bwala, deli goli matausina okugimolaisi metoya baisa togilagala. ");
INSERT INTO kij_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ibodi tauwau taitala taitala bibobusi, e bobu makwaina baisa kabutuvatusi ouwomi bikibuboti kidamwa lakabutaimi makawala. ");
INSERT INTO kij_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kidamwa avai tau isisu oluwalaimi gala kala bobu, e matauna gala wala badoki ulo tomota, paila uula gala ivagi baisa avaka lakabutaimi.” ");
INSERT INTO kij_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Yaubada iluki Eberaam, kawala, “Gala tuvaila bukudoki m kwava yagala Serai. Baisa tuta bukudoki m kwava yagala Sera. ");
INSERT INTO kij_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","E bakabwaili minana, deli basakaim latum tau metoya baisa minana. E bakabwaili minana e bivigaki minana igau inasi bidubadu mina watanawa, e tuvaila mimilisi tubula igau biguyausi.” ");
INSERT INTO kij_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","E Eberaam ikavagina deli migila opwaipwaia. E igigila tutala eiluwai, kawala “Ki, mokwitala taitala tomota bibani latula kidamwa kala taitu lakatutala? E Sera, ki, gagabila bivalulu, paila kala taitu kweluwolima kweluwovasi?” ");
INSERT INTO kij_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","E Eberaam ikatupoi Yaubada, kawala, “Ammakawala Isimeili? Kaina bibodi matauna kaimapugu biyosi kaikeyagu?” ");
INSERT INTO kij_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mitaga Yaubada ikaibiga, kawala, “Gala. M kwava Sera igau biuni latum tau, bukuvabu yagala bukudoki Aisake. Paila baisa avaka lakabutu bayamati baisa matauna deli baisa tubula tuta gala biwokuva. Paila makwaina kabutu kwekanuvagasi. ");
INSERT INTO kij_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Taga bogwa lalagi avaka m kwapuloki paila Isimeili, mitaga igau bakabwaili matauna basaiki bidubadu litula deli bakatumkulovi dalela. E matauna bivigaki tumalela tailuwotala taiyu gweguya, e oluvi bavigaki saina kwaipeula kabokwaraiwaga metoya odalela. ");
INSERT INTO kij_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mitaga avaka la kabutu bayamati baisa latum Aisake matauna igau biuni Sera otutala matutona talatova tubukonela minawena wala.” ");
INSERT INTO kij_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","E avai tuta Yaubada bogwa eivenokusi kaiyaku sola Eberaam, e isilavi matauna ila. ");
INSERT INTO kij_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Makwaina wala yam Eberaam ikabikuwoli Yaubada e ibobu latula Isimeili deli komwaidosi tauwau ola bwala kala tosisu. Deli goli ibobu la ula matausina eikaloubusisi ola bwala deli matausina eigimloki la mani. ");
INSERT INTO kij_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Eberaam kala taitu iboda kweluwolima kweluwovasi kwailima kwaivasi e ibani kala bobu. ");
INSERT INTO kij_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","E latula Isimeili kweluwotala kwaitolu taitu. ");
INSERT INTO kij_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Kasitaiyu wala ibobwaisi yam kwaitala wala, ");
INSERT INTO kij_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","e deli goli komwaidona Eberaam la ula. ");
INSERT INTO kij_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Guyau iyoumatila baisa Eberaam wa kai kaibumaboma baisa Mamira. E tuta makwaina saina yuviyavi kalasia, e Eberaam isisu ola lulu ola buliyoyova. ");
INSERT INTO kij_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Avai tuta ikowana igisi taitolu tauwau itotusi. E tuta makwaina bogwa igisimlili matausina wala, e isakaula ibodi matausina itapopula kwaitutula ikavagina opwaipwaia. ");
INSERT INTO kij_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","E matauna ikaibiga, kawala, “Tommoya, ka, gala ibodi bukusilavaigusi. Yeigu baisa lasisu ibodi bawotitalaimi. ");
INSERT INTO kij_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","“Kutagwalasi bamiakaimi sitana sopi bukuwinaisi kaikemi. Bukusilaisi kai kaibumaboma osikowala bukuvaiwasisi. ");
INSERT INTO kij_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","E tuvaila bamai sitana kaula bukukwatupeulasi, oluvi bukulosi. Paila bogwa labani kamaiaba, paila lokumakaiagusi goli. Ka, ibodi bawotitalaimi.” E ivitakaulokaisi matauna, kawasi, “Bwaina avaka kulivali kuvagi makawala.” ");
INSERT INTO kij_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Eberaam inanakwa isuvi ola buliyoyova iluki Sera, kawala, “Kunanakwa kukwau kapotala pwarawa kapominabwaita e kugabu sitana beredi.” ");
INSERT INTO kij_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","E matauna isakaula ilokaia mayuwona bulumakau, iyosi natana nagwadi naposa e isaiki la touwata bivigimmalaisi. ");
INSERT INTO kij_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ikau sitana nunu deli posala, deli viliona e ikatubiasi kawailuwa omitasi tommoya osikowala kai, e iyeia, isaiki, e ikamsi. ");
INSERT INTO kij_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","E ikatupoiyaisi matauna, kawasi, “Ambaisa m kwava Sera?” E iluki matausina, kawala, “Isisu ola buliyoyova.” ");
INSERT INTO kij_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","E taitala ikaibiga, kawala, “Igau nalima navasi tubukona biwokuva bakeiita bama e matutona goli m kwava Sera bivalulu latula tau.” E minana katitaikina itotu otuboulola matauna, e ililagi. ");
INSERT INTO kij_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eberaam bogwa itomoya deli Sera bogwa eivinumoya, e minana Sera bogwa isim paila tubukona natana natana paila vivila kasi katoula. ");
INSERT INTO kij_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sera igigili titoulela ikaibiga, kawala, “Baisa tuta yeigu bogwa lavinumoya bogwa lakapanunu, ki gagabila bamwasawa paila bamasisi sogu ulo mwala? Deli tuvaila ulo mwala bogwa eitomoya.” ");
INSERT INTO kij_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Oluvi Guyau ikatupoi Eberaam, kawala, “Avaka paila Sera eigigila? Avaka paila Sera ikaibiga, kawala, ‘Ki gagabila babani gwadi tutala bogwa lavinumoya?’ ");
INSERT INTO kij_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ki, avai vavagi saina mwau paila Guyau bivagi? Bogwa makawala lakaibiga, ‘Igau nalima navasi tubukona biwokuva bakaimilavau bama, e matutona goli Sera bivalulu latula tau.’” ");
INSERT INTO kij_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mapaila Sera ikokola e iyakala, ikaibiga, kawala, “Yeigu gala agigila,” e matauna ivitakauloki, kawala, “Mitaga, lokugigilala.” ");
INSERT INTO kij_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Tuta matutona matausina tauwau bogwa isilavaisi baisa ilokaiasi ovalu makwaina ambaisa igagabila bivakawolaisi Sodom. E deli Eberaam ilosi wa keda bitaloi bilosi. ");
INSERT INTO kij_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Guyau onanola ikaibiga, “Adoki gala ibodi bakatupwani baisa Eberaam paila igau oluvi avaka bavigaki. ");
INSERT INTO kij_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Paila tuta oluvi tubula bidalasi saina budoveka deli topapeula la boda komwaidona. E bamitukwaii matauna deli komwaidosi mina watanawa metoya baisa matauna. ");
INSERT INTO kij_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","“Bogwa lanagi matauna kidamwa igau tuta oluvi bikaraiwogi litula deli tubula, kidamwa bikamiabaigusi deli bivagaisi avaka kala bwaina, deli avaka kala duwosisia makawala. Kidamwa bogwa bivagaisi, e yeigu bavagi komwaidona vavagi paila matauna. Bogwa makawala lalivala ulo biga katotila.” ");
INSERT INTO kij_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mitaga Guyau ikaibiga baisa Eberaam, kawala, “Baisa saina kwevakaigaga kasi tabinona lalagi paila Sodom deli Gomora e si mitugaga saina isiligaga. ");
INSERT INTO kij_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Bogwa laligibogwi kasi tabinona saina gaga. Ibodaigu babusi watanawa banevi ammakawala, kaina mokwita kaina gala.” ");
INSERT INTO kij_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","E matausina taiyu tauwau tommoya isilavaisi baisa e ilokaiasi Sodom. Mitaga Guyau isikaili Eberaam. ");
INSERT INTO kij_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Eberaam ila katitaikinela, ikatupoi baisa Guyau, kawala, “Ki, mwada yoku mokwita bukukwatudoum matausina tobubwaila deli tomitugaga oluwalaisi? ");
INSERT INTO kij_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kidamwaga tailuwolima tobubwaila olumoulela valu, ki, yoku bukukwatudoum komwaidona? Ki, kaina ibodi bukunokapisi komwaidosi kidamwa bukukwatumovi matausina tailuwolima? ");
INSERT INTO kij_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Mokwita, gala bukukwatumati matausina tobubwaila deli tomitugaga, baisa gala gagabila bukuvagi makawala. Kidamwa bukuvagi makawala e matausina tobubwaila igau bibanaisi mipuki deli matausina tomitugaga. Wa, galaga gagabila baisa. Ibodaim yoku kasi toyakala mina watanawa bukuvagi duwosisia wala.” ");
INSERT INTO kij_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Guyau ivitakauloki, kawala, “Kidamwa babani tailuwolima tobubwaila olumoulela Sodom, e, gala bakatudoum komwaidosi. Bogwa banokapisi valu paila uula matausina tailuwolima.” ");
INSERT INTO kij_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","E Eberaam tuvaila ikaibiga, kawala, “Anigadaim kuninabwaila paila ulo kaliyeiya. Tuvaila balivilavau baisa yoku. Paila yeigu tau wala, e gala ibodaigu balivala avaka. ");
INSERT INTO kij_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kaina luwovasi tailima matausina tobubwaila bikaimapwaisi luwolima, ammakawala? Ki, bukukwatudoum mapilana pilamwaidona kidamwa tobubwaila kasi bawa bibusi e biboda wala tailuwovasi tailima?” E Guyau ikaibiga, kawala, “Kidamwa babani tailuwovasi tailima tobubwaila, gala bakatudoum valu.” ");
INSERT INTO kij_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","E Eberaam ikaibigavau, kawala, “Kidamwa tailuwovasi wala, e, ammakawala?” Guyau ikaibiga, kawala, “Kidamwa babani kasi bawa tailuwovasi gala wala bakatudoum valu.” ");
INSERT INTO kij_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eberaam ikaibiga, kawala, “Guyau, taga bimwau nanom, mitaga ibodi balivilavau. Kidamwa kasi bawa tailuwotolu e ammakawala?” E ikaibiga, kawala, “Kidamwaga babani tailuwotolu gala wala bakatudoum valu.” ");
INSERT INTO kij_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eberaam ikaibiga, kawala, “Anigadaim kuninabwaila paila ulo kaliyeiya. Tuvaila balivilavau baisa yoku. Kaina kasitailuwoyu tobubwaila, e, ammakawala?” E ikaibiga, kawala, “Kidamwa babani kasitailuwoyu gala bakatudoum valu.” ");
INSERT INTO kij_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eberaam ikaibiga, kawala, “Anigadaim taga bimwau nanom kidamwa sivatala wala balivilavau. Ka, kidamwaga kasitailuwotala bukubani, ammakawala?” E ikaibiga, kawala, “Kidamwa babani kasitailuwotala, gala wala bakatudoum valu.” ");
INSERT INTO kij_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","E bogwa ivenokusi livala kasitaiyu Eberaam. E Guyau bogwa leila, e Eberaam ikaimilavau ola valu. ");
INSERT INTO kij_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tutala kasitaiyu anelosi bogi makwaina imakaiasi mapilana Sodom, e Lota eisili wala okalapisilela valu. E tutala igisi matausina itokaia ila ibodi matausina. Lota ikavagina omitasi, ");
INSERT INTO kij_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","e ikaibiga, kawala, “Tommoya, ka, mwada bawotitalaimi. Anigadaimi bukumaisi bavakomaimi ogu bwala. Gagabila bukuwinaisi kaikemi e bukukwanamwaisi baisa. Igau biyam bukumamatasi bukutokaiasi bukulosi wala.” Mitaga ivitakaulasi, kawasi, “Gala wala. Bakasimwaisi baisa obikubaku.” ");
INSERT INTO kij_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mitaga Lota saina imnabi matausina, imnabi imnabi, e mapaila ilosi deli matauna ola bwala. E Lota iluki la touwata bisulusi kaula e bikatubaiasasi kidamwa sala bikamsi. Tutala bogwa leikatubiasaisi, e kasitaiyu ikamsi. ");
INSERT INTO kij_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Igau gala bimasisisi kasitaiyu, e mina Sodom itoulaisi Lota la bwala. E komwaidosi tauwau mina Sodom tommoya deli tubovau itotusi baisa. ");
INSERT INTO kij_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","E idousi baisa Lota, kawasi, “Ambaisa kasitaiyu samwa eimaisi mwada bikanamwaisi baisa yoku bogi makwaina? Kumai matausina bakayosisi goli.” Paila mina Sodom ninasi mwada bikatudeuwaisi matausina e bimisiaisi goli. ");
INSERT INTO kij_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","E Lota bogwa isunapula okoukweda, e otapwala ikatubodi kabosuvi. ");
INSERT INTO kij_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ikaibiga baisa matausina, kawala, “Segwaia. Anigadaimi gala bukuvagaisi makawala saina vavagi gaga. ");
INSERT INTO kij_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ka, kugisaisi litugwa vivila nayu wala, minasina gala ikikapugulasi. Igagabila basunupuloi minasina baisa yokomi, e bukuvagaisi avaka magimi baisa minasina. Mitaga gala avaka bukuvigakaisi baisa matausina tauwau, paila matausina tokwaidadina leimaisi ogu bwala, ibodaigu bakoli matausina.” ");
INSERT INTO kij_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mitaga matausina ikaibigasi, kawasi, “Mwa! Togilagala yoku, kutomwada ma kedasiga. Availa yoku mwada bukulukwaimasi avaka bakavagaisi? Kutomwada ma kedasiga taga bakayogagaimsi sainela, e matausinaga sitana.” E matausina itupaisi Lota ikeiita, e iyagaisi kabosuvi mwada bikodidaimisi bikapusi. ");
INSERT INTO kij_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mitaga matausina tauwau kasitaiyu wa bwala iyosalaisi yumasi iyosisi Lota ibiyumalaisi olumoulela bwala. E ikatubodaisi kabosuvi. ");
INSERT INTO kij_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tuta makwaina ikatupataisi mitasi komwaidosi matausina tauwau okoukweda, e isugweulu mitasi ikausi e gala ibodi bibanaisi kabosuvi. ");
INSERT INTO kij_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","E matausina tommoya taiyu ikaibigasi baisa Lota, kawasi, “Ki kaina litumwa, yuwomwa kaina availa veyamwa isisuaisi baisa ovalu? Kidamwa availa m boda isisuaisi baisa, bukuvakouli e deli bukusunapulasi metoya mapilana valu, e bukusakaulasi. ");
INSERT INTO kij_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Paila makateki bakakatudoum valu. Paila Guyau bogwa eiwitalaima lakama mwada bakakatudoum mapilana Sodom.” ");
INSERT INTO kij_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","E Lota ilokaia tauwau matausina mwada eipakusi litula paila mwada bivaiyasi, e ikaibiga, kawala, “Kunanakwasi kusilavaisi metoya baisa; paila Guyau bogwa bikatudoum valu makwaina.” Mitaga matausina idokaisi Lota ikukovili. ");
INSERT INTO kij_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bogwa eikikivi visiga e matausina anelosi ivigikonaisi bikammalaisi Lota. Ikaibigasi, kawasi, “Kunanakwa kuvakouli m kwava deli litumwa minasina nayu e kusilavaisi kusunapulasi igau bukukitumouwaisi mi momova avai tuta valu makwaina bitamwau.” ");
INSERT INTO kij_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lota ininayuwa gala itagwala bisakaulasi, ilagoli Guyau inokapisi matauna deli litula. E tommoya matausina ivakoulisi matauna, la kwava deli litusia, iyosaisi yumasi isunupuloiyaisi metoya ovalu makwaina. ");
INSERT INTO kij_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","E taitala anelosi iluki Lota, kawala, “Kusakaulasi paila mi momova. Gala bukutovilasi, taga bukugisaisi otupwami. Taga bukuvaiwasisi oitayatila. Kusisakaulasi wala bukulosi wa koya e taga bukusilagisi bukukwaligasi.” ");
INSERT INTO kij_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","E Lota ivitakauloki, kawala, “Guyau anigadaim taga bukuvigakaimasi makawala. ");
INSERT INTO kij_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Bogwa lokuvagi vavagi siligaga deli m nokapisi paila ulo momova. E mitaga koya makwaisina saina kaduwonaku, baliloula wala mwada bala mitaga wa keda basilagi e bakaliga. ");
INSERT INTO kij_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ka, kugisi kabayatila ovalu makwaina kwekekita baisa katitaikina wala. Bibodaigu bala baisa. E bogwa kugisi kwekekita e baisa basisu bwaina.” ");
INSERT INTO kij_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Anelosi ivitakauloki Lota, kawala, “O bwaina. Bogwa latagwala. Makwaina valu gala bakatudoum. ");
INSERT INTO kij_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","E kusakaula nanakwa gala avaka bavagi igau wala bukula baisa.” E mapilana valu idokaisi yagala Sowa (baisa kala katumiki kwekekita), paila uula Lota idoki valu kwekekita wala. ");
INSERT INTO kij_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tuta makwaina kalasia bogwa eiyuwoula e Lota bogwa eiviloubusi Sowa. ");
INSERT INTO kij_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Saina nanakwa Guyau ilavi dakuna salipa kwelululu maiinela saina gaga ikapusi ovalu makwaisina Sodom deli Gomora. ");
INSERT INTO kij_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ikatudoum makwaisina deli komwaidona kabayatilela deli tomotala komwaidona deli vavagi komwaidona eisususinasi olumoulela valu makwaisina. ");
INSERT INTO kij_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","E mitaga Lota la kwava imitavila igisi otuboulola imila yona kala gigisa makawala kokola. ");
INSERT INTO kij_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Obulubuvisiga Eberaam inanakwa ila makwaina valu ambaisa eitobogwa omatala Guyau. ");
INSERT INTO kij_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Bogwa igisi Sodom deli Gomora deli komwaidona oitayatilela deli bogwa eigisi mseula ititokaia metoya valu opwaipwaia makawala mseula kumkumla deli kubowala. ");
INSERT INTO kij_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Mitaga tuta makwaina Yaubada bogwa eikatudoum valu makwaisina, ambaisa wala Lota eisisu oitayatilela, iluluwai Eberaam e bogwa itugwali Lota bisakaula e bibwaina. ");
INSERT INTO kij_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Matauna Lota ikokola bisisuaisi Sowa, mapaila deli litula igalasi ilosi wa koya, e kwaitala lagi baisa mesisikaisi deli litula. ");
INSERT INTO kij_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Latula vilitomoya iluki bodala, kawala, “Ka, sogu, ammakawala tamada bogwa eitomoya, e gala wala taitala tau ovalu komwaidona isisuaisi bitavaisi e bitabanaisi gugwadi. ");
INSERT INTO kij_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ka, ibodi bitavimom tamada waini e bitamisii matauna, e bitaunai gugwadi metoya baisa matauna.” ");
INSERT INTO kij_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","E bogi makwaina ivimomwaisi tumasi sopi kaipeula waini, e minana vilitomoya eimisii matauna. Mitaga matauna gala wala avaka inikoli paila bogwa eimom kaipeula. ");
INSERT INTO kij_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","E eiyam minana vilitomoya iluki bodala, kawala, “Kamataiyu tamada kamasisi bogi e ka! tavimom tuvaila sopi kaipeula ibogi e bukumisii. Mapaila kadataiyu wala bitaunai gugwadi metoya baisa tamada.” ");
INSERT INTO kij_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mapaila bogi makwaina ivimomwaisi tumasi, e latula vilagwadi eimisii matauna. Deli tumasi saina imom, mwada gala binikoli avaka. ");
INSERT INTO kij_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Bogwa makawala Lota litula ivagaisi, e kasitaiyu wala isumasi wala metoya baisa tumasi. ");
INSERT INTO kij_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Vilitomoya iuni tau, idoki yagala latula Mowabi. Mina Mowabi baisa tuta isisuaisi, e tubusi matauwena. ");
INSERT INTO kij_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","E vilagwadi latula tuvaila iuni tau wala, e idoki yagala Benami. Mina Amoni baisa tuta isisuaisi, e tubusi matauwena. ");
INSERT INTO kij_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Eberaam isilavi valu Mamira, e ila Kenani mapilana opilibolimila, e ibudi la valu oluwalaisi Kedesi deli Sura. E avai tuta matauna igau eisisu mapilana Gerara, ");
INSERT INTO kij_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","matauna eilivala kawala, la kwava Sera mwada minana luleta. Mapaila guyau Abimeleki matauna guyoula Gerara ikaraiwogi Sera ilauwaisi ola bwala. ");
INSERT INTO kij_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kwaitala bogi Yaubada iyoumatila baisa matauna metoya wa mimi e iluki kawala, “Yoku bukukwaliga, paila minana vivila navavaigila, e lokuvaisabuga.” ");
INSERT INTO kij_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mitaga Abimeleki gala wala sitana isividuli minana, mapaila ikaibiga kawala, “Mwa, Guyauwʹo - yeigu tobwaila wala! Ki, mwada bukukwatumataigu deli ulo tomota? ");
INSERT INTO kij_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ka, titoulela wala Eberaam eilivala mwada minana luleta, e minana eilivala mabigana wala. Yeigu lauvagi baisa okedala duwosisia, e gala wala avai sula avagi.” ");
INSERT INTO kij_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Yaubada ivitakauloki Abimeleki wa mimi ikaibiga, “E mokwitala. Bogwa lanikoli lokuvagi baisa okedala duwosisia, mapaila lakolaim taga bukumitugaga baisa yeigu, e baisa uula gala atugwalaim bukukwabikoni minana. ");
INSERT INTO kij_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Mitaga tuta baisa, kukwaimali minana baisa la mwala. Paila matauna taitala tovitoubobuta, e matauna binigada paila yoku, kidamwa yoku gala bukukwaliga. Mitaga kidamwa gala bukukwaimali minana baisa la mwala, alukwaim biga mokwita igau bukukwaliga, deli goli m tomota komwaidona bikaligasi.” ");
INSERT INTO kij_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Eiyam kaukwau Abimeleki idou komwaidosi la tosikwawa e iluki matausina avaka eikaloubusi, e matausina ikokolasi sainela. ");
INSERT INTO kij_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","E oluvi Abimeleki idou Eberaam ikatupoi matauna kawala, “Avaka baisa lokuvigakaimasi? Avai sula lavagi baisa yoku, e lokuyomituli kabosilagi baisa yeigu deli ogu kwabokwaraiwaga komwaidona? Mwa, gala availa bivigakaigu makawala lokuvigakaigu. ");
INSERT INTO kij_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Avaka uula lokuvagi makawala?” ");
INSERT INTO kij_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","E Eberaam ivitakauloki kawala, “Mwa, adokila gala taitala tosisula baisa ikukoli Yaubada e adokila matausina bikatumataigusi e bivaiyasiga ulo kwava. ");
INSERT INTO kij_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Minana mokwitala luguta, tamagu latula, mitaga gala inama natana, e yeigu lavaiya minana. ");
INSERT INTO kij_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mapaila avai tuta Yaubada iwitalaigu basilavi tamagu la bwala e bala valu viloumitawasi aluki minana kawagu, ‘Kidamwa kuyebwailigu, bukululuki tomota taitala taitala mwada yeigu lumta.’” ");
INSERT INTO kij_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","E oluvi Abimeleki ikaimilivau Sera isaiki Eberaam; e tuvaila tuta matutona wala isaiki mimilisi sipi, bulumakau, deli ula. ");
INSERT INTO kij_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","E Abimeleki iluki Eberaam kawala, “Mwa, baisa komwaidona ulo pwaipwaia wala; e ambaisa wala magim bukula kubudi m valu.” ");
INSERT INTO kij_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","E iluki Sera kawala, “Ka, basaiki lumta lakatuluwotala siliba kidamwa komwaidona availa availa deli lokumaisi bisimokwitasi yoku nabwaila wala e deli tomota komwaidona igau binikolaimsi mwada gala avai sula kuvagi.” ");
INSERT INTO kij_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Paila wala avaka eikaloubusi Eberaam la kwava, baisa minana Sera, mapaila Guyau ikibodi luposi bikaligasi nunumoya komwaidosi eisisuaisi wa ligisa. Eberaam inigada paila Abimeleki, e Yaubada ikatumovi matauna. E deli goli ikatumovi la kwava deli la ula vivila, e igagabila goli bivalulusi. ");
INSERT INTO kij_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Guyau imitukwaii Sera, makawala la katotila. ");
INSERT INTO kij_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","E minana isuma ivalulu gwadi magudina Eberaam latula, tutala Eberaam eitomoya. Paila Yaubada bogwa inagi avai tuta magudina la kaloubusi, e bogwa goli eikaloubusi makawala. ");
INSERT INTO kij_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Eberaam ivabu magudina yagala Aisake. ");
INSERT INTO kij_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","E tuta matutona magudina kala yam iboda kwailima kwaitolu, e Eberaam ibobu magudina makawala Yaubada la karaiwaga. ");
INSERT INTO kij_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","E tuta makwaina Aisake ikaloubusi, Eberaam kala taitu iboda lakatutala taitu. ");
INSERT INTO kij_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sera ikaibiga, kawala, “Yaubada bogwa imiakaigu kala mwamwasila nanogu, e deli ulo gigila. Paila komwaidosi availa availa bilagaisi bulogala ulo valulu, bakagigilasi deli.” ");
INSERT INTO kij_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","E tuvaila minana ikaibiga, kawala, “Tokinabogwa, availa biluki Eberaam kidamwa yeigu Sera bavinunu litugwa? Mitaga yeigu lavinumoya e launiga latuma.” ");
INSERT INTO kij_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","E magudina itoveka. E tuta matutona ivakalai gwadi, e Eberaam ivagi paka kwaiveka. ");
INSERT INTO kij_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Minana Ega vilela Itipita, e omitibogwa Eberaam eimisii minana e ivilulu latula Isimeili. E kwaitala yam Isimeili sola bodala Aisake imwasawasi. ");
INSERT INTO kij_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","E Sera igigisi matausina si mwasawa, e iluki Eberaam, kawala, “Mwa! Ibodi bukuyabi minana m ula bilosi sola latula. Galaga bibodi minana latula bibani avaka kaikeyam. Ibodi wala latugu Aisake biyosi kaikeyam komwaidona.” ");
INSERT INTO kij_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","E Eberaam ikai nanola paila baisa, paila uula Isimeili tuvaila latula. ");
INSERT INTO kij_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mitaga Yaubada iluki Eberaam kawala, “Taga bikai nanom paila magudina sola inala minana m ula. Yeigu bogwa lakatotila kidamwa tubumwa bidalasi, e bogwa bikaloubusi makawala metoya baisa Aisake. Desi wala, ibodi bukuvagi avaka Sera eilukwaim. ");
INSERT INTO kij_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Paila magudina latula minana m ula latula tuvaila biunai litula bidubadu, e mabudona bavigaki budotala tomota budovau. Paila matauwena goli Isimeili tuvaila latum.” ");
INSERT INTO kij_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Eiyam kaukwau Eberaam isaiki sitana kala kalaga deli yatala lukwava kasi sopi. Ikau latula ipapi, e iyabi wala ilosi. E minana isilavi e ilomakava mapilana Biasiba oviloupakala. ");
INSERT INTO kij_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","E tuta matutona eivinakwaisi kasi sopi, e isaili magudina gwadi osikowala kai kaikekita, ");
INSERT INTO kij_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","e ila kala malola iboda uvaluwolima isili wala. Paila ikaibiga, kawala, “Saina ikaikai nanogu, gala magigu bagisi la kaliga latugu.” E minana isisu isisu e ikapwali koku ivalam. ");
INSERT INTO kij_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Yaubada ilagi magudina gwadi iuvalam. E Yaubada la anelosi ilivala metoya wa labuma iluki Ega, kawala, “Ve! Avaka ikaiki nanom? Taga bukukokola. Yaubada bogwa ilagi magudina la valam. ");
INSERT INTO kij_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kutokaia kula kukopwi magudina kuvisimoli. Paila yeigu bogwa lakaraiwaga kidamwa magudina dalela bidalasi e bavigaki budotala tomota budoveka.” ");
INSERT INTO kij_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","E Yaubada iulaim matala minana e igisi kwaitala utuwotu. Ila ivakasau lukwava deli sopi e ivimom magudina gwadi. ");
INSERT INTO kij_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Yaubada eisisu deli magudina tutala ititoveka. Isisu mapilana Parana oviloupakala. E matauna iwawaiga, towaiga komwaidona kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","E inala ibani natana vilela Itipita iyovaiya latula. ");
INSERT INTO kij_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Wa tuta matutona Abimeleki ilosi kasitaiyu Pikoli, matauna la tokwabilia kasi tokugwa, e iluki Eberaam kawala, “Vavagi komwaidona lokuuvagi, Yaubada deli yoku. ");
INSERT INTO kij_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Mapaila makatupona wala baisa kubiga katotila omatala Yaubada kidamwa gala bukuwabwaimasi deli litugwa e deli goli dalegu komwaidona. Yeigu bogwa lamitukwaiyaim mapaila kukwatotila kidamwa bukumitukwaiyaigu deli goli valu makwaina tuta baisa lokusisiki.” ");
INSERT INTO kij_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Eberaam ilivala kawala, “Bogwa akatotila.” ");
INSERT INTO kij_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","E oluvi Eberaam ikavilavila baisa Abimeleki paila utuwotu makwaina Abimeleki la touwata eiyoulisi. ");
INSERT INTO kij_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","E Abimeleki ilivala kawala, “Gala wala anikoli availa eivagi vavagi baisa. E gala kulukwebogwaigu paila baisa, deli lagaila wala lalagi lokulivali.” ");
INSERT INTO kij_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tuvaila Eberaam isaiki Abimeleki mimilisi sipi deli bulumakau, e kasitaiyu wala ininabwailasi. ");
INSERT INTO kij_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","E Eberaam ikatupali nalima nayu lam metoya ola yawa, ");
INSERT INTO kij_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","e Abimeleki ikatupoi matauna kawala, “Avaka uula lokuvagi makawala ke?” ");
INSERT INTO kij_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eberaam ivitakauloki Abimeleki kawala, “Kutagwala bukukwau minasina nalima nayu lam. Kidamwa bukukwau, bogwa bukukwamokwita baisa yeigu, paila utuwotu makwaina yeigu wala lakeli.” ");
INSERT INTO kij_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Mapaila valu makatupona idokaisi yagala Biasiba, paila uula metoya mapilana kasitaiyu wala ibigasi katotila. ");
INSERT INTO kij_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Avai tuta bogwa eininabwailasi mapilana Biasiba, Abimeleki sola Pikoli ikaimilavausi mapilana Pilisitia. ");
INSERT INTO kij_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","E Eberaam ivali kaitala pulopola olopola Biasiba e matauna itapwaroru baisa Guyau, Yaubada matauna Tosivagasi. ");
INSERT INTO kij_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eberaam imilivalu mapilana Pilisita tuta kaduwonaku. ");
INSERT INTO kij_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Igau oluvi Yaubada iwakoli Eberaam. Idou baisa matauna, kawala, “Eberaamʹo!” E Eberaam ivitakaula, kawala, “Mayeigu ka.” ");
INSERT INTO kij_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Yaubada ikaibiga, kawala, “Kukwau latum gudikesa Aisake matauwena tombwailim. Bukulosi mapilana Moria, e oluvi bavitulokaim koya kwaitala. Baisa goli bukutugwali magudina bukuvigaki m lula baisa yeigu.” ");
INSERT INTO kij_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Eiyam kaukwau Eberaam iselavi luvatala kai kidamwa bigabu lula, e isaili otapwala ase. E ilau magudina Aisake deli taiyu la ula. Ivitouulasi loula bilokaiasi mapilana valu ambaisa Yaubada eilivala bibodi bilula baisa matauna. ");
INSERT INTO kij_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ililoulasi ililoulasi e yam kwaitolula Eberaam igisi koya makwaina sita kaduwonaku. ");
INSERT INTO kij_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","E mapaila iluki matausina la ula, kawala, “Kusisiaisi minana ase. Yeigu sogu latugu bakawa baisa bakatapwaroru e oluvi bakakaimilavau.” ");
INSERT INTO kij_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eberaam iluki Aisake bikeula maluvana kai, e matauna ikau kutou deli kova paila bivakati kovala la lula. Ililoulasi ");
INSERT INTO kij_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","e Aisake ikaibiga, kawala, “Tamagʹo.” E tamala ivitakaula, kawala, “Mwa! Ammakawala?” E Aisake ikaibiga, kawala, “Ka, bogwa lagisi kova deli kai. Mitaga amminana lam paila bitavigaki da lula?” ");
INSERT INTO kij_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","E Eberaam ivitakaula, kawala, “Yaubada titoulela bisakaida da lula.” E kasitaiyu wala isaitaulasi ilosi. ");
INSERT INTO kij_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tutala eisakailasi makwaina koya, Eberaam ikatubiasi kabolula, e isaili kai odabala. E iyosi iyuwoli latula isaili magudina okabolula odabala kai. ");
INSERT INTO kij_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","E ikau kutou mwada bikatumati latula. ");
INSERT INTO kij_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mitaga Guyau la anelosi idou baisa matauna metoya wa labuma, kawala, “Eberaam, mwa! Eberaam.” E ivitakaula, kawala, “Mayeigula, ka!” ");
INSERT INTO kij_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","E ikaibiga, kawala, “Taga kukwatumati gwadi. Gala avaka bukuvigaki magudina. Tuta baisa bogwa anikolaim yoku kukukoli Yaubada, paila gala lokuyusi latum tombwailim metoya baisa matauna.” ");
INSERT INTO kij_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Eberaam imitibilibili igisi natana sipi namwala ikasikola kala doga wa kai. E ila iyosi minana imai ivigaki lula kaimapula latula. ");
INSERT INTO kij_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Eberaam idoki mapilana valu kala kavilevi yagala “Yaubada bisakaidasi.” E tuta baisa tomota bililivalasi, “Ola koya Yaubada, matauna isakaidasi.” ");
INSERT INTO kij_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","E siviyuwela Guyau la anelosi idou baisa Eberaam metoya wa labuma. ");
INSERT INTO kij_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Kawala, “Ka baisa tuta akavitagi yagagu e baisa makawala goli akatotila baisa yoku. Ka, yeigula Guyau Yaubada alilivala. Bogwa bamitukwaiyaim saina siligaga. Uula goli bogwa lokuvigaki makawala baisa yeigu yam lagaila, e gala goli kuyusi latum gudikesa. ");
INSERT INTO kij_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","E mauula akatotila kidamwa tubumwa bidalasi makawala utuyam kala bawa wa labuma, kaina makawala kanakenuva kala bawa olumata. Tubumwa bogwa bikalisauwaisi odubasi kasi tilaula. ");
INSERT INTO kij_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","E komwaidosi mina watanawa binigadaigusi kidamwa bamitukwaii matausina makawala lamitukwaii tubumwa. E vavagi makwaina uulela paila yoku lokukwabikuwoli baisa avaka lakaraiwogaim.” ");
INSERT INTO kij_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Eberaam sola latula ikaimilavausi baisa la ula, e matausina ilosi Biasiba. E mapilana Biasiba baisa Eberaam ibudi la valu. ");
INSERT INTO kij_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","E igau makateki Eberaam einikoli Milika eiuni litula kasitailima kasitaitolu ola bwala Naiyo, matauna Eberaam bodala. ");
INSERT INTO kij_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Kuluta Usa e bodala Busa, Kemueli litula, Aram, ");
INSERT INTO kij_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Aso, Pilidasi, Yidilapi, deli Betuweli, ");
INSERT INTO kij_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","matauna Ribeka tamala. Milika, eiuni matausina litula kasitailima kasitaitolu ola bwala Naiyo. Matauna Eberaam bodala. ");
INSERT INTO kij_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reuma, minana Naiyo la ula e ivigakiga la kwava, eiuni Teba, Gami, Taasi, deli Maaka. ");
INSERT INTO kij_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera isisu iboda lakatutala kweluwoyu kwailima kwaiyu kala taitu. ");
INSERT INTO kij_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","E minana ikaliga mapilana Ebironi viluwela Kenani, e Eberaam ivalam paila minana. ");
INSERT INTO kij_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Isilavi mapilana ambaisa la kwava wowola ikanukwenu, e ilokaia mina Itai, kawala, ");
INSERT INTO kij_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Yeigu togilagala mitaga asikailimi baisa. Magigu bagimoli sita pwaipwaia metoya baisa yokomi e gagabila babaku ulo kwava.” ");
INSERT INTO kij_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ivitakaulasi, kawasi, ");
INSERT INTO kij_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ka, tomwaya, kulagi. Yakamaisi kadokaimsi tokugwa saina topeula yoku. E avai laka makwaina ikalisau laka komwaidona, baisa goli bukubaku m kwava. Paila availa goli oluwalaimasi bogwa bimwamwasila nanola kidamwa bisemakavi avai laka baisa yoku, kidamwa bukubaku minana.” ");
INSERT INTO kij_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","E mapaila Eberaam ikavagina omitasi, ");
INSERT INTO kij_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","e ikaibiga, kawala, “Kidamwa kutagwalasi mwada babaku ulo kwava baisa, anigadaim bukulukwaisi matauna Sowara latula yagala Epironi ");
INSERT INTO kij_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kidamwa yeigu magigu bagimoli makwaina lagi Makipela, makwaina isisu ola kwabila opapala. Magigu bukunigadaisi matauna bisakaigu makwaina e yeigu bamapuvigasi wala baisa omitami, kidamwa bayosi wala paila laka.” ");
INSERT INTO kij_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","E matauna Epironi titoulela wala isili deli mina Itai okabosigugula makwaina okalapisilela valu. Matauna ivitakauloki Eberaam omitasi komwaidosi baisa, ");
INSERT INTO kij_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","kawala, “Ka, tomwaya, kulagi. Bogwa basemakavi wala makubilana kubilimwaidona deli goli makwaina lagi olopola. Ka, baisa goli omitasi ulo tomota basakaim, kidamwa bukubaku minana m kwava.” ");
INSERT INTO kij_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Mitaga Eberaam ikavagina omitasi mina Itai, ");
INSERT INTO kij_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","e ililivala mimilakatila baisa matauna, mwada goli komwaidosi bilagaisi, kawala, “Mwa! anigadaim goli bukulagi ulo biga. Magigu bamapu makubilana pilamwaidona. Bukutagwala basakaim mapula goli, e bogwa babaku ulo kwava baisa.” ");
INSERT INTO kij_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epironi ivitakaula, ");
INSERT INTO kij_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","kawala, “Wi, tomwaya, kuligaiwa. Ka, mapula gala wala bikalisau lakatuvasi siliba. Baisa gala wala avaka oluwalaida. Kubaku m kwava baisa goli.” ");
INSERT INTO kij_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","E Eberaam itagwala wala e ivisaikoli mapula avaka Epironi eilivala otaigasi tomota, baisa goli lakatuvasi siliba, kwaitala kwaitala kala kwaiveka makawala togigimwala bikaraiwagasi tuta tuta okabogimwala. ");
INSERT INTO kij_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","E baisa makawala Eberaam imapu makubilana omitibogwa Epironi la pwaipwaia, makubilana Makipela isisu mapilana Mamira opilibomatu. E tuta matutona igimoli, eimipugoli kwabila, lagi, e deli kai komwaidona olopola kwabila bila opapala wala. ");
INSERT INTO kij_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","E komwaidosi mina Itai availa availa eisisuaisi yam makwaina e eigisaisi baisa, bogwa ikatetasi kidamwa Eberaam eivigaki la pwaipwaia. ");
INSERT INTO kij_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","E oluvi Eberaam ibaku la kwava Sera makwaina lagi mapilana Kenani. ");
INSERT INTO kij_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","E mauula makubilana omitibogwa mina Itai si kwabila, deli goli makwaina lagi, Eberaam eigimoli la pwaipwaia, e ivigaki kasi laka la tomota. ");
INSERT INTO kij_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Tuta baisa Eberaam saina wala eitomoya e komwaidona avaka eivagi, Guyau leimitukwaii matauna. ");
INSERT INTO kij_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Eberaam idou la tosikwawa e iluki matauna, kawala, “Kuvisuvi yamam okwaipiapagu e bukulivala biga katotila mwau. ");
INSERT INTO kij_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Magigu bukukwavitagi yagala Guyau, matauna walakaiwa deli watanawa la Yaubada, e bukukwatotila goli omatala matauna kidamwa bukunagi Aisake latugu la kwava natana. Gala goli bukunagi natana metoya minasina vilesi Kenani oda valusi baisa. ");
INSERT INTO kij_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ibodi wala bukukwaimilavau bukula ogu valu viloutabugu, e baisa bukubani natana metoya odalegu, kidamwa minana la kwava latugu.” ");
INSERT INTO kij_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","E tosikwawa ikatupoi, kawala, “E kidamwaga minana gala magila bisilavi la viloutoula mwada gala bakama, e ammakawala? Kaina bawitali latum bila om valu viloutabum e bivaisi baisa?” ");
INSERT INTO kij_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Mitaga Eberaam ivitakaula, kawala, “Wa. Kuyamataim goli. Galaga bukuwitali latugu biwa baisa. ");
INSERT INTO kij_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ka, Guyau matauna labuma la Yaubada eimaiyaigu baisa, e ilukwaigu basilavi mapilana tamagu la viloutoula deli dalegu si valu. E Guyau ikatotila baisa yeigu saina peula kidamwa bisaiki mapilana Kenani baisa tubugwa. Ka, matauna biwitali la anelosi bilobogwa omatam, kidamwa bukubani natana latugu la kwava baisʹe. ");
INSERT INTO kij_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kidamwa minana gala magila mwada deli bukumaisi, ka baisa bitanekwaim metoya om biga katotila. Taga, bomam wala bukulau latugu bukuwaisi baisʹe.” ");
INSERT INTO kij_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","E mapaila tosikwawa isaili yamala okwaipiapala Eberaam la guyau, e ikatotila bivagi makawala Eberaam eilivala. ");
INSERT INTO kij_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Matauna tosikwawa ikau Eberaam la kameli buluwotala e ililoula ila matauna Nayo ola valu, mapilana Mesopotemia opiliyavata. ");
INSERT INTO kij_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Yam makwaina iviloubusi baisa, iluki kameli bikanapopulasi otalila utuwotu osisunela valu. E bogwa eikoyavi e ibodi tuta matutona vivila bisunapulasi bikasopisi outuwotu. ");
INSERT INTO kij_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Matauna tosikwawa inigada baisa Yaubada. Kawala, “Mwa! Guyau, yoku ulo guyau Eberaam la Yaubada - ka, bukutagwala bapeula wala yam lagaila, kidamwa bavagi makawala lakatotila baisa ulo guyau. ");
INSERT INTO kij_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Baisa goli atulotula outuwotu, e makateki minasina natubovau vilesi mapilana valu bimaisi bikasopisi. ");
INSERT INTO kij_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","E baluki natana minasina, ‘Anigadaim sita bamom metoya om lukwava.’ Kidamwaga minana bivitakaulokaigu, kawala, ‘Bwaina, kumom. E deli bakasopi bamai bavimom kameli minasina’ - e baisa bikibuboti kidamwa yoku lokunagi minawena paila m towotetila Aisake. E kidamwa bikaloubusi makawala, bogwa banikoli kidamwa yoku lokuvagi makawala m biga katotila baisa ulo guyau.” ");
INSERT INTO kij_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ininigada makawala, e natana yagala Ribeka ima ikokeula yatala lukwava ovilavala. E minana tamala Betuweli, e matauna tamala Nayo, Eberaam bodala, e inala Milika. ");
INSERT INTO kij_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","E minana Ribeka saina namitabwaila e vilakapugula minana gala avai tuta availa imisii minana. E minana isalili ila outuwotu ikasopi e imwenavau. ");
INSERT INTO kij_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","E tosikwawa isakaula ila ibodi minana, kawala, “Ve! Anigadaim sita bamom metoya om lukwava.” ");
INSERT INTO kij_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ikaibiga kawala, “Bwaina wala tomoya, kumom.” E nanakwa ivabu miyana metoya ovilavala, ikikuloti paila bimom. ");
INSERT INTO kij_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Imom iwokuva, e minana ikaibiga, kawala, “Tuvaila bala akasopi paila minasina kameli, kidamwa natana natana bimomsi.” ");
INSERT INTO kij_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","E inanakwa iligabu sopi okasi damwau mauna e isakaula ila outuwotu kidamwa bimai tuvaila kasi sopi kameli e imai avaka ibudoki komwaidosi minasina. ");
INSERT INTO kij_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","E matauna tosikwawa ikapatu wala imitakavati minana, mwada bigisi kidamwa Guyau eitagwala bipeula la vavagi. ");
INSERT INTO kij_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Bogwa leivenoku minana, e matauna ikau kala gosa goula saina mwau mapula, e isaili okabulula, e deli ivilili kwaiyu kala mtuwetuwa kwevakaveka goulawokuva oyamala. ");
INSERT INTO kij_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","E ikaibiga, kawala, “Ve! Kulukwaigu avai tau tamam. Ki, gagabila bukuvaulaimasi deli ulo towotetila paila bogi makwaina?” ");
INSERT INTO kij_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","E minana ikaibiga, kawala, “Tamagu yagala Betuweli, e tubugwa Nayo sola Milika. ");
INSERT INTO kij_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","E oma valusiga bidubadu kasi kawailuwa mauna, e gagabila wala bakavaulaimi.” ");
INSERT INTO kij_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","E matauna ikavagina itemmali Guyau. ");
INSERT INTO kij_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ikaibiga, kawala, “Ayakawolaim yoku Guyau, yoku la Yaubada ulo guyau Eberaam, paila tokimadagi wala yoku, e bogwa lokuvagi makawala m biga katotila baisa ulo guyau. Paila lokuvakadaigu duwosisia goli, e asaitaula wala laboda dalela ulo guyau.” ");
INSERT INTO kij_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","E minana isakaula ilokaia inala ola bwala, e ikamituli komwaidona avaka eikaloubusi. ");
INSERT INTO kij_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","E taitala luleta Ribeka isisu, yagala Lebani. E matauna nanakwa isunapula kidamwa bilokaia utuwotu ambaisa matauna Eberaam la tosikwawa isisu. ");
INSERT INTO kij_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Paila Lebani leigisi kala gosa kala mtuwetuwa avaka luleta eisikoma, e ililagi minana ilivala avaka tosikwawa eiluki minana. E ilokaia matauna Eberaam la tosikwawa, itotu outuwotu deli kameli. ");
INSERT INTO kij_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ikaibiga, kawala, “Kuma bitalosi goli ogu bwala. Paila yoku mokwita goli Guyau eimitukwaiyaim. Avaka uula kutomakava baisa okoukweda? Ka, bogwa lakatubiasi kabam ogu bwala, e gagabila kameli tuvaila bimaisi.” ");
INSERT INTO kij_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Mapaila tosikwawa ila isuvi wa bwala. E Lebani ivabu guguwa okameli, e isaiki kasi kawailuwa deli ikatubiasi kabasi kameli. Oluvi imai sitana sopi kidamwa Eberaam la tosikwawa deli sala biwinaisi kaikesi. ");
INSERT INTO kij_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","E imai kaula, mitaga matauna tosikwawa ikaibiga, kawala, “Gala wala bakam. Igau bitabigatonasi biwokuva, oluviga kamkwam.” E Lebani ikaibiga, kawala, “Kulivala wala.” ");
INSERT INTO kij_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ikaibiga, kawala, “Yeigu Eberaam la tosikwawa. ");
INSERT INTO kij_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Guyau Yaubada saina eimitukwaii ulo guyau mauula tuta baisa la guguwa saina bidubadu. Yaubada bogwa leisaiki matauna yuwovakaveka sipi, gota, bulumakau, e tuvaila isisii goula, siliba, bidubadu la ula tauwau deli vivila, e kameli deli ase buluwovila. ");
INSERT INTO kij_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Minana Sera, la kwava ulo guyau, eivinumoya mitaga iuni latula tau goli, e ulo guyau eisaiki matauna komwaidona avaka avaka eisisii. ");
INSERT INTO kij_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ulo guyau ilukwaigu mwada bakatotila saina peula kidamwa bakabikuwoli kwaitala la karaiwaga. “Kawala, ‘Gala goli bukunagi natana la kwava latugu metoya minasina vilesi Kenani. ");
INSERT INTO kij_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mitaga bukulokaia tamagu la viloutoula, baisa dalegu si valu.’ ");
INSERT INTO kij_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","E lakatupoi matauna ulo guyau, kawagu, ‘Kidamwaga minana gala magila deli bakama, ammakawala?’ ");
INSERT INTO kij_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Matauna ivitakaulokaigu, kawala, ‘Tuta komwaidona lakabikuwoli Guyau Yaubada, e matauna goli biwitali la anelosi e deli bukulosi, e mauula bogwa bukupeula. Bogwa bukubani la kwava latugu metoya baisa dalegu, matausina tamagu tubula goli. ");
INSERT INTO kij_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","E kwaitala wala vavagi bitanekwaim metoya om biga katotila. Ka, kidamwa bukulokaia dalegu, e matausina bipakaimsi, baisa goli bogwa bitanekwaim.’ ");
INSERT INTO kij_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“E yam lagaila aviloubusi outuwotu. E lanigada, kawagu, ‘Mwa! Guyau, yoku ulo guyau Eberaam la Yaubada, anigadaim bukutagwala bapeula wala avaka lauvagi. ");
INSERT INTO kij_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Baisa goli atulotula outuwotu. E avai tuta natana natubovau bima bikasopi, banigadi minana bisakaigu sita sopi bamom metoya ola lukwava. ");
INSERT INTO kij_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","E kidamwa minana bitagwala, e deli bilukwaigu mwada bimai kasi sopi kameli, e bogwa badoki kidamwa yoku Guyau lokunagi minana, kidamwa bukuvigaki minana la kwava ulo guyau latula.’ ");
INSERT INTO kij_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Aninigada wala onanogu e ka, minana Ribeka ima ikokeula lukwava ovilavala, e isalili ila outuwotu bikasopi. E akaibiga baisa minana, ‘Ve! Anigadaim, sita bamom.’ ");
INSERT INTO kij_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","E inanakwa ivabu miyana metoya ovilavala. Kawala, ‘Bwaina wala, kumom. E tuvaila bavimom minasina m kameli.’ E mapaila yeigu amom, e minana ivimom kameli. ");
INSERT INTO kij_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","E akatupoi minana, ‘Availa tamam?’ Minana ivitakaulokaigu, kawala, ‘Tamagu yagala Betuweli, e tubugwa yagasi Nayo sola Milika.’ E asaili kala gosa okabulula, deli avilili makwaisina kala mtuwetuwa oyamala. ");
INSERT INTO kij_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","E, akavagina atemmali Guyau, paila bogwa ivakadaigu duwosisia, e lasaitaula wala bogwa laboda ulo guyau dalela. E baisa goli bogwa labani minana latula vivila ibodi ulo guyau latula bivigaki la kwava. ");
INSERT INTO kij_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","E ammakawala? Ka, yokomi mokwita wala metoya odalela ulo guyau. Kidamwa magimi bukuvagaisi avaka ibodaimi baisa ulo guyau, e ninami mwada bukububunasi duwosisia baisa matauna, anigadaimi bukulukwaigusi banikoli. Kidamwaga gala bukulivalasi mimilakatila, e yeigula baninamsi avaka bavagi.” ");
INSERT INTO kij_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","E Lebani deli tamala Betuweli, ivitakaulokaisi, kawasi, “Guyau Yaubada eiwitali vavagi baisa. Mauula goli gala ibodaima avaka bakakaraiwaga. ");
INSERT INTO kij_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ka, minawena Ribeka isisu, ibodi minana la kwava m guyau latula makawala goli Guyau eililivala. E mapaila kulau, e deli bukulosi.” ");
INSERT INTO kij_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","E tutala Eberaam la tosikwawa ilagi baisa, ikavagina itemmali Guyau. ");
INSERT INTO kij_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","E imai bobwailila isaiki Ribeka, kala kwama, e la veiguwa siliba deli goula. Tuvaila isaiki bobwailila saina mwau mipusi baisa luleta deli goli inala. ");
INSERT INTO kij_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Oluvi Eberaam la tosikwawa deli sala ikamsi, imomsi, ikanamwaisi wala. E, eiyam imamatasi itokaiasi, e tosikwawa ikaibiga, “Bukutagwalasi bakaimilavau balokaia ulo guyau.” ");
INSERT INTO kij_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mitaga Ribeka luleta deli inala ikaibigasi, kawasi, “Gala goli. Kaina bukutagwala minana igau kasi tulaisi kaina biboda kweluwotala yam kainaga wiki kwaitala, e oluvi gagabila deli bukulosi.” ");
INSERT INTO kij_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mitaga ikaibiga, kawala, “Galaga bukusiaimwaimasi. Ka, bogwa lapeula paila vavagi makwaina paila uula Guyau eipilasaigu. Bukutagwalasi wala bakaimilavau e minana deli bakalokaiasi ulo guyau.” ");
INSERT INTO kij_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","E ivitakaulokaisi, kawasi, “Igau bitadouwaisi minana vilakapugula e bitanikolaisi nanola.” ");
INSERT INTO kij_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","E idouwaisi Ribeka ikatupoisi, kawasi, “Ki, magim matauna deli bukulosi?” E minana ivitakauloki, kawala, “Mitaga!” ");
INSERT INTO kij_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","E itugwalaisi minana bilosi deli Eberaam la tosikwawa toyo sala. E Ribeka ilau minana numoya kala toyamata. ");
INSERT INTO kij_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","E ibigibwailisi Ribeka baisa makawala. “Ka, luguta, ibodi tubumwa bidalasi saina bidugaga sainela. E ibodi dalem biyoulisi kasi tilaula si valu.” ");
INSERT INTO kij_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","E Ribeka deli minasina la ula ikatubaiasasi, e isilasi okameli ilosi deli Eberaam la tosikwawa. E ivitouulasi si loula. ");
INSERT INTO kij_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisake ililoula ima oluwalela mapilana viloupakala yagala “Utuwotula Tomomova Matauna Igigisaigu,” e baisa tuta isisu mapilana Kenani opilibolimila. ");
INSERT INTO kij_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","E, ikoyavi, e isunapula mwada bililoula osaivau, e igisi mimilisi kameli eideilisi leimaisi. ");
INSERT INTO kij_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Tutala Ribeka igisi matauna Aisake, e minana isilabusi metoya ola kameli, ");
INSERT INTO kij_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","e ila ikatupoi Eberaam la tosikwawa, kawala, “Ki, avai tau matauna ililoula osaivau imakaiadasi baisa?” E tosikwawa ivitakauloki, kawala, “Matauna ulo guyau.” Mapaila Ribeka ikau yatala yagesi e itabodi migila. ");
INSERT INTO kij_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tosikwawa iluki Aisake komwaidona avaka avaka eivagi. ");
INSERT INTO kij_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","E Aisake imai minana isuvisi makwaina buliyoyova omitibogwa inala Sera bolela. E Aisake sola Ribeka ivaisi. Aisake iyebwaili Ribeka, e ivigaki kala visimoli paila inala bogwa eikaliga. ");
INSERT INTO kij_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eberaam ivaivau natana tuvaila vivila, yagala Ketura. ");
INSERT INTO kij_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","E ola bwala Eberaam minana iuni Simrana, Yokisani, Medani, Midiani, Isibaki, deli Suwai. ");
INSERT INTO kij_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokisani iuni Seba deli Dedani, e Dedani tubula mina Asuri, mina Letusi, deli mina Leum. ");
INSERT INTO kij_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","E litula Midiani yagasi, Epa, Eperi, Anoki, Abida, deli Elidaa. Komwaidosi matausina Ketura tubula. ");
INSERT INTO kij_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","E Eberaam la guguwa komwaidona isaiki Aisake kala bigukeya, ");
INSERT INTO kij_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","mitaga igau otobwailala, isaiki kasi bobwailila litula matausina eiuni, mitaga inisia ituwoli. E iyabi matausina ilosi mapilana valu opilibomatu, e isilavaisiga Aisake. ");
INSERT INTO kij_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","E Eberaam bogwa saina eitomoya kala taitu iboda lakatutala kwailuwolima kwailuwoyu kwailima; matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","E litula Aisake sola Isimeili ibakwaisi matauna wa Lagi Makipela, mapilana Mamira opilibomatu, kwabila makubilana metoya baisa Epironi matauna Sowara latula guma Itai. ");
INSERT INTO kij_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","E kwabila makubilana Eberaam eigimoli metoya baisa mina Itai; e kasitaiyu wala Eberaam sola la kwava Sera ibakwaisi metoya baisa. ");
INSERT INTO kij_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","E tutala Eberaam bogwa eikaliga Yaubada ikabwaili Aisake, matauna isisu katitaikinela makwaina utuwotu yagala, “Utuwotula Tomomova Matauna Igigisaigu.” ");
INSERT INTO kij_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isimeili, inala Ega ola bwala Eberaam, minana vilela Itipita e Sera la ula; ");
INSERT INTO kij_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","e matausina Isimeili litula yagasi eikasasi kuluta leila kasusu, Nebaioti, Kedara, Adibieli, Mibisam, ");
INSERT INTO kij_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO kij_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adadi, Tema, Yeturi, Napisa, deli Kedema. ");
INSERT INTO kij_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Matausina tubusia madilasina dilaluwotala dilayu, e yagasi titoulesi idokaisi si valu deli si kabovaiwasi. ");
INSERT INTO kij_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","E Isimeili kala taitu iboda lakatutala kwailuwotolu kwailima kwaiyu matauna ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","E Isimeili tubula isisuaisi oluwalaisi Abila deli Sura, mapilana opilibomatu bilokaia Itipita okedala bila Asiria. Mabudona isipalasi metoya mabudosina tubula Eberaam. ");
INSERT INTO kij_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Baisa liliula Eberaam latula yagala Aisake. ");
INSERT INTO kij_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tutala ivaisi sola Ribeka, Aisake kala taitu iboda kweluwovasi taitu. E minana tamala Betuweli matauna guma Aramia mapilana Mesopotemia. E Ribeka luleta yagala Lebani. ");
INSERT INTO kij_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Minana Ribeka nakaliga wala, e mapaila Aisake inigada baisa Guyau paila minana titoulela. E Guyau ilagi e imapu la nigada, e mapaila Ribeka isuma wala. ");
INSERT INTO kij_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Bogwa bivilulu litula nupoyu, e igau makateki bikaloubusisi, saina iyowaisi kasitaiyu olopola inasi. E minana ikaibiga, kawala, “Wi. Avakaga uula aboda makawala baisa?” Mapaila ila mwada bikatupoi baisa Guyau, e bibani avaka uula. ");
INSERT INTO kij_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","E Guyau iluki minana, kawala, “Magudisina nupoyu olopom bavigaki budoyu tomota. E bukuvilulu budoyu tomota wala. Budotala bivigaki kasi tilaula baisa buduyuwela E budotala bitomgwaga baisa buduyuwela. Molitomoya igau biwotitali molagwadi.” ");
INSERT INTO kij_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Bogwa leima kala tuta bitapoi yamala e ivalulu nupoyu litula tauwau. ");
INSERT INTO kij_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Matauna molitomoya tobweyani, e wowola isim unuunula kala gigisa makawala kakapula saina yaunuunu e mapaila ivabwaisi yagala Iso. ");
INSERT INTO kij_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Matauna molagwadi tutala ikaloubusi, ikikikola okaigadula kaikela tuwala, e mapaila ivabwaisi yagala Yekobe. E tutala ikaloubusisi, tumasi Aisake bogwa iboda kweluwolima kweluwotala kala taitu. ");
INSERT INTO kij_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Gugwadi itovakavekasi, e Iso imila towawaiga, towaiga komwaidosi kasi tokugwa. Matauna saina mbwailila sunini olawodila. Mitaga Yekobe tomanum wala, tosikuvalu wala. ");
INSERT INTO kij_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisake tombwailila Iso, paila saina magila bikam minasina bolodila avaka Iso eiwawaiga. Mitaga Ribeka tombwailila Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kwaitala yam Yekobe isulusulu kala bini, e Iso ikaloubusi metoya wawaiga e ima ovalu. Matauna saina kala molu, ");
INSERT INTO kij_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","e iluki bodala Yekobe, kawala, “Wo, saina agu molu. Kumai sitana akoma kam kwawailuwa kwebweyani.” (Ka, baisa uula tomota idokaisi matauna yagala Edom.) ");
INSERT INTO kij_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yekobe ivitakauloki, kawala, “Ka, bogwa basakaim kidamwaga yoku bukutugwali m kwaikeya baisa yeigu.” ");
INSERT INTO kij_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso ikaibiga, kawala, “Bwaina wala. Ka, makateki bakaliga, e gala avaka ulo kaikeya mwadaga bipilasaigu.” ");
INSERT INTO kij_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","E Yekobe ikaibiga, kawala, “Ikugwa kulivala biga katotila peula kidamwa bogwa bukutugwali m kwaikeya baisa yeigu.” E Iso ikatotila makawala, e itugwali la kaikeya baisa Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","E oluvi Yekobe isaiki sita kaula deli lubwaula lokwai. Iso ikam, imom, ikomata e itokaia isunapula. E baisa makawala goli Iso ikaluwou la kaikeya. ");
INSERT INTO kij_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Molusaula kwaitala tuvaila ikaloubusi mapilana valu, ituwoliga makwaina ola tuta Eberaam. E Aisake ilokaia Abimeleki, guyoula Pilisitia, mapilana Gerara. ");
INSERT INTO kij_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Guyau iyoumatila baisa Aisake e ikaibiga, “Gala bukula Itipita, kusisu wala valu mapilana ambaisa lalukwaim bukusisu. ");
INSERT INTO kij_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kumilivalu baisa, e yeigu deli yoku, e bogwa bakabwailim. Yeigu basakaim deli tubumwa komwaidona valu mavilousina. Bavagi makawala ulo biga katotila baisa tamam Eberaam. ");
INSERT INTO kij_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Basakaim tubumwa kala bidubadu makawala utuyam wa labuma, e basaiki matausina komwaidona valu mavilousina. E boda komwaidona binigadaigusi paila bakabwaili matausina makawala goli lakabwaili tubumwa. ");
INSERT INTO kij_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Yeigu bakabwailim, paila uula Eberaam ikabikuwolaigu deli iuvagi makawala ulo karaiwaga makwaisina.” ");
INSERT INTO kij_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Mapaila Aisake imilivalu mapilana Gerara. ");
INSERT INTO kij_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Avai tuta tomotela mapilana valu ikatupoisi paila la kwava, matauna iluki mwada minana luleta wala. E gala igagabila bikamituli paila minana la kwava, paila uula ikukoli tomotela mapilana valu mwada bikatumataisi matauna e bivaiyasiga Ribeka, paila minana saina namatabwaila. ");
INSERT INTO kij_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Avai tuta Aisake bogwa leisimolila mapilana valu, guyau Abimeleki itadoyai oponana, e igisi Aisake eimisii Ribeka. ");
INSERT INTO kij_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Mapaila Abimeleki idou Aisake, e iluki kawala, “Ka, bogwa lavitoki tolosila, minana m kwava wala! Avakaga uula lokulivala mwada minana lumta ke?” E Aisake ivitakauloki kawala, “Mwa ulo nanamsa, kidamwa bakamituli minana ulo kwava bogwa wala bikatumataigusi.” ");
INSERT INTO kij_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","E Abimeleki ikaibiga kawala, “Avaka baisa lokuvigakaimasi? Mwa! Kileta wala gala taitala ulo tomota imisii m kwava, e kaguyam yoku bikaiki wowom paila ma sulasi.” ");
INSERT INTO kij_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimeleki ikatululuti komwaidona tomota kawala, “Kidamwa availa matauna bilamidadi tau matauna kaina la kwava bakakatumataisi.” ");
INSERT INTO kij_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aisake ibiguli pwaipwaia makwaina, e taitu makwaina matauna itaiyau lakatutala ikalisau la kwaisi kwaibogwa, paila uula Guyau imitukwaii matauna. ");
INSERT INTO kij_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Matauna la kaisisu ikobaluluva e ivigaki matauna saina todabala. ");
INSERT INTO kij_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Paila iyosi saina bidubadu la sipi, la bulumakau, deli la ula, e mina Pilisitia ipukwa kaiyasi paila la kaisisu. ");
INSERT INTO kij_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mapaila mina Pilisitia ikalidubolaisi komwaidona utuwotu makwaisina tamala Eberaam la towotetila eikelaisi avai tuta Eberaam igau eisisu otobwailala. ");
INSERT INTO kij_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Oluvi Abimeleki iluki Aisake kawala, “Kusilavi ma valusi. Paila bogwa lokukwalisauwaimasi.” ");
INSERT INTO kij_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Mapaila Aisake igala e ila ibudi valu oItayatilela Gerara, e imilivalu metoya mapilana valu. ");
INSERT INTO kij_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","E matauna ikelivau utuwotu makwaina mina Pilisitia eikalidubolaisi avai tuta Eberaam eikaliga. Utuwotu makwaisina eikelaisi ola tuta Eberaam. E Aisake idoumapu yagasi utuwotu makwaisina maigasina wala tamala eidoubogwi. ");
INSERT INTO kij_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aisake la touwata ikelaisi kwaitala utuwotu oitayatila e ibanaisi sopi. ");
INSERT INTO kij_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","E mina Gerara toyamata sipi ikominimanisi deli Aisake la toyamata sipi ilivalasi kawasi, “Sopi makwaina kama sopisi.” Mapaila Aisake idoki yagala utuwotu makwaina “Kominimani”. ");
INSERT INTO kij_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","E Aisake la touwata ikelivauwaisi utuwotu kwaitala tuvaila, mitaga tuvaila wala kominimani itokaia paila sopi makwaina makawala kwaibogwa, mapaila idoki yagala utuwotu makwaina “Kwekukologu”. ");
INSERT INTO kij_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","E igalasi metoya baisa e ilosi ewaiwa ikelaisi kwaitala utuwotu tuvaila. E makwaina gala isim kominimanila, mapaila idoki makwaina yagala “Taneku”. Matauna ilivala kawala, “Tuta baisa Guyau bogwa eitanekwaidasi paila bitamilivalusi baisa, e bogwa wala bitayubwailasi.” ");
INSERT INTO kij_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Aisake igala ila Biasiba. ");
INSERT INTO kij_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Wa bogi makwaina Guyau iyoumatila baisa matauna iluki kawala, “Yeigu tamam Eberaam la Yaubada. Gala bukukokola. Yeigu deli yoku. E bogwa wala bakabwailim e bavigaki tubumwa bidalasi makawala ulo biga katotila baisa ulo touwata Eberaam.” ");
INSERT INTO kij_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","E Aisake ikaliyaiya kwaitala kabogabu lula, e itaimamila baisa Guyau. E makatupona wala ibudi la kabosikaiwa, e la touwata ikelaisi kwaitala utuwotu tuvaila. ");
INSERT INTO kij_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimeleki, Ausata matauna la tokatayuvisa, deli Pikoli matauna la tokwabilia si kumatoula metoyasi Gerara leimaisi bigisaisi Aisake. ");
INSERT INTO kij_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Mapaila Aisake ikatupoi matausina, “Avaka paila yokomi lagaila wala lokumaisi bukugisaigusi ke? Ka, omitibogwa yokomi tokukolomi wala yeigu, e kukwaliyabaigusi lasilavi mi valu.” ");
INSERT INTO kij_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","E matausina ivitakaulokaisi matauna kawasi, “Baisa tuta kanikolaisi Guyau deli yoku, e kananamsasi ibodi wala bitaninatalasi oluwalaidasi. Magimasi yoku bukukwatotila ");
INSERT INTO kij_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","mwada gala bukuyogagaimasi, e makawala goli yakamaisi gala kayogagaimsi. Omitibogwa yakamaisi lakamitukwaiyaimsi e katagwalasi lokusilavaimasi olopola vakota. Tuta baisa saina mimilakatila Guyau bogwa wala eikabwailim.” ");
INSERT INTO kij_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","E Aisake ivagi kwaitala paka paila matausina, e ikamkwamsi deli imomomsi. ");
INSERT INTO kij_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","E eiyam kaukwau pikekita taitala taitala ibiga katotila, e ikatukikitaisi si biga katotila. Aisake italoi e matausina lubaila goli ikatuwakedasi ilosi. ");
INSERT INTO kij_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Wa yam makwaina wala Aisake la towotetila imaisi ilukwaisi matauna paila utuwotu makwaina eikelaisi. Matausina ikaibigasi, “Mwa, bogwa kabanaisi sopi.” ");
INSERT INTO kij_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","E matauna idoki utuwotu makwaina yagala “Katotila”. Baisa makawala valu Biasiba yagala eidokaisi. ");
INSERT INTO kij_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Avai tuta Iso kala taitu iboda kwailuwovasi, e matauna ivaiya nayu vivila vilesi Itai, yagasi Duditi minana Bieri latula, e Basimata minana Eloni latula. ");
INSERT INTO kij_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","E minasina iyomwauwaisi Aisake sola Ribeka si kaisisu. ");
INSERT INTO kij_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Baisa tuta Aisake bogwa eitomoya, e eikau wala. E idou molitomoya Iso iluki matauna, kawala, “Mwa! Latugʹo.” E ivitakauloki, kawala, “Mayeigu ka.” ");
INSERT INTO kij_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisake ikaibiga, kawala, “Ka, bogwa latomoya, e kaina makateki bakaliga. ");
INSERT INTO kij_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Mapaila kukwau m kwaiyala, e kula olawodila kubasi natana agu bolodila. ");
INSERT INTO kij_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","E oluvi kusulu kʹagu kwaitala kalumatabwaila e kumai bakam. Oluvi basakaim kam kwabwaila, paila ulo kaliga makateki wala.” ");
INSERT INTO kij_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Aisake ililivala makawala baisa Iso mitaga Ribeka bogwa inakaigali. E tutala Iso isunapula bila iwaiga, ");
INSERT INTO kij_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","e minana iluki Yekobe, kawala, “Ka, bogwa lalagi tamam iluki Iso, kawala ");
INSERT INTO kij_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Kumai agu bolodila e kusulu paila yeigu. Tutala bakam biwokuva, e basakaim kam kwabwaila, paila makateki bakaliga wala.? ?? ");
INSERT INTO kij_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","E Ribeka ikaibiga, kawala, “E latugu, ka, ibodi bukulagi bukuvagi avaka balukwaim. ");
INSERT INTO kij_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kula mayuwona gota bukunagi nayu nagugugwadi napusoposa, e kumai basulu kʹala tamam kalumatabwaila. ");
INSERT INTO kij_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","E ibodi bukuuyoki tamam bikam e bisakaim kam kwabwaila e bikaligaga.” ");
INSERT INTO kij_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Mitaga Yekobe iluki inala, kawala, “Ka yoku kunikoli matauna Iso tounuunu, mitaga yeigu todudubuna. ");
INSERT INTO kij_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kaina tamagu bikabikonaigu e binikoli lasipuloki matauna, e makawala goli bogwa babani agu bolata, gala wala agu kwabwaila bakau.” ");
INSERT INTO kij_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mitaga inala ivitakaula, kawala, “Kidamwa bisakaim kam bolata, ka latugu, yeigu bakeula agu pakula mabigasina. Desi wala. Yokugwa kuvagi wala avaka lalukwaim. Kula kumai minasina gota baisa yeigu.” ");
INSERT INTO kij_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","E mapaila ila wala imai minasina gota isaiki inala, e minana isulu kʹala tamala kalumatabwaila. ");
INSERT INTO kij_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","E minana eisisia Iso kala kakapula yaminabwaita ola bwala. Mapaila imai miyana ivisikoma Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","E ivisikoma minasina gota kanuvinesi oyamala Yekobe, e deli isaili okaigadula ambaisa gala unuunula. ");
INSERT INTO kij_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","E minana isaiki Yekobe kʹala tamala kalumatabwaila, deli makwaina kaula eisulu makateki. ");
INSERT INTO kij_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","E Yekobe ilokaia tamala, kawala, “Tamagu.” E ivitakauloki, kawala, “Mayeigula. Ka litugwa taiyu, e avai taugwa yoku?” ");
INSERT INTO kij_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","E Yekobe ivitakauloki matauna, kawala, “Yeigula latum Iso molitomoya. Ka bogwa lavagi makawala kulukwaigu. Anigadaim kusimalaula kukwam kam viliona avaka lamiakaim, e mapaila gagabila bukusakaigu agu kwabwaila.” ");
INSERT INTO kij_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","E Aisake ikaibiga, kawala, “Mwa! Latugu, ammakawalaga saina nanakwa lokubani agu bolodila?” E Yekobe ivitakaula kawala, “Guyau m Yaubada ipilasaigu e bogwa labani.” ");
INSERT INTO kij_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","E Aisake iluki Yekobe, kawala, “Anigadaim kusimada bakabikonaim. Ki mokwitala yoku Iso?” ");
INSERT INTO kij_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yekobe isimada okaipapala tamala, e Aisake ikabakakavi, kawala, “Kaigam makawala Yekobe, yamamgwa makawala Iso.” ");
INSERT INTO kij_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aisake gala wala binikoli Yekobe, paila yamala saina unuunula makawala Iso yamala. E makateki bisaiki kala kabwaila, ");
INSERT INTO kij_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","mitaga ikatupoivau, kawala, “Ki mokwita goli yoku Iso, ke?” E ivitakaula, kawala, “Yeigu goli.” ");
INSERT INTO kij_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aisake ikaibiga, kawala, “Kumai sitana agu viliona bakam. Oluvi goli basakaim kam kwabwaila.” Yekobe imiaki matauna, e tuvaila imai sitana kala waini. ");
INSERT INTO kij_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","E tamala iluki matauna, kawala, “Latugu kusimada kuviyuwolaigu.” ");
INSERT INTO kij_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yekobe ima biviyuwoli, e Aisake isikoni maiinela kala kakapula, e mauula isaiki kala kabwaila. Ikaibiga, kawala, “Latugu, maiinela saina simasimina wowom, makawala maiinela bagula makwaina Guyau eimitukwaii. ");
INSERT INTO kij_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ibodi Yaubada bivinumli m bagula kidamwa bikabinai sainela. Ibodi tomota bimitukwaiyaim bisakaim kaula deli waini saina bidugaga. ");
INSERT INTO kij_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ibodi tomota ituwoli bona ituwoli bona biwotitalaimsi e deli bikavaginasi baisa omatam. Ibodi bisim m kwaraiwaga baisa dalem komwaidona. Availa availa bisakaimsi kam bolata, ibodi bibanaisi kasi bolata. Availa availa bisakaimsi kam kwabwaila, ibodi bibanaisi kasi kabwaila.” ");
INSERT INTO kij_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisake ivenoku kala kabwaila Yekobe, e Yekobe isunapula. E matutona tuwala Iso isuvi imai kala bolodila tumasi. ");
INSERT INTO kij_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","E matauna tuvaila isulu kʹala tamala kalumatabwaila, e imiaki tamala. Kawala, “Tamagu, ka anigadaim kusimalaula kukwam kam viliona avaka lamiakaim, e gagabila bukusakaigu agu kwabwaila.” ");
INSERT INTO kij_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","E Aisake ikatupoi, kawala, “Availaga yoku?” E ivitakaula, kawala, “Yeigula latum molitomoya Iso.” ");
INSERT INTO kij_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aisake ivitouula itatatuva wowola deli la nokubukubu sainela, e ikatupoi, kawala, “Availaga matauna makateki ikatumati agu bolodila e imiakaigu? Paila igau gala bukusuvi, lakambogwa. Paila bogwa lasaiki iyavila ulo kabwaila baisa matauwena. Matauna goli eikoumkulovi kala kabwaila gala biwokuva, bikanigaga goli.” ");
INSERT INTO kij_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tutala Iso ilagi baisa, iuwakula kaigala kaigaveka nanola saina mmayuyu e ikaibiga, kawala, “Tamagʹo, yeigu tuvaila. Bukusakaigu agu kwabwaila.” ");
INSERT INTO kij_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Aisake ivitakaula, kawala, “Wo, bodam leima eisipulokaigu. Bogwa eikau kam kwabwaila.” ");
INSERT INTO kij_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iso ikaibiga, kawala, “Ka, tuta baisa siviyuwela eisipulokaigu. Ka mokwitatoula matauna yagala Yekobe. Ikugwa eikau ulo kaikeya yeigu molitomoya, e tuta baisa ikau agu kwabwaila. Ki gala kwaitala kuyosi agu kwabwaila?” ");
INSERT INTO kij_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aisake ivitakaula, kawala, “Mwa! Latugu, bogwa lakaraiwaga matauna biguyoi odabam, e deli veyala lavigaki la ula. E lasaiki kaula deli waini. E bogwa leiwokuva, gala avaka gagabila bavagi paila yoku.” ");
INSERT INTO kij_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Mitaga Iso iyokakapisi baisa tamala, kawala, “Ki, tamagu, gala wala kwaitala kabwaila isisu, ke? Tamagʹo, kusakaigu agu kwabwaila tuvaila!” E ikapwali la koku ivalam. ");
INSERT INTO kij_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","E Aisake iluki matauna, kawala, “Yaubada gala bivinumli m bagula, e m bagula gala wala bikabinai. ");
INSERT INTO kij_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","M puluta wala bivigakaim bukutokwaraiwaga, mitaga bukuwotitali bodam. E avai tuta mwada bukukoulovi la karaiwaga, E tuta matutona goli bogwa bukukwalisau.” ");
INSERT INTO kij_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso saina igaga nanola baisa bodala paila uula tamala leisaiki Yekobe kala kabwaila. E ininamsi, kawala, “Makateki goli tamagu bikaliga, e yeigu bavalam. Mitaga tutala basimla, e bogwa bakatumati Yekobe.” ");
INSERT INTO kij_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mitaga tutala Ribeka ilagi Iso nanola, idou Yekobe iluki matauna, kawala, “Ka tuwam magila bikiduwosisii vavagi makwaina metoya om kwaliga. ");
INSERT INTO kij_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mapaila latugu, ka, ibodi bukuvagi avaka balukwaim. Bukunanakwa wala bukulokaia luguta Lebani mapilana Erana, ");
INSERT INTO kij_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","e bukusisu wala baisa, igau tutala biminumki nanola paila la gibuluwa tuwam, ");
INSERT INTO kij_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","e bilumwelavi baisa avaka lokuvigaki matauna. E oluvi bawitali availa biuyokaim biga, e bukukwaimilavau baisa. Ki, avakaga kala bwaina kidamwa kasitaiyu litugwa bibodasi kaliga yamla kwaitala wala?” ");
INSERT INTO kij_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ribeka iluki Aisake, kawala, “Ka, bogwa lakamagwesi paila minasina vilesi kedakeda Iso la kukova. Kidamwa Yekobe tuvaila bivai natana minasina vilesi Itai, kaina bibodi yeigu bakaliga wala.” ");
INSERT INTO kij_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Mapaila Aisake idou Yekobe inokagutoki, e iluki matauna, kawala, “Gala bukuvaiya natana vilela Kenani. ");
INSERT INTO kij_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Kaimapula wala, kula mapilana Mesopotemia, e bukulokaia tabum Betuweli ola valu, kidamwa bukuvaiya natana vilakapugula baisa, kainaga natana kadam Lebani latula vilakapugula. ");
INSERT INTO kij_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ibodi Yaubada Topeuligaga bikabwaili m veivai e bukubani litumwa bidubadu, kidamwa bidubadu mina watanawa tubusi yoku. ");
INSERT INTO kij_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ibodi Yaubada bimitukwaiyaim deli tubumwa, makawala eimitukwaii Eberaam. E ibodi yoku igau wala bukuyosi mapilana bukuvigaki m pwaipwaia, paila yoku mokusisiki, e omitibogwa Yaubada bogwa eisaiki Eberaam.” ");
INSERT INTO kij_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","E Aisake iwitali Yekobe ila mapilana Mesopotemia, kidamwa bilokaia Lebani, matauna Betuweli guma Aramia latula. E matauna luleta Ribeka, minana inasi Yekobe sola Iso. ");
INSERT INTO kij_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iso ilagi kidamwa Aisake eisaiki Yekobe kala kabwaila, e oluvi iwitali bila Mesopotemia bibani la kwava. E tuvaila ilagi kidamwa tutala Aisake isaiki kabwaila iluki taga bivaiya natana vilela Kenani. ");
INSERT INTO kij_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","E inakaigali kidamwa Yekobe ikabikuwoli tamala deli inala e bogwa leila Mesopotemia. ");
INSERT INTO kij_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","E mapaila Iso ikateta kidamwa tamala gala eiyomwasali nanola paila minasina vilesi Kenani. ");
INSERT INTO kij_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","E mapaila Iso ilokaia matauna Isimeili, Eberaam latula, e ivaiya natana Isimeili latula, yagala Maalati. E minawena tuwala Nebaioti. ");
INSERT INTO kij_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yekobe isilavi Biasiba e ililoula bila Erana. ");
INSERT INTO kij_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Bogwa eisalili kalasia, imakaia pilatala valu viloubumaboma e isisu baisa. E ikau kwaitala dakuna ivigaki kala kabaikunu e ikenu imasisi. ");
INSERT INTO kij_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Imimi, e wa mimi igisi kaboteta metoya valu watanawa bila wa labuma e igisi anelosi imweimwenasi ibubusisi. ");
INSERT INTO kij_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","E, ka, Guyau itotu opapala, kawala, “Yeigu Guyau, Eberaam deli Aisake si Yaubada. Pwaipwaia makwaina ambaisa lokukwanukwenu bogwa basakaim yoku deli tubumwa. ");
INSERT INTO kij_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","E tubumwa bidalasi saina bidugaga, kasi bawa makawala tubumyou odabala pwaipwaia. Bogwa biyoulisi si valu ambaisa ambaisa, e yeigu bamitukwaii komwaidosi mina watanawa metoya baisa yoku deli tubumwa. ");
INSERT INTO kij_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","E kululuwai baisa yeigu basikailim deli bakolaim ambaisa ambaisa bukula, e bakaimilivauwaim mapilana valu baisa gala goli basilavaim igau tutala bavigimkulovi komwaidona avaka lakatotila baisa yoku.” ");
INSERT INTO kij_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yekobe imamata e ikaibiga, kawala, “Wa! Guyau isisu wala baisa! Ka, isisu mapilana valu goli e yeigu gala wala anikoli.” ");
INSERT INTO kij_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ikokola e ikaibiga, kawala, “Wi. Saina agu kokola. Kaina baisa goli Yaubada la bwala. Kaina goli baisa labuma kalapisilela.” ");
INSERT INTO kij_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Igau ikikivisiga Yekobe itokaia. E ikau kabaikunu dakuna makwaina e itomiliwoli ivigaki kaboluluwai. E iligabu bulamila olibe odabala dakuna makwaina, e makawala ikabomi makwaina baisa Yaubada. ");
INSERT INTO kij_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","E idoki mapilana yagala Beteli. (E omitibogwa mapilana viloubogwa yagala Lusi.) ");
INSERT INTO kij_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","E tuta baisa Yekobe ilivala la biga katotila baisa Guyau, kawala, “Kidamwa yoku bukusikailigu deli bukukolaigu baisa ogu kwaidadina, e deli bukusakaigu agu kwalaga deli agu kwama, ");
INSERT INTO kij_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","e tuvaila kidamwa gala wala basilagi mitaga bakaimilavau baisa ola valu tamagu, e ka! - bogwa bavigakaim yoku ulo Yaubada. ");
INSERT INTO kij_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Bogwa latomiliwoli dakuna makwaina lavigaki kaboluluwai, kidamwa mapilana valu bibodi tomota bitapwarorusi baisa yoku. E tuvaila bogwa basakaim tala metoya luwotala komwaidona avaka avaka bukusakaigu.” ");
INSERT INTO kij_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yekobe isaitaula ilokaia mapilana opilibomatu. ");
INSERT INTO kij_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","E nanakwa ibani utuwotu osaivau, e yuwotolu sipi itoulaisi makwaina. Paila bivimomwaisi minasina metoya makwaina utuwotu, e dakuna kwaiveka ikanubodi wodola utuwotu. ");
INSERT INTO kij_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","E avai tuta yuwomwaidona sipi bimaisi baisa e toyamata sipi bilopipinaisi dakuna e bivimomwaisi minasina. Oluvi bilopipinaisi bikaimilivauwaisi dakuna owodola utuwotu. ");
INSERT INTO kij_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yekobe ikatupoi toyamata sipi, kawala, “Segwaia, ammokutoyasi?” Ikaibigasi, “Yakamaisi mina Erana.” ");
INSERT INTO kij_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","E ikatupoi, kawala, “Ki sitana kunikolaisi matauna Lebani Nayo latula?” E ivitakaulasi, “Mitaga.” ");
INSERT INTO kij_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","E ikatupoi, kawala, “Ammakawala matauna, bwaina wala, ke?” Ivitakaulasi, “E, bwaina wala isisu. Ka kugisi minawena latula Retieli leima deli la sipi tamala.” ");
INSERT INTO kij_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","E Yekobe ikaibiga, kawala, “Tuta baisa yam wala e gala ibodi tuta baisa bukuvisuvisi sipi okasi kali. Avaka paila gala kuvimomwaisi minasina, e gagabila bukukwaimilivauwaisi bikabubunasi tuvaila?” ");
INSERT INTO kij_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","E ivitakaulokaisi, kawasi, “Galaga gagabila bakavagaisi igau tutala komwaidona mayuwosina bitotusi baisa, e bogwa bilopipinaisi dakuna. Oluvi goli gagabila bakavimomwaisi mayuwosina.” ");
INSERT INTO kij_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","E igau ililivalasi deli Yekobe, e minana Retieli leima deli la sipi. ");
INSERT INTO kij_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","E tutala Yekobe igisi minana, deli kadala Lebani la sipi, e Yekobe ilokaia utuwotu ilopipini dakuna, e ivimom la sipi minana. ");
INSERT INTO kij_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Oluvi iviyuwoli minana, e ivalam deli la mwasawa. ");
INSERT INTO kij_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","E iluki minana, kawala, “Ka, tamam kadagu. Yeigu Ribeka latula.” Retieli isakaula iluki tamala. ");
INSERT INTO kij_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","E tutala Lebani ilagi bulogala kadala Yekobe, e isakaula, ibodi, ikaipapi iviyuwoli, e imai matauna ola bwala. Tutala Yekobe iluki Lebani komwaidona avaka eikaloubusi, ");
INSERT INTO kij_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","e Lebani ikaibiga, kawala, “Wo, mokwitatoula yoku dalegu.” E Yekobe isisu baisa natana tubukona namwaidona. ");
INSERT INTO kij_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lebani iluki Yekobe, kawala, “Gala bibodi bukupaisewamakava baisa paila uula yoku kadagu. Ki avaka bibodi basakaim mapula m paisewa?” ");
INSERT INTO kij_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","E Lebani litula nayu. Vilitomoya yagala Lea, e vilagwadi yagala Retieli. ");
INSERT INTO kij_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","E Lea matala kweminabwaita. Mitaga Retieli saina namitabwaila, e nagumwakota. ");
INSERT INTO kij_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yekobe saina migibwailila Retieli mapaila ikaibiga, kawala, “Bogwa bawotitalaim biboda kwailima kwaiyu taitu, kidamwa bukutagwala bavaiya minana Retieli.” ");
INSERT INTO kij_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lebani ivitakauloki, kawala, “Kidamwa ibodi bayovaiya minana, e magigu sainela yoku wala. Anigadaim bukusigaga baisa, e deli bitapaisewasi.” ");
INSERT INTO kij_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yekobe iwotetila makawala kwailima kwaiyu taitu, kidamwa mapula bivaiya Retieli, mitaga matauna kala lumkola mwada kwaivila wala yam ipupaisewa, paila uula saina wala migibwailila minana. ");
INSERT INTO kij_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","E Yekobe iluki Lebani, kawala, “Ka, bogwa tavinakwaisi taitu. Kaina bukutagwala bakavai sogu latum.” ");
INSERT INTO kij_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Mapaila Lebani ivagi pakala veivai e idou komwaidosi bisuvisi. ");
INSERT INTO kij_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mitaga bogi makwaina kaimapula Retieli ilau Lea isaiki Yekobe, e matauna imisii minana. ");
INSERT INTO kij_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(E Lebani isaiki la ula vivila natana yagala Silipa baisa latula Lea, paila bivigaki kala toyamata.) ");
INSERT INTO kij_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mitaga eiyam, ka, Yekobe ibani bogwa ivaiya Lea. E ilokaia Lebani ikatupoi, kawala, “Avaka uula lokuvigakaigu makawala? Lawotitalaim mwada bavaiya minana Retieli. Avaka uula lokusipulokaigu?” ");
INSERT INTO kij_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lebani ikaibiga, kawala, “Galaga kama gulogulasi kidamwa vilagwadi bivaibogwa oluviga vilitomoya. ");
INSERT INTO kij_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Bukutulotula wiki kwaitala igau biwokuva veivai pakala e oluvi basakaim minana, kidamwa bukuwotitalaigu tuvaila kwailima kwaiyu taitu.” ");
INSERT INTO kij_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yekobe itagwala, e igau tutala wiki makwaina eiwokuva deli ivinakwaisi veivai pakala, Lebani isaiki Retieli e Yekobe ivigaki la kwava. ");
INSERT INTO kij_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(E Lebani isaiki la ula vivila natana yagala Bilia baisa latula Retieli paila bivigaki kala toyamata.) ");
INSERT INTO kij_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","E Yekobe imisii Retieli tuvaila, e kala yebwaili paila Retieli ikalisau kala yebwaili paila Lea. Oluvi ikatumkulovi kala wotetila Lebani iboda kwailima kwaiyu taitu tuvaila. ");
INSERT INTO kij_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tutala Guyau igisi kidamwa Yekobe migibwailila Retieli, mitaga iyebwaili Lea sitana wala, e Guyau ipilasi Lea kidamwa biunai litula. Mitaga Retieli isisu wala nakaliga. ");
INSERT INTO kij_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea isuma e ivilulu tau. Ikaibiga, kawala, “Guyau bogwa leigisi nanogu kala mmayuyu, e tuta baisa ulo mwala biyebwailigu wala.” E mapaila ivabu yagala e idoki magudina Rubeni. ");
INSERT INTO kij_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","E isumavau e ivilulu tau tuvaila. Minana ikaibiga, kawala, “Guyau eisakaigu matauna latugu taiyuwela, paila wala eilagi ulo mwala gala iyebwailigu.” E mapaila ivabu yagala e idoki magudina Simioni. ");
INSERT INTO kij_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","E isuma tuvaila e ivilulu tau. E ikaibiga, kawala, “Ulo mwala gagabila basipukikiti, paila bogwa launai litula tauwau taitolu goli.” E mapaila ivabu yagala e idoki magudina Libai. ");
INSERT INTO kij_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","E isumavau ivilulu latula tau. E ikaibiga, kawala, “Ka, tuta baisa bayakawoli Guyau.” E mapaila ivabu yagala idoki magudina Yuda. Oluvi minana itaboda lopola gala tuvaila iunai litula. ");
INSERT INTO kij_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mitaga Retieli gala biunai gugwadi baisa Yekobe, e mapaila ikaibigiuliweli tuwala, e iluki Yekobe, kawala, “Ibodi bukusakaigu litugwa. Kidamwaga gala, e bogwa bakaliga wala.” ");
INSERT INTO kij_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","E Yekobe isegibuluwi minana Retieli e ikaibiga, kawala, “Gala goli gagabila yeigu kaimapula Yaubada bapilasaim. Paila matauna wala ikatubodi m valulu.” ");
INSERT INTO kij_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","E Retieli ikaibiga, kawala, “Ka, kulau minana ulo ula Bilia. Gagabila minana kaimapugu biuni gugwadi. E baisa makawala yeigu babani latugu metoya baisa minana.” ");
INSERT INTO kij_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","E isaiki minana Bilia baisa la mwala, e imisii minana. ");
INSERT INTO kij_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","E Bilia isuma iuni Yekobe latula tau. ");
INSERT INTO kij_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","E Retieli ikaibiga, kawala, “Yaubada matauna Toyakala e ikabwailigu wala. Bogwa eilagi ulo nigada e isakaigu latugu tau.” E mapaila ivabu yagala, idoki magudina Dani. ");
INSERT INTO kij_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","E Bilia isumavau iunai taiyuwela latula tau baisa Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Retieli ikaibiga, kawala, “Bogwa lakakominimani sogu tuwagu, mitaga yeigu bogwa latomgwaga.” E mapaila ivabu yagala idoki magudina Napitalai. ");
INSERT INTO kij_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tutala Lea ikateta bogwa eisiligulagu valulu, e minana iyovaiya la ula Silipa baisa Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","E Silipa iuni Yekobe latula tau. ");
INSERT INTO kij_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","E Lea ikaibiga, kawala, “Ka, bogwa layubwaila goli.” E mapaila ivabu yagala idoki magudina Gada. ");
INSERT INTO kij_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Silipa iuni tuvaila Yekobe latula tau. ");
INSERT INTO kij_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","E Lea ikaibiga, kawala, “Saina amwasawa. Ka, baisa tuta vivila bidokaigusi namwamwasila goli.” E mapaila ivabu yagala idoki magudina Asera. ");
INSERT INTO kij_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kala kweluva tayoyuwala witi, e Rubeni ililoula osaivau e ibani sita la koiwaga. E ikau makaisina imiaki inala Lea. E Retieli iluki Lea, kawala, “Anigadaim bukusakaigu sita latum la koiwaga.” ");
INSERT INTO kij_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea ivitakauloki, kawala, “Ka, bogwa lokuyouli ulo mwala. Ki, magim bukuyosikikiti wala? Paila magim bukukwau latugu la koiwaga. Wo!” Mitaga Retieli ikaibiga, kawala, “Kidamwa bukusakaigu la koiwaga latum, bogwa bukumasisisi deli Yekobe bogi makwaina.” ");
INSERT INTO kij_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","E bogi makwaina tutala Yekobe ivenoku la paisewa wa bagula e ima ovalu, Lea isunapula ibodi matauna ikaibiga, kawala, “Ka, bogi makwaina bitamasisi deli, paila bogwa labuwaim metoya makaisina latugu la koiwaga.” E mapaila wa bogi makwaina Yekobe imisii minana. ");
INSERT INTO kij_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Yaubada imapu Lea la nigada, e isuma, ivilulu latula tailimala baisa Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea ikaibiga, kawala, “Yaubada eisakaigu agu mapu, paila uula latugwali minana ulo ula baisa ulo mwala.” Mapaila ivabu yagala idoki magudina Isaka. ");
INSERT INTO kij_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea isumavau e ivilulu latula tau tailima taitalela baisa Yekobe, ");
INSERT INTO kij_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","e ikaibiga, kawala, “Yaubada eisakaigu bobwailila saina bwainigaga. E baisa tuta ulo mwala bikabwailigu, paila launai litula tailima taitala goli.” E mapaila ivabu yagala idoki magudina Sebuloni. ");
INSERT INTO kij_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","E igau oluvi ivaluluvau, latula vivila. E ivabu yagala minana e idoki Dina. ");
INSERT INTO kij_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","E tuta baisa Yaubada iluluwai Retieli. Imapu la nigada minana e iulaim la valulu. ");
INSERT INTO kij_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","E minana isuma e ivilulu tau. Ikaibiga, kawala, “Yaubada bogwa eikau agu mmosila e isakaigu latugu. ");
INSERT INTO kij_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","E ulo nigada tuta baisa kidamwa Guyau bisakaigu latugu taiyuwela.” E mapaila ivabu yagala, idoki magudina Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Avai tuta Yosepa bogwa eikaloubusi, Yekobe iluki Lebani kawala, “Kutugwalaigu bala e igagabila bakaimilavau ogu valu. ");
INSERT INTO kij_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kusakaigu ulo kukova deli litugwa matausina latakuni metoya ogu wotetila baisa yoku, e basilavaim. Deli kunikoli ulo wotetila bogwa lavigibau baisa yoku.” ");
INSERT INTO kij_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","E Lebani iluki matauna kawala, “Mwa, kulagi avaka balivala. Bogwa lavitoki tolosila avaka makateki bikaloubusi. Ka, paila wala yoku mapaila goli Guyau eikabwailigu. ");
INSERT INTO kij_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mapaila kusaili mapum, e yeigu bamapwaim.” ");
INSERT INTO kij_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yekobe ivitakauloki kawala, “Bogwa kunikoli ammakawala ulo paisewa paila yoku deli ammakawala eiyuwoveka m yawa metoya ogu wotetila. ");
INSERT INTO kij_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Omitibogwa m yawa yuwokekita wala, mitaga avai tuta lama, lokukeula m vayoguta. Metoya ogu wotetila paila yoku, Guyau bogwa eikabwailim. Mapaila baisa tuta ibodi baneviki sitana agu bwaina titoulegu.” ");
INSERT INTO kij_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","E Lebani ikatupoi matauna kawala, “Avaka bamapwaim?” Yekobe ivitakauloki matauna kawala, “Gala magigu avai mapu bukusakaigu. Mitaga magigu baiyamata wala m yawa, kidamwa bukukwabwaili nanamsa makwaina. ");
INSERT INTO kij_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kutagwala balokaia m yawa komwaidona lagaila e bayausi komwaidona lam nabubwabwau, deli komwaidona gota natunutunu kaina lidabwau. E baisa wala magigu agu mapu. ");
INSERT INTO kij_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Igau tuta oluvi avai tuta bukuma paila bukuvitoki tolosila agu mapu saina gagabila wala bukubani kaina tokamokwita yeigu kaina gala. Kidamwaga bayosi natana gota gala lidabwau, kaina gala natunutunu, kaina natana sipi gala nabwabwau, e yoku bogwa bukunikoli minasina laveilau.” ");
INSERT INTO kij_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","E Lebani ivitakauloki matauna kawala, “Bogwa latagwala. E bitavagi makawala nanom.” ");
INSERT INTO kij_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mitaga yam makwaina wala Lebani ikatukili gota nammwala minasina liyada, tunutunu, deli goli komwaidona nauvila minasina lidabwau, tunutunu, deli minasina sousou, deli ikatukili komwaidona sipi nabubwabwau. E ikaraiwogi litula biyamataisi minasina, ");
INSERT INTO kij_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","e oluvi Lebani deli mayuwona yawa isilavaisi Yekobe, e ililoulasi ilosʹo iboda kwaitolu yam. E Yekobe isim iiyamata mayuwona kesala Lebani la yawa. ");
INSERT INTO kij_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","E Yekobe itaiya sisigigeyata, sisisi yanowawa, saida, deli kaitawoula, e itanini sitana tupwasi mapaila sisi masisisina ipupwakau ambaisa ambaisa eitanini. ");
INSERT INTO kij_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","E ambaisa wala okasi kaiwaga matauna isaili masisisina sisi. Paila avai tuta la yawa bimaisi bimomsi bogwa bikatukoli migisi makawala masisisina sisi. ");
INSERT INTO kij_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Mapaila avai tuta gota bikatumwakulasi omitasi masisisina sisi, bivilulaisi litusia komwaidosi naliliyada, kaina lidabwau, kaina natunutunu. ");
INSERT INTO kij_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","E Yekobe ikatupali sipi ituwoli e gota ituwoli, deli ivigaki bigisamapusi deli Lebani la mauna minasina naliliyada deli nabubwabwau. Matauna eivagi makawala kidamwa bivayoguta la yawa titoulela, e ikatupali minasina metoya Lebani la yawa. ");
INSERT INTO kij_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Avai tuta dilimoya bikatumwakulasi, Yekobe isaili sisila kai okasi kaiwaga e igagabila bikatukoli migisi makawala masisisina sisi. ");
INSERT INTO kij_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mitaga gala isaili masisisina omitasi minasina nagugolia. E igau Lebani iyosi komwaidona minasina nagugolia, e Yekobe iyosi dilimoya. ");
INSERT INTO kij_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Metoya keda makadana, Yekobe ivigaki saina bidugaga la guguwa. Matauna iyosi bidubadu la sipi, la ula, la kameli, deli la ase. ");
INSERT INTO kij_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yekobe inakaigali Lebani litula ililivalasi kawasi, “Tauwau, Yekobe bogwa eikoiyai komwaidona la guguwa tamadasi. Komwaidona la guguwa avaka leiyosi metoya wala baisa tamadasi.” ");
INSERT INTO kij_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Tuvaila bogwa eivitusi Lebani la yebwaili gala makawala omituvaula. ");
INSERT INTO kij_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Oluvi Guyau iluki Yekobe kawala, “Bukukwaimilavau oviloutabum deli baisa veyamwa. E yeigu deli yoku.” ");
INSERT INTO kij_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Mapaila Yekobe iwitali biga baisa Retieli sola Lea, bilokaiasi matauna osaivau ambaisa la sipi eitotusi. ");
INSERT INTO kij_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","E matauna iluki minasina kawala, “Veve, yeigu bogwa lavitoki tolosila tumami la yebwaili baisa yeigu gala makawala omituvaula; mitaga tumagwa si Yaubada deli wala yeigu. ");
INSERT INTO kij_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yokomi kamitaiyu bogwa kunikolaisi auwotitali tumami deli ulo peula komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mitaga matauna iuwabwaigu wala e agu mapu isivaluwotala katumapu. Mitaga Yaubada gala wala itagwala matauna biyogagaigu. ");
INSERT INTO kij_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Avai tuta Lebani bilivala kawala, ‘Ka, minasina gota lidabwau baisa kam mapu,’ e yawa mayuwona eiunigeyaisi, yuwomwaidona wala lidabwau. Avai tutaga matauna bilivala kawala, ‘Ka gota minasina liyada baisa kam mapu,’ e yawa mayuwona eiunigeyaisi yuwomwaidona wala liyada. ");
INSERT INTO kij_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Yaubada bogwa eikau yawa mayuwosina metoya baisa tumami, e leisakaiguga. ");
INSERT INTO kij_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Tutala minasina si tuta katumwakula, e yeigu amimi, lagisi mwada minasina gota nammwala eikikatumwakulasi, liyada, tunutunu, deli lidabwau. ");
INSERT INTO kij_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","E wa mimi Yaubada la anelosi idouwaigu kawala, ‘Yekobe!’ E yeigu avitakauloki kawagu, ‘Mayeigu ka.’ ");
INSERT INTO kij_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","E isaitaula wala ibigatona kawala, ‘Ka, kugisi komwaidona minasina gota nammwala eikikatumwakulasi, liyada wala, tunutunu, deli lidabwau. E vavagi baisa layomitali paila uula bogwa lagisi avaka avaka Lebani eiuvigakaim. ");
INSERT INTO kij_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yeigu wala Yaubada e mayeigu wala layoumatila baisa yoku mapilana Beteli, baisa goli lokubulami dakuna makwaina metoya bulamila olibe e lokukwabomi makwaina makawala kwaitala kaboluluwai deli makatupona wala lokukwatotila mwau baisa yeigu. E tuta baisa kukwatubaiasa bukukwaimilavau ovalu makwaina ambaisa eikapusaiya kulum.’” ");
INSERT INTO kij_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Retieli sola Lea ivitakaulokaisi Yekobe kawasi, “Gala kwaitala vavagi ikesa paila kama bigukeya metoya baisa tamama. ");
INSERT INTO kij_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Matauna ivigakaima makawala tomitawasi yakama. Ivigakaima kaikulela la veiguwa, e tuta baisa mani magulona veiguwama komwaidona wala bogwa eiyomadi. ");
INSERT INTO kij_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Komwaidona guguwa makwaisina Yaubada eikau metoya baisa tamama, makwaisina ma guguwasi deli litumaia. Mapaila kuvagi avaka Yaubada leilukwaim.” ");
INSERT INTO kij_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Mapaila Yekobe ikatubaiasa paila bikaimilavau baisa tamala mapilana Kenani. Matauna ivisiyaila litula deli la kukova okameli, e ivigaki la yawa komwaidona ivakumgwasi, deli goli komwaidona avaka leitakuni mapilana Mesopotemia. ");
INSERT INTO kij_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","E Lebani bogwa leilobogwa paila bivaliu la sipi unuunusi, e tuta makwaina eitamwau, Retieli iveilau tamala la yaubada minasina tokolu katububulela la bwala. ");
INSERT INTO kij_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yekobe ikiwoli Lebani gala iluki binikoli paila bogwa bisilavi matauna. ");
INSERT INTO kij_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Mapaila ikoluluvi komwaidona la guguwa titoulela, e isilavi gala kwemanum. Matauna ivabusi ivapela Waya Yupereiti e isaitaula wala bilaguva mapilana Giliadi. ");
INSERT INTO kij_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Kwaitolu yam bogwa leiwokuva, oluvi Lebani ilega biga paila Yekobe bogwa leisakaula. ");
INSERT INTO kij_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mapaila iyosi la tomota e deli matauna iyeikulaisi Yekobe. E bogwa eiboda kwailima kwaiyu yam isakailasi matauna wa koya mapilana Giliadi. ");
INSERT INTO kij_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","E wa bogi makwaina Yaubada iyoumatila baisa Lebani wa mimi, e iluki matauna kawala, “Kuyamataim taga bukuninamsi avai nanamsa mwada bukukwakukoli Yekobe.” ");
INSERT INTO kij_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","E Yekobe bogwa ibudi la kabosikaiwa wa koya e tuvaila Lebani deli la tomota ibudaisi si kabosikaiwa wa koya mapilana Giliadi. ");
INSERT INTO kij_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","E Lebani iluki Yekobe kawala, “Avaka paila lokukiwolaigu e lokusakawoli litugwa lokumai makawala minasina vivila eikatupipaisi metoya okabilia? ");
INSERT INTO kij_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Deli avaka uula lokukiwolaigu gala kulukwaigu e lokuvakiwada wala lokuma ke? Ka, kidamwa bukulukwaigu, bogwa bawitalaim bukuma deli m mwasawa, e bukuusiwosi deli butusi sasani deli gita. ");
INSERT INTO kij_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Deli gala sitana kutagwala baviyuwoli e batali tubugwa deli litugwa. Mwa, baisa nagowa wala lokuuvagi! ");
INSERT INTO kij_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yeigu ibodaigu wala bayogagaim, mitaga ila wala matauna tamam la Yaubada wa bogi ilukwaigu gala baninamsi avai keda mwada bayokukolaim. ");
INSERT INTO kij_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Bogwa lanikoli lokusilavaigu paila uula bogwa wala eisetoyaim bukukwaimilavau om valu, mitaga avaka paila lokuveilau minasina ulo yaubada katububulela ulo bwala?” ");
INSERT INTO kij_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","E Yekobe ivitakauloki matauna kawala, “Mwa, akukolaim wala, paila adokila mwada bukubisabu litumwa bisiwaisi. ");
INSERT INTO kij_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mitaga kidamwa bukubani taitala yakamaisi eikau m yaubada matauna bitakatumataisi wala. Ka, omitasi wala da tomota bukunevi avai guguwa m guguwa e kukwau minasina m vavagi.” E Yekobe gala wala inikoli Retieli bogwa eiveilau Lebani la yaubada. ");
INSERT INTO kij_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","E Lebani isuvi isuvali Yekobe la buliyoyova iwokuva, e oluvi Lea ola buliyoyova, deli osi buliyoyova minasina nayu ula, mitaga gala wala ibani minasina la yaubada. E oluvi isuvi Retieli ola buliyoyova. ");
INSERT INTO kij_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mitaga Retieli bogwa eikau minasina tamala la yaubada katububulela la bwala e isewoya olumoulela kabala paila bisisu otapwala la kameli e isipela isikaila minasina. Lebani isuvali buliyoyova makwaina kwemwaidona mitaga gala wala ibani minasina. ");
INSERT INTO kij_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Retieli iluki tamala kawala, “Tomwaya, gala bukugibuluwaigu, yeigu gala ibodaigu batotu omatam, paila vivila kama katoulasi eiyosaigu.” Lebani isisavali wala mitaga gala wala ibani la yaubada minasina katububulela la bwala. ");
INSERT INTO kij_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","E Yekobe igibuluwa. Ikatupoi deli la gibuluwa kawala “Mwa, avai sula lavagi? Avai karaiwaga lakodidaimi e eibisiki lopom bwaina wala bukuyokukolaigu? ");
INSERT INTO kij_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ka, bogwa lokusuvali ulo guguwa komwaidona leiwokuva, e avai vavagi katububulela m bwala lokubani ke? Kumai kukwatugai omitasi m tomota deli ulo tomota e bigisaisi e ibodi binagaisi availa eikamokwita yoku kaina yeigu. ");
INSERT INTO kij_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Yeigu asisu deli yoku iboda kwailuwoyu taitu, e m sipi deli m gota isousewasi wala, mitaga gala wala akamkoni natana m sipi nammwala metoya om yawa. ");
INSERT INTO kij_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Avai tuta mauna nabubolodila bikamataisi natana sipi gala bamiakaimi paila bukugisi mwada yeigu gala agu pakula. Mitaga tuta komwaidona yeigu wala bampumapu. Yoku kukwaraiwogaigu mwada bakiduwosisii vavagi makwaisina biveilauwaisi wa yam kaina wa bogi. ");
INSERT INTO kij_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Bidubadu tuta alumkoli agu mmayuyu, deli agu kwalasia wa yam e agu numla wa bogi. Gala ammasisi bwaina. ");
INSERT INTO kij_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Baisa makawala lokuvigakaigu olumoulela makwaisina kweluwoyu taitu tasisu kadataiyu. Kweluwotala kwaivasi taitu yeigu awotitalaim paila litumwa minasina lavaiya nayu - e kwailima kwaitala taitu paila m yawa. E wa taitu makwaisina olumoulela kusivaluwotala katumapu agu mapu. ");
INSERT INTO kij_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kidamwa tumagwa si Yaubada, matauna Eberaam deli Aisake si Yaubada gala deli yeigu, yoku bogwa bukuyabaigu bala yumawokuva wala yamagu. Mitaga Yaubada bogwa eigisi agu mwau deli ulo wotetila avaka bogwa lavagi e wa bogi matauna ivagi avaka la karaiwaga.” ");
INSERT INTO kij_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lebani ivitakauloki Yekobe kawala, “Ka, minasina vivila litugwa goli; e litusia ulo vavagi wala, e tuvaila mayuwona yawa baisa ulo mauna wala. E mokwita goli avaka avaka lokugisi baisa komwaidona wala ulo vavagi. Mitaga kuluwai wala gala ammakawala bavigaki paila bayosi litugwa deli goli litusia, ");
INSERT INTO kij_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","mapaila yeigu bogwa latagwala kidamwa bitaninatala. Ibodi bitakouguguli gulotala dakuna kidamwa bikatululuwaiyaida paila da ninatala, kadai.” ");
INSERT INTO kij_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Mapaila Yekobe ikau kwaitala dakuna e ivitomiliwoli makwaina bivigaki si kaboluluwai. ");
INSERT INTO kij_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","E iluki la tomota bikauwaisi mimilisi dakuna e bikougugulaisi. E oluvi ikamsi okaipapala magulona dakuna. ");
INSERT INTO kij_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lebani idoki yagala Yega Saaduta, e Yekobe idoki yagala Galeedi. ");
INSERT INTO kij_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","E Lebani iluki Yekobe kawala, “Ka, magulona dakuna bivigaki da kaboluluwai.” Baisa uula idokaisi valu makatupona yagala Galeedi. ");
INSERT INTO kij_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","E Lebani tuvaila ikaibiga kawala, “Ibodi Guyau bigigisaida tuta makwaina bitasikaduwonaku.” Mapaila valu makatapona tuvaila idokaisi yagala Misipa. ");
INSERT INTO kij_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Lebani isaitaula wala bigatona kawala, “Ilagoli kidamwa bukuvakatutuki litugwa kaina bukuvaiya ituwoli vivila, e yeigu gala banikoli makawala bikaloubusi, mitaga kululuwai Yaubada eigigisaida wala. ");
INSERT INTO kij_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ka, magulona dakuna bogwa lakatuguguli oluwalaida, deli makwaina dakuna paila da kaboluluwai. ");
INSERT INTO kij_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dakuna magulona deli dakuna makwaina kwaiyu wala da kaboluluwai. Yeigu gala avai tuta bavapaili dakuna magulona mwada bakabilia baisa yoku, e yoku gala avai tuta bukuvapaili dakuna magulona kaina dakuna makwaina mwada bukukwabilia baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","La Yaubada Eberaam deli la Yaubada Nayo matauna bikaraiwogaida.” Oluvi Yekobe ikatotila mwau oyagala Yaubada matauna Aisake itemmali. ");
INSERT INTO kij_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Matauna ikatumati natana mauna, minana eivigaki lula odabala koya e idou la tomota ilosi okamkwam makwaina. Avai tuta bogwa leivenokusi kamkwam, e ikanawaisi wala wa koya. ");
INSERT INTO kij_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Eiyam kaukwau pikekita Lebani iviyuwoli tubula deli litula, e itali matausina, e ikaimilavau ola valu. ");
INSERT INTO kij_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yekobe ililoula wala e mimilisi anelosi ibodaisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","E tuta matutona igisi matausina, ikaibiga, kawala, “Mapilana Yaubada la kabosisu.” Mapaila idoki mapilana Maanaim. ");
INSERT INTO kij_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yekobe iwitali mimilisi touwata bilobogwasi bibodaisi tuwala Iso mapilana Edom. ");
INSERT INTO kij_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Iluki matausina mwada bikaibigasi, “Yekobe kawala, ‘Ka, yeigu Yekobe m touwata tokabikaula, akamituli baisa yoku Iso agu tokugwa. Masisiki baisa Lebani, e omitibogwa gala awokaiam, mitaga baisa tuta wala bogwa lanagi bakaimilavau. ");
INSERT INTO kij_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Bogwa isim ulo bulumakau, ulo ase, ulo sipi, ulo gota, e mimilisi tomota ulo ula. E tomwaya, ka. Baisa tuta awitali biga baisa yoku, paila nanogu mwada bukuninabwaila paila yeigu.’” ");
INSERT INTO kij_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tutala touwata ikaimilavausi baisa Yekobe, ikaibigasi, kawasi, “Kalokaiasi kabodaisi tuwam Iso, e bogwa ililoula bima bibodaim. E deli, matauna la tomota tauwau kasi bawa lakatuvasi deli eimaisi.” ");
INSERT INTO kij_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","E Yekobe kala kokola inokubukubu. Mapaila la tomota ikovi ivigaki budoyu, e makawala minasina sipi, gota, bulumakau, deli kameli. ");
INSERT INTO kij_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Idoki wala, “Kidamwaga bima biwaiya budotala e kaina buduyuwela gagabila bisakaulasi.” ");
INSERT INTO kij_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","E Yekobe inigada baisa Yaubada. Ikaibiga, kawala, “Mwa! Yaubada, yoku tabugu Eberaam la Yaubada, deli goli tamagu Aisake la Yaubada, ka, kulagaigu wala. Mwa! Guyau, bogwa kulukwaigu kidamwa ibodi bakaimilavau bala viloutabugu e lokulivala kidamwa bukumitukwaiyaigu vavagi komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ka, yeigu gala wala dimlegu. Gala ibodi bukunokapisaigu deli bukuvakadaigu makawala lokuvagi omitibogwa e lagaila. Ka, omitibogwa tutala aluvapela wa Waya Yoridani, gala isim bubwaiagu mesinaku kaitala kaitukwa oyamagu wala. E baisa tuta akaimilavau deli mabudosina budoyu. ");
INSERT INTO kij_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Anigadaim bukukolaigu metoya baisa matauna tuwagu Iso. Saina agu kokola. Paila akukoli kaina matauna bima bimtulaimasi deli goli vivila e gugwadi. ");
INSERT INTO kij_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ka, bukululuwai ammakawala lokukwatotila kidamwa bukumitukwaiyaigu vavagi komwaidona kidamwa baboda vavagi bwaina wala. E deli lokukwatotila kidamwa tubugwa bidalasi, e gala gagabila availa bikalau paila kasi bawa makawala kanakenuva olumata.” ");
INSERT INTO kij_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Wa bogi makwaina imasisisi baisa. E eiyam inagi mimilisi mauna metoya mayuwona paila kala bobwailila tuwala Iso. E baisa makawala - lakatuyu gota nauvila deli buluwoyu gota nammwala; lakatuyu sipi nauvila deli buluwoyu sipi nammwala; buluwotolu kameli minasina nauvanunu deli litusia; buluwovasi bulumakau nauvila deli buluwotala bulumakau nammwala; e buluwoyu ase nauvila deli buluwotala ase nammwala. ");
INSERT INTO kij_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ikovi minasina ivigaki yuwovila yawa e isaili yuwotala taitala toyamata. E iluki matausina, kawala, “Bukulobogwasi omatagu, e yuwotala yuwotala bililoulasi, deli sitana sasa bisisu oluwalaisi yuwotala yawa e mayuwona iyeikuli.” ");
INSERT INTO kij_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","E iluki matauna ilobogwa, kawala, “Avai tuta tuwagu Iso bibodaim e bikatupoi, kawala, ‘Availa m guyau? Am bukula? Minasina mauna omatam, ki availaga tolimauna?’ ");
INSERT INTO kij_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","e ibodi bukuvitakauloki matauna kawam, ‘Toli mauna matauna m touwata Yekobe. E bogwa eiwitali kam bobwailila, yokugwa kala tokugwa Iso. E Yekobe titoulela iyeikulaimasi otuboulomasi eililoula.’” ");
INSERT INTO kij_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E Yekobe ilivala makawala wala baisa taiyuwela e taitolula, e deli goli komwaidosi matausina iyamataisi mayuwosina. Ikaibiga, kawala, “Baisa makawala bukulivala avai tuta bukubodi Iso. ");
INSERT INTO kij_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kawam, ‘E mokwita, m touwata Yekobe iyeikulaimasi otuboulomasi eililoula.’” Yekobe ininamsi, “Ka, bogwa bayomwasali nanola makwaisina bobwailila. E avai tuta yeigu babodi matauna kainaga biligaiwa makwaina ulo sula.” ");
INSERT INTO kij_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","E makwaisina bobwailila iwitali bilobogwasi omatala matauna, e bogi makwaina imasisi wala baisa. ");
INSERT INTO kij_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","E bogi makwaina Yekobe itokaia ilau la kukova nayu, deli minasina la ula nayu eivigaki la kukova, e deli litula tailuwotala taitala, e iluvapelasi wa Waya Yaboka. ");
INSERT INTO kij_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Yekobe iwitali matausina iluvapelasi e deli iwitali komwaidona la guguwa avaka avaka eisisia, ");
INSERT INTO kij_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","mitaga matauna kalamwaleta wala gala iluvapela, isisu wala. E oluvi taitala tau leima ipupogudusi wala ikikivisiga. ");
INSERT INTO kij_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","E tutala tau matauna igisi gala wala bitomgwaga e iwaiya ikatusikili la kaidawaga Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","E matauna tau ikaibiga, kawala, “Mwa! Kukilavaigu, paila bogwa biyam tatoula.” Mitaga Yekobe ikaibiga, kawala, “Galaga bakilavaim. Ibodi bukubigibwailigu.” ");
INSERT INTO kij_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","E matauna ikatupoi, kawala, “Ami yagam?” E ivitakaula, kawala, “Yeigu Yekobe.” ");
INSERT INTO kij_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","E matauna ikaibiga, “Gala tuvaila bidokaimsi Yekobe. Paila bogwa lokuyominimani som Yaubada deli goli tomota e bogwala lokutomgwaga. Mapaila bidokaimsi Isireli.” ");
INSERT INTO kij_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","E Yekobe ikaibiga, kawala, “Ka ibodi bukulukwaigu ami yagam.” Mitaga matauna tau ikaibiga, kawala, “Avaka uula magim bukunikoli yagagu?” E ibigibwaili Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yekobe ikaibiga kawala, “Ka bogwa lakagisamapu sogu Yaubada e ka! Asisu wala tomomova yeigu.” E mapaila idoki mapilana valu yagala Penieli. ");
INSERT INTO kij_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","E tutala Yekobe isisilavi Penieli, e kalasia eipela. E Yekobe ikagei paila uula matauna eikatusikili la kaidawaga. ");
INSERT INTO kij_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Baisa tuta goli mina Isireli gala wala bikamsi sibuvatusi avai mauna avai mauna, paila uula matauna tau ikatusikili la kaidawaga Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yekobe igisi Iso ililoula imakaia deli la tomota tauwau lakatuvasi. Mapaila itavilevi litula oluwalaisi la kukova, minasina Lea, Retieli e minasina la ula eivigaki la kukova. ");
INSERT INTO kij_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Isaili budotala, minasina la ula eivigaki la kukova deli litusia e mabudona ilobogwasi. Isakaili mabudona Lea deli litula, e ivabodasinim Retieli deli latula Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yekobe ililoula ila omitasi mabudosina e ilokaia tuwala. Ililoula e sivalima sivayu ikavagina ila opwaipwaia omatala matauna. ");
INSERT INTO kij_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mitaga Iso isakaula ibodi matauna, e ikaipapi iviyuwoli wala. Kasitaiyu matausina iuvalamsi. ");
INSERT INTO kij_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","E Iso imitibilibili igisi minasina vivila deli litusia e ikatupoi, kawala, “Mwa! Availaga mabudona tomota deli yoku kuliloulasi?” E Yekobe ivitakaula, kawala, “Ka, tomwaya, Yaubada eimitukwaiyaigu e isakaigu litugwa magudisina, ka.” ");
INSERT INTO kij_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","E minasina la ula availa eivigaki la kukova ikugwa imaisi deli litusia e ikavaginasi. ");
INSERT INTO kij_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Oluvi Lea deli litula, e kala vigimkovila Yosepa sola Retieli imaisi ikavaginasi. ");
INSERT INTO kij_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","E Iso ikatupoi, kawala, “Ammakawalaga mabudona ituwoli bogwa labodi? Avaka uula mabudona?” Yekobe ivitakaula, kawala, “Uula wala magigu bayomwasali nanom.” ");
INSERT INTO kij_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mitaga Iso ilivala, kawala, “Wa, bodagu, desi. Ulo vavagi bogwa ibodaigu wala. Bukuyosi m vavagi.” ");
INSERT INTO kij_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yekobe ikaibiga, kawala, “Gala wala tuwagu. Ka, kidamwa bogwa layomwasali nanom, kukwau ulo bobwailila. Paila bogwa lagisi migim, e agu lumkola makawala bogwa lagisi migila Yaubada, paila baisa tuta takalubailasi goli. ");
INSERT INTO kij_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Anigadaim bukukwau ulo bobwailila avaka lawitali. Paila Yaubada bogwa eimitukwaiyaigu e isakaigu komwaidona avaka magigu.” E Yekobe imnabi imnabi e mapaila Iso itagwala e ikau kala bobwailila. ");
INSERT INTO kij_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Iso ikaibiga kawala, “Bitakatubaiasasi bitalosi. E yeigu bavamatala.” ");
INSERT INTO kij_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mitaga Yekobe ivitakauloki kawala, “Bwaina, mitaga bogwa kunikoli gugwadi gala bikaka kaikesi paila biloulasi, deli ibodi baninamsi minasina sipi, bulumakau deli litusia. Kidamwa bitavaninakwaisi minasina, yam kwaitala wala, e mauna yuwomwaidosi bikaligasi. ");
INSERT INTO kij_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mwa, akoma lopom bwaina wala kukugwaiwa kuliloula e desi goli manum baliloula bauvakwabu gugwadi deli mauna tatoula wala bawa asakailam mapilana Edom.” ");
INSERT INTO kij_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","E Iso ikaibiga kawala, “O bwaina, mimilisi ulo tomota bisikaimwaimsi.” Mitaga Yekobe ivitakauloki kawala, “Gala bikaiki wowom, mesinaku wala magigu bavagi makawala nanom.” ");
INSERT INTO kij_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Mapaila yam makwaina wala Iso ikaimilavau ila mapilana Edom. ");
INSERT INTO kij_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mitaga Yekobe isum ila mapilana Sukoti, e mapilana baisa ikaliaii la bwala deli mimilisi buliyoyova paila la mauna. E baisa uula idokaisi makatupona yagala Sukoti. ");
INSERT INTO kij_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ola kaimilavau metoya Mesopotemia Yekobe iviloubusi bwaina wala ovilouveka valu Sekem mapilana Kenani, e ibudi valu osaivau opapala valu vilouveka. ");
INSERT INTO kij_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","E igimoli makatupona kwabila metoya odalela Emori, matauna Sekem tamala e mapula kala bawa iboda lakatutala siliba. ");
INSERT INTO kij_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","E makatupona baisa ikaliaii kwaitala kabogabu lula, e idoki makwaina oyagala Eli, matauna mina Isireli si Yaubada. ");
INSERT INTO kij_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Kwaitala yam Dina, minana Yekobe sola Lea litusi ila bikaiyaku deli mimilisi vilesi Kenani. ");
INSERT INTO kij_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Avai tuta Sekem matauna Emori latula guma Ivi, matauna goli guyoula mapilana valu, igisi minana, iyosi e imokaia minana. ");
INSERT INTO kij_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Mitaga igisi vivila minana saina namanabwaita e ikau nanola paila minana, e ivigikoni mwada bivisimoli minana. ");
INSERT INTO kij_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","E Sekem iluki tamala kawala, “Tamagu, magigu bukulokaia minana vivila bukumiakaigu bavigaki ulo kwava.” ");
INSERT INTO kij_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yekobe bogwa eikateta paila latula bogwa eiyomsilaisi mitaga gala wala avaka ivagi, paila komwaidosi wala litula tauwau bogwa eilosi osaivau iiyamatasi si mauna. E itulotula wala avai tuta eikaimilavausi. ");
INSERT INTO kij_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","E Emori Sekem tamala isunapula ilokaia Yekobe bibigatonasi, ");
INSERT INTO kij_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","e isivilasiga Yekobe litula tauwau eiuviloubusisi metoya osaivau. Avai tuta ilagaisi bulogala vavagi makwaina, itutuvakau ninasi deli si gidumleiya paila Sekem leivagi vavagi makwaina deli leiyomsili tomotala Isireli paila leiyosi imokaia Yekobe latula vivila. ");
INSERT INTO kij_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","E Emori iluki Yekobe kawala, “Mwa, latugu Sekem saina nambwailila latum; sogu akoma lopom, ");
INSERT INTO kij_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","kutagwala bitaninatala kidamwa ulo tomota bivaigogulasi deli m tomota. ");
INSERT INTO kij_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","E yoku ibodaim bukusivagasi baisa oma valusi deli yakamaisi, ibodaim wala bukula ambaisa nanom e bukubudi m valu, gala avaka bisilibodi paila bukugigimwala, deli avaka bukuyosa baisa m vavagi tatoum.” ");
INSERT INTO kij_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","E oluvi Sekem iluki Dina tamala deli luleta kawala, “Ka, tauwau, kidamwa ulo nanamsa makwaina bukuvagaisi, e avaka magimi yeigu basakaimi wala. ");
INSERT INTO kij_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","E kulukwaigusi avai bobwailila magimi, deli kunagaisi kasilavila veiguwa bakabi mapula minana; e yeigu basakaimi wala avai vavagi bukunigadaigusi, mitaga kidamwa wala bukutagwalasi bavaiya minana.” ");
INSERT INTO kij_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Mitaga paila uula Sekem iyomsili lusita Dina, mapaila Yekobe litula ivitakaulokaisi Sekem sola tamala Emori metoya avaka eibigiutaisi. ");
INSERT INTO kij_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Matausina ilukwaisi Sekem kawasi, “Gala katagwalasi lumetasi bivaiya taitala tau gala isim kala bobu wowola, baisa biyomsilaimasi. ");
INSERT INTO kij_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Yakamaisi bakatagwalasi kidamwa wala bukuvigakaimi makawala yakamaisi bukubobwaisi uwomi komwaidomi tauwau. ");
INSERT INTO kij_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","E oluvi bakatagwalasi bitavaigogulasi. E bakasilomlasi oluwalaimi bitavigakaidasi boda kwaitala. ");
INSERT INTO kij_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mitaga kidamwa gala bukuvagaisi makawala ninamaisi paila bukubobwaisi uwomi, e bakayusaisi wala minana bakalauwaisi.” ");
INSERT INTO kij_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","19","E nanamsa makwaisina ibudoki wala ninasi Emori sola latula, mapaila Sekem gala wala itulotula paila bivagi avaka si nanamsa, paila saina nambwailila minana Yekobe latula. Tuvaila osi kaukweda deli tumasi matauna wala kasi todabala. ");
INSERT INTO kij_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Emori sola latula Sekem ilosi obikubaku katitaikinela kalapisilela valu, e ilivalasi baisa si tomota kawasi, ");
INSERT INTO kij_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Tomota matausina tomitakwai; kutagwalasi bisikailidasi oda pwaipwaiasi, deli kidamwa ambaisa ninasi bilosi, biluva wala taigasi. Kwabila saina kubilaveka bogwa bibodaidasi komwaidodasi. Mapaila ibodi bitavaiyasi litusia vivila e bitasakaisi litudoiasi vivila bivaiyasi. ");
INSERT INTO kij_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mitaga matausina tauwau bitagwalasi bitasimwaisi, e bitavigakaidasi boda kwaitala, kidamwa wala bitabobwaisi uwodaisi komwaidodasi tauwau, makawala matausina bogwa leibobusi. ");
INSERT INTO kij_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ki! gala ititagam lupomi paila komwaidona si bulutuvalu deli avaka eiyosisi baisa paila wala yakidasi? Mapaila bwadagwa kutagwalasi bisikaimwaidasi.” ");
INSERT INTO kij_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","E komwaidona tomotala valu makwaina itagwalasi avaka Emori sola Sekem si nanamsa; e komwaidona tauwau ibobusi uwosi. ");
INSERT INTO kij_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kwaitolu yam bogwa leiwokuva, avai tuta tauwau kasi bobu ouwosi igau wala eiuwolaga, e Yekobe litula taiyu yagasi Simioni sola Libai matausina Dina luleta, ikauwaisi si kaiyala gala iyolibigasi isuvisi ovalu ikatumataisi komwaidona tauwau, ");
INSERT INTO kij_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","deli goli Emori sola latula Sekem. E matausina ibiasi Dina metoya Sekem ola bwala e isilavaisi valu. ");
INSERT INTO kij_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Avai tuta bogwa leivenokusi katumata, mimilisi tuvaila Yekobe litula isuvisi ikwaiyaisi valu paila bikeulasi lugwala lusita eiyomsilaisi. ");
INSERT INTO kij_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Matausina ivayoulisi sipi, bulumakau, ase, deli goli komwaidona avaka avaka isisuaisi ovalu deli obuyagu. ");
INSERT INTO kij_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Matausina ikauwaisi komwaidona si veiguwa, e ikatupipaisi komwaidona vivila deli gugwadi, e ivayoulisi komwaidona avaka avaka wa bwala. ");
INSERT INTO kij_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","E Yekobe iluki litula Simioni sola Libai kawala, “Ka, yokomi bogwa kuyomitulaisi agu pakula, tuta baisa mina Kenani, mina Peresi, deli komwaidosi availa availa isisuaisi baisa bogwa bivigakaigusi tokukolosi yeigu. Gala ayosi bidubadu tomota; kidamwa komwaidosi bikatukwaitalasi bimakaiagusi, yeigu deli litugwa bimtumlaimasi wala bakadoumsi.” ");
INSERT INTO kij_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mitaga matausina ivitakaulokaisi tumasi kawasi, “Gala bakatagwalasi lumetasi bivigakaisi makawala minasina nakomlilipwa.” ");
INSERT INTO kij_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Yaubada iluki Yekobe kawala, “Baisa tuta wala bukula Beteli e bukusiwa mapilana. Bukukwaliaii kwaitala kabogabu lula paila yeigu Yaubada, paila mayeigula layoumatila baisa yoku matutona lokusakaula metoya baisa tuwam Iso.” ");
INSERT INTO kij_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Mapaila Yekobe iluki litula deli komwaidona availa availa toyo matauna. Kawala “Kuligaimwaisi minasina gilagala si yaubada lokuiyosisi; deli kusikamsi kami kwama yamigileu. ");
INSERT INTO kij_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Bogwa bitasilavaisi valu makwaina e bitalosiga Beteli, e yeigu bakaliaii kwaitala kabogabu lula baisa Yaubada, matauna goli agu topilasi ogu tuta mwau, e ambaisa ambaisa bala matauna deli wala yeigu.” ");
INSERT INTO kij_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Mapaila matausina eisakaisi Yekobe komwaidona gilagala si yaubada minasina leiyosisi, deli kasi paya makaisina eisisikomasi. E Yekobe ibaku osikowala kaitala yawa katitaikinela Sekem. ");
INSERT INTO kij_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Avai tuta Yekobe deli litula eikoluluvisi bilosi, e kokola igubami wala tomotala valu makwaisina opapala, mapaila gala wala ibokavilaisi matausina. ");
INSERT INTO kij_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yekobe deli komwaidona la tomota iviloubusisi valu Lusi, tuta baisa eidokaisi Beteli, mapilana Kenani. ");
INSERT INTO kij_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Matauna ikaliaii kwaitala kabogabu lula baisa, e idoki yagala oigiyagala Yaubada makatupona Beteli kala Yaubada; paila uula Yaubada iyoumatila baisa matauna avai tuta leisakaula metoya baisa tuwala. ");
INSERT INTO kij_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debora minana Ribeka kala toyamata ikaliga, e ibakwaisi osikowala kaitala yawa, mapilana Beteli opilibolimila. Mapaila idokaisi makatupona yagala “Yawela Valam”. ");
INSERT INTO kij_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Avai tuta Yekobe ikaimilavau metoya Mesopotemia, Yaubada tuvaila iyoumatila baisa matauna e ikabwaili matauna. ");
INSERT INTO kij_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Yaubada iluki matauna kawala, “Mwa, yoku yagam Yekobe, mitaga metoya wa tuta baisa e tuta oluvi yagam Isireli.” Mapaila Yaubada idoki matauna Isireli. ");
INSERT INTO kij_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yaubada iluki matauna kawala, “Yeigu Yaubada Topeuligaga. Yoku bukuunai litumwa bidubadu. Metoya baisa yoku, e boda komwaidona bidalasi, deli goli gweguya tubusi yoku. ");
INSERT INTO kij_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Yeigu basakaim valu mapilana lasakaibogwi Eberaam, oluvi baisa Aisake e igau bukukwaliga, yeigu tuvaila basaiki baisa tubumwa.” ");
INSERT INTO kij_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","E oluvi Yaubada isilavi matauna. ");
INSERT INTO kij_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Makatupona wala ambaisa Yaubada eibigitoni matauna, Yekobe ivitomiliwoli kwaitala dakuna paila kaboluluwai e iligabu waini deli bulami olibe odabala makwaina, e ikabomi makwaina. ");
INSERT INTO kij_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","E idoki makatupona valu yagala Beteli. ");
INSERT INTO kij_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","E Yekobe deli litula isilavaisi Beteli, e igau wala miloutala eisisu bilokaiasi Eparati, Retieli bogwa eigadi, e bwaina wala igidiuvili paila bitapoi yamala. ");
INSERT INTO kij_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Avai tuta bogwa eigidiusiwasi lopola sainela, e minana nakaivalulu iluki Retieli kawala, “Retieli, gala bukunokubukubu; magudina gudiyuwela latum tau.” ");
INSERT INTO kij_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mitaga minana bogwa wala bikaliga, e avai tuta eikutokutiga, minana ivabu latula yagala Benoni, e ikaliga. Mitaga tamala idoki magudina gwadi yagala Beniamina. ");
INSERT INTO kij_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Avai tuta Retieli bogwa eikaliga, ibakwaisi minana opapala keda makadana bilokaia Eparati, tuta baisa eidokaisi Bedeliem. ");
INSERT INTO kij_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","E wa yam makwaina Yekobe ivitomiliwoli kwaitala dakuna paila kaboluluwai e dakuna makwaina eivitau kabovituvitusila Retieli kala laka eitotu wala tuta baisa. ");
INSERT INTO kij_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","E oluvi Yekobe isilavi makatupona, e ila ibudi la kabosikaiwa opapala buluvatoi mapilana Ederi. ");
INSERT INTO kij_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Avai tuta Yekobe isisu wala mapilana valu, e Rubeni iyovilavila imisii Bilia, minana natana tamala la ula eivigaki la kwava. Avai tuta Yekobe ilagi biga, matauna saina igaga nanola. Yekobe litula kasi bawa tailuwotala taiyu. ");
INSERT INTO kij_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","E matausina Lea litula, Rubeni (matauna Yekobe latula molitomoya), Simioni, Libai, Yuda, Isaka, deli Sebuloni. ");
INSERT INTO kij_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","E Retieli litula Yosepa sola Beniamina. ");
INSERT INTO kij_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilia minana Retieli la nawotetila litula Dani sola Napitalai. ");
INSERT INTO kij_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silipa minana Lea la nawotetila litula, Gada sola Asera. Matausina inisia eiunaisi mapilana Mesopotemia. ");
INSERT INTO kij_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yekobe bogwa ilokaia tamala Aisake mapilana Mamira, katitaikina Ebironi, ambaisa Eberaam sola Aisake eisisikaisi. ");
INSERT INTO kij_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Aisake bogwa saina eitomoya kala taitu iboda lakatutala kweluwolima kweluwotolu, e ikaliga. Litula Iso sola Yekobe ibakwaisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Baisa makawala Iso matauna igiyuwela Edom tubula liliusi. ");
INSERT INTO kij_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso ivaiya Ada minana vilela Kenani, tamala yagala Eloni guma Itai. Nayuwela la kwava yagala Owolibama minana tamala yagala Anai, matauna Sibioni latula guma Ivi, ");
INSERT INTO kij_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","e natolula yagala Basimata, minana Nebaioti luleta, e tumasi Isimeili. ");
INSERT INTO kij_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada latula Elipasa; Basimata latula Reueli; ");
INSERT INTO kij_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","e Owolibama litula, Yeusa, Yalam, deli Kora, matausina komwaidosi wala Iso litula leiuni mapilana Kenani. ");
INSERT INTO kij_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Oluvi Iso ikoluluvi la kukova, litula tauwau deli vivila, e komwaidona la tomota ola bwala, la mauna komwaidona, deli la guguwa komwaidona makwaisina leitakuni mapilana Kenani, e Iso isilavi bodala Yekobe, e ila valu ituwoli. ");
INSERT INTO kij_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Matauna la koluluvi uula valu makwaina leisisikaisi sola Yekobe gala ibudoki si kaisisu. Paila kasitaiyu wala saina bidugaga si mauna e gala ibodi bisisuaisi valu kwaitala. ");
INSERT INTO kij_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Mapaila Iso ila ibudi valu mapilana Edom wa koya. ");
INSERT INTO kij_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Baisa makawala Iso tubula, dalesi mina Edom. ");
INSERT INTO kij_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Iso la kwava Ada iuni taitala wala latula yagala Elipasa. E oluvi Elipasa iunai tailima litula. Temani, Oma, Sepo, Gatam, deli Kenasi. E nayuwela la kwava, minana Timna eiuni taitala tuvaila latula tau, yagala Ameleki. Iso la kwava Basimata latula taitala wala tau, yagala Reueli, e oluvi Reueli iuni litula kasi bawa taivasi, yagasi. Naata, Sira, Samma, deli Misa. ");
INSERT INTO kij_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","E Iso nayuwela la kwava yagala Owolibama, minana Anai latula, e Anai matauna Sibioni latula. Minana iuni litula taitolu tauwau. Matausina yagasi Yeusa, Yalam, Kora. ");
INSERT INTO kij_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dala makwaisina leidalasi metoya baisa Iso. Iso la kuluta yagala Elipasa matauna dalela, Temani, Oma, Sepo, Kenasi, ");
INSERT INTO kij_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam deli Ameleki. Komwaidosi wala matausina tubusi Ada, minana Iso la kwava. ");
INSERT INTO kij_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso latula Reueli matauna tubula madalasina, Naata, Sira, Samma deli Misa. Komwaidosi wala matausina tubusi Basimata Iso la kwava nayuwela. ");
INSERT INTO kij_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso dalela leidalasi metoya baisa la kwava natolula, yagala Owolibama, minana Anai latula, matausina yagasi Yeusa, Yalam, deli Kora. ");
INSERT INTO kij_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Komwaidosi wala matausina Iso dalela. ");
INSERT INTO kij_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Baisa makawala Seiri matauna guma Ora, tubula yagasi matausina tosibogwa mapilana Edom, Lotani, Sobali, Sibioni, Anai, Disoni, Esa, deli Disani. ");
INSERT INTO kij_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotani dalela Ori sola Emani. (Lotani luleta yagala Timna.) ");
INSERT INTO kij_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali dalela madilasina Alivani, Manaata, Ebali, Sepo deli Onam. ");
INSERT INTO kij_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibioni litula taiyu, Aiya sola Anai. (Anai matauna leibanena sopi yuviyavi ititayelu oviloupakala; avai tuta iiyamata tamala la ase.) ");
INSERT INTO kij_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anai latula Disoni e matauna tubusi, Emdani, Esibani, Itirani, deli Kerani dalela. Tuvaila Anai latula natana vivila yagala Owolibama. ");
INSERT INTO kij_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esa dalela madilasina Bilani, Saavani, deli Akani. ");
INSERT INTO kij_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disoni dalela madilasina Usa deli Arani. ");
INSERT INTO kij_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Matausina Ora dalela eisisuaisi mapilana Edom. yagasi, Lotani, Sobali, Sibioni, Anai, Disoni, Esa, deli Disani. ");
INSERT INTO kij_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","39","Omitibogwa igau gala avai guyau iguguyoi Isireli, e ka, baisa yagasi matausina eitakasasi gweguyala Edom. Bela matauna Beori latula, tolela Dinaba Yobabi matauna Sera latula tolela Bosira Usam matauna tolela mapilana Temani Adadi matauna Bedadi latula, tolela Aviti, (matauna eitomgwaga odubasi mina Midiani okabilia mapilana Mowabi) Samla matauna tolela Masireka Sauli matauna tolela Reyoboti Wa Waya Beali Anani matauna Akibori latula Adadi matauna tolela Pau (matauna la kwava yagala Meetabeli; minana Materedi latula, e Meseyabi tabula.) ");
INSERT INTO kij_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Matausina Iso tubula mina Edom. Timna, Aliva, Yeteti, Owolibama, Ela, Pinoni, Kenasi, Temani, Mibisari, Magidieli, deli Iram. E ammakatuposina dala madalasina isisuaisi idokaisi si valu yagasi oigiyagala wala si dala. ");
INSERT INTO kij_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yekobe isigaga baisa mapilana Kenani, ambaisa mesisiki tamala. ");
INSERT INTO kij_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","E baisa goli liliula Yekobe veyala. Matauna Yosepa toulatila wala, kweluwotala kwailima kwaiyu kala taitu. E matauna deli mimilisi tuwʹala iyamataisi mayuwosina sipi toyo gota. Tuwʹala matausina Bilia deli Silipa litusia, minasina tumasi la ula eivigaki la kukova. E tuta tuta Yosepa bilokaia tumasi bisolamapu biga paila tuwʹala si wotetila. ");
INSERT INTO kij_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yekobe tombwailila wala Yosepa, tuwʹalaga kasi yebwaili sitana wala, paila eiuni Yosepa tutala bogwa eitomoya. Yekobe ibasi yatala Yosepa kala kakapula yawonaku isim kala yumiyami, saina yaminabwaita, e isaiki Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tutala tuwʹala eigisaisi tumasi tombwailila wala Yosepa e saina ikalisuwoli matausina, e ikoulovaisi budasi sainela, e gala ikalubailisi kaina ibigitonisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","E bogi kwaitala Yosepa imimi e oluvi iluki tuwʹala avaka mimi makwaina. Mitaga tutala ilagaisi ikoulovaisi matauna sainela. ");
INSERT INTO kij_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosepa ikaibiga, kawala, “Ka, kulagaisi baisa avaka lamimi. ");
INSERT INTO kij_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Komwaidodasi wa bagula tatataisi witi, e makaisina witi tasailavaisi. E ka, yeigu ulo sailava itokaia itomalaula goli. E yokomi mi sailava itoulaisi ulo sailava e ikavaginasi baisa maluvana.” ");
INSERT INTO kij_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Tuwʹala ikaibigasi kawasi, “Wei. Ki, kaina kudoki bukuguyau e bukukwaraiwogaimasi?” E mapaila ikoulovaisi matauna sainela paila bogwa eimimi makawala, e deli eililivala mimi makwaisina. ");
INSERT INTO kij_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Oluvi Yosepa imimi tuvaila e iluki tuwʹala, kawala, “Ka, bogwa lamimi tuvaila e wa mimi agisi kalasia e tubukona e tuvaila utuyam naluwotala natana imakaiagusi ikavaginasi baisa yeigu.” ");
INSERT INTO kij_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","E tuvaila iluki tamala makwaina mimi e tamala ibuyoyu matauna, kawala, “Wi, saina gegedu makwaina mimi. Ki, kaina kudoki kidamwa inam deli tuwamwa e deli goli yeigu bakamakaiamsi bakakavaginasi baisa yoku? Wo!” ");
INSERT INTO kij_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","E tuwʹala isim si pogi baisa Yosepa, mitaga tamala ininamsi komwaidona vavagi makwaisina. ");
INSERT INTO kij_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Yosepa tuwʹala ilokaiasi Sekem biyamataisi mayuwona la sipi tumasi. ");
INSERT INTO kij_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","E kwaitala yam Yekobe iluki Yosepa, kawala, “Ka, magigu bukula Sekem, mapilana tuwamwa iyamataisi mayuwona sipi.” E Yosepa ivitakaula, kawala, “Bogwala bala.” ");
INSERT INTO kij_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tamala ilivala, kawala, “Kula sitana kugisi tuwamwa deli sipi, ammakawala si kaisisu, e kumaiga bulogasi bukulukwaigu.” Mapaila tamala iwitali bisilavi Itayatilela Ebironi e bila. Yosepa iviloubusi Sekem, ");
INSERT INTO kij_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","e ililoula olopola mapilana. Taitala tau igisi matauna e ikatupoi, kawala, “Mwa! Avaka kunainevi?” ");
INSERT INTO kij_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","E ivitakaula, kawala, “Sogu, lanainevila tuwagwa iiyamataisi si sipi. Anigadaim bukulukwaigu am mesisikaisi.” ");
INSERT INTO kij_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","E tau matauna ikaibiga, kawala, “Bogwa leilosi. E lalagi si mowai eililivalasi mwada bilosi mapilana Dotani.” Mapaila Yosepa ibokuli tuwʹala e ibani matausina mapilana Dotani. ");
INSERT INTO kij_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tuwʹala igisaisi matauna sitana kaduwonaku ililoula leima. E igau gala biviloubusi, ikeiwalaisi mwada bikatumataisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ilivalasi taitala baisa taitala, kawasi, “Wa, ka. Tokalamimi bogwa leima. ");
INSERT INTO kij_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","E, tauwau, bitakatumataisi, e wowola bitalavaisi bila outuwotu kwaimada. Kainaga bitakaibigasi mwada natana bolodila eigigadi wala ikamati. E bitagisi ammakawala bisunapula kala kamokwita kala mimi matauna.” ");
INSERT INTO kij_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubeni ilagi ikikeiwalaisi mwada biwaiyasi, e inevi ammakawala bikoli Yosepa. Ikaibiga, kawala, “Kaina gala bitakatumataisi. ");
INSERT INTO kij_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Bwaina wala, talavaisi bila makwaina utuwotu kwaimada. Gala bibodi bukuyogagaisi matauna.” Ililivala makawala, mwada idoki igau bima bikoli e oluvi biwitali matauna bikaimilavau baisa tumasi. ");
INSERT INTO kij_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","E avai tuta Yosepa imakaia tuwʹala, saina minimani ivililaisi miyana kala kakapula deli yumiyamila saina yaminabwaita. ");
INSERT INTO kij_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","E oluvi iyosisi ilavaisi ila makwaina utuwotu kwaimada. ");
INSERT INTO kij_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ikamkwamsi, e nani igisaisi budotala mina Isimeili ikwaidadinasi, eisilavaisi mapilana Giliadi ililoulasi bilosi Itipita. Si kameli eididagaisi bidubadu kai yekwesila deli waitunela ituwoli ituwoli avaka bibodi biwaki kaula, e deli kai pwatigela simasimina avaka bivigakaisi bisuluki bulami. ");
INSERT INTO kij_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda iluki sala, kawala, “Tauwau, ammakawala? Kidamwa bitakatumataisi bodadasi e oluvi takatupwanaisi, e avaka kala bwaina paila yakidasi? ");
INSERT INTO kij_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kaina bitagimolaisi matauna baisa mina Isimeili, e bivigakaisi si ula. E makawala goli gala bibodi bitayogagaisi. Paila mokwita wala matauna bodadasi, tamadasi goli la unai.” E matausina sala itagwalasi, ");
INSERT INTO kij_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","e tutala mimilisi mina Midiani togigimwala ililoulasi imaisi, e ilupaisi Yosepa metoya outuwotu e igimolaisi Yosepa baisa mina Isimeili, mapula matauna kweluwoyu siliba. E matausina mina Isimeili ilauwaisi Yosepa ilosi Itipita. ");
INSERT INTO kij_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Tutala Rubeni ikaimilavau makwaina utuwotu, e ibani Yosepa bogwa eitamwau. E ikisi kala kwama deli la ninamwau. ");
INSERT INTO kij_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ilokaia budala e ikaibiga, kawala, “Magudina gala wala abani baisa. Wi, avakaga bavagi?” ");
INSERT INTO kij_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Mapaila ikatumataisi natana gota nagwadi e ividagwaisi miyana kala kakapula obuyavila minana gota mwada bivitokaisi bolodila eigadi. ");
INSERT INTO kij_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ilauwaisi miyana isakaisi tumasi, e ikaibigasi, kawasi, “Ka bogwa lakabanaisi miyana. Ki, kaina baisa latum kala kakapula?” ");
INSERT INTO kij_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yekobe ivitusi miyana e ikaibiga, kawala, “Wi, miyanala latugu kala kakapula. Bogwa leikamati natana bolodila nagigasisi. Mauna bogwa einovili eitapupoi latugu Yosepa.” ");
INSERT INTO kij_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yekobe saina mwau nanola, ikisi kala kwama e isikam la saigala. E ivalam paila Yosepa tuta kaduwonaku. ");
INSERT INTO kij_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Komwaidosi litula tauwau deli vivila mwada bivisimolaisi matauna, mitaga ipaiki wala, gala magila bisimla. Ikaibiga, kawala, “Bogwa babusi bala tomata osi valu mitaga gala wala basim valam paila latugu.” E iuvalam tuta komwaidona paila latula Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","E mapilana Itipita mina Midiani eigimolaisi Yosepa baisa mina Itipita si guyau la toyausa yagala Potipara. E matauna ligisa kala toyamata kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","E tuta matutona wala Yuda isilavi budala e ilokaia taitala tau yagala Ira, tolela Adulam. ");
INSERT INTO kij_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","E mapilana wala, Yuda ipakusi sola natana vivila vilela Kenani, minana tamala yagala Suwa. E Yuda ivaiya minana, ");
INSERT INTO kij_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","e minana iuni guditala litusi tau, e ivabu yagala Eri. ");
INSERT INTO kij_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Minana isumavau e iuni gudiyuwela litusi tau e ivabu yagala Onani. ");
INSERT INTO kij_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","E tuvaila isumavau e iuni guditolula litusi tau wala, e ivabu yagala Sela. Yuda isisu mapilana Akisibi avai tuta gwadi magudina eikaloubusi. ");
INSERT INTO kij_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","E Yuda iyovaiya la kuluta yagala Eri baisa natana vivila yagala Tamara. ");
INSERT INTO kij_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","E Eri la bubunela gaga, gala wala iyomwasali nanola Guyau, mapaila Guyau ikatumati matauna. ");
INSERT INTO kij_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Oluvi Yuda iluki Eri bodala yagala Onani kawala, “Mwa kulokaia kumisii minana tuwam kubuyala. Kuvagi makawala kada gulogulasi. E kuvaiya minana, e gagabila tuwam dalela bidalasi metoya baisa yoku.” ");
INSERT INTO kij_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mitaga Onani bogwa leinikoli gugwadi biuni gala wala dalela matauna. Mapaila avai tuta matauna bikanavaiya minana tuwala kubuyala, e la sopi bimoi wala ibubusi omalaga, mapaila baisa gala wala bibani gugwadi paila tuwala dalela. ");
INSERT INTO kij_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Avaka matauna leiuvagi, Guyau gala imwamwasila nanola, mapaila Guyau tuvaila ikatumati matauna. ");
INSERT INTO kij_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Oluvi Yuda iluki yawala kawala, “Tamara bwaina bukukwaimilavau baisa veyamwa, e bukusisu wala nakakau yoku, e igauga latugu matauna Sela iulatila.” Yuda ilivala makawala paila ikokola idoki Sela bikaliga makawala tuwala matausina leikaligasi. Mapaila Tamara ikaimilavau ola valu. ");
INSERT INTO kij_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","E igau bogwa leim lumwaitala, Yuda la kwava ikaliga. Avai tuta Yuda bogwa eisunapula wa libu, matauna sola lubaila Ira tolela Adulam ilosi mapilana Timnai, ambaisa la sipi eiviliwaisi unuunusi. ");
INSERT INTO kij_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","E taitala tomota iluki Tamara paila yawala bila Timnai bivaliu unuunusi la sipi. ");
INSERT INTO kij_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Mapaila Tamara ivilili kala koula miyasina eisisikoma isaim, e isikomaga ituwoli karekwa, deli ikapoli migila, e isili okadumalaga makadana bila Enaim, valu makwaina itobodi wala keda bila mapilana Timnai. Minana bogwa einikolibogwi, Yuda latula molagwadi matauna Sela bogwa eiulatila, mitaga gala wala iyovaiyasi matauna baisa minana. ");
INSERT INTO kij_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","E avai tuta Yuda igisi minana, idoki mwada natana minasina nakomlilipwa, paila uula migila bogwa eikapoli. ");
INSERT INTO kij_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Mapaila ilokaia minana osiusiula keda e ikatupoi, “Ve, tawaga takanavai?” Mitaga gala inikoli minana yawala wala. Minana ikatupoi kawala, “Ki avakaga bukusakaigu?” ");
INSERT INTO kij_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","E matauna imapu minana kawala, “Igau bawitali natana gota nagwadi metoya ogu yawa.” Minana ikaibiga, “Bogwa bwaina, kidamwa wala bukusakaigu avai vavagi kabutuvitusila avaka lokukwanukusaigu, tatoula wala bukuwitali gota minana.” ");
INSERT INTO kij_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","E matauna ikatupoi minana kawala, “Ki avaka basakaim paila kabutuvitusila avaka lakanukusaim?” E minana ivitakauloki matauna kawala, “Magigu bukusakaigu kam kuwekuwa makwaina kibila yamam deli m kwaitukwa makaina lokuiyosi.” E matauna isaiki guguwa makwaina baisa minana. Oluvi matauna imokaia minana, e igau oluvi minana isuma. ");
INSERT INTO kij_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamara ikaimilavau ola bwala, ikatulova e isikomvauga kala koula. ");
INSERT INTO kij_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda iwitali lubaila Ira biuyoki gota minana baisa minana vivila, e bikaimaliga guguwa makwaisina leisakaibogwi, mitaga Ira gala ibodi bibani minana. ");
INSERT INTO kij_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Matauna ikatupoi mimilisi tolesi Enaim kawala, “Tauwau, ki gala sitana kugisaisi minana nakomlilipwa, minana mesisikila baisa osiusiula keda?” Matausina ivitakaulokaisi matauna kawasi, “Mwa, gala wala avai tuta natana nakomlilipwa isisu baisa.” ");
INSERT INTO kij_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","E matauna ikaimilavau baisa Yuda e iluki matauna kawala, “Gala wala abani minana. Deli tolesi valu makwaina ikatulokaigusi mwada gala avai tuta natana nakomlilipwa isisu baisa.” ");
INSERT INTO kij_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda ikaibiga kawala, “Desi wala biyosi guguwa makwaisina. Gala magidasi tomota bigigilaidasi. Ka, yeigu magigu babuwi minana, mitaga gala wala kubani minana.” ");
INSERT INTO kij_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Makawala natonu tubukona bogwa leiwokuva, taitala tomota iluki Yuda kawala, “Mwa, yawam Tamara eibububuna makawala natana minasina nakomlilipwa, e tuta baisa bogwa leisuma.” E Yuda ikaibiga kawala, “Kulosi kuyosisi minana kulauwaisi oyosewa, e kuvakamataisi minana wa kova.” ");
INSERT INTO kij_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","E bogwa leiyosisi minana bivisunupuloiyaisi bilauwaisi, e minana ikilavi biga baisa yawala kawala, “Mwa, yeigu lasuma metoya tau matauna la guguwa makwaisina laiyosi. Kugisi availa la guguwa - makwaina kuwekuwa kibila yamala deli makaina kaitukwa.” ");
INSERT INTO kij_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","E Yuda bogwa ivitusi guguwa makwaisina, e ilivala kawala, “Bogwa leikamokwita minana. Yeigu gala avagi makawala kada gulogulasi baisa minana - ibodaigu bayovaiya latugu Sela baisa minana.” Mapaila Yuda gala avai tuta tuvaila ikanavaiya minana. ");
INSERT INTO kij_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Avai tuta minana bogwa la tuta bitapoi yamala, ivitusaisi lopola minana biuni nupoyu. ");
INSERT INTO kij_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tutala minana lopola bogwa eigidiusiwasi bitapoi yamala, guditala magudisina yamala isunupulabogwa; e minana nakaivalulu iyosi gwadi yamala isipu wotunu yabweyani, e ilivala kawala, “Ka, magudina kuluta.” ");
INSERT INTO kij_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mitaga ibiyumali yamala ikaimilivau olopola inala, e magudina mwada kasusu ikaloubusibogwa. Oluvi minana nakaivalulu ilivala kawala, “Wo, kukosaikikina wala lokusunapula!” Mapaila ivabu yagala magudina idoki Peresi. ");
INSERT INTO kij_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","E oluvi magudina mwada kuluta ikaloubusi deli wala miyana wotunu yabweyani oyamala, e ivabu yagala magudina idoki Sira. ");
INSERT INTO kij_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","E mina Isimeili eilauwaisi Yosepa ilosi Itipita e igimolaisi matauna baisa taitala guyau la toyausa yagala Potipara. E matauna ligisa kala toyamata kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","E Guyau Yaubada isikaili Yosepa e ipilasi matauna kidamwa bipeula. E Yosepa isisu ola bwala kala tokwaraiwaga guma Itipita, matauwena Potipara. ");
INSERT INTO kij_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","E matauna tokwaraiwaga igisi kidamwa Guyau Yaubada eisikaili Yosepa e mapaila ipapeula wala avaka avaka eiuvagi. ");
INSERT INTO kij_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","E Yosepa iyomwasali nanola Potipara e mapaila ivigaki matauna la tosikwawa. E mapaila Yosepa iyosi karaiwaga paila tokwaraiwaga la bwala deli paila komwaidona avaka avaka eisisii. ");
INSERT INTO kij_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","E oluvi Guyau Yaubada imitukwaii matauna guma Itipita deli la ula komwaidona, deli goli ikabwaili komwaidona guguwala la bwala deli la bagula. ");
INSERT INTO kij_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Mapaila Potipara itugwali komwaidona la vavagi baisa Yosepa, mwada biyamati, e gala wala bininamsi avai vavagi avai vavagi - mesinaku wala ininamsi kamkwam wala. Matauna Yosepa togumwakota deli tomatabwaila, ");
INSERT INTO kij_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","e igau wala Potipara la kwava ikau matala paila matauna, e ikasemwali matauna mwada bimasisisi kasitaiyu. ");
INSERT INTO kij_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mitaga Yosepa ipaiki e eikamitilaki minana, kawala, “Ka, kugisi, agu tokwaraiwaga gala wala ininamsi avai vavagi ola bwala kidamwa yeigu asisu baisa. E bogwa isakaigu karaiwaga paila komwaidona avaka avaka isisii. ");
INSERT INTO kij_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","E yeigu isim wala ulo karaiwaga makawala la karaiwaga matauna. E bogwa itugwali avaka avaka baisa yeigu, mesinaku wala yoku gala wala itagwala. E ammakawalaga gagabila bavagi mitugaga makwaina e makawala bavigaki sula baisa omatala Yaubada?” ");
INSERT INTO kij_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","E minana yam yam goli imnabi matauna, mitaga gala goli bitagwala bimisii minana. ");
INSERT INTO kij_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mitaga kwaitala yam Yosepa isuvi wa bwala kidamwa bipaisewa e gala avai topaisewa isisu deli. ");
INSERT INTO kij_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","E minana iyosi kala kakapula e ibia, kawala, “Kumaga bitamasisi kadai?” Mitaga Yosepa isaga e isakaula isunapula e ikilavi kala kakapula oyamala minana. ");
INSERT INTO kij_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Minana igisi kidamwa Yosepa ikilavi kala kakapula e eisakaula isunapula, ");
INSERT INTO kij_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","e minana idou matausina la touwata ikaibiga, kawala, “Ka, kugisaisi miyana. Matauwenala guma Iberu, ulo mwala eimai baisa bogwa eiyogigedu da sisuaisi. Ka, bogwa eisuvi matabudona ulo kabomasisi e iyosaigu mwada bimisiaigu, mitaga yeigu awakula saina vakaigaga. ");
INSERT INTO kij_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","E tutala ilagi ulo wakula e ikilavi kala kakapula e isakaula isunapula.” ");
INSERT INTO kij_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","E isisii miyana igau tutala Yosepa kala tokwaraiwaga ikaimilavau. ");
INSERT INTO kij_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","E iluki matauna makawala wala, kawala, “Ka, matauwenala guma Iberu yokugwa lokumai baisa eisuvi matabudona ulo kabomasisi e iyosaigu. ");
INSERT INTO kij_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mitaga tutala awakula e matauna eikilavi kala kakapula okaipapagu, e isakaula isunapula.” ");
INSERT INTO kij_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Yosepa kala tokwaraiwaga saina igidaleiya, ");
INSERT INTO kij_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","e ikaraiwaga biyosisi Yosepa bisailisi wa bwala katupipi, e bisisu matabudona ambaisa tuta tuta bisailisi si guyau la tokwatupipi. E baisa goli isivagasi. ");
INSERT INTO kij_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mitaga Guyau Yaubada isikaili Yosepa e imitukwaii matauna. E Yosepa saina iyomwasali nanola matauna tokatupipi kasi toyamata. ");
INSERT INTO kij_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Matauna ivigaki Yosepa bikaraiwogi komwaidosi tokatupipi, e isaiki la koni biyamati komwaidona avaka eiuvagaisi wa bwala makwaina. ");
INSERT INTO kij_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","E matauna toyamata ibodi gala wala bivagi avaka kidamwa bogwa eisaiki Yosepa la koni mwada biyamati baisa. Paila uula Guyau Yaubada eisikaili Yosepa, e mapaila eipeula wala komwaidona avaka avaka eiuvagi. ");
INSERT INTO kij_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Igau oluvi mina Itipita si guyau la tovigogula waini deli la togabu pwarawa kasi tokugwa iyogagaisi nanola si guyau. ");
INSERT INTO kij_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","E guyau igibuluwa baisa matausina la touwata, ");
INSERT INTO kij_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","e isaili matausina wa bwala katupipi. Isisuaisi ola bwala matauna toyamata kasi tokugwa. E baisa goli Yosepa mesisiki. ");
INSERT INTO kij_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","E isigagasi baisa, tuta kaduwonaku, e matauna tokugwa ivigaki mwada matausina kasitaiyu si touwata Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","E bogi kwaitala matausina tovigogula waini deli togabu pwarawa imimisi, e kasi mimi kala katumiki ituwoli ituwoli. ");
INSERT INTO kij_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","E eiyam Yosepa imakaia matausina igisi kidamwa deli si nokubukubu. ");
INSERT INTO kij_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","E ikatupoi matausina, kawala, “Tauwau, avaka uula kunokubukubusi lagaila?” ");
INSERT INTO kij_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ivitakaulasi, kawasi, “Ka yakama bogwa lakamimi, e gala availa isisu baisa gagabila bikatumiki avaka uula mimi makwaisina.” E Yosepa ikaibiga, kawala, “Yaubada wala bisaiki peula kidamwa bitakatumiki mimi. E bukulukwaigusi avaka kami mimi.” ");
INSERT INTO kij_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","E matauna tovigogula waini ikaibiga, kawala, “Ka, agu mimi agisi tamtala waini omatagu, ");
INSERT INTO kij_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","e isim sisila sisitolu. E avai tuta yekwesila eitam, e nanakwa isisi e ibukula, e mapulina bogwa leimonogu. ");
INSERT INTO kij_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Oyamagu ayosi ulo guyau kala viga, mapaila akau mapulina waini apoli e waini ibubusi okala viga. E asaiki guyau mwada bimom.” ");
INSERT INTO kij_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosepa ikaibiga, kawala, “Kala katumiki baisa makawala. Ka, masisisina sisitolu baisa kwaitolu yam. ");
INSERT INTO kij_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Igau biwokuva kwaiyu yam, e kwaitolulaga yam guyau bitanekwaim e biligaiwa m sula, e bikaimilivauwaim om wotetila. E bukusaiki matauna kala viga bimom, makawala omitibogwa avaka lokuuvagi. ");
INSERT INTO kij_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","E anigadaim bukululuwaigu kidamwa tuta matutona bukusibwabwaila. Kaina bukukwavitagi yagagu baisa guyau e makawala bukupilasaigu kidamwa basunapula metoya wa bwala katupipi makwaina. ");
INSERT INTO kij_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Paila ka, bogwa eiyosimakavaigusi imaiyaigusi metoya oma valusi mina Iberu. E tuvaila mapilana Itipita, gala wala avai pakula baisa yeigu bibodi bisailigusi wa bwala katupipi.” ");
INSERT INTO kij_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","E tutala matauna togabu pwarawa igisi kidamwa matauna tovigogula waini ibani kala katumiki bwaina, e iluki Yosepa, kawala, “Ka, yeigu tuvaila lamimi. Odabagu tolu petala pwarawa agigabi. ");
INSERT INTO kij_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","E mitana odabala isisu bidubadu kawailuwa saina simokainia, avaka lagabu paila guyau, e mauna nayoyowa ikamkomasi makwaisina kawailuwa.” ");
INSERT INTO kij_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosepa ivitakaula, kawala, “Kala katumiki baisa makawala. Ka, tolu peta baisa kwaitolu yam. ");
INSERT INTO kij_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Igau biwokuva kwaiyu yam, e kwaitolulaga yam guyau bitanekwaim, e bikaraiwaga bikapitunaisi kaiyom. Oluvi bilasoyasi wowom wa kai, e mauna nayoyowa bikomasi wowom.” ");
INSERT INTO kij_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","E igau yam kwaitolula, makwaina la yam kaloubusi guyau e ivagi kwaitala paka idou la touwata komwaidosi bimaisi. E tuta matutona itaneku matauna la tovigogula waini deli matauna la togabu pwarawa kasi tokugwa, e imai matausina omitasi la touwata komwaidosi. ");
INSERT INTO kij_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","E matauna tovigogula waini ikaimilivau ola wotetila avaka eivagi omitibogwa, ");
INSERT INTO kij_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","mitaga matauna togabu pwarawa ikaraiwaga bikatumataisi. E komwaidona vavagi baisa eikaloubusi makawala avaka Yosepa leilivala. ");
INSERT INTO kij_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mitaga matauna tovigogula waini gala wala ininamsi Yosepa. Bogwa wala ilumwelavi matauna. ");
INSERT INTO kij_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kwaiyu taitu bogwa leiwokuva, e guyoula Itipita imimi. E okala mimi matauna itotu opapala waya Naili. ");
INSERT INTO kij_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","E makateki nalima nayu bulumakau saina naminibwaita deli nakakaitubwa iyoulapulasi imaisi opapala waya e ikamkwamsi mnumonu. ");
INSERT INTO kij_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","E tuvaila nalima nayu bulumakau iyoulapulasi saina napupatata natotuwana. Imaisi itotusi otalisi minasina nakakaitubwa opapala waya, ");
INSERT INTO kij_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","e minasina bulumakau napupatata ikomasi minasina bulumakau nakakaitubwa. Kala vigimkovila, guyau imamata isimalaula. ");
INSERT INTO kij_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Matauna ikenuvau imasisi e tuvaila imimi. Igisi kwailima kwaiyu waitunela witi kwesukusaikutu bogwa leimituwoki iuwasi uulaga kaitala wala. ");
INSERT INTO kij_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Oluvi kwailima kwaiyu witi tuvaila iuwasi, makwaisina kwelubulobwaga kwesisisikwa yagila yuviyavi metoya oviloupakala ikaligou. ");
INSERT INTO kij_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Makwaisina witi kwelubulobwaga kwemigigaga ilupolaisi makwaisina kwesukusaikutu deli kwemmatuwa. E guyau imamata bogwa ivitoki tolosila avaka bogwa igisi okala mimi. ");
INSERT INTO kij_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Eiyam kaukwau guyau inokubukubu, mapaila iwitali biga baisa matausina tomigameguva deli tokabitam mapilana Itipita. Iluki matausina kala mimi, mitaga gala availa gagabila bikatumiki makwaisina mimi baisa matauna. ");
INSERT INTO kij_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","E matauna tovigogula waini iluki guyau, kawala, “Ibodaigu bakamituli sula avaka bogwa lavagi. ");
INSERT INTO kij_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ka, yoku kugibuluwa baisa matauna togabu pwarawa deli goli yeigu, e lokusailima obolela mipuki deli matauna toyamata kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","E kwaitala bogi kamataiyu wala kamimi, e mimi makwaisina kala katumiki ituwoli ituwoli. ");
INSERT INTO kij_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","E taitala totubovau guma Iberu isisu deli yakama, e toyamata kasi tokugwa la ula matauna. E kalivala kama mimi ilagi ikatumiki baisa yakama. ");
INSERT INTO kij_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","E vavagi makwaisina eikaloubusisi makawala bogwa eilivala. Ka, yoku lokukwaimilivauwaigu ogu paisewa, mitaga matauna togabu pwarawa lokukwaraiwogi leikatumataisi.” ");
INSERT INTO kij_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","E guyau iwitali biga baisa Yosepa paila bima, e saina nanakwa imaiyaisi metoya obolela mipuki. Ikugwa iviliu kala gabula e ikatulovi kala kakapula e ilokaia guyau omatala. ");
INSERT INTO kij_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","E guyau iluki matauna, kawala, “Yeigu lamimi kwaitala mimi e gala availa gagabila bikatumiki baisa yeigu. E ilukwaigusi kidamwa yoku gagabila bukukwatumiki tomota kasi mimi.” ");
INSERT INTO kij_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosepa ivitakauloki, kawala, “O ulo guyau, yeigu gala gagabila bakatumiki. Mitaga Yaubada wala metoya ola katumiki biyomwasalaim.” ");
INSERT INTO kij_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","E guyau ilivala, kawala, “Lamimi kidamwa yeigu atotu opapala waya Naili. ");
INSERT INTO kij_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","E nalima nayu bulumakau nakakaitubwa deli naminibwaita ikaloubusisi metoya wa waya e ivitouulasi kamkwam mnumonu. ");
INSERT INTO kij_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","E tuvaila nalima nayu bulumakau ikaloubusisi napupatata natotuwana minasina. E saina namigigaga minasina bulumakau, yeigu gala agisi natana makawala olopola Itipita. ");
INSERT INTO kij_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","E bulumakau nakapatata ikomasi minasina naminibwaita nakakaitubwa. ");
INSERT INTO kij_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Taga gala availa binikoli mwada bogwa eikamkwamsi kwaiveka makawala, paila kasi gigisa oluvi makawala wala omitibogwa, gala wala bidavila uwosi minasina. E oluvi amamata asimalaula. ");
INSERT INTO kij_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","E tuvaila amimi agisi kwailima kwaiyu witi kwesukusaikutu bogwa leimituwoki iuwasi uulaga kaitala wala. ");
INSERT INTO kij_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","E tuvaila kwailima kwaiyu witi waitunela kwelubulobwaga kwesisisikwa metoya yagila yuviyavi oviloupakala. ");
INSERT INTO kij_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","E makwaisina witi kwesisisikwa ilupolaisi makwaisina kwesukusaikutu. Oluvi goli aluki agu mimi baisa tomigameguva, mitaga gala availa gagabila bikatumiki baisa yeigu.” ");
INSERT INTO kij_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosepa ikaibiga baisa guyau, kawala, “Makwaisina mimi kala katumiki kwaitala wala, e Yaubada bogwa eilukwaim wa mimi paila avaka bivagi tuta oluvi. ");
INSERT INTO kij_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","E baisa makawala. Nalima nayu bulumakau nakakaitubwa baisa kwailima kwaiyu taitu. E kwailima kwaiyu makwaisina waitunela witi baisa tuvaila kwailima kwaiyu taitu. E kala katumikiga makawala wala. ");
INSERT INTO kij_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","E nalima nayu bulumakau nakapatata makateki eikaloubusisi eimaisi, deli makwaisina kwailima kwaiyu waitunela witi eima yagila yuviyavi metoya oviloupakala ikaligou baisa makawala kwailima kwaiyu taitu molusaula. ");
INSERT INTO kij_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Baisa bogwa makawala avaka lalukwaim. Yaubada bogwa ivitulokaim paila avaka bivagi. ");
INSERT INTO kij_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Olopola kwailima kwaiyu taitu saina maliapwasa olopola Itipita. ");
INSERT INTO kij_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","E maliapwasa bogwa biwokuva, e biviloubusiga kwailima kwaiyu taitu molusaula, e makwaisinaga taitu luvabwaila igau bilumwelavaisi paila molusaula bogwa biyotitavi valu. ");
INSERT INTO kij_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","E kali nanamsa paila luvabwaila deli malia bogwa bitamwau mokwita, pailaga molusaula makwaina kwevakaigaga sainela. ");
INSERT INTO kij_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","E pailaga kala kamokwita kam mimi kwaiyu, baisa kala katumiki. Yaubada bogwa eiyosikikiti e bogwa wala bikaloubusi igau tuta pikekita wala. ");
INSERT INTO kij_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Mapaila lagaila wala ibodi bukunagi taitala tau tokabitam deli toninitalapula, e bukusaiki biguyoi mapilana valu. ");
INSERT INTO kij_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Makawala goli bukunagi mimilisi kaidadala valu. E bipaisewasi otutala tayoyuwa, e metoya kougugulela witi gulolima bikauwaisi gulotala wala. Bivagaisi makawala taitu kwaitala kwaitala olopola makwaisina kwailima kwaiyu taitula luvabwaila deli malia. ");
INSERT INTO kij_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ibodi bukukwaraiwaga bikougugulaisi witi komwaidona makawala paila taitula luvabwaila igau bima, e bukusaiki matausina kasi karaiwaga bikedidagaisi witi omi valu makwaisina, e biyamataisi. ");
INSERT INTO kij_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Paila kougugula makwaina bisisu e bipilasi valu avai tuta molusaula makwaina bikaloubusi paila kwailima kwaiyu taitu mapilana Itipita. E makawala wala tomota gala bikamolusi.” ");
INSERT INTO kij_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","E tutala guyau deli kaidadala valu ikabwailisi nanamsa makwaina, ");
INSERT INTO kij_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","e guyau iluki matausina, kawala, “Galaga bitabanaisi avai tau makawala Yosepa, paila matauna Yaubada la baloma isisu olumoulela.” ");
INSERT INTO kij_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","E guyau iluki Yosepa, kawala, “Yaubada bogwa ivitulokaim vavagi komwaidona mapaila kam gigisa wala ikamitulaim yoku m kwabitam saina vakaigaga deli m ninitalapula gala taitala makawala yoku. ");
INSERT INTO kij_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","E yoku bakaraiwaga bukuguyoi ogu valu e ulo tomota komwaidona bikabikuwolaisi m kwaraiwaga. Mitaga yeigu wala odabam basisu. ");
INSERT INTO kij_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Baisa tuta bogwa lanagaim bukutokwaraiwaga komwaidona viluwela Itipita.” ");
INSERT INTO kij_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","E guyau ivilili kala kakalougwa isim leilaila metoya oyamala. E leilai makwaina ikibuboti gweguya kabutuvitusila karaiwaga. E kabutuvatusi makwaina ivilili oyamala Yosepa. E ivisikoma matauna kala kwama yaminabwaita e isipu kala kuwekuwa goulawokuva okaiyola. ");
INSERT INTO kij_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","E tuvaila guyau isaiki matauna gweguya si waga kaibibiu makaina isikaili paila bisila, deli la tokaiala bikugwasi omatala matauna bikawausi, “Guyau ee guyau, kuulaisi keda.” E makawala goli Yosepa ivigakaisi bitokwaraiwaga komwaidona viluwela Itipita. ");
INSERT INTO kij_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","E guyau iluki matauna kawala, “Yeigula wala guyau, mapaila bogwa lakaraiwaga gala availa olopola Itipita gagabila bivagi avai vavagi kidamwa yoku gala ikugwa bukutagwala.” ");
INSERT INTO kij_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","E guyau idoki Yosepa igatala Itipita igalela maigana Sapenati Panea, e isaiki matauna natana la kwava yagala Asinata. E minana tamala yagala Potipera, matauna tolula mapilana Eliopolisi. Yosepa kala taitu kweluwotolu wa tuta makwaina ivitouula iwotetila baisa guyoula Itipita. E Yosepa isilavi la bwala karaiwaga guyau itavina olumoulela Itipita viluwela komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Olopola kwailima kwaiyu taitu makwaisina malia, pwaipwaia isaiki uwala bidubadu sainela, ");
INSERT INTO kij_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","e ikouguguli uwala taitu kwailima kwaiyu makwaisina ididagi valu komwaidona Itipita olopola. Itipita opapala valu kwaitala kwaitala makwaisina ididagi kaula metoya obigulela valu makwaina. ");
INSERT INTO kij_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Witi kala bidubadu ikalisau sainela, e Yosepa gala gagabila biveikwai, paila saina bidugaga makawala kanakenuva obolita kala bawa. ");
INSERT INTO kij_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Igau makateki molusaula bisunapula, Yosepa ikugwa ibani taiyu litula metoya Asinata. ");
INSERT INTO kij_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","E ikaibiga, kawala, “Yaubada ivigakaigu balumwelavi agu mmayuyu deli goli tamagu dalela komwaidona.” Mapaila ivabu molitomoya yagala Manasa. ");
INSERT INTO kij_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Tuvaila ikaibiga kawala, “Yaubada bogwa isakaigu litugwa olopola valu makwaina ulo tuta mmayuyu deli mwau.” Mapaila ivabu molagwadi yagala Epereim. ");
INSERT INTO kij_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","E mapilana valu Itipita saina kwaiveka kaimwana paila uula saina bidubadu witi, e leima kala vigimkovila taitu kwailima kwaiyu. ");
INSERT INTO kij_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","E tutala ivitouula molusaula taitu kwailima kwaiyu tuvaila, makawala avaka bogwa leilivala Yosepa. Paila molusaula itokaia baisa valu valu komwaidona. Mitaga mapilana valu Itipita ikasewa kaula. ");
INSERT INTO kij_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","E tutala eivitouula molu baisa Itipita, tomota inigadaisi guyau paila kaula. Mapaila ikaraiwogi tomota bilokaiasi Yosepa e bivagaisi avaka bogwa biluki matausina. ");
INSERT INTO kij_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Mitaga molusaula bogwa eiyouloveka e ikaligiaki baisa valu valu komwaidona, e mapaila Yosepa iulaim komwaidona la bwaima e ivitouula gigimwala witi baisa mina Itipita. ");
INSERT INTO kij_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tomota komwaidona baisa ovalu watanawa imailabasi igimwalasi kʹasi mapilana Itipita baisa Yosepa. Uula molusaula bogwa leikaligiaki komwaidona ambaisa ambaisa. ");
INSERT INTO kij_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Avai tuta Yekobe bogwa einikoli witi isisu mapilana Itipita, e iluki litula tauwau, kawala, “Tauwau, avaka kuvagaisi? Ki ammakawami, gala sitana bikaiki uwomi? ");
INSERT INTO kij_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ka, bogwa lalagi bulogala witi isisu mapilana Itipita. Ibodi bukulosi bukugimwalasi sitana bikamovaidasi e taga bitakaligasi.” ");
INSERT INTO kij_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yosepa tuwʹala tailuwotala bogwa ibusisi bilosi bigimwalasi witi mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mitaga Yekobe gala wala itagwala Beniamina, Yosepa bodala tatoula, deli bilosi, paila saina kala kokola igau avaka bikaloubusi baisa matauna. ");
INSERT INTO kij_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Litula Yekobe deli mimilisi tomota tuvaila deli wala ilosi paila bigimolaisi witi, paila tuta makwaina molusaula eiviloubusi mapilana Kenani. ");
INSERT INTO kij_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yosepa matauna iguyoi valu Itipita, e igigimwala witi baisa tomota ovalu komwaidona. E avai tuta Yosepa tuwʹala leimaisi itaimamilasi omatala ikavaginasi opwaipwaia. ");
INSERT INTO kij_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Tuta makwaina Yosepa igisi tuwʹala leimaisi bogwa inikoli matausina mitaga ivigaki makawala kala tomakava. Ikatilakavi tuwʹala e ikatupoi, kawala, “Tauwau am mokutoyasi?” E ivitakaulokaisi, kawasi, “Makatoyasi mapilana Kenani lakamaisi mwada bakagimwalasi kaula.” ");
INSERT INTO kij_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosepa ivitusi tuwʹala, mitaga matausina gala ivitusaisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","E iluluwai makwaisina mimi eimimi paila matausina e ikaibiga, kawala, “Yokomi tokwauta. Lokumaisi bukunevisi ambaisa ma valusi kala mama.” ");
INSERT INTO kij_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","E matausina ivitakaulokaisi, kawasi, “Gala tomwaya. Yakamaisi makawala m touwata wala kagigimwalasi kaula. ");
INSERT INTO kij_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Yakamaisi komwaidona dilatala wala. Ka, tomwaya, yakamaisi gala tokwauta, yakamaisi tauwau tokwamokwita.” ");
INSERT INTO kij_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yosepa ikaibiga baisa matausina, kawala, “Gala goli. Lokumaisi bukunevisi ma valusi kala mama.” ");
INSERT INTO kij_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ikaibigasiga, kawasi, “Yakamaisi omitibogwa kama bawasi tailuwotala taiyu, tumamaisi taitala tomoya deli kasisuaisi oviluwela Kenani. Taitala bodamasi bogwa eikaliga e kasusugwa eisisu deli tumamaisi.” ");
INSERT INTO kij_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosepa ikaibiga, kawala, “E bogwa makawala lalivala. Yokomi tokwauta wala. ");
INSERT INTO kij_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Baisa makawala bawakolaimi. Alivala biga mokwita omatala guyau, kidamwa gala bukusilavaisi valu mapilana kidamwa gala bukumaiyaisi mi kasusu baisa. ");
INSERT INTO kij_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Taitala yokomi bila bivakouli matauna bimai. Komwaidomiga bukusimwaisi baisa e toyausa biyamataimi igau tutala babani kala kamokwita baisa avaka lokulivalaisi. Kidamwaga gala, ka, alivala biga mokwita omatala ulo guyau, bogwa badokaimi tokwauta.” ");
INSERT INTO kij_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mapaila isaili matausina obolela katupipi kwaitolu yam. ");
INSERT INTO kij_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","E yam kwaitolula, Yosepa ikaibiga baisa matausina, kawala, “Ka, yeigu atemmali Yaubada. E yeigu bakolaimi kidamwaga bukuvagaisi baisa kwaitala wala vavagi. ");
INSERT INTO kij_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Magigu babani kala kamokwita kidamwa yokomi lokukwamokwitasi. Taitala yokomi bisim wala bwala katupipi makwaina ambaisa bogwa eiyamataimi, e kesalaga yokomi ibodi bukukweiitasi bukukwaimalaisi witi baisa veimia tokwamolu, makwaisina bogwa lokugimolaisi. ");
INSERT INTO kij_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Oluvi ibodi bukumaiyaisi budami kasusu baisa yeigu. Kidamwa kuvagaisi makawala, baisa bikamituli avaka bogwa lokulivalaisi biga mokwita. E mapaila gala bakatumataimi.” E matausina itagwalasi paila baisa, ");
INSERT INTO kij_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","e ilivalasi taitala baisa taitala, kawasi, “Ka, lagaila tabodasi mwau takaimapwaisi mmayuyu makwaina avaka bogwa tavigakaisi baisa bodadasi. Bogwa tagisaisi eilumkoli mwau avai tuta einigadaidasi paila pilasi mitaga yakidasi gala wala tapilasaisi. Baisa uula lagaila makwaina pakula bitakaimapwaisi.” ");
INSERT INTO kij_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni ikaibiga, kawala, “Bogwa lalukwaimi mwada gala bukuyogagaisi magudina mitaga yokomi gala wala kulagaisi biga. E lagaila goli bitakaimapwaisi la kaliga.” ");
INSERT INTO kij_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosepa bogwa inikoli avaka eilivalaisi, mitaga matausina gala wala bikatetasi baisa paila uula bogwa eilivalasi baisa matauna metoya baisa tokwatumiki. ");
INSERT INTO kij_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosepa isilavi matausina ila ivitouula ivalam. E avai tuta gagabila bilivilavau, e ikeiita imakaia inagi Simioni bivigaki tokwatupipi, e iyuwoli matauna omitasi. ");
INSERT INTO kij_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosepa ikaraiwaga bitavileisi tuwʹala si koni deli witi, bikaimalaisi si mani taitala taitala ola baiki e isaiki matausina kaula paila kasi kalaga. E bogwa ivagaisi makawala. ");
INSERT INTO kij_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Tuwʹala witi eigimolaisi ikaidodigasi osi ase e isilavaisi Itipita. ");
INSERT INTO kij_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tutala iviloubusisi okatupwaila keda ambaisa bimasisisi, e taitala matausina iulaim la baiki bivakoma la ase e ibani la mani odabala witi. ");
INSERT INTO kij_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","E idou sala kawala, “Tauwau ulo mani ikaimilivauwaisi. Ka, makwaisina ogu baiki.” E ikiuta ninasi, ikatupoiyaisi taitala baisa taitala deli kasi kokola, kawasi, “Tauwau, avaka Yaubada eivigakaidasi?” ");
INSERT INTO kij_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Avai tuta imaisi baisa tumasi Yekobe mapilana Kenani ilukwaisi matauna avaka eikaloubusi baisa matausina, ");
INSERT INTO kij_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","kawasi, “Mwa! Matauna tokwaraiwogala Itipita saina ikatilakaiyaimasi deli itabinakaimasi mwada yakamaisi tokwauta valu. ");
INSERT INTO kij_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mitaga lakamapwaisi la biga kawamasi, ‘Yakamaisi gala tokwauta. Yakamaisi tauwau tokwamokwita. ");
INSERT INTO kij_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Yakamaisi omitibogwa kama bawasi tailuwotala taiyu e litula taitala tau. Taitala bodamasi bogwa eikaliga e kasusu wala eisisu mapilana Kenani deli tumamaisi.’ ");
INSERT INTO kij_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Mitaga matauna ivitakauloki, kawala, ‘Ka, baisa makawala bakateta kidamwa yokomi tokwamokwita. Taitala yokomi bakasim e komwaidomiga bukulauwaisi witi kuuyokaisi veimia, paila kasi molu eisisuaisi, e bukulosi. ");
INSERT INTO kij_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","E bukumaiyaisi mi kasusu baisa yeigu. Baisa bikibuboti e banikoli mokwita mwada yokomi gala tokwauta mitaga tokwamokwita, e igau bakaimilivau budami basakaimi, e oluvi gagabila yokomi bukusisuaisi baisa e bukugigimwalasi.’” ");
INSERT INTO kij_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Bogwa iligabwaisi kasi witi metoya okabosakaila, e taitala taitala ibani kapolela mani isisu. E tutala igisaisi, e deli tumasi Yekobe ikiuta ninasi deli kasi kokola. ");
INSERT INTO kij_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","E tumasi iluki matausina, “Ki, yokomi ninami mwada bakitumou komwaidosi litugwa? Ka, Yosepa eitamwau e Simioni itamwau. E baisa tuta mwadaga magimi bukulauwaisi Beniamina. Mitaga yeigu agumwaleta wala abubani mmayuyu.” ");
INSERT INTO kij_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","E Rubeni iluki tamala, kawala, “Ka, tomwaya, kidamwa gala bakaimilivau Beniamina baisa yoku, e kasitaiyu litugwa kaimapula bukukwatumati wala. Bukuvigaki baisa agu pakula bayamati magudina, e bogwala bakaimilivau magudina.” ");
INSERT INTO kij_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mitaga Yekobe ikaibiga, kawala, “Gala wala gagabila batagwala latugu Beniamina deli bukulosi. Paila tuwala Yosepa bogwa eikaliga e magudina kalamwaleta wala eikesa. Kaina bukubodasi kaboyogagi wa keda e bogwa bisilagi magudina. Ka, yeigu bogwa latomoya. Kidamwaga baboda nanogu kala mwau metoya baisa, e bogwa wala bakaliga.” ");
INSERT INTO kij_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Mapilana Kenani molusaula bogwa saina igaga mokwita. ");
INSERT INTO kij_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Yekobe deli veyala kasi witi bogwa eivinakwaisi baisa avaka eigimolaisi mapilana Itipita. E Yekobe iluki litula, kawala, “Kukweiitasi Itipita kugimwalasi sitana kadasi.” ");
INSERT INTO kij_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yuda iluki tamala kawala, “Tomwaya, tau matauna igidaleiya ilukwaimasi mwada migila gala bakagisaisi kidamwa budamaisi gala deli bakalauwaisi. ");
INSERT INTO kij_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kidamwa bukutagwala deli budamaisi bakalosi, e bogwa bakalosi kagimwalasi kaula paila yoku. ");
INSERT INTO kij_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kidamwa gala bukutagwala, e gala bakalosi, paila matauna tau ikaibiga kawala, ‘Gala bukugisaisi migigu kidamwa gala deli budami.’” ");
INSERT INTO kij_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yekobe ikaibiga, kawala, “Avaka paila lokuvigakaisi saina agu mmayuyu paila lokukwamitulaisi baisa matauna tau paila taitala budami tuvaila eisisu?” ");
INSERT INTO kij_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Matausina ivitakaulokaisi, kawasi, “Paila matauna tau saina ikatukoyaimasi baisa paila yakamaisi deli veimaiasi, kawala, ‘Ki, tumamiga eisisu wala, e sitana taitala budami eisisu?’ Yakamaisi ibodi bakamapwaisi la katupoi. E ammakawalaga kidamwa bakanikolaisi baisa, paila matauna eilukwaimasi mwada deli budamaisi bakamaisi?” ");
INSERT INTO kij_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda ikaibiga baisa tamala, kawala, “Ka, kuwitali gwadi deli yeigu. Baisa tuta bakatokaiasi bakalosi e gala taitala yakidasi biboda molusaula kala mwau e bikaliga. ");
INSERT INTO kij_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Yeigu atugwali ulo momova titoulegu, e yoku bukusakaigu agu pakula paila matauna gwadi. Ka, kidamwa gala bakaimali matauna baisa yoku deli bulogala bwaina, e yeigu goli tuta komwaidona bakau pikolela. ");
INSERT INTO kij_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","E ka, kidamwa bakatulotulasi saina kaduwonaku, kala yam bogwa bakalilouyusi bakalosi e bogwa bakakaimilavausi tuta baisa.” ");
INSERT INTO kij_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tumasi ikaibiga baisa matausina, kawala, “Kidamwa makawala, e bwaina wala. Bukukwauwaisi kaiuwala da valusi deli yokomi, kusewoyaisi omi baiki, bukuvigakaisi mi bobwailila baisa tokwaraiwaga matauna, ka, seyakwa sitana e kitorina, sita dibirera deli saida. ");
INSERT INTO kij_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Bukukwauwaisi tuvaila mani guliyuwela paila kaina bukukwaimalaisi magulosina mani avaka eikaimalaisi omi baiki. Kainaga eisulasi baisa. ");
INSERT INTO kij_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kulosi deli budami, nanakwa bukulosi e kukwaimilavausi. ");
INSERT INTO kij_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ibodi Yaubada Topeuligaga bivigaki matauna tau binokapisaimi e bisakaimi Beniamina deli budami taiyuwela bikaimili baisa yokomi. E yeigu ammakawagu? Ke, kidamwa bakitumou litugwa, desi wala bakitumou matausina.” ");
INSERT INTO kij_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Mapaila ikauwaisi bobwailila deli mani ikigolaisi e ilokaiasi Itipita deli Beniamina. E ovalu iyoumatilasi baisa Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Avai tuta Yosepa igisi Beniamina deli matausina ikaibiga baisa la tosikwawa, “Matausina igau bilosi ikamsi deli yeigu ilalavi, mapaila kukwatumati natana mauna kuvakapuli.” ");
INSERT INTO kij_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","E touwata ivagi makawala kala karaiwaga e ilau matausina ola bwala Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Bogwa makawala ilau ola bwala, mitaga matausina ikokolasi ininanamsasi, kawasi, “Yakidasi eimaiyaidasi baisa paila mani makwaisina omitibogwa eikaimalaisi oda baikisi. Ka, bogwa biwaidasi bikauwaisi da maunasi e bivigakaidasi la towotetila.” ");
INSERT INTO kij_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Mapaila wa kabosusuvi ikaibigasi baisa tosikwawa, ");
INSERT INTO kij_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Mwa! Tomwaya, sita bukunokapisaimasi. Ka, malilouna liloutala lakamaisi baisa kagimwalasi kaula. ");
INSERT INTO kij_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Wa keda kabudaisi ma kabosikaiwasi kaulaimwaisi ma baikisi taitala taitala ibani la mani owodola la baiki. Ka, komwaidomasi wala kakaimilivauwaisi makwaisina mani baisa yoku. ");
INSERT INTO kij_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Deli lakamaiyaisi tuvaila mani bakagimwalasi kaula, mitaga gala kanikolaisi availa eisaivau mani oma baikisi.” ");
INSERT INTO kij_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Towotetila ikaibiga, kawala, “Gala bukuninayuwasi, e gala bukukokolasi. Kainaga mi Yaubada, matauwena tumami la Yaubada, eisaivau makwaina mani omi baiki paila yokomi. Yeigu bogwa labani mapula witi.” Oluvi ivakouli Simioni iuyoki matausina. ");
INSERT INTO kij_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Touwata matauna ivakouli matausina isuvisi wa bwala. Isaiki sopi biwinaisi kaikesi, e ivakoma si mauna. ");
INSERT INTO kij_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ikatubiasaisi si bobwailila paila bisakaisi Yosepa lalavi, tutala bimakaia, paila bogwa ilukwaisi matausina kidamwa bikamsi deli matauna. ");
INSERT INTO kij_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","E avai tuta Yosepa iviloubusi wa bwala, ikauwaisi si bobwailila makwaisina e isuvisi wa bwala ikavaginasi opwaipwaia. ");
INSERT INTO kij_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yosepa ikatupoi paila si kaisisu, e oluvi ikaibiga, kawala, “Lokulukwaigusi paila tumami, e ammakawala matauna, ke, matauna igau tomomova deli ibwaina wala ke?” ");
INSERT INTO kij_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ivitakaulokaisi matauna, kawasi, “E makawala, tumamaisi, matauwena m touwata goli, igau wala tomomova, e ibwaina wala.” E ikavaginasi omatala. ");
INSERT INTO kij_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tutala Yosepa bogwa igisi bodala Beniamina ikaibiga kawala, “Ki budami kasusu lokulukwaigusi, mtonala ke? Yaubada binokapisaim latugu.” ");
INSERT INTO kij_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","E Yosepa isilavi nanakwa paila saina ikalisau saina kakapisigaga lopola paila bodala. Katitaikina bivalam mapaila ila matabudona la kabomasisi e ivalam. ");
INSERT INTO kij_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Bogwa ikiwisa e isunapula ima ipeuloki wala iluki biyeyasi kaula. ");
INSERT INTO kij_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kwaitala tebeli paila Yosepa e kwaiyuwela paila tuwʹala. Mina Itipita itavileiyaisi si kamkwam gala bikamsi deli mina Iberu paila uula idokaisi gala wala avaka dimlesi. ");
INSERT INTO kij_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Tuwʹala isilaisi mitasi ikoulakaiwaisi Yosepa, ikaraiwogi isidadelisi makawala kasi taitu kuluta ilaga kasusu. Tutala igisaisi si kaisisu makawala saina iyowa luposi igisamapusi. ");
INSERT INTO kij_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kaula iyeyasi paila matausina metoya Yosepa ola tebeli e Beniamina isivalimasi eiyeyasi ikalisau kala bawa kʹasi matausina tuwʹala. Mapaila ikamkwamsi deli imomomsi igau tatoula wala imommatasi. ");
INSERT INTO kij_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yosepa ikaraiwogi la tosikwawa kawala, “Kutavili matausina tauwau kasi witi bila osi baiki kuvakasau kala siniveka makawala gagabila matausina bikeulasi. Deli taitala taitala la mani kusewoya odabala la baiki. ");
INSERT INTO kij_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","E kusailiga agu viga siliba kwelakavikavila olumoulela la baiki budasi kasusu, kuseigoli deli la mani paila kala witi.” E tosikwawa ivagi makawala bogwa eiluki. ");
INSERT INTO kij_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kaukwau pikekita tuwʹala itokaiasi ilokaiasi osi keda deli si ase. ");
INSERT INTO kij_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Avai tuta bogwa leilosi sitana wala kala kaduwonaku metoya ovalu, e Yosepa iluki la tosikwawa, kawala, “Kunanakwa kuyeikuli matausina tauwau. Avai tuta bukusakaila matausina, bukukwatupoi kawam, ‘Avaka paila lokumapwaisi gaga kaimapula bwaina? ");
INSERT INTO kij_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Avaka paila lokuveilauwaisi ulo tokwaraiwaga kala viga siliba kwelakavikavila? Paila kwelatinidesi makwelana bimomom deli makwelana wala eivigaki la kabovitoubobuta. Lokuvagaisi mi sula saina gaga.’” ");
INSERT INTO kij_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tutala la tosikwawa ibani matausina ikaibigivau wala mabigasina biga. ");
INSERT INTO kij_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Mitaga ivitakaulokaisi matauna, kawasi, “Mwa! Tomwaya, avaka m nanamsa paila lokulivali makawala baisa? Yakamaisi kalivalasi biga katotila saina peula, mokwitala gala kavagaisi avai vavagi makawala. ");
INSERT INTO kij_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kunikoli lakakaimalaisi metoya Kenani baisa yoku makwaisina mani lakabanaisi odabala ma baikisi. Avaka paila bakaveilausi siliba kaina goula metoya baisa m tokwaraiwaga ola bwala? ");
INSERT INTO kij_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ka tomwaya, kidamwa taitala yakamaisi bitabanaisi leiyosi makwelana, ibodi bikaliga wala, e kesalaga yakamaisi bakasisuaisi m ula yakamaisi.” ");
INSERT INTO kij_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ikaibiga, kawala, “Baisa bwaina, mitaga kwaitala vavagi, taitala wala availa eikau viga, matauna wala bavigaki ulo ula, e kesalaga yokomi bwaina wala bukulosi.” ");
INSERT INTO kij_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mapaila ivabwaisi si baiki opwaipwaia e taitala taitala iulaim la baiki. ");
INSERT INTO kij_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Yosepa la tosikwawa kwemanum inainevi, ivitouula baisa molitomoya e ivigimkulovi baisa kasusu, e bogwa ibani viga makwelana kwelakavikavila baisa Beniamina ola baiki. ");
INSERT INTO kij_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tuwʹala ikisaisi kasi kwama deli si ninamwau e ikedidagaisi si baiki otapwala mauna e ikeiitasi ovilouveka. ");
INSERT INTO kij_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","E avai tuta Yuda deli budala ikeiitasi imaisi Yosepa ola bwala e matauna isisu wala baisa, e mapaila ikavaginasi baisa matauna. ");
INSERT INTO kij_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosepa iluki tuwʹala, kawala, “Avaka baisa kuuvagaisi? Ki gala kunikolaisi taitala tokwaraiwaga makawala yeigu tovitoubobuta wala e gagabila wala babanaimi?” ");
INSERT INTO kij_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","E Yuda ivitakauloki matauna kawala, “Tomwaya, avaka bakalivalasi baisa yoku? Ammakawalaga gagabila bakakamitulaimasi? E ammakawala gagabila bakavitulokaimsi mwada tokwamokwita yakamaisi? Paila Yaubada bogwa eiulaim ma sulasi. E komwaidomasi baisa tuta kasisuaisi m ula e gala wala kalamwaleta matauna eibanaisi viga ola baiki.” ");
INSERT INTO kij_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yosepa ivitakauloki, kawala, “Tauwau. Yeigu gala igagabila bavagi makawala baisa yokomi. Mitaga matauna wala eikau viga makwelana, kalamwaleta matauna wala ulo ula e komwaidomiga bukukweiitasi deli bulogami bwaina baisa tumami.” ");
INSERT INTO kij_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda bogwa ilokaia Yosepa e ilivala, kawala, “Mwa! Guyau, kutagwala sitana bitabigatona bibwaina. Gala bukugibuluwaigu, paila yoku makawala matauna uula guyau Itipita. ");
INSERT INTO kij_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tomwaya, lokukwatupoiyaimasi, ‘Ki, isim tumami kaina taitala budami?’ ");
INSERT INTO kij_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kamapwaisi, ‘E tumamaisi isisu, matauna bogwa eitomoya e budamaisi kasusu. Tutala tumamaisi bogwa eitomoya e eiuni matauna. E matauna tuwala bogwa eikaliga. Kasitaiyu inasi natana wala e matauna wala eikesa isisu tomomova. Ka, tamala isaiki bobonala mokwita baisa magudina.’ ");
INSERT INTO kij_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tomwaya, ka - lokulukwaimasi bakamaiyaisi matauna baisa e mwada bukugisi matauna. ");
INSERT INTO kij_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","E yakamaisi lakalukwaimsi kidamwa gwadi matauna gala wala ibodi bisilavi tamala. Paila kidamwa bisilavi tamala igau tamala bikaliga. ");
INSERT INTO kij_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Yoku lokukwaibiga kawam, ‘Kidamwaga budami gala deli bukumaisi, gala wala bukugisaisi migigu tuvaila.’ ");
INSERT INTO kij_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Tuta makwaina lakakeiitasi baisa tamamasi kalukwaisi matauna avaka bogwa lokulivala. ");
INSERT INTO kij_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Mapaila ilukwaimasi tuvaila mwada bakakaimilavausi baisa, bakagimwalasi sitana kama witisi. ");
INSERT INTO kij_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kavitakaulokaisi, kawamasi, ‘Gala igagabila bakalosi. Yakamaisi gala ibodi bakaviloubusisi omatala matauna tau, kidamwa gala deli bodamasi kasusu bakawaisi. Igagabila wala bakawaisi kidamwa bodamasi kasusu deli bakalosi.’ ");
INSERT INTO kij_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","E tamamasi ilukwaimasi, kawala, ‘Kunikolaisi kidamwa ulo kwava Retieli eiuni taiyu wala tauwau. ");
INSERT INTO kij_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Taitala matausina bogwa eitamwau. Adoki matauna bogwa wala eiyogagaisi mauna olawodila einikaisi, e mapaila gala lagisi matauna igau tutala eisilavaigu e lagaila. ");
INSERT INTO kij_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kidamwa bukulauwaisi matauwena kasusu metoya baisa yeigu lagaila, adoki kaina kwaitala vavagi mwau bikaloubusi baisa matauna. E ka bukuvigakaigusi nanogu kala mwau sainela e bogwa bikimataigu, paila ka, bogwa latomoya.’” ");
INSERT INTO kij_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","E Yuda tuvaila ilivala, kawala, “E tomwaya ka, kidamwa bakeiita baisa tamagu gala deli matauna gwadi, e avai tuta bigisi kidamwa matauna gwadi gala deli yeigu, e bogwa bikaliga. Paila tomoya matauna isisu tomomova paila uula wala magudina eisaiki bobonala. E kidamwa bakayomwauwaisi nanola tomoya makawala, e mwau makwaina bogwala bikimati matauna, paila bogwa eitomoya. ");
INSERT INTO kij_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","E ka, tuvaila, bogwa laluki tamagu mwada agu pakula matauna gwadi. Bogwa laluki matauna kidamwa gala bakaimili magudina gwadi baisa matauna, e yeigu goli bakeula agu pakula wala ogu tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","E tomwaya, ka, tuta baisa basim wala baisa bukuvigakaigu m ula kaimapula magudina. Bukutugwali matauna bikeiita deli tuwʹala. ");
INSERT INTO kij_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ammakawala bakeiita baisa tamagu kidamwa matauna gwadi gala deli yeigu? Gala goli gagabila bagisi mwau makwaina bisunapula baisa tamagu.” ");
INSERT INTO kij_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","E Yosepa gala wala imomwa gala gagabila bikatupwani kala lumkola omitasi la touwata mapaila ikaraiwogi matausina komwaidosi wala bisunapulasi metoya ola bwala. Gala availa deli matausina e iyomitali titoulela baisa tuwʹala. ");
INSERT INTO kij_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Matauna iuvalam wala iwaki mota deli kaigala kaigaveka. E valu ikubila paila la valam, e mina Itipita bogwa ilegasi valam, e bulogala makwaina iuyokaisi ambaisa guyoula Itipita la katuposula. ");
INSERT INTO kij_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosepa ilivala baisa tuwʹala, kawala, “Tauwau yeigu Yosepa, e kwalaisiga, tamagu eisisu wala tomomova ke?” Mitaga matutona tuwʹala ilagaisi makawala, saina itakala ninasi deli goli kasi kokola e gala wala imapwaisi la katupoi budasi. ");
INSERT INTO kij_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Mapaila Yosepa ilivala baisa matausina, kawala, “Segwaia, anigadaimi kutomadasi kumaisi katitaikinegu.” E bogwa ivagaisi makawala e ilivala, kawala, “Tauwau, mayeigula budami Yosepa, matauna lokugimolaisi baisa mina Itipita. ");
INSERT INTO kij_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tauwau, tuta baisa gala bukunokubukubusi deli bimwau ninami kaina bitabinakaimi yokomi titoulemi mi sula paila lokugimolaigusi lama baisa. Avaka kala kamokwita baisa ka - Yaubada bogwa leiwitalibogwaigu e oluviga yokomi, paila bikoli bidubadu tomota si momova. ");
INSERT INTO kij_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","E baisa kwaiyuwela wala taitu molusaula valu olumoulela, e igau eisisu kwailima tuvaila taitu bima, makwaisina gala kabobagula kaina kabotayoyuwa. ");
INSERT INTO kij_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yaubada bogwa iwitalibogwaigu oluviga yokomi, paila bikolaimi makawala baisa saina kaboyowalula, deli bigisi mokwita yokomi deli tubumia komwaidomi bukusisuaisi e gala bukutamwausi. ");
INSERT INTO kij_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Mapaila baisa kala kamokwita wala. Gala yokomi okuwitalaigusi lama baisa, mitaga Yaubada nanola makawala. Yaubada matauna isailigu guyau la tosikwawa komwaidosi kasi toveka. E yeigu aguyoi valu makwaina viloumwaidona. Ka yeigu atokwaraiwaga viloumwaidona Itipita. ");
INSERT INTO kij_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Kunanakwasi kukweiitasi baisa tamagu e kulukwaisi matauna kawami, ‘Latum Yosepa ikaibiga, Yaubada bogwa ivigakaigu batokwaraiwaga viloumwaidona Itipita. Nani bukumakaiagusi. ");
INSERT INTO kij_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Bukubudaisi mi valu mapilana Goseni, e baisa katitaikinegu bukusilaisi. Yokomi deli goli litumia toyo tubumia, mi sipi, mi gota, mi bulumakau deli goli komwaidona wala avaka avaka lokuiyosisi kumaiyaisi. ");
INSERT INTO kij_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kidamwa bukusisuaisi Goseni e gagabila bayamataimi. Paila igau kwailima taitu bima molusaula bisisu wala, e yeigu gala wala magigu yokomi deli veimia e tuvaila mi mauna bukubodasi mwau paila molu.’” ");
INSERT INTO kij_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","E Yosepa isetuwoli la bigatona, kawala, “Lagaila komwaidona yokomi, deli goli yoku Beniamina, lokugisaigusi yeigu mokwita wala Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kulosi kulukwaisi tamagu bulogala ulo guyau mapilana Itipita, deli kulukwaisi matauna vavagi komwaidona avaka bogwa kugisaisi. Deli kunanakwasi kumiakaigusi tamagu sitana bagisi.” ");
INSERT INTO kij_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","E ikaipapi bodala Beniamina ivitouula ivalam, e Beniamina deli ivalam matutona tuwala ikaipapi matauna. ");
INSERT INTO kij_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","E igau wala iuvalam e ikaipapi tuwʹala taitala taitala iviyuwoli matausina. E bogwa eisimlasi valam e tuwʹala ibigatonasi deli matauna. ");
INSERT INTO kij_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","E bulogala bogwa iviloubusi ovilouguyau kidamwa Yosepa tuwʹala bogwa leimaisi, e guyau deli la touwata saina imwasawasi. ");
INSERT INTO kij_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","E iluki Yosepa, kawala, “Ka, kuluki tuwamwa bididagaisi si mauna e bikeiitasi osi valu Kenani. ");
INSERT INTO kij_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","E ibodi bilukwaisi tumasi deli litusia komwaidona bikovaluisi bimaisi baisa. E yeigu basaiki bulukumitabwaila olopola Itipita, e bogwa bibodi komwaidosi matausina paila bisilaisi baisa. ");
INSERT INTO kij_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","E tuvaila bukuluki bikauwaisi waga kaibibiu metoya Itipita kidamwa bididagaisi si kukova, e litusia gudikikekita, e deli goli tumasi bididagaisi bimaiyaisi. ");
INSERT INTO kij_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Gala binokubukubusi paila biligaiwaisi komwaidona avaka avaka si guguwa, paila bogwa bakaimapu basaiki guguwala Itipita saina bwainigaga bivigakaisi si guguwa.” ");
INSERT INTO kij_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","E Yekobe litula ivagaisi avaka eiluki matausina. Yosepa isaiki matausina waga kaibibiu avaka bogwa guyau eikaraiwogi, deli goli kasi kalaga. ");
INSERT INTO kij_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Deli goli isaiki matausina kasi karekwa paila si katulova, mitaga isaiki Beniamina lakatutolu siliba e deli yalima karekwa paila la katulova. ");
INSERT INTO kij_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Iwitali paila tamala naluwotala ase otupwasi ikauwaisi guguwala Itipita kweminibwaita, deli naluwotala ase tuvaila otupwasi ikauwaisi witi, beredi, deli goli avai kaula avai kaula paila kasi kalaga. ");
INSERT INTO kij_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","E Yosepa iwitali tuwʹala bilosi mitaga tutala bisilavaisi ikatululuti matausina, kawala, “Gala bukugibuluwasi kaina bukuvayesisi wa keda.” ");
INSERT INTO kij_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Matausina isilavaisi Itipita ikaimilavausi osi valu baisa tumasi mapilana Kenani. ");
INSERT INTO kij_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","E matausina ilukwaisi tumasi, kawasi, “Yosepa isisu wala tomomova. Matauna eitokwaraiwaga viloumwaidona Itipita.” Yekobe iyowa lopola sainela, saina itutu nanola e itom wala, gala avaka gagabila bilivali, paila gala gagabila bidubumi matausina si biga. ");
INSERT INTO kij_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mapaila matausina ilukwaisi tumasi komwaidona avaka avaka Yosepa leiluki matausina, e Yekobe eigisi makaisina waga kaibibiu Yosepa leiwitali paila bididagaisi matausina bilauwaisi Itipita. E mapaila Yekobe italapula nanola. ");
INSERT INTO kij_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","E Yekobe ikaibiga, kawala, “Wo, latugu Yosepa tomomova wala isisu. Gala magigu balagi avaka tuvaila. Ibodaigu wala yeigu tomomova ikugwa bala agisi matauna, e oluviga bakaliga.” ");
INSERT INTO kij_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yekobe bogwa ikoululuvi avaka avaka iyosi metoya ola kaisisu, e ilosiga Biasiba, e baisa igabu mimilisi lula paila Yaubada, matauna tamala Aisake la Yaubada. ");
INSERT INTO kij_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Yaubada ilivala baisa matauna metoya okilisala wa bogi, e idou matauna kawala, “Yekobe! Yekobʹo!” E matauna ivitakaula, kawala, “E mayeigu ka!” ");
INSERT INTO kij_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","E ivitakaula, kawala, “Yeigu Yaubada, yeigula tamam la Yaubada. Taga kukokola bukula Itipita, paila bavigaki tubumwa bidalasi metoya mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yeigu deli yoku bitala Itipita, e tubumwa bakaimilivau bimaisi mapilana valu. Yosepa bisisiaim wala om tuta kaliga.” ");
INSERT INTO kij_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","E Yekobe bogwa isilavi metoya Biasiba. Litula ilupaisi matauna ivisiyeilisi waga kaibibiu, e si kukova deli litusia gudikikekita deli isilasi okaibibiu, makaisina avaka guyoula Itipita bogwa eiwitali. ");
INSERT INTO kij_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Matausina ikauwaisi si mauna, si vavagi avaka avaka iyosisi mapilana Kenani, e ilosi Itipita. Yekobe ilau deli tubula komwaidosi. ");
INSERT INTO kij_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ikau komwaidosi litula deli litusia, tauwau deli vivila. ");
INSERT INTO kij_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Mabudona Yekobe litula deli tubula eilosi deli matauna mapilana Itipita, la kuluta tau Rubeni, ");
INSERT INTO kij_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","e Rubeni litula. Anoki, Palu, Esironi, deli Kami. ");
INSERT INTO kij_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simioni deli litula Yemweli, Yamini, Owadi, Yakini, Sowara, deli Sauli, matauna inala natana vilela Kenani. ");
INSERT INTO kij_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Libai deli litula. Gerisoni, Kowati, deli Merari. ");
INSERT INTO kij_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda deli litula. Sela, Peresi, deli Sira. (Tuvaila Yuda litula, Eri, sola Onani, matausina eikaligasi mapilana Kenani.) Peresi litula Esironi sola Amli. ");
INSERT INTO kij_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka deli litula. Tola, Puwa, Yasuba, deli Simroni. ");
INSERT INTO kij_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuloni deli litula. Seredi, Eloni, Yaleeli. ");
INSERT INTO kij_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Matausina Lea sola Yekobe litusia tauwau eiunaisi mapilana Mesopotemia, deli goli natana litusi yagala Dina. Komwaidosi wala Yekobe dalela metoya baisa Lea, kasi bawa tailuwotolu taitolu. ");
INSERT INTO kij_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gada deli litula. Seponi, Agi, Suni, Esiboni, Iri, Arodi, deli Areli. ");
INSERT INTO kij_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asera deli litula. Imna, Isiva, Isivi, Beria, deli goli lusita Serai, Beria litula matausina Ebera sola Malikieli. ");
INSERT INTO kij_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Matausina tailuwotala tailima taitala komwaidosi wala dalela Yekobe metoya baisa Silipa, minana ula Lebani eisaiki latula Lea. ");
INSERT INTO kij_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yekobe la kwava Retieli iuni litusia taiyu tauwau. yagasi, Yosepa sola Beniamina. ");
INSERT INTO kij_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Olopola Itipita Yosepa la kwava Asinata iuni litusia taiyu. Manasa sola Epereim, minana Potipera latula; matauna tolula olopola Eliopolisi. ");
INSERT INTO kij_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Beniamina litula yagasi, Bela, Bekeri, Asibeli, Gera, Nemani, Ei, Rosi, Mpim, Upim, deli Adi. ");
INSERT INTO kij_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Matausina tailuwotala taivasi Yekobe dalela metoya baisa Retieli. ");
INSERT INTO kij_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dani sola latula Usim. ");
INSERT INTO kij_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napitalai deli litula; Yaseeli, Guni, Yesera, deli Silem. ");
INSERT INTO kij_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Matausina tailima taiyu tubula Yekobe metoya baisa Bilia, minana ula Lebani eisaiki latula Retieli. ");
INSERT INTO kij_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Isonukulasi kasi bawa tubula Yekobe ilosi baisa Itipita kasi bawa luwolima luwotala tailima taitala. Mitaga gala deli ikalawaisi litula si kukova. ");
INSERT INTO kij_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yosepa eiuni litula taiyu tutala isisu mapilana Itipita. E matausina kasitaivasi ikatumkulovaisi iboda tailuwolima tailuwoyu kala bawa Yekobe dalela leilosi mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yekobe iwitali Yuda bikugwai bila binigadi Yosepa bibodi matausina mapilana Goseni. Avai tuta iviloubusisi, ");
INSERT INTO kij_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosepa isila ola waga kaibibiu ila Goseni paila bibodi tamala. Avai tuta ibodasi, Yosepa igigi tamala okaiyola, e ivalam tuta kaduwonaku. ");
INSERT INTO kij_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yekobe ilivala, kawala, “Bogwa ibodi bakaliga baisa tuta, paila bogwa lagisaim deli bogwa lanikolaim yoku tomomova lokusisu.” ");
INSERT INTO kij_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","E oluvi Yosepa ikaibiga baisa tuwʹala deli tamala toyo la ula komwaidona, kawala, “Ibodi yeigu bala baluki guyau paila tuwagwa deli tamagu sola la ula matausina eisisuaisi Kenani, e bogwa imakaiagusi baisa. ");
INSERT INTO kij_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","E baluki kidamwa yokomi komwaidomi toyamata sipi deli bulumakau toyamata, e kidamwa bogwa lokumaiyaisi mayuwosina mi sipi mi bulumakau deli avaka mi guguwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Avai tuta guyau bikatupoiyaimi avaka kuuvagaisi, ");
INSERT INTO kij_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","e kululuwaisi bukulukwaisi kawami, ‘Yakamaisi toyamata wala sipi deli bulumakau tuta komwaidona, makawala tubumaiasi eivagaisi.’ E binanamsa bitugwalaimi bukusilaisi okubilela Goseni.” E Yosepa leilivala makawala, paila uula tuta komwaidona mina Itipita ikasilalaisi komwaidosi toyamata sipi. ");
INSERT INTO kij_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","E Yosepa ilau wala tuwʹala tailima bilokaiasi guyau. E Yosepa ikaibiga baisa guyau, kawala, “Tamagu deli tuwagwa bogwa leimaisi metoyasi mapilana Kenani, deli si bulumakau, si sipi, deli avaka avaka si guguwa komwaidona. E leimaisi okubilela Goseni isilaisi.” ");
INSERT INTO kij_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Oluvi iyomitali tuwʹala baisa guyau. ");
INSERT INTO kij_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Guyau ikatupoi matausina, kawala, “Avaka mi paisewa?” Matausina ivitakaulasi ikaibigasi, kawasi, “Guyau, yakamaisi toyamata sipi, makawala tubumaiasi eivagaisi. ");
INSERT INTO kij_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Lakamaisi mwada bakamili valusi mapilana valu, paila uula mapilana valu Kenani molusaula eikaligiaki sainela deli goli mayuwona ma sipisi gala isim kasi mnumonu. Mapaila tuta baisa bakanigadaimsi mwada bukusakaimasi mapilana valu Goseni, paila bakasilaisi.” ");
INSERT INTO kij_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","E guyau iluki Yosepa ikaibiga, kawala, “Ka, tuta baisa tamam deli tuwamwa bogwa leimaisi, ");
INSERT INTO kij_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","e mapilana viluwela Itipita baisa si vavagi wala. Ibodi wala bukusaiki matausina paila bibudaisi si valu mapilana Goseni, paila makubilana bulukumalala. Deli kidamwaga avai tauwau topapeula metoya oluwalaisi matausina, e kuvigaki matausina biyamataisi mayuwona ulo mauna tatougu.” ");
INSERT INTO kij_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","E Yosepa imai tamala Yekobe, e iyomitali matauna baisa guyau. E Yekobe isaiki guyau kala bigabwaila. ");
INSERT INTO kij_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","E oluvi guyau ikatupoi matauna, kawala, “Kwaivila kam taitu?” ");
INSERT INTO kij_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yekobe ivitakauloki, kawala, “Ulo tuta metoya ogu tavina bogwa leima kala vigimkovila makawala lakatutala kweluwotolu taitu. Taitu makwaisina gala kwebobawa, mitaga deli mwau olopola lasisu. Mitaga gala makawala taitu makwaisina kwewonaku tubugwa osi tuta tavina.” ");
INSERT INTO kij_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yekobe ibigibwailitulai guyau e isilavi. ");
INSERT INTO kij_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","E Yosepa isaiki tamala deli tuwʹala paila bibudaisi si valu olopola Itipita, isaiki matausina si valu mapilana bulukumalala katitaikinela valu mapilana Ramesa, avaka bogwa guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","E Yosepa ivakoma tamala, tuwʹala, deli goli availa availa tamala eivauli bila itobu magudisina gudikikekita. ");
INSERT INTO kij_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Molusaula saina vakaigaga e gala kaula isisu ambaisa. E tomotala mapilana Itipita deli Kenani iyomami uwosi deli kasi molu. ");
INSERT INTO kij_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tutala igimolaisi kasi witi, Yosepa ikatuyouli mani komwaidona ilau wa ligisa. ");
INSERT INTO kij_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tutala mina Itipita deli mina Kenani iyomadaisi si mani komwaidona, oluvi mina Itipita imakaiasi Yosepa ilivalasi kawasi, “Kusakaimasi kaula. Taga kuyovikidadaimasi igau bakakaligasi. Nani kuwonanaimasi avaka sitana bakakamsi! Ma manisi bogwa wala leiwokuva!” ");
INSERT INTO kij_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosepa ivitakauloki ikaibiga, kawala, “Kidamwa mi mani bogwa leiwokuva - e desi wala bukumaiyaisi mi mauna e basakaimi kaula mapula minasina.” ");
INSERT INTO kij_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Mapaila si mauna komwaidona imiakaisi Yosepa e isaiki matausina kaula baisa mapula si wosa, sipi, gota, bulumakau deli ase komwaidona. Wa taitu makwaina isaiki matausina kaula paila mapula si mauna. ");
INSERT INTO kij_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","E taitu oluvi imakaiasi matauna ilukwaisi, kawasi, “Ka tomwaya, yakamaisi gala wala avaka eisisu uula bakakatuyumalaisi kwaitala vavagi. Ma manisi komwaidona bogwa leiwokuva, e ma maunasi lakasakaimsi baisa m vavagi. E gala wala avaka kesala isisu bakasakaimsi, mesinaku wala wowomasi e deli ma balekusi kesala. ");
INSERT INTO kij_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Gala bukutagwala bakakaligasi! Kuwonana kuvagi sitana avaka paila yakamaisi. Gala bukuvigaki ma balekusi igau biviloububu wala. Bukugimolaimasi deli goli ma kwabilasi baisa mapula paila kaula. Ibodi guyau bivigakaimasi la ula, deli ma balekusi biyosi paila titoulela. Bukusakaimasi witi, paila bikamovaimasi, e sitanaga bakavaulasi oma bagulasi.” ");
INSERT INTO kij_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","E Yosepa imapu komwaidona kubilela Itipita paila la guyau. Paila uula molusaula sainela, e gala kwaitala vavagi isisu mesinaku wala ibodi bigimolaisi si kwabila. E mapaila komwaidona makubilasina ivigakaisi guyau la kwabila. ");
INSERT INTO kij_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","E Yosepa iyosi komwaidosi mina Itipita metoya kabulotala ila kabuluyuwela e ivigaki ula wala viloumwaidona. ");
INSERT INTO kij_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mesinaku wala tolula si kwabila gala bigimoli. Matausinaga gala ibodi bigimwalasi paila uula si guyau isisaiki taitala taitala tolula la mani paila la katuboyuva. ");
INSERT INTO kij_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","E Yosepa iluki tomota, kawala, “Tauwau, bogwa lagimolaimi deli goli mi kwabila e lasaiki guyau. Ka, baisa sitana bukukwauwaisi kami yagogu bukuvalaisi wala omi buyagu. ");
INSERT INTO kij_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","E igau tutala tayoyuwa bukukougugulaisi komwaidona witi gulolima, e gulotala bukusakaisi guyau. Kesalaga bukuyosisi kami yagogu e tuvaila kʹami titoulemi deli veimia.” ");
INSERT INTO kij_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","E ivitakaulasi, kawasi, “Tomwaya, bogwala lokukolaimasi. Bogwa kumitukwaiyaimasi. Ka, yakamaisi bogwa bakawotitalaisi guyau.” ");
INSERT INTO kij_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","E Yosepa ivigaki kasi karaiwaga mina Itipita kidamwa osi tayoyuwa witi bikougugulaisi gulolima, e gulotala bisakaisi guyau. E baisa makawala eiuvagaisi, ee, leimaga tuta lagaila. Mesinaku wala tolula gala bigimolaisi si kwabila baisa guyau. ");
INSERT INTO kij_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","E mina Isireli ibudaisi valu opapala Itipita wa kwabila Goseni, e baisa ibanaisi guguwa bidubadu deli idalasi. ");
INSERT INTO kij_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yekobe isisu olopola Itipita taitu kala bawa kweluwotala kwailima kwaiyu. E ikatumguliki iboda kwelakatutala kweluwovasi kwailima kwaiyu kala taitu. ");
INSERT INTO kij_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","E avai tuta la tuta bogwa eivakatitaikina paila bikaliga, e idou latula Yosepa iluki matauna, kawala, “Kusaili yamam okwaipiapagu ogu kwaidawaga e kulukwaigu biga katotila. Ka, gala bukubakwaigu Itipita. ");
INSERT INTO kij_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Taga magigu bukubakwaigu ambaisa tumagwa eikanakaisi. E bukukwauwaigu bukusunupuloiyaigu metoya Itipita e bukubakwaigu ambaisa tumagwa eibubakwaisi.” E Yosepa ivitakauloki kawala, “Bogwa bavagi avaka lokulukwaigu.” ");
INSERT INTO kij_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","E Yekobe iluki, kawala, “Kulivala biga katotila kidamwa bogwa bukuvagi makawala.” E Yosepa bogwa ikatotila, e Yekobe ikabwaili matauna metoya ola kabokanukwenu. ");
INSERT INTO kij_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Igau oluvi Yosepa ilagi kidamwa tamala ikatoula. Mapaila ivakouli litula tauwau taiyu Manasa sola Epereim, e ilosi bibodaisi Yekobe. ");
INSERT INTO kij_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tutala Yekobe ilagi Yosepa bogwa leima bibodi, e mapaila ipeuloki wala isimalaula okabala. ");
INSERT INTO kij_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yekobe ikaibiga baisa Yosepa, kawala, “Guyau Topeuligaga iyoumatila baisa yeigu mapilana Lusi olumoulela mapilana Kenani e ikabwailigu. ");
INSERT INTO kij_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ilukwaigu, kawala, ‘Igau basakaim litumwa bidubadu e dalem bidalasi bidubadu mina watanawa. Basaiki mapilana valu baisa tubumwa kidamwa bivigakaisi kasi bigukeya gala biwokuva, bikanigaga.’” ");
INSERT INTO kij_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yekobe tuvaila ikaibiga, kawala, “Mwa, Yosepa! Litumwa matausina taiyu eikaloubusisi baisa yoku mapilana Itipita oluviga lama - ka, matausina mwada bavigaki litugwa. Kasitaiyu Epereim sola Manasa bavigaki makawala litugwa Rubeni sola Simioni, e bikeulasi kasi bigukeya metoya baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kidamwa bukubani tuvaila litumwa tauwau, matausina gala bavigaki litugwa. Matausina igau bikeulasi kasi bigukeya metoya baisa Epereim sola Manasa. ");
INSERT INTO kij_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Lavagi baisa paila uula inam Retieli. Ka, ulo ninamwau kwaiveka, paila eikaliga mapilana Kenani katitaikina Eparati, tutala ogu lilouyumila metoya mapilana Mesopotemia. E baisa goli labaku minana opapala kedala Eparati.” (Baisa tuta Eparati idokaisi yagala Bedeliem.) ");
INSERT INTO kij_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Avai tuta Yekobe igisi Yosepa litula, e ikatupoi, kawala, “Avai tauwau magudisina?” ");
INSERT INTO kij_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosepa ivitakauloki, kawala, “Matausina litugwa Yaubada bogwa isakaigu baisa mapilana Itipita.” Yekobe ikaibiga, kawala, “Kumiakaigu magudisina kidamwa basaiki kasi bigabwaila.” ");
INSERT INTO kij_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yekobe matala bogwa eidudubila paila bogwa eitomoya e gala bigisi bwaina. Yosepa imai litula baisa matauna e ikaipapi iviyuwoli magudisina. ");
INSERT INTO kij_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yekobe ikaibiga baisa Yosepa, kawala, “Adoki gala wala bagisaim avai tuta. Mitaga bogwa lagisaim e ka! - baisa tuta Yaubada bogwa itugwalaigu tuvaila bagisi litumwa.” ");
INSERT INTO kij_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mapaila Yosepa ilupi magudisina metoya Yekobe okwaitutula e ikavagina omatala tamala migila opwaipwaia. ");
INSERT INTO kij_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yosepa ivakouli Epereim isaili Yekobe ola kikiwama, e Manasa ola kakata. ");
INSERT INTO kij_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mitaga Yekobe yamala isobali isaili la kakata opwanetala Epereim mtona molagwadi e yamala kikiwama isaili opwanetala Manasa matauna molitomoya. ");
INSERT INTO kij_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","E Yekobe isaiki Yosepa kala bigabwaila. Kawala, “Yaubada, matauna eiwotitalaisi Eberaam deli Aisake, ibodi matauna Yaubada bimitukwaii gugwadi matausina. Yaubada eivakadaigu omitibogwa e lagaila. Ibodi matauna Yaubada bimitukwaii gugwadi matausina. ");
INSERT INTO kij_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Anelosi matauna eikolaigu e gala avai tuta basilagi. Ibodi anelosi matauna bimitukwaii gugwadi matausina. Ibodi bulogagu, e bulogasi tamagu Aisake deli tabugu Eberaam bikanigaga baisa ovalu watanawa metoya baisa gugwadi matausina. Ibodi bibanaisi litusia bidubadu e tubusia bidubadu.” ");
INSERT INTO kij_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yosepa ikaikai nanola tutala igisi tamala isaili yamala kakata opwanetala Epereim. Mapaila iyosi tamala yamala ibia metoya opwanetala Epereim mwada bisaili opwanetala Manasa. ");
INSERT INTO kij_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ikaibiga baisa tamala, kawala, “Tamagu, taga bukuvagi makawala. Ka, matauwena molitomoya. Ibodi bukusaili yamam kweyakakata opwanetala matauwena.” ");
INSERT INTO kij_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mitaga tamala ipaiki, kawala, “Ka, latugu, bogwala lanikoli. Manasa dalela bidalasi bimila tomota budoveka. Mitaga bodala tuta oluvi bikalisau tuwala e bodala dalela bidalasi saina bidugaga bimila tomota budovila buduvakaveka.” ");
INSERT INTO kij_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Mapaila yam makwaina isaiki kasi bigabwaila matausina, ikaibiga, kawala, “Avai tuta mina Isireli bilivalasi bigabwaila, bogwa bisailiusi yagami. Bikaibigasi kawasi, ‘Ibodi Yaubada bivigakaim makawala Epereim sola Manasa.’” E makawala wala Yekobe ivigaki Epereim ivakumgwa baisa Manasa. ");
INSERT INTO kij_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","E Yekobe ikaibiga baisa Yosepa, kawala, “Ka, kugisi - yeigu katitaikina bakaliga. Mitaga Yaubada bogwa bisikailim, e matauna bikaimilivauwaim bukula mapilana viloutabum. ");
INSERT INTO kij_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mapilawena Sekem basakaim, yoku wala, galaga basaiki tuwamwa. Mapilana saina kwekabinai pwaipwaia, avaka bogwa layouli metoya oyumasi mina Amora metoya ulo puluta toyo ulo kaiyala.” ");
INSERT INTO kij_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yekobe idau litula e ilivala, kawala, “Kusigugulasi gulitinidesi e balukwaimi paila avaka bivitolai tuta oluvi. ");
INSERT INTO kij_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Tauwau litula Yekobe, kumaisi gulitinidesi kulegasi. Bukulagaigusi yeigu tumami yagagu Isireli. ");
INSERT INTO kij_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Mwa, Rubeni. Yoku ulo kulutala aunibogwaim, e yoku wala ulo peula. Deli ulo kuluta yoku tutala igau otubovaugu. Yoku tomwamwasila deli goli topeula metoya oluwalaimi yokomi litugwa. ");
INSERT INTO kij_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Yoku makawala sakala bidumyelu, mitaga yoku gala kuvigakaim saina toveka. Paila yoku lokumisii minana ulo ula, minawena lavigaki ulo kwava, e makawala goli lokukwavi kam kwaboma titoulem. ");
INSERT INTO kij_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simioni sola bodala Libai oyumasi iyosisi si lewa e iyowaisi deli sesia. ");
INSERT INTO kij_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","E yeigu gala batoula deli matausina ikasilamsi, e gala basilala olumoulela sigugula makwaina. Paila ikatumataisi tomota deli kasi leiya, e ikatuuwolaisi bulumakau nammwala kaikesi paila bivigakaisi kasi yousokana. ");
INSERT INTO kij_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Akagagi si gibuluwa, paila saina togigasisi. E akagagi si gidaleiya paila uula saina toseputupwatula. Bayobutubutu matausina olopola valu Isireli komwaidona, e babutugigai matausina bibutusi wala oluwalaisi mina Isireli. ");
INSERT INTO kij_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Mwa, Yuda. Budamwa biyakawolaimsi. Bukuyosi kam tilaula okaiyosi. E budamwa bikavaginaimsi. ");
INSERT INTO kij_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda makawala laiyoni. Bikamati kala tau e bikeiita kala nobwala, bikanaki lopola yamala bivitukoli, bikanukwenu, e gala taitala biyobosi. ");
INSERT INTO kij_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda igau bikau gweguya kasi karaiwaga kabutuvitusila, e dalela tuta komwaidona biguyausi. Kabokwaraiwaga igau bimaiyaisi si urigubu, e bikavaginasi deli si tagwala baisa matauna. ");
INSERT INTO kij_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","E isikoli la ase osisila waini, makaina saina kaiminabwaita sainela, e iwina kala kakapula metoya tovala waini bweyani. ");
INSERT INTO kij_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matala ikulubuyavi ikalisau waini bweyanila, e kudula pupwakaula ikalisau nunu kala pupwakau. ");
INSERT INTO kij_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebuloni matauna tokulumata. Ola kawolawa baisa waga kaivakaveka si kabokota. La valu kaligeila ila itobu mapilana Saidoni. ");
INSERT INTO kij_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isaka gala bikalisau minana ase, minawena ikanuwalai makwaisina kabokaidodiga guguwa. ");
INSERT INTO kij_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Mitaga igigisi mapilana valu kabovaiwasi saina bwaina. E makubilana kwabila saina bwainigaga. Mapaila itapopula ikau la koni matauna ivigaki makawala taitala towotetila la koni. ");
INSERT INTO kij_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dani igau bitokwaraiwaga baisa la tomota. E Dani dalela makawala avai dala avai dala mina Isireli dalesi. ");
INSERT INTO kij_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","E Dani la bubunela makawala keiyuna kabala baisa osiusiula keda. E minana keiyuna nayayana kabala osiusiula keda. Minawena igau bigadi wosa kegadula kaikela, e availa matauna eisisu otapwala wosa bikapusi. ");
INSERT INTO kij_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“E Yaubada, mwa! Yeigu latutulaim wala m kwatumova. ");
INSERT INTO kij_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gada biyosisi wala matausina tolibulebu. Mitaga bogwa goli bitovila bibokavili matausina. ");
INSERT INTO kij_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asera ola bagula bikabinai bitaiyau matala kaula, makwaina kaula bibodi gweguya kʹasi. ");
INSERT INTO kij_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Napitalai matauna makawala natana dia bulukilova minawena tuta tuta bivilulu litula naminabwaita sainela. ");
INSERT INTO kij_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosepa matauna makawala ase bulukilova otalila utuwotu. Kaina makawala ase nagugwadi olilina koya. ");
INSERT INTO kij_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kala tilaula bikabiliasi baisa matauna deli kasi leiya, e bibokavilaisi matauna deli kasi kaiyala. ");
INSERT INTO kij_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mitaga matauna kala kaiyala biyosikikiti, deli yamala kweyapapeula wala, metoya ola peula matauna Topeuligaga, Yekobe la Yaubada, matauna Toyamata sipi, e matauwena goli kala Tokwala Isireli. ");
INSERT INTO kij_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","E baisa tamam la Yaubada eipilasaim, e Yaubada matauna Topeuligaga bimitukwaiyaim. Bisakaim kuna metoya walakaiwa, deli utuwotu metoya osikowala pwaipwaia. Bisakaim bidubadu bulutuvalu deli litumwa. ");
INSERT INTO kij_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Bisakaim kaula deli lala. Bisakaim tubumwa si koya, deli goli bisakaim vavagi makwaisina saina bwainigaga kasi gigisa metoya koya makwaisina kwetitovagasi. Ibodi mitakwai makwaisina bisisuaisi baisa Yosepa, e matauna Yaubada eikatupali metoya baisa tuwʹala bibani mitakwai makwaisina. ");
INSERT INTO kij_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Beniamina matauna makawala kaukwa ugiwagi nagigasisi, kaukwau deli koyavi ikikamati ilulupoli.” ");
INSERT INTO kij_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Matausina Isireli dalela dililuwotala dilayu makawala avaka tumasi bogwa ilivala baisa matausina. E isaiki biga bobwailila deli la biga taloi taitala baisa taitala litula. ");
INSERT INTO kij_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","E Yekobe isaiki litula kasi karaiwaga ikaibiga, kawala, “Ka, tuta baisa yeigu balokaia ulo tomota baisa okaliga. Bukubakwaigusi deli tubugwa olumoulela lagi makwaina olopola Epironi la kwabila guma Itai, ");
INSERT INTO kij_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","mapilana Makipela viluwela Mamira opilibomatu olumoulela mapilana Kenani. Eberaam omitibogwa eigimoli lagi makwaina deli goli baleku metoya baisa Epironi paila kasi laka. ");
INSERT INTO kij_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","E baisa eibakwaisi Eberaam deli la kwava Sera. Baisa eibakwaisi Aisake deli la kwava Ribeka. Makawala goli yeigu tuvaila labaku Lea. ");
INSERT INTO kij_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Eberaam igimoli makubilana deli lagi makwaina olopola kwabila metoya baisa mina Itai. E baisa goli bukubakwaigusi.” ");
INSERT INTO kij_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Avai tuta Yekobe bogwa ivenoku la katuloluta baisa litula, ikenuvau tuvaila, e iwokuva la momova. ");
INSERT INTO kij_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosepa ikapusi ilokaia tamala wowola ivalam deli iviyuwoli migila. ");
INSERT INTO kij_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Oluvi ikaraiwaga bikapolaisi tamala wowola. ");
INSERT INTO kij_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ipaisewasi iboda kweluwovasi yam e ivigimkulovaisi kala kapula wowola, baisa makawala tuta tuta topaisewa matausina kala kaduwonaku si paisewa paila tomata. E mina Itipita ivalamsi paila matauna kweluwolima kweluwoyu yam. ");
INSERT INTO kij_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tuta makwaina ivenokusi valam, Yosepa ikaibiga baisa guyau la kaidadala valu, kawala, “Anigadaimi bukukwauwaisi ulo biga baisa guyau. ");
INSERT INTO kij_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Kawami, ‘Avai tuta tamagu la tuta katitaikina bogwa bikaliga, leilukwaigu mwada bakatotila paila babaku matauna laka makwaina bogwa leikatubiasi mapilana Kenani. Mapaila anigadaim bukutugwalaigu balau abaku tamagu, e oluvi bakeiita.’” ");
INSERT INTO kij_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","E guyau ivitakauloki matauna, kawala, “Bwaina wala, kulau kubaku tamam, makawala m biga katotila mwada bukuvagi wala.” ");
INSERT INTO kij_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","E Yosepa ila bibaku tamala. Komwaidona guyau la kaidadala valu, matausina tokwaraiwogala valu deli mina Itipita kasi tokugwa, komwaidosi goli ilosi deli Yosepa. ");
INSERT INTO kij_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Tuvaila Yosepa la bwala kala tosisu, e tuwʹala, deli tumasi la ula komwaidosi deli ilokaiasi. Mesinaku gugwadi tokikekita wala isimwaisi e deli si mauna minasina sipi, gota e bulumakau komwaidona isisuaisi mapilana Goseni. ");
INSERT INTO kij_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Deli matausina mimilisi tauwau tosisula wogala kabilia kaibibiu toyo mimilisi tosisila wosa deli ilosi, e ivigaki saina boda budoveka. ");
INSERT INTO kij_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Bogwa leimaisi Etadi okabotutula witi, baisa Yoridani opilibomatu, e baisa iuvalamsi kaigasi saina kaigaveka tuta kaduwonaku. E Yosepa ilibu kwailima kwaiyu yam paila tamala libula. ");
INSERT INTO kij_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Avai tuta mina Kenani igisaisi matausina eiuvalamsi mapilana Etadi, ikaibigasi kawasi, “Ka, ina kwaita libu mina Itipita eiuvagaisi!” Baisa uula idokaisi mapilana valu Eibeli Misireim. ");
INSERT INTO kij_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","E makawala wala Yekobe litula ivagaisi makawala tumasi eikaraiwogi matausina. ");
INSERT INTO kij_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ikauwaisi wowola ilauwaisi mapilana Kenani, e ibakwaisi makwaina lagi Makipela, Mamira opilibomatu, makubilana omitibogwa Eberaam eigimoli metoya baisa Epironi guma Itai eivigaki kasi laka. ");
INSERT INTO kij_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosepa eibaku tamala e oluvi ikeiita mapilana Itipita deli tuwʹala, e deli komwaidosi matausina leilokaiasi deli matauna paila kalisamila. ");
INSERT INTO kij_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Bogwa tumasi eikaliga e Yosepa tuwʹala ikaibigasi kawasi, “Wi, kaina Yosepa bikoulovaidasi bikaimapu baisa yakidasi komwaidona vavagi gaga avaka leitavigakaisi matauna.” ");
INSERT INTO kij_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Mapaila iwitalaisi biga baisa Yosepa, ikaibigasi, kawasi, “Igau tamadasi gala bikaliga, ");
INSERT INTO kij_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ilukwaimasi bakanigadaimsi kawamasi, ‘Bukuligaiwa ma sulasi makwaina avaka lakavigakaimsi tuta matutona kayogagaimsi.’ Mapaila kanigadaimsi mwada bukuligaiwa ma mitugagasi avaka lakavagaisi, paila yakamaisi kawotitalaisi tamam la Yaubada.” E Yosepa ivalam tuta matutona eilagi si bigatona. ");
INSERT INTO kij_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","E tuwʹala imaisi ikavaginasi baisa matauna ikaibigasi kawasi, “Ibodi bukuvigakaimasi m ula.” ");
INSERT INTO kij_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mitaga Yosepa ikaibiga baisa matausina kawala, “Gala bukukokolasi. Gala gagabila bavigakaigu makawala Yaubada. ");
INSERT INTO kij_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yokomi lokuninamsaisi gaga baisa yeigu mitaga Yaubada ikatumapu ivigaki bwaina, kidamwa bikoli bidubadu tomota si momova. E bidubadu matausina yam lagaila isisuaisi tomomova paila uula vavagi makwaisina eikaloubusisi makawala. ");
INSERT INTO kij_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Gala avaka bukukukolaisi. Bogwa bayamataimi deli litumia.” E Yosepa ibigibwaili matausina deli la biga kamaiaba, e ikatigam luposi. ");
INSERT INTO kij_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","E Yosepa isigaga wala mapilana Itipita deli tamala veyala. Kala taitu iboda lakatutala kweluwotala, e tuta makwaina ikaliga. ");
INSERT INTO kij_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Tutala isisu tomomova, e igisi Epereim litula deli tubula. E tuvaila igisi Manasa latula yagala Makira eiuni litula. ");
INSERT INTO kij_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ikaibiga baisa tuwʹala kawala, “Ka yeigu katitaikina bakaliga, mitaga Yaubada bogwala bisikailimi biyamataimi deli bivakadaimi bikaimilivauwaimi metoya makwaina valu e bilauwaimi makwaina valu bogwa eilivala la biga katotila baisa Eberaam, Aisake, deli Yekobe.” ");
INSERT INTO kij_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","E oluvi Yosepa inigadi la tomota kidamwa bilivalasi biga katotila peula. Ikaibiga kawala, “Kukwatotilasi kidamwa avai tuta Yaubada bikaimilivauwaimi bukulosi mapilana valu, ibodi deli bukukwauwaisi wowogu e bukulauwaisi.” ");
INSERT INTO kij_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","E Yosepa ikaliga mapilana Itipita kala taitu iboda lakatutala kweluwotala. E ikapolaisi wowola isemoyaisi olumoulela kwaitala didawaga tomata kabosakaila.");
INSERT INTO kij_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yekobe litula eigalasi eilosi mapilana Itipita deli matauna, e matausina taitala taitala deli wala litusia. E matausina yagasi ");
INSERT INTO kij_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, Simioni, Libai, Yuda, ");
INSERT INTO kij_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Sebuloni, Beniamina, ");
INSERT INTO kij_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Napitalai, Gada, deli Asera. ");
INSERT INTO kij_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","E matausina Yekobe dalela kasi bawa tailuwolima tailuwoyu. E latulaga Yosepa bogwa wala eisibogwa mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","E igau matubona Yosepa deli tuwala ikaligasi, e tuvaila kesala tubwa matubona. ");
INSERT INTO kij_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Taga tubusia iunigeyaisi bidubadu gugwadi, e mabudona mina Isireli dalela saina budoveka, e matausina ivakasauwaisi Itipita. ");
INSERT INTO kij_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","E oluvi taitala giyouvau ikaraiwogi Itipita. E matauna gala wala inikoli Yosepa livalela. ");
INSERT INTO kij_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Iluki la tomota kawala, “Ka! Mina Isireli saina bidugaga deli saina budoveka, e bogwa bikaiyoulaidasi. ");
INSERT INTO kij_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","E gala tagigisi kidamwa kabilia bima, e kaina bikommolaisi boda kwaitala deli kada tilaulasi, e bikabiliasi deli yakidasi, e baisa makawala bisakaulasi metoya oda valusi. Mapaila ibodi bitanevisi avai nanamsa bitavagaisi bitasilibodaisi mwada taga tuvaila kasi bawa bibidubadu.” ");
INSERT INTO kij_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Mapaila mina Itipita isailisi kasi tokaraiwaga odubasi, kidamwa mina Isireli bivigaki bipupaisewasi mwau sainela paila bilamamsi komwaidosi. Mina Isireli eikaliaisi valu mapilasina Pitom deli Ramesa, mwada mapilasina bivigaki guyau la bomileilai. ");
INSERT INTO kij_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Taga mayogagela wala mina Itipita iyogagaisi mina Isireli, e mauvagila goli kasi bawa ibidubadu, e tuvaila wala isilomlasi olopola valu. Mapaila mina Itipita ikukolaisi mina Isireli. ");
INSERT INTO kij_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","Ivigaki si sisu mwau sainela metoya si komikikana baisa matausina olopola paisewa mwau. Ivigakaisi mina Isireli si tokwaliai e deli si tobagula. Deli gala wala sitana si nokapisi baisa matausina. ");
INSERT INTO kij_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","E tuta matutona mina Itipita si guyau ilivala baisa minasina vilesi Iberu tokaivalulu. Natana yagala Sipara, nayuwela yagala Puwa. ");
INSERT INTO kij_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","E guyau matauna ikaibiga kawala, “Ka, kugisaisi. Matutona yokomi kukwavilulaisi vilesi Iberu - ka, kidamwa gwadi tau bikaloubusi, kukwatumati. Kidamwaga magudina vivila wala, e desi wala, bimova.” ");
INSERT INTO kij_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mitaga minasina tokaivalulu ikukolaisi Yaubada, e gala wala bikabikuwolaisi guyau. E mapaila gugwadi tauwau iyomovaisi wala. ");
INSERT INTO kij_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","E matauna guyau idou minasina tokaivalulu e ikatupoi kawala, “Avaka uula kuuvagaisi baisa ke? Avaka uula kuyomovaisi magudisina tauwau?” ");
INSERT INTO kij_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","E ivitakaulokaisi kawasi, “Ka, vilesi Iberu gala makawala vilesi Itipita. Paila vilesi Iberu si kaivalulu gagabila, e bogwa bivilulubogwasi oluviga yakama bakasusuvi.” ");
INSERT INTO kij_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","E mapaila Yaubada imitukwaii minasina tokaivalulu, paila uula minasina ikukolaisi Yaubada, e itagwala biunaisi litusia titoulesi. E mina Isireli tuvaila iunigeyaisi saina bidugaga, deli saina budoveka goli. ");
INSERT INTO kij_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","E kala vigimkovila, guyau matauna isaiki la tomota komwaidosi kasi karaiwaga. Kawala, “Bukuyosisi magudisina gudipwapwawa tauwau mina Iberu e bukulavaisi bilosi wa Waya Naili. Vivila wala bimovasi.” ");
INSERT INTO kij_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Wa tuta matutona taitala tau metoya odalela Libai ivaisi sola natana vivila metoya odalela titoulela. ");
INSERT INTO kij_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","E ivilulu latula tau. Avai tuta minana igisi latula saina gudiminabwaita sainela, e ikatupwani matauna iboda natonu tubukona. ");
INSERT INTO kij_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mitaga igigisi gala igagabila bikatupwani matauna tuvaila, e mapaila ikau tatala peta eiwoli metoya pitapatila e ibwadi taga sopi bisuvi. E isewoya gwadi olumoulela e ilau isaiwa omnumonu yauwonaku okununa waya. ");
INSERT INTO kij_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","E gwadi magudina luleta itowa sitana kaduwonaku mwada bigisi avaka biviloubusi baisa matauna. ");
INSERT INTO kij_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","E guyau latula vivila ivabusi leima bikakaya, e la nawotetilaga ililoulasi opapala waya. Gala imomwa igisi peta matana omnumonu yauwonaku, e iwitali la nawotetila natana bila ikau. ");
INSERT INTO kij_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","E guyau latula iulaim peta matana igisi gwadi magudina tau iuvalam wala, e saina ikikapisi lopola sainela. Kawala, “Wii! Magudina gwadi taitala mina Iberu litusia!” ");
INSERT INTO kij_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","E gwadi luleta iviloubusi iluki minana guyau latula kawala, “Ki, kudoki bala anevi natana vilela Iberu e igagabila bivinunu matauna?” ");
INSERT INTO kij_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","E iluki minana, kawala, “Bogwa bwaina wala!” E vivila minana ilokaia imiaki magudina inala wala titoulela. ");
INSERT INTO kij_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","E guyau latula iluki numoya minana, kawala, “Kukwau gwadi magudina kulau kuvinunu paila yeigu, e yeigu bamapwaim.” E ikau magudina ilau ivinunu. ");
INSERT INTO kij_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","E oluvi, avai tuta gwadi magudina bogwa eitoveka, iuyoki guyau latula, e ivakalai matauna ivigaki makawala latula titoulela. E ilivala titoulela, “Bogwa lakatuligavi metoya wa sopi, mapaila badoki matauna yagala Mosese.” ");
INSERT INTO kij_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","E wa tuta matutona Mosese bogwa eiulatila, e ilokaia bivakawoli la tomota mina Iberu. E igisi ammakawala kala mwau si paisewa leikomikikanaisi. Mitaga ivitoki tolosila taitala guma Itipita eitokaia ikatumati guma Iberu, matauwena goli Mosese la tomota tatoula. ");
INSERT INTO kij_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","E Mosese iwawai kala yausa, e avai tuta ivitoki tolosila gala wala availa igigisi matauna, e itokaia ikatumati matauna guma Itipita e ibaku okanakenuva. ");
INSERT INTO kij_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","E kwaiyuwela yam ikeiitavau imakaia igisi taiyu mina Iberu ikikimapusi. E iluki matauna tolipakula kawala, “Avaka paila kuwawaiya som wala guma Iberu?” ");
INSERT INTO kij_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","E matauna tau ivitakauloki, kawala, “Wa, availa inagaim bukukwaraiwogaimasi mwada kama toyakalasi yoku? Ki, yoku magim bukukwatumataigu, makawala lokukwatumati matauna guma Itipita?” E avai tuta Mosese ilagi makawala, saina ikokola e inanamsa titoulela wala, “Ka, tomota leibanaigusi avaka lavagi.” ");
INSERT INTO kij_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Tutala guyoula Itipita ilagi avaka eikaloubusi, ivigikoni ammakawala bikatumati Mosese. Mitaga Mosese igala, isakaula ila mapilana Midiani. Kwaitala yam Mosese isisu opapala kwaitala utuwotu, e nalima nayu litula Yetoro, matauna si tolula mina Midiani, imaisi bigolasi sopi e biligabwaisi bila okaiwaga, paila bivimomwaisi tumasi la sipi deli la gota. ");
INSERT INTO kij_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mitaga mimilisi toyamata sipi ibokavilaisi minasina Yetoro litula ilosi. Mapaila Mosese ilokaia ipilasi minasina e ivimom si mauna. ");
INSERT INTO kij_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","E tutala ikaimilavausi baisa tumasi, ikatupoi minasina kawala, “Avaka paila lagaila saina kaukwau lokukweiitasi?” ");
INSERT INTO kij_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ivitakaulokaisi matauna kawasi, “Taitala tau guma Itipita ipilasaimasi metoya matausina toyamata sipi, e igoli sopi paila yakamaisi, deli goli ivimom da maunasi.” ");
INSERT INTO kij_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","E ikatupoi litula kawala, “Wo! Ambaisa matauna? Avakaga paila kuligaiwaisi matauna? Kulosi kulukwaisi matauna bima e deli bitakamsi.” ");
INSERT INTO kij_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","E mapaila Mosese itagwala bisisiaisi baisa, e Yetoro iyovaiya latula Siporai baisa Mosese. ");
INSERT INTO kij_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","E minana iuni latula tau. E Mosese inanamsa titoulela, “Yeigu togilagala ovalu makwaina, mapaila badoki matauna yagala Gerisom.” ");
INSERT INTO kij_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kwaivila taitu bogwa leiwokuva, e guyoula Itipita ikaliga, taga mina Isireli igau wala ikikayagigilasi paila kasi mwau e ininigadasi paila pilasi. Si valam imwena baisa Yaubada, ");
INSERT INTO kij_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","e ilagi si kayagigila e iluwai la kabutu baisa Eberaam, Aisake deli Yekobe. ");
INSERT INTO kij_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Matauna igisi kasi mwau mina Isireli e mwada bipilasi matausina. ");
INSERT INTO kij_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Kwaitala yam, Mosese iiyamata yawala la sipi deli la gota. E yawala yagala Yetoro, mina Midiani si tolula. E matauna ivakouli mayuwosina imai mapilana oviloupakala Sinai, wa koya kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","E Guyau la anelosi iyoumatila baisa matauna metoya wa kova eilululu wa kai. E Mosese bogwa leigisi kova eilululu wa kai mitaga gala igabu makaina. ");
INSERT INTO kij_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","E inanamsa, kawala, “Wi! Baisa kwemitawasi wala. Avaka paila gala igabu makaina kai? E igau bala katitaikinela e bagisimlili.” ");
INSERT INTO kij_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","E tutala Guyau bogwa leigisi Mosese leima katitaikinela makaiwena kai, e Guyau idou matauna kawala, “Mosese, Mosese!” E itama kawala, “Wo! Yeigu, ka!” ");
INSERT INTO kij_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Yaubada ikaibiga kawala, “Ei! Gala bukuma katitaikinela baisa. Ka, kuvilili kaikem katubukolela, paila baisa lokutitoki pwaipwaia kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Paila yeigu tubumwa si Yaubada, e Eberaam, Aisake deli Yekobe si Yaubada yeigu.” Mapaila Mosese itapapi matala, paila kala kokola gala magila bigisi Yaubada migila. ");
INSERT INTO kij_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","E Guyau ikaibiga kawala, “Bogwa lagisi ammakawala ulo tomota eibodasi mwau sainela metoya oyumasi kasi tokaraiwaga mapilana Itipita. E anakaigali si dou magisi bakoli metoya baisa kasi toyamata mina gigasisi. Anikoli ammakawala kasi mmayuyu ");
INSERT INTO kij_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","e labusi kidamwa bakoli matausina metoya baisa mina Itipita oyumasi, e basunupuloi matausina metoya mapilana Itipita, bilosi mapilana valu saina kubilumalala, ambaisa mina Kenani, mina Itai, mina Amora, mina Peresi, mina Ivi e deli mina Yebusi tuta baisa isisuaisi. ");
INSERT INTO kij_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","E mokwita goli lalagi si dou ulo tomota e deli bogwa lagisi ammakawala mina Itipita si lamadada baisa matausina. ");
INSERT INTO kij_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","E baisa tuta bawitalaim bukulokaia guyoula Itipita, kidamwa bukuvisunupuloi ulo tomota metoya ola valu matauna.” ");
INSERT INTO kij_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mitaga Mosese ivitakauloki Yaubada, kawala, “Yeigu gala wala agu yeiwau. Ammakawala yeigu balokaia guyau matauna? E ammakawala bavisunupuloi mina Isireli metoya mapilana Itipita?” ");
INSERT INTO kij_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","E Yaubada ivitakaula kawala, “Yeigu igau basikailim, e avai tuta bogwa bukuvisunupuloi ulo tomota, e bukutapwarorusi baisa yeigu wa koya makwaina. Baisa bivigaki bukusimokwita mwada yeigu lawitalaim.” ");
INSERT INTO kij_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","E Mosese ikatupoi kawala, “Ki, matutona balokaia mina Isireli, e baluki matausina kawagu, ‘Ka! Si Yaubada tubumia leiwitalaigu lamakaiam!’ e bogwa bikatupoiyaigusi kawasi, ‘Ami yagalaga?’ E, ammakawala baluki matausina?” ");
INSERT INTO kij_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Yaubada ikaibiga, kawala, “Yeigu wala matoulegu. Baisa ibodaim yoku bukulivala baisa matausina. Kawam, ‘Matauwena yagala idokaisi “Yeigu Wala” eiwitalaigu lamakaiami.’ ");
INSERT INTO kij_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kuluki mina Isireli kidamwa yeigu Guyau Yaubada, si Yaubada tubusia, e Eberaam, Aisake deli Yekobe si Yaubada, bogwa lawitalaim lokumakaia matausina. Maigana goli yagagu bikanuvagasi. E matubosina, avai tubwa avai tubwa igau bikaloubusisi, bogwa bidokaigusi baisa makawala. ");
INSERT INTO kij_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Kula kukouguguli kasi tokugwa mina Isireli, e bukuluki kidamwa yeigu Guyau Yaubada, si Yaubada tubusia, e Eberaam, Aisake deli Yekobe si Yaubada, bogwa layoumatila baisa yoku. E bukuluki matausina kidamwa yeigu lamakaia matausina, e kidamwa bogwa lagisi avaka mina Itipita ivigakaisi matausina. ");
INSERT INTO kij_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","E ka, yeigu bogwa lanagi kidamwa basunupuloi matausina metoya osi lumkoli saina mwaugaga mapilana Itipita, e balau mapilana valu saina kubilumalala, ambaisa mina Kenani, mina Itai, mina Amora, mina Peresi, mina Ivi, e deli mina Yebusi si valu. ");
INSERT INTO kij_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Ulo tomota bilagaisi avaka bukuluki matausina. Oluvi bukulosi deli tokugwala Isireli, e bukulokaiasi guyoula Itipita, e bukuluki matauna kawam, ‘Matauna Guyau, mina Iberu si Yaubada, bogwa iyoumatila baisa yakamaisi. Baisa tuta bukutagwala bakatavinasi kwaitolu yam oviloupakala, kidamwa bakagabwaisi lula baisa Guyau ma Yaubadasi.’ ");
INSERT INTO kij_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Anikoli matauna guyoula Itipita gala wala bitugwalaimi bukulosi. Ilagoli kidamwa matauna guyau bibani kala komikikana e bogwa bitugwalaimi bukulosi. ");
INSERT INTO kij_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Paila ka! Metoya ogu peula bavagi mimilisi vavagi kabovitukokola e makawala bamipuki matausina mina Itipita. Oluvi matauna titoulela bitugwalaimi bukulosi. ");
INSERT INTO kij_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Yeigu bogwa bavigaki mina Itipita bikamiabaimi mapaila avai tuta ulo tomota bilosi, gala bibodi yumawokuva wala bilosi. ");
INSERT INTO kij_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Komwaidosi vilesi Isireli biboda bilokaiasi minasina vilesi Itipita otalisi e deli availa vilesi Itipita eivigakaisi si ula, e iboda binigadaisi karekwa e deli kasi katububula goula deli siliba. E mina Isireli bikatububulaisi litusia metoya makwaisina guguwa, e bikauwaisi bilauwaisi kaikeyasi mina Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosese ivitakauloki Guyau, kawala, “Ki, ammakawala? Kaina mina Isireli gala bidubumaigusi e gala wala bilagaisi avaka lalivali. E ammakawala bavigaki kidamwa bilivalasi mwada yoku gala kuyoumatila baisa yeigu?” ");
INSERT INTO kij_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mapaila Guyau ikatupoi matauna, kawala, “Avakaga lokuiyosi oyamam?” E ikaibiga, kawala, “Mna, kaitukwa wala.” ");
INSERT INTO kij_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","E Guyau ikaibiga, kawala, “Kulavi makaina kaitukwa bila opwaipwaia.” E Mosese ilavi makaina kaitukwa, e kai imila keiyuna, e matauna isakaula metoya minana keiyuna. ");
INSERT INTO kij_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","E Guyau iluki Mosese, kawala, “Kukwalakova kuyosi yeyunela.” Mapaila Mosese itapopula wala iyosi minana keiyuna e imila kaitukwa tuvaila. ");
INSERT INTO kij_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","E Guyau ikaibiga, kawala, “Bukuvagi baisa kidamwa mina Isireli bisimokwitasi kidamwa yeigu Guyau Yaubada layoumatila baisa yoku. E mayeigu goli tubusia si Yaubada, e Eberaam, Aisake deli Yekobe si Yaubada yeigu.” ");
INSERT INTO kij_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Guyau ilukivau Mosese, kawala, “Kukovisuvi yamam bila olumoulela kam kwama.” Mosese ikabikaula, e tutala ibiigili yamala, bogwa wala iyosi katoula, e isipusipwapula wala mweyamwaidona. ");
INSERT INTO kij_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Oluvi Guyau ikaibiga, kawala, “Kukovisuvivau yamam bila olumoulela kam kwama.” E matauna ivagi makawala, e tuta matutona ibiigili, bogwa imigileu makawala wala wowola komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Guyau ikaibiga, “Kidamwaga matausina gala bidubumaimsi, kaina bininayuwasi paila kabutuvatusi ikugwa, e bogwa goli matausina bininatotilasi paila kabutuvatusi kwaiyuwela. ");
INSERT INTO kij_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Mitaga kaina bigisaisi kwaiyu kabutuvatusi makwaisina e gala wala bidubumaimsi e galaga binakaigalaisi avaka kulilivali. Kidamwa makawala, ka - kuvagi makawala baisa. Kukili sitana sopi metoya wa Waya Naili kuligabu bila opwaipwaia. E sopi baisa bidavila bimili buyavi wala.” ");
INSERT INTO kij_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mitaga Mosese ikaibiga, kawala, “Woo, mwa! Guyau, gala, galaga bukuwitalaigu. Paila uula gala tobigitomoya yeigu. Ka, igau okuvitouula lokudouwaigu e leima yam lagaila, gala wala tobigitomoya yeigu. Paila yeigu togum toyo tokamtomota wala yeigu.” ");
INSERT INTO kij_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","E Guyau iluki matauna, kawala, “Mwa! Ki, availaga isaiki tomota wodola? Kaina availa ivigaki matauna bituli kaina bikutabu? E availaga ivigaki matauna bimitalala kaina bikau? Baisa goli mayeigula Guyau. ");
INSERT INTO kij_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","E tuta baisa bukula, igau bayogigibali paila m bigatona, deli igau bavitulokaim avaka bukulivali.” ");
INSERT INTO kij_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mitaga Mosese ivitakaula, kawala, “Wa, Guyau, gala wala. Akoma lopom. Ka, kuwitali availa.” ");
INSERT INTO kij_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","E Guyau la gibuluwa iviloubusi baisa Mosese ikaibiga, “Ammakawalaga tuwam Eroni, matauna dalela Libai? Anikoli wala matauna tobigitomoya. E ka, matauna baisa tuta leimaima bibodaim, e deli kala mwamwasila nanola kidamwa bigisaim. ");
INSERT INTO kij_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Yoku gagabila bukuluki matauna deli bukulivala baisa matauna avaka bilivali. Yeigu bapilasaimi kamitaiyu bukulivalasi e deli yeigu balukwaimi kamitaiyu avaka bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Matauna bivigaki makawala wodom, deli kaimapum bilivala baisa tomota. E yokugwa makawala Yaubada, paila bukuluki matauna avaka bikaibigi. ");
INSERT INTO kij_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kukwau makaina kaitukwa kulau, paila bukuvagi mimilisi kabutuvatusi metoya makaina.” ");
INSERT INTO kij_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","E Mosese ikeiita baisa yawala Yetoro, e iluki matauna, kawala, “Kaina bukutugwalaigu bakaimilavau mapilana Itipita, e bavakawoli veyagwa e banevi kaina tommomova isisuaisi.” E yawala itagwala e itali matauna. ");
INSERT INTO kij_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","E matutona Mosese isisu wala mapilana Midiani, Guyau iluki matauna, kawala, “Kukwaimilavau Itipita, paila matausina mwada bikatumataimsi bogwa eikaligasi.” ");
INSERT INTO kij_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","E Mosese ikoluluvi la kwava deli litula, eivisiyeila wa ase, e ivatuboulolasi bilosi Itipita. E deli iyosi kaitukwa makaina Yaubada eiluki bikau. ");
INSERT INTO kij_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Tuvaila Guyau iluki Mosese, kawala, “Ka, bogwa bukukwaimilavau mapilana Itipita, e mapaila kuyamata bukuvagi komwaidona makwaisina kabutuvatusi omatala guyau avaka lakatupewolaim paila bukuvagi. Taga igau bavigaki guyau matauna bikasai dabala e gala bikilavi tomota. ");
INSERT INTO kij_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","E bukuluki matauna kidamwa yeigu Guyau alivala kawagu, ‘Isireli mabudona makawala ulo kuluta tau. ");
INSERT INTO kij_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Lalukwaim mwada bukukilavi latugu bila bitapwaroru baisa yeigu, taga yoku kuyusi. E ka, baisa tuta bakatumati m kuluta latum tau.’” ");
INSERT INTO kij_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ililoulasi bilosi Itipita, e katupotala kabosikaiwa makadana keda, Yaubada ibodasi sola Mosese deli mwada magila bikatumati matauna. ");
INSERT INTO kij_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","E minana Siporai ikau memetu e ibobu latula tau wowola e ikau kanavina ikipituki kaikela Mosese. Paila isim kasi gulogula paila bobu, e mapaila minana iluki Mosese, kawala, “Ka, bogwa ladokaim ulo mwala metoya obuyavi.” Mauula Yaubada ikoli Mosese la momova. ");
INSERT INTO kij_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","E tuta matutowena goli Guyau eikaibiga baisa Eroni, kawala, “Kula oviloupakala e bukubodi Mosese.” Mapaila bogwa eila e ibodi matauna wa koya makwaina kwebumaboma. E matutona Eroni eibodi Mosese e iviyuwoli matauna. ");
INSERT INTO kij_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mapaila Mosese eiluki Eroni vavagi komwaidona avaka Guyau eilivali matutona eiluki bikaimilavau Itipita, e deli goli eiluki kabutuvatusi makwaisina eikaraiwogi matauna bivagi. ");
INSERT INTO kij_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mapaila Mosese sola Eroni ilosi Itipita ikougugulaisi komwaidona mina Isireli kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","E Eroni iluki mabudona vavagi komwaidona makwaisina avaka Guyau eilukibogwi Mosese, e oluvi Mosese ivagi komwaidona kabutuvatusi makwaisina omitasi tomota. ");
INSERT INTO kij_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","E matausina idubumaisi wala. E avai tuta eilagaisi ammakawala Guyau eimakaia mina Isireli deli eigisi ammakawala eibodasi mwau metoya oyumasi toyamata mina gigasisi, e mina Isireli ikavaginasi itapwarorusi. ");
INSERT INTO kij_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Oluvi Mosese sola Eroni ilokaiasi guyoula Itipita ikaibigasi, kawasi “Ka! Matauna Guyau mina Isireli si Yaubada leikaibiga, kawala, ‘Kutugwali ulo tomota bilosi, e bivagaisi paka oviloupakala paila bitemmalaigusi.’” ");
INSERT INTO kij_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","E matauna guyau ikavilavila, kawala, “Wa! Availaga Guyau ke? Avaka uula banakaigali matauna e batugwali mina Isireli bilosi? Gala anikoli matauna Guyau e gala ibodi batugwali mina Isireli bilosi.” ");
INSERT INTO kij_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mosese sola Eroni ivitakaulasi, kawasi, “Ka! Mina Iberu si Yaubada iyoumatila baisa yakamaisi. E ka! Kutugwalaimasi kidamwa bakaliloulasi makawala kwaitolu yam bakalokaiasi mapilana oviloupakala, e baisa bakagabwaisi lula baisa Guyau ma Yaubadasi. Kidamwa gala bakavagaisi makawala, igau bikatumataimasi metoya wa lelia kaina okabilia.” ");
INSERT INTO kij_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","E matauna guyau iluki Mosese sola Eroni, kawala, “Avaka yokomi kudokaisi bukuvigakaisi tomota mwada bisilavaisi si paisewa? Kukwaimilivauwaisi matausina ula baisa osi paisewa. ");
INSERT INTO kij_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Paila yokomi saina bidugaga kami bawa e kukwalisauwaimasi yakamaisi mina Itipita kama bawasi. Ki, kudokaisi tuta baisa magimi mwada bukusimwaisi paisewa kadai?” ");
INSERT INTO kij_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","E mapaila yam makwaiwena wala guyoula Itipita ikaraiwogi towotetila kasi tokaraiwaga deli tokugwala mina Isireli, kawala, ");
INSERT INTO kij_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Gala tuvaila bukusakaisi tomota, lei yammatutila paila bikepupolaisi deli mlomwaluva bimila dakuna. Mitaga ibodi wala bilosi e binainevisi miyasina paila titoulesi. ");
INSERT INTO kij_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mitaga bukulukwaisi matausina ibodi bikepupolaisi mlomwaluva bimila dakuna makawala omitibogwa eivagaisi, bivagaisi kala bawa makawala omitibogwa e kala bawa gala bibusi. Paila matausina si paisewa saina gagabila, e mapaila baisa tuta tuta ininigadasi baisa yeigu kidamwa batugwali matausina bilosi e bigabwaisi lula baisa si Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kulukwaisi matausina bipaisewasi peula, deli bukuyamataisi matausina bisalausi, e taga binakaigalaisi avaka si biga tosisasopa.” ");
INSERT INTO kij_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","E towotetila kasi tokaraiwaga deli mina Isireli paisewa kala tokugwa isolasi baisa mina Isireli kawasi, “Ka! - guyau eilivala gala tuvaila bisakaimi lei. ");
INSERT INTO kij_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mitaga titoulemi wala bukunevisi ambaisa goli bukukowaiyasi, e bukukwepupolaisi mlomwaluva bimila dakuna makawala omitibogwa okuvagaisi, e kala bawa makawala omitibogwa.” ");
INSERT INTO kij_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","E tomota ikabiselusi olopola Itipita inainevisi lei. ");
INSERT INTO kij_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Mitaga kasi tokaraiwaga ikominimanaisi matausina kidamwa bikepupolaisi mlomwaluva deli lei bimila dakuna yam kwaitala kwaitala. E ikaraiwagasi kala bawa gala sitana bibusi, mitaga ibodi bivigakaisi makawala goli omitibogwa igau tutala isisakaisi deli lei. ");
INSERT INTO kij_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","E mina Itipita tokaraiwaga igimsisaisi mina Isireli tokugwala paisewa paila goli eivigakaisi matausina mwada bikaraiwogaisi paisewa. E ikatilakaiyaisi, kawasi, “Ki, avaka paila yokomi gala kukwepupolaisi mlomwaluva bimila dakuna kala bawa makawala lokuuvagaisi omitibogwa?” ");
INSERT INTO kij_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Matausina paisewa kala tokugwa ilokaiasi guyau, ikavilavilasi kawasi, “Mwa, Guyau! Avaka uula lokuvagi makawala baisa yakamaisi? ");
INSERT INTO kij_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Paila gala bisakaimasi lei, mitaga isaitaula m kwaraiwaga paila bakakepupolaisi mlomwaluva deli lei bimila dakuna. E ka, tuta baisa goli igimsisaimasi, e uula goli yoku.” ");
INSERT INTO kij_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","E guyau ivitakauloki, kawala, “Uula goli yokomi saina tonunumata okupakaisi paisewa, e mauula lokunigadaigusi mwada batugwalaimi bukulosi bukugabwaisi lula baisa Guyau Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nani! Kukweiitasi omi paisewa. Gala wala bisakaimi lei, mitaga ibodaimi wala bukukwepupolaisi mlomwaluva deli lei bimila dakuna e kala bawa gala bibusi.” ");
INSERT INTO kij_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","E paisewa kala tokugwa ivitusaisi bogwa bibodaisi mwau. Paila matauna guyau eiluki bikepupolaisi mlomwaluva bimila dakuna kala bawa makawala omitibogwa. ");
INSERT INTO kij_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Avai tuta tokugwa isilavaisi, ibodaisi Mosese sola Eroni, paila bogwa itutulaisi matausina. ");
INSERT INTO kij_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","E ilukwaisi Mosese sola Eroni, kawasi, “Yaubada bogwa igisi avaka lokuvagaisi, deli bogwa bimipukwaimi, paila uula lokuvigakaisi guyau deli la tosikwawa ikoulovaidasi. Ka, yokomi bogwa lokuyomitulaisi kada pakulasi mwada bikatumataidasi.” ");
INSERT INTO kij_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","E Mosese tuvaila itovilaki Guyau, ikaibiga, kawala, “Mwa! Guyau, avaka paila kuyovikidadi m tomota? Avaka uula lokuwitalaigu lama baisa? ");
INSERT INTO kij_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ka! Matutona lalokaia guyau mwada balivala paila yoku - ee, eima lagaila goli, matauna ikatugisisi matausina, deli gala wala avaka kuvagi bipilasi matausina.” ");
INSERT INTO kij_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mapaila guyau Yaubada iluki Mosese, kawala, “Ka, makateki bukugisi avaka bavigaki guyoula Itipita. Bogwa bakomikikani matauna bitugwali ulo tomota bilosi. E ka, bakomikikani matauna kidamwa mwada biyobutubutaimi bukusunapulasi metoya ola valu.” ");
INSERT INTO kij_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Yaubada iluki Mosese, kawala, “Yeigu wala Guyau. ");
INSERT INTO kij_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ayoumatila baisa Eberaam, Aisake deli Yekobe makawala Topeuligaga Yaubada yeigu, mitaga gala avituloki matausina mwada binikolaigusi metoya yagagu igibumaboma, maigana Guyau. ");
INSERT INTO kij_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","E tuvaila akabutu deli matausina, e akatotila basaiki matausina valu Kenani, makwaina eisibogwasi makawala togilagala. ");
INSERT INTO kij_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","E baisa tuta bogwa lalagi si kayagigila mina Isireli, matausina mina Itipita eivigakaisi si ula, e bogwa laluluwai ulo kabutu. ");
INSERT INTO kij_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Mapaila kuluki mina Isireli kidamwa yeigu laluki matausina, kawagu, ‘Yeigu goli Guyau. E yeigu bogwa bakolaimi deli batanekwaimi metoya kami katupipi avaka mina Itipita eivagaisi. Bavitukoli yamagu kweyapeula, paila bamai mipuki saina mwaugaga baisa matausina e yokomiga bakolaimi. ");
INSERT INTO kij_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","E bavigakaimi ulo tomota tatougu, e yeigu wala mi Yaubada. E avai tuta batanekwaimi metoya kami katupipi baisa mina Itipita, e ka - bukunikolaisi kidamwa yeigu Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Bamaiyaimi ovalu makwaina bogwa lakatotila basaiki Eberaam, Aisake deli Yekobe. E baisa goli basakaimi mi valu tatoumi. Yeigu goli Guyau.’” ");
INSERT INTO kij_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","E Mosese iluki makawala baisa mina Isireli, mitaga gala wala inakaigalaisi matauna. Paila uula si kaisisu mwau sainela osi tuta ula, e gala gagabila binanamsasi duwosisia. ");
INSERT INTO kij_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Oluvi Guyau iluki Mosese, kawala, ");
INSERT INTO kij_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Kulokaia guyoula Itipita e kuluki ibodi bitugwali mina Isireli bisilavaisi la valu.” ");
INSERT INTO kij_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mitaga Mosese ivitakauloki kawala, “Ilagoli mina Isireli gala binakaigalaisi kaigagu. E mapaila ammakawalaga matauna guyau bilagi ulo biga? Paila tokamtomota yeigu.” ");
INSERT INTO kij_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Guyau Yaubada ikaraiwogi Mosese sola Eroni kawala, “Ka! Kulosi kulukwaisi mina Isireli deli guyoula Itipita kidamwa yeigu lakaraiwogaimi kidamwa bukukugwaiyaisi mina Isireli bisunapulasi metoya mapilana Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Rubeni matauna Yekobe la kuluta, litula kasitaivasi, Anoki, Palu, Esironi, Kami; matausina deli goli tubusia dala madalasina yagasi eiginaisi. ");
INSERT INTO kij_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simioni litula kasitailima kasitaitala, Yemweli, Yamini, Owadi, Yakini, Sowara, deli Sauli. Sauli matauna inala vilela Kenani; matausina goli tubusia dala madalasina yagasi eiginaisi. ");
INSERT INTO kij_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Libai litula kasitaitolu, Gerisoni, Koati, Mirari; matausina goli tubusia dala madalasina yagasi eiginaisi. Libai isisu kala taitu iboda 137. ");
INSERT INTO kij_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerisoni litula kasitaiyu, Libini, Simei, e matausina dalesi saina bidugaga. ");
INSERT INTO kij_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Koati litula kasitaivasi, yagasi, Amram, Isa, Ebironi, Usieli. Koati isisu kala taitu iboda 133. ");
INSERT INTO kij_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","E Mirari litula kasitaiyu Mali, sola Msi; matausina goli Libai dalela deli tubusia. ");
INSERT INTO kij_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ivaiya tabula wala titoulela; tamala luleta, yagala Yokebedi, e iuni Eroni sola Mosese. E Amram isisu kala taitu iboda 137. ");
INSERT INTO kij_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isa litula kasitaitolu; Kora, Nepegi, deli Sikiri. ");
INSERT INTO kij_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Usieli makawala goli, litula kasitaitolu; Misaeli, Elisapani deli Sitiri. ");
INSERT INTO kij_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Eroni ivaiya Elisiba, minana Aminadaba latula, e Nasoni luleta, e minana iuni litula Nadaba, Abiu, Eleasa, deli Itama; ");
INSERT INTO kij_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kora litula kasitaitolu; Asiri, Elikana, deli Abiasapi, Matausina tubusia madalana dalela Kora. ");
INSERT INTO kij_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","E Eleasa matauna Eroni latula, ivaiya Putieli latula. E iuni latula Peniasi. E matausina goli kasi tommoya metoya odalela Libai. ");
INSERT INTO kij_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","E Eroni sola Mosese, matausina Guyau eiluki kawala, “Kusunupuloiyaisi dala Isireli metoya Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","E matolesi goli eilulukwaisi guyoula Itipita kidamwa bikilai mina Isireli. ");
INSERT INTO kij_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Tuta makwaina Guyau ilivala baisa Mosese mapilana Itipita, ");
INSERT INTO kij_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ikaibiga kawala, “Yeigu goli Guyau. Kuluki guyoula Itipita komwaidona vavagi avaka balukwaim.” ");
INSERT INTO kij_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Taga Mosese ivitakauloki, “Ka, kunikoli yeigu tokamtomota, e ammakawalaga guyau bilagi ulo biga?” ");
INSERT INTO kij_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","E Guyau Yaubada ikaibiga kawala, “Ka, bavigakaim makawala Yaubada baisa guyau matauna, e tuwam Eroni bilivala m biga baisa matauna makawala m tovitoubobuta. ");
INSERT INTO kij_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kuluki Eroni komwaidona avai karaiwaga balukwaim, e matauna biluki guyau mwada bitugwali mina Isireli bisilavaisi la valu. ");
INSERT INTO kij_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mitaga bavigaki guyau bikasai dabala, e gala goli binakaigalaim, ilagoli yeigu bavagi bidubadu kabutuvatusi saina kabokokola olopola Itipita. ");
INSERT INTO kij_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","E oluvi bamipuki mina Itipita saina mwau sainela, e deli bavisunupuloi ulo tomota dalesi bisilavaisi valu makwaina. ");
INSERT INTO kij_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","E avai tuta bamipuki mina Itipita, deli bavisunupuloi mina Isireli, e mina Itipita bogwa bikatetasi kidamwa yeigu goli Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","E Mosese deli Eroni ivagaisi avaka Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tuta makwaina ililivalasi baisa guyau matauna, Mosese kala taitu kweluwolima kweluwotolu, e kweluwolima kweluwotolu kwaitolu kala taitu Eroni. ");
INSERT INTO kij_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","E Guyau Yaubada iluki Mosese sola Eroni kawala, ");
INSERT INTO kij_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Kidamwa guyau matauna bilukwaimi kidamwa bibodi bukuuvagaisi avai kabutuvatusi mwada matauna bisimokwita avaka lokuvagaisi, e kuluki Eroni bilavi la kaitukwa watanawa omatala guyau, e bogwa bidavila bimila keiyuna.” ");
INSERT INTO kij_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mapaila Mosese sola Eroni ilokaiasi guyau e ivagaisi avaka Guyau Yaubada eikaraiwogi bivagaisi. Eroni ilavi la kaitukwa watanawa omatala guyau deli la tosikwawa e ka! - kaitukwa makaina idavila imila keiyuna. ");
INSERT INTO kij_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mapaila guyau idou la tokwabitam deli la tomigameguva, e metoya osi meguva ivagaisi makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Matausina ilavaisi si kaitukwa watanawa e kaitukwa makaisina idavilasi imila keiyunasi. Mitaga Eroni la kaitukwa itokaia ilupoli si kaitukwa. ");
INSERT INTO kij_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Mitaga guyau matauna ikasai wala dabala e gala wala binakaigali Mosese sola Eroni. ");
INSERT INTO kij_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","E Guyau Yaubada iluki Mosese kawala, “Matauna guyau saina kasai dabala, e gala wala itagwala tomota bilosi. ");
INSERT INTO kij_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Igau kaukwau kula kuvabodi matauna tutala bisalili bila wa Waya Naili. E kaitukwa kukwau, makaina lokuvigaki eimila keiyuna, e kututuli matauna opapala waya. ");
INSERT INTO kij_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","E bukuluki guyau matauna kawam, ‘Ka, matauna Guyau, mina Iberu si Yaubada goli, bogwa eiwitalaigu lamakaiam mwada balukwaim bukutugwali la tomota bilosi kidamwa bitapwarorusi baisa matauna oviloupakala. Lalivilabogwʹo mitaga gala wala kutagwala - ee, eima lagaila. ");
INSERT INTO kij_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","E mwa, guyau, ka - Guyau Yaubada eilivala kidamwa yoku makateki bukunikoli matauna metoya baisa avaka makateki bivagi. Ka, kugisi - bogwa bawaiya sopi dabala, e sopi bidavila bimili buyavi. ");
INSERT INTO kij_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","E yenala waya bikaligasi, e maduyona waya yena minasina bisoboginasi e mina Itipita gala igagabila bimomsi metoya maduyona.’” ");
INSERT INTO kij_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Guyau Yaubada iluki Mosese, kawala, “Kuluki Eroni kawam, ‘Kaitukwa kuyosali odubasi waya, waya kadakilikeli, deli katuwotu, olopola Itipita. E bimili buyavi, e valu Itipita viloumwaidona kasi sopi buyaviwokuva wala ambaisa ambaisa, tuvaila okasi kaboma deli kasi lukwava goli.’” ");
INSERT INTO kij_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","E Mosese sola Eroni ivagaisi avaka Guyau la karaiwaga. Omitasi guyau matauna deli la tosikwawa, Eroni iyosali kaitukwa wa waya e iwaiya dabala sopi, e sopi idavila imili buyavi. ");
INSERT INTO kij_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","E yena imiliaki waya ikaligasi iboginaki, e mina Itipita gala gagabila bimomsi metoya wa waya. Paila viloumwaidona valu Itipita buyaviwokuva wala isisu. ");
INSERT INTO kij_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","E guyau la tomigameguva ivagaisi makawala metoya osi meguva. Mitaga guyau ikasai dabala makawala silovala. Paila gala sitana binakaigali si biga Mosese sola Eroni, makawala goli Guyau bogwa eikaibigi. ");
INSERT INTO kij_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Mitaga itovila ila ola ligisa, paila gala sitana itapuloki nanola vavagi baisa. ");
INSERT INTO kij_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","E komwaidosi mina Itipita ikilikelisi wa waya opapala paila kasi sopi, paila gala gagabila bimomsi metoya wa waya. ");
INSERT INTO kij_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","E yam makwaina Guyau Yaubada iwaiya sopi wa waya, e oluvi kwailima kwaiyu yam bogwa leiwokuva. ");
INSERT INTO kij_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","E Guyau Yaubada iluki Mosese kawala, “Kulokaia guyau e kuluki matauna kawam, ‘Guyau Yaubada eilivala, Kutugwali ulo tomota bilosi paila bitapwarorusi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kidamwa bukuyusi, bamipuki m valu, bavigaki kumeu goli bivakasau. ");
INSERT INTO kij_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Waya Naili saina bivakasewoki kumeu, e bisilavaisi waya bisuvisi om ligisa, matabudona okukwanukwenu, okabam, osi bwala m tosikwawa deli m tomota, deli goli om kumkumla, deli kam kwavayega. ");
INSERT INTO kij_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Bipelasi owowom, ouwosi m tomota deli komwaidosi m tosikwawa.’” ");
INSERT INTO kij_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","E Yaubada iluki Mosese kawala, “Kuluki Eroni biyosali la kaitukwa odubasi waya, waya kadakilikeli deli katuwotu, e bikatubutu kumeu bikayalaguvasi bimiliaki valu Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","E Eroni iyosali la kaitukwa odubasi komwaidona sopi, e kumeu ikayalaguvasi imiliaki valu. ");
INSERT INTO kij_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Mitaga tomigameguva imeguvasi, e matausina deli ikatubutaisi kumeu ikayalaguvasi. ");
INSERT INTO kij_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","E guyau idou Mosese sola Eroni ikaibiga kawala, “Kunigadasi baisa Yaubada bikau kumeu biligaiwa, e batugwali m tomota bilosi, paila bilulasi baisa Guyau Yaubada.” ");
INSERT INTO kij_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mosese ivitakaula kawala, “Amwasawa wala banigada paila yoku. Mitaga kusaili wala tutala e banigada paila yoku, m tosikwawa deli kam viloumgwa. E kumeu bitamwausi, gala natana bisisu mesinaku wala wa Waya Naili.” ");
INSERT INTO kij_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","E guyau ivitakauloki kawala, “Nabwaiaga bukunigada paila yeigu kadai.” E Mosese ikaibiga kawala, “Bogwa bavagi makawala kulivala, e mapaila bukunikoli gala taitala tuvaila yaubada makawala Guyau ma Yaubadasi. ");
INSERT INTO kij_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Yoku, m tosikwawa e deli kam viloumgwa gala tuvaila bukugisaisi kumeu minasina, e kumeu bitamwausi mesinaku wa Waya Naili.” ");
INSERT INTO kij_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","E oluvi Mosese sola Eroni isilavaisi guyau. E Mosese inigada baisa Guyau Yaubada paila biligaiwa kumeu, baisa kabomipuki leisaiki guyoula Itipita. ");
INSERT INTO kij_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E Guyau Yaubada ivagi makawala Mosese einigadi, e ka! - kumeu wa bwala, olopola valu deli olawodila idoumlabasi wala. ");
INSERT INTO kij_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","E mina Itipita ikatugugulaisi gulovakavekasi e ikanai wala iboginaki valu. ");
INSERT INTO kij_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","E avai tuta guyau igisi kumeu bogwa eivadoumsi, e tuvaila wala ikasai dabala, gala bilagi si biga Mosese sola Eroni, makawala Guyau Yaubada leikaibigibogwi paila matauna guyoula Itipita. ");
INSERT INTO kij_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","E Guyau Yaubada iluki Mosese kawala, “Kula kuluki Eroni bikau la kaitukwa biwaiya pwaipwaia e viloumwaidona Itipita tubumyoula bimila segusegusi.” ");
INSERT INTO kij_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","E Eroni ikau la kaitukwa iwaiya pwaipwaia e wa tuta matutona tubumyou komwaidona olopola Itipita imila segusegusi, e ikuboli tomota deli mauna nasigisagina. ");
INSERT INTO kij_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","E tomigameguva ivigikonaisi si meguva mwada segusegu bikaloubusisi tuvaila, mitaga eiwaisi isomatasi. Kugisa, ambaisa ambaisa seguseguwokuva wala, ");
INSERT INTO kij_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","e tomigameguva ilokaiasi ilukwaisi guyau kawasi, “Yaubada wala matauna eivagi baisa.” Mitaga matauna guyau ikasai dabala, e gala bilagi si biga Mosese sola Eroni, makawala goli Guyau Yaubada bogwa eilivali. ");
INSERT INTO kij_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","E Guyau Yaubada iluki Mosese kawala, “Nabwaia kaukwau pikekita bukula kubodi guyau tutala bisalili bila wa waya, e kuluki matauna kidamwa baisa Guyau Yaubada eilivala, kawala, ‘Kutugwali ulo tomota bilosi, kidamwa bitapwarorusi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","E akatululutaim kidamwa bukuyusi, e bamipukwaim e bawitali nigunagu baisa yoku, deli m tosikwawa deli kam viloumgwa. Komwaidona mina Itipita si bwala bivakasau wala nigunagu, e minasina bikubolaisi pwaipwaia. ");
INSERT INTO kij_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mitaga bavitopali mapilana Goseni bayamata ambaisa ulo tomota eisisuaisi, e gala goli nigunagu bikaloubusisi baisa. Bavigaki makawala kidamwa bukunikolaisi yeigu Guyau asisu valu makwaina. ");
INSERT INTO kij_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","E balivi ulo tomota e m tomota. Makwaina kabutuvatusi nabwaia wala bikaloubusi.’” ");
INSERT INTO kij_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","E Guyau Yaubada iwitali budoveka nigunagu ola valu guyau matauna, deli la tosikwawa osi bwala, e viloumwaidona valu Itipita ivakasau iyogagi metoya minasina nigunagu. ");
INSERT INTO kij_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","E tuta makwaina guyau idou paila Mosese sola Eroni e iluki kawala, “Kulosi ovalu wala e kululasi baisa mi Yaubada olopola valu makwaina.” ");
INSERT INTO kij_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mitaga Mosese ivitakauloki kawala, “Kidamwa bakavagaisi makawala e baisa gala wala duwosisia. Paila kidamwa mauna bakavigakaisi lula baisa Guyau ma Yaubadasi, e baisa biyomwau ninasi mina Itipita. Kidamwa bakayosisi minasina mauna bakalulasi ambaisa mina Itipita bigisaimasi, e bogwa bikatubuyavaimasi odakuna e bakakaligasi. ");
INSERT INTO kij_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ibodi bakakwaidadinasi yam kwaitolu olumoulela oviloupakala e bakagabwaisi lula baisa Guyau ma Yaubadasi, makawala matauna eikaraiwogaimasi.” ");
INSERT INTO kij_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","E guyau matauna ikaibiga, kawala, “Bogwa batugwalaimi bukulosi bukugabwaisi lula baisa Guyau mi Yaubada olumoulela oviloupakala, kidamwa goli gala bukulosi kaduwonaku. E, bukunigadasi paila yeigu.” ");
INSERT INTO kij_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mosese ivitakauloki kawala, “Matutona basilavi baisa e bogwa banigada baisa Guyau kidamwa nabwaia nigunagu bisilavaimi, yoku deli m tosikwawa deli kam viloumgwa. Mitaga bukuyamata taga tuvaila bukusipulokaimasi deli bukusilibodi tomota bilosi paila bilulasi baisa Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mosese isilavi guyau e ila inigada baisa Guyau Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","E Guyau ivagi makawala avaka Mosese la nigada. Nigunagu isilavaisi guyau matauna, deli la tosikwawa deli kala viloumgwa, e gala natana nigunagu ikesa. ");
INSERT INTO kij_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mitaga tuta baisa tuvaila goli guyau ikasai dabala, e tuvaila gala bitugwali tomota bilosi. ");
INSERT INTO kij_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","E Guyau iluki Mosese kawala, “Kulokaia guyoula Itipita e kuluki kidamwa Guyau, mina Iberu si Yaubada goli, eikaibiga kawala, ‘Kutugwali ulo tomota bilosi e gagabila bitapwarorusi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kidamwa bukuyusivau, ");
INSERT INTO kij_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","igau bamipukwaim e bawitali lelia saina gaga baisa mi mauna komwaidona - mi wosa, mi ase, mi kameli, mi bulumakau, mi sipi deli mi gota. ");
INSERT INTO kij_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","E balivi mina Isireli si mauna e mina Itipita si mauna, e mina Isireli si mauna gala wala natana bikaliga. ");
INSERT INTO kij_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","E yeigu Guyau bogwa laluvatuta baisa nabwaia wala, kidamwa bogwa bavagi makawala.’” ");
INSERT INTO kij_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","E eiyam Guyau ivagi avaka bogwa eilivala bivagi, paila komwaidona maunela Itipita ikaligasi, mitaga mina Isireli si mauna gala wala natana ikaliga. ");
INSERT INTO kij_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","E guyau matauna ikatupoi avaka eikaloubusi, e ilukwaisi matauna kidamwa gala wala natana mina Isireli si mauna eikaliga. Mitaga guyau ikasai wala dabala e gala goli bitugwali mina Isireli bilosi. ");
INSERT INTO kij_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","E Guyau iluki Mosese sola Eroni kawala, “Kuyeilisi yelivila tubwaga metoya okumkumla, e yoku Mosese bukulavi bila walakaiwa omatala guyau. ");
INSERT INTO kij_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","E tubwaga bogwa bikaligiaki makawala tubumyou olopola Itipita komwaidona e bikaloubusi pukuna bimila pwasa ouwosi tomota deli si mauna.” ");
INSERT INTO kij_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mapaila ikauwaisi tubwaga metoya okumkumla, e itotusi guyau omatala, e Mosese ilavi ila walakaiwa, e bogwa ikaloubusi pukuna eimila pwasa ouwosi tomota deli goli si mauna. ");
INSERT INTO kij_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","E matausina tomigameguva gala gagabila bilokaiasi Mosese omatala, paila uula uwosi pukunawokuva wala, makawala komwaidosi mina Itipita. ");
INSERT INTO kij_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mitaga Guyau Yaubada ivigaki guyau matauna ikasai dabala e gala itagwala binakaigali si biga Mosese sola Eroni, makawala Guyau eilivala. ");
INSERT INTO kij_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","E Guyau Yaubada iluki Mosese kawala, “Ka, nabwaia kaukwau pikekita kutokaia kula omatala guyau e kuluki matauna kidamwa Guyau, matauna mina Iberu si Yaubada, eikaibiga, kawala, ‘Kutugwali ulo tomota bilosi e bitapwarorusi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Bogwa bamipuki m tosikwawa deli kam viloumgwa, mitaga tuta baisa bakatumkulovi e yoku tuvaila bamipukwaim, kidamwa bukunikoli gala taitala makawala yeigu ovalu watanawa komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kidamwa batagwala mwada bakatumataim deli m tomota matausina metoya wa lelia, e yokomi komwaidomi wala bukudoumlabasi. ");
INSERT INTO kij_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mitaga magigu bavitulokaimi ulo peula, e mapaila atagwala bukusisuaisi wala tommomova, kidamwa bulogagu bukulivalaisi e bikaligiaki ovalu watanawa komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","E yoku saina kasai dabam gala magim bukutugwali ulo tomota bilosi. ");
INSERT INTO kij_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","E mapaila makulovala nabwaia bamai utuyagila saina kwevakaigaga, deli kuna kwekulokula bikapusisi, gala kwaitala tuta mina Itipita eigisaisi makawala baisa, omitibogwa e lagaila. ");
INSERT INTO kij_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Baisa tuta kuwitali biga paila mi mauna kaina avai vavagi mi guguwa isisuaisi okaukweda, kidamwa nani bimaiyaisi wa bwala olumoulela. Paila kuna kwekulokula bikapusisi baisa avai tomota deli avai mauna lokuligaiwaisi okoukweda, e komwaidosi bikaligasi.’” ");
INSERT INTO kij_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Mimilisi guyau la tosikwawa ikokolasi paila Yaubada la biga, mapaila si towotetila deli si mauna isisuaisi okoukweda imaiyaisi wa bwala paila bisipepunisi. ");
INSERT INTO kij_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mimilisiga matausina gala ikabikaulasi Guyau Yaubada la katuloluta e iligaiwaisi wala okoukweda si towotetila deli si mauna. ");
INSERT INTO kij_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","E Guyau iluki Mosese kawala, “Kuyosali yamam bila wa labuma, e kuna kwekulokula bikapusisi ovalu viloumwaidona Itipita - baisa tomota, mauna, deli goli avaka avaka isususinasi obaleku.” ");
INSERT INTO kij_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mapaila Mosese iyosali la kaitukwa ikibuboti labuma, e Guyau iwitali pilapala deli kuna kwekulokula deli kavikavila iwaiya pwaipwaia. Guyau iwitali ");
INSERT INTO kij_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","kwaiveka utuyagila deli kuna kwekulokula, deli kavikavila ikavikavila ambaisa ambaisa. Utuyagila saina kwaiveka mwau sainela, omitibogwa mina Itipita gala kwaitala tuta igisaisi e leima lagaila. ");
INSERT INTO kij_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Viloumwaidona valu Itipita kuna kwekulokula ikatudebali komwaidona avaka avaka isisuaisi okoukweda, deli goli tomota komwaidosi e mauna komwaidona ikatumtuwoli wala. Ikatumtuwoli kai kaikikekita obaleku, deli ikatuuwoli kai kaivakaveka. ");
INSERT INTO kij_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Mapilana wala Goseni, ambaisa mina Isireli isisuaisi, baisa wala gala ikuna kwekulokula. ");
INSERT INTO kij_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","E guyau matauna iwitali biga baisa Mosese sola Eroni kawala, “Ka, lagaila bogwa lasula. Paila Guyau Yaubada bogwa eikamokwita, e yeigu deli agu viloumgwa bogwa kasulasi. ");
INSERT INTO kij_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kunigadasi baisa Guyau Yaubada, paila bogwa kasomatasi pilapala deli kuna kwekulokula. E alukwaimi biga katotila batugwalaimi bukulosi. Gala wala tuvaila bukusisuaisi baisa.” ");
INSERT INTO kij_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","E Mosese iluki matauna kawala, “Avai tuta basilavi valu makwaina e balokowoi yamagu banigada baisa Guyau Yaubada. E pilapala biwokuva deli gala tuvaila bikuna kwekulokula, e baisa bukunikoli kidamwa valu watanawa baisa la vavagi Guyau Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mitaga anikoli yoku deli m tosikwawa igau gala wala sitana kukukolaisi Guyau Yaubada.” ");
INSERT INTO kij_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Seuloulu deli bali bogwa eigagasi, paila uula bali bogwa eimonogu deli seuloulu makateki eitam. ");
INSERT INTO kij_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mitaga gala sitana luvatala witi bigaga paila uula kasi monogu eiyobali. ");
INSERT INTO kij_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","E Mosese isilavi guyau e isunapula metoya ola valu, e ilokowoi yamala e inigada baisa Guyau Yaubada. E pilapala, deli kuna kwekulokula, deli kuna iwokuvasi wala. ");
INSERT INTO kij_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","E avai tuta guyau matauna igisi makwaisina vavagi bogwa leiwokuva, tuvaila wala imitugaga. Matauna deli goli la tosikwawa tuvaila wala ikasai dubasi makawala omitibogwa. ");
INSERT INTO kij_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","E makawala goli Guyau eilukibogwi Mosese, matauna guyoula Itipita gala bitugwali mina Isireli bilosi. ");
INSERT INTO kij_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Oluvi Guyau iluki Mosese kawala, “Kula kugisi matauna guyau. Yeigu lavigaki matauna deli la tosikwawa ikasai wala dubasi, kidamwa bavagi vavagi kabutuvatusi makwaisina baisa matausina, ");
INSERT INTO kij_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","deli makwaisina bikatululuwaiyaimi bukulilivalasi baisa litumia deli tubumia ammakawala lakatudeu mina Itipita avai tuta lavagi makwaisina kabutuvatusi. E komwaidomi bukunikolaigusi yeigu goli Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","E Mosese sola Eroni ilokaiasi guyau matauna ilukwaisi kawasi, “Matauna Guyau, ma Yaubadasi mina Iberu, ilivala kawala, ‘Ammakawala kala woloula bukupakaigu goli? Bukutugwali ulo tomota bilosi, kidamwa bitapwarorusi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kidamwa bukuyusivau, nabwaia bamai nipawa om valu. ");
INSERT INTO kij_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Bivigaki saina bidugaga e bikuboli pwaipwaia deli bikomasi avai vavagi makunowena kuna kwekulokula gala ikodidaimi, deli goli kai makaisina kesa eitomwaisi. ");
INSERT INTO kij_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","E bivakasauwaisi makwaisina m ligisa, deli si bwala m tosikwawa deli kam viloumgwa komwaidosi. Igau bivigaki saina kala siligaga, gala makawala tubumia eibubanaisi avai tuta.’” Mitaga guyau itovila e ivatuboulola. ");
INSERT INTO kij_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","E guyau la tosikwawa ilukwaisi matauna kawasi, “Ammakawala kala woloula mwada matauna tau biyogagaidasi? Ka, bukutugwali mina Isireli tauwau bilosi. E igagabila matausina bitapwarorusi baisa Guyau si Yaubada. Ki, kaina gala kunikoli viloumwaidona Itipita ikatudumani?” ");
INSERT INTO kij_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mapaila ikaimilivauwaisi Mosese deli Eroni baisa guyau matauna, e iluki matausina kawala, “Desi wala! Igagabila bukulosi bukutapwarorusi baisa Guyau mi Yaubada. Mitaga - ki, availaga bilosi?” ");
INSERT INTO kij_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mosese ivitakauloki kawala, “Yakamaisi komwaidomasi wala bakalosi deli litumaiasi e deli ma nunumoyasi. Bakalauwaisi litumaiasi tauwau deli vivila, e tuvaila ma sipisi ma gotasi, e ma bulumakausi. Paila ibodi bakapakasi e bivigaki kala taimamila Guyau ma Yaubadasi.” ");
INSERT INTO kij_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","E guyau matauna ivitakauloki kawala, “Alivala biga katotila omatala Guyau, gala igagabila batugwali mi nunumoya deli gugwadi bukulauwaisi. Bogwa agisimlili kidamwa kunainevisi ammakawala bukukoulovaigusi wala. ");
INSERT INTO kij_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Gala wala! Ka, tauwau wala bilosi bitapwarorusi baisa Guyau, kidamwa makawala magimi.” E iyabaisi Mosese sola Eroni isunapulasi metoya omatala matauna guyau. ");
INSERT INTO kij_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","E Guyau iluki Mosese kawala, “Kuyosali yamam odabala Itipita viloumwaidona, e nipawa bimaisi. E bimaisi bikomasi vavagi komwaidona kwesususinasi, vavagi komwaidona kesala avaka kuna kwekulokula gala eiyogagi.” ");
INSERT INTO kij_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mapaila Mosese iyosali la kaitukwa e Guyau iwitali yagila bomatu bitokaia e biuu yam makwaina deli bogi makwaina. E eiyam kaukwau ikaloubusisi minasina nipawa. ");
INSERT INTO kij_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","E bogwa ikaloubusisi saina yuwoveka ivakasauwaisi valu komwaidona. E saina bidugaga minasina nipawa, gala kwaitala tuta tagigisi makawala, e igau tuta oluvi gala tuvaila bitagisivau makawala. ");
INSERT INTO kij_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","E ikubolaisi wala pwaipwaia komwaidona bwabwauwokuva wala. Ikomasi ivinakwaisi vavagi komwaidona, avaka kuna kwekulokula gala eiyogagi, deli tuvaila kai kaiuwala komwaidona. Gala sitana avaka kesa isisu semitamata kaina wa kai kainaga omnumonu viloumwaidona valu Itipita. ");
INSERT INTO kij_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","E nanakwa guyau idou Mosese sola Eroni ikaibiga kawala, “Yeigu bogwa wala lasula baisa Guyau mi Yaubada deli goli baisa yokomi. ");
INSERT INTO kij_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Lagaila wala ulo mitugaga bukuligaiwaisi paila wala tuta makwaina. E bukunigadasi baisa Guyau mi Yaubada kidamwa gala basilagi metoya mipuki makwaina.” ");
INSERT INTO kij_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","E Mosese bogwa isilavi guyau matauna e inigada baisa Guyau Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","E tuta makwaina Guyau Yaubada iwitali utuyagila saina peula yagila kwaibwaga e iyuvisau nipawa ilau olopola Bolita Pilabweyani, e gala natana ikesa olopola Itipita. ");
INSERT INTO kij_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mitaga Guyau ivigaki guyau matauna ikasai dabala, e gala wala itugwali mina Isireli bilosi. ");
INSERT INTO kij_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","E Guyau Yaubada iluki Mosese kawala, “Kuyosali yamam bikibuboti labuma, e dubilikitakita sainela bikuboli viluwela Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","E Mosese iyosali yamala ila wa labuma, e dubilikitakita isisu olopola Itipita iboda kwaitolu yam. ");
INSERT INTO kij_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","E mina Itipita gala gagabila bigisaisi sesia e gala taitala isilavi la bwala wa tuta matutona. E mitaga mina Isireli osi valu lumalama wala isisu. ");
INSERT INTO kij_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","E guyau idou Mosese iluki matauna kawala, “Desi wala, bukulosi kutapwarorusi baisa Guyau, e deli goli mi nunumoya deli litumia bukulosi. Mitaga mi sipi, mi gota deli mi bulumakau bisisuaisi baisa.” ");
INSERT INTO kij_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","E Mosese ivitakaula kawala, “Kidamwa makawala, bibodi bukusakaimasi mauna paila bakasemakavaisi deli bakagabwaisi lula bakasakaisi Guyau ma Yaubadasi. ");
INSERT INTO kij_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Gala wala ibodi. Ka, bakakauwaisi ma maunasi, e gala natana bakaligaimwaisi. Paila ibodi yakamaisi titoulemasi bakanagaisi avai mauna bibodi paila bakatapwarorusi baisa Guyau ma Yaubadasi. Deli gala kanikolaisi avai mauna bibodi bakalulasi baisa matauna igau avai tuta wala bakaviloubusisi baisʹe.” ");
INSERT INTO kij_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Guyau Yaubada ivigaki guyau ikasai dabala e gala itugwali mina Isireli bilosi. ");
INSERT INTO kij_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","E iluki Mosese, kawala, “Eei! Kusunapula. Gala magigu tuvaila bagisaim! Wa yam makwaina bagisaim e bukukwaliga!” ");
INSERT INTO kij_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosese ivitakaula, kawala, “Bogwala kukwabuboti! Gala wala tuvaila bukugisaigu.” ");
INSERT INTO kij_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","E Guyau Yaubada iluki Mosese kawala, “Basakaim kwaitala wala kala vigimkovila mipuki bukusaiki guyoula Itipita deli tomotala. E oluvi bitugwalaimi bukulosi. Ka, bogwa goli bibutugigaiyaimi komwaidomi bukusunapulasi metoya baisa. ");
INSERT INTO kij_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","E baisa tuta kula kuluki mina Isireli bilokaiasi sesia otalisi binigadasi kasi katububula goula deli siliba.” ");
INSERT INTO kij_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","E Guyau iviyelu ninasi mina Itipita bitemmalaisi mina Isireli. Paila mokwita goli tosikwawa deli tomota idokaisi Mosese saina tovakaigaga tau. ");
INSERT INTO kij_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","E oluvi Mosese iluki guyau matauna kawala, “Ka! Guyau Yaubada ikaibiga kawala, ‘Olubulotoula yeigu batavina olumoulela Itipita, ");
INSERT INTO kij_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","e bakatumtuwoli komwaidona mina Itipita si kuluta tauwau, bivitouula si guyau la kuluta tau, mwada matauna kaimapula tamala la kabokwaraiwaga, e bila ivigimkulovi baisa la kuluta tau minana ula tokaipupolela kasi bali. E deli bulutuvalu nagugwadi nammwala si kuluta deli bikaligasi. ");
INSERT INTO kij_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","E baisa bivigaki kwaiveka valam olopola Itipita, avaka gala eigisaisi igau omitibogwa, deli goli igau gala tuvaila bigisaisi. ");
INSERT INTO kij_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mitaga gala sitana natana kaukwa paila bikagoti mina Isireli kainaga si mauna. E oluvi bukunikolaisi kidamwa yeigu Guyau balivi mina Itipita deli mina Isireli.’” ");
INSERT INTO kij_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","E Mosese ivigimkulovi la bigatona baisa makawala, “Mi tosikwawa komwaidosi bimakaiagusi bikavaginasi baisa yeigu, e komwaidosi wala biyokakapisisi baisa yeigu, kidamwa bakau ulo tomota e bakasilavaisi. E oluvi tutala lalagi si nigada, yeigu bogwa basilavaimi.” E deli kala leiya Mosese isilavi guyau. ");
INSERT INTO kij_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Guyau Yaubada leiluki Mosese kawala, “Matauna guyau tuvaila gala wala binakaigalaim, e baisa bavigaki tuvaila wala uula kidamwa bakatumkulovi ulo kabutuvatusi olumoulela mapilana Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosese sola Eroni ivagaisi komwaidona kabutuvatusi makwaisina omatala guyau matauna, mitaga Yaubada tuvaila iviyelu nanola ivigaki kala kasai dabala, e gala bitugwali mina Isireli bisilavaisi la valu. ");
INSERT INTO kij_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Guyau iluki Mosese sola Eroni mapilana Itipita, ");
INSERT INTO kij_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","kawala, “Baisa minana tubukona bukuvigakaisi kala vitouula baisa yokomi paila taitu taitu. ");
INSERT INTO kij_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kukwatululutaisi komwaidosi kala boda mina Isireli baisa makawala. Minana tubukona yamla kweluwotala, tau taitala taitala binagi kaina natana lam kainaga natubovau gota paila la bwala kala tosisu bikamsi. ");
INSERT INTO kij_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","E kidamwa ola kaukweda gala ibawasi tomota paila bikomasi namwaidona minana mauna, e matauna bikau kwaiyuwela bwala baisa otalila la bwala kidamwa bivilaisi natana mauna, e bikalawaisi tomota kasi bawa makawala kala vilavila taitala taitala avaka ibodi bikamsi. ");
INSERT INTO kij_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","E ibodi bukunagaisi kaina sipi kainaga gota, mitaga ibodi wala natana namwala kala taitu kwaitala, gala isim kala nebaneba kaina kala kapwaila. ");
INSERT INTO kij_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","E yamla kweluwotala kwaivasila minana tubukona, e koyavila wala komwaidosi kala boda mina Isireli bikatumataisi kasi mauna. ");
INSERT INTO kij_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","E mauna minasina igau makateki bikomasi osi bwala, mitaga ikugwa bikauwaisi sitana buyavila kasi mauna e bikumasi wa lulu okokolela deli odabala. ");
INSERT INTO kij_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Bogi wala makwaina bigabwaisi minana vilionela e bikamsi, e kasi gwaba bikamsi lokwai yaiyayana, e deli bikamsi beredi gala isim kala yisi. ");
INSERT INTO kij_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Mitaga gala bikomasi geyata kaina bisulusulusi avaka bikamsi. Mitaga bigabwaisi wala namwaidona, deli kununa, kaikena, deli goli komwaidona luguloguva isisuaisi olumoulela minana. ");
INSERT INTO kij_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Gala ibodi bikobogaisi avaka mwada bikaboyuva. Mitaga avai kobwaga isisu ibodi wala bidokaisi wawa bigabwaisi. ");
INSERT INTO kij_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ikugwa bukusikamsi avaka bibodi paila loula, deli kaikemi katubukolela e oyumami mi kaitukwa, e ibodaimi bukukommamalusi makawala. Baisa goli Luvapela Pakala bivigaki agu taimamila, yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Wa bogi makwaina yeigu baloya mapilana Itipita, bakatumati komwaidosi mina Itipita si kuluta tauwau deli si mauna si kuluta nammwala, e bamipuki komwaidona si yaubada mina Itipita. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Buyavi baisa isisu wa lulu okokolela, kabutuvatusi makwaina bikibuboti bwala makwaisina lokusisikaisi. Avai tuta bagisi buyavi, e baluvapela gala wala bayogagaimi wa yam makwaina bamipuki mina Itipita. ");
INSERT INTO kij_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ibodaimi yam makwaiwena bukukikilaisi bukuvigakaisi kwaitala tapwaroru pakala, kidamwa biyoluluwaiyaimi paila yeigu Guyau avaka bogwa lavagi. Baisa bivigaki mi kaboluluwai tuta komwaidona igau tuta bima.” ");
INSERT INTO kij_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","E Guyau ikaibiga kawala, “Kwailima kwaiyu yam yokomi gala bukukomasi avai beredi eigabwaisi deli kala yisi. Mitaga ibodi bukukwamsi wala beredi gala deli kala yisi. Yam makwaisina kala vitouula komwaidona yisi bukuligaiwaisi, e gala kwaitala bisisu omi bwala. Paila ka - kidamwa availa bikam beredi deli kala yisi olumoulela kwailima kwaiyu yam makwaisina, yokomi gala wala ibodaimi bukudokaisi matauna taitala ulo tomota. ");
INSERT INTO kij_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","E yam kala vitouula, deli tuvaila kwailima kwaiyuwela yam, yokomi ibodi bukusigugulasi paila tapwaroru. Gala kwaitala paisewa bukuvagaisi olumoulela makwaisina yam kwaiyu, mesinaku wala bukuvakapulasi kʹami. ");
INSERT INTO kij_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","E bukuvagaisi makwaina paka, paila wa yam makwaina yeigu Guyau lavisunupuloiyaimi metoya mapilana Itipita. E taitu taitu bukukwabomaisi yam makwaina yamla paka. ");
INSERT INTO kij_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","E minana tubukona namatala, e koyavila kweluwotala kwaivasila bila koyavila kweluwoyu kwaitala yam, yokomi gala bukukomasi beredi eigabwaisi deli yisi. ");
INSERT INTO kij_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","E wa yam kwailima kwaiyu galaga bitabani yisi omi bwala. Paila kidamwa availa, kaina tolivalu kainaga togilagala, bikam beredi deli kala yisi wa yam makwaisina, yokomi gala wala ibodaimi bukudokaisi matauna taitala ulo tomota.” ");
INSERT INTO kij_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","E Mosese idou mina Isireli kasi tokugwa komwaidosi, e iluki matausina, kawala, “Ka, taitala taitala yokomi bukunagaisi lam kaina gota natubovau e bukukwatumataisi paila tosisula mi bwala bipakasi Luvapela Pakala. ");
INSERT INTO kij_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","E kasaikuku okukoyasi deli sisitala silumwaiya, kuvidagwaisi wa bolu makwelana okutavikotaisi buyavila mauna, e kusobaisi wa lulu okokolela deli okaitaula odabala lulu, e ka! - gala taitala bisilavi bwala bogi kwemwaidona bila biyam. ");
INSERT INTO kij_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","E avai tuta Guyau biloya Itipita bikatumati matausina mina Itipita, e bogwa bigisi buyavi okokola deli okaitaula, e gala bitagwala Anelosi Tokwatumata bisuvi omi bwala paila mwada bikatumataimi. ");
INSERT INTO kij_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","E ka, makwaisina karaiwaga tuta komwaidona bukukwabikaulasi wala, yokomi deli goli litumia. ");
INSERT INTO kij_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","E avai tuta bukuviloubusisi ovalu makwaina avaka Guyau bogwa eikatotila bisakaimi, e ibodaimi bukuvigakaisi makwaina kami gulogula. ");
INSERT INTO kij_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","E matutona litumia bikatupoiyaimi kawasi, ‘Avakaga kala katumiki kada gulogulasi makwaina?’ ");
INSERT INTO kij_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","e yokomi bukuvitakaulokaisi kawami, ‘Baisa eivigaki da lulasi Luvapela, e baisa makawala tatemmalaisi Guyau, paila eiluvapela osi bwala mina Isireli mapilana Itipita. E eikatumati mina Itipita, mitaga tubudoiasi eikoli wala matausina.’” E tuta matutona mina Isireli itapopula kaikesi ikavaginasi. ");
INSERT INTO kij_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","E oluvi ilosi ivagaisi makawala Guyau eikaraiwogi Mosese sola Eroni bivagaisi. ");
INSERT INTO kij_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Olubulotoula goli, Guyau ikatumtuwoli tauwau si kuluta mina Itipita, ivitouula si guyau la kuluta tau, mwada matauna kaimapula tamala la kabokwaraiwaga, e ila ivigimkulovi baisa availa matauna eitokwatupipi isisu obolela katupipi, e matauna tuvaila la kuluta tau ikatumati. E tuvaila goli komwaidona si mauna kuluta nammwala ikatumati. ");
INSERT INTO kij_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Wa bogi makwaina guyau, deli la tosikwawa deli goli mina Itipita komwaidosi imamatasi. E viloumwaidona Itipita ikaligiaki valam kwaiveka, paila bwala kwaitala kwaitala isim tomatela tau. ");
INSERT INTO kij_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Wa bogi makwaina wala guyau idou Mosese sola Eroni, e iluki matausina kawala, “Nani kulosi, yokomi deli mi tomota mina Isireli! Kusilavaisi ulo valu. Kulosi bukutapwarorusi baisa Guyau, makawala avaka mi nigada. ");
INSERT INTO kij_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Kuvadelisi mi sipi, mi gota, deli mi bulumakau e kusunapulasi. Tuvaila anigadaimi bukunigadasi baisa mi Yaubada kidamwa bimitukwaiyaigu.” ");
INSERT INTO kij_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","E mina Itipita ikammalaisi tomota binanakwasi bisilavaisi valu, e ikaibigasi kawasi, “Komwaidomasi bakakaligasi kidamwa gala bukusilavaisi baisa.” ");
INSERT INTO kij_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Mapaila mina Isireli eivilugwaisi kasi beredi gala deli kala yisi okasi kavayega, e ikapolaisi makwelasina okasi karekwa isailisi ovilavasi ilosi. ");
INSERT INTO kij_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","E mina Isireli bogwa eivagaisi avaka Mosese eiluki, paila einigadaisi mina Itipita mwada bisakaisi goula deli siliba deli goli karekwa. ");
INSERT INTO kij_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","E Guyau eiviyelu ninasi mina Itipita kidamwa bitemmalaisi mina Isireli e bisakaisi makawala osi nigada. E mapaila baisa makawala mina Isireli eikauwaisi mina Itipita si veiguwa. ");
INSERT INTO kij_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","E mina Isireli ilolosi isilavaisi Ramesa bilosi Sukota. E tauwau komwaidosi kasi bawa 600,000 e deli goli vivila e gugwadi. ");
INSERT INTO kij_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","E saina bidugaga tuwoli tomota ilosi deli, e tuvaila bidubadu sipi, gota e bulumakau deli ilauwaisi. ");
INSERT INTO kij_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Igabwaisi kasi beredi gala deli kala yisi, avaka eikeulasi imaiyaisi metoya mapilana Itipita. Paila mina Itipita saina nanakwa eiyabaisi matausina, e tutala eisilavaisi Itipita gala wala gagabila bikatubiasaisi kasi kalaga. Deli gala isim tuta bibodi bikepupolaisi pwarawa deli yisi kidamwa bilelia bimila bereditoula deli kala yisi. ");
INSERT INTO kij_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Mina Isireli eisisuaisi mapilana Itipita kwelakatuvasi kweluwotolu taitu. ");
INSERT INTO kij_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","E wa yam makwaina kwelakatuvasi kweluwotolu taitu kala vigimkovila, Guyau la tomota dalesi komwaidona isilavaisi Itipita. ");
INSERT INTO kij_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","E wa bogi makwaina Guyau eiyausi la tomota kidamwa bivisunupuloi metoya mapilana Itipita. E mapaila taitu taitu takabomi bogi makwaiwena baisa Guyau. Paila wa bogi makwaina mina Isireli kasi gulogula ibodi wala biyuuyausasi. ");
INSERT INTO kij_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Guyau iluki Mosese sola Eroni kawala, “Makwaisina karaiwogala Luvapela Pakala. Gala taitala togilagala bikam kalagila Luvapela Pakala. ");
INSERT INTO kij_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Mitaga kidamwa taitala mi ula bogwa lokumapu isim kala bobu, matauna ibodi wala bikam. ");
INSERT INTO kij_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Gala taitala tosiwosa kaina availa lokukwabutu bikam wa paka. ");
INSERT INTO kij_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","E kʹami bukukwamsi olumoulela wala bwala makwaina lokukwatubiasaisi, gala bukusunupulovaisi okoukweda. E gala bukukouwolaisi kaitala totuwanela mauna. ");
INSERT INTO kij_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","E komwaidosi mina Isireli ibodi wala bipakasi paka makwaina. ");
INSERT INTO kij_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Mitaga tau matauna gala isim kala bobu gala ibodi bikam. Kidamwa taitala togilagala eimilivalu deli yokomi e saina magila bivagi Luvapela Pakala paila kala taimamila Guyau, bikugwa bukubobwaisi komwaidosi tauwau ola bwala. E oluvi bukuvigakaisi matauna makawala taitala wala yokomi mina Isireli, e ibodi wala bivagi paka makwaina. ");
INSERT INTO kij_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Karaiwaga makwaina bisisu wala paila tolivalu mina Isireli deli paila togilagala availa availa eimilivalu deli yokomi.” ");
INSERT INTO kij_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","E komwaidosi mina Isireli ikabikaulasi e ivagaisi avaka Guyau eikaraiwogi Mosese sola Eroni. ");
INSERT INTO kij_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","E yam makwaina wala Guyau ikatusunupulovi mina Isireli dalesi metoya Itipita. ");
INSERT INTO kij_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Kukwabomi komwaidona kuluta tauwau baisa yeigu, paila kuluta taitala taitala tauwau mina Isireli deli kuluta natana natana mauna baisa ulo vavagi.” ");
INSERT INTO kij_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mosese iluki tomota kawala, “Ibodi bukululuwaisi yam makwaina - yam makwaina lokusilavaisi Itipita, mavilouna goli eivigakaimi si ula. Makwaina yam eikatusunupuloiyaimi metoya ola peuligaga. Mapaila gala bukukwamsi beredi deli kala yisi. ");
INSERT INTO kij_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Yokomi lokusilavaisi wa yam makwaina olopola tubukona namatala, tubukona yagala Abibi. ");
INSERT INTO kij_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Guyau ikatotila baisa tubumia bisakaimi si valu mina Kenani, mina Itai, mina Amora, mina Ivi deli mina Yebusi. Avai tuta biviloubusiaimi oviluwela maliapwasa deli kwabilela kubilimalala, ibodaimi bukupakasi paka makwaina olopola tubukona namatala taitu kwaitala kwaitala. ");
INSERT INTO kij_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yokomi bukukwamkwamsi beredi gala deli kala yisi biboda kwailima kwaiyu yam. E oyamla kwailima kwaiyuwela yokomi bukuvagaisi kwaitala paka paila kala taimamila Guyau. ");
INSERT INTO kij_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Biboda kwailima kwaiyu yam yokomi gala bukukwamsi beredi deli kala yisi. Gala bibodi yisi, kaina beredi deli kala yisi, bisisu ambaisa omi valu. ");
INSERT INTO kij_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","E avai tuta bukuvitouulasi paka, ibodi bukukwamitububulaisi baisa litumia kuuvagaisi paila komwaidona vavagi makwaisina avaka Guyau leivagi paila yokomi avai tuta lokusilavaisi Itipita. ");
INSERT INTO kij_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","E paka makwaina bivigaki mi kaboluluwai, makawala kwaitala kwasi oyumami kaina sedabala odubami. Vavagi makwaina bikatululuwaiyaimi kidamwa Guyau la karaiwaga bukuvigakaisi kami wosi, paila Guyau matauna eikatusunupuloiyaimi mapilana Itipita metoya ola peuligaga. ");
INSERT INTO kij_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Mapaila taitu kwaitala kwaitala bukukibubotaisi okweluvala makawala, ibodi bukuvagaisi paka makwaina. ");
INSERT INTO kij_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“E Guyau igau bilauwaimi osi valu mina Kenani, valu makwaina eikatotila baisa yokomi deli tubumia. Avai tuta matauna bisakaimi, ");
INSERT INTO kij_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","e yokomi bukusemakavaisi komwaidosi mi kuluta tauwau baisa Guyau. E komwaidona kuluta mi mauna namwala, baisa Guyau wala la vavagi. ");
INSERT INTO kij_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mitaga ibodi wala bukugimolivauwaisi metoya baisa matauna, minana ase kuluta nammwala, bukusakaisi natana lam kaimapula ase. Kidamwaga gala magimi bukugimolivauwaisi minana ase, e kukwapitunaisi kaiyola. E ibodi wala bukugimolivauwaisi komwaidona mi kuluta tauwau. ");
INSERT INTO kij_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Tuta oluvi, avai tuta litumia bikatupoiyaimi avaka kala katumiki gulogula makwaina, e yokomi bukuvitakaulokaisi kawami, ‘Metoya ola peuligaga Guyau ikatusunupuloiyaimasi metoya Itipita, valu makwaina eivigakaimasi si ula. ");
INSERT INTO kij_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Avai tuta guyoula Itipita ikasai dabala deli gala itagwala bikilavaimasi bakalosi, mapaila Guyau ikatumati komwaidona si kuluta tauwau deli si mauna nammwala olopola Itipita. Baisa uula da maunasi kuluta nammwala tavigakaisi lula baisa Guyau, mitaga tagimolivauwaisi da kulutasi tauwau. ");
INSERT INTO kij_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Makwaina paka bivigaki da kaboluluwaisi makawala kwasi oyumadaisi, kaina sedabala odubadaisi, baisa ikatululuwaiyaidasi paila Guyau ola peuligaga eikatusunupuloiyaidasi metoya Itipita.’” ");
INSERT INTO kij_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","E kadatala kaduvapoi bisuwa okawolawa bila Pilisitia. Mitaga tuta makwaina guyoula Itipita bogwa itugwali mina Isireli bilosi, Yaubada gala isuwalai matausina bilosi makadana keda. Yaubada inanamsi, “Igau avai tuta bigisaisi kidamwa bikabiliasi, e gala magigu bikivilivauwaisi si nanamsa e bikaimilavausi mapilana Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","E mapaila Yaubada isuvili matausina e isuyeiwa oluwalela viloupakala, bilokaia Bolita Pilabweyani. E mina Isireli ikabiyumalaisi si guguwa paila kabilia. ");
INSERT INTO kij_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mosese ikau wowola Yosepa e deli ilauwaisi, makawala goli avaka Yosepa bogwa eiluki mina Isireli bikatotilasi mokwita bivagaisi nanola. Paila Yosepa bogwa eikaibiga kawala, “Avai tuta Yaubada bitanekwaimi metoya valu makwaina, bukukwauwaisi wowogu e deli bukulauwaisi.” ");
INSERT INTO kij_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Mina Isireli isilavaisi Sukota, e ilosi bibudaisi si kabosikaiwa mapilana Esam omatala viloupakala. ");
INSERT INTO kij_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Wa yam, Guyau bilobogwa omitasi matausina metoya kaitala lowa, paila bivituloki si keda. E wa bogi, bilobogwa omitasi tomota makawala mitaga bidavila migila bimila kova, paila bisimitali matausina, e igagabila goli matausina bililoulasi wala yam deli bogi. ");
INSERT INTO kij_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tuta komwaidona makaina lowa ikukugwai wala omitasi tomota wa yam, e makawala goli ivigaki makovana kova wa bogi. ");
INSERT INTO kij_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","E oluvi Guyau iluki Mosese, kawala, ");
INSERT INTO kij_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Kuluki mina Isireli bikeiitasi bilosi bibudaisi si kabosikaiwa omatala mapilana Pi Airota oluwalaisi Migadoli deli Bolita Pilabweyani katitaikinela Beali Seponi. ");
INSERT INTO kij_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","E guyoula Itipita bidoki kaina mina Isireli ititavinasi baisa mapilana e viloupakala itobodi mitasi. ");
INSERT INTO kij_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Igau yeigu bavigaki matauna guyau bikasai dabala, e matauna bibokavilaimi, e mapaila batomgwaga odubasi matauna guyau deli la tokwabilia, bivigaki agu taimamila. E matausina mina Itipita binikolaisi yeigu goli Guyau.” Mapaila mina Isireli ivagaisi makawala avaka bogwa leiluki. ");
INSERT INTO kij_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Avai tuta ilukwaisi guyoula Itipita kidamwa matausina tomota bogwa leisakaulasi, e matauna deli la tosikwawa ikivilaisi ninasi, e ikaibigasi kawasi, “Avaka leitavagaisi? Bogwa tatugwalaisi mina Isireli eisakaulasi leilosi, deli goli bogwa takitumouwaisi da ulasi!” ");
INSERT INTO kij_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","E guyau ikatubiasi la waga kaibibiu wogala kabilia, deli la tokwabilia. ");
INSERT INTO kij_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","E ikatuwakeda deli komwaidona la waga kaibibiu, deli goli makaisina kaimatala lakatulima lakatutala. E mabudona isim kasi kumatoula. ");
INSERT INTO kij_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","E Guyau Yaubada ivigaki guyoula Itipita ikasai dabala, e ibokavili mina Isireli, tutala isilavaisi valu ilosi deli wala si mwasawa. ");
INSERT INTO kij_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Mabudona mina Itipita si tokwabilia, deli komwaidona wosa deli waga kaibibiu deli tokwabikuliga, ibokavilaisi imaisi isakailasi matausina ambaisa eibudaisi si kabosikaiwa, okawolawa Bolita Pilabweyani baisa katitaikinesi Pi Airota deli Beali Seponi. ");
INSERT INTO kij_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Avai tuta mina Isireli igisaisi guyoula Itipita deli la tokwabilia eimakaiasi matausina, e ivigaki kasi kokola sainela, e idousi baisa Guyau mwada bikoli matausina. ");
INSERT INTO kij_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","E ilukwaisi Mosese kawasi, “Kaina goli gala kama lakasi olumoulela Itipita kadai? Lokumaiyaimasiga baisa oviloupakala mwada bakakaligasi ke? Ka, kugisi avaka lokuvigakaimasi tutala kusunupuloiyaimasi metoya mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ki, kaina gala kalukibogwaimsi igau gala bitasilavaisi mapilana Itipita paila pakula makwaina biviloubusi baisa yakamaisi? “Bogwa kalukwaimsi ibodi bukuligaiwaimasi wala si ula mina Itipita. Baisa bwaina wala kidamwa bakasisuaisi ula wala, e gala wala bwaina kidamwa bakakaligasi baisa oviloupakala!” ");
INSERT INTO kij_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","E Mosese ivitakaula kawala, “Gala bukukokolasi. Bitau uwomi e bukugisaisi avaka Guyau bivagi kidamwa bikolaimi lagaila. Yokomi gala tuvaila bukugisaisi matausina mina Itipita. ");
INSERT INTO kij_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","E Guyau Yaubada bikabilia deli matausina mina Itipita paila yokomi, e yokomiga gala bikaiki uwomi avaka bukuvagaisi.” ");
INSERT INTO kij_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Guyau iluki Mosese, kawala, “Mwa! Avaka paila yoku kudoudou paila pilasi? Kuluki tomota bivasekalasi. ");
INSERT INTO kij_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","E kulokowoi m kwaitukwa odabala bolita, e sopi bitabai e igagabila mina Isireli biloulasi makawala oyabala oluwalela bolita. ");
INSERT INTO kij_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mitaga mina Itipita bavigaki bikasai dubasi, e biyeikulaisi wala matausina, e tuvaila goli batomgwaga odubasi guyoula Itipita, la tokwabilia, la waga kaibibiu deli la tokwabikuliga, e makawala goli babani agu taimamila. ");
INSERT INTO kij_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","E avai tuta bakalisuwoli matausina e mina Itipita binikolaigusi yeigu wala Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","E Yaubada la anelosi makateki eikugwai si tokwabilia mina Isireli. E matauna itabai ikeiita otuboulosi. E tuvaila lowa makaina deli wala itabai, ");
INSERT INTO kij_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","e itowalai oluwalaisi mina Itipita deli mina Isireli. E lowa ivigaki dudubila baisa mina Itipita, mitaga lumalama ititapi baisa mina Isireli, e baisa uula mabudosina tokwabilia budoyu gala bivakatitaikinasi baisa sesia bogi kwemwaidona. ");
INSERT INTO kij_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","E Mosese ilokowoi yamala odabala sopi, e Guyau ivigaki yagila bomatu iuu e iwosau sopi itabai. Bogi kwemwaidona yagila eiuu itayuvisi sopi ilubulabu e imili yabala. Sopi eitavilevi ");
INSERT INTO kij_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","e mina Isireli iluvapelasi metoya oyabala e sopi ivigaki papala pilatala piliyuwela. ");
INSERT INTO kij_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mina Itipita ibokavilaisi ibokulaisi matausina oyabala oluwalela bolita, deli komwaidona si wosa, si waga kaibibiu deli tokwabikuliga. ");
INSERT INTO kij_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Bulubuvisiga Guyau ikululuki metoya makovana kova deli makaina lowa baisa mina Itipita si tokwabilia, e ivigaki kasi kokola saina kwevakaigaga. ");
INSERT INTO kij_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Tuvaila waga kaibibiu isonusi, mapaila ivigaki saina mwau paila bisakaulasi. E mina Itipita ikaibigasi kawasi, “Guyau Yaubada bogwa eipii mina Isireli e ibokavilaidasi. Wo! Bitabutusi, gala bitasisuaisi baisa!” ");
INSERT INTO kij_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","E Guyau iluki Mosese kawala, “Kulokowoi yamam odabala bolita, e sopi bikatukuluvi odubasi mina Itipita deli si waga kaibibiu e tuvaila kala tokwabikuliga.” ");
INSERT INTO kij_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mapaila Mosese ilokowoi yamala odabala sopi, e tutala bogwa eikikivi visiga, sopi ikaimilavau okabala makawala ikanabogwa. E mina Itipita ivigikonaisi bikayalaguvasi metoya wa sopi, mitaga Guyau iluvivau matausina ilosi obolita. ");
INSERT INTO kij_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Sopi ikaimilavau ikuboli komwaidona waga kaibibiu deli kala tokwabikuliga e tuvaila komwaidosi mina Itipita si tokwabilia, availa availa eibokulaisi mina Isireli obolita. Komwaidosi wala eidoumsi, gala kesa. ");
INSERT INTO kij_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mitaga mina Isireli iloulasi oyabala oluwalela bolita, e sopi ivigaki papala pilatala piliyuwela. ");
INSERT INTO kij_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Wa yam makwaina Guyau ikoli mina Isireli metoya oyumasi mina Itipita, e mina Isireli igisaisi matausina ikatupisau tokakaliga okawolawa. ");
INSERT INTO kij_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Avai tuta mina Isireli igisaisi ammakawala Guyau la peuligaga ikalisau mina Itipita, e ikukolaisi matauna. E idubumaisi Guyau, deli goli la touwata Mosese. ");
INSERT INTO kij_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Tuta baisa Mosese deli mina Isireli iwosisi mapilana wosi baisa Guyau, kawasi. “Bawosi baisa Guyau, paila matauna la tomgwaga saina kabokatubau. Paila bogwa ikatudoum tomota deli si wosa olumoulela bolita. ");
INSERT INTO kij_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Guyau matauna agu tokwala topeula wala. Matauwena wala eikatumovaigu. Matauna goli ulo Yaubada, e bayakawoli matauna. E matauna tamagu la Yaubada, e bawosi paila matauna Tovakaigaga. ");
INSERT INTO kij_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Guyau matauna kumatoula. Matauna goli yagala Guyau. ");
INSERT INTO kij_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“E mina Itipita si tokwabilia deli si waga kaibibiu eilavi ilosi olumoulela bolita. Dabala si wota eidoumsi oBolita Pilabweyani. ");
INSERT INTO kij_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Tulubwabwau ikuboli matausina, e isabwabulasi isalilisi watanawa makawala dakuna. ");
INSERT INTO kij_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“E Guyau, yamam kweyakakata saina kweyapapeula, e itutuvakau nanogu. Lokukwatudoum matausina tilaula. ");
INSERT INTO kij_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Kutomgwaga odubasi kam tilaula, e yoku goli giyouveka. Kam leiya ilululu saina nanakwa igibumkulovi matausina, makawala kovasupa nanakwa bigabu susupa. ");
INSERT INTO kij_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kuyuvisau bolita e sopi ila walakaiwa. Sopi ivigaki papala makawala kali, e sopi olopola bolita imili dakuna. ");
INSERT INTO kij_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tilaula matausina ikaibigasi kawasi, ‘Babokavili ayosi matausina. Bogwa bavili si veiguwa e bakau komwaidona avaka magigu. Babiigili ulo puluta e bakau komwaidona avaka avaka iyosisi.’ ");
INSERT INTO kij_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Mitaga ka, Guyau - sivatala wala kuyagisa, e mina Itipita ikanopulasi. Isalilisi makawala tanumnumta ilosi olopola bolita katuposilagi. ");
INSERT INTO kij_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Mwa, Guyau! Avai yaubada isisu makawala yoku? Availa goli makawala yoku Tobumaboma deli Towalakaiwa? Availaga gagabila bivagi kabutuvatusi deli kaboyowalula, makawala yoku m vavagi? ");
INSERT INTO kij_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Lokuyosali yamam kweyakakata e valu watanawa ilupoli kama tilaulasi. ");
INSERT INTO kij_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Lokukugwai matausina availa availa lokukoli, paila lokukwatotila makawala, e tokimadagi yoku! E metoya om peula lokuvakadi matausina eimaisi baisa om valu viloubumaboma. ");
INSERT INTO kij_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Boda ituwoli ituwoli ilagaisi e itatatuvasi deli kasi kokola. Mina Pilisitia ibulukukoli sainela. ");
INSERT INTO kij_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Tokugwala Edom tuvaila kasi kokola sainela. Mina Mowabi si topapeula bogwa itatatuvasi wala, e mina Kenani ikitumouwaisi si tuvaluwa. ");
INSERT INTO kij_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Saina kasi kokola eimitaki uwosi, paila bogwa eigisaisi yoku Guyau m peula, e imitaki uwosi gala gagabila bivagaisi avaka, igau tutala m tomota eidadelisi eilosi. Tomota matausina goli lokutaneku metoya okasi katupipi. ");
INSERT INTO kij_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","E lokumai matausina e lokubudi si valu om koya. Paila yoku Guyau lokunigibogwi makwaina paila m valu, baisa goli Bwala Kwebumaboma yoku titoulem lokukwaliai. ");
INSERT INTO kij_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mwa, Guyau! Yoku m guyau gala kala vigimkovila, bikanuvagasi wala.” ");
INSERT INTO kij_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","E mina Isireli ililoulasi olumoulela bolita baisa oyabala. Mitaga tutala mina Itipita si waga kaibibiu deli si wosa deli tokwabikuliga bogwa leimaisi obolita, e Guyau ikaimilivau sopi ikuboli matausina. ");
INSERT INTO kij_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","E minana navitoubobuta, minawena Eroni luleta yagala Miriam, ikau la sasani, deli komwaidosi vivila ibokulaisi minana, ikatugoregorasi si sasani, deli kaiwosisi. ");
INSERT INTO kij_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","E minawena Miriam iusiwosi paila minasina, kawala. “Kuwosisi baisa Guyau, paila matauna la tomgwaga saina kabokatubau. Paila matauna bogwa ilavi minasina wosa deli kala tosisila ilosi obolita.” ");
INSERT INTO kij_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","E Mosese ikugwai mina Isireli bisilavaisi Bolita Pilabweyani e bilosiga oviloupakala Sura. Kwaitolu yam ililoulasi oviloupakala, mitaga gala sitana sopi ibanaisi. ");
INSERT INTO kij_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Oluvi iviloubusisi kwaitala valu yagala Mara, mitaga sopi saina yayana gala gagabila bimomsi. Baisa uula idokaisi Mara. ");
INSERT INTO kij_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","E tomota ikavilavilasi ikatupoiyaisi Mosese, kawasi, “Avaka sitana bakamomsi?” ");
INSERT INTO kij_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mosese inigada peula baisa Guyau, e Guyau ivituloki matauna bubotala kai. E imai mabubona ilavi wa sopi, e sopi ikivili isumokainia. Mapilana valu Guyau isaiki mimilisi karaiwaga baisa matausina kidamwa bipilasi si sisu. E baisa tuvaila iwakoli matausina. ");
INSERT INTO kij_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Yaubada ikaibiga kawala, “Kidamwa bukukwabikuwolaigusi mokwita, e bukuvagaisi avaka duwosisia, deli bukukwabikaulasi ulo karaiwaga, e gala bamipukwaimi metoya wa lelia makwaisina avaka lamai baisa mina Itipita. Yeigu goli Guyau, kami tokatumova yeigu.” ");
INSERT INTO kij_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Oluvi imaisi Elim, e baisa isisuaisi kweluwotala kwaiyu utuwotu deli kailuwolima kailuwoyu pulopola. E baisa ibudaisi si kabosikaiwa opapala sopi. ");
INSERT INTO kij_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","E komwaidosi mina Isireli ivatuboulolasi metoya Elim e iviloubusisi oviloupakala idokaisi Sini, baisa olumoulela mapilasina Elim deli Sinai. Leisilavaisi Itipita e igau tubukona nayuwela wa yam kweluwotala kwailimala iviloubusisi mapilana viloupakala Sini. ");
INSERT INTO kij_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","E baisa oviloupakala komwaidosi itakulukulusi baisa Mosese sola Eroni, ");
INSERT INTO kij_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","e ikaibigasi baisa matausina kawasi, “Magimasi Guyau bogwa bikatumataimasi mapilana Itipita. Ka, mapilana Itipita gagabila bakasibwabwailasi e bakakamkwamsi kama gwabasi deli goli avai kaula tuvaila magimasi. Mitaga yoku lokumaiyaimasi baisa oviloupakala mwada molusaula bikimataimasi.” ");
INSERT INTO kij_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","E Guyau iluki Mosese kawala, “Baisa tuta bavagi kaula bikapusisi metoya wa labuma paila komwaidomi. E tomota bisunapulasi yam kwaitala kwaitala e bisewasi avaka bibodi paila yam kwaitala. E baisa makawala bawakoli matausina kidamwa bibokulaisi ulo katuloluta. ");
INSERT INTO kij_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Kwailima kwaitalelaga yam bisauwaisi avaka bibodi paila yam kwaiyu kalagila e bikatubiasaisi.” ");
INSERT INTO kij_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mapaila Mosese sola Eroni ilukwaisi komwaidosi mina Isireli kawasi, “Koyavi lagaila bukunikolaisi kidamwa Guyau matauna eisunupuloiyaimi metoya mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","E nabwaia kaukwau bukugisaisi Guyau migila saina guyugwayu. Bogwa einakaigali mi takulukulu baisa matauna. Baisa mokwita wala kutakulukulusi baisa Guyau, paila yakama kakabikuwoli wala la karaiwaga.” ");
INSERT INTO kij_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","E oluvi Mosese ikaibiga kawala, “Baisa Guyau matauna bisakaimi kami gwaba paila bukukwamsi ikoyavi, e bisakaimi beredi avaka magimi kala bidubadu kaukwau kwaitala kwaitala, paila bogwa einakaigali ammakawala kala siniveka mi takulukulu baisa matauna. Avai tuta lokutakulukulusi baisa yakama, baisa mokwita wala kutakulukulusi baisa Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","E Mosese iluki Eroni kawala, “Kuluki komwaidosi mina Isireli bimaisi bitogugulasi omatala Guyau, paila bogwa eilagi si takulukulu.” ");
INSERT INTO kij_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Avai tuta Eroni ililivala baisa matausina, itovilakaisi oviloupakala, e gala imomwa Guyau la lumalama saina guyugwayu iyoulapula olowalowa. ");
INSERT INTO kij_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Bogwa lalagi si takulukulu mina Isireli. Kuluki matausina avai tuta biyoyowa pali, bogwa bikauwaisi kasi gwaba bikamsi, e biyam kaukwau bikauwaisi beredi avaka magisi kala bawa. E binikolaisi kidamwa yeigu wala Guyau si Yaubada.” ");
INSERT INTO kij_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","E odubilikoyavi, yuwotala yuwoveka gogoila itapulolousi imaisi ibodi wala bikubolaisi si kabosikaiwa. E eiyam kaukwau numla ikuboli kabosikaiwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Avai tuta kalasia iyuwoula itumililabu valu, e kwaitala vavagi kwesisikwa deli kwepatata odabala pwaipwaia ikanukwenu. E saina gagabila kala kivisi. ");
INSERT INTO kij_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Avai tuta mina Isireli igisaisi, gala inikolaisi avaka baisa. E ikatupoisi baisa taitala taitala kawasi, “Avakaga baisa?” E Mosese iluki matausina, kawala, “Baisa kaula Guyau eisakaimi paila bukukwamsi. ");
INSERT INTO kij_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Guyau eikaraiwaga kidamwa taitala taitala bisewa avaka magila kala bidubadu bibodi la bwala kala tosisu, kwelayu bolu paila taitala taitala.” ");
INSERT INTO kij_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Mina Isireli ivagaisi makawala, taivilesi isosewasi bidubadu e taivilesi isosewasi pikekita. ");
INSERT INTO kij_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Avai tuta ivisaikolaisi, availa matausina isauwaisi bidubadu, baisa eibodi matausina, e availa eisauwaisi pikekita, tuvaila bogwa wala eibodi. Taitala taitala bogwa leisewa avaka kala bidubadu magila. ");
INSERT INTO kij_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","E Mosese iluki matausina, kawala, “Gala taitala bikatuyumali paila nabwaia.” ");
INSERT INTO kij_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mitaga taivilesi gala inakaigalaisi Mosese e isaimwaisi sitana. E eiyam kaukwau ikasewoki mwatemwata deli saina bogina. Mapaila Mosese igibuluwa baisa matausina. ");
INSERT INTO kij_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kaukwau kwaitala kwaitala e taitala taitala bisewa avaka kala bidubadu magila. E avai tuta kalasia saina tiganini, avaka kesala opwaipwaia komwaidona isosu. ");
INSERT INTO kij_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","E kwailima kwaitalelaga yam isauwaisi avaka bibodi paila yam kwaiyu kalagila, kala bidubadu kaula makawala kwelavasi bolu paila taitala taitala. E komwaidona tokugwa imaisi ilukwaisi Mosese makawala, ");
INSERT INTO kij_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","e Mosese iluki matausina kawala, “Guyau eikaraiwaga kidamwa nabwaia yam kwebumaboma yamla vaiwasi e eikabomi paila titoulela. Kugabwaisi avaka magimi bukugabwaisi e kusulusi avaka magimi bukusulusi. Avaka kesa kukwatuyumalaisi bikanam paila nabwaia.” ");
INSERT INTO kij_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Makawala Mosese eikaraiwogi, ikatuyumalaisi avaka kesa paila yam kwaiyuwela. Gala igaga e mwatemwata gala isuki olumoulela. ");
INSERT INTO kij_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosese ikaibiga kawala, “Kukomasi baisa lagaila, paila lagaila yam sabate yamla vaiwasi, e gala bukubanaisi tuvaila kaula otalila kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Kwailima kwaitala yam ibodaimi bukusewasi k ʹami, mitaga kwailima kwaiyuwelaga yam yamla vaiwasi, e Guyau gala wala biwitali k ʹami.” ");
INSERT INTO kij_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","E kwailima kwaiyuwelaga yam mimilisi tomota isunapulasi ilosi bisewasi k ʹasi. Mitaga gala wala sitana ibanaisi. ");
INSERT INTO kij_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Mapaila Guyau iluki Mosese kawala, “Ammakawala kala woloula bukukoulovaisi ulo karaiwaga? Wooi! ");
INSERT INTO kij_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bukululuwaisi kidamwa yeigu Guyau lasakaimi kwaitala wala yam mi yam vaiwasi. E baisa uula kwailima kwaitalelaga yam basisakaimi kaula avaka bibodi paila kwaiyu yam. E kwailima kwaiyuwelaga yam taitala baisa taitala ibodi bisisu ambaisa eisisiki e gala bisilavi la kabosisu.” ");
INSERT INTO kij_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Mapaila tomota gala ivagaisi avai paisewa wa yam makwaina. ");
INSERT INTO kij_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","E mina Isireli idokaisi kaula makwaina yagala mana. Kala gigisa makawala kwaitala waituna kwekekita kwepupwakau, e kala kamkona makawala kaula taseguliki deli kitorina. ");
INSERT INTO kij_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","E Mosese ikaibiga kawala, “Guyau bogwa eikaraiwogaidasi paila bitakatuyumalaisi sitana mana e bitayamataisi paila tubudoiasi igau tuta oluvi, kidamwa gagabila bigisaisi kaula makwaina avaka Guyau isakaidasi paila bitakamkwamsi oviloupakala, tuta matutona eivisunupuloiyaidasi metoya mapilana Itipita.” ");
INSERT INTO kij_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","E Mosese iluki Eroni kawala, “Kukwau yatala yakweya e kusewoya makawala kwelayu bolu mana olumoulela, e kusaili Guyau omatala, bisisu paila tubudoiasi igau tuta oluvi.” ");
INSERT INTO kij_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","E mapaila Eroni isaili omatala makwaina Kabutu Didawogala, e gagabila biyamataisi, makawala goli Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Mina Isireli eikamkwamsi wala mana eiboda kweluwovasi taitu tatoula wala iviloubusisi mapilana Kenani. E baisa imili valusi. ");
INSERT INTO kij_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ka, kwelaluwoyu bolu bibodi bivakasauwaisi yatala si yakweya.) ");
INSERT INTO kij_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Komwaidona mina Isireli isilavaisi viloupakala Sini isipeipelasi ilosi ambaisa ambaisa, makawala la karaiwaga Guyau. E ibudaisi si kabosikaiwa Repidim, taga kwaitala vavagi, gala sopi baisa paila bimomsi. ");
INSERT INTO kij_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mina Isireli ikavilavilasi baisa Mosese kawasi, “Kusakaimasi sopi bakamomsi.” Mosese ivitakauloki, kawala, “Avaka paila kukwavilavilasi? Avaka paila kudokaisi bukuwakolaisi Guyau?” ");
INSERT INTO kij_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Taga tomota saina wala kasi daka, e tuvaila wala isetuwoli si kavilavila baisa Mosese kawasi, “Avaka uula lokumaiyaimasi metoya Itipita? Ki, nanom mwada daka wala bikimataimasi deli litumaiasi deli ma bulutuvalusi?” ");
INSERT INTO kij_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mosese inigada peula baisa Guyau ikaibiga kawala, “Avaka ibodi bavagi paila matausina tomota? Bogwa katitaikina biwaigusi odakuna.” ");
INSERT INTO kij_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Guyau iluki Mosese kawala, “Kuvakouli mimilisi mina Isireli kasi tokugwa deli yoku, e bukukugwasi tomota omitasi. Kukwau kaitukwa deli, makaina lokuwaiya Waya Naili. ");
INSERT INTO kij_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","E yeigu batobogwa odabala kwaitala dakuna wa Koya Sinai. E ka! - bukuwaiya dakuna metoya om kwaitukwa e sopi bisunapula paila tomota bimomsi.” Mosese bogwa ivagi makawala omitasi kasi tokugwa mina Isireli. ");
INSERT INTO kij_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","E makatupona valu idokaisi yagala Masai deli Meriba. Paila baisa mina Isireli si kavilavila, deli eiwakolaisi Guyau tuta matutona eikatupoisi kawasi, “Kaina Guyau deli yakidasi kaina gala?” ");
INSERT INTO kij_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Tuta makwaina mina Amaleki leimaisi ikabiliasi deli mina Isireli mapilana Repidim. ");
INSERT INTO kij_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","E Mosese iluki Yosuwa kawala, “Mwa! Kunagi mimilisi tomota e nabwaia kulokaiasi mina Amaleki e deli bukukwabiliasi. Yeigu batotu odabala makwaina koya e baiyosi kaitukwa makaina avaka Yaubada eilukwaigu bakau.” ");
INSERT INTO kij_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosuwa ivagi makawala avaka Mosese eiluki, e isunapulasi bikabiliasi deli mina Amaleki. E Mosese, Eroni deli Ura ilokaiasi koya makwaina odabala. ");
INSERT INTO kij_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","E avai tuta Mosese yamala biyosali walakaiwa, e mina Isireli bipeulasi. Mitaga avai tuta yamala bisaili watanawa, e mina Amaleki bipeulasi. ");
INSERT INTO kij_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","E mapaila tuta matutona Mosese yamala bogwa eitubega, Eroni sola Ura imaiyaisi dakuna paila matauna bisila. E itolisi okanivala e iyosalaisi yamala Mosese, e matausina iyosisi wala tatoula kalasia eisalili. ");
INSERT INTO kij_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","E makawala goli Yosuwa itomgwaga ikalisau odubasi mina Amaleki. ");
INSERT INTO kij_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","E Guyau iluki Mosese, kawala, “Kugini bila wa buki ammakawala lokutomgwagasi paila kabilia makwaina, e baisa bivigaki kala kaboluluwai. E kuluki Yosuwa kidamwa bogwa babutugigai mina Amaleki.” ");
INSERT INTO kij_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","E Mosese ikaliai kwaitala kabolula e idoki yagala “Guyau Matauna ulo Doya.” ");
INSERT INTO kij_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","E ikaibiga kawala, “Kuyosalaisi la doya Guyau! Guyau bisaitaula bikabilia deli mina Amaleki, tuta gala biwokuva.” ");
INSERT INTO kij_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mosese yawala yagala Yetoro, matauna tolula guma Midiani, e matauna inakaigali bidubadu vavagi Yaubada eivagi paila Mosese deli la tomota mina Isireli matutona eikatusunupulovi matausina metoya Itipita. ");
INSERT INTO kij_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mapaila Yetoro ikoluluvi Siporai deli litula iuyoki tumasi Mosese, paila matausina eisiwaisi wala osi valu, ");
INSERT INTO kij_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","e litula taitala yagala Gerisom, e taiyuwela yagala Eliesa. (Mosese omitibogwa eilivala kawala, “Yeigu togilagala asivayaba oviloumitawasi.” Mapaila eivabu kala kavilevi e idoki latula molitomoya yagala Gerisom. ");
INSERT INTO kij_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","E tuvaila eikaibiga kawala, “Tamagu la Yaubada eipilasaigu deli eikolaigu metoya oyamala guyoula Itipita.” Mapaila eivabu molagwadi yagala Eliesa.) ");
INSERT INTO kij_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","E Yetoro sola Siporai deli litula magudisina ilokaiasi Mosese oviloupakala ambaisa leibudaisi kabosikaiwa okuvalila koya kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetoro iwitali biga ilokaia Mosese paila matausina bogwa eililoulasi bimakaiasi. ");
INSERT INTO kij_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mapaila Mosese ila ibodi yawala, itaimamila omatala, e iviyuwoli matauna. Kasitaiyu wala ililivalasi kidagala si sisu, oluvi isuvisi ola buliyoyova Mosese. ");
INSERT INTO kij_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mosese iluki Yetoro vavagi komwaidona avaka Guyau bogwa eivagi baisa mina Itipita deli si guyau paila bitaneku mina Isireli. Tuvaila Mosese iluki matauna paila mwau makwaisina tomota eibudobodasi otapwala keda e ammakawala Guyau eikoli matausina. ");
INSERT INTO kij_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Avai tuta Yetoro ilagi komwaidona baisa, saina imwasawa, ");
INSERT INTO kij_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","e ikaibiga kawala, “Kala yakaula Guyau, paila matauna ikolaimi metoya guyoula Itipita deli goli tomotala! Kala yakaula Guyau, matauna ikoli la tomota metoya oyumasi mina Itipita. ");
INSERT INTO kij_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","E bogwa lanikoli Guyau saina tovakaigaga odubasi komwaidosi yaubada, paila uula eivagi vavagi makwaisina matutona mina Itipita eilamidadaisi mina Isireli.” ");
INSERT INTO kij_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Oluvi Yetoro imai lula kwegubugabu, deli goli mimilisi semakavi paila bisemakavaisi baisa Yaubada, e Eroni deli komwaidosi tokaraiwogala Isireli ilosi deli Yetoro ikamsi okamkwam kwebumaboma paila kala taimamila Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","E eiyam, Mosese ikikimanum wala tomota si kominimani, e kaliyamveka wala, kaukwau, eiyayosa goli ibugiki. ");
INSERT INTO kij_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Avai tuta Yetoro eigisi komwaidona avaka Mosese eiuvagi matauna ikatupoi kawala, “Mwa, avaka baisa lokuuvagi paila tomota? E avaka paila kammwaleta wala lokuuwotetila makawala, e tomota eitomwaisi mapoulona kaukwau eibogiki?” ");
INSERT INTO kij_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosese ivitakaula kawala, “Ibodaigu wala bavagi makawala, paila tomota imakaiagusi magisi binikolaisi Yaubada nanola. ");
INSERT INTO kij_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Paila kidamwa taiyu tomota bikominimanisi, e yeigu banagi availa eikamokwita, oluvi baluki matausina Yaubada la biga deli la karaiwaga.” ");
INSERT INTO kij_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Oluvi Yetoro ilivala kawala, “Adoki gala kuvitububoti kidikedala mokwita. ");
INSERT INTO kij_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ka, igau bukusomata e makawala goli mabudona tomota. Wotetila makwaina saina vakaigaga kidamwa kammwaleta wala bukuuvagi. ");
INSERT INTO kij_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ka, ibodi bakayuvisi nanom, e Yaubada deli yoku. Ibodaim wala bukuvigakaim udosi m tomota omatala Yaubada deli bukukwamituli si kominimani baisa matauna. ");
INSERT INTO kij_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ibodaim bukuvituloki matausina avaka Yaubada la karaiwaga deli bukukwamitububuli baisa matausina ammakawala si kaisisu bibwaina deli avaka ibodi bivagaisi. ");
INSERT INTO kij_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","E tuvaila bakatumkulovi makawala, ibodi bukuyosi taivila tauwau tokatavatu, e bukunagi bikugwaiyaisi tomota. e matausina tokugwa, taivila bikugwaiyaisi lakatuluwotala, taivila lakatutala, taivila tailuwolima, taivila tailuwotala. E tokugwa matausina Yaubada kala todubumi mokwita, deli tomota idubumaisi matausina, e tuvaila matausina gala bikabikaulasi bikauwaisi avaka mwada katupatula udosi. ");
INSERT INTO kij_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ibodi matausina bukuvigaki bitokaraiwagasi paila tomota wa tuta komwaidona. Mitaga komwaidona pakula kwemomwau, ibodi wala bimiakaimsi, e makwaisinaga pakula kwekikekita ibodi matausina bikaraiwogaisi. Keda makadana bivigaki bigagabila baisa yoku, paila bukupaisewasi gulitinidesi. ");
INSERT INTO kij_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ka, kidamwa bukuvagi makawala, e makawala Yaubada bikaraiwaga, gala wala ibodi bukusomata, deli komwaidona matausina tomota eimati wala bikaimilavausi osi kaukweda deli si mwasawa paila si kominimani bogwa bimanum.” ");
INSERT INTO kij_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","E Mosese ivagi makawala Yetoro la biga, ");
INSERT INTO kij_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","e iyosi mimilisi tauwau tokatavatu metoya oluwalesi komwaidosi mina Isireli. E ivagi taivila bikugwaiyaisi lakatuluwotala, taivila lakatutala, taivila tailuwolima, taivila tailuwotala. ");
INSERT INTO kij_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Eivigaki matausina kasi tokaraiwaga tomota wa tuta komwaidona. Pakula kwevakaveka immiakaisi Mosese, mitaga kwekikekita ikaraiwogaisi titoulesi. ");
INSERT INTO kij_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Oluvi Mosese italoisi sola yawala, e Yetoro ikaimilavau ola valu. ");
INSERT INTO kij_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","E mina Isireli isilavaisi Repidim e leimaisi oviloupakala Sinai. E iviloubusisi baisa wa yam makwaina kala vitouula tubukona natolula metoya tuta matutona eisilavaisi Itipita. E baisa goli ibudaisi kabosikaiwa okaikela Koya Sinai. ");
INSERT INTO kij_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","E Mosese imwena wa koya paila bibodasi sola Yaubada. E Guyau idou baisa matauna metoya wa koya e iluki matauna kidamwa biluki mina Isireli, matausina Yekobe tubula, kawala, ");
INSERT INTO kij_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Ka! Bogwa kugisaisi avaka yeigu Guyau lavagi baisa mina Itipita, e ammakawala yeigu layamataimi makawala natana mluveka bilupi litula metoya opinupanela, e lamaiyaimi baisa. ");
INSERT INTO kij_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","E, kidamwa yokomi bukukwabikuwolaigusi deli bukuvagaisi ulo kabutu, e yokomi bavigakaimi ulo tomota tatougu. E komwaidona valu watanawa baisa yeigu wala ulo vavagi, mitaga yokomi bogwa lanagaimi paila ulo tomota. ");
INSERT INTO kij_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","E bukukwabomaimi titoulemi baisa yeigu agumwaleta, e bukuwotitalaigusi makawala tolula yokomi.” ");
INSERT INTO kij_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mapaila Mosese ibusi metoya wa koya e idou tokugwala tomota komwaidosi iluki matausina vavagi komwaidona avaka Guyau eikaraiwogi matauna. ");
INSERT INTO kij_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","E komwaidosi tomota ivitakaulokaisi kawasi, “Bogwa bakavagaisi komwaidona vavagi avaka Guyau eilivala.” E Mosese ikamituli makawala baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","E Guyau iluki Mosese kawala, “Yeigu bamakaiam metoya wa lowalowa saina pilapopou, e tomota bilagaida tabibigatona, e metoya wa tuta matutona bivigaki bidubumaimsi goli.” Mosese iluki Guyau avaka tomota eivitakaulokaisi, ");
INSERT INTO kij_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","e Guyau iluki matauna kawala, “Kulokaia tomota kuluki kidamwa ibodi lagaila deli nabwaia bikikilaisi titoulesi paila tapwaroru. Komwaidosi kasi kwama biwinaisi, ");
INSERT INTO kij_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","e bitutulaigusi paila bugiyu. Paila yam makwaina yeigu babusi odabala Koya Sinai, e baisa komwaidosi tomota gagabila bigisaigusi. ");
INSERT INTO kij_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","E kusaili tula okuvalila koya bitavina bitapatu baisa tomota gala bikayupailisi. E kuluki galaga bimwenasi wa koya kaina bilosi katitaikina. Kidamwa availa bivitouula mweimwena, bukukwatumataisi wala. ");
INSERT INTO kij_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kaina bukukwabidikunaisi kainaga bukubasaisi okaiyala, e taga availa bikabikoni matauna. Karaiwaga makwaina biboda tomota deli mauna, e kasi karaiwaga makawala wala, ibodi bukukwatumataisi. Mitaga ka, avai tuta tauya bitagina, e tuta matutona goli ibodi tomota bimwenasi wa koya.” ");
INSERT INTO kij_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Oluvi Mosese itobusi leima metoya wa koya, e iluki tomota bikatubaiasasi paila tapwaroru. E iwinaisi kasi kwama. ");
INSERT INTO kij_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","E Mosese iluki matausina kawala, “Bukukwatubaiasasi paila bugiyu, e wa tuta matutona gala bukukwanavaisi.” ");
INSERT INTO kij_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Kwaitolula yam kaukwau e pilapala, kavikavila, deli lowalowa pilapopou ikayounapula odabala koya e ilagaisi tauya butula itagilulu. E komwaidosi tomota okabosikaiwa itatuvasi deli kasi kokola. ");
INSERT INTO kij_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","E Mosese ivisunupuloi matausina metoya okabosikaiwa mwada bibodaisi Yaubada, e itolisi okuvalila koya. ");
INSERT INTO kij_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Komwaidona Koya Sinai ikuboli mseu, paila Guyau eibusi leima olopola kova. Mitaga mseu ititokaia makawala susupa wa dumia mseula, e tomota komwaidosi itatatuvasi saina siligaga. ");
INSERT INTO kij_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Mitaga butula tauya isiniveka e tuvaila isisiniveka. Mosese ilivala, e ka! - Yaubada bogwa leimapu matauna metoya opilapala. ");
INSERT INTO kij_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","E Guyau ibusi odabala Koya Sinai e idou Mosese bilokaia odabala koya. E mapaila Mosese imwena odabala, ");
INSERT INTO kij_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","e Guyau iluki matauna kawala, “Ka, kubusi kula kukwatululuti tomota taga biluvipeilisi tula mwada bimaisi bigisaigusi. Kidamwa bivagaisi makawala, bidubadu bikaligasi. ");
INSERT INTO kij_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Deli goli kidamwa matausina tolula bimaisi katitaikinegu ibodi bikikilaisi titoulesi. Kidamwa gala, e bogwa bamipuki matausina.” ");
INSERT INTO kij_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosese iluki Guyau kawala, “Tomota gala gagabila bimaisi baisa, paila kukwaraiwogaimasi mwada bakadokaisi koya kwebumaboma wala, e kidamwa bakasailisi tula bitavina bitapatu.” ");
INSERT INTO kij_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mitaga Guyau ivitakaula kawala, “Kubusi kulokaia Eroni e kamitaiyu kumakaiagusi. Mitaga tolula deli tomota gala biluvipeilisi tula mwada bimakaiagusi. Kidamwa bivagaisi makawala, e bogwa bamipuki matausina.” ");
INSERT INTO kij_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","E Mosese ibusi ilokaia tomota e iluki avaka Guyau eilivala. ");
INSERT INTO kij_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Yaubada bogwa eikaibiga, e la biga makawala baisa. ");
INSERT INTO kij_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Yeigu Guyau mi Yaubada, e bogwa lavisunupuloiyaimi metoya baisa Itipita, ambaisa lokuulasi. ");
INSERT INTO kij_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Gala bukutitapwaroru baisa avai yaubada mesinaku wala baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Gala bukuyouduli tokolu paila yoku mwada migila makawala avai vavagi isisuaisi wa labuma kaina ovalu watanawa kaina obolita osikowala valu watanawa. ");
INSERT INTO kij_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Gala bukutaimamila baisa avai tokolu, kaina bukutapwaroru omatala. Paila yeigu wala Guyau m Yaubada, e gala wala atagwala bukutapwaroru baisa availa mwada kaimapugu. Bamipuki matausina availa availa ipakaigusi deli tubusia e bilokaia tubutolusi deli tubuvasisi kasi tubwa. ");
INSERT INTO kij_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Mitaga bamitukwaii lakatuluwovila tubwa matubosina availa availa iyebwailigusi deli goli ikabikuwolaisi ulo karaiwaga. ");
INSERT INTO kij_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Gala bukukwagoli yagagu deli mitugaga nanamsela. Paila yeigu Guyau m Yaubada igau bamipuki availa availa matausina ikagolaisi yagagu deli mitugaga. ");
INSERT INTO kij_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Bukukwabikuwoli kala karaiwaga yam Sabate, e bukukwabomi yam makwaina. ");
INSERT INTO kij_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","M yam kwailima kwaitala isisu e baisa bogwa ibodi paila m wotetila. ");
INSERT INTO kij_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mitaga yam kwailima kwaiyuwela yamla vaiwasi, e makwaina bogwa lakabomi. Wa yam makwaiwena gala taitala bipaisewa, kaina goli yoku, litumwa, m ula, deli m mauna, kaina avai togilagala isisuaisi om valu. ");
INSERT INTO kij_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ka, yam kwailima kwaitala wala e yeigu Guyau labubuli valu watanawa, labuma, bolita, deli komwaidona vavagi makwaisina isisuaisi baisa. Mitaga yam kwailima kwaiyuwela yeigu avaiwasi. Baisa uulela yeigu Guyau lakabwaili Sabate deli goli lakabomi. ");
INSERT INTO kij_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Kutemmali tamam deli inam, kidamwa m tuta bikaduwonaku om valu mapilana avaka yeigu lasakaim. ");
INSERT INTO kij_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Gala bukukwatumata tomota. ");
INSERT INTO kij_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Gala bukukwailasi. ");
INSERT INTO kij_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Gala bukuveilau. ");
INSERT INTO kij_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Gala bukutabinimakavi availa. ");
INSERT INTO kij_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Gala bukumitikewakewa baisa availa la bwala. Gala bukumitikewakewa baisa matauna la kwava, la ula, la bulumakau, la ase, kaina avai vavagi tuvaila la vavagi titoulela.” ");
INSERT INTO kij_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","E avai tuta tomota ilagaisi pilapala deli tauya butula, e igisaisi kavikavila deli mseu ibobwau odabala koya, matausina itatatuvasi deli kasi kokola, e itowaisi sita kaduwonaku. ");
INSERT INTO kij_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","E ilukwaisi Mosese kawasi, “Kidamwa yoku bukulukwaimasi e bogwa wala bakanakaigalaimsi, mitaga yakamaisi kakokolasi kidamwa Yaubada avaka bilukwaimasi, kaina bakakaligasi.” ");
INSERT INTO kij_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","E Mosese ivitakaula kawala, “Gala bukukokolasi. Yaubada leima baisa biwakolaimi yokomi, e bivigaki yokomi bukukukolaisi matauna, e baisa makawala gala tuvaila bukumitugagasi.” ");
INSERT INTO kij_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mitaga tomota itowaisi wala kaduwonaku, e Mosese wala kalamwaleta ilokaia katitaikinela mapilana lowalowa piladudubila ambaisa Yaubada isisu. ");
INSERT INTO kij_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Guyau ikaraiwogi Mosese biluki mina Isireli kawala. “Yokomi bogwa lokugisaisi ammakawala yeigu Guyau, lalulukwaimi metoya wa labuma. ");
INSERT INTO kij_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Bomami bukububulaisi avai yaubada metoya siliba kaina goula mwada bukutapwarorusi baisa minasina makawala kutapwarorusi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kukwaliaiisi kwaitala kabogwabu lula paila yeigu metoya pwaipwaia wala, e odabala makwaina bukugabwaisi mi sipi deli mi bulumakau bivigaki lula kwegubugabu deli lulela kalubaila. E katuposula makatuposina lanagi paila bukutemmalaigusi, yeigu bayoumatila baisa yokomi e bakabwailimi. ");
INSERT INTO kij_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","E kidamwaga bukukwaliaiisi kwaitala kabogwabu lula paila yeigu metoya dakuna, gala bukukwaliaiisi metoya dakuna lokutavaisi, paila kidamwa bukutavaisi dakuna metoya ketavila dakuna, baisa bogwa bukuyogwalaisi e gala bibudoki paila yeigu. ");
INSERT INTO kij_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Gala bukukwaliaiisi kabogwabu lula paila yeigu isim kala daga paila bukumweimwenasi bukulolosi odabala, ka, kidamwa bukuvagaisi makawala, avai tuta bukumweimwenasi wa daga, baisa bukuyomitakasi wala makawala tomdumwadu yokomi. ");
INSERT INTO kij_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Kusaiki karaiwaga makwaisina baisa mina Isireli. ");
INSERT INTO kij_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kidamwa bukugimoli taitala m ula guma Iberu, matauna ibodi biwotitalaim kwailima kwaitala taitu. E kwailima kwaiyuwelaga taitu, ibodi bukutaneku matauna e gala bimapu avai vavagi baisa yoku. ");
INSERT INTO kij_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kidamwa tokubukwabuya wala lokuvigaki m ula, matauna tokubukwabuya wala bisilavaim, mitaga kidamwa tovavaigila lokuvigaki m ula, matauna bisilavaim tovavaigila wala. ");
INSERT INTO kij_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kidamwa kala tokugwa biyovaiya matauna e la kwava biuni litusia tauwau kaina vivila, magudisina gugwadi deli inasi bisisuaisi deli matauna tokugwa, e tumasiga bila kalamwaleta. ");
INSERT INTO kij_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Mitaga kidamwa matauna bikalai kawala, ‘Yeigu saina ayebwaili agu tokugwa, ulo kwava, deli litugwa, mapaila gala magigu basilavi matausina.’ ");
INSERT INTO kij_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","E kala tokugwa ibodi bilau matauna wa bwala tapwaroru. E matauna ula bitopituki lulu kaina lulu kokolala e tokugwa bitaponani taigala. E matauna bisivagasi wala la ula ola tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Kidamwa taitala tau latula vivila bisaiki availa bigimoli bivigaki la ula, e minana gala ibodi bitanekwaisi makawala tauwau leiuvigakaisi. ");
INSERT INTO kij_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","E kidamwa tamala bigimoli minana baisa avai tau mwada bivigaki la kwava, mitaga oluvi matauna bipaiki minana, matauna igagabila wala bigimolivau baisa tamala; mitaga matauna kala tokugwa gala ibodi bigimolivau baisa togilagala, paila uula avaka eivagi baisa minana gala duwosisia. ");
INSERT INTO kij_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","E kidamwa taitala tau bigimoli natana ula mwada bisaikiga latula la kwava, e tau matauna ibodi bivigaki minana makawala latula vivila. ");
INSERT INTO kij_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","E kidamwa taitala tau bivaiya nayuwela la kwava, matauna ibodi wala bisisaiki kala vilabogwa kʹala, kala karekwa, deli la karaiwaga kala peula bisisu wala makawala leisibogwa kalamwaleta. ");
INSERT INTO kij_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","E kidamwa matauna gala bikikuli vavagi makwaisina paila minana, e ibodi bitugwali minana bila e gala bibani avaka mapula. ");
INSERT INTO kij_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Kidamwa availa biwaiya sola e bikatumati, matauna tokatumata ibodi bukukwatumataisi. ");
INSERT INTO kij_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Mitaga kidamwa eiluvamakava wala e gala nanola paila bikatumati matauna, e matauna ibodi bisakaula bila valu mapilana yeigu Guyau banagi paila yokomi, e metoya mapilana valu matauna bikwala. ");
INSERT INTO kij_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mitaga avai tuta taitala tau bigibuluwa e deli la gibuluwa bikatumati sola, matauna ibodi bukukwatumataisi, ilagoli bisakaula bila ogu kabogwabu lula mwada bikwala. ");
INSERT INTO kij_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ka, kidamwa availa biwaiya tamala kaina inala matauna ibodi bukukwatumataisi. ");
INSERT INTO kij_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“E availa bibutuveilau taitala tau, mwada idoki bigimoli baisa availa, kaina bivigaki la ula, matauna ibodi bukukwatumataisi. ");
INSERT INTO kij_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“E availa bikamogi tamala kaina inala, matauna ibodi bukukwatumataisi. ");
INSERT INTO kij_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Kidamwa taiyu biyowaisi e taitala biwaiya sola odakuna kaina bikinunuma yamala biwaiya, mitaga gala ikatumati sola, gala bukumipukwaisi matauna towai. E kidamwaga matauna eikau lewa biyokenu paila kala lewa, ");
INSERT INTO kij_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","mitaga oluvi bisimalaula e bikaitukwa bila okoukweda, ibodi matauna towai bimapu sola paila eiyomadi la tuta deli biiyamata wala sola kala kalitutila wala bibwaina. ");
INSERT INTO kij_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Kidamwa taitala tau bikau notala lewa e biwaiya taitala kaina natana la ula, e la ula otukolela wala bikaliga, ibodi bukumipukwaisi tau matauna. ");
INSERT INTO kij_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mitaga kidamwa la ula gala bikaliga e bikalatala kaina bikalayu bikanukwenu wala e oluvi bikaliga, gala bukumipukwaisi kala tokugwa. Paila matauna kaina minana ivigaki makawala wala la guguwa. E kidamwa bikitumou matauna kaina minana metoya ola kaliga, baisa ivigaki kala mipuki. ");
INSERT INTO kij_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ka, kidamwa mimilisi tauwau biiyowaisi e biwaiyasi natana vivila nasusuma e minana biyopwi latula, mitaga vivila minana namwaidona naminabwaita wala, e matauna eiwaiya minana bikabi kulututu makawala kala bidubadu veiguwa avaka minana la mwala binagi, kidamwa goli deli tokaraiwaga bitagwalasi. ");
INSERT INTO kij_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mitaga kidamwa mavilela wala, minana bisilagi, mipuki baisa makawala, momova kaimapula momova, ");
INSERT INTO kij_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","e matila kaimapula matila, kudu kaimapula kudu, yamila kaimapula yamila, ");
INSERT INTO kij_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","e gabu kaimapula gabu, tatai kaimapula tatai, gilumsisi kaimapula gilumsisi. ");
INSERT INTO kij_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Kidamwa taitala tau bikatupwesi matala la ula tau kaina vivila, matauna ibodi bitaneku la ula bila mapula matala. ");
INSERT INTO kij_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kidamwa tau matauna bikatummolu kaitala kudula la ula, e ibodi bitaneku matauna la ula bila mapula kudula makaina. ");
INSERT INTO kij_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Kidamwa natana bulumakau namwala bitamati taitala tomota, ibodi bukukwabidukunaisi minana bikaliga, e gala bukukomasi minana. E tolimauna gala bukumipukwaisi. ");
INSERT INTO kij_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mitaga kidamwa bulumakau minana nagigasisi wala, e tomota bogwa eiwonaisi tolimauna, mitaga gala ikatupipi minana wa kali - e kidamwa bitamati availa, ibodi bukukwatumataisi minana deli goli tolimauna. ");
INSERT INTO kij_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Mitaga kidamwa bukutagwalasi tolimauna bikabi kulututu paila bikoli la momova, ibodi bimapu komwaidona mapula einagaisi. ");
INSERT INTO kij_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kidamwa bulumakau minana bitamati guditala gwadi tau kaina vivila, karaiwaga makwaina wala bukubokulaisi. ");
INSERT INTO kij_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kidamwa bulumakau minana bitamati taitala kaina natana ula, tolimauna bikabi kala kulututu toliula kweluwotolu siliba, e bukukwabidikunaisiga minana bulumakau bikaliga. ");
INSERT INTO kij_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Kidamwa taitala tau bikeli kwaitala mlopu e gala bikaliduboli makwaina, e bulumakau kaina ase bikasonu, ");
INSERT INTO kij_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ibodi matauna bimapu paila minana mauna. Matauna bimapu wa mani bisaiki tolimauna, e bisaimga kala bulumakau. ");
INSERT INTO kij_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kidamwa taitala tau la bulumakau bitamati sola la bulumakau, ibodi kasitaiyu wala bigimlokaisi mani minana namomova e bivilasi si mani. E minanaga nakaliga bisigalaisi kasi mauna. ");
INSERT INTO kij_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mitaga kidamwa minana bulumakau nagigasisi wala, e tolimauna gala ikatupipi wa kali, matauna ibodi bisaiki sola natana bulumakau namwamova, e minanaga nakaliga bisaim kala bulumakau. ");
INSERT INTO kij_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Kidamwa taitala tau biveilau natana bulumakau kaina sipi e bilau ikatumati kaina igimoli, ibodi wala matauna bimapu nalima bulumakau paila minana eiveilau kaina navasi sipi paila minana eiveilau. ");
INSERT INTO kij_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Ibodi wala bimapu avaka bogwa eiveilau. Kidamwa gala avaka iiyosi ibodi bukugimolaisi matoulela bimila ula e mapulaga bukumipukwaisi avaka eiveilau. E kidamwaga minana mauna eiveilau kaina bulumakau kaina ase kaina sipi, namwamova wala leititoi, matauna ibodi bimapu nayu mauna paila natana minana eiveilau. “Kidamwa bukuyosisi taitala touveilau leikikopwala bwala wa bogi e bukukwatumataisi matauna, matauna eikatumata gala la sula paila leikatumati sola. Mitaga kidamwa pakula makwaina bikaloubusi wa yam, e matauna eikatumata bogwa leisula. ");
INSERT INTO kij_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Kidamwa taitala tau bikilavi la mauna komwaidona bilosi ikikabubunasi wa bagula kaina bigulela waini, e oluvi minasina biwausi wala bilosi, e bikamsauwaisi taitala sola la bagula, matauna ibodi bimapu sola la bagula metoya ola bagula titoulela kaina obigulela waini. ");
INSERT INTO kij_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Kidamwa taitala bigabu la baleku e bikapela bila sola ola bagula bivakamati kali yagogu sola, kaina bivakamenu makwaisina bogwa eitaiyau, e matauna tovakata kova ibodi bimapu baisa sola avaka avaka eigabu. ");
INSERT INTO kij_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Kidamwa taitala tau bitagwala biyamati sola la mani kaina avai veiguwa tuvaila, e toveilau biveilau veiguwa makwaisina metoya ola bwala matauna, e oluvi biyosisi matauna toveilau, ibodi matauna toveilau binokwaiyuwa mapu paila mapula veiguwa makwaisina. ");
INSERT INTO kij_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","E kidamwaga gala biyosisi toveilau ibodi matauna toyamata veiguwa bukulauwaisi wa bwala tapwaroru e matauna bikatotila omatala Yaubada mwada gala iveilau la veiguwa sola. ");
INSERT INTO kij_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“E komwaidona pakula makwaisina pikolela guguwa kwaititamwau, makawala bulumakau, kaina ase, sipi, karekwa kaina avai guguwa wala eitamwau, e taiyu tauwau bikominimanaisi guguwa makwaina, ibodi kasitaiyu wala bukulauwaisi wa bwala tapwaroru. E ammatauna Yaubada bikamituli eisula, matauna goli binokwaiyuwa mapu baisa sola. ");
INSERT INTO kij_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ka, kidamwa taitala tau bitagwala biyamati sola la ase, kaina la bulumakau, la sipi, kaina avai mauna wala, mitaga mauna minana kaina bikaliga, kaina bisilagi, kaina biveilauwaisi, e kidamwaga gala availa yʹovila, ");
INSERT INTO kij_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","tau matauna bila wa bwala tapwaroru bilivala biga katotila omatala Yaubada matauna gala iveilau sola la mauna. Kidamwa gala availa iveilau mauna minana, e tolimauna ibodi bilumwelavi vavagi makwaina e sola gala bimapu. ");
INSERT INTO kij_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mitaga kidamwa minana mauna bogwa eiveilauwaisi matauna toyamata ibodi bimapu baisa tolimauna. ");
INSERT INTO kij_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ka, kidamwaga bolodila bikamataisi minana, tau matauna bimai avaka kasi kobwaga bolodila paila kabosimokwita, e matauna gala ibodi bimapu baisa sola paila mauna minana bolodila leikamataisi. ");
INSERT INTO kij_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Kidamwa taitala tau bitogu natana mauna metoya baisa sola e mauna minana bisilagi kaina bikaliga e tolimauna gala omatala, matauna totogu ibodi bimapu minana mauna. ");
INSERT INTO kij_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Mitaga kidamwa tolimauna bisisu omatala matutona mauna minana bikagaguma matauna totogu gala ibodi bimapu minana. Kidamwaga matauna bogwa eikaitogu mauna minana paila bivagi la paisewa e kidamwa bikagaguma, mapula bogwa wala eimipubogwi. ");
INSERT INTO kij_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Kidamwa taitala tau bikasaimwali natana vilakapugula e bimisii, ibodi wala bikabi veiguwala minana e bivaiya. ");
INSERT INTO kij_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Mitaga kidamwa vivila tamala bipaiki gala magila tau matauna bivaiya minana, tau matauna ibodi wala bisaiki buwala vivila minana baisa tamala avaka bibudoki vilakapugula veiguwala. ");
INSERT INTO kij_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Kidamwa natana vivila nabubogau, kwatumataisi minana. ");
INSERT INTO kij_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Kidamwa taitala tau bimokaia natana mauna, kwatumataisi matauna. ");
INSERT INTO kij_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Kidamwa availa bilula baisa avai yaubada ituwoli e gala baisa yeigu Guyau, kwatumataisi matauna. ");
INSERT INTO kij_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Gala bukuyomiyuyaisi kaina bukulamidadaisi taitala togilagala, kululuwaisi okwaitala yokomi lokutogilagalasi mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Gala bukuyomiyuyaisi natana kwabuya kaina guditala weilova. ");
INSERT INTO kij_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kidamwa bukuyomiyuyaisi matausina, yeigu Guyau bavitakauloki matausina avai tuta bidousi baisa yeigu paila pilasi. ");
INSERT INTO kij_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","E yeigu bagibuluwa bakatumataimi metoya okabilia. E mi kukova bikwabuyasi, e litumia gala tumisia. ");
INSERT INTO kij_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Kidamwa availa wala matausina ulo tomota tonamakava biwasi m mani, gala bukuvigakaim makawala mani kala tokaiyelu, deli gala bukunakusi mwada bimapu deli kala katumkovila. ");
INSERT INTO kij_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","E kidamwa bukukwau availa kala karekwa paila katululuwaila kala wasi igau bimapu baisa yoku, ibodi bukukwaimali bukusaiki matauna igau kalasia gala bisalili; ");
INSERT INTO kij_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","paila uula yatinidesi wala miyana eiyuviyavi wowola. E avai karekwa tuvaila bikanunuvi ke? E avai tuta bidou baisa yeigu paila pilasi, bogwa bamapu la dou, paila yeigu saina tonokapisi. ");
INSERT INTO kij_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Bomam taga bukubigigagi m Yaubada, kaina bukubuloti kam tokugwa. ");
INSERT INTO kij_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ibodi bukusemakavaisi kʹami, kami waini, mi bulami bulamila olibe baisa yeigu avai tuta si tuta bibudoki. “Kusakaigusi mi kuluta tauwau. ");
INSERT INTO kij_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Kusakaigusi mi bulumakau mi sipi si kuluta. Ibodi mi mauna si kuluta nammwala bikavatowasi okasi saleku biboda kwailima kwaiyu yam, e kwailimalaga kwetolula yam, kusemakavaisi minana baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Ka, yokomi ulo tomota, mapaila gala ibodaimi bukukomasi avai mauna bolodila eikamataisi. Mesinaku wala kusakaisi kaukwa bikamsi. ");
INSERT INTO kij_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Gala bukukwayayaisi biga kweutusai, deli gala bukupilasaisi taitala tosula bukuutaisi la bigatona mwada bikamokwita. ");
INSERT INTO kij_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Taga bikoyoulimsi tobobawa avai tuta bivagaisi avai sula, kaina biutaisi avai sopa paila bikididogi karaiwaga duwosisia. ");
INSERT INTO kij_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Gala bukupii taitala tonamakava ola tuta yakala. ");
INSERT INTO kij_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Kidamwa bukubani natana kam tilaula la bulumakau kaina la ase eisula, ibodi bukuyosi e bukukwaimilivau bukuuyoki matauna. ");
INSERT INTO kij_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","E kidamwaga la ase eikapusi deli konila, gala bukugigisaki wala bukulaga, ibodi bukupilasi kam tilaula e bukutokowoiyaisi la ase. ");
INSERT INTO kij_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Avai tuta taitala tonamakava biyakala gala bukukiwoli karaiwaga duwosisia. ");
INSERT INTO kij_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Gala bukutamituli avai tabinona sasopa, deli gala bukukwatumati taitala tobwaila, paila yeigu bakamogi availa bimitugaga makawala. ");
INSERT INTO kij_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Gala bukutagwala bukukwau kwaitala vavagi mwada katupatula wodom, paila avaka katupatula wodila, tomota ivigaki kasi kau metoya avaka kamokwita, e ikididogaisiga si bigatona tobubwaila. ");
INSERT INTO kij_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Gala bukuyomiyuyaisi taitala tomitawasi, paila bogwa kunikolaisi ammakawala kada lumkola kidamwa tomitawasi yakida, paila uula yokomi bogwa lokutomitawasisi mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Olopola kwailima kwaitala taitu yokomi bukusupusopusi mi bagula e avai tuta bikabinaisi kutaiyauwaisi makwaisina. ");
INSERT INTO kij_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mitaga avai tuta bukusakailasi kwailima kwaiyuwela taitu, kuvalaiyaisi bikanawa gala bukutaiyauwaisi avai vavagi lokusapwaisi omi bagula. E mina namakava ibodi bikauwaisi kʹasi metoya baisa, e kesalaga bolodila ibodi bikamkulovaisi. Mi waini bigulesi deli mi kai olibe tuvaila kuvigakaisi makawala. ");
INSERT INTO kij_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Kwailima kwaitala yam kuvagaisi mi paisewa olopola wiki kwaitala kwaitala, mitaga kwailima kwaiyuwela yam gala bukupaisewasi, e mi ula toyo tomitawasi leiwotitalaimi deli goli mi mauna ibodi bivaiwasisi. ");
INSERT INTO kij_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Kuligimlilaisi komwaidona avaka yeigu Guyau bogwa lalukwaimi. E gala bukutemmalaisi avai yaubada ituwoli; e taga bukukwadidalaisi yagasi. ");
INSERT INTO kij_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ka, taitu kwaitala kwaitala yokomi bukusivatolusi paka paila agu taimamila. ");
INSERT INTO kij_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","E olopola tubukona Abibi, tubukona minana lokusilavaisi Itipita, yokomi bukupakasi Beredi Gala Deli Kala Yisi Pakala makawala avaka lakaraiwogaimi bukuvagaisi. E olopola makwaisina kwailima kwaiyu yam bukupakapakasi paka makwaina, yokomi gala bukukwamsi beredi deli kala yisi. Gala bukulomakavasi bukumaisi bukutapwarorusi baisa yeigu kidamwa gala deli mi semakavi. ");
INSERT INTO kij_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Avai tuta bukuvitouulasi mi tayoyuwa, ibodi bukupakasi Tayoyuwa Pakala. “Deli avai tuta bukuyoulilisi mi bagula bigulela waini, deli kami kawailuwa kai kaitala kaitala okweluvala milamala, ibodi bukupakasi Buliyoyova Pakala. ");
INSERT INTO kij_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Taitu kwaitala kwaitala otutala paka makwaisina kwaitolu, komwaidomi wala bukumaisi bukutapwarorusi baisa yeigu Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Gala bukusemakavaisi beredi deli kala yisi avai tuta bukululasi natana mauna baisa yeigu. E mi mauna posasi lokuvigakaisi mi lula baisa yeigu tutala lokupakapakasi paka makwaisina, gala bikanam bila biyam kaukwau. ");
INSERT INTO kij_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Taitu kwaitala kwaitala bukuvisulapulasi mi bagula ibodi wala bukumaiyaisi ola bwala Guyau mi Yaubada. “Avai tuta bukusulaisi nagwadi sipi kaina gota, gala bukuvigakaisi inisia nunusi kami yavau. ");
INSERT INTO kij_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Ka yeigu bawitali anelosi bikugwa omitami paila bikolaimi metoya omi loula, e bilauwaimi valu mapilana yeigu bogwa lakatubiasi. ");
INSERT INTO kij_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Kulamamsi baisa matauna, deli kukwabikuwolaisi matauna. Gala bukukosomapwaisi matauna paila yeigula lawitali leiwokaiami, deli gala binokapisaimi kidamwa bukukosomapwaisi matauna. ");
INSERT INTO kij_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mitaga kidamwa bukukwabikuwolaisi matauna, e bukuvagaisi komwaidona avaka bakaraiwogaimi, yeigu bapiaimi bakabilia baisa komwaidosi kami tilaula. ");
INSERT INTO kij_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ulo anelosi bikugwa omitami e bilauwaimi osi valu mina Amora, mina Itai, mina Peresi, mina Kenani, mina Ivi, deli mina Yebusi, e yeigu bakatudoum matausina. ");
INSERT INTO kij_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Gala bukutemmalaisi si yaubada kaina bukutapwarorusi baisa minasina, deli gala bukutapaiseisi si tapwaroru kidikedala. Kwatudidaimisi si yaubada minasina tokolu, deli kwatuuwolaisi makaisina si kokola dakuna kaibumaboma. ");
INSERT INTO kij_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","E kidamwa bukutemmalaigusi yeigu Guyau mi Yaubada, yeigu basakaimi kami bobwailila metoya kaula, sopi, deli bakau komwaidona kami katoula baligaim. ");
INSERT INTO kij_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Olopola mi valu gala natana bivalulubogwa kidamwa gala bibudoki kala tubukona, e gala natana nakaliga bisisu. E yeigu bakatududuli mi momova. ");
INSERT INTO kij_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Yeigu bavigaki matausina eikoulovaimi, bikukolaigusi. E matausina deli bukukwabiliasi bavigaki bisineiyousi, deli yeigu bakau kaikesi kami tilaula e bisakaulasi bilosi. ");
INSERT INTO kij_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Yeigu bayokukoli kami tilaula e avai tuta bukusuvaisi kulumi, yeigu babokavili mina Ivi, mina Kenani, deli mina Itai. ");
INSERT INTO kij_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mitaga gala kudokaisi babokavili matausina olopola kwaitala wala taitu, paila kidamwa bavagi makawala, valu biviloububu, deli mauna nabubolodila bikalisauwaimi kami bawa. ");
INSERT INTO kij_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mitaga ka, baisa makawala bavigaki, manum wala babokavili matausina, tatoula wala bukuunigeyaisi paila bukuyoulisi valu mapilana. ");
INSERT INTO kij_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","E bakobili kami kaligei balawʹo metoya mapilana Mlulela Akaba bila itobu wa Waya Yupereiti, e metoya mapilana Bolita Kwaiveka bila itobu oviloupakala. Yeigu bavigakaimi bukuvaiyoulisi matausina tolivalu, deli avai tuta bukusuvaisi kulumi bogwa wala bukubokavilaisi matausina. ");
INSERT INTO kij_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Mapaila gala bukukwatotilasi paila avai vavagi deli matausina kaina deli minasina si yaubada. ");
INSERT INTO kij_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Gala bukutagwalasi matausina bimilivalusi omi valu, paila kidamwa bukusigolaisi matausina, matolesi goli bitavilaisi ninami bukumitugagasi baisa yeigu. Kidamwa bukutemmalaisi minasina si yaubada, baisa bogwa wala lokuleiyasi sikolela kami kaliga.” ");
INSERT INTO kij_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","E Guyau iluki Mosese kawala, “Ka, yoku e Eroni, Nadaba, Abiu, deli tailuwolima tailuwoyu tokugwala mina Isireli kumwenasi kumakaiagusi wa koya. E igau wala kutotusi sitana kaduwonaku e kutapopulasi kutapwarorusi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Oluvi yoku wala kammwaleta bukumakaiagu katitaikina, e gala goli deli samwa bukumakaiagusi. E mina Isireli gala taitala bimwena bima wa koya.” ");
INSERT INTO kij_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mosese ila iluki tomota komwaidosi avaka Guyau la karaiwaga kwevakaveka deli kwekikekita e komwaidosi tomota ivitakaulokaisi matauna kawasi, “Bogwa bakavagaisi komwaidona avaka Guyau eilivala.” ");
INSERT INTO kij_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","E Mosese igini komwaidona avaka Guyau la karaiwaga. Eiyam kaukwau ikaliai kabolula okaikela koya, e isaili kweluwotala kwaiyu dakuna mwada kabutuvitusila mina Isireli dalesi kweluwotala kwaiyu. ");
INSERT INTO kij_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","E iwitali mimilisi tauwau tubovau e igabwaisi lula baisa Guyau, deli mimilisi bulumakau ivigakaisi lula paila kalubaila lulela baisa Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","E Mosese ikau sitana buyavisi mauna e itavikoti makwelasina bolu, e kesala buyavi ikatusoki okabolula. ");
INSERT INTO kij_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","E ikau bukila kabutu mapilana Guyau la karaiwaga kala ginigini isisu, e ikalau baisa tomota. E ilivalasi kawasi, “Bakakabikuwolaisi Guyau deli bakavagaisi komwaidona vavagi avaka bogwa eikaraiwogi.” ");
INSERT INTO kij_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mosese ikau buyavi ikatusoki tomota. E iluki matausina kawala, “Makwaina buyavi eikatukikiti Guyau la kabutu avaka eivagi deli yokomi avai tuta isakaimi komwaidona makwaisina karaiwaga.” ");
INSERT INTO kij_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mosese, Eroni, Nadaba, Abiu e deli tailuwolima tailuwoyu tokugwala Isireli imwenasi wa koya, ");
INSERT INTO kij_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","deli igisaisi mina Isireli si Yaubada. Osikowala kwaibakwaila isisu kabototu dakuna kwedudubuna yagala sapaya, kala bwabwau makawala labuma. ");
INSERT INTO kij_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yaubada gala iyogagi matausina tokugwala Isireli. Eigisaisi Yaubada, e oluvi ikamsi imomsi gulitinidesi. ");
INSERT INTO kij_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","E Guyau iluki Mosese kawala, “Kumwena kumakaiagu wa koya, e wa tuta matutona kadataiyu wa koya basakaim pilayu pilapupatata dakuna, e baisa isisu karaiwaga komwaidona makwaisina avaka lagini paila bikatululuti ulo tomota.” ");
INSERT INTO kij_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mosese sola kala topilasi Yosuwa ikatubaiasasi iwokuva, e Mosese ivitouula bimwena wa koya kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mosese iluki tokugwala komwaidosi kawala, “Ka! Bukututulaimasi wala baisa okabosikaiwa igau avai tuta bakakeiita. Eroni sola Ura deli wala bukusisuaisi, e kidamwa availa kwaitala kala pakula e magila bimanum, ibodi bilokaia matausina.” ");
INSERT INTO kij_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mosese bogwa imwena wa Koya Sinai, e pilatala lowalowa ikuboli wala makwaina koya. ");
INSERT INTO kij_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","E Guyau migila lumalamela saina ivivivila deli guyugwayula ibusi wa koya. E mina Isireli si gigisa idokaisi makwaina lumalama kala gigisa makawala goli kovatala kova ilululu odabala koya. Lowalowa mapilana ikalalima ikalatala ikuboli koya, e ikalalima ikalayuwela Guyau eidou baisa Mosese metoya olowalowa. ");
INSERT INTO kij_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","E Mosese isaitaula imwena wa koya, e isuvi olowalowa. E kweluwovasi yam deli bogi isisu wala wa koya. ");
INSERT INTO kij_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Kuluki mina Isireli bisemakavaisi baisa yeigu. E bukukwau avai semakavi wala taitala tomota nanola bisemakavi. ");
INSERT INTO kij_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Bisemakavaisi guguwa makwaisina goula, siliba, barasi, ");
INSERT INTO kij_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","deli karekwa yakakaraia, miyasina ibasaisi metoya sipi unuunula kasi vau burum, dairarugu deli bweyani; karekwa eiyoudulaisi metoya gota unuunula; ");
INSERT INTO kij_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","sipi nammwala kanuvinesi bilaleisi bweyani; mauna kanuvinesi yammatabwaila deli makaisina meku; ");
INSERT INTO kij_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","kevakevala kaitapa deli vana paila bulamila vaputuma deli avaka lula bigabwaisi maiina simasimina; ");
INSERT INTO kij_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","makwaisina dakuna mipusi mwau makala kaneliani deli avai veiguwa tuvaila paila bisailisi okala epodi Tolula Toveka miyana kabutuvitusila la wotetila deli goli okala kwama. ");
INSERT INTO kij_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ibodi tomota bikaliaiisi kwaitala buliyoyova kwebumaboma paila yeigu, e gagabila yeigu basikaili matausina. ");
INSERT INTO kij_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Bukukwaliaiisi makwaina deli bukukwatuvalatusi avaka ulo nanamsa bavitulokaimi bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Kukwatuvilataisi kwaitala didawaga metoya meku, kala woloula tomwaidona, kala beiyaya yumatala, e lomla bima okaboyaulela yim. ");
INSERT INTO kij_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","E bukupakaisi goulatoula bikuboli kai olopola deli otapwala, deli bukuvagaisi kaidadela goulawokuva wala bitavina bitapatu. ");
INSERT INTO kij_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Bukuyoudulaisi kwaivasi kala nonoita metoya goula wala e bukukwatuvilataisi makwaisina okaikela makweyasina kweyavasi, e bivigaki kwaiyu pilatala kwaiyu piliyuwela, ");
INSERT INTO kij_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","E bukuyoudulaisi kaitakewala metoya meku e bukupakaisi goula bikuboli makaisina kaitakewa, ");
INSERT INTO kij_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","e bukukwaluvisuvaisi makaisina ononoita makwaisina lokukwatuvilataisi okaipapala didawaga. ");
INSERT INTO kij_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","E kaitakewa makaisina bikanuvagasi wala ononoita e gala avai tuta bukubiigilaisi. ");
INSERT INTO kij_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","E igau oluvi basakaimi pilayu dakuna, mapilasina isisu karaiwaga kala ginigini, e bukudidagaisi mapilasina olumoulela didawaga makwaina. ");
INSERT INTO kij_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Bukuyoudulaisi katubukolela metoya goulatoula, kala woloula tomwaidona e kala beiyaya yumatala. ");
INSERT INTO kij_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Bukututaisi goula e bukububulaisi tokolu nayu mauna isim pinupanesi, ");
INSERT INTO kij_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","e bukuvitauwaisi natana kabulotala katukwabula e nayuwela kabuluyuwela. Bukukwatupitukwaisi minasina okatukwabula e bivigaki bitovagasisi wala baisa. ");
INSERT INTO kij_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","E minasina tokolu bukusimapwaisi, matala sola matala sola bigisamapusi, e pinupanesi bivakanunuvi katukwabula. ");
INSERT INTO kij_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","E bukudidagaisi mapilasina pilayu dakuna olumoulela e bukukwatubukolaisi. ");
INSERT INTO kij_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Yeigu babodaim baisa, e odabala katukwabula oluwalaisi mauna minasina nayu yeigu basakaimi komwaidona ulo karaiwaga paila mina Isireli. ");
INSERT INTO kij_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Kukwatuvilataisi kwaitala tebeli metoya meku, kala woloula bisividoga e kala beiyaya okatupoi, kaikela kala woloula bima yumatala. ");
INSERT INTO kij_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Odabala makwaina bukupakaisi goulatoula, kaidadela bukupakaisi goula wala bitavina bitapatu. ");
INSERT INTO kij_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Bukuyoudulaisi kala kaidada beiyayela kweyatala sikwekula; e bukupakaisi goula wala bitavina bitapatu. ");
INSERT INTO kij_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Bukuyoudulaisi kwaivasi nonoita paila kaitakewa e bukukwatuvilataisi okaikela tebeli owokulula kwaivasi. ");
INSERT INTO kij_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Nonoita makwaisina paila kaitakewa bukukwatuvilataisi opapala kaidadela tebeli. ");
INSERT INTO kij_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Bukuyoudulaisi kaitakewa metoya meku, e kupakaisi goula wala otapwala komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Bukuyoudulaisi kaboma, viga, kwaibolu, deli kailuya paila guguwala mi waini semakavila. E komwaidona guguwa makwaisina bukuyoudulaisi metoya goulatoula wala. ");
INSERT INTO kij_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","E tebeli makwaina bukusailisi omatala Kabutu Didawogala, e tuta komwaidona mi semakavi beredi kwebumaboma bisisu wala otebeli. ");
INSERT INTO kij_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Bukuyoudulaisi kaitapa la kabototu metoya goulatoula. Kututaisi goula e bukububulaisi la kabototu deli kaikela; e katububulela makaisina lala, biluwai deli lalela kububuligolaisi kaitinidesila wala. ");
INSERT INTO kij_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Bukububulaisi sisilima sisitala sisila opapala, sisitolu pilatala, sisitolu piliyuwela. ");
INSERT INTO kij_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","E masisisina sisi, sisitala sisitala kala katububula kaitolu lala kasi gigisa makawala parani biluwai deli bilala. ");
INSERT INTO kij_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","E kaila makaina kaitapa la kabototu kala katububula kaivasi lala makawala kala gigisa parani biluwai deli bilala. ");
INSERT INTO kij_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Sisitala sisitala lalesi bitakasasi kasatinidesila wala bila itobu okaila. ");
INSERT INTO kij_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Metoya kwaitala wala goulatoula bukututaisi e bukububulaisi lalela, sisila deli kaila. ");
INSERT INTO kij_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kububulaisi kailima kaiyu kaitapa paila makaina kaitapa la kabototu e kuvitauwaisi odabala e igagabila visigala bisimitali mapilana omatala. ");
INSERT INTO kij_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Kuyoudulaisi kaivila kekarisigila kova deli kabomala metoya goulatoula. ");
INSERT INTO kij_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ibodi bukuyosisi goulatoula kala mokaila makawala lima yuwa petala kaula (35 kg) paila bukuyoudulaisi makaina kaitapa la kabototu deli komwaidona guguwela. ");
INSERT INTO kij_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Bukuyamatasi avai tuta bukuyoudilasi e bukuvagaisi makawala nanogu lakavitusi baisa yokomi wa koya. ");
INSERT INTO kij_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Ka, olumoulela ulo Buliyoyova Kwebumaboma kutabodaisi metoya yaluwotala karekwa yakakalaia, miyasina eibisigolaisi deli sipi unuunula, kasi vau, burum, dairarugu, deli bweyani. Kubasaisi otapwasi miyasina kaikobusi mauna isim pinupanesi. ");
INSERT INTO kij_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Yatala yatala miyasina kuvagaisi kasi vakaila makawala wala, kasi wonaku uvalima uvatala e kasi beiyaya uvatala. ");
INSERT INTO kij_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kubisitukwaisi yalima bila gulotala, e yalima bila guloyuwela. ");
INSERT INTO kij_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Metoya magulosina guloyu karekwa kulapwaisi yaburum buluva okaipagasi miyasina otapwala. ");
INSERT INTO kij_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","E magulona gulomatala karekwa kulapwaisi kweluwolima buluva okaipagala miyana eikalumatala, e guloyuwela kulapwaisi kweluwolima buluva okaipagala miyana kala vigimkovila. E guloyu wala kasi gigisa makawala. ");
INSERT INTO kij_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Kuyoudulaisi kasiluwolima kailasau metoya goula paila bukusagaisi magulosina guloyu karekwa bivigaki gulotala wala. ");
INSERT INTO kij_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Bukubasaisi katuvala Buliyoyova metoya yaluwotala yatala karekwa miyasina eibasaisi metoya gota unuunula. ");
INSERT INTO kij_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Bukubasaisi komwaidona wala makawala kasi vakaila, kasi wonaku uvalima uvatala isividoga, e kala beiyaya uvatala. ");
INSERT INTO kij_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Bukubisitukwaisi yalima bila gulotala, e yalima yatala bila guloyuwela. Miyana yalima yatalela bukukwatupokaisi kabuloyu omatala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Bukulapwaisi kwailuwolima buluva okaipagala miyana kala vigimkovila gulotala, e tuvaila kwailuwolima buluva okaipagala miyana kala vigimkovila guloyuwela. ");
INSERT INTO kij_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Bukuyoudulaisi kasilalima kailasau bukusagaisi obuluvasi magulosina guloyu karekwa bivigaki yatinidesila wala katuvala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","E makabulonaga eikesa, bukutabodaisi pwasousiu. ");
INSERT INTO kij_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","E kesala katuva makabulosina kasi vakaila leima oyumakwasi opapala Buliyoyova, bukuvigakaisi tabodala papala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Ka, kuyoudulaisi yayu tuvaila katuva, yatala metoya kanuvinesi sipi nammwala e bukulaleisi kala vau bweyani, yayuwela metoya kanuvinesi mauna ituwoli, miyasina paila bukuvakalupolaisi katuva. ");
INSERT INTO kij_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Bukuyoudulaisi baba paila tabodala Buliyoyova metoya meku. ");
INSERT INTO kij_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Pilatala pilatala mapilasina kasi wonaku uvayu, e kasi beiyaya yumatala. ");
INSERT INTO kij_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Kaipagasi bukukibubotaisi bibodasi wala gala biwelu, paila avai tuta bikavatowasi bikaili wala bikanam. Komwaidona baba mapilasina bukukibwelakaisi bibwaina. ");
INSERT INTO kij_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kuyoudulaisi pilaluwoyu baba paila mapilana opilibolimila ");
INSERT INTO kij_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","e kweluwovasi ulilaguva siliba bitoulisi osikowasi mapilasina. Pilatala baba ulilaguvala kwaiyu. ");
INSERT INTO kij_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kuyoudulaisi pilaluwoyu baba paila mapilana opiliyavatela Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","e kweluwovasi ulilaguva siliba, pilatala baba ulilaguvala kwaiyu. ");
INSERT INTO kij_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","E paila opwasosiula Buliyoyova mapilana opilikwaibwaga, kuyoudulaisi pilalima pilatala, ");
INSERT INTO kij_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","e pilayu baba biwaisi tupa owokulula. ");
INSERT INTO kij_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Mapilasina pilayu eiwaisi tupa owokulula, kukwailaisi bibwaina, watanawa bitotu goli bila walakaiwa. Mapilasina pilayu baba eiwaisi tupa owokulula eivigaki totomla Buliyoyova bukuvigakaisi makawala. ");
INSERT INTO kij_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","E baisa bivigaki pilalima pilatolu baba e ulilaguvasi kweluwotala kwailima kwaitala, pilatala baba kwaiyu ulilaguvala. ");
INSERT INTO kij_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Kuyoudulaisi kailuwotala kailima kavala metoya meku, kailima paila kavalela baba mapilasina pilatala Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","e kailima paila mapilasina pilayuwela, e kailima paila baba mapilasina oposousiu opilibomatu. ");
INSERT INTO kij_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kavala makaina eikanuwala, kaiwonaku wala, kabulotala Buliyoyova bila itobu kabuluyuwela. ");
INSERT INTO kij_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kwatububulaisi baba mapilasina goulawokuva wala, e komwaidona baba mapilasina kuyoudulaisi nonoitasi goula paila bikikuloti kavala makaisina, e makaisina deli bukukwatububulaisi goulawokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Kwaluvitauwaisi Buliyoyova makawala kala kaliai lavitulokaim wa koya. ");
INSERT INTO kij_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Kubasaisi yatala taboda yakakalaia metoya sipi unuunula kasi vau burum, dairarugu, deli bweyani. Kubasaisi otapwala miyana kaikobusi mauna isim pinupanesi. ");
INSERT INTO kij_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kusagaisi miyana okailasau makavisina otupwasi kokola makaisina kaivasi meku lokupakaisi goulawokuva wala, e bukuvitauwaisi oulilaguva makwaisina kwaivasi silibawokuva. ");
INSERT INTO kij_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kusagaisi miyana taboda okailasau makavisina olumoulela Buliyoyova, e makwaina Kabutu Didawogela lokudidagaisi mapilasina pilayu dakuna, kusailisi otuboulola miyana taboda bikalituli matabudona Bomikikila bim ituwoli e matabudona Bomikikila Sainela bim ituwoli. ");
INSERT INTO kij_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","E bukukwatubodaisi Kabutu Didawogala. ");
INSERT INTO kij_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","E olumoulela matabudona Bomikikila Sainela kuvitauwaisi tebeli makwaina opapala Buliyoyova mapilana opiliyavata; e kaitapa la kabototu bukuvitauwaisi mapilana opilibolimila. ");
INSERT INTO kij_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Paila Buliyoyova kala lulu tabodala bukubasaisi yatala karekwa yakakalaia metoya sipi unuunula, kasi vau burum, dairarugu, deli bweyani, e bukubasaisi isim kala katububula. ");
INSERT INTO kij_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Bukuyoudulaisi kailima kokolela miyana taboda metoya meku, e kupakaisi goula otupwasi makaisina, e kusagaisi miyana taboda okailasau makavisina goulawokuva wala, e bukuyoudulaisi kwailima ulilaguva metoya barasi paila bitoulisi makaisina kokola. ");
INSERT INTO kij_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Kuyoudulaisi kwaitala kabogwabu lula metoya meku. E kala beiyaya deli kala woloula biboda wala uvatala, e kaikela kala woloula bima okuvilu. ");
INSERT INTO kij_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","E odabala wokulu makwaisina kwaivasi bukukisalaisi kala sukusaku. E bivigaki kwaitinidesila wala kabogwabu lula, e kwemwaidona wala bukupakaisi barasiwokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kuyoudulaisi kavaega paila tubwagela lula, deli kaitapana, kailuya, kaisusuwa, deli kova kaisakaila. Komwaidona guguwela kuyoudulaisi metoya tanumnumta barasi. ");
INSERT INTO kij_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Kuyoudulaisi kaitala kaivala metoya tanumnumta barasi deli kwaivasi nonoita owokulula makwaina kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kusailisi kaivala makaina osikowala kaidadela kabogwabu lula makwaina, e gagabila kaivala makaina bikanuwalai wala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kuyoudulaisi katakewala metoya meku, e otupwasi makaisina kupakaisi barasiwokuva wala; ");
INSERT INTO kij_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","e avai tuta bukukwatikeuwaisi makwaina bukukwaluvisuyaisi makaisina ononoita. ");
INSERT INTO kij_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kutabodaisi papala kabogwabu lula, e olopolaga bikikapogega wala. Kuvagaisi makawala nanogu lalukwaimi wa koya. ");
INSERT INTO kij_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“E paila ulo Buliyoyova tabodala, bukuyoudulaisi metoya karekwa yakakalaia. E mapilana opilibolimila bukuyoudulaisi taboda kala woloula uvaluwoyu uvayu, ");
INSERT INTO kij_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","e bukuyoudulaisi kailuwoyu kokola metoya tanumnumta barasi, e kwailuwoyu ulilaguva, deli kailasau toyo wotunula bukuyoudulaisi metoya siliba wala. Youdila makwaisina paila bikikuloti bipeula miyasina taboda. ");
INSERT INTO kij_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","E tuvaila mapilana taboda opiliyavata bukuvagaisi makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","E mapilana opilikwaibwaga bukuyoudulaisi taboda kala woloula uvaluwotala uvatala, deli kailuwotala kokola, e kwailuwotala ulilaguva. ");
INSERT INTO kij_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","E mapilana opilibomatu ambaisa lulu metitoki, bukuyoudulaisi taboda kala woloula uvaluwotala uvatala. ");
INSERT INTO kij_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Wa lulu opapala pilatala deli pilayuwela bukuyoudulaisi miyasina karekwala taboda uvatolu yumatala kala maloula, deli kaitolu kokola e kwaitolu ulilaguva. ");
INSERT INTO kij_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","E paila makaduyona wala kala lulu Buliyoyova, tabodala karekwa yakakalaia kala maloula uvavasi isividoga lokubisikaisi metoya sipi unuunula kasi vau, burum, dairarugu, deli bweyani, miyana eibasaisi isim kala katububula. Miyana taboda bikana wala otupwasi makaisina kokola kaivasi, ulilaguvasi kwaivasi. ");
INSERT INTO kij_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","E taboda kokolela komwaidona eitavina eitapatu kuwaiyasi kopala metoya yuwoyoula silibawokuva, e kala kailasau makavisina kuyoudulaisi metoya siliba, e ulilaguvala tanumnumta barasi. ");
INSERT INTO kij_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","E taboda kala maloula uvaluwoyu uvayu, e kala beiyaya uvaluwotala uvatala, e paila kala woloula bila walakaiwa uvatala. E taboda miyasina kubasaisi metoya karekwa yakakalaia deli ulilaguvala metoya tanumnumta barasi. ");
INSERT INTO kij_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Komwaidona guguwala olumoulela Buliyoyova deli komwaidona kala kenubiluma Buliyoyova deli tabodala bukuyoudulaisi metoya tanumnumta barasi.” ");
INSERT INTO kij_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Yaubada iluki Mosese kawala, “Kukwaraiwogi mina Isireli bimiakaimsi kwaimmatabwaila bulamila olibe paila kevakevala kaitapa, e gagabila bukuvakaloti kaitapa makaina koyavi kwaitala kwaitala. ");
INSERT INTO kij_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","E Eroni deli litula bivakalotaisi kaitapa makaina, e bilauwaisi bivitauwaisi ogu Buliyoyova omatala miyana taboda eitabodi Kabutu Didawogala. E bikakata wala ogu Buliyoyova koyavi bila biyam. Ka, karaiwaga makwaisina baisa kami karaiwaga yokomi mina Isireli tubumia tuta oluvi, kidamwa bukuuvagaisi wala makawala tubwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Kuluki tuwam Eroni deli litula, Nadaba, Abiu, Eleasa deli Itama bimakaiamsi. Kwatupali matausina metoya tomotala Isireli, e gagabila bavigaki matausina ulo tolula. ");
INSERT INTO kij_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Bukubasaisi yavila kwama paila wala tolula e tuwam Eroni bisisikam miyasina paila kala katubaiasa deli la wotetila kala taimamila. ");
INSERT INTO kij_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","E bukudou komwaidosi matausina tokabitam youdila, matausina goli bogwa lasaiki si kabitam, e kuluki matausina bibasaisi Eroni kala kwama, e gagabila bakabomi matauna e bavigaki ulo tolula. ");
INSERT INTO kij_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Kuluki matausina biyoudulaisi kwaitala kuwa, yatala epodi, yatala kwama, yatala kakapula isim kala katububula, kwaitala kulupaipi, deli kwaitala duriduri. E matausina biyoudulaisi komwaidona makwaisina si guguwa tolula paila Eroni deli litula, e gagabila bavigaki matausina ulo tolula. ");
INSERT INTO kij_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Toyoudila matausina si youdila bikauwaisi wotunu eiyoudulaisi metoya sipi unuunula kasi vau burum, dairarugu, deli bweyani, deli wotunu goulawokuva, deli goli karekwa yakakalaia. ");
INSERT INTO kij_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“E matausina biyoudulaisi epodi metoya sipi unuunula kasi vau, burum, dairarugu, deli bweyani, yadigadegila wotunu, deli karekwa yakakalaia, e biyoudulaisi isim kala katububula. ");
INSERT INTO kij_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Tuvaila yayu kala wotunu bukusipwaisi okaipagala paila bukupilakavataisi miyana epodi. ");
INSERT INTO kij_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","E duriduri makwaina lokukimidagaisi kala bisibasi, bukubisitukwaisi wa epodi bivigaki yatinidesila wala. E youdulelaga makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Kukwauwaisi pilayu dakuna kaneliani e kutaiyasi otapwasi yagasi matausina tailuwotala taiyu Yekobe litula, ");
INSERT INTO kij_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","bukutakasasi molitomoya bila molagwadi, e bukutaiyasi yagasi tailima taitala pilatala dakuna e tailima taitala bila piliyuwela. ");
INSERT INTO kij_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Mapaila kunagaisi taitala tokataraki dakuna kala youdila, paila bitaiya otupwasi mapilasina dakuna yagasi Yekobe litula, e bikatuginigini mapilasina dakuna goulawokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Kusipwaisi mapilasina dakuna owotunu miyasina ovitakola eipilakavataisi miyana epodi paila kabotuvitusila dala Isireli dilaluwotala dilayu. E mapaila Eroni bikikau wala mapilasina dakuna ovitakola, e mapaila yeigu Guyau baluluwai ulo tomota tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Kuyoudulaisi kaiyu kailasau goulawokuva, ");
INSERT INTO kij_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","deli yayu wotunu metoya goulatoula bukuviraisi makawala yuwoyoula, e bukusipwaisi miyana okailasau makavisina. ");
INSERT INTO kij_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Kuyoudulaisi kwaitala kala kuwa Tolula Toveka bisisikam paila biuwotetila Yaubada nanola. Kuwa makwaina bukuyoudulaisi metoya youdila makwaisina wala lokuyoudulokaisi miyana epodi, deli kala katuginigini makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Mapilana eivigakaisi makawala doga kala woloula deli kala beiyaya makawala wala, deli kwatupokaisi pilayu, kala woloula bima okabotakuwa, e kala beiyaya makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kutakasaisi kasavasi dakuna kwevivivila otapwala mapilana. Kasamatala makasana kutakasaisi dakuna makwaisina mwau mipusi, kwaitala rubi, kwaitala topasi, deli kwaitala ganeti, ");
INSERT INTO kij_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","e kasayuwela, kwaitala emerodi, kwaitala sapaya, deli kwaitala daimoni. ");
INSERT INTO kij_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Kasatolula, kwaitala tekwesi, kwaitala ageiti, deli kwaitala ametisi, ");
INSERT INTO kij_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","e kasavasila, kwaitala berili, kwaitala kaneliani, deli kwaitala yasipa. Bukukwatuginiginaisi makwaisina dakuna goulawokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","E kweluwotala kwaiyu dakuna makwaisina kutaiyasi odubasi yagasi Yekobe litula, paila kabotuvitusila dala Isireli dilatala dilatala. ");
INSERT INTO kij_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","E kuwa mapilana wotunula kuyoudulaisi metoya goulawokuva, kuviraisi makawala yuwoyoula kala viriviri. ");
INSERT INTO kij_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Bukuyoudulaisi kwaiyu kakalougwa goulawokuva wala, e kwatupitukwaisi makwaisina wa kuwa okaipagala owokulula walakaiwa. ");
INSERT INTO kij_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Oluvi bukusipwaisi miyasina yayu wotunu goulawokuva okakalougwa makwaisina. ");
INSERT INTO kij_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","E matalaga makabulosina kabuloyu wotunu goulawokuva, bukusipwaisi okailasau makavisina ovilavala, e bogwa goli makawala baisa, kubisitukwaisi makavisina omatala miyana wotunula epodi. ");
INSERT INTO kij_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Bukuyoudulaisi kwaiyu tuvaila kakalougwa goulawokuva, e kwatupitukwaisi wa kuwa okaipagala owokulula watanawa, baisa goli kaipagala olumoulela ambaisa bikanapituki miyana epodi. ");
INSERT INTO kij_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","E kuyoudulaisi kwaiyu tuvaila kakalougwa e bukubisitukwaisi makwaisina osikowala miyasina wotunula epodi miyana omatala bila katitaikinela kuvilu okaipagala epodi, e odabala makwaina duriduri lokukimidagaisi kala bisibasi. ");
INSERT INTO kij_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","E bukukwauwaisi yatala yaburum wotunu kusipwaisi okakalougwa makwaisina wa kuwa bilaga kusipwaisi okakalougwa makwaisina wa epodi, e gagabila kuwa mapilana bisila wala odabala makwaina duriduri e gala bisaisaya. ");
INSERT INTO kij_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Avai tuta Eroni bisuvi matabudona Bomikikila, matauna bisikoma makwaina kuwa leitaiyasi yagasi dalesi mina Isireli, e gagabila yeigu Guyau baluluwai ulo tomota tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ka, kusaila makwaisina Urim deli Tummim olumoulela kuwa makwaina, e gagabila Eroni bisikoma vavagi makwaisina avai tuta bimakaiagu ogu Buliyoyova. Wa tuta matutona matauna bimakaiagu, tuta komwaidona bisisikoma wala kuwa makwaina, e gagabila matauna biwotitali nanogu baisa ulo tomota mina Isireli. ");
INSERT INTO kij_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“E kwama miyana epodi eivakalupoli bukubasaisi yamwaidona wala yaburum metoya sipi unuunula. ");
INSERT INTO kij_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Bukutabolusi walakaiwa paila bisuvi pwaneta, e ponana maponinana kaipagala bukuviraisi bipoupou e taga bidadaimi. ");
INSERT INTO kij_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","E okabulumwaisala miyana, bukukisounusi kala puluweiwa metoya sipi unuunula kasi vau burum, dairarugu, toyo bweyani, e deli bukukwalumgolaisi makwaisina, kusailisi bela kekikekita goulawokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ibodi Eroni bisikoma miyana kwama avai tuta bisuvi biuwotetila tolula wotitalela. Avai tuta bisuvi ogu Buliyoyova matabudona Bomikikila kaina bisilavi matabudona ibodi wala bitalilagi butula makaisina bela, e matauna gala bikaliga. ");
INSERT INTO kij_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Bukuyoudulaisi kwaitala saveva metoya goulatoula, e bukutaiyasi otapwala makwaina biga mabigasina, ‘Takabomaisi baisa Guyau.’ ");
INSERT INTO kij_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","E wotunula makwaina saveva yaburum bukusipwaisi omatala kulupaipi. ");
INSERT INTO kij_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Eroni bisisikoma makwaina odabala e gagabila yeigu Guyau bakabwaili komwaidona si semakavi makwaisina mina Isireli eikabomaisi baisa yeigu, ilagoli kidamwa tomota bikisulaisi kidikedala si semakavi. ");
INSERT INTO kij_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“E bukubasaisi Eroni kala kwama metoya karekwa yakakalaia e deli bukubasaisi kala kulupaipi metoya karekwa yakakalaia deli goli kala duriduri bukukwatububulaisi. ");
INSERT INTO kij_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Kuyoudulaisi mimilisi kwama, duriduri, deli kulupewa paila Eroni litula, paila kasi katubaiasa deli si wotetila kala taimamila. ");
INSERT INTO kij_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","E guguwa makwaisina bukuvisikoma tuwam Eroni deli litula. Bukukiwoti matausina deli kukwabomi, e bukuvaputumi matausina metoya olibe bulamila, e gagabila bavigaki matausina ulo tolula. ");
INSERT INTO kij_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Kubasaisi mimilisi tarautusi yakakalaia paila si sevalopula matausina bitobu okuvilisi bila okwaipiapasi, e gala gagabila biyomitakasi uwosi titoulesi. ");
INSERT INTO kij_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","E avai tuta Eroni deli litula bisuvisi ogu Buliyoyova kaina bitoulisi okabogwabu lula paila biuwotetilasi tolula wotitalela olumoulela matabudona Bomikikila, tuta komwaidona bisisikomasi miyasina e gala gagabila bikaligasi paila biyomitakasi uwosi titoulesi. Makwaina kwekanuvagasi kasi karaiwaga Eroni toyo dalela tubwa komwaidona.” ");
INSERT INTO kij_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Guyau iluki Mosese kawala, “Bukuvagi baisa makawala paila Eroni deli litula tutala bukukwabomi matausina paila bavigaki ulo tolula. Bukuyosi natana namwala bulumakau deli nayu sipi nammwala minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","E bukukwau kalamatabwaila pwarawa mitaga gala deli yisi, e bukugabu beredi deli bulamila olibe, e mimilisi gala deli bulami, mimilisi bukugabu pilapupatata e kwatugiaki bulami odubasi mapilasina. ");
INSERT INTO kij_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Avai tuta bukuvigaki lula minana namwala bulumakau deli minasina nayu sipi nammwala baisa yeigu, e kawailuwa makwaisina bukuvilugi wa peta e bukusemakavi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Kumai Eroni deli litula tauwau wa lulu ogu Buliyoyova, metoya baisa kuluki bikakayasi bimigileusi. ");
INSERT INTO kij_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Oluvi kuvisikoma Eroni metoya tolula kasi karekwa - yatala kwama, epodi, kwama miyana eivakalupoli epodi, kuwa makwaina deli duriduri. ");
INSERT INTO kij_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kusaila opwanetala kala kulupaipi, e kusipu okulupaipi kala saveva kwebumaboma makwaina kala ginigini makawala, ‘Takabomaisi baisa Guyau.’ ");
INSERT INTO kij_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Oluvi kukwau vaputuma bulamila kuligabu opwanetala, e kukiwoti dabala matauna. ");
INSERT INTO kij_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Kumai litula tauwau e kuvisikoma matausina kasi kwama. ");
INSERT INTO kij_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Kusipu kasi kulupewa odubasi. Baisa goli makawala bukukwabomi Eroni deli litula. E matausina deli goli tubusia tuta oluvi bavigaki ulo tolula tubwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Kumai minana bulumakau namwala omatala ulo Buliyoyova, e kuluki Eroni deli litula biyosalaisi yumasi bisailisi opwanetala minana bulumakau. ");
INSERT INTO kij_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","E kukwatumati minana bulumakau omatala lulu ogu Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kutavikoti sitana buyavila bulumakau e kukogiaki buyavi omisikwaikwem, e kuleiya okala sukusaku kabogwabu lula. Oluvi kubisikovi komwaidona buyavi bila oulilaguvala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Oluvi kukwau komwaidona posa wa seila, kapatula, deli makwaisina kwaiyu kweta deli wala posala, e kugibuki lula okabogwabu lula baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mitaga bulumakau vilionela kanuvinela, deli sileula bukugabu oyosewala mi kabosikaiwa. Makwaina lula bivigaki tolula si mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ka, kuyosi natana sipi metoya minasina nayu nammwala, e kuluki Eroni deli litula bisailisi yumasi opwanetala. ");
INSERT INTO kij_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kukwatumati minana, kutavikoti buyavila e kukwatusoki komwaidona papala kabogwabu lula pilavasi wala mapilasina. ");
INSERT INTO kij_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","E kuyali minana sipi namwala, kuwini makabilasina luguloguva, deli goli makweyasina kaikena, e kuvidubali odubasi makabilasina kununa deli goli mimilisi kabakabalela. ");
INSERT INTO kij_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kugabu minana namwaidona namwala sipi odabala kabogwabu lula, e lula makwaina bivigaki kaula lulela. E avai tuta basikoni maiina lula makwaina saina biyomwasalaigu. ");
INSERT INTO kij_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“E kuyosi nayuwela sipi namwala - ka, minana lokukwabomi - e kuluki Eroni deli litula bisailisi yumasi opwanetala minana sipi. ");
INSERT INTO kij_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Oluvi bukukwatumati minana sipi namwala, kutavikoti sitana buyavila e kukogiaki Eroni deli litula puwala taigasi pilakakata, deli kweyakakata kaikesi kweyaveka. E kesalaga buyavi komwaidona kukwatusoki papala kabogwabu lula pilavasi wala mapilasina. ");
INSERT INTO kij_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kutali sitana buyavi metoya okabogwabu lula, deli kuligabu sitana vaputuma bulamila bila oyamam, e kukwatusoki Eroni kala karekwa, e makawala goli litula deli kasi karekwa. Mapaila matauna litula deli goli kasi karekwa bogwa bukukwabomi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ka, kuyali posala minana sipi namwala, yeyunela deli posala, seila posala, kapatula; kwaiyu makwaisina kweta deli wala posala, deli kweyakakata kaikena. ");
INSERT INTO kij_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","E petala beredi mitana lokuvigaki semakavi baisa yeigu, kukwau beredi kasi gubugabu ituwoli ituwoli. kwaitala lokugabu deli bulamila olibe, kwaitala gala deli bulamila olibe, e pilatala pilapatata. ");
INSERT INTO kij_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Kukwau komwaidona makwaisina kawailuwa e kusaila oyumasi Eroni deli litula e kuluki matausina bikabomaisi makwaisina, bivigaki kwaitala kwedabala si semakavi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Oluvi kukwau metoya oyumasi matausina, e kusaila makwaisina odabala lula kwegubugabu, e kugabu okabogwabu lula, bivigaki kaula lulela baisa yeigu, e avai tuta basikoni maiinela lula makwaina saina biyomwasalaigu. ");
INSERT INTO kij_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Kukwau makabilana seila metoya minana sipi namwala e kukwabomi baisa yeigu bivigaki kwaitala kwedabala si semakavi baisa yeigu. E makabilana seila yoku kam vilavila. ");
INSERT INTO kij_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Avai tuta bukukiwoti taitala tolula, makabilasina seila deli kaikena metoya minana sipi namwala lokukwabomi, makabilasina bukukwabomi bivigaki kwaitala kwedabala si semakavi baisa yeigu; e kukwatupali makabilasina paila tolula. ");
INSERT INTO kij_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ulo karaiwaga makwaina gala bavigavau paila avai tuta ulo tomota bivagaisi kalubaila lulela, seila deli kaikena makabilasina kabilayu wala tolula kasi vilavila. Makabilasina tomota si bobwailila baisa yeigu Guyau. ");
INSERT INTO kij_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Avai tuta Eroni bikaliga kala kwama miyasina tolula kwamala bukusakaisi litula e avai tuta wala bikiwotaisi dubasi, matausina bisikomasi miyasina. ");
INSERT INTO kij_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Mapaila avai tau wala matausina bikaimapu tamala paila bipaisewa paisewala tolula deli bisusuvi ogu Buliyoyova paila biuwotetila olumoulela matabudona Bomikikila, matauna ibodi bisisikoma miyasina kwama biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ka, kukwau minana sipi namwala vilionela baisa lokuvigaki paila kasi kaboma Eroni deli litula, e kusulu ambaisa makatupona katupobumaboma. ");
INSERT INTO kij_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","E wa lulu ogu Buliyoyova matausina bikomasi viliona baisa deli beredi kesala wa peta. ");
INSERT INTO kij_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Matausina bikomasi vavagi makwaisina lokuvigaki kabotuvitusila mitugaga kala ligaiwa tuta makwaina lokukwabomi matausina. Tolula wala kasimwaleta ibodi bikomasi kaula makwaina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","E kidamwa bikobogaisi sitana viliona kaina beredi bikanam biyam kaukwau, ibodi wala bukugabu, e gala availa bikoma paila kaula makwaina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Bukupakapakasi pakala kasi kaboma Eroni deli litula biboda kwailima kwaiyu yam, e kukibubotaisi bibwaina makawala goli avaka lalukwaimi. ");
INSERT INTO kij_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Mapaila yam kwaitala kwaitala ibodi bukusemakavaisi natana bulumakau namwala paila bukuvigakaisi lula, e igagabila mi mitugaga baligaiwa. E lula makwaina bikatumigileu kabogwabu lula. Oluvi kuligabwaisi olibe bulamila odabala kabogwabu lula paila bivigaki makwaina kwebumaboma goli. ");
INSERT INTO kij_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mapaila yam kwaitala kwaitala biboda kwailima kwaiyu yam, bukuuvagaisi wala makawala. E bivigaki kabogwabu lula makwaina kwebumaboma wala. E kidamwa availa kaina avai vavagi wala biwoli makwaina bogwa bisilagi metoya kala bumaboma pewolela. ");
INSERT INTO kij_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Tuta baisa tuta igau bima, yam kwaitala kwaitala mi lula bukugibugabusi odabala kabogwabu lula, nayu lam kasi taitu kwaitala wala. ");
INSERT INTO kij_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","E natana bukululasi paila kaukwau, nayuwela paila koyavi. ");
INSERT INTO kij_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","E lam minana namatala bukululasi deli kalamatabwaila pwarawa kala mokaila makawala kapotala eikepupolaisi deli bulamila olibe kwematabwaila kala vakaila iboda yatala lukwava. Deli kuligabwaisi waini kala vakaila ibodi yatala lukwava bilokaia wala deli, e baisa bivigaki mi semakavi. ");
INSERT INTO kij_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","E ikoyavi bukululasi nayuwela lam deli goli pwarawa, olibe bulamila, deli waini, kasi vakaila makawala wala lokuvigakaisi kaukwau. Baisa bivigaki kaula lulela baisa yeigu Guyau, e avai tuta basikoni maiinela lula makwaina saina biyomwasalaigu. ");
INSERT INTO kij_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Mapaila lagaila deli tuta igau bima, tuta komwaidona bukugibugabusi makwaina lula kwegubugabu omatala ulo Buliyoyova. Paila makatupona goli babodi ulo tomota deli babigitonim. ");
INSERT INTO kij_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","E makatupowena goli babodi ulo tomota mina Isireli, e visigagu bivisigili makatupona e bivigaki katupobumaboma. ");
INSERT INTO kij_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Yeigu bakabomi Buliyoyova deli kabogwabu lula bivigaki makwaisina kwebumaboma, deli bakatupali Eroni deli litula e bavigaki matausina ulo tolula. ");
INSERT INTO kij_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Yeigu basivagasi oluwalesi mina Isireli, e yeigu wala si Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","E matausina binikolaigusi yeigu goli Guyau si Yaubada lakatusunupulovi metoya mapilana Itipita, e gagabila yeigu basivagasi deli matausina. Yeigu goli Guyau si Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Kuyoudulaisi kwaitala kabogwabu lula metoya meku, paila bukugibugabusi lula maiina simasimina. ");
INSERT INTO kij_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","E kala beiyaya deli kala woloula bibodasi wala, pilayu wala bimaisi oyumakwasi. E kaikela kala woloula bima okuvilu. E odabala kala sukusaku owokulula kwaivasi bivigaki kwetinidesila wala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kupakaisi goulatoula odabala, opapala pilavasi wala deli okala sukusaku, e kaipagala bukuyoudulaisi goulawokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kuyoudulaisi kwaiyu nonoita goulawokuva, e bukukwatuvilataisi makwaisina okaipagala pilayu wala paila bisuvi katikewala. ");
INSERT INTO kij_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Bukuyoudulaisi katikewala metoya meku e bukupakaisi goula otupwasi. ");
INSERT INTO kij_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Kuvitauwaisi makwaina kabogwabu lula okoukweda omatala miyana taboda eitabodi Kabutu Didawogala. E makatupowena goli babodaimi. ");
INSERT INTO kij_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Kaukwau kwaitala kwaitala avai tuta Eroni bisuvi ogu Buliyoyova paila bikatubiasi kaitapa, matauna bigigabu lula maiina simasimina okabogwabu lula makwaina. ");
INSERT INTO kij_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","E koyavi kwaitala kwaitala avai tuta bisusuvi paila bivakaloti kaitapa, matauna bigabuvau makwaina lula maiina simasimina. Lula makwaina bisetuwoli wala baisa tubwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Gala bukugabwaisi avai mauna ituwoli, kaina mauna lulela, kaina kaula lulela, kaina bukuligabwaisi waini lulela odabala makwaina kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","E kwaitala taitu olopola Eroni bisivatala wala bivagi wotitalela katumigileu paila kala katumigileu kabogwabu lula makwaina. Metoya buyavila mauna minana lokuvigakaisi lulela mitugaga kala ligaiwa, matauna bikatugiaki okala sukusaku makwaina kabogwabu lula. Karaiwaga makwaina ibodi bukuuvagaisi taitu kwaitala kwaitala tubwa komwaidona. Ka, ibodi kabogwabu lula makwaina kwemwaidona wala kwebumaboma, bukukwabomaisi paila yeigu Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Avai tuta bukusonukula kasi bawa mina Isireli e tomota taitala taitala ibodi bipokala baisa yeigu paila mapula la momova, kidamwa gala avai kabommayuyu biviloubusi baisa matauna otutala sonukula. ");
INSERT INTO kij_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Komwaidosi matausina bogwa eibudoki pokala, ibodi wala bipokalasi makawala topokala bogwa si pokala kala vakaila makawala avaka tokaraiwaga einagaisi. Komwaidosi wala bipokalasi e baisa bivigaki si semakavi baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Availa availa bogwa lokukwalau otutala sonukula, matausina kasi taitu kweluwoyu kaina kweluwoyu kesa, ibodi wala komwaidosi bipokalasi makawala kala vakaila. ");
INSERT INTO kij_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","E matausina isim si guguwa si pokala gala bimwena, e matausina tonamakava si pokala gala bibusi, mitaga komwaidosi wala bipokalasi makawala kala vakaila, e baisa pokalela si momova. ");
INSERT INTO kij_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kukwatuyouli mani magulona metoya baisa mina Isireli, e mani magulona paila wala paisewala ulo Buliyoyova. Pokala baisa bisailisi paila mapula si momova, e yeigu baluluwai paila bakoli matausina.” ");
INSERT INTO kij_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Kuyouduli kaitala kailuya metoya tanumnumta barasi, e tuvaila la kabototu barasi wala. E kuvitau makaina kailuya bitowalai Buliyoyova deli kabogwabu lula, e kutavikoti sopi olumoulela. ");
INSERT INTO kij_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","E Eroni deli litula bivigakaisi kabowinela yumasi deli kaikesi ");
INSERT INTO kij_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","oluviga bisuvisi ogu Buliyoyova kaina bilosi okabogwabu lula paila bigabusi kaula lulela. E matausina gala goli bikaligasi. ");
INSERT INTO kij_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Matausina ibodi biwinaisi yumasi deli kaikesi, e gala bikaligasi. Karaiwaga makwaina ibodi matausina deli goli tubusia tubwa oluvi bikabikuwolaisi tuta gala biwokuva.” ");
INSERT INTO kij_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Kukwau kaimatabwaila vana - mokaila yalima yatala lukwavala bulamila mro, yatolu lukwavala bulamila gau maiina simasimina, yatolu lukwavala bulamila doula lalela maiina simasimina, ");
INSERT INTO kij_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","deli yalima yatala lukwavala bulamila kasia, (komwaidona wala bukuvisaikoli mokaisi makawala tokaraiwaga inagaisi). Kukwatumkulovi yavasi lukwavala olibe bulamila, ");
INSERT INTO kij_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","e bukugabu vaputuma bulamila kebumaboma; maiina bikaipuyuma makawala bulami saina simasimina. ");
INSERT INTO kij_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","E bulami makaina bukuvaputumi ulo Buliyoyova, Kabutu Didawogala, ");
INSERT INTO kij_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tebeli deli komwaidona guguwala, kaitapa la kabototu deli komwaidona guguwala, kabogwabu lula makwaina paila maiina simasimina, ");
INSERT INTO kij_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kabogwabu lula makwaina paila bukugubugabusi lula, deli komwaidona guguwala, deli makaina kailuya paila kabowina deli goli la kabototu. ");
INSERT INTO kij_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ka, baisa makawala bukukwabomi vavagi makwaisina, komwaidona wala vavagi makwaisina bivigaki kwebumaboma sainela, deli kidamwa availa kaina avai vavagi biwoli vavagi makwaisina bogwa bisilagi metoya kala bumaboma pewolela. ");
INSERT INTO kij_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Oluvi bukuvaputumi Eroni deli litula, e bukukiwoti dubasi e gagabila bavigaki matausina ulo tolula. ");
INSERT INTO kij_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ka, kuluki mina Isireli, ‘Bulami makaina kebumaboma sainela, bukuvigakaisi ulo vaputuma bulamila tubwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Gala bukuvaputumaisi tomotamakava, deli yoku gala bukutapaisei mwada bukugabu avai bulami makawala, paila bulami makaina kebumaboma, deli ibodaim bukukikili makaina kebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Availa bigabu makawala makaina kaina bivaputumi avai tomotamakava matauna gala tolula, matauna gala tuvaila tomota bidokaisi ulo tomota.’” ");
INSERT INTO kij_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","E Guyau iluki Mosese kawala, “Kukwau vavagi makwaisina kwesimasimina yagasi makawala - sitakita, onika, galibanum deli bulami mapula mwau. ");
INSERT INTO kij_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","E kutaguliki vavagi makwaisina paila bukuvigaki lula maiina simasimina, maiina bikaipuyuma makawala bulami mapula saina mwau. E kukwatumkulovi sitana yona paila taga bisigi deli bivigaki kwebumaboma wala bisisu. ");
INSERT INTO kij_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Bukututu sitana bimila tubumyou kukwau kulau ogu Buliyoyova, e kukwatusoki omatala Kabutu Didawogala. Kukikili vavagi makwaina maiina simasimina kwebumaboma sainela. ");
INSERT INTO kij_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","E yoku gala bukutapaisei mwada bukutaguliki vavagi makwaisina maiina simasimina paila titoulem. Bukukikili vavagi makwaina kwebumaboma paila wala yeigu. ");
INSERT INTO kij_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kidamwa availa bitaguliki vavagi makwaisina mwada bivigaki kesumanela wowola, matauna gala tuvaila tomota bidokaisi ulo tomota.” ");
INSERT INTO kij_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","E Guyau iluki Mosese, kawala, ");
INSERT INTO kij_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Bogwa lanagi Besaleli matauna Uri latula e tabula Ura, metoya odalela Yuda. ");
INSERT INTO kij_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Bogwa lavakasau matauna metoya ulo baloma. Bogwa lasaiki la katavatu, la kabitam tuvaila la ninitalapula paila kala katuginigini youdila kwaitala kwaitala, ");
INSERT INTO kij_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","deli bininamsi ammakawala leilai kala kimadagi e bikatuginigini goula, siliba, deli barasi, ");
INSERT INTO kij_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","tuvaila veiguwa kala titavisi deli bikibuboti, deli paila bilaleya kai, deli goli kala katuginigini avai leilai avai leilai. ");
INSERT INTO kij_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tuvaila lanagi Owoliabi matauna Aisamaki latula, metoya odalela Dani, e matauna kasitaiyu biyoudulaisi. E tuvaila goli lasaiki komwaidona tokabitam ninitalapula paila biyoudulaisi komwaidona avaka avaka lakaraiwogi bivagaisi. ");
INSERT INTO kij_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ulo Buliyoyova, Kabutu Didawogala deli katubukolela, komwaidona guguwala Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tebeli deli uvagila, kaitapa la kabototu goulatoula deli guguwala komwaidona, kabogwabu lula paila lula maiina simasimina, ");
INSERT INTO kij_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kabogwabu lula makwaina paila lula kwegubugabu deli komwaidona uvagila, kailuya barasi deli la kabototu, ");
INSERT INTO kij_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","miyasina karekwa saina yaminibwaina sainela paila Eroni sola latula bisikamsi osi tuta wotetila tolula, ");
INSERT INTO kij_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","bulamila vaputuma deli bulami maiina saina simasimina paila matabudona Bomikikila Sainela. Komwaidona vavagi makwaisina ibodi wala bukuyoudulaisi makawala lakaraiwogaimi goli e gala avai vavagi bitamwau.” ");
INSERT INTO kij_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","biluki mina Isireli la karaiwaga, kawala, “Ibodi bukuyamataisi Yam Sabate, ulo yam vaiwasi, paila baisa kabutuvatusi omatagu omitami paila tuta gala wala biwokuva. Yam makwaina bivitulokaimi yeigu Guyau bogwa lanagaimi paila ulo tomota. ");
INSERT INTO kij_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ibodaimi bukutemmalaisi makwaina yamla vaiwasi, paila yam makwaina yam kwebumaboma goli. Availa gala bitemmali mitaga bipaisewa wa yam makwaina, bukukwatumataisi. ");
INSERT INTO kij_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mi yam kwailima kwaitala isisu e baisa bogwa ibodi paila mi wotetila. Mitaga yam kwailima kwaiyuwela yamla vaiwasi kwebumaboma e makwaina bogwa lakabomi. Availaga bivagi avai paisewa wa yam makwaina bukukwatumataisi. ");
INSERT INTO kij_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Mina Isireli ibodi bikabikuwolaisi kala karaiwaga yam Sabate bivigaki kabutuvitusila Kabutu. ");
INSERT INTO kij_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kabutuvatusi makwaina bisigaga oluwalaidasi yeigu deli yokomi mina Isireli, paila yeigu Guyau labubuli labuma deli valu watanawa olumoulela yam kwailima kwaitala e yam kwailima kwaiyuwela lasaim paisewa avaiwasi.” ");
INSERT INTO kij_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Matutona Yaubada bogwa eivenoku bigatona baisa Mosese wa Koya Sinai, isaiki matauna pilayu dakuna pilapupatata, ambaisa Yaubada titoulela bogwa eigini makwaisina karaiwaga. ");
INSERT INTO kij_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Avai tuta tomota itulukoyasi paila Mosese eisivagasi wa koya, e gala nani eibusi, e matausina imakaiasi Eroni ivaulaisi e ilukwaisi matauna kawasi, “Gala kanikolaisi kaina avaka eiviloubusi baisa matauna Mosese, matauwena eikugwaiyaidasi metoya Itipita. Mapaila kububuli natana da yaubadasi, paila bikugwaiyaidasi.” ");
INSERT INTO kij_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","E Eroni ivitakauloki matausina kawala, “Kupiasi goula osi kaikokwau mi kukova, litumia tauwau deli vivila, avaka eitakasaisi otaigasi e kumiakaigusi.” ");
INSERT INTO kij_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Mapaila tomota komwaidosi ipiasi goula osi kaikokwau e imiakaisi Eroni. ");
INSERT INTO kij_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ikau makavisina kaikokwau ivakasosu e iligabu baisa goula ila kwelatala bolu makawala bulumakau migila e ibubuli natana bulumakau tokolu metoya wa goula. E tomota ikaibigasi kawasi, “Mina Isireli, ka, da yaubadasi minana, eikugwaiyaidasi leitasunapulasi metoya mapilana Itipita!” ");
INSERT INTO kij_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Oluvi Eroni ikaliai kwaitala kabolula omatala minawena bulumakau tokolu, e ikatuvagwagu kawala, “Nabwaia bitavagaisi kwaitala paka paila kala taimamila Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Eiyam kaukwau wala imaiyaisi navila wala mauna paila bigabwaisi lula, e navila tuvaila mwada bikamsi bivigaki kalubaila lulela. Tomota isukuvatasi ipakapakasi, e oluvi ikivilivauwaisi makwaina paka ivigaki makawala tutala kalibom. ");
INSERT INTO kij_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","E Guyau iluki Mosese kawala, “Baisa tuta wala bukubusi. Paila m tomota, matausina okukugwai okusunapulasi metoya mapilana Itipita bogwa eimitugagasi deli eikoulovaigusi. ");
INSERT INTO kij_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Bogwa eisilavaisi keda makadawena avaka lakaraiwogi bibokulaisi. Bogwa eibubulaisi natana bulumakau tokolu metoya wa goula, e bogwa eitapwarorusi deli igubugabusi lula baisa minana. Matausina eilivalasi mwada minana si yaubada, e eikugwai eisunapulasi metoya mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Bogwa lanikolibogwi ammakawala si katukubona matausina tomota. ");
INSERT INTO kij_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Bogwa lagibuluwi matausina, mapaila bakatumtuwoli wala matausina. E gala wala kudoki mwada bukusilibodaigu. E oluvi bavigakaim yoku deli tubumwa bukudalasi kwaiveka baisa ovalu watanawa.” ");
INSERT INTO kij_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mitaga Mosese imnabi Guyau la Yaubada, e ikaibiga kawala, “Guyau, avakaga uula kugibuluwi m tomota saina peula, matausina bogwa lokukoli metoya mapilana Itipita deli m peuligaga sainela? ");
INSERT INTO kij_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Avaka uula mina Itipita bikapogegasi bilivalasi mwada lokusunupuloi m tomota metoya mapilana Itipita e lokuninamsiga mwada bukukwatumati matausina baisa wa koya e bukukwatumtuwoli wala biwokuva? Desi gibuluwa, kuninavila, deli gala bukumai ninamwau makwaina baisa m tomota. ");
INSERT INTO kij_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kululuwai matausina m towotetila Eberaam, Aisake deli Yekobe. Kululuwai kwaipeula biga katotila lokuvagi baisa matausina mwada bukusaiki bidalasi dalesi makawala utuyam wa labuma kasi bawa, e deli bukusaiki tubusia komwaidona kwabila makawala lokukwatotila bivigaki si vavagi wala bikanuvagasi.” ");
INSERT INTO kij_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mauula Guyau ininavila e gala ivigaki makawala la gibuluwa. ");
INSERT INTO kij_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mosese ikaimilavau metoya wa koya, e ikau mapilasina dakuna pilayu deli karaiwaga makwaisina bogwa isim kasi ginigini isisuaisi omitasi e otupwasi. ");
INSERT INTO kij_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Yaubada titoulela wala eivagi mapilasina dakuna e eileiya karaiwaga makwaisina otupwasi mapilasina. ");
INSERT INTO kij_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yosuwa ilagi tomota eiukuwakulasi e iluki Mosese, kawala, “Sogu! Lalagi butula wala kabilia okabosikaiwa.” ");
INSERT INTO kij_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mosese ilivala, kawala, “Baisa gala wala sitana kala lega kalisewa govala kainaga tomamama si valam. Baisa kala lega eiusiwosisi wala.” ");
INSERT INTO kij_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","E tutala Mosese ivakatitaikina okabosikaiwa e igisi minana bulumakau tokolu deli tomota ikikaiwosisi, e saina igidaleiya sainela. E baisa wa koya okaikela ilavi wala mapilasina dakuna avaka eikokeula, e ila ikatuvi. ");
INSERT INTO kij_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ikau minana bulumakau tokolu e ivakasosu deli ikatumkumku e ikenevigoli deli sopi e ikomikikani mina Isireli bimomwaisi. ");
INSERT INTO kij_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","E iluki Eroni, kawala, “Avaka eivigakaimsi e mapaila eimitugagasi saina mwaugaga e uulela yoku?” ");
INSERT INTO kij_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Eroni ivitakaula kawala, “Mwalʹo! Gala bukugibuluwaigu. Bogwa kunikoli tomota bubunesi saina kasai ninasi, e magisi wala mitugaga biuvagaisi. ");
INSERT INTO kij_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","E ka, ilukwaigusi kawasi, ‘Gala kanikolaisi avaka eiviloubusi baisa matauwena Mosese, matauwena leivisunupuloiyaidasi metoya mapilana Itipita. Mapaila kububuli natana da yaubadasi paila bikugwaiyaidasi.’ ");
INSERT INTO kij_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","E aluki matausina mwada bimaiyaisi kasi katububula goula. E mimilisi bogwa eisisiaisi sitana ivililaisi isakaigusi. E alavi ila wa kova, e oluvi minana bulumakau tokolu isunapula metoya wa kova!” ");
INSERT INTO kij_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mosese bogwa eigisi kidamwa Eroni eitugwali tomota ikilavaisi avaka kasi karaiwaga e ivigakaisi makawala nagowa wala baisa titoulesi omitasi kasi tilaula. ");
INSERT INTO kij_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mapaila matauna itokaia baisa osi kabosikaiwa kalapisilela, e iwakula kawala, “Komwaidomi availa availa yokomi Guyau ola boda kumaisi baisa ka!” E komwaidosi mina Libai imaisi itoulaisi matauna. ");
INSERT INTO kij_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","E iluki matausina kawala, “Ka! Guyau mina Isireli si Yaubada la karaiwaga baisa yokomi - taitala taitala bikau la puluta, e bila olumoulela kabosikaiwa metoya kalapisila makwaina e bila piliyuwela, e bikatumati budala, lubaila deli veyala.” ");
INSERT INTO kij_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","E matausina mina Libai ikabikaulasi wa yam makwaina e ikatumataisi tomota kasi bawa lakatuluwotolu. ");
INSERT INTO kij_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mosese iluki mina Libai, kawala, “Lagaila wala lokukikilaimi titoulemi okuvigakaimi tolula e lokuwotitalaisi Guyau. Paila goli lokukwatumataisi litumia deli budumia, e mauula baisa Guyau eikabwailimi.” ");
INSERT INTO kij_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","E eiyam Mosese iluki tomota kawala, “Yokomi bogwa kuvagaisi saina kwaimwaugaga. Mitaga baisa tuta bamwenavau wa koya e balokaia Guyau, bayokakapisi e kaina gagabila bitagwala biligaiwa mi mitugaga.” ");
INSERT INTO kij_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","E Mosese ikaimilavau baisa Guyau e ikaibiga kawala, “Matausina tomota bogwa eivagaisi mitugaga saina kwaimwaugaga. Matausina eibubulaisi si yaubada metoya wa goula e eitapwarorusi baisa minana. ");
INSERT INTO kij_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Anigadaim kidamwa yoku bukuligaiwa si mitugaga matausina. Mitaga kidamwa yoku bukupaiki, e desi wala iboda bukukodidaimi yagagu metoya mapilana buki olopola ambaisa bogwa lokugini yagasi m tomota.” ");
INSERT INTO kij_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","E Guyau ivitakaula kawala, “Mitaga availa availa imitugagasi baisa yeigu, e matausina wala yagasi ibodi bakodidaimi metoya ogu buki. ");
INSERT INTO kij_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","E kula kuvakouli tomota kulau mapilana valu igau ambaisa lalukibogwaim. Mitaga kululuwai kidamwa ulo anelosi wala bikugwaiyaimi. Mitaga ka! - igau kala tuta bima yeigu Guyau bamipuki matausina tomota paila si mitugaga.” ");
INSERT INTO kij_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","E Guyau iwitali lelia baisa mina Isireli, paila uula matausina eikomikikanaisi Eroni e ibubuli minana bulumakau tokolu metoya wa goula. ");
INSERT INTO kij_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","E Guyau iluki Mosese kawala, “Kusilavaisi makatupona valu, yoku deli tomota lokumai metoya mapilana Itipita, e kulokaiasi valu makwaina bogwa lakatotila basaiki Eberaam, Aisake deli Yekobe, e tuvaila goli tubusia. ");
INSERT INTO kij_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","E yeigu bawitali taitala anelosi paila bikugwaiyaimi e yeigu igau babokavili mina Kenani, mina Amora, mina Itai, mina Peresi, mina Ivi, e deli mina Yebusi. ");
INSERT INTO kij_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","E ka, yokomi bogwa bukulokaiasi makwaina valu pwaipwaiala kubilumalala. Mitaga ka, yeigu gala deli yokomi bitalosi, paila yokomi saina kasai dubami, e kainaga bakatumtuwolimi wa keda.” ");
INSERT INTO kij_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","E avai tuta tomota ilagaisi makawala, ivitouulasi valam e gala tuvaila isisikamsi kasi katububula kwevivivila. ");
INSERT INTO kij_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Paila Guyau eikaraiwogi Mosese biluki matausina, kawala, “Yokomi saina kasai dubami. E kidamwa yeigu deli yokomi bitalosi, ka bitavasekalasi wala e bakatumtuwolimi. Baisa tuta wala kutalugosaisi kami katububula kwevivivila, e yeigu igau bananamsa avaka bavigakaimi.” ");
INSERT INTO kij_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","E avai tuta leisilavaisi Koya Sinai e mina Isireli gala tuvaila isisikomasi kasi katububula kwevivivila. ");
INSERT INTO kij_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Avai tuta mina Isireli bibudaisi si kabosikaiwa, Mosese bikau makwaina Buliyoyova Kwebumaboma e bikaliai omiloutala metoya ambaisa eisisuaisi. E Buliyoyova makwaina idokaisi yagala Guyau la Buliyoyova, mapaila availa magila avai nanamsa metoya baisa Guyau, matauna ibodi wala bilokaia ola Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Avai tuta Mosese bilokaia makwaina Buliyoyova, tomota goli bitomalaulasi wa lulu osi buliyoyova e bivitoyaisiga Mosese bililoula igau avai tuta bisuvi. ");
INSERT INTO kij_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tutala Mosese bogwa eisuvi, e makaina lowa bibusi bima itom wa lulu wala ola Buliyoyova, e Guyau bibigitoni Mosese metoya wa lowa. ");
INSERT INTO kij_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tuta makwaina tomota bigisaisi makaina lowa bivabodi wala lulu ola Buliyoyova, matausina goli bikululusi opwaipwaia. ");
INSERT INTO kij_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","E Guyau bibigitoni Mosese makawala goli taitala tau eibibigatonasi sola lubaila - matala sola matala sola. E oluvi Mosese bikeiita okabosikaiwa. Mitaga kala topilasi matauna totubovau Nuni latula yagala Yosuwa, matauna bisitotaula oBuliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosese iluki Guyau kawala, “Baisa biga mokwita paila lokulukwaigu mwada bakugwai matausina tomota balau makwaina valu, mitaga gala wala kulukwaigu availa bukuwitali paila kamataiyu. Okulivala mwada bogwa kunikolaigu e ayomwasalaim. ");
INSERT INTO kij_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kidamwa mokwita goli ayomwasalaim, e tuta baisa kulukwaigu avaka nanom, e igagabila bawotitalaim e tuvaila goli bayomwasalaim. Tuvaila kululuwai mwada mina Isireli bogwa lokunigibogwi paila titoulem.” ");
INSERT INTO kij_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Guyau ikaibiga kawala, “Yeigu deli yokomi bitalosi, e bapilasaimi e bukutomgwagasi.” ");
INSERT INTO kij_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mosese eivitakaula kawala, “Kidamwa gala deli yoku bitalosi, gala bukulukwaimasi bakasilavaisi makwaina valu. ");
INSERT INTO kij_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ammakawala taitala binikoli mwada yakamaisi m tomota kayomwasalaisi nanom kidamwa yoku gala deli bitalosi? Ka, yoku m viloubusi baisa yakamaisi bivigaki kala tuwoli metoya baisa yakamaisi e tomota ituwoli odabala pwaipwaia.” ");
INSERT INTO kij_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","E Guyau iluki Mosese kawala, “Bogwa bavigaki makawala wala avaka lokunigada, paila bogwa lanikolaim mokwita deli goli yoku lokuyomwasalaigu.” ");
INSERT INTO kij_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Oluvi Mosese inigada baisa Guyau kawala, “Mwa Guyau! Akoma lopom, kutagwala bagisi migim lumalamela ivivivila deli guyugwayula.” ");
INSERT INTO kij_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Guyau ivitakauloki matauna, kawala, “Bavitulokaim tomwaidogu yeigu Toguyugwayu e bavaloula omatam, e deli bakamlili yagagu igibumaboma. Yeigu goli Guyau, e amitukwaii deli anokapisi availa availa matausina bogwa lanagi. ");
INSERT INTO kij_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","E gala wala batagwala bukugisi migigu, paila gala taitala gagabila bigisaigu e bisisu tomomova. ");
INSERT INTO kij_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Mitaga ka, baisa kabototu bwaina otaligu e ibodaim bukutotu baisa odakuna. ");
INSERT INTO kij_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","E avai tuta yeigu Toguyugwayu avaloula omatam, ikugwa bavisuviyaim odubodebula makwaina e oyamagu bakibodi igau avai tuta bavaloula bala. ");
INSERT INTO kij_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","E oluvi bakaimali yamagu e bukugisiga tapwagu wala, e mitaga gala wala bukugisi migigu.” ");
INSERT INTO kij_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Guyau iluki Mosese kawala, “Kuyouduli pilayu dakuna pilapupatata makawala mapilasina pilabubogwa, e bibodi balaivau mapilasina makawala wala mapilasina bogwa kukwatumimisi. ");
INSERT INTO kij_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Bukukwatubaiasa e nabwaia kaukwau bukumwena wa Koya Sinai odabala e baisa bukubodaigu. ");
INSERT INTO kij_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Gala taitala availa kamitaiyu bukumai. Gala bibodi bagisi availa wa koya, e deli sipi kaina bulumakau gala wala bikabubunasi okaikela koya.” ");
INSERT INTO kij_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","E Mosese iyouduli tuvaila pilayu pilapupatata dakuna, e eiyam kaukwau pikekita ikau mapilasina imwenei wa Koya Sinai bogwa makawala Guyau Yaubada eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","E Guyau ibusi olopola lowalowa e itoli baisa matauna, e ikavitagi yagala igibumaboma, matauna Guyau. ");
INSERT INTO kij_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","E Guyau tuta matutona ivaloula omatala e idou kawala, “Yeigu Guyau, yeigula Yaubada tokimadagi e tonokapisi yeigu, e tomanum wala. Ulo mitakwai deli ulo nokapisi gala wala bitakaibiga. ");
INSERT INTO kij_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Bavagi makawala ulo biga katotila baisa kwelakatuluwovila dala e baligaiwa si sula deli si mitugaga. Taga bogwa bamipuki litusia deli tubusia tubutolusi deli tubuvasisi paila si mitugaga veisia.” ");
INSERT INTO kij_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mosese nanakwa ikululu opwaipwaia e ikavagina. ");
INSERT INTO kij_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","E ikaibiga kawala, “Guyau, kidamwa mokwita goli layomwasali nanom, anigadaim kidamwa yoku deli yakamaisi bitalosi. Matausina tomota saina kasai dubasi, taga anigadaim kidamwa yoku bukuligaiwa ma sulasi deli ma mitugagasi, e bukuvakadaimasi yakamaisi m tomota tatoum.” ");
INSERT INTO kij_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Guyau iluki Mosese kawala, “Baisa tuta bakabutu baisa mina Isireli. Omitasi bavagi vavagi kwevakaigaga, e makwaisina gala kwaitala tuta eiviloubusi ambaisa odabala pwaipwaia oluwalaisi mina watanawa. Tomota komwaidosi bigisaisi ammakawala kasi kwaiveka vavagi makwaisina avaka yeigu Guyau gagabila bavagi. Paila bavagi kwaitala vavagi kwevakaigaga paila yokomi e bitutuvakau ninami. ");
INSERT INTO kij_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Kukwabikuwolaisi makwaisina karaiwaga avaka asisakaimi lagaila. Ka, avai tuta bukusuvaisi kulumi, e bogwa babokavili mina Amora, mina Kenani, mina Itai, mina Peresi, mina Ivi deli mina Yebusi metoya omitami. ");
INSERT INTO kij_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Tutala bukuviloubusisi kwaitala valu, gala bukuvagaisi kwaitala biga katotila deli tomotala valu makwaina, taga bivigaki makawala kami sikula. ");
INSERT INTO kij_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mitaga kaimapula wala si kabolula kukwatudidaimisi, si kokola kaibumaboma kukwatuwolaisi, e kutauwolaisi kabutuvitusila si yaubada minana Aserai. ");
INSERT INTO kij_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Gala bukutapwarorusi baisa tuwoli yaubada. Paila yeigu Guyau e gala wala atagwala bukutapwarorusi baisa availa mwada kaimapugu. ");
INSERT INTO kij_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","E gala bukuvagaisi kwaitala biga katotila deli tomotala valu makwaina - paila kidamwa bitapwarorusi baisa si yaubada tokolu e bilulasi baisa minasina, e bidouwaimi mwada bukutapwarorusi deli matausina, e kaina bitamnabaimi bukukomasi kaula makwaina eivigakaisi si lula baisa si yaubada. ");
INSERT INTO kij_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","E litumia kaina bivaiyasi minasina vilesi makwaina valu e minasina bivakadaisi matausina kidamwa gala bikamiabaigusi e deli bitapwarorusi baisa si yaubada sasopa. ");
INSERT INTO kij_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Gala bukububulaisi e gala bukutapwarorusi baisa yaubada tanumnumta. ");
INSERT INTO kij_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Bukupakasi Beredi Gala Deli Kala Yisi Pakala. Avaka bogwa lakaraiwogaimi, bukukwamsi beredi gala deli kala yisi biboda kwailima kwaiyu yam otubukonela Abibi, paila olopola tubukona minana lokusilavaisi Itipita. ");
INSERT INTO kij_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Komwaidona kuluta tauwau deli nabulutuvalu si kuluta nammwala, baisa yeigu ulo vavagi. ");
INSERT INTO kij_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mitaga komwaidona kuluta minasina ase bukukwatumapwaisi e kaimapula bukusemakavaisi natana lam baisa yeigu. Kidamwaga gala bukukwatumapwaisi makawala e kukouwolaisi kaiyasi minasina. Tuvaila ibodi bukukwatumapwaisi komwaidosi kuluta tauwau. “Gala availa ibodi bitotu baisa omatagu kidamwa gala kwaitala semakavi oyamala. ");
INSERT INTO kij_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Bogwa lasakaimi kwailima kwaitala yam paila bukuwotetilasi. Mitaga kwailima kwaiyuwelaga yam gala bukupaisewasi, gala otutala supusopu kaina otutala tayoyuwa. ");
INSERT INTO kij_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Bukuvagaisi Tayoyuwa Pakala avai tuta kuvitouulasi tayoyuwala kami witi. E bukuvagaisi Buliyoyova Pakala avai tuta okuvinakwaisi tayoyuwa wa tuta makwaina kukougugulaisi kai kaiuwala. ");
INSERT INTO kij_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Tauwau komwaidomi kwaitala taitu bukusivatolusi tapwaroru baisa yeigu Guyau, mina Isireli si Yaubada. ");
INSERT INTO kij_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Paila yeigu babokavili makwaisina boda metoya omitami, e makawala bakatumkulovi kami kaligei e mapaila gala avai tomota mwada biyoulisi mi valu otutala paka kwaitolu makwaisina. ");
INSERT INTO kij_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Avai tuta kusemakavaisi mauna paila bukuvigakaisi lula baisa yeigu, e gala bukusemakavaisi beredi deli kala yisi. Avai tuta kukwamsi Luvapela Pakala, taga kukwatuyumalaisi avaka bikaboyuva paila eiyam. ");
INSERT INTO kij_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Taitu kwaitala kwaitala avai tuta bukuyokavalasi kami witi ibodi bukumaiyaisi kala kavala Guyau ola bwala. “Avai tuta bukusulaisi nagwadi sipi kaina gota, gala bukuvigakaisi inisia nunusi kami yavau.” ");
INSERT INTO kij_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Guyau iluki Mosese kawala, “Kugini makwaisina biga. Paila makwaisina biga yeigu avigaki uula ulo kabutu deli yoku, e deli goli mina Isireli.” ");
INSERT INTO kij_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","E Mosese isikaiwa Guyau kweluwovasi yam deli bogi, gala kamkwam gala momom. E odakuna mapilasina pilapupatata igini bigala kabutu, baisa Karaiwaga Kwailuwotala. ");
INSERT INTO kij_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Avai tuta Mosese ibusi metoya Koya Sinai, e ikikau Karaiwaga Kwailuwotala, e migila ivivivila, paila kasitaiyu Guyau eibigatonasi. Mitaga matauna gala wala inikoli migila kala guyugwayu. ");
INSERT INTO kij_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","E Eroni deli tomota komwaidosi ivitalaisi Mosese, e igisaisi migila ivivivila, e saina ikukolaisi bilokaiasi katitaikinela. ");
INSERT INTO kij_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mitaga Mosese idou matausina, Eroni deli kasi tokugwa mina Isireli, e ilokaiasi matauna, e Mosese ililivala baisa matausina. ");
INSERT INTO kij_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Oluvi, komwaidosi tomota imakaiasi matauna, e Mosese iluki matausina komwaidona karaiwaga avaka Guyau eisaiki matauna odabala Koya Sinai. ");
INSERT INTO kij_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Avai tuta Mosese ivenoku lilivala baisa matausina, e ivilili kala geba ikatubodi migila. ");
INSERT INTO kij_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","E tuta matutosina Mosese bisuvi Guyau ola Buliyoyova paila Guyau kasitaiyu bibigatonasi, e ivilili kala geba isaim. E avai tuta bisunapula biluki mina Isireli komwaidona vavagi avaka Guyau eikaraiwogi bilivala, ");
INSERT INTO kij_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","e bigisaisi migila visigala. E oluvi bivililivau kala geba bisisu wala igau avai tuta bikeiitavau paila Guyau kasitaiyu bibigatonasi. ");
INSERT INTO kij_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosese ikouguguli komwaidosi mina Isireli e iluki matausina kawala, “Ka, baisa makawala Guyau eikaraiwogaimi bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mi yam kwailima kwaitala paila bukuvagaisi mi paisewa, mitaga yam kwailima kwaiyuwela ibodi bukukwabomaisi, yam makwaina kami yamveka wala bukuuvaiwasisi, deli bukukwabomaisi paila yeigu Guyau. E availa bivagi avai paisewa wa yam makwaina, ibodi wala bukukwatumataisi. ");
INSERT INTO kij_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Gala goli bukuvakatasi kova omi valu yam Sabate.” ");
INSERT INTO kij_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mosese iluki komwaidosi mina Isireli kawala, “Ka, baisa makawala Guyau eikaraiwogaimi. ");
INSERT INTO kij_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ibodi bukusemakavaisi baisa Guyau. Mapaila availa availa magisi bisemakavaisi, ibodi bimaiyaisi si semakavi goula, kaina siliba, kaina barasi; ");
INSERT INTO kij_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kaina karekwa yakakalaia eiyoudulaisi metoya sipi unuunula kasi vau burum, dairarugu deli bweyani; kaina karekwa eibisikaisi metoya gota unuunula, ");
INSERT INTO kij_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kaina sipi nammwala unuunisi eilaleisi bweyani; kaina mauna kanuvinela; kaina meku, ");
INSERT INTO kij_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","kaina kevakeva paila kaitapa; kaina vana paila vaputuma bulamila deli paila lula maiina simasimina; ");
INSERT INTO kij_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","kaina dakuna kaneliani isim mapula mwau, kaina avai veiguwa tuvaila paila bisailasi omatala miyana epodi yabumaboma eisisikoma Tolula Toveka deli okala kuwa. ");
INSERT INTO kij_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Ka, availa availa matausina tokataraki youdila oluwalaidasi, ibodi biyoudulaisi vavagi komwaidona avaka Guyau bogwa eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ka makwaina Buliyoyova, miyasina katuvala, deli miyasina bivakalupoli, makaisina kokola deli kala kailasau, mabubosina poula, makaisina kokolela, deli makwaisina ulilaguvala; ");
INSERT INTO kij_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","e makwaina Kabutu Didawogala, deli mabubosina katikewala, mapilana katubukolela, deli miyana tabodala makwaina, ");
INSERT INTO kij_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","makwaina tebeli, mabubosina katikewala, deli komwaidona makwaisina guguwala; deli makwaisina beredi tavigakaisi lula baisa Yaubada; ");
INSERT INTO kij_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","e kabototu paila kaitapa deli makwaisina guguwala; e makaisina kaitapa deli kevakevasi, ");
INSERT INTO kij_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","e kabogwabu lula paila lula maiina simasimina deli mabubosina katikewala; vaputuma bulamila; vavagi maiina simasimina; e miyana tabodala Buliyoyova kala lulu; ");
INSERT INTO kij_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kabogwabu lula makwaina paila lula kwegubugabu, deli kaivalela barasi olumoulela, katikewala deli komwaidona guguwala; makaina kailuya kabowina deli la kabototu; ");
INSERT INTO kij_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","miyasina taboda paila papala, kokolela deli ulilaguvala; miyana taboda paila lulu tabodala; ");
INSERT INTO kij_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","makaisina kenubiluma deli yuwoyoulela Buliyoyova deli papala, ");
INSERT INTO kij_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","deli miyasina yammatabwaila kwama paila tolula bisisikamsi avai tuta biwotitalaigusi olumoulela matabudona Bomikikila - miyasina kwama yabumaboma paila tolula Eroni deli goli litula.” ");
INSERT INTO kij_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","E komwaidosi mina Isireli ibutusi, ");
INSERT INTO kij_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","mapaila availa availa magisi bisemakavaisi, matausina isemakavaisi baisa Guyau paila kala kaliai la Buliyoyova. E matausina imaiyaisi komwaidona avaka bibudoki paila tapwaroru wotitalela deli tolula kasi kwama bibisikaisi. ");
INSERT INTO kij_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","E komwaidosi availa magisi bisemakavaisi tauwau deli vivila, imaiyaisi si semakavi vasia isim kasi katububula, paya, kakalougwa, kuwekuwa, deli goli katububula ituwoli ituwoli eibubulokaisi metoya goula e ikabomaisi komwaidona makwaisina baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","E availa availa matausina iyosisi karekwa yakakalaia eiyoudulaisi metoya sipi unuunula kasi vau burum, dairarugu, kaina bweyani, karekwa eibisikaisi gota unuunusi, kaina sipi nammwala kanuvinesi eilalaisi bweyani; kaina mauna kanuvinesi yamatabwaila, imaiyaisi wala. ");
INSERT INTO kij_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Komwaidona availa availa ibodi bisemakavaisi siliba, kaina barasi, imaiyaisi si semakavi baisa Guyau, deli availa availa iyosisi meku paila bibudoki avai youdila tuvaila ivigakaisi si semakavi. ");
INSERT INTO kij_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Komwaidosi nunumoya minasina nakatavatu youdila imaiyaisi wotunula karekwa yakakalaia, deli wotunu metoya sipi unuunula kasi vau burum, dairarugu, deli bweyani, miyasina goli leibisikaisi yumasi. ");
INSERT INTO kij_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","E tuvaila minasina iviraisi wotunu metoya gota unuunula. ");
INSERT INTO kij_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","E matausina tokaraiwaga imaiyaisi dakuna kaneliani deli avai veiguwa tuvaila paila bipakaisi otapwala miyana epodi yabumaboma deli goli mapilana kuwekuwa pilapatata. ");
INSERT INTO kij_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Tuvaila imaiyaisi bulami deli kevakeva paila makaisina kaitapa, deli vana paila vaputuma bulamila, deli paila lula maiina simasimina. ");
INSERT INTO kij_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","E komwaidosi mina Isireli availa availa magisi bisemakavaisi baisa Guyau, matausina isemakavaisi paila wotetila makwaina Guyau leikaraiwogi Mosese bivagi. ");
INSERT INTO kij_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mosese iluki mina Isireli kawala, “Guyau bogwa einagi Besaleli matauna Uri latula e tabula Ura, metoya odalela Yuda. ");
INSERT INTO kij_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Yaubada la peula bogwa eivakasau matauna deli isaiki la katavatu, la kabitam tuvaila la ninitalapula paila kala katuginigini youdila kwaitala kwaitala, ");
INSERT INTO kij_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","deli bininamsi ammakawala leilai kala kimadagi e bikatuginigini goula, siliba, deli barasi, ");
INSERT INTO kij_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","tuvaila veiguwa kala titavisi deli bikibuboti, deli paila bilaleya kai; deli goli kala katuginigini avai leilai avai leilai. ");
INSERT INTO kij_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Guyau bogwa leisaiki si kabitam, matauna deli Owoliabi matauna Aisamaki latula metoya odalela Dani, paila biyomitalaisi si katavatu paila youdila baisa sesia. ");
INSERT INTO kij_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","E Guyau bogwa leisaiki matausina si katavatu paila bivagaisi komwaidona paisewa makwaisina totaisi dakuna leiuvagaisi, deli toleilai, toviriviri karekwa yakakalaia, wotunu leiyoudulaisi metoya sipi unuunula kasi vau burum, dairarugu deli bweyani deli goli avai karekwa wala. Matausina ibodi bivagaisi avai youdila wala, paila matausina saina tokatavatu katuginigini. ");
INSERT INTO kij_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Besaleli, Owoliabi deli komwaidona toyoudila matausina goli Guyau bogwa eisaiki si katavatu deli si ninitalapula, matausina bogwa eikatetasi paila biyoudulaisi youdila kwaitala kwaitala avaka bibudoki paila kala kaliai Buliyoyova Kwebumaboma, e matausina ibodi biyoudulaisi komwaidona guguwa makawala Guyau eikaraiwogi bivagaisi.” ");
INSERT INTO kij_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","E Mosese idou Besaleli, Owoliabi deli goli komwaidosi sesia tokatavatu matausina Guyau bogwa leisaiki si kabitam deli tuvaila eitugwalaisi titoulesi paila bipilasisi, e Mosese iluki matausina bivitouulasi paisewa. ");
INSERT INTO kij_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Matausina ibanaisi komwaidona mina Isireli si semakavi makwaisina eimiakaisi Mosese paila kala ulai Buliyoyova. Mitaga mina Isireli si semakavi isetuwolaisi wala kaukwau kwaitala kwaitala imiakaisi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Oluvi tauwau matausina eiyoudilasi ilosi ");
INSERT INTO kij_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ilukwaisi Mosese kawasi, “Mwa, avaka tomota eimmaiyaisi saina bidugaga e paisewa makwaina avaka Guyau eikaraiwogi bakavagaisi biwokuva e bigugulom goli.” ");
INSERT INTO kij_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mapaila Mosese iwitali karaiwaga itavina itapatu osi kabosikaiwa ikatuloki tomota gala taitala tuvaila bimai avai vavagi tuvaila paila makwaina Buliyoyova. Mapaila tomota gala tuvaila ikatuyoulasi guguwa. ");
INSERT INTO kij_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Paila avaka bogwa leimaiyaisi saina bidugaga, bogwa eibodi bivigimkulovaisi paisewa komwaidona e bigugulom goli. ");
INSERT INTO kij_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","E matausina saina tokatavatu deli eipupaisewasi, ikaliaiisi Guyau la Buliyoyova. E itabodaisi makwaina metoya yaluwotala karekwa yakakalaia, e ibisigolaisi deli sipi unuunula kasi vau burum, dairarugu, deli bweyani. Ibasaisi otupwasi miyasina kaikobusi mauna isim pinupanela. ");
INSERT INTO kij_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Yatala yatala miyasina ivagaisi kasi vakaila makawala wala, kasi wonaku uvalima uvatala e kasi beiyaya uvatala. ");
INSERT INTO kij_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","E ibisitukwaisi yalima ila gulotala, e yalima ila guloyuwela. ");
INSERT INTO kij_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","E metoya magulosina guloyu karekwa ilapwaisi yaburum buluva okaipagasi miyasina otapwala. ");
INSERT INTO kij_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","E magulona gulomatala karekwa ilapwaisi kweluwolima buluva okaipagala miyana eikanumatala, e guloyuwela ilapwaisi kweluwolima buluva okaipagala miyana kala vigimkovila. E guloyu wala kasi gigisa makawala. ");
INSERT INTO kij_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","E iyoudulaisi kasiluwolima kailasau metoya goula, paila bisagaisi magulosina guloyu karekwa bivigaki gulotala wala. ");
INSERT INTO kij_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","E oluvi matausina ibasaisi yatala katuvala Buliyoyova metoya miyasina karekwa yaluwotala yatala eibasaisi metoya gota unuunusi. ");
INSERT INTO kij_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ivagaisi miyasina komwaidona wala makawala kasi vakaila, kasi wonaku uvalima uvatala isividoga, e kala beiyaya uvatala. ");
INSERT INTO kij_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ibisitukwaisi yalima bila gulotala e yalima yatala bila guloyuwela. ");
INSERT INTO kij_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","E matausina ilapwaisi kwailuwolima buluva okaipagala miyana okala vigimkovila magulona gulomatala, e tuvaila kwailuwolima buluva okaipagala miyana kala vigimkovila magulona guloyuwela. ");
INSERT INTO kij_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","E iyoudulaisi kasiluwolima kailasau metoya tanumnumta barasi, e bisagaisi magulosina guloyu karekwa bivigaki yatinidesila wala. ");
INSERT INTO kij_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","E iyoudulaisi yayu tuvaila katuva. Yatala metoya sipi nammwala kanuvinesi eilalaisi kala vau bweyani, e yayuwela metoya kanuvinesi mauna ituwoli, miyasina paila eivakalupolaisi katuva. ");
INSERT INTO kij_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Matausina iyoudulaisi baba metoya meku paila youdulela Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Pilatala pilatala mapilasina kala wonaku iboda uvayu, e kala beiyaya iboda yumatala. ");
INSERT INTO kij_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Kaipagasi ikibwelakaisi wala iwokuva, e igagabila bikavatowasi e bikaili wala bikanam. Komwaidona baba mapilasina eiyoudulaisi makawala wala kasi gigisa. ");
INSERT INTO kij_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Matausina iyoudulaisi pilaluwoyu paila mapilana opilibolimila ");
INSERT INTO kij_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","e kwailuwovasi ulilaguva paila mapilasina bitoulasi, pilatala baba kwaiyu ulilaguvala. ");
INSERT INTO kij_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Matausina iyoudulaisi pilaluwoyu baba paila mapilana opiliyavatela Buliyoyova ");
INSERT INTO kij_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","deli kwailuwovasi ulilaguva, kwaiyu paila pilatala baba. ");
INSERT INTO kij_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","E paila mapilana opwasosiula Buliyoyova opilikwaibwaga, matausina iyoudulaisi pilalima pilatala baba ");
INSERT INTO kij_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","e pilayu baba paila biwaisi tupa owokulula. ");
INSERT INTO kij_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Mapilasina iwaisi tupa owokulula ikailaisi watanawa, itotu goli ila walakaiwa. Mapilasina baba eiwaisi tupa owokulula eivigaki totomla Buliyoyova ivigakaisi makawala. ");
INSERT INTO kij_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Mapaila mapilasina baba kasi bawa pilalima pilatolu e kwailuwotala kwailima kwaitala ulilaguva, pilatala baba kwaiyu ulilaguvala. ");
INSERT INTO kij_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Matausina iyoudulaisi kailuwotala kailima kavala metoya meku, kailima paila kavalela baba pilatala Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","kailima paila piliyuwela, e kailima paila opwasousiu, mapilana opilikwaibwaga. ");
INSERT INTO kij_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","E kavala makaiwena eikanuwalai baba, makaina kaiwonaku, kabulotala Buliyoyova eila kabuloyuwela. ");
INSERT INTO kij_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","E matausina ikatububulaisi baba mapilasina goulawokuva deli iyoudulaisi nonoitasi goula paila bikikuloti kavala makaisina, e deli goli kavala eikatububulaisi goula. ");
INSERT INTO kij_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ibasaisi yatala taboda yakakalaia metoya sipi unuunula kasi vau burum, dairarugu, deli bweyani, e ibasaisi otapwala miyana kaikobusi mauna isim pinupanesi. ");
INSERT INTO kij_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","E isagaisi miyana okailasau makavisina otupwasi kokola makaisina kaivasi meku leipakaisi goulawokuva wala, e ivitauwaisi oulilaguva makwaisina kwaivasi silibawokuva wala; ");
INSERT INTO kij_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","paila Buliyoyova kala lulu ibasaisi yatala karekwa yakakalaia metoya sipi unuunula, kasi vau burum, dairarugu, deli bweyani, eibasaisi kala katububula. ");
INSERT INTO kij_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","E iyoudulaisi kailima kokolela miyana taboda metoya meku, e ipakaisi goula otupwasi makaisina, e isagaisi miyana okailasau makavisina goulawokuva wala, e iyoudulaisi kwailima ulilaguva metoya barasi paila bitoulisi makaisina kokola. ");
INSERT INTO kij_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","E Besaleli iyouduli Kabutu Didawogala metoya meku, kala woloula tomwaidona e kala beiyaya yumatala, e lomla yumatala. ");
INSERT INTO kij_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Matauna ipaki goulatoula e ikuboli kai olopola deli otapwala, deli ivigaki kaidadela goulawokuva wala itavina itapatu. ");
INSERT INTO kij_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Matauna iyouduli kwaivasi kala nonoita metoya goula wala, e ikatuvilatu makwaisina okaikela makweyasina kweyavasi, e ivigaki kwaiyu pilatala kwaiyu piliyuwela. ");
INSERT INTO kij_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Matauna iyouduli katikewala metoya meku, e ipaki goula ikuboli makaisina katakewa, ");
INSERT INTO kij_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","e ikaluvisuvi makaisina ononoita makwaisina leikatuvilatu okaipagala didawaga. ");
INSERT INTO kij_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","E iyouduli katubukolela makwaina metoya goulatoula, kala woloula tomwaidona, e kala beiyaya yumatala. ");
INSERT INTO kij_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Itutu goula e ibubuli nayu mauna isim pinupanesi, ");
INSERT INTO kij_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","e ivitau natana kabulotala katukwabula, e nayuwela kabuloyuwela. Ikatupituki minasina okatukwabula e ivigaki bitovagasisi wala baisa. ");
INSERT INTO kij_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","E matauna isimapu mauna minasina, matala sola matala sola igisamapusi, e pinupanesi ivakanunuvi katukwabula. ");
INSERT INTO kij_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Matauna ikatuvilatu tebeli kwaitala metoya meku, kala woloula isividoga, e kala beiyaya okatupoi, e kaikela kala woloula yumatala. ");
INSERT INTO kij_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Odabala makwaina matauna ipaki goulatoula, e kaidadela ipaki goula wala itavina itapatu. ");
INSERT INTO kij_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Iyouduli kala kaidada beiyayela kweyatala sikwekula; e ipaki goula wala itavina itapatu. ");
INSERT INTO kij_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","E iyouduli kwaivasi nonoita paila katakewa, e ikatuvilatu okaikela tebeli owokulula kwaivasi. ");
INSERT INTO kij_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Nonoita makwaisina paila katakewa, e ikatuvilatu opapala kaidadela tebeli. ");
INSERT INTO kij_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Iyouduli katakewa metoya meku, e ipaki goula wala otupwasi makaisina. ");
INSERT INTO kij_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Iyouduli kaboma, viga, kwaibolu, deli kailuya; paila guguwala waini semakavila. E komwaidona guguwa makwaisina iyouduli metoya goulatoula wala. ");
INSERT INTO kij_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Matauna iyouduli kaitapa kaikela metoya goulatoula. Itutu goula e ibubuli la kabototu deli kaila; e katububulela makaisina lala, luwai, deli lalela. Matauna ibubuligoli kaitinidesila wala. ");
INSERT INTO kij_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ibubuli sisilima sisitala sisila opapala, sisitolu pilatala sisitolu piliyuwela. ");
INSERT INTO kij_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","E masisisina sisi, sisitala sisitala kala katububula kaitolu lala kasi gigisa makawala parani iluwaisi e ilalasi. ");
INSERT INTO kij_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","E kaila makaina kaitapa la kabototu kala katububula kaivasi lala kala gigisa makawala parani, iluwai e ilala. ");
INSERT INTO kij_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Sisitala sisitala lalesi itakasasi kasatinidesila wala ila itobu okaila. ");
INSERT INTO kij_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Metoya kwaitala wala goulatoula matauna itutu e ibubuli lalela, sisila deli kaila. ");
INSERT INTO kij_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ibubuli kailima kaiyu kaitapa paila makaina kaitapa la kabototu, deli ibubuli kaivila kekarisigila kova deli kabomala metoya goulatoula. ");
INSERT INTO kij_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Matauna iyosi goulatoula kala mokaila makawala lima yuwa petala kaula (35 kg), e iyouduli makaina kaitapa la kabototu deli goli komwaidona guguwala. ");
INSERT INTO kij_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Matauna iyouduli kwaitala kabogwabu lula metoya meku, paila bigibugabu lula maiina simasimina. E kala beiyaya deli kala wonaku ibodasi wala pilayu wala imaisi oyumakwasi. E kaikela kala woloula ima okuvilu. E odabala owokulula makwaisina kwaivasi kala sukusaku ivigaki kwetinidesila wala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Matauna ipaki goulatoula odabala, opapala pilavasi wala deli okala sukusaku, e kaipagala iyouduli goulawokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Iyouduli kwaiyu nonoita okaipagala pilayu wala paila bisuvi katikewala. ");
INSERT INTO kij_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Iyouduli katakewala metoya meku, e ipaki goula otupwasi. ");
INSERT INTO kij_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Matauna igabu vaputuma bulamila kebumaboma, deli bulamila lula maiina simasimina, e maiina bikaipuyuma makawala bulami kaisimasimina. ");
INSERT INTO kij_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","E matauna iyouduli kwaitala kabogwabu lula metoya meku paila bigubugabu lula. E kala beiyaya deli kala woloula iboda wala uvatala, e kaikela kala woloula ima okuvilu. ");
INSERT INTO kij_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","E odabala owokulula kwaivasi matauna ikisali kala sukusaku, e ivigaki kwetinidesila wala kabogwabu lula, e kwemwaidona wala ipaki barasi wala. ");
INSERT INTO kij_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Iyouduli kavaega paila tubwagela lula, deli kaitapana, kailuya, kaisusuwa, deli kova kaisakaila. Komwaidona guguwela eiyouduli metoya tanumnumta barasi. ");
INSERT INTO kij_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Matauna iyouduli kaitala kevalela metoya tanumnumta barasi e isaili kaivala makaina osikowala kaidadela kabogwabu lula makwaina, e gagabila kaivala makaina bikanuwalai wala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Deli iyouduli kwaivasi nonoita e ikatupituki makwaisina owokulula kwaivasi kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","E iyouduli katikewala metoya meku, e otupwasi makaisina ipaki barasiwokuva wala; ");
INSERT INTO kij_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","e ikaluvisuvi makaisina ononoita. Matauna iyouduli baba e itabodi kabogwabu lula, e olopolaga ikikapogega wala. ");
INSERT INTO kij_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","E matauna iyouduli kaitala kailuya metoya tanumnumta barasi, e tuvaila la kabototu iyouduli metoya si saribu vivila minasina eiwotetilasi wa lulu ola kabosusuvi Guyau ola Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","E paila Guyau la Buliyoyova tabodala, matauna iyouduli metoya karekwa yakakalaia. E mapilana opilibolimila iyouduli taboda kala woloula uvaluwoyu uvayu, ");
INSERT INTO kij_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","e iyouduli keluwoyu kokola metoya tanumnumta barasi; e kweluwoyu ulilaguva, deli kailasau toyo wotunula iyouduli metoya siliba wala. ");
INSERT INTO kij_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","E tuvaila mapilana taboda opiliyavata ivagi makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","E mapilana opilikwaibwaga iyouduli taboda kala woloula uvaluwotala uvatala, deli kailuwotala kokola, e kweluwotala ulilaguva, deli kailasau toyo wotunula iyouduli metoya siliba. ");
INSERT INTO kij_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","E mapilana opilibomatu, ambaisa lulu metitoki, iyouduli taboda kala woloula uvaluwotala uvatala. ");
INSERT INTO kij_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","E wa lulu opapala pilatala deli piliyuwela iyouduli miyasina karekwala taboda uvatolu yumatala kala maloula, deli kaitolu kokola e kwaitolu ulilaguva. ");
INSERT INTO kij_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Komwaidona tabodala Buliyoyova eitavina eitapatu, iyoudulaisi metoya karekwa yakakalaia. ");
INSERT INTO kij_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","E kokola ulilaguvasi iyouduli metoya barasi, e kailasau deli yuwoyoulesi, deli kokola dubasi katubukolesi iyouduli metoya siliba. E taboda komwaidona kokolela eitavina eitapatu matauna iwaiya kopala metoya yuwoyoula silibawokuva. ");
INSERT INTO kij_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","E tabodala Buliyoyova kala lulu iyoudulaisi taboda miyana metoya karekwa yakakalaia, eibisitukwaisi metoya sipi unuunula kasi vau burum, dairarugu deli bweyani, miyana ibasaisi isim kala katububula, e kala maloula uvavasi isividoga e kala woloula bila walakaiwa uvatala, makawala miyana tabodala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Miyana taboda bikana wala otupwasi makaisina kokola kaivasi, ulilaguvasi kwaivasi. E kailasau, kokola odubasi katubukolesi, deli yuwoyoula iyoudulaisi metoya siliba. ");
INSERT INTO kij_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Komwaidona Buliyoyova kala kenubiluma, deli tabodala iyoudulaisi metoya tanumnumta barasi. ");
INSERT INTO kij_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Baisa makawala kala bawa tanumnumta eikaliakaisi Guyau la Buliyoyova, e mapilasina pilayu dakuna leiginaisi karaiwaga kweluwotala baisala mekikanaki. E Mosese ikaraiwogi mina Libai iginaisi kala bawa tanumnumta komwaidona. Mapaila Itama matauna tolula Eroni latula ikugwai mina Libai paila leivagaisi paisewa makwaina. ");
INSERT INTO kij_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","E Besaleli matauna Uri latula, tabula Ura, metoya odalela Yuda ivagi vavagi komwaidona makawala Guyau bogwa leikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","E kala topilasi matauna Owoliabi matauna Aisamaki latula metoya odalela Dani, la paisewa katuginigini, leilai, deli biviriviri karekwa yakakalaia deli wotunu metoya sipi unuunula kasi vau burum, dairarugu, deli bweyani. ");
INSERT INTO kij_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Komwaidona goula makwaisina bogwa leikabomaisi baisa Guyau paila makwaina Buliyoyova Kwebumaboma kala mokaila makawala lakatuyu petala kaula (1,000 kg), makawala tokaraiwaga bogwa leinagaisi kala bawa. ");
INSERT INTO kij_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","E siliba metoya baisa matausina topokapokala leisailisi kala mokaila iboda makawala gulotala taitu uvalima uvavasi (3,430 kg), makawala tokaraiwaga bogwa leinagaisi kala bawa. ");
INSERT INTO kij_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Baisa makawala kala bawa komwaidosi matausina topokapokala bogwa eisailisi, taitala taitala isaili makawala avaka tokaraiwaga bogwa leinagaisi. Matausina tauwau kasi taitu bogwa eibodi kweluwoyu kaina kweluwoyu kesa leiginaisi osonukula kasi bawa iboda 603,550 tomota. ");
INSERT INTO kij_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","E metoya siliba makwaina, kala mokaila iboda makawala gulotala taitu uvalima uvavasi (3,400 kg) iyoudulaisi lakatutala ulilaguvala Buliyoyova Kwebumaboma deli goli miyana taboda, ulilaguva kwaitala kwaitala eikau siliba kala mokaila makawala lima yuwa petala kaula (34 kg). ");
INSERT INTO kij_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Metoya baisa kesala siliba kala mokaila makawala lima tala petala kaula (30 kg). Besaleli iyouduli yuwoyoula, kailasau paila bisagaisi okokola, deli kokola dubasi katubukolela. ");
INSERT INTO kij_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","E barasi baisa bogwa leikabomaisi baisa Guyau kala mokaila makawala gulotala taitu uvalima uvayu (2,425 kg). ");
INSERT INTO kij_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Metoya baisa iyouduli ulilaguvala kokola makaisina wa lulu Guyau ola Buliyoyova, deli kabogwabu lula makwaina barasi deli goli kaivalela, deli komwaidona guguwala makwaina kabogwabu lula, ");
INSERT INTO kij_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kokola ulilaguvasi opapala eitavina eitapatu deli wa lulu, deli komwaidona kenubiluma paila Buliyoyova deli goli papala. ");
INSERT INTO kij_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","E metoya wotunu eiyoudulaisi metoya sipi unuunula kasi vau burum, dairarugu deli bweyani iyoudulaisi kwama yaminibwaita paila tolula bisisikomasi tutala biuwotetilasi olumoulela matabudona Bomikikila. Matausina iyoudulaisi tolula kwamala paila Eroni, makawala avaka Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Matausina iyoudulaisi miyana epodi metoya karekwa yakakalaia iyoudulaisi metoya sipi unuunula kasi vau burum, dairarugu, deli bweyani; deli wotunula metoya goula. ");
INSERT INTO kij_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Matausina ikatupitukwaisi goula e itaiyasi yasisikwa paila biyoudulaisi olumoulela karekwa yakakalaia deli sipi unuunula kasi vau burum, dairarugu, deli bweyani. ");
INSERT INTO kij_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Matausina iyoudulaisi yayu wotunula miyana epodi e ibisitukwaisi opapala miyana epodi, e gagabila bipilakavataisi deli miyana epodi. ");
INSERT INTO kij_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","E duriduri makwaina eikimidagaisi kala bisibasi, eibisikaisi metoya youdila makwaisina wala, ibisitukwaisi deli miyana epodi gagabila bivigaki yatinidesila wala, makawala Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Matausina ikatubiasaisi dakuna yagasi kaneliani e ikatuginiginaisi mapilasina dakuna goulawokuva wala, matausina inagaisi taitala tokataraki dakuna kala youdila, e itaiya otupwasi mapilasina dakuna yagasi Yekobe litula, tailuwotala taiyu. ");
INSERT INTO kij_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","E isipwaisi mapilasina dakuna owotunu miyasina ovitakola, e ipilakavataisi miyana epodi paila kabotuvitusila dala Isireli dilaluwotala dilayu; makawala avaka Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Matausina iyoudulaisi kwaitala kuwa metoya youdila makwaisina wala leiyoudulokaisi miyana epodi deli kala katuginigini makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kala maloula deli kala beiyaya makawala wala, deli ikatupokaisi pilayu, kala woloula ima okabotakuwa, e kala beiyaya makawala wala. ");
INSERT INTO kij_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","E itakasaisi kwaivasi dakuna kwevivivila otapwala mapilana. Kasamatala makasana itakasaisi dakuna makwaisina, kwaitala rubi, kwaitala topasi, deli kwaitala ganeti, ");
INSERT INTO kij_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","e kasayuwela, kwaitala emerodi, kwaitala sapaya deli kwaitala daimoni; ");
INSERT INTO kij_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","kasatolula, kwaitala tekwesi, kwaitala ageiti, deli kwaitala ametisi, ");
INSERT INTO kij_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","kasavasila, kwaitala berili, kwaitala kaneliani, deli kwaitala yasipa. Makwaisina dakuna ikatuginiginaisi goulawokuva wala. ");
INSERT INTO kij_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","E kweluwotala kwaiyu dakuna itaiyasi odubasi yagasi Yekobe litula, paila kabotuvitusila dala Isireli dilaluwotala dilayu. ");
INSERT INTO kij_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","E kuwa mapilana wotunula iyoudulaisi metoya goulawokuva wala, iviraisi makawala yuwoyoula kala viriviri. ");
INSERT INTO kij_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Iyoudulaisi kwaiyu kakalougwa goulawokuva wala, e ikatupitukwaisi makwaisina wa kuwa okaipagala owokulula kwaiyu walakaiwa. ");
INSERT INTO kij_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Oluvi isipwaisi miyasina yayu wotunu goulawokuva okakalougwa makwaisina ");
INSERT INTO kij_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","e matalaga makabulosina kabuloyu wotunu isipwaisi okailasau makavisina, e bogwa goli makawala baisa, ibisitukwaisi makavisina omatala miyana wotunula epodi. ");
INSERT INTO kij_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Iyoudulaisi kwaiyu tuvaila kakalougwa goulawokuva, e ibisitukwaisi wa kuwa okaipagala owokulula kwaiyu watanawa, baisa goli kaipagala olumoulela ambaisa bikanapituki miyana epodi. ");
INSERT INTO kij_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","E iyoudulaisi kwaiyu tuvaila kakalougwa goulawokuva, e ibisitukwaisi makwaisina osikowala miyasina wotunula epodi miyana omatala bila katitaikinela kuvilu okaipagala epodi, e odabala makwaina duriduri leikimidagaisi kala bisibasi. ");
INSERT INTO kij_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Makawala avaka Guyau eikaraiwogi Mosese, matausina ikauwaisi wotunu kala vau burum, e isipwaisi okakalougwa makwaisina eibisitukwaisi wa kuwa, e ilaga okakalougwa makwaisina eibisitukwaisi deli miyana epodi, e kuwa mapilana isila wala odabala makwaina duriduri e gala gagabila bikapusi. ");
INSERT INTO kij_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","E kwama miyana epodi eivakalupoli ibasaisi yamwaidona wala yaburum metoya sipi unuunula. ");
INSERT INTO kij_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","E itabolusi walakaiwa paila pwaneta, e ponana maponinana kaipagala iviraisi ipoupou taga bidadaimi. ");
INSERT INTO kij_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","E okabulumwaisala miyana, ikisonusi kala puluweiwa metoya sipi unuunula kasi vau burum, dairarugu, toyo bweyani, e deli ikalumolaisi makwaisina isaili bela kekikekita goulawokuva wala, makawala avaka Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Matausina iyoudulaisi mimilisi kwama; ");
INSERT INTO kij_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","kulupaipi, kulupewa, sevalopula, ");
INSERT INTO kij_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","deli duriduri metoya karekwa yakakalaia eiyoudulaisi metoya sipi unuunula kasi vau burum, dairarugu, deli bweyani sipi unuunula paila Eroni deli litula; matausina ibasaisi kasi katububula deli ikatuginiginaisi, makawala Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","E iyoudulaisi kwaitala saveva metoya goulatoula, makwaina goli kabotuvitusila kaboma kwebumaboma e itaiyasi otapwala biga mabigasina, “Takabomaisi baisa Guyau.” ");
INSERT INTO kij_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","E wotunula saveva makwaina yaburum isipwaisi omatala kulupaipi makawala avaka Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","E komwaidona paisewa Guyau ola Buliyoyova bogwa eivigimkulovaisi. Mina Isireli iyoudulaisi vavagi komwaidona avaka Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Matausina imiakaisi Mosese katuvala Buliyoyova deli komwaidona guguwala, kala kailasau, makaisina kokola, mabubosina pou, kokolela deli ulilaguvasi; ");
INSERT INTO kij_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","katuvala miyana eiyoudulaisi metoya sipi nammwala kanuvinesi, yayuwela miyana eiyoudulaisi metoya mauna kanuvinesi; deli tabodala makwaina; ");
INSERT INTO kij_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Kabutu Didawogala makwaina eididagaisi mapilasina dakuna, katikewala, deli katubukolela makwaina; ");
INSERT INTO kij_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tebeli makwaina deli goli komwaidona guguwala, deli beredi baisa leivigakaisi lula baisa Yaubada; ");
INSERT INTO kij_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kaitapa la kabototu leiyoudulaisi metoya goulatoula, makaisina kaitapa, deli komwaidona guguwala, e kevakevala kaitapa makaisina, ");
INSERT INTO kij_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","kabogwabu lula makwaina eiyoudulaisi metoya goula, vaputuma bulamila, bulami maiina saina simasimina; e miyana tabodala Buliyoyova kala lulu; ");
INSERT INTO kij_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kabogwabu lula makwaina paila lula kwegubugabu, deli kevalela makaina barasiwokuva wala olumoulela; katikewala deli komwaidona guguwala; makaina kailuya kabowina deli la kabototu; ");
INSERT INTO kij_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","miyasina taboda paila papala, kokolela deli ulilaguvala, miyana taboda paila lulu tabodala; makaisina kenubiluma deli yuwoyoulela Buliyoyova deli papala; ");
INSERT INTO kij_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","deli miyasina yamatabwaila kwama paila tolula bisisikamsi avai tuta biuwotetilasi olumoulela matabudona Bomikikila miyasina kwama yabumaboma paila tolula Eroni deli goli litula. ");
INSERT INTO kij_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","E mina Isireli bogwa eivagaisi komwaidona paisewa makawala Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mosese igisi komwaidona vavagi makwaisina e ibani matausina bogwa eivagaisi makawala Guyau eikaraiwogi. Mapaila ikabwaili matausina. ");
INSERT INTO kij_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Tubukona namatala oyamla kwematala yoku bukukwaliaiya Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Kukwau Kabutu Didawogala lokusewoya makwaina goli Karaiwaga Kwailuwotala eikikanaki olumoulela e kutapapi makwaina. ");
INSERT INTO kij_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tebeli makwaina kusewoya e odabala kusaili guguwala wotetila. Tuvaila kaitapa la kabototu kusewoya e kuvitau kaitapa odabala makaina. ");
INSERT INTO kij_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","E kabogwabu lula makwaina eibubulokaisi goula paila bigubugabusi lula maiina simasimina kuvitau omatala Kabutu Didawogala. E kutabodi lulula Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","E omatala Buliyoyova kusaili makwaina kabogwabu paila bigibugabusi lula. ");
INSERT INTO kij_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","E kailuya makaina kusaili bitowalai Buliyoyova deli kabogwabu lula e kutavikoti sopi olumoulela makaina. ");
INSERT INTO kij_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kutapapi Buliyoyova bitavini bitapatu, e kutabodi lulula. ");
INSERT INTO kij_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Oluvi bukukwabomi Buliyoyova deli goli komwaidona guguwala metoya bulami kaibumaboma bukubulami bivigaki kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tuvaila bukukwabomi kabogwabu lula makwaina deli komwaidona guguwala metoya bukubulami makwaisina bivigaki komwaidona wala kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Deli goli bukukwabomi kailuya makaina toyo la kabototu makawala wala avaka lokuvigibogwi. ");
INSERT INTO kij_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Oluvi bukuvakouli Eroni deli litula bukumai omatala Buliyoyova e bukuluki bikakayasi. ");
INSERT INTO kij_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kuvisikoma Eroni tolula kwamela e kubulami matauna, e baisa bivigaki bogwa lokukwabomi matauna, e matauna bibodi bimila tolula paila biwotitalaigu. ");
INSERT INTO kij_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","E litula kuvisikoma kasi kwama. ");
INSERT INTO kij_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Oluvi kubulami matausina makawala lokubulami tumasi, e matausina ibodi bimila tolulasi paila biwotitalaigusi. Bulami makwaina bivigaki tolula wotitalela bikanuvagasi odalesi matausina tuta gala biwokuva.” ");
INSERT INTO kij_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","E Mosese ivagi komwaidona avaka Guyau leikaraiwogi matauna. ");
INSERT INTO kij_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kwaiyuwela taitu avai tuta bogwa leisilavaisi Itipita, otubukona minana eikalimatala wa yam ikugwa, e Guyau la Buliyoyova ikaliaiisi. ");
INSERT INTO kij_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","19","Mosese itomiliwoli kokola e ilavi kaitaula, pou deli kaivalapu, e bisiboda. E ibisibodi olumoulela e oluvi ikau kanivisi ipapi Buliyoyova makwaina, makawala Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","E ikau mapilasina pilayu dakuna pilapupatata isewoya olumoulela Kabutu Didawogala. Ikovisuvi kaitakewa oponanesi didawaga e ikatubukoli makwaina. ");
INSERT INTO kij_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Oluvi isewoya oBuliyoyova e isagi kala taboda paila bitabodi. E baisa makawala itabodi Yaubada la Kabutu Didawogala, makawala Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Isaili tebeli olumoulela Buliyoyova mapilana piliyavata otuboulola taboda, ");
INSERT INTO kij_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","e odabala isaili beredi makwaisina eisemakavaisi baisa Guyau, makawala Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Isaili kaitapa la kabototu olumoulela Buliyoyova, mapilana opilibolimila omatala tebeli. ");
INSERT INTO kij_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","E baisa omatala Guyau ivakanoti kaitapa, makawala Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Isaili kabolula goula oBuliyoyova omatala taboda, ");
INSERT INTO kij_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","deli igabu maiina simasimina, makawala Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ilasoya taboda wa lulu oBuliyoyova, ");
INSERT INTO kij_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","e baisa opapala taboda isaili kabogwabu lula. Odabala kabolula igabu mauna deli witi ivigaki lula, makawala Guyau bogwa eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Isaili kailuya kabowina oluwalaisi Buliyoyova deli kabolula e ivigogu sopi olumoulela. ");
INSERT INTO kij_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Kidamwa avai tuta bisuvisi oBuliyoyova kaina bilokaiasi kabolula, e Mosese, Eroni deli litula tauwau biwinaisi yumasi deli kaikesi baisa kailuya makaina, makawala Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","E Mosese ididali Buliyoyova deli kabolula, e deli itabodi taboda wa lulu e ikatubodi. E makawala wala bogwa ivinaku youdila komwaidona. ");
INSERT INTO kij_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","E tuta matutona mapilana lowalowa ikuboli Buliyoyova e Guyau migila lumalamela ivivivila deli guyugwayula ivakasau makwaina. ");
INSERT INTO kij_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mauula Mosese gala igagabila bisuvi olumoulela Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tuta makwaina lowalowa bogwa bikaka metoya oBuliyoyova, e mina Isireli bisoguguwasi, e bisupelasi tuwoli kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mitaga kidamwa lowalowa bisisu baisa, gala goli bisupelasi. ");
INSERT INTO kij_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tuta komwaidona osi tavina, gagabila bigisaisi mapilana lowalowa baisa Guyau migila odabala Buliyoyova otutala yam, e kova ilululu odabala makwaina Buliyoyova otutala bogi.");
INSERT INTO kij_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","E Guyau idou Mosese metoya olumoulela Guyau la Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","e iluki matauna kasi karaiwaga mina Isireli avaka ibodi bikabikuwolaisi avai tuta bigabwaisi si lula. Karaiwaga makwaisina baisa makawala. Kidamwa availa bitugwali natana mauna paila bivigaki la lula, ibodi bikasali metoya ola yawa natana la bulumakau, kaina natana la sipi kaina la gota. ");
INSERT INTO kij_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kidamwa bitugwali natana la bulumakau paila bigubuki la lula, ibodi bimai minana gala isim kala nebaneba. Matauna bimai minana bisaiki omatala Guyau la Buliyoyova, e gagabila Guyau bikabwaili matauna. ");
INSERT INTO kij_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Tau matauna bisaili yamala opwanetala minana paila lulela la mitugaga, e Guyau bikabwaili lula makwaina. ");
INSERT INTO kij_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","E makatupona wala matauna bikatumati bulumakau minana, e Eroni dalela tolula bikauwaisi buyavila bilulasi baisa Guyau. Oluvi bikatusokaisi kwemwaidona kabogwabu lula makwaina eitotu omatala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Oluvi tau matauna binini kanuvinela mauna minana, e biyali, ");
INSERT INTO kij_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","e tolula mabudona bikasaisi kai okabogwabu lula e bivakataisi kova. ");
INSERT INTO kij_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Komwaidona kabakabalela mauna minana matausina bigabwaisi wa kova, e kununela, posala deli wala bigabwaisi. ");
INSERT INTO kij_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","E tau matauna ibodi biwini yayapilela komwaidona deli kaikena makweyasina, oluvi tolula kasi todabala bigabu lula kwemwaidona okabogwabu lula. E Guyau biyomwasali nanola metoya maiinela makwaina kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kidamwa tau matauna bikasali natana la sipi kaina la gota paila la lula, ibodi bimai natana namwala deli gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Matauna bikatumati minana opiliyavatela kabogwabu lula, e oluvi mabudona tolula bikauwaisi buyavila bikatusokaisi kwemwaidona kabogwabu lula makwaina. ");
INSERT INTO kij_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Avai tuta tolimauna bogwa eiyali minana, tolula kasi todabala bisaila komwaidona makabilasina wa kova, e toyo kununa deli posa. ");
INSERT INTO kij_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","E tau matauna ibodi biwini komwaidona yayapilela deli makweyasina kaikena, oluvi tolula bisaiki Guyau kala lula, e komwaidona wala bigabu okabogwabu lula. E Guyau biyomwasali nanola metoya maiinela makwaina kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Mitaga kidamwa tau matauna bitugwali natana mauna nayoyowa paila bigubuki la lula, ibodi bikasali bubuna kaina buneroro. ");
INSERT INTO kij_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Tolula bisaila minana okabogwabu lula, matauna bikituni kaiyola e kununela bigabu okabogwabu lula. E buyavila bitayelu bim opapala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Matauna bikau mauna minana petala deli wowela komwaidona bilau ilavi opilibomatula kabogwabu lula, mapilana goli kabolovala tubwagela kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Matauna biyosa opinupanela e bitabolu minana, mitaga biyamata gala bitalakai mapilasina, oluvi bigabu minana okabogwabu lula. E Guyau biyomwasali nanola metoya makwaina kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kidamwa availa bisemakavi kaula baisa Guyau, e matauna ikugwa bikikili bimila pwarawa. E matauna ibodi bitaguliki olibe bulamila deli maiina simasimina odabala makwaina ");
INSERT INTO kij_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","e bimiaki bisaiki Eroni dalela mabudona tolula. E matauna tolula kasi todabala biyeili yelitala pwarawa deli bulami, deli goli avai maiina simasimina wala oyamala e bigabu okabogwabu lula, bivigaki kabotuvitusila paila lula makwaina kwemwaidona wala bogwa eisakaisi Guyau. E Guyau biyomwasali nanola metoya makwaina kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","E kesalaga makwaina kaula lulela baisa tolula kasi vilavila, kaula makwaina saina bomikikila sainela paila mekauwaisila metoya kaula baisa leivigakaisi lula baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Kidamwa bilulasi beredi leikumlaisi metoya okumkumla, ibodi wala gala deli kala yisi. Beredi makwaisina kwepupoupou leikepupolaisi metoya pwarawa eitagulikaisi deli olibe bulamila kaina pasikeda bikatugiakaisi odabala deli olibe bulamila. ");
INSERT INTO kij_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kidamwa bilulasi beredi leigabwaisi metoya okavaega, bikepupolaisi metoya opwarawa e leitagulikaisi deli olibe bulamila mitaga gala deli kala yisi. ");
INSERT INTO kij_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Bikimimisi makwaina e biligabu bulami odabala tutala bivigaki lula baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kidamwa bilulasi beredi leigabwaisi metoya okavaega, bikepupolaisi metoya pwarawa e bitagulikaisi deli bulamila olibe. ");
INSERT INTO kij_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bimaiyaisi bivigakaisi makwaina si lula baisa Guyau e bisakaisi tolula; e matauna bikau bilau okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","E tolula bikau sitana metoya makwaina bivigaki kaboluluwaila paila lula makwaina kwemwaidona wala bogwa leisakaisi Guyau, e matauna bigabu okabogwabu lula. E Guyau biyomwasali nanola metoya maiinela makwaina kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","E kesalaga makwaina kaula lulela baisa tolula wala kasi vilavila; kaula makwaina saina bomikikila sainela paila mekauwaiasila metoya kaula baisa leivigakaisi lula baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","E komwaidona kaula makwaisina lokuvigakaisi mi lula baisa Guyau kaina kutagulikaisi deli yisi, mitaga gala avai tuta bukutagulikaisi yisi kaina kitorina deli kaula makwaina lokululasi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","E taitu kwaitala kwaitala mi visulapula komwaidona wala bukusakaisi Guyau, mitaga gala bigabwaisi okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kaula makwaisina lokuvigakaisi mi lula bukutagulikaisi deli yona, paila yona ikibuboti Yaubada lakabutu deli yokomi. (E komwaidona mi lula bukutagulikaisi deli yona.) ");
INSERT INTO kij_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Avai tuta bukumiakaisi Guyau mi visulapula paila mi lula, kukwabwasaisi kaula kaina kukikilaisi yuvayavila. ");
INSERT INTO kij_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","E kutagulikaisi olibe bulamila deli kukwatugiakaisi kaisimasimila bulami odabala. ");
INSERT INTO kij_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","E kaula makwaina deli olibe bulamila, deli goli avai kaisimasimila bulami wala tolula bigabu okabogwabu lula, bivigaki kaboluluwaila kaula lulela makwaina bogwa lokusakaisi Guyau. ");
INSERT INTO kij_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kidamwa availa bitugwali natana la bulumakau paila kalubaila lulela, ibodi bimai minana namwala kaina navivila gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Matauna bisaili yamala okununa bulumakau minana oluvi bikatumati minana omatala Guyau la Buliyoyova. E Eroni dalela mayuwona tolula bikauwaisi buyavila bikatusokaisi kwemwaidona kabogwabu lula, ");
INSERT INTO kij_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","e oluvi yayapilela bisakaisi Guyau kala vilavila paila kaula lulela. komwaidona wala posa oyayapila, ");
INSERT INTO kij_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kweta toyo posala deli nawota. ");
INSERT INTO kij_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Tolula matausina bigibugolaisi yayapila makwaisina deli lula kwegubugabu okabogwabu lula. E Guyau biyomwasali nanola metoya maiinela makwaina kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kidamwa natana sipi kaina gota bivigakaisi paila kalubaila lulela bimaiyaisi namwala kaina navivila, minana gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kidamwa taitala tau bitugwali natana la sipi, ");
INSERT INTO kij_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ibodi matauna bisaili yamala okununa e bikatumati minana omatala wala Buliyoyova. E tolula matausina bikauwaisi buyavila bikatusokaisi kwemwaidona kabogwabu lula, ");
INSERT INTO kij_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","e oluvi yayapilela bisakaisi Guyau kala vilavila paila kaula lulela. posala, yeyunala, komwaidona posa wa seila, ");
INSERT INTO kij_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kweta toyo posala deli nawota. ");
INSERT INTO kij_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Oluvi tolula kasi todabala bigabu komwaidona makwaisina baisa Guyau paila kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Kidamwa taitala tau bitugwali natana gota, ");
INSERT INTO kij_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ibodi matauna bisaili yamala okununa minana e oluvi bikatumati omatala Buliyoyova. E tolula matausina bikauwaisi buyavila bikatusokaisi kwemwaidona kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Oluvi yayapilela bisakaisi Guyau kala vilavila paila kaula lulela, komwaidona wala posa oyayapila, ");
INSERT INTO kij_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kwetala toyo posala deli nawota. ");
INSERT INTO kij_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","E tolula bigabu komwaidona makwaisina okabogwabu lula paila kaula lulela e baisa biyomwasali Guyau nanola. E komwaidona posala baisa Guyau kala vilavila. ");
INSERT INTO kij_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","E ambaisa ambaisa mina Isireli eisisuaisi, posa deli buyavi gala gagabila bisuki udosi. Karaiwaga makwaina ibodi biyamataisi e bivigaki kasi gulogula baisa tubwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","biluki mina Isireli kidamwa availa bimitugaga, e bikodidaimi kwaitala Guyau la karaiwaga, gala nanola makawala bivagi mitaga iyopolasi wala ivagi, ibodi matauna bikabikuwoli karaiwaga makwaisina, ka baisa makawala. ");
INSERT INTO kij_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kidamwa Tolula Toveka bimitugaga, e la mitugaga makwaina bikoguliki mina Isireli komwaidona, ibodi matauna bikasali natana la bulumakau natubovau gala isim kala nebaneba, e bilula baisa Guyau paila la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Matauna bimai bulumakau minana omatala Buliyoyova e yamala bisaili okununela minana e makatupona wala matauna bikatumati minana omatala Guyau. ");
INSERT INTO kij_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Oluvi Tolula Toveka bitavikoti sitana buyavila minana bulumakau bilau olumoulela Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Matauna bividagu misikwaikwela obuyavi e bikatusoki omatala miyana taboda yabumaboma biboda sivalima sivayu. ");
INSERT INTO kij_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Oluvi matauna bisaili sitana buyavi okala sukusaku owokulula kabogwabu makwaina kabogwabu lula maiina simasimina olopola Buliyoyova. Matauna biligabu kesala buyavi bila okaikela kabogwabu lula makwaina bigubugabusi mauna lulela makwaina eitotu omatala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","E metoya bulumakau minana wala, matauna bikau komwaidona posala, posa metoya oyayapila, ");
INSERT INTO kij_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kweta toyo posala, deli nawota. ");
INSERT INTO kij_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","E tolula bikau posa komwaidona e bigabu okabogwabu lula, makawala wala leivigaki posala mauna minana leikatumataisi paila kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mitaga matauna bikau kanuvinela, deli vilionela kununela, kaikenala, yayapilela komwaidona deli goli sileula, ");
INSERT INTO kij_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","bivisunupulovi metoya osi kabosikaiwa e bilau makatupona katupobumaboma ambaisa kabolovala lula tubwagela; e metoya baisa tolula matauna bivakati kova bigabu. ");
INSERT INTO kij_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Mitaga kidamwa mina Isireli komwaidosi bimitugagasi, e bivigaki si sula titoulesi bikodidaimisi kwaitala Guyau la karaiwaga e gala ninasi bivagaisi makawala mitaga iyopolasisi wala ivagaisi, ");
INSERT INTO kij_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","e avai tuta mitugaga makwaina biyoumatila, tomota komwaidosi ibodi bimaiyaisi natana nagwadi bulumakau paila mitugaga lulela. Matausina bimaiyaisi minana olopola Guyau la Buliyoyova ");
INSERT INTO kij_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","e komwaidosi tokugwala Isireli ibodi bisailisi yumasi okununela minana, e makatupona wala bikatumataisi minana. ");
INSERT INTO kij_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","E Tolula Toveka bikau sitana buyavi e bilau olumoulela Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","e bividagu misikwaikwela obuyavi e bikatusoki makatupona omatala taboda miyana biboda sivalima sivayu. ");
INSERT INTO kij_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Matauna ibodi bikogiaki sitana buyavila minana okala sukusaku owokulula kabogwabu lula makwaina bigubugabusi lula maiina simasimina olopola Buliyoyova, e kesalaga buyavi biligabu bila okaikela kabogwabu lula makwaina bigubugabusi mauna lulela, makwaina goli eitotu omatala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Oluvi matauna bikau posala komwaidona e bigabu okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Matauna bivigaki makawala wala leivigaki bulumakau minana paila mitugaga lulela, baisa makawala bivigaki lulela paila tomota si mitugaga, e Guyau biligaiwa si mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Oluvi matauna bisunupulovi bulumakau minana bilau oyosewala kabosikaiwa bigabu makawala wala leivigaki bulumakau minana paila la mitugaga titoulela. Lula makwaina leivagi paila Guyau biligaiwa si mitugaga boda komwaidona. ");
INSERT INTO kij_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ka, kidamwa taitala tokaraiwaga bimitugaga e baisa bivigaki la sula paila ikodidaimi kwaitala Guyau la karaiwaga, gala nanola bivagi makawala, mitaga iyopolasi wala ivagi, ");
INSERT INTO kij_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","e avai tuta mitugaga makwaina biyoumatila, matauna ibodi bimai la lula natana namwala gota gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","E matauna bilau opiliyavatela kabogwabu lula, bisaili yamala okununela minana, e bikatumati, mapilana goli si kabokatumata paila mauna minasina leivigakaisi lula kwegubugabu. E lula makwaina paila mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","E tolula matauna bividagu misikwaikwela obuyavila mauna minana e bikogiaki kala sukusaku owokulula makwaina kabogwabu lula; e kesalaga buyavi biligabu bila okaikela kabogwabu lula makwaina. ");
INSERT INTO kij_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Oluvi matauna bigabu komwaidona posala okabogwabu lula, makawala wala leivigaki posasi mauna minasina leikatumataisi paila kalubaila lulela. Baisa makawala tolula bigibuki lula paila tokaraiwaga matauna la mitugaga, e Guyau biligaiwa la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","E kidamwa taitala wala osi boda mina Isireli bimitugaga, e baisa bivigaki la sula paila eikodidaimi kwaitala Guyau la karaiwaga gala nanola bivagi makawala mitaga iyopolasi wala ivagi, ");
INSERT INTO kij_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","e avai tuta mitugaga makwaina biyoumatila, matauna ibodi bimai la lula natana navivila gota gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","E matauna bilau opiliyavatela kabogwabu lula e bisaili yamala okununela minana e bikatumati, mapilana goli si kabokatumata paila mauna minasina leivigakaisi lula kwegubugabu. ");
INSERT INTO kij_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","E tolula matauna bividagu misikwaikwela obuyavila mauna minana e bikogiaki kala sukusaku owokulula kabogwabu lula makwaina, e kesalaga buyavi biligabu bila okaikela kabogwabu lula makwaina. ");
INSERT INTO kij_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","E matauna biyapi komwaidona posala mauna minana makawala goli leivigaki posasi minasina leikatumataisi paila kalubaila lulela, e matauna bigabu okabogwabu lula, e maiinela biyomwasali Guyau nanola. Baisa makawala tolula bigibuki lula paila tau matauna la mitugaga, e Guyau biligaiwa la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kidamwa taitala tau bimai natana la sipi paila lulela mitugaga, ibodi bimai navivila gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","E matauna bilau opiliyavatela kabogwabu lula, bisaili yamala okununela minana e bikatumati, mapilana goli si kabokatumata paila mauna minasina leivigakaisi lula kwegubugabu. ");
INSERT INTO kij_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","E tolula matauna bividagu misikwaikwela obuyavila minana, e bikogiaki kala sukusaku owokulula kabogwabu lula makwaina, e kesalaga buyavi matauna biligabu bila okaikela makwaina kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","E oluvi matauna biyapi posala komwaidona mauna minana makawala goli leivigaki posasi minasina leikatumataisi paila kalubaila lulela, e bigabu odabala kabogwabu lula deli kaula baisa leisakaisi Guyau. Baisa makawala tolula bigibuki lula paila tau matauna la mitugaga, e Guyau biligaiwa la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Mitugaga lulela ibudoki pakula makwaisina. Ka, kidamwa tokaraiwaga bikaikivi taitala bima oyakala paila bikibuboti avai vavagi leigisaki matala deli leiligaki taigala mitaga bikiwoli, ibodi matauna bilumkoli mmayuyu paila la sula titoulela. ");
INSERT INTO kij_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Kidamwa availa biyopolasi wala bikabikoni avai vavagi saina kala kikila sainela, makawala goli mauna nakaliga, e avai tuta biluwai avaka bogwa leivagi, matauna bogwa eiyogwali titoulela deli eisula. ");
INSERT INTO kij_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Kidamwa availa biyopolasi wala bikabikoni avai katupwaila metoya tomota uwosi, e avai tuta biluwai avaka bogwa leivagi, matauna bogwa eiyogwali titoulela deli eisula. ");
INSERT INTO kij_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Kidamwa availa bikebigimakavi kwaitala biga katotila metoya avai vavagi wala bilivali, e avai tuta biluwai avaka bogwa leivagi, matauna bogwa eiyogwali titoulela deli eisula. ");
INSERT INTO kij_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Avai tuta taitala tomota bisula, matauna ibodi bikamituli la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","E paila la mitugaga kaimapula, matauna ibodi bimai navivila sipi kaina gota paila la semakavi baisa Guyau. E tolula bigubuki lula paila tau matauna la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kidamwa taitala tau gala ititoi natana sipi kaina gota, ibodi matauna bimiaki Guyau nayu bubuna kaina nayu buneroro mapula la mitugaga, natana paila lulela mitugaga e nayuwela paila lula kwegubugabu lulela. ");
INSERT INTO kij_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","E matauna bimiaki tolula minasina, e tolula bigububogwi mauna minana paila mitugaga lulela. Matauna bikigudu kaiyola minana mitaga gala bikituni kununela, ");
INSERT INTO kij_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","e matauna bikau sitana buyavila bikatusoki papala kabogwabu lula. E kesalaga buyavi biligabu bila okaikela kabogwabu lula makwaina. Lula makwaina paila mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Oluvi tolula bigabu nayuwela mauna paila lula kwegubugabu lulela makawala avaka kasi karaiwaga. E baisa makawala tolula bigabu lula makwaina paila tau matauna la mitugaga lulela, e Guyau biligaiwa la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Kidamwa taitala tau gala ibodi bimai nayu bubuna kaina nayu buneroro, matauna ibodi bimai pwarawa kala vakaila biboda makawala kapotala paila la mitugaga kala ligaiwa lulela. Matauna gala bitaguliki deli olibe bulamila kaina avai bulami maiina simasimila, paila lula makwaina mitugaga kala ligaiwa lulela, gala goli kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Matauna bimiaki tolula, e tolula biyeili yelitala oyamala bivigaki kabotuvitusila lula makwaina kwemwaidona wala bogwa leisakaisi Guyau, e matauna bigabu okabogwabu lula bivigaki kaula lulela, e lula makwaina paila mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","E baisa makawala tolula bigabu lula makwaina paila tau matauna la mitugaga, e Guyau biligaiwa la mitugaga matauna. E kesalaga pwarawa baisa tolula kala vilavila, makawala wala leivigaki paila kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","E Guyau isaiki Mosese karaiwaga makwaisina baisa makawala. ");
INSERT INTO kij_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Ka, kidamwa availa biyopolasi wala bimitugaga e bikatuduvidavi guguwa makwaisina leikabomaisi paila Guyau, matauna ibodi bimai mapula la mitugaga lulela baisa Guyau natana namwala sipi kaina gota minana gala isim kala nebaneba. Matauna ibodi bimai minana kala vakaila makawala avaka tokwaraiwaga einagaisi. ");
INSERT INTO kij_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Matauna ibodi wala bimapu guguwa makwaisina leikatuduvidavi, e deli bisaila odabala tuvaila katumkulovala. Matauna bisaiki tolula, e tolula bigabu mauna minana bivigaki lulela tau matauna la mitugaga, e Guyau biligaiwa la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","E kidamwa availa biyopolasi wala bimitugaga, e bikodidaimi kwaitala Guyau la karaiwaga, matauna bogwa leisula e ibodi wala bimapu avaka mapula la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Matauna ibodi bimiaki tolula natana namwala sipi kaina gota minana gala isim kala nebaneba paila la mitugaga mapula. Matauna ibodi bimai minana kala vakaila makawala avaka tokaraiwaga einagaisi. E tolula bigabu lula makwaina paila tau matauna la mitugaga, e Guyau biligaiwa la mitugaga matauna. ");
INSERT INTO kij_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Lula makwaina paila mapula mitugaga makwaina tau matauna leiyomituli baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","E Guyau isaiki Mosese karaiwaga makwaisina baisa makawala. ");
INSERT INTO kij_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Ibodi wala bigabwaisi lula kidamwa availa bimitugaga baisa Guyau metoya biyosikikiti wala gala bikaimilivau bisaiki avaka taitala sola wala guma Isireli la guguwa leisaiki biyamati, kaina biveilau mimilisi la guguwa, kaina biwabu matauna ");
INSERT INTO kij_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","kaina bisepuloki matauna mwada vavagi makwaisina bogwa leikitumou e ibigakatotila mwada gala wala ibani. ");
INSERT INTO kij_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Avai tuta taitala tau bimitugaga metoya kwaitala vavagi makwaisina, matauna bimapu mapula la mitugaga metoya avai guguwa leikopatu baisa tomota. Mitaga yam makwaina bibanaisi matauna leivagi sula, ibodi matauna bimmapu wala la guguwa sola biwokuva, e bisaila odabala tuvaila katumkulovala. ");
INSERT INTO kij_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Matauna ibodi bimiaki tolula natana namwala sipi kaina gota, minana gala isim kala nebaneba paila la mitugaga mapula lulela baisa Guyau. Matauna ibodi wala bimai minana kala vakaila makawala tokaraiwaga einagaisi. ");
INSERT INTO kij_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","E tolula bigabu lula makwaina paila tau matauna la mitugaga, e Guyau biligaiwa la mitugaga matauna. ");
INSERT INTO kij_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","biluki Eroni deli goli litula paila karaiwogala lula kwegubugabu. Lula kwegubugabu ibodi wala bisisu okabogwabu lula bogi kwemwaidona, deli kovala bikakata wala biyamki. ");
INSERT INTO kij_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","E tolula matauna, leisisikoma kala kakapula yakakalaia deli la sevalopula, bikau tubwagela kabogwabu lula leisuki posasi mauna bisaim opapala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","E oluvi matauna bikatulova e bikau tubwaga baisa bisunupulovi metoya osi kabosikaiwa e bilau makatupona saina katupobumaboma. ");
INSERT INTO kij_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Mitaga kovala kabogwabu lula gala avai tuta bimata bikakata wala. E kaukwau kwaitala kwaitala tolula biuvigadi wala kaila kabogwabu lula, bisisaila lula kwegubugabu odabala, deli bigigabu posa metoya kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","E kovala kabogwabu lula tuta komwaidona bikakata wala gala avai tuta bimata. ");
INSERT INTO kij_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Karaiwaga makwaisina paila kaula lulela karaiwogala. Ka, taitala Eroni wala dalela bikau lula makwaina bilau omatala kabogwabu lula e bisaiki Guyau. ");
INSERT INTO kij_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Oluvi matauna biyeili yelitala pwarawa leitagulikaisi toyo olibe bulamila, deli bulami maiina simasimina, e bigabu okabogwabu lula bivigaki kabutuvitusila lula makwaina kwemwaidona bogwa leisakaisi Guyau. E metoya maiinela lula makwaina biyomwasali Guyau nanola. ");
INSERT INTO kij_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","17","E tolula ibodi bikomasi kesala kaula makwaina. Matausina bigabwaisi bimila pwarawa gala deli yisi e bilauwaisi ambaisa katupobumaboma bikamsi, makatupona goli Guyau ola Buliyoyova. Baisa bivigaki Guyau bogwa leisaiki tolula mabudona kasi vilavila metoya kaula lulela. Lula makwaina saina kwebumaboma, makawala mitugaga lulela deli goli kaimapu lulela. ");
INSERT INTO kij_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Mapaila tubwa tuta oluvi metoya Eroni dalela tauwau wala ibodi bikamkomasi kaula makwaina leisemakavaisi baisa Guyau. Mitaga availa metoya dala ituwoli bikabikoni kwaitala kalagila kaula lulela matauna bisilagi paila kaula makwaina saina bomikikila sainela. ");
INSERT INTO kij_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","karaiwaga makwaisina paila avai tuta taitala tolula metoya Eroni dalela bibulamaisi. Ka yam makwaina wala bibulamaisi ibodi matauna bimai baisa Guyau sitana pwarawa kala vakaila makawala kapotala (kala vakaila makawala wala kaula lulela bigigabwaisi yam kwaitala kwaitala paila kaimapu lulela). Matauna bigabu sitana paila kaukwau e sitana paila koyavi. ");
INSERT INTO kij_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Matauna bitaguliki deli bulami e bigabu okavaega, oluvi bikimsumsoli bigubuki kaula lulela baisa Guyau, e maiinela lula makwaina biyomwasali Guyau nanola. ");
INSERT INTO kij_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Mapaila tubwa tuta oluvi lula makwaina availa wala metoya Eroni dalela bivagi Tolula Toveka matauna ibodi bivagi lula makwaina. Komwaidona wala matauna bigubuki lula baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","E kaula lulela makwaisina tolula leigigabu gala gagabila sitana bikomasi; komwaidona bigigabu wala bimila pwanosi. ");
INSERT INTO kij_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","biluki Eroni deli litula karaiwaga makwaisina paila karaiwogala mitugaga lulela. E mauna minana bigabwaisi paila mitugaga lulela ibodi bikatumataisi opiliyavatela kabogwabu lula, makatupona goli leivigakaisi si kabokatumata mauna minasina paila lula kwegubugabu. Paila lula makwaina saina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","E mauna minana tolula matauna bigibuki lula ibodi bikoma ambaisa makatupona katupobumaboma omatala Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Kidamwa tomota kaina avai vavagi wala bikabikoni vilionela mauna minana bogwa wala bisilagi paila saina bomikikila sainela. Kidamwa avai karekwa bikogiaki buyavila minana mauna, ibodi wala biwinaisi miyana ambaisa makatupona katupobumaboma. ");
INSERT INTO kij_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","E kulimoya makwelana leisulukwaisi vilionela mauna minana ibodi bikatumkumkwaisi makwelana, mitaga kidamwa bisulusi makwelana tanumnumta, ibodi biwaiyasi tapwala kala pupagatu deli biwasauwaisi lopola. ");
INSERT INTO kij_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Tolula litusia tauwau ibodi wala bikomasi lula makwaina paila lula makwaina saina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Mitaga kidamwa sitana buyavila bilauwaisi olumoulela Buliyoyova bivigakaisi mapula mitugaga kala ligaiwa; mauna minana gala bikomasi, ibodi bigigabwaisi wala bimila pwanosi. ");
INSERT INTO kij_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Karaiwaga makwaisina karaiwogala paila mitugaga mapula lulela makwaisina goli saina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mauna minana paila lula makwaina ibodi bikatumataisi opiliyavatela kabogwabu lula, makatupona goli lula kwegubugabu maunela bikikatumataisi, e buyavila bikatusokaisi komwaidona papala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","E komwaidona posala biyapaisi e bigabwaisi okabogwabu lula, posa oyeyunala, seila posala, ");
INSERT INTO kij_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kweta deli posala, deli naota. ");
INSERT INTO kij_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Tolula matauna ibodi bigabu komwaidona posa okabogwabu lula bivigaki kaula lulela baisa Guyau. Lula makwaina mitugaga mapula lulela. ");
INSERT INTO kij_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","E tolula wala litusia tauwau ibodi bikomasi lula makwaina, mitaga ibodi bikamsi ambaisa katupobumaboma, paila lula makwaina saina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","E olopola karaiwaga makwaisina, kwaitala ibudoki kwaiyu vavagi, mitugaga lulela deli kaimapu lulela karaiwogasi. Ka, tolula matauna bigabu lula makwaina, e avaka baisa leigabu bikau viliona kala vilavila. ");
INSERT INTO kij_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Deli kanuvinela mauna minana bigubuki paila lula kwegubugabu, baisa tolula wala matauna eigabu lula makwaina bikau kanuvinela kala vilavila. ");
INSERT INTO kij_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","E kaula lulela makwaisina bogwa leikumlaisi okumkumla kaina leigabwaisi metoya okavaega baisa tolula wala matauna eigabu lula makwaina baisa Yaubada bikau kala vilavila. ");
INSERT INTO kij_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Mitaga komwaidona kaula lulela makwaisina gala kala vakapula, kaina eitagulikaisi deli bulami kaina kwelubulabu wala, baisa Eroni dalela mabudona tolula kasi vilavila e matausina ibodi bisigilibwailasi oluwalaisi. ");
INSERT INTO kij_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","E karaiwaga makwaisina karaiwogala paila kalubaila lulela biyomitalaisi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ka, kidamwa taitala tau bivagi lula makwaina bivigaki nokagutoki lulela baisa Yaubada, e matauna ibodi wala bivagi makawala, bikatumati natana mauna, deli bikatumkulovi beredi leigibuki lula gala deli yisi, kaina kwepupoupou leigabu metoya pwarawa itaguliki deli olibe bulamila, kainaga pasikeda ikatugiaki odabala deli olibe bulamila, kaina goli pwarawa leiwaki yuvayavila itaguliki deli olibe bulamila. ");
INSERT INTO kij_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","E katumkulovala makwaisina, matauna bilula beredi leigabu gala deli yisi. ");
INSERT INTO kij_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","E beredi makwaisina komwaidona leivigakaisi lula, tolula bikau kwaitala kwaitala metoya magulosina bivigaki Guyau kala katukila; e lula makwaina bivigaki kala vilavila tolula matauna, eikikatusoki kabogwabu lula makwaina metoya mauna buyavisi. ");
INSERT INTO kij_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","E vilionela mauna minana ibodi wala bikomasi biwokuva yam makwaina wala leivigakaisi lula, gala wala sitana bikobogaisi bikanam paila nabwaia. ");
INSERT INTO kij_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Kidamwa taitala tau bimai la lula paila kalubaila lulela bikamokwiti la biga katotila baisa Guyau kaina la lula wala metoya la tagwala titoulela, ibodi bikomasi wa yam makwaina. E kidamwa gala bivinakwaisi, avaka bikobogaisi ibodi wala bikomasi kwaiyuwela yam. ");
INSERT INTO kij_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kidamwa sitana viliona bikanam kwetolula yam, ibodi wala bigabwaisi bimila pwanosi. ");
INSERT INTO kij_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Mitaga kidamwa bikomasi sitana olopola kwetolula yam, Yaubada gala wala bikabwaili tau matauna la lula. E lula makwaina gala wala avaka bivigaki tau matauna kala bwaina, mesinaku wala bogwa bidokaisi makwaina kwaiyogwala, e availa bikoma sitana, matauna bogwa bisilagi. ");
INSERT INTO kij_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kidamwa viliona bikogiaki avai vavagi saina eikikilaisi, gala ibodi bikomasi, mitaga bigabwaisi wala bimila pwanosi. Availa wala matauna bogwa eikikili titoulela, ibodi wala bikoma viliona baisa, ");
INSERT INTO kij_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","mitaga kidamwa availa gala bikikili titoulela bikam wala, matauna bitavileyaisi metoya Yaubada la tomota. ");
INSERT INTO kij_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Deli, kidamwa availa bikabikoni avai vavagi saina ekikilaisi, kaina metoya tomota kaina mauna oluviga bikoma viliona metoya lula makwaina, matauna bitavileyaisi metoya Yaubada la tomota. ");
INSERT INTO kij_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Guyau iluki Mosese karaiwaga makwaisina ");
INSERT INTO kij_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","paila mina Isireli. Ka, posasi bulumakau, sipi, kaina gota gala ibodi bikomasi. ");
INSERT INTO kij_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Kaina avai mauna eikaligimakava kaina mauna nagigasisi eitamati minana gala wala bikomasi posala, mitaga ibodi wala bivigakaisi paila avai vavagi ituwoli. ");
INSERT INTO kij_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Kidamwa availa bikoma posala mauna minana mwada bigubukwaisi kaula lulela baisa Guyau, matauna bitavileyaisi metoya Yaubada la tomota. ");
INSERT INTO kij_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Kaina goli ambaisa mina Isireli eisisipwalasi, matausina gala wala avai tuta bikomasi buyavisi mauna nayoyowa kaina mauna nasigisagina. ");
INSERT INTO kij_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ka, kidamwa availa bikoulovi makwaina Guyau la karaiwaga, matauna bitavileyaisi metoya Yaubada la tomota. ");
INSERT INTO kij_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Guyau iluki Mosese karaiwaga makwaisina ");
INSERT INTO kij_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","paila kasi karaiwaga mina Isireli. Ka, kidamwa availa bikasali paila kalubaila lulela matauna ibodi bimai sitana metoya magulona, e bivigaki Guyau kala katukila, ");
INSERT INTO kij_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","matauna bikabi yamala titoulela bimai bivigaki kaula lulela. Matauna bimai makabilana seila deli posala e bivigaki Guyau kala katukila. ");
INSERT INTO kij_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","E tolula bigabu posala makabilana okabogwabu lula, e kabilamwaidonaga baisa tolula bikau kala vilavila. ");
INSERT INTO kij_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","E kaikena mweyakakata baisa kala katukila ");
INSERT INTO kij_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","tolula matauna leigubugabu buyavila deli posala mauna paila kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Makabilana seila si semakavi kabilidabala deli mamweyana kaikena mweyakakata baisa Guyau kala katukila, matauna bogwa eikau metoya mina Isireli e leisaiki tolula kasi vilavila. Baisa makawala mina Isireli ibodi bisisakaisi tolula tuta gala biwokuva. ");
INSERT INTO kij_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Baisa bivigaki kabotuvitusila kaula lulela magulona bogwa leisakaisi Guyau, magulona goli kasi vilavila Eroni deli litula yam makwaina leibulamaisi matausina paila biwotetilasi tolula wotitalela. ");
INSERT INTO kij_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Yam makwaina Guyau ikaraiwogi mina Isireli bisisakaisi matausina kasi vilavila lula makwaina. E tubwa tuta oluvi mina Isireli ibodi bikabikuwolaisi karaiwaga makwaina. ");
INSERT INTO kij_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","E karaiwaga makwaisina paila karaiwogela lula kwegubugabu, kaula lulela, mitugaga lulela, mitugaga kaimapu lulela, vaputuma lulela, deli kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Makwaisina karaiwaga Guyau eisaiki Mosese oviloupakala wa Koya Sinai, yam makwaina eiluki mina Isireli bimiakaisi si semakavi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Kuvakouli Eroni deli litula kulau omatala ulo Buliyoyova deli kukwau tolula kasi kwama, vaputuma bulamila, natana namwala bulumakau nagwadi minana paila mitugaga lulela, nayu nammwala sipi, deli tala peta beredi gala deli yisi. ");
INSERT INTO kij_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","E oluvi kudou komwaidosi boda mina Isireli e kukougugulasi baisa.” ");
INSERT INTO kij_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mosese ivagi makawala avaka Guyau eikaraiwogi, e avai tuta boda bogwa eigugulasi, ");
INSERT INTO kij_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","matauna iluki matausina kawala, “Ka, avaka makateki bavagi baisa Guyau la karaiwaga makawala.” ");
INSERT INTO kij_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","E Mosese ivakouli Eroni deli litula ilosi omatala e iluki matausina bikayawisasi. ");
INSERT INTO kij_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","E oluvi Mosese ivisikoma Eroni kala kakapula, kala kwama deli isipu kala duriduri okuvalila. E ivisikoma miyana epodi oluvi ipilakavati miyana metoya wopoi miyana saina leikimidagaisi kala viriviri. ");
INSERT INTO kij_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","E ivisikoma kala kuwa mapilana oluvi ipaki odabala makwaisina Urim deli Tummim. ");
INSERT INTO kij_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Matauna ivisikoma kala kulupewa, e omatala makwaina isaili kala katububula eibubulokaisi metoya goula kabotuvatusi saina kwebumaboma paila matauna ikabomaisi baisa Guyau. Baisa makawala avaka Guyau eikaraiwogi matauna. ");
INSERT INTO kij_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Oluvi Mosese ikau vaputuma bulamila e ivaputumi Guyau la Buliyoyova deli goli guguwala komwaidona. Baisa makawala komwaidona wala bogwa leikabomi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Matauna ikau sitana bulami ikatusoki kabogwabu lula deli guguwala iboda sivalima sivayu, tuvaila ikatusoki kailuya makaina deli goli la kabototu makaina; baisa eivigaki ikabomi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Matauna ibulami Eroni metoya vaputuma bulamila iligabu opwanetala. ");
INSERT INTO kij_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Oluvi, Mosese idou Eroni litula imakaiasi matauna e ivisikoma kasi kakapula, isipu kasi duriduri okuvalisi deli ivisikoma kasi kulupewa, makawala avaka Guyau eikaraiwogi bivagi. ");
INSERT INTO kij_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Oluvi Mosese imai bulumakau minana nagwadi paila mitugaga lulela, e Eroni deli litula isailisi yumasi okununela minana. ");
INSERT INTO kij_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mosese ikatumati minana e ikau sitana buyavila, e misikwaikwela wala iuvidagu e ikikogiaki kala sukusaku owokulula kabogwabu lula, baisa makawala bogwa leikabomi makwaina. Oluvi matauna iligabu kesala buyavila mauna minana ila okaikela kabogwabu lula. E baisa makawala matauna bogwa leikabomi deli leikatumigileu makwaina. ");
INSERT INTO kij_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mosese iyapi komwaidona posa oyayapila, nawota, kweta deli posala, e komwaidona wala igabu okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Matauna ikau kabakabalela komwaidona, deli goli kununela, kanuvinela, sileula, e ilau igabu oyosewala si kabosikaiwa, makawala avaka Guyau eikaraiwogi Mosese bivagi. ");
INSERT INTO kij_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Tuvaila Mosese imai natana sipi namwala paila lula kwegubugabu, e Eroni deli litula isailisi yumasi okununela minana. ");
INSERT INTO kij_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Oluvi Mosese ikatumati e ikau buyavila ikatusoki komwaidona papala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","E matauna itakabakabali minana, ikau sopi iwini yayapilela makwaisina deli makweyasina kaikenala e kununela, posala, deli goli namwaidona wala igabu okabogwabu lula, baisa makawala Guyau leikaraiwogi Mosese bivagi. E makwaina lula kwegubugabu baisa paila kaula lulela, e metoya lula makwaina maiinela iyomwasali Guyau nanola. ");
INSERT INTO kij_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","E oluvi Mosese imai nayuwela sipi namwala, minawena bivigakaisi kabotuvitusila paila tolula matausina bibulamaisi, e Eroni deli litula isailisi yumasi okununela minana. ");
INSERT INTO kij_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Oluvi Mosese ikatumati minana ikau sitana buyavila ikogiaki puwala taigala Eroni pilakakata, deli misikwaikwela mweyaveka oyamala kakata, deli mweyaveka kaikela okwaibakwaila kakata. ");
INSERT INTO kij_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Oluvi Mosese idou Eroni litula imaisi omatala, e ikau sitana buyavi ikogiaki puwala taigasi pilakakata, e misikwaikwesi mweyavakaveka oyumasi kakata, deli mweyavakaveka kaikesi okwaibakwaisi kweyakakata. E oluvi Mosese ikau kesala buyavi e ikatusoki kwemwaidona papala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","E matauna iyapi posa komwaidona, posa oyeyunala, yayapila posasi komwaidona, nawota, kweta deli posala, deli goli kaikenala mamweyana mweyakakata. ");
INSERT INTO kij_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Oluvi matauna ikau kwaitala beredi metoya opetala beredi gala deli kala yisi leikabomaisi baisa Guyau, kwaitala leitagulikaisi deli bulami, deli pilatala pasikeda, e matauna isaili makwaisina odabala posala mauna minana deli mamweyana kaikenala. ");
INSERT INTO kij_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Matauna ikau komwaidona kaula baisa isaiki Eroni deli litula, e matausina isakaisi wala Guyau kala katukila. ");
INSERT INTO kij_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Oluvi Mosese ikaimilivau kaula baisa metoya baisa matausina, e igibugoli okabogwabu lula, deli lula kwegubugabu e ivigaki vaputuma lulela. Lula makwaina kaula lulela, e Guyau iyomwasali nanola metoya maiinela lula makwaina. ");
INSERT INTO kij_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Oluvi Mosese ikau makabilana seila e tuvaila wala isaiki Guyau kala katukila. Makabilana goli matauna kala vilavila metoya minana eigubukwaisi vaputuma lulela. E Mosese ivagi komwaidona avaka Guyau eikaraiwogi bivagi. ");
INSERT INTO kij_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Oluvi Mosese ikau sitana vaputuma bulamila deli sitana buyavi eikota okabogwabu lula e ikatusoki Eroni deli litula deli goli kasi kwama, e baisa bivigaki matauna bogwa leikabomi matausina deli goli kasi kwama baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mosese iluki Eroni deli litula kawala, “Kukwauwaisi viliona baisa kulauwaisi omatala Guyau la Buliyoyova, e kusulaisi, kugubukwaisi deli pwarawa makwaisina olumoulela mitana petala vaputuma lulela, baisa makawala Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","E avaka bukukobogaisi kugabwaisi wala bimila pwanosi. ");
INSERT INTO kij_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Deli gala bukusilavaisi makatupona Buliyoyova lulula biboda kwailima kwaiyu yam, tatoula wala avaka kami karaiwaga paila bibulamaimi bivigimkulovaisi. ");
INSERT INTO kij_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Avaka Guyau bogwa eikaraiwogaidasi bitavagaisi bogwa tavagaisi yam lagaila, paila mi mituguga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","E kami yam kami bogi bukusisiaisi wala wa lulu Buliyoyova biboda kwailima kwaiyu yam, e bukuuvagaisi avaka Guyau leikaraiwogaimi. Kidamwa gala bukukwabikaulasi, bukukwaligasi. Baisa makawala avaka Guyau leikaraiwogaigu bavagi.” ");
INSERT INTO kij_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Mapaila Eroni deli litula ivagaisi komwaidona avaka Guyau la karaiwaga eiluki Mosese. ");
INSERT INTO kij_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Yamla bulami bogwa leiwokuva e eiyamga, Mosese idou Eroni deli litula deli goli kaidadala valu. ");
INSERT INTO kij_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Matauna iluki Eroni kawala, “Ka, kuyosi natana namwala bulumakau nagwadi deli natana sipi namwala minasina gala isim kasi nebaneba e bukulula baisa Guyau, minana bulumakau paila mitugaga lulela, e minana sipi namwala paila lula kwegubugabu. ");
INSERT INTO kij_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","E kuluki mina Isireli bimaiyaisi natana gota namwala paila mitugaga lulela, e natana nagwadi bulumakau kala taitu kwaitala deli natana nagwadi lam kala taitu kwaitala e minasina gala isim kasi nebaneba nayu wala paila lula kwegubugabu, ");
INSERT INTO kij_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","e natana namwala bulumakau, deli natana sipi namwala paila kalubaila lulela. Matausina bigubugolaisi minasina deli kaula lulela baisa leitagulikaisi deli bulami e bilulasi baisa Guyau. Matausina ibodi bivagaisi makawala paila uula Guyau biyoumatila baisa matausina yam lagaila.” ");
INSERT INTO kij_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Matausina ikauwaisi komwaidona lula makwaisina ilauwaisi omatala Buliyoyova makawala Mosese eikaraiwogi, e komwaidona wala mina Isireli isigugulasi baisa paila bitapwarorusi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mosese ikaibiga kawala, “Ka, Guyau eikaraiwogaimi bukuvagaisi komwaidona baisa, e gagabila migila guyugwayula biyoumatila baisa yokomi.” ");
INSERT INTO kij_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Oluvi Mosese iluki Eroni kawala, “Kula okabogwabu lula e kugabu mitugaga lulela deli lula kwegubugabu paila m mitugaga deli tomota si mitugaga kala ligaiwa, kuvagi lula makwaina paila tomota si mitugaga kala ligaiwa makawala avaka Guyau la karaiwaga.” ");
INSERT INTO kij_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Oluvi Eroni ila okabogwabu lula e ikatumati minana namwala nagwadi bulumakau, minana goli maunela paila titoulela la mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","E litula imiakaisi buyavila minana e matauna ividagu misikwaikwela obuyavi e ikogiaki kala sukusaku owokulula kabogwabu lula makwaina, e kesalaga buyavi komwaidona wala iligabu ila okaikela kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Oluvi matauna igabu posa okabogwabu lula, kweta deli posala, deli nawota, makawala avaka Guyau eikaraiwogi Mosese bivagi. ");
INSERT INTO kij_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","E komwaidonaga vilionela deli kanuvinela minana igabu oyosewala si kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Oluvi matauna ikatumati natana tuvaila paila la lula kwegubugabu. E litula imiakaisi matauna buyavila minana, e matauna ikau ikatusoki komwaidona papala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Litula isakaisi tumasi kununela deli kabakabalela minana e igabu okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Oluvi matauna iwini komwaidona yayapila kaikenala e isaila odubasi lula kwegubugabu e igubugoli okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Avai tuta matauna bogwa leivenoku wotetila paila titoulela, isetuwoli wala la wotetila paila tomota si lula. Matauna iyosi gota minana paila bigubuki lulela tomota si mitugaga, ikatumati minana e ivigaki lula, makawala wala leivigaki mauna minana paila la mitugaga lulela titoulela. ");
INSERT INTO kij_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Matauna imai natana tuvaila paila lula kwegubugabu e igabu minana makawala wala avaka si karaiwaga. ");
INSERT INTO kij_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Matauna imai lula makwaina kaula lulela e iyeili yelitala pwarawa metoya magulona e igabu okabogwabu lula. (Baisa katumkulovala deli lula kwegubugabu bigigabwaisi yam kwaitala kwaitala.) ");
INSERT INTO kij_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Matauna ikatumati natana bulumakau namwala deli natana sipi namwala paila kalubaila lulela paila tomota deli Yaubada. E litula imiakaisi matauna buyavisi minasina e ikau ikatusoki komwaidona papala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","E Eroni ikau posasi mauna minasina ");
INSERT INTO kij_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","isaila odabala makabilasina seila e ikau komwaidona ilau okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Matauna ikatupali makabilasina seila deli mamweyasina kaikena mweyakakata tuvaila wala Guyau kala katukila, magulona paila wala tolula bikauwaisi kasi vilavila makawala avaka Mosese eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Avai tuta Eroni bogwa leivenoku gibugabu lula, matauna iyosali yamala ilokaia tomota e ikabwaili matausina, oluvi ibusi. ");
INSERT INTO kij_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","E Mosese sola Eroni isuvisi olumoulela Guyau la Buliyoyova, e avai tuta leisunapulasi, matausina ikabwailisi tomota, e Guyau migila guyugwayula leiyoumatila baisa tomota. ");
INSERT INTO kij_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","E saina nanakwa Guyau iwitali kova, ivakammwaisi komwaidona lula kwegubugabu. Avai tuta tomota bogwa leigisaisi makawala, e komwaidosi wala igovasi deli si mwasawa oluvi ikululusi itemmalaisi matauna. ");
INSERT INTO kij_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","E Eroni litula Nadaba sola Abiu, kasitaiyu wala ikauwaisi si kaisakaila kova isailasi pwakova kuwokakata olumoulela, deli goli bulami maiina simasimina e ilulasi baisa Guyau. Mitaga kova makovasina gala kovabumaboma paila Guyau gala eikaraiwogi matausina bilulasi makawala. ");
INSERT INTO kij_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Mapaila Guyau saina nanakwa iwitali kova, e mapoulona wala omatala Guyau igigabu wala matausina ivakamati. ");
INSERT INTO kij_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Oluvi Mosese iluki Eroni kawala, “Guyau magila baisa makawala avai tuta bilivala kawala, ‘Availa availa matausina eiwotitalaigusi ibodi bikamiabaigusi paila yeigu saina Tobumaboma. Yeigu bayomitali ulo guyugwayu baisa ulo tomota.’” Mitaga Eroni gala bigatona ikutukwatu wala isisu. ");
INSERT INTO kij_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","E Mosese idou Misaeli sola Elisapani matausina Usieli litula, matauna taitala Eroni tumala e iluki matausina kawala, “Tauwau, kumaisi kukwauwaisi budamia uwosi kusunupuloiyaisi metoya Guyau ola Buliyoyova Kwebumaboma e kulauwaisi oyosewala kabosikaiwa.” ");
INSERT INTO kij_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Mapaila matausina imaisi iyosasi okarekwa miyasina eikapulikaisi matausina e ikauwaisi isunupuloiyaisi ilauwaisi oyosewala kabosikaiwa, makawala avaka Mosese eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Oluvi Mosese iluki Eroni deli litula Eleasa sola Itama kawala, “Kulumi gala bisisu deli virivirila deli gala bukukodidaimisi kami kwama mwada bukuyomitalaisi mi ninamwau. Kidamwa bukuvagaisi makawala, bukukwaligasi, e Guyau bigibuluwi komwaidona mi tomota. Mitaga komwaidosi semia mina Isireli ibodi bivalamsi paila kaliga makwaina metoya kova makovana Guyau eiwitali. ");
INSERT INTO kij_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Yokomi gala bukusilavaisi lulula Buliyoyova. Kidamwa bukusilavaisi bukukwaligasi, paila yokomi bogwa leikabomaimi metoya makaina vaputuma bulamila paila Guyau.” Mapaila matausina ivagaisi makawala Mosese eikaraiwogi matausina. ");
INSERT INTO kij_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Guyau iluki Eroni kawala, ");
INSERT INTO kij_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Kidamwa bukumomsi waini kaina sopi kaipeula, yokomi deli litumia gala wala bukusuvisi olumoulela ulo Buliyoyova. Kidamwa bukusuvisi, bukukwaligasi. Karaiwaga makwaina paila dalem tubwa tuta oluvi bibokulaisi makawala. ");
INSERT INTO kij_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Yokomi ibodi bukunikolaisi avai guguwa Yaubada la guguwa, e avai guguwa paila tomota, avai vavagi saina migileu avai vavagi pupagatu. ");
INSERT INTO kij_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Ibodi bukuvitulokaisi mina Isireli komwaidona karaiwaga makwaisina lasakaimi metoya baisa Mosese.” ");
INSERT INTO kij_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","E oluvi Mosese iluki Eroni deli litula taiyu matausina tommomova, Eleasa sola Itama kawala, “Kukwauwaisi kaula baisa kesala eikanam metoya kaula lulela lokuvigakaisi lula baisa Guyau, e kugibukwaisi beredi gala deli kala yisi, e kukomasi opapala kabogwabu lula, paila lula makwaina saina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mapaila ibodi bukukomasi ambaisa katupobumaboma, paila baisa kami vilavila deli litumia tauwau metoya kaula baisa lokuvigakaisi lula baisa Guyau. Baisa makawala avaka Guyau eikaraiwogaigu balukwaimi. ");
INSERT INTO kij_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","E yokomi deli litumia omi kaukweda ibodi bukukomasi seila makabilana deli mamweyana kaikena baisa lokuvigakaisi mi lula e lokusakaisi wala tuvaila Guyau kala katukila, baisa yokomi tolula kami vilavila. Yokomi ibodi bukukomasi seila makabilana deli mamweyana kaikena ammakatupona wala makatuposina katupobumaboma. Lula makwaina semia mina Isireli leisakaimi deli litumia baisa kami vilavila metoya magulona kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Tuta matutona posa bivigakaisi kaula lulela baisa Guyau. Matausina ibodi bimmaiyaisi kaikena mamweyana deli seila makabilana. Makabilasina baisa mi vavagi wala deli litumia tuta gala biwokuva, makawala avaka Guyau eikaraiwogi.” ");
INSERT INTO kij_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Oluvi Mosese ikatupoi paila gota minana paila mitugaga lulela, e ilukwaisi matauna bogwa leigabwaisi. E baisa ivigaki saina igibuluwi Eleasa sola Itama, mapaila iluki matausina kawala, ");
INSERT INTO kij_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Avaka paila gala kukomasi mitugaga lulela olumoulela makatupona katupobumaboma? Paila lula makwaina saina kwebumaboma, e Guyau leisakaimi paila bivigaki tomota si mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Paila gala kumaiyaisi buyavila minana olumoulela Guyau la Buliyoyova kwebumaboma, mitaga yokomi ibodi wala bukukomasi lula makwaina olumoulela makatupona katupobumaboma makawala avaka Guyau leikaraiwogaimi.” ");
INSERT INTO kij_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","E Eroni ivitakauloki kawala, “Ammakawalaga kidamwa bakoma mitugaga lulela lagaila? Ki kudoki baisa sitana biyomwasali Guyau nanola? Ka, tomota isakaisi Guyau paila si mitugaga lulela lagaila, deli imaiyaisi si lula kwegubugabu, mitaga kabommayuyu makwaisina lalumkoli wala.” ");
INSERT INTO kij_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Avai tuta Mosese ilagi baisa, bogwa eibudoki nanola. ");
INSERT INTO kij_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","E Guyau iluki Mosese sola Eroni karaiwaga makwaisina ");
INSERT INTO kij_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","paila kasi karaiwaga mina Isireli. Ka, yokomi ibodi bukukomasi avai mauna wala nasigisagina ");
INSERT INTO kij_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","minasina kwebakwaisi kweyalilalai deli kʹasi bikasuyumalaisi e bikamvauwaisi. ");
INSERT INTO kij_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Mitaga gala bukukomasi kameli, ugiwagi, kaina kwakwau. Paila minasina napupagatu; minasina kʹasi ikasuyumalaisi ikamvauwaisi, mitaga kwebakwaisi gala kweyalilalai. ");
INSERT INTO kij_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Deli gala bukukomasi bunukwa. Paila minasina napupagatu; minasina kweyalilalai kwaibakwaisi, mitaga gala ikasuyumalaisi kʹasi e ikamvauwaisi. ");
INSERT INTO kij_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Gala bukukomasi minasina mauna kaina bukukwabikonaisi uwosi tutala bogwa eikaligasi; paila minasina napupagatu. ");
INSERT INTO kij_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Yokomi ibodi bukukomasi avai yena wala isim siyola deli isim silisilila, ");
INSERT INTO kij_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","mitaga avai mauna olumoulela bolita gala isim siyola kaina gala silisilila gala bukukomasi, ");
INSERT INTO kij_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","bubuli makawala minasina napupagatu. Gala bukukomasi minasina kaina bukukwabikonaisi avai tuta bogwa leikaligasi. ");
INSERT INTO kij_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Yokomi gala wala ibodi bukukomasi avai vavagi obolita gala isim siyola kaina gala silisilila. ");
INSERT INTO kij_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","Yokomi gala ibodi bukukomasi mauna minasina yagasi makawala, mluveka, kuru, kilakila, kaleya, bulibwali, kwailou, kawokawo, kasuwari, maikela, boituva, boi, binama, monilouluwa, sawila deli magiyaweda. ");
INSERT INTO kij_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Komwaidona minumauna isim pinupanesi napupagatu, ");
INSERT INTO kij_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","mesinaku wala minasina napeipela. ");
INSERT INTO kij_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ibodi bukukomasi nipawa, vegu, sigweilela. ");
INSERT INTO kij_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Mitaga komwaidona minasina isim pinupanesi mitaga nasigisagina, minasina napupagatu. ");
INSERT INTO kij_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","28","Kidamwa availa bikabikoni uwosi minasina mauna nakakaliga, matauna bogwa eiyogwali titoulela bisisu wala topupagatu kaukwau bila ibugiki. Komwaidona minasina isim kwaibakwaisi. Kidamwa kwaibakwaisi kweyalilalai deli kʹasi ikasuyumalaisi oluvi ikomvauwaisi, deli komwaidona minasina kukweyavasi kaikesi e isim misikwaikwesi. E availa bikau mauna minasina bogwa leikaligasi, matauna ibodi biwini kala kwama miyasina eisisikoma, mitaga matauna bogwa wala eiyogwali titoulela e bisisu wala topupagatu kaukwau bila bibugiki. ");
INSERT INTO kij_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","Kwakwau, kikoni navakaveka deli nakikekita, ketata, kainavasia, minasina napupagatu. ");
INSERT INTO kij_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Kidamwa availa bikabikoni minasina igau nammomova kaina bogwa eikaligasi, matauna bogwa eiyogwali titoulela, e bisisu wala topupagatu kaukwau bila bibugiki. ");
INSERT INTO kij_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Deli kidamwa bogwa eikaligasi e uwosi bikanakaila avai vavagi, vavagi makwaina bogwa eiyopigigatu. Vavagi makwaisina makawala, kai, karekwa, guguwa eiyodulokaisi metoya mauna kanuvinesi, kaina avai karekwa wala, avai paisewa wala ibudoki paila guguwa makwaisina bivigakaisi. E vavagi makwaina ibodi wala bitavidagwaisi wa sopi bigigadi, mitaga bisisu wala kwepupagatu bila bibugiki. ");
INSERT INTO kij_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Deli kidamwa uwosi bikapusisi bila olumoulela kwelatala kulimoya, avai vavagi olumoulela makwelana bogwa eiyopigigatu, e kulia makwelana ibodi wala bikatumimisaisi. ");
INSERT INTO kij_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","E avai kaula ibudoki paila kamkwam mitaga kidamwa sopi metoya kulia makwelana bukuligabwaisi kaula makwaina, bogwa lokuyogwalaisi kaula, deli avai sopi kami sopi olumoulela kulia makwelana, baisa bogwa wala lokuyogwalaisi. ");
INSERT INTO kij_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Avai vavagi wala mauna minasina uwosi bikabikonaisi bogwa eiyopigigatu kailagila kaina kumkumla, e ibodi bukukwatumimisaisi kailagila makwaisina deli bukukwalidubolaisi kumkumla makumlona. ");
INSERT INTO kij_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ilagoli vavagi komwaidona bikabikoni uwosi mauna minasina nakakaliga bogwa eiyopigigatu, mitaga utuwotu kaina avai vavagi ketaikotela sopi migileu wala bisisu. ");
INSERT INTO kij_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kidamwa avai mauna nakaliga e wowola bikogiaki yagogu makwaina bisapwaisi, e yagogu makwaina kwemigileu wala. ");
INSERT INTO kij_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mitaga kidamwa yagogu makwaina wa sopi bigigadi e natana minasina bogwa eikaliga wowola bikapusi bikogiaki yagogu makwaina bogwa wala eiyopigigatu. ");
INSERT INTO kij_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Kidamwa availa bikabikoni avai mauna minana ibudoki kamkwam bogwa eikaliga, matauna bogwa eiyogwali titoulela, e bisisu wala topupagatu kaukwau bila bibugiki. ");
INSERT INTO kij_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","E availa bikoma avai kakasili wala metoya mauna minana, matauna ibodi biwini kala kwama, mitaga bisisu wala topupagatu kaukwau bila bibugiki. E availa bikau uwosi minasina nakakaliga ibodi biwini kala kwama, mitaga bisisu wala topupagatu kaukwau bila bibugiki. ");
INSERT INTO kij_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Yokomi gala ibodi bukukomasi natana mauna minasina nakikekita maunela pwaipwaia, ");
INSERT INTO kij_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","kaina minasina nasigisagina, kaina minasina naliloula, kaina minasina nateteta. ");
INSERT INTO kij_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Gala bukuyogwalaisi titoulemi metoya bukukomasi minasina mauna. ");
INSERT INTO kij_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Yeigu Guyau mi Yaubada, ibodi bukukwabomaimi titoulemi, paila yeigu Tobumaboma. ");
INSERT INTO kij_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Yeigu wala Guyau mayeigu goli lavisunupuloiyaimi mapilana Itipita, e yeigu wala mi Yaubada. Mapaila ibodi bukukwabomaimi, paila yeigu Tobumaboma. ");
INSERT INTO kij_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ka, baisa kasi karaiwaga mauna komwaidona naliloula deli nayoyowa deli goli komwaidona maunela bolita, e komwaidona maunela pwaipwaia. ");
INSERT INTO kij_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Yokomi ibodi bukumitakavataisi bibwaina metoya avaka migileu deli avaka pupagatu, deli metoya avai mauna minasina ibudoki kamkwam e avai mauna minasina gala ibudoki kamkwam. ");
INSERT INTO kij_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","E Guyau iluki Mosese sola Eroni karaiwaga makwaisina ");
INSERT INTO kij_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","paila kasi karaiwaga mina Isireli. Ka, kidamwa natana vivila bitapoi yamala, e latula tau, kwailima kwaiyu yam minana bisisu wala napupagatu makawala wala igau kala tubukona buyavila eitalagila. ");
INSERT INTO kij_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","E kwailima kwaitolula yam gwadi magudina biboda kala bobu. ");
INSERT INTO kij_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Oluvi kweluwotolu kwaitolu yam tuvaila minana bogwa wala bimigileu metoya buyavila eititalagila, minana gala wala ibodi bikabikoni avai vavagi kwebumaboma kaina bisuvi Guyau ola Buliyoyova kwebumaboma, tatoula wala bivigimkulovaisi kala katumigileu. ");
INSERT INTO kij_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","E kidamwa natana vivila bitapoi yamala e latula vivila, kweluwotala kwaivasi yam minana bisisu wala napupagatu, makawala wala igau kala tubukona buyavila eititalagila. Oluvi kweluwolima kweluwotala kwailima kwaitala (66) yam tuvaila, minana bogwa bimigileu metoya buyavila eititalagila. ");
INSERT INTO kij_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Avai tuta minana yamla kala katumigileu bogwa biwokuva, kaina paila latula tau, kaina vivila, minana ibodi bimiaki tolula natana lam kala taitu kwaitala paila lula kwegubugabu deli natana bubuna kaina buneroro paila mitugaga lulela, omatala Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","E tolula bikau vivila minana la semakavi bisaiki Guyau, oluvi bivagi kabotuvitusila avaka kasi gulogula paila kala katumigileu vivila minana, e minana bogwa bimigileu. Baisa makawala vivila ibodi bivagaisi avai tuta bogwa eitapoi yumasi. ");
INSERT INTO kij_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kidamwa vivila minana gala iyosi natana lam, minana ibodi bimai nayu bubuna kaina nayu buneroro, natana paila lula kwegubugabu, e nayuwela paila mitugaga lulela, e tolula bivagi kabotuvitusila avaka kasi gulogula paila kala katumigileu vivila minana, e minana bogwa wala bimigileu. ");
INSERT INTO kij_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","E Guyau iluki Mosese sola Eroni karaiwaga makwaisina. ");
INSERT INTO kij_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Ka, kidamwa availa kwaitala kala pwasa kaina kala pukuna kaina sapila wala okanuvinela, makwaina igau bivigaki kala kagwaiguya, ibodi matauna bimiakaisi baisa taitala matausina tolula Eroni dalela. ");
INSERT INTO kij_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","E tolula ibodi bimitakavati pwasa makwaina, e kidamwa unuunula wowola olumoulela pwasa bipupwakausi deli pwasa makwaina bikombonu sitana, makwaina kagwaiguya, e tolula matauna bikamituli tomota matauna topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mitaga kidamwa pwasa makwaina kwepupwakau wala e gala bikombonu bila olumoulela deli unuunula wowola gala iyapupwakausi, e tolula ibodi bikatupali tau matauna bim ituwoli la kabosisu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Tolula ibodi bimitakavati matauna tuvaila avai tuta bibudoki kwailima kwaiyuwela yam, e kidamwa idoki pwasa makwaina makala gigisa wala gala ikikabaiveka, tolula matauna bikatumkulovi kala yam tau matauna biboda kwailima kwaiyu yam tuvaila. ");
INSERT INTO kij_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Tolula matauna bimitakavati matauna tuvaila oyamla bibudoki kwailima kwaiyuwela, e kidamwa pwasa makwaina gala ikabaiveka bogwa leibwaina, e tolula bikamituli matauna tomigileu paila pwasa makwaina pwasamakava wala. E tomota matauna ibodi biwini kala kwama komwaidona e matauna bogwa wala bimigileu. ");
INSERT INTO kij_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mitaga kidamwa tolula bogwa eimitakavati kala pwasa deli eikamituli matauna tomigileu oluviga pwasa makwaina bikabaiveka, tau matauna ibodi bikaimilavau baisa tolula. ");
INSERT INTO kij_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","E tolula bimitakavati matauna tuvaila, e kidamwa pwasa makwaina bogwa eikabaiveka tolula ibodi bikamituli tau matauna topupagatu, e makwaina kala kagwaiguya. ");
INSERT INTO kij_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Kidamwa availa biyosi kagwaiguya matauna ibodi bimiakaisi tolula ");
INSERT INTO kij_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","e tolula ibodi bimitakavati matauna. Kidamwa kala pwasa okanuvinela kwepupwakau e unuunula wowola bipupwakau wala deli ivakasau polala, ");
INSERT INTO kij_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","e kagwaiguya makwaina kwemyuvau. E tolula ibodi bikamituli tau matauna topupagatu; e gala ibodi bikatupali matauna bim ituwoli la kabosisu paila bogwa eivitoki tolosila matauna topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ka, kidamwaga kagwaiguya makwaina biyouloveka bikomkuwosi wowola tomwaidona opwanetala bila okwaibakwaila ");
INSERT INTO kij_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","e tolula ibodi bimitakavati matauna tuvaila, kidamwa bibani mokwitatoula wala bogwa eikomkuwosi tomwaidona, e tolula bikamituli tau matauna bogwa eimigileu. E kidamwaga komwaidona wowola bogwa eipupwakau, matauna mokwita wala bogwa eimigileu. ");
INSERT INTO kij_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mitaga avai tuta wala pwasa biyoulapula owowola e tau matauna topupagatu wala. ");
INSERT INTO kij_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Oluvi tolula ibodi bimitakavati matauna tuvaila, e kidamwa bigisi bogwa wala mokwita kala pwasa, e tolula ibodi bikamituli tau matauna topupagatu. E pwasa makwaina eiyomitali kagwaiguya, e tau matauna topupagatu wala. ");
INSERT INTO kij_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mitaga avai tuta pwasa makwaina eibwaina bivapupwakau tuvaila, e tau matauna ibodi bikaimilavau baisa tolula, ");
INSERT INTO kij_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","e tolula ibodi bimitakavati matauna tuvaila. Kidamwa pwasa makwaina bogwa eipupwakau, matauna bogwa eimigileu e tolula bikamituli matauna bogwa eimigileu. ");
INSERT INTO kij_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kidamwa availa kwaitala kala pukuna makwaina bogwa leibwaina ");
INSERT INTO kij_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mitaga kidamwa bimyuvau bisapila kaina bisukwanekwana onebala pukuna makwaina, e matauna ibodi bilokaia tolula. ");
INSERT INTO kij_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","E tolula ibodi bimitakavati matauna, kidamwa bigisi pwasa makwaina bikombonu bila sitana olumoulela deli unuunula wowola olumoulela pwasa bipupwakau, e tolula ibodi bikamituli tau matauna topupagatu. Paila kagwaiguya makwaina eivitouula metoya wa pukuna makwaina. ");
INSERT INTO kij_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mitaga kidamwa tolula bimitakavati e bibani unuunula wowola olumoulela pwasa makwaina gala idavila bipupwakau deli gala ikombonu bila sitana olumoulela, mitaga bogwa leibwabwaina, e tolula ibodi bikatupali matauna bim ituwoli la kabosisu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kidamwa pwasa makwaina bikabaiveka e tolula ibodi bikamituli tau matauna topupagatu; matauna bogwa eikatoula. ");
INSERT INTO kij_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mitaga kidamwa pwasa makwaina makala gigisa wala gala ikikabaiveka baisa pukuna makwaina nebala, e tolula ibodi bikamituli tau matauna bogwa eimigileu. ");
INSERT INTO kij_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","E kidamwa taitala tau bigabu kova, e bivakabinini kanuvinela bipupwakau kaina bikulubweyani, ");
INSERT INTO kij_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","tolula ibodi bimitakavati tau matauna. E kidamwa unuunula wowola olumoulela pwasa makwaina bipupwakau deli bikombonu sitana bila olumoulela, makwaina kagwaiguya leivitouula metoya kova leigabu matauna, e tolula ibodi bikamituli tau matauna topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mitaga kidamwa unuunula wowola olumoulela pwasa makwaina gala ipupwakau gala ikombonu ila olumoulela sitana bogwa leibwabwaina tolula ibodi bikatupali matauna bim ituwoli la kabosisu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Avai tuta bibudoki kwailima kwaiyuwela yam tolula ibodi bimitakavati tau matauna tuvaila, mitaga kidamwa pwasa makwaina ikikabaiveka makwaina kagwaiguya, e tolula ibodi bikamituli tau matauna topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mitaga kidamwa pwasa makwaina makala gigisa wala gala ikikabaiveka deli bogwa eibwabwaina makwaina gala kagwaiguya. E tolula ibodi bikamituli tau matauna bogwa eimigileu paila baisa kala neba wala metoya kova leigabu. ");
INSERT INTO kij_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Kidamwa taitala tau kaina natana vivila kala pwasa opwanetala kaina okimwala, ");
INSERT INTO kij_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","tolula ibodi bimitakavati pwasa makwaina. Kidamwa bikombonu sitana bila olumoulela e unuunula wowola wa pwasa eivapupwakau deli yasisikwa bogwa eikamituli makwaina kagwaiguya, e tolula bikamituli tau matauna topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Mitaga kidamwa tolula bimitakavati matauna, e pwasa makwaina gala bikombonu, deli unuunula wowola wa pwasa gala isusinasi, tolula ibodi bikatupali tau matauna bim ituwoli la kabosisu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","E avai tuta kwailima kwaiyuwela yam bibudoki, tolula ibodi bimitakavati pwasa makwaina tuvaila. Kidamwa pwasa makwaina gala bikabaiveka e unuunula wowola wa pwasa gala ivapupwakau deli gala bikombonu bila sitana olumoulela, ");
INSERT INTO kij_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","tau matauna ibodi biviliu papala pwasa makwaina opwanetala bitavina wala bitapatu. E tolula ibodi bikatupali tau matauna bim ituwoli la kabosisu biboda kwailima kwaiyu yam tuvaila. ");
INSERT INTO kij_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","E avai tuta kwailima kwaiyuwela yam bibudoki, tolula ibodi bimitakavati pwasa makwaina tuvaila, e kidamwa gala ikabaiveka deli ikombonu bila sitana olumoulela tolula ibodi bikamituli tau matauna tomigileu. E tau matauna ibodi biwini kala karekwa komwaidona e matauna bogwa bimigileu. ");
INSERT INTO kij_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mitaga kidamwa tolula bogwa eikamituli matauna tomigileu, e oluviga pwasa makwaina bimyuvau bikabaiveka, ");
INSERT INTO kij_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","tolula ibodi bimitakavati matauna tuvaila. E kidamwa pwasa makwaina mokwita bogwa eikabaiveka tolula gala bikaiki wowola paila bimitakavati tau matauna unuunula wowola miyasina bogwa eivapupwakau, paila bogwa eikamituli matauna topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mitaga kidamwa tolula la nanamsa idoki pwasa makwaina gala ikabaiveka deli unuunula wowola eisususinasi deli pwasa makwaina bogwa leibwaina, e tolula ibodi bikamituli tau matauna bogwa eimigileu. ");
INSERT INTO kij_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Kidamwa taitala tau kaina natana vivila vana bikikapwalasi owowola, ");
INSERT INTO kij_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","e tolula ibodi bimitakavati matauna kaina minana. E kidamwa vana makwaisina kwetubumyou, e makwaisina kala kaisegita wala eikikapwalasi owowola, mapaila matauna kaina minana wowola migileu wala. ");
INSERT INTO kij_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","41","Kidamwa taitala tau kulula bitatotinasi okaigadula kaina omatala, baisa gala bivigaki matauna topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mitaga kidamwa bikompwala kwaitala pwasa okala bakana, makwaina kagwaiguya. ");
INSERT INTO kij_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","E tolula ibodi bimitakavati matauna, e kidamwa bigisi kwaitala pwasa, ");
INSERT INTO kij_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","tolula ibodi bikamituli tau matauna topupagatu, paila makwaina pwasa kagwaiguya opwanetala. ");
INSERT INTO kij_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Availa biyosi kagwaiguya ibodi bisisikam yapupagatu karekwa, gala bisinati kulula, bikapoli migila makabulona watanawa, e bikawota kawala, “Pupagatu, pupagatu!” ");
INSERT INTO kij_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","E makala kala kaduwonaku lelia makwaina bigugweimili, matauna bisisu wala topupagatu, mapaila matauna ibodi bisim oyosewala kabosikaiwa, e bisikaduwonaku wala metoya tomota komwaidona. ");
INSERT INTO kij_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Kidamwa kulisosou bikana okarekwa miyasina, eiyoudulaisi metoya sipi unuunula kaina miyasina yakakalaia, ");
INSERT INTO kij_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kaina msomsela miyasina karekwa, kaina okanuvinesi mauna, kaina avai vavagi wala eiyoudulaisi metoya mauna kanuvinesi, ");
INSERT INTO kij_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","kidamwa kulisosou makwaina kala gigisa semitamata kaina bweyani, kulisosou makwaina kwekikapela mapaila ibodi wala guguwa makwaina bivitulokaisi tolula. ");
INSERT INTO kij_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","E tolula ibodi bimitakavati makwaina e bikatupali bim wala kabala ituwoli biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Avai tuta bibudoki yam kwailima kwaiyuwela, matauna ibodi bimitakavati tuvaila, e kidamwa kulisosou makwaina bikabaiveka, guguwa makwaina kwepupagatu. ");
INSERT INTO kij_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","E tolula ibodi bigabu guguwa makwaina, paila kulisosou makwaina kwekikapela, mapaila ibodi wala guguwa makwaina bigabu. ");
INSERT INTO kij_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mitaga kidamwa avai tuta tolula bimitakavati e ibani kulisosou gala wala ikabaiveka oguguwa makwaina, ");
INSERT INTO kij_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","e tolula matauna bikaraiwogi biwinaisi e bikatupalaisi bim wala kabala ituwoli ikanam biboda kwailima kwaiyu yam tuvaila. ");
INSERT INTO kij_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Avai tuta kwailima kwaiyuwela yam bibudoki matauna ibodi bimitakavati makwaina kidamwa kulisosou baisa gala bididavila kala gigisa, deli gala ikikabaiveka makwaina kwepupagatu wala; kidamwa kulisosou bikapilaki olopola kaina otapwala guguwa makwaina, ibodi wala bukugabwaisi. ");
INSERT INTO kij_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mitaga kidamwa avai tuta tolula bimitakavati tuvaila, e kulisosou bogwa leiwokuva, matauna ibodi bikisi makatupona metoya okarekwa kaina kanuvinesi mauna leiyoudulokaisi avai vavagi. ");
INSERT INTO kij_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Oluvi kidamwa kulisosou bivigavau tuvaila, e eikikabaiveka tuvaila, e toliguguwa ibodi bigabu guguwa makwaina. ");
INSERT INTO kij_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mitaga kidamwa matauna biwini guguwa makwaina deli kulisosou biwokuva, matauna ibodi wala biwinavau tuvaila, e bogwa wala bimigileu mokwita. ");
INSERT INTO kij_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ka, baisa makawala karaiwogala kulisosou avai tuta bikana okarekwa, miyasina yakakalaia kaina miyasina eibisikaisi metoya sipi unuunusi kaina miyasina yabisibasi kaina yaviriviri kaina goli avai vavagi wala leiyoudulokaisi metoya mauna kanuvinesi. Baisa makawala karaiwogala guguwa makwaisina kaina kwemigileu kaina kwepupagatu. ");
INSERT INTO kij_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","karaiwaga makwaisina avaka bibudoki kasi gulogula paila katumigileu baisa taitala tomota bogwa leibwaina metoya okala kagwaiguya. Wa yam makwaina matauna bikamitulaisi bogwa eimigileu, e matauna ibodi bimiakaisi tolula; ");
INSERT INTO kij_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","e tolula ibodi bisunupuloi matauna e bilau oyosewala kabosikaiwa e baisa bimitakavati matauna kidamwa bibani katoula makwaina bogwa leibwaina, ");
INSERT INTO kij_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","e tolula ibodi bikaraiwogi nayu mauna nammigileu, pilatala kai kweisila, yatala woyai yabweyani, deli sisitala silumwaiya deli wala bimaiyaisi. ");
INSERT INTO kij_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Oluvi tolula ibodi bikaraiwogi natana mauna minasina bikatumataisi odabala kailuya makaina leitavikotaisi sopi utuwotu. ");
INSERT INTO kij_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","E tolula ibodi biyosi nayuwela mauna minana, deli mapilana kai kweisila, miyana woyai yabweyani, deli masisina silumwaiya, e bividagu obuyavila mauna minana bogwa leikatumatibogwisi. ");
INSERT INTO kij_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","E tolula bikau buyavi baisa e bikatusoki tau matauna sivalima sivayu e bivigaki tau matauna kala katumigileu metoya owowola kala katoula, e oluvi tolula ibodi bikamituli tau matauna bogwa eimigileu. E tolula ibodi bikiyou mauna namomova bila iyoyowa omalaga. ");
INSERT INTO kij_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","E tau matauna ibodi biwini kala karekwa, biviliu kulula komwaidona, deli bikakaya, e oluvi matauna bimigileu. E matauna ibodi bikaimilavau okabosikaiwa; mitaga gala bisuvi ola bwala bikanukwenu wala omalaga biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","E avai tuta bibudoki kwailima kwaiyuwela yam, matauna ibodi biviliuvau kulula, kala gabula, kala pola, deli goli komwaidona unuunula wowola; e matauna ibodi biwini kala karekwa komwaidona, deli bikakaya, e matauna bogwa bimigileu mokwita. ");
INSERT INTO kij_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","E yam kwailima kwaitolula bibudoki matauna ibodi bimai nayu nammwala lam deli natana navivila, kasi taitu kwaitala wala, minasina gala isim kasi nebaneba, deli bimai pwarawa kala vakaila makawala kapotolu leikepupolaisi deli olibe bulamila, deli tuvaila bimai kwelatala viga olibe bulamila. ");
INSERT INTO kij_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","E tolula bikau semakavi makwaisina deli bivakouli tau matauna bilau omatala Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","E tolula bikau natana lam minasina nammwala deli kwelatala viga olibe bulamila bigubuki paila mitugaga mapula lulela e matauna bisemakavi baisa Guyau kala katukila paila tolula. ");
INSERT INTO kij_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Matauna bikatumati minana lam olumoulela makatupona katupobumaboma ambaisa maunela mitugaga lulela deli lula kwegubugabu leikikatumataisi. Matauna ibodi bivagi makawala, paila kaimapu lulela makawala wala mitugaga lulela, paila baisa tolula wala kala vilavila deli saina bomikikila sainela. ");
INSERT INTO kij_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Tolula bikau sitana buyavila lam e bikogiaki tau matauna puwala taigala pilakakata, deli misikwaikwela mweyaveka oyamala mweyakakata; deli mweyaveka kaikela okwaibakwaila mweyakakata, matauna goli mwada bikamitulaisi bogwa eimigileu. ");
INSERT INTO kij_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Tolula bikau sitana olibe bulamila e biligabu bila okwailopola yamala mweyakikiwama, ");
INSERT INTO kij_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","e mweyatala misikwaikwela ola kakata, bividagu bikatusoki matabudona Guyau la Buliyoyova biboda sivalima sivayu. ");
INSERT INTO kij_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Oluvi bikau sitana bulami baisa okwailopola yamala deli sitana buyavila lam e bikogiaki tau matauna puwala taigala pilakakata deli mweyaveka misikwaikwela yamala mweyakakata, deli mweyaveka kaikela okwaibakwaila kweyakakata matauna goli leikamitulaisi bogwa leimigileu. ");
INSERT INTO kij_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","E kesalaga buyavi okwailopola yamala biligabu bila okulula tau matauna. Baisa bivigaki kabotuvitusila avaka kasi gulogula paila tau matauna kala katumigileu. ");
INSERT INTO kij_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Mapaila tolula ibodi bigabu mitugaga lulela e bivagi kabutuvitusila avaka kasi gulogula paila katumigileu. Oluvi matauna bikatumati mauna minana paila lula kwegubugabu ");
INSERT INTO kij_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","e bigibugoli deli kaula lulela okabogwabu lula, baisa makawala tolula ibodi bivagi avaka kasi gulogula paila katumigileu, e tau matauna bogwa wala bimigileu mokwita. ");
INSERT INTO kij_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Kidamwa tau matauna tonamakava gala ibodi bimai avai vavagi tuvaila, matauna ibodi bimai paila kala katumigileu natana namwala lam paila la mitugaga mapula lulela, e lula makwaina bivigaki Guyau kala katukila paila tolula. Matauna ibodi bimai pwarawa kala vakaila makawala kapotala leitagulikaisi deli kwelatala viga olibe bulamila paila kaula lulela deli kwelatala olibe bulamila. ");
INSERT INTO kij_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Matauna ibodi bimai nayu bubuna kaina nayu buneroro, natana paila mitugaga lulela, e nayuwela paila lula kwegubugabu. ");
INSERT INTO kij_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","E yam kwailima kwaitolula yamla kala katumigileu bibudoki, matauna ibodi bimiaki tolula vavagi makwaisina omatala Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","E tolula bikau minana lam deli olibe bulamila e bivigaki Guyau kala katukila paila tolula. ");
INSERT INTO kij_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Matauna ibodi bikatumati lam minana e bikau sitana buyavila bikogiaki tau matauna puwala taigala pilakakata, deli misikwaikwela mweyaveka oyamala kweyakakata, deli misikwaikwela mweyaveka okwaibakwaila kakata. ");
INSERT INTO kij_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","E tolula biligabu sitana buyavi bila okwailopola yamala kweyakikiwama, ");
INSERT INTO kij_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","e mweyatala misikwaikwela ola kakata bividagu e bikatusoki makatupona omatala Guyau la Buliyoyova biboda sivalima sivayu. ");
INSERT INTO kij_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Matauna ibodi bikau sitana bulami e bikogiaki wala tuvaila tau matauna puwala taigala pilakakata, misikwaikwela mweyaveka oyamala kakata, deli misikwaikwela mweyaveka okwaibakwaila kakata. ");
INSERT INTO kij_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","E kesalaga bulami baisa okwailopola yamala, matauna biligabu bila okulula tau matauna, baisa bivigaki matauna bogwa leivagi avaka kasi gulogula paila katumigileu. ");
INSERT INTO kij_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Oluvi tolula bigabu natana minasina bubuna kaina buneroro ");
INSERT INTO kij_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","paila mitugaga lulela e nayuwela paila lula kwegubugabu e bigibugoli deli kaula lulela. Baisa makawala tolula ibodi bivagi avaka kasi gulogula paila katumigileu. ");
INSERT INTO kij_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Karaiwaga makwaina paila avai tau wala isim kala kagwaiguya e galaga iyosi guguwa makwaisina tuta komwaidona leiuvigakaisi lula paila avaka bibudoki kala katumigileu. ");
INSERT INTO kij_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","E Guyau iluki Mosese sola Eroni ");
INSERT INTO kij_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","karaiwaga makwaisina paila bwala makwaisina eikikanaki kulisousou kwekikapela. (Baisa bivitouula avai tuta mina Isireli bogwa eisuvisi Kenani makwaina goli Guyau leisaiki matausina viloutabusi.) ");
INSERT INTO kij_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Kidamwa availa bibani kulisosou ola bwala ibodi matauna bilokaia tolula biluki paila vavagi makwaina. ");
INSERT INTO kij_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","E tolula ibodi bikaraiwogi bisoguguwaisi guguwa komwaidona bim okoukweda, oluviga matauna bila imitakavati kulisosou makwaina; mitaga kidamwa gala bivagaisi makawala, komwaidona guguwala bwala makwaina tolula bikamituli makwaisina kwepupagatu. Oluvi matauna tolula bila wa bwala makwaina ");
INSERT INTO kij_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","bimitakavati kulisosou makwaina. E kidamwa bibani kala gigisa semitamata kaina bweyani eisumsoma tabodala bwala makwaina ");
INSERT INTO kij_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","matauna ibodi bisilavi makwaina e bikobodi yoyula bitotu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","E avai tuta kwailima kwaiyuwela yam bibudoki, tolula bikaimilavau wa bwala makwaina e bimitakavati tuvaila. Kidamwa kulisosou baisa bogwa eikabaiveka, ");
INSERT INTO kij_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","e papala bwala mapilasina eikapilaki kulisosou, matauna bikaraiwogi bitapilakwaisi bikauwaisi bilauwaisi ilavaisi odubilawawa. ");
INSERT INTO kij_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Oluvi matauna bikaraiwogi bitapilakwaisi komwaidona taboda olumoulela bwala makwaina, e wawa baisa leitapilakwaisi bilauwaisi ilavaisi odubilawawa. ");
INSERT INTO kij_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Oluvi yauwovau taboda bipapivauwaisi baisa leitapilakwaisi deli bitabodivauwaisi taboda olumoulela bwala. ");
INSERT INTO kij_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Kidamwa bwala makwaina bogwa eitapilakwaisi papala e eipapivauwaisi mitaga kulisosou makwaina bimyuvau tuvaila, ");
INSERT INTO kij_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","e tolula ibodi bila bigisi. Kidamwa bogwa mokwita eikabaiveka, e bwala makwaina kwepupagatu. ");
INSERT INTO kij_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Mapaila ibodi wala bikodidaimisi bwala makwaina, e kwemwaidona wala bilauwaisi ilavaisi odubilawawa. ");
INSERT INTO kij_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Mitaga kidamwa availa bisuvi bwala makwaina bogwa eikobodaisi yoyula matauna bogwa leiyogwali titoulela e bisisu wala topupagatu kaukwau bila bibogiki. ");
INSERT INTO kij_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Kidamwa availa bikanaki bwala makwaina kaina bikam olumoulela ibodi wala biwini kala karekwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Kidamwa bwala makwaina bogwa eitabodivauwaisi, e tolula bima bigisi kulisosou baisa gala imyuvau, tolula bikamituli bwala makwaina bogwa wala eimigileu, paila kulisosou baisa bogwa leiwokuva. ");
INSERT INTO kij_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Paila bwala makwaina kala katumigileu, tolula ibodi bikau nayu mauna, mimilisi mapilasina kai kweisila, miyana woyai yabweyani, deli masisina silumwaiya. ");
INSERT INTO kij_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","E tolula ibodi bikatumati natana mauna minasina odabala kailuya makaina leitavikotaisi sopi utuwotu. ");
INSERT INTO kij_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Oluvi tolula ibodi bikau vavagi makwaisina, kai kweisila, silumwaiya, woyai yabweyani, deli goli minana mauna namomova e bisewoya okailuya makaina sopi utuwotu deli mauna buyavila eitaguliki minana leikatumati. E tolula ibodi bikatusoki bwala makwaina bibodi sivalima sivayu. ");
INSERT INTO kij_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","E baisa bivigaki tolula bikatumigileu bwala makwaina metoya obuyavila mauna minana, sopi utuwotu, mauna minana namwamova, kai kweisila, silumwaiya, deli goli woyai yabweyani. ");
INSERT INTO kij_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Oluvi tolula ibodi bikiyou mauna minana namwamova bila iyoyowa omalaga. Baisa makawala tolula bivagi avaka kasi gulogula paila bwala kala katumigileu e bwala makwaina bogwa bimigileu mokwita. ");
INSERT INTO kij_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Karaiwaga makwaisina paila karaiwogala kagwaiguya; ");
INSERT INTO kij_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","pwasa, pukuna, kaina sapila wala, deli paila kulisosou bikana okarekwa kaina wa bwala. ");
INSERT INTO kij_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Karaiwaga makawaisina paila biyomitali vavagi makwaisina pupagatu kaina migileu. ");
INSERT INTO kij_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Guyau iluki Mosese sola Eroni ");
INSERT INTO kij_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","karaiwaga makwaisina paila kasi karaiwaga mina Isireli. Ka, kidamwa avai tau biyosi pokesa, e pokesa makwaina kwepupagatu, ");
INSERT INTO kij_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","kaina bibubusi kaina bikabodi. ");
INSERT INTO kij_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Avai moi matauna bisikaila kaina bikanakaila makwaina kwepupagatu. ");
INSERT INTO kij_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kidamwa availa bikabikoni la moi ");
INSERT INTO kij_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","kaina bisimapu kabala, ibodi matauna biwini kala karekwa deli bikakaya, e bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","E kidamwa availa bikabikoni matauna isim kala pokesa, matauna ibodi biwini kala karekwa deli bikakaya, mitaga bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Kidamwa matauna isim kala pokesa bigiu availa tobwaila matauna ibodi biwini kala karekwa deli bikakaya, mitaga bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kidamwa tau matauna isim kala pokesa bisikaila avai kebila wala, kabosisu makwaina bogwa eipupagatu. ");
INSERT INTO kij_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kidamwa availa bikabikoni avai vavagi wala matauna isim kala pokesa eisikaila, matauna bogwa eiyogwali titoulela, e bisisu wala topupagatu kaukwau bila ibugiki. E kidamwa availa bikau avai vavagi wala matauna isim kala pokesa eisikaila, matauna ibodi biwini kala karekwa deli bikakaya, mitaga bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Kidamwa matauna isim kala pokesa gala biwini yamala e bikabikoni taitala tomanabwaita, e tau matauna ibodi biwini kala karekwa deli bikakaya, mitaga bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","E kidamwa matauna isim kala pokesa bikabikoni kwelatala kulimoya, makwelana ibodi bikatumkumkwaisi, deli kidamwa bikabikoni kaitala kaboma, makaina ibodi biwinaisi. ");
INSERT INTO kij_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Avai tuta tau matauna isim kala pokesa bogwa bibwaina, ibodi bisisu kwailima kwaiyu yam, oluvi biwini kala karekwa deli bikakaya sopi utuwotu, e matauna bogwa bimigileu mokwita. ");
INSERT INTO kij_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","E yam kwailima kwaitolula bibudoki, matauna bikau nayu bubuna kaina buneroro bilau omatala Guyau la Buliyoyova e bisaiki minasina baisa tolula. ");
INSERT INTO kij_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","E tolula bigabu natana paila mitugaga lulela, deli nayuwela paila lula kwegubugabu, baisa makawala matauna bivagi avaka kasi gulogula paila tau matauna kala katumigileu. ");
INSERT INTO kij_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kidamwa taitala la sopi bibusimakava wala, matauna ibodi bikakaya tomwaidona, mitaga bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","E avai vavagi eiyoudulokaisi metoya karekwa kaina mauna kanuvinesi bikogiaki tau matauna la sopi, ibodi biwinaisi makwaina, mitaga bisisu wala kwepupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kidamwa taitala tau sola natana vivila bivenokusi kanavai, kasitaiyu wala bikakayasi, mitaga bisisuaisi wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kidamwa natana vivila kala tubukona buyavila bititalagila, minana napupagatu, e bisisu biboda kwailima kwaiyu yam. E kidamwa availa bikabikoni minana bogwa eiyogwali titoulela e bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Avai vavagi minana bisikaila kaina bikanakaila tutala buyavila eititalagila, vavagi makwaina kwepupagatu wala. ");
INSERT INTO kij_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","E kidamwa availa bikabikoni la moi kaina avai vavagi wala minana leisikaila, ibodi biwini kala karekwa deli bikakaya, mitaga bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","E kidamwa minana igau wala buyavila eititalagila, e taitalaga bimokaia minana, matauna bogwa eiyogwali titoulela metoya minana pupagatula wowola, e matauna bisisu wala topupagatu biboda kwailima kwaiyu yam, e kidamwa avai moi bikanakaila, moi makwaina kwepupagatu wala. ");
INSERT INTO kij_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kidamwa natana vivila bikabuyaimakava wala kwaivila yam gala kala tubukona, kaina bogwa eibudoki kala tubukona mitaga bisetuwoli wala bititalagila lopola, e makawala kala kaduwonaku bititalagila lopola e minana bisisu wala napupagatu. ");
INSERT INTO kij_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Avai moi minana bikanakaila kaina avai vavagi bisikaila otutala eikikabuyavi makwaina kwepupagatu. ");
INSERT INTO kij_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Kidamwa availa bikabikoni vavagi makwaisina matauna bogwa eiyogwali titoulela mapaila matauna ibodi biwini kala karekwa deli bikakaya, mitaga bisisu wala topupagatu kaukwau bila ibugiki. ");
INSERT INTO kij_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Avai tuta vivila minana bitaboda buyavila, minana ibodi bisisu kwailima kwaiyu yam, e minana bogwa bimigileu. ");
INSERT INTO kij_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","E yam kwailima kwaitolula bibudoki, minana ibodi bikau nayu bubuna kaina nayu buneroro e bilau Guyau ola Buliyoyova wa lulu, e bisaiki minasina tolula. ");
INSERT INTO kij_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","E tolula bigabu natana paila mitugaga lulela e nayuwela paila lula kwegubugabu, baisa makawala matauna bivagi avaka kasi gulogula paila tau matauna kala katumigileu. ");
INSERT INTO kij_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Guyau iluki Mosese bikatululuti mina Isireli paila kasi pupagatu, taga biyogwalaisi Guyau la Buliyoyova, makwaina eitotu oluwalela kabosikaiwa. Kidamwa bivagaisi makawala, bikaligasi. ");
INSERT INTO kij_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Karaiwaga makwaisina paila karaiwogala avai tau bikapokesa kaina bibusimakava la sopi, ");
INSERT INTO kij_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kaina avai vila kala tubukona buyavila bititalagila, kaina taitala tau bimokaia natana vivila minana napupagatu deli buyavila eititalagila. ");
INSERT INTO kij_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","E Guyau ilivala baisa Mosese igau bogwa eikaligasi kasitaiyu litula Eroni. Eikatumati matausina paila kovala lula ivakogalaisi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Guyau ikaibiga, “Kuluki tuwam Eroni kidamwa gala bisuvimakava bila opapala tapapela matabudona e bisuki matabudona Bomikikila Sainela. Mitaga bisuvi okala tuta wala. Paila yeigu bayoumatila olopola lowalowa odabala katubukolela Yaubada la Kabutu Didawogala. Kidamwa bikoulovi karaiwaga makwaina, e bogwa bawaiya bikaliga. ");
INSERT INTO kij_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Ibodi bisuvi matabudona Bomikikila Sainela kidamwa bogwa leimai bulumakau namwala paila mitugaga lulela deli natana sipi namwala paila lula kwegubugabu.” ");
INSERT INTO kij_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Mapaila Guyau iluki avaka kidikedala matabudona Bomikikila Sainela kala susuvi. Igau gala bisuvi matabudona Bomikikila Sainela, ibodi ikugwa Eroni bikakaya, biwokuva, oluvi bivalili kasi karekwa tolula, baisa kala kakapula yapupwakau deli kala kwama yakukupi, e bigigi kala palitula okuvalila, deli kala geba opwanetala. ");
INSERT INTO kij_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","E mina Isireli osi boda bisakaisi Eroni nayu gota nammwala paila mitugaga lulela, deli natana sipi namwala paila lula kwegubugabu. ");
INSERT INTO kij_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ibodi matauna bisaiki natana bulumakau namwala bivigaki lula paila biligaiwa la mitugaga titoulela deli si mitugaga litula. ");
INSERT INTO kij_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Matauna bimai nayu gota minasina okala lulu buliyoyova makwaina Yaubada la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Baisa wa lulu bikowobobuta metoya kwaiyu dakuna, kwaitala isim kala ginigini “paila Guyau”, e kwaiyuwelaga “paila Asaseli.” ");
INSERT INTO kij_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Avai gota bikowobuboti paila Guyau, minana bivigaki lulela mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","E avai gota bikowobuboti paila Asaseli, minana bisakaisi namwamova baisa Guyau, deli biwitalaisi bila oviloupakala bilokaia Asaseli, kidamwa mwada bikau biligaiwa tomota si mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Avai tuta Eroni bilula metoya minana bulumakau, baisa mitugaga kala ligaiwa paila titoulela deli paila litula komwaidosi, ");
INSERT INTO kij_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","oluvi matauna bikau kova kaisakaila ikasewa pwakova metoya okabolula, deli sivayu biyeli maiina simasimina bimai makwaisina baisa matabudona Bomikikila Sainela. ");
INSERT INTO kij_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Baisa omatala Guyau bisaili maiina simasimina wa kova, e bibobwau mseu bitabodi katubukolela Yaubada la Kabutu Didawogala. Gala ibodi matauna bigisi makwaina kaina igau matauna bikaliga. ");
INSERT INTO kij_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","E bikau sitana buyavila bulumakau, e omisikwaikwela bividagu bikatusoki baisa omatala katukwabula, oluviga bikatusoki omatala didawaga, bivagi sivalima sivayu. ");
INSERT INTO kij_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","E oluviga bikatumati minana gota, baisa paila tomota si mitugaga kala ligaiwa, e bimai buyavi baisa matabudona Bomikikila Sainela bikatusoki katukwabula makwelana, oluvi baisa omatala makwaina didawaga, makawala avaka eivigibogwi buyavila bulumakau. ");
INSERT INTO kij_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","E baisa makawala matauna bivagi makawala kidikedala matabudona Bomikikila Sainela, kidamwa bikikilivau matabudona metoya osi yogwala mina Isireli deli si mitugaga. Ibodi bivagi makawala baisa matabudona, paila itowalai osi kabosikaiwa e makwaina valu tomotala iiyogwalaisi kasi karaiwaga. ");
INSERT INTO kij_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Metoya ola tuta Eroni bisuvi matabudona Bomikikila Sainela kidamwa bivagi kidikedala kikila igau avai tuta bisunapula, gala wala availa bisisu okaukwedala Buliyoyova. Tutala matauna bogwa bikikilivau titoulela, litula, deli goli tomota komwaidosi, ");
INSERT INTO kij_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","e oluvi bisunapula bila okabolula paila bikikilivau. E matauna bikau sitana bulumakau buyavila deli sitana gota buyavila bikatusoki kala katububula owokulula makwaina kabolula. ");
INSERT INTO kij_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","E matauna omisikwaikwela sitana buyavila bulumakau bividagu e bikatusoki baisa kabolula sivalima sivayu. E baisa makawala goli bikikili mina Isireli si mitugaga deli bikabomi makwaina. ");
INSERT INTO kij_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Avai tuta Eroni bogwa eivigimkulovi avaka kidikedala bikikili matabudona Bomikikila Sainela e komwaidona Guyau la Buliyoyova e kabolula, e oluvi matauna bisaiki Guyau minana gota namwamova einagaisi paila Asaseli. ");
INSERT INTO kij_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","E matauna bisaili yamala kweyayu wala odabala gota e bikamituli mina Isireli komwaidona si bubunela doudoga, si mitugaga e si kowolova, e bikatupeili makwaisina bila odabala minawena gota. E binagaisi taitala tau bilau minana oviloupakala e bibokavili bila. ");
INSERT INTO kij_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","E minana gota bogwa bikau komwaidona si mitugaga bilau deli minana biligaiwa ambaisa tomota gala isisakaisi. ");
INSERT INTO kij_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","E oluvi Eroni bisuvi oBuliyoyova bikatulovi tolula kasi kwama miyasina avaka eisikambogwa e bisaili miyasina ambaisa kabosakaila. ");
INSERT INTO kij_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Matauna bikakaya okabokakaya sopi kwebumaboma, e oluviga bisikam kala kakapula tatoula. E oluvi matauna bisunapula bila bigabu lula paila la mitugaga kala ligaiwa e deli goli komwaidosi tomotala Isireli si mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Matauna bigabu posala mauna paila mitugaga lulela odabala kabolula. ");
INSERT INTO kij_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Matauna tau eibokavili minana gota bila oviloupakala baisa Asaseli, ibodi wala biwini kala kakapula deli bikakaya e oluvi bikaimilavau okabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","E bogwa leikatumati minasina bulumakau deli gota eivagaisi mitugaga lulela, minasina buyavisi bogwa leilauwaisi olumoulela matabudona Bomikikila Sainela paila mitugaga kala ligaiwa ibodi bivisunupulovi osi kabosikaiwa e bigabwaisi. E tuta baisa bikeulasi kanuvinesi, vilionesi e deli sileu, ibodi wala komwaidona bigabwaisi biwokuva. Bikauwaisi bilauwaisi odubilawawa e bigabwaisi komwaidona goli bitamwau. ");
INSERT INTO kij_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Matauna wala eigabu makwaisina, biwina kala kakapula e bikakaya oluviga bikaimilavau okabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Karaiwaga makwaisina ibodi bukukwabikaulasi tuta komwaidona deli igau tuta bima. Nalima nayuwela tubukona kala yam kweluwotala, e mina Isireli deli avai tomitawasi isisu deli matausina, gala ibodi bivagaisi avai paisewa. ");
INSERT INTO kij_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Wa yam makwaina ibodi wala bukuvagaisi kala kidakeda paila bikatumigileu matausina metoya osi mitugaga, e makawala goli bikikilaisi makawala kala karaiwaga. ");
INSERT INTO kij_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Yam makwaina bukuvigakaisi yam kwebumaboma sainela, e tomota biposumasi deli gala avai paisewa bivagaisi. Karaiwaga makwaisina ibodi bukukwabikaulasi tuta komwaidona deli igau tuta bima. ");
INSERT INTO kij_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ibodaimi mi Tolula Toveka tovau bukuvaputumaisi e bukukwabomaisi, kidamwa biwotetila kaimapula tamala. E ibodi matauna tuta tuta bivagi makawala kidikedala kikilavau. Matauna iboda bisikoma tolula kasi kwama, ");
INSERT INTO kij_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","e bivagi kala tapwaroru paila bikikilavau matabudona Bomikikila Sainela, deli kwemwaidona Buliyoyova makwaina Guyau la Buliyoyova, e kabolula, e tutala komwaidosi deli tomotala ovalu kasi kikilavau bivagi. ");
INSERT INTO kij_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Makwaisina karaiwaga ibodi bukukwabikaulasi tuta komwaidona deli igau tuta bima. Makwaina tapwaroru ibodi bukuvagaisi sivatala wala olopola kwaitala taitu paila bikau biligaiwa si mitugaga mina Isireli, e bikikilavausiga. Mapaila Mosese ivagi makawala avaka Guyau eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","biluki Eroni deli litula deli goli komwaidona mina Isireli paila karaiwaga makwaisina. ");
INSERT INTO kij_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","4","Ka, kidamwa availa bikatumati natana bulumakau navivila kaina sipi, kaina gota, mwada bivigaki la semakavi baisa Guyau, mitaga omalaga wala ikatumati gala bimai omatala Guyau la Buliyoyova matauna bogwa eikoulovi karaiwaga. Paila matauna bogwa eikipwasa yamala buyavi e deli gala tuvaila bidokaisi matauna taitala Yaubada la tomota. ");
INSERT INTO kij_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Karaiwaga makwaina kala kamokwita, ibodi mina Isireli bimiakaisi Guyau mauna minasina leikatumataisi omalaga. Mitaga ibodi baisa tuta bimiakaisi tolula mauna minasina omatala Buliyoyova, e bikatumataisi paila kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","E tolula bikau buyavila mauna bikatusoki komwaidona papala kabogwabu lula omatala Guyau la Buliyoyova, e posalaga bigabu e maiina biyaina biyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Mapaila mina Isireli gala tuvaila bikoulovaisi Guyau metoya bikatumataisi si mauna omalaga wala paila bivigakaisi si lula baisa tokolu eibubulaisi migila gota. E karaiwaga makwaina mina Isireli ibodi biyamataisi tubwa tuta baisa e tubwa tuta oluvi. ");
INSERT INTO kij_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Kidamwa taitala guma Isireli kaina taitala togilagala omi boda bisemakavi lula kwegubugabu kaina avai lula wala ituwoli ");
INSERT INTO kij_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","paila la semakavi baisa Guyau omalaga wala e gala bimai omatala Guyau la Buliyoyova, matauna gala wala bidokaisi taitala Guyau la tomota. ");
INSERT INTO kij_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Kidamwa taitala guma Isireli kaina taitala togilagala omi boda bikoma vilionesi mauna deli buyavila e Guyau bogwa bigibuluwi matauna, e gala tuvaila bidoki matauna taitala la tomota. ");
INSERT INTO kij_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Paila bubuli komwaidona kwemmomova, da momovasi isisu obuyavi, baisa uula Guyau eikaraiwogi komwaidona buyavi biligabwaisi bila okabogwabu lula paila tomota si mitugaga kala ligaiwa. Paila buyavi baisa goli momova uulela, paila mitugaga kala winisewa. ");
INSERT INTO kij_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Baisa uula Guyau iluki mina Isireli, gala matausina kaina togilagala ibodi bikomasi mauna vilionesi deli buyavila. ");
INSERT INTO kij_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Kidamwa taitala guma Isireli kaina taitala togilagala bikatumati natana mauna nasigisagina kaina nayoyowa minana namigileu, ibodi matauna biligabu buyavila opwaipwaia e bikaliduboli. ");
INSERT INTO kij_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Paila bubuli komwaidona da momovasi isisu obuyavi, baisa uula Guyau iluki mina Isireli gala bikamsi viliona deli buyavila. Kidamwa availa bikam matauna gala tuvaila bidokaisi taitala Guyau la tomota. ");
INSERT INTO kij_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Kidamwa taitala guma Isireli kaina taitala togilagala bikoma vilionela avai mauna wala eikaligimakava kaina mauna nagigasisi leikamataisi, matauna ibodi biwini kala karekwa deli bikakaya, mitaga bisisu wala topupagatu kaukwau bila ibugiki, e oluvi matauna bogwa bimigileu. ");
INSERT INTO kij_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mitaga kidamwa gala bivagi makawala, matauna ibodi bilumkoli mmayuyu mapula la kowolova. ");
INSERT INTO kij_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","biluki mina Isireli kawala, “Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Gala bukukwavisakaisi si bubunela mina Itipita, mapilana goli okwaitala lokusisuaisi okatupipi, kaina bukukwavisakaisi si bubunela mina Kenani, ambaisa balauwaimi tuta baisa. ");
INSERT INTO kij_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ibodi bukukwabikuwolaisi ulo karaiwaga deli kuvagaisi avaka bakaraiwogaimi. Yeigu goli Guyau mi Yaubada, ");
INSERT INTO kij_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","mapaila kukwavisakaisi avaka lalukwaimi deli kuvagaisi avaka ulo karaiwaga lakaraiwogaimi; paila kidamwa bukuvagaisi makawala bukumovasi. Yeigu goli Guyau.” ");
INSERT INTO kij_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","E Guyau iluki karaiwaga makwaisina. Gala bukumokaia dalem titoulem. ");
INSERT INTO kij_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Gala goli bukuyomsili tamam metoya bukumokaia inam tatoum. Gala goli bukuyomsili inam tatoum. ");
INSERT INTO kij_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Kidamwa tamam la kukova bidubadu, gala bukumokaia minasina. ");
INSERT INTO kij_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Gala bukumokaia lumta tatoum kaina lumta minana inala ituwoli e tumamiga taitala, kaina omi kaukweda tumami eiuni kaina ituwoli kaukweda. ");
INSERT INTO kij_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Gala bukumokaia tabum vivila, minawena latum latula, paila baisa bukuyomsilaim wala titoulem. ");
INSERT INTO kij_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Deli kidamwa tamam bivaivau e biuni latula vivila, gala bukumokaia minana, paila minana lumta goli. ");
INSERT INTO kij_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","13","Gala bukumokaia tamam luleta kaina inam tuwala deli bodala. ");
INSERT INTO kij_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Gala bukumokaia kadam la kwava paila minana bukudoki inam goli. ");
INSERT INTO kij_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Gala bukumokaia latum la kwava ");
INSERT INTO kij_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","kaina tuwam kainaga bodam la kwava. ");
INSERT INTO kij_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Gala bukumokaia latula kaina tabula vivila minana bogwa lokumokaiabogwi; paila minasina buyavim, paila baisa bivigaki bogwa lokukwavi kam kwaboma titoulem. ");
INSERT INTO kij_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Kidamwa m kwava igau namomova isisu gala bukubuluvavaia bodala kaina tuwala. ");
INSERT INTO kij_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Gala bukumokaia vivila minana igau wala buyavila eititalagila paila minana saina wala napupagatu. ");
INSERT INTO kij_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Gala bukukwailasi som la kwava paila baisa bukuyogwalaim wala titoulem. ");
INSERT INTO kij_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Gala bukutugwali taitala latum bigubukwaisi lula baisa yaubada tokolu yagala Moleki, paila baisa bivigaki saina kabommosila oyagala Guyau Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Gala ibodi tau bimisii sola tau, paila Yaubada ikamogi nanamsa makawala. ");
INSERT INTO kij_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Gala tau kaina vivila ibodi bikatumwakula deli mauna, paila nanamsa makwaina saina doudoga biyopigigataim titoulem. ");
INSERT INTO kij_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Gala bukuyogwalaimi titoulemi metoya kwaitala nanamsa makwaisina, paila baisa makawala matausina gala inikolaisi Yaubada leiyogwalaisi titoulesi, matausina goli leisibogwasi ovalu mapilana, e Guyau igau bibokavili bibutusi igagabilaga yokomi bukusuvisi. ");
INSERT INTO kij_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Si kedakeda gaga ivigaki iyopigigataisi valu mapilana, mapaila Guyau imipuki valu mapilana, e tomotala eisisuaisi ivabutu ibutusi, kidamwa goli yokomi bukusuvisi mapilana. ");
INSERT INTO kij_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","27","Matausina eivagaisi vavagi komwaidona makwaisina saina kabokakayuwa e ivigaki iyopigigataisi valu mapilana, mitaga yokomi gala wala ibodaimi bukuvagaisi vavagi makwaisina. Komwaidomi wala kaina yokomi mina Isireli kaina togilagala matausina eisilomlasi deli yokomi, ibodi bukukwabikuwolaisi Guyau la karaiwaga avaka leikaraiwogaimi, ");
INSERT INTO kij_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","e valu mapilana gala bipakaimi makawala leipaiki matausina tosibogwa gala inikolaisi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Bogwa kunikolaisi kidamwa availa bivagi kwaitala vavagi makwaisina saina kabokakayuwa, matauna gala tuvaila bidokaisi taitala Yaubada la tomota. ");
INSERT INTO kij_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","E Guyau ikaibiga kawala, “Kukwabikuwolaisi karaiwaga makwaisina lasakaimi, e taga bukubokulaisi si kedakeda tomota matausina eisibogwasi valu mapilana, deli taga bukuyogwalaimi titoulemi metoya bukukwavisakaisi kwaitala vavagi makwaisina. Yeigu wala Guyau mi Yaubada.” ");
INSERT INTO kij_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","bilivala baisa mina Isireli, kawala, “Ibodaimi yokomi mina bumaboma, paila yeigu Guyau mi Yaubada, yeigu tobumaboma. ");
INSERT INTO kij_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Taitala taitala yokomi ibodi bukutemmalaisi inumia deli tumimia, e ibodi bukukwabikuwolaisi kala karaiwaga Sabate, makawala lakaraiwogaimi. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Taga sitana bukupakaigusi mwada bukutapwarorusi baisa tokolu, taga sitana bukububulaisi yaubada metoya tanumnumta e bukutapwarorusi baisa minasina. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Avai tuta bukukwatumataisi natana mauna paila kalubaila lulela ibodaimi bukukwabikuwolaisi kala karaiwaga paila kikila kidikedala makawala avaka lasakaimi, e yeigu bakabwaili makwaina lula. ");
INSERT INTO kij_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","E vilionela bukukomasi wa yam makwaina lokukwatumataisi minana mauna, kaina bikanam eiyam. E kidamwa sitana kesa bikanam paila kwaitolula yam, ibodi wala kala gabu bitamwau, ");
INSERT INTO kij_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","paila baisa bogwa eivigaki kala pupagatu. E kidamwa availa bikoma, yeigu gala sitana bakabwaili lula makwaina. ");
INSERT INTO kij_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Paila availa bikoma viliona makwaina makawala wa yam kwaitolula, e baisa avaka lokukikilaisi paila yeigu, bogwa matauna tokam eivigaki vavagi vigimakava wala, e matauna gala tuvaila bukudokaisi taitala ulo tomota. ");
INSERT INTO kij_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Avai tuta bukutayoyuwasi omi bagula, taga bukutamkulovaisi witi makaisina kala vigimkovila opapala mi bagula. Tuvaila gala bukukweiitasi mwada bukutamkulovaisi makaisina itowaisi. ");
INSERT INTO kij_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","E gala bukukweiitasi bukulosi omi bagula bigulela waini mwada bukukiuyasi sisimonogu masisisina avaka totayoyuwa gala eibinibogwisi kaina bukusauwaisi masisisina avaka eikikapusisi. Kuligaiwaisi bikanawa paila tonamakava deli togilagala. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Taga sitana bukuveilausi, kaina bukukidoudogasi karaiwaga, kaina bukuubuwabusi. ");
INSERT INTO kij_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Taga sitana bukuvagaisi kwaitala biga katotila oyagagu kidamwa kunikolaisi gala wala bukuvagaisi. Baisa bivigaki bukuyomsilaigusi goli. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Taga sitana bukukwaumakavaisi si vavagi semia, kaina bukulebwaisi matauna. Taga sitana bukukwatuyumalaisi mapula sami la paisewa, gala kaina paila kwaitala wala bogi, gala wala. ");
INSERT INTO kij_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Taga sitana bukubigigagaisi taitala totuli, kaina bukusailisi avai kabosilagi omatala tokwau, mwada bukuvagaisi bitokaila. Ibodaimi bukukukolaigusi goli. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Avai tuta tomota biyakalasi omitami, iboda wala bukunagaisi avaka kala duwosisia, e gala bukutabilibilisi, kaina bukupiaisi tonamakava kainaga bukukukolaisiga matauna bidubadu la guguwa. ");
INSERT INTO kij_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Taga bukukwayayaisi biga sopa paila availa. E kidamwa availa itotu omatala toyakala, e isim kala pakula ibodi kaliga, e yokomiga kudokaisi mi silasola bibodi bipilasi matauna, e bwaina wala kutotusi peula e bukulivalasi avaka kala duwosisia. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Gala nanom bimwau baisa avai tomota paila eiyogagaim, mitaga ibodi wala bukukiduwosisiaisi kamitaiyu, kidamwa gala bukuvagi sula paila uula matauna. ");
INSERT INTO kij_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Gala bukukwaimapu baisa avai tomota, kaina bisetuwoli m tavilevi baisa matauna. Mitaga bukuyebwaili som makawala kuyebwailim titoulem. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Bukukwabikaulasi ulo karaiwaga. Ibodi mi bulutuvalu navivila biuni litula metoya namwala kidamwa migisi migitinidesi wala, e gala wala natana namwala migatala biuni latula metoya natana navivila ituwoli migila. Gala bukuvali kwaiyu waituna migawelu migawelu olopola kwaitala bagula. Gala bukusikoma kwama eibasaisi metoya migayu karekwa. ");
INSERT INTO kij_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Kidamwa taitala tau bogwa eikatotila paila bigimoli la ula vivila baisa sola paila bivigaki makawala la kwava, mitaga togimwala gala imapu minana, e kainaga toliula bimisii, e gala bukukwatumataisi matauna sola la ula vivila. Paila igau wala gala bikau mapula minana la ula. Mitaga bogwala bibodi mipuki. ");
INSERT INTO kij_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Matauna tau ibodi bimai natana sipi namwala wa lulu ogu Buliyoyova paila kaimapu lulela, ");
INSERT INTO kij_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","e metoya baisa Tolula ibodi bivagi tapwaroru paila kikilavau, kidamwa bikau la mitugaga matauna, e Yaubada bogwa biligaiwa tau matauna la sula. ");
INSERT INTO kij_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Avai tuta bukusuvisi okubilela Kenani e bukuvalaisi avai kai kaiwouwa, ibodi bukudokaisi kaiuwasi isim kala bumaboma biboda kwaitolu taitu, kala tuta makwaina yokomi gala bukukomasi. ");
INSERT INTO kij_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","E kwaivasila taitu komwaidona kaiuwasi kai makaisina ibodi bukukwasalaisi bukusemakavaisi baisa Guyau. E makawala bukuvitulokaigusi mi taimamila kala vakaila baisa yeigu mi Guyau. ");
INSERT INTO kij_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Mitaga kwailimala taitu yokomi ibodaimi bukukomasi kaiuwala kai. Kidamwa bukuvagaisi makawala, kaiuwasi mi kai bikalisau kala kaiuwa. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Gala bukukomasi avai viliona kidamwa deli buyavila olumoulela. Gala bukukwavisakaisi avai bogau. ");
INSERT INTO kij_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Gala bukukwapitunaisi kulumi miyasina opapala dubami kaina bukutabubotaisi kami gabula, ");
INSERT INTO kij_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","kaina bukuwaiyaisi katukwatuva ouwomi, kaina bukuteyasi uwomi mwada kabutuvitusila mi ninamwau paila kaliga. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Taga bukulukwaisi minasina litumia mwada bitugwalaisi uwosi baisa avai yaubada bivigaki nakalimwala olumoulela makwaina tapwaroru sasopa. Baisa bivigaki minasina kasi mmosila sainela. Kidamwa kuvagaisi makawala, bogwa bukutovilaisi bukuwotitalaisi yaubada ituwoli ituwoli, e valu bikasewoki bubunela gegedu wala. ");
INSERT INTO kij_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Kukwabikuwolaisi kala karaiwaga yam sabate, e bukutemmalaisi valu mapilana ambaisa ititapwarorusi baisa yeigu. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Taga bukunevisi mapula mi katupoi metoya baisa matausina tokaisivila, matausina ikikatupoisi metoya baisa bilomasi tomata. Kidamwa bukuvagaisi makawala, bogwa bukuyogwalaisi ulo karaiwaga. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Kuvitulokaisi mi kamaiaba baisa tommoya nunumoya, e deli bukuyakawolaisi matausina. Mitaga ibodi bukukukolaigusi wala. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Taga bukutabinakaisi togilagala availa matausina eisisuaisi omi valu. ");
INSERT INTO kij_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Kuvigakaisi matausina makawala goli bukuvigakaisi avai sami guma Isireli, e bukuyebwailisi matausina makawala kuyebwailimi titoulemi. Ibodi bukululuwaisi kidamwa omitibogwa yokomi tuvaila kusisuaisi togilagala mapilana Itipita. Yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Taga kusipulokaisi availa kidamwa kuvisaikolaisi avai guguwa. Mitaga ibodi bukuvisaikoli duwosisia avaka kala maloula, kala mokaila deli kala bawa. ");
INSERT INTO kij_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ibodi wala mi kabovisaikola duwosisia wala e mapaila gala wala bukusasopasi avai tuta kuvisaikoli guguwa kala mokaila deli kala maloula. Yeigu goli Guyau mi Yaubada e lasunupuloiyaimi metoya mapilana Itipita. ");
INSERT INTO kij_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Bukukwabikuwolaisi komwaidona makwaisina ulo karaiwaga. Yeigu goli Guyau.” ");
INSERT INTO kij_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","biluki mina Isireli kawala, “Kidamwa availa guma Isireli kaina taitala togilagala omi boda bitugwali guditala latula paila bigubukwaisi lula baisa yaubada tokolu yagala Moleki, ibodi wala tomota komwaidona bikabidikunaisi bikaliga. ");
INSERT INTO kij_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Kidamwa availa bitugwali guditala latula bigubukwaisi lula baisa yaubada tokolu yagala Moleki e biyogwali ulo Buliyoyova kwebumaboma, deli biyomsili yagagu igibumaboma, yeigu saina bagibuluwi matauna e gala tuvaila bavigaki matauna taitala ulo tomota. ");
INSERT INTO kij_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Mitaga kidamwa tomota komwaidona gala bikaiki uwosi avaka matauna bogwa leivagi, e gala ikatumataisi, ");
INSERT INTO kij_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","e yeigu saina bagibuluwi matauna deli litula komwaidona, deli komwaidona availa availa matausina eitokailasi matauna eikoulovaigusi ititaimamilasiga baisa minana yaubada tokolu yagala Moleki. Yeigu gala tuvaila badoki matausina ulo tomota. ");
INSERT INTO kij_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Kidamwa availa binainevi avaka metoya baisa matausina tokaisivila, yeigu saina bagibuluwi matauna, e gala tuvaila badoki matauna taitala ulo tomota. ");
INSERT INTO kij_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Mapaila kukwabomaimi titoulemi, paila uula yeigu goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kukwabikuwolaisi komwaidona ulo karaiwaga, paila yeigu Guyau e lavigakaimi tobumaboma.” ");
INSERT INTO kij_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Guyau isaiki karaiwaga makwaisina baisa makawala. Availa bibuloti tamala deli inala matauna ibodi bikatumataisi; e la kaliga kala pakula wala titoulela. ");
INSERT INTO kij_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Kidamwa taitala tau bikailasi sola wala guma Isireli la kwava, tau matauna deli vivila minana kasitaiyu wala bikatumataisi. ");
INSERT INTO kij_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Kidamwa taitala tau bimokaia natana tamala la kukova, matauna bogwa eiyomsili tamala, mapaila kasitaiyu wala bikatumataisi. E si kaliga kasi pakula wala titoulesi. ");
INSERT INTO kij_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kidamwa taitala tau bimokaia yawala vivila, kasitaiyu wala bikatumataisi, paila bogwa eikavaisi kasi kaboma titoulesi, e si kaliga kasi pakula wala titoulesi. ");
INSERT INTO kij_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kidamwa taitala tau bimisii sola tau wala, matausina bogwa eivagaisi vavagi saina kabokakayuwa, e kasitaiyu wala bikatumataisi, e si kaliga kasi pakula wala titoulesi. ");
INSERT INTO kij_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Kidamwa taitala tau bivaigoli natana vivila sola inala, kasitaitolu wala bigabwaisi wa kova bikaligasi, paila uula bogwa leivagaisi vavagi makwaina saina kabommosila, deli vavagi makawala makwaina gala bisusukwaimi. ");
INSERT INTO kij_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kidamwa taitala tau bimokaia natana mauna, tau matauna deli mauna minana bikatumataisi. ");
INSERT INTO kij_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kidamwa natana vivila bivigikoni mwada bimokaia natana mauna, vivila minana deli mauna minana bikatumataisi, e si kaliga kasi pakula wala titoulesi. ");
INSERT INTO kij_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kidamwa taitala tau bivaiya luleta titoulela kaina luleta inala ituwoli tumasiga taitala, matauna bogwa bikayayaisi olopola valu, mapaila ibodi biyabaisi metoya osi boda. Matauna bogwa eimokaia luleta tatoula mapaila ibodi bilumkoli kala kamwaga paila la sula titoulela. ");
INSERT INTO kij_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kidamwa taitala tau bimokaia natana vivila otutala kala tubukona buyavila eititalagila, kasitaiyu wala biyabaisi metoya osi boda paila uula matausina bogwa eikoulovaisi avaka kasi karaiwaga paila eiyopigigataisi titoulesi. ");
INSERT INTO kij_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Kidamwa taitala tau bimokaia inala ilitomoya kaina ilagwadi, kasitaiyu wala bogwa eikavaisi kasi kaboma titoulesi, e kasitaiyu wala ibodi bilumkolaisi kasi kamwaga paila si sula titoulesi. ");
INSERT INTO kij_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kidamwa taitala tau bimokaia la kwava kadala matauna bogwa eiyomsili kadala, mapaila kasitaiyu wala ibodi bikabilulasi mapula si sula, e gala wala biunaisi gugwadi. ");
INSERT INTO kij_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Kidamwa taitala tau bivaisabu la kwava tuwala kaina bodala, kasitaiyu wala gala biunaisi gugwadi osi tuta tommomova. Paila matauna bogwa leivagi vavagi makwaina saina gaga, deli bogwa eiyomsili tuwala kaina bodala. ");
INSERT INTO kij_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","E Guyau ikaibiga kawala, “Kuvagaisi komwaidona ulo karaiwaga makwaisina avaka lakaraiwogaimi, e igagabila valu Kenani mapilana goli balauwaimi gala bipakaimi. ");
INSERT INTO kij_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","E gala bukusopeilisi avaka kasi gulogula matausina tosibogwa; paila yeigu bogwa babokavili matausina gala inikolaigusi e igagabila yokomi bukusuvisi wala makwaina. Matausina leivigakaigusi kabokakayuwa metoya komwaidona si kedakeda gaga eiuvagaisi. ");
INSERT INTO kij_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Mitaga yeigu bogwa lakatotila basakaimi valu mapilana viloukabalaki deli pwaipwayela bilukumalala e bivigaki mi vavagi tatoumi. Yeigu goli Guyau mi Yaubada, yeigu bogwa lakatupalaimi metoya boda ituwoli ituwoli. ");
INSERT INTO kij_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Mapaila ibodaimi bukumitakavataisi bibwaina metoya mauna nasigisagina e mauna nayoyowa minasina namigileu e minasina napupagatu; gala ibodi bukukomasi minasina napupagatu nayoyowa kaina nasigisagina. Yeigu bogwa lakavili minasina napupagatu, e kidamwa bukukomasi bogwa bukuyogwalaimi titoulemi. ");
INSERT INTO kij_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Yokomi ulo tomota tatougu mapaila ibodaimi bukukwabomaimi titoulemi, paila yeigu Guyau. Yeigu goli Tobumaboma. Yokomi bogwa lakatupalaimi metoya boda ituwoli ituwoli mapaila yokomi ulo tomota tatougu. ");
INSERT INTO kij_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Avai tau kaina avai vila bikikaisivila, matauna kaina minana ibodi bikabidikunaisi wala bikaliga. Avai tau bivagi makawala baisa, matauna iyomituli la kaliga titoulela.” ");
INSERT INTO kij_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","E Guyau ikaraiwogi Mosese biluki Eroni dalela mabudona tolula kawala, “Gala taitala yokomi tolula ibodi biyogwali titoulela metoya bivagi avai vavagi avai tuta taitala vaiyola bikaliga, ");
INSERT INTO kij_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","mesinaku wala inala, kaina tamala, luleta, tuwala, budala, ");
INSERT INTO kij_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kaina luleta minana nakubukwabuya eiuvauli. ");
INSERT INTO kij_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Matauna gala ibodi biyogwali titoulela metoya osi kaliga la veivai. ");
INSERT INTO kij_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Gala taitala tolula ibodi biviliu katupotala pwanetala kaina bitabuboti kala gabula, kaina bitaguligweili wowola paila biyomitali la ninamwau. ");
INSERT INTO kij_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Matauna ibodi bikabomi titoulela e gala biyomsilaigu. Paila matauna igibugabu kaula lulela baisa yeigu, mapaila matauna ibodi bikabomi titoulela. ");
INSERT INTO kij_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Tolula gala ibodi bivaiya natana minasina nakalimwala kaina minana bogwa ikikapugula kaina minana nauvaipaka, paila matauna tobumaboma. ");
INSERT INTO kij_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","E tomota ibodi bivigakaisi tolula tobumaboma, paila matauna igibugabu kaula lulela baisa yeigu. Yeigu goli Guyau. Yeigu Tobumaboma e ulo touwata bavigaki mina bumaboma wala. ");
INSERT INTO kij_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kidamwa taitala tolula latula vivila bivigaki titoulela nakalimwala, minana bogwa eiyomsili tamala, mapaila ibodi wala bigabwaisi minana wa kova bikaliga. ");
INSERT INTO kij_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“E Tolula Toveka bogwa eivaputumaisi deli bogwa eikabomaisi matauna paila bisikam kasi karekwa tolula, mapaila matauna gala ibodi biviriviri kulula kaina bikisi kala kwama paila biyomitali la ninamwau. ");
INSERT INTO kij_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","Paila matauna bogwa leikabomaisi paila yeigu, e gala biyogwali titoulela kaina biyogwali ulo Buliyoyova kwebumaboma metoya bisilavi ulo Buliyoyova e bilaga bwala makwaina tomata eikikanaki, ilagoli tamala kaina inala tatoula. ");
INSERT INTO kij_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Matauna ibodi wala bivaiya natana gala ikikapugula, ");
INSERT INTO kij_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","gala kwabuya kaina natana nauvaipaka kaina natana nakalimwala. Matauna ibodi bivaiya natana gala ikikapugula metoya odalela titoulela. ");
INSERT INTO kij_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Mitaga kidamwa gala bivagi makawala, e mwada litula tobumaboma, bogwa bivigaki topupagatu. Yeigu goli Guyau e yeigu bogwa lakatupali matauna lavigaki Tolula Toveka.” ");
INSERT INTO kij_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","biluki Eroni kawala, “Gala taitala metoya odalem matauna isim pikolela wowola ibodi bigabu kaula lulela baisa yeigu. Karaiwaga makwaina paila tuta baisa deli tubwa tuta oluvi. ");
INSERT INTO kij_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Gala taitala isim kala kapwaila ibodi bigabu lula makwaina. gala taitala, tokwau, topem, kaina tobelu kaina tosiekupuna; ");
INSERT INTO kij_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","gala taitala tobali, kaina togei, ");
INSERT INTO kij_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","gala taitala tokubula, kaina taitala saina wala tokukupi sainela; gala taitala avai katoula omatala kaina owowola; kaina taitala bogwa eikivaisi kikiyatula. ");
INSERT INTO kij_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Gala taitala odalela Eroni Tolula isim kala golia ibodi bigabu kaula lulela baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Kidamwa taitala bikoma kaula baisa eivigakaisi lula baisa yeigu, kaula lulela kwebumaboma, deli kaula lulela makwaina saina kwebumaboma, ");
INSERT INTO kij_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","mitaga matauna isim kala golia, matauna gala ibodi bima katitaikinela taboda miyana yabumaboma kaina bivalapula okabogwabu lula. Matauna gala ibodi biyogwali vavagi makwaisina kwebumaboma paila yeigu goli Guyau e lavigaki makwaisina kwebumaboma.” ");
INSERT INTO kij_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Baisa makawala avaka Mosese eiluki Eroni, deli litula, deli goli komwaidosi mina Isireli. ");
INSERT INTO kij_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","biluki Eroni deli litula kawala, “Yokomi gala ibodi bukuyomsilaisi yagagu igibumaboma, mapaila ibodi bukukwabomaisi makwaisina semakavi kwebumaboma deli mi kamaiaba avaka mina Isireli leikabomaisi baisa yeigu. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Kidamwa availa metoya odalemi, igau wala topupagatu, e bimaga katitaikinela makwaina semakavi kwebumaboma avaka mina Isireli leikabomaisi baisa yeigu, matauna gala avai tuta tuvaila biwotetila metoya okabogwabu lula. Karaiwaga makwaina paila tuta baisa deli tubwa tuta oluvi. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Kidamwa availa metoya Eroni dalela biyosi kagwaiguya kaina pokesa matauna gala ibodi bikoma makwaina lula kwebumaboma, tatoula wala matauna bimigileu, e kidamwa taitala tolula bikabikoni avai vavagi kwepupagatu, matauna bogwa eiyogwali titoulela, makawala tomata kaina la sopi bibusimakava, ");
INSERT INTO kij_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kaina ikabikoni natana mauna napupagatu, kaina taitala tomota topupagatu. ");
INSERT INTO kij_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Kidamwa taitala tolula biyogwali titoulela, matauna bisisu wala topupagatu kaukwau bila ibugiki, deli matauna gala ibodi bikoma avai vavagi metoya lula kwebumaboma tatoula wala bikakaya bikugwa. ");
INSERT INTO kij_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Avai tuta kalasia bisalili matauna bogwa bimigileu, e matauna ibodi bikam lula kwebumaboma, paila metoya lula baisa tolula kʹasi eibubanaisi. ");
INSERT INTO kij_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Matauna gala ibodi bikoma avai mauna vilionela minana eikaligimakava kaina mauna nagigasisi eikamataisi. Paila kidamwa bikoma bogwa biyogwali titoulela. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Tolula komwaidona ibodi bikabikuwolaisi karaiwaga makwaina lasaiki, mitaga kidamwa gala, matausina bogwa leisulasi e bikaligasi, paila matausina bogwa eikoulovaisi ulo karaiwaga kwebumaboma. Yeigu goli Guyau e yeigu lavigaki matausina mina bumaboma. ");
INSERT INTO kij_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Tolula wala deli litusia ibodi bikomasi lula makwaina kwebumaboma, gala tomotamakava ibodi bikomasi deli goli gala avai tomota tolula eivauli kaina taitala la topaisewa. ");
INSERT INTO kij_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mitaga kidamwa taitala tolula la ula matauna eigimloki ola mani titoulela kaina eivilulaisi ola bwala, ibodi bikam kaula baisa tolula kasi vilavila. ");
INSERT INTO kij_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kidamwa taitala tolula latula vivila bivaiya taitala gala tolula, minana gala ibodi bikoma makwaisina lula kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mitaga minana eivaipaka leikwabuya gala iunai gugwadi e ikaimilavau ola bwala tamala iyamati ibodi bikoma kaula baisa tamala eitakuni metoya tolula wotitalela. Tolula wala deli litusia ibodi bikomasi kaula baisa. ");
INSERT INTO kij_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Kidamwa availa matauna gala tolula litusia biyopolasi wala bikoma lula makwaina kwebumaboma matauna ibodi bimipuvau baisa tolula makawala kala bidubadu lula makwaina, deli bisaila odabala tuvaila katumkulovala. ");
INSERT INTO kij_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Tolula matauna gala ibodi biyogwali makwaisina lula kwebumaboma; ");
INSERT INTO kij_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","metoya bitugwalaisi avai tomotamakava bikam kaula makwaisina, baisa biyomituli kala pakula deli kala mipuki tau matauna. Yeigu goli Guyau e yeigu lavigaki lula makwaisina kwebumaboma.” ");
INSERT INTO kij_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","biluki Eroni deli litula deli goli komwaidosi mina Isireli karaiwaga makwaisina. Ka, kidamwa taitala guma Isireli kaina taitala togilagala eisisu olopola Isireli bimai lula kwegubugabu paila bikibuboti la biga katotila kaina la semakavi wala metoya ola tagwala, ibodi mauna minana gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Kidamwa Yaubada bikabwaili, ibodi bimaiyaisi namwala gala isim kala nebaneba. ");
INSERT INTO kij_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Mitaga kidamwa bukutugwalaisi natana mauna minana isim kala nebaneba, Guyau gala bikabwaili minana. ");
INSERT INTO kij_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","E kidamwa availa bimai kalubaila lulela baisa Guyau paila bikibuboti la biga katotila kaina la semakavi metoya ola tagwala wala mauna minana gala isim kala nebaneba, kidamwa magisi Guyau bikabwaili. ");
INSERT INTO kij_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Gala bukusemakavaisi baisa Guyau avai mauna minana nakau, kaina napem, kaina isim kala kapwaila, kaina napokesa, napwasa kaina nakasikuni. Gala bukugabwaisi avai mauna makawala minasina okabogwabu lula paila kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","E paila mi semakavi metoya avaka omi tagwala ibodi bukutugwalaisi avai mauna minana naikieki kaina isim kala gimabubula, mitaga minana Guyau gala bikabwaili paila biga katotila. ");
INSERT INTO kij_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Gala bukusemakaiyaisi baisa Guyau avai mauna minana kikiyatula bogwa eikatumkumkwaisi, leiteyasi, kaina leikatubwauwaisi, kaina leikapitunaisi. Karaiwaga makwaina gala isusukwaimi omi valu. ");
INSERT INTO kij_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Gala bukuvigakaisi natana mauna paila kaula lulela minana taitala togilagala leisakaimi, paila mauna makawala minasina nakakatoula deli Yaubada gala bikabwaili minana. ");
INSERT INTO kij_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","27","Kidamwa natana bulumakau, kaina sipi, kaina gota biuni latula, gala ibodi bukukwatulakaiyaisi bim ituwoli, bisisu wala deli inala biboda kwailima kwaiyu yam. Mitaga avai tuta bipeula wowola minana bogwa bibudoki paila kaula lulela. ");
INSERT INTO kij_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Gala ibodi bukusemakaiyaisi natana bulumakau deli latula, kaina sipi deli latula kaina gota deli latula yam makwaina wala. ");
INSERT INTO kij_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Avai tuta bukumaiyaisi nokagutoki lulela baisa Guyau, kuvagaisi makawala kami karaiwaga e igagabila Guyau bikabwailimi; ");
INSERT INTO kij_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","yam makwaina wala bukukomasi bukuvinakwaisi e gala bikalayuwela. ");
INSERT INTO kij_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","E Guyau ikaibiga kawala, “Kukwabikuwolaisi ulo karaiwaga; yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","E gala bukuyomsilaisi yagagu igibumaboma; komwaidomi mina Isireli ibodi bukuninatalasi baisa yeigu, e bukukwabomaimi titoulemi. Yeigu goli Guyau e bavigakaimi mina bumaboma; ");
INSERT INTO kij_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","yeigu goli lavisunupuloiyaimi metoya Itipita mwada bukuvigakaigusi mi Yaubada. Yeigu goli Guyau.” ");
INSERT INTO kij_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","E Guyau isaiki Mosese karaiwaga ");
INSERT INTO kij_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","paila tapwaroru pakala, tutala mina Isireli bisigugulasi paila bitapwarorusi. ");
INSERT INTO kij_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Bogwa kuyosisi kwailima kwaitala yam paila mi tuta bukuvagaisi avaka mi paisewa. Mitaga kululuwaisi yam makwaina kwailimala kwaiyuwela, baisa Sabate yamla vaiwasi. E wa yam makwaina gala bukupaisewasi, mitaga bukusigugulasi paila tapwaroru. Paila sabate makwaiwena Guyau la yam, ambaisa ambaisa goli lokusisikaisi. ");
INSERT INTO kij_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Baisa bukukwamitulaisi la tuta paila paka makwaisina avaka makateki balukwaimi. ");
INSERT INTO kij_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Paila Luvapela Pakala, bukusigugulasi paila bukukwamiabaisi Guyau. Bukuvitouulasi tutala tubukona minana kala vitouula taitu, yamla kweluwotala kwaivasila otutala kalasia bisalili. ");
INSERT INTO kij_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Paila Beredi Gala Deli Kala Yisi Pakala bukuvitouulasi wa yam kweluwotala kwailimala. E kwailima kwaiyu yam gala ibodi bukukwamsi beredi avaka eivagaisi deli kala yisi. ");
INSERT INTO kij_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","E okala vitouula yam makwaisina igau bukusigugulasi paila bukutapwarorusi, e gala wala availa baisa yokomi bivagi avai paisewa. ");
INSERT INTO kij_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Kusemakavaisi kaula kala lula baisa Guyau paila kwailima kwaiyu yam makwaisina. Metoya baisa kwailima kwaiyuwela yam kusigugulasi tuvaila paila bukutapwarorusi. Taga gala wala avai paisewa bukuvagaisi wa yam makwaina. ");
INSERT INTO kij_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Igau avai tuta bukusuvisi mapilana valu avaka Guyau bisakaimi, e bukutayoyuwasi mi witi, ikugwa bukukwauwaisi luvatala mi witi bukulauwaisi baisa mi tolula. ");
INSERT INTO kij_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","E matauna bitabubula baisa Guyau makawala bivigaki kwedabala mi lula baisa Guyau, e mwada Guyau bogwa bikabwailimi. Igau avai tuta Sabate biwokuva e tolula bitabubula mi lula makwaina. ");
INSERT INTO kij_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","E wa yam makwaina okutabubulaisi witi kala semakavi, e makawala goli bukugabwaisi lula kwegubugabu metoya natana sipi namwala kala taitu kwaitala wala e gala isim kala kapwaila. ");
INSERT INTO kij_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Wa tuta makwaina deli bukululasi kaula lulela. Kukwauwaisi kapoyu pwarawa e kukwenevigolaisi bulamila olibe paila lula makwaina. Vavagi makwaina maiinela simasimina kala lula mwada biyomwasali Guyau. E deli goli bukutabubulaisi yatala lukwavala waini. ");
INSERT INTO kij_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Gala bukukwambogwasi witi, kaina geyata kaina gubugabu, kainaga beredi kwegubugabu. Mitaga ikugwa bukutabubulaisi makwaisina lula baisa Guyau. Baisa makawala kami karaiwaga baisa tubumia komwaidosi kidamwa bukukwabikuwolaisi paila tuta baisa deli goli tuta bima. ");
INSERT INTO kij_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Paila Tayoyuwa Pakala tutala, bukuvitouula kakalawa metoya Sabate makwaina lokutabubulaisi witi baisa Guyau. Sabate makwaina eiwokuva, e metoya yam makwaina oluvi bukukwalawasi kwailima kwaiyu wiki. ");
INSERT INTO kij_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","E avai tuta makwaina Sabate kwailima kwaiyuwela eiwokuva, e wa yam makwaina kweluwolimala goli, bukuvigivauwaisi mi semakavi witi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","E kwaitala kaukweda ibodi bimai kwaiyu beredi baisa Guyau paila kala katukila. E kwaitala kwaitala makwaisina beredi bukusailisi kapoyu pwarawa deli bukukwepupolaisi yisi, e bukumaiyaisi baisa Guyau paila mi tabubula lulela kwaimatala witi kala tayoyuwa. ");
INSERT INTO kij_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","E deli beredi komwaidosi mina Isireli bimaiyaisi nalima nayu sipi kwaitala wala kasi taitu, e natana bulumakau, e deli nayu gota. Ibodi wala komwaidosi minasina gala isim kasi kapwaila. E komwaidona bigabwaisi lula baisa Guyau, e bisegulikaisi wala bali deli waini kala lula. E vavagi makwaisina maiinela bogwa biyomwasali Guyau. ");
INSERT INTO kij_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Tuvaila bukutugwalaisi natana gota namwala paila mitugaga lulela e deli nayu sipi nammwala kwaitala wala kasi taitu paila kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","E tolula bisaiki beredi deli nayu sipi nammwala bivigaki Guyau kala katukila paila wala tolula kʹasi. E komwaidona lula makwaisina kwebumaboma wala. ");
INSERT INTO kij_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Wa yam makwaina gala kwaitala paisewa bukuvagaisi makawala paisewala yam yam, mitaga bukusigugulasi wala paila bukutapwarorusi. E dalemi ibodi bikabikuwolaisi karaiwaga makwaisina tuta komwaidona deli tuta igau bima, ambaisa ambaisa goli lokusisikaisi. ");
INSERT INTO kij_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Avai tuta bukutayoyuwasi mi bagula, gala bukuteyasi witi otukulumwalela mi bagula, kaina gala kukukweiitasi bukubobwaisi pusiganela witi avaka bogwa kuligaiwaisi. Mitaga kuligaiwaisi wala makaisina paila tonamakava deli goli togilagala. Guyau matauna wala mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","E tubukonela nalima nayuwela, yamla kala vitouula, kuvigakaisi yam makwaina kwaiveka yamla vaiwasi. E bukumaisi gulitinidesi paila tapwaroru avai tuta tauya bitigilulu. ");
INSERT INTO kij_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Bukusakaisi kaula paila lula baisa Guyau, e gala bukuvagaisi kwaitala mi paisewa titoulemi yam makwaina. ");
INSERT INTO kij_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","27","Tubukonela nalima nayuwela yamla kweluwotala e makwaina yam bukuvagaisi tapwaroru makwaina paila tomota si mitugaga kala ligaiwa. Makwaina yam gala bukukwamsi e kumaisi gulitinidesi paila tapwaroru deli kaula lulela bukusakaisi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Gala bukupaisewasi yam makwaina, paila bogwa inagaisi yam makwaina bivagaisi makawala kidikedala mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Avai tomota kidamwa bikoma avai kaula makwaina yam, matauna gala bukudokaisi Yaubada la tomota. ");
INSERT INTO kij_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Deli kidamwa availa bipaisewa yam makwaina e Guyau titoulela bikatumati. ");
INSERT INTO kij_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Makwaina karaiwaga bilokaia komwaidosi tubumia ambaisa ambaisa eisisikaisi. ");
INSERT INTO kij_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","E tubukona minana kwailima kwaivasila yam kalasia ola salili e bila bibodi kweluwotalela yam kalasia ola salili kukwabomaisi paila yamla vaiwasi, e tuvaila gala avaka bukukomasi. ");
INSERT INTO kij_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Avai tuta bukupakasi Buliyoyova Pakala bukuvitouulasi nalima nayuwela tubukona yamla kweluwotala kwailimala e bisaitaula wala bila kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","E yam makwaina kala vitouula bukumaisi gulitinidesi paila tapwaroru, deli gala kwaitala avaka mi paisewa bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Yam kwaitala kwaitala paila makwaisina kwailima kwaiyu yam bukumaiyaisi kaula lulela. Wa yam kwailima kwaitolula bukumaisi gulitinidesi e tuvaila bukutapwarorusi, e deli bukumaiyaisi kaula lulela. Paila yam makwaina yamla tapwaroru, deli gala avaka mi paisewa bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(Makwaisina tapwaroru pakala baisa makawala bukukwamiabaisi Guyau. Bukumaisi gulitinidesi bukutapwarorusi, deli bukutabubulasi kaula lulela, gubugabu lulela, witi lulela, mitugaga kala ligaiwa lulela, deli waini lulela, makawala kidikedala paila paka makwaisina yam kwaitala kwaitala. ");
INSERT INTO kij_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Makwaisina paka bukukwalumgulikaisi makwaisina mi Sabate, deli makwaisina lula bukukwalumgulikaisi mi lula paila yam kwaitala, mi lula paila biga katotila, e mi semakavi avaka lokusisakaisi Guyau.) ");
INSERT INTO kij_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Avai tuta bogwa okutaiyauwaisi mi buyagu, bukukwalalimasi bukukwalayusi bukuvagaisi paka makwaina Buliyoyova Pakala. Bukuvitouulasi yam kweluwotala kwailimala tubukona nalima nayuwela. Yam makwaina kala vitouula bukuvagaisi yam kwaiveka wala paila yamla vaiwasi. ");
INSERT INTO kij_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Wa yam makwaina bukukwauwaisi kwaivila wala kaiuwasi mi kai, makwaisina saina bwainigaga, deli bukukwauwaisi sisila pulopola, deli sisila kai isim yekwesila bidubadu, e bukuvitoulaisi kwaitala pakala tapwaroru paila kala taimamila Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kukwalalimasi kukwalayusi baisa bukupakapakasi wala. Karaiwaga makwaisina ibodi tubumia bikabikaulasi tuta komwaidona deli igau tuta bima. ");
INSERT INTO kij_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Biboda kwailima kwaiyu yam komwaidosi mina Isireli bisisuaisi obuliyoyova, ");
INSERT INTO kij_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","e igau tubumia binikolaisi kidamwa Guyau eivigaki mina Isireli isisuaisi obuliyoyova avai tuta eivisunupuloi matausina metoya mapilana Itipita. Matauna goli Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","E baisa makawala Mosese isaiki karaiwaga makwaisina baisa mina Isireli kidamwa bikabikuwolaisi kidikedala makwaisina tapwaroru pakala, paila kala taimamila Guyau. ");
INSERT INTO kij_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","biluki mina Isireli karaiwaga makwaisina. Ka, ibodi bukumaiyaisi olibe bulamila baisa kala gigisa saina bwainigaga paila kaitapa makaisina olumoulela Buliyoyova, e igagabila kaitapa bikakatasi wala tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Koyavi kwaitala kwaitala Eroni ibodi bivakanoti makaisina e bikakatasi wala biyamki omatala Guyau opapala miyana taboda eitabodaisi Kabutu Didawogela, makwaina eitotu olumoulela matabudona Bomikikila Sainela. Karaiwaga makwaina ibodi bikabikuwolaisi paila tuta baisa deli tubwa tuta oluvi. ");
INSERT INTO kij_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","E Eroni ibodi biyamati kaitapa makaisina eitotusi osi kabototu eibubulaisi metoya goulawokuva wala, deli ibodi bivakawoli makaisina bikakatasi wala tuta komwaidona omatala Guyau. ");
INSERT INTO kij_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Kukwau pwarawa kala vakaila makawala kapoluwotala kapoyu, e kugabu beredi kala bawa kweluwotala kwaiyu. ");
INSERT INTO kij_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Oluvi kukwasi kasayu, kwailima kwaitala kasatala kwailima kwaitala kasayuwela, odabala tebeli, makwaina leibubulokaisi metoya goulawokuva wala, makwaina goli eitotu omatala Guyau. ");
INSERT INTO kij_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","E kukwau sitana bulami maiina simasimina e kukwatugiaki makwaisina beredi komwaidona, bivigaki kabotuvitusila paila kaula lulela makwaina komwaidona wala bogwa leisakaisi Guyau, kaimapula beredi makwaisina. ");
INSERT INTO kij_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","E tuta baisa deli tubwa tuta oluvi, Sabate kwaitala kwaitala, ibodi bisisailisi beredi omatala Guyau. Baisa mina Isireli kasi gulogula ibodi biuvagaisi tubwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Beredi baisa Eroni deli dalela kasi vilavila, e matausina ibodi bikomasi matabudona bomikikila, paila makwaina kaula lulela saina kwebumaboma leisakaisi Guyau, e tolulaga kʹasi. ");
INSERT INTO kij_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Ka, taitala tau tamala guma Itipita e inala vilela Isireli, minana yagala Selomiti minana Dibiri latula odalela Dani. E olumoulela kabosikaiwa tau matauna ikominimanisi sola taitala guma Isireli. E olopola si kominimani matauna ikadubali Yaubada, mapaila ivakolaisi iuyokaisi Mosese, ");
INSERT INTO kij_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","e ikatupipaisi matauna e itulotulasi Guyau biluki matausina avaka bivigakaisi matauna. ");
INSERT INTO kij_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Kuvisunupuloiyaisi matauna metoya omi kabosikaiwa. E availa availa eilagaisi eibigatona ibodi bisailasi yumasi odabala paila bikamokwitaisi matauna bogwa leisula, oluvi tomota komwaidona ibodi bikatumataisi matauna odakuna. ");
INSERT INTO kij_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","E kuluki mina Isireli kidamwa availa bikadubali Yaubada matauna ibodi bilumkoli mapula la sula, ");
INSERT INTO kij_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","e bukukwatumataisi matauna. Kidamwa taitala guma Isireli kaina taitala togilagala olopola Isireli bikadubali Guyau, tomota komwaidona ibodi bikatumataisi matauna. ");
INSERT INTO kij_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Kidamwa availa bikatumati tomota ibodi bukukwatumataisi matauna, ");
INSERT INTO kij_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","e availa bikatumati sola la mauna, matauna ibodi bisaiki sola natana mapula minana. E vidubalela karaiwaga makwaina momova kaimapula momova wala. ");
INSERT INTO kij_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Kidamwa availa bivisilagi sola, e avaka leivigaki sola ibodi bivigakaisi matauna makawala. ");
INSERT INTO kij_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Kidamwa bikatuuwoli kaitala totuwanela sola, ibodi bikatuuwolaisi kaitala totuwanela; kidamwa availa bikatupwesi kwaitala matala sola, ibodi bikatupwesaisi kwaitala matala matauna; kidamwa bikatummolu kaitala kudula sola, ibodi bikatummolusi kaitala kudula matauna. Avaka wala bivigaki baisa taitala tomota, ibodi bivigakaisi matauna makawala. ");
INSERT INTO kij_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kidamwa bikatumati natana sola la mauna ibodi bisaiki sola natana kaimapula, mitaga kidamwa availa bikatumati sola, ibodi wala bikatumataisi matauna. ");
INSERT INTO kij_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Karaiwaga makwaina kami karaiwaga mina Isireli, deli goli togilagala eisisuaisi deli yokomi, paila yeigu goli Guyau mi Yaubada.” ");
INSERT INTO kij_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Avai tuta Mosese eivenoku bigatona baisa mina Isireli, matausina ivisunupuloiyaisi tau matauna metoya osi kabosikaiwa e ilauwaisi ikatumataisi. Baisa makawala mina Isireli ivagaisi avaka Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Metoya wa Koya Sinai Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","deli ikaraiwogi matauna biluki mina Isireli karaiwaga makwaisina. Ka, avai tuta bukuviloubusisi valu mapilana Guyau bisakaimi, iboda bukukwamiabaisi Guyau, e tutala bukusakailasi kwailima kwaiyuwela taitu, gala bukubigulaisi pwaipwayela valu mapilana. ");
INSERT INTO kij_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Taitu kwailima kwaiyuwela olumoulela yokomi ibodi bukusopusi mi bagula, bukukwatupomasi mi waini matamsina, deli bukutitapelasi avaka kabinaila mi bagula. ");
INSERT INTO kij_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mitaga taitu kwailima kwaiyuwela, taitu makwaina kwemwaidona pwaipwaia bivaiwasi, paila taitu makwaina Guyau bogwa leikabomi. Gala bukusopusi kaina bukutayoyuwasi. ");
INSERT INTO kij_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Deli gala bukutaiyauwaisi avai kaula bisusinamakavasi wala. Gala kusapwaisi, deli gala bukukwaveyasi kaiuwala eitammakava e eibukulamakava, matamsina gala kukwatupomasi, paila taitu makwaina kwemwaidona wala pwaipwaia bivaiwasi wala. ");
INSERT INTO kij_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ilagoli gala bukubigulaisi pwaipwaia mapilana olopola taitu makwaina, mitaga kʹami bibobwabula wala bukukwamkwamsi, mi ula, mi topaisewa, togilagala deli lokusisuaisi, ");
INSERT INTO kij_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","mi bulutuvalu, deli nabubolodila omi kwabila. Vavagi kwaitala kwaitala bikabinaisi olopola taitu makwaina paila ibodi bukukomasi. ");
INSERT INTO kij_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Kukwalau taitu kwailima kwaiyu paila sivalima sivayu, baisa kala bawa biboda kwailuwovasi kwailima kwaivasi. ");
INSERT INTO kij_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","E wa taitu makwaina tubukona nalima nayuwela e oyamla kweluwotalela, yam makwaina Yamla Vasosu kukwaraiwogi taitala tau biyuvi tauya ambaisa ambaisa olopola valu viloumwaidona. ");
INSERT INTO kij_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","E baisa bivigaki yokomi bukukwabomaisi kweluwolimala taitu, makwaina bivigaki taitula ninabwaila bukukwamitulaisi baisa tomotala valu mapilana. Wa taitu makwaina olopola komwaidona guguwa makwaisina lokugimolaisi metoya baisa semia, ibodi bukukwaimilivauwaisi baisa matausina kaina baisa dalesi, e kidamwa availa leigimolaisi leivigakaisi ula, ibodi bikaimilavau bilokaia veyala. ");
INSERT INTO kij_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Yokomi gala bukusopusi kaina bukutaiyauwaisi avai kaula leisususinasi titoulesi, kaina bukuyoulogusi kaiuwasi mi waini matamsina gala kukwatupomasi. ");
INSERT INTO kij_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Taitu makwaina kwemwaidona kwebumaboma; mitaga yokomi kʹami bukukwamkwamsi avaka wala metoya kabinaila mi bagula. ");
INSERT INTO kij_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Wa taitu makwaina olopola komwaidona guguwa makwaisina lokugimolaisi semia si guguwa, ibodi bukukwaimilivauwaisi baisa toliguguwa. ");
INSERT INTO kij_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","E kidamwa taitala som wala guma Isireli bipokala pwaipwaia baisa yoku, kaina yoku bukupokala pwaipwaia baisa matauna, gala bukuvigakaisi pokala vavagi katudewa. ");
INSERT INTO kij_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","E kwaivila taitu bukubigulaisi pwaipwaia makwaina, ibodi bukukibubotaisi mapula pwaipwaia makwaina avaka bibudoki taitu makwaisina oluviga bukusakailasi Taitula Ninabwaila. ");
INSERT INTO kij_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kidamwa saina bidubadu taitu bukubigulaisi, ibodi bukuyovigasaisi pokala, mitaga kidamwa kwaivila wala taitu bukubigulaisi, e pokala bibusi, paila avaka kala bidubadu m pokala lokuyomadi pwaipwaia makwaina kabinaila bikaimapu makawala wala m pokala kala bidubadu. ");
INSERT INTO kij_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Gala bukuwabu som, mitaga ibodi bukukukoli Guyau m Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Kukwabikuwolaisi komwaidona Guyau la karaiwaga avaka leikaraiwogaimi. E igagabila bukusibwabwailasi ovalu mapilana. ");
INSERT INTO kij_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","E pwaipwaia wala bisaiki kaiuwasi kawailuwa komwaidona, e mi valu bimalia kaula, deli bukusisuaisi bwaina. ");
INSERT INTO kij_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Mitaga kaina availa bilivala kawala, “Gala tabigubagulasi deli gala takakavaisi, e avakaga bitakomasi olopola taitu kwailima kwaiyuwela?” ");
INSERT INTO kij_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mitaga Guyau wala bivigaki kala luvabwaila taitu kwailima kwaitalela e kaula bimiliaki wala, bibodi kwaiyu taitu bukukwamkwamsi. ");
INSERT INTO kij_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Avaka lokutaiyauwaisi olopola kwailima kwaitalela taitu, yokomi bukukwamkwamsi wala tatoula bila ibudoki kwailima kwaiyuwela otutala biguvau, e kaula baisa bikatutuwoli wala bila otayoyuwa. ");
INSERT INTO kij_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Gala bukutagwalasi mi pwaipwaia bimipuvauwaisi, paila gala mi pwaipwaia tatoumi, baisa Yaubada la vavagi, yokomi makawala togilagala tolivalu eitugwalaisi paila bibigulaisi. ");
INSERT INTO kij_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Avai tuta pwaipwaia makwaina bogwa eipokalaisi, e tolipwaipwaia magila bitayumali, ibodi biyomitali avai vavagi paila tayumalela pwaipwaia makwaina. ");
INSERT INTO kij_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Kidamwa taitala guma Isireli bitonamakava, e bikominimanaisi wala bigimoli la pwaipwaia baisa sala, e veyala wala tatoula ibodi bitayumalaisi makwaina. ");
INSERT INTO kij_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kidamwa taitala tau gala veyala paila bitayumalaisi pwaipwaia makwaina, desi wala bitotu tatoula wala bibani veiguwa e bila itayumila titoulela. ");
INSERT INTO kij_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Matauna ibodi bisaiki sola veiguwa kala bidubadu avaka bibudoki paila taitu makwaisina gala ibiguli oluviga bisakaila Taitula Ninabwaila, e pwaipwaia makwaina bila oyamala. ");
INSERT INTO kij_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mitaga kidamwa matauna la veiguwa gala ibawa paila bitayumali la pwaipwaia, pwaipwaia makwaina bisisu wala oyamala sola, tatoula wala bibudoki Taitula Ninabwaila. Taitu makwaina gala tayumalela pwaipwaia makwaina, bikaimali wala bisaiki tolipwaipwaia. ");
INSERT INTO kij_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kidamwa taitala tau la bwala olopola kwaitala valu isim kalila, e sala bigimolaisi makwaina, matauna ibodi wala bigimolivau la bwala olopola kwematala taitu, e avai yam wala sola leigimolaisi la bwala, matauna ibodi bikibuboti paila bigimolivau la bwala. ");
INSERT INTO kij_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mitaga kidamwa gala bigimolivau olopola taitu makwaina, matauna bogwa eikivau, e bwala makwaina bivagi la bwala wala tatoula matauna togimwala deli goli dalela; avai tuta bibudoki Taitula Ninabwaila matauna gala bikaimilivau bisaiki tolibwala. ");
INSERT INTO kij_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Mitaga bwala olopola valu makwaisina gala isim kalisi kala kaiyumila makawala baleku, avai tuta bibudoki Taitula Ninabwaila matauna ibodi wala bikaimilivau la bwala. ");
INSERT INTO kij_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Mitaga mina Libai wala osi valu kasimwaleta, avai tuta wala magisi bitayumilasi si guguwa avaka sesia leigimolaisi. ");
INSERT INTO kij_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Kidamwa taitala guma Libai olopola kwaitala valu makwaisina la bwala sala bigimolaisi, e gala bigimolivau, makwaina ibodi bikaimilivauwaisi bisakaisi tolibwala otutala bibudoki Taitula Ninabwaila, paila bwala makwaisina mina Libai eisisikaisi osi valu makwaisina si vavagi tatousi oluwalaisi mina Isireli komwaidona. ");
INSERT INTO kij_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Mitaga kwabila opapasi mavilousina mina Libai si valu gala bigimolaisi makubilasina, paila baisa si vavagi tatousi kwekanigaga. ");
INSERT INTO kij_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Kidamwa taitala som wala guma Isireli la mitakwabu e m mitakwabu binamakava, e la kaukweda biyatai, ibodi bukupilasi matauna makawala lokuvigaki baisa taitala m topaisewa e gagabila matauna bisisu wala deli yoku. ");
INSERT INTO kij_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Gala bukunanamsa bisakaim sitana katumkulovala mapula lokupilasi, mitaga ibodi bukukukoli Yaubada e bukutagwala wala matauna som guma Isireli bisisu otalim. ");
INSERT INTO kij_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Avaka m pilasi lokusisaiki matauna, gala bukunanamsa bisakaim sitana katumkulovala mapula lokupilasi, deli bigimwala kaula baisa yoku e gala bukuvamweni mapula. ");
INSERT INTO kij_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Baisa goli Guyau mi Yaubada la karaiwaga makawala, matauna goli leivisunupuloiyaimi metoya mapilana Itipita leimaiyaimi e bisakaimi mi valu Kenani e bukuvigakaisi matauna mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Kidamwa taitala som wala guma Isireli la mitakwabu e m mitakwabu saina binamakava e bitugwali titoulela bukugimoli bukuvigaki m ula, gala bukuvigaki bipaisewa makawala si paisewa ula. ");
INSERT INTO kij_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Matauna ibodi bukuvauli makawala taitala mi topaisewa lokugimloki wa mani, e matauna biwotitalaim tatoula wala bibudoki Taitula Ninabwaila. ");
INSERT INTO kij_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","E taitu makwaina matauna deli litula ibodi bisilavaimsi bikaimilavausi baisa veisia biyosasi kasi bigukeya, bigukeyasi tubusia. ");
INSERT INTO kij_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Matausina mina Isireli Guyau wala la ula, e ivisunupuloi metoya mapilana Itipita, mapaila gala gagabila availa bigimoli matausina bivigaki ula. ");
INSERT INTO kij_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Gala bukuyomiyuyaisi matausina mitaga ibodi bukukukolaisi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Kidamwa magimi availa bukusiaimwaisi mi ula, ibodi bukugimwalasi ituwoli tomota metoya valu mavilousina otalimi. ");
INSERT INTO kij_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Deli yokomi ibodi bukugimwalasi togilagala litusia matausina deli lokusigolaisi. Gugwadi leiunaisi omi valu magudisina mi tomota, ");
INSERT INTO kij_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","e gagabila magudisina bukuvigaki kasi bigukeya litumia, e ibodi matausina ula biwotitalaisi litumia osi tuta tomomova komwaidona. Mitaga yokomi gala ibodi bukuyomiyuyaisi taitala sami wala guma Isireli. ");
INSERT INTO kij_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Kidamwa taitala togilagala deli lokusigolaisi bikobaluluva la kaisisu, e taitalaga guma Isireli binamakava e bitugwali titoulela mapaila matauna togilagala bigimoli matauna bivigaki la ula kaina taitala wala togilagala veyala bigimwala. ");
INSERT INTO kij_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Kidamwa bogwa leigimolaisi matauna, mitaga ibodi wala bigimlivauwaisi. Kaina tuwala kaina bodala bigimlovau, ");
INSERT INTO kij_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","e kaina kadala kaina taitala wala tuwala kaina bodala inala ituwoli, kaina taitala wala vaiyola titoulela ibodi bigimlivau matauna. Mitaga kidamwa matauna bogwa eibodi la guguwa eititakuni ibodi wala bimapu titoulela paila kala taneku. ");
INSERT INTO kij_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Matauna deli availa matauna leigimoli matoulela, ibodi bikalawaisi kwaivila taitu kala bawa tuta matutona leigimolaisi e bilaga ibudoki Taitula Ninabwaila e ibodi bivitobwaisi avaka mapula tau matauna kala taneku, bivatobusi makawala avaka mipusi leimapwaisi si topaisewa. ");
INSERT INTO kij_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","52","Metoya guguwa magulona paila mapula kala taneku matauna ibodi biyosi sitana paila taitu makwaisina kesala e bila bibudoki Taitula Ninabwaila, ");
INSERT INTO kij_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","makawala wala eivigakaisi si topaisewa taitu kwaitala kwaitala. Kala tokaraiwaga gala ibodi biyomiyuyu matauna. ");
INSERT INTO kij_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Kidamwa nanamsa makwaisina bikasai e gala bitagwalasi bitanekwaisi matauna, ibodi wala matauna deli litula bitanekwaisi oTaitula Ninabwaila. ");
INSERT INTO kij_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Gala availa ibodi biyosikikiti taitala guma Isireli bisivagasi la ula, paila mina Isireli Guyau wala la ula titoulela. Matauna goli leivisunupuloi metoya mapilana Itipita; matauna wala Guyau si Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","E Guyau ikaibiga kawala, “Taga bukububulasi tokolu kaina bukuyoudulaisi kaikobula avai vavagi, kaina kokola bukuyoudulaisi metoya dakuna, kaina dakuna bukulaleiyasi tokolu paila mi kabotaimamila. Yeigu wala Guyau mi Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ibodi bukuuvagaisi wala kami paka pakala tapwaroru ambaisa lokuvigakaisi mi kabotaimamila, e bukukwamiabaigusi. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Kidamwa bukubokulaisi ulo karaiwaga deli bukukwabikuwolaisi, ");
INSERT INTO kij_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","yeigu basakaimi kuna okala kweluva mokwita, e igagabila bagula bikabinaisi deli kai biuwasi. ");
INSERT INTO kij_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Yokomi bukuluvabwailasi e bukuyayosasi wala tayoyuwa tatoula bikalapula mi waini kaiuwala, e bukukwavaisi wala mi waini tatoula wala bikalapula biguvau. E mi valu bimiliaki kaula, deli bukusisuaisi bwaina. ");
INSERT INTO kij_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Yeigu bakoli mi valu, avai tuta bukumasisi gala bukukokolasi metoya avai vavagi. E yeigu bamtuli mauna nagigasisi omi valu, deli gala tuvaila kabilia. ");
INSERT INTO kij_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Yokomi bukutomgwagasi odubasi kami tilaula; ");
INSERT INTO kij_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","kidamwa kamitailima wala, mitaga ibodi wala bukukwalisauwaisi lakatutala, e kidamwa lakatutala kami bawa mitaga ibodi wala bukukwalisauwaisi boda budoveka kasi bawa 10,000. ");
INSERT INTO kij_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Yeigu bamitukwaiyaimi e bavigakaimi bukuunaisi litumia bidubadu; yeigu bavagi avaka ulo biga katotila baisa yokomi. ");
INSERT INTO kij_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mi valu bimiliaki kaula bukukwamkwamsi wala bila kwaivau taitu bukulupisauwaisi kesala taituvala bukuligaimwaisi pailaga bukukwaidodigasi kalavau. ");
INSERT INTO kij_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","E yeigu basisu ogu Buliyoyova Kwebumaboma e deli bitasisuaisi, yeigu gala avai tuta batotubulokaimi. ");
INSERT INTO kij_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Yeigu deli yokomi tuta komwaidona; yeigu mi Yaubada, e yokomi ulo tomota. ");
INSERT INTO kij_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Yeigu Guyau mi Yaubada, yeigu goli lavisunupuloiyaimi metoya mapilana Itipita e gala tuvaila bivigakaimi ula. Yeigu akodidaimi la peula kabokaraiwaga makwaina leikatupipaimi, e atanekwaimi deli mi mwasawa lokuuvatumwanasi.” ");
INSERT INTO kij_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","E Guyau ikaibiga kawala, “Kidamwa gala bukukwabikuwolaisi ulo karaiwaga, yeigu bamipukwaimi. ");
INSERT INTO kij_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Kidamwa bukupakaisi gala bukukwabikuwolaisi ulo karaiwaga avaka lakaraiwogaimi e bukukodidaimisi kabutu makwaina lavagi deli yokomi, ");
INSERT INTO kij_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","yeigu bamipukwaimi. Yeigu bamipukwaimi kami lelia kwekanuvagasi deli kuluyuviyavi makwaina bivigaki bukukwausi, deli bigweimilaimi wala bikimataimi. Yokomi bukusapwaisi mi bagula mitaga gala wala avaka kala bwaina bukubanaisi, paila kami tilaula bimaisi biyoulisi mi valu deli bidakwaisi mi bagula. ");
INSERT INTO kij_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Yeigu batotubulokaimi e kami tilaula bikalisauwaimi, e matausina leivigakaisi mina kukolosi yokomi bikaraiwogaimi; e kami kokola wala bibulukukolaimi bukusakaulasi ilagoli gala wala availa ibokavilaimi. ");
INSERT INTO kij_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Kidamwa vavagi komwaidona makwaisina bikaloubusisi mitaga gala wala bukukwabikuwolaigusi, yeigu bakatumkulovi kami mipuki sivalima sivayu tuvaila. ");
INSERT INTO kij_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Yeigu bakodidaimi avaka kala kasai ninami; yeigu bavapakali labuma gala kuna, e mi bagula viloupakala e bikasai pwaipwaia makawala dakuna kala kasai. ");
INSERT INTO kij_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mi pwaitukula komwaidona gala wala dimlela, paila mi bagula gala bikabinaisi deli kami kawailuwa makaisina gala biuwasi. ");
INSERT INTO kij_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Kidamwa yokomi kusetuwolaisi bukukoulovaigusi wala e bukupakaisi gala bukukwabikuwolaigusi, yeigu tuvaila wala bakatumkulovi kami mipuki sivalima sivayu tuvaila. ");
INSERT INTO kij_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","E bawitali mauna nagigasisi oluwalaimi, minasina bikamataisi litumia, deli bikomasi mi bulutuvalu e gala bukubawasi bukusisuaisi omi valu, e mi keda makadasina komwaidona kadaukuwokuva wala. ");
INSERT INTO kij_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Kidamwa mipuki makwaisina bisusunapulasi wala biwokuva, mitaga gala wala bukunakaigalaigusi bukuseudeikisi wala kowolova, ");
INSERT INTO kij_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","e yeigu bagibuluwaimi e bamipukwaimi sivalima sivayu tuvaila kala mwau bikalisau masivasina lavigibogwi. ");
INSERT INTO kij_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Yeigu bamai kabilia baisa yokomi e bamipukwaimi paila lokukodidaimisi da kabutusi, e kidamwa bukukougugulaimi gulitinidesi omi valu mwada bukukwalasi, yeigu bawitali lelia kwekanigaga baisa yokomi, e kami tilaula bikatupipaimi. ");
INSERT INTO kij_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","E yeigu bavigaki biyatai mi valu, e naluwotala vivila avaka si katuboyuva ibodi bikumlasi kumlotala wala kumkumla. Minasina biyeyasi e bikatupataimi bukukomasi, e avai tuta bukukomasi bukuvinakwaisi, mitaga gala wala bitubwa lupomi, kami molu wala. ");
INSERT INTO kij_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Kidamwa mipuki makwaisina komwaidona bisusunapulasi wala biwokuva mitaga gala wala bukunakaigalaigusi, bukuseudeikisi wala kowolova, ");
INSERT INTO kij_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","e deli ulo gibuluwa batovilakaimi e bakatumkulovi kami mipuki sivalima sivayu tuvaila kala mwau bikalisau masivasina lavigibogwi. ");
INSERT INTO kij_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Molusaula wala biyogagaimi e litumia wala titoulemi bukukomasi. ");
INSERT INTO kij_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","E odabala koya makwaisina lokuvigakaisi mi kabotapwaroru yeigu bakatudidaimi, deli bakodidaimi mi kabogwabu lula makwaisina lokugibugabusi lula maiina simasimina. E avai tuta bukukwaligasi uwomi balavi bukuwokaiasi deli tokolu minasina lokuvigakaisi mi yaubada minasina goli eikapusibogwasi opwaipwaia. E bavigakaimi saina kabommosila sainela ");
INSERT INTO kij_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","yeigu bakodidaimi mi valu deli bakatupilaku ambaisa lokuvigakaisi mi kabotapwaroru, deli bapaiki gala bakabwaili mi lula. ");
INSERT INTO kij_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Yeigu bakodidaimi wala mi valu biwokuva e tilaula matausina biyoulisi mi valu saina bitutu uwosi paila kala kodadaimi. ");
INSERT INTO kij_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","E yeigu bamai kabilia baisa yokomi e babutugigaiyaimi bukubutusi bukulosi osi valu gilagala. Yokomi mi valu biviloububu, deli bitotusi wala kwedidadaimi. ");
INSERT INTO kij_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","E taitu kwaitala kwaitala mi pwaipwaia biuvaiwasi wala gala availa bibiguli; bitotu biviloububu wala biuvaiwasi, yokomiga bukusisuaisi wala okatupipi osi valu kami tilaula. ");
INSERT INTO kij_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“E availa availa yokomi bukusisuaisi okatupipi, yeigu bavigakaimi bukukokolasi sainela, e yagila biyuvisau yatala wala yogilumwamwaisa bisilumgola e bukusisakaulasiga. Mi sakaula bukuvigakaisi makawala wala leibokavilaimi okabilia. Tilaula gala bibokavilaimi mitaga bukukwapusimakavasi wala. ");
INSERT INTO kij_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Gala availa bibokavilaimi mitaga bukusilibeibeusi wala bukuwaisi kukwanuwaidalasi, e yokomi gala wala ibodaimi bukukwabiliasi deli kami tilaula. ");
INSERT INTO kij_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Yokomi bukukwaligasi okatupipi, e bukukwanawaisi wala osi valu kami tilaula. ");
INSERT INTO kij_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","E kesalaga yokomi tommomova lokusisuaisi osi valu kami tilaula, bukusisuaisi wala kaligami bukukwaligasi paila mi mitugaga deli tubumia si mitugaga. ");
INSERT INTO kij_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Mitaga kidamwa tubumia tuta oluvi bikamitulaisi si mitugaga deli tubusia si mitugaga, matausina goli eikoulovaigusi deli eikosomapwaigusi, ");
INSERT INTO kij_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","deli eiyogibuluwaigusi eivigakaigusi atotubuloki matausina e lavigaki tilaula leikatupipaisi eilauwaisi osi valu. Mitaga avai tuta tubumia tuta oluvi bimanum ninasi deli bininavilasi metoya osi mitugaga deli si kowolova, ");
INSERT INTO kij_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","e yeigu baluwai avaka ulo kabutu baisa Yekobe, Aisake, deli Eberaam, e bavigivau avaka ulo biga katotila paila basaiki ulo tomota valu mapilana. ");
INSERT INTO kij_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mitaga bikugwa valu mapilana vilouwokuva wala bitotu gala tomotala, gagabila pwaipwaia bitomakava wala biuvaiwasi, e matausina ibodi bilumkolaisi mmayuyu paila ikoulovaisi ulo karaiwaga avaka lakaraiwogi. ");
INSERT INTO kij_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ilagoli tuta baisa kidamwa matausina leisisuaisi osi valu kasi tilaula, yeigu gala wala basilavi kaina bakatudoum matausina. Paila katudoum baisa bivigaki ulo kabutu bogwa bitotina deli matausina, e yeigu goli Guyau si Yaubada. ");
INSERT INTO kij_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Yeigu bavigivau ulo kabutu lavagi deli tubumia omitibogwa tuta makwaina layomitali ulo peula baisa boda komwaidona metoya lavisunupuloi ulo tomota metoya mapilana Itipita, kidamwa yeigu Guyau yeigula si Yaubada.” ");
INSERT INTO kij_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Karaiwaga makwaisina komwaidona Guyau leisaiki Mosese metoya wa Koya Sinai paila kasi karaiwaga mina Isireli. ");
INSERT INTO kij_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Guyau isaiki Mosese ");
INSERT INTO kij_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","karaiwaga makwaisina paila kasi karaiwaga mina Isireli. Ka, kidamwa availa bogwa eikatilavi titoulela paila Guyau e bikamokwiti la biga katotila mwau, tau matauna ibodi bitugwali mani kaimapula, e matauna bogwa bibani kala taneku, ");
INSERT INTO kij_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","7","makawala avaka tokaraiwaga einagaisi. - tommoya, kasi taitu kweluwoyu bila kweluwolima kweluwotala. bisakaisi kweluwolima siliba - nunumoya. bisakaisi kweluwotolu siliba - tauwau, kasi taitu kwailima bila kweluwoyu. bisakaisi kweluwoyu siliba - kapugopugula. bisakaisi kweluwotala siliba. - weiwaya tauwau kasi taitu kwaivasi eibusiga watanawa. bisakaisi kwailima siliba - weiwaya vivila. bisakaisi kwaitolu siliba - tommoyabogwa kasi taitu eikalisau kweluwolima kweluwotala. bisakaisi kweluwotala kwailima siliba - nunumoyabogwa kasi taitu eikalisau kweluwolima kweluwotala. bisakaisi kweluwotala siliba. ");
INSERT INTO kij_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kidamwa taitala tau bogwa eikatotila mitaga saina tonamakava paila bimapu avaka tokaraiwaga leinagaisi, matauna ibodi biuyokaisi tolula, e tolula bivabu sitana, avaka ibodi tau matauna bimapu. ");
INSERT INTO kij_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Mitaga kidamwa availa eilivala biga katotila mwada bisaiki natana mauna bivigaki lula baisa Guyau, e bobwailila kwaitala kwaitala makwaisina leisakaisi Guyau kwebumaboma wala; ");
INSERT INTO kij_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","e tau matauna eikatotila gala ibodi bivitomapu natana kaimapula minana. Kidamwa bivagi makawala nayu wala minasina bilokaiasi Guyau la vavagi. ");
INSERT INTO kij_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Mitaga kidamwa biga katotila makwaina paila natana mauna e saina napupagatu minana gala ibudoki lula paila Guyau, tau matauna ibodi biuyoki tolula mauna minana. ");
INSERT INTO kij_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","E kidamwa mauna minana naminabwaita kaina namigaga tolula ibodi binagi avaka mapula, e mapu makwaina bogwa goli mapula minana. ");
INSERT INTO kij_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","E kidamwa tau matauna magila bigimolivau minana mauna, matauna ibodi bisaiki mapula avaka tolula leinagi deli goli bisaila odabala tuvaila katumkulovala. ");
INSERT INTO kij_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kidamwa availa bitugwali la bwala bivigaki kwebumaboma baisa Guyau, e kidamwa bwala makwaina kala kaliai bwaina kaina gaga tolula wala ibodi binagi avaka mapula. ");
INSERT INTO kij_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mitaga kidamwa tau matauna magila bigimolivau bwala makwaina matauna ibodi bisaiki avaka mapula tolula leinagi deli bisaila odabala tuvaila katumkulovala. ");
INSERT INTO kij_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Kidamwa taitala tau bitugwali sitana la pwaipwaia bivigaki kwebumaboma baisa Guyau, e kwaivila yagogu bisapwaisi okowolukuvala baleku makwaina ibodi bikibubotaisi mapula makawala, kweluwotala siliba paila mapula vasi peta yagogu. ");
INSERT INTO kij_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kidamwa Taitula Ninabwaila makateki biwokuva e saina nanakwa bitugwali la pwaipwaia bivigaki kwebumaboma baisa Guyau, e mapula la pwaipwaia bisisu makawala komwaidona avaka tokaraiwaga leinagi. ");
INSERT INTO kij_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mitaga kidamwa Taitula Ninabwaila bogwa leiwokuva e kwaivilaga taitu tuvaila, e oluvi goli bitugwali la pwaipwaia bivigaki kwebumaboma baisa Guyau, tolula ibodi binagi kwaivila siliba mapula avaka bibudoki taitu makwaisina kesala oluviga bisakaila Taitula Ninabwaila, e tolula wala titoulela bivabu mapula. ");
INSERT INTO kij_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Mitaga kidamwa matauna bogwa leitugwali la pwaipwaia bivigaki kwebumaboma baisa Guyau mitaga tuta oluvi magila bigimolivau, matauna ibodi bisaiki mapula avaka tolula einagi, e bisaila odabala tuvaila katumkulovala. ");
INSERT INTO kij_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","E kidamwa tau matauna gala ikugwa bikaimali pwaipwaia makwaina baisa Guyau, e bikasali wala bisaiki tuwoli tomota mwada bigimolaisi, matauna bogwa leikivau gala gagabila bigimolivau pwaipwaia makwaina. ");
INSERT INTO kij_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","E avai tuta Taitula Ninabwaila bibudoki, pwaipwaia makwaina bivigaki Guyau wala la pwaipwaia tatoula; e makwaina tolula si pwaipwaia. ");
INSERT INTO kij_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kidamwa taitala tau bogwa leigimoli kwaitala pwaipwaia e oluvi bitugwali baisa Guyau bivigaki kwebumaboma, ");
INSERT INTO kij_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","tolula ibodi binagi kwaivila siliba mapula avaka bibudoki taitu makwaisina kesala oluviga bisakaila Taitula Ninabwaila, e tau matauna ibodi bimapu pwaipwaia makwaina wa yam makwaina wala; e mani magulona Guyau la vavagi. ");
INSERT INTO kij_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Avai tuta bibudoki Taitula Ninabwaila pwaipwaia makwaina bikeiita bilokaia tolipwaipwaia tobubogwa kaina dalela. ");
INSERT INTO kij_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Guguwa komwaidona mapusi ibodi bivitobwaisi makawala tokaraiwaga leikaraiwogaisi. ");
INSERT INTO kij_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Mauna si kuluta minasina Guyau wala la vavagi, mapaila gala availa ibodi bikabomi baisa Guyau bivigaki la semakavi metoya ola tagwala. Bulumakau nagwadi, lam, kaina gota nagwadi minasina Guyau wala la vavagi, ");
INSERT INTO kij_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","mitaga mauna minasina napupagatu si kuluta ibodi tomota bigimolivauwaisi metoya omapula wala avaka leinigibogwaisi deli bisailasi odabala tuvaila katumkulovala. Kidamwa gala bigimolivauwaisi minana, ibodi tomota ituwoli bigimolaisi, e mapula makawala avaka leisibogwaisi. ");
INSERT INTO kij_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Kidamwa avai vavagi bogwa lokukwatilavaisi lokusakaisi Guyau la vavagi tatoula, gala ibodi availa bigimolivau biyosi la vavagi kaina bisaiki sala bigimolaisi, kaina goli tomota, kaina mauna, kaina pwaipwaia. Paila vavagi makwaina bogwa leikabomi leisaiki Guyau la vavagi tatoula. ");
INSERT INTO kij_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Kidamwa lokukwatilavaisi taitala tomota lokusakaisi Guyau la vavagi tatoula, gala gagabila bukugimolivauwaisi matauna. Ibodi wala bikatumataisi. ");
INSERT INTO kij_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Tala metoya luwotala avaka kabinaila mi bagula, baisa Guyau wala la vavagi. ");
INSERT INTO kij_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Mitaga kidamwa taitala tau magila bigimolivau sitana kʹala, matauna ibodi bigimwala avaka mapula bogwa leinagibogwisi deli bisaila odabala tuvaila katumkulovala. ");
INSERT INTO kij_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Komwaidona mi yawa mayuwosina natana metoya naluwotala bukusakaisi Guyau la vavagi. Avai tuta bukukwalauwaisi kasi bawa minasina, minana naluwotalela bukusakaisi Guyau la vavagi. ");
INSERT INTO kij_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","E tolimauna gala ibodi bikili ituwoli naminabwaita, ituwoli namigigaga, biseguliki wala e gagabila tutala okakalawa ibodi wala namigigaga binagaisi, deli gala ibodi biwouya nanola. Mitaga kidamwa biwouya nanola idoki bikatumapu bisaiki naminabwaita bikaimaliga namigaga, e nayu wala bitowaisi Guyau la vavagi e gala gagabila bigimolivau bikaimali. ");
INSERT INTO kij_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Karaiwaga makwaisina Guyau leisaiki Mosese metoya wa Koya Sinai paila kasi karaiwaga mina Isireli.");
INSERT INTO kij_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Avai tuta mina Isireli bogwa eisilavaisi Itipita, e olopola taitu kwaiyuwela tubukona nayuwela oyamla kwematala, e olopola Guyau la Buliyoyova mapilana Sinai Viloupakala Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Yoku som Eroni ibodi bukusonukulaisi mina Isireli avaka kasi bawa metoya dala dilatala dilatala. Kuginaisi yagasi tauwau ");
INSERT INTO kij_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","kasi taitu ibodi kweluwoyu kaina ikalisau kweluwoyu, matausina kala tau kabilia. ");
INSERT INTO kij_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Kulukwaisi tokugwala dala dilatala dilatala bipilasaimi.” ");
INSERT INTO kij_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","16","Baisa makawala yagasi matausina tokugwala dala madilasina, matausina goli leinagaisi metoya oluwalaisi mina Isireli paila paisewa makwaina. Dala Tokugwala Rubeni Elisura Simioni Selumieli Yuda Nasoni Isaka Netaneli Sebuloni Eliabi Epereim Elisama Manasa Gamalieli Beniamina Abidani Dani Aiesa Asera Pagieli Gada Eliasapi Napitalai Aira. ");
INSERT INTO kij_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","Avai tuta bogwa eibudoki tubukona nayuwela oyamla kwematala, Mosese, Eroni, deli matausina tailuwotala taiyu kasi topilasi, ikogugulaisi komwaidona tomota e isonukulaisi kasi bawa taitala taitala metoya odalela titoulela. E matausina kasi taitu kweluwoyu kaina ikalisau kweluwoyu, iginaisi yagasi deli ikalawaisi avaka kasi bawa, ");
INSERT INTO kij_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","makawala avaka Guyau eikaraiwogi bivagaisi. E baisa mapilana Sinai Viloupakala, Mosese bogwa eisonukuli tomota avaka kasi bawa. ");
INSERT INTO kij_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","E tauwau matausina kasi taitu kweluwoyu kaina ikalisau kweluwoyu, matausina kala tau kabilia, igini yagasi taitala taitala metoya odalela titoulela, ivitouulasi baisa Rubeni dalela, matauna Yekobe la kuluta. Kasi bawa baisa makawala. Dala Kasi bawa Rubeni 46,500 Simioni 59,300 Gada 45,650 Yuda 74,600 Isaka 54,400 Sebuloni 57,400 Epereim 40,500 Manasa 32,200 Beniamina 35,400 Dani 62,700 Asera 41,500 Napitalai 53,400 Kasi bawa iboda. 603, 550 ");
INSERT INTO kij_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","E mina Libai wala gala ikalumgugolaisi toyo dala madilasina, ");
INSERT INTO kij_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","paila uula Guyau bogwa eiluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Avai tuta bukusonukula paila tauwau matausina ibudoki kala tau kabilia gala bukukwalumgugoli dalela Libai. ");
INSERT INTO kij_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mitaga kaimapula bukukwaraiwogi matausina biyamataisi ulo Buliyoyova toyo guguwala komwaidona. Matausina tokeula ulo Buliyoyova toyo goli guguwala komwaidona, e biuwotetilasi olumoulela makwaina, deli bibudaisi si kabosikaiwa bitavinaisi wala bitapataisi ulo Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","E avai tuta wala bukugalasi metoya makatupona lokusisikaisi, ibodi mina Libai bikatupilakwaisi ulo Buliyoyova e ambaisa wala bukubudaisi mi kabosikaiwa tuvaila, e matausina wala bikaliivauwaisi ulo Buliyoyova. E komwaidonaga dala, availa idoki bila katitaikinaila ulo Buliyoyova ibodi bukukwatumataisi wala. ");
INSERT INTO kij_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","E komwaidonaga mina Isireli bibudaisi si kabosikaiwa odalesi wala titoulesi, taitala taitala matausina bisisu wala odalela titoulela ouula si dala doyala. ");
INSERT INTO kij_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mitaga mina Libai wala bibudaisi si kabosikaiwa otalila ulo Buliyoyova paila biyamataisi makwaina, e taga availa bima katitaikinela makwaina mwada biyomituli ulo gibuluwa e bayomiyuyu mina Isireli komwaidona.” ");
INSERT INTO kij_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Mapaila komwaidona mina Isireli ivagaisi vavagi komwaidona avaka Guyau eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","E baisa makawala karaiwaga Guyau eisaiki Mosese sola Eroni. ");
INSERT INTO kij_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Avai tuta mina Isireli bibudaisi si kabosikaiwa, taitala taitala matausina ibodi bikaliai la buliyoyova otalila la boda doyala deli dalela doyala. Kabosikaiwa komwaidona bitavinaisi bitapataisi Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","E mapilana opilibomatu, matausina bisisuaisi deli doya miyana Yuda la boda. Ibodi bibudaisi si kabosikaiwa osi boda wala titoulesi deli wala kasi tokaraiwaga. Ka, baisa makawala kala takasa. Dala Tokugwa Kasi Bawa Yuda Nasoni 74,600 Isaka Netaneli 54,400 Sebuloni Eliabi 57,400 Kasi bawa iboda. 186, 400 E Yuda la boda bivakumgwasi. ");
INSERT INTO kij_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","E opilibolimila matausina bisisuaisi deli doya miyana Rubeni la boda, ibodi bibudaisi si kabosikaiwa osi boda wala titoulesi deli kasi tokaraiwaga. Ka, baisa makawala kala takasa. Dala Tokugwa Kasi Bawa Rubeni Elisura 46,500 Simioni Selumieli 59,300 Gada Eliasapi 45,650 Kasi bawa iboda. 151, 450. E Rubeni la boda bilouyasi otuboulosi Yuda la boda. ");
INSERT INTO kij_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","E mabudosina budoyu bikugwasi, deli budoyu oluvi. E mina Libai bivawalasi bikikaitakewasi Guyau la Buliyoyova. E metoya osi loula budotala budotala mabudosina biloulasi osi boda wala titoulesi makawala wala kala leilai kabasi osi tuta vaiwasi osi kabosikaiwa, budotala budotala okasi kasa wala bililoulasi deli si doya. ");
INSERT INTO kij_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","E mapilana opilikwaibwaga matausina bisisuaisi otalila doya miyana Epereim la boda ibodi bibudaisi si kabosikaiwa osi boda wala titoulesi deli kasi tokaraiwaga. Ka, baisa makawala kala takasa. Dala Tokugwa Kasi Bawa Epereim Elisama 40,500 Manasa Gamalieli 32,200 Beniamina Abidani 35,400 Kasi bawa iboda. 108, 100. Otubolousi Yuda sola Rubeni si boda, Epereim la boda bilouyasi otubolousi. ");
INSERT INTO kij_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","E opiliyavata, matausina bisisuaisi otalila doya miyana Dani la boda, iboda bibudaisi si kabosikaiwa osi boda wala titoulesi deli wala kasi tokaraiwaga. Ka, baisa makawala kala takasa. Dala Tokugwa Kasi Bawa Dani Aiesa 62,700 Asera Pagieli 41,500 Napitalai Aira 53,400 { Kasi bawa iboda.} 157, 600. E Dani la boda bivabodasinim. ");
INSERT INTO kij_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","E komwaidona mina Isireli mabudosina ikalumgugolaisi kasi bawa 603, 550. ");
INSERT INTO kij_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Makawala Guyau bogwa eiluki Mosese, mina Libai wala gala ikalumgugolaisi deli dala madilasina. ");
INSERT INTO kij_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Mapaila mina Isireli ivagaisi komwaidona avaka Guyau eikaraiwogi Mosese. Matausina ibudaisi si kabosikaiwa budotala budotala otalila wala si doya titoulesi deli osi loula ililoulasi osi boda wala titoulesi. ");
INSERT INTO kij_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Baisa makawala Eroni sola Mosese veyala, tuta matutona Guyau eibigitoni Mosese wa Koya Sinai. ");
INSERT INTO kij_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Eroni litula kasitaivasi, kuluta Nadaba, eisakaili Abiu, Eleasa, e kasusu Itama. ");
INSERT INTO kij_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Matausina bogwa eikiwotaisi deli eikabomaisi bivagisi tolula, ");
INSERT INTO kij_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","mitaga Nadaba sola Abiu ikaligasi paila uula Guyau kala lula leigabwaisi metoya kovamakava wala mapilana Sinai Viloupakala. Matausina gala pesisi, mapaila igau wala Eroni tomomova Eleasa sola Itama eiwotetilasi tolula wotitalela. ");
INSERT INTO kij_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ka kuluki Libai dalela bimaisi e kusaiki kasi karaiwaga biwotetilasi deli Eroni tolula. ");
INSERT INTO kij_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","E avai wotetila isisu paila ulo Buliyoyova wotitalela matausina bivagaisi, deli biwotitalaisi tolula deli goli tomota komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Tuvaila matausina biyamataisi komwaidona guguwala ulo Buliyoyova, deli biwotetilasi paila komwaidona mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","E si wotetilaga mokwita biwotitalaisi Eroni deli litula. ");
INSERT INTO kij_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ka, yoku ibodi bukunagi Eroni deli litula biwotitalaisi tolula wotitalela, e kidamwa availa bivigikoni mwada bivagi wotetila makwaina bukukwatumataisi wala.” ");
INSERT INTO kij_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Ka, tuta baisa mina Libai ulo vavagi tatougu. Avai tuta lakatumati mina Itipita si kuluta tauwau komwaidona, e wa tuta matutona yeigu akatupali mina Isireli si kuluta tauwau komwaidona deli goli si mauna kuluta, komwaidona wala ulo vavagi. Mitaga ka, mwada mina Isireli si kuluta tauwau lakatupali paila yeigu, taga kaimapula mina Libai bogwa lavigaki ulo vavagi tatougu. Yeigu goli Guyau. ");
INSERT INTO kij_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","E mapilana Sinai Viloupakala Guyau ikaraiwogi Mosese bisonukuli mina Libai avaka kasi bawa metoya odalesi deli veisia titoulesi, ");
INSERT INTO kij_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","bikalau komwaidona tauwau kasi tubukona natana kaina ikalisau, ");
INSERT INTO kij_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","e Mosese ivagi makawala. ");
INSERT INTO kij_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","20","Libai litula taitolu. Gerisoni, Kowati, Merari, matausina tubusia paila dala madalasina isim yagasi makawala baisa. Gerisoni litula taiyu, Libini sola Simei; Kowati litula taivasi. Amram, Isa, Ebironi, Usieli; Merari litula taiyu. Mali sola Msi. Matausina tubusia paila dala madalasina yagasi makawala baisa. ");
INSERT INTO kij_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Dala Gerisoni budoyu goli, Libini veyala, Simei veyala. ");
INSERT INTO kij_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","E komwaidona tauwau kasi tubukona natana kaina ikalisau eisonukulaisi kasi bawa iboda 7,500. ");
INSERT INTO kij_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Madalana ibudaisi si kabosikaiwa opilikwaibwaga osisunela Guyau la Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","dala madilana tomoyela Eliasapi matauna Laeli latula. ");
INSERT INTO kij_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Dala madalana si koni Buliyoyova kwemwaidona biyamataisi, katuvala miyasina yayu olumoulela deli okoukweda, e miyana tabodala paila kabosusuvi. ");
INSERT INTO kij_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","E miyasina tabodala leitapapaisi Buliyoyova kwemwaidona deli kabogwabu lula, e deli miyana paila tabodala kabosusuvi matabudona olumoulela. E komwaidona taboda miyasina matausina si koni paila biyamataisi. ");
INSERT INTO kij_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Dala Kowati isisu, Amram veyala, Isa veyala, Ebironi veyala deli Usieli veyala. ");
INSERT INTO kij_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","E komwaidona tauwau kasi tubukona natana kaina ikalisau eisonukulaisi kasi bawa iboda 8,600. ");
INSERT INTO kij_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Dala madalana ibudaisi si kabosikaiwa opilibolimila opapala Guyau la Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","e dala madalana tomoyela Elisapani matauna Usieli latula. ");
INSERT INTO kij_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Matausina si koni biyamataisi Kabutu Didawogala, tebeli, kaitapa la kabototu, makwaisina kabogwabu lula, deli guguwala komwaidona tolula leivigakaisi paila si wotetila olumoulela matabudona Bomikikila, deli miyana tabodala kabosusuvi matabudona Bomikikila Sainela. Komwaidona guguwa makwaisina matausina si koni paila biyamataisi. ");
INSERT INTO kij_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Dala Libai tomoyela Eleasa matauna Eroni tolula latula. Matauna ikaraiwogi availa availa matausina iwotetilasi olumoulela Guyau la Buliyoyova matabudona Bomikikila. ");
INSERT INTO kij_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Dala Merari budoyu, Mali sola Msi veisia, ");
INSERT INTO kij_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","e komwaidona tauwau kasi tubukona natana kaina ikalisau eisonukulaisi kasi bawa iboda 6,200. ");
INSERT INTO kij_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Dala madalana ibudaisi si kabosikaiwa opiliyavata opapala Guyau la Buliyoyova. Dala madalana tomoyela Surieli matauna Abiaili latula. ");
INSERT INTO kij_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Matausina einagaisi biyamataisi komwaidona youdulela Guyau la Buliyoyova, ketuwolela kokolela, ulilaguvala, deli goli youdulela komwaidona. Matausina si koni biyamataisi komwaidona guguwa makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Tuvaila biyamataisi kokolela, ulilaguvala, kenubilumala, deli yuwoyoulela taboda miyana eitavinaisi eitapataisi Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","E Mosese, Eroni deli litula komwaidosi wala ibudaisi si kabosikaiwa opilibomatu omatala Guyau la Buliyoyova. E komwaidona matausina si koni paila biwotetilasi olumoulela matabudona Bomikikila paila mina Isireli. E kidamwaga availa mwada bivigikoni wotetila makwaina, matauwena bikatumataisi. ");
INSERT INTO kij_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Baisa Guyau la karaiwaga makawala, Mosese isonukuli komwaidona mina Libai tauwau kasi tubukona natana kaina ikalisau, kasi bawa dala madalana iboda 22,000. ");
INSERT INTO kij_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","41","Guyau iluki Mosese kawala, “Komwaidona mina Isireli si kuluta tauwau matausina ulo vavagi. Mapaila kugini komwaidona yagasi mina Isireli kuluta tauwau, kasi tubukona natana kaina ikalisau. Mitaga kaimapusi mina Isireli si kuluta tauwau deli si mauna kuluta, mina Libai deli goli si mauna kuluta baisa bogwa ladoki ulo vavagi! Yeigu goli Guyau!” ");
INSERT INTO kij_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mapaila Mosese ikabikaula igini komwaidona yagasi mina Isireli si kuluta tauwau ");
INSERT INTO kij_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","natana kasi tubukona kaina ikalisau, e kasi bawa iboda 22,273. ");
INSERT INTO kij_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Tuvaila Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Tuta baisa kukwabomi mina Libai matausina ulo vavagi goli kaimapula mina Isireli si kuluta tauwau, deli kukwabomi mina Libai si mauna kuluta kaimapula mina Isireli si mauna kuluta. ");
INSERT INTO kij_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Omitibogwa mina Isireli si kuluta tauwau kasi bawa ikalisau mina Libai kasi bawa, kasi kakalawa matausina kesa iboda 273. Mauula ibodi yoku bukugimolivau matausina kesa. ");
INSERT INTO kij_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","E taitala taitala matausina bimapu paila titoulela kwailima siliba, makawala avaka kasi karaiwaga bimapusi, ");
INSERT INTO kij_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","e mani magulona kusaiki Eroni deli litula.” ");
INSERT INTO kij_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","E Mosese ivagi makawala, ikau ");
INSERT INTO kij_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","magulona 1,365 siliba ");
INSERT INTO kij_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","isaiki Eroni deli litula. ");
INSERT INTO kij_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","bisonukuli avaka kasi bawa mina Libai metoya dala Kowati, e odalesi wala titoulesi, ");
INSERT INTO kij_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","e deli bisonukuli komwaidona tauwau kasi taitu kweluwotolu bila itobu kweluwolima matausina goli mina katavatu paila biwotetilasi olumoulela Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Matausina si wotetila biwotetilasi deli guguwa makwaisina kwebumaboma sainela. ");
INSERT INTO kij_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Baisa makawala Guyau isaiki Mosese la karaiwaga. Avai tuta mi tuta bukugalasi, Eroni deli litula ibodi bisuvisi Guyau ola Buliyoyova e bilisaisi taboda miyana omatala Kabutu Didawogala e biyoulumasi Didawaga makwaina. ");
INSERT INTO kij_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Oluvi bikauwaisi yatala leiyoudulaisi metoya mauna kanuvinesi biyavaisi odabala makwaina, e karekwa burum biyavaisi odabala, e oluvi bikaluvisuyaisi kaitakewala makaisina. ");
INSERT INTO kij_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","E matausina ibodi biyavaisi yatala yaburum karekwa odabala tebeli, oluvi bisailisi kabomala beredi kwegubugabu makaisina leivigakaisi si lula baisa Guyau, kaboma makaisina paila lula maiina simasimina, semakavi kabomala deli miyasina lukwavala waini eivigakaisi lula. E ibodi tuta komwaidona beredi kwegubugabu bisisu wala odabala tebeli. ");
INSERT INTO kij_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","E oluvi bikauwaisi karekwa yabweyani biyoulumasi guguwa makwaisina, bikauwaisi yatala eiyoudulokaisi metoya mauna kanuvinesi biyavaisi odabala, e oluvi bikaluvisuyaisi kaitakewala makaisina. ");
INSERT INTO kij_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Tuvaila bikauwaisi karekwa yaburum bikapolaisi kaitapa deli kabototula, makaisina kailokaila, makaisina kabomala, deli komwaidona lukwavala olibe bulamila. ");
INSERT INTO kij_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","E matausina ibodi bikapoligolaisi makaina deli guguwala komwaidona metoya yatala leiyoudulokaisi mauna kanuvinesi e bisailisi odabala kebila makwaina paila bikatikewaisi. ");
INSERT INTO kij_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Tuvaila matausina biyavaisi yatala burum karekwa odabala kabogwabu lula makwaina goulawokuva wala, deli biyoulumasi makwaina metoya yatala leiyoudulokaisi metoya mauna kanuvinesi, e bikaluvisuyaisi katikewala. ");
INSERT INTO kij_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Deli bikauwaisi komwaidona guguwala makwaina metoya matabudona Bomikikila, e bikauwaisi yatala karekwa yaburum bikapolaisi makwaisina, biyavaisi odabala yatala eiyoudulokaisi metoya mauna kanuvinesi, e bisailisi odabala kebila makwaina paila bikatikewaisi. ");
INSERT INTO kij_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Bikatusouwaisi tubwagela lula owakau metoya kabogwabu lula makwaina e biyavaisiga yatala karekwa kala vau dairarugu odabala makwaina. ");
INSERT INTO kij_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Matausina bisailasi komwaidona guguwala odabala makwaina, kova kaisakaila, kaisusuwa, yova, kaboma, e biyavaisi yatala leiyoudulokaisi metoya mauna kanuvinesi odabala makwaina, oluvi bikaluvisuyaisi katikewala. ");
INSERT INTO kij_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Avai tuta wala mi tuta bukugalasi, Kowati dalela matausina kala tokeula guguwa makwaisina kwebumaboma, mitaga ikugwa Eroni deli litula bivinakwaisi kakapola makwaisina deli goli guguwala komwaidona. Kowati dalela gala wala bikabikonaisi guguwa makwaisina, kidamwa bikabikonaisi bikaligasi wala. Baisa Kowati dalela si koni ibodi bivagaisi avai tuta wala bukukwatupilakwaisi Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","E Eleasa matauna Eroni Tolula latula biyamati kwemwaidona Guyau la Buliyoyova, kaitapa kevakevala, lula maiina simasimina, kaula lulela, vaputuma bulamila, deli goli komwaidona guguwa olumoulela Guyau la Buliyoyova makwaisina eikabomaisi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","E Guyau iluki Mosese sola Eroni kawala, ");
INSERT INTO kij_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Gala bukutagwalasi dala Kowati ");
INSERT INTO kij_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","bimaisi katitaikinela guguwa makwaina saina bomikikila e taga biyomitulaisi kasi kaliga. Mwau makwaina kala silaboda, Eroni deli litula ibodi binagaisi taitala taitala la koni e bilukwaisi matauna avaka ibodi bikau. ");
INSERT INTO kij_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Mitaga kidamwa matausina Kowati dalela bisuvisi Guyau ola Buliyoyova mwada bigisaisi tolula bikikatubaiasasi guguwa makwaisina saina bomikikila paila bigalasi, e matausina bikaligasi wala.” ");
INSERT INTO kij_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","bisonukuli kasi bawa mina Libai matausina Gerisoni dalela metoya odalesi titoulesi, ");
INSERT INTO kij_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","e bigini yagasi tauwau matausina kasi taitu kweluwotolu e bila itobu kweluwolima matausina mina katavatu paila biwotetilasi olumoulela Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Matausina si koni tokawesi guguwa makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Buliyoyova katuvala miyana olopola deli miyana otoukweda, miyana odabala eiyoudulokaisi metoya mauna kanuvinesi, lulu tabodala, ");
INSERT INTO kij_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","taboda miyasina deli yuwoyoula paila tabodala Buliyoyova deli kabogwabu lula, tabodala miyasina metoya kabosusuvi deli goli komwaidona youdulela ibudoki paisewala deli guguwa makwaisina. Matausina ibodi bivagaisi si koni komwaidona paila guguwa makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Mosese sola Eroni ibodi bivakawolaisi Gerisoni dalela ibodi biuvagaisi komwaidona si wotetila deli bikatikewaisi komwaidona guguwa makwaisina Eroni deli litula einagaisi baisa matausina. ");
INSERT INTO kij_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Baisa makawala Gerisoni dalela si koni olopola Guyau la Buliyoyova; e avaka Itama matauna Eroni tolula latula biluki, matausina bivagaisi makawala. ");
INSERT INTO kij_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","E Guyau iluki Mosese bisonukuli avaka kasi bawa mina Libai metoya odalela Merari, e oveisia wala titoulesi; ");
INSERT INTO kij_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","e deli bisonukuli komwaidona tauwau kasi taitu kweluwotolu bila itobu kweluwolima matausina goli mina katavatu paila biwotetilasi olumoulela Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Matausina si koni tokawesi youdulela Guyau la Buliyoyova mabubosina pou, kokola, ulilaguva kenubilumala, yuwoyoulela, ");
INSERT INTO kij_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","deli goli komwaidona guguwala ibudoki kala kaliai makwaina. Taitala taitala la koni bikeula avai guguwa wala makwaisina leinagaisi paila matauna bikeula. ");
INSERT INTO kij_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Baisa makawala dala Merari si koni biwotetilasi olopola Guyau la Buliyoyova; e avaka Itama matauna Eroni tolula latula biluki matausina bivagaisi makawala. ");
INSERT INTO kij_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Makawala Guyau la karaiwaga, Mosese sola Eroni deli goli komwaidosi tokugwala Isireli isonukulaisi mina Libai kasi bawa madilasina dilatolu dala Kowati, dala Gerisoni, deli dala Merari. Matausina isonukulaisi metoya osi dala deli veisia wala titoulesi, e iginaisi komwaidona yagasi tauwau kasi taitu kweluwotolu e ila itobu kweluwolima, matausina ibudoki biwotetilasi olumoulela Guyau la Buliyoyova, kala takasa baisa makawala. Dala Kasi Bawa Kowati 2,750 Gerisoni 2,630 Merari 3,200 Kasi bawa iboda. 8,580. ");
INSERT INTO kij_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Makawala Guyau eikaraiwogi Mosese, matauna igini taitala taitala yagasi; e Mosese inagi taitala taitala matausina la koni paila biwotetila kaina bikeula guguwa makwaisina, makawala Guyau la karaiwaga. ");
INSERT INTO kij_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Kukwaraiwogi mina Isireli availa availa matausina tokagwaiguya kaina bititalagila uwosi deli komwaidosi matausina iyogwalaisi titoulesi metoya ikabikonasi uwosi tomata bisilavaisi metoya omi boda. ");
INSERT INTO kij_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Kuyabi komwaidosi matausina tomota topupagatu bisunapulasi metoya omi boda; e taga biyogwalaisi mi kabosikaiwa, paila baisa goli ulo kabosisu deli ulo tomota.” ");
INSERT INTO kij_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Mapaila mina Isireli ikabikaulasi iyabaisi komwaidosi matausina isim pikolela uwosi isunapulasi metoya osi kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Baisa makawala Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","paila kasi katuloluta mina Isireli. Kidamwa availa gala bikamiabi Guyau e bivagi avai pakula baisa availa; ");
INSERT INTO kij_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","matauna ibodi bikamituli la mitugaga deli avaka kala bidubadu la guguwa bikabilula baisa matauna leiyogagi deli bisaila odabala tuvaila katumkoluvala. ");
INSERT INTO kij_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Mitaga kidamwa tau matauna bogwa eikaliga deli gala veyala katitaikina paila biyosisi mapu makwaisina, ibodi wala baisa avaka eimapu bisakaisi Guyau paila tolula. Tuvaila mapu makwaina bisisu odabala minana sipi namwala bivigakaisi kala katumigileu tau matauna leivagi sula. ");
INSERT INTO kij_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Deli avai vavagi kwebumaboma makwaisina mina Isireli bisakaisi Guyau kala katukila e matauna wala tolula leisakaisi baisa la vavagi. ");
INSERT INTO kij_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Tolula taitala taitala ibodi bikeula la vavagi titoulela metoya avaka tomota si semakavi leisakaisi. ");
INSERT INTO kij_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","biluki mina Isireli kasi katuloluta. Ka, kaina kwaitala tuta bileiki makawala taitala tau bininali la kwava mwada gala ikamiabi matauna e minana iyogwali titoulela ikailasi. E mitaga la mwala gala bikamokwiti paila baisa, kaina la kwava ikikium - e gala wala availa igisaki matala bilivali; deli gala iyosisi minana ikikailasi. E kaina bileiki makawala la mwala bininali la kwava, mitaga minana gala ikailasi. ");
INSERT INTO kij_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Matauna ibodi bivakouli la kwava biuyoki tolula. Deli matauna bikau pwarawa kala vakaila makawala kapotala bikasewa, mitaga gala bitaguliki deli olibe bulamila kaina avai vavagi maiina simasimina, paila lula makwaina nanali lulela, bivigaki bikamokwiti deli biyomitali sula makwaina omilakatila. ");
INSERT INTO kij_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","E tolula ibodi bivakouli vivila minana bimai omatala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Matauna biligabu sitana sopi bumaboma bila kwelatala kulimoya, oluvi bikau sitana pwaipwaia metoya olumoulela Guyau la Buliyoyova bisewoya bila wa sopi olumoulela kulimoya makwelana bivigaki biyayana. ");
INSERT INTO kij_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Bikugwa tolula bikiyuvisi kulula vivila eiviri, e oluvi bisaila kaula lulela oyamala minana. E tolula matauna oyamala biyosi kulimoya makwelana leitavikoti sopi yayana paila bulubolata. ");
INSERT INTO kij_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Oluvi tolula bilivali biga mabigasina baisa vivila minana kawala. “Kidamwa mokwita gala kukwailasi e gala bukulumkoli mmayuyu metoya makwelana sopila bulubolata. ");
INSERT INTO kij_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mitaga kidamwa bogwa kukwailasi, ");
INSERT INTO kij_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","igagabila wala Guyau bivigakaim kabokakayuwa oluwalaisi m tomota. Matauna bivigaki wowom kwemwaidona bitilipanunu, deli lopom biulela. ");
INSERT INTO kij_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","E sopi baisa bisuki lopom e bivigaki biulela deli wowom kwemwaidona wala bitilipanunu.” E vivila minana bivitakauloki kawala, “E bogwa atagwala. Ibodi Guyau bivigaki makawala.” ");
INSERT INTO kij_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ikugwa tolula matauna bigini mabigasina bigala bulubolata bila wa pweipu, e oluvi biwinisau ginigini makwaina bila olumoulela kulumoya makwelana leitavikoti sopi yayana. ");
INSERT INTO kij_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","E igau oluvi tolula bisaiki vivila minana sopi baisa bimom, paila bivigaki bilumkoli mmayuyu makwaina, ");
INSERT INTO kij_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ikugwa tolula matauna bikau pwarawa lulela metoya oyamala vivila minana leiyosi e bikabomi baisa Guyau oluvi bisaili pwarawa baisa okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","E matauna biyeili yelitala pwarawa paila kabotuvatusi lulela, e bigabu okabogwabu lula. E kala vigimkovila tolula matauna bisaiki vivila minana sopi baisa bimom. ");
INSERT INTO kij_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kidamwa vivila minana mokwita leikailasi, sopi baisa biyomitali kala mmayuyu; lopola biulela deli wowola kwemwaidona wala bitilipanunu. E minana bivigakaisi kabokakayuwa oluwalaisi la tomota. ");
INSERT INTO kij_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mitaga kidamwa minana gala ikailasi, gala bibani kamwaga makwaina, ibodi wala biunai litula. ");
INSERT INTO kij_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","30","Baisa makawala karaiwaga makwaina gala tagigisi avai tuta kaina taitala biuliweli e bininali la kwava mwada ikailasi, vivila minana bilauwaisi omatala kabogwabu lula, e tolula ibodi bivagi karaiwaga makwaina. ");
INSERT INTO kij_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","E tau matauna gala wala isula, mitaga vivila minana, kidamwa mokwita eisula ibodi bilumkoli mmayuyu makwaina. ");
INSERT INTO kij_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","bikatululuti mina Isireli. Kidamwa avai tau kaina avai vila bikatilavi tatoula paila bimila guma Nasira e bikikili titoulela baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Matauna gala ibodi bimom waini deli goli sopi kepapeula. Tuvaila matauna gala ibodi bimom avai sopi ituwoli leivagaisi metoya waini kaiuwala kaina bikoma kwemmonogu kaina kwemmatutila kaiuwala waini. ");
INSERT INTO kij_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ola tuta komwaidona matauna guma Nasira wala, gala ibodi bikoma avai vavagi metoya otamla waini gala goli waitunela kaina bikamgoli deli kanuvinela kaiuwala waini. ");
INSERT INTO kij_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ola tuta komwaidona eikatotila matauna bivagi makawala mina Nasira kasi karaiwaga, matauna gala bikapituni kulula kaina bivaliu. Matauna bogwa eipikoli wowola paila eikatotila ola tuta komwaidona matauna eikabomi titoulela baisa Guyau, mapaila matauna ibodi bigugoli kulula deli kala gabula. ");
INSERT INTO kij_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","Kulula baisa kabotuvitusila paila eikabomi titoulela baisa Yaubada, mapaila bikikili titoulela gala bila katitaikina tomata, kaina goli tamala bikaliga, inala, bodala, tuwala, kaina luleta. ");
INSERT INTO kij_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ola tuta komwaidona matauna guma Nasira, matauna tobumaboma wala paila Guyau. ");
INSERT INTO kij_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Kidamwa taitala matausina mina Nasira kulula bogwa leikabomi, e biyogwaliga paila uula isipituki katitaikinela taitala tomota la kaliga kweyopolasi wala, matauna ibodi bitulotula biboda kwailima kwaiyu yam bibudoki oluvi biviliu kulula deli kala gabula; baisa bivigaki bogwa eimigileu. ");
INSERT INTO kij_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","E oyamla kwailima kwaitolula bibudoki matauna biuyoki tolula nayu bubuna kaina buneroro omatala Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Tolula ibodi bigubuki natana minasina paila mitugaga lulela e nayuwela paila lula kwegubugabu; bivigaki kala katumigileu tau matauna paila eikabikoni tomata. E yam makwaina wala matauna guma Nasira bikabomivau kulula, ");
INSERT INTO kij_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","deli bikikilivau la tuta matauna taitala guma Nasira. Guyau gala wala biluluwai la tuta omitibogwa matauna taitala guma Nasira, paila uula kulula bogwa leikabomi, mitaga iyogwali miyasina. E paila kaimapu lulela matauna biuyoki tolula natana lam kwaitala kala taitu. ");
INSERT INTO kij_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Kidamwa taitala guma Nasira bogwa leikamokwita la biga katotila mwau, ibodi matauna bivagi makawala. Matauna bila wa lulu Guyau ola Buliyoyova ");
INSERT INTO kij_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","deli bisemakavi baisa Guyau bisaiki natonu mauna gala kasi nebaneba, natana lam namwala kwaitala kala taitu paila bigubukwaisi lula kwegubugabu, natana lam navivila kwaitala kala taitu paila mitugaga lulela, e natana sipi namwala paila kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Tuvaila matauna bisaiki tala peta beredi kwegubugabu gala deli yisi. Makwaisina beredi leitagulikaisi pwarawa toyo olibe bulamila deli mapilasina pasikeda leikatugiakaisi odabala toyo olibe bulamila. Deli tuvaila bisaiki katumkulovala lula makwaisina kaula deli waini. ");
INSERT INTO kij_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","E tolula bisaiki komwaidona makwaisina baisa Guyau, e matauna bigabu mitugaga kala ligaiwa lulela deli lula kwegubugabu lulela. ");
INSERT INTO kij_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Minana sipi namwala bivigaki paila kalubaila lulela baisa Guyau deli petala beredi. Deli goli bisaiki makwaisina semakavi kaula toyo waini. ");
INSERT INTO kij_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","E wa lulu Guyau ola Buliyoyova matauna guma Nasira biviliu kulula e bisaili wa kova makovana ambaisa kalubaila lulela leigigabu bigibugoli deli miyasina. ");
INSERT INTO kij_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Oluvi avai tuta sipi namwala yamanela bogwa eisulumenu, tolula biyeiya e biseguliki deli kwaitala beredi, pilatala pasikeda metoya wa peta e bisaili oyamala matauna guma Nasira. ");
INSERT INTO kij_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Oluvi tolula bikau makwaisina metoya oyamala matauna guma Nasira, e bivigaki gulotala wala Guyau kala katukila; lula makwaisina semakavi kwebumaboma paila wala tolula. Deli goli seila, toyo kaikenala mauna minana, vavagi makwaisina baisa tolula wala la vavagi, makawala goli karaiwaga. Igau wotetila makwaina biwokuva, matauna guma Nasira gagabila bimom waini. ");
INSERT INTO kij_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Baisa makawala kasi karaiwaga matausina eidokaisi mina Nasira, mitaga kidamwa taitala guma Nasira bikatotila bivagi avaka la biga katotila e bikatumkuloviga avaka tuvaila, matauna ibodi wala bivagi komwaidona makawala la biga katotila. ");
INSERT INTO kij_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","kidamwa biluki Eroni deli litula bibigibwailisi mina Isireli metoya wa biga mabigasina. ");
INSERT INTO kij_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Ibodi Guyau bimitukwaiyaimi e deli biyamataimi. ");
INSERT INTO kij_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ibodi Guyau bikamiabaimi e binokapisaimi. ");
INSERT INTO kij_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ibodi Guyau biyobobonaimi, e bitalaguva lupomi. ");
INSERT INTO kij_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","E Guyau ikaibiga, kawala, “Kidamwa bikavitagaisi yagagu e makawala bivigaki bikabwailisi mina Isireli, e yeigu bogwa goli bakabwaili matausina.” ");
INSERT INTO kij_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Oyamla makwaina Mosese eivigimkulovi kala kaliai Guyau la Buliyoyova, ivaputumi deli ikabomi makwaina deli goli guguwala komwaidona, deli kabogwabu lula toyo guguwala komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Oluvi gweguyala dala madalasina matausina kasi tokugwa mina Isireli, matausina goli leinagaisi paila bipilasisi sonukula makwaina, ");
INSERT INTO kij_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","imaiyaisi si semakavi baisa Guyau kala bawa makawala. kailima kaitala waga kaibibiu deli naluwotala nayu bulumakau, kaitala waga kaibibiu paila taiyu tokugwa si semakavi, e natana bulumakau paila taitala taitala matausina tokugwa la semakavi. Avai tuta guguwa makwaisina bogwa leisakaisi Guyau, ");
INSERT INTO kij_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","e Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Kukwau guguwa makwaisina paila bipilasi wotitalela Buliyoyova; e kusaiki mina Libai paila avaka bipilasi si paisewa.” ");
INSERT INTO kij_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mapaila Mosese isaiki mina Libai makaisina waga kaibibiu deli minasina bulumakau. ");
INSERT INTO kij_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Kaiyu makaisina waga kaibibiu deli navasi bulumakau isaiki dala Gerisoni, ");
INSERT INTO kij_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","e kaivasi waga kaibibiu deli nalima natonu bulumakau isaiki dala Merari. E avaka Itama matauna Eroni latula biluki matausina bivagaisi makawala. ");
INSERT INTO kij_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mitaga dala Kowati isibwaigasi Mosese gala isaiki waga kaibibiu deli bulumakau paila uula guguwa kwebumaboma eiyamataisi ikikatikewaisi okaiyasi. ");
INSERT INTO kij_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","E tokugwa matausina tuvaila imaiyaisi si semakai paila bipakasi kala kaboma kabogwabu lula. Avai tuta bogwa bisailisi si semakavi okabogwabu lula, ");
INSERT INTO kij_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Guyau iluki Mosese kawala, “Kuluki matausina kidamwa olopola kweluwotala kwaiyu yam e yam kwaitala kwaitala makwaisina tokugwa taitala taitala ibodi bisemakavi la semakavi okabogwabu lula paila bivigaki kala kaboma kabogwabu lula makwaina.” ");
INSERT INTO kij_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Baisa makawala kala takasa paila si semakavi leisakaisi. Yam Dala Tokugwa 1st Yuda Nasoni 2nd Isaka Netaneli 3rd Sebuloni Eliabi 4th Rubeni Elisura 5th Simioni Selumieli 6th Gada Eliasapi 7th Epereim Elisama 8th Manasa Gamalieli 9th Beniamina Abidani 10th Dani Aiesa 11th Asera Pagieli 12th Napitalai Aira. Taitala taitala matausina si semakavi imaiyaisi makawala wala. Kaitala kaboma silibawokuva kala mokaila makawala kwaitala taitu kwaiveka mokaila (1.5 kg). Deli kwelatala bolu silibawokuva kala mokaila makawala kwaitala taitu mokaila (800g). E kaboma deli bolu ikasuwoki pwarawa eitagulikaisi deli olibe bulamila paila kaula lulela. Kaitala kaboma kaikekita goulawokuva kala mokaila makawala kwaitala yagogu (110g), ikasuwoki wala lula maiina simasimina; natana namwala bulumakau natubovau, natana sipi namwala, deli natana nagwadi lam kwaitala kala taitu paila lula kwegubugabu; natana gota paila mitugaga lulela e nayu bulumakau nammwala, nalima sipi nammwala, nalima gota, deli nalima lam kwaitala kasi taitu paila kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","88","E komwaidona kala bawa si semakavi makwaisina leimaiyaisi matausina tailuwotala taiyu tokugwala Isireli paila kala kaboma kabogwabu lula makwaina baisa makawala kala bawa. - keluwotala kaiyu kaboma silibawokuva wala deli kwelaluwotala kwelayu bolu silibawokuva wala komwaidona kasi mokaila makawala lima yuwa petala kaula (28 kg) - keluwotala kaiyu keiluya goulawokuva wala ivakasuwoki wala lula maiina simasimina kala mokaila komwaidona makawala kwaitala taitu kwaiveka - e tuvaila buluwotala nayu bulumakau nammwala, buluwotala nayu sipi nammwala, deli buluwotala nayu lam kasi taitu kwaitala, e toyo kaula lulela bisegulikaisi paila lula kwegubugabu - buluwotala nayu gota paila mitugaga lulela, e buluwoyu navasi bulumakau nammwala, buluwolima buluwotala sipi nammwala, buluwolima buluwotala gota, buluwolima buluwotala lam kasi taitu kwaitala paila kalubaila lulela. ");
INSERT INTO kij_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Avai tuta Mosese eisuvi olumoulela Guyau la Buliyoyova paila bibigatonasi kasitaiyu Guyau, matauna inakaigali Guyau kaigala iluluki matauna metoya odabala makwaina Kabutu Didawogala, oluwalaisi minasina tokolu nayu mauna isim pinupanesi eiyoudulaisi odabala makwaina. ");
INSERT INTO kij_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Kuluki Eroni avai tuta bivitau makaisina kaitapa kailima kaiyu osi kabototu, matauna ibodi bivitobwelaki makaisina e gagabila visigala bivisigili matabudona bomikikila.” ");
INSERT INTO kij_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Eroni ivagi makawala ivitovili makaisina mitasi ila omatala. ");
INSERT INTO kij_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","E kaitapa la kabototu komwaidona wala goulawokuva; makawala Guyau nanola eivituloki Mosese bivagi. ");
INSERT INTO kij_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Kukwatupali mina Libai bimwaisi ituwoli metoya komwaidosi mina Isireli e kukwatumigileu matausina ");
INSERT INTO kij_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","makawala avaka balukwaim. Ka, kukwatusoki matausina metoya katumigileu sopila e kuluki matausina biviliwaisi komwaidona unuunula uwosi deli biwinaisi kasi karekwa. E matausina bogwa bimigileusi. ");
INSERT INTO kij_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Oluvi matausina biyosisi natana bulumakau nammwala deli pwarawa eitagulikaisi deli olibe bulamila paila kaula lulela, e yoku deli bukuyosi natana tuvaila bulumakau nammwala paila mitugaga lulela. ");
INSERT INTO kij_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Oluvi kukoguguli komwaidona mina Libai bivamatalasi omatala ulo Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Komwaidosi mina Isireli ibodi bikiwotaisi mabudona mina Libai, ");
INSERT INTO kij_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","e oluvi Eroni bikabomi matausina paila yeigu bivigaki mabudona agu kwatukila wala metoya baisa mina Isireli, e gagabila matausina biwotitalaigusi. ");
INSERT INTO kij_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Oluvi mina Libai mabudona ibodi bisailisi yumasi opwanetasi minasina nayu bulumakau nammwala, natana minasina bigubukwaisi paila mitugaga lulela, e nayuwela paila lula kwegubugabu, baisa bivigaki kabotuvitusila paila mina Libai kasi katumigileu. ");
INSERT INTO kij_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Ka, kukwabomi mina Libai mabudona bivigaki kagu kwatukila wala, e Eroni deli litula bikaraiwogaisi matausina. ");
INSERT INTO kij_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ka, makawala bukukwatukili mina Libai metoya oluwalaisi komwaidosi mina Isireli e matausina bavigaki ulo vavagi tatougu. ");
INSERT INTO kij_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","E avai tuta bogwa bukukwatumigileu deli bukukwabomi mina Libai, matausina bogwa eibudoki paila biwotetilasi olumoulela ulo Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Yeigu bogwa bavigaki matausina kaimapusi komwaidona mina Isireli si kuluta tauwau e matausina goli ulo tomota tatougu. ");
INSERT INTO kij_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Avai tuta bogwa lakatumati mina Itipita si kuluta tauwau e yeigu akabomi mina Isireli si kuluta tauwau deli si mauna kuluta nammwala bavigaki ulo vavagi tatougu. ");
INSERT INTO kij_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Baisa tuta bogwa lakau mina Libai kaimapusi mina Isireli komwaidosi si kuluta tauwau, ");
INSERT INTO kij_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","e bogwa lasaiki Eroni deli litula; makawala kwaitala semakavi metoya baisa mina Isireli, matausina biwotetilasi olumoulela ulo Buliyoyova paila kasi bwaina mina Isireli, deli goli bikolaisi mina Isireli metoya avai pakula bilumkolaisi kidamwa saina bivakatitaikinasi matabudona Bomikikila.” ");
INSERT INTO kij_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mapaila Mosese sola Eroni deli goli komwaidona mina Isireli ikabomaisi mina Libai, makawala wala Guyau leikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","E mina Libai ikatumigileuwaisi titoulesi deli iwinaisi kasi karekwa; e Eroni ikabomi matausina ivigaki Guyau kala katukila. Deli Eroni ikatumigileu matausina makawala avaka kasi gulogula. ");
INSERT INTO kij_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","E tomota komwaidona ivagaisi avaka Guyau eikaraiwogi Mosese paila mina Libai. E matausina bogwa eibudoki paila biwotetilasi olumoulela ulo Buliyoyova, e Eroni deli litula kasi tokugwa matausina. ");
INSERT INTO kij_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Mina Libai matausina kasi taitu bogwa eibudoki kweluwoyu kwailima, taitala taitala matausina ibodi biwotetilasi olumoulela ulo Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","e avai tuta bibudoki kweluwolima kala taitu matauna bivaiwasi. ");
INSERT INTO kij_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Oluvi kaina magila bipilasi sala mina Libai avaka si wotetila olumoulela ulo Buliyoyova, matauna gala ibodi bivagi avai wotetila titoulela. Baisa makawala bukukwaraiwogi mina Libai si wotetila.” ");
INSERT INTO kij_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Avai tuta mina Isireli bogwa eisilavaisi Itipita e taitu kwaiyuwela tubukona namatala e Guyau ibigitoni Mosese mapilana Sinai Viloupakala kawala, ");
INSERT INTO kij_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","“Ka tubukona minana oyamla kweluwotala kwevasila kalasia bogwa bisalala matala, mina Isireli komwaidosi bivagaisi Luvapela Pakala bikibubotaisi komwaidona karaiwogala.” ");
INSERT INTO kij_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mapaila Mosese bogwa eiluki tomota bivagaisi Luvapela Pakala, ");
INSERT INTO kij_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","e tutala bogwa eidudubali matala oyamla makwaina wala kweluwotala kwaivasila, tubukona minana wala namatala e matausina bogwa ivagaisi makawala mapilana Sinai Viloupakala. E tomota komwaidona ivagaisi makawala avaka Guyau bogwa eikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Mitaga mimilisi tauwau eiyogwalaisi titoulesi paila uula ikabikonasi wowola tomata, mapaila matausina gala gagabila bipakasi Luvapela Pakala yam makwaina. Matausina ilokaiasi Mosese sola Eroni ");
INSERT INTO kij_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","e ilukwaisi kawasi, “Yakamaisi bogwa kayogwalaimasi paila uula kakabikonasi wowola tomata, e avaka paila eipakaimasi gala bakapakasi deli matausina paila Guyau kala semakavi?” ");
INSERT INTO kij_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","E Mosese ivitakauloki kawala, “Kutulotulasi igau, tatoula wala Guyau bilukwaigu avaka la karaiwaga.” ");
INSERT INTO kij_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","biluki mina Isireli kawala, “Avai tuta wala kaina yokomi kaina tubumia tuta oluvi biyogwali titoulela metoya bikabikoni tomata wowola, kaina bila ikwaidadina ambaisa, mitaga iluluwai wala paila bivagi Luvapela Pakala, ");
INSERT INTO kij_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ibodi wala bikau natana tubukona biwokuva oluvi bivagi tubukona nayuwela oyamla kweluwotala kwaivasila koyavila. Bipaka metoya beredi gala deli kala yisi deli avai kawailuwa pwayuyu. ");
INSERT INTO kij_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Gala bukukwabogaisi kaula bikanam biyam kaukwau, deli gala kaitala totuwanesi mauna bukukwatuuwolaisi. Kuvagaisi Luvapela Pakala makawala komwaidona karaiwogala. ");
INSERT INTO kij_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mitaga kidamwa availa bogwa wala eikikili titoulela deli gala ila ikwaidadina mitaga gala ivagi Luvapela Pakala, matauna gala wala tuvaila badoki ulo tomota, paila uula gala isemakavi baisa yeigu okala tuta mokwita. Matauna ibodi bilumkoli mmayuyu avaka bibudoki la mitugaga. ");
INSERT INTO kij_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Kidamwa taitala togilagala deli kusisiaisi magila bivagi Luvapela Pakala, matauna ibodi bivagi makawala avaka karaiwogala. Karaiwaga makwaina paila komwaidomi, tolivalu deli goli togilagala kami karaiwaga.” ");
INSERT INTO kij_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Wa yam makwaina ikaliaiisi Yaubada la Buliyoyova, pilatala lowalowa eibusi ikuboli makwaina. E otutala bogi, lowalowa kala gigisa makawala kova. ");
INSERT INTO kij_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Avai tuta lowalowa bikaka metoya wa Buliyoyova e mina Isireli bisoguguwasi bigalasi bilosi, e bibudaisi si kabosikaiwa mapilana ambaisa lowalowa bibusi. ");
INSERT INTO kij_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Tomota bigalasi metoya ola karaiwaga Guyau, e bibudaisi si kabosikaiwa metoya ola karaiwaga Guyau. Kidamwa lowalowa bisisu wala odabala Buliyoyova, e tomota bisigagasi wala mapilana kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kidamwa lowalowa bisisu tuta kaduwonaku odabala Buliyoyova, e mina Isireli ikabikuwolaisi Guyau la karaiwaga e gala wala bigalasi. ");
INSERT INTO kij_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mimilisi tuta lowalowa isisu odabala Buliyoyova kwaivila wala yam. E mina Isireli bisisuaisi kaina bigalasi, makawala goli Guyau la karaiwaga. ");
INSERT INTO kij_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Mimilisiga tuta lowalowa isisu wa bogi kwaitala, e eiyam kaukwau bikaka e tomota bigalasi wa tuta makwaina. Avai tuta lowalowa bikaka e bogwa bigalasi tomota. ");
INSERT INTO kij_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","E kaina lowalowa bisisu odabala Buliyoyova biboda kwaiyu yam, e kaina natana tubukona, e kaina kwaitala taitu, kainaga bikalisau kwaitala taitu, e mina Isireli gala wala bigalasi bilosi ambaisa. Mitaga avai tuta lowalowa bikaka, e bogwa bigalasi bilosi. ");
INSERT INTO kij_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Bibudaisi si kabosikaiwa e bisoguguwasi metoya osi kabikaula baisa Guyau, makawala avaka Guyau bikaraiwogi metoya baisa Mosese. ");
INSERT INTO kij_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","E iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Kuyouduli kwaiyu tauya silibawokuva wala e bukuvigaki kasi yuvidou tomota bimeimaisi poulotala, deli paila kabotuvitusila bigalasi. ");
INSERT INTO kij_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Avai tuta tauya kwaiyu makwaisina toyuvisi binotubwaisi, e komwaidona tomota bimaisi poulotala bitoulaimsi bitopataimsi wa lulu omatala ulo Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Mitaga kidamwa kwaitala wala tauya bitagina, e matausina tokugwala dala dilatala dilatala bimaisi bitoulaimsi bitopataimsi. ");
INSERT INTO kij_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","E avai tuta tauya bikatupwaisi kala yuyuvi, e dala madilasina opilibomatu bikugwasi. ");
INSERT INTO kij_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","E sivayuwela bikatupwaisi tauya kala yuyuvi, e dala madilasina opilibolimila biloulasi, mapaila tauya bikatupwaisi kala yuyuvi baisa kabotuvitusila paila kovaluvi. ");
INSERT INTO kij_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Mitaga tauya binotubwaisi baisa paila kasi dou tomota bimaisi poulotala. ");
INSERT INTO kij_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","E tauya makwaisina kala toyuvi Eroni wala litula matausina tolula. “Karaiwaga makwaina ibodi bukuuvagaisi tuta komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Avai tuta bivitoulai kabilia omi valu, e kedala paila bukukolaimi titoulemi metoya kami tilaula, kuyuvaisi tauya makwaisina paila kabotuvitusila kabilia. E yeigu Guyau mi Yaubada bapilasaimi deli bakolaimi metoya kami tilaula. ");
INSERT INTO kij_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Deli avai tuta bibudoki kami paka ituwoli ituwoli - makawala Tubukona Navau Pakala, deli avai paka paila pakala mi tapwaroru - yokomi bukuyuvaisi tauya avai tuta bukusemakaiyaisi lula kwegubugabu deli kalubaila lulela. E yeigu bapilasaimi. Yeigu Guyau mi Yaubada.” ");
INSERT INTO kij_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","E olopola taitu kwaiyuwela tubukona nayuwela oyamla kweluwoyuwela avai tuta mina Isireli eisilavaisi Itipita, e lowalowa makwaina odabala Guyau la Buliyoyova isikaka, ");
INSERT INTO kij_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","e mina Isireli isilavaisi Sinai Viloupakala ikatuwakedasi. Lowalowa ikugwai matausina tatoula wala ilau oviloupakala Parana e itoli. ");
INSERT INTO kij_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Metoya Guyau la karaiwaga baisa Mosese, komwaidosi ikatuwakedasi, ");
INSERT INTO kij_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","tuta komwaidona osi loula, okabasi wala bogwa einagaisi bililoulasi. Mabudosina osikowala eitotusi osi boda doyala Yuda dalela eivamatalasi, ikugwasi osi boda wala titoulesi, Nasoni matauna Aminadaba latula kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Netaneli matauna Suwa latula kasi tokugwa Isaka dalela, ");
INSERT INTO kij_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","e Eliabi matauna Eloni latula kasi tokugwa Sebuloni dalela. ");
INSERT INTO kij_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Oluvi Guyau la Buliyoyova katuvala bikatupwaisi, e dala Gerisoni deli dala Merari matausina kala tokeula miyasina bikatuwakedasi. ");
INSERT INTO kij_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Eisakaili mabudona eitotusi osikowala si boda doyala Rubeni dalela eivamatalasi biloulasi kasi tokugwa Elisura matauna Sedeuri latula. ");
INSERT INTO kij_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Selumieli matauna Surisadai latula kasi tokugwa Simioni dalela, ");
INSERT INTO kij_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliasapi matauna Deueli latula kasi tokugwa Gada dalela. ");
INSERT INTO kij_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","E mina Libai matausina Kowati dalela, matausina deli wala konisi guguwa kwebumaboma biloulasi. Avai tuta biviloubusisi ammakatupona sesia eibudaisi si kabosikaiwa matausina biwokaiasi Guyau la Buliyoyova bogwa wala eikaliaiisi. ");
INSERT INTO kij_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","E eisakaili mabudona osikowala eitotusi si boda doyala Epereim dalela eivamatalasi biloulasi, osi boda wala titoulesi, e Elisama matauna Amiuda latula kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamalieli matauna Pedasura latula kasi tokugwa Manasa dalela, ");
INSERT INTO kij_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","e Abidani matauna Gidioni latula kasi tokugwa Beniamina dalela. ");
INSERT INTO kij_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Kala vigimkovila, mabudona osikowala eitotusi si boda doyala, Dani dalela eivamatalasi, matausina tovaboda kasi nim komwaidona mabudosina eikugwasi, biloulasi; osi boda wala titoulesi bililoulasi, e Aiesa matauna Amisadai latula kasi tokugwa. ");
INSERT INTO kij_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pagieli matauna Okirana latula ikugwai Asera dalela ");
INSERT INTO kij_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","e Aira matauna Enani latula ikugwai Napitalai dalela. ");
INSERT INTO kij_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Baisa makawala kala takasa paila si loula mina Isireli avai tuta bigalasi metoya kabosikaiwa katupotala katupotala, budotala budotala okabasi wala. ");
INSERT INTO kij_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","E Mosese iluki luboula yagala Obabi matauna Yetoro latula guma Midiani kawala, “Ka, yakamaisi makateki bakaloulasi bakalokaiasi valu mapilana Guyau eilukwaimasi bisakaimasi. Matauna bogwa eikatotila bivigakaimasi mina Isireli bakasibwabwailasi, mapaila kuma deli bitalosi, e bitavilabwailasi avaka guguwala metoya valu mapilana.” ");
INSERT INTO kij_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Mitaga Obabi ivitakauloki kawala, “Gala, yeigu bakaimilavau ogu valu tatougu.” ");
INSERT INTO kij_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mitaga Mosese iluki kawala, “Mwa, lubougu akoma lopom, gala bukusilavaimasi. Yoku kunikoli ammakatupona bibodi bitabudaisi kabosikaiwa oviloupakala, e yoku ibodi bukuvakadaimasi. ");
INSERT INTO kij_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kidamwa bukuma deli bitalosi, e gagabila bitavilabwailasi komwaidona avaka Guyau bisakaimasi.” ");
INSERT INTO kij_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Tutala tomota isilavaisi Sinai, makwaina koya kwebumaboma, ililoulasi iboda kwaitolu yam. Guyau la Kabutu Didawogala tuta komwaidona bikukugwai omitasi bikibuboti avai valu bibodi bibudaisi si kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Avai tuta bisilavaisi bigalasi, Guyau la lowalowa bisisu odubasi wa yam. ");
INSERT INTO kij_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Tutala Yaubada la Kabutu Didawogala bivalilouyaisi, e Mosese bikaibiga, kawala, “Guyau, kutokaia! Bukubutugigai kam tilaula, e matausina ikoulovaimsi bukuyobutubutu bisakaulasi metoya omatam!” ");
INSERT INTO kij_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","E tutala bitayasi, e Mosese bikaibiga, kawala, “Guyau, kukwaimilavau baisa lakatuluwovila mina Isireli deli litusia.” ");
INSERT INTO kij_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Tomota ivitouulasi tabunobwana baisa Guyau paila kasi mwau. Tutala Guyau ilagi saina igibuluwa e iwitali kova ila baisa tomota. Kova igabu matausina e iyogagi kabulotala si kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Tomota idousi baisa Mosese inigadasi paila pilasi, e Mosese inigada baisa Guyau e kova imata. ");
INSERT INTO kij_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Mapaila valu makwaina idokaisi Tabera. Paila la kova Guyau igabu matausina. ");
INSERT INTO kij_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mimilisi tomitawasi ikwaidadinasi deli mina Isireli, matausina saina kasi vikeiya paila gwaba. Deli goli mina Isireli titoulesi ivitouulasi takulukulu. Kawasi, “Mwadaga sitana kada gwabasi. ");
INSERT INTO kij_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Itipita olumoulela takamkwamsi komwaidona yena avaka magidasi, e gala wala tamipumapusi. E ka, kululuwaisi susugelu, marena, lokwai, aniyani e dibirera! ");
INSERT INTO kij_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Mitaga baisa tuta da peulasi bogwa leiwokuva. Gala wala avaka bitakomasi mesinaku wala eiyam eiyam manawokuva wala!” ");
INSERT INTO kij_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(Mana makawala waituna kwekekita kala gigisa kwedigadegila wala. ");
INSERT INTO kij_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Bididebarisi odabala si kabosikaiwa wa bogi otutala numla. E eiyam kaukwau tomota bilosi isosewasi makwaisina. Tomota bitutaisi bimila pwarawa, e bisulaisi oluvi bivagaisi makawala yuvayavila. E kakamwenala makawala beredi bigabwaisi deli bulami.) ");
INSERT INTO kij_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mosese bogwa ilagi tomota komwaidosi si takulukulu tutala itotusi deli litusia omatala si buliyoyova. Matauna ikaiki nanola paila Guyau eigibuluwa baisa matausina. ");
INSERT INTO kij_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","E mapaila Mosese ikaibiga baisa Guyau, kawala, “Avaka uula kuvigakaigu saina gaga sainela? Avaka paila gala ayomwasali nanom? Avaka paila kusakaigu mwada ulo koni paila bayamati matausina tomota komwaidosi? ");
INSERT INTO kij_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Ka, gala goli yeigu abubuli matausina kaina launi matausina! Ki, avaka uula kulukwaigu mwada bavigaki makawala nakaivalulu e bakopwi matausina oyamagu makawala pwapwawa e balau osi pwaipwaia makubilana avaka m biga katotila baisa matausina? ");
INSERT INTO kij_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ambaisa gagabila babani gwaba kala siniveka paila bibodi matausina tomota? Tuta komwaidona iyogugwesaisi wowogu paila wala gwaba. ");
INSERT INTO kij_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Gala wala ibodaigu agumwaleta wala bayamati tomota komwaidosi kasi bawa makawala baisa kadai! Baisa gala ibodaigu bavauli! ");
INSERT INTO kij_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Gala wala magigu bukuyogililamaigu makawala lokuvigakaigu. Ka, kidamwa bukuvigakaigu makawala, e ibodi metoya om nokapisi bukukwatumataigu!” ");
INSERT INTO kij_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","E Guyau iluki Mosese, kawala, “Kuvayouli tailuwolima tailuwoyu kaidadala valu matausina wala todidabala, e kumai matausina baisa yeigu ogu Buliyoyova, e kuluki matausina bitolisi okanivam. ");
INSERT INTO kij_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","E yeigu babusi bawa babigitonaimi baisa, e bakau sitana ulo baloma avaka lasakaim e basaiki matausina. E oluvi matausina gagabila bipilasaimsi paila kasi karaiwaga matausina tomota, paila gala ibodi bukuwotitali kammwaleta. ");
INSERT INTO kij_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","E kuluki tomota, kawam, ‘Bukukikilaimi titoulemi paila nabwaia, paila bogwa bukukwamsi viliona. Paila Guyau bogwa eilagi mi takulukulu avaka kulilivalaisi paila mwada bukukwamsi kami gwaba e deli lokuninavilasi paila Itipita. Mitaga Guyau bogwa bisakaimi kami viliona, e yokomi ibodi goli bukukwamsi. ");
INSERT INTO kij_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","E yokomi bukukomasi gala paila kwaitala yam wala, kaina kwaiyu, kaina kwailima, kaina kweluwotala, o kaina kweluwoyu yam, ");
INSERT INTO kij_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mitaga natana wala namwaidona tubukona, e bukukwamsi wala e bikalimineiki ninami bukulagobasi. E baisa biviloubusi paila uula kukoulovaisi Guyau matauwena eisividulaimi baisa, e tuvaila lokutitamapusi baisa matauna mwada ibodi mokwita gala wala bukusilavaisi Itipita.’” ");
INSERT INTO kij_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mosese iluki Guyau, kawala, “Yeigu wala ka! Akukugwai 600, 000 tomota e yoku lokulivala mwada bogwa bukusaiki kasi viliona avaka bibodi natana tubukona namwaidona ke? ");
INSERT INTO kij_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ammakawala bakakatumataisi bulumakau deli sipi kala bawa avaka bibodi matausina ke? E ki! Kudoki tuvaila yenala bolita bibodi matausina?” ");
INSERT INTO kij_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","E Guyau ivitakauloki, kawala, “Ki, kudoki ulo peuligaga isim kala kalitutila? Kutokavata igau makateki bukugisi, kaina makwaisina vavagi avaka lalilivali biviloubusisi kaina gala.” ");
INSERT INTO kij_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","E Mosese isunapula iluki tomota avaka Guyau eilivala. Ikatuguguli tailuwolima tailuwoyu tokugwa isaiki kabasi itoulaisi itopataisi Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Oluvi Guyau ibusi olumoulela lowalowa e ilivala baisa matauna. Ikau sitana la baloma avaka bogwa leisaiki Mosese e isaiki matausina tailuwolima tailuwoyu tokugwa. Avai tuta baloma imakaia matausina, e ivitouulasi iwakulasi makawala mina vitoubobuta, mitaga gala tuta kaduwonaku. ");
INSERT INTO kij_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","E taiyu matausina tailuwolima tailuwoyu tokugwa, Elidada sola Medada, eisisuaisi wala okabosikaiwa e gala ilokaiasi oBuliyoyova. E baisa okabosikaiwa wala baloma leimakaia matausina, e matausina kasitaiyu tuvaila ivitouulasi iwakulasi makawala mina vitoubobuta. ");
INSERT INTO kij_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","E taitala totubovau isakaula ilokaia Mosese e iluki avaka kasitaiyu Elidada sola Medada eivagaisi. ");
INSERT INTO kij_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Mitaga taitala tau yagala Yosuwa, matauna Nuni latula, isisu, e matauna Mosese kala topilasi metoya ola tuta gwadi e lagaila. E matauna Yosuwa iluki Mosese, kawala, “Wa, tomwaya, kusilibodi matausina.” ");
INSERT INTO kij_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","E Mosese ivitakaula, kawala, “Ki, yoku bogwa kuyebwaili bukupilasi ulo wotetila? Ka, yeigu nanogu mwada Guyau bisaiki la baloma baisa la tomota komwaidosi, e bivigaki biwakulasi makawala mina vitoubobuta.” ");
INSERT INTO kij_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Oluvi Mosese deli matausina tailuwolima tailuwoyu tokugwala Isireli ikaimilavausi okabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","E nanakwa goli Guyau iwitali kwaitala yagila e imai gogoila metoya obolita e iyokakailasi odabala wala pwaipwaia. E minasina itolisi osi kabosikaiwa deli itoulaisi itapataisi valu deli udilela komwaidona maunawokuva wala. ");
INSERT INTO kij_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Mapaila yam makwaina deli bogi makwaina deli yam omitasi, tomota si paisewa yayosa wala minasina gogoila, e gala taitala iyosi mokaila ibusi makawala lakatuyu petala kaula (1,000 kg). Ikatugaiyaisi minasina kidamwa bikali osi kabosikaiwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","E bogwa makawala saina bidubadu viliona paila matausina bikamkwamsi. Mitaga Guyau igibuluwa baisa tomota mapaila itagwala kwaitala lelia bikaloubusi, e bidubadu matausina ikaligasi. ");
INSERT INTO kij_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Mapaila valu mapilana idokaisi Lakala Vikeiya, paila valu mapilana ibakwaisi tomota matausina ikavikeiyasi paila gwaba. ");
INSERT INTO kij_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","E metoya baisa igalasi ilosi mapilana Asaroti e baisa ibudaisi si kabosikaiwa. ");
INSERT INTO kij_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","E Mosese ivaiya natana vivila vilela Kusa, e Miriam sola Eroni ikavilakaisi matauna paila baisa. ");
INSERT INTO kij_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ikaibigasi, kawasi, “Ki, Guyau bogwa wala bililivala baisa la tomota metoya baisa Mosese kalamwaleta? E bogwala eilivala metoya baisa yakida, kadai?” E Guyau ilagi avaka eikaibigasi. ");
INSERT INTO kij_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Mosese matauna tomanum, la manum gala taitala makawala odabala pwaipwaia.) ");
INSERT INTO kij_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","E nanakwa goli Guyau iluki matausina kasitaitolu Mosese, Eroni deli Miriam, e ikaibiga, kawala, “Magigu kamitaitolu wala bukumaisi ogu Buliyoyova.” Ilokaiasi matauna, ");
INSERT INTO kij_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","e Guyau ibusi olopola kaitala lowa e itoli okabosusuvi oBuliyoyova e idou, kawala, “Eroni! Miriam!” E kasitaiyu wala ivaloulasi, ");
INSERT INTO kij_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","e Guyau ikaibiga, kawala, “Ka! Kulagaisi avaka balivala. Avai tuta mina vitoubobuta isisuaisi deli yokomi, e yeigu aiyoumatila baisa matausina metoya okilisagu e abigitoni matausina metoya wa mimi. ");
INSERT INTO kij_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Mitaga baisa ituwoli wala paila avai tuta babigatona deli ulo touwata Mosese. Bogwa lasaili matauna kami tokwaraiwaga komwaidomi mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mapaila tuta tuta bakabigatona matala matagu, e kabigatona omilakatila wala e gala metoya avai kaboninayuwa. E tuvaila, ka! - matauwena bogwa leigisi migigu avaka kala gigisa. E ammakawami, yokomi kamitaiyu deli mi tuvaluwa kukwavilakaisi ulo touwata Mosese? Woo!” ");
INSERT INTO kij_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mapaila Guyau bogwa igibuluwi matausina. E matauna isilavi matausina ");
INSERT INTO kij_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","avai tuta lowalowa isilavi Buliyoyova, e saina nanakwa Miriam wowola namwaidona wala ilokuwoli kagweiguya e minana inapupwakau makawala pwaka kala pupwakau. Avai tuta Eroni igisi minana kala gigisa lelia makwaina bogwa eilokuwoli wowola, ");
INSERT INTO kij_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","e matauna iluki Mosese kawala, “Mwa, tomwaya, gala bukuvigakaimasi bakalumkolaisi mmayuyu makwaina paila uula ma mitugagasi. ");
INSERT INTO kij_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Gala bukuvigaki makawala guditala gwadi bikaloubusi gudimata inala olopola kabulotala wowola totuwanawokuva wala.” ");
INSERT INTO kij_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mapaila Mosese idou kaigaveka baisa Guyau kawala, “Mwa Yaubada, kukwatumovi minana!” ");
INSERT INTO kij_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Guyau ivitakauloki kawala, “Kidamwa minana tamala bogwa eigiu migila, e minana ibodi bilumkoli mmosila biboda kwailima kwaiyu yam. Mapaila kuyabaisi minana bisunapula metoya omi kabosikaiwa e bisisu kalamwaleta biboda kwailima kwaiyu yam, e oluvi bukukwaimilivauwaisi minana omi kabosikaiwa.” ");
INSERT INTO kij_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miriam iyabaisi metoya osi kabosikaiwa isisu kwailima kwaiyu yam, e tomota gala igalasi tatoula wala ikaimilivauwaisi minana osi boda. ");
INSERT INTO kij_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Oluvi isilavaisi mapilana Asaroti e ilosiga ibudaisi kabosikaiwa mapilana Parana oviloupakala. ");
INSERT INTO kij_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","E Guyau ilivala baisa Mosese, kawala, ");
INSERT INTO kij_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Kunagi taitala kasi tokugwa metoya dala kwaitala kwaitala paila makwaisina dala dililuwotala dilayu, e bukuwitali matausina bilosi bikautasi bivakawolaisi valu Kenani, makwaina basaiki mina Isireli.” ");
INSERT INTO kij_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","15","Mosese ikabikaula, e metoya oviloupakala mapilana Parana iwitali tokugwa matausina, baisa makawala: Dala Tokugwa Rubeni Sammwa Simioni Sapati Yuda Keleba Isaka Igali Epereim Osea Beniamina Paliti Sebuloni Gadieli Manasa Gaadi Dani Amiela Asera Seturi Napitalai Nabi Gada Geueli ");
INSERT INTO kij_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Baisa makawala yagasi matausina tokwauta Mosese eiwitali leilosi paila bivakawalisi valu makwaina. Mosese ikatumapu yagala Osea matauna Nuni latula idoki yagala igavau Yosuwa. ");
INSERT INTO kij_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Avai tuta Mosese eiwitali matausina bilosi, iluki kawala, “Metoya baisa bukuvalasi bukulosi opiliyavata e bukusuwaisi wala bukulosi opilibolimalela Kenani e bukusaitaulasi wala bukumwenasi okoyala. ");
INSERT INTO kij_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","E kuvitokaisi tolosila ammakawala valu kala gigisa, taivila tomotala, topapeula kaina tomamama. ");
INSERT INTO kij_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Kaina valu bwaina kaina gaga, deli si valu isim kalila kaina gala kalila. ");
INSERT INTO kij_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Deli kuvitokaisi tolosila pwaipwaiala bilukumalala kaina bidapakala. E avai tuta bukukwaimilavausi ibodi bukumaiyaisi sitana kawailuwala valu mapilana.” (Paila baisa tuta kweluvala waini bimonogusi.) ");
INSERT INTO kij_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Mapaila tauwau matausina ivalasi isumwaisi opiliyavata ivitouulasi oviloupakala mapilana Sini opilibolimila ikabikabisi goli ilosi mapilana Reyobi, katitaikinela Amati Kadaula opiliyavata. ");
INSERT INTO kij_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ikugwa matausina ilosi opilibolimila mapilana Ebironi, mapilana goli si valu dala Aimani, Sesai, deli Talimai, matausina tubusia kasi vakaila makawala dokanikani yagasi mina Anaki, (Eberoni viloubogwa taitu kwailima kwaiyu leiwokuva oluviga eiteyasi valu Sowani mapilana Itipita). ");
INSERT INTO kij_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Tutala eivalapulasi oItayatilela Esikoli, e metoya baisa matausina itaiyasi sisitala waini deli wala kaiuwala saina mwaugaga gala ibodi koutaitala, mapaila ikaluvisuyaisi katakewa e taiyu ikobulukwaisi. E gigiku deli seuseu ikougolaisi wala. ");
INSERT INTO kij_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","(Valu mapilana eidokaisi yagala Itayatila Esikoli paila uula mina Isireli meiteyasila masisina waini mapilana.) ");
INSERT INTO kij_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Bogwa ivakawolaisi valu iboda kweluwovasi yam, e tokwauta ikaimilavausi ");
INSERT INTO kij_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","baisa Mosese sola Eroni, deli komwaidona mabudona mina Isireli, isisuaisi mapilana Kedesi olumoulela viloupakala Parana. E ikamitulaisi avaka bogwa leigisaisi deli ivitulokaisi matausina makwaisina leimaiyaisi. ");
INSERT INTO kij_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ikaibigasi baisa Mosese, kawasi, “Ka! Lakavakawolaisi valu e lakabanaisi pwaipwaia saina kubilumalala, e ka! Mimilisi kawailuwa makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mitaga tomotala matausina isisuaisi baisa saina topapeula, deli mapilasina si valu saina kwevakaveka, e kasi kali paila kabilia saina kwepapeula. E kala gaga wala bogwa lakagisaisi mimilisi tubusia madilana dokanikani. ");
INSERT INTO kij_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Mina Amaleki isisuaisi opilibolimila olopola valu makwaina. Mina Itai, mina Yebusi deli mina Amora isisuaisi wa koya, e mina Kenani isisuaisi okawolawa Bolita Kwaiveka deli katitaikina maduyona Waya Yoridani.” ");
INSERT INTO kij_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","E matauna Keleba ikiminum ninasi tomota matausina itakulukulusi baisa Mosese e ikaibiga, kawala, “Ibodi wala bitakabiliasi deli matausina e bitakauwaisi kwabila. Paila bogwa ibodi da peulasi bitakauwaisi makwaina pwaipwaia.” ");
INSERT INTO kij_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mitaga tomota matausina bogwa leilosi deli Keleba ikaibigasi, kawasi, “Gala, yakidasi gala ibodi da peulasi bitakabiliasi deli matausina, paila matausina tomota saina topapeula, yakidasiga tomamama wala.” ");
INSERT INTO kij_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Mapaila eikayayaisi biga sasopa wala baisa mina Isireli paila valu mapilana avaka bogwa eivakawolaisi, ikaibigasi, “Valu makwaina kala kabinai gala ibodi bivakoma matausina tuta baisa eisisuaisi baisa. Bogwa lakagisaisi komwaidosi wala saina touwonaku. ");
INSERT INTO kij_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Deli mwada lakagisaisi matausina saina touwonaku sainela metoya odalela Anaki. E kama lumkolasi yakamaisi makawala nipawa wala, e kaina baisa makawala ma gigisasi baisa matausina.” ");
INSERT INTO kij_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Tomota komwaidosi ikapwalaisi si koku bogi komwaidona ivalamsi ila iyam. ");
INSERT INTO kij_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Tuta makwaina tomota itakulukulusi baisa Mosese sola Eroni, ikaibigasi, kawasi, “Tauwau, ibodi wala bakasiwaisi Itipita bakakaligasi kainaga bakakaligasi baisa oviloupakala. ");
INSERT INTO kij_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Avaka paila Guyau imaiyaidasi valu makwaina? Bitakaligimakavasi okabilia wala! E da kukovasi deli litudoiasi bikatupipaisi! Kaina ibodi wala bitakaimilavausi bitalosi Itipita.” ");
INSERT INTO kij_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","E ititamapusi taitala baisa taitala, kawasi, “Ibodi bitanagaisi taitala kada tokugwasi e bitakaimilavausi mapilana Itipita.” ");
INSERT INTO kij_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","E Mosese sola Eroni ikavaginasi opwaipwaia omitasi mina Isireli komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","E matausinaga kasitaiyu Nuni latula Yosuwa deli Yepunei latula Keleba tokwauta matausina, ikisaisi kasi kwama deli si valam, ");
INSERT INTO kij_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","e ikaibigasi baisa tomota komwaidosi, kawasi, “Ka, yakamaisi lakalosi kavakawolaisi valu makwaina pwaipwaiala saina bwaina sainela. ");
INSERT INTO kij_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kidamwa Guyau binokapisaidasi bilauwaidasi e bisakaidasi valu makwaina saina kubilumalala. ");
INSERT INTO kij_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Gala bukukwamagwesisi baisa Guyau, e gala bukukukolaisi tomota matausina isisuaisi mapilasina valu. Ibodi wala bitalokaiasi paila gagabila bitakalisauwaisi. Paila Guyau matauna deli yakidasi, e matauna bogwa eikalisau odubasi minasina yaubada mwada kasi tokwala. Mapaila gala wala bukukokolasi.” ");
INSERT INTO kij_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Tomota komwaidosi deli si gibuluwa mwada odakuna bikatubuyavaisi bikaligasi, mitaga saina nanakwa tomota igisaisi Guyau migila guyugwayula isisu odabala Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","E Guyau iluki Mosese, kawala, “Ammakawala woloula matausina tomota si kowolova baisa yeigu? Ammakawala woloula bipakaigusi, ilagoli lavagi bidubadu kabutuvatusi omitasi matausina? ");
INSERT INTO kij_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Bogwa bawitali lelia saina mwaugaga bamtuli matausina biwokuva. Oluvi bavigakaim yoku tumasi tubwa tubovau, e kasi bawa deli si peula bikalisau wala matausina tubwa tubobogwa.” ");
INSERT INTO kij_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mitaga Mosese iluki Guyau, kawala, “Ka, yoku lokumai matausina tomota metoya wa Itipita paila uula saina topeula yoku. E avai tuta mina Itipita bilagaisi baisa avaka mwada bukuvigaki matausina m tomota, ");
INSERT INTO kij_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","e bogwa bilukwaisi matausina tolesi valu mapilasina lakavakawolaisi. Mitaga tomota matausina bogwa leilagaisi bulogam. E ilagaisi kidamwa yoku deli yakamaisi. Ilagaisi gagabila wala tomota bigisimlilaimsi avai tuta m lowalowa itabodaimasi, e kidamwa bogwa lokukugwaiyaimasi wa yam olopola kaitala lowa e wa bogi olopola kaitala kova. ");
INSERT INTO kij_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ka, bidubadu mina watanawa ituwoli bona ituwoli bona eilagaisi bulogam. E, ammakawala? Kidamwa bukumtuli komwaidosi m tomota, e matausina mina watanawa bilivalasi ");
INSERT INTO kij_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","kidamwa yoku lokumtuli m tomota baisa oviloupakala paila uula gala ibodaim bukumai matausina bisuvisi valu makwaina lokukwatotila bukusaiki matausina. ");
INSERT INTO kij_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","18","Mwa Guyau, bukululuwai m biga katotila tutala kulivala kawam, ‘Yeigu Guyau tomanum wala, tokimadagi deli tonokapisi yeigu. E baligaiwa tomota si mitugaga deli si kowolova karaiwaga. Taga bogwa bamipuki litusia deli tubusia tubutolusi deli tubuvasisi paila si mitugaga tumisia inisia.’ E Guyau, mwa, ibodi bukuvitulokaimasi m peula e bukuvagi makawala m biga katotila makwaina. ");
INSERT INTO kij_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","E mwa, Guyau, yoku m yebwaili saina vakaigaga e gala avai tuta bikatumapu. E mapaila anigadaim kidamwa bukuligaiwa si mitugaga matausina tomota, makawala yoku lokuligaiwa si mitugaga matausina sivabidubadu igau avai tuta eisilavaisi Itipita e leima lagaila goli.” ");
INSERT INTO kij_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Guyau ivitakauloki, kawala, “Bogwa baligaiwa si sula makawala lokunigada. ");
INSERT INTO kij_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mitaga baisa ulo biga katotila, e kidamwa kudubumaisi yeigu tomomova asisu, e asisu goli ambaisa ambaisa ovalu watanawa, e gagabila goli bukudubumaisi baisa ulo biga katotila. ");
INSERT INTO kij_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","E ka, baisa makawala - matausina tomota gala taitala biviloubusi valu makwaina. Bogwa leigisaisi lumalamela migigu saina guyugwayu deli kabutuvatusi makwaisina lauvagi mapilana Itipita deli oviloupakala, mitaga saina ivakadolaigusi tuta komwaidona deli ikoulovaigusi. ");
INSERT INTO kij_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Gala wala avai tuta biviloubusisi valu makwaina avaka lakatotila bakasali baisa tubusia. E matausina eikoulovaigusi gala wala taitala matausina biviloubusi valu makwaina. ");
INSERT INTO kij_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mitaga ulo touwata Keleba la nanamsa ituwoli, nanola eitugwali baisa yeigu, mapaila bamai matauna ovalu makwaina leivakawoli e tubulaga biyosisi pwaipwaia. ");
INSERT INTO kij_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Oitayatila isisuaisi mina Amaleki deli mina Kenani. E nabwaia bukutovilasi bukukwaimilavausi bukulosi oviloupakala mapilana bila Mlulela Akaba.” ");
INSERT INTO kij_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Guyau iluki Mosese sola Eroni, kawala, ");
INSERT INTO kij_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Ammakawala kala woloula matausina tomitugaga bitakulukulusi baisa yeigu? Yeigu bogwa lasomata ligalega takulukulu makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Mapaila kuvitakaulasi baisa makawala, kawami, ‘Yeigu Tolimomova akatotila kidamwa bavagi baisa avaka bogwa lokunigadaigusi. Yeigu Guyau bogwa lalivala. ");
INSERT INTO kij_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Yokomi bukukwaligasi e uwomi bikatupilipili wala oviloupakala. Gala taitala yokomi availa kala taitu bikalisau kweluwoyu biviloubusi valu makwaina, paila uula mi takulukulu baisa yeigu. ");
INSERT INTO kij_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Bogwa akatotilabogwa mwada bukusisuaisi valu makwaina, mitaga gala taitala yokomi bisuvi, mesinaku wala Keleba sola Yosuwa. ");
INSERT INTO kij_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Lokukwaibigasi mwada litumia bikatupipaisi, mitaga yeigu bamai matausina valu mapilana lokupakaisi e baisa bivigakaisi si valu. ");
INSERT INTO kij_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","E yokomiga bukukwaligasi wala oviloupakala baisa. ");
INSERT INTO kij_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","E litumia biwowausi wala oviloupakala biboda kweluwovasi taitu e bibudobodasi mwau paila mi kowolova, tatoula wala komwaidomi yokomi bukukwaligasi. ");
INSERT INTO kij_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","E yokomi bukubudobodasi mmayuyu mapula mi mitugaga biboda kweluwovasi taitu. Paila yokomi mi tokwauta eivakawolaisi makwaina valu eiboda kweluwovasi yam, e mauula bavigaki kweluwovasi taitu makwaisina bikaimapu yam makwaisina kweluwovasi. E yokomi bukubanaisi avaka kala mwau kidamwa yeigu goli akoulovaimi. ");
INSERT INTO kij_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Bogwa akatotila kidamwa bavagi makawala baisa yokomi mina mitugaga, yokomi lokusigugulasi baisa gulitinidesi paila bukukoulovaigusi. Oviloupakala baisa komwaidomi wala bukukwaligasi. Yeigu Guyau bogwa lakaibiga.’” ");
INSERT INTO kij_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Tomota matausina Mosese eiwitali paila bivakawolaisi valu imaiyaisi biga sasopa wala e baisa ivigaki tomota itakulukulusi baisa Guyau. E mapaila Guyau imipuki matausina wa lelia e ikaligasi. ");
INSERT INTO kij_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","E metoya baisa matausina tokwauta tailuwotala taiyu, taiyu wala imovasi, matausina Yosuwa sola Keleba. ");
INSERT INTO kij_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Avai tuta Mosese iluki mina Isireli avaka Guyau bogwa eilivala, e ivalamsi sainela. ");
INSERT INTO kij_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","E kaukwau pikekita itokaiasi e ivitouulasi mwada biyoulisi valu wa koya. E ilivalasi, kawasi, “Ka, bogwa tavenokusi katubaiasa e baisa tuta ibodi bitalokaiasi makwaina valu Guyau eilukwaidasi. E takamitulaidasi kidamwa mokwita wala bogwa tamitugagasi.” ");
INSERT INTO kij_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mitaga Mosese ivitakauloki, kawala, “Ki, avakaga uula baisa tuta kukoulovaisi Guyau? Gala wala bukupeulasi. ");
INSERT INTO kij_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Taga bukulosi. Paila Guyau gala wala deli yokomi e kami tilaula igau bikalisauwaimi. ");
INSERT INTO kij_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Avai tuta bukubodaisi mina Amaleki kaina mina Kenani e yokomi igau bukukwaligasi okabilia. Guyau gala wala bisikailimi paila uula lokukoulovaisi matauna.” ");
INSERT INTO kij_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ilagoli Guyau la Kabutu Didawogala kaina goli Mosese gala bisilavaisi kabosikaiwa, mitaga matausina ituvaluwasi wala e imwenasi mwada biyoulisi valu mapilana wa koya. ");
INSERT INTO kij_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","E mina Amaleki deli mina Kenani tosisula valu makwaina deli iyowaisi, e bogwa ikalisauwaisi odubasi mina Isireli, e ibokavilaisi ilosi mapilana Oma. ");
INSERT INTO kij_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","E Guyau isaiki Mosese ");
INSERT INTO kij_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","karaiwaga makwaisina paila kasi karaiwaga mina Isireli kidamwa bibokulaisi ovalu mapilana makateki bisaiki matausina. ");
INSERT INTO kij_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Kaina natana bulumakau namwala, kaina natana sipi namwala kaina natana sipi navivila, kaina natana gota ibodi bukusemakavaisi baisa Guyau paila bigubuki lula kwegubugabu, kaina mi semakavi paila bikibuboti mi biga katotila, kaina paila mi tagwala semakavila, kaina mi semakavi makawala lokuuvagaisi otutala mi tapwaroru pakala, e maiinela kaula lulela makwaisina biyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","5","Kidamwa availa wala bisemakavi natana sipi kaina gota paila bigubuki lula kwegubugabu baisa Guyau, matauna ibodi bimaigoli deli mauna minana pwarawa kala vakaila makawala kapotala eitaguliki deli olibe bulamila kala kainaga makawala yatala lukwava, deli goli yatala lukwavala waini, bivigaki kaula semakavila. ");
INSERT INTO kij_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kidamwa bitugwali natana sipi namwala, pwarawa kala vakaila makawala kapoyu eitaguliki deli olibe bulamila kala kainaga yatala lukwava deli yayuwela sokopwana makwaisina ibodi bisemakavi, bivigaki kaula semakavila, ");
INSERT INTO kij_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","yatala lukwavala waini deli yayuwela sokopwana deli wala biseguliki makwaisina, e maiinela lula makwaisina biyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kidamwa bitugwali natana bulumakau namwala baisa Guyau paila bigubuki lula kwegubugabu, kaina lulela paila bikamokwiti la biga katotila, kaina bivigaki kalubaila lulela, ");
INSERT INTO kij_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","kaula semakavila, matauna bikau pwarawa kala vakaila makawala kapotolu eitaguliki deli yayu lukwavala olibe bulamila, ");
INSERT INTO kij_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","deli yayu lukwavala waini biseguliki deli magulona e bisemakavi. E maiinela lula makwaisina biyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Baisa makawala guguwa makwaisina ibodi bisemakavi deli natana mauna minasina bulumakau namwala, kaina sipi namwala, kaina sipi navivila kaina natana gota, ");
INSERT INTO kij_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","kidamwa bimai nayu kaina natonu bisemakavi, e makwaisina semakavi ituwoli tuvaila bikatumkulovi makawala mauna kasi bawa. ");
INSERT INTO kij_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Mina Isireli komwaidosi ibodi bivagaisi makawala avai tuta bisemakavaisi kaula semakavila, e maiinela lula makwaina biyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Deli avai tuta wala taitala togilagala omi valu kaina tosiwosa kaina tosivagasi, bisemakavi kaula semakavila, makwaina goli maiinela tuta komwaidona iiyomwasali nanola Guyau, matauna ibodi bikikuli avaka kami karaiwaga. ");
INSERT INTO kij_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Tuta baisa deli tuta oluvi karaiwaga makwaina bisisu wala baisa yokomi mina Isireli deli baisa togilagala omi valu. Paila yokomi deli matausina makawala wala omatala Guyau. ");
INSERT INTO kij_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mapaila karaiwaga makwaina kami karaiwaga wala yokomi deli matausina. ");
INSERT INTO kij_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Baisa makawala Guyau eisaiki Mosese ");
INSERT INTO kij_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","karaiwaga makwaisina paila kasi karaiwaga mina Isireli kidamwa bibokulaisi ovalu makwaina makateki bisaiki matausina. ");
INSERT INTO kij_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Ka, kidamwa avaka kabinaila mi bagula, kukwatupalaisi sitana paila wala Guyau kala katukila. ");
INSERT INTO kij_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Avai tuta bukugabusi beredi, e kwematala makwaisina lokugabwaisi metoya mi tayoyuwa witi, bukusakaisi wala Guyau kala katukila. Bukuvigakaisi makawala wala lokuvigakaisi metoya witi lokutututaisi. ");
INSERT INTO kij_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Tuta baisa deli tuta oluvi, katukila magulona bikanigaga metoya beredi lokugigabwaisi bukusakaisi wala Guyau kala katukila. ");
INSERT INTO kij_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Mitaga kidamwa availa bivigimakavi wala bisula e gala bibokuli mimilisi karaiwaga makwaisina avaka Guyau leiluki Mosese. ");
INSERT INTO kij_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","E kidamwa igau tuta oluvi mina Isireli gala wala bivagaisi vavagi komwaidona avaka Guyau leikaraiwogi Mosese. ");
INSERT INTO kij_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Kidamwa sula bivagaisi paila uula gala itapuloki ninasi tomota komwaidona, e matausina bisemakavaisi natana bulumakau namwala paila lula kwegubugabu e maiinela iiyomwasali Guyau nanola, deli kaula kalamatabwaila toyo waini. E katumkulovala semakavi magulona, matausina bisakaisi natana gota namwala bivigakaisi mitugaga semakavila. ");
INSERT INTO kij_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","E tolula matauna ibodi bivagi paila kasi katumigileu tomota komwaidona paila si mitugaga kala ligaiwa, paila uula sula makwaina ivigimakavaisi mapaila bimaiyaisi si mitugaga semakavila bivigakaisi kaula semakavila baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","E komwaidona mina Isireli deli goli togilagala matausina eisilomlasi oluwalaisi mina Isireli, komwaidona wala si mitugaga biligaiwa, paila uula komwaidosi wala isim si mitugaga. ");
INSERT INTO kij_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Mitaga kidamwa taitala tau iyopolasi wala imitugaga ibodi matauna bisemakavi natana navivila gota kwaitala kala taitu bivigaki mitugaga lulela. ");
INSERT INTO kij_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Metoya okabogabu lula tolula bigabu minana bivigaki mitugaga kala ligaiwa lulela paila bikatumigileu tau matauna la mitugaga, e Guyau bogwa biligaiwa la mitugaga. ");
INSERT INTO kij_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Karaiwaga makwaina bikaguliki availa availa matausina ivigimakavaisi wala imitugagasi kaina guma Isireli kaina togilagala deli eimilivalusi. ");
INSERT INTO kij_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mitaga kidamwa availa magila wala bimitugaga, kaina guma Isireli kaina togilagala, matauna bogwa eisula paila ivigaki Guyau gala kala kamaiaba, mapaila ibodi matauna bikaliga, ");
INSERT INTO kij_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","paila uula ikoulovi Guyau e ikodidaimi kwaitala la karaiwaga. Matauna la kaliga kala pakula wala titoulela. ");
INSERT INTO kij_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Igau wala mina Isireli eititavinasi oviloupakala, e kwaitala tuta ibanaisi taitala sasi ikikapoli kai wa yam Sabate. ");
INSERT INTO kij_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Iyosisi matauna iuyokaisi Mosese sola Eroni, deli goli komwaidosi mina Isireli, ");
INSERT INTO kij_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ikatupipaisi matauna, paila uula gala itobu ninasi avaka ibodi bivigakaisi matauna. ");
INSERT INTO kij_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Oluvi Guyau iluki Mosese kawala, “Ibodi wala bukukwatumataisi matauna. Komwaidosi mina Isireli ibodi bikabidikunaisi wala bikatumataisi matauna oyosewala mi kabosikaiwa.” ");
INSERT INTO kij_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Mapaila komwaidona mina Isireli isunupuloiyaisi matauna metoya osi kabosikaiwa e ikabidikunaisi ikatumataisi matauna makawala Guyau eikaraiwogi bivagaisi. ");
INSERT INTO kij_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","biluki mina Isireli kawala, “Bukubisitukwaisi yumiyami okaipagala kami kwama owokulula kwaivasi, e kukwauwaisi yatala yaburum wotunu kusipwaisi oyumiyami. Yokomi bukuvagaisi makawala bikanigaga baisa tubwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","E yumiyami miyasina bivigaki biyoluluwaiyaimi, deli avai tuta bukugigisaisi miyasina e bukululuwaisi komwaidona ulo karaiwaga e bukukwabikuwolaisi makwaisina; tuvaila gala gagabila bukutotubulokaisi e bukubokulaisiga avaka ninami titoulemi mwada bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","E yumiyami miyasina biyoluluwaiyaimi bukukwabikuwolaisi komwaidona ulo karaiwaga e deli bakabomaimi yokomi ulo tomota wala tatougu. ");
INSERT INTO kij_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Yeigu Guyau mi Yaubada. Mayeigula lakatusunupuloiyaimi metoya Itipita kidamwa yeigu wala mi Yaubada. E yeigu goli Guyau.” ");
INSERT INTO kij_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","Kora matauna Isa latula, guma Libai Kowati dalela, matauna ikoulovi avaka Mosese la karaiwaga. Matauna deli Rubeni dalela kasitaitolu matausina Datani deli Abiram Eliabi litula toyo Oni matauna Peleta latula e deli goli sesia mina Isireli kasi bawa lakatuyu tailuwolima matausina goli isim kasi nikoli tomota bogwa leinagaisi. ");
INSERT INTO kij_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Komwaidosi wala ilokaiasi Mosese sola Eroni e ilukwaisi Kawasi, “Tauwau, ki, Guyau nanola bogwa eitobu baisaga ninami wala titoulemi, ke? Ka komwaidodasi wala Guyau la tomota, e Guyau matauna deli wala yakidasi. Mitaga avaka paila yoku Mosese lokulupaim titoulem odubasi komwaidosi Guyau la tomota?” ");
INSERT INTO kij_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Tutala Mosese ilagi makawala, ikapusi opwaipwaia e inigada baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Oluvi iluki Kora deli sala, kawala, “Nabwaia kaukwau Guyau bivitulokaidasi availa la tomota mokwita. Matauna bitugwali tau matauna bogwa leinagi bibodi Guyau okabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","Nabwaia kaukwau yoku deli samwa bukukwauwaisi kova kaisakaila, e maiina simasimina deli pwakova kuwokakata kusewoyasi olumoulela, e kukwauwaisi kulauwaisi okabogwabu lula. E bilivi availa metoya oluwalaidasi Guyau bogwa leinagi. Ka, yokomila mina Libai saina ikikaiveka ninami!” ");
INSERT INTO kij_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","E Mosese isetuwoli wala la bigatona baisa Kora kawala, “Kunakaigalaisi yokomi mina Libai! ");
INSERT INTO kij_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ka, mina Isireli si Yaubada bogwa leikatupalaimi lokumwaisi ituwoli metoya komwaidosi tomota, e gagabila bukuvakatitaikinasi baisa matauna. Ki, kudokaisi baisa vavagi pikekita? Ka, tauwau, kuvagaisi avaka mi wotetila olumoulela Guyau la Buliyoyova. Ka, yokomi deli komwaidosi mina Libai isim wala kami kamaiaba Guyau bogwa leinagi! ");
INSERT INTO kij_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Guyau bogwa leitagwala yokomi deli goli komwaidona mabudona Libai bukukeulasi baisa kami kamaiaba, kadai. Mitaga baisa tuta lokuvigikonaisi mwada bukuyoulisi tuvaila avaka tolula wotitalela! ");
INSERT INTO kij_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ka, yoku deli samwa avai tuta bukutakulukulusi baisa Eroni, gala kutakulukulusi baisa matauna mitaga kutakulukulaisi wala Guyau.” ");
INSERT INTO kij_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Oluvi Mosese iwitali biga baisa Datani sola Abiram bimakaiasi matauna, mitaga ikaibigasi kawasi, “Mwa gala wala bakawokaiamsi! ");
INSERT INTO kij_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ka, bogwa lokuvisunupuloiyaimasi metoya Itipita opwaipwayela kubilumalala, e avakaga tuvaila bukuvagi mwada bukuvakaligaimasi oviloupakala? Deli ki kudoki bukuguyau odubamaisi ke? ");
INSERT INTO kij_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Mwa yoku gala kulauwaimasi ovalu mapilana pwaipwayela saina kubilumalala kaina kusakaimasi ma kwabilasi kaina ma bagulasi bigulesi waini bivigaki ma vavagisi totoumasi, mitaga baisa tuta lokuvigikoni mwada bukukwatudeuwaimasi. Ka, gala wala bakawaisi!” ");
INSERT INTO kij_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mosese saina igibuluwa e idou baisa Guyau kawala, “Guyau gala bukukwabwaili avai semakavi matausina bimaiyaisi. Yeigu gala wala ayogagi matausina. Gala goli akopatu natana si ase.” ");
INSERT INTO kij_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","E Mosese iluki Kora kawala, “Nabwaia yoku deli matausina kam tobwakuli kasi bawa lakatuyu tailuwolima bukumaisi Guyau ola Buliyoyova; Eroni bogwa wala bisibogwa oBuliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Taitala taitala yokomi bikau kova kaisakaila e bisewoya lula maiina simasimina e bisaila okabogwabu lula.” ");
INSERT INTO kij_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","E komwaidosi matausina ikeulasi kova kaisakaila, isailisi pwakova kuwokakata deli lula maiina simasimina, e ilosi itokailisi deli Mosese sola Eroni wa lulu omatala Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Oluvi Kora ikoguguli komwaidosi mina Isireli omatala Guyau la Buliyoyova itolisi mitasi ilokaia Mosese sola Eroni. E saina nanakwa Guyau la guyugwayu ivisigili tomota komwaidona, ");
INSERT INTO kij_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","oluvi Guyau iluki Mosese sola Eroni kawala, ");
INSERT INTO kij_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Kuvayumilasi metoya komwaidona tomota e bakatumtuwoliga komwaidosi baisa tuta.” ");
INSERT INTO kij_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mitaga Mosese sola Eroni ikululusi opwaipwaia e ikaibigasi kawasi, “Mwa, Yaubada yoku momova uulela, kidamwa taitala tomota bimitugaga e yokuga bukugibuluwi tomota komwaidona ke?” ");
INSERT INTO kij_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ka, kuluki tomota bivapalasi bilosi ewaiwa metoya osi buliyoyova Kora, Datani, deli Abiram.” ");
INSERT INTO kij_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","E oluvi Mosese, deli komwaidosi tokugwala Isireli ilokaiasi Datani sola Abiram. ");
INSERT INTO kij_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mosese iluki tomota kawala, “Kuvapalasi kuwaisi ewaiwa metoya osi buliyoyova matausina mina mitugaga deli gala bukukwabikonaisi avai guguwa si guguwa matausina. Kidamwa bukuyokeiwaisi yokomi madeilila wala bukudoumsi.” ");
INSERT INTO kij_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Mapaila matausina itopalasi ilosi ewaiwa metoya osi buliyoyova Kora, Datani, deli Abiram. Datani deli Abiram eisunapulasi itodelisi osi buliyoyova wa lulu deli goli si kukova e litusia. ");
INSERT INTO kij_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","E Mosese iluki tomota kawala, “Baisa makawala bukunikolaisi Guyau iwitalaigu bavagi vavagi makwaisina e gala nanogu titoulegu lauvagi vavagi makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kidamwa Yaubada gala bimipuki tauwau matausina e bikaligimakavasi wala, baisa kala nikoli Guyau gala inagaigu. ");
INSERT INTO kij_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mitaga kidamwa Guyau bitamituli kwaitala vavagi kwemitawasi e pwaipwaia bikapogega bikapatu matausina toyo si guguwa komwaidona e tommomova wala bilosi wa Tuma, ka, metoya baisa bukunikolaisi matausina ikoulovaisi Guyau.” ");
INSERT INTO kij_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Tutala Mosese ivenoku bigatona, pwaipwaia makatupona Datani sola Abiram eititokaisi ikapogega ");
INSERT INTO kij_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","e ilupoli matausina, litusia, Kora deli sala, deli goli komwaidona si guguwa. ");
INSERT INTO kij_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","E matausina tommomova wala ilosi Tuma toyo si guguwa komwaidona. E pwaipwaia ikapatu matausina, e komwaidosi itamwausi. ");
INSERT INTO kij_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Komwaidosi mina Isireli eitotusi baisa isakaulasi tutala ilagaisi iukuwakulasi. Matausina ikamitamatasi kawasi, “Sakaula, sakaula, ikapataidasiga madeilila!” ");
INSERT INTO kij_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Tuvaila Guyau iwitali kova ilululu ivakadoum matausina lakatuyu tailuwolima, matausina eigibumakavasi lula maiina simasimina. ");
INSERT INTO kij_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Oluvi Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Kuluki Eleasa matauna Eroni tolula latula bikau makaisina kova kaisakaila eibubulokaisi metoya tanumnumta barasi bisaim ituwoli metoya tauwau matausina kova bogwa eivakadoum, e bilau ikatusou makovasina omalaga, paila makaisina kova kaisakaila kaibumaboma. ");
INSERT INTO kij_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Makaisina kaibumaboma tuta matutona lokusakaisi Guyau ivigaki paila la kabogwabu lula wotitalela. Mapaila kukwau makaisina kova kaisakaila metoya tauwau matausina bogwa leikaligasi paila si mitugaga, kukwatupitati makaisina bipatatasi wala e kuvigaki yokuluvala kabogwabu lula; e baisa bivigaki yokilela mitasi mina Isireli.” ");
INSERT INTO kij_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Mapaila Eleasa matauna tolula ikau makaisina kova kaisakaila ikatupitati ivigaki yokuluvala kabogwabu lula. ");
INSERT INTO kij_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","E availa availa mina Isireli matausina gala Eroni dalela baisa yokilela mitasi, e gala ibodi bimaisi okabogwabu lula paila bigabusi lula maiina simasimina baisa Guyau. Paila kidamwa avai tau bima, matauna bisilagi makawala Kora deli la boda. Eleasa ivagi komwaidona makawala Guyau la karaiwaga baisa Mosese. ");
INSERT INTO kij_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","E eiyam, komwaidona mina Isireli itakulukulusi baisa Mosese sola Eroni kawasi, “Yokomi bogwa lokukwatumataisi mimilisi Guyau la tomota.” ");
INSERT INTO kij_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","E tutala bogwa eikougugulasi mwada bilokaiasi Mosese sola Eroni, komwaidosi itovilakaisi Guyau la Buliyoyova e igisaisi lowalowa ikukuboli makwaina e Guyau la gugugwayu saina peula ikaloubusi. ");
INSERT INTO kij_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","E Mosese sola Eroni ilosi itolisi omatala Buliyoyova, ");
INSERT INTO kij_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","e Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Kuvayumilasi bamtuliga komwaidosi otukolela!” E kasitaiyu wala ikululusi migisi opwaipwaia, ");
INSERT INTO kij_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","e Mosese iluki Eroni kawala, “Kukwau m kova kaisakaila e kusewoya pwakova kuwokakata metoya okabogwabu lula deli sitana lula maiina simasimina. E bukunanakwa bukulokaia tomota e bukuvagi kabotuvitusila paila kasi katumigileu. Mwa, kunanakwa, Guyau la gibuluwa baisa tuta bogwa eilitaki tomota e lelia saina mwaugaga bogwa eivitouula.” ");
INSERT INTO kij_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","E Eroni ikabikaula, ikau la kova kaisakaila e isakaula ila oluwalaisi tomota komwaidona. Avai tuta leigisi lelia makwaina bogwa leivitouula, matauna ikau lula maiina simasimina isaila odabala pwakova kuwokakata e ivagi kabotuvitusila paila tomota kasi katumigileu. ");
INSERT INTO kij_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","E mwau makwaina iwokuva, e Eroni kalamwaleta wala itotu oluwalaisi tommomova deli tokukwaliga. ");
INSERT INTO kij_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Tomota kasi bawa leikaligasi 14,700, e deli goli matausina leikaligasi metoya Kora ola dubakasala gala deli kasi kakalawa. ");
INSERT INTO kij_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Avai tuta lelia makwaina saina mwaugaga bogwa leiwokuva, e Eroni ikaimilavau ilokaia Mosese omatala Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Kuluki mina Isireli tokugwala metoya dala dilatala dilatala bimiakaimsi kaitukwa kala bawa kailuwoyu kaiyu, kugini yagala taitala taitala matausina ola kaitukwa wala titoulela ");
INSERT INTO kij_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","e Eroni yagala kugini Libai ola kaitukwa. E kaitukwa kaitala kaitala makaisina paila tokugwala dala dilatala dilatala. ");
INSERT INTO kij_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","E kukwau makaisina kulau ogu Buliyoyova kusaili omatala Kabutu Didawogala, makatupona goli leitabudoboda. ");
INSERT INTO kij_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","E avai tau bogwa lanagi la kaitukwa bitam. Baisa bivigaki basilibodi si takulukulu mina Isireli tuta komwaidona itakulukulusi baisa yoku.” ");
INSERT INTO kij_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Mapaila Mosese iluki mina Isireli e tokugwala dala dilatala dilatala isakaisi matauna si kaitukwa, kaitala kaitala makaisina paila dala dilatala dilatala, kala bawa kailuwotala kaiyu, e Eroni la kaitukwa deli makaisina. ");
INSERT INTO kij_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","E oluvi Mosese ilau komwaidona kaitukwa makaisina olumoulela Buliyoyova e isaili omatala Guyau la Kabutu Didawogala. ");
INSERT INTO kij_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","E eiyam avai tuta Mosese isuvi olumoulela Guyau la Buliyoyova igisi makaina Eroni la kaitukwa oyagasiga mina Libai bogwa leitam. Makaina eisisi, ilala, deli eiuwa kaiuwala makawala saida kwematuwa. ");
INSERT INTO kij_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mosese ikau komwaidona makaisina kaitukwa e ivituloki mina Isireli. E matausina igisaisi avaka eikaloubusi, e tokugwa taitala taitala ikaimalaisi si kaitukwa. ");
INSERT INTO kij_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","E Guyau iluki Mosese kawala, “Kukwau Eroni la kaitukwa kukwaimilivau kulau kusaili omatala Kabutu Didawogala. E makaina bikanigaga baisa bivigaki mina Isireli si kabogigisa paila si kowolova, paila matausina bikikaligasi wala kidamwa gala bisimwaisi takulukulu.” ");
INSERT INTO kij_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mosese ivagi makawala avaka Guyau leikaraiwogi matauna. ");
INSERT INTO kij_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Mitaga mina Isireli ilukwaisi Mosese kawasi, “Mwa bogwa wala bakadoumlabasi! ");
INSERT INTO kij_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Paila kidamwa availa bivakatitaikina Guyau la Buliyoyova bogwa wala bikaliga, mapaila desi wala bakadoumsi.” ");
INSERT INTO kij_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","E Guyau iluki Eroni kawala, “Yoku deli litumwa, deli goli mina Libai ibodi bukulumkolaisi kala mmayuyu mi sula komwaidona bukukeulasi kami pakula paila avai vavagi lokukididogaisi metoya omi wotetila olumoulela ulo Buliyoyova, mitaga yoku wala deli litumwa ibodi bukulumkolaisi kala mmayuyu wotetila makwaina paila tolula wotitalela. ");
INSERT INTO kij_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Yoku bukumai veyamwa komwaidona odalela Libai kidamwa biwotetilasi deli yoku e bipilasaimsi avai tuta yoku bukupaisewasi deli litumwa olumoulela ulo Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Matausina bivagaisi si wotetila bwaina baisa yoku, deli wotitalela ulo Buliyoyova, mitaga gala wala ibodi bikabikonaisi avai guguwa kwebumaboma olumoulela matabudona Bomikikila, kaina okabogwabu lula. Kidamwa bivagaisi, matausina deli yoku bukukwaligasi wala. ");
INSERT INTO kij_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Matausina biwotetilasi deli yoku e bivigimkulovaisi avaka kasi karaiwaga paila wotitalela ulo Buliyoyova, mitaga gala bukutagwala tobubeikam biwotetilasi deli yoku. ");
INSERT INTO kij_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Yoku wala deli litumwa kamimwaleta ibodi bukuvigimkulovaisi wotitalela matabudona Bomikikila deli kabogwabu lula, e baisa bivigaki gala tuvaila bayomitali agu leiya baisa mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ka, yeigu wala titoulegu lanagi veyamwa mina Libai oluwalaisi Isireli komwaidona bivigaki kam bobwailila. Matausina bogwa lakabomi, e igagabila biwotetilasi olumoulela ulo Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Mitaga yoku deli litumwa kamimwaleta ibodi bukuvigimkulovaisi komwaidona tolula wotitalela metoya okabogwabu lula deli olumoulela matabudona Bomikikila Sainela. E komwaidona guguwala Buliyoyova bukukwaraiwogaisi, paila tolula wotitalela bogwa lasakaimi baisa mi koni. E availa tobubeikam idoki bima katitaikinela guguwa makwaisina kwebumaboma, bikaliga wala.” ");
INSERT INTO kij_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","E Guyau iluki Eroni kawala, “Komwaidona mina Isireli si semakavi leikatuyoulisi paila yeigu agu kwatukila, makwaisina gala ibodi bigubuki lula. Bogwa basakaimi, yoku deli goli dalem, vilavila makwaina bikanigaga baisa yokomi. ");
INSERT INTO kij_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Metoya komwaidona semakavi saina kwebumaboma makwaisina gala bigabu okabogwabu lula, mimilisi makwaisina mi vavagi wala. Makawala, kaula semakaila, mitugaga kala ligaiwa semakaila, deli kaimapu semakaila. Komwaidona makwaisina saina kwebumaboma, bisemakaiyaisi baisa yeigu, baisa mi vavagi deli litumwa. ");
INSERT INTO kij_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Kaula makwaina bukukwamkomasi ambaisa wala katupobumaboma, e tauwau wala ibodi bikomasi kaula makwaisina. Bukudokaisi makwaisina kwebumaboma. ");
INSERT INTO kij_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“E tuvaila, kidamwa avai vavagi tuvaila mina Isireli bisemakaiyaisi paila yeigu agu kwatukila, baisa mi vavagi wala. Yeigu lasisakaim, litumwa tauwau deli vivila, tuta baisa e bikanuvagisi goli. Availa availa goli veyamwa bogwa eikikilaisi titoulesi ibodi bikamsi goli. ");
INSERT INTO kij_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“E avaka kalamatabwaila mina Isireli si visulapula paila yeigu taitu kwaitala kwaitala makawala. olibe bulamila, waini, deli kaula. ");
INSERT INTO kij_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Komwaidona wala mi vavagi. Availa availa goli veyamwa bogwa eikikilaisi titoulesi ibodi bikamkomasi goli semakavi makwaina. ");
INSERT INTO kij_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Komwaidona vavagi kwebumaboma olopola Isireli makwaisina eisemakavaisi baisa yeigu baisa mi vavagi wala. ");
INSERT INTO kij_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“Kidamwa kuluta gugwadi kaina mauna mina Isireli leisisakaigusi baisa mi vavagi wala. Mitaga kidamwa gugwadi veisia magisi bigimolivauwaisi ibodi bukusaili mapusi, makawala goli komwaidona kuluta mauna ibodi bukusaili mapusi minasina napupagatu. ");
INSERT INTO kij_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","E gugwadi ibodi bigimolivauwaisi avai tuta bibudoki kasi tubukona natana, mapusi bibudoki wala kwailima siliba, makawala avaka kami karaiwaga. ");
INSERT INTO kij_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mitaga bulumakau, sipi, deli gota si kuluta gala bukutagwala bigimolivauwaisi, minasina komwaidona wala yeigu ulo vavagi tatougu, ibodi wala bukugibukwaisi lula paila yeigu. E buyavisi bukukwatusokaisi kabogwabu lula, e posasi bukugibukwaisi lula bivigaki kaula semakaila e maiinela biyomwasali nanogu. ");
INSERT INTO kij_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","E vilionesiga minasina baisa paila wala yokomi, makawala, seila deli kaikena kweyakakata metoya katukila magulona. ");
INSERT INTO kij_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","“Yeigu basakaimi kami vilavila toyo litumwa tauwau deli goli vivila, tuta baisa, e bikanuvagasi goli metoya vavagi komwaidona avaka mina Isireli leisisemakavaisi baisa yeigu agu kwatukila. Makwaina goli kabutu oluwalaidasi gala bitotina baisa yoku toyo dalem.” ");
INSERT INTO kij_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","E Guyau iluki Eroni kawala, “Mwa, yoku gala wala bukuyosi avai guguwa gagabila bukuvigaki bigukeya paila titoulem, deli goli dalem; deli gala bisim pwaipwayem olopola Isireli. Ka, komwaidona vavagi bukubani metoya wala baisa yeigu.” ");
INSERT INTO kij_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","E Guyau ikaibiga kawala, “Bogwa lasaiki mina Libai komwaidona tala metoya luwotala avaka mina Isireli eisakaigusi. Baisa kaimapula si wotetila paila iyamataisi ulo Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Mina Isireli dala ituwoli ituwoli gala tuvaila bisukwaisi ulo Buliyoyova paila igau biyomitulaisi kasi kaliga titoulesi. ");
INSERT INTO kij_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Tuta baisa e bikanuvagasi goli mina Libai wala kasimwaleta biyamataisi ulo Buliyoyova, deli bivagaisi wotitalela komwaidona paila makwaina. Karaiwaga makwaina bikanigaga baisa yoku deli goli dalem komwaidona. Mina Libai gala wala biyosisi avai vavagi kasi vilavila olopola Isireli, ");
INSERT INTO kij_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","paila uula tala metoya luwotala avaka mina Isireli leisisakaigusi agu kwatukila, baisa kasi vilavila tatousi. Baisa uula lakatuloki matausina gala wala sitana biyosisi avai vavagi kasi vilavila olopola Isireli.” ");
INSERT INTO kij_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","E Guyau ikaraiwogi Mosese ");
INSERT INTO kij_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","biluki mina Libai kawala, “Avai tuta mina Isireli bisakaimi tala metoya luwotala avaka Guyau leisisakaimi paila mi vavagi tatoumi, metoya magulona ibodi bukusemakaiyaisi tala metoya luwotala paila Guyau kala katukila. ");
INSERT INTO kij_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Katukila magulona bukukibubotaisi bibudoki makawala tobigubagula la semakavi metoya kwaiuwovau kaula deli waini. ");
INSERT INTO kij_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Baisa bivigaki yokomi bukusemakaiyaisi paila Guyau kala katukila metoya magulosina tala metoya luwotala avaka mina Isireli leisakaimi katukila magulona paila Guyau, komwaidona wala bukusakaisi Eroni tolula. ");
INSERT INTO kij_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Komwaidona avaka bwainigaga leisakaimi kusakaisi matauna. ");
INSERT INTO kij_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Avai tuta bogwa bukusemakaiyaisi avai vavagi bwainigaga baisa Guyau, e kesalaga paila wala titoulemi makawala goli tolibagula ikugwa bisemakavi e oluvi kesala biyosi paila wala titoulela. ");
INSERT INTO kij_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Yokomi tolula deli veimia bukukwamsi ambaisa wala magimi, paila baisa mapula mi wotetila ogu Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","E avai tuta bukukwamkwamsi baisa gala bivigaki lokusulasi, paila uula bogwa lokusemakaiyaisi komwaidona vavagi bwainigaga baisa Guyau. Mitaga kuyamataimi gala bukuyogwalaisi mina Isireli si semakavi kwebumaboma metoya bukukwambogwisi avai vavagi makwaisina, oluviga bukusemakaiyaisi vavagi bwainigaga. Kidamwa bukuvagaisi makawala, bukukwaligasi wala.” ");
INSERT INTO kij_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","E Guyau ikaraiwogi Mosese sola Eroni ");
INSERT INTO kij_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","bisakaisi mina Isireli kasi karaiwaga. Matausina bimiakaisi natana navivila bulumakau nabweyani minana gala isim kala nebaneba, deli minana gala kwaitala tuta ivigakaisi ipaisewa, ");
INSERT INTO kij_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","matausina bisakaisi minana baisa Eleasa tolula. Bisunupuloiyaisi minana oyosewala kabosikaiwa e bikatumataisi omatala wala Eleasa tolula. ");
INSERT INTO kij_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Oluvi Eleasa bikau sitana buyavila minana, e deli misikwaikwela bikikatusoka sivalima sivayu kidamwa litukwela buyavi bila ambaisa kibubotala Buliyoyova eititoki. ");
INSERT INTO kij_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","E namwaidonaga minana makawala kanuvinela, vilionela, buyavila, deli sileula bigabwaisi wala omatala tolula. ");
INSERT INTO kij_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Tuvaila tolula matauna bikolibabi mimilisi kai kweisila, sisitala silumwaiya, deli yatala wotunu yabweyani, e bilavi bilosi wa kova bigabugoli. ");
INSERT INTO kij_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","E oluvi matauna biwini kala karekwa deli bikakaya tomwaidona, e oluvi biviloubusi okabosikaiwa. Mitaga matauna deli wala la pupagatu bisisu tatoula wala bibugiki. ");
INSERT INTO kij_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","E avai tau kala togabu minana bulumakau ibodi biwini kala karekwa deli bikakaya tomwaidona, mitaga tau matauna tuvaila la pupagatu bisisu tatoula wala bibugiki. ");
INSERT INTO kij_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","E avai tau matauna tomigileu mokwita ibodi bikau tubwagela bulumakau minana bilau oyosewala kabosikaiwa e bisaili kabala ambaisa katupomigileu wala bisisu, e bisisu baisa paila mina Isireli bisewoyasi wa sopi e bivigakaisi paila katumigileula si pupagatu. E makwaina gulogula katumigileu bivagaisi paila mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","E tau matauna leikatuyoula tubwaga baisa ibodi biwini kala karekwa. Mitaga matauna la pupagatu bisisu tatoula wala bibugiki. E karaiwaga makwaina bikanigaga paila mina Isireli deli goli togilagala eisisilomlasi oluwalaisi. ");
INSERT INTO kij_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Availa bikabikoni tomata bogwa eiyogwali titoulela e bisisu wala deli la pupagatu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Mitaga matauna ibodi bikatumigileu titoulela metoya mitugaga kala katumigileu sopila wa yam kwaitolula, deli yam kwailima kwaiyuwela, e matauna bogwa bimigileu. Mitaga kidamwa gala bikatumigileu titoulela olopola yam makwaisina kwaiyu, matauna gala wala bimigileu. ");
INSERT INTO kij_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Availa bikabikoni tomata e gala bikatumigileu titoulela matauna bisisu wala deli la pupagatu, paila uula sopila mitugaga kala katumigileu gala ivakakayaisi matauna. Matauna bogwa eiyogwali Guyau la Buliyoyova, mapaila matauna gala tuvaila Yaubada bidoki la tomota. ");
INSERT INTO kij_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Kidamwa availa bikaliga olumoulela la buliyoyova titoulela, e availa isisu olumoulela makwaina tutala eikaliga kaina availa bisuvi olumoulela makwaina bogwa bipupagatu, e la pupagatu bisisu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Komwaidona bolu deli kulia olumoulela buliyoyova makwaina gala isim katubukolesi tuvaila bogwa eipupagatusi wala. ");
INSERT INTO kij_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Kidamwa availa bikabikoni avai tomota matauna bogwa eikatumataisi kaina ikaligimakava wala, okoukweda, kaina availa bikabikoni kaitala tomata totuwanesi kaina laka, matauna bogwa bipupagatu e la pupagatu bisisu biboda kwailima kwaiyu yam. ");
INSERT INTO kij_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Paila pupagatu kala katumigileu, ikugwa bikauwaisi sitana tubwagela bulumakau nabweyani minana leigabwaisi paila mitugaga kala katumigileu e bisewoyasi bila olumoulela kwelatala kulia, oluvi sopi simokainia biligabwaisi bila olumoulela. ");
INSERT INTO kij_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Kwematala nanamsela makawala, kidamwa availa tomigileu, matauna ibodi bilopwi sisitala silumwaiya, bividagu wa sopi olumoulela kulia, e bikatusoki la buliyoyova titoulela, deli guguwala komwaidona, deli komwaidona kala tosisu buliyoyova makwaina. Kweyuwela nanamsela, kidamwa availa tomigileu, matauna ibodi bikatusoki avai tau matauna eikabikoni tomota totulesi, kaina tomata, kaina laka. ");
INSERT INTO kij_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","E yam kwaitolula deli yam kwailima kwaiyuwela tomota matauna tomigileu, ibodi bikatusoki sopi makwaina baisa tau matauna isim la pupagatu. E yam kwailima kwaiyuwela tomigileu matauna ibodi bikatumigileu sola matauna deli la pupagatu. E matauna goli ikugwa biwini kala karekwa, deli bikakaya, e oluvi avai tuta bikoyavi matauna bogwa bimigileu. ");
INSERT INTO kij_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Kidamwa availa bogwa eiyopigigatu titoulela, e gala ikatumigileu wowola, matauna deli wala la pupagatu bisisu, paila uula sopila katumigileu gala ivakakayasi matauna. Matauna bogwa eiyogwali Guyau la Buliyoyova, e gala wala tuvaila Yaubada bidoki la tomota tatoula. ");
INSERT INTO kij_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Karaiwaga makwaina ibodi bukukwabikuwolaisi tuta baisa e bikanigaga goli. Tau matauna tokatusoka sopi baisa paila katumigileu ibodi biwini kala karekwa. Availa bikabikoni sopi baisa, matauna bogwa eiyopigigatu titoulela e bisisu wala deli la pupagatu bila bibugiki. ");
INSERT INTO kij_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kidamwa tau matauna deli la pupagatu bikabikoni avai vavagi, bogwa eiyopigigatu makwaina deli bogwa eiyopigigatu titoulela e bisisu deli la pupagatu bila bibugiki. ");
INSERT INTO kij_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","E tubukona minana taitu kala vitouula e komwaidosi mina Isireli iviloubusisi oviloupakala Sini e ibudaisi si kabosikaiwa baisa Kadesi. E baisa minana Miriam ikaliga e ibakwaisi. ");
INSERT INTO kij_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Baisa eibudaisi si kabosikaiwa gala wala sopi, e tomota itoulaisi Eroni sola Mosese, ");
INSERT INTO kij_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","e itakulukulusi baisa matausina, kawasi, “E kaina bibodi mokwita kidamwa bakakaligasi omatala Guyau ola Buliyoyova makawala semaiasi mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Avaka paila lokumaiyaimasi mapilana oviloupakala? Ki, kidamwa baisa bakakaligasi, yakamaisi deli goli ma bulutuvalusi? ");
INSERT INTO kij_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Avaka paila lokuvisunupuloiyaimasi metoya mapilana Itipita e lokumaiyaimasi baisa saina gaga sainela, paila gala wala avaka bitavali bisusina? Gala witi, gala seuseu, gala waini kawailuwala e gigiku, e deli tuvaila gala sitana sopi paila momom.” ");
INSERT INTO kij_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mosese sola Eroni ivapalasi metoya baisa tomota e itolisi omatala Buliyoyova. E ikavaginasi migisi opwaipwaia, e Guyau la lumalama deli guyugwayula iviloubusi baisa matausina. ");
INSERT INTO kij_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","E Guyau iluki Mosese, kawala, ");
INSERT INTO kij_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Kukwau kaitukwa makaina eikanukwenu omatala Kabutu Didawogala, e yoku som Eroni kukougugulaisi mina Isireli komwaidosi. Boda komwaidona omitasi kuluki makwaina dukutotu, e sopi bogwa bigiposisi. E baisa bukuvigaki sopi bibusi metoya odakuna, e matausina deli si bulutuvalu bimomsi.” ");
INSERT INTO kij_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","E Mosese ilokaia ikau kaitukwa makaina makawala avaka Guyau bogwa eikaraiwogi. ");
INSERT INTO kij_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Matauna deli Eroni ikougugulaisi tomota omatala dukutotu, e Mosese iluki tomota kawala, “Kulagaisi yokomi tokosomapu. Ki, ibodi wala bakakau sopi metoya wa dukutotu makwaina paila yokomi?” ");
INSERT INTO kij_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Oluvi Mosese ilupi la kaitukwa e isivayu iwaiya makwaina dukutotu, e sopi igiposisi isusunapula ivigaki saina kaduyoveka sakala, e tomota komwaidosi deli si bulutuvalu imomsi. ");
INSERT INTO kij_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mitaga Guyau ikamitilaki Mosese sola Eroni, ikaibiga kawala, “Uula wala gala kusimokwitasi ulo peula kwebumaboma omitasi mina Isireli, paila mi dubumi gala tona, e mapaila yokomi gala bukuviloubusiaisi matausina valu makwaina avaka lakatotila mwada basaiki matausina.” ");
INSERT INTO kij_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Baisa leivigaki mapilana Meriba, ambaisa mina Isireli eitakulukulusi baisa Guyau, e baisa iyoumatila baisa matausina mwada matauna Tobumaboma. ");
INSERT INTO kij_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Mosese iwitali touwata metoya Kadesi e ilauwaisi biga baisa guyoula Edom. E ikaibigasi kawasi, “Biga mabigana metoya baisa veyamwa mina Isireli. Kunikoli vavagi mwau kabudobodasi, ");
INSERT INTO kij_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ammakawala tubumaiasi eilosi Itipita e baisa kasigagasi kwaivila taitu. Mina Itipita iyomiyuyaisi tubumaiasi e deli goli yakamaisi, ");
INSERT INTO kij_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","mapaila kadousi baisa Guyau paila pilasi. E bogwa ilagi ma dousi iwitali anelosi ima e ivisunupuloiyaimasi metoya Itipita. E baisa tuta yakamaisi Kadesi lakasisuaisi valu makwaina okaligeila deli m valu. ");
INSERT INTO kij_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Kutagwala bakaluvapelasi olopola m valu. Yakamaisi deli ma bulutuvalusi gala bakavalavaisi keda, kaina bakakalipolasi omi bagula kaina omi waini bigulesi, deli gala bakamomsi metoya kami utuwotu, mitaga bakaliloulasi wala okadaula igau avai tuta bakavaligilaisi m kwabokwaraiwaga.” ");
INSERT INTO kij_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mitaga mina Edom ivitakaulokaisi, kawasi, “Gala wala katagwalasi bukusuvisi e bukuluvapelasi metoya oma valusi. Kidamwa kuvigikonaisi, bakadeilisi bakawaisi e bakawaimi.” ");
INSERT INTO kij_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","E mina Isireli ikaibigasi, kawasi, “Bakaliloulasi wala okadaula, e kidamwa yakamaisi kaina ma bulutuvalusi bakamomsi metoya kami sopi, e bakamapusi. Mesinaku wala magimasi sainela bakaluvapelasi wala.” ");
INSERT INTO kij_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mitaga mina Edom ikaibigasi, kawasi, “Gala wala katagwalasi!” E ideilisi isunapulasi deli tokwabilia topapeula paila bikabiliasi deli mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Mina Edom gala wala itagwalasi mina Isireli biluvapelasi olopola si valu, e mapaila mina Isireli iuwovilasi ilosi wa keda ituwoli. ");
INSERT INTO kij_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","E komwaidosi mina Isireli isilavaisi Kadesi e iviloubusisi wa Koya Ora ");
INSERT INTO kij_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","okaligeila mapilana Edom. E makatupona Guyau iluki Mosese sola Eroni kawala, ");
INSERT INTO kij_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Eroni gala wala biviloubusi makwaina valu avaka lakatotila mwada basaiki mina Isireli, paila matauna bogwa bikaliga. Paila yokomi kamitaiyu lokukoulovaisi ulo karaiwaga mapilana Meriba. ");
INSERT INTO kij_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Kuvakouli Eroni deli latula Eleasa kulau kumwenasi wa Koya Ora, ");
INSERT INTO kij_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","e baisa bukuvilili Eroni kala kwama tolula e bukuvisikoma Eleasa, paila Eroni bogwa bikaliga baisa.” ");
INSERT INTO kij_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mosese ivagi avaka Guyau eikaraiwogi. Imwenasi wa Koya Ora, boda budomwaidona omitasi, ");
INSERT INTO kij_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","e Mosese ivilili kala kwama tolula Eroni e ivisikoma Eleasa. E Eroni ikaliga wa koya odabala, e Mosese deli Eleasa ibusisi ikaimilavausi metoya wa koya. ");
INSERT INTO kij_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","E komwaidosi mina Isireli eilagaisi paila Eroni bogwa eikaliga, e komwaidosi matausina ivalamsi paila matauna iboda kweluwotolu yam. ");
INSERT INTO kij_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","E tolela Kenani guyoula Aradi isisu opilibolimila mapilana Kenani ilagi bulogasi mina Isireli leimaisi okedala Atarim. E ilokaia e deli ikabiliasi e mimilisi tomota iyosi ikatupipi. ");
INSERT INTO kij_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Mapaila mina Isireli ilivalasi biga katotila baisa Guyau, kawasi, “Kidamwa yoku bukutagwala bakatomgwagasi odubasi tomota matausina, bogwa wala bakakabomaisi matausina deli si valu paila yoku, e bakamtulaisi matausina e si valu bakakatudidaimisi.” ");
INSERT INTO kij_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","E Guyau bogwa ilagi si biga e ipilasi mina Isireli e bogwa itomgwagasi odubasi matausina mina Kenani. Mapaila mina Isireli imtulaisi matausina e ikatudidaimisi si valu. E idokaisi mapilana valu kala kavilevi Oma. ");
INSERT INTO kij_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Mina Isireli isilavaisi Koya Ora bilokaiasi wa keda makadana bila Mlulela Akaba, paila mwada bitavinaisi valu Edom. Mitaga wa keda ililoulasi e tomota ikamagwesisi. ");
INSERT INTO kij_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","E ikosomapusi baisa Yaubada deli goli baisa Mosese. Itakulukulusi kawasi, “Avaka paila lokumaiyaimasi metoya wa Itipita, e oviloupakala baisa bakakaligasi paila gala kaula deli sopi? Bogwala kasomatasi kamkwam kaula gagaina wala.” ");
INSERT INTO kij_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Mapaila Guyau iwitali keiyuna naiyayana baisa tomota mina Isireli e bidubadu igadaisi ikaligasi. ");
INSERT INTO kij_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Tomota imakaiasi Mosese e ikaibigasi, kawasi, “Bogwa kamitugagasi avai tuta lakakosomapusi baisa Guyau deli goli baisa yoku. Kunigada baisa Yaubada kidamwa bikau minasina keiyuna.” Mapaila Mosese inigada paila tomota. ");
INSERT INTO kij_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","E Guyau iluki Mosese bibubuli natana keiyuna metoya tanumnumta barasi e bisaili odabala kaitala kai, e availa availa matausina keiyuna eigadaisi kidamwa bigisaisi keiyuna barasi bimovasi wala. ");
INSERT INTO kij_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mapaila Mosese ibubuli keiyuna metoya tanumnumta e isaili odabala kai. E matausina keiyuna bogwa eigadaisi igisaisi minana wa kai e imovasi. ");
INSERT INTO kij_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","E mina Isireli isilavaisi koya Ora e ilosiga ibudaisi si kabosikaiwa mapilana Oboti. ");
INSERT INTO kij_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Oluvi isilavaisi Oboti, ilosiga ibudaisi si kabosikaiwa mapilana Abarim ovilouwokuva oviluwela Mowabi opilibomatu. ");
INSERT INTO kij_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","E oluvi isilavaisi mapilana ilosiga ibudaisi si kabosikaiwa mapilana oItayatilela Seredi. ");
INSERT INTO kij_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Isilavaisi mapilana e ilosiga ibudaisi si kabosikaiwa wa Waya Anoni opiliyavata mapilana vilouwokuva, eikabikabi wala ila mapilana Amora. (Waya Anoni baisa kasi kaligei mina Mowabi toyo mina Amora.) ");
INSERT INTO kij_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Baisa uula mapilana Bukila Guyau la kabilia kala ginigini isisu, “… Waebi mavilouna eitotu oviluwela Supa, itayatila komwaidona, Waya Anoni, ");
INSERT INTO kij_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","deli beibega komwaidona ikabikabi wala eila mapilana Ari e isaitaula wala ila okaligei mapilana Mowabi.” ");
INSERT INTO kij_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","E metoya baisa matausina igalasi ilosi valu yagala Utuwotuwokuva, e baisa Guyau iluki Mosese kawala, “Kumai tomota poulotala, e yeigu basaiki kasi sopi.” ");
INSERT INTO kij_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Wa tuta matutona wala mina Isireli eiwosaisi mapilana wosi kawasi. “Utuwotu kulodusi e deli wosimasi bakamomomsi - ");
INSERT INTO kij_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","E kala tokeli makwaisina gweguya litusia deli tomota kasi tokugwa. Si kaitukwa deli kai ivigakaisi si daima.” Oluvi matausina igalasi metoya ovilouwokuva e ilosi valu yagala Matana, ");
INSERT INTO kij_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","e metoya baisa igalasi ilosi Naalieli, e metoya Naalieli igalasi ilosi Bamoti, ");
INSERT INTO kij_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","e metoya Bamoti igalasi ilosi oitayatilela Mowabi, okuvalila Koya Pisiga biloula oviloupakala. ");
INSERT INTO kij_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","E mina Isireli iwitalaisi biga baisa guyoula Amora matauna yagala Siyoni bilukwaisi kawasi. ");
INSERT INTO kij_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Kutagwala bakasuwaisi om valu. Yakamaisi deli ma bulumakausi gala bakavalaiyaisi keda e bakakalipoulasiga omi bagula bigulesi waini deli gala bakamomsi okami utuwotu, bakaliloulasi wala okadaula tatoula bakavapeilisi kaligeila m valu.” ");
INSERT INTO kij_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mitaga Siyoni gala itagwala mina Isireli bisuwaisi ola valu. Mitaga matauna ikouguguli tokabilia ilosi mapilana Yaasa ovilouwokuva e ikabiliaisi mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mina Isireli ikatumataisi saina bidubadu kasi tilaula, e iyoulisiga si valu, ivitouula wa Waya Anoni ikabikabi goli ila itobu mapilana Yaboka opiliyavata, baisa si valu mina Amoni paila mina Amoni bogwa eipeulasi eivakulotaisi kasi kaligei. ");
INSERT INTO kij_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Mapaila mina Isireli iyoulisi komwaidona mina Amora si valu vilouvakaveka deli goli mavilouna Esiboni, toyo goli komwaidona viloukikekita otalila e isipitalaisi mavilousina. ");
INSERT INTO kij_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","E Esiboni mavilouna Amora la vilouveka e guyau Siyoni matauna mina Amora si guyau, matauna okwaitala eikabiliasi kasitaiyu guyoubogwa guyoula Mowabi e iyouli komwaidona la pwaipwaia ikabikabi wala ila itobu wa Waya Anoni. ");
INSERT INTO kij_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Baisa uula tobutusi wosi kasi wosi ikaibiga, “Kumaisi Esiboni mavilouna guyau Siyoni la vilouveka! Magimasi bakagisaisi bukukwaliivauwaisi deli bukuvigivauwaisi mavilouna. ");
INSERT INTO kij_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Kwaitala tuta metoya vilouveka Esiboni, Siyoni la tokabilia ilosi makawala kovatala kova. E makovana ivakakovi vilouveka Ari olumoulela Mowabi. Deli ivakagoli wala koyala Anoni mapilana walakaiwa. ");
INSERT INTO kij_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mina katudewa gaga yokomi mina Mowabi! Yokomi kutapwarorusi baisa tokolu Kemosi bogwa lokubodasi kami mwau! Mi yaubada ivigaki tauwau komwaidona bisakaulasi metoya kabosilagi. Deli ivigaki vivila komwaidona la tokatupipi guyoula Amora. ");
INSERT INTO kij_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Mitaga baisa tuta dalesi komwaidona bogwa wala eidoumlabasi, metoya Esiboni bila itobu Diboni, metoya Nasim bila itobu Nopa katitaikinela Medeba komwaidona dadaimiwokuva wala.” ");
INSERT INTO kij_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Mapaila mina Isireli imilivalusi oviluwela mapilana Amora, ");
INSERT INTO kij_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","e oluvi Mosese iwitali tauwau binevaisi avai keda ibwainaki paila biyoulisi valu Yasa. Mina Isireli iyoulisi mavilouna deli goli viloukikekita opapala; e ibokavilaisi komwaidona mina Amora ibutusi. ");
INSERT INTO kij_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Oluvi mina Isireli isilavaisi Yasa i tovilasi e ikatubwatakaisiga kedala Basani, e Ogi guyoula Basani deli la tokabilia ivalapulasi mwada bikabiliasi deli matausina mapilana Edirei. ");
INSERT INTO kij_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Mitaga Guyau iluki Mosese kawala, “Gala bukukukoli matauna, yeigu wala bavigakaim bukutomgwaga odabala matauna deli la tomota deli bukuyouli la valu. Bukuvigaki matauna makawala lokuvigaki Siyoni matauna mina Amora si guyau eikikaraiwogi vilouveka Esiboni.” ");
INSERT INTO kij_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","E mina Isireli ikatumataisi Ogi deli litula, deli goli la tomota komwaidona, gala goli kesa, e iyoulisi la valu komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Mina Isireli ililoulasi e ibudaisi si kabosikaiwa Mowabi opilibomatu oitayatilela Waya Yoridani opiliyuwela baisa Yeriko. ");
INSERT INTO kij_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","E taitala guyau isisu, matauna guyoula Mowabi, Sipora latula yagala Balaki. E ilagi bulogala avaka mina Isireli eivagaisi baisa mina Amora e deli taivila kasi bawa. ");
INSERT INTO kij_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","E matauna deli mina Mowabi komwaidosi saina ikokolasi. ");
INSERT INTO kij_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","E mina Mowabi ililivalasi baisa mina Midiani tokwaraiwogala valu, e kawasi, “Baisa saina bidugaga tomota makateki bikatudidaimisi avaka avaka oda valusi, makawala bulumakau namwala bikamdubuni komwaidona mnumonu bwaina.” E mapaila guyau Balaki ");
INSERT INTO kij_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","iwitali la touwata bidouwaisi Beori latula matauna Balam bimakaia matauna. Matauna isisu mapilana Petoro katitaikinela Waya Yupereiti mapilana Amawa. Isakaisi biga makwaina metoya baisa guyau Balaki kawala, “Magigu bukunikoli boda mabudona metoyasi Itipita leimaisi ikaligiaki valu komwaidona, e bivaiyoulaisi da pwaipwaiasi. ");
INSERT INTO kij_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","E matausina kasi bawa ikalisauwaimasi. Mapaila anigadaim mwada bukuma bukubuloti matausina. E oluvi kainaga bakapeulasi bakakalisauwaisi bakabokavilaisi metoya oma valusi. Paila bogwa anikoli matausina availa availa kukwabwaili bibwainasi, e matausinaga availa availa kubuloti bibodasi mwau.” ");
INSERT INTO kij_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","E mina Mowabi deli mina Midiani tokwaraiwogala valu ikauwaisi sosula mapula ilokaisi Balam e ilivalaisi Balaki la biga. ");
INSERT INTO kij_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balam iluki matausina, kawala, “Kukwanamwaisi bogi makwaina baisa e igau nabwaia balukwaimi avaka Guyau Yaubada bilukwaigu.” Mapaila mina Mowabi tokwaraiwogala valu isikailisi Balam. ");
INSERT INTO kij_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","E Yaubada imakaia Balam ikatupoi, kawala, “Ki, availa matausina isisuaisi deli yoku?” ");
INSERT INTO kij_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ivitakaula, kawala, “Matauna Balaki guyoula Mowabi eiwitali matausina eimaisi bilukwaigusi ");
INSERT INTO kij_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","kidamwa matausina tomota leimaisi metoyasi Itipita bogwa leisipitalaisi pwaipwaia. E matauna magila bala babuloti matausina paila wala matauna, kidamwa matauna gagabila biyowai deli matausina e bibokavili bisunapulasi.” ");
INSERT INTO kij_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Yaubada iluki Balam, kawala, “Gala bukulosi deli matausina e deli gala bukubuloti mina Isireli, paila yeigu bogwa lakabwaili matausina.” ");
INSERT INTO kij_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Eiyam kaukwau Balam ilokaia la touwata Balaki e ikaibiga, “Bukukwaimilavausi omi valu. Guyau Yaubada gala itagwala bawokaiami.” ");
INSERT INTO kij_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Mapaila ikaimilavausi baisa Balaki ilukwaisi kidamwa Balam eipaiki gala magila deli bimaisi. ");
INSERT INTO kij_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","E Balaki iwitalivau bidubadu tokwaraiwaga, e matausina saina todidabala gala makawala tolobogwa. ");
INSERT INTO kij_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ilokaiasi Balam e isakaisi biga metoya Balaki. E Balaki kawala, “Anigadaim taga bukutagwala avai kabosilaboda bisilibodaim paila bukumakaiagu. ");
INSERT INTO kij_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Bogwa bamapwaim saina vakaigaga e avaka bukulivala bavagi wala. Akoma lopom, bukuma wala bukubuloti tomota matausina paila yeigu.” ");
INSERT INTO kij_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mitaga Balam ivitakaula, kawala, “Kaina goli bisakaigu komwaidona la siliba deli la goula metoya ola ligisa, mitaga gala wala gagabila bakoulovi Guyau ulo Yaubada la karaiwaga. Kaina binigadaigu mwada vavagi pikekita wala bavagi, mitaga ibodi wala bakabikaula Guyau ulo Yaubada. ");
INSERT INTO kij_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Mitaga bwaina wala yokomi bukukwanamwaisi makawala semia eivagaisi, kidamwa babani kaina Guyau mwada bilukwaigu avai vavagi tuvaila.” ");
INSERT INTO kij_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Makwaina bogi Yaubada imakaia Balam ikaibiga, kawala, “Kidamwa matausina bogwa leimaisi e ilukwaimsi mwada deli bukulosi, bwaina wala kukwatubaiasa paila bukulosi, mitaga bukuvagi wala avaka balukwaim.” ");
INSERT INTO kij_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","E eiyam kaukwau itokaia ikatubiasi la ase e ilosi deli matausina mina Mowabi kasi tokwaraiwaga. ");
INSERT INTO kij_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","E Yaubada igibuluwa paila Balam bila, e wa tuta matutona Balam isisakaula ola ase, deli la tosikwawa taiyu, e Guyau la anelosi itotu olopola keda paila bivabodi la keda Balam. ");
INSERT INTO kij_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Avai tuta ase minana igisi anelosi itotu e oyamala kaitala puluta, e ivalai keda ikalupoula ila wa bagula. Mitaga Balam iwaiya minana e ikaimilivau wa keda. ");
INSERT INTO kij_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mapaila anelosi itoli ambaisa keda eivasisikwa oluwalaisi kwaiyu waini bigulela makwaisina kalisi iwakaisi dakwa. ");
INSERT INTO kij_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Avai tuta minana ase igisi anelosi, ivabilibili ikanuvateta wa dakwa e ikanumkumku Balam kaikela. E tuvaila wala Balam iwaiya ase minana. ");
INSERT INTO kij_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","E anelosi ivasekala tuvaila, e itoli ivabodi makatupona saina kadasisikwa gala gagabila kaboloula. ");
INSERT INTO kij_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","E malilouna, avai tuta ase igisi anelosi, ikenu. Balam igibuluwivagasi ivitouula inobwau minana deli la lewa. ");
INSERT INTO kij_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Mapaila Guyau isaiki minana peula paila bigatona, e ikaibiga baisa Balam, kawala, “Avaka avigakaim? Avaka paila lokuwaigu sivatolu?” ");
INSERT INTO kij_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balam ivitakauloki, kawala, “Paila uula lokuvigakaigu makawala tonagowa! Ka, kidamwa kaitala puluta baiyosi e bogwa bakatumataim.” ");
INSERT INTO kij_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","E ase ivitakauloki, kawala, “Ki, kaina gala yeigu minawena lokusikailagu om tuta komwaidona? Ki, sitana kwaitala tuta avigakaim makawala?” Balam ivitakaula, kawala, “Gala wala!” ");
INSERT INTO kij_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","E baisa tuta Guyau itagwala Balam bigisi anelosi itotu omatala deli la puluta, e Balam ikapusi ikanaiki lopola opwaipwaia. ");
INSERT INTO kij_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","E anelosi iluki, kawala, “Avaka paila kusivatolu kuwawaiya m ase? Lama paila bavabodi m keda. Paila gala ibodaim bukula makadana. ");
INSERT INTO kij_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Mitaga m ase igisaigu e iuwovila sivatolu. Kidamwa gala bivagi makawala, bogwa bakatumataim e bakoli minana ase.” ");
INSERT INTO kij_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balam ivitakaula, kawala, “Bogwa lamitugaga. Gala anikolaim yoku lokutotu wa keda paila bukusilibodaigu. Mitaga kidamwa kudoki baisa sula paila yeigu bala, e bwaina wala, bakaimilavau ogu valu.” ");
INSERT INTO kij_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mitaga anelosi ikaibiga, kawala, “Kukwatuwakeda deli matausina, mitaga avaka balukwaim e baisa wala bukulivala.” Mapaila Balam ikatuwakeda deli matausina. ");
INSERT INTO kij_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","E avai tuta Balaki ilagi bulogala Balam bogwa leima, e ilokaia bibodi matauna mapilana Ari, makwaina kwaiveka valu opapala Waya Anoni okaligeila Mowabi. ");
INSERT INTO kij_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","E Balaki iluki matauna, kawala, “Avaka paila gala kuma avai tuta lawitalibogwi kam kwaikivi? Kudoki m nanamsa gala tona mapu basakaim?” ");
INSERT INTO kij_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","E Balam ivitakauloki, kawala, “Bogwa lama kainaga! Mitaga baisa tuta ammakawala balivala biga peula kidamwa gala isim ulo karaiwaga? Mitaga balivala wala avaka Yaubada bilukwaigu.” ");
INSERT INTO kij_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","E Balam sola Balaki ilosi ovalu Usota. ");
INSERT INTO kij_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","E baisa leikatumataisi Balaki la bulumakau deli la sipi e isaiki kabilavila baisa Balam deli matausina tokugwa eimaisi deli matauna. ");
INSERT INTO kij_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Eiyam kaukwau Balaki sola Balam itokaiasi e ilosi Bamoti Beali, ambaisa Balam gagabila bigisi mimilisi mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","E iluki Balaki, kawala, “Kukwaliai kwailima kwaiyu kabolula baisa paila yeigu, e kumai nalima nayu bulumakau nammwala deli nalima nayu sipi nammwala.” ");
INSERT INTO kij_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaki ivagi avaka eiluki. E matauna sola Balam igabwaisi natana bulumakau deli natana sipi odubasi kabolula kwaitala kwaitala. ");
INSERT INTO kij_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Oluvi Balam iluki Balaki, kawala, “Kutoli baisa opapala m lula kwegubugabu e igaugwa alokaia bagisi kaina Guyau bibodaigu kaina gala. E igau balukwaim avaka bilukwaigu.” E matauna kalamwaleta ila wa koya. ");
INSERT INTO kij_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","E Yaubada ibodi matauna. E Balam iluki Guyau, kawala, “Bogwa lakaliai kwailima kwaiyu kabolula e lagabu lula bulumakau natana deli sipi natana odubasi kwaitala kwaitala makwaisina.” ");
INSERT INTO kij_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","E Guyau iluki Balam avaka bilivala e iluki matauna bikaimilavau baisa Balaki bisola Guyau la biga baisa matauna. ");
INSERT INTO kij_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","E ikeiita ibani Balaki eitotu opapala la lula kwegubugabu deli goli komwaidosi kasi tokwaraiwaga mina Mowabi. ");
INSERT INTO kij_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balam ivitoubobuta baisa makawala. “Matauna Balaki guyoula Mowabi eimaiyaigu metoya mapilana Siria, e metoya wa koya opilibomatu. Kawala, ‘Kuma kulivala paila yeigu. Bukubuloti mina Isireli.’ ");
INSERT INTO kij_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ammakawala babuloti avaka Yaubada gala ibuloti, kaina balivala paila kaliga avai tuta Guyau gala wala eilivala makawala? ");
INSERT INTO kij_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Metoya dukutotu saina walakaiwa gagabila bagisi matausina. E igagabila bavitusi matausina metoya wa koya. Matausina makwaina boda eisisuaisi kasimwaleta. Bogwa eikatetasi kidamwa Yaubada eikabwaili matausina, gala makawala boda ituwoli. ");
INSERT INTO kij_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Dalela Isireli makawala tubumyou. Matausina saina bidugaga gala gagabila bitakalau. Ibodaigu bavigimkulovi ulo tuta ovalu watanawa makawala taitala Yaubada la tomota. Ibodaigu bakaliga duwosisia wala makawala tomitukwaibwaila.” ");
INSERT INTO kij_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","E Balaki ivitakauloki Balam, kawala, “Avaka kuvagi baisa yeigu? Yeigu lamaiyaim baisa paila mwada bukubuloti agu tilaula, mitaga yoku lokukwabwaili wala matausina.” ");
INSERT INTO kij_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","E Balam ivitakauloki, kawala, “Yeigu gagabila balivala mesinaku wala avaka Guyau bilukwaigu balivala.” ");
INSERT INTO kij_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","E oluvi Balaki ikaibiga baisa Balam, kawala, “Kuma bitala kwaiyuwela valu e baisa igagabila bukugisi mimilisi wala mina Isireli, e metoya baisa bukubuloti matausina paila yeigu.” ");
INSERT INTO kij_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ivakouli matauna ilau obaleku Sopim odabala Koya Pisiga. Baisa tuvaila ikaliai kwailima kwaiyu kabolula e igabu natana bulumakau namwala deli natana sipi namwala odubasi kwaitala kwaitala makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balam ikaibiga baisa Balaki, kawala, “Kutotu baisa opapala m lula kwegubugabu e yeigu bala baisʹe babodi Yaubada.” ");
INSERT INTO kij_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","E Yaubada ibodi Balam e iluki matauna avaka bilivala, deli iwitali matauna bikaimilavau baisa Balaki paila bisola Guyau la biga baisa matauna. ");
INSERT INTO kij_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Mapaila ikaimilavau e ibani Balaki itotu wala opapala la lula kwegubugabu deli tokwaraiwaga mina Mowabi. E Balaki ikatupoi avaka Guyau eilivala. ");
INSERT INTO kij_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","E Balam ivitoubobuta baisa makawala. “Balaki yoku Sipora latula, kuma, e bukulagi avaka balukwaim. ");
INSERT INTO kij_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Yaubada gala makawala tomota tosisasopa. Guma watanawa tuta tuta ikivilivau nanola mitaga Yaubada gala makawala. Avai vavagi ikatotila bivagi e bogwa bivagi wala. Eililivala e bogwa eikaloubusi. ");
INSERT INTO kij_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Bogwa eikaraiwogaigu paila bakabwaila. E avai tuta Yaubada bikabwaili, yeigu gala gagabila badouyumali. ");
INSERT INTO kij_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Bogwa lagisibogwi paila mina Isireli tuta oluvi kidamwa gala bibodasi mwau kaina pakula, paila Guyau si Yaubada deli matausina, e matausina ikamitulaisi matauna si Guyau. ");
INSERT INTO kij_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Yaubada eikaimilivau matausina metoya Itipita. Iyowai paila matausina makawala bulumakau nabolodila. ");
INSERT INTO kij_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Baisa gala isisu avai silami deli avai mlukwausa gagabila biyogagaisi mabudona mina Isireli. Tuta baisa tomota bikaibigasi paila mina Isireli, kawasi, ‘Kugisaisi avaka Yaubada bogwa leivagi.’ ");
INSERT INTO kij_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","E mabudona mina Isireli makawala laiyoni napeula, gala wala bivaiwasi tatoula wala bigadi bikamtumtu tatoula bimom buyavi metoya minasina bogwa eikamati.” ");
INSERT INTO kij_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","E Balaki ikaibiga baisa Balam kawala, “Ka, lokupaiki bukubuloti mina Isireli. Mitaga anigadaim gala bukukwabwaili matausina.” ");
INSERT INTO kij_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balam ivitakauloki, kawala, “Kaina gala alukwaim mwada bogwa bavagi vavagi komwaidona avaka Guyau leilukwaigu.” ");
INSERT INTO kij_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","E Balaki ikaibiga kawala, “Kuma deli yeigu bitala balauwaim ituwoli valu. Kaina Yaubada bitagwala bukubuloti matausina paila yeigu metoya mapilawena. ");
INSERT INTO kij_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","E ivamwenei Balam odabala Koya Peora ambaisa metitoki baisa viloupakala opapala. ");
INSERT INTO kij_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balam iluki matauna kawala, “Kukwaliai kwailima kwaiyu kabolula paila yeigu e baisa kumai nalima nayu bulumakau nammwala deli nalima nayu sipi nammwala.” ");
INSERT INTO kij_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","E Balaki ivigaki makawala eiluki, e igabu natana bulumakau namwala deli natana sipi namwala odubasi kwaitala kwaitala kabolula makwaisina. ");
INSERT INTO kij_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Makwaina tuta wala Balam inikoli Guyau magila bikabwaili mina Isireli, e mapaila gala ila ivitoki tolosila avai kabovitoubobuta makawala eiuvagi omitibogwa. Itovila itovilaki viloupakala ");
INSERT INTO kij_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","e igisi mina Isireli eibudaisi si kabosikaiwa dala kwaitala kwaitala. E Yaubada bilomala iviyelu nanola matauna, ");
INSERT INTO kij_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","e ivitoubobuta baisa makawala. “Baisa ulo biga yeigu Beori latula, yeigula Balam. Baisa goli yeigu ulo biga, e bogwa agisimlili, ");
INSERT INTO kij_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","e yeigu gagabila balagi avaka Yaubada eililivali. Amitatobu agigisi metoya wa mimi, agigisi kilisala metoya baisa Yaubada Topeuligaga. ");
INSERT INTO kij_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Si buliyoyova mina Isireli kwemminabwaita sainela, ");
INSERT INTO kij_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","makawala pitalela pulopola saina kasawonaku, kaina bagula opapala waya. Makawala lileikoya avaka Guyau eivali, kaina makawala kweisila opapala waya. ");
INSERT INTO kij_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Bogwa bibanaisi bidubadu kuna, deli bisapwaisi kasi yagogu obilekula outuwotu. Si guyau la karaiwaga bikalisau guyau Agagi, e la kabokwaraiwaga kala kaduwonaku deli kala beiyaya. ");
INSERT INTO kij_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Yaubada eivisunupuloi matausina metoya mapilana Itipita, e iyowai paila matausina makawala bulumakau nabolodila. Ikatumtuwolisi kasi tilaula, ikatumkumkwaisi tutuwanesi e deli ikomtumtaisi si kaiyala. ");
INSERT INTO kij_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Makwaina boda makawala wala laiyoni napeuligaga. Avai tuta eimmasisi, gala wala taitala totuvaluwa biyommati. Availa availa ikabwailisi mina Isireli, e matausina tuvaila Guyau Yaubada bikabwaili. E availa availa ibulotaisi mina Isireli, e matausina tuvaila Guyau Yaubada bibuloti.” ");
INSERT INTO kij_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","E Balaki ikinunuma yamala e deli la gidaleiya iluki Balam, “Yeigu ladouwaim paila bukubuloti agu tilaula, mitaga kaimapula lokukwabwaili wala iboda sivatolu. ");
INSERT INTO kij_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Nani wala baisa tuta bukula om valu. Alivalabogwa biga katotila paila bamapwaim, mitaga Guyau gala itagwala yoku bukukwau mapu makwaina.” ");
INSERT INTO kij_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","E Balam ivitakaula kawala, “Bogwa laluki m touwata matausina lokuwitali agu tokaikivi, ");
INSERT INTO kij_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","kawagu kidamwa yoku bukusakaigu komwaidona siliba deli goula olopola m ligisa, yeigu gala wala igagabila bakoulovi avaka la karaiwaga Guyau paila mwada bavagi avaka titoulegu. Yeigu balivala avaka wala Guyau eilukwaigu balivala.” ");
INSERT INTO kij_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","E Balam iluki Balaki, kawala, “Baisa tuta yeigu bakaimilavau balokaia ulo tomota tatougu, mitaga ikugwa bakatululutaim paila avaka mina Isireli bivigakaisi m tomota igau tuta oluvi, e oluviga bala.” ");
INSERT INTO kij_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","E ivitoubobuta baisa makawala, “Baisa ulo biga yeigu Beori latula, yeigula Balam. Baisa goli yeigu ulo biga, e bogwa agisimlili, ");
INSERT INTO kij_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","e yeigu gagabila balagi avaka Yaubada eililivali e babani kabitam metoya baisa matauna Towalakaiwa Sainela. Amitatobu agigisi metoya wa mimi, agigisi kilisala metoya baisa Yaubada Topeuligaga. ");
INSERT INTO kij_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Agisibogwi avaka igau tuta bima, deli agisi mabudona mina Isireli. Taitala guyau igau biyuwoula metoya boda makwaina, matauna makawala natana utuyam saina visigala, kaina makawala utuyam isim yeyunela, e matauna biyoulapula metoya wa Isireli. Matauna biwaiya tokugwala Mowabi e bikapusisi, deli goli bivakapusii komwaidosi mina Seti. ");
INSERT INTO kij_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Matauna bitomgwaga odubasi kala tilaula mapilana Edom, e bivigaki si valu kala bigukeya. Tuta komwaidona mina Isireli bitomgwagasi wala. ");
INSERT INTO kij_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","E mina Isireli bivapupoiyaisi matausina, e bikatumtuwolisi kesala matausina.” ");
INSERT INTO kij_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","E Balam okilisala igisi mina Amaleki, e ivitoubobuta baisa makawala, “Mina Amaleki saina mina peuligaga odubasi avai boda avai boda, Mitaga igau kala vigimkovila mabudona bitamwauvagasisi.” ");
INSERT INTO kij_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","E tuvaila okilisala igisi mina Keni, e ivitoubobuta baisa makawala, “Kabosisu makwaina lokusisiki kwaipeuligaga, makawala avai nigwa eikaliai odubadabila. ");
INSERT INTO kij_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mitaga avai tuta mina Asiria bikatupipaimi, e yokomi mina Keni bukutamwausi.” ");
INSERT INTO kij_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balam ivitoubobuta baisa makawala, “Avai tomota matausina eigugugulasi baisa opiliyavata? ");
INSERT INTO kij_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Tokwabilia bikewasi metoya Saipirosi, e biyoulisi Asiria deli Eba. Mitaga igau tuta bima matausina tokwabilia tuvaila bitamwauvagasisi.” ");
INSERT INTO kij_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","E Balam ikatubaiasa ikaimilavau ila ola valu e Balaki isaitaula wala ila ola keda. ");
INSERT INTO kij_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Avai tuta mina Isireli ibudaisi si kabosikaiwa oItayatilela Akakia, e tauwau imisiaisi vilesi Mowabi. ");
INSERT INTO kij_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Vivila minasina ivakoulisi matausina ilauwaisi okasi paka makatupona tuta komwaidona bititaimamilasi baisa minana si yaubada tokolu. Mina Isireli ikomasi kalagila deli itemmalaisi minana tokolu ");
INSERT INTO kij_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Beali mina Peori si yaubada. Mapaila Guyau saina igibuluwi matausina ");
INSERT INTO kij_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","e iluki Mosese kawala, “Ibodi bukukwabikuwolaigu makawala - kuvakouli komwaidona tokugwala Isireli e kukwatumati matausina omilakatila, e yeigu gala tuvaila bagibuluwi mina Isireli.” ");
INSERT INTO kij_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mosese iluki komwaidona tokaraiwaga kawala, “Taitala taitala yokomi ibodi bikatumati metoya odalela titoulela matausina bogwa eitugwalaisi titoulesi itemmalaisi baisa tokolu Beali mina Peori si yaubada.” ");
INSERT INTO kij_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","E tuta matutona wala matausina iuvalamsi omatala Guyau la Buliyoyova, taitala sasi wala guma Isireli ivakouli natana vilela Midiani e ilau ola buliyoyova titoulela omatala wala Mosese deli goli komwaidona tomota. ");
INSERT INTO kij_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","E Peniasi matauna Eleasa latula e Eroni tolula tabula. Tutala Peniasi igisi baisa, itokaia isilavi tomota komwaidona. Matauna ikau kaitala kaiyala, ");
INSERT INTO kij_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","e isaitaula wala ilokaia tau matauna sola vivila obuliyoyova, e ikopituki wala kasitaiyu okaiyala. E baisa makawala katudoum makwaina lelia saina mwaugaga eiyogagi mina Isireli iwokuva. ");
INSERT INTO kij_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Mitaga tomota bogwa leikaligasi kasi bawa 24,000. ");
INSERT INTO kij_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Ka avaka Peniasi leivagi baisa ivigaki gala tuvaila bagibuluwi mina Isireli. Matauna gala itagwala availa bitaimamila baisa avai yaubada, mitaga agumwaleta wala, mauula gala akatumtuwoli matausina metoya ogu gibuluwa. ");
INSERT INTO kij_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Mapaila kuluki matauna kidamwa yeigu babigakatotila deli matauna tuta baisa e bikanuvagasi goli. ");
INSERT INTO kij_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Yeigu bogwa lakamokwita matauna deli dalela komwaidona bimila tolulasi tuta komwaidona; paila uula matauna gala itagwala avai yaubada bisisu kaimapugu e baisa makawala eivigaki tomota si mitugaga kala ligaiwa.” ");
INSERT INTO kij_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","E Simri matauna Salu latula, matauna tokugwala kwaitala boda metoya Simioni odalela. Peniasi bogwa eikatumati Simri sola natana vilela Midiani. ");
INSERT INTO kij_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Minana yagala Kosibi, tamala yagala Sura, matauna guyoula kwaitala boda metoya Midiani. ");
INSERT INTO kij_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","E Guyau ikaraiwogi Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Kusuvi kukwabilia deli mina Midiani e kukwatudidaimi si valu komwaidona, ");
INSERT INTO kij_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","paila bogwa leivagaisi sula baisa yokomi tuta matutona leisinapwaimi mapilana Peori; deli paila minana Kosibi eikatumati tuta makwaina lelia kala tuta mapilana Peori.” ");
INSERT INTO kij_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Avai tuta lelia mwau makwaina bogwa leiwokuva, Guyau iluki Mosese sola Eleasa matauna Eroni latula kawala, ");
INSERT INTO kij_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Komwaidona dala Isireli kusonukulaisi avaka tauwau kasi bawa matausina kasi taitu kweluwoyu kaina bila walakaiwa matausina goli ibudoki bikabisi okawakali.” ");
INSERT INTO kij_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Mosese sola Eleasa ivagaisi makawala, matausina ikougugulasi gulitinidesi okabatau mapilana Mowabi opapala Waya Yoridani kibubotala valu Yeriko. Mabudona mina Isireli metoyasila Itipita leimaisi. ");
INSERT INTO kij_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubeni matauna Yekobe la molitomoya. E Rubeni dalela eitetila metoya odalesi Anoki, Palu, ");
INSERT INTO kij_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Esironi, deli Kami. ");
INSERT INTO kij_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Dala madalasina kasi bawa 43,730 tauwau wala. ");
INSERT INTO kij_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","E dalela Palu matausina Eliabi ");
INSERT INTO kij_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","deli litula, Nemueli, Datani, deli Abiram. (E Datani sola Abiram matausina tomota komwaidona inagaisi paila bitokugwasi. Mitaga matausina ipakaisi Mosese sola Eroni e ilokaiasiga Kora ola boda, e ikoulovaisi Guyau. ");
INSERT INTO kij_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","E mapaila pwaipwaia ikapogega ilupoli matausina, e matausina Kora deli goli la boda komwaidona ikaligasi tuta matutona wala kova eivakadoum tauwau kasi bawa 250; baisa ivigaki tomota si kabogigisa. ");
INSERT INTO kij_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mitaga Kora litula tauwau gala ikaligasi.) ");
INSERT INTO kij_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simioni dalela eitetila metoya odalesi Nemueli, Yamini, Yakini, ");
INSERT INTO kij_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Sera, deli Sauli. ");
INSERT INTO kij_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Dala madalasina tauwau kasi bawa 22,200. ");
INSERT INTO kij_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gada dalela eitetila metoya odalesi Seponi, Agi, Suni, ");
INSERT INTO kij_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Osini, Iri, ");
INSERT INTO kij_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arodi, deli Areli. ");
INSERT INTO kij_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Dala madalasina tauwau kasi bawa 40,500. ");
INSERT INTO kij_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Yuda dalela eitetila metoya odalesi Sela, Peresi, Sera, Esironi, deli Amli. (Taiyu Yuda litula, Eri sola Onani, eikaligasi mapilana Kenani.) ");
INSERT INTO kij_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Dala madalasina kasi bawa tauwau 76,500. ");
INSERT INTO kij_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isaka dalela eitetila metoya odalesi Tola, Puwa, ");
INSERT INTO kij_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasuba, deli Simroni. ");
INSERT INTO kij_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Dala madalasina kasi bawa tauwau 64,300. ");
INSERT INTO kij_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sebuloni dalela eitetila metoya odalesi Seredi, Eloni, deli Yaleeli. ");
INSERT INTO kij_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Dala madalasina kasi bawa tauwau 60,500. ");
INSERT INTO kij_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yosepa dalela eitetila metoya litula taiyu Manasa sola Epereim. ");
INSERT INTO kij_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasa dalela eitetila metoya odalela Makira matauna Manasa wala latula; e Makira latula Giliadi, e dala madalasina eikitetilasi metoya odalela Giliadi. ");
INSERT INTO kij_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","dala madalasina Yesa, Eleki, ");
INSERT INTO kij_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asirieli, Sekem, ");
INSERT INTO kij_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida deli Epera, ");
INSERT INTO kij_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selopeyadi matauna Epera latula matauna gala litula tauwau mitaga vivilawokuva wala, e yagasi Mala, Nowa, Ogila, Milika deli Tesa. ");
INSERT INTO kij_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Dala madalasina tauwau kasi bawa 52,700. ");
INSERT INTO kij_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Epereim dalela eitetila metoya odalesi Sutela, Bekeri deli Taana. ");
INSERT INTO kij_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","E Erani dalela eikitetila metoya baisa mabudona Sutela. ");
INSERT INTO kij_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Dala madalasina kasi bawa tauwau 32,500. E dala madalasina eitetila metoya odalela wala Yosepa. ");
INSERT INTO kij_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Beniamina dalela eitetila metoya odalesi Bela, Asibeli, Airam, ");
INSERT INTO kij_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sepupam, deli Upam. ");
INSERT INTO kij_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","E dalesi Adi sola Nemani eitetilasi metoya baisa Bela. ");
INSERT INTO kij_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Dala madalasina kasi bawa tauwau 45,600. ");
INSERT INTO kij_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dani dalela eitetila metoya odalela Usim. ");
INSERT INTO kij_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Kasi bawa tauwau 64,400. ");
INSERT INTO kij_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asera dalela eitetila metoya odalesi Imna, Isivi deli Beria. ");
INSERT INTO kij_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ebera sola Malikieli eikitetilasi metoya Beria dalela. ");
INSERT INTO kij_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asera latula vivila yagala Serai. ");
INSERT INTO kij_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Kasi bawa tauwau 53,400. ");
INSERT INTO kij_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Napitalai dalela eitetila metoya odalesi Yaseeli, Guni, ");
INSERT INTO kij_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yesera, deli Silem. ");
INSERT INTO kij_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Madalasina kasi bawa tauwau 45,400. ");
INSERT INTO kij_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Komwaidona mina Isireli tauwau kasi bawa iboda 601, 730. ");
INSERT INTO kij_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Kukwalituli valu makwaina kusagali baisa dala komwaidona makawala avaka bibodi kala vakaila si boda. ");
INSERT INTO kij_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","56","Kukwalituli valu makwaina metoya kukowobobuta e kusaiki katupovakaveka baisa dala kwevakaveka, e katupokikekita baisa dala kwekikekita.” ");
INSERT INTO kij_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Libai dalela eitetila metoya odalesi Gerisoni, Kowati, deli Merari. ");
INSERT INTO kij_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Deli goli dalesi tuvaila Libini, Ebironi, Mali, Msi, deli Kora. E Kowati latula Amram, ");
INSERT INTO kij_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","matauna ivaiya Libai latula Yokebedi. Minana meunaisi Itipita, e metoya baisa Amram eiuni taiyu litula tauwau, Eroni sola Mosese, e natana latula vivila yagala Miriam. ");
INSERT INTO kij_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Eroni litula tauwau taivasi yagasi Nadaba, Abiu, Eleasa deli Itama. ");
INSERT INTO kij_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadaba sola Abiu ikaligasi avai tuta eigabwaisi lula baisa Guyau metoya wa kova kovamakava. ");
INSERT INTO kij_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Mina Libai gugwadi tauwau kasi tubukona natana kaina walakaiwa kasi bawa iboda 23,000. Magudisina kasi kakalawa imwaisi wala ituwoli gala deli komwaidona mina Isireli paila uula gala wala isim kasi vilavila olopola Isireli. ");
INSERT INTO kij_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","E Mosese sola Eleasa bogwa leiginaisi kasi bawa komwaidona dala madalasina tuta makwaina leisonukulaisi kasi bawa mina Isireli okabatau mapilana Mowabi opapala Waya Yoridani kibubotala biloula Yeriko. ");
INSERT INTO kij_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Ilagoli gala taitala ikesa oluwalaisi matausina bogwa leisonukulibogwisi Mosese sola Eroni mapilana Sinai Viloupakala. ");
INSERT INTO kij_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","E Guyau bogwa eiluki komwaidosi tomota bikaligasi wala oviloupakala, e komwaidosi goli eikaligasi mesinaku wala Keleba matauna Yepunei latula, deli Yosuwa matauna Nuni latula kasimwaleta wala eimovasi. E komwaidosiga ikaligasi. ");
INSERT INTO kij_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Mala, Nowa, Ogila, Milika deli Tesa minasina Selopeyadi litula, matauna Epera latula, Epera matauna Giliadi latula Giliadi matauna Makeli latula, Makeli matauna Manasa latula Manasa matauna Yosepa latula. ");
INSERT INTO kij_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Minasina ilosi itotusi omitasi Mosese, Eleasa tolula, tokugwa deli komwaidona tomota omatala Guyau la Buliyoyova e ikaibigasi kawasi, ");
INSERT INTO kij_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Ka, tumamaisi bogwa leikaliga ovilouwokuva, deli gala wala isim litula tauwau. Matauna gala deli mabudona kala tobwakuli Kora, matausina ikoulovaisi Guyau; matauna leikaliga paila uula la mitugaga titoulela. ");
INSERT INTO kij_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Avaka paila tumamaisi yagala bitamwau olopola Isireli paila wala gala isim litula tauwau? Ibodi wala bukusakaimasi pwaipwaia avaka tumamaisi kala vilavila metoya odalela.” ");
INSERT INTO kij_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","E Mosese ikamituli baisa Guyau paila mwau makwaina. ");
INSERT INTO kij_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","E Guyau iluki matauna kawala, ");
INSERT INTO kij_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Avaka Selopeyadi litula vivila si nanamsa eilivalasi duwosisia wala; kusaiki sitana minasina kasi vilavila metoya tumasi veyala eiyosisi. Ibodi tumasi la guguwa sitana biyosisi kasi bigukeya. ");
INSERT INTO kij_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Kuluki mina Isireli komwaidona kidamwa avai tau bikaliga e gala isim latula tau e latula vivila ibodi biyosi bigukeyala tamala komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Mitaga kidamwa gala litula vivila, ibodi wala tuwala kaina budala biyosisi kasi bigukeya komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Kidamwa matauna gala tuwala kaina budala, ibodi wala tamala tuwala kaina budala biyosisi kasi bigukeya komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Mitaga kidamwa matauna gala tuwala kaina budala kaina goli kadala, tuvaila ibodi wala availa vaiyola ivakatitaikina baisa matauna biyosi bigukeya makwaina, bivigaki la vavagi tatoula. E mina Isireli komwaidona bikabikuwolaisi karaiwaga makwaina bivigaki kasi karaiwaga kwekanigaga. Baisa makawala yeigu Guyau bogwa lakaraiwogaim.” ");
INSERT INTO kij_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","E Guyau ikaibiga baisa Mosese, kawala, “Kumwena wa Koya Abarim e bukugisi valu komwaidona lasisaiki mina Isireli. ");
INSERT INTO kij_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Avai tuta bukugisi makwaina e oluvi bukukwaliga, makawala goli tuwam Eroni. ");
INSERT INTO kij_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Paila uula kamitaiyu wala lokukosomapwaisi ulo karaiwaga olumoulela oviloupakala mapilana Sini. Avai tuta boda komwaidona itakulukulusi baisa yeigu mapilana Meriba, e lokupakaisi ulo peula kwebumaboma omitasi matausina.” (Meriba makwaina utuwotu mapilana Kedesi olumoulela oviloupakala Sini.) ");
INSERT INTO kij_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mosese inigada, kawala, ");
INSERT INTO kij_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Mwa Guyau Yaubada, yoku tolimomova, anigadaim, bukunagi taitala, matauna igagabila bikugwai m tomota, ");
INSERT INTO kij_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","deli igagabila bikugwai matausina otutala kabilia, kidamwa mabudona m tomota gala bivigaki makawala sipi gala isim kasi toyamata.” ");
INSERT INTO kij_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","E Guyau ikaibiga baisa Mosese, kawala, “Kuvakouli Yosuwa, matauna Nuni latula, matauna goli tokatavatu, e bukusaili yamam odabala. ");
INSERT INTO kij_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Matauna bukuvigaki bitotu omatala Eleasa tolula deli omitasi boda komwaidona, e baisa komwaidosi mabudona omitasi yoku bukukwamituli matauna mwada kaimapum. ");
INSERT INTO kij_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Bukusaiki matauna mimilisi m kwaraiwaga titoulem kidamwa mina Isireli komwaidosi bikabikuwolaisi matauna. ");
INSERT INTO kij_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Matauna Yosuwa bikanuvateta baisa tolula Eleasa, e matauna Eleasa binainevi nanogu metoya baisa makwaisina vavagi Urim deli Tummim. Baisa makawala Eleasa bitovakeda baisa Yosuwa deli goli baisa komwaidosi mina Isireli osi vavagi komwaidona.” ");
INSERT INTO kij_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mosese bogwa ivagi avaka Guyau eiluki matauna, e ivigaki Yosuwa itoli omatala tolula Eleasa deli goli omitasi boda komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","E Mosese isaili yamala odabala Yosuwa makawala Guyau bogwa eikaraiwogi, e ikamituli matauna paila kaimapula. ");
INSERT INTO kij_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","E Guyau iluki Mosese ");
INSERT INTO kij_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","bikaraiwogi mina Isireli avai tuta bisemakaiyaisi kaula semakaila baisa Yaubada, semakavi makwaina iyomwasali Guyau nanola, bisemakavaisi okala tuta mokwita. ");
INSERT INTO kij_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Baisa makawala kaula semakaila ibodi bukusemakaiyaisi baisa Guyau bivigaki semakavi kwegubugabu paila yam kwaitala kwaitala, nayu nammwala lam kasi taitu kwaitala minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Natana kaukwau bukusemakaiyaisi e nayuwela ikoyavi, ");
INSERT INTO kij_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","natana natana minasina bukusemakaiyaisi deli kaula semakaila kala vakaila makawala kapotala pwarawa bitagulikaisi deli yatala lukwavala olibe bulamila. ");
INSERT INTO kij_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Baisa yam kwaitala kwaitala semakaila. Komwaidona wala kwegubugabu; makawala wala makwaina bogwa leivigibogwisi kaula semakaila wa Koya Sinai, e maiinela iyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Makawala goli waini semakaila biligabwaisi yatala lukwavala waini bila okabolula deli minana lam namatala. ");
INSERT INTO kij_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","E tutala bikoyavi bisakaisi nayuwela lam makawala kaukwau leivagaisi e sivayu wala bisegulikaisi waini semakaila. E baisa tuvaila kaula semakaila e maiinela iyomwasali Guyau nanola. ");
INSERT INTO kij_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Wa yam Sabate bukusemakaiyaisi nayu lam nammwala minasina kasi taitu kwaitala deli gala isim kasi nebaneba, deli pwarawa kala vakaila makawala kapoyu bukutagulikaisi deli olibe bulamila e bivigaki kaula semakaila toyo waini semakaila. ");
INSERT INTO kij_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Makwaisina semakavi kwegubugabu bukusemakavaisi Sabate kwaitala kwaitala, katumkulovala yam kwaitala kala semakavi deli wala waini semakaila. ");
INSERT INTO kij_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Kusakaisi baisa Guyau semakavi kwegubugabu okala vitouula tubukona natana natana; nayu bulumakau natubovau, natana namwala sipi, nalima nayu nammwala lam kasi taitu kwaitala. Komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Paila kaula semakaila bukutagulikaisi pwarawa deli olibe bulamila e bukusegulikaisi natana natana bulumakau pwarawa kala vakaila makawala kapotolu, e kapoyu deli minana namwala sipi; ");
INSERT INTO kij_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","e deli natana natana lam, pwarawa kala vakaila makawala kapotala. Makwaina semakavi kwegubugabu bivigaki kaula semakaila, e maiinela iyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Guguwala mokwita paila waini semakaila makawala, yayu lukwavala waini paila natana natana bulumakau, e yatala lukwavala deli yayuwela sokopwana bilokaia paila sipi namwala, e yatala lukwavala paila natana natana minasina lam. Baisa makawala karaiwogala paila semakavi kwegubugabu bisakaisi oyamla kwematala tubukona natana natana olopola kwaitala taitu. ");
INSERT INTO kij_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","E katumkulovala semakavi kwegubugabu paila yam kwaitala kwaitala deli waini semakaila bukusemakaiyaisi natana namwala gota bivigaki mitugaga kala ligaiwa semakaila. ");
INSERT INTO kij_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","E tubukona namatala oyamla kweluwotala kwaivasila bukupakasi Luvapela Pakala paila Guyau kala taimamila. ");
INSERT INTO kij_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","E yam kweluwotala kwailima kwaitalela paka bivitouula, bukupakapakasi wala bila biboda kwailima kwaiyu yam, e olopola yam makwaisina bukukwamkwamsi beredi gala deli kala yisi. ");
INSERT INTO kij_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","E yam makwaina paka bivitouula komwaidomi wala bukusigugulasi gulitinidesi paila bukutapwarorusi e gala avai paisewa bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","E bukusakaisi mi semakavi kwegubugabu bivigaki kaula semakaila baisa Guyau. Nayu natubovau bulumakau nammwala, natana sipi namwala, deli nalima nayu lam nammwala kasi taitu kwaitala wala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Bukusemakavaisi kaula semakaila metoya pwarawa bukutagulikaisi toyo olibe bulamila, kala vakaila makawala kapotolu paila natana natana minasina bulumakau nammwala, kapoyu paila minana sipi namwala, ");
INSERT INTO kij_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","e kapotala paila natana natana minasina lam. ");
INSERT INTO kij_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Deli bukukwatumkulovaisi mi semakavi kusakaisi natana gota namwala paila mitugaga semakaila, e baisa bivigaki kabotuvitusila paila tomota si mitugaga kala ligaiwa. ");
INSERT INTO kij_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Semakavi makwaina katumkulovala semakavi kwegubugabu paila kaukwau kwaitala kwaitala bukusemakaiyaisi. ");
INSERT INTO kij_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","E yam kwailima kwaiyu makwaisina bukusemakaiyaisi kaula semakaila baisa Guyau paila maiinela biyomwasali matauna. Bukusemakaiyaisi baisa bivigaki katumkulovala semakavi kwegubugabu deli waini kwegubugabu paila yam kwaitala kwaitala. ");
INSERT INTO kij_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","E yam kwailima kwaiyuwela gala avai paisewa bukuvagaisi mesinaku tapwaroru wala. ");
INSERT INTO kij_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Avai tuta bukusakaisi mi semakavi kwaiuwovau kaula baisa Guyau, wa yam makwaina kwematala paila Tayoyuwa Pakala, ibodi bukusigugulasi gulitinidesi paila bukutapwarorusi, deli gala wala avai paisewa bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Bukusemakaiyaisi semakavi kwegubugabu makwaina maiinela biyomwasali nanola Guyau. nayu natubovau bulumakau, natana sipi namwala, deli nalima nayu nammwala lam minasina kasi taitu kwaitala e komwaidosi minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Bukusemakaiyaisi kaula semakaila metoya pwarawa bukutagulikaisi deli olibe bulamila, kala vakaila kapotolu paila natana natana bulumakau, kapoyu paila minana sipi namwala, ");
INSERT INTO kij_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","e kapotala paila natana natana minasina lam. ");
INSERT INTO kij_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Tuvaila bukusemakaiyaisi natana gota namwala paila mitugaga kala ligaiwa semakaila e baisa bivigaki kabutuvitusila paila kasi katumigileu tomota. ");
INSERT INTO kij_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Bukusemakaiyaisi minasina deli goli waini semakaila bivigaki katumkulovala semakavi kwegubugabu deli kaula semakaila paila yam kwaitala kwaitala. ");
INSERT INTO kij_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","E tubukona nalima nayuwela oyamla kwematala bukusigugulasi gulitinidesi paila bukutapwarorusi, gala avai paisewa bukuvagaisi. Wa yam makwaina kami tauya bukuyuvaisi. ");
INSERT INTO kij_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","E bukusakaisi mi semakavi kwegubugabu baisa Guyau. e maiinela biyomwasali nanola matauna. ka, natana natubovau bulumakau namwala, natana sipi namwala, deli nalima nayu lam nammwala kasi taitu kwaitala wala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","E bukusemakaiyaisi kaula semakaila pwarawa bukusegulikaisi olibe bulamila, kala vakaila kapotolu paila minana bulumakau namwala, e kapoyu paila minana sipi namwala, ");
INSERT INTO kij_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","kapotala paila natana natana minasina lam. ");
INSERT INTO kij_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Deli katumkulovala mi semakavi kusakaisi natana gota namwala paila mitugaga kala ligaiwa semakaila, e baisa bivigaki kabotuvitusila paila tomota kasi katumigileu. ");
INSERT INTO kij_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Semakavi makwaisina bukusakaisi yam kwematala olopola tubukona minana paila katumkulovala semakavi kwegubugabu deli kaula semakaila paila yam kwaitala kwaitala, e toyo kaula semakaila deli waini semakaila. E makwaisina kaula semakaila maiinela biyomwasali nanola Guyau. ");
INSERT INTO kij_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Tubukona nalima nayuwela oyamla kweluwotalela bukusigugulasi gulitinidesi paila bukutapwarorusi. Gala avai kaula bukukwamsi deli gala avai paisewa bukuvagaisi. ");
INSERT INTO kij_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Bukusemakaiyaisi baisa Guyau semakavi kwegubugabu, makwaina maiinela iyomwasali Guyau nanola. Natana natubovau bulumakau, natana sipi namwala, deli nalima nayu lam kasi taitu kwaitala, komwaidosi minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Bukusemakaiyaisi kaula semakaila metoya pwarawa bukutagulikaisi deli olibe bulamila, kala vakaila makawala kapotolu paila minana bulumakau namwala, kapoyu paila minana sipi namwala, ");
INSERT INTO kij_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","deli kapotala paila natana natana minasina lam. ");
INSERT INTO kij_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Tuvaila bukusemakaiayaisi natana gota namwala paila mitugaga kala ligaiwa semakaila deli goli minana gota paila kasi katumigileu tomota. Deli goli yam kwaitala kwaitala bukugabwaisi semakavi lulela deli kaula semakavila toyo waini semakaila. ");
INSERT INTO kij_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Tubukona nalima nayuwela oyamla kweluwotala kwailimala bukusigugulasi gulitinidesi bukutapwarorusi. Bukupakasi kami paka paila Guyau kala taimamila biboda kwailima kwaiyu yam, e gala bukuvagaisi avai paisewa paila titoulemi. ");
INSERT INTO kij_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Yam makwaina kwematala bukusemakaiyaisi paila kaula semakaila baisa Guyau. Bukusemakaiyaisi naluwotala natolu bulumakau natubovau, nayu sipi nammwala, deli naluwotala navasi lam nammwala kasi taitu kwaitala, minasina gala isim kasi nebaneba. Semakavi makwaina maiinela iyomwasali Guyau nanola. ");
INSERT INTO kij_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Bukusemakaiyaisi kaula semakaila metoya pwarawa bukutagulikaisi deli olibe bulamila, kala vakaila makawala kapotolu paila minana bulumakau, kapoyu paila minana sipi nammwala, ");
INSERT INTO kij_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","deli kapotala paila natana natana minasina lam, e semakavi makwaina bukusegulikaisi deli waini semakaila. ");
INSERT INTO kij_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Tuvaila bukusemakaiyaisi natana gota namwala bivigaki mitugaga semakaila. Bukusemakaiyaisi katumkulovala semakavi kwegubugabu deli kaula semakaila deli goli waini semakaila paila yam kwaitala kwaitala. ");
INSERT INTO kij_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","E yam kwaiyuwela bukusemakaiyaisi naluwotala nayu bulumakau natubovau nammwala, nayu sipi nammwala, deli naluwotala navasi lam nammwala kasi taitu kwaitala wala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","19","Deli semakavi makwaina bukusemakaiyaisi tuvaila yam kwematala semakaila kala katumkoluva. ");
INSERT INTO kij_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Yam kwaitolula bukusemakaiyaisi naluwotala natana bulumakau natubovau, nayu sipi nammwala, deli naluwotala navasi lam nammwala kasi taitu kwaitala wala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","22","Deli semakavi makwaina bukusemakaiyaisi tuvaila yam kwematala semakaila kala katumkoluva. ");
INSERT INTO kij_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Yam kwaivasila bukusemakaiyaisi naluwotala bulumakau natubovau, nayu sipi nammwala, deli naluwotala navasi lam namwala, kasi taitu kwaitala wala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","25","Semakavi makwaina bukusemakaiyaisi yam kwematala semakaila kala katumkoluva. ");
INSERT INTO kij_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Yam kwailimala bukusemakaiyaisi nalima navasi bulumakau natubovau, nayu sipi nammwala, deli naluwotala navasi lam kasi taitu kwaitala wala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","28","Deli semakavi makwaina bukusemakaiyaisi yam kwematala semakaila kala katumkoluva. ");
INSERT INTO kij_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Yam kwailima kwaitalela bukusemakaiyaisi nalima natonu bulumakau nammwala natubovau, nayu sipi nammwala, deli naluwotala navasi lam kwaitala wala kasi taitu, e minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","31","Deli semakavi makwaina bukusemakaiyaisi yam kwematala semakaila kala katumkoluva. ");
INSERT INTO kij_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Yam kwailima kwaiyuwela bukusemakaiyaisi nalima nayu bulumakau nammwala natubovau, nayu sipi nammwala, deli naluwotala navasi lam nammwala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","34","Semakavi makwaina bukusemakavaisi makawala wala yam kwematala semakaila. ");
INSERT INTO kij_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Yam kwailima kwetolula bukusigugulasi gulitinidesi paila bukutapwarorusi e gala bukupaisewasi. ");
INSERT INTO kij_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Bukusemakavaisi baisa Guyau semakavi kwegubugabu makawala kaula semakaila, makwaina maiinela iyomwasali Guyau nanola. natana natubovau bulumakau, natana sipi namwala, deli nalima nayu lam nammwala kasi taitu kwaitala, komwaidona minasina gala isim kasi nebaneba. ");
INSERT INTO kij_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","Semakavi makwaina bukusemakavaisi makawala wala yam kwematala semakaila. ");
INSERT INTO kij_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Baisa makawala karaiwogala paila semakavi kwegubugabu, kaula semakaila, waini semakaila bukusakaisi Guyau otutala kami paka. Makwaisina bivigaki katumkulovala semakavi paila bikamokwita avaka mi biga katotila kaina mi tagwala wala lokusemakaiyaisi. ");
INSERT INTO kij_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Mapaila Mosese iluki mina Isireli komwaidona avaka Guyau eikaraiwogi matauna. ");
INSERT INTO kij_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mosese isaiki karaiwaga baisa tokugwala dala Isireli. ");
INSERT INTO kij_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Kidamwa taitala tau bilivala biga katotila mwau mwada bisaiki avai vavagi baisa Guyau kaina eikatotila bikikili titoulela metoya avai vavagi, matauna gala ibodi biyogagi la biga katotila, mitaga ibodi wala bivagi vavagi komwaidona avaka eilivala bivagi. ");
INSERT INTO kij_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Kidamwa natana vivila natubovau igau wala deli veyala eisisuaisi bilivala biga katotila mwau mwada bisaiki avai vavagi baisa Guyau kaina eikatotila bikikili titoulela metoya avai vavagi, ");
INSERT INTO kij_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","minana ibodi wala bivagi makawala la biga katotila mwau eikatotila bivagi, mesinaku wala kidamwa tamala bikavilivili minana avai tuta bilega biga. ");
INSERT INTO kij_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Kidamwa tamala bogwa eilagi biga e bisilibodi minana gala bivagi makawala la biga katotila mwau, minana gala wala ibodi bivagi avaka eikatotila bivagi. E Guyau bikabwaili minana, paila uula tamala gala itagwala minana bivagi avaka la biga katotila. ");
INSERT INTO kij_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Kidamwa natana nakubukwabuya bilivala biga katotila mwau, kaina isim uula kaina bikaibigimakavi wala, kaina goli bikatotila mwada gala bivagi avai vavagi e oluvi minana bivai, ");
INSERT INTO kij_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","minana ibodi wala bivagi komwaidona makawala la biga katotila mwau eikatotila bivagi mesinaku la mwala wala bikavilivili minana avai tuta bilega biga. ");
INSERT INTO kij_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mitaga kidamwa la mwala bilagi biga e bisilibodi minana gala bivagi makawala avaka la biga katotila mwau, minana gala ibodi bivagi avaka eikatotila bivagi. E Guyau bikabwaili minana. ");
INSERT INTO kij_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Kaina natana kwabuya kaina natana nauvaipaka ibodi bivagi komwaidona la biga katotila mwau deli komwaidona avaka eikatotila gala bivagi. ");
INSERT INTO kij_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Kidamwa natana navavaigila bilivala biga katotila mwau kaina bikatotila gala bivagi avai vavagi, ");
INSERT INTO kij_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","minana ibodi wala bivagi makawala la biga katotila mwau eikatotila bivagi, mesinaku la mwala wala bikavilivili minana avai tuta bilega biga. ");
INSERT INTO kij_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Kidamwa la mwala eilagi biga e bisilibodi minana gala bivagi makawala la biga katotila mwau, minana gala wala ibodi bivagi avaka eikatotila bivagi. E Guyau bikabwaili minana, paila uula la mwala isilibodi minana gala bivagi makawala la biga katotila mwau. ");
INSERT INTO kij_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Paila la mwala ibodi wala bikabwaili kaina bikagagi avai biga katotila mwau kaina avaka eikatotila bivagi. ");
INSERT INTO kij_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Mitaga kidamwa yam makwaina matauna eilagi biga paila makwaina biga katotila mwau, e bila yam nabwaia gala kwaitala kavilavila bisaila, minana ibodi wala bivagi vavagi komwaidona makawala la biga katotila eikatotila bivagi. La mwala eikabwaili makwaina biga katotila mwau paila uula gala bikagagi yam makwaina eilagi biga, mapaila gala bikavilivili minana. ");
INSERT INTO kij_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mitaga kidamwa tuta oluvi matauna bikagagi makwaina biga katotila mwau, matauna ibodi wala bilumkoli mmayuyu paila uula la kwava gala ivagi makawala makwaina biga katotila mwau. ");
INSERT INTO kij_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Karaiwaga makwaisina Guyau eisaiki Mosese paila kasi karaiwaga vivila kubukwabuya deli veisia isisuaisi deli vavaigila vivila paila si biga katotila mwau. ");
INSERT INTO kij_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Bukumipuki mina Midiani paila avaka bogwa leivagaisi baisa mina Isireli. Avai tuta bukuvagi makawala, oluviga yoku bukukwaliga.” ");
INSERT INTO kij_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mapaila Mosese iluki tomota kawala, “Kukwatubaiasasi paila kabilia, e bukubasisi kabilia deli mina Midiani, e bukumipukwaisi matausina paila avaka bogwa leivagaisi baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Ibodi dala dilatala dilatala olopola Isireli biwitali tailakatuluwotala tokabilia.” ");
INSERT INTO kij_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Mapaila inagaisi tailakatuluwotala tauwau metoya dala dilatala dilatala, e kasi bawa komwaidona iboda 12,000 matausina tobasi okawakali. ");
INSERT INTO kij_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mosese iwitali matausina ilosi ikabiliasi. Peniasi matauna Eleasa tolula latula ikugwai matausina, matauna tokaraiwogala guguwa kwebumaboma deli makwaisina taudoudou. ");
INSERT INTO kij_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","E makawala Guyau eikaraiwogi Mosese, matausina ivabodaisi valu Midiani, e ikatumataisi komwaidona tauwau, ");
INSERT INTO kij_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","deli goli Midiani si gweguya kasitailima yagasi Ebi, Rekem, Sura, Ura, deli Reba. Balam matauna Beori latula deli wala ikatumataisi. ");
INSERT INTO kij_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","E mina Isireli ikatupipaisi vilesi Midiani deli gugwadi, ivayoulisi si bulumakau deli yuwoulela si mauna, ikwayaisi komwaidona si veiguwa, ");
INSERT INTO kij_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","deli igabwaisi si valu deli si kabosikaiwa komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ivayoulisi komwaidona guguwala, tomotala, deli maunela, ");
INSERT INTO kij_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","e imiakaisi Mosese sola Eleasa deli goli komwaidona mina Isireli tosibwaiga eisisuaisi osi kabosikaiwa oitayatilela Mowabi katitaikinela Yoridani kibubotala biloula Yeriko. ");
INSERT INTO kij_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mosese, Eleasa, deli goli komwaidosi tokugwala Isireli isunapulasi metoya osi kabosikaiwa, e ilosi ibodaisi tokabilia. ");
INSERT INTO kij_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Mosese saina igibuluwi kasi tokaraiwaga deli si kumatoula mabudosina eikaimilavausi metoya okakabilia. ");
INSERT INTO kij_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Mosese ikatupoi matausina kawala, “Avaka paila gala kukwatumataisi vivila? ");
INSERT INTO kij_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Kululuwaisi minasinala vivila eikabikaulasi Balam la karaiwaga, makawala okwaitala eileiki mapilana Peori minasina ivakadaisi tomota bipakaisi Guyau. Baisa uulela kwaitala lelia mwau leiyomituli Guyau la tomota kasi mwau. ");
INSERT INTO kij_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Mapaila baisa tuta kukwatumataisi komwaidona gugwadi tauwau deli vivila minasina bogwa eikikapugulasi. ");
INSERT INTO kij_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mitaga komwaidona vivila gugwadi deli kapugopugula minasina gala ikikapugulasi gala bukukwatumataisi, kuyosisi baisa mi vavagi. ");
INSERT INTO kij_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","E availa availa yokomi lokukwatumataisi kaina lokukwabikonaisi tomata uwosi, bukusiwaisi wala oyosewala kabosikaiwa biboda kwailima kwaiyu yam. E yam kwaitolula deli yam kwailima kwaiyuwela yokomi bukukwatumigileuwaimi deli goli vivila minasina lokukwatupipaisi. ");
INSERT INTO kij_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Tuvaila ibodi bukukwatumigileuwaisi karekwa yatala yatala, deli avai vavagi eibubulokaisi metoya mauna kanuvinesi, gota unuunusi, kaina avai vavagi eiyoudulokaisi metoya kai.” ");
INSERT INTO kij_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","E Eleasa matauna tolula iluki tauwau matausina eikaimilavausi metoya okabilia kawala, “Karaiwaga makwaisina Guyau isaiki Mosese. ");
INSERT INTO kij_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","Komwaidona vavagi makwaisina gala ibodi kova bivakasosu, makawala goula, siliba, barasi, deli goli tanumnumta ituwoli ituwoli makwaisina bukukwatumigileuwaisi metoya wa kova. E avai guguwa makwaisina ituwoli bukukwatumigileuwaisi metoya sopila katumigileu. ");
INSERT INTO kij_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","E yam kwailima kwaiyuwela yokomi bukuwinaisi kami karekwa, e bogwa bukumigileusi mokwita e bibodi bukusuvisi okabosikaiwa.” ");
INSERT INTO kij_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","E Guyau iluki Mosese kawala, ");
INSERT INTO kij_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Yoku som Eleasa, deli goli matausina tokugwala Isireli, bukukwalauwaisi guguwa komwaidona lokumaiyaisi metoya okabilia, kukwalumgolaisi tokatupipi deli mauna komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Kuvilaisi guguwa makwaisina bila wala guloyu, gulotala paila kabilia, e guloyuwela paila tomota komwaidona. ");
INSERT INTO kij_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","E metoya okasi vilavila tokabilia bukukwau taitala wala metoya lakatulima matausina tokatupipi, natana bulumakau metoya lakatulima e makawala goli bukuvigakaisi baisa minasina ase, sipi, deli gota. Baisa bukuvigakaisi mi pokala baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Bukusakaisi matausina deli minasina baisa Eleasa tolula baisa bivigaki Guyau kala katukila. ");
INSERT INTO kij_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","E metoya okasi vilavila tomota komwaidona bukukwau taitala wala metoya tailuwolima matausina tokatupipi, natana bulumakau metoya buluwolima bulumakau e makawala goli bukuvigakaisi baisa minasina ase, sipi deli gota. Bukusakaisi matausina deli minasina baisa mina Libai matausina iuwotetilasi Guyau ola Buliyoyova.” ");
INSERT INTO kij_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","E Mosese sola Eleasa ivagaisi avaka Guyau eikaraiwogi matausina. ");
INSERT INTO kij_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","35","Baisa makawala kala takasa avaka tokabilia leimaiyaisi metoya okabilia deli goli makwaisina leivatulumasi paila titoulesi, kala bawa baisa makawala. 675, 000 sipi deli gota, 72,000 bulumakau, 61,000 ase, 32,000 vivila kapugopugula. ");
INSERT INTO kij_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","40","E sipi deli gota ivilaisi isakaisi tokabilia 337, 500 kasi vilavila, e metoya minasina ikauwaisi 675 ivigakaisi si pokala baisa Guyau; 36,000 bulumakau, e metoya minasina ikauwaisi naluwolima naluwoyu nayu ivigakaisi si pokala baisa Guyau, 30,500 ase e metoya minasina ikauwaisi naluwolima naluwotala natana ivigakaisi si pokala baisa Guyau; e 16,000 kapugopugula, metoya minasina ikauwaisi naluwotolu nayu ivigakaisi si pokala baisa Guyau. ");
INSERT INTO kij_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mapaila Mosese isaiki Eleasa pokala baisa ivigaki Guyau kala katukila, makawala avaka Guyau eikaraiwogi Mosese bivagi. ");
INSERT INTO kij_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","46","E tomota kasi vilavila bogwa makawala tokabilia kasi vilavila. 337, 500 sipi deli gota, 36,000 bulumakau, 30,500 ase, e 16,000 kapugopugula. ");
INSERT INTO kij_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Metoya vilavila makwaina Mosese ikau taitala metoya tailuwolima tokatupipi, deli natana metoya naluwolima bulutuvalu, e makawala goli Guyau eikaraiwogi isaiki mina Libai matausina kala towotetila Guyau la Buliyoyova. ");
INSERT INTO kij_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Oluvi kumatoula matausina eikugwaiyaisi tokabilia ilokaiasi Mosese ");
INSERT INTO kij_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ilukwaisi kawasi, “Tomoya ka, bogwa lakakalawaisi avaka kasi bawa tokabilia e gala taitala isasa matala. ");
INSERT INTO kij_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Mapaila avaka taitala taitala lakakauwaisi metoya okabilia bogwa bakamiakaimsi guguwa makwaisina eibubulokaisi goula, mlipwapwa, mituwetuwa, kakalougwa, paya deli kuwekuwa. E makwaisina ma semakaiyaisi baisa Guyau paila eikoli ma momovasi, kidamwa m