﻿USE sofia;
DROP TABLE IF EXISTS sofia.khz_vpl;
CREATE TABLE khz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES khz_vpl WRITE;
INSERT INTO khz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iesu Keriso ewalato, tupuna gatana geriana evogomaito valina ea: Iesu ia Davida kalakalana, Davida ia Aperaamo kalakalana. ");
INSERT INTO khz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aperaamo ia Isaako tamana; Isaako ia Iakobo tamana; Iakobo ia Iuda makakana e matarina ria tamara; ");
INSERT INTO khz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda ia Perese e Sera tamara, ira tinara Tamar; Perese ia Hesron tamana; Hesron ia Ram tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ia Aminadab tamana; Aminadab ia Nasona tamana; Nasona ia Salmon tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ia Boas tamana, Boas tinana Rahaba; Boas ia Obed tamana, Obed tinana Ruta; Obed ia Iese tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iese ia King Davida tamana. Davida ia Solomona tamana. Solomona ia Uria garawana genana ewalato, (Uria garawana etavarariato mulinai); ");
INSERT INTO khz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona ia Rehoboam tamana; Rehoboam ia Abia tamana; Abia ia Asa tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ia Iehosafat tamana; Iehosafat ia Ioram tamana; Ioram ia Usia tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ia Iotam tamana; Iotam ia Ahasa tamana; Ahasa ia Hesekia tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia ia Manase tamana; Manase ia Amon tamana; Amon ia Iosia tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosia ia Iekonia mawalakavana ria tamara. Volaganinai Babulonia talimara na Isaraela talimara gegapi-agorato Babuloniai. ");
INSERT INTO khz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babuloniai gegapi-agorato mulinai, Iesu evogomaito gulura e gewalato valina ea: Iekonia ia Sealtiele tamana; Sealtiele ia Serubabele tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabele ia Abiud tamana; Abiud ia Eliakim tamana; Eliakim ia Asoro tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoro ia Sadok tamana; Sadok ia Akim tamana; Akim ia Eliud tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ia Eleasara tamana; Eleasara ia Matan tamana; Matan ia Iakobo tamana; ");
INSERT INTO khz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakobo ia Iosepa tamana, Iosepa garawana Maria. Maria genana Iesu ewalato; Iesu arana gekilagiana Keriso negetina. (Keriso ganina ia Palagu na ekilagi-maavuato vevega-maguli tauna). ");
INSERT INTO khz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Gulu maparara Aperaamo genana pene vogomai King Davida genai gulu gagalana vativati (14), Davida genana pene vogomai Babuloniai gelakagirato gulu gagalana vativati (14), Babuloniai gelakagirato laganina na vegata pene vogomai Keriso genai gulu gagalana vativati (14). ");
INSERT INTO khz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesu Keriso evetaina ewalato: Ia tinana Maria Iosepa komunana, na ira ruala e rogoti gere vegarawa aonai, Veaga Palaguna na melo evega-matagaiato Maria tinagenai. ");
INSERT INTO khz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iosepa, Maria garawana, ia kala rorirori talimana, e ati eririwato, taunilimalima wailarai Maria pene vega-nugaragea. Vovetaina gaurai gena ririwa ia veavugai vou Maria pene rugaa netiwato. ");
INSERT INTO khz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ia vovetaina etugamagiwai aonai, Velekou gena aneru ta nivi aonai ematagaito, ne evaikilaato, netiwato, “Iosepa, Davida natuna, komunamu Maria gapiragena kalinana ragai pono kali, kwalana ia e Veaga Palaguna na melo pevega-matagaia ia tinagenai. ");
INSERT INTO khz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ia na melo ta pene gapia, pono araa arana Iesu, (Iesu ganina ia vevega-maguli tauna); kwalana ia na gena taunilimalima geria rakava aorana pene vega-magulira.” ");
INSERT INTO khz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Egaura maparara gewalato e Velekou na peroveta talimana muruna na ekilagirato kilara pene vega-taunataunara ularana, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Iogita, vavine ta pene kuvia, melo ta pene gapia, vomelo keina pia araa Emanuela.” Emanuela ganina “Palagu ita lagalagarai.” ");
INSERT INTO khz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosepa maitu na ekeroto aonai Velekou gena aneru na evaikilaato kalara ekalagirato. Maria evairageato, egarawaato. ");
INSERT INTO khz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Na ia goti ati gegeno-kouto natuna egapiato. Melona earaato arana, Iesu. ");
INSERT INTO khz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu Iudea tanonai vanuga ta arana Betelehemai ewalato. Volaganinai King Heroda na Iudea tanona egita-tagoawai. Iesu ewalato mulinai, aoneka talimara garo eragena kavana na gevogomaito, Ierusalemai gema kwarato. ");
INSERT INTO khz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ne geverenagito, negetiwato, “Iuda talimara geria king ta pewala negetina ariginai nea? Ia gena mitiu paga gitaa garo eragena kavanai. Ai ia aia aliruputali-venia ulanana paga vogomai.” ");
INSERT INTO khz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Heroda na vokila ekamonagiato ia nugana epilupiluto, e Ierusalema talimara maparara maki. ");
INSERT INTO khz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Gaurana ia na Rupu Veaga velera kamura e rova gevevega-ripagiawai talimara maparara evega-tanu-kourato, ne erenagirato, netiwato, “Peroveta talimara rakagau negetiwato, Keriso, (Palagu na ekilagi-maavuato vevega-maguli tauna), ravanai pene wala?” ");
INSERT INTO khz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ira na gevega-geleato, negetiwato, “Betelehema vanuganai, Iudea tanonai, kwalana peroveta talimana Mika na evetaina etaloato, ");
INSERT INTO khz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betelehema o, Iudea tanona aonai vanugana, Iuda vanugara nuganugarai goi ati vanuga keina, na maarana vanugana ta, kwalana vevai tauna ta goi gemuna pene vogomai, ia na au geku Isaraela talimara pene kune-agira.’” ");
INSERT INTO khz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Gaurana Heroda na aoneka talimara veavugai ekearato, ne erenagi-gainagainarato, netiwato, arigi toma taunataunanai mitiu ematagaito. ");
INSERT INTO khz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Gaura pakurai etugurato Betelehemai, evaikilarato, “Iolaka, melo keina iove tavu gitagitaa, pio rawalia genai, pioma vega-ripaku, pe au maki pana wati, pana aliruputali-venia.” ");
INSERT INTO khz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Heroda gena kila gekamonagiato mulinai, ira magelakato. Raupara na geagowai aonai, vomitiu, garo eragena kavanai gegitaato mitiuna, na maekune-agirato, pene ago, melo keina emaoko-tagowai kapuna atanai eve mia-tagoto. ");
INSERT INTO khz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ira na vomitiu gegitaato aonai, geverere-gaokavagito. ");
INSERT INTO khz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Vonumai gelaka-togato aonai, melo keina matinana Maria goti gegitarato, nea getiu-talito, gealiruputali-veniato. Voia mulinai geria veveni rinagara gekala-pakarato ne gewareware-veniato. Gewareware-veniato gaura ea kolo, e mulamula arana frenkinsens, kovuna maponana namana mulamulana, e veiru mulamulana arana muro. ");
INSERT INTO khz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne Palagu na nivi aonai evega-riparato, netiwato, “Heroda genai ragai pio waikule.” Gaura pakurai raupara poluna na geria tanopara e vanugai gewaikuleto. ");
INSERT INTO khz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ira gelakato mulinai, Velekou na aneru nivi aonai Iosepa genai evevega-matagaito, netiwato, “Ono kuliiti, melo keina matinana goti Aikupito ai ono raka-lakagira. Vonai pio talu vou, pene ago, au na mapana vaikila-waimu, kwalana Heroda na melo keina etavuana, pene vagi-kwaregaa netina.” ");
INSERT INTO khz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gaurai Iosepa ekuliitito, melo keina matinana goti evairato, pogi aonai Aikupito ai gelakato. ");
INSERT INTO khz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Vonai getaluwai pene ago, Heroda ekwaregato. Ekila e Velekou na peroveta talimana muruna na ekilagiato kilana etaunataunato, netiwato, “Aikupito na natuku akea-piatiato.” ");
INSERT INTO khz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Heroda eripa-rorirorito, voaoneka talimara na ia geopa-veniato gaurana, ia eparu-rakavato. Ne vetali talimara pa soldia etugurato, Betelehema e lagana tanorai melo keira geria wala rigolora ruala e mulinai gewalato maparara gevagi-kwaregarato. Vomelo keira geria wala rigolora ruala e mulinai gevagi-kwaregarato ganina aoneka talimara na mitiu gegitaato tomana na, pene ago, Heroda eripato tomana rigolo ruala e kovana. ");
INSERT INTO khz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gaurai Palagu na peroveta talimana Ieremia muruna na rakagau ekilagiato kilana etaunataunato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Karo ta Rama vanuganai gekamonagiato, tagi-kogokogo e tagi-wanonowanono kamu, Raela natuna galamarai etagina, ati eririwana pia vega-pikapikaa, kwalana natuna pia kwarega.” ");
INSERT INTO khz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Heroda ekwaregato mulinai, Velekou gena aneru Iosepa genai nivi aonai maevevega-matagaito Aikupito ai. ");
INSERT INTO khz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne voaneru Iosepa evaikilaato, netiwato, “Ono kuliiti, melo keina matinana goti ono vaira, Isaraela tanonai ioago. Kwalana melo keina pia vagi-kwaregaa negetiwato talimara warau pege kwarega.” ");
INSERT INTO khz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iosepa ekuliitito, ne melo keina matinana goti evairato, Isaraela tanonai gewaikuleto. ");
INSERT INTO khz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na Iosepa ekamonagito, Akelao na Iudea egita-tagoawai tamana Heroda kapunai, gaurana vonai ago ekalito. A Palagu na nivi aonai evega-ripaato gelegelenai elaka-vanagito, eagoto Galileia tanona kavanai. ");
INSERT INTO khz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Galileia tanonai vanuga ta arana Nasaretai etaluto. Voanana Palagu na peroveta talimara geriana Iesu ekilagiato kilana etaunataunato, netiwato, “Ia Nasareta talimanai pia kilagia.” ");
INSERT INTO khz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Volaganinai Ioane Bapatiso evogomaito, tanoleanai Iudea aonai evopatawai, netiiwai, ");
INSERT INTO khz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Gemi rakava aora na iovetugamagiwai, e iolaka-waikule Palagu genai, kwalana Kupa Basileia pevekavi-vagi, (Palagu gena vegitatago tiavuna evega-rugaana ea).” ");
INSERT INTO khz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","EIoane ea Isaia peroveta talimana na ekilagiawai, evetaina ekilato, “Talima ta tanoleanai ekeana, netina, ‘Velekou gena raupara ioalevaa, gena vogomai rauparana iovega-roriroria.’” ");
INSERT INTO khz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioane gena rapuga kamela lamulamuna na gekalaato, ia kapanai pae kopina. Gana gauganigani gaura ea koi e kwarere. ");
INSERT INTO khz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Taunilimalima Ierusalema na e Iudea maparana na e Ioridana waina vanugara maparara na maki geagowai Ioane genai. ");
INSERT INTO khz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Geria rakava gekilagi-matagairawai vou, ebapatisorawai Ioridana wainai. ");
INSERT INTO khz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Parisea e Sadukea talimara vogovagi maki ia genai geagowai pene bapatisora ularana. Ioane na egitarato ne, evaikilarato, netiwato, “Gomi warowaro natura, rai na pevaikilami, Palagu gena Kota kamuna tomana genana pio kali-maguli? ");
INSERT INTO khz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Gemi rakava na pio vetugamagiwai, ne gemi maguli ai vuavua namara pio vega-walara. ");
INSERT INTO khz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","E aomi ai ragai pio kila, ‘Aperaamo e ai tamamai, (pe Palagu na pene gapi-ragemi).’ Avaikilamina, Palagu matiavuna, Aperaamo natuna evatu geriana pene vega-walara!” ");
INSERT INTO khz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Etoma giro gautupu kwalarai warau pege taora; gaura pakurai vuavua namara ati gevega-walarana gautupura maparara pia patira, kalovai pia pia-ragera. ");
INSERT INTO khz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Rai gena rakava aora na evetugamagi-kulena talimana, au na nanu na abapatisoana. Na au muliku na pene vogomai talimana gena tiavu iwavagi, au geku tiavu maki evanagiana, e ia gena tamaka maki au na ati pana kalara ripa. Ia na Veaga Palaguna e kalova na pene bapatisomi. ");
INSERT INTO khz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ia gimanai aleva-aleva gauna, vuiti momona e vuiti ganina genana pene aleva-gitagitara ulanana. Na vuiti getao-kouana numanai pia tao-koura, na vuiti momona vou pene kapua ati eputena kalovanai.” ");
INSERT INTO khz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Volaganinai Iesu Galileia vanugana na Ioridana wainai eagoto, Ioane na pene bapatisoa ulanana. ");
INSERT INTO khz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na Ioane na ekila-waiato, netiwato, “Pere nama goi na au poro bapatisoku. Rakagau gaurai au geku ai povogomai?” ");
INSERT INTO khz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A Iesu na evega-geleato, netiwato, “Kalana ono kalaa, kwalana kala rorirori pa Palagu gena ririwa kalara maparara pita rogona-tolera nama.” Ne gaurana Ioane na Iesu gena ririwa kalana ekalaato. ");
INSERT INTO khz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu ebapatisoato, nanu na erage-vagito kupa evekala-pakato, aonai ia na Veaga Palaguna egitaato, pune vetaina emarigoto ia atanai. ");
INSERT INTO khz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aonai karo ta kupa na ekea-rigoto, netiwato, “E au Natuku, raramanina, aulamagiana; e averere-rakavana maki.” ");
INSERT INTO khz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Voia mulinai Veaga Palaguna na Iesu tanoleanai evaiagoato, Tiapolo na pene kalatovoa ulanana. ");
INSERT INTO khz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Toma e pogi gagala vativati (40) aorai ati eganiganito, evokato; gaurai ia evito-rakavaato. ");
INSERT INTO khz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ne Vekalatovo Talimana Tiapolo ia genai evogomaito, evaikilaato, netiwato, “Pene goi Palagu Natuna genai, evatu ono vaikilara, pia gauganigani.” ");
INSERT INTO khz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A Iesu na evega-geleato, netiwato, “Veaga Pukana aonai evetaina ekilana, ‘Taunilimalima ati gauganigani namo pia maguli. Na Palagu gena kila egapi-ragerana e ekwalanarana talimana maguli pene vaia.’” ");
INSERT INTO khz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tiapolo na Ierusalema, siti maveaganai, evaiagoato, Rupu Veaga kukuna pogepogenai evega-rugakauato. ");
INSERT INTO khz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Maevaikilaato, “Pene goi Palagu Natuna, neanana ono puri-rigo, kwalana Veaga Pukana aonai evetaina ekilana, ‘Palagu na gena aneru pene vega-nagira, pia gopemu, pia gapi-itimu, irauna gagemu vatu ai oputu-kauana.’” ");
INSERT INTO khz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu na maevega-geleato, netiwato, “Veaga Pukana aonai maki ekilana, ‘Velekou goi gemu Palagu ragai pono kalatovoa.’” ");
INSERT INTO khz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Eia mulinai Tiapolo na Iesu evairageato golo kamuna e mogana ta kukunai, tanopara basileiara maparara maralema ralemara e matiavura maki evega-gitaato, ");
INSERT INTO khz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","netiwato, “Pene au wailaku ai pono tiu-tali e au pono aliruputali-veniku genai egaura maparara au na pana venimu.” ");
INSERT INTO khz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Na Iesu na evaikilaato, netiwato, “Satani, au gekuna ono laka-paka. Kwalana Veaga Pukana aonai ekilana, ‘Velekou goi gemu Palagu pono aliruputali-venia, iamo geregana vetugunagina pono kalaa.’” ");
INSERT INTO khz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ne Tiapolo na eraokwaniato. Aneru reketa Iesu genai geagoto, genakagatuato. ");
INSERT INTO khz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu ekamonagito, Ioane gevega-tipuraato, gaurana Galileia tanonai maewaikuleto. ");
INSERT INTO khz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na Nasareta vanugana maeraokwaniato, ati etaluto, eagoto, Kaperanaumai evetaluto. Kaperanauma Genesareta kovuna lagana vanugana ta, Sebulona e Naptali tanora aorai. ");
INSERT INTO khz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Voanana Isaia, peroveta talimana, gena kila etaunataunato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulona e Naptali tanorai gotaluna talimami o, Galileia kovuna pipinai e Ioridana waina vokavanai, ati Iuda talimami, Palagu ati ripami talimami, gemi Galileia voa, iokamonagia. ");
INSERT INTO khz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mukunai getaluwai talimara emaeka kamuna warau gegitaana. E voo raira mukuna kaikolo tanonai getaluwai talimara atarai maeka warau pema matagai.” ");
INSERT INTO khz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Volaganinai vou Iesu matotauna valina evopatagi-matagaiato, netiwato, “Gemi rakava aora na iovetugamagiwai, e iolaka-waikule Palagu genai, kwalana Kupa Basileia pekwara, (Palagu gena vegitatago tiavuna evega-rugaana ea).” ");
INSERT INTO khz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu Galileia kovuna kone taitarina na elakato, eagowai aonai, tau walakako ruala, Simona, arana ta Petero, matarina Anduru goti egitarato, geria leke kovu ai gepiarawai, kwalana ira taura ruala vetavu talimara. ");
INSERT INTO khz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne Iesu na evaikilarato, netiwato, “Muliku ai iomai-laka, pe au na gomi taunilimalima vetavura pana vega-ripami.” ");
INSERT INTO khz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ne veganamo geria leke geraokwanirato, Iesu mulinai gelakakauto. ");
INSERT INTO khz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Voanana gelakato, geagowai aonai, Iesu na tau walakako ruala maegitarato, Teimiti Tepetaio matarina Ioane goti; geria gati ai tamara Tepetaio ria geria leke veralera geaumerawai. Iesu na ekearato, ");
INSERT INTO khz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","veganamo geria gati e tamara geraokwanirato, Iesu mulinai gelakakauto. ");
INSERT INTO khz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu Galileia tanona maparanai elakavo-lakavowai, Iuda talimara geria rupu aorai evevega-ripawai, e Palagu gena Basileia, (gena vegitatago tiavuna evega-rugaana), valina namana evopatagiawai. E taunilimalima geria viti e viti irauirau maparara evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ia valina gepiaato, Siria tanona maparana eraka-lovaato, ne taunilimalima na geria viti talimara maparara ia genai geago-agirato: Viti irauirau, palagu rakavara na geporogirato talimara, uve na evagiana vitina, taunipara gepilupiluna, e tauniparara kavatara gekwaregato talimara, Iesu na maparara evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Taunilimalima gutuma gutuma ia mulinai gelakato, Galileia na, Vanuga Gagalana (10) na, Ierusalema na, Iudea na, e Ioridana waina vokavana na maki ia gekwaruato. ");
INSERT INTO khz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu na talima gutuma gutuma egitarato, golo taai everageto, atanai etanu-talito. Gena melo ia genai geagoto. ");
INSERT INTO khz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ne ia na evega-ripa-tinarato, netiwato: ");
INSERT INTO khz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aoma talimara, Palagu genaimo gevetapekauna talimara, pia verere, kwalana Palaguna Basileia ira geria. ");
INSERT INTO khz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Raira etoma aora gevitivitina talimara pia verere, kwalana Palagu na geria aovitiviti pene vega-aikira. ");
INSERT INTO khz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aoma talimara pia verere, kwalana Palagu na tanopara maparana ira pene venira. ");
INSERT INTO khz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kala rorirori vitona na evitorana e nanuna na ekalarana talimara pia verere, kwalana roe nea vou pia gani-tinage-tupu. ");
INSERT INTO khz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vegita-vetuga talimara pia verere, kwalana Palagu na ira maki pene gita-vetugara. ");
INSERT INTO khz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Raira aora nama iwavagi talimara pia verere, kwalana ira na Palagu pia gitaa. ");
INSERT INTO khz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Raira etoma vevega-maino kalara gekalarana talimara pia verere, kwalana Palagu na ira natunai pene kilagira. ");
INSERT INTO khz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Raira etoma kala rorirorira gekalarana galamanai gevega-viti-vuarana e gevega-rakavarana talimara pia verere, kwalana Kupa Basileia ira geria. ");
INSERT INTO khz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Pene au muliku ai golakana galamanai gomi pia munemune-agimi, pia vega-vitivitimi e kila rakavara irauirau gemi ai pia kilagira e pia kilagi-opakaumi, pio verere. ");
INSERT INTO khz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pio verere, e mapio verere, kwalana Palagu na voimi kamuna pene venimi kupai. Ekala gelegelena, gomi mulimi talimara e, peroveta talimara kunera, maki vovetaina gevega-rakavarato.” ");
INSERT INTO khz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gomi tanopara tamenana. Pene tamena mamina taunataunana pene aiki ne, arigi rauparai mamina mapene waikule? Ia e warau perakava, ati gena nama ta. Gaura pakurai pia piatogaa, taunilimalima gagera na pia pana-talia. ");
INSERT INTO khz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Gomi tanopara maekana. Golo kukunai gevega-rugaato vanugana ati pene veavuga ripa. ");
INSERT INTO khz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lamepa pia kapua maki, rivu kapulenai ati pia taoa, na lamepa taotaona patana taunataunanai pia tao-kaua. Ne ia maekana na numa talimara maparara pene waera. ");
INSERT INTO khz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gelegelena, gomi gemi maeka taunilimalima wailarai vovetaina pio vega-matagaira, pe gemi kala namara pia gitara, Tamami kupai etaluna pia vega-ragea.” ");
INSERT INTO khz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Evetaina ragai pio tugamagi, au avogomaito Mose na rova e peroveta talimara geria kila ati ganirai pana vega-agora ulanana. Aikina. Au ati avogomaito vokila ati ganirai pana vega-agora ulanana, na pana vega-taunataunara e pana vega-gugulura ularana. ");
INSERT INTO khz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Avaikila-taunataunamina, kupa e tanopara roe gemiana aonai, rova gena leta keivagina ta pa gena koma ta ati vagi pene lekwalekwa, pene ago, rova maparara ganira taunatauna pia wala. ");
INSERT INTO khz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Vovetainai, talima taa na rova keivagina ta pene karoverave-venia, e gena ririwa kalanai talima reketa ekala gelegelenai mapene vega-ripara, ia Kupa Basileiai kapi talimanai pia kilagia. Na talima taa na rova pene kwalanara e talima reketa mapene vega-ripagira, ia kune talimanai pia kilagia Kupa Basileia aonai. ");
INSERT INTO khz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Avaikila-taunataunamina, pene gomi gemi kala rorirori na Parisea e rova gevevega-ripagirana talimara geria kala rorirori ati pene vanagira ne, gomi Kupa Basileia aonai ati pio laka-toga, aikina kinavagi.” ");
INSERT INTO khz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gomi ripami, talima kunera na rova kilara gegapirato, gekilato, ‘Ragai pono vagivagi! A rai na talima ta pene vagia ne, ia Kota kapunai pene ago.’ ");
INSERT INTO khz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Na etoma au na avaikilamina: Talima ta kakana pa tarina pene paru-venia ne, ia Kota kapunai pia renagia. E rai na kakana pa tarina pene vaikila-rakavaa ne, ia Kota kamunai pia vega-rugaa. E rai na kakana pa tarina pene vaikilaa, ‘Goi kawa papo’ nepenetiwa ne, ia ati eputena kalovanai pene ago. ");
INSERT INTO khz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Gaura pakurai, pene gemu veveni gauna pata maveagana atanai pono tao-kaua, Palagu pono venia notina genai, goi kakamu pa tarimu otugamagiana, ia magena metau goi gemu ai, ");
INSERT INTO khz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne gemu veveni gauna pata maveagana wailanai pono raokwania, pono ago, tarimu goti maino pio gapia vou pono waikule, gemu veveni gauna pata veaganai pono taoa Palagu gena. ");
INSERT INTO khz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Goi eparu-venimuna talimana goti maino pio raka-gapia, Kota kapunai roe wagolaka-kavikavina aonai. Kwalana eparu-venimuna talimana na Kota ekamonagiana talimana gimanai neeve tao-kaumuna nea, e Kota ekamonagiana talimana na tipura numana gitatagona talimana gimanai pene taomu, ia na tipura numana aonai neekana-gavumuna nea. ");
INSERT INTO khz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au na avaikila-taunataunamuna: Voanana ati pono laka-piati, pene ago gemu metau voina pono vega-voigatua.” ");
INSERT INTO khz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Gomi ripami, talima kunera na rova kilara gegapirato, gekilato, ‘Ragai pono veopa-lema!’ ");
INSERT INTO khz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Na au na avaikilamina: Rai na talima ta garawana egita-rogorogoana ne eririwana pene gapia ia gena, ia aona tugamagina genana warau peveopa-lema vogare genai. ");
INSERT INTO khz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pene goi matamu ripana na evega-rakavamuna genai, pono kipo-vagia, pono piatogaa! Kwalana tauniparamu rakavana kavana pene lekwalekwa voo nama, na ati nama tauniparamu maparana kalova ati eputena kapunai pia pia-kaua. ");
INSERT INTO khz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na pene goi gimamu ripana na evega-rakavamuna genai, pono pati-vagia, pono piatogaa. Namana ea, tauniparamu rakavana kavana pono piatoga-kunea, pe tauniparamu maparana kalova egala-vanagivanagina kapunai ragai pene ago.” ");
INSERT INTO khz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Talima kunera na rova kilara gegapirato, gekilato, ‘Tau ta garawana pene vega-lakaa genai, ia na vegarawa lugalugana pepana pene talo-venia.’ ");
INSERT INTO khz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Na au na avaikilamina: Pene talima ta garawana egui-rigoana, na gare veopa-lema kalara ati ekalagina, votalima na garawana veopa-lema garenai evega-agoana. E rai na egui-rigoato garena pene garawaa talimana ia pene veopa-lema.” ");
INSERT INTO khz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ita kalakalara gevega-riparato kilara gomi ripami: ‘Gemi kilagavu ragai pio vega-rakavara, na Velekou wailanai gokilagi-gavurato gaura pio kalara.’ ");
INSERT INTO khz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Na au na avaikilamina: Ragai pio kila-gavu vegata! Gemi kila vega-taunataunara ularana kupa ragai pio kilagia (pa kupa ragai pio ruia), kupa aranai ragai pio kila-gavu, kwalana ia Palagu gena terona; ");
INSERT INTO khz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","pa tanopara aranai maki ragaina, kwalana ia Palagu gagena panakauna kapuna; pa Ierusalema aranai, kwalana ia King kamuna gena siti. ");
INSERT INTO khz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Goi repamu, gemu maguli, maki ragai pono kilagia gemu kilagavu vega-taunatauna na, kwalana goi guimu nivana ta ati pono vega-kulokuloa e ati pono vega-ruparupaa ripa. ");
INSERT INTO khz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Namana ea: Gemu kila pono kilagia, ‘Pa’ pene pa e ‘Aikina’ pene aikina. Voiamo, na kila reketa maokilagirana Talima Rakavana, Satani, genana gevogomaina.” ");
INSERT INTO khz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Talima kunera gevega-riparato kilara gomi ripami, evetaina gekilato: ‘Mata voina mata e ruga voina ruga.’ ");
INSERT INTO khz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Na au na avaikilamina, kala rakavana ekala-venimuna talimana ragai pono kala-rakava-venia. Pene talima taa na mokomu ripana pene valea genai, mokomu kaulina mapono venia. ");
INSERT INTO khz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","E pene talima taa na Kotai pene taomu gemu tiati pene gapia ulanana genai, gemu kota maki pono venia. ");
INSERT INTO khz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","E talima taa na eririwamagimuna, kilomita kwapunai pono kwarua nepenetiwa genai, kilomita rualai pono laka ia goti. ");
INSERT INTO khz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","E enoginogina talimana pono venia, e gemu ai pene gapitore netina talimana maki ragai pono kila-tilivagi-venia.” ");
INSERT INTO khz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Talima kunera gevega-riparato rovara ripami, gekilato: ‘Goi lagamu talimana pono ulamagia, na evega-rakavamuna talimana pono vega-rakavaa.’ ");
INSERT INTO khz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Na au na avaikilamina: Geparu-venimina talimara pio ulamagira, e raira na gevega-rakavamina talimara maki atarai pio rapali. ");
INSERT INTO khz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eia genana pio vega-matagaia, gomi Tamami kupai etaluna ia natunai evega-agomito. Kwalana ia na garo kala rakava talimara e kala nama talimara atarai evega-ralaana, e gura maki kala rorirori e kala teveletevele talimara atarai evega-ketoana. ");
INSERT INTO khz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pene goulagamirana talimara gomi geulamagimina talimaramo genai, arigi veveni namana pio gapia? Takiti gekokoana talimara pa opakau talimara evetaina maki gekalana. ");
INSERT INTO khz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","E tarimimo pio vega-namara, gemi nama rakagau? Palagu ati geripaana talimara na maki ekala gekalaana. ");
INSERT INTO khz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Gaura pakurai gomi ati vetoukaumi pio talu, gomi Tamami kupai etaluna ati vetoukauna vetaina.” ");
INSERT INTO khz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Rogomi pio vetole, gemi kala namara taunilimalima wailarai ragai pio vega-matagaira, ira na pia vega-ragemi ulanana. Eira pio kalara genai, Tamami kupai etaluna genai voimi ati pio gapira. ");
INSERT INTO khz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Gaurai, gemu wareware rupu talimara pono venira aonai, ragai pono vopatagia, opakau talimara rupu ai e vanuga gatamanai gekalana vetaina, taunilimalima na pia vevato-agira ulanana. Avaikila-taunataunamina, ira talima na gevega-ragerana, pe voira warauna gegapirato. ");
INSERT INTO khz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Na goi gemu wareware ati gena e ati gana talimana ono venia noponotiwa genai, gimamu kaulina ragai pene ripa, goi gimamu ripana na rakagau ekalaana. ");
INSERT INTO khz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pe gemu wareware veavugai pono veni. E Tamamu na, rakagau ewalana veavugai egitarana, ia na vou voimu pene venimu.” ");
INSERT INTO khz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Pene pio rapali genai, opakau talimara vetaira ragai pio rapali! Ira rugarugarai mavererera gerapalina, rupu aorai e vanuga gatamanai e rauparai maki, taunilimalima na pia gitara ulanana. Au na avaikila-taunataunamina, ira voira warau gegapirato. ");
INSERT INTO khz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A goi oririwana pono rapali notina genai, gemu numa kovoganai pono laka-toga, vanagi pono kana-gavua, vonai vou Tamamu pono nogi-venia, ia veavugai etaluna. E Tamamu na, rakagau ewalana veavugai egitarana, ia na vou voimu pene venimu. ");
INSERT INTO khz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Gomi pio rapali genai, kila ati ganira ragai pio kilagiwai-kilagiwaira, Palagu ati ripara talimara gekalana vetaina. Ira getugamagina, geria kila vogora gekilagirana gaurana, Palagu na pene kamonagira. ");
INSERT INTO khz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ira vetaira ragai pio kala. Kwalana gomi na rakagau goririwaana, Tamami na eripa-kuneana, kapinai vou gomi na gonogi-veniana. ");
INSERT INTO khz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Evetaina pio rapali: ‘Ai Tamamai kupai goi aramu pene veaga; ");
INSERT INTO khz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","gemu Basileia pene vogomai; gemu ririwa paia kalaa tanoparai, kupai gekalaana vetaina. ");
INSERT INTO khz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Etoma gama gauganigani ono venimai. ");
INSERT INTO khz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Gema rakava ono tugamagi-piatogara, ai gevega-rakavamaina talimara geria rakava gatugamagi-piatogarana gelegelena. ");
INSERT INTO khz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Veripagani ai ragai pono vaimai, a Rakava Talimana, Satani, gimana na pono vega-magulimai. Kwalana Basileia goi gemu, tiavu goi gemu, ralema iwavagina goi gemu, toma pene ago-vanagivanagi, Amen.’ ");
INSERT INTO khz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pene gomi na gevega-rakavamina talimara geria rakava pio tugamagi-piatogara genai, Tamami kupai etaluna gemi rakava maki pene tugamagi-piatogara. ");
INSERT INTO khz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Na, pene gomi na gevega-rakavamina talimara geria rakava ati gotugamagi-piatogarana genai, Tamami na gemi rakava maki ati pene tugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pio voka genai, ragai pio ali-vetuga, opakau talimara gekalana vetaina. Wailarai gevevega-matagai-opakauna, taunilimalima matapolu pia kila, ‘Gevokana rakavaria kika’ nepiatiwa. Avaikila-taunataunamina, ira voira warau gegapirato. ");
INSERT INTO khz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A goi, ono voka noponotiwa genai, repamu pono rigaa e wailamu pono guligia, ");
INSERT INTO khz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pe taunilimalima na ragai pia ripamu, goi ovokana, na Tamamu veavugaimo pene ripa. E Tamamu na, rakagau ewalana veavugai egitarana, ia na vou voimu pene venimu.” ");
INSERT INTO khz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gemi rinaga etanoparai ragai pio tao-koura! Kwalana palo e kalokalo pa rasta na neevega-rakavarana nea, e lema taura na numa nege lovoana nege lemarana. ");
INSERT INTO khz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gemi rinaga kupai pio tao-koura, palo e kalokalo na ragai pia vega-rakavara, e lema talimara na maki numa ati pia lovoa e ati pia lemara ripa. ");
INSERT INTO khz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Goi gemu rinaga ariginai emiana, goi aomu maki vonai emiana.” ");
INSERT INTO khz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mata taunipara gena lamepa vetaina. Pene goi matamu nama genai, tauniparamu maparana maki pene waea. ");
INSERT INTO khz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Na pene goi matamu rakava genai, tauniparamu maparana maki pene mukuna. A pene maeka goi aomu ai mukuna genai, emukuna pene kamu-iwavagi!” ");
INSERT INTO khz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Talima ta vele ruala vetugunagira ati pene ago-venira ripa. Kwalana ia na ta ati pene ulamagia, a ta pene ulamagia; ta pene vega-taunataunaa, a ta pene opa-venia. Palagu e moni vetugunagira ati pio ago-venira ripa.” ");
INSERT INTO khz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Gaura pakurai avaikilamina, gemi maguli ragai pio tugamagira, rakagau pio gani pa pio niu; pa tauniparami rakagau na pio rapugara. Arigia gau kamuna, maguli pa ganigani? E arigia gau kamuna, taunipara pa rapuga? ");
INSERT INTO khz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kupai gelovona manura iogitara! Ira ati gevarovarona e ati gekuakuana, e araga numarai maki gauganigani ati getao-kouna. Na Tamami kupai etaluna na egupurana. Gomi gau kamu iwavagimi, a manu kei! ");
INSERT INTO khz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gomi rai otugamagitugamagina, gemu maguli kiata pono vega-mogaa ripa pa? ");
INSERT INTO khz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Raka rapuga vetaira gotugamagi-vekwalavi-agirana? Uraura tiarera iogitara, raka gekala-tiwana. Ati geinaguluna e rapuga ati getulina. ");
INSERT INTO khz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na avaikilamina, King Solomona gena verapuga ralemana maki gevanagiana. ");
INSERT INTO khz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E Palagu na tano gawara evega-rapugarana, ira toma gekalana, a pogipogi kalovai pia pia-ragera, Palagu vovetaina evevega-rapugana. Ia na gomi ati pene vega-rapugami, ei? Gomi kamonagi kei talimami! ");
INSERT INTO khz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Vovetaina gaurai, ragai pio tugamagitugamagi, ragai pio kila, ‘Toma rakagau ita gani?’ Pa ‘Rakagau ita niu?’ Pa ‘Toma rakagau ita ligo?’ ");
INSERT INTO khz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Palagu ati ripara talimara na egau maparara geraka-vetavurana, a Tamami kupai etaluna ripana, gomi egau goririwarana. ");
INSERT INTO khz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Na tovotovona ia gena Basileia e gena kala rorirori pio tavu-kunera, ne egau maparara gomi pene venimi. ");
INSERT INTO khz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Gaura pakurai pogipogi toma na tugamagi vekwalavina ragai pio kalaa; pogipogi tomana gena vekwalavi Palagu gimanai. Toma gena vekwalavi atanai metau mapio tao-kaua genai, raka pio vua-tiwaa?” ");
INSERT INTO khz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Taunilimalima ragai pio agirorira, pe Palagu na gomi maki ragai pene agirorimi. ");
INSERT INTO khz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kwalana gomi gemi veagirori vetainai, gomi maki vovetaina Palagu na pene agirorimi; e raka govega-vetovo-veni-tiwarana, Palagu na maki vopene vega-vetovo veni-tiwami. ");
INSERT INTO khz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Rakagau gaurai goi tarimu matanai ripiripi ogitaana, na lako tupina goi matamu aonai ati otugamagiana? ");
INSERT INTO khz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Arigi rauparai goi tarimu ovaikilaana, ‘Gata, matamu ai ripiripi ana gaivagia vou,’ na goi matotaumu matamu ai lako tupina ta emiana? ");
INSERT INTO khz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Goi opakau taumu, kune goi matamu ai lako tupina ono gaivagia vou, e ono poepoe-namanama vou, tarimu matanai ripiripi pono gaivagia. ");
INSERT INTO khz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Veaga gaura kwaeva (karoverave talimara) ragai pio venira, e gemi kurukuru maki ragai pio pia-atira pae wailarai! Gagera na pia pana-talira, pia ruga-kule, mapia rale-kinikinimi kalirana.” ");
INSERT INTO khz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Noginogi ai Palagu na pene venimi, vetavuvetavu ai pio rawali, koekoe ai gemi vanagi pia kala-pakara. ");
INSERT INTO khz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kwalana pene noginogi talimana pene gapi, pene vetavuvetavu talimana pene rawali, e pene koekoe talimana Palagu na gena vanagi pene kala-pakaa. ");
INSERT INTO khz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gomi rai natumu melona na gauganigani pene nogia aonai, goi na vatu pono venia? ");
INSERT INTO khz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Pa magani pene nogi aonai, warowaro pono venia? ");
INSERT INTO khz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pio tugamagi, gomi rakava talimami, na gau namara natumi venivenira ripami, gaurana gomi Tamami kupai etaluna, ia na gau namara genogi-veniana talimara pene venira vegata! ");
INSERT INTO khz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Gomi rakagau goririwana talima na gemi ai pia kalagira kalara, ira geriai maki vovetaina pio kala. Mose gena rova e peroveta geria vevega-ripa kilara ganira taunatauna voa.” ");
INSERT INTO khz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Vanagi kokotinana pio laka-toga. A kwarega kapuna eago-veniana rauparana gagava, e gena vanagi maki kamu vagi, e gutuma voanana gelaka-togana. ");
INSERT INTO khz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Na maguli vanagivanagi ago-venina vanagina kokoti e rauparana maki kei galagala vagi, e taunilimalima ati vogonamo gerawaliana.” ");
INSERT INTO khz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Rogomi pio vetole peroveta opakau talimara geriana. Ira gomi gemi ai gevogomaina mamamoe rapugara ria, na aorai geria tugamagi uraura kwaevara rakavara vetaira. ");
INSERT INTO khz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ira vuavuarai vou pio ripara. Vine vuara (grapes) gau vekalavekala geriana ati gekwamona, e figi vuara maki gawa veginivegini geriana ati gegapirana. ");
INSERT INTO khz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gautupu namana genana vuara namara pene vega-walara, a gautupu rakavana genana vuara rakavara pene vega-walara. ");
INSERT INTO khz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gautupu namana na vuana rakavana ati pene vega-walaa, gelegelena, gautupu rakavana na vuana namana ati pene vega-walaa ripa. ");
INSERT INTO khz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Vuavua namara ati gevuana gautupura pia patira, kalovai pia pia-ragera. ");
INSERT INTO khz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Vovetaina gelegelenai peroveta opakau talimara maki vuavuarai pio ripara. ");
INSERT INTO khz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ati ‘Velekou, Velekou,’ negetina talimara maparara Kupa Basileiai pia laka-toga. Aikina. Rai, Tamaku kupai etaluna ekwalanaana e gena ririwa kalara ekalarana talimana gereganamo. ");
INSERT INTO khz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kota kamuna tomana pene kwara aonai, talima vogona na pia vaikilaku, nepiatiwa, ‘Velekou, Velekou, goi aramu ai gaperovetato, e goi aramu ai kala irau vagira vogo maki gakalarato.’ ");
INSERT INTO khz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ne au na pana vaikilara, napanatiwa, ‘Au ati ripaku gomi. Iokali, gomi kala rakava talimami.’” ");
INSERT INTO khz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Gaurana, rai au geku kila ekamonagirana e kalara ekalarana, ia talima maaonekana gena numa vatu atanai evega-rugaato vetaina. ");
INSERT INTO khz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gura erakurakuato, gapata erakato agi ekuluto vonuma ati emakaka-makakato, kwalana vatu atanai evega-rugaato. ");
INSERT INTO khz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A rai na geku kila ea ekamonagirana, na kalara ati ekalarana, ia kawakawa talimana vetaina, numa kwanokulo atanai evega-rugaato. ");
INSERT INTO khz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gura erakurakuato, gapata erakato, agi ekuluto vonuma epialauato e eketo-lovolovo-vagito.” ");
INSERT INTO khz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu gena vopata kilara ekilagi-gaturato mulinai, getanu-kouto talimara gutuma para na gena vevega-ripa kilara gevevega-kaliagirato. ");
INSERT INTO khz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kwalana gena kila matiavuna, ati ira geria rova gevevega-ripagirawai talimara geria kila vetaira. ");
INSERT INTO khz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu golo kukuna na emarigoto, taunilimalima gutuma para ia mulinai gelakato. ");
INSERT INTO khz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ne talima ta maleperana Iesu genai eagoto, wailanai evetiu-talito, ekilato, “Velekou, pene goi oririwana genai, taunatauna pono kala-alevaku e pono vega-namaku ripa.” ");
INSERT INTO khz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu gimana etugu-agoato, viti talimana enapa-kaunagiato, evaikilaato, “Aririwana, ono nama!” Ne veganamo lepera enamato. ");
INSERT INTO khz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iesu na evaikilaato, netiwato, “Talima ta ragai pono vega-ripaa. Ono laka, Rupu Veaga Velena na pene gitamu, e vekala-aleva vevenina gaura Mose na ekilagirato gelegelenai pono venia, pe taunilimalima pia ripa, goi ponama.” ");
INSERT INTO khz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu Kaperanaumai ekwarato, Roma vetali velena ta ia genai eagoto, Iesu enogiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Velekou, geku vetugunagi melona tauniparana ati ekalavo-kalavona, e viti maki kamu vagi evuaana.” ");
INSERT INTO khz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu na evaikilaato, netiwato, “Au awatina, pe ana wati vega-namaa.” ");
INSERT INTO khz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Vetali velena evega-geleto, netiwato, “Velekou, au epe ati gelegele goi au geku numai pono ragekau; gaurai goi tipomo ono kila, ne au geku vetugunagi melona pene nama. ");
INSERT INTO khz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Au maki talima reketa geria vegitatago kapulerai, e vetali talimara pa soldia au kapuleku ai. Au na ta avaikilaana, ‘Ono laka!’, natina elakana e mataa avaikilana, ‘Ono vogomai!’, natina evogomaina. E au geku vetugunagi melona avaikilaana, ‘Eia ono kalaa!’, ne ekalaana.” ");
INSERT INTO khz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu na gena kila ekamonagiato aonai, evevega-kali-rakavato. Ne ia mulinai gelakakauto talimara evaikilarato, netiwato, “Au na avaikila-taunataunamina, Isaraela aonai evetaina kamonagina ta rogoti ara rawalia. ");
INSERT INTO khz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Au na maki, avaikilamina taunilimalima garo rageragena e garo rigorigona na pia vogomai, Aperaamo, Isaako, e Iakobo ria velekwa kamuna pia gani-koukoua Kupa Basileia aonai. ");
INSERT INTO khz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Na tovotovonai Palagu na evirigirato talimara, Basileiai pia talu netiwato talimara, Palagu na pene pia-atira muli ai, mukuna kaikolo aonai. Vonai pia tagi, e karira pia kari-kikitalira.” ");
INSERT INTO khz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ne Iesu na vetali velena evaikilaato, netiwato, “Ono laka, gemu numai! Gemu kamonagi gelegelenai kalana pene wala.” Gena vetugunagi melona voorai enamato. ");
INSERT INTO khz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesu Petero gena numai elaka-togato. Vonai Petero gena tegama garena evitiato, tauniparana etiavutiavuto, pe emaoko-tagowai, Iesu na egitaato; ");
INSERT INTO khz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","gimanai egapito, ne gena viti eaikito, ekuliitito, ne ia egupuato. ");
INSERT INTO khz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Volavilavi palagu rakavara na eporogirato talimara vogo Iesu genai gevaiagorato. Iesu na vopalagu rakavara gena kila tiavuna na egui-atirato, e viti talimara maparara maki evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ekala vega-taunataunara Isaia, peroveta talimanana, ekilagirato gelegelena, netiwato, “Ia na gera viti-vua egapi-pakarato, e gera viti irauirau evuarato, evega-namarato.” ");
INSERT INTO khz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu na gutuma egitarato, gevogoago-vogoagowai gaurai gena melo evaikilarato, netiwato, “Ita vevanagi, kovu vokavanai.” ");
INSERT INTO khz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aonai rova evevega-ripagiawai talimana ta Iesu genai eagoto, evaikilaato, “Vevega-ripa talimamu, goi pono laka kapura mapararai au goi mulimu ai pana lakakau.” ");
INSERT INTO khz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu na evaikilaato, netiwato “Uraura kwaevara mageria kovoga, e manu mageria nuguvi, na Taunilimalima Natuna ati gena maitu kapuna.” ");
INSERT INTO khz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iesu gena melo taa na evaikilaato, “Velekou gemu kala, ana waikule, pe tamaku anave taoa vou.” ");
INSERT INTO khz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Iesu na evega-geleato, netiwato, “Muliku ai onoma lakakau, kwarega taura (Palagu ati gekwalanaana talimara) matotaura geria kwarega pia taora.” ");
INSERT INTO khz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu gati ai eragekauto, ripa getavuawai melora ria. ");
INSERT INTO khz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Gevanagiwai aonai, atilovana agi kamukamu kovu ai ekwarato, e aku maki gati aonai gevelaku-rigowai. A Iesu gati aonai emaituwai. ");
INSERT INTO khz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ne gena melo geagoto, gevagoato, negetiwato, “Velekou, ono vega-magulimai, ita tapuluna, roli takwaregana.” ");
INSERT INTO khz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu na evega-gelerato, netiwato, “Rakagau gaurai gokalina? Kamonagi kei talimami!” Ne Iesu ekuliitito, agi e aku ekila-wairato, ne gevega-aikito e erawa-taliato. ");
INSERT INTO khz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Taunilimalima maparara gevevega-kalito, negetiwato, “E raka talima vetaina ta? Agi e aku na maki karona gekamonagiana!” ");
INSERT INTO khz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Galileia kovuna vokavanai, Gadara (pa Gerasa) talimara geria tano ai, Iesu ekwarato, ne palagu rakavara na geporogirato talimara ruala kala kovogara na gevogomaiwai Iesu genai. Etalima ruala makaliagira, gaurana voraupara na ta ati elaka-vanagiwai. ");
INSERT INTO khz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ne tauria ruala Iesu gelailai-veniato, negetiwato, “Palagu natuna o, rakagau gemai ono kalaa notina? Goi povogomai enai, ono vega-vitivitimai ulanana, toma taunataunana roe nea vou pene kwara aonai, ei?” ");
INSERT INTO khz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Vonai ati rauvagi ai, pae laveta na geunaunawai. ");
INSERT INTO khz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Vovetaina gaurai palagu rakavara na Iesu genogiato, negetiwato, “Pene goi na oguiatimaina genai, ono tugumai pae geriai, ira aorai aia laka-toga.” ");
INSERT INTO khz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iesu na evaikilarato, netiwato, “Ioago!” Ne palagu rakavara votalima ruala aora na gelaka-piatito, geagoto, pae geriai gelaka-togato. Ne pae laveta na maparana golona geralupito, kovu ai gevegugutu-kwaregato. ");
INSERT INTO khz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pae gitatagora talimara geraka-velekeveleketo vanugai geagoto, vali maparana gepiaato, e palagu rakavana geporogirato talimara geriai rakagau ewalato maparara gevega-matagairato. ");
INSERT INTO khz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ne vanuga talimara maparara gevekoko-agoto, Iesu pia gitaa ulanana. Iesu genai gekwarato aonai, genogiato geria tanona pene laka-paka. ");
INSERT INTO khz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu gati ai eragekauto, ewaikuleto, kovuna evanagito gena vanuga taunataunanai eagoto. ");
INSERT INTO khz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Vonai talima reketa na tauniparana kavata ekwaregato talimana ta gepai maokomaokonai, Iesu genai gevua-agoato. Iesu na geria kamonagi egitaato, ne viti-rakava talimana evaikilaato, netiwato, “Natuku pono tiliga, gemu rakava patugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ne rova gevevega-ripagiawai talimara matotauria gevevaikilato, “Etalima Palagu ekilagi-piatogaana.” ");
INSERT INTO khz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu ripana ira rakagau getugamagiawai gaurai evaikilarato, netiwato, “Rakagau gaurai netugamagi rakavara vetaira gokalarana? ");
INSERT INTO khz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Raka para kilatiwa malaga, ‘Gemu rakava patugamagi-piatogaa’ naparatiwa, pa para kila, ‘Ono rugaiti, ono laka’ naparatiwa. ");
INSERT INTO khz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Au na ana vega-gitami, Taunilimalima Natuna magena rorirori, rakava pene tugamagi-piatogara etanoparai.” Ne Iesu na viti rakava talimana evaikilaato, netiwato, “Ono kuliiti, gemu gepa ono gapia, numai ono laka!” ");
INSERT INTO khz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ne votalima ekuliitito, gena numai elakato. ");
INSERT INTO khz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Taunilimalima na vokala gegitaato aonai, gekalito e Palagu gevega-rageato, kwalana tiavu vovetaira taunilimalima evenirato gaurai. ");
INSERT INTO khz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu voanana elaka-vanagiwai aonai, ia na talima ta arana Mataio egitaato, takiti monira gekokorawai numanai etanu-tagowai egitaato. Ne Iesu na evaikilaato, netiwato, “Muliku ai onoma laka.” Ne Mataio eraka-kuliitito, Iesu mulinai eagoto. ");
INSERT INTO khz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Iesu Mataio gena numai eganiganiwai aonai, takiti-koko talimara e kala rakava talimara vogovagi gevogomaito, Iesu magena melo ria geganigani-koukouto. ");
INSERT INTO khz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisea talimara reketa na gegitaato, ne Iesu gena melo gerenagirato, “Rakagau gaurana gomi gemi vevega-ripa talimana takiti-koko e kala rakava talimara ria geganigani-koukouna?” ");
INSERT INTO khz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu na vokila ekamonagiato, ne evega-gelerato, netiwato, “Nama talimara toketa ati getavurana, na viti talimara namo. ");
INSERT INTO khz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ioago, matotaumi na Veaga Pukana na ekilagiana kilana iove tavua, evetaina ekilana, ‘Au ati gomi gemi vevoiwai pa veveni gaura aririwarana. Au aririwana gomi na vetuga e kala nama pio vega-matagaira.’ Au kala rorirori talimara keakeara ati avogomaito, na kala rakava talimaramo.” ");
INSERT INTO khz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Voia mulinai Ioane Bapatiso gena melo Iesu genai geagoto, ne gerenagiato, “Rakagau gaurai ai e Parisea talimara gavokana, na goi gemu melo ati gevokana?” ");
INSERT INTO khz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu na evega-gelerato, netiwato, “Gomi gotugamagina, vegarawa valigu talimana gatana lagarai etaluna aonai pia tagi pa? Aikina! Tomana evogomaina, vegarawa valigu talimana gatana geriana pia gapi-gerevagia, vonai vou pia voka. ");
INSERT INTO khz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Talima taa na rapuga valiguna kiata rapuga kunena goti ati pene vega-pani-koura. Pene vovetaina pene kala genai, rapuga valiguna na kunena pene ralea, e verale maki pene kamu-vagi. ");
INSERT INTO khz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Talima taa na maki vine nanuna valiguna nanikoti kopina kunenai ati pene wagia. Pene vovetaina pene vekala genai, nanikoti kopina kunena pene verale, vine nanuna pene vepopo, e kopina pene rakava. Na vine nanuna valiguna nanikoti kopina valigunai pia wagi-rigoa nama. Ne ruala, vine nanuna e kopi pia mia ati pia rakava.” ");
INSERT INTO khz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu gena melo roe waevega-riparawai aonai vele ta ekwarato, Iesu gagena kwalanai etiu-talito, netiwato, “Au natuku vavinena ewagumona kiana pekwarega. Ita wati, gimamu ia atanai pono tao-kaua ne natuku pene maguli.” ");
INSERT INTO khz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu ekuliitito, ia goti geagoto. Gena melo maki ia ria geagoto. ");
INSERT INTO khz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Geagowai aonai, gare ta, gena viti rala vitina, rigolo gagalana ruala (12) eviti-agiato, evogomaito mulina kavanana ne gena rapuga rikinai enapakauto. ");
INSERT INTO khz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwalana ia etugamagito, “Gena rapugaimo pana gapikau ne pana nama.” ");
INSERT INTO khz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu eruga-kuleto, egitaato, netiwato, “Natuku, pono tiliga! Gemu kamonagi na pevega-namamu.” Ne veganamo gena viti enama-gatuto. ");
INSERT INTO khz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesu vovele gena numai elaka-togato. Turai vili talimara e tagi talimara kulura kamu vagi egitarato, ");
INSERT INTO khz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ne Iesu na evaikilarato, netiwato, “Iolaka-piati. Vavine ati pekwarega, ia e tipo emaituna.” Na taunilimalima na gemamai-agiato. ");
INSERT INTO khz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iesu na votaunilimalima gutuma etugu-piatirato mulinai, ia elaka-togato numa aonai, vavine gimanai egapito; ne vovavine etogaitito. ");
INSERT INTO khz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ekala valina votano maparanai gepia-lovolovoato. ");
INSERT INTO khz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu na vokapu eraokwaniato. Elakawai aonai, mata-kele talimara ruala mulina na geagoto, gekea-veniato, negetiwato, “Davida Natuna o, ai ono gita-vetugamai!” ");
INSERT INTO khz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu numai elaka-togato aonai, vomata-kele taura ruala maki geragekauto. Ne Iesu na erenagirato, netiwato, “Gomi na govega-taunataunakuna, au na pana vega-namami ripa?” Ira gevega-geleto, negetiwato, “Pa, Velekou, gavega-taunataunamuna.” ");
INSERT INTO khz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nea Iesu na matara enapa-kaunagirato, netiwato, “Gemi kamonagi rorinai, kalana pana kalaa gemi ai.” ");
INSERT INTO khz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ne matara gealirato. Iesu maaona maparana ria na evaikila-gaokarato, netiwato, “Ekala pewala ea valina talima ta ragai pio vega-ripaa!” ");
INSERT INTO khz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Na tauria ruala gelaka-piatito, geagoto, Iesu valina votano maparanai gepia-lovolovoato. ");
INSERT INTO khz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tauria ruala numa na gelaka-piatiwai aonai, talima ta, palagu rakavana na eporogiato gaurai ati ekilakilawai, Iesu genai geago-agiato. ");
INSERT INTO khz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesu na palagu rakavana egui-atiato mulinai, vomuru-kapu talimana veganamo ekilakilato. Taunilimalima maparara na eia ewalato kalana gevevega-kaliagiato, gekilato, “Evetaina kalana ta Isaraela aonai rogoti ere wala!” ");
INSERT INTO khz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A Parisea talimara gekilato, “Ia e palagu rakavara geria vele tiavuna na palagu rakavara ia na egui-atirana.” ");
INSERT INTO khz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu na vanuga kamura e keira maparara eago-venirato: Geria rupu ai evevega-ripawai, Palagu gena Basileia valina namana evopatagiawai, e viti e viti-vua talimara maparara evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iesu na votaunilimalima gutuma para egitarato aonai evetugarato, kwalana aora gevekwalavito e ati geria veveakava talimara, vega-gelegelena mamoe ati tau gitatagora talimana vetaina. ");
INSERT INTO khz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ne Iesu na gena melo evaikilarato, netiwato, “Makora gitagitana kamu, na inagulu-agina talimara ati vogo. ");
INSERT INTO khz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Araga ganiganina venivenina Velekouna pio nogia, pe inagulu talimara pene tugura, gena ganigani koko aragarai.” ");
INSERT INTO khz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu na gena melo gagalana ruala ekearato, ne tiavu evenirato, palagu rakavara pia gui-atira, viti e viti-vua maparara pia vega-namara ulanana. ");
INSERT INTO khz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Eapostolo talimara gagalana ruala arara ea: Tovotovona ia Simona, arana ta Petero, ia tarina Anduru; Teimiti Tepetaio natuna, tarina Ioane goti; ");
INSERT INTO khz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo e Batolomio; Tomas e takiti-koko talimana Mataio; Teimiti Alfia natuna, e Tadio; ");
INSERT INTO khz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simona, Selote talimana, e Iudas Isakariota, Iesu pene lewaa talimana. ");
INSERT INTO khz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Etalima gagalana ruala Iesu na etugu-atirato e velaunagi gavutinara evetaina evenirato, netiwato, “Ati Iuda talimara geriai ragai pio ago, e Samaria vanugara taai maki ragai pio laka-toga; ");
INSERT INTO khz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","na Isaraela talimara geriai pio ago, ira gelekwalekwato mamoera vetaira. ");
INSERT INTO khz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ioago, evetaina pio vopata, nopiotiwa, ‘Kupa Basileia pevekavi-vagi, (Palagu gena vegitatago tiavuna evega-rugaana ea)!’ ");
INSERT INTO khz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Viti talimara pio vega-namara, kwarega talimara pio vega-magulira, lepera talimara pio alevara e pio vega-namara, e palagu rakavara pio gui-atira! Gomi na gogapiato ati voina, pio veni maki ati voina. ");
INSERT INTO khz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gemi lakalakai moni ragai pio gapikau, kolo pa siliva monira pa kopa monira maki ragai pio vuakau. ");
INSERT INTO khz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Palaka ragai pio gapikau, tiati ruala, tamaka, e toki maki ragai pio gapi. Kwalana inagulu talimana gena e gana pia venia vegata. ");
INSERT INTO khz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Vanuga kamuna taai pa vanuga keina taai pio laka-toga aonai, rai na eririwamina gena numai pene gapi-ragemi netina talimana pio tavua. Vonumaimo pio talu, pene ago vovanuga pio raokwania. ");
INSERT INTO khz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Numai golaka-togana aonai, numa talimara pio vega-namara, nopiotiwa, ‘Maino gomi gemi ai pene mia!’ ");
INSERT INTO khz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pene vonuma talimara na pia gapi-ragemi genai, Palagu gena maino geriai pene mia. Na pene ira na ati pia gapi-ragemi genai, Palagu gena maino geriai ragai pene mia, gemi ai mapene waikule. ");
INSERT INTO khz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Arigi numai pa pene aikina arigi vanugai taunilimalima na ati pia gapi-ragemi e gemi kila ati pia kamonagira genai, vonuma pa vanuga pio raokwania, gagemi kavura pio kwarikwari vagira, (ira geria kila ketoketo vega-taunataunara ulanana). ");
INSERT INTO khz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Au na avaikila-taunataunamina, Palagu gena Kota tomanai vonuma pa vovanuga geria rakava voina metauna kamu galagala vagi pene gapia, Sodoma e Gomora geria rakava voira maki pene vanagia.” ");
INSERT INTO khz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Iokamonagi, au na atugumina mamoe vetaira uraura kwaevara rakavara nuganugarai. Gaura pakurai, gelema vetaira pio aoneka e pio marana pune vetaira. ");
INSERT INTO khz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Rogomi pio vetole taunilimalima geriai! Kwalana ira na pia gapimi mapia tugu-agomi Iuda geria kaonsela talimara geriai, e geria rupu aorai pia kwarimi. ");
INSERT INTO khz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Au gogapi-ragekuna gaurai, kavana e vele kamura pa pene aikina king geriai pia gapi-agomi, ira wailarai au vega-taunataunaku ai pio ago, kwalana ati Iuda talimara maki Vali Namana pia ripaa. ");
INSERT INTO khz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pene Kota talimara wailarai pia gapi-agomi genai, rakagau pio kilagia pa pene aikina raka pio kilagi-tiwara kilara ragai pio tugamagiagi-vekwalavira. Kwalana votoma rakagau pio kilagira kilara Palagu na vou pene venimi. ");
INSERT INTO khz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ati gomi pio kila, na Palagu Palaguna gomi gemina pene kila. ");
INSERT INTO khz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Kakana na tarina pene lewaa pene kwarega ulanana, tamana na natuna maki vovetaina pene kalaa. Natura na tamara e tinara pia karoverave-venira e kwaregai maki pia taora. ");
INSERT INTO khz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Taunilimalima maparara na pia aorakava-venimi, kwalana au gogapi-ragekuna gaurai. Na rai pene vaigaoka ikanai pene maguli. ");
INSERT INTO khz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Vanuga taai pia vega-rakavami e pia guimi genai, vanuga taai mapio ago. Pio ripa rorirori, geku inagulu ati pio vega-aikia Isaraela vanugara maparara aorai, pene ago o, Taunilimalima Natuna penema kwara. ");
INSERT INTO khz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ripa etavuana talimana na gena vevega-ripa talimana ati pene vanagia; vetugunagi talimana na ekune-agiana talimana maki ati pene vanagia ripa. ");
INSERT INTO khz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ripa etavuana melona pene vevega-ago gena vevega-ripa talimana goti pia gelegele, e vetugunagi talimana ekune-agiana talimana goti maki pia gelegele voo nama. Pio tugamagia, taunilimalima reketa na au pamili repana, Belsebul pa Satani negetina, na gomi, geku pamili talimami, maki vovetaina pia kilagimi, e pia vega-metaumi maki.” ");
INSERT INTO khz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Gaura pakurai, taunilimalima kalira na ragai pio kali. Vekougavu gaura maparara pia matagai, veavuga kilara maparara pia ripara. ");
INSERT INTO khz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Au na rakagau pavarami mukunai mapio kilagi-waira lagani maekanai, rakagau geregami na pio kamonagira numa kukura na mapio kilagi-matagaira, (taunilimalima maparara na pia kamonagira ularana). ");
INSERT INTO khz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Taunipara pia vagia talimara kalira na ragai pio kali, kwalana ira na palagu ati pia vagia. Na Palagu kalinana ne pio kali, kwalana ia na ruala pene vagira ripa, taunipara e palagu, kalova ati eputena kapunai. ");
INSERT INTO khz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Manu ruala maki toea kwapuna namo gevoirana, ei? Na ira ta ati pene ketorigo-kawa kwano ai, pene Tamami ati pene ririwa genai. ");
INSERT INTO khz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A gomi repami guira maki maparara Palagu na evega-agi-gitakaurato. ");
INSERT INTO khz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pe ragai pio kali; gomi voimi verage vagi, manu girigiri vogo voira maki govanagirato.” ");
INSERT INTO khz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Rai na au taunilimalima wailarai pene kilagi-atiku, ia maki au na pana kilagi-atia Tamaku kupai etaluna wailanai. ");
INSERT INTO khz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Na au rai na taunilimalima wailarai pene rugaku e pene kilagi-veavugaku, ia maki au na pana rugaa e pana kilagi-veavugaa Tamaku kupai etaluna wailanai.” ");
INSERT INTO khz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ragai pio tugamagi, au maino tanoparai avuamaiato. Aikina, au ati maino avuamaiato, na vetali ulanana avogomaito. ");
INSERT INTO khz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Au avogomaito egaura pana vega-rugara ulanana: Natu melora na tamara pia vevagi-venira, natu vavinera na tinara pia vevagi-venira, tegama garera keira na geria tegama garera kamura pia vevagi-venira. ");
INSERT INTO khz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Numa gatana matotauna gena numa talimara na pia aorakava-vagia. ");
INSERT INTO khz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Rai na tamana pa pene aikina tinana pene ulamagi-kamura, a au pene tugamagi-keiku genai, ia ati gelegele au geku talimai pia kilagia. E rai na natuna melona pa pene aikina vavine vavinena eulamagi-kamuana, a au eulamagi-keikuna genai, ia ati gelegele au geku talimai pia kilagia. ");
INSERT INTO khz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","E rai matotauna gena satauro ati pene vuaa, e muliku ai ati pene laka, ia ati gelegele au geku talimai pia kilagia. ");
INSERT INTO khz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Rai gena maguli matotaunamo genai etaoana talimana, gena maguli pene piatogaa. Na rai au pakuku ai gena maguli pene piatogaa talimana, gena maguli ati pene vega-lekwalekwaa. ");
INSERT INTO khz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Rai na gomi egapi-ragemina, au maki egapi-ragekuna, talimana na au etugukuto Palaguna maki egapi-rageana. ");
INSERT INTO khz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Rai na peroveta talimana ta egapi-rageana, kwalana ia Palagu gena kila evega-matagaina talimana ta, ia na peroveta talimana voina pene gapia. E rai na kala rorirori talimana egapi-rageana, kwalana ia Palagu gena ririwa ekwalanaana talimana, ia na kala rorirori talimana voina pene gapia. ");
INSERT INTO khz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E talima taa na geku melo ta nanu pala kaperi ta vagi pene venia, kwalana ia au geku vetugunagi talimana, avaikila-taunataunamina, ia voina pene gapia vegata.” ");
INSERT INTO khz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesu na vovegavutina kilara gena melo gagalana ruala geriai ekilagi-gaturato mulinai, ia voanana Galileia vanugarai eagoto, vonai Palagu gena kila pene vevega-ripagia e pene vopatagia ulanana. ");
INSERT INTO khz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ioane Bapatiso tipura numanai etaluwai aonai, Keriso gena inagulu valira ekamonagirato, gaurana ia na gena melo Iesu genai etugu-agorato. ");
INSERT INTO khz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iesu gerenagiato, negetiwato, “Palagu na ekilagi-gavuato pene vogomai talimana goi, pa talima poluna ta paia aloa?” ");
INSERT INTO khz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Gaurana Iesu na evega-gelerato, netiwato, “Iowaikule, gomi na pogo kamonagira e pogo gitara gaura Ioane pio vega-ripaa: ");
INSERT INTO khz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mata-kele talimara gepoepoena, gage rakava talimara gelakana, lepera talimara genamana, tega-gela talimara gekamonagina, kwarega talimara gekuliiti-waina, e Vali Namana lealea talimara geria evopatagiana. ");
INSERT INTO khz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Au geku ai ati gena aovoaovo talimana evererena.” ");
INSERT INTO khz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ioane gena melo gelakawai aonai, Iesu na getanu-kouto talimara evaikilarato, Ioane valina geria ekilagiato, netiwato, “Ioane genai goagoto aonai, votanopakanai rakagau pio gitaa ulanana? Ralaka agi na elavu-aveaveana pio gitaa ulanana goagoto? ");
INSERT INTO khz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pene aikina genai, rakagau pio gitaa ulanana goagoto? Rapuga namana eligoana talimana gitagitana goagoto? Aikina. Rapuga namara geligorana talimara ira king geria numai getaluna. ");
INSERT INTO khz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na, rakagau pio gitaa ulanana goagoto? Peroveta talimana ulanana? Pa! Avaikilamina, gogitaato talimana ia peroveta talimara maparara evanagirana. ");
INSERT INTO khz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ioane valina Puka Veaga aonai evetaina etaloato, Palagu ekilato, ‘Au na geku vetugunagi talimana pana tugu-kunea, gemu raupara wailamu ai pene kala-maavua.’ ");
INSERT INTO khz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Avaikila-taunataunamina, etanoparai pia maguli talimara maparara nuganugarai Ioane Bapatiso ia kamu iwavagi, taa na ati pene vanagia. Na Kupa Basileiana aonai kapi talimana na Ioane pene vanagia. ");
INSERT INTO khz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ioane Bapatiso gena vopata evali-piagirato genana pene vogomai etoma, Palagu na gena Basileia pa vegitatago tiavuna evega-rugaana, na talima reketa na gevevagi-veniana geria ririwa matotaura pia vegita-tago, a rai Palagu gena Basileiai ene laka-toga netina talimana, ira na gekouana. (Mataio 23:13). ");
INSERT INTO khz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Peroveta talimara maparara e Mose gena rova maki na Palagu gena Basileia pa vegitatago gevopatagiawai, evogomaito pene vogomai, Ioane gena lagani ai. ");
INSERT INTO khz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","E gomi na geria kila pio gapi-ragera pa aikina, na Ioane ia taunatauna peroveta talimana Elia, gena vogomai gekilagiawai. ");
INSERT INTO khz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mategana talimana pene kamonagi. ");
INSERT INTO khz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Toma gulu talimara raira ria pana vega-gelegelera? Ia no melo girigiri vetaina, vanuga gatamanai getanu-tagona, geulaulana, kavata melora na kavata melora gekea-venirana, negetina, ");
INSERT INTO khz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ai vegarawa vererenai kita galavuwai gomi gemi, na gomi ati gopalawai! Ai kwarega marira gagapiwai, na gomi ati gotagiwai!’ ");
INSERT INTO khz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ioane evogomaito, evokato e vine nanuna ati eniuato. Gaurana gekilana, ‘Ia palagu rakavana na eporogiato,’ negetina. ");
INSERT INTO khz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A taunilimalima Natuna evogomaito, ia ganigani ta ati erugaana. Gaurana gekilana, ‘Ia ganigani gaoka talimana e vine nanuna eniu-gaoka-vagiana talimana, takiti-koko talimara e kala rakava talimara gatara!’ negetina. Na Palagu gena aoneka evega-matagaina e vega-taunatauna na gena kolema namara geriana.” ");
INSERT INTO khz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesu na gena tiavu inagulura vanuga kamura reketa aorai ekalagirato, na geria kala rakavara na ati gevetugamagi-kulewai, gaurana Iesu na vovanuga talimara egolorato. ");
INSERT INTO khz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ekilato, “Korasina o, goi e Betesaida, vetugami kika! Kwalana kala irau vagira gemi ai gematagaiwai Taia e Sidona aorai pegere matagai, na ira rauvagi pegere vetugamagi-kule, pute rakavarai e tauniparara makulumarai geria vetugamagi-kule pegere vega-matagaira. ");
INSERT INTO khz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na avaikilamina, Palagu na taunilimalima pene kota-venira tomanai, gomi na pio rawalia metauna Taia e Sidona geria metau pene vanagia.” ");
INSERT INTO khz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Goi maki, Kaperanauma o, goi oririwana kupai pono verage notina? Aikina, goi kwarega kapunai pono ago! Pene kala irau vagira gemi ai gematagaiwai Sodoma aonai pegere matagai genai, ia roe pere talu pene vogomai etoma. ");
INSERT INTO khz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na avaikilamina, Palagu na taunilimalima pene kota-venira tomanai, gomi na pio rawalia metauna Sodoma geria metau pene vanagia. ");
INSERT INTO khz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Volaganinai Iesu ekilato, “Tamaku o, kupa e tanopara Velena, avega-namamuna, kwalana goi na aoneka e ripa talimara geriai otao-veavugarana gaura ati ripara talimara geriai ovega-matagairana. ");
INSERT INTO khz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pa, Tamaku, gemu ririwa evetaina pene vetao vegata. ");
INSERT INTO khz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Gaura maparara Tamaku na evenikuto. Natuna talima ta ati ripana, na Tamana gereganamo ripana, e Tamana talima ta ati ripana, na Natuna gereganamo ripana, e Natuna na pene vega-matagai-venira netina talimara. ");
INSERT INTO khz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Au geku ai iovogomai, gomi raira maruna metaura govuana e goragana talimami maparami, au na agalagi pana venimi. ");
INSERT INTO khz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Au geku maruna, geku vegitatago namana, iomai-gapiragea, au geku ai ripa maki iomai-gapia! Kwalana au na ati pana ririwamagimi e ati pana gita-guilagimi. Au geku ai agalagi taunataunana pio rawalia. ");
INSERT INTO khz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Au na maruna malaga e pagami ai pio vuaa maki ati metauna.” ");
INSERT INTO khz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Volaganinai Iesu Tapati tomanai vuiti aragara na elaka-vanagiwai. Gena melo evitorato gaurai, vuiti vuara gekwamorawai e geganirawai. ");
INSERT INTO khz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisea talimara na gegitarato, ne Iesu gevaikilaato, negetiwato, “Ono gitaa, gemu melo na ita gera rova ati gekwalanaana, Tapati tomanai vuiti gekwamona.” ");
INSERT INTO khz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Iesu na evega-gelerato, netiwato, “Davida na kala ta ekalaato, ia mataukavana ria evitorato gaurai, gomi na ekala ewalato gauna rogoti goro agia? ");
INSERT INTO khz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Palagu gena numai elaka-togato, Palagu wailanai getaorawai peretira ia magatana ria na geganirato. Vopereti maveagara, Rupu Veaga veleramo garia, rova. ");
INSERT INTO khz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","E gomi na Mose gena rova aonai ekila maki rogoti goro agia, netina, Tapati tomanai Rupu Veaga velera Rupu Veaga aonai geinaguluna. Gaura pakurai Tapati rovana gevega-rakavaana, na ira ati geria kepi? ");
INSERT INTO khz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Au na avaikilamina, enai talima ta, ia na Rupu Veaga evanagiana. ");
INSERT INTO khz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Puka Veaga ekilana, ‘Vetuga ne aririwaana, a vega-nama paera vou ragaina.’ Pene ekila ganina goripaana genai, ati geria kepi talimara ragai pogoro vega-rakavara. ");
INSERT INTO khz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kwalana Taunilimalima Natuna ia Tapati Velena.” ");
INSERT INTO khz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesu na vokapu eraokwaniato, eagoto, Iuda talimara geria rupu ai elaka-togato, ");
INSERT INTO khz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","gimana ekeveto talimana ta maki vonai. Parisea talimara na Iesu pia vega-vekwakunagia gaurai gerenagiato, negetiwato, “Tapati tomanai viti pita vega-namara marovana pa?” ");
INSERT INTO khz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ne Iesu na evega-gelerato, netiwato, “Gomi ta gena mamoe kwapuna gerega vagina Tapati tomanai lega aonai pere keto-rigo genai, vega-magulina kavanai gomi na ati pogoro rolo-ragea? ");
INSERT INTO khz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pio tugamagi: Taunilimalima tugamagi-venina gau kamu iwavagina, a mamoe genai gau kei vagina! Gaura pakurai Tapati tomanai kala namana kalagikalagina rorirori vagi.” ");
INSERT INTO khz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ne Iesu na vogima-keve talimana evaikilaato, netiwato, “Gimamu ono tugu-roriroria.” Ia gimana etugu-roriroriato, ne maparana enama-gatuto, gimana kavata maki vovetaina. ");
INSERT INTO khz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Na Parisea talimara gelakatito, genavuga-kouto, Iesu raka pia vagi-kwarega-tiwaa rauparana getavuato. ");
INSERT INTO khz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Parisea geria navuga Iesu na warau eripa-kuneato gaurai, ia vokapu na elaka-gerevagito. Taunilimalima gutuma ia mulina na mageagoto, e viti talimara maparara evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na evaikila-gaoka-vagirato, ia valina talima ta ragai pia vega-ripaa. ");
INSERT INTO khz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Evetaina ekilato, kwalana Isaia peroveta talimana muruna na elakatito kilana pene taunatauna ulanana, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ia au geku vetugunagi talimana, avirigiato. Au na ia aulamagiana, e ia genai maki avererena; Au palaguku ia genai pana taoa, e ia na au geku kila e kala rorirorira pene vopatagira taunilimalima maparara geriai. ");
INSERT INTO khz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ia ati pene kogo, e ati pene inala; e gatamai karona maki taa na ati pene kamonagia. ");
INSERT INTO khz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ia na ponu ati pene gaukorua, e emole irauna lamepana ati pene kala putea, pene ago ia na kila e kala rorirorira pene vega-rugara, ne pia tiliga. ");
INSERT INTO khz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ia genai taunilimalima maparara geria veraramani pia taora.” ");
INSERT INTO khz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ne reketa na palagu rakavana na eporogiato talimana Iesu genai gevua-agoato. Votalima matana kele e muruna kapu. Iesu na evega-namaato, ne ekilakilato e epoepoeto. ");
INSERT INTO khz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Taunilimalima maparara ekala ewalato genai gevevega-kali-rakavato, negetiwato, “Ia peiramu Davida Natuna pa, (Palagu na ekilagi-gavuato vevega-maguli tauna)?” ");
INSERT INTO khz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na Parisea talimara na eia gekamonagiato aonai, gekilato, “Ia e Belsebul, palagu rakavara geria vele, na tiavu eveniana gaurai, etalima na palagu rakavara egui-atirana.” ");
INSERT INTO khz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu na geria tugamagi warau eriparato gaurai, evaikilarato, netiwato, “Kaomani pene veware, matotauna pene galama pakurai, ia pene rakava-vagi; e vanuga ta pa kwalu ta pene veware, matotauna pene galama genai, ati pene ruga ripa. ");
INSERT INTO khz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","E tiapolo taa na tiapolo ta pene gui-kalia genai, Satani ia matotauna pene galama, voia ganina kwalu ta warau peveware-kavaluga pakunai, ati pene ruga ripa? ");
INSERT INTO khz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Gomi gokilana, au Belsebul gena tiavu na palagu rakavara agui-atirana, a gomi mulimi ai gelakana talimara na palagu rakavara rakavetaina gegui-atirana? Ira na gevega-taunataunaana, gomi gemi kila ati rorirori. ");
INSERT INTO khz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aikina, ati Belsebul, na Palagu Palaguna gena tiavu ai aguirana, gaurai pio ripa, Palagu gena Basileia gomi gemi ai warau pekwara. ");
INSERT INTO khz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Talima ta tiliga talimana gena numa ati pene lovoa ripa, e gena rinaga pene kali-agira, na ia na tiliga talimana walo na pene ligoligoa, voanana vou gena numa rinagara pene kali-agira. ");
INSERT INTO khz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Rai na au ati eveakavakuna, ia na au erugakuna, e rai au goti ati gatao-kouna, talimana ekala-lovolovona. ");
INSERT INTO khz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Voia pakunai avaikilamina, taunilimalima rakava gekalaana e Palagu gekilagi-rakavaana talimara, geria rakava maparara Palagu na pene tugamagi-piatogara ripa, na talima taa na Veaga Palaguna pene kilagi-rakavaa talimana, gena rakava ati pene tugamagi-piatogara. ");
INSERT INTO khz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Talima taa na Taunilimalima Natuna pene kilagi-rakavaa genai, gena rakava pene tugamagi-piatogaa, na talima taa na Veaga Palaguna pene kilagi-rakavaa talimana, gena rakava ati pene tugamagi-piatogaa, toma magulina aonai e maguli kapinai maki ati pene tugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Pene gautupu namana genai, vuavuana maki nama, a pene gautupu rakavana genai vuavuana maki rakava. Gautupu vuavuanai pono ripaa. ");
INSERT INTO khz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gomi warowaro natura, marakavami ria gotaluna, kila namana ta raka pio kilagi-tiwaa? Kwalana talima aona na ema ragena gauna, muruna na ekilagiana. ");
INSERT INTO khz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Talima namana na gau namara aonai etao-kourana gaura pene vega-laka-piatira. Talima rakavana na gau ati namara aonai etao-kourana gaura pene vega-laka-piatira. ");
INSERT INTO khz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Na au na avaikilamina, kila kawakawa maparara, taunilimalima na pia kilagira Palagu gena Kota kamuna tomanai voira pia gapira. ");
INSERT INTO khz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gemu kilakilai Palagu na kala rorirori talimamu ai pene kilagimu, pa kala rakava talimamu ai pene kilagimu.” ");
INSERT INTO khz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Rova gevevega-ripagirawai talimara e Parisea talimara reketa na Iesu gevaikilaato, negetiwato, “Vevega-ripa tauna, ai gaririwana vegailia irauna ta goi gemuna pagara-gitaa.” ");
INSERT INTO khz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesu na evega-gelerato, netiwato, “Toma gulu rakavana mamata poragana (Palagu genana egerevagito guluna), tiavu vegailiana ta gegita-vetavuana, na vegailia ta ati pia rawalia, Iona, peroveta talimana, kolemanamo. ");
INSERT INTO khz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Iona toma toitoi e pogi toitoi magani kamu gauvelako tinagenai etaluwai, vovetainamo Taunilimalima Natuna maki toma toitoi e pogi toitoi kwano aonai pene talu. ");
INSERT INTO khz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kota kamuna tomanai Nineva talimara pia rugaiti, toma gulu talimara pia tamanira, kwalana Iona gena vopata gekamonagiato aonai, ira geria rakava na gevetugamagi-kuleto, e gelaka-kuleto Palagu genai. Na iogitaa, talima taa na Iona evanagiana talimana ea. ");
INSERT INTO khz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kota kamuna tomanai maki, Seba kuinina pene rugaiti, egulu valiguna pene tamanira, kwalana ia rauvagi na evogomaito, Solomona gena aoneka kilara pene kamonagira ularana. Na iogitaa, talima taa na Solomona evanagiana talimana ea.” ");
INSERT INTO khz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Palagu rakavana ta talima ta genana elaka-vagito, nea tano lakilaki na elaka-vanagito, aga pene gani netiwato, na agalagi kapuna ta ati erawaliato. ");
INSERT INTO khz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nea ia matotauna ekilato, ‘Ana waikule araokwaniato numanai.’ Ewaikule-waito, numa erawaliato. Numana kovagona, kala vealeva gitagitana nama iwavagi. ");
INSERT INTO khz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Gaurana ia na palagu rakava vagira taulatoi kwapuna (7) maevaiagorato, maparara gelaka-togato, vonai getaluwai. Gaurana votalima kunenai gena rakava kiata kei, na ikana kavanai gena rakava kamu iwavagi. Evetaina toma gulu rakavana genai pene wala.” ");
INSERT INTO khz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu taunilimalima roe waevaikilarawai aonai, ia tinana e walakavana gekwarato. Numa mulinai gerugato, geria ririwa Iesu pia vaikilaa. ");
INSERT INTO khz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Talima taa na evaikilaato, netiwato, “Goi tinamu e tarimu numa mulinai geruga-tagona, geririwana ia vaikilamu negetina.” ");
INSERT INTO khz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu na evega-gelerato, netiwato, “Au tinaku rai, e au tariku raira?” ");
INSERT INTO khz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Gaurana gimana na gena melo eruirato, netiwato, “Au tinaku e au tariku goi ea! ");
INSERT INTO khz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Rai na au Tamaku kupai etaluna gena ririwa kalara ekalarana talimana ia au walakavaku e au walawalaku e au tinaku.” ");
INSERT INTO khz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Votomamo Iesu na numa eraokwaniato, eagoto, Galileia kovuna kavatai etanu-talito. ");
INSERT INTO khz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Taunilimalima gutuma para na getanu-gegelagiato gaurai, ia gati gautai eragekauto, etanu-talito, na talima maparara kone ai gerugato. ");
INSERT INTO khz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iesu na gau vogo parapore ai evega-riparato. Netiwato, “Araga tauna ta gena vuiti uvera varovarora eagoto. ");
INSERT INTO khz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ia na vuiti uvera epia-lovolovorawai aonai, kapu irauirau ai geketoto. Reketa rauparai geketoto, ne manu geraumaito, gegani-gatu-vagirato. ");
INSERT INTO khz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Reketa vatu atarai geketokauto kwano magivi ai. Atirau gekalato, kwalana kwano atanaimo. ");
INSERT INTO khz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gaurana garo erala-kauato egorerato, lamura ati geverigo-namato gaurai, atirau gemalaito. ");
INSERT INTO khz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Reketa gawa vekalavekala aorai geketoto. E gawa vekalavekala warigi gekala-gitato gaurai, varovaro gaura gekala-gavurato. ");
INSERT INTO khz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A reketa kwano namai geketoto, gevuato aonai, reketai tinavuna (100), reketai gagala taulatoi (60), e reketai gagala toitoi (30).” ");
INSERT INTO khz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Iesu gena kila ikanai netiwato, “Mategana talimana pene kamonagi!” ");
INSERT INTO khz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iesu gena melo ia genai geagoto, ne gerenagiato, negetiwato, “Rakagau gaurai parapore ai taunilimalima ovega-riparana?” ");
INSERT INTO khz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Iesu na evega-gelerato, netiwato, “Kupa Basileia gena ripa veavugara gomi gemi ai ira matagai, na ira geriai aikina. ");
INSERT INTO khz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Magena kamonagi talimana Palagu na tugamagi-ilu pene venia, kamu iwavagina pene rawalia ulanana. Ati gena kamonagi talimana, gena tugamagi-ilu keina maki pene gapi-vagia. ");
INSERT INTO khz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Vovetaina gaurai au na parapore ai avega-riparana. Kwalana matara na gepoepoena, na ati gegitailiana, gekamonagina, na ati getugamagi-rorirorina. ");
INSERT INTO khz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ira geriai Isaia gena peroveta kilana pema taunatauna, evetaina ekilana, ‘Gomi pio kamonagi, e mapio kamonagi, na ati pio ripa-rorirori. Gomi pio gita, e mapio gita, na repami ati pia vekala-paka. ");
INSERT INTO khz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kwalana egulu talimara nugara gaoka-poro, tegara maki gela, matara maki gevekouto. Matara na nege gitana kalinana, tegara na nege kamonagina, nugara na nege ripa-rorirorina kalinana, e au geku ai nege vetugamagi-kulena geria Palagu, ne naavega-magulirana kalinana.’ ");
INSERT INTO khz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","A gomi pio verere, kwalana matami gegitana e tegami gekamonagina. ");
INSERT INTO khz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Au na avaikila-taunataunamina: Peroveta talimara vogo e Palagu gena kala rorirori talimara gutuma erapa geria ririwa kamuna gomi na rakagau gogitaana pia gitaa, na ati gegitaato, gomi na rakagau gokamonagiana pia kamonagia, na ati gekamonagiato.” ");
INSERT INTO khz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Iokamonagi, vuiti pia-lovolovona talimana paraporena ganina ea: ");
INSERT INTO khz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Talima reketa na Palagu gena Basileia valina gekamonagiana, na ati getugamagi-iluana. Gaurana Satani evogomaina, ne vorakagau ira aorai pege varoa gaura ia na egapi-vagirana. Votalima vuiti vuara rauparai geketona vetaira. ");
INSERT INTO khz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Vuiti uvera reketa vatu ai geketoto, eira e talima reketa na Palagu gena Vali Namana mavererera na gekamonagiana e gegapi-rageana. ");
INSERT INTO khz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Na ira nugarai ati elakatoga-gitakauna gaurai, ati emia-rauna. Palagu gena kila pakunai lagani rakavara gewaitagona e gevitivitina tomarai, ia genana gelaka-gerevagina. ");
INSERT INTO khz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Vuiti uvera reketa gawa vekalavekala vekarawarai geketoto, eira gekilagirana, talima reketa na Palagu gena kila gekamonagiana, na matotaura geria maguli e rinaga vogora getugamagi-kamurana gaurana, Palagu gena kila gekouana, ati gevuana. ");
INSERT INTO khz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A vuiti uvera reketa kwano namanai geketoto, eira gekilagirana, talima reketa na Palagu gena kila gekamonagiana, e gegapi-rageana maaora maparara na, ira vuavuara maki gematagaina, reketa tinavuna (100), mareketa gagala taulatoi (60), e reketa gagala toitoi (30).” ");
INSERT INTO khz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu na parapore ta geria maekilagiato, netiwato: “Kupa Basileia talima ta vetaina, uve namara gena aragai evarorato. ");
INSERT INTO khz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ne pogi ta, taunilimalima maparara roe wagemaituwai aonai, evekuku-veniawai talimana evogomaito, gawa vuara gutura vuiti aorai epiarato, ne elakato. ");
INSERT INTO khz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Vuiti getuputupu-rageto, gekamuto e vuara getugurato aonai, gawa rakavara maki ira aora na getupu-rageto. ");
INSERT INTO khz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ne araga gatana gena vetugunagi melora ia genai gevogomaito, gevaikilaato, ‘Velekou, goi gemu aragai uve gutura namara ovarorato, ei? Na egawa rakavara e ravanana pege vogomai?’ ");
INSERT INTO khz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ia na evega-gelerato, netiwato, ‘Evekuku-venirana talimana na ekala pema kalaa.’ Vetugunagi melora na gerenagiato, negetiwato, ‘Pene oririwana genai, aia ago, pe paia lagura pa?’ ");
INSERT INTO khz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ia evega-geleto, netiwato, ‘Ragaina, kwalana irauna gawa lagulagurai vuiti maki lamura nogo lagu-kaurana nea. ");
INSERT INTO khz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ira ruala ia kala-kou, e ia mia pene ago, vuiti vuana patipatina tomana pene kwara. Votomai au na patipatina talimara evetaina pana vaikilara, napanatiwa: Tovotovona gawa maparara iotao-koura, pio rekora, pe kalova na pene galara, a vuiti maki pio tao-koura, pe geku ganigani taokouna numanai pio taora.’” ");
INSERT INTO khz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu na parapore ta maevaikilagirato, netiwato, “Kupa Basileia mastadi vuana vetaina, talima taa na egapiato, gena aragai evaroato. ");
INSERT INTO khz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tanoparai varovaro gaura maparara nuganugarai ia geregana kei galagala vagi, na ekalana aonai, varovaro gaura maparara nuganugarai iamo kamu iwavagi. Ia evekamu-vagina aonai, manu raurau gelovomaina, ia raganai geria nuguvi gekalarana.” ");
INSERT INTO khz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu na parapore ta geria maekilagiato, netiwato, “Kupa Basileia paraoa egoro-agiana mulamulana vetaina, gare taa na girina kiatamo egapiato, paraoa goti ekiro-kourato, ne eraokwaniato, vomulamula na paraoa egoro-agiato e evega-kamuato.” ");
INSERT INTO khz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu na egau maparara parapore ai taunilimalima evega-riparawai. Gena vopatai parapore ati eraokwanirawai. ");
INSERT INTO khz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ekala ekalagiawai genana, peroveta talimana gena kila ema vega-taunataunaato, netiwato, “Au na parapore geriana ira pana vaikilara; tanopara evetinato tomana na pene vogomai etoma veavugai gemiana gaura, au na ira geria pana kilagi-matagaira.” ");
INSERT INTO khz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesu na votaunilimalima gutuma eraokwanirato, numai elaka-togato. Gena melo ia genai gevogomaito, ne gevaikilaato, negetiwato, “Gawa rakavara araga aonai paraporena ai gema poro kilagi-matagaia.” ");
INSERT INTO khz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu na evega-gelerato, netiwato, “Vuiti uvera namara evarorana talimana Taunilimalima Natuna. ");
INSERT INTO khz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Araga tanopara, uve gutura namara Palagu gena Basileia pa vegitatago tiavuna kapulenai getaluna talimara; gawa rakavara Satani gena taunilimalima. ");
INSERT INTO khz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","E gawa varovarona talimana Tiapolo, ita ekukurana talimana; tanopara ikana kuakua laganina vetaina. Pia kuaa e pia patia talimara aneru na pia kwalanaa. ");
INSERT INTO khz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Vega-gelegelena gawa getao-kourana, e kalovai gekapurana, egala-gaturana, tanopara peneve aiki aonai, vovetaina peneve mia: ");
INSERT INTO khz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Taunilimalima Natuna na gena aneru pene tugura, taunilimalima gevailearana talimara, e kala rakava gekalarana talimara maparara, Palagu gena Basileia genana pia gapi-gerevagira, ");
INSERT INTO khz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","e kalova tiavuna emole lailaina aonai pia piatogora, e vonai roe wapia tagi, karikarira maki pia gala kokikokira. ");
INSERT INTO khz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Votomanai maki Palagu gena kala rorirori talimara garo vetaina mamaekara ria tamara gena Basileia aonai pia talu. Rai mategana talimana pene kamonagi.” ");
INSERT INTO khz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Kupa Basileia rinaga veavugana tanoparai vetaina. Talima taa na erawaliato, ne maetole-gavuato. E mavererena eagoto, gena rinaga maparara evoi-agirato, ne votano evoiato.” ");
INSERT INTO khz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Kupa Basileia evetaina voivoi talimana pel ralemaralema etavuawai. ");
INSERT INTO khz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ia na pel ralema iwavagina e voina kamu iwavagina erawaliato, ne gena rinaga maparapara vagira evoi-agirato vou vovoina kamuna evoiato.” ");
INSERT INTO khz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Kupa Basileia vaiopu vetaina, nanu ai gepiaana aonai, magani irauirau gekou-gavurana. ");
INSERT INTO khz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Vaiopu evonuna aonai, gerolo-rageana kone taitarinai, enai vou gevirigirana, namara maparara korai geurarana, na rakavara maparara gepia-togarana. ");
INSERT INTO khz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vovetaina peneve mia, tanopara ikana pene kwara aonai. Aneru pia vogomai aonai, kala rakava talimara pia tao-gerevagira kala rorirori talimara geriana; ");
INSERT INTO khz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","e kalova molemolena aonai pia piatogora. Vonai pia tagi, karikarira maki pia vepati-tali.” ");
INSERT INTO khz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iesu na gena melo erenagirato, netiwato, “Ekila maparara aomi ai pogo ripa-gitakaura pa?” Ira na gevaikilaato, “Pa, Velekou.” ");
INSERT INTO khz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iesu na maevaikilarato, netiwato, “Gaura pakurai, pene rova gevevega-ripagirana talimana ta Kupa Basileia vevega-ripagina talimanai pene ago genai, ia numa gatana ta vetaina, gena rinaga valigura e kunera egapi-atirana gena rinaga etao-kourana numana na.” ");
INSERT INTO khz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu na eparapore ekilagi-gaturato vou, vokapu eraokwaniato. ");
INSERT INTO khz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Voanana vou ekamuto vanuganai ekwarato. Iuda talimara geria rupu ai evevega-ripawai aonai, ia gekamonagiawai talimara na gena vopata kilara gevevega-kaliagirato, e evetaina geverenagito, negetiwato, “Etalima gena ripa ravanai egapiato, e ekala irau vagira kalara maki raka ekalagi-tiwarana? ");
INSERT INTO khz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ia kapenta talimana natuna, ei? Ia tinana arana Maria negetina, ei? E ia tarina arara Teimiti e Iosepa, Simona e Iudas, ei? ");
INSERT INTO khz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","E ia walawalana maparara maki ita ria ea. Na eripa e etiavu maparara ravanana egapirato?” ");
INSERT INTO khz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Vovetaina getugamagi-aovoaovo-veniato gaurai, ira na ati gegapi-rageato. Iesu na evetaina evaikilarato, netiwato, “Peroveta talimana kapu mapararai pia kupa-kaua, na gena vanuga taunataunanai e gena numa talimara namo ati pia kupa-kaua.” ");
INSERT INTO khz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Vonai kala irau vagira ati vogo ekalarato, kwalana ati geria vega-taunatauna gaurana. ");
INSERT INTO khz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Volaganinai Heroda, Galileia velena, Iesu valina ekamonagiato. ");
INSERT INTO khz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ia na gena vetugunagi talimara evaikilarato, netiwato, “Ia e Ioane Bapatiso kwarega na pekuliiti-wai gaurana, kala irau vagira ekalarana.” ");
INSERT INTO khz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Heroda na Ioane egapi-taliato eligoligoato, tipura numanai etaviri-gavuato. Ia na evetaina ekala-veniato, kwalana ia kakana Filipo garawana, Herodia, galamanai. ");
INSERT INTO khz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ioane Bapatiso na Heroda evaikilaato, netiwato, “Goi na Herodia potavararia ati rorirori.” ");
INSERT INTO khz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heroda eririwa-rakavato, Ioane pene vagia, na taunilimalima kalira na ekalito, kwalana ira na Ioane getugamagiawai ia peroveta talimana ta. ");
INSERT INTO khz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aonai Heroda gena wala tomanai Herodia natuna vavinena wariwari talimara wailarai epalawai. Heroda maki epala na evega-verereato. ");
INSERT INTO khz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Gaura pakurai ia maaona maparana na kila gaoka vagina evetaina pala vavinena ekilagavu-veniato, netiwato, “Goi rakagau oririwaana gauna ono kilagia, pana venimu.” ");
INSERT INTO khz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Vavine tinana na warauna evaikila-kuneato e elau-naginagiato pakurai, ia evetaina ekilato, “Ioane Bapatiso repana rivu ai enai onoma veniku.” ");
INSERT INTO khz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Heroda nugana emetauto, na gena kilagavu warauna vavine genai ekalaato e wariwari talimara pakurai ekilato, pia venia. ");
INSERT INTO khz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ne gaurana talima repara epati-vagirawai talimana etuguato tipura numanai, Ioane repana epati-vagiato. ");
INSERT INTO khz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ioane repana rivu aonai geuraato vou, vavine geveniato. Ia na tinana genai eago-agiato. ");
INSERT INTO khz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Gaura pakurai Ioane gena melo gevogomaito, tauniparana gegapiato, getoleato. Voia mulinai geagoto Iesu gevevaraato. ");
INSERT INTO khz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu na Ioane gena kwarega valina ekamonagiato aonai, gati na vokapu eraokwaniato, kapu ati taunilimalimana kapunai eagoto. Na taunilimalima na gekamonagiato aonai, geria vanuga geraokwanirato, gagera na Iesu mulina na geagoto. ");
INSERT INTO khz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu kone ai etoga-rigoto aonai, taunilimalima gutuma para egitarato gaurana egita-vetugarato, e geria viti talimara evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lavi kavanai Iesu gena melo ia genai geagoto, ne gevaikilaato, “E kapu pakana, ati taunilimalimana, garo warau waeverigona etaunilimalima gutuma para ono tugura, pe vanugai ganigani piave voi.” ");
INSERT INTO khz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Iesu ekilato, “Ira ragai pia laka-lovolovo, gomi na garia iovenira, pe pia gani.” ");
INSERT INTO khz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ira na gevaikilaato, negetiwato, “Ai gemai e pereti imaima e magani rualamo ea.” ");
INSERT INTO khz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iesu na evaikilarato, netiwato, “Iovogomai-agira au geku ai.” ");
INSERT INTO khz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ne ia na egutuma para elaunagirato, gawa atarai pia tanu-tali netiwato, vonai vou ia pereti imaima e magani ruala egapirato, kupai epoe-rageto, Palagu evega-namaato epuki-kinikinirato, gena melo evenirato, ira na vou etaunilimalima gutuma para gevenirato. ");
INSERT INTO khz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Maparara gegani-kwaregato; kapinai Iesu gena melo na ganigani kovara gekoko-kourato, papalu gagalana ruala gevega-vonurato. ");
INSERT INTO khz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Geganito marumarumo maparara ragana imaima (5,000) vetaira, na gare manatura keikeira ria ati gevega-agirato. ");
INSERT INTO khz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Voia mulinai Iesu na gena melo evaikilarato, gati ai pia ragekau, pia kune, kovu kavatai pia vevanagi netiwato. Na ia votaunilimalima gutuma roe waetugu-lovolovorawai. ");
INSERT INTO khz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Etaunilimalima vogora etugurato vou, ia geregana golo ai everageto, pene rapali ulanana. Warau epogiato aonai ia roe voa, geregana. ");
INSERT INTO khz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Gati kiata mavepakana tanopara genana kovu nuganai, e aku na eaku-kepolekepoleawai, kwalana agi gati gena ago wailana kavana na evogomaiwai. ");
INSERT INTO khz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ora gauna 3 e 6 koloko vekarawarai amoamo kavanai, Iesu ira geriai eagoto. ");
INSERT INTO khz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aonai gena melo na nanu atanai elakawai gegitaato, ne nugara gepale-vagito, e gekali-rakavato, gekilato, “Avuavu para!” Gekalito gaurai gelailaito maki. ");
INSERT INTO khz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iesu na veganamo evaikilarato, netiwato, “Iovaigaoka, e au; ragai iokali.” ");
INSERT INTO khz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petero na evega-geleato, netiwato, “Velekou, pene goi genai, ono launagiku, pe nanu atana na pana laka, gemu ai pana wati.” ");
INSERT INTO khz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iesu ekilato, “Ono vogomai!” Ne Petero gati na epana-raito, nanu atanai elakato, Iesu genai eagoto. ");
INSERT INTO khz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Na Petero na agi (e aku) egitarato, ne ekalito, erai-rigowai gaurai elailaito, netiwato, “Velekou o, onoma vega-maguliku.” ");
INSERT INTO khz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iesu veganamo gimana etugu-agoato, genai evenapakauto, netiwato, “Kamonagi kei talimamu, rakagau gaurai oaovoaovona?” ");
INSERT INTO khz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tauria ruala gati ai geragekauto vou agi epia-taliato. ");
INSERT INTO khz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Gati ai talimara ia wailanai gealiruputalito, negetiwato, “Taunatauna vegata, goi Palagu Natuna.” ");
INSERT INTO khz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ira gati na gevanagito, Genesareta tanonai gekwarato. ");
INSERT INTO khz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Vokapu talimara na Iesu gegita-rawaliato, ne ia valina vokapu vanugara maparara gevega-riparato. Gaurana viti talimara ia genai gevua-agorato, ");
INSERT INTO khz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","e genogiato, gena rapuga rikinaimo maki pia napakau. Genapakauto talimara maparara warau genamato. ");
INSERT INTO khz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisea talimara e rova gevevega-ripagirawai talimara reketa Ierusalema na Iesu genai geagoto, negetiwato, ");
INSERT INTO khz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Rakagau gaurai goi gemu melo na ita kalakalara velera geria vevega-ripa ati gekamonagirana? Ira gimara maki ati raupara taunataunanai geguligirana vou geganiganina!” ");
INSERT INTO khz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu na evega-gelerato, netiwato, “Pe rakagau gaurai kalakalami velera geria vevega-nagi pio kwalanara pakurai, Palagu gena rova kilara gorugarana? ");
INSERT INTO khz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Palagu ekilato, ‘Tamamu e tinamu pono kupa-kaura,’ e ‘Rai na tamana pa tinana pene vaikila-rakavaa talimana pio vagi-kwaregaa!’ ");
INSERT INTO khz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Na gomi gokilana, talima taa na tamana pa tinana pene vaikilaa, nepenetiwa, ‘Au na gomi ati pana veakavami, kwalana para venimi gaura Palagu gena gaura maparara, gaurai ia aveniana.’ ");
INSERT INTO khz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Vokalara na gomi na talima gokouana, tamana e tinana ati pene veakavara e ati pene kupa-kaura. Gemi maguli kunera evetaira geriana Palagu gena rova kilara ati ganirai govega-agorana. ");
INSERT INTO khz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Opakau talimami, Isaia na eperovetagimito ekila-taunataunato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Eguluna murura tinatinaraimo au gekupa-kaukuna geria Palagu, na ira aora au geku ai rauvagi ai. ");
INSERT INTO khz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gealiruputali-veni-kawakuna, geria vevega-ripa taunilimalima geria vevega-nagi rovara, na ati au geku!’” ");
INSERT INTO khz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu na taunilimalima gutuma ia genai ekea-mairato, ne evaikilarato, netiwato, “Iokamonagi, e pio ripa-rorirori: ");
INSERT INTO khz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mulina elaka-togana talima muruna na gauna na ia ati evega-rakavaana, na rakagau ia aona na pa nugana garakauna na e muruna na elaka-piatina gauna na ia evega-rakavaana.” ");
INSERT INTO khz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Gena melo ia genai gevogomaito, ne gevaikilaato, negetiwato, “Goi ripamu, Parisea talimara goina kila pia kamonagira aonai, aora pia viti?” ");
INSERT INTO khz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesu evega-geleto, netiwato, “Tamaku kupai etaluna gautupu ati evarorato maparara pia tava-ragera. ");
INSERT INTO khz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Iotugamagi-lekwalekwara! Ira matara kele, na geririwana mata-kele talimara pia vaira. Pene mata-kele talimana na mata-kele talimana ta pene vaia ne, tauria ruala ropuropu ai pia keto-rigo.” ");
INSERT INTO khz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petero na evaikilaato, netiwato, “Ekila ganina taunataunana ono vega-ripamai.” ");
INSERT INTO khz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu na evaikilarato, netiwato, “Gomi maki ati gotugamagi-aonekana talima reketa vetaira? ");
INSERT INTO khz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ati goripana maki? Gau kwauta talima muruna na elaka-togana, eagona tinagenai, voanana eagona taunipara genana evelaka-piatina. ");
INSERT INTO khz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Na muruna na gelakatina gaura ira aona pa nugana na gevogomaina gaurai, egaura na talima gevega-rakavaana. ");
INSERT INTO khz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Talima aona na pa nugana na tugamagi rakava geragena gaurai, evagivagina, evegeno-agina, emata-poragana, elemana, Kota kapunai opakau kilara ekilagirana, e talima namara arara opakau kalarai evali-piagirana. ");
INSERT INTO khz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E gaura na talima evega-rakavaana; na gimamu ati oguligiana vou oganiganina, voanana talima ati evega-rakavaana.” ");
INSERT INTO khz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu na vokapu eraokwaniato, elakato eagoto pene ago Taia e Sidona kavara tanorai ekwarato. ");
INSERT INTO khz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ne vonai etaluwai aonai, Kanaana garena ta Iesu genai evogomaito, ekogo-lailaito, netiwato, “Velekou, Davida Natuna o, au ono vetugaku! Au natuku vavinena palagu rakavana na peporogia gaurai gena viti-vua etoma rakava galagala vagi.” ");
INSERT INTO khz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Na Iesu na ia ati evega-geleato. Aonai gena melo ia genai gevogomaito, genogiato, negetiwato, “Ono tugu-lakaa! Ita eraka-guiguirana e kulu kamu vagi ekalaana.” ");
INSERT INTO khz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iesu evega-geleto, netiwato, “Palagu na au etugukuto lekwalekwa mamoera, Isaraela talimara, ularanamo.” ");
INSERT INTO khz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ne vogare Iesu gagena kwalanai evetiu-talito, netiwato, “Velekou, ono veakavaku!” ");
INSERT INTO khz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu evega-geleto, netiwato, “Girigiri garia gau pita gapira, kwaeva pita pia venira ati rorirori.” ");
INSERT INTO khz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Gare na evega-geleato, netiwato, “Velekou, nee mataunatauna, na kwaeva na gau kala ketoketora gataria geria pata atarana maki geganirana.” ");
INSERT INTO khz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gaurana Iesu na evega-geleato, netiwato, “Kamonagi kamu garemu! Rakagau oririwaana kalana pene wala.” Voora kianai ia natuna vavinena enamato. ");
INSERT INTO khz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu na vokapu eraokwaniato, Galileia kovuna lagana na elaka-vanagito. Ne golo gauta kukunai everageto, atanai etanu-talito. ");
INSERT INTO khz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Taunilimalima gutuma para ia genai gevogomaito, viti irauirau talimara gevuamairato, reketa gage rakava, mata-kele, kopara na gealawai talimara, muru-kapu, e viti irauirau gutuma maki. Iesu gagena kwalanai gema tao-talirato, ne ia na evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Taunilimalima maparara na ekolema gegitaato aonai, gevevega-kali-rakavato, kwalana murura kapu talimara gekilakilato, gealawai talimara tauniparara magugulura kapurai gevetaoto, gage rakava talimara gelakato, mata-kele talimara gepoepoeto. Gaurana ira na Isaraela geria Palagu gevega-rageato. ");
INSERT INTO khz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu gena melo ia genai ekea-mairato, evaikilarato, “Au na e taunilimalima avetugarana, kwalana toma toitoi vegata au ria enai pege talu, e gau kwauta maki rogoti na gere gania. Gau ta rogoti gere gani aonai, au na ati pana tugu-lakara, kwalana rauparai neeve porimarana.” ");
INSERT INTO khz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Gena melo na gerenagiato, negetiwato, “Etanopakanai gau vogora raka pita rawali-tiwara egutuma para pita gupura?” ");
INSERT INTO khz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu na evega-gelerato, netiwato, “Gomi gemi ai pereti nee vira nea?” Ira na negetiwato, “Pereti taulatoi kwapuna (7) ai gemai ea, e magani girigiri reketa maki.” ");
INSERT INTO khz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ne Iesu na etaunilimalima gutuma para evaikilarato, kwano ai pia tanu-tali. ");
INSERT INTO khz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ne pereti taulatoi kwapuna e magani girigiri egapirato, Palagu evega-namaato, epuki-kinikinirato, gena melo evenirato, ira na tanukou talimara gevenirato. ");
INSERT INTO khz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Maparara gegani-kwaregato mulinai, Iesu gena melo na gau kovara gekokorato, papalu taulatoi kwapuna (7) gevega-vonurato. ");
INSERT INTO khz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Vogau geganirato aonai marumo maparara ragana vativati (4,000), na gare manatura ria ati gevega-agi-kaurato. ");
INSERT INTO khz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ne Iesu na egutuma para etugu-lovolovorato mulinai, ia gati ai eragekauto, Makadana tanonai eagoto. ");
INSERT INTO khz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisea e Sadukea talimara reketa Iesu genai geagoto, ne gerenagi-veripaganiato. Geria ririwa vegailia ta kupa na pere marigo, pia gitaa, ia taunatauna Palagu na etuguato talimana. ");
INSERT INTO khz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Na Iesu na evega-gelerato, netiwato, “Lavilavi aina garo everigona aonai, gokilana, ‘Kupa pekalovakalova, pe gura ati pene keto, gitagitana lagani nama.’ ");
INSERT INTO khz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A amoamo kavanai gokilana, ‘Toma gura maagina goti gevogomaina, kwalana kupa pekalovakalova, e gitagitana maki makalina.’ Kupa gogitaana gaurai, rakagau pio kilagia, lagani nama pa lagani rakava geriai rorinai, na ewagumona toma kolemana ati ripami! ");
INSERT INTO khz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Etoma gulu rakavana mavekalakauna (Palagu genana gegerevagito guluna), vegailia etavuna, na vegailia ati pana venimi, a Iona, peroveta tauna, genai ewalato vegailianamo.” Ne Iesu na eraokwanirato, geriana elaka-gerevagito. ");
INSERT INTO khz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kovu na gevanagito kavatai vou, Iesu gena melo geripato, gau ati gegapikauto. ");
INSERT INTO khz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ne Iesu na evaikilarato, netiwato, “Rogomi pio vetole, pio poepoe, kwalana Parisea talimara e Sadukea talimara geria paraoa egoro-agiana mulamulana rogona pio tolea.” ");
INSERT INTO khz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ira matotaura na gekilagi-koukourato, negetiwato, “Ia evetaina ekilana, kwalana pereti ati pata gapikau gaurai.” ");
INSERT INTO khz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu ripana ira na rakagau gekilagiato gaurai, erenagirato, netiwato, “Rakagau gaurai geregami na pereti ati pogo gapikau kilana gokilagiana? Kamonagi kei talimami! ");
INSERT INTO khz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gomi rogotina goro ripa-rorirori? E ati gotugamagiana pereti imaima (5) na taunilimalima ragana imaima (5,000) na geganirato, e kovara gokokorato papalu vira govega-vonurato? ");
INSERT INTO khz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","E ta maki, paraoa taulatoi kwapuna (7) na taunilimalima ragana vativati (4,000) na geganirato, e kovara gokokorato papalu vira govega-vonurato? ");
INSERT INTO khz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Rakagau gaurai aomi ati gevekala-pakana, e ati goripana, au ati pereti akilagirana? E ana kila: Parisea talimara e Sadukea talimara geria paraoa egoro-agiana mulamulana rogona pio tolea!” ");
INSERT INTO khz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gaurai ira nugara gevekala-pakato, e geripato maki, Iesu na ati paraoa mulamulana ekilagiato, na Parisea talimara e Sadukea talimara geria vevega-ripa kilara opakaura kavarai ekilato. ");
INSERT INTO khz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu eagoto, Kaisarea Filipi vanugana tanona kavanai ekwarato. Vonai ia na gena melo erenagirato, netiwato, “Taunilimalima rakagau negetina, Taunilimalima Natuna rai?” ");
INSERT INTO khz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ira gekilato, “Reketa gekilana, goi Ioane Bapatiso, reketa gekilana, Elia, e reketa gekilana, Ieremia pa peroveta talimana ta.” ");
INSERT INTO khz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iesu na erenagirato, netiwato, “Na gomi rakagau nogotina au rai?” ");
INSERT INTO khz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simona Petero na evega-geleato, netiwato, “Goi Keriso, maguli Palaguna Natuna.” ");
INSERT INTO khz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu na evega-gele-veniato, netiwato, “Simona, Ioane natuna, pono verere e vega-nama atamu ai pene mia, kwalana vevega-gele taunataunana povenia, eia ati talima ta genana pevogomai, na au Tamaku kupai etaluna na goi pevenimu. ");
INSERT INTO khz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Voia pakunai avaikilamuna: Goi Petero (ganina vatu), evatu atanai au geku ekalesia pana vega-rugaa. Kwarega tiavuna na maki ati pene lovoa. ");
INSERT INTO khz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Au na Kupa Basileia tavirira maki goi pana venimu; tanoparai pono ligora gaura maparara kupai maki Palagu na pene ligora; e tanoparai pono lugara gaura maparara kupai maki Palagu na pene lugara.” ");
INSERT INTO khz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ne Iesu na gena melo evaikilarato, talima ta ragai pia vega-ripaa ia Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna). ");
INSERT INTO khz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Volaganina na vegata Iesu na gena melo evega-ripa-kunerato, netiwato, “Au Ierusalemai aagona, pe Iuda velera, e Rupu Veaga velera kamura, e rova gevevega-ripagirawai talimara geriana roe avitivua-kamuvagina; e pia vagi-kwaregaku maki, na toma vega-toitoinai vou kwarega na mapana kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petero na evaigerevagiato, ne evaikilaato, netiwato, “Velekou, ati nevetaina; nevetaina ati pia vaivenimu, e ati pene wala maki.” ");
INSERT INTO khz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gaurai Iesu epoe-kuleto, Petero evaikilaato, netiwato, “Goi Satani, gekuna ono laka-gerevagi! Au geku lakalaka goi na oroli-gavuana, kwalana negemu tugamagi kilana ati Palagu genana evogomaina, na taunilimalima geriana.” ");
INSERT INTO khz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iesu na gena melo evaikilarato, netiwato, “Pene talima ta au muliku ai pene laka netina genai, ia matotauna pene veluga, gena satauro pene vuaa, au muliku ai pene laka.” ");
INSERT INTO khz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gaura pakurai rai matotauna gena maguli egapi-gaugauana talimana, gena maguli pene piatogaa. A rai au pakuku ai gena maguli pene piatogaa talimana, gena maguli ati pene vega-lekwalekwaa, na pene rawalia. ");
INSERT INTO khz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Talima taa na tanopara maparana eririwaana genai gena maguli pene piatogaa, gena nama rakagau ia genai? Kwalana talima ta gena maguli epia-togaato gaurai, rakagau na mapene voi-waia? ");
INSERT INTO khz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kwalana Taunilimalima Natuna ia Tamana maekana kolemana e tiavuna kamuna e gena aneru maparara ria pia vogomai, ne taunilimalima kwapurakwapura geria kala gelegelerai voira pene venira. ");
INSERT INTO khz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Avaikila-taunataunamina, enai reketa geruga-tagona ira ati pia kwarega vou, pene ago Taunilimalima Natuna gena Basileia aonai pene vogomai pia gitaa. ");
INSERT INTO khz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Toma taula toitoi (6) geaikito mulinai, Iesu na Petero, e Teimiti, e tarina Ioane egapirato, golo kamuna kukunai geverageto, vonai iramo geregara. ");
INSERT INTO khz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ira gepoepoewai aonai, Iesu gitagitana warau eirauto: Ia wailana evewaeto garo vetaina, e gena rapuga gekulo-garogaroto gevekemelewai. ");
INSERT INTO khz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ne emelo toitoi na Mose e Elia gegitarato, Iesu ria gekilakilawai. ");
INSERT INTO khz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Vonai Petero na Iesu evaikilaato, netiwato, “Velekou, nama iwavagi ita enai ea! Pene oririwana genai, ama gau toitoi aia kalara, gau ta goi gemu, gau ta Mose gena, e gau ta Elia gena.” ");
INSERT INTO khz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ia roe waekilakilawai aonai, iloa kulo poikapoikana na ira ema gapi-gavurato karo ta eiloa aona na ekea-rigoto, netiwato, “Ia e au Natuku, aulamagi-kamu-iwavagiana; au averere-rakavana ia genai. Ia pio kamonagi-venia!” ");
INSERT INTO khz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iesu gena melo toitoi na ekaro gekamonagiato aonai, kwano ai geketo-talito wailara maki kwano ai, kwalana gekali-rakavato gaurai. ");
INSERT INTO khz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ne Iesu ira geriai eagoto, tauniparara enapa-kaunagirato, netiwato, “Iokuliiti, ragai iokali.” ");
INSERT INTO khz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ira gealiitito aonai, ira na talima ta ati gegitaato ia ria, Iesumo geregana. ");
INSERT INTO khz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Maparara golo na gemarigowai aonai, Iesu na evaikilarato, netiwato, “Pogo gitara gaura maparara talima ta ragai pio vega-ripaa, pene ago Taunilimalima Natuna kwarega na pene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ne Iesu gena melo na gerenagiato, negetiwato, “Rakagau gaurai rova gevevega-ripagirana talimara gekilana, Elia pene vogomai kune?” ");
INSERT INTO khz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu evega-geleto, netiwato, “Taunatauna vegata, Elia pene vogomai kune, gau maparara pene vega-valigu-waira. ");
INSERT INTO khz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Na au na avaikilamina, Elia warau evogomaito, na taunilimalima ati ripara ia voo rai. Geria ririwa kalaramo ai gekala-veniawai. Voia gelegelena Taunilimalima Natuna maki pia vega-vitivitia.” ");
INSERT INTO khz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ekila geriana Iesu gena melo geripato, ia na Ioane Bapatiso ekilagiawai. ");
INSERT INTO khz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ira magewaikuleto taunilimalima gutuma geriai aonai, talima ta Iesu genai evogomaito, wailanai ema tiu-talito, ");
INSERT INTO khz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","netiwato, “Velekou, au natuku melona ono vetugaa! Ia ewagiana, e tauniparana epilupilu-rakavana. Vega-vogovagi kalovai eketo-ragena e nanu ai maki. ");
INSERT INTO khz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Gemu melo geriai agapi-agoato, na vega-namana ira geriai ati gelegele.” ");
INSERT INTO khz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu evega-geleto, netiwato, “Ati kamonagi e kila-tilivagi guluna! Toma vira au gomi lagami ai pana talu? Toma vira pana vaigaoka venimi? Melo au geku ai iovuamaia!” ");
INSERT INTO khz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu na melo tauniparanai etaluwai palagu rakavana ekila-waiato, ne palagu rakavana elaka-vagito, veganamo melo enamato. ");
INSERT INTO khz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mulina kavanai Iesu gena melo genai geagoto, veavugai gerenagiato, negetiwato, “Rakagau gaurai ai ati gelegele palagu rakavana paia gui-atia?” ");
INSERT INTO khz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iesu na evega-gelerato, netiwato, “Kwalana gemi kamonagi ati gelegele gaurai. Avaikila-taunataunamina, pene gemi kamonagi mastadi gutuna girigiri vetaina genai, egolo pio vaikilaa, nopiotiwa, ‘Eanana ono vegapiiti, vonai ono vetao!’, pene vegapiiti pene ago. Kala maparara maki pio kalara ripa.  ");
INSERT INTO khz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Palagu rakavara evetaira guiguira raupara irauna taai maaikina, na rapali e vokaimo.” ");
INSERT INTO khz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Toma ta, Iesu magena melo ria Galileiai getaluwai aonai, Iesu na evaikilarato, netiwato, “Taunilimalima Natuna pia lewaa vou taunilimalima gimarai pia tao-kaua. ");
INSERT INTO khz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ne pia vagi-kwaregaa, na toma toitoinai mapene kuliiti-wai.” Gena melo na gekamonagiato aonai, nugara gemetau-rakavato. ");
INSERT INTO khz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu magena melo ria Kaperanauma vanuganai gekwarato, ne Rupu Veaga monira gekokowai talimara gevogomaito, Petero gerenagiato, negetiwato, “Gomi gemi vevega-ripa tauna Rupu Veaga gena takiti monira evenina pa aikina?” ");
INSERT INTO khz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petero na evega-gelerato, netiwato, “Pa, evenina.” Petero numai ewaikuleto aonai, Iesu na erenagiato, netiwato, “Simona, goi gemu tugamagi rakavetaina? Tanopara velera pa king geria takiti monira raira na pia venira? Ira natura na pa tau polu na pia venira?” ");
INSERT INTO khz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petero evega-geleto, netiwato, “Tau polu na.” Iesu na evaikilaato, netiwato, “Voia ganina, ira natura ati pia veni. ");
INSERT INTO khz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na ragai pita vega-parura ulanana, gaurai kovu ai ono verigo. Kau pono pia-raia, magani tovotovona pono rolo ragea genai, pokana pono kala-pakaa, siliva monina ta pono rawalia. Pono gapia, pono venira ita taura ruala gera Rupu Veaga takiti monina.” ");
INSERT INTO khz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Volaganinai Iesu gena melo ia genai geagoto, gevaikilaato, “Rai kamu iwavagi Kupa Basileia aonai?” ");
INSERT INTO khz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A Iesu na melo girigiri ta ekea-agoato, ne nuganugarai evega-ruga-taliato, ");
INSERT INTO khz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","netiwato, “Taunatauna vegata, avaikilamina, gomi ati pio vetugamagi-kule emelo girigiri vetaina ati pio ago genai, gomi Kupa Basileia aonai ati pio laka-toga. ");
INSERT INTO khz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Talima ta matotauna evevega-aomana emelo girigiri vetaina, ia kamu iwavagi Kupa Basileia aonai. ");
INSERT INTO khz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","E rai na melo girigiri evetaina au araku ai pene gapi-ragea talimana na au maki egapi-ragekuna.” ");
INSERT INTO khz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Gaurana pene melo girigiri ta gena kamonagi au geku ai talima taa na evega-rakavaana, ia pere nama vatu kamuna ta gaagonai pegere kwatu-kaua, rawapara ropu-kelaunai pere vegugutu-kwarega. ");
INSERT INTO khz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tanopara mavetugana kekei, kwalana veripagani genana talima geria kamonagi evega-rakavaana. Gau vovetaira vanagivanagi pia wala vegata, na veripagani evega-walaana talimana vetugana kekei. ");
INSERT INTO khz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pene goi gimamu pa gagemu na rakavai etaomuna genai, pono pati-vagia, ne pono piatogaa! Gimamu kwapunai pa gagemu kwapunai maguli vanagivanagi pono rawalia nama, a ati nama gimamu ruala e gagemu ruala na kalova egala-vanagivanagina kapunai pia pia-kaumu. ");
INSERT INTO khz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pene goi matamu na rakavai etaomuna genai, pono kipo-vagia, pono piatogaa. Matamu kwapunai maguli vanagivanagi pono rawalia nama, a ati nama matamu rualana kalova egala-vanagivanagina kapunai pia pia-kaumu.” ");
INSERT INTO khz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Rogomi pio vetole, emelo girigiri ta nogo rugaana nea. Kwalana avaikilamina: Geria aneru na au Tamaku kupai etaluna wailana lagani mapararai gegitaana.  ");
INSERT INTO khz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Taunilimalima Natuna ia lekwalekwa talimara vega-magulira ularana evogomaito. ");
INSERT INTO khz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Rakagau gotugamagiana? Pene talima ta gena mamoe tinavuna (100), na kwapuna pene lekwalekwa genai, ia rakagau pene kala? Ia na gagala taulavati kwapuna e taulavati kwapuna (99) golo kapanai pene raokwanira, ne pene ago, lekwalekwa mamoena pene vetavua. ");
INSERT INTO khz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pene verawalia aonai, taunatauna avaikilamina, pene verere-rakava. A gena mamoe gagala taulavati kwapuna e taulavati kwapuna, ati gerigoto gaura, maki pene vanagira. ");
INSERT INTO khz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Voia gelegelena Tamami kupai etaluna ati gena ririwa, emelo girigiri ta pene lekwalekwa.” ");
INSERT INTO khz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Pene goi tarimu taa na pene kala-rakava-venimu genai, pono ago, gena kala rakavana pono vega-matagaia. Na veavugai ekala pono kalaa, ia e goimo. Pene ia na pene kamonagimu e pene gapi-ragemu genai, tarimu goi gemu ai pene waikule. ");
INSERT INTO khz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Na pene ati pene gapi-ragemu genai, talima ta pa ruala pono gapira, goi ria pio ago genai, ne ‘kila maparara pia vega-taunataunara, kamonagi talimara ruala pa toitoi geriana,’ Puka Veaga ekilana vetaina. ");
INSERT INTO khz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pene ira ati pene kamonagira genai, pia wala gaura maparara rupu pa ekalesia tanukouna pono vega-ripaa. Pene ekalesia tanukouna karona ati pene kamonagia, goi na ia Palagu ati ripana talimanai e takiti-koko pa kala rakava talimanai pono vega-agoa. ");
INSERT INTO khz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Avaikila-taunataunamina: Tanoparai pio ligora gaura maparara kupai maki Palagu na pene ligora; e tanoparai pio lugara gaura maparara kupai maki Palagu na pene lugara. ");
INSERT INTO khz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Au na avaikila-waimina: Tanoparai gomi talima ruala gau kwautai nugami pio tao-kwapunaa e pio rapali-agiaa Tamaku kupai etaluna na pene venimi. ");
INSERT INTO khz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kwalana au araku ai talima ruala pa toitoi pia tanu-kou kapurai, au maki ira ria vonai.” ");
INSERT INTO khz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Gaurana Petero Iesu genai eagoto, evaikilaato, “Velekou, au tariku na pene vega-rakava-agoku genai, gena rakava vega-vira vetaira pana tugamagi-piatogaa? Taulatoi kwapuna pa?” ");
INSERT INTO khz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu evega-geleto, netiwato, “Aikina, ati taulatoi kwapunamo, na gagala taulatoi kwapuna (70) e taulatoi kwapuna pia vetapura, pa 70 taims 7, (voia ganina vanagivanagi). ");
INSERT INTO khz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iokamonagi, Kupa Basileia vele ta vetaina, ia eririwato, gena vetugunagi talimara geria gapitore pene tavura e pene vega-rorirorira. ");
INSERT INTO khz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ia na gapitore roli evetavurawai aonai, vetugunagi talimana ta gema gapi-togaato, ia gena gapitore genai kina gagala (10) milion, moni kamu iwavagina, ekalaato. ");
INSERT INTO khz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Evetugunagi tauna gena moni ati gelegele gena gapitore pene vega-voia. Gaura pakurai vele na gena vetugunagi melora evaikilarato, etalima pia voi-agia, vele ta gena vetugunagi melonai pene ago, magarawana e manatuna e magena rinaga maparara maki, gena gapitore pene vega-voia ulanana. ");
INSERT INTO khz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Vetugunagi tauna vele gagena kwalanai evetiu-talito, enogiato, netiwato, ‘Ono vaigaoka-veniku. Gemu gaura maparara voira pana venimu.’ ");
INSERT INTO khz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Vele na evetugaato gaurai, vetugunagi tauna gena gapitore etugamagi-lekwalekwaato, ne etugu-lakaato. ");
INSERT INTO khz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Evetugunagi tauna elaka-piatito, ia gatana vetugunagi talimana ta erawaliato. Egatana moni kiata egapi-toreato ia genai. Egapi-taliato, gaagona na ekiki-vanaigato, evaikilaato, ‘Au geku ai ogapi-toreto monina voina ono veniku!’ ");
INSERT INTO khz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Gatana vetugunagi talimana ia gagena kwalanai evetiu-talito, enogiato, netiwato, ‘Ono vaigaoka veniku, pe voina maparana pana venimu!’ ");
INSERT INTO khz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Na ia ati eririwato, gaurana tipura numanai eroli-togaato. Vonai pene talu, pene ago gena gapitore voina pene kalaa netiwato. ");
INSERT INTO khz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ne ia ria vetugunagi geago-veni-kouwai talimara na vokala gegitaato aonai, ira nugara gemetauto, gaurana geagoto vele genai, vokala gewalato gaura maparara gevega-ripaato. ");
INSERT INTO khz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Vovetaina gaurai ia na vetugunagi tauna numai ekea-togaato, evaikilaato, netiwato, ‘Goi vetugunagi tauna rakavana! Goi au geku ai moni vira milion kina ogapi-torerato gaura maparara atugamagi-lekwalekwarato, voina ati ovenikuto, kwalana onogikuto gaurai. ");
INSERT INTO khz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Gelegelena goi na maki gatamu vetugunagi tauna poro vetugaa, au na goi avetugamuto vetaina.’ ");
INSERT INTO khz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Evele eparu-rakavato, gaurai vetugunagi tauna tipura numanai etao-togaato, vonai metauna pene vuaa, pene ago gena gapitore voina maparana pene veni-waia. ");
INSERT INTO khz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iesu gena kila ikana kavanai evetaina ekilato: Tamaku kupai etaluna gomi maparami ekala kwapunaimo pene kala-venimi, pene goi tarimu gena rakava nugamu maparanai ati pono tugamagi-piatogara genai.” ");
INSERT INTO khz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu na egaura maparara ekilagi-gatu-vagirato mulinai, Galileia eraokwaniato, Iudea tanonai eagoto, Ioridana waina kavatai. ");
INSERT INTO khz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Taunilimalima gutuma para ia mulina na gevogomaito, e vonai geria viti evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisea talimara reketa ia genai geagoto, geverenagi-veripaganiato, negetiwato, “Talima ta gena ririwa garawana pene rugaa netina genai, rova na pene gapia pa?” ");
INSERT INTO khz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Iesu na evega-gelerato, netiwato, “Gomi na Puka Veaga ati goagiana? Evetaina ekilana, ‘Tovotovona na vegata, Palagu na gaura maparara ekalarato aonai, ia na taunilimalima maki ekalarato maru e gare.’ ");
INSERT INTO khz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ne Palagu ekilato, ‘Vovetaina pakunai tau taa na tamana e tinana pene raokwanira, garawana goti pia talu, ne ira taura ruala pia kwapuna.’ ");
INSERT INTO khz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gaura pakurai ira ati ruala, na kwapunamo. Vovetaina gaurai Palagu na eveakwapurato talimara talima taa na ati mapene tao-vepakara.” ");
INSERT INTO khz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parisea talimara na gevaikilaato, negetiwato, “Rakagau gaurai Mose na rova ekalaato aonai, ekilana, maru na vegarawa lugalugana pene taloa vou, garawana pene tugu-lakaa?” ");
INSERT INTO khz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu evega-geleto, netiwato, “Mose na rorirori evenimito, garawami pio tugu-lakara ulanana, kwalana gomi vega-ripami gaoka-poroporo gaurai. Na Palagu na gaura maparara ekalarato aonai, evetaina aikina. ");
INSERT INTO khz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Avaikilamina: Rai na garawana, lewana ati evegeno-agina, na tipo epia-togaana gare ta mapene garawaa, ia evegeno-agina.” ");
INSERT INTO khz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iesu gena melo na gevaikilaato, negetiwato, “Vegarawa rauparana vovetaina gaurai, talima ragai pia vegarawa maki nama.” ");
INSERT INTO khz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu evega-geleto, netiwato, “Evevega-ripa ea taunilimalima maparara na ati pia tugamagi-pakaa, na Palagu na raira tugamagi-ilu evenirato talimaramo. ");
INSERT INTO khz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Taunilimalima reketa ati gevegarawana, kwalana ira vovetaina vegata gewalato tinara geriana, gaurai ati gelegele pia vegarawa; reketa eunuko taura vetaira, (taunilimalima na ragira gegapirana); reketa Kupa Basileia pa Palagu vetugunagina pia ago-venia pakunai ati gevegarawana.” ");
INSERT INTO khz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Talima reketa natura Iesu genai gevua-agorato, gimana ira atarai pene tao-kaura, e pene rapali ulanana. Na gena melo na gekila-wairato. ");
INSERT INTO khz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu na evaikilarato, netiwato, “Nemelo girigiri ia vogomai au geku ai, ragai iokila-waira, kwalana Kupa Basileia nevetaira talimara geria.” ");
INSERT INTO khz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Gaurana Iesu gimana atarai etao-kaurato, evega-namarato vou eraokwanirato. ");
INSERT INTO khz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Toma ta talima ta Iesu genai eagoto, evaikilaato, “Vevega-ripa tauna, rakagau namana pana kalaa vou, maguli vanagivanagi pana vaia?” ");
INSERT INTO khz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu na evega-geleato, netiwato, “Rakagau gaurai au orenagikuna, arigi gau namana? Kwapunamo nama, Palagu. Pene oririwana maguli vanagivanagi pono vaia genai, Palagu gena rova pono kwalanara.” ");
INSERT INTO khz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ia na Iesu erenagiato, netiwato, “Arigi rova okilagirana?” Iesu ekilato, “Ragai pono vagivagi, ragai pono vegenoagi, ragai pono lema, ragai pono veroli-opakau, ");
INSERT INTO khz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tamamu e tinamu pono kupa-kaura, e lagamu talimana maki pono ulamagia, goi matotaumu oveulamagina vetaina.” ");
INSERT INTO khz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Emalaga valiguna netiwato, “Au nerova maparara akwalanarana. Rakagau au na pana kalaa?” ");
INSERT INTO khz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu na ia evega-geleato, netiwato, “Pene goi oririwana pono rorirori genai, tovotovona goi ono ago, gemu rinaga maparara pono voivoi-agira, pe monira ati geria e ati garia talimara pono venira, ne kupai magemu rinaga. Kapinai muliku ai ponoma laka.” ");
INSERT INTO khz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Malaga valiguna eia ekamonagiato aonai, nugana mametauna na eraokwaniato, kwalana ia magena rinaga vogo talimana. ");
INSERT INTO khz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iesu na gena melo evaikilarato, netiwato, “Au na avaikila-taunataunamina: Rinaga vogo talimara geria laka-toga Kupa Basileia aonai gaoka-galagala vagi. ");
INSERT INTO khz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Maavaikilamina: Kamela rina iluna na pene vanagi gaoka, na gena rinaga vovogo talimana Palagu gena Basileiai gena laka-toga gaoka-galagala vagi.” ");
INSERT INTO khz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gena melo na ekila gekamonagiato aonai, gevevega-kali-rakavato. Gaura pakurai geverenagito, negetiwato, “Pe, rai na maguli vanagivanagi pene rawalia?” ");
INSERT INTO khz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","A Iesu na egita-kalakalarato, ne evega-gelerato, netiwato, “Taunilimalima geriai ati gelegele, na Palagu genai gau maparara gelegele.” ");
INSERT INTO khz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gaurana Petero ekila-rageto, netiwato, “Goi ripamu, ai gema gaura maparara garaokwanirato, ne goi mulimu ai galakana! Ne ai rakagau paia gapi?” ");
INSERT INTO khz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu na evaikilarato, netiwato, “Avaikila-taunataunamina, tanopara valiguna pene matagai aonai, Taunilimalima Natuna gena terona pa vele tanukauna rakirakinai pene tanukau, e gomi gagalana ruala au muliku ai golakana talimami maki vele tanukaura gagalana rualai pio tanukau, Isaraela gena kwalu gagalana ruala pio gita-togara, e pio vaira. ");
INSERT INTO khz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Talima taa na gena numa, kakana, tarina, walawalana, tamana e tinana e natuna, e gena tano, au pakuku ai pene raokwanira genai, ia gau tinavutinavu pene rawali, e maguli vanagivanagi maki pene vaia. ");
INSERT INTO khz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Na taunilimalima gutuma etoma gekunena piave kapi, e gutuma maki etoma gekapina piave kune.” ");
INSERT INTO khz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Kupa Basileia evetaina: Vine aragana talimana ta amoamo valiguvaliguna numa na elakatito, gena vine araganai pia inagulu talimara etavurato. ");
INSERT INTO khz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ne inagulu talimara ria gekila-koukouto e gevega-taunataunaato, voinagulu talimara toma kwapuna pia inagulu-agia voira siliva monina kwapuna pene venira negetiwato. Ne gena vine aragana aonai etugu-agorato. ");
INSERT INTO khz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Amoamo ora gauna 9 koloko vetaina ia maelaka-piatito, maketi ai eagoto, vonai talima reketa geruga-lekwalekwa tagowai egitarato. ");
INSERT INTO khz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ne evaikilarato, netiwato, ‘Gomi maki geku vine araganai ioago, iove inagulu, pe voimi rorirorina pana venimi.’ ");
INSERT INTO khz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ira maki geagoto. Garogota ora gauna 12 koloko e 3 koloko vetaira ia numa na maelakatito, reketa maerawalirato, maetugurato. ");
INSERT INTO khz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lavi kavanai ora gauna 5 koloko vetaira maelakati-waito, reketa roe wagerugatagowai aonai maerawalirato. Ne erenagirato, netiwato, ‘Rakagau gaurai enai goruga-kawakawa-tagona garo vowaeverigona?’ ");
INSERT INTO khz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ira na gevega-geleato, negetiwato, ‘Kwalana talima taa na inagulu ati evenimaina gaurai.’ Ne evaikilarato, ‘Gomi maki geku vine araganai ioago, iove inagulu.’ ");
INSERT INTO khz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Garo enonorigoawai aonai, araga gatana na inagulu taura egita-tagorawai talimana evaikilaato, netiwato, ‘Inagulu talimara ono keara, pe voira pono venira, ewagumona pege inagulu talimara pono veni-kunera, pene ago pakea kunera talimara geriai pono veveni-kwara.’ ");
INSERT INTO khz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Gaurana volavilavi ora gauna 5 koloko etugurato talimara gevogomai-kuneto, ne siliva monira kwapurakwapura gegapito. ");
INSERT INTO khz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Geago-kuneto talimara gevogomaito aonai, ira matapolu gekilato voira kiata mapene taokau, na ira maki siliva monira kwapurakwapuramo gegapito. ");
INSERT INTO khz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Geria moni gegapirato aonai, gemunemuneto araga gatana genai, ");
INSERT INTO khz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","gekilato, ‘Etaunilimalima ewagumona vou pege vogomai ora kwapunamo pege inagulu mavoira, na ai toma maguguluna paga vekwalavi-agia, e garo tiavuna na perala-rakavamai aonai voimai ira ria poveni-gelegelemai.’ ");
INSERT INTO khz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Araga gatana na ira ta evaikilaato, netiwato, ‘Gataku, ono kamonagiku, au na goi ati paopamu. Takila-koukouto aonai, toma kwapuna voina siliva monina kwapuna natatiwato, ei? ");
INSERT INTO khz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ewagunamo voimu ono gapia, ono laka! Au aririwana ekapi talimana pana venia, goi pavenimu gelegelena. ");
INSERT INTO khz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Pe, au mageku rorirori, geku moni au geku ririwa gelegelenai pana veveni-agia. Pa goi oparuna, kwalana au aoku mavererenai avenina.’ ");
INSERT INTO khz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iesu gena kila evega-ikaato mulinai ekilato, ‘Kune talimara pia kapi, e kapi talimara pia kune.’” ");
INSERT INTO khz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesu Ierusalema rauparana na everagewai aonai, gena melo gagalana ruala evaigerevagirato, veavugai evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Iokamonagi, ita Ierusalemai taveragena. Vonai Taunilimalima Natuna Rupu Veaga velera kamura e rova gevevega-ripagirana talimara gimarai pia taoa. Ira na gena kwarega kilana pia vega-taunataunaa, ");
INSERT INTO khz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ne ati Iuda (Roma) talimara pia venira, ira na pia vegarevegare-agia, pia kwaria e pia satauroa; na toma vega-toitoinai mapene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ne Tepetaio garawana manatuna ruala Teimiti e Ioane ria Iesu genai geagoto, wailanai gevetiu-talito, gau kwauta ene nogia ulanana. ");
INSERT INTO khz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ne Iesu na egare erenagiato, netiwato, “Goi rakagau oririwana?” Ia evega-geleto, netiwato, “Ono vega-ripaku, au natuku tauria ruala ea, goi ria pio wati-tanu, ta ripamu ai, e ta kaulimu ai gemu Basileia aonai.” ");
INSERT INTO khz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na Iesu na evega-gelerato, netiwato, “Gomi ati ripami rakagau gonogiana. Au na viti-vua kaperina pana niua gauna gomi na maki pio niua ripa?” Ira gevega-geleto, negetiwato, “Pa, paia niua.” ");
INSERT INTO khz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu na maevaikilarato, netiwato, “Taunatauna, au geku kaperi gomi na maki pio niu-agia, na au ripaku ai pa kauliku ai pio tanu nogotina ati au na pana vega-taunataunami; eia e au Tamaku na ekala-maavurato talimara geria.” ");
INSERT INTO khz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Melo gagalana (10) na eia gekamonagiato aonai, etalima ruala Teimiti e Ioane geparu-venirato. ");
INSERT INTO khz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gaurana Iesu na maparara ekea-koukourato, ne evaikilarato, netiwato, “Gomi ripami, ati Iuda talimara geria vele na taunilimalima getugu-naginagirana, e geria vekuneagi talimara kamura na geria rorirori tiavura na gelaunaginagirana. ");
INSERT INTO khz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Na gomi vepakami ai vovetaina ragai pio kala. Pene ta gomi vepakami ai pene kamu netina genai, ia gomi maparami vetugunagimi pene ago-veni, ");
INSERT INTO khz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","e rai pene kune netina talimana, ia gemi vetugunagi talimanai pene ago. ");
INSERT INTO khz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Taunilimalima Natuna vetaina, ia evogomaito ati taunilimalima na ia vetugunagina pia ago-veni ulanana, na ia evogomaito taunilimalima vetugunagira pene ago-veni, e gena maguli pene tao-rigoa, taunilimalima gutuma pene voi-waira e pene vega-magulira ularana.” ");
INSERT INTO khz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu magena melo ria Ieriko geraokwaniato, taunilimalima gutuma para ira mulira na geagoto. ");
INSERT INTO khz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mata-kele talimara ruala raupara pipinai getanu-tagowai, gekamonagito Iesu elaka-vanagiwai, ne gekea-kogokogoto, negetiwato, “Velekou o, Davida natuna, ai ono gita-vetugamai!” ");
INSERT INTO khz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Taunilimalima na gekila-wairato, ragai pia kea negetiwato, na ira gekea-vigiragewai, “Velekou, Davida Natuna o, ai ono gita-vetugamai!” ");
INSERT INTO khz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu eruga-talito, ne ekea-mairato, evaikilarato, “Rakagau gemi ana kalaa nogotina?” ");
INSERT INTO khz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ira na gevaikilaato, “Velekou, ai gaririwana matamai onoma kala-pakara!” ");
INSERT INTO khz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ne Iesu na evetugarato, matara enapa-kaunagirato, veganamo matara genamato e gepoepoeto, ne Iesu mulina na geagoto. ");
INSERT INTO khz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesu magena melo ria gelakato geagowai, Ierusalema gevekaviawai, e Betepeiti ai gekwarato Olive Golona kavanai, ne Iesu na gena melo ruala etugu-kunerato, ");
INSERT INTO khz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","evaikilarato, netiwato, “Ioago, wailara vanuganai. Vonai toniki ta kwatukau manatuna goti pio rawalira, pio luga-vagira, ne au geku ai pio vaimaira. ");
INSERT INTO khz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pene talima taa na pene renagimi genai, pio vaikilaa, ‘Velekou na eririwaana, roe nea mapene tugu-waikulera, ati pia kwaipo.’” ");
INSERT INTO khz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Eia ewalato genana, peroveta tauna gena kilagavu kilana evega-taunataunaana, netina, ");
INSERT INTO khz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Siona natuna, (Ierusalema talimara), ono vaikilara, ‘Ono gitaa, gemu Vele evogomaina, aoma talimana, toniki kukunai etanuna, etoniki natuna rogenai petanukau.’” ");
INSERT INTO khz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Emelo ruala geagoto, Iesu na evaikilarato kalana gelegelenai gekalato. ");
INSERT INTO khz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ira toniki manatuna goti Iesu genai gevaiagorato, geria rapuga kamura toniki rogerai geava-kaurato, ne Iesu etanukauto. ");
INSERT INTO khz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Taunilimalima gutuma para geria rapuga kamura rauparai geavarato, reketa gautupu lekara malaura gepatirato, ne rauparai geavarato. ");
INSERT INTO khz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Taunilimalima gutuma para ia wailanai gelakato e mulinai gelakato, evetaina gevonewai, negetiwato, “Hosana, Davida natuna gena! Velekou aranai evogomaina talimana ita vega-namaa! Hosana kupa atagaina raimoraimonai!” ");
INSERT INTO khz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu Ierusalemai elaka-togato aonai, vanuga taunilimalimara maparara geverakaverakawai e geverenagiwai, negetiiwai, “Goi ne rai?” ");
INSERT INTO khz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iesu ria gelaka-kouto talimara na gevega-gelerato, negetiwato, “Ia e Iesu, peroveta tauna, Galileia vanugana Nasareta na evogomaina.” ");
INSERT INTO khz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu Rupu Veaga aonai elaka-togato, ne voivoi talimara maparara egui-atirato. Moni gevepoe-agirawai talimara geria pata e pune gevoivoi-agirawai talimara geria tanukau gaura egule-vepoporato, ");
INSERT INTO khz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","e evaikilarato, netiwato, “Puka Veaga aonai evetaina etaloato, Palagu ekilato, ‘Au geku numa rapali numanai pia kilagia,’ na gomi na lema talimara geria kumu kapunai pogo vega-agoa.” ");
INSERT INTO khz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mata-kele e gage rakava talimara Iesu genai gevogomaito Rupu Veaga aonai, ne ia na evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Rupu Veaga velera kamura e rova gevevega-ripagirawai talimara na gena kala iwavagi kalara gegitarato, e melo girigiri karora gekamonagirato, Rupu Veaga aonai gevonewai, negetiwato, “Hosana, Davida natuna gena,” gaura pakurai ira geparu-rakavato, ");
INSERT INTO khz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ne Iesu gerenagiato, negetiwato, “Ira na ne rakagau gekilagirana okamonagirana pa?” Iesu na evega-gelerato, netiwato, “Pa akamonagina, na gomi na Puka Veaga aonai ati goagiana, ‘Melo girigiri e tinara latara erogerururana melora na maki goi gevega-ragemuna’?” ");
INSERT INTO khz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ne Iesu na eraokwanirato, vanuga kamuna na elakatito, Betaniai eagoto, vonai evemaituto. ");
INSERT INTO khz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Amoamo, Iesu vanuga kamunai maewaikuleto, eagowai aonai, ia evitoato. ");
INSERT INTO khz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ia na figi gautupuna ta raupara pipinai egitaato, ne eago-veniato, na ati vuana, launa kovagonamo. Ne Iesu figi gautupuna evaikilaato, netiwato, “Goi gemuna vuavuamu ati mapia matagaiwai!” Veganamo vofigi gautupuna emalai-gatu-vagito. ");
INSERT INTO khz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gena melo na figi gautupuna emalai-gatuto gegitaato aonai, gevevega-kali-rakavato, negetiwato, “Figi gautupuna e rakavetaina pe veganamo pekwarega?” ");
INSERT INTO khz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu na evega-gelerato, netiwato, “Avaikila-taunataunamina, pene gomi pio kamonagi, e ragai pio aovoaovo gomi na maki efigi gautupuna genai pakalaa vetaina pio kalaa ripa; e ati voiamo, na egolo pio vaikilaa, ‘Ono vegapiiti, pe rawaparai ono vepiarai,’ vokala pene wala. ");
INSERT INTO khz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gau maparara rapali ai pio kilagira makamonagimi na genai pio rawalira.” ");
INSERT INTO khz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu Rupu Veaga aonai elaka-togato, evevega-ripawai aonai, Rupu Veaga velera kamura e Iuda velera ia genai gevogomaito, ne gerenagiato, negetiwato, “Arigi tiavu ai goi na ekala okalarana? Rai na rorirori evenimuto?” ");
INSERT INTO khz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu na evega-gelerato, netiwato, “Au na maki verenagi ta ana venimi; pene pio vega-gelea genai, au na arigi rorirori ai ekala akalarana pana vega-ripami. ");
INSERT INTO khz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioane gena bapatiso kalana ravanana evogomaito? Kupa na evogomaito, pa taunilimalima geriana?” Ira nuganugarai geverolito, gekilato, “Pene ita pita kila, ‘Palagu genana’ nepitatiwa genai, ia pene kila ‘Rakagau gaurai Ioane ati govega-taunataunaana?’ nepenetiwa. ");
INSERT INTO khz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Na pene ita pita kila, ‘Taunilimalima geriana’ nepitatiwa genai, taunilimalima kalira na pita kali, kwalana ira ripara, Ioane peroveta talimana taunatauna.” ");
INSERT INTO khz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gaura pakurai ira na Iesu gevega-geleato, negetiwato, “Ai ati ripamai.” Ne Iesu na ira evaikilarato, “Au na maki arigi rorirori ai ekala akalarana ati pana vega-ripami.” ");
INSERT INTO khz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Eparapore raka gotugamagi-tiwaana? Talima ta manatuna ruala. Tau kunena genai eagoto, evaikilaato, netiwato, ‘Natuku, toma ono ago, vine araganai onove inagulu!’ ");
INSERT INTO khz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Natuna na evega-geleato, netiwato, ‘Ati aririwana,’ na kapinai evetugamagi-waito, ne eagoto. ");
INSERT INTO khz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ia maeagoto natuna vega-rualana genai, tau kunena evaikilaato gelegelenai evaikilaato. Melo evega-geleto, netiwato, ‘Aagona,’ na ati eagoto. ");
INSERT INTO khz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ira taura ruala vekarawarai rai na tamara gena ririwa ekalaato?” Ira gevega-geleto, negetiwato, “Tau kunena.” Iesu na evaikilarato, “Avaikila-taunatauna vagimina, takiti-koko talimara e mata-poraga vavinera na gekune-agimina Palagu gena Basileia lakatoganai. ");
INSERT INTO khz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ioane Bapatiso gomi gemi ai evogomaito kala rorirori rauparana gemi ai evega-matagaiato, na ati gokamonagi-veniato. Na takiti-koko talimara na e mata-poraga vavinera na gevega-taunataunaato. Gomi na maki gogitarato, na ati govetugamagi-waito, ati govega-taunataunaato.” ");
INSERT INTO khz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesu ekilato, “Parapore ta maiokamonagia: Tano gatana taa na vine aragana evaroato, kanana ekalaato, tano ai vine kikiagina legana etaviato, araga gitatagona numana maki evega-rugaato. Voia mulinai araga gitatagona talimara geriai gena araga eraokwaniato, ne elakato kapu taai. ");
INSERT INTO khz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Vine vuara (grapes) gemerato, ne ia na gena vetugunagi talimara etugurato araga gegita-tagoawai talimara geriai, gena vine vuara reketa pia gapira ulanana. ");
INSERT INTO khz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Na araga gitatagona talimara na vetugunagi taura gegapirato, ne ta gekwariato, mataa gevagiato, e mataa vatu na gevaleato. ");
INSERT INTO khz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Araga gatana na gena vetugunagi taura vogo reketa maetugurato, na vovetainamo gevaivenirato. ");
INSERT INTO khz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ikanai ia natuna taunataunana geriai etuguato, ekilato, ‘Natuku ana tugua, ira na pia kupa-kaua.’ ");
INSERT INTO khz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Na araga gitatagona talimara na natuna gegitaato aonai, matotaura gevevaikilato, negetiwato, ‘Araga pene gaunaa melona ea, pe ita gapia, ita vagi-kwaregaa, pe gena araga pita gaunaa!’ ");
INSERT INTO khz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gaurai gegapi-taliato, vine aragana mulinai gerolo-atiato, gevagi-kwaregaato.” ");
INSERT INTO khz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iesu everenagito, netiwato, “Araga gatana pene vogomai aonai, voaraga gitatagona talimara raka pere kalagi-tiwara?” ");
INSERT INTO khz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ira gevega-geleto, negetiwato, “Vokala rakava talimara ia na pene vagira vegata, e vine aragana gitatagona talima polura reketa mapene venira, ne geria vua laganirai, vuara ia genai pia vua-agora.” ");
INSERT INTO khz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu na maevaikilarato, netiwato, “Gomi na e talotalo Puka Veaga aonai ati goagiana, evetaina ekilana, ‘Vatu numara gekalarana taunilimalima na ati geririwaato e gepia-togaato vatuna vatu keakwalai eagoto. Ekala ea Velekou na ekalaato, matara na tagitaana, gitagitana irau vagi vegata.’ ");
INSERT INTO khz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Gaura pakurai avaikilamina, Palagu gena Basileia gemina pene gapi-vagia, e vuavua evega-walaana petena pene venia.  ");
INSERT INTO khz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Rai vovatu atanai pene ketokau talimana pene vua-kavalugaa; e evatu talima ta atanai pene ketokau genai, pene vega-minamina vagia.” ");
INSERT INTO khz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Rupu Veaga velera kamura e Parisea talimara na Iesu gena parapore gekamonagirato aonai, geripato, Iesu na ira ekilagirana, ");
INSERT INTO khz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","gaurana ira geria ririwa pia gapi-talia. Na taunilimalima gutuma getanu-koukou tagowai kalira na gekalito, kwalana ira na getugamagiawai, Iesu peroveta talimana ta. ");
INSERT INTO khz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu na Iuda velera geria parapore ta maekilagiato: ");
INSERT INTO khz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kupa Basileia roli vele ta vetaina, natuna gena vegarawa velekwana ekala-maavuato. ");
INSERT INTO khz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ne gena vetugunagi talimara etugurato, evaikilarato talimara pia keara, na ati geririwato gaurai, ati gevogomaito. ");
INSERT INTO khz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gaura pakurai ia na vetugunagi talimara taarana maetugurato, evaikilarato, ‘Avaikilarato talimara iovaikilara: Au geku velekwa pakala-gatua, geku polomakau marura e polomakau natura mona poura pavagira, gaura maparara pakala-maavura, gaurai iovogomai velekwai.’ ");
INSERT INTO khz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Na ira gevevega-waito, geria ririwa inaguluramo gekalarato. Ta aragai elakato, mataa gena sitoai eagoto. ");
INSERT INTO khz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pa reketa vetugunagi talimara gegapi-talirato, gekwarirato, e gevagi-kwaregarato. ");
INSERT INTO khz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Vele eparu-rakavato, gena vetali goleara etugurato, vovagivagi talimara gevagi-kwaregarato, e geria vanuga kamuna gekapu-kauato. ");
INSERT INTO khz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ne ia na gena vetugunagi talimara evaikilarato, netiwato, ‘Au geku vegarawa velekwana pakala-maavua, na au na avaikilarato talimara ati gelegele pia vogomai. ");
INSERT INTO khz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Gaura pakurai ewagumonamo ioago, gatama kamura raka veregavarai pio rawalira talimara maparara pio vaikilara, pia vogomai velekwai.’ ");
INSERT INTO khz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ne vetugunagi talimara geagoto, gatamai e rauparai gerawalirato talimara maparara, namara, rakavara, gekoko-agorato, vegarawa numana maki gevega-vonuato. ");
INSERT INTO khz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ne vele elaka-togato, gevogomaito talimara gitagitara aonai, ia na talima ta vonai egitaato, ati gena vegarawa rapugana. ");
INSERT INTO khz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ne erenagiato, netiwato, ‘Gata, goi ravanana polaka-toga, ati gemu vegarawa rapugana?’ Na votalima ati ekilakilato. ");
INSERT INTO khz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ne vele na gena vetugunagi talimara evaikilarato, netiwato, ‘Gimana e gagena ioligoligora, ne iopiatia muli mukunanai. Vonai pene tagi, karikarina maki pene gala-kokikokira.’ ");
INSERT INTO khz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Kwalana talima gutuma Palagu na ekearato, na maine evirigirato maguli pia vaia.” ");
INSERT INTO khz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Parisea talimara gelaka-gerevagito, genavuga-koukouto, Iesu pia vega-verauleaa verenagira gekalarato. ");
INSERT INTO khz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Gaurana ira na geria melo taarana e Heroda mulinai gelakawai talimara taarana getugu-agorato, gekilato, “Vevega-ripa talimamu, ai ripamai goi taunatauna kala rorirori talimamu. Goi taunataunai Palagu gena raupara ovevega-ripagi-gitakauana. Taunilimalima kalira na ati okalina, talima geria raki maki ati otugamagirana. ");
INSERT INTO khz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gaura pakurai ono vega-ripamai, raka otugamagi-tiwana: Kaisara, Roma geria vele, genai takiti paia veni pa aikina?” ");
INSERT INTO khz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na Iesu ripana geria navuga rakavara gaurai, evaikilarato, “Gomi opakau talimami! Rakagau gaurai au goopa-tovokuna? ");
INSERT INTO khz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takiti monina ta ioveniku, anama gitaa, ne siliva monina ta geveniato.” ");
INSERT INTO khz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne ia na erenagirato, netiwato, “E rai avuavuna e rai arana?” ");
INSERT INTO khz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ira gevega-geleto, “Kaisara gena.” Iesu na evaikilarato, netiwato, “Gaurai, Kaisara gena gau Kaisara pio venia, Palagu gena gau Palagu pio venia.” ");
INSERT INTO khz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Vokila gekamonagiato aonai, gevevega-kali-rakavato, ne geraokwaniato, gelakato. ");
INSERT INTO khz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Votomamo ai Sadukea talimara reketa Iesu genai geagoto. Ira geria tugamagi kwarega talimara ati pia kuliiti-wai. Gaurai Iesu gerenagiato, negetiwato, ");
INSERT INTO khz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Vevega-ripa talimamu, Mose evetaina ekilato, ‘Pene maru ta ati natuna pene kwarega genai, wapuna kakana pa tarina taa na pene garawaa, natura pia maguli kwarega tauna gena.’ ");
INSERT INTO khz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tau walakako maparara taulatoi kwapuna enai getaluwai. Tau kunena evegarawato, ekwaregato ati natuna, ne tarina na wapuna egarawaato. ");
INSERT INTO khz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Vokala tarina vega-rualana genai maewalato, vega-toitoina maki vovetainamo pene ago vega-taulatoi kwapuna genai. ");
INSERT INTO khz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ikanai vogare maki ekwaregato. ");
INSERT INTO khz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kuliiti-wai tomanai vogare rai garawana? Kwalana ira taura taulatoi kwapuna na gegarawaato.” ");
INSERT INTO khz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu na evega-gelerato, netiwato, “Gomi goleana, kwalana Puka Veaga ganina e Palagu gena tiavu ati ripami. ");
INSERT INTO khz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kwarega na mapia kuliiti-wai talimara ati mapia vegarawa. Ira aneru vetaira kupai. ");
INSERT INTO khz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na kwarega na mapia kuliiti-wai kilara Palagu na pukai ati goagiana? Ia ekilato, ");
INSERT INTO khz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Au Aperaamo gena Palagu, Isaako gena Palagu, e Iakobo gena Palagu.’ Ia maguli talimara geria Palagu, ati kwarega talimara geria Palagu!” ");
INSERT INTO khz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Taunilimalima gutuma na vokila gekamonagiato aonai, gevevega-kali-rakavato gena vevega-ripa kilara na. ");
INSERT INTO khz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parisea talimara gekamonagito, Iesu na Sadukea talimara geria kila ekou-gavurato, ne gelaka-koukouto. ");
INSERT INTO khz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ira nuganugarai ta rova evevega-ripagirawai talimana. Ia na Iesu erenagi-veripaganiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Vevega-ripa talimamu, rova aonai arigi rova kamu iwavagi?” ");
INSERT INTO khz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu na evega-geleato, netiwato, “‘Velekou goi gemu Palagu pono ulamagia maaomu maparana, mapalagumu maparana, magemu tugamagi maparana ria.’ ");
INSERT INTO khz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Eia e rova tovotovona e kamu iwavagina. ");
INSERT INTO khz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Rova kamu iwavagina vega-rualana ia gelegelena ea: ‘Lagamu talimana pono ulamagia, goi matotaumu oveulamagina vetaina!’ ");
INSERT INTO khz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Erova ruala na rova maparara e peroveta talimara geria kila maparara egapi-koukourato.” ");
INSERT INTO khz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisea talimara getanu-kouwai aonai, Iesu na erenagirato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gomi na Keriso raka gotugamagi-tiwaana? Ia rai natuna nogotina?” Ira gevega-geleto, negetiwato, “Ia Davida natuna.” ");
INSERT INTO khz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iesu na maerenagirato, netiwato, “Davida rakagau gaurai Keriso ‘Velekou’ netina? Kwalana Davida Veaga Palaguna na tugamagi-ilu e ripa eveniato, ne ekilato, ");
INSERT INTO khz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Palagu na au geku Velekou evaikilaato: Au gimaku ripana kavanai ono mai-tanu, pene ago goi geparu-venimuna talimara goi gagemu kapulenai pana taora.’ ");
INSERT INTO khz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pene Davida na Keriso ia ‘Velekouna’ ekilagito, rakagau gaurai Keriso ia Davida natuna?” ");
INSERT INTO khz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ira maparara taa na ati evega-geleato, e volaganina na vegata eagoto, talima taa na maki ati erenagiato, kwalana gekalito gaurai. ");
INSERT INTO khz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Iesu na taunilimalima gutuma para e gena melo evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Rova gevevega-ripagirana talimara e Parisea talimara na Mose gena rova gevevega-ripagirana. ");
INSERT INTO khz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gaura pakurai gomi gevega-ripamina kilara maparara pio kwalanara e pio kalara. Na geria kala ragai pio kalara, kwalana rakagau gevopatagirana, taunilimalima na pia kalara matotaura na ati gekwalanarana. ");
INSERT INTO khz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ira na maruna metaura taunilimalima gevega-vuarana, na gimara ririra ta vagi maki geria marunai ati genapakauna, ati geveveakavana, maruna pia vuara. ");
INSERT INTO khz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Geria kala maparara gekalarana taunilimalima na pia gitara ularana. Ira pakurai e gimarai gau veagara gekwatu-kaurana, aorai Puka Veaga goleara geurarana, vogaura gevega-kamurana, e geria rapuga kevera maki gevega-mogarana. ");
INSERT INTO khz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ganikoukou kapurai e rupu aorai geria ririwa tanutanu namaraimo pia tanu. ");
INSERT INTO khz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ira geririwana maketi kapurai pia loulou, taunilimalima na pia vega-namara ularana, e taunilimalima na ‘Vevega-ripa Talimarai’ pia kilagira. ");
INSERT INTO khz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Na gomi ‘Vevega-ripa Talimami’ ai ragai pia kilagimi, kwalana Palagu gereganamo gemi Vevega-ripa Tauna, e gomi maparami matarimi. ");
INSERT INTO khz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Etanoparai talima ta ‘Tama’ ragai pio kilagia, kwalana gomi Tamami kwapunamo, ia kupai etaluna. ");
INSERT INTO khz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Gomi maki ‘Vevai Talimami’ ragai pia kilagimi, kwalana gemi Vevai Talimana kwapunamo, Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna). ");
INSERT INTO khz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Rai kamu iwavagi gomi nuganugami ai, ia gomi vetugunagimi pene ago-veni. ");
INSERT INTO khz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Matotauna evegapi-itina talimana Palagu na pene vega-aomaa, matotauna evevega-aomana talimana pene gapi-itia.” ");
INSERT INTO khz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Rova govevega-ripagirana talimami e Parisea talimami, opakau talimami, vetugami kika! Kwalana Kupa Basileia lakatogana taunilimalima wailara gokou-gavurana. Gomi matotaumi ati pio laka-toga, e ia laka-toga negetina talimara geria raupara maki gomi na gokourana.  ");
INSERT INTO khz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Rova govevega-ripagirana talimami e Parisea talimami, opakau talimami, vetugami kika! Gomi na wapu geria numa e geria rinaga govega-aikirana. Gemi rapali mogaloki, goopana. Gaura pakurai gomi metau kamu iwavagi pio gapia. ");
INSERT INTO khz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Rova vevega-ripagira talimami e Parisea talimami, opakau talimami! Gomi kapu mapararai goagona, rawaparai e tanoparai, talima kwapuna kwanilova gemi gole ai pene laka-toga ulanana. Gogapiana, ne kalova egala-vanagivanagina kapuna natunai govega-agoana, gemi kila-tilivagi e karoverave maki pene vanagi-iwavagira. ");
INSERT INTO khz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Vevai taumi, matami vekanagavu, vetugami kika! Gemi vevega-ripai gokilana, Rupu Veaga aranai pene kila-gavu gena kilagavu ati ganina nogotina, a Rupu Veaga kolona (gold na) aranai pene kila-gavu tauna gena kilagavu roe nea pene kwalanaa. ");
INSERT INTO khz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kawa e mata-kele talimami! Arigia kamu, kolo pa Rupu Veaga, kolo evega-veagana numana? ");
INSERT INTO khz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Magokilana, pata veagana aranai pene kila-gavu talimana gena kilagavu ati ganina, na wareware gauna pata veagana atanai getaoato gauna aranai pene kila-gavu talimana gena kilagavu roe pene kwalanaa. ");
INSERT INTO khz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mata-kele taumi. Arigia kamu, wareware gauna pa wareware gauna evega-veagaana pata veagana? ");
INSERT INTO khz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gaura pakurai pata veagana aranai ekila-gavuna talimana na pata veaga e pata veaga atanai getaorana gaura maparara ararai ekila-gavuna. ");
INSERT INTO khz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","E Rupu Veaga aranai ekila-gavuna talimana na Rupu Veaga e aonai etaluna Palaguna ararai ekila-gavuna. ");
INSERT INTO khz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","E kupa aranai ekila-gavuna talimana na Palagu gena terona e atanai etanuna Palaguna ararai ekila-gavuna. ");
INSERT INTO khz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Rova vevega-ripagina talimami e Parisea talimami, opakau talimami, vetugami kika! Kwalana gomi na Palagu gowareware-veniana gaura, gemi ganigani gaulaura girigirira maki, tolega gagalana (10) gokalarana, tolega kwapuna vega-nama gaunai govega-agoana, na rova gena gau kamura, kala rorirori, venugagiviti e veraramani golearana. Gomi na ekala kamura pogoro kalara e vokala keira maki ragai pogoro raokwanira. ");
INSERT INTO khz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Vevai talimami, matami kelekele! Gami nanu na nakama gokala-vagiana, na kamela golavu-lokarana. ");
INSERT INTO khz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Rova vevega-ripagira talimami e Parisea talimami, opakau talimami, vetugami kika! Gomi gemi kaputi e mereki muliramo goguligirana, na aora vou lema e ririwamagi gokalarana gaura na pege vonu-poraketo. ");
INSERT INTO khz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisea talimami, matami kelekele! Kaputi e mereki aorai gotaorana gaura pio aleva-kunera, ne mulina kavana maki pene vealeva. ");
INSERT INTO khz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Rova vevega-ripagira talimami e Parisea talimami, opakau talimami, vetugami kika! Gomi kala kapura gepeni-kulokulorato vetaina, mulira gitagitara nama iwavagi, na aora kwarega talimara tiligara e milo maparara na gevonuto. ");
INSERT INTO khz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gomi maki vovetaina, taunilimalima na gegitamina no kala rorirori talimami na aomi opakau e kala rakava na gevonuvonu-rageto.” ");
INSERT INTO khz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Rova vevega-ripagira talimami e Parisea talimami, opakau talimami, vetugami kika! Gomi na peroveta talimara geria kala kapura gokala-gitavenirana, tugamagi tagoagira vatura govega-rugarana, e kala rorirori talimara geria kala kapura goveakwagorana. ");
INSERT INTO khz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Gokilana, ‘Tupumai e gatamai geria lagani ai pagara maguli genai, peroveta talimara vagivagirai ati pagara veakavara.’ ");
INSERT INTO khz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Vovetaina gokilana gaurai, matotaumi govekilagina, gomi peroveta gevagirato talimara natura. ");
INSERT INTO khz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pa, gomi maki tupumi gatami gekalawai vetaira roe nogo kalana, geria rakava gomi na govega-gugulurana. ");
INSERT INTO khz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Gomi warowaro! Warowaro natura! Palagu gena Kota kamuna tomana pene kwara aonai, kalova egala-vanagivanagina kapuna na raka pio kali-maguli-tiwa? ");
INSERT INTO khz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Gaura pakurai avaikilamina, au na peroveta talimara e aoneka talimara e vevega-ripa talimara pana tugu-agora. Ne reketa pio vagi-kwaregara, pa, pio sataurora; e reketa rupu aorai pio kwarira, ralara maki pia rigo, e vanuga taa na pio guira vanuga taai. ");
INSERT INTO khz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gaura pakurai kala rorirori talimara gevagirato metaura gomi atami ai, Abela gevagi-kwaregaato, voanana evogomaito pene vogomai Sakaria, Barakia natuna, ia pata veagana e numa veagana nuganugarai govagi-kwaregaato. ");
INSERT INTO khz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Avaikila-taunataunamina, maparara metaura toma gulu talimami atami ai pia ketokau.” ");
INSERT INTO khz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ierusalema, Ierusalema o, goi na peroveta talimara ovagirana e Palagu na etugu-watirana talimara vatu na ovatu-materana. Vega-vogovagi aririwato, natumi pana kana-gegelagira, kokoloku garena na natuna ekou-gavurana vetaina, na gomi ati goririwato! ");
INSERT INTO khz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gaura pakurai gemi vanuga e Rupu Veaga kovagona pene mia. ");
INSERT INTO khz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kwalana au na avaikilamina, gomi au ati pio gitaku vou, pene ago, toma ta pene kwara, vonai vou pio kila, ‘Palagu aranai evogomaina tauna ita vega-namaa.’” ");
INSERT INTO khz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu Rupu Veaga na elakatito, elaka-gerevagito aonai, gena melo ia genai geagoto, geria ririwa Rupu Veaga numara kamura pia vega-gitaa. ");
INSERT INTO khz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na Iesu na evaikilarato, netiwato, “Egau maparara gogitarana? Au na avaikila-taunataunamina: E vatu ta vatu ta atanai ati pene mia, maparara pia vale-vepopo-rigora.” ");
INSERT INTO khz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesu Olive Golonai etanu-tagowai aonai, gena melo ia genai geagoto, gerenagi-gariato, negetiwato, “Ono vega-ripamai, egaura maparara arigi toma pia wala? E goi pono waikule-wai e tanopara ikana pene gapia maki vegailiana raka pia matagai-tiwa?” ");
INSERT INTO khz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu evega-geleto, netiwato, “Gomi rogomi pio vetole, talima taa na ragai pene opami. ");
INSERT INTO khz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kwalana talima gutuma au araku ai pia vogomai, pia kila, ‘Keriso au ea!’ Talima vogo pia opara. ");
INSERT INTO khz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gomi na vetali kulura e vetali valira pio kamonagira genai, nugami ragai pia golugolu. Negaura ne pia wala, na ikana roe voa. ");
INSERT INTO khz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tanopara ta tanopara ta goti pia vevagi, kaomani ta kaomani ta goti pia vetali. Kapu vogo ai roge pene wala, tanokepo maki. ");
INSERT INTO khz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Eia e vitimo pene wala, no melo keina ewalana vitina vetaina. ");
INSERT INTO khz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Volaganinai pia gapi-talimi, pia vega-vitivitimi, pia vagi-kwaregami. Tanopara maparara na pia paru-venimi, kwalana au govega-taunataunakuna gaurai. ");
INSERT INTO khz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ne talima gutuma geria kamonagi pia raokwanira, kwapurakwapura pia velewa e pia veparuagi. ");
INSERT INTO khz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Peroveta opakau talimara pia kuliiti, talima gutuma pia opara. ");
INSERT INTO khz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kala rakava maki pene lovolovo, ne gutuma geria ulamagi maki pene palapala. ");
INSERT INTO khz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Na rai pene vaigaoka pene ago ikanai pene maguli. ");
INSERT INTO khz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Palagu gena Basileia Valina Namana tanopara maparanai pia vopatagia, taunilimalima maparara na pia kamonagia voia mulinai vou ikana pene kwara.” ");
INSERT INTO khz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Gomi na gau rakava iwavagina, vevega-kali gauna, peroveta talimana Daniela na ekilagiato gauna, pio gitaa kapu veaganai pene ruga.” Ekila pene agia talimana pene ripa-rorirori ganina rakagau. ");
INSERT INTO khz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ne raira Iudeai getaluna talimara golo ai pia raka-ago. ");
INSERT INTO khz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Rai numa kukunai etanu-tagona ati mapene laka-toga numa aonai gena rinaga gapigapira. ");
INSERT INTO khz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Rai araga aonai maki ati mapene waikule gena rogagirogagi gapigapina. ");
INSERT INTO khz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Volaganinai gare kuviakuvia e melewa valigu garera kika mavetugara! ");
INSERT INTO khz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pio rapali Palagu genai, pe gura e nakula aorai pa Tapati ai ragai pio laka-lekwalekwa! ");
INSERT INTO khz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kwalana volaganinai viti-vua ati guilagira pia wala, Palagu na tanopara ekalaato pene vogomai etoma, viti-vua vovetaira ati gewalana. Eia mulinai vovetaina kalana kwauta ati mapene walawai. ");
INSERT INTO khz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pere Palagu na votoma rakavara ati pere vega-kupara, taunilimalima ta ati pere maguli ripa, na egapi-itirato talimara pakurai, ia na tomara pene vega-kupara. ");
INSERT INTO khz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Volaganinai, pene talima taa na pene vaikilami, ‘Iogita, Keriso ea!’ pa ‘Ia goi voa!’ nepenetiwa genai, ragai pio vega-taunataunaa. ");
INSERT INTO khz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kwalana Keriso opakaura e peroveta talimara opakaura pia matagai, vegailia kamura e kala irau vagira pia kalara, Palagu na evirigirato talimara pia opa-vevilira. ");
INSERT INTO khz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pio tugamagi-tagoa, egaura akarovara-kunemina, ora rogoti ere kwara aonai. ");
INSERT INTO khz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pene talima taa na pene vaikilami, ‘Iogita, ia tanopakanai voa,’ voana ragai pio ago; pa pene vaikilami, ‘Iogita, ia vonuma aonai etaluna,’ ragai pio vega-taunataunaa. ");
INSERT INTO khz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kwalana Taunilimalima Natuna pene vogomai matagai-tago, noowane rama ekeuleana kupai garo rageragena na pene ago garo rigorigona vetaina; ");
INSERT INTO khz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","e kwarega tauniparana emiana kapunai kao maki vonai pia koukou, (pe ira na pia vega-matagaia).” ");
INSERT INTO khz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Vorakava pia wala mulinai, garo pene mukunaa, pene pogi-lotoa, e uve maki ati pene rala, mitiu kupa na pia keto e kupa tiavura pia veakaveaka. ");
INSERT INTO khz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ne Taunilimalima Natuna vegailiana kupai pene matagai. Votomai tanopara pamilira maparara pia tagi-wanonowanono, kwalana Taunilimalima Natuna pia gitaa, iloa atana na pene vogomai matiavuna kamuna e maralema iwavagina ria. ");
INSERT INTO khz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ne ia na gena aneru pene tugura makipi kulura kamura ria, evirigirato talimara pia vega-koukoura tanopara maparanai.” ");
INSERT INTO khz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Figi gautupuna genana eparapore pio ripaa: Pouna eragena e launa ekakavana aonai, goripana, garo gena rala laganina pekavinagi nogotina. ");
INSERT INTO khz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Voia gelegelena, gomi maki pene egaura maparara pia wala e pio gitara genai, pio ripa, Taunilimalima Natuna pekavinagi vanagi ai. ");
INSERT INTO khz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Avaikila-taunataunamina, egulu ati pene aiki, pene ago egaura maparara pia wala. ");
INSERT INTO khz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kupa e tanopara pia lekwalekwa, na au geku kila vou ati pia lekwalekwa, pia mia-vanagivanagi.” ");
INSERT INTO khz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Na votoma e ora talima ta ati ripana, aneru kupai ati ripara e Natuna maki ati ripana, na Tamana gereganamo ripana. ");
INSERT INTO khz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Taunilimalima Natuna gena vogomai Noa gena lagani ai rakagau gewalato vetaina. ");
INSERT INTO khz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gutugutu roe nea aonai, taunilimalima geria kala geganiganiwai, geniuniuwai, e maru e gare gevegarawawai, evogomaito Noa gena lakatoi ai elaka-togato tomanai. ");
INSERT INTO khz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na ati genunukato, ati geripato rakagau pene wala pene ago, gutugutu ekwarato, ne maparara egutu-kwarega-kwaregarato. Taunilimalima Natuna pene vogomai maki vovetaina pene wala. ");
INSERT INTO khz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Voorai talima ruala aragai pia inagulu, ta Palagu na pene gapi-vagia, a ta pene talu. ");
INSERT INTO khz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Gare ruala vuiti kiro gaunai pia kiro-koukou, ta pene gapi-vagia, a ta pene talu. ");
INSERT INTO khz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Vovetaina gaurai keromi pio talu, kwalana gomi ati ripami gemi Velekou arigi toma pene vogomai. ");
INSERT INTO khz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pio ripa-taunatauna: Pene numa talimana ripana arigi orai lema talimana pene vogomai ia kerona pene tanu, ne lema tauna na numa ati pene lovoa. ");
INSERT INTO khz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gaura pakurai gomi maki rogomi pio vetole, kwalana Taunilimalima Natuna arigi toma pene kwara orana gomi ati ripami.” ");
INSERT INTO khz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Rai vorinaga gitatagora talimara na kila ekamonagiana e kala rorirori ekalaana, gena vele na egapi-itiato numa e vetugunagi talimara pene gita-tagora, e ganigani maki ora rorirori ai pene venira? ");
INSERT INTO khz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Vovetugunagi talimana, gena vele na evaikilaato gelegelenai einaguluna, pene waitagoa voo nama. ");
INSERT INTO khz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Avaikila-taunataunamina, ia gena vele gena rinaga maparara gitatagora talimanai pene taoa. ");
INSERT INTO khz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Na pene ia vetugunagi talimana rakavana, matotauna aonai pene kila, ‘Au geku vele gena waikule pekwaipo-rakava,’ ");
INSERT INTO khz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ne ia na taukavana pene kwarira, e ia niuniu talimara ria pia ganigani-koukou e pia niuniu-koukou. ");
INSERT INTO khz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Vetugunagi talimana gena vele gena waikule tomana ati etugamagiana tomanai, e ati eripaana oranai pene kwara. ");
INSERT INTO khz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ne gena vele na pene pati kinikinira, e opakau talimara ria pene taoa. Vonai pia tagi, karikarira maki pia gala kokikokira.” ");
INSERT INTO khz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Votomai Kupa Basileia no vavine gagalana (10) vetaina, geria lamepa gegapirato, gelaka-piatito, vegarawa valigu tauna ria pia verawali negetiwato. ");
INSERT INTO khz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vavine imaima maaonekara, a imaima kawa. ");
INSERT INTO khz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kwalana vavine kawara geria lamepa gegapirato, na keretini kiata na maati gegapikauto. ");
INSERT INTO khz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Na aoneka vavinera geria lamepa gegapito aonai, keretini maki matai gegapikauto. ");
INSERT INTO khz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Vegarawa valigu tauna ekwaipoto pakunai, matara geputeputeto, ne maparara gemaituto. ");
INSERT INTO khz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pogi nuganai ta ekogoto, netiwato, ‘Vegarawa valigu tauna evogomaina nea, pe ioago, ia ria pio verawali!’ ");
INSERT INTO khz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ne vavine gagalana gekeroto, geria lamepa gealevarato. ");
INSERT INTO khz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Vavine kawara na maaonekara vavinera gevaikilarato, negetiwato, ‘Gemi keretini kiatana iovenimai, kwalana ai na lamepa geputena.’ ");
INSERT INTO khz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Na aoneka vavinera na gevega-gelerato, negetiwato, ‘Aikina, gomi e ai ati pia gelegele. Namana sitoai ioago, matotaumi gemi iove voi.’ ");
INSERT INTO khz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Keretini voi geagoto aonai, vegarawa valigu maruna ekwarato. Ne gekala-maavuto vavinera ia ria vegarawa velekwanai gelaka-togato. Ne vanagi gekana-gavuato. ");
INSERT INTO khz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kapinai vavine reketa magekwarato, negetiwato, ‘Velekou, Velekou o, gema vanagi onoma kala-pakaa!’ ");
INSERT INTO khz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Na vegarawa valigu tauna evega-geleto, netiwato, ‘Avaikila-taunataunamina, au ati ripaku gomi.’ ");
INSERT INTO khz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Gaura pakurai, pio vemalatago, kwalana gemi Velekou pene vogomai tomana e orana ati ripami.” ");
INSERT INTO khz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kupa Basileia talima ta vetaina, kapu raurau ai pene laka netiwato. Rogotina ere laka aonai, gena vetugunagi talimara ekearato, gena rinaga evenirato, pia inagulu-agira ularana. ");
INSERT INTO khz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ia na kolo monira ira kwapurakwapura geria kolema e ripa e tiliga vetairai evenirato. (Kolo monina ta e talima ta voina rigolo toitoi aorai pere gapia vetaina). Ta kolo monira imaima eveniato, ta kolo monira ruala, mataa kolo monina kwapuna eveniato. Ne eraokwanirato, ia gena lakalaka kapunai elakato. ");
INSERT INTO khz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kolo monira imaima egapirato talimana rorirori eagoto, gena moni einagulu-agirato, kolo monira polura imaima maerawalirato. ");
INSERT INTO khz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Voia vetaina kolo monira ruala egapirato talimana na maki moni polura ruala maerawalirato. ");
INSERT INTO khz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Na kolo monina kwapuna egapiato talimana eagoto, kwano ai lega etaviato, gatana gena moni etoleato. ");
INSERT INTO khz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Lagani warau ema rauvagito gaurai, vovetugunagi talimara geria vele evewaikule-waito, gena moni raka geinaguluagi-tiwarato pia varaa netiwato. ");
INSERT INTO khz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ne kolo monira imaima egapirato talimana ema laka-togato, moni polura imaima egapi-kaurato, netiwato, ‘Velepara, goi na kolo monira imaima ovenikuto aorana, au na moni polura imaima maparawalira gaura ea.’ ");
INSERT INTO khz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ia na evega-namaato, netiwato, ‘Nama iwavagi! Goi vetugunagi taumu namana, maveraramanimu! Gau girigiri oinaguluagi-gitakaurana pakurai, au na gau vogo avenimuna, goi na pono gita-tagora. Onoma laka-toga, au goti itama verere-koukou!’ ");
INSERT INTO khz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ne kolo monira ruala eveniato talimana ema laka-togato, netiwato, ‘Velepara, goi na kolo monira ruala ovenikuto aonai, au na moni polura ruala maparawalira, gaura ea.’ ");
INSERT INTO khz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Gena vele na evega-namaato, netiwato, ‘Nama iwavagi! Goi vetugunagi taumu namana, maveraramanimu! Gau girigiri oinaguluagi-gitakaurana gaurai, au na gau vogo avenimuna, goi na pono gita-tagora. Onoma laka-toga, au goti itama verere-koukou!’ ");
INSERT INTO khz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ne kolo monina kwapuna egapiato talimana ema laka-togato, netiwato, ‘Velepara, au ripaku goi aomu rakava vagi talimamu, ati goi na ovarorato gaura okuarana, e ati goi na uve opia-lovolovorato gaura otao-kourana. ");
INSERT INTO khz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Gaurai akalito, aagoto, gemu moni kwano aonai atoleato. Ono gitaa, gauna ea, gemu ono gapia.’ ");
INSERT INTO khz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Gena vele na evaikilaato, netiwato, ‘Goi vetugunagi taumu rakavamu lepeti vagi. Goi ripamu, ati au na avarorana gaura akuarana, e ati au na apia-lovolovorato gaura atao-koukourana. ");
INSERT INTO khz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kamo, pere nama geku moni panikai poro taoa, pe au para waikule-wai aonai taokauna goti para rawalia.’ ");
INSERT INTO khz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ia na vetugunagi talimara reketa evaikilarato, netiwato, ‘Ne moni kwapuna genai nea iogapia, moni gagalana (10) talimana iovenia. ");
INSERT INTO khz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kwalana magena e magana talimana vogora mapana venia, pe kamu iwavagi pene gapia, a ati gena e ati gana talimana genai giri-gonegonena maki pene gapi-vagia. ");
INSERT INTO khz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne vetugunagi talimana rakavana iopiatia muli mukunanai. Vonai pene tagi, karikarina maki pene gala-kokikokira.’” ");
INSERT INTO khz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Taunilimalima Natuna mavewae ralemana e tiavu kamu, e magena aneru maparara ria pia vogomai, gena teronai pene tanukau. ");
INSERT INTO khz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kwalu maparara ia wailanai pia vega-koukoura, ne ia na pene ware-kavalugara, gelegele mamoe gitatagora talimana na mamoe nanikoti geriana etao-gerevagirana vetaina. ");
INSERT INTO khz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mamoe ia ripana kavanai, a nanikoti ia kaulina kavanai pene taora. ");
INSERT INTO khz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ne Vele na ripana talimara pene vaikilara, nepenetiwa, ‘Iovogomai! Tamaku na evega-namamina talimami, iovogomai! Palagu gena Basileia ioma gapia, kupa e tanopara ekalarato laganinai warau ekala-maavurato gomi gemi. ");
INSERT INTO khz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kwalana au evitokuto aonai, gogupukuto; nanu na ekalakuto aonai, nanu govenikuto; au vanuga polu talimaku gomi aomi ai atanuto, na gogapi-ragekuto; ");
INSERT INTO khz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","au ati geku rapuga, govega-rapugakuto; evitikuto aonai, gogita-tagokuto; tipura numanai ataluwai aonai, golaka-gitakuto.’ ");
INSERT INTO khz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ne kala rorirori talimara na pia vega-gelea, nepiatiwa, ‘Velekou, arigi toma gagitamuto ovitoto, gagupumuto? Pa nanu na ekalamuto? ");
INSERT INTO khz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Arigi toma goi vanuga polu talimamu ai na gagitamuto, gagapi-ragemuto ai gema numai, pa ati gemu rapuga, gavega-rapugamuto? ");
INSERT INTO khz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Arigi toma gagitamuto goi evitimuto, pa tipura numanai galaka-gitamuto?’ ");
INSERT INTO khz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ne Vele na pene vega-gelera, nepenetiwa, ‘Avaikila-taunataunamina, tariku ati gevega-agirana talimara ta gokala-venirato gelegelenai, au maki vovetaina gokala-venikuto.’ ");
INSERT INTO khz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ne kaulina kavana talimara pene vaikilara, nepenetiwa, ‘Au geku na iolaka-paka, metau kamu iwavagina atami ai emiana talimami, ioago, egala-vanagivanagina kalovanai. Palagu na rauvagi ekala-maavuato, Satani magena aneru geria. ");
INSERT INTO khz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kwalana evitokuto, na ati gogupukuto; nanu na ekalakuto, na nanu ati govenikuto; ");
INSERT INTO khz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","au vanuga polu talimaku gomi nuganugami ai ataluto, na ati govairagekuto gemi numai; ati geku rapuga, na ati govega-rapugakuto; evitokuto e tipura numanai ataluto, na ati golaka-gitakuto.’ ");
INSERT INTO khz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ne ira maki pia vega-gele, nepiatiwa, ‘Velekou, arigi tomai gagitamuto, ovitoto pa nanu na ekalamuto, pa vanuga polu talimamu, pa ati gemu rapuga, pa evitimuto, pa tipura numanai otaluto, ai na ati gaveakavamuto?’ ");
INSERT INTO khz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ne Vele na pene vega-gelera, nepenetiwa, ‘Avaikila-taunataunamina, gomi na etariku ati gevega-agirana talimara ea, ta ati goveakavaato genai, au maki vovetaina gokala-venikuto, ati goveakavakuto.’ ");
INSERT INTO khz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ganina ira viti-vua vanagivanagi kapunai pia ago, a kala rorirori talimara maguli vanagivanagi kapunai pia ago.” ");
INSERT INTO khz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu na egaura maparara evevega-ripagi-gaturato aonai, gena melo evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gomi maripami, toma rualamo roe nea, Pasova pia kalaa. (Voo Iuda talimara kwarega aneruna na evanagirato ati evagirato velekwana). Votomai Taunilimalima Natuna talima reketa gimarai pia taoa, pia satauroa.” ");
INSERT INTO khz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ne Rupu Veaga velera kamura e Iuda geria vele kamura getanu-kouto, Kaiapa, Rupu Veaga velena kamuna, gena numai. ");
INSERT INTO khz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Navuga getovo-lemaato, Iesu pia gapia, ne pia vagi-kwaregaa. ");
INSERT INTO khz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na gekilato, “Velekwa aonai ragai pene wala, kwalana velekwai pia vogomai talimara ia atana na nege purina nea.” ");
INSERT INTO khz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu Betaniai, Simona, lepera talimana, gena numai. ");
INSERT INTO khz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Geganiganiwai aonai, vavine ta ia genai eagoto; mata namana ta, alabasta vatuna na gekalaato matana, egapikauto, aonai mulamula maponana namana, voina kamu iwavagi; Iesu ganigani kapunai etanu-tagowai aonai, vovavine na Iesu repanai epopo-kauato. ");
INSERT INTO khz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gena melo na gegitaato, ne geparuto, gekilato, “Rakagau gaurana ne mulamula epiatoga-kawaana? ");
INSERT INTO khz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Emulamula pere voi-agia, pe moni kamuna pere gapia, ne ati geria e ati garia talimara pere venira!” ");
INSERT INTO khz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu ripana ira rakagau gekilagiato, gaura pakurai evaikilarato, netiwato, “Rakagau gaurai evavine gomunemune-agiana? Evavine na kala namana au geku ai pekalagia. ");
INSERT INTO khz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ati geria e ati garia talimara gomi ria pio talu-vanagivanagi. Na au ati toma mapararai gomi ria pita talu. ");
INSERT INTO khz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Evavine na mulamula au tauniparaku ai pepopo-kunea, au pia toleku ulanana. ");
INSERT INTO khz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Taunatauna avaikilamina, Vali Namana pia vopatagia tanopara maparara aorai, evavine na kala pekalaa kalana maki pia kilagia, ia tugamagi-tagoagina.” ");
INSERT INTO khz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ne gagalana ruala talimara ta, arana Iudas Isakariota, Rupu Veaga velera kamura geriai eagoto, ");
INSERT INTO khz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","erenagirato, netiwato, “Rakagau pio veniku, pene Iesu gimami ai pana tao-kaua genai?” Ira na siliva monira gagala toitoi (30) gevega-agirato, ne geveniato. ");
INSERT INTO khz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Voanana vegata Iudas na ira gimarai pene tao-kaua rauparana etavuawai. ");
INSERT INTO khz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ati egorona paraoana velekwana tomana tovotovonai gena melo Iesu genai geagoto, gerenagiato, negetiwato, “Ai ariginai Pasova velekwana paia kala-maavua, pono gania?” ");
INSERT INTO khz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ne Iesu na evega-gelerato, netiwato, “Ioago vanuga kamuna aonai, pakilagia talimana genai, pio vaikilaa, nopiotiwa, ‘Vevega-ripa tauna ekilana: Geku ora warau pekwara. Gaurai mageku melo ria goina numai vekapawai mamoena paia gania.’” ");
INSERT INTO khz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ne melo Iesu na evaikilarato gelegelerai Pasova velekwana gekalaato. ");
INSERT INTO khz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lavilavi Iesu magena melo gagalana ruala ria getanu-talito, velekwa pia gania. ");
INSERT INTO khz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ne geganiawai aonai, evaikilarato, netiwato, “Taunatauna avaikilamina, gomi taa na au pono lewaku.” ");
INSERT INTO khz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ira maparara aora mametaura na kwapurakwapura na gerenagiato, negetiwato, “Velekou, taunatauna ati au, ei?” ");
INSERT INTO khz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu evega-geleto, netiwato, “Au goti rivu kwapunaimo paia napa-rigo talimana na au pene lewaku. ");
INSERT INTO khz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Taunilimalima Natuna pene kwarega Puka Veaga aonai getaloato gelegelenai. Na Taunilimalima Natuna pene lewaa talimana ia vetugana kekei; ati pere maguli nama.” ");
INSERT INTO khz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ne Iudas, velewa talimana, ekilato, “Vevega-ripa taumu, taunatauna ati au, ei?” Iesu evega-geleto, netiwato, “Gauna okilagiana nea.” ");
INSERT INTO khz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Geganiganiwai aonai, Iesu na pereti egapiato, Palagu evega-namaato, ekala-kava-lugaato, evenirato, ne evaikilarato, “Iogapia, iogania, e au tauniparaku.” ");
INSERT INTO khz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ia na kaperi maegapi-itiato, evega-namaato mulinai, evenirato, netiwato, “Ioniua, gomi maparami. ");
INSERT INTO khz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","E au ralaku, Vekapawai Valiguna evega-taunataunaana, pene vepopo, taunilimalima gutuma geria rakava tugamagi-piatogara ulanana. ");
INSERT INTO khz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Avaikilamina, evine nanuna ati mapana niu-waia, pene ago tomana pene kwara vou, au gomi ria na mapita niu-koukoua au Tamaku gena Basileia aonai.” ");
INSERT INTO khz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ne mari ta gemariato mulinai, gelaka-piatito, Olive Golonai geagoto. ");
INSERT INTO khz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ne Iesu na evaikilarato, netiwato, “Toma pogi gomi maparami gemi kamonagi au geku ai pio raka-kwanira, kwalana Puka Veaga aonai evetaina ekilana, ‘Au na mamoe gitatagona talimana pana vagia, mamoe maparara pia kali-lovolovo.’ ");
INSERT INTO khz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na au kwarega na pana kuliiti-wai mulinai, pana ago-kune Galileiai. Vonai vou pita verawali.” ");
INSERT INTO khz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petero na, Iesu evaikilaato, netiwato, “Pene maparara geria kamonagi pia raka-kwanira goi gemu ai, na aumo aikina.” ");
INSERT INTO khz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu na Petero evaikilaato, netiwato, “Taunatauna avaikilamuna, toma pogi kokoloku rogoti ere kogo aonai, goi na au vega-toitoi pono opa-tagoku.” ");
INSERT INTO khz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Na Petero ekila-vigirageto, netiwato, “Pene goi goti pita kwarega-koukou genai, au na goi vegata vagi ati pana opatago-kapu-vagimu.” Gena melo maparara maki vovetaina gekilato. ");
INSERT INTO khz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iesu magena melo ria geagoto kapu ta arana Getesemane, ne ia na evaikilarato, netiwato, “Enai iotanu-tago, au aagona, ana rapali.” ");
INSERT INTO khz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne Petero e Tepetaio natuna rualamo evairato, ia ria geagoto. Aonai Iesu tauniparana epalapalato, ekalito, aona maki evekwalavito. ");
INSERT INTO khz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne evaikilarato, netiwato, “Au nugaku na metau kamu vagi evuana, roli evagikuna. Enai iotanu-tago, pio gitatago au ria.” ");
INSERT INTO khz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iesu kiata maelaka-nagito, wailana kwano ai eve kwanu-taliato, ne erapalito, netiwato, “Tamaku o, pere marauparana ta, e viti-vua kaperina gekuna onoma gaivagia. Na ati au geku ririwa, goimo gemu ririwa.” ");
INSERT INTO khz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Gena melo toitoi geriai ewaikuleto aonai, ira gemaitu-kwaregato erawalirato, ne Petero evaikilaato, netiwato, “Rakagau gaurai gomi taumi toitoi au ria ora ta vetaina maki ati pogo vaigaoka? ");
INSERT INTO khz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pio vaigaoka, pio rapali, pe veopatovo pene vogomai aonai ragai pio moira. Palagu taunatauna eririwana, na taunipara emoirana.” ");
INSERT INTO khz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iesu vega-rualana elaka-pakato, everapalito, netiwato, “Tamaku o, pene raupara ta aikina e viti-vua kaperina pono gaivagia genai, goi gemu ririwamo pono kalaa.” ");
INSERT INTO khz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Maeve waikule-waito aonai ira ati geria vaigaoka gaurai, maitu kwaregarai ema rawalirato, kwalana matara maitu na egapi-rakavarato. ");
INSERT INTO khz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iesu na maeraokwanirato, maeagoto, vega-toitoi maeverapalito, gena rapali kunera kilara maekilagi-wairato. ");
INSERT INTO khz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ne gena melo geriai maeve waikule-waito, evaikilarato, “Gomi roe ogo maituna e gopikapikana? Iogitaa! Orana warau pekwara! Taunilimalima Natuna pege lewaa, rakava talimara gimarai pege taoa. ");
INSERT INTO khz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Iokuliiti, ita wati! Iogitaa, au elewakuto talimana pekwara!” ");
INSERT INTO khz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu roe waekilakilawai aonai, Iudas, melo gagalana ruala tauna ta, ekwarato. Taunilimalima gutuma ia ria mageria vetali kativara e vevagi gapara. Ira Rupu Veaga velera kamura e Iuda velera na getugurato. ");
INSERT INTO khz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lewa talimana na vegailia ta evaikila-maavurato, netiwato, “Pana velavua talimana voa, pio gapi-talia.” ");
INSERT INTO khz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iudas ekwarato aonai, rorirori eagoto Iesu genai, ne ekilato, “Vevega-ripa talimamu, pogi namana!” ne evelavuato. ");
INSERT INTO khz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu na evega-geleato, netiwato, “Gata, poririwaa kalana povogomai-venia kalana ono raka kalaa!” Ne gevogomaito, gimara na Iesu gegapi-taliato, geligoligoato. ");
INSERT INTO khz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na Iesu gena melo ta gena vetali kativana einu-vagiato, eavuato, Rupu Veaga velena kamuna gena vetugunagi talimana tegana epati-vagiato. ");
INSERT INTO khz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ne Iesu na evaikilaato, netiwato, “Gemu kativa uraurana kapunai ono ura-waia. Kwalana vetali kativara gegapina talimara maparara vetali kativarai pia kwarega. ");
INSERT INTO khz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Goi ati ripamu, Tamaku gena veveakava pana nogia, ia na aneru veganamo au geku ai pene tugura, aneru goleara gagalana ruala pa ragana gagala taulatoi kwapuna (70,000) e mareketa maki pene tugura au veakavaku? ");
INSERT INTO khz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Vovetaina pere kala, na Puka Veaga aonai warau getaloato kilana raka pene taunatauna-tiwa? Gaurana, evetainamo pene mia!” ");
INSERT INTO khz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iesu na vonai talima gutuma evaikilarato, netiwato, “Au karoverave goleana ta avaiana, gaurai gomi pogo vogomai au gapigapiku magemi vetali kativara e vevagi gapara ria? Toma mapararai au gomi lagami ai, Rupu Veaga aonai avevega-ripawai, na ati gogapi-talikuto. ");
INSERT INTO khz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na egaura maparara gewalana peroveta talimara na Puka Veaga aonai getalo-kunerato kilara vega-taunataunara ularana.” Ne Iesu gena melo maparara na geraka-kwaniato, geraka-lovolovoto. ");
INSERT INTO khz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Gegapi-taliato talimara na Iesu gevaiagoato, Kaiapa, Rupu Veaga velena kamuna, gena numai. Vonai rova gevevega-ripagirawai talimara e Iuda velera warau gelaka-koukouto. ");
INSERT INTO khz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petero na Iesu elaka-guiawai, mavepakana pene ago, Rupu Veaga velena kamuna gena numai. Elaka-togato kana aonai, ne vegitatago talimara nuganugarai eve tanu-talito, pene gita, vokala ikanai rakagau pene matagai. ");
INSERT INTO khz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Rupu Veaga velera kamura e Iuda geria kaonsela talimara maparara veroli-opakau talimara getavurato, Iesu pia opagia, pe pia vagia ulanana. ");
INSERT INTO khz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Veroli-opakau talimara gutuma gekuliitito, geopagiato, na geria kila ati gekwapunawai. Ikanai vou opakau talimara ruala gekila-rageto, ");
INSERT INTO khz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","negetiwato, “Etalima ekilato, ‘Au matiavuku Palagu gena Rupu Veaga pana lovoa, toma toitoi aorai mapana vega-ruga-waia.’” ");
INSERT INTO khz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ne Rupu Veaga velena kamuna erugaitito, Iesu erenagiato, netiwato, “Goi ati pono vega-gele? Eira na goi gevali-piagimuna kilara rakavetaina?” ");
INSERT INTO khz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Na Iesu ati ekilakilato. Rupu Veaga velena kamuna na maerenagi-waiato, netiwato, “Maguli Palaguna aranai au na goi avaikilamuna, ono varamai: Goi Keriso, Palagu Natuna?” ");
INSERT INTO khz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu na evega-geleato, netiwato, “Gauna okilagiana nea! E au na gomi maparami avaikilamina: Etoma, pene ago wailai, gomi na Taunilimalima Natuna roe nea pio gitaa, Tiavu Palaguna gimana ripanai pene tanu, e kupa iloara atara na pene vogomai!” ");
INSERT INTO khz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ne Rupu Veaga velena kamuna matotauna gena rapuga eraleato, netiwato, “Palagu vega-rakavana kilana ekilagi-gatuato! Rakagau gaurana vevega-gita talimara roe ata tavurana? Palagu vega-rakavana kilana pekilagia, warau pogo kamonagia. ");
INSERT INTO khz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Rakagau nogotina?” Ira maparara gekilato, “Pene kwaregamo.” ");
INSERT INTO khz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ne wailana gekainiuato, gekwariato. Reketa na geapariato, ");
INSERT INTO khz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","negetiwato, “Keriso, goi peroveta talimana, gaurana ono varamai, rai na pekwarimu?” ");
INSERT INTO khz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petero roe voa numa kanana aonai etanu-tagowai, vetugunagi vavinena ta ia genai evogomaito, evaikilaato, “Goi maki Iesu, Galileia tauna, goti golakavowai, okwaruawai.” ");
INSERT INTO khz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Na Petero evevega-veituto ira maparara wailarai, netiwato, “Au ati ripaku goi rakagau okilagiana.” ");
INSERT INTO khz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ne elaka-piatito, kana vanagina laganai eagoto. Mavetugunagi vavinena taa na egitaato, ne lagana talimara evaikilarato, netiwato, “Ia maki Iesu, Nasareta talimana, ekwaruato talimana.” ");
INSERT INTO khz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petero maeveituto, ekila-gaokato, netiwato, “Au ati ripaku netalima.” ");
INSERT INTO khz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ati rau kiana, vonai geruga-tagowai talimara Petero genai gevogomaito, gevaikilaato, negetiwato, “Taunatauna, goi maki ia goti talimana ta, kwalana karomu na evega-matagaimuna.” ");
INSERT INTO khz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ne Petero na evaikilarato, “Aikina kinavagi, avaikila-taunataunamina, netalima au ati ripaku!” Aikina na kokoloku ekogoto. ");
INSERT INTO khz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ne Petero na Iesu gena kila etugamagi-rawaliato, evaikilaato, “Kokoloku rogoti ere kogo aonai, goi na au vega-toitoi pono opa-tagoku.” Ne elaka-piatito muli ai, etagi-rakavarakavato. ");
INSERT INTO khz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Amoamo garo kagena etugu-rageana nea na, Rupu Veaga velera kamura maparara e Iuda velera genavuga-kouto, Iesu pia vagia. ");
INSERT INTO khz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Teini na geligoligoato, gevaiagoato, Pilato, Roma kavanana, gimanai getao-kauato. ");
INSERT INTO khz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iudas, lewa tauna, na Iesu egitaato, veakwaregana kilana warau gekalaato, ne evevega-vuato. Ne siliva monira gagala toitoi (30) evua-waikulerato Rupu Veaga velera kamura e Iuda velera geriai. ");
INSERT INTO khz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Evaikilarato, “Au pakala rakava, kwalana ati gena rakava talimana palewaa, pene kwarega.” Gevega-geleato, negetiwato, “Nema ati ai gema nuga vekwalavi, na goi matotaumu gemu inagulu.” ");
INSERT INTO khz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iudas na siliva monira Rupu Veaga aonai epia-togarato, elaka-kalito. Ne eagoto, matotauna evenagato. ");
INSERT INTO khz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ne Rupu Veaga velera kamura na vosiliva monira gegapirato, gekilato, “E rala voina monina, vega-nama mauanai ragai vagi pita ura-rigora, rova.” ");
INSERT INTO khz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Gekilagi-kilagiato, gevega-taunataunaato mulinai, vomoni gegapiato, gulo ekalawai talimana gena tano gevoiato, tanopara polu talimara geria kala kapunai gevega-agoato. ");
INSERT INTO khz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Vovetaina gaurai votano arana gekeaato “Rala Tanona” pene vogomai etoma. ");
INSERT INTO khz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Voanana Ieremia peroveta talimana gena kila ema taunataunato, netiwato, “Vosiliva monira gagala toitoi (30) gegapirato, Isaraela talimara na gevega-taunataunaato voina keina, votalima pia vega-voia. ");
INSERT INTO khz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","E vomoni na gulo ekalawai talimana gena tano gevoiato, Velekou ekilato gelegelenai.” ");
INSERT INTO khz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu Roma kavanana wailanai erugato, ia na erenagiato, netiwato, “Goi Iuda talimara geria king pa?” Iesu evega-geleto, netiwato, “Pa, okilagiana nea.” ");
INSERT INTO khz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ne Rupu Veaga velera kamura e Iuda velera na Iesu geopagiato, na kila ta ati ekilagiato. ");
INSERT INTO khz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Gaura pakurai Pilato na evaikilaato, netiwato, “Goi ati okamonagina, atamu ai metau kamu vagi gekilagiana?” ");
INSERT INTO khz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Na Iesu evaigarito, kila vuana tai maki ati evega-gelerato. Voanana kavana evevega-kali-rakavato. ");
INSERT INTO khz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vanagivanagi Pasova velekwana tomanai kavana na ira geria tipura numanai etaluna pia kilagia talimana ta etugu-piatiawai. ");
INSERT INTO khz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Volaganinai talima rakava kwaikwaina ta tipura numanai etaluwai, arana Barabas. ");
INSERT INTO khz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gaura pakurai talima gutuma getanu-kouto aonai, Pilato na erenagirato, netiwato, “Rai goririwaana ana tugu-atia: Barabas pa Iesu, gekilagiana Keriso?” ");
INSERT INTO khz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kwalana Pilato ripana vealeva, Iuda talimara kamura geria vekuku pakunai, Iesu ia gimanai getao-kauato. ");
INSERT INTO khz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato na Kota ekalaawai aonai, Pilato garawana na gena keakau gema varaato, netiwato, “Nekala rorirori talimana genai gau kwauta ragai pono kalaa, kwalana au pogi panivi, geku nivi ai viti-vua kamu vagi na pegapiku ia pakunai.” ");
INSERT INTO khz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na Rupu Veaga velera kamura e Iuda velera na tanukou talimara aora geganirato, Pilato pia vaikilaa, Barabas pene tugu-piatia, na Iesu pene kwarega. ");
INSERT INTO khz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na kavana na tanukou talimara maerenagirato, netiwato, “Ira taura ruala rai gomi gemi ana tugu-piatia?” Tanukou talimara geparalato, negetiwato, “Barabas!” ");
INSERT INTO khz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne Pilato na erenagirato, netiwato, “Na e Iesu, gekilagiana Keriso, raka ana kalagi-tiwaa?” Ira maparara gevega-gele-koukouto, negetiwato, “Ono satauroa!” ");
INSERT INTO khz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na Pilato na maerenagirato, netiwato, “Rakagau gaurai? Raka kala rakavana ekalaato gaurai?” Na maparara geparalato, negetiwato, “Ono satauroa!” ");
INSERT INTO khz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato etugamagi-ripato, ia gena ripa kilara ati pia gapi-ragera, e taunilimalima ia atana na nege purina kalinana, gaurai nanu egapiato, gimana eguligiato votaunilimalima gutuma wailarai, e evetaina ekilato: “Au ati geku kepi ekala rorirori talimana ralana genai; e gomimo gemi inagulu!” ");
INSERT INTO khz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tanukou talimara maparara gevega-geleto, negetiwato, “Etalima ralana pa gena kwarega metauna ai atamai ai pene mia e ai natumai atarai.” ");
INSERT INTO khz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ne Pilato na Barabas etugu-atiato ira geria, na Iesu ia kwaria aonai vou vetali taura evenirato, pia satauroa ulanana. ");
INSERT INTO khz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ne Pilato gena vetali talimara na Iesu gevaiagoato kavana na numa aonai, taukavara maparara gekea-koukourato, ne geruga-gegelagiato. ");
INSERT INTO khz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gena rapuga geluga-vagirato, rapuga kalovakalova geveakalaato, ");
INSERT INTO khz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","repana gauna gau vekalavekala gevatuato, kraon vetaina gekalaato, ne Iesu repanai getao-kauato. Toki ta maki gimana ripanai geveagapiato, ne wailanai getiu-talito, gevegarevegare-agiato, negetiwato, “Iuda geria King o, toma namana!” ");
INSERT INTO khz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ne gekainiuato, votoki gegapi-rariato, repana gekwariwai-kwariwaiawai. ");
INSERT INTO khz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Gevegarevegareagi-gatuato mulinai, rapuga kalovakalovana gegaivagiato, gena rapuga taunataunara mageveakalaato. Ne gevaiatiato, pia satauroa ulanana. ");
INSERT INTO khz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Gelaka-piatiwai aonai, Kureni talimana ta ria geverawalito arana Simona. Vetali talimara pa soldia na gelaunaginagiato, Iesu na satauro ene vuaa. ");
INSERT INTO khz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ne vanuga na gelaka-piatito, kapu taai gekwarato arana Gologota, ganina, ‘Repa Gavana Kapuna.’ ");
INSERT INTO khz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Vonai vine nanuna viti-vua vega-keina mulamulana arana gal ria gekiroato gauna, Iesu geveniato; emamitovoato, na ati eniuato. ");
INSERT INTO khz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Gesatauroato mulinai, gena rapuga ira nuganugarai gewarerato kati ai. ");
INSERT INTO khz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Voia mulinai getanutanu-talito, ne gegita-tagoato. ");
INSERT INTO khz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ia repana atanai rakagau gaurai ia gesatauroato kilana getao-kauato, evetaina getaloato, “E IESU, IUDA TALIMARA GERIA VELE.” ");
INSERT INTO khz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Karoverave talimara ruala maki Iesu ria gesataurorato, ta ripana kavanai, e ta kaulina kavanai. ");
INSERT INTO khz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gelaka-vanagiwai talimara repara gekwarakwararawai, kila rakavara Iesu geveniawai, ");
INSERT INTO khz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gekilawai, “Pa goi okilato, Rupu Veaga pono lovoa, toma toitoi aorai mapono vega-ruga-waia notiwato, matotaumu ono vevega-maguli! Pene goi Palagu Natuna, satauro kukuna na ono laka-rigo.” ");
INSERT INTO khz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Rupu Veaga velera kamura e rova gevevega-ripagirawai talimara e Iuda velera na maki evetaina gevegarevegare-agiwai, negetiwato, ");
INSERT INTO khz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ia na talima polura evega-magulirawai, navou ia matotauna ati evevega-magulina! Pene ia taunatauna Isaraela talimara geria vele genai, satauro na ewagumona kiana ene laka-rigo, pe paia vega-taunataunaa. ");
INSERT INTO khz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ia na Palagu evega-taunataunaawai, ita gitaa, Palagu na maki pene tugamagia, pene vega-magulia pa? Evekilagiwai, ‘Au Palagu Natuna,’ ei?” ");
INSERT INTO khz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iesu ria gesatauro-kourato karoverave talimara ruala na maki vovetaina gevaikila-rakavaato. ");
INSERT INTO khz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ora gauna 12 koloko egapiato aonai, tanopara maparana mukuna na egapi-gavuato, mukuna emiato pene ago ora gauna 3 koloko. ");
INSERT INTO khz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ora gauna 3 koloko kavanai Iesu ekea-lailaito, netiwato, “Eloi, eloi, lama sabaktani?” ganina “Au geku Palagu, au geku Palagu, rakagau gaurai au poraokwaniku?” ");
INSERT INTO khz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Taunilimalima reketa vonai geruga-tagowai aonai, gekamonagito, ne gekilato, “Ia Elia ekeana.” ");
INSERT INTO khz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ne geria talima ta eraka-agoto, nanu limagina gauna ta egapiato, vine nanuna mamakina aonai eroli-gugutuato, toki kevenai ekwanu-kauato, ne etugu-rageato, Iesu na pene niua ulanana. ");
INSERT INTO khz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Na reketa gekilato, “Ita aloa vou, ita gitaa, Elia pene vogomai, pene vega-magulia pa aikina.” ");
INSERT INTO khz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Iesu maekea-lailaito mulinai ekwaregato. ");
INSERT INTO khz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ne volaganinamo kianai Rupu Veaga aonai veaga iwavagi kovogana, vega-gelogavuna rapugana pa ketin na everale-kavalugato, kwatu ruala kukuna na pene verigo kapinanai. Tano etano-kepoato, vatu kamura gekava-lugato. ");
INSERT INTO khz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kwarega legara gevekala-pakato, e talima gutuma, Palagu gena ririwa gekalarawai talimara, kwarega na magekuliiti-waito, ");
INSERT INTO khz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","geria lega kapura geraokwanirato. Iesu gena kuliitiwai mulinai, Siti Veaganai geagoto, vonai taunilimalima gutuma wailarai gematagaito. ");
INSERT INTO khz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Vetali velena magena vetali talimara ria, Iesu gegita-tagoawai talimara, tanokepo e gewalato gaura maparara gegitarato aonai, gekali-rakavato, negetiwato, “Etalima taunatauna Palagu Natuna!” ");
INSERT INTO khz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Gare vogo maki vonai, kiata rau ai gerugato, gemoalewai. Vogare Iesu mulinai gelakato Galileia na geagoto Ierusalemai, e ia vetugunaginai geagowai. ");
INSERT INTO khz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ira nuganugarai Maria, Magadala garena; Maria, Teimiti e Iosepa tinara; Teimiti e Ioane Tepetaio tinara. ");
INSERT INTO khz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Volavilavinai rinaga iwavagi talimana Arimatea vanugana na ekwarato, arana Iosepa; ia maki Iesu gena melo ta. ");
INSERT INTO khz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ia Pilato genai eagoto, ne enogiato, Iesu tauniparana pene gapia netiwato. Ne Pilato na gena vetali talimara evaikilarato, Iesu tauniparana Iosepa pia venia. ");
INSERT INTO khz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Gaura pakurai Iesu tauniparana egapiato, rapuga kulokulo namana na ekumuato, ");
INSERT INTO khz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kala kapuna vatu kovoganai eve tao-togaato. Vokala vatu gaoka-poro kovogana ta gekoloato, ia matotauna gena lega kapuna valiguna ta. Vatu kamuna na kovoga pokana gekule-gavuato, ne eraokwaniato. ");
INSERT INTO khz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria, Magadala garena, e Maria ta vonai getanu-tagowai, lega getanu-wailaato. ");
INSERT INTO khz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Velekwa gekala-maavuana tomana eaikito vou, Tapati warau ene gapia, Rupu Veaga velera kamura e Parisea talimara Pilato genai geagoto, ");
INSERT INTO khz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","gekilato, “Velepara, ai gatugamagina, voo opakau talimana roe magulinai, ekilato, ‘Toma toitoi mulirai au kwarega na mapana kuliiti-wai.’ ");
INSERT INTO khz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Gaura pakurai vegitatago taura ono vaikilara, pe lega kapuna pia gitatago-gitakaua, pene ago votoma toitoi mulirai. Irau na gena melo nege vogomaina, tauniparana nege lemaana, ne taunilimalima nege oparana, nepiatiwa, ‘Ia kwarega na pekuliiti-wai,’ negetina nea. Eopa na opakau kunena pene vanagia.” ");
INSERT INTO khz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato na evaikilarato, netiwato, “Vegitatago talimara iogapira, ia ago, pe lega pokana pia ruga gavu-namanamaa.” ");
INSERT INTO khz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ne kalai geagoto, lega kovogana gekou-gavuato vatuna geveakaraato, ne vegitatago talimara getaorato, pia gita-tagoa. ");
INSERT INTO khz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tapati eaikito mulinai, epetoma toma tovotovonai, amoamo elagani-mamamaawai aonai, Maria, Magadala garena, Maria ta goti geagoto, kala kapuna gegitaato. ");
INSERT INTO khz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Atirau na tanokepo kamuna ekwarato, kwalana Velekou gena aneru ta kupa na emarigoto, vatu ekule-pakaato, ne atanai etanukauto. ");
INSERT INTO khz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ia gitagitana noowane rama ekeuleana vetaina, e gena rapuga kulo poikapoika gamavu pa tinoo gelegelena. ");
INSERT INTO khz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lega kapuna gegita-tagoato talimara gekali-rakavato gaurai gepilupiluwai, ne tano ai geketo-talito kwarega talimara vetaira. ");
INSERT INTO khz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aneru na vogare evaikilarato, netiwato, “Ragai iokali, au ripaku gomi Iesu, gesatauroato talimana, gotavuana. ");
INSERT INTO khz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ia enai aikina; ia pekuliiti-wai, evaikilamito gelegelenai. Getaoato kapuna iomai-gitaa. ");
INSERT INTO khz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pe ioago vega-veleke, gena melo pio vega-ripara, nopiotiwa, ‘Iesu kwarega na pekuliiti-wai, e pene kune-agimi Galileiai. Vonai vou pio gitaa.’ Ekila ana vega-ripami ulanana pavogomai.” ");
INSERT INTO khz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ne vogare na lega kapuna geraokwani vega-velekeato, makalira e mavererera ria gerakato gena melo geriai, voaneru gena kila vevega-ripagina ulanana. ");
INSERT INTO khz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Gelakawai aonai, atilovana Iesu ira wailarai erugato, netiwato, “Maino gomi ria.” Ne wailanai gevetiu-talito, gagena gevuarato, gealiruputali-veniato. ");
INSERT INTO khz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iesu na evaikilarato, netiwato, “Ragai iokali, ioago, au tariku iove vaikilara, Galileiai pia ago; vonai vou au pia gitaku.” ");
INSERT INTO khz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Gare ruala raupara na geagowai aonai, vetali talimara reketa, lega kapuna gegita-tagoato talimara, gewaikuleto vanuga kamunai, rakagau rakagau gewalato gaura maparara Rupu Veaga velera kamura gevega-riparato. ");
INSERT INTO khz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ne voRupu Veaga velera kamura Iuda velera ria genavuga-kouto, vegitatago talimara moni kamuna gevenirato. ");
INSERT INTO khz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Evetaina gekilato, negetiwato, “Gomi pio kila, ‘Gena melo pogi aonai pege vogomai, ai maitumai ai pege lemaa.’ ");
INSERT INTO khz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pene evali kavana na pene kamonagia genai ai na ia aona paia vega-pikapikaa, pe gomi kala rakavana ta ati pene vaivenimi.” ");
INSERT INTO khz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Vegitatago talimara na moni gegapiato, gevaikilarato gelegelenai gekilato. Evali Iuda talimara nuganugarai gekilagi-lovolovoato, etoma maki roe gekilagiana. ");
INSERT INTO khz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gena melo gagalana kwapuna (11) Galileiai geagoto, Iesu na ekilagi-kuneato golonai. ");
INSERT INTO khz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Vonai gegitaato aonai, gealiruputali-veniato; na reketa geaovoaovoto: ‘Goi e Iesu taunataunana pa?’ ");
INSERT INTO khz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ne Iesu elaka-kavito, evaikilarato, netiwato, “Palagu na tiavu maparana kupai e tanoparai au warau peveniku. ");
INSERT INTO khz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Gaura pakurai ioago tanopara mapararai, taunilimalima maparara geku melo ai pio vega-agora. E Tamana, Natuna, Veaga Palaguna ararai pio bapatisora. ");
INSERT INTO khz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pio vega-ripara maki, avenimito vevega-nagira maparara pia kwalanara. Pio ripa, au toma mapararai gomi ria pita talu, pene ago tanopara ikana!” ");
INSERT INTO khz_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Iesu Keriso Palagu Natuna Valina Namana evetaina evetinato. ");
INSERT INTO khz_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peroveta talimana arana Isaia na etaloato, “Palagu ekilato, ‘Au na geku vetugunagi talimana pana tugu-kunea, gemu raupara pene kala-maavua.’ ");
INSERT INTO khz_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Talima ta tanoleanai ekeana, netina, ‘Velekou gena raupara ioalevaa, gena vogomai rauparana iovega-roriroria!’” ");
INSERT INTO khz_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gaura pakurai Ioane evogomaito, tanoleanai taunilimalima ebapatisorawai e evopatawai, taunilimalima geria rakava aora na pia vetugamagiwai e pia laka-waikule Palagu genai, e bapatiso pia gapia, Palagu na geria rakava pene tugamagi-piatogara ularana. ");
INSERT INTO khz_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Taunilimalima maparara Iudea vanugara na e Ierusalema na geagowai Ioane genai. Geria rakava gekilagi-matagairawai vou, ebapatisorawai Ioridana wainai. ");
INSERT INTO khz_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioane gena rapuga kamela lamulamuna na gekalaato, gena paekopina nanikoti kopina, gana ganigani gaura koi e kwareremo. ");
INSERT INTO khz_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Evopatawai, netiiwai, “Talima ta au muliku na pene vogomai ia gena tiavu na au geku tiavu evanagiana. Au maki ati gelegele ia gena tamaka walona pana lugaa. ");
INSERT INTO khz_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Au na gomi nanu na abapatisomina, na ia na Veaga Palaguna na pene bapatisomi.” ");
INSERT INTO khz_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Volaganinai Iesu Nasareta, Galileia vanugana taa, na evogomaito, ne Ioane na Ioridana wainai ebapatisoato. ");
INSERT INTO khz_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesu nanu na erage-vagito aonai, kupa egitaato, evekala-pakato, ne Veaga Palaguna pune vetaina emarigoto ia genai. ");
INSERT INTO khz_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne karo ta kupa na ekea-rigoto, netiwato, “Goi au Natuku, aulamagimuna; e gemu ai maki averere-rakavana.” ");
INSERT INTO khz_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Voia mulinai Veaga Palaguna na Iesu tanoleanai etugu-agoto. ");
INSERT INTO khz_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Vonai toma e pogi gagala vativati (40) egapirato, Satani na ekalatovoawai. Ia manega paera ria getaluwai, aneru na gegita-tagoawai. ");
INSERT INTO khz_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ioane tipura numanai getao-togaato mulinai, Iesu Galileiai eagoto, Palagu Valina Namana eve vopatagiawai. ");
INSERT INTO khz_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Evopatato, netiwato, “Palagu gena toma warauna pekwara, gena Basileia pekwara, (gena vegitatago tiavuna evega-rugaana ea)! Gemi rakava aora na iovetugamagi-waikule, Vali Namana aomi na iovega-taunataunaa!” ");
INSERT INTO khz_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesu Galileia kovu pipina na eagowai aonai, Simona matarina Anduru goti egitarato, geria leke kovu ai gepiaato, kwalana ira vetavu talimara. ");
INSERT INTO khz_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne Iesu na evaikilarato, netiwato, “Muliku ai iomai-laka, pe au na gomi taunilimalima vetavura pana vega-ripami.” ");
INSERT INTO khz_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ne veganamo geria leke geraokwanirato, Iesu mulinai gelakakauto. ");
INSERT INTO khz_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ati gelaka-rauto, ne Iesu na Teimiti Tepetaio, matarina Ioane goti egitarato, gati ai geria leke veralera geaumerawai; ");
INSERT INTO khz_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ekearato, ne ira na tamara Tepetaio magena inagulu talimara ria gati ai geraokwanirato, Iesu mulinai gelakakauto. ");
INSERT INTO khz_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gelaka-agoto, Kaperanaumai gekwarato. Vonai Tapati ai Iesu Iuda talimara geria rupu ai elaka-togato, ne evevega-ripato. ");
INSERT INTO khz_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ia gena vevega-ripa kilana taunilimalima na gekamonagirato aonai, gevevega-kaliagirato, kwalana gena kila matiavuna, ati rova gevevega-ripagiawai talimara geria kila vetaira. ");
INSERT INTO khz_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Vorupu ai talima ta palagu rakavana na eporogiato talimana. Ia ekeaato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu, Nasareta talimamu o, rakagau gemai ono kalaa notina? Goi ai vega-rakavamai ulanana povogomai? Au ripaku goi ne rai, goi nema Palagu gena Veaga Talimamu!” ");
INSERT INTO khz_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu na ekila-waiato, “Kulumu! Ia genana ono lakati!” ");
INSERT INTO khz_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ne palagu rakavana na votalima evega-pilupiluato, ne malailaina ria elakatito. ");
INSERT INTO khz_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Taunilimalima maparara gevevega-kali-rakavarakavato, ne matotaura geverenagi-verenagito, negetiwato, “E rakagau? Vevega-ripa valiguna? Ia matiavuna na palagu rakavara evega-vegupurana, e karona maki gekamonagiana!” ");
INSERT INTO khz_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ne Iesu valina atilovana eraka-lovolovoto Galileia vanugara mapararai. ");
INSERT INTO khz_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Rupu na gelaka-piatito mulinai, Teimiti e Ioane geagoto, Simona e Anduru geria numai gerageto. ");
INSERT INTO khz_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simona gena tegama garena evitiato, tauniparana etiavutiavuto, gaurai emaoko-tagowai, ne Iesu gekarovaraato. ");
INSERT INTO khz_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu eagoto genai, gimanai egapito, ne evega-tanu-itiato. Voviti eaikito, ne ira egupurato. ");
INSERT INTO khz_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lavilavi, garo eketoato mulinai, taunilimalima na viti talimara e palagu rakavara na geporogirato talimara Iesu genai gevaiagorato. ");
INSERT INTO khz_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Vanuga talimara maparara numa wailanai getanu-kouto. ");
INSERT INTO khz_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iesu na viti irauirau talimara vovogo evega-namarato e palagu rakavara gutuma egui-atirato. Palagu rakavara murura ekourato ragai pia kilakila, kwalana ira riparia Iesu. ");
INSERT INTO khz_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rapa kavanai, rogotina ere lagania aonai, Iesu ekuliitito, tanoleanai eagoto, everapalito. ");
INSERT INTO khz_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ne Simona mataukavana ria Iesu geve tavuato, ");
INSERT INTO khz_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","geve rawaliato aonai, gevaikilaato, negetiwato, “Goi taunilimalima na getavumuna!” ");
INSERT INTO khz_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesu evega-geleto, netiwato, “Vanuga vekavirai ita ago. Voira geriai maki pana vopata, au geku vogomai kwalana voa.” ");
INSERT INTO khz_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ne ia eagoto Galileia vanugara mapararai. Rupu ai evopatawai e palagu rakavara egui-atirawai. ");
INSERT INTO khz_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Talima ta maleperana Iesu genai eagoto, evetiu-talito, ne enogiato, netiwato, “Pene goi oririrwana genai, taunatauna pono kala-alevaku e pono vega-namaku ripa.” ");
INSERT INTO khz_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu na egita-vetugaato, gimana etugu-agoato, viti talimana enapa-kaunagiato, evaikilaato, “Aririwana, ono nama!” ");
INSERT INTO khz_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ne veganamo lepera na eraokwaniato, enamato. ");
INSERT INTO khz_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu na evaikila-gaokaato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ekala talima ta ragai pono varaa. Ono laka, Rupu Veaga velena na pene gitamu, e vealeva vega-namana gaura Mose na ekilagirato gelegelenai pono venia, pe taunilimalima pia ripa, goi ponama.” ");
INSERT INTO khz_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Na ia eagoto, vokala valina epiaato. Vovetaina gaurai Iesu vanuga taai ati maelaka-togato, a tanolearaimo etaluwai. Na taunilimalima kapu irauiraura na Iesu roe wageago-veniawai. ");
INSERT INTO khz_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Toma reketa gevanagito vou, Iesu Kaperanaumai maewaikuleto. Taunilimalima na valina gekamonagiato Iesu numai. ");
INSERT INTO khz_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gaura pakurai taunilimalima gutuma gelaka-kouto, numa aona gevega-vonuato, pene ago vanagi pokana maki ati pakana. Vonai vou Iesu na Vali Namana evopata-venirato, ");
INSERT INTO khz_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","aonai talima vativati (4) na tauniparana kavata ekwaregato talimana ta Iesu genai gevua-agoato. ");
INSERT INTO khz_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Taunilimalima gutuma gaurai, ati geria raupara Iesu laganai pia lakakavi-ago. Gaurai ira na Iesu erugato atana numa kinina gelovo-vagiato vou, viti rakava talimana magepana getugu-rigoato Iesu wailanai. ");
INSERT INTO khz_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu na geria kamonagi egitaato gaurai, ia na viti rakava talimana evaikilaato, netiwato, “Natuku, gemu rakava patugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Rova gevevega-ripagiawai talimara reketa vonai getanu-tagowai, aora evetaina getugamagito, ");
INSERT INTO khz_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Rakagau gaurana etalima vovetina ekilana? Ia na Palagu ekilagi-piatogaana. Rai na rakava pene tugamagi-piatogaa? Palagumo geregana!” ");
INSERT INTO khz_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesu ripana ira rakagau getugamagiawai gaurai, evaikilarato, netiwato, “Rakagau gaurana evetaina gotugamagina? ");
INSERT INTO khz_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Raka para kilatiwa malaga, viti rakava talimana para vaikilaa, ‘Gemu rakava patugamagi-piatogaa’ naparatiwa, pa para kila, ‘Ono rugaiti, gemu gepa ono gapia, ono laka’ naparatiwa? ");
INSERT INTO khz_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Au na ana vega-gitami, Taunilimalima Natuna magena rorirori, rakava pene tugamagi-piatogara etanoparai.” Ia na viti rakava talimana evaikilaato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Avaikilamuna, ono kuliiti, gemu gepa ono gapia, numai ono laka!” ");
INSERT INTO khz_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Rorirori erugaitito, gena gepa egapiato, taunilimalima wailara na elakatito. Gaura pakurai maparara gevevega-kali-rakavato, Palagu gevega-rageato, negetiwato, “Evetaina ta rogotina tara gitaa.” ");
INSERT INTO khz_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu maeagoto kovu pipinai. Taunilimalima gutuma ia genai geagoto, ne ia na evega-riparato. ");
INSERT INTO khz_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Iesu elaka-agowai aonai, ia na Alfia natuna arana Levi takiti monira gegapirawai numanai tanutago egitaato, ne evaikilaato, netiwato, “Muliku ai ono mai-lakakau.” Ne Levi ekuliitito, Iesu mulinai elakakauto. ");
INSERT INTO khz_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iesu Levi gena numai eganiganiwai aonai, takiti-koko talimara e kala rakava talimara gutuma maki Iesu magena melo ria geganigani-kouto, kwalana taunilimalima vogo ia mulinai gelakawai. ");
INSERT INTO khz_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Rova gevevega-ripagiawai talimara, Parisea geria kako talimara, na Iesu gegitaato, takiti-koko talimara e kala rakava talimara ria geganigani-kouwai, ne ira na Iesu gena melo gerenagirato, negetiwato, “Ia vorakagau gaurai takiti-koko e kala rakava talimara ria geganigani-koukouna?” ");
INSERT INTO khz_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu ekamonagito, ne evaikilarato, netiwato, “Nama talimara na toketa ati getavurana, na viti talimara namo. Au avogomaito maki ati kala rorirori talimara keakeara, na kala rakava talimara ularana.” ");
INSERT INTO khz_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Toma ta Ioane Bapatiso gena melo e Parisea talimara gevokawai aonai, talima reketa Iesu genai geagoto, ne gerenagiato, negetiwato, “Rakagau gaurai Ioane Bapatiso gena melo e Parisea talimara geria melo gevokana, na goi gemu melo aikina?” ");
INSERT INTO khz_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu na evega-gelerato, netiwato, “Gomi gotugamagina, vegarawa valigu tauna gatana lagarai etaluna aonai pia voka pa? Aikina! Vegarawa valigu tauna gatana lagarai aonai, ati pia voka. ");
INSERT INTO khz_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tomana evogomaina vegarawa valigu tauna gatana geriana pia gapi-gerevagia, vonai vou pia voka. ");
INSERT INTO khz_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Talima taa na rapuga valiguna kiata rapuga kunena goti ati pene vega-pani-koura. Pene vovetaina pene kala genai, rapuga valiguna na kunena pene ralea, e maki veralena pene kamu. ");
INSERT INTO khz_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Talima taa na vine nanuna valiguna nanikoti kopina kunenai ati pene wagi-rigoa. Pene vovetaina pene kala genai, vine nanuna valiguna na nanikoti kopina kunena pene rakagi-pakaa. Vine nanuna e kopi pia rakava. Na vine nanuna valiguna nanikoti kopina valigunai pene wagi-rigoa nama.” ");
INSERT INTO khz_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tapati taai Iesu magena melo ria vuiti aragara na gelaka-vanagiwai aonai, gena melo lakalakarai vuiti geralupi-vagirawai. ");
INSERT INTO khz_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisea talimara na Iesu gevaikilaato, negetiwato, “Ono gitara, ira rakagau gekalaana! Nevetaina ragai pia kala Tapati tomarai, rova.” ");
INSERT INTO khz_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iesu na evega-gelerato, netiwato, “Davida na rakagau ekalaato kilara goagiato pa aikina, ia mataukavana ria evitorato aonai? ");
INSERT INTO khz_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Palagu gena numai elaka-togato, Palagu wailanai getaorawai peretira egapirato, eganirato, taukavana maki evenirato. Vopereti maveagara vegata, Rupu Veaga velera geregariamo garia. Vokala Abiata Rupu Veaga velena kamuna gena lagani ai ewalato.” ");
INSERT INTO khz_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne Iesu na maevaikilarato, netiwato, “Palagu na Tapati ekalaato taunilimalima geria, ati taunilimalima ekalarato Tapati gena. ");
INSERT INTO khz_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Vovetaina gaurai Taunilimalima Natuna Tapati Velena.” ");
INSERT INTO khz_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Toma ta Iesu rupu ai maelaka-togato. Gima keve talimana ta vonai. ");
INSERT INTO khz_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Talima reketa maki vonai, Iesu gegita-tagoawai, Tapati tomanai votalima pene vega-namaa pa, pia gita-veakaua, pe pia rolia-agia negetiiwai gaurai. ");
INSERT INTO khz_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu na gima keve talimana evaikilaato, netiwato, “Ono rugaiti, talima maparara wailarai ono mai-ruga.” ");
INSERT INTO khz_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ne Iesu na erenagirato, netiwato, “Arigia rorirori, Tapati ai kala namara kalakalara nama pa kala rakavara patara kalara? Patara vevega-maguli pa patara vagivagi?” Na ira ati gekilakilato. ");
INSERT INTO khz_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iesu maparuna e aona mametauna na egita-gegelagirato, kwalana taunilimalima aora gaokaporo gaurai. Ne gima keve talimana evaikilaato, netiwato, “Gimamu ono tugu-roriroria.” Gimana etugu-roriroriato, ne enamato. ");
INSERT INTO khz_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Voia mulinai Parisea talimara rupu na gelaka-piatito, Heroda mulinai gelakawai talimara ria genavuga-kouto, Iesu raka pia vagi-kwarega-tiwaa rauparana getavuato. ");
INSERT INTO khz_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu magena melo ria gelaka-gerevagito, Galileia kovunai geagoto. Taunilimalima gutuma galagala vagi Galileia na ia mulina na geagoto, e vogo galagala vagi maki Iudea na, ");
INSERT INTO khz_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ierusalema na, Idumea na, Ioridana wai vokavana na, Taia e Sidona kavara na geagoto, kwalana Iesu valina gekamonagiato gaurai. ");
INSERT INTO khz_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Taunilimalima gutuma gaurai, Iesu na gena melo evaikilarato, gati keina ta pia gapi-maavua, taunilimalima gutuma irau na nege pekuana nea. ");
INSERT INTO khz_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iesu na viti talimara gutuma evega-namarato gaurai, viti talimara maparara maki gegoto-agoto, Iesu genai pia napakau ularana. ");
INSERT INTO khz_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Palagu rakavara na geporogirato talimara na ia gegitaato ne, wailanai geketo-talito, gekeato, negetiwato, “Goi nema Palagu Natuna!” ");
INSERT INTO khz_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Iesu na evaikila-taitalirato, ragai pia vega-matagaia ia voo rai. ");
INSERT INTO khz_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Voia mulinai Iesu golo ai everageto, ne eririwarato taura eve kearato, ia genai geagoto. ");
INSERT INTO khz_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Iesu na talima gagalana ruala evirigirato, ekilagirato apostolo talimara, ia pia kwarua. Ne mapene tugura, pia vopata, ");
INSERT INTO khz_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","e tiavu pia gapi, palagu rakavara pia gui-atira. ");
INSERT INTO khz_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Evirigirato talimara ea: Simona, arana valiguna ekeato Petero; ");
INSERT INTO khz_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Teimiti, Tepetaio natuna, matarina Ioane goti, araria valiguna evatoato, Boanere, ganina gaita natuna; ");
INSERT INTO khz_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anduru; Filipo; Batolomio; Mataio; Tomas; Teimiti, Alfia natuna; Tadio; Simona, Selote talimana; ");
INSERT INTO khz_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Iudas Isakariota, ia Iesu pene lewaa talimana. ");
INSERT INTO khz_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu numai maerageto. Taunilimalima gutuma para magetanukou-waito gaurai, ia magena melo ria ati garia ganigani rauparana. ");
INSERT INTO khz_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesu gena talima na valina gekamonagiato, gaurai gapiwaina geagoto, kwalana taunilimalima gekilato, “Ia pe kawaa!” negetiwato gaurai. ");
INSERT INTO khz_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Rova gevevega-ripagiawai talimara Ierusalema na gemarigoto, negetiwato, “Belsebul, palagu rakava geria vele, na ia eporogiato gaurai, palagu rakavara egui-atirana.” ");
INSERT INTO khz_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ne Iesu na ekea-mairato, parapore ai evaikilarato, netiwato, “Satani na Satani raka pene gui-atitiwaa? ");
INSERT INTO khz_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Pene kaomani ta pene kavaluga, matotauna pene vevagi genai, vokaomani ati pene ruga ripa. ");
INSERT INTO khz_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pene kwalu ta pene kavaluga, matotauna pene galama genai, vokwalu maki ati pene ruga ripa. ");
INSERT INTO khz_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pene Satani pene kavaluga, matotauna pene galama genai, ia ati pene ruga, na pene aiki. ");
INSERT INTO khz_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Talima taa na tiliga talimana gena numai ati pene laka-toga ripa, gena rinaga ati pene veraria ripa; votiliga talimana pene ligoligo-kunea vou, gena numa rinagara pene veraria. ");
INSERT INTO khz_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Taunatauna avaikilamina, taunilimalima rakava pia kala e Palagu pia kilagi-piatoga talimara geria rakava maparara Palagu na pene tugamagi-piatogara ripa. ");
INSERT INTO khz_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Na talima taa na Veaga Palaguna pene kilagi-piatogaa talimana, gena rakava ati pene tugamagi-piatogaa, vorakava pene mia-vanagivanagi.” ");
INSERT INTO khz_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu vovetaina ekilato, kwalana talima reketa gekilato, “Ia aonai palagu rakava” negetiwato gaurai. ");
INSERT INTO khz_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ne Iesu tinana e tarina gekwarato. Numa mulinai geruga-talito, gevetuguto, Iesu iave vaikilaa, iama vaikilaa ularana. ");
INSERT INTO khz_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ia taunilimalima gutuma na getanu-gegelagiato, ne gevaikilaato, negetiwato, “Goi tinamu e tarimu muli ai, goi getavumuna.” ");
INSERT INTO khz_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iesu na evega-gelerato, netiwati, “Au tinaku e au tariku raira?” ");
INSERT INTO khz_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ne getanu-gegelagiato talimara egitarato, evaikilarato, “Au tinaku e au tariku goi ea! ");
INSERT INTO khz_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Palagu gena ririwa gekalarana talimara au tariku e au walawalaku e au tinaku.” ");
INSERT INTO khz_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesu maeve vevega-ripa-waito Galileia kovuna pipinai. Taunilimalima gutuma para na magevetanu-gegelagiato gaurai, gati ai eragekauto, ne etanu-talito. Gati kiata geroli-atiato, a taunilimalima kovu pipinaimo getanu-levalevato. ");
INSERT INTO khz_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu na gau vovogo evega-riparato parapore ai. Ia gena vevega-ripa aonai netiwato, ");
INSERT INTO khz_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Iokamonagi! Araga talimana ta eagoto, gena vuiti uvera peneve piara ularana. ");
INSERT INTO khz_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Epiarawai aonai, reketa rauparai geketo-talito. Ne manu geraumaito, geganirato. ");
INSERT INTO khz_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Reketa vatu kapurai geketokauto kwano magivinai. Atilovana getupu-rageto, kwalana kwano atanaimo. ");
INSERT INTO khz_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ne garo erageto aonai, ira gemalaito, kwalana lamura ati geverigo-namato gaurai, atilovana gekwaregato. ");
INSERT INTO khz_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Reketa gawa vekalavekala aorai geketoto. Ne gawa vekalavekala getupu-kamuto, varovaro gaura gekala-gavurato e gegunigavurato gaurai, ati gevuato. ");
INSERT INTO khz_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Reketa kwano namanai geketo-talito, gaurai getupu-namanamato, gekamuto, gevuato, reketara vuara gagala toitoi (30), reketai gagala taulatoitoi (60), reketai tinavu kwapuna (100).” ");
INSERT INTO khz_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne Iesu ekilato, “Mategana talimana pene kamonagi!” ");
INSERT INTO khz_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesu gereganamo aonai, gena melo gagalana ruala e ia mulinai gelakawai talimara reketa ia laganai ruga-gegelagi, ne parapore ganira geverenagi-agirato. ");
INSERT INTO khz_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu na evaikilarato, netiwato, “Palagu gena Basileia kilara veavugara gomi gemi ai matagai, na mulimuli talimara parapore ai avaikilarana, kwalana, ");
INSERT INTO khz_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Pia gitaa, na ganina ati pia ripaa, pia kamonagia, na ati pia tugamagi-ripa, pia vetugamagi-waikule Palagu genai, ne geria rakava netugamagi-piatogarana kalirana.’” ");
INSERT INTO khz_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne Iesu na maevaikilarato, netiwato, “Eparapore ganina ati goripaana genai, maparapore reketa raka pio ripa-tiwara? ");
INSERT INTO khz_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Araga talimana na Palagu gena kila epiaana. ");
INSERT INTO khz_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Talima reketa vuiti uvera rauparai geketona vetaina. Kila gekamonagiana aonai, Satani na veganamo egapi-vagirana. ");
INSERT INTO khz_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Talima reketara vuiti uvera vatu ai geketona vetaira. Kila gekamonagiana aonai, mavererera na gegapi-rageana. ");
INSERT INTO khz_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na kila talima aorai ati gemia-talina gaurai, ati gemia-rauna. Palagu gena kila pakunai, lagani rakavara gerawalirana, e gegolorana, pa viti gevuana tomarai ia genana gelaka-gerevagina. ");
INSERT INTO khz_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Talima reketa vuiti uvera gawa vekalavekala aorai gepiarana vetaina. Palagu gena kila gekamonagiana, ");
INSERT INTO khz_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","na tanopara gaura tugamagira na, tanopara rinagara getugamagi-kokokorana, e geria ririwa gaura reketara na Palagu gena kila gegunigavuana, gaurai Palagu gena kila ira geriai ati vuavuara. ");
INSERT INTO khz_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Talima reketa vuiti uvera kwano namanai gepiarana vetaina. Kila gekamonagiana, gegapi-rageana, ganira gevekalana reketaraina gagala toitoi, reketaraina gagala taula toitoi, reketaraina tinavu kwapuna.” ");
INSERT INTO khz_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu na maevaikilarato, netiwato, “Talima ta lamepa pene kapua genai, gulo na pene koutalia pa pata kapulenai pene taoa? Aikina, taotaona patanai pene tao-kaua. ");
INSERT INTO khz_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Veavuga gaura maparara pia matagai, gekou-gavurato gaura maparara pia gapi-gerevagira. ");
INSERT INTO khz_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mategana talimana pene kamonagi!” ");
INSERT INTO khz_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesu na maevaikilarato, netiwato, “Pio kamonagira kilara pio tugamagi-kinikaura. Gemi kamonagi vetairai Palagu na ripa e tugamagi-ilu pene venimi. Tugamagi-ilu reketa mapene tao-kaura. ");
INSERT INTO khz_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Magena kamonagi talimana tugamagi-ilu pene venia, ati gena kamonagi talimana, gena tugamagi-ilu keina maki pene gapi-vagia.” ");
INSERT INTO khz_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesu maekilato, “Palagu gena Basileia noowane talima ta, vuiti uvera kwano ai epiarana vetaina. ");
INSERT INTO khz_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ia pogi aina emaituna, e lagani aina ekuliitina aonai, vovuiti uvera gekalana, ia ati ripana raka gekala-tiwana. ");
INSERT INTO khz_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kwano matotauna na ganina evega-walaana. Korina etao-kuneana, kapinai pekana, voia mulinai ganina etaoana peka aonai. ");
INSERT INTO khz_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ganina pene kili aonai, pene patia, kwalana patipati tomana pekwara.” ");
INSERT INTO khz_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesu everenagito, netiwato, “Palagu gena Basileia rakagau genai pita vega-gelegelea? Arigi parapore na pene vega-matagaia? ");
INSERT INTO khz_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ia mastadi gautupuna gutuna ta vetaina, tanoparai varovaro uvera maparara nuganugarai ia geregana kei galagala vagi kwano ai gevaroana. ");
INSERT INTO khz_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na kwano ai gevaroana aonai, evekala-ragena, varovaro gaura maparara nuganugarai iamo kamu iwavagi. Ia ragana maki kamura etugurana. Vonai manu raurau ia lukuna avuganai genuguvina.” ");
INSERT INTO khz_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Vovetaina gelegelena paraporera ati kwapunamo ai Iesu na Palagu gena kila evopata-venirawai, ira geria ripa e tugamagi-ilu gelegelerai. ");
INSERT INTO khz_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Gena vopatai parapore ati eraokwanirawai, na gena melomo geregari ai vou, kila ganira maparara evega-matagairawai. ");
INSERT INTO khz_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Volavilavi Iesu na gena melo evaikilarato, netiwato, “Ita ravu-vanagi, kovu vokavai.” ");
INSERT INTO khz_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ne votaunilimalima gutuma geraokwanirato, gena melo na gekwaruato Iesu etanu-tagowai gatinai, ne geravuto. Gati reketa maki ira ria. ");
INSERT INTO khz_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Agi kamu vagi ekwaragiato e aku kakamu gati aonai gevepopo-rigowai, gati maki roli epuluwai. ");
INSERT INTO khz_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu gati kwalunai evekuneto emaituwai. Gena melo na gevagoato, negetiwato, “Vevega-ripa talimamu o, goi ati okalina? Ita tapuluna!” ");
INSERT INTO khz_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ne Iesu ekuliitito, agi ekila-waiato e aku evaikilaato, “Ono aiki, ono rawaa.” Ne agi eaikito e erawa-taliato, ekawalagiato. ");
INSERT INTO khz_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iesu na gena melo evaikilarato, netiwato, “Rakagau gaurai gokalina? Gomi roe nea ati gemi kamonagi?” ");
INSERT INTO khz_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ira gekali-rakavarakavato, ne matotaura geverenagi-verenagito, negetiwato, “Goi eraka talima ta? Agi e aku na maki karona gekamonagiana!” ");
INSERT INTO khz_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kovu kavatai gevevanagito Gerasa (pa Gadara) talimara geria kapu ai. ");
INSERT INTO khz_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesu gati na erigowai aonai, palagu rakavana na eporogiato talimana ta kala kapuna na evogomaiwai Iesu genai. ");
INSERT INTO khz_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ia kala kovogarai etaluwai. Taunilimalima ia ligoligonai geraga-manukouto, teini maki ia genai ati gaoka. ");
INSERT INTO khz_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Vega-vogo gagena e gimana teini na geligorawai, na teini etapu-iturawai, e gagenai auri gaura maki epere-kinikinirawai. Ia tiliga vagi, talima taa na maki ati pene vega-maranaa ripa. ");
INSERT INTO khz_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pogi e lagani ia kalai e golo kukurai ekogowai e matotauna maki vatu na evevorowai. ");
INSERT INTO khz_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ia na Iesu rau ai egitaato, eraka-agoto, wailanai eketo-talito, ");
INSERT INTO khz_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ekogo-lailaito, “Iesu o, Goloka Iwa Palaguna Natuna, rakagau au geku ai ono kalaa notina? Palagu aranai anogimuna, ragai pono vega-vitivitiku.” ");
INSERT INTO khz_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ia vovetaina ekilato, kwalana Iesu na evaikilaato, netiwato, “Palagu rakavamu, ne talima genana ono lakati!” ");
INSERT INTO khz_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ne Iesu na erenagiato, netiwato, “Goi aramu rai?” Ia evega-geleto, netiwato, “Au araku ‘Vetali Talimara Gutuma,’ kwalana ai vovogo.” ");
INSERT INTO khz_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ia na Iesu enogi-vigirageato, vokapu na ragai pene gui-atira. ");
INSERT INTO khz_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Vonai pae lavetana golo kapanai geunaunawai. ");
INSERT INTO khz_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Vovetaina gaurai palagu rakavara na Iesu genogiato, negetiwato, “Ono tugumai pae geriai, ira aorai aia laka-toga.” ");
INSERT INTO khz_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Iesu na etugu-agorato. Ne palagu rakavara votalima aonana gelakatito, pae aorai gelaka-togato. Ne ropa-kareketo na geraka-ralupito, kovu ai gevegugututo. Vopae lavetana aonai pae maparara ragana ruala (2,000) vetaina. ");
INSERT INTO khz_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pae gitatagora talimara gerakato, vovali geve piaato vanuga kamuna aonai e vanuga keirai. Taunilimalima gelaka-piatito, geagoto vorakagau ewalato gauna gitagitana. ");
INSERT INTO khz_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iesu genai gekwarato aonai, ira na votalima palagu rakavara gutuma na geporogiato talimana gegitaato, marapugana e gena tugamagi maki rorirori etanu-tagowai, ne ira maparara gekalito. ");
INSERT INTO khz_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Vokala gewalato, gegitarato talimara na palagu rakavara na geporogiato talimana valina, e pae valira, taunilimalima gevararato. ");
INSERT INTO khz_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne ira na Iesu genogiato, geria tano na pene laka-gerevagi. ");
INSERT INTO khz_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu gati ai eragekauwai aonai, palagu rakavara genana gelakatito talimana na enogiato, ia goti pia laka netiwato. ");
INSERT INTO khz_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Na Iesu na evaikilaato, netiwato, “Ono waikule numai e gemu numa talimara geriai. Ne pono vevaikilara, Palagu na gemu ai rakagau pekalaa e gena venugagiviti gemu ai pewala gauna.” ");
INSERT INTO khz_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ne ia elakato Vanuga Gagalana (10) tanorai, evevaravarato, rakagau Iesu na ia genai ekalaato. Ne taunilimalima maparara gevevega-kali-rakavato. ");
INSERT INTO khz_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu gati na maewaikuleto kovu kavatai. Kovu pipinai taunilimalima gutuma para na magevegalu-kanaato. ");
INSERT INTO khz_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Rupu gitatagona talimana ta arana Iairo eagoto, Iesu egitaato aonai, gagena kwalanai etiu-talito, ");
INSERT INTO khz_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","maaona maparana na enogiato, “Au natuku vavinena peviti-rakavaa, roli ekwaregana. Gemu kala, ono vogomai, gimamu atanai pono tao-kaua, pe natuku pene nama!” ");
INSERT INTO khz_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ne Iesu ia goti geagowai aonai, taunilimalima gutuma para maki gegotokauto, ira na gelaka-piipipiawai. ");
INSERT INTO khz_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vonai gare ta, gena viti rala vitina, rigolo gagalana ruala eviti-agiato. ");
INSERT INTO khz_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Toketa vogo na mulaga geveniawai, na ati enamawai. Gena moni maparara evega-aikirato, ene nama ularana, na ati enamawai, gena vitimo emetau-agowai. ");
INSERT INTO khz_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ia na Iesu valina ekamonagiato gaurai evogomaito, taunilimalima gutuma nuganugara na evepipi-vanagito neamo Iesu mulinai evekwarato, ne gena rapugai evegapikauto. ");
INSERT INTO khz_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kwalana ia etugamagito, “Gena rapugaimo pana vegapikau genai pana nama.” ");
INSERT INTO khz_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ne rala vitina eikato, tauniparana emamilagiato gena viti warau eaikito. ");
INSERT INTO khz_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Veganamo Iesu eripato, ia genana tiavu elaka-vagito. Ne taunilimalima gutuma aora na eruga-kuleto, everenagito, netiwato, “Rai na au geku rapuga pegapi-kaulagia?” ");
INSERT INTO khz_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Gena melo gevega-geleto, negetiwato, “Ono gita, etaunilimalima gutuma na gepekuvomuna, rakagau maoverenagi-agiana, notina, ‘Rai na pegapi-kaulagiku?’” ");
INSERT INTO khz_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na Iesu roe waepoevopoevowai, egapi-kaulagiato talimana egita-vetavuawai. ");
INSERT INTO khz_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Vogare eripa-rorirorito rakagau genai ewalato, ne makalina e mapilupiluna Iesu gagena kwalanai evetiu-talito, ne rakagau ewalato gauna maparana ekilagi-matagaiato. ");
INSERT INTO khz_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu na vogare evaikilaato, netiwato, “Natuku, gemu kamonagi na pevega-namamu. Gaurana, mavereremu ono laka, gemu viti peaiki-vagi.” ");
INSERT INTO khz_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu roe waekilakilawai aonai, rupu gitatagona tauna Iairo gena numa na talima reketa gevogomaito, Iairo gevaikilaato, negetiwato, “Natumu pekwarega. Vevega-ripa talimana ragai ono vega-vekwalavia.” ");
INSERT INTO khz_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu na vokila ekamonagi-guilagiato, ne rupu gitatagona talimana evaikilaato, netiwato, “Ragai pono kali, pono kamonagimo.” ");
INSERT INTO khz_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ne Iesu na maparara ekila-wairato, mulina na ragai pia ago, na Petero, e Teimiti, matarina Ioanemo ia ria pia ago. ");
INSERT INTO khz_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iairo gena numai gekwarato, ne Iesu na taunilimalima egitarato, gekogowai e getagi-kilakilawai. ");
INSERT INTO khz_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ne Iesu numai elaka-togato, evaikilarato, netiwato, “Rakagau gaurai gokogona e gotagina? Vavine ati pekwarega, ia emaituna.” ");
INSERT INTO khz_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na taunilimalima na gemamai-agiato. Ne Iesu na etugu-atirato, ne vavine tamana e tinana e ia gekwaruato talimara toitoi riamo vavine gevega-maokoato kapunai gelaka-togato. ");
INSERT INTO khz_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ne Iesu na vavine gimanai egapito, evaikilaato, netiwato, “Talita kumi!” Vokila ganina “Vavine, au na goi avaikilamuna, ono kuliiti!” ");
INSERT INTO khz_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ne vavine veganamo ekuliitito, eloulouto. Ia gena rigolo gagalana ruala. Ekala ewalato genai, taunilimalima gevevega-kali-rakavato. ");
INSERT INTO khz_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu na evaikilarato, ekala valina ragaina vagi pia kilagia netiwato, e evaikilarato, vovavine pia gupua. ");
INSERT INTO khz_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu na vokapu eraokwaniato, ne gena vanugai eagoto; ia gena melo maki mulina na geagoto. ");
INSERT INTO khz_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tapati tomanai Iesu rupu ai maevevega-ripato, taunilimalima gutuma na gekamonagiato aonai, gevevega-kali-rakavato, negetiwato, “Etalima eripa e ariginai egapito? Gena tugamagi-ilu maki rai na eveniato? Ekala irau vagi kalara raka ekala-tiwarana gimana na? ");
INSERT INTO khz_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ia ati kapenta talimana? Maria natuna; Teimiti, e Iosepa, e Iudas, e Simona kakaria, e walawalana maki lagarai getaluna ea.” Gaurai ati gevega-taunataunaawai. ");
INSERT INTO khz_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu na evaikilarato, netiwato, “Peroveta talimana ia kapu mapararai pia kupa-ragea, na gena vanuga kwalanai, gena talimana, e gena numa talimara, namo ati pia kupa-ragea.” ");
INSERT INTO khz_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Vonai ia na kala irau vagira ati ekalato, na viti talimara kwapurakwapuramo atarai gimana etao-kauato, evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iesu eaovoaovo-rakavato, kwalana ati geria kamonagi gaurai. Ne Iesu maelakato, eagoto vanuga reketai maeve vevega-ripawai. ");
INSERT INTO khz_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na Iesu na gena melo gagalana ruala ekearato, ne rualana rualana etugurato, e tiavu evenirato, palagu rakavara pia gui-atira ularana. ");
INSERT INTO khz_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iesu na evega-nagirato, “Gau kwauta ragai pio gapi-kaua gemi lakalakai, tokimo. Potega, ganigani gaura e moni maki ragai pio vuakau. ");
INSERT INTO khz_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamaka pio kala, na tiati ruala ragai pio rogagi.” ");
INSERT INTO khz_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Maevaikilarato, netiwato, “Numa taai pio rage genai, vonumaimo pio talu, pene ago, vovanuga pio raokwania. ");
INSERT INTO khz_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pene vanuga taai ati pia gapi-ragemi e karomi ati pia kamonagira genai, pio raokwania, gagemi kavuramo pio kwara-vagira ira geria kila-tilivagi vega-taunataunara ularana.” ");
INSERT INTO khz_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ne gelakato, gevevopatato, taunilimalima geria rakava na pia vetugamagi-waikule e pia laka-waikule ulanana. ");
INSERT INTO khz_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Palagu rakavara vovogo taunilimalima geriana gegui-atirato, viti talimara gutuma maki riga na geirurato, gevega-namarato. ");
INSERT INTO khz_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Heroda, Galileia velena, na ekala valira evekamonagirato, kwalana Iesu arana kapu mapararanai eraka-lovolovoto. Taunilimalima reketa gekilato, “Ioane Bapatiso kwarega na mapekuliiti-wai. Gaura pakurai ekala kamura maparara evega-matagairana.” ");
INSERT INTO khz_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mareketa gekilato, “E Elia,” mareketa gekilato, “E Peroveta talimana ta, peroveta talimara kunera vetaira.” ");
INSERT INTO khz_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na Heroda ekamonagito aonai, ekilato, “E Ioane Bapatiso, au na repana alama-vagiato talimana, kwarega na mapekuliiti-wai!” ");
INSERT INTO khz_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kwalana Heroda matotauna evetuguto, Ioane gevegapi-taliato, ne geligoligoato tipura numanai, gekana-gavuato. Vokala ekalaato, kwalana etavarariato garena Herodia, ia kakana Filipo garawana, pene vega-vererea ulanana. ");
INSERT INTO khz_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ioane na Heroda evaikilaawai, netiwato, “Goi na kakamu garawana potavararia ne ati rorirori!” ");
INSERT INTO khz_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Vovetaina gaurai Herodia na Ioane eparu-veniato, gena ririwa pene vagia, na ati gena raupara, ");
INSERT INTO khz_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kwalana Heroda Ioane kalinana ekaliwai e egita-tagoawai. Heroda ripana Ioane rorirori vagi e veaga talimana. Ioane karona ekamonagiato aonai, eaovoaovowai, na eririwato pene kamonagi-venia. ");
INSERT INTO khz_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodia gena toma namana ta ekwarato. Heroda gena wala tomana e tugamagi-tagona velekwana ekalaato, gena vekuneagi talimara kamura, e vetali kuneagina talimara, e Galileia vanugarai vekuneagi talimara ekearato. ");
INSERT INTO khz_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia natuna vavinena ema laka-togato, ne epalato aonai, Heroda magena wariwari talimara maparara evega-verererato. Ne Heroda na vovavine evaikilaato, netiwato, “Goi rakagau oririwana gauna ono kilagia, pana venimu.” ");
INSERT INTO khz_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ne evaikilaato, netiwato, “Rakagau pono nogiku gauna pana venimu, geku Basileia kavata pono nogiku maki pana venimu.” ");
INSERT INTO khz_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ne elaka-piatito, tinana erenagiato, netiwato, “Rakagau napanatiwa?” Tinana evega-geleto, netiwato, “Ioane Bapatiso repana, noponotiwa!” ");
INSERT INTO khz_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ne vovavine maeraka-waikuleto, vele kamuna Heroda enogiato, netiwato, “Au aririwana ewagumonamo vegata Ioane Bapatiso repana rivu ai onoma veniku.” ");
INSERT INTO khz_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Vele kamuna evetugamagi-waikuleto, na ati eririwato karona pene lekwaa, kwalana gena wariwari talimara wailarai ekila-gavuato gaurai. ");
INSERT INTO khz_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Rorirori vele kamuna Heroda talima repara epati-vagirawai talimana ta etuguato, Ioane repana pene vuamaia. Ne ia eagoto, Ioane Bapatiso tipura numanai repana epati-vagiato. ");
INSERT INTO khz_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ne rivu aonai evua-agoato, vovavine eve veniato. Ia na tinana eveniato. ");
INSERT INTO khz_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ioane gena melo na vovali gekamonagiato, geagoto, tauniparana geve gapiato, ne kala kapunai geve toleato. ");
INSERT INTO khz_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apostolo talimara gewaikuleto Iesu genai, ne rakagau gekalato e gevevega-ripagirato gaura maparara gekaro-varaato. ");
INSERT INTO khz_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iesu na evaikilarato, netiwato, “Tanopakana taai ita wati, kiata ioagalagi.” Kwalana taunilimalima gutuma gevogomaiwai e eanana geagowai, pe ira maki ati gelegele pia agalagi pa pia ganigani. ");
INSERT INTO khz_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Gaurai maparara gati taai geragekauto, tanopakana taai geagoto. ");
INSERT INTO khz_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na taunilimalima gutuma na gegitarato, gelakawai, veganamo geripato ira voo raira. Ne vanuga gaura gaura taunilimalima maparara gagera na gelaka-rakaraka-agoto, vokapu ai gevekwara-kuneto. ");
INSERT INTO khz_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu kone ai etoga-rigoto aonai, taunilimalima gutuma para egitarato gaurana egita-vetugarato, kwalana ira noowane mamoe ati gitatagora talimana ta vetaira. Ne ia na gau vogo evega-riparato. ");
INSERT INTO khz_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Elaviawai gaurai, Iesu gena melo ia genai geagoto, ne gevaikilaato, “E tanopakana e garo maki waeverigona. ");
INSERT INTO khz_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ono tugura, araga kala talimara geria talu kapurai e vanuga kavinagirai ia ago, pe garia ganigani iave voi.” ");
INSERT INTO khz_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Na Iesu na evega-gelerato, netiwato, “Gomi na garia iovenira.” Ne ira na gerenagiato, negetiwato, “Goi oririwana aia ago, pereti siliva monira tinavu ruala (200) na aia voira, ne paiama gupura notina?” (E talima ta voina uve taula vativati (8) aorai pene gapia vetaina). ");
INSERT INTO khz_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu na evaikilarato, netiwato, “Gomi gemi ai pereti ne vira nea? Ioago, iove gitara.” Geve gitarato, ne gekilato, “Pereti imaima e magani ruala.” ");
INSERT INTO khz_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iesu na melo evaikilarato, taunilimalima pia warera, gole ai gawa atarai pia tanutanu-tali. ");
INSERT INTO khz_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne golea rorirai getanuto, taarana tinavu kwapura (100), taarana gagala imaimara (50). ");
INSERT INTO khz_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ne Iesu na vopereti imaima e magani ruala egapirato, epoe-rageto, kupa egitaato, Palagu evega-namaato vou, epuki-kinikinirato, ne gena melo evenirato pia warera ularana. Magani ruala maki vovetaina epuki-kinikinirato. ");
INSERT INTO khz_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Maparara gegani-kwaregato. ");
INSERT INTO khz_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mulinai Iesu gena melo na pereti kovara e magani kovara maparara gekoko-koukourato, papalu gagalana ruala gevega-vonurato. ");
INSERT INTO khz_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Geganiganito marumaruramo maparara ragana imaima 5,000. ");
INSERT INTO khz_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Roirori Iesu na gena melo evaikilarato, gati ai pia ragekau, pia kune, kovu kavatai Betesaidai pia vevanagi netiwato. Na ia votaunilimalima gutuma roe waetugu-lovolovorawai. ");
INSERT INTO khz_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ne etugu-lovolovorato mulinai, golo ai everageto ene rapali. ");
INSERT INTO khz_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ewamuna-wamunaawai aonai, gati kovu nuganuganai, na Iesu geregana kwano ai. ");
INSERT INTO khz_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ne gena melo egitarato, gevekwalavi-rakavawai pako ai, kwalana agi wailara na egavumaiwai. Ne Iesu geriai elaka-agowai nanu atana na, gati pene laka-vanagia netiwato. Oragauna 3 e 6 koloko vepakanai rapa kavanai. ");
INSERT INTO khz_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ne gena melo na gegitaato, nanu atanai elakawai, getugamagito, negetiwato, “Avuavu kwapuna!” negetiwato. Ne gelailai-vegalapoluto, ");
INSERT INTO khz_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kwalana maparara na gegitaato e gekali-rakavato. Na Iesu na eraka-vaikilarato, netiwato, “Iotiliga, e au; ragai iokali!” ");
INSERT INTO khz_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ne gati ai eragekauto, e agi maki eaikito. Gena melo gevevega-kali-rakavato, ");
INSERT INTO khz_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kwalana vopereti evega-vogorato kala irau vagi kalana ganina rogoti gere tugamagi rawalia, aoria vekanagavu roe voa. ");
INSERT INTO khz_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ne gati na gevanagito kovu kavatai, Genesareta tanonai gekwarato. Geria gati vonai gekwatu-kauato. ");
INSERT INTO khz_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ne gati na gerigoto aonai, taunilimalima veganamo gegitailiaato, geripato voo Iesu. ");
INSERT INTO khz_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ne votano maparana gelaka-iluiluato, gaurana geria viti talimara magepara Iesu ariginai gekamonagiawai kapurai gevua-agorawai. ");
INSERT INTO khz_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesu na eago-venirawai kapura mapararai, vanuga kamurai, vanuga keirai, araga kala talimara geria talu kapurai, geria viti talimara maketi kapurai getaorawai, ne genogiawai, gena rapuga rikinaimo maki pia gapikau. Gegapikauwai talimara genamawai e gemaguliwai. ");
INSERT INTO khz_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisea talimara e rova gevevega-ripagiawai talimara reketa Ierusalema na gevogomaito, Iesu getanu-gegelagiato. ");
INSERT INTO khz_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ne gena melo gegitarato, geganiganiwai reketa gimara “mamilora,” gimara ati geguligirato ira geria gulukune velera geria vevega-nagi vetainai. ");
INSERT INTO khz_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pio ripa, Parisea talimara e Iuda talimara maparara rogoti gere ganigani aonai, gimara pia guligira mulinai vou pia ganigani. Eia e ira geria gulukune velera na gevega-taunataunaato e gekalagi-maiawai kalana. ");
INSERT INTO khz_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maketi kapura na pia vogomai maki rogoti gere ganigani aonai, pia veguligi-kune vou. Gulukune geria vevega-nagi vovogo reketa maki gekwalanarawai, kaputi guligi, gulo, ketolo e gepa maki geguligirawai. ");
INSERT INTO khz_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Vovetaina gaurai Parisea talimara e rova gevevega-ripagiawai talimara na Iesu gerenagiato, negetiwato, “Rakagau gaurai gemu melo na gera gulukune velera geria vevega-nagi ati gekwalanarana, gimara ‘mamilora’ geganiganina?” ");
INSERT INTO khz_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu na evega-gelerato, netiwato, “Isaia na eperovetagimito opakau talimami taunatauna, evetaina ekilato, ‘Egulu na murura tinatinaraimo au gekupa-kaukuna geria Palagu, na ira aora au geku ai rauvagi ai. ");
INSERT INTO khz_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gealiruputali-veni-kawakuna, geria vevega-ripa taunilimalima geria vevega-nagi rovara, na ati au geku!’ ");
INSERT INTO khz_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gomi na Palagu gena rova goraokwanirana, na taunilimalima geria vevega-nagi gokwalanarana.” ");
INSERT INTO khz_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iesu na maevaikilarato, “Taunatauna, gomi na Palagu gena rova gotugamagi-piatogarana, matotaumi gemi vevega-nagi pio kwalanara ularana. ");
INSERT INTO khz_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mose ekilato, ‘Tamami e tinami pio nugagi-ragera. Rai na tamana pa tinana kila rakavara eveniana talimana pio vagi-kwaregaa.’ ");
INSERT INTO khz_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Na gomi gokilana, talima taa na tamana pa tinana pene vaikilaa, nepenetiwa, ‘Au na gomi ati pana veakavami, kwalana para venimi gauna au na Koban aveniana gaurai.’ Koban ganina Palagu gena. ");
INSERT INTO khz_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Vokalana gomi na talima gokouana, tamana e tinana ragaina pene veakavara ularana. ");
INSERT INTO khz_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gomi na gemi gulukune geria vevega-nagi geriana Palagu gena kila ati ganiraimo govega-agorana. Gau vogo vovetaina gokalarana.” ");
INSERT INTO khz_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ne Iesu na taunilimalima gutuma ekea-koukourato ia genai, ne evaikilarato, netiwato, “Maparami iokamonagi e pio ripa-rorirori. ");
INSERT INTO khz_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Taunilimalima na geganirana, geverigona talima aorai, gaura na talima ati gevega-rakavarana, na taunilimalima aora pa nugara garakaura na gemaragena gaura na vou taunilimalima gevega-rakavarana.  ");
INSERT INTO khz_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mategana talimana pene kamonagi!” ");
INSERT INTO khz_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu na taunilimalima gutuma eraokwanirato, numai erageto; ne gena melo na voparapore ganina geverenagi-agiato. ");
INSERT INTO khz_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesu na evaikilarato, netiwato, “Gomi maki ati gotugamagi-iluna? Ati goripana, mulina geverigona gaura na taunilimalima ati gevega-rakvarana? ");
INSERT INTO khz_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kwalana voia ati nugana na geverigona, na tinagena na geverigona, pe geagonamo.” Voia ganina, ia na ganigani maparara evega-taunataunarato, ati geria rakava. ");
INSERT INTO khz_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ne maekilato, “Rakagau taunilimalima nugana na emaragena, voanana taunilimalima evega-rakavarana, ");
INSERT INTO khz_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kwalana talima nugana na tugamagi rakavara, tuga kalara, lema, vagivagi, ");
INSERT INTO khz_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","veopa-lema, ririwamagi rakavara, kala rakavara maparara, opakau, mata-poraga, vepiagikau, velivu, veagi, kala kawakawa gevogomaina. ");
INSERT INTO khz_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Maparara gau rakavara, eira nugana na gemaragena, talima gevega-rakavarana.” ");
INSERT INTO khz_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu voanana ekuliitito, Taia e Sidona tanorai eagoto. Ne numa gautai eve ragekau-garito, ia ati eririwato talima taa na pene ripaa ia vonai, na ati gena veavuga rauparana. ");
INSERT INTO khz_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gare ta, natuna vavinena palagu rakavana na eporogiato, Iesu valina ekamonagiato gaurai, eagoto, gagena kwalanai evetiu-talito. ");
INSERT INTO khz_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vogare ia Grik garena, Siriafonesia ai ewalato. Ne ia na Iesu enogiato, vopalagu rakavana natuna vavinena genana pene gui-atia ");
INSERT INTO khz_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na Iesu na evaikilaato, netiwato, “Melo keira pia ganimate-kune vou, kwalana ati gelegele, melo keira garia ganigani pita gapira, kwaeva pita pia venira.” ");
INSERT INTO khz_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Gare na evega-geleato, netiwato, “Velekou, neia ne taunatauna, na kwaeva maki pata kapulenai melo keira geganiganina momora geganirana.” ");
INSERT INTO khz_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Gaurai ia na vogare evaikilaato, netiwto, “Nevetaina povega-gele pakunai, ono waikule, palagu rakavana natumu genana pelakati.” ");
INSERT INTO khz_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ne vogare ewaikuleto gena numai aonai, natuna vavinena everawaliato, gena gepai emaoko-tagowai egitaato, palagu rakavana taunatauna elakatito. ");
INSERT INTO khz_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ne Iesu Taia tanona eraokwaniato, Sidona e Vanuga Gagalana (10) tanora elaka-vanagirato, Galileia kovunai ekwarato. ");
INSERT INTO khz_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne talima reketara na tega-gela e eaga-raurauwai talimana ta gegapi-agoato, ne genogiato, gimana atanai pene tao-kaua. ");
INSERT INTO khz_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ne Iesu na taunilimalima gutuma aora na evaigerevagiato, ririna tegana kovogarai egoto-togarato, ekainiuto, e maena egapi-kaulagiato. ");
INSERT INTO khz_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kupai epoe-rageto, eaga-rageto malailaina na, netiwato, “Efata!” ganina “Ono vekala-paka!” ");
INSERT INTO khz_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ne tegana gevekala-pakato, maena evelugato, erorirorito, ne ekila-namanamato. ");
INSERT INTO khz_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu na evaikilarato, talima ta ragai pia varaa, na evaikilarawai kilara ati gekamonagirawai, ia valina gepia-lovolovoawai. ");
INSERT INTO khz_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Taunilimalima gevevega-kali-rakavato, gekilato, “Ia na gau maparara ekala-gitakaurana, tega-gela talimara eveakamonagirana, muru-kawa taura evega-kilakilarana.” ");
INSERT INTO khz_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Volaganinai taunilimalima gutuma para magetanukou-waito. Ira ati garia gauganigani gaurai, Iesu na gena melo ekea-kavirato laganai, ne evakilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Au na etaunilimalima avetugarana, kwalana toma toitoi vegata au ria enai pege talu, e gau kwauta maki rogoti na gere gania. ");
INSERT INTO khz_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pene au na pana tugu-waikulera geria vanugai mavitora genai, rauparai neeporimarana, kwalana reketa kapu rau vagina gevogomaito gaurai.” ");
INSERT INTO khz_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ne gena melo na gevega-geleato, negetiwato, “Arigi rauparai rai talima na etaunilimalima pereti na pene gupura etanoleanai?” ");
INSERT INTO khz_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ne Iesu na erenagirato, netiwato, “Gomi gemi ai pereti nee vira?” Ira gevega-geleto, negetiwato, “Taulatoi kwapuna (7).” ");
INSERT INTO khz_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iesu na gutuma evaikilarato, kwano ai ia tanutanu-tali. Ne pereti taulatoi kwapuna egapirato, Palagu evega-namaato, epuki-kinikinirato, gena melo evenirato, taunilimalima wailarai pia taotao-talira ularana. Ne vetainai gekalarato. ");
INSERT INTO khz_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ira geriai maki magani girigiri reketa. Iesu na Palagu maevega-namaato, gena melo evaikilarato, voira maki ia warera. ");
INSERT INTO khz_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ne taunilimalima gegani-kwaregato mulinai, Iesu gena melo na ganigani kovara gekokorato, papalu taulatoi kwapuna gevega-vonurato. ");
INSERT INTO khz_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Taunilimalima maparara ragana vativati (4,000) vetaira. Ne Iesu na etugu-lovolovorato, ");
INSERT INTO khz_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ia magena melo ria gati ai geragekauto, Dalmanuta tanonai geagoto. ");
INSERT INTO khz_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisea talimara reketa Iesu genai geagoto, ne gerenagi-opakauato. Geria ririwa vegailia ta kupa na pene mairigo. ");
INSERT INTO khz_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu eaga-raurauto maaona metauna na, netiwato, “Rakagau gaurai toma gulu talimara na vegailia kamura gegita-vetavurana? Taunatauna avaikilamina, vegailia ta ati vagi pana venimi!” ");
INSERT INTO khz_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ne eraokwanirato, gati ai eragekauto, kovu kavatai eve vanagito. ");
INSERT INTO khz_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iesu gena melo gevetugamagi-lekwalekwato, ganigani ati gegapikauto, pereti kwapunamo gati ai. ");
INSERT INTO khz_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ne Iesu na egavu-tinarato, netiwato, “Rogomi pio vetole, Parisea talimara e Heroda garia paraoa egoro-agiana mulamulana kalinana.” ");
INSERT INTO khz_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ne vokila matotauria nuganugarai geveroli-agiato, negetiwato, “Vovetaina pekila, kwalana ita ati gara pereti gaurai.” ");
INSERT INTO khz_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iesu na eriparato, gaurai evaikilarato, netiwato, “Rakagau gaurai pereti ta lagami ai aikina kilana gokalaana? Gomi rogoti goro ripa, rogoti goro tugamagi-ilu? Nugami roe nea gaoka-poro? ");
INSERT INTO khz_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mamatami, na ati gogitana? Mategami, na ati gokamonagina? Ati govetugamagi-tagona maki? ");
INSERT INTO khz_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Au na pereti imaima apuki-kinikinirato taunilimalima ragana imaima (5,000) garia, pereti kovara gokokorato aonai, papalu vira govega-vonurato?” Ira gevega-geleto, negetiwato, “gagalana ruala.” ");
INSERT INTO khz_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Au na pereti taulatoi kwapuna apuki-kinikinirato taunilimalima ragana vativati (4,000) garia, pereti kovara gokokorato papalu vira govega-vonurato?” Ira gevega-geleto, negetiwato, “Taulatoi kwapuna.” ");
INSERT INTO khz_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na Iesu na netiwato, “Gomi rogoti goro tugamagi-ilu?” ");
INSERT INTO khz_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ira Betesaidai geagoto, ne talima reketa na mata-kele tauna ta Iesu genai gevaiagoato, ne genogiato, pene gapi-kaulagia. ");
INSERT INTO khz_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na Iesu na mata-kele tauna gimanai egapito, evaiatiato vanuga na, ne matana ekainiuato, e gimana genai etao-kaurato, erenagiato, “Gau kiatarana ogitarana pa?” ");
INSERT INTO khz_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Votalima epoe-itito, netiwato, “Pa, talima taarana agitarana, na noowane gautupu vetaira gelakalakana.” ");
INSERT INTO khz_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Gaurai Iesu gimana matanai maetao-kaurato, ne epoepoe-namanamato, gau maparara egita-namanamarato. ");
INSERT INTO khz_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ne Iesu na numai etugu-agoato, evaikilaato, netiwato, “Vanuga aona na ragai pono ago.” ");
INSERT INTO khz_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu magena melo ria Kaisarea Filipi tanona vanugarai geagowai aonai, rauparai Iesu na gena melo erenagirato, netiwato, “Taunilimalima na rakagau negetina au rai?” ");
INSERT INTO khz_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ira gevega-geleto, negetiwato, “Reketa gekilana Ioane Bapatiso, reketa Elia, mareketana peroveta talimana ta.” ");
INSERT INTO khz_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesu na erenagirato, netiwato, “Na gomi rakagau nogotina au rai?” Petero na evega-geleato, netiwato, “Goi Keriso, (Palagu na ekilagi-maavuato vevega-maguli tauna).” ");
INSERT INTO khz_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ne Iesu na evaikilarato, talima ta ragai pia varaa. ");
INSERT INTO khz_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ne Iesu na gena melo maevega-riparato, netiwato, “Taunilimalima Natuna vitiviti vovogo roe nea pene vua. Iuda velera, e Rupu Veaga velera kamura, e rova gevevega-ripagirana talimara na pia rugaa; e pia vagi-kwaregaa maki, na toma toitoi mulirai kwarega na mapene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ekila ekilagi-matagaiato, ne Petero na evaigerevagiato, evaikila-waiato. ");
INSERT INTO khz_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Na Iesu eruga-kuleto, gena melo egitarato, ia na Petero evaikila-waiato, netiwato, “Satani, ono laka-paka, kwalana gemu tugamagi ne ati Palagu gena, na taunilimalima gerianamo.” ");
INSERT INTO khz_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iesu na taunilimalima gutuma e gena melo ekea-koukourato, ne evaikilarato, netiwato, “Pene talima ta au muliku ai pene laka netina genai, ia matotauna pene veruga, gena satauro pene vuaa, au muliku ai pene laka. ");
INSERT INTO khz_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kwalana rai gena magulimo navugana etovoana talimana, gena maguli pene piatogaa. A rai au pakuku ai e Vali Namana pakunai gena maguli pene piatogaa talimana, gena maguli ati pene kala-lekwalekwaa. ");
INSERT INTO khz_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pene talima taa na tanopara maparana ulanana gena maguli pene piatogaa, gena nama rakagau ia genai? ");
INSERT INTO khz_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kwalana talima ta gena maguli epia-togaato genai, rakagau na vou mapene voi-waia? ");
INSERT INTO khz_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pene rai na au e geku kila nugaragera na ekalaana, e veopa-lema e kala rakava talimara wailarai, Taunilimalima Natuna maki pene nugarage ia genai gena vogomai ai, ia Tamana vewaena ralemana e tiavu kamuna e magena aneru veagara ria pia vogomai tomanai.” ");
INSERT INTO khz_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Gaurai evaikilarato, netiwato, “Avaikila-taunataunamina, enai reketa geruga-tagona talimara ati pia kwarega vou, pene ago, Palagu gena Basileia matiavuna ria pene vogomai pia gitaa.” ");
INSERT INTO khz_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Toma taula toitoi (6) gevanagito mulinai, Iesu na Petero, e Teimiti, e Ioane egapirato, ne golo kamuna taai evairagerato. Vonai ira geregariamo aonai Iesu gegitaato, gitagitana eirauto, ");
INSERT INTO khz_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","e gena rapuga ekulo-garogaroto, tanoparai talima ta ati gelegele vovetaina pere vega-kulokuloa. ");
INSERT INTO khz_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ne wailarai Elia e Mose gematagaito, Iesu ria gekilakilawai. ");
INSERT INTO khz_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ne Petero na Iesu evaikilaato, netiwato, “Vevega-ripa talimamu o, nama iwavagi ita enai ea, pe ama gau toitoi aia kalara. Gau ta goi gemu, gau ta Mose gena, gau ta Elia gena.” ");
INSERT INTO khz_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petero ati ripana rakagau pene kilagia, kwalana ira gekali-rakavato. ");
INSERT INTO khz_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ne iloa na ema avugarato, egapi-gavurato aonai, karo ta iloa aona na ekea-atito, netiwato, “E au Natuku, aulamagiana; ia pio kamonagi-venia!” ");
INSERT INTO khz_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ira na vokapu gerakagita-gegelagiato, na ta ati gegitaato ia goti, Iesumo geregana. ");
INSERT INTO khz_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Golo na gemarigowai aonai, Iesu na evaikilarato, rakagau gegitaato gauna talima ta ragai pia varaa, pene ago, Taunilimalima Natuna kwarega na pene kuliiti-wai. ");
INSERT INTO khz_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gaura pakurai gena kila vetairaimo etaluto, na ira vekarawarai geverolito, kwarega na kuliitiwai ganina rakagau. ");
INSERT INTO khz_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne ira na Iesu gerenagiato, negetiwato, “Rakagau gaurai rova gevega-ripagiana talimara gekilana, Elia pene vogomai-kune?” ");
INSERT INTO khz_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu evega-geleto, netiwato, “Taunatauna, Elia e pene vogomai-kune, gau maparara pene vega-valigura. A Taunilimalima Natuna kilana raka getalo-tiwaato viti vogo pene mamilagi e pia rugaa? ");
INSERT INTO khz_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Na avaikilamina, Elia warau evogomaito, e geria ririwa kalara ia genai warau gekalarato, ia kilana Puka Veaga aonai getalo-kuneato gelegelenai.” ");
INSERT INTO khz_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gena melo geriai gekwarato, taunilimalima gutuma para na geruga-gegelagirato, gegitarato, rova gevevega-ripagiawai talimara maki ia ria geveituwai. ");
INSERT INTO khz_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Taunilimalima na Iesu gegitaato aonai, nugara geketo-vagito, gaurai genai geraka-agoto, geve vega-namaato. ");
INSERT INTO khz_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iesu na erenagirato, netiwato, “Etalima ria rakagau veituna gokalaana?” ");
INSERT INTO khz_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ne talima ta gutuma aora na evega-geleto, netiwato, “Vevega-ripa talimamu, au natuku goi gemu ai pavaimaia. Ia muru-kapu palaguna na eporogiato gaurai, ati ekilakilana. ");
INSERT INTO khz_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Epalagu na egapiana tomarai, tano ekwari-agiana. Pokana na kapurokapuro gelakatina, karikarina gevepatina, tauniparana erorina. Gaura pakurai goina melo panogira, epalagu rakavana iagui-atia napatiwa, na pege gui-kavaa.” ");
INSERT INTO khz_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ne Iesu ekilato, “Ati kamonagi talimami! Toma vira au gomi lagami ai pana talu? Toma vira pana vaigaoka venimi? Iovogomai-agia!” ");
INSERT INTO khz_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne vomelo Iesu laganai gevaiagoato. Palagu rakavana na Iesu egitaato aonai, veganamo melo evega-pilupiluato, kwano ai eketo-talito, emakulemakuleto, pokana na kapurokapuro gelakatito. ");
INSERT INTO khz_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu na melo tamana erenagiato, netiwato, “Arigi lagani eviti erawaliato?” Tamana evega-geleto, netiwato, “Emakeina na vegata! ");
INSERT INTO khz_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vega-vogo palagu rakavana na kalovai epia-kauana, e nanu ai epia-raiana pene vagia ulanana. Pene gau kwauta pono kalaa ripa genai, gemu kala, poro gita-vetugamai, poro veakavamai.” ");
INSERT INTO khz_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ne Iesu ekilato, “Pene gau kwauta pono kalaa ripa notina? Palagu genai magena kamonagi talimana gau maparara pene kalara ripa.” ");
INSERT INTO khz_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ne melo tamana veganamo elailaito, netiwato, “Au mageku kamonagi, na geku tugamagi aovoaovo onoma porogia.” ");
INSERT INTO khz_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu na taunilimalima gutuma gelaka-koukouwai egitarato aonai, ia na vopalagu rakavana ekila-waiato, netiwato, “Muru-kapu e tega-gela palaguna, avaikilamuna, ono laka-paka, aonai ragai mapono laka-togawai!” ");
INSERT INTO khz_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ne palagu rakavana elailai-vegala-poluto, ia na melo evega-pilupilu-rakavaato, ne elaka-gerevagito. Melo gitagitana noowane ekwaregato, gaura pakurai taunilimalima gutuma gekilato, “E pekwarega.” ");
INSERT INTO khz_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na Iesu na gimanai egapito, erolo-kuliitiato, ne erugato. ");
INSERT INTO khz_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Voia mulinai Iesu numai erageto, gena melo na veavugai gerenagiato, negetiwato, “Rakagau gaurai ai na palagu rakavana ati gelegele paia gui-atia?” ");
INSERT INTO khz_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne Iesu na evega-gelerato, netiwato, “Palagu evetaira guiguira gau ta aikina, na rapali e voka gereganamo.” ");
INSERT INTO khz_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Vokapu geraokwaniato, Galileia tanona na gevanagito. Iesu ati gena ririwa talima ta pene ripa ia ariginai, ");
INSERT INTO khz_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kwalana gena melo evega-riparato, netiwato, “Taunilimalima Natuna pia lewaa vou, taunilimalima gimarai pia tao-kaua, ne pia vagi-kwaregaa, na pia vagia genai, toma toitoi mulirai mapene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na ira ati geripa-rorirorito Iesu vorakagau ekilagiato, na ati magerenagiato, kwalana gekalito gaurai. ");
INSERT INTO khz_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kaperanaumai gekwarato, ne Iesu na numa aonai vou erenagirato, netiwato, “Gomi rauparai vorakagau gokilagiawai?” ");
INSERT INTO khz_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Na ira ati gevega-geleto, kwalana rauparai, rai kamu iwavagi gekilagiawai. ");
INSERT INTO khz_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iesu etanu-talito, gena melo gagalana ruala ekearato, ne evaikilarato, netiwato, “Rai pene kune netina talimana kapi talimanai pene ago, e taunilimalima maparara vetugunagira pene ago-veni.” ");
INSERT INTO khz_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gaurai ia na melo keina ta egapiato, ira nuganugarai evega-ruga-taliato, epani-itiato, ne evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Rai na melo keina evetaina gelegelena pene gapi-ragea au araku ai, ia na voo au pene gapi-rageku. Pene talima taa na au pene gapi-rageku genai, ati aumo geregaku pene gapi-rageku, na etugukuto Palaguna maki pene gapi-ragea.” ");
INSERT INTO khz_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ioane na Iesu evaikilaato, netiwato, “Vevega-ripa talimamu, talima ta gagitaato, goi aramu ai palagu rakavara egui-atirawai, na ai na gakila-waiato, kwalana ia ati ita ria talaka-kouna.” ");
INSERT INTO khz_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu na evaikilarato, netiwato, “Ragai pio kila-waia, kwalana talima ta au araku ai kala irau vagira pene kalara talimana, au muliku ai au ati pene kilagi-rakavaku. ");
INSERT INTO khz_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kwalana rai na ita ati evega-rakavarana talimana ia ita ria. ");
INSERT INTO khz_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Taunatauna avaikilamina, talima taa na nanu kaperina au araku ai pene venimi, kwalana gomi Keriso gena talima gaurai, ia voina pene gapia vegata.” ");
INSERT INTO khz_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pene talima taa na au ekamonagi-venikuna melo keina ta gena kamonagi evega-rakavaana, ia pere nama vatu kamuna ta gaagonai pegere kwatu-kaua, rawaparai pegere pia-raia. ");
INSERT INTO khz_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pene goi gimamu na evega-rakavamuna genai, pono pati-itua. Gimamu kwapunai maguli vanagivanagi pono rawalia voo nama, a ati nama gimamu ruala kalova egala-vanagivanagina ati eputena kapunai pono ago.  ");
INSERT INTO khz_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Vonai ‘maganimagani na pia gani vanagivanagimi, e kalova ati eputena.’ ");
INSERT INTO khz_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pene goi gagemu na evega-rakavamuna genai, pono pati-itua. Gagemu kwapunai maguli vanagivanagi pono rawalia vonama, a ati nama gagemu ruala kalova egala-vanagivanagina kapunai pia pia-kaumu.  ");
INSERT INTO khz_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Vonai ‘maganimagani na pia gani vanagivanagimi, e kalova ati eputena.’ ");
INSERT INTO khz_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pene goi matamu na evega-rakavamuna genai, pono kipo-vagia. Matamu kwapunai Palagu gena Basileiai pono laka-toga voo nama, a ati nama matamu ruala kalova egala-vanagivanagina kapunai pia pia-kaumu. ");
INSERT INTO khz_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vonai ‘maganimagani na pia gani vanagivanagimi, e kalova ati eputena.’ ");
INSERT INTO khz_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Maparara kalova na pene tamenara, pene alevara. ");
INSERT INTO khz_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tamena nama, na pene tamena mamina pene aiki genai, mamina raka mapono vega-waikule-tiwaa? Nugami ai tamena pene mia, e gomi kwapurakwapura mataukavami ria maino aonai pio talu.” ");
INSERT INTO khz_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu vokapu eraokwaniato, ne Iudea tanonai eagoto, Ioridana waina kavatai evanagito. Taunilimalima gutuma para ia genai geagoto, ne ekalawai vetaina maevega-riparato. ");
INSERT INTO khz_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ne Parisea talimara mageagoto, ia geverenagi-opakauato, negetiwato, “Maru ta garawana pene vega-lakaa genai, rova na pene gapia?” ");
INSERT INTO khz_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Iesu na evega-gelerato, netiwato, “Mose gena rova aonai rakagau netina?” ");
INSERT INTO khz_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Gekilato, “Mose gena rova evetaina ekilana, vegarawa lugalugana pepana pene taloa vou, garawana pene tugu-lakaa.” ");
INSERT INTO khz_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iesu na evaikilarato, netiwato, “Mose na erova etaloato, kwalana gomi aomi vekanagavu roe nea. ");
INSERT INTO khz_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Na Palagu na gau maparara ekalarato aonai, ia na taunilimalima maki ekalarato maru e gare. ");
INSERT INTO khz_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Vovetaina pakunai tau taa na tamana e tinana pene raokwanira, garawana goti pia talu, ");
INSERT INTO khz_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ne ira taura ruala pia kwapuna.’ Gaura pakurai ira ati ruala, na kwapunamo. ");
INSERT INTO khz_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Vovetaina gaurai Palagu na eveakwapunarato talimara talima taa na ati mapene tao-vepakara.” ");
INSERT INTO khz_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gewaikuleto numai, gena melo na gerenagiato vokila ganina rakagau. ");
INSERT INTO khz_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesu na evega-gelerato, netiwato, “Rai na garawana pene raokwania, gare ta mapene garawaa, ia peveopa-lema. ");
INSERT INTO khz_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Gare maki vovetaina, ia garawana pene raokwania, tau taa na mapene garawaa, ia maki peveopa-lema.” ");
INSERT INTO khz_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Talima reketa na naturia gevaiagorawai Iesu genai pene gapi-kaulagira ularana, na gena melo na gekila-wairato. ");
INSERT INTO khz_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu na egitarato aonai eparuto. Ne gena melo evaililarato, netiwato, “Nemelo keira ia vogomai au geku ai, ragai pio gui-waira, kwalana Palagu gena Basileia netalima vetaira geria. ");
INSERT INTO khz_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Taunatauna avaikilaminia, rai na Palagu gena Basileia ati pene gapi-ragea melo keina vetaina, ia Basileiai ati vagi pene laka-toga.” ");
INSERT INTO khz_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Gaurai Iesu na melo keira epani-itirato, ne gimana atarai etao-kaurato, evega-namarato. ");
INSERT INTO khz_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu voanana ekuliitito, ne elakato aonai, talima ta ia genai eraka-agoto, ne wailanai evetiu-talito, erenagiato, netiwato, “Vevega-ripa talimamu namana, au e rakagau pana kalaa vou maguli vanagivanagi pana vaia?” ");
INSERT INTO khz_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iesu na evega-geleato, netiwato, “Goi rakagau gaurai au namaku okilagina? Talima ta ati nama, Palagumo geregana. ");
INSERT INTO khz_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Rova maparara ripamu, ‘Ragai pono vagivagi, ragai pono veopa-lema, ragai pono lema, ragai pono veroli-opakau, ragai pono tao-toga, tamamu tinamu pono nugagi-ragera.’” ");
INSERT INTO khz_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ne votalima ekilato, “Vevega-ripa talimamu, au nema keiku na vegata pene vogomai toma, nerova maparara akwalanarana.” ");
INSERT INTO khz_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu na egitaato maulamagina na netiwato, “Gau kwapunamo ai orapuna, ono ago, gemu rinaga maparara ono vevoi-agira, lealea talimara pono venira, ne kupai magemu rinaga; pono vogomai, muliku ai ponoma laka.” ");
INSERT INTO khz_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Votalima na ekila ekamonagiato aonai, wailana evuaato, aona mametauna elaka-gerevagito, kwalana ia magena rinaga vogo talimana. ");
INSERT INTO khz_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ne Iesu na gena melo egita-gainagainarato, ne evaikilarato, netiwato, “Geria rinaga vovogo talimara Palagu gena Basileiai geria laka-toga gaoka vagi.” ");
INSERT INTO khz_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na Iesu gena melo na vokila gekamonagiato aonai, nugara gepale-vagito, gaurai Iesu na maevaikila-wairato, netiwato, “Natugavu, Palagu gena Basileia lakatogana gaoka vagi. ");
INSERT INTO khz_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamela rina iluna na pene vanagi gaoka, na gena rinaga vogo talimana Palagu gena Basileiai gena laka-toga gaoka-galagala vagi.” ");
INSERT INTO khz_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ne gena melo nugara gepalevagi-rakavato, gaurai gevaikilaato, negetiwato, “Pe, raira na vou maguli vanagivanagi pia vaia?” ");
INSERT INTO khz_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu na egitarato, ne evaikilarato, “Taunilimalima geriai ati gelegele, na Palagu genai gelegele, kwalana Palagu genai gau maparara gelegele.” ");
INSERT INTO khz_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petero na evaikilaato, netiwato, “Goi ripamu, ai gema gau maparara garaokwanirato, goi mulimu ai galakana.” ");
INSERT INTO khz_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iesu evega-geleto, netiwato, “Avaikila-taunataunamina, talima ta gena numa eraokwaniato, pa walakavana, walawalana, tinana, tamana, natuna e gena tano au pakuku ai e Vali Namana pakunai, ");
INSERT INTO khz_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ia emaguli aonai gena numa, walakavana, walawalana, tinana, natuna e tano tinavutinavu pene rawali, e vitiviti maki; e toma gevogomaina aorai, maguli vanagivanagi pene vaia. ");
INSERT INTO khz_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Na taunilimalima gutuma ewagumona gekunena pia kapi, kapi talimara pia kune.” ");
INSERT INTO khz_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesu magena melo ria Ierusalemai geveragewai, rauparana geagowai, Iesu ira wailarai elakato, aonai ira gevevega-kali-rakavato, e mulirai gelakato talimara maki gekalito. Iesu na gena melo gagalana ruala evaigerevagirato, ne genai rakagau pia wala gaura evararato, ");
INSERT INTO khz_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","evaikilarato, “Iokamonagi, ita e Ierusalemai taveragena. Vonai Taunilimalima Natuna Rupu Veaga velera kamura e rova gevevega-ripagiana talimara gimarai pia taoa. Ira na gena kwarega kilana pia vega-taunataunaa, ne ati Iuda talimara (Roma) gimarai pia taoa. ");
INSERT INTO khz_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ira na pia vegarevegare-agia, pia kainiua, pia kwaria e pia vagi-kwaregaa. Na toma toitoi mulirai pene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ne Tepetaio natuna, Teimiti e Ioane, Iesu genai geagoto, ne gevaikilaato, “Vevega-ripa talimamu, ai gaririwana rakagau paia nogimu gauna pono venimai.” ");
INSERT INTO khz_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iesu na evaikilarato, netiwato, “Rakagau gemi ai pana kalaa nogotina?” ");
INSERT INTO khz_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ira na gevaikilaato, negetiwato, “Ai gaririwana, ai ta ripamu ai, e ta kaulimu ai paia tanu goi gemu Basileia maekana ralemana iwavagina aonai.” ");
INSERT INTO khz_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na Iesu na evaikilarato, netiwato, “Gomi ati ripami rakagau gonogiana. Au na vitiviti kaperina pana niua gauna gomi na maki pio niua ripa? Au pia bapatisoku bapatisona gomi na maki pio gapia ripa?” ");
INSERT INTO khz_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Magevega-geleto, negetiwato, “Pa.” Iesu na evaikilarato, netiwato, “Taunatauna, au na pana niua kaperina gomi na maki pio niua, e au pia bapatisoku bapatisona gomi maki pia bapatisomi. ");
INSERT INTO khz_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Na au ripaku ai pa kauliku ai pio tanu nogotina ati au na pana vega-taunataunami; eia e Palagu na ekala-maavurato talimara geria.” ");
INSERT INTO khz_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ekila melo gagalana (10) na gekamonagiato aonai, Teimiti e Ioane geparu-venirato. ");
INSERT INTO khz_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ne Iesu na maparara ekea-koukourato, ne evaikilarato, netiwato, “Gomi ripami, ati Iuda talimara geria vele na taunilimalima getugu-naginagirana, e geria vekuneagi talimara kamura na geria rorirori tiavurana gelaunaginagirana. ");
INSERT INTO khz_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na gomi aomi ai vovetaina ragai pio kala. Pene ta gomi aomi ai pene vele netina genai, gomi maparami vetugunagimi pene ago-veni, ");
INSERT INTO khz_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","e rai pene kune netina talimana, ia maparara geria vetugunagi talimanai pene ago. ");
INSERT INTO khz_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kwalana Taunilimalima Natuna evogomaito, ati taunilimalima na vetugunagina pia ago-veni ulanana, na ia evogomaito, taunilimalima vetugunagira pene ago-veni, e gena maguli pene tao-rigoa, taunilimalima gutuma pene voi-waira e pene vega-magulira ularana.” ");
INSERT INTO khz_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ieriko ai gekwarato, voanana Iesu magena melo e taunilimalima gutuma para ria Ieriko mageraokwaniato aonai, mata-kele e nogi-vekame talimana Batimio, Timeo natuna, raupara pipinai etanu-tagowai. ");
INSERT INTO khz_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ia ekamonagito Iesu, Nasareta talimana, ia laganai, ne ekea-lailaito, netiwato, “Iesu o, Davida natuna, au ono gita-vetugaku!” ");
INSERT INTO khz_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Taunilimalima gutuma na gegoloato e gevaikilaato, ragai pene kogo negetiwato, na ia ekea-vigirage-vigiragewai, “Davida Natuna o, au ono gita-vetugaku!” ");
INSERT INTO khz_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu eruga-talito, ne netiwato, “Iokeaa.” Ne ira na mata-kele talimana gekeaato, negetiwato, “Ragai pono kali, ono kuliiti, Iesu na ekeamuna.” ");
INSERT INTO khz_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ne gena rogagirogagi epia-togaato, epuriitito, Iesu laganai eagoto. ");
INSERT INTO khz_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ne Iesu na erenagiato, netiwato, “Rakagau gemu ana kalaa notina?” Mata-kele talimana evega-geleto, netiwato, “Vevega-ripa talimamu, mataku ono mai-kala-pakaa.” ");
INSERT INTO khz_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ne Iesu na evaikilaato, “Ono ago, gemu kamonagi na pevega-namamu.” Veganamo matana enamato e epoepoe-namanamato, ne Iesu mulina na raupara na eagoto. ");
INSERT INTO khz_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Gelaka-agowai, Ierusalema gekavinagiawai, e Betepeiti e Betaniai gekwarato Olive Golona kavanai, ne Iesu na gena melo ruala etugu-kunerato, ");
INSERT INTO khz_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","evaikilarato, netiwato, “Ioago, wailara vanuganai. Pio kwara genai, toniki natuna ta kwatukau pio gitaa, atanai talima ta rogoti ere rage. Pio lugaa, ne pio vogomai-agia. ");
INSERT INTO khz_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pene talima taa na pene renagimi, nepenetiwa, ‘Gomi rakagau gaurai nevetaina gokalana?’ nepenetiwa genai, pio vaikilaa, ‘Velekou na eririwaana, roe nea vou mapene tugu-waikulea.’” ");
INSERT INTO khz_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ne gelakato, geagoto, toniki natuna geve rawaliato numa ta wailanai kwatukau. Gelugaawai aonai, ");
INSERT INTO khz_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","vonai geruga-tagowai talimara na gerenagirato, negetiwato, “Gomi rakagau gaurai netoniki natuna golugaana?” ");
INSERT INTO khz_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne gevega-gelerato Iesu na evaikilarato vetainai, vou getugurato. ");
INSERT INTO khz_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ne toniki natuna Iesu genai geago-agiato, geria rapuga kamura toniki rogenai geava-kaurato, ne Iesu etanukauto. ");
INSERT INTO khz_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Taunilimalima gutuma geria rapuga kamura rauparai geavarato. Reketa gau laura uraurai gepatito, ne rauparai getaorato. ");
INSERT INTO khz_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Wailai e mulinai gelakato talimara maparara na gevone-agiawai, gekilato, “Hosana, Velekou aranai evogomaina talimana ita vega-namaa! ");
INSERT INTO khz_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Davida ita Tamara gena Basileia evogomaina, ita vega-namaa! Hosana kupa atagaina raimoraimonai!” ");
INSERT INTO khz_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu Ierusalemai elaka-togato aonai, Rupu Veaga aonai elaka-togato, gau maparara egita-veakaurato. Na elaviato gaurai, ia magena melo gagalana ruala ria gelaka-piatito, Betainiai magewaikuleto. ");
INSERT INTO khz_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Maelaganiato, ira Betania geraokwaniato, geagowai aonai, Iesu evitoato. ");
INSERT INTO khz_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Epoe-agoto, figi gautupuna malauna ta egitaato pakana kiata rau ai, ne eagoto, ene vegita-kwalakaua mavuana pa aikina. Vonai eve kwarato, vuana ta ati erawaliato, launamo kovagona, kwalana gena vua laganina roe nea gaurai. ");
INSERT INTO khz_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ne Iesu na figi gautupuna evaikilaato, netiwato, “Goi vuavuamu talima taa na ati pene gania, toma pene ago-vanagivanagi!” Ekila gena melo na gekamonagiato. ");
INSERT INTO khz_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ierusalemai gekwarato, Iesu Rupu Veaga aonai elaka-togato, ne voivoi talimara egui-atirato. Moni gevepoe-agirawai talimara geria pata e pune gevoi-agirawai talimara geria tanukau egule-vepoporato. ");
INSERT INTO khz_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Rupu Veaga aona na geria rinaga gevua-agorawai talimara maki ekila-wairato. ");
INSERT INTO khz_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ne taunilimalima evega-riparato, netiwato, “Puka Veaga aonai evetaina etaloato, Palagu ekilato, ‘Au geku numa taunilimalima irauirau geria rapali numanai pia kilagia,’ na gomi na lema talimara geria kumu kapunai pogo vega-agoa.” ");
INSERT INTO khz_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Rupu Veaga velera kamura e rova gevevega-ripagiawai talimara na gekamonagiato aonai, Iesu pia vagia rauparana getavuato. Iesu kalina na gekaliwai, kwalana taunilimalima maparara na gena gevevega-ripa kilarai gevevega-kali-rakavawai. ");
INSERT INTO khz_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Elavilaviato, Iesu magena melo ria vanuga kamuna geraokwaniato. ");
INSERT INTO khz_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Amoamonai raupara na gelaka-vanagiwai aonai, vofigi gautupuna gegitaaato, emalai-gatuto, lamuna maki gekwaregato. ");
INSERT INTO khz_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petero na etugamagi-tagoawai, gaurai Iesu evaikilaato, netiwato, “Vevega-ripa talimamu, ono gitaa, goi na vofigi gautupuna owaraliato ovaikila-rakavaato gauna warau pekwarega.” ");
INSERT INTO khz_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ne Iesu na evega-gelerato, netiwato, “Palagu pio kamonagi-venia. ");
INSERT INTO khz_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Taunatauna avaikilamina, talima taa na egolo pene vaikilaa, ‘Ono vegapiiti, pe rawaparai ono vepiarai,’ aona ati aovoaovona, na pene vega-taunatauna, rakagau pene kilagia gauna pene taunatauna genai, vokala pene wala. ");
INSERT INTO khz_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gaura pakurai avaikilamina, rakagau pio nogi rapali ai genai, pio vega-taunataunaa, pio rawalia, ne pio gapia. ");
INSERT INTO khz_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pene goruga-talina, ne gorapalina aonai, rakava pio tugamagi-piatogara, pene talima ta genai magemi nuga metau genai, gomi Tamami kupai etaluna na maki gemi rakava pene tugamagi-piatogara.  ");
INSERT INTO khz_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Na pene gomi na talima geria rakava ati pio tugamagi-piatogara genai, gomi Tamami kupai etaluna na maki gemi rakava ati pene tugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ne ira Ierusalemai gekwarato. Vonai Iesu Rupu Veaga aonai elaka-togawai aonai, Rupu Veaga velera kamura, e rova gevevega-ripagiawai talimara, e Iuda velera ia genai geagoto. ");
INSERT INTO khz_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ne gerenagiato, negetiwato, “Arigi rorirori ai goi na ekala okalarana? Rai na rorirori evenimuto?” ");
INSERT INTO khz_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu na evega-gelerato, netiwato, “Au na verenagi kwapuna ana venimi, pio vega-gelea genai, au na arigi rorirori ai ekala akalarana pana vega-ripami. ");
INSERT INTO khz_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioane gena bapatiso kalana kupa na evogomaito, pa taunilimalima geriana?” ");
INSERT INTO khz_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ira vekarawarai geveroliverolito, negetiwato, “Pene ita pita kila, ‘Palagu genana’ nepitatiwa genai, ia pene kila, ‘Rakagau gaurai Ioane ati govega-taunataunaato?’ nepenetiwa. ");
INSERT INTO khz_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Na pene ita pita kila, ‘Taunilimalima geriana’ nepitatiwa genai maki ati gelegele.” Ira taunilimalima kalira na gekalito, kwalana ira ripara, Ioane peroveta talimana taunatauna. ");
INSERT INTO khz_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Gaura pakurai ira na Iesu gevega-geleato, negetiwato, “Ai ati ripamai.” Ne Iesu na ira maki evaikirato, netiwato, “Au na maki arigi rorirori ai ekala akalarana ati pana vega-ripami.” ");
INSERT INTO khz_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu na parapore ai maevaikilarato, “Talima ta vine aragana evaroato, ekanaato, kwano ai vine kikiagina legana etaviato, araga gitatagona numana maki evega-rugaato. Voia mulinai araga gitatagona talimara geriai gena araga eraokwaniato, ne elakato kapu taai. ");
INSERT INTO khz_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Vine vuara (grapes) gemerato, ne ia na gena vetugunagi tauna ta etuguato araga gitatagona talimara geriai, vine vuara reketa peneve gapira ularana. ");
INSERT INTO khz_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Na gegapi-taliato, ne gekwariato vou, gimana kovagona getugu-waikuleato. ");
INSERT INTO khz_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Araga gatana na gena vetugunagi tauna ta maetuguato, na ia repana gevega-raka-kavalugaato e gekala-nugarageato. ");
INSERT INTO khz_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ne ta maetuguato, na gevagi-mateato; e vetugunagi talimara gutuma etugurato, reketa gekwarirato, reketa gevagirato. ");
INSERT INTO khz_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Talima kwapunamo roe voa ia laganai, ia natuna taunataunana, gena ulamagi melona. Ikanai ia etuguato, ‘Natuku ana tugua, ira na pia kupa-ragea.’ ");
INSERT INTO khz_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Na araga gitatagona talimara matotauria gevekila-vevenito, negetiwato, ‘Araga pene gaunaa melona ea, pe ita gapia, ita vagi-kwaregaa, pe araga ita gera.’ ");
INSERT INTO khz_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ne gegapi-taliato, gevagiato, vine aragana mulinai gepiatiato.” ");
INSERT INTO khz_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iesu everenagito, netiwato, “Araga gatana na rakagau pene kalaa? Ia pene vogomai, araga gitatagona talimara pene vagi-gatura, ne vine aragana talima iraura reketa mapene venira. ");
INSERT INTO khz_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Gomi na talotalo Puka Veaga aonai ati goagiana, evetaina ekilana, ‘Vatu numara geraperana talimara na ati geririwaato gepia-togaato vatuna vatu keakwalai eagoto. ");
INSERT INTO khz_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ekala e Velekou na ekalaato, matara na tagitaana, gitagitana irau vagi vegata.’” ");
INSERT INTO khz_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ne Iuda velera na Iesu pia gapia rauparana getavuato, kwalana ira ripara, Iesu na eparapore e ira ekilagirawai gaurai. Na taunilimalima gutuma getanukou-tagowai kalira na gekalito gaurai geraokwaniato, gelakato. ");
INSERT INTO khz_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kapinai vou Parisea talimara e Heroda mulinai gelakawai talimara reketa Iesu genai getugu-agorato, gena kilakilai pia vega-verauleaa e pia gapia ulanana. ");
INSERT INTO khz_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Gevogomaito, ne Iesu gema ripaganiato, negetiwato, “Vevega-ripa talimamu o, ai ripamai goi taunatauna kala rorirori talimamu, taunilimalima kalira na ati okalina. Talima geria raki ati otugamagirana, na goi na taunataunai Palagu gena raupara ovevega-ripagi-gitakauana. Ono vega-ripamai, Kaisara, Roma geria vele, genai takiti paia veni pa aikina?” ");
INSERT INTO khz_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Na Iesu na geria opakau eripaato gaurai, evaikilarato, netiwato, “Rakagau gaurai au goopa-tovokuna? Siliva monina ta iovuamaia, ana mai-gitaa.” ");
INSERT INTO khz_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gaurai ta gevuamaiato, Iesu na erenagirato, netiwato, “Eia e rai avuavuna e rai arana?” Ira gevega-geleto, negetiwato, “Kaisara.” ");
INSERT INTO khz_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iesu na evaikilarato, “Kaisara gena gau Kaisara pio venia, Palagu gena gau Palagu pio venia.” Gaurai gevevega-kali-rakavato ia genai. ");
INSERT INTO khz_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadukea talimara reketa Iesu genai geagoto. Ira geria tugamagi, kwarega talimara ati mapia kuliiti-wai. Gaurai Iesu gerenagiato, negetiwato, ");
INSERT INTO khz_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Vevega-ripa talimamu o, Mose na rova ai gema evetaina etaloato, ‘Pene tau ta kakana pene kwarega, wapuna pene kwarega-kwania, ati natura genai, vomaru na kakana wapuna pene garawaa, naturia pia gapira kwarega tauna gena.’ ");
INSERT INTO khz_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Melo walakako maparara taulatoi kwapuna. Tau kunena na egarawaato, ekwaregato ati natuna. ");
INSERT INTO khz_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Melo vega-rualana na wapu egarawaato, na ia maki ekwaregato ati natuna. Melo vega-toitoina maki vovetainamo. ");
INSERT INTO khz_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Voia aonai ira maparara taulatoi kwapuna, naturia ta ati gevega-walaato. Ikanai vogare maki ekwaregato. ");
INSERT INTO khz_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kuliitiwai tomanai vogare rai garawana? Kwalana ira taura taulatoi kwapuna na gegarawaato.” ");
INSERT INTO khz_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu na evega-gelerato, netiwato, “Gomi goleana, kwalana Puka Veaga ganina e Palagu gena tiavu ati ripami. ");
INSERT INTO khz_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kwarega na pia kuliiti-wai talimara ati mapia vegarawa. Ira aneru vetaira kupai. ");
INSERT INTO khz_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kwarega na mapia kuliiti-wai kilara Mose gena pukai ati goagirana? Gautupu egalaato valina aonai Palagu na Mose evaikilaato, netiwato, ‘Au Aperaamo gena Palagu, Isaako gena Palagu, e Iakobo gena Palagu.’ ");
INSERT INTO khz_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ia maguli talimara geria Palagu, ati kwarega talimara geria Palagu. Gomi golea-rakavana!” ");
INSERT INTO khz_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Rova gevevega-ripagiawai talimana ta evogomaito, geria vegupuvegupu ekamonagiato, ne egitaato, Iesu na evega-gele-gitakaurato gaurai, erenagiato, netiwato, “Rova maparara aorai arigia kamu iwavagina?” ");
INSERT INTO khz_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu na evega-geleato, netiwato, “Kamu iwavagina ea: ‘Isaraela talimami o, iokamonagi, Velekou ita gera Palagu ia Velekou kwapunamo geregana kwanilova. ");
INSERT INTO khz_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Velekou goi gemu Palagu pono ulamagia maaomu maparana, mapalagumu maparana, magemu tugamagi maparana, matiligamu maparana na.’ ");
INSERT INTO khz_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Vega-rualana ea: ‘Lagamu talimana pono ulamagia, goi matotaumu oveulamagina vetaina.’ Rova taa na erova ruala ati pene iwara.” ");
INSERT INTO khz_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Rova evevega-ripagiawai talimana maevega-geleto, netiwato, “Vevega-ripa talimamu o, goi gemu kila taunatauna, Palagu kwapunamo, mataa aikina. ");
INSERT INTO khz_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pono ulamagia maaomu maparana, magemu tugamagi maparana, matiligamu maparana, e lagamu ai etaluna talimana maki pono ulamagia, goi matotaumu oveulamagina vetaina. Eia e kamu iwavagi, rapali gaura e veveni gaura maparara eiwarato.” ");
INSERT INTO khz_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Gaurai Iesu na votalima gena vevega-gele egitaato maaonekana e matugamagi-iluna, gaurai evaikilaato, netiwato, “Goi e Palagu gena Basileia vepakami ati rau.” Voia mulinai talima taa na ati maerenagiato, kwalana gekalito gaurai. ");
INSERT INTO khz_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu Rupu Veaga aonai evevega-ripawai aonai, ekilato, “Rova gevevega-ripagiana talimara rakagau gaurai Keriso Davida natuna negetina? ");
INSERT INTO khz_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davida Veaga Palaguna na ripa e tugamagi-ilu eveniato, gaurai ekila-matagaito, netiwato, ‘Palagu na au geku Velekou evaikilaato: Au gimaku ripana kavanai ono mai-tanu, pene ago, goi geparu-venimuna talimara goi gagemu kapulenai pana taora.’ ");
INSERT INTO khz_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Davida na Keriso ‘Velekouna’ ekilagito; rakagau gaurai Keriso ia Davida natuna?” Taunilimalima gutuma para Iesu gena kila mavererera na gekamonagiato. ");
INSERT INTO khz_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Gena vevega-ripa aonai ekilato, “Rova gevevega-ripagiana talimara pio gitatago-namanamara. Ira geririwana rapuga mogara pia ligo, maketi kapurai pia loulou, talima na pia vega-ragera ularana. ");
INSERT INTO khz_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rupu aorai e velekwa kapurai geria ririwa tanukau namaraimo pia tanu. ");
INSERT INTO khz_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ira na wapu geria numa e rinaga gevega-aikirana. Geria rapali moga vavagi, e geopaopakauna. Ira metau kamu iwa pia gapia.” ");
INSERT INTO khz_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu moni-tao mauana wailanai etanu-talito, ne taunilimalima moni geurawai egitarato. Rinaga e moni vovogo talimara gutuma moni kamura geurarawai. ");
INSERT INTO khz_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Aonai ati gena e ati gana wapuna ta evogomaito, gena moni girigiri rualamo eura-rigorato, eia e noo roli toea kwapuna vetaina. ");
INSERT INTO khz_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Gaurai Iesu na gena melo ekearato ia genai, ne evaikilarato, netiwato, “Taunatauna avaikilamina, ewapu na peuraa monina na maparara geria veni peiwara. ");
INSERT INTO khz_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kwalana ira maparara geria moni vovogo aora na keitaramo pege veni, na ewapu ati gena e ati gana aonai, genai rakagau gemia na gena maguli ai pere veakavagia gaura maparara peurara.” ");
INSERT INTO khz_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu Rupu Veaga na elakatiwai aonai, gena melo taa na evaikilaato, netiwato, “Vevega-ripa talimamu, evatu ati keikeira ono gitara e enuma kamura maralemara ono gitara.” ");
INSERT INTO khz_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iesu na evega-geleato, netiwato, “Enuma kamura ogitarana? Evatu ta vatu ta atanai ati pia mia, maparara pia vale-vepopo-rigora.” ");
INSERT INTO khz_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iesu Olive Golona kukunai etanu-tagowai, Rupu Veaga Ierusalemai egita-agoawai aonai, Petero, Teimiti, Ioane, e Anduru na gerenagi-gariato, negetiwato, ");
INSERT INTO khz_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ono varamai, egaura arigi toma pia wala, e pia wala genai, raka vegailiana pia vega-matagaia, ne ira maparara pia wala?” ");
INSERT INTO khz_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Gaurai Iesu na evega-gelerato, netiwato, “Gomi rogomi pio vetole, talima taa na ragai pene opami. ");
INSERT INTO khz_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Talima vovogo au araku ai pia vogomai, pia kila, ‘Talimana au ea!’ Talima gutuma pia opara. ");
INSERT INTO khz_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pene gomi vetali kulura e vetali valira pio kamonagira genai, nugami ragai pia golugolu. Negaura ne pia wala, na ikana roe voa. ");
INSERT INTO khz_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tanopara ta tanopara ta goti pia vetali, kaomani ta kaomani ta goti pia vetali. Kapu vovogo aorai pene tano-kepoa, roge maki pia wala. Eia vitivitimo pene tinaa, noowane kivani ewalana vitina vetaina. ");
INSERT INTO khz_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Matotaumi pio vegita-tago namanama, kwalana pia gapimi, Iuda geria kaonsela talimara geriai pia vaiagomi e rupu aorai pia kwarimi. Au gogapi-ragekuna pakunai, kavana e vele kamura pa king wailarai roe nea pio ruga, au vega-taunataunaku ai pio ago. ");
INSERT INTO khz_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Vali Namana tanopara maparara aorai pia vopatagi-kunea. ");
INSERT INTO khz_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pene Kota talimara wailarai pia vaiagomi genai, rakagau nogo kilagiana kilara ragai pio aovekwalavi-agira. Laganina pene kwara vou, Palagu na rakagau pene vega-ripami kilara pio kilagira, kwalana ati gomi pio kila, na Veaga Palaguna pene kila. ");
INSERT INTO khz_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kakana na tarina pene lewaa pene kwarega ulanana, tamana na natuna maki vovetaina pene kalaa. Natura na tamara e tinara pia karoverave-venira e pia vagira. ");
INSERT INTO khz_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Taunilimalima maparara na pia aorakava-vagimi, kwalana au gogapi-ragekuna gaurai. Na rai pene vaigaoka pene ago ikanai pene maguli.” ");
INSERT INTO khz_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pene gomi na gau rakava iwavagina, vevega-kali gauna, pio gitaa, ati pene ruga kapunai pene ruga.” Ekila pene agia talimana pene ripa-rorirori ganina vorakagau. “Gaurai rairai Iudeai getaluna talimara golo ai pia raka-ago. ");
INSERT INTO khz_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Rai numa kukunai etanu-tagona, ati mapene laka-toga numa aonai gena rinaga gapigapira. ");
INSERT INTO khz_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Rai araga aonai maki ati pene waikule gena rogagirogagi gapigapira. ");
INSERT INTO khz_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Volaganinai gare matinagera e melewa valigu garera kika mavetugara! ");
INSERT INTO khz_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pio rapali, egau ragai pene wala gura e nakula aorai! ");
INSERT INTO khz_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kwalana volaganinai rakava e viti-vua kamu pia kwara, Palagu na tanopara ekalaato pene vogomai ewagumona, rakava e viti-vua vovetaira ati gewalana. Eia mulinai vovetaina rakavana ta ati mapene wala. ");
INSERT INTO khz_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pene Velekou na votoma rakavara ati pere vega-kupara, talima ta ati pere maguli ripa, na evirigirato talimara pakurai, ia na tomara evega-kuparato. ");
INSERT INTO khz_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Volaganinai, pene talima taa na pene vaikilami, ‘Iogitaa, Keriso ea!’ pa ‘Iogitaa ia goi voa!’ nepenetiwa genai, ragai pio vega-taunataunaa. ");
INSERT INTO khz_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kwalana Keriso opakaura e peroveta talimara opakaura pia matagai, vegailia kamura e kala irau vagira pia kalara, Palagu na evirigirato talimara pia opa-vevilira ularana. ");
INSERT INTO khz_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Vovetaina gaurai matotaumi pio vegita-tago; gau maparara akarovara-kunemina, laganina rogoti ere kwara aonai.” ");
INSERT INTO khz_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na volaganinai, rakava pia wala mulinai, garo pene mukunaa, pene pogi-lotoa, e uve maki ati pene rala, ");
INSERT INTO khz_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mitiu kupa na pia keto-rigo e kupa tiavura pia veakaveaka. ");
INSERT INTO khz_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ne talima na Taunilimalima Natuna pia gitaa, iloa na pene vogomai matiavuna kamuna e mamaeka ralema iwavagina. ");
INSERT INTO khz_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ne ia na aneru pene tugura, evirigirato talimara pia vega-koukoura tanopara maparara na.” ");
INSERT INTO khz_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Figi gautupuna genana eparapore pio ripaa: Pouna eragena e launa ekakavana aonai, goripana, garo gena rala laganina pekavinagi nogotina. ");
INSERT INTO khz_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Voia gelegelenai, gomi maki pene egau pia wala pio gitara genai, pio ripa, Taunilimalima Natuna pekavinagi vanagi ai. ");
INSERT INTO khz_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Taunatauna avaikilamina, egulu ati pene aiki, pene ago, egaura maparara pia wala. ");
INSERT INTO khz_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kupa e tanopara pia lekwalekwa, na au geku kila vou ati pia lekwalekwa, pia mia-vanagivanagi.” ");
INSERT INTO khz_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Na votoma e ora talima ta ati ripana, aneru kupai ati ripara, e Natuna maki ati ripana, na Tamana gereganamo ripana. ");
INSERT INTO khz_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Rogomi pio vetole, pio vegita-mataneka, kwalana ati ripami, arigi toma voora pene kwara. ");
INSERT INTO khz_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ia evetaina, talima ta elaka-gerevagito, gena numa eraokwaniato, ne gena vetugunagi talimara rorirori evenirato, kwapurakwapura geria inagulu pia kala. Vanagi gitatagona talimana maki evaikilaato, pene mala. ");
INSERT INTO khz_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Vovetaina gaurai gomi maki keromi pio talu, kwalana numa gatana pene waikule orana ati ripami, lavilavi, pa pogi nugana, pa kokoloku pene kogo aonai, pa amoamo. ");
INSERT INTO khz_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Irau na ewagumona neekwarana, ne maitumi ai neewaitagomina nea. ");
INSERT INTO khz_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Au na rakagau gomi akaro-varamina kilana taunilimalima maparara maki akaro-vararana, natina, ‘Keromi pio talu e pio vegita-tago!’” ");
INSERT INTO khz_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Toma rualamo roe nea, ne Pasova velekwana pa Iuda talimara kwarega aneruna na evanagirato ati evagirato velekwana e ati egoro-agiana paraoana velekwana pia kalaa aonai, Rupu Veaga velera kamura e rova evevega-ripagiawai talimara na Iesu pia gapi-lemaa, ne pia vagi-kwaregaa rauparana getavuawai. ");
INSERT INTO khz_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na gekilato, “Ati velekwa aonai pene wala, kwalana velekwai pia vogomai talimara ia atana na nege purina nea.” ");
INSERT INTO khz_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesu Betaniai Simona, lepera talimana, gena numai eganiganiwai aonai, gare ta elaka-togato, mata namana ta, alabasta vatuna na gekalaato matana, egapi-kauato, aonai vomulamula maponana namana. Vomulamula gawa arana nad lamuna na gekalaawai gauna, voina kamu vagi. Vogare na mata pokana ekoe-kavalugaato, ne mulamula Iesu repanai epopo-kauato. ");
INSERT INTO khz_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ia laganai talimara reketa maaora metaura gemunemuneto, negetiwato, “Rakagau gaurai emulamula ponana namana epiatoga-kawaana? ");
INSERT INTO khz_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pere voivoi-agia, pe siliva monira tinavu toitoi (300) pere rawalira, (eia e talima ta voina rigolo kwapuna aonai vetaina), pe lealea talimara pere venira.” Ne ira na vogare gegoloato. ");
INSERT INTO khz_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na Iesu ekilato, “Ioraokwania! Rakagau gaurai gomi na metau goveniana? Egare na ekala namana au geku ai pekalaa. ");
INSERT INTO khz_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Lealea talimara gomi ria pio talu-vanagivanagi, pe pio ririwa genai, pio veakavara. Na au ati toma mapararai gomi ria pita talu. ");
INSERT INTO khz_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Egare na rakagau pere kalaa gauna pekalaa, ia na au tauniparaku ai mulamula pepopo-kunea au toleagiku ulanana. ");
INSERT INTO khz_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Taunatauna avaikilamina, Vali Namana pia vopatagia tanopara mapararai, egare na kala pekalaa kalana maki piave kilagia, ia tugamagi-tagoagina.” ");
INSERT INTO khz_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ne Iudas Isakariota, gagalana ruala talimana ta, Rupu Veaga velera kumura geriai eagoto, Iesu pene velewaa ira geriai ulanana. ");
INSERT INTO khz_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ne ira na gekamonagiato aonai, geverere-rakavato, e gekila-gavuto, moni pia venia. Gaurai Iuda na gimarai pene tao-kaua rauparana etavuawai. ");
INSERT INTO khz_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Toma tovotovonai, ati egoro-agiana paraoana velekwana tomana e vekapawai mamoena vagivagina tomanai, Iesu gena melo geverenagito, negetiwato, “Ai ariginai Pasova velekwana paia kala-maavua, pono gania?” ");
INSERT INTO khz_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne Iesu na gena melo ruala etugurato, evaikilarato, netiwato, “Vanuga kamunai pio laka-toga, talima ta nanu kwagutuna pene vuaa pio rawalia. Mulina na pio ago. ");
INSERT INTO khz_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ne pene rage numanai numa gatana pio vaikila, nopiotiwa, ‘Vevega-ripa talimana ekilana: Au geku wariwari kovogana arigia, geku melo ria vonai vekapawai mamoena paia gania?’ ");
INSERT INTO khz_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ne ia na kovoga kamuna ta numa kukunai pene vega-gitami aleva-maavu. Vonai pio rapalaa ita garaa.” ");
INSERT INTO khz_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ne melo geagoto, vanuga kamuna aonai gelaka-togato, Iesu na ekilagirato gelegelerai gerawalirato. Vonai Pasova velekwana gekalaato. ");
INSERT INTO khz_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Elaviato, Iesu magena melo gagalana ruala ria gekwarato. ");
INSERT INTO khz_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Geganiganiwai aonai Iesu ekilato, “Taunatauna avaikilamina, gomi taa na au pono lewaku, au goti ewagumona taganigani-koukouna talimamu taa na.” ");
INSERT INTO khz_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ira maparara aora mametaura na kwapurakwapura na gerenagiato, negetiwato, “Taunatauna ati au, ei?” ");
INSERT INTO khz_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu na evaikilarato, netiwato, “E gomi gagalana ruala vekarawami ai rai au goti rivu kwapunaimo ganapa-rigona talimana. ");
INSERT INTO khz_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Taunilimalima Natuna pene kwarega, Puka Veaga aonai etaloato gelegelenai. Na Taunilimalima Natuna pene lewaa talimana vetugana kekei, ati pere wala nama.” ");
INSERT INTO khz_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Geganiganiwai aonai, Iesu na pereti egapiato, Palagu evega-namaato, ekala-kava-lugaato, evenirato, aonai evaikilarato, “Iogapia, e au tauniparaku.” ");
INSERT INTO khz_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ia na kaperi maegapiato, evega-namaato mulinai evenirato, ne maparara na geniuato. ");
INSERT INTO khz_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aonai Iesu na evaikilarato, netiwato, “E au ralaku, Vekapawai Valiguna evega-taunataunaana, pene vepopo, taunilimalima gutuma vega-magulira. ");
INSERT INTO khz_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Taunatauna avaikilamina, vine nanuna ati mapana niu-waia, pene ago neamo, Palagu gena Basileiai vou mapana niu-waia.” ");
INSERT INTO khz_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ne mari ta gemariato mulinai, gelaka-piatito, Olive Golonai geagoto. ");
INSERT INTO khz_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ne Iesu na evaikilarato, netiwato, “Gomi maparami gemi kamonagi au geku ai pio raokwania, kwalana Puka Veaga aonai evetaina etaloato, ‘Au na mamoe gitatagora talimana pana vagia, ne mamoe maparara pia raka-lovolovo.’ ");
INSERT INTO khz_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Na au kwarega na pana kuliiti-wai mulinai, pana ago-kune Galileiai. Vonai vou pita verawali.” ");
INSERT INTO khz_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petero ekilato, “Maparara na geria kamonagi goi gemu ai pia vega-gevoa, na au na aikina.” ");
INSERT INTO khz_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu na evega-geleato, netiwato, “Taunatauna avaikilamuna, toma pogi kokoloku vega-ruala rogoti ere kogo aonai, goi na au vega-toitoi pono opa-tagoku.” ");
INSERT INTO khz_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na Petero ekila-vigirageto, netiwato, “Pene goi goti pita kwarega-kou genai, au na goi vegata vagi ati pana opatago-kapu-vagimu.” Maparara vovetainamo gekilato. ");
INSERT INTO khz_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ira geagoto kapu ta arana Getesemane, Iesu na gena melo evaikilarato, netiwato, “Enai iotanu-tago, au ana ago, ana verapali vou.” ");
INSERT INTO khz_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ne Petero, Teimiti, e Ioanemo evairato, ia ria geagoto. Voia aonai Iesu tauniparana enakulaato, ekalito, aona maki evekwalaviwai. ");
INSERT INTO khz_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne evaikilarato, netiwato, “Au nugaku na metau kamu vagi evuaana, roli evagikuna. Enai iotanu-tago, pio vegita-tago.” ");
INSERT INTO khz_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iesu kiata maelaka-nagito, kwano ai eketo-talito, ne Palagu enogiato, netiwato, pene maraupara ta voa genai, eora metauna genana pene vanagi. ");
INSERT INTO khz_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ekilato, “Abba, Tamaku o, gau maparara goi gemu ai kalakalara gelegele. Eviti kaperina gekuna ono mai-gapi-vagia. Na ati au geku ririwa, goimo gemu ririwa.” ");
INSERT INTO khz_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Gena melo toitoi geriai ewaikuleto aonai, ira gemaitu-kwaregato erawalirato, ne Petero evaikilaato, netiwato, “Simona, goi ne omaituna? Ora kwapuna vetaina ati poro vaigaoka? ");
INSERT INTO khz_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pio vaigaoka, pio rapali, pe veopatovo pene vogomai aonai ragai pio moira. Palagu taunatauna eririwana, na taunipara emoirana.” ");
INSERT INTO khz_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne maelaka-gerevagito, eve rapalito, vorapali kilara kunera maeve kilagirato. ");
INSERT INTO khz_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Maeve waikule-waito aonai ira ati geria vaigaoka gaurai, maitu kwaregarai ema rawalirato, kwalana matara maitu na egapi-rakavarato. Ira ati riparia raka pia vega-gele-tiwaa. ");
INSERT INTO khz_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Vega-toitoina maewaikuleto, ne evaikilarato, netiwato, “Gomi roe ogo maituna e gopikapikana? Peremagaro! Orana warau pekwara! Iogitaa, Taunilimalima Natuna pege lewaa, rakava talimara gimarai pege taoa. ");
INSERT INTO khz_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Iokuliiti, pe ita wati! Iogitaa, au lewalewaku talimana pe kwara ea!” ");
INSERT INTO khz_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu roe waekilakilawai aonai, Iudas, melo gagalana ruala tauna ta, ekwarato. Taunilimalima gutuma maki ia ria mageria vetali kativara e gapa. Ira Rupu Veaga velera kamura, e rova gevevega-ripagiawai talimara, e Iuda velera na getugurato. ");
INSERT INTO khz_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lewa talimana na vegailia ta evaikila-maavurato, netiwato, “Pana velavua talimana voa; pio gapi-talia, pio vaiagoa gomi gemi vegita-tago kapulenai.” ");
INSERT INTO khz_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iudas ekwarato aonai, rorirori eagoto Iesu genai, ne evaikilaato, “Vevega-ripa talimamu o!” ne evelavuato. ");
INSERT INTO khz_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ne vetali talimara na gegapiato, geligoligoato. ");
INSERT INTO khz_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na vonai eruga-tagowai talimana ta, gena vetali kativana einu-vagiato, eavuato, ne Rupu Veaga velena kamuna gena vetugunagi talimana tegana epati-vagiato. ");
INSERT INTO khz_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu na evaikilarato, netiwato, “Au karoverave kakona ta avaivoana? Gaurai gomi pogo vogomai au gapigapiku, magemi vetali kativara e vevagi gapara? ");
INSERT INTO khz_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Toma mapararai au gomi lagami ai Rupu Veaga aonai avevega-ripawai, na ati gogapikuto. A eia e Puka Veaga aonai getalo-kuneato kilana vega-taunataunana ulanana.” ");
INSERT INTO khz_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Gena melo maparara na geraka-kwaniato, geraka-lovolovoto. ");
INSERT INTO khz_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Melo valigu ta kopina kovagona, na rapuga kianamo tauniparana eligo-gavuato, Iesu mulinai elakato. Ia maki gegapiato, ");
INSERT INTO khz_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na gena rapuga gimarai eraka-kwaniato, kopina kovagona eraka-vevilito. ");
INSERT INTO khz_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ira na Iesu gevaiagoato Rupu Veaga velena kamuna genai, Rupu Veaga velera kamura, Iuda velera, e rova gevevega-ripagiawai talimara maparara gelaka-koukouto. ");
INSERT INTO khz_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petero na Iesu elaka-guiato, na mavepakana eagoto neamo, Rupu Veaga velena kamuna gena numa kanana aonai elaka-togato. Vonai vegitatago talimara nuganugarai evetanuto, kalova na etunuwai. ");
INSERT INTO khz_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Rupu Veaga velera kamura e Iuda geria kaonsela talimara maparara na Iesu veakwaregana kwalana ta getavuato, na ta ati gerawaliato. ");
INSERT INTO khz_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Taunilimalima gutuma geria opakau kilara na geroliawai, na geria kila ati gekwapunawai. ");
INSERT INTO khz_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ne talima reketa geruga-itito, nee opakau kilara gekilagirato, negetiwato, ");
INSERT INTO khz_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ai na ia gena kila paga kamonagia, nepetiwa, ‘Au na etaunilimalima gimara na gekalaato Rupu Veagana pana lovoa, toma toitoi aorai mapana kalaa, ati gima kalakalana rupuna.’” ");
INSERT INTO khz_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na ira geria veroli-opakau kilara ati gekwapunato. ");
INSERT INTO khz_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ne Rupu Veaga velena kamuna wailarai erugaitito, ne Iesu erenagiato, netiwato, “Goi ati pono vega-gele? Eira na goi gerolimuna kilara rakavetaina?” ");
INSERT INTO khz_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Na Iesu ati ekilakilato, e ati evega-gelerato. Gaurai Rupu Veaga velena kamuna na maerenagi-waiato, netiwato, “Goi Keriso, gevega-namaana Palaguna Natuna?” ");
INSERT INTO khz_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu na evega-geleato, netiwato, “Talimana au ea! Gomi na Taunilimalima Natuna roe nea pio gitaa, Tiavu Palaguna gimana ripanai pene tanu, e kupa iloara atara na pene vogomai!” ");
INSERT INTO khz_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ne Rupu Veaga velena kamuna na gena rapuga eraleato, netiwato, “Rakagau gaurai talimara roe ata tavurana? ");
INSERT INTO khz_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Palagu vega-rakavana kilana pogo kamonagia. Gomi rakagau nogotina?” Ira maparara gekilato, “Pene kwaregamo nea.” ");
INSERT INTO khz_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ne reketa na gekainiuato, matana gekumu-gavurato, gerakavaleato, gevaikilaato, negetiwato, “Goi peroveta talimana, pe ono kilagia, rai na pekwarimu?” Ne vegitatago talimara na gegapiato, gimara na geapariato. ");
INSERT INTO khz_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petero roe voa numa kanana aonai, Rupu Veaga velena kamuna gena vetugunagi vavinera ta eagoto. ");
INSERT INTO khz_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ia na Petero kalova na etunuawai egitaato, ne egita-gainagainaato, evaikilaato, netiwato, “Goi maki Iesu, Nasareta tauna, goti golouvowai, okwaruawai.” ");
INSERT INTO khz_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Na ia eveopa-tagoto, netiwato, “Au ati ripaku goi rakagau okilagiana,” ne elakatito kana vanagina na, ne kokoloku ekogoto. ");
INSERT INTO khz_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Vovetugunagi vavinena na maegitaato, ne vonai geruga-tagowai talimara evaikilarato, netiwato, “Talimana ta goi nea.” ");
INSERT INTO khz_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Petero maeveopa-tagoto. Ati lovana, ia laganai geruga-tagowai talimara na gevaikilaato, negetiwato, “Taunatauna, goi maki ia goti golakavowai talimamu ta, kwalana goi Galileia taumu.” ");
INSERT INTO khz_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na Petero na evaikilarato, netiwato, “Aikina kinavagi, avaikila-taunataunamina, gomi na gokilagiana talimana au ati ripaku.” ");
INSERT INTO khz_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kokoloku vega-ruala maekogoto, Petero na Iesu gena kila etugamagi-rawaliato, ekilato, “Kokoloku vega-rualana rogoti ere kogo aonai, goi vega-toitoi pono veopa-tago.” Ne etagi-rakavarakavato. ");
INSERT INTO khz_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Amoamo valiguvaliguna, Rupu Veaga velera kamura, Iuda velera, rova gevevega-ripagiawai talimara, e kaonsela talimara maparara na gevega-taunataunaato. Gaurai Iesu geligoligoato, gevaiagoato, Roma kavana na Pilato geve veniato. ");
INSERT INTO khz_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato na erenagiato, netiwato, “Goi Iuda talimara geria king pa?” Iesu na evega-geleato, netiwato, “Pa, okilagiana nea.” ");
INSERT INTO khz_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ne Rupu Veaga velera kamura na Iesu geroliato, kila vogo gekilagirato. ");
INSERT INTO khz_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato na maerenagi-waiato, netiwato, “Goi ati pono vega-gele? Ono gitaa, goi atamu ai metau vogo gekilagirana.” ");
INSERT INTO khz_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na Iesu ati ekilakilato, gaurai Pilato eaovoaovoto. ");
INSERT INTO khz_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Vanagivanagi Pasova velekwana tomanai Pilato na ira geria tipura numanai etaluna, pia kilagia talimana ta, etugu-atiawai. ");
INSERT INTO khz_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Volaganinai talima ta arana Barabas, ia tipura numanai etaluwai talima reketa ria, kwalana gegalamato aonai, talima ta gevagi-kwaregaato. ");
INSERT INTO khz_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ne gutuma vonai gekoukouto talimara Pilato genogiato, ekalana vetaina mapene kalaa. ");
INSERT INTO khz_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato na erenagirato, netiwato, “Gomi goririwana au na Iuda talimami gemi vele ana tugu-atia pa?” ");
INSERT INTO khz_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ia ripana, Rupu Veaga velera kamura geria velivu pakunai, Iesu ia gimanai getaoato. ");
INSERT INTO khz_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Na Rupu Veaga velera kamura na taunilimalima aora geganirato, Pilato na Barabas pene tugu-atia. ");
INSERT INTO khz_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ne Pilato na maerenagirato, netiwato, “Na eIuda talimami gemi vele nogotina eraka ana kalagi-tiwaa?” ");
INSERT INTO khz_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ira geparalato, negetiwato, “Ono satauroa!” ");
INSERT INTO khz_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato na erenagirato, netiwato, “Rakagau gaurai, raka kala rakavana ekalaato?” Na maparara geparala-vigirageto, negetiwato, “Ono satauroa!” ");
INSERT INTO khz_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato gena ririwa votaunilimalima gutuma aora pene vega-namara ularana, ia na Barabas etugu-atiato, na Iesu gekwariato mulinai, evenirato pia satauroa. ");
INSERT INTO khz_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Vetali talimara na Iesu gevaiagoato kavana gena numa aonai, ne taukavara maparara gekea-koukourato. ");
INSERT INTO khz_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ne rapuga kalovakalovana gevega-rogagiato, repana gauna gau vekalavekala gevatuato, noowane kraon, ne Iesu repanai getao-kauato. ");
INSERT INTO khz_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ne gevega-namaato, negetiwato, “Iuda geria King o, toma namana!” ");
INSERT INTO khz_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ne golo toki na repana gekwariwai-kwariwaiawai, gekainiuato, getiutali-veniato, gealiruputali-veni-opakauato. ");
INSERT INTO khz_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Gevegarevegareagi-gatuato mulinai, rapuga kalovakalovana gegaivagiato, gena rapuga taunatauna magevega-rogagiato. Ne gevaiatiato pia satauroa ulanana. ");
INSERT INTO khz_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kureni talimana ta arana Simona, Alesanda e Rufas tamara, kuni vanugana taa na evogomaiwai, vetali talimara na gelaunagiato Iesu gena satauro ene vuaa. ");
INSERT INTO khz_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ne Iesu gevaiagoato kapu ta arana Gologota, ganina “Repa Gavana Kapuna.” ");
INSERT INTO khz_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ne ira na vine nanuna, viti vega-keina mulagana arana muro goti gekao-veviliato, geveniato, na ati eniuato. ");
INSERT INTO khz_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ne gesatauroato; gena rapuga pakurai kati ulana gekalaato, ne gewarerato ira vekarawarai. ");
INSERT INTO khz_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Amoamo oragauna taulavati kwapuna (9 koloko) kavanai gesatauroato. ");
INSERT INTO khz_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rakagau pakunai gesatauroato kilana satauro atanai evetaina getaloato, “IUDA TALIMARA GERIA VELE.” ");
INSERT INTO khz_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Lema talimara ruala maki Iesu ria gesataurorato, ta ripana kavanai, ta kaulina kavanai.  ");
INSERT INTO khz_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Voanana Puka Veaga aonai getalo-kuneato kilana evega-taunataunaato, netiwato, “Ia kala rakava talimara ria geagi-kouato.” ");
INSERT INTO khz_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Gelaka-vanagiwai talimara na kila rakavara geveniawai, repara gekwarakwararawai, negetiiwai, “Ei, goi okilato Rupu Veaga pono lovoa, toma toitoi aorai mapono vega-ruga-waia notiwato! ");
INSERT INTO khz_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Satauro kukuna na ono mairigo, matotaumu ono vevega-maguli!” ");
INSERT INTO khz_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Rupu Veaga velera kamura e rova gevevega-ripagiawai talimara na maki vekarawarai evetaina gevegarevegare-agiato, negetiwato, “Ia na talima polura evega-magulirato, na matotauna ati evevega-magulina! ");
INSERT INTO khz_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keriso, Isaraela talimara geria vele, satauro na ewagumonamo ono mairigo ai wailamai ai, pe paia vega-taunataunamu!” Iesu goti gesatauro-kourato talimara ruala na maki gevaikila-rakavaato. ");
INSERT INTO khz_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Oragauna 12 koloko evegapiato aonai, tanopara maparana mukuna na egapi-gavuato; mukuna emiato, pene ago, oragauna 3 koloko. ");
INSERT INTO khz_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Oragauna 3 koloko kavanai Iesu elailaito, netiwato, “Eloi, eloi, lama sabaktani?” ganina, “Au geku Palagu, au geku Palagu, rakagau gaurai au poraokwaniku?” ");
INSERT INTO khz_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iesu laganai geruga-tagowai talimara reketa gekamonagito, ne gekilato, “Iokamonagi, Elia ekeaana.” ");
INSERT INTO khz_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ne talima ta erakato, nanu eromagiana gauna ta egapiato, vine nanuna vevokaina aonai epia-raiato, toki ai ekwanu-kauato, ne etugu-rageato Iesu na ene niua ulanana, netiwato, “Ita gitaa, Elia pene vogomai, penema gapi-rigoa pa?” ");
INSERT INTO khz_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ne Iesu elailaito mulinai ekwaregato. ");
INSERT INTO khz_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ne Rupu Veaga aonai veaga iwavagi kovogana vega-gelogavuna rapugana (ketin) evetovi-kavalugato, kava ruala, kukuna na pene verigo kapulenai. ");
INSERT INTO khz_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Roma vetali velena Iesu wailanai eruga-tagowai, gena lailai ekamonagiato e raka ekwarega-tiwato egitaato, ne ekilato, “Taunatauna vegata, etalima e Palagu Natuna!” ");
INSERT INTO khz_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Garegare reketa maki gemoalewai, kiata rau ai gerugato, aorai Maria, Magadala garena; e Maria, Teimiti keina e Iosepa tinara; e Salome. ");
INSERT INTO khz_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Galileiai egaregare Iesu mulinai gelakawai e ia vetugunagina geago-veniwai. Gare vogo ia ria Ierusalemai gemarageto garera maki vonai. ");
INSERT INTO khz_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Volavilavi velekwa pia kala-maavua, Tapati tomana rogoti ere gapia aonai. ");
INSERT INTO khz_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Iosepa, Arimatea vanuga na talimana, genugagi-rageawai kaonsela aorai talimana ta, Palagu gena Basileia ealoawai talimana, Pilato genai eagoto, ne enogi-namanamaato, Iesu tauniparana pene gapia netiwato. ");
INSERT INTO khz_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ekamonagito Iesu warau ekwaregato, nugana eketo-vagito, gaurai vetali velena ekeaato, erenagiato, netiwato, “Taunatauna, Iesu pekwarega pa?” ");
INSERT INTO khz_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ne vetali velena na Iesu gena kwarega evega-taunataunaato vou, Iesu tauniparana Iosepa eveniato. ");
INSERT INTO khz_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Voia mulinai Iosepa na rapuga kulokulo namana ta evoiato, ne Iesu egapi-rigoato, rapuga na ekumuato. Kala kapuna vatu kovoganai evetao-togaato mulinai, vatu kamuna na vanagi ekule-gavuato. ");
INSERT INTO khz_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria, Magadala garena, e Maria, Iosepa tinana, na etaoato kapuna gegita-veakauato. ");
INSERT INTO khz_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tapati eaikito mulinai, Maria, Magadala garena, e Maria, Teimiti tinana, e Salome mulamula maponana namana gevoiato, pia ago, Iesu tauniparana pia rigaa ulanana. ");
INSERT INTO khz_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Epetoma toma tovotovona pa Sandei, amoamo garo kagena etugu-rageana nea, kalai geagoto. ");
INSERT INTO khz_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ne matotaura gevegupuwai, negetiwato, “Rai na vovatupara kala gekou-gavuagiato, gauna eneve kule-gerevagia?” ");
INSERT INTO khz_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na gepoe-agoto aonai, vovatupara pakai emia-tagowai. ");
INSERT INTO khz_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ira kala kovogana aonai gelaka-togato, malaga valigu ta gegitaato, ripa kavanai etanuto, gena rapuga kulokulo e moga loki, gaurai nugara gegolugolu-rakavato. ");
INSERT INTO khz_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ia na evaikilarato, netiwato, “Ragai iokali, au ripaku gomi Iesu, Nasareta tauna, gesatauroato talimana gotavuana. Ia pekuliiti-wai! Ia enai aikina, getaoato kapuna iomai-gitaa. ");
INSERT INTO khz_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gaurai ioago, gena melo e Petero pio vevega-ripara, nopiotiwa, ‘Iesu pene kune Galileiai. Vonai vou piove gitaa evaikilamito gelegelenai.’” ");
INSERT INTO khz_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ne vogare gelakatito kala aona na, kwalana nugara gegolugoluto e tauniparara gepilupiluwai gaurai. Talima ta maki ati gevaikilaato, kwalana gekalito.  ");
INSERT INTO khz_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Epetoma toma tovotovonai, elagani-mamamaawai, Iesu ekuliiti-waito, ne Maria, Magadala garena, genai evevega-matagai-kuneto. Ia genana palagu rakavara taulatoi kwapuna egui-atirato. ");
INSERT INTO khz_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ia eagoto, ne Iesu mulinai gelakawai talimara geria aovitiviti e tagi aonai evararato. ");
INSERT INTO khz_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Gekamonagito Iesu pemaguli, Maria na egitaato, na gena kila ati gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Voia mulinai ira taura rulala kapu taai geagowai aonai, Iesu geriai evevega-matagaito, na gitagitana eirauto. ");
INSERT INTO khz_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Gaurai taura ruala gewaikuleto, taukavara gevararato, na geria kila ati gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Voia mulinai gena melo gagalana kwapuna geganiganiwai aonai, geriai evevega-matagaito, egolorato, kwalana ati geria kamonagi e geria ao gaoka-poro gaurai, kwalana kwarega na ekuliiti-waito mulinai, gegitaato talimara geria kila ati gevega-taunataunarato. ");
INSERT INTO khz_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ne evaikilarato, netiwato, “Iolakaa, tanopara mapararai Vali Namana taunilimalima maparara wailarai pio vopatagia. ");
INSERT INTO khz_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Rai na eVali Namana pene vega-taunataunaa e bapatiso pene gapia talimana pene maguli, na ati pene vega-taunataunaa talimana Palagu na rakava voina pene venia. ");
INSERT INTO khz_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Gevega-taunataunana talimara evegailia kamura ria pia kwapuna: Ira palagu rakava au araku ai pia gui-atira. Karo valigura irauiraurai pia kila. ");
INSERT INTO khz_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Gelema pia gapi-itira, kwarega garikira pia niura, na ati pia vega-rakavara. Gimara viti talimara atarai pia tao-kaura, ne viti talimara pia nama.” ");
INSERT INTO khz_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Iesu Velekou na evaikilarato mulinai, Palagu na egapi-itiato, kupai everageto, ne Palagu ripana kavanai etanu-talito. ");
INSERT INTO khz_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na Iesu gena melo gelaka-lovolovoto, kapu mapararai geve vopatato. Velekou maki ira ria geinagulu-kouwai, e geria kila evega-taunataunarawai vegailia kamurai. ");
INSERT INTO khz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Vele talimamu Teofilo, goi atalo-venimuna. Taunilimalima vogo na Iesu na ekalarato kalara ita vepakarai gaura valira warau getalorato. ");
INSERT INTO khz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Tovotovonai taunilimalima matara na gegitarato gaura e gevopatagirato valira gelegelerai gevega-riparato. ");
INSERT INTO khz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Gaura pakurai au maki atugamagina, namana evetaina, Vele o, rakagau rakagau gewalato gaura veavugara patavu gitagitara, gaurai gewalato gelegelerai ama talorana goi gemu. ");
INSERT INTO khz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Gaurai ewagumona pono ripa, gevega-ripamuto kilara votaunatauna vegata. ");
INSERT INTO khz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Heroda, Iudea tanoparana evele-agiawai laganinai, Rupu Veaga velena ta etaluwai arana Sakaria, Abia gena kwalu talimana. Garawana arana Elisapeta. Ia maki Aarona kalakalana, Rupu Veaga velena geria kwalu garena. ");
INSERT INTO khz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ira ruala maki kala rorirori talimara Palagu wailanai. Velekou gena rova e vevega-nagi maparaparara gegapi-ragerawai maaora maparara na maki. ");
INSERT INTO khz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na ira ruala vou ati naturia, kwalana Elisapeta maki egaerato, e ira ruala maki warauna gevelepara e logeapara-vagito. ");
INSERT INTO khz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Toma ta Sakaria gena rupu inagulura ekalarawai Palagu wailanai Rupu Veaga aonai, kwalana gena kwalu geria toma pakunai. ");
INSERT INTO khz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Gaurai Rupu Veaga velera geria kala gelegelenai Sakaria gevirigiato, mulamula maponana namana pene kapua. Gaurai elaka-togato Velekou gena Rupu Veaga aonai, ");
INSERT INTO khz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","taunilimalima maparara mulimuli ai gerapaliwai aonai mulamula ekapuato. ");
INSERT INTO khz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aonai Velekou gena aneru ta ia genai ematagaito, mulamula kovuna maponana patapatana veagana ripana kavanai eruga-tagowai. ");
INSERT INTO khz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakaria na egitaato aonai nugana epara-vagito e ekalito. ");
INSERT INTO khz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Na aneru na evaikilaato, netiwato, “Sakaria, ragai pono kali, kwalana gemu rapali Palagu na pekamonagia. Garawamu Elisapeta na natumu ta pene gapia, pono araa, arana Ioane. ");
INSERT INTO khz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Goi pono verere, mapono verere, taunilimalima vogona na maki ia gena wala pia verere-agia. ");
INSERT INTO khz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kwalana Velekou wailanai ia maki vele kamu iwavaginai pene mia. Ia maki vine nanuna ati pene niua e niuniu gaura gaokara maki aikina vagi. Ia tinana tinagenai roe voa, Veaga Palaguna na pene vonu. ");
INSERT INTO khz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ia na Isaraela talimara vogona pene vaiwaikulera Velekou, ira geria Palagu, genai. ");
INSERT INTO khz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Velekou wailanai pene laka Elia peroveta talimana gena kwalimu e gena tiavu vetaina. Tama manatura ia na mapene vega-tanu-koukoura. Karoverave talimarai maki pene vega-tanu-kulera, kala rorirori talimara pia kilagira; ne ia na Velekou gena taunilimalima pene kala maavura.” ");
INSERT INTO khz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria na aneru evaikilaato, netiwato, “Au raka pana ripa-tiwa? Au velepara vagi, garawaku maki logeapara vagi.” ");
INSERT INTO khz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aneru na evega-geleato, netiwato, “Au Gaberiela, Palagu wailanai arugana. Palagu na au petuguku, pana vaikilamu evali namana ea pana varamu. ");
INSERT INTO khz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na au geku kila ati ovega-taunataunaana gaurai, goi murumu pene kapu, ati pono kilakila, pene ago ekila ganina peneve wala tomanai. Akilagirana gaura geria lagani taunataunarai pia wala.” ");
INSERT INTO khz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ekala ewalawai gaurai, taunilimalima gevealo-kavato geveroliveroliwai rakagau gaurai Sakaria Rupu Veaga aonai warigi ekwaipo-gitato. ");
INSERT INTO khz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Elakatito aonai, ira ati evega-vegupurato, gaurai geripato, ia epoe-karaleto, rakagau kwauta egitaato Rupu Veaga aonai. Gaurai ia gimanaimo ira evega-riparato, ati ekilakilato, kwalana ia muruna ekaputo. ");
INSERT INTO khz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakaria gena votoma inagulura Rupu Veaga aonai gaura evega-aikirato mulinai, ewaikuleto gena vanugai. ");
INSERT INTO khz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Voia mulinai ia garawana Elisapeta warauna ekuviato, gaurai uve imaima numai etalu-veavugato. ");
INSERT INTO khz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ekilato, “Velekou na penugagivitiku, evetaina au geku ai pekalagia. Geku nugarage taunilimalima wailarai pegapi-pakaa.” ");
INSERT INTO khz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisapeta matinagena uve taula toitoi aonai, Palagu na aneru ta arana Gaberiela etuguato vanuga ta Galileia aonai arana Nasareta. ");
INSERT INTO khz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Vavine ta vonai. Ia mataogavuna arana Iosepa, Davida gena kwalu. Vovavine arana Maria. ");
INSERT INTO khz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneru ia genai eagoto, evaikilaato, “Maino goi gemu ai, Velekou goi goti e gena vega-nama para goi gemu ai.” ");
INSERT INTO khz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria na ekila ekamonagiato aona warigi evekwalavi-gitato, etugamagito evega-nama ganina eerakagau. ");
INSERT INTO khz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aonai aneru na maevaikilaato, netiwato, “Maria, ragai pono kali, Palagu gena vega-nama goi atamu ai petaoa. ");
INSERT INTO khz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Goi pono kuvia melo ta pono gapia, pono araa, arana Iesu. ");
INSERT INTO khz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ia arana peneve rage e pia kilagia Goloka Iwavagi Palaguna Natuna. Palagu talutalu na king ai pene vega-agoa, ia kalakalana Davida vetaina. ");
INSERT INTO khz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ia Vele Taputapu ai pene ago, vele talutalu Iakobo petena geria, gena Basileia ati pene aiki.” ");
INSERT INTO khz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria na aneru evaikilaato, netiwato, “Eeraka pene wala-tiwa? Au tau ta goti rogoti gara genokou.” ");
INSERT INTO khz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aneru na evega-geleato, netiwato, “Veaga Palaguna goi atamu ai pene kwara, Palagu tiavuna na pene porogimu. Vovetainai goi gemu na pene wala melona maveagana Palagu Natunai pia kilagia. ");
INSERT INTO khz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Pono ripa, goi vavine kavamu Elisapeta, warauna pelogeapara vagi, na matinagena. Ripamu, taunilimalima na gekilagiawai, ia kapakovago garena negetiiwai, na etoma ia gena uve taula toitoi ea. ");
INSERT INTO khz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kwalana Palagu gau maparara kalakalara ripana.” ");
INSERT INTO khz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria ekilato, “Au Velekou gena vetugunagi vavineku, pe pokilagia vetainai geku ai pene wala.” Ne aneru na eraokwaniato, elakato. ");
INSERT INTO khz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Oranaimo Maria ekuliitito, Iudea golo vanugana gautai elakato. ");
INSERT INTO khz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Vonai Sakaria gena numai everageto, Elisapeta evega-namaato. ");
INSERT INTO khz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisapeta na Maria gena vega-nama kilana ekamonagiato natuna ia tinagenai ekalavo-kalavoto, aonai Elisapeta Veaga Palaguna na evega-vonuato, mamina egapiato. ");
INSERT INTO khz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ne ekila-kamukamuto, netiwato, “Vavine maparara aorai Palagu gena vega-nama goi atamu ai kamu iwavagi, e pono gapia melona atanai maki! ");
INSERT INTO khz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na au geku nama rakagau gaurai Velekou tinana au geku ai pevogomai? ");
INSERT INTO khz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gemu vega-nama kilana pakamonagia aonai, natuku tinageku ai evererena gaurai ekalavona. ");
INSERT INTO khz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Goi overerena, kwalana ovega-taunataunato, Velekou gena kila pene vuvuka notiwato.” ");
INSERT INTO khz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ne Maria ekilato, “Au aoku na Velekou evega-rageana. ");
INSERT INTO khz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Au palaguku na maki au evega-magulikuna Palaguna everere-veniana, ");
INSERT INTO khz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kwalana au, gena vetugunagi vavinena, geku talu lealeai roe tugamagi-tagokuna! Ewagumona, pene ago, gulu maparara Palagu gena vega-nama au ataku ai nepiatiwa, ");
INSERT INTO khz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kwalana kala kamu iwavagira Tiavu Palaguna na au geku ai pekalara. Ia arana veaga. ");
INSERT INTO khz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gena vetuga ia kalina na gekalina talimara atarai pene taoa, pene ago gulu maparara aorai. ");
INSERT INTO khz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ia gimana egapi-itirato tiavuna na veagi talimara eako-lovolovorato. ");
INSERT INTO khz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ia na vele kamura geria tanutanu kapura na eroli-piarigorato, na ati gevega-agirana talimara egapi-itirato. ");
INSERT INTO khz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Vito talimara maki gau namara na evega-vonurato, na rinaga talimara ia na gimara kovagora etugu-waikulerato. ");
INSERT INTO khz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gena kilagavu ita tupura e gatara Isaraela talimara geriai ati etugamagi-lekwalekwarato, e ia evogomaito gena vetugunagi talimara Isaraela pene veakavara ulanana, ");
INSERT INTO khz_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kalakalara ekilagavu-venirato gelegelena. Aperaamo makalakalana pene vetuga-vanagivanagira, netiwato.” ");
INSERT INTO khz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria vonai Elisapeta goti uve toitoi getalu-agirato. Mulinai gena vanugai ewaikule-waito. ");
INSERT INTO khz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisapeta gena gapi tomana warau ekwarato gaurai, melo ta egapiato. ");
INSERT INTO khz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ne lagana talimara e gena talimana valina gekamonagiato ia ria geverere-koukouto, kwalana Velekou gena vetuga kamu ia genai ewalato gaurai. ");
INSERT INTO khz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Toma vega-taula vativatinai melo tauniparana kopina kiata pia voro-vagia ulanana getanu-kouto. Votoma maki arana pia keaa Sakaria, tamana arana pia kea-vanagia negetiwato. ");
INSERT INTO khz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Na tinana ati eririwato gaurai ekilato, “Aikina! Ia arana Ioane.” ");
INSERT INTO khz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ira gekilato, “Na goi na pamili aonai neara aikina!” ");
INSERT INTO khz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aonai irana melo tamana gimaraimo gerenagiato, melo arana rai nepiatiwa. ");
INSERT INTO khz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria na talotalo gauna eririwaato, ekilagiato, geveniato, gaunai evetaina etaloato, “Ia arana Ioane.” Aonai maparara gevevega-kalito. ");
INSERT INTO khz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Vonai vou muruna evekala-pakato, maena maki evelugato, ne ekilakilato Palagu evega-namaato. ");
INSERT INTO khz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aonai lagana talimara maparara gevevega-kalito vokala valina Iudea golo vanugara maparara aorai eraka-lovolovoto. ");
INSERT INTO khz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Valina gekamonagiato talimara maparara na getugamagiato, gekilato, “Emelo rakavetaina?” Kwalana Velekou gimana tiavuna ia atanai. ");
INSERT INTO khz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ioane tamana Sakaria Veaga Palaguna na evega-vonuato, gaurai Palagu gena kila evega-matagaiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Velekou, Isaraela talimara geria Palagu, ita vega-namaa, kwalana ia gena kwalu talimara evogomai-veniarato pene voi-waikulera e pene vega-magulira ularana. ");
INSERT INTO khz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Vevega-maguli talimana matiavuna goti etuguato ita gera, ia gena vetugunagi talimana Davida kalakalana. ");
INSERT INTO khz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ekilagavu ia gena peroveta talimara veagara na rauvagi gekilagi-matagaiato: ");
INSERT INTO khz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ita ia na ekilagi-gavurato, gevekuku-venirana e geparu-venirana talimara gimara na pene vega-magulira netiwato. ");
INSERT INTO khz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ekilato maki, ita tupura gatara pene vetugara, e gena kilagavu veagana ati pene tugamagi-lekwalekwaa. ");
INSERT INTO khz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ia na ita kalakalara Aperaamo ekilagavu-veniato, ");
INSERT INTO khz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","netiwato, gevekuku-venirana talimara gimara na pene vaimagulira. Gaurai vetugunagina pita ago-venia, ati kalira. ");
INSERT INTO khz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Wailanai pita laka maveagara e marorirorira maki gera maguli tomara mapararai. ");
INSERT INTO khz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Natuku o, goi maki Goloka Iwavagi Palaguna gena peroveta talimanai pia kilagimu, kwalana pono laka-kune Velekou gena raupara pono kala-maavua ulanana. ");
INSERT INTO khz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gena kwalu talimara pono vega-ripara, ia na geria rakava pene tugamagi-piatogara e pene vega-magulira. ");
INSERT INTO khz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwalana ita gera Palagu gena vetuga kamu ita gerai. Garo eragena maekana vetaina vevega-maguli ita atarai pene mia. ");
INSERT INTO khz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ne mukunai e kwarega aonai getaluna talimara maeka na pene rala-talira, maino rauparanai pene vaira.” ");
INSERT INTO khz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ioane ekamuto mapalaguna e matiligana. Tanoleanai etaluwai, pene ago Isaraela talimara geriai ematagaito tomana. ");
INSERT INTO khz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Volaganinai Kaisara Augusto, Roma geria vele, na gena kilakila etuguato, tanopara talimara maparara arara pia talora, tentiti (census) pia gapia. ");
INSERT INTO khz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tentiti tovotovona voa, Kurinio na Siria evele-agiawai laganinai gegapiato. ");
INSERT INTO khz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Gaura pakurai taunilimalima maparara arara talotalora ularana kwapurakwapura geria vanuga taunataunarai gewaikuleto. ");
INSERT INTO khz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Iosepa maki elakato. Nasareta, Galileia kavana vanugana taa na, Betelehemai eagoto, Iudea kavana vanugana ta, Davida gena vanuga. Vonai eagoto, kwalana ia Davida gena kwalu talimana. ");
INSERT INTO khz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Vonai arana pia taloa ulanana, ia tao-gavuna Maria goti geagoto. Ia matinagena. ");
INSERT INTO khz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ira ruala vonai getaluwai aonai, gena gapi tomana ekwarato. ");
INSERT INTO khz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ia egapito, natuna kunena maru, rapuga na ekumuato, polomakau garia ganigani tapilana aonai evega-maoko-rigoato, kwalana wariwari talimara geria numa gevonuto gaurai. ");
INSERT INTO khz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Vokapu ai mamoe gegita-tagorawai talimara reketa uraurai getaluwai, pogi airana geria mamoe gegita-tagorawai. ");
INSERT INTO khz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Aonai Velekou na aneru ta ira geriai ekwarato, Velekou maekana na ewae-talirato; gekali-rakavato, ");
INSERT INTO khz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","na aneru na evaikilarato, netiwato, “Ragai pio kali! Vali Namana au na pavuamaia gomi gemi, taunilimalima maparara pene vega-vererera valina. ");
INSERT INTO khz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Etoma Davida na vanugai gemi vevega-maguli Velena pewala, Keriso Velekou! ");
INSERT INTO khz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Vegailiana evetaina, melo ralarala pio rawalia polomakau geria ganigani tapilana aonai emaoko-tagona, rapuga na pege kumua.” ");
INSERT INTO khz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ne veganamo kupa anerura gutuma eaneru kwapuna ria gegoto-kwarato, Palagu gevega-namaato, negetiwato, ");
INSERT INTO khz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kupa atagaina raimoraimonai Palagu pia vega-ragea, e tanoparai maino ia na eao-namarana talimara na pia gapia!” ");
INSERT INTO khz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneru maparara na geraokwanirato, kupai gewaikuleto mulinai, mamoe gitatagora talimara gekila-kouto, negetiwato, “Ita Betelehemai ita ago, Velekou na pevega-ripara gauna itave gitaa.” ");
INSERT INTO khz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gaurai gelakato, Maria e Iosepa gerawalirato, melo keina maki polomakau garia ganigani tapilana aonai maokotagonai gerawaliato. ");
INSERT INTO khz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Melo gegitaato, aneru na gevega-riparato vetainai valina gevaravaragiato. ");
INSERT INTO khz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na gekamonagito talimara maparara mamoe gegita-tagorawai talimara geria kila na nugara evega-keto-vagirato. ");
INSERT INTO khz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria na vokilara maparara aonai etaorato e etugamagirawai. ");
INSERT INTO khz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mamoe gegita-tagorawai talimara gewaikuleto, Palagu gevega-rageato, e gevega-namaato, kwalana gekamonagirato e gegitarato gaura taunatauna, aneru na ira evega-riparato gelegelenai. ");
INSERT INTO khz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Toma taula vativatinai, melo tauniparana kopina kiata pia voro-vagia tomanai, ia gearaato arana, Iesu. Tinana na rogoti ekuviagia aonai, aneru na ekilagiato arana gekeaato. ");
INSERT INTO khz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Melo ewalato toma gagala vativati (40) mulirai, ira geria vekala-aleva tomana ekwarato, Mose gena rova na ekilagiana gelegelenai. Gaurai Iosepa e Maria na Iesu Ierusalemai gelakagiato, Velekou wailanai pia vega-matagaia ulanana. ");
INSERT INTO khz_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kwalana Velekou gena rova na ekilagiana, “Malita melora maparara veaga Velekou gena.” ");
INSERT INTO khz_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Velekou gena rova gelegelena veveni gaura pia veni negetiwato, pune natura ruala. ");
INSERT INTO khz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Talima ta Ierusalemai etaluwai, arana Simeona. Ia kala rorirori talimana e Palagu gena rova ekwalanarawai talimana. Ia na Isaraela gena vevega-maguli ealo-tagoawai e Veaga Palaguna na evega-vonuato. ");
INSERT INTO khz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Veaga Palaguna na maki evaikilaato, netiwato, ia ati pene kwarega, Keriso (Palagu na ekilagi-gavuato vevega-maguli talimana), pene gitaa vou. ");
INSERT INTO khz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Veaga Palaguna na Rupu Veaga aonai Simeona evaitogaato vou, Iesu tamana e tinana na gevaitogaato, rova na ekilagiana kalana pia kalaa ulanana. ");
INSERT INTO khz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Gaurai Simeona na melo egapiato, epaniato, Palagu evega-namaato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Velekou, gemu vetugunagi talimana ewagumona vou pono tugu-piatogaku mamainoku pana laka gemu kilagavu gelegelenai. ");
INSERT INTO khz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Warauna gemu vevega-maguli tiavuna mataku na pama gitaa, ");
INSERT INTO khz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","goi na okala-maavurato taunilimalimara maparara wailarai. ");
INSERT INTO khz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Maeka ea, ati Iuda talimara vega-maekagira, e goi gemu kwalu Isaraela vega-ragera ulanana.” ");
INSERT INTO khz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Melo tamana e tinana na Simeona gena kila gekamonagiato, gevevega-kalito. ");
INSERT INTO khz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ne Simeona na ira ruala evega-namarato, Maria evaikilaato, netiwato, “Emelo na, Isaraela talimara gutuma vega-ketora e vega-kuliitirai pene ago. Ia vegailia ta Palagu genana, taunilimalima gutuma na pia kilagi-piatogaa, ");
INSERT INTO khz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","votaunilimalima vetaira aora veavugara gaura maparara piave matagai. Goi, Maria, maki vitiviti ati keikeina pono rawalia, noowane nugamu garakauna kativana pia kwanua vitina vetaina.” ");
INSERT INTO khz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vonai peroveta garena ta arana Ana. Ia Panuela natuna, Asere gena kwalu garena. Ia evegarawato, rigolo taulatoi kwapuna garawana goti getaluto, ");
INSERT INTO khz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ne ewaputo, rigolo gagala taula vativati e vativati (84) etalu-agirato, warauna elogeaparato. Rupu Veaga ati eraokwaniawai, pogi, lagani Palagu ealiruputali-veniawai, erapaliwai e evokawai. ");
INSERT INTO khz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Voora kianai ia maki ekwarato, aonai Palagu evega-namaato, Ierusalema vaimagulina gealoawai talimara wailarai emelo valina evaravaragiato. ");
INSERT INTO khz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Iosepa e Maria Velekou na rova ekilagirato kalara maparara gekalarato mulinai, Galileiai gewaikuleto, geria vanuga Nasaretai. ");
INSERT INTO khz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Emelo ekamuto makwalimuna maki; Palagu gena aoneka na evonuvonu-rageto e gena vega-nama kamu ia atanai. ");
INSERT INTO khz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Rigolo mapararai Iesu tamana e tinana Ierusalemai gelakawai, Pasova velekwana ulanana. (Iuda talimara kwarega aneruna na elaka-vanagirato, ati evagirato velekwana). ");
INSERT INTO khz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu rigolona gagalana ruala egapiato matamana e matinana velekwa ulanana gelakato, gekalawai vetaina. ");
INSERT INTO khz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Velekwa eaikito mulinai, gewaikule-waito geria vanugai, na ira ati riparia, Iesu Ierusalemai geraokwaniato. ");
INSERT INTO khz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ira geria tugamagi Iesu ira ria. Toma kwapuna gelakagiato mulinai, walakavaria e gataria aorai getavuawai. ");
INSERT INTO khz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Gevetavuto aonai ati gerawaliato, gaurai gewaikule-waito Ierusalemai. Iesu tavutavuna ulanana. ");
INSERT INTO khz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Toma toitoi mulinai, Iesu gerawaliato Rupu Veaga aonai Iuda talimara geria vevega-ripa talimara ria. Palagu gena kila gekilagirawai, e ekamonagirawai e vokila ganina rakagau, everenagi-agirawai. ");
INSERT INTO khz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Maparara Iesu gena verenagi e vega-gele kilara gekamonagirato, gevevega-kali-rakavato. ");
INSERT INTO khz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Iesu tamana e tinana na enai gerawaliato aonai, nugara gepale-vagito, gaurai tinana na evaikilaato, netiwato, “Natuku, rakagau gaurai evetaina pokalamai? Goi tamamu e au goi pakumu ai rauparamai maki pege vekou, raka pomia-tiwa napagatiwa.” ");
INSERT INTO khz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iesu na evakilarato, “Rakagau gaurai au gotavukuna? Gomi ati ripami, au tamaku gena numai?” ");
INSERT INTO khz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Na ira ati ripara, rakagau gaurai Iesu evetaina evega-geleto. ");
INSERT INTO khz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Voia mulinai Iesu matamana e matinana Nasaretai gewaikule-waito. Geria kila maparara ekamonagirato e, ekala-venirato. Egaura gewalato maparara Maria aonai etaorato etugamagi-tagorawai. ");
INSERT INTO khz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iesu ekoloato maaonekana maki, Palagu e taunilimalima na maki geririwaawai. ");
INSERT INTO khz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberia Kaisara, Roma geria vele, rigolo gagalana imaima (15) evele-agirato aonai Pontio Pilato, ia Iudea geria Kavana, Heroda, ia Galileia velena, tarina Filipo, ia Iturea e Trakoniti kapura geria vele, Lisania, ia Abilene velena. ");
INSERT INTO khz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas e Kaiapa ira Rupu Veaga velera kamura. Volaganinai Palagu na Ioane Sakaria evaikilaato tanoleanai. ");
INSERT INTO khz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aonai Ioane Ioridana waina kapura mapararai elakalakawai, evopatawai, taunilimalima geria rakava aora na pia vetugamagiwai e pia laka-waikule Palagu genai, e bapatiso pia gapia, Palagu na geria rakava pene tugamagi-piatogara ularana. ");
INSERT INTO khz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaia, peroveta talimana, gena pukai etaloato gelegelenai, netiwato, “Talima ta tanoleanai ekeana, netina, ‘Velekou gena raupara ioalevaa, gena vogomai rauparana iovega-roriroria. ");
INSERT INTO khz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Poga maparara pene vega-vonura, golo kamura e gologolo keira maparara pene kala gelegelera. Raupara teetetera maparara pio vega-rorirorira, raupara ropuropura maki pio vega-vonura. ");
INSERT INTO khz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aonai taunilimalima maparara na Palagu gena vevega-maguli pia gitaa!’” ");
INSERT INTO khz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Taunilimalima gutuma Ioane genai geagoto, pene bapatisora ulanana. Na Ioane na evaikilarato, netiwato, “Gomi warowaro natura, rai na pevaikilami, Palagu gena Kota kamuna tomana genana pio kali-maguli? ");
INSERT INTO khz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gemi rakava na pio vetugamagiwai, ne gemi maguli ai vuavua namara pio vega-walara, e ragai pio kila, ‘Aperaamo ai tamamai, (pe Palagu na pene gapi-ragemi).’ Kwalana pio ripa, Palagu matiavuna, Aperaamo natuna evatu geriana pene vega-walara! ");
INSERT INTO khz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Giro gautupu kwalarai warau pege taora; gaura pakurai vuavua namara ati gevega-walarana gautupura maparara pia patira, kalovai pia pia-ragera.” ");
INSERT INTO khz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tanukou talimara na Ioane gerenagiato, negetiwato, “Na ai rakagau paia kala?” ");
INSERT INTO khz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ia na evega-gelerato, netiwato, “Gomi raira gemi rogagirogagi gaura rualana genai, taarana ati gena talimana pio venia, e magana ganigani talimana maki vovetaina pene kala.” ");
INSERT INTO khz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takiti koko talimara maki bapatiso pia gapi ulanana Ioane genai geagoto, gerenagiato, negetiwato, “Vevega-ripa talimamu o, ai raka paia kala-tiwa?” ");
INSERT INTO khz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ia na evega-gelerato, netiwato, “Rova ekilana rorinaimo pio koko.” ");
INSERT INTO khz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Vetali talimara na maki gerenagiato, negetiwato, “Ai maki raka paia kala-tiwa?” Ia na evega-gelerato, netiwato, “Talima geria moni ragai pio verarira e ragai pio vaikila-rakavara. Gomi voimi pakurai maki ragai pio munemune.” ");
INSERT INTO khz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Taunilimalima aorai evetaina getugamagito, “Etalima e Keriso, (Palagu na ekilagi-gavuato vevega-maguli talimana) pa,” negetiwato. ");
INSERT INTO khz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aonai Ioane na maparara evaikilarato, netiwato, “Au na gomi nanu na abapatisomina, na talima ta pene vogomai, ia gena tiavu na au geku tiavu evanagiana. Au ati gelegele ia gena tamaka walona pana lugaa. Ia na Veaga Palaguna e kalova na pene bapatisomi. ");
INSERT INTO khz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ia gimanai aleva-aleva gauna, vuiti momona e vuiti ganina genana pene aleva-gitagitara ulanana. Vuiti taokouna numanai pene tao-koua, na vuiti momona vou pene kapua ati eputena kalovanai.” ");
INSERT INTO khz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ioane na ekilakila e makila reketa aora na Palagu Valina Namana taunilimalima geria evopatagirato, e enogirato, geria rakava aora na pia vetugamagiwai. ");
INSERT INTO khz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ioane na Heroda, Galileia velena, maki ekilagi-rakavaato, kwalana ia kakana Filipo garawana etavarariato, e kala rakavara vogovagi ekalarato gaura pakurai. ");
INSERT INTO khz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Heroda na vorakava maparara atarai ta maetao-kauato, Ioane tipura numanai ekana-gavuato. ");
INSERT INTO khz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Taunilimalima maparara Ioane na ebapatisorawai aonai, Iesu maki ebapatisoato. Ne Iesu erapaliwai aonai, kupa evekala-pakato. ");
INSERT INTO khz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Veaga Palaguna ema rigoto ia atanai, noo pune vetaina. Karo ta kupa na ekea-rigoto, netiwato, “Goi au Natuku, warigi aulamagi-gitamuna; goi na au maki ovega-vererekuna.” ");
INSERT INTO khz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesu gena inagulu tovotovona etinaato aonai, ia rigolona gagala toitoi (30). Taunilimalima na gekilagiawai ia Iosepa natuna. Kalakalana ea: Iosepa ia Heli natuna, ");
INSERT INTO khz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli ia Matat natuna, Matat ia Levi natuna. Levi ia Melki natuna, Melki ia Ianai natuna. Ianai ia Iosepa natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosepa ia Matatia natuna, Matatia ia Amosa natuna, Amosa ia Nahum natuna, Nahum ia Eseli natuna, Eseli ia Nagai natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ia Mahat natuna, Mahat ia Matatia natuna. Matatia ia Semein natuna, Semein ia Ioseka natuna, Ioseka ia Ioda natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ioda ia Ioanan natuna, Ioanan ia Resa natuna, Resa ia Serubabele natuna. Serubabele ia Sealtiele natuna. Sealtiele ia Neri natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ia Melki natuna. Melki ia Adi natuna. Adi ia Kosam natuna. Kosam ia Elmadam natuna. Elmadam ia Ere natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere ia Iosua natuna. Iosua ia Eliesere natuna. Eliesere ia Iorim natuna. Iorim ia Matat natuna, Matat ia Levi natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi, ia Simeona natuna. Simeona ia Iuda natuna. Iuda ia Iosepa natuna, Iosepa ia Ionam natuna, Ionam ia Eliakim natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ia Melea natuna, Melea ia Mena natuna, Mena ia Matata natuna, Matata ia Natan natuna, Natan ia Davida natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davida ia Iese natuna, Iese ia Obed natuna, Obed ia Boas natuna, Boas ia Salmon natuna, Salmon ia Nasona natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasona ia Aminadab natuna, Aminadab ia Admin natuna, Admin ia Areni natuna, Areni ia Hesron natuna, Hesron ia Perese natuna, Perese ia Iuda natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Iuda ia Iakobo natuna, Iakobo ia Isaako natuna, Isaako ia Aperaamo natuna, Aperaamo ia Tera natuna, Tera ia Nahoro natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoro ia Serug natuna, Serug ia Reu natuna, Reu ia Peleg natuna, Peleg ia Ebere natuna, Ebere ia Sela natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ia Kainana natuna, Kainana ia Afasada natuna, Afasada ia Sem natuna, Sem ia Noa Natuna, Noa ia Lameka natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameka ia Metusela natuna, Metusela ia Enoka natuna, Enoka ia Iared natuna, Iared ia Mahalalel natuna, Mahalalel ia Kainana natuna. ");
INSERT INTO khz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainana ia Enos natuna, Enos ia Seta natuna, Seta ia Adamu natuna, Adamu ia Palagu natuna. ");
INSERT INTO khz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Ioridana wainai Veaga Palaguna na evega-vonuato mulinai, ewaikule-waito, tanoleanai Veaga Palaguna na evaiagoato. ");
INSERT INTO khz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Vonai toma e pogi gagala vativati (40) Tiapolo na ekalatovoawai. Votoma maparara aorai ia ati eganiganiwai, gaura pakurai votoma geaikito mulirai ia evito-rakavaato. ");
INSERT INTO khz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tiapolo na ia evaikilaato, netiwato, “Pene goi Palagu Natuna genai, evatu ono vaikilaa, pene gauganigani.” ");
INSERT INTO khz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na Iesu na evega-geleato, netiwato, “Veaga Pukana aonai evetaina ekilana, ‘Taunilimalima ati gauganigani namo pia maguli.’” ");
INSERT INTO khz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aonai Tiapolo na Iesu evairageato golo ta kukunai tanopara basileiara maparara veganamo evega-gitaato. ");
INSERT INTO khz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tiapolo na evaikilaato, “Au na tiavu pana venimu, egaura maparara pono gita-tagora, aramu maki pene kamu. Egaura maparara au geku, gaurai au na aririwaana talimana pana venia. ");
INSERT INTO khz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pene goi na au pono aliruputali-veniku genai, egaura maparara pono gapira goi gemu.” ");
INSERT INTO khz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Na Iesu na evega-geleato, netiwato, “Puka Veaga aonai evetaina getaloato, ‘Velekou, goi gemu Palagu pono aliruputali-venia, iamo geregana vetugunagina pono kalaa!’” ");
INSERT INTO khz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ne Tiapolo na Ierusalemai evaiagoato, Rupu Veaga kukunai evega-rugakauato, evaikilaato, “Pene goi Palagu natuna, eanana ono puri-rigo, ");
INSERT INTO khz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kwalana Puka Veaga aonai evetaina ekilana, ‘Palagu na gena aneru pene vaikilara, goi pia malamu.’ ");
INSERT INTO khz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Maekilagiana maki, ‘Aneru na pia gopemu, pia gapi-itimu, irauna gagemu vatu ai oputu-kauana.’” ");
INSERT INTO khz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu na evega-geleato, netiwato, “Puka Veaga aonai maki ekilagiana, ‘Velekou goi gemu Palagu, ragai pono kalatovoa.’” ");
INSERT INTO khz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tiapolo gena vekalatovo kalara maparara evega-aikirato, ia eraokwaniato, pene ago toma ta. ");
INSERT INTO khz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iesu maewaikuleto Galileiai, Veaga Palaguna tiavuna maki ia ria. Ia valina Galileia tanona aonai gepia-lovolovoato. ");
INSERT INTO khz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iesu ira geria rupu aorai evevega-ripawai, maparara na gevega-rageato. ");
INSERT INTO khz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ne Iesu Nasaretai elakato. Ia ekamuto vanugana. Vanagivanagi ekalawai kalana Tapati tomarai ia rupu ai elakawai. Puka Veaga pene agia ulanana erugaitito aonai, ");
INSERT INTO khz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Isaia peroveta talimana gena puka rupu gitatagona talimanana Iesu eveniato, ia na ekule-pakaato, pene agia kapuna erawaliato, eagiato, evetaina ekilana, ");
INSERT INTO khz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Velekou Palaguna au geku ai ea, kwalana ia na au eporogikuto, e evirigikuto, Vali namana lealea talimara geriai pana vopatagia. Etugukuto, eligorato talimara geriai Palagu na geligorato talimara elugarato valina pana varavaragia ulanana, e mata-kele talimara matara pia alira. Gevega-rakavarana talimara pana vega-magulira, ");
INSERT INTO khz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","e Velekou na taunilimalima pene vega-magulira laganina pana vopatagia.” ");
INSERT INTO khz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Aonai Iesu na Puka ekou-gavuato, rupu gitatagona talimana eveni-waikuleato, ne etanu-talito. Rupu aonai talima maparara na ia gegita-kalakalaato. ");
INSERT INTO khz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iesu na evopata-venirato, netiwato, “E kilakila pogo kamonagia kilana etoma pevuvuka.” ");
INSERT INTO khz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ne maparara na gevega-namaato e gevega-rageato, kwalana kila namaramo ekilagirato. Gaura pakurai, ira matotaura geverenagito, negetiwato, “Ia e Iosepa natuna pa?” ");
INSERT INTO khz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ne Iesu na evaikilarato, netiwato, “Au ripaku gomi na evegavutina kilana au pio varaku, nopiotiwa, ‘Toketa talimamu, matotaumu pono vevega-maguli! Kaperanaumai okalarato kalara valira gama kamonagirato, pe enai gemu vanuga kwalanai maki pono kala.’” ");
INSERT INTO khz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Avaikila-taunataunamina, peroveta talimana gena vanuga kwalanai ati pia gapi-ragea. ");
INSERT INTO khz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Eia maki pio kamonagia: Taunatauna, Elia laganinai wapu vogovagi Isaraelai getaluwai. Rigolo toitoi e uve taula toitoi aorai gura ati eketowai, tanopara maparana erogeato. ");
INSERT INTO khz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Na Isaraela wapura geriai Palagu na Elia ati etuguato. Kapu gerevagina vanugana ta arana Sarefata, Sidona tanoparanai, wapu ta genai etuguato. ");
INSERT INTO khz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Elisa, peroveta talimana, laganinai lepera talimara vogovagi Isaraelai getaluwai, na ta vagi ati evega-namaato, Naaman, Siria talimanamo geregana evega-namaato. ");
INSERT INTO khz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Rupu ai getanu-kouto talimara maparara na vokila gekamonagiato, geparu-rakavato. ");
INSERT INTO khz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Gaurai gekuliitito, Iesu vanuga aona na gerolo-atiato, geria vanuga gekiniato golona kavata ropa-kareketo voanana pia pia-rigoa negetiwato. ");
INSERT INTO khz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Na Iesu ira nuganugara na elaka-gerevagito, ne elakato. ");
INSERT INTO khz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iesu Kaperanauma, Galileia vanugana taai, everigoto. Tapati tomanai evevega-ripato. ");
INSERT INTO khz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ia gena vevega-ripa kilara taunilimalimana gekamonagirato, gevevega-kaliagirato, kwalana gena kilakila matiavura. ");
INSERT INTO khz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Rupu aonai palagu rakavana eporogiato talimana ta etanu-tagowai. Ia ekogo-lailaito, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iesu, Nasareta talimamu o, rakagau ono kala ai gemai notina? Goi ai ono vega-rakavamai ulanana povogomai pa? Au ripaku, goi Palagu gena Veaga Talimamu.” ");
INSERT INTO khz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu na ekila-waiato, netiwato, “Kulumu, ia aona na ono laka-paka!” Gaurai palagu rakavana ia tano ai taunilimalima wailarai erara-taliato, ia aona na elaka-piatito, ia mako ta ati erawaliato. ");
INSERT INTO khz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na Taunilimalima maparara gevevega-kalito, ira matotaura gevevaikilato, negetiwato, “Eerakagau ekilagiana? Matiavuna e makwalimuna na palagu rakava evaikalarana, gelaka-piatina!” ");
INSERT INTO khz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ne Iesu valina kapu maparaparanai eraka-lovolovoto. ");
INSERT INTO khz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu rupu eraokwaniato, Simona na numai elakato. Simona gena tegama garena evitiato, tauniparana etiavu-rakavato; gaurai Iesu genogiato pene veakavaa. ");
INSERT INTO khz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iesu eagoto vogare laganai eruga-talito, viti ekila-waiato, ne viti eaikito. Gare na veganamo etanuitito, ne ira egupurato. ");
INSERT INTO khz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Garo everigoawai aonai, taunilimalima na viti irauirau talimara maparara Iesu genai gevaiagorato. Ia gimana ira kwapurakwapura atarai etao-kauawai evega-namarawai. ");
INSERT INTO khz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Palagu rakavara maki taunilimalima vogo aora na gelaka-piatito, ne palagu rakavara gekogoto, negetiwato, “Goi Palagu Natuna!” Na Iesu na evaikilarato ragai pia kilakila, kwalana ira riparia Iesu ia Keriso, (Palagu na ekilagi-gavuato vevega-maguli talimana). ");
INSERT INTO khz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Elaganiato, Iesu etogaitito, kapu pakanai elakato. Taunilimalima na getavuawai, geverawaliato, gegapi-gaugauato ati geririwato ia na ira pene raokwanira. ");
INSERT INTO khz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Na Iesu na evaikilarato, netiwato, “Au vanuga irauirau ai maki pana vopata, Palagu gena Basileia valina namana pana varavaragia, kwalana au Palagu na etugukuto ganina voa.” ");
INSERT INTO khz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ne Iudea aonai rupu mapararai evopatawai. ");
INSERT INTO khz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Toma ta Iesu Genesareta kovuna pipinai eruga-tagowai, taunilimalima na geruga-makeato, Palagu gena kila pia kamonagia ulanana. ");
INSERT INTO khz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ia na gati ruala egitarato, taitari ai gegapitoma-ragerato; vetavu talimara na geraokwanirato, ira geria leke gealevarawai. ");
INSERT INTO khz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na Iesu vogati gautai eragekauto, Simona gena gati. Ia na Simona evaikilato, gati kiata pene rokoati-lagia nanu ai. Ia gati ai etanu-talito, gutuma evega-riparawai. ");
INSERT INTO khz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ekilakila-gatuto mulinai, ia na Simona evaikilaato, netiwato, “Gemi gati ropu ai ioago-agira, pe gemi leke pio piara, magani piatoga.” ");
INSERT INTO khz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simona na evega-geleato, netiwato, “Vevega-ripa talimamu o, ai paga vekwalavi lagani, magani ta vagi ati paga rawalia, na gemu kila pakunai leke ana piara.” ");
INSERT INTO khz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne gepiarato, magani vogo galagala vagi getogato, geria leke maki roli geveraleto. ");
INSERT INTO khz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Vovetaina gaurai taukavaria gati gautai gelaorato, pia vogomai, ira pia veakavara ulanana. Gevogomaito, gati ruala voa gevega-vonurato, roli gepuluwai. ");
INSERT INTO khz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simona Petero na vokala ewalato gauna egitaato, ne Iesu gagena kwalanai etiu-talito evaikilaato, netiwato, “Velekou, ono laka-paka au gekuna, au galama talimaku.” ");
INSERT INTO khz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kwalana ia mataukavana maparara gevevega-kali-rakavato, magani vogo vavagina gelekerato gaurai. ");
INSERT INTO khz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simona goti gevetavukouto talimara maki Teimiti e Ioane, Tepetaio natuna gevevega-kali-rakavato. Iesu na Simona evaikilaato, netiwato, “Ragai pono kali, ewagumona vegata pene ago goi taunilimalima vetavurai pono ago.” ");
INSERT INTO khz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ne gati gau ruala taitari ai gegoli-ragerato, geria gau maparara geraokwanirato, Iesu mulinai gelakakauto. ");
INSERT INTO khz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Toma ta Iesu vanuga gauta aonai, vonai talima ta kopina maparana lepera na evaiato. Ia na Iesu egitaato, wailanai evetiu-talito enogiato, netiwato, “Velekou, pene oririwana genai, taunatauna pono kala-alevaku e pono vega-namaku ripa.” ");
INSERT INTO khz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu gimana etugu-agoato, viti talimana enapa-kaulagiato, evaikilaato, “Aririwana, ono nama!” veganamo lepera eaikito. ");
INSERT INTO khz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iesu na evaikilaato, netiwato, “Talima ta ragai pono vega-ripaa.” Maevaikilaato, “Ono laka, Rupu Veaga velena na pene gitamu, e vealeva vega-namana gaura Mose na ekilagirato gelegelenai pono venia, pe taunilimalima pia ripa, goi ponama.” ");
INSERT INTO khz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na Iesu valina warauna taunilimalima na gekilagi-lovolovaato, taunilimalima gutuma para gelaka-kavito, ia gena kila pia kamonagira e geria viti vega-namara ularana. ");
INSERT INTO khz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ne Iesu elakato kapu gerevaginai everapaliwai. ");
INSERT INTO khz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Toma ta Iesu evevega-ripawai aonai, Parisea talimara e rova gevevega-ripagirawai talimara Galileia e Iudea vanugara maparara na, e Ierusalema na gevogomaito, ia laganai getanu-talito. Palagu gena tiavu Iesu genai evega-matagaiato, viti talimara pene vega-namara ulanana. ");
INSERT INTO khz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Talima reketa na tiutiu talimana ta gile ai gevuaato. Numa aonai pia lakagi-togaa rauparana getavuawai, Iesu wailanai pia tao-talia ulanana. ");
INSERT INTO khz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na gutuma kamu vagi pakurai, laka-toga rauparana everauleato. Gaurai tiutiu talimana magilena numa kininai gevua-rageato, ilu gekalaato pakana na, getugu-rigoato taunilimalima nuganugarai Iesu wailanai. ");
INSERT INTO khz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Iesu na geria kamonagi egitaato, tiutiu talimana evaikilaato, netiwato, “Gata, gemu rakava patugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parisea talimara e rova gevevega-ripagiawai talimara aora evetaina getugamagito, “Eerai ta, ia na Palagu ekilagi-rakavaana? Palagumo geregana galama etugamagi-piatogarana!” ");
INSERT INTO khz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu ripana ira na rakagau getugamagiawai, gaurai erenagirato, netiwato, “Rakagau gaurai aomi ai nevetaina gotugamagina? ");
INSERT INTO khz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Raka para kilatiwa malaga, ‘Gemu rakava patugamagi-piatogaa’ naparatiwa, pa para kila, ‘Ono rugaiti, ono laka’ naparatiwa? ");
INSERT INTO khz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Au na ana vega-gitami, Taunilimalima Natuna magena rorirori, rakava pene tugamagi-piatogara etanoparai.” Ia na viti rakava talimana evaikilaato, netiwato, “Avaikilamuna, ono kuliiti, gemu gepa ono gapia, numai ono laka!” ");
INSERT INTO khz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ne ia eraka-kuliitito taunilimalima wailarai, emaoko-agirato gaura egapirato, gena numai elakato, Palagu evega-rageato. ");
INSERT INTO khz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Taunilimalima maparara gevevega-kalito e Palagu gevega-rageato. Gekali-rakavato, gaurai gekilato, “Kala irau vagira etoma pata gitara!” ");
INSERT INTO khz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Voia mulinai Iesu vanuga na elakatito, takiti-koko talimana arana Levi takiti-koko numanai tanutago egitaato. Ne Iesu na evaikilaato, netiwato, “Muliku ai onoma lakakau.” ");
INSERT INTO khz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Gaurai Levi ekuliitito, gena gaura maparara eraokwanirato, Iesu mulinai elakato. ");
INSERT INTO khz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ne Levi na velekwa para gena numai ekalaato, Iesu gana. Wariwari talimara aorai takiti-koko talimara gutuma para e matalima reketa ria na geganiato. ");
INSERT INTO khz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisea talimara reketa e rova gevevega-ripagiawai talimara mataukavara ria na Iesu magena melo gekilagi-rakavarawai, gekilawai, “Rakagau gaurai gomi takiti-koko talimara e kala rakava talimara ria goganiganina e goniuniu-kouna?” ");
INSERT INTO khz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu na evega-gelerato, netiwato, “Nama talimara toketa ati getavurana, na viti talimara namo. ");
INSERT INTO khz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Au maki kala rorirori talimara keakeara ularana ati avogomaito, na kala rakava talimara galamara kila-waira ulanana avogomaito.” ");
INSERT INTO khz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Parisea talimara na Iesu gevaikilaato, negetiwato, “Ioane Bapatiso gena melo toma vogo aorai, gevokana e gerapalina. Aina melo maki vovetaina gekalana, a goina melo ganigani e niuniumo gerakagiana.” ");
INSERT INTO khz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu na evega-gelerato, netiwato, “Gomi gotugamagina vegarawa valigu talimana gatana lagarai etaluna aonai pia voka pa? ");
INSERT INTO khz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tomana evogomaina, vegarawa valigu talimana gatana geriana pia gapi-gerevagia, vou ira pia voka.” ");
INSERT INTO khz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iesu na geria kila vega-gelegele ta maekilagiato, netiwato, “Talima taa na rapuga valiguna ati pene rale vagia, rapuga kunena vega-paniagina. Pene vovetaina pene kala genai, rapuga valiguna pene ralea, e rapuga valiguna karena rapuga kunena goti ati pia gelegele. ");
INSERT INTO khz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Talima taa na vine nanuna valiguna nanikoti kopina kunenai ati pene wagi-rigoa. Pene vovetaina pene kala genai, vine nanuna valiguna na kopi kunena pene rakagi-pakaa. Vine nanuna pene vepopo e kopi pene rakava. ");
INSERT INTO khz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Na vine nanuna valiguna nanikoti kopina valigunai pene wagia genai nama. ");
INSERT INTO khz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","E talima taa na vine nanuna kunena eniuana mulinai vine nanuna valiguna ati pene ririwaa, kwalana ia pene kila, ‘Vine nanuna kunena nama vagi.’” ");
INSERT INTO khz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tapati tomanai Iesu vuiti aragara aora na evanagiwai, aonai gena melo vuiti gekwamoto, gimarai gemuturawai, ganira geganirawai. ");
INSERT INTO khz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisea talimara reketa na gerenagirato, negetiwato, “Gomi rakagau gaurai aina rova ati gokwalanaana, Tapati tomarai vuiti gokwamona?” ");
INSERT INTO khz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu na evega-gelerato, netiwato, “Gomi Davida mataukavana evitorato aonai, Davida na kala ekalagiato kilana ati goagiana? ");
INSERT INTO khz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Palagu gena numai elaka-togato, Palagu wailanai getaorawai peretira egapirato, eganiato e taukavana maki evenirato. Vopereti maveagara, Rupu Veaga veleramo garia, rova.” ");
INSERT INTO khz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iesu na maevaikilarato, netiwato, “Taunilimalima Natuna ia Tapati Velena.” ");
INSERT INTO khz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","MaTapati taai Iesu rupu aonai elaka-togato, evevega-ripawai. Vonai talima ta gimana ripana kavana ekeveto. ");
INSERT INTO khz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rova gevevega-ripagiawai talimara e Parisea talimara na ia gegita-tagoawai, Tapati tomanai pene vevega-nama pa aikina, kwalana pia tamania ulanana. ");
INSERT INTO khz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Na Iesu na ira na rakagau getugamagiawai gauna warauna eripaato, gaurai gima keve talimana evaikilaato, netiwato, “Ono rugaiti, enai onoma ruga.” Ne erugaitito, everugato. ");
INSERT INTO khz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ne Iesu na evaikilarato, netiwato, “Ana renagimi, rova aonai arigia nama, Tapati tomarai kala namara pita kalara nama pa kala rakavara pita kalara? Pita vevega-nama pa pita vagivagi?” ");
INSERT INTO khz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Epoe-gegelagito, maparara egitarato, ne votalima evaikilaato, netiwato, “Gimamu ono tugu-roriroria.” Gimana etugu-roriroriato, ne enamato gimana kavata vetaina. ");
INSERT INTO khz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Na ira vou geparu-rakavato, gaurai matotaura nuganugarai gekila-kouto Iesu raka pia kalagi-tiwaa. ");
INSERT INTO khz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Toma ta Iesu golo ta kukunai everageto pene rapali, vopogi mamaguluna ia Palagu genai erapalito. ");
INSERT INTO khz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Elaganiato, gena melo ekea-koukourato, aora na galagalana ruala evirigi-vagirato, arara ekilagirato, Apostolo. ");
INSERT INTO khz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simona, arana ta Petero, tarina Anduru; e Teimiti, Ioane, Filipo e Batolomio, ");
INSERT INTO khz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Mataio, e Tomas; Teimiti Alfia natuna; Simona, Selote talimana; ");
INSERT INTO khz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Iudas, Iakobo natuna; Iudas Isakariota, Iesu pene lewaa talimana. ");
INSERT INTO khz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ira ria golona gema rigoto kapu gelegelenai, Iesu ema ruga-talito. Ia na evega-riparawai talimara gutuma e taunilimalima gutuma para maki Iudea e Ierusalema na gevogomaito, Taia konena na e Sidona konena na maki gevogomaito; ");
INSERT INTO khz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ia pia kamonagia e vitira pene vega-namara ulanana. Palagu rakavara na geporogirato talimara maki evega-namarato. ");
INSERT INTO khz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na taunilimalima maparara geririwawai Iesu pia napa-kaulagia, kwalana tiavu ia genana evogomaiwai, gaurai taunilimalima maparara geria viti genamato. ");
INSERT INTO khz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesu eali-itito, ne epoe-agoto gena melo egitarato evaikilarato: “Aoma talimami, pio verere, kwalana Palaguna Basileia gomi gemi. ");
INSERT INTO khz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gomi raira ewagumona evitomina pio verere, kwalana gomi roe nea pio gani-mate. Gomi raira toma gotagina pio verere, kwalana gomi pio mamai. ");
INSERT INTO khz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Pio verere pene talima na pia paru-venimi genai, e pia kilagi-rakavami, pia roli opakaumi, e arami pia vega-rakavara Taunilimalima Natuna pakunai. ");
INSERT INTO khz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Vogaura pia wala tomanai pio verere puriiti mavonelagimi, kwalana akwami kamu vagi kupai. Kwalana ira kalakalarana maki peroveta talimara wagekala-tiwarato. ");
INSERT INTO khz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Na gomi rinaga talimami mavetugami kika, kwalana vega-vereremi rinagara warau gogapirato. ");
INSERT INTO khz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Toma gogani-matena talimami, vetugami, kwalana peneve vitomi. Toma gomamai na talimami, vetugami kika, kwalana piove waguri e piove tagi. ");
INSERT INTO khz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Taunilimalima na geagimina talimami, vetugami, kwalana tenera na maki peroveta talimara opakaura nevetaina geagirato.” ");
INSERT INTO khz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Na au gokamonagikuna talimami avaikilamina: Geparu-venimina talimara pio ulamagira, gevega-rakavamina talimara pio kala-nama-venira. ");
INSERT INTO khz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gekilagi-ketoketomina talimara pio vega-namara, e gekala-rakava-venimi na talimara geria pio rapali. ");
INSERT INTO khz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pene talima taa na mokomu kavata pene valea, mokomu kavata mapono ali-venia. Talima taa na gemu kouti pene gapia genai, tiati maki ragai pono vogaragia, pene gapia. ");
INSERT INTO khz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Gemu ai pia nogi talimara pono venira e raira na gemu gau ta pia gapia genai, gapiwaina kilana ragai pono vai. ");
INSERT INTO khz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Goi na rakagau oririwaana taunilimalima na pia kalaa gemu ai kalana, ira geriai maki vovetaina pono kala. ");
INSERT INTO khz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Pene goulagamirana talimara gomi geulamaginina talimaramo genai, gomi gemi nama rakagau? Rakava talimara maki geulamagirana talimaramo geulamagirana. ");
INSERT INTO khz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pa pene kala namara gemi ai gekalagirana talimaramo kala namara, gokala-venirana genai, gomi gemi nama rakagau? Rakava talimara maki nevetaina gekalana. ");
INSERT INTO khz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pa pene geveni-waimina talimaramo govenirana genai, gomi gemi nama rakagau? Rakava talimara na maki talimara gevenirana, mulinai maparara mapia vega-voi-waira negetina. ");
INSERT INTO khz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na geparu-venimina talimara pio ulamagira, kala namara geriai pio kala, pio venira, na vega-voi tugamagina ragai pio kala. Ne akwami pia kamu, e Goloka Iwavagi Palaguna natunai pia kilagimi, kwalana ia na ati gevega-namaana talimara e kala rakava talimara evega-namarana. ");
INSERT INTO khz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pio vegita-vetuga, gomi Tamami evegita-vetugana vetaina.” ");
INSERT INTO khz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Aomi ai taunilimalima ragai pio kilagi-rakavara. Vovetainai Palagu na maki ati pene kilagi-rakavami. Rakava voina taunilimalima geriai ragai pio kilagi-kaua, pe Palagu na rakava voina maki gemi ai ragai pene kilagi-kaua. Rakava pio tugamagi-piatogara, pe Palagu na maki gemi rakava pene tugamagi-piatogara. ");
INSERT INTO khz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pio veni, pe Palagu na maki pene venimi, vogora pene roli-rigora, pene kora-koura, pene vonu-poraketo, pene vepolavepola-vagi, pene popo-rigoa gemi ai. Kwalana rakavetaina govenina, Palagu na maki vovetaina pene venimi.” ");
INSERT INTO khz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesu na parapore ta maevaikila-venirato, netiwato, “Mata-kele talimana na mata-kele talimana ta pene vaia ripa? Pe tauria ruala lega aonai pia keto-rigo? ");
INSERT INTO khz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ripa etavuana melona na evega-ripaana talimana ati pene vanagia, na gena ripa etavuana gauna pene vega-aikia vou, evega-ripaana talimana goti pia vegelegele. ");
INSERT INTO khz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Rakagau gaurai goi tarimu matanai ripiripi ogitaana, na lako tupina goi matamu aonai ati otugamagiana? ");
INSERT INTO khz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Arigi rauparai goi tarimu ovaikilaana, notina, ‘Gata, matamu ai ripiripi ana gaivagia vou,’ na goi matamu ai lako tupina vou ati ogitaana? Goi opakau talimamu, kune goi matamu ai lako tupina ono gaivagia vou, pono poepoe-namanama vou, tarimu matanai ripiripi pono gaivagia.” ");
INSERT INTO khz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Gautupu namana vuana rakavara ati pene tugura, e gautupu rakavana vuana namara ati pene tugura. ");
INSERT INTO khz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gautupu maparara vuarai pita ripara. Figi vuana maki gautupu vekalavekalarai ati gekwamoana, e vine vuana maki gawa maginiginirai ati gekwamoana. ");
INSERT INTO khz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Talima namana na gau namara ia aonai etao-kourana gaura pene vega-laka-piatira. Talima rakavana na gau ati namara aonai etao-kourana gaura pene vega-laka-piatira. Kwalana talima aona na rakagau evogomaina gauna murunai ekilagirana.” ");
INSERT INTO khz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Rakagau gaurai au govaikilakuna, nogotina, ‘Velekou, Velekou,’ aonai au na akilagirana kalara ati gokalarana? ");
INSERT INTO khz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ana vega-ripami, rai au geku ai evogomaina, au geku kila ekamonagirana e kalara ekalarana ia rakavetaina. ");
INSERT INTO khz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ia talima ta gena numa ekalaato vetaina. Lega etavi-lekwalekwaato, vatu atanai evega-rugaato, aonai gapata kamu vagi erakato, vonuma eroliato, na ati egalu-lauato, kwalana vatu atanai erugato gaurai. ");
INSERT INTO khz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Talima ta au geku kila ekamonagirana, na kalara ati ekalarana, ia numa kala talimana vetaina, kwano merumeru ai numa evega-rugaato, gapata na egutu-lauato, eketo-lovolovoto.” ");
INSERT INTO khz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu na vokila maparara taunilimalima wailarai ekilagi-gaturato, mulinai vou Kaperanauma vanuganai elaka-togato. ");
INSERT INTO khz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Vonai Roma vetali velena ta etaluwai. Gena vetugunagi melona, eulamagi-kamuawai melona, eviti-rakavaato, roli ekwaregawai. ");
INSERT INTO khz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Vetali velena na Iesu valina ekamonagiato, ne Iuda talimara kamura reketa etugurato, Iesu pia nogia, pene vogomai, gena vetugunagi melona penema vega-namaa. ");
INSERT INTO khz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gaurai Iesu genai geagoto, maaora maparara na genogiato, negetiwato, “Evetali velena ia talima namana gaurai ono veakavaa. ");
INSERT INTO khz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kwalana ia na ita gera taunilimalima eulamagirana, e ai gema rupu maki ia na ekalaato.” ");
INSERT INTO khz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iesu ira ria gelakato. Numa gevekaviato aonai, vetali velena gatana reketa etugu-wailawailarato Iesu genai, ne vetali velena gena keakau kilana Iesu gevaikilagiato, negetiwato, “Velekou, ragai ono vekwalavi, au ati gelegele, goi au geku numai pono ragekau. ");
INSERT INTO khz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Au maki ati gelegele, goi gemu ai pana wati. Na tipo ono kila pe, geku vetugunagi melona pene nama. ");
INSERT INTO khz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Au maki talima reketa geria vegitatago kapulerai, e vetali talimara pa soldia au kapuleku ai. Au na ta avaikilaana, ‘Ono laka!’, natina elakana e mataa avaikilana, ‘Ono vogomai!’, natina evogomaina. E au geku vetugunagi melona avaikilaana, ‘Eia ono kalaa!’, ne ekalaana.” ");
INSERT INTO khz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu na ekila ekamonagiato, evevega-kalito, eruga-kuleto, ia mulinai gelakato talimara maparara evaikilarato, netiwato, “Au na gomi avaikilamina, Isaraela aonai kamonagi evetaina au na ati arawaliato.” ");
INSERT INTO khz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ne vetali velena gena vetugunagi talimara gewaikuleto ia gena numai. Viti melona gerawaliato, gena viti warau eaikito. ");
INSERT INTO khz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Voia mulinai Iesu vanuga gauta arana Nain ai elakato. Gena melo e taunilimalima gutuma maki ia gelaka-kwaruato. ");
INSERT INTO khz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vanuga aonai rogoti gelaka-toga aonai, kwarega ta vanuga aona na gevuatiawai. Wapu ta natuna melona kekeimo melona ekwaregato. Vanuga talimara gutuma na wapu gekwaruato. ");
INSERT INTO khz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Iesu na wapu egitaato, ne evetugaato, gaurai evaikilaato, netiwato, “Ragai ono tagi.” ");
INSERT INTO khz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne Iesu elaka-kaviagoto, kwarega kounai enapakauto. Kou gevuaato talimara geruga-talito. Ne Iesu ekilato, “Melo valigu, avaikilamuna, ono kuliiti!” ");
INSERT INTO khz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ne etanuitito, ekilakilato. Voia mulinai Iesu na tinana eveni-waiato. ");
INSERT INTO khz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ira maparara kalina gevonuto. Palagu gevega-rageato, negetiwato, “Peroveta talimana kamuna ta ita aorai pematagai!” E, “Palagu gena taunilimalima pene veakavara ularana pevogomai!” ");
INSERT INTO khz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ekala valina Iudea maparanai e Iudea lagana vanugara mapararai gekilagi-lovolovoato. ");
INSERT INTO khz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ioane gena melona egaura maparara gewalato gaura gevega-ripaato. Gaurai Ioane na gena melo ruala ekearato, ");
INSERT INTO khz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","etugurato, Velekou genai, ia renagia, “Ioane na ekilagiato, pene vogomai talimana goi, pa talima poluna ta paia aloa?” ");
INSERT INTO khz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Talimara ruala Iesu genai gekwarato, ne gevaikilaato, “Ioane Bapatiso na petugumai, nepetiwa, ‘Ia na ekilagiato pene vogomai talimana goi, pa talima poluna ta paia aloa?’” ");
INSERT INTO khz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Voora kianai Iesu na taunilimalima vogo evega-namarato, viti talimara, viti gevuawai talimara, palagu rakavara na geporogirato talimara. Mata-kele talimara gutuma maki matara evega-alirato. ");
INSERT INTO khz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ne Iesu na etalima ruala evega-gelerato, netiwato, “Iowaikule, gomi na pogo gitara e pogo kamonagira gaura Ioane pio vevaraa: Mata-kele talimara gepoepoena, gage rakava talimara gelakana, lepera talimara genamana, tega-gela talimara gekamonagina, kwarega talimara gekuliiti-waina, e Vali Namana lealea talimara geria evopatagiana. ");
INSERT INTO khz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Au geku ai ati gena aovoaovo talimana evererena.” ");
INSERT INTO khz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ioane na vetugunagi talimara gelakato vou, Iesu na gelaka-kavito talimara evaikilarato, Ioane valina geria ekilagiato, netiwato, “Ioane genai goagoto aonai, votanopakanai rakagau pio gitaa ulanana? Ralaka agi na elavu-aveaveana pio gitaa ulanana goagoto? ");
INSERT INTO khz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pene aikina genai, rakagau pio gitaa ulanana goagoto? Rapuga namana eligoana talimana gitagitana goagoto? Aikina. Rapuga namara gekalana talimara e ganigani namara geganirana talimara ira vele talimara geria numai getaluna. ");
INSERT INTO khz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na, rakagau pio gitaa ulanana goagoto? Peroveta talimana ulanana? Pa! Avaikilamina, gogitaato talimana ia peroveta talimara maparara evanagirana. ");
INSERT INTO khz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ioane valina Puka Veaga aonai evetaina etaloato, Palagu ekilato, ‘Au na geku vetugunagi talimana pana tugu-kunea, gemu raupara wailamu ai pene kala-maavua.’” ");
INSERT INTO khz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iesu maekilato, “Avaikilamina, etanoparai pege maguli talimara maparara aorai taa na Ioane ati pene vanagia. Na Palagu gena Basileia aonai kapi talimana na Ioane pene vanagia.” ");
INSERT INTO khz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Taunilimalima maparara e takiti-koko talimara maparara na maki ekila gekamonagiato, ira na Palagu gena raupara gevega-taunataunaato, Ioane na ebapatisorato. ");
INSERT INTO khz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Na Parisea talimara e rova gevevega-ripagiawai talimara na Palagu gena vevega-maguli rauparana gerugaato. Ioane na bapatiso maki ati gegapi-rageato. ");
INSERT INTO khz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ewagumona guluna talimara raira ria pana vega-gelegelera? Ira rakavetaina? ");
INSERT INTO khz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ira noo melo keira vetaira, vanuga gatamarai getanu-tagona, geulaulana, kavata melora na kavata gekea-venirana, negetina, ‘Ai vegarawa vererenai kita galavuwai gomi gemi, na gomi ati gopalawai! Ai kwarega marira gagapiwai, na gomi ati gotagiwai!’ ");
INSERT INTO khz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kwalana Ioane Bapatiso evogomaito, evokato e vine nanuna ati eniuato. Gaurai gomi gokilana, ‘Ia palagu rakavana na eporogiato,’ nogotina. ");
INSERT INTO khz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Taunilimalima Natuna evogomaito, ia ganigani ta ati erugaana. Gaurana gokilana, ‘Ia ganigani gaoka talimana e vine nanuna eniu-gaoka-vagiana talimana, takiti-koko talimara e kala rakava talimara gatara!’ nogotina. ");
INSERT INTO khz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Na Palagu gena ripa gegapi-rageana talimara na Palagu gena aoneka gevega-taunataunaana.” ");
INSERT INTO khz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisea talimana taa na Iesu enogiato pia ganigani-koukou, netiwato. Gaurai Iesu eagoto gena numai, ganigani kapunai etanu-talito. ");
INSERT INTO khz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Vovanugai gare ta etaluwai, ia mata-poraga garena. Ia ekamonagito, Iesu Parisea talimana gena numai eganiganiwai, ne vatu matana, alabasta vatuna na gekalaato matana, aonai mulaga maponana namana egapi-kauato, ");
INSERT INTO khz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","eagoto Iesu mulinai eruga-talito, gagena kwalanai etagi-rakavato, matana nanuna na Iesu gagena evega-nuparato. Ne guina na eiru-lakirato, gagena evelavurato, mulaga ponana namana gagenai epopo-kauato. ");
INSERT INTO khz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisea talimana na, vokala egitaato, ia matotauna etugamagito, “Etalima pene taunatauna ia peroveta talimana genai, ia pere ripa, ia genai penapakau garena rai. Ia pere ripa, vogare ia mata-poraga garena!” ");
INSERT INTO khz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ne Iesu na ia evaikilaato, netiwato, “Simona, au mageku kila goi gemu ai.” Simona na netiwato, “Vevega-ripa talimamu o, ono kila, pana kamonagi.” ");
INSERT INTO khz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iesu na evaikilaato, “Talima ruala na moni eveveniwai talimana genai moni gegapi-toreto. Talima taa na siliva monira tinavu imaima (500) egapi-torerato, mataa na siliva monira gagala imaima (50) egapi-torerato. ");
INSERT INTO khz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na etalima ruala geria gapitore vega-voi-waira gegaoka-vagito gaurai, moni eveniwai talimana na geria gapitore maki ati etavurato. Rai na votalima eulamagi-kamuato?” ");
INSERT INTO khz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simona na evega-geleato, netiwato, “Au atugamagina gena gapitore kamu talimana.” Iesu na evaikilaato, “Pa, rorinai pokilagia.” ");
INSERT INTO khz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Voia mulinai Iesu etanu-kuleto, vavine etanu-wailaato vou, Simona evaikilaato, netiwato, “Egare ogitaana? Au goi gemu numai pama ragekau aonai, gageku guligi-agina nanuna ta ati povuamaia, na egare matana nanura na au gageku peguligira, e guina na peiru-lakira. ");
INSERT INTO khz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Goi na ita gera vegapi-rage vevelavunai au ati pogapi-rageku, na egare ogitaana, pema rage vegata au gageku roe evelavuana. ");
INSERT INTO khz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Goi na repaku ai riga ta ati popopoa, na ia na au gageku mulaga maponana namana na pevega-nupa-vekwalavira. ");
INSERT INTO khz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gaura pakurai, au na goi avaikilamuna, gena rakava vogo vavagina, na Palagu na warauna petugamagi-piatogara. Gaura pakurai gena ulamagi kamu vagi. Na gena galama kiaramo etugamagi-piatogarato talimana gena ulamagi maki kei vagi.” ");
INSERT INTO khz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ne Iesu na egare evaikilaato, netiwato, “Gemu galama warauna patugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ia ria geganigani-kouto talimara geverenagi-verenagito, negetiwato, “Ia eeraka talima vetaina, pe ia na talima galamara ekila-wairana netina?” ");
INSERT INTO khz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu na egare maevaikilaato, netiwato, “Gemu kamonagina warau pevega-magulimu. Ewagumona ono laka maaomu namana ria.” ");
INSERT INTO khz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Voia mulinai Iesu na vanuga kamura e vanuga keira eago-venirawai, Palagu gena Basileia Valina Namana evopatagiawai. Gena melo gagalana ruala na geveakavaato. ");
INSERT INTO khz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Gare reketa maki ia ria geagoto, Iesu na palagu rakavara vogare aorai egui-atirato e geriai viti, evega-namarato. Ta Maria, arana gevatoato Magadala vanugana garena. Egare aona na palagu rakavara taulatoi kwapuna egui-atirato. ");
INSERT INTO khz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Mataa Ioana, Kusa garawana. Kusa ia Heroda gena rinaga egita-tagorawai talimana ta. Ta Susana, e gare mareketa maki vogo vavagina. Egare geria rinaga na Iesu magena melo geveakavarawai. ");
INSERT INTO khz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Taunilimalima gutuma para getanu-kouto vanuga, maparara na Iesu genai geagoto. Ne ia na geria parapore ta ekilagiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Araga talimana gena aragai elakato, gena vuiti vuara pene pia-lovolovora ulanana. Epiarawai aonai, reketa rauparai geketoto. Ne taunilimalima na gepana-vevilirato, e manu na geganirato. ");
INSERT INTO khz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Reketa vatu kapurai geketoto. Getuputo, na ati rau gemalaito, kwalana kwano ati nanuna. ");
INSERT INTO khz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Reketa gawa maginiginira aorai geketoto. Ne gawa maginiginira ria gekala-kouto, na varovaro gaura gepinupinurato gaurai gekwaregato. ");
INSERT INTO khz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Reketa kwano namanai geketoto, getupu-nama-iwavagito, gevuato, kwapurakwapura vuara tinavuna (100).” Aonai Iesu karona evega-kamuato, netiwato, “Mategana talimana pene kamonagi.” ");
INSERT INTO khz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Gena melona Iesu gerenagiato voparapore ganina rakagau. ");
INSERT INTO khz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iesu na evega-gelerato, netiwato, “Palagu gena Basileia kilara veavugara gomi gemi ai evega-matagairana, na maparara parapore ai avaikilarana, pia gitara, na ganira ati pia ripara, pia kamonagira, na ati pia tugamagi-ilu.” ");
INSERT INTO khz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Eparapore ganina evetaina: Vuiti vuara Palaguna kila. ");
INSERT INTO khz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Rauparai geketoto vuiti uvera taunilimalima na Palagu gena kila gekamonagiana. Na Satani evogomaina, Palagu gena kila ira aora na egaivagirana, Vali Namana nege vega-taunataunaana e nege magulina kalinana. ");
INSERT INTO khz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kwano mavatunai geketoto vuiti uvera, taunilimalima na Palagu gena kila gekamonagiana e mavererera na gegapi-rageana. Na ira noo talima ati lamura vetaira. Lagani kianamo, Palagu gena kila gekwalanaana, na vekalatovo pene kwara aonai pia keto. ");
INSERT INTO khz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Gawa veginivegini aorai geketoto vuiti uvera, ira taunilimalima na Palagu gena kila gekamonagiana, na tugamagi vogovagi gekalarana, tanopara rinagara getugamagi-kokokokorana e tanopara gena maguli vererera na Vali Namana ekou-taliana. Gaurai vuara namara ati etugurana. ");
INSERT INTO khz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na kwano namai geketoto vuiti uvera, ira taunilimalima na Palagu gena kila gekamonagiana, maaora namara na e manamara na gegapi-ragerana, gegapi-gaugaurana, vuara namara etugurana. ");
INSERT INTO khz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Talima taa na lamepa pene ekapuana genai, ati gulo na pene kou-talia, pa vala kapulenai pene taoa. Aikina, ia na lamepa taotaona kapunai pene taoa. Pia laka-toga talimara maparara na maekana pia gitaa ulanana. ");
INSERT INTO khz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Veavuga gaura maparara pia matagai, vegunima kilara pia ripara e pia kilagi-atira. ");
INSERT INTO khz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Gaurai gokamonagirana kilara pio rogona tolera. Kwalana magena kamonagi talimana Palagu na tugamagi-ilu pene venia, ati gena kamonagi talimana, ia etugamagina magena tugamagi-ilu, na gena tugamagi-ilu maki pene gapi-pakaa.” ");
INSERT INTO khz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesu tinana e tarina melora ia genai geagoto, na taunilimalima gutuma gaurai, ati geria raupara ia laganai pia laka-kavi. ");
INSERT INTO khz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Talima taa na Iesu evaikilaato, netiwato, “Goi tinamu e tarimu numa mulinai geruga-tagona, goi getavumuna.” ");
INSERT INTO khz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ne maparara Iesu na evaikilarato, “Palagu na kila gekamonagiana e gekalarana talimara ira au tinaku e au tariku.” ");
INSERT INTO khz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Toma ta Iesu magena melo gati ai geragekauto, ne Iesu na evaikilarato, netiwato, “Ita wati vanagi, kovu vokavai.” Ne gevevanagito. ");
INSERT INTO khz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Gevevanagiwai aonai, Iesu emaitu-kwaregato. Aonai na ragepogi ekwaragiato, aku gati aonai gevepopo-rigowai, gati roli epuluto. ");
INSERT INTO khz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ne gena melo geagoto, gevagoato, gekilato, “Vevega-ripa talimamu o, Vevega-ripa talimamu o, ita tapuluna, roli takwaregana!” Iesu etogaitito agi e aku ekila-wairato, ne geaikito, e erawa-taliato. ");
INSERT INTO khz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iesu na gena melo evaikilarato, netiwato, “Gomi gemi kamonagi arigia?” Ira gekalito e getugamagi-kavato, matotaura geverenagi-verenagito, negetiwato, “Etalima e rai? Ia na agi e aku pevaikilara aonai, karona pege kamonagia!” ");
INSERT INTO khz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Vokapu na Iesu magena melo geagoto, Gerasa (pa Gadara) talimara geria kapu ai gekwarato, Galileia kavata taitarinai. ");
INSERT INTO khz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu gati na elaka-rigoto aonai, palagu rakavara na eporogiato talimana ta evogomaito Iesu genai. Ia vovanuga talimana. Rauvagi-vegata ati rapugana etaluwai, ati numai, na kala kapuna vatu kovogarai. ");
INSERT INTO khz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ia na Iesu egitaato aonai, ekogo-lailaito, ne Iesu gagena kwalanai eketo-talito, netiwato, “Iesu o, goi Goloka Iwavagi Palaguna Natuna, au geku ai rakagau ono kalaa notina? Anogimuna, ragai pono vega-vitivitiku!” ");
INSERT INTO khz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ia vovetaina ekilato, kwalana Iesu, na palagu rakavana evaikilaato votalima genana ene laka-vagi. Vega-vogo vavagina palagu rakavana na egapiawai, gagena e gimana teini na gekwatuawai, na teini erapurawai, ne palagu rakavana na kapu pakarai elakagiawai. ");
INSERT INTO khz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu na erenagiato, netiwato, “Goi aramu rai?” Ia na evega-geleato, netiwato, “Au araku ‘Vogovagi,’” kwalana palagu rakavara vogo vavagina na geporogiato gaurai. ");
INSERT INTO khz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ne palagu rakavara na Iesu genogiato, lega ropu-kelaunai ragai pene tugu-agora. (Voo palagu rakavara geria tipura kapuna). ");
INSERT INTO khz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Vonai pae laveta ta golo kapanai geunaunawai. Gaura pakurai palagu rakavara na Iesu genogiato, pae aorai ia laka-toga, negetiwato. Ne Iesu na evaikilarato, “Ioago!” ");
INSERT INTO khz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gaurana palagu rakavara votalima genana gelaka-piatito, pae geriai gelaka-togato. Ne vopae gewaloku-lovolovoto, roparopa na geralupito, kovu ai gevegugutu-kwaregato. ");
INSERT INTO khz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pae gitatagora talimara na rakagau ewalato gauna gegitaato, ne gerakato, vovali gepiaato vanuga kamunai e vanuga keirai. ");
INSERT INTO khz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Taunilimalima gegoto-agoto, rakagau ewalato gauna iave gitaa ulanana. Iesu genai gekwarato aonai, ira na votalima, palagu rakavara vogo ia genana gelaka-piatito talimana, gerawaliato, Iesu gagena kwalanai etanu-tagowai marapugana e gena tugamagi maki rorirori. Gaurai ira maparara gekalito. ");
INSERT INTO khz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Vokala gegitaato talimara na palagu rakavara na geporogiato talimana raka enama-tiwato valina taunilimalima geriai gepiaato. ");
INSERT INTO khz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gaurana Gerasa kapuna talimara maparara na Iesu genogiato, pene raokwanira negetiwato, kwalana gekali-rakavato gaurai. Gaura pakurai Iesu gati ai eragekauto, maewaikuleto. ");
INSERT INTO khz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Palagu rakavara genana gelaka-piatito talimana na enogiato, Iesu goti pia laka netiwato. Na Iesu na etugu-waiato, evaikilaato, ");
INSERT INTO khz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ono waikule gemu numai. Palagu na goi gemu ai pekalaa kalana taunilimalima pono vega-ripara.” Gaurai ia eagoto, gena vanuga talimara maparara Iesu gena kala ia genai gewalato gaura evopatagirato. ");
INSERT INTO khz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iesu kovu vokavana na ewaikuleto aonai, taunilimalima gutumana gegapi-rageato maverererana, kwalana maparara na gealo-tagoawai. ");
INSERT INTO khz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ne rupu gitatagona talimana ta arana Iairo, Iesu genai eagoto, gagena kwalanai evetiu-talito, enogiato, gena numai ia ago netiwato, ");
INSERT INTO khz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kwalana ia natuna vavine na kekeimo, roli ekwaregawai gaurai. Gena rigolo gagalana ruala. Iesu eagoto aonai taunilimalima gutuma na gelaka-piipipiawai. ");
INSERT INTO khz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Voia aonai gare ta, genai rala vitina; rigolo gagalana ruala eviti-agiato. Ia gena rinaga e moni maparara evega-aikirato toketa geriai gena viti pia vega-namaa ulanana. Na taa na ati evega-namaawai. ");
INSERT INTO khz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Taunilimalima gutuma mulira na evepipi-togato, makavata na evelakatito, Iesu laganai ekwarato. Iesu gena rapuga pipinai evegapikauto. Ne veganamo gena rala viti eaikito. ");
INSERT INTO khz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu everenagito, ekilato, “Rai na au penapa-kaunagiku?” Maparara geveopa-tagoto, gekilato, “Au aikina.” Na Petero ekilato, “Vevega-ripa talimamu, taunilimalima ogitarana, pege galukorope-gavumu e gelaka-pekupekumuna.” ");
INSERT INTO khz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Na Iesu ekilato, “Ta au geku ai penapakau, kwalana au ripaku, tiavu au gekuna pelakati.” ");
INSERT INTO khz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Egare warauna eripato, ia ati gena veavuga rauparana, gaurai manuga-golugoluna eagoto, Iesu gagena kwalanai evetiu-talito. Iesu genai rakagau gaurai enapakauto e gena viti veganamo eakito valina ekilagi-atiato taunilimalima wailarai. ");
INSERT INTO khz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ne Iesu na evaikilaato, netiwato, “Natuku, gemu kamonagina pevega-namamu. Gaurai, maaomu namana ono laka.” ");
INSERT INTO khz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu roe waekilakilawai aonai, talima ta rupu gitatagona talimana Iairo gena numa na evogomaito, netiwato, “Natumu warauna pekwarega. Vevega-ripa talimana ragai ono vega-vekwalavia.” ");
INSERT INTO khz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu na vokila ekamonagiato, aonai Iairo evaikilaato, netiwato, “Ragai pono kali, pono kamonagi vegata, pe ia pene maguli.” ");
INSERT INTO khz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iairo gena numai ekwarato, aonai Iesu na taunilimalima evaikilarato, numai ragai pia laka-toga, Petero, Teimiti, e Ioane, e vavine tamana e tinanamo. ");
INSERT INTO khz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Maparara getagiwai e getagi-kilakilawai aonai, Iesu na evakilarato. “Ragai iotagi, vavine e ati pekwarega, ia tipo emaituna.” ");
INSERT INTO khz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Taunilimalima na gemamai-agiato, kwalana ira geripato, vavine ekwaregato. ");
INSERT INTO khz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ne Iesu na vavine gimanai egapito, evaikilaato, ekeaato, “Natuku o, ono kuliiti!” ");
INSERT INTO khz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Gaurai palaguna ewaikuleto, emagulito, veganamo ekuliitito. Iesu na evaikilarato, vavine pia gupua. ");
INSERT INTO khz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ia tamana e tinana gevevega-kali-rakavato, na Iesu na evaikila-taitalirato, ekala valina talima ta genai ragai pia kilagia. ");
INSERT INTO khz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesu na gena melo gagalana ruala ekea-koukourato, tiavu evenirato, palagu rakavara maparara pia gui-atira, e viti talimara pia vega-namara. ");
INSERT INTO khz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ne etugurato, Palagu gena Basileia valina pia vopatagia, e viti talimara pia vega-namara. ");
INSERT INTO khz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Evaikilarato, netiwato, “Gemi lakalakai gau kwauta ragai pio gapi-kaua. Toki, palaka, ganigani gaura, moni, e tiati ruala na maki ragai pio gapi. ");
INSERT INTO khz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pia vairagemi numarai pio talu, pene ago, vanuga pio raokwania. ");
INSERT INTO khz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pene vanuga taai ati pia gapi-ragemi genai, vovanuga pio raokwania, gagemi kavuramo pio kwara-vagira ira geria kila-tilivagi vega-taunataunara ularana.” ");
INSERT INTO khz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iesu gena melo gelakato, vanuga gauragaurai geagoto, Vali Namana gevopatagiawai e viti talimana gevega-namarawai kapu mapararai. ");
INSERT INTO khz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Heroda, Galileia velena, Iesu valina ekamonagiato, aonai eaovoaovo-rakavato, kwalana talima reketa gekilawai, Ioane Bapatiso kwaregana pekuliiti-wai. ");
INSERT INTO khz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mareketa gekilato, Elia ematagaito. Mareketa gekilato, peroveta talimana kunena ta ekuliiti-waito, negetiwato. ");
INSERT INTO khz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na Heroda ekilato, “Ioane repana au na apati-vagiato. Na, evali akamonagiana talimana e rai?” Heroda eririwato Iesu pene gitaa. ");
INSERT INTO khz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iesu gena apostolo gewaikuleto, rakagaurakagau gekalarato gaura valira Iesu gema varaato. Ne Iesu na evaigerevagirato, vanuga ta arana Betesaida, vanuganai evaiagorato. ");
INSERT INTO khz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Na taunilimalima na gekamonagirato gaurai, Iesu mulina na geagoto. Ne Iesu na egapi-ragerato, Palagu gena Basileia valina evopata-venirato, e viti talimara evega-namarato. ");
INSERT INTO khz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Garo everigoawai aonai, gena melo gagalana ruala Iesu genai geagoto, gekilato, “Etaunilimalima ono tugura, pe vanuga vekavirai e araga talimara geria talu kapurai, garia gauganigani e maitu kapura ia tavu, kwalana eia e kapu pakana.” ");
INSERT INTO khz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Na Iesu na evaikilarato, netiwato, “Gomi na garia iovenira.” Ira na gevega-geleato, negetiwato, “Ai gemai pereti imaima e magani rualamo. Goi oririwana ai paia ago, ganigani paia voira egutuma maparana gana?” ");
INSERT INTO khz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kwalana marumaru maparara ragana imaima (5,000) vetaira. Iesu na gena melo evaikilarato, netiwato, “Taunilimalima iowarera gagala imaima tanu ta (50), gagala imaima tanu ta (50,) ne pia tanu-tali.” ");
INSERT INTO khz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iesu ekilato rorinai gekalarato taunilimalima maparara gevega-tanu-talirato. ");
INSERT INTO khz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Voia mulinai Iesu na paraoa imaima e magani ruala egapirato, kupai eali-rageto, Palagu evega-namaato vou, epuki-kinikinirato, gena melo evenirato pia warera. ");
INSERT INTO khz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Maparara gegani-kwaregato; kapinai Iesu gena melo na ganigani kovara gekoko-koukourato, papalu gagalana ruala gevega-vonurato. ");
INSERT INTO khz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Toma ta Iesu geregana erapaliwai, gena melo maki ia goti. Aonai Iesu na erenagirato, netiwato, “Taunilimalima na negetina au rai?” ");
INSERT INTO khz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ia gevega-geleato, negetiwato, “Reketa gekilana goi Ioane Bapatiso, reketa Elia, mareketa na peroveta talimana kunena ta pekuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iesu na evaikilarato, netiwato, “Na gomi na nogotina au rai?” Petero na evega-geleato, negetiwato, “Goi Palaguna Keriso, ia na ekilagi-gavuato vevega-maguli talimana.” ");
INSERT INTO khz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesu na evaikila-taitalirato, ia valina talima ta ragai pia varaa. ");
INSERT INTO khz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ia maekilato, “Taunilimalima Natuna viti vogo pene vuara. Iuda velera, e Rupu Veaga velera kamura, e rova gevevega-ripagiana talimara na pia rugaa, e pia vagi-kwarega maki, na toma vega-toitoinai kwarega na mapene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iesu na ira maparara evaikilarato, netiwato, “Pene talima ta au muliku ai pene laka netina genai, ia matotauna pene vetugamagi-piatoga, gena satauro pene vuaa toma mapararai, au muliku ai pene laka. ");
INSERT INTO khz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kwalana rai gena maguli evogaragiana talimana, ia gena maguli pene piatogaa. A rai au pakuku ai gena maguli pene piatogaa talimana, ia gena maguli ati pene vega-lekwalekwaa. ");
INSERT INTO khz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pene talima taa na tanopara maparana pakunai gena maguli pene piatogaa genai, ia matotauna gena maguli pene vega-rakavaa, gena nama rakagau ia genai? ");
INSERT INTO khz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pene talima taa na au e geku kila nugaragera na pene nuga-rage genai, Taunilimalima Natuna maki pene nugarage ia genai gena vogomai ai, maekana mavewaena e matiavu iwavagina, Tamana aneru maveagara ria pia vogomai tomanai. ");
INSERT INTO khz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Avaikila-taunataunamina, enai reketa geruga-tagona ira ati pia kwarega vou, pene ago, Palagu gena Basileia pia gitaa.” ");
INSERT INTO khz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ekila ekilagi-gaturato mulinai, toma taula vativati vetaira gevanagito vou, Iesu na Petero, Ioane, e Teimiti evairato, golo gautai geverageto pia rapali ulanana. ");
INSERT INTO khz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Erapaliwai aonai, ia wailana gitagitana eirauto, e gena rapuga ekulo-garogaroto. ");
INSERT INTO khz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ne talima ruala gematagaito, Mose e Elia, Iesu ria gekilakilawai. ");
INSERT INTO khz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tauria ruala mavewaevewaera e mamaekara ria gematagaito, Iesu ria gekilakilawai, Ierusalemai pene kwarega negetiwato, Palagu gena ririwa gelegelenai. ");
INSERT INTO khz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petero mataukavana gemaitu-kwaregato, na gekeroto aonai, Iesu mavewaevewaena e mamaekana ria gegitaato, e ia ria geruga-tagowai talimara maki. ");
INSERT INTO khz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tauria ruala na Iesu geraokwaniawai aonai, Petero na Iesu evaikilaato, netiwato, “Vevega-ripa talimamu o, nama iwavagi ita ea, pe enai ama toitoi aia kalara. Ta goi gemu, ta Mose gena, e ta Elia gena.” Ia ati ripana rakagau ekilagiato. ");
INSERT INTO khz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ia roe waekilakilawai aonai, iloa na ema avugarato. Iloa na egapi-gavurato aonai, ira gekalito. ");
INSERT INTO khz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Karo ta iloa aora na ekea-atito, netiwato, “Au natuku ea, avirigiato talimana, ia pio kamonagi-venia!” ");
INSERT INTO khz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Vokaro eaikito aonai, Iesu geregana gegitaato. Ekala gegitarato gaura, talima ta genai ati gekilagi-matagaiato votoma. ");
INSERT INTO khz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Toma ta eaikito mulinai, ira golona geverigowai aonai, gutuma kamu vagi ria gelaka-verawalito. ");
INSERT INTO khz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ne talima ta gutuma aora na ekea-golito, netiwato, “Vevega-ripa talimamu o, anogimuna, au natuku melona onoma gitaa. Ia e gereganamo kekei ewalato. ");
INSERT INTO khz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Toma taarana ia palagu rakavana egapiana, ne ekogo-lailaina; tauniparana maki evegegena, aonai pokana na kapurokapuro gelakatina. Evetaina evagi-kwarega-vanagivanagiana. ");
INSERT INTO khz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Goi gemu melo panogira, ia gui-atia napatiwa, na ira ati pege gelegele.” ");
INSERT INTO khz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu na evega-geleato, netiwato, “Ati kamonagi e kila-tilivagi guluna! Toma vira au gomi lagami ai pana talu e pana vaigaoka-venimi?” Gaurai Iesu votalima evaikilaato, netiwato, “Natumu ono vaimaia.” ");
INSERT INTO khz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Melo evogomaiwai aonai, palagu rakavana na kwano ai ekwalavi-taliato, tauniparana evega-pilupiluato. Na Iesu na palagu rakavana ekila-waiato, melo evega-namaato, ne tamana maeveni-waiato. ");
INSERT INTO khz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Talima maparara gevevega-kali-rakavato, kwalana Palagu gena tiavu gegitaato gaurai. Taunilimalimana Iesu gena kala roe wagevevega-kaliagiawai aonai, Iesu na gena melo evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Au na kila ta gemi ana kilagia, pe pio kamonagia ragai pio tugamagi-lekwalekwaa. Taunilimalima Natuna pia lewaa vou taunilimalima gimarai pia tao-kaua.” ");
INSERT INTO khz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na gena melona ati getugamagi-rawaliato, Iesu na rakagau ekilagiato. Vokila ganina ira geriai veavuga, ragai pia ripaa ulanana, Iesu maki ati gerenagiato kwalana gekalito gaurai. ");
INSERT INTO khz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iesu gena melo nuganugarai veitu ewalato, kwalana gekilato, rai kamu iwavagi ira nuganugarai. ");
INSERT INTO khz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu warauna eripato rakagau getugamagiato, gaura pakurai melo keina ta egapiato, ia laganai evega-ruga-taliato vou, ");
INSERT INTO khz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","evaikilarato, netiwato, “Rai na emelo pene egapi-rageana au araku ai, ia na au egapi-ragekuna. Pene talima taa na au egapi-ragekuna genai, etugukuto Palaguna maki egapi-rageana. Kwalana rai gomi na gokilagi-piatogaana talimana gomi nuganugami ai, ia kamu iwavagi.” ");
INSERT INTO khz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ioane na Iesu evaikilaato, netiwato, “Vevega-ripa taumu, talima ta gagitaato, goi aramu ai palagu rakavara egui-atirawai, na ai na gakila-waiato, kwalana ia ati ita ria tainaguluna gaurai.” ");
INSERT INTO khz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu na evaikilarato, netiwato, “Ragai pio kila-waia, kwalana rai na gomi ati evega-rakavamina talimana gomi eveakavamina.” ");
INSERT INTO khz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu kupai pene verage tomana ekavinagiawai gaurai, Ierusalema pene ago-venia, netiwato. ");
INSERT INTO khz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Gaurai gena vetugunagi talimara etugu-kunerato, Samaria vanugana taai gekwarato, Iesu gena agalagi kapuna gevetavuato. ");
INSERT INTO khz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Na vanuga talimara na Iesu ati gegapi-rageato, kwalana ia Ierusalema eago-veniawai gaurai. ");
INSERT INTO khz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iesu gena melo, Teimiti e Ioane na vokala gegitaato, ne gekilato, “Velekou, goi oririwana kalova kupa na paia kea-rigoa, pene mairigo, pene vega-veroverora?” ");
INSERT INTO khz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iesu eruga-kuleto, taura ruala ekila-wairato. ");
INSERT INTO khz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ne ira gelakato, mavanuga gautai. ");
INSERT INTO khz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ira raupara na geagowai aonai, talima taa na Iesu evakilaato, netiwato, “Goi pono laka kapura mapararai au goi mulimu ai pana lakakau.” ");
INSERT INTO khz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu na evakilaato, netiwato, “Uraura kwaevara mageria kovoga, e manu mageria nuguvi, na Taunilimalima Natuna vou ati gena maitu kapuna.” ");
INSERT INTO khz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iesu na matalima ta evaikilaato, netiwato, “Muliku ai onoma laka.” Na votalima na evega-geleato, netiwato, “Velekou, roe nea vou, ana waikule, tamaku anave tolea vou.” ");
INSERT INTO khz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu na evega-geleato, netiwato, “Neira ono raokwanira, kwarega talimara (pa Palagu ati gekwalanaana talimara) geria kwarega matotaura na pia tolera. Na goi ono laka, Palagu gena Basileia valina onove piaa.” ");
INSERT INTO khz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Talima taa na maevaikilaato, netiwato, “Velekou, mulimu ai ana laka, na ana ago vou, geku numa talimara ria aia vevega-neka.” ");
INSERT INTO khz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu na evega-geleato, netiwato, “Talima ta elugana aonai, mulina maepoe-waikule-veniana, ia ati gelegele Palaguna Basileia pene vaia.” ");
INSERT INTO khz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Voia mulinai Velekou na talima gagala taulatoi kwapuna e ruala (72) evirigirato, ne ruala na ruala na etugu-kunerato, ia pene ago vanugara e kapura mapararai. ");
INSERT INTO khz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Evaikilarato, netiwato, “Kuakua ganiganira vogo galagala vagi, na kuakua talimara maine vagi. Gaura pakurai kuakua Velekouna ionogia, pe kuakua talimara reketa mapene tugu-agora, ganigani piave kua. ");
INSERT INTO khz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Iolaka, au na mamoe vetaira atugumina, uraura kwaevara rakavara nuganugarai. ");
INSERT INTO khz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Moni molora, rula e tamaka ragai pio gapikau; rauparai talima ta ragai pio vega-vegupua. ");
INSERT INTO khz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pene numa gautai pio rage genai, nopiotiwa, ‘Enumai maino pene mia.’ ");
INSERT INTO khz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pene maino eririwaana talimana vonai etaluna genai, gemi maino kilana ia atanai pene mia. Pene aikina genai, maino gemi ai mapene waikule-wai. ");
INSERT INTO khz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Rakagau pia venimi pio ganira e pio niura, kwalana einaguluna talimana akwana pene gapia ulanana. Numa taa na manuma taai ragai pio ago, na vonumamo gaunai pio talu. ");
INSERT INTO khz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pene vanuga gautai pio kwara, pia gapi-ragemi, rakagau wailami ai pia tao-atira gaura pio ganira. ");
INSERT INTO khz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Vovanugai viti talimara pio vega-namara e taunilimalimara pio vaikilara, nopiotiwa, ‘Palaguna Basileia (gena vegitatago tiavuna evega-rugaana), gomi lagami ai ea.’ ");
INSERT INTO khz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Na pene vanuga gautai pio kwara, ati pia gapi-ragemi genai, gatamanai pio lakati, nopiotiwa, ");
INSERT INTO khz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Gemi vanuga kakavura gagemai ai pege karakau gaura maki gakwara-vagirana gemi karoverave vevega-matagaira ulanana. Na pio ripa, Palaguna Basileia pekavinagi.’ ");
INSERT INTO khz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Au na avakilamina, Kota kamuna tomanai evanuga na metau pene vuaa gauna, Sodoma gena metau maki pene vanagia.” ");
INSERT INTO khz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korasina o, goi e Betesaida, vetugami kika! Kwalana kala irau vagira gemi ai gematagaiwai Taia e Sidona aorai pegere matagai, na ira rauvagi pegere vetugamagi-kule, pute rakavarai e tauniparara makulumarai geria vetugamagi-kule pegere vega-matagaira. ");
INSERT INTO khz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Palagu na taunilimalima pene agirorira tomana kamunai, gomi na pio rawalia metauna Taia e Sidona geria metau pene vanagia. ");
INSERT INTO khz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Goi maki, Kaperanauma o, goi oririwana kupai pono verage notina? Aikina, goi kwarega kapunai pono ago!” ");
INSERT INTO khz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iesu na gena melo evaikilarato, netiwato, “Rai na gomi pene kamonagi-venimi, au maki pene kamonagi-veniku; rai na ati pene gapi-ragemi, au maki ati pene gapi-rageku; e rai na ati egapi-ragekuna, etugukuto Palaguna maki ati egapi-rageana.” ");
INSERT INTO khz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Gena melo gagala taulatoi kwapuna e ruala (72) mavererera gewaikuleto, negetiwato, “Velekou o, palagu rakavara goi aramu ai gavaikilarato, ne karomai gekamonagirato.” ");
INSERT INTO khz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu na evega-gelerato, netiwato, “Satani agitaato, rama ekeuleana vetaina kupa na eketo-rigoto. ");
INSERT INTO khz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pio ripa, au na tiavu warauna avenimito, gelema e rogaroga pio pana-talira, Satani gena tiavu maki pio vega-pala palaa, gau taa na ati pene vega-rakavami. ");
INSERT INTO khz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Na, ragai pio verere kwalana palagu rakavara gemi tiavu aonai, aikina, a gomi pio verere kwalana gomi arami kupai etalorato gaurai.” ");
INSERT INTO khz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Votanukou aonai Veaga Palaguna na Iesu verere na evega-vonuato, ne ekilato, “Tamaku o, kupa e tanopara Velena, avega-namamuna, kwalana goi na aoneka e ripa talimara geriai otao-veavugarana gaura ati ripara talimara geriai ovega-matagairana. Pa, Tamaku, gemu ririwa evetaina pene vetao vegata. ");
INSERT INTO khz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Gau maparara Tamaku na evenikuto. Talima ta ati ripana ia Natuna, Tamanamo geregana, e ta ati ripana ia Tamana, na Natuna gereganamo, e Natuna na eulamagirana talimara geriai vou evega-matagairana.” ");
INSERT INTO khz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ne Iesu epoe-kuleto gena melo geriai, veavugai evaikilarato, netiwato, “Gomi pio verere, kwalana egaura gogitarana pakurai. ");
INSERT INTO khz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Au na avaikilamina, peroveta talimara e tanopara velera kamura vogona geririwato, gomi na gogitarana gaura pegere gitara, na ati gegitarato, e gokamonagirana gaura pegere kamonagira na ati gekamonagirato.” ");
INSERT INTO khz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Rova evevega-ripagiawai talimana ta ekuliitito, ne Iesu ekalatovoato, netiwato, “Vevega-ripa talimamu o, au raka pana kala-tiwa, maguli vanagivanagi pana vaia?” ");
INSERT INTO khz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iesu na evega-geleato, netiwato, “Rova rakagau netina? Goi na raka oagi-tiwaana?” ");
INSERT INTO khz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ia evega-geleto, netiwato, “Velekou goi gemu Palagu pono ulamagia, maaomu maparana, mapalagumu maparana, e makwalimumu maparana, e matugamagimu maparana; e ‘Lagamu talimana maki pono ulamagia, goi matotaumu oveulamagina vetaina.’” ");
INSERT INTO khz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu na evaikilaato, netiwato, “Povega-gele rorirori, nevetaina pono kala, pe pono maguli.” ");
INSERT INTO khz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Na rova evevega-ripagiawai talimana maveveagolokana Iesu maerenagi-veripaganiato, netiwato, “Au lagaku talimana rai?” ");
INSERT INTO khz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu na evega-geleato, netiwato, “Talima ta Ierusalema na Ieriko everigo-veniawai aonai, lema talimara na rauparai gekuluati-veniato gevagiato, e rapugana gegaivagirato, roli gevagi-kwaregaato, vonai geraka-kwaniato. ");
INSERT INTO khz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Rupu Veaga velena ta voraupara na everigowai aonai, votalima erawaliato, na elaka-gegelagiato. ");
INSERT INTO khz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Levi na kwalu talimana ta (Rupu Veaganai vetugunagi talimana), maki vovetainamo, votalima erawaliato, na maelaka-gegelagiato. ");
INSERT INTO khz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Na Samaria talimana ta gena lakalaka aonai votalima everawaliato, egitaato aonai, evetugaato. ");
INSERT INTO khz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Laganai eagoto, riga e vine nanuna komatanai epopoto, e ekumurato, ne gena toniki (ass) ai evega-tanu-kauato, wariwari numanai elakagiato, vonai egita-tagoato. ");
INSERT INTO khz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Amoamo ekuliitito aonai, siliva monira ruala numa gatana eveniato, evaikilaato, ‘Etalima pono gitatago-namanamaa. Pene moni ati pene gelegele genai, geku waikule ai vou gemu moni voira panama venimu.’” ");
INSERT INTO khz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iesu everenagito, netiwato, “Goi rakagau notina? Etalima toitoi aorai rai lagana talimana volema talimara na gevagiato talimana genai pita kilagia?” ");
INSERT INTO khz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Rova evevega-ripagiawai talimana na evega-geleato, netiwato, “Egita-vetugaato talimana.” Ne Iesu na evaikilaato, “Ono laka, goi maki wapono kala-tiwa.” ");
INSERT INTO khz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu magena melo geria lakalaka aonai vanuga gautai gekwarato. Vonai gare ta arana Mareta, gena numai evairagerato. ");
INSERT INTO khz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ia mavavine-kavana arana Maria, ne Maria eagoto Velekou gagena kwalanai evetanu-talito, gena kila ekamonagirawai. ");
INSERT INTO khz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mareta ira garia ganigani ekalawai, evekwalaviwai. Gaurai eagoto, evaikilaato, “Velekou, goi otugamagina pa? Tariku na peraokwaniku, au geregaku, avekwalavina. Ono vaikilaa, pe enema veakavaku!” ");
INSERT INTO khz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Velekou na evega-geleato, netiwato, “Mareta, Mareta, gau vogo vavagina aomu gevega-vonuana e gevega-vekwalaviana, ");
INSERT INTO khz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","na gau kwapunamo gerevagi. Maria na iwavagina pevirigia, taa na ia genana ati pene gapi-vagia.” ");
INSERT INTO khz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Toma ta Iesu kapu taai erapalito. Evega-aikito aonai, gena melo taa na evaikilaato, netiwato, “Velekou o, rapali ono vega-ripamai Ioane na gena melo evega-riparato gelegelena.” ");
INSERT INTO khz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iesu na evaikilarato, netiwato, “Gorapalina aonai, epio kilatiwa: ‘Ai Tamamai goi aramu pene veaga; gemu Basileia pene vogomai. ");
INSERT INTO khz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Toma, toma aorai, gama gauganigani pono venimai. ");
INSERT INTO khz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Gema rakava ono tugamagi-piatogara, kwalana ai maki gevega-rakavamaina talimara geria rakava gatugamagi-piatogarana. E veripagani ai ragai pono vaimai.’” ");
INSERT INTO khz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ne Iesu na evaikilarato, netiwato, “Pere gomi ta pogi nugana gatana genai pere ago, pere nogia, neperetiwa, ‘Gataku o, ganigani kiata ana gapi-torea vou, ");
INSERT INTO khz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kwalana au gataku ta gena lakalakai geku ai pema kwara, na au geku ai ganigani aikina pana gupua.’ ");
INSERT INTO khz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aonai votalima numa aona na pere keati, neperetiwa, ‘Ragai ono vega-vekwalaviku. Vanagi warauna pakana-gavua, e au manatuku ria gamaituna. Au ati pana kuliiti, gau kwauta ati pana venimu.’ ");
INSERT INTO khz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Avaikilamina, lewana ia gatana, na ati pene kuliiti, ganigani ati pene venia, na gena nogi ririwarage pakunai pene kuliiti, eririwarana gaura pene venia. ");
INSERT INTO khz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Gaura pakurai, au na gomi avaikilamina: Noginogi ai Palagu na pene venimi, vetavuvetavu ai pio rawali, koekoe ai gemi vanagi pia kala-pakaa. ");
INSERT INTO khz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kwalana pene noginogi talimana pene gapi, pene vetavuvetavu talimana pene rawali, e pene koekoe talimana Palagu na gena vanagi pene kala-pakaa. ");
INSERT INTO khz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gomi tama aomi ai pene rai natuna melona magani pene nogi genai, goi na warowaro pono venia? ");
INSERT INTO khz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Pa gatoi pene nogi genai rogaroga pono venia? ");
INSERT INTO khz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pio tugamagi, gomi rakava talimami, na gau namara natumi venivenira ripami, gaurana gomi Tamami kupai etaluna, ia na Veaga Palaguna genogi-veniana talimara pene venira vegata!” ");
INSERT INTO khz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu na muru-kapu palagu rakavana, egui-atiato, gaurai vomuru-kapu talimana ekilakilato. Taunilimalima vogo na eia ewalato kalana gevevega-kaliagiato, ");
INSERT INTO khz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","na talima reketa gekilato, “Ne Belsebul, palagu rakavara geria vele, gena tiavu ai palagu rakavara egui-atirana.” ");
INSERT INTO khz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Talima reketa na Iesu gekalatovoato, geria ririwa vegailia ta kupa na penema rigo. ");
INSERT INTO khz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iesu na geria tugamagi warau eriparato, gaurai evaikilarato, netiwato, “Kaomani ta pene vekala kavaluga, ia pene rakava, e kwalu ta pene vekala kavaluga genai, ia pene keto. ");
INSERT INTO khz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Gaura pakurai, Satani matotauna pene veware-kavaluga genai, gena basileia raka pene ruga-tiwa? Evetaina akilagiana, kwalana gomi gokilana, au Belsebul gena tiavu ai palagu rakavara agui-atirana. ");
INSERT INTO khz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pene au palagu rakavara Belsebul gena tiavu ai agui-atirana genai, gomi mulimi ai gelakana talimara na palagu rakavara rakavetaina gegui-atirana? Ira na gevega-taunataunaana gomi na kila ati ganira. ");
INSERT INTO khz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na pene au palagu rakavara Palagu gena tiavu ai agui-atirana genai, pio ripa, Palagu gena Basileia, gena vegitatago tiavuna, gomi gemi ai warauna pekwara. ");
INSERT INTO khz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Matiligana talimana gena vagivagi gaura na gena numa pene gita-tagoa genai, gena rinaga pia mia-nama. ");
INSERT INTO khz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Na tiliga iwavagi talimana ta pene vogomai, etalima penema vevagi-venia, ne pene vega-aikia, ia gena vagivagi gaura, eraramanirana gaura, pene veraria, e gena rinaga maparara pene ware-lovolovora. ");
INSERT INTO khz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Rai ati au gataku ia au ekukuna talimana, e rai au goti ati gatao-koukouna ia ekala-lovolovona.” ");
INSERT INTO khz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Palagu rakavana ta talima ta genana elaka-vagito, ne tano lakilaki na elaka-vanagito, aga pene gani netiwato, na agalagi kapuna ta ati erawaliato. Ne ia matotauna ekilato, ‘Ana waikule araokwaniato numanai.’ ");
INSERT INTO khz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ewaikule-waito, numa erawaliato. Numana kala vealeva gitagitana nama iwavagi. ");
INSERT INTO khz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Gaurana ia na palagu rakava vagira taulatoi kwapuna maevaiagorato, maparara gelaka-togato, vonai getaluwai. Gaura pakurai votalima kunenai gena rakava kiata kei, na ikana kavanai gena rakava kamu iwavagi.” ");
INSERT INTO khz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Vokila ekilagiawai aonai, gare ta taunilimalima gutuma aora na ekeato, netiwato, “Goi evega-walamuto e eveni-rurumuto garena nama iwavagi!” ");
INSERT INTO khz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Na Iesu evega-geleato, netiwato, “Evetaina ono kila, Palagu gena kila gekamonagiana e gekwalanaana talimara ne nama!” ");
INSERT INTO khz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Taunilimalima gutuma na Iesu gerugakorope-gavuato, ne evaikilarato, netiwato, “Toma guluna gulu rakavana! Vegailia irauna geririwaana, na vegailia ta ati pia rawalia, Iona, peroveta talimana, vegailianamo. ");
INSERT INTO khz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kwalana Iona vegailia ta Nineva talimara geriai, voia gelegelenai Taunilimalima Natuna vegailiana pene ago egulu geriai. ");
INSERT INTO khz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Palagu na taunilimalima pene veakotaa tomanai, Seba logeana pa kuinina pene rugaiti, egulu pene tamanira, kwalana ia gena tanopara rauvagi na evogomaito, Solomona gena aoneka kilara pene kamonagira ularana. Na iogitaa, talima taa na Solomona evanagiana talimana ea. ");
INSERT INTO khz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Palagu gena Kota kamuna tomanai, Nineva talimara pia rugaiti, toma guluna pia tamanira, kwalana Iona gena vopata gekamonagiato aonai, ira geria rakava na gevetugamagi-kuleto. Na talima ta ea Iona eiwaana.” ");
INSERT INTO khz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Talima taa na lamepa pene kapua aonai, ati pene tao-veavugaa, rivu na ati pene koutalia, na lamepa taotaona kapuna taunataunanai pene taoa, pe pia laka-toga talimara na maekana pia gitaa ulanana. ");
INSERT INTO khz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Goi matamu goi tauniparamu gena lamepa vetaina. Pene goi matamu nama genai, tauniparamu maparana pene waea. Na pene goi matamu rakava genai, tauniparamu maparana pene mukunaa. ");
INSERT INTO khz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gaura pakurai, rogomu pono vetole, maeka goi aomu ai neemukunana nea. ");
INSERT INTO khz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pene goi tauniparamu maparana maeka na pene waea genai, mukuna kiata vagi ati pene mia, ia maeka vagi, lamepa ewae-lovolovona, goi evega-maekamuna vetaina.” ");
INSERT INTO khz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu ekila-gatuto mulinai, Parisea talimana taa na ekeaato, ia goti pia ganigani-koukou; gaurai gena numai eagoto, rapalai etanu-talito. ");
INSERT INTO khz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","VoParisea talimana na egitaato aonai, evevega-kali-rakavato, kwalana Iesu ati eveguligito, (ira tenera velera geria vevega-ripa gelegelenai), na tipo eganito. ");
INSERT INTO khz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gaurana Velekou na evaikilaato, netiwato, “Gomi Parisea talimami gemi kaputi e riti muliramo goguligi-gitakaurana, na aomi vou verari e kala kawakawa na gevonu-poraketoto. ");
INSERT INTO khz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gomi kawa! Gomi ati goripana, muli kavana ekalaato Palaguna na aona kavana maki ia na ekalaato? ");
INSERT INTO khz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Na kaputi e riti aora gaura ati geria e garia talimara pio venira vou, gau maparara gemi ai pia kala-alevara. ");
INSERT INTO khz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Parisea talimami, rakavami kika! Kwalana gomi na Palagu govega-namaana gaura girigirira, gemi ganigani, mamira vega-namagira gaura (tivoga, oporo, gaulaura) tolega gagalana (10) gokalarana, tolega kwapunamo vega-nama gaunai govega-agoana, na kala rorirori e Palagu ulamagi-venina magulina goleana. Gomi na e kala kamura pogoro kalara e vokala keira maki ragai pogoro raokwanira. ");
INSERT INTO khz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Parisea talimami, rakavami kika! Kwalana gemi ririwa rupu ai tanutanu namarai pio tanu, e gemi ririwa maki maketi kapurai pia vega-namami. ");
INSERT INTO khz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Vetugami kika! Gomi kala ati vegailiara kapura vetaira, taunilimalima atara na gelaka-vanagina aonai gemilorana, ira ati geripana voo kapu rakavana.” ");
INSERT INTO khz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Rova gevevega-ripagiawai talimana taa na Iesu evaikilaato, netiwato, “Vevega-ripa taumu o, evetaina okilana aonai, ai maki okilagi-piatogamaina!” ");
INSERT INTO khz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu evega-geleto, netiwato, “Gomi rova govevega-ripagiana talimami maki rakavami kika! Gomi na maruna metaura taunilimalima govega-vuarana, na gimami ririna ta maki geria marunai ati gokori-kauana, ati goveakavarana. ");
INSERT INTO khz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Vetugami kika! Gomi tupumi e gatami na peroveta talimara gevagi-kwaregarato, e gomi na geria kala kapura namara gokalarana. ");
INSERT INTO khz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vovetainai gomi matotaumi tupumi e gatami geria kala gokilagi-matagairana e govega-taunataunarana; taunatauna vagi, tupumi e gatami na peroveta talimara gevagi-kwaregarato, e gomi na geria kala kapura gokalarana. ");
INSERT INTO khz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Gaura pakurai Palagu gena Tugamagi-ilu ekilana, ‘Au na peroveta talimara e apostolo talimara pana tugu-agora geriai, ne reketa pia vagi-kwaregara, reketa pia gui-lovolovora.’ ");
INSERT INTO khz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Vovetaina gaurai, peroveta talimara maparara gevagi-kwaregarato, Palagu na tanopara ekalaato vegata pene vogomai etoma, metauna toma guluna na pia vuaa. ");
INSERT INTO khz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abela gevagi-kwaregaato, voanana evogomaito Sakaria, ia pata veagana e Palagu gena numa veagana vekarawarai gevagi-kwaregaato. Pa, au na avaikilamina, metaura maparara toma guluna na pia vuara! ");
INSERT INTO khz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Rova govevega-ripagirana talimami, rakavami kika! Ripa numana kala-pakana vanagina tavirina gomi na gogapiato. Gomi geregami ati pio laka-toga, na ia laka-toga negetina talimara geria raupara gomi na gokourana!” ");
INSERT INTO khz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesu vokapu na elaka-piatito, ne rova gevevega-ripagiawai talimara e Parisea talimara na gegaoato, gau vogo ia genai geverenagi-agirato, ");
INSERT INTO khz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ia vega-verauleaa ularana, geririwawai gau kwauta pene kilagi-lea, pe pia roli opakaua ulanana. ");
INSERT INTO khz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Vovepaka aonai taunilimalima gutuma kamu vagi warauna getanu-kouto, panatali kapuna aikina, aonai Iesu gena melo evaikila-kunerato, netiwato, “Pio vegitatago-namanama Parisea talimara geria paraoa egoro-agiana mulamulana genana, kwalana ne ira geria opakau kalana gaurai. ");
INSERT INTO khz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Koutali gaura maparara pia matagai, veavuga kilara maparara pia ripara. ");
INSERT INTO khz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Gaura pakurai rakagau mukunai gokilagiato gauna, maekai piave kamonagia, rakagau kovoga mukunanai tegai gokilagi-garigariato gauna, numa kinira na piave keagi-rigoa, taunilimalima maparara na pia kamonagia ularana.” ");
INSERT INTO khz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Gataku maparami, avaikilamina, taunipara pia vagia, na mulinai kala ta ati mapia kalaa talimara kalira na ragai pio kali. ");
INSERT INTO khz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na ana vega-ripami, rai kalina na pio kali: Palagu kalina na pio kali. Taunipara pene vagia mulinai magena tiavu, gomi mapene pia rigomi, kalova egala-vanagivanagina kapunai. Pa, au na avaikilamina, iamo kalina na pio kali! ");
INSERT INTO khz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Manu girigiri imaima maki toea rualanamo gevoirana, ei? Na Palagu na ta vagi maki ati etugamagi-lekwalekwaana. ");
INSERT INTO khz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Taunatauna vegata, gomi repami guira maki maparara Palagu na evega-agi-gitakaurato. Pe ragai pio kali; gomi voimi kamu vagi, manu girigiri vogo voira maki govanagirato.” ");
INSERT INTO khz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Au na avaikilamina, rai na au taunilimalima wailarai pene kilagi-matagaiku, ia maki Taunilimalima Natuna na Palagu gena aneru wailarai pene kilagi-matagaia. ");
INSERT INTO khz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Na rai na au taunilimalima wailarai pene rugaku e pene kilagi-veavugaku, ia maki Palagu gena aneru wailarai pana rugaa e pana kilagi-veavugaa. ");
INSERT INTO khz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Taunilimalima Natuna rai na ekilagi-rakavaana, Palagu na ia gena rakava pene tugamagi-piatogaa, na rai na Veaga Palaguna ekilagi-rakavaana, ia gena rakava ati pene tugamagi-piatogaa. ");
INSERT INTO khz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Iuda talimara geria rupu ai pia agirorimi, e vanuga velera e Kota kamura gekamonagina talimara wailarai pia vaiagomi genai, ragai pio tugamagitugamagi, irau raka nogo kilatiwana. ");
INSERT INTO khz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwalana Veaga Palaguna na votomai rakagau pio kilagi kilara pene vega-ripami.” ");
INSERT INTO khz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Taunilimalima gutuma aora na talima taa na Iesu evaikilaato, netiwato, “Vevega-ripa talimamu o, au kakaku ono vaikilaa, ai tamamai na eraokwanirato rinagara ene warera, pe au kava taa ene veniku.” ");
INSERT INTO khz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu na evega-geleato, netiwato, “Melo o, au rai na gomi ruala gemi rinaga warewarera ularana etaokuto?” ");
INSERT INTO khz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ne evaikilarato, netiwato, “Pio vegita-tago! Rogomi pio vetole, rinaga vogora ririwamagira nogo kalana nea; kwalana taunilimalima geria maguli taunatauna ati geria rinaga vogora na gevega-walarana.” ");
INSERT INTO khz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ne eparapore ekilagiato, netiwato, “Rinaga vogovagi talimana ta gena araga na ganigani namara evega-walarato. ");
INSERT INTO khz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ia etugamagito, ekilato, ‘Au raka ana kala-tiwa? Eganigani maparara eeravai ana tao-koura?’ ");
INSERT INTO khz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ne ekilato, ‘Au evetaina ana kala. Ganigani ataorana numara kunera ana lovora, numa kamura ana kalara. Enai vou au geku ganigani e rinaga maparara pana tao-koura. ");
INSERT INTO khz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ne au matotauku pana vevaikila, “Goi gemu gau namara vogo galagala vavagi potenu-koura rigolo vogovagi ularana. Pe, ono agalagi, ono gani, ono niu e ono verere.” ’ ");
INSERT INTO khz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Na Palagu na evaikilaato, netiwato, ‘Goi gaurai kawa! Toma pogi goi gemu maguli agapi-vagiana gemuna, ne egemu rinaga potao-koura gaura rai na pene vaira?’ ");
INSERT INTO khz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Vetainamo raira matotauramo geria rinaga getao-kouna talimara ati geria rinaga Palagu wailanai.” ");
INSERT INTO khz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ne Iesu gena melo evaikilarato, netiwato, “Gaura pakurai, avaikilamina, gemi maguli ragai pio tugamagira, rakagau pio gani; pa tauniparami rakagau na pio rapugara. ");
INSERT INTO khz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Maguli gau kamuna, a ganigani gau keina, e taunipara gau kamuna, na rapuga gau keina. ");
INSERT INTO khz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kao iotugamagira, ati gevarovarona e ati gekuakuana; ati geria ganigani taokou-agira numara, na Palagu na egupurana! Gomi gau iwa vavagimi, manu kei! ");
INSERT INTO khz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Gomi rai otugamagitugamagina, gemu maguli kiata pono vega-mogaa ripa pa? ");
INSERT INTO khz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Egau keina ati pono kalaa ripa, rakagau gaurai magau reketa ririwarai otugamagitugamagina? ");
INSERT INTO khz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Uraura tiarera iogitara raka gekala-tiwana. Ati geinaguluna e rapuga ati getulina. Na avaikilamina, King Solomona gena verapuga ralemana maki gevanagiana. ");
INSERT INTO khz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pene Palagu na tano gawara vovetaina evega-rapugarana, ira toma gekalana, a pogipogi kalovai pia pia-ragera, Palagu na gomi vovetaina pene vega-rapuga-namanamami. Gomi kamonagi kei talimami! ");
INSERT INTO khz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Gaura pakurai ragai pio poe-irauirau, toma irau rakagau goganina e goniuna; e ragai pio tugamagi-vekwalavi maki. ");
INSERT INTO khz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kwalana Palagu ati ripara talimara maparara negaura getavurana, a gomi Tamami ripana negaura goririwarana. ");
INSERT INTO khz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Na Palagu na Basileia pio tavu-kunea, aonai negaura maparara pene venimi.” ");
INSERT INTO khz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Laveta keina, ragai pio kali, kwalana Tamami gena ririwa aona mavealevana na gena Basileia pene venimi. ");
INSERT INTO khz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gemi rinaga iovoi-agira, monira ati geria e ati garia talimara iovenira. Ati pia rakava paotira iogapira, gemi rinaga kupai iotao-koukoura, vonai ati pia aiki, vonai lema talimara ati pia laka-kavi e palo na maki ati pia vega-rakavara. ");
INSERT INTO khz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kwalana gomi gemi rinaga ariginai, gomi aomi maki vonai.” ");
INSERT INTO khz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Inagulu pakunai pio verapuga-maavu e gemi lamepa pia wae vegata. ");
INSERT INTO khz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Vetugunagi talimara na geria vele numai gealo-tagoana vetaina pio vealo. Vegarawa velekwana na pene waikule, vanagi ai pene koekoe genai, gena vanagi pia raka kala-pakaa ulanana. ");
INSERT INTO khz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Vetugunagi talimara kerora roe voa aonai geria vele pene waikule nama. Taunatauna avaikilamina, gena rapuga pene ligo-kaua, ganigani kapunai pene vega-tanura, ne ganigani pene venira. ");
INSERT INTO khz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Vovetugunagi talimara vealotago roe voa aonai geria vele pene waikule vonama, irauna pogi nugana pa amoamo kavanai pene vogomai. ");
INSERT INTO khz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Na pio ripa, pene numa talimana ripana, arigi orai lema talimana pene vogomai numa pene gita-tagoa, pe lema talimana maki lema pene veraulea. ");
INSERT INTO khz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gaura pakurai gomi maki pio vealo-tago, kwalana Taunilimalima Natuna ati gotugamagiana oranai pene vogomai.” ");
INSERT INTO khz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ne Petero na erenagiato, netiwato, “Velekou, eparapore aimo gemai okilagiana, pa taunilimalima maparara geriai maki?” ");
INSERT INTO khz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Velekou evega-geleto, netiwato, “Rai vorinaga gitatagora talimara na kila ekamonagiana e kala rorirorira ekalana, gena vele na evirigiato, numa e vetugunagi talimara pene gita-tagora, e ganigani maki orara rorirorirai pene venira? ");
INSERT INTO khz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Vovetugunagi talimana, gena vele na evaikilaato gelegelenai einaguluna, penema rawalia nama. ");
INSERT INTO khz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Avaikila-taunataunamina, ia gena vele na rinaga maparara gitatagora talimanai pene taoa. ");
INSERT INTO khz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Na pene vetugunagi talimana pene kila, ‘Au geku vele gena waikule pekwaipo vagi,’ ne vetugunagi marura e garera pene kwarira, e pene gani e pene niu-kawakawa. ");
INSERT INTO khz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Vetugunagi talimana gena vele gena waikule ati etugamagiana tomanai, e ati eripaana oranai pene kwara. Gena vele na peneve pati-kinikinia, e ati gevega-taunataunana talimara ria peneve taoa. ");
INSERT INTO khz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Vovetugunagi talimana gena vele gena ririwa ia ripana, na ati ekala-maavu-veniana e gena vele na ririwa ati ekalarana, kwarikwari kamu iwavagina pene gapia. ");
INSERT INTO khz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A vetugunagi talimana ati ripana gena vele gena ririwa, peneve inagulu kawa, voina pene kwaria, na ati vogo pene gapira. Vogora eveniato talimana genana vogora mapene ririwara; vogovagira eveniato talimana genana vogovagira pene tavu-venia.” ");
INSERT INTO khz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Au kalova avogomai-agiato tanoparai, e geku ririwa pere galakau-kune nama! ");
INSERT INTO khz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na au bapatiso ta pana gapia, e au atugamagitugamagina, pene ago, pana vega-aikia! ");
INSERT INTO khz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gomi gotugamagina, au maino tanoparai avogomai-agiato? Aikina, avaikilamina, veware-kavaluga ulanana avogomaito. ");
INSERT INTO khz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ewagumona pene ago wailarai, numa kwapuna talimara imaima pia vetao-kavaluga, toi kavatai e lua kavatai, lua kavatai e toi kavatai. ");
INSERT INTO khz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tamana natuna maruna goti pia vepaka, natuna maruna tamana goti pia vepaka; tinana natuna vavinena goti pia vepaka, natuna vavinena tinana goti pia vepaka; tegama garena kamuna tegama garena keina goti pia vepaka, e tegama garena keina tegama garena kamuna goti pia vepaka.” ");
INSERT INTO khz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesu na taunilimalima vogo evaikilarato, netiwato, “Pene garo everigona aonai iloa ruparupara gerai-atina gogitarana genai, gokilana, ‘Gura pene keto,’ ne gura eketona. ");
INSERT INTO khz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Waiatina kavana (south) na gavurigo erigona aonai gokilana, ‘Garo tiavu vagi ene rala,’ ne garo tiavu vagi eralana. ");
INSERT INTO khz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Opakau talimami! Tanopara e kupa vegailiara kilagikilagira ripami; rakagau gaurai ewagumona elagani kolemara ati goriparana? ");
INSERT INTO khz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Rakagau gaurai matotaumi na ati gotugamagi-pakaana arigia rorirori? ");
INSERT INTO khz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Etamanimuto talimana goti veagirori kapunai roe wagoagona aonai pio maino. Pene aikina genai, eveagirorina talimana gimanai pene vetao-kaumu, ne eveagirorina talimana na tipura numana gitatagona talimana gimanai pene vetao-kaumu, ne tipura numana gitatagona talimana na tipura numanai peneve kana-gavumu. ");
INSERT INTO khz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Avaikilamuna, ati pono laka-piati, pene ago, gemu metau voina maparana pono vega-voi-vagia.” ");
INSERT INTO khz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Volaganinai talima reketa Iesu genai geagoto, ne gevaraato, Galileia talimara Pilato na evagirato, geria vega-nama gaura Palagu geveniawai aonai; ira ralara vega-nama gaura ralara ria epopo-kourato. ");
INSERT INTO khz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu na evega-gelerato, netiwato, “Gomi gotugamagina, voGalileia talimara vovetaina gevagirato gaurai, voiana evega-taunataunaato, ira geria rakava na Galileia talimara maparara geria rakava evanagirato? ");
INSERT INTO khz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aikina! Au na avaikilamina, pene gemi rakava aora na ati pio vetugamagiwai, gomi maparami ira gekwaregato vetaina pio kwarega. ");
INSERT INTO khz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","A votalima gagalana taula vativati (18) Siloama kovunai koge numa evua-kapuato atarai eketokauto evagirato rakavetaina? Gomi gotugamagina, votalima geria rakava Ierusalema talimara maparara geria rakava evanagirato? ");
INSERT INTO khz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aikina! Au na gomi avaikilamina, pene gemi rakava geriana ati pio vetugamagiwai, gomi maparami maki pio kwarega ira gekwaregato vetaina.” ");
INSERT INTO khz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iesu na eparapore ekilagiato, netiwato, “Talima ta gena vine aragana aonai figi gautupuna evaroato. Aonai eagoto, figi gautupuna vuana etavuato, na vuana ta ati erawaliato. ");
INSERT INTO khz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gaura pakurai gena araga gitatagona talimana evaikilaato, netiwato, ‘Ono gitaa, rigolo toitoi pege aiki, au egautupu gitagitana avogomaina, na vuana ta ati arawaliana. Ono pati laua, kwalana ati ganina gaurai. Ekwano einaguluagi-kawaana.’ ");
INSERT INTO khz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Na araga gitatagona talimana evega-geleto, netiwato, ‘Velekou, ono raokwania, erigolomo kwapuna ene mia-tago. Au na pana lavu-rukurukua e kwano namara pana popo. ");
INSERT INTO khz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ne vuvuana namara pene tugura rigolo wailarai nama, pene aikina genai vou, pono patia.’” ");
INSERT INTO khz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tapati taai Iesu evevega-ripawai rupu ta aonai. ");
INSERT INTO khz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Gare ta vonai palagu rakavana na eporogiato, pe ekala-vitivitiawai rigolo gagalana taula vativati (18). Ia rogena eteveleto, ati erugaitiwai. ");
INSERT INTO khz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu na egitaato, ne ekea-maiato, evaikilaato, “Gare o, goi ne vitina warau poveluga-vagi.” ");
INSERT INTO khz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne Iesu gimana vogare atanai evenapa-kauato aonai, veganamo rogena erorirorito, Palagu evega-rageato. ");
INSERT INTO khz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Rupu gitatagona talimana eparuto, kwalana Iesu Tapati tomanai evevega-namato gaurai. Gaura pakurai ia na taunilimalima evaikilarato, netiwato, “Toma taula toitoi taunilimalima geria inagulu tomara. Votomai vevega-nama ulanana pio vogomai, na Tapati tomanai ragai pio vogomai.” ");
INSERT INTO khz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Velekou na evega-geleato, netiwato, “Opakau talimami! Tapati tomarai gemi polomakau pa toniki ati golugarana, geria numa na ati govaiatirana nanu niu? ");
INSERT INTO khz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A egare, Aperaamo petena garena, Satani na rigolo gagalana taula vativati (18) eligoligoato, au na Tapati tomanai ligoligo na ragai para lugaa pa?” ");
INSERT INTO khz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Vovetaina ekilato aonai, geparu-veniawai talimara nugara gerageto, na taunilimalima maparara na Iesu gena kala nama iwavagira gegitarato aonai geverere-rakavato. ");
INSERT INTO khz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ne Iesu na erenagirato, netiwato, “Palagu gena Basileia rakavetaina? Rakagau genai pana vega-gelegelea? ");
INSERT INTO khz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ia mastadi gautupuna gutuna vetaina. Talima taa na egapiato, gena aragai evaroato. Mastadi gautupuna gutuna ekalato, gautupu ai eagoto, ne kupa manura ia raganai genuguvito.” ");
INSERT INTO khz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesu na maerenagirato, netiwato, “Palagu gena Basileia rakagau genai pana vega-gelegelea? ");
INSERT INTO khz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ia paraoa egoro-agiana mulamulana vetaina, gare taa na girina kiatamo egapiato, paraoa goti ekiro-kourato, ne eraokwaniato, vomulamula na paraoa egoro-agiato e evega-kamuato.” ");
INSERT INTO khz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iesu Ierusalema rauparanai eagowai aonai, vanuga kamura e keira aorai evevega-ripawai. ");
INSERT INTO khz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Talima taa na erenagiato, netiwato, “Velekou, talima maine pia maguli pa?” Iesu na evega-gelerato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Pio vegigi-vanagi, vanagi kokotinana pio laka-toga ulanana, kwalana au na avaikilamina, taunilimalima gutuma ia laka-toga negetina, na ati pia laka-toga. ");
INSERT INTO khz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Numa talimana pene kuliiti, vanagi pene kana-gavua mulinai, gomi muli ai pio ruga-tago, vanagi ai pio koekoe, nopiotiwa, ‘Velekou, ai gema vanagi ono kala-pakaa!’ na ia pene kila, ‘Au ati ripaku gomi ravana na pogo vogomai!’ ");
INSERT INTO khz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ne gomi pio kila, ‘Ai goi ria taganiganiwai e taniu-kouwai; e goi ai gema vanuga gatamanai ovevega-ripawai!’ ");
INSERT INTO khz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Na ia pene kila, ‘Au ati ripaku gomi ravana na govogomaina. Au gekuna iolaka-gerevagi rakava talimami!’ ");
INSERT INTO khz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ne Aperaamo, Isaako, Iakobo, e peroveta talimara maparara pio gitara Palagu gena Basileia aonai, na gomi muli ai pia piatimi; votomai pio tagi, e karikarimi pia vepati. ");
INSERT INTO khz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Taunilimalima garo rageragena na e garo rigorigona na, e waitogana na (north) e waiatina (south) kavana na pia vogomai, pia tanu-tali velekwai Palagu gena Basileia aonai. ");
INSERT INTO khz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pio ripa, ewagumona gekapina talimara pia kune, a gekunena talimara pia kapi.” ");
INSERT INTO khz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Volaganinai Parisea talimara reketa Iesu genai geagoto, gevaikilaato, negetiwato, “Ekapu ono raokwania, makapu taai ono ago, kwalana Heroda eririwana goi pene vagimu netina.” ");
INSERT INTO khz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu evega-geleto, netiwato, “Ioago, vouraura kwaevana iovaikilaa, ‘Au palagu rakavara agui-atirana e taunilimalima avega-namarana, toma, pogipogi, e toma vega-toitoinai geku inagulu pana vega-aiki -namanamaa.’ ");
INSERT INTO khz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Na etoma, pogipogi, ilagaita geku lakalaka pana lakagia vegata, kwalana peroveta talimana irau kapu ai ati pene kwarega, na Ierusalemaimo! ");
INSERT INTO khz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ierusalema, Ierusalema o, goi na peroveta talimara ovagirana e Palagu na etugu-watirana talimara vatu na ovatu-materana. Lagani vogo aririwato, natumi pana kana-gegelagira, kokoloku garena natuna emuku-talirana vetaina, na gomi ati goririwato! ");
INSERT INTO khz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Gaura pakurai gemi vanuga e Rupu Veaga kovagona pene mia. Au na avaikilamina, gomi na au ati pio gitaku vou, pene ago toma ta pene kwara, vonai vou pio kila, ‘Palagu aranai evogomaina talimana ita vega-namaa.’” ");
INSERT INTO khz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tapati tomana taai Iesu (gekeato aonai) eagoto, Parisea geria vekuneagi talimana ta gena numai pia ganigani ulanana, ne taunilimalima na gena kala gegitavagi-gitavagirawai. ");
INSERT INTO khz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Vonai talima ta tauniparana eolooloto, Iesu wailanai etanu-tagowai. ");
INSERT INTO khz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ne Iesu na rova gevevega-ripagiawai talimara e Parisea talimara erenagirato, netiwato, “Tapati tomanai viti vega-nama vororirori pa aikina?” ");
INSERT INTO khz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Na ira ati gekilakilato, taa na maki ati evega-geleato. Ne Iesu na voviti talimana egapiato, evega-namaato mulinai etuguato. ");
INSERT INTO khz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ne evaikilarato, netiwato, “Gomi rai natumu pa gemu polomakau puluka aonai pere keto-rigo genai, goi na Tapati tomanai poro rolo-ragea pa aikina?” ");
INSERT INTO khz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na Iesu ira na ati gevega-geleato. ");
INSERT INTO khz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesu na wariwari talimara egitarato, tanutanu kapura namaramo gegaunarato, ne geria parapore ta ekilagiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Pene talima taa na pene keamu, vegarawa velekwana laka koukounai, kapu namanai ragai pono tanu-tali, kwalana irau velekwa ekune-agiana tauna na talima kamuna ta nekeaana nea. ");
INSERT INTO khz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ne ekeamito talimana pene vogomai, pene vaikilamu, ‘Ono gerevagi, evele gena tanu kapuna ono vega-pakaa.’ Goi pono nuga-rage, ne pono tanu-rigo. ");
INSERT INTO khz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pene goi gekeamuna genai, pono tanu-tali kwano ai pa vuatai. Ne velekwa ekune-agiana talimana pene vogomai genai, pene vaikilamu, ‘Gata, kukunai onove rage.’ Goi velekwa talimara maparara na pia vega-ragemu. ");
INSERT INTO khz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kwalana matotauna evevega-ragena talimana Palagu na pene vega-rigoa, a matotauna evevega-rigona talimana pene gapi-itia.” ");
INSERT INTO khz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iesu na velekwa kuneagina talimana evaikilaato, netiwato, “Pene goi ganigani pa velekwa ta orapalaana genai, gatamu, walakavamu, kalakalamu pa lagamu ai getaluna rinaga talimara ragai pono keara, kwalana ira na goi mapia keamu, goina vekea pia vega-voia. ");
INSERT INTO khz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Na pene velekwa ta pono rapalaa genai, gamaka, tiutiu, gage koru, e mata-kele talimara pono keara, ");
INSERT INTO khz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ne goi Palagu gena vevega-nama pono rawalia. Taunatauna, ira na ati pia vega-voimu, na kala rorirori talimara kwarega na pia kuliiti-wai tomanai vou, voimu ponove rawalia.” ");
INSERT INTO khz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iesu ria geganigani-kouto talimana taa na vokila ekamonagiato aonai, evaikilaato, netiwato, “Palagu gena Basileiai velekwa peneve gania talimana ia pene nama.” ");
INSERT INTO khz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu na evega-geleato, netiwato, “Talima taa na velekwa kamuna ta erapalaato, ne taunilimalima gutuma ekearato. ");
INSERT INTO khz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Velekwa ganiganina tomanai gena vetugunagi talimana ta etuguato, evaikilarato talimara eneve keara, ‘Iovogomai, gau maparara pege kala-maavura.’ ");
INSERT INTO khz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Na ira maparara gekaroveraveto. Ta ekilato, ‘Au tano ta pavoia, aririwana pana gitaa gaurai, ragai pono paru.’ ");
INSERT INTO khz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta maekilato, ‘Au polomakau gagalana (10) pavoira gaurai aagona anave lugagi-tovora, gaurai ragai pono paru.’ ");
INSERT INTO khz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta maekilato, ‘Au ewagumona vou pavegarawa gaurai, ati pana wati.’ ");
INSERT INTO khz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Vetugunagi talimana ewaikuleto, gena vele evaraato. Ne numa talimana maparuna na gena vetugunagi talimana evaikilaato, netiwato, ‘Ono raka-ago vanugai, gamaka, tiutiu, mata-kele e gage rakava talimara pono vaimaira.’ ");
INSERT INTO khz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ne vetugunagi talimana ewaikuleto, ekilato, ‘Vele o, gemu ririwa inaguluna warau pakalaa, na numa rogoti ere vonu.’ ");
INSERT INTO khz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ne vele na vetugunagi talimana maevaikilaato, netiwato, ‘Ono ago raupara-parai e araga raupararai, taunilimalima pono vaikilara, pia vogomai, auna numa penema vonu. ");
INSERT INTO khz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Au na avaikilamina, akearato talimana taa na geku velekwa ganiganina kiatavagi ati pene mamitovoa.’” ");
INSERT INTO khz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Taunilimalima gutuma para Iesu ria geagowai, ne eruga-kuleto, evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Pene talima ta eririwana, au geku ai pene vogomai netina, na ia tamana e tinana, garawana e natuna, kakana tarina e matotauna gena maguli ulamagina ati pene tugamagi-piatogaa genai, ia ati au geku melo. ");
INSERT INTO khz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Rai matotauna gena satauro ati pene vuaa, e muliku ai ati pene laka, ia ati au geku melo. ");
INSERT INTO khz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pene gomi ta eririwana numa ta pene kalaa netina genai, pene tanutali-kune, numa voina pene ripaa, moni pegelegele pa aikina, ei? ");
INSERT INTO khz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Irau inagulu pene vetina, ne ati pene vega-aikia, pia gitaa talimara maparara na pia mamai-agia, ");
INSERT INTO khz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","pia kila, ‘Etalima na etinaato, na ati evega-aikiato.’ ");
INSERT INTO khz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pa arigi vanuga velena, mavanuga velena ta pene vetalia netina, ne ati pene tanutali-kune, gavutina ati pene tavu, gena vetali talimara maparara ragana gagalana (10,000), e kavata velena gena ragana gagala ruala (20,000), ia gevogomai-veniana genai, pene wailara ripa pa? ");
INSERT INTO khz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pene ia ati gelegele genai, ia aranai gena talima reketa pene tugu-agora, golea kamuna pakai roe voa aonai, maino pia gapia rauparana piave kalaa. ");
INSERT INTO khz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Voia gelegelenai rai gena gaura maparara ati pene raokwanira, ia ati au geku melo.” ");
INSERT INTO khz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tamena nama, na pene tamena mamina pene lekwalekwa genai, arigi rauparai mamina mapene waikule-wai? ");
INSERT INTO khz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ia ati gelegele kwano vega-namana e varovaro gaura vega-kalara ulanana; gaura pakurai talima na pia piatogaa. Mategana talimana pene kamonagi!” ");
INSERT INTO khz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takiti koko talimara e kala rakava talimara gutuma Iesu genai geagoto, gena kila pia kamonagira ularana. ");
INSERT INTO khz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Parisea talimara e rova gevevega-ripagiawai talimara gemunemuneto, negetiwato, “Etalima rakava talimara egapi-ragerana e ira ria geganigani-kouna!” ");
INSERT INTO khz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ne Iesu na eparapore geria ekilagiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pere gomi ta gena mamoe tinavu kwapuna (100), aonai ta pere lekwalekwa genai, ia rakagau pere kala? Ia na gagala taulavati kwapuna e taulavati kwapuna (99) tanopakanai pere raokwanira, elekwalekwato mamoena pere tavua pere ago pereve rawalia. ");
INSERT INTO khz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Pereve rawalia genai, pere pani-itia mavererena, ");
INSERT INTO khz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ne numai pere lakagia. Pere kwaragia aonai, gatana e lagana talimara pere keara, pere vaikilara, ‘Itama verere-koukou vou, kwalana geku mamoe, elekwalekwato gauna, maparawalia.’ ");
INSERT INTO khz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Au na avaikilamina, voio gelegelenai rakava talimana ta gena rakava aora na evetugamagiwaina genai, kupai verere kamu iwavagi, kala rorirori talimara gagala taulavati kwapuna e taulavati kwapuna (99) geria kala rorirori pakurai ati gevetugamagi-waina maki pene vanagira.” ");
INSERT INTO khz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Pere gare ta gena siliva monira maparara gagalana (10), aonai kwapuna pere lekwalekwa genai, ia rakagau pere kala? Ia na lamepa pere kapua, numa pere alia, vomoni kwapuna pere tavu-inamainamaa pere ago pereve rawalia. ");
INSERT INTO khz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Pere rawalia genai, ia na gatana e lagana talimara pere keara, pere vaikilara, ‘Itama verere-koukou, kwalana geku siliva monina, elekwalekwato gauna, warau parawalia.’ ");
INSERT INTO khz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Au na avaikilamina, rakava talimana ta gena rakava na evetugamagiwaina genai, Palagu gena aneru vovetaina pia verere.” ");
INSERT INTO khz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu maekilato, “Talima ta natuna ruala. ");
INSERT INTO khz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Tau mulitaina na tamana evaikilaato, netiwato, ‘Tamaku, ita na rinaga ono warera, pe au gavuku rinagara ono veniku.’ Ne rinaga maparara natuna ruala nuganugarai ewarerato. ");
INSERT INTO khz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Toma ati vogo geaikito mulirai, tau mulitaina gena rinaga etao-koukourato, ne kapu raurau ai elakato. Vonai gena rinaga eve ulaulagirato. ");
INSERT INTO khz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Gena rinaga maparara evega-aikirato mulinai, vokapu ai roge kamukamu ekwarato. Ia warau ema lealeato. ");
INSERT INTO khz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ne eagoto, vokapu talimana ta genai inagulu eve tavuto, ne ia na etuguato pae pene gita-tagora. ");
INSERT INTO khz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ia evito-rakavaato gaurai, pae garia ganigani pene ganira netiwato, na voganigani maki taa na ati eveniato. ");
INSERT INTO khz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ne eve vetugamagi-waito, netiwato, ‘Tamaku gena inagulu talimara vogo, e garia gauganigani maki vogo, na au enai vitona evagikuna. ");
INSERT INTO khz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ana waikule, tamaku genai ana laka, ne pana vaikilaa: Tamaku, Palagu wailanai e goi wailamu ai akala-rakavato. ");
INSERT INTO khz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Au ati gelegele goi natumu ai mapono kilagiku; na anogimuna, gemu vetugunagi talimanai pono vega-agoku, napanatiwa.’ ");
INSERT INTO khz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ne ekuliitito, tamana genai elakato. Roe waevogomaiwai aonai, tamana na warauna egitailiaato, ne evetuga-rakavaato, gaurai erakawaila-wailaato, evekapani-waloato, evelavuato. ");
INSERT INTO khz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ne natuna na evaikilaato, netiwato, ‘Tamaku, au Palagu wailanai e goi wailamu ai mageku kala rakava. Au ati gelegele goi natumu ai mapono kilagiku.’ ");
INSERT INTO khz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Na tamana na gena vetugunagi talimara evaikilarato, netiwato, ‘Iokala-veleke! Rapuga nama iwavagina ta iovuamaia, ioma vega-rogagia. Rini ta ririnai ioma lupi-ragea, e tamaka maki gagenai ioma veakalaa. ");
INSERT INTO khz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","E polomakau natuna monapouna ta iovuamaia, iovagia, ne pita gani e pita verere-koukou. ");
INSERT INTO khz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kwalana natuku ea ekwaregato, na mapemaguliwai; elekwalekwato, na mapama rawalia!’ Ne ira maparara geverereto. ");
INSERT INTO khz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Natuna tau kunena araga kapunai. Araga na ewaikuleto, numa eago-veniawai aonai, mari e pala kulura ekamonagirato. ");
INSERT INTO khz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Gaurai vetugunagi talimana ta ekeaato, vokulu kwalana everenagi-agiato. ");
INSERT INTO khz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Vetugunagi talimana na evega-geleato, netiwato, ‘Goi tarimu pewaikule, tamamu na ia namana e magulina pema rawalia gaurai, ia na vetugunagi talimara pevaikilara, polomakau natuna monapouna gauna pege vagia.’ ");
INSERT INTO khz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tau kunena eparu-rakavato, numai ati elaka-togato, ne tamana elaka-piatito, enogiato ene laka-toga ulanana. ");
INSERT INTO khz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Na ia na tamana evaikilaato, netiwato, ‘Ono gitaa, au rigolo rigolo goi lagamu ai ataluna, vetugunagimu aago-venina, gemu ririwa maparara akwalanarana, gemu vevega-nagi ta ati akala-ketoana, e goi na nanikoti natuna ta maki ati ovenikuna au magataku ria vega-verere-agimai ulanana. ");
INSERT INTO khz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A goi enatumu mata-poraga garera geriai gemu rinaga maparara pevevega-verovero-vagira; pewaikule-wai aonai, goi na polomakau natuna monapouna povagia ia gana!’ ");
INSERT INTO khz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tamana evega-geleto, netiwato, ‘Natuku, goi au lagaku ai otalu-vanagivanagina, au geku egaura maparara goi gemu. ");
INSERT INTO khz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A ewagumona ita verere e ita vonelagi e pita verere, kwalana tarimu ekwaregato, na pemaguli; elekwalekwato, na mapatama rawalia.’” ");
INSERT INTO khz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu na gena melo evaikilarato, netiwato, “Rinaga e moni vogo talimana ta emaguliwai. Ne talima reketa na rinaga vogo talimana gevaraato, ia gena rinaga gitatagora talimana na gena rinaga eulaulagirana. ");
INSERT INTO khz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Gaura pakurai rinaga talimana na ekea-togaato, ne evaikilaato, ‘Goi valimu pakamonagia taunatauna pa? Au geku inagulu okalana aonai ono vevaravaragi, kwalana ewagumona goi ati au geku rinaga gitatagora talimana.’ ");
INSERT INTO khz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ne vorinaga gitatagora talimana etugamagito, ekilato, ‘Au geku kamuna na ewagumona, geku inagulu na evega-aikikuna. Rakagau ana kala? Au ati kwalimuku pana araga e noginogi au geku ai nugarage gauna.’ ");
INSERT INTO khz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Etugamagiwai aonai, ekilato, ‘Pama ripa rakagau pana kala! Gaurai pene gaivagiku genai, gataku namara vogovagi geria numai pia vairageku.’ ");
INSERT INTO khz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Gaura pakurai gena kamuna genai gegapi-toreto talimara maparara ekea-koukourato. Ne ta erenagiato, netiwato, ‘Goi gemu gapitore vira?’ ");
INSERT INTO khz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Evega-geleto, netiwato, ‘Olive rigara mata maparara tinavu taula vativati (800).’ Ne rinaga gitatagora talimana na evaikilaato, ‘Gemu gapitore pepana ea, pe ono raka-tanutali, ne tinavu vativati (400) ono taloa.’ ");
INSERT INTO khz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na ta maerenagiato, netiwato, ‘Goi gemu gapitore vira?’ Ia ekilato, ‘Vuiti putera maparara raganana (1,000).’ Ne rinaga gitatagora talimana na evaikilaato, ‘Gemu gapitore pepana ea, ono gapia, ne tinavu taula vativati (800) ono taloa.’ ");
INSERT INTO khz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ikanai rinaga gitatagora talimana rakavana gena aoneka pakunai gena kamuna na evega-rageato. Kwalana tanopara talimara geria kila e tugamagi aonekara na maeka talimara geiwarana. ");
INSERT INTO khz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Au na avaikilamina, etanopara rinagara e monira na taunilimalima pio gatara, kwalana gemi moni pia veaiki genai, gomi mia-vanagivanagi numarai pia gapi-ragemi. ");
INSERT INTO khz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Rai gau keivagina inagulu-agina ripana genai, gau kamu vagina maki inagulu-agina ripana; e rai gau keivaginai pene opakau genai, gau kamu vaginai maki pene opakau. ");
INSERT INTO khz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pene gomi tanopara rinagara e monira inagulu-agira ati ripami genai, Palagu na raka rinaga taunataunara kupai pene venimi pio inagulu-agira? ");
INSERT INTO khz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E pene gomi talima ta gena rinaga ati pio gitatago-namanamara genai, gomi rinaga rai na pene venimi? ");
INSERT INTO khz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Vetugunagi talimana vele ruala vetugunagira ati pene ago-venira ripa. Kwalana ia na ta ati pene ulamagia, a ta pene ulamagia; ta pene vega-taunataunaa, a ta pene opa-venia. Palagu e moni vetugunagira ati pio ago-venira ripa.” ");
INSERT INTO khz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisea talimara moni geulamagi-kamuawai. Iesu gena kila maparara gekamonagirato aonai, gemamai-agiato. ");
INSERT INTO khz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iesu na evaikilarato, netiwato, “Gomi taunilimalima wailarai govekilagi-rorirorina, na Palagu na gomi aomi eriparana. Taunilimalima na gevega-ragerana gaura Palagu na ati eririwarana, ekilagi-piatogarana. ");
INSERT INTO khz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mose gena rova e peroveta talimara geria kila gemiawai pene vogomai Ioane Bapatiso gena lagani ai. Voanana Palagu gena Basileia valina gevopatagiana aonai, taunilimalima maparara gevegigi-togana pia laka-toga ulanana. ");
INSERT INTO khz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kupa e tanopara pia lekwalekwa marauparanai, na rova gena leta keivagina ta pa gena koma ta ati vagi pene lekwalekwa. ");
INSERT INTO khz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Maru taa na garawana pene guia, ne gare ta mapene garawaa genai, ia eveopa-lemana; mamaru taa na vomaru na eguiato garena pene garawaa genai, ia maki eveopa-lemana.” ");
INSERT INTO khz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Rinaga talimana ta etaluwai. Ia rapuga namaramo ekalawai e toma mapararai evererewai e ganigani namaramo eganiwai. ");
INSERT INTO khz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gena numa vanaginai lealea talimana ta arana Laasaro emaoko-tagowai. Ia malakulakuna. ");
INSERT INTO khz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eririwa-rakavawai rinaga talimana gana ganigani momora pere ganira. Kwaeva maki geagowai, ia komatana geremalirawai. ");
INSERT INTO khz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lealea talimana ekwaregato, ne aneru na Aperaamo laganai gevua-agoato. Rinaga talimana maekwaregato, ne getoleato. ");
INSERT INTO khz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kwarega kapunai (Hades) viti evuawai aonai, epoe-rageto, rauvagi ai Aperaamo egitaato, e Laasaro maki ia goti. ");
INSERT INTO khz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ne ekeato, netiwato, ‘Aperaamo, tamaku o, ono gita-vetugaku, Laasaro poro tugua, gimana ririrana nanu ai eneve tura-raia, pe maekumo anama vega-palapalaa, kwalana au ekalova molenai viti kamu vagi avuaana.’ ");
INSERT INTO khz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Na Aperaamo ekilato, ‘Natuku o, ono tugamagia, goi omaguliwai tomarai gau namaramo orawaliwai, a Laasaro gau rakavaramo erawaliwai. Na ewagumona ia evererena, a goi viti ovuaana. ");
INSERT INTO khz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ita vekarawarai maki poga para emiana, gaura pakurai eanana talima ta nenai ati pene wati, e neana na maki ta enai ati pene vogomai.’ ");
INSERT INTO khz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ne rinaga iwavagi talimana ekilato, ‘Tamaku o, anogimuna, Laasaro ono tugua tamaku gena numai. ");
INSERT INTO khz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Au walakavaku imaima; ia na pene vaikilara eviti-vua kapunai nege vogomaina nea.’ ");
INSERT INTO khz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Na Aperaamo ekilato, ‘Mose e peroveta talimara ira ria, pe karora pia kamonagira.’ ");
INSERT INTO khz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Rinaga talimana ekilato, ‘Aikina, tamaku! Pene ekwaregato talimana ta pene ago genai, ira geria rakava na pia vetugamagiwai.’ ");
INSERT INTO khz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aperaamo ekilato, ‘Pene Mose gena rova e peroveta talimara geria kila ati pia kamonagira genai, kwarega na talima ta pene kuliiti-wai maki ati pia kamonagia.’” ");
INSERT INTO khz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu na gena melo evaikilarato, netiwato, “Taunilimalima vega-ketora gaura roe nea pia wala, na pene vega-walara talimana vetugana kekei. ");
INSERT INTO khz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pere nama ia gaagonai vatu kamuna ta pegere kwatu-kaua, ne rawapara ropukelau ai pegere pia-raia, kwalana egirigiri ta rakavai neopa-togaana nea. ");
INSERT INTO khz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Vovetaina gaurai rogomi pio vetole! Pene goi walakavamu kala rakavara ekalana genai, pono kila-waia, pene gena rakava na pene vetugamagiwai genai, gena rakava pono tugamagi-piatogara. ");
INSERT INTO khz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pene ia na toma kwapuna aonai vega-taulatoi kwapuna pene vega-rakavamu, e vega-taulatoi kwapuna pene waikule-wai goi gemu ai, pene kila, ‘Pavetugamagiwai,’ nepenetiwa genai, goi na gena rakava pono tugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apostolo na Velekou gevaikilaato, negetiwato, “Gema kamonagi ono vega-kamura!” ");
INSERT INTO khz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Velekou na evega-gelerato, netiwato, “Pene gomi gemi kamonagi mastadi gautupuna gutuna kamuna vetaina, giri-konevekoneve kiana gomi na egautupu kamuna pa malberi gautupuna pio vaikilaa, ‘Ono velagu-rage, pe rawaparai onove vevaro!’ nopiotiwa genai karomi pene kamonagira.” ");
INSERT INTO khz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Pere gomi ta gemu vetugunagi talimana tano pene lugaa pa mamoe pene gita-tagora mulinai, inagulu kapuna na numai pene vogomai genai, goi na pono vaikilaa, ‘Ono laka vega-veleke, pe onoma ganigani,’ noponotiwa pa? ");
INSERT INTO khz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aikina, goi pono kila, ‘Gaku ganigani ono kala e nanunanu rapugana na pono verapuga, pe pono gita-tagoku; au pana ganigani gatu mulinai vou, goi mapono ganigani.’ ");
INSERT INTO khz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pa vetugunagi talimana gena kamonagi pakunai pene vega-namaa? Aikina. ");
INSERT INTO khz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Gomi maki vovetaina; pene Palagu na pene vaikilami inagulura maparara pio kalara genai, pio kila, ‘Ita vetugunagi talimara gera inagulu.’” ");
INSERT INTO khz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iesu Ierusalema eago-veniawai aonai, Samaria e Galileia vetogara na evanagito. ");
INSERT INTO khz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Vanuga taai elaka-togato, ne lepera talimara gagalana (10) ria geverawalito. Rauvagi ai roe voa aonai geruga-talito, ");
INSERT INTO khz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ira gekeato, negetiwato, “Iesu! Gema Velekou! Ono gita-vetugamai!” ");
INSERT INTO khz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesu na egitarato, ne evaikilarato, netiwato, “Rupu Veaga velera geriai ioago, pe piave gitami.” Ne geagowai aonai, tauniparara gevealevato, genamato. ");
INSERT INTO khz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Talima kwapunamo ira aorai kopina egitaato enamato, ne ewaikule-waito, Palagu evega-rageato. ");
INSERT INTO khz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ia Iesu gagena kwalanai evetiu-talito, evega-namaato. Ia Samaria talimana. ");
INSERT INTO khz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu ekilato, “Talima maparara gagalana pege nama. Taulavati kwapuna ravai nea? ");
INSERT INTO khz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Rakagau gaurai etau polu kwapuna pewaikule-wai, Palagu pema vega-ragea?” ");
INSERT INTO khz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ne Iesu na evaikilaato, netiwato, “Ono kuliiti, ono laka, gemu kamonagi na pevega-magulimu.” ");
INSERT INTO khz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisea talimara reketa na Iesu gerenagiato, Palagu gena Basileia arigi toma pene vogomai. Ia na evega-gelerato, netiwato, “Palagu gena Basileia pene vogomai ati pio gitaa gauna. ");
INSERT INTO khz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Talima ta ati pene kila, ‘Ono gitaa, goi ea!’ pa ‘Goi voa!’; kwalana Palagu gena Basileia gomi aomi ai nea.” ");
INSERT INTO khz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ne ia na gena melo evaikilarato, netiwato, “Toma ta pene kwara aonai, gomi gemi ririwa kamuna Taunilimalima Natuna gena toma taa vagi pogoro gitaa, na ati pio gitaa. ");
INSERT INTO khz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Reketa na pia vaikilaimi, ‘Talimana goi voa!’ pa ‘Talimana goi ea!’ nepiatiwa. Na ragai pio ago, mulirai ragai pio laka. ");
INSERT INTO khz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kwalana eramaana aonai, maekana kupai kavata-kavatana eagona vetaina, Taunilimalima Natuna gena tomai maki vovetaina pene wala. ");
INSERT INTO khz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Na ia vitiviti vogo roe nea pene vuara, etoma guluna na roe pia rugaa. ");
INSERT INTO khz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Taunilimalima Natuna pene vogomai tomana Noa gena lagani ai vetaina. ");
INSERT INTO khz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Taunilimalima maparara geganiwai, geniuwai, maru e gare gevegarawawai, pene vogomai, Noa gena poti aonai elaka-togato tomanai, gutugutu na maparara egugutu-kwaregarato. ");
INSERT INTO khz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lota gena lagani ai maki vovetainamo. Geganiwai, geniuwai, gevoivoiwai, gevarovarowai, numa gekalawai. ");
INSERT INTO khz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na Lota Sodoma eraokwaniato tomanai, kalova e salfa pa vatu matiavura kupa na geketo-rigoto, maparara eporo-mourato. ");
INSERT INTO khz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Taunilimalima Natuna pene matagai genai, maki vovetaina pene wala. ");
INSERT INTO khz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Votomai, pene talima ta numa kukunai etanu-tagona, numai ati mapene laka-toga gena rinaga pene gapira. E pene talima ta aragai genai, ia gena numai ati mapene waikule-wai gena rinaga gapigapira. ");
INSERT INTO khz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lota garawana pio tugamagia! ");
INSERT INTO khz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Rai matotaunamo gena maguli rogona etoleana talimana, gena maguli pene piatogaa; a rai gena maguli epia-togaana talimana maguli pene rawalia. ");
INSERT INTO khz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Avaikilamina, vopogi aonai talima ruala gepa kwapunaimo pia maitu aonai, ta Palagu na pene gapi-vagia, (kwalana pegapi-ragea gaurai), a ta pene raokwania, (kwalana erugaana gaurai). ");
INSERT INTO khz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Gare ruala vuiti kao-agina gauna pia kaoagi-koukoua aonai, ta pene gapi-pakaa, a ta pene raokwania.  ");
INSERT INTO khz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Talima ruala aragai pia inagulu aonai, ta pene gapi-vagia, a ta pene rugaa.” ");
INSERT INTO khz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iesu gena melo na gerenagiato, negetiwato, “Velekou o, ariginai pene wala?” Iesu evega-geleto, netiwato, “Kwarega tauniparara gemiana kapunai, kao maki vonai pia koukou, (pe ira na pia vega-matagaia).” ");
INSERT INTO khz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ne Iesu na gena melo geria parapore ta ekilagiato. Voparapore na pene vega-ripara, vanagivanagi pia rapali e ragai pia moira ulanana. ");
INSERT INTO khz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Evetaina ekilato, “Vanuga gautai Kota ekamonagina talimana ta etaluwai. Ia Palagu kalina na ati ekaliwai, e taunilimalima maki ati ekupa-ragerawai. ");
INSERT INTO khz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Vovanuga wapuna ta Kota ekamonagina talimana genai ewaikule-wai waikule-waiwai, gena rorirori eve ririwamagi-agiawai e ekilawai, ‘Ono veakavaku, pe gevega-rakavakuna talimara akwara ono venira!’ ");
INSERT INTO khz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Gaova kiata erauto, Kota ekamonagina talimana na wapu gena ririwa kalana ati ekalaato. Na toma ta ia matotauna evetugamagito, netiwato, ‘Au Palagu kalina na ati akalina e taunilimalima maki ati akupa-ragerana, ");
INSERT INTO khz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","na gau kwatunamo, ewapu na au evega-tauvitikuna gaurai, gena ririwa kalana ana kalaa, kwalana vanagivanagi evogomaina, au evega-tauvitikuna.’” ");
INSERT INTO khz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Velekou maekilato, “VoKota ekamonagina talimana rakagau netiwato, iokamonagia. ");
INSERT INTO khz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pe rakagau? Palagu na evirigirato talimara, ia genai pogi e lagani getagina e genogina talimara, veagirori tomanai ati pene veakavara? Veakavarai neekwaipona? ");
INSERT INTO khz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Au na avaikilamina, geria rorirori ai veganamo pene veakavara. Na Taunilimalima Natuna pene vogomai aonai, kamonagi tanoparai pene rawalia pa aikina?” ");
INSERT INTO khz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Talima reketa geria tugamagi ira kala rorirori, na taunilimalima maparara kala rakava talimara. Iesu na etalima geria parapore ekilagiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Talima ruala Rupu Veaganai geagoto, geverapalito; ta Parisea talimana, ta takiti-koko talimana. ");
INSERT INTO khz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisea talimana geregana kavatai erugato, ne erapalito, netiwato, ‘Palagu o, avega-namamuna, kwalana au ati talima maparara vetaira, karoverave talimara, kala teveletevele talimara, e vekalakau talimara. Avega-namamuna, kwalana au ati votakiti-koko talimana vetaina. ");
INSERT INTO khz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Epetoma kwapuna aonai au toma ruala avokana, e arawalirana gaura golea gagalana (10) akalarana, ne golea ta goi avenimuna.’ ");
INSERT INTO khz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Na takiti-koko talimana rauvagi ai erugato, ati epoe-rageto kupai, kopana evaleato, ekilato, ‘Palagu o, au rakava talimaku, ono gita-vetugaku!’ ");
INSERT INTO khz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Au na avaikilamina, takiti-koko talimana Palagu na evega-taunataunaato, ia makala rorirorina vanugai ewaikuleto, a Parisea talimana aikina. Kwalana matotauna evevega-ragena talimana Palagu na pene vega-rigoa, a matotauna evevega-rigona talimana pene vega-ragea.” ");
INSERT INTO khz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Talima reketa girigiri Iesu genai gevua-agorato, gimana atarai pene tao-kaua ulanana. Gena melo na gegitarato, ne gekila-wairato. ");
INSERT INTO khz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Na Iesu na girigiri ekea-mairato, gena melo evaikilarato, netiwato, “Egirigiri au geku ai ia vogomai, ragai iogui-waira, kwalana Palagu gena Basileia nevetaira talimara geria. ");
INSERT INTO khz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Taunatauna au na gomi avaikilamina, rai na Palagu gena Basileia ati pene gapi-ragea melo girigiri vetaina, Basileiai ati pene laka-toga.” ");
INSERT INTO khz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iuda talimara geria vele taa na Iesu erenagiato, netiwato, “Vevega-ripa talimamu namana, au rakagau pana kala vou maguli vanagivanagi pana rawalia?” ");
INSERT INTO khz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu na evega-geleato, netiwato, “Goi rakagau gaurai au namaku okilagina? Talima ta ati nama, Palagumo geregana nama. ");
INSERT INTO khz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Rova ripamu, ‘Ragai pono mata poraga, ragai pono vagivagi, ragai pono lema, ragai pono veroli-opakau, tamamu e tinamu pono kupa-ragera.’” ");
INSERT INTO khz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Votalima ekilato, “Au keiku na vegata pene vogomai etoma nerova maparara akwalanarana.” ");
INSERT INTO khz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu na vokila ekamonagiato, ne ekilato, “Goi gau kwatunaimo orapuna. Gemu rinaga maparara ono voi-agira, monira lealea talimara pono venira, ne kupai goi gemu rinaga pono rawalira. Vovetaina pono kala voupe, au muliku ai ponoma laka.” ");
INSERT INTO khz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Vokila ekamonagiato aonai, aona emetau-rakavato, kwalana ia rinaga vogo talimana. ");
INSERT INTO khz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu na egitaato, ne evaikilaato, netiwato, “Rinaga vogo talimara Palagu gena Basileia lakatoganai, geria lakatoga gaoka vagi. ");
INSERT INTO khz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamela rina ilunana pene vanagi gaoka, na gena rinaga vovogo talimana Palaguna Basileiai gena laka-toga gaoka-galagala vagi.” ");
INSERT INTO khz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Taunilimalima na ekila gekamonagiato, ne Iesu gerenagiato, negetiwato, “Na, rai na maguli vanagivanagi pene rawalia?” ");
INSERT INTO khz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu evega-geleto, netiwato, “Taunilimalima na ati pia kalara ripa gaura Palagu na pene kalara ripa.” ");
INSERT INTO khz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petero na evaikilaato, netiwato, “Goi ripamu, ai gema gaura maparara garaokwanirato, mulimu ai galakana.” ");
INSERT INTO khz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu na evaikilarato, “Taunatauna avaikilamina, talima ta gena numa eraokwaniato, pa garawana, kakana, tarina, tamana, tinana, natuna Palagu gena Basileia pakunai, ");
INSERT INTO khz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ia emagulina aonai gau vogo pene rawali, e volaganinai vou maguli vanagivanagi pene rawalia.” ");
INSERT INTO khz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu na gena melo gagalana ruala evaigerevagirato, ne evaikilarato, netiwato, “Iokamonagi! Ita Ierusalemai taveragena. Vonai peroveta talimara na Taunilimalima Natuna valina getalo-kuneato kilara ganira maparara pia taunatauna. ");
INSERT INTO khz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ati Iuda talimara gimarai pia tugu-kaua. Ira na pia vegarevegare-agia, pia mamai-agia e pia kainiua. ");
INSERT INTO khz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pia kwaria e pia vagi-kwaregaa, na toma vega-toitoinai mapene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iesu gena melo na vokila ganina ati gerawaliato. Kila ganina ira geriai veavuga. Ira ati ripara Iesu na rakagau ekilagiato. ");
INSERT INTO khz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu Ieriko ekavinagiato aonai, mata-kele talimana ta raupara pipinai etanu-tagowai, enoginogiwai. ");
INSERT INTO khz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Taunilimalima gutuma raupara na gelaka-vanagiwai ekamonagirato, ne everenagito, “Ne rakagau kuluna?” ");
INSERT INTO khz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Gevaikilaato, negetiwato, “Iesu, Nasareta talimana, elaka-vanagina.” ");
INSERT INTO khz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ne ekea-lailaito, netiwato, “Iesu o, Davida natuna, au ono gita-vetugaku!” ");
INSERT INTO khz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Gelaka-kuneto talimara na gekila-waiato, na ia ekea-vigiragewai, “Davida Natuna o, au ono gita-vetugaku!” ");
INSERT INTO khz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu eruga-talito, ne ekilato, “Iovaimaia!” Ia evogomaito, ne Iesu na erenagiato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Goi rakagau oririwana gemu ai ana kalaa notina?” Ia evega-geleto, netiwato, “Velekou o, mataku ono mai-vega-alira.” ");
INSERT INTO khz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu ekilato, “Matamu ia nama, gemu kamonagi na pevega-namamu.” ");
INSERT INTO khz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Veganamo matana ealirato, epoepoe-namanamato, Iesu mulinai elakato, Palagu evega-rageato. Vokala gegitaato talimara maparara na maki Palagu gevega-rageato. ");
INSERT INTO khz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu Ieriko ai ekwarato, ne vanuga aona na eagowai. ");
INSERT INTO khz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Vonai takiti-koko talimara geria vele ta arana Sakaio; ia moni e rinaga vogo talimana. ");
INSERT INTO khz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ia gena ririwa Iesu kolemana rakavetaina pere gitaa, na talima gutuma e ia kupavagi gaurai, ati egitaato. ");
INSERT INTO khz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gaura pakurai ia eraka-kuneto, sikamoa gautupuna taai epae-rageto, Iesu voanana pene laka-vanagi aonai, pene gitaa ulanana. ");
INSERT INTO khz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu vonai ekwarato, epoe-rageto, ia egitaato, ne evaikilaato, “Sakaio, onoma rigo-rakaraka, kwalana etoma au goi na numai pana talu gaurai.” ");
INSERT INTO khz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ne Sakaio eraka-rigoto, mavererena na Iesu evaiagoato gena numai. ");
INSERT INTO khz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Gegitaato talimara maparara gemunemuneto, negetiwato, “Etalima galama talimana, gena numai eneve talu.” ");
INSERT INTO khz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakaio erugaitito, Velekou evaikilaato, netiwato, “Velekou, ono kamonagi! Geku rinaga kavata viriviri talimara pana venira, e gena rinaga agapi-kawaato talimana vega-vativati pana veni-waia.” ");
INSERT INTO khz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu na evaikilaato, netiwato, “Etoma vevega-maguli enumai pema kwara, kwalana etalima maki Aperaamo natuna. ");
INSERT INTO khz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kwalana Taunilimalima Natuna gelekwalekwato talimara tavutavura e vega-magulira ulanana evogomaito.” ");
INSERT INTO khz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Maparara gekamonagiwai aonai, Iesu na geria parapore ta ekilagiato. Kwalana ia Ierusalema ekavinagiato gaurai, ira matapolu gekilato, Palagu gena Basileia volaganinai pene matagai. ");
INSERT INTO khz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ne ia ekilato, “Raki kamuna talimana ta kapu raurau ai elakato, king pa vele rakina pene gapia vou, mapene waikule-wai. ");
INSERT INTO khz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Rogoti ere laka aonai, gena vetugunagi talimara gagalana (10) ekearato, kolo monira kwapurakwapura ira kwapurakwapura evenirato, ne evaikilarato, netiwato, ‘Au muliku ai pio inagulu-agira, pe moni polura taarana mapio rawalira.’ ");
INSERT INTO khz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Na gena tanopara talimara na ati geririwaawai gaurai, mulina na kilakila getuguato, negetiwato, ‘Ai ati gaririwana etalima ai gema vele ai pene ago.’ ");
INSERT INTO khz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Na votalima na king rakina geveniato mulinai, ewaikule-waito. Ne gena vetugunagi talimara ekearato, pia vega-ripaa, moni polura vira ira kwapurakwapura na gerawalirato. ");
INSERT INTO khz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Talima kunena eagoto, ne evaikilaato, ‘Velekou, kolo monina kwapuna ovenikuto aona na, au na moni gagalana maparawalira.’ ");
INSERT INTO khz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ia na evega-namaato, netiwato, ‘Goi vetugunagi talimamu namana! Gau girigiri oinaguluagi-gitakaurana gaurai, au na vanuga maparara gagalana avenimuna, goi na pono gita-tagora.’ ");
INSERT INTO khz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Vega-rualana eagoto, ne ekilato, ‘Velekou, kwapuna ovenikuto aona na, au na moni imaima maparawalira.’ ");
INSERT INTO khz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Gena vele na evaikilaato, ‘Goi vanuga imaima pono gita-tagora.’ ");
INSERT INTO khz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Vetugunagi talimana ta maevogomaito, ne ekilato, ‘Velekou o, goi gemu moni kwapuna gauna ea, au na muko ai akumuato, atao-togaato. ");
INSERT INTO khz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Au goi kalimu na akalito, kwalana goi ati ovekupa-ragena talimamu. Talima geria gau ogapirana, e ati goi na ovarorato gaura opatirana e okuarana.’ ");
INSERT INTO khz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Gena vele na evaikilaato, ‘Goi vetugunagi talimamu rakavana! Matotaumu gemu kila na pana agirorimu. Goi ripamu au ati vekuparage talimaku, ati au geku gaura agapirana, e ati avarorato gaura apatirana. ");
INSERT INTO khz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Rakagau gaurai au geku moni panikai ati otaorato? Pe au para waikule aonai, mataokauna para rawalia.’ ");
INSERT INTO khz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ne vonai geruga-tagowai talimara evaikilarato, netiwato, ‘Ne moni kwapuna genai nea gauna iogapia, moni gagalana talimana iovenia.’ ");
INSERT INTO khz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na ira na gevaikilaato, ‘Velekou, ia gena moni gagalana warauna pegapira.’ ");
INSERT INTO khz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ia evega-geleto, netiwato, ‘Au na avaikilamina, magena e magana talimana vogora mapana venia, a ati gena e ati gana talimana genai girigiri kiana maki pana gapi-vagia. ");
INSERT INTO khz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na au geparu-venikuna talimara, ati geririwato au ira pana kune-agira negetiwato talimara, iovaimaira, au wailaku ai ioma vagi-kwaregara!’” ");
INSERT INTO khz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ekilakila-gatuto vou, Iesu elaka-kuneto, Ierusalemai everageto. ");
INSERT INTO khz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betepeiti e Betania ekavinagirawai aonai, Olive Golona kavanai, Iesu na gena melo ruala etugu-kunerato, evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Wailara vanuganai ioago. Pio kwara aonai, toniki natuna ta kwatukau pio gitaa, atanai talima ta rogoti ere ragekau. Pio luga-vagia, pio vogomai-agia. ");
INSERT INTO khz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pene talima taa na pene renagimi, pene kila, ‘Rakagau gaurai golugaana?’ nepenetiwa genai, gomi pio kila, ‘Velekou na eririwaana.’” ");
INSERT INTO khz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ne tauria ruala geagoto, Iesu na evaikilarato gelegelenai gerawaliato. ");
INSERT INTO khz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Toniki natuna gelugaawai aonai, toniki gatara na gerenagirato, “Ne rakagau gaurai toniki golugaana?” ");
INSERT INTO khz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Gevega-geleto, negetiwato, “Velekou na eririwaana.” ");
INSERT INTO khz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne Iesu genai geago-agiato. Geria rapuga toniki rogenai geava-kaurato vou, Iesu gevega-tanukauato. ");
INSERT INTO khz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesu eagowai aonai, taunilimalima geria rapuga kamura rauparai geavarawai. ");
INSERT INTO khz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ierusalema warauna ekavinagiato, Olive Golona na everigowai, Iesu gena melo gutuma gevererewai, Palagu gevonevone-agiato, kwalana kala kamu vagira gegitarato gaurai. ");
INSERT INTO khz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Gekilato, “Velekou aranai evogomaina Velena ita vega-namaa! Maino kupai e maeka ralema iwavagina kupa atagaina raimoraimonai!” ");
INSERT INTO khz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ne Parisea talimara reketa na taunilimalima gutuma aora na Iesu gevaikilaato, negetiwato, “Vevega-ripa talimamu, gemu melo ono kila-waira!” ");
INSERT INTO khz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iesu na evega-gelerato, netiwato, “Au na avaikilamina, pene ira pia vaigari genai, evatu pia kogo.” ");
INSERT INTO khz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu vanuga kamuna Ierusalema elaka-kavinagiato, egitaato, ne galamanai etagito, ");
INSERT INTO khz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","netiwato, “etoma gemu maino kwalana poro ripaa nama! Na ewagumona, goi na ati ogitaana. ");
INSERT INTO khz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tomana pene kwara aonai, geparu-venimuna talimara na kwano pia tenua, pia kana gegelagimu, ati gemu rava rauparana. ");
INSERT INTO khz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ne goi e aomu ai getaluna talimara pia gule-vepopo-lovolovo-vagimi; vatu ta maki vatu ta atanai ati pia raokwania, kwalana Palagu gena veveakava emarigoto ati oripaana gaurai.” ");
INSERT INTO khz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iesu Rupu Veaga aonai elaka-togato, voivoi talimara egui-atirato, ");
INSERT INTO khz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","evaikilarato, netiwato, “Veaga Pukana aonai evetaina ekilana, ‘Au geku numa rapali numana pia kilagia,’ na gomi na lema talimara geria kumu kapunai pogo vega-agoa.” ");
INSERT INTO khz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iesu tomara mapararai Rupu Veaga aonai evevega-ripawai. Rupu Veaga velera kamura, e rova gevevega-ripagiawai talimara, e Iuda velera na ia pia vagia rauparana getavuawai. ");
INSERT INTO khz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Na ati geria raupara, kwalana taunilimalima maparara geririwawai, Iesu gena kila ta vagi ragai pia kala-ketoa. ");
INSERT INTO khz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Toma ta Iesu Rupu Veaga aonai evevega-ripawai, Vali Namana taunilimalima evopata-venirawai. Ne Rupu Veaga velera kamura, e rova gevevega-ripagiawai talimara, e Iuda velera Iesu genai geagoto, ");
INSERT INTO khz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","gerenagiato, negetiwato, “Arigi tiavu ai goi na egau okalarana? Rai na etiavu evenimuto?” ");
INSERT INTO khz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iesu na evega-gelerato, netiwato, “Au na maki verenagi ta ana venimi. Pio varaku, ");
INSERT INTO khz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioane gena bapatiso kalana Palagu genana evogomaito, pa taunilimalima geriana?” ");
INSERT INTO khz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ira aorai geveroliverolito, negetiwato, “Pene ita pita kila, ‘Palagu genana,’ nepitatiwa genai, ia pene kila, ‘Rakagau gaurai Ioane ati govega-taunataunaato?’ nepenetiwa. ");
INSERT INTO khz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Na pene ita pita kila, ‘Taunilimalima geriana,’ nepitatiwa genai, taunilimalima maparara na ita vatu na pia vale matera, kwalana ira gekilana, Ioane peroveta talimana, negetina.” ");
INSERT INTO khz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iesu gevega-geleato, negetiwato, “Ai ati ripamai,” negetiwato. ");
INSERT INTO khz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Gaurana Iesu na ira maki evaikilarato, netiwato, “Au na maki arigi tiavu ai egaura akalarana ati pana varami.” ");
INSERT INTO khz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne Iesu na talima eparapore evaikilarato, netiwato, “Talima ta vine aragana evaroato vou, araga gitatagona talimara geriai eraokwaniato. Ne elakato kapu taai. Vonai toma vogo evetalu-agirato. ");
INSERT INTO khz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Vine vuara (grapes) gemerato, ne ia na gena vetugunagi talimana ta etuguato araga gitatagona talimara geriai, vine vuara reketa pene gapira ularana. Na araga gitatagona talimara na gekwariato vou gimana kovagona getugu-waikuleato. ");
INSERT INTO khz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ne vetugunagi talimana ta maetuguato, na ia maki gegalama-veniato, e gevega-nugarageato, gimana kovagona magetugu-waikuleato. ");
INSERT INTO khz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Vetugunagi talimana vega-toitoina maetuguato, na gegalama-rakavarakavato, kopina mamakomakona gepiatiato. ");
INSERT INTO khz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ne araga gatana ekilato, ‘Au rakagau maana kala? Au natuku, aulamagi-iwavagiana melona, ana tugua, atugamagina ia pia nugagi-ragea!’ ");
INSERT INTO khz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Na araga gitatagona talimara na gegitaato aonai, matotaura gevevaikilato, negetiwato, ‘Araga pene gaunaa melona ea, ita vagi-kwaregaa, pe araga ita gera.’ ");
INSERT INTO khz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ne araga mulinai gerolo-atiato, gevagi-kwaregaato.” Iesu everenagito, netiwato, “Araga gatana rakagau pene kala ira geriai? ");
INSERT INTO khz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ia pene vogomai, araga gitatagona talimara pene vagi-veroverora, ne araga talima iraura pene venira.” Taunilimalima na ekilakila gekamonagiato aonai, gekilato, “Aikina, nevetaina ragaina!” ");
INSERT INTO khz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu na egita-kalakalarato, ne erenagirato, netiwato, “Ekilakila Puka Veaga aonai ganina rakagau? Evetaina ekilato, ‘Vatu numa gekalarana talimara na gerugaato, gepia-togaato vatuna, keakwala vatunai eagoto.’ ");
INSERT INTO khz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Rai vovatu atanai pene ketokau talimana pene keto-lovolovo-vagi; e evatu talima ta atanai pene ketokau genai, pene kavi-minamina-vagia.” ");
INSERT INTO khz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Rova gevevega-ripagiawai talimara e Rupu Veaga velera kamura na Iesu tipo vonaimo pia gapia rauparana getavuawai, kwalana ira ripara, Iesu na eparapore e ira ekilagirawai gaurai. Na taunilimalima gutuma getanu-tagowai gaurai gekalito. ");
INSERT INTO khz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Gaura pakurai tipo gegitagitaato. Kapinai vou opakau talimara getugurato, noo kala rorirori talimara vetaira, Iesu pia renagia, gena kila pene irau genai, ia pia gapia, Roma kavanana gimana tiavuna aonai pia taoa. ");
INSERT INTO khz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Voopakau talimara na Iesu gerenagiato, negetiwato, “Vevega-ripa talimamu o, ai ripamai, gemu kila e gemu vevega-ripa-rorirori. Taunilimalima geria raki ati otugamagirana, na goi na Palagu gena raupara ovevega-ripagi-gitakauana mataunataunamu na. ");
INSERT INTO khz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ono vaikilamai, Kaisara, Roma geria vele, genai takiti paia veni pa aikina?” ");
INSERT INTO khz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesu na geria opakau warau egitaato, ne evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Siliva monina ta iovega-gitaku! E rai avuavuna e rai arana?” Ira gevega-geleto, negetiwato, “E Kaisara avuavuna e arana,” negetiwato. ");
INSERT INTO khz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Gaurai Iesu na evaikilarato, “Kaisara gena gau, Kaisara pio venia, Palagu gena gau, Palagu pio venia.” ");
INSERT INTO khz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iesu gena kila taunilimalima wailarai rorirori gaurai, ati geria raupara ia pia opa-leaa, na gena vega-gele na evega-kalirato, ati gekilakilato. ");
INSERT INTO khz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadukea talimara reketa Iesu genai geagoto. Geria tugamagi kwarega talimara ati pia kuliiti-wai. Iesu gerenagiato, gekilato, ");
INSERT INTO khz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Vevega-ripa talimamu o, Mose na rova ai gema evetaina etaloato, ‘Pene tau ta kakana pene kwarega, wapuna pene kwarega-kwania, ati natura genai, vomaru na kakana wapuna pene garawaa, naturia pia gapira kwarega tauna gena.’ ");
INSERT INTO khz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tau walakako maparara taulatoi kwapuna. Tau kunena na gare ta egarawaato, ne ekwaregato, natuna ta ati evega-walaato. ");
INSERT INTO khz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Melo vega-rualana na wapu maegarawaato, ");
INSERT INTO khz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","melo vega-toitoina na maki vovetainamo. Voia aonai ira maparara taulatoi kwapuna, maparara gekwaregato, naturia ta ati gevega-walaato. ");
INSERT INTO khz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ikanai vogare maki ekwaregato. ");
INSERT INTO khz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kuliitiwai tomanai vogare rai garawana? Kwalana ira tauria taulatoi kwapuna na gegarawaato gaurai.” ");
INSERT INTO khz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu na evega-gelerato, netiwato, “Etanoparai maru e gare gevegarawana, ");
INSERT INTO khz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","na roe vogomaina Basileianai, kala rorirori talimara pia kuliiti-wai. Ira ati pia vegarawa. ");
INSERT INTO khz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ira maki ati pia kwarega, na aneru vetaira pia talu. Palagu natunai pia ago, kwalana ira kuliitiwai talimara. ");
INSERT INTO khz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mose na evega-taunataunaato, kwarega na pia kuliiti-wai. Gautupu egalaato valina aonai, Mose na Velekou ‘Aperaamo gena Palagu, Isaako gena Palagu, e Iakobo gena Palagu’ ekilagiato. ");
INSERT INTO khz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Taunatauna, ia maguli talimara geria Palagu, ati kwarega talimara geria Palagu. Kwalana Palagu genai, taunilimalima maparara magulira.” ");
INSERT INTO khz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Rova gevevega-ripagiawai talimara reketa gekilato, “Vevega-ripa talimamu o, vevega-gele namana nea.” ");
INSERT INTO khz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ne voia mulinai ati magerenagi-waiato, gekalito gaurai. ");
INSERT INTO khz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iesu na evaikilarato, netiwato, “Ira rakagau gaurai Keriso Davida natuna negetina? ");
INSERT INTO khz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davida Salamo aonai ekilato, ‘Palagu na au geku Velekou evaikilaato: Au gimaku ripana kavanai ono mai-tanu, ");
INSERT INTO khz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pene ago goi geparu-venimuna talimara goi gagemu kapulenai pana taora.’ ");
INSERT INTO khz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davida na Keriso ia ‘Velekouna’ ekilagito, rakagau gaurai Keriso ia Davida natuna?” ");
INSERT INTO khz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Taunilimalima maparara wailarai Iesu na gena melo evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Rova gevevega-ripagiana talimara geriana rogomi pio vetole. Ira geririwana rapuga mogara pia ligora, maketi kapurai pia loulou, taunilimalima na pia vega-namara ularana. Rupu aorai e gani-koukou kapurai geria ririwa tanutanu kapura namaraimo pia tanu. ");
INSERT INTO khz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ira na wapu geria numa rinagara gevega-aikirana. Geria rapali mogaloki, na geopakauna. Vovetaina gekalana talimara metau kamu iwavagi pia rawalia.” ");
INSERT INTO khz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu eali-itito aonai, moni vogo talimara geria vega-nama monira moni kounai geurarawai egitarato. ");
INSERT INTO khz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wapu lealea ta eagoto, egitaato, gena moni keira rualamo eura-rigorato, (e no toea kwapuna vetaina). ");
INSERT INTO khz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ne Iesu ekilato, “Taunatauna, au na avaikilamina, ewapu na peuraa monina maparara geria veveni peiwara. ");
INSERT INTO khz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kwalana maparara geria moni vovogo aora na kiatanamo pege veni, na ewapu lealea gena moni kika, gena maguli ai pere veakavaa gaura maparara peurara.” ");
INSERT INTO khz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iesu gena melo reketa na Rupu Veaga gekilagiato, gitagitana maralemana, vatu namara na e Palagu gevega-namaato warewarera gaura namara na geveakwagoato, negetiwato. Na Iesu ekilato, ");
INSERT INTO khz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tomana pene kwara, enai gogitarana gaura maparara talima reketa na pia vale-vepopo-rigora, vatu ta vatu ta atanai ati pene mia-tago.” ");
INSERT INTO khz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ne Iesu gerenagiato, negetiwato, “Vevega-ripa talimamu, arigi toma pene wala? E pene wala genai, pene vega-taunataunaa vegailiana rakagau?” ");
INSERT INTO khz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iesu evega-geleto, netiwato, “Gomi rogomi pio vetole, nege opami na nea. Kwalana taunilimalima vogo au araku ai pia vogomai, pia kila, ‘Talimana au ea!’ e, ‘Tomana pekwara!’ nepiatiwa. Na ira mulirai ragai pio laka. ");
INSERT INTO khz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pene gomi na vetali pa veineveine kulura pio kamonagira genai, nugami ragai pia golugolu. Egaura pia wala-kune, na ikana roe nea pene kwara.” ");
INSERT INTO khz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iesu maekilato, “Tanopara ta tanopara ta goti pia galama, kaomani ta kaomani ta goti pia vetali. ");
INSERT INTO khz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kapu vogo aorai tanokepo pene kwara, roge pia kwara, e taunilimalima gutuma viti pia rawali taa na ta pene kawaria. Vevega-kali vegailiara kamura kupa na pia matagai. ");
INSERT INTO khz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Na vogaura rogoti gere wala aonai, ira na gomi pia gapimi, pia vega-vitivitimi. Rupu aonai pia agirorimi, tipura numarai pia tao-togami. King e kavana wailarai pia agirorimi, kwalana au gogapi-ragekuna pakurai. ");
INSERT INTO khz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eegomi gemi lagani namana au vega-taunataunaku ai pio ago. ");
INSERT INTO khz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pio vetugamagi, gemi vevega-gele kilara ragai pio tugamagi-aloalora, ");
INSERT INTO khz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kwalana kila e aoneka au na pana venimi, pia paru-venimi talimara na pia kilawaimi, na ati pia tiliga. ");
INSERT INTO khz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tamami, tinami, kakami, tarimi, kalakalami, e gatami na taunilimalima geriai pia lewami. Gomi reketa maki pia vagi-kwaregami. ");
INSERT INTO khz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Taunilimalima maparara na pia aorakava-vagimi, kwalana au gogapi-ragekuna gaurai. ");
INSERT INTO khz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Na repami guira nivana taa vagi ati pene lekwalekwa. ");
INSERT INTO khz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pio vaigaoka genai, pio maguli.” ");
INSERT INTO khz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Vetali goleara na Ierusalema pia ruga gegelagia pio gitaa, ne pio ripa, Ierusalema roli gevega-rakavaana. ");
INSERT INTO khz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Volaganinai Iudeai getaluna talimara golo ai pia kali-ago. Vanuga kamuna Ierusalemai getaluna talimara vanuga pia raka-kwania, e kuni ai getaluna talimara vanuga kamuna aonai ati pia laka-toga. ");
INSERT INTO khz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kwalana volaganinai Palagu na taunilimalima geria rakava voira pene venira Puka Veaga aonai getalo-kunerato vega-taunataunara. ");
INSERT INTO khz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Volaganinai gare kuviakuvia e melewa valigu garera kika mavetugara! Vitiviti kamu etano ai pene kwara, Palagu na gena pete talimara pene agirorira. ");
INSERT INTO khz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Talima reketa vetali kativara na pia vagi-kwaregara, reketa pia gapi-magulira, tanopara mapararai pia lakagira, piave vega-tipurara; e ati Iuda talimara na Ierusalema pia pana-talia, pene ago geria toma peneve gugulu.” ");
INSERT INTO khz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Garo, uve, e mitiu aorai vegailia pia wala. Tanopara petera rawapara e aku kulura na pia kali-rakava. ");
INSERT INTO khz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Taunilimalima pia kali-agamotu, geria tugamagi maki roe nea pia aiki pia wala gaura pakurai; kwalana kupa tiavura pia veakaveaka. ");
INSERT INTO khz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Volaganinai Taunilimalima Natuna pia gitaa, iloa aona na pene vogomai matiavuna e mamaeka ralema iwavagina ria. ");
INSERT INTO khz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Vogaura pia wala aonai, pio kuliiti, pio poeiti, kwalana vega-magulimi warau pekavinagi.” ");
INSERT INTO khz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iesu na geria parapore ta ekilagiato, netiwato, “Figi gautupuna e gautupu maparara iogitara. ");
INSERT INTO khz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Laura valigura gekakavana gogitarana, gomi goripana, garo gena rala laganina warau pekavinagi. ");
INSERT INTO khz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Voia gelegelenai, gomi maki pene pio gitara, egaura pia wala genai, pio ripa, Palaguna Basileia pekavinagi. ");
INSERT INTO khz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Taunatauna avaikilamina, egulu ati pene aiki, pene ago egaura maparara pia wala. ");
INSERT INTO khz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kupa e tanopara pia lekwalekwa, na au geku kila vou ati pia lekwalekwa, pia mia-vanagivanagi.” ");
INSERT INTO khz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Rogomi pio vetole, ganigani e niuniu kamu vagi, etanopara gena tugamagi gaura na gomi aomi irauna evega-metaurana. Ne votoma na neevega-polumina nea. ");
INSERT INTO khz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kwalana votoma tanoparai getaluna talimara maparara geriai pene kwara. ");
INSERT INTO khz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gaura pakurai pio vegita-tago, pio rapali toma mapararai, pia wala gaura maparara aora na pio kali-maguli ulanana, e Taunilimalima Natuna wailanai roe nea piove ruga-ati.” ");
INSERT INTO khz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tomara mapararai Iesu Rupu Veaga aonai evevega-ripawai, lavilavi aina elakatiwai, Olive Golona kukunai eve genowai. ");
INSERT INTO khz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Amoamo aina taunilimalima maparara Rupu Veaga aonai getanu-kouwai ia gena kila pia kamonagia ulanana. ");
INSERT INTO khz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ati egoro-agiana paraoana velekwana arana Pasova warau evekavito. ");
INSERT INTO khz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Rupu Veaga velera kamura e rova gevevega-ripagiawai talimara na Iesu pia gapia, ne pia vagi-garia rauparana getavuato, kwalana taunilimalima kalira na gekalito. ");
INSERT INTO khz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Volaganinai Satani na Iudas Isakariota, gagalana ruala aorai, talimana ta, eporogiato. ");
INSERT INTO khz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ne Iudas Isakariota eagoto Rupu Veaga velera kamura e Rupu Veaga gegita-tagoawai talimara geria vele geriai, Iesu ira gimarai raka pene taokau-tiwaa navugana genavuga-kouato. ");
INSERT INTO khz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ira geverere-rakavato, gekilagavu-veniato, moni pia venia negetiwato. ");
INSERT INTO khz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iudas Isakariota na egapi-rageato, ne Iesu ira gimarai veavugai pene tao-kaua rauparana etavuawai. ");
INSERT INTO khz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ati egorona paraoana velekwana e vekapawai mamoena pia vagia tomana warau ekwarato. ");
INSERT INTO khz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ne Iesu na Petero e Ioane etugurato, evaikilarato, “Ioago, Pasova velekwana pio kala-maavua, pita gania.” ");
INSERT INTO khz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gevega-geleto, negetiwato, “Ai na ravai paia kala-maavua?” ");
INSERT INTO khz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ne Iesu na evaikilarato, netiwato, “Vanuga kamunai pio laka-toga aonai, talima ta nanu kwagutuna pene vuaa pio rawalia. Mulina na pio ago, ia pene rage numanai pio rage. ");
INSERT INTO khz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ne numa gatana pio vaikilaa, nopiotiwa, ‘Vevega-ripa talimana ekilana: Wariwari kovogana arigia, au mageku melo ria vonai vekapawai mamoena paia gania?’ ");
INSERT INTO khz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ne ia na kovoga kamuna ta numa kukunai pene vega-gitami, gealeva-maavuato. Vonai pio kala-maavua.” ");
INSERT INTO khz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ne gelakato, Iesu na ekilagirato gelegelerai gerawalirato. Vonai Pasova velekwana gekalaato. ");
INSERT INTO khz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Vekapawai mamoena pia gania orana ekwarato. Iesu magena apostolo talimara ria ganigani kapunai getanu-talito. ");
INSERT INTO khz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ne Iesu na evaikilarato, netiwato, “Au geku ririwa kamuna evekapawai mamoena gomi ria na pita gani-koukou kunena vou, pana vitiviti. ");
INSERT INTO khz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kwalana avaikilamina, vekapawai mamoena ati mapana gani-waia, pene ago, vekapawai ganina taunataunana peneve matagai Palagu gena Basileia aonai.” ");
INSERT INTO khz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ne Iesu na kaperi ta egapiato, evega-namaato, netiwato, “Eia iogapia, maparami na pio niua. ");
INSERT INTO khz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kwalana avaikilamina, vine nanuna ati mapana niu-waia, pene ago, Palagu gena Basileia pene vogomai vou.” ");
INSERT INTO khz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne Iesu na pereti egapiato, evega-namaato, ekala-kava-lugaato, evenirato, netiwato, “E au tauniparaku, gomi avenimina; eia pio kalaa, au tugamagi tagoagiku ulanana.” ");
INSERT INTO khz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gegani-gatuto mulinai, kaperi maegapiato, ekilato, “Ekaperi e Vekapawai Valiguna, au ralaku na pene vega-taunataunaa, pene vepopo gomi vega-magulimi ulanana. ");
INSERT INTO khz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Na au pene lewaku talimana enai au goti taganigani-kouna! ");
INSERT INTO khz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Taunatauna, Taunilimalima Natuna pene kwarega, Palagu na ekilagi-kuneato gelegelenai, na pene lewaa talimana rakavana kekei!” ");
INSERT INTO khz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ne matotaura geverenagi-verenagito, ia rai na vovetaina pene kalaa. ");
INSERT INTO khz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ne Iesu gena melo matotaura geveituto, ira aorai rai kamu iwavagi. ");
INSERT INTO khz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu na evaikilarato, netiwato, “Ati Iuda talimara geria vele na taunilimalima getugu-naginagirana, e vekuneagi talimara kamura na geria rorirori tiavura na geririwamagirana, pe taunilimalima na pia vevato-agira negetina. ");
INSERT INTO khz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Na gomi ati vovetaina. Gomi aomi ai tau kunena ia tau mulitainai pene ago, e vele talimana vetugunagi talimanai pene ago. ");
INSERT INTO khz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Rai kamu, ganigani kapunai etanuna talimana pa vetugunagi talimana? Ganigani kapunai etanuna talimana, ei? Na au gomi aomi ai no vetugunagi talimana. ");
INSERT INTO khz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Gomi au geveagare-konekuwai aonai, au lagakau ai gotanu-vaigaokato talimami. ");
INSERT INTO khz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Gaura pakurai au Tamaku na rorirori evenikuto, Basileia ta au geku ekilagiato gelegelenai, au na maki Basileia ta gomi gemi akilagiana. ");
INSERT INTO khz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ne gomi maki au geku Basileiai pita ganikou e pita niu-kou, e gomi terona pa vele tanukaurai pio tanu, Isaraela kwalura gagalana ruala pio agirorira.” ");
INSERT INTO khz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simona, Simona o, ono kamonagi! Au na avaikilamina, Palagu na Satani rorirori eveniato, gomi pene ripaganimi, nama e rakava pene taoware-agira ulanana, noo araga talimana na vuiti e momo etaoware-agirana vetaira. ");
INSERT INTO khz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Na au na gemu warauna arapalito, gemu kamonagi ragai pene moira ulanana. Ne au geku ai pono ruga waikule genai, walakavamu pono vega-tiligara.” ");
INSERT INTO khz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petero evega-geleto, netiwato, “Velekou, au goi goti vegata tipura numanai pia taora e pita kwarega-kou!” ");
INSERT INTO khz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu ekilato, “Petero, au na avaikilamuna, etoma kokoloku rogoti ere kogo aonai, goi na au vega-toitoi pono opa-tagoku, pono kila, ‘Au ati ripaku ia,’ noponotiwa.” ");
INSERT INTO khz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iesu na gena melo evaikilarato, netiwato, “Au na gomi atugumito aonai, ati gemi molo, palaka, pa tamaka. Gomi gau kwautai goraputo pa?” Ira gevega-geleto, negetiwato, “Aikina!” ");
INSERT INTO khz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iesu na maevaikilarato, netiwato, “Na ewagumona gomi rai magena molo e palaka, pene gapira; e rai ati gena vetali kativana, gena kouti pene voi-agia, ta mapene voia. ");
INSERT INTO khz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kwalana au na avaikilamina, Puka Veaga aonai ekilana, ‘Karoverave talimara ria pia vega-agi-koumi.’ Vokila au geku ai pene taunatauna.” ");
INSERT INTO khz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iesu gena melo gevega-geleto, negetiwato, “Ono gitaa, Velekou, vetali kativara ruala ea.” Iesu evega-geleto, netiwato, “Nea, ragaina!” ");
INSERT INTO khz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ne Iesu vanuga kamuna eraokwaniato, Olive Golonai eagoto ekalawai vetaina. Gena melo ia mulinai gelakakauto. ");
INSERT INTO khz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Vonai gekwarato, ne Iesu na evaikilarato, netiwato, “Pio rapali, pe veripagani ai ragai pio moira.” ");
INSERT INTO khz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ne geregana elaka-gerevagito, vatu ta piarana geketo-talina rauna vetainai, evetiu-talito, erapalito. ");
INSERT INTO khz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ekilato, “Tamaku o, pene aomu gelegele genai, eviti kaperina au gekuna ono gapi-gerevagia; na ati au geku ririwa, goimo gemu ririwa.”  ");
INSERT INTO khz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ne aneru ta kupa na emarigoto, Iesu evega-tiligaato. ");
INSERT INTO khz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Vitiviti kamu vagi na ia aona evega-vonuato, ne erapalito maaona maparana, eagoto, garivuna kwano ai eketo-talito no rala kapurona vetaina. ");
INSERT INTO khz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Erapali-gatuto vou, erugaitito, gena melo geriai ewaikule-waito, maitu maiturai erawalirato, rauparara geve kana-gavuto gaurai. ");
INSERT INTO khz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ne ia na evaikilarato, netiwato, “Gomi rakagau gaurai gomaituna? Iokuliiti, iorapali, pe veripagani ai ragai pio moira.” ");
INSERT INTO khz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu roe waekilakilawai aonai, taunilimalima gutuma gekwarato, Iudas Isakariota, gagalana ruala aorai melona ta, ia na ekune-agirato. Iesu eago-veniato pene velavua ulanana. ");
INSERT INTO khz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Na Iesu na evaikilaato, netiwato, “Iudas o, Taunilimalima Natuna vevelavu ai pono lewaa?” ");
INSERT INTO khz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iesu laganai geruga-tagowai melora na gegitaato rakagau pene wala, gaurai gerenagiato, negetiwato, “Vetali kativara na paia patira pa?” ");
INSERT INTO khz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ne ira taa na Rupu Veaga velena kamuna gena vetugunagi talimana vetali kativana na ekulu-veniato, tegana ripana kavana epati-vagiato. ");
INSERT INTO khz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Na Iesu na evaikilarato, “Nea, iovega-aikia!” Votalima tegana egapi-kaulagiato, evega-namaato. ");
INSERT INTO khz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ne Iesu gapigapina gevogomaito talimara, Rupu Veaga velera kamura, Rupu Veaga gitatagona talimara geria kamuna e Iuda velera ia na evaikilarato, netiwato, “Gomi pogo vogomai magemi vetali kativara e magemi gapa, noo karoverave talimana ta gapigapina pogo vogomai vetaina? ");
INSERT INTO khz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Toma mapararai au gomi lagami ai Rupu Veaga aonai, na ati gogapikuto. Eegomi gemi ora, mukuna (pa Satani) gena tiavu orana.” ");
INSERT INTO khz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ne ira na Iesu gegapiato, Rupu Veaga velena kamuna gena numai geago-agiato. Petero maki ia mulinai elakakauto, na mavepakana. ");
INSERT INTO khz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Numa kanana aonai reketa kalova geveagalaato, ne getanu-gegelagiato. Petero maki ira lagarai etanu-talito. ");
INSERT INTO khz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aonai vetugunagi vavinena taa na kalova maekanai egitaato, egita-kalakalaato, evaikilarato, netiwato, “Etalima maki Iesu ekwaruawai!” ");
INSERT INTO khz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Na ia eveopa-tagoto, netiwato, “Vogare a, au ati ripaku ia!” ");
INSERT INTO khz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ati lovana kiana, talima taa na Petero egitaato, evaikilaato, “Goi maki ia taukavara ta!” Na Petero evega-geleto, netiwato, “Vomaru a, au aikina!” ");
INSERT INTO khz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ora ta evanagito mulinai, talima ta maekilato maaona maparana na, netiwato, “Taunatauna, ia maki Iesu ria talimana ta, kwalana ia maki Galileia talimana!” ");
INSERT INTO khz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na Petero evega-geleto, netiwato, “A vomaru a, au ati ripaku goi rakagau okilagiana!” Ia roe waekilawai aonai, kokoloku ekogoto. ");
INSERT INTO khz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ne Velekou eruga-kuleto, ia na Petero egitaato aonai, Velekou gena kila etugamagi-rawaliato, netiwato, “Etoma kokoloku ati pene kogo, pene ago goi na au vega-toitoi pono opa-tagoku.” ");
INSERT INTO khz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Petero elaka-piatito, etagi-rakavarakavato. ");
INSERT INTO khz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iesu gegita-tagoawai talimara na gevegarevegare-agiato e gekwariato. ");
INSERT INTO khz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Matana gekumu-gavurato, gevaikilaato, negetiwato, “Goi peroveta talimana, gaurai ono kilagia, rai na pekwarimu?” ");
INSERT INTO khz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kila rakavara vogo ia geveniato. ");
INSERT INTO khz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Elaganiato, Iuda velera, e Rupu Veaga velera kamura, e rova gevevega-ripagiawai talimara getanu-kouto. Iesu gevaiagoato Iuda kaonselara wailarai. ");
INSERT INTO khz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ne gevaikilaato, negetiwato, “Ono varamai, goi Keriso, (Palagu na ekilagi-gavuato vevega-maguli talimana), pa?” Iesu na evega-gelerato, netiwato, “Pene au na pana vaikilami, gomi na au ati pio vega-taunataunaku, ");
INSERT INTO khz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","e pene verenagi ta pana venimi, ati pio vega-geleku. ");
INSERT INTO khz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Na ewagumona pene ago-vanagivanagi, Taunilimalima Natuna Tiavu Iwavagi Palaguna gimana ripana kavanai pene tanu.” ");
INSERT INTO khz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ne maparara gekilato, “Pe, goi Palagu Natuna notina?” Ia evega-geleto, netiwato, “Gomi na gokilagiana nea.” ");
INSERT INTO khz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ira gekilato, “Raka vega-taunatauna talimara vetaira roe ata tavurana? Ia matotauna muruna na pekilagia pata kamonagia.” ");
INSERT INTO khz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ne tanukou talimara maparara gekuliitito, Iesu gevaiagoato kavana Pilato genai. ");
INSERT INTO khz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Vonai geopagiato, gekilato, “Etalima ea paga rawalia, ai gema taunilimalima evailearana, ekilana, Kaisara, Roma geria vele, gena takiti monira ragai paia venia netina, e matotauna evekilagina, ia Keriso, Palagu na ekilagi-gavuato velena.” ");
INSERT INTO khz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ne Pilato na erenagiato, netiwato, “Goi Iuda talimara geria king pa?” Iesu evega-geleto, netiwato, “Pa, okilagiana nea.” ");
INSERT INTO khz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ne Pilato na Rupu Veaga velera kamura e taunilimalima gutuma evaikilarato, netiwato, “Kepi ta ati parawalia etalima genai.” ");
INSERT INTO khz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Na votaunilimalima gevigi-rageto, gekilato, “Ia gena vevega-ripa kilara na Iudea talimara maparara aora pekala-vevilira. Galileiai etinaato pene vogomai enai.” ");
INSERT INTO khz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Vokila ekamonagiato aonai, Pilato everenagito, netiwato, “Etalima Galileia talimana pa?” ");
INSERT INTO khz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na Pilato eripato, Iesu Heroda gena tiavu kapulenai gaurai genai etugu-agoato. Votoma ia maki Ierusalemai. ");
INSERT INTO khz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Heroda everere-rakavato Iesu egitaato aonai, kwalana Heroda Iesu valina ekamonagiato, e rauvagi evealo-agiato Iesu pene gitaa ulanana. Ia eririwato Iesu na kala irau vagira kalara reketa pene kalara pene gitara. ");
INSERT INTO khz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Gaura pakurai verenagi vogo Iesu eveniato, na ia ati evega-geleto. ");
INSERT INTO khz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Rupu Veaga velera kamura e rova gevevega-ripagiawai talimara vonai geruga-tagowai, Iesu geopagi-rakava-vagiawai. ");
INSERT INTO khz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Heroda magena vetali talimara na Iesu gemamai-agiato, gevegarevegare-agiato, ne rapuga namana taa na gevega-rapugaato, magetugu-waikuleato Pilato genai. ");
INSERT INTO khz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato e Heroda gevelivuwai, na votoma gevegatato. ");
INSERT INTO khz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato na Rupu Veaga velera kamura, e Iuda velera, e taunilimalima maparara ekearato, ");
INSERT INTO khz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","evaikilarato, netiwato, “Gomi na etalima pogo vaimaia au geku ai, gokilana, ia na taunilimalima evailearana nogotina. Ewagumona au na gomi wailami ai gemi kila gaura patavura na kepi ta ati parawalia. ");
INSERT INTO khz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Heroda maki ia genai kepi ta ati perawalia gaurai, mapetugu-waikulea ita gerai. Gomi na gogitaana, ia kepi ta ati ekalaato gauna na ia pene kwarega. ");
INSERT INTO khz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gaura pakurai au na ana kwaria vou pana luga-vagia.”  ");
INSERT INTO khz_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Vanagivanagi evekalagina kalana Pilato na Pasova velekwana tomanai tipura numanai etaluna talimana ta pene lugaa. ");
INSERT INTO khz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Na taunilimalima maparara gekogoto, negetiwato, “Pono vagia! Barabas ono lugaa, ono venimai!” ");
INSERT INTO khz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas tipura numanai gekana-gavuato, kwalana vanuga kamuna aonai gegalamato e talima ta gevagi-kwaregaato gaurai. ");
INSERT INTO khz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato aona evekwalavito Iesu pene luga-vagia, gaura pakurai taunilimalima maevaikila-wairato, ");
INSERT INTO khz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","na ira gekogowai-kogowaiwai, gekilato, “Ono satauroa, ono satauroa!” ");
INSERT INTO khz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Vega-toitoina maevaikilarato, netiwato, “Rakagau gaurai, raka kepi etalima na ekalaato? Au na ia pene kwarega kepina ta ati arawaliana. Gaura pakurai au na maana kwaria vou pana lugaa.” ");
INSERT INTO khz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Na ira gekogoto maaora maparara na, negetiwato, ono satauroa; pene ago ikanai ira geria ririwa eguguluto. ");
INSERT INTO khz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ne Pilato na geria ririwa egapi-rageato. ");
INSERT INTO khz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Vogalama e vagivagi pakurai tipura numanai etaluwai talimana, eluga-vagiato geria noginogi gelegelenai, na Iesu evenirato geria ririwa kalana pia kalaa. ");
INSERT INTO khz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Vetali talimara na Iesu gevaiatiato, geago-agiawai aonai, Kureni talimana ta arana Simona gerawaliato, ia kuni na ema lakatito vanuga kamunai eagowai aonai, vetali talimara na gegapiato, satauro gevega-vuaato. Ia na satauro evuaato, ne Iesu mulinai elakagiato. ");
INSERT INTO khz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Taunilimalima gutuma Iesu mulinai gelakato. Ira aorai reketa gare, ira Iesu getagi-agiawai e getagi-kilakilawai. ");
INSERT INTO khz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ne Iesu eruga-kuleto, evaikilarato, netiwato, “Ierusalema vavinemi! Au ragai iotagi-agiku, na matotaumi iovetagiagi e natumi iotagi-agira. ");
INSERT INTO khz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kwalana toma rakavara pia vogomai, taunilimalima evetaina pia kila, ‘Gaera garera e latara ati gerururana garera pia verere!’ ");
INSERT INTO khz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ne golo kamura pia vaikilara, nepiatiwa, ‘Ai atamai ai ioma ketokau!’ e tipatipa pia vaikilara, ‘Ai iokougavumai!’ ");
INSERT INTO khz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pene au, gautupu maguliku, na evetaina pia kalaku genai, gomi, gautupu kwaregana, raka pia kala-tiwami?” ");
INSERT INTO khz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Karoverave talimara ruala maki Iesu ria gevaiatirato ia ria pia sataurora ulanana. ");
INSERT INTO khz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kapu arana “Repa Gavana Kapunai” gekwarato. Vonai karoverave talimara ria gesatauroato, ta ripana kavanai, ta kaulina kavanai. ");
INSERT INTO khz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesu ekilato, “Tamaku o, geria rakava pono tugamagi-piatogara, kwalana rakagau gekalana ira ati riparia.” Ne iru ulana ta gekalaato vou gena rapuga gewarerato. ");
INSERT INTO khz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Taunilimalima geruga-talito, gemoalewai, e Iuda talimara kamura na gemamai-agiawai, gekilato, “Ia na talima reketa evega-magulirato, na ia matotauna ati pene vevega-maguli pene ia Keriso, Palagu na evirigiato vevega-maguli talimana.” ");
INSERT INTO khz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Vetali talimara na maki gevegarevegare-agiato, ia genai geagoto, vine nanuna vevokaina getugu-rageato, ");
INSERT INTO khz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","gekilato, “Pene goi Iuda talimara geria vele notina, matotaumu ono vevega-maguli.” ");
INSERT INTO khz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Talotalo ta maki ia atanai getaloato, ekilato: “E IUDA TALIMARA GERIA VELE.” ");
INSERT INTO khz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Karoverave talimana ta, ia goti gesatauro-kourato talimana, na egoloato, netiwato, “Goi ati Keriso? Goi matotaumu ono vevega-maguli, ai maki ono vega-magulimai!” ");
INSERT INTO khz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ia taukavana na ekila-waiato, netiwato, “Goi Palagu kalina na ati okalina? Goi maki pono kwarega ia gelegelena. ");
INSERT INTO khz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gau kwatunamo, ita taura ruala takwaregana gera rakava voira pakurai, na etalima ati gena kala rakava.” ");
INSERT INTO khz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Gaurai ia na Iesu enogiato, netiwato, “Iesu, gemu Basileia pono gapia aonai, au pono tugamagiku.” ");
INSERT INTO khz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu na evega-geleato, netiwato, “Taunatauna avaikilamuna, etoma goi au goti paradaiso ai.” ");
INSERT INTO khz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Garogota, ora gauna 12 koloko warau egapiato, garo gena tiavu eaikito, tanopara maparana mukuna na egapi-gavuato, pene ago, ora gauna 3 koloko. ");
INSERT INTO khz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ne Rupu Veaga aonai veaga iwavagi kovogana vega-gelogavuna rapugana pa ketin everale-kavalugato. ");
INSERT INTO khz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu ekogoto, netiwato, “Tamaku o, palaguku goi gimamu ai ataoana!” Ekila-gatuto mulinai ekwaregato. ");
INSERT INTO khz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Vetali velena na vokala egitaato, ne Palagu evega-rageato, netiwato, “Taunatauna vegata, etalima kala rorirori talimana!” ");
INSERT INTO khz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Moale talimara gutuma na vokala ewalato gauna gegitaato, ne kopara gevalerato, gevetugamagi-rakavato, geria numai gewaikuleto. ");
INSERT INTO khz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Na Iesu geripaato talimara maparara, Galileia na ia mulina na gevogomaito garera maki, pakai geverugato, gewalato gaura gegitarato. ");
INSERT INTO khz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Talima ta arana Iosepa Iudea vanugana Arimatea aonai etaluwai. Ia vali nama talimana ta, Palagu gena Basileia ealoawai. Ia maki Iuda kaonsela talimana, na gekila-gavuto kalana ati egapi-rageato. ");
INSERT INTO khz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ne Pilato genai eagoto, Iesu tauniparana pene gapi-rigoa netiwato. ");
INSERT INTO khz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Voia mulinai Iesu tauniparana egapi-rigoato, rapuga kulokulo nama iwavagina na ekumuato, kala kapunai vatu gekoloato kovoganai etao-togaato. Vokala valiguna, aonai kwarega ta rogoti gere taoa. ");
INSERT INTO khz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Vokala Paraire lavilavi ewalato, Tapati ulanana gekala-maavuwai tomana, Tapati roli ekwarawai gaurai. ");
INSERT INTO khz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileia na Iesu ria gevogomaito garera, Iosepa mulina na geagoto, kala kovogana e Iesu tauniparana raka etao-toga-tiwaato gegitaato. ");
INSERT INTO khz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ne gewaikuleto Ierusalema sitinai, mulamula maponara e veiru mulamulara gegapi-maavurato. Tapati tomanai gepikapikato rova ekilana gelegelenai. ");
INSERT INTO khz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Epetoma toma tovotovonai, garegare amoamo elagani maamamaawai kalai geagoto, mulamula ponara namara gekala-maavurato gaura geago-agirato. ");
INSERT INTO khz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kala kougavuna vatuna kule-gerevagi, pakai emia-tagowai gegitaato. ");
INSERT INTO khz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kala kovoganai gelaka-togato, na Iesu Velekou tauniparana ati gerawaliato. ");
INSERT INTO khz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ira roe wageaovoaovowai aonai, maru ruala ira lagarai geruga-talito, geria rapuga kulogarogaro. ");
INSERT INTO khz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Garegare gekali-rakavato, kwano ai geruputalito, ne votalima na gevaikilarato, negetiwato, “Rakagau gaurai maguli talimana kwarega kapunai gotavuana? ");
INSERT INTO khz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ia enai aikina; kwarega na pekuliiti-wai. Galileiai etaluwai aonai, evaikilamito kilana pio tugamagia, ");
INSERT INTO khz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ekilato, ‘Taunilimalima Natuna rakava talimara geriai pia lewaa, pia satauroa, toma vega-toitoinai pene kuliiti-wai.’” ");
INSERT INTO khz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ne garegare na vokila getugamagi-rawaliato. ");
INSERT INTO khz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kala geraokwaniato, gewaikuleto, vogau ewalato gauna valina maparana Iesu gena melo gagalana kwapuna (11) mataukavara ria gevararato. ");
INSERT INTO khz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Garera ea: Maria, Magadala garena, Ioana, Maria, Teimiti tinana, e magare reketa maki. Ira na evali Iesu gena apostolo talimara geria gekilagiato. ");
INSERT INTO khz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Na garegare geria kila ati gevega-taunataunarato, kwalana apostolo getugamagito, ira no gekila-kawakawawai. ");
INSERT INTO khz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Na Petero ekuliitito, erakato, kala kovoganai eve poe-togato, na Iesu gekumuato rapugaramo egitarato. Ne numai ewaikule-wai aonai, gewalato gaura etugamagirato gaurai, evevega-kali-rakavato. ");
INSERT INTO khz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Votomaimo Iesu gena melo ruala Emausa vanuganai gelakato; vokapu vepakana Ierusalema na kilomita gagalana kwapuna (11) vetaina. ");
INSERT INTO khz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Geagowai aonai, gewalato gaura gekilagikilagirawai. ");
INSERT INTO khz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Gelaka-vegupuvegupuwai aonai, Iesu maki elaka-kaviagoto, ira ria gelaka-kouto. ");
INSERT INTO khz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Na taura ruala ati geripato ia voo rai. ");
INSERT INTO khz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iesu na erenagirato, netiwato, “Gomi rakagau erauparai golaka-vegupuvegupu-agiana?” Ne ira tauria ruala geruga-talito, wailara mavetugara. ");
INSERT INTO khz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ne ira ta, arana Kleopa, na evega-geleato, netiwato, “Ierusalema na gevogomaito talimara aorai peiramu goimo geregamu enai pege wala gaura ati ripamu?” ");
INSERT INTO khz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iesu everenagito, netiwato, “Rakagau?” Ira gevega-geleto, negetiwato, “Iesu, Nasareta talimana, genai gewalato gaura. Ia peroveta talimana, Palagu wailanai e taunilimalima maparara wailarai gena kala e gena kila maki matiavura. ");
INSERT INTO khz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ita gera Rupu Veaga velera kamura e gera vekuneagi talimara na gelewaato pene kwarega ulanana, gesatauroato. ");
INSERT INTO khz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na ai gatugamagito, ia na Isaraela talimara pene vega-magulira. Ekala ewalato pene vogomai etoma warauna toma toitoi pege aiki. ");
INSERT INTO khz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Voia atanai, gema gare reketa na ai nugamai pege kala-golugolura. Ira amoamo elagani maamamaavona aonai kalai pege ago. ");
INSERT INTO khz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Na tauniparana ati pege rawalia. Ne pege waikule-wai, pege kila, aneru pege gitara, voaneru na pege vaikilara, ‘Ia warau pemaguliwai,’ nepegetiwa. ");
INSERT INTO khz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ai taukavamai reketa maki kalai pege ago, garegare na pege kilagia vetaina pegeve rawalia, na Iesu ati pege gitaa.” ");
INSERT INTO khz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ne Iesu na evaikilarato, netiwato, “Gomi kawakawa, peroveta talimara geria kila vega-taunataunarai maki kwaipo vavagimi! ");
INSERT INTO khz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keriso vovetaina pene vitiviti mulinai vou maeka ralema iwavagina aonai pene laka-toga, ei?” ");
INSERT INTO khz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ne ia valina Mose e peroveta talimara geria pukai e Puka Veaga maparanai maki getalorato kilara ganira evega-riparato. ");
INSERT INTO khz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Geago-veniawai vanugana Emausa gekavinagiato, ne ia pene laka-vanagi netiwato. ");
INSERT INTO khz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Na gekila-waiato, negetiwato, “Ai ria ita tanu-tago, kwalana pelavia, e garo maki waeverigona.” Ne ira ria vonai gelaka-togato. ");
INSERT INTO khz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ganigani kapunai getanu-tagowai aonai, Iesu na pereti egapiato, evega-namaato, ekala-koruato, tauria ruala evenirato. ");
INSERT INTO khz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ne matara gevekala-pakato, geripato voo ia. Na ira wailarai elekwalekwato. ");
INSERT INTO khz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ne tauria ruala gevevaikilato, negetiwato, “Rauparai evaikilaravona, e Puka Veaganai getalorato kilara ganira gera ekilagi-matagairavona aonai, ita nugara pege tiavutiavu, noowane kalova na egalaravona, ei?” ");
INSERT INTO khz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Rorirori gekuliitito, Ierusalemai gewaikule-waito, Iesu gena melo gagalana kwapuna mataukavara ria tanukou-tago gerawalirato. ");
INSERT INTO khz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ira na tauria ruala na gevaikilarato, negetiwato, “Taunatauna vegata, Velekou pekuliiti-wai e Simona genai maki evevega-matagaito.” ");
INSERT INTO khz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ne tauria ruala na rauparai ewalato gauna e Iesu na pereti raka ekala-koru-tiwato vou, ira na Iesu gegitailiaato geria gekilagiato. ");
INSERT INTO khz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Votalima ruala roe wagekilakilawai aonai, Velekou ira nuganugarai eruga-talito, ne evaikilarato, netiwato, “Maino gemi ai pene mia.” ");
INSERT INTO khz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ira nugara gepale-vagito e gekalito, ira matapolu gekilato, avuavu ta gegitaato. ");
INSERT INTO khz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Na ia ekilato, “Rakagau gaurai nugami gegolugoluna? Rakagau gaurai goaovoaovona? ");
INSERT INTO khz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gimaku e gageku ioma gitara, ne pio ripa e au. Ioma gapi-kaulagiku, ne pio ripa kwalana avuavu ati virigona e ati tiligana, gogitakuna au mavirigoku e matiligaku.” ");
INSERT INTO khz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Waekilatiwato, ne gimana e gagena evega-gitarato. ");
INSERT INTO khz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na ira roe wageaovoaovowai geria verere e geria nuga palevagi pakunai; ne Iesu na erenagirato, netiwato, “Ganigani kiata nea pa?” ");
INSERT INTO khz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ira na magani kapukapu ta geveniato. ");
INSERT INTO khz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ne Iesu na egapiato, wailarai eganiato. ");
INSERT INTO khz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ne evaikilarato, netiwato, “Au gomi ria roe watataluwai aonai, avaikilamiwai: Mose gena rova e peroveta talimara geria kila e Salamo ai au kolemaku getalorato kilara maparara pia vuvuka.” ");
INSERT INTO khz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ne Iesu na aora ekala-pakarato, Puka Veaga kilara ganira pia tugamagi-ilura ulanana. ");
INSERT INTO khz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Maevaikilarato, netiwato, “Evetaina getaloato: Keriso taunatauna roe wapene vitiviti, e toma vega-toitoinai kwarega na pene kuliiti-wai. ");
INSERT INTO khz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","E ia aranai vetugamagiwai e rakava tugamagi-piatogara pia vopatagi-lovolovora tanopara mapararai, Ierusalema na pene vetina. ");
INSERT INTO khz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Egaura vega-taunataunara talimami gomi. ");
INSERT INTO khz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Au matotauku na Tamaku na ekilagi-gavuato Veaga Palaguna pana tugua, atami ai pene matagai. Gomi Ierusalemai pio talu, pene ago, kupa na pene marigo tiavuna pio rawalia.” ");
INSERT INTO khz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Voia mulinai Iesu na Ierusalema na evaiatirato, geagoto Betaniai, ne gimana egapi-itirato, evega-namarato. ");
INSERT INTO khz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Evega-namarawai aonai, Iesu ira evega-gevorato, Palagu na egapi-rageato kupai. ");
INSERT INTO khz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ira na gealiruputali-veniato mulinai, mavererera Ierusalemai gewaikule-waito. ");
INSERT INTO khz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ne Rupu Veaga aonai getaluwai, Palagu gevega-rageawai. ");
INSERT INTO khz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tovotovona na vegata Kila emaguliwai. VoKila Palagu goti gemaguliwai, e voKila Palagu. ");
INSERT INTO khz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ia tovotovona na vegata Palagu goti gemaguliwai. ");
INSERT INTO khz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gau maparara Palagu na ia aona na ekalarato. Palagu na gau taa vagi maraupara poluna taai ati ekalaato, aikina kinavagi. ");
INSERT INTO khz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Maguli ia aonai emiana; vomaguli taunilimalima geria maeka. ");
INSERT INTO khz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Maeka mukuna aonai ewaena, na mukuna na ati etugamagi-ripaato e ati egita-rawaliato. ");
INSERT INTO khz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Palagu na talima ta etuguato, arana Ioane. ");
INSERT INTO khz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ia kila taunatauna kilagikilagina e maeka vega-matagaina ulanana evogomaito. Pe ia genana taunilimalima maparara na vali pia kamonagia e pia vega-taunataunaa. ");
INSERT INTO khz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ia matotauna ati vomaeka, na ia evogomaito, maeka penema kilagia ulanana. ");
INSERT INTO khz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Vomaeka ia maeka taunatauna, tanoparai evogomaito, taunilimalima maparara maeka penema venira ulanana. ");
INSERT INTO khz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kila tanoparai emaguliwai, e vokila aona na Palagu na tanopara ekalaato, na tanoparana ati eripaato. ");
INSERT INTO khz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ia gena tanoparai evogomaito, na gena taunilimalima na ati gegapi-rageato. ");
INSERT INTO khz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A taunilimalima reketa na gegapi-rageato e gevega-taunataunaato gaurai, ia na rorirori evenirato, Palagu natunai pia ago. ");
INSERT INTO khz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ira Palagu natunai geagoto ati taunipara genana. Voo ati tina e tama ralarana pa taunipara gena ririwai pa tina e tama geria ririwai. Aikina, taunilimalima Palagu matotauna gavanana ia natunai evega-agorana. ");
INSERT INTO khz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","VoKila taunilimalima tauniparanai eagoto, ne ai aomai ai emagulito. Ia maekana ralemana iwavagina e tiavuna kamu gagitaato. Voo Palagu na Natuna geregana kwanilova, eveniato maekana ralemana iwavagina e tiavuna. Vega-nama e taunatauna na evonuvonu-rageto. ");
INSERT INTO khz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioane na ia kilana ekilagi-matagaiato, ekeaato, netiwato, “Au na akilagiato talimana ea, natiwato, ‘Au mulikuna pene vogomai talimana na au evanagikuto. Kwalana au rogotina ara wala aonai vegata, ia emaguliwai.’” ");
INSERT INTO khz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ia vega-nama na evonuvonu-rageto. Voo gena vega-nama vetainai ita maparara vevega-nama ataiatai evenirana. ");
INSERT INTO khz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kwalana Palagu na Mose genana rova evenirato, a vega-nama e kila e maguli taunataunana, Iesu Keriso na evogomai-agirato. ");
INSERT INTO khz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tovotovona na vegata pene vogomai etoma talima taa na Palagu ati egitaato. Natuna wala gerega, ia maki Palagu, Tamana laganai etaluna talimana, ia na Palagu ema vega-matagaiato. ");
INSERT INTO khz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ioane gena kila matagai ea. Iuda talimara na Rupu Veaga velera e Levi kwaluna talimara, (E Rupu Veaga aonai vetugunagi talimara), reketa Ierusalema na Ioane genai getugu-agorato, pia renagia ulanana, nepiatiwa, “Ia rai?” ");
INSERT INTO khz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ne Ioane ati evekilagi-veavugato, na wailarai ekila-matagaito, netiwato, “Au ati Keriso, (Palagu na ekilagi-maavuato vevega-maguli tauna)” ");
INSERT INTO khz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Magerenagiato, negetiwato, “Na goi rai? Goi Elia pa?” Ia ekilato, “Au ati Elia.” Magekilato, “Ai na peroveta talimana gaaloana talimana goi pa?” Ia evega-geleto, netiwato, “Aikina!” ");
INSERT INTO khz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ne ira na magerenagi-waiato, negetiwato, “Na goi rai? Gemu vega-gele ono veni-rorirorimai, pe pege tugumai talimara geriai paia ago, paia vega-ripara. Goi matotaumu valimu rakavetaina?” ");
INSERT INTO khz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Gaurai Ioane matotauna evevaravaragito, netiwato, “Au karo ta tanoleanai ekea-lailaina, netina, ‘Velekou gena raupara pio aleva-maavua.’” Isaia peroveta talimana na ekilagi-kuneato gelegelena. ");
INSERT INTO khz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Vovetugu gekalaato talimara voo Parisea talimara. ");
INSERT INTO khz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ne Ioane gerenagiato negetiwato, “Pene goi ati Keriso, e ati Elia, e ati voperoveta talimana, rakagau gaurai goi ovebapatisona?” ");
INSERT INTO khz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ioane evega-geleto, netiwato, “Au nanu namo avebapatisona, na talima ta gomi aomi ai eruga-tagona, gomi ati ripami ia. ");
INSERT INTO khz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ia au mulikuna evogomaina, au ati gelegele, ia gena tamaka walora pana lugara.” ");
INSERT INTO khz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Egau maparara Betania, Ioridana waina vokavanai, gewalato, Ioane evebapatisowai kapunai. ");
INSERT INTO khz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Elaganiato aonai, Ioane na Iesu egitaato, ia genai evogomaiwai, ne ekilato, “Iopoe-ago, nee Palagu gena Mamoe Natuna, ia na tanopara gena rakava pene gapi-vagia. ");
INSERT INTO khz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Au na ia akilagiato, natiwato, ‘Au mulikuna evogomaina talimana na evanagikuto, kwalana au rogotina ara wala aonai vegata, ia emaguliwai.’ ");
INSERT INTO khz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tovotovonai au ati ripaku ia, na au avogomaito nanu na avebapatisona, kwalana Isaraela talimara na Iesu pia ripaa ulanana.” ");
INSERT INTO khz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ne Ioane maekila-matagaiato, netiwato, “Veaga Palaguna agitaato, kupa na emarigoto pune vetaina, ia atanai etikokauto. ");
INSERT INTO khz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tovotovonai au ati ripaku ia, na Palagu na etugukuto, pana vogomai, taunilimalima nanu na pana bapatisora ulanana. Ia na evaikilakuto, netiwato, ‘Goi na talima ta pono gitaa, Veaga Palaguna pene mairigo, atanai pene tikokau. Votalima na taunilimalima Veaga Palaguna na pene bapatisora.’” ");
INSERT INTO khz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ioane ekilato, “Au na agitaato gaurai akilagi-matagaiana, ia Palagu Natuna.” ");
INSERT INTO khz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Elaganiato aonai, Ioane magena melo ruala ria vonai geruga-tagowai. ");
INSERT INTO khz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Geruga-tagowai aonai, Iesu elaka-vanagito, egitaato, ne ekilato, “Iopoe-ago, Palaguna Mamoe Natuna, (gena vekapawai mamoena), iogitaa.” ");
INSERT INTO khz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ioane gena melo ruala na vokila gekamonagiato, ne Iesu mulina na geagoto. ");
INSERT INTO khz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu eruga-kuleto, mulinai gelakakauto talimara ruala egitarato, ne erenagirato, netiwato, “Gomi, rakagau goririwana?” Ira gevega-geleto, negetiwato, “Rabi, goi ariginai otaluna?” Rabi ganina vevega-ripa talimana. ");
INSERT INTO khz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ia evega-geleto, netiwato, “Iovogomai, ioma gitaa.” Ne ia ria geagoto, gena talu kapuna geve gitaato, votoma mamaguluna ia ria gepukato. Oragauna 4 koloko lavi kavanai ");
INSERT INTO khz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ioane gena kila gekamonagiato, ne Iesu mulinai gelakato talimana ta Anduru, Simona Petero tarina. ");
INSERT INTO khz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Anduru na Iesu eraokwaniato. Ati lovana kakana Simona erawaliato, ne evaikilaato, netiwato, “Ai na Mesia paga rawalia.” Mesia ganina Keriso, (Palaguna ekilagi-maavuato vevega-maguli talimana). ");
INSERT INTO khz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ne ia na Simona Iesu genai evaiagoato. Iesu na egitaato, ne evaikilaato, “Goi aramu Simona, Ioane natuna, na goi ewagumona aramu pia keaa Kefas nepiatiwa.” E ara “Kefas” e “Petero” ganira kwapunamo, karo ai ganina “Vatu.” ");
INSERT INTO khz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Elaganiato aonai, Iesu Galileia tanonai ene ago netiwato. Ia na Filipo erawaliato, ne evaikilaato; netiwato, “Muliku ai ono mai-laka.” ");
INSERT INTO khz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo Betesaida talimana, Anduru e Petero ria vanuga kwapuna. ");
INSERT INTO khz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo na Natanaela erawaliato, ne evaikilaato, netiwato, “Mose gena rovai e peroveta talimara geria pukai valina getaloato talimana paga rawalia, ia Iesu, Nasareta talimana, Iosepa natuna.” ");
INSERT INTO khz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaela everenagito, netiwato, “Nasareta na gau namana ta pene vogomai?” Filipo ekilato, “Ono vogomai ono mai-gitaa.” ");
INSERT INTO khz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu na Natanaela egitaato, evogomaiwai, ne ia ekilagiato, netiwato, “Iogita, netalima Isaraela talimana taunatauna, ia genai opakau ta ati emiana.” ");
INSERT INTO khz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaela na erenagiato, netiwato, “Raka poripa-tiwaku?” Iesu na evega-geleato, netiwato, “Filipo na rogotina ere keamu. Au na goi pagita-kunemu figi gautupuna kapulenai roe waotanu-tagovona aonai.” ");
INSERT INTO khz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ne Natanaela na evega-geleato, netiwato, “Vevega-ripa talimamu, goi Palagu Natuna; goi Isaraela Velena.” ");
INSERT INTO khz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu na maevega-geleato, netiwato, “Goi na ovega-taunataunakuna, kwalana au na pavaramu, goi figi gautupuna kapulenai pagitamu, ei? Kala reketa roe nea vou pono gitara, ekala ea pia vanagia.” ");
INSERT INTO khz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ne maevaikilarato, netiwato, “Taunatauna vagi, au na gomi avaikilamina, kupa pene vekala-paka pio gitaa, e Palagu gena aneru pia verage e pia mairigo pio gitara Taunilimalima Natuna genai.” ");
INSERT INTO khz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Toma ruala geaikito mulinai, Kana vanugana aonai vegarawa velekwana ta gekalaato. Kana vanugana Galileia tanona aonai. Vovegarawa velekwana aonai Iesu tinana maki vonai. ");
INSERT INTO khz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","E Iesu magena melo ria maki geririwarato, gaurai vovegarawa velekwana aonai gelaka-togato. ");
INSERT INTO khz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vine nanuna pa wain eaikito, gaurai Iesu tinana na evaikilaato, netiwato, “Ira ati garia vine nanuna.” ");
INSERT INTO khz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu na evaga-geleato, netiwato, “Gare, rakagau gaurai au oma vaikilakuna? Ne gomi gemi inagulu. Au geku toma rogotina ere kwara.” ");
INSERT INTO khz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ne tinana na vetugunagi talimara evaikilarato, netiwato, “Rakagau pene kilagia kalana pio kalaa.” ");
INSERT INTO khz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Vonai vatu kwagutura taula toitoi vega-ruga, Iuda talimara geria kala aleva kalarai geinagulu-agirawai. Vovatu kwagutura kwapurakwapura aorai ganira galon gagala ruala (20) pa gagala toitoi (30) vetaira. ");
INSERT INTO khz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu na vetugunagi talimara evaikilarato, netiwato, “Ne kwagutu nanu na iovega-vonura!” Ne gevega-vonu-poraketorato. ");
INSERT INTO khz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Voia mulinai maevaikilarato, netiwato, “Kiata iogutu-vagia, ioago-agia velekwa ekune-agiana talimana genai.” Gegutu-vagito, ne geago-agiato, ");
INSERT INTO khz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","velekwa kuneagina talimana na vonanu, vine nanunai eagoto gauna, eniu-tovoato. Ia ati ripana vovine nanuna ravanana evogomaito; a nanu gewagiato melora geregariamo ripara. Ne velekwa kuneagina talimana na vegarawa valigu talimana ekea-maiato, ne evaikilaato, netiwato, ");
INSERT INTO khz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Taunilimalima maparara na vine nanuna nama iwavagina getaoati-kuneana, ne velekwa talimara geniu-matena mulinai vou, vine nanuna kiata nama lagina magetao-atiana. Na goi na vine nanuna nama iwavagina pogapi-gaugaua pene vogomai ewagumona.” ");
INSERT INTO khz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","E Iesu gena vegailia irau vagina tovotovona evega-matagaiato Kana vanuganai, Galileia tanona aonai. Voanana ia maekana-ralemana iwavagina e tiavuna kamuna evega-matagaiato, e gena melo na gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Voia mulinai Iesu matinana e matarina melora, e gena melo, geverigoto Kaperanaumai. Vonai toma ati vogo getaluto. ");
INSERT INTO khz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iuda talimara geria Pasova (Iuda talimara kwarega aneruna na tipo evanagirato) velekwana ewailawailato gaurai, Iesu Ierusalemai everageto. ");
INSERT INTO khz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Rupu Veaga aonai taunilimalima na polomakau, mamoe, e pune gevoivoi-agirawai, e talima reketa teipolo ai getanuto moni gevepoe-agirawai erawalirato. ");
INSERT INTO khz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ne vekwari walona ta eraka-vatuato. Gauna na Rupu Veaga na mamoe e polomakau maparara egui-atirato. Moni gevepoe-agirawai talimara geria pata egule-vepoporato, geria moni epopo-lovolovorato. ");
INSERT INTO khz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne pune gevoi-agirawai talimara ekila-wairato, netiwato, “Egau eanana iogapi-atira! Au Tamaku gena numa voivoi numanai ragai iovega-agoa!” ");
INSERT INTO khz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ne gena melo na Puka Veaga aonai evetaloto kilana getugamagi-rawaliato, netina, “Goi gemu numa ulamagina aoku ai noowane kalova egalana.” ");
INSERT INTO khz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Voia mulinai Iuda talimara na gevaikilaato, negetiwato, “Evetaina okalana ganina rakagau? Raka kolemana pene vega-matagaimu ai gemai ai, goi magemu rorirori nopono kala-tiwa?” ");
INSERT INTO khz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu evega-geleto, netiwato, “ERupu Veaga iolovoa, ne toma toitoi aorai au na mapana vega-rugaiti-waia.” ");
INSERT INTO khz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ira na gevaikilaato, negetiwato, “ERupu Veaga rigolo gagala vativati taula toitoi (46) aorai gekalaato. Na goi na toma toitoi aorai mapono vega-rugaiti-waia notina?” ");
INSERT INTO khz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Na Iesu na ia tauniparana Rupu Veaganai evega-gelegeleato. ");
INSERT INTO khz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iesu kwaregana ekuliiti-waito mulinai, gena melo na vokila getugamagi-rawaliato, ne ira na Puka Veaga e Iesu na evega-riparato kilara gevega-taunataunarato. ");
INSERT INTO khz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesu Pasova velekwana tomarai Ierusalemai etaluwai aonai, talima vogo na gevega-taunataunaato, kwalana vegailia irau vagira vogo ekalarato gegitarato gaurai. ");
INSERT INTO khz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Na Iesu na ira ati evega-taunataunarato, kwalana taunilimalima maparara ia ripana namanama. ");
INSERT INTO khz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","E talima ta ati gelegele ia taunilimalima geria maguli rauparara pene vega-ripaa, kwalana taunilimalima maparara aora ia ripana. ");
INSERT INTO khz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisea talimana ta etaluwai arana Nikodemo, ia Iuda talimara geria vekuneagi talimana ta. ");
INSERT INTO khz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Toma ta pogi aonai Iesu genai eagoto ne netiwato, “Rabi, ai ripamai, goi vevega-ripa talimamu, Palagu genana ovogomaito, kwalana vegailia irau vagira okalarana gaura Palagu na ati eveakavaana talimana na ati vagi pene kalara ripa.” ");
INSERT INTO khz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu na evega-geleato, netiwato, “Taunatauna vagi avaikilamuna, ati pene walawai talimana na Palagu gena Basileia ati vagi pene gitaa.” ");
INSERT INTO khz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ne Nikodemo na erenagiato, netiwato, “Talima kamuna ta raka mapene walawai-tiwa? Tinana tinagenai pene laka-toga, ne mapene walawai?” ");
INSERT INTO khz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu evega-geleto, netiwato, “Au na avaikila-taunataunamuna, talima ta Palagu gena Basileia aonai ati pene lakatoga-kawa, na nanu na pene wala e Veaga Palaguna genana maki pene wala talimana vou pene laka-toga. ");
INSERT INTO khz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Taunilimalima tauniparana genana ewalana gauna taunipara, e Palagu Palaguna genana ewalana gauna palagu. ");
INSERT INTO khz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Goi ragai pono vevega-kali evetaina avaikilamuna aonai, kwalana au pakila, ‘Gomi maparami pio walawai.’ ");
INSERT INTO khz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Agi ekuluna, eagona kapurana egavu-agona. Kuluna gokamonagiana, na ravanana evogomaina, e ravanana eagona ati goripaana. Palagu Palaguna genana gewalana talimara maparara maki vovetaina, ati goripana raka gewala-tiwana.” ");
INSERT INTO khz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo maeverenagito, netiwato, “Egaura raka gewala-tiwana?” ");
INSERT INTO khz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu na evega-geleato, netiwato, “Goi Isaraela geria vevega-ripa talimamu, na egaura goi ati ripamu? ");
INSERT INTO khz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Au na avaikila-taunataunamuna, ai ripamai gaura gakilagirana, e gagitarato gaura gakilagi-matagairana, na gema kila ati gogapi-ragerana. ");
INSERT INTO khz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Au na gomi gemi tanopara gaura akilagirana, na ati govega-taunataunakuna, na kupa gaura pana vega-ripami aonai, raka pio vega-taunatauna-tiwaku. ");
INSERT INTO khz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Talima ta kupai ati vagi everageto, na kupana emarigoto talimana gereganamo, ia Taunilimalima Natuna. ");
INSERT INTO khz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mose na tanoleanai gelema egapi-itiato gelegelenai, Taunilimalima Natuna maki vovetaina pia gapi-itia. ");
INSERT INTO khz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Vonai vou ia genai pia vega-taunatauna talimara maparara na maguli vanagivanagi pia vaia. ");
INSERT INTO khz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kwalana Palagu na tanopara eulamagi-kamu-iwavagiato gaurai, Natuna wala geregana evenirato, gaurai ia pia kamonagi-venia talimara maparara ati pia kwarega, na maguli vanagivanagi pia vaia. ");
INSERT INTO khz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kwalana Palagu na Natuna ema tugu-rigioato tanoparai, ati tanopara pene agiroria ulanana, na tanopara ia pakunai pene maguli gaurai. ");
INSERT INTO khz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ia genai evega-taunataunana talimana ati pene agiroria, na ati evega-taunataunana talimana warau eagirorirato, kwalana ia na Palagu Natuna wala geregana ati evega-taunataunaana gaurai. ");
INSERT INTO khz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Voveagirori kwalana ea: Maeka tanoparai warau ema matagaito, na taunilimalima na mukuna geulamagi-kamuato, kwalana geria kala rakava gaurai. ");
INSERT INTO khz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kala rakavara gekalana talimara maparara na maeka gerugaana, maeka ati geago-veniana. Ira gekalina, kwalana geria kala rakavara nege matagaina maekai gaurai. ");
INSERT INTO khz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Na rai raupara taunatauna na ekwalanaana talimana na maeka eago-veniana, ne taunilimalima na pia gita-namanamaa, gena kala namara ekalarato, Palagu genana ekalarato.” ");
INSERT INTO khz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Voia mulinai Iesu magena melo ria Iudea tanona kavana na geagoto. Vonai getaluwai e ebapatisowai. ");
INSERT INTO khz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ioane maki Aenon ai, Salim kavanai, ebapatisowai kwalana nanu kamu vonai. Taunilimalima voanana geagowai, evebapatisorawai. ");
INSERT INTO khz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Voo Ioane tipura numai rogoti gere kana-gavua aonai. ");
INSERT INTO khz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Votama Ioane gena melo Iuda talimana ta ria geveituto. Ira geria kila, arigi veguligi kalanai taunilimalima pene nama iwavagi. ");
INSERT INTO khz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ioane gena melo genai geagoto, ne gekilato, “Vevega-ripa talimamu, Ioridana waina vokavanai goi ria gotaluwai e goi na okilagiato talimana evebapatisona, taunilimalima vogo ia genai geagona.” ");
INSERT INTO khz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ioane evega-geleta, netiwato, “Talima taa na gau ta ati pene rawali-kawaa, na Palagu na kupana pene veni-rigoa vou pene rawalia. ");
INSERT INTO khz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gomi matotaumi na gokamonagikuto, pe ripami au akilato, ‘Au ati Keriso, (Palagu na ekilagi-maavuato vevega-maguli tauna), na au etugu-kunekuto ia wailanai.’ ");
INSERT INTO khz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pene vegarawa vavinena pene garawaa melona na pene garawaa. A pene garawaa koloana gatana eruga-tagona, (e au, Ioane), e gatana ekamonagi-tagona, gatana pene vegarawa koloana karona pene kamonagia genai, pene verere. Vovetaina gaurai au verere na pavonuvonu-rage. ");
INSERT INTO khz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ia pene kamu, na au pana kei.” ");
INSERT INTO khz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Kukuna na emarigoto talimana gau maparara atarai; tanopara na evogomaito talimana ia tanopara talimana e tanopara kilaramo pene kilagi. Kupa na evogomaito talimana gau maparara atarai. ");
INSERT INTO khz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ia vonai egitato e ekamonagito gaura ekilagi-matagairana, na talima taa na gena kila ati egapi-rageana. ");
INSERT INTO khz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Rai na ia gena kila egapi-rageana talimana na evega-taunatauna vagiana, Palagu taunatauna vegata. ");
INSERT INTO khz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kwalana Palagu na etuguato talimana Palagu gena kila pene kilagia, kwalana Palagu na gena Veaga Palaguna na eveniato e evega-vonuvonu-rageana. ");
INSERT INTO khz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tamana na Natuna eulamagiana, e gau maparara ia gimanai etao-kaurato. ");
INSERT INTO khz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Rai na Natuna evega-taunataunaana talimana na maguli vanagivanagi pene vaia. A Natuna ati evega-taunataunaana talimana na maguli ati pene vaia, na Palagu gena paru ia atanai pene mia.” ");
INSERT INTO khz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisea talimara warau gekamonagito, Iesu na talima vogo egapirato, gena melo ai evega-agorato e ebapatisorato, Ioane ati vogo egapirato. ");
INSERT INTO khz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Na Iesu matotauna na ta ati ebapatisoato; gena melomo gebapatisowai. ");
INSERT INTO khz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesu eripato ia valina Parisea talimara na gekamonagiato, ne Iudea eraokwaniato, Galileiai ewaikule-waito. ");
INSERT INTO khz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria tanona na elaka-vanagito Galileiai. ");
INSERT INTO khz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria vanugana taai ekwarato. Vovanuga arana Sika. Vovanuga Iakobo na natuna Iosepa eveniato tanona laganai. ");
INSERT INTO khz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iakobo gena puluka maki vonai. Iesu evogomaito, eraga-manukouto, gaurai puluka laganai etanu-talito. Ora gauna 12 koloko garogota-kilipaaluna. ");
INSERT INTO khz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Etanu-tagowai aonai, Samaria garena ta nanu gutu eagoto, ne Iesu na enogiato, netiwato, “Nanu kiata onoma veniku, pe anama niua.” ");
INSERT INTO khz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Gena melo vanugai, ganigani voi geagoto. ");
INSERT INTO khz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria garena evega-geleto, netiwato, “Goi Iuda taumu, au Samaria gareku, rakagau gaurai au geku ai nanu onogina?” Vovetaina ekilato, kwalana Iuda talimara Samaria talimara ria ati gevetau-kava-veveniwai. ");
INSERT INTO khz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na Iesu na evega-geleato, netiwato, “Pere Palagu gena veveni gauna poro ripaa, e poro ripa maki, nanu kiato gemu ai enogiana talimana rai genai, ia poro nogia, ia na maguli nanuna pere venimu.” ");
INSERT INTO khz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Gare ekilato, “Velekou, goi ati gemu keme e puluka maki ropu vagi. Nemaguli nanuna ariginai pono gapia? ");
INSERT INTO khz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Goi iwavagi, na ai tenemai Iakobo kei ei? Epuluka ia na evenimaito, e ia matotauna na eniuawai, natuna maparara na e gena polomakau e mamoe lavetara na maki geniuawai.” ");
INSERT INTO khz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu na maevega-geleato, netiwato, “Enanu pia niua talimara maparara nanuna mapene kala-waira. ");
INSERT INTO khz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Na au na pana venia nanuna pene niua talimana, nanuna ati pene kala-waia. Kwalana au na pana venia nanuna ia aonai pulukai pene ago, pene vonewai-vonewai e maguli vanagivanagi pene venia.” ");
INSERT INTO khz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Vogarena enogiato, netiwato, “Velekou, nenanu ono veniku, pe nanuna ati mapene kalawaiku, e enai nanu gutu ragai mapana vogomai.” ");
INSERT INTO khz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Na Iesu na evaikilaato, netiwato, “Ono ago, garawamu ono vekeaa, pe taumi ruala pio vogomai.” ");
INSERT INTO khz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Vogare evega-geleto, netiwato, “Au ati garawaku.” Iesu ekilato, “Ne okila-taunataunana, ‘Au ati garawaku’ notina ne rorinai. ");
INSERT INTO khz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gemu kila taunatauna, kwalana goi vega-imaima vegata ovegarawato, e roe nogarawaana talimana ne ati goi garawamu.” ");
INSERT INTO khz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Vogare ekilato, “Velekou, au ewagumona pama ripa, goi peroveta talimamu. ");
INSERT INTO khz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ai tupumai e gatamai na egolo ai Palagu gealiruputali-veniawai, a gomi Iuda talimami gokilana, aliruputali kapuna Ierusalemai voa, pe taunilimalima vonai pia aliruputali.” ");
INSERT INTO khz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu ekilato, “Gare, geku kila pono vega-taunataunaa, toma ta evogomaina, egolo ai e Ierusalemai maki Tamara ati pio aliruputali-venia. ");
INSERT INTO khz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gomi Samaria talimami na goaliruputali-veniana Palaguna ati ripami; a ai na gaaliruputali-veniana Palaguna ripamai, kwalana vevega-maguli ai Iuda talimamai gemana evogomaina. ");
INSERT INTO khz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Na tomana evogomaina e warau pekwara ea, aliruputali talimara taunataunara na Tamara Palagu palagu ai e taunataunai pia aliruputali-venia. Kwalana Tamara na vovetaina pia aliruputali-venia talimara etavurana. ");
INSERT INTO khz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Palagu ia Palagu Palaguna, pia aliruputali-venia talimara na palagu ai e taunataunai pia aliruputali-venia.” ");
INSERT INTO khz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Vogare na evaikilaato, netiwato, “Au ripaku, Mesia, gekilagiana Keriso negetina, pene vogomai. Ia pene vogomai tomanai, ia na gaura maparara pene kilagi-matagaira.” ");
INSERT INTO khz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Na Iesu na evega-geleato, netiwato, “Talimana au ea, goi avaikilamuna.” ");
INSERT INTO khz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iesu vovetaina ekilawai aonai, gena melo gekwarato. Ira maparara nugara gepale-vagito, kwalana Iesu gare ta goti gekilakilawai, na talima ta ati ekilato, “Goi rakagau oririwana?” Pa “Rakagau gaurai goi egare goti gokilakilana?” ");
INSERT INTO khz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ne vogare gena nanu kwagutuna eraka-kwaniato, ewaikuleto vanugai, ne vanuga talimara evevaikilarato. ");
INSERT INTO khz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Netiwato, “Iovogomai, talima ta iomai-gitaa. Ia na au geku kala akalarato gaura maparara pekilagikilagi-atira. Peiramu ia e Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna), pa?” ");
INSERT INTO khz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Gaurai taunilimalima na vanuga geraokwaniato, Iesu genai geagoto. ");
INSERT INTO khz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Vovepaka kianai gena melo na gevaikilaato, negetiwato, “Vevega-ripa talimamu, ono ganigani.” ");
INSERT INTO khz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Na ia evega-geleto, netiwato, “Au magaku ganigani, gomi ati ripami ganiganina.” ");
INSERT INTO khz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Vovetaina gaurai gena melo matotaura geverenagito, negetiwato, “Talima taa na gana ganigani pevuamai pa?” ");
INSERT INTO khz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iesu na evaikilarato, netiwato, “Au gaku ganigani etugukuto Palaguna gena ririwa pana kalaa, e evenikuto inaguluna pana vega-gugulua. ");
INSERT INTO khz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gomi magemi vegavutina kilana, gokilana, ‘Uve vativati mulinai vou keto-toga tomana pene kwara.’ Na au na avaikilamina, matami iokala-pakara, ne araga ganiganira iogita-kalakalara, ganira warau pege tola, ginaroginaro tomana pekwara. ");
INSERT INTO khz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ginaroginaro talimana gena inagulu voina pene gapia, e araga ganiganina pene tao-koua, maguli vanagivanagi ulanana. Ganina voa, varovaro talimana e kuakua talimana pia verere-kou. ");
INSERT INTO khz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kwalana vovetaina pene vetao vou, evetaina gekilagiana kilana taunatauna, ‘Talima taa na evaroana, taa na ekuaana.’ ");
INSERT INTO khz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Au na gomi atugumito, ati govaro-vekwalavito gaura kuakuara. Varovaro vekwalavira talima reketa gevekwalavito, na gomi ira geria vekwalavi gaura kuakuarai pio laka-toga.” ");
INSERT INTO khz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ne Samaria talimara vogo vovanuga aonai Iesu gevega-taunataunaato, kwalana vogare gena vali pia kilana genana gaurai, ia ekilato, “Au geku kala rakavara akalarato gaura maparara pekilagikilagi-atira.” ");
INSERT INTO khz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Vovetaina gaurai Samaria talimara Iesu genai, gevogomaito genogiato, ira ria pia talu. Gaura pakurai Iesu vovanugai toma ruala maegapirato. ");
INSERT INTO khz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Taunilimalima vogo na Iesu gevega-taunataunaato, kwalana gena valipia kilara na. ");
INSERT INTO khz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ne ira na vogare gevaikilaato, negetiwato, “Ai na ewagumona Iesu gavega-taunataunaana, ati goi gemu kila vetainai, na ai matotaumai ia paga kamonagia, e pagama ripa-namanama, ia taunatauna Keriso, tanopara Vega-magulina Talimana.” ");
INSERT INTO khz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iesu vonai toma ruala etaluto mulinai, Galileiai eagoto. ");
INSERT INTO khz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu matotauna evekilagi-matagaito, netiwato, “Peroveta talimana gena vanuga taunatauna talimara na ati pia nugagi-ragea.” ");
INSERT INTO khz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ne Galileiai evekwarato aonai, Galileia talimara na gegapi-rageato. Iesu gegapi-rageato kwalana Ierusalemai Pasova velekwana aonai ira maki vonai, pe Iesu na rakagau ekalarato gaura maparara, matara na gegitarato. ");
INSERT INTO khz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ne Iesu maewaikuleto Galileia vanugana taai arana Kana. Kana Iesu na nanu wain ai evega-agoato vanugana. Vonai king gena vele ta Kaperanaumai etaluwai, ia natuna melona eviti-rakavaato. ");
INSERT INTO khz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Vovele ekamonagito, Iesu Iudea na eagoto Galileiai, gaurai eagoto ia genai, ne enogiato, Kaperanaumai ene verigo, pe ia natuna melona eneve vega-magulia, kwalana ia natuna melona roli ekwaregawai. ");
INSERT INTO khz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu na evaikilaato, netiwato, “Gomi vegailia irau vagira e vevega-kali kalara ati pio gitara, ati pio vega-taunataunaku.” ");
INSERT INTO khz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Vovele ekilato, “Velekou, ita ago, natuku neekwaregana nea.” ");
INSERT INTO khz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu na evaikilaato, netiwato, “Ono ago, natumu melona pene maguli gaurai.” Votalima na Iesu gena kila evega-taunataunaato, gaurai eagoto. ");
INSERT INTO khz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Raupara na ewaikule-waito aonai, gena vetugunagi talimara ria geverawalito, ne gevaikilaato, negetiwato, “Goi natumu melona pemaguli.” ");
INSERT INTO khz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ne ia na erenagirato, arigi orai natuna melona enamato. Ira gevega-geleto, negetiwato, “Walagani oragauna 1 koloko vetaina ia vovotina peraokwania.” ");
INSERT INTO khz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ne tamana eripa-rorirorito, voora taunataunanai enamato, Iesu na ia evaikilaato, netiwato, “Goi natumu pemaguli.” Gaurai ia e gena numa talimara maparara Iesu gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Eevegailia irau vagina vega-rualana Iesu na ekalaato, Iudea na Galileiai eagoto mulinai. ");
INSERT INTO khz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ekala mulinai Iesu Ierusalemai everageto, kwalana Iuda talimara geria velekwa ta gekalaawai. ");
INSERT INTO khz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ierusalemai kovu ta vanagi kamuna arana Mamoe Vanagina laganai. Vokovu arana Heberu karonai Betesda, ia laganai agalagi numara imaima. ");
INSERT INTO khz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Toma mapararai viti talimara vovogo vonai gemaoko-tagowai, mata-kele, gage rakava, e tauniparara kwautarana gekwaregato talimara, nanu pene kuvilaa gealo-tagoawai. ");
INSERT INTO khz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kwalana aneru ta kupa na emarigowai, vonanu evega-kuvilaawai. Vonanu ekuvilaawai aonai, etulurai-kunewai talimana gena viti enamawai. ");
INSERT INTO khz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Vonai talima taa emaoko-tagowai, gena viti rigolora gagala toitoi taula vativati (38). ");
INSERT INTO khz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu na vonai maokotagonai egitaato, eripato, ia toma vogovagi eviti-agiato. Gaurai Iesu na erenagiato, netiwato, “Goi oririwana ono nama pa?” ");
INSERT INTO khz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Viti talimana na evega-geleato, netiwato, “Velekou, nanu ekuvilaana aonai, au kovu ai ati tau raka taoraiku talimana ta. Eanana matotauku kovu ago-veninai ta etulurai-kunena.” ");
INSERT INTO khz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iesu na evaikilaato, netiwato, “Ono kuliiti, gemu gepa ono gapi-itia, ono laka.” ");
INSERT INTO khz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ne votalima gena viti veganamo enamato, gena gepa egapi-itiato, ne erugaitito, elakato. Vokala Tapati tomanai ewalato. ");
INSERT INTO khz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Gaura pakurai Iuda talimara na viti na enamato talimana gevaikilaato, negetiwato, “Toma Tapati, gemu gepa ragai ono vua-louloua, rova.” ");
INSERT INTO khz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ia na evega-gelerato, netiwato, “Au pevega-namaku talimana na pevaikilaku, nepetiwa ‘Gemu gepa ono gapi-itia, ono laka,’ nepetiwa.” ");
INSERT INTO khz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ne ira na gerenagiato, negetiwato, “Voo rai talimana pevaikilamu, ‘Gemu gepa ono gapi-itia, ono laka,’ nepetiwa?” ");
INSERT INTO khz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Na Iesu na evega-namaato talimana ati ripana, rai na evega-namaato, kwalana Iesu elaka-gerevagito, talima gutuma vonai aora na. ");
INSERT INTO khz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kapinai vou Iesu na votalima Rupu Veaga aonai erawaliato, ne evaikilaato, netiwato, “Ono kamonagi, ewagumona goi ponama. Kala rakavana ta ragai mapono kala-waia, rakava kamu iwavagina taa na neerawalimuna nea.” ");
INSERT INTO khz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ne votalima elakato, eagoto, Iuda talimara evega-riparato, ia Iesu na evega-namaato. ");
INSERT INTO khz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Vovetaina gaurai Iuda talimara na Iesu gevega-rakavaawai, kwalana Tapati tomanai vevega-maguli kalana ekalaato gaurai. ");
INSERT INTO khz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ne Iesu na evega-gelerato, netiwato, “Au Tamaku vanagivanagi einaguluna gaurai, au maki ainaguluna.” ");
INSERT INTO khz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Vovetaina ekilato gaurai, Iuda talimara geria ririwa raupara ta pia rawalia vegata, pe Iesu pia vagi-kwaregaa negetiwato. Ati voTapati ati ekwalanaato gaurai, na ekilato, Palagu ia Tamana netiwato. Kwalana vokilai ia Palagu goti gelegele netiwato. ");
INSERT INTO khz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Gaurai Iesu na evega-gelerato, netiwato, “Taunatauna, au na avaikila-taunataunamina, Natuna geregana na gau ta ati pene kalaa, na Tamana gena kala pene gitara kalaramo ia na pene kalara. Tamana rakagau ekalana gaura mapararara Natuna na maki pene kalara. ");
INSERT INTO khz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kwalana Tamana na Natuna eulamagiana, e ia na ekalarana gaura maparara maki evega-gitaana. Pa, gau kamu iwavagira maki genai pene vega-matagaira, egaura maki pene vanagira, gomi nugami pia pale-vagi ulanana. ");
INSERT INTO khz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Vega-gelegelena Tamana na kwarega talimara evega-kuliiti-wairana, ne maguli evenirana vetaina, Natuna na maki gena ririwa talimara maguli evenirana. ");
INSERT INTO khz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tamana na talima ta ati eagiroriana, kwalana veagirori tiavuna maparana Natuna eveniato. ");
INSERT INTO khz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Voia ganina, taunilimalima maparara na Natuna pia nugagi-ragea, Tamana genugagi-rageana vetaina. Natuna ati enugagi-rageana talimana na Tamana maki ati enugagi-rageana, kwalana Tamana na Natuna etuguato. ");
INSERT INTO khz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Taunatauna au na avaikilamina, au geku kila ekamonagiana e etugukuto Palaguna evega-taunataunaana talimana na maguli vanagivanagi warau pegapia. Ia Palagu gena Kota aonai ati pene laka-toga. Aikina. Kwarega warau peraokwania, maguli aonai pelaka-toga. ");
INSERT INTO khz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Taunatauna avaikilamina, tomana roe nea pene vogomai, warau pekwara, kwarega talimara na Palagu Natuna karona pia kamonagia, e pia kamonagia talimara pia maguli. ");
INSERT INTO khz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kwalana Tamana matotauna genai maguli emiana gelegelenai, Natuna maki vovetaina eveniato, maguli genai emiana. ");
INSERT INTO khz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","E ia Natuna rorirori eveniato, pene veagirori ulanana, kwalana ia Taunilimalima Natuna. ");
INSERT INTO khz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nugami ragai pia palevagi! Tomana evogomaina, kwarega talimara maparara roe nea kala aora na Palagu Natuna karona pia kamonagia. ");
INSERT INTO khz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ne piama laka-piati: Kala nama talimara pia kuliiti, maguli pia vaia gaurai kala rakava talimara pia kuliiti, rakava voina metauna pia gapia ulanana.” ");
INSERT INTO khz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Au geregaku na gau ta ati pana kalaa ripa. Aveagirorina maki Palagu na evaikilakuna akamonagirana gelegelerai akalarana, gaura pakurai geku veagirori rakagoto, kwalana ati au matotauku geku ririwa ta akwalanaana, na au etugukuto Palaguna gena ririwamo akalaana. ");
INSERT INTO khz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Pere au matokaukumo para vekilagi-matagai genai, au geku kila ati tau vega-taunataunana. ");
INSERT INTO khz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Na talima taa na maki au evega-taunataunakuna, e au ripaku, ia na au ekilagi-matagaikuna kilana taunatauna. ");
INSERT INTO khz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Gomi na talima reketa gotugu-agorato Ioane genai, ne ia na kila taunatauna ekilagiato. ");
INSERT INTO khz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Au vega-taunataunaku kilara ati taunilimalima geriana evogomaina, a Ioane pakilagia kwalana, gomi maguli pio vaia pakurai. ");
INSERT INTO khz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ioane noowane lamepa vetaina egalawai e emolewai, ne gomi vovekarawa kianai gemi ririwa, ia gena maekai tipo pio verere nogotiiwai. ");
INSERT INTO khz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Na au gevega-taunataunakuna kalarana, Ioane na evega-taunataunakuna kilara, voira gevanagirana. Kwalana au Tamaku na evenikuto inaguluna ewagumona akalaana, eiana au evega-taunataunakuna, au Tamaku na etugukuto. ");
INSERT INTO khz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Au Tamaku na etugukuto, e ia matotauna na au maki ekilagi-matagaikuto. Gomi na ia karona rogoti goro kamonagia, e kolemana maki rogoti goro gitaa. ");
INSERT INTO khz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","E gena kila gomi aomi ai ati emiana, kwalana ia na etuguato talimana ati govega-taunataunaana. ");
INSERT INTO khz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gomi na Puka Veaga kilara gotavu-inamainamarana, kwalana gomi gotugamagina, vokila aorai maguli vanagivanagi pio rawalia. Vokilana au gekilagikuna. ");
INSERT INTO khz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Na gomi maguli vaivaina veaolenai au geku ai vogomai ati goririwana. ");
INSERT INTO khz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Au taunilimalima geriana vevega-rage ati atavuana. ");
INSERT INTO khz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na gomi rakavetaina, au ripaku. Au ripaku gomi aomi ai pa nugami garakaurai Palagu ulamagina ati emiana. ");
INSERT INTO khz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Au avogomaito Tamaku aranai, ati gogapi-ragekuna. Na talima poluna ta pene vogomai matotauna aranai genai, pio gapi-ragea. ");
INSERT INTO khz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Gomi matotaumimo aomi ai govevega-ragena ne gogapi-ragerana. Na vovevega-rage Palagu geregana namo pene kalaa. Palagu genana evogomaina vovevega-rage, gomi na ati goririwaana pio gapia. Pene gomi nevetaina matotaumi aomi ai govevega-ragena genai, au raka pio vega-taunatauna-tiwaku? ");
INSERT INTO khz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ragai pio tugamagi, au na Tamaku wailanai pana rolimi, aikina. Veroli talimana gogapi-rageana talimana, Mose, ia na gomi pene rolimi. ");
INSERT INTO khz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pere gomi Mose pogoro vega-taunataunaa genai, au maki pogoro vega-taunataunaku, kwalana ia na au kolemaku etaloato. ");
INSERT INTO khz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na pene ia na etaloato kilana ati pio vega-taunataunaa genai, au geku kila raka pio vega-taunatauna-tiwaa?” ");
INSERT INTO khz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Voia mulinai Iesu Galileia kovuna na evanagito kavatai. Vokovu arana ta Tiberia. ");
INSERT INTO khz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ne taunilimalima vogo vagi ia mulina na geagoto, kwalana vegailia irau vagira ekalato viti talimara geriai gegitarato gaurai. ");
INSERT INTO khz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Voia mulinai Iesu golo ai everageto, ne vonai gena melo ria getanu-talito. ");
INSERT INTO khz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iuda talimara geria Pasova velekwana ekavinagiwai wailai. ");
INSERT INTO khz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu epoe-itito, taunilimalima galagala vagi ia genai gevogomaiwai, gaurai ia na Filipo evaikilaato, netiwato, “Ita ganigani ariginai toma tavoina etaunilimalima maparara gupu-agira?” ");
INSERT INTO khz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Iesu vovetaina ekilato, kwalana Filipo aona pene ripaa ulanana. A ia ripana rakagau pene kala. ");
INSERT INTO khz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo na evega-geleato, netiwato, “Siliva monira tinavu ruala (200) na ganigani gaura pita voira, na ati pia gelegele, e kiarakiara maki maparara ati vagi pene gavura.” (Siliva moni tinavu ruala (200) talima ta voina uve taula vativati (8) aonai pene gapi vetaina.) ");
INSERT INTO khz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Gena melo ta arana Anduru, Simona Petero tarina, ia na evega-geleato, netiwato, ");
INSERT INTO khz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Melo girigiri ta ea, ia gana pereti imaima, e magani ruala. Na ati pia gelegele etaunilimalima maparara geriai.” ");
INSERT INTO khz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu na evaikilarato, netiwato, “Taunilimalima ia vaikilara, ia tanutanu-tali.” Vokapu magawana. Ne taunilimalima maparara getanutanu-talito. Marumaru geregariamo ragana imaima (5,000) vetaina. ");
INSERT INTO khz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ne Iesu na vopereti egapirato, Palagu evega-namaato, ne getanu-talito talimara maparara geveni-veagavurato. Magani maki vovetaina ekalarato, maparara gegapito geria ririwa gelegelerai. ");
INSERT INTO khz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ira maparara gegani-mateto, ne Iesu na gena melo evaikilarato, netiwato, “Pereti kovara maparara iokoko-koukoura geriana, kiata vagi maki ragai pene lekwalekwa.” ");
INSERT INTO khz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ne vopereti geganirato kovara maparara gekoko-koukourato, papalu maparara gagalana ruala gevega-vonurato. ");
INSERT INTO khz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Taunilimalima na Iesu na evegailia irau vagina ekalaato gegitaato aonai, gekilato, “Taunatauna, e peroveta talimana tanoparai pene vogomai negetiwato talimana.” ");
INSERT INTO khz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu eripato, taunillimalima pia vogomai, ia piama gapia geria king ai pia vega-agoa gaurai. Vovetaina gaurai golo ai maewaikuleto. ");
INSERT INTO khz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Elaviawai aonai, Iesu gena melo kovu ai geverigoto. ");
INSERT INTO khz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Vonai gati gautai gerageto, ne kovuna gevanagito, Kaperanaumai geagoto. Voo warauna epogiato, na Iesu rogoti ere kwara ira geriai. ");
INSERT INTO khz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aonai agi kamu vagi egavuwai, gaurai vokovu akuna maki gekamuto. ");
INSERT INTO khz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iesu gena melo kilomita imaima pa taula toitoi vetaina gati gepako-agiato aonai, ira na Iesu gegitaato, nanu atana na elaka-maiwai, gati evogomai-veniawai, gaurana ira gekalito. ");
INSERT INTO khz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iesu na evaikilarato, netiwato, “Ragai iokali, e au.” ");
INSERT INTO khz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ne ia gegapi-rageato, gati ai, atilovana geago-veniawai kapunai gekwarato. ");
INSERT INTO khz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Elaganiato, taunilimalima vogo Iesu gena melo gati ai geragekauto kapunai geruga-tagowai. Ira geripato, tovotovonai vonai gati kwapunamo vokovu taitarinai. E maki riparia, Iesu gena melo ria vogati ai ati gerageto, gena melo geregariamo gerageto ne gevanagito. ");
INSERT INTO khz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Gati reketa Tiberia na gevogomaito, kovu taitarinai gema toga-rageto. Ira getoga-rageto kapuna, Velekou na pereti Palagu evega-namaato mulinai, taunilimalima evenirato, geganirato kapuna laganai. ");
INSERT INTO khz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Votaunilimalima geripa-rorirorito, Iesu gena melo ria vonai aikina, gaurai vogati ai geragekauto, Kaperanaumai gevanagito, Iesu geve tavuato. ");
INSERT INTO khz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Taunilimalima na Iesu kovu kavata taitarinai gerawaliato, ne gevaikilaato, negetiwato, “Vevega-ripa talimamu, goi arigi toma enai poma kwara?” ");
INSERT INTO khz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu na evega-gelerato, netiwato, “Au na avaikila-taunataunamina, gomi na au gotavukuna kwalana vopereti goganirato, ne gogani-mateto, e ati vovegailia irau vagira gogitarato gaurai, gotavukuna. ");
INSERT INTO khz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mapia rakava ganiganira inagulura ragai pio kala, na ganigani roe wapia mia-vanagivanagi pene ago, maguli vanagivanagi, inaguluna pio kalaa. Voganigani Taunilimalima Natuna na pene venimi, kwalana Tamana Palagu na ia genai vegailia ta ekalaato, ia evega-taunataunaato vegailiana.” ");
INSERT INTO khz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ne gerenagiato, negetiwato, “Ai Palagu gena ririwa inagulura aia kala napaiatiwa genai rakagau paia kala?” ");
INSERT INTO khz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu na evega-gelerato, netiwato, “Palagu gena inagulu gomi na pio kalaa netina inaguluna eiamo: Etuguato talimana pio vega-taunataunaa.” ");
INSERT INTO khz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ira na gerenagiato, negetiwato, “Goi na ai gema raka vegailia irau vagina pono kalaa paia gitaa, ne goi paia vega-taunataunamu? Goi na rakagau pono kalaa? ");
INSERT INTO khz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ai tenemai na mana geganiato tanoleanai, Puka Veaga aonai ekilagiana vetaina, evetaina ekilana, ‘Ia na pereti kupa na eveni-rigorato geganito.’” ");
INSERT INTO khz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu na evega-gelerato, netiwato, “Taunatauna vagi avaikilamina, ati Mose na vopereti kupa na evenimito. Aikina. Au Tamaku na pereti taunatauna kupa na evenimina. ");
INSERT INTO khz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kwalana Palagu gena pereti kupana emarigoto talimana. Ia na tanoparai getaluna talimara maguli evenirana.” ");
INSERT INTO khz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ne ira na gevaikilaato, negetiwato, “Velekou, nepereti toma mapararai pono venimai.” ");
INSERT INTO khz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iesu na evaikilarato, netiwato, “Maguli peretina au ea. Au geku ai pene vogomai talimana ati pene vitoa, e au pene vega-taunataunaku talimana, nanuna ati pene kalaa. ");
INSERT INTO khz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na au na gomi warau avaikilamito, gogitakuna, na ati govega-taunataunakuna. ");
INSERT INTO khz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tamaku na au evenikuto talimara maparara, au geku ai pia vogomai, e raira au geku ai pia vogomai talimara, au na ati pana gui-waira. ");
INSERT INTO khz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kwalana au kupa na amarigoto, ati au geku ririwa pana kalaa ulanana, na au etugukuto Palaguna gena ririwa pana kalaa ulanana. ");
INSERT INTO khz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","E au etugukuto Palaguna gena ririwa, au evenikuto talimara maparara ta ati pana kala-lekwalekwaa, a maparara kwaregana pana vega-kuliiti-waira toma ikanai. ");
INSERT INTO khz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kwalana au Tamaku gena ririwa, Natuna pia gitaa e pia vega-taunataunaa talimara maparara na maguli vanagivanagi pia vaia, e toma ikanai pana vega-kuliiti-waira.” ");
INSERT INTO khz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na Iuda talimara gemunemuneto, kwalana ia ekilato, “Au kupa na amarigoto peretina.” ");
INSERT INTO khz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Gaurai gekilato, “Etalima e Iesu, Iosepa natuna, ei? Ia tamana e tinana ita ripara. Raka rauparai ia ekilana, ‘Au kupa na amarigoto’?” ");
INSERT INTO khz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu na evega-gelerato, netiwato, “Gomi matotaumi aomi ai munemune iovega-aikia. ");
INSERT INTO khz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Au geku ai ta ati pene vogomai kawa, na Tamaku, au etugukuto Palaguna, ia na rai au geku ai pene vaimaia talimanamo. E au geku ai pene vogomai talimana, au na toma ikanai kwaregana pana vega-kuliiti-waia. ");
INSERT INTO khz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Peroveta talimara na evetaina getaloato, ‘Ira maparara Palagu na pene vega-ripara.’ Tamaku gekamonagi-veniana e genana ripa gegapina talimara maparara, au geku ai pia vogomai. ");
INSERT INTO khz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Au ati akilana, talima taa na Tamaku egitaato natina, na Palagu genana evogomaito talimana geregana namo Tamaku egitaato. ");
INSERT INTO khz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Avaikila-taunataunamina, au evega-taunataunakuna talimana na maguli vanagivanagi pene vaia. ");
INSERT INTO khz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Maguli peretina au ea. ");
INSERT INTO khz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gomi tenemi na tanoleanai mana geganiawai, na gekwaregato. ");
INSERT INTO khz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Na kupa na emarigona peretina ea, ia pene gania talimana ati pene kwarega. ");
INSERT INTO khz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Au maguli peretina kupa na emarigoto. Talima taa na epereti pene gania, ia pene maguli-vanagivanagi. E pereti au na pana venia au virigoku. Au virigoku pana veni-piatogaa kwalana, tanoparai getaluna talimara na maguli pia vaia ulanana.” ");
INSERT INTO khz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Eiana Iuda talimara matotaura aorai veitu kamu iwavagina ewalato, ira gekilato, “Etalima na arigi rauparai ia virigona pene venira pita gania?” ");
INSERT INTO khz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu na evaikilarato, netiwato, “Avaikila-taunataunamina, pene gomi na Taunilimalima Natuna virigona ati pio gania e ralana ati pio niua genai, gomi aomi ai maguli ati pene mia. ");
INSERT INTO khz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Rai na au virigoku pene gania e ralaku pene niua talimana, maguli vanagivanagi pene vaia, e au na toma ikanai kwaregana pana vega-kuliiti-waia. ");
INSERT INTO khz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kwalana au virigoku ganigani taunataunana, e au ralaku maki niuniu gauna taunataunana. ");
INSERT INTO khz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Rai au virigoku pene gania e ralaku pene niua talimana, au aoku ai pene talu, e au maki ia aonai pana talu. ");
INSERT INTO khz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tamaku ia maguli kwalana ia na etugukuto e au ia pakunai amagulina. Voia gelegelenai au virigoku pene gania talimana maki pene maguli, kwalana au amagulina. ");
INSERT INTO khz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Au kupa na emarigoto peretina au ea. Gomi tenemi mana geganito na gekwaregato. Na epereti pene gania talimana pene maguli vanagivanagi.” ");
INSERT INTO khz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesu na ekila Iuda talimara rupu ai evaikilagirato, Kaperanaumai evevega-ripawai aonai. ");
INSERT INTO khz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iesu gena melo gutuma na ekila gekamonagiato, negetiwato, “E vevega-ripa kilana gaoka vagi, rai na pene gapi-ragea.” ");
INSERT INTO khz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu ripana gena melona vokila gemunemune-agiawai, gaurai evaikilarato, netiwato, “Ekila na pevega-vekwakunagimi? ");
INSERT INTO khz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pene gomi Taunilimalima Natuna pio gitaa, pene veragewai, etalu-agiato kapunai rakavetaina? ");
INSERT INTO khz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Palagu Palaguna na maguli evenirana; tauniparana ati pene veakavara. Au na avaikilamina kilara Palagu, e ira aorai maguli emiana. ");
INSERT INTO khz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Na gomi reketa na ati govega-taunataunakuna.” Iesu ripana tovotovona na vegata, rai taa na ati evega-taunataunaawai e maki rai na ia pene lewaa. ");
INSERT INTO khz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Maekilato, “Vovetaina gaurai au na avaikilamito, ta au geku ai ati pene vogomai-kawa, na Tamaku na pene vega-taunataunaa talimana vou pene vogomai.” ");
INSERT INTO khz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Vokila gekamonagiato, voanana Iesu gena melo vogo ia genana gelaka-gerevagito, e ia ria ati magelaka-kouwai. ");
INSERT INTO khz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ne Iesu na gena melo gagalana ruala erenagirato, netiwato, “Gomi maki goririwana pio laka-gerevagi pa?” ");
INSERT INTO khz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simona Petero na evega-geleato, netiwato, “Velekou, ai rai genai mapaia ago? Maguli vanagivanagi kilara goi gemu ai. ");
INSERT INTO khz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ai na gavega-taunataunamuna e garipa-rorirorina, goi Palagu gena Veaga Talimana.” ");
INSERT INTO khz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iesu evega-geleto, netiwato, “Au na gomi gagalana ruala avirigimito ei? Na gomi ta ne tiapolo.” ");
INSERT INTO khz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ia na Iudas, Simona Isakariota natuna, ekilagiato. Iuda maki vomelo gagalana ruala aorai melona taa, na ia na Iesu roe nea vou pene lewaa. ");
INSERT INTO khz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Voia mulinai Iesu Galileiai elakavowai. Ia ati eririwato, Iudeai pene ago, kwalana Iuda talimara vonai geria ririwa, ia pia vagia. ");
INSERT INTO khz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iuda talimara geria Palai-ama Velekwana tomana ekavinagito. (EPalai-ama Velekwana gekalaawai genai, palai-ama gekalarawai, ne aorai getaluwai, kwalana tenera tanoleanai palai-ama aorai getaluwai, voia pia tugamagi-tagoa ulanana.) ");
INSERT INTO khz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ne Iesu tarina melora na gevaikilaato, negetiwato, “Ekapu ono raokwania, Iudeai pono ago, pe okalarana kalara gemu melo na pia gitara. ");
INSERT INTO khz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kwalana rai matotauna pene vevega-matagai netina talimana, pia ripaa ulanana, gau kwauta ati pene kala veavugaa. Goi ekala okalarana, pe tanopara mapararai ono vevega-matagai!” ");
INSERT INTO khz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kwalana Iesu tarina maparara na maki ia ati gevega-taunataunaawai. ");
INSERT INTO khz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Gaura pakurai Iesu na evaikilarato, netiwato, “Au geku toma rogotina ere kwara. A gomi gemi ai toma maparara gelegeleramo. ");
INSERT INTO khz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tanopara na gomi ati eparu-venimina, na au eparu-venikuna, kwalana au kala rakavara ekalarana gaura akilagi-matagairana. ");
INSERT INTO khz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gomi pio ago vovelekwai. Na au ati pana ago, kwalana au geku toma taunatauna rogotina ere kwara.” ");
INSERT INTO khz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iesu vovetaina ekilato, gaurai Galileiai etaluto. ");
INSERT INTO khz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iesu tarina melora geagoto vovelekwai, mulirana Iesu maki maeagoto. Na ati elaka-matagaito, veavugai eagoto. ");
INSERT INTO khz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Vovelekwa kapunai Iuda talimara na getavuawai, geverenagi-agiawai, negetiiwai, “Ia ariginai?” ");
INSERT INTO khz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Vogutuma para aonai Iesu warigi gekilagi-garigari-gitaawai. Talima reketa gekilawai, “Ia talima namana” negetiwato. Reketa gekilawai, “Aikina, ia na taunilimalima reketa evailearana.” ");
INSERT INTO khz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Na talima taa na ati ekilagi-matagaiato, kwalana ira maparara Iuda velera kalira na gekaliwai. ");
INSERT INTO khz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Velekwa tomara reketa geaikito, reketa roe voa aonai, Iesu Rupu Veaga aonai elaka-togato, ne evevega-ripato. ");
INSERT INTO khz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ne Iuda talimara gevevega-kali-rakavato, negetiwato, “Etalima vevega-ripa kilara raka eripa-tiwato, ia vevega-ripa kapuna taai ati elakato.” ");
INSERT INTO khz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu evega-geleto, netiwato, “Au na rakagau avevega-ripagirana gaura ati au geku vevega-ripa, na au etugukuto Palaguna genana gevogomaina. ");
INSERT INTO khz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pene talima ta eririwana Palagu gena ririwa pene kalara netina talimana, au geku vevega-ripa kilara pene ripara. Pene ripa, au geku vevega-ripa kilara Palagu genana gevogomaina, pa au matotauku gekuna. ");
INSERT INTO khz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Rai talima gena ririwa kilara ekilagina, matotauna arana vega-ragena rauparana ekaalana. Na au etugukuto Palaguna vega-ragena rauparana ekalaana talimana genai, kila taunatauna emiana, ia genai opakau ta ati emiana. ");
INSERT INTO khz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mose na gomi rova evenimito, ei? Na gomi taa na vorova ati gokwalanarana. E rakagau gaurai au iovagiku nogotina?” ");
INSERT INTO khz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Votaunilimalima gutuma gevega-geleto, negetiwato, “Goi palagu rakavana taa na eporogimuto. Rai na ene vagimu notina?” ");
INSERT INTO khz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu na evega-gelerato netiwato, “Au na enai Ierusalemai kala irau vagina ta akalaato aonai, gomi maparaparami nugami gepale-vagito. ");
INSERT INTO khz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose na melo tauniparara kopira lamavagira kalana evenimito, gaura pakurai gomi na melo keira Tapati ai maki kopira golama-vagirana. Vokopi lamavagi kalana ati Mose na etinaato, na gomi tenemi na getinaato. ");
INSERT INTO khz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pene melo tauniparara kopira Tapati tomanai golama-vagirana Mose gena rova ragai pio kala-makoraa genai, rakagau gaurai au goparu-venikuna, Tapati tomanai talima ta pana vega-nama gugulua? ");
INSERT INTO khz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gomi na gau maparara mulira gitagitarai ragai pio agirorira, na gau maparara rorirori ai pio agirorira.” ");
INSERT INTO khz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ne Ierusalema talimara reketa, gekilato, “Pia vagia negetina talimana ea. ");
INSERT INTO khz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Iogitaa, ia magugulagina ekilakilana, taa na ati evaikila-wainagiana. Pa peiramu kaonsela talimara pege ripa, Keriso taunataunana ea. ");
INSERT INTO khz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Na Keriso, (Palagu na ekilagi-maavuato vevega-maguli tauna), pene vogomai aonai, ta ati pene ripa ia ravanana pene vogomai. Na etalima ravanana evogomaito ita maparara ripara.” ");
INSERT INTO khz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu Rupu Veaga aonai roe waevevega-ripawai aonai, ekila-kamukamuto, netiwato, “Taunatauna, gomi ripami au rai e ravanana avogomaito. Na au ati matotauku geku ririwaimo avogomaito. Au etugukuto Palaguna taunatauna. Gomi ati ripami ia. ");
INSERT INTO khz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na au ia ripaku, kwalana au ia genana avogomaito e ia na etugukuto.” ");
INSERT INTO khz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ne ia gapi-talia negetiwato, na talima ta gimana ia genai ati enapa-kauato, kwalana gena toma taunatauna rogoti ere kwara gaurai. ");
INSERT INTO khz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na taunilimalima vogovagi egutuma aonai ia gevega-taunataunaato, negetiwato, “Keriso pene vogomai aonai, vegailia irau vagira kalara kalakalarai etalima pene vanagia pa?” ");
INSERT INTO khz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisea talimara gekamonagito, taunilimalima gutuma na vokila Iesu genai gekilagi-garigariawai. Voia galamanai Parisea talimara e Rupu Veaga velera kamura na Rupu Veaga gitatagona talimara reketa, getugurato, Iesu pia gapia ulanana. ");
INSERT INTO khz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu ekilato, “Au gomi ria ati rau kiana pita talu, voia mulinai pana laka-gerevagi etugukuto Palaguna genai pana ago. ");
INSERT INTO khz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gomi na pio tavuku, na ati pio rawaliku, e au pana talu kapunai, gomi ati pio ago ripa.” ");
INSERT INTO khz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ne Iuda talimara matotaura geverenagito, negetiwato, “Ia ravanai pene ago, pe ita na ati pita rawalia netina? Peiramu ia pene ago Grik talimara geria tanoparai, Iuda talimara gutuma maki ira aorai getaluna gaurai, vonai Grik talimara pene vega-ripara. ");
INSERT INTO khz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","E raka kila ia na ekilagiana, netina, ‘Pio tavuku na ati pio rawaliku,’ e, ‘Au pana talu kapunai gomi ati pio ago ripa’?” ");
INSERT INTO khz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Velekwa ikana tomana, voo toma kamu iwavagina, Iesu erugaitito, ne ekila-inalato, netiwato, “Rai nanu na ekalaana, au geku ai pene vogomai, nanu penema niu. ");
INSERT INTO khz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Puka Veaga aonai ekilana gelegelenai, netina, ‘Au pene vega-taunataunaku talimana aonana maguli nanuna pene galu-atia.’” ");
INSERT INTO khz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesu na Palagu Palaguna vovetaina ekilagiawai, raira na Iesu gevega-taunataunaana talimara na vou pia vaia. Votomai Veaga Palaguna Palagu na rogoti ere venira, kwalana Iesu na Palagu gena maeka ralema iwavagina maki rogoti ere gapia gaurai. ");
INSERT INTO khz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Talima reketa vogutuma aorai vokila gekamonagiato, ne gekilato, “Taunatauna, ita na peroveta talimana taaloana talimana ea.” ");
INSERT INTO khz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Talima reketa gekilato, “E Keriso.” Na reketa gekilato, “Aikina, Keriso Galileia na ati pene vogomai. ");
INSERT INTO khz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Puka Veaga aonai ekilana, Keriso Davida petena na pene vogomai, e Betelehemai, Davida etaluwai vanuganai, pene wala.” ");
INSERT INTO khz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Vovetaina gaurai talima matotaura aorai gevetao-kavalugato, kwalana Iesu galamanai. ");
INSERT INTO khz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Talima reketa geririwato pia gapia, na ta gimana ia genai ati enapa-kauato. ");
INSERT INTO khz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Rupu Veaga gitatagona talimara gewaikuleto, ne Rupu Veaga velera kamura e Parisea talimara na gerenagirato, negetiwato, “Rakagau gaurai ia ati pogo vaimaia?” ");
INSERT INTO khz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Rupu Veaga giatatagona talimara gevega-geleto, negetiwato, “Etalima ekilana vetaina talima ta rogotina ere kila.” ");
INSERT INTO khz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ne Parisea talimara gevaikilarato, negetiwato, “Pe, gomi maki ne ia na peopami? ");
INSERT INTO khz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Vekuneagi talimana ta pa Parisea talimana taa na ia evega-taunataunaana pa? Aikina! ");
INSERT INTO khz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A etaunilimalima na gevega-taunataunaana, ira Mose gena rova ati ripara talimara. Palagu na geria rakava voira pene venira.” ");
INSERT INTO khz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Parisea talimana ta vonai arana Nikodemo. Ia pogi ta eagoto Iesu evegitaato talimana. Ia na evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ita gera rova ekilana, talima ta gena kila gekamonagi-kuneana vou, voia mulinai gena rakava voina metauna pia venia.” ");
INSERT INTO khz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ira na gevega-geleato, negetiwato, “Goi maki Galileia talimamu pa? Puka Veaga aona pono tavua, voanana pono ripa, peroveta talimana ta Galileia na ati pene vogomai.”  ");
INSERT INTO khz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ne taunilimalima maparara geria numai geagoto. ");
INSERT INTO khz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Na Iesu Olive Golonai eagoto. ");
INSERT INTO khz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Elaganiato amoamo valiguna ia maewaikuleto Rupu Veaganai. Vonai taunilimalima maparara geagoto genai, getanu-gegelagiato, ne etanu-talito, evega-riparato. ");
INSERT INTO khz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ne rova gevevega-ripagirawai talimara e Parisea talimara na gare ta Iesu genai geago-agiato. Vogare eveopa-lemawai aonai gerawaliato, ne geago-agiato, Iesu ria getanu-tagowai talimara maparara wailarai gevevega-rugaato. ");
INSERT INTO khz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iesu gevaikilaato, negetiwato, “Vevega-ripa talimamu, egare eveopa-lemavona aonai pege rawalia. ");
INSERT INTO khz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mose gena rova ekilana, vovetaina pia kala garera, vatu na paia vale matera. Goi rakagau notina?” ");
INSERT INTO khz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Vovetaina gekilato, Iesu gekalatovoato, pia vega-verauleaa ulanana. Na Iesu erupu-talito, kwano ai ririna na etalotaloto. ");
INSERT INTO khz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ira na Iesu roe wagerenagiawai aonai, erugaitito, ne evaikilarato, netiwato, “Rai gomi aomi ai rogotina ere kala rakava genai, ia na vatu pene gapia, egare pene vale-kunea.” ");
INSERT INTO khz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ne Iesu maerupu-talito, kwano ai maetalotaloto. ");
INSERT INTO khz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ira na vokila gekamonagiato aonai, ira kwapurakwapura aorai geripato mageria kala rakava, gaurai kwapurakwapura gelakavagi-lakavagito; talima kamura gelaka-kuneto mulinai vou gulu valigu magelakato. Iesu gereganamo eruga-tagowai, vogare goti. ");
INSERT INTO khz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ia erugaitito aonai, talima ta ati egitaato, vogaremo, ne erenagiato, netiwato, “Goi pege vega-rakavamu talimara arigia? Taa na gemu rakava metauna voiana ati pevenimu?” ");
INSERT INTO khz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Vogare evega-geleto, netiwato, “Velekou, ta vagi maki aikina.” Gaurai Iesu ekilato, “Au na maki gemu rakava metauna voina ati pana venimu. Ono laka, na ragai mapono kala-rakava-wai.” ");
INSERT INTO khz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na Iesu taunilimalima evopata-venirato, netiwato, “Au tanopara maekana. Rai au muliku ai pene laka talimana, mukunai ati pene laka, na maguli maekana pene vaia.” ");
INSERT INTO khz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisea talimara na gevaikilaato, negtiwato, “Goi matotaumu ovevaravaragina; gaurai goi gemu varavara ati taunatauna.” ");
INSERT INTO khz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu evega-geleto, netiwato, “Aikina, au matotauku avekilagina, na au na rakagau akilagiana gauna taunatauna. Kwalana au ripaku ravanana avogomaito e ravanana mapana ago. A gomi ati ripami au ravanana avogomaito e ravanana mapana ago. ");
INSERT INTO khz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gomi taunilimalima geria veagirori rauparanai goveagirorina. Au na ta ati aagiroriana. ");
INSERT INTO khz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Na pene au pana veagirori genai, geku veagirori taunatauna. Kwalana au ati geregakumo aveagirorina, na Tamaku, au etugukuto Palaguna, au goti. ");
INSERT INTO khz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Gomi gemi rovai maki evetaina ekilana, talima ruala na kila kwapunamo gekilagiana genai voo taunatauna. ");
INSERT INTO khz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Au matotauku avekilagina; e Tamaku, etugukuto Palaguna, na au maki ekilagikuna.” ");
INSERT INTO khz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Gaurai ira na gerenagiato, negetiwato, “Goi tamamu ariginai?” Iesu evega-geleto, netiwato, “Gomi ati ripami au, e Tamaku maki ati ripami. Pere au pogoro ripaku, Tamaku maki pogoro ripaa.” ");
INSERT INTO khz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesu gena ekila Rupu Veaga aonai evevega-ripawai, moni geura-koukourawai mauana kapunai. Talima ta ati enapakauto genai, kwalana ia gena toma rogotina ere kwara. ");
INSERT INTO khz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu na evaikila-wairato, netiwato, “Au alaka-gerevagina. Gomi na pio tavuku, na gemi kala rakava aonai pio kwarega. Au pana ago kapunai, gomi ati pio ago ripa.” ");
INSERT INTO khz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Na Iuda talimara gekilato, “Ia pekila, ia pene ago kapunai ita ati pita ago. Voia ganina ia matotauna pene vevagi, pa?” ");
INSERT INTO khz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iesu evega-geleto, netiwato, “Gomi etanopara genana ekalamito, na au kukunana amarigoto. Gomi etanopara talimami, na au ati etanopara talimaku. ");
INSERT INTO khz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gaura pakurai au na gomi pavaikilami; gemi rakavai pio kwarega. Kwalana pene au, Keriso, ati pio vega-taunataunaku genai, gemi rakavai pio kwarega.” ");
INSERT INTO khz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Na ira na gerenagiato, negetiwato, “Goi rai?” Iesu na evega-gelerato, netiwato, “Tovotovonai vegata gemi akilagirawai vetaina. ");
INSERT INTO khz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kila vovogo para kilagira e para agirorimi, kwalana gemi kala vetainai. Na kwapunamo, au etugukuto Palaguna taunatauna, e ia genana akamonagito kilara tanoparai getaluna talimara avega-riparana.” ");
INSERT INTO khz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ira ati getugamagi-iluto Iesu na Tamana ekilagiawai. ");
INSERT INTO khz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Gaurai maevaikilarato, netiwato, “Gomi na Taunilimalima Natuna pio gapi-itia mulinai vou, pio ripa au Keriso. Ne pio ripa, au geregaku na gau ta geku ririwaimo ati akalaana, na Tamaku na au rakagau evega-ripakuna kilaramo, au na gomi avega-ripamina. ");
INSERT INTO khz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","E au etugukuto Palaguna au goti, au ati eraokwanikuna; kwalana au na vanagivanagi ia na everere-agirana kalaramo akalarana.” ");
INSERT INTO khz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Talima vogona na Iesu gevega-taunataunaato, ekila ekilagirawai gaurai. ");
INSERT INTO khz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ne Iesu na Iuda talimara, ia gevega-taunataunaato talimara, evaikilarato, netiwato, “Pere gomi na au geku vevega-ripa kilara pio kwalanara genai, gomi au geku melo taunatauna. ");
INSERT INTO khz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gaurai taunatauna pio ripaa, e votaunatauna na pene luga-vaginmi, gau kwauta na ati mapene ligoligomi.” ");
INSERT INTO khz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ira gevega-geleto, negetiwato, “Ai Aperaamo kalakalana e inagulu talimana ati voina talimanai ati gaagoto. E goi rakagau gaurai okilana, ‘Taunatauna na pene luga-vagimi’?” ");
INSERT INTO khz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu na evaikilarato, netiwato, “Avaikila-taunataunamina, rai rakava ekalaana, ia kala rakava gena inagulu talimana ati voina talimana. ");
INSERT INTO khz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Inagulu talimana ati voina talimana numai ati pene talu kikitali, na numa gatana natuna vou numai pene talu-vanagivanagi. ");
INSERT INTO khz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gaura pakunai pene Palagu Natuna na pene luga-vagini genai, gomi pio veluga-vagi vegata, gau kwauta na ati mapene ligoligomi. ");
INSERT INTO khz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Au ripaku gomi Aperaamo kalakalana, na gomi goririwana, au pio vagiku, kwalana gomi na geku vevega-ripa kilara, ati vagi gogapi-ragerana. ");
INSERT INTO khz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Au na rakagau Tamaku genai agitarato gaura gomi avaramina, a gomi tamami genana gokamonagito gaura gomi na gokalarana.” ");
INSERT INTO khz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ira na Iesu gevega-geleato, negetiwato, “Ai tamamai Aperaamo.” Iesu na evaga-gelerato, netiwato, “Pere gomi taunatauna Aperaamo natuna genai, ia na ekalarato kalara gomi na maki pogoro kalara. ");
INSERT INTO khz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Au Palagu genana akamonagirato kilara taunataunara maparara gomi avaramina, na gomi goririwana, au iovagiku nogotina. Aperaamo vovetaina ati ekalato. ");
INSERT INTO khz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gomi matotaumi tamami (Tiapolo), na rakagau ekalana kalana gokalaana.” Ira gevega-geleto, negetiwato, “Ai ati kuvia lema talimamai. Ai Tamamai Palagumo geregana.” ");
INSERT INTO khz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu na evaikilarato, netiwato, “Pene Palagu taunatauna gomi Tamami genai, au pogoro ulamagiku. Kwalana au Palagu lagana na avogomaito. Au geku ririwai ati avogomaito, na ia na etugukuto. ");
INSERT INTO khz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Rakagau gaurai au na rakagau akilagiana kilana ati gotugamagi-iluana? Kwalana au geku kila ati gelegele pio kamonagira. ");
INSERT INTO khz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gomi tamami Tiapolo gena taunilimalima, pe gomi goririwana tamami na eririwa-rakavarana kalara pio kalara. Tovotovona na vegata ia vevagi-repa talimana e kila taunatauna ati ekwalanaana, kwalana ia aonai kila taunatauna ta ati emiana. Ia eopana, voo ia gena maguli taunatauna. Kwalana ia opa talimana, opakau maparara tamara. ");
INSERT INTO khz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Na au na gomi kila taunatauna avaramina, aonai gomi na au ati govega-taunataunakuna. ");
INSERT INTO khz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na gomi taa na au geku ai kala rakava ta porawalia pa? A pene au na kila taunataunana akilagiana genai, rakagau gaurai au ati govega-taunataunakuna, ei? ");
INSERT INTO khz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Palagu natuna na Palagu gena kila pene kamonagia. A gomi ati Palagu natuna, gaura pakurai ati gokamonagina.” ");
INSERT INTO khz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ne Iuda talimara na Iesu gevaikilaato, negetiwato, “Ai taunatauna garorirorina. Goi Samaria talimamu e palagu rakavana na peporogimu.” ");
INSERT INTO khz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu evega-geleto, netiwato, “Au palagu rakavana na ati pegorogiku. Au Tamaku akupa-rageana, na gomi na au ati gokupa-ragekuna. ");
INSERT INTO khz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Au matotauku araku vega-ragena rauparana ati atavuana; na ia talima taa na etavuana, e ia Kota ekamonagina talimana. ");
INSERT INTO khz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Taunatauna vegata, avaikilamina, au geku kila pene kwalanaa talimana ati pene kwarega.” ");
INSERT INTO khz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iuda talimara gekilato, “Ai ewagumona paga ripa-namanama, goi palagu rakavana na eporogimuto. Aperaamo ekwaregato, peroveta talimara maki gekwaregato, a goi okilana, rai na goi gemu kila pene kwalanara talimana ati pene kwarega. ");
INSERT INTO khz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ai tamamai Aperaamo ekwaregato. Goi na ia, ai tamamai Aperaamo, oiwaato, ei? Ia ekwaregato e peroveta talimara maki gekwarega-gatuto. Goi otugamagina, goi rai?” ");
INSERT INTO khz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu evega-geleto, netiwato, “Pere au matotauku para vevega-rage, geku vevega-rage ati ganina. Na au Tamaku na evega-ragekuna. E ia gomi na gokilagiana, gokilana gomi gemi Palagu nogotina. ");
INSERT INTO khz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gomi ati ripami ia, na au ripaku ia. Pene au pana kila, au ati ripaku ia, au opakau talimaku gomi vetaimi, na au ripaku ia, e gena kila akwalanarana. ");
INSERT INTO khz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Gomi tamami Aperaamo etugamagito, au geku vogomai tomana pene gitaa netiwato, gaurai everereto. Egitaato, ne aona enamato.” ");
INSERT INTO khz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iuda talimara na Iesu gevaikilaato, negetiwato, “Goi gemu maguli rigolora gagala imaima (50) maki rogoti ere rawalia, rakagau gaurai Aperaamo ogitaato notina?” ");
INSERT INTO khz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu na evega-gelerato, netiwato, “Avaikila-taunataunamina, Aperaamo rogoti ere wala aonai, au amaguliwai.” ");
INSERT INTO khz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ne vatu gegapito, ia vatua negetiwato, na Iesu elaka-veavugato, ne vekarawarana Rupu Veaga aonana elaka-piatito. ");
INSERT INTO khz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesu elaka-vanagiwai aonai, talima ta egitaato. Votalima mata-kele ewalato. ");
INSERT INTO khz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Gena melo na gerenagiato, negetiwato, “Vevega-ripa talimamu, rai ekala-rakavato, gaurai etalima matana kele ewalato? Ia pa tamana e tinana?” ");
INSERT INTO khz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu evega-geleto, netiwato, “Ati ia gena rakava pa ati tamana e tinana geria rakava pakurai, na evetaina ewalato kwalana, Palagu gena tiavu ia genana pene matagai ulanana. ");
INSERT INTO khz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Au etugukuto Palaguna gena inagulu maeka aonai pita kalara. Pogi ne vogomai, mata ati pene inagulu ripa. ");
INSERT INTO khz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Au tanoparai roe ataluna aonai, au tanopara maekana.” ");
INSERT INTO khz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ekila ekilagiato mulinai, Iesu kwano ai ekainiuto. Kainiuna na pali emoneato, ne vopalina mata-kele talimana matana eiruato. ");
INSERT INTO khz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","E evaikilaato, netiwato, “Ono ago, wailamu Siloama kovunai ono veguligia.” Siloama ganina, “Palagu na etuguato talimana.” Ne, eagoto, wailana eveguligiato, ewaikule-waito aonai, matana warau ealirato. ");
INSERT INTO khz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ia lagana talimara e vanagivanagi enoginogiwai kapunai gegitaawai talimara geverenagito, negetiwato, “Etalima noginogi kapunai etanu-tagowai talimana ei?” ");
INSERT INTO khz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Reketa gekilato, “Talimana nea” Na reketa gekilato, “Aikina, ne matalima ta, na gitagitanamo ia vetaina.” Na ia matotauna ekilato, “Talimana au ea.” ");
INSERT INTO khz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Taunilimalima gekilato, “Goi matamu raka poali-tiwaa?” ");
INSERT INTO khz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ia evega-geleto, netiwato, “Votalima arana Iesu, ia na pali pemonea, au mataku ai peirukaua, ne pevaikilaku, ‘Siloama kovunai onove guligia.’ Paago, paguligia, ne mataku paalira.” ");
INSERT INTO khz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Magerenagiato, negetiwato, “Talimana arigia?” Ia evega-geleto, netiwato, “Au ati ripaku.” ");
INSERT INTO khz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ne matana enamato talimana Parisea talimara geriai gevaiagoato. ");
INSERT INTO khz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Votoma Iesu na pali emoneato, mata-kele talimana matana evega-namaato voo Tapati tomana. ");
INSERT INTO khz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Gaura pakurai Parisea talimara na magerenagi-waiato, matana raka peali-tiwara. Ia na evaikilarato, netiwato, “Votalima na mataku palina eiruato, ne wailaku aguligiaato, ewagumona apoepoena.” ");
INSERT INTO khz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisea talimara reketa gekilato, “Etalima ati Palagu genana evogomaito, kwalana ia na Tapati ati ekwalanaana.” Reketa gekilato, “Kala rakava talimara na vokala vetaira raka pia kala-tiwara?” voanana ira matotaura geveware-kavalugato. ");
INSERT INTO khz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ne Parisea talimara na votalima magerenagiato, negetiwato, “Goi okilana ia na matamu pevega-alira notina? Goi na ia raka ogita-tiwaana?” Ia evega-geleto, netiwato, “Ia peroveta talimana.” ");
INSERT INTO khz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Iuda talimara na etalima gena kila ati gevega-taunataunaato, kwalana ekilato, ‘Tovotovonai au mataku kele, a ewagumona apoepoe-vega-namana.’ Gaura pakurai tamana e tinana gekea-mairato. ");
INSERT INTO khz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ne ira na gerenagirato, negetiwato, “E gomi natumi pa? Taunatauna ia mata-kele ewalato nogotina? E rakagau gaurai ia ewagumona, e poepoena?” ");
INSERT INTO khz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ne tamana e tinana gevega-geleto, negetiwato, “Ai ripamai, ia ai natumai, e ai ripamai maki, ia mata-kele ewalato. ");
INSERT INTO khz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Na ai ati ripamai, ewagumona arigi rauparai epoepoena. Ai maki ati ripamai, rai na matana pevega-namaa. Iorenagia, ia melo kamu, pe matotauna pene vega-gele.” ");
INSERT INTO khz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamana e tinana vovetaina gekilato, kwalana Iuda talimara kalira na gekalito gaurai. Kwalana Iuda talimara na gevega-taunataunaato, talima taa na Iesu pene kilagia Keriso nepenetiwa talimana, rupu na pia tao-gerevagia. ");
INSERT INTO khz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Vovetaina gaurai tamana e tinana gekilato, “Ia melo kamu, pe iorenagia,” negetiwato. ");
INSERT INTO khz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Matana enamato talimana magekea-waiato, ne gevaikilaato, negetiwato, “Palagu wailanai ono kila-gavu, pe ono kila-rorirori. Ai ripamai, goi matamu pevega-namaa talimana ia kala rakava talimana.” ");
INSERT INTO khz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Matana enamato talimana evega-geleto, netiwato, “Au ati ripaku, ia kala rakava talimana pa aikina. Gau kwatunamo ripaku: Au mataku kele, na ewagumona apoepoena.” ");
INSERT INTO khz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ira na gevaikilaato, negetiwato, “Votalima rakagau ekalato goi gemu ai? Goi matamu kele na raka evega-alitiwaato?” ");
INSERT INTO khz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ia evega-geleto, netiwato, “Au na gomi warau pavarami, na gomi ati gokamonagina. Rakagau gaurai goririwana maiokamonagiwai nogotina? Gomi maki ia gena melo ai ioago nogotina pa?” ");
INSERT INTO khz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ne irana gevaikila-gaokaato, negetiwato, “Goi ne ia gena melo, ai Mose gena melo. ");
INSERT INTO khz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ai ripamai Palagu na Mose evaikilaato. A netalima, ai ati ripamai ia ravanana evogomaito!” ");
INSERT INTO khz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Matana enamato talimana evega-geleto, netiwato, “A, gomi rakagau gaurai magokilana, nogotina gomi ati ripami ia ravanana evogomaito? Na iogitaa, ia na au mataku pevega-namaa. ");
INSERT INTO khz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ita ripara, Palagu na kala rakava talimara ati ekamonagi-venirana, a raira na ia gekwalanaana e gena ririwa kalara gekalarana talimara, ia na ekamonagi-venirana. ");
INSERT INTO khz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tanopara evetinato vegata talima ta rogoti tara kamonagia, talima ta mata-kele ewalato talimana matana evega-aliato. ");
INSERT INTO khz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Pere etalima Palagu genana ati pere vogomai genai, ia na gau ta ati pere kalaa ripa.” ");
INSERT INTO khz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ira gevega-geleto, negetiwato, “Goi owalato vegata rakava talimamu, rakagau gaurai ai ono vega-ripamai notina?” Ne rupu aona na gegui-atiato. ");
INSERT INTO khz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu ekamonagito, matana enamato talimana gegui-atiato, talimana erawaliato aonai, evaikilaato, netiwato, “Taunilimalima Natuna ovega-taunataunaana pa?” ");
INSERT INTO khz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Votalima evega-geleto, netiwato, “Velekou, ia rai? Ono varaku, pe pana vega-taunataunaa.” ");
INSERT INTO khz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu na evaikilaato, netiwato, “Talimana warau ogitaana ea, goi ewagumona ia goti gokilakilana.” ");
INSERT INTO khz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ne matana enamato talimana ekilato, “Velekou, avega-taunataunamuna.” Ne etiu-talito, Iesu ealiruputali-veniato. ");
INSERT INTO khz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iesu ekilato, “Au veagirori ulanana etanoparai avogomaito, mata-kele talimara pia poepoe ularana, e gepoepoena talimara matara pia kele ularana.” ");
INSERT INTO khz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisea talimara vonai ia ria, ekila gekamonagiato, ne gevaikilaato, negetiwato, “Goi okilana, ai mata-kele notina?” ");
INSERT INTO khz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu evega-geleto, netiwato, “Pere gomi mata-kele genai, gomi ati gemi rakava pogoro talu, na gomi gokilana, ‘Ai matamai alitago’ nogotina, gaurai gomi gemi rakava atami ai roe nea.” ");
INSERT INTO khz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iesu ekilato, “Taunatauna, au na gomi avaikila-taunataunamina, mamoe kanana vanagina na ati pene laka-toga, na raupara taa na pene pae vanagi talimana ia lema e verari talimana. ");
INSERT INTO khz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A mamoe gitatagora talimana kana vanagina na pene laka-toga. ");
INSERT INTO khz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kana vanagina gitatagona talimana na gena vanagi pene kala-pakaa, ne mamoe na ia karona gekamonagiana. Ia na gena mamoe arara evatorana, ne evaiatirana. ");
INSERT INTO khz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Gena mamoe maparara evaiatirana, ne ira wailarai elakana, gena mamoe ia mulinai gelakakauna, kwalana mamoe riparia ia karona. ");
INSERT INTO khz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A talima poluna ta mulina na ati pia ago, aikina kinavagi; talima poluna genana pia laka-gerevagi, kwalana ia karona mamoe ati riparia.” ");
INSERT INTO khz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu na voparapore evega-riparato, na ira ati getugamagi-iluto. ");
INSERT INTO khz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Na Iesu na maevaikilarato, netiwato, “Au na avaikila-taunataunamina. Au mamoe geria kana vanagina. ");
INSERT INTO khz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gevogomai-kuneto talimara maparara lema e verari talimara. Gaurai mamoe na karora ati gekamonagirato. ");
INSERT INTO khz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Au kana vanagivanagina. Rai au gekuna pene laka-toga talimana ia pene maguli. Pene laka-toga, pene laka-piati, e ganigani pene rawali. ");
INSERT INTO khz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Lema talimana ati pene vogomai-kawa. Na ia lema pene vogomai, vagivagi pene vogomai, vevega-rakava kwaikwai ulanana pene vogomai. Na au avogomaito, maguli pia vaia, e maguli na pia vonuvonu-rage ulanana. ");
INSERT INTO khz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Au mamoe gitatagora talimaku namana. Mamoe gitatagora talimana namana gena maguli etao-taliana mamoe pakurai. ");
INSERT INTO khz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Inagulu talimana gevega-voiana vou mamoe egita-tagona talimana, ia ati mamoe gitatagora talimana taunatauna, e ia ati mamoe gatara. Gaura pakurai uraura kwaevana rakavana evogomaina egitaana genai, mamoe pene raokwanira, pene raka-lekwalekwa. Ne uraura kwaevana rakavana na pene gapi-talira, pene vega-kali-lovolovara. ");
INSERT INTO khz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mavoina talimana eraka-lekwalekwana, kwalana ia vetugunagi talimana mavoina, e mamoe maki ati eraramanirana. ");
INSERT INTO khz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Au mamoe gitatagora talimaku namana. Geku mamoe ripaku e geku mamoe maki riparia au. ");
INSERT INTO khz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Vega-gelegelena Tamaku ripana au e au maki ripaku Tamaku vetaina. E geku maguli maki atao-rigoana ira pakurai. ");
INSERT INTO khz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Au mageku mamoe iraura reketa getaluna. Na ira elaveta aonai roe nea. Au na ira maki pana vaimaira. Ira na au karoku pia kamonagia, e ira maki elaveta kwapunamo ai pia ago e gitatagora talimana maki kwapunamo. ");
INSERT INTO khz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tamaku na eulamagikuna, kwalana geku maguli atao-rigoana, e mapana gapi-waia. ");
INSERT INTO khz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Talima taa na au geku maguli ati pene gapi-vagia au gekuna. Au matotauku geku ririwai atao-rigoana. Au mageku tiavu pana tao-rigoa, e mageku tiavu pana gapi-waia. Voo au Tamaku na evaikilakuto pana kalaa.” ");
INSERT INTO khz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ekila galamanai Iuda talimara matotaura vekarawarai geveware-kavalugato. ");
INSERT INTO khz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Talima vovogo gekilato, “Ia palagu rakavana na peporogia, pe pekawaa. Rakagau gaurai, ia gokamonagiana?” ");
INSERT INTO khz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Na talima reketa gekilato, “Talima ta palagu rakavana na pene porogia genai, evetaina ati pene kila. Palagu rakava na mata-kele talimara matara raka pene vega-ali-tiwara?” ");
INSERT INTO khz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Vonai Rupu Veaga Vega-veagana Velekwana Ierusalemai tomana ekwarato. Voo gaulago aonai. ");
INSERT INTO khz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesu Rupu Veaga aonai Solomona gena vanevane na elaka-agowai. ");
INSERT INTO khz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ne Iuda talimara na geruga-gegelagiato, gerenagiato, negetiwato, “Ai roe gaaovoaovona. Arigi toma vou pono varamai, goi rai? Pene goi taunatauna Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna), genai, gemai ono vekilagiati-taunatauna.” ");
INSERT INTO khz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu na evega-gelerato, netiwato, “Au na warau avaikilamito, na ati govega-taunataunakuna. Au Tamaku aranai akalarana kalara na au gevega-matagaikuna. ");
INSERT INTO khz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Na gomi na au ati govega-taunataunakuna, kwalana gomi ati au geku mamoe. ");
INSERT INTO khz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Au geku mamoe na au karoku gekamonagiana. E au ripaku ira, e ira au muliku ai gelakana. ");
INSERT INTO khz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne au na maguli vanagivanagi avenirana, e ira ativagi pia kwarega; e taa na au gekuna ati pene gapi-gerevagira. ");
INSERT INTO khz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ira au Tamaku na evenikuto, e au Tamaku goloka iwavagi, taa na ati pene vanagia. E taa na maki ati gelegele ia gena vegitatago tiavuna aonana pene gapi-gerevagira. ");
INSERT INTO khz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Au e au Tamaku ai kwapunamo.” ");
INSERT INTO khz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ne Iuda talimara vatu gegapito, ia vatua negetiwato. ");
INSERT INTO khz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iesu na evaikilarato, netiwato, “Kala namara vovogo gomi wailami ai akalarato. Vokala maparara au Tamaku na evenikuto pana kalara netiwato. Vokala maparara aorai, arigi kala galamanai goririwana au iovatuku nogotina?” ");
INSERT INTO khz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Iuda talimara gekilato, “Kala namana ta galamanai goi ati gavatumuna, na goi na Palagu okilagi-piatogaana gaurai. Goi taunilimalimamo, na matotaumu Palagu ai ovevega-agona.” ");
INSERT INTO khz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu na evega-gelerato, netiwato, “Gomi gemi rova aonai kila ta evetaina ekilana, ‘Au akilato, gomi palagu.’ ");
INSERT INTO khz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ita ripara, rakagau Puka Veaga aonai ekilagiana kilana emia-vanagivanagina. Palagu na votaunilimalima ekilagirato ‘palagu,’ e Palagu na gena kila evenirato talimara ira. ");
INSERT INTO khz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","A au Tamaku na evirigikuto, e etugukuto tanoparai; rakagau gaurai govaikilakuna, nogotina, au na Palagu akilagi-piatogaana, kwalana au akilana, ‘Au Palagu Natuna’ natina ei? ");
INSERT INTO khz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Pene au Tamaku gena kala ati akalarana genai, ragai pio vega-taunataunaku. ");
INSERT INTO khz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Na gena kala akalarana genai, vokala pio vega-taunataunara, pene au ragai pio vega-taunataunaku nogotina. Pio ripa e pio vega-taunatauna, Tamaku au aoku ai etaluna, e au maki Tamaku aonai ataluna.” ");
INSERT INTO khz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Vokila galamanai geririwato, Iesu pia gapia negetiwato, na gimara na evegaivagito, elakato. ");
INSERT INTO khz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ne voanana Iesu ewaikuleto. Eagoto, Ioridana waina na elaka-vanagito, eagoto kavata roparopanai, kunenai Ioane evebapatisowai kapunai; vonai etaluwai. ");
INSERT INTO khz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Talima vovogo ia genai geagoto, negetiwato, “Ioane na vegailia irauna ta ati ekalaato, na etalima kilana ekilagirato kilara maparara taunatauna vegata.” ");
INSERT INTO khz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Vonai talima vovogo Iesu gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania talimana ta arana Laasaro evitiato. Betania Maria mavavine kavana Mareta goti geria vanuga. ");
INSERT INTO khz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","E Maria e enai Velekou mulamula ponana nama iwavagina na erigaato, e Velekou gagena maki guinana eiru-lakiato vavinena. Laasaro ia Maria walawalana koloana. ");
INSERT INTO khz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ne evavine ruala na Iesu gena kila getuguato, negetiwato, “Velekou, goi na oulamagiana talimana pevitia.” ");
INSERT INTO khz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesu na vovali ekamonagiato aonai, ekilato, “Nevitina ati pene veakwaregaa. Ne Palagu gena tiavu e vegailia iwavagina pene matagai ulanana. E neia genana Palagu Natuna pia vega-ragea.” ");
INSERT INTO khz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu na Mareta mavavine kavana Maria e Laasaro eulamagirawai. ");
INSERT INTO khz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Na Laasaro gena viti valina ekamonagiato, toma ruala etalu-agirato, etaluwai kapunai. ");
INSERT INTO khz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Votoma ruala mulirai gena melo evaikilarato, netiwato, “Ita maita waikule-wai Iudeai.” ");
INSERT INTO khz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Gena melo na gevaikilaato, negetiwato, “Vevega-ripa talimamu, ewalagani vou Iuda talimara na vatu na ia vatumu nepegetiwa, a ewagumona maita waikule-wai notina.” ");
INSERT INTO khz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu na evega-gelerato, netiwato, “Toma kwapuna aonai ora maparara gagalana ruala ei? Pene talima ta lagani maekanai elakana genai, ati pene vekwakunagi, kwalana ia etanopara maekanai epoepoena. ");
INSERT INTO khz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Na mukunai elakana talimana evekwakunagina, kwalana ia aonai maeka ati emiana.” ");
INSERT INTO khz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesu na evetaina evaikila-gaturato mulinai, maevaikilarato, netiwato, “Ita gatara Laasaro emaituna, na au aagona, maitu na ana vago-keroa.” ");
INSERT INTO khz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ne gena melona gevaikilaato, “Velekou, pene emaituna genai, roe nea pene nama.” ");
INSERT INTO khz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na Iesu na voo ekwaregato ekilagiawai. A gena melo matapolu gekilawai, eagalagina gaurai emaitu-kwaregato ekilagiana, negetiiwai. ");
INSERT INTO khz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ne Iesu na evara-namanamarato, netiwato, “Laasaro pekwarega. ");
INSERT INTO khz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na gomi gemi nama atugamagiana gaurai avererena, votomai au ia goti aikina, kwalana eia genana pio vega-taunataunaku. Gaurai ita ago genai.” ");
INSERT INTO khz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ne Tomas, arana ta Didimas pa Kapa negetiiwai, na Iesu gena melo reketa evaikilarato, netiwato, “Ita maki ia ria ita ago, pe ia ria pita kwarega-kou.” ");
INSERT INTO khz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu ekwarato aonai eripato, Laasaro tauniparana toma vativati lega aonai warau pemaoko-agira. ");
INSERT INTO khz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania e Ierusalema vepakara kilomita toitoi vetaina. ");
INSERT INTO khz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E Iudea talimara vovogo Mareta e Maria geriai geagoto, tauniparara pia vega-tiligara ulanana, kwalana walawalaria ekwaregato gaurai. ");
INSERT INTO khz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mareta ekamonagito, Iesu evogomaiwai gaurai, elakawaila-wailaato Iesu goti geve verawalito. A Maria numai etanu-vaigoakato. ");
INSERT INTO khz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ne Mareta na Iesu evaikilaato, netiwato, “Velekou, goi pere enai genai, au walawalaku ati pere kwarega. ");
INSERT INTO khz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na au ripaku, ewagumona maki rakagau Palagu pono nogia gauna, Palagu na pene venimu.” ");
INSERT INTO khz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu na evaikilaato, netiwato, “Goi walawalamu pene kuliiti-wai” ");
INSERT INTO khz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mareta na Iesu evega-geleato, netiwato, “Au ripaku, toma ikanai kuliitiwai tomanai ia pene kuliiti-wai.” ");
INSERT INTO khz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu na Maria evaikilaato, netiwato, “Au kuliitiwai, e maguli. Au pene vega-taunataunaku talimana pene kwarega, na roe mapene maguli. ");
INSERT INTO khz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E rai roe magulina aonai, au evega-taunataunakuna, ati vagi pene kwarega. Ekila ovega-taunataunaana pa?” ");
INSERT INTO khz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mareta na evaikilaato, netiwato, “Pa Velekou, au na avega-taunatauna-vagimuna, goi taunatauna Keriso, Palagu Natuna, tanoparai pono vogomai talimamu.” ");
INSERT INTO khz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mareta vovetaina ekilato mulinai ewaikule-waito, ne vavine kavana Maria veavugai eve kea gariato, netiwato, “Vevega-ripa talimana pevogomai e goi etavumuna.” ");
INSERT INTO khz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria vokila ekamonagiato aonai, veganamo ekuliitito, Iesu genai eagoto. ");
INSERT INTO khz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Voorai Iesu vanugai rogoti ere laka-toga, ia Mareta na erawaliato kapunai roe voa. ");
INSERT INTO khz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iuda talimara, Maria getanu-rukurukuawai talimara, na Maria gegitaato, eraka-kuliitito elaka-piatito aonai, mulina na geagoto. Ira matapolu gekilato, Maria kalai eagona, kwarega talimana eneve tagi-agia negetiwato. ");
INSERT INTO khz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria eagoto, Iesu laganai eruga-talito, Iesu egitaato aonai, gagena kwalanai etiu-talito, ne evaikilaato, netiwato, “Velekou, goi pere enai, au walawalaku ati pere kwarega.” ");
INSERT INTO khz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu na Maria egitaato etagiwai, e Iuda talimara, ia ria gevogogmaito talimara, maki getagiwai gaurai, ia aona maki evetuga-rakavato, roli etagito. ");
INSERT INTO khz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne Iesu na erenagirato, netiwato, “Ariginai gotaoato?” Ira na gevega-geleato, negetiwato, “Velekou, ono vogomai, pe onoma gitaa.” ");
INSERT INTO khz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu etagito. ");
INSERT INTO khz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ne Iuda talimara gekilato, “Iogitaa, Laasaro eulamagi-rakavaana.” ");
INSERT INTO khz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Na Iuda talimara reketa gekilato, “Etalima na mata-kele talimana matana evega-aliaato, pe Laasaro maki ati vagi pere kwarega, ei?” ");
INSERT INTO khz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Voana Iesu aona evega-vekwalavi-rakavaato, ne kala kapunai eagoto. Vokala vatu kovogana vatu taa na getape-gavuato. ");
INSERT INTO khz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu ekilato, “Vatu iogapi-pakaa.” Mareta, vokwarega talimana walawalana, na Iesu evaikilaato, netiwato, “Velekou, ia ekwaregato tomana na pene vogomai ewagumona toma vega-vativatina (4), pe ponana rakava vagi.” ");
INSERT INTO khz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesu na Mareta evaikilaato, netiwato, “Au na goi pavaikilamu, pene pono vega-taunataunaku genai, Palagu maekana ralemana iwavagina pono gitaa napatiwa, ei?” ");
INSERT INTO khz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ne kwarega talimana getaoato kapuna vatuna gekule-pakaato. Voia mulinai Iesu epoe-itito, ne ekilato, “Tamaku o, au na goi atanikiumuna, kwalana goi na warau pokamonagiku. ");
INSERT INTO khz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Au ripaku, goi na vanagivanagi okamonagikuna. Na evetaina avaikilamuna kwalana etaunilimalima geruga-tagona enai pakurai. Pe ira na pia vega-taunataunaa, au goi na otugukuto.” ");
INSERT INTO khz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Vovetaina ekilato mulinai ekea-paralato, netiwato, “Laasaro, onoma lakati!” ");
INSERT INTO khz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ne ekwaregato talimana kwarega rapugara na gimana e gagena gerekorato e wailana gekumu-agiato rapugana ria elaka-piatito. Iesu na evaikilarato, netiwato, “Iolugaa, pe ene laka.” ");
INSERT INTO khz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ne Iuda talimara vogo, Maria genai geagoto talimara, Iesu na vokala ekalarato gegitarato aonai, vogo Iesu gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Na reketa gewaikule-waito Parisea talimara geriai, ne Iesu na rakagau ekalarato gaura geve vararato. ");
INSERT INTO khz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ne Rupu Veaga velera kamura e Parisea talimara na kaonsela talimara gekea-koukouratao, ne gevaikilarato, “Ita ewagumona rakagau ita kala? Etalima na vegailia irau vagira vogo ekalarana. ");
INSERT INTO khz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Pene ia evetaina ita na tipo pita gitaguilagia genai, taunilimalima maparara na ia pia vega-taunataunaa. Ne Roma talimara pia vogomai, ita gera kapu (pa Rupu Veaga) e gera tanopara ita gerana pia gapi-vagira.” ");
INSERT INTO khz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nea ira aorai talima ta arana Kaiapa, ia volaganinai Rupu Veaga velena kamuna, ia na evaikilarato, netiwato, “Gomi gau ta ati ripami! ");
INSERT INTO khz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gomi ati gotugamagi-iluna, namana talima kwapunamo taunilimalima maparara pakurai pene kwarega, a etanopara maparana pia vega-rakava-gatuvagia ati nama.” ");
INSERT INTO khz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ia vovetaina ekilato, ati ia matotauna maaona maparana ekilato; na ia volaganinai Rupu Veaga velena kamuna, gaura pakurai ia eperovetato, Iesu pene kwarega Iuda talimara maparara pakurai. ");
INSERT INTO khz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E Iesu ati Iuda talimaramo pakurai pene kwarega. Na Palagu natuna kapu irauirau ai getalu-lovolovona talimara maparara pene gapi-koukoura, golea kwapunai pene vega-agora ulanana. ");
INSERT INTO khz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gaura pakurai votoma na evetinato eagoto, Iuda talimara kamura na Iesu raka pia vagi-kwarega-tiwaa raupana getavuato. ");
INSERT INTO khz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Vovetaina gaurai Iuda talimara wailarai Iesu ati elaka-matagaiwai. Vokapu eraokwaniato, eagoto tanoleanai taunilimalima aikina kapuna laganai, vanuga ta arana Efraim ai. Gena melo ria vonai getaluwai. ");
INSERT INTO khz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iuda talimara geria Pasova velekwana ekavinagito. E Iuda talimara vogo votanoparai getaluwai Ierusalemai gema laka-koukouto. Ira gema laka-koukouto ganina taunatauna, Palagu wailanai pia vekala-vealeva voupe, Pasova velekwana pene vetina. ");
INSERT INTO khz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ira na Iesu getavuawai, Rupu Veaga aonai geruga-koukouto genai, matotaura nuganugaraimo geverenagi-verenagito, negetiwato, “Gomi raka gotugamagi-tiwana? Evelekwai toma ema matagaina pa?” ");
INSERT INTO khz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Rupu Veaga velera kamura e Parisea talimara na vevega-nagi kilana warau Iuda talimara gevenirato, gevaikilarato, pene ta pene kamonagi Iesu ariginai, ia rorirori pene ago, Iuda velera pene vevarara, pe pia gapia. ");
INSERT INTO khz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pasova velekwana toma taula toitoi wailai roe voa aonai, Iesu Betaniai eagoto. Laasaro Betaniai etaluwai, e vonai ekwaregato, Iesu na kwarega na evega-kuliiti-waiato. ");
INSERT INTO khz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Vonai Iesu ralialona ganiganina gekalaato. Mareta na garia ganigani erapalaato, Laasaro maki vonai ganigani kapunai getanu-koukouto talimara ria getanu-kouto, geganiganiwai. ");
INSERT INTO khz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ne Maria na mulamula ponana nama iwavagina lita kapana vetaina egapiato, ne Iesu gagena ganapana eriga-agiato, e guina na eiru-lakiato. Numa maparana vomulamula ponana na evaiato. Vomulamula gautupu arana nad lamuna na gekalaawai, voina kamu vagi. ");
INSERT INTO khz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na Iesu gena melo ta arana Iudas Isakariota, e Iesu roe nea vou pene lewaa talimana, ekilato, ");
INSERT INTO khz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Rakagau gaurai emulamula maparana siliva monira tinavu toitoi (300) ai ati pevoi-agaia? (E talima kwapuna voina rigolo kwapuna aonai vetaina). Pere voi-agia, pe voina monina pere gapia, lealea talimara pere venira.” ");
INSERT INTO khz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ia vovetaina ekilato, ati lealea talimara evetugarawai gaurana, na kwalana ia lema talimana gaurana. Ia moni putena evua-loulouawai, e vopute aonai moni elemarawai, ne gena ririwa gaura evoi-agirawai. ");
INSERT INTO khz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ne Iesu na evaikilarato, netiwtao, “Ioraokwania, e vavinena rakagau pere kalaa gauna pekalaa, ia na au tauniparaku mulamulana peiru-kunea, toletoleku ulanana. ");
INSERT INTO khz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lealea talimara vanagivanagi gomi ria pio talu, na au gomi ria ati pita talu-vagi.” ");
INSERT INTO khz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iuda talimara vogovagi gekamonagito Iesu Betaniai. Ne vonai geagoto, ati Iesumo ulanana, na Laasaro maki pia gitaa ulanana. Laasaro kwarega na Iesu na evega-kuliiti-waiato. ");
INSERT INTO khz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Vovetainai gaurai Rupu Veaga velera kamura navuga getovoato Laasaro maki pia vagi-kwaregaa negetiwato. ");
INSERT INTO khz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kwalana ia pakunai Iuda talimara vogo ira geriana gelaka-gerevagito, ne Iesu gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Elaganiato aonai, velekwa ulanana gevogomaito talimara vovogo gekamonagito, Iesu Ierusalemai warau eagowai. ");
INSERT INTO khz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Lauta e kalamo laura vetaira gaura gegapito, ne Iesu genai geagoto, gelailaito, negetiwato, “Hosana, Velekou aranai evogomaina talimana ita vega-namaa! Isaraela geria King ita vega-namaa!” ");
INSERT INTO khz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu na doniki natuna ta erawaliato, ne atanai etanukauto, Puka Veaga aonai ekilana gelegelenai, ");
INSERT INTO khz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Siona natuna, (Ierusalema talimami), ragai iokali, iopoe-ago, gemi Vele evogomaina, ia doniki natuna atanai petanukau.” ");
INSERT INTO khz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Votoma gena melo na egaura ati getugamagi-ilurato. Na Palagu na Iesu evega-rageato e maeka ralema iwavagina eveniato mulinai vou, ira geripa-rorirorito, egaura maparara getalorato, ia gekilagiato. E geripato, vokala maparara ia genai gekalarato. ");
INSERT INTO khz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iesu na Laasaro kala vatuna kovogana na ekea-piatiato, e kwarega na evega-kuliiti-waiato tomanai, taunilimalima gutuma para ia ria. Na votalima na vokala gegitaato valina roe wagepiaawai. ");
INSERT INTO khz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Talima gutuma geagoto Iesu ria pia verawali, kwalana gekamonagito, Iesu na vegailia irauna ekalaato pakunai. ");
INSERT INTO khz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Vovetainai Parisea talimara matotaura aorai geveineveineto, gekilato, “Gogitaana, gomi ati gotiligana. Iogitaa, etanopara talimana maparana ia mulinai gelakana.” ");
INSERT INTO khz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Velekwa tomanai aliruputali ulanana Ierusalemai geverageto talimara aorai, Grik pa Helene talimara reketa maki gelakakauto. ");
INSERT INTO khz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ira geagoto Filipo genai, ne gevaikilaato, negetiwato, “Velepara, ai gaririwana Iesu aia gitaa nagatina.” Filipo Galileia tanonai vanuga ta arana Betesaida talimana. ");
INSERT INTO khz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipo eagoto Anduru eve vaikilaato, ne tauria ruala geagoto, Iesu gevaikilaato. ");
INSERT INTO khz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu na evega-gelerato, netiwato, “Orana warau pekwara, Taunilimalima Natuna maeka ralema iwavagina pene vaia. ");
INSERT INTO khz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Taunatauna vagi avaikilamina, vuiti uvena kwano aonai pene rigo e pene kwarega vou, ganira vogo ia genana pia wala. A vuiti uvena kwano aonai ati pene rigo e ati pene kwarega genai, gereganamo pene mia. ");
INSERT INTO khz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Gena maguli eulamagiana talimana na gena maguli pene piatogaa. A e tanoparai gena maguli etugamagi-piatogaana talimana na, gena maguli e etao-togaana maguli vanagi ulanana. ");
INSERT INTO khz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Au vetugunagiku eago-veniana talimana muliku ai pene laka; pe au ariginai, au vetugunagiku eago-veniana talimana maki vonai au goti. Au vetugunagiku eago-venina talimana, au Tamaku na ia maki pene vega-namaa.” ");
INSERT INTO khz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ewagumona au aoku evekwalavina, e geku tugamagi pekamu. Gaurai rakagau naanatiwa? Ana kila, ‘Tama, eora ono mai-vega-namaku’ naanatiwa? Aikina, au geku vogomai ganina taunatauna aonai pama kwara ea. ");
INSERT INTO khz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamaku, goi aramu ono vega-ragea.” Ne karo ta kupana ema rigoto, netiwato, “Au na araku warau pavega-ragea, e eia maki mapana vega-rage-waia.” ");
INSERT INTO khz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Talima gutuma vonai rugakou na vokaro gekamonagiato, ne gekilato, “Kupa pekulua.” Mareketa gekilato, “Aneru taa na pevega-vegupua.” ");
INSERT INTO khz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu na evega-gelerato, netiwato, “Ne karo ne ati au ulakuna pevogomai, na gomi ulami na pevogomai. ");
INSERT INTO khz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ewagumona tanoparai Palagu na veagirori ekalaana. Ewagumona Palagu na etanopara velena, Satani, eveakalovoana. ");
INSERT INTO khz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ne au tanopara na pene gapi-itiku, voanana taunilimalima maparara au geku ai pana rolo kavira.” ");
INSERT INTO khz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ia evetaina ekilato, ia gena kwaregai raka pene kwarega-tiwa gauna ekilagi-atiato. ");
INSERT INTO khz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Taunilimalima gevega-geleto, negetiwato, “Ai rova kilara gakamonagito, Keriso pene talu-vanagivanagi, goi rakagau gaurai okilana, Taunilimalima Natuna pia gapi-itia? Taunilimalima Natuna rai?” ");
INSERT INTO khz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ne Iesu na evaikilarato, netiwato, “Maeka gomi ria ati pene mia rau. Maeka gomi ria roe nea aonai, maekai iolaka, mukuna na negapimina nea. Mukuna aonai elakana talimana ati ripana, ia ravanana eagona. ");
INSERT INTO khz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Maeka gomi ria roe nea aonai, maeka pio vega-taunataunaa, pe maeka natunai pio ago.” Ekila ekilagi-gaturato mulinai eraokwanirato, ne eagoto, ati pia rawalia kapunai etaluwai. ");
INSERT INTO khz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu na Iuda talimara wailarai vegailia irau vagira vovogo ekalarato, na roe voa ati gevega-taunataunaawai. ");
INSERT INTO khz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Voanana peroveta talimana arana Isaia gena kila etaunataunato, Isaia evetaina ekilato, “Velekou, rai na ai gema kila pene vega-taunataunara? Rai genai Velekou gena tiavu pene matagai?” ");
INSERT INTO khz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ira na Iesu ati gevega-taunataunato ganina, Isaia kapu taai gena talotalo ai maekilato, ");
INSERT INTO khz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Palagu na matara evega-kelerato, e aora evega-mukunarato, kwalana matarana ragai pia poepoe, e aorai ragai pia tugamagi-ilu ulanana. Au geku ai ragai pia waikule, naavega-namarana kalinana.” ");
INSERT INTO khz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia vovetaina ekilato, kwalana ia na Iesu maekana ralemana e tiavuna iwavagina egita-kuneato, gaurai ia ekilagiato. ");
INSERT INTO khz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iuda kuneagina velera vovogo na maki Iesu gevega-taunataunaato, na Parisea talimara kalira na gekaliwai, gaurai Iesu ati gekilagi-matagaiawai. Kwalana pene pia kilagi-matagaia genai, Parisea talimara na rupu na nege gaivagirana kalinana. ");
INSERT INTO khz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kwalana Iuda velera geria ririwa kamuna, taunilimalima na pia vega-ragera, a Palagu na pene vega-ragera tugamagina ati gekalaawai. ");
INSERT INTO khz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iesu eparalato, netiwato, “Au pene vega-taunataunaku talimana ati au evega-taunataunakuna, na au etugukuto Palagu na evega-taunataunaana. ");
INSERT INTO khz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","E au egitakuna talimana na au etugukuto Palaguna egitaana. ");
INSERT INTO khz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Au maeka, etanoparai avogomaito, gaurai au pene vega-taunataunaku talimana mukuna aonai ati pene talu. ");
INSERT INTO khz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pene talima taa na au geku kila ekamonagiana, na ati evega-taunataunaana, au na votalima ati pana agiroria. Kwalana au ati tanopara agirorina ulanana avogomaito. Aikina. Au tanopara vega-magulina ulanana avogomaito. ");
INSERT INTO khz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Au erugakuna e au geku kila ati egapi-ragerana talimana, agirorina talimana ta etaluna. Au na akilagirato kilara, vokilara na ia piave agiroria toma ikanai. ");
INSERT INTO khz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kwalana au ati matotauku geku rorirori ai akilana. Na Tamaku, au etugukuto Palaguna, na au evega-nagikuto au rakagau pana kilagia e raka pana kilagi-tiwaa. ");
INSERT INTO khz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Au ripaku, Tamaku gena kila na taunilimalima maguli vanagivanagi pia vaia. Gaura pakurai au na rakagau akilagirana kilara, rakagau Tamaku na evaikilakuna pana kilagira netina kilaramo.” ");
INSERT INTO khz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasova velekwana roli egapiawai, Iesu eripato, etanopara pene raokwania Tamana genai peneve rage tomana warau pekwara. Etanoparai gena taunilimalima eulamagi-rakavarato, gena ulamagi geriai ati eikato, pene ago ikanai. ");
INSERT INTO khz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Iesu magena melo ria lavilavi ganiganina geganiawai aonai, Tiapolo na Iudas Isakariota, Simona natuna, aona eganiato, Iesu pene lewaa ulanana. ");
INSERT INTO khz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu ripana, Tamana na gaura maparara ia gena tiavu kapulenai etaorato. E maki ripana, ia Palagu genana evogomaito, e mapene waikule Palagu genai; ");
INSERT INTO khz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","gaurai ganigani kapuna na ekuliitito, gena kota egaivagiato, ne taugela eligoato. ");
INSERT INTO khz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ne rivu ai nanu ewagiato, gena melo gagera eguligirato, e eligoato taugelana na eiru-lakirato. ");
INSERT INTO khz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Gageramo eguligi-agorawai pene ago, Simona Petero genai evekwarato, ne Petero na evaikilaato, netiwato, “Velekou, goi au gageku ono guligia notina?” ");
INSERT INTO khz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu na evega-geleato, netiwato, “Ewagumona au na rakagau akalaana kalana ati oripaana, na kapinai vou pono ripa.” ");
INSERT INTO khz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petero na evaikilaato, netiwato, “Aikina, au gageku goi na ativagi pono guligia,” Iesu na evega-geleato, netiwato, “Pene au na goi gagemu ati pana guligia genai, goi ati au geku melo.” ");
INSERT INTO khz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona Petero ekilato, “Velekou, ati gagekumo, na gimaku e repaku maki.” ");
INSERT INTO khz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu na evaikilaato, netiwato, “Erikuna talimana taunipara na maparana vealeva, pe ia gagenamo pene guligia. Gomi maparami vealeva, na kwapunamo ati vealeva.” ");
INSERT INTO khz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesu ripana rai na ia pene lewaa, vovetaina gaurai netiwato, “Ati maparami vealeva.” ");
INSERT INTO khz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Gagera eguligi-gaturato mulinai, gena rapuga kamuna maerogagiato, eagoto gena tanutanu kapunai evetanu-talito, ne evaikilarato, netiwato, “Au na gomi gemi ai rakagau pakalaa kalana ganina taunatauna pogo ripaa pa? ");
INSERT INTO khz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gomi na au gokilagikuna, gokilana ‘Vevega-ripa Talimana’ e ‘Velekou’ voo taunatauna gokilagikuna, kwalana au taunatauna Vevega-ripa Talimaku e Velekou. ");
INSERT INTO khz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pene au gomi gemi Velekou e Vevega-ripa talimakuna gomi gagemi paguligira genai, gomi maki matotaumi aomi aimo taukavami reketa gageria pio guligira. ");
INSERT INTO khz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kwalana au na pavega-gitami, pe au na rakagau gomi gemi ai pakalaa kalana, gomi na maki pio kalaa. ");
INSERT INTO khz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Au na gomi taunatauna avaikilamina, inagulu talimana ati voina talimana na gena vele ati pene iwaa, e vetugunagi melona na pene tugua talimana ati pene vanagia. ");
INSERT INTO khz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ewagumona egaura maparara gomi na pogo ripara, pene pio kalara genai pio verere. ");
INSERT INTO khz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Au na gomi maparami ati akilagimina, au na avirigirato talimara au ripaku. Na e Puka Veaga aonai getalorato kilara pia taunatauna ularana: ‘Rai au goti pereti paia gani-koukoua talimana, kwarilina pene gapi-itia au geku ai’ (Voia ganina, Iesu mapene kilagi-piatoga, ne vagi-kwaregana rauparana pene kalaa). ");
INSERT INTO khz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ewagumona au na wailarai pia wala gaura avaramina, pe pia wala aonai pio ripa-rorirori, (Palagu na etugukuto) Talimana Au. ");
INSERT INTO khz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Taunatauna avaikilamina, au na atuguana talimana egapi-rageana talimana na au egapi-rakekuna. E au egapi-ragekuna talimana na au etugukuto talimana, Palagu, egapi-rageana.” ");
INSERT INTO khz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesu na ekila ekilagirato mulinai, aona evekwalavi-rakavato, gaurai ekila-matagaito, netiwato, “Avaikila-taunataunamina, gomi taa na au pono lewaku.” ");
INSERT INTO khz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ne gena melo gevegitavegitato, ati riparia rai ekilagiato. ");
INSERT INTO khz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Gena melo aorai Iesu na eulamagiawai melona ia genai egegepekauto. ");
INSERT INTO khz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simona Petero na Ioane evarulagiato, eririwato, Iesu pene renagia rai ekilagiana. ");
INSERT INTO khz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ne Iesu genai egegepekauto talimana na, erenagiato, netiwato, “Velekou, vorai?” ");
INSERT INTO khz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu evega-geleto, netiwato, “Au na pereti pana turaa, ne pana venia talimana voa.” Ne Iesu na pereti eturaato, Simona natuna, Iudas Isakariota, eveniato. ");
INSERT INTO khz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iuda na vopereti egapiato, ne ia aonai Satani elaka-togato. Ne Iesu na evaikilaato, netiwato, “Rakagau oririwaana pono kalaa gauna ono kala velekea.” ");
INSERT INTO khz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na geganigani-kouto talimara ta vagi maki ati eripato, rakagau gaurai Iesu na vovetaina evaikilaato. ");
INSERT INTO khz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Voia aonai Iudas moni kouna egita-tagoawai. Vovetainai gaurai ira reketa getugamagito, Iesu na pevaikilaa, velekwai rakagau geririwarana gaura eneve voira, pa lealea talimara gau reketa eneve venira negetiwato. ");
INSERT INTO khz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iudas na vopereti egapi-rageato mulinai, atilovana vonuma na elaka-piatito. Voo warau epogiato. ");
INSERT INTO khz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iuda elaka-piatito mulinai, Iesu ekilato, “Ewagumona Taunilimalima Natuna pia vega-ragea, e Palagu maki Natuna aonana pia vega-ragea. ");
INSERT INTO khz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pene Palagu na Iesu pakunai vevega-rage e maeka ralema iwavagina pene gapia genai, Palagu matotauna na maki matotauna gena maeka ralema iwavagina Taunilimalima Natuna pene venia. Palagu na veganamo pene venia. ");
INSERT INTO khz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Natuku, au gomi ria ati pita talu-rau. Ne gomi na au pio tavuku. Au na Iuda talimara avaikilarato gelegelenai, gomi maki vokilamo kwapuna avenimina: Au aagona kapunai, gomi ati pio ago ripa. ");
INSERT INTO khz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Rova kilana valiguna avenimina. Taukavami ria pio veulamagi. Au na gomi aulamagimina gelegelenai, gomi maki mataukavami ria pio veulamagi. ");
INSERT INTO khz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pene gomi mataukavami ria pio veulamagi-veveni genai, taunilimalima maparara pia ripa, gomi au geku melo.” ");
INSERT INTO khz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simona Petero na Iesu erenagiato, netiwato, “Velekou, goi ariginai, oagona?” Iesu evega-geleto, netiwato, “Au ariginai aagona kapunai, ewagumona au muliku na ati pio vogomai, na kapinai vou pio vogomai mulikuna.” ");
INSERT INTO khz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petero na Iesu evaikilaato, netiwato, “Velekou, rakagau gaurai ewagumona au goi mulimu na ati pana wati ripa? Au goi pakumu ai geku maguli pana tao-rigoa, pana kwarega.” ");
INSERT INTO khz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iesu na Petero evega-geleato, netiwato, “Goi gemu maguli au pakuku ai pono tao-rigoa notina? Avaikila-taunataunamuna, kokoloku rogoti ere kogo aonai, goi na au vega-toitoi pono opa-tagoku.” ");
INSERT INTO khz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nugami ragai pia golugolu, e ragai pio tugamagitugamagi. Palagu pio vega-taunataunaa, e au maki pio vega-taunataunaku. ");
INSERT INTO khz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Au Tamaku gena numai kovoga galagala vagi; pere aikina genai, ekila gomi ati para varami: Au aagona, gomi gemi kapu ta pana kala-maavua. ");
INSERT INTO khz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne aagona, gomi gemi kapu pana kala-maavua. Pana kala-maavu gatua vou, pana waikule-wai, gomi panama vaimi au ria pita talu. Pe au ariginai pana talu, gomi maki au ria pita talu. ");
INSERT INTO khz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Au pana ago kapuna rauparana gomi ripami.” ");
INSERT INTO khz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas na evaikilaato, netiwato, “Velekou, ai ati ripamai goi ravanana oagona, e rauparana raka paia ripa-tiwaa?” ");
INSERT INTO khz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu na evaikilaato, netiwato, “Raupara au, Taunatauna au, e maguli maki au. Talima ta Tamaku genai raupara poluna na ati pene ago. Aikina kinavagi. Aumo gekuna. ");
INSERT INTO khz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pene taunatauna au gomi na goripakuto, au Tamaku maki pogoro ripaa. Na ewagumona vou goripaana e warau pogo gitaa.” ");
INSERT INTO khz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipo na Iesu evaikilaato, netiwato, “Velekou, Tamara ono vega-ripamai, pe aomai pia keto-tali.” ");
INSERT INTO khz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu na evaikilaato, netiwato, “Filipo, au goi goti erapa tatalu-agiato, na goi na au rogoti oro ripaku? Au egitakuna talimana na Tamaku egitaana. Na goi rakagau gaurai okilana, ‘Tamara ono vega-ripamai notina?’ ");
INSERT INTO khz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Goi na ati ovega-taunataunakuna, au Tamaku aonai, e Tamaku au aoku ai, ei? Au na gomi avaikilamina kilara ati au matotauku geku rorirori ai avaikilamina. Aikina. E Tamaku, ia au aoku ai etaluna, ia na gena inagulu ekalarana. ");
INSERT INTO khz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Au akilana, au Tamaku aonai ataluna e Tamaku au aoku ai etaluna natina genai pio vega-taunataunaku. Pene aikina genai, e kala akalarana gogitarana genai pio vega-taunataunaku. ");
INSERT INTO khz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Taunatauna avaikilamina, au evega-taunataunakuna talimana, au na akalarana kalara, ia na maki pene kalara. E ia na kala kamu iwavagira pene kalara, au na akalarana kalara pene vanagira. Kwalana au Tamaku genai aagona. ");
INSERT INTO khz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E au araku ai rakagau pio nogira, au na pana kalara. Voanana Tamaku pia vega-ragea Natuna pakunai. ");
INSERT INTO khz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Au araku ai rakagau pio nogira gaura maparara, kalara au na pana kalara.” ");
INSERT INTO khz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Pene gomi au goulamagikuna genai, au geku rova kilara pio kwalanara. ");
INSERT INTO khz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ne au Tamaku pana nogia, ia na veveakava talimana ta pene venimi. Voveveakava talimana gomi ria pio talu-vanagivanagi. ");
INSERT INTO khz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Veaga Palaguna, ia kila taunatauna evega-matagaiana. Ia tanopara magulinai getaluna talimara na ati pia gapi-ragea ripa, kwalana ati gegitaana e ati geripaana. Na ia gomi ripami, kwalana ia gomi ria gotaluna e gomi aomi ai pene talu. ");
INSERT INTO khz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Au na gomi geregami gamaka vetaira ati pana raokwanimi. Au mapana waikule-wai gomi gemi ai. ");
INSERT INTO khz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tanopara talimara na ati pia gitaku tomana ati rau, na gomi na pio gitaku. Gomi au amagulina gaurai, pio maguli. ");
INSERT INTO khz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Votoma gomi pio ripa, au Tamaku aonai ataluna, e gomi au aoku ai gotaluna, e au gomi aomi ai ataluna. ");
INSERT INTO khz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Au geku rova kilara egapi-ragerana e ekwalanarana talimana na au eulamagikuna. E au eulamagikuna talimana au Tamaku na maki pene ulamagia. Au na maki pana ulamagia e au matotauku ia genai pana vevega-matagai.” ");
INSERT INTO khz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iudas, ati Iudas Isakariota, na evaikilaato, netiwato, “Velekou, rakagau gaurai goi matotaumu ai gemai pono vevega-matagai, na tanopara genai aikina?” ");
INSERT INTO khz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu na evaikilaato, netiwato, “Au eulamagikuna talimana na au geku vevega-ripa pene kwalanaa. Ne au Tamaku na votalima pene ulamagia. Ne taumai ruala paia ago ia genai, ne ia ria paia talu-vanagivanagi. ");
INSERT INTO khz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Au ati eulamagikuna talimana, au geku kila ati ekwalanarana. Ekila gokamonagirana e ati au geku, na Tamaku gena; au ia na etugukuto. ");
INSERT INTO khz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Gomi ria roe ata taluna aonai, ekilara gomi avaramina. ");
INSERT INTO khz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A gomi veakavami talimana Veaga Palaguna. Ia au araku ai Tamaku na pene tugu-maia. Ia na gau maparara pene vega-riapami, e au na rakagau akilagirato gaura, gemi tugamagi ai mapene vega-matagai-waira. ");
INSERT INTO khz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Maino gomi gemi ai araokwaniana. E au geku maino gomi avenimina. E emaino au na gomi avenimina, ati tanopara talimara na gomi gevenimina vetaina avenimina. Nugami ragaina pia golugolu e ragai pio tugamagitugamagi e ragai pio kali. ");
INSERT INTO khz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Au pakila pogo kamonagi, au pakila, ‘Au alaka-gerevagina, na mapana waikule-wai gomi gemi ai.’ Pere au pogoro ulamagiku genai, Tamaku genai aagona, pe pogoro verere, kwalana au Tamaku goloka iwavagi, au tairageku ai. ");
INSERT INTO khz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ekala rogoti gere wala aonai avaramina. Pe ekala pene matagai aonai, pio vega-taunataunaku. ");
INSERT INTO khz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Au gomi ria ati pita kila raurau, kwalana etanopara ekune-agiana velena, Satani, roli ekwarana. Ia ati tiligana, gaurai au geku ai gau kwauta ati pene kalaa. ");
INSERT INTO khz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Na etanopara talimara pia ripa, au na Tamaku aulamagiana. E au Tamaku na ekilagiato gelegelenai akalana. Gaurai iokuliiti, ekapu na ita laka-gerevagi.” ");
INSERT INTO khz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Au vine gautupuna taunatauna, au Tamaku vine aragana inagulu-agina talimana. ");
INSERT INTO khz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Vine ragara au geku ai ragakau gaura, ati gevuana ragara, ia na ekoirana; e raga maparara mavuara, ia na ekoi-alevarana, pia vua vogo ularana. ");
INSERT INTO khz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gomi warau pogo vealeva-gatu. Vokila avenimito gaurana pege alevami. ");
INSERT INTO khz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Au geku ai pio raga-tago, pe au maki gomi gemi ai pana raga-tago. A vine ragana ta gereganamo genai ati pene vua, na vine gautupuna genai pene raga-tago vou pene vua. Gomi maki vovetaina, pene au ria ati pita kwapuna genai, ati pio vua. ");
INSERT INTO khz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Au vine, na gomi raga. Au geku ai pene raga-tago, au ia genai pana raga-tago vetaina, talimana vuavuana gagala vagi. Pene au pio raokwaniku genai, gau kwauta ati pio kalaa. ");
INSERT INTO khz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Au geku ai ati eragakauna talimana, vine gautupuna ragana vetaina pia gapia, pia piatogaa, ne peneve lako. Voraga lakora gegapi-koukourana, kalovai gepia-ragerana, ne egalarana. ");
INSERT INTO khz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pene gomi au geku ai pio raga-tago pa au ria pita kwapuna, au geku kila gomi gemi ai pene mia genai, rakagau goririwarana gaura pio nogira, gemi noginogi gaura pio rawalira. ");
INSERT INTO khz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pene vuavuami vogo galagala vagi genai, taunilimalima na au Tamaku gevega-rageana, e gomi maki au geku melo taunataunarai pio ago. ");
INSERT INTO khz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tamaku na au eulamagikuna gelegelenai, au na gomi maki aulamagimina. Vanagivanagi au geku ulamagi aonai pio talu. ");
INSERT INTO khz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pene au geku rova kilara pio kwalanara genai, gomi au geku ulamagi aonai pio talu, gelegele au Tamaku gena rova kilara akwalanarana, ne ia gena ulamagi aonai ataluna vetaina. ");
INSERT INTO khz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Au na ekila gomi pavenimi ganina, au geku verere gomi aomi ai pene mia, pe gomi maki aomi verere na pia vonuvonu-rage. ");
INSERT INTO khz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Au geku rova kilara ea, matotaumi vekarawami ai mataukavami ria pio veulamagi, au na gomi aulamagimina vetaina. ");
INSERT INTO khz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gena ulamagi kamu iwavagi talimana, taukavana pakurai gena maguli kwavina ati egapiana, etao-rigoana. Gena ulamagi kamu talimana taunatauna na voa, irauna ta aikina, nea. ");
INSERT INTO khz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pene au na rakagau avaikilamina kalara pio kalara genai, gomi au gataku. ");
INSERT INTO khz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Au na gomi vetugunagi talimami ati pana kilagimi, kwalana vetugunagi talimana na gena vele na rakagau ekalaana, ia ati ripana. Na gomi gata napanatiwa, kwalana au Tamaku genana rakagau akamonagirato gaura maparara, gomi warau avega-ripamito. ");
INSERT INTO khz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gomi na au ati govirigikuto, na au na gomi avirigimito, e avega-rugamito pio ago, vuavuami pio vega-walara, voira namamo pia mia-vanagivanagi. Vovetaina gaurai rakagau goririrwarana gaura au araku ai Tamaku pio nogia, Tamaku na pene venimi. ");
INSERT INTO khz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Au geku rova kilana gomi avenimina ea, mataukavami ria pio veulamagi-veveni.” ");
INSERT INTO khz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Pene tanopara talimara na pia aorakava-vagimi genai, pio ripa, au geaorakava-vagi-kunekuto. ");
INSERT INTO khz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pene gomi tanopara gena taunilimalima roe pogoro talu, tanopara talimara na pegere ulamagimi, kwalana gomi ira geria taunilimalima gaurai. Na gomi ati tanopara gena taunilimalima. Aikina. Gomi warau avirigimito, etanopara magulina aonana agapi-vagimito. Gaura pakurai tanopara talimara na geaorakava-vagimina. ");
INSERT INTO khz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Avaikilamito kilana pio tugamagi-tagoa: ‘Inagulu talimana ati voina talimana etugunagiana talimana ati pene iwaa.’ Pene au gevega-vitivitikuto, gomi maki pia vega-vitivitimi. Pene au geku kila gekwalanarato, gomi gemi kila maki pia kwalanara. ");
INSERT INTO khz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iara na ekala ati namara maparara gomi gemi ai pia kalara ganina taunatauna, gomi na au araku gokwalanaana gaurai; kwalana au etugukuto Palaguna ira ati ripara. ");
INSERT INTO khz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Pere au ati para vogomai, e ati para vaikilami, ira ati geria rakava. Na ira ewagumona geria rakava na ati geria rava rauparana. ");
INSERT INTO khz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Au eao-rakavakuna talimana na au Tamaku maki eaorakava-vagiana. ");
INSERT INTO khz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Pere au na kala irau vagira kalara, talima reketara na rogoti gere kalara gaura, ira nuganugarai ati para kalara, ira ati geria kala rakava. Na ewagumona ira na vokala irau vagira kalara pege gitara, aonai ira na au maTamaku goti taumai ruala geaorakava-vagimaina. ");
INSERT INTO khz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na ekalara gewalana kwalana rova aonai getaloato kilana pene taunatauna ulanana. Vokila evetaina ekilana: ‘Au tipo geaorakava-vagi-kawakuto, ati kwalanai.’ ");
INSERT INTO khz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Veveakava Talimana, Veaga Palaguna pene vogomai. Ia kila taunataunara kilagikilagira ulanana, Tamaku genana pene vogomai. Au na gomi gemi ai pana tugua, Tamaku laganai pana talu aonai. Ia na au pene kilagi-matagaiku. ");
INSERT INTO khz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Gomi na maki au roe wapio kilagi-matagaiku, kwalana gomi au ria tataluna tovotovona na vegata gaurai.” ");
INSERT INTO khz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Au na ekila avaramina, kwalana ati aririwana gemi kamonagina pio laka-gerevagi. ");
INSERT INTO khz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Iuda talimara geria rupu na pia tao-gerevagimi. Pa, tomana ea evogomaina, talima taa na pene vagi-kwaregami genai, ia mata polu pene kila, ia Palagu vetugunagina eago-veniana. ");
INSERT INTO khz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ekalara gomi gemi ai pia kalara kwalana ira na au Tamaku ati geripaato, e au maki ati geripakuto. ");
INSERT INTO khz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Na au na ekila ana vara-kunemi. Pe wailai vou taunilimalima na kalara gemi ai piave kalara genai, ekila pavarami pio tugamagira. Tovotovonai au gomi ria roe watataluwai gaurai ekila gemi ati akilagirato. ");
INSERT INTO khz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Na ewagumona ema tugu-rigokuto Palaguna genai maawaikulena, e taa na ati erenagikuna, ‘Goi ravanai oagona?’ ati notina. ");
INSERT INTO khz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Gomi ekilara pavega-ripami gaurai, aomi gevekwalavina e getagitagina. ");
INSERT INTO khz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na taunatauna avaikilamina e gomi gemi nama ulanana gomi aomi na alaka-gerevagina, alakana. Kwalana pene au ati pana laka genai, Veveakava Talimana, Veaga Palaguna, gemi ai ati pene vogomai. Na pene au pana laka genai, gemi ai pana tugu-maia. ");
INSERT INTO khz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","E ia pene vogomai aonai, etanopara talimara geria kala rakava e Palagu gena kala rorirori e Palagu na tanopara talimara pene agirorira ganira pene vega-matagai namanamara. ");
INSERT INTO khz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Geria kala rakava ganina taunatauna, au ati gevega-taunataunakuna. ");
INSERT INTO khz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Palagu gena kala rorirori ganina taunatauna ea, au Tamaku genai aagona, pe ati mapio gita-waiku. ");
INSERT INTO khz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","E Palagu na tanopara talimara pene agirorira ganina ea etanopara velena warau eagiroriato. ");
INSERT INTO khz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Gau vogo roe aririwana ana varami, na maparara ewagumona ati gelegele pio ripara e ati pio gapi-ragera. ");
INSERT INTO khz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Veaga Palaguna, ia taunatauna, pene vogomai aonai, ia na gomi pene vaimi, taunatauna pio ripaa. Kwalana ia ati matotauna gena tugamagi kilara pene kilagira. Aikina. Ia au gekuna pene kamonagira kilaramo pene kilagira. E roe nea vou pia wala gaura pene vega-ripa-kunemi. ");
INSERT INTO khz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ia na au pene vega-rageku, kwalana au gekuna pene gapira kilara gomi pene varami. ");
INSERT INTO khz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Au Tamaku gena gau maparara au geku. Vovetaina gaurai pakila, ‘Ia na au gekuna pene gapira kilara gomi pene varami.’” ");
INSERT INTO khz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Lagani ati rau aonai, gomi na au ati pio gitaku, e lagani ati rau mulinai, mapio gitaku. Kwalana au Tamaku genai aagona.” ");
INSERT INTO khz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ne gena melo reketa matotauria aoraimo gekilakilato, negetiwato, “Ia e rakagau ekilagiana, netina, ‘Lagani ati rau aonai au ati pio gitaku, e lanagani ati rau mulinai mapio gitaku,’ e ekilana, ‘Kwalana au Tamaku genai aagona?’” ");
INSERT INTO khz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Vovetaina gaurai gekilato, “Ia e rakagau ekilagiana, netina, ‘Lagani ati rau’ netina? Ita ati taripana ia na rakagau ekilagiana!” ");
INSERT INTO khz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu eripato, gena melo geria ririwa ia renagia negetiiwai, gaurai ia na evaikilarato, netiwato, “Gomi matotaumimo aonai au na rakagau pakilagia veineveinena gokalaana, ei? Au pakila, ‘Lagani ati rau aonai ati pio gitaku, e lagani ati rau mulinai mapio gitaku,’ napatiwa ganina gotavuana? ");
INSERT INTO khz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Taunatauna avaikilamina, gomi pio tagi e pio tagi-wanonowanono, na tanopara talimara pia verere. Gomi pio aovitiviti, na gemi aovitiviti verere ai pia ago. ");
INSERT INTO khz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Gare ta melo ene vega-walaa ulanana, evitivitina, kwalana gena gapi orana pekwara. Na melo e walana aonai, genai vovitiviti etugamagi-lekwalekwaana, kwalana melo ta tanoparai warau pevega-walaa vererena. ");
INSERT INTO khz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gomi maki vovetaina: Ewagumona goaovitivitina, na au na mapana gita-waimi, pe mapio verere. Talima taa na gomi gemi verere ati gelegele gemina pene gapi-vagia. ");
INSERT INTO khz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","E votoma gomi na au gau kwauta ati pio nogiku. Taunatauna avaikilamina, au araku ai rakagau pio nogira gaura maparara, au Tamaku na pene venimi. ");
INSERT INTO khz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pene vogomai ewagomona, gomi na au araku ai gau ta rogoti goro nogia. Au araku ai pio nogi, ne pio rawali; pe aomi verere na pia vonuvonu-rage.” ");
INSERT INTO khz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ekilara au na gomi gemi parapore ai akilagirana, na toma kapirai parapore ai ati pana vaikilami. Kapinai vou au Tamaku valina gemi pana kilagi-matagai-namanamaa. ");
INSERT INTO khz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Votoma pene kwara aonai, gomi au araku ai pio noginogi. A au ati akilana, au na gomi pakumi ai Tamaku pana nogia; ");
INSERT INTO khz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kwalana Tamaku matotauna na gomi eulamagimina. Gomi eulamagimina, kwalana gomi na au goulamagikuna, e govega-taunataunakuna, au Palagu genana avogomaito. ");
INSERT INTO khz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Au Tamaku lagana na etanoparai amarigoto. Ewagumona etanopara araokwaniana, Tamaku genai maawaikule-waina.” ");
INSERT INTO khz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Gena melo na gevaikilaato, negetiwato, “Ogitaana, ewagumona goi okila-matagai-rorirorina, ati oparaporena. ");
INSERT INTO khz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ewagumona ai garipa-rorirorina, goi gau maparara ripamu. Talima taa na ene renagimu netina verenagina maki, goi na oripa-kuneana. Gaura pakurai gavega-taunataunamuna, goi taunatauna Palagu genana ovogomaito.” ");
INSERT INTO khz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu na evega-gelerato, netiwato, “Ewagumona vou govega-taunataunakuna, ei? ");
INSERT INTO khz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Taunatauna, tomana evogomaina, warau pekawara, gomi pio raka-lovolovo, kwapurakwapura gemi ririwa rakarai pio raka, na au geregaku pio raokwani-guilagiku. Na au ati geregaku, kwalana Tamaku au lagaku ai. ");
INSERT INTO khz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Au aririwana, au geku ai pio kwalanakau, pe au geku ai maino pio gapia ulanana, au na ekila gomi pavarami. Etanoparai gotaluna aonai, vitiviti pio rawali. Na pio tiliga! Au na tanopara gena tiavu agunuato.” ");
INSERT INTO khz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu vovetaina ekila-gatuto mulinai, eali-rageto, kupa egitaato, ne ekilato, “Tamaku orana ea. Natumu maeka ralema iwavagina ono vega-matagaia, pe Natumu na goi maekamu ralemana iwavagina maki pene vega-matagaia. ");
INSERT INTO khz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kwalana goi na ia rorirori oveniato, taunilimalima maparara ia gena vegitatago kapulenai pia talu. Pe goi na ia oveniato talimara maparara maguli vanagivanagi pene venira. ");
INSERT INTO khz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Maguli vanagivanagi ea: Maguli vanagivanagi pia gapia talimara maparara pia ripa, Palagu taunataunamu goi geregamu kwanilova, e Iesu Keriso pia ripaa. Iesu Keriso goi na otuguato tanoparai. ");
INSERT INTO khz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Au na goi tanoparai pavega-ragemu. Goi na ovenikuto pana kalaa notiwato inaguluna warau pavega-gugulua. ");
INSERT INTO khz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tamaku, tanopara rogotina ere vetina e au maki goi goti roe voa aonai, au geku ai maeka ralema iwavagina emiawai. Ewagumona aririwana, vomaeka ralema iwavagina goi matotaumu wailamu ai geku ai ono vega-matagaia.” ");
INSERT INTO khz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tanopara magulina aona na ogapi-vagirato, ne ovenikuto talimara geriai goi avega-matagaimuto. Ira goi gemu taunilimalima, goi na au ovenikuto. Ira na goi gemu kila gekwalanaato. ");
INSERT INTO khz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ewagumona ira pege ripa, goi na ovenikuto gaura maparara goimo gemuna gevogomaito. ");
INSERT INTO khz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kwalana goi na ovenikuto kilara maparara avararato. Ira na vokila maparara gegapi-ragerato, geripa-rorirorito, au goi lagamu na avogomaito. E gevega-taunataunana, au goi na otugu-rigokuto. ");
INSERT INTO khz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Au ira geria arapalina. Au ati etanopara magulinai getaluna talimara geria arapalina. Na au ovenikuto talimara geria arapalina, kwalana ira goi gemu taunilimalima. ");
INSERT INTO khz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Au geku taunilimalima maparara goi gemu taunilimalima. E goi gemu taunilimalima maparara au geku taunilimalima. E ira geriana au araku gevega-rageana, kwalana au geku maeka ralema iwavagina gevega-matagaiana. ");
INSERT INTO khz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Au goi gemu ai awatina, etanoparai ati pana talu-awagi. Na ira tanoparai roe wapia talu. Tamaku Veagamu, goi na au ovenikuto talimara goi aramu tiavuna na pono gita-tagora. Pe ira maparara pia kwapuna, ita taura ruala vetaira. ");
INSERT INTO khz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Au tanoparai ira ria roe wagataluwai aonai, goi aramu tiavuna na ira agita-tagorawai. Goi na au ovenikuto talimara agitatago-namanamarato, pe ta ati elekwalekwato; pene lekwalekwa talimanamo, taunatauna elekwalekwato, Puka Veaga aonai getaloato kilana vega-taunataunana ulanana. ");
INSERT INTO khz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na ewagumona au goi gemu ai awatina. Au tanoparai roea aonai, ekilara pakilagira, au geku verere na ira aora pene vega-vonuvonu-ragera ulanana. ");
INSERT INTO khz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Goi gemu kila au na ira warau avenirato. Etanopara magulinai getaluna talimara na geao-rakavagirana, kwalana ira ewagumona ati etanopara talimara, au vetaiku, au ati etanopara talimaku. ");
INSERT INTO khz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Au ati etanopara na pono gapi-vagira rapalina akalaana. Na anogimuna, pono gita-tagora, pe Talima Rakavana, Satani, na ragai pene gapira natina. ");
INSERT INTO khz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ira ati etanopara talimara, au vetaiku, au ati etanopara talimaku. ");
INSERT INTO khz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Goi gemu kila-taunataunana na ono vega-veagara; goi gemu kila taunatauna. ");
INSERT INTO khz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Goi na tanopara magulinai getaluna talimara nuganugarai au otugu-togakuto gelegelenai, au na ira maki tanopara magulinai roe gemagulina talimara nuganugarai patugu-togara. ");
INSERT INTO khz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ira pakurai au matotauku avevega-veagana, pe ira maki pia veaga-taunatauna.” ");
INSERT INTO khz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Au ati ia gena melo geregaria geriamo arapalina. Aikina. Au ira na vali piave piaa genai, au pia vega-taunataunaku talimara maparara maki geria arapalina. ");
INSERT INTO khz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Pe ira maparara pia kwapuna, Tamaku, goi au aoku ai otaluna e au goi aomu ai ataluna gelegelena. Vovetainai au aririwana, ira maki pia kwapuna, e ita aorai pia talu, pe tanopara magulinai roe getaluna talimara pia ripa, au goi na otugu-rigokuto. ");
INSERT INTO khz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Goi na au maeka ralema iwavagina ovenikuto gauna ira avenirato, ira pia kwapuna ulanana, pe ita taura ruala takwapunana vetaina, ira maki pia kwapuna. ");
INSERT INTO khz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Au ira aorai, e goi au aoku ai, pe ira maki pia kwapuna vegata. Ne voanana tanopara magulinai roe getaluna talimara pia ripa, au goi na otugu-maikuto, e pia ripa maki, goi na ira oulamagirana au oulamagikuna vetaina. ");
INSERT INTO khz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tamaku, au geku ririwa kamuna, au ariginai pana talu, au ovenikuto talimara maki au ria, pe vonai paia talu, pe au maeka ralema iwavagina ovenikuto gauna pia gitaa. Vomaeka ralema iwavagina ovenikuto, kwalana au goi na tanopara rogotina oro kalaa aonai vegata oulamagikuto. ");
INSERT INTO khz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamaku o, goi kala rorirori Palagumu, tanopara magulinai getaluna talimara goi ati geripamuto. A au na goi aripamuto, e au geku melo ea pia ripa, au goi na oma tugu-rigokuto. ");
INSERT INTO khz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Goi aramu ira avega-riparato, e roea mapana kilagi-matagaia. Kwalana voanana au oulamagikuna ulamagina ira aorai pene mia, e au maki ira aorai pana talu.” ");
INSERT INTO khz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu na vorapali ekilagi-gatuato mulinai, gena melo ria gelakato. Geagoto, Kidron waina na gelaka-vanagito, pene ago kavatai. Vonai araga ta, gena melo ria voaraga aonai gelaka-togato. ");
INSERT INTO khz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iudas, Iesu elewaato talimana, maki vokapu ripana, kwalana Iesu magena melo ria vonai toma vogo getanu-kouwai. ");
INSERT INTO khz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Vovetaina gaurai Iudas na Roma vetali talimara e Rupu Veaga gitatagona talimara reketa evairato. VoRupu Veaga gitatagona talimara voo Rupu Veaga velera kamura e Parisea talimara na getugurato. Ne voaragai geagoto, makerera, malamepara, e mageria vetali rinagara. ");
INSERT INTO khz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu ripana kune, ia genai rakagau pia wala gaura maparara, gaurai eagoto geriai, ne erenagirato, netiwato, “Gomi rai gotavuana?” ");
INSERT INTO khz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ira gevega-geleto, negetiwato, “Iesu, Nasareta talimana.” Iesu na evaikilarato, netiwato, “Talimana au.” Iudas, Iesu elewaato talimana, maki ira ria vonai rugatago. ");
INSERT INTO khz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesu na evaikilarato, netiwato, “Talimana au,” netiwato aonai, ira maparara gekoleto, ne kwano ai geketo-talito. ");
INSERT INTO khz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iesu na maerenagi-wairato, netiwato, “Gomi rai gotavuana?” Ne ira gekilato, “Iesu, Nasareta Talimana.” ");
INSERT INTO khz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu evega-geleto, netiwato, “Au na pavaikilami, talimana au. Pene gomi aumo gotavukuna genai, etalima iotugura, ialaka.” ");
INSERT INTO khz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Vovetaina ekilato, kwalana ia gena kila tovotovonai ekilagiato kilana pene taunatauna ulanana, netiwato, “Au ovenikuto talimara taa vagi ati akala-lekwalekwaato.” ");
INSERT INTO khz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aonai Simona Petero gimanai vetali kativana ta. Vovetali kativana einu-vagiato, eavuato, ne Rupu Veaga velena kamuna gena vetugunagi talimana tegana aloripana kavana epati-vagiato. Vovetugunagi talimana arana Malkas. ");
INSERT INTO khz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ne Iesu na Petero evaikilaato, netiwato, “Goi na nevetali kativana ponao aonai ono ura togaa! Au Tamaku na peveniku vitiviti kaperina ati pana niua, ei?” ");
INSERT INTO khz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ne vetali talimara kuneagira talimana e Iuda talimara geria Rupu Veaga gitatagona talimara na Iesu gegapiato, ne geligoligoato, ");
INSERT INTO khz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ne Anas genai gevaiago-kuneato, kwalana Anas ia Kaiapa gena tegama. Kaiapa na Anas natuna vavinena egarawaato. Kaiapa ia Rupu Veaga velena kamuna volaganinai. ");
INSERT INTO khz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapa na Iuda talimara egavu-tinarato, netiwato, “Namana talima kwapunamo taunilimalima maparara pakurai pene kwarega.” ");
INSERT INTO khz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simona Petero e Iesu gena melo taa na Iesu gelaka-guiato. Rupu Veaga velena kamuna ripana ira, Iesu gena melo. Vovetaina gaurai ia maki Iesu ria gevega-lakatoga-kourato, Rupu Veaga velena kamuna gena numa kanana aonai Kota kapunai. ");
INSERT INTO khz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Na Petero kana vanagina mulinaimo erugato. Iesu gena melo, Rupu Veaga velena kamuna na eripaato melona, maewaikuleto, ne kana vanagina egita-tagoawai vavinena evevaikilaato, Petero evaitogaato. ");
INSERT INTO khz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ne kana vanagina egita-tagoato vavinena na Petero evaikilaato, netiwato, “Goi maki etalima gena melo ta, ei?” Petero evega-geleto, “Aikina, au aikina.” ");
INSERT INTO khz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Vokapu nakula na egapiato, gaurai vetugunagi talimara e Rupu Veaga gitatagona talimara na kalova ta gekalaato. Ne vokalova geruga-gegelagiato, etunurawai. Petero maki ira lagarai erugato etunuawai. ");
INSERT INTO khz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Voorai Rupu Veaga velena kamuna na Iesu erenagiato, Iesu gena melo e gena vevega-ripa everenagi-agirato. ");
INSERT INTO khz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu na evega-geleato, netiwato, “Au taunilimalima gutuma wailarai akila-matagaito. Au vanagivanagi Iuda talimara geria rupu ai e Rupu Veaga aorai avevega-ripawai, e Iuda talimara gelaka-koukouna kapurai, au ati akila-veavugato. ");
INSERT INTO khz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Rakagau gaurai au orenagikuna? Au gekamonagikuto talimara ono verenagira, ira ripara au na rakagau akilagirato.” ");
INSERT INTO khz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu vovetaina ekilato gaurai, Rupu Veaga gitatagona talimana ta ia laganai eruga-tagowai, ia na Iesu wailana evaleato. Ne Iesu evaikilaato, netiwato, “Goi e Rupu Veaga velena kamuna nevetaina ovaikilaana?” ");
INSERT INTO khz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu na evaga-geleato, netiwato, “Pene au na kila rakavana ta pakilagia genai, ono kilagia, arigi kila rakavana! Na pene au pakila-taunatauna, rakagau gaurai povaleku?” ");
INSERT INTO khz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ne Anas na Iesu maligoligona roe voa Rupu Veaga velena kamuna Kaiapa genai etugu-agoato. ");
INSERT INTO khz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simona Petero kalovai roe waetunuawai. Ne kalova laganai geruga-kouto talimara na gerenagiato, negetiwato, “Goi maki ia gena melo ta, ei?” Petero eveopa-tagoto, netiwato, “Aikina, au aikina.” ");
INSERT INTO khz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Rupu Veaga velena kamuna gena vetugunagi talimana ta Petero na tegana epati-vagiato talimana gena talima ta, ia evaikilaato, “Au atugamagina, goi maki ia goti voaraga aonai noopagitamu, pa?” ");
INSERT INTO khz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petero maeveopatago-waiato, atilovana kokoloku ekogoto. ");
INSERT INTO khz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ne Iuda talimara na Iesu Kaiapa lagana na gevaiagoato Roma geria kavana gena numa kamunai. Voo warau elagani-maamamaawai. Iuda talimara ati geririwato, Roma geria kavana gena numai pia laka-toga, kwalana gekilato, ira pia vealeva-tago. Ira geria ririwa Pasova velekwana pia gania vegata. ");
INSERT INTO khz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gaurai Pilato elaka-piatito ira geriai, ne evaikilarato, “Etalima pogo vaimaia gena kepi kwalana rakagau?” ");
INSERT INTO khz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ira na gevega-geleato, negetiwato, “Pere ia kala rakavara ati pere kala genai, goi gemu ai ia ati pagara vogomai-agia.” ");
INSERT INTO khz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ne Pilato na evaikilarato, netiwato, “Iogapia, ioago-agia, ne gemi rova ekilana gelegelenai iove agiroria.” Vovetaina gaurai Iuda talimara na Pilato gevaikilaato, negetiwato, “Ai gema rovana rorirori ati evenimaina, talima ta paia vagi-kwaregaa.” ");
INSERT INTO khz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Eia ewalato ganina, Iesu rakavetaina pene kwarega ekilagiato kilana pene taunatauna ulanana. ");
INSERT INTO khz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Gaurana Pilato numa kamuna aonai maelakatoga-waito, ne Iesu ekeaato, erenagiato, “Goi Iuda talimara geria king pa?” ");
INSERT INTO khz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu na evega-geleato, netiwato, “Goi nevetaina au ovaikilakuna matotaumu aomu tuga okilana pa talima reketa na pege vaikilamu kilana?” ");
INSERT INTO khz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato evega-geleto, netiwato, “Pe, au Iuda talimaku ei? Goi gemu tanopara talimara na e Rupu Veaga velera na pege vaimaimu, au pegema veniku. Goi raka kepi okalaato?” ");
INSERT INTO khz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu na evega-geleato, netiwato, “Au geku Basileia ati etanopara gena. Pere au geku Basileia e tanopara aonai pere mia e pere ruga genai, au geku vetugunagi talimara pegere kuliiti, Iuda talimara ria pegere galama, e talima ta maki ati gelegele, Iuda talimara gimarai pere taoku. Na au geku Basileia ati etanopara aonai emiana.” ");
INSERT INTO khz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilato na vovetaina gaurai Iesu erenagiato, netiwato, “Goi vele pa?” Iesu evega-geleto, netiwato, “Goi okilana au vele notina ne taunatauna okilana. Au tanoparai ama walato ganina taunatauna, taunatauna pana vega-matagaia ulanana. Taunataunai gemagulina talimara maparara na au karoku gekamonagiana.” ");
INSERT INTO khz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato ekilato, “Taunatauna rakagau?” Vovetaina ekilato mulinai, elaka-piatito Iuda talimara geriai, ne evaikilarato, netiwato, “Au na etalima genai kepi ta ati parawalia. ");
INSERT INTO khz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Na gomi gemi kala ta evetaina, Pasova velekwana tomanai, tipura talimana ta pana luga-vagia. Gaurana gomi goririwana au na Iuda talimami gemi vele ana tugu-atia pa?” ");
INSERT INTO khz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Na ira maparara gelailaito, negetiwato, “Aikina! Ia ragaina! Na Barabas.” A Barabas elemawai e evagivagiwai gaurai gevega-tipuraato. ");
INSERT INTO khz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Vovetaina gaurai Pilato na Iesu egapiato, vetali talimara pa soldia evenirato, ne gekwariato. ");
INSERT INTO khz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","E soldia na walokoko makalana gauna gevatu-rokurokuato, kraon vetaina, ne Iesu repanai gekou-kauato. E rapuga mogana kalovakalovana na gevega-rapugaato. ");
INSERT INTO khz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ne wailanai gelaka-kavito, ne gevaikilaato, negetiwato, “Iuda talimara geria King, toma namana!” Ne wailana gevaleato. ");
INSERT INTO khz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato maelaka-piatito Iuda talimara geriai, ne evaikilarato, netiwato, “Iogitaa, au na ia gomi wailami ai ama vaiatiana ganina ana vega-ripami, au na ia genai kepi ta ati parawalia.” ");
INSERT INTO khz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ne Iesu ema laka-piatito, repanai kraon koukau, walokoko makalana gevatuato gauna, e rapuga kalovakalovana maki roe waerogagi-tagoawai. Ne Pilato na Iuda talimara evaikilarato, netiwato, “Iogitaa, talimana ea.” ");
INSERT INTO khz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","VoRupu Veaga velera kamura mageria vetugunagi taura na gegitaato aonai, geparalato, negetiwato, “Iosatauroa! Iosatauroa!” Ne Pilato na evaikilarato, netiwato, “Gomi matotaumi na ioago-agia, e iove satauroa, kwalana au na ia genai kepi ta ati parawalia.” ");
INSERT INTO khz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Iuda talimara na gevega-geleato, negetiwato, “Ai magema rova, ai gema rova ekilana, ia pene kwarega vegata, kwalana ia matotauna Palagu Natunai pevekilagi.” ");
INSERT INTO khz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato na vokila ekamonagiato aonai, ekali-rakavato. ");
INSERT INTO khz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ne numa kamunai maelaka-togato, ne Iesu evaikilaato, netiwato, “Goi ravanana ovogomaito?” Na Iesu na ati evega-geleato. ");
INSERT INTO khz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ne Pilato na evaikilaato, netiwato, “Goi ati oririwana au pono vega-geleku ei? Goi ati ripamu au mageku tiavu goi pana satauromu e mageku tiavu goi pana luga-vagimu?” ");
INSERT INTO khz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu evega-geleto, netiwato, “Pere Palagu na kupa na goi tiavu ati pere venimu genai, ewagumona au goi gemu tiavu kapulenai ati para ruga. Gaura pakurai, au egapikuto goi gimamu ai etaokuto talimana, gena rakava kamu iwavagi.” ");
INSERT INTO khz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilato na vokila ekamonagiato, ne raupara etavuwai, gena ririwa Iesu pene luga-vagia. Na Iuda talimara roe wagelailaiwai, negetiiwai, “Pene goi na etalima pono luga-vagia genai, goi ati Kaisara gatana. Rai talima matotauna evekilagina vele netina, ia na Kaisara, Roma geria vele, ekilagi-piatogaana.” ");
INSERT INTO khz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato na vokila ekamonagiato, ne Iesu ema vaiatiato, ne eagoto, Kota ekamonagiana talimana gena tanukau ai evetanukauto. Vokapu “Vatu Kalakauna” negetiiwai. E Heberu karonai “Gabata.” ");
INSERT INTO khz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Votoma Pasova velekwana ulanana kalamaavu tomana, ora gauna 12 koloko warau egapiato. Ne Pilato na Iuda talimara evaikilarato, netiwato, “Iogitaa, gemi vele ea!” ");
INSERT INTO khz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Na ira geinalato, negetiwato, “Iokaliagia! Iogapi-pakaa! Iove satauroa!” Pilato na maerenagirato, netiwato, “Gemi vele ana satauroa, ei?” Rupu Veaga velera kamura gevega-geleto, negetiwato, “Kaisara gereganamo ai gema vele, mavele poluna ta aikina.” ");
INSERT INTO khz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Gaura pakurai Pilato na Iesu ira gimarai etao-kauato pia satauroa ulanana. Ne vetali talimara na Iesu gegapiato, gevaiagoato. ");
INSERT INTO khz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iesu gena satauro evua-itiato, elaka-piatito, eagoto kapu arana “Repa Gavana Kapunai” Heberu karonai vokapu arana “Gologota” ");
INSERT INTO khz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Vokapu ai ira na Iesu gesatauroato talima ruala ria; ta kavatai, ta kavatai, Iesu nuganugai. ");
INSERT INTO khz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato na kila reketa mara revareva kwatunai etalorato, ne satauro kukunai genaero-kauato. Etalorato kilara ea, “IESU, NASARETA TALIMANA, IUDA TALIMARA GERIA VELE.” ");
INSERT INTO khz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Vokila Heberu karonai, e Roma karonai, e Grik karonai etalorato. Iesu gesatauroato kapuna vanuga kamuna laganai, gaurai Iuda talimara gutuma na vokila geagiato. ");
INSERT INTO khz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ne Rupu Veaga velera kamura na Pilato gevaikiaato, negetiwato, “‘Iuda talimara geria vele’ ragai ono taloa, na evetaina ono taloa, ‘Ia ekilato, au Iuda talimara geria Vele.’” ");
INSERT INTO khz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato na evega-gelerato, netiwato, “Rakagau au na pataloa kilana pataloa vegata.” ");
INSERT INTO khz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Vetali talimara na Iesu gesatauroato mulinai, gena rapuga gegapirato, kava vativati gekalarato, ne vetali talimara na geria kwapurakwapura gegapito, vega-kapule rapugana geraokwaniato. Kwalana vega-kapule rapugana ia rapuga kwapuna namo getuliato. A ia ati rapuga kinikinira getuli-koukourato vou gekalaato rapugana. ");
INSERT INTO khz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Vovetaina gaurai matotauria nuganugarai gekila-koukouto, negetiwato, “Ragai ita ralea, na iru ulana ta ita kalaa, pene iru talimana na vorapuga pene gapia.” Ekala gekalaato ganina taunatauna, Puka Veaga aonai getaloato kilara pia taunatauna ularana, evetaina ekilana, “Au geku rapuga ira vekarawarai gewarerato, e au geku rapuga ularana iru ulana ta gekalaato.” Vovetaina gaurai vetali talimara na vokala gekalarato. ");
INSERT INTO khz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu gena satauro kwalanai gare vativati geruga-tagowai: Iesu tinana, e Iesu tinana vavine kavana, e Maria, Klopa garawana, e Maria, Magadala garena. ");
INSERT INTO khz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu na tinana e eulamagiawai melona vonai rugatago egitarato, ne tinana evaikilaato, netiwato, “Natumu melona nea.” ");
INSERT INTO khz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","E gena melo evaikilaato, netiwato, “Tinamu nea.” Votoma na vegata, Iesu gena melo na Iesu tinana gena numai evaiagoato, ne egita-tagoawai. ");
INSERT INTO khz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Voia mulinai Iesu eripato, gena inagulu maparara warau pevega-aikira. E Puka Veaga aonai getaloato kilana pene taunatauna pakurai netiwato, “Au nanuna pekalaku.” ");
INSERT INTO khz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Vine nanuna mamakina makwagutu na vonai miatago. Nanu romagina gauna vine nanuna mamakina aonai getuguraiato. Vine nanuna mamakina na evonuto, ne isopo ragana kwalunai gekwanu-kauato, ne getugu-rageato, Iesu pipiganai getao-kauato. ");
INSERT INTO khz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesu na vovine nanuna mamakina eniuato, ne ekilato, “Peaiki.” Repana egelo-rigoto, ne tauniparana na ia palaguna elaka-vagito, ekwaregato. ");
INSERT INTO khz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Votoma kala-maavu tomana, kwalana pene lagania voo Tapati veagana kamuna ta Pasova velekwana tomara aorai. Gaura pakurai Iuda talimara ati geririwato, voTapati veagana kamunai kwarega talimara tauniparara satauro kukunai pia mia-tago. Vovetaina gaurai Pilato genogiato, Iesu e votalima ruala gagera pia kwari korura, ne satauro kukura na pia gapi-rigora. ");
INSERT INTO khz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Gaura pakurai vetali talimara gevogomaito, ne gesatauro-kuneato talimana gagena gekwari-koruato, talima vega-rualana Iesu goti gesatauroato maki vovetaina gekalaato. ");
INSERT INTO khz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na Iesu genai gevogomaito aonai, Iesu gegitaato warau ekwaregato, gaurai gagena ati gekwari-koruato. ");
INSERT INTO khz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","A vetali talimana taa namo Iesu penipenina kolovana ekwanuato. Ne veganamo ekwanuato kapuna na rala e nanu gevepopo-atito. ");
INSERT INTO khz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Eia egitaato talimana na evaravaragiato, e ia gena varavara taunatauna. Ia ripana, ia ekila-taunataunana, e ia na ekilagi-matagaiana ganina, gomi na maki pio vega-taunataunaa ulanana. ");
INSERT INTO khz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ekala gekalarato kwalana, Puka Veaga aonai getalorato kilara pia taunatauna, netina, “Ia tiligana ta vagi ati pia gaukorua.” ");
INSERT INTO khz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Puka Veaga aonai etaloato kilana ta evetaina ekilana, “Penipenina gekwanuato talimana genai mapia poe-rage.” ");
INSERT INTO khz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Eia mulinai Iosepa, Arimatea talimana, na Pilato enogiato, Iesu tauniparana pene gapia ulanana. Pilato na rorirori eveniato, ne eagoto, Iesu tauniparana eve gapiato. Iosepa Iesu gena melo taa, na Iuda talimara kalira na ekaliwai, gaurai elaka-veavugawai, gena kamonagi ati evega-matagaiawai. ");
INSERT INTO khz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemo, tovotovonai Iesu genai pogi aonai eagoto talimana, maki eagoto. Ia na muro e aloe gekao-vevilirato mulamulana kilogram gagala toitoi (30) maki egapi-kauato. (Voveiru mulamulana ponana nama iwavagi). ");
INSERT INTO khz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ne Iesu tauniparana gegapiato, tauria ruala na rapuga kulokulo namana mamulamulana na gekumuato, Iuda tenera na kwarega talimara gekalarawai gelegelena. ");
INSERT INTO khz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Iesu gesatauroato kapuna maaragana. Voaraga aonai kala kovogana ta vatu na gekoloato, vokala kovogana rogoti gere vetao-agia. ");
INSERT INTO khz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Votoma voo Iuda talimara geria kala maavu tomana, e vokala kovogana maki kavinagi, gaurai Iesu tauniparana gegapiato, vonai geve tao-togaato. ");
INSERT INTO khz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tapati eaikito mulinai, epetoma toma tovotovonai, amoamo elagani maamamaawai aonai, Maria, Magadala garena, kalai eagoto. Ne epoe-agoto, kala vanagina getao-gavuato vatuna gegapi-gerevagiato pakai miatago egitaato. ");
INSERT INTO khz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ne eraka-waikuleto, Simona Petero e Iesu gena melo ta, Iesu na eulamagiawai melona, geriai, ne evaikilarato, netiwato, “Velekou kala na pege gapi-pakaa, ita ati ripara ariginai pege taoa.” ");
INSERT INTO khz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ne Petero e Iesu na vomelo gerakatito, kalai geagoto. ");
INSERT INTO khz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Taura ruala geraka-kouto, na Iesu na vomelo na Petero eraka-kwaniato, kala vatunai eve kwara-kuneto. ");
INSERT INTO khz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Erupu-talito, ne erune-togato, Iesu gekumuato rapugana kulokulonamo miatago egitaato. Ia tipo erune-togato, na ati elaka-togato. ");
INSERT INTO khz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Aonai Simona Petero eraka-kwarato, ne elaka-togato kala kovogana aonai, Iesu gekumuato rapugana kulokulona miatago egitaato, ");
INSERT INTO khz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","e Iesu repana maparana gekumuato mukona egitaato, Iesu tauniparana gekumuato rapugana kulokulona goti ati miakou. Na vomuko ikuiku, pe gerevagi ai. ");
INSERT INTO khz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ne Iesu na vomelo evekwara-kuneto talimana, maki elaka-togato. Vogaura egitarato, ne evega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kwalana ira na Puka Veaga aonai evetaloto kilana rogoti gere ripa-taunataunaa, kilana ea: Iesu kwaregana mapene kuliiti-wai. ");
INSERT INTO khz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Na Iesu gena melo ruala magewaikule-waito geria numai. ");
INSERT INTO khz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na Maria kala kovogana mulinai etagiwai. Etagiwai aonai erupu-talito, ne erune-togato kala kovoganai. ");
INSERT INTO khz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Aonai aneru ruala egitarato, rapuga kulokulo gerogagito, Iesu gevega-maokoato kapunai tanutago. Ta repana kavanai, ta gagena kavanai. ");
INSERT INTO khz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ne voaneru ruala na gevaikilaato, negetiwato, “Gare, goi rakagau gaurai otagina?” Maria na evega-gelerato, netiwato, “Kwalana au geku Velekou pege gapi-pakaa, au ati ripaku ariginai pegeve taoa.” ");
INSERT INTO khz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Evetaina ekila-gatuto mulinai, epoe-gegelagito, Iesu vonai rugatago egitaato. Na Maria ati eripa-rorirorito, voo Iesu eruga-tagowai. ");
INSERT INTO khz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iesu na evaikilaato, netiwato, “Gare, goi rakagau gaurai otagina? Goi rai otavuana?” Maria etugamagito, Iesu voaragai einaguluna talimana, gaurai evaikilaato, netiwato, “Velekou, pene goi na pogapi-pakaa genai, ariginai potaoa kapuna ono varaku, pe ana gapia.” ");
INSERT INTO khz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu na evaikilaato, netiwato, “Maria!” Maria eruga-kuleto, ne evaikilaato, Heberu karonai, netiwato, “Rabboni!” Ekila ganina, “Vevega-ripa Tauna.” ");
INSERT INTO khz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu na evaikilaato, netiwato, “Au ragai ono gapiku, kwalana au Tamaku genai rogoti araverage. Na ono ago au walakavaku geriai, pono vaikilara, ‘Au Tamaku e gomi Tamami, e au geku Palagu e gomi gemi Palagu genai averagena.’” ");
INSERT INTO khz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria, Magadala garena, Iesu gena melo geriai eagoto, ne evaikilarato, netiwato, “Au na Velekou pagitaa.” Ne Velekou na evaikilaato kilara maparara ira evararato. ");
INSERT INTO khz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","VoSandei poginai, voo toma tovotovona epetoma kwapuna aonai, Iesu gena melo numa gautai getanu-kouto. Ira Iuda talimara kalira na, gaurai geria numa vanagina gekana-gavuato. Iesu evogomaito, ira nuganugarai eruga-talito, ne evaikilarato, “Ragai iokali, aomi ai maino ene mia.” ");
INSERT INTO khz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Vovetaina ekila-gatuto mulinai, gimana genaerorato e penipenina gekwanuato kapura evega-gitarato. Velekou gegitaato aonai, geverere-rakavato. ");
INSERT INTO khz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ne Iesu na ira maevaikilarato, “Ragai iokali, aomi ai maino ene mia! Tamaku na au etugukuto vetaina, au na maki gomi atugumina.” ");
INSERT INTO khz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Vovetaina evaikila-gaturato mulinai, agilana evili-kauato geriai, ne evaikilarato, netiwato, “Veaga Palaguna iogapia. ");
INSERT INTO khz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Gomi na gena rakava pio tugamagi-piatogaa talimana, gena rakava Palagu na maki pene tugamagi-piatogaa. A gena rakava ati pio tugamagi-piatogaa talimana, gena rakava Palagu na maki ati pene tugamagi-piatogaa.” ");
INSERT INTO khz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na Tomas, Iesu gena melo geriai eagoto tomanai ia aikina. Tomas arana ta Didimas pa Kapa, ia maki Iesu gena melo ta vomelo gagalana ruala aonai. ");
INSERT INTO khz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Vovetaina gaurai Iesu gena melo na gevaraato, negetiwato, “Velekou ai na paga gitaa.” Na Tomas ekilato, “Au ia gimana genaerorato kapura pana gitara, e ririka naero gelaka-togato kapura na pana tugu-togaa, e penipenina gekwanuato, kapunana ririku pana tugu-togaa vou, pana vega-taunataunaa.” ");
INSERT INTO khz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Toma taula vativati (8) geaikito mulirai, Iesu gena melo numa aonai, e votoma Tomas maki ira ria. Vonuma vanagina kanagavu, na Iesu evogomaito, ira nuganugarai eruga-talito, ne ekilato. “Ragai iokali, aomi ai maino pene mia.” ");
INSERT INTO khz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ne Tomas evaikilaato, netiwato, “Tomas, gimaku ono gitara, ririmu enaero kapurai onoma goto-togaa. E gimamu ono tugu-maia, pe ririmu au penipeniku gekwanuato kapunai onoma goto-togaa. Gemu aovoaovo ono vega-aikia, e ono vega-taunataunaku.” ");
INSERT INTO khz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ne Tomas na Iesu evega-gegelekato, netiwato, “Au geku Velekou e au geku Palagu.” ");
INSERT INTO khz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu na evaikilaato, netiwato, “Tomas, goi na ovega-taunataunakuna, kwalana pogitaku gaurai. A ati gegitakuna, na gevega-taunataunakuna talimara pia verere.” ");
INSERT INTO khz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu na vegailia irau vagira vogo gena melo wailarai ekalarato. Na voira e pukai ati atalorato. ");
INSERT INTO khz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","A eira atalorato kwalana, gomi na Iesu pio vega-taunataunaa, ia taunatauna Keriso, Palagu Natuna. Pene gomi na ia pio vega-taunataunaa genai, ia aranai maguli vanagivanagi pio vaia. ");
INSERT INTO khz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Voia mulinai Tiberia kovuna pipinai Iesu gena melo geriai evevega-matagaito. Vonai evetaina evevega-matagaito: ");
INSERT INTO khz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simona Petero; Tomas, arana ta Didimas pa Kapa; Natanaela, Kana vanugana talimana, Kana Galileia tanonai; Tepetaio natuna ruala; e Iesu gena melo ruala; maparara vonai getanu-kouwai. ");
INSERT INTO khz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ne Simona Petero na evaikilarato, netiwato, “Au kovu ai vetavu aagona.” Reketa, gekilato, “Ai maki goi ria tawatina.” Ne taura taulatoi kwapuna gelaka-piatito, geagoto, gati ai geveragekauto, ne geve vetavuto. Na vopogi maparana aonai magani ta vagi ati gerawaliato. ");
INSERT INTO khz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Amoamo valiguna Iesu kovu taitarinai eruga-tagowai; na gena melo ati geripa-rorirorito voo Iesu eruga-tagowai. ");
INSERT INTO khz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne Iesu na evaikilarato, netiwato, “Natuku, gomi gemi ai magani keita nea pa?” Ira na gevega-geleato, negetiwato, “Aikina.” ");
INSERT INTO khz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ne Iesu na evaikilarato, netiwato, “Leke gati ripana kavana na iopia-rigoa, nenai magani taarana pio rawalira.” Leke gepia-rigoato, ne maia goli-rage-waia negetiwato aonai gerolo-rage-kavaato metau panipani, kwalana magani vogo galagala vavagi geleke-gavurato gaurai. ");
INSERT INTO khz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iesu na eulamagiawai melona. E melo na Petero evaikilaato, netiwato, “Goi voma Velekou.” Simona Petero na vokila ekamonagiato, “Voma Velekou.” Veganamo gena rapuga eraka-rogagiato, ne kovu ai epavuraito. Vorapuga, einaguluwai gaurai egaivagiato. ");
INSERT INTO khz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na Iesu gena melo reketa gati na vou geleva-agoto. Voleke mamaganina maki gerolo-kauato. Kwalana ira na leke gepia-rigoato kapuna e taitari vepakara ati rau, mita tinavuna (100) vetaina. ");
INSERT INTO khz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kone ai gevetoga-rigoto aonai, gepoe-agoto kalova veagala gegitaato, e magani kalovai taokau gegitarato, e pereti reketa maki vonai miatago. ");
INSERT INTO khz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu na evaikilarato, netiwato, “Gomi na leke ai pogo gapira maganira reketa iovuamaira.” ");
INSERT INTO khz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simona Petero gati ai eragekauto, ne leke kone ai erolo-rageato. Voleke magani kamura na evonuto, vomagani kamura maparara tinavu kwapuna gagala imaima e toitoi (153), vogo galagala vavagi, na leke ati everaleto. ");
INSERT INTO khz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu na evaikilarato, netiwato, “Iovogomai, iomai-ganigani.” Iesu gena melo taa na evetaina ati erenagiato, “Goi rai?” Kwalana ira ripara, voo Velekou. ");
INSERT INTO khz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu evogomaito, pereti egapiato, ne evenirato, e magani maki vovetaina ekalarato. ");
INSERT INTO khz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","E vevega-matagai vega-toitoina gena melo geriai, Palagu na kwarega na evega-kuliiti-waiato mulinai. ");
INSERT INTO khz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Geganigani-gatuto mulinai, Iesu na Petero evaikilaato, netiwato, “Simona, Ioane natuna, goi na au oulamagikuna ulamagina na eira geria ulamagi au geku ai getaoana gauna eiwaana, pa?” Petero ekilato, “Pa Velekou, goi ripamu, au na goi aulamagimuna.” Iesu na evaikilaato, netiwato, “Au geku mamoe natura pono gupura.” ");
INSERT INTO khz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iesu na maerenagi-waiato, netiwato, “Simona, Ioane natuna, au oulamagikuna, pa?” Petero evega-geleto, netiwato, “Pa Velekou, goi ripamu, au na goi aulamagimuna.” Iesu ekilato, “Au geku mamoe pono gitatago-namanamara.” ");
INSERT INTO khz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iesu na Petero vega-toitoina maerenagiato; netiwato, “Simona, Ioane natuna, goi na au oulamagikuna, pa?” Petero aona emetauto, kwalana Iesu na vega-toitoi erenagiato, “Goi au oulamagikuna, pa?” Petero ekilato, “Velekou, goi gaura maparara ripamu, e goi ripamu, au na goi aulamagimuna.” Iesu ekilato, “Au geku mamoe pono gupura. ");
INSERT INTO khz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Avaikila-taunataunamuna, goi malaga valigumu ai, matotaumu na pae kopina kapamu ai okala-kauawai, ne oririwarawai kapurai oagowai. Na goi pono velepara laganinai, gimamu pono tugu-gagavaa ne talima taa na pene kwatua, ne pene vaimu, ati oririwaana kapunai pene vaiagomu.” ");
INSERT INTO khz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu na ekila ekilagiato, Petero pene kwarega kolemana e gena kwarega na Palagu raka pene vega-rage-kamutiwaa, ekilagi-atiato. Ne Petero evaikilaato, netiwato, “Au muliku ai onoma laka.” ");
INSERT INTO khz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petero eruga-kuleto, Iesu na eulamagiawai melona egitaato, mulira na eagowai. Emelo, Iesu ria geganigani-kouwai lavinai Iesu genai egegepekauto, ne erenagiato netiwato, “Velekou, goi pene lewamu talimana rai?” ");
INSERT INTO khz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petero na vomelo (pa Ioana) egitaato, ne Iesu evaikilaato, netiwato, “Na Velekou, ia kolemana rakavetaina?” ");
INSERT INTO khz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu na evega-geleato, netiwato, “Pene au pana ririwa, ia roe wapene maguli pene ago, au pana waikule-wai, voia rakagau goi gemu ai? Au muliku ai ono mai-laka.” ");
INSERT INTO khz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ekila pakunai, walakava kamonagi aonai nuganugarai vali erakawai, valina, “Iesu na emelo e ati pene kwarega.” Na Iesu ati ekilato, vomelo ati pene kwarega. Iesu tipo evetaina ekilato, “Pene au pana ririwa, ia pene maguli pene ago, au pana waikule-wai, goi gemu ai voia rakagau?” ");
INSERT INTO khz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Iesu na vomelo gauna ea, ekila evaravaragirana e etalorana. Ita ripara, ia gena varavara kilara e taunatauna. ");
INSERT INTO khz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu na gau vovogo ekalarato. Pere maparara pegere talora genai, au atugamagina, etanopara maparana pere kei, ati vagi pere gelegele, vopuka maparara pegere tao-koukoura genai. ");
INSERT INTO khz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilo, goi atalo-venimuna. Geku talotalo tovotovona aonai, Iesu gena inagulu e gena vevega-ripa kilara maparara atalo-matagairato, gena inagulu etinaato vegata, ");
INSERT INTO khz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","eagoto pene ago, Palagu na kupai evegapi-rageato. Rogotina ere gapi-ragea aonai, Veaga Palaguna genana evirigirato apostolora evega-riparato. ");
INSERT INTO khz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Gena vitiviti e kwarega mulinai ia eapostolo geriai evevega-matagaito e kolema taunataunara vogo vavagirai ia matotauna evevega-taunataunato ia magulina etaluna. Ia toma gagala vativati (40) aonai apostolo geriai raupara vogovagi ai ematagaiwai, gegitaawai, e Palagu gena Basileia, (gena vegitatago tiavuna evega-rugaana ea), valina geria ekilagiawai. ");
INSERT INTO khz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","E Iesu ria gelaka-koukouto aonai, Iesu na evaikilarato, netiwato, “Ierusalema ragai pio raokwania, na au na avaramito warewarena pio aloa vou, voo au Tamaku na ekilagi-gavuato warewarena. ");
INSERT INTO khz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kwalana Ioane taunatauna nanu na evebapatisowai, na gomi etoma viravira pia aiki mulinai Veaga Palaguna na pene bapatisomi.” ");
INSERT INTO khz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apostolo Iesu ria getanu-kouto aonai, Iesu gerenagiato, negetiwato, “Velekou, goi na irau elagani ai Isaraela talimamai, Roma geria vegitatago na pono vega-magulimai, ne Isaraela gema vegitatago pa basileia pono veni-waimai pa?” ");
INSERT INTO khz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu evega-geleto, netiwato, “Neia ne au Tamaku geregana gena tiavu ai tomara e laganira etaorato, gomi na ati pio ripara. ");
INSERT INTO khz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Na gomi Veaga Palaguna gomi atami ai pene mairigo, tiavu pio gapia, ne au kilagi-matagaiku talimami ai pio ago, Ierusalemai, Iudeai e Samaria kapura mapararai, pene ago tanopara kapura mapararai.” ");
INSERT INTO khz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ekila-gatuto mulinai, matara ganima-legirai Palagu na kupai egapi-rageato. Gegita-rogorogoato pene ago, iloa na ekou-gavuato, ne ati magegitaato. ");
INSERT INTO khz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Apostolo na Iesu kupai everagewai roe wagegitagita-rageawai aonai, talima ruala rapuga kulokulora na geverapugato, veganamo ira lagarai gema ruga-talito. ");
INSERT INTO khz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ne gekilato, “Galileia talimami, rakagau gaurai nenai pogo ruga-kupa gogita-rogorogoana? EIesu, gomi gemi na kupai pegapi-ragea talimana, mapene waikule-wai. Ia kupai peverage pogo gitaa vetaina, mapene marigo.” ");
INSERT INTO khz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ne apostolo Olive Golona na Ierusalemai gewaikuleto. Vokapu ruala vepakara rauna kilomita kwapuna vetaina. ");
INSERT INTO khz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ierusalemai gekwarato, ne getaluwai numana atana kovoganai gerageto. Vokovogai apostolo getanu-kouto, araria Petero; Ioane; Teimiti e Anduru; Filipo e Tomas; Batolomio; Mataio; Teimiti Alfia; Simona, Selote tauna; e Iudas, Iakobo natuna. ");
INSERT INTO khz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ira maparara maaora kwapunamo ai gerapali-koukouwai, gare reketa maki e Maria, Iesu tinana, e Iesu walakavana. ");
INSERT INTO khz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Votomara aorai Iesu gevega-taunataunaawai talimara maparara tinavuna e gagala ruala (120) getanu-kouwai. Ira nuganugara na Petero erugaitito, ne ekilato. ");
INSERT INTO khz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Walakavaku maparami, talotalo veagana pema taunatauna, Veaga Palaguna Davida muruna na erapa ekilato, Iudas na, Iesu gapitalina talimara pene vaiagora kilana. ");
INSERT INTO khz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iudas ai taukavamai ta, e ia maki apostolo inaguluna talimana, ai vetaimai.” ");
INSERT INTO khz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Gena kala rakava voina monina na tano ta evoiato. Vonai ia eketoto, ne ekwaregato, tinagena evua-pouato, ne evelaku-atito. ");
INSERT INTO khz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ierusalema talimara maparara na valina gekamonagiato, ne votano arana gekilagiato geria karo ai “Akeledama” ganina “Rala Tanona.” ");
INSERT INTO khz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kwalana Salamo pukanai warauna getaloato, netina, “‘Gena numa pene kalovo, talima ta ati pene talu.’ Makila ta Salamo aonai netina, ‘Gena vegitatago inaguluna maki taa na pene gapia.’ ");
INSERT INTO khz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Gaura pakurai namana tau ta ita virigia. Votalima ita ria vanagivanagi talakavo-koukouwai, Iesu Velekou ita nuganugarai talaka-togawai e talakatiwai aonai, ");
INSERT INTO khz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","e Ioane na talima ebapatisorato laganina na, pene vogomai Iesu ai gemana kupai egapi-rageato tomana talimana ta. Kwalana ia maki ai ria Iesu gena kuliitiwai pene kilagi-matagaia.” ");
INSERT INTO khz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Gaura pakurai ira na talima ruala gegapirato, Iosepa, arana Barasaba negetiiwai, arana ta maki Iusto; e Matias. ");
INSERT INTO khz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ne gerapalito, negetiwato, “Velekou o, taunilimalima maparara aora goi na oriparana, gaurai ono vega-gitamai, rai goi na pogapi-itia, ");
INSERT INTO khz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","apostolo inaguluna pene kalaa Iudas kapunai; a Iudas eagoto gena kapu taunataunanai.” ");
INSERT INTO khz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Gaurai vatu ulana gekalaato aonai, vatu Matias aranai eketoto, ne Matias apostolo gagalana kwapuna (11) ria geagi-kauato. ");
INSERT INTO khz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentekoste tomanai, Iesu gevega-taunataunaawai talimara maparara kapu kwapunaimo gekoukouto. Pentekoste ganina gagala imaima (50), Pasova velekwana tomana na pene vogomai etoma. ");
INSERT INTO khz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ne atilovana noowane agi kamuna ta kuluna kupa na emarigoto, getanu-kouto numana aona maparana evega-vonuato. ");
INSERT INTO khz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ne noowane kalova maera vetaira gemarigowai gegitarato. Vokalova maera gemarigoto, ira kwapurakwapura repara kukurai gemoleto. ");
INSERT INTO khz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne ira maparara Veaga Palaguna na evega-vonurato, ne karo irauirau ai gekilato, Veaga Palaguna na evenirato gelegelenai. ");
INSERT INTO khz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Votomanai Iuda talimara, Palagu kalina na gekaliwai talimara, tanopara kapura maparara na gevogomaito, Ierusalemai getaluwai. ");
INSERT INTO khz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Vokulu gekamonagiato aonai, taunilimalima gutuma gegalu-kavito. Nugara geparato, kwalana ira kwapurakwapura na Iesu gevega-taunataunaawai talimara gekamonagirato geraka-kouto talimara geria karo ai gekilawai. ");
INSERT INTO khz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ira gevevega-kali-rakavato e geaovoaovoto, negetiwato, “E gekilakilana talimara e Galileia talimara, ei? ");
INSERT INTO khz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Arigi rauparai ita kwapurakwapura gera karo ai gekilana takamonagirana? ");
INSERT INTO khz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ita reketana Patia talimara, reketa Media talimara e Elam talimara. Reketana Mesopotamia, Iudea e Kapadokia na, reketana Pontas na e Asia na, ");
INSERT INTO khz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frikia e Pamfilia na, Aikupito e Kureni lagana Libia tanora na, e mareketa Roma na tavogomaito, ");
INSERT INTO khz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iuda talimara, e ati Iuda talimara Iuda gera aliruputali gegapi-rageato talimara; e ita reketa Krete e Arabia talimara. Na ita maparara na takamonagirana ita kwapurakwapura gera karo ai Palagu na kala kamura iraura vagira ekalarawai gekilagi-matagairana.” ");
INSERT INTO khz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Maparara nugara geparato e maaovoaovora matotaura geverenagi-verenagito, negetiwato, “Ekala ganina rakagau?” ");
INSERT INTO khz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Na talima reketana na gevegarevegare-agirato, negetiwato, “Etalima e pege niu-rakava.” ");
INSERT INTO khz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ne Petero apostolo gagalana kwapuna (11) ria geruga-itito, e karona evega-kamuato, ne vokoukou talimara evopata-venirato, netiwato, “Iuda talimami e Ierusalemai gotaluna talimami maparami, pio kamonagi namanama, ekala ganina gemi ana kilagi-matagaia. ");
INSERT INTO khz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Etalima e ati pege niu rakava, gomi gotugamagina vetaina. E amoamo roea ora gauna 9 koloko. ");
INSERT INTO khz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Na etoma Ioela, peroveta talimana, na ekilagi-kuneato vetainai ematagaina, netiwato, ");
INSERT INTO khz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Palagu ekilana: Toma ikarai au Palaguku pana popo-rigoa taunilimalima maparara atarai. Ne natumi melora e vavinera pia peroveta, gemi malaga valigu pia mata-vanagi, e velepara e logeapara pia nivi. ");
INSERT INTO khz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Pa, votoma au geku vetugunagi marura e garera atarai au Palaguku pana popo-rigoa, ne pia peroveta. ");
INSERT INTO khz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ne nugapalevagi kalara kamura kupa kukunai pana vega-matagaira, e vegailia tanoparai; rala, e kalova, e kovu milomilo. ");
INSERT INTO khz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Garo pene vetao-kule pene mukunaa, e uve pene kalovakalova, rala vetaina pene mia, Velekou gena vogomai tomana kamuna e irau vagina pene kavinagi gaurai. ");
INSERT INTO khz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne rai Velekou aranai ekea-ragena talimana maguli pene vaia.’ ");
INSERT INTO khz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isaraela talimami, ekila pio kamonagira: Iesu, Nasareta talimana, Palagu na eveniato inaguluna gomi gemi ai evega-matagai-gitakauato. Ia genana Palagu gena kala irau vagira e nugapalevagi kalara e vegailia irau vagira reketa ekalarato gomi nuganugami ai, pe gomi ne ripami. ");
INSERT INTO khz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Palagu gena ririwai e ripai warau enavuga-kuneato gelegelenai, Iesu gomi gimami ai etugu-kauato, ne rakava talimara na geveakavamito, gaurai Iesu satauro ai gonaero-kauato ne govagi-kwaregaato. ");
INSERT INTO khz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Na Palagu na ia kwarega na evega-kuliiti-waiato, e kwarega vitina egaivagiato, kwalana kwarega ati gelegele ia pene gapi-gaugaua. ");
INSERT INTO khz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Davida na ia ekilagiato, netiwato, ‘Velekou toma mapararai wailaku ai agitaana. Ia au gimaku ripana kavanai, gaurai gau taa na ati pene kalavo-kalavoku. ");
INSERT INTO khz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Gaura pakurai aoku verere na pevonu, e geku kilakila verere na pege vonu. Kwarega kalina na maki ati akalina, ");
INSERT INTO khz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kwalana au kwarega talimara geria kapu ai ati pono raokwaniku, e gemu Talima Veagana ati pene poraga. ");
INSERT INTO khz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Maguli rauparara warauna ovega-ripakuto; goi lagamu ai pana talu, ne verere na pono vega-vonuku.’ ");
INSERT INTO khz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Walakavaku maparami, etoma au aoku matiligana na pana kila, ita kalakalara kamuna Davida ekwaregato pe getoleato, etoma ia kalana ita ria ea. ");
INSERT INTO khz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na ia peroveta talimana, e ripana Palagu na warau ekilagi-gavuato, netiwato: Davida kalakalana ta ia gena teronai pene tanukau vegata. ");
INSERT INTO khz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Davida na eripa-kuneato, Palagu na rakagau wailai pene kalaa egitaato. Gaurana Keriso gena kuliitiwai kilana ekilagiato, netiwato, ‘Ia kwarega talimara geria kapu ai ati eraokwaniato, e tauniparana ati pene poraga.’ ");
INSERT INTO khz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Palagu na Iesu, kwarega na evega-kuliiti-waiato, ai maparamai ripamai. ");
INSERT INTO khz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Palagu na egapi-rageato, gimana ripana kavanai etaoato, ne Palagu na ekilagi-gavuato, Veaga Palaguna Tamana genana egapiato. Ne ia na Veaga Palaguna toma pepopo-rigoa, gomi na gogitaana e gokamonagiana. ");
INSERT INTO khz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kwalana Davida kupai ati everageto, na ekilato, ‘Palagu na au geku Velekou ekilagiato, netiwato: Au gimaku ripana kavanai ono mai-tanu, ");
INSERT INTO khz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","pene ago gevetali-venimuna talimara pana tao-rigora, gagemu panakauna gaurai pana vega-agora.’ ");
INSERT INTO khz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Gaura pakurai Isaraela talimara maparara pia ripa-namanama, eIesu, gomi na gosatauroato, Palagu na Velekou e Keriso ai evega-agoato.” ");
INSERT INTO khz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ekila gekamonagiato aonai, nugara gerageto, ne Petero e voapostolo reketa gerenagirato, negetiwato, “Walakava, ai rakagau aia kala?” ");
INSERT INTO khz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petero na evaikilarato, netiwato, “Gomi kwapurakwapura gemi rakava geriana pio vetugamagiwai pio laka-waikule, e Iesu Keriso aranai bapatiso pio gapia, pe gemi rakava pene tugamagi-piatogara; e gena vega-nama, Veaga Palaguna, pio vaia. ");
INSERT INTO khz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kwalana Palagu gena kilagavu ekalaato gomi gemi e gomi natumi geria, e kapu raurai getaluna talimara geria. Pa, Velekou ita gera Palagu na ekilagi-gavuato Veaga Palaguna na pene keara talimara maparara pene venira.” ");
INSERT INTO khz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petero na kila vogo ekilagirato, egavu-tinarato evaikila-gaivagirato, netiwato, “Egulu talimara rakavara geriana matotaumi pio kali-maguli.” ");
INSERT INTO khz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Talima gutuma na gena kila gegapi-rageato, gaurai bapatiso gegapiato. Votomaimo taunilimalima maparara ragana toitoi (3,000) vetaira ira geria golea aonai gelou-togato. ");
INSERT INTO khz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ne vanagivanagi apostolo talimara geriana ripa gegapiwai, gekoukouwai e geveveakavawai, pereti gekala-koruwai pa ganikou geganiwai e gerapali-koukouwai. ");
INSERT INTO khz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostolo geriana Palagu na nugapalevagi kalara kamura e vegailia irau vagira vogo ekalarawai, e taunilimalima maparara gekali-rakavato. ");
INSERT INTO khz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iesu gevega-taunataunaato talimara maparara getanu-kouwai e geria e garia geveware-veniwai. ");
INSERT INTO khz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Geria rinaga e tano gevoi-agirawai, ne monira ira maparara aorai gewarerawai, kwapurakwapura geria rapu gelegelerai. ");
INSERT INTO khz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Toma mapararai Rupu Veaga aonai getanu-kouwai. Geria numai ganikou geganiwai e gegani-koukouwai mavererera e mamainora ria. ");
INSERT INTO khz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Palagu gevega-rageawai, e taunilimalima maparara geria vetaukava veveni nama geverere-agiawai. Gaurai toma mapararai Velekou na evega-magulirawai talimara ira ria etao-kourawai. ");
INSERT INTO khz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Toma ta lavilavi ora gauna 3 koloko rapali oranai, Petero e Ioane Rupu Veaganai geagoto. ");
INSERT INTO khz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Vonai talima ta ewalato gagena rakava gerawaliato. Toma mapararai gevua-agoawai, Rupu Veaga vanagina arana “Nama Iwavagi” kwalanai gevega-tanu-taliawai, ne Rupu Veaganai gelaka-togawai talimara geriai moni enogiwai. ");
INSERT INTO khz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ia na Petero e Ioane ia laka-toga aonai egitarato, ne gau ta ia venia ulanana enogirato. ");
INSERT INTO khz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Taura ruala na gegita-kalakalaato, ne Petero na evaikilaato, netiwato, “Ai ono gitamai!” ");
INSERT INTO khz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Vokila ekamonagiato vetainai, ira ruala egitarato, ia matapolu ekilato gau ta pia venia. ");
INSERT INTO khz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Na Petero na evaikilaato, netiwato, “Au ati geku moni, na geku ai rakagau emiana gauna ana venimu. Iesu Keriso, Nasareta tauna, aranai avaikilamuna, ono kuliiti, ono laka!” ");
INSERT INTO khz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ne Petero na gage rakava talimana gimana ripanai egapito, evega-rugaitiato. Veganamo ia gagena e gagena komukomura getiligato. ");
INSERT INTO khz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ia epuriitito, eruga-talito, elaka-nagito. Ne Petero e Ioane ria Rupu Veaga aonai gelaka-togato, elakato e epuriitito, Palagu evega-rageato. ");
INSERT INTO khz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Taunilimalima maparara na gegitaato, elakato e Palagu evega-rageawai, ");
INSERT INTO khz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","e gegita-leaato, ia “Nama Iwavagi” vanagina kwalanai etanuwai voupe enoginogiwai talimana gaurai, ira maparara palagura geveruluvagito gevevega-kali-rakavato ia genai vokala ewalato genai. ");
INSERT INTO khz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Votalima Petero e Ioane geriai roe waegapi-tagowai, aonai tourage kamuna arana “Solomona Gena Tourage” ai, taunilimalima maparara gevevega-kalito, ne geagoto geriai. ");
INSERT INTO khz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petero na votaunilimalima egitarato, ne evaikilarato, netiwato, “Isaraela talimami, rakagau gaurai egau govevega-kaliagiana? Rakagau gaurai ai gogita-kalakalamaina? Gomi gotugamagina e ai matotaumai gema tiavu ai e Palagu kwalanagina gaurai, etalima paga vega-lakaa nogotina? ");
INSERT INTO khz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aperaamo, Isaako, Iakobo geria Palagu, ita tenera maparara geria Palagu, na gena vetugunagi talimana Iesu evega-rageato, na gomi na Roma talimara govenirato pia vagia ulanana, e Pilato gena ririwa pene luga-vagia ragaina pia vagia netiwato, na gomi ati goririwato. ");
INSERT INTO khz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ia Veaga e Kala-rorirori talimana, na gomi na ati goririwaato, gaurai Pilato gonogiato, vagivagi talimana pene luga-vagia nogotiwato. ");
INSERT INTO khz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Maguli evuamaiato talimana gomi na govagi-kwaregaato. Na Palagu na kwarega na maevega-kuliiti-waiato. Ai eia e ripamai e gakilagi-matagaiana. ");
INSERT INTO khz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ai gema kamonagi Iesu genai gaurai, etalima gomi na gogitaana e ripami pevega-namaa. EmaIesu aranai e kamonagi ia genana evogomaina gauna na, etalima pevega-nama taunataunaa, gomi maparami na gogitaana ea. ");
INSERT INTO khz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Walakavaku maparami, au ewagumona aripana, rakagau gemi vekuneagi talimara ria na gokalaato voati ripami gaurai. ");
INSERT INTO khz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Na Palagu na kunenai gena peroveta talimara maparara muruna na ekilagiato, ia gena Keriso roe nea viti pene vua netiwato. Vokila gomi gemina ema taunataunato. ");
INSERT INTO khz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gaura pakurai iovetugamagiwai e iolaka-waikule Palagu genai, pe ia na gemi rakava pene gapi-pakara. ");
INSERT INTO khz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Pene vovetaina pio kala genai, Palagu gena kwalimu Velekou genana pene vogomai, e ia na Iesu Keriso pene tugu-maia. Ia Palagu na gomi gemi ekilagi-maavu-kuneato. ");
INSERT INTO khz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ia kupai roe wapene talu, pene ago, Palagu na gaura maparara pene vega-valigu-waira. Ia na gena peroveta talimara veagara murura na rauvagi-vegata ekilagiato gelegelenai. ");
INSERT INTO khz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kwalana Mose ekilato, ‘Velekou gemi Palagu na gomi gemi talima aora na gemi peroveta talimana ta pene vega-rugaa au vetaiku. Ia na pene vaikilami kilara maparara pio kamonagira. ");
INSERT INTO khz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Talima taa na ia gena kila ati pene kamonagi-venia talimana, Palagu na gena taunilimalima aora na pene gapi-vagia, ne pene vagi-kwaregaa.’ ");
INSERT INTO khz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Taunatauna, peroveta talimara maparara Samuela na pene vogomai toma, e ia mulina na gevogomaito peroveta talimara maki vogo warau gekilato, e tomara gekilagirato. ");
INSERT INTO khz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gomi peroveta talimara naturia, e Palagu gena kilagavu gomi tenemi geria ekalaato maki gomi gemi. Palagu na Aperaamo evaikilaato aonai netiwato, ‘Goi natumu genana tanopara petera maparara na nama pia vaia.’ ");
INSERT INTO khz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gaura pakurai Palagu gena vetugunagi talimana Iesu evega-rugaato, ne gemi ai etugu-wati-kuneato, gomi pene vega-namami ularana. Vonama ganina gomi kwapurakwapura gemi rakava geriana pene vaiwaikulemi.” ");
INSERT INTO khz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petero e Ioane na taunilimalima roe wagevega-vegupurawai aonai, Rupu Veaga velera, e Rupu Veaga gitatagona talimara geria vele, e Sadukea talimara gekwarato. ");
INSERT INTO khz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ira geparuto, kwalana eapostolo ruala na taunilimalima gevega-riparawai e geria gevopatawai aonai gekilawai, Iesu kwarega na ekuliiti-waito; gaura pakurai kwarega talimara maki pia kuliiti-wai. ");
INSERT INTO khz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ne tauria ruala gegapi-gaugaurato, tipura numanai gekana-gavurato; vonai pia maitu pene ago amoamo, kwalana garo maki erigoato. ");
INSERT INTO khz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Na Petero e Ioane geria vopata talima vogovagi na gekamonagiato, gaurai talima vogo na gevega-taunataunaato, aonai marumo maparara vogora ragana imaima (5,000) vetaina. ");
INSERT INTO khz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Elaganiato aonai Iuda velera, e vanuga talimara kamura, e rova gevevega-ripagiawai talimara Ierusalemai getanu-kouto. ");
INSERT INTO khz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas, Rupu Veaga velena kamuna, Kaiapa, e Ioane, e Alesanda, e Rupu Veaga velena kamuna gena pete maki vonai. ");
INSERT INTO khz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ne taura ruala gevaiagorato, wailarai gevega-rugarato vou gerenagirato, negetiwato, “Arigi tiavu ai pa rai aranai ekala gokalaato?” ");
INSERT INTO khz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ne Petero, Veaga Palaguna na evonuto gaurai evega-gelerato, netiwato, “Isaraela velemi e vegitatago talimami! ");
INSERT INTO khz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Pene ai etoma pogo kea-maimai goririwana ai na aia vaikilami, egage rakava talimana genai kala namana paga kalaa e arigi rauparai ia penama genai, ");
INSERT INTO khz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","gomi maparami e Isaraela aonai taunilimalima maparami pio ripa, Iesu Keriso, Nasareta talimana, gomi na gosatauroato, na Palagu na kwarega na evega-kuliiti-waiato talimana, aranai etalima penama-vagi, gomi wailami ai eruga-tagona. ");
INSERT INTO khz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","VoIesu, ‘gomi, numa kala talimami, na gorugaato vatuna, ia keakwala vatunai emiato.’ ");
INSERT INTO khz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Vevega-maguli iamo geregana genana pita rawalia; tanopara maparana aonai Palagu na ara ta ati evenirato, ita pene vega-magulira ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kaonsela talimara na Petero e Ioane gegitarato, ati gekaliwai e geripato maki, ira vevega-ripa kapuna taai ati gelakato, pe taura ruala ati aonekara. Voia gegitaato aonai, gekalito e aora gevekala-pakato, gaurai geripato, ira Iesu ria gelaka-kouwai talimara. ");
INSERT INTO khz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","E votalima gegitaato nama vagi Petero e Ioane ria geruga-tagowai, gaurai ati geria kila rauparana. ");
INSERT INTO khz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Gaura pakurai gevaikilarato, votanukou kapuna na pia laka-gerevagi. Ne gelaka-piatito muli ai ne ira geregariamo aonai matotauria geverenagito, negetiwato, ");
INSERT INTO khz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Etalima ruala e raka ita kalagi-tiwara? Ierusalemai getaluna talimara maparara riparia, ira kala irau vagina ta pege kalaa, e ita na ati pita kilagi-veavugaa ripa. ");
INSERT INTO khz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Na taunilimalima na nege varavaragiana kalinana, etalima patara vega-kalira e ita kila-waira, Iesu aranai talima ta ragaina mapia vaikila-waia.” ");
INSERT INTO khz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ne magekea-togarato, gevaikilarato, Iesu aranai ragaina vagi mapia vopata e vevega-ripa. ");
INSERT INTO khz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Na Petero e Ioane na gevega-gelerato, negetiwato, “Gomi matotaumi iovega-vetovoa, arigia rorirori Palagu wailanai? Gomi na rakagau gokilagiana gauna paia kalaa, pa Palagu na ekilagiana kalana paia kalaa? ");
INSERT INTO khz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kwalana gagitarato e gakamonagirato gaura ai ati gelegele paia kilagi-veavugara e murumai maki vogaura kilagikilagirai ati paia koura ripa.” ");
INSERT INTO khz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Gevaikila-gaokarato mulinai, getugu-atirato. Vega-rakavara rauparana ta ati gerawaliato, kwalana talima maparara na Palagu gevega-rageawai, vokala irau vagina pakunai. ");
INSERT INTO khz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Kwalana vokala irau vagina na enamato talimana gena maguli rigolora gagala vativati (40) maki evanagiato. ");
INSERT INTO khz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Petero e Ioane getugurato mulinai, taukavaria geriai gewaikuleto. Rupu Veaga velera kamura e Iuda velera na rakagau gevaikila-venirato gaura maparara taukavaria geria gekilagirato. ");
INSERT INTO khz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ne taukavaria na vokila gekamonagirato aonai, ira maparara na Palagu gerapali-veni-koukouato, negetiwato, “Velekou o, kupa, tanopara, rawapara, e aorai gemiana gaura maparara goi na okalarato. ");
INSERT INTO khz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Veaga Palaguna genana, ai tenemai Davida, goi gemu vetugunagi talimana, muruna na okilato gaurai netiwato, ‘Rakagau gaurai ati Iuda talimara geparu-rakavana? E rakagau gaurai taunilimalima na ati pia inagulu navugara getovorana? ");
INSERT INTO khz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tanopara velera gekala-maavuto, e vegitatago talimara kamura gegalu-kavito Velekou magena Keriso ria pia vetali-venira ularana.’ ");
INSERT INTO khz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Taunatauna vegata, Heroda e Pontio Pilato, e ati Iuda talimara Isaraela talimara ria evanuga kamunai gekoukouto, goi gemu vetugunagi talimana veagana Iesu, ia goi na ovirigiato e Keriso ai ovega-agoato, navugana getovoato. ");
INSERT INTO khz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ira na gekalarato gaura rakagau goi na gemu tiavu ai e ririwai onavuga-kunerato pia vetalo notiwato gauramo. ");
INSERT INTO khz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gaura pakurai, Velekou o, geria vevega-kali kalara ono gitara, e ai goi gemu vetugunagi talimamai tiliga ono venimai, pe valimu paia kilagia matiligamai na. ");
INSERT INTO khz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Gimamu ono tugu-atia, pe viti talimara pono vega-namara, e vegailia irau vagira e kala irau vagira pono kalara, Iesu, goi gemu vetugunagi talimana veagana aranai.” ");
INSERT INTO khz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Gerapali-gatuto mulinai, getanu-kouto numana eveakaveakato. Ne ira maparara Veaga Palaguna na gevonuto, Palagu valina gepiaato matiligara na. ");
INSERT INTO khz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Iesu gevega-taunataunaawai talimara maparara geria tugamagi e aora kwapunamo. Ta gena rinaga ia geregana gena ati netiiwai, na geria gau maparara ira kwapurakwapura gevewareagi-veveniwai. ");
INSERT INTO khz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostolo talimara matiavu iwavagira na Iesu Velekou gena kuliitiwai valina gepiaawai, e Palagu gena vega-nama iwavagina ira maparara atarai epopo-rigoato. ");
INSERT INTO khz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ira nuganugarai ta ati erapuwai. Kwalana mageria tano pa numa talimara na, geria numa e tano gevoi-agirawai, ne voira monira geago-agirawai, ");
INSERT INTO khz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Apostolo wailarai getao-talirawai. Ne maparara geveniagi-gelegelerawai, kwapurakwapura geria rapu vetairai. ");
INSERT INTO khz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iosepa apostolo na arana gekeaato Banabas, ganina “Vevega-tiliga Talimana”. Ia Levina kwalu, Saipras mounai ewalato. ");
INSERT INTO khz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ia gena tano evoi-agiato, ne voina monina eago-agiato, apostolo gageria kwalarai evetao-taliato. ");
INSERT INTO khz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tau ta etaluwai arana Anania, garawana arana Safira. Anania na geria tano ta eve voi-agiato, garawana na maki egapi-rageato. ");
INSERT INTO khz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na votano monina kwautamo eago-agiato apostolo wailarai evetao-taliato, na kovana egapi-gaugauato. Vokala ekalaato garawana ripana. ");
INSERT INTO khz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ne Petero na evaikilaato, netiwato, “Anania, rakagau gaurai Satani na peporogimu, ne Veaga Palaguna poopaa, tano monina kwauta goi gemu pogapi-waia? ");
INSERT INTO khz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Rogotina oro voi-agia aonai tano goi gemu, ei? Pege voia mulinai moni maki goi gemu. Rakagau potugamagia gaurai ekala pokalaa? Goi ati taunilimalima poopara, na Palagu poopaa.” ");
INSERT INTO khz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anania na vokila ekamonagiato aonai, eketo-talito, ekwaregato. Ne vokala ewalato valina gekamonagiato talimara maparara gekali-rakavato. ");
INSERT INTO khz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Gaurai malaga valigu gekuliitito, Anania tauniparana rapugai gekumuato, gevua-atiato, ne geve toleato. ");
INSERT INTO khz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ora toitoi vetaira mulirai, garawana ema laka-togato, na ia rakagau ewalato gauna ati ripana. ");
INSERT INTO khz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petero na erenagiato, netiwato, “Ono varaku, gomi ruala na tano monina pogo gapia gauna eiamo pa?” Ia evega-geleto, netiwato, “Pa, voina neiamo.” ");
INSERT INTO khz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ne Petero na evaikilaato, netiwato, “Rakagau gaurai goi magarawamu goti gokila-kouto, Velekou Palaguna goopaato? Ono gitaa, goi garawamu pege tolea talimara vanagi ai geruga-tagona, ira na goi maki pia vua-atimu.” ");
INSERT INTO khz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Voora kianai ia Petero gagena kwalanai eketo-talito, ekwaregato. Ne vomalaga valigu gelaka-togato, gegitaato kwaregana, gaurai tauniparana gevua-atiato, garawana laganai geve toleato. ");
INSERT INTO khz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ekalesia maparana evali gekamonagiato talimara maparara kali kamu vagi na egapirato. ");
INSERT INTO khz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Vegailia irau vagira e kala irau vagira vogo apostolo na taunilimalima wailarai gekalarawai. E Iesu gevega-taunataunaawai talimara maparara “Solomona Gena Tourage” ai getanu-kouwai. ");
INSERT INTO khz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ati geria kamonagi talimara na gevega-ragerawai, na gekaliwai, pe ira ria ati geve tanu-kouwai. ");
INSERT INTO khz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Na maru e gare gutuma iwavagi na Velekou gevega-taunataunaawai. Gevega-taunataunaawai marura e garera maparara apostolo geria goleai gelaka-togato. ");
INSERT INTO khz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Apostolo na gekalarawai kalara taunilimalima na geriparato, ne viti talimara gevua-atirato rauparai, ne maokomaoko valarai gepai gevega-maokorato, Petero gena lakavanagi ai, avugana na pene avugara ulanana. ");
INSERT INTO khz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","E taunilimalima gutuma para Ierusalema lagana vanugara na viti talimara e palagu rakavara na geporogirato talimara gevua-agorato, ne maparara genamato. ");
INSERT INTO khz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Gaurai Rupu Veaga velena kamuna mataukavana Sadukea goleana ria, apostolo talimara geriai gemunemune-rakavato. ");
INSERT INTO khz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ira na apostolo talimara gegapi-gaugaurato, ne tipura numanai gekana-gavurato. ");
INSERT INTO khz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Na vopogi Velekou gena aneru na tipura numana vanagina elovoato, ne apostolo egapi-atirato, evaikilarato, netiwato, ");
INSERT INTO khz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ioago, Rupu Veaga aonai pio ruga, nee maguli valiguna maparana taunilimalima geria pio kilagia.” ");
INSERT INTO khz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Amoamo valiguvaliguna Rupu Veaga aonai gelaka-togato, aneru na evaikilarato gelegelenai taunilimalima gevega-riparato. Rupu Veaga velena kamuna mataukavana ria gelakatito, ne kaonsela talimara e Isaraela velera maparara gekea-koukourato, ne tipura numanai getugu-agorato, apostolo talimara ularana. ");
INSERT INTO khz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Na vetugunagi taura tipura numanai geve kwarato aonai apostolo talimara ati gerawalirato. Ne gewaikuleto, geve vaikilarato, negetiwato, ");
INSERT INTO khz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Tipura numana vanagina kanagavu, e vegitatago talimara maki rugatago; na vanagi paga kala-pakaa aonai apostolo ta ati paga rawalia.” ");
INSERT INTO khz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Rupu Veaga gitatagona talimana kamuna e Rupu Veaga velera kamura na vokila gekamonagiato aonai geaovoaovo-rakavato, ati riparia vokala ganina rakagau. ");
INSERT INTO khz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Roe wageaovoaovowai aonai talima ta elaka-togato, ne evaikilarato, netiwato, “Iokamonagi! Tipura numanai pogo kana-gavura talimara Rupu Veaga aonai geruga-tagona, e taunilimalima gevega-riparana.” ");
INSERT INTO khz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ne Rupu Veaga gitatagona talimana kamuna magena melo ria apostolo talimara gevevaiwaikulerato. Ati gekwara-rolorolorato, kwalana taunilimalima na irauna nege vaturana kalirana. ");
INSERT INTO khz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Gelakagi-togarato, kaonsela wailanai gevega-rugarato, ne Rupu Veaga velena kamuna na erenagirato, netiwato, ");
INSERT INTO khz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ai na gavaikila-gaoka-vagimito, etalima aranai ragaina pio vevega-ripa, na iogitaa, gomi rakagau pogo kalaa! Gomi na vevega-ripa pogo vega-lovolovoa, ne Ierusalema maparana warau pevaia, e gomi goririwana ia gena kwarega kepina ai gemai pia rolia.” ");
INSERT INTO khz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petero e apostolo reketa gevega-geleto, negetiwato, “Ai Palagu gena ririwa paia kwalanaa, ati taunilimalima geria ririwa. ");
INSERT INTO khz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iesu gomi na satauro kukunai gonaero-kauato ne, govagi-kwaregaato, na ita tamara geria Palagu na maevega-kuliiti-waiato. ");
INSERT INTO khz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Palagu na egapi-itiato, ia gimana ripana kavanai evega-rugaato, Vegitatago Velena e Vevega-maguli Talimanai evega-agoato. Isaraela talimara pene vega-vetugamagi-waira, e geria rakava pene tugamagi-piatogara ulanana. ");
INSERT INTO khz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ai egaura kilagi-matagaira talimamai. Veaga Palaguna na maki egaura ekilagi-matagairana. VoVeaga Palaguna voma Palagu na ia gekamonagi-veniana talimara maparara evenirato.” ");
INSERT INTO khz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaonsela talimara na ekila gekamonagiato aonai geparu-rakavato, e geria ririwa voapostolo talimara ia vagi-kwaregaramo. ");
INSERT INTO khz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Na ira nuganugarai Parisea talimana arana Gamaliel, rova evevega-ripagiawai, e taunilimalima maparara na gekupa-rageawai talimana, kaonsela aora na erugaitito. Ne ekilato, neapostolo talimara ia vaiatira vou. ");
INSERT INTO khz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gaurai ia na kaonsela tanukouna evaikilaato, netiwato, “Isaraela talimami, etalima raka iokalagi-tiwara nogotina genai pio tugamagi-namanama. ");
INSERT INTO khz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Toma reketa pege vanagi, Teuda erugaitito, evekilagito, ia talima kamuna ta, ne talima tinavu vativati (400) vetaira ia ria gekauto. Na ia gevagi-kwaregaato aonai gena taunilimalima maparara geraka-lovolovoto; vogolea toma verovero vagi. ");
INSERT INTO khz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Voia mulinai Iudas, Galileia tauna, taunilimalima arara talotalora pa tentiti (census) gapigapina tomarai ematagaito, ia maki gutuma kamu evairato, na ia maki gevagiato gaurai gena taunilimalima geraka-lovolovoto. ");
INSERT INTO khz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Gaura pakurai etoma kalanai, au na avaikilamina, etalima ioraokwanira, e geriai gau ta ragaina pio kalaa. Kwalana pene geria navuga e inagulu taunilimalima geriana evogomaina genai pene lekwalekwa. ");
INSERT INTO khz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Na pene eia Palagu genana evogomaina genai gomi na etalima ati gelegele pio koura. Ati nama Palagu pio vetali-venia!” Kaonsela na Kamaliela gekamonagi-veniato. ");
INSERT INTO khz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ne apostolo magekea-togarato, gekwarirato, ne gevaikilarato, Iesu aranai ragaina mapia vevega-ripawai; ne getugu-lakarato. ");
INSERT INTO khz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apostolo na kaonsela tanukouna geraokwaniato mavererera na, kwalana Palagu na egapi-itirato, ira gelegele Iesu aranai nugarage pia rawalia. ");
INSERT INTO khz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Gaurana toma mapararai Rupu Veaga aonai e taunilimalima geria numa aorai ira Vali Namana gevevega-ripagiawai e gevopatagiawai, e gekilawai, Iesu ia Keriso. ");
INSERT INTO khz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Votomara aorai Iesu gekwalanaawai talimara gegutuma-agowai. Iuda talimara, Grik karonai gekilawai talimara, e Heberu karonai gekilawai talimara aorai kogo ewalato. Grik karonai gekilawai talimara gekilato, ira geria wapu toma kwapurakwapura ganigani gewarewai aonai ira gevega-rapurawai. ");
INSERT INTO khz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Gaura pakurai apostolo gagalana ruala (12) na Iesu gekwalanaawai talimara maparara gekea-koukourato, ne gekilato, “Ai na ganigani warewarena ulanana, Palagu gena kila ati paia vali-piagia ati rorirori. ");
INSERT INTO khz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Gaura pakurai, walakavaku maparami, gomi aomi na talima taulatoi kwapuna iogapi-itira, valira nama talimara, Veaga Palaguna e aoneka na gevonuto talimara; ne einagulu ira paia veni-vanagira. ");
INSERT INTO khz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A ai matotaumai gema taim maparana rapali e vopatai paia taoa.” ");
INSERT INTO khz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Apostolo geria navuga ira maparara na geverere-agiato. Ne ira na etalima gegapirato: Setepano, kamonagi na e Veaga Palaguna na evonuto talimana; Filipo; Porokora; Nikano; Timon; Pamena; e Nikolas, Antioka talimana na Iuda talimara geria aliruputali ekwalanaawai. ");
INSERT INTO khz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ira na e talima ea apostolo wailarai gevega-rugarato, ne atarai gerapalito e gimara atarai getao-kaurato. ");
INSERT INTO khz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ne Palagu gena kila eraka-lovolovoto. E Iesu kwalanagina talimara Ierusalemai gevogo-veleke-vagito, e Rupu Veaga velera vogo galagala vagina maki Palagu gena kila gegapi-rageato, e gevega-taunataunato. ");
INSERT INTO khz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Setepano Palagu gena vega-nama e tiavu na evonuto talimana, ia na nugapalevagi kalara kamura e vegailia irau vagira taunilimalima wailarai ekalarawai. ");
INSERT INTO khz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Na vekilagi-piatoga kamu ewalato. Iuda talimara geria rupu goleana ta gekilagiawai “Lugavagi Talimara”. Ira e Iuda talimara, Kureni e Alesandria na e Silisia e Asia tanoparara na gevogomaito talimara, Setepano ria geveituto. ");
INSERT INTO khz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Na Setepano gena kila ati gegaoawai, kwalana ia Veaga Palaguna na eveniawai aonekanai ekilawai. ");
INSERT INTO khz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Gaurai ira na talima reketa aora geganirato pia kila, “Ai na Setepano gakamonagiato, ia na Mose e Palagu ekilagi-piatogarato.” ");
INSERT INTO khz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Vorauparai ira na taunilimalima, e Iuda velera, e rova gevevega-ripagiawai talimara gekaro-iluilurato. Ira Setepano genai geagoto, geve gapiato, ne Iuda geria kaonsela wailanai geago-agiato. ");
INSERT INTO khz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Vonai pia opagia ularana veroli-opakau talimara reketa gevaitogarato, ne gekilato, “Etalima toma mapararai ita gera Rupu Veagana e Mose gena rova ekilagi-piatogarana. ");
INSERT INTO khz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ai na gakamonagiato, netiwato, ‘Iesu, Nasareta talimana, na eRupu Veagana pene vega-rakavaa, e Mose na evenirato kalara maparara pene vega-iraura.’” ");
INSERT INTO khz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kaonselai getanukou-tagowai talimara maparara na Setepano gegita-kalakalaato, e wailana gegitaato noowane aneru ta wailana. ");
INSERT INTO khz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Rupu Veaga velena kamuna na Setepano erenagiato, netiwato, “Ekila e taunatauna pa?” ");
INSERT INTO khz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Setepano na evega-gelerato, netiwato, “Walakavaku e tamaku maparami, au iokamonagiku! Ita tenera Aperaamo Haran vanuganai rogotina ere talu aonai maeka ralema iwavagina Palaguna ia genai ematagaito Mesopotamiai, ");
INSERT INTO khz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ne evaikilaato, netiwato, ‘Gemu talima e tanopara ono raokwanira, ne au na pana vega-gitamu tanoparanai pono ago.’ ");
INSERT INTO khz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ne ia na Kaldea tanoparana eraokwaniato, Haran ai eve vanugato. Tamana ekwaregato mulinai, Palagu na etugu-maiato ewagumona gotalu-agiana tanoparanai. ");
INSERT INTO khz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","A Palagu na Aperaamo tano girina kiata vagi ati eveniato. Gagena panatalina kapuna gelegelenai girina kiata maki ati eveniato. Na Palagu ekila-gavuato ia na tano ta pene venia, ia e ia mulinai pia wala talimara na tano ta pia kwalanaa ira geria. Volaganinai Aperaamo ati natuna. ");
INSERT INTO khz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Palagu na maevaikilaato, netiwato, ‘Goi gemuna pia wala gulura tano poluna taai pia talu. Rigolo tinavu vativati (400) vokapu talimara geria vetugunagi talimarai pia ago e pia vega-vitivitira.’ ");
INSERT INTO khz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Palagu maekilato, ‘Isaraela talimara na vetugunagira geago-venirana kwalura au na pana agirorira, voia mulinai ira votano na pia laka-piati, ekapu ai au pia aliruputali-veniku.’ ");
INSERT INTO khz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ne Palagu na Aperaamo kopi-lamavagi inaguluna eveniato, voo ia gena kilagavu vegailiana. Ne Aperaamo na Isaako evega-walaato, toma taula vativati (8) mulinai tauniparana kopina elama-vagiato. Voia mulinai Isaako na Iakobo evega-walaato, ne Iakobo na gera kwalu gereparana talimara gagalana ruala evega-walarato. ");
INSERT INTO khz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kwalu repara talimara Iosepa genai gemunemuneto, gaurai Aikupito talimara geriai gevoi-agiato. Na Palagu vou Iosepa goti, ");
INSERT INTO khz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","gaurai gena raupara verauleara maparara aorana evega-maguliato. Palagu na Iosepa aoneka eveniato, e Parao, Aikupito velena, aona evega-namaato Iosepa genai, ne Parao na eririwaato e tiavu eveniato, Aikupito tanona e ia gena numa talimara e rinaga pene gita-tagora. ");
INSERT INTO khz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ne Aikupito tanona maparana e Kanaana tanona maparanai roge gewalato, voanana vito e nanu vekala kamu evega-walaato, ne ita tenera ati garia ganigani rawali rauparana. ");
INSERT INTO khz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Na Iakobo ekamonagito Aikupito ai vuiti voa, gaurai ia na ita tenera etugu-agorato, voo ira geria lakalaka tovotovona. ");
INSERT INTO khz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Geria ago vega-rualanai Iosepa matotauna kakana e tarina geriai evevega-matagaito ia rai, ne Parao na Iosepa gena wala eripaato. ");
INSERT INTO khz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Voia mulinai Iosepa evetuguto, tamana Iakobo magena pete geriai Aikupito ai pia ago ulanana. Iakobo petena Kanaanai maparana gagala taulatoi kwapuna imaima (75). ");
INSERT INTO khz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ne Iakobo Aikupito ai everigoto, vonai ia e ita tenera gekwaregato. ");
INSERT INTO khz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ira tauniparara Sekem ai gevua-waikulerato, ne vonai gevetolerato. Vokala kapuna Aperaamo na Hamora natuna geriana moni na evoiato. ");
INSERT INTO khz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Palagu gena kilagavu Aperaamo genai pene vega-taunataunaa tomana ekavinagiwai laganinai ita gera taunilimalima Aikupito ai gegutuma-vagito. ");
INSERT INTO khz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Voia mulinai vele taa na Aikupito egita-tagoato. Vovele ati ripana Iosepa. ");
INSERT INTO khz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ia na ita tenera eoparawai e evega-vitivitirawai, e evaikilarawai, naturia ralaralara geria numa na pia tao-atira, pia kwarega ulanana. ");
INSERT INTO khz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Volaganinai Mose ewalato. Mose ewalato aonai, gitagitana nama iwavagi. Ia uve toitoi tamana gena numai gegita-tagoato, ");
INSERT INTO khz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ne numa na getao-atiato aonai Parao natuna vavinena na egapiato, ne natunai evega-agoato. ");
INSERT INTO khz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mose Aikupito geria ripa e aoneka maparana gevega-ripaato, e gena kila e kala matiavura talimanai eagoto. ");
INSERT INTO khz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Gena maguli rigolora gagala vativati (40) egapiato, ne taukavana Isaraela talimara ene laka-gitara netiwato. ");
INSERT INTO khz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ia na Aikupito talimana ta egitaato, Isaraela talimana ekwariawai, ia eagoto galamana ekalaato, ne Aikupito talimana evagi-kwaregaato. ");
INSERT INTO khz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose matapolu ekilato gena taunilimalima pia tugamagi ripa, ia genana Palagu na Isaraela talimara pene vega-magulira, na voia Isaraela talimara na ati geripa-roriroriato. ");
INSERT INTO khz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Elaganiato aonai ia na Isaraela talimara ruala egitarato gegalamawai, ne ene vega-mainora ulanana evaikilarato, netiwato, ‘Gomi ruala, iokamonagi, gomi nema mawalakavami ruala, na rakagau gaurai taumi ruala gogalamana?’ ");
INSERT INTO khz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Na galama evega-walaato talimana na Mose eroli-gerevagiato, ne evaikilaato, ‘Goi rai na ai gema vele e agirorimai talimanai ekilagimuto? ");
INSERT INTO khz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Goi oririwana walagani Aikupito talimana povagi-kwaregaa vetaina au maono vagi-kwaregaku notina?’ ");
INSERT INTO khz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mose na vokila ekamonagiato, ne eraka-kwanirato, Midian ai ekali-lakato. Vonai etaluwai aonai natuna melora ruala gewalato. ");
INSERT INTO khz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Rigolo gagala vativati (40) geaikito mulinai, aneru ta tanoleanai Sinai Golona laganai Mose genai evevega-matagaito. Voaneru gautupu lukuna aonai kalova molenai eagoto, ne Mose genai evevega-matagaito. ");
INSERT INTO khz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mose na vogau egitaato aonai, ekalito; ne ene gita-namanamaa ulanana elaka-kaviagowai aonai, Velekou karona ekamonagiato, evetaina ekilato, ");
INSERT INTO khz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Au goi tenemu Aperaamo, Isaako, e Iakobo geria Palagu.’ Mose ekali-rakavato, ne ati eririwato mapene poe-agowai. ");
INSERT INTO khz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Palagu na evaikilaato, netiwato, ‘Gemu tamaka gagemu na ono gaivagira, kwalana oruga-tagona kapuna ne maveagana. ");
INSERT INTO khz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Taunatauna, au geku taunilimalima Aikupito ai gevega-vitivitirana pagitara e geria viti-vua lailaina kuluna pakamonagira gaurai au pamarigo ana vega-magulira ulanana. Ewagumona ono vogomai, au na goi ana tugu-waikulemu Aikupito ai.’ ");
INSERT INTO khz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mose ema Isaraela talimara na gerugaato talimana. Evetaina gekilato, ‘Goi rai na ai gema vele e toto-rorirorimai talimanai ekilagimuto?’ Etalimamo kwapuna Palagu na etuguato pene vele e pene vevega-maguli. E ia na maki gautupu lukunai kalova molena aona na ematagaito aneruna na eveakavaato. ");
INSERT INTO khz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ia na Isaraela talimara Aikupito na evaipiatirato aonai, nugapalevagi kalara kamura e vegailia irau vagira ekalarawai, Aikupito aonai Rawapara Kalovakalova e tanoleanai rigolo gagala vativati (40). ");
INSERT INTO khz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","EMosemo kwapuna na Isaraela talimara evaikilarato, netiwato, ‘Palagu na gemi peroveta talimana pene tugua, au etugukuto vetaina. Voperoveta gomi gemi taunilimalima ta.’ ");
INSERT INTO khz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ia Isaraela talimara geria tanukou aonai tanoleanai ita tenera Sinai Golonai evaikilarato aneruna ria vonai. Ia na Palagu gena maguli kilana Palagu genana egapiato, ita mapene vega-ripara ulanana. ");
INSERT INTO khz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Na ita tenera ati geririwato gena kila pia gapi-ragea, e ia gekila-piatogaato e aorai geria ririwa Aikupito ai maia waikule. ");
INSERT INTO khz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ira na Aarona gevaikilaato, negetiwato, ‘Ita gera palagu reketa ono kalara, ita wailarai pia laka ulanana. Kwalana eMose ita Aikupito na evaipiatirato talimana ita ati ripara ia raka pe kala-tiwa.’ ");
INSERT INTO khz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Votoma ira na polomakau natuna vetaina kaivakukuna gekalaato. Ne vokaivakuku wailanai vega-nama gaura geve taoto e gevelekwato. Matotaura gimara na gekalaato gauna geverere-veniato. ");
INSERT INTO khz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ne Palagu elaka-gerevagito, e Isaraela talimara etugu-kwanirato, kupa mitiura pia aliruputali-venira ulanana. Voperoveta talimara geria pukai getaloato gelegelenai, netina, ‘Isaraela talimami! Rigolo gagala vativati tanoleanai govagirawai mamoera, e polomakaura, e vega-nama gaura ati au geku. ");
INSERT INTO khz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Vokaivakuku palaguna Molok gena palai rupuna, e gemi palagu Refan gena mitiu avuavuna govuaawai; vokaivakuku gomi na gokalarato, pio aliruputali-venira ularana. Gaura pakurai au na gomi pana tugu-lakami Babulonia vokavanai.’ ");
INSERT INTO khz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ita tenera tanoleanai getaluwai aonai palai rupuna maki ira geriai. Vopalai rupuna Palagu na, gena kila taunataunara evega-matagairawai. Vopalai rupuna gekalaato Palagu na Mose evaikilaato rorinai, e Mose na palai rupuna kolemana egitaato gelegelenai gekalaato. ");
INSERT INTO khz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Voia mulinai ita tenera na vopalai rupuna tamara geriana gegapiato, ne Iosua gena vevai laganinai gevua-agoato kwalu polu talimara ita tenera wailarai Palagu na geria tano na egui-atirato. Vopalai rupuna vonai emiato pene ago Davida gena lagani. ");
INSERT INTO khz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Davida na Palagu gena vega-nama egapiato, e enoginogito, vonai Iakobo gena Palagu gena talu numana pene kalaa netiwato. ");
INSERT INTO khz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Na Solomona na vou gena numa ekalaato. ");
INSERT INTO khz_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Na Goloka Iwa Palaguna talima gimara na gekalarana numarai ati etaluna, peroveta talimana ekilana vetaina, ");
INSERT INTO khz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Velekou ekilana: Kupa au geku terona, e tanopara au gageku panatalina kapuna. Gaurai, au geku numa rakagau na pio kalaa? Au geku agalagi kapuna arigia? ");
INSERT INTO khz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Egaura maparara au gimaku na ati akalarato, pa?’” ");
INSERT INTO khz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Setepano maekilato, netiwato, “Kila-guilagi talimami! Gomi aomi e tegami Palagu ati geririwaana talimara vetaira. Gomi tenemi gekalawai vetaira gokalana, vanagivanagi Veaga Palaguna gogui-gerevagiana! ");
INSERT INTO khz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Arigi peroveta gomi tenemi na ati gevega-vitivitiato? Ira na Kala Rorirori Talimana gena vogomai gekilagi-matagai-kuneato talimara gevagi-kwaregarato. Ewagumona gomi na Iesu pogo lewaa e pogo vagi-repaa. ");
INSERT INTO khz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Palagu gena rova aneru na gema rigo-agiato gomi na gogapiato, na ati gokwalanaato.” ");
INSERT INTO khz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ira na vokila gekamonagiato aonai, geparu-rakavato, karikarira maki gegala-kikitalirato Setepano genai. ");
INSERT INTO khz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Na Setepano Veaga Palaguna na evega-vonuato, epoe-rageto kupai, ne kupai Palagu maekana ralemana iwavagina egitaato, e Iesu egitaato Palagu gimana ripanai rugatago. ");
INSERT INTO khz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ne ekilato, “Iogitaa! Kupa pevekala-paka agitaana, e Taunilimalima Natuna Palagu gimana ripanai eruga-tagona!” ");
INSERT INTO khz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Vokila gekamonagiato aonai gimara na tegara gekou-gavurato voupe geparalato. Ne maparara veganamo ia geraka-veniato, ");
INSERT INTO khz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","gegapiato, ne siti mulinai gerolo-atiato, ne vatu na gevatuato. Vega-taunatauna talimara geria rapuga koloakoloa ta arana Saulo, ia gagena kwalanai getao-talirato. ");
INSERT INTO khz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Gevaleawai aonai, Setepano erapalito, netiwato, “Iesu Velekou o, au palaguku ono gapi-ragea.” ");
INSERT INTO khz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Evetiu-talito, ne matagina ekea-rageto, netiwato, “Velekou o, geria kala rakavana ea voina ragai pono venira.” Vovetaina ekilato, ne ekwaregato. ");
INSERT INTO khz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo na Setepano vagi-kwaregana gauna egapi-rageato. Votoma Ierusalema aonai ekalesia vega-vitivitina e gui-lovolovona kamuna evetinato. Kamonagi talimara maparara geraka-lovolovoto, Iudea e Samaria tanora mapararai geagoto, na apostolo talimara maparara geregariamo geraka-kwanirato. ");
INSERT INTO khz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Palagu gekwalanaawai talimara reketa na Setepano getagiagi-rakavaato e matagira na gevuaato, ne geve toleato. ");
INSERT INTO khz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Na Saulo na vou ekalesia ene vega-rakava-taunataunaa netiwato. Numa kwapurakwapura aorai elaka-togawai, ne kamonagi marura e garera erolo-piatirawai, tipura numai eve kana-gavurato. ");
INSERT INTO khz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Gevega-raka-lovolovorato talimara geagoto kapurai Palagu gena kila gevopatagiato. ");
INSERT INTO khz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo Samaria vanugana kamunai eagoto, vonai Keriso valina eve piaato. ");
INSERT INTO khz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Gutuma na Filipo gena kila gekamonagiato e vegailia irau vagira ekalarato gegitarato aonai, ira maparara na gekamonagi-kalakalaato. ");
INSERT INTO khz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Palagu rakava taunilimalima gutuma geriana malailaira gelaka-vagito, e tauniparara kavatara gekwaregato talimara e gage-rakava talimara gutuma genamato. ");
INSERT INTO khz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Gaura pakurai Samaria vanugana aonai verere kamu vagi ewalato. ");
INSERT INTO khz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Vovanugai talima ta etaluwai arana Simona. Kunenai gena megamega e wara kalara na Samaria talimara evega-kali-rakavarawai. Matotauna evekilagiwai, ia iwavagi, ");
INSERT INTO khz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","e taunilimalima maparara vanuga aonai keira na pene ago kamura na gekamonagiawai, e gekilagiawai, “Etalima e voPalagu genana evogomaito tiavuna gekilagiana ‘Tiavu Iwavagi.’” ");
INSERT INTO khz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ia ekamonagi-veniato, kwalana lagani rauvagi ia gena megamega kalara na evega-kalirato. ");
INSERT INTO khz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Na Filipo na Palagu gena Basileia, (gena vegitatago tiavuna evega-rugaana ea), Valina Namana e Iesu Keriso arana valina evopata-venirato aonai, maru e gare na gevega-taunataunaato, ne ebapatisorato. ");
INSERT INTO khz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simona na maki evega-taunataunaato, gaurai bapatiso egapiato. Voia mulinai Simona na Filipo ekwaru-guiguiato, e Filipo na vegailia irau vagira e nugapalevagi kalara kamura ekalarawai gaurai geriai evevega-kalito. ");
INSERT INTO khz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Apostolo talimara Ierusalemai getaluwai gekamonagito, Samaria talimara na Palagu gena kila warau gegapi-rageato, gaurai Petero e Ioane getugu-agorato Samariai. ");
INSERT INTO khz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Taura ruala gekwarato aonai kamonagi talimara atarai gerapalito, Veaga Palaguna pia gapia ulanana. ");
INSERT INTO khz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kwalana Veaga Palaguna ira ta atarai rogotina ere mairigo. Ira Iesu Velekou aranaimo bapatiso gegapiato. ");
INSERT INTO khz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Petero e Ioane gimara ira atarai getao-kaurato, ne ira na Veaga Palaguna gegapiato. ");
INSERT INTO khz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simona na apostolo talimara egitarato, gimara getao-kaurato vou Veaga Palaguna gegapiato, ne ia na moni Petero e Ioane etugu-venirato, ekilato, ");
INSERT INTO khz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Au maki netiavu ioveniku, pe gimaku ta atanai pana tao-kaua aonai, Veaga Palaguna pene gapia.” ");
INSERT INTO khz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Na Petero na evaikilaato, netiwato, “Goi magemu moni ria kalova kapunai ioago, kwalana otugamagina Palagu gena vega-nama gauna moni na pono voia! ");
INSERT INTO khz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Einagulu ai goi ati gemu kapu, kwalana aomu ati rorirori Palagu wailanai. ");
INSERT INTO khz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gemu ririwa rakavana na ono vetugamagiwai, ne Velekou ono nogia, peiramu ia na netugamagi tevelena ogapiana aomu ai gauna pene tugamagi-piatogaa. ");
INSERT INTO khz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kwalana agitamuna, goi aoginigini na ovonuto, e rakava na eligomuto.” ");
INSERT INTO khz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ne Simona na Petero evega-geleato, netiwato, “Gemu kala, au ataku ai Velekou ono nogia, pe pokilagira gaura ta au geku ai ragai pene wala.” ");
INSERT INTO khz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petero e Ioane na Velekou gena kila gekilagi-matagaiato e gevali-piato mulinai, Ierusalemai gewaikuleto. Geria waikule ai Samaria vanugara vogo aorai Vali Namana gevopatagiato. ");
INSERT INTO khz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Velekou gena aneru taa na Filipo evaikilaato, netiwato, “Ono kuliiti, waiatina kavanai ono ago, tipo pono agomo Ierusalema na Gasai geagona rauparanai. Votanoleana rauparanai, talima ta ati etaluna.” ");
INSERT INTO khz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Gaurai ekuliitito, eagoto. Ne eagowai aonai, Itiopia talimana ta, raki kamu talimana, gena vanugai ewaikule-wai. Ia Itiopia logeana kamuna gena rinaga egita-tagorawai talimana kamuna. Ia eunuko, (ragira gegapirato talimana). Ia Ierusalemai elakato Palagu pene aliruputali-venia ulanana. ");
INSERT INTO khz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Gena waikule ai kariota atanai etanukauto vou, Isaia peroveta talimana gena puka eagi-agoawai. ");
INSERT INTO khz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ne Veaga Palaguna na Filipo evaikilaato, netiwato, “Ono ago, vokariota laganai pono velaka.” ");
INSERT INTO khz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gaurai Filipo kariota laganai eraka-agoto, ne votalima ekamonagiato, Isaia peroveta talimana gena puka eagiawai. Gaurai evaikilaato, “Nekila oagiana ganina ripamu pa?” ");
INSERT INTO khz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ia evega-geleto, netiwato, “Au raka ana ripa-tiwa? Talima taa na pene vega-ripaku vou pana ripa taunatauna.” Ne Filipo evaikilaato, netiwato, “Kariotai ono mai-ragekau, lagaku ai ono mai-tanu.” ");
INSERT INTO khz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ia na puka aonai eagiawai kilana ea, “Ia mamoe vetaina geago-agiato, pia vagi-kwaregaa ulanana; ia mamoe natuna vetaina guira gepakoti-vagirana aonai murura ati gekala-pakarana, vovetainai ia maki muruna ati ekala-pakaato. ");
INSERT INTO khz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Getao-rigoato e gena Kota rauparana gekouato. Gena pete talimara rai na pene kilagira? Kwalana gena maguli tanoparai pema aiki.” ");
INSERT INTO khz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Eunuko na Filipo enogiato, netiwato, “Ono varaku, eperoveta talimana na rai vovetaina ekilagiato? Ia matotauna evekilagito pa tau ta ekilagiato?” ");
INSERT INTO khz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ne Filipo na votalotalo genana gena kilakila etinaato, e Iesu Valina Namana evega-ripaato. ");
INSERT INTO khz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Voraupara na geagowai, nanu kapuna taai gelakatito. Vonai eunuko na Filipo evaikilaato, netiwato, “Ono gitaa, nanu ea, rakagau na au bapatisoku evega-waiana?”  ");
INSERT INTO khz_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ne Filipo ekilato, “Na pene aomu maparana na ovega-taunataunaana genai pana bapatisomu.” Ia evega-geleto, netiwato, “Pa, aoku maparara na avega-taunataunaana Iesu Keriso ia Palagu Natuna.” ");
INSERT INTO khz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ne kariota egiuato talimana evaikilaato, kariota ene vega-ruga-talia, ne kariota evega-ruga-taliato. Filipo e eunuko taura ruala nanu ai gelaka-rigoto, ne Filipo na eunuko ebapatisoato. ");
INSERT INTO khz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Taura ruala nanu na gerage-vagiwai aonai, Velekou Palaguna na Filipo egapi-vagiato. Eunuko na ati maegita-waiato, na gena lakalaka rauparana na eagowai mavererena. ");
INSERT INTO khz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipo Asoto ai maeve matagaito. Vonai vanuga mapararai elaka-togato, Vali Namana evopatagiawai, eagoto pene ago Kaisareai ekwarato. ");
INSERT INTO khz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo maparuna roe voa Velekou gekwalanaawai talimara vega-rakavara e vagi-matera kilara ekala-vigi-rageawai. Gaurai eagoto Rupu Veaga velena kamuna genai, ");
INSERT INTO khz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","enogiato, vevega-ripa pepana pene taloa, Damaseko ai Iuda talimara geria rupu pene venira ulanana. Pe, Iesu gekwalanaana marura e garera vonai pene rawalira e pene ligora, ne Ierusalemai pene vogomai-agira. ");
INSERT INTO khz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ne Saulo na Ierusalema eraokwaniato Damaseko ai eagoto. Damaseko vanugana ekavinagiato aonai, maeka ta kupa na emarigoto ia ewae-taliato. ");
INSERT INTO khz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ne ia kwano ai eketo-talito, e karo ta ekamonagiato, netiwato, “Saulo, Saulo! Rakagau gaurai au ovega-vitivitikuna e oguikuna?” ");
INSERT INTO khz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ia everenagito, netiwato, “Velekou, goi ne rai?” Vokaro na evega-geleato, netiwato, “Au Iesu, goi na au ovega-rakavakuna talimaku. ");
INSERT INTO khz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na ono kuliiti, vanuga kamunai ono laka-toga, vonai talima taa na pene vaikilamu rakagau pono kala.” ");
INSERT INTO khz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ia gekwaruato talimara maparara geruga-talito, ati gekilakilato, kwalana karo gekamonagiato, na talimana vou ati gegitaato. ");
INSERT INTO khz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo kwano na ekuliitito, matana ealirato aonai gau ta ati egitaato. Ne taukavana na gimanai gegapito, Damaseko ai gevaiagoato. ");
INSERT INTO khz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Toma toitoi vegata matana gekeleto ati evegitato, e ati eganiganito e nanu pa rakagau ta ati eniuato. ");
INSERT INTO khz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaseko ai Iesu gekwalanaawai talimana ta arana Anania, mata-vanagi ai Velekou na evaikilaato, netiwato, “Anania!” Ia evega-nokoto, “Ou! Velekou, au ea.” ");
INSERT INTO khz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Velekou na evaikilaato, netiwato, “Ono kuliiti, pe raupara ta arana Rorirori Rauparana na ono ago. Pono ago Iudas gena numai Taso talimana ta arana Saulo pono verenagi-agia, kwalana ia vonai erapalina voa. ");
INSERT INTO khz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ia na mata-vanagi ai talima ta arana Anania pegitaa, pelaka-toga, gimana ia atanai petao-kaura, matana pene alira ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Anania evega-geleto, netiwato, “Velekou, talima gutuma na gevarakuto, etalima Ierusalemai goi gemu taunilimalima veagara kala rakava kwaikwaira ekala-venirana. ");
INSERT INTO khz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Damaseko ai pevogomai maki Rupu Veaga velera kamura na rorirori geveniato, goi aramu gevega-rageana talimara maparara pene ligora e tipura numanai pene taora ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Na Velekou na evaikilaato, netiwato, “Ono ago, kwalana etalima au na warau avirigiato, ati Iuda talimara e tanopara velera kamura e Isaraela talimara wailarai au araku pene kilagia ulanana. ");
INSERT INTO khz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","E au na pana vega-gitaa, ia au araku pakunai vitiviti vogo roe nea pene vuara.” ");
INSERT INTO khz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Gaurai Anania eagoto, numai elaka-togato, e gimana Saulo atanai etao-kauato. Ne netiwato, “Walakavaku Saulo, Velekou Iesu, ekapu ovogomai-veniawai aonai raupara kapanai gemu ai evevega-matagaito talimana. Ia na petuguku, kwalana matamu mapia vekala-paka e Veaga Palaguna na goi pene vega-vonumu ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ati lovana gau kwatuna magani gunavera vetaina ia matana na eketo-vagito, ne maevegita-waito. Voia mulinai ekuliitito, ne bapatiso egapito. ");
INSERT INTO khz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Eganiganito mulinai, tauniparana etiliga-waito. Saulo Damaseko ai toma reketa maetalu-agirato, Iesu gekwalanaawai talimara ria. ");
INSERT INTO khz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ia veganamo rupu ai eagoto, Iesu eve vopatagiato, netiwato, “Iesu ia Palagu Natuna.” ");
INSERT INTO khz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Saulo gekamonagiato talimara maparara nugara geketo-vagito, ne gekilato, “Etalima Iesu arana gekilagiana talimara Ierusalemai evagirana talimana ei? E enai pevogomai ekalamo ulanana pene gapira, pe Rupu Veaga velera geria ai pene vaiwaikulera ulanana ei?” ");
INSERT INTO khz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Na Saulo gena vopata tiavuna ekamuwai. Gena kilakilai Iesu evega-taunataunaawai, taunatauna Iesu ia Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna). Vokila Iuda talimara Damaseko ai getaluwai talimara ati geria vega-gele rauparana. ");
INSERT INTO khz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Toma vogo geaikito mulinai, Iuda talimara getanu-kouto, Saulo vagi-kwaregana rauparana navugana getovoato; ");
INSERT INTO khz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","na raka navuga getovoato gauna talima reketa na Saulo gevaraato, pe eripato. Pogi-lagani vanuga kamuna laka-togara gegita-tagorawai, ia pia vagia ulanana. ");
INSERT INTO khz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Na pogi ta Iesu gekwalanaawai talimara na gegapiato, potegai geuraato, ne vanuga kanana mulina na getugu-rigoato. ");
INSERT INTO khz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Ierusalemai evekwarato aonai gena ririwa Iesu gekwalanaawai talimara ria pia tanu-kou, na ira maparara na gekali-veniato, kwalana ati gevega-taunataunaawai, ia taunatauna Iesu gena melo. ");
INSERT INTO khz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Na Banabas na evevaiato, apostolo talimara geriai evaiagoato. Ia na vou geria ekilagiato, Saulo na Velekou rauparai raka egita-tiwaato, e Velekou na evega-vegupuato. E evararato, rakavetaina Saulo Damaseko ai matiligana, e ati ekalito, Iesu aranai evopatato genai. ");
INSERT INTO khz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Gaura pakurai Saulo ira ria getaluwai e Ierusalema maparanai evopatawai Velekou aranai matiligana. ");
INSERT INTO khz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Grik karonai gekilawai Iuda talimara ria gevevaikilawai e geveituwai, na ira na pia vagia rauparana getavuawai. ");
INSERT INTO khz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Taukavana na enavuga geripaato gaurai Saulo Kaisareai geverigo-agiato, voanana Taso ai getugu-lakaato. ");
INSERT INTO khz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Gaura pakurai ekalesia maparana Iudea, Galileia, e Samaria tanorai maino ewalato. Ekalesia gena tiliga ekamuto e Velekou kalina na gekaliwai e Veaga Palaguna na eveakavarato. ");
INSERT INTO khz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petero kapu mapararai eagoto, aonai Lidai maki everigoto, Palagu gena taunilimalima veagara lakagitara. ");
INSERT INTO khz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Vonai talima ta arana Aenea erawaliato. Ia gagena kwaregara rigolo taula vativati (8) gena genogeno kapuna na ati ekuliitiwai. ");
INSERT INTO khz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ne Petero na evaikilaato, netiwato, “Aenea, Iesu Keriso na evega-namamuna. Ono kuliiti, gemu genogeno ono ikua.” Veganamo Aenea ekuliitito. ");
INSERT INTO khz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Vonai getaluwai Lida e Saron talimara maparara na gegitaato, gaurai Velekou genai gewaikuleto. ");
INSERT INTO khz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Iopai Iesu ekwalanaawai garena ta arana Tabita etaluwai. Grik karonai arana Toreka, ganina “deer”. Ia kala namara vogo ekalarawai, e ati geria e ati garia talimara eveakavarawai. ");
INSERT INTO khz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Volaganinai ia evitiato, ne ekwaregato. Tauniparana geguligiato, numa kukuna kovogana ta aonai getaoato. ");
INSERT INTO khz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iopa e Lida vepakara ati rau. Iesu gekwalanaawai talimara Iopai gekamonagito Petero Lidai gaurai talima ruala getugurato ia genai, pia nogia, nepiatiwa, “Ai ria ita ago, ragai pono kwaipo!” ");
INSERT INTO khz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Gaura pakurai Petero ekuliitito, ne ira ria geagoto. Ekwarato aonai numa kukuna kovoganai gevairageato. Vonai wapu maparara na geruga-gegelagiato, ne kouti e rapuga reketa, Toreka na, magulinai etulirawai gaura, ia gevega-gitaato matagira na. ");
INSERT INTO khz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petero na ira maparara kovoga na etugu-atirato, ne etiu-talito, erapalito. Voia mulinai epoe-talito, kwarega garena egitaato, netiwato, “Tabita, ono kuliiti!” Tabita matana ealirato, Petero egitaato, ne etanuitito. ");
INSERT INTO khz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petero na gimanai egapito, evega-rugaitiato. Gaurai vega-taunatauna talimara e wapu ekea-togarato. Ira gema laka-togato aonai, Tabita magulina eruga-tagowai. Ne Petero na geriai eveni-vanagiato. ");
INSERT INTO khz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ekala valina Iopa maparanai eraka-lovolovoto, gaurai talima gutuma na Velekou gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petero toma vogo Iopai etaluto, polomakau kopira einagulu-agirawai talimana goti arana Simona. ");
INSERT INTO khz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Talima ta arana Korenelio, ia Kaisarea vanuganai etaluwai. Ia Roma geria vetali talimara tinavuna (100) ekune-agirawai talimana. Ia na vetali goleana arana gekilagiawai “Itali geria Vetali Goleana” egita-tagorawai. ");
INSERT INTO khz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ia e gena numa talimara maparara Palagu gekwalanaawai e Palagu kalina na gekaliwai. Ia na ati geria e ati garia Iuda talimara eveakava-kamuvagirawai, e vanagivanagi erapaliwai Palagu genai. ");
INSERT INTO khz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lavilavi ta, ora gauna 3 koloko vetaina ia emata-vanagito, Palagu gena aneru ta egita-taunataunaato, elaka-togato, ia evaikilaato, netiwato, “Korenelio!” ");
INSERT INTO khz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Gaurai makalina na Korenelio na voaneru egita-kalakalaato, netiwato, “Velekou, rakagau?” Aneru na evega-geleato, netiwato, “Gemu rapali e gemu veveakava ati geria e ati garia talimara geriai Palagu na egapi-ragerato, e ia na etugamagirana. ");
INSERT INTO khz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Toma, talima reketa Iopai ono tugura, talima ta arana Simona, arana mataa Petero, piave vaia. ");
INSERT INTO khz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ia Simona, polomakau kopira einagulu-agirana talimana goti etaluna; gena numa kone ai.” ");
INSERT INTO khz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Evaikilaato aneruna na eraokwaniato, ne Korenelio na gena vetugunagi talimara ruala e gena vetali talimana ta ekearato. Gena vetali talimana Palagu gekwalanaawai talimana e ia vanagivanagi Korenelio laganai ia vetugunagina eago-veniawai talimana ta. ");
INSERT INTO khz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Rakagau gewalato gaura maparara Korenelio na evararato mulinai Iopai etugurato. ");
INSERT INTO khz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Elaganiato, ira raupara na roe wageagowai aonai Iopa gekavinagiato, garogota Petero numa kukunai erageto, ene verapali ulanana. ");
INSERT INTO khz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ia warau evitoato, gaurai gena ririwa pere ganigani. Ganigani roe wagekalarawai aonai, ia emata-vanagito. ");
INSERT INTO khz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ia na kupa evekala-pakato egitaato, gau ta rapuga kamuna vetaina, pipina kava vativati emarigowai ia genai, noowane gema tugu-rigoawai tanoparai. ");
INSERT INTO khz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ia emarigowai aonai maguli gaura irauirau maparara, gagera vativati gelakana gaura, e gealana gaura, e kupai gelovona manura. ");
INSERT INTO khz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ne karo taa na evaikilaato netiwato “Petero, ono kuliiti, pe ono vagira, ono ganira!” ");
INSERT INTO khz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Na Petero na evega-geleato, netiwato, “Velekou, aikina kinavagi! Rakava e ati vealeva gaura ta au na rogotina ara gania.” ");
INSERT INTO khz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Vokaro na maevaikila-waiato netiwato, “Palagu na ealevarato gaura ta rakavana ragai pono kilagi.” ");
INSERT INTO khz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Vega-toitoi vovetaina ewalato, ne vorapuga atilovana kupai maegapi-rageato. ");
INSERT INTO khz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petero na gena vomata-vanagi ai egitarato gaura ganina roe waetugamagi-vetavurawai aonai, Korenelio gena vetugunagi talimara gekwarato, e geripato Simona gena numa ariginai. Ne geagoto vonuma vanagina kwalana wailanai geve ruga-talito. ");
INSERT INTO khz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ne gekeato e geverenagito, negetiwato, “Simona, arana ta gekilagiana Petero, enai etaluna pa?” ");
INSERT INTO khz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petero vomata-vanagi ganina roe waetugamagi-vetavuawai aonai, Veaga Palaguna na evaikilaato, netiwato, “Ono kamonagi, goi talima toitoi na getavumuna. ");
INSERT INTO khz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gaurai ono kuliiti, ono verigo, ira ria pio laka. Ragai pono veituveitu, kwalana au na patugura gaurai.” ");
INSERT INTO khz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petero eraka-rigoto votalima geriai, ne evaikilarato, “Gotavuana talimana au ea. Rakagau gaurai pogo vogomai?” ");
INSERT INTO khz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ira gevega-geleto, negetiwato, “Ai vetali talimara tinavuna (100) ekune-agirana talimana arana Korenelio na petugumai. Ia kala rorirori e Palagu kalina na ekalina talimana, e Iuda talimara maparara na maki gekuparage-kamuvagiana. Ia Palagu gena aneru taa na evaikilaato, goi pene keagi-kaumu, gena numai pono ago, e goi na rakagau pono kilagira gaura pene kamonagira.” ");
INSERT INTO khz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ne Petero na votalima egapi-ragerato gena numai, vonai gemaituto. Amoamo gekuliitito, Petero ira ria geagoto, e walakavaria reketa Iopa na maki ira gekwarurato. ");
INSERT INTO khz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ira geagoto, raupara kapanai geve maituto, elaganiato vou Kaisareai gekwarato. Korenelio na ira ealo-tagorawai, gena talima e gatana maki ekea-koukourato gena numai. ");
INSERT INTO khz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petero elaka-togato aonai, Korenelio na erawaliato, ne gagena kwalanai etiu-talito e ealiruputali-veniato. ");
INSERT INTO khz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Na Petero na evega-rugaitiato, evaikilaato, “Ono kuliiti, au maki taunilimalimamo.” ");
INSERT INTO khz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Numa aonai gelaka-togawai aonai, Petero na Korenelio evega-vegupuawai. Numa aonai taunilimalima gutuma tanukou-tago erawalirato. ");
INSERT INTO khz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ne ia na evaikilarato, netiwato, “Gomi matotaumi maki ripami vealeva, ai gema rova ekilana, Iuda talimana ta ati Iuda talimana ta goti ati pia tanu-kou e ati pene wariwaria maki, rova. Na Palagu na pevega-gitaku, au na talima ta ati pana kilagia ia rakava pa ati vealeva. ");
INSERT INTO khz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Gaura pakurai pogo keagi-kauku genai tipo pavogomai ati pakaroverave. Gaurai ana renagimi, au rakagau gaurai pogo keagi-kauku?” ");
INSERT INTO khz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korenelio na netiwato, “Toma vativati warau pege aiki, au geku numai arapaliwai ora gauna 3 koloko lavilavi kavanai, ewagumona ora gauna vetaina. Aikina, na rapuga kulokulo iwavagina na everapugato talimana ta wailaku ai eruga-talito, ");
INSERT INTO khz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ne ekilato, ‘Korenelio! Palagu na gemu rapali pekamonagia e veveakava kalara ati geria e ati garia talimara geriai etugamagirato. ");
INSERT INTO khz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Iopai ono vetugu, Simona, ia arana gekeana Petero negetina, piave vaikilaa, pe pene vogomai. Ia Simona, polomakau kopira einagulu-agirana talimana gena numai etaluna kone ai.’ ");
INSERT INTO khz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Gaura pakurai veganamo avetugu-agimuto, nonamana, goi kala nama taumu, kwalana povogomai gaurai. Ewagumona ai maparamai Palagu wailanai ea, pe Velekou na pevaikilamu kilara maparara paia kamonagira ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ne Petero gena kila etinaato, netiwato, “Au ewagumona pama ripa rorirori, Palagu na taunilimalima maparara egapirage-gelegelerana. ");
INSERT INTO khz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pete maparara aorai rai ia kalina na ekalina, e kala rorirori ekalana talimanamo ia na egapi-rageana. ");
INSERT INTO khz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Palagu na Isaraela talimara geria ai etugu-maiato valina ea, vomaino valina Iesu Keriso genana maino valina namana epiaawai. Iesu Keriso talima maparara geria Velekou. ");
INSERT INTO khz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gomi ripami Iudea aonai rakagau ewalato, Galileia na evetinato. Ioane na bapatiso evopatagiato mulinai. ");
INSERT INTO khz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iesu, Nasareta talimana valina, gomi ripami, Palagu na Veaga Palaguna e tiavu ia atanai rakavetaina epopo-rigoato. Ia kapu mapararai eagoto, kala namara ekalarawai, e Tiapolo gena tiavu na egapirato talimara maparara evega-magulirawai, kwalana Palagu ia ria. ");
INSERT INTO khz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ai ia na Iuda e Ierusalema tanorai ekalarawai gaura maparara gavega-taunataunarana talimara. Ia satauro ai genaero-kauato aonai gevega-kwaregaato. ");
INSERT INTO khz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Na Palagu na toma vega-toitoinai (3) evega-kuliiti-waiato e evega-matagaiato pia gitaa ulanana. ");
INSERT INTO khz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ia taunilimalima maparara na ati gegitaato, na gevega-taunataunaana talimara, Palagu na evirigi-kunerato talimara namo gegitaato. Votalima ai ea. Ia ekuliiti-waito mulinai, ai ia ria gagani-kouto e ganiu-kouto. ");
INSERT INTO khz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ia na evega-nagimaito, taunilimalima geria paia vopata e paia kilagi-matagaia, ia Palagu na egapi-itiato, maguli talimara e kwarega talimara geria veagirori talimanai eagoto. ");
INSERT INTO khz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Peroveta talimara maparara na ia gekilagi-matagaiawai, negetiiwai, ia pia vega-taunataunaa talimara maparara ia arana tiavunai Palagu na geria rakava pene tugamagi-piatogara.” ");
INSERT INTO khz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petero roe waekilakilawai aonai, Palagu gena kila gekamonagiawai talimara maparara atarai Veaga Palaguna emarigoto. ");
INSERT INTO khz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iuda talimara Iesu gevega-taunataunaawai e Petero ria Iopa na gevogomaito talimara gevevega-kalito, kwalana Palagu na Veaga Palaguna ati Iuda talimara maki evenirato atarai epopo-rigoato. ");
INSERT INTO khz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kwalana gekamonagirato karo iraurai gekilawai, e Palagu gevega-rageato. Ne Petero ekilato, ");
INSERT INTO khz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","etaunilimalima na Veaga Palaguna warau pege gapia, ita na tagapiato vetaina. Gaurana, nanuna bapatiso pia gapia gauna rai na pene kila-waira? ");
INSERT INTO khz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Gaura pakurai ia na evaikilarato, Iesu Keriso aranai pia bapatisora. Ne ira na Petero genogiato, toma reketa ira ria mapia talu vou. ");
INSERT INTO khz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostolo e walakava Iudea kapura mapararai gekamonagito, ati Iuda talimara na maki Palagu gena kila warau gegapi-rageato. ");
INSERT INTO khz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Na Petero Ierusalemai everageto aonai, Iesu gevega-taunataunaawai talimara, na tauniparara kopira gevoro-vagirato gaura, na gegao-piatogarato, ");
INSERT INTO khz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","negetiwato, “Goi taunipara kopira ati gevoro-vagirana ati Iuda talimara geria numai olaka-togato, e ira ria goganigani-kouto!” ");
INSERT INTO khz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ne Petero na vali maparana geria epiaato, raka evetina-tiwato pene ago ikanai. Netiwato, ");
INSERT INTO khz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Au Iopa vanugana kamunai arapaliwai aonai amata-vanagito. Apoeto, gau ta rapuga kamuna vetaina, riki kava vativati, kupa na emarigowai, noowane gema tugu-rigoawai, wailaku ai ema vetao-talito. ");
INSERT INTO khz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Apoe-rigoto aonai maguli gaura irauirau, tanoparai gageria vativati na gelakana ramaramara, e urai getaluna ramaramara, gealana gaura, e kupai gelovona manura agitarato. ");
INSERT INTO khz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ne karo ta akamonagiato, netiwato, ‘Petero, ono kuliiti, ono vagira ono ganira!’ ");
INSERT INTO khz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Na au akilato, ‘Velekou, aikina ragaina vagi, rakava e ati kala vealeva gaura ta au muruku na rogotina gelaka-toga.’ ");
INSERT INTO khz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Vokaro kupa na maekila-waito, netiwato, ‘Palagu na ealevarato gaura rakavara ragai pono kilagi.’ ");
INSERT INTO khz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Vega-toitoi vovetaina ewalato, ne gaura maparara kupai maegapi-ragerato. ");
INSERT INTO khz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Voora kianai talima toitoi au ataluwai numanai gekwarato. Ira Kaisarea na getugurato au geku ai. ");
INSERT INTO khz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ne Veaga Palaguna na evaikilakuto, ira ria paia ago, ragai pana veituveitu. E walakava taula toitoi maki au ria Kaisareai gaagoto, maparamai Korenelio gena numai galaka-togato. ");
INSERT INTO khz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ia na gema ekilagiato, raka aneru ta ia gena numai ematagaito egitaato, e evaikilaato, netiwato, ‘Iopai ono vetugu, Simona, ia arana ta Petero, piave vaikilaa, pene vogomai. ");
INSERT INTO khz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ia na kila reketa gemu pene kilagira, ne vokila geriana Palagu na goi e gemu numa talimara maparara pene vega-magulimi.’ ");
INSERT INTO khz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Au na kila warau atinaato aonai, Veaga Palaguna emarigoto ira atarai, Pentekoste tomanai ita atarai emarigoto vetaina. ");
INSERT INTO khz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ne Velekou na rakagau ekilagiato gauna atugamagi-rawaliato, netiwato, ‘Ioane nanu na evebapatisowai, na gomi Veaga Palaguna na pene bapatisomi.’ ");
INSERT INTO khz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pene Palagu na vovega-nama kwapunamo, ita Velekou Iesu Keriso tavega-taunataunaato gaurai evenirato vega-namana, ati Iuda talimara maki evenirato genai, au rai gaurai, au na Palagu pana kila-waia?” ");
INSERT INTO khz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ira na vokila gekamonagiato aonai, geria kila paruparu gevega-aikiato, ne Palagu gevega-rageato, negetiwato, “Navou ati Iuda talimara maki Palagu na vetugamagiwai rauparana pevega-gitara, maguli pia gapia ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Setepano ekwaregato aonai, ekalesia vega-vitivitina e vagivagina ewalato, ne vega-taunatauna talimara gevega-raka-lovolovorato. Ira reketa geagoto pene ago Foenikia, Saipras e Antiokai geve kwarato. Vonai Iuda talimara geriaimo Iesu valina gevopatagiawai. ");
INSERT INTO khz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Na vega-taunatauna talimara reketa, Saipras e Kureni talimara Antiokai geagoto, Grik talimara geriai maki vali geve piato, Iesu Velekou Valina Namana gevopatagiawai. ");
INSERT INTO khz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Velekou tiavuna ira geriai, gaurai taunilimalima gutuma para Velekou gevega-taunataunaato e gevetugamagi-waito. ");
INSERT INTO khz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ierusalema ekalesiara na evali gekamonagiato, ne ira na Banabas Antiokai getuguato. ");
INSERT INTO khz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ia Antiokai ekwarato, Palagu gena vega-nama taunilimalima geriai egitaato aonai, everere-gaokato. Maparara evega-nagirato, rorirori ai Velekou pia kwalanaa maaora maparara na. ");
INSERT INTO khz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas talima namana, Veaga Palaguna e kamonagina evonuto. E taunilimalima gutuma para Velekou gena taunilimalimai geagoto. ");
INSERT INTO khz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ne Banabas Taso ai eagoto, Saulo tavutavuna. ");
INSERT INTO khz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Erawaliato, ne Antiokai evaiagoato. Vonai rigolo kwapuna, taura ruala ekalesia ria getanu-kouwai e taunilimalima gutuma para gevega-riparawai. Iesu gekwalanaawai talimara Antioka vanuganai vou gekilagirato “Christian”. ");
INSERT INTO khz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Votoma peroveta talimara reketa Ierusalema na Antiokai geverigoto. ");
INSERT INTO khz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ta ira aorai arana Akapas. Akapas ekuliitito, Veaga Palaguna na evega-ripaato gelegelenai tanopara maparanai roge kamuna pene wala valina epia-kuneato. Voroge kamuna Klaudias gena vegitatago laganinai ewalato. ");
INSERT INTO khz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Iesu gekwalanaawai talimara na geririwaato, ira kwapurakwapura geria rawali gelegelenai walakavara Iudeai geria wareware gaura reketa pia tugura, pia veakavara ularana. ");
INSERT INTO khz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Vokala gekalagiato, Banabas e Saulo geriai geria moni getugukauto, rupu gitatagona talimara pia venira ulanana. ");
INSERT INTO khz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Votomara aorai King Heroda na ekalesia talimara reketa egapirato, pene vega-vitivitira ularana. ");
INSERT INTO khz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Teimiti, Ioane kakana, kativa na repana epati-vagiato. ");
INSERT INTO khz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Heroda na Iuda talimara egitarato, vokala geverere-agiato gaurai Petero maki maeve gapiato. Voo ati egorona paraoana velekwana tomarai ewalato. ");
INSERT INTO khz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Petero egapiato, ne tipura numanai etaoato. Vonai vetali talimara gagalana taula toitoi (16) etaorato, vativatira evega-rugarato Petero pia gita-tagoa. Heroda gena ririwa Pasova mulinai vou, taunilimalima wailarai pene vaiatia e pene veakotaa. ");
INSERT INTO khz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Gaura pakurai Petero tipura numanai gegita-tagoawai, na ekalesia Palagu genai gerapali-veaoleawai Petero gena. ");
INSERT INTO khz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pogi, pene lagania Heroda na taunilimalima wailarai Petero pene vaiatia, Petero teini na geligoligoato, ne vetali talimara ruala nuganugarai emaituto, e vetali talimara na maki vanagi gegita-tagoawai. ");
INSERT INTO khz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ne Velekou gena aneru ta ematagaito, Petero laganai eruga-talito, e maeka ta tipura numana aonai ewae-taliato. Voaneru na Petero pagana eraka-valeato, ne evago-keroato, evaikilaato, “Vega-veleke, ono kuliiti!” Ne teini Petero gimana na geketo-vagito. ");
INSERT INTO khz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ne aneru na evaikilaato, netiwato, “Gemu pae kopina ono kala-kaua? E gemu tamaka ono kalara.” Ne Petero na ekalarato. Aneru maekilato, “Gemu kota ono rogagia, au muliku na ono vogomai.” ");
INSERT INTO khz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petero ia mulinai elakato pene ago, tipura numana na elakatito. Na ia ati ripana, voaneru na rakagau ekalaawai taunatauna. Ia matapolu ekilato emata-vanagina netiiwai. ");
INSERT INTO khz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Vanagi gitatagona talimara gerugato kapuna ta gelaka-vanagiato, e vega-rualana gelaka-vanagiato, geagoto pene ago, auri vanaginai geve kwarato. Vovanuga kamuna lakapiatina vanagina. Vovanagi matotauna ira geria evekala-pakato, ne gelaka-piatito. Raupara na gevelaka-rigowai aonai, veganamo aneru na Petero eraokwaniato. ");
INSERT INTO khz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Vonai vou Petero eripato ia genai rakagau ewalato, ne ekilato, “Au ewagumona taunatauna pama ripa, Velekou na gena aneru petugua Heroda gimana na, e Iuda talimara na au geku ai rakagau pia kalaa negetiiwai genana pema vega-maguliku.” ");
INSERT INTO khz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Vokala etugamagi-kalakalaato, ne Maria gena numai eagoto. Maria Ioane Mareko tinana. Vonuma aonai taunilimalima gutuma getanu-kouto, gerapaliwai. ");
INSERT INTO khz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petero numa mulina vanaginai ekoekoeto, ne vetugunagi vavinena ta arana Roda eagoto, eneve gitaa ulanana. ");
INSERT INTO khz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na ia na Petero karona ekamonagi-iliaato, ne verere na evega-vonuato, gaurai vanagi ati ekala-pakaato, na ia eraka-waikuleto, eve vaikilarato, Petero muli ai eruga-tagona voa. ");
INSERT INTO khz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ira na gevaikilaato, negetiwato, “Goi pekawamu pa!” Na ia evigiragewai, netiiwai, “Taunatauna, Petero muli ai eruga-tagona.” Ne ira gekilato, “Nema ia gena aneru!” ");
INSERT INTO khz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Na Petero roe waekoekoe-vigiragewai. Ne geagoto, vanagi geve kala-pakaato aonai Petero gegitaato, gevevega-kali-rakavato. ");
INSERT INTO khz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petero gimanai elao-wairato ragai pia kilakila, na Velekou na tipura numana na raka evaiati-tiwaato gauna geria ekilagiato. Ia na evaikilarato, netiwato, “Teimiti e walakava maparara geria evali pio piaa.” Ne ia elakato kapu taai maeagoto. ");
INSERT INTO khz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Amoamo, vetali talimara nuganugarai aovoaovo kamu vagi ewalato; geverenagi-verenagito, negetiwato, “Petero raka pekala-tiwa?” ");
INSERT INTO khz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Heroda na kapu maparana etavu-namanamaato, na Petero ati erawaliato. Ne Petero gegita-tagoato talimara eveakotarato mulinai, gena vetali talimara evaikilarato piave vagi-kwaregara. Voia mulinai Heroda na Iudea eraokwaniato, Kaisareai toma reketa eve taluto. ");
INSERT INTO khz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Heroda na Taia e Sidona talimara eparu-veni-rakavarato; gaura pakurai Taia e Sidona talimara gekila-koukouto, Heroda geve gitaato. Na kune, Blasto, Heroda gena maitu-kovogana gitatagona talimana goti vegata roe voa gevega-maranaato, e ira kavarai roe waekauto. Voia mulinai geagoto, Heroda genai maino geve nogiato, kwalana ira geria tanopara ganiganina Herodana tanoparai gegapiwai. ");
INSERT INTO khz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Gaurai ekilagi-maavuato tomanai Heroda na gena vele rapugana erogagiato, ne gena teronai eve tanukauto vou, taunilimalima evaikilarato. ");
INSERT INTO khz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Na taunilimalima gevevega-kalito, negetiwato, “E palagu ta karona, ati taunilimalima karona.” ");
INSERT INTO khz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Voorai Velekou gena aneru taa na Heroda ekwariato, kwalana ia na vokila ekamonagirato gaurai, Palagu ati evega-rageato. Ia vuo na geganiato, ekwaregato. ");
INSERT INTO khz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na Palagu gena kila vou ekamuto e eraka-lovolovoto. ");
INSERT INTO khz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas e Saulo geria inagulu gevega-guguluato ne Ierusalema na gewaikuleto; Ioane Mareko maki gevaikauato. ");
INSERT INTO khz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioka ekalesiana aonai peroveta talimara e vevega-ripa talimara reketa. Araria Banabas; Simeona, arana ta Nika; Lusias, Kureni talimana; Manaen, ia Kavana Heroda goti gekamu-kouto; e Saulo. ");
INSERT INTO khz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ira na Velekou gealiruputali-veniawai e gevokawai aonai, Veaga Palaguna na evaikilarato, netiwato, “Banabas e Saulo au geku pio gapi-gerevagira, kwalana au na pakeara, geku inagulu ta pia kalaa ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ira gevokato e gerapalito mulinai, gimara ira atarai getao-kaurato, ne getugurato. ");
INSERT INTO khz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Veaga Palaguna na Banabas e Saulo etugurato, ne taura ruala kone vanugana Seleusiai geverigoto. Seleusia na taura ruala poti ai gerageto, ne Saipras mounai gevanagito. ");
INSERT INTO khz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Banabas e Saulo Salami ai gekwarato aonai, Palagu gena kila Iuda talimara geria rupu reketai gevopatagiato. Ioane Mareko maki ira ria, ira taura ruala eveakavarawai. ");
INSERT INTO khz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Taura ruala Saipras mouna aonana gelaka-vanagiato, geagoto Papos vanuganai gevekwarato. Vonai Iuda geria wara e peroveta opakau talimana ta arana Ba-Iesu geve rawaliato. ");
INSERT INTO khz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","E Ba-Iesu maki vomou velena, e aoneka rakavarakava talimana arana Serekias Paulo gatana. Vovele na Banabas e Saulo ekearato ia wailanai, kwalana gena ririwa Palagu gena kila pene kamonagia. ");
INSERT INTO khz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Na vowara talimana Elima, (Ba-Iesu arana ta Elima), na geria kila ekilagi-piatogarato, gena ririwa vele na Iesu ragaina pene vega-taunataunaa. ");
INSERT INTO khz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ne Saulo, arana ta Paulo, Veaga Palaguna na evega-vonuato, ne Elima egita-kalakalaato. ");
INSERT INTO khz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ne ekilato, “Goi Tiapolo natuna, e kala rorirorira maparara goi na ovetali-venirana! Goi opa e rakava maparara na ovonuto. Velekou gena kala rorirorira opakauai pono vega-agora ularana ovegovana. Vokala arigi toma vou pono vega-aikia? ");
INSERT INTO khz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ono kamonagi! Ewagumona Velekou gena tiavu goi gemu ai pene matanai, matamu pene kele, e lagani maekana ati pono gitaa pene ago, toma ta.” Ati lovana Elima mukuna na matana egapi-gavuato, ne elaka-gegelagi-gegelagito, gena ririwa taa na gimanai pene gapi, e pene vaia. ");
INSERT INTO khz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Vovele na rakagau ewalato gauna egitaato aonai, Velekou evega-taunataunaato. E evevega-kalito Velekou gena vevega-ripa kilarai. ");
INSERT INTO khz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulo mataukavana ria Papos geraokwaniato, poti na Pekai geagoto. Peka Pamfilia aonai. Pekai Ioane Mareko na Paulo e Banabas eraokwanirato, ia Ierusalemai ewaikule-waito. ");
INSERT INTO khz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Peka na gagera na Antiokai geagoto. Antioka Pisidia tanonai. Tapati ai Iuda talimara geria rupu ai gelaka-togato, ne getanu-talito. ");
INSERT INTO khz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mose gena rova e peroveta talimara geria talotalo geagirato mulinai, rupu gitatagona talimara na ira ruala genogirato, negetiwato, “Walakava, pene magemi vevega-kwalimu kilara etaunilimalima geriai genai ai gaririwana, geria iokilagi.” ");
INSERT INTO khz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulo ekuliitito, gimana na elao-talirato, ne ekilato, “Isaraela taumi e ati Iuda talimara nuganugarai Palagu kalina na gokalina talimami, iokamonagi! ");
INSERT INTO khz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","E Isaraela talimara geria Palagu na ai tenemai evirigirato, e ia na evega-gutumarato, Aikupito tanonai getaluwai aonai. Palagu gena tiavu kamuna na Aikupito tanona na evaipiatirato, ");
INSERT INTO khz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","e rigolo gagala vativati (40) vetaina tanoleanai ira egita-tagorato. ");
INSERT INTO khz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ia na Kanaana tanonai pete taulatoi kwapuna talimara eporo-mourato. E geria tano egapiato, Isaraela talimara evenirato e geria tanoparai evega-agoato. ");
INSERT INTO khz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Vogaura maparara rigolo tinavu vativati e gagala imaima (450) vetaira aonai gewalato. Voia mulinai ia na veagirori talimara evenirato, pene ago peroveta talimana Samuela gena vegitatago laganina. ");
INSERT INTO khz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","E geria vele pa king ta pia gapia-noginogina gekalaato gaurana Palagu na Saulo evenirato. Ia Kisi natuna, Peniamina gena kwalu talimana. Saulo na rigolo gagala vativati (40) egita-tagorato. ");
INSERT INTO khz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saulo king rakina na egaivagiato mulinai, Palagu na Davida egapiato, Isaraela geria king ai evega-agoato. Palagu na Davida evetaina ekilagi-matagaiato, netiwato, ‘Au na Davida, Iese natuna, parawalia, ia au nugaku na eririwaveni-rakavaana talimana. Ia na au geku ririwa kalara maparara pene kalara.’ ");
INSERT INTO khz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Palaguna kilagavu gelegelenai, Davida petena na, Isaraela talimara geria vevega-maguli talimana ema tugu-rigoato. Vovevega-maguli talimana Iesu. ");
INSERT INTO khz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iesu rogotina ere inagulu aonai, Ioane na Isaraela talimara maparara evopata-venirato, evaikilarato, geria rakava geriana pia vevega-vua, ne bapatiso pia gapia. ");
INSERT INTO khz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ioane na gena inagulu roli evega-aikiato aonai, taunilimalima evaikilarato, netiwato, ‘Gomi gotugamagina au rai? Au ati gomi na goalo-tagoana talimana. Na iogita! Ia au muliku na evogomaina, e au ati gelegele ia gagena tamakara pana gaivagira.’ ");
INSERT INTO khz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Walakavaku, Aperaamo petena, e gomi ati Iuda talimara nuganugarai Palagu kalina na gokalina talimami: Evevega-maguli kilana ita gera etuguato. ");
INSERT INTO khz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ierusalema talimara mageria vele ria Iesu ati gegitailiaato, eIesu, peroveta talimara geria kila Tapati mapararai geagirawai, na ati getugamagi-ilurato. Vovetaina gaurai ira na Iesu vagi-kwaregana kilana gekilagiato aonai, peroveta talimara geria kila gevega-taunataunarato. ");
INSERT INTO khz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Pa, vagi-kwaregana ganina ati gerawaliato, na Pilato genogiato, pene vagi-kwaregaa negetiwato. ");
INSERT INTO khz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Puka Veaga aonai ia gekilagiato kilara maparara gekalarato mulinai, satauro kukuna na gegapi-rigoato, ne vatu gekoloato kovogana kalanai getaoato. ");
INSERT INTO khz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Na Palagu na kwarega na maevega-kuliiti-waiato, ");
INSERT INTO khz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ia ria Galileia na Ierusalemai geagowai talimara na toma vogo gegitaato. E ia ewagumona Isaraela talimara geriai Iesu gekilagi-matagaiana. ");
INSERT INTO khz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","E Palagu na ita tenera rakagau ekilagavu-venirato Valina Namana gomi gavega-ripamina. ");
INSERT INTO khz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Vokilagavu Palagu na ita, ita tupura, gera evega-taunataunaato, voia na Iesu kwarega na evega-kuliiti-waiato pakunai. Salamo vega-rualanai etaloato gelegelenai, netina, ‘Goi au Natuku; etoma au goi Tamamu ai paago.’ ");
INSERT INTO khz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Palagu na taunatauna kwarega na evega-kuliiti-waiato e ati mapene waikule kalai, ne pene poraga. Palagu na evetaina ekilagiato, netiwato, ‘Davida gena akilagi-gavurato, vevega-nama veagara e taunataunara gomi pana venimi.’ ");
INSERT INTO khz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E Salamo ta aonai maekilana, ‘Goi gemu talima veagana ati pene poraga, kwalana ati pene wala notiwato.’ ");
INSERT INTO khz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Davida gena gulu ai Palagu gena vetugunagi eago-veniawai aonai ekwaregato, ne tenena lagarai getoleato, e tauniparana eporagato. ");
INSERT INTO khz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Na Iesu, Palagu na kwarega na evega-kuliiti-waiato talimana, tauniparana ati eporagato. ");
INSERT INTO khz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Gaura pakurai, walakavaku maparami, au aririwana pio ripa, ai Iesu pakunai rakava tugamagi-piatogara valina gomi gemi gavali-piagiana. ");
INSERT INTO khz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mose gena rova na gomi gemi rakava ati pene luga-vagira ripa, a Iesu na ia gevega-taunataunaana talimara maparara geria rakava eluga-vagirana, kala rorirori talimarai evega-agorana. ");
INSERT INTO khz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Rogomi pio vetole, pe peroveta talimara na gekilagirato gaura, gemi ai ragaina pia wala; gekilato, ");
INSERT INTO khz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Gomi veveagoloka talimami iogitaa! Nugami ia pale-vagi, ne iokwarega! Kwalana gemi maguli tomarai au na kala ta pana kalaa, lewana taa na gemi pene kilagi-namanamaa, na ati pio vega-taunataunaa!’” ");
INSERT INTO khz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paulo e Banabas rupu na gelaka-rigowai aonai, taunilimalima na genogirato, wailara Tapatinai mapia waikule, pe vokila reketa geria mapia kilagi. ");
INSERT INTO khz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Taunilimalima tanukou na gelaka-lovolovoto mulinai, Iuda talimara gutuma, e ati Iuda talimara, Palagu gekwalanaawai talimara, gutuma maki Paulo e Banabas mulira na geagoto. Taura ruala na gevaikilarato e gevega-tiligarato, Palagu gena vega-nama aonai pia ruga-gaugau. ");
INSERT INTO khz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Tapati vega-rualanai, roli kianamo vanuga kamuna talimara maparara na Velekou gena kila kamonagina ulanana gelaka-koukouto. ");
INSERT INTO khz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Iuda talimara na vogutuma gegitarato aonai, gemunemune-rakavato; gaurai Paulo na rakagau ekilagirawai kilara ira na gekilagi-piatogarato e gekogo-agiato. ");
INSERT INTO khz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Na Paulo e Banabas makwalimura na gevega-gelerato, negetiwato, “Palagu gena ririwa vetainai ia gena kila ai na gomi paia vara-kunemi. Na gomi na ati gogapi-rageana, voanana gomi matotaumi na govega-taunataunaana, gomi ati gelegele maguli vanagivanagi pio vaia. Gaura pakunai, ai na gomi garaokwanimina, e ati Iuda talimara geriai gaagona. ");
INSERT INTO khz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kwalana Velekou na evetaina evega-nagimaito, netiwato, ‘Au na gomi ataomito ati Iuda talimara geria maekai pio ago, pe vevega-maguli pio lakagia tanoparai getaluna talimara maparara geriai.’” ");
INSERT INTO khz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ati Iuda talimara na vokila gekamonagiato aonai, geverereto e Velekou gena kila gevega-rageato; e Palagu na evirigirato maguli vanagivanagi pia gapia talimara maparara gevega-taunataunato. ");
INSERT INTO khz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Velekou gena kila vokapu maparana aonai eraka-lovolovoto. ");
INSERT INTO khz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Na Iuda talimara ati Iuda garera, raki kamura gegapirawai e Palagu gekwalanaawai garera, e vanuga kamunai vegitatago taura, aora geganirato. Ne ira na vevega-vitiviti gevega-walaato Paulo e Banabas geriai, e geria kapu na gegui-atirato. ");
INSERT INTO khz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Taura ruala na gagera kavura gekwarakwara-vagirato, ira geria kila-pelegovo vega-taunataunara ulanana, ne Ikoniai geagoto. ");
INSERT INTO khz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Iesu gekwalanaawai talimara Antiokai verere e Veaga Palaguna na gevonuvonu-rageto. ");
INSERT INTO khz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikoniai Paulo e Banabas taura ruala Iuda talimara geria rupu ai gekalawai vetaina gelaka-togato, ne gevopatato. Geria vopata na Iuda e Grik talimara gutuma kamu vagi gevega-taunataunato. ");
INSERT INTO khz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Na Iuda talimara ati geririwato Iesu pia vega-taunataunaa, talima reketa na ati Iuda talimara gekaro-iluilurato, ne walakava kamonagi aonai talimara geao-rakavarato. ");
INSERT INTO khz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paulo e Banabas vonai getalu-rauto. Makwalimura na Velekou gena vega-nama kilana gekilagiawai. Velekou na geria kila evega-taunataunarato tiavu evenirato, vegailia irau vagira e nugapalevagi kalara kamura gekalarato. ");
INSERT INTO khz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Na vanuga kamuna talimara geveware-kavalugato, reketa Iuda talimara ria gekauto, reketa apostolo talimara ria. ");
INSERT INTO khz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Gaurai ati Iuda talimara e Iuda talimara mageria vekuneagi taura ria gekila-koukouto, geririwato apostolo pia vega-vitivitira e vatu na pia vatu-matera. ");
INSERT INTO khz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Na Paulo e Banabas na vonavuga geripaato, gaurai Likaonia tanonai vanuga kamura ruala Listera e Derebe, e lagara tanorai gekali-agoto e lagara vanugara reketai. ");
INSERT INTO khz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Vonai Vali Namana gevopatagiawai. ");
INSERT INTO khz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listerai talima ta etaluwai; ia ewalato gagena rakava, pe ati elakawai. ");
INSERT INTO khz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Votalima ekamonagiwai Paulo evopatawai aonai. Paulo na egita-kalakalaato, ne eripato ia gena kamonagi na pene vega-namaa ripa, ");
INSERT INTO khz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ne ekila-paralato, netiwato, “Ono rugaiti ono ruga.” Ne epuriitito, elakato. ");
INSERT INTO khz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Taunilimalima gutuma na Paulo na rakagau ekalaato gauna gegitaato aonai, geria Likaonia karonai gekeato, negetiwato, “Palagu taunilimalimai pege ago, pegema rigo ita gerai!” ");
INSERT INTO khz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ira na Banabas arana Dios negetiwato, e Paulo arana Hemes negetiwato, kwalana Paulo ekilakila-vogowai. ");
INSERT INTO khz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Dios gena Rupu Veaga velena gena rupu vanuga kamuna mulinai. Ia na polomakau e tiare vanuga kanana vanaginai eago-agirato, kwalana taunilimalima gutuma ria geririwato, apostolo geriai vega-nama kalara pia kalara ulanana. ");
INSERT INTO khz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Na apostolo ruala Banabas e Paulo na gekamonagirato, rakagau pia kalaa negetiwato aonai, geria rapuga geralerato, ne gutuma aorai geraka-kogokogo-togato. ");
INSERT INTO khz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Negetiwato, “Rakagau gaurai gomi nevetaina gokalana? Ai maki talimamo gomi vetaimi! Ai na Vali Namana gomi gemi ai gavogomai-agiana, gomi gavaikilamina, ati ganira gaura pio raokwanira, ne Palagu Magulina genai pio laka-waikule-wai nagatina. Ia na kupa, tanopara, rawapara, e getalu-agirana gaura maparara ekalarato. ");
INSERT INTO khz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Kunenai ia na pete maparara egita-guilagirato, matotaura geria ririwa raupararai pia laka ulanana. ");
INSERT INTO khz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Na gau namara ekalarana geriana, ia matotauna vanagivanagi evevega-taunataunana: Ia na gura kupa na evenimina e varovaro gaura geria toma rorirorirai evenimina. Ia na ganigani vogovagi evenimina e aomi verere na evega-vonurana.” ");
INSERT INTO khz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Vovetaina gevaikilarato, na votaunilimalima gutuma kamu ira taura ruala geriai vega-nama kalara ia kalara vou negetiwato, kila-waira taura ruala geriai gegaokato. ");
INSERT INTO khz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Iuda talimara reketa Antioka e Ikonia na gevogomaito, e votalima ira kavarai gegapi-vanagirato. Gaurai Paulo vatu na gevaleato ne gerolo-atiato vanuga mulinai. Ira getugamagito ia warau ekwaregato. ");
INSERT INTO khz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Na Iesu gekwalanaawai talimara na geruga-gegelagiato aonai erugaitito, ne vanuga kamuna aonai elakatoga-waito. Amoamo Banabas goti Derebe ai geagoto. ");
INSERT INTO khz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulo e Banabas na Derebe ai Vali Namana gevopatagiato, ne taunilimalima gutuma Iesu gekwalanaana talimarai gegapi-togarato. Ne magewaikule-waito Listera, e Ikonia, e Pisidia Antiokai. ");
INSERT INTO khz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ira na Iesu gekwalanaawai talimara gevega-tiligarato e gelaunagirato geria kamonagi pia gapi-gaugaura. E gekilato, “Ita vitiviti vogo pita rawalira vou Palagu gena Basileiai pita laka-toga.” ");
INSERT INTO khz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Taura ruala na rupu kwapurakwapurai vekuneagi talimara gevega-rugarato. E taura ruala gevokato e gerapalito mulinai, Velekou gimanai getao-kaurato. Voo ira na gekamonagi-veniawai Velekouna genai. ");
INSERT INTO khz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidia tanona na gelaka-vanagito mulinai Pamfilia tanonai gekwarato. ");
INSERT INTO khz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Peka vanuganai Velekou gena kila gevopatagiato mulinai, Atalia vanuganai geagoto. ");
INSERT INTO khz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia na poti na gewaikule-waito Antiokai. Vonai geria evanelia lakalakana rogotina gere tinaa aonai, walakava na Palagu gena vega-nama aonai getao-kaurato, einagulu pia kalaa ulanana. Inaguluna ewagumona pege vega-aikia. ");
INSERT INTO khz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiokai gekwarato aonai ekalesia talimara gevega-tanu-kourato, ne Palagu na ira geriana rakagau ekalarato gaura maparara, rakavetaina ia na ati Iuda talimara geria kamonagi vanagina ekala-pakaato valira, geria ekilagito. ");
INSERT INTO khz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Vonai Iesu gekwalanaawai talimara ria taura ruala getalu-rauto. ");
INSERT INTO khz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Marumaru reketa Iudea na Antiokai geverigoto, ne walakava kamonagi aonai talimara gevega-riparato, negetiwato, “Gomi ati gelegele vevega-maguli pio gapia, pene melo tauniparara kopira vorovagira kalana Mose gena rovai ekilagiana gauna ati pio kwalanaa genai.” ");
INSERT INTO khz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Vokila galamanai, Paulo e Banabas ira ria veitu kamu vagi gekalaato. Gaura pakurai Paulo e Banabas e Antioka ekalesia talimara reketa gevirigirato, Ierusalemai pia verage, apostolo e ekalesia gevaiawai talimara geriai vokila piave verenagi-agia. ");
INSERT INTO khz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ira rupu na getugurato. Foenikia e Samaria tanora aora na gelaka-vanagito aonai vonai walakava geria gevaravarato, rakagau gaurai ati Iuda talimara Palagu genai gevetugamagi-waito. Walakava maparara na vovali gekamonagiato aonai, maparara geverere-rakavato. ");
INSERT INTO khz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ierusalemai gekwarato aonai, ekalesia talimara, apostolo, e ekalesia gegita-tagoawai talimara na gegapi-ragerato. Ne Palagu na ira geriana rakagau ekalato gaura maparara geria gekilagirato. ");
INSERT INTO khz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Na Parisea golea na Iesu gekamonagi-veniawai talimara reketa geruga-itito, gekilato, “Ati Iuda talimara maki tauniparara kopira pia voro-vagira, e pio vaikilara, Mose gena rova pia kwalanaa.” ");
INSERT INTO khz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ne apostolo e ekalesia gegita-tagoawai talimara getanu-kouto, voverenagi gevega-vetovoato. ");
INSERT INTO khz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Rauvagi gekilagiato mulinai, Petero ekuliitito, ekilato, “Walakavaku maparami, gomi ripami, rauvagi-vegata gomi aomi na Palagu na au egapi-itikuto, ati Iuda talimara geria Vali Namana pana kilagia, pe ira maki pia kamonagi e pia vega-taunatauna. ");
INSERT INTO khz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Etaunilimalima aora eriparana Palaguna na ati Iuda talimara Veaga Palaguna evenirato, ita evenirato vetaina. Vokala genana evega-gitarana, ira maki egapi-ragerato. ");
INSERT INTO khz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ita e ira nuganugarai vega-iraura vetogana ati ekalaato, kwalana geria vega-taunatauna rorirai, Palagu na aora ealevarato. ");
INSERT INTO khz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ewagumona rakagau gaurai Palagu gokalatovoana, Iesu gekwalanaana talimara atarai metau gotaorana. Ita matotaura na e ita tenera na maki vomaruna vuavuana ati gegelegeleto gauna. ");
INSERT INTO khz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Aikina! Ita taripana, ita Iesu Velekou gena vega-nama rorinai, Palagu na evega-magulirana, ira maki vovetaina.” ");
INSERT INTO khz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Petero vovetaina ekilato aonai, tanukou talimara maparara ati gekilakilato. Ne Banabas e Paulo gekamonagirato, Palagu ira geriana vegailia irau vagira e nugapalevagi kalara kamura, Grik talimara nuganugarai ekalarato gaura, maparara gekilagirato. ");
INSERT INTO khz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ira gekila-gatuto vou, Teimiti ekilato, “Walakavaku maparami, iokamonagiku! ");
INSERT INTO khz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simona na ewagumona pekilagi-vealevaa, rakagau tovotovonai Palagu na ati Iuda talimara etugamagirato, ne ira nuganugara na pete ta evirigiato, ia arana pia gapia ulanana. ");
INSERT INTO khz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","E peroveta talimara geria kila ria pege gelegele-gitakau, kwalana evetaina getaloato, ");
INSERT INTO khz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Velekou ekilana: Eia mulinai au mapana vewaikule-wai, Davida gena numa, evua-kapuato gauna, pana kala-waia. Gekwara-lovolovoato gauna, pana kala-waia, e pana vega-rugaiti-waia. ");
INSERT INTO khz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kwalana taunilimalima reketa maki maparara na, e au araku gegapi-lakavoana talimara ati Iuda talimara maparara na, au, Velekou, pia tavuku ulanana. ");
INSERT INTO khz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Velekou na egaura maparara pene vega-walara. Rauvagi-vegata e kala evega-matagairato.’ ");
INSERT INTO khz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Gaura pakurai au atugamagina, ati Iuda talimara gevetugamagi-waina Palagu genai ragaina pita veagaokaa. ");
INSERT INTO khz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Na pepa ta pita taloa, pita vaikilara, kaivakuku gevega-namagirana ganiganira ragaina pia ganira, kwalana opakau palagura gevenirana gaura; mata-poraga kalara ragaina pia kalara, e gaagora na gepito-materana ramaramara ragaina pia ganira e ralara ragaina pia gani. ");
INSERT INTO khz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kwalana Mose gena rova rauvagi-vegata vanuga kamura mapararai gevopatagirana e Tapati tomara mapararai Iuda talimara geria rupu ai geagirana.” ");
INSERT INTO khz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ne apostolo e ekalesia gevaiawai talimara e ekalesia maparara geririwato, ira aora na marumaru reketa pia virigira, ne Paulo e Banabas ria Antiokai pia tugura. Ira na Iudas, arana ta Barasaba negetiiwai, e Sila gevirigirato. Ira walakava na gekuparage-kamurawai talimara. ");
INSERT INTO khz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Epepa ira ria getuguato: “Ai gomi walakavami kamonagi aonai, apostolo talimamai e ekalesia gegita-tagoana talimamai na gema vega-nama gatugu-watiana, gomi walakava kamonagi aonai ati Iuda talimami, Antiokai, Siriai, e Silisiai gotaluna talimami maparami gemi ai. ");
INSERT INTO khz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ai pagama kamonagi, eanana marumaru reketa gewatito, ne geria kila na gemi tugamagi gevega-vevilirato e gevega-aovoaovomito. Kwalana gevaikilamito, tauniparami kopira pio voro-vagira e rova pio kwalanaa. Na neira ne ati ai gemana gegapito kilara. ");
INSERT INTO khz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Gaura pakurai, gema tanukou ai, ai maparamai na gavega-taunataunaato, marumaru reketa paia virigira, pe paia tugu-watira, gema raramani talimara Banabas e Paulo ria pia wati. ");
INSERT INTO khz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ira geria maguli kwavira ati gegapirato, getao-talirato, gera Velekou Iesu Keriso arana pakunai. ");
INSERT INTO khz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gaura pakurai, Iudas e Sila paga tugura, rakagau paga talora gaura ira matotaura murura na kilakilai gomi gemi ai pia vega-taunataunara ulanana. ");
INSERT INTO khz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Veaga Palaguna e ai gakilato, namana gomi atami ai metau ta ragai paia tao-kaua. Na evetaina kalaramo pio kwalanara: ");
INSERT INTO khz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Opakau palagura pa kaivakuku gevenirana ganiganira ragai pio gani; rala ragai pio gani; gaagora na gepito-materana ramaramara ragai pio ganira; e mata-poraga kalara ragai pio kala. Vogaura geriana pio laka-gerevagi genai, gomi pio nama. Pio talu.” ");
INSERT INTO khz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Gevirigirato talimara getugurato, Antiokai gelakato. Vonai kamonagi talimara maparara gevega-tanu-kourato vou, geria pepa gevenirato. ");
INSERT INTO khz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ira na vopepa geagiato aonai, geverere-rakavato, kwalana veveakava kilana gekamonagiato gaurai. ");
INSERT INTO khz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iudas e Sila, ira matotaura peroveta talimara. Ira taura ruala na walakava geria kila vogo gekilagirato, gevega-tiligarato, e gelaunagirato. ");
INSERT INTO khz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Toma reketa vonai getaluto mulinai, mamainora ria walakava na getugu-waikulerato, getugurato talimara geriai.  ");
INSERT INTO khz_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Na Sila eririwato Antiokai pene talu vou. ");
INSERT INTO khz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulo e Banabas Antiokai getalu-rauto, e talima gutuma ria Velekou gena kila gevevega-ripagiawai, e gevopatagiawai. ");
INSERT INTO khz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Toma reketa gevanagito mulinai, Paulo na Banabas evaikilaato, netiwato, “Taura ruala ita waikule-wai, Velekou gena kila tavopatagiawai vanugara mapararai, walakavara pita gitara, geria kamonagi magulina rakavetaina.” ");
INSERT INTO khz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas gena ririwa Ioane Mareko maki pia vaikaua, pe ira ria pia ago. ");
INSERT INTO khz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Na Paulo ati gena ririwa ia pia vaikaua, kwalana ia na Pamfiliai eraokwanirato, e ira ria ati geinaguluto pene ago geria inagulu ikanai. ");
INSERT INTO khz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Voia galamanai ira taura ruala geveitu-rakavato. Ne taura ruala geveraokwanito. Banabas na Mareko evaiato, poti ai gerageto, ne Saipras ai geagoto. ");
INSERT INTO khz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","A Paulo na Sila evirigiato. Walakava na Velekou gena vega-nama vevega-namana gevenirato mulinai gelakato. ");
INSERT INTO khz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Siria e Silisia tanora na gelaka-vanagito, ne ekalesia goleara vonai gevega-tiligarawai. ");
INSERT INTO khz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulo voanana evanagito Derebe ai eve kwarato, ne voanana eagoto Listerai eve kwarato. Listerai Iesu gekwalanaawai talimana ta etaluwai, arana Timoteo. Timoteo tinana Iuda garena, ia maki ekamonagiwai garena, na tamana Grik talimana. ");
INSERT INTO khz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Walakava maparara Listerai e Ikoniai Timoteo talima namanai gekilagiawai. ");
INSERT INTO khz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulo eririwato Timoteo pene vaikaua, pe ia goti pia laka, gaura pakurai, ia tauniparana kopina evoro-vagiato. Vovetaina ekalato, kwalana vonai getaluwai Iuda talimara maparara riparia, Timoteo tamana Grik talimana. ");
INSERT INTO khz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Vanuga rorira na gevanagiwai aonai Ierusalemai getaluwai apostolora e ekalesia kuneagira talimara na gevega-taunataunarato kilara kamonagi talimara geria gekilagirawai, ira na pia kwalanara ulanana. ");
INSERT INTO khz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ne ekalesia talimara geria kamonagi geveakwalimurato, e toma mapararai ekalesia gegutumawai. ");
INSERT INTO khz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulo mataukavana ria Frikia e Galatia tanora aora na tipo gelaka-vanagito kwalana Veaga Palaguna na ekila-wairato, Asia tanorai Palagu gena kila ragai pia kilagia. ");
INSERT INTO khz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misia tanona vetoganai gekwarato, ne Bitinia tanonai ia laka-toga negetiwato, na Iesu Palaguna ati eririwato ira voanana pia ago. ");
INSERT INTO khz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Gaura pakurai Misia na gevanagito, Troas vanuganai geve kwarato. ");
INSERT INTO khz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Vopogi Paulo emata-vanagito. Ia na Makedonia talimana ta rugatago egitaato, ia enogiawai, netiwato, “Makedoniai ono vogomai, ono mai-veakavamai.” ");
INSERT INTO khz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulo na vomata-vanagi egitaato mulinai, garaka-gapi-kavito, Makedoniai paia ago ulanana. Kwalana garipato, voo Palagu na ekeamaito, votaunilimalima geriai Vali Namana paia piaa ulanana. ");
INSERT INTO khz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Gaura pakurai Troas ai poti ai garageto, ne rorirori Samotrake mounai gaagoto. Vonai gamaituto, elaganiato vou Neapoli ai gaagoto. ");
INSERT INTO khz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Voanana kunina gaagoto, Filipi ai gakwarato. Filipi Makedonia tanonai vanuga kamuna tene vanugana, e Roma geria kapu. Vonai toma reketa gataluto. ");
INSERT INTO khz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tapati ai, vanuga kanana vanagina na galaka-piatito, wai ai gaagoto, ai gatugamagito, Iuda talimara geria rapali kapuna ta vonai. Ai gatanu-talito vonai vowai pipinai gatanu-kouto garera gavaikilarato. ");
INSERT INTO khz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Vonai ekamonagimaiwai garena ta arana Lidia, Taiatira garena. Ia rapuga voira kamura evoi-agirawai. Ia Palagu ealiruputali-veniawai garena. Ia Velekou na aona ekala-pakaato, ne Paulo na rakagau ekilagiawai ekamonagiato e egapi-rageato. ");
INSERT INTO khz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ia magena numa talimara ria bapatiso gegapito mulinai, ia na enogimaito, netiwato, “Pene gotugamagina au Velekou genai avega-taunataunana genai, ita ago, pe geku numai pita talu.” Ne, gaurai ia ria gaagoto. ");
INSERT INTO khz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Toma ta rapali kapunai gaagowai aonai, inagulu talimana ati voina vavinena taa na erawalimaito. Ia palagu rakavana taa na eporogiato, e wailai rakagau pia wala gaura ekilagi-matagairawai. Wailai pia wala gaura ekilagi-matagairawai aonai gitatagona talimara geria moni kamu vagi ekalarawai? ");
INSERT INTO khz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Vovavine Paulo e ai maparamai mulimai na evogomaito, ekogowai, evetaina ekilawai, “Etalima e Goloka Iwa Palaguna gena vetugunagi talimara! Vevega-maguli raka pio vaitiwaa rauparana valina gepiaana.” ");
INSERT INTO khz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Toma vogo vovetaina ekalawai, pene ago, Paulo eparuto, ne eruga-kuleto, vopalagu rakavana evaikilaato, netiwato, “Iesu Keriso aranai au na avaikilamuna, nevavine genana ono laka-vagi!” Ne veganamo palagu rakavana vovavine genana elaka-vagito. ");
INSERT INTO khz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Vovavine gitatagona talimara geripato, ira geria moni rawali rauparana eaikito, gaurana ira na Paulo e Sila gegapirato, rova taura geriai maketi kapunai geago-agirato. ");
INSERT INTO khz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kota gekamonagina talimara wailarai gevega-rugarato vou gekilato, “E Iuda talimara. Ira na ita gera vanuga kamunai rakava gevega-walaana. ");
INSERT INTO khz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","E ira na gevevega-ripagirana kalara ita gera rova na ati egapi-ragerana. Ita Roma talimara, ira geria kala ragaina pita gapi-ragera e ati pita kalara ripa.” ");
INSERT INTO khz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Taunilimalima gutuma para ira ria gekauto, Paulo e Sila gekulu-venirato. Ne Kota gekamonagina talimara na Paulo e Sila geria rapuga geralerato, ne vogutuma para gevaikilarato, pia kwarira. ");
INSERT INTO khz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Gekwari-pilupilurato mulinai, tipura numanai gepia-togarato, e tipura numana gitatagona talimana gevaikilaato, pene gitatago-namanamara. ");
INSERT INTO khz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ia na vovevega-nagi kilana ekamonagiato, ne tipura numana nuga tumakenai epia-togarato. Gagera mara kamura kwatu ruala e metaura vekarawarai geteini-talirato. ");
INSERT INTO khz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pogi nugana Paulo e Sila gerapaliwai e Palagu vega-ragena marira gemarirawai, tipura numana talimara reketa na gekamonagirawai. ");
INSERT INTO khz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Atilovana tanokepo kamuna ekwarato, tipura numana kwalana maguguluna maki eveakaveakato. Veganamo vanagi maparara gevekala-pakato, e tipura talimara geligorato teinira maparara geveluga-vagito. ");
INSERT INTO khz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tipura numana gitatagona talimana ekeroto, vanagi maparara egitarato vekalapaka. Gena tugamagi tipura talimara maparara gekaliatito netiwato, gaurai gena vetali kativana einu-vagiato, matotauna ene vekwanu-mate netiwato. ");
INSERT INTO khz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Na Paulo na egagata-veniato, netiwato, “Matotaumu ragai ono vevega-rakava! Ai maparamai ea!” ");
INSERT INTO khz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tipura numana gitatagona talimana kere ekeagito, elaka-togato, mapilupiluna Paulo e Sila gagera kwalarai eveketo-talito. ");
INSERT INTO khz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ne voanana evaipiatirato e erenagirato, netiwato, “Velemi, au rakagau pana kala vou maguli pana rawalia?” ");
INSERT INTO khz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ira na gevega-geleato, negetiwato, “Iesu Velekou pono kamonagi-venia, ne maguli pono vaia, goi e gemu numa talimara maparara.” ");
INSERT INTO khz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ne ira na Velekou gena kila, ia magena numa talimara maparara geria gekilagito. ");
INSERT INTO khz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Vopogi nugana oranaimo, tipura numana gitatagona talimana na taura ruala evaiagorato, makora eve guligirato, e ia magena numa talimara maparara gebapatisorato. ");
INSERT INTO khz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Voia mulinai ia na Paulo e Sila gena numai evaiagorato, ne ganigani evenirato, geganito. E ia magena numa talimara ria verere na gevonuto, kwalana ira ewagumona Palagu genai gevega-taunataunana. ");
INSERT INTO khz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Amoamo, Kota gekamonagina talimara na vetugunagi talimara getugurato, negetiwato, “Tipura numanai votalima ruala iove tugu-atira.” ");
INSERT INTO khz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ne tipura numana gitatagona tauna na Paulo evega-ripaato, netiwato, “Kota gekamonagina talimara na kila pege tugua, goi e Sila paia tugu-atimi nepegetiwa. Gaura pakurai iolaka-piati mamainomi.” ");
INSERT INTO khz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Na Paulo na vetugunagi talimara evaikilarato, netiwato, “Ai Roma talimamai, na ira na taunilimalima gutuma para wailarai ai tipo gekwari-kawamaito, gema rakava ati getavuato, na tipura numanai gepia-togamaito. Ewagumona veavugai ia tugu-atimai negetina? Aikina kinavagi! Ira matotaura enai pia vogomai, ne ai piama gapi-atimai.” ");
INSERT INTO khz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ne vetugunagi talimara na vokila Kota gekamonagina talimara gevaikilarato. Ira gekamonagito Paulo e Sila Roma talimara gaurai gekalito. ");
INSERT INTO khz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Gaurai geagoto, Paulo e Sila genogirato, geria rakava pia tugamagi-piatogara. Ne ira taura ruala tipura numa na getugu-atirato, e genogirato, vovanuga kamuna pia raokwania. ");
INSERT INTO khz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paulo e Sila na tipura numana geraokwaniato, Lidia gena numai geagoto. Vonai walakava ria geverawalito, ne vevega-tiliga kilara na geveakwalimurato, ne gelakato. ");
INSERT INTO khz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulo e Sila na Amfipoli e Apolonia gelaka-vanagiato, pene ago Tesalonikai gekwarato. Iuda talimara geria rupu ta vonai. ");
INSERT INTO khz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulo ekalawai vetaina rupu ai elaka-togato. Tapati tomara toitoi aorai, ia taunilimalima ria Puka Veaga kilara gekilagi-kilagirato. ");
INSERT INTO khz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ira geria ekilagi-vealevaawai, e evega-taunataunaawai, Keriso pene vitiviti e kwarega na mapene kuliiti-wai. E ekilato, “EIesu, valina gomi gemi apiaana talimana, Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna).” ");
INSERT INTO khz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Iuda talimara reketa na vokila gevega-taunataunaato, ne Paulo e Sila ria gekwapunato. E Palagu gealiruputali-veniawai Grik talimara gutuma kamu vagi e vanugai geria raki kamu garera gutuma maki ira ria gekauto. ");
INSERT INTO khz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Na Iuda talimara gemunemuneto, gaurai voivoi kapunai karoverave iwavagi talimara reketa gegapi-koukourato, karoverave goleana ta pia tinaa negetiwato. Gaurai ira na veineveine e galama kamuna vanuga kamuna aonai gekalaato. E Iason gena numa gerageato, Paulo e Sila pia rawalira, pe taunilimalima wailarai pia vaiatira ulanana. ");
INSERT INTO khz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Na ati gerawalirato, gaurai Iason e walakava reketa gevaiagorato, vanuga gitatagona taura wailarai, gekogowai gekilato, “Tanopara mapararai etalima na rakava gevega-walarana, ewagumona enai pege vogomai, ");
INSERT INTO khz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ne Iason na gena numai egita-tagorana. Ira na Kaisara gena rova gekilagi-piatogaana, kwalana gekilana, vele kamuna ta moe negetina. Gekilana, vovele arana Iesu.” ");
INSERT INTO khz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Vanuga talimara e gitatagona talimara na vokila gekamonagiato aonai, geria aovoaovo ekamuto. ");
INSERT INTO khz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ne ira na Iason mataukavana ria tipo gevega-painerato ne getugu-lakarato. ");
INSERT INTO khz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Epogiato aonai veganamo walakava na Paulo e Sila Bereai geraka-tugu-lakarato. Bereai geve kwarato aonai geagoto, Iuda talimara geria rupu ai. ");
INSERT INTO khz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea taunilimalima namara, ati Tesalonika talimara vetaira. Ira na Palagu gena kila gekamonagiawai aonai, geririwa-kamuawai. E toma mapararai Puka Veaga aonai Paulo na rakagau ekilagiawai gauna getavuawai. Kwalana geririwawai pia ripa, Paulo na rakagau ekilagiawai kilara taunatauna pa, pia vega-taunataunara ulanana. ");
INSERT INTO khz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Iuda talimara gutuma Iesu Keriso gevega-taunataunaato; e Grik garera kamukamura reketa na e Grik marumarura gutuma maki Iesu Keriso gevega-taunataunaato. ");
INSERT INTO khz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Na Iuda talimara Tesalonikai gekamonagito, Paulo Bereai Palagu gena kila evopatagiawai. Gaurai geagoto, vanuga talimara aora geganirato e gekila-paru-ragerato. ");
INSERT INTO khz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ne Paulo veganamo walakava na kone ai getugu-lakaato; a Sila e Timoteo Bereai getaluto. ");
INSERT INTO khz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paulo gekwaruato taura na geago-agiato pene ago Atena. Voanana magewaikuleto Bereai. Ira gewaikuleto aonai Paulo gena kila keakau kilana ta maki geago-agiato, ekilato, Sila e Timoteo ia genai pia ago vega-veleke netiwato. ");
INSERT INTO khz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Atenai, Paulo na Sila e Timoteo ealo-tagorawai aonai, vovanuga kamuna egitaato kaivakuku na gevega-vonuato. Gaurai ia aona emetau-rakavato. ");
INSERT INTO khz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Gaura pakurai ia eagoto Iuda talimara geria rupu ai, Iuda talimara e ati Iuda talimara Palagu gealiruputali-veniawai talimara ria gekilakilato. E toma mapararai maketi ai gelaka-matagaiwai talimara evega-vegupurawai. ");
INSERT INTO khz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Vevega-ripa taura iraura, geria golea gekilagirawai Epikurea e Stoiki, na Paulo gerawaliato, ne gevega-veituato. Ira reketa geverenagito, negetiwato, “E muru-papo rakagau ekilagina?” Mareketa gevega-geleto, negetiwato, “Ia ema no palagu iraura ekilagirana.” Ira vovetaina gekilato, kwalana Paulo Iesu e gena kuliitiwai valina evopatagiawai. ");
INSERT INTO khz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ira na Paulo gegapiato, Areopakas golonai geago-agiato, kaonsela getanu-kouwai kapunai. Ne vonai gevaikilaato, negetiwato, “Ai gaririwana aia ripa, evevega-ripa valiguna okalaana erakagau okilagiana? ");
INSERT INTO khz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Goi na kila taarana okilagirana ai na ati gakamonagirana gaura, gaurai ai gaririwana ganira paia ripara.” ");
INSERT INTO khz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kwalana Atena talimara maparara e irau kapu talimara vonai getaluna inagulu ta ati gekalaawai, na ira geria kala kwapuna toma mapararai tipo vokila valiguramo gekilagirawai e gekamonagi-tagorawai. ");
INSERT INTO khz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ne Paulo na Areopakas tanukouna aona na erugaitito, ne evaikilarato, “Atena talimami! Au na gomi agitamina, gomi gemi palagu geriai goveraramani-taunataunana. ");
INSERT INTO khz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kwalana gemi vanugai alaka-loulouna e gemi aliruputali kapura agitarato aonai au na pata veagana ta agitaato, atanai ekila getaloato, ‘ATI RIPAMAI PALAGUNA GENA.’ Gaura pakurai voati ripami Palaguna, gomi na goaliruputali-veniana eewagumona au na avega-ripamina. ");
INSERT INTO khz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tanopara e tanopara aonai gemiana gaura maparara ekalarato Palaguna kupa e tanopara velena. Ia talima gimara na gekalarato rupu veagarai ati etaluna. ");
INSERT INTO khz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ia gau kwautai ati eraputo, pe talima gimara na ia gena ati pia kalaa ripa. Ia matotauna na talima maparara maguli evenirana, agila e gau maparara evenirana. ");
INSERT INTO khz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Talima kwapuna genana ia na taunilimalima petera maparara evega-walarato, e tanopara maparana pia talu-agia netiwato. Ia matotauna na geria maguli rigolora e geria talu kapura taunatauna enavuga-kunerato. ");
INSERT INTO khz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Palagu na vovetaina ekalaato, kwalana ia pia gita-vetavua ulanana; e pia tavu-tiligatiligaa, ne pia rawalia. Pa, Palagu e ita kwapurakwapura vepakara ati rau. ");
INSERT INTO khz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Kwalana ita ia pakunai tamagulina, takalavo-kalavona e roe ata magulina.’ Gemi mari getovona e gegavutinamina taura na gekilagiato vetaina, negetiwato, ‘Ita maki ia natuna.’ ");
INSERT INTO khz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ita Palagu natuna gaurai, ragai pita tugamagi, Palagu kolo, siliva, pa vatu, taunilimalima geria navugai e ripai gekenerato gaura vetaira. ");
INSERT INTO khz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kunenai taunilimalima ati geria ripa rorirori gaurai, Palagu na vogaura egita-guilagirato. Na ewagumona ia na taunilimalima maparara kapu mapararai evaikilarana, pia vetugamagiwai. ");
INSERT INTO khz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kwalana ia na toma ta ekilagi-gavuato, votomai gena gapiiti talimana na tanoparai veagirori pene kalaa marorirorina na. Palagu na votalima evega-taunataunaato taunilimalima maparara wailarai, vegailiana kwarega na evega-kuliiti-waiato.” ");
INSERT INTO khz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kwarega na kuliitiwai kilana gekamonagiato aonai, reketa na Paulo gemamai-agiato. Reketa gekilato, “Ai gaririwana vovali gema maono kilagi-waia.” ");
INSERT INTO khz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ne Paulo na votanukou eraokwaniato. ");
INSERT INTO khz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Na marumaru kikalua ia genai gelakakauto e Palagu genai gevega-taunataunato. Ira aorai Dionisio, ia Areopakas golonai getanu-kouwai talimana ta, e gare ta arana Damari, e talima reketa maki. ");
INSERT INTO khz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Voia mulinai Paulo na Atena eraokwaniato, Korinto ai elakato. ");
INSERT INTO khz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Vonai ia na Iuda talimana ta arana Akwila erawaliato. Akwila Pontas ai ewalato. Ia garawana Prisila goti Itali na gekwarato. Ira Italina gevogomaito, kwalana Klaudias na Iuda talimara maparara evaikilarato, Roma pia raokwania. Paulo eagoto ira geriai, eve gitarato. ");
INSERT INTO khz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ia maki Akwila magarawana ria vetaira palai numara getuliwai. Gaura pakurai Paulo vonai ira ria getaluwai e geinagulu-koukouwai. ");
INSERT INTO khz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Tapati mapararai Iuda talimara geria rupu ai evopatawai, Iuda e Grik talimara aora ene gapira ulanana. ");
INSERT INTO khz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila e Timoteo Makedonia na gekwarato aonai, Paulo Palagu gena kila evopatagiawai toma mapararai, Iuda talimara geriai ekila-matagaiawai, Iesu ia taunatauna Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna). ");
INSERT INTO khz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Na Iuda talimara na Paulo gena kila gevega-waiato, ekila ati namara genai gevevega-veitu-agirawai gaurai, Paulo gena rapuga ekwara-lagiato ira wailarai voupe evaikila-gaokarato, netiwato, “Gomi ralami kepina matotaumi atami ai! Au geku ai kepi ta aikina. Ewagumona au aagona ati Iuda talimara geriai.” ");
INSERT INTO khz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ne vorupu na elaka-piatito, eagoto, ati Iuda talimana ta arana Titio Iusto gena numai. Titio Palagu ealiruputali-veniawai talimana, gena numa rupu lagana kianai. ");
INSERT INTO khz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispo, rupu kuneagina talimana e gena numa talimara maparara ria Velekou gekamonagi-veniawai. E Korinto talimara gutuma na maki vali gekamonagiato, ne gevega-taunataunaato e bapatiso gegapiato. ");
INSERT INTO khz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pogi ta aonai Velekou na Paulo nivi-akau ai evaikilaato, netiwato, “Ragai pono kali, murumu ragai pene kapu, pono kila! ");
INSERT INTO khz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kwalana au goi goti gaurai; taa na ati pene wati-venimu e ati pene vega-rakavamu ripa, kwalana au geku taunilimalima gutuma evanuga kamunai.” ");
INSERT INTO khz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Gaura pakurai Paulo vonai etaluto rigolo kwapuna e uve taula toitoi; Palagu gena kila taunilimalima evega-riparawai. ");
INSERT INTO khz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio ia Akaia tanona kavana na aonai, Iuda talimara gegalu-kouto, Paulo gegapiato, Kota kapunai geago-agiato. ");
INSERT INTO khz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Gekilato, “Etalima na taunilimalima aora eganirana, e rova na ati ekilagiana rauparanai Palagu pia aliruputali-venia netina.” ");
INSERT INTO khz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paulo ene kila netiwato aonai, Galio na Iuda talimara evaikilarato, netiwato, “Gomi Iuda talimami, pere kala rakavana taai pa kepi kamuna taai pogoro tamania genai para kamonagi-venimi ripa. ");
INSERT INTO khz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Na ne veitu e vevega-ripa, e ara, pe matotaumi gemi rova veitura, gaurai matotaumi na pio kala rorirorira. Au evetaira gaura Kotai ati pana kamonagira!” ");
INSERT INTO khz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gaurai ia na Kota kapuna na egui-atirato. ");
INSERT INTO khz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ira maparara na rupu kuneagina talimana, Sostene, gegapiato, Kota kapunai ne gekwari-korukoruato. Galio na egitarato na eali-guilagito. ");
INSERT INTO khz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo Korinto ai walakava kamonagi aonai taunilimalimara ria toma kiata vogo magetaluto. Voia mulinai eraokwanirato, ne Prisila e Akwila ria poti taa na Siriai geravuto. Kenkrea na rogoti na gere ravu aonai, ia repana geraloato, kwalana gena kilagavu gaokana ta Palagu genai ekalaato gaurai. ");
INSERT INTO khz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Epeso ai gekwarato, ne Paulo na Prisila e Akwila vonai eraokwanirato. Ia Iuda talimara geria rupu ai elaka-togato ne Iuda talimara ria geve kilakilato. ");
INSERT INTO khz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ira na genogiato, vonai Iuda talimara ria pia talu vou, na geria noginogi ati egapi-rageato. ");
INSERT INTO khz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na evega-nekarawai aonai evetaina evaikilarato, netiwato, “Pene Palagu pene ririwa genai, gomi gemi ai mapana waikule-wai.” Ne poti ai eve ragekauto, Epeso eraokwaniato. ");
INSERT INTO khz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kaisareai ekwarato aonai, gagena na Ierusalemai everageto, ekalesia ria geve verawalito vou, Antiokai everigoto. ");
INSERT INTO khz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Toma reketa vonai etaluto mulirai, Galatia e Frikia tanorai eagoto, Iesu gekwalanaawai talimara maparara kapu kwapurakwapurai getaluwai talimara eve veakwalimurato. ");
INSERT INTO khz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Voorai Iuda talimana ta arana Apolos, Alesandria ai ewalato talimana, Epeso ai eagoto. Ia gena ripa kamu vagi, kilakilai nama vagi e Puka Veaga maki eripa-vealevaato. ");
INSERT INTO khz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ia Velekou gena raupara gevega-ripaato, ne maaona maparana na Iesu valina epiaato, evevega-ripagi-vealevaato. Gau kwatunamo, ia Ioane gena bapatisomo eripaato. ");
INSERT INTO khz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Rupu aonai evopatawai matiligana. Vonai Prisila e Akwila na gekamonagiato, ne gevaikauato, ira na talu numanai gevaiagoato, vonai vou Palagu gena raupara taunataunana gevega-ripa-namanamaato. ");
INSERT INTO khz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ne Apolos eririwato, Akaiai pene ago. Gaura pakurai walakava Epeso ai talimara na geveakavaato, e pepa getaloato Akaiai Iesu gekwalanaawai talimara geriai, genogirato, Apolos eagona aonai pia gapi-ragea. Apolos ekwarato aonai Palagu gena vega-nama genana Palagu gevega-taunataunato talimara veveakava Apolos genana gerawalito. ");
INSERT INTO khz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Kwalana gena kila tiligatiligana na Iuda talimara evega-ketorato taunilimalima gutuma wailarai, Apolos na Puka Veaga na geria evega-taunataunaawai Iesu ia Keriso, (Palagu na ekilagi-gavuato vevega-maguli tauna). ");
INSERT INTO khz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolos Korinto ai etaluwai aonai, Paulo kuni kavana na eagoto pene ago Epeso ai eve kwarato. Vonai Iesu gekwalanaawai talimara taarana erawalirato, ");
INSERT INTO khz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ne erenagirato, netiwato, “Iesu genai govega-taunataunato aonai, Veaga Palaguna gogapiato pa?” Ira gevega-geleto, negetiwato, “Aikina, ai Veaga Palaguna maki etaluna kilana ta rogotina gara kamonagia.” ");
INSERT INTO khz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ne Paulo na maerenagirato, netiwato, “Gomi raka bapatiso gogapiato?” Ira gevega-geleto, negetiwato, “Ioane gena bapatiso.” ");
INSERT INTO khz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ne Paulo ekilato, “Ioane rakava geriana gevetugamagi-waito talimara ebapatisorato, e Isaraela talimara evaikilarato, ia mulina na pene vogomai talimana pia kamonagi-venia, ia voo Iesu.” ");
INSERT INTO khz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Vokila gekamonagiato aonai, Velekou Iesu aranai bapatiso gegapiato. ");
INSERT INTO khz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulo gimana ira atarai etao-kaurato aonai Veaga Palaguna emarigoto ira atarai. Ne karo irauirau ai gekilato, e Palagu na ira geriai evega-matagairato kilara valira gepiarato. ");
INSERT INTO khz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Talimara maparara gagalana ruala vetaira. ");
INSERT INTO khz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paulo vonai etaluto uve toitoi. E vanagivanagi rupu ai elaka-togawai, Palagu gena Basileia, (gena vegitatago tiavuna evega-rugaana ea), evopatagiawai matiligana e taunilimalima ria na gekilagiawai e aora eganirawai. ");
INSERT INTO khz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Na taarana aora vekanagavu, gaurai ati gekamonagi-veniato, e taunilimalima gutuma wailarai Velekou gena raupara atanai kila-rakavara gekilagito. Gaura pakurai Paulo na eraokwanirato, Iesu gekwalanaawai talimaramo evaikaurato, ne toma mapararai Tirano gena vevega-ripa numanai evega-riparawai. ");
INSERT INTO khz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Rigolo ruala vovetaina ekalato, vovetainai gaurai Asia tanonai getaluwai Iuda talimara e Grik talimara maparara na Palagu gena kila gekamonagiato. ");
INSERT INTO khz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Palagu na Paulo genana kala irau vagira ekalarato. ");
INSERT INTO khz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ia na einagulu-agirawai mukora e eligorawai rapugara viti talimara geriai gegapi-agorawai aonai geria viti genamawai, e palagu rakavara ira geriana gelaka-vagiwai. ");
INSERT INTO khz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Iuda talimara reketa vonai gelakavowai e palagu rakava gegui-atirawai taura na maki Velekou Iesu arana gevatoato palagu rakavara na geporogirato talimara atarai. Palagu rakavara gevaikilarato, negetiwato, “Paulo na evopatagiana talimana Iesu aranai avaikilamina, iolaka-vagi.” ");
INSERT INTO khz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Skeva, Iuda geria Rupu Veaga velena kamuna ta, natuna melora taulatoi kwapuna vovetaina gekalawai. ");
INSERT INTO khz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ne toma ta palagu rakavana na evaikilarato, netiwato, “Iesu au ripaku, e Paulo maki ripaku, na gomi raira?” ");
INSERT INTO khz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Gaurai palagu rakavana na eporogiato talimana na tauria taulatoi kwapuna ekulu-venirato, e ekwari-korukorurato. Evagi-rakavarato, ne vonuma na gema kaliatito kopira kovagora e maralara. ");
INSERT INTO khz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Epeso ai getaluwai talimara, Iuda e Grik talimara maparara, na vovali gekamonagiato aonai, gekali-rakava-rakavato, e Iesu Velekou arana gevega-ragekamuato. ");
INSERT INTO khz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Iesu gevega-taunataunaato talimara vogo gevogomaito, ne gutuma wailarai geria kala rakavara gekilagi-matagairato. ");
INSERT INTO khz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Megamega talimara gutuma geria mega pukara gevua-koukourato, ne taunilimalima maparara wailarai gekapurato. Vopuka voira getao-kourato siliva monira ragana gagala imaima 50,000. ");
INSERT INTO khz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ekala tiavura gewalato geriana Velekou gena kila eraka-lovolovoto, e ekamuto matiavuna. ");
INSERT INTO khz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Vogaura mulirai Paulo aonai etugamagito, Makedonia e Akaia tanora na pene vanagi Ierusalemai. Ekilato, “Voanana pana ago mulinai, Roma maki pana gitaa.” ");
INSERT INTO khz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Gaurana Timoteo e Erastas, ia geveakavaawai talimara ruala, Makedoniai etugurato, a ia Asia tanonai kiata etalu-rauto. ");
INSERT INTO khz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Votomamo aonai Epeso ai veineveine kamuna ewalato, kwalana Velekou gena Raupara pakunai. ");
INSERT INTO khz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Vonai siliva einagulu-agirawai talimana ta arana Demetrio, ia na palagu garena arana Diana gena rupu kamuna gitagitana gelegelenai rupu girigirira siliva na ekalarawai. Voanana gena inagulu talimara moni polura kamu iwavagi gerawalirato. ");
INSERT INTO khz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Gaurai Demetrio na ira maparara, e ira geria inagulu vetaina talimara ekea-koukourato, evaikilarato, netiwato, “Marumaru, gomi ripami ita gera moni einaguluna evogomaina. ");
INSERT INTO khz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ewagumona gomi matotaumi na gogitaana e gokamonagiana, etalima Paulo na rakagau ekalaana. Ia ekilana, taunilimalima gimara na gekalarana palagura ati palagu, e ia na taunilimalima gutuma para aora eganirana, evaipakarana, ati Epeso aimo, na Asia tanona maparanai maki. ");
INSERT INTO khz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","E ati ita gera inagulu namana aranamo evega-rakavaana, na palagu garena kamuna, Diana, gena rupu maki ati ganinai pia vega-agoa, e Diana goloka-iwa ati mapia vevato-agia; pa, e palagu garena Asia talimara e tanopara maparana na gealiruputali-veniana.” ");
INSERT INTO khz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Vokila gekamonagiato aonai, geparu-rakavarakavato, e gekogoto, gekilato, “Epeso palaguna Diana goloka-iwa!” ");
INSERT INTO khz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ne vogarulugarulu erageto gauna na vovanuga kamuna maparana aovoaovo na eraka-lovaato. E Paulo ria gelakavowai Makedonia talimara ruala, Gaius e Aristakas, gegapirato, ne moalemoale kapunai gerolo-agorato. ");
INSERT INTO khz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo gena ririwa taunilimalima gutuma para wailarai pene laka-piati, na Iesu gekwalanaawai talimara ati geririwato, ne geruga-gavuato. ");
INSERT INTO khz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia velera reketa Paulo gatana. Ira na maki gena kila getuguto, genogiato, moale kapunai ragai pene matagai. ");
INSERT INTO khz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Votanukou aonai aovoaovo ati keikeina ewalato, kwalana taunilimalima maparara gelailaito gekogoto e gekeakeato. Gelailaiwai e gekeawai aonai, reketa kila reketa gekilagirawai, mareketa kila polura reketa gekilagirawai, kwalana taunilimalima gutuma ati riparia rakagau ulanana gegalu-kavito. ");
INSERT INTO khz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Iuda talimara na Alesanda vogutuma para aona na getugu-atiato, taunilimalima wailarai eve rugato, Iuda talimara atarai pene kila ulanana. Gaurai Alesanda gimana na taunilimalima elao-talirato ragai pia kilakila. ");
INSERT INTO khz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Na gegitailiaato, ia Iuda talimana gaurai, maparara veganamo kila kwapunamo gekeagiwai-keagiwaiawai, negetiiwai, “Epeso palaguna, Diana, goloka-iwa!” ");
INSERT INTO khz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Vanuga gena talotalo tauna pa klak votaunilimalima gutuma evega-rawarato, ne netiwato, “Epeso talimami, taunilimalima maparara riparia, Epeso Diana palagu garena kamuna gena rupu gitatagona vanugana, e kupa na vatu veagana Diana gelegelenai gauna eketo-piarigoto gitatagona vanugana maki. ");
INSERT INTO khz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Talima taa na egaura ati pene kilagi-veavugara ripa. Gaura pakurai ragaina ioveineveine, ragaina iokala-kawakawa. ");
INSERT INTO khz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Etalima na rupu gauna ta ati pege lemaa, e gera palagu garena genai maki kila rakavana ta ati pege kilagia, na gomi na enai pogo vogomai-agikawara. ");
INSERT INTO khz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pene Demetrio magena inagulu talimara ria mageria paru talima ta genai, ita magera kavana, gera Kota tomara vekalapaka. Vonai vou pia vega-rorirorira. ");
INSERT INTO khz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pene goririwana gau ta mapio kilagia genai, rova na evega-taunataunaato tanukounai vou pia kilagia. ");
INSERT INTO khz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ewagumona rakagau pewala ganina pia renagira genai, ita pita kepi. Kwalana eveineveine kamuna pata kalaa ati ganina ta, gera galukavi kawa ganina ati pita kilagia ripa.” ");
INSERT INTO khz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ekila-gatuto mulinai, gegalu-kavito talimara etugu-lovolovorato. ");
INSERT INTO khz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Voaovoaovo aonai gekogowai, gelailaiwai, gauna enotuto mulinai, Paulo na Iesu gekwalanaawai talimara ekea-kourato; ne evega-tiligarato mulinai, evega-nekarato. Ne ia elakato Makedoniai. ");
INSERT INTO khz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Vokapu aora na elaka-vanagiwai aonai, kila vogo ekilagito, taunilimalima evega-tiligarawai. Voanana eagoto pene ago, Grik ai ekwarato. ");
INSERT INTO khz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Vonai uve toitoi etaluto. Poti na Siriai pene ago ulanana egapi-kaviwai aonai ekamonagito, Iuda talimara na ia pia vagia navugana getovoawai. Gaura pakurai Makedonia aonana pene waikule-wai netiwato. ");
INSERT INTO khz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Talima reketa na ia gekwaruato, talimara ea: Sopata Piro, Berea talimana; Aristakas e Sekundo, Tesalonika taura; Gaius, Derebe talimana; Tikikas e Trofimas, Asia taura; e Timoteo. Ira na gekwaruato, Asia ai geagoto. ");
INSERT INTO khz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ira gelaka-kuneto, Troas ai vou ai geve alomaito. ");
INSERT INTO khz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Na ai Ati Egorona Paraoana Velekwana eaikito mulinai vou, Filipi garaokwaniato. Toma imaima geaikito vou, ira geriai Troas ai gakwarato, gaverawalito. Vonai toma taulatoi kwapuna gataluto. ");
INSERT INTO khz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Epetoma toma tovotovonai pa Sandei ai galaka-koukouto ganikou paia gania ulanana. Ne Paulo na volavilavi taunilimalima evopata-venirato, pene ago, pogi nugana, kwalana pene lagania ia pene laka gaurai. ");
INSERT INTO khz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Vonuma kukuna kovoganai gatanu-kouto, lamepa vogovagi geveagalarato. ");
INSERT INTO khz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Malaga valigu ta arana Eutiko pokeilu ai etanuto. Paulo gena kila emoga-agowai gaurai, Eutiko matana eputeputeto ne emaitu-verakwato. Ne vonuma kukuna ragea vega-toitoina na evegapi-rakato pene ago kwano ai. Geve gapi-itiato aonai ia kwaregana. ");
INSERT INTO khz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Na Paulo eraka-rigoto, Eutiko atanai epavukauto, evuato, netiwato, “Nugami ragai pia golugolu, ia magulina!” ");
INSERT INTO khz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Voia mulinai numa kukunai maeverageto, e paraoa epuki-kavalugaato, geganito. Ne gena kila maetilivuato, pene ago elaganiato, ne elakato. ");
INSERT INTO khz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Tanukou talimara na vomalaga valigu gevaiato, ne mavererera gelakato. ");
INSERT INTO khz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ai poti na Aso ai garavu-kuneto, na Paulo vonai vou paia ura-kaua. Paulo na vovetaina evaikilamaito, kwalana ia gagena na pene laka-vanagi netiwato. ");
INSERT INTO khz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aso ai ema rawalimaito, ne gaura-kauato, Mitilene ai garavuto. ");
INSERT INTO khz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Voanana poti na garavuto pene ago elaganiato vou, Kioso tairagenai garai-talito. Votoma mulinai Samo ai gakwarato, toma ta evanagito vou, Miletas ai gakwarato. ");
INSERT INTO khz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulo eririwato, Epeso pia ravu vanagia, Asia tanonai toma reketa nege vega-aikirana kalinana, kwalana ia evailavailawai. Gena ririwa pene marauparana genai Ierusalemai pia kwara voupe Pentekoste tomana pene kwara, voo Pasova toma gagala imaima (50) mulinai. ");
INSERT INTO khz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paulo Miletas vanugana na Epeso ekalesia kuneagina talimara geria kila etuguato, evaikilarato, pia vogomai, ia ria piama verawali. ");
INSERT INTO khz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ira gema kwarato aonai, evaikilarato, netiwato, “Gomi ripami au toma mapararai gomi ria tataluwai aonai, rakavetaina ataluto, toma tovotovona na Asia tanonai ama kwarato vegata. ");
INSERT INTO khz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Toma vogo Iuda talimara geririwawai au pia vega-waiku, kala rakavara vogo au geku ai gekalarawai. Na aoku maomana e matagiku na Velekou vetugunagina aago-veniwai. ");
INSERT INTO khz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Gomi ripami, veakavagimi kilara maparara avega-ripamito, ta ati atao-togaato, gemi numai e gutuma wailarai avevega-ripawai aonai. ");
INSERT INTO khz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Iuda talimara e Grik talimara wailarai akila-matagaiwai, geria rakava geriana pia vetugamagiwai, Palagu genai pia waikule, e gera Velekou Iesu Keriso pia kamonagi-venia. ");
INSERT INTO khz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Au ewagumona Ierusalemai aagona, kwalana Veaga Palaguna na evega-nagikuna gaurai, e ati ripaku vonai geku ai rakagau pene wala. ");
INSERT INTO khz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Gau kwapunamo au ripaku Veaga Palaguna na vanuga kamura mapararai evega-ripakuna, au wailaku ai tipura numana e vitivitina gevealo-tagokuna. ");
INSERT INTO khz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Na au geku ai, au geku maguli ati atugamagi-kamuana, rakagau kalagina natina, geku ririwa kwapuna geku raka-vegalamo pana vega-gugulua, e voinagulu Velekou Iesu na evenikuto, pana kalaa netiwato inaguluna, pana vega-aikia. Voinagulu: Palagu gena vega-nama Valina Namana pana kilagi-matagaia. ");
INSERT INTO khz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Au gomi maparami nuganugami ai alakavo-lakavoto, Palagu gena Basileia, (gena vegitatago tiavuna evega-rugaana ea), gemi avopatagiato. A ewagumona au ripaku, taa na ati mapono gita waiku. ");
INSERT INTO khz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Gaura pakurai toma gomi wailami ai au akila-matagaina, pene gomi ta Palagu genana pene laka-lekwalekwa genai, vuavuana ati au geku ai. ");
INSERT INTO khz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kwalana Palagu gena ririwa maparana avega-ripamito, girina kiata vagi ati akilagi-taotogaato. ");
INSERT INTO khz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Matotaumi rogomi pio vetole, e mamoe lavetana rogora pio tolera. Ne mamoe lavetana ne Veaga Palaguna na evenimito pio gita-tagora ulanana. Palagu gena ekalesia pio gita-tagoa e pio kune-agia. Ne ia Natuna ralana na evoiato. ");
INSERT INTO khz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Au ripaku, au pana laka muliku ai uraura kwaevara rakavara gomi nuganugami ai pia laka-toga, ne mamoe lavetana pia vega-rakavaa. ");
INSERT INTO khz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Gomi matotaumi aomi na maki talima reketa pia kuliiti, ne opakau kilara pia kilagira, Iesu gekwalanaana talimara ira na pia rolo-gerevagira ulanana. ");
INSERT INTO khz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Gaura pakurai rogomi pio vetole! Pio vetugamagi-tago, au na rigolo toitoi vegata mataku matagina na, gomi agavutina pogimiwai e agavutina-laganimiwai. ");
INSERT INTO khz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ewagumona Palagu gimanai e gena vega-nama kilana aonai etaomina, ia na pene vega-ruga-rorimi gelegele, e voimi pene venimi evega-veagarato talimara maparara ria. ");
INSERT INTO khz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Au na ta gena siliva, pa kolo, pa rapuga ririwana ati akalaato. ");
INSERT INTO khz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gomi matotaumi ripami, au geku rapu e taukavaku geria rapu gaura maparara, egimaku ruala geria inagulu na arawalirawai. ");
INSERT INTO khz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Gaura maparara aorai au na avega-gitamiwai, au voinagulu tiligatiligana aoarana vou moiramoira talimara pita veakavara. Iesu Velekou gena kila pio tugamagi-tagoa, netiwato, ‘Veveni vererena kamu, a tarawalina vererena kei.’” ");
INSERT INTO khz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulo ekila-gatuto vou, ira ria getiu-talito, ne maparara gerapalito. ");
INSERT INTO khz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ira maparara getagi-rakavato, gevekapani-waloto, gevelavuato. ");
INSERT INTO khz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ira aora gevekwalavi-rakavato evetaina evaikilarato aonai, ekilato, ira na wailana ati mapia gita-waia. Ne poti ai geago-agiato. ");
INSERT INTO khz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ira ria gavevega-nekato, ne galakato. Rawapara na garavuto, rorirori pene ago Koso ai gakwarato; elaganiato vou Rodes ai garavuto, voanana garavuto Patarai. ");
INSERT INTO khz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Foenikiai pene ago potina vonai garawaliato, garagekauto, ne garavuto. ");
INSERT INTO khz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Gapoe-agoto Saipras gagitaato, ne waiatina (pa south) kavana na gavanagito, garavuto pene ago Siriai gakwarato. Taia vuapona na vou garigoto, kwalana vopoti rinagana vonai pia tao-rigora gaurai. ");
INSERT INTO khz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Iesu gekwalanaawai talimara reketa vonai garawalirato, ira ria epetoma kwapuna gataluto. Veaga Palaguna tiavuna na ira na Paulo gevaikilaato, Ierusalemai ragai pene ago. ");
INSERT INTO khz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Na gema laka tomana egapiato, ne galakato. Ira maparara magarawaria e manatura ria na vanuga kamuna na geago-agimaito kone ai. Ne ai maparamai gavetiutiu-talito, garapalito. ");
INSERT INTO khz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ira kwapurakwapura ria gavevega-nekato, ne ai poti kamunai garagekauto, na ira voanana gewaikuleto geria numai. ");
INSERT INTO khz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Taia na garavuto Tolemais. Gema rawapara lakalakana ikana voa. Vonai walakava reketa ria gaverawalito, e gavega-namarato, ira ria toma kwapuna gagapiato. ");
INSERT INTO khz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Elaganiato, ne gagemai na galakato, gaagoto, Kaisarea ai gakwarato. Vonai evanelia talimana arana Filipo gena numai gaagoto, ia ria gataluto. Ia Ierusalemai talima taulatoi kwapuna gevirigirato talimana ta. ");
INSERT INTO khz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ia natuna vavinera vativati Palagu na peroveta warewarena evenirato. ");
INSERT INTO khz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Toma vogo vonai gataluto mulinai, peroveta talimana ta arana Akapas, Iudea na ema kwarato. ");
INSERT INTO khz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ia ai gemai evogomaito, Paulona peleta egapi-itiato, ne ia matotauna gagena e gimana eligorato, ne ekilato, “Veaga Palaguna evetaina ekilana, ‘Epeleta gatana Iuda talimara na Ierusalemai evetaina pia ligoa, ne ati Iuda talimara gimarai pia tao-kaua.’” ");
INSERT INTO khz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ekila gakamonagiato aonai, ai e vonai talima reketa ria Paulo ganogiato, Ierusalemai ragai pene ago. ");
INSERT INTO khz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Na ia evega-geleto, netiwato, “Rakagau tagina gokalaana au aoku govega-moiraana? Au kala-maavu, ati tipo Ierusalemai pia ligoku, na Velekou Iesu arana pakunai pana kwarega maki.” ");
INSERT INTO khz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ai ati gelegele ia paia gaoa gaurai, ia noginogina gavega-aikiato, ne gakilato, “Velekou gena ririwamo pene vekala.” ");
INSERT INTO khz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Toma reketa geaikito mulirai, gema rinaga gagapi-kavirato, ne Ierusalemai galakato. ");
INSERT INTO khz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Kaisarea ai getaluwai Iesu gekwalanaawai talimara reketa maki ai ria galakato. Ira na geago-agimaito, Nason, Saipras talimana, gena numai. Nason rauvagi-vegata Iesu ekwalanaawai talimana. ");
INSERT INTO khz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ierusalemai gakwarato aonai, walakava mavererera na gegapi-ragemaito. ");
INSERT INTO khz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Elaganiato, Paulo ai ria gaagoto Teimiti gitagitana; e rupu kuneagina talimara maparara vonai tanukou-tago. ");
INSERT INTO khz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulo na evega-namarato mulinai, ia gena inagulu aonana Palagu na ati Iuda talimara raka ekala-tiwarato valira maparara geria ekilagirato. ");
INSERT INTO khz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ira na gekamonagiato aonai, maparara na Palagu gevega-rageato. Ne ira na Paulo gevaikilaato, negetiwato, “Walakavamai, ogitaana Iuda talimara ragana vira warau Iesu gekamonagi-veniana, e rova maki gekwalana-namanamaana. ");
INSERT INTO khz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Goi valimu ira gevararato. Gevaikilarato, goi na irau tano ai getanuna Iuda talimara maparara ovevega-riparana, okilana, Mose gena rova pia raokwania, natura melora tauniparara kopira ragai pia voro-vagira, e Iuda tenera geria kala ragaina pia kwalanara. ");
INSERT INTO khz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Pe, ai ewagumona rakagau aia kala? Goi poma kwara valina pia kamonagia vegata. ");
INSERT INTO khz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Gaura pakurai rakagau paia vaikilagimu kalana pono kalaa. Taura vativati (4) ea, ira kilagavu gaokana ta gekalaato Palagu genai. ");
INSERT INTO khz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ira ria pio ago, e goi maki ira ria pio vekala-aleva, e pia vua-agora gaura pono vega-voira, pe ira repara pia ralora. Evetaina pono kala vou, taunilimalima maparara pia ripa, goi atamu ai gekilagirawai kilara maparara ati taunatauna, a goi matotaumu maki Mose gena rova gelegelenai omagulina. ");
INSERT INTO khz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ati Iuda talimara gekamonagina geria pepa warauna gatuguto, gavaikilarato, kaivakuku gevenirato ganiganira ragaina pia ganira, e rala e gaagorana gepora-materana ramaramara virigora ragai pia gani, e ragaina pia mata-poraga.” ");
INSERT INTO khz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ne Paulo na votalima vativati egapirato, elaganiato aonai maparara kala-aleva inaguluna geve kalaato. Voia mulinai Rupu Veaga aonai elaka-togato, e arigi toma kala-aleva pene aiki tomana, e arigi toma wareware gaura ira kwapurakwapura ararai pia tao ekilagi-matagaiato. ");
INSERT INTO khz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Geria vekala-aleva inaguluna toma taulatoi kwapuna; roli geaikito aonai, Iuda talimara reketa Asia tanona na gevogomaito, ira na Paulo Rupu Veaga aonai gegitaato. Ira na talima maparara aora geganirato, nea Paulo gegapiato, ");
INSERT INTO khz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","gekogoto, negetiwato, “Isaraela taumi, ai ioveakavamai! Etalima e kapu mapararai eagona, taunilimalima maparara evega-riparana; Isaraela talimara, e Mose gena rova, e eRupu Veaga ragaina pia kwalanaa netina. Ewagumona maki, ia na Grik talimara eRupu Veaga aonai pevaitogara, ekapu veagana pevega-rakavaa.” ");
INSERT INTO khz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Vovetaina gekilato, kwalana ira na Epeso talimana arana Trofimas, Paulo goti vovanuga kamunai gegitarato, e getugamagito, ia Paulo na Rupu Veaga aonai evaitogaato. ");
INSERT INTO khz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Vanuga maparana aovoaovo na egapiato, e talima maparara vonai gema galukavito, ne Paulo gegapiato, Rupu Veagana gerolo-atiato. Ati lovana Rupu Veaga vanagira geve kana-gavuto. ");
INSERT INTO khz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ira na Paulo ia vagi-matea negetiiwai aonai, talima ta eve raka-rageto, Roma vetali velena kamuna eve vaikilaato, Ierusalema maparanai veineveine kamu vagi gekalaana. ");
INSERT INTO khz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ia veganamo gena vetali gitatagona talimara e vetali talimara eago-agirato, ne geraka-rigoto vogutuma para geriai. Talima na vetali velena kamuna magena vetali taura gegitarato aonai, ira na Paulo kwarikwarina gevega-aikiato. ");
INSERT INTO khz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ne vetali velena kamuna Paulo genai eagoto, egapiato, gena melo evaikilarato, teini ruala na pia ligoa. Ne everenagito, netiwato, “Etalima e rai, e ia rakagau pekala?” ");
INSERT INTO khz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Vogutuma para aonai taarana geparalawai; kila ta gekilagiawai, reketa na makila ta, gaurai vetali velena kamuna maki kila rorirorina ta ati egapiato. Gaura pakurai gena melo evaikilarato, Paulo vetali talimara geria kapu ai pia ago-agia. ");
INSERT INTO khz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ragerage ai gevaikwaraato aonai vetali talimara na, gevua-rageato, kwalana votaunilimalima maparara aora geginigini-rakavato. ");
INSERT INTO khz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Votaunilimalima maparara ira mulira na geraka-agoto, gelailaiwai, negetiiwai, “Iovagia!” ");
INSERT INTO khz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Roli kiana vetali talimara geria numai gevaitogaato aonai, Paulo na vetali velena kamuna evaikilaato, netiwato, “Pana vaikilamu rorinai pa?” Ia na evega-geleato, netiwato, “Goi Grik geria karo ripamu? ");
INSERT INTO khz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Pe goi ne ati voAikupito talimana, toma reketa warau pege vanagi, ia na kaomani vevagi-venina etinaato, e vagivagi talimara ragana vativati (4,000), mageria vevagi rinagara tanoleanai eago-agirato talimamu?” ");
INSERT INTO khz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulo na evega-geleato, netiwato, “Au Iuda talimaku, awalato vanugana kamuna arana Taso, vanuga mavalina, Silisia tanonai. Anogimuna, gemu kala, etaunilimalima ana vaikilara.” ");
INSERT INTO khz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Vetali velena kamuna na rorirori eveniato, ne Paulo ragerage ai erugato, gimana na taunilimalima elao-talirato. Veineveine enotuto, ne Paulo na Heberu karonai evaikilarato. ");
INSERT INTO khz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Walakavaku e tamaku maparami, wailami ai ana vekilagi-piati, pe pio kamonagi.” ");
INSERT INTO khz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ira gekamonagito, ia na Heberu karonai evaikilarato aonai, gevaigarito, maparara gevaivakoloto pene ago ikanai; ne Paulo na netiwato: ");
INSERT INTO khz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Au Iuda talimaku, Taso vanuganai Silisia tanona aonai awalato, na eIerusalema vanuga kamunai akamuto. Gamaliel gena vevega-ripa aonai ataluwai, ia na ita tenera geria rova veagara gaokara evega-ripakuwai, e Palagu gena inagulu akalawai makwalimuku na, ewagumona gomi na gokwalimu-agiana vetaina. ");
INSERT INTO khz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Au na eraupara gekwalanaawai talimara avega-vitivitirawai pene ago geve kwaregawai. Maru e gare agapirawai, tipura numarai alapu-togarawai. ");
INSERT INTO khz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Rupu Veaga velena kamuna e kaonsela talimara maparara na maki pia vega-taunataunaku, au akila-taunataunana. Au maki ira na pepa gevenikuto, walakava Iuda talimara Damaseko ai pana venira ulanana. Ne au voanana aagoto, e taunilimalima pana gapira, teini na pana ligora e Ierusalemai pana ago-agira, geria rakava akwara pia gapira ulanana.” ");
INSERT INTO khz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Au raupara na roe waagowai, Damaseko akavinagiato, garogota-kilipaaluna, maeka kamuna ta kupa na emarigoto, atilovana ewae-talikuto. ");
INSERT INTO khz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Au kwano ai aketo-talito, e karo ta akamonagiato, au evaikilakuto, netiwato, ‘Saulo! Saulo! Rakagau gaurai au ovega-rakavakuna?’ ");
INSERT INTO khz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ne au averenagito, natiwato, ‘Velekou, goi ne rai?’ Ia evega-geleto, netiwato, ‘Au Iesu, Nasareta talimaku, goi na ovega-rakavakuna.’ ");
INSERT INTO khz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Au taukavaku na maki maeka gegitaato, ne gekalito, na au evaikilakuto karona ati gekamonagiato. ");
INSERT INTO khz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ne averenagito, natiwato, ‘Velekou, au ewagumona rakagau ana kala?’ Velekou evega-geleto, netiwato, ‘Ono kuliiti, Damaseko ai onove laka-toga, vonai vou taa na pene vega-ripamu, goi rakagau pono kala.’ ");
INSERT INTO khz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Vomaeka kamuna na mataku ekala-keleato, ne taukavaku na gimaku ai gegapito, Damaseko ai gevaiagokuto. ");
INSERT INTO khz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Vonai tau ta arana Anania, ia Palagu kalina na ekaliwai e rova ekwalanaawai talimana, e Iuda talimara maparara Damaseko ai getaluwai talimara na gekuparage-kamuawai. ");
INSERT INTO khz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ia evogomaito lagaku ai ema ruga-talito, ne ekilato, ‘Saulo walakavaku, matamu ono alira.’ Atilovana mataku aalirato, ia agitaato. ");
INSERT INTO khz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Voia mulinai Anania na evaikilakuto, netiwato, ‘Ita tenera geria Palagu na warau pegapi-itimu, ia gena ririwa rakagau pono kalaa, pono ripaa. Ekala rorirori talimana pono gitaa, e ia matotauna muruna na pene kila karona pono kamonagia. ");
INSERT INTO khz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Kwalana goi ia povega-taunataunaa talimamu, rakagau pogitaa e pokamonagia gaura, talima maparara pono vega-ripara. ");
INSERT INTO khz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Rakagau oalo-tagoana? Ono kuliiti, bapatiso ono gapia. Ia arana ono vega-ragea, ne gemu rakava ene guligi-vagira.’” ");
INSERT INTO khz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Voanana Ierusalemai awaikuleto, ne Rupu Veaga aonai arapaliwai aonai, amata-vanagito. ");
INSERT INTO khz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Vonai au na Velekou agitaato, au evaikilakuto, netiwato, ‘Ono kala, Ierusalema ono raokwani vega-velekea, kwalana enai au valiku pono piaa, na etaunilimalima na ati pia vega-taunataunamu.’ ");
INSERT INTO khz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Au na avega-geleato, natiwato, ‘Velekou, ira ripara nama, au rupu mapararai aagowai, gevega-taunataunamuna talimara agapirawai, tipura numanai akanagavurawai e akwarirawai. ");
INSERT INTO khz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","E goi evega-taunataunamuwai talimana Setepano ralana gevega-rigoato tomanai au vonai, gevagi-kwaregaato avega-taunataunaato, e gevagiawai talimara geria rapuga agita-tagorato.’ ");
INSERT INTO khz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Na Velekou na evaikilakuto, netiwato, ‘Ono ago, kwalana au na pana tugumu, ati Iuda talimara kapu raurai getaluna talimara geriai.’” ");
INSERT INTO khz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Taunilimalima na Paulo gekamonagiwai, pene ago, ia vovetaina ekilato. Ne geparalato, negetiwato, “Iogapi-pakaa! Iovagi-kwaregaa! Ia ati gena nama ta etanoparai roe magulina.” ");
INSERT INTO khz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Gelailaiwai, geria rapuga gekwara-lagirawai, e kakavu gekwari-itirawai. ");
INSERT INTO khz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Roma geria vetali velena kamuna na gena melo evaikilarato, Paulo pia ago-agia, vetali talimara geria talu kapunai. E evaikilarato pia kwaria, e pia renagia rakagau galamanai ia vovetaina gelailai-veniana, pene varara. ");
INSERT INTO khz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Na geligoawai pia kwaria ulanana aonai Paulo na vetali gitatagona talimana evaikilaato, netiwato, “E taunatauna rova aonai ekilana, goi na Roma talimana pono kwari-kunea; a ia na rakagau pekala-lea gauna Kota na rogotina ere kilagia, genai?” ");
INSERT INTO khz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Vovetali gitatagona talimana na vokila ekamonaigiato, ne eraka-agoto vetali velena kamuna genai, evaikilaato, netiwato, “Goi na raka ono kala-tiwaa? Votalima voma Roma talimana!” ");
INSERT INTO khz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Gaura pakurai vetali velena kamuna eagoto Paulo genai, ne eve renagiato, netiwato, “Ono varaku, goi Roma talimamu pa?” Paulo na evega-geleato, netiwato, “Pa.” ");
INSERT INTO khz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ne vetali velena kamuna ekilato, “Au Roma talimaku ai aagoto gauna moni kamunana kaomani genai avoiato.” Paulo evega-geleto, netiwato, “Na au Roma petera geriana awalato Roma talimaku.” ");
INSERT INTO khz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ati lovana Paulo pia renagia talimara geruga-waito, e vetali velena kamuna maki ekalito, kwalana eripa-rorirorito, Paulo Roma talimana, ia na eligoato pia kwaria ulanana. ");
INSERT INTO khz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Elaganiato, vetali velena kamuna gena ririwa pene ripa-rorirori, rakagau pakunai Iuda talimara na Paulo gevega-veroliato. Gaura pakurai ia na Paulo geligoato walora elugarato, ne Rupu Veaga velera kamura e kaonsela maparana evaikilarato pia tanu-kou. Ne ia na Paulo evaiagoato, ira wailarai eve vega-rugaato. ");
INSERT INTO khz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulo na kaonsela talimara egita-kalakalarato, ne evaikilarato, “Walakavaku maparami! Au aoku marorirori na Palagu wailanai ataluna, pene vogomai etoma.” ");
INSERT INTO khz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Paulo vovetaina ekilato aonai Rupu Veaga velena kamuna Anania na Paulo laganai geruga-tagowai taura evaikilarato, muruna pia vale-gavua. ");
INSERT INTO khz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ne Paulo na evaikilaato, netiwato, “Goi Palagu na pene valemu, goi pilipili gevega-kulokuloato vetaina, rakava ragai pia gitaa ulanana opakau talimamu! Goi nenai potanu rova gelegelenai au okota-venikuna, na goi matotaumu na rova poleaa, talima povaikilara, au ia valeku nopotiwa!” ");
INSERT INTO khz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Paulo lagana taura na gevaikilaato, negetiwato, “Goi Palagu gena Rupu Veaga velena kamuna genai kila rakavara okilagina!” ");
INSERT INTO khz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulo evega-geleto, netiwato, “Walakavaku, au ati paripa-rorirori ia Rupu Veaga velena kamuna. Kwalana ripaku Puka Veaga aonai ekilana, ‘Gomi gemi vele ragai pio vaikila-rakavaa.’” ");
INSERT INTO khz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paulo na ira reketa egitarato Sadukea talimara, e reketa Parisea talimara, ne kaonsela wailanai ekogoto, netiwato, “Walakavaku, Isaraela talimami, au Parisea talimaku, Parisea talimana natuna. Au veveakota kapunai ea, kwalana au geku vega-taunatauna, kwarega talimara kwarega na pia kuliiti-wai!” ");
INSERT INTO khz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Vovetaina ekilato, nea Parisea talimara e Sadukea talimara geveituto, e geria tanukou maki gekala-kavalugaato. ");
INSERT INTO khz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kwalana Sadukea talimara gekilana, taunilimalima kwarega na ati mapia kuliiti-wai, e aneru e palagu ati getaluna; a Parisea talimara na voira maparara gevega-taunataunarana. ");
INSERT INTO khz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Vovetainai gaurai lailai kuluna ekamuwai, aonai rova gevevega-ripagiawai Parisea talimara geruga-itito, matiligara gekilato, negetiwato, “Etalima genai rakava ta ati pata rawalia! Pene ia palagu na pa aneru taa na taunatauna pevaikilaa genai Palagu ragai ita vega-vevagia!” ");
INSERT INTO khz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Veitu etiavu-galagalato aonai, vetali gitatagona talimana kamuna ekalito, Paulo irauna nege rale-kinikiniana nea. Gaura pakurai gena vetali taura evaikilarato, piave raka-rigo, Paulo pia vaigerevagia Iuda talimara nuganugara na, ne vetali talimara geria numai pia ago-agia. ");
INSERT INTO khz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Vopoginai, Velekou Paulo laganai eruga-talito, ne ekilato, “Goi na eIerusalemai au okilagi-matagaikuto gelegelena, Romai maki vovetaina ponove kilagi-matagaiku.” ");
INSERT INTO khz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Elaganiato amoamonai, Iuda talimara reketa getanu-kouto, ne navuga ta getovoato. Ira na kilagavu kilana gaokana gekilagiato, gau kwauta ati pia gania e ati pia niua, pene ago, Paulo pia vagia. ");
INSERT INTO khz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Vonavuga getovo-koukouato talimara maparara 