﻿USE sofia;
DROP TABLE IF EXISTS sofia.khs_vpl;
CREATE TABLE khs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES khs_vpl WRITE;
INSERT INTO khs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Epalahame sena i maye mina emi Yesuwa hetetiwa wekeye. Yesu Keleso e mei kouwawa Tepitikeye. Tepiti e mei kouwawa epela: Epalahamekeye. ");
INSERT INTO khs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Epalahame e sa:wa Aisa:kekeye. Aisa:ke e sa:wa Yakopekeye. Yakope e sa:wa Yuta, apula: e ma:ela: kesa:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yutayawa e kesale Temawa tiyapola: sena sala elipei kesa:pekeye. Nowa Selakeye, nowa Pelesekeye. Pelese e sa:wa Heselonekeye. Heselone e sa:wa Lamekeye. ");
INSERT INTO khs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lame e sa:wa Aminatapekeye. Aminatape e sa:wa Nasonekeye. Nasone e sa:wa Salomonekeye. ");
INSERT INTO khs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomoneyewi e kesale Lehape tiyapola: sena sala kesa:pewa Poasekeye. Poaseyewi kesale Luti tiyapola: sena sa: kesa:pewa Opetekeye. Opete e sa:wa Yesikeye. ");
INSERT INTO khs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi e sa:wa Tepitikeye. Tepiti amowa ene piseikipela: enekeye. Tepitiyewi Yulaiya kesale sopa:lawa tiyapola: sala kesa:pewa Solomonekeye. ");
INSERT INTO khs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomone e sa:wa Liapohamekeye. Liapohame e sa:wa Apaisakeye. Apaisa e sa:wa Asakeye. ");
INSERT INTO khs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa e sa:wa Yeho:sefatekeye. Yeho:sefate e sa:wa Yolamekeye. Yolame e sa:wa Usaiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaiya e sa:wa Yotamekeye. Yotame e sa:wa Ehasekeye. Ehase e sa:wa Hesekaiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaiya e sa:wa Mana:sakeye. Mana:sa e sa:wa Amonekeye. Amone e sa:wa Yosaiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaiya e sa:wa Yehoiyasine apula: e ma:ela: kesa:pewayakeye. Ikila emiwa Papilone peleya:wemi siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Papilone peleya:wemi siliye hapalapita:, Yehoiyasine e sa:le kesa:pewa Siatiokeye. Siatio e sa:wa Selapapeokeye. ");
INSERT INTO khs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selapapeo e sa:wa Apiutekeye. Apiute e sa:wa Eliakimikeye. Eliakimi e sa:wa Esolokeye. ");
INSERT INTO khs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esolo e sa:wa Sa:tokekeye. Sa:toke e sa:wa Akimekeye. Akime e sa:wa Eliutekeye. ");
INSERT INTO khs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliute e sa:wa Eliesakeye. Eliesa e sa:wa Ma:ta:nekeye. Ma:ta:ne e sa:wa Yakopekeye. ");
INSERT INTO khs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakope e sa:wa Yosepekeye. Yosepe ekewa Melikeye. Meliyewi sala kesilawa Yesukeye. Yesu Ewa Piseikipela: epesita: Koteyewi tila:tesa: apoyanase Ene unu unuwapowa Kelesokeye. ");
INSERT INTO khs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Alake, Epalahame sena i maye minawa akeye hanapola:, kena:wa (14) Tepitikeye. Tepiti sena i maye minawa akeye hanapola:, kena:wa (14) Papilone peleya: emi tipolo selama:na:pela: hapa ikila emi sena sa: kesa:pe akeye. Papilone peleya: emi tipolo selama:na:pela: hapa emi ma:ta: tiye akeye hanapola:, kena:wa (14) Kelesokeye. ");
INSERT INTO khs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Keleso kesilawa wekeye. Ene e amawa Meli amowa Yosepeyewi setetima ela: semini enene ikila emi, Meli suwemi Ho Napoyewi sala selawatapita: alelakeye. ");
INSERT INTO khs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Alepita: potapola:, Meli semini sena Yosepewa ene o:sulu ela:, solo ele tuwapowa kulu hanose o:sulu hopola enenase eyawa matanese, “Meli sena nowanapulu hapalapo. Aluse, ema sosolo kotokamakiwa sena sopoyawa Ewa ewama:pekise semiwa o:sulu iya:pa:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aluse matanepela: enewemi, uwa koane Piseiki Koteyewi hepene sena inapola: Yosepema selese, “Tepitiyewi sena i Yosepe. Ke kesale Meliwa tima:na:wa tutumanose ipilise iya:tapa. Kine koane Meliwa siliye ha:na:pa:. Ene alela epeya Ho Napoyewi sala ema selawapokeye. ");
INSERT INTO khs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sala amowa sena sa: keisa:taposakeye. Keisa:tapita: Ewa unuwatese Yesu unuwata:pa:. Yesu unuwapo mouwa Isolaiya sena kesalewa ketea olokeyatelawa tiya:sela: sitalapitekiwa, iwa falasima:pekise Eyewi mene siliyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Apula:, Yosepe tesile hanose Piseiki Kote hepene senayewi seyawa ta: tiyapola:, Meliwa ene koane siliye hapakeye. Hanapola: Meli sala a kesima:na: enene ikila emiwa, Yosepe ewalapuluwa elipewa mowa eta: hapamakeye. Meli alela ela: sena sa: keisa:tapita: potapola: sala amo unuwatese Yesu unuwapokeye. Yesu minawa, nano ketea amowa sopoke auma:na:no, puwano fa:nemi sepatosene senayewi Kote sowa ta:tapola: pukawemi momateyakeye. Pukawemi momateyawa wekeye. “Ta:ta:pa:, kesale pola alela elaposakeye. Alela elapepela: sena sa: keisa:taposakeye. Keisa:tapita: Ewa unuwatese Ima:niuele unu unuwata:pa:,” aluse Piseiki Koteyewi selapitekiwa sepatosene senayewi ta:tapola: momateyalakeye. Momateyawa heteti epalakeye. Aputa: Ima:niuele unuwapo mouwa, Kotewa niwanapulu elakeye. Aluse unuwapokeye. ");
INSERT INTO khs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Helote piseikipela: enene ikila emiwa, Yutia peleya: emi Peteleheme taunewemi Yesuwa selatikeye. Selati ikila emiwa, nono opo inisene tapo emi meiyetolu potosene sena Yelusaleme sitiwemi minakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Inapola:, iyewi selese, “Sala napute kesilawa Yu sena kesale Piseikipela: epesenewa kaiye? Opo inisene tapowemi meiyetolu pa:ta hili hetetiyapita: potapola: niyewi matanese, ‘Yu senayewi piseikiwa selatilapo.’ Aluse matanepela: ema wapilima:na:pela: niwa minakeye.” ");
INSERT INTO khs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Apula: Heloteyewi ta:tapola: piseiki nowamoke ewa helete tima:pekise mapoyakeye. Mapoyawa Yelusaleme senayewi ta:tapola: howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aputa: Heloteyewi mapolose ela:, pilisiti sena sosowala, Kote solo ele walosene senawana, ewamo enene kekenema:na:pela: mina e seya. Mina selapita: potapola: Heloteyewi ima selese, “Koteyewi Piseikipela: epesita: ta:peya sena Keleso hamonama:na: e seyawa, peleya: kami kesima:na: e seyala?” ");
INSERT INTO khs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Apula: iyewi selese, “Yutia peleya: emi Peteleheme taunewemi kesipesakeye.” Aluse kesima:na: seyawa puwano fa:nemi sepatosene senayewi momate tiye, ");
INSERT INTO khs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Yutia peleya: emi Peteleheme koamesa: tiwa koane koloteakeye. Kolotea elapepela: koawemi Piseiki kesima:na:nase koawa putupesakeye. Piseikiyawa Isolaiya sena kesale sopoke Koteyewi ta:peyawa Eyewi a:pele sipi pota:tesene sena epapuluse potapola: elaposakeye.” Aluse sepatosene senayewi momateyalakeye. Aluse iyewi Helotema seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Selapola: kotetiyapita: Heloteyewi ta:tapola: iwa hamona seyakeye. Iwa hapalapita: Helote ewa enapotane ela:, meiyetolu potosene senawa mina e seya. Mina selapita: imawa selese, “Kiyawa meiyetoluwa ikila asu papola?” Apula: iyewi meiyetolu papolo oka seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Selapita: Heloteyewi ta:tapola: selese, “Peteleheme taunewemi sala kesilawa keye hamona. Hanapola: sala kesilawa keyalapepela: potosekiwa, nema selapose mene ina:pa:. Neyawana sala amo wapilima:na:pela: ha:na:na:nase, nema selapose mene ina:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aluse Heloteyewi selapitekiwa iyewi ta:tapola: hapakeye. Hanose puwano iwa opo inisene tapowemi sita:la: meiyetolu papowa meiyetolu semetei kamo wa:ke elapita: papokeye. Potakamake meiyetoluwa putupela: hanapita: iyewi pote hapakeye. Meiyetoluwa sala selati koane hekeyawemi elapita: ");
INSERT INTO khs_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","potosekiwa sosolo epeyakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Epelese hanapola: koawemi musuluyetiye potakamake, salawa Ene e ama Meliwalapulu elapita: papokeye. Potapola: iwa kuniu kula:walopela: ka:la:lopela:la: salama wapiyakeye. Iyewi nano ketea himu hapa tiye tiwa tiyapola: inapola:, salama mokopo mikeye. Kinisewa etewa kolowala, ima ikomo hosonosene kamuna unuwa felekenesewala, ima nowa ikomo hosonosene kamuna unuwa muawala keteawa tiyapola: minawa mokopo mikeye. ");
INSERT INTO khs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kinapola: apola: iwa ipitane koane mene hanose, Helotema selapose eta: hapamakeye. Aluse uwa koane “Helote popa:na:pela: hanapa.” Apula: ta:tapola:, Heloteyewi koawa aloyetiye isu nowemi iwa ipitane koane hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sena minawa hapalapita:, Yosepeyewi uwa koane Piseiki Kote E hepene senayewi Yosepema selese, “Kewa tesile hamona. Sala amowa sana kuma:na:pela: Heloteyewi kelese potaposakeye. Popa:pekise sala amowana, salayewi e amawana, siliye, Isipi peleya: nesile hamona. Hanapola: peleya: emi sita:la: neyewi mene ina:pa: e selapita: ina:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aluse hepene senayewi selapita: ta:tapola:, nukulapo kemi Yosepe tesile, salawala, ene e amawana, siliye, Isipi peleya: emi sita:pesena:pela: nesile hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hanapola: Helote seta: kulumake falela apota: enene ikila emi iwa Isipi peleya: emi sita:nekeye. Isipi peleya: emi sita:pesena:pela: a hanapose, puwano fa:nemi Koteyewi selapitekiwa sepatosene senayewi ta:tapola: momate tiye, “Isipi peleya: emi Neyewi sala mina selapita: inaposakeye.” Aluse Koteyewi selapitekiwa sepatosene senayewi ta:tapola: momateyawa heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Alake meiyetolu potosene senawa Helote enewemiwa mene mainapita: Heloteyewi matanese, “Sena amokiwa nema mokopo sepapolapo.” Aluse matanese ene sosolo konomonakeye. Konomonose ela: eyewi matanese, “Sena makene mina amoke meiyetolu papolo ikila amowa, seya ikila semetei kemi Isolaiya senayewi piseikiwa selatilapo. Selati ikila amowa akeye inapola:, ikila weyemi hetetiyatakeye. Sala sosololikeye.” Aluse Heloteyewi matanese selese, “Sena sala yapene elipe tepela: hanetapowa sopoke sanose kotetiya:pa:. Peteleheme taunewemiwana, Peteleheme taune mapato emi sita:newana, sena sala sopoke sanose kotetiya:pa:.” Aputa: ta:tapola: sena sala sopoke sanose kotetikeye. ");
INSERT INTO khs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Sana amowa a sanapose puwano fa:nemi sepatosene sena Yelemaiyayewi momateyawa kamunuse heteti epalakeye. Sepatosene senayewi momateyawa wekeye. ");
INSERT INTO khs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Senayewi ta:takamake Lama koamesa: kesaleyawa sosolo ya:pelepita: ta:taposakeye. Kesale ene unuwa Lesoloyewi ene salawamopela: sosolo ya:pelepita: ta:taposakeye. Sala sopoke sanose kotetinase ewa hopolose selakamakiwala eyawa ta:te iya:tapita: potaposakeye.” Aluse sepatosene senayewi puwano fa:nemi momateyawa heneye kamunuse heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sikape Helote kulapita: potapola:, Yosepe Isipi peleya: enewemi uwa koane Piseiki Koteyewi hepene sena inapola: Yosepema selese, ");
INSERT INTO khs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Kewa tesima. Sena sala kumita: sama:na:pela: matanepela: enene senawa kulukeye. Kulunase salawala, salayewi ene e amawana, siliye ha:na:pa:. Hanapola: Isolaiya peleya: emi sita:pesena:pela: mene ha:na:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aputa: Yosepe tesile hanapola:, tesile salawala, salayewi ene e amawana, siliye, Isolaiya peleya: emi mene hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Alawamona, mene hanose ta:takamake Heloteyewi e sa:le Akelease e ata onatu wapa:kemi ela:, Yutia peleya: emi piseikipela: ela e selapita: topukeye. Ta:tapola: Yosepe Yutia peleya: emi ha:na:na:wa tutumanose enekeye. Tutumanose enewemi uwa koane nowa Yutia peleya: emi hanapa e selapita:, Kalili peleya: emi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Hanapola: Nasalete koamesa: sita:pesena:pela: hapakeye. Sita:pesena:pela: minawa a hanapose, puwano fa:nemi sepatosene sena nokamoke seyawa wekeye. “Ewa Nasalete senakeye, aluse sena sopoyawa au selaposakeye.” Aluse sepatosene senayewi seyawa heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Amo fasuwemi, Yutia peleya: moa honosanewemi Yone hano toluyetisewa inapola: sena kesalema se tiye kinise, ");
INSERT INTO khs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Koteyewi Piseikipela: pota: epesene ikilawa pa telanase, kiyewi mane olokeyatelawa iya:pela: Ema sita:pesena:pela: ke iya:ta:pa:. Eyewi kiwa pota: epesita: Ema sita:pesena:pela: ke iya:ta:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ala senawa puwano fa:nemi sepatosene sena Aisaiayewi momate tiye, “Sena moawemi elaposakeye. Ela: eyewi unuwapo selese, ‘Piseiki mina:na:wa isuwa seila:ta:pa:. Isuwa koakenananeke heka:ta:pa:.” Aluse, moawemi senayewi selaposakeye. Aluse Aisaiayewi momateyawa Yone amowa momateyakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Mowa honosanewemi Yone enene ikila emiwa kopolo ka:mo fano sao tupiya kapela:, kopolo kapo tekapo polopela:, mapalo napela:, kele ipi hano noiya napela: ala:sela: enekeye. ");
INSERT INTO khs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ewa enene peleya: emi sena kesale Yelusaleme sitiwemi tesekiwala, Yutia peleya: tesekiwala, hano Yotane mapato tesekiwala, sena kesale muta minakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Inapola: iyewi mane olokeyatelawa hokato selapita:, Yoneyewi iwa hano Yotanewemi tolusulakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yoneyewi hawemi tolusupela: ela: potakamake Felesi senawala, Satusi senawala, iwa noka hawewemi ine sita:la: popa:na:pela:, Yoneyewi ima selese, “Kiwa sopoke heseke amunanakeye. Koteyewi kima sosolo konomonose falasima:na: epeya, kiwa ko:lu heletetiye nesile ha:na:na: e seye? ");
INSERT INTO khs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Aputa: i napoyawa fowa seli watosekeye. Alusene amunuse kili himu olokeyatelawa iya:pela: sita:pesena:pela: ke iya:peyawa popita: napolo sopolo sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Epapu sita:pesene telawamona kiyewi matanese, ‘Niwa Epalahameyewi sena inase Kote senawa niwakeye. Alake niwa ili sitalakeye.’ Aluse matanepa. Epalahameyewi sena iwa temita: Koteyewi etewa amowa tiyapola:, senamene tesaleke ili senamene tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Alake senayewi i kema:na:pela: kapiwa tilitiye ela epapuluse, ikila weyemiwa Koteyewi falasima:na: tuwapa:na:wa aluse mapato elakeye. I fo napolo eta: helesema i amowa kene tiye sotukepilapola: teiyewi wa:mita: kilipesakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kiyewi himu olokeyatelawa iya:pela: sita:pesena:pela: ke iya:tapitekiwa, neyewi kiwa hano semetei toluyetiyakeye. Alawamona, newa enewemi sikape sena sosolo nowa inaposakeye. Inisekiwa, Eyewi, E Ho Napowala, tei wa:lawala kiwa toliyetiyaposakeye. Ewa sena sosonase tima:na: tisene sena e tamaka kalawa fake tiyapola: epa hanoseyamunuse neyewi tiyapola: hanakamakiwa eta: ilimanakeye. Ewa sena sosonase neyewi ewamopela: tima:na: tisene tima:na:pela: elawamona, newa koloteanase neyewi tiyakamakiwa eta: ilimanakeye. Newa Ewalapulu eta: ilimakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sena sosolo amowa inise eyewi sipiti amuna foke tiyapola: inaposakeye. Tiye inise peleya: pakia witi fo tiye tiwa fokeyewi sa:takamakiwa, witi hene amowa hekeya sululuwalupita:, amowa tiyapola: koane tiye tiyaposakeye. Witi kapo amowa foyewi tiyapola: hanapola: nokemi sululuwalupita:, amowa sotukepilapola: tei wa:la eta: sekakolosema emi kilipesakeye.” Aluse Yoneyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yone moa honosanewemi enene ikila emiwa, Yesuwa Kalili peleya: iya:pela: Yoneyewi ewa hawemi toliyetimita: hano Yotanewemi minakeye. ");
INSERT INTO khs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Inapita: Yoneyewi eta: auma:na:ma selese, “Keyawa newa hawemi toliyetiyakamakiwa ililakeye. Neyewi kewa hawemi toliyetiyakamakiwa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Aputa: Yesuyewi selese, “Aupa. Ne sowa keyawa ta:pa. Koteyewi nano ketea napolo timinisewa na:tewi nano ketea sopoke napolo tiye ha:na: iliye tima:na:pela: yemiwa keyawa newa hawemi toliyetima.” Aputa: Yoneyewi ilikeye esa: Yesuwa hawemi toliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hawemi toliyetiyapola: hawemi mutula: sinapola: mowa falemi fiyanakamake, meiki fala takalese fa:temi takalese komemi potakamake, Koteyewi Ho Napowa a:nema: tumu amuna inisene epapuluse inapola:, Yesuwemi helepita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Potapola: sita:ne ikila emiwa hepene emi selese, “Ewa Nine Ni Sa:keye. Ewa Nine himu hanose sosolo matanepela: epelekeye.” Aluse selapita: topukeye. ");
INSERT INTO khs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesuwa hano toluyetipela: ha:na:newemi, Seteneyewi Yesuma polumita: Ho Napoyewi Yesuwa moawemi siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hanapola: ikila talo pinipe (40) sopolo enewemiwa, ikilawala yopolotelawala Yesu Ewa ma:na:wa ala:pela: hapakeye. Mokopo kutama meina ela: ikila talo pinipe amowa (40) itapa tekamake ewa heneye heneye sosolo meinakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Meinise enewemi Seteneyewi Yesu kapo popa:na:pela: poluse selese, “Kewa Kote E Sa:laleke, Keyawa etewa epeteseya tiyapola: Kine napose falawa menetema.” ");
INSERT INTO khs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Aputa: Yesuyewi selese, “Aupa. Kote pukawemi momateyawa wekeye. ‘Senayawa napolo elaposekiwa, falawa semetei na:sela: napolo eta: tesemakeye. Napolo elaposekiwa Koteyewi seyawa ta:tiyapitekiwa napolo tesekeye.’ Aluse Kote pukawemi momateyalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aluse selapita: Seteneyewi Yesuwa Yelusaleme sitiwemi siliye hanapola: Kote koane tomo falemi siliye fiyanapola: sita:la: selese, ");
INSERT INTO khs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Kewa Kote E Sa:laleke, Kine kemi peleya: kolemi autetima. Autetiyapita:, Koteyewi hepene senama ‘Ewa sesema,’ aputa: Ke onatuwa etewayawa makapesakeye hepene senayewi tiya:yawa kewa talo tiyapola: elaposakeye.” Aluse Kote pukawemi momateyalakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aputa: Yesuyewi selese, “Aupa. Koteyewi solo nowa Kote pukawemi momateyawa wekeye. ‘Kine Piseiki Kotewa kapo popa:na:pela: aupa.’ Aluse Kote pukawemi momateyalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aluse selapita: Seteneyewi Yesuwa siliye tokomo sosolo tumu hapakeye. Hanapola: sita:la: kamani kalikalila peleya: kalikalila piseikipela: pota: sita:newana, peleya: sopolo nano ketea hele heneye napolo sopowala, Yesuma waiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Walose Yesuma selese, “Keyawa newamo elakemi kula:pela: inapola: helema kuniu kula:walopela: nema wapilipitekiwa, nano ketea sopoke epe potoseya keyawa piseikipela: pota: epesita: Kewa apoma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aputa: Yesuyewi selese, “Setene kewa hamona. Kote pukawemi momateyawa wekeye. ‘Ke Piseikiwa Kotekeye. Kote Ene Ema semetei wapilipa:. Ewamopela: semetei tiya:pa:.’ Aluse Koteyewi pukawemi momateyalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aluse Yesuyewi selapita: Setenewa hapakeye. Hanapita: hepene sena inapola: Yesuwa seselese pota: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Piseiki Heloteyewi Yonewa tipolo selawapokeye. Yone tipolo selawapolopita: ta:tapola: Yesuwa peleya: amowa iya:pela:, Kalili peleya: emi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hanapola: Nasalete koamesa: eniya:newa iya:pela: hanapola:, Kapaneame taunewemi enekeye. Aputa: hano Kalili hano hawe Sepulane sena maya peleya:wala, Nafatali sena maya peleya:wala peleya: emi Kapaneame taune tikeye. ");
INSERT INTO khs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Enima ela: puwano fa:nemi sepatosene sena Aisaiayewi momateyawa heteti epalakeye. Aisaiayewi momateyawa wekeye. ");
INSERT INTO khs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepulane sena maya peleya: emiwana, Nafatali sena maya peleya: emiwana, hano Yotane satepela: emiwana, Kalili peleya: emiwana, Yu senama tela muta sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Amowa yopolotela sita:nekeye. Yopolotela sita:ne sena kesaleyewi ho:liya sosolo papokeye. Aputa: kuluseyewi ausuya peleya: emi senala: sita:newa, ikilale okemi ho:lulusene epapuluse ho:liya semetei ho:lulukeye.” Aluse momateyawa heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesuwa Kapaneame taunewemi hapa ikila emiwa Eyawa nano ketea timinisewa ma:ta: tikeye. Ma:ta: tiyapola: se tiye kinise, “Kote Piseikipela: epesene ikilawa hetetikeye. Hetetinase kiyawa mane olokeyatelawa iya:pela: Ema sita:pesena:pela: ke iya:ta:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesuwa hano Kalili hawe hanapola: potakamake Saimone ene e ma:e A:nitulu a:ko: papokeye. Aputa: Saimone ene unuwa nowa Pitakeye. Ene ewala, ene e ma:e A:nituluwala a:tawi tima:na: tisewa ewalo pisinisi timinisekeye. Timinise sita:la:, a:tewi ewalo tima:na:pela: hawemi nete tikiwalopita:, papokeye. ");
INSERT INTO khs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Alake Yesuyewi a:ma selese, “Newa kulu mina. Newalapulu kulu inisaleke ka:tawa ewalo tisene epapuluse sena kesale Newemi mina:na:wa silimita:, neyewi ka:ko: ta:pelekeye.” ");
INSERT INTO khs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aluse selapita: eli netewa ela:pe kipila iya:pela:, a:ko: Yesu kulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kolotea hanapola: Yesuyewi potakamake sena elipei nowa sitalapitekiwa papokeye. Papowa Sepetiyewi e sa:le elipei, nowa Yemese nowa ene e ma:e Yone, a:ko: inawalapulu potuwemi sita:la:, nete pitia tupiya:sela: sitalapita: papokeye. Potapola: a:ko: minite Yesuyewi holakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hopita: ela:pe kipila a:tewi inawana, potuwana, iya:pela:, eli a:ko: Yesu kulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kalili peleya: koamesa: sopolo Yesuwa sila:sela: ela:, Yu senayewi kekenesene koane sopolo Kote solo napowa se tiye kinise, Kote Piseikipela: enewa se tiye mikeye. Se tiye kinise sena kesalela: nakola sosolo telawala nakola kolotea telawala, nakola towaya kalikalila sopoke Yesuyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesuyewi sena kesale nakola towayawa fala:walopita: Silia senayewi ta:tapola: Yesu enewemi senala: nakola towaya sopoke siliye minakeye. Sena kesalela:wa nakola towaya kalikalila towaya hapawa siliye minakeye. Siliye minawa noka kapo oiya, noka isaneseyewi ho tiyapola:, noka matakolose, noka tomawana, tiya:wala, pa:mo tise olale tela sena sopoke epapuluse nakola towaya hapawa Yesuyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Epapu fala:walopita: potapola: sena kesale mutayewi Yesuwa pote hanose hapakeye. Hanapola: Kalili peleya: tesekiwala, Teka:polisi peleya: tesekiwala, Yelusaleme sitiwemi tesekiwala, Yutia peleya: tesekiwala, hano Yotane satepela: peleya: nono tesekiwala, sena kesale muta inapola: Yesuwa pote hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sena kesale muta minawa Yesuyewi potapola:, tokomo tumu fiyanapola: henekeye. Henewanapulu E sena ilipe hanosene inapola: Ewalapulu ilipe ka:la:lopela:la: ");
INSERT INTO khs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesuyewi ima selese, ");
INSERT INTO khs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Sena kesale iye matanese, ‘Niwa Kote ketea misitiya sitala,’ kiwa epelepa:. Ala sena kesalewa Koteyewi Piseikipela: pota: tesekeye. Potapola: ela: Koteyewi sena kesalewa sela:tapita: iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Aputa: sena kesale nokamoke ya:pelese sitalapita: Koteyewi iwa hopo selese hopa: tesekeye. Hopa:pela: epapu seila:tapita: iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Aputa: sena kesaleyawa i mene solo se wapilise eta: seyamake, i mene kolotea meapolose hopola sitalapita:, i peleya: weyamo keteawa potapola: sita:pesita: Koteyewi iwa ta:pele tiyapola: apoyakeye. Ta:pele tiyapola: epapu seila:tapita: iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Aputa: sena kesale nokamoke menise sita:la: ma:na: nasewana, hawana ma:na:pela: epelesene epapuluse, Kote hekeya matanesewa epapuluse epelese sitalapita:, epelesene sena kesalema Koteyewi hekeya matanesewa ili kinisekeye. Kinapola: epapu seila:tapita: iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Aputa: sena kesale nokamoke, sena kesale nowama hauwekilise matanesaleke, hauwekilisene sena kesalewa, Koteyewi hauwekilise matanesekeye. Hauwekilise matanepela: epapu seila:tapita:, iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aputa: sena kesaleyewi mane olokeyatela matanawa selakolose, napolo sopolo matanesene sena kesaleyewi Kotewa potaposakeye. Popa:na: sena kesalewa Koteyewi epapuluse seila:tapita: iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Aputa: nowamoke nowama konomonose elapita:, konomonawa itapa temita: sena kesale nowamoke hekelesaleke, ema Koteyewi selese, ‘Kewa Nine Salakeye.’ Au selesekeye. Alake sena kesalewa Koteyewi aluse seila:tapita: iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Aputa: sena kesale nokamoke Kotewa kulu hanose, hekeya sopolo timiyanase, iwa sena nowamoke ikomonosaleke, iwa Kote Piseikipela: pota: tesekeye. Potapola: ela: Koteyewi iwa aluse seila:tapita:, iwa epelese sita:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Alake kiyawa Newamo kulu minanase kima sena nokamoke henipasolose, sanose ikomonose, mokopo palese selesaleke, kiwa Koteyewi seila:takeye. ");
INSERT INTO khs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Epelese sita:latipa:. Epelese sita:la: hepene falemi kiyewi nano ketea heka napolo sosolo tiye tinase, heneye sosolo epelese sita:latipa:. Alake puwano fa:nemi senayewi Koteyewi solo kinisene sepatosene senawa ikomona epapuluse, kiwala aluse ikomopesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesuyewi selese, “Nano ketea posuma:pekise solu kepela: tiye ti tuwapo epapuluse, senayewi nano ketea olokeyatelawa peleya: sopolo foye tima:pekise soluyewi kela seleya amunawa kiwakeye. Aputa: solu noiyawa kotetiyapita:, wa:ke eta: nonosemakeye. Solu noiya itapa mokopo tiye tiyakamakiwa eta: ilimanapita:, soluwa sotukalesekeye. Sotukaiyawa sena hanose onatuyewi onanesekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Aputa: peleya: weyemi yopolosaleke ikiwapo okemi ho:lulusene epapu ho:lulusene amunawa kiwakeye. Aputa: koamesa: tokomo tumu tiwa hokatonase ketea nowamoke eta: o:sulusemakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aputa: senayewi nafa tupa:tapola: tuwapola: paketeyewi eta: fopulusemakeye. Nafa tupa:tapola: koane telepeyawa ho:lilipita: sena kesale sopoyawa potosekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nafa tupa:tapola: telepeyawa sosolo ho:lilise ela epapuluse, kiyawa epapuluse seli timinise sitalapita: sena kesale sopoyawa potosekiwa, kili ki Ata hepene falemi elakamawa wapilipesakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesuyewi selese, “Kiyawa matanese, ‘Puwano Koteyewi solo ele tuwapowala, Koteyewi se tiye kinisene sepatosene senayewi seyawala, Yesuyewi nanese iya:pa:na:keye.’ Aluse matanepa. Koteyewi solo ele tuwapowala, sepatosene senayewi seyawala, nanese iya:pa:na:pela:, newa eta: minamakeye. Koteyewi solo ele tuwapowala, sepatosene senayewi seyawala semetei kamo ili auma:na:pela:, newa minakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne solo we heneye selakeye. Hepene falala, peleya: sosolo weyala, seta: itapa telamake ela ikila emi, Koteyewi solo ele amowana elaposakeye. Solo ele momateyawa semetei nowana maiya:taposakeye. Aupesakeye aluse momateyawa, sopoke heneye kamupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Alanase, sena semetei nowamoke Kote E elewa kolotea semetei hotolosaleke, ewa Kote Piseikipela: ela emiwa ewa ununama elaposakeye. Alawamona, senayewi Kote solo ele sopoke ta: tiyapola:, sena nokamokiwala ta: timita: se tiye kinapita:, se tiye kina senawa Koteyewi Piseikipela: pota: enene sena puwanowa Ekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ta:ta:pa:. Ne solo we heneye selakeye. Felesi senayawala, Kote solo ele walosene senayawala, iyewi ilipe hekeya matanepela: timinise sita:newa, kiyewi sitiyetiye hekeya mamatanesaleke kiwa Kote Piseikipela: enene peleya: emi mahanaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yesuyewi selese, “Puwano fa:nemi kili tilila kouwa meima seyawa sele inapola: kiyawala topukeye. Topuwa wekeye. ‘Sena kumita: sanapa. Sena nowa keyawa sana kulusaleke, Kewa kotopela: falasipesakeye.’ Aluse sepapolakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Alawamona, seya kamowa, Neyewi kima solo nowa weyamo selakeye. Sena nowamoke ene sena e manama konomonosaleke, ewa falasimita: kotosene koawemi kotopesakeye. Aputa: sena nowamoke ene sena e manama konomonose sikapo henipasolosaleke, Yelusaleme sitiwemi kotosene mou ta:tapola: sena sosoyewi hekemita: siliye hanaposakeye. Alawamona, sena nowamoke ene sena e manama ikomonose konomonose selese, ‘Kewa nanano telakeye.’ Aluse selesaleke, sena amowa heo peleya: tei wa:la hamonapesakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Alanase, ikiwapo nowemi Kotema nano ketea mokopo kinakamokiwa keyawa matanese, ‘Ne sena mana nema mapolose elakeye.’ Aluse matanepela: ");
INSERT INTO khs_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kotema nano ketea mokopo miya:na:wa seta: mimake mosote tepolowemi tiye tiyapola: keyawa Kine mana kema mapoyawa puwano tiya: hapopola: itapa tepa:se ha:na:pa:. Hanapola: ka:lipe tiya: hapopola: iya:pela: mene inise nano ketea mokopo miya:na:pela: tiye tiwa kina:pa:. ");
INSERT INTO khs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aputa: sena nowamoke kema selesaleke, ‘Keyawa newa apipa:.’ Aluse kewa kotoma:na:pela: isu hanose sita:la:, keyawa ema mapoyawa iya:ta:pa:. Iya:pela: api kinapola:, ka:tawa ka:lipe nano ketea olokeyatelawa iya:ta:pa:. Maiya:tesaleke kotoma:na: ikila emiwa kotosene mou ta:tapola: senayewi ta:le tima kewa walose selese, ‘Sena amowa tipolo selawata:pa:.’ ");
INSERT INTO khs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Au selapita: kema api kina:pa: e seyawa iliyetiye makinisaleke, kewa tipolo selawapowa masilikepilaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yesuyewi selese, “Ketea puwano seyawa kiyawa topukeye. Topuwa wekeye ‘Sena kesale tili kiyawa iwei tiyapa.’ Aluse seyalapokeye. ");
INSERT INTO khs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Alawamona, seya kamona Neyawa solo nowa weyamo selakeye. Senayewi kesale potosekiwa himu hanose, ‘Kesale amowa iwei timana,’ esa: matana kamoke ela: kesale amowa himuyewi atu tisekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Alake ke si iliyewi nano ketea olokeyatelawa timita: sutapitekiwa, siwa tukutiye sotukepila:pa:. Si kolotea semeteiyewi ke toma sopoke heo peleya: emi siliye ha:na:pekitise, si kolotea semeteiwa tukuyetisaleke ililakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aputa: ke tiya: iliyewi olokeyatela timinisaleke tiya:le amowa na tiye iya:ta:pa:. Tiya:le iliyewi toma sopoke sukulutiye heo peleya: emi siliye ha:na:pekitise, tiya: semeteiwa na tiye iya:ta:pa: ililakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yesuyewi selese, “Ketea puwano se tiye miwa wekeye. ‘Senayewi ene ekewa iya:peyawa sena sopoyewi potapola: matanemita: kesalema sawi momate tiye kinise, “Kewa iya:takeye.” Aluse sawi momate tiye kina:pa:.’ Aluse se tiye minapokeye. ");
INSERT INTO khs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Se tiye mini kamona Neyawa kima solo nowa weyamo selakeye. Senayewi ene kesale tiwa sena nowanapulu mokopo mahanosaleke kemi, iya:tesaleke senayewi olokeyatela timinikeye. Kesale iya:peyawa sena nowamoke tisaleke Koteyewi potapola: matanese, ‘Kesale amowa sena elakemi hanosene kesalekeye. Aputa: senayewi kesalewa atu tisekeye.’ Aluse Koteyewi matanesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesuyewi selese, “Wa:ke, puwano fa:nemi kili tilila kouwa meima seyawa sele inapola: kiyawala topukeye. Topuwa wekeye. ‘Keyawa tima:na: sita:la:posakeye, aluse sepapola: seyawa iya:tapa. Piseikiyewi popita: keyawa sepapola: selese auma:na: seyawa heneye aupa:,’ aluse sepapolakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Alawamona, tilila kouwa meiyewi seya kamunuse, Neyawa kima solo nowa we selakeye. Ketea nowa selapola: hekilapa. Hepene falemi Kote Piseikipela: sea sosolo helanase, hepene fala selapola: hekilapa. ");
INSERT INTO khs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Aputa: Kote Ene Ewa hepene falemi hela:, peleya: sosolo we Eyewi onatuyewi onapela: helanase, peleya: sosolo weyala, selapola: hekilapa. Aputa: Yelusaleme sitiwala selapola: hekilapa. Ko:yawemiye, Yelusaleme sitiwa Piseiki Sosoyewi sitikeye. ");
INSERT INTO khs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Aputa: kiyawa piseiwala selapola: hekilapa. Ko:yawemiye, pisei fawa ulawala, yopoyawala, kili senayawa eta: apolosemakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Alake Ehema:na: matanese heneye Ehepa:. Auma:na:ma matanesekiwa heneye auma:na:makeye epa:. Ko:yawemiye, nano ketea nowa selapola: hekilase sopoke mouwa Setenekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesuyewi selese, “Nano ketea puwano seyawa kiyawa topukeye. Topuwa wekeye. ‘Senayewi ke siwa sanose kowa:tesaleke, ewala siwa koyetimita: sanose heka tiya:pa:. Senayewi kewa meakemi sanose peka tukuyetisaleke, ewala peka tukuyetimita: keyawa heka sana:pa:.’ Aluse seyawa kiyawa topukeye. ");
INSERT INTO khs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Alawamona, iyewi seya kamo Neyawa kima solo nowa weyamo selakeye. Sena olokeyatelayewi kewa ikomonosaleke keyawa ema heka ikomopa. Senayewi kewa meapo papo iliwemi sanosaleke, keyawa heka eta: sanamake meapo papo hukalo tapowala samita: walopa:. ");
INSERT INTO khs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aputa: kotosene mou ta:tesene senayewi ta:pita: sena olokeyatelayewi kema kotopela: selesaleke, ‘Ke sao seti kalawa nema tine.’ Au selapita: sao kalawa ema kinise, sao kala napolo nowana ema kina:pa:. ");
INSERT INTO khs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aputa: kamani senayewi kema penanose selese, ‘Keyawa nano ketea pa kemi mokopo tiyapola: hamona.’ Au selapitekiwa keyawa epelese ewa seselese pamawemiwana mokopo tiyapola: ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Alake senayewi kema nano ketea ta:potosaleke, keyawa kina:pa:. Senayewi kema ketea mosote kina:pa:saleke kina:pa:. Eta: auma:na:ma selapa.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yesuyewi selese, “Ketea puwano seyawa kiyawa topukeye. Topuwa wekeye. ‘Sena manayewi kema himu hapa matanesaleke keyawala ema himu hapa matanepa:. Senayewi kema mapolosaleke keyawala ewa mapolopa:.’ Aluse puwano seyalapokeye. ");
INSERT INTO khs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Alawamona, seya kamona Neyewi kima solo nowa we selakeye. Sena nowamoke Kewa ikomonosaleke, keyawa ema himu hapa matanepa:. Ewa Koteyewi sesemita: kulukulupa:. ");
INSERT INTO khs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ewa matanepela: kulukulula:sela: ela:, kiyewi ki Ata hepene falemi elakamoke ketea tisene aluse, kiwa Ene sala amunatese aluse timiyanakeye. Alake sena olokeyatelayewi peleya: emiwana, sena napoyawa peleya: emiwana, iyawa sopoke peleya: emi ikilale okemi ho:lilimita:, Koteyewi ikilale oka kinisekeye. Aputa: hema senawala, henela senawala, iyawa sopoke peleya: emi hawa minite Koteyewi kinisekeye. ");
INSERT INTO khs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Sena manayewi kewa himu hapa matanesaleke, keyawala ewa heka himu hapa matanema:na:pela:, ‘Koteyewi nema ketea heka elaposakeye.’ Aluse matanesewa ililapa? Aupa, eta: ilimanakeye. Keyawa heka himu hapa matanepela: elapita:, kewa takese tisene sena ela epapula elakeye. Sena olokeyatelayewi matana epapuluse alawamona kiyawa aluse matanekeye. Aputa: kiyawa sena manawana matanesekiwa kemi, sena nokala himu hapa matanepa:. ");
INSERT INTO khs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Keyawa kine sena i amowa semetei napola:tese, sena nowa pote iya:tese kepoliyetisaleke ililapa? Aupa, amowa eta: ilimanakeye. Keyawa Kine sena i semeteima napola:tese, sena nowa pote iya:tese kepoliyetise elaleke, kewa mokopo sena ela epapuluse elakeye. ");
INSERT INTO khs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Alake keyawa ki Ata hepene falemi elakamoke seli ela: sena kesale sopoke himu hapa matana hanosene epapuluse, kewala seli ela:, sena kesale sopoke himu hapa matanepa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesuyewi selese, “Keyawa Kotema kulu hanosene tisewa sena sopoyewi potapola: kewa solo se wapilimita: timinipa. Keyawa kine mene solo se wapilise tekamunuse timinipa. Keyawa Kotema kulu hanosene elakamoke timinise, sena sopoke pota: kewa solo se wapilimita: timinisaleke, keyawa ki Ata hepene falemi elakamoke kema ketea heka miya:na:pela: elawamona, keyawa Kine ela: ekamoke, keyawa ketea heka sinisekeye. ");
INSERT INTO khs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Alake sena ketea misitiya elakamowa keyawa potapola: ketea kina ikila emi, o:sulu kina:pa:. Sena sopoyewi potapola: kewa solo se wapilimita:, sena sopolo sikapo kinapa. Sena sopolo sikapo kinisene epapuluse, sena matana elipei matanepela: elakamoke aluse ketea kinisekeye. Iyewi ketea kinisewa Yu senayewi kekenesene koawana, isu sosowala, ketea kinisekeye. Epapu ketea kinapita:, senayewi potapola: wapilise, ‘Eyewi ketea sosolo kinatakeye.’ Alake Neyewi kima heneye selakeye. E selesaleke, senayewi ene mane potapola: wapilise ketea heka ili epe tiseya akeye. ");
INSERT INTO khs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Alawamona, sena ketea misitiya enewa keyawa ketea kinise, o:sulu kina:pa:. Sena nokamoke popa:pekise, iwa sikapo kinapa. Aputa: sena nokamoke ta:pa:pekise, selapa. ");
INSERT INTO khs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","O:sulu kinisene aluse kina:pa:. Ikila emiwa, keyawa mupapola:la: timiyawa keyawa ki Ata hepene falemi elakamoke potosekiwa Eyawa kewa seila:taposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yesuyewi selese, “Keyawa kulukulusekiwa sena matana elipei elakamo kulukulusewa ta:tapola:, aluse kulu hanose kulukulupa. Sena nowamoke isu kiwemi ela: kulukuluse, apula: sena nowamoke Yu senayewi kekenesene koawemi sena sopoke ta:pita: kulukuluse e sekeye. Aputa:, sena sopoyewi potosekiwa selese, ‘Ewa sena napokeye.’ Alake Neyawa kima heneye selakeye. E selesaleke senayewi ketea heka ili epe tiseya akeye. ");
INSERT INTO khs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Alawamona, keyawa kulukulusekiwa keyawa kine koane kinapotane hanapola: isu tenamowa etapela: ela:, kulukulupa:. Keyawa kinapotane kulukulula:sela: ela:, kine ki Ata senayawa eta: popa:na: telamawa o:sulu kelapita: Ema kulukulupa:. Kulukulusewa kine ki Atayewi ta:tapola: kewa seila:taposakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Mokopo senayewi kulukulusene epapuluse, keyawa kulu hanose kulukulupa. Mokopo senayewi matanese, ‘Sosolo kulukulupita: Koteyewi ta:taposakeye.’ Aluse matanese, iyewi solo sosolo sutuse solo senatoye hanose kulukulusekeye. ");
INSERT INTO khs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Iyewi kulukulusene epapuluse, keyawa kulu hanose kulukulupa. Ko:yawemiye, keyawa ketea ili eta: tiye timawana, matana eta: ilima telawala, keyawa seta: kulukuluma ela:, kine ki Ata hepene falemi elakamoke puwano matane tiye elakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Alake kiyawa kulukulusekiwa weyamu kulukulupa:. ‘Nini Ata. Kewa nini Ata hepene falemi elakeye. Ke unuwa heneye sosolo pa:ta napolo sopowa puwano putumita: matanekeye. ");
INSERT INTO khs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Sena sopoyewi matanawa Kewa piseikipela: epesita: matanekeye. Hepene falemi keyawa kine matana alusene epapuluse, peleya: weyemiwana aumita: matanekeye. ");
INSERT INTO khs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Napu ketea ma:na:wa napu yemi maita:, iliyetiye kina:pa:. ");
INSERT INTO khs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Sena nowamoke nima ikomonosaleke, niyewi heka ikomonosewa iya:pela: kepoliyetiyapita: potapola:, niyewi olokeyatelawala, Keyawa iya:pela: kepoliyetiya:pa:. ");
INSERT INTO khs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Niwa kapo popa:na: mina:pekise Keyawa niwa pota: elatipa:. Seteneyewi niwa poluma:pekise niwa heleye tiya:pa:.’ Aluse kulukulupa:. ");
INSERT INTO khs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Alake senayewi kema olokeyatela timiyawa, keyawa heka eta: ikomonomake iya:tapita:, keyawa ki Ata hepene falemi elakamoke ke olokeyatelawala iya:pa:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Alawamona, senayewi kema olokeyatela timiyawa, keyawa heka ikomonosewa maiya:tasaleke, ke olokeyatelawala, ki Ata hepene falemi elakamoke maiya:taposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yesuyewi selese, “Ketea nasewa alesekiwa sena matana elipei sita:neyawa ala:sene amunuse, keyawa aluse ala:pa. Ili sipupa:wa epeyawa itapa sita:la:, ili ketea nasewa ala:pewa, sena sopoyewi matanemita:, meinise kelese sita:tesekeye. Meinise kelese sita:newa sena sopoyawa potapola: wapilipitekiwa, alake, Neyewi kima heneye selakeye. Iyewi ketea heka ili epe tiseya akeye. ");
INSERT INTO khs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Alawamona, keyawa Koteyewi epelemita: ketea nasewa ala:pela:la:, sena sopoyewi matanema:pekise, kine sipupa:wa hetetiyapola:, pisei fano saleoyewi sululupa:. ");
INSERT INTO khs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Sululupela: sena sopoyewi popa:pekise o:sulu ketea nasewa alepita:, keyawa mupapola:la: ala:pewa keyawa ki Ata Ene semeteiyewi potosekeye. Potapola: Eyawa kewa seila:taposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yesuyewi selese, “Peleya: weyemi ketea himu hapa tiye tiwa nowa wamenesekeye. Nowa wanapoyewi nasolosekeye. Nowa atu tisene senayewi koane isu tenamo etaiyawala, koloyetiye atu tisekeye. Auma:pekise peleya: weyemi keteawa himu hanose tiye tiyapa. ");
INSERT INTO khs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Alawamona, keyewi ketea himu hapa amowa hepene falemi tiye timita: timinipa:. Hepene falemi ketea tiye tiwa sena nowamoke eta: atu tisemakeye. Wanapoyawala eta: nasolosemakeye. Apula:, wamenesekiwala eta: wamenesemakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Alake keyawa peleya: weyemi keteawa himu hanose kekenepela: tiye tiyapola: elapitekiwa peleya: weyamo keteawa semetei matanema:na:pela:. Aputa: hepene falemi ketea himu hapa amowa kekenepela: tiye tiyapola: elapita: hepene falemi ketea tiye tiwa semetei matanepela: elaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yesuyewi selese, “Ke tomayewi nafa amunawa kine sikeye. Ke siyewi ketea sopoke seli potapola: takalese elapita: kine tomawa ho:lilise elaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Alawamona ke siwa koyetiye ela:, ke tomawana, yopoloyetiye elaposakeye. Yopoloyetinase ho:liya enewa yopoyayawa foye tiyaposakeye. Foye tiyapita: yopoyaye solopesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yesuyewi selese, “Sena yesila elipeipela: tima:na: tisene sena semeteiyawa eta: tisemakeye. Sena tima:na: tisene semeteiyawa sena yesila elipeipela: tisekiwa, nowama epelese tise, nowama mapolose tiyaposakeye. Alusene amunuse senayewi Kotepela: matanepela: tisewana, mowenipela: matanepela: tisewana, elipe tiyakamakiwa eta: ilimanakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Alake Neyewi solo we kema selakeye. Kewa a pote elawa hawana, ma:na: nasewana, ketea amopela: sosolo himunama matanepa. Ipa:towane sita:pesa:pekise sao kalawa, sosolo himunama matanepa. Heiyato a elekiwa ma:na: nasene semetei kama? Tomawemi sao kalesene semetei kama? Alamakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","A:nema: fa:nano sitalaka pota:pa:. A:nema:yawa ma:na: nasewa eta: kelesemakeye. Witi fo kenepita: a:nema:yewi eta: nasolosemakeye. Witi fo sikape napose koane eta: tiye tisemakeye. Eta: tiye timanase a:nema:ma ki Ata hepene falemi elakamoke ma:na: nasewa kinakeye. A:nema:ma kinisenase senamawana eta: miya:na: telamanapa? Henekeye. Senawa Ene kinisene sosolo matanepela: kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aputa: senayawa ene himu matanayawa, ‘Newa kuma:na:wa mapolokeye.’ Aluse himunama elapitekiwa, ewa kuma:na: opo tuwapowa sitiye tiyaposapa? Alamakeye, masitipesakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Aputa: sao tima:na:pela: himunama elatepa. Falafalawa matanepa:. Falafalawa sopoma:na:pelekiwa falafalayewi ilipe kemi tima:na: tisena? Alusemakeye, tima:na: eta: tisemakeye. Falafalayewi sao keyawa tiyapola: tupulusena? Alusemakeye, falafalayewi ene matana eta: timinisemakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ta:ta:pa:. Puwano fa:nemi, Solomone sena sosolo piseikipela: ela:, ene sao napolo kalesekeye. Solomoneyewi sao kalawa napolo kamona, mei waine fowa hele heneye napokeye. ");
INSERT INTO khs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Aputa: hutiya sopopela: enewa Koteyewi napola:tesekeye. Napola:pita: hutiya napu sopopela: elaka, kolotea sikape teiyewi kilikamakiwa ya:te tesekeye. Ya:te tela, opo koloteawemi sopopela: sita:ne kamona, Koteyewi pote tesekeye. Koteyewi hutiya potapola: ela epapuluse, ke sawa itapama:pekise, Koteyewi kewa aluse pota: elakeye. Koteyewi kewa pota: ela kamona, keyawa Kotema matanayewi semetei kolotea matanekeye. ");
INSERT INTO khs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Koteyewi kiwa pota: elanase weyamu matanepa, ‘Ma:na: nasewa kami tima:na:ne? Hawa kami wa:pa:na:ne? Sao itapalapita: kami tima:na:ne?’ Aluse, himunama sosolo matanepa. ");
INSERT INTO khs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Aputa: mokopo senayewi ikiwapo sopoke ma:na: nasewana, saowala, sosolo matana iliyewi matanesekeye. Aputa: ma:na: nasewana, sao kama:na:wana, kotetiyapita: tima:na:wa ki Ata hepene falemi elakamoke matanesekeye. ");
INSERT INTO khs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Alawamona, keyawa puwano Koteyewi Piseikipela: pota: epesita: matanepa:. Kotewa hekeya ela epapuluse hekeya elaposekiwa matana iliyewi epapu matanepa:. Epapu matanepela: elapitekiwa ma:na: nasewana, saowala, iliyetiye tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Alanase, eliwemi auma:na:wa eliwemi kemi matanepa:. Napu matanepa. Napu hililawa napu ikila akeye. Eli hililawa eliwemi ikila akeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesuyewi selese, “Keyawa sena nowa kolotea temita: akowa tese selese, ‘Ewa olokeyatela elakeye. Newa napolo elakeye. Ewa ela epapuluse newa maelakeye.’ Au selapa. Ma au selesaleke sena nokamokiwala, Koteyawala, kema aluse maselaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Keyawa sena nowa epapu kolotea meapolose akowa tese selapitekiwa, Koteyawa kewala epapu kolotea meapolose selaposakeye. Aputa: ke sowa takalese kina epapuluse, kema Kotewala, epapuluse takalese kema kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Keyawa kine ke ma:e siwemi nano ketea funu kolotea epeya keyawa potose kemi, keyawa kine siwemi nano ketea i sosolo epeya, ko:lupita: pote iya:ta:? ");
INSERT INTO khs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Pote iya:pela: kemi kine ke ma:ema selese, ‘Ke siwemi nano ketea funu kolotea epeya, neyewi tiyapola: iya:pa:na:keye.’ Aluse selesaleke kewa sena matana elipei elakeye. Puwano keyawa kine siwemi nano ketea i sosolo epeya tiyapola: iya:ta:pa:. Iya:pela: itapa tepela:, kine ke ma:e siwemi nano ketea funu kolotea epeya tiyapola: iya:pa:na:pela: kelekamakewa keyawa kine siyewi ili napolo potaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Aputa: Kotema nano ketea mokopo miya:na:wa kasolo ima kinapa. Aputa: kopolo inapita: kopolo minitapo kemi, kapowa tikipelapa. Tikipelesaleke kapowa kopoyewi onapela: ela:, itipaiyawemi mutule sinapola:, kewa alu tiye inise sano tiye tuwapola: naposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesuyewi selese, “Nano ketea tima:na:pela: Kotema kulukulupa:. Kulukulupitekiwa Koteyewi kema kinaposakeye. Siyewi popa:na:pela: kelepa:. Kelesaleke kelese potose tiyaposakeye. Isu tenamo kolo timita: kotokotopa:. Kotokotopita: Koteyewi kolo tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Alake nano ketea tima:na:pela: Kotema kulukulupita: tiyaposakeye. Nano ketea popa:na:pela: siyewi kelesaleke kelese potaposakeye. Keyawa isu tenamowemi kotokotosaleke, Koteyewi kolo tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aputa: keyawa kine salayewi selese, ‘Ni Ata, newa ma:ne tine.’ Au selapitekiwa keyawa kine salama etewa miya:na:na? Alusemakeye, etewa kinisemakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aputa: salayewi selese, ‘Newa ewalo tine.’ Au selapitekiwa keyawa ema heseke miya:na:na? Alusemakeye, heseke kinisemakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Alake ke matana olokeyatela kamona ke salama nano ketea napolo kinisekeye. Kina epapuluse, ki Ata hepene falemi elakamokiwala, kiyewi ketea tine e seyawa sena kesalema ki Atayewi nano ketea hele heneye napowa kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Alake sena nowamoke kewa aumita: keye matanese, keyawala sena nowama aupa:. Alake heka alusene sowa Moseseyewi solo elewala, sepatosene senayewi seyawala, solo mouwa semetei kalakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yesuyewi selese, “Falasisene peleya: isu ki pawemi sena ha:na:na:wa eta: temekelesemakeye. Eta: temekelemake sena muta isu ki emi hanosekeye. Alawamona, kewa ha:na:na:pelekiwa isu tenamo teleya emi ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Teleya:nase temekelese hokolose musuluyetiye kokolo kao tesene peleya: emi hanaposakeye. Isu tenamo koloteanase sena mutamayewi kelese potapola: hanosekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesuyewi selese, “Mokopo sepatosene senayewi Kote solo se tiye kinisene sepatosene sena amunatese se tiye kinisekeye. Ili sowa kiyawa ta:tapele esa:, mokopo sele inise selaposakeye. Alake mokopo sepatosene sena amone esa:, seli pota:pa:. Mowa kasolo tikape tela mokopo a:pele sipi amuna menetepela: sitalapela: esa:, seli potapola: tipipelepa:. ");
INSERT INTO khs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","‘Kote solo se tiye kinisene sena tesekiwalo?’ Aluse takalese matanepa:se, eyewi tima:na: tisewa potapola: tipipelepa:. Senayewi tima:na: tisewa, mei fo epapulakeye. Mei napeiwemi mei kalipe fo watula sutusemakeye. Aputa: mei onawa i kalu fo watula sutusemakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Alake, i napoyawa fo napolo sopolo watosekeye. I olokeyatelayewi fo olokeyatela sopolo watosekeye. ");
INSERT INTO khs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I napoyawa fo olokeyatela eta: helesemakeye. Aputa: i olokeyatelayewi fo napolo eta: helesemakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iyewi fo napolo eta: watesemawa, senayewi kene tiye iya:pela:, teiyewi wa:mita: kilisekeye. ");
INSERT INTO khs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Alake mokopo kote solo se tiye kinisene sena amuna menetepela: timinisaleke pota:pa:. Potapola: matanese, ‘Ewa Koteyewi solo se tiye kinisene senamakeye.’ Aluse matanepa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yesuyewi selese, “Sena nokamoke Nema selaposa, ‘Piseiki, Piseikio,’ aluse tomayewi holosene senawa Kote Ene Piseikipela: pota: elakemiwa sena alapulu mapapesakeye. Alawamona neyewi ni Ata hepene falemi elakamoke matana kulu hanose tisene sena kesale amowa, iwa semetei papesakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kotoma:na: ikila emi sena kesale mutayewi Nema selaposa, ‘Piseiki, Piseikio, Ke unuwa solomita:, Kote sowa niyewi ta:tapola: sowa se tiye mikeye. Niyewi Ke unuwa selapola: isanesema iya:pela: hamonapita:, iwa hapakeye. Kewa unuwapowa sosonase niyawa penana:pela: timinisaleke, sena nokamoke potapola: howa hapakeye.’ ");
INSERT INTO khs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Apula: Neyewi selese, ‘Kiwa Neyawa eta: potesemakeye. Kiwa sena olokeyatelanase Newa iya:pela: kiwa hamona,’ au selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesuyewi selese, “Senayewi seli matanepela: etewawemi koane tiwa penana:pela: ela epapuluse, Ne solo ta: tiyapola: kulu hanose senawa aluse tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Koane tiwemi alopo hawanapulu sosolo inise, hano hakene hanose, etewa emi koane tinase tukutiye eta: hanosemakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Aputa: sena seli eta: matanamake peleya: sipitouwemi koane tili ela epapuluse, Ne solo ta: tiyapola: eta: kulu hanosema iya:peya senawa aluse tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Koane tiwemi hawa sosolo alopowalapulu sosolo inisekiwa, hano hakene hanosekeye. Hanose koane peleya: sipitouwemi tiwa tukutiye hanose sosolo apulusekeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sowa se tiye kinapola: kotetiyapita: sena kesale mutayewi ta:tapola: himunama tese howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ko:yawemiye, Kote solo ele walosene senayewi se tiye kina epapuluse Yesuyewi epapuluse se tiye mimakeye. Eyawa penana:pela: se tiye kinapita: ta:tapola:, “Sowa eta: fesamoma:na: telamanakeye.” Aluse sena kesale howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesuwa tokomo tumu fiyanapola: mene inapita:, sena kesale mutayewi Eyewi tima:na: tisewa pote hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pota: hanose hanapola: sena wakapila tela Yesu enewemi inise, kuniu kula:walopela: hela: selese, “Piseiki, Keyawa newa itapa tepa:se Kote sikapowemi hili temita: epelesekiwalao, epelepele?” ");
INSERT INTO khs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aputa: Yesuyewi Ene tiya:wa tili tiyapola: sena amowa kesalese selese, “Henekeye, Newa epelekeye. Kewa nakolawa itapa tema. Napuwa kewa Kote sikapowemi hili tekeye.” Au selakamake sena wakapila telawa ela:pe kipila fala:pekeye. ");
INSERT INTO khs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Itapa tepita: potapola: Yesuyewi selese, “Kewa fala:pewa sena nokamawa selapa. Pilisiti sena elakemiwa hanapola:, ke toma wakapila tela fala:pewa pilisiti senama walopa:. Walopela:, Moseseyewi solo ele sepapoyewi aupa: au seyawa kulu hanose, nano ketea mokopo Kotema aluse kina:pa:. Kewa fala:pewa sena kesale sopoyewi potapola: matanemita: aluse kina:pa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesuwa hanapola: Kapaneame taunewemi inapita:, Lome sena ta:le ti yesila inapola: Yesuma selese, ");
INSERT INTO khs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sena sosolo, ne tima:na: tisene sena nakola sosolo tese oiya ilima tela, toma pa:mo tise sosowane tese koane ka:pelalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aputa: Yesuyewi selese, “Newa Nine inise ewa fala:pa:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aputa: Lome sena ta:le ti yesilayewi mene selese, “Piseiki, newa sena koloteanase Kewa sena sosonase nenipe eta: ilimakeye. Alanase ne koane Kewa inakamakiwa eta: ilimanakeye. Kewa sena nakola ka:pela:la eta: hapamake weyemi ela:, sena nakolawa fala:pa e sema. Keyawa fala:pa aputa: ne tima:na: tisene sena nakolawa fala:pesakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Aputa: newamo pota: ela senayewi nema timinima e selapita: neyawa timinisekeye. Aputa: neyewi sena pota: tesema hamonapita: ewa hanosekeye. Mina selapita: ewa inisekeye. Neyewi tima:na: tisene senama timinima e selapita:, eyawa timinisekeye. Neyewi alusene amunuse, keyawala sena nakolawa fala:masaleke, ewa fala:pesakeye.” ");
INSERT INTO khs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Aputa: sowa Yesuyewi ta:tapola: howa hapakeye. Howa hanose pote hanose mina sena kesalema selese, “Neyewi kima heneye selakeye. Lome sena ta:le ti yesila amowa Yu senamakeye. Yu senama tela elakamoke Nema matana semetei matana epapuluse Isolaiya peleya: Yu sena nowamoke Nema epapuluse matana semetei eta: matanesemanakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ta:ta:pa:. Kote Piseikipela: ela peleya: emi Epalahamewana, Aisakewala, Yakopewala, iwalapulu ilipe ka:la:lopela:la: ma:na: napose, Yu senama telawa muta hanaposakeye. Aputa: opo inisene peleya: tapo tesekiwala, opo sinisene peleya: tapo tesekiwala, iwa muta inaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Aputa:, Yu sena kesale Kote Piseikipela: ela peleya: emi ha:na:na:pela: elawamona, iyawa Nema matana semetei eta: matanamanase, iwa Koteyewi heneye iya:taposakeye. Yopolotela peleya: emi hamonapesakeye. Hamonapita: hanapola: emi sita:la:, iwa ya:pelese konomonose meapo pese kalonanaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Alake Lome sena ta:le ti yesilama Yesuyewi selese, “Kine koane mene hamona. Keyawa Nema himu semetei matana epapuluse kaluse Neyewi timiyanakeye.” Aluse sela:pa: tima:na: tisene sena nakolawa fala:pekeye. ");
INSERT INTO khs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesuwa hanapola: Pita koane musuluyetiye potakamake, Pita ene ekele e amawa nakola toma ofolose ka:pelalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Potapola: kesale amo tiya:wemi Yesuyewi kesakamake, nakola tese toma ofolawa itapa telakeye. Itapa tepita: potapola:, kesale amowa tesile fiyanapola: ma:na: nasewa satapola: Yesuma mikeye. ");
INSERT INTO khs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aputa: kolotea elapepela: ka:le nukulukemi, sena kesale muta isaneseyewi ho tiwa Yesu enewemi sena nokamoke siliye minakeye. Siliye inapita: isanesema Yesuyewi Ene meatawa semetei sela kamoke isanesewa iya:pela: hapakeye. Aputa: sena kesale nakola telawala sopoke Yesuyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fala:wayawa a fala:pa:na:no puwano fa:nemi sepatosene sena Aisaiayewi momateyakeye. Momateyawa wekeye, “Nini nakola towayawa sopoke tiyapola: hapakeye.” Aluse momateyawa heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Sena kesale muta Yesuwalapulu kekenawa Yesuyewi potapola:, Ene sena ilipe hanosema selese, “Niwa potuwemi tapela: hano Kalili nono fa:nemi hanakeye.” ");
INSERT INTO khs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aputa: Ewamo enewemi Kote solo ele walosene sena nowa inapola: Yesuma selese, “Walosene sena, Kewa peleya: sopoke sila:pitekiwa, newa Kewalapulu na:nipe sila:pesena:keye.” ");
INSERT INTO khs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aputa: sena amowa Yesuyewi ema mene selese, “Mowa kasolo ewa peleya: uwalokemi enisekeye. A:nema:wa ene aiwemi enisekeye. Iwa koane enisewa sitalakeye. Alawamona, Newa Sena Sa:yawa koane enisewa pisei piatowa maelakeye.” ");
INSERT INTO khs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aputa: sena semetei nowa Yesuwalapulu hanose ene selese, “Piseiki, newa Kewalapulu mina:na:keye elawamona, puwano neyewi ni ata kulapita: peleya: tikipela: itapa tepela:, Kewalapulu mina:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Alawamona, Yesuyewi ema selese, “Ki ata iya:pela:, Newanapulu ina:pa:. Sena Newa eta: kulu hanosema sena kuluwa peleya: tikipesakeye. Sena Newa eta: kulu hanosema iwa sena kulu epapulakeye. Sena kulu amunanase iyawa sena kuluwa peleya: tikilisaleke ilipesakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesuwa potuwemi tapela: Ene sena ilipe hanosewana, Ewalapulu ilipe potuwemi tapela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tapela: hanose Yesuwa potiwemi enikeye. Enilapita: hawa kipila inise alokalapulu hano ko:luwalapulu sosolo minakeye. Hawa ko:lu sosolo inise, potiwa suwemi hano kalotiye selalese, potiwa mutule sima:na: telakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mutule sima:na: tepita: potapola:, sena ilipe hanoseyewi Yesuwa kila:tese Ema selese, “Piseiki, niwa sesema. Potiwa mutule sinise niwa hayewi katoma:na: telalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aputa: Yesuyewi ima selese, “Kiwa ko:lupita: ipiliseya:? Nema heneye matana semetei sosolo eta: matanamanakeye. Kolotea matananakeye.” Aluse Yesuwa tesile alopomawana, hano ko:lumawana, “Itapa tema,” Au selapita:, alokala, hano ko:lu sosolo minawana, kipila itapa telakeye. Itapa tese hawa eta: iminamakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hawa maimipita: potapola:, sena ilipe hanoseyewi howa hanose selese, “Yesuyewi sowa alotawala, hano ko:luyawala, ta: tise itapa tetakeye. Itapa telanase Sena Epa ipei?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hano ka:na enene potiwa kolo tiye hanapola:, Ka:telini peleya: emi potiwa papela: hanapola: potakamake, sena elipei isaneseyewi ho tiwa sena kulu tiye tisene apana emi inapita: papokeye. Sena elipei amowa yekele telanase a:tawi apana pawemiwa sena nowa eta: hanosemakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Alake Yesuwa potiwemi tapela: inapola: potiwa palesewemi papelapita: potapola:, sena elipei amowa Yesu elakemi minakeye. Inisekiwa Yesuma halalose selese, “Kewa Kote E Sa:keye. Keyawa na:ko: ko:luma:na:na? Falasima:na: ikilawa seta: hetetima ela: Keyawa na:ma falasise toma oiya kao tesewa miya:na:pela: minana?” ");
INSERT INTO khs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aluse potakamake kopolo muta mapato ma:na: na:sela: sitalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Potapola: ho olokeyatelayewi Yesuma selese, “Keyawa niwa hamona sewa kopolo suwemi sita:pesena:wa hamonoma.” ");
INSERT INTO khs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aputa: ima Yesuyewi selese, “Kiwa hamona,” aputa: ho olokeyatelawa hanapola: kopolo suwemi sita:nekeye. Kopolo suwemi sitalapita: kopowa sopoke tokomo akola naiya emi kipila sine tese, hano naiyawemi sululuwalose hano honosane sutesinise kopowa sopoke hano nase ya:te telakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ya:te tepita: potapola:, kopolo pota: sita:ne senawa koamesa: nesile hapakeye. Hanose sena ho olokeyatela fiyane itapa telawala, kopolo ya:te telala, nano ketea papowa sopoke seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Selapita: koamesa: emi sena sopoyawa Yesuwa popa:na:pela: minakeye. Inisekiwa, himunama tese Yesuma selese, “Nini peleya:wa Kewa iya:pela: hamona,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesuyewi Ka:telini peleya:wa iya:pela:, potiwa tapela: mene inapola: ene taunewemi seselakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sesepela: sita:la: potakamake, sena sosowane tela sasekela selawapola: popoto tiye inapita: papokeye. Tiye mina senayewi sena sosowane tela Yesuyewi itapa temita: Yesuma matana semetei matanepela: tiyapola: inapita: potapola:, Yesuyewi sena sosowane telama selese, “Ni sa:le, ekela matanepa:. Keyewi mane olokeyatelawa Neyewi itapa tekeye.” ");
INSERT INTO khs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Au selapita:, Kote solo ele walosene sena nokamoke ipitane sopolo selese, “Sena mane olokeyatela itapa tekeye au selakamowa Koteyewi E kamutakeye. Eyawa Kotewa kolotea me apolatakeye.” ");
INSERT INTO khs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aluse matanese, iyewi matanawa Yesuyewi potose selese, “Kiyawa ko:lupita: matana olokeyatela kili himu fa:nemi ela:? ");
INSERT INTO khs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Senayewi mane olokeyatela iya:peyawa sosola? Sena nakola fala:pewa koloteasula? No nokaiyamo sosola? No nokaiyamo koloteasula? Alamakeye, elipe ilikeye. ");
INSERT INTO khs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sena Sa:wa Nekeye. Peleya: weyemi sena mane olokeyatelawa Neyewi itapa temita: Koteyewi Newa ta:pele tiyapola: apoyakeye. Apoyanase kiyewi popita: sena sosowane telama Neyewi tesima e selakeye.” Aluse sena sosowane telama Yesuyewi selese, “Kewa tesima. Tesilapola: kine ke keatawa kopo tiyapola: kewa kine koane hamona.” ");
INSERT INTO khs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aputa: sena amowa tesile ene koane hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hanapita: sena kesale kekenayewi potosekiwa howa hapakeye. Howa hanose iyewi matanese, “Ketea olokeyatela fala:tesene penaiyawa Koteyewi senama minakeye.” Aluse matanese iyewi Kotema wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesuyewi peleya:wa iya:pela: hanose potakamake, takese tisene sena unuwa Ma:tiu takese tisene opesi koane helapita: papokeye. Potapola: Ma:tiuma Yesuyewi selese, “Kewa Newamo kulu ina:pa:.” Aputa: Ma:tiuwa tesile Yesuwalapulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hanapola: Ma:tiuyewi koane hanapola: koane suwemi musuluyetiye ka:la:lopela:la:, Yesuwala Ene sena ilipe hanosewana ka:la:lopela:la:, iwalapulu takese tisene sena nokala, sena mane olokeyatelawala, kekenepela: ka:la:lopela:la:, ma:na: menakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Iwa sopoke ilipe ka:la:lopela:la: ma:na: napita:, Felesi senayewi potapola:, Yesu sena ilipe hanosema selese, “Ko:lupita: kili walosene sena takese tisene senawanapulu sena mane olokeyatelawalapulu ilipe ka:la:lopela:la: ma:na: naseya:?” ");
INSERT INTO khs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aluse iyewi selapita: Yesuyewi ta:tapola: ima selese, “Sena seli enewa mitikoloyawa falemita: eta: hanosemakeye. Sena nakolawa mitikoloyawa falemita: hanosekeye. ");
INSERT INTO khs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Alake sena mane olokeyatela sita:neyawa olokeyatelawa iya:pela: sita:pesena:pela: temita: ima mina e semita: Newa minakeye. Sena napowa mina e semita: Newa eta: minamakeye. Alake Kote pukawemi momateyawa matane tima:na:pela: matanepa:. Koteyewi selese, ‘Nema ketea sanapola: satapola: mokopo kinapita: potapola: Neyawa kolotea epelesekeye. Alawamona, sena nowama hauwekilise himu hanapita: potapola: Neyawa sosolo epelesekeye.’ Aluse momateya mouwa matanepa:se kelepa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yesu enewemiwa Yone hano toluyetiseyewi sena ilipe hanosene inapola: Yesuma selese, “Koteyewi popita: niyawana, Felesi senayawala, ikiwapo nowemiwa ma:na: nasewa napela:, ikiwapo nowemiwa ma:na: nasewa ala:tesekeye. Ke sena kilipe hanoseyewi ikiwapo sopoke ma:na: nasewa na:sela: sitalakeye. Iyawa ma:na: nasewa eta: ala:pemawa ko:luselala?” ");
INSERT INTO khs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Aputa: Yesuyewi Ene Ewamo pale selese, “Senayewi kesale tisaleke sena sopoyawa tikinise epelese ma:na: nasekeye. Ma:na: na:sela: sena kesale napute e ko:lu iwalapulu ilipe elapita:, iwa matana eta: mapoyamake epelese sita:la:, ma:na: nasewa eta: ala: tesemakeye. Alawamona, sikape sena kesale e ko:luwa sena nokamoke sukulutiye hana ikila emiwa, iyawa matana mapolose ma:na: ma:na:wa ala:taposakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Aputa: sao pusomiya keseyawemi sao hili papela: tupiyawa, sao hiwamoke akopolose sao pusomiyawa fili nokemi tese keseleye tisekeye. Keselese sosolo pitilila hanaposakeye. Auma:pekise sao pusomiyawanapulu sao hiwalapulu papela: eta: tupulusemakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aputa: a:pele kapo senayewi tiyapola: waine hano wa:pa:na:pela: tupulusekeye. Waine hano hili tikipaseyawa waine hano wa:tesene pusomiyawemiwa eta: wa:tesemakeye. Wa:tapitekiwa waine hano hiyewi telise waine hano wa:tesene pusomiyawa hotolosekeye. Hotolose waine hano wa:tesene palalese waine hano sukamenepesakeye. Sukamenese waine hawana wa:tesewana elipe itapa tepesakeye. Aputa: waine hano hili tikipaseyawa waine hano wa:tesene hiwemi wa:tesaleke waine hano wa:tesene eta: hotolosemakeye. Eta: hotomake, elipe ili elaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yone hano toluyetiseyewi sena ilipe hanosema Yesuyewi selese enene ikila emi, Yu senayewi kekenesene koane pota: tesene sena nowa minakeye. Inapola: kuniu kula:walopela: hela: Yesuma selese, “Ne kesale sa: napute kulukeye. Kulu kamona Kewa inisaleke, ewa kesakamake tesile hanapola: a potala elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Au selapita: ta:tapola:, Yesuwa tesile ewalapulu ilipe hapakeye. Hanose Ene sena ilipe hanosewana, Ewalapulu ilipe hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Hanapita: potapola: kesale nowa fa:se tapo inapola:, ene matanayewi matanese, “Newa yapene kukuluipe sopowemiwa hekila hapawa kokolo a ha:na:sela: enekeye. Enenase, Yesu sawemi neyewi kesakamake newa hekila hapawa kokolo a ha:na:sela: enewa itapa tepesakeye.” Aluse matanepela: Yesu hanapita: potapola:, E fa:se tapo inapola: Yesu sao fili sosowemi kesalakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kesapita: Yesuyewi notolo tese, kesalema selese, “Ne la:le kewa tutumanose elatepa. Ekela elatipa:. Keyawa Nema matana semetei matana epa kamoke, ke nakolawa fala:pekeye.” Au selakamake kesale amowa nakolawa ela:pe kipila itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Itapa tepita: iwa hanapola: Yu senayewi kekenesene koane pote tesene senayewi koane hanapola:, koane suwemi musuluyetiye hanapola: potakamake, salawa kuluwemi kesaleyewi ya:pelese, nokamoke hauwekilise ya:pelepita: potapola:, ");
INSERT INTO khs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesuyewi ima selese, “Kiwa sopoke mowa hamona. Kesale sala amowa eta: kulumakeye. Ewa eninakeye.” Au selapita: sena kesale sopoyewi Yesuwa akowapokeye. ");
INSERT INTO khs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Akolose iwa mowa hanapita: potapola:, sala kulu ka:pela:la koane Yesuwa musuluyetiye hanapola:, sala tiya:wemi tiyapola: tili tise ewa teisa:pekeye. ");
INSERT INTO khs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Teisa:tapita: potapola:, sala amowa teisa:pewa peleya: pawemi sena kesale sopoma sele hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesuwa hanose ta:takamake sena elipei si kolayewi Yesuwa a:le inise Yesuma holose, “Tepitiyewi sena i Yesu, Keyawa na:ko: hauwekilise sesema.” ");
INSERT INTO khs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Au selapita: Yesuwa koane inapola: musuluyetiye ela: potakamake, sena elipei si kola inapita: potapola:, Yesuyewi a:ma selese, “Ka:tewi matanesekiwa, ‘Na:ko: si kolawa Keyewi fala:pita: matanakeye,’ aluse matanana?” Au selapita: a:tawi selese, “Henekeye, Piseiki, Keyawa na:ko: itapa temita: matanekeye.” ");
INSERT INTO khs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Au selapita: a:ko: siwemi Eyewi kesalese selese, “Ka:tewi matanese ka:ko: fala:pita: matanakeye, aluse matananase ka:ko: itapa tekeye.” ");
INSERT INTO khs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Au selakamake a:ko: si kolawa itapa tepela: napolo papokeye. Itapa tepita: potapola: Yesuyewi a:ma penanose selese, “Ka:li si kolawa itapa telawa sena kesale nowama selapa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Au selapita: kemi a:tawi Yesuyewi timiyawa sena kesale koamesa: sopoma sele hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Sena elipei si kolawa fala:pewa hapalapita:, sena nowa ho olokeyatelayewi tiwa sowa itapa telawa sena nokamoke siliye minakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Siliye inapita: Yesuyewi ho olokeyatelama selese, “Kewa iya:pela: hamona.” Au selapita: ho olokeyatelawa hapakeye. Hanapita: sena sowa itapa telayewi napolo seyakeye. Selapita: sena kesale kekenayewi ta:tapola: howa hanose selese, “Eyewi tisewa kalilapo. Isolaiya peleya: weyemi niyewi sena nowamoke epapu timinipitekiwa puwano niyawa eta: papomakeye.” ");
INSERT INTO khs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aluse selapita: alawamona, Felesi senayewi selese, “Alamakeye, ho olokeyatelawa iya:pela: hamonite, ho olokeyatela piseiki Seteneyewi penaiyawa Yesuyewi tiye ho olokeyatelawa hamonapita: hanatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Taune sopolowala, koamesa: kolotea emiwana, Yesuwa sila:sela: ela:, Yu senayewi kekenesene koane sopolo Yesuyewi solo napolo se tiye kine hapakeye. Eyawa se tiye kinise, “Kote Piseikipela: elakeye,” aluse solo napowa se tiye mikeye. Se Tiye kinise enene ikila emiwa, sena kesale noka nakola sosolo telawala, kolotea telawala, sopoke Yesuyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Fala: tesele ela: sena kesale sopoke Yesuyewi potapola: matanese, “A:pele sipi inawa itapalapita: a:pele sipi mokopo hapawa, hele kelesekeye. Aputa: a:pele sipi noka hopolo tese sita:tesekeye. Alusene amunuse sena kesale epesita:ya aluse sitalakeye.” Aluse Yesuyewi sena kesale sopowamopela: hauwekilise matanakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Hauwekilise matanepela: sena kesale mutawa, sena semetei nowamoke eta: seselamanase, Yesuyewi Ene sena ilipe hanosema pale selese, “I fo kenawa sosolapo. Alawamona i fowa supa:na:wa sena mutamanakeye. ");
INSERT INTO khs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Alake i fo kenawa tima:na: tisene senayewi supa:na:pela: hamonite alekena inama kulukulupa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesuyewi Ene sena ilipe hanosene kukuluipe sopoma mina selapita: minakeye. Inapita: iyewi ho olokeyatelawa iya:pela: hamonite, iwa ta:pele tiyapola: penaiyawa mikeye. Iyewi sena kesale nakola sosolo telawala, kolotea telawala, iyewi fala:pita:, ima Yesuyewi penaiyawa mikeye. ");
INSERT INTO khs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Apula: Yesuyewi sena kukuluipe ta:pele tiyapola: ima Apasolo sena unuwapokeye. Iwa unuwa tulawa wekeye. Saimone ene unuwapo nowa Pita, apula: nowa Saimoneyewi ene e ma:e A:nitulu, apula: nowa Sepeti e sa:le Yemese, apula: nowa Yemese ene e ma:e Yone, ");
INSERT INTO khs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","apula: nowa Filipi, apula: nowa Patalomiu, apula: nowa Tomase, apula: nowa takese tisene sena Ma:tiu, apula: nowa Afiase e sa:le Yemese, apula: nowa Tatiase, ");
INSERT INTO khs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","apula: nowa Lome kamaniyewi Yu sena pote enewa iya:pa:na:pela: matanesene sena Saimone, apula: nowa Yesu sihelelema:na: sena Yutase Isekeleote, epapuluse Yesuyewi sena kukuluipewa ta:peyakeye. Apasolo sena ta:peyawa ili epa akeye. ");
INSERT INTO khs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sena kukuluipe sopoma Yesuyewi selese, “Kiwa weyamu ha:na:pa:. Hanosekiwa Yu senamatela koamesa: hanapa. Samelia sena koamesa: hanapa. ");
INSERT INTO khs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A:pele sipi kelekeyeti epesita:ya amunuse Isolaiya sena kesalewa epapu sitalakeye. Ima selapose hamona. ");
INSERT INTO khs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hanapola: solo se tiye kinise, ‘Kote Piseikipela: epesene oka pa telakeye.’ Aluse sela:pa:. ");
INSERT INTO khs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sena kesale nakolawa iya:ta:pa:. Aputa: sena kesale kuluwa mene teisa:ta:pa:. Aputa: sena kesale wakapila telawa iya:ta:pa:. Aputa: ho olokeyatelayewi sena kesale ho tiwa ho olokeyatelawa iya:pela: hamonopa:. Aluse fala:tesene penaiyawa kiyewi mokopo tinase, kiyawa sena kesale sopoke mokopo iya:ta:pa:. ");
INSERT INTO khs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Alake kiwa hanosekiwa, kolo moweniwana, silifa moweni ukala, moweni kuluwala, moweni sopoke pausiwemi selawa tiyapola: hanapa. ");
INSERT INTO khs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kiwa makene hanosekiwa yetuwala, sao nowana, tiyapola: hanapa. Tamakawala, ininamowana, nano ketea sopoke tiyapola: hanapa. Alake kiyewi tima:na: tisewa tiyapose kiyewi sesela senayewi kima ma:na: nasewa kinapitekiwa ililakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kiwa makene hanapola: koamesa: hanapola: kiyewi ta:tese, ‘Napolo tesene sena ipa:?’ Aluse ta:pota:pa:. Ta:takamake walosaleke, koane musuluyetiye koane semetei kemi eniya:sela: sita:latipa:. Koamesa: nowa ha:na:na:nase koane kewa eniwa emi ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Koane enisewa walosaleke emi hanapola:, koane inawa tiya: hapolose ema selese, ‘Newa minakeye. Koteyewi kewa sela:tapita: kewa hopola epesita: matanekeye.’ Aluse se tiye kina:pa:. ");
INSERT INTO khs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Se tiye miwa koane inayewi ta:tapola: mina selapita:, hanosekiwa hopola tesewa ema se tiye kina:pa:. Aputa: koane inayewi inapasaleke hopola tesewa koane emiwa se tiye kinapa. Koane amowa iya:pela: ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aputa: sena nokamoke kima eta: nekanamake, kili sowa ta:te iya:tapitekiwa, koamesa: amowa iya:pela: ha:na:pa:. Hanose kilipe mapoyanase sena amawa Koteyewi ma epelekeye. Aluse iyewi matanemita: itipilise onatuwemi funu pupalulawa fipa:pela: apola: iya:pela: ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ta:ta:pa:. Neyewi kima heneye selakeye. Kotoma:na: opo emiwa sena kesale Sotome taunewemiwana Komola taunewemiwana olokeyatela timiya:sela: sita:newa fala:sima:na:wa sosolo tepesakeye. Alawamona, kiyewi se tiye kinakamake ta:ta: iya:peya taunewemi sena kesale sita:newa fala:sima:na:wa hele heneye sosolo tepesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sena ilipe hanosema Yesuyewi selese, “Ta:ta:pa:. Kiwa a:pele sipi hopola epapulakeye. Sena olokeyatelawa mowa kasolo yekele tela epapula sita:nenase Neyawa kiwa a:pele sipi amunawa hamona e selakeye. Aputa: kuya:lewa o:sulu hanosene epapuluse kiwala o:sulu ha:na:pa:. Senayewi kiwa ikomoma:pekise o:sulu ha:na:pa:. Aputa: a:nema: tumuyawa ketea nowa olokeyatela eta: timinisema epapuluse, kiyawala epapu ketea nowa timinipa. ");
INSERT INTO khs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Senayewi kiwa ikomoma:pekise pota:pa:. Kiwa sena nokamoke sukulu tiye kotosene koane kotopela:, aluse Yu senayewi kekenesene koane meiyewi kiwa pananepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aputa: kiyewi Newamo kulu hanosenase, kamani piseiki senayawala, sena peleya: kalikali piseikiwala, kiwa kotomita: sena nokamoke kiwa sutaposakeye. Sutapola: kotopita: kiyawa imawana, Yu senama telamawana, Ne solo seya selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kiwa kotopita: kiyawa sema:na:wa tutumatepa. Alake kiwa sema:na:wa kiyawa himu fa:nemi matanepitekiwa kiyawa selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kiyawa kipitane nowamoke matana maselaposakeye. Ki Ata Ho Napoyewi kima se tiye kinapita:, Eyewi se tiye mini semetei kamo, kiyawa selaposakeye. Kiyawa ili selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aputa: senayewi ene e ma:ewa sena nowamoke samita: sihelelepesakeye. Aputa: inayewi ene e sa:wa sena nowamoke samita: sihelelepesakeye. Aputa: salayewi ene inawa e ama a:ko: sena nowamoke samita: sihelelepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kiwa Newamo kulu hanosenase kiwa sena sopoyewi mapolopesakeye. Mapolopita: kemi sena kesaleyawa Newemi kulu hanosewa eta: iya:peyamake kokolo kemi Newemi matanepela: sitalapitekiwa, sena kesale amowa Koteyewi mene siliyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Siti nowemi kiwa ikomonosaleke nesila hanapola: siti nowemi ha:na:pa:. Siti nowemiwana iyawa kiwa ikomonosaleke kamunuse nesila hanapola: siti nowemi ha:na:pa:. Neyewi solo weyamo heneye selakeye. Sena Sa:wa Nekeye. Kiyawa Isolaiya peleya: siti sopolo Ne sowa se tiye kine hanose, se tiye kinapola: seta: itapa telamake, siti mutama noka se tiye kinise epesita:yemi newa mina:na:keye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yesuyewi selese, “Sukulu senayewi ene walosene senawa eta: helete tiye hanosemakeye. Aputa: tima:na: tisene senayewi ene inawa eta: helete tiye hanosemakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Walosene sena ela kamunuse sukulu salawala kamunuse kulu hanose sita:laleke ililakeye. Aputa: tima:na: tisene inawa ela kamunuse tima:na: tisene senawala, kamunuse kulu hanose sita:laleke ililakeye. Aputa: koane inawa amunawa Nekeye. Sena nokamoke Nema ikomonose selese, ‘Kewa Setene Piaosipukeye,’ au selesapekeye. Au seya amunuse Newemi pala sena kesalemawana, aluse sosolo ikomonose au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Alake kiwa ikomoma:na: senama ipipa. Ketea fopiyawa hokatopesakeye. Ketea mupapowa matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Neyewi kima semetei selapitekiwa, kiwa yopolotela epesita:ya, aluse sita:newa sikape solo mouwa kiyewi matanese, ho:lilisene epapuluse ho:lulupesakeye. Ho:liyawa sena sopoke ta:pita: Keyewi seyawa ima sela:pa:. Neyewi kima o:sulu seyawa sena sopoyewi ta:pita: koane sosolo towemi ela: unuwapo sela:pa:. ");
INSERT INTO khs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Senayewi kewa toma kumita: sanosaleke sena amawa ipipa. Sana senayewi ke howa eta: kulusemakeye. Aputa: kewa tomawana, howana, ikomonose heo peleya: emi hamona, ema:na: Kote semetei Ewamo ipipa:. ");
INSERT INTO khs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aputa: ketewemi a:nema: kelakela senayewi wa:la:losekeye. Wa:la:lose a:nema: kelakela amunawa elipei moweni usu kulu semeteiyewi wa:la:losekeye. A:nema: kelakela amunawa semetei peleya:wemi natesinisaleke, kiyawa Ki Atayewi potosekeye. ");
INSERT INTO khs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","A:nema: kelakela koloteawa Koteyewi pote tesekeye. A:nema: kelakela koloteawa pote tesenase, kili senawa Koteyewi hele heneye sosolo matanepela: pote elakeye. Pote ela: kili pisei fano sopoke Eyewi semetei semetei esa: aketiye matane tiye kotetikeye. Pisei fano aketiye pote tesenase kiwa ipipa. A:nema: kelakela mutawa Koteyewi matanepela: pote elakeye. Alawamona, kili senawa Koteyewi hele heneye sosolo matanepela: pote elakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yesuyewi selese, “Sena kesale sopoyewi ta:pita: sena nowamoke selese, ‘Newa Yesu kulu hanosekeye.’ Aluse selapitekiwa, Neyewi Ni Ata hepene falemi elakamoke ta:pita: Neyewi selese, ‘Newa kulu hanosene sena amowa akeye,’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Aputa: sena kesale sopoyewi ta:pita: sena nowamoke selese, ‘Newa Yesu kulu ha:na:na:pela: mapolokeye.’ Aluse selapitekiwa, sena amowa Nine Ni Ata hepene falemi elakamoke ta:pita: Neyewi selese, ‘Sena amowa Newa eta: kulu hanosemakeye. Newa eta: kulu hanosemanase ewa Neyewi iya:takeye,’ au selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesuyewi selese, “Kiyewi matanese, ‘Yesu minanase peleya: weyemi sena kesale sopoke takalese o:sulu hopola sitalaposakeye,’ aluse matanepa. Newa minanase sena kesale sopoke takalese o:sulu hopola masitalaposakeye. Sena kesale nokamoke Nema matana semetei matanepela:, apula: sena kesale nokamoke Nema matana semetei eta: matanamanase o:sulu hopola masitalaposakeye. Newa weyemi minanase sena kesale i kene kemi aloye tiye kisi tepela: sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Alake Newa minanase senayewi ene inawa elipe konomonose sitalaposakeye. Aputa: kesaleyewi ene e ama elipewala konomonose sitalaposakeye. Aputa: kesaleyewi ene e sena e ama elipe konomonose sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aputa: senayewi ene sena i semeteima, ene koane ilipe sita:ne i kene konomonose kisi tepela: sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Aputa: senayewi ene inawana ene e amawana matana ekela matanepela: Newa sikape meapolose matanesaleke, sena amowa Newanapulu ili maelakeye. Aputa: sena nowamoke ene sena salawala ene kesale salawala matana ekela matanese Newa sikape meapolose matanesaleke, sena amowa Newanapulu ili maelakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Newa i kelipapoya palese kuma:na:pela: i kelipapowa Nine Neyewi tiye hanosene epapuluse, kiyawala, peleya: weyamo keteawa sopoke sikape meapolose i kelipapoya tiye Ne onatu wapa:kemi fe onanese mainisaleke, kiwa Newanapulu ili maelakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sena kesale eta:wiye peleya: weyemi a elekiwa a potala epesenewa semetei matanesaleke, senayewi Kotema kokolo tesewa kelese matiyaposakeye. Aputa: senayewi Nema matanese, peleya: weyemi toma a pote epesenewa sikape meapolose matanesaleke, senayewi Kotema kao tesewa kelese tiyaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sena kukuluipe makene hanapita: Yesuyewi selese, “Kiwa koane inakamakiwa senayewi kiwa nekanese siliyapitekiwa amowa, Newamo siliyakeye. Newa silinase amowa, Newa hamona seya Kotewala siliyakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aputa: sepatosene senawa Koteyewi se tiye kinisene senakeye. Koteyewi se tiye kinisene senanase, se tiye kinisene senawa sena nowamoke nekanese silinase se tiye kinisene sena makene minama Koteyewi ketea heka kina kamunuse, sena koane pisilimawana, ketea heka semetei kamunuse kinaposakeye. Aputa: sena hekeya tesenase sena nowamoke ewa silinase, sena hekeya enema Koteyewi ketea heka kina kamunuse, sili senamawana, ketea heka semetei kamunuse kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aputa: Newemi pala sena koloteama sena nowamoke selese, ‘Kewa Yesu kulu hanosenase neyawa kewa hawa potia maita: kinakeye.’ Ala sena amawa Koteyewi ketea heka kinaposakeye. Ne solo we heneye selakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Sena ilipe hanosema Yesuyewi se tiye kinapola: itapa tepela:, koawa iya:pela: Kalili koamesa: noka koane pawemi sita:ne emi Yesuyewi se tiye miya:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yone tipolo ela: ta:takamake, “Kelesoyewi Kote penaiyawanapulu timiyanakeye.” Au selapita: eyawa ta:tapola: ene sena ilipe hanosene nokamawa selese, “Yesu elakemi ta:tapose hamona,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Hamonapita: iwa hanapola: Yesuma ta:tese, “Koteyewi sena hamonapita: mina:na: e seyawa Kewama? Sena nowama? Sena nowa inapele esa: niwa yesi sitalapa?” ");
INSERT INTO khs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Aputa: ima Yesuyewi selese, “Kiwa hanapola: kili ketea topuwala, ketea papowala, Yonema sela:pa:. ");
INSERT INTO khs_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Sena si kolawa fala:pe seli potalakeye. Aputa: sena onatu kete telawa salo heka:pe seli hananakeye. Aputa: sena wakapilawa fala:pe seli sitalakeye. Aputa: sena kena: seteyawa fala:pe seli ta:talakeye. Aputa: sena kuluwa mene tesile fiyanapola: sitalakeye. Aputa: sena nano ketea misitiya sita:nema Kote solo napowa se tiye kinakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Alake Newemi matana semetei matanesewa eta: iya:peyamake kao matanepela: sitalapitekiwa, sena kesalewa Koteyewi seila:tesekeye. Aluse nano ketea sopoke kiyawa Yonema sela:pa:.” Aluse sena minama Yesuyewi se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Se Tiye kinapola: itapa tepela: sena amowa mene hanapita: potapola: Yesuyewi sena muta kekenama selese, “Yoneyewi moawemi se tiye kinapita:, kiyewi moawemi ena popa:na:pela: hapala? Mawa alotowi ilelisewa popa:na:pela: hapala? Alamakeye, mawa alotowi ilelisewa popa:na:pela: eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kiyawa mawa popa:na:pela: eta: hapamake ena popa:na:pela: hapala? Sena toma tapola napolo kalawa popa:na:pela: hapala? Alamakeye. Sena toma tapola napolo kalasene piseikiyewi koawemi tesekeye. Sena toma tapola napolo kala tiye moawemi eta: tesemakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Alawamona kiyawa ena popa:na:pela: hapala? Kote solo se tiye kinisene sepatosene sena popa:na:pela: hapala? Henekeye, kiyawa Kote solo se tiye kinisene sepatosene sena sosowa papokeye. ");
INSERT INTO khs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Puwano fa:nemi Kote pukawemi Kote solo se tiye kinisene sepatosene sena nowamoke momateyawa wekeye. Heleye tima:na: senama Koteyewi selese, ‘Kewa a hanapose sena nowamoke puwano se tiye miya:na:pela: Neyewi hamonama:na:keye. Sena amokiwa Kewa isu ha:na:na:wa seila:taposakeye.’ Aluse Koteyewi selapita:, Kote se tiye kinisene sepatosene senayewi ta:tapola: momateyakeye. Aputa: Koteyewi sena puwano hamonama:na:wa Yonewa momateyakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Neyewi solo we heneye selakeye. Yone hano toliyetisene ewa peleya: weyamo sena kesale sopowa eye helepekeye. Alawamona, sena nowa ununama kolotea Kote Piseikipela: ela: hepene ene amoke Yonewa eye helepekeye. ");
INSERT INTO khs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yone hano toliyetisene eyewi Kote sowa se tiye kinise ma:ta: tiye hawemi tolusule ine napu ikila emiwa Kote Piseikipela: elaka heneye penaiya ofola ha:na:sela: alawamona, sena ikomoma:na: matana senawa emi ine ikomoma:na: minakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yone hano toluyetiseyewi solo se tiye seta: mimake, Piseiki mina:na:wa Koteyewi se tiye kinisene sepatosene senayewi momateyakeye. Aputa: Koteyewi solo ele momateyawa semetei kamunuse momateyakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Alake ili sowa kiyewi ta:tesaleke Ne sowala ta:ta:pa:. Ilaiya mene inaposakeye au seyawa Yonekeye. ");
INSERT INTO khs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kiwa kena:wa tela:yawa ta:tapola: seli ta:ta:pa:. ");
INSERT INTO khs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ikila weyemiwa sena kesale sita:newa Neyawa noko:lu sema:na:ne? Neyawa pale selakeye. Salayawa peleya: pakia fesamonose ilipe kemi sala nokamoke sala nokamawa selese, ");
INSERT INTO khs_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Niyewi kona fose sanawamona kiyawa epelese ninipe tese ninipe makisale selakeye. Niyewi siya:lata elawamona kiyawala ninipe tese maya:le selakeye,’ au seyakeye. Alake iwa epesita:ya amunuse, kiwala aluse sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yone hano toluyetisewa inise ma:na: nasewa alepela:la:, waine hawana eta: menamakeye. Manapita: potapola:, kiyewi selese, ‘Yonewa ho olokeyatela ho tilakeye,’ au seyakeye. Aluse kiwa Yonewemiwa eta: palemakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aputa: Sena Sa: Newa inisekiwa, ma:na: nasewana waine hawana nasekeye. Napita: potapola: kiyewi selese, ‘Yesuyewi ma:na:wa mete nasenakeye. Waine hawana sosolo nasenakeye. Aputa: sena takese tisewana, sena noka matana olokeyatelawala Ene E mananakeye.’ Aluse selese kiwa Newemi eta: palemakeye. Eta: palema kamo Kote matanawa Neyewi kulu hanose timinipita:, senayewi potapola: matanese, ‘Kote matanawa hekeyalakeye,’ aluse matanema:na:pela:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kolasini taunewemiwana, Pesaita taunewemiwana, Kapaneame taunewemiwana, Kote penaiyayewi matanepela: tisene Yesuyewi nano ketea muta timinipita:, sena kesale sita:neyawa papokeye. Potapola: kemi iyawa matana olokeyatelawa iya:pela: sita:pesena:pela: eta: iya:peyamakeye. Sita:pesena:pela: manotolopita: Yesuyewi ima kotopela: selese, “Kiwa kaluse olokeyatela sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Uo. Eta: fesamoma:na: telamanakeye. Kolasini sena kesale kiwala, Pesaita sena kesale kiwala, kiyawa potose kasele kiyawa mane olokeyatelawa maiya:tasaleke, kiwa sosolo falasipesakeye. Kili taunewemi Kote penaiyayewi matanepela: timinisewa Neyewi timiyakeye. Timiyawa Yu senama telayewi Taia taunewemiwana, Saetone taunewemiwana, Neyewi timinisaleke, ili mane olokeyatelawa puwano fa:nemi iya:papekeye. Iya:pela: ili mane olokeyatela timiyanase iwa ewalose sita:la:, tomawemi peleya:yewi mutapola: sao nasoya fopula: kotopola: aluse sita:pesapekeye. Aluse ka:la:lopela:la: ili mane olokeyatelawa iya:pela: sita:pesena:pela: iya:papekeye. Alawamona Neyewi timiyawa iyawa eta: papomakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ta:ta:pa:. Takalepela: kotopela: falasima:na: ikila emiwa Taia sena kesalewala, Saetone sena kesalewala, kolotea sosolo falasipesakeye. Kiyewi potose kasele epesene eta: iya:peyamanase kiwa sosolo falasipesakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapaneame sena kesale, kiyewi matanesekiwa, ‘Niwa wapilise sita:pesena:keye.’ Aluse matanepela: hepene taune fala a puwano aluse kiyawa kilipe unuwa tilipita: matana hanatakeye. Alawamona, sikape kiwa sena kulusene peleya: kolemi tolusupesakeye. Alake Kapaneame sena, kili taunewemi Neyewi tima:na: penanose ti aluse, Sotome taunewemi Kote solo se tiye kinisene sepatosene senayewi penanose timinisaleke, Sotome sena kesaleyewi ili mane olokeyatelawa iya:pela: sita:pesena:pela: iya:papekeye. Alake Kotema epesena:pela: iya:peyakiwa, Sotome taune amowa Koteyewi masakepimapekeye. ");
INSERT INTO khs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ta:ta:pa:. Koteyewi kotoma:na: ikila emiwa Sotome sena kesalewa Koteyewi kolotea sosolo falasisewa tuwataposakeye. Alawamona, kiyawa potapola: kemi mane olokeyatela iya:pela: epesena:pela: eta: iya:peyamanase, kiwa hele heneye sosolo falasisewa tuwataposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ikila emi Yesuyewi Kotema kulukuluse, “Ni Ata, hepene falemiwana, peleya: weyemiwana, Keyewi Piseikipela: pote elakeye. Pote elakamoke senayewi ketea sopoke matane tima Keyewi Kine mupapolo ketea amowa hokatolose walopakeye. Alawamona Keyawa kine sala epapulamawa Keyawa ketea fopiyawa hokatolose walokeye. Walopita: Neyawa Ke unuwa wapilise Kema napolo selakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ni Ata, Keyawa Kine matanawa senama walosekeye.” Aluse Yesuyewi kulukululakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kulukuluse itapa tepela: sena kesalema Yesuyewi selese, “Nano ketea sopoke Neyewi Ni Atayewi E penaiya Nema mikeye. Aputa: Neyewi matanawana, Neyewi alusewana, Nine Ni Atayewi Ene semeteiyewi potose matanesekeye. Aputa: Nine Ni Atayewi matanawana Eyewi alusewana, Neyewi Nine semeteiyewi potapola: matanesekeye. Matanepela: Nine Neyewi sena kesale matanama Ni Atayewi alusewana, matanesewana walosaleke, sena kesaleyewi potapola: matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kiyawa tima:na: tisekiwa mapolose hopolo tese, tima:na: hilila sosolo tiye hanose mapolose, penaiya itapa tese hopolo tepita:, Newamo elakemi ha:le tepa:se ina:pa:. Inapitekiwa kewa napolo hopola elaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Aputa: kopolo kao elipeiyewi tima:na: semetei tiye hamonite kepakuwemi i tuwapola: sakolosekeye. I tuwapola: sakolosene epapuluse kiyewi Nema selese, ‘Keyewi iwa Ne kenewemi tuwapola: sakome,’ e sela:pa:. Aputa: Neyewi ketea epe walosaleya kiyewi matane tiya:pa:. Newa hopola enenase Neyewi alusewa kiyewi matane tiya:pa:. Matane tiyapitekiwa kili howa eta: hopolo telamake penanose ha:le tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Alake Newanapulu tima:na: tiye hamonite ke kenewemi Neyewi iwa tuwapola: sakolawa ilikeye. Aputa: Ne tima:na: tisene hililawa feyapelesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ha:le tesene ikila semetei nowemi witi alekenawemi Yesuwala, Ene sena ilipe hanosewana hapakeye. Hanose sena ilipe hanosewa menipita:, witi fo kenawa su tiye menakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Napita: Felesi senayewi potapola:, Yesuma selese, “Ke sena kilipe hanoseyewi tima:na: epe tiseya pota:pa:. Iyawa tima:na: tisekiwa, ha:le tesene ikilawa ala:pewa hotoyetiyatakeye.” ");
INSERT INTO khs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Aputa: Yesuyewi selese, “Puwano fa:nemi Tepitiwala eyewi ene sena ilipe hanosewana sosolo menipita:, Tepitiwa Kote koane musuluyetiye Kotepela: falawa tiye tiwa tiyapola: menakeye. Aputa: Kotepela: falawa tiye tiwa Tepitiyawala, ene sena ilipe hanoseyawana ma:pekise ala:pekeye. Alake pilisiti senayewi iwamo semeteiyewi nasewa eta: ala:pemakeye. Alawamona Tepiti ewa pilisiti senama tela kamoke falawa ala:pewa menakeye. Aluse Kote pukawemi momateyalakeye. Momateyawa kiyawa aketiye mouwa matanepa? Alamakeye. Kiyawa mamataneselakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aputa: ha:le tesene okemi Kote koawemi pilisiti senayewi Kotema nano ketea hopola sanapola: satapola: kinapola:, aluse iyawa tima:na: timinisekeye. Aluse timinipita:, Koteyewi iwa eta: kotosemakeye. Aluse Kote pukawemi solo ele momateyawa kiyawa aketiye mouwa mamataneselakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ta:ta:pa:. Kiyawa matanepela:, ‘Koteyewi koawa puwanonakeye.’ Aluse matana kamona, Koteyewi koawa sikapetapo elakeye. Newa weyemi elakamowa putupela: elakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Alake Ne sena ninipe hanoseyewi olokeyatela eta: timiyama kamona, kiyewi iwa kotolakeye. Alake Koteyewi pukawemi momateyawa wekeye. Koteyewi selese, ‘Ne solo ele sepapowa kiyewi tomayewi kulu hanose, Nema nano ketea mokopo kinapita: Neyawa ma epelekeye. Alake sena kesale noka kiyewi hauwekilise sesepa:.’ Aluse Koteyewi selapita: momateyawa mouwa kiyawa mamataneselakeye. Kiyawa matanakiwa amowa, kiyawa Ne sena ninipe hanosewa makotomapetakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sena Sa:wa Nekeye. Ikila ha:le tesene okemi ketea aupa: aluse apolosewa, Neyewi Piseikipela: pote elakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesuyewi selese kotetise, Ewa hanapola: Yu senayewi kekenesene koane musuluyetiye potakamake ");
INSERT INTO khs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","sena tiya: pa:mo ti elapita: papokeye. Yesuyewi hele selapele esa: kotoma:na:pela:, Felesi senayewi selese, “Ha:le tesene ikila emiwa sena kesale nakola towayawa, sena nowamoke fala:tesaleke, sena amokiwa Koteyewi solo elewa hotiyetiyapa?” ");
INSERT INTO khs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Au selapita: ima Yesuyewi selese, “Ha:le tesene ikila emiwa kiyawa kilipe sena nowamoke a:pele sipi peleya: uwalokemi sutesinapitekiwa, a:pele sipiwa keyawa talo tiye tilipa:na:na? Henekeye, tilipa:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Alake, a:pele sipiwa senayewi semetei kolotea esa: matanesekeye. Alawamona, sena kesale amowa Koteyewi hele heneye sosolo matanepela: seselesekeye. Alake ha:le tesene okemi sena kesale seselesene amo, Koteyewi solo elewa mahotolakeye.” ");
INSERT INTO khs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aluse Yesuyewi Felesi senama selese kotetise, sena tiya: pa:mo tima selese, “Ke tiya:wa salo hekema.” Au selapita: e tiya:le amowa salo hekeyakeye. Salo hekelese tiya:le nono nowa napolo ela epapuluse, tiya: pa:mo tiwala itapa tese seli enekeye. ");
INSERT INTO khs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Napolo elapita: potapola: Felesi senawa hanapola: i kene sopolo selese se tise, “Yesuwa kumita: niyewi ikomoma:na:keye. Alake noko:lu ikomoma:na:ne?” Aluse Felesi senayewi selese se tikeye. ");
INSERT INTO khs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Felesi senayewi matanawa Yesuyewi potose, taune amowa iya:pela: hapakeye. Hanose sena kesale muta Ewalapulu ilipe hapakeye. Hanapola: sena kesale nakola towaya sopoke Yesuyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Fala: tesele ima selese, “Newa sena kesale sopoma selapa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Au seyawa seta: seyamake Kote solo se tiye kinisene sepatosene sena Aisaiayewi Kote pukawemi Yesuwa momateyakeye. Momateyawa wekeye. Koteyewi ewa selese, ");
INSERT INTO khs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ne sena tima:na: tisewa ekeye. Ewa Neyewi ta:peyakeye. Ta:pele tiyapola: Neyewi Ema matana iliyewi sosolo matanepela: epelekeye. Ema Neyewi Ho Napowa apoma:na:keye. Apolapita:, Ne hekeya hekelesewa Yu sena telama Eyewi selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eyewi matafapesakeye. Eyawa sosolo sowa masele hanaposakeye. Isu sosolo emiwa sena kesale sopoyewi ta:pita:, Eyawa unuwapo mahopesakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mawa koakena semeteiwala, Eyewi manaiye tiyaposakeye. Nafa tupa:tapola: yemeni tese sekakoma:na:pela: mapatopita:, Eyewi masekakoye tiyaposakeye. Sena kesale sopoke Eyewi seselese tima:na: tiye hanapola:, aluse hekeya hekelesewa Eyewi puwano putupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Puwano putuma:na:nase Ema Yu senama telayewi matanepesakeye. Matanepela: Koteyewi auma:na: seyawa popa:na:pela:, yesi sitalakeye.” Aluse, Koteyewi selapita: Aisaiayewi momateyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ikila emiwa sena nowa ho olokeyatelayewi ho tise, siwa kolose, sowa itapa telawa sena nokamoke Yesu elakemi siliye minakeye. Siliye minawa Yesuyewi senawa fala:walopita:, ene sowa itapa telawa iya:pela: napolo selese, apula: ene si kolawala itapa tese napolo pote aulakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aputa: sena kesale sopoke potapola: howa hanose selese, “Itapa tesene sena amowa Tepitiyewi sena i ma:ta: tiye mina sena nowa hetetima:na: e seyawa, ewamonikeye.” ");
INSERT INTO khs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aluse seyawa Felesi senayewi ta:tapola: selese, “Ho olokeyatela piseiki unuwa Piaosipu ewa Yesuwalapulu elakeye. Elanase Piaosipuyewi penaiyawamoke ho olokeyatelawa hamonapita: hanatakeye.” ");
INSERT INTO khs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aluse selapita: ili matanawa Yesuyewi potapola: pale selese, “Sena ilipe peleya: semetei sita:ne kamoke takalese tetese, sena amowa pula tiye iya: tese, kalikalise sita:la:, peleya:wa senanama tepesakeye. Aputa: sena koamesa: semetei i kene takalese tetese keneye tiyaposakeye. Aputa: sena i semetei i kenewana takalese tetese keneye tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Alusene amunuse Seteneyewi ho olokeyatelama hamona e seyakiwa, amowa ene a:kene elipe tetesene epapuluse tepapekeye. Seteneyewi ene sena manama takalese tetesene telakiwa iwa keniyetimapekeye. ");
INSERT INTO khs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Alake kiyewi selese, ‘Piaosipu Newanapulu enenase Eye penaiyayewi ho olokeyatelama hamonapita: hapakeye,’ aluse kiyewi selakeye. Aputa: kiyawa kilipe sena nokamoke ho olokeyatelama hamonama:na:pela:, ikamo iwalapulu papela: enena? A:me penaiyayewi ho olokeyatelama hamona seyala? Kiyewi selese, ‘Piaosipuyewi penaiyayewi aulakeye.’ Aluse kiyawa sowa mamene selaposakeye. ‘Koteyewi penaiyayewi aulakeye.’ Aluse kiyawa selaposakeye. Alake Neyewi timita: penaiyawamoke mouwa matanepa:se, kiyawa kilipe senayewi alusewa matanepa:. ");
INSERT INTO khs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Aputa: ho olokeyatelawa hamonite Koteyewi Ho Napowa Newanapulu enenase, E penaiyayewi hamonasekeye. Ho olokeyatela hanapita: potapola:, kiyawa weyamu matanepa:. ‘Koteyewi Piseikipela: pote epesene oka hetetikeye.’ Aluse matanepa:. ");
INSERT INTO khs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Aputa: sena nowamoke sena komono nano keteawa atu tima:na:pela:, puwano sena komowa meiyewi ta tiye tuwapola: apola:, e koane musuluyetiye ketea atu tisekeye. Sena komowa seta: tapoyama ela:, ewa kao komowa sela:sela: elapita: potapola:, e koane suwemiwa atu tima:na:pela: eta: musulusemakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Alanase, Newamo eta: kulu hanosema sita:ne sena kesaleyewi, Nema kisi tepela: elakeye. Aputa: Newemi pala sena kesale kiyawa, sena kesale noka masilisaleke, sena kesale amowa kiyawa alukepilakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Alake Neyawa kima heneye selakeye. Sena kesaleyewi olokeyatela tisewana, Kote kolotea meapolose selesewana, Koteyewi ili iya:pa:na: telalakeye. Alawamona, Ho Napowa sena kesale nowamoke kolotea meapolosaleke, Koteyewi maiya:taposakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aputa: Sena Sa:wa Nekeye. Nema sena kesale nowamoke tikili tese kolotea meapolose selapitekiwa, Koteyewi ewa iya:pa:na: telalakeye. Alawamona, Ho Napoyewi penaiyawa nowamoke potose selese, ‘Amowa Seteneyewi penaiyakeye.’ Aluse Ho Napowa kolotea meapolosaleke, sena kesale amowa, yemiwa peleya: weyemi a elakamokiwala, sikape mene teisa:pa:na: ikila emiwana, Koteyewi maiya:taposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yesuyewi selese, “I napoyawa i fowa napolo watosekeye. Aputa: i olokeyatelayewi i fowa olokeyatela watosekeye. I fowa potose i henewa matanesekeye. ");
INSERT INTO khs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Alake kiwa heseke amunanakeye. Kiwa olokeyatela sita:la: kiyewi noko:lu seli sema:na:ne? Sena kesaleyewi himu matanawemi selawapowa meakemi tese selesekeye. ");
INSERT INTO khs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Himu hapa keteawa himuyewi matanesekeye. Sena napoyawa matanayewi napolo matanepela: meatawa kulu hanose napolo selesekeye. Sena olokeyatelayewi matanayewi olokeyatela matanepela:, meatawa kulu hanose olokeyatela selesekeye. ");
INSERT INTO khs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Alake kotopela: tipipilise takalema:na: opo emiwa, sena kesaleyewi mokopo seya amopela: Koteyewi sena kesalema ta:taposakeye. Ta:tapola: iwa takalepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Takalepita: sena kesale nokamoke ene sela epa kamoke, ema falasima:na: peleya: emi hamonapesakeye. Aputa: sena kesale nokamokiwala ene meatewi sela epa kamoke, kewa Kote sikapowemiwa hekeya sena selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kote solo elewa walosene senayawala, Felesi senayawala, Yesuma selese, “Walosene sena, Kewa Kotewemi tese minanone esa: niyawa matanepa:se, Kote penaiyayewi matanepela: timinisewa Keyawa timinipa:. Timinipitekiwa niyawa popa:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aputa: Yesuyewi selese, “Opo weyemiwa sena kesale olokeyatela sita:la: Kotema himu semetei eta: matanamake nowama mokopo matanese selese, ‘Niyawa popa:na:pela: Kote penaiyayewi matanepela: timinisewa Keyawa matiminima:.’ Au selapita: kili sowa Neyawa ta: tiyapola: eta: timinima:na:makeye. Yonama ketea waiyawa semetei kima waloma:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Alake Kote solo se tiye kinisene sepatosene sena Yonawa ewalo sosolo suwemi, ikila usulupewala, yopolotela usulupewala, enekeye. Yonawa ewalo suwemi enene epapuluse Sena Sa: Newa peleya: kolemi ikila usulupewala, yopolotela usulupewala, aluse elaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aputa: Yonayewi Kote sowa se tiye kinapita:, Ninefa sena kesaleyawa ili olokeyatelawa iya:pela: sita:pesena:pela: ke iya:peyakeye. Alawemi ela: Koteyewi kotoma:na: okemi, Ninefa sena kesale amokiwa, sena kesale ikila weyemiwa olokeyatela sita:nenase ili olokeyatelawa walose selaposakeye. Alake kiyawa mane olokeyatelawa eta: iya:peyamanase, iyawa kiwa kotopesakeye. Aputa: Yonawa epamo fo:su puwano telawa Nekeye. Newa inapola: se tiye kinapita:, ikila weyemiwa sena kesaleyawa mane olokeyatelawa maiya:tatakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aputa: Solomoneyewi napolo matanepela: seyawa ta:tapose, fapo helele nokemi peleya: pama koma tapo kesale kuini amowa minakeye. Alawemi ela: Koteyewi kotoma:na: ikila emiwa, sena kesale ikila weyemi sita:neyawa Ne sowa eta: ta: tima ama, kesale kuiniyewi iwa kotopesakeye. Aputa: Solomone epamo fo:su puwano telawa Nekeye. Newa ikila yemiwa sena kesalewalapulu ninipe ela:, Kote sowa se tiye kinapitekiwa kiyawa mata:teselakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesuyewi selese, “Ho olokeyatela sena ho tiwa iya:pela: hanapola: peleya: seleyawemi fa:nano sita: tesekeye. Sila:sela: ela: ewa koane enima:na:wana, ewa ha:le hepesena:wana, kelekamakewa itapalapita: ");
INSERT INTO khs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ene matanese, ‘Sena suwemi koane epapula eniya:newa iya:pela: hapanase, emi epesena:pela: mene hanakeye.’ Aluse mene inapola: potakamake sena suwemi koane epapula sapela hokato nano ketea sopoke napolapita: potosekeye. ");
INSERT INTO khs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Potapola: ene ho olokeyatelawa e mana tomoipewa siliyapanosekeye. Ho olokeyatela tomoipewa mene sili amoke, ho olokeyatelawa puwano elakamoke olokeyatelawa sitiyetiye, iyewi hele heneye sosolo olokeyatela timinisekeye. Iwa siliyapola: inapola:, sena amo suwemi koane musulusene epapuluse musuluyetiye sita:tesekeye. Sitalapita: sena amowa hele heneye olokeyatela tesekeye. Puwano ho olokeyatelawa semetei enene ikila emiwa, sena amo olokeyatelawa koloteasukeye. Aputa: oloipewa inapola: sitalapita:, sena amo olokeyatelawa sosolo tesekeye. Alusene amunuse ikila weyemi sena kesale sitalakamokiwa olokeyatela timinipita: ima aupesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuyewi sena kesale sopoma se tiye kinise enene ikila emi, Ene E amawana, Ene E ma:ewana minakeye. Inapola: peleya: pakia sita:la: iyewi selese, “Niyawa Yesuma nano nowa sema:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aluse selapita: sena nowamoke ta:tapola: Yesu koane suwemi enewemi Ema selese, “Keyewi kine ki amawana, kine ke ma:eyawana, Kema nano ketea selapose inapola:, peleya: pakia kolemi sitalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Au selapita: Yesuyewi ema selese, “Ni amawa ipa:? Ne ma:ewa ipa:?” ");
INSERT INTO khs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aluse Yesu Ewemi pala sena kesale kekenama tiya:yawa walose selese, “Ni amawana, Ne ma:ewana, kili ka:la:ya epakeye. ");
INSERT INTO khs_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Alake sena kesaleyewi Ni Ata hepene falemi elakamoke matanawa kulu hanose timinisaleke, sena kesale amowa Ne ma:e, Ne ate, Ni amawa akeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ikiwapo semetei kemi, Yesuwa koawa iya:pela: hanapola: hano hawe henekeye. ");
INSERT INTO khs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Henewanapulu, sena kesale muta kekenese peleya: walupita:, Yesuwa tesile hanapola: potuwemi hela:, sena kesale hano hawe sita:nema nano ketea seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Solo muta pale selese Eyewi seyakeye. Eyewi selese, “A:lekena senayewi nakela sa:le fipila: hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Fipila: hanose hapa ikila emiwa, nakela sa:le noka isu kiwemi sululuwayakeye. Sululuwayawa a:nema:yewi menakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aputa: nakela sa:le noka etewa wapa:kemi peleya:wa koloteawemi sululuwayawa, kipila sopopela: seka seli eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Seka seli eta: hapamanase, otowi sanose ofolose onose olo tikeye. ");
INSERT INTO khs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aputa: nakela sa:le noka, nakela sa:le ona sita:ne olapowemi sululuwayakeye. Sululuwayawa nakela sa:le ona sita:ne alapulu ilipe fiyanekeye. Fiyanese nakela ona sita:newa sololose nakela e sa:wa foluse siwa sakolose yapetowayakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aputa: nakela sa:le noka peleya: napowemi sululuwayawa sopopela: fowa wapokeye. Fowa watose, noka fowa sakopolo semetei wata:, noka fowa talo tekapeipe wata:, noka fowa talo usulupe wata:, aluse wapokeye. ");
INSERT INTO khs_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kiwa kena:wa elaleke ta:tapola: seli ta:ta:pa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sena ilipe hanosene inapola: Yesuma ta:potose, “Ko:lupita: Keyawa sena sopoma paya sopolo sela:?” ");
INSERT INTO khs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aputa: Yesuyewi selese, “Kiyawa ta:pita: Kote Piseikipela: ela mupapowa sowa mouwa yemiwa kima hokatolose selakeye. Alawamona, sena sopoma solo mouwa hokatolose maselakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kote Piseikipela: elakamowa solo mouwa kiyawa matanekeye. Matanepitekiwa kima nano ketea nowana waloma:na:keye. Walopita: kili matanawa solopesakeye. Aputa: senayewi mouwa eta: matanemake, puwano topuwala kepoliyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ili siyewi potose potapola:, mouwa seli eta: matanesemakeye. Ili kena:yewi ta:tese ta:tapola:, himuyewi seli eta: matanesemakeye. Alake, ima paya sopolo selalakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iyawa eta: matanemake ta:te iya:peyawa seta: ta:te iya:peyamake puwano fa:nemi Kote solo se tiye kinisene sepatosene sena Aisaiayewi selese, ‘Iyawa ta:tese ta:taposakeye. Topu kamona mouwa mamatanepesakeye. Iyawa potose potaposakeye. Papo kamona mouwa seli mamatanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Alake sena kesale sopoke ili himu talapoiya tese sitalakeye. Ili kena:yewi ta:tesewa ta:pa:na:wa mapolose kena:wa seteyakeye. Ili siyewi popa:pekise siwa sitiyapoyakeye. Ili himuyewi matanema:na:wa mapolose seli mamatanekeye. Ili matana olokeyatelawa Neyewi itapa temita: iwa Newemi epesene matetakeye.’ Aluse, Aisaiayewi seyawa heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Alawamona, kiyewi siyewi potose potapola: matanekeye. Kili kena:yewi ta:tese ta:tapola: matanekeye. Alanase epelese sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Neyewi kima heneye selakeye. Kiyewi nano ketea papowa Kote se tiye kinisene sepatosene sena mutayawala, Kote matanesene sena hekeya sita:neyawala, iyawa popa:na:keye e seya kamona, iyawa eta: papomakeye. Kiyewi nano ketea topuwa iyawa ta:pa:na: tekeye e seya kamona, iyawa eta topumakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yesuyewi selese, “Kiyawa matanemita: nakela sa:le fipila pale seya mouwa wekeye. ");
INSERT INTO khs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nakela sa:le isu kiwemi sululuwaya amunawa wekeye. Sena kesalewa Koteyewi Piseikipela: pote elakeye, au seyawa senayewi ta:tapola: mouwa seli eta: matanamanase, solo topuwa Seteneyewi kipila atu tisekeye. ");
INSERT INTO khs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Aputa: nakela sa:le etewa wapa:kemi sululuwaya seka seli eta: hanosema amunawa wekeye. Sena kesaleyewi Kote sowa ela:pe kipila ta:tapola: epelese alawamona, hele heneye eta: ta: tisemakeye. Eta: ta: timake ikila koloteawemi ta: tiyapola: sita:nenase, sikape mane olokeyatela hetetiyapitekiwala, sena nokamoke Kote solo ta: ti sena kesalema ikomonosalekiwala apula: potapola: Kote solo topuwa kipila iya:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aputa: nakela sa:le ona sita:ne olapowemi nakela sa:le sululuwaya, fowa seli eta: wapoma amunawa wekeye. Sena kesaleyewi Kote sowa topu kamona, peleya: weyamo ketea kete matanayawala, nano ketea sosolo tiyapola: mokopo epelese matanayawala, elipei amoke Kote sowa foluse siwa sakolose yapetowayakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aputa: nakela sa:le peleya: napowemi sululuwaya fowa muta wapo amunawa wekeye. Sena kesaleyewi Kote sowa ta: tiyapola: hele heneye matana semetei matanepela: sitalapitekiwa, i fo sakopolo semetei watosene aluse sita:tesekeye. Aputa: noka talo tekapeipe apula: noka talo usulupe aluse watosene epapuluse, sena kesalewa aluse sita:tesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesuyewi sena kesale sopoma pale selese, “Koteyewi Piseikipela: pote ela amunawa wekeye. Senayewi kelekamakewa nakela sa:le napolo alekenawemi fipilakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Fipipela: apola: nukulapo sena sopoke fayelapita: kisi sena inise witi fipilawemi hano ketale fowa fipipela: apola: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hanapita: nakela sa:le fipilawa fiyapepela: fowa watosene opo emi potakamake, hano ketalewala witiwanapulu elipe fiyanapola: fowa helepita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Potapola: tima:na: tisene senayewi inapola: alekena inama selese, ‘Piseiki, ke alekenawemi witi sa:le semetei kelala? Witi sa:le semetei fipilawemi noko:lu hano ketalewa elipe fiyanene?’ ");
INSERT INTO khs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Au selapita: alekena inayewi selese, ‘Kisi senayewi o:sulu inapola: hano ketale fo amowa, witi alekenawemi fipilalakeye.’ Au selapita: tima:na: tisene senayewi alekena inama ta:potose, ‘Hano ketalewa tuku tiye iya:pa:na:wa ililapa? Hano ketalewa ko:lumeinapa?’ ");
INSERT INTO khs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Au selapita: alekena inayewi selese, ‘Aupa, kiyawa hano ketalewa tuku tiye sotukepilisaleke, witi amowa hele tokopa solotiye iya:pa:pekise hano ketalewa tutapa. ");
INSERT INTO khs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Elipe sopoke kemi sita:pesita: iya:ta:pa:. Sikape napoyalapita: ma:na:pela: supa:na: ikila emi, tima:na: tisene senama neyewi selese, “Hano ketalewa puwano nasolo tiye sako tiye tei kilima:na:pela: tiye tiyapola: witi henewa su tiye koane tiye tima,” ’ au selaposakeye.” Aluse Yesuyewi pale seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sena kesale sopoma Yesuyewi pale seya nowa selese, “Sena kesale Koteyewi Piseikipela: pote elakamowa, i maseta fo sena nowamoke ene alekenawemi kela epapulakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maseta fo heneye kolotea kamoke, sopopela: alekenawemi nakela kelawa sitiyetiye i amuna tese sosolo tesekeye. Sosolo tese enewemi i elewa a:nema: fa:nano sitalaka inapola:, a:nema:yewi aiwa tisekeye. Alusene amunuse sena kesale Koteyewi Piseikipela: pote elakamowa epapulakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesuyewi pale seya nowa selese, “Sena kesale Koteyewi Piseikipela: pote elakamowa, falawa solosene epapulakeye. Kesaleyewi falawa sapa:na:pela: falawa muta tiyapola: nano solosewanapulu papela: notolose notolopita:, nano soloseyewi falawawa ene matana solosekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesuyewi seya ikila emi sena kesale muta kekenama Yesuyewi pale selese, heneye hokatolose eta: seyamakeye. Pale seya sopolo seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Seta: seyamake ela:pe puwano Kote solo kinisene sepatosene senayewi Yesuwa seyawa wekeye. Piseikiyewi Ene selese, “Sena kesale sopoma Neyewi pale selaposakeye. Peleya: ma:ta: ti ikila emiwa ketea mupapowa, yemiwa solo mouwa sopoke heneye hokatolose selakeye.” Au seyawa heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sena kesale muta kekenawa, Yesuyewi iya:pela: hanapola: koane musuyakeye. Musulupita: sena ilipe hanosene inapola: Yesuma selese, “Alekenawemi hano ketalewala, witiwalapulu elipe sopola pale seyawa mouwa nima hokato sema.” ");
INSERT INTO khs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aputa: Yesuyewi selese, “Witi sa:le napolo alekenawemi kelesene senawa Nekeye. Sena Sa:wa Nekeye. ");
INSERT INTO khs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Alake, alekena amunawa peleya: sosolo wekeye. Witi sa:le napolo amunawa Kote Piseikiwemi pala sena kesalekeye. Hano ketale fo amunawa Setenewemi pala sena kesalekeye. ");
INSERT INTO khs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kisi senayewi hano ketale fowa fipila amunawa Setenekeye. Fowa napoyalapita: sutusene amunuse, peleya: we itapa tema:na: opo emiwa auma:na: akeye. Tima:na: tisene senayewi hano ketalewa nasolo tiye, witi henewa su tiye koane tiye tima:na: senawa hepene senakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hano ketale sako tiye teiwemi kilima:na: amunuse, sikape peleya: weyamowa itapa tema:na: opo emiwa aluse kilipesakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Sena Sa:wa Nekeye. Neyawa hepene sena hamonapita: inisekiwa, senayewi olokeyatela timinimita: polusene senawana, olokeyatela tisene senawana, sopoke tiyapola: teiyewi wa:mita: tei emi tolusupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tolusula emi iwa falasise sita:la: ya:pelese peka kalo na:sela: sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ikila emiwa ikilale otowi sakalepasolose ho:lilisene amunuse hekeya sita:ne sena kesalewa ki Ata Piseikipela: elakamoke peleya: emiwa aluse ho:lulupesakeye. Kiwa kena:wa telalaleke, seli ta:ta:pa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesuyewi pale seya nowa selese, “Koteyewi sena Piseikipela: pote enewa, ketea hele heneye napolo himu hapa keteawa pokose selatiye, alekenawemi tikipiya epapulakeye. Sena tikila:pela: inakamakiwa, nano hele heneye himu hapa keteawa potapola:, himunama tese eyawa kemi fopulusekeye. Fopula: apola: hanapola:, sosolo epelese ene nano keteawa sopoke tiyapola: sena nowama wa:la:lopela: moweni tikeye. Moweni tiyapola: moweniyewi alekena amowa wa:la:yakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aputa: Yesuyewi pale seya nowana selese, “Koteyewi Piseikipela: pote elakamowa, pisinisi senayewi kapolo napowa wa:la:loma:na:pela: keye hanosene epapulakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pisinisi senayewi kapolo keye hanapola: kapolo hele heneye napowa potose wa:la:loma:na:pela:, ene nano ketea sopoke tiyapola: sena nowama wa:la:lopela: moweni tikeye. Moweni tiyapola: moweniyewi kapowa wa:la:yakeye.” Aluse Yesuyewi pale seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yesuyewi pale seya nowa selese, “Koteyewi Piseikipela: pote enewa nete ewalo tisene epapulakeye. Ewalo tima:na:pela: nete hawemi toliyetikeye. Toliyeti emi ewalo kalikalila sopowa talalapita: tikeye. ");
INSERT INTO khs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tiwa woliyetilapita: senayewi netewa tiyapola:, hano hema tuwapola: apola: ka:la:lopela:la:, ewawa takayakeye. Takalese ewalo napowa tiyapola: tisi menekiwemi tiye tiyapola:, ewalo olokeyatela eta: nasemawa sotukaiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ala amunuse sikape peleya: we itapa tema:na: ikila emiwa aupesakeye. Sena napowalapulu olokeyatelawalapulu tisilakolose sita:newa hepene senayewi takalepesakeye. Sena kesale olokeyatelawa takale tiyapola:, teiwemi wa:mita: tolusupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tolusulawa falasima:na: peleya: emi sita:la: ya:pelese peka kalo na:sela: sitalaposakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Alake Yesuyewi Ene sena ilipe hanosema selese, “Neyawa kima seyawa sopoke matanepa?” Aputa: iyewi “Henekeye, matanekeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Au selapita: Yesuyewi solo nowa selese, “Neyawa Kote Piseikipela: pote elakamowa selapita:, Kote sowa walosene senayewi ta: tiyapola: Newemi pala senawa koane inawa epapulakeye. Alake koane inayewi nano ketea napolo tiye tiwa tiyapola:, napute tiye tiwala, puwano tiye tiwala, tiyapola: sena amawa kinisekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesuyewi aluse pale selese kotetise Kapaneame taune amowa iya:pela:, ");
INSERT INTO khs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nasalete Ene koamesa:wemi Ewa hapakeye. Hanapola: emi ela: Yu senayewi kekenesene koane nano ketea se tiye kinapita:, sena kesaleyewi ta:tapola: howa hapakeye. Howa hanose iyewi selese, “Koteyewi matanesene solo napowa Eyawa kami topule. Eyawa Kote penaiyayewi matanepela: epe tiseya kami matane tile? ");
INSERT INTO khs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sena amowa Ewa kapenetayewi e sa:keye. Ene E amawa Melikeye. Aputa: Ene e ma:ewa Yemesewala, Yosepewala, Saimonewana, Yutasewala iwakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ene ololowa niwanapulu ninipe sita:la:keye. Eyawa semetei penanose epe tiseya kami matane tile?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aluse iyewi Yesuma matana semetei eta: matanemake iye Ema hele matanakeye. Hele sitalapita:, Yesuyewi ima selese, “Kote solo se tiye kinisene sepatosene senayewi ene koamesa: sena ilipe sita:ne amokiwala, ene koane enisewa sena ilipe sita:ne amokiwala, ewa puwano putuluse eta: matanesemakeye. Mamatanepita: kemi, koamesa: nowemi sena kesale nokamoke Kote se tiye kinisene sepatosene senawa puwano putuluse matanesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Selese Ene koane sena kesaleyewi Ema matana semetei eta: matanamanase Yesuyewi Kote penaiyayewi matanepela: tima:na: tisewa sosolo eta: timakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yesu Ewa Kalili peleya: emi sowa kinise enene ikila emiwa, Kalili peleya: pote enene senawa Helote Antipasekeye. ");
INSERT INTO khs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aputa: Yesuyewi penanose tima:na: tisekeye selapita:, Heloteyewi ta:tapola:, e tima:na: tisene senama selese, “Sena penanose tima:na: tisewa Yone hano toliyetisene amunikeye. Ewa sana kuluwa mene tesilakeye. Mene tesilapola: penanose epe tiseya Yoneyewi penanose tima:na: tiyatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Helote Kalili peleya: pota: tesene senayewi ene e ma:ewa Filipikeye. Filipiyewi ekele Helotiasewa Heloteyewi atu tiya:sela: elapita: potapola:, Yoneyewi Helotema kotopela: selese, “Kesale amowa keye atu tiya:sela: elakamowa solo ele tuwapowa hotoyetiyatakeye.” Au selapita: Heloteyewi Yonewa tipolo selawapa:na:pela: sena ta:le tima selese, “Yonewa sukulu tima.” Au selapita: sena ta:le tiyewi Yonewa sukulu tiye tiya:wemi tapola: tipolo selawapokeye. ");
INSERT INTO khs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tipolo selawapola:, Yonewa kumita: sama:na:pela: elawamona, Yu sena nokamoke selese, “Yonewa Kote solo se tiye kinisene sepatosene senanakeye.” Aputa: ta:tapola: Heloteyewi matanese, “Neyawa Yonewa sana kulusaleke, sena mutayewi nema konomoma:na:nakeye.” Aluse matanese senayewi ema konomoma:pekise ipilise ela:, Yonewa sama:na:pela: elawamona, iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Iya:pela: Helote ene ewa selati oka hetetiyapita: matanema:na:wa tikinise, sena sopoyewi popita: Helotiyase ene e la:le kesale polayewi tanase ese kisalakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tanase ese kisapita: potapola:, Heloteyewi epelese kesale polama selese, “Keyawa nano ketea kina:pa:saleke, neyawa kema miya:na:keye. Neyawa heneye maselesalekiwa Koteyewi potaposakeye.” Aluse hekilase seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Selapita: Helotiyase ene e la:ma setalese selese, “Yone hano toluyetisene piseiwa na tiye, menekiwemi tuwapola:, nema miya selepa:. Ewa heneye sana kuluwa popa:na:pela: ene piseiwa miya selepa:.” Au selapita: solo amowa ene e la:yewi ta: tiyapola: Helotema kao seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Selapita: piseiki Heloteyewi ta:tapola: himunama enekeye. Mapolose ela: eyewi matanese, neyewi miya:na:keye esa: hekilase seyawa, sena tikinise kekena sopoke topunase, piseiwa na tiye kina:pa: e seyawa iya:takamakiwa, ewama:pekise eyewi seyawa eta: iya:peyamakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eta: iya:peyamake sena ta:le tiyewi Yone piseiwa naiye timita: tipolo koane hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aputa: tipolo koane hanapola: Yone piseiwa na tiye menekiwemi tuwapola: tiye inapola: kesale polama mikeye. Kinapita: tiyapola: ene e ama Helotiyasema mikeye. ");
INSERT INTO khs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aputa: Yoneyewi e sena ilipe hanosene inise Yone toma sopowa tiyapola: hanapola: peleya: tikipela: Yesuma Yone sana kuluwa selapose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yone hano toluyetisewa sana kululopita: Yesuyewi ta:tapola:, Yesuwa potiwemi tapela: hanapola:, mowa peleya:wemi sena itapawemi Ene enapotane mosote epesena:pela: hapakeye. Hapalopita: ta:tapola: sena kesale muta iyawa ili koamesa: iya:pela:, Yesu kulule hanose hano hema isu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hanapola: kekenawemi Yesuwa inapola: potiwa papela: potakamake sena kesale sopoke kekenanapita: papokeye. Potapola: iwa hauwekilakeye. Hauwekilise matanepela:, sena kesale nakola towayawa Eyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Fala:ta:sela: ela: ka:le oka sinapita: Yesuma E sena ilipe hanoseyewi selese, “Peleya: we mowa peleya:nase sena kesalewa masitalakeye. Oka sininase sena kesale kekenama iliwa ilipe ma:na: ma:na:wa wa:la:loma:na:pela: koamesa: mene hamona sema.” ");
INSERT INTO khs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Au selapita: Yesuyewi selese, “Iwa hamona sewa ko:lupita: ela:? Kiyawa ki ima ma:na: ma:na:wa kina:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Au selapita: sena ilipe hanoseyewi selese, “Ma:na: ma:na:wa falawawa pipe, ewalo elipei ala telakeye. Ma:na: nowa matelakeye.” ");
INSERT INTO khs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Au selapita: Yesuyewi selese, “Ma:na: ma:na:wa Nema tina.” ");
INSERT INTO khs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aluse sena kesale sopoma Yesuyewi selese, “Kiwa sopoke hutiyawemi ka:la:loma.” Aluse iwa ka:layakeye falawa pipe ewalo elipei tiyapola: ela:, hepene falemi pota:la:, Kotema napolo esa: kulukulupela: kotetise, falawa pasoloyetiye sena ilipe hanosema kinapita:, sena ilipe hanoseyewi sena kesale sopoma mikeye. ");
INSERT INTO khs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kinapita: sena kesale sopoke ili menakeye. Napela: kotetipela: falawawala ewawala muyawa kemi teselapita:, sena ilipe hanoseyewi elale kukuluipewemi selatiye woliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Sena ma:na: mena sopowa akeyawa pipe taosenekeye Kesalewala salawala iwa sopoke eta: akeyamakeye. Iwa eta: akeyamawana, iyawa sopoke menakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sena kesale sopoyawa ma:na:wa napela: kotetiyapita:, Yesuyewi E sena ilipe hanosema selese, “Kiwa puwano potiwemi tapela: hano hema tapo fa:nemi ha:na:pa:. Aputa: sena kesale kekenawa ili koane meneyetiye hamona, au sema:na:keye.” Au selapita:, iwa potiwemi tapela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hanapita: sena kesale sopoke kekenawana i koane mene ha:na: tiyakeye. Ha:na: tipita: Yesuwa Ene enapotane tokowemi kulukuluma:na:pela: hapakeye. Hanapola: nukulapo Yesuwa Ene enapotane kulukulula:sela: enekeye. ");
INSERT INTO khs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kulukuluse enewemi sena ilipe hanosewa potiwemi tapela: hano honosane hanakamake, hano ko:luyewi poti piseiwemi sanose hano ko:lu alokalapulu sosolo inise potiwa tiye fiyane sine esa: potiwa koyawa eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Potiwa koya:sela: sita:la:, mowa ikiwapa:na: mapatoyawemi Yesuwa poti alupa:pa:la:ne pawemi hano wapa:kemi onane minakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Inapita: sena ilipe hanoseyewi potapola: hele heneye himunama tese ka:la:lopela:la: kalose holose, “Ho olokeyatela inatakeye.” ");
INSERT INTO khs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aluse ipilise hopita: ima Yesuyewi ela:pe kipila selese, “Nekeye. Kiwa ipipa. Ipilise matana kipilapa. Penanose sita:latipa:.” ");
INSERT INTO khs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Aputa: Pitayewi selese, “Piseiki, Kewama? Kewalaleke, Keyawa nema hano wapa:kemi onane mina sema.” ");
INSERT INTO khs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Au selapita: Yesuyewi selese, “Kewa mina.” Aluse selapita: Pitawa potiwa iya:pela:, Yesu elakemi hano wapa:kemi onane hanose ");
INSERT INTO khs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ta:takamake, alotowi e tomawemi sanapita: topukeye. Ta:tapola: ipilise ewa hawemi mutule sima:na: tepita: holose, “Piseiki, newa tima.” ");
INSERT INTO khs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Au selapita: ela:pe kipila Yesuyewi tiya:yawa Pitawa tiyapola: selese, “Keyawa Nema matanayewi semetei kolotea matananakeye. Keye matanesekiwa, ‘Ili hanosekiwalo, hawemi mutule sinisekiwalo ema:pelipe.’ Ko:luse matana elipei matanana?” ");
INSERT INTO khs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aluse a:ko: potiwemi takamake alopowa itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Itapa tepita: potapola: sena potiwemi ka:la:yawamoke Yesuma wapilise selese, “Kewa heneye Kote E Sa:keye.” Aluse wapilise seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Hano ka:na enene potiwa kolo tiye sanese, Yesuwala, E sena ilipe hanosewana, poti kolo tiye hanapola:, Kenesalete peleya: emi hetetikeye. ");
INSERT INTO khs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hetetiyapita: senayewi potapola: matanese, “Amowa Yesulapo.” Aluse matanepela: solo sekepilise, “Yesuwa minawa peleya: pawemi selapose ha:na:pa:.” Aluse sowa sekepilapita: hanapola: seyakeye. Selapita: ta:tapola: sena kesale sopoke nakola towayawa Yesuyewi fala:pita: siliye minakeye. ");
INSERT INTO khs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Siliye mina senayewi Yesuma selese, “Sena kesale nakola towayama Keyawa sao fili sosowemi kesakamake ilima:na: telalapita: ilikeye e sema.” Au selapita: Yesuyewi ilikeye e seya. Ilikeye epela: E sao sosowa sena kesale nakola towayama kesakamake ili nakola towayawa itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Felesi senayawala, Kote solo elewa walosene senayawala, Yelusaleme sitiwa iya:pela: Yesu elakemi inapola: ta:potose, ");
INSERT INTO khs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ko:lupita: Ke sena kilipe hanoseyewi nini tilila kouwayewi aupa:, esa: sele minawa tikapeyetipela: sita:la: tikapeye tise, iyawa ma:na: napose tiya:wa ma selakotakeye. Tiya:le eta: selakolamake ma:na: tiye natakeye.” ");
INSERT INTO khs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Aputa: Yesuyewi ima ta:potose, “Ko:lupita: kili tilila kouwa meiyewi aupa:, esa: sele minawa puwano apoma:na:pela:, kiyawa Kote sowa tikapeyetipela: sita:la? ");
INSERT INTO khs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ta:ta:pa:. Kote sowa tuwapowa wekeye. Koteyewi selese, ‘Kine ki ata ki ama a:ko: seli matanepela: seila:ta:pa:,’ au seyakeye. Kote solo nowana selese, ‘Senayewi ene e atawala, ene e amawana, henipasolosaleke ewa heneye kumita: sanapa:.’ ");
INSERT INTO khs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Aluse Koteyewi seya kamona kiyewi selese, ‘Senayewi ene e atamawana ene e amamawana selese, “Neyewi ka:mawa nano ketea mokopo miya:na:pela: elawamona, Neyawa iya:pela: Kotema kinakeye.” Ala senayawa ene e ata e ama a:ko: seila:ta:pa: aluse Kote solo tuwapowa iya:pela: tikape tesewa ilikeye.’ Aluse kiyawa Kote solo amowa kolotea apolakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Aluse kiyawa kilipe tilila kouwa meiyewi aupa:, esa: sele minawa puwano apoma:na:pela:, Kote solo elewa kiyawa sowa epelese etayakeye. Sowa epelese ela:, kiyawa ki ata ki ama a:ko: pote epesenewa iya:takeye. ");
INSERT INTO khs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kiwa matana elipe sitalakeye. Puwano fa:nemi, Kote solo se tiye kinisene sepatosene sena Aisaiayewi kiwamopela: heneye seyakeye. Seyawa wekeye. ");
INSERT INTO khs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Koteyewi selese, ‘Sena kesale amokiwa Nema meatewi wapilise kemi alawamona, ili himuyewi Nema mamatanekeye. ");
INSERT INTO khs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Matanayawa Nema eta: matanemake, mokopo meapo sopoyewi Nema wapilikeye. Iyawa i kene senayawa matanawa se tiye kinakeye. Se tiye kinisakasele Ne solo elewa iyawa se tiye makinakeye.’ Aluse, Koteyewi selapita: Aisaiayewi momateyakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sena kesale sopoke kekenemita: Yesuyewi minapita: inapita: ima selese, “Ta:ta:pa:. Ta:tapola: matanepa:. ");
INSERT INTO khs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Senayawana, kesaleyawala ene meatewi ma:na: nakamokiwa ene ewa eta: akeleya tesemakeye. Alawamona, meakemi tese solo olokeyatela hetetiyakamoke ene ewa akeleya tesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sikape Ewamo enewemi E sena ilipe hanosene inapola: Ema selese, “Ke solo se tiye kinisewa, Felesi senayewi ta:tapola: mapoyalapokeye. Keyawa topula?” ");
INSERT INTO khs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Au selapita: Yesuyewi selese, “Nakela sa:le kelawa Ni Ata hepene falemi elakamoke eta: kelamawa sopoke tutaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Alake sena si elipe kolayewi isuwa walosene epapuluse, Felesi senayewi aluse walokeye. Sena si elipe kolayewi sena si elipe kolawa nowa siliye hanapita:, a:ko: elipe uwalokemi sutesinaposakeye. Auma:pekise kiwa Felesi senawanapulu papa.” ");
INSERT INTO khs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aputa: Pitayewi selese, “Pale seya mouwa nima sema.” ");
INSERT INTO khs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aputa: Yesuyewi selese, “Kiyawa mouwa kemi mamatanepa? ");
INSERT INTO khs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma:na: menawa ipuwemi hanapola: ipuwemi tese iti komowemi sinapola: ika olosekeye. ");
INSERT INTO khs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Aputa: himuyewi olokeyatela matanawa meatawala olokeyatela selakamoke, ene ekemi akeleya tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Alake sena kesaleyewi matanawemi ketea olokeyatela matanepela: sita: tesewa wekeye. Olokeyale matanesewana, sena kumita: sama:na: matanesewana, kesale iwei tima:na: matanesewana, kesalewa sena elakemi ha:na:na: matanesewana, nano keteawa atu tima:na: matanesewana, mokopo tipalese sema:na: matanesewana, sena wepi sema:na: matanesewana, ketea amowa matanawemi enewa meatewi selesekeye. ");
INSERT INTO khs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nano ketea amoke sena ene ewa akeleya tesekeye. Alawamona, ma:na: ma:na:pela: tiya: eta: selakolosema amowana sena ene ewa eta: akeleya tesemakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesuyewi koawa iya:pela: hanose, Yu senama tela peleya: emi, hanose Taia taune amowana, Saetone taune amowana, pawemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hanapola: emi enewemi Yu kesalema tela kesale, Keina:ne sena i ma:ta: tiye mina kesale amowa enekeye. Kesale amowa Yesu elakemi inapola: penanose holose selese, “Piseiki, Tepiti sena i, Keyawa newa hauwekilise sesema. Ne la:le ho olokeyatelayewi tise ikomonawa kinisekeye.” Aluse kesale amoke seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aluse selapita: kemi Yesuyewi emawa ketea nowa eta: seyamakeye. Eta: seyamake Yesu hanapita:, E sena ilipe hanosene inapola: Ema penanose ta:potose, “Kesale amowa niwa ale inise hole inise inatakeye. Kesale amo salawa sesema au selakamowa Keyawa sesema. Seselese ewa mene hamonama.” ");
INSERT INTO khs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Au selapita: Yesuyewi selese, “Yu sena kesale sopowa a:pele sipi netale tiye sitala epapulakeye. Alanase Yu sena kesale semetei sesemita: Koteyewi Newa hamona e seyakeye. Yu senama telawa sesemita: Newa hamona seyamakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Selapita: Yesu elakemi kesale amowa inapola: kuniu kula:pela: hela: selese, “Piseiki, newa sesema.” ");
INSERT INTO khs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Au selapita: Yesuyewi selese, “Sala ma:na: ma:na:wa kasoyewi maita: iya:takamakiwa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Au selapita: kesale amoke selese, “Piseiki, henenapo. Alawamona koane inayewi koane tepolo emi tese ma:na: na:sela: muyawa sululuwalupita:, kasoyawala nasekeye.” ");
INSERT INTO khs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Au selapita: Yesuyewi selese, “Kesale, keyawa Nema matana semetei matanesewa sosokeye. Ke matana epapuluse Neyawa aupesakeye.” Au selakamake kesale sa:wa ho olokeyatela tiwa itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesuyewi Yu senama tela peleya:wa iya:pela: hanapola:, hano Kalili hano hawe hapakeye. Hanapola: tokowemi fiyanapola: henekeye. ");
INSERT INTO khs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Henewanapulu senala: muta inapola:, sena onatu ketetowayawala, sena tiya: pa:mo tiwala, sena si kolawala, sena solamawana, sena noka nakola telawala tiyapola: minakeye. Tiyapola: inapola: Yesu enene minitapowemi tiyapola: inapola: tiye tiyapita:, Yesuyewi potapola: sena kesale nakola towaya sopoke Eyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Alake sena solo itapa fala:peyawa seli seyakeye. Tiya:le pa:mo ti fala:pewa tiya:wa seli salo hekeyakeye. Onatu kete tela fala:pewa seli fa:nano sita:nekeye. Si kola fala:peyawa seli papokeye. Aluse sena sopoke Yesuyewi fala:wayakeye. Fala:tapita: sena kekenayewi potapola: howa hanose kemi epeyakeye. Epelese Isolaiya sena kesaleyewi Kotewa wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu E sena ilipe hanosema nano ketea selapose minapela: inapita:, ima selese, “Ikiwapo usulupewemi sena kesale muta Newanapulu kekenepela: sita:la:, ma:na: ma:na:wa itapakeye. Itapa telanase Neyawa iwa hauwekikeye. Iwa kutama meina isu kiwemi menise hopolo tema:pekise hamonama:na:wa mapolokeye.” ");
INSERT INTO khs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Au selapita: sena ilipe hanoseyewi selese, “Niwa sita:la: weyamowa mowa peleya:nase sena kekenama falawa ili maita: miya:na:wa kami tima:na:ne?” ");
INSERT INTO khs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Au selapita: Yesuyewi ima ta:potose, “Kiyawa falawa ipipa: telapa:?” Au selapita: iyewi selese, “Falawa tomoipewa ewalo tepeteni mutama telakeye.” Aluse iyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aluse selapita: sena kesale sopoma Yesuyewi selese, “Kiwa sopoke peleya: epemi ka:la:loma.” ");
INSERT INTO khs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aluse iwa ka:la:lopelelapita:, falawa tomoipewa, ewalo mutamawana Yesuyewi tiyapola:, Kotema napolo esa: kulukulupela: kotetipela:, falawa pasoloyetiye sena ilipe hanosema kina:sela: elapita:, iyawa sena kesale sopoke kekenama sakole hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sakole hanapola: kotetipela: sena sopoke kekenayewi iliye tiye menakeye. Napela: iliye tiyapita: falawa fuwa sena ilipe hanoseyewi tiyapola:, elale tomoipewemi selatiye woliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aputa: sena falawa mena sopowa akeyawa taosene pinipe. Aputa: kesalewala, sala tepeteniwana, iwa eta: akeyamakeye. Iwa eta: akeyamawana ma:na: amowa menakeye. ");
INSERT INTO khs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Napela: kotetipela: sena muta kekenawa Yesuyewi hamona seyakeye. Iwa hanapita: Yesu potiwemi tapela: poti kolo tiye Makatala peleya: emi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yesu enewemi Felesi senawala, Satusi senawala inapola:, iyawa Yesuwa kapo popa:na:pela: Yesuma poluse seyakeye. Iyewi selese, “Koteyewi ta:peyawa Kewalakeye au sema:na:pela: Keyewi tima:na: tisewa niyewi popa:na:ke Keyawa matiminima:. Koteyewi hepene falemi nano ketea alusewa niyewi popa:na:ke Keyawa matiminima:.” ");
INSERT INTO khs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Au selapita: Yesuyewi selese, “Ka:le oka sinakemiwa meikiwa kelepita: potapola: kiyewi selese, ‘Hepolo tema:na:nakeye,’ au selesekeye. ");
INSERT INTO khs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aputa: ikiwapo nowemi kiapo ikiwatapita: potakamake meikiwa ka:menise yopolosaleke potose kiyewi selese, ‘Napu hawa sima:na:napo,’ au selesekeye. Aluse kiyawa meikiwa potose hano sima:na:wana, mo napoloma:na:wana, kiyawa potose takalese matanesekeye. Amowa potose matanesene kamunuse ikila weyemi Kote penaiyayewi matanepela: tima:na: tisewa tiyapita: potapola:, ‘Koteyewi ta:peya senawa ewalakeye.’ Aluse kiyawa mamataneselakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Senayewi selese, ‘Koteyewi ta:peya senawa kewalaleke, niyawa popa:na:pela: Kote penaiyayewi matanepela: tima:na: tisewa matiminima:.’ Aluse timinisewa popa:na:pela: keye hana ikila emiwa sena kesale sita:newa olokeyala:pela: sitalakeye. Sena kesaleyawa Kotema mamatanekeye. Aputa: Yonayewi Koteyewi tisene timita: Koteyewi ta:peyakeye. Ta:peyawa sena kesale sopoyewi potapola: matanemita: Yonama ela amunuse Nemawana aupesakeye. Auma:na: semeteiwa kiyawa popita: waloma:na:keye. Nano ketea nowa kima eta: waloma:na:makeye.” Aluse selese kotetipela: Yesuwa iwa iya:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesuwala, E sena ilipe hanosewana, potiwemi tapela: kolo tiye sanese hanapola:, hano hema tapo fa:nemi sita:la: selese, “Niyawa falawa tiye eta: minamakeye. Niyawa kepoliyetikeye.” ");
INSERT INTO khs_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Au selapita: ima Yesuyewi selese, “Felesi senayawala, Satusi senayawala, iyawa nano solosene amunawa kiyawa tima:pekise pota:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aluse Yesuyewi pale selese selapita: solo mouwa iyawa tikili tese sulupoluse i kene selese, “Niyawa falawa tiye eta: tiye minamanapita: etakeye.” ");
INSERT INTO khs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Au selapita: ili matanawa Yesuyewi potapola: selese, “Kiyawa Nema matana semetei kolotea matana hanatakeye. Ko:lupita: kiyawa kipitane sopolo sulupoluse selese, falawawa itapalakeye e seya:? ");
INSERT INTO khs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ne solo mouwa kiyawa kaluse tikili tepa? Sena taosene pipe kekenama falawa pipe kinapola: kotetipela:, falawa muyawa kemi teselapita: elale kukuluipewemi selatiye woliyetiwa, kiyawa mamatanepa? ");
INSERT INTO khs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aputa: sena taosene pinipe kekenama falawa tomoipewa kinapola: kotetipela:, falawa muyawa kemi teselapita: elale tomoipewemi selatiye woliyetiwa kiyawa mamatanepa? ");
INSERT INTO khs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Neyawa kima hele heneye falawa amowa eta: seyamanase, Ne solo amoke mouwa kiyawa mamataneselakeye. Ne solo mouwa weyamu selakeye. Felesi senayawala, Satusi senayawala, iyawa nano ketea solosene amunawa tima:pekise pota:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Au selapita: Yesuyewi solo amo mouwa sena ilipe hanoseyewi matanese, “Felesi senayeliye Satusi sena ili sowa nano ketea solosene epapulakeye. Ili sowa niyawa ta: tima:pekise Yesuyewi etakeye. Heneye falawa ketea solosewa tima:pekise Eyewi maselatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesuwa Sesalia Filipai taune pawemi inise, E sena ilipe hanosema ta:potose, “Sena Sa: Newa sena nokamoke Newa ipise matanepa:?” ");
INSERT INTO khs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Au selapita: iyewi selese, “Sena nokamoke selese, ‘Kewa Yone hano toluyetisene mene tesile minanakeye.’ Au selapita: sena nokamoke selese, ‘Kewa Ilaiya elakeye.’ Aputa: sena nokamoke selese, ‘Kewa Yelemaiya elakeye.’ Au selapita: sena nokamoke selese, ‘Kewa sepatosene sena nowanakeye’ au selesapekeye.” ");
INSERT INTO khs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Au selapita: Yesuyewi selese, “Kiyewi kili matanawa Newa ipise matanana?” ");
INSERT INTO khs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aputa: Saimone Pitayewi selese, “Kote kao elakamoke E Sa:wa Kekeye. Koteyewi Piseikipela: epesita: ta:peya sena Kelesowa Kewalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Au selapita: Yesuyewi selese, “Yona e sa:le Saimone, Koteyewi kewa napola:takeye. Napola:tapita: epelese elatipa:. Keye matanepela: seyawa senayawa kema se tiye kinapita: keyawa maselakeye. Ni Ata hepene falemi elakamoke kema waloselapita:, keyawa aluse seleselakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ta:ta:pa:. Pita, ke unu amo mouwa etewakeye. Aputa: keyewi Newa seyawa etewa epapulakeye. Keyawa Newa seya amunuse, sena kesale nokamoke aluse ta: tiyapola: selesaleke, iwa Neyewi mene silima:na:keye. Sena kesale amowa Newemi pala sena kesale akeye. Alake Hetisi peleya: emiwa, kulusene penaiyayewi Newemi pala sena kesalewa makeneyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aputa: sena kesale Koteyewi pote elakamowa iyewi matanemita:, keyewi isu tenamowa kolo tiyaposakeye. Isu tenamowa kiyewi kolo tisene epapuluse, keyawa Newa se tiye mita: Neyawa kewa ta:pelekeye. Alake peleya: weyamo senayawa olokeyatela timinipita:, keyewi potapola: hekeya:sela:, ‘Iya:ta:pa:,’ Au selapita:, hepene falemiwana Koteyewi ‘Iya:ta:pa:,’ au selalakeye. Aputa: peleya: weyamo senayawa seli timinipitekiwa, keyawa potapola:, ‘Napolapo,’ au selesaleke, hepene falemiwana Koteyewi, ‘Napolapo,’ au selalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aluse Yesuyewi E sena ilipe hanosema sowa penanose selese, “Keleso Newa sena sopoma selapa.” Au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ikila emi E sena ilipe hanosema Yesuyewi selese, “Newa aupa: seyanase, Yelusaleme sitiwemi hanosekiwa, Yu sena tililayawala, pilisiti sena sosoyawala, Kote solo ele walosene senayawala, Newa ikomonosaleke, himu nakolose toma olose aluse sanose kuma:na:keye. Sana kuluwa ikiwapo osokemi Newa mene teisa:pa:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Au selapita: sena ilipe hanosene kekene tiye sita:newa iya:pela:, Pitayewi Yesuwa siliye kolotea hanapola: Yesuma ka selakamunuse selese, “Piseiki, Kewa sana kuma:na:keye, aluse selapa. Koteyewi Kewa sesemita: matanekeye. Keyewi au selakamowa auma:pekise selakeye.” ");
INSERT INTO khs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Au selapita: Yesuyewi notolo tese Pitama selese, “Setene, kewa Ne fo:su tapowemi hamona. Seteneyewi selesene amunuse keyawa selapa. Koteyewi matanawa kulu hanose eta: matanemake, senayewi matanesewa keyewi kulu hanose matana hanatakeye. Aluse matanese isu ha:na:na:wa kalesene mouwa kekeye.” ");
INSERT INTO khs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Au selapita: sena ilipe hanosema Yesuyewi selese, “Kiyawa Newamo kulu ha:na:na:pela: Newa iwemi palese kumita: i kelipapoyawa Neyewi Nine uwapola: hanosene amunuse, kiwala, kili matanawa iya:pela: i kelipapoya uwapola: hanose, Ne onatu onaiyawemi kiwala fe onanese ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Senayawa peleya: weyemi a elekiwa a pote epesenewa semetei matanepela: tiya:sela: elapitekiwa, sena amowa Kotewalapulu kokolo maelaposakeye. Alawamona, sena nowamoke selesaleke, ‘Yesupela: newa kulakamakiwala ililakeye. Ewamopela: semetei tima:na: tiya:sela: elaposakeye.’ Aluse matanepela:, kuma:na:wa eta: ipilamake elapitekiwa, sena amowa Kotewalapulu kokolo elaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aputa: senayewi peleya: sosolo weyamo nano ketea sopowa tiyapola: kekene tiye ela:, Kotewalapulu kokolo tesewa Eyewi iya:pela: elapitekiwa, kulusene ikila emiwa ketea enayewi ewa sesepesapa:? Kokolo kao tesewa wa:la:loma:na:pela: enayewi wa:la:losena? Alamakeye. Kokolo kao tesewa eta: wa:la:losemakeye. ");
INSERT INTO khs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ni Atayewi ho:liyawalapulu hepene senawanapulu epapuluse Sena Sa: Newa mene mina:na:keye. Mene mina:na: ikila emiwa sena kesale sopoyewi tima:na: tiwa potapola: takalepesakeye. Takalepela: sena kesale seli sita:nema ketea heka napolo miya:na:keye. Sena kesale olokeyatela sita:nema ketea heka olokeyatela miya:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Neyawa kima heneye selakeye. Kiwa noka epesita:ya a elakemi seta: kulumake potakamake, Sena Sa: Newa inise Piseikipela: elapita: potaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ikiwapo tekapeipe itapa tepela: Yesuyewi Pitawala, Yemesewala, Yemese ene e ma:e Yonewana, iwa siliye tokomo sosolo tumu fiyanekeye. Fiyanapola: ilipe ipitane sita:la: ");
INSERT INTO khs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","potakamake Yesu tomawa kali tepela: ela: ikilale otowi ho:lilisene epapuluse, Yesu mitiwa ho:lilise ela:, Ene sao kalawala hele heneye koiya sopolapokeye. ");
INSERT INTO khs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ho:liya elapita: iyewi potakamake, Mosese Ilaiya a:ko: Yesuwalapulu sita:la: selalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Potapola: Pitayewi Yesuma selese, “Piseiki, Niwa weyemi minawa napokeye. Keyawa, ‘Henekeye, epelekeye,’ au selesaleke neyawa koane panokaseya kolotea usulupe tima:na:keye. Nowa Kewamopela:, nowa Mosesepela:, nowa Ilaiyapela: aluse tima:na:keye. Kewa epelepa?” ");
INSERT INTO khs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aluse Pitayewi sela:sela: enene kemi, kiniwani sosolo ho:liyayewi ela:pe kipila iwa foye tikeye. Kiniwani fopiya olapo emi tese solo nowa selese, “Ewa Nine Ni Sa:keye. Ewa Nine himu hapawa sosolo matanepela: epelekeye. E sowa ta:tapola: matanepela: sita:latipa:.” Aluse seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aluse selapita: sena ilipe hanoseyewi ta:tapola:, peleya: sululuwaluse howa hanose ipilakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ipipita: iwa falopela:newemi Yesuwa inapola: iwa tomawemi kesalese selese, “Kiwa tesima. Ipipa.” ");
INSERT INTO khs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aluse selapita:, iwa tesilapola: siyewi kelese, fa:nemi pote, komemi potose potakamake, sena nowa eta: enima Yesu semetei elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aputa: iwa tokomo tumu emi tese ina:sela: Yesuyewi penanose selese, “Sena Sa:wa Nekeye. Newa kupula: mene seta: tesima weyemiwa kiyawa uwa koane potosene epapuluse papowa sena kesale nowama selapa.” ");
INSERT INTO khs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aputa: sena ilipe hanoseyewi selese, “Kote solo elewa walosene senayewi selese, ‘Keleso seta: minama ela: Ilaiyawa puwano inaposakeye.’ Au seyawa ko:lupita: iyawa ke seyala?” ");
INSERT INTO khs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aputa: Yesuyewi selese, “Kote solo elewa walosene senayewi selese, ‘Ilaiyawa puwano inisekiwa nano ketea sopoke seila:taposakeye.’ Au seyawa heneye au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Aputa: Ne solo we henekeye. Ilaiya mina:na: seyawa puwano minakeye. Minawa iyewi potapola: matanese, ‘Ilaiya mina:na: seyawa ewalakeye.’ Aluse eta: matanemakeye. Eta: matanemake i matanawamoke tise ewa ikomonakeye. Ikomona amunuse Sena Sa:wa Newana kapo olomita: ikomopesakeye.” ");
INSERT INTO khs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Au selapita: sena ilipe hanoseyewi matanese, “Ilaiya mina:na: seyawa, Yone hano toliyetisene epalakeye, esa: Yesuyewi seleselakeye.” Aluse iyewi matanakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesuwala, E sena ilipe hanosene Pitawala, Yemesewala, Yonewana iwa hanapola:, sena kesale muta kekenepela: sita:newemi hetetikeye. Hetetise Yesu elakemi sena nowa inapola:, kuniu kula:walopela: hela: selese, ");
INSERT INTO khs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Piseiki, ni sa:wa wa:ke matakolose sutesinise sosolo tesekeye. Ikila mutawemiwa tei kiyawemi sutesinisekeye. Ikila nowemiwa hawemi sutesinisekeye. Alusenase Keyawa ewa hauwekilise sesema. ");
INSERT INTO khs_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aluse Ke sena kilipe hanosene sita:newemi, ne salawa siliye minawamona iyawa eta: fala:pemakeye.” ");
INSERT INTO khs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Au selapita: Yesuyewi selese, “Sena kesale ikila weyemi sitalakamokiwa Kotema matana semetei matanepela: eta: sita:nemanase olokeyale sitalakeye. Ikila sopoke kiyawa hele matanepela: sitalapitekiwa, Neyawa kiwamopela: ikiwapo sopoke kaluse hokolose tiya:sela: elaposapa? Kiwalapulu Newa ikila sosowa elapitekiwa kemi, kiyawa Nema matana semetei matanepela: masitalatakeye. Newamo ela weyemi salawa siliye mina.” ");
INSERT INTO khs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Au selapita: salawa siliye minakeye. Siliye inapita: ho olokeyatelama Yesuyewi penanose selese, “Kewa iya:pela: hamona.” Au selakamake ho olokeyatelawa iya:pela: hapakeye. Ho olokeyatela hanapita: salawa fala:pekeye. ");
INSERT INTO khs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yesuyewi salawa fala:tapita: sena ilipe hanoseyewi potapola:, sikape iwa Yesu enewemi inapola: ilipe ka:la:lopela:la: Yesuma selese, “Niyawa ho olokeyatelawa iya:pela: hamonapita: eta: hapamawa ko:luse elale?” ");
INSERT INTO khs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Au selapita: Yesuyewi selese, “Kiyawa Kotema matanawa hele heneye koloteanase ho olokeyatelama selese, ‘Kewa iya:pela: hamona,’ esaleke eta: hapamakeye. Neyawa solo we heneye selakeye. Kiyawa Kotema himu semetei matanawa i maseta fo kolotea epapulaleke, tokomoma selese, ‘Tokomo weyamowa kewa peleya: we iya:pela:, peleya: nowemi elapose hamona,’ au selesaleke hanaposakeye. Alusaleke, nano ketea sopoke ile timinipesakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Alake ho olokeyatelawa we iya:pela: hamona, au selesaleke ho olokeyatelawa hamonite ma:na: nasewa alepela:la: hela: Kotema kulukulupa:. Kulukuluse ma:na: nasewa eta: alepemake, ho olokeyatela weyamowa iya:pela: hamonapitekiwa mahanaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ikila nowemi, Yesuwala, E sena ilipe hanosewana, iwa Kalili peleya: mene hanapola: sita:newemi Yesuyewi ima selese, “Sena Sa:wa Nekeye. Newa sana kumita: senayewi Newa ta: tiye kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta: tiye kinise Newa sukulu tiye kumita: sanaposakeye. Newa sana kuluwa ikiwapo usulupe kotetipela: mene tesima:na:keye.” Au selapita: sena ilipe hanoseyewi ta:tapola: sosolo hauwekilise matanakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesuwala, E sena ilipe hanosewana, Kapaneame taunewemi minakeye. Inapola: Pita enewemi Kote koanepela: takese tisene sena inapola:, Pitama ta:potose, “Ke walosene sena, Yesuwa Kote koanepela: takese moweni tuwatesena?” ");
INSERT INTO khs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Au selapita: Pitayewi henekeye e seya. Henekeye epela: Pitawa koane mene inapita:, Pitayewi seta: seyamake Yesuyewi Pitama puwano seyakeye. Yesuyewi selese, “Saimone, peleya: weyamo sena piseikiyewi sena kesale ipima takese moweni halosapeya:? Piseiki Ene e peleya: sena kesalema takese moweni halosapeya:? Makene sena kesale nokamawa takese moweni halosapeya:? Ke matanawa enana?” ");
INSERT INTO khs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Aputa: Pitayewi selese, “Makene sena kesale nokamawa takese moweni tine, au selesekeye.” Aputa: Yesuyewi selese, “Henekeye, Piseiki Koteyawala Ene e sa:ma takese moweni tuwapa, elawa eta: selesemakeye. ");
INSERT INTO khs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Alusene amunuse Neyawa iya:pa:na: telawamona, takese tisene senayewi mapoloma:pekise, Neyawa takese moweni tuwataposakeye. Pita, kewa hanapola: kimiyewi hano tuwapola: ewalo tiyaposakeye. Ewalo puwano ti emi kimiwa sutiye, moweni uka ewalo meakemi sulu talapita: potaposakeye. Potapola: moweni usu amo tiyapola:, na:niwa na:komopela: Kote koanepela: takese tuwata:pa: elanase, moweniwa takese tisene senama kina:pa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ikila emiwa sena ilipe hanoseyewi Yesu enewemi inapola: Ema ta:potose, “Koteyewi Piseikipela: pote ela pala senawa ikamo putupela: elapa:?” ");
INSERT INTO khs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Au selapita: iwa sita:ne sala kolotea Yesuyewi minapela: inapita: Yesuyewi E sena ilipe hanosema selese, ");
INSERT INTO khs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Ne solo we heneye selakeye. Sala kolotea ewa ene ewa solo se eta: matanesemakeye. Kiyawa kilipe amowa solo se matanesewa na tiye iya:pela:, sala kolotea amunuse sita:latipa:. Sala kolotea amunuse masitalaleke, Koteyewi Piseikipela: pote ela peleya: emiwa mahanaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sala ewa ene eta: soyamake ela epapuluse, sena ewa ene eta: soyamake epapuluse elaleke potapola:, ewa Koteyewi Piseikipela: pote ela pala sena puwano amowa ekeye. ");
INSERT INTO khs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sena sa: ewa ene eta: soyamake Nema matanepela: ela senayawa sala amunawa seselesaleke amowa, Newana seselekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yesuyewi selese, “Ewa ene sala tepeteni Nema matanepela: senayawa olokeyatela timinimita:, senayewi polusaleke, polusene senawa tokonawemi etewa sosolo kakiwemi koma:pela: tiye, hano tawala honosane hano katomita: toliyetisaleke ililakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Senayewi olokeyatela timinimita: polusene sena kesale amowa fala:sima:na:wa eta: fesamoma:na: telamanakeye. Nano ketea olokeyatelawa hetetisekeye. Alawamona, nano olokeyatela hetetimita: polusene sena kesale amowa fala:sima:na:wa eta: fesamoma:na: telamanakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aputa: ke tiya:yawa olokeyatela timinisaleke, keyewi kine matanawa ikomonosekeye. Ikomoma:pekise tiya: noka na tiye iya:ta:pa:. Tiya:le elipe elaleke tei eta: sekakolosema peleya: emi toliyetima:pekise, tiya:le semetei noka na tiye iya:pela:, tiya:le semetei ela:, kao tesewa ma:ta: tiye tiya:sela: elaleke ililakeye. Aputa: ke onatuyewi olokeyatela timinisaleke, keyawa kine matanawa ikomonosekeye. Ikomoma:pekise onatu noka na tiye iya:ta:pa:. Onatu elipe elaleke tei eta: sekakolosema peleya: emi toliyetima:pekise, onatu noka na tiye iya:pela:, onatu semetei elaleke kao tesewa ma:ta: tiya: tiya:sela: elaleke ililakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ke siyewi nano ketea potose olokeyatela timinisaleke, kine matanawa ikomoma:pekise, si noka tukutiye iya:ta:pa:. Si elipe elaleke heo peleya: emi tei wa:la toliyetima:pekise, si noka tukutiye iya:pela:, kao tesewa ma:ta: tiye tiya:sela: elaleke ililakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ewa ene sala tepeteni ela sena amowa mapolose wepi selapa. Sala amowa hepene senayewi pote sitalakeye. Pote sita:la: Ni Ata hepene falemi ela emi, Ni Atayewi sikapo sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sena Sa:wa Nekeye. Sena kesale sulukepiya Neyewi mene silima:na:pela: Newa minakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yesuyewi selese, “Kima Neyewi pale seya weyamo selapita: kiyawa noko:lu matanema:na:na? Sena nowamoke ene a:pele sipi sita:newa akelese sakopolo semetei ala sita:nekeye. Sita:newa semetei nowa ene enapotane nesile hanose kelekeyetikeye. Kelekeyetiyapita: senayewi iya:peyala? Alamakeye. Eta: iya:peyamakeye. A:pele sipi kekene tiye sita:newemi akelese talo akotaipe epela: akotaipe sita:nekeye. Talo akotaipe epela: akotaipe sitalapita: potapola: talo akotaipe epela: akotaipewa tokomo kemi sita:pesita: ke apola:, semetei nesile hapawa kelema:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nakelepa:se hanapola: kelese potose sosolo epeyakeye. Alake Neyawa heneye selakeye. A:pele sipi talo akotaipe epela: akotaipe sita:newa a:pele sipi inayewi potose epelesekeye. Alawamona, a:pele sipi semetei nowa nesile hapawa kelese potose hele heneye sosolo epelesekeye. ");
INSERT INTO khs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Alusene amunuse Ni Ata hepene falemi elakamoke matanese, ‘Ewa Ene eta: sosolo telama sena semetei nowa hele kelesaleke eta: ilimanakeye.’ Aluse Ni Atayewi matanesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesuyewi selese, “Sena kine ke ma:eyewi kema ikomonosaleke, ikomonawa iya:pita: ka:lipe ka:potane sita:la: ema sela:pa:. Selakamake eyawa ta: tiyapola:, eyawa kema ikomonawa iya:pela:, ka:ko: ka:lipe napolo ma:epela: sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Alawamona sena amoke ke sowa ta:te iya:tapitekiwa, keyawa sena noka siliyapola: selapose ha:na:pa:. Sena semeteiwala sena elipeiwala siliyapola: selapose ha:na:pa:. Hanapola: ema kotose selapita: ta:tese, solo amowa henenapo au semita:, sena elipeiyawala, sena usulupewala aluse selakamakiwa ililakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Alawamona ili sowala sena amoke kaluse ta:te iya:tapitekiwa Newemi pala sena sopoma sela:pa:. Selatalawa solo amowa tikape tesaleke, ewa iya:pela: takala:pela: sita:latipa:. Iya:pela: Yu senama telawala, takese tisene senawala, kiwa takala:pela: kalikalise epesita:ya amunuse, sena amowa aluse takala:pela: sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Neyewi sela weyamo heneye selakeye. Peleya: weyemi senayawa olokeyatela timinipitekiwa, keyewi potapola: hekeya:sela:, ‘Iya:ta:pa:,’ au selapitekiwa, hepene falemiwana Koteyewi, ‘Iya:ta:pa:,’ au selaposakeye. Aputa: peleya: weyemi senayawa napolo timinipitekiwa, keyewi potapola:, ‘Napolapo,’ au selesaleke, hepene falemiwana Koteyewi, ‘Napolapo,’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Neyewi solo nowa weyamowana selakeye. Sena elipeiyewi matana semetei se tiyapola: matanepela: aluse Kotema kulukulupita:, Ni Ata hepene falemi elakamoke ta:tese nano ketea aupa: e seyawa, semetei kamunuse tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kiyawa sena elipeiyawala, sena usulupewala Ne unuwa matanepela: kekenepitekiwa Newana inapola: kiwalapulu ninipe elaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yesu enewemi Pitawa inapola: ta:potose, “Piseiki, sena ne ma:eyewi ikiwapo sopoke newa ikomonosaleke, heka emawa eta: mene seyamake ikila ipipa:wemi neyawa kepoliyeti meinapa? Ikila tomoipewemi kepoliyetisaleke ililapa?” ");
INSERT INTO khs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Au selapita: Yesuyewi selese, “Ikila tomoipewemi kepoliyetisaleke eta: ilimanakeye. Keyawa eta: akeyamake eyewi kema ikomonawa keyawa sosolo kepoliyetiya:pa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yesuyewi selese, “Koteyewi sena kesale Piseikipela: pote ela amunawa wekeye. Sena piseikipela: kini elakamo ene tima:na: tisene senama selese, ‘Neyewi kima moweni heka tima:na:pela: miwa napu moweni heka tiye mina.’ ");
INSERT INTO khs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Au selapita: tima:na: tisene sena nowamoke moweni sosolo milione taloipe heka mita: sena nokamoke siliye minakeye. Tima:na: tisene sena siliye mina amoke moweni heka mita: hele heneye sosolo heka miya:na: tela kamona ");
INSERT INTO khs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","moweni itapalakeye, au seyakeye. Aputa: sena piseikiyewi selese sekepilise, ‘Tima:na: tisene sena moweni eta: tenemayawa ene nano keteawa wa:la:lopa:. Wa:la:lose ewa ene ewala, eyewi ene ekewala, eyewi ene salawala sopoke wa:la:lopa:. Iwa sopoke mokopo tima:na: timita: sena nowamoke iwa wa:la:lopela: moweni tiwa nema tiye ina:pa:.’ ");
INSERT INTO khs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aluse selese sekepilapita: tima:na: tisene sena amoke ta:tapola: kuniu kula:walopela: hela: hopo selese, ‘Piseiki, sema aupa. Sikape moweni sopoke neyewi kema miya:na:keye.’ ");
INSERT INTO khs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Au selapita: sena piseikiyewi hauwekilise matanepela: selese, ‘Moweni hele heneye sosolo amowa keyawa nema miya:na: telawamona, Neyawa iya:takeye. Sikape neyawana kema tine, elawa eta: sema:na:makeye. Napu neyawa kepoliyetiyakeye.’ ");
INSERT INTO khs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Alawamona selapita: ta:tapola:, sena tima:na: tisewa hanapola: e tima:na: tisene sena nowa tokonawemi tikipa selese, ‘Puwano neyewi kema tene kina heka tima:na:pela: miwa napu nine tina.’ ");
INSERT INTO khs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Au selapita: ene tima:na: tisene sena manawa kuniu kula:walopela: hela: hopo selese, ‘Kolotea elapepela: sikape neyewi kema miya:na:keye.’ ");
INSERT INTO khs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Au selapita: tima:na: tisene sena amoke eta: auma:na:ma e seyakeye. Au selapita: ene tima:na: tisene sena manawa kotopela: tipolo selawapokeye. Selatapita: potapola: selese, ‘Puwano kema moweni mini amopela:, keyawa moweni heka makinisaleke kewa tipolo kemi elaposakeye.’ Aluse ene tima:na: tisene sena manawa tipolo selawatapita:, ");
INSERT INTO khs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","tima:na: tisene sena nokamoke papokeye. Potapola: sosolo himunama iyewi nano ketea papowa sena piseikima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Selapita: sena piseikiyewi ene tima:na: tisene sena mina e seya. Inapita: sena piseikiyewi selese, ‘Kewa tima:na: tisene sena olokeyatelakeye. Keyawa nema, “Ela:pe aupa,” au seyanase keyawa nema moweni heka miya:na: telawamona neyawa kepoliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kepoliyetise neyawa kema hauwekilise matanesene epapuluse, keyawala ke tima:na: tisene sena ke manama aluse hauwekilise matanenuwamona ke elalapo.’ ");
INSERT INTO khs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aluse sena piseikiyewi e tima:na: tisene senama konomonose tipolo selawapokeye. Selawapola: selese, ‘Kewa toma olomita: tipolo pote ela senayewi kewa sanose toma olopesakeye. Nema moweni heka makinisaleke tipolo kemi elaposakeye. Nema moweni kinapita: kewa silikepima:na:keye,’ au seyakeye.” ");
INSERT INTO khs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aluse Yesuyewi pale selese kotetipela:, E sena ilipe hanosema selese, “Kiyawa ki sena manayewi kiwa ikomonosaleke, kiyawa matana mapoyawa puwano iya:pela: makepoliyetisaleke, amowa piseikiyewi ene tima:na: tisene senama timiya epapuluse, Ni Ata hepene falemi elakamoke kima aluse timinipesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesuyewi selese kotetipela: Kalili peleya:wa iya:pela: hanapola:, hano Yotane satepela: nono fa:nemi Yutia peleya: emi enekeye. ");
INSERT INTO khs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Enewemi sena kesale muta Yesu kulule hanose inapita: potapola: sena kesale nakola towayawa Yesuyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fala:ta:sela: Yesuwa enewemi Felesi sena inise, Yesu kapo popa:na:pela: Ene hele semita:, iyawa poluse selese, “Senayewi ene kesale tili iya:pa:na:wa mouwa elapita: iya:pa:na:wa ililapa? Mouwa elapita: iya:pa:na:wa solo elewa hotoma:na: telalapa?” ");
INSERT INTO khs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Au selapita: Yesuyewi selese, “Puwano fa:nemi ma:ta: ti ikila emi Koteyewi senawana kesalewala elipe timiyakeye. Timinise Koteyewi selese, ‘Senayewi ene e ama ene e atawa iya:pela: kesale tise, ene kesalewalapulu elipe palese elipe toma semetei sitalakeye.’ Aluse Koteyewi selapita: Kote pukawemi momateyawa kiyawa papola? Henekeye, kiyawa papokeye. ");
INSERT INTO khs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Alake senayewi kesalewa tiyapola: elipe toma semetei sita:nenase kalise masitalakeye. Elipe semeteikeye. Alake sena kesale elipe Koteyewi kekena:pewa sena nowamoke takalekamakiwa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aputa: Felesi senayewi Yesuma selese, “Puwano Moseseyewi selese, ‘Kesale tili iya:pa:na:pelekiwa kesalema sawi momate tiye kina:pa:.’ Au seyawa ko:lupita: Moseseyewi ilikeye esa: iya:pa:na:wa ilikeye ke seyala?” ");
INSERT INTO khs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aputa: Yesuyewi selese, “Senayewi Kote sowa tikapeye tinase Moseseyewi senama, ‘Kesale iya:pa:na:wa ililakeye,’ au seyakeye. Alawamona Koteyewi ma:ta: tiye timiya opo emiwa Koteyewi alamakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Neyawa kima solo we selakeye. Senayewi kesale tiwa, kesale amowa ene sena nowanapulu eta: hapamake seli helakamona, ene e senayewi mapolose ewa iya: tese kesale pa:ta nowa tisaleke, sena amokiwa kesale nowa atu tiyakeye.” ");
INSERT INTO khs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aluse Yesuyewi selapita:, E sena ilipe hanoseyewi Yesuma selese, “Keyawa senayewi kesale tisene solo amowa heneye seyalaleke senayawa kesale eta: timake mokopo sita:laleke ililakeye.” ");
INSERT INTO khs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Au selapita: Yesuyewi selese, “Kiyewi au sela amowa sena sopoyewi eta: ta: tima:na:manakeye. Koteyewi sena noka mokopo sita:pesita: seselesaleke kesale tima:na: matanesewa itapakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta:ta:pa:. Sena sopoyewi kesale eta: tisemakeye. Sena noka kalikalila sita:tesekeye. Aputa: sena noka ili toma olokeyatela kesale eta: tima:na: telama amuna kesilisekeye. Ene e amayewi kesilise kemi esekeye. Aputa: sena noka sena nokamoke ikomonose ili tomawa naiya tese sita:la: kesale eta: tisemakeye. Aputa: sena nokamoke matanese, ‘Kote piseikiyewi tima:na: tisewa tima:na:pela: neyawa kesalewa eta: tima:na:makeye.’ Aluse matanese kesalewa eta: tisemakeye. ‘Kesale eta: tima:na:makeye.’ Aluse matanesewa himu fa:nemi iliye tiyapita: kesalewa iya:ta:pa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yesu enewemi sala siliye minakeye. Sala siliye minawa Yesuyewi tiya:yawa kesalese Kotema kulukulumita: siliye minakeye. Alawamona, siliye mina sena kesalema Yesuyewi sena ilipe hanoseyewi matana mapolose selese, “Sala siliye inapa.” ");
INSERT INTO khs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Au selapita: Yesuyewi selese, “Newamo elakemi salawa inisaleke ililakeye. Inapitekiwa kapa. Ta:ta:pa:. Sena kesale ewa sala kolotea epapuluse sita:laleke, Koteyewi Piseikipela: pote elakeye.” ");
INSERT INTO khs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aluse selese sala amowa Yesuyewi tiya:yawa kesalakeye. Kesalese iya:pela: Yesuyewi iwa iya:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yesu enewemi sena nowa inise selese, “Walosene sena, newa Kotewalapulu kao epesena:pelekiwa, neyawa nano ketea napolo ena timinima:na:napa?” ");
INSERT INTO khs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Au selapita: Yesuyewi selese, “Nano ketea napowa Nema ko:lupita: ta:ta:? Kote Ene Ewa semetei napokeye. Kewa Kotewalapulu kao epesena:pelekiwa, napu pama:na:pela: matanese Kote sowa ta: tiyapola: elatipa:.” ");
INSERT INTO khs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Au selapita: sena amoke selese, “Solo ele pa:ta nokaiyamo ta: tiyapola: elaposapa?” Au selapita: Yesuyewi selese, “Sena kumita: sanapa. Sena kesale tili kiyawa iwei tiyapa. Ketea nowa atu tiyapa. Sena nowama mokopo tipa selapa. ");
INSERT INTO khs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ki atawala ki amawana seli matanepela: seila:ta:pa:. Keyewi kine kewamo himu hanose matanesene epapuluse, kine sena ke mana nowa aluse himu hanose matanepa:.” ");
INSERT INTO khs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aputa: senayewi selese, “Solo ele sopoke epamowa neyewi ta: tiyapola: kao enekeye. Nano nowa ena timinima:na:napa?” ");
INSERT INTO khs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Au selapita: Yesuyewi selese, “Kewa ili napolo sopolo elapose ke nano ketea sopoke wa:la:loma:na:pela: ha:na:pa:. Hanapola: nano keteawa wa:la:lopela: apola:, moweni tiwa sena ketea misitiya sita:nema kina:pa:. Kinapola: kotetiyapita: keyewi nano ketea himu hapa hepene falemi teselaposakeye. Alake keyawa kine nano keteawa kinapola: kotetipela: Newamo kulu mina:na:pela: ina:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Au selapita: sena sala amokiwa ta:tapola: ene nano keteawa sosonase sena nokamawa miya:na:wa mapolose, Yesuwa iya:pela: himu nakolose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hanapita: potapola: Yesuyewi e sena ilipe hanosema selese, “Neyawa kima heneye selakeye. Nano ketea sosolo tese ela sena amowa Kote Piseikipela: ela mina:na:wa hele heneye hokolosekeye. ");
INSERT INTO khs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Solo we Neyawa heneye selakeye. Sao tupulusene ono uwalokemi kopolo ka:mowa musulukamakiwa tele tesekeye. Alusene amunuse, nano ketea sosolo tese ela sena amowa Kote Piseikipela: ela mina:na:wa hele heneye hokolosekeye.” ");
INSERT INTO khs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aputa: sena ilipe hanoseyewi ta:tapola: howa hanose selese, “Sena nano ketea sosolo telawa Kote Piseikipela: ela mina:na:wa, hele heneye hokolosekeye, etakeye. Alake sena ikamo Koteyewi Piseikipela: pote elapose heliye tiyaposapa:?” ");
INSERT INTO khs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Au selapita: Yesuyewi E sena ilipe hanosema pote selese, “Sena kesaleyawa eta: ilima. Alawamona, Kote semetei Eyawa nano ketea sopoke ili timinisekeye.” ");
INSERT INTO khs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Au selapita: Pitayewi selese, “Niyawa nano ketea sopoke iya:pela:, Kewamo kulu mina:na:pela: minakeye. Alanase niyawa nano ketea ena tima:na:ne?” ");
INSERT INTO khs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Au selapita: Yesuyewi selese, Ta:ta:pa:. Solo we henekeye. Sena Sa:wa Nekeye. Sikape nano ketea sopoke hili tema:na: ikila emiwa Newa Piseikipela: elaposakeye. Piseikipela: ela:, sea sosolo ho:liya sopolo emi helaposakeye. Helapita: kiwala Newanapulu kekenepela: sea noka kukuluipe sopowemi kiwa ka:la:lopesakeye. Ka:la:lopela:, Isolaiya sena i kukuluipewa kiyewi seli pote sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sena kesale sopoyewi semetei semetei esa: Nema matanese Ne tima:na: tisewa tima:na:pela:, ene koane iya:pela:, e ma:e iya:pela:, e ate iya:pela:, e ata iya:pela:, e ama iya:pela:, e sa:le iya:pela:, peleya: iya:pela:, aluse nano ketea sopoke iya:pela: ela sena kesale amokiwa nano ketea wa:la:ya hepe sosolo sakopolo amunawa tiyapola: Kotewalapulu kao elaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Alake yemiwa sena kesale muta putupela: sita:newa sikape tepesakeye. Sena kesale muta yemiwa sikape sita:newa putupesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesuyewi selese, “Sena kesalewa Koteyewi Piseikipela: pote ela amunawa wekeye. Kiapo ikiwatapita: alekena inawa sila:sela: ela:, mei kalipe alekenawemi senayewi timita:, sena silima:na:pela: kelese enekeye. ");
INSERT INTO khs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sila:sela: ela: tima:na: tisene senawa potapola: ima selese, “Kiyawa ikiwapo semeteiwemi tiyapita: kima moweni wane kina semetei semetei esa: miya:na:keye.” Aluse selakamakiwa iyawa henekeyepita: alekena inayewi ta:tapola: ima selese, “Kiwa tima:na: tima:na:pela: hamona,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hamona seyanase opo si owemi alekena inawa wa:ke sila:sela: ela:, peleya: pakia potakamake sena noka mokopo sitalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Potapola: ima selese, “Kiwa ne mei kalipe alekenawemi tima:na:pela: hamona. Neyewi matanawa ketea wa:la:ya hepe ilima:na: telalapita: kima miya:na:keye.” Au selapita: iwa tima:na: tima:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hanapita: opo si honosane opo si kukuwemiwana, ka:le opo si osokemiwana, alekena inayewi sena nokamoke alekenawemi tima:na: timita: ketea wa:la:ya hepe puwano seya semetei kamunuse seyakeye. Selapita: iwa tima:na: tima:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ka:le opo si piwemi alekena inawa wa:ke hanapola: peleya: pakiawemi senawa mokopo sitalapita: potapola: ima selese, “Kiyawa ikiwapo sopoke ko:lupita: mokopo sita:la:?” ");
INSERT INTO khs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Au selapita: iyewi selese, “Alekena pote ela senayawa nima tima:na: tiya:pa:, au seyamakeye.” Au selapita: alekena inayewi selese, “Kiwala hanapola: ne mei alekenawemi tima:na: tiya:pa:,” au seyakeye. Aluse selapita: iwa tima:na: tima:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nukulupita: alekena inayewi e alekena pote tesene senama selese, “Alekenawemi tima:na: tiya:sela: sita:ne senawa sopoke ina:pa: sela:pa:. Mina selapita: potapola: ima ketea wa:la:ya hepe kina:pa:. Kina:sela: sena ka:le minawa puwano kina:pa:. Amo fo:su sena kiapo okemi minawa kina:pa:. Amo fo:su sena ikiwatapita: minawa sikape kina:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aluse alekena inayewi selapita: sena opo si piwemi minama moweni wane kina semetei semetei esa: mikeye. ");
INSERT INTO khs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aluse kinapita: potapola: sena kiapo ikiwatapita: mina amoke matanese, ‘Ima moweni wane kina epe kiniseya, nima moweni wane kina miya:na: seyawa nowa papela: kinaposakeye.’ Aluse matanawa imawana, kaluse moweni wane kina mikeye. ");
INSERT INTO khs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Kinapita: iyewi alekena inama mapolose selese, ");
INSERT INTO khs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Sena opo si piwemi mina amoke kolotea tikeye. Niwa kiapo ikiwatapita: inapola: tima:na: tiye hanapola: ka:le iya:peyakeye. Niwa otowi ofolose hepepilise tima:na: tiya:sela: mapolose sosolo hokolakeye. Sena opo si piwemi minamawana nimawana semetei kamunuse kinapitekiwa eta: ilimanakeye.’ ");
INSERT INTO khs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Au selapita: sena kiapo ikiwatapita: mina nowama alekena inayewi selese, Ta:ta:pa:. Neyawa kiwa mene sili ikila emiwa neyawa kima ketea wa:la:ya hepe moweni wane kina miya:na:keye. Au selakamake keyawa henekeyepita: topukeye. Alake na:tewi nenipe sepapowa neyawa mahotolakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Moweni wane kina semetei kamo tiye hamona. Moweni wane kina weyamowa keyewi kine ketea wa:la:ya hepe akeye. Neyewi matanawa sena puwano minawana, sena sikape minawana, ketea wa:la:ya hepe semetei kamunuse miya:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Neyewi ninawa neyewi nine matanepela: kinakamake ililakeye. Alake, sena nokamawa neyewi matanese moweni sosolo kinapita: keyawa nema mapoloseya?’ Aluse alekena inayewi seyakeye.” ");
INSERT INTO khs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Seya amo mouwa wekeye. “Sena kesale sikapetapo sita:newa putupesakeye. Sena kesale puwano sita:newa sikape tepesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesuwa Yelusaleme sitiwemi fiyane hanosekiwa sena kesale sopoke iya:pela: E sena ilipe hanosene kukuluipewalapulu kolotea hanapola: ima semetei selese, ");
INSERT INTO khs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ta:ta:pa:. Niwa Yelusaleme sitiwemi hanakeye. Yelusaleme sitiwemi sena nokamoke, Sena Sa: Newa kotomita: sihelelese sukulu tiye siliye hanaposakeye. Pilisiti sena sosoyawala, Kote solo ele walosene senayawala, kotomita: Newa siliye hanaposakeye. Siliye hanapola: iyawa Newa kumita: i papema, au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aluse Newa kumita: Yu senama telayewi Newa i papema:na:pela: siliye hanaposakeye. Siliye hanapita: Yu senama telayewi Newa ikomonose tisenipesakeye. Ne tomawemi sanapola: i kelipapola: papelaposakeye. Papelapita: Newa kuma:na:keye. Kulapita: ikiwapo usulupewemi Koteyewi Newa mene teisataposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sepetiyewi ekele ene e sa:le Yemese Yone a:ko:lapulu ilipe Yesu elakemi inapola:, kesale amoke kuniu kula:walopela: hela: Yesuma selese, “Ne sowa Keyewi ta: tiyapola: aluse timinimita: matanekeye.” ");
INSERT INTO khs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Au selapita: Yesuyewi selese, “Neyawa epapuluse ena timinapa?” Au selapita: kesale amoke selese, “Kewa Piseikipela: ela ikila emiwa, ne sala nowa Ke tiya:le ili tapowemi helema, apula: sala nowa Ke tiya:le hukalo tapowemi helema, au semita: matanakeye.” ");
INSERT INTO khs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Au selapita: Yesuyewi selese, “Keyewi epe seleseyamo mouwa keyawa kine mamataneselakeye. Mokopo seleselakeye.” Aluse Yesuyewi a:ma selese, “Ne kapo hano nasewa ka:tawala ma:na: telalapa?” Au selapita: a:tawi selese, “Henekeye, na:tewi ma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Au selapita: Yesuyewi selese, “Ne kapo hano nasene semetei kemi ka:tawa heneye naposakeye. Alawamona, Ne tiya:le ili tapowemi helema:na:wana, tiya:le hukalo tapowemi helema:na:wana, Neyewi helema elawa eta: sema:na:makeye. Neyewi Nine matanawamunuse eta: ta:pelema:na:makeye. Nine Ni Atayewi Ene matanawamunuse ili hekeya:sela: Ewa semetei ta:peyakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aputa: sena ilipe hanosene taloipeyewi ta:tapola: e ma:e a:ma mapoyakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mapolopita: sena ilipe hanosene sopoma Yesuyewi mina e seya. Inapita: potapola: Yesuyewi ima selese, “Yu senama telayewi ili sena piseikiyewi sena kesale nokamawa sosolo tinenisekeye. Sena piseikiwa ene sosolo tese enenase, sena kesale amawa tinenisekeye. ");
INSERT INTO khs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Alusene amunuse kiwa aluse sitalatepa. Kiyawa kilipe sena nowamoke matanese, ‘Newa sena sosolo tese epesena: tekeye.’ Aluse matanesaleke, sena koloteawemi timinisene amunuse kiyawa sena sopowamopela: seselese tiya:pa:. ");
INSERT INTO khs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Alake sena nowamoke matanese, ‘Newa sena puwano epesena: tekeye.’ Aluse matanesaleke, sena amokiwa tima:na: tisene senayewi timinisene amunuse tiya:pa:. ");
INSERT INTO khs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sena Sa:wa Nekeye. Alake tima:na: tisene senayewi timinisene amunuse senayawa Newamopela: amunuse timita: Newa eta: minamakeye. Senala:wa sopowamopela: tima:na: tisene senayewi timinisene epapuluse Neyawa tima:na:pela: Newa minakeye. Senala: ilipe olokeyatelawamopela: falasima:pekise keyawa kakasilise Newa kulapose minakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yeliko taune amowa iwa iya:pela: hanapita:, sena kesale muta Yesuwalapulu ilipe hanose isu kiwemi pote hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hapa ikila emi sena elipei si elipe kola, isu kiwemi hema ka:la:lopela:la: Yesu inapita: ta:tese, unuwapo holose, “Tepitiyewi sena maya, Piseiki, Keyawa na:ko: hauwekilise sesema.” ");
INSERT INTO khs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Au selapita: sena kesale mutayewi penanose selese, “Hopa. Sowa itapa tema.” Au selapita: a:tawi wa:ke unuwapo holose, “Piseiki, Kewa Tepitiyewi sena maya na:ko:ne, hauwekilise sesema.” ");
INSERT INTO khs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Au selapita: Yesuyewi ta:tapola: Ewa minawa ene tepela: pote enekeye. Pote ela: a:ma Yesuyewi selese, “Ka:tawa epelemita: Neyawa ko:lu timini meinapa?” ");
INSERT INTO khs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Au selapita: a:tawi selese, “Piseiki, na:tewa siyewi seli popa:na: epelekeye.” ");
INSERT INTO khs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Au selapita: Yesuyewi a:ko: hauwekilise a:ko: siwemi kesakamake ela:pe kipila itapa tese a:tawi siyewi napolo potapola: Yesuwalapulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sena kesale muta Yesuwalapulu isu kiwemi hapakeye. Hanapola: Yelusaleme siti pawemi minakeye. Yelusaleme sitiwa mapatose tokomo Olofi elakeye. Tokomo Olofi pawemi Pefasi koamesa: tiwa emi iwa hetetikeye. Hetetise Yesuyewi sena ilipe hanosene elipeima ");
INSERT INTO khs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","selese, “Ka:ko: koamesa: asopa epemi hamona. Hanapola: potakamake kopolo toki e ama koma:peya, e sa:walapulu sitalapita: potaposakeye. Potapola: kopolo tokiwa e ama e sa:walapulu elipe fake tiye Newamo ela weyemi siliye ina:pa:. ");
INSERT INTO khs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aputa: sena nowamoke ka:ma selese, ‘Ka:tawa ko:luma:na:pela: ela:?’ Au selesaleke ka:tawa ema selesekiwa, ‘Kopolo toki emiwa Piseikiyewi tima:na: tiyaposakeye. Eyawa au seyanase kopolo toki weyamowa na:tewi siliye hananakeye.’ Au selapita: sena amoke ka:ma, ‘Henekeye, ilikeye. Tiye ha:na:pa:,’ au selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesuyewi aluse seta: seyamake puwano fa:nemi Kote solo se tiye kinisene sepatosene senayewi seyawa wekeye. ");
INSERT INTO khs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sena kesale Saione sitiwemi sita:nema selese, ‘Pota:pa:. Kili Piseiki sosowa inatakeye. Kili Piseiki hopola enewa kopolo toki wapa:kemi helepela: inatakeye. Kopolo toki wapa:kemi heyawa kopolo tokiwa e sa:keye’ au selaposakeye.” Au seyawa hetetiya epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Alake a:ko: hanapola: Yesuyewi seya semetei kamunuse ta: tiyapola: timiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Timinise kopolo toki e ama e sa:walapulu elipe siliye minakeye. Siliye inapita: sena mutayewi ili saowa kopolo toki wapa:kemi fepela: apola:, Yesuwa emi heyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tapela: helapita: sena kesale muta iyewi sopoke isu ki emi ili sao felakeye. Aputa: sena kesale nokamoke nano ketea falo nasolo tiye isu ki emi felakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Felawemi Yesuwa inise sena kesale noka puwano, noka sikapetapo aluse minakeye. Iyewi holose inise, “Tepiti sena i maye mina sena Kewa sosokeye. Piseiki Koteyewi Kewa hamonapita: minawa, Koteyewi napola:takeye. Kewa hele heneye puwano elakeye.” Aluse, iyewi Yesuwa wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wapilise iwa sopoke Yelusaleme sitiwemi holose inapita: sena kesale emi sita:neyawa potapola: himunama tese selese, “Sena epe iniseya ipa:?” ");
INSERT INTO khs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Au selapita: sena kesale mutayewi selese, “Sena epe iniseya sepatosene senakeye. Kote solo se tiye kinisene sena Yesukeye. Kalili peleya: Nasalete koamesa: enewa Ekeye.” Aluse sena kesale mutayewi Yesuwa wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kote koane pawemi, sola suwemi Yesuwa musuluyetiye hanapola: potakamake, senala:yewi nano ketea wa:la:ya:sela: sitalapita: potapola:, iwa sopoke Yesuyewi alutale tiye hamona seyakeye. Aputa: sena nokamoke tepolowemi moweni tiye tiyapola: senisila:sela: sita:newanapulu, Yesuyewi inise ili tepolo sopoke notoloyetikeye. Aputa: a:nema: tumu amuna wa:la:ya:sela: sita:ne sena amo sea amowana Yesuyewi notoloyetikeye. ");
INSERT INTO khs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Notoloyetiye ima Yesuyewi selese, “Kote pukawemi Koteyewi seyawa sepatosene senayewi momateyawa wekeye. Ne koawa sena kesaleyewi selese, ‘Kote koawa Kotema holosene kulukulusene koakeye,’ au selesekeye. Au selesene kamona Kote koane weyamo kiyawa atu tisene senayewi apana amuna apolatakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kote koane Yesu enewemi sena kesale si kolawala, onatu kete towayawala, inapita: Yesuyewi fala:wayakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aputa: sala tepiteniyewi Yesuma wapilise holose, “Tepiti sena i maye mina sena, Kewa sosokeye,” aluse holakeye. Hopita: ta:tapola:, pilisiti sena sosoyawala, Koteyewi solo ele walosene senayawala mapolose konomonakeye. Aputa: Kote penaiyayewi matanepela: tima:na: tisewa Yesuyewi tiyapita: potapola: iyewi mapolose konomonakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Konomonose Yesuma iyewi ta:potose, “Sala tepiteniyewi epe holoseya Keyawa ta:teseya?” Au selapita: Yesuyewi selese, “Henekeye, Neyawa ta:takeye. Sala tepiteniyewi epe holoseya Kote pukawemi momateyawa kiyawa eta: akeyamana? Kote pukawemi momateyawa wekeye. ‘Sala tepeteni sopoke apula: sala kiaiyawala Nema epelese wapilimita:, epelesewa ima Koteyewi kinaposakeye.’ Aluse momateyakeye.” ");
INSERT INTO khs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aluse Yesuyewi selese kotetise sena kesale Kote koane kekenawana, Yelusaleme sitiwala, Eyewi iya:pela: hanapola: Petani koamesa: enikeye. ");
INSERT INTO khs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kiapowemi Yesuwa Yelusaleme sitiwemi mene hanosekiwa meinakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Menipita: i kalu isu hemawemi elapita:, kalu fo ma:na:pela: supa:na:pela: inise, potakamake i kalu henewa falo sopolo elapita: papokeye. Potapola: Yesuyewi selese, “I kalu weyamowa fowa wa:ke mahelepesakeye.” Au selala kemi i kaluwa ela:pe kipila olo tikeye. ");
INSERT INTO khs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Olo tiyapita: sena ilipe hanoseyewi potapola: howa hanose selese, “I kaluwa noko:lu ela:pe kipila ko:luse olo tiyape?” ");
INSERT INTO khs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Au selapita: Yesuyewi selese, “Neyawa kima solo we heneye selakeye. Kiyawa matana elipei matanepela: eta: telamake Kotewalapulu matana semetei matanepela: sita:latipa:. Aluse sitalapita:, Neyawa i kaluma seya amunuse kiyawa i kalumawana, tokomomawana, aluse selapita: aupesakeye. Kiyawa tokomo potapola: selese, ‘Tokomo kewa kikili tiye hano tawala mutula hamone.’ Au selapitekiwa aupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Alake kiyawa Kotema matana semetei matanepela: sita:la:, nano ketea nowamopela: matanepela: Kotema kulukulupita: Koteyewi aluse timinipesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kote koane sola suwemi Yesuwa musuluyetiye hanapola: solo se tiye kina:sela: enene ikila emiwa pilisiti sena sosoyawala, Yu sena tililayawala, Ewamo elakemi inapola: selese, “Keyewi epe tiseya etewi apoyala? Kema etewi epapuluse tiya:pa: e seyala?” ");
INSERT INTO khs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Au selapita: Yesuyewi ima selese, “Neyawana, kima nano ketea semetei nowa meapo ta:talakeye. Ta:takamake kiyawa Nema solo mene inapita:, ta:tapola: Nema timinipe seyawa Neyewi kima sema:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoneyewi sena kesale hawemi tolusulawa etewi aupa: seyala? Koteyewi aupa: seyala? Senayewi aupa: seyala? Kiyawa Nema sema.” Au selapita: sena iyawa i kene sopolo tafase selese, “Niyawa Yesuma ena sema:na:ne? Niyawa selese, ‘Koteyewi aupa: seyakeye,’ aluse selesaleke, Yesuyewi nima selese, ‘Ko:lupita: Yoneyewi sowa ta:te iya:peyala?’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aputa: niyewi selese, ‘Senayewi aupa: seyakeye,’ aluse selesaleke, sena kesale sopoyewi nima mapolose konomopesakeye. Alake sena kesale sopoyewi matanese, ‘Yone ewa sepatosene senakeye. Ene Koteyewi solo se tiye kinisene senakeye.’ Aluse iyewi matanemita: iwalapulu ipikeye. Aluse sena kesale sopoyewi nima mapoloma:pekise niyewi Yesuma sowa mamene selaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aluse ilipe tafase Yesuma selese, “Yoneyewi sena kesale hawemi tolusulawa etewi aupa: e seyale. Niwa tikili tekeye.” Au selapita: Yesuyewi selese, “Kiyawa Nema sowa mene eta: seyamanase Nema timinipa: e seya mouwa Neyawa kima maselakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pilisiti sena sosowala, Yu sena tililawala sita:nema Yesuyewi pale selese, “Sena semeteiyewi sena e sa:le elipei enekeye. Alake sala ola:pema inayewi selese, ‘Ni sa:le, napu kewa mei kalipe alekenawemi tima:na: tima:na:pela: hamona.’ ");
INSERT INTO khs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Au selapita: sala amoke selese, ‘Newa mapolokeye. Eta: ha:na:na:makeye.’ Ala kamona sikape eyawa matanese, ‘Neyewi puwano mapoyawa iya:pela:, wa:ke tima:na: tima:na:pela: ha:na:na:keye,’ Aluse matanese matana notoyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aputa: sala sipima inayewi selese, ‘Ni sa:le, napu kewala kalipe alekenawemi tima:na: tima:na:pela: hamona.’ Au selapita: sala amoke selese, ‘Henekeye, newa ha:na:na:keye.’ Ala kamona ewa eta: hapamakeye.” ");
INSERT INTO khs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aluse Yesuyewi ima meapo ta:tese, “Sala nokaiyamoke ene e ata sowa ta: tila? Kiyawa noko:lu matanepa:?” Aputa: iyewi selese, “Sala ola:tewi topukeye.” Au selapita: Yesuyewi ima selese, “Solo we henekeye. Kote Piseikipela: ela palesewa, takese tisene senawana, iwei kesalewa sena elakemi hanosewana puwano palesekeye. ");
INSERT INTO khs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Alake kiwa hekeya sita:pesita:, Yoneyewi kima se tiye kinapita: kiyawa eta: topumakeye. Alawamona, takese tisene senayawala, kesalewa sena elakemi hanosewana topukeye. Ta:tapola: sitalapita: kiyawa potose kasele, Yoneyewi sowa kiyawa ta: tima:na:pela: elawamona matana semetei matanepela: masitalapekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesuyewi pilisiti sena sosomawana, sena tililamawana, selese, “Ta:ta:pa:. Neyawa kima pale seya nowa selakeye. Alekena inayewi mei kalipe alekenawemi kepela: solakeye. Sola suwemi mei kalipe fowa tikipaselese hawa hamonite etewa kalotese pokose amuna timiyakeye. Aputa: senayewi alekena amowa seli pota: epesita: ituwe koane tikeye. Tipila: apola: alekena amowa sena nokamoke pota: sita:pesena: esa: ema wa:la:le tiye sita:nekeye. Pota:pesenawa apola:, alekena inayewi ene alekena amowa iya:pela: peleya: nowemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hanapita: mei kalipe fowa ki ina ikila emi, alekena potapola: sita:ne senayewi mei kalipe fowa takalese, noka alekena inama mita:, alekena inayewi tima:na: tisene sena nokamawa tima:na:pela: hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hamona seyawa alekenawemi inapita: alekena pota: sita:ne senayewi tima:na: tisene sena nowa i polotoyewi sanose, apula: tima:na: tisene sena nowa hele heneye sana kule, apula: tima:na: tisene sena nowa etewayewi ole epapulakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aputa: puwano alekena inayewi tima:na: tisene senama mei kalipe fo tima:na:pela: hamona e seyawa sena mutamakeye. Me wa:ke tima:na:pela: hamona e seyawa sena muta hamona seyakeye. Hamonapita: hapawa sena puwano hamona e seyawa alekena pota: sita:ne senayewi ikomona amunuse, sena sikape hamona e seyawala, aluse ikomonakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aputa: sikape alekena inayewi matanese, ‘Alekena pota: sita:ne senayewi ne salawa maikomopesakeye. Ewa iyewi matanepela: seila:taposakeye.’ Aluse matanepela: enenase alekena inayewi ene salawa hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hamona seyawa alekenawemi inapita: potapola:, alekena pota: sita:ne senayewi ilipe sopolo selese, ‘Alekena inayewi sala inatakeye. Alake sikape ene inawa kuluwemi onatu wapa:kemi ewa ela:, alekena weyamowa eyewi pota: epesena: telalakeye. Auma:pekise niyewi ewa sama:na:keye. Sana kulapita: alekena weyamowa niyewi ninipe ina tepela: pota: sitalaposakeye.’ ");
INSERT INTO khs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aluse salawa sukulu tiye solawa papaseye tiye nono fatemi toliyetipela: sana kulukeye.” Aluse Yesuyewi pale seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aluse selese itapa tese Eyewi sena sopoma meapo ta:tese, “Alekena inawa inapita: alekena pota: sita:ne senawa ko:luma:na:na?” ");
INSERT INTO khs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aputa: sena sopoyewi Yesuma selese, “Alekena inayewi alekena pota: sita:ne sena olokeyatelawa heneye ikomonose sana kuma:na:keye. Sana kulapita:, sena nokamoke alekena amowa seli pote sita:pesita: apolowaloma:na:keye. Apolowa amokiwala mei kalipe fo ki inakemiwa mei fo nokawa tiyapola: alekena inama miya:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aputa: ima Yesuyewi selese, “Solo we Kote pukawemi momateyawa kiyawa eta: akeyamana? Kote pukawemi momateyawa wekeye. ‘Koane tisene senala:yawa i isu olokeyatela esa: matanese sotukepiyakeye. Alawamona, sena nowamoke tiye inapola: ola:pe isu honosane kelalakeye. Kela epa Koteyewi Ene aluse timiyanakeye. Aluse timiyanapita: niyewi potose, “Amowa napolapo,” au selesekeye.’ Aluse, Kote pukawemi momateyalakeye. ");
INSERT INTO khs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Alake Neyawa kima heneye selakeye. Kote Piseikipela: pote enewa kiwa Yu senayewi mapoyanase Koteyawa kiwa iya:taposakeye. Iya:tapita: sena kesale sopoyewi Kotema matana semetei matanepela: E tima:na: tisewa sita:pesita: ima miya:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Alake isuwemi sena kesale noka emi kolusaleke ewa heneye olokeyalepesakeye. Aputa: i isu kela amowa sena kesale tukule hanose wapa:kemi suluwa tesaleke, heneye munu tiye iya:taposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aputa:, pilisiti sena sosoyawala, Felesi senayawala, Yesuyewi pale selapita: ta:tapola: matanese, “Yesuyewi sela amowa niwa seleselakeye.” ");
INSERT INTO khs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Aluse matanese Yesu supa:na:pela: elawamona iya:peyakeye. Koiyawemiye, sena kesale sopoke matanese, “Yesu sepatosene sena Koteyewi solo se tiye kinisene senanakeye.” Aluse matanemita: iyawa Yesuwa sutakamakiwa, sena kesale sopoyewi ima mapolose konomoma:pekise iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesuyewi senama wa:ke pale selese, ");
INSERT INTO khs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Koteyewi Piseikipela: pote ela amunawa wekeye. Sena piseikipela: elakamoke ene e sa:yewi kesale tima:na: ikila emi tikinima:na:pela:, ma:na: ma:na:wa kekene tiye tiye tikeye. ");
INSERT INTO khs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tiye tipila: sena kesale puwano ta:peyama yemiwa minite, hamona aluse ene tima:na: tisene senama seyakeye. Selapita: iwa hanapola:, sena kesale puwano ta:peyama mina e seyakeye. Mina seyawamona sena kesale amowa i mapolose eta: minamakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Mainapita: potapola:, sena piseikiyewi tima:na: tisene sena nokama selese, ‘Sena kesale mina e seyama wa:ke selese, “Yemiwa mina. Ma:na: ma:na:wa sopoke kekene tiye tiye tikeye. Kopolo kao tima:na: tisenewala, kopolo ponomakau e sa:le napolo soyawala sanapola: tiye tiyapola:, nano ketea sopoke kekene tiye tiye tikeye.” Aluse selapose hamona.’ ");
INSERT INTO khs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Aputa: tima:na: tisene sena hanapola: mina seyawamona, sena mina seya amokiwa ta:ta: iya:pela:, sena nowamoke ene alekenawemi tima:na:pela: hanapola:, apula: sena nowamoke ene pisinisi tima:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aputa: sena mina seya nokamoke tima:na: tisene senawa sukulu tiye ikomonose sana kulukeye. ");
INSERT INTO khs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Sana kulapita: sena piseikiyewi ta:tapola: konomonose ene ami senama mina e seyakeye. Inapita: potapola: sena piseikiyewi ima selese, ‘Sena sana kulu senawa kumita: sanapa:. Ili koawana wa:mita: sata:pa:.’ Au selapita: sena piseikiyewi ami sena hanose sena piseikiyewi seya semetei kamowa iyawa aulakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aputa: sena piseikiyewi e tima:na: tisene sena nokama selese, ‘Ma:na: ma:na:pela: nano ketea sopoke kekenakeye. Kekene tiyapola: sena kesale inepe seyawa iwa olokeyale sita:la: iwa ili eta: sita:nemanase, iwa neyewi iya:takeye. ");
INSERT INTO khs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Alanase kiwa hanapola: isu tiyapowemi sena kesale nokala inapita: potapola: tikina emi ina:pa: sela:pa:.’ ");
INSERT INTO khs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Aputa: tima:na: tisene sena isu tiyapowemi hanose, sena kesale sopoke olokeyatelawala, napowala, potose mina e seyakeye. Minapela: siliye inapola:, ma:na: ma:na: koane musuluyetiye kekenekamake koawa woliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Koane walupita: sena kesale koane tisawa, sena piseikiyewi popa:na:pela: minakeye. Inapola: potakamake kesale tima:na: emi kekene tiye, sena kesale sopoyewi kesale tisene sao napolo kapela:, sena semetei nowa kesale tisene sao napowa eta: kalamanapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Potapola: sena ama sena piseikiyewi selese, ‘Ne mana, kewa kesale tisene sao napowa iya:pela: eta: kalamanakeye. Ko:lupita: musuluyeti minana?’ Au selapita: sena amowa sowa itapa enekeye. ");
INSERT INTO khs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Alake tima:na: tisene senama sena piseikiyewi selese, ‘Sena amowa onatuwemiwana tiya:wemiwana ta tiye yopolotela peleya: tapowemi toliyetiya:pa:. Aputa: yopolotela peleya: emiwa sena kesale epesita:yemiwa ya:lese konomonose peka kalo naposakeye,’ au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ta:ta:pa:. Sena kesale muta mina seya kamona sena kesale mutamawa tipipilise siliyakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Felesi senala:yewi kekene tiye selese, “Yesuyewi hele semita: niyewi Ewa tiyapose niwa hopolose hanapola:, weyamu sema:na:keye.” Aluse iyewi o:sulu sulupoluse selese se tikeye. ");
INSERT INTO khs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sowa sulupoluse se tiyapola: kotetise, Felesi ilipe kulu hanosene sena nokala Helote kulu hanosene sena nokala, Yesu enewemi hamona, au seyakeye. Au selapita: hanapola: Yesu enewemi inapola:, Yesuma iyewi selese, “Walosene sena, Ke sowa hele heneye seleselakeye, aluse niyawa matanekeye. Sena seli sita:pesita: heneye Koteyewi alusewa Keyewi se tiye kinatakeye. Senayewi Kema ikomoma:na:wa Keyawa eta: matanamake heneye seleselakeye. Sena sosowa epelemita: Keyawa se tiye makiniselakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Alake niyawa Kema nano semetei ta:potakeye. Niyawa Yu senayawa Lome sena piseiki Sisama takese moweni kinakamake ililapa? Kinakamake Koteyawa solo elewa hotoma:na: telalapa?” ");
INSERT INTO khs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Aputa: iyawa Yesu ikomoma:na:pela: hopolose minawa Yesuyewi potose, ima selese, “Kiwa sena matana elipei sitalakeye. Neyawa hele selapitekiwa Nine Ne solo kamoke samita: kiyewi aluse seleselakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takese moweni usu tuwapa:na:wa Neyewi potapose tiye mina.” Au selapita: moweni uka tiye inapita: potapola: ");
INSERT INTO khs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesuyewi selese, “Ipi miti moweni ukemi elatapa? Ipi unu momateyalapa?” Au selapita: iyewi selese, “Lome sena piseiki Sisa mitilakeye. Ene unu momateyalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Au selapita: Yesuyewi selese, “Lome sena piseikiyewi enawa ene ema kina:pa:. Kotenewa Kote Ene Ema kina:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Au selapita: iyewi ta:tapola: howa hanose Yesuwa iya:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ikila semetei kemi, Yesu enewemi Satusi sena inapola:, Yesuma nano ketea meatewi ta:tapose minakeye. Aputa: iyewi matanawa sena kuluwa ene tomawanapulu howanapulu heneye kuluwa mene eta: tesilisemakeye. Aluse matanese iyawa Yesuma selese, ");
INSERT INTO khs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Walosene sena, Moseseyewi seyawa wekeye. ‘Senayewi sala eta: kesilamake kulusaleke, e kesale sopa:lawa ene e ma:yewi tisekeye. Sena kulu amoke sala maya tekamunuse manomita:, kesale sopa:lawa ene e ma:yewi tisekeye.’ Aluse Moseseyewi seyalapokeye. ");
INSERT INTO khs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Alake peleya: weyemi e ma:ewa tomoipewa sita:nekeye. E ma: ola:tewi kesale tiwa sala eta: kesilamake kulapita:, ");
INSERT INTO khs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","e ma:e kulu fo:su kamoke kesale sopa:lawa tikeye. Eyawa salawa eta: kesilamake ewala kulukeye. Kulapita: e fo:su kamoke kesale sopa:lawa tikeye. Tiwamona eyawa salawa eta: kesilamake kulapita:, ala hanose e ma:e tomoipe sopoyawa kesale sopa:la semetei kamo tise sala eta: kesilamakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Sikape kesale ini telawa kulukeye. ");
INSERT INTO khs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sena kesale kuluwa mene tesila ikila emiwa kesale amowa a:me ekela? Ewa sena tomoipewemi tikeye.” ");
INSERT INTO khs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Au selapita: Yesuyewi selese, “Kote solo pukawemi momateyawala, Kote penaiyawana kiyawa tikili tese hele matane selakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sena kuluwa mene tesilapola:, hepene sena epesita:ya amunuse sitalaposakeye. Aluse epesita:ya ikila emiwa sena kuluwa mene tesiyawa kesale kulu tesiwa eta: tisemakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aputa: sena kuluwa mene teisa:pa:na: amo mouwa Neyawa kima selakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kote pukawemi momateyawa Koteyewi selese, ‘Epalahameyewi Kotewa Nekeye. Aisa:keyewi Kotewala Nekeye. Yakopeyewi Kotewala Nekeye.’ Aluse momateyawa kiyawa akelese mouwa kiwa mamatane selakeye. Mouwa wekeye. Kotewa sena kuluwa mene tesilapola: falela apota: epesita:yamo Kotekeye. Epalahamewana Aisakewala Yakopewala heneye kupula: a pote masitalaleke, ‘Ili Kotewa Nekeye,’ aluse Koteyewi auwa masemapekeye.” ");
INSERT INTO khs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aluse Yesuyewi selapita: sena kesale mutayewi ta:tapola: himunama tese howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Satusi senayewi seyawa, Yesuyewi solo amoke sano tiye toliyetise seyakeye. Selapita: iyewi ta:tapola: solo itapa sita:nekeye. Sowa itapa sitalapita: potapola:, Felesi senayewi kekene tiye. ");
INSERT INTO khs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ilipe sena semetei solo ele ta:tesene sena amoke, Yesuyewi hele semita: hopolose selese, ");
INSERT INTO khs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Walosene sena, Kote solo ele no nokaiyamo puwanowa?” ");
INSERT INTO khs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Aputa: Yesuyewi selese, “Kote amowa ke Piseikikeye. Piseikima keyawa himu hapa iliyawa sosolo matanepa:. Ke hoyawala Ema sosolo matanepa:. Ke himu matanayawana Ema sosolo matanepa:. ");
INSERT INTO khs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Amowa solo ele hele heneye puwanokeye. ");
INSERT INTO khs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aputa: solo ele nowana semetei kamuna wekeye. Keyawa kine kewamo himu hapawa matanese epapuluse keyawa sena kesale sopomawa aluse himu hanose matanepa:. ");
INSERT INTO khs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Alake solo ele elipei amowa Neyewi kima epe seleseyamo sepatosene senayewi seyawala, Moseseyewi solo ele momateyawala mouwa semetei kakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Felesi sena kekene tiye sita:ne ikila emiwa, Yesuyewi ima ketea meatewi ta:potose, ");
INSERT INTO khs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Kelesowa kiyawa noko:lu matanepa:? Ewa ipi sa:la?” Au selapita: iyewi selese, “Tepiti e sa:keye.” ");
INSERT INTO khs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Au selapita: Yesuyewi selese, “Kelesowa Tepitiyewi selese, ‘Ne Piseikikeye.’ Aluse Ho Napoyewi waloselapita: seyakeye. Seyawa puwano fa:nemi Kote pukawemi momateyawa wekeye. ");
INSERT INTO khs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tepitiyewi selese, ‘Ne Piseikima, Piseiki Koteyewi selese, “Kewa Ne tiya:le ili tapowemi helema. Helapita: Ke kisiwa Neyewi sano tiye hanewemi apoma:na:keye.” Aluse, Koteyewi seyawa Tepitiyewi momateyalakeye. ");
INSERT INTO khs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Alake, Tepitiyewi Kelesoma ‘Kewa ne Piseikikeye,’ au seyawa ko:lupita: seyala? Aputa: tilila kouwayewi ene sa:le hapama Piseikikeye, elawa eta: selesemakeye. Alake Tepitiyewi Kelesoma Piseikikeye, au seyanase, Tepiti seta: kesilama Kelesowa ela:pe puwano kao enekeye. Alawamona kiyewi selese, ‘Tepiti e sa:keye,’” ");
INSERT INTO khs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Au selapita: iyewi ta:tapola: sowa eta: mene seyamakeye. Ikila emi sena semetei nowamoke Yesuma wa:ke ketea meapo eta: topumakeye. Ili sowa Yesuyewi sano tiye toluyetiyapita: potapola: iyawa nano ketea nowa wa:ke meapo eta: topumakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ikila emi sena kesale muta kekenamawana Ene sena ilipe hanosemawana Yesuyewi selese, ");
INSERT INTO khs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Solo ele Moseseyewi se tiye miwa Koteyewi solo ele walosene senayawala Felesi senayawala solo mouwa se tiye kinisekeye. Se tiye kinise walosene senayewi penanose se tiye kina epapuluse, iyawa aluse se tiye kinise ili unuwa wapilisekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iyewi se tiye epe kiniseya kiyawa ta: tiya:pa:. Alawamona, iwa sita:la: epapuluse kiwa sitalatepa. Alake iyawa sena nokama se tiye kinapita: kemi solo amowa iyewi i kulu hanose eta: tisemakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Sena nokamoke nano kita hilila uwapita: iyawa sako tiyapola: senayewi kenewemi uwapola: apoyakeye. Uwapola: apola: iyawa koloteawala eta: seselamakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Eta: seselamake i kene kemi senayewi popita: hokatolose timinisekeye. Alake Kote solo puka pokose koloteawemi, momateyawa kopo tiye tiya:wemiwana kapela:, sipupa:wemiwana tuwapola:, kolotea sololo pale tiye tisekeye. Aputa: iyawa sao kalawa, sao fili sosona senatolo kalesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iyewi ketea epelesewa wekeye. Tikinisene ikila emi senayewi iwa solo se wapilisene sea iwa ka:la:loma:na:pela: seawa ima walomita: epelesekeye. Aputa: Yu senayewi kekenesene koane hanapola: sena kesale sopoke kekenepela: ka:la:lo pela:newanapulu, iwa sipupa: minitapo tapowemi sea ka:la:loma:na:pela: epelesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aputa: sena kesale peleya: pakia kekenepela: sita:newanapulu iwa hanapita:, senayewi iwa tiya: hapomita: epelesekeye. Tiya: hapolose ima solo se selese, ‘Walosene sena,’ au semita: Felesi senayewi sosolo epelesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Aputa: sena nowamoke kiwa solo se selese, ‘Walosene sena,’ au semita: timinipa. Alake kiyawa walosene senawa Newamo semeteikeye. Kiwa sopoke ma:e sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Niyewi ni Ata Kote semetei hepene falemi elakeye. Alanase peleya: weyemi sena nowa solo se kiyawa ki Ata Kote ela epapuluse epesita: solopa. ");
INSERT INTO khs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sena nowamoke kiwa solo se selese, ‘Pisei Sena,’ au semita: timinipa. Kili Pisei Sena semetei elakeye. Ewa Kelesokeye. ");
INSERT INTO khs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aputa: kiwa kilipe sena nowa putupela: ela: sena amoke sena koloteayewi timinisene epapuluse sena kesale sopowamopela: seselesekeye. Eyawa kili tima:na: tisene sena aupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Alake senayewi ewa ene solopita: sena amowa Kotewa kolotea meapolaposakeye. Aputa: senayewi ene ewa kolotea meapolosaleke sena amowa Koteyewi sosolo meapolaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yesuyewi selese, “Kote sowa walosene sena kiwala, Felesi sena kiwala eta: fesamoma:na: telamanakeye. Kiwa pota:pa:. Kiwa sopoke sena matana elipei sitalakeye. Sena kesale Kote Piseikipela: pote ela pama:pekise iwa kiyewi kalakeye. Alake kiwa Kote Piseikipela: pote ela eta: palamake mapolose sitalakeye. Sena kesale noka Kotewalapulu pama:na:pela: epeyawa kiyewi kalese sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kote sowa walosene sena kiwala, Felesi sena kiwala eta: fesamoma:na: telamanakeye. Kiwa pota:pa:. Kiwa sopoke sena matana elipei sitalakeye. Kiyawa kesale sopa:la koawemiwana, nano keteawala atu tisekeye. Atu tise kemi, Kotewalapulu kulukulusene ikila emi solo senatoye hanose kulukulusekeye. Senayewi potose, ‘Ewa napolapo,’ au semita: aluse kulukulusekeye. Alusene amopela: kiwa fala:sima:na:wa solopesakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kote sowa walosene sena kiwala, Felesi sena kiwala eta: fesamoma:na: telamanakeye. Kiwa pota:pa:. Kiwa sopoke sena matana elipei sitalakeye. Felesi senama tela semetei Felesi senama temita: kiyawa silima:na:pela: makene sosolo hanosekeye. Hanapola:, peleya: sosolo silalape epela:, hawemiwana satepela: aluse fa:na:no sita:tesekeye. Fa:na:no sita:la: sena semetei siliyapita:, senawa Felesi sena amuna tese, sena amowa kili kamoke heo peleya: hamona e selakeye. Alake senayewi olokeyatela timinisaleke, ene olokeyatela timiyamoke kili olokeyatelawa sitiye tiyaposakeye. Alake senayewi olokeyatela timinimita:, walosene mouwa kiwakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Sena si elipe kolayewi sena nokama isu walosene epapuluse kiyawa epapuluse walotakeye. Kiwa pota:pa:. Sena kiwala, eta: fesamoma:na: telamanakeye. Kiyewi selese, ‘Senayewi hekilase selese, “Kote koakeye.” Aluse selapola: ene hekilase seyawa iya:takamakiwa ililakeye. Alawamona, Kote koane kolo tiye tiwa senayewi hekilase selese, “Kolokeye.” Aluse selapola: ene hekilase seyawa talapoiya kokolo elaposakeye.’ Aluse kiyawa selesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sena si elipe kolawa matana eta: seli matanesema epesita:ya epapuluse, kiwa epapuluse sitalakeye. Alake no nokaiyamo puwanowa? Kolowa puwanowa? Kote koane puwanowa? Alake kolo Kote koane tiye tinase Kote koawa hele heneye napokeye. ");
INSERT INTO khs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aputa: kiyewi selese, ‘Senayewi hekilase selese, “Etewa kalotese tiye tikeye.” Aluse selapola: ene hekilase seyawa iya:takamakiwa ililakeye. Alawamona, etewa kalola wapa:kemi Kotema nano ketea mokopo miya:na:pela: tiye tiwa, senayewi hekilase selese, “Nano ketea tiye ti akeye.” Aluse selapola: ene hekilase seyawa talapoiya kao elaposakeye.’ Aluse kiyewi selesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sena si elipe kolawa matana eta: seli matanesema epesita:ya amunuse kiwa aluse sitalakeye. Alake no nokaiyamo puwanowa? Etewa kalola wapa:kemi Kotema nano ketea mokopo miya:na:pela: nano ketea tiye tiwa puwanowa? Etewawa puwanowa? Alake etewa eta: tiye tima Kotema ketea mokopo miya:na:wa noko:lu sapa:na:na? Satapita: nano ketea mokopowa pa:ta napolo sopolo tepesakeye. Napowa sopolo tepesanase etewawa puwanowa? ");
INSERT INTO khs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Alanase, senayewi hekilase selese, ‘Etewa kalotese tiye tikeye.’ Aluse selese etewa kalotese tiye tiwala, etewa kalola wapa:kemi ketea tiye tiwala, sopoke hekilasekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aputa: senayewi hekilase selese, ‘Kote koakeye.’ Aluse hekilase selapita:, Kote koawana, Koteyewi E koawemi sita:newana, hekilasekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aputa: senayewi hekilase selese, ‘Hepene fala akeye.’ Aluse selapita: Kote Piseikipela: ela amo sea amowa hekilase, Kote Ene Ewa sea emi helanase Kotewala hekilakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kote solo ele walosene sena kiwala, Felesi sena kiwala eta: fesamoma:na: telamanakeye. Kiwa pota:pa:. Kiwa sopoke sena matana elipei sitalakeye. Kiyawa nakela sa:le aniyane nano ketea amuna taloipe sopolo tiwa, akotaipe ki tise, talo semeteiwa Kotema kinisekeye. Nano ketea koloteasuwa kiyawa kinisakasele, solo ele sosolo noka ta:te iya:tesekeye. Seli tipipilise matanema:na: telawamona kiyawa eta: matanesemakeye. Sena nowa hauwekilise matanema:na: telawamona kiyawa eta: matanesemakeye. Kotema matana semetei matanepa: seyawala, kiyawa epapuluse eta: matanesemakeye. Alake nano ketea talo semeteiwa Kotema kinisewana, solo ele noka ta:te iya:peyawala, sopoke ta: timapekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sena si elipe kolayewi sena nokama isuwa walosene epapuluse kiyawa walokeye. Kiwa sita:newa weyamu sitalakeye. Hano nasene kana pupusini sutesinapitekiwa nano ketea koloteawa kiyawa tiye iya:tesekeye. Iya:pela: kemi kiyawa kopolo ka:mo amuna sosolo amowa popona kunusekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kote sowa walosene sena kiwala, Felesi sena kiwala eta: fesamoma:na: telamanakeye. Kiwa pota:pa:. Kiwa sopoke sena matana elipei sitalakeye. Kiyawa kapowala, menekiwala, wapa:se tapowamo semetei selakolose, suwa eta: selakolama epapuluse kiwa epapulakeye. Kiwa tomayewi ilise sita:pesena:pela: elawamona, kiwa himu matanawa mane olokeyatela woliyetiye sita:la: etakeye. Aluse sita:la: kiyawa nano ketea atu tima:na:pela:, matanepela: apula: kiyawa ki matanawana, kulu hanose aluse kiwa sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Felesi sena kiwa, sena si elipe kola sita:la: epapuluse sitalakeye. Kapo suwala, meneki suwala, puwano selakopa:. Suwa selakolose kotetise, wapa:se tapowala napolopesakeye. Alusene amunuse kili himu matanesewa puwano seila:ta:pa:. Seila:tapita: kiwa ili napolo sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kote sowa walosene sena kiwala, Felesi sena kiwala eta: fesamoma:na: telamanakeye. Kiwa pota:pa:. Kiwa sopoke sena matana elipei sitalakeye. Sena kuluwa peleya: tikilawa wapa:se falemi pene koiyayewi mutusekeye. Mupuwa wapa:se fala napolo kamona, hane kolemi sena kulu po:sula kiwa teselakeye. Alusene amunuse kiwa epapuluse sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Aputa: senayewi kiwa potose matanese, ‘Iwa sena napokeye.’ Aluse matana kamona, kiwa matana elipei matanesewana matana olokeyatelawala sitalakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yesuyewi wa:ke selese, “Kote solo ele walosene sena kiwala, Felesi sena kiwala eta: fesamoma:na: telamanakeye. Kiwa pota:pa:. Kiwa sopoke sena matana elipei sitalakeye. Koteyewi solo se tiye kinisene sepatosene senawana, Kotema matanepela: sita: tesene senawana, sena kulu apana timiyawa apula: sena kulu peleya: tikilawa kiyawa tima:na: tise momateya seila:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Momateya seila:tapola: kiyawa selese, ‘Niyawa tilila kouwa mei sita:ne opo emi, niwa sita:nekiwa, tilila kouwa mei seselese, Kote solo se tiye kinisene sepatosene senawa masamapekeye.’ Aluse kiyawa selesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kiyawa ki mouwa hokatolose seleselakeye. Kili tilila kouwa meiyewi Kote solo se tiye kinisene sepatosene senawa sana kulukeye. Aputa: tilila kouwa mei semeteiyewi maye minawa kiwakeye. Kiyewi alusewana semetei kakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ehe, hamona. Kiwa ha:na: mane olokeyatela ke kouwa iyewi timiniyawamu kiwa sosolo timinipa:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kiwa heseke amunanakeye. Kili tilila kouwa mei heseke epapula amoke maye minawa minanase kiwala, heseke amunanakeye. Heo peleya: emi kiwa hamonama:na:wa noko:lu iya:pa:na:napa? Maiya:taposakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Alake kiyawa ta:pita: Kote solo se tiye kinisene sepatosene senayawala, seli matanepela: takalese selesene senayawala, Kote solo ele walosene senayawala solo miya:na:pela: Neyewi hamonama:na:keye. Inapita: kiyawa sena noka i kelipapoya papela: sana kulaposakeye. Sena noka Yu senayewi kekenesene koane mei naiyayewi sanaposakeye. Sanose ikomonosaleke senawa nesile hanaposakeye. Hanapola: koane nowemi hanapola:, koawana ikomonosaleke, nesile hanapola:, koane nowemi aluse nesile sila:sela: silalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Alake Kotema matanepela: ela sena, Epo puwano sana kuluwemi, amo fo:su sena nokala sana kulukeye. Sikape Pelekaiya e sa:le Sekalaiya Kote koane sana kulukeye. Etewa kalola tiye tiwa nono fa:namo tapo apola: Kotepela: koane nono komamo tapo apola: honosane enene ewa sana kulukeye. Alake kili tilila kouwa meiyewi olokeyatela matanepela: timiya aluse, kiyawala olokeyatela tima:na:pela: matanesekeye. ");
INSERT INTO khs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Neyewi kima heneye selakeye. Sena sopoke seli sita:newa sana kulunase, sena kesale ikila weyemi sita:newa Koteyewi falasipesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesuyewi selese, “Yelusaleme sena kesale kiwala, kiyawa Kote solo se tiye kinisene sepatosene senawa sana kulusapekeye. Koteyewi hamona seya senawa kiyewi etewayewi olosapekeye. Yelusaleme sena kesale kiwala, a:nema: yoyewi a:nema: sa:le kekene tiye epiyewi o:sula: tesekeye. Alusene amunuse wa:kiwala, wa:kiwala, Neyawa kiwa kekene tiye auma:na:pela: elawamona, kiyawa Nema mapoyakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ta:ta:pa:. Yelusaleme sena kesale kiwala, kili koane mokopo sitalaposakeye. Koane sena kesale eniya:sela: masitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Neyewi kima heneye selakeye. Kiyawa Newa wa:ke mapotaposakeye. Aputa: sikape kiyewi selese, ‘Koteyewi hamona seya sena epe iniseya Koteyewi napola:pita:,’ aluse selapita: ikila emi kiyawa Newa potaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesuyewi Kote koawa iya:pela: hanapita:, Ene sena ilipe hanoseyewi Kote koawa sema:na:pela: Yesuma waiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Walopita: Yesuyewi selese, “Kote koawa kiyawa pota? Ta:ta:pa:. Neyawa kima heneye selakeye. Koane amowa etewa wa:lese tiwa etewawa iyawa ekeye ti iya:peya semetei semetei esa: teselaposakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesuwa tokomo Olifiwemi fiyanapola: henewemi Ene sena ilipe hanosene inapola:, ilipe ipitane ka:la:lopela:la: Yesuma meapo ta:potose, “O:suwemi Kote etewa koawa ekeye tiyaposapa:? Aputa: Kewa mene mina:na:wa nano ketea enayewi nima walopesapa:? Aputa: ikila itapa tema:na:wa nano ketea enayewi walopesapa:?” ");
INSERT INTO khs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Au selapita: Yesuyewi selese, “Sena nowamoke kima mokopo selapitekiwa solo amowa ta: tima:pekise pota:pa:. ");
INSERT INTO khs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sena muta inaposakeye. Inapola: iyawa mokopo selese, ‘Newa Kelesokeye.’ Aluse Ne unuwa sepela: mokopo selapita:, solo amowa sena kesale mutayewi ta: tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Sena nokamoke sena nokalapulu tetape esaleke, kiyawa ta:taposakeye. Aputa: sena nokamoke sena nokalapulu tetakeye esaleke, aluse mokopo pepile hapa selapita:, kiyawa ta:taposakeye. Kiyawa ta:tese himunama tepa. Senayewi tepa:na:wa puwano hetetiyaposakeye. Aputa: itapa tema:na: oka sema hetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aputa: sena peleya: nowamoke sena peleya: nowanapulu tetapola:, apula: kamani nowamoke kamani nowanapulu tetapita: aupesakeye. Aputa: peleya: kalikalilawemi ma:na: nasewa kotetiyapita: sena kesale sosolo menipesakeye. Aputa: peleya: kalikalilawemi henene muta inaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Alake, kesale ene kupu fa:nemi sala enewa ha:na:na:wa sosolo temekelese fa:se nakolosene hanose alusene epapuluse henene inapitekiwala, ma:na: nasewa itapa tepitekiwala, kisi tetapitekiwala, nano ketea hililawa ma:ta: tiye aupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ikila emiwa sena olokeyatelayewi kiwa ikomomita: sukulu tiye siliye hanaposakeye. Siliye hanapola: kiwa sana kulaposakeye. Kiwa Newamo kulu hanapose senala: peleya: sopowemi sita:neyawa kima mapolopesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mapolopita: Newamo kulu hanosene sena kesale mutayewi Newa iya:pela: hanaposakeye. Iya:tapita: nokamoke noka sihelelepesakeye. Iwa i kene kemi, nowamoke nowama mapoye, nowamoke nowama mapoye aluse sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Aputa: mokopo solo se tiye kinisene sepatosene sena muta hetetise se tiye kinapita:, sena kesale muta amoke mokopo sowa ta: tiyaposakeye. Ta:tapola: hele matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aputa: sena kesaleyewi olokeyatela timinisewa solopesakeye. Sosolo tese, Nema kulu hanosene sena kesale mutayewi himu semetei matanepela: himu hapawa itapa tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Alawamona, sena kesale Kotema kulu hanosewa eta: iya:peyamake, kokolo matanepela: sita:la:, tima:na: tiye hanapola: o:suye tisaleke, sena kesale amowa Koteyewi mene siliyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Newa Piseikipela: enewa sena peleya: sopowemi sita:neyawa ta:pita:, peleya: sopowemi Nema kulu hanosene sena kesale sopoyewi solo napowa se tiye kinaposakeye. Se tiye minase, itapa tema:na: oka hetetiyaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesuyewi selese, “Puwano fa:nemi Kote solo se tiye kinisene sepatosene sena Ta:nioloyewi selese, ‘Kote kolotea meapoma:na:pela: Kote koane senayewi nano ketea olokeyatelawa apolaposakeye.’ Aluse Ta:nioloyewi seyawa hetetiyaposakeye. Aputa: nano ketea olokeyatelawa hetetiyapita: kiyawa puka we akelesene sena kesaleyewi potapola: Yesuyewi sowa kiyawa matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Alake Yutia sena kesale kiwala, keteawa hetetiyakemiwa kiwa nesile tokowemi ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ikila emiwa sena koane tomo kiwa ene koane suwemi nano ketea tima:na:pela: hanakamakiwa eta: ilimanakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sena nowa ene alekena honosane enewa koane sao tima:na:pela: hanakamakiwa eta: ilimanakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kesale alelawala, kesale sala kiaiya yowala, nesile hanakamakiwa sosolo hokopesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yapewemiwana ha:le tesene opo emiwana nesile ha:na:na: oka hetetima:pekise kulukulupa:. ");
INSERT INTO khs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kiwa nesile hanapola: epesita:ya ikila emi ikomoma:na:wa sosolo tepesakeye. Peleya: sosolo weyamo ma:ta: ti opo emiwana, yemiwana ikomoma:na:wa puwano eta: alamakeye. Aputa: ikomonose itapa tepela:, sikape epapuluse maikomopesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Aputa: ikomoma:na: opo hetetiyakemiwa, kaluse ikomonose sitalapitekiwa, sena kesale sopoke ya:te tepesakeye. Ya:te tema:pekise Koteyewi ta:peya sena kesale amowa matanepela:, ikomoma:na: opo heka Koteyewi na tiye kasa apolaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aputa: sena nowamoke kima selese, ‘Ta:ta:pa:. Sena we Piseiki sola:pewa Ekeye. Ewa Kelesokeye,’ au selaposakeye. Aputa: sena nowamoke kima selese, Ta:ta:pa:. Keleso inapola:, elakeye,’ au selaposakeye. Alake sena nokamoke aluse selesaleke, ili sowa ta:tapa. ");
INSERT INTO khs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sena noka mokopo Keleso mene tepela: hetetiyaposakeye. Aputa: sena noka mokopo sepatosene sena mene tepela: hetetiyaposakeye. Hetetise sena kesaleyewi iwa kulu hanapita: iyewi nano ketea penaiya tisene sosolo timinipesakeye. Timinipitekiwa sena kesaleyawa pota: ipipesakeye. Koteyewi ta:peya sena kesale iyewi ketea alusewa kapo popa:na:pela: sukulutiye timinipesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ta:ta:pa:. Oka seta: hetetima ela: nano ketea auma:na:wa Neyewi kima selakeye.’ ");
INSERT INTO khs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Alake senayewi kima selese, ‘Keleso mowa peleya:wemi elakeye,’ Au selapita: ta: tiyapola: potapose hanapa. Aputa: sena nowamoke selese, ‘Kelesowa koane muka:lakeye.’ Au selapita: ta:tapa. ");
INSERT INTO khs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aputa: opo inisene tapowemi saiyakolose ho:liyawa, opo sinisene tapowala ho:lilisekeye. Alusene amunuse Newa kemiwa epapuluse mina:na:keye. Sena Sa:wa Nekeye. ");
INSERT INTO khs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Aputa: nano ketea kulu telapitekiwa a:nema: usunuwa kekenesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesuyewi selese, “Ikomoma:na: oka itapa tese ela:pe kipila ikilale otowi yopolo tepesakeye. Nukulapo kuneiyawa maho:lilipesakeye. Meiyetolu hepene falemi tese peleya: weyemi sululuwalupesakeye. Hepene falemi nano ketea sololo sita:newa ilelipesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ikila emiwa hepene falemi tese Sena Sa: Newa mene mina:na:wa nano ketea penaiya sosolo nowamoke waloma:na:keye. Nano ketea walopita: peleya: sosolo weyemi sena kesale sopoke sita:neyawa potose ya:pelepesakeye. Ya:pelese potakamake Newa hepene falemi tese meiki koiya emi penaiyawanapulu ho:liya sosowalapulu inapita: potaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Potapita: wa:polo sosolo sanaposakeye. Sanapita: hepene sena muta Neyewi hamonapita: inise, Neyewi ta:peya sena kesale peleya: sopowemi sita:newa mene silima:na:keye. Neyewi ta:peya sena kesale fo:su tapowemi sita:newana, fapo helele tapowemi sita:newana, fapo helele tapowemi sita:newana, sipupa: minitapo sita:newana, peleya: sopowemi Neyewi ta:peya sena kesalewa siliyapola: kekenema:na:keye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yesuyewi selese, “I kalu pale seyawa wekeye. I kalu seyawa alutisaleke kiyewi potose matanese, ‘Hepolo tema:na:pela: mapatotakeye.’ Aluse kiyawa matanesekeye. ");
INSERT INTO khs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Alusene amunuse Neyewi nano ketea auma:na: seyawa hetetiyapita: potapola: kiyawa matanese, ‘Yesu mina:na:wa mapatotakeye,’ esa: matanepa:. Aputa:, ‘Sena koane suwemi musuluma:na:pela: isu tenamo mapatopita: ela epapuluse, Yesuwa epapuluse mina:na:wa mapatotakeye.’ Aluse kiyawa matanepa:. ");
INSERT INTO khs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Neyawa kima heneye selakeye. Sena kesale ikiwapo semetei kemi kesilawa iwa seta: kulumake a pote a sitalakemi, Neyewi auma:na: seyawa hetetiyapita: potapola:, we aluselapo esa: epalakeye. Aluse potaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Alake, meiki falala peleya: sosolo weyala itapa tepesakeye. Alawamona Ne sowa maitapa tepesakeye. Kokolo kao elaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yesuyewi selese, “Newa mina:na: okala opo si awawala senayawa eta: matanesemakeye. Hepene senayawala Kote E Sa:le Neyawana eta: matanesemakeye. Ni Atayewi Ene semeteiyewi matanesekeye. ");
INSERT INTO khs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Aputa: Noa enene ikila emiwa sena kesale sita:ne amunuse Newa mene mina:na: ikila emi sena kesaleyawa aluse sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa enene ikila emiwa hawa seta: minama ela: sena kesaleyawa ma:na: nasewana, hawana napela: senayawa kesale tiye, kesaleyawa sena salo hanapola: aluse sita:nekeye. Aluse sita:newemi Noa potiwemi talakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tapita: sena kesale sopoke tikila:pela: sita:nenase hawa hakene minakeye. Hano hakene inise nano ketea sopoke tiye hapakeye. Alake Sena Sa: Newa mene ina ikila emiwa Noa enene ikila emi ela amunuse aupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Newa mene ina ikila emiwa, sena elipei alekenawemi sita:newa nowa Neyewi silise, nowa kemi iya:pa:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kesale elipeiyewi witi fo falawa timinima:na:pela: muya:sela: sita:newa, nowa Neyewi silise, nowa kemi iya:pa:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Auma:na:nase kiyawa pote sita:latipa:. Kiyawa Piseiki mene mina:na: oka kiyawa eta: matanamake pota: sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Aputa: sena nano ketea atu tiseyawa sena nowamo koane nano ketea atu tima:na:pela: inisekeye. Nano ketea atu tima:na:pela: mina:na:wa, opo si awawa koane inayawa eta: matanesemakeye. Nukulapo ka:lewemiwana, nukulapo honosanewemiwana, ikiwapa:na: mapato kemiwana, atu tisene sena koane o:sulu mina:na:wa, koane inayawa eta: matanesemakeye. Eta: matanamanase ikilawala, nukulapowala, eta: enimake koane pote tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Alusene amunuse kiyawala aluse pote sita:latipa:. Sena Sa: Newa mene mina:na: ikilawala, opo si awawala, kiyawa eta: matanamanase kiwa pota: sita:latipa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesuyewi selese, “Tima:na: tisene senayewi seli matanese ene inama matana semetei matanepela: weyamu tesekeye. Inayewi ema selese, ‘Ne koawa pota: elatipa:. Sena koane sita:nema nano ma:na: ili kina:pa:. Na tese kinapa.’ Aluse selese selapola: hanapola:, ");
INSERT INTO khs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","sikape mene inise potakamake tima:na: tisene senayewi timinipe seyawa tiyapita: potapola: sosolo epelepesakeye. Epelese ewa napola:taposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Neyawa kima heneye selakeye. Koane inayewi ene tima:na: tisene senawa solo se ema selese, ‘Neyewi nano ketea sopoke pota: elatipa:,’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Alawamona, tima:na: tisene sena olokeyatela weyamu tesaleke matanese, ‘Koane inawa hapa sema mamene inatakeye.’ ");
INSERT INTO khs_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aluse matanese eyewi tima:na: tisene sena noka sanose, sena olokeyatela noka ilipe ka:la:lopela:la:, hano olokeyatela napela: matana nanano tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aluse ela: ene inawa mene mina:na: okala, opo si awawala, eta: matanemake enewemi, ene inawa mene inisekeye. ");
INSERT INTO khs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mene inise tima:na: tisene sena falasise sananape apola: ema selese, ‘Kewa hamona. Sena matana elipei sita:ne alapulu elapose hamona. Peleya: emi iwa sita:la: ya:pelese peka kalo na:sela: sitalakeye. Amowana elapose hamona.’ Aluse koane inayawa selaposakeye.” Aluse Yesuyewi pale seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesuyewi selese, “Piseiki mene mina:na: ikila emi, Kote Piseikipela: pote a elekiwa ela amunuse, auma:na:wa wekeye. Kesale pola taloipe sopoyewi nafa tiyapola: koawa iya:pela: sena kesale napute tiwa isu kiwemi koluma:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kesale taloipe sopoyawa pipe nowamoke seli eta: matanemakeye. Aputa: kesale pipe nowamoke seli matanakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Alake seli eta: matanama kesaleyawa nafa semetei tiyapola: hanapola:, wela hawa potolowemi wasu tiye tiyapola: eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Aputa: seli matana kesaleyawa nafa tiyapola: wela hawa potolowemi wasu tiye tiyapola: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aputa: sena kesale napute tiwa sema inapita: kesale taloipe hapawa enima:na: tepita: enikeye. ");
INSERT INTO khs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Faya elapita: nukulapo honosanewemi sena nowamoke holose, ‘Sena kesale napute tima:na:wa inatakeye. Kiyawala potapose mina.’ Aluse holakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hopita: kesale taloipe sopowa tesile fiyanapola: nafa tutiyapola:, ");
INSERT INTO khs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","seli eta: matanama kesaleyawa seli matana kesalema selese, ‘Nini nafawa sekako tiyape. Kiyawa wela hawa nini nafa kolotea susama.’ ");
INSERT INTO khs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Au selapita: seli matana kesaleyewi selese, ‘Eta: auma:na:makeye, niyawa kima susakamakiwa eta: ilimanakeye. Niwa sopowamopela: wela hawa ilima:pele. Wela hawa itapa tema:pekise kiwa kilipe sitoa hanapola: pa:ta wa:la:lopa:.’ ");
INSERT INTO khs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Au selapita: iyawa wela hawa wa:la:loma:na:pela: hapakeye. Hanapita: sena kesale napute tima:na:wa minakeye. Inapita: wela hawa ili wasu tiye mina kesale amowa ewalapulu ilipe semetei ma:na: ma:na:wa koane musuluyetiye hapakeye. Hanapita: isu tenamo etapeyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Etapeyawemi seli eta: matanama kesale pipe sopowa sikape inapola: peleya: pakia emi tese holose, ‘Piseiki, Piseiki, isu tenamowa kolo tima. Niwa mina:na:keye.’ ");
INSERT INTO khs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Au selapita: piseikiyewi selese, ‘Neyawa heneye selakeye. Kiwa neyawa eta: potesemakeye.’ Aluse eyawa seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Auma:na:nase kiyawa pota: sita:latipa:. Alake Newa mene mina:na: ikilawala, opo si awawala, kiyawa eta: matanemake pota: sita:latipa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesuyewi selese, “Piseiki mene mina:na: ikila emiwa auma:na:wa wekeye. Alekena inawa makene ha:na:na:nase ene tima:na: tisene senayewi ene moweniwa pota: sita:pesita: mina selapita: minakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Alake tima:na: tisene senayewi alusewa alekena ina amoke potose, ima nano ketea semetei kamuna mimakeye. Sena semetei nowamoke hele heneye penanose timiyanase ema moweni taosene pipe pota: epesita: mikeye. Aputa: sena semetei nowamoke penanose timiyanase ema moweni taosene elipei pota: epesita: mikeye. Aputa: sena semetei nowamoke kolotea penanose timiyanase ema moweni taosene semetei mikeye. Kinapola: apola: ene makene hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Makene hapalapita: moweni taosene pipe tili senayawa pisinisi timinise, moweni taosene pipe nowana, tiyapola: alapulu kekenakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aputa: moweni taosene elipei tili senayawa pisinisi timinise, moweni taosene elipei nowana, tiyapola: alapulu kekenakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Alawamona, moweni taosene semetei tili senayawa peleya: ta:pela:, ene pota: enene sena amokiwa moweni taosene semetei miwa tikipiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Alake ikiwapo muta kotetipela: tima:na: tisene senayewi ili tilile esa:, alekena inayewi potapose mene minakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mene inapita: moweni taosene pipe tili sena amoke moweni taosene pipe nowana tiyapola: alapulu kekenawa, alekena inama mikeye. Kinise eyewi selese, ‘Piseiki, keyawa nema moweni taosene pipe kinapita:, neyawa pisinisi timinise moweni taosene pipe nowana, tiwa Kewamopela: moweni sopowa tiye tiwa akeye.’ ");
INSERT INTO khs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Au selapita: alekena inayewi selese, ‘Napolakeye. Kewa tima:na: tisene sena napokeye. Keyawa nema matana semetei matanese napolo timiyanakeye. Neyawa kema nano ketea kolotea pota: epesita: apoyawa keyawa napolo timiyanase, keyawa nano ketea sosolo pota: epesita: neyawa apoma:na:keye. Ke piseikiwa nekeye. Neyawa kema epelekeye. Keyawala epelepa:. Na:nipe semetei epelese sita:pesena:keye,’ au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Aputa: moweni taosene elipei tili senayawa alekena ina elakemi inapola: selese, ‘Piseiki, keyawa nema moweni taosene elipei kinapita:, neyawa pisinisi timinise moweni taosene elipei nowana tiwa kewamopela: tiye ti akeye.’ ");
INSERT INTO khs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Au selapita: alekena inayewi selese, ‘Napolakeye. Kewa tima:na: tisene sena napokeye. Keyawa nema matana semetei matanepela: napolo timiyanakeye. Neyawa kema kolotea pota: epesita: apoyawa keyawa napolo timiyanase, keyawa nano ketea sosolo pota: epesita: neyawa kewa apoma:na:keye. Ke piseikiwa nekeye. Neyawa kema epelekeye. Keyawala epelepa:. Na:nipe semetei epelese sita:pesena:keye,’ au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Aputa: moweni taosene semetei tili senayawa alekena ina elakemi inapola: selese, ‘Piseiki, neyewi matanesekiwa, “Kewa sena komokeye. Kewa kine alekena ina ela kemi, tima:na: tisene sena kewamopela: ke alekenawemi nakela kelawa, fo watapita:, keyawa tine, au selesekeye.” Aluse Neyewi matanema:na:pela: ");
INSERT INTO khs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","newa ipilise ela: ke moweniwa peleya: ta:pela: tikipiyakeye. Tikipiyawa sitiyapola: keyewi kiwa kinawa kema mene kinakeye.’ ");
INSERT INTO khs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Au selapita: alekena inayewi selese, ‘Kewa tima:na: tisene sena hele heneye olokeyatelakeye. Kewa tomayewi mapolose tima:na: tiya:sela: elakeye. Keyewi matanesekiwa, “Eyawa alekena eta: kelama kemi nano ketea nasewa tisekeye.” ");
INSERT INTO khs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aluse matanese ne moweniwa keyewi pa:eke tuwatoluwamona ke elalakeye. Tuwatapitekiwa moweni kolotea nowana wapa:kemi pape mapekeye. Newa mene inise moweni kokonose tiye tiwala, moweni kolotea papeyawala, timapekeye,’ au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Alanase alekena inayewi sena nokama selese, ‘Moweni taosene semetei ene ema pota: epesita: miwa mene tupa. Tutapola: moweni taosene taloipe tili senama moweni taosene semetei kina:pa:. ");
INSERT INTO khs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Alake senayewi nano ketea pa:ta tesenema, nano ketea nowana miya:na:keye. Kinapita:, ene enawa sosolo teselaposakeye. Aputa: nano ketea nowa eta: tesenema senayawa nano ketea nowa elapita: tukutiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tima:na: tisene sena olokeyatelawa mowa yopolotela peleya: tapowemi toliyetima. Peleya: emi sena kesale ya:pelese peka kalo na:sela: sitalaposakeye.’ Aluse alekena inayewi seyakeye.” Aluse Yesuyewi pale seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesuyewi selese, “Sena Sa:wa Nekeye. Newa inisekiwa ho:liyawalapulu hepene sena mutawalapulu ninipe mina:na:keye. Inisekiwa Newa Piseiki sosonase sea ho:liya sopolo emi helema:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Helapita: Ne minitapowemi sena kesale peleya: sopoke emi tese siliye inapita: kekenepesakeye. Kekenawa Neyewi tipipilise takalepesakeye. Alake a:pele sipiwalapulu kopolo nanikosewalapulu tisilakolose sita:newa, a:pele sipi inayewi epapuluse Neyewi tipipilise takalepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Takalese a:pele sipi tiya:le ili tapowemi apola:, kopolo nanikose tiya:le hukalo tapowemi apola:, aluse takalepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Aputa: Newa Piseikipela: ela: ne tiya:le ili tapowemi, sena kesale takalese apoyama weyamu sema:na:keye. ‘Ni Atayewi kiwa napola:pewa mina. Kiwa Koteyewi e sa:nase kiwa neyewi piseikipela: pote elaposakeye. Newalapulu epesena:pela: mina. Puwano fa:nemi, peleya: sosolo weyamowa ma:ta: ti ikila emiwa, kiwa Newanapulu sita:pesena:wa Koteyewi hekeya:sela: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aputa: Newa menipita: kiyewi Nema ma:na: nasewa kinisekeye. Newa hano menipita: kiyewi newa hano maita: kinisekeye. Newa himini inapita: kili koane newa minapela: silisapekeye. ");
INSERT INTO khs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Newa nano ketea misitiya ela: sao itapalapita:, kiyewi Newa seselese sao kinisalekeye. Newa nakola ka:pelalapita:, kiyewi Newa seselesapekeye. Newa tipolo selawatapita:, kiyewi Newa potapose inisapekeye.’ Aluse Neyewi sema:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aluse selapita: Kotema hekeya matana sena kesale Nema weyamu selaposakeye. ‘Piseiki, Kewa menipita:, asu niyewi Kema ma:na: nasewa mina? Kewa hano menipita:, asu niyewi Kema hano maita: mina? ");
INSERT INTO khs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kewa asu himini inapita:, niyewi Kewa minapela: silila? Kewa sao itapalapita:, niyewi asu Kema sao mina? ");
INSERT INTO khs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kewa nakola ka:pelalapita:, asu niyewi Kewa seselala? Kewa tipolo selawatapita:, asu niyewi Kewa potapose minana?’ Aluse Kotema hekeya matana sena kesaleyewi selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aluse selapita: Neyawa ima weyamu sowa sema:na:keye. ‘Neyawa kima heneye selakeye. Neyawa nine ne ma:e amunawana, nine ne ate amunawana, semetei nowa kolotea esa: enewa kiyawa seselalaleke Newamo seselakeye,’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aputa: ne tiya:le hukalo tapowemi sena kesale apoyama weyamu sema:na:keye. ‘Kiwa sopoke olokeyatelakeye. Setenepelekiwala, Seteneyewi tima:na: tisene senapelekiwala, tei eta: sekakolosemawa heke tiye apoyakeye. Kiwala Newa iya:pela: epemi hamona, au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Alake Newa menipita: kiyawa nema ma:na: nasewa eta: mimakeye. Newa hano menanapita: kiyawa nema hawa maita: eta: mimakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Newa himini inapita:, kiyawa newa minapela: eta: silimakeye. Newa nano ketea misitiya ela: sao itapalapita:, kiyawa nema sao eta: mimakeye. Newa nakola ka:pelalapita:, kiyawa newa eta: seselamakeye. Newa tipolo selawatapita: kiyawa newa potapose eta: minamakeye.’ Aluse Neyawa sema:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aluse selapita:, iyawa Nema weyamu selaposakeye. ‘Piseiki, Kewa menise elapitekiwala, hano meina:sela: elapitekiwala, himini inapitekiwala, sao itapalapitekiwala, nakola elapitekiwala, tipolo selawatapitekiwala, asu niyewi Kewa pote iya:peyala?’ Aluse iyewi selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aluse selapita: Neyewi ima weyamu solo mene sema:na:keye. ‘Neyawa kima heneye selakeye. Sena kesale kolotea esa: enene semetei nowa, kiyewi eta: seselamake, kiyawa Newa pote iya:tesalekeye.’ Aluse Neyawa sowa mene sema:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Alake iwa kemi kokolo kao falasima:na:pela: nono kolemi hanapita:, alawamona, Kotema hekeya matana sena kesalewa Kotewalapulu kokolo kao sita:pesena:pela:, nono falemi hanaposakeye,” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesuyewi ketea auma:na:wa selapola: kotetise, E sena ilipe hanosema selese, ");
INSERT INTO khs_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ikila elipei itapa tepela:, Koane Helepa:pe Matanema:na:pela: Tikinakeye. Tikinisene ikila emiwa, Sena Sa: Newa i kelipapoya papela: sana kuma:na:keye. Sana kumita: senayewi Newa sihelelepesakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Aputa: pilisiti sena puwanowa ene unuwa Kaiafasekeye. E koane pilisiti sena sosowala, Yu sena tililawala sopoke kekenakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kekene tiyapola: iyewi kekelese selese, “Yesuwa hopolose sukulu tiye sana kumita: sanaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Alawamona, tikina amo okemi, Yesuwa sutakamakiwa eta: ilimanakeye. Sena muta kekenayewi niwanapulu tepa:pekise niyawa eta: supa:na:makeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Petani koamesa: Saimone wakapila tela itapa telayewi koane, Yesuwa enewemi ");
INSERT INTO khs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kesale nowa inise etewa napolo potolo amuna timiyawa tiye minakeye. Potolo tiye mina emiwa wela hele heneye ikomo hosonosene, moweni sosoyewi wa:la:losewa wasu tikeye. Wasu tiyapola: Yesuwa tepolo pawemi hela: ma:na: na:sela: helapita:, kesale amoke wela ikomo hosonosene Yesu piseiwemi sulakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Supita: potapola:, sena ilipe hanoseyewi konomonose i kene sopolo selese, “Kesale amoke welawa ko:lupita: mokopokemi suluse itapa tepe? ");
INSERT INTO khs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Welawa sena nowama wa:la:lopela: moweni sosolo timapetakeye. Moweni tiwa sena kesale ketea misitiyama miyapetakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Au selapita: ili matanawa Yesuyewi potapola: selese, “Ko:lupita: kesale amowa mapolomita: aluse sela? Kesale amoke Ne piseiwemi wela sukamowa nano ketea tisene heneye napowa akeye. ");
INSERT INTO khs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Alake sena ketea misitiyawa ikila sopoke kiwalapulu kilipe sitalaposakeye. Alawamona Newa ikiwapo sopoke kiwalapulu ninipe maelaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ne tomawa apana tuwapa:na:pela: kesale amoke wela ikomo hosonosene Ne toma napola:tese suma:na:wa ta:pele tiyapola: sulusapekeye. ");
INSERT INTO khs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ta:ta:pa:. Neyawa kima heneye selakeye. Peleya: sosolo weyamo senayawa Newamo se tiye kina ikila emiwa kesale amoke wela sulawala sena kesaleyewi matanemita: iyewi selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sena ilipe hanosene kukuluipe semetei nowa unuwa Yutase Isekeleote ewa pilisiti sena sosolo sita:newemi hanapola:, ");
INSERT INTO khs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","se tiye kinise ta:potose, “Neyewi Yesuwa sihelelesaleke kiyawa nema ena miya:na:na?” Au selapita: iyewi Yutasema selese, “Niyawa kema silifa moweni usu talo usulupe miya:na:keye.” Aputa: iyewi silifa moweni usu talo usulupe akelese ema kinakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aluse kinapita: Yutaseyewi matanese, “Yesuwa noko:lu sihelelema:na:ne,” esa: Yesuwa sihelelema:na: isuwa keyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Falawa eta: solosema ma:na:pela: tikinisene ma:ta: tisene ikila emiwa Yesuwa elakemi sena ilipe hanosene inapola: selese, “Koane Helepa:pe Matanema:na:pela: Tikinise ma:na: ma:na:wa, koane kami kekene tiye tiye tima:na:na?” ");
INSERT INTO khs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Au selapita: Yesuyewi selese, “Yelusaleme sitiwemi hanose sena nowama weyamu sela:pa:. Walosene senayewi selese, ‘Newa kuma:na: oka mapatotakeye. Mapatoyanase Koane Helepa:pe Matanema:na:pela: Tikinima:na:pela: ke koawemi Ne sena ninipe hanosewanapulu ma:na: ma:na:keye.’ Aluse Neyewi selesapekeye, e sela:pa:.” Aluse Yesuyewi sekepilapita:, ");
INSERT INTO khs_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","solo amowa kaluse kulu hanose sena ilipe hanosewa hanapola: ma:na: ma:na:wa kekene tiye tiye tikeye. ");
INSERT INTO khs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ka:lewemi Yesuwa E sena ilipe hanosene kukuluipewalapulu koane emi hapakeye. Hanapola: tepolo pawemi ");
INSERT INTO khs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ma:na: na:sela: ka:la:lopela:ne ikila emi Yesuyewi selese, “Neyawa kima heneye selakeye. Kiyawa sena semetei nowamoke Newa sihelelepesakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Au selapita: iyawa matana eta: epeyamake mapolose, i kene ta:keye hanose, “Piseiki, Kewa sihelelema:na:wa newama?” Aluse ta:keye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ta:keye hanapita: Yesuyewi selese, “Neyewi falawa tiye hano wela tikipela: kemi, sena nowamokiwala ke tikila sena epakeye. Sena amokiwa Newa sihelelepesakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sena Sa:wa Nekeye. Newa senayawa auma:na:wa Kote pukawemi sepatosene senayewi momate tiye apoyawa kamunuse aupesakeye. Newa sihelema:na: senawa fala:sima:na:wa mahepapelepesakeye. Sena amowa yoyewi eta: kesilamakiwa amowa ilimapetakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Au selapita: Yutase Yesu sihelelema:na: sena amoke Yesuma selese, “Walosene sena, Kewa sihelelema:na:wa newama?” Au selapita: Yesuyewi Yutasema selese, “Henekeye, kine epe seleseya kakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iyewi ma:na: na:sela: ka:la:lopela:ne ikila emi Yesuyewi falawa tiyapola: Kotema napolo esa: kulukululakeye. Kulukuluse kotetipela: Eyewi falawawa tiyapola: pasoloyetiye, E sena ilipe hanosema kinapola: selese, “Falawa we kiyewi tiyapola: maiya. Weyamowa Ne tomakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aputa: kapo hano tiyapola: Kotema napolo esa: kulukulupela: kotetipela: ima kinise selese, “Kiyawa sopoke maiya. ");
INSERT INTO khs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Waine hano we Ne pepetakeye. Koteyewi sena kesalewalapulu hili sepapowa matanemita:, Ne pepeta hapawa akeye. Sena kesale mutayewi mane olokeyatelawa pepeta amoke kepoliyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ta:ta:pa:. Waine hano weyamowa Neyawa wa:ke peleya: weyemi eta: ma:na:makeye. Ni Ata Piseikipela: elakamo peleya: emi kiwalapulu ninipe kekene tiyapola: waine hano hiwamo ma:na:keye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aluse selapita: iyewi Kotema wapilise kisalakeye. Kisalese itapa tepela: koawa iya:pela: tokomo Olifiwemi fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sena ilipe hanosema Yesuyewi selese, “Napu nukulapo Newa aputa: potapola:, kiyawa sopoke Newemi matana semetei esa: eta: matanamake Newa iya:taposakeye. Aputa: Kote pukawemi Koteyewi seya momateyawa wekeye. ‘A:pele sipi yesila senawa Neyewi kumita: sanaposa, a:pele sipi sopoke netalepesakeye.’ Aluse momateyawa aupesakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Auma:na: kamunuse Newa mene tesilapola: Kalili peleya: emi Newa puwano hapalapita:, kiwa sikape inapola: ninipe semetei kekenema:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Aputa: Pitayewi Yesuma selese, “Iyawa sopoyawa kewa iya:tapita:, alawamona, neyawa Kewa heneye maiya:taposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Au selapita: Yesuyewi Pitama selese, “Neyawa heneye selakeye. Napu nukulapo kokono seta: kayamawemi keyawa ‘Yesuwa eta: potesemakeye,’ esa: ikila usulupe keyawa mokopo selaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Au selapita: Pitayewi selese, “Eta: auma:na:makeye. Newa Kewalapulu na:nipe kuluse, ko:luse Kewa eta: potesemakeye, e sema:na:na?” Au selapita: sena ilipe hanosene sopoyewi Pitayewi solo amowa semetei kamo kulu hanose seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesuwa sena ilipe hanosewanapulu Kesemene peleya: emi hanose, Yesuyewi ima selese, “Kiwa weyemi ka:la:loma. Newa kolotea hanapola: kulukuluma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aluse Yesuyewi Pitawala, Sepetiyewi e sa:le elipeiwala siliye hanapola:, Yesuwa Ene sosolo himu nakolose eta: epeyamake enekeye. ");
INSERT INTO khs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aluse ela: Yesuyewi ima selese, “Newa himu sosolo nakolose ela: Newa kuma:na:nakeye. Weyemi kiwa Newanapulu ninipe yesipela: sita:pesena:keye. Kiwa eniyapa.” ");
INSERT INTO khs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aluse Yesuyewi selapola: apola: kolotea hanapola:, panoka:pela:la: mitiyawa peleya:wemi opola: ela: kulukulula:sela:, “Ni Ata, Keyawa Nema nano ketea hilila apoyakeye. Apoyawa ililaleke nano ketea hililawa Keyewi tima. Alawamona Neyewi matanawamunuse aupa. Keyewi Kine matanawamunuse aupa:.” ");
INSERT INTO khs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aluse kulukulupela: kotetise sena ilipe hanosene usulupe amowa ka:la:lo pela:newanapulu inapola:, potakamake iwa fayalapita: papokeye. Potapola: iwa kila:tese tesilapola: Pitama selese, “Kiwa opo si awa semeteiwemi Newanapulu ninipe tesile pota: eta: sita:pesena: telamanakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Alake kiwa polusaleke kiyewi olokeyatela tima:na: tiye ha:na:pekitise falela apota: sita:la: kulukulupa:. Kili matanayewi kulukuluma:na:pela: epelese, elawamona tomayewi hopolo tese eniyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aluse Yesuwa wa:ke me hanapola: kulukulula:sela:, “Ni Ata, nano hililawa Keyewi Nema mikeye. Miwa Neyewi matisaleke maitapa tepesakeye. Nano hililawa itapa temita: Neyewi tima:na:keye. Keyewi matanawamunuse Neyawa auma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aluse kulukulupela: kotetipela: sena ilipe hanosene ka:la:lo pela:newanapulu, Yesuwa inise potakamake iwa wa:ke fayalapita: papokeye. Ko:yawemiye, iwa enima:na:pela: siwa sitiyapola: minenise heneye fayakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Fayalapita: iya:pela:, Yesuwa kolotea hanapola: wa:ke osokamo kulukululakeye. Kulukuluse puwano kulukulula semetei kamunuse kulukululakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kulukuluse kotetise sena ilipe hanosewa ka:la:lo pela:newanapulu Yesuwa mene inise selese, “Kiwa kao fayala? Kiwa sopoke tesima. Sena Sa: Newa sihelelese sena olokeyatelayewi Newa supa:na: ikilawa opo weyalakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kiwa sopoke tesima. Tesilapola: niwa hanakeye. Sena Newa sihelelema:na:wa inatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesuyewi seya ikila emi E sena kukuluipe hanosene nowa unuwa Yutase inise, sena muta ewalapulu ilipe minakeye. Sena minawa sena nokamoke kafa: tiye ine, sena nokamokiwa pesapu ketea amowa tiye ine, sena nokamokiwa sapa ketea amowa tiye minakeye. Sena minawa pilisiti sena sosoyawala, Yu sena tililayawala, iwa hamonapita: minakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sena amowa seta: minama ela: sihelema:na: sena Yutaseyewi puwano selese, “Sena neyewi minitisaleke sena akeye. Ewa suta:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Au seyanase Yesu enewemi Yutase hekeya inapola: selese, “Yopolotela napolo, Walosene sena,” esa: eyewi Yesuwa minipikeye. ");
INSERT INTO khs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Minitapita: Yesuyewi selese, “Ne mana, keyewi timinima:na: minawa timinima.” Au selapita: sena muta inapola: Yesuwa supukeye. ");
INSERT INTO khs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sutapita: Yesuyewi sena ilipe hanosene sena semetei nowamoke ene sapa sulu tiyapola: tiye, pilisiti sena puwano tima:na: tisene sena nowa kena:wa alotiye toliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Alotiye toliyetiyapita: Yesuyewi selese, “Ke sapawa tekakemi pokolopoma. Senala: sapayewi tetesaleke sapayewi iwa sanaposakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Senayewi Newa ikomoma:na: ikila emi Ni Atama hopita: Ni Atayewi hepene sena taosene muta eta: akema:na: telama amuna amoke Newa sesemita: hamonapesakeye, aluse Ni Atayewi hepene sena amowa hamonama:na:wa kiyawa tikili tepa? ");
INSERT INTO khs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Aputa: Newa kulaposape e seyawa Kote pukawemi momateyawa aumita: hepene senawa mahamonapesakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aluse Yesuyewi sena sopolo kekenama selese, “Kiyawa sapawa tiye ine, kafa: tiye inapola:, Newa supa:na:pela: inapola: epesita:ya Newa atu tisene senanapa? Ikila sopoke Kote koane Newa ela: se tiye kinapita:, kiyawa Newa masutuselapokeye. ");
INSERT INTO khs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Alawamona Kote pukawemi Kote solo se tiye kinisene sepatosene senayewi momatelese Newa auma:na: seyawa epe hetetiseya akeye.” Aluse selapita: Yesuyewi E sena ilipe hanosene sopoke Ewa iya:pela: talele hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pilisiti sena puwano wa:pa:se elaka Kaiafasekeye. Kaiafase koane Yesuwa supulu sena amoke Ewa siliye hapakeye. Koane Kote solo ele walosene senawana, Yu sena tililawala, Kaiafasewalapulu kekene tiye sita:newanapulu iyawa Yesuwa siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Siliye hanapita: Pitawa kolotea pama kulule hanose hapakeye. Kulule hanose hanapola: pilisiti sena puwanoyewi koane peleya: pakia hanapola: sena ta:le ti ka:la:lo pela:newanapulu Pitawala henekeye. Hela: Yesuma nano kotoka popa:na:pela: henekeye. ");
INSERT INTO khs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aputa:, pilisiti sena sosoyawala, Kote solo ele walosene senayawala, Yu sena tililayawala, iyawa sena nokama mina e seya. Inapola: senayawa Yesuma kotopela: tipalese selapose mina e seyakeye. Iyewi matanese, “Sena nokamoke Yesuwa kotopita: Yesuwa falasise sana kulaposakeye.” Aluse tipalese semita: keyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Keya ikila emiwa sena nokamoke Yesuma mokopo tipalese seya kamona, ili sowa ta:tese Yesuwa sana kula:pa:, aluse semita: iyewi tafase eta: ilimakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Sikape sena elipei inise selese, “Sena amokiwa selese, ‘Kote koane Neyewi ekeyetiye ikila usulupe itapa tepela: wa:ke tima:na:keye.’ Au seyawa na:tewi topukeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Au selapita: pilisiti sena putupela: enewa tesile Yesuma selese, “Keyawa sowa mene sema:na:na? Kema nano kotola mouwa enana?” ");
INSERT INTO khs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Aputa: Yesuyewi nano nowa maselapita: pilisiti sena puwanoyewi selese, “Kotewa kokolo kao enenase neyawa Kema meatewi ta:potapita: Keyawa hekilase sowa mene sela:pa:. Koteyewi Kewa Piseikipela: epesita: ta:peya sena Kelesowa Kewama? Kote E Sa:le amowa Kewama? Keyawa sema.” ");
INSERT INTO khs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Au selapita: Yesuyewi selese, “Henekeye, kewa kine epe seleseya akeye. Ta:ta:pa:. Kote Ewa hele heneye penaiya elakeye. Alake sikape Sena Sa: Newa Kote tiya:le ili tapowemi helapita: kiyawa potaposakeye. Newa hepene emi tese kiniwaniwanapulu inapita: kiyawa potaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aputa: pilisiti sena puwanoyewi ta:tapola: mapolose, ene saowa keselese selese, “Sena amokiwa Kotewa kolotea me apolatakeye. Eyewi ela: Kotewa kolotea meapolosaleke Ewa kotoma:na:pela: sena nowa eta: minama:na:makeye. Ene ela: Kotewa kolotea meapolosaleke kiyawa ta:takeye. ");
INSERT INTO khs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ta:tapola: kiyawa matanawa enana? Niyawa Yesuwa ko:luma:na:na?” Au selapita: iyewi selese, “Ewa sana kula:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aluse Yesu sikapo kepesesa:, sena nokamoke tiya:wa somo tiye sanose, sena nokamoke tiya: tekatewi sanose selese, ");
INSERT INTO khs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Kewa Kelesonase Kewa sanaka etewi sanapa:? Ewa unuwa sema. Alake Kote sepatosene senama seya amunuse, Kewa ikomoma:na: senawa Koteyewi unuwa selapita: ta:tapola: Keyawa unuwa sema.” Aluse iyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peleya: pakiawemi Pitawa helapita: tima:na: tisene kesale nowa inapola: ema selese, “Kewa Kalili sena Yesuwalapulu kilipe hanosekeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Au selapita: Pitayewi alamakeye esa: selese sena sopoyewi ta:pita: selese, “Keyewi epe seleseyamowa newa tikili tekeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Au selapita: Pitawa koane sola pakia isuwemi hanapola: elapita:, tima:na: tisene kesale nowamoke sena ka:la:yama Pitawa walose selese, “Sena epamowa Nasalete sena Yesuwalapulu hanosekeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Au selapita: Pitayewi hekilase selese, “Sena epamowa neyawa eta: potesemakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Au selapita: kolotea ka:la:lopela:lape sena sita:neyawa Pita enewemi inapola: selese, “Ke sowa niyewi ta:takamake Kalili senayewi solo selatakeye. Yesuyewi sowa niyewi ta: tesenase ke sowala niyewi ta:takamake, Yesuyewi sena ilipe hanoseyewi selesewamunuse selatakeye.” ");
INSERT INTO khs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Au selapita: Pitayewi henipasolose hekilase selese, “Sena epamowa neyawa eta: potesemakeye. Neyawa mokopo selapitekiwa Koteyawa newa falasisaleke ililakeye.” Au selakamake ela:pe kipila kemi a:nema: kokonowa kayakeye. ");
INSERT INTO khs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kalopita: ta:tapola: Yesuyewi puwano seyawa Pitayewi mene matanakeye. Alake puwano Yesuyewi selese, “A:nema: kokonowa seta: kayamawemi keyawa ikila usulupe ‘Yesuwa neyawa eta: potesemakeye,’ au selaposakeye.” Aluse Yesuyewi seyawa Pitayewi matanese koawa iya:pela: mowa hanapola: sosolo ya:lakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kiapowemi ikiwatapita:, pilisiti sena sosowala, Yu sena tililawala iwa kekene tiyapola:, Yesuwa sanose kuma:na:wa kekela:sela: sela:sela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Iyewi selese sitalapepela: kekelese selese kotetise, Yesuwa meiyewi tapola: apola:, Pailate elakemi Yesuwa siliye hapakeye. Aputa: Yutia peleya: amowa Lome kamani sena Pailateyewi pota: enekeye. ");
INSERT INTO khs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yesuwa Pailate elakemi kotomita: siliye hanapita: potapola:, Yesu siheleya sena Yutaseyewi potapola: ene himu sosolo nakolose matanese, “Ko:luma:na:pela: kemi sihelelelue. Siufa moweni usu talo usulupe miwa neyawa tukutiye mene miya:na:keye.” Aluse matanese, pilisiti sena sosowala Yu sena tililawala iwa sita:newemi inapola: selese, ");
INSERT INTO khs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Neyawa olokeyatela timiyakeye. Yesuyawa olokeyatela eta: timiyama kamona, neyawa Ewa siheleyakeye.” Au selapita: iyewi selese, “Mouwa kine. Nini nemakeye.” ");
INSERT INTO khs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Au selapita: moweni usu tiye minawa tuku tiye Kote koane tisawemi tolusupela:, iya:pela: hanapola:, Yutase ene kemakuwemi mei kakiyewi koma:pela: sutesinise kulukeye. ");
INSERT INTO khs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kulapita: pilisiti sena sosoyewi moweni tukutiye mene miwa tiyapola:, kekelese selese, “Sena sana kumita: moweni weyamo minase, Kote koane moweni tiye ti alapulu moweni we kekenekamake eta: ilimanakeye.” Aluse iyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aluse selese moweni amowa tiyapola:, peleya:yewi kopalo amuna timinisene senayewi peleya:wa wa:la:yakeye. Aputa: peleya: wa:la:yawa sena makene mina kulapita: peleya: emi tikiwalomita: wa:la:yakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Alake peleya:wa unuwatese Pepeta Peleya:keye. Aluse unuwa tula hapawa, puka weyamo momateya ikila emiwana, aluse peleya:wa unuwa seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Alake peleya: amowa a wa:la:loma:na:no sepatosene sena Yelemaiyayewi momateyawa wekeye. “Ewa wa:la:loma:na:pela: Yu sena sosoyewi selese, ‘Siufa moweni usu talo usulupe amowa ililakeye.’ Aluse selese sepaponase moweni usu talo usulupe amowa tiye ");
INSERT INTO khs_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","peleya:yewi kopalo amuna timinisene senayewi peleya:wa wa:la:yakeye. Wa:la:yawa Koteyewi auma:na: seyawa aulakeye.” Aluse Yelemaiyayewi momateyawa heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lome sena piseikipela: enene minitapowemi Yesuwa elapita: Yesuma meatewi ta:tese, “Yu senayewi piseikiwa Kewama?” Au selapita: Yesuyewi selese, “Henekeye. Keye seya epakeye.” ");
INSERT INTO khs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Aputa:, pilisiti sena sosoyawala, Yu sena tililayawala, Yesuma kotopela: selapita: Yesuyawa sowa eta: mene seyamakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sowa mamene selapita: Pailateyewi selese, “Iyewi nano ketea sosolo kotoka Keyawa ta:teseya?” ");
INSERT INTO khs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Au selakamake Yesuyawa sowa mamene selapita: potapola: Lome sena piseikiyewi matanese, “Solama tepela: pota: elakamowa ko:luse epe?” esa: matanakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Pailateyewi matanese, “Yu senayawa Yesuma kanakese sana kumita: newa elakemi siliye minakeye,” aluse matanakeye. Matanepela: Yesu kotola opo emi Yesu sowa Pailateyewi ta:ta:sela: elapita:, Pailate ekeyewi Pailate enewemi sena nowa hamona seyakeye. Hamonapita: sena amowa hanapola: Pailatema selese, “Keyewi kine kesaleyewi solo sekepiyawa wekeye. ‘Napu neyewi uwa koane sena napolo Yesuwa paponase himuyewi sosolo matanepela: elakeye. Alanase sena napowa falasipa. Iya:ta:pa:,’ au seyakeye.” Aluse sena mina amoke selapita: Pailateyewi topukeye. Aputa: Koane Helepa:pe Matanema:na:pela: Tikina ikila emiwa tipolo selawapo sena semetei nowa Lome kamani sena piseikiyewi silikepilisekeye. Tipolo selawapo sena semetei nowa silikepimita: Yu senayewi ta:pele tise, “Sena amowa silikepila:pa:,” esa: ta:pelepita: kamani piseikiyewi silikepilisekeye. Alake Yesuwa kotola ikila emiwa sena heneye olokeyatela unuwa Palapase tipolo selawapo elapita: potapola:, Yu sena muta kekenama Pailateyewi selese, “Sena mene silikepima:na:wa ikamo silikepima:na: matanepa:? Palapasewalao, Yesu Kelesowalao, ikamo silikepima:na:na?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Alawamona, pilisiti sena sosoyawala, Yu sena tililayawala, iyawa sena kesale sopoke kekenama se tiye kinise selese, “Yesuwa sana kuluse Palapasewa silikepila:pa:, e sela:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Au seyanase Lome kamani sena piseiki Pailateyewi selese, “Sena elipei amowa ikamo silikepima:na: matanepa:?” Au selapita: iyewi selese, “Palapasewa silikepila:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Au selapita: Pailateyewi selese, “Yesu Kelesowa ko:lumeinapa?” Au selapita: iyewi sopoke selese, “Ewa i kelipapoya papela: sana kula:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Au selapita: Pailateyewi selese, “Ko:lupita: sana kula:pa: e sela:? Eyawa olokeyatela ketea ena timiyana?” Au selapita: iyewi unuwapo holose, “Ewa i kelipapoya papela: sana kula:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aluse iyewi unuwapo holose sita:nekeye. Aluse sitalapita: senayewi tepa:na:wa Pailateyewi potapola: matanese, “Ne sowa iyewi ta:te iya:takeye.” Aluse sena sopoyewi popita: sena sopolo sikapo ela:, hayewi ene tiya:wa selakolose selese, “Sena epamowa sana kulusaleke ne hele timiyamakeye. Kili hele timiyakeye. Ne tiya:wemi nano ketea panewa selakolose itapa epakeye.” ");
INSERT INTO khs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Au selapita: sena kesale sopoyewi selese, “Yesuwa sanosaleke hele timiyawa nini nekeye. Nini salala:walapulu nekeye.” ");
INSERT INTO khs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Apula: Palapasewa Pailateyewi silikepilila:, e ta:le ti senama Yesu fa:kemi meiyewi sanapa: e seyakeye. Sanapita: potapola: selese, “Yesuwa i kelipapoya pamita: siliye ha:na:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kamani sena piseikiyewi ami sena inise, Yesuwa kamani koawemi siliye hanapola:, Yesu elakemi ami sena sopoke kekenakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kekene tiyapola: Yesu saowa sopolo kalu tiye iya:pela:, sao keyalo senato kapela: apola:, ");
INSERT INTO khs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ha:ti napolo piseiki sosoyewi kataopelesene epapula kataopola: apoyakeye. Alawamona ha:ti kataopeyawa heneye hatimakeye. Yesuwa itipilise mei ona towaya ha:ti amuna timiyawemi, kakili a:tesene epapuluse asulu kopo tiye timiyakeye. Timiyawa Yesu piseiwemi kataopola: apoyakeye. Kataopela: Yesu tiya: ili tapowemi tapa naiya tiya: saliye apola: kuniu kula:pola: itipilise selese, “Yu senayewi piseiki, Kewa sena sosokeye.” ");
INSERT INTO khs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aluse Yesu tomawemi kepesesa:, tapa tiya:wemi apoyawa tiyapola: Yesuwa piseiwemi sanakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sanose itipilise kotetipela:, sao keyalo senato toma momateyawa kolu tiye, Ene saowa kapela: apola: i kelipapoya pama:na:pela: siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yesuwa siliye hanose potakamake Sailini sena ene unuwa Saimone inapita: potapola:, i kelipapowa tiye uwapola: hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tiye hamonapita: iwa hanapola: Kokata peleya: emi hetetikeye. Aputa: Kokata peleya:wa amo mouwa Pisei Ki peleya:keye. ");
INSERT INTO khs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kokata peleya: emi hanapola: sita:la: Yesuyewi maita: waine hawana munamuna amunawanapulu papela: notoyalapepela: mikeye. Kinapita: Yesuyewi tapelesa: eta: menamakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Manapita: ami senayewi Yesuwa i palese, Yesu saowa takalese tima:na:pela: iyewi kase fesamonosene epapuluse fesamonakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Fesamona:sela: ka:la:lopela:la: Yesuwa sena nowamoke sesema:pekise pota: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ami senayewi Yesu pisei wapa:se falemi Ema kotola i pawemi momate tiye papeyakeye. Momatelese palawa wekeye. “Sena we Yesukeye. Yu senayewi Piseiki Ekeye.” Aluse momate tiye papeyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ikila emi atu tisene sena elipei Yesuwalapulu i kelipapoya pawayakeye. Nowa Yesu tiya: ili tapowemi papela: kepela:, nowa Yesu tiya: hukalo tapowemi papela: kepela:, Yesuwa honosane papela: kepeyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yesuwa papela: elapita:, sena noka Ewamo papela: ela pawemi hanose itipilise ilio esa:, piseiwa kolose selese, ");
INSERT INTO khs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Keyewi puwano selese, ‘Kote koane ekeyetiye ikila usulupe itapa tepela: wa:ke titima:na:keye,’ au selesapekeye. Au seyanase Keyawa Kine mene sesema. Kewa Kote e Sa:laleke i kelipapowa iya:pela: weyemi mina.” ");
INSERT INTO khs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Au selapita:, pilisiti sena sosoyawala, Kote solo ele walosene senayawala, Yu sena tililayawala, Yesuwa aluse itipilise selese, ");
INSERT INTO khs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yesuyewi sena noka seselakeye. Sesela kamona Ene Ewa masesetakeye. Ene Isolaiya sena Piseikikeye. Ene i kelipapoya iya:pela: weyemi inisaleke, niyewi Ema matana semetei matanema:na:keye. ");
INSERT INTO khs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ene Kotema matana semetei matanepela: ela: selese, ‘Newa Kote E Sa:keye.’ Au selapita: Koteyewi Ewa epelese seselesekiwalao Ewa sesemapitakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Au selapita: atu tisene sena Yesu tapowemi i kelipapoya pawaya amokiwala Yesuma kau seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Peleya: sopowemi opo si kukuwemi ma:ta: tiye yopoyakeye. Yopolotela enewa ka:le opo si osokemi wa:ke ho:liyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ka:le opo si osoka mapatokemi, Yesuyewi Yu sena solopela:la: unuwapo holose, “Elai, Elai, lema sapakatani.” Au seya amo mouwa selese, “Ne Kote, Ne Kote, Keyawa Newa ko:lupita: iya:peyala?” ");
INSERT INTO khs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Au selapita: ta:tapola: sena noka pawemi sita:neyewi selese, “Eyawa Ilaiyawa hotakeye.” ");
INSERT INTO khs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Au selapita: sena semetei nowa kipila hanapola: waine hano epapula hano ha:ka:la emi sipanese tikipela: mane tuwemi sakopola: Yesuyewi maita: tili tiye falemi ilikepiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sena nokamoke selese, “Asepakeye. Ilaiyayewi Yesuwa sesema:na: inapele esa:, niyewi yesi sitalakeye.” ");
INSERT INTO khs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Au selapita: Yesuyewi wa:ke unuwapo holose, Eyewi matanese, “Ne howa hanosaleke ililakeye,” esa: matanese kulukeye. ");
INSERT INTO khs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yesuwa kulu ikila emiwa Kote koane sao telepeyawa falemi tese keseye kolemi hapakeye. Keseye hanapola: noka pa:ta noka kalilakeye. Apula:, henewana sosolo inise, etewa ene matana pasolose ");
INSERT INTO khs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","sena kesale kulu tuwapo apana etewayewi etapeyawa ene matana kolola hapakeye. Kolola hanose sena kesale muta Kotema matana semetei matanepela: sita:ne kuluwa Koteyewi teisa:pekeye. ");
INSERT INTO khs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sena kesale teisa:pewa Yesuwa mene teisa:penase iwala apana iya:pela: Yelusaleme sitiwemi hanapita: sena kesale mutayewi iwa papokeye. ");
INSERT INTO khs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Aputa: ami senawana iwamo yesilawalapulu Yesu pota: sita:ne amoke potakamake henene inise nano ketea sopoke aputa: potapola: himunama tese selese, “Sena epamowa heneye Kote E Sa:keye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aputa: peleya: kolotea pa kemi kesale muta pota: sita:nekeye. Alake Yesuwa Kalili peleya:wemi silalapita: kesaleyewi Yesu seselakeye. Seselese Yesu Yelusaleme sitiwemi inapita: iwala minakeye. Inisekiwa Yesu napu kemi i kelipapoya papita:, kolotea pa kemi sita:la: papokeye. ");
INSERT INTO khs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Papo kesale amowa unuwa tulawa wekeye. Nowa, Makatala kesalewa Melikeye. Nowa, Meli Yemese Yosepe eli yokeye. Nowa Sepetiyewi e sa:le yokeye. Ili usulupeyawala, kesale nokamokiwala iyawa nano ketea sopowa papokeye. ");
INSERT INTO khs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ka:le oka sinapita: Alamatia sena minakeye. Ene ewa nano ketea sosolo telakeye. Ene unuwa Yosepekeye. Ewa Yesu kulu hanosekeye. ");
INSERT INTO khs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ewa Pailate elakemi hanapola: selese, “Yesu kuluwa neyewi apana tuwapa:na: tiye ha:na:na:wa ililapa?” Au selapita: Pailateyewi ami senama selese, “Yesu kuluwa fake tiye Yosepema kina:pa:.” Aluse selapola: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Selapola: sekepilapita: ta:tapola:, Yesuwa fake tiye Yosepema mikeye. Kinapita: Yosepeyewi Yesu kuluwa sao koiya napoyewi sakolakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sako tiye Yosepeyewi tiye hanapola: ene etewa apana puwano ta:la emiwa, sena nowa puwano eta: tuwatesema, emi Yesuwa tuwapokeye. Tuwapola: apola: apana sulu etapema:na:pela:, etewa sosolo pale kepele tiye hanapola:, apana ulalopo menewemi etapela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aputa: Makatala kesale Meliwala, Meli nowana, apana pawemi hekeya ka:la:lopela:nekeye. ");
INSERT INTO khs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ha:le tesene ikila amowa hetetiyapose piwemi, nano ketea sopoke kekene tiye tiye tikeye. Tiye ti oka itapa tepela: pilisiti sena sosowala, Felesi senawana, Pailate elakemi kekenese selese, ");
INSERT INTO khs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Piseiki, Niyawa nano ketea weyamo matanekeye. Mokopo selesene sena Yesuwa seta: kulumake Eyewi selese, ‘Newa kuluwa ikila usulupe itapa tepela: mene tesima:na:keye,’ au selesapekeye. ");
INSERT INTO khs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Au seyanase ikila usulupe weyemi apanawa heneye etapemita: keyawa solo sekepila:pa:. Aputa: Yesu kulu apana tuwapowa Ene sena ilipe hanosene inapola:, o:sulu atu tiyapola: sena sopoma selese, ‘Yesuwa Koteyewi teisa:pekeye.’ Aluse selesaleke sena sopoyewi ta: tiyaposakeye. Ta:tapola: iyawa mokopo selesene amo mokopo selesene puwanowa sitiye tiyaposakeye. Auma:pekise apana amowa heneye etapela:pa:. Aluse selapola: sekepila:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aputa: Pailateyewi selese, “Sena ta:le tiyewi pota: sita:pesita: hamonama:na:keye. Kiwa hanapola: etewa apeya etapeyawa kiyawa heneye seli etapela:pa:.” ");
INSERT INTO khs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Au selapita: iwa hanapola: etewa apeya etapeyawa koloyetima:pekise yesi sita:nekeye. Aluse yesipela: elape apola: sena ta:le tiyewi pota: sita:pesita: apolowayakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ha:le tesene oka kotetiyapita: tomowemi mo heli ikiwatapita: kiapo Makatala kesale Meliwala, Meli nowana apana potapose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ikila emi ela:pe kipila henene sosolo inise, hepene falemi tese Piseiki Koteyewi hepene senawa inapola: etewa apeya apana isu tenamo etapeyawa kepele tiye hema apola:, etewa wapa:se falemi pota: henekeye. ");
INSERT INTO khs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Saiyakolose ho:lilisene epapuluse hepene sena mitiwa aluse ho:liyakeye. Ene saowa kiniwani heneye koiya epapulakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hepene senawa sena ta:le tiyewi potose sosolo ipilise howa hanose kiwa pipilise kuluwamuna telakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aputa: hepene senayewi kesalema selese, “Kesale ka:ko: ipipa. Neyewi matanekamakiwa ka:tawa Yesuwa iwemi papela: sanose kuluwa potapose keye inatakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yesuwa weyemi ma elatapo. Eyewi Ene selese, ‘Newa mene tesima:na:keye,’ au seyawa kamunakeye. Ewa toma tuwapo itapa telawa potapose ka:ko: mina. ");
INSERT INTO khs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Potapola: iya:pela: Ene sena ilipe hanosema selapose kipila hamona. Hanose weyamu sela:pa:. ‘Yesuwa mene tesikeye. Ewa puwano Kalili peleya: emi hanapola: enewemi, kiwa sikape inise Kalili peleya: emi Ewa potaposakeye.’ Aluse sela:pa:. Alake neyewi ka:ma solo amowa selapose minakeye.” ");
INSERT INTO khs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Au selapita:, kesale a:ko: howa hanose sosolo epelese apanawa iya:pela:, sena ilipe hanosema selapose kipila hapakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hanapita: potapola: ikila emiwa kipila ela:pe Yesuyewi a:ko: ko:luye tise inapola: selese, “Kiapo, ka:ko: hopola sita:latipa:.” Au selapita: a:ko: inapola: kuniu kula:walopela: ka:la:lopela:la: Yesuwa onatuwemi tiye ela: Ewa wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Wapilipita: Yesuyewi selese, “Ka:ko: ipipa. Neyewi Ne ma:e amunama weyamu sela:pa:. ‘Kalili peleya: emi hamona. Peleya: emi Newa potaposakeye.’ Aluse selapose hamona.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kesale a:ko: hapalapita: sena ta:le ti apana pota: sita:newa, sena noka Yelusaleme sitiwemi hanose, nano ketea sopoke alawa pilisiti sena sosoma seyakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Seyawa pilisiti sena sosoyewi Yu sena tililawalapulu ka:la:lopela:la: sowa kekelakeye. Sowa kekelese se tiyapola: sena ta:le tima moweni sosolo kinise selese, ");
INSERT INTO khs_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Sena kesale sopoma weyamu sela:pa:. ‘Nukulapo niwa fayawemi Yesu kuluwa apana tuwapowa Ene sena ilipe hanoseyewi o:sulu tilapokeye.’ Aluse mokopo sela:pa:. ");
INSERT INTO khs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Au selesaleke kamani sena piseikiyewi ta:tese kiwa kotoma:pekise, niyawa kiwa kakasilise, ewa kama:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Au selapita: sena ta:le tiyewi moweni tiyapola: aluse pilisiti sena sosoyewi seyawa iyewi topukeye. Ta:tapola: mokopo seyawa sowa pula tiye apola: selapita:, apula: neyewi puka weyamo momateya ikila emiwana, solo amowa kaluse mokopo selapita: Yu sena kesaleyewi ta:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesuyewi Ene sena ilipe hanosewa Kalili peleya: emi hapakeye. Puwano Yesuyewi selese tokowemi fiyana:pa: eseya emi sena ilipe hanosewa keneneipe fiyanapola:, ");
INSERT INTO khs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yesuwa potose sosolo wapiyakeye. Wapilise kemi iwa nokamoke potose i kene sopolo selese, “Sena epamowa Yesulapa?” Aluse matana elipei tese matanakeye. ");
INSERT INTO khs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aluse matanese iwa sita:newanapulu Yesuwa inapola: selese, “Hepene falamoke matanesene penaiya sopowala, peleya: weyemi matanesene penaiya sopowala, Nema mikeye. ");
INSERT INTO khs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Minase peleya: sopowemi kiwa hanosekiwa sena kesaleyewi Newa kulu hanapita: se tiye kina:pa:. Se tiye kinakamake ta:tiyapitekiwa, ta:ti sena kesale amowa Ni Ata Kote unuwana, Koteyewi E Sa:le Ne unuwana, Ho Napolo unuwana, Niwamo unuwapowa emi palesaleke, sena kesale amowa hawemi to:lusupa:. ");
INSERT INTO khs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Neyawa kima aupa: e seyawa kiyawa imawa se tiye kina:pa:. Neyewi aupa: e seyawa walosene senayewi selesene epapuluse kiyawa sela:pa:. Ta:ta:pa:. Ikila sopoke Newa kiwalapulu elakeye. Ikila itapa tema:na: okemiwana Newa kiwalapulu kokolo elaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kote E Sa:le Yesu Kelesowa matanemita: solo napolo ma:ta: tiwa wekeye. ");
INSERT INTO khs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Puwano fa:nemi Koteyewi selapita: sepatosene sena Aisaiayewi ta:tapola: momateyalakeye. Momateyawa wekeye. “We, ta:ta:pa:. Kewa a hanapose sena nowamoke puwano se tiye miya:na:pela: Neyewi hamonama:na:keye. Sena amokiwa kewa isu ha:na:na:wa seila:taposakeye. Isuwa sosolo hekelesene aluse sena kesaleyewi himu matanawa seila:taposakeye. Iyewi Kewa matanemita: se tiye kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ewa mowa peleya:wemi enene ikila emiwa sena kesaleyewi ta:tapose inapita: eyewi penaiya selese, ‘Piseiki mina:na:wa isu seila:ta:pa:. Isu sosowa koakenananeke heka:ta:pa:,’ au selaposakeye.” Aluse, Koteyewi selapita: puwano fa:nemi Yesu seta: minama ela: Aisaiayewi ta:tapola: momateyalakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Momateya semetei kamona sikape Yone hano toluyetisewa mowa peleya:wemi hanapola: enene epalakeye. Hetetiyapola: ela: sena kesalema selese, “Kili mane olokeyatelawa Koteyewi itapa temita:, mane olokeyatelawa iya:ta:pa:. Iya:pela: Ewalapulu epesena:pela: ke matana notolopita:, kiwa neyewi hano toliyetima:na:keye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Au seya ikila emiwa, Yone enewemi peleya: emiwa Yutia peleya: tesekiwala, Yelusaleme sitiwemi tesekiwala, sena kesale muta minakeye. Inapola: iyewi mane olokeyatela timiyawa hokato selapita: iwa Yoneyewi hano Yotanewemi tolusulakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ikila emiwa Yoneyewi kopolo ka:mo fayewi sao tupiya kapela: kopolo nanikose kaka tekapo kapela:, mapalo amuna napela:, kele hano tikipaselese nasela: enekeye. ");
INSERT INTO khs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ela:, eyewi se tiye kinise, “Newa enewemi sikape Sena Sosolo nowa inaposakeye. Inisekiwa Eyewi newa sitiye tiye hanaposakeye. Ewa hene heneye Sosokeye. Ewa sena sosonase, tima:na: tisene senayewi E tamakawa fakelesene epapuluse, newa kula:pela: inapola: E tamakawa neyewi fakema:na:wa eta: ilimanakeye. Ewa sena sosonase, neyewi ewamopela: tima:na: tisene tima:na:pela: elawala, newa koloteanase, neyewi tiyakamakiwa eta: ilimanakeye. Newa Ewalapulu eta: ilimakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Neyewi kiwa hano semetei toluyetiyakeye. Alawamona Eyewi kili himuwemi Ho Napowa apolowaloposakeye,” aluse Yoneyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ikila emiwa, Yesu Kalili peleya: Nasalete koamesa: emi iya:pela: Yone enewemi minakeye. Inapita:, Yoneyewi Ewa hano Yotanewemi toliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hawemi toliyetipela: hema fiyatela mowa falemi fiyanakamake, meiki fala takalese fatemi, takalese komemi, potakamake Ho Napowa a:nema: tumu amuna meiki falemi tese inapola: Yesu elakemi minakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Inapitekiwa, iyewi potapola: sita:nenase, hepene emi Koteyewi selese, “Kewa, Nine Ni Sa:keye. Kewa Neyewi himu hapa matanepela: sosolo epelekeye.” Au selapita: topukeye. ");
INSERT INTO khs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Au selakamake, ela:pe kipila Ho Napoyewi Yesuma selese, “Kewa mowa peleya:wemi epesena:pela: hamone,” au selapita: Ewa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Hanapola: ikila talo pinipe amowa (40) Yesu mowa peleya: enewemi, Seteneyewi Ewa tikitiya inapita: papokeye. Apula: mowa a:pewalapulu sita:nekeye. Inapita: kemi, hepene senayewi Ewa seselese potapola: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Heloteyewi Yone tipolo selawapola: Yesuwa Kalili peleya: emi hanapola: Kote solo napowa se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Se tiye kina:sela:, “Koteyewi ta:peya ikilawa hetetikeye. Yemiwa Kote Ene Piseikipela: pota: epesene ikila amowa pa telakeye. Alanase kiyewi himu olokeyatelawa iya:pela: Ewalapulu sita:pesena:pela: ke iya:ta:pa:. Kote solo napowa ta:pa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu hano Kalili hawe hanapola: ela: potakamake Saimonewana ene e ma:e A:tuluwala a:tewi ewalo tima:na:pela: hawemi nete tuwata:sela: sitalapita: papokeye. Aputa: a:tewi tima:na: timinisewa ewalo pisinisi timinisekeye. ");
INSERT INTO khs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Alake Yesuyewi a:ma selese, “Newemi kulu ina:pa:. Newemi kulu hapa potosaleke ka:tawa ewalo tisene epapuluse sena kesale Newemi mina:na:wa silimita: Neyewi ka:ko: ta:pelekeye.” ");
INSERT INTO khs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Au selapita: a:ko: netewa ela:pe kipila iya:pela: Yesu ilipe hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kolotea hanapola: Yesuyewi potakamake Sepeti e sa:le Yemese ene e ma:e Yone a:ko: potiwemi sita:la: nete pitia tupiya:sela: sitalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Potapola: a:ko: minite Yesuyewi holakeye. Hopita: eli ina Sepetiwala, e tima:na: tisene senawana, iwa poti kemi sitalapita: iya:pela:, a:ko: Yesuwalapulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesuyewi E sena kulu hanosene Ewalapulu Kapaneame taunewemi hanapola: ha:le tesene ikila emiwa, Yu senayewi kekenesene koane hanapola: Yesuyewi se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Se tiye kinapita: sena kesaleyewi ta:tapola: howa hanose sosolo kete matanakeye. Kote solo ele walosene senayewi se tiye kina epapuluse, senayewi matana sosolo hanosene aluse, Yesuyewi se tiye mimakeye. Sena ununa solo kina aluse se tiye kinapita: ta:tapola:, “Solo amowa eta: fesamoma:na: telamanakeye,” aluse sena kesale sopoke howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aputa:, ikila semetei kemi, Yu senayewi kekenesene koawemi, sena semetei ho olokeyatelayewi ewemi fiyane ela: ");
INSERT INTO khs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Eyewi holose, “Yesu Kewa Nasalete senakeye. Keyewi niwa ho olokeyatelawa ko:luma:na:na? Niwa olokeyale tima:na: minana? Kewa Neyewi potosekeye. Kewa Kote hamona e seyawa Kewa Kote Ene E Sa:nase hene heneye napolo Kewakeye.” ");
INSERT INTO khs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Au selapita:, Yesuyewi ho olokeyatelama selese, “Kewa selapa. Keyewi sena ho tiwa iya:pela: ha:na:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Au selapita: ho olokeyatelawa sena fiyanewa ha:na:na: temekelawa ilima apola:, sena fiyanewa iya:pela: ewa kalose holose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hanapita: potapola: sena kesale sopoke sita:newa howa hanose, i kene sopolo selese, “Amowa ko:lutapa. Solo epe kiniseya solo hililapo. Sena penaiya se tiye kinisene epapuluse se tiye kinatakeye. Eyewi ho olokeyatelawa hamonapita: ho olokeyatelayewi ta: tiyapola: hanatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aluse iyewi sena kesale Kalili peleya: sopowemi ima hanapola:, Yesuyewi nano ketea timiyawa sena kesale sopoma seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yu senayewi kekenesene koawa Yesuyewi Yemese Yonewala iwa iya:pela: hanapola: ela:pe kipila, Saimoneyeli A:nitulu eli koawemi hanapola: musuluyetiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hanapola: iyewi Yesuma kipila selese, “Saimone e ekele e ama toma ofolose nakola ka:pelalakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Alanase kesale nakola ka:pela:la emi Yesu hanapola: kesale amowa tiya:wemi tiyapola: ewa tesa:pela: toma ofolawa itapakeye. Itapa tepita: kesale amoke iwamopelekiwa nano ma:na: satapola: mikeye. ");
INSERT INTO khs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aputa: kolotea tepela: opo sinapita: sena kesale sopoke nakola telawala, sena kesale sopoke ho olokeyatela fiyanewala, Yesu elakemi siliye minakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Siliye inapita: sena kesale muta taune sita:newa Saimone koane isu tenamowemi kekene tiye yesipela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesuyewi sena kesale muta nakola towaya kalikalilawa fala:wayakeye. Ho olokeyatela muta iya:pela: hamonapita: hapakeye. Ho olokeyatela Yesuwa matananase, Yesuyewi ima selese, “Kiyewi selapa,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kiapowemi ikima:na: pa tepita: Yesu tesile hanapola:, mowa peleya:wemi senanama emi kulukululakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kulukuluma:na:pela: hapalapita: Saimonewana, e sena manawana, iyewi Yesu kelema:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Hanapola: iyewi Yesuwa keyalapepela: potapola: selese, “Kewa sena sopoke kelekeye.” ");
INSERT INTO khs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Au selapita: ima Yesuyewi selese, “Koamesa: nokala Newa hanakeye. Hanapola: koane Neyewi Kote sowa se tiye miya:na:keye. Alake Kote sowa se tiye miya:na:pela: Newa mou amowa peleya: sosolo weyemi minakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ewa Kalili peleya: koamesa: sopowemi sila:sela: enekeye. Sila:sela: ela: Yu senayewi kekenesene koane se tiye miya:na:pela: hanapola:, Yu senayewi kekenesene koane nowana se tiye miya:na:pela: hanapola:, Yu senayewi kekenesene koane nowana, se tiye miya:na:pela: hanapola: epapulakeye. Apula:, ho olokeyatelawala Yesuyewi hamonapita: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yesu elakemi sena waka:pila telawa minakeye. “Yesu unuwa Sosokeye,” aluse matanepela: ewa kuniu kula:pela: hela: penaiya selese, “Keyewi newa fala:pa:na:wa epelepa?” ");
INSERT INTO khs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Au selapita: senawa Yesuyewi hauwekilise E tiya:wa tili tiye ewa kesalese selese, “Henekeye, Newa epelekeye. Ke nakola telawa fala:pa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Au selakamake sena waka:pilawa ela:pe kipila kotetikeye. ");
INSERT INTO khs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Itapa tese ewa iliye tiye elapita: potapola: Yesuyewi sena ama wa:ke penanose selese, “Kewa hamona. ");
INSERT INTO khs_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kewa waka:pila fala:pewa sena kesale nokamawa selapa. Alawamona, pilisiti sena elakemi kewa hanapola:, toma waka:pila fala:pewa pilisiti senama walopa:. Walopela: Moseseyewi solo elewa kulu hanose nano ketea mokopo Kotema kina:pa: e seyawa ko:luse kina:pa:. Au tima:na:pela:, sena kesale sopoke ta:tapola: matanepesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Alawamona, selapita: kemi, sena waka:pila itapa telayewi ta:ta: iya:pela: hanapola: sena kesale sopoma seyakeye. Selapola: hekelese sena kesale sopoke topukeye. Alanase, Yesu taune sopowemi hokato eta: hapamakeye. Yesuwa mowa enekeye. Moawemi elapita: sena kesale muta inise, nono nokemiwana, nono komemiwana, nono fa:nemiwana, nono kolemi tesekiwala, sena kesale muta Yesu elakemi minakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ikila mutama tepela:, Yesu Kapaneame taunewemi mene minakeye. Yesuwa meneye tiye inapita: sena kesale sopoke topukeye. ");
INSERT INTO khs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ta:tapola:, sena kesale muta inapola: kekenepela: koane woliyetikeye. Koane woliyetiyapita:, isu tenamowemi yesipela: elapita:, Yesu koane sulu honosane ela:, sena kesalema solo napowa se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Se tiye kina:sela: elapita: sena pinipe sena sosowane tela somusowala selawapola:, tiye inapola: ");
INSERT INTO khs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","potakamake, sena kesale muta kekenawemi, Yesu elakemi eta: ha:na: telama, sena sosowane tela tiyapola: koane tomo falemi tiye fiyanapola:, Yesu Ewa elakemi pisei wapa:se emi koane tomo pukuyetiye, koane tomo emi somusowala halute kikiye sine kikiye sine, tise Yesu enewemi tuwapokeye. ");
INSERT INTO khs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tuwatapita:, sena sosowane tela tiyapola: mina sena pinipeyewi Yesuma himu semetei matanewa potapola:, Yesuyewi sena sosowane telama selese, “Ni sa:le, Ke olokeyatelawa Neyewi iya:takeye.” ");
INSERT INTO khs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Au selapita: Kote solo elewa walosene sena noka emi ka:la:yawamoke i kene sopolo matanese, ");
INSERT INTO khs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Kote semeteiyewi Ene ela: sena olokeyatelawa iya:tesekeye. Senayewi eta: iya:tesemakeye. Aluse Yesuyewi Kotewa kolotea me apolatakeye. Eyewi aluse seyawa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aluse iyewi matanepita:, ela:pe kipila ili matana amunuse Yesuyewi potapola: ima selese, “Kiyewi ko:lupita: Newa itipilise ela:? ");
INSERT INTO khs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Sena sosowane telama Neyewi selese, ‘Ke olokeyatelawa Neyewi iya:takeye,’ e selapita: mahokokeye. Olokeyatela itapa tesewala, seta: iya:peyamawana, kiyewi eta: potesemakeye. Alawamona Neyewi selese, ‘Ke nakola tiwa Neyewi itapa tekeye,’ e selapita: hokokeye. Sena sosowane tela tesitiye hanaka kiyawa potakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sena Sa:wa Nekeye. Peleya: weyemi sena kesale olokeyatelawa Neyewi itapa temita:, Kote Ene Nema aupa: seyakeye. Aupa: e seyanase semetei kamunuse Neyewi tiye, kiyawa popita: sena sosowane telama Neyewi tesima e selakeye.” Aluse Yesuyewi sena sosowane telama selese, ");
INSERT INTO khs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tesima, keatawa sasekeya kine koane tiye ha:na:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Au selapita: sena amowa tesile e keatawa ela:pe kipila kopo tiyapola: hapakeye. Tiye hanapita: sena kesale sopoke potapola: himunama tese, Kotema wapilise selese, “Puwano nano ketea epapulawa niyawa eta: papomakeye. Napu nano ketea kalilapo,” aluse iyewi sopoke seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu hano ka:na enene emi wa:ke hanapola: hano hawe ela: potakamake, sena kesale muta kekenepita:, Yesuyewi ima se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Se tiye kinapola: kotetipela: hanapola: Yesuyewi potakamake, Afiase e sa:le Lifai amowa ewa takese tisene opose koane helapita: papokeye. Potapola: selese, “Kewa Newemi kulu mina.” Au selapita: Lifai tesile Yesuwalapulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hanapola: Lifai koawemi hanapola:, koane suwemi musuluyetiye Yesuwala, e sena ilipe hanosewana, ka:la:lopela:la: iwalapulu sena olokeyatelawala, takese tisene senawana, iwa sopoke muta Ewa kulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kulu hanapola: hapa sena amowa noka sena olokeyatelawala, takese tisene senawana, iwa Yesuwalapulu ka:la:lopela:la: ma:na: napita:, Felesi senayewi ilipe solo elewa walosene sena papokeye. Potapola: iyewi Yesuwa sena ilipe hanosema selese, “Takese tisene senawana sena olokeyatelawala Yesu ilipe ka:la:lopela:la: ma:na: epe naseya heneye olokeyatelalakeye. Ko:luse epe timiniseya?” ");
INSERT INTO khs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Au selapita:, Yesuyewi ta:tapola: ima selese, “Sena napolo enewa mitikoloyawa fala:pita: eta: hanosemakeye. Alawamona, sena nakolawa mitikoloyawa fala:pita: hanosekeye. Alanase sena kesaleyewi himu olokeyatela sita:newa, ili olokeyatelawa iya:pela: sita:pesena:pela: temita:, ima mina e semita: Newa minakeye. Sena napolo mina e semita: Newa eta: minamakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ikila nowemi Yone hano toluyetiseyewi e sena ilipe hanoseyawana, Felesi senayawala, ma:na: nasene ala:pela: sita:nekeye. Ala:pela: sitala ikila emiwa sena nokamoke inapela: Yesuma ta:potose, “Ke sena kilipe hanoseyewi ma:na: nasene eta: ala:pemawa ko:luselala? Yoneyewi e sena ilipe hanoseyewi ma:na: nasene ala:tesekeye. Felesi sena ili sena ilipe hanoseyewi ma:na: nasene ala:tesekeye. Alawamona Ke sena kilipe hanoseyewi ma:na: nasene eta: ala: tesemakeye.” ");
INSERT INTO khs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Au selapita: Yesuyewi pale selese, “Senayewi kesale tisaleke, sena kesale sopoke tikinise epelese ma:na: nasekeye. Ma:na: na:sela: sena kesale hili e ko:lu iwalapulu elipe elapita:, ili himu eta: mapoyamake iwa epelese sita:la:, ma:na: ma:na:wa eta: ala: tesemakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Alawamona sena kesale hili e ko:lu sena nokamoke sukulu tiye epapuluse ikila emiwa, himu mapolose ma:na: ma:na:wa ala:taposakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aputa: sao pusomiya keseyawemi sao hili palese tupiyawa, sao hiwa akopolose sao pusomiyawa hema nokemi tese keseleye tisekeye. Keselese sosolo pitilila hanaposakeye. Auma:pekise sao pusomiyawanapulu sao hiwalapulu papela: eta: tupulusemakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Apula: a:pele kapo senayewi tiyapola: potolo amuna aluse tupulusekeye. Waine hano hili tikipaseyawa a:pele kapo pusomiyawemiwa eta: susalesemakeye. Susapitekiwa waine hano hiwa telise a:pele kapo pusomiyawa hotolosekeye. Hotolose a:pele kapo palalese waine hawa sukamenepesakeye. Sukamenese waine hawana, wa:tesewana, elipe itapa tepesakeye. Apula: waine hano hili tikipaseyawa a:pele kapo hiwemi wa:tesaleke, a:pele kapo eta: hotolosemakeye.” ");
INSERT INTO khs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ha:le tesene ikila semetei nowa, witi alekenawemi Yesuwala, E sena ilipe hanosewana iwa hapakeye. Hanosekiwa sena ilipe hanoseyewi witi fo kene su tiye menakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Napita: Felesi senayewi potosekiwa Yesuma selese, “Kine ke sena ilipe hanoseyewi ma:na: sutuseya tima:na: tiyaka pota:pa:. Iyewi tima:na: epe tiseya ha:le tesene okemi ala:pekeye. Ala:pela: hotolosewa ko:luma:na: esena?” ");
INSERT INTO khs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Au selapita: potapola:, Yesuyewi ili hele matanawa waloma:na:pela:, Tepitiwa Kote pukawemi momateyawa ima selese, “Puwano fa:nemi pilisiti sena sosolo e unuwa Apiata, ewa elakemiwa ikila emiwa, Tepitiwala e sena ilipe hanosewana meinakeye. Menise ikila emiwa, Tepiti ene Kote koawemi musuluyetiye potakamake, Kotepela: falawa tiye tiwa Apiatayewi kinapita: Tepitiyewi na:sela:, e sena ilipe hanosemawana, falawa tiye tiwa mikeye. Miwa Kotepela: falawa tiye tiwa sena kesale iyewi ma:pekise ala:pe tuwapokeye. Pilisiti sena ilipe ma:na: nasewa eta: ala:pemakeye. Alawamona, Tepiti e pilisiti senama tela amoke falawa ala:pewa menakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aputa: sena sesemita: ha:le tesene ikilawa Koteyewi apoyakeye. Ha:le tesene ikilawa sela:pa:na: epela: senawa eta: alusemakeye. ");
INSERT INTO khs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sena Sa:wa Nekeye. Ikila ha:le tesene ikila emiwa nano ketea alusene amowa Newa Piseikipela: elakeye.” Aluse Yesuyewi Felesi senama seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Me wa:ke Yu senayewi kekenesene koawemi Yesu musuluyetiye potakamake, sena tiya:le kete tela elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Apula: ha:le tesene ikila emiwa sena tiya:le kete tela Yesuyewi itapa tema:pekitise, Felesi senayewi potapola: sita:nekeye. Ha:le tesene ikila emiwa Yesuyewi timinisaleke potapola: kotoma:na:pela:, pota: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pote sitalapita:, Yesuyewi sena tiya:le kete tela ema selese, “Kewa inapola: honosane weyemi sena kesale sikapowemi ke epesa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Au seya Eyewi Felesi senama ta:potose, “Ha:le tesene ikila emiwa napolo timinisewalo, olokeyatela timinisewalo, nano ketea tisene nokaiyamoke Kote sowa hotolape? Sena nowa kuma:pekitise seselesewana, sena nowa sanosewana, nano ketea nokaiyamoke Kote sowa hotolape?” Au selapita:, iyewi wa:ke eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sowa eta: seyamake potapola:, Yesuyewi konomonose iwa seli pote hanosekeye. Potakamake ili himuyewi matanema:na mapolose potapola: Yesuyewi iwalapulu himu sosolo nakolakeye. Alanase Eyewi sena tiya:le kete tela ema selese, “Ke tiya:le tili tiye salo hekema.” Au selapita: tiya:le salo hekelese kete telawa itapakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sena amowa tiya:le kete telawa itapa tepita: potapola:, Felesi senawa Yu senayewi kekenesene koawa iya:pela: hanapola:, ela:pe kipila Kini Helote e sena ilipe sopolo i kene selese, “Yesuwa kumita: niyewi sama:na:keye. Niyewi noko:lu sama:na:napa?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu E sena ilipe hanosewana hanapola:, hano ka:na enene emiwa hapakeye. Hanapita: iwalapulu sena kesale muta pote hanose hapakeye. Hanapola: Kalili peleya: tesekiwala, Yutia peleya: tesekiwala, ");
INSERT INTO khs_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yelusaleme sitiwemi tesekiwala, Itumea peleya: tesekiwala, hano Yotane satepela: peleya: nokemi tesekiwala, Saitone taune tesekiwala, Taia taune tesekiwala, sena kesale mutayewi ta:takamake Yesuyewi sena kesale nakolawa fala:wayapita: ta:tapola:, Ewamo elakemi minakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Sena kesale minawa Ewa muta nakola towayawa Yesuyewi fala:wayakeye. Fala:tapita: potapola: sena kesale nakola towaya sopoke Yesu tomawemi saliyapose minakeye. Inapola: e tomawemi iyewi sopoke saliyapita: potapola: Yesuyewi e sena ilipe hanosema selese, “Sena kesale muta ina:sela: woliyetikeye. Alake Newa potiwemi helema:na:keye. Potiwa hano hema meiyewi koma:pema,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aputa: sena kesale suwemi ho olokeyatela elakamokiwa Yesuwa potosene kemi Yesu sikapowemi sutesinapola: telapita: holose, “Kewa Kote E Sa:keye.” ");
INSERT INTO khs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Alawamona Yesuyewi ho olokeyatelama selese, “Sena kesale sopoke ta:pa:pekitise Newa Kote E Sa:keye, au selapa.” Aluse Yesuyewi penaiya seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu tokowemi hanosekiwa, Yesuyewi E sena epeya sopowa mina e seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mina selapita: potapola:, sena kukuluipe ta:peyakeye. Ta:peyawa iwa walosene senakeye, au seyakeye. Ta:peyawa Ewalapulu ilipe ha:na:na:nase ta:pele tiyapola:, apula: E sowa se tiye miya:na:pela: ta:pele tiyapola:, ");
INSERT INTO khs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","apula: ho olokeyatelawa iya:pela: hamone au sema:na:pela: ta:pele tiyapola: aluse timita: ima penaiyawa mikeye. ");
INSERT INTO khs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aputa: sena kukuluipe ta:peyawa wekeye. Saimone e unu nowa Pita, esa: Yesuyewi unuwapokeye. ");
INSERT INTO khs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Apula: nowa Sepeti e sa:le Yemese, apula: nowa Yemese e ma:ewa Yone elipei amowa Poanesi, esa: Yesuyewi unuwapokeye. Iyawa Poanesi unuwapo mouwa hene solopela:la: Kunu e sa:le aluse unuwapokeye. ");
INSERT INTO khs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Apula: nowa A:nitulu, apula: nowa Filipi, apula: nowa Patalomiu, apula: nowa Ma:tiu, apula: nowa Tomase, apula: nowa Afiase e sa:le Yemese, apula: nowa Tatiase, apula: nowa Lome kamaniyewi Yu sena pota: enewa iya:pa:na:pela: matanesene sena Saimone, ");
INSERT INTO khs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","apula: nowa Yesu sihelelema:na: sena Yutase Isekeleote, aluse Yesuyewi sena kukuluipe ta:peyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ta:pele tiye kotetipela:, Yesu Ene koawemi hapakeye. Me wa:ke Yesu enewemi sena kesale muta kekenepela: sosolo ikila sopoke Yesuyewi tima:na: timinise ela:, Ewalapulu E sena ilipe hanoseyawana, iyewi ma:na: eta: menamakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma:na: eta: menama, Yesu E sena maya topukeye. Yesu matakola, au seyanase iyewi Yesu silima:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aputa: Kote solo elewa walosene sena Yelusaleme siti emi inapola: iyewi selese, “Ho olokeyatela piseiki unuwa Piaosipu, Yesu ho tiyapola:, Ewa Yesuwalapulu enenase, Piaosipuyewi penaiyawa Yesuyewi tiyapola: ho olokeyatelawa hamonapita: hanatakeye.” ");
INSERT INTO khs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Au selapita: Yesuyewi ima selese, “Kiwa sopoke mina.” Aluse inapita: potapola: Yesuyewi ima pale selese, “Seteneyewi ene kemi tima:na: tisene senawa ko:lu hamona elala? ");
INSERT INTO khs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sena ilipe peleya: semetei sita:ne kemi takalese tetesaleke sena amowa kene tiye walose kalikalila kalikalila sita:la: koane senanama tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Apula: sena i semetei ilipe takalese tetese keneye tiyapita: itapa tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Alusene epapuluse Seteneyewi ho olokeyatelama hamona e selesaleke, ene e mana elipe tetesene aluse tepapekeye. Seteneyewi e sena manama takalese tetesene e selesaleke, iwa keneye tiyapita: itapa tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Aputa: sena nowamoke sena penaiya koawemi nano ketea atu tima:na:pela:, puwano sena penaiyawa meiyewi sako tiyapola: tuwapola:, e koane musuluyetiye nano ketea atu tisekeye. Sena penaiyawa seta: tapoyama ela:, ewa ke ela: penaiya elapita: potapola: e koane atu tima:na:pela: musuluyetiye eta: hanosemakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Alake Neyewi kima heneye selakeye. Sena kesaleyewi kalikalila olokeyatelawa timinisekeye. Olokeyatela tisewana, Kotewa kolotea meapolose selesewana, Koteyewi iya:taposakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Alawamona Ho Napowa sena kesaleyewi kolotea meapolosaleke, yemiwana, sikapewala, Koteyewi heneye maiya:taposakeye. Sena kesaleyewi Ho Napowa kolotea meapolose seyanase, mane olokeyatelawa iwalapulu kokolo kao elaposakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Aluse iyewi selese, “Ho olokeyatelayewi Yesu ho tinase Yesuyewi penanose tiyatakeye.” Au seya amopela: Yesuyewi ima aluse seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yesuyewi E amawana, E ma:ewana minakeye. Inapola: peleya: pakiawemi sita:la: selese, “Yesu ina:pa: sela:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aputa: sena kesale muta Yesuwalapulu kekenepela: ka:la:yawamoke Yesuma selese, “Kine ke amawana, kine ke ma:ewana, kine ke atewala, peleya: pakia kolemi sita:la:, Kewa ina:pa: e selakeye.” ");
INSERT INTO khs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Au selapita: Yesuyewi selese, “Ni amawana, Ne ma:ewana, henewa ta:ta:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Au seya, sena kesale sita:newa Yesuyewi seli potose selese, “Ni ama amunawana Ne ma:e amunawana kiwakeye. ");
INSERT INTO khs_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Alake senayawala, kesaleyawala, Kote matanawa kulu hanose timinisaleke sena kesale amowa Ne ma:e Ne ate Ni ama epapulakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu hano hemawemi wa:ke inapola: ima se tiye mikeye. Se tiye kina:sela: ela: potakamake sena kesale muta kekenepitekiwa potapola:, Ewa tesile hanapola: potiwa hawemi toliyetipela: enewemi Ewa potiwemi tapela:, sena kesale hano hawe sita:nema se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Solo muta pale se tiye mikeye. Iyewi matanemita: selese, ");
INSERT INTO khs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“We, ta:ta:pa:. Senayewi nakela sa:le fipila hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Fipila hanose hapawa ikila emiwa nakela sa:le noka isu kiwemi sululuwayakeye. Sululuwayawa a:nema:yewi menakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Apula: nakela sa:le noka etewa wapa:kemi peleya: koloteawemi sululuwayawa kipila sopola kamona, sepe napolo eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sepe seli eta: hapamanase otowi sanose ofolose kulapitekiwa onose olo tikeye. ");
INSERT INTO khs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Apula: nakela sa:le noka nakela sa:le ona sitala olapowemi sululuwayakeye. Sululuwayawa nakela sa:le ona sitala alapulu semetei fiyanekeye. Fiyanese nakela sa:le ona enewa sololose, nakela e sa:wa foluse eleletese fo eta: heyamakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Apula: nakela sa:le noka peleya: napowemi sululuwayawa sopopela: fo heyakeye. Fowa helese, noka fowa talo usulupe (30) heya, noka fowa talo tekapeipe (60) heya, noka fowa sakopolo semetei (100) epapuluse heyakeye.” ");
INSERT INTO khs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Au seyawa, Yesuyewi selese, “Kiwa kena: tela:yawa ta:tapola: seli ta:ta:pa:. Ta:tapola: matanepa:.” Aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sena kesale muta hanapola: itapalapita: sena mutama Yesuwalapulu sita:la:, sena kukuluipe puwano ta:peyawa Yesuwalapulu sita:la: iyewi Yesuma selese, “Pale seya mouwa enana?” ");
INSERT INTO khs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Au selapita: Yesuyewi ima selese, “Kiwa ta:pita: Kote Piseiki solo mupapowa napu yemi solo mouwa kima hokatolose selakeye. Alawamona Neyewi eta: ta:peyama sena kesale ama pale seya sopolo selakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kote pukawemi momatelese aupesakeye, e seya emiwa mouwa sepatosene senayewi heneye momateyalakeye. Momateyawa wekeye. ‘Sena kesaleyewi siyewi potapola: potaposakeye. Papo kamona mouwa seli eta: matanesemakeye. Ili kena:yewi ta:tapola: ta:taposakeye. Topu kamona mouwa seli eta: matanesemakeye. Ili himuyewi seli eta: matanamanase mapolose sita: tesekeye. Aluse ili himu olokeyatelawa iya:pela: Kotewalapulu elapose iya:peyakiwa, Koteyewi ili olokeyatelawa itapa temapekeye.’ Aluse, sepatosene sena Aisaiayewi momateyalakeye.” Aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu E sena ilipe hanosema selese, “Kiyewi pale seya weyamo mata:teseya? Pale seya weyamowa eta: matanamananeke kiyewi pale seya sopoke noko:lu mouwa matanema:na:na? ");
INSERT INTO khs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","We, ta:ta:pa:. Nakela sa:le fipila hanose hanosene sena amunawa, Kote solo walosene sena akeye. Nakela sa:le amunawa, Kote sokeye. ");
INSERT INTO khs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nakela sa:le isu kiwemi sululuwaya elawamona, sena isu kiwemi hema sita:neyawa Kote sowa se tiye miwa ta:potapita:, Setene fo kipila inapola: solo amowa atu tisekeye. ");
INSERT INTO khs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Apula: etewa wapa:kemi sululuwaya telawamona wekeye. Senayewi Kote sowa ta:tapola: fo kipila solo amowa epelese ta:tapola: matanesekeye. ");
INSERT INTO khs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Alawamona, sepe seli eta: hanosema epapuluse seli ta: tiyapola: eta: tesemakeye. Nano ketea olokeyatela hetetiyapitekiwala, Kote solo ta: ti sena amawa ikomonosalekiwala, Kote sowa ikila kolotea topu kamona, kipila iya:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Apula: nakela sa:le ona sita:ne olapowemi nakela sa:le sululuwaya amuna wekeye. Senayewi Kote sowa ta:tapola: kemi ");
INSERT INTO khs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","peleya: weyemi nano ketea sosolo matanesewana, moweni sosolo tima:na:pela: epelese matanesewana, peleya: weyemi nano ketea amowa tima:na:pela: sosolo matanesewana, nano usulupe amowa Kote sowa foluse fo seli eta: helesemakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Alawamona peleya: napowemi sululuwaya amunawa wekeye. Senayewi Kote sowa ta:tapola: heneye ta: tiyapola: sitalapita:, fowa helesene epapuluse helepesakeye. Fowa helesewa noka talo usulupe (30), noka talo tekapeipe (60), noka sakopolo semetei (100) aluse fowa supita: sosolo helepesakeye.” Aluse Yesuyewi pale seya amowa mouwa seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesuyewi E sena ilipe hanosema selese, “Napa tupa:tapola: tuwapola: paketeyewi fopulusena? Napawa koane enisene wa:ta hanewa tuwatesena? Eh, napa tupa:tapola: koane hokato telepela:pa:. ");
INSERT INTO khs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Alusene epapuluse Kote solo fopiyawa hokatopesakeye. Nano ketea mupapowa matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kiwa kena: tela:yawa ta:tapola:, seli ta:ta:pa:. ");
INSERT INTO khs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne sowa seli ta:tapola: matanepa:. Kiyewi nano ketea kinisene epapuluse kima kinaposakeye. Nano ketea nowana papela: apola: kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Alusene epapuluse kiyewi Ne sowa seli matanema:na:wa, mouwa keye hanapola: matanesaleke, solo nowa mouwala matanemita: Koteyewi kewa sesepesakeye. Alawamona Ne sowa seli kelese eta: matanamanase, puwano nano ketea topuwala iya:taposakeye.” Aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesuyewi selese, “Sena kesaleyewi Kotewa matanemita: Koteyewi iwa Piseikipela: pota: tesekeye. Potapola: tesene amunawa wekeye. Senayewi nakela sa:le fipipela: apola:, ");
INSERT INTO khs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","koane hanapola: nukulapo eniyapola: kiapo ikiwatapita: mene tesile hanapola:, ikila sopoke aluse elaleke nakela sa:le fipilawa fiyatepesakeye. Ikiwapowala nukulapowala fiyatepesakeye. ‘Ko:luse sopopela: helepesape?’ Aluse sena amokiwa tikili tese, ");
INSERT INTO khs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","apula: nakela sa:le ene matanese peleya: emi sopopela: fiyatela, puwano pulu fiya tepela:, amo honosane pisei hetetipela:, amo sikape fo hene ma:na:wa ka:la:losekeye. ");
INSERT INTO khs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Fo hene ma:na:wa kene penaiyalapita:, senayewi sutusekeye. Ko:lupita: sutesina? Hene nasene ikila emi hetetisaleko, sutusekeye.” Aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesuyewi selese, “Kote Piseikipela: pota: enewa nano ena papola? Kiyewi matanemita: pale sema:na:wa ena semita: eseya? ");
INSERT INTO khs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Koteyewi sena kesale Piseikipela: pota: ela amunawa wekeye. I maseta fo senayewi e alekenawemi fipila epapulakeye. Maseta fo amowa hene heneye koloteakeye. Fo nowa kolotea epapuluse eta: alusemakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Maseta fo heneye kolotea kamoke, sopopela: fiyanese alekenawemi nakela kelawa sitiyetiye iwa amuna sosolo tesekeye. Sosolo tese enewemi i elewa emi a:nema: sila:sela: sitalaka inapola: a:nema:yewi aiwa tisekeye.” Aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesuyewi E sowa sena kesaleyewi matanemita: Eyewi pale seyawa muta epapuluse se tiye mikeye. Se tiye miwa iyewi ili ta:potapita:, solo pale seya epapuluse se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sena kesale sopoma Eyewi pale selese semetei seyakeye. Alawamona E sena ilipe hanosene i kene semetei sita:la: solo mouwa hokato seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ikila semetei kemi ka:le mowa nukulukemi, Yesuyewi E sena ilipe hanosema selese, “Niwa hano Kalili nono fa:nemi hanakeye.” ");
INSERT INTO khs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aputa: sena sopoke kekenawa iya:pela:, Yesu potiwemi elapita:, iwala poti kemi tapela: hapakeye. Potiwa nowana sena nokamoke kolo tiye ilipe hanapita: potapola: ");
INSERT INTO khs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yesu potiwa kena hela: pisei piatopola: enikeye. Enilapita: hawa inapola: alokala, hano ko:luwalapulu sosolo minakeye. Hano ko:lu sosolo inise, potiwa suwemi hano kalotiye selalese, potiwa mutule sima:na: telakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mutule sima:na: tepita: potapola:, sena ilipe hanoseyewi Yesu kila:tese selese, “Walosene sena, niwa hawa nase kuma:na: telalakeye. Keyewi niwa matanepa?” ");
INSERT INTO khs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Alanase Yesu mene tesi tiye hanapola: alopomawana, hano ko:lumawana selese, “Itapa tema. Hopola tema.” Au selapita: alokala, hano ko:lu sosolo minawana itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Itapa tepita: potapola: Yesuyewi ima selese, “Kiwa ko:lupita: ipiliseya:? Kiwa Newemi heneye himu semetei esa: eta: matanamanakeye.” ");
INSERT INTO khs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Aputa: iwa howa hanose i kene kemi selese, “Yesu sowa alotawala, hano ko:luyawala, ta:tapola: itapa tetakeye. Aluse epe timiniseya Ewa sena ipa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aputa:, iyewi hano Kalili ka:na enene potiwa kolo tiye ha:na: polopela:, Kelasini peleya: emi potiwa papela:, ");
INSERT INTO khs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Potiwa koma:pela:, iwa mowa palopela: potakamake, ho olokeyatelayewi sena suwemi fiyane Yesu koluma:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Sena epamowa sena kulu tiye tisene apana emi ela:, ewa sena nokamoke sakolawala eta: ilimakeye. Ewa temekelese seiniyawana tapowala eta: ilimakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Puwano ikila muta sena ho tiwa seiniyewi e tiya:wala onatuwala tapokeye. Tapapola:, ewa penaiya penanose kenekeye tikeye. Kenekeye tipela: senayewi ewa tima:na:pela: elawala, e penaiyawa eta: ilimakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nukulapowemiwana, ikilalewemiwala, ewa apanawemi ela:, tokowemi fiyanapola: mokopo hola: sila:sela: enekeye. E tomawemi etewayewi sanose nanesekeye. ");
INSERT INTO khs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pama emi ela: eyewi Yesuwa potosekiwa kipila Yesu elakemi inapola: kuniu kula:pela: Yesu minitapowemi heyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Helapita: potapola: Yesuyewi ho olokeyatelama selese, “Kewa ho olokeyatelakeye. Kewa sena epamowa iya:pela: hamona,” au seyakeye. Au selapita: ho olokeyatelayewi sena ho fiyane sulu fa:nemi ela: unuwapo holose selese, “Yesu, Kewa hene heneye Piseiki Kote falamo E Sa:lo, Keyawa newa ko:luma:na:na? Keyawa Kote unuwemi newa falasise oiyawa kokolo kao tesewa kinapa.” ");
INSERT INTO khs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Au selapita: Yesuyewi ema selese, “Ke unuwa ipa:?” Aputa: ho olokeyatelayewi selese, “Ne unuwa Amikeye. Koiyawemiye, niwa ilimakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Peleya: we iya:pa:na:wa mapolokeye. Peleya: we iya:pela: hamona e selapa.” ");
INSERT INTO khs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Au seya iyewi potakamake kopolo muta tokomo kikiliwemi ma:na: napita: potose Yesuma penanose selese, ");
INSERT INTO khs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","“Keyawa niwa hamona sewa kopolo amowa suwemi sita:pesita: hamonoma.” ");
INSERT INTO khs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Au selapita: Yesuyewi selese, “Henekeye. Aupa:.” Aputa: ho olokeyatelayewi sena ho fiyane iya:pela: hanapola: kopolo suwemi fiyanekeye. Fiyanapita: kopolo sopoke taosene elipei amowa (2,000) tokomo akola naiya emi kipila sine inapola:, hano naiyawemi sululuwalose, hano honosane sutesinise kopolo sopoke hano katolose ya:takeye. ");
INSERT INTO khs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ya:telapita: potapola:, kopolo pota: towaya sena amowa nesile koawemi hanapola:, koane sita:ne senamawana, mowa sita:ne senamawana selese, nano ketea sopoke papowa seyakeye. Selapita: sena kesale sopoke nano ketea alawa potapose minakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Inapola: Yesu elakemi potakamake, sena ho olokeyatela mutalo fa:nemi fiyanewa, seli ela: sao kapela: napolo matanepela: elapita: papokeye. Potapola: ipilakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Papo sena amowa sena ho olokeyatela ho fiyane itapa telawala, kopolo ya:te telala, sena kesale nowama nano ketea sopoke papowa seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Selapita: sena kesale sopoke Yesuma penanose selese, “Nini peleya: we iya:pela:, Kewa hamone.” ");
INSERT INTO khs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Au selapita: Yesu potiwemi tapela: ha:na:na:pela: elapita:, sena ho fiyane fala:peyewi Ema selese, “Newa Kewalapulu na:nipe ha:na:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Alawamona, Yesuyewi eta: auma:na:ma e seyakeye. Au selapita: Eyewi selese, “Ke koane mene hanapola:, kine sena ke manama Piseikiyewi kewa sesewapowa sela:pa:. Piseikiyewi kewa hauwekilise matanepela: sesewapowa sela:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aputa: sena epamowa mene hanapola:, koamesa: taloipe unuwa Teka:polisi emi selese, “Yesuyewi newa weyamu seselakeye.” Au selapita: sena kesale sopoke howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu potiwemi tapela: hanose hano Kalili ka:na enene nono fa:nemi mene hanose potakamake, sena kesale muta kekenepela: sitalapita: potapola: Yesu hano hema enekeye. ");
INSERT INTO khs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ela: potakamake Yu senayewi kekenesene koane pota: tesene sena amowa inapola:, e unuwa Yailasekeye. Ewa inapola: Yesu potapola: kuniu kula:pela: hela: eyewi penanose ");
INSERT INTO khs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yesuma selese, “Ne la:le kuma:na: pa elakeye. Alanase Ke tiya:yewi ewa kesapa:se mina. Kesalesaleke e nakola telawa itapa tepela: ewa makulaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Alanase Yesu ewalapulu elipe hapakeye. A:ko:la sena kesale muta ilipe kuluwapola: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kuluwapola: hanapita:, kesale nowa fa:se tapo emi inapola:, ewa yapene kukuluipe hesana kokolo a ha:na:sela: henekeye. ");
INSERT INTO khs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ikila mutawemi mitikolo sena nokamoke timinisewalo kesale amowa ewa eta: itapa telamakeye. Eyewi moweni sopoke mitikolo senama kinapola:, amunawana seta: itapa telama e nakolawa sosolo telakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nakola sosolo tepela: ela:, Yesuyewi sena kesale nakola towaya itapa tekeye e selapita: ta:tapola:, kesaleyewi e himuyewi matanese, “Yesu sawemi neyewi kesakamake, newa hesana kokolo a ha:na:sela: hela: fala:pesakeye.” Aluse matanepela: Yesu fa:se tapo emi ine E sawemi kesalakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kesakamake ela:pe kipila ewa hesana kokolo a ha:na:sela: hela: fala:pekeye. Itapa tepita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aputa: Yesu Ewa tikila:pela: hanapola: ela: ta:takamake, ela:pe kipila E penaiyawa hanapita: papokeye. Potapola: Ewa mene potose, sena kesale sopoma selese, “Ne sawa eta: kesalala?” ");
INSERT INTO khs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Au selapita: E sena ilipe hanoseyewi selese, “Alamakeye. Sena kesale mutawemi Kewa kolu potaposape? Iyewi Ke tomawemi kesalese hapalakeye. Sawemi kesalawa ko:lupita: e seleseye?” ");
INSERT INTO khs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Alawamona, Yesuyewi mene potose E sawemi eta:wi eta: kesalale esa: popa:na:pela: potakamake, ");
INSERT INTO khs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","kesale amowa ewa hesana kokolo a ha:na:sela: ela: itapa tela, ta:tapola: howa hanose kiwa pipilise, kuniu kula:pela: hela: nano ketea sopoke amunawa Yesuma seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Selapita: Yesuyewi ta:tapola: ema selese, “Ne la:le, kewa Newemi himu semetei esa: matana hanosene kemi ke nakolawa fala:pekeye. Kewa halute ha:na:pa: seli elatipa:. Ke nakolawa heneye itapa telakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Au seya ikila emiwa sena noka inapola:, Yu senayewi kekenesene koane pota: enene senayewi koane emi inapola:, Yailasema selese, “Ke la:le hene heneye kulukeye. Kulunase Walosene Senama wa:ke selapa. Iya:ta:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Au selapita: solo amowa Yesuyewi ta:tapola: ta:ta: iya:pela:, Yu senayewi kekenesene koane pota: enene sena ama selese, “Kewa ipipa. Newemi himu semetei esa: matanepa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Au seya Yesuyewi Pitawala, Yemesewala, e ma:e Yonewana, siliye hanapola: sena kesale sopoma inapa, au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aluse iwa hanapola:, Yu senayewi kekenesene koane potapola: enene senayewi koane hanapola: potakamake, sena kesale muta kekenepela:, sala kuluwamopela: sosolo kamunuse ya:pelese ka:la:lopelelapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Potapola: Yesu koane musuluyetiye sena kesale sopoma selese, “Ko:lupita: ya:la:sela:? Sala amowa eninakeye. Eta: kulumakeye.” ");
INSERT INTO khs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Au selapita: sena kesale sopoke Yesuma akowapokeye. Ka:la:lopelapita: potapola: Yesuyewi iwa sopoma selese, “Kiwa sopoke mowa peleya: pakia kolemi hamone,” au seyakeye. Hanapita: potapola: sala amowa e amawana, inawana, Yesuyewi siliye hanapola:, sena usulupe Ewalapulu ilipe minawana siliye sala ka:pela:la koane musuluyetiye, ");
INSERT INTO khs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","sala tiya:wemi Yesuyewi tiyapola: Ene solopela:la: selese, “Talita kumi,” au seyakeye. Solo amowa mou wekeye. “Kesale sala, kewa tesile hamone,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Akamake kesale sala amowa tesile hapakeye. Tesile hanapola: sila:sela: enekeye. Apula: kesale sa: tesile hapa amowa yapene kukuluipe itapa telakeye. Kesale sa: amowa silalapita: potosekiwa iwa sopoke howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Howa hanapita: Yesuyewi ima selese, “Sena kesale nokama selapa. Sala amowa ma:na: nasewa kina:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Peleya: amowa iya:pela: Yesu E koamesa: mene hapakeye. Mene hanapola: E sena ilipe hanosewala, ilipe Ewalapulu ilipe mene ha:na: tiyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Mene hanapola: sita:la:, ha:le tesene ikila emiwa Yu senayewi kekenesene koane hanapola:, Yesuyewi se tiye kinapita:, sena kesale muta ta:tapola: howa hapakeye. Howa hanose iyewi selese, “Eyewi nano ketea sopoke kami topula? Kote matanawa solo napolo selapita: kami topula? Eyewi Kote penaiyayewi matane tiye epe tiseya E tiya:yewi timiyawa kami matane tile? ");
INSERT INTO khs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ewa koane tisene kapenta senakeye. Ewa Meli e sa:keye. E ma:ela:wa Yemesewala, Yosepewala, Yutasewala, Saimonewana, sopoke niyewi potosekeye. E atela: ninipe semetei elakeye.” Au seya iyewi Yesuma himu semetei esa: eta: matanamake mapolose sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Mapolose sitalapita: Yesuyewi ima selese, “Kote solo kinisene sepatosene senayewi e koamesa: sena ilipe sita:ne emiwana, e sena mayawala, e ama mouwana, e koane enisewa sena ilipe sita:neyawala, ewa puwano putupela: eta: matanesemakeye. Alawamona peleya: nokemiwa sopoke sena kesale Ewemi matanesekeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aluse, emiwa Yesuyewi nano kolotea timinise, sena mutama nakola towaya tiya:yewi kesakamake itapa kamona, Kote penaiyayewi matanepela: timinisewa Ewa sosolo eta: timakeye. Sena kesaleyawa Yesuma himu semetei esa: eta: matanamanase, sosolo eta: timakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ema himu semetei esa: eta: matanama elapita: Yesuyewi howa hanose sosolo matanakeye. Ikila emiwa, koamesa: kolotea sopowemi Yesu hanapola: se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Se tiye kinise, Yesuyewi E sena kukuluipe ta:peyawa mina e seyakeye. Mina selapita: potapola: sena elipei elipei esa: peleya: nowemi hanapola:, apula: kaluse sena elipei nowa peleya: nowemi hanapola:, aumita: ta:peyakeye. Ta:pele tiyapola: iyewi sena ho olokeyatela fiyane iya:pela: hamonite ima penaiya mikeye. ");
INSERT INTO khs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kinapola: selese, “Makene hanosekiwa nano ketea noka tiyapa. Ininamo tiyapola: hanakamakiwa ililakeye. Alawamona nano ketea nasewana, yetuwala, moweni ukala, nano ketea amowa tiyapola: hanapa. ");
INSERT INTO khs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamaka kapela: ililakeye. Alawamona sao elipei kapa. ");
INSERT INTO khs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kiwa hanosekiwa koamesa: emi hanapola:, koamesa: musuluyetiye koane semetei kemi eniya:sela: sita:latipa:. Koamesa: nowemi ha:na:na:pela:, koane kewa eniwa emi ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Koamesa: nowemi sena kesaleyewi kima eta: nekanamake, kili solo ta:pa:na:wa mapolosaleke potapola: koawa iya:pela: ha:na:pa:. Onatu funu pupalulawa fipa:pela: apola: iya:pela: ha:na:pa:. Funu pupalulawa iwalapulu ilipe kemi epesita: alusene epapuluse, ili olokeyatelawa iwalapulu kemi elakeye. Aluse kiyewi walopa:.” Au seya Yesuyewi sena kukuluipema seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aputa: sena kukuluipe hanapola: se tiye kina:sela:, “Sena kesale kili mane olokeyatela timiyawa iya:ta:pa: apula: kili matanawa notolopa:,” aluse se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ho olokeyatela mutawala iyewi hamonapita: hapakeye. Wela tiyapola: sena nakola towaya tomawemi tuwatakamake fala:pekeye. ");
INSERT INTO khs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesu penaiyayewi matanese tima:na: tisekeye sena kesale sopoyewi selapita: Yesu unuwa Kini Heloteyewi ta:tapola: sena nokamoke selese, “Yesu Ewa Yone hano toliyetisene epalakeye. Yone hano toluyetisewa mene tesilapola: ewa hanose penaiya timiyanakeye.” ");
INSERT INTO khs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Au selapita: sena nokamoke selese, “Yesuwa Ilaiya puwano enewa mene minanapo.” Au selapita: sena nokamoke selese, “Yesuwa sepatosene sena nowa enekeye. Puwano fa:nemi Kote solo kinisene sepatosene sena enene epapuluse Ewa elakeye.” ");
INSERT INTO khs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Alawamona Heloteyewi ta:tapola: selese, “Yone neyewi tokona naiye tiwa Koteyewi mene teisa:pekeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aluse, puwano Helote ene e ta:le ti senayewi Yone sukulu tiye tiya:wa tapola: tipolo selawapokeye. Mouwa wekeye. Heloteyewi e ma:e unuwa Filipikeye. Filipiyewi e kesale unuwa Helotiasekeye. Helotiasewa, Heloteyewi sutiyapola: elapita: potapola: ");
INSERT INTO khs_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yoneyewi Helotema kotopela: selese, “Kewa ke ma:e kesale amowa keyawa sutiyapola: elakamowa, solo ele tuwapowa kewa hotoyetiyatakeye.” ");
INSERT INTO khs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Au seyanase kesale Helotiyase ta:tapola: Yonema mapolose ela:, ewa kumita: sanapose epelese matanakeye. Matana kamona ewa sana eta: kulumakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Koiyawemiye, Heloteyewi Yonema ipilise ela: matanese, “Yone ewa hekeya ela: ewa Kotewalapulu matanepela: elakeye.” Aluse Helote ipilise ela:, Yone eta: sanamakeye. Aputa: sena nokamokiwala Yone sama:na:keye e selapita:, Heloteyewi eta: auma:na:ma e seyakeye. Ikila nowemiwa, Yone sowa Heloteyewi ta:tapola: epelese topu kamona eta: kolaiyamakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Puwano Helotiaseyewi matanepela: isu keya:ne opo napowa hetetikeye. Helote ewamo selati oka napuwa hetetiyapita: tikinise, Heloteyewi e kamani senawana, ami sena yesilawala, Kalili peleya: sena sosowala, iwa sopoma tikina kekenema:na: mina e seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mina selapita: potapola: Helotiyaseyewi ene e la:le inapola: Helote koawemi sosomatise kisalakeye. Sosomatise kisapita: potapola: Heloteyewi epelese, sena sopoke mina amokiwala epeyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Alake kesale polama Heloteyewi selese, “Keyewi nano ketea kina:pa: esaleke neyewi kema miya:na:keye. Neyewi nano ketea sopoke pota: enene heka kema miya:na:keye. Neyewi heneye maselesalekiwa, Koteyewi potalakeye,” aluse hekilase seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Selapita: Helotiyaseyewi e la:le hanapola:, e amama selese, “Neyewi ena tima:na: sema:na:napa?” Au selapita: Helotiyaseyewi selese, “Yone hano toluyetisene piseiwa miya selepa:.” ");
INSERT INTO khs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aputa: Helotiyaseyewi e la:wa ela:pe kipila hanapola:, Kini Helotema selese, “Yone hano toluyetisene piseiwa na tiye, meneki tuwapola: nema tine.” ");
INSERT INTO khs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Au selapita: Kini Heloteyewi ta:tapola: sosolo mapoyakeye. Mapolose ela: miya:na:keye, aluse hekilase seyawa, senayewi tikinise ikila emi sopoke topunase, na tiye kina:pa: e seyawa iya:tesaleko ewama:pekitise e seyawa kulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kulu hanapola: ela:pe kipila sena ta:le tiyewi Yone piseiwa naiye timita: tipolo koane hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aputa: tipolo koane hanapola:, Yone piseiwa na tiye meneki tuwapola: tiyapola: ine kesale polama mikeye. Kinapita: tiyapola: ene e ama Helotiyasema miya:na:pela: tiyapola: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aputa: ta:tapola:, Yone e sena ilipe hanosene inapola: Yone toma sopowa tiyapola: hanapola: sena kulu tuwatesene apanawemi tuwapokeye. ");
INSERT INTO khs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu E walosene sena ta:peyawa Ewamo enewemi mene inapola: iyewi nano ketea timiyawana, iyewi se tiye miwana, nano ketea sopoke Yesuma seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sela:sela: sita:lapita: sena kesale muta ine ha:na:, ine ha:na:, aluse sita:la: walosene senayewi ma:na: nasewa oka itapakeye. Aluse Yesuyewi walosene senama selese, “Kiwa kilipe Newanapulu mokopo mowa mina. Ikila koloteawemi ha:le tepa:se mina.” ");
INSERT INTO khs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Au selapita: iwa ilipe hanapola: mokopo mowa nono fa:nemi ha:na:na:nase potiwemi tapela: kolo tiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hanapita: sena kesale mutayewi potapola: matanese, “Iwa nono fa:nemi hanatakeye,” aluse matanepela:, iwa onatuyewi nono fa:nemi kipila hapakeye. Hanosekiwa koamesa: kolotea sopoke emi hapakeye. Hanapola: Yesuwala, E sena ilipe hanosewala, iwa seta: minama ela:, sena kesale muta hano hema isu kiwemi emi ela: hapawa, puwano hanapola: kekenakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kekenanase iwa potiwemi tapela: minawa, mowa sipa:kili tiye potakamake sena kesale muta sitalapita: potapola: iwa Yesuyewi sosolo hauwekilakeye. A:pele sipiyawa ili inawa itapalapita: tikili tese epesita:ya epapuluse, iwa tikili tese sitalakeye. Iyewi seli matanemita: Yesuyewi ima solo nowa se tiye kinapola:, solo nowana se tiye kinapola:, aluse nano ketea muta ima se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aputa: ikila emiwa, mowa nukulupita: Yesuyewi E sena ilipe hanosene inapola: Yesuma selese, “Peleya: weyemi mowa peleya:nase sena kesale masitalakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Oka sima:ma: tepita: sena kesale kekenayewi iyewi ili ma:na: nasewa wa:la:loma:na:pela: koamesa: mene hamona sema. Mowa koane koloteawala koamesa: koloteawala emi ma:na: nasewa wa:la:loma:na:pela: mene hamona sema.” ");
INSERT INTO khs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Alawamona Yesuyewi selese, “Kiyewi kilipe ma:na: nasewa ima kina:pa:.” Au selapita: iyewi selese, “Sena kesale sopoke ma:na: ma:na:wa niwa hanapola:, sakopolo elipei (200) ikilawa tima:na: tisene moweniwa epapula ma:ne wa:la:lopela: ima miya:na:na? Aluse niyawa moweni amowa itapa telanase, noko:lu tima:na:na?” Aluse iyewi Yesuma seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Au selapita: Yesuyewi ima selese, “Falawa ena ipa: telapa:? Potapose hamona.” Au selapita: iyewi keye hanapola:, mene inapola: Yesuma selese, “Ma:na: nasewa falawa pipe, ewalo elipei epapula telakeye.” ");
INSERT INTO khs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Au selapita: Yesuyewi selese, “Sena kesale takalese sopoke noka nono fa:nemi hutiya napolo emi ka:la:lomei. Apula: iwa noka kekenepela: hema nokemi hutiya napolo emi ka:la:lomei.” ");
INSERT INTO khs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Au selapita: iwa takalese ka:la:lose, sena kesale noka talo piipe (50) kekenepela: nono fa:nemi ka:la:lopela:la:, sena kesale noka sakopolo semetei (100) kekenepela: nono komemi ka:la:lopela:la: epapuluse iwa sopoke hutiyawemi ka:la:lopela:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ka:la:lopela: elapita: potapola: Yesuyewi falawa pipe, ewalo elipei tiyapola: ela:, hepene falemi pota: napolo esa: kulukululakeye. Kulukulupela: itapa tepela: falawa pasoloyetiye, sena ilipe hanosema kinapola:, sena kesale sopoke mita: Yesuyewi ima mikeye. Ewalo elipei amowala, sena kesale sopoma mita: Yesuyewi mikeye. ");
INSERT INTO khs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kinapita: iyewi sena kesale sopoyewi iliye tiye tiyapola: menakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Napela: kotetipela: falawawala, ewawala, mena hepe kemi teselapita:, sena ilipe hanoseyewi elale kukuluipewemi selawapola: woliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aluse sena ma:na: mena sopoke akeyawa taosene piipekeye (5,000). ");
INSERT INTO khs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sena kesale sopoke ma:na: napela: kotetiyapita:, ela:pe kipila, Yesuyewi E sena ilipe hanosema selese, “Kiwa puwano potiwemi tapela: hano hema nono fa:nemi ha:na:pa:. Hanapola: Pesaita taunewemi ha:na:pa:. Aputa: sena kesale kekenawa iwa koane meneyetiye hamona, au sema:na:pela: Newa mosote weyemi elakeye.” Aputa: iwa potiwemi tapela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hanapita: sena kesale sopoke kekenawana ili koane mene ha:na: tiyakeye. Ha:na: tipita: Yesu Ewa enapotane tokowemi kulukuluma:na:pela: fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Fiyanapola: nukulapo Yesu Ewa enapotane tokowemi ela: kulukulula:sela: enekeye. Ela: potakamake sena ilipe hanosene potiwemi tapela: hano ka:na honosanewemi kolo tiye hanapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Potakamake hano ko:lu alopowalapulu sosolo inise, potiwa tiyapola: fiyane sine esa: potiwa koyawa halute hanapita: papokeye. Mowa ikiwapa:na: mapatoyawemi potiwa alupa:pa:na:ne emi Yesu hano wapa:kemi onane minakeye. Onane inapola:, potiwa sitiyetiye ha:na:na:pela: elawamona, ");
INSERT INTO khs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ewa hano wapa:kemi onane inapitekiwa, iwa potiwemi ka:la:yawamoke potosekiwa matanese ho olokeyatela inapela: esa: matanese ipilise kalose holakeye. Hopita: Yesuyewi ima kipila selese, “Nekeye. Kiwa ipipa. Ipilise himunama tepa. Penanose sita:latipa:.” ");
INSERT INTO khs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aluse potiwemi iwa enewa emi Yesu takamake alopowa itapa telakeye. Itapa tepita: potapola: sena potiwemi sita:newa sosolo howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Puwano falawa pipe Yesuyewi pasoloyetiye kinapita:, sena kesale mutayewi kupuwemi iliye tiye menawa eta: seli matanamakeye. Ili siyewi papolo kamona himuyewi mouwa eta: matanemakeye. Heneye eta: seli matanamakeye. Alanase, ili himuyewi mapolose telakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hano Kalili ka:na enene potiwa kolo tiye sanese Yesuwala, Yesu E sena ilipe hanosewana, Keneselete peleya: hapakeye. Hanapola: potiwa palesewemi hanapola: potiwa meiyewi koma:peyakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Koma:pela: mowa sipa: keletiye hanapola:, ela:pe kipila sena kesale iyewi matanese, “Epamowa Yesulapo.” ");
INSERT INTO khs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Au seya matanepela:, peleya: emi koane sopoke kipila hanapola:, sena kesale nakola towaya sumusowa selawapola:, Yesu emi ela e selapita: ta:tapola:, Ewa elakemi tiyapola: minakeye. ");
INSERT INTO khs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu sila:ne ikila emiwa iyewi Ewa kelese enene koamesa: kolotea emiwana, taune sosolo emiwana, mowa peleya: koane koloteawala, inapita: potapola: peleya: sana hokatonase sena kesale nakola towayawa emi tuwapokeye. Tiye tipila: iyewi Yesuma selese, “Ke sao fili sosowemi niyewi kesakamake ilima:na: telalapita: amowa Keyewi ilikeye e sema.” Aputa: Yesuyewi ilikeye e seya. Ili e selapita: sao sosona emi iyewi kesakamake sena kesale nakola towayawa kipila fala:pekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Felesi senawana, Kote solo elewa walosene sena nokala Yelusaleme siti emi inapola: Yesu enewemi kekenakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Kekene tiyapola: potakamake, Yesuyewi E sena ilipe hanosene nokamoke tiya:le eta: selakolama ma:na: napita: potapola: matanese, “Sena amokiwa hele tiyatakeye. Aluse timiyamoke ili himuwa olokeyale timinitakeye. Iyewi Yu sena tililayawa solo ele amowa hotoyetiyatakeye.” Aluse Felesi senayewi matanakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aputa: Yu sena sopowala, Felesi senayawala alusewa tiya:le eta: selakolamananeke, ma:na:wa tiyapola: eta: nasemakeye. Yu sena tilila e mei kouwayewi aupa:, au seyawa kulu hanose, tiya:le selakolose ma:na: nasekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nano ketea wa:la:losene peleya: pakia sana emi inapola:, puwano ili tomawa selakolose kotetipela: ma:na: nasekeye. Ma:na: napose tiya:le selakolosene epapuluse, kapowala kumu amunawana menekiwala selakolosekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Alake Felesi senayeliye Kote solo elewa walosene sena iyewi Yesuma selese, “Ko:lupita: Ke sena ilipe hanoseyewi nini tilila kouwayewi aupa:, aluse sele minawa tikapeye tipela: sita:la:? Tikapeye tise iyewi ma:na: napose tiya:le ma selakotakeye.” ");
INSERT INTO khs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Au selapita: Yesuyewi ima selese, “Kili himu elipei epesita:ya sepatosene sena Aisaiayewi heneye sepapolakeye. Seyawa Kote pukawemi momateyawa wekeye. Koteyewi selese, ‘Sena kesale amokiwa Nema meatewi wapilise Alawamona ili himuyewi Nema mamatanekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Himuyewi Nema eta: matanemake mokopo meapo sopoyewi Nema wapilikeye. Iyewi ili matanawa se tiye kinakeye. Se tiye kinise kemi, Ne solo amowa iya:pela: iyewi ilipe senayewi sowa amowa se tiye kinakeye.’ Aluse, Koteye selapita: Aisaiayewi momateyalakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Alake, kiyawa Kote sowa tikapeye tipela: tilila kouwa meiyewi aupa: aluse sele minawa ta:tesekeye,” aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Me wa:ke Yesuyewi ima selese, “Kili tilila kouwayewi aupa: aluse sele minawa puwano putupela:, kiyewi Kote sowa tikape tesewa wekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Koteyewi E sowa Mosesema selese sekepilise, ‘Kine ki ata kine ki ama a:ko: seli matanepela: seila:ta:pa:,’ au seyakeye. Solo nowana selese, ‘Sena kesale nowamoke ene e atawala, ene e amawana, henipasolosaleke, ewa heneye kumita: sanapa:,’ aluse Kote solo sepapowa Moseseyewi sena sopoma sepapolakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Seya kamona kiyawa selese, ‘Senayawana, kesaleyawala, iyewi ili e atamawana, iyewi ili e amamawana selese, “Ka:tewi nano ketea miya:na:pela: elawamona iya:pela:, Kotema kinakeye.” Au seya kiwa Felesi senayewi sena kesalema se tiye kinakeye.’ ");
INSERT INTO khs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Se tiye kinapita: sena kesaleyewi ene e ata e ama a:ko: sesema:na:pela: elawamona, iya:takeye. Aluse e ama e ata seselesewa kiyewi ha:na: kalakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nano ketea etalesene muta nokala kiyewi timiyanakeye. Aluse kiyawa kili tilila kouwa meiyewi aupa: aluse sele minawa puwano apoma:na:pela:, Kote solo elewa kiyewi sekelese sitalakeye. Tilila kouwa meiyewi solo amowa kiyewi ta: tiyapola: aupa: etakeye. Apula: kiyewi sena kesale nokama aupa: aluse selesekeye” aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sena kesale sopoke kekenemita: Yesuyewi ima selese, “Kiwa sopoke mina. Kiwa ta:ta:pa:. Ta:tapola: matanepa:. ");
INSERT INTO khs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nano ketea mowa emi inapola: sena kesale suwemi hanakemiwa ewa kemi Kote sikapowemi eta: akelelisemakeye. Sulu emi tese mowa hanakamoke ewa akelelisekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kili kena:yewi ta:tesaleke, seli ta: tiya:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Au seya Yesuyewi selapola: kotetipela:, sena kesale kekenawa iya:pela:, koane musuluyetiye hanapita:, Yesu E sena ilipe hanoseyewi selese, “Pale seya mouwa enana?” ");
INSERT INTO khs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Au selapita: Yesuyewi selese, “Kiyawala mouwa kaluse mamatane seye? Nano ketea mowa emi inapola: sena kesale suwemi hanakamoke e himu fa:nemiwa eta: akelelisemakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nano ketea mowa emi himuwemi eta: hanosemakeye. Kupuwemiwa hanapola:, emi ili komowemi hanapola: iti koawemi hanosekeye. Alake ma:na: nasene sopoke kili himuwa eta: akelelisemakeye,” aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesuyewi wa:ke selese, “Matana emi hetetiyakamoke ewa kemi akelelisekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Matana emi sena kesale ili matana mane olokeyatela matanesewa wekeye. Olokeyatela tima:na:pela: matanesewana, mane ewalosene tima:na:pela: nano ketea iwei tima:na: matanesewana, nano ketea o:sulu tima:na: matanesewana, senala: kumita: sama:na: matanesewana, kesale atu tima:na:pela: matanesewana, sena elakemi sena nowa ha:na:na: matanesewana, ");
INSERT INTO khs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","sena nowa newa tima:na: aluse matanesewana, olokeyatela tima:na:pela: matanesewana, mokopo selapose matanesewana, kesale elakemi kesale nowa tima:na: matanesewana, ewa elakemi epapuluse newa aluse epesanowe aluse matanesewana, mokopo tipalese selapose matanesewana, ewa ene puwano putupela: epesena:pela: matanesewana, mokopo tima:na:pela: matanesewana, nano ketea sopoke matanawemi hetetisekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Himuwemi ketea sulu emi hetetiyakamoke, sena ewa akelelisekeye.” Aluse Yesuyewi Ene seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Peleya: amowa Yesuyewi iya:pela: hanapola:, Yu senama telayewi peleya: emi hanapola:, Taia taune mapatopita: emi hapakeye. Hanapola: senayewi Ewa popa:pekitise E koane musuluyetiye koane suwemi hapakeye. Hapa kamona Ewa sena kesaleyewi papokeye. ");
INSERT INTO khs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yesu minano e selapita: ela:pe kipila Yu senama tela kesaleyewi topukeye. Kesale amowa Finisia peleya: Silia peleya: honosanwemi emi tesenekeye. Kesale amoke e sa:wa kolotea kamona, ho olokeyatela ho tiyapitekiwa potapola: kesale amowa inapola: Yesu onatu emi kuniu kula:walopela: hela: selese, “Ne kesale sa: ho olokeyatelayewi fiyanekeye. Ho olokeyatela Keyewi hamonapa:.” ");
INSERT INTO khs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Au selapita: Yesuyewi kesalema pale selese, “Puwano, salama maita: kinakamake ililakeye. Ma:na: nasewa salawamopela: tuwapowa kasoma kinapitekiwa eta: ilimanakeye. Puwano salama maita: kinisekeye.” ");
INSERT INTO khs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Au selapita: kesale amoke Yesuma selese, “Piseiki, henenapo. Alawamona, salayewi ma:na: na:sela: mena hepe sululuwalupita:, kasolo tepolo hane sita:neyawa nasekeye.” ");
INSERT INTO khs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Au selapita: Yesuyewi selese, “Keye nano seyanase kewa ke koawemi hamona. Kine ke la:le ho olokeyatela fiyanewa iya:pela: hapakeye.” ");
INSERT INTO khs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Au selapita:, kesale amowa e koawemi mene hanapola: potakamake, e la:le ho olokeyatela fiyanewa, iya:pela: hanapola:, kesale sa: amowa ewa seli koane ka:pelalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aputa:, Yesuyewi Taia taune peleya:wa iya:pela: hanapola: Saitone taune amowana honosane sitiyetiye hanapola:, hano Kalili ha:na:na:pela: taune taloipe sopoke unuwa Tekapolisia peleya: hanapola: ");
INSERT INTO khs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","potakamake, sena kena: seteya meapo etapeya kola sena nowamoke siliyapola:, Yesu elakemi inise Yesuma penanose selese, “Ke tiya:yewi sena amowa kesama.” ");
INSERT INTO khs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aputa: sena kena: seteyawa Yesuyewi siliyapola: sena kesale muta kekenawa iya:pela:, a:ko: na:nipe kolotea hanapola:, elipe a:potane sita:la:, Yesuyewi E tiya:le kasoyewi sena kena: seteya elipe palese kotetipela:, Yesu E tiya:wemi kepesesa: sena meapo etapeya kolawa tepe kesalakeye. ");
INSERT INTO khs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kesalese ela: Ewa hepene falemi pota: sena amowa hauwekilise, haukula esa: Yesuyewi Ene solopela:la: sena kena: seteyama selese, “Efata,” au seyakeye. Solo amo mouwa wekeye. “Koloma,” e selesekeye. ");
INSERT INTO khs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Au selakamake sena kena: seteyawa itapa tepela: seli ta:tapola:, meapo etapeya itapa tepela: ewa seli selapita:, potapola: ");
INSERT INTO khs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesuyewi sena kesale sopoma selese, “Newa sena nokama selapa,” au seyakeye. Au selapita: iyewi ta:ta: iya:pela: iyewi nano ketea papowa sopoke seyakeye. Me wa:ke Yesuyewi ima selapa au seyawa, alawamona, iyewi ta:ta: iya:pela: sopoke selapita: ");
INSERT INTO khs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ta:tapola:, sena kesale nokamoke Yesuma sosolo howa hapakeye. Howa hanose selese, “Eyewi nano ketea sopoke seli timiyakeye. Sena kena: seteyawala seli ta:pita: eyewi itapa telakeye. Sena meapo etapeya seyawala seli semita: eyewi itapa telakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ikila nowemi me wa:ke, sena kesale sopoke Yesu enewemi inapola: kekenepela:, ma:na:wa itapalapita:, Yesuyewi E sena ilipe hanosema selese, ");
INSERT INTO khs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ikiwapo osokemi sena kesale muta Newanapulu ilipe kekenepela: sita:la:, ma:na:wa itapakeye. Itapa telanase Neyewi iwa sosolo hauwekikeye. ");
INSERT INTO khs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Iwa meina hanosaleke isu kiwemi menise hopolo tesekeye. Koiyawemiye, iwa noka pama emi minakeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Apula: E sena ilipe hanoseyewi selese, “Niwa epesita:ya we mowa peleya:nase sena kesale kekenama falawa iliye tipela: maita: kinapita: eta: ilimanakeye. Miya:na:wa kami tima:na:na?” ");
INSERT INTO khs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Au selapita: Yesuyewi selese, “Kiyewi falawa ena ipa: telapa:?” Aputa: iyewi selese, “Falawa tomoipewa telakeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Au selapita: Yesuyewi sena kesale sopoma selese, “Kiwa peleya:wemi ka:la:loma.” Aluse iwa ka:la:lopelelapita: potapola:, Yesuyewi falawa tomoipewa tiyapola: ela: Kotema napolo esa: kulukulupela:, itapa tepela: falawa pasoloyetiye, sena kesale sopoma mita: E sena ilipe hanosema kinise selese, “Falawa we sena kesale sopoke kekenama sakole hamona,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Au seya sikape ewalo tepeteni mutama teselapita: potapola:, Yesuyewi Kotema napolo esa: kulukululakeye. Kulukuluse itapa tepela:, sena ilipe hanosema selese, “Sena kesale sopoma sakopa:,” au selapitekiwa sakole hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sakopola: potakamake sena kesale iyewi sopoke iliye tiye napita: potapola:, falawa epela: ewalowala mena hepe sena ilipe hanoseyewi tiyapola: elale tomoipewemi selawapokeye. ");
INSERT INTO khs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aluse sena kesale sopoke kekena akeyawa taosene pinipe (4,000). Apula:, Yesuyewi iwa sopoke hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Komaiyama kemi iwa hanapita: Yesu E sena ilipe hanosewana potiwemi tapela:, potiwa kolo tiye Taomanuta peleya: emi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Felesi sena inapola: Yesuma ta:potose selese, “Koteyewi ta:peyawa kewalaleke, Keyewi nano timinisewa niyawa potapose Keyewi matiminima. Koteyewi hepene falemi nano alusewa niyawa popa:na:pela: Keyewi matiminima.” Au selapita:, Yesuwa E toma popa:na:pela: Ewa timinimita: seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Selapita:, Yesu e himu fa:nemiwa sosolo mapolose selese, “Sena kesale ikila weyemiwa epesita:yemi iyewi Ne toma popa:na:pela: selese, ‘Koteyewi ta:peyawa kewalaleke, Keyewi timinisewa niyawa popa:na:ke Keyawa matiminima,’ au selakamowa ko:lupita: ela:? Neyewi heneye selakeye. Ikila weyemiwa sena kesale epesita:ya weyemi popita: Kote penaiyayewi matanepela: timinisewa Neyewi eta: timinima:na:makeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Au selapola:, Yesuyewi iwa iya:pela: potiwemi tapela:, hano satepela: nono fa:nemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sena ilipe hanosewa Yesuwalapulu potiwa kolo tiye hanapola: iyewi falawa tiyapola: mina:na:wa kepoliyetiye minakeye. Alawamona, inapola: potiwemi sita:la: potakamake falawa semetei potiwemi elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aputa: Yesuyewi ima pale selese, “Felesi senayawala, Heloteyawala, ili olokeyatela matanesewa falawa solosene epapulakeye. Amuna amowa kiyewi tima:pekitise seli pota:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Apula: Yesuyewi selapita:, solo mouwa iwa tikili tese ilipe sopolo kekelese selese, “Niyewi falawa tiyapola: seta: minamanase au selakeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Au selapita: ili matanawa Yesuyewi potapola: ima ta:potose, “Ko:lupita: kiyewi ki kene sopolo kekelese selese, falawa itapalakeye e seya:? Ne solo mouwa kiyawa kao tikili tese sita:laposelele? Kiwa eta: papomana? Apula: ela:, kiyawa eta: matanamana? Kili himuwa mapeya elapa? ");
INSERT INTO khs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kili siyewi potose kasele, seli mapotoselakeye. Kena:yewi ta:ta kamona, seli mata:teselakeye. Neyewi nano timiyawa kiyawa kepoliyetiye sitalakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Sena muta taosene pipe (5,000) kekena emi, falawa pipe Neyewi pasoloyetiye kinapola: kotetipela:, falawa mena hepe kemi telapita: elale ena ipa: kiyewi selala?” Au selapita: iyewi selese, “Elale kukuluipewemi selawapokeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Apula: Yesuyewi selese, “Sena kesale muta taosene pinipe (4,000) kekenama Neyewi falawa tomoipewa kinapola: kotetipela:, falawa mena hepe kemi telapita: elale ena ipa: kiyewi selala?” Au selapita: iyewi selese, “Elale tomoipewemi selawapokeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aputa: Yesuyewi selese, “Epamowa kiyewi kao tikili tepa?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu E sena ilipe hanosewanapulu Pesaita taunewemi inapola: potakamake, sena nokamoke sena si kolawa siliye inapola: Yesuma penanose selese, “Ewa kesama.” ");
INSERT INTO khs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aputa: potapola: Yesuyewi sena si kolawa tiya: tiyapola: taune iya:pela: hanapola: sola papaseye tiye mowa tapowemi siliye hanapola:, Yesuyewi sena si kolawa siwemi kepesepela: ewa e tiya:yewi kesalese selese, “Ke siyewi ena pota:?” ");
INSERT INTO khs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Au selapita: sena si kolayewi selese, “Neyewi potakamake senawa i potosene epapuluse potose potakamukeye. I potosene epapuluse senawa aluse hanatakeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Aputa: wa:ke sena si kolawa Yesuyewi e siwemi kesakamake, si faka:pela: nano sopoke seli papokeye. Si kolawa heneye fala:tapita:, seli potose hokato papokeye. ");
INSERT INTO khs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Seli potapola:, Yesuyewi ema selese, “Ke koawemi hamona. Pesaita taune kemi mene hanapa,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesuwala, E sena ilipe hanosewana, iwa hanapola:, koamesa: noka Sisalia Filipai taune mapatopita: hapakeye. Emi honosane hapa ikila emiwa, Yesuyewi E sena ilipe hanosema selese, “Sena kesale sopoyawa Newa ipise matanepa:?” ");
INSERT INTO khs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aputa: iyewi selese, “Sena nokamoke selese, Kewa Yone hano toluyetisewa mene tesi tiye minanakeye. Aluse selesapekeye. Apula: sena nokamoke selese, Kewa sepatosene sena Ilaiyalakeye. Aluse selesapekeye. Apula: sena nokamoke selese, Kewa sepatosene sena nowanakeye, au selesapekeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Au selapita: Yesuyewi ima ta:potose, “Kiyewi kili matanawa, Newa ipise matanepa:?” Au selapita: Pitayewi selese, “Koteyewi Piseikipela: epesita: ta:peya sena Kelesowa Kewakeye.” ");
INSERT INTO khs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aputa: Yesuyewi selese, “Keleso Newa sena kesale sopoma selapa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sena ilipe hanoseyewi matanemita: Yesuyewi ima walose se tiye miwa wekeye. Yesu Ewa Sena Sa: peleya: weyemi minakeye. Ewa himu oiya sosowa senayewi Ewamo ikomopesakeye. Yu sena tililayawala, pilisiti sena soloyawala, Kote sowa walosene senayawala Ewa mapolose fa:se kinaposakeye. Fa:se kinapola: Ewa kumita: sanaposakeye. Ikila usulupe itapa tepela: mene teisa:taposakeye. Aluse auma:na:wa, Yesuyewi E sena ilipe hanosema se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Se tiye miwa heneye hokatolose seyakeye. Hokatolose selapita:, Pitayewi Yesuwa kolotea siliye hanapola: Ema penaiya selese, “Kewa sana kulaposakeye, au selapa.” ");
INSERT INTO khs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Alawamona Yesu mene notolo tese, E sena ilipe hanosewa potapola: Pitama selese, “Seteneyewi selesene aluse keyawa selapa. Kote matanesewa kulu hanose eta: matanamake, sena matanesewa keyawa kulu hanose matana hanatakeye. Setene, Kewa Ne fo:su tapowemi ha:na:pa:,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesuyewi sena kesale sopowala, E sena ilipe hanosewala, mina e seyakeye. Inapita: potapola: Eyewi selese, “Kiwa Newemi kulu inisekiwa, Newa kuluse i kelipapoya pama:na:wa, Neyewi uwapola: hapa epapuluse, kiyawala, kili matanawa iya:pela:, kili i kelipapoya tiyapola: ha:na:pa:. Ne onatu onaiyawemi emi, kiwala fe onanese ina:pa:. ");
INSERT INTO khs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Senala:wa peleya: weyemi a elekiwa a potala epesenewa semetei matanepela: tise elaleke, sikape sena amowa Kotewalapulu kokolo kao maelaposakeye. Alawamona, senala: nowamoke selesaleke, ‘Yesupela: newa kulakamakiwala ililakeye. Aputa: Yesuyewi solo napolo miya:na:pela: newa kulapitekiwa ililakeye.’ Aluse kuma:na:wa eta: matanamake ela:, sena amowa Kotewalapulu kokolo kao elaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aputa: senayewi peleya: sosolo weyemi nano ketea sopoke tiyapola: kekene tiye ela:, Kotewalapulu kokolo kao tesewa eyewi iya:pela: elaleke, kulu ikila emiwa nano ketea enayewi ewa sesepesapa:? Nano ketea nowamoke ewa sesema:na:wa maelakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kokolo kao tesewa wa:la:loma:na:pela: nano ketea enayewi wa:la:losena? Kokolo kao tesewa nano ketea nowamoke eta: wa:la:losemakeye. ");
INSERT INTO khs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ikila weyemiwa epesita:yemi sena kesale olokeyatela sita:laleke, senayewi e kesale iya:pela:, kesale nowanapulu hanosene alusene epapuluse, Newa iya:pela: hanose, Newamo ewalose hanose, Ne sowala iya:pela: sitalaleke, sena kesale sikapowemi alusene epapuluse, sikape Sena Sa: Newa mene ina ikila emiwa, Newa iya:peya sena kesale amowa, Newana iwa ewaposakeye. Ni Atayewi ho:liyawalapulu, hepene sena napolo sopoke mene ina ikila emiwa, sena kesaleyewi Newa iya:peyanase, iwala Neyewi iya:pa:na:keye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesuyewi E sena ilipe hanosema selese, “Neyewi kima heneye selakeye. Kiwa noka yemi sita:newa seta: kulumake sita:la: potakamake, Kote sena kesale amowa Piseikipela: pota: ela: E penaiya timinise elapita: potaposakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ikiwapo tekapeipe itapa tepela: Yesuyewi Pitawala, Yemesewala, Yonewana, iwa siliye tokomo tumu fiyanekeye. Fiyanapola: iwa ilipe sita:la: potakamake, Yesu tomawa kali tese, ");
INSERT INTO khs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","E sao kalawala, hene heneye koiya ho:lilipita: papokeye. Peleya: weyemi sopoyewi sao selakolosene koiya eta: epapulamakeye koiya ilimakeye. Ewa hele heneye ho:liya elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Potakamake ela:pe kilipa sitala sepatosene sena Ilaiyayeli Mosese a:ko: sita:la:, a:tewi Yesuwalapulu nano sela:sela: sitalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Potapola: Pitayewi Yesuma selese, “Walosene sena, niwa weyemi minawa napolakeye. Niyewi koane kolotea usulupe tima:na:keye. Koane nowa Kewamopela:, koane nowa Mosesepela:, koane nowa Ilaiyapela: aluse tima:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aluse Pitayewi Yesuma seyakeye. Iwa sopoke heneye himunama tese ipilise sita:nekeye. Alanase, eyawa ena sema:na:ne esa: matanamakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Aputa:, Iwa sita:newa kiniwaniyewi iwa fopiyakeye. Kiniwani fopiya honosane emi soyewi nowa selese, “Ewa Nine Ni Sa:keye. Ewa Neyewi himu hapa matanekeye. E sowa ta:tapola: matanepela: sita:latipa:,” au selapita: iyewi topukeye. ");
INSERT INTO khs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ta:tapola: iyewi ela:pe kipila potakamake Yesu Ene ilipe kemi iwalapulu ela:, sena elipei nowa itapalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Iwa tokomo tumu emi ina:sela:, Yesuyewi ima penaiya selese, “Sena Sa:wa Nekeye. Sikape Newa kuma:na:keye. Newa kulapola: mene seta: tesima weyemiwa, kiyewi napu nano papowa sema selapa.” ");
INSERT INTO khs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Au selapita: iyewi nano papowa sena kesale nokama eta: seyamakeye. Iyewi i kene selese, “Mene tesiwa mouwa enana?” Aluse iyewi i kene sowa kekela:sela: elatepa sosolo seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sena ilipe hanosene usulupe Yesuma selese, “Kote sowa walosene senayewi selese, ‘Keleso seta: minama ela: Ilaiyawa puwano inaposakeye,’ e seya amowa mouwa nano enana?” ");
INSERT INTO khs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Au selapita: Yone hano toluyetiseyewi Kelesopela: isu sosolo hekelesewa Yesuyewi matanepela: selese, “Ilaiya puwano inise Kelesopela: nano sopoke seila:taposakeye, au seyawa heneye kamunakeye. Kelesowa matanemita: nano nowana momateyawa wekeye. ‘Sena Sa: E toma oiya sosolo tise sena nokamoke Ewa ikomonose itipilise fa:se kinaposakeye,’ aluse momateya amowana matanepa:. ");
INSERT INTO khs_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Alawamona Neye selakeye. Ilaiya mina:na: seyawa heneye minakeye. Epe inaka iyewi ilipe kemi matanepela: ewa ikomonakeye. Aluse Kote pukawemi momate tiye aupesakeye au seyawa heneye kamunakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sena ilipe hanosene usulupe Yesuwalapulu tokomo tumu hapawa iya:pela: inise potakamake, sena ilipe hanosene nokalapulu sena kesale muta kekenepela: sitalapita: papokeye. Apula: sita:la: Kote sowa walosene sena nokamoke, sena ilipe hanosewanapulu kekelese selapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sena kesale sopoke Yesuwa potose sosolo epelese howa hanose Ewa koluma:na:pela: kipila inapita: potapola:, ");
INSERT INTO khs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesuyewi ima ta:potose, “Kiwa Ne sena siliwalapulu nano ena solo kekela:sela: sita:la:?” ");
INSERT INTO khs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Au selapita: sena kesale muta kekene emiwa sena semetei nowamoke selese, “Walosene sena, Kewa sesemita: ne sala siliye minakeye. Ho olokeyatelayewi ni sa:le amowa ho fiyanenase napute eyewi nano nowa eta: selesemakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ho olokeyatelayewi ho fiyanewa ikila emi ni sa:le amowa peleya: kolemi sano tiye toluye tise, meakemi supa:se sosolo tese, meakemi pese kalose, ki penanose sosowane telakeye. Alake Kewa seta: minamanase, Ke sena kilipe hanosema neyewi ta:potose, ‘Ho olokeyatela hamonoma.’ Au selapita: iyewi hamone e seyawa ho olokeyatelawa eta: hapamakeye.” ");
INSERT INTO khs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Au selapita: Yesuyewi ima selese, “Sena kesale ikila weyemi sitalakamokiwa Kotema himu semetei esa: matanepela: masitalatakeye. Ikila sopoke kiyewi nano hele matanepela: sitalapita:, Neyewi kiwamopela: ikila sopoke kao hokolose tiya:sela: elaposapa? Newa kiwalapulu ikila sopoke elapita: kemi kiyawa Newemi himu semetei esa: matanepela: masitalatakeye. Newa ela weyemi sala amowa siliye mina.” ");
INSERT INTO khs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Au selapita: sala amowa Yesu elakemi siliyapola: minakeye. Siliye inapitekiwa ho olokeyatela Yesuwa potapola:, sala amowa ho olokeyatela ela:pe kipila ha:na:na: temekelawa ilima peleya: kolemi sano tiye toluye tikeye. Sano tiye toliye tiyapita:, sala amowa kepeye hanose meakemi supa:se hetetise sosolo telakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aputa: Yesuyewi sala inama selese, “O:suwemi ho olokeyatela sala amo ho fiyanena?” Au selapita: sala inayewi selese, “Sala kiaiya kemi epapulakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ikila muta ni sa:wa ho olokeyatela tei wa:lawemi toliyetisekeye. Hawemiwala toliyetisekeye. Kumita: alusekeye. Alawamona Keyawa ilima:na: telalaleke na:ko: hauwekilise Keyawa sesema.” ");
INSERT INTO khs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Au selapita: Yesuyewi selese, “Ko:lupita: ililapa e seleseye? Senayewi Newemi himu semetei esa: elaleke, nano sopoke Neyewi tiyakamakiwa ililakeye.” ");
INSERT INTO khs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Au selapita: sala inayewi ela:pe kipila unuwapo holose, ‘Neyewi Kema himu semetei esa: matanekeye. Alawamona, ikila nokemi matana semetei esa: matanesewa koloteakeye. Koloteake sosolo temita: Keyawa newa sesema.” ");
INSERT INTO khs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Au selapita: Yesuyewi potakamake, sena kesale muta kekenema:na:pela: kipila inapita: pota:, ho olokeyatelama Eyewi selese, “Ho olokeyatela kewa sala weyemiwa kena: seteyawala, solo tikili telawala, kewa iya:pela: ha:na:pa:. Sala weyemiwa wa:ke ho fiyama:na:pela: menewa inapa.” ");
INSERT INTO khs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Au selapita: ho olokeyatelayewi ta:tapola: unuwapo holose sala amowa sosolo ha:na:na: temekelawa ilima apola:, sala amowa ho olokeyatelayewi ho fiyanewa iya:pela: hanapita:, sala amowa kulu amuna telakeye. Sala kulu amuna tepita: sena kesale sopoke potosekiwa selese, “Kulakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Alawamona Yesuyewi sala tiya:wemi tiyapola: teisa:tapita:, sala tesile hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aputa:, Yesu koawemi musuluyetiye inapita:, E sena ilipe hanoseyewi Ema ta:potose, “Niyewi ho olokeyatelawa iya:pela: hamone e seyawa eta: ha:na:na:ma tepita:, ko:luse e sena?” ");
INSERT INTO khs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aputa: Yesuyewi selese, “Ho olokeyatela hamonite timinisewa Kotema kulukulusene semetei kakeye. Nano nowamoke hamonapita: mahanaposakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Peleya: amowa iyewi iya:pela:, Kalili peleya: emi hanapola:, peleya: amowa sitiyetiye, iwa hapawa sena kesale sopoke ta:pa:pekitise, Yesu o:sulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","E sena ilipe hanoseyewi matanemita:, se tiye miya:na:pela: o:sulu hapakeye. Yesuyewi se tiye kinise, “Sena Sa:wa Nekeye. Newa sana kumita: senayewi Newa ta: tiye kinaposakeye. Ta: tiye kinise Newa sukulu tiye kumita: sanaposakeye. Newa sana kuluwa ikila usulupe tepela: mene tesima:ma:keye.” ");
INSERT INTO khs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Alawamona sowa iwa eta: kolaiyamakeye. Eta: seli matanama tutumanose ipilise sita:la: iyewi Yesuma selese, “Solo mouwa enana?” aluse eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesuwala E sena ilipe hanosewana hanapola:, Kapaneame taunewemi hanapola:, koawemi musuluyetiye Yesuyewi ima selese, “Kiwa isu sosolo inise kiyewi kilipe sopolo nano ena kekelala?” ");
INSERT INTO khs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Alawamona iwa solama telakeye. Koiyawemiye, iwa isu sosolo hanapola: sita:la: iyewi selese, “Niwa sena puwanowa ipa:?” aluse seyanase ewalose iyewi Yesuma nano eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eta: seyamanase, Yesuyewi Ewa hela: sena ilipe hanosene kukuluipewa mina e seyakeye. Inapita: potapola: Eyewi selese, “Senayewi Newa sena sosokeye, aluse kenawemi saliyapola:, wapilise matanese, ‘Newa putupela: epesena:pela: epelekeye,’ aluse kiyewi matanepa. Kiyewi kilipe puwano sikape apola:pa:. Kiyewi sena sopowamopela: tima:na: tisene sena amuna hetetiya:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Au selapola: sala nowa Eyewi siliyapola: iwa minitapowemi epesa seyakeye. Enewemi ewa Yesuyewi tiya:yewi sala amowa tiyapola:, E sena kukuluipe sopoma selese, ");
INSERT INTO khs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sena nowamoke Nema himu hapa matanepela: Ne unuwa matanemita: sala kolotea amunawa nekanesene epapuluse, Newana nekanenakeye. Newa nekanese Newa semetei manekanekeye. Ni Ata Newa hamona e seyawala nekanenakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoneyewi Yesuma selese, “Walosene sena, niyawa potakamake sena nowamoke Ke unuwa sepela:, sena nowa ho olokeyatela ho fiyanewa hamonapita: hapakeye. Hanapita: potapola: niyewi sena amawa selese, ‘Kewa Yesuyewi sena ilipe hanosewanapulu eta: palemakeye. Eta: palemanase ho olokeyatela hamona e selapa.’” ");
INSERT INTO khs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Au selapita: Yesuyewi ima selese, “Kiyewi sena epamowa kalese selapa. Senayewi Kote nano penaiya tima:na: tima:na:pela: Ne unuwa sepela:, ewa ela:pe kipila Newamo wepi maselaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Alanase senayewi ewa niwanapulu kisima tesaleko ewa nini manakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ne solo we heneye selakeye. Sena nowamoke selesaleke, ‘Kewa Kelesowemi kulu hapa senakeye. Alake neyewi kewa hano maita: miya:na:keye.’ Au seya sena amawa Koteyewi nano wa:la:ya hepe kinaposakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesuyewi E sena ilipe hanosema selese, “Sala ewa ene Newemi himu semetei esa: matanesene senayewi olokeyatela timinimita: sala ama tinenisaleke, tinenisene senawa Koteyewi sosolo falasipesakeye. Tinenisene senawa, e kemakuwemi etewa sosolo kakiyewi koma:pela: apola: hano tawala honosane hano maita: toliyetisaleke ililakeye. Falasima:na: epamowa koloteakeye. Koteyewi falasima:na:wa sosolo tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Aputa: ke tiya:yewi nano olokeyatela tiya:sela: elaleke, na tiye iya:ta:pa:. Tiya:le elipei elaleke tei eta: sekakolosema peleya: heo emi toliyetima:pekise, tiya:wa semetei noka na tiye iya:ta:pa:. Tiya:le nona:kalo semetei elaleke kamunuse tesewa ma:ta: tiye tise ela: ililakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aputa: heo peleya: emi fetekene eta: kulusemakeye. Teiwala eta: sekakolosemakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Aputa: ke onatuyewi nano olokeyatela timiya:sela: elaleke, na tiye iya:ta:pa:. Onatu elipei elaleke heo peleya: emi toliyetima:pekise onatu noka na tiye iya:ta:pa:. Onatu nona:kalo semetei elaleke kamunuse tesewa ma:ta: tiye timinise ela: ililakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aputa: heo peleya: emi fetekene eta: kulusemakeye. Teiwala eta: sekakolosemakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Apula: ke siyewi mane olokeyatelawa tisaleke, kine matanawa ikomonosekeye. Ikomoma:pekise, si noka tukutiye iya:ta:pa:. Si elipei elaleke heo peleya: emi toliyetima:pekise, si noka tukutiye iya:pela: si nona:kalo semetei ela: Kote Piseikipela: pota:tesene emi palesaleke ililakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aputa: heo peleya: emi fetekene ela: eta: kulusemakeye. Teiwala eta: sekakolosemakeye. ");
INSERT INTO khs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Alake soluyewi nano seila:tesene epapuluse, senayewi nano olokeyatela himu fa:nemi enewa tei kilipela: itapa tepela:, himuwa seila:tesekeye. ");
INSERT INTO khs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Apula: solu napokeye. Alawamona solu noiyawa itapa tesaleke, solu ko:lukamake noiyawa mene ketepesape? Alanase kiwa solu napolo amuna tepela: sena kesale sitala olosane emi tepa:. Kiwa kamako nowanapulu hopola tepa:. Sena kesale sopoma matanepela: o:sulu hopola sita:latipa:,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu Ewa Kalili peleya: amowa iya:pela:, Yutia peleya: hanapola:, hano Yotane satepela: nono fa:nemi emi enekeye. Enewemi sena kesale muta Yesu elakemi inapita: potapola:, Yesuyewi ima se tiye mikeye. Eyewi se tiye kinisene amunuse, iwa inapita: potapola:, Eyewi Ene amunuse se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yesu enewemi Felesi sena noka inise, Yesu toma popa:na:pela: Eyewi hele selapele esa:, iyewi Ema selese, “Senayewi e kesale iya:pa:na:wa ililapa? Iya:pa:na: solo elewa hotoma:na: telalapa?” ");
INSERT INTO khs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Au selapita: Yesuyewi Ene selese, “Moseseyewi solo ele sepapo ena seya tuwapola?” ");
INSERT INTO khs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Apula: iyewi selese, “Puwano Moseseyewi selese, ‘Kesale tili iya:pa:na:pelekiwa kesalema sawi momate tiye kina:pa:,’ au seyakeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Au selapita: Yesuyewi selese, “Kili himuyewi tikapeye tinase Moseseyewi senama selese, ‘Kesale iya:pa:na:wa ililakeye,’ au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Alawamona puwano fa:nemi ma:ta: ti ikila emiwa, Koteyewi senawana, kesalewala, elipe timiyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Timinise Koteyewi selese, ‘Senayewi ene e ama ene e ata iya:pela:, kesale tise ene kesalewalapulu semetei tepela:, ");
INSERT INTO khs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","elipe toma semetei sitalakeye.’ Aluse, elipe toma semetei sita:nenase elipei masitalakeye. Semeteikeye. ");
INSERT INTO khs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Alanase Koteyewi kesale sena elipe kekena:pewa, sena nowamoke takalekamakiwa eta: ilimanakeye.” Aluse Yesuyewi Felesi senama seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Selapola: itapa tepela: Yesu koane mene hanapola: enewemi, sena ilipe hanoseyewi Yesuma ta:potose, “Solo amowa mouwa enana?” ");
INSERT INTO khs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Au selapita: Yesuyewi ima selese, “Senayewi kesale tiwa ene e ko:lu mapolose, ewa iya: tese kesale nowa tisaleke, senayewi kesale nowa iwei tiyalakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Apula: kesale sena hapawa e sena mapolose iya:pela:, sena nowa hanasaleko, kesale amoke sena nowa iwei tiyalakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sena kesaleyewi Yesu enewemi sala siliyapola: minakeye. Siliye minawa Yesu tiya:yewi kesalese seila:pita: siliye minakeye. Siliye mina sena kesalema Yesuyewi E sena ilipe hanoseyewi himu konomonose ima selese, “Sala siliye inapa.” ");
INSERT INTO khs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Au selapita: Yesuyewi ta:tapola: konomonose selese, “Newa enewemi sala inisaleke ililakeye. Inapita: kapa. Sena kesale eta:wiye sala kolotea amunuse sita:newa, Kote Piseikipela: pota: elaka ili nekeye. ");
INSERT INTO khs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Neyewi kima heneye selakeye. Sena kesaleyewi sala kolotea mane Kote Piseikipela: pota: elaka amu timiya:sela: epapu matisaleko, sena kesale amowa emi mamusuluposakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aluse selese apola: sala amowa Yesuyewi talotiyapola:, ili tomawemi E tiya:yewi kesalese iwa seli sita:pesita:, napolo sita: tesewa ima mikeye. ");
INSERT INTO khs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Makene ha:na:na: ikila emiwa, sena semetei nowa kipila inapola: Yesu minitapowemi kuniu kula:pela: hela: selese, “Walosene sena napolo, newa Kotewalapulu kokolo kao epesena:pela: neyewi nano ena timinima:na:napa?” ");
INSERT INTO khs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Au selapita: Yesuyewi selese, “Kewa Nema ko:lupita:, ‘Walosene sena napolo,’ e seleseye? Mouwa matanepa:. Kote semetei Ene Ewa napokeye. Sena nowa napowa maelakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kote solo elewa keyewi matana hanatakeye. Solo ele amowa wekeye. ‘Sena kumita: sanapa. Kesale iwei tiyapa. Nano ketea nowa atu tiyapa. Sena nokama mokopo tipa selapa. Nano wa:la:ya heka atu tiyapa. Ke atawala, ke amawana, seli matanepela: seila:ta:pa:.’ Aluse, solo ele tuwapowa keyewi topukeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Au selapita: senayewi selese, “Walosene sena, newa a sala enewemi ikila emiwa, solo ele amowa ta: tiyapola: kao enekeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Apula: Yesuyewi Ewa potapola:, ema himu hapa matanese selese, “Keyewi nano semetei nowa eta: ilimakeye. Keyewi nano ketea sopoke wa:la:loma:na:pela: hamona. Hanapola: nano keteawa wa:la:lopela: apola:, moweni tiwa sena ketea itapa misitiya sita:nema kina:pa:. Kinapola: kopela: emiwa, keyawa nano himu hapa hepene falemi telakeye. Keye nano ketea kinapola: itapa tepela:, Newa kulu inise ina:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Au selapita: sena amokiwa ta:tapola: e nano ketea sosonase, sena nokama miya:na:wa mapolose, e mitiwa epeyawa itapa tese Yesu iya:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Hanapita: potapola:, Yesu mene notolo tese, E sena ilipe hanosema selese, “Nano ketea sosolo ela sena epamowa, Kote Piseikipela: elakemi mina:na:wa, hene heneye hokopesakeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Au selapita: sena ilipe hanoseyewi ta:tapola: howa hanose sitalapita: potapola: Yesuyewi wa:ke selese, “Ni sa:le, kiwa Kote Piseikipela: pota: epesita: mina:na:wa hene heneye hokopesakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tapola tupulusene ono uwalokemi kopolo ka:mowa sosonase musuluyetiye hanakamakiwa tele tesekeye. Alusene amunuse nano ketea sosolo tisene senawa Kote Piseikipela: elakemi mina:na:wa hene heneye hokopesakeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Au selapita: iyewi sosolo howa hanose tikili tese Ema selese, “Sena nano ketea sosolo telawa Kote Piseikipela: pota: epesita: Ehe, ema:na:wa hene heneye hokopesakeye, au selakeye. Alake sena falela kokolo kao tesewa eta: tiyaposape?” ");
INSERT INTO khs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Au selapita: Yesuyewi iwa potapola: selese, “Sena epamowa Kote Piseikipela: pota: epesita: senayewi ene kemi eta: timinima:na: telamakeye. Alawamona, nano ketea sopoke timinima:na:wa Koteyewi Ene semetei matanepela: elakeye. Alake sena kesale amowa Koteyewi mene silima:na:wa Kote Ene semetei ilikeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Au selapita: Pitayewi Ema selese, “Niyewi ketea amowa sopoke iya:pela: Kewa kulu minakeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Aputa: Yesuyewi selese, “Neyewi heneye selakeye. Sena kesale sopoke semetei semetei esa: Newemi matanepela:, Neyewi timinisewa tima:na:pela:, Ne solo napowa se tiye miya:na:pela:, e koane iya:pela:, e ma:e iya:pela:, e ate iya:pela:, e ama iya:pela:, e ata iya:pela:, sala iya:pela:, peleya: iya:pela:, aluse nano ketea sopoke iya:pela: enene senayewi ");
INSERT INTO khs_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","peleya: weyemi nano ketea sosolo tiyaposakeye. Tima:na:wa wekeye. Koanewana, peleya:wala tiyaposakeye. Sena kesale noka kine ke ma:e, ke ate, ki ama, ke sa:le aluse sitalaposakeye. Apula: sena nokamoke kewa ikomoma:na:pela: elawamona, sikape kewa Kotewalapulu kokolo kao elaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Alawamona yemiwa sena muta putupela: sita:newa sikape tepesakeye. Sena muta yemiwa sikape sita:newa puwano tepesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu Yelusaleme sitiwemi putupela: fiyanapita:, E sena ilipe hanosene sikape hanosekiwa, matana sosolo matanepela: howa hapakeye. Apula: sena kesale sikape kulule hanose hanosekiwa sosolo matanepela: ipilise hapakeye. Hanapola: ikila emiwa sena kukuluipewa Yesuyewi siliyapola:, kolotea hanapola: sikape Yesu Ene Ewemi nano auma:na:wa ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yesuyewi selese, “Niwa Yelusaleme sitiwemi fiyanakeye. Yelusaleme sitiwemi sena nokamoke Sena Sa: Newa sihelepesakeye. Sihelelepita: pilisiti sena sosoyawala, Kote solo ele walosene senayawala, Newa kumita:, iwemi papema, au selaposakeye. Aluse Newa kumita: Yu senama telayewi Newa iwemi papema:na:pela: siliye hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Siliye hanapita:, Yu senama telayewi Newa ikomonose itipilipesakeye. Itipilise Nema kepesesa:, Ne tomawemi sanose, Newa sanose kuma:na:keye. Sana kulapola: ikila usulupewemi Koteyewi Newa mene teisa:taposakeye,” aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepeti e sa:le Yemese Yone a:ko: Yesu enewemi inise Yesuma selese, “Walosene sena, na:tewi matanawa Keyawa aumita:keye.” ");
INSERT INTO khs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Au selapita: Yesuyewi a:ma selese, “Neyewi ka:ko:mopela: nano ena timinimita: ela:?” ");
INSERT INTO khs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Apula: a:tewi selese, “Kewa Piseikipela: ho:liya ela ikila emiwa, na:ko: nowa Ke tiya: ili tapowemi helema, apula: na:ko: nowa Ke tiya: hukalo tapowemi helema au semita: matanakeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Au selapita: Yesuyewi selese, “Ka:tewi epe ta:potose amowa mouwa ka:tawa mamatane selakeye. Neyewi kapo hano nasene ka:tawala ma:na: telalapa? Apula: sena hano toliyetisene epapuluse Ne hilila amoke sosolo fopulaposakeye. Ne hilila amoke kataopelesene epapuluse ka:ko:la hilila amoke fopuma:na:wa ililapa?” Aluse Yesu Ene ewamo ikomonose sana kuma:na:wa seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Au selapita: a:tewi selese, “Henekeye, na:ko: ilima:na:keye.” Apula: Yesuyewi a:ma selese, “Ne kapo hano nasene semetei kemi ka:tawa heneye naposakeye. Newa hano toliyetiyapita:, semetei kemi ka:ko:la hano toliyetima:na:keye. ");
INSERT INTO khs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Alawamona Ne tiya: ili tapowemi helema:na:wana, tiya: hukalo tapowemi helema:na:wana, Neyewi helema elawa eta: sema:na:makeye. Nine Ni Atayewi Ene matanawamunuse sea sela:pe ta:peyakeye.” ");
INSERT INTO khs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Au selapita: sena ilipe hanosene taloipe sopoyawa ta:tapola:, Yemese Yone a:ma mapoyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Mapolopita: sena ilipe hanosene sopoma Yesuyewi mina e seyakeye. Mina selapita: potapola: Yesuyewi ima selese, “Yu senama telayewi iyewi ilipe sena piseikiyewi sena kesale sosoma tinenisekeye. Sena piseiki ewa ene sosolo tese enenase sena ama tinenise polusekeye. ");
INSERT INTO khs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Alusene amunuse kiwa aluse sitalatepa. Kiyewi ki kene sena nowamoke matanese, ‘Newa sena sosolo epesena: tekeye.’ Aluse matanese sena koloteayewi timinisene epapuluse, sena sopowamopela: seselese timinipa:. ");
INSERT INTO khs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sena nowamoke matanese, ‘Newa sena putupela: epesena: tekeye.’ Aluse matanesene senayewi tima:na: tisene sena timinisene epapuluse, sena sopowamopela: tima:na: tisene sena amuna hetetiya:pa:. ");
INSERT INTO khs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sena Sa: Newa peleya: weyemi minakeye. Tima:na: tisene senayewi timinisene epapuluse, senayewi Newamopela: aluse timinimita:, Newa eta: minamakeye. Senala: sopowamopela: tima:na: tisene senayewi timinisene epapuluse tima:na:pela: Newa minakeye. Sena kesale muta olokeyatelawamopela: iwa falasima:pekise Neyewi kakasilise mene wa:la:le tima:na:pela: kulapose minakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesuwala E sena ilipe hanosewana inapola:, Yeliko taune emi hapakeye. E sena ilipe hanosewana, sena kesale muta Yesuwalapulu ilipe hanapola: taune iya:pela: hanakamake, sena semetei nowa Timiasi e sa:le e unuwa Patamease, e si noka elipe kola, isu sosolo hema moweni mita: helapita: papokeye. Aluse hela: Patameaseyewi ta:takamake, ");
INSERT INTO khs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nasalete sena Yesuwa inape e selapita: ta:tapola:, eyewi unuwapo holose, “Yesu, Tepiti sena maya, Newa hauwekilise sesema.” ");
INSERT INTO khs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Au selapita: sena kesale muta ema penanose selese, “Hopa. Sowa selapa.” Alawamona, Patameaseyewi wa:ke unuwapo sosolo holose, “Tepiti sena maya, Newa hauwekilise sesema.” ");
INSERT INTO khs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Apula: Yesuyewi ta:tapola: ewa minawa ene tepela: potapola: enekeye. Potapola: ela: Yesuyewi selese, “Sena amowa weyemi mina.” Au selapita: iyewi sena si kola ema selese, “Kewa weyemi ina:pa: e selakeye. Alake kewa tutumatepa. Kewa tesima.” ");
INSERT INTO khs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Au selapita: sena si kolayewi e sao kolu tiye sotukepila: kipila tesile, Yesu enewemi minakeye. ");
INSERT INTO khs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Inapita: Yesuyewi ema selese, “Kewa epelemita: Neyewi ko:lu meinapa?” Au selapita:, sena si kolayewi selese, “Walosene sena, Ne siyewi seli popa:na:keye. Siwa seila:ta:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Au selapita: Yesuyewi selese, “Keyewi Nema himu semetei esa: matana hanosene amoke, ke si kolawa fala:takeye. Kewa ha:na:pa:.” Au selakamake sena si kolawa fala:pela: ewa napolo papokeye. Napolo potapola: Yesuwalapulu isu sosolo kiwemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sena kesale muta Yesuwalapulu ilipe isu sosolo hapakeye. Hanapola: Yelusaleme sitiwa mapatopita: hetetikeye. Yelusaleme sitiwa mapatopita: tokomo Olofi elakeye. Tokomo Olofi mapatopita: Pefasi koawemiwana, Petani koawemiwana tili emi iwa hetetikeye. Hetetise Yesuyewi sena ilipe hanosene elipeima ");
INSERT INTO khs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","selese, “Ka:ko: koamesa: asopa epemi hamona. Hanapola: potakamake koane hekemi kopolo toki sa:le koma:peya e fa:kemiwa sena nowa eta: helesema kakiyewi koma:peya elapita: potaposakeye. Potapola: kakili fake tiye Newamo ela siliyapola: ina:pa:. ");
INSERT INTO khs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Apula: sena nowamoke ka:mawa ta:potosaleke, ‘Ka:tewi ko:luma:na:pela: ela:?’ Au selapita: ka:tawa mene selese, ‘Piseikiyewi kopolo tokiwa siliyapola: ina:pa: e seyanase, na:tewi siliyapola: hanakeye. Eyewi kopolo tokiwalapulu nano timiyawa kotetipela:, siliyapola: mene hamone e selapita:, kopolo tokiwa siliyapola: mene inaposakeye,’ aluse sela:pa:.” Aluse, Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Au selapita: sena ilipe hanosene a:ko: hanapola: potakamake kopolo toki e sa:le isu tenamo mapatopita: peleya: pakia isu sosolo emi kakili koma:peyalapita:, Yesuye seyawamuna elapita: papokeye. Potapola: kopolo tokiwa a:tewi fake tikeye. ");
INSERT INTO khs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Fake tiyapola:, sena sita:neyewi selese, “Ko:lupita: kopolo toki e sa:wa fakeleseya:?” ");
INSERT INTO khs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Au selapita: a:tewi Yesuyewi seyawa ima seyakeye. Selapita: senayewi selese, “Henekeye, siliye hamone.” ");
INSERT INTO khs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Au selapita: a:tewi siliyapola: hanapola:, Yesu enewemi kopolo toki e sa:wa siliye minakeye. Siliye inapita: potosekiwa, iyewi saowa kopolo toki fa:kemi fepela: apola:, Yesu emi heyakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Helepela: potapola:, sena kesale muta iyewi sopoke sao isu kiwemi emi felakeye. Apula: sena kesale nokamoke nano falo alekenawemi nasolo tiye, isu kiwemi emi felakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Felawemi Yesu inapita: sena kesale noka puwano, iwa noka sikapetapo apola: epapuluse minakeye. Inisekiwa iyewi sopoke holose inise, “Hosana. Niyewi Kewa siliyakeye. Kewa minawa sena Sosokeye. Piseiki Koteyewi Kewa hamone Eyewi Kewa napola:pekeye. ");
INSERT INTO khs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nini tilila kouwa mei Tepitiyewi piseikipela: pota: enene epapuluse, Keyewi piseikipela: pota: elaposakeye. Piseikipela: pota: epesenewa Koteyewi napola:takeye. Alake Kote hepene falemi enewa niyewi wapiyakeye. Hosana.” ");
INSERT INTO khs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aluse iyewi holose hanapola: Yesu Yelusaleme sitiwemi hanapola: hetetise, Kote koawa potapose hapakeye. Hanapola: nano ketea sopoke seli pote hanosekeye. Alawamona, opo sinapita: Yesuyewi Kote koawa iya:pela: sena ilipe hanosene kukuluipewalapulu Petani koamesa: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yopolotela semetei eniyapola: kiapo ikiwatapita:, Petani koamesa: iya:pela: hanapola: Yesu menipita: ");
INSERT INTO khs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","potakamake kolotea pama i kalu hene falo sopolo elapita: papokeye. Potapola: i kalu mouwemi hanapola: i fo supa:na:pela: potakamake, i kalu fowa eta: heyama falo sopolo elapita: papokeye. Koiyawemiye, kalu fo helesene opomakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Potapola: Yesuyewi i kaloma selese, “Me wa:ke ke fo mahelepesakeye. Sikape senayewi fo maita: inisekiwa, ke fowa eta: ma:na:makeye,” aluse seyakeye. Aluse seyawa E sena ilipe hanoseyewi topukeye. ");
INSERT INTO khs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yesu E sena ilipe hanosewanapulu Yelusaleme sitiwemi hanapola: hetetise, Kote koane pakia Yesu musuluyetiye hanapola:, Yesuyewi potakamake, sena kesale nokamoke nano ketea wa:la:ya:sela: sitalapita: potapola:, alutale tiye hamona seyakeye. Sena kesale nokamoke moweni peleya: kalikalila senisila:sela: sitalapita:, tepolowa notoloyetikeye. Sena kesale nokamoke a:nema: tumu amuna wa:la:lopita:, ili sea sita:newana notoloyetikeye. ");
INSERT INTO khs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Notoloyetiye Yesuyewi ima selese, “Kote koawemi nano ketea tiye inapita: wa:la:lomita: hanapita: aupa. ");
INSERT INTO khs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Apula: Kote pukawemi puwano sepatosene sena Aisaiayewi momateyawa wekeye. Koteyewi selese, ‘Sena kesale peleya: sopowemi sita:neyawa selese, “Niyewi Kotema sema:na:pela:, Kote koane inise kulukuluma:na:keye,” au selesekeye.’ Au selesene kamona Kote koane we kiyewi atu tisene sena koane amuna hetetikeye.” ");
INSERT INTO khs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Au selapita: pilisiti sena sosoyawala, Kote solo elewa walosene senayawala, iyawa Yesu sowa ta:tapola: Yesu kumita: sanapose matanakeye. Yesu solo se tiye miwa sena sopoke ta:tapola:, “Napolapo,” apula: potapola:, pilisiti sena sosoyewi katolose sita:la:, Yesu sama:na:pela: elawamona iwa ipilise eta: salimakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ka:lo nukulupita: Yesuwala, E sena ilipe hanosewana, Yelusaleme sitiwa iya:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kiapowemi iwa mene hanapola: potakamake i kalu puwano papowa falo olotilapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Potapola: Pitayewi Yesu seyawa matanepela:, Yesuma selese, “Walosene sena, pota:pa:. Keyawa puwano selese i kaluwa wa:ke senayewi fowa manaposakeye, e seyawa olotilakeye. Keyawa pota:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Au selapita: Yesuyewi selese, “Kotema himu semetei esa: matanepa:. ");
INSERT INTO khs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Neyewi kima solo we heneye selakeye. Kiyewi sena kesale nowamoke selesaleke, ‘Tokomo kewa kikili tiye hano tawala mutula hamone.’ Aluse himu elipei eta: matanamake heneye himu semetei matanepela:, auma e selesaleko aupesakeye. Aluse matanepela: elaleke Koteyewi aluse timinipesakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Alanase kiyewi kulukulusene ikila emiwa, Kotema nano ketea ta:tese heneye Koteyewi alalakeye, aluse matanese kulukulupita:, keteawa heneye aupesakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kulukulusene ikila emiwa, keyawa sena nowama kema mapolose enewa kepoliyetiya:pa:. Ke olokeyatelawa Koteyewi itapa temita: keyewi sena nowama mapolosewana itapa teme. Aluse kulukulusaleke Koteyewi ke olokeyatelawa iya:taposakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aputa: Yesu solo nowa selese, “Keyawa mapolosewa makepoliyetisaleke, ke olokeyatelawala ki Ata hepene falemi elakamoke maiya:taposakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yelusaleme sitiwemi Yesu E sena ilipe hanosewanapulu wa:ke mene hanapola:, Yesu Kote koane pakiawemi enewemi pilisiti sena sosowala, Kote solo ele walosene senayawana, Yu sena tililawala, iwa sopoke inapola: ");
INSERT INTO khs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yesuma selese, “Keyawa epe timiniseya eta:wi apoyala? Keyawa aluse timinimita: eta:wi Kema aluse timinipa:, e seyala?” ");
INSERT INTO khs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Au selapita: Yesuyewi ima selese, “Neyewi kima nano semetei nowa meapo ta:potakeye. Ta:potakamake kiyawa Nema solo mene inapita:, ta:tapola: Nema timinipe seyawa Neyewi kima sema:na:keye. ");
INSERT INTO khs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoneyewi sena kesale hano tolusulawa Koteyewi e seyala? Senaye seyala? Eta:wi seyala? Kiyewi Nema sema.” ");
INSERT INTO khs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aputa: i kene sopolo kekelese selese, “Niyewi Yesuma ena sema:na:ne? Niyewi selese, ‘Koteyewi au seyakeye,’ aluse selesaleke, Yesuyewi nima selese, ‘Ko:lupita: Yoneyewi solo amowa ta:te iya:peyala?’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Alawamona niyawa selese, ‘Senayewi au seyakeye,’ aluse selesaleke, sena kesale sopoke nima mapolose konomopesakeye. Koiyawemiye, sena kesale sopoke matanese, ‘Yone ewa heneye sepatosene senakeye. Ewa heneye Kote solo se tiye kinisene senakeye.’” Aluse iyewi matananase ima ipikeye. ");
INSERT INTO khs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Alake ilipe kekelese Yesuma selese, “Yoneyewi sena kesale hano tolusulawa eta:wi eta: elamita:keye. Niwa tikili tekeye.” Au selapita: Yesuyewi selese, “Kiyewi Nema solo mene eta: seyamanase, Nema timinipa: e seya mouwa kima maselaposakeye,” aluse Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Aputa:, Yesuyewi ma:ta: tima:na: pale selese, “Alekena inayewi mei kalepe alekena amowa kepela: apola:, sikape solakeye. Solawala fo tikipaselesa: waine hano hamonite, etewa kalotese pokose amuna timiyakeye. Timinise senayewi alekena amowa seli pota: epesita:, ituwe koane tikeye. Tipela: apola:, alekena amowa sena nokamoke alekena potapola: sita:pesita: sena noka ta:pele tiyapola: apolo wayakeye. Ta:pele tiyapola: itapa tepela:, alekena inayewi senawana, e alekena amowana iya:pela:, peleya: nowemi makene hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hanapita: mei kalepe fowa kene ina ikila emiwa, alekena pota: sita:ne senayewi mei kalepe fowa supukeye. Su tiyapola: takalese alekena inayewi seyawa ta:tapola: iliye tima:na:pela: elawamona, iyewi tikapeye tipela: matanepela:, alekena inamawa eta: tuwapomakeye. Apula: alekena inayewi e tima:na: tisene senama selese, ‘Mei kalepe fowa newamopela: tuwapowa keye tima:na:pela: hamone,’ au seyakeye. Aputa: tima:na: tisene senayewi tima:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ewa hanapola: alekenawemi inapitekiwa, alekena pota: sita:ne senayewi ewa sanapola:, mei kalepe fowala eta: mima mokopo hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Apula: wa:ke mei kalepe fo tima:na:pela: alekena inayewi tima:na: tisene sena nowa hamona seyakeye. Hamona seyawa alekenawemi inapitekiwa, alekena pota: sita:ne senayewi ewa piseiwemi sanapola: ewa ikomonose itipiyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sanose ikomonose itipiyawa potapola: alekena inayewi tima:na: tisene sena nowama mei kalepe fo tima:na:pela: hamona seyakeye. Hamona seyawa alekenawemi inapitekiwa, alekena pota: sita:ne senayewi ewa sana kulukeye. Tima:na: tisene sena nokamokiwala kamunakeye. Tima:na: tisene sena noka sanapola:, apula: tima:na: tisene sena noka heneye sana kulukeye. ");
INSERT INTO khs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Apula: alekena inayewi matanese, ‘Sena semetei nowa elakeye. Ewa Ni Sa:keye. Ewa Neyewi sosolo himu hapawa matanese elakeye. Ewa Ni Sa:nase iyewi maikomopesakeye.’ Aluse matanepela: E Sa:ma selese, ‘Mei kalepe fo tima:na:pela: hamona,’ apula: E Sa:le amowa Ewa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Hanapola: alekenawemi inapitekiwa, alekena pota: sita:ne senayewi selese, ‘Alekena ina sa:wa inatakeye. Alanase sikape E inawa kuluwemi onatu wapa:kemi Ewa ela:, alekena we Eyewi pota: epesena: telalakeye. Auma:pekise Ewa sama:na:keye. Sana kulapita: alekena we niyewi ninipe tima:na:keye. Alake niyewi niwa ina tepela: pota: sita:pesena:keye.’ ");
INSERT INTO khs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Au seya sala amowa iyewi sukulu tiye sana kulapita:, alekena solawa papaseye tiye hema tapowemi toliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Alake sikape alekena inawa inisekiwa alekena pota: sita:ne senawa ko:lupesape? Ewa inapola: eyewi alekena pota: sita:ne senawa sana kulaposakeye. Sana kulapita: sena nokamoke alekena amowa seli pota: sita:pesita: ta:pelepesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Aputa: Yesuyewi sena kesale sopoma selese, “Kote pukawemi solo weyamowa momateyawa kiyawa eta: akeyamana? Kote pukawemi momateyawa wekeye. ‘Koane tisene senayewi i isu sotukepiyawa wa:ke tiyapola: inapola: koane honosane kelalakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kela epa Koteyewi Ene aluse timiyanakeye. Aluse timiyalapita: niyewi potapola: selese, “Epamowa seli napolapo,” alusekeye.’ Aluse, momateyalakeye.” ");
INSERT INTO khs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aluse Yesuyewi selapitekiwa, pilisiti sena sosowala, Kote solo ele walosene senayawana, Yu sena tililawala, iwa sopoke ta:tapola: matanese, “Yesuye niwamo kotopela: apola: pale seleselakeye.” Aluse matanepela:, Yesu tipolo selawapote supa:na:pela: elawamona, sena kesale iyewi sopoke ima konomoma:pekitise, Yesuwa iya:pela: iwa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Felesi senayawala, Helote kulu hapa senayawala, Yesu elakemi sena noka hamona seyakeye. Yesuyewi hele selapele esa:, hopolose meapo ta:tapose hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Hamonapita: iwa hanapola:, Yesu elakemi inapola: selese, “Walosene sena, Ke sowa hene heneye selakeye. Aluse niyewi matanekeye. Aputa: senayewi Kewa ikomoma:na:wa kine kewa eta: matanamake Keyawa heneye selesekeye. Sena sosowa epelemita: Keyewi se tiye kinise eta: selesemakeye. Koteyewi alusewa Keyewi heneye se tiye kinatakeye. Alake Kema niyewi meapo ta:takeye. Niyewi Yu senayewi Lome sena Sisa piseikima takese moweni kinapitekiwa ililapa? Kinakamake Kote solo elewa hotoma:na: telalapa? Ko:luma:na:napa? ");
INSERT INTO khs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Niyewi takese moweni tuwataposapele? O iya:pa:na:napa?” Alawamona ili himu elipei matanepela: sita:la:, ili sowa pateya seyawa Yesuyewi Ene potapola: ima selese, “Neyewi hele selesaleke Neyewi Ne solo kemi ka:yewi a:pele sanosene aluse, Newa Nine samita: kiyewi aluse selakeye. Neyewi hele selesaleke kiyewi Newa tipolo selawapa:na:pela: selakeye. Alake moweni usu amo Neyewi potapose tiye mina.” ");
INSERT INTO khs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Au selapita: iyewi moweni usu tiyapola: minakeye. Tiye inapita: Yesuyewi potapola: ima selese, “Sena ipi mitiwa moweni ukemi elatapa? Ipi unuwa momateyalapa?” Au selapita: iyewi selese, “Lome sena piseiki Sisa mitilakeye. E unuwa momateyalakeye.” ");
INSERT INTO khs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Au selapita: Yesuyewi selese, “Lome sena piseikiyewi newa Ene Ema kina:pa:. Kotenewa Kote Ene Ema kina:pa:.” Apula: iyewi ta:tapola: howa hanose sosolo kete matanakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satusi sena Yesu enewemi inapola: iyewi matanese, sena kesale kuluwa mene eta: tesilisemakeye. Aluse matanepela: iyewi Yesuma selese, ");
INSERT INTO khs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Walosene sena, Moseseyewi solo momateyawa wekeye. ‘Sena nowamoke ene e ma:yewi sala eta: kesilamake kulapita: potapola:, ene e ma:yewi kesale sopa:lawa tisekeye. Sena kulu amowa e sa:le maya tekamunuse manomita: kesale sopa:lawa ene e ma:yewi tisekeye.’ Aluse Moseseyewi solo momateyawa niyewi akeyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sena tomoipewa sita:newa ilipe e ma:e semeteikeye. E ma: ola:tewi kesale tiwa sala eta: kesilamake kulapita:, ");
INSERT INTO khs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","e ma:e kulu fo:su amoke kesale sopa:lawa tikeye. Ewala sala eta: kesilamake ewa kulukeye. Kulapita: e fo:su kemi kesale sopa:lawa tikeye. Tiwamona ewalapulu sala eta: kesilamake kulapita:, ");
INSERT INTO khs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ala hanapola:, e ma:e tomoipeyewi kesale sopa:la semetei kamo tiye ha:na: hanapola:, sala eta: kesilamakeye. Sikape kesale initelawa elapepela: sikape ewala kulukeye. ");
INSERT INTO khs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kulu mene tesila ikila emiwa, kesale amowa a:me ekele tepesape? Kesale amowa sena tomoipeyewi tikeye.” ");
INSERT INTO khs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Au selapita: Yesuyewi selese, “Kote solo pukawemi Moseseyewi momateyalakeye. Momateyawala, Kote E penaiyawana, kiyewi tikili tese hele matana hanatakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sena kesale kulu mene tesilapita: hepene sena epesita:ya epapuluse sitalaposakeye. Aluse sitala ikila emiwa sena kulu mene tesiyawa kesale kulu teisa:pewa eta: tisemakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aputa: sena kesale kuluwa mene teisa:pa:na: amowa mouwa Moseseyewi momateyawa wekeye. I tepeteni honosane emi tei wa:la enene ikila emiwa, Koteyewi Mosesema selese, ‘Epalahame Kotewa Nekeye. Aisa:ke Kotewala Nekeye. Yakope Kotewala Nekeye.’ Au selapita: Moseseyewi momateyawa kiyewi akelese mouwa kiwa mamatane selakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Momateya amo mouwa wekeye. Kote Ene Ewa sena falela apota: a sitalakamo Kotekeye. Ewa sena kulu tana Kotemakeye. Kiyewi puwano seyawane hele seleselakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kote sowa walosene sena semetei nowa inapola: potakamake, Satusi senayewi Yesuma kekela:sela: seya ikila emiwa, ili solo amowa Yesuyewi solo napowa ima mene se tiye kinapita: potapola:, sena mina amoke Yesuma selese, “Kote solo ele nowa nokaiyamo puwanowa?” ");
INSERT INTO khs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Au selapita: Yesuyewi selese, Kote puka momateyawa wekeye. ‘Isolaiya sena kesale kiyawa ta:ta:pa:. Nini Piseiki Kote Ene semetei Piseikipela: elakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Alake kiyewi Piseiki Kotema himu hapa matanepa:. Kili himu sopoyawa Ema himu hapa matanepa:. Kili ho sopoyawana Ema himu hapa matanepa:. Kili matana sopoyawana Ema himu hapa matanepa:. Kili penaiya sopoyawana Ema kulupela: apola:pa:.’ ");
INSERT INTO khs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Apula: Kote solo nowa wekeye. ‘Keyawa kine kewamo himu hapa matana hanosene amunuse, sena nowana aluse himu hapa matanepa:.’ Aluse, solo elewa elipei amowa heneye itapa tesekeye. Solo nowa puwanomakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Au selapita: Kote sowa walosene senayewi selese, “Walosene sena, Keyawa epe selese amowa henenapo. Kote Ene Ewamo semeteikeye. Piseiki Kote nowa maelakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ke himu sopolo Ema himu hapa matanayawana, ke matana sopolo Ema himu hapa matanayawana, ke penaiya sopolo Ema himu hapa matanayawana, kine kewamo himu hapa matana hanosene aluse, keye sena nowa aluse himu hapa matanepa:. Au selaka henenapo. Koteyewi epelemita: solo ele elipei amowa kulu hanose timinisewa heneye itapa tesekeye. Kotema nano sopoke sano tiye kilipela: kinaka sikapekeye.” ");
INSERT INTO khs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Au selapita: eyewi seli matanepela: seyawamunuse, Yesuyewi ema selese, “Kewa Kote Piseikipela: pota: epesene pa elakeye,” au seyakeye. Au selapita: iyewi Yesuma nano ta:popa:na:pela: elawamona, iyewi solo amowa sano tiye toluyetiyapita:, wa:ke nano nowa meapo eta: topumakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Senayewi matanemita: Kote koane pakia hema nokemi Yesuyewi selese, “Kote solo elewa walosene senayewi selese, ‘Kelesowa Tepiti sena i maya mina amo senanakeye,’ au selesapekeye. Au selaka ko:lupita: ela:? ");
INSERT INTO khs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Puwano fa:nemi Ho Napoyewi Tepitima matanepitekiwa Tepitiyewi selese, ‘Ne Piseikima Piseiki Kote selese, “Kewa ne tiya:le ili tapowemi helema. Helapita: ke kisiwa Neyewi sano tiye ke hanewemi apoma:na:keye.” ’ Aluse, Kote seyawa Tepitiyewi momateyalakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Alake Tepitiyewi Kelesoma selese, ‘Kewa ne Piseikikeye,’ au seyawa ko:lupita: e seyala? Aputa: tilila kouwayewi E sala maya hapama ‘Piseikikeye,’ elawa eta: selesemakeye. Alake Tepitiyewi Kelesowemi ‘Piseikikeye’ au seyanase, Tepiti seta: kesilama Kelesowa puwano fa:nemi kao enekeye. Alawamona kiyewi selese, ‘Tepiti maya mina emi Keleso hetetiyaposakeye,’ au selakeye. Au selaka ko:lupita: ela:?” Aluse Kote sowa walosene senayewi solo amowa Yesuyewi sano tiye toliyetise selapita:, sena kesale sopoke ta:tapola: heneye epeyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesuyewi solo se tiye mini ikila emiwa se tiye miwa wekeye. Eyewi selese, “Kote solo ele walosene senayewi timinisene amunuse, kiyawala aluse timinipa. Iyewi sao senatolo kapela: hanapola: sena kesale kekenepela: sita:ne iwa hanose, senayewi ili tiya:wa hapolose iwa me solo se selese, ‘Walosene sena sosolo,’ au semita: sosolo epelesekeye. ");
INSERT INTO khs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Apula: Yu senayewi kekenesene koane hanapola:, sena kesale sopoke kekenepela: ka:la:lopela:la:, iwa minitapowemi sea ka:la:loma:na: epelesekeye. Tikinisene ikila emiwa senayewi iwa me solo se, sena piseiki ununa sosowa sea emi ka:la:loma:na:pela: epelesekeye. ");
INSERT INTO khs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Apula: kesale sopa:la moweniwana, nano keteawala, ima mita: kesale sopa:lawa ipa:tesekeye. Iyewi atu tima:na:pela: aluse ipa:tesekeye. Ipa:pela: kemi senayewi iwa napolapo, au semita: iyewi kulukulula:sela: sita:la:, solo senato solo senatoye hanose kulukulusekeye. Alanase iwa sopoke falasima:na:wa heneye sosolo tepesakeye.” Aluse Kote solo elewa walosene senayewi alusewa Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kote koane pokose moweni tuwaponase, nono fa:nemi Yesu hela: potakamake, sena kesaleyewi moweni tiyapola: inapola: Kotema miya:na:pela: pokose telakeye. Nano keteawa sosolo enewa sena kesale iyewi sopoke moweni sosolo selawapokeye. ");
INSERT INTO khs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Alawamona kesale sopa:lawa nano ketea misitiya enenase eyewi moweni usu kulu elipei selawapokeye. ");
INSERT INTO khs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Moweni usu kulu elipei selawatapita: potapola:, Yesuyewi E sena ilipe hanosewa mina e seyakeye. Inapita: potapola: Yesuyewi ima selese, “Sena kesale iyewi sopoke moweni selawapowa, kesale sopa:la moweni selawapo amoke helete tiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iyewi moweni kinapola: itapa tepela: moweni noka kemi elakeye. Alawamona kesale sopa:lawa eyewi nano ketea misitiya enenase moweni kolotea enewa sopoke tiyapola: ine mikeye. Moweni nowa e koane maelakeye.” Aluse Yesuyewi E sena ilipe hanosema seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kote koawa Yesuyewi iya:pela: hanose ikila emiwa, E sena ilipe hanosene semeteiyewi ema selese, “Walosene sena, Kote koawa pota:pa:. Etewa koane tiwa hene heneye sosolapo. Alake koawa hene heneye napokeye.” ");
INSERT INTO khs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Au selapita: Yesuyewi ema selese, “Kote koane na:tewi epe potoseya, etewa kalopo hanapola:, koane tiwa sikape ekeye tiye semetei semetei esa: sitalaposakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu tokomo Olifiwemi hanapola: tokomo akola naiya emi potakamake, Kote koane elapita: pota: hela:, Pitawala, Yemesewala, Yonewana, A:nituluwala inapola:, ilipe semetei sita:la: Yesuma iyewi ta:potose, ");
INSERT INTO khs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Keyawa epe seleseya asu hetetiyaposape? Koteyewi Ene nano sopoke auma:na:wa ikila asu hetetiyaposape? Niyewi matanemita: nano enayewi nima walopesape?” ");
INSERT INTO khs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Au selapita: Yesuyewi selese, “Pota:pa:. Sikape nano auma:na:wa wekeye. Sena nokamoke kima mokopo selesaleke iyawa solo amowa ta: tima:pekise seli pota:pa:. ");
INSERT INTO khs_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sena muta inaposakeye. Inapola: iyewi mokopo selese, ‘Newa Kelesokeye. Piseiki Soswa Nekeye.’ Aluse iyewi Ne unuwa sepela: mokopo sela, solo amowa sena kesale mutayewi ta: tiyaposakeye. Alake kiyewi seli pota:pa:. ");
INSERT INTO khs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Apula: senayewi koamesa: nowanapulu tetape esaleke, kiyewi ta:taposakeye. Koamesa: pawemiwala, koamesa: pamawemiwana tetakeye esaleke, aluse solo pepile hapa selesalekala kiyawa ta:taposakeye. Ta:tapola: himunama tepa. Senayewi tepa:na:wa puwano hetetiyaposakeye. Alawamona, Koteyewi nano sopoke auma:na:wa sema hetetiyaposakeye. Alawamona, ka ikilawa asepakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sena peleya: nowamo sena peleya: nowanapulu tetesaleke, kamani nowamoke kamani nowanapulu tetesaleke, aupesakeye. Peleya: kalikalila henene sosolo inaposakeye. Apula: peleya: kalikalila nano ma:na: itapa tepela: sena kesale sosolo menipesakeye. Kesale ene sala kesima:na: tekemiwa sosolo temekelese fa:sewala, himuwana, sosolo olosekeye. Olosene ma:ta: tisene epapuluse henene sosolo kemiwala, nano ma:na: itapa tepitekiwala, kisi tetakemiwana, epapuluse sena kesalema nano hililawa ma:ta: tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ikila emiwa kiwa sutesima:pekitise pota:pa:. Kiwa sena nokamoke sukulu tiye kotosene senayewi kiwa kotose, apula: Yu senayewi kekenesene koawemi sena nokamoke kiwa mei kiyewi sanaposakeye. Alake kiyawa Newa kulu hapanase, kiwa kamani senawala, sena piseikiwala, kiwa kotomita: sena nokamoke kiwa supa:na:pela: hamonapesakeye. Sukulu tiyapola: kotoma:na: ikila emiwa, kiyawa ima Newamo solo se selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Itapa tema:na: ikilawa seta: hetetima ela: Newa matanemita:, solo napowa peleya: sopolo sena kesale sopoma Newamo kulu hanosene sena kesaleyewi se tiye kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Apula: kiwa sukulu tiye kotoma:na: ikila emiwa, kiyewi sema:na:wa tutumatepa. Kotoma:na: ikila kemi sema:na:wa kiwa himu fa:nemi Kote matanawa, kiyewi selaposakeye. Kiyewi kili matanawa maselaposakeye. Ho Napoyewi matanawa kiyewi selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Apula: senayewi ene e ma:ewa, sena nowamoke sanose kumita: ta: tiye kinaposakeye. Apula: inayewi ene e sa:wa sena nowamoke sanose kumita: ta: tiye kinaposakeye. Apula: salayewi ene e atawa e amawa a:ko: sena nowamoke sanose kumita: ta: tiye kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Alake kiwa Newa kulu hapanase kiwa sena kesale sopoke mapolopesakeye. Alawamona, kiwa Koteyewi mene silimita: kiwa Kotewemi kulu hapawa eta: iya:peyamake, kao matanese sita:la:, tiye hanose pulaye tiye iya:ta:pa:,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesuyewi ima selese, “Kiyewi potakamake Kotewa kolotea meapoma:na:pela:, Kote koawemi nano ketea heneye olokeyatela tuwatapita:, kiyawa nano amowa potapola: seli matanepa:. Amowa kiyawa Yutia peleya: sita:newa nesile tokowemi ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Apula: kiwa sena noka koane tomo sita:newa kiwa koane suwemi nano ketea tima:na:pela: hanapa. ");
INSERT INTO khs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Apula: kiwa sena noka alekena honosane sita:newa, kili koane sao tima:na:pela: hanapa. ");
INSERT INTO khs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ikila emiwa kesale alelawala, sala kiaiya e amawana, nesile hanakamakiwa hokopesakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nesile fiyama:na: ikila emiwa hano sinisene inakemiwa nesile hanakamakiwa heneye hokopesakeye. Hawa sosolo sinisene ikila emiwa, neiye mene ha:na:pekitise kulukulupa:. ");
INSERT INTO khs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nesile hanapola: sitala ikila emiwa, nano hilila hetetima:na:wa sosolo tepesakeye. Koteyewi peleya: sosolo we ma:ta: ti ikila emiwana, napu yemiwana, nano hilila hetetima:na: amowa puwano eta: alamakeye. Nano hilila hetetima:na:wa kotetipela: sikape aluse hilila mahetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nano hilila hetetima:na: ina ikila emiwa, ikomonose sita: tesene e seyakiwa sena kesale sopoke kupula: itapa tepesakeye. Alawamona, kuluse itapa tema:pekise Koteyewi ta:peya sena kesale amowa matanese ikomoma:na: ikila heka na tiye heka kasa tepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aputa: sena nowamoke kima selese, ‘Kiwa sopoke weyemi pota:pa:. Sena amowa Ewa Kelesokeye.’ Apula:, ‘Kiwa sopoke fatemi pota:pa:. Sena amowa Ewa Piseiki Sosokeye.’ aluse iyewi selesaleke, solo amowa kiyawa ta:tapa. ");
INSERT INTO khs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Alake sena noka, mokopo Keleso amuna tese inaposakeye. Aputa: sena noka, mokopo se tiye kinisene sepatosene sena amuna tese inaposakeye. Inisekiwa sena kesale sopoke ima kulu hanapita:, iyewi nano penanose tisene sosolo nowa timinipesakeye. Timinisewa Kote penaiyawa ima mikeye, aluse sena kesale sopoke howa hanose ima matanemita: timinipesakeye. Koteyewi ta:peya sena kesale iyewi nano alusewa, noka toma potapose sukulu tiye timinipesakeye. Iyewi matanese, ‘Ne sowa ta:tapola:wala, mata:tesewala, ima ta:pele tiyapola: selaposakeye,’ aluse iyewi matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Alake nano amowa seta: hetetima ela:, nano auma:na:wa Neyewi kima selakeye. Seli pota:pa:. Neye sela we kiyawa heneye ta: tiya:pa:,” aluse Yesuyewi sena ilipe hanosema seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesuyewi selese, “Ikomoma:na: ikila amowa itapa tepela: amo fo:su, ‘Ikila opowala nukulapo kuneiwana maho:lilipesakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Meiyetolu hepene falemi tese sululuwalupesakeye. Apula: hepene falemi nano sosolo sitalaka ilelipesakeye.’ ");
INSERT INTO khs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ikila emiwa sena kesale iyewi potakamake Sena Sa: Newa inapita: potaposakeye. Mekifala koiya emi penaiyawanapulu ho:liyawalapulu Newa mina:na:keye. Newa inapita: sena kesale sopoke potaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Newa ina ikila emiwa sena kesale Neyewi ta:peyawa Ne hepene sena mutayewi silima:na: hamonama:na:keye. Hamonapita: iwa inise peleya: sopowemi, fo:su tapowemi sita:newana, fapo helele tapowemi sita:newana, fapo helele tapowemi sita:newana, minitapo tapowemi sita:newana, peleya: sopowemi Neyewi sena kesale ta:pele tiwa hepene senayewi siliyapola: kekenepesakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesuyewi selese, “I kalu amowa pale seya mouwa matanepa:. I kalu falo selese alu tiyakemi potapola: kiyawa matanese, ‘Hepolo tema:na:wa mapatotakeye,’ aluse kiyewi matanesekeye. ");
INSERT INTO khs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Matanese amunuse kiyawa potakamake, nano hilila hetetiyaposakeye au seyawa hetetiyapita: potose, Neyewi nano sopoke auma:na: seyawa mapatotakeye, aluse kiyewi matanepesakeye. Sena koane suwemi musuluma:na:pela: isu tenamowa pa inisene epapuluse mapatotakeye, aluse kiyewi matanepa:. ");
INSERT INTO khs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Neyewi kima heneye selakeye. Sena kesale napuwemi a sitala, iwa seta: kulumake falela apota: epesita:ya kemi, Neyewi auma:na: seyawa hetetiyapita: potapola: iyewi selese, ‘Nano auma:na: seyawa epalakeye,’ aluse kiyewi potapola: matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Alake meiki falala, peleya: weyala itapa tepesakeye. Alawamona Ne sowa maitapa tepesakeye,” aluse Yesuyewi Ene seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yesuyewi selese, “Newa mina:na: okala, opo si awawala, sena kesaleyewi eta: matanesemakeye. Hepene senayawala, Kote E Sa:le Neyawana, eta: matanesemakeye. Ni Ata semeteiyewi Ene ela: matanakeye. ");
INSERT INTO khs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Alanase kiyawa seli pota: sita:latipa:. Newa mene mina:na: ikilawa kiyawa eta: matanamanase seli pota: sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Newa mene mina:na: ikila emiwa auma:na:wa wekeye. Sena makene ha:na:na:pela: ene koawa tima:na: tisene senayewi pota: sita:pesita: apoyakeye. Iyewi nano tisewana eyewi apoyakeye. Isu tenamo pota:tesene senama eyewi selese, ‘Seli pota: elatipa:,’ au selesekeye. ");
INSERT INTO khs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Koane pota:tesene sena mene inaposapekitise pota: sita:latipa:. Ewa opo sinakemiwana, nukulapo honosanewana, kokono kalokemiwana, kiapowemiwana, ewa inapele esa: pota: sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ewa ela:pe kipila inise potakamake, kiwa fayalapita: popa:pekise kiwa pota: sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aluse Neyewi kiwa sena ilipe hanosema seya we sena kesale sopoma selakeye. Solo amowa wekeye. Kiwa sopoke eta: enimake seli pota: sita:latipa:.” Aluse Yesuyewi Ene seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ikila elipei itapa tepela:, ikila nowemi tikina tepesakeye. Puwano fa:nemi Yu sena kesale Isipi peleya: iya:pela: hapalapita:, Koane Helepa:pe Matanema:na:pela: Tikinakeye. Tikina kekenepela: falawa eta: solosema nasekeye. Ikila emiwa pilisiti sena sosowala, Kote solo elewa walosene senawana, iyewi kekelese solo tise, “Yesuwa sana kumita: Ewa ko:luse hopolose saliyaposape? ");
INSERT INTO khs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yemiwa tikina ikila emiwa Yesu saliyakamakiwa eta: ilimanakeye. Alake sena kesale muta kekenawemi niwanapulu tepa:pekise, yemi Ewa eta: salima:na:makeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Petani koamesa: sena nowa unuwa Saimone puwano waka:pila enewa fala:pekeye. Alake Saimone koane Yesu hanapola:, tepolowemi ma:na: na:sela: elapita:, kesale nowa inapola: etewa napolo potolo amuna timiyawa tiyapola: minakeye. Potolo tiyapola: mina emi, wela hene heneye ikumu hoseyawa wasu, moweni sosoyewi wa:la:losewa susa tikeye. Susa tiyapola: potolo hotiyetipela: Yesu piseiwemi sulakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Supita: sena noka sita:neyewi potapola: konomonose i kene sopolo selese, “Kesale amoke ko:lupita: mokopokemi suluse itapa tepe? ");
INSERT INTO khs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wela amowa moweni sosoyewi wa:la:lopela:, yapene semeteiwemi tima:na: tisene heka amowa epapulakeye. Wela amowa sena nowama wa:la:lopela: moweni sosolo tiyapola: sena nano ketea misitiyama miya:na: telakeye.” Aluse iyewi kesalema konomona selese, “Keyawa sena nano misitiyawa eta: sesema:na: telamanapa? Ko:lupita: wela amowa suluse itapa tepe?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Au selapita: Yesuyewi selese, “Kesale amoke ene tima:na:pela: matanawa ko:lupita: kiyawa ewamita: ela: seleseya? Alake kiyawa au selapa. Kesale amoke Ne piseiwemi wela sukamowa heneye napokeye. ");
INSERT INTO khs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aluse sena nano misitiyawa ikila sopoke kiwalapulu kilipe a sitalaposakeye. Alawamona Newa ikila sopoke kiwalapulu ninipe maelaposakeye. Ikila nowemi kiyewi matanese iwa sesema:na:wa ililakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kesale amoke timiyawa ilima:na: telalapita: eyewi timiyanakeye. Ne toma amowa apana tuwapa:na:wa, kesale amoke wela ikumu hosonosene Ne tomawa napola: tese suma:na:wa ta:pela: tese sulakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","We, ta:ta:pa:. Neyewi kima heneye selakeye. Peleya: sosolo weyamo senayewi Newamo matanemita: solo napowa se tiye kinise, kesale amoke wela sulawala, sena kesaleyewi matanemita: iyewi selaposakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sena kukuluipe hanosene semetei nowa unuwa Yutase Isekeliotekeye. Ewa pilisiti sena sosolo sitala emi Yesu sihelelema:na:pela: selapose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Hanapola: selapita: iyewi epelese ta:tapola: ema selese, “Niyewi kema moweni miya:na:keye,” au seyakeye. Au selapita: Yutaseyewi matanese, “Yesu ko:lu sihelelema:na:na?” Aluse matanepela: Yesu sihelelema:na: isu keyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Aputa: tikinise Falawa Eta: Solosema Nasene ma:ta: ti ikila emiwa, a:pele sipi sa:le sanakeye. Ikila emiwa sena ilipe hanoseyewi Yesuma ta:potose, “Koane Helepa:pe Matanema:na:pela: Tikinise ma:na: nasewa Keyawa koane kami kekenema:na: seli tima:na:na?” ");
INSERT INTO khs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aputa: sena ilipe hanosene elipei hamonite Yesuyewi ta:pele tiyapola: selese, “Ka:ko: sitiwemi hamone. Hanapola: potakamake sena nowamoke hano potolowemi wasu tiye uwapola: inapita:, ka:tawa ewa kolupesakeye. Koluye tipela: ewa hanapita:, ewalapulu kilipe ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hanapola: koane nowa musuluyetiye hanapita:, koane inama selese, ‘Walosene senayewi ta:papowa wekeye. Koane Helepa:pe Matanema:na:pela: Tikinima:na:pela:, Ne sena ilipe hanosewanapulu kekenepela:, koane sulu nono kami kekenema:na: ma:na: ma:na:na? Sena makene mina apolosene koane ulutupu nono kaiye?’ ");
INSERT INTO khs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aputa: eyewi ka:ko: siliyapola:, koane wa:pa: fiyanapola: koane ulutupu sosolo walopesakeye. Koane emi seawala, tepolowala, elaka walopesakeye. Walopita: koane emi ma:na: nasene seli tiye tuwata:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aluse Yesuyewi sekepilapita:, sena ilipe sitiwemi hapa elipei amowa hanapola: koane hetetise Yesuyewi auma:na: seyawa, amunuse timinipitekiwa a:tewi papokeye. Koane Helepa:pe Matanema:na:pela: Tikinima:na:pela: a:tewi ma:na: nasene seli tiye tuwapokeye. ");
INSERT INTO khs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Seli tiye tuwatapita: potapola: opo sinakemiwa, Yesu koane inapola:, E sena ilipe hanosene kukuluipewalapulu ilipe kekene tiyapola: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iyewi ma:na: na:sela: tepolowemi ka:la:lopela:ne ikila emiwa, Yesuyewi selese, “Neyewi kima heneye selakeye. Kiyewi sena semetei nowamoke Newanapulu semetei ma:na: nakemi, kiyawa semetei nowamoke Newa sihelelepesakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Au selapita: iyewi himu nakolose ilipe semetei semetei esa: Yesuma selese, “Kewamo sihelelema:na:wa neya?” aluse selese hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sela: hanapita: Yesuyewi selese, “Kiwa sena ka:la:ya yamoke Newa sihelelepesakeye. Neyewi falawa tiyapola: hano wela emi tikipela: amoke, sena nowamokiwala, Newanapulu semetei tiki tisaleke sena epakeye. Eyewi Newa sihelelepesakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Heneye, Sena Sa: Newa kulaposakeye. Newa auma:na:wa Koteyewi se tiye kinisene sepatosene senayewi, Kote pukawemi momatelese apoya, semetei kamunuse kulu hanose aupesakeye. Sena Sa:wa Nekeye. Newa sihelelema:na: sena amowa ewa falasima:na:wa heneye mahepapelepesakeye. Sena epamowa ewa eta: kesilamakiwa amowa ilimapetakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Iyewi ma:na: na:sela: ka:la:ya ikila emiwa, Yesuyewi falawa tiyapola: Kotema napolo esa: kulukululakeye. Kulukuluse itapa tepela: falawa pasoloyetiye sena ilipe hanosema semetei semetei esa: kinise selese, “Falawa we tima. Weyamowa Ne tomakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Apula: kapo waine hawana tiyapola:, Kotema napolo esa: kulukulupela: itapa tepela:, ima kinapita: iyewi sopoke menakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Napita: potapola: Yesuyewi ima selese, “Waine hano weyamowa Ne pepetakeye. Ne pepeta hapa amokiwa sena kesale muta himu olokeyatelawa iya:taposakeye. Ne pepetayewi sena kesale muta mene silima:na:pela: Koteye solo hili sepapokeye. ");
INSERT INTO khs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Neyewi kima heneye selakeye. Waine hano Neyewi wa:ke peleya: weyemi kiwalapulu semetei eta: ma:na:makeye. Sikape Kote Piseikipela: ela peleya: emi Neyewi waine hano weyamowa kiwalapulu semetei sita:la: ma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aluse Yesuyewi selapita:, iyewi Kotema wapilise kisalakeye. Kisapela: itapa tepela:, koawa iya:pela: tokomo Olifiwemi fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sena ilipe hanosema Yesuyewi selese, “Kiyewi sopoke Newa iya:taposakeye. Iya:pa:na:wa Kote pukawemi momateyawa wekeye. ‘A:pele sipi yesila senawa sanowapo ikila emiwa a:pele sipi sopoke netalepesakeye.’ Aluse, Kote pukawemi momateyawa heneye kamunuse aupesakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Auma:na: kamunuse, sikape Newa mene tesilapola:, Kalili peleya: emi Newa puwano hapalapita:, kiwa sikape inapola: ninipe semetei kekenema:na:keye.” ");
INSERT INTO khs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Au selapita: Pitayewi Yesuma selese, “Iyawa sopoke Kewa iya:tesaleke, Neyawa Kewa heneye maiya:taposakeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Au selapita: Yesuyewi Pitama selese, “Neyawa heneye selakeye. Napu nukulapo kokono ikila elipei seta: kayamawemi keyewi selese, ‘Yesu Neyewi eta: potesemakeye,’ aluse ikila usulupewemi mokopo selaposakeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Alawamona Pitayewi penanose selese, “Eh, newa Kewalapulu semetei sana kulusewala, neyewi ‘Yesuwa eta: potesemakeye,’ elawa eta: sema:na:makeye.” Au selapita: sena ilipe hanosene sopoke Pitayewi solo semetei kamo kulu hanose seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu E sena ilipe hanosewanapulu Kesemene peleya: emi hanose Yesuyewi ima selese, “Newa kulukulula:sela: ela ikila emiwa kiwa weyemi sitalatipa:.” ");
INSERT INTO khs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Au seya Yesuyewi Pitawala, Yemesewala, Yonewana, siliye hanose, Yesu Ewa sosolo himu nakolose, eta: epeyamake enekeye. ");
INSERT INTO khs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aluse ela: Yesuyewi ima selese, “Ne himu sosolo nakolose ela:, Newa kuma:na: tekeye. Alake kiwa weyemi ka:la:loma. Kiwa seli potalatipa: eniyapa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Au selapola: apola: Yesu Ewa kolotea hanapola:, panoka:pela:la: mitiwa peleya: opola: ela: kulukulula:sela:, Ema nano hililawa itapa temita: kulukululakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kulukuluse selese, “Ni Atao, Keyawa nano sopoke timiyawa ili tesekeye. Alake Keyawa kapo nano hilila Nema miwa elaka Keyawa iya:ta:pa:, aluse Neyewi matanekeye. Alawamona Ne matanawamunuse aupa. Ke matanawamunuse aupa:.” ");
INSERT INTO khs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aputa: Yesuyewi kulukulupela: itapa tepela:, sena ilipe hanosene usulupe amoke ka:la:lo pela:newanapulu ina:sela: potakamake, iwa fayalapita: papokeye. Potapola: iwa kila:tese Pitama selese, “Saimone, kewa eniya:sela: ela:? Kewa opo si awa semeteiwemi eta: pota:pesene telemanapa? ");
INSERT INTO khs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kima sena nowamoke polusaleke, kiyawa olokeyatela tima:na: tiye ha:na:pekitise, mene tesi tiye hanapola: ela: seli pota:pa: kulukulupa:. Eniyapa. Kili himuyewi napolo matanepela: kulukuluma:na:pela: epeya kamona, tomayewi hopolo tese eniyatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aluse Yesu wa:ke kolotea hanapola: kulukulula:sela:, puwano kulukulula semetei kamunuse kulukululakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kulukuluse itapa tepela:, sena ilipe hanosene ka:la:lo pela:newemi inise potakamake, iwa sopoke fayalapita: papokeye. Aputa: iwa enima:na: tese si sitiyapola: hilise heneye fayakeye. Fayalapota:, Eyewi iwa kila:tese tesilapola: selapita:, iyewi Yesuma solo mene hanose heneye sosolo eta: seli matanamakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ikila usulupe Yesu hanapola: mene inise ima selese, “Kiwa kao ha:le tese fayala? Fayawa kao falome. Kulukuluma:na: ikilawa itapakeye. Sena Sa: Newa sihelelese sena olokeyatelayewi Newa salima:na: ikilawa napu ikila weyalakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kiwa sopoke tesima. Tesilapola: niwa hanakeye. Senayewi Newa sihelelema:na:wa inatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesuyewi seya ikila kemi sena kukuluilipe hanosene nowa unuwa Yutase inapola: Ema sena muta ilipe minakeye. Sena minawa sena nokamoke samene tiyapola: inapola:, apula: sena nokamoke sapa mina elipei senato tiyapola: minakeye. Sena minawa pilisiti sena sosowala, Kote solo elewa walosene senawana, Yu sena tililawala, iwa hamonapita: minakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Sena amowa seta: minama ela: sihelelema:na: sena Yutaseyewi puwano selese, “Sena neyewi mini tisaleke sena epakeye. Ewa saliyapola: siliye ha:na:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Au selapola: Yesu elakemi Yutase hekeya inapola: selese, “Walosene sena,” aluse eyewi Yesuwa minipikeye. ");
INSERT INTO khs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Minitapita: sena sopoke Yesuwa salikeye. ");
INSERT INTO khs_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Saliyapita: E sena ilipe hanosene nowa mapatopita: elakemi eyewi e sapa mina elipei senato sulu tiyapola: tiye, pilisiti sena puwano tima:na: tisene sena kena:wa sapayewi alotiye toliyetikeye. ");
INSERT INTO khs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Alotiye toliyetiyapita: Yesuyewi ima selese, “Kiyawa ami sena sapa senato tiyapola: inapola:, samene tiyapola: inapola:, Newa saliyapose epe iniseya Newa atu tisene senale? ");
INSERT INTO khs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ikila sopoke Kote koawemi ninipe semetei sita:la: Neyewi se tiye kinapita: kiyawa Newa masalisapekeye. Alawamona Kote pukawemi momatelese auma:na: seyawa hetetima:na: iniseya welakeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Au selapita: sena ilipe hanosene sopoke Yesu iya:pela: netaiyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Apula: sala sa:se e sao koiya kapela:, ewa Yesu kulu tiye, ewa sikape hapakeye. Hanapola: sena nokamoke ewa saliyapita: pota: ");
INSERT INTO khs_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sala sa:se e sao koiyawa iya:pela: henese nesile hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Senayewi Yesu siliyapola: hanapola: pilisiti sena sosolo koane, siliye hanapola: potakamake, koane pilisiti sena puwanowana, Yu sena tililawala, Kote solo elewa walosene senawana, kekene tiyapola: sopoke ka:la:lopelelapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesu siliye hanapita:, Pitayewi kolotea pama kulule hanose hapakeye. Kulu tiye hanapola: pilisiti sena puwano koane peleya: pakiawemi hetetise, sena ta:le ti ka:la:lo pela:newanapulu Pitawala henekeye. Tei kiyawemi Pita tei hema henekeye. ");
INSERT INTO khs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Henewanapulu pilisiti sena sosoyawala, Kote solo ele walosene senayawala, Yu sena tililayawala, iyewi sena nokama mina e seyakeye. Sena amoke Yesuma kotopela: tipalese selapose mina e seyakeye. Iyewi matanese, “Sena nokamoke Yesu kotopita: Yesu falasise sana kulaposakeye.” Aluse senayewi tipalese selapose iyewi keyakeye. Alawamona ili kotoma:na:wa eta: ilimanakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sena mutayewi tipalese seya kamunuse iyewi solo semetei seya amakeye. Sena nokamoke solo nowa tipalese seya, alawamona sena nokamokiwala, solo nowa tipalese solo epapuluse solo kalikalila sela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sela: hanapita: sena noka tesile mokopo kotopela: selese, ");
INSERT INTO khs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Niyewi topu wekeye. Eyewi selese, ‘Kote koane senayewi tiya:yewi tiwa Neyewi ekeyetiye, ikila usulupe itapa tepela: Kote koane nowa Neyewi tima:na:keye. Koane amowa tima:na: sena tiya:yewi matiyaposakeye,’ aluse seyawa niyewi topukeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aluse seya kamona, ili solo semetei seya amakeye. Solo kalikalila kalikalila seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Selese sitalapepela: pilisiti sena puwano tesi tiyapola: Yesuma selese, “Kema nano kotosewa Keyewi ena solo mene sema:na:na?” ");
INSERT INTO khs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Au selapita: Yesuyewi Ene nano eta: seyamakeye. Eta: seyamake elapita: pilisiti sena puwanoyewi wa:ke ta:potose, “Piseiki Sosolo ta:peyawa Kelesowa Kewama? Sena Sosolo niyewi wapilisene E Sa:wa Kewama?” ");
INSERT INTO khs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Au selapita: Yesuyewi selese, “Keyewi au sela amowa Nekeye. Keyewi papowa Sena Sa: Newa Kote E penaiyayewi tiya:le ili tapowemi Newa helapita: kiyewi potaposakeye. Hepene emi kiniwaniwemi Newa inapita: kiyewi potaposakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Au selapita: pilisiti sena puwanoyewi ta:tapola: konomonose e sao kalawa keselese selese, “Ewa kotoma:na:pela: sena nowa eta: minama:na:makeye. ");
INSERT INTO khs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Eyewi Ene ela: selese Kotewala, Ewala, elipe semetei kalakeye, au selakeye. Au selakane kiyewi matanawa enana? Niyewi Yesuwa ko:luma:na:na?” Au selapita: iyewi selese, “Ewa Kote elipe ilikeye apula: Ewa sana kula:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Au selapita: sena nokamoke Yesuwa kepesesa:, apula: sena nokamoke Yesu siwemi saoyewi sako tiyapola: ili tiya:yewi Ewa sanose selese, “Kewa sanaka eta:wi sanape? E unuwa sema.” Au selapita: pilisiti sena sosoyewi sena ta:le tiyewi Yesu siliyapola: ili tiya:yewi Ewa sana:sela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yesu kotose ikila emiwa, peleya: pakia hanetapowemi Pita helapita: pilisiti sena puwano tima:na: tisene kesale semetei nowa inapola: potakamake, ");
INSERT INTO khs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita tei kiya emi tei kela:sela: helapita: potapola:, kesale amoke selese, “Nasalete sena Yesuwalapulu hanosewa Kewalakeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Au selapita: Pitayewi eta: auma:na:ma selese, “Keye epe selese amowa newa tikili tekeye. Newa Ewalapulu semetei eta: hanosemakeye.” Aluse Pita tesi tiyapola: hanapola: isu tenamowemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tima:na: tisene kesaleyewi ewa potapola:, wa:ke sena sopoke ta:pita: selese, “Sena epamowa Yesuwalapulu hanosekeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Au selapita: wa:ke Pitayewi selese, “Nemakeye.” Au selapita: kolotea elapepela:, sena pa sita:neyawa Pitama selese, “Keyewi selaka Kalili senayewi selesewamunuse selakeye. Alake Kewa Kalili senanakeye. Kewa Yesuwalapulu hanosenakeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Au selapita: Pitayewi selese, “Newa sena epa eta: potesemakeye. Neyewi mokopo selesalekala Kote Eyewi newa falasipesakeye.” ");
INSERT INTO khs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Au selakamake ikila elipei kokono kayakeye. Kalopita: ta:tapola: Yesuyewi solo miwa Pita eyawa matanakeye. Aputa: puwano Yesuyewi selese, “Kokono ikila elipei seta: kayamawemi, kewa ikila usulupe ‘Yesuwa neyewi eta: potesemakeye,’ au selaposakeye,” e seyawa Pitayewi sosolo kete matanese himu nakolose ya:lakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kiapowemi ikiwatapita: pilisiti sena sosowala, Yu sena tililawala, Kote solo ele walosene senawana, Kanisolo sena sopoke amowa kekene tiyapola: Yesu sana kuma:na:wa kekelese sepapokeye. Selapola: kotetipela: Yesu meiyewi tapola: apola:, Lome sena e unuwa Pailate enene Yesu siliyapola: hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailateyewi Yesuma selese, “Yu sena piseikiwa Kewama?” Au selapita: Yesuyewi selese, “Henekeye, kine epe seleseya kakeye.” ");
INSERT INTO khs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Au selapita: pilisiti sena sosoyewi Yesuwa pepilise nano muta mokopo tipalese seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Alake wa:ke Pailateyewi Yesuma selese, “Iyewi nano sosolo kotoka Keyawa ta:teseya? Keyawa sowa mene sema:na:na?” ");
INSERT INTO khs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Alawamona, Yesuyewi nano eta: seyamakeye. Eta: seyamake solo eta: seyamake potapola: Pailateyewi kete matanese, “Ko:lupita: solo eta: seyama ela:?” Aluse, ewa howa hanose tuteilakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","8","Puwano sena nokamoke Lome kamanima tepele ikila emiwa sena noka sana kulapita: alanase sena nokamoke tipolo selawapokeye. Sena semetei e unuwa Palapasekeye. Eyewi sena nowa sana kulukeye. Sana kulapita: potapola: ewa tipolo selawapokeye. Tipolo enewemi sena mutayewi Pailatema selese, “Koane Helepa:pe Matanema:na:pela: Tikina ikila emiwa tipolo selawapo sena semetei nowa niyawa matanawamunuse silikepime, Au selapita: keyawa silikepilisekeye. Yapene sopoke alusekeye. Napu auma:na:pela: sena semetei silikepila:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Au selapita: Pailateyewi matanese, “Pilisiti sena sosoyewi Yesuma kanakepita: matanese, Ewa kotomita: siliyapola: inapola: emi epese.” Aluse Pailateyewi matanese eyewi ima selese, “Yu sena piseikiwa silikepima:na:na?” ");
INSERT INTO khs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Alawamona pilisiti sena sosoyewi sena sopoke kekenama sele inise selese, “Palapasewa silikepime, aupa:.” Au selapita: iyewi sopoke holose, “Palapasewa silikepime,” aluse iyewi unuwapo holakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Apula: Pailateyewi ima selese, “Kiyewi Yu sena piseikiwa ko:lumeinapa?” ");
INSERT INTO khs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Apula: iyewi unuwapo holose, “Ewa i kelipapoya palese sana kula:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Au selapita: Pailateyewi selese, “Ko:lupita: Ewa sano kula:pa: e sela:? E olokeyatelawa nano ena timiyana?” Au selapita: iyewi wa:ke unuwapo holose, “Ewa i kelipapoya palese sana kula:pa:.” ");
INSERT INTO khs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aputa: sena kesale muta amowa epelemita:, Pailateyewi ili sowa kulu hanose Palapasewa silikepilise, Yesuwa wapa:kemi meiyewi sama, au seyakeye. Sanapita: potapola: selese, “Yesu i kelipapoya pamita: siliye hamone,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ami sena inise Yesuwa kamaniyewi koane sosolo e unuwa Peletoliame, emi siliye hapakeye. Siliye hanapola: koane sosolo emi hetetise, ami sena sopoke kekenema:na:pela: mina e seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Inapita: potapola:, iyewi Yesuwa sao senato napolo i okane fo ipi mutusene epapula amoke popona amo kapela: apola:, itipilise, mei ona tela ha:ti amuna menetepela: tima:na:pela:, kakiwemi inisene aluse inapola: kopo tiye timiyakeye. Timiyawa Yesu piseiwemi fopiyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aluse Ewa itipilise Piseikikeye, aluse matanepela: Ema holose selese, “Yu sena piseiki. Kewa sena Sosokeye.” ");
INSERT INTO khs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aluse Yesu piseiwemi i polotoyewi wa:ke wa:ke esa: sanose, Yesu tomawemi kepesesa:, Ewa piseiki esa: selakamunuse, inapola: kuniu kula:walopela: hela:, iyewi Yesuma mokopo wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Aluse itipilise itapa tepela:, sao senato napolo i okane fo ipi mutusene epapula amoke popona amo tomawemi momateyawa kolu tiye, Eyewi Ene saowa kapela: apola: i kelipapoya pamita: siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yesu i kelipapoya pamita: siliye hanapola: potakamake, isu honosanewemi emi sena semetei nowa e unuwa Saimone. Ewa Sailini taune senakeye. Ewa emi Yelusaleme siti hemawemi enewa inapita: papokeye. Aputa: Saimone e sa:le elipei, nowa Alekesata, nowa Lufase, aluse unuwapokeye. Alake ami senayewi Saimonema selese, i kelipapoyawa tiyapola: ha:na:pa: seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aluse iyewi Yesu siliye hanapola: Kokata peleya: emi hetetikeye. Apula: Kokata peleya:wa hene solopela:la: Pisei Ki peleya:keye. ");
INSERT INTO khs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kokata peleya: emi hanapola: sita:la: waine hano munamuna amunawanapulu kekenepela: notolose notoyalapepela: Yesuma maita: mikeye. Alawamona, Yesuyewi eta: menamakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Aputa: ami senayewi Yesuwa i papeyakeye. Papela: kepela: apola:, Yesu saowa takalese tima:na:pela: iyewi kase fesamonosene epapuluse fesamonakeye. Fesamonose, eye tima:na: keteawa sena semetei semetei esa: ta:peyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kiapo opo si akotawemi iyewi Yesuwa i kelipapoya papeyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Papela: Yesu pisei wapa:kemi falemi Ewa E kotola i pawemi momate tiye weyamu momateyakeye. “Yu sena Piseiki Ekeye.” Aluse momate tiye papeyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Aputa: atu tisene sena elipei Yesuwalapulu i elipei nowa pawayakeye. Papela: nowa Yesu tiya: ili tapowemi papela: kepela:, nowa Yesu tiya: hukalo tapowemi papela: kepela: epapulakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Puwano fa:nemi Yesu seta: minama ela: Kote pukawemi momateyawa wekeye. “Mane olokeyatela timinisene sena alapulu Ewa semetei kamunakeye.” Aluse Kote pukawemi momateyalakeye. Momateya semetei kamona heteti epalakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Aputa: Yesu i papela: pa sena kesale noka hanapola:, Ema itipilise ilikeye piseiwa wakanese selese, “Ilikeye, Keyawa puwano selese, ‘Kote koane ekeyetiye, ikila usulupe itapa tepela: wa:ke titima:na:keye,’ au selesapekeye. ");
INSERT INTO khs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Au seyanase kine mene sesema. I kelipapoya palawa iya:pela: weyemi mina,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aluse pilisiti sosolo senayawala, Kote solo ele walosene senayawala, iyewi i kene sopolo Yesuma aluse itipiyakeye. Itipilipela: selese, “Yesuyewi sena kesale noka seselakeye. Sesela epapuluse Ewa Ene Ewamo aluse masesetakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ewa Ene heneye Kelesoyewi timinisewa timinise e selesaleke, amowa Isolaiya sena kesale amoke Piseiki amowa Ewa Ene e selesaleke, Ewa i kelipapoya palawa iya:pela: minapekeye. Inapita: potosekiwa Eyewi Ene seyawa heneye sepapolakeye au semapekeye.” Aluse iyewi Yesu itipilise sita:nekeye. Aputa: Yesuwalapulu papela: senawala Yesuwa itipilise seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Peleya: sopoke eleka:le kukuwemi (12) ma:ta: tiye yopoyakeye. Yopolotela ela: opo si awa usulupe amowa yopolotela enekeye. ");
INSERT INTO khs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Enewa ka:le opo si usulupe iya:pa:na: pa tepita: Yesuyewi Yu sena solopela:la: unuwapo holose, “Eloi, Eloi, lama sapakatani?” Aluse hene solopela:la: selese, “Ne Koteo. Ne Koteo. Keyawa Newa ko:lupita: iya:teseya?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Au selapita: ta:tapola: sena kesale noka pawemi sita:neyawa selese, “Ta:pa. Eyewi Ilaiyawa hotakeye.” ");
INSERT INTO khs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Au selapita: sena semetei nowa kipila hanapola: hano sipanese epapula waine hano ha:ka:la emi tikipela: mawa tuwemi sakopola:, Yesuma maita: tili tiye falemi ilikepiyakeye. Tili tiyapola: a falemi eyewi selese, “Asepakeye. Sepatosene sena Ilaiyayewi Yesuwa fake tiyapose inapele esa:, niwa yemi yesipela: sita:pesena:keye.” ");
INSERT INTO khs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aputa: potakamake Yesuyewi unuwapo holose kemi Yesu E himu hepa:lese heneye himu hepa:la ulutilapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aputa: Kote koane sao telepeyawa falemi tese keseleye tikeye. Keseleye tiye nono pa:ta, nono kalilakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aputa: ami sena yesila ewa Yesu mitiwa hekeya ela: potakamake Yesu kulapita: potapola: selese, “Neyewi heneye selakeye. Sena amowa heneye Kote Ene Sa:keye,” aluse eyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aputa: peleya: kolotea pa kemi kesale nokala pota: sita:nekeye. Potapola: ka:la:lopela:ne kesale amowa nowa Makatala kesale Melikeye. Apula: nowa Meli, Yemese Yosepe eli yokeye. Apula: nowa kesale Salomekeye. ");
INSERT INTO khs_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Apula: puwano Yesu Kalili peleya: hapa ikila emi, kesale usulupe amoke Ewalapulu ilipe hanapola:, Ewa nano ma:na: satapola: mikeye. Apula: Yesu Yelusaleme sitiwemi mina ikila emiwa, Ewalapulu ilipe mina kesale nokamokiwala, matanese pota:sela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Alamatia sena Yosepewa ewa Felesi senawanapulu Kote solo ele walosene sena alapulu ilipe kekenepela: tima:na: tisekeye. Tima:na: timinise e unuwa sosolo telakeye. Aputa: Koteyewi Piseikipela: pota: epesene ikila amowa hetetimita: Yosepe yesipela: enekeye. Eyewi matanese, “Napu ka:le opo sinakemiwa napu yopolotelawemi ha:le tesene ikilawa ma:ta: tiyaposakeye. Ma:ta: tima:na:nase ha:le tema:na:ke yemiwa nano sopoke tiyapola: kekenanakeye.” Aluse matanepela: eyewi tutumanose eta: ipilamake Pailate ela hanapola: selese, “Yesu kuluwa apana tuwapa:na: neyewi tiyapola: ha:na:na:wa ililapa?” ");
INSERT INTO khs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Au selapita:, Pailateye ta:takamake Yesuwa kulu e selapita: ewa howa hapakeye. Aluse Eyewi ami sena yesilama mina e seyakeye. Inapita: potapola: Pailateyewi ema selese, “Yesu heneye kululule?” ");
INSERT INTO khs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Au selapita: yesilayewi selese, “Henekeye, heneye kulukeye.” Au selapita: ta:tapola: Pailateyewi Yosepema selese, “Yesu kuluwa keye tiye hanasaleke ililakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Au selapita: Yosepe hanapola: sao koiya napolo wa:la:lopela: tiyapola:, Yesu i palawa fake tiye, tiyapola: hanapola:, sao koiya napolo wa:la:ya amoke Yesu sako tiyapola: tiye hanapola:, etewa apana puwano ta:la emi Yesu tuwapokeye. Tuwapola: apola:, apana sulu etapema:na:pela:, etewa sosolo pale kepele tiye hanapola:, apana uwalokemi etapeyakeye. ");
INSERT INTO khs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Etapela: Makatala kesale Meliwala, Yosepe e ama Meliwala, a:tewi Yesuwa apana tuwatapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ha:le tesene ikila itapa tepela: Makatala kesale Meliwala, Yemese e ama Meliwala, Salomewala, iyewi Yesu tomawemi wela ikumu hosonosene napolo ta:tesewa wa:la:yakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sokatiye hili ma:ta: tisene ikila emiwa kiapo ikiwatapita:, oka heli sesalose inakemi kesale usulupe amoke Yesu apanawemi tuwapo emi potapose hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ha:na: sita:la:, kesale ili usulupe amoke ilipe sopolo selese, “Etewa apana etapeyawa eta:wi niwamopela: hemawemi kikilitiye apolaposape?” ");
INSERT INTO khs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Alawamona matanepela: ha:na: potakamake, etewa apeya sosolo amowa hemawemi kikilitiye mowa tapowemi elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Potapola: kesale usulupe amowa apana suwemi musuluyetiye potakamake, sena sa:se sao koiya kapela:, tiya: ili tapowemi helapita: potapola: kesale usulupe amowa howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Howa hanapita: eyewi ima selese, “Titoulupa. Nasalete sena Yesu i kelipapoya palese sana kuluwa, kiyewi potapose inatakeye. Ewa mene tesitiye hapakeye. Ewa weyemi maelakeye. E toma tuwapowa potapose mina. E toma weyemi itapakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Alawamona E sena ilipe hanosemawana, Pitamawana kiyewi selapose hamona. Yesu puwano Kalili peleya: emi hanapola: enewemi kiwa sikape inise, Kalili peleya: emi kiyewi Ewa potaposakeye. Ewa seta: kulumake Eyewi puwano se tiye mini semetei kamona aupesakeye.” ");
INSERT INTO khs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aluse selapita:, kesale usulupe amokiwa apana amowa iya:pela:, ipilise nesile hanose, kiwa pipilise himunama tese hapakeye. Ha:na: sita:la: ipilise sena kesale nokama nano nowa eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tomo ikila emiwa Yesu mene tesile hanose sena kesale nokamoke Ewa popita: Ewa hetetikeye. Makatala kesale Meli puwano ho olokeyatelawa tomoipeyewi ewa ho fiyanewa, Yesuyewi ho olokeyatelawa hamonapita:, ho olokeyatela hapakeye. Kesale Meli amowa ewa popita: ewa ela Yesu hetetikeye. Hetetiyapita: kesale amoke ewa papokeye. ");
INSERT INTO khs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Potapola: hanapola: Yesu E sena ilipe hanosene iwa sita:newemi kesale amowa hetetikeye. Hetetise eye potakamake iyewi Yesupela: himu nakola sosolo ya:pelepita: papokeye. Potapola:, kesaleyewi ima selese, “Yesu mene tesile hapalapita: neye papokeye.” ");
INSERT INTO khs_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Au selapita: iyewi ta:tapola: kemi henenapo, aluse eta: matanemakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Sikape, sena elipei Yelusaleme siti iya:pela: mowa hanapita:, a:tewi Ewa popita: Yesu E toma kali tepela: hetetikeye. Hetetiyapita:, a:tewi Ewa papokeye. ");
INSERT INTO khs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Potapola:, a:ko: Yelusaleme sitiwemi mene hanose sena ilipe hanosema Yesu papowa a:tewi seyakeye. Alawamona, selapita: iyewi eta: seli topumakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sikape, sena ilipe hanosene kenenipe tepolowemi ma:na: na:sela: ka:la:lopelelapita: potapola:, iyewi Ewa popita: Yesu iwa ka:la:lopela:ne hetetikeye. Alake sena kesale nokamoke Yesu teisa:pewa papokeye au seyawa, iyewi eta: seli ta:timanase Yesuyewi ima selese, “Kiwa ko:yale? Kiyewi matanema:na mapolosewa ko:lupita: e seya:?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aluse Yesuyewi ima selese, “Peleya: sopowemi kiwa hanapola:, sena kesale sopoma Newa matanemita:, solo napowa se tiye kina:pa:. ");
INSERT INTO khs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Se tiye kinapita: sena kesale nokamoke ta: tiyapola:, iwa hano toliyetiyakemiwa, iwa Kotema kao sita:pesita:, Koteyewi iwa mene siliyaposakeye. Alawamona, sena kesaleyewi ma seli ta:tiyapitekiwa Koteyewi iwa falasipesakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aputa: ta: tisene sena kesalema Koteyewi penaiya miya:na:wa wekeye. Nema himu semetei esa: matanepela:, Ne unuwa tuwapowa penaiyanase, Ne unuwa sepela: ho olokeyatela hamonapita: hanaposakeye. Aputa:, Kote penaiyaye solo hili kalikalila kiyawa selaposakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aputa: Kote penaiya nowa miya:na:wa wekeye. Heseke amowa tiya:yewi tiye tilitikeye. Apula: senayewi kulusene hano napita: manakopesakeye. Iyewi tiya:yewi sena kesale nakola towayawa saliyapita:, ili nakola towayawa itapa tepesakeye.” Aluse Kote penaiya miya:na:wa Yesuyewi ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Piseiki Yesuyewi ima nano selese itapa tepela:, Ewa hepene falemi tese Koteyewi silikeye. Silinase Ewa Kote tiya:le ili tapowemi helakeye. ");
INSERT INTO khs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aputa: sena ilipe hanosewa hanapola:, Yesu solo amowa peleya: sopolo sena kesale sopoma se tiye mikeye. Iyewi se tiye kinapita: Piseiki Yesuyewi iwa seselakeye. Iyewi Kote penaiyayewi matanawamuna timinimita:, Piseiki Yesuyewi iwa seselese penaiyawa ima mikeye. Alake iyewi penaiya timinisaleke, sena kesale sopoke potapola: matanese, “Koteyewi ima penaiya minase Kote solo amowa iyewi se tiye epe kiniseya, heneye selesekeye,” aluse matanesekeye. ");
INSERT INTO khs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Sena sosolo Tiafolaseo, puwanowa, sena mutayawa tiya:yewi ta:pelesa: pula walawa nano ketea sopoke nini honosanewemi Koteyewi timini tiye hetetikeye. ");
INSERT INTO khs_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ma:ta:tiwemiwa ili siyewi nano ketea amowa papowa nima se tiye mikeye. Sena ili tima:na: tisene amowa Kote sowemi tima:na: tisekeye. ");
INSERT INTO khs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Alanase, neyawana ma:ta:tiwemiwa nano ketea amowa sopoke seli matanema:na:pela:, apula:, neye matanawa pula hekeya wala kema momatekeye. ");
INSERT INTO khs_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ko:yawemiye, keyawa nano ketea sopoke keye waiya amowa neyawa keyawa seli matane tiya:pa:. ");
INSERT INTO khs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Helotewa Yutia peleya:wemi kini enene ikila emiwa, pilisiti sena semetei nowa enene e unua Sekalaya. Ewa Apaisa sena maya ili pilisiti; Ekewa Alone mayakeye e unua Elisapete. ");
INSERT INTO khs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","A:ko: Kote sikapowemi hekeya sena kesale enene. A:tawa Kote solo mane sopoke kulu hanose Kote elewala sopoke kulu hapa, apula:, a:tawa hele timiya nowa itapa. ");
INSERT INTO khs_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Alawamona a:tawa salawa eta: kesilama, Elisapetewa ini telanase apula:, a:ko: ela:pe tilila tela. ");
INSERT INTO khs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ikila nowemi Sekalaya e maya iwa pilisiti tima:na: epela: hapa, apula:, Sekalaya ewala Kote sikapowemi pilisiti tima:na: ti. ");
INSERT INTO khs_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pilisiti sena mane iliwa Kote koane suwemi sena nowa emi musuluyetiye ikumu napolo hoseya sapa:na:pela:kiwa etewa satukalepela: emi tipipilisene. Tipipili tiyapola: Sekalayawa ta:pele tiye apoya. Apula: eyawa Kotema mokopo miya:na:pela: Kote koane suwemi musuluyetiye hapa. ");
INSERT INTO khs_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kotema ikumu napolo hoseya mokopo miya:na: ikila emiwa, sena kesale muta Kote koane hema emi kekene tiyapola: kulukulula:sela: sita:nene. ");
INSERT INTO khs_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Apula: kulukulula:sela: sitalapita:, Kote E hepene sena semetei nowa tepolo amuna timiya wa:pa:se Kotema ikumu napolo hoseya mokopo miya:na:pela: satosene, tiya: ili tapowemi ine heteti. ");
INSERT INTO khs_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aputa:, Sekalayayawa ewamo potakamake howa hanose tutelise ipila ilima tela. ");
INSERT INTO khs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Alawamona, hepene senayewi ema selese, “Sekalaya, kewa ipipa. Keye kulukululawa topukeye. Ke kesale Elisapeteyawa senase kema kesa:taposakeye, aputa: keyawa Yone unuwata:pa:. ");
INSERT INTO khs_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sala emawa keyawa sosolo epelepesakeye. Ewa supeliwata ikila emiwa sena kesale sopoke ewa potose epelepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ko:yawemiye, ewa Kote sikapowemiwa sena sosolo tepesakeye. Sala eyawa waine hano epela: hano olokeyatela noka manaposakeye. Aputa: ewa e ama kupu sulu fa:nemi ke ela: ikila emiwa Ho Napowa woliyetiye elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eyawa Isolaiya sena kesale mutawa sopoke Kote Sosolo salo mene siliyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eyawa Ilaiya e mane alapulu apula: e penayawalapulu amowa Eyewi tiyaposakeye. Apula:, Ewa Yesu Keleso puwano putupela: hanaposakeye. Sala inayawa e sa:walapulu himu hapa matesaleke, Yone eyawa ina matanawa me notoloyetiye e sa:ma kinaposakeye. Apula:, Yone eyawa sena solo seya ta:te iya:tesene iye matanawa me heka:taposakeye. Apula: iyawa sena napolo hekeya matanasene aluse tiyaposakeye. Alanase, eyawa sena kesale sopoke seila:walo tiyapola: Sosolo Yesu emi minita:.” ");
INSERT INTO khs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Hepene senayewi au selapita:, Sekalaya ema ta:potose, “Neyawa ke solo selesewa henenapo esekiwa ko:lu matanema:na:napa?” e seya. “Newa sena tililakeye apula: ne kesalewala kepeyasokeye.” ");
INSERT INTO khs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kote E hepene sena mene selese, “Ne unua Kepiyalokeye. Newa Kote minitapo tesekeye. Kote ene ela: newa hamona e selapita: inakeye. Alanase, newa inapola: kema selakeye. Apula: solo napolo weyamowa kema se tiye kinakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Aputa:, ta:pa. Keyawa ne solo seyawa maseli ta:te selapita:ke, alanase, kewa meaka kata tiyapola: solama tepesakeye. Apula: ha:na: tese nano ketea epe selakamowa sopoke ha:na: iliye tise itapa tepesakeye. Ne solo we heneye hetetiyaposakeye Koteyewi ta:peyawamunuse. ");
INSERT INTO khs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Napu semetei kemi, sena kesalewa Sekalaya yesiwapola: sita:la:. Iye matanesekiwa Kote koane suwemi hapawa ela:pe mainatape esa: matana:sela: sita:nene. ");
INSERT INTO khs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","O:la:sela: sita:newemi, Sekalayawa Kote koane suwemi musuluyetiye inisekiwa iwalapuluwa sowa eta: seyama. Iye matanesekiwa Kote koane suwemi hapa emiwa uwa koane nano nowa papolapo esa: matanakeye. Ko:yawemiye, eyawa sowa eta: seyamake papolo tiya:yewi walo selapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ikila Sekalaya eyewi pilisiti sena tima:na: tiya:newa kopela: koane meneye tiye hapa. ");
INSERT INTO khs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Amo fo:suwemi, ekele Elisapetewa salawa alela. Apula:, ewa kunei pipe enene emiwa ewa o:sulu enekeye. ");
INSERT INTO khs_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kote Sosolo eye kokonawa nema mikeye,” Elisapete eyawa au seya. “Ikila emiwa Koteyawa himu hapawa nema waya. Apula: sena kesale sikapowemiwa ne ewala tiwa. Eyewi tiye iya:peyekeye.” ");
INSERT INTO khs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Aputa:, kunei tekakemi Elisapetewa alela ela:, Koteyawa e hepene sena Kepiyalowa Kalili peleya: Naselete koamesa:wemi ilikepiya. Hepene sena ewa kesale pola semetei nowa senawanapulu eta: hanosema salo hapa. Kesale ewa kini Tepiti sena i ama semikeye. Sena amo unua Yosepe. Kesale pola amo unua Meli. ");
INSERT INTO khs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Apula:, Hepene senawa e salo hanapola: selese, “Ikilale napolo, kewa Kote sikapowemiwa hekeya kesalekeye. Alake, Sosowa kewalapulu elakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Au selapita:, Meliyawa sosolo kete matana e seya amo ta:tapola: ilima tela. Apula: eyewi matanesekiwa ena selape esa: matana. ");
INSERT INTO khs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Alawamona, Hepene senayewi ema selese, “Meli, kewa ipipa. Koteyawa himu hapawa kewalapulu elakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ta:pa! Kewa sala alepela: elapepela: salawa senase keisa:taposakeye. Apula:, keyawa Yesu unua ta:pa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ewa Sena Sosolo elaposakeye. Apula:, ewa Kote Sosolo falamo E Sa:keye e selaposakeye. Kote Sosoyawa Yesuwa kini temita: apolosekiwa e kouwa kini Tepiti enene amuna tepesakeye, ");
INSERT INTO khs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ewa Yakope sena i amo kini kokolo kau elaposakeye. E kini tima:na: tiwa maitapa tepesakeye,” hepene senayawa au seya. ");
INSERT INTO khs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Au selapita:, Meliyewi hepene senama ta:potose selese, “Newa senawanapulu seta: hapama weyemiwa salawa ko:lu alema:na: telalapa?”, e seya. ");
INSERT INTO khs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Hepene senayewi mene selese, “Ho Napowa ke salo inapola: Kote penaiya falamoke fopula: elaposakeye. Alanase, sala keyewi kesipesa epamokiwa hekeya napolo tepesakeye. Aputa:, Ewa Kote E Sa:le e selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ta:pa. Ke nane Elisapetewa kepeyasowamona salawa alelakeye. Puwanowa iye selesekiwa salawa eta: kesima:na: telamanakeye, e seya. Alawamona, naputewa ewa sala alela ela: kunei tekapeipewa itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ko:yawemiye, Koteyawa nano ketea sopoke iliye tiye timinisekeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aputa:, Meliyewi mene selese, “Ta:pa. Newa Sosolo tima:na: tisene kesalekeye. Keye epe seleseya Koteyawa newemiwa ili timinipesakeye,” e seya. Apula:, hepene senayewi ewa iya:pela: hapa. ");
INSERT INTO khs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ikila emiwa, Meliwa seli tiye Yutia koamesa: semetei tokowemi kipila hapa, ");
INSERT INTO khs_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","apula:, ewa Sekalaya koane suwemi hanapola: Elisapete potapola: ikilale napolo e seya. ");
INSERT INTO khs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Au selapita:, Elisapete ta:takamake, sala keaya e kupu suwemi tanewa sipa:kuya. Aputa:, Elisapetewa Ho Napowa woliyeti. ");
INSERT INTO khs_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisapeteyewi sowa unuwapo selese, “Kesalela: sopoke Koteyewi potosewamona kewane heneya sosolo seselese napola:takeye. Apula: sala keaya keyewi kesipesa epamokiwala Kote seselese seila:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Newa itapa. Apula: sena Sosolo yowa ne salo inisewa ko:yawemiye? ");
INSERT INTO khs_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Keye selese, ‘Ikilale napolo,’ e seya epamowa ne kena:yewi ta:tapola:, sala keaya ne kupu suwemi taneyawa epelesa: sipa:kulukeye” e seya. ");
INSERT INTO khs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Meli, keyawa nano ketea sopoke auma:na: e seyawa Kote Sosoyawa kema seya amowa aupesakeye esa: seli topu. Epemi ela: keyawa henenapo esa: epelema. ");
INSERT INTO khs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aputa: Meli selese, “Ne himuwamokeyawa Sosolo unua wapilikeye. ");
INSERT INTO khs_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Apula: ne howa epeya sosolo telakeye ko:yewemiye Kote ene ela: newa mene silinase. ");
INSERT INTO khs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Newa ene tima:na: tisene kesale. Ne unua sosomakeye. Alawamona, Koteyawa newa sosolo matana:sela: elakeye. Napuwemiwana sikapewana sena kesale e sola sopoke iyawa au selaposakeye, “Koteyawa epeya sosowa nema mikeye,” e selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kote Penaiya Ilima Eyawa nano sosolo keayamawa newamopela: timiya. E unua Kalaiya Papalola napolo sopolo elakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ikila yemiwana sikapewemiwana sena kesaleyewi Kote unua wapilisaleke, Eyawa iwa hauwekilise Sosolo seselesenekeye. ");
INSERT INTO khs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kote ene tiya:yewi talapoiya tima:na: ti alanase, sena kesale eta:wiye matana honosane fa:nemi ene unua sosolo temana esa: matanesene, sena kesale amowa Koteyawa alutaletiye ilikepilisene. ");
INSERT INTO khs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Sena kini seawemi helesene amowa Koteyawa ewa iya:taposakeye. Alawamona, sena kesale eta:wiye ene ewa me sinapola: elaleke, Koteyawa ewa e unua me tila:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sena meina sitalakamawa nano napowa katalo kinanapeyapola: teila:walotiye apolosene, alawamona, sena kesale nano ketea mutalo tela, amowa Koteyawa mokopo ilikepeya. ");
INSERT INTO khs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Eyawa e tima:na: tisene sena Isolaiyawa sesela. Apula:, Eyawa nini kouwa Epalahame ima sepapowa a matanepela: enene. Apula:, Eyawa sena kesale sikape hetetima:na: epamowa kokolo kau tesene kokona ewamokiwa eta: kepoliyetimakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meliwa Elisapetewalapulu sita:nene emiwa kunei usulupe tukuyetiye apula: ewa ene peleya:wemi mene hapa. ");
INSERT INTO khs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sala ha:na:na: ikila emiwa Elisapeteyawa senase supeliwapo. ");
INSERT INTO khs_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aputa:, e sena kesale maya semetiyawala ilipe enisene sena kesale iyawala sopoke Koteyewi kokona ema mi amo ta:tapola:, iyawala ewalapulu epeyawa ilima tela. ");
INSERT INTO khs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","60","Olo ikiwapowemi iwa inapola: sala keaya kapo nama:na:pela: mina, apula:, iyawa ina Sekalaya unuwapa:na:pela: ela, alawamona, sala yoyewi selese, “Eh, Yone unuwapa:na:keye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iyewi ema selese, “Sena maya i kiwemiwa Yone etaiyawa itapakeye.” ");
INSERT INTO khs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Apula:, iyawa tiya:yewi inama walo selese, “Salawa ipi unuapa:na:na?” esa: walo selakamake. ");
INSERT INTO khs_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Eyawa nano momatema:na: keteyawa haya. Halotiyapola:, momatepita: potakamake, Yone unu tuwatapita: papo. Apula: iyawa matanawa ilima telakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Komayama kemi, Sekalayawa e tekala meakala napolo me tepela: sowa wa:ke me seya. Apula:, Kote unua wapiya. ");
INSERT INTO khs_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aputa: ikiwapo kemi, sena kesale ilipe sita:ne amoke potapola: ipila ilima telakeye. Nano papolo amowa sena kesale sopoyawa Yutia koamesa: tokowemi tisateya hapa imawana sopoke sekoya hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iyawa solo seya amo ta:tapola:, ikene kete matane se selese, “Sikapewemiwa sala we ikamuna tepesape esa: matanakeye. Ko:yawemiye, iye matanesekiwa Kote penayawa ewalapulu elatapo esa: matanakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yone ina Sekalayawa Ho Napowa woliyetiyapola: Kote solo sepapolo sowa selese, ");
INSERT INTO khs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Niyawa Sosolo unua wapilima, Isolaiya Kotewa, ko:yawemiye Ewa inapola: e sena kesale sopoke mene silikeye. ");
INSERT INTO khs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Koteyawa E tima:na: tisene sena Tepiti maya sena i emiwa sena penaiya semetei nowa niwamo mene silima:na:wa hetetiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Amowa puwano fa:nemi Kote e sepatosene senala: kalaya hekeya iyawa au seyakeye), ");
INSERT INTO khs_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Eye selesekiwa niwa kisi sena tiya:wemi sita:newa mene silima:na:keye, apula: sena niwanapulu mapolo matanesene tiya:wemi sita:newana mene silikeye. ");
INSERT INTO khs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Eyawa nini kouwawa kokonose iwa seselakeye. Apula: Eyawa E sepapo solo ho:liya ene puwano timiya amowa a matanepela: enene. ");
INSERT INTO khs_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Koteyawa sepapo amowa nini kouwa Epalahamema hekila sosolo fala kamo e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eyawa niwa kisi tiya:wemi sita:newa mene silima:na: matanakeye. Apula: niwa Ewamopela: tima:na: tiya:selekiwa ipipa. ");
INSERT INTO khs_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Alanase, ikila sopoke nini hepa:la kokolo kau tesene, niwa mane hekeyawemi Kote sikapowemi ha:na:pa:. Apula: niyawa Kote E mane seli napolo woliyetiya:pa:. ");
INSERT INTO khs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Apula:, ni sa:le, sikapewemiwa iyawa kewa Kote Falamo e sepatosene sena unua taposakeye. Ko:yawemiye, kewa Yesu puwano putupela: ewamo mina:na: isu seli timita: ha:na:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Hanapola:, keyewi e sena kesale sopoma matana miya:na:pela: sema:na:wa, “Sikape sena nowa epe ini seyamowa kiwamo mene siliyaposakeye. Mene siliyapola:, kili olokeyatelawa Eye tiye iya:taposakeye.” Aluse, sala weyamoke selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ko:yawemiye nini Koteyawa niwamo sosolo hauwekilise kokona Ewa nima kinisene. Alanase, hepene falemi opo si ho:liya fiya tepela: ni salo inaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Inapola:, ho:liya amoke sena kesale yopolotela honosanewemi sita:nene iwa ho:lili wataposakeye. Kululu ho tapo sita:newa ho:liya amoke iwala ho:lili wataposakeye. Apula:, ho:liya amoke nini onatu onatiye ha:na:na:wa hopola tema:na: isuwa amoke walopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aputa:, sala Yone ewa solo tepela: e howa penaiya talapo tiyapola: enene. Apula: ewa senanama peleya:wemi ha:na: enapotane enene. Elapepela:, sikapewemi ewa Isolaiya sena kesale sikapowemi ine hetetikeye. ");
INSERT INTO khs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ikila emiwa, Sisa Okatase, ewa Lome sena kesale piseiki epela: enene. Eyawa solo ele nowa tuwa tese sena kesale Lome peleya: honosanewemi sitalaka sopoke unu tiya:pa:, e seya. ");
INSERT INTO khs_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sena kesale unua tuwapa:na: e seya amowa, kamani sena Kuliniase ewa Silia peleya: pota: epesene ikila emiwa, eye pota:la:kiwa napu semetei kemi ma:ta: tiye unua kemi tikeye. ");
INSERT INTO khs_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aputa:, sena kesale sopoke i peleya:wemi unua momatema:na:pela: hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosepe ewa kini Tepiti sena i akeye. Alake, Yosepe ewala Naselete koamesa: Kalili peleya: amowa iya:pela; Petiliheme koamesa: Yutia peleya:wemi hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hanose, e kesale simini Meliwa sala alelawalapulu siliyapola: unua momatema:na: epela: elipe hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hanapola:, a:ko: Petilihemewemi sita:newanapulu Meliwa sala ha:na:na: tela oko: emi heteti. ");
INSERT INTO khs_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ikila emiwa, makene hanapola: enisene koawa teleya: tilapita: potapola: a:ko:mo enima:na: fowa itapalapita: potapola: a:ko: kopolo kao koane ha:na: ka:la:lopela: enene. Ka:la:lopela: enewanapulu e sa:le ola:ko: senase supeliwapo. Supeliwatapita: kopolo kao ma:na: nasene pokose tuwapowemi sala keayawa tapolayewi sako tiyapola: pokose suwemi tuwapo. ");
INSERT INTO khs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ikila emiwa, a:pele sipi pota: tesene sena noka Petiliheme koamesa: pa hema kemi sita:nekeye. Iwa yopolotela honosane a:pele sipi pota:sela: sita:ne. ");
INSERT INTO khs_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pota: sita:newanapulu, Kote E hepene senawa i salowemi ine heteti. Apula: hepene falemi Kote E ho:liyawa inapola: iwa sita:newemi ine hekeye tiyapita: potapola: iwa ipilawa ilima tela. ");
INSERT INTO khs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aputa:, hepene senayewi ima selese, “Kiwa ipipa. Kiwa solo napowa neyewi kima tiye inakeye. Solo amowa sena kesale sopoke kiyawala ta:tapola: sosolo epelepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Napuwa, Tepiti koamesa: Petilihemewemi, senase supeliwapokeye. Sala amokiwa sena kesale kiwa sopoke mene siliyaposakeye. Ewa Sosolo Yesu Keleso. ");
INSERT INTO khs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Alake, solo we henenapo esa: matanema:na:wa wekeye, kiwa Petilihemewemi ha:na: potakamakiwa sala keaya tapolayewi sako tiyapola: kopolo kao ma:na: nasene pokose suwemi telapita: potaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kipila kemi, hepene sena muta noka kemi ine hepene sena alapulu ine sitalapita: papo. Apula: iyawa Kote unua wapilise sela:sela:, ");
INSERT INTO khs_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kote Sosolo faleyamo unua wapilima. Apula: sena kesale peleya: sosolo weyemiwa hopola sita:laposakeye. Koteyawa iwa himu hapawa elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Apula: hepene sena iwa hepene falemi meneye tiye ha:na: tipita:, a:pele sipi pota: tesene sena ikene selese, “Niwa Sosoyewi solo epe selakamo potapose Petilihemewemi hanakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Apula: iwa kipila hanapola: Meli Yosepe a:tawa sala keayawalapulu kopolo kao ma:na: nasene pokose suwemi telapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iyawa sala amowa potapola:, hepene senayewi sala amo solo seyawa ima se tiye miwa sopoke sena kesale sopoke ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sena kesale sopoke a:pele sipi pota: tesene sena ili solo seya amo ta:tapola:, iyawa kete matanawa ilima tela. ");
INSERT INTO khs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Alawamona, Meliyawa solo seya amowa sopoke e himu sulu fa:nemi selawapola: matana:sela: enene. ");
INSERT INTO khs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Apula: a:pele sipi pota: tesene sena iwa mene ha:na: tise Kote unua wapilise hapa. Ko:yawemiye, iye nano ketea sopoke iyewi topuwa paponase. Papolo amowa hepene senayewi ima seyawamunuse hetetikeye. ");
INSERT INTO khs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ikila sala supeliwapowemi ma:ta: tiye akeye hapawa ikila owemi puwano salawa kaka nanese unua tese Yesu unuwapo. Ewa yoyawa seta: alelama ela: hepene senayewi puwano fa:nemi unuwapokeye. ");
INSERT INTO khs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ikila Moseseyewi ele tuwapowa matanese Yosepe Meli a:ko: Kote sikapowemi hili napolo tepela: ikila amowa kotetipela:, sala keayawa tiyapola: Yelusalemewemi Kote Sosoma miya:na:pela: hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","A:tawa Kote solo ele tuwapo amo kulu hapakeye. Ele tuwapo solo amokiwa weyamu seya, “Sala senase puwano yoyewi kesilawa, Kotema kina:pa: esa: sepapo. Apula: ewa ho:liya elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Apula: a:tawa a:nema:wana mokopo miya:na:pela: ko:yawemiye Kote ele tuwapowemi ela:. A:nema: Tumu elipei o kipiato e sa:le elipei tiye hapa.” ");
INSERT INTO khs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ikila emiwa hekeya sena nowa Yelusalemewemi enene e unua Simione. Eyawa Kotema kulukulusene. Ewa Isolaiya sena kesale hopola napolo tiye miya:na: sena amo yesipela: enene. Apula: Ho Napowa ewemi woliyetiye enene. ");
INSERT INTO khs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aputa:, Ho Napoyewi ema seya, “Kewa kipila sema kulaposakeye. Puwanowa Sena Koteyewi sepatose e sena kesale mene silimita: ilikepima:na: e seya sena amowa Kote E Kelesowa potaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Apula:, Ho Napoyewi ewa siliye Kote koane suwemi hapa. Hanapola: enewanapulu, Yosepe Meli a:tawa Yesu keayawa tiyapola: ele tuwapo solo amo kulu hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ikila emiwa, sala keayawa Simioneyewi talo tiyapola: Kote unua wapilise napolo e seya. ");
INSERT INTO khs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Eyawa sela:sela:kiwa, “Sosolo, Newa ke tima:na: tisene senakeye. Alanase, napuwa Kewa newa ili hamonote apola:pa:. Apula: ne matanawa hopola apola:pa:. Ko:yewemiye kine puwano sepaponase. ");
INSERT INTO khs_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ne siyawa nano ketea Kine ela: timiya amoke niwa mene silima:na: e seya amowa papokeye. ");
INSERT INTO khs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kine Keyawa nano we sena kesale sopoke sikapowemiwa seli tikeye. ");
INSERT INTO khs_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ho:liyawa amunawa Ene ekeye. Apula: nano ketea o:sulu mupapo Eyewi Yu sena kesalema walopesakeye. Alanase, Eyawa Yu sena kesale kiwa unua sosolo unuwataposakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simione solo seya amo ta:tapola:, sala ina yoyeliyawa ena selape esa: matanwa ilima. ");
INSERT INTO khs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simioneyewi Yosepe Meli a:ma selese, “Kotewa ka:ko:lapulu elaposakeye,” e seya. Apula:, Yesu yo Melima selese, “Koteyewi sala amowa ta:pele tiye apolose selese Isolaiya sena kesalewa muta noka iyewi Yesuwa potapola: Ewa fa:tapo apola: sululuwalupesa alawamona sena kesale muta noka iyewi Yesuwa potapola: Ewa siliyaposakeye. Alanase, iwa mene teisa:walo tiye apolaposakeye. Apula: sena kesale muta Ewamo solo olokeyatelawa selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Alanase, sena kesale matana mupawayawa Eyewi hokatopesakeye. Apulapita:, Meli kewa ta:yewi ola nakolosene epapuluse ke himuwana nakola oiya tiyaposakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ikila emiwa, sepatosene kesale nowa enene, e unua Ana. Ewa Fanuele e la:le. Ewa mayawa Asakeye. Ana kepeyasokeye. Puwanowa ewa senayewi tiyapola: yapewa tomoipe itapa tela. Apula: e senawa ke kulu. ");
INSERT INTO khs_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kulapita: potapola:, ewa sopa:la hela: yapewa talo oloipe epela: pinipe (84) itapa tela. Eyawa Kote koawa eta: ata hanosema. Alawamona, ikilalewala nukulapowemiwana Kotema wapilisene. Aluse, eyawa kulukulula: selekiwa ma:na:wa ala:pela: tesene. ");
INSERT INTO khs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Napu semetei kemi, ewa i salo pakemi mina. Apula:, eyawa sala amowa Kotema napolo seya. Apulapita:, eyawa sala amowa walose selese sena kesale sopoke Kotewamo yesipela: Yelusaleme sena kesale sopoke mene siliyaposakeye esa: ima au seya. ");
INSERT INTO khs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosepe Meli a:tawa Kote ele tuwapo solo sepapo amowa timini tiye. Apula:, a:ko: Kalili peleya: Naselete ene koamesa:wemi mene hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Apulapita:, sala Yesuwa solo tepela: penayawa tiyapola: enene. Eyawa matana napolo sosolo woliyetiyapola: Kote e kokonawa ewalapulu elakeye. ");
INSERT INTO khs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yapene sopoke Yesu ina yoyeliwa Yelusalemewemi Isolaiya sena kesale semetei helepa:pe amo matanese ma:na: mena popa:na: hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesuwa yapene kukuluipe (12) tepela:, Iyawa ili mane amo kulu hanose ma:na: mena ikila sosolo amo matanese Yelusalemewemi hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ikila ma:na: mena amowa usuyetiyapola:, ina yoyeliwa ene peleya:wemi mene hapa. Alawamona, sala Yesuwa Yelusaleme peleya: kemi enene. Apulapita:, ina yoyeliyawa Yesuwa Yelusaleme peleya: kemi ela tapo esekiwa eta: matanama. ");
INSERT INTO khs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A:tawa sena kesale nokalapulu hapalole esa: matanese a:ko: ikiwapo semetei nowa ha:na: ka:lewemi tese. Yesuwa sena kesale nokalapulu minanole esa: nakeya. Apula: sena e sola nokamawana ta:keya. Apula: e mana nokamawana ta:keya. Alawamona itapalapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A:tawa mapotapita:, a:ko: Yelusalemewemi Yesu kelema:na:pela: hapa. ");
INSERT INTO khs_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hanapola:, ikiwapo usulupe keyalape mapotapita: ke eniyapola:, a:tawa ewa Kote koane suwemi walosene sena pisei tewaya amo seya ta:ta: apula: mene sela: ela:sela: elapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Walosene sena pisei iyawa Yesuyewi ta:tapola: mene seya amo ta:tapola:. Iyawa Yesu matana fa:namo potapola: iwa howa hanose matana ilima tela. ");
INSERT INTO khs_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aputa: ina yoyeliwala inise ta:takamake Yesuyawa au selapita: ta:tapola:, a:ko:la howa hapa. Aputa:, yoyewi Yesuma selese, “Ni sa:le, keye mane weyamowa ko:luma:na:pela: elala? Ki ata na:ko: kewamo matanese nakeyawa ilima telakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Alawamona, Eyawa ina yoyelima mene selese, “Ka:tawa newa ko:luma:na:pela: nakeye minana? Ka:tawa newa ni ata koane ela tapo esekiwa eta: matanamana? ");
INSERT INTO khs_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Alawamona, ina yoyeliyawa Yesu solo seyawa eta: seli matanama. ");
INSERT INTO khs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Apula:, Yesu ewa a:ko:lapulu ilipe Nasalete peleya:wemi mene sinikeye. Sinapola:, ikiwapo sopoke ina yoyeli solo seya semetei kulu hanosene. Alawamona, Meliyawa nano seya sopoke amowa e himu sulu fa:nemi selawapola: matana:sela: enene. ");
INSERT INTO khs_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Alanase, Yesuwa sena sosolo tepela:. Eye matanawa napolo matane tiye elapita: potapola: sena kesaleyawala ele potapola: epeyawa sosolo tela. Aputa: Koteyawala Yesumawa epeyawa sosolo ilimakeye. ");
INSERT INTO khs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Puwano Lome sena ili pisei sena Taipiliasi Sisa ewamo enene. Ikila ewa ili pisei sena yapene papoipe tepela: sikape emi Kote E sowa Yone e salo mina. Aputa: ikila emi Ponitiase Pailete amoke pisei sena Yutia ili pisei enene. Aputa: ikila emiwa Kalili peleya: emiwa Helote ene pisei kolotea epela: enene. Aputa: Itulia peleya: alapulu, Takonitisi peleya: alapulu Heloteyewi e ma:e Filipiyewi pisei kolotea epela: potapola: enene. Aputa: ikila emiwa A:pilini peleya:wane Laiseniaseyewi pisei kolotea epela: potapola: enene. ");
INSERT INTO khs_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aputa: ikila emiwa Anase Kaiafase elipei amoke pilisiti pisei sena wa:pa:se sita: enene. Ikila emiwa Sekalaiya e sa:le Yone, peleya: senanama emi, Kote E sowa Yone E salo mina. ");
INSERT INTO khs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aputa: Yone ewa hano Yota:ne hema emi sisa:nene Kote solo se tiye kina:sela: enene. Eye au seya, “Ke matana olokeyatela iya:pela: notoloyetipela: inapola: hano toliyeti. Alusaleke:, Koteyawa ke olokeyatelawa itapa tepesa.” ");
INSERT INTO khs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Puwano solo sepapo weyamowa sepatosene sena Aisaia eyewi pukawemi momateyawa weyamo, “Sena nowamoke peleya: senanama emi hola:sela: ene, ‘Sosolo mina:na:wane isu selipa:. E isuwa koakena elapetawa hekepa:. ");
INSERT INTO khs_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kokeya sopoke peleya:wa selalesa: feyetiyepe. Fapolo tokomo koloteawalapulu sosowalapulu sopoke hotolose fela apola:pa:. Isu koakena elapitewa isu hekeya napolo tepesa. Isu etewa apula: nano ketea noka elapitewane Kote Eyewi papaya tepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Sena kesale peleya: sopoke potakamake Kote Eyewi sena kesale olokeyatela sita:newa mene tiyaposakeye.’” ");
INSERT INTO khs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Alanase, Yone eyewi sena kesale iwa ine tese hano toloyetima:na: matanase mina, eye ima selese, “Kiwa heseke salakeye! Koteyawa kiwa sopoke konomonose falasipesakeye. Kimawa eta: seyala? ");
INSERT INTO khs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kiyawa fo napolo helepa: amokiyawa kiwa heneye matana notoya walopesakeye. Alanase, kiyawa ma au selapesakeye, ‘Niwa Epalahame e sa:le, alanase, Kote Eyawa niwa mafalasi epesa.’ Alamakeye, Neye kima selakeye, Kote Eyawa etewa epa eleyetipela: Epalahame e sa:le tepesa. ");
INSERT INTO khs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kapiwa i mouwemi tuwapolo elakeye. Alanase, i sopoke fo napo mahelesaleke amowa kene tiyapola: tei wa:lawemi sotukepilaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yoneyewi au selapita:, sena kesale sopoke ema mene ta:potese selese, “Alanase, niyawa ko:lu timinima:na:napa?” ");
INSERT INTO khs_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aputa:, eyewi ima mene selese, “Sena eta:wiye setiwa elipei elaleke nowa tiyapola: sena itapama kina:pa:. Sena eta:wiye eyawa ma:na: elaleke, sena itapama sakopa:. ");
INSERT INTO khs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takese tisene sena noka Yone salo inapola: hano toliyetimita: minakeye. Aputa: iyewi ema ta:potose, “Walosene sena, niyawa ko:lu timinima:na:napa?” ");
INSERT INTO khs_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aputa: eye ima selese, “Kiyawa sena kesale moweniwa wa:ke me palesekiwa tiyapa. Kamani senayewi kima sela kamunuse tiya:pa:.” ");
INSERT INTO khs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Aputa:, Ami sena nokamoke Yonema ta:potose sela:sela: enene, “Niyawa ko:lu timinima:na:napa? Apula: eyewi ima mene selese, “Kiyawa nowamo moweniwa mokopo tinenisekiwa tiyapa. Kiyawa sena nowa mokopo timiyamawa selapa. Kiyawa seli epelesa: kili tima:na: ti moweniwa tikeye.” ");
INSERT INTO khs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ikila emiwa, sena kesale sopoke, Keleso mina:na: amo yesipela: sita:ne. Aputa: sena kesale ili himu fa:nemi matana penaiya tesi tiyapola:. Iwa sopoke matanawa kalikali esa: matanawa ilima aluse, “Amowa Yone ewa Kelesowa?” ");
INSERT INTO khs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aputa: Yoneyewi ima sopoke selese, “Neyawa kiwa sopoke mokopo hano toliyetiyakeye. Alawamona, Sena Ewa opola Ewamoke opola niwa me helepe inaposakeye. Alanase, newa ununamanase, E tima:na: tisene senawamuna tese E tamaka kalawa neyawa eta: ka:ma:na: telamakeye. Eyawa kiwa sopoke Ho Napowalapulu tei wa:lawalapulu toliyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Solo semetei weyamowa pale seya solo selakeye. Sena Sosolo inisekiwa, Eyawa sipiti epapula foke tiye inaposakeye. Tiye inisekiwa peleya: pakia witi e sa:le tuwapo fokeyewi paseyalapepela: witi henewa seli sululupoiyawa amowa tiyalapepela: E koanewemi tuwataposakeye. Witi tapo alopoyewi tiyapola: ha:na: nokemi sululupolusaleke amowa tiyapola: tei wa:la eta: sekakolosema emi kilipesakeye. ");
INSERT INTO khs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aluse, Yoneyewi solo se tiye mi aluse, solo nowanapulu se tiye kine, wa:ke me se tiye kine, wa:ke me se tiye kine, aluse Yoneyewi Kote E solo napolo eyewi sena kesalema solo se tiye mikeye. Iyewi seli ta:tapola: matanemita: se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aputa: Heloteyewi Kalili peleya:wemi potapola: ene ikila emiwa, e mae Filipiyewi e kesale, Helotiase ewa, Heloteyewi o:sulu tiyapola: enene. Yoneyewi nano olokeyatela sopoke tiyapita:, potapola:, Eyewi konomonose selese, “Kewa olokeyatelalapo. Apowo, e seya.” ");
INSERT INTO khs_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Aputa: Heloteyewi ene puwano olokeyatela timiya, kamunuse wa:ke wala me timinipita: Yone ewa tipolo selawapo. ");
INSERT INTO khs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sena kesale sopoke hano toliyetiya:sela: elapita:. Aputa: Yesu Ewala hano toliyeti. Ewa hano toliyetipela: Yesuyewi Kotema kulukulula:sela: enewanapulu hepene isuwa kola:pe. ");
INSERT INTO khs_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aputa: hepene isuwa kola:tapita: potapola: Ho Napowa E salowemi a:nema: tumu epapula sinapita: papo. Aputa: Kote E sowa hepene falemi Yesuma selese, “Kewa Ni Sa:keye. Kewa matana sosolo telakeye apula: epeya ilima telakeye.” ");
INSERT INTO khs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ikila emiwa, Yesu Ewa yapene talo usulupe tepela: emi ma:ta: tiye E tima:na: tiye hapakeye. Sena kesale sopoyawa Yesuwa Yosepe e Sa:keye e seyakeye. Aputa: Yosepe ewa Ilai e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ilai ewa Matate e sa:keye. Matate ewa Lifai e sa:keye. Lifai ewa Meleki e sa:keye. Meleki ewa Yonai e sa:keye. Yonai ewa Yosepe e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosepe ewa Matatiase e sa:keye. Matatiase ewa Emose e sa:keye. Emose ewa Nehume e sa:keye. Nehume ewa Hesili e sa:keye. Hesili ewa Nakai e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai ewa Ma:tane e sa:keye. Ma:tane ewa Matatiase e sa:keye. Matatiase ewa Semeine e sa:keye. Semeine ewa Yoseke e sa:keye. Yoseke ewa Yota e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yota ewa Yoanane e sa:keye. Yoanane ewa Lesa e sa:keye. Lesa ewa Selapapeo e sa:keye. Salapapeo ewa Siatio e sa:keye. Siatio ewa Neli e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli ewa Meleki e sa:keye. Meleki ewa Ati e sa:keye. Ati ewa Kosame e sa:keye. Kosame ewa Elematame e sa:keye. Elematame ewa Eli e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eli ewa Yo:sua e sa:keye. Yo:sua ewa Eliesa e sa:keye. Eliesa ewa Yolime e sa:keye. Yolime ewa Matati e sa:keye. Matati ewa Lifai e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lifai ewa Simione e sa:keye. Simione ewa Yuta e sa:keye. Yuta ewa Yosepe e sa:keye. Yosepe ewa Yoname e sa:keye. Yoname ewa Elaiyakime e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiyakime ewa Melea e sa:keye. Melea ewa Mena e sa:keye. Mena ewa Matata e sa:keye. Matata ewa Netane e sa:keye. Netane ewa Tepiti e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tepiti ewa Yesi e sa:keye. Yesi ewa Opete e sa:keye. Opete ewa Poase e sa:keye. Poase ewa Salamone e sa:keye. Salamone ewa Na:sione e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Na:sione ewa Aminatape e sa:keye. Aminatape ewa Atimine e sa:keye. Atimine ewa Lame e sa:keye. Lame ewa Hesilone e sa:keye. Hesilone ewa Pelese e sa:keye. Pelese ewa Yuta e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuta ewa Yakope e sa:keye. Yakope ewa Aisake e sa:keye. Aisake ewa Epelehame e sa:keye. Epelehame ewa Tela e sa:keye. Tela ewa Nehole e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nehole ewa Seluke e sa:keye. Seluke ewa Leu e sa:keye. Leu ewa Peleke e sa:keye. Peleke ewa Hipelo e sa:keye. Hipelo ewa Sela e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ewa Keinane e sa:keye. Keinane ewa Afasate e sa:keye. Afasate ewa Seme e sa:keye. Seme ewa Noa e sa:keye. Noa ewa Lameke e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameke ewa Metusala e sa:keye. Metusela ewa Inoke e sa:keye. Inoke ewa Ya:lete e sa:keye. Ya:lete ewa Mahalaleli e sa:keye. Mahalaleli ewa Keinane e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keinane ewa Ino:se e sa:keye. Ino:se ewa Sete e sa:keye. Sete ewa Atame e sa:keye. Atame ewa Kote e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Ewa Ho Napowa ewemiwa woliyetipela: hano Yota:ne iya:pela: hapakeye. Apula: Ho Napoyewi Yesuwa siliyapola: hekelese senanama peleya: hapa. ");
INSERT INTO khs_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aputa: senanama peleya: emiwa Seteneyewi ikila talo pinipe Yesuwa olokeyatela timinimita: ta:peyakeye. Aputa: ikila talo pinipe emiwa Yesuwa nano ketea nowa eta: menama. Akamake, ikila talo pinipe itapa tekamake Ewa meina sosolo heteti. ");
INSERT INTO khs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Aputa: Seteneyewi Ema selese, “Kewa Kote E Sa:laleke Keyewi etewa epamawa ‘ma:ne hetetima,’ e sema. ");
INSERT INTO khs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Aputa: Yesuyewi mene Setenema selese, “Kote solo Pukawemiwa momateya elakeye, ‘Sena kesaleyawa mokopo ma:na:wemiwa falelawa matiyaposakeye.’” ");
INSERT INTO khs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seteneyewi Yesuwa siliyapola: tokomo fiyale falemi kamani kalikalila koamesa: sopoke amowa kipila waloma:na: hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aputa: Seteneyewi Yesuma selese, “Neyewi kamani kalikalila weyamowa opolawalapulu nano ketea sopoke kema pota: epesete miya:na:keye. Ko:yawemiye, Koteye weyamowa nema miwemi ela:, alanase, nine ela: sena ama miya:na: matana ama miya:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Alanase, Keyewi nema kulukulusaleke nano ketea sopoke neyewi kema waya weyamowa miya:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aputa: Yesuyewi ema mene selese, “Kote solo pukawemiwa momateya elakeye, ‘Kewa Sosolo ke Kotema wapilipa: apula: Ewemi semetei tima:na: tisene kulu ha:na:pa:.’” ");
INSERT INTO khs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Seteneyewi Yesuwa siliyapola: Yelusaleme emi hapa. Hanapola:, Seteneyewi Ewa Kote koane tomo falemi sapela: Ema selese, “Kewa Kote E Sa:laleke, weyemi kine kolemi o:tetima. ");
INSERT INTO khs_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ko:yawemiye, Kote solo pukawemiwa momateya elakeye, ‘Koteyawa E hepene senama kewamowa seli pota: elaposakeye. Kewa maolokeyalepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aputa: Kote solo puka nowemi me selesekiwa, “Hepene sena ili tiya:yewi kewa talo tiyaposakeye, ke onatuwa etewayewi kama:pekitise.’” ");
INSERT INTO khs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Aputa: Yesuyewi ema mene selese, “Kote sowa pukawemi selese, ‘Keyawa ke Kotewa ta:pelepa.’” ");
INSERT INTO khs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aputa: ikila Yesuma nano ketea kalikalila ta:peya sopoke kotetipela:, Setene ewa hanapola: ikila fo napo hetetiyapita: wa:ke ta:pelema:na: yesilakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu Ewa Kalili peleya:wemi mene hanose Kote E Ho Napolo opolawalapulu hapa. Sena kesale sopoke Kalili hema koamesa: emi ka:la:ya, amokiwa Yesu wala solo seya topukeye. ");
INSERT INTO khs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aputa: Eyawa Yu sena kulukulu koawemi ma:ta: tiye walopola: sena kesale sopoke Emawa solo napolo seya. ");
INSERT INTO khs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Aputa: Ewa Ene Ewamo solo tela peleya: Na:saletewemi mina. Aputa: ikila Tekapewemi ha:le tesene ikilawemi Ewa Yu sena kulukulu koane suwemi tuwatene. Yesu Eyawa Ikila Teka kemiwa sopoke alusene. Eyawa akema:na:pela: tesi tikeye. ");
INSERT INTO khs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aputa: sena semetei nowamoke sepatosene sena Aisaia puka momateya amowa Ema mikeye. Eye tiyapola: faketipela: akeyakeye. Momateya amowa weyamu akeya, ");
INSERT INTO khs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kote E Ho Napowa Newanapulu enekeye, ko:yawemiye, Koteyawa Newamo ta:pelesewa Kote solo napolo sena kesale sopoke iye ela: matane kamuna amowa se tiye mikeye. Kote Eye Newamo ilikepilise solo sepapolo amowa sena kesale tipula elaka mokopo hanaposakeye. Sena kesale si kola wa:ke potaposa. Sena kesale nokamoke ima mane olokeyatela timinisaleke, Neyawa iwa mokopo hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Koteyewi Newamo ilikepiya we solo sepapolo weyamowa yapene napu ikila Kote Eye sena kesalema epeya walomita: hetetikeye.” ");
INSERT INTO khs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesuyewi puka kopotiye kulukulu koane yesila sena ema mene kinapola: Ewa heya. Sena kesalela: kulukulu koane suwemi sita:ne ili siyawa Yesuwa kulu papo. ");
INSERT INTO khs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eyawa sowa ma:ta: tiye ima selapose elakeye, “Napu weyemiwa puka Neyewi akeya epamowa kiye ta:taka amowa heneye hetitikeye.” ");
INSERT INTO khs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aputa: Eyewi au selapita:, i sita:ne amokiyawa E sowa napolo ta:tapola: sa:le napolo e seya. Iyawa E meapo solo napolo seya amo ta:tapola: iwa mono matanakeye. Aputa: Iyewi selese, “Ai, Epamowa Yosepe e sa:lapa?” ");
INSERT INTO khs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aputa: Eyewi ima selese, “Neyawa matanakeye kiyawa Nema mene selaposakeye nano weyamowa kiyawa puwano topuwa, ‘Mitokolo sena, kine ela: me faliyetima. Aputa: nano ketea sopoke Kapaneamewemi timiya Niyewi topuwa amowa Ke peleya: Na:salete emiwa timinipa:.” ");
INSERT INTO khs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aputa: Yesuyewi ima selese, “Neyawa heneye kima selakeye, sepatosene sena semetei nowa e peleya:wemi inapola:, iyawa eta: seli silima. ");
INSERT INTO khs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Neyawa heneye kima selakeye, sepatosene sena Ilaiya ene ikila emiwa Isolaiya peleya:wemiwa kesale sopa:la ilima enekeye. Ikila emiwa meiki fala itapela: yapene usulupe apula: kunei tekapeipe tepela: peleya: sopoke weyemiwa meinawa sosolo hetetikeye. ");
INSERT INTO khs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Alawamona, Koteyawa Ilaiyawa kesale sopa:la iwamo tapo sesemita: eta: ilikepiyama, alawamona, Koteyawa kesale sopa:la semetei peleya: koamesa: Salafete peleya: Saitone elakamo sesemita: Ilaiya ilikepiya. ");
INSERT INTO khs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ikila sepatosene sena nowa unua Ilaisa enene emiwa Isolaiya sena kesale muta iwa oloseseya nakola unua wakepila tiyapola: enekeye. Alawamona, Koteyawa semetei nowa iwa eta: faliyetimakeye. Alawamona, Eyawa Silia peleya:wemi sena semetei amo unua Nemane ewamo faliyetikeye.” ");
INSERT INTO khs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yesuyewi au selapita: ta:tapola:, sena kesale sopoke Yu kulukulu koane sita:ne emiwa iyawa konomona ilima telakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sena kesale iwa sopoke tesilapola: Yesuwa tiye poye ha:na: tese koamesa: akola naiya fiyale hema emi ha:na: apoyakeye. Aputa: iyawa akola naiya emi Yesuwa polutiye toliyetima:na: matana. ");
INSERT INTO khs_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Alawamona, Yesu Ewa sena kesale iyewi sowapola: ene amowa kaselese hapa. ");
INSERT INTO khs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sikape emiwa Yesu Ewa koamesa: Kapaneame, Kalili peleya: emi, sinikeye. Aputa: ikila tekakemiwa Eyawa Kote sowa sena kesalema ma:ta: tiye wayakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aputa: Yesuyewi Kote Sowa selapita: iyawa ta:tapola: howa hapakeye. Ko:yawemiye E Sowa opola penaiya ilima telakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aputa:, Yu kulukulu koane sulu emiwa sena semetei nowa ho olokeyatela sena amo suwemi enekeye. Amoke sowa penaiya seyakeye, ");
INSERT INTO khs_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ai, Yesu Na:selete sena, Kewa inapola: niwa ko:luma:na:pela: minana? Kewamo mina epa niwamo ikumuma:na: minana? Neyawa Kewa matanakeye. Kewa Kote ene ho:liya papaya emi tepela: minakeye. ");
INSERT INTO khs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aputa: Yesuye ema penaiya selese, “Kewa sowa selapa. Kewa ewa iya:pela: hamona!” Aputa: sena kesale sopoke ili sikapowemi ho olokeyatela eyewi sena amowa polutiye toliyetiyapola: ewa iyapela: hapakeye. Aputa: eyawa sena amowa eta: olokeyaleye tima. ");
INSERT INTO khs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aputa: sena kesale sopoke iyawa potapola: howa hanose matanese ikene sowa mene sela:sela:, “Solo epa ko:ya selape? Yesu E solo opola penaiya ilima amo ta:tapola: ho olokeyatelama selakamake iwa iya:pela: hapa!” ");
INSERT INTO khs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Alanase, Yesu E wala solo seya amowa peleya: sopoke honosane emiwa ta:ta:sela: iliyetikeye. ");
INSERT INTO khs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aputa: Yesu Ewa Yu kulukulu koawa iya:pela: Saimone koane suwemi hapa. Saimone e neiya amo e tomawa opolose nakola ilima tepita: Iyawa Yesuma ta:potose ine sesemita: mina. ");
INSERT INTO khs_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aputa: Yesu Ewa inapola: kesale nakola emi ine tesi tese nakola ama solo penaiya selakamake nakola ewa itapa tela. Aputa:, kesale amowa kipila kemi tesi tiyapola: sena kesale ima ma:ta: tiyapola: ma:na: sapokeye. ");
INSERT INTO khs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aputa: opo sima:na: pa tela emi sena kesale iyawa iwa nakola kalikalila amowa siliyapola: Yesu salowemi mina. Inapola:, Yesuyewi E tiya:wa nakola sena kesalela: emi kesakamake nakola sopoke faliyeti. ");
INSERT INTO khs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Apulapita:, ho olokeyatela sena kesale muta i suwemi sita:ne amowa hanapola: sowa penaiya sela:sela: “Kewa Kote E Sa:keye!” Alawamona, Yesuyewi ima sowa selapa esa: penaiya seyakeye. Ko:yawemiye, iyawa matanakeye Yesu ewa Kelesokeye. ");
INSERT INTO khs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aputa: ha:le ikila Yesuwa koamesa: amowa iya:pela: senanama peleya: hapa. Alawamona, sena kesale iyawa Ewamo popa:na:pela: nakeya hapa. Aputa: iyawa Ewamo enene amowa ha:na: koliyetipela: potapola: iyawa Ewa kasema:na:pela: seya, “Niye matanawa Keyawa niwa ata hamonota:wa eta: matanamakeye.” ");
INSERT INTO khs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Alawamona Eyewi ima selese, “Neyawa Kote Sowa napolo Kote Ewa Kini elakeye. Neye solo weyamowa koamesa: sopoke nokalapulu sema:na: matanakeye. Ko:yewemiye, mou emi ela: Newa Koteyewi ilikepiyakeye.” ");
INSERT INTO khs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Au selapita:, Yesu Ewa Yutia koamesa: muta ilima emi Kote sowa Yu kulukulu koane emi se tiye miya:na: hapa. ");
INSERT INTO khs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ikila semetei nowemiwa Yesuwa hano Kalili ka:na hema emi tesitiyapola: enene. Hano ka:na amo unua elipeikeye. Hano nowa unua Kenesalete. Yesuwa tesitiyapola: elapita: sena kesale muta ilima ine tese Ewa kekene tiyapola: hekewapola: elapita: Kote solo ta:pa:na: mina. ");
INSERT INTO khs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aputa: Eyewi potakamake ewalo tisene sena amoke poti elipei hano hemawemi ine sukula:pe elapita: papo. Ewalo tisene sena amowa ili nete amo selakola:sela: sita:ne. ");
INSERT INTO khs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu Ewa Saimone potiwemi tuwatene tapela: Saimone ema ta:potose, “Keyawa potiwa aso kolotea poluma:na: ililapa?” Aputa:, Yesu Ewa potiwemi helepela: sena kesale ima waya. ");
INSERT INTO khs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesuyawa sena kesale ima waya:sela: kotetiyapola:, Eyewi Saimone Ema selese, “Keyawa ke potiwa kolotiye ho:kunu olosa fatemi netewa toliyetiyapola: ewalo tima:na:pela: hamona.” ");
INSERT INTO khs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimone mene selese, “Sena Sosolo, eli nukulapowemiwa niyawa netewa tiyapola: hawemi toliyetiyapola: enene, ikilawamona ewalo eta: timakeye. Eli nukulapowemi niwa ha:wa eta: telamakeye. Alawamona, Keyewi ela: nema selese nete wa:ke me toliyetima e selapita: neyawa auma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aputa: iyawa aukamake ewalo ilima tiyakamake ili netewa ma:ta: tiyapola: pitiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Alanase, iyawa ili mana noka poti nowemi sita:newa holose tiya:yawa hapelakeye. Iwamo ine sesemita: holakeye. Aputa: iwa ine tese ewalo poti elipei emi selalese woliyetikeye. Akamake poti elipei amowa ma:ta: tiyapola: sinikeye. ");
INSERT INTO khs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ikila emiwa Saimone Pita eye potapola:, e kuniuwa sine Yesu E onatuwemi kula:pela: ela: selese, “Sosolo, Kewa newa iya:pela: hamona. Koiyawemiye, newa olokeyatela senakeye!” ");
INSERT INTO khs_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimone Pita au selapita: ko:yawemiye ewa e manawalapulu ewalo ilima ti amo potapola: iwa howa hapa. ");
INSERT INTO khs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aputa: Sepeti e sa:le elipei Yemese epela: Yone a:ko: Saimone Pitawalapulu ilipe tima:na: tisene iwala howa hapa. Aputa: Yesuyewi Saimone ema selese, “Kewa ipipa. Napu weyemiwa keyewi ewalo ti epapuluse sena kesalewa keyewi siliyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Alanase, iwa ili potiwa sukulutiye ine mowa hemawemi apola: iwa nano ketea sopoke iya:pela: Yesu ewamo kuluse hapa. ");
INSERT INTO khs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ikila nowemiwa, Yesuwa koamesa: semetei nowemi enene emi sena semetei nowa nakola waka:pila eta: ilima toma sopoke fola enene. Nakola amowa unua Lepolosi. Aputa: sena amowa Yesu ewa potapola:, ene sutesinapola: peleya:wemi minitapo sine eni Yesu Ewamo pawemi sine eni apula: ela: penaiya ta:potose, “Sosolo, Keyawa newa fala:pa:na: matanananeke, newa hili papaya tema:na:keye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Au selapita:, Yesuyewi E tiya:wa salokepilisa: ewa kesapela: ela: sela:sela:, “Neyewi ili timinima:na:keye. Kewa faliyetiyapola: hili papaya tema.” Aputa: nakola waka:pila Lepolosi amowa kipila iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aputa: Yesuyewi ema solo penaiya selese, “Keyawa Neyewi kewamo faliyeti epamowa sena nokamawa selapa. Alawamona kine ela: pilisiti senama ke tomawa amowa ha:na: walopa:. Aputa: keyawa Kotema mokopo Mosese ene emi seya amunuse kina:pa:. Kewa hili temita: aupa:. Aputa: sena kesalela: iye potakamakiwa ke nakola amowa itapa telakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Alawamona Yesu Eyewi nano ketea sopoke Eye timiya amowa sekoluse peleya: sopoke iliye tikeye. Alanase, sena kesale mutama noka ine E solo seya amo ta:pa:na: mina aputa: iwala nakola amowa Yesuma fala:pita: mina. ");
INSERT INTO khs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Alawamona, Yesuwa ikila muta emiwa Kotema kulukuluma:na:pela: peleya: senanama emi hapa. ");
INSERT INTO khs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ikila semetei nowemiwa Yesuyewi sena kesale waya:sela: ene emiwa Felesi senawanapulu apula: ele walosene sena alapulu iwa ka:la:lopola: ene. Iwamo minawa koamesa: sopoke peleya: unua Kalili. Yutia, Yelusaleme emi tepela: mina. Aputa: Kote E opolawa Yesuwalapulu ela: sena kesale nakolawa faleyetikeye. ");
INSERT INTO khs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Sena nokamoke sena nakola tiya:le onatu olokeyatela amowa patapata o:suwemi selawapola: tiyapola: ine Yesu salo tuwapa:na:pela: ta:pelesa: koane suwemi tuwatema:na: elawamona sena kesaleyewi fo ha:na:na: itapa tepita:. Alanase, iwa sena nakola amo tiyapola: koane wa:pa:se falemi fiyane. Fiyanapola: uwalopo puka:pela:. Aputa: iyawa patapata alapulu tiyapola: uwalopo emi halute sine tuwapola: sena kesale iwamo sita: ela amo honosane emi Yesu minitapo tuwapo. ");
INSERT INTO khs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Aputa: iye ala ikila emiwa Yesuyewi ili seli topuwa potapola: ema selese, “Ne mana Neyewi ke olokeyatela tiye iya:peyakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Au selapita:, Felesi senawanapulu ele walosene sena alapulu iye ma:ta: tiye i ekene ke matanese, “Sena epa ewa nano ketea epamo timinima:na: opola itapa. Ewa Kotewamona hetetikeye. Kote semetei Eyawa olokeyatela iya:tesekeye,” iye seya. ");
INSERT INTO khs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesuyawa ili matana fa:na matane ti apula: Eyewi ima ta:papo, “Kiyawa matana kili himu fa:nemi olokeyatela epe teseya ko:luse ela:? ");
INSERT INTO khs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Niye sena epama selesaleke, ‘ke olokeyatela iya:peyakeye,’ amowa sosolole? Niye sena epama selesaleke, ‘Kewa tesitiye hamona’ amowa kolotealole? Nokayamo sosolapa? Nokayamo kolotealapa? Alamakeye, elipei semetei kamo telakeye. ");
INSERT INTO khs_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Alawamona Neyewi nano weyamowa kima waloma:na:keye, sena sa: Newa Koteyewi ta:pelese peleya: sopoke weyemiwa opolawa Kote eye nema minase olokeyatela ili iya:pa:na:keye.” Eye ima au selakamake sena nakola onatu tiya:le olokeyatela ema selese, “Neyewi kema selakeye, ‘Kewa napute yemi tesitiyapola: ke patapata epa tiye kine koane hamona.’” ");
INSERT INTO khs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aputa: kipila kemi sena amowa sena ili sikapowemi tesi tiyapola: e patapatawa ene tiyapola: e koane hanose Kote unua wapilise hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Sena kesale iwala amo potapola: monose howa hanose Kote unua wapiyakeye. Matana iyawa ilima woliyetikeye. Aluse, iye selese, “Napu ikila weyemiwa nano ketea kalila potakeye.” ");
INSERT INTO khs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aputa:, sikape emi, Yesu ewa mowa tuwatene potakamake takese tisene sena, E unua Lifai, amowa e koane takese tisene emi helapita: papo. Yesu eye ema selese, “Newamo kulu tiye mina,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Au selapita:, Lifai ewa tesi tiyapola: nano ketea sopoke iya:pela: Yesu ewamo kulu tiye hapa. ");
INSERT INTO khs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aputa: Lifai eyawa Yesu ewamopela: ma:na:ma:na:pela: Yesu ewamo wapilise kekena amowa e koawemi kekena. Aputa: takese tisene sena muta alapulupela: sena nokalapulu sopoke ka:la:lopela: ma:na: na:sela: enekeye. ");
INSERT INTO khs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Alawamona, Felesi sena iwalapulu ili ele walosene sena alapulu iyawa Yesuwalapulu kulu hanosene sena ima solo talapoiya ine ma:ta tiye sela:sela:, “Sena takese tisene alapulu sena himu olokeyatelawalapulu ma:na: ko:luma:na:pela: na:sela: ela:?” ");
INSERT INTO khs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesuyewi mene ima selese, “Sena seli enewa mitikolo eyawa ewamo elaka eta: fala:pa:na: hanosemakeye. Alawamona sena nakola elaleke amowa mitikolo eyawa fala:pa:na: hanosekeye. ");
INSERT INTO khs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Newamo mina we sena kesale hekeya ela amopela: matana notolomita: eta: holamakeye. Alawamona, Newa mina we sena kesale olokeyatela elaka amopela: matana notolomita: holakeye.” ");
INSERT INTO khs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aputa: iyewi Ema selese, “Ikila muta emiwa Yone hano toliyetisene ewamo kulu hanosene sena iyawa ma:na:wa hekila epela: kulukulula:sela: tesene. Aputa: Felesi kulu hanosene sena alapulu iyawala alusekeye. Alawamona, Kewamo kulu hanosene sena iyawa ma:na:wana na:sela: hawana na:sela: enekeye.” ");
INSERT INTO khs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesuyewi mene selese, “Kiyawa sena kesale sepema:na: ikila emiwa ma:na:wa kiyawa sena kesale tima:na: amo e mana ma:na: napa e selesena? ");
INSERT INTO khs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Alawamona, sikape emiwa, sena kesale nokamoke sena kesale tima:na: amowa siliyapola: e mana iya:pela: hapa. Ikila emiwa iwa ma:na: hekila epela: elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Aputa: Yesuyewi pale seya solo ima selese, “Sena kesale iyawa tapola hili hepe eta: pitili tiyapola: tapola somia emiwa eta: papela: tupulusemakeye. Alusaleke, amowa tapola hili pitiya apula: tapola hili hepe amowa somiawanapulu eta: ekela tesemakeye. ");
INSERT INTO khs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Apula: sena kesale iyawa waine kapo somiawemiwa waini hili emiwa eta: susalesema. Alusaleke, amowa waine hili kaka hotolaposakeye. Waine hawa mowa suyetiyakamake waine kapo olokeyatepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Alusemakeye, waine hiwa waine hili kapo emiwa susapa:. ");
INSERT INTO khs_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aputa: sena waine somia mena amokiyawa waine hiwa eta: matanama, ko:yawemiye, sena amokiyawa selaposakeye, “Waine hiwa napokeye alawamona waine somiawa hele napokeye.” ");
INSERT INTO khs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aputa: Ha:le Tesene Ikila semetei nowemiwa witi kela ikena honosanewemi Yesuwa hapalo. Aputa: hanapola: Yesu kulu hanosene sena iyawa witi fo amowa su tiyapola: ili tiya:wemi tuwapola: sosokelepela: fo usu fa:no: tiyapola: na:sela: sita:ne. ");
INSERT INTO khs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Felesi sena nokamoke Yesuma ta:papo, “Kiyawa Ha:le Tesene Ikila weyemiwa nano tima:na: ke tise ele tuwapo amowa ko:luma:na:pela: hotala? ");
INSERT INTO khs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Aputa:, Yesuyewi ima mene selese, “Kiyawa Tepeti e mana nokamo sita:ne ikila emiwa iwa meina sitalapitekiwa kiyawa eta: akeyamana? ");
INSERT INTO khs_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aputa: ewa Kote koane suwemi hanapola: Kote E ma:na: tuwapowa tiyapola: noka ene nase noka e manama tiye mikeye. Yu sena iyawa ele tuwatese pilisiti sena semetei amoke ma:na: amowa enapotane nasene.” ");
INSERT INTO khs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Apula: Yesuyewi ima selese, “Sena Sa:le, Neyawa, Ha:le Tesene Ikila nano ketea emi hetetisaleke opola penaiya amowa Newemi elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ha:le Tesene Ikila nowemi, Yesuwa Yu sena kulukulu koane suwemi musuluyetiyapola: Kote solo waya sela: enene. Emiwa sena nowa e tiya: iliwa ketetela elapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aputa: Felesi senawanapulu ele walosene sena iyawa hele timiya mou nowa potapola: Yesuma tuwapa:na:pela: ela. Alanase, Iyawa Ewa seli pota: sita:la: Eyawa Ha:le Tesene Ikila emiwa sena amowa faletaposapele esa: pota: sita:ne. ");
INSERT INTO khs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Alawamona, Yesuyawa ili matanawa eyawa matane ti. Alanase, Eyewi sena tiya: ketetelama selese, “Tesima. Tesitiyapola: sena sopolo sikapowemi tesi tema,” E seya. Au selapita: ewa emi tesi telakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aputa: Yesuyewi ima selese, “Neyawa kima ta:potakeye, ‘Yu ele Ha:le Tesene Ikila emiwa ko:lusena? Ele amokewa niwa napolo timinimita: matanana o olokeyatela timinimita: matanana? Aputa: ele amokewa niyawa sena falela ela amo sesema:na: o niyawa sena falela ela amo ikumuma:na:na? ");
INSERT INTO khs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Au selapola:, Yesuyawa sena sopoke pepeya: ha:na: tepela: sena tiya: ketetelama selese, “Ke tiya:wa hekema,” E seya. Aputa: eyawa Yesu sowa ta:tapola: kulu hanapola: e tiya:wa napolo me telakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aputa: Felesi senawanapulu ele walosene sena iyawa konomonawa ilima tese ikene selese, “Niyawa Yesuwa ko:luma:na:napa?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aputa: ikiwapo nowemi Yesuwa tokowemi Kotema kulukuluma:na: hapa. Hanapola: Ewa yopolotela semetei nowa eta: enimake kulukulula:sela: ikiwapo. ");
INSERT INTO khs_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ikiwapola:, Eyawa sena Ewalapulu kulu hanosene senawa hola. Iwa inapita: Eyawa sena kukuluipe ta:peya. Sena i weyamowa Eyewi unuatese ‘Apasolo.’” ");
INSERT INTO khs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sena ili amo unua wekeye. Saimone, e unu nowa Yesuyewi unuatese Pita, aputa: nowa Pita e ma:e A:nitulu, nowa Yemese, nowa Yone, nowa Filipi, nowa Patalomiu, ");
INSERT INTO khs_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Nowa Ma:tiu, nowa Tomase, nowa Afiase e sa:le Yemese, nowa Saimone, Lome Kamaniyewi Yu sena pota:newa iya:pita: matanesene sena, ");
INSERT INTO khs_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nowa Yemese e sa:le Yutase, aputa: nowa Yutase Isekaliote, eyawa Yesuwa kisi senama samita: walo seya. ");
INSERT INTO khs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aputa: Yesuwa iwalapulu tupoyawemi tese soma:wemi sine sipa:lepela: hapa. Emiwa sena kesale ewa kulu hanosene alapulu sena kesale muta noka Yelusaleme peleya: emi tepela: apula: Yutia peleya: honosane sita:newanapulu apulapita: sena kesale noka hano tawala ka:no: hawe esili koamesa: elipei Taiya nowa Saitoni iwala inapola: emi ine kekenakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iwa Eyewi Kote solo waloka ta:pa:na:pela: mina. Apula: iwa nakowayawa fale walomita: epela: mina. Ili ine tiya honosane emiwa sena noka ho olokeyatela sena suwemi fiyanewana Yesuyewi sili tiye iya:wayakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aputa: potapola:, sena kesale iyawa sopoke Yesuwa kesama:na:pela: ela ko:yawemiye Kote E penaiya opola sosowa Ewemi elapita: pota:pola: iwa nakowaya ke falewayakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu Ewamo kulu hanosene sena potapola: ima selese, “Sena kesale kiyawa nano ketea itapa elaleke amokewa epelepesa, ko:yawemiye, ala sena kesale amowa Koteyewi piseikipela: pota: elakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kiyawa napu weyemiwa meina:sela: elaleke amokewa epelepesa, ko:yawemiye kiwa sikapewemiwa ili elaposakeye. Kiwa napu weyemiwa ya:la:sela: elaleke amokewa epelepesa, ko:yawemiye kiwa sikapewemiwa akopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Alanase, kiyawa sena sa:le kulu minanase sena nowamoke kima mapolose kiwa wepi selese kiwa henipasolose selese sena kewa olokeyatelalapo e selesaleke kiwa epelepa:. ");
INSERT INTO khs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Au selapitekiwa kiwa epelepa: epelesa: sipa:kuya:sela: elatipa:, ko:yawemiye Koteyawa wa:la:ya hepe sosowa hepene falemi elakeye. Puwanowa ili mei fa:namokiwala sepatosene senama mane timinisene semetei kamunakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Alawamona, sena kewa nano ketea muta teselaleke emiwa hilila sosolo nowa hetetiyaposakeye. Ko:yawemiye, nano napolo sopowa kiyawa ela:pe tinase. Alanase, nano ketea semetei nowa kiwemiwa ma ine hetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sena kewa napu weyemiwa ma:na:wa katalo na: tesaleke, emiwa hilila sosolo nowa hetetiyaposakeye. Ko:yawemiye sikapewemiwa kiwa meinawa sosolo tepesakeye. Sena kewa napu weyemiwa akola: tesaleke, emiwa hilila sosolo nowa hetetiyaposakeye. Ko:yawemiye, sikapewemiwa kiwa eta: epiyama tese ya:laposakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Alake, sena sopolo nokamoke kili unua wapilisaleke hilila sosolo nowa ki salowemi hetetiyaposakeye. Ko:yawemiye, puwanowa ili mei fa:namokiwala mokopo sepatosene senama mane timinisene semetei kamunakeye.” ");
INSERT INTO khs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Alawamona, kiwa Ne solo ta:ta:sela: ka:la:ya kima selakeye, Kili Kisi senawanapulu himu hanapola: elatipa:. Sena kiwalapulu mapolo semawa kiyawa sena amowa mane napolo sopowa ima timinipa:. ");
INSERT INTO khs_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sena nowamoke kiwa hetewane selesaleke, amowa kiyawa Kotema napolo temita: ta:ta:pa:. Apula: sena kiwalapulu olokeyatela timinisaleke, ewamo seselese kiyawa Kotema kulukulupa:. ");
INSERT INTO khs_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Sena nowamoke kiwa papowemi sanosaleke kemi epela: papo nokala samita: notoloyetiya:pa:. Alake, sena nowamokiwa kili sao kalesewa tisaleke, kiyawa kili setiwa ema timita: ke iya:ta:pa:. ");
INSERT INTO khs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sena kesale sopoke kema nano ketea ta:ta kemiwa kina:pa:. Apula: sena nowamoke ketea kiwa tiye hanapitekiwa menewa halopa. ");
INSERT INTO khs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iyawa mane keyewi matana amunuse timinipesakeye. Keyawala mane kamunuse imawana timinipa:. ");
INSERT INTO khs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Aputa:, sena nowamoke kewa himu hapa tesaleke keyawala ewa himu hapa emi ela, amowa napolo esekiwa sena kesale nokamokiwa ko:lu matanema:na: telalapa? Sena olokeyatela a ela iyawala sena kesale iwalapulu himu hapa ela amawana iyawala himu hanapola: tesene. ");
INSERT INTO khs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Aputa: sena nowamoke kewa napola:tesaleke, keyawala ewa napola:pela: emi ela, amowa napolo e sekiwa sena kesale nokamokiwa ko:lu matanema:na: telalapa? Sena olokeyatela a ela iyawala aluse timinisene. ");
INSERT INTO khs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aputa: sena nowama mini hepe amowa kema mene tiye kinaposa esa: matanesaleke amowa napolo esekiwa sena kesale nokamokiwa ko:lu matanema:na: telalapa? Sena olokeyatela a ela iyawala mini heka sena olokeyatela a ela nowamawana minaneke, sena amokiwala mene kinisene. ");
INSERT INTO khs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Alawamona ke kisi senawanapuluwa himu hapa ela: mane napolo sopowa ima timinipa:. Apula: kiyawa nano ketea sena nokamawa kina:pa: amowa kiyawa mini hepe amowa mene tima:na: e sekiwa matanepa. Kiyawa alusaleke, Koteyawa wa:la:ya hepe sosowa kima kinaposakeye. Mane alusene amoke elekiwa kiwa heneya Kote Falamo E Sa:le tepesakeye. Ko:yawemiye Kote eye elekiwala sena ewalapulu napolo ela eta: selesema alapulu apula: sena olokeyatela timinisene amawa Eyawa mane napolo sopolo timinisene. ");
INSERT INTO khs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kiyawa sena sopoke haukulu sela:pa: alusene amowa ki Ata hepene falemi ela Eyawala sena sopoke haukula e selesene.” ");
INSERT INTO khs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yesuyewi selese, “Kiyawa sena nowamo mane timinika potapola: tipipelepa. Kiyawa alusaleke sena nokamokiwala Koteyawala mane kiliwa matipipelepesakeye. Aputa: kiye selese, “ewa falasima,” au selapa. Auwa maselesaleke kemawana falasima elawa sena nokamokiwala Koteyawala maselaposakeye. Alake, sena nowamoke himuyewi mapolo matanawa iya:ta:pa:. Iya:ta:saleke Kote Eyawala ke olokeyatelawa tiye iya:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Keyawa nano ketea ima kinisaleke, kemawana nano ketea iyawala kinaposakeye. Kinisekiwa sosolo woliyetiye kinaposakeye. Woliyetiyapitekiwa kapususe sokolose sukama:na:mita: miya:na:keye. Amowa noka ke feya:wemi supesakeye. Keyewi nano ketea mini ka epapula iyawala kema kinaposakeye,” Yesuyewi sowa au seya. ");
INSERT INTO khs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesuyewi ima pale selese, “Sena si kolayewi sena nowa tiya:wemi kaopela: hanosaleke ililapa? Eh, a:ko: elipei uwalokemi sululuwalupesakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sukulu sala eyawa tisa senawa eta: pulute tiye hanosema, alawamona tisayawa sukulu salawa seli walosaleke sukulu sala amokiwa sikapewemiwa e tisa tesene amunuse tepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Aputa: keyawa ke ma:e siwemi i popono kolotea epe taiya amo semetei potosene alawamona kine ke siwemi i sosolo kepi pana epe taiyamowa keyawa eta: papoma amowa ko:luse elala? ");
INSERT INTO khs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Keyawa ke ma:ema selese, “Ne Ma:e, neyawa ke siwemi i popono kolotea epe taiya sili tiye iya:pa:na:wa ililapa? Alawamona kine ke siwemi i sosolo kepi pana epe taiyamowa keyawa eta: papoma. Keyawa ke ma:ema au selakamowa ko:luse sela:? Au selesaleke, sena kewa matana elipei ela: selakeye. Puwanowa i kepi pana kine ke siwemi epe taiya sili tiye iya:ta:pa:. Apula: amo fo:suwemi ke ma:e siwemi i popono kolotea epe taiyamowa keyawa hokato potapola: sili tiye iya:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesuyewi selese, “Iwa napolo elaleke fowa olokeyatela eta: helesema, apula:, Iwa olokeyatela elaleke fowa napolo eta: helesemakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I fo kalikalila amo potapola: hene iwa e selatapo esa: matanesene. Ta:pele selesekiwa, i kaluyawala kemineme i amokiwala fowa mei onawemiwa heyawa eta: potosemakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sena napoyawa himu amoke hekeya matanepela: meatawa hekeya selesene. Ko:yawemiwa, e himuyawa matanawa napolo sopolo woliyetinase. Aputa: sena olokeyatelayawa himu amoke olokeyatela matanepela: meatawa olokeyatela selesene. Ko:yawemiye e himuyawa matanawa olokeyatela sopolo woliyetinase. Ko:yawemiye sena nowamoke E himu honosane fa:nemi kete matanewa woliyetiye enewa meakemi ine hetetiyapola: selesene.” ");
INSERT INTO khs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aputa: Yesuyewi selese, “Kiyawa Nema selese,’ Sena Sosolo, Sena Sosolo’ e selesewamona kiyawa Ne solo seyawa makulu hanosewa ko:luse ela:? ");
INSERT INTO khs_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Alake, senayewi koane tima:na: epelekiwa peleya: talapoiya etewa wa:pa:se emi isu kema:na:pela: peleya: ta:la: sinapola: emi isuwa kepela: koawa emi tikeye. Koawa tiyapola: enewemi hawa hakene inesekiwa koawa seli tinase eta: tukula hanosema amunuse sena kesale Ne salo inapola: Ne sowa ta:tapola: emi kulu hanapola: tima:na: tisewa epapula elakeye. ");
INSERT INTO khs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Alawamona, sena nowamokiwa peleya: pelepoiya wa:pa:wemi koawa emi tiyapola: enewemi hawa hakene inesekiwa koawa eta: seli timanase tukuwatapola: sopoke eke tiye iya:peya. Alusene amowa sena kesale Ne Sowa ta:tapola: eta: kulu hapamawa epapula elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sena kesale iyawa sopoke ta:pita:, Yesuyewi sowa selalapepela: kopela: ene Ewa Kapaneame koamesa:wemi mene hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kapaneame koamesa: emiwa Lomene Ami ta:le ti amo tima:na: tisene sena nowa emi enene. Ewa nakola ilima tese kuma:na:pela: elakeye. Aputa: Lomene Ami ta:le ti sena amokiwa sena nakola amowa sosolo matana. ");
INSERT INTO khs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ikila emiwa Lomene Ami ta:le ti sena amoke ta:takamake Yesuwa inape e selapita: ta:tapola:, Eyewi Yu sena pisei towaya iyawa Yesuma ta:potapola: Ewa siliye inapola: e tima:na: tisene sena nakola weyamo fala:pa:na: ina:pa: e seya. ");
INSERT INTO khs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Iyawa Yesu enewemi ine fiyatese sowa penano selese, “Lomene Ami ta:le ti sena ewa napokeye. Ewa keyewi sesema:na:wa ililakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ko:yawemiye eyawa nini Yu senawa sosolo matanesekeye. Eyawa niwamopela: kulukulu koawa nima tipiyakeye.” ");
INSERT INTO khs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Au selapita:, Yesuwa ilipe hapa. Hanapola: Ewa Lomene Ami ta:le ti sena amo koane pawemi ine heteti. Ikila emiwa Lomene Ami ta:le ti sena amokiwa e mana noka Yesu salo ilikepiya. Aputa: Iyewi Yesuma selese, “Piseiki, Kewa hokolose minanakeye. Newa sena koloteasukeye. Alawamona Kewa sena sosonase na:nipe eta: ilimakeye. Alake, Kewa ne koane mina:na:wa eta: ilimanakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Alanase, newa sena koloteasunase kewa enewemiwa newa eta: minamakeye. Alawamona, Kewa epa ke ela: selese ne tima:na: tisene sena nakola weyamowa falema e selesaleke fala:pa:na:nakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Aputa: newamo yesila senayewi nema tima:na: tima e selapitekiwa neyawa tisene. Aputa: neyewi yesila ami sena noka neyewi ewa hamona e selapitekiwa ewa hanosene. Apula: neyewi nowa mina e selapitekiwa nowa inisene. Apula: neyewi ne tima:na: tisene senama tima e selapitekiwa eyawa tisene.” ");
INSERT INTO khs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesuyawa iyewi solo seya amo ta:tapola:, Ewa mono tela. Monotese Ewa mene i salo notolose ilipe ha:na: tiyenema selese, “Neyawa kima selakeye, Neyawa Yu sena kiwemiwa Lomene Ami ta:le ti senayewi Newemi penanose seli topu amunawa eta: papomakeye.” ");
INSERT INTO khs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aputa:, Lomene Ami ta:le ti sena amo e mana iwa e koane meneyetiye inapola: potakamake tima:na: tisene sena nakola amowa faliyetilapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aso komayama kemi, Yesuwa Neine koamesa:wemi hapa. Aputa: Yesu kulu hanosene sena alapulu sena kesale muta nokala ilipe hapa. ");
INSERT INTO khs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hanapola: koamesa: isu tiapo pa emi ha:na: tepeya ikila emiwa senala:yawa sala kulu nowa uwatiye inapita: papo. Sala kulu amowa kesale sopa:la amo e sa:le senase semetei kakeye. Sena kesale muta noka koamesa: emi tese kesale sopa:la alapulu ha:na: tiyalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aputa: potapola:, Yesuyewi kesale sopa:la amo hauwekilise selese, “Kewa ya:lapa,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aputa: Ewa hanapola: sala kulu sasekeya emi ha:na: kesala. Kesapita: potapola:, sena ili uwapola: ha:na:neyawa ke enetowaya. Aputa: Yesuyewi selese, “Sala, Neyawa Kema selakeye. Kewa tesima!” ");
INSERT INTO khs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Au selapita:, sala kulu amowa tesi tiyapola: sowa me seya. Aputa:, Yesuyewi ewa e amama mene mikeye. ");
INSERT INTO khs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Aputa: sena kesale sopoke amo potapola: tutelise Kote unua wapilise selese, “Sepatosene sena sosolo nowa ni salo ine hetetiyatakeye,” e seya. “Koteyawa E sena kesale amo sesema:na: minakeye.” ");
INSERT INTO khs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aputa: sena kesale Yutia peleya: sita:neyawana Yutia peleya: pa kemi sita:neyawana Yesuyewi sala kuluwa mene tesa:pelo e seyawa sopoke topukeye. ");
INSERT INTO khs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Yesuyewi tima:na: tiwa Yone ewalapulu kulu hanosene senayewi Yonema seya. Selapita: ta:tapola: Yoneyewi ewamo kulu hanosene sena elipeima selese, “Ka:ko: Yesu salo hanapola: ta:pota:pa:. Ta:potese selese, ‘Kewa sepatosene senayewi selese Sena nowa inaposakeye e seyawa Kewama? O niyawa pa:ta nowa yesima:na:napa?” ");
INSERT INTO khs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aputa:, a:tawa Yesuma ha:na: selese, “Yone hano toliyetisene eyewi na:ko: Ke salo hamonapita: inakeye. Mina weyamowa Kema nano nowa ta:pa:na: minakeye. Ta:pa:na: amowa we, “Kewa sepatosene senayewi selese Sena nowa inaposakeye e seyawa Kewama? O niyawa pa:ta nowa yesima:na:napa?” ");
INSERT INTO khs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Esa: ta:pota:newanapulu Yesuyawa sena kesale muta noka nakola kalikalila tiwa fale walopita: papo. Emiwa sena kesale noka ho olokeyatela fiyanewa sili tiye iya:pela: apula: sena noka si kola towayawa Yesuyewi ili siwa me popota: fake walopita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Alanase, Yesuyewi Yone hano toliyetisene kulu hanosene sena elipei ama mene selese, “Ka:ko: Yone salo mene hanapola: nano ketea ka:tawi topuwala apula: ka:te papowala sopoke ema sela:pa:. Sena kesale puwano si kola enewa napu yemiwa me papokeye. Sena kesale puwano onatu kete towayawa napu yemiwa me hapakeye. Sena kesale waka:pila palawa falewaya. Apula: sena kesale kena: setiya towayayawa me topukeye. Apula: sena kuluwa me tesitikeye. Apula: Kote solo napowa sena kesale misitiya towaya ima setiye mikeye. ");
INSERT INTO khs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Alake, sena kesale Newemi matana semetei tesewa eta: iya:peyama kou elaleke sena kesale amowa Koteyewi ewa napola:tesekeye.” Aluse, Yesuyewi sena elipei mina ama au seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ikila emiwa, Yone ewamo kulu hanosene sena elipei amowa mene hanapita: Yesuyawa Yoneyewi tima:na: tiwa sena kesalema ma:ta: tiye selese, “Sena kesale kiwa senanama peleya:wemi hapawa ena popa:na: hapala? Kiwa mane alotowi fuwala amo popa:na: hapala? ");
INSERT INTO khs_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Eta: alamananeke, kiyawa ena popa:na:pela: hapala? Kiwa sena sa:le sao popona kala amo popa:na: hapala? Eh, eta: alamakeye. Sena kesale sa:le sao popona napolo kalesewa apula: nano ketea sopoke napowa iliyetiye kini koane suwemi tesekeye. ");
INSERT INTO khs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Alanase, kiyawa ena popa:na:pela: hapala? Kiyawa sepatosene sena nowa popa:na: hapala? Ehe, Neyewi kima selakeye kiyawa sepatosene sena sosolo nowa papokeye. ");
INSERT INTO khs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Puwano fa:nemi Kote pukawemi sepatosene sena amoke Yone tima:na: tiyaposa kamo momateyawa wekeye, ‘Neyawa Kote sowa puwano ela:pe setiye miya:na: sena nowa hamona e sema:na:keye. Sena amoke elekiwa isu kewamo ha:na:na:wa seila:taposakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Neyawa kima selakeye, sala kesale nowamoke kesila amoke elekiwa Yonewa eta: helepemakeye. Alawamona, sena kesale eta:wiye nine newa kolotea esa: matanese Kotewemi seli ta:tapola: eyawa Kotewa ne piseikipela: elatapo esa: matanesaleke eyawa Yonewa helepekeye.” ");
INSERT INTO khs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Sena kesale sopoyawala takese tisene sena iwa sopoke Yesu solo seya amo ta:tapola: nono Kote tapowa hene napo esa: matana, ko:yawemiye Yoneyewi iwa hano tolusulanase. ");
INSERT INTO khs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Alawamona Felesi sena apula:pita: ele walosene sena iyawa Kote sowa ta:ta: iya:peya, ko:yawemiye Yoneyewi iwa hano eta: tolusulamanase. ");
INSERT INTO khs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aputa: Yesuyewi selese, “Napu sena a sitala weyamowa amuna telalapa? ");
INSERT INTO khs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sena a sitala iwamowa sala tepiteni amuna tepela: ma:na: wa:la:lesene peleya:wemi ka:la:lopela:la: ikene hosela:sela: sita:nene. Iyewi hoseyawa wekeye, ‘Niyawa konawa kima falawamona kiyawa eta: sipa:kuyamakeye. Niyawa sena kuluyewi kisala maya amo kisalawamona kiyawa eta: ya:la:makeye.’ ");
INSERT INTO khs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aputa: Yone inisekiwa ma:ne falawa apula: waine hano amowa eyawa eta: nasemakeye, apula: kiye selese, “Ewemiwa ho olokelatela nowa elatakeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Alawamona, Sena Sa:le, Newamo inisekiwa ma:na:wana naiye hawana naiye elakeye, apula: kiye selesekiwa, ‘Eyawa ma:na:wa katalo napela: waine hawana katalo nanape apola: teila:pela: nanano telalapo. Ewa takese tisene sena alapulu sena olokeyatela a ela amowa sopoke Yesu E manakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yesuyewi selese, “Sena kesale sopoke Kote matanawa kulu hanose ta: tisene iye Kote E sa:wa E matanawa henenapo esa: walopesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Felesi sena nowamoke Yesuwa e koane ma:na:ma:na: mina e selapita: emi ha:na: henene. ");
INSERT INTO khs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Koamesa: emiwa kesale semetei nowa olokeyatela a enene amokiwa Yesuwa Felesi sena amo koane emi helapita: potapola: eyawa wela hano ikumu napolo hoseyawa kopa napolo suwemi ela tiyapola: mina. ");
INSERT INTO khs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aputa: kesale amowa Yesu fo:suwemi inapola: e onatu salo kepiyawemi ine ya:lese siyawa Yesu onatuwemi tulusatoya. Ya:la:lape apola:, ene piseifano tiyapola: Yesu e onatuwa helapola: minipi. Minitapola: wela ikumu napolo hoseya amowa Yesu onatu emi sulakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Aputa: potapola: Felesi sena Yesu mina e sela:ne amoke matanesekiwa, “Yesuwa heneye sepatosene sena telakiwa eyawa kesale ko:lu telayewi kesape esa: matanemapekeye. Eyawa kesale amowa olokeyatela tisene esa: matanemapekeye. ");
INSERT INTO khs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eyawa au matanese, Yesuyewi ema mene selese, “Saimone, Neyawa kemawa solo nowa selakeye.” Aputa: Saimone selese, “Walosene sena, Keyawa sema!” ");
INSERT INTO khs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesuyewi pale selese, “Sena elipei amokiwa mini heka sena moweni puwano a:ma kinisene alapulu enekeye. Sena nowama mini heka sakopolo semetei aputa: sena nowamawa talo semetei telakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Alanase, sena elipei amoke sena a:ma moweni kina:ne ama selese, “Na:tawa moweniwa itapake kemawa mini heka eta: mene miya:na:manakeye, e seya. Au selapita:, moweni kina:ne sena amoke ela: selese, “Ke iya:pa, ka:tawa moweni neyewi mini heka nine mene kinapa,” e seya. Sena eta:wiye moweni kina:ne sena amawa sosolo epelesa: eta: matanema:na:na? ");
INSERT INTO khs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimone mene selese, “Neye matanawa sena moweni sosolo tili sena amokiwa moweni kina:ne sena amawa sosolo epelesene.” Aputa: Yesu selese, “Keyawa heneye selakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Au selapola:, Yesuwa kesale amo mene pota:la: Saimonema selese, “Keyawa kesale we pota? Newa ke koane suwemi minawamona keyawa Newa Ne onatu selakomita: hawa eta: mimakeye, alawamona kesale weyamoke elekiwa e siyayewi Ne onatuwa tulusatopola: ene pisei fayewi helakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Apula: keyawa Newa eta: minipimakeye, alawamona kesale semetei weyamokiwa heli a inise Ne onatuwemi ine minitenewa napute yemiwana a minita:sa:la: elakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Aputa: keyawa Newa wela hawa Ne pisei fawemiwa eta: sulamakeye. Alawamona kesale weyamoke elekiwa wela hano ikumu napolo hoseya moweni sosoyewi wa:la:yawamoke Ne onatuwemi sutakeye. ");
INSERT INTO khs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Alake, Neyewi kema selakeye, kesale weyamokiwa ene ewa olokeyatela sosolo elapita: potapola: olokeyatela sosolo amowa Neye tiye iya:peyakeye. Iya:peyanase, Nemawa sosolo matanetakeye. Alawamona, sena nowamoke olokeyatela kolotea iya:takemiwa Nemawa kolotea matanesene.” ");
INSERT INTO khs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Au selapita:, Yesuyewi kesale ema selese, “Ke olokeyatelawa Neyewi tiye iya:peyakeye.” ");
INSERT INTO khs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Sena kesalela: noka ipitane ka:lalopela:la: selese, “Sena epamowa ene eyawa olokeyatela tiye iya:tesene sena amowa ipa:?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aputa:, Yesuyewi kesale ama selese, “Koteyawa kewa mene silikeye. Ko:yawemiye kewa Newemi seli topuwemi ela:. Alake, kewa ha:na:piyo. Koteyewi hopola tesewa kewalapulu elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Amo sikape kemi, Yesuwa koamesa: kalikalila apula: taune kalikalila emi hapa. Hanapola: Eyawa Kote Piseiki epela: ela peleya: emi solo napolo ela amo waye sila:nekeye. Apula: Ewamo kulu hanosene sena kukuluipewa ilipe hapa. ");
INSERT INTO khs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Apulapita:, kesalela: nakola kalikalila falewaya apula: ho olokeyatela fiyane sili tiye iya:waya amokiwala Yesu ilipe hapa. Ilipe hapa emiwa kesale nowa unua Meli, Makatala koamesa: amo kesale. Ewa puwanowa Yesuyewi ho olokeyatela tomoipe fiyane sili tiye iya:peya amopela: nowa unua Yoana. Ewa sena Kusa ekele. Kusa eyawa Helote koane pota:tesene. Apula: kesale nowa unua Susa:na apuluse kesale muta nokala ilipe hapakeye. Kesalela: iyawa Yesu Ewamo kulu hanosene senawanapulu Yesu Ewalapulu iwa kesalela: ili moweni amoke sesela hapa. ");
INSERT INTO khs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yesu enewemi sena kesale muta noka koamesa: kalikalila amowa emi ine tese kekene tiyapola: elapita: Yesuyewi pale selese, ");
INSERT INTO khs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nakela sa:le kelesene sena nowamoke nakela e sa:wa fipila hapakeye. Fipila hapa amowa noka isu kiwemi sululuwaya. Sululuwaya amowa noka sena kesalela: ha:na: tise onamunu tiye iya:peya. Apula: noka a:nema:yewi ine ketetiye mena. ");
INSERT INTO khs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nakela sa:le noka etewa wapa:kemi sululuwaya. Sululuwaya amowa fiyanesekiwa napolo ka fiyatepela: sikapewemi ewa hawa itapanase eleletese ke olo tikeye. ");
INSERT INTO khs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nakela sa:le noka mei ona honosane sululuwaya. Sululuwaya amowa fiyanesekiwa mei ona alapulu elipei ke fiyanese mei ona amoke nakela sa:le kelawa fepilise sakotise eta: fiyanemakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aputa:, nakela sa:le noka peleya: sa:le napowemi sululuwaya. Sululuwaya amowa napolo fiyanese fowa heyawa semetei semetei esa: sakopolo semetei helesene.” Yesuyawa pale seya sowa selapola: sena kesalema unuwapo ho selese, “Sena kesale eta:wiye kiwa kena:wa elaleke, ta:ta:pa:.” ");
INSERT INTO khs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Au selapita: ta:tapola:, Yesu Ewamo kulu hanosene senayewi Ema ta:potose, “Pale seya epamo mouwa enana?” ");
INSERT INTO khs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesuyewi selese, “Kote Piseiki ela peleya: Ewemi matana mupapo enewa kima hokato kinakeye. Alawamona, sena nokamawa Neyewi pale selakeye. Alanase, sena kesale iyawa Ne tima:na: tiwa papowamona, hene mouwa eta: seli papomakeye. Apula: Ne solo seyawa iyawa topuwamona eta: seli matanamakeye.” ");
INSERT INTO khs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesuyewi a selese, “Pale seya heneya mouwa wekeye. Nakela sa:le amunawa Kote solo akeye. ");
INSERT INTO khs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nakela sa:le isuwemi sululuwaya amuna amowa sena kesale Kote sowa ta: tiyapola: sita:newanapulu Setene ewa inapola: Kote sowa sena kesale himu matana fa:nemi tenewa tiye iya:tesene, ko:yawemiye iwa Kote Sowa seli ta: tiyapola: Koteyewi iwa mene silima:pikitise. ");
INSERT INTO khs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aputa: nakela sa:le noka etewa wapa:kemi sululuwaya amuna amowa sena kesale Kote sowa epelese topuwamona seka eta: seli hapama. Alanase, iyawa Kote Sowa aso kasa topukeye. Ala emi ela:, hilila nowa inapita: ili seli topuwa ke iya:peya. ");
INSERT INTO khs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aputa: nakela sa:le noka mei ona honosanewemi sululuwaya amuna amowa sena kesale Kote Sowa ta: tiyapola: enekeye. Alawamona nano ketea kalikalila peleya: ne weyamoke fepili tise sako tikeye. Sena kesale amokiwa nano ketea muta temana esa: hili matana apula: moweni sosolo tima:n:a esa: matane apula: nano ketea yulu tepela: epesana esa: matanesene apula: peleya: sosolo weyemi epelema:na: tela amoke ela: fowa eta: helesema apula: iwa Kelesowemi seli topuwa eta: penaiyama telakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Alawamona nakela sa:le peleya: napowemi sululuwaya amuna amowa hekeya sena kesale apula: iwa matana himu fa:na napolo ela akeye. Iyawa Kote sowa ta: tiyapola: seli talapo tiyapola: ela amowa nano ta:peya kalila nowa inakemiwa iyawa Keleso unua seli talapo tinase sikapewa fowa napolo helepesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesuyewi sowa a sela:sela:, “Sena nowamoke imawa tutiyapola: pakete hasuwemiwa eta: fopulusema apula: wa:ta hasuwemiwa eta: tuwatesemakeye. Eta: alusema, senayawa imawa tutiyapola: hokato honosane tuwatesene ko:yawemiye sena kesale noka inisekiwa ho:liya amo potapola: inisekeye. ");
INSERT INTO khs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Alanase, napu weyemi nano ketea sopoke o:sulu mupapeya enewa sikapewemiwa hokato tepesakeye. Apula: napu weyemi nano ketea sopoke o:sulu mupapeya enewa sikapewemiwa Koteyawa hokato walopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Alake, solo amowa kiyawa seli matane tiyapola: ta: tiya:pa:. Koteyawa matane ti sena ela amawa matana sosowa wa:ke kinaposakeye. Alawamona sena eta: seli matanama elaleke amowa Koteyawa ene eye matana ela amowa tiye iya:taposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ikila emiwa, Yesu yowala E ma:ela:wala Ewa popa:na: mina. Alawamona, iwa pa emiwa eta: ine mako:lu telama ko:yawemiye sena kesale mutayewi Yesuwa hekiyetise fowa itapalapita: potose. ");
INSERT INTO khs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aputa: sena semetei nowamoke Yesuma selese, “Ki amawa ke ma:ela:walapulu iwa Kewalapulu solo sema:na:pela: inapola: hema fatemi sita:lakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Au selapita: Yesuyewi mene selese, “Sena kesale eta:wiye Kote sowa ta: tiyapola: tima:na: tisene amowa heneye Ni ama apula: Ne ma:ela: akeye.” ");
INSERT INTO khs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ikiwapo nowemi Yesuyewi Ewamo kulu hanosene senama selese, “Niwa hano ka:na epa satepela: hawe nono fa:nemi hanakeye,” e seya. Au selapita:, iwa sopoke fala: telesene potiwemi tatiwalopela: fala:wa telepela: alotowi fukamake mene tiye hano ka:nawemi hapa. ");
INSERT INTO khs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iwa ha:na:sela: hano honosanewemi Yesuwa enise uwa hapa. Uwa hapa elapita:, alopo penaiya nowa hano ka:na honosanewemi inakamake hawa kalo tiyapola: poti suwemi waluse potiwa hano mutula: sinise iwa honama telakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aputa: potapola:, Yesu ilipe hanosene sena iyawa Ewa eni enewa ha:na: kila:tese selese, “Piseiki, Piseiki, niwa hano katoma:na: mapatokeye!” Au selapita:, Yesuwa tesi tiye fiyane tese alopoyeli hano ko:luwe penaiya potiwemi ine pola:nema penaiya selese, “Alopo kewa ke iya:pa! Apula: hano ko:luwe kewala enetema,” e seya. Au selapita:, alokala ko:luwewala elipei ke itapa telakeye. Akamake hano ka:nawa ene tese eta: iminamakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesuyewi ilipe hanosene senama ta:potose, “Seli topu kiliwa kami elape?” Au selapita:, iwa howa hanose ipilise ikene selese, “Sena we ipa:? Eyawa alopoyeliye hano ko:luwe ama selakamakiwa seyawa ta:tatakeye. Ta:tapola:, E solo seya amo kulu hanatakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Au selapola:, iwa potiwa fala: telepela: Kelasini sena kesale ili peleya: emi hapa. Kelasini peleya: amowa Kalili peleya: emi ela: potakamakiwa hano ka:na hawe nono fa:nemi elakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Apula: Yesuwa poti suwemi tese mowa sine sipa:lepeyawalapulu Kelasini koamesa: amo sena nowa ho olokeyatela fiyanewa emi inapita: papokeye. Sena amowa ikiwapo sopoke ewa saowa eta: kalama henese ela: sena kulu tuwatesene apana suwemi eniya: tesene. Ewa koanewemiwa eta: enisemakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sena amokiwa Yesu potose unuwapo kalose Yesu minitapo sutesini. Sutesinapola: tela: unuwapo kalose Yesuma selese, “Kote faleyamo E Sa:wa kenase keyawa newemiwa ena ketea timinima:na:na? Apula: Neyewi kema penaiya ta:potose, “Nemawa nakoma:na: ketea nowa kinapa!” ");
INSERT INTO khs_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Sena amokiwa au seya amowa ko:yawemiye Yesuyewi ho olokeyatelama selese, ‘Iya:pela: hamona’, e seya amowa topunase. Ikila sopoke ho olokeyatela amokiwa sena amowa siliye sila:nekeye. Alalapita: potapola:, sena nokamoke ewa seiniyewi tiya:walapulu onatuwalapulu ta tiye tuwapola: pota:tesene. Alawamona, seini amowa sena amoke penanose hotole inapita: potapola: ho olokeyatela amoke poluse senanama peleya: emi ha:na: enekeye. ");
INSERT INTO khs_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aputa: Yesuyewi ema ta:potose, “Ke unua ipa:?” Eye mene selese, “Ne unua, ‘Mutakeye’,” e seya. Sena amoke au seya amowa ko:yawemiye ho olokeyatelawa ewemiwa muta fiyanenase seya. ");
INSERT INTO khs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aputa: ho olokeyatela iyawa Yesuma penaiya ta:potose selese, “Keyawa niwa uwalopo heka eta: popa:na: telama utesiniwemiwa toliyetiyapa.” ");
INSERT INTO khs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ikila emiwa kopowa muta aso pa fapolo hema emi peleya: mona:sela: sitalapita: papokeye. Potapola: ho olokeyatela iyewi Yesuma ta:potose, “Niwa ili kopolo suwemi fiyama:na:wa ililapa?” e seya. Au selapita: Yesuyewi ima selese, “Ilikeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aputa: ho olokeyatela iwa senawemi enewa iya:pela: kopolo sita:ne amo suwemi fiyane. Fiyanapita: kopolola:wa kipila kalo tiye netalekamake akola naiyawemi sululuwaluse hano ka:na emi katolose ya:te telakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aputa: sena kopolo pota:tesene amoke potapola:, iwa mene talewata: hanapola: sena kesale koamesa: emi sita:newanapulu peleya: hepe nokemi sita:newana sopoke sekoya hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Au sele inapita:, ta:tapola:, sena kesale muta sopoke amokiwa henele esa: popa:na: mina. Iwa inapola:, Yesu enewemi ine fiyatese potakamake sena puwano ho olokeyatela fiyanenewa Yesu onatu onapela: enewemi sine helapita: papo. Sena amowa sao napolo me ka tiyapola: matanawana napolo tepela: elapita: papokeye. Ala amo potapola: sena kesale ine tiya amowa ipilise tuteilakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aputa: sena kesale papoyawa eta: pote minama sena kesale nokamawa Yesuyewi sena ho olokeyatela sili tiye iya:peya amowa iyewi papowa wa tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","38","Aputa: potapola:, Kelasini peleya: sena kesale sopoke iyawa Yesuwa mene hamona e seya ko:yawemiye, iwa ipilawa ilima tese. Au selapita:, Yesuwa potiwemi tapela: ha:na:na:pela: ekamake puwano ho olokeyatela fiyanene sena amoke Yesuma penaiya ta:potose, “Newa ninipe mina:na:wa ililapa? e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Au selapita: Yesuyewi ewa mene ilikepilise selese, “Kewa mene hanapola: ke solawalapulu ke manawanapulu imawa Koteyewi kewa sosolo weyamu seselawa sela:pa:,” e seya. Aputa: sena ewa mene ene koamesa:wemi hanapola: sena kesale sopoma nano ketea Yesuyewi ewemi timiyawa epapulakeye e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Apula: Yesuwa hano ka:nawa mene satepela: inise potakamake sena kesalela:wa ewa inapita: epelesa: mene silikeye. Ko:yawemiye iyawa ewa yesipela: enenase. ");
INSERT INTO khs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ikila emiwa Yu sena iyewi kulukulusene koane sosolo amo yesila sena e unua Yailase sena amokiwa Yesu onatu onapela: enewemi ine tese kuniuwa kula:walopela: ela: Yesuma penano ta:potose, “Kewa newanapulu ne koane mina:na:wa ililapa? ");
INSERT INTO khs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ko:yawemiye ne la:le semetei nowa yapene kukuluipe tela amowa kula hananakeye. Au selapita: Yesuwa Yailase koane ha:na:na:pela: ha:na:newanapulu sena kesale ilima emi ha:na: tiyenenapita: Ewala ilipe hanose teletese poiya hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ikila emiwa kesale nowa ilipe hapa kesale amowa hekila hanose hesana ela: yapewa kukuluipe enene, alawamona mitokolo sena nowamokiwa eta: faliyetimakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kesale amowa Yesu fa:kemi inapola: e sao kala aso fili hekemi ine kesalakeye. Kesakamake komayamakemi hekila hanose hesana enewa ke itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aputa: Yesuyewi ta:potose, “Newamo ine kesaka eta: elala?” e seya. Au selapita: iyewi selese, “Niyawa Kewa eta: kesalamakeye,” e seya. Au selapita: Pitayewi selese, “Piseiki” sena kesalewa mutake Kewa poluse etakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Alawamona Yesuyewi selese, “Sena kesale nowamoke Newa kesalakeye. Amowa Neyawa matanekeye. Ko:yawemiye penaiya opola Newemi ela amo hanaka nine Neyawa potakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Au selapita: kesale amoke matanesekiwa eyewi kesatapo esekiwa Yesuyawa matana ela esa: matanese ewa kiwa pipilise ipilise Yesu salo inapola: E minitapowemi kuniuwa kula:pela: e pisei kotopela: ine hela:. Sena kesale nokamo sikapowemi eyewi Yesu kesala amo mouwa apula: ewa aso komayama kemi faleyetiwa Ema emi seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Au selapita: Yesuyewi ema selese, “Ne la:le, kine seli topu epamoke faleyetiyatakeye. Alake hamona. Koteyewi hopola tesewa kewalapulu elaposakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesuyawa sowa au sela:sela: enewemi, sena nowa Yu sena kulukulu koane pota:tesene sena Yailase e koane emi tese inapola: Yailasema selese, “Ke la:wa kulukeye. Alake keyawa Walosene Sena epamowa siliye inapa,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesuyawa solo seya amo ta:tapola: Yailase ema selese, “Kewa ipipa. Keyawa Newemi seli topuwa eta: natelama elaleke, ke la:le epa mene tesilaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu Eyawa Yailase koawemi fiya tesekiwa, sena muta noka koane suwemiwa musulumita: fowa eta: apoyamakeye. Alawamona Eyawa Ewalapulu koane suwemi musuluma:na: ta:peyawa Pita nowa Yone nowa Yemese apula: sala kulu amo ina yoyeli ili amo sopolo musuyakeye. ");
INSERT INTO khs_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Musuluye tiye hanapita: potapola:, sena kesale pakiya kole ke sita:neyawa ya:peya:sela: sosolo matana:sela: sita:ne. Aputa: Yesuyewi ima selese, “Kiyawa sosolo matanese ya:lapa. Ewa eta: kulumakeye. Ewa eni elakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Au selapita: iyawa Yesuwa akowapokeye. Ko:yawemiye, iyawa kesale sa: epamowa heneye kulukeye esa: matanese. ");
INSERT INTO khs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Alawamona, Yesuyewi kesale sa: kulu amo tiya:wa kaopela: ela: ema selese, “Ne la:le, kewa tesima!” ");
INSERT INTO khs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Au selapita: kesale sa:le kulu amo howa ene ewemi mene ine tese komayama kemi tesi. Aputa: Yesuyewi ima selese, “Kiyawa kesale sa: epa ma:na:wa miya,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aputa: kesale sa: amo ina yoyeliwa tuteila, alawamona Yesuyewi sena kesale sopolo ima penaiya selese, “Kiyawa sena kesale nokamawa kiyewi papo weyamowa selapa,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesuyewi ilipe hanosene sena kukuluipewa ha tiyapola: penaiya opola sosowa ima kinapola: iyawa ho olokeyatela fiyanewa sili tiye iya:ta: aputa: nakola kalikalilawala sopoke iyewi falewalomita: epela: holakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Apula: Eyawa penaiya opola sosowa ima kinapola: iwa Kote Piseiki epela: ela peleya: emi Kote solo napolo amo waya:sela: apula: sena nakola towayawa fala:ta: emita: ilikepiya. ");
INSERT INTO khs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Eyawa ima selese, “Kiwa makene hanosekiwa nano ketea noka tiye hanapa amowa wekeye. Ininamowa kapela: hanapa. Yetuwa wa:pela: hanapa. Ma:wa tiye hanapa. Moweniwa selapela: hanapa. Sao kama:na: noka tiye hanapa. ");
INSERT INTO khs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kiwa hanosekiwa koamesa: nowemi ha:na: fiyatesekiwa koane semetei nowemi fiyanenaneke koane semetei ke elatipa: koane nowemi esa: silalatepa. Koane emi ela: koamesa: nowemi ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hanapola:, ha:na: sena kesale koamesa: amokiwa nekanese masilisaleke, kiwaya onatuwemi peleya: palawa ke fipa:pela: ha:na:pa:. Amoke ela: walosekiwa koamesa: emiwa Koteyawa maepelepesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Au selapita: iwa koamesa: kalikalila sopoke Kote solo napowa waya:sela: sena kesale nakola towaya amowa fal:waya hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Aputa: Yesuyewi tima:na: tiye hapa amowa Heloteyawa sopoke topukeye. Helote ewa Kalili peleya: emi Kamani pisei senawa ekeye. Eyawa ta:tapola:, tikili tela ko:yawemiye sena nokamoke selese Yone hano toliyetisene kuluwa mene teisa:pekeye e seya nokamokiwa Ilaiyawa mene minanapo esa: matanakeye. Apula: sena nokamoke selese sepatosene sena semetei puwano kulu nowa mene tesilapo esa: matanakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Alawamona Helote selese, “Yone kemakuwa naiye tikeye. Alake, sena tima:na: penaiya tiyakeye e sela epamowa ipa:?” Aluse, eyawa Yesuwa ene siyewi popa:na:keye esa: matana. ");
INSERT INTO khs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu Ewamo kulu hanosene sena kukuluipe amowa mene inisekiwa, nano ketea iyewi timiyawa Yesuma seya. Selapita:, Yesuyewi iwa siliye Ewalapulu ipitane Pesaita koamesa: pawemi hapa. ");
INSERT INTO khs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Alawamona, sena kesale muta noka Yesu hapa emi sikape kulu tiye hapa. Ko:yawemiye iyawa Ewa emi hapa esa: matanese. Iwa inapita: potapola:, Yesuyawa iwa mene siliyapola: Kote Piseiki epela: ela peleya: amowa ima waya. Apula: sena kesale nakola sita:newa falewaya. ");
INSERT INTO khs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ka:le oka sine sinakemi Yesu Ewamo kulu hanosene sena kukuluipe iyawa Yesu salo inapola: Ema selese, “Keyawa sena kesale mina weyamowa mene ilikepilepa: apula: iyawa ma:na:wana enima:na:wana kelepa:sa: hamonota: ilikepilepa:, ko:yawemiye weyamowa senanama peleya:keye. Alake, koawa itapa.” ");
INSERT INTO khs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesuyewi mene selese, “Ma:na: ma:na:wa kiyewi tiye kina:pa:.” Iyewi mene selese, “Niyawa ma:ne towapowa pipe apula: ewalo elipei amo elakeye. Ma:na: noka itapakeye. Alake, sena sopolo ma:na:wa niyewi wa:la:lomita: ha:na:na:wa ililapa?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Emiwa sena taosene pipewa ine kekenakeye. Alawamona Yesuyewi Ewa kulu hanosene sena kukuluipe ima selese, “Sena ili epa takalese talo pipe esa: ka:la:lopa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Au selapita: Yesu Ewamo kulu hanosene sena kukuluipe amokiwa Yesu solo seya amo ta:tapola: iwa sopoke ka:la:ya. ");
INSERT INTO khs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sopoke ka:la:lopela: elapita: Yesuyewi ma:ne towapo pipe amowana apula: ewalo elipei amowa tiyapola: hepene fala pota:la: Kotema napolo e selapola: ma:na: amowa pasolo koluyetiyapola: Eyawa Ewa kulu hanosene senama tiye mi. Kinapita: potapola:, Iyawa sena kesale sopoke ima sakolakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sakokepilapita:, sena kesale sopolo menakeye. Nanapeyapola: kuka telipita: ma:na: mena heka Yesu kulu hanosene sena kukuluipe iyewi elale kukuluipewemi selakamake woliyetikeye. ");
INSERT INTO khs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ikila nowemiwa, Yesu Ewa Enapotane Ewamo kulu hanosene sena kukuluipe alapulu ela: Kotema kulukulula:sela: enekeye. Apula: Eyewi ima ta:potose, “Sena kesale sopoke Newamo selakamowa Newa ipa:?” ");
INSERT INTO khs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aputa: Ewamo kulu hanosene senayewi mene selese, “Sena nokamoke selese Kewa Yone hano toliyetisene akeye, apula: nokamokiwa Kewa sepatosene sena Ilaiyakeye seya, nokamokiwa Kewa sepatosene sena puwano kuluwa mene tesilakeye e seya.” ");
INSERT INTO khs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aputa: Yesuyewi ima mene ta:potose, “Kiyawa Newa ipise matane seya:?” Au selapita:, Pitayewi mene selese, “Kewa Kote Piseiki epesita: ta:peya Sena Kelesowa kekeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesuyewi Ewamo kulu hanosene senama penaiya selese, “Kiyawa Newa Kelesokeye e sekiwa sena nokamawa selapa!” ");
INSERT INTO khs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aputa: Yesuyewi selese, “Sena Sa: Neyawa Kapo oyawa sosolo tiyaposakeye aukemiwa Yu sena piseiki amokiwala pilisiti sena piseiki amokiwala ele walosene sena piseiki iyawa sopoke Newa mapolose fa:tapo apolose selese ‘Kewa heneya Kelesomakeye’ e selaposakeye. Alanase, Koteyewi ta:pelese Newa senayewi sana kulaposakeye esa: ta:pelewapokeye. Alawamona ikila usulupe kupela: elapepela: Koteyewi mene teisataposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Eyawa ima sopoke selese, “Sena kesale Newemi kulule mina:na: matanesaleke, ewa ene me sinapola: apula: ene i kelipapoiyawa uwapola: ikila sopoke Newamo kulu ina:pa:. ");
INSERT INTO khs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sena kesale eta:wiye ili falela epesene amo tapowemi teketiye matanesaleke, sena amowa e kokolo kau tesene amowa itapa tepesakeye. Alawamona, sena kesale eta:wiye ili falela epesene amo tapowemi iya:pela: Newamo kulu inisaleke, sena amowa e falela mene siliyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Alake, sena kesale semetei nowamoke peleya: sosolo weyemi nano ketea sopoke tiyapola: kekeneye tiye ela: Kotewalapulu kokolo kao tesewa eyawa iya:pela: elaleke nano ketea weyamowa napola? Eh, eta: alamakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Alake sena kesale semetei nowamoke Ne unua apula: Ne solo sema:na:wa ewalosaleke, sikapewa Sena Sa: Nine Newa mene mina ikila emiwa ewa Neyewi ewala miya:na:keye. Amo inisekiwa Nine Ne ho:liyawalapulu apula: Ni Ata ho:liyawalapulu hepene sena napolo sopowalapulu mene mina:na: ikila emiwa sena kesaleyewi Newa ewala kinapita: Neyawana iwa ewala miya:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Neyawa kima heneye selakeye. Kiwa noka napu yemiwa weyemi tesi tiyapola: seta: kuluma a elapepela: Kote Piseiki epela: peleya: ela iyawa potaposakeye,” Yesuyewi au seya. ");
INSERT INTO khs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesuyewi au selapita:, ikila oloipe itapa tepela:, Eyewi tokowemi kulukuluma:na:pela: hanose Pitawala Yonewana Yemesewala siliyapola: hapa. ");
INSERT INTO khs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hanapola: Yesuwa kulukulula:sela: enewanapulu E mitiwa kalila heteti apula: E sao kalawala saiyakolosa: koiya hetetisene epapula elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Aputa: potakamake, sena elipei nowa emi ine sita:lapita: papo. Amowa Mosese Ilaiyayeli a:ko:la inapola: Yesuwalapulu solo sela:sela: elapita: potakamake eli sao kalawa koiya papalola elapita: papo. Ili usulupe amoke solo seya amowa weyamu seya Yesuyawa Koteyewi matana amowa sopoke tima:na: tiwa kotetiyapita:kiwa Yelusaleme koamesa:wemi kulaposakeye. Alanase, Yesuyawa peleya: sosolo we iya:pela: ha:na:na:wa a:tawi Yesuma seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ikila emiwa Pita Yemese Yone iwa falopela: enekeye. Falopela:la: toyetiyapola: tesila: fiyanese potakamake Yesuwa papalola koiya elapita: potakamake sena elipei nowana ine Yesuwalapulu tesi tiye elapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Sena elipei amowa Yesuwalapulu sita:newa iya:pela: ha:na:na: epita: Pitayewi selese, “Walosene Sena, niwa weyemi minawa napolakeye. Alake, niyawa koawa usulupe tisaleke ililakeye. Nowa kema tipima:na:keye. Nowa Mosesene tipima:na:keye apula: nowa Ilaiyane tipima:na:keye.” Pita eyawa mokopo seyakeye. Eyawa ene solo seya amo mouwa eta: seli matanamake seya. ");
INSERT INTO khs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita eyawa au sela:newanapulu iwamo sita:newa kiniwaniyewi ine folakeye. Fopita: potapola: Yesu Ewamo kulu hanosene sena usulupe iwa kiniwaniyewi foyetiyapita: potapola: ipilawa ilima tela. ");
INSERT INTO khs_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ipila:sela: sita:newanapulu Solo nowa kiniwani olapowemi ine ela: selese, “Sena epamowa Nine Ni Sa:keye. Ewa Nine ta:pele tiye apoyakeye. Alake, E Sowa seli ta:ta:pa:.” ");
INSERT INTO khs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Au selapita: ta:ta: tepeyawalapulu Yesu Ewamo kulu hanosene sena usulupe iyewi potakamake Yesuwa Enapotane elapita: papo. Iyewi nano sosolo papo amowa eta: hokatoyamake i matana fa:namoke ke matane tiye sita:ne. ");
INSERT INTO khs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kiapo ikiwatapita:, Yesu Ewamo kulu hanosene sena usulupe iwa tokowemi tese sinenewanapulu sena kesale muta noka isu honosanewemi iwa katiye ina:nenapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sena kesale kekena honosane emi sena nowamoke Yesuma holose selese, “Walosene Sena, Neyawa Kema talapoiya selakeye. Ni sa:le semetiwa potapose mina. ");
INSERT INTO khs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ho olokeyatelayawa ewemi fiyanapola: amoke matane kamunuse silalakeye. Apula: komayamakemi kalose kitase haiya. Halese peleya: kolemi sutesinise meakalapulu supa:kalapulu meakemi ine hetetikeye. Aluse, ho olokeyatela amowa sala emi ela: eta: iya:pela: hanosemakeye. Ewa kemi ke ela: sala amowa ikumuna:sela: elakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Alake sena kine kewamo kulu hanosene ima penaiya ta:potose ho olokeyatela epa hamona e seya. Au selapita: iyawa hamona e seyawamona eta: hapamakeye. Kemi ke elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Aputa: Yesuyewi ima mene selese, “Sena kesale napu ikila weyemi a sita:lekiwa Kotema matana semetei maelatakeye. Alake, kiwa ikila sopoke hele matana:sela: elapita: Neyawa kiwamopela: hokola tima:na: tiya:sela: ela ikila ipipa:ya?. Alake, ke sala epa weyemi siliye mina.” ");
INSERT INTO khs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Apula: sala amowa siliye inakamake ho olokeyatelayewi sano tiye peleya: kolemi toliyeti emiwa halese kitalakeye. Alawamona, Yesuyewi ho olokeyatela ama penaiya selese, “Kewa hamona” e selakamake ho olokeyatela ewa hapakeye. Apula: Yesuyewi sala amowa aluse fala:tapola: ewa inama mene mikeye. ");
INSERT INTO khs_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aputa: potapola:, sena kesale sopoke howa hapa. Ko:yawemiye, Kote penaiya opola sosowa potose. Aputa: Yesuyewi penaiya opola sosolo amo potose sena kesale iwa howa hanose sita:newemi Yesuyewi Ewamo kulu hanosene sena kukuluipe ima selese, ");
INSERT INTO khs_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Neyewi solo kima sema:na: weyamowa, seli ta:ta:pa:. Sikapewa sena nowamoke Sena Sa: Newa kisi sena tiya:wemi tiye kinaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Alawamona, Yesu E solo seyawa Ewamo kulu hanosene sena kukuluipe iyawa mouwa eta: seli matanama. Ko:yawemiye seli matanema:na: mou amowa Koteyewi o:sulu mupapokeye. Alanase, iyawa mouwa Yesuma ta:popa:na:wa ipilise tutumatese eta: ta:papomakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesu Ewamo kulu hanosene sena kukuluipe iyawa ikene kekelese tapase selese, “Nini weyamo honosanewemiwa sena puwano sosowa ipi tepesapa:?” ");
INSERT INTO khs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Aluse kekela:sela: sita:lapita:, Yesuyawa ili matana honosane fa:nemi telaka potapola: Eyawa sala kolotea nowa siliye inapola: epawemi tesi tiye elapita:. ");
INSERT INTO khs_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Eyewi ima selese, “Sena eta:wiye Newa matanema:na:pela: sala weyamuna seselesaleke Newana sesekeye. Newa seselese epela: tesaleke Newa hamona e seya Kote Ewala epela: takeye. Alake, sena nowa ene sikape elaleke, sena amowa puwano tepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoneyewi Yesuma selese, “Walosene Sena, niyawa sena nowamoke Ke unu penaiya opola amo tiyapola: ela: sena ho olokeyatela fiyanewa sili tiye iya:talakeye. Aputa: niyawa e tima:na: tiyala amowa kama:na:pela: elakeye. Ko:yawemiye ewa niwanapulu eta: ine palamanase. ");
INSERT INTO khs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aputa: Yesuyewi selese, “Kiyawa ewa kapa! Ko:yawemiye sena kewalapulu hopola elaleke amowa kewalapulu elakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesuwa hepene falemi ha:na:na: mapatoya enene ikila emiwa Yesuyawa penaiya matanese Ewa Yelusaleme koamesa: emi ha:na:na: matanese hanose. ");
INSERT INTO khs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yesuyewi sena noka puwano E solo semita: ilikepiya. Iwa hanapola: Samelia peleya: emi fiyatela. Fiyatese iwa koamesa: nowemi hapa. Hanapola: iyawa nano ketea noka seila:walotiye apolapola: eneke Yesuwa emi minite. ");
INSERT INTO khs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Alawamona koamesa: amo a:taluyewi selese, Yesuwalapulu epela: Ewamo kulu hanosene sena kukuluipe iwa emiwa mainaposakeye, e seya. Ko:yawemiye iwa Yelusalemewemi hanose koane emi enima:na: e seya emi ela: iyawa inapa, e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Esa: iwa mapolopita: potapola:, Yemese Yone a:tewi Yesuma ta:potose, “Sena Sosolo, niyawa hepene falemi tei wa:lawa Koteyewi koamesa: ili weyamo a:talu emi toliyetisaleke ililapa?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Au selapita:, Yesuwa mene notolo tese penaiya a:ma selese, “Ka:li matana epa olokeyatela matane selakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Apula: iwa koamesa: nowemi hapa. ");
INSERT INTO khs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ilipe isu sosowemi ha:na: tiya:sela: isu honosanewemi ilipe hapa sena nowamoke Yesuma selese, ‘Neyawa kewa hanakamunuse kulule mina:na:keye.” ");
INSERT INTO khs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aputa: Yesuyewi mene selese, “Mowa kasowa peleya: ulalokemi enisene apula: a:nema:wa ene aiwemi enisene alawamona Sena Sa: Newa piyatopola: enisewa itapakeye.” ");
INSERT INTO khs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Apula: Yesuyewi sena nowama selese, “Kewa Newa kulu mina.” Alawamona sena amoke mene selese, “Sena Sosolo, puwano newa ni atawa kuluke amo tikima:na: hanakeye.” ");
INSERT INTO khs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesuyewi ema selese, “Sena nowamoke Newa eta: kulule minamananeke ewa sena kulu amuna elakeye. Alake, sena kulu amunayawa e sena kuluwa peleya:wemi tikilisaleke ilima:na:nakeye. Alawamona, kewa Ne fo:suwemi mina:na: matanesaleke kewa hanapola: sena kesale sopolo Koteyewi Piseiki epela: pota: elakeye esa: selapamona,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aputa: sena nowamokiwala Yesuma selese, “Sena Sosolo, Newana kewa kulu mina:na:keye. Alawamona, puwano newa ni ata ni ama ne sola sopoke epama e sema:na: hanakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesuyewi mene selese, “Sena eta:wiye iwemi sapa sosolo tela nakela sa:le peleya: ta:la kopolo kauwemi koma:pela: hanosene amowa e tiya:yewi tiyapola: hanosekiwa ikiwapo sopoke piseiwa mene eta: pote hanosemakeye. Sena amowa, Kote Piseiki epela: ela peleya: emiwa eyawa tima:na: napolo matiyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ikila sikape nowemi Yesuyewi sena talo tomoipe apula: me elipei (72) ta:peyakeye. Sena ili amowa elipei elipei esa: puwano koamesa: apula: peleya: sopoke Ewa ha:na:na: emi ilikepiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Apula: Eyewi ima selese, “I fowa muta helese kenawa ilimanakeye. Alawamona supa:na: senawa mutamanakeye. Alanase, I fo kenawa tima:na: tisene senayewi suputa: hamona e semita: ikena inama kulukulupa:. ");
INSERT INTO khs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Alake, kiwa ha:na:pa:. Neyawa Kiwa a:pele sipi e sa:le hopola amuna mowa kasolo sitala honosanewemi ilikepilakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Alake kiwa hanosekiwa moweni selawatesene yetuwa tiyapa apula: tamaka pa:ta: nowa tiyapa apula: kiwa isuwemi ha:na:selekiwa ene tese sena nokalapulu sowa selapa. ");
INSERT INTO khs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kiwa hanapola: koane fiyatesekiwa puwanowa weyamo sela:pa:, ‘Koteyawa kewa o:sulu hopola ke koane weyemiwa sesepesakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Alake, koane ina amokiwa kewalapuluwa hopola elaleke, hopola tesene kiwala ewalapulu elakeye. Alawamona ma alusaleke hopola tesene kiwa kine ke salo mene inise Koteyawa koane emiwa masesepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Alanase, koane semetei emi eniya:sela: potakamake koane pisili sena amoke kema ma:na: nasewana hawana kinapitekiwa na:pa:. Ko:yawemiye ene tima:na: tiwemi wa:la:ya heka ma:na: nasene kina epakeye. Alake, koane nowemi esa: mokopo silalatepa. ");
INSERT INTO khs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kiwa koamesa: nowemi hanosekiwa koamesa: sena amoke kiwa silisaleke, ma:na:wana iyewi heka:pe amunuse na:pa:. ");
INSERT INTO khs_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Apula: sena nakolawa emi sitalaka faleta:pa:. Faletese sena kesale sopomawa Kote Piseiki epela: peleya: emi ela amowa ki salowemiwa mapatopela: elakeye e sela:pa:. ");
INSERT INTO khs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Alawamona, kiwa koamesa: nowemi hanosekiwa koamesa: sena amoke kiwa masilisaleke, kiwa isu ki epe kemi hanose unuwapo ho selese, ");
INSERT INTO khs_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ki koamesa: weyamo peleya: funu ne onatuwemi palawa mene fipi tiye toliyetiyakeye. Ko:yawemiye Koteyawa kiwa maepelekeye. Alawamona, kiyawa niyewi we selapose esale seli matanepa:, Kote Piseiki epela: peleya: emi ela amowa ki salowemiwa mapatopela: elakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesuyewi ima selese, “Neyawa Kima selakeye. Koteyewi kotoma:na: ikila emiwa Sotome koamesa: sena kesale iwamo falasima:na:wa aso koloteakeye. Alawamona, koamesa: nowamoke kiwa eta: silimananeke sena kesale amawa falasima:na:wa sosokeye. ");
INSERT INTO khs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Apula: Yesuyewi selese, “Sena kesale Kolasini koamesa: kiwa selikeye. Kiwa Koteyawa falasipesakeye! Sena kesale Pesaita koamesa: kiwala selikeye. Kiwala Koteyawa falasipesakeye! Neyawa mono tema:na: tela keteawa Taia koamesa: apula: Saitone koamesa: elipei emiwa Neyawa eta: alamakeye. Kolasini koamesa: apula: Pesaita koamesa:wemi timiya amunusekeye. Alawamona, Neyawa mono tema:na: tela keteawa Taia Saitone koamesa: elipei emi timinisaleke, sena kesale koamesa: emi sita:newa iyewi olokeyatela timiyawa puwano fa:nemi iya:pela: matana notolopela: epesapekeye. Aluse, iwa ewalose ela: tomawa teipo munu tiyapola: sao pusomiya ka tiye sita:pesapekeye. Alawamona, iyawa Ne tima:na: tiwa eta: papomakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Alawamona, Koteyewi kotoma:na: ikila emiwa Taia koamesa: Saitone koamesa: sena kesale iwamo falasima:na:wa aso koloteakeye. Alawamona, Kolasini koamesa: Pesaita koamesa: sena kesale kiwa falasima:na:wa sosokeye. ");
INSERT INTO khs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Apula: Kapaniame sena kesale kiwa Koteyewi hepene falemi silile fiyanaposa esa: matana:sela? Eta: alamakeye. Kiwa tei wa:la peleya: heo kolemi toliyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Au selapita:, Yesuyewi Ewamo kulu hanosene sena ima selese, “Sena kesaleyewi kili sowa ta:tesaleke amowa Ne sowa ta:takeye. Apula: sena kesaleyewi kiwa fa:tapo apolosaleke amowa Newamo fa:tapo apolakeye. Aputa: sena kesale eta:wiye Newamo fa:tapo apolosaleke, Newa hamona e seya Ni ata Kotewala fa:tapo apolakeye. Yesuyawa au selapita: ta:tapola: sena talo tomoipepela: me elipei (72) amowa hapa. ");
INSERT INTO khs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sena talo tomoipepela: me elipei amo mene inisekiwa epeyawalapulu inapola: Yesuma selese, “Sena Sosolo, ho olokeyatela iyawa nini solo seyawa ta:tapola: kulu hapakeye. Ko:yawemiye niyawa ke unuwamo selakamake. ");
INSERT INTO khs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aputa: Yesuyewi mene selese, “Ikila ho olokeyatelayawa kili sowa ta:tapola: kulu hanosekiwa, Setene penaiya opola ewa sutesinise hepene falemi tepela: saiyakolose esene epapupita: Neyawa papokeye. ");
INSERT INTO khs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Alake, Neyawa penaiya opola sosowa kima minase kiyawa hesekewemi onanesaleke apula: ko:nanuwemi onanesaleke amokiwa kiwa mama:naposakeye. Apula: Neyawa penaiya opola sosowa kima minase kili kisi Setene e penaiya opola amowa sopoke kiyewi heletetiye hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Alawamona, kiyawa ho olokeyatelayewi kili sowa ta:tapola: kulu hanosaleke emiwa sa:le sosolo epelepa. Alawamona, Koteyewi kili unua kokolo kao tesene pukawemi momateya amopelekiwa sosolo epelepa:,” Yesuyewi sowa au seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ikila emiwa Ho Napoyewi Yesuma epeya kinapita: Eyewi Kotema selese, “Kewa Ni Atakeye, alanase nano ketea sopoke hepene falemi elakalapulu apula: peleya: sosolo weyemi elakala sopoke Keyewi pote elakeye. Neyawa Ke unua wapilikeye. Ko:yawemiye Keyawa nano ketea sopoke weyamowa Kine Keyawa matana senamawa mupapokeye. Alawamona, Keyawa nano ketea sopoke sala tepeteni weyama waloselakeye. Ni ata, Keyewi au timiya amowa ko:yawemiye Kine napolo matanese elakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Aputa: Yesyewi selese, “Ni Atayawa nano ketea weyamo matanema:na: mouwa opola penaiyawa sopoke Nema tiye mikeye. Alake, sena kesale semetei elayawa Kote E Sa:le Newa eta: matanama elakeye. Kote Enapotane semetiyewi matana elakeye. Apula: sena kesale semetei elayawa Ni Ata Kotewa eta: matanama elakeye. Neye Ninapotane semetiyewi matana elakeye. Alawamona, sena kesale nokala Neyewi ta:pele tiyapola: walosaleke, iyawala matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Au selapola: Yesuwa mene notolo tese Ewamo kulu hanosene senama halute selese, “Koteyawa Kiwa Ene napola:pekeye. Ko:yawemiye si kiliwamokiwa nano ketea sosowa papokeye. ");
INSERT INTO khs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Alake, Neyawa kima heneye selakeye. Sepatosene sena muta nokamokiwala Kamani piseiki sena muta iyawa nano ketea Kiyewi papo epamowa popa:na:pela: matanawamona iyawa eta: papomakeye. Apula: kiyewi topu epamowa iyawala ta:pa:na:pela: matanawamona eta: topumakeye,” Yesuyawa au seya. ");
INSERT INTO khs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ikiwapo nowemi ele matana sena nowamoke tesi tiyapola: Yesuwa talapoiya elapele esa: kapo popa:na:pela: Eyawa mene semita: solo talapoiya nowa Ema ta:papo, “Walosene Sena, newa kokolo kao epesene esa: matanesekiwa neyawa ko:luma:na:napa?” ");
INSERT INTO khs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Aputa: Yesuyawala mene ta:potose, “Kote ele tuwatese momatelesekiwa ko:lu sepapola? Apula: keyawa ko:lu akeyala?” ");
INSERT INTO khs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aputa: eyewi mene selese, “Kote ele tuwatese seyawa welakeye. ‘Neyawa Ne Kote Sosowalapulu himu hanosekiwa himu matanawa sopoke Ewemi ha:na:pa:. Ne hoyawana sopoke Ewemi ha:na:pa:. Ne tomayewi penaiyawa sopoke Ewemi ha:na:pa:. Apula: ne matanawa sopoke Ewemi hanapola: elatipa:. Apula: ela: kine kewamo matanesene amunuse ke mana sitala nokala aluse matanepa:’”. ");
INSERT INTO khs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesuyewi ema mene selese, “Keyawa heneye selakeye. Keyawa alusaleke kewa kokolo kao tesewa tiyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Alawamona sena amoke ewa ene unua wapilise selese, “Ne mana sitalaka ipa:?” ");
INSERT INTO khs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aputa: Yesuyewi pale selese, “Sena semetei nowa Yelusalemewa koamesa: iya:pela: Yeliko koamesa:wemi ha:na:pela: sina:ne. Sina:newanapulu atu tisene senayewi ewa ine saliya:la: sananape apola: e sao kalawa koalo tiye iya:pela: apula: e ketea sopoke moweniwalapulu tiyapola: hanose ewa kuma:na: tepita: ka:pela: enene. ");
INSERT INTO khs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Apula: hapa elapita: Yu pilisiti sena nowa isu semetei kemi mina. Inise potakamake sena sana amowa emi telapita: potapola: ewa isu hema tapowemi aloyetiye hapa. ");
INSERT INTO khs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aputa: Kote koane suwemi tima:na: tisene Lifai sena e maya ewala inise potakamake sena sana amowa isu kiwemi telapita: ewala aloyetiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Aputa: Samelia sena nowana sikape isu kemi inise potakamake sena sana amowa isu ki kemi telapita: potapola: eyawa ewa sosolo hauwekila. ");
INSERT INTO khs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hauwekilalape apola: eyawa senayewi sana:waya amowa eyewi wela hawanapulu waine hawanapulu amoke tuwapola: sakotiye apola: sena amowa tiyapola: ene kopolo toki wa:pa: kemi tuwapola: isuwemi hapakeye. Hanapola: makene hanose enisene koawemi ha:na: tuwapola: yesipela: enikeye. ");
INSERT INTO khs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eniyapola: kiapowemi hanapose ela: koane amo yesila senama Samelia senayewi moweni usu elipei sili tiye ema mi. Kinise selese, ‘Keyawa sena we yesipela: elatipa:. Newa mene inise wa:la:ya heka kema emi miya:na:keye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aputa: Yesuyawa ele walosene senama ta:potose, “Keyawa ko:lu matanepa:? Sena ili usulupe honosane epemiwa sena atu tisene senayewi sana amo e mana telawa ipa:?” ");
INSERT INTO khs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aputa: ele walosene sena eyewi mene selese, “Sena sana amo hauwekilise sesela akeye,” e seya. Yesuyewi ema selese, “Kewa hanosekiwa, epapu timinipa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesuwa Ewamo kulu hanosene senawalapulu hanose koamesa: nowemi ine hetetise potakamake kesale nowa emi elapita: papo. Kesale amo unua Mata. Eyawa Yesuwa siliyapola: e koane suwemi hapa. ");
INSERT INTO khs_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Koane emiwa Mata e akila nowa enene. E unua Meli. Meli ewa Yesu e onatu pawemi ine hela: Yesu solo selakamo ta:ta:sela: henenekeye. ");
INSERT INTO khs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Alawamona, Mata eyawa nano ketea noka koane suwemi selila: apula: ma:na: sata: ela:nenekeye. Aula:sela:, Mata ewa inapola: Yesuma ta:potose, “Sena Sosolo, Keyawa pota newa ninapotane hokokeye. Ne akila epamokiwa newa masesekeye. Alake, Keyawa ema sema newa sesepa: minita:.” ");
INSERT INTO khs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aputa: Yesuyewi selese, “Mata, Mata, kewa nano ketea kalikalila epemi hililise kete mataneselakeye. ");
INSERT INTO khs_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Alawamona, nano ketea semetei nowa telakeye. Amowa nano ketea noka ewalapuluwa eta: ilimakeye. Alake, Meli eyawa nano amo tima:na:pela: matana:sela: helakeye. Alake, Neyawa eyewi tima:na:pela: tiwa eta: tiye iya:pa:na:makeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ikila nowemi Yesuwa peleya: nowemi kulukulula:sela: enene. Kulukulula:newa itapa tepita:, Yesu Ewamo kulu hanosene sena semetei nowamoke Ema selese, “Sena Sosolo, Keyawa niwa kulukulusewa seli waloma Yoneyewi ewamo kulu hanosene sena ima waiya amunuse.” ");
INSERT INTO khs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aputa: Yesuyewi ima selese, “Kiyawa kulukulusekiwa weyamo kulukulupa:. Nini Ni Ata, Kote Sena kesale sopoyawa Ke unu sa:le napolo papalola amo wapilikeye. Alake, kewa nini Piseiki Sosolo tepela: Keyewi putupela: hanapose mina. ");
INSERT INTO khs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Napu ma:na: ma:na:wa iliyetiye maita: kina:pa:. Aluse, ikiwapo sopoke Keyawa kina:sela: elatipa:. ");
INSERT INTO khs_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Apula:, nini olokeyatelawa Keyewi tiye kepoliyetiya:pa:. Ko:yawemiye niyawana sena niwanapulu olokeyatela timinipita:kiwa emawa niyawa kepoliyetima:na:keye. Apula: Keyawa niwa ta:pelema:na: ili tapowemiwa siliye hanapa.” ");
INSERT INTO khs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Aputa: Yesuyewi Ewamo kulu hanose senama pale selese, “Kewa ke mana koane nukulapo honosane ha:na: tese selese, ‘Ne mana ne koane sena makene minakeye. Alawamona newa ma:wa itapakeye. Alake, keyawa ma:ne towapo usulupe telaleke, nema miya:na:wa ililapa? ");
INSERT INTO khs_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aputa: koane inawa ka:pela:la: selese, ‘Ne koane isuwa ta:pe etapeyakeye. Apula: ne salawala fayakeye. Alanase, nine newana ka:pela: elakeye. Alake, keyawa newa tesima e selapa.’ ");
INSERT INTO khs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesuyawa epapu pale selapola: ima selese, “Neyawa kima selakeye. Sena koane ina amokiwa tesi tiye ma:na:wa ili kemawa miya:na: tela. Ko:yawemiye, ewa ke manakeye. Alawamona heneye mouwa ewa tesile mina:na: telawamona keyewi ema sowa penanose ine ta:papowemi elakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Alake, Neyawa kima selakeye. Nano ketea keyewi tima:na: matanawa Kotema ta:ta:sela: elatipa: alusaleke Eyawa kema kinaposakeye. Nano ketea keyewi popa:na: matanawa keya:sela: elatipa:. Alusaleke, Koteyawa kemawa walopesakeye. Apula:, isuwemi kotokotola:sela: elaleke, Eyawa isuwa kema kola:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ko:yawemiye sena kesale sopoke nano ketea iyewi tima:na: matanawa Kotema ta:ta:tesaleke, Eyawa kema kinaposakeye. Alanase, sena nowamoke keya:tesaleke eyawa potaposakeye. Apula: sena nowamoke isuwa kotokotola:sela: elaleke, sena ema isuwa kola:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Alake, sala ina kiyawa ke salayewi ewalo ma:na: e ta:tesaleke kiyawa suikiyana hesekewa tiyapola: kinisena? ");
INSERT INTO khs_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Apula: ke salayewi a:nema: usu ma:na: tekeye e ta:tesaleke, keyawa ko:nanu tiye kinisena? ");
INSERT INTO khs_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aputa:, kiwa olokeyatelawa a ela, alawamona kiyawa ke salamawa nano ketea napolo sopolo kinisene. Alusene amunuse ki Ata napolo Kote hepene falemi elakamokiwa sena nowamoke Ema ta:ta: tesaleke, Eyawa sosolo me kinisekiwa Ho Napowa ema kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ikila nowemi sena nowa ho olokeyatelayewi meaka katatiye solama elapita: Yesuyewi sili tiye iya:peya. Aputa: potapola: ho olokeyatela amowa sena emi enewa iya:pela: hanapita: sena amokiwa sowa me seyakeye. Amo potapola:, sena kesale sopoke tutelise howa hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Alawamona, sena kesale nokamoke selese, “Yesu Eyawa ho olokeyatela sopoke amo ili piseiki amo unua Piaosapapikeye e opola penaiya amo tiyapola: ho olokeyatela amowa hamona e selakamake hanatakeye”, e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aputa: sena kesale nokamoke Yesuwa ta:pele potose selese, “Keyawa hepene falemi timinisewa niyawa popa:na:ke matiminima,” e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Aputa: Yesuyawa iye matana honosane fa:na potapola: selese, “Peleya: semetei nowemi sena emi sita:newemi ikene me tetesaleke, peleya: amowa ikomopesakeye. Apula: sola semetei nowemi ikene tetesaleke, sola honosane amowa ikene takalepela: elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Alusene amunuse Setene e ho olokeyatela iyawa sopoke ikene tetesenekiwa, amowa Setene ewa piseiki epela: peleya: emi ko:lu tesi tiye elaposapa:? Neyawa we selale amowa ko:yawemiye kiye selesekiwa Neyawa Setene opola penaiya amo tiyapola: ho olokeyatela amowa emi sili tiye iya:tatakeye e selesewemi ela: selakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Alawamona, heneye Neyawa Setene e opola penaiya amo tiyapola: ho olokeyatelawa emi sili tiye iya:peyakiwa, amowa henekiwa kewamo kulu hanosene sena iyawa ho olokeyatela sili tiye iya:peyawa penaiya opola ipi nene tiyapola: elala? Amo mou emi ela: kewamo kulu hanosene sena amokiwa kiwa hele walomapetakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Alawamona, Neyawa ho olokeyatelawa Kote opola penaiya emi ela: sili tiye iya:tesaleke, Kote Piseiki epela: ela peleya: amowa kiwemi ine telakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Alake, sena komoyawa ene keteawa koane suwemi tiye tipela: sena nowamoke atu tima:pikise ene ewa isu tenamowemi tetesene keteawa tiyapola: yesipela: tesekeye. Alusaleke, sena nowamoke ene keteawa matiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Alawamona, sena nowa heneye komono mowatapo tepela: inapola: elipei tetalape apola: eyewi sena koane inawa sananape apola: e tetesene ketea penano saliya:ne amowa eyewi o:su tiye iya:pela: apula: e ketea tiye tiwa tiyapola: sena nokalapulu takale tiyapola: tikeye. ");
INSERT INTO khs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Alake, sena kesale Newemi eta: kulu minamananeke, ewa newanapulu kisi elakeye. Apula: sena kesale nowamoke Newa seselese sena kesale eta: sikiyamananeke, sena kesale amokiwa sena kesale amowa Kiyewi pulakepilakeye.” ");
INSERT INTO khs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesuyewi selese, “Ho olokeyatelawa senawemi elape apola: hanakamowa ewa ha:na: senanama seleya peleya:wemi sila:tesenekeye. Sila:selekiwa ewamo epesene peleya:wa ha:le keya:sela: sila:newamona eyawa eta: papomakeye. Mapotapita:, eye selesekiwa, ‘Newa koane puwano nine newamo enene mina kemi mene ha:na:na:keye,’ e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","26","Apula: ho olokeyatela hamona e seya amowa mene koane emi ine tese potakamake koane suwa seli sape tiye napolo elapita: potapola: ewa mene hanapola: ho olokeyatela tomoipewa siliye mina. Ho olokeyatela tomoipe ili mawa hele heneye olokeyatela sosolo timinisekeye. Apula: iwa ha:na: tese emi sita:tesekeye. Apula: elakemiwa sena amowa puwanowa olokeyale tepela: enekeye. Alawamona sikapewemiwa ewa hele heneya olokeyale tepela: elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesuyawa sowa au sela:sela: elapita:, kesale semetei nowamoke kekena honosane emi Yesuma holose selese, “Kewa Ki amayewi alela elapepela: supeliwapo ikila emiwa kesale Kema po ipi mi amawa Koteyawa Ewa napola:tapita: pote helakeye.” ");
INSERT INTO khs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesuyewi mene selese, “Koteyawa sena kesale E sowa ta: tiyapola: kulu hapa amowa sa:le sosolo napola:tesekeye. ");
INSERT INTO khs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sena kesale ilima noka ine kekene tiye elapita: Yesuyewi selese, “Sena kesale napu weyemi falela apota: sitala weyamokiwa olokeyale timinisekeye. Iyawa Nema ta:tesekiwa mono tema:na: tela keteawa timinima e selesene. Alanase, Neyawa mono tema:na: tela keteawa eta: timinima:na:makeye. Alawamona, Neyawa kiwa matanemita: puwano sena Yona ewemi mono tema:na: tela timiya amo selapose ekeye. ");
INSERT INTO khs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Koteyawa Yonawa hamone e seyawa Ninifa sena kesale amoke matanemita: Koteyewi Yonama timiya amowa Koteyewi ima wayakeye. Waya amunuse Sena Sa: Newana ikila yemi sena kesale kiwa falela a sitala weyama Neyewi waloma:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Alake, Solomoneyewi seli matanepela: seyawamona Piseiki kesale Kuiniwa komemi tese ta:pa:na:pela: minakeye. Aputa: kesale Kuini ewa hele peleya: pama tepela: minakeye. Alake, sikape Koteyewi kotoma:na: ikila emiwa sena kesale ikila napu yemi falela a sitalakamowa kesale Kuini amoke iwa kotopesakeye. Solomone ene ewa sena sosolo enene kamona kiwamo sita:ne honosane emi Newa ine ela: Solomonewa helete tiyapola: Newa hele Sosolo elakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sikape Koteyewi kotoma:na: ikila emiwa sena kesale ikila napu yemi falela a sitalakamowa Ninifa koamesa: sena kesale sopoke amokiwa iwa kotopesakeye. Ko:yawemiye, Ninifa sena kesale iwa Yonayewi Kote solo seya amo ta:tapola: matanawa notoyakeye. Yona ene ewa sena sosolo enene kamona kiwamo sita:ne honosane emi Newa ine ela: Yonawa helete tiyapola: Newa hele sosolo elakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sena nowamokiwa imawa tutiyapola: pakia honosane nowemi kopalo suwemi eta: tuwatesemakeye. Eh, eta: alusemakeye. Senayawa imawa tutiyapola: hokato honosane tupa:tesene peleya: emi tuwatesene. Alanase sena kesale inisekiwa ho:liya amo potapola: inisene. ");
INSERT INTO khs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Aputa: ke toma epamo ho:lilima:na:wa kine si epakeye. Alanase, ke siwa napolo elaleke, toma kiwala ho:liyayewi woliyetiye elaposakeye. Alanase, ke siwa olokeyatela elaleke, toma kiwala yopolotelayewi woliyetiye elakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Alanase, seli potapola: matanepa: ho:liya kewemi ela epamowa heneye yopolotelamakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Alanase, toma kiwa sopoke ho:liyayewi woliyetiye elaleke, hepe noka yopolotela maelaleke, toma kiwa ho:liyayewi woliyetiye elakeye. Alusene amowa ima tupa:takamake kewemi ho:lilisene epapupesakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesuyewi sowa sela: ha:na: elepelapita:, Felesi sena semetei nowamoke Yesuma ta:potose, “Kewa ne koane ma:na:ma:na: mina:na:wa ililapa?”, e seya. Au selapita:, Yesu Ewa hanapola: koane suwemi musuluyetiye tuwatenapola: tepolo pawemi ha:na: heya. ");
INSERT INTO khs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aputa: potapola:, Felesi sena ewa tuteilise howa hapa. Ko:yawemiye Felesi sena iyewi ele tuwatesekiwa ikila ma:na:ma:na: elekiwa tiya:wa selakolosene alawamona Yesuyawa tiya:wa eta: selakolamake inapola: helapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aputa: Yesuyewi ema pale selese, “Felesi sena kiyawane kapowala menekiwala fa:se wapa:kamo selakolosene alawamona kili himu fa:nemiwa mane olokeyatelawa woliyetiyapola: apula: kiyawa nano ketea sosolo tima:na: matanese kiyawa eta: sakoma:na:ma matanesene. ");
INSERT INTO khs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Alanase, tikapetela senakeye! Alake, Koteyawa ke tomawana timiye apula: ke howana timiyakeye. Amowa heneye alalapa? ");
INSERT INTO khs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Alawamona, meneki kiwemi nano ketea emi selatela epamo tiyapola: sena kesale nowa ketea itapa tela ela ama sakopa:. Keyawa alusaleke, nano ketea sopoke kewemiwa hili tepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Alake, Felesi sena kiwa selikeye. Ko:yawemiye kiyawa nakela sa:le kalikalila noka elakeye amowa tisekiwa akotaipewa kine tise talo semetiwa Kotema mokopo kinisene. Alawamona, kiyawa sena kesale nokamowa eta: hauweki matanamake ela: apula: Kotewalapulu himu hapa maelakeye. Alanase, talo semetei ketea amowa Kotema kina:pa:. Alanase solo ele tuwapowa aluse kulu ha:na:sela: ele tuwapo solo nokala aluse tiye ha:na:pa: solo ele noka iya:tapa. ");
INSERT INTO khs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Alake, Felesi sena kiwa selikeye. Ko:yawemiye kiwa Yu sena ili kulukulu koanewemi sena ka:la:ya sikapo amo minitapo emi ha:na: seawemi helema:na:wa epelesekeye. Apula: sena kesale ma:na: wa:la:losene koane kekene tiye sita:newemi kiwa emi hanapita: senayewi kiwa tiya: hapomita: kiyawa epelesekeye. ");
INSERT INTO khs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kiwa selikeye. Ko:yawemiye kiwa sena kulu tikila peleya: ta:la elatapo esa: eta: papomake tikila:pela: sena nowa kemi onana hanosene epapula elakeye,” Yesuyewi ima au seya. ");
INSERT INTO khs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesuyewi au selapita:, ele walosene sena nowamoke mene selese, “Walosene sena, ke solo epe selese amokiwa niwana ewala tiyakeye.” ");
INSERT INTO khs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesuyewi mene selese, “Ele walosene sena kiwa selikeye. Ko:yawemiye kiyawa hilila sosowa sena kesale sopoma kinisene. Alanase, iyawa eta: penanose uwapola: hanosemakeye. Aputa: kipitane kiyawa nano ketea nowamokiwa iwa eta: seselamakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kiwa selikeye. Ko:yawemiye sepatosene sena amowa ke mei fa:namoke sana kulukeye kulapita: apana tuwapowa kiyewi seila:tatakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Alake, kiyewi tima:na: epeti seyamoke kili ke mei fa:namoke tima:na: tiwa henenapo esa: sepatosene senala: kululuse tiyatakeye. Kili ke mei fa:namoke sana kulunase kiwa epelese apana tuwapowa seila:tatakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Alanase, Koteyewi seli matana tiyapola: selese, “Ima Neyewi sepatosene sena apula: Apasolo senawa ilikepima:na:keye. Inakemiwa noka sana kulaposakeye apula: noka olokeyale timinipesakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Alake, peleya: sosolo weyamo ma:ta: ti ikila emiwa sepatosene sena sana kulusewa pepetawalapulu emi ma:ta: tiye sane inapola: napu ikila weyemi ine hetetisekiwa sena kesale a sita:newa Koteyewi kotopesakeye. Kotoma:na: ikila emiwa iwa hililawa tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Alanase, puwanowemiwa Eipowa sana pepetawalapulu kulukeye. Sana kulunase amo fo:suwemi sena nokala sana kulukeye. Ala: mina sikapewemiwa Sekalaiyawa Kote koane suwemi sana pepetawalapulu kulukeye etewa kalopowa nono fa:nemi apola: Kote koane numu apoyawa nono komemi apola: Sekalaiyawa honosane elapita: ewa sana kulukeye. Sana kulunase napu ikila weyemi sena kesale a sitala weyamowa Koteyewi kotopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ele walosene sena kiwa selikeye. Ko:yawemiye sena kesale nano ketea napolo ta:tapola: matanemita: koane isu tenamowa kiyewi eta: kolotimakeye. Kiyawala kipitane napolo ketea ta:tapola: matanema:na:pela: koane suwemiwa eta: musuyamakeye. Sena nokamoke nano ketea ta:pa:na:pela: koane suwemi musuluyetiye inapitekiwa kiyawa kalakeye.” Aluse, Yesuyewi koawemi pale seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Apula: Yesuwa iwa sita:ne peleya: amowa iya:pela: hanapita: Felesi senala: apula: ele walosene senala: iyawa Yesuwalapulu kisi tema:na:pela:la: Emawa sowa talapoiya mene ta:papo. ");
INSERT INTO khs_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iyawa Yesuwa hopolose Ewa potoke hapa. Kopolo ka:ne telesene amunakeye iyewi E meatewi solo selakamoke elekiwa ka:ne teya amunakeye. Yesuyawa ilipe sowa mene selesaleke, Ewa kotoma:na:pela: E solo selesewa iyewi ta:tapola: potoke hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ikila emima sena kesale tausene ilimawa emi ine kekenekamake pakiawa teleye tise fa:na:noma:na:wa fowa itapa tese iyewi ili mana nokamo onatuwemi me fe onane elakeye. Ala amo honosane emiwa Yesuyawa Ewamo kulu hanosene sena ima sowa puwano ela:pe ma:ta: tiye sela:sela:, “Felesi sena mane iyewi alusene amowa ma:ne falawa solomita: timinisene amunakeye. Iyewi himu matana elipei tesene amowa kiyawa tima:pikise seli pota:pa:. ");
INSERT INTO khs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Aputa: nano ketea sena kesaleyewi mupatose foye ti amowa Koteyewi kokolotiye hokato honosane apolaposakeye. Apula: Eyawa nano ketea o:sulu mupapowa hokato walopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Aputa: kiwa yopolotela honosane sita:la: solo emi seya amowa sikapewemiwa ho:liya honosanewemi selapita: sena sopoke ta:taposakeye. Apula: kiyewi kipitane koane sulu numu nokemi sita:la: o:sulu kena: setalese seyalaleke, amowa sikapewemiwa sena sopoke ta:pita: koane towemi tesitiye ela: unuwapo ho selaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Aputa: Yesuyewi solo nowa selese, “Ne mana, kima selakeye. Kiwa sena nowamoke kili tomawemi ine sana emi kuma:na:wa ipipa. Sena amokiwa kili howa sana makulaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Alawamona, Neyawa kiwa ipima:na: amowa kima walo sema:na:keye. Kiyawa Kote semetei ipipa:. Eyawa penaiya opola Ewamoke kili tomawa sanapola: heo tei wa:la peleya: emiwa kili howa emi toliyetiyaposakeye. Neyawa wa:ke selakeye. Kiyawa Kote semetei ipipa:. ");
INSERT INTO khs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A:nema: kelakela tepeteni amuna amowa senayewi wa:la:losekiwa a:nema: pipewa moweni usu kulu elipeiyewi wa:la:losene. Alawamona, Koteyawa a:nema: aso kolotea kamona Eyawa eta: kepoliyetima a matanepela: elakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Alake, kiwa ipipa. Sena kesale kiwa wa:la:yawa sosokeye. Alawamona a:nema: tepeteni amo wa:la:yawa aso koloteasukeye. Aputa: Koteyawa kili pisei fano epa semetei semetei esa: Eyawa matane tiye elakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Neyawa kima selakeye, sena nowamoke ela: sena nokama selese “Newa Yesu kulu hanosekeye” au selesaleke, Sena Sa:, Neyawa, Kote E hepene sena amawa sena epa Newamo kulu minakeye e sema:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Alawamona, sena nowamoke sena nokama selese Newa Yesuwa eta: kulu ha:na:na:makeye e selesaleke, Neyawa Kote E hepene sena imawa sena epa Newemi eta: kulu minamakeye e sema:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Aputa:, sena nowamoke Sena Sa: Nema solo olokeyatela selesaleke, Koteyawa e olokeyatelawa kepoliyetiyaposakeye. Alawamona, sena nowamoke Ho Napoma solo olokeyatela selesaleke, Koteyawa e olokeyatelawa makepoliyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aputa: kiwa Yu sena kulukulu koane suwemi kotoma:na:pela: kotosene senawana apula: piseiki senawanapulu iyewi sukulutiye kotoma:na:pela: hana kemiwa kiyawa sowa penanosekiwa ko:lu sema:na:ne apula: imawa sowa menewa ko:lu selaposape esekiwa kete matanepa. ");
INSERT INTO khs_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ko:yawemiye, kotoma:na: ikila kemi Ho Napoyewi solo kiyewi sema:na:wa walopesakeye,” Yesuyawa au seya. ");
INSERT INTO khs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kekena honosane emi sena semetei nowamoke Yesuma selese, “Walosene Sena, Keyawa ne akilamawa sema Ni atawa kuluke ketea ewa na:nipe takale tima:na:keye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aputa: Yesuyewi mene selese, “Sena, Newa sena eta:wi kotosene sena ta:peletiye kewamo apoyala?” ");
INSERT INTO khs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aputa: Eyewi ima selese, “Kiwa nano ketea muta tiyapola: epesene matanesene kiwa selikeye. Ko:yawemiye, sena nowa peleya: sosolo weyemi nano ketea muta elaleke, amowa mouwa itapalase sena amowa e falelawa ikila muta matepesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aputa: Yesuyewi ima pale selese, “Sena nano ketea muta tisene sena amo peleya:wemiwa nakela kelawa sa:le napolo fiyanese fowa muta heyakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Heyalapita: potapola:, ene ela: matanese, ‘Neyawa ko:lupesape? Neyawa nakela weyamo sutiye tuwapa:na:wa koane suwemiwa fowa itapa.’ ");
INSERT INTO khs_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Apula: sikape ene me matanese selese, ‘Neyawa weyamu timinimeina e seya. Koane suwa me ekeyetiye sosolo me tiyapola: emi nakela hene fowa alapulu apula: nine nano ketea sopoke emi tuwapa:na:. ");
INSERT INTO khs_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Apula: nine mene weyamo sema:na:keye, “Nano ketea Niwa napolo sopolo telakeye. Alanase, newa yapene muta teleke ha:na:na:keye. Alake, newa ha:le ela: ma:na: na:sela: apula: hano na:sela: epeya:sela: epesenekeye.” ’ ");
INSERT INTO khs_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Alawamona, Koteyewi ema selese, ‘Keyawa nananotelayewi matanesene amunanakeye! Alanase napu nukulapowemiwa hepa:la kiwa Nine mene tima:na:keye. Aputa:kiwa, ke ketea kine seli tiye ti epeya sena eta:wi tiyaposape?’ ");
INSERT INTO khs_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aluse amunuse, nano ketea weyamowa sena eta:wiye nano ketea muta tiye tiye ela emiwa aupesakeye. Sena amoke elekiwa Kote salo falemi ketea napolo tela amowa ewa hepe tela elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aputa:, Yesuyewi Ewamo kulu hanosene sena ima selese, “Neyawa Kima selakeye. Kiyawa falela hepa:la a epesene emiwa aso matanepa. Apula: kiyawa ma:na: sosolo ma:na: esekiwa asono matanepa. Apula: kiyawa ke tomawemi sao kama:na:wa asono matanepa. ");
INSERT INTO khs_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hepa:la falela kokolo kau tesene amo mouwa sosokeye. Alake ma:na: nasene semetei amakeye. Apula: toma kiliwa sosolo keteakeye. Alawamona sao kalesewa aso koloteakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Alake, a:nema: iwa matanepa:. Iyawa nakela kelawa itapanase iyawa eta: ha:na: sutusemakeye. Apula: iyawa ma:na: tiye tima:na: koawa itapakeye. Alawamona, Koteyewi ela: ma:na:wa ima kinisekeye. Aputa: sena kesale kiwa Kote sikapowemiwa sosolo keteakeye. Alawamona a:nema: iwa aso koloteasukeye! ");
INSERT INTO khs_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Alanase, sena kili muta epamoke ela: nowamokiwa nano ketea kete matanesaleke, sena amokiwa ene ewamo kokolo kau epesenewa opo si semetei nowa me tuwapa:na:wa ililapa? ");
INSERT INTO khs_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Alanase, kiyawa nano kolotea epamowa timinima:na:wa eta: ilimakeye. Alanase, kiyawa nano ketea ma:ne ma:na:wa sosolo kete matanese apula: sao kama:na:wana kete matanese amo mouwa kami ela:? ");
INSERT INTO khs_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kiyawa mowa falafala Akemei amo fiyanesewa matanema. Falafala Akemei emiwa tapolawa eta: timinitiye kalesema. Apula: amokiwa tima:na: eta: tisemakeye. Alawamona, Neyawa kima selakeye. Puwano kini Solomone ewa ela: nano ketea muta ilima ela: eyawa saowa mete napolo kalesene. Alawamona, Akemei amo falafalayawa kini Solomone sao kalesewa amoke me heletetiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Alake, Koteyawa hutiya sololo mowa elaka sao kama:na:wa kinisekeye. Hutiya amowa napuwa elaposa alawamona eliwemiwa ewa tei wa:la sotukepilaposakeye. Weyamowa hele henekeye. Alanase, Koteyewi kiwa sosolo matanese sao kamita: kinaposakeye. Alawamona, kiyewi seli topuwa aso koloteasulakeye! ");
INSERT INTO khs_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Alanase, kiyawa ma:na: naiye hano naiye ema:na: emiwa asono kete matanepa. ");
INSERT INTO khs_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ko:yawemiye, sena kesale matana eta: notoyama ela amokiwa ma:na: naiye hano naiye ema:na: amo kete matana:sela: ela amokiwa Kotewa makulu hanakeye. Ki Ata hepene ela amokiwa keyewi tima:na: matana ela epamowa Eyawa matanetiye elakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Alawamona, kiyawa Kote Piseiki epela: ela peleya: amowa puwano ela:pe matanepa:. Kiyawa alusaleke, Kote Eyawa nano ketea sopoke nokala kima kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sena kesale kiwa a:pele sipi e sa:le kekene tiye apoya amuna elakeye. Alake, kiwa ipipa. Ko:yawemiye, Kote Eyawa Kima epelesa: Kote Piseiki epela: ela peleya: amowa Kima kinaposakeye,” Yesuyewi au seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yesuyewi selese, “Kiyewi ketea muta epe tese amowa sena nokama wa:la:lopela: moweniwa emi tiwa tiyapola: misitiya sena sitala ama sakopa:. Alusene amunusekiwa, pause hili wa:la:lo tiyapola: eta: pitili hanosema epapula emi kiyewi himu hapa hepene falemi ela amowa emi ine sela tiyapola: epesita: apola:pa:. Alusaleke, himu hapa amowa maitapa tepesakeye. Aputa: atu tisene senayawa ma atu tiyaposakeye. Apula: wanapoloyawa manasolopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Peleya: kiwa nano ketea sa:le napolo sopoke tiye tiyapola: tuwatesene emiwa ke himu matanawa emi elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesuyewi selese, “Kiyawa tima:na: tima:na:pela: saowa katiyapola: yesipela: sitalatipa:. Apula: nafa kiliwa ikila sopoke tupa:pela: sitalatipa:. ");
INSERT INTO khs_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Apula: sita:newemi tima:na: tisene yesila senawa kesale silise kekena amowa popa:na: hapawa mene inise isuwemi kotokotosaleke e tima:na: tisene senayewi isuwa kipila koloteaposakeye. Kiyawala alusene amuma:na: esa: matanepela: sitalatipa:. ");
INSERT INTO khs_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Alanase, tima:na: tisene sena amo yesilawa mene inise potakamake tima:na: tisene sena iwa eta: enima ewamo yesipela: sita:ne potosekiwa tima:na: tisene sena iyawa epelepita: potapola: napolo ketea sopowa i salo inaposakeye. Alake, Neyawa kima heneye selakeye. Tima:na: tisene sena yesila amokiwa ene ewa saowa tima:na: tisene senayewi kalesene amuna kapela: ela: selese, “Kiwa tepolo pawemi ka:la:loma” e selapola: ma:na:wa ima sakopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aputa: nukulapo honosanewemiwana kiapo ha:li ikikemiwana tima:na: tisene sena yesila amowa mene inise potakamake tima:na: tisene sena iwa eta: enima sikili sita:ne potosaleke tima:na: tisene senayewi epelepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Alake, solo we kiyawa matanepa:. Sena koane ina nowamokiwa atu tisene sena noka inaposape esa: matanese ene ewa sikila:pela: eta: enimake elaleke, atu tisene senawa e koane sulu emiwa eta: inisemakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Alanase, kiwala ikila sopoke seli tiye sitalatipa:. Ko:yawemiye, Sena Sa:le, Newa opo si semetei nowemiwa kiyawa eta: yesipela: sita:nema emi mene mina:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Aputa: Pitayewi Yesuma ta:potose, “Sena Sosolo, Keyewi pale selesewa nini yamo semetima sela? O sena sopolo sela? ");
INSERT INTO khs_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aputa: Yesuyewi mene selese, “Sena koane ina ene ewa tema makene hanose e tima:na: tisene sena nowamoke tima:na: tisene sena noka eyewi me pota:la: ma:na: nasene okemiwa eyewi kinanatipe e seyakeye. Alanase, tima:na: tisene sena pota: epesene amowa ewa eta: mapolo tesema apula: eyawa tima:na: tisene senawa seli siliye teleke ha:na:na: tela potapola: ta:peletiye apolosene. Alawamona, kiwamo sitala honosane epemiwa sena amunawa ipi elapa:? ");
INSERT INTO khs_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tima:na: tisene sena pota:pesita: ta:peya sena amokiwa epelepesakeye. Ko:yawemiye, ewamo yesila sena tema makene hapa amowa mene inise potakamake tima:na: ema kinapola: hapa semetei kemi enenapita: potose. ");
INSERT INTO khs_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Alanase, Neyawa kima heneye selakeye. Koane ina eyawa tima:na: tisene sena pota: epesene ta:peya sena amawa opola penaiyawalapulu apula: e keteawa sopoke tiyapola: eyewi pota: epesita: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Alawamona, tima:na: tisene sena pota: epesita: ta:peya amokiwa ene mene saleke, “Newamo yesila senawa mene sema inatapo,” e seya. Aluse matanese, eyawa tima:na: tisene sena kesale noka eyewi ma:ta: tiye yasokoya hapakeye. Apula: ma:na: sosolo napela: apula: hano olokeyatela napela: nanono tepela: enekeye. ");
INSERT INTO khs_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Apula: enewemi ewamo yesila senawa ikila nowemi mene mina:na: e seya amowa ewa eta: matanama tikila:pela: enewemi ewamo yesila senawa mene inaposakeye. Mene ina ikila emiwa e tima:na: tisene sena pota:pesita: ta:peya sena ama konomonose sosolo falasisekiwa ewa tikape tela sena kesale sitalakemi hamona e selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Alake, tima:na: tisene sena nowamoke ewamo yesila senayewi matana fa:na telaka eyawa matanetiwamona eyawa amo tapowemi tima:na: tima:na:wa eta: seli timakeye. Alanase, yesila senayawa ewa ilima sanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Alawamona, tima:na: tisene sena nowamoke ewamo yesila senayewi matana fa:na telaka eyawa eta: matanetima ela: eyawa mane olokeyatela timiya:newemi ewamo yesila sena amokiwa ewa aso kolotea sanaposakeye. Alake, sena ketea muta tilaleke, eyawa menewa muta mene kina:pa:. Apula: sena nokamoke sena nowama nano ketea muta tiye minaneke, sena amokiwa menewa muta mi kamunuse kina:pa:,” Yesuyawa au seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesuyewi wa:ke selese, “Peleya: sosolo we teiyewi wa:mita: Neyewi tiye minakeye. Alake, Neye matanawa tei amowa ela:pe kipila wa:mita: matanekeye. ");
INSERT INTO khs_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Alawamona, Newa hano toliyetisene amuma:na: amo tima:na: matanawa hilila elakeye. Alawamona, Neyawa seta: timakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kiyawa Neyawa hopola tesene amo peleya: sosolo weyemi tiye mina esa: matanepa? Eta: alamakeye! Neyawa kima selakeye. Newa sena kesale takalema:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aputa: napu yemiwana apula: sikapewemiwana sena e sola pipe koane semetei nowemi elaleke, amo honosane emiwa elipei takalepesakeye. Takalesekiwa sena usulupeyawa elipeima kisi tepela: elaposakeye. Aputa: sena elipeiyawa usulupemawa kisi tepela: elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aputa: iwa i mene takalepela: sita:la:posakeye. Sala inayawa e sa:ma kisi tiyaposakeye. Apula: e sa:yawa inawanapulu kisi tiyaposakeye. Aputa: yoyawa e la:ma kisi tiyaposakeye. Aputa: e la:yawa yowalapulu kisi tiyaposakeye. Aputa: e sa:le ekele e neiya alapulu kisi tiyaposakeye. Aputa: e sa:le ekeyawa e neiyawalapulu kisi tiyaposakeye,” Yesu Eyawa au seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aputa: sena kesale kekena honosane Yesuyewi ima selese, “Kiyawa nono opo sinisene ilitapo meki falemi hano sima:na: ka:meya potapola: selese, ‘hano sima:na: etakeye’ e selesene. Alanase, sikape heneye hawa sinisekeye. ");
INSERT INTO khs_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aputa: nono komemi alopo penaiya inisaleke, hepoloma:na: etakeye e selesene. Alanase, sikape heneye hepolosekeye. ");
INSERT INTO khs_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Matana elipei tesene senawa kili epakeye! Kiyawa peleya: weyemiwana mei falemiwana ketea emi timinika kiyewi seli matane tiyapola: takalesekeye. Alawamona, napu ikila weyemi mane weyemi timinika kiyawa takalema:na:wa mamatanesewa ko:luse ela:?” ");
INSERT INTO khs_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Aputa: Yesuyewi sowa wa:ke selese, “Kiyawa mane hekeya ketea sopoke takale matanema:na: telawamona ko:luse elala? ");
INSERT INTO khs_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aputa: sena nowamoke kewa kotoma:na:pela: hanose isu honosanewemi ka:lipe konomonawa se tiye iya:ta:pa:. Keyawa sowa ewalapulu selisekiwa penanose sela:pa:. Ka:lipe maselisaleke, kewa siliyapola: koto ta:tesene sena salo siliye hanapola: eyawa kewa ta:le ti salo siliye hanapola: ta:le tiyawa kewa tipolo selawataposakeye. ");
INSERT INTO khs_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Alake, Neyawa kima selakeye, “Kewa tipolo selawapowa menewa sema silikepilaposakeye. Etewa tipolo koane wa:la:lomita: kema ake seya amowa iliyetiyapita: kewa emi silikepilaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ikila semetei emiwa sena noka Yesu salo inapola: selese, “Kalili sena iyawa a:pele sipiwa sanapola: Kotema mokopo kina:sela: sita:newemi kamani pisei sena Pailete e ta:le ti senama selese, ‘Sena a:pele sipi Kotema mokopo kina:sela: epesita: ha:na: heneya sana kula:pa:.’ Aputa: sena sana kulapitekiwa ili pepetawa tiyapola: a:pele pepeta alapulu kemi kesepela: apoyakeye.” Aluse, sena nokamoke Yesuma ine seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aputa: Yesuyewi ima mene selese, “Kalili sena iyawa Kalili sena nokalapulu himu olokeyale matanawa hele sosolo elapita: iwa emi sanana? ");
INSERT INTO khs_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Eta: alamakeye. Neyawa kima heneye selakeye. Kiwala matanawa eta: notoyama elaleke, epapu timinikamake kiwa ikumupesakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aputa: Siloame koamesa: emiwa koane ituwe a falemi ti amo tutuse senawa talo semetei epela: oloipe yasokoluse kulukeye. Alake, kiyawa ko:lu matanepa:? Sena talo semetei epela: oloipe amo olokeyatela timiya amokiwa Yelusaleme sena sopoke emi sitala amo olokeyatela timiya amowa amoke heletetiye hapala? ");
INSERT INTO khs_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Eta: alamakeye. Neyawa kima heneye selakeye, kiwala matanawa eta: notoyama elaleke, epapu timinipesakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesuyewi pale selese, “Sena nowamokiwa ene waine sa:le kela kemi i ko:lu ala kemi kelakeye. Kelanase sikape ene eyawa i ko:lu amowa fowa heya elapele esa: popa:na:pela: minakeye. Alawamona, eyawa fowa eta: heyamanapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Alalapita: potapola:, e a:lekena amo yesila senama selese, ‘Yapene usulupe honosane emiwa i ko:lu amowa fowa heyalole esa: popa:na:pela: minakeye. Alawamona neyawa fowa heyawa semetei nowa mapotakeye. Alanase, ko:lu i epa kema! I eyawa peleya: ipi semetei kamo tiya:sela: enene weyamowa ko:luse elala? ");
INSERT INTO khs_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Aputa: a:lekena amo yesila senayewi mene selese, ‘Newamo yesila sena, i ko:lu epa yapene semetei nowemiwa neyewi a pota:la: i mouwemi peleya: napolo ta:sana: apula: mena tapowa kina:pesa:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aukamake yapene no fa:nemiwa fowa helesaleke, amowa ilikeye. Alawamona, i amowa fowa mahelesaleke, kema e sela:pa:.’” ");
INSERT INTO khs_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ha:le tesene ikila semetei nowemi Yesuwa Yu sena kulukulu koawemi Kote sowa waya:sela: enene. ");
INSERT INTO khs_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aputa: kulukulu koane sulu emiwa kesale semetei nowa ho olokeyatelayewi kesale emi sine ela: kesale amawa nakola kinisekiwa yapene talo semetei epela: oloipe enekeye. Apula: enene emiwa, kesale amo fa:sekiwa kukusa:pela: sila:tesene. Sila:selekiwa hekeya eta: tesitiye hanosemakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aputa: Yesuyewi kesale amo potapola:, e salowemi minita: ho tiyapola: ema selese, “Kesale, ke nakola epa Neyewi iya:takeye. Alake, kewa keli napolo elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Au selese, Yesuyewi kesale amowa tiya:yewi ha:na: kesakamake kesale amo fa:se kukusutela enewa kipila me heka:pe. Aputa: potapola: kesale amokiwa Kote unua wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesuyawa aputa: potapola:, kulukulu yesila piseiki sena eyawa ha:le tesene okemi Yesuyewi kesale nakola amowa faletatapo esa: konomonose sena kesale tisa ama selese, “Tima:na: tisene ikilawa tekapeipekeye. Alanase, kiyawa kiwemi nakola falemita: matanesaleke, tima:na: tisene ikila tekapeipa: emi ina:pa:. Alawamona ha:le tesene okemiwa inapa,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Alawamona, Sena Sosolo ema mene selese, “Kiwa himu matana elipei tesenekeye. Aputa: solo kiyewi selesekiwa apula: mane kiliwala amowa kalilakeye. Kiyawa ikila ha:le tesene emiwa kopolo kau koane hanapola: kili kopolo kau koma:pewa apula: toki koma:pewala elipei faketiye hano ma:na: sikili tiye hanosena? ");
INSERT INTO khs_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Alawamona, kesale weyamowa Epalaha:me e la:le semetikeye. Apula: Seteneyewi kesale amowa nakola timita: yapene talo semetei epela: oloipe emiwa ewa tapola: enekeye. Alanase, Neyawa kesale tapoya epamowa ha:le tesene okemi fakekepilisaleke, amowa eta: ilimanapa? ");
INSERT INTO khs_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Eyawa au selapita: ta:tapola:, E kisi senawa sopoke ewala sosolo tikeye. Apula: sena kesale sopoke Yesuyewi mane napolo sopoke timiya amo potapola: iyawa sosolo epeya. ");
INSERT INTO khs_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesuyewi ta:potose, “Kote Piseiki epela: ela peleya: amowa ena ketea wamunana? Kote Piseiki epela: ela peleya: amo ko:lu sema:na:napa? ");
INSERT INTO khs_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kote Piseiki epela: ela peleya: amowa i maseta mupusu amunakeye. Aputa: sena nowamokiwa ene a:lekenawemi i maseta mupusu amowa tiyapola: emi fipila: hapakeye. Fipila: hapa amo fiyanesekiwa heneye i amuna fiyatesene epapula elapitekiwa ituwe a:nema:yawa inapola: iyawa i ele emiwa a:nema: aiwa emi ine tisene.” ");
INSERT INTO khs_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aputa: wa:ke Yesuyewi ta:potose, “Kote Piseiki epela: ela peleya: amo ko:lu sema:na:napa? ");
INSERT INTO khs_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kote piseiki epela: ela peleya: amowa ma:ne falawawemi solomita: tuwatesene yisi amunakeye. Aputa: kesale semetei nowamoke yisi amowa tiyapola: falawawala muta tiyapola: notolokamakiwa ma:ne falawa amowa sosolo soya potosene. ");
INSERT INTO khs_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesuwa Yelusaleme hanosene isu emi hapa. Hanapola: koamesa: nowemiwana taune nokemiwana Kote sowa waiye sila:nekeye. ");
INSERT INTO khs_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Waiye hanapita:, sena nowamoke Yesuma ta:potose, “Sena Sosolo, Koteyawa sena aso mutama mene siliyaposapa? Aputa: Yesuyewi ima mene selese, ");
INSERT INTO khs_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kiwa mete temekelalape epela: isu tenamo teletela emiwa emi musuluyetiye hanaposakeye. Alake Neyawa Kima selakeye. Sena kesale muta sopoke isu tenamo teletela emi musuluma:na:pela: matana minawamona iwa mamusulupesakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Alake, sikapewemiwa koane inawa tesile inapola: isuwa etapelaposakeye. Aputekiwa, kiwa mowa kolemi ine sita:la: isuwemi ine kotokotola:sela: selese, ‘Sena Sosolo, isuwa koloma.’ e selaposakeye. Alawamona koane ina eyewi kima mene selesekiwa, ‘Kiwa ipa:?’ Apula: ‘Kiwa kami tese minana? Alanase, kiwa eta: potosemakeye,’ e selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Au selapitekiwa, kiye mene selesekiwa epapu selaposakeye, ‘Kewa ma:na:wanapulu hawanapulu ninipe na:na:kaka apula: kewa niwamo hanosene isuwemi tesitiye ela: emi walo selalakaka’, e selaposakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Alawamona, Eyawa kima mene selesekiwa, “Kiwa nono kami tese minana? Alanase, kiwa Neyawa eta: potosemanakeye. Alanase, kiwa mane olokeyatela timinisene sena kesale kiwa sopoke Ne salowemiwa inapa. Kiwa sopoke meneyetiye hamona, e selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ikila emiwa, kiyawa Epalaha:mewana Aisakewala Yakopewala apula: sepatosene sena nokala sopoke Kote Piseiki epela: ela peleya: emi sita:lapita: potaposakeye. Alawamona, kine kiyewi ela: Koteyewi kiwa hematapo polutiye ilikepilaposakeye. O:kemiwa, kiwa sosolo ya:pelesa: kine pesewa kalo naposakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aputa: potapola: sena kesale opo inisene tapo emiwana opo sinisene tapo emiwana apula: nono fa:ta:miwana komemiwana inapola: kekene tiye Kote Piseiki epela: ela peleya: emiwa tepolo pawemi ine ka:la:lopesakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Alake, sena kesale napu weyemi noka puwano sitalaka sikape me ha:na: tepesakeye. Aputa: sena kesale napu weyemi noka sikape sitalaka puwano me ine tepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ikila emiwa Felesi sena noka Yesu salo inise selese, “Heloteyawa Kewa sama:na:,” e seyakeye. Alake, “Kewa peleya: we iya:pela: peleya: nowemi ha:na:pa:.” ");
INSERT INTO khs_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Au selapita:, Yesuyewi mene selese, “Kiyawa mowa kasolo epamawa sela:pa:, ‘Napu eliyeliwemiwa Neyawa sena nakola towaya amowa fala:waloma:na:keye. Apula: sena ho olokeyatela fiyane tiyawa sili tiye iya:waloma:na:keye. Tima:na: amowa tiye ha:na: tese osolo ikilawemi ha:na: itapa tema:na:keye.’ ");
INSERT INTO khs_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Alawamona, napuwala eliwala ineniwana Newa Yelusaleme sitiwemi ha:na:na:keye. Ko:yawemiye, sepatosene senawa Yelusaleme siti hepawemiwa sanose kuma:na:wa eta: ilimakeye. ");
INSERT INTO khs_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yelusaleme, Yelusaleme, keye elekiwa Kote E sepatosene senala: noka sopoke keyewi yasokoluse kulusekeye. Apula: keye elekiwa Koteyewi ilikepiya senawa siliye hanapola: etewayewi tapapuluse olokelese kulusekeye. Alanase, ikiwapo mutawemiwa Neyawa ke salawa sopoke kekene tiye epesene matanakeye. Amowa a:nema: kokonoyewi e salawa kekene tiyapola: ene epi hanewemi fopulusene amuma:na:pela: elakeye. Alawamona, kiyawa mapolo selakeye! ");
INSERT INTO khs_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Alake, kiwa ta:ta:pa:. Koamesa: kiliwa ikomonose olokeyatele tiyaposakeye. Neyawa heneye kima selakeye. Kiyawa Newa wa:kewa mapotaposakeye. Alawamona, sikape Newa ina ikila emi potose selesekiwa, ‘Sena Kote unuwemi tese mina amowa Koteyawa ewa napola:pela: apolaposakeye.’” ");
INSERT INTO khs_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ha:le tesene ikila nowemi Yesuwa Felesi sena piseiki epela: tesene amo koane suwemi musuluyetiye tuwatenapola: ma:na: ma:na:pela: hapa. Aputa: sena iyawa Ewa seli papokeye. ");
INSERT INTO khs_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Apula: sena nowa toma sopoke pipiti nowa Yesu minitapo enekeye. ");
INSERT INTO khs_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aputa: potapola:, Yesuyewi Felesi sena apula: ele matana senama ta:potose, “Ha:le tesene ikila weyemiwa nakola fala:tesaleke, ele tuwapo seyawa, ililapa?” ");
INSERT INTO khs_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Au selakamakewa, iyawa sowa menewa eta: seyamakeye. Alanase, Yesuyewi sena nakola amowa siliyapola: fala:pela: apoya. Apula: ewa ‘hamona’ e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aputa: Yesuyewi ima ta:potose, “Kiyawa ha:le tesene ikilawemiwa kine salawala apula: kine kopolo kau nowa hano ta:la uwalokemi sutesine elapitekiwa kine kiyawa kipila ha:na: sili tisena? ");
INSERT INTO khs_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Au selapita:, iyawa sowa menewa eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesuyewi ene potakamake, sena nokamokiwa sena ununa ka:la:losene ela:pe emi helema:na:pela: helepita: papo. Aputa: potapola:, Yesuyewi sena kesale sopoke koane ina ina:pa: e seya amawa solo pale selese, ");
INSERT INTO khs_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Alake, sena nowamoke kewa kesale senama ha:na: sepelese kekenema:na:pela: kewa ina:pa: e selesaleke, kewa hanosekiwa sena ununa ka:la:losene peleya: emiwa ha:na: helepa. Ko:yawemiye, amowa sena sa:le ununa helemita: ta:peletiye apoya eneke epesakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Keyawa alusaleke, koane ina ka:ko:mo mina e seya sena amokiwa ke salo inapola: kema selesekiwa, “Kewa tesitiye ha:na: sena ununa helesene seawemi helese ununa sena epa kewamo henene sea emi ha:na: helema e selaposakeye. Alusaleke, Kewa sosolo ewalose koane fapalu tapo ha:na: helepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Alanase, sena nowamoke kewa mina e selesaleke inisekiwa koane fapalu tapo sikape komemi ine helatipa:. Alusaleke, koane ina ene ewa inise kema selesekiwa, ‘Ne mana, kewa puwano fa:temi ha:na: helema’ e selaposakeye. Alusaleke, kilipe ka:ya:la sikapo epemiwa kewa sosolo ununa tila:tese epesakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sena eta:wiye ene unua wapilisaleke, Koteyawa sena amo unua kolotea me sine apolaposakeye. Alawamona, sena eta:wiye ene unua me sinapola: elaleke, Koteyawa sena amo unua a falemi tila:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesuyawa Ewa ma:na: na: mina e seya sena ama selese, “Keyawa tikinisekiwa ke ma:ewana ke manawana ke solawala apula: sena nano ketea muta tela sena amowa sopoke ina:pa: e selapa. Keyawa ina:pa: eselesaleke, sikapewemiwa iyawala heka mina e selapola: emi mini heka mene kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Alawamona, keyawa tikina tiye selesekiwa, sena misitiya elakala apula: sena toma olokeya towaya elakala apula: sena onatu kete towaya sitalakalapulu apula: sena si kola ela alapulu amowa sopoke ina:pa: e sela:pa:. ");
INSERT INTO khs_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Sena amowa keyewi ina:pa:saleke, sena ili amokiwa kewa heka minalawa maselaposakeye. Alawamona, Koteyawa kewa seli napola:taposakeye. Alanase, hekeya sena tikila amowa mene tesila ikila emiwa Koteyawa kewa wa:la:ya heka sosolo mene kinaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aputa: sena semetei nowa tepolo pawemi henene amoke Yesuyewi solo seya amo ta:tapola: Yesuma selese, “Sena kesale eta:wiye Kote Piseiki epela: ela peleya: emi tikinise ma:na: mena amowa emi ka:la:lopela:la: nasaleke iwa sosolo epelepesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Aputa: Yesuyewi pale selese, “Sena nowamoke tikinima:na:pelekiwa eyawa nano keteawa sopoke timonutiye tiye tisekeye,” e seya. “Apula: ela: eyawa sena kesale mutawa sopoke emi ina:pa: e selesene. ");
INSERT INTO khs_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aputa:, tikina oka hetetiyapitekiwa, eyawa ene e tima:na: tisene sena nowa sena kesale eyewi ina:pa: e seyawa sekolupese ‘hamona’ e seyakeye. Sena amoke ha:na: selesekiwa, “Nano keteawa sopoke timonuye tiyapola: iliyetiye elakeye. Alake kiwa sopoke mina, e seya. ");
INSERT INTO khs_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Alawamona, sena kesale iyawa sopoke tutuma seyakeye. Tutuma selesekiwa, sena nowamoke selese, “Aso napute yemi, neyawa peleya: nowa wa:la:yanase amo popa:na: ha:na:na:nakeye. Alake, newa eta: mina:na:manakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aputa: sena nowamoke selese, “Neyawa kopolo kauwa taloipe tima:na: tima:na:pela: napute wa:la:yakeye. Alanase, newa amo ta:pele popa:na: hanakeye. Alanase, newa eta: mina:na:manakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wa:ke nowamoke selese, “Newa kesalewa napute tinase newa eta: mina:na:makeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Au selapita: ta:tapola:, tima:na: tisene sena amowa mene hanapola: ewamo yesila senama seyakeye. Aputa: ta:tapola:, koane ina amokiwa sosolo konomonose e tima:na: tisene senama selese, “Kewa kipila hanapola: isu sosowala apula: isu koloteawala amowa taunewemi hanosene isukeye. Alanase, kewa hanapola: sena misitiyawala apula: sena toma olokeya towaya sitalakalapulu apula: sena onatu ketetela towaya alapulu apula: sena si kola ela alapulu amowa sopoke sikili tiye ne koane suwemi ina:pa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Aputa: tima:na: tisene sena amoke selese, “Piseiki sena, keye nema selesewa neyawa au timiyakeye. Alawamona, fowa elatakeye.” ");
INSERT INTO khs_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aputa: sena sosolo amokiwa e tima:na: tisene sena ama selese, “Kewa taunewa heletetiye isu sosowemi ha:na: tese potakamakewa ili tese sole fiyane emi nakela sa:le kela isu tiapo emi keliyetiye tuwatene pota:pa:. Sena kesale emi sitalaka sikili tiye ina:pa:. Alusaleke, ne koawa woliyetiyapesakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Alanase, Neyawa kima selakeye. Sena kesale puwano Neyewi ina:pa: e sekepeya iyawa ne ma:na: mena weyamowa iyawa kolotea mama:ni potaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sena kesale muta Yesuwalapulu ha:na: tiya. Ha:na: tiya:sela: Yesuwa mene notolo tese ima selese, ");
INSERT INTO khs_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sena kiwa nowa Ne salo mina:na: matanesekiwa, ki ata ki ama kine kesale kine ke sala kine ke ma:e apula: kine ke ate apula: kine kewamo teleke ha:na:na: amo tapowa sopoke eta: fa:tapo apolosema elaleke, sena amowa Newamo eta: kulu hanosema sena elakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Apula: sena eta:wiye ene i kelipapoyawa eta: uwapomake Ne salo makulu inisaleke, sena amowa Newamo eta: kulu hanosema sena elakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Aputa: sena nowamokiwa ituwe koane a falemi tima:na:pelekiwa puwanowa ela:pe moweni koane tima:na: amo ketea wa:la:loma:na:wa ili telapele esa: ake potosena? ");
INSERT INTO khs_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Aputa: eyawa puwanowa eta: alamananeke, eyawa a:pa:sulu sekapo semetei ke tiyapola: sanumu semetei tiye tiyapola: heneye koanewa eta: tima ke iya:tesenekeye. Aputekiwa sena nokamoke ewa potose akotiye tuwatese selese, ");
INSERT INTO khs_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Sena epamokiwa koawa tima:na:pela: ma:ta: tiye tiwamona eta: titimanakeye, e selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aputa: kini nowamoke kini nowanapulu tepa:na:pelekiwa, eyawa puwanowa hela: emi seli matanesene. Eye matanesekiwa ene eyawa ami ta:le tiwa tausene taloipe (10,000) ela. Alawamona kini pa:ta nokemi tese inakamokiwa ami ta:le tiwa tausene talo elipei (20,000) ela tapo esa: matanesene. Alanase, puwano eyewi matanesekiwa, Neyawa kini pa:ta epalapulu tetakamakiwa neyawa iwa ili pulatiye iya:taposapela: esa: matanesene. ");
INSERT INTO khs_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eyawa kini amo ami ta:le ti iwalapulu tetesekiwa iwa eta: pulatiye iya:pa:na: telamananeke, kisi senawa pama kemi sitalakemi eyawa sena noka emi ilikepilise selaposa, ‘Ninipe eta: tepa:na:makeye,’ e selesene. ");
INSERT INTO khs_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Alusene amunuse, kiwamo sitala honosane epemiwa sena semetei nowamokiwa kine ke keteawa eta: fa:tapo apoyamananeke, sena amowa Newamo kulu hanosene sena maelakeye.” ");
INSERT INTO khs_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesuyewi selese, “Solu noiyawa sa:le napokeye. Alawamona solu noiya amowa itapa tesaleke, wa:ke nonomitekiwa ena timinisena? ");
INSERT INTO khs_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Solu eta: noiyama amowa peleya:wemiwana apula: kopolo kau ili ola alapuluwa eta: ilimakeye. Amowa mowawemi sotukepilisekeye. Sena kesale eta:wiye kiwa kena:wa elaleke, seli ta:ta:pa:,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ikila emiwa takese tisene senawana apula: olokeyaletela timinisene sena nokala sopoke Yesu enene pawemi inapola: Yesu E solo seya amo ta:pa:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Inapola: potapola:, Felesi senayawana aputa: ele walosene sena iyawala konomonose selese, “Sena weyamokiwa olokeyatela timinisene senawanapuluwa mana timinise iwalapulu ma:na:wa natakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aputa: potapola:, Yesuyawa ima pale selese, ");
INSERT INTO khs_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Sena semetei kili nowamokiwa a:pele sipiwa sakopolo semetei (100) sita:newamona semetei nowa mowa kelekeye tiyapitekiwa sena semetei amokiwa e a:pele sipi talo akotaipe epela: me akotaipewa iwa peleya: hokatowemi ha:na: apolapola: eyawa a:pele sipi semetei kelekeye ti amowa kelekamakiwa ili potaposapa? ");
INSERT INTO khs_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eyawa a:pele sipi amowa keye ha:na: potosekiwa, epelese talo tiyapola: seli honowemi wala sakotapeyakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ewa koane mene ine fiyatesekiwa, sena e mana nokala apula: e koane pawemi sitala sena kesale iwa sopoke minite holose selese, “Neyewi a:pele sipi kelekeye ti keya:newa paponase kiyawala newanapulu epelepa:,” e selesene. ");
INSERT INTO khs_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Aputa: Yesuyewi selese, “Neyawa kima heneye selakeye. Sena olokeyatela timinisene nowa matana notolosaleke, hepene falemiwa epapuluse epelepesakeye. Sena talo akotaipe epela: me akotaipewa matana notolopela: hekeya sitala amawana epelesene. Apula: iwa ela:pe matanawa notoyakanase wa:kewa matana manotolopesakeye. Alawamona, sena olokeyatela honosane sine enene amo matana notolosaleke, hepene falemiwa sosolo epelesekeye. ");
INSERT INTO khs_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesuyewi wa:ke pale selese, “Kesale semetei nowamokiwa moweni usu uluyeti taloipe amowa nowa koane suwemi keleke tisaleke, eyawa ko:lupesapa:? Eyawa nafawa tutiyapola: koane suwa sapelese seli kelese moweni usu uluyeti semetei amowa keye ha:na: tese emi tisene. ");
INSERT INTO khs_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Eyawa moweni usu uluyeti semetei amowa potose tisekiwa sosolo epelesene. Epelese e mana nokala apula: e koane pawemi sitala sena kesale iwa sopoke minite holose selese, ‘Neyewi moweni usu uluyeti kelekeye ti keya:newa paponase kiyawala newanapulu epelepa:,’ e selesene. ");
INSERT INTO khs_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Alanase, Neyawa kima selakeye, aluse epelesene epapulusekiwa, sena olokeyatela timiya:sela: enene sena amowa matana notolo kemiwa Kote e hepene sena iyawa sopoke epapuluse sosolo epelesekeye.” ");
INSERT INTO khs_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aputa: Yesuyewi pale selese, “Sena nowamokiwa sena sa: elipei kesilakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aputa: sala sitowi inama selese, ‘Ni ata, ke ketea ne akila na:ma takaletiye miya:na e selalaka nine nema ela:pe matina,’ e seya. Aputa: potapola:, inayawa e keteawa takaletiye e sa:le elipeima tiye mi. ");
INSERT INTO khs_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aso komaiyama kemi, sala amokiwa ene keteawa sopoke yetuwemi kamona tiyapola: ewa makene peleya: pama nowemi hapakeye. Peleya: emi ha:na: elekiwa nano ketea e tiya hapa amowa sopoke tima:na:ma tise sotukaiya:sela: kotetikeye. Ko:yawemiye, e falela nano kalikalila olokeyaletela timinima:na: amo matanesekeye. ");
INSERT INTO khs_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ikila emiwa ewa mowenilama henese enewemi, peleya: emiwa meinawa sosolo ine heteti. Aputa: potosekiwa, sala amokiwa nano ketea nowa tima:na: matana. ");
INSERT INTO khs_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Alanase, sala amowa ha:na: tese peleya: amo sena nowamo salowemi tima:na: emi ha:na: tikeye. Sena amokiwa sala ewa e kopolo potapola: kopolo apoya peleya:wemi ma:na: kina:sela: elapamona e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aputa: ewa kopolo ma:na: kina:sela: ela: eyawa kopoyewi ma:na: mena amo potose eyawala heka ma:na: matana ko:yawemiye sena nowamokiwa ewa ma:na:wa eta: mimakeye. Alanase, eyawala ene nase kuka telima:na: esa: matanakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Alawamona, eyawa matana napolo matanese ene mene selese, ‘Ni ata tima:na: tisene sena iyawa ma:na:wa ili elakeye. Alawamona, newa weyemi ine tela weyemiwa meinawa sosolo tekeye!, e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Alanase, newa mene ni ata salo tesile ha:na:na:keye. Apula: ema sema:na:keye. Selesekiwa, “Ni ata, neyawa Kote hepene ela alapuluwala kewalapuluwala neyawa hele olokeyatela timiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Alanase, newa olokeyatela senake keyawa newa ni sa:le elawa selapa. Alanase, keyawa newa mona ke tima:na: tisene sena apola:pa:.’ ");
INSERT INTO khs_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Apula: matane tiyapola: ewa tesile ina salo mene hapakeye. Ha:na: koane pawemi inakamake inayawa ewa pama komemi inapita: potapola: eyawa e sa:wa sosolo hauwekilise kipila ha:na: tese e sa:wa talo tiyapola: minipikeye. ");
INSERT INTO khs_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aputa: potapola: e sa:yewi inama selese, “Ni ata, neyawa Kote hepene ela alapuluwala kewalapuluwala neyawa hele olokeyatela timiyakeye. Newa olokeyatela senake keyawa newa ni sa:le elawa selapa,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Alawamona, sala inayewi e tima:na: tisene senama selese, ‘Kiyawa nine sao sa:le ekela hili kalesene epa kipila tiye inapola: sala epemi kapema. Apula: nano ki tiya:wemi kalesewa kapela: apula: tamakawala e onatuwemi kapema. ");
INSERT INTO khs_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Apula: kopolo kau e sa:le seli napolo soya ilima nowa talo tiye inapola: sama. Apula: niyawa epelese ma:na:ma:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ko:yawemiye, ni sa:le weyamowa kulukeye. Alawamona ewa napuwa mene tesile falela apota: elakeye. Ewa kelekeye tiwamona neyewi nakelesa: mene silikeye.’ Aluse iyawa epelese ma:na:wa sosolo menakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ikila emiwa e sa:le ola:ka a:lekenawemi enene. Elapeyapola: koane mene inise ta:takamake epelese kisala amo feya inapita: topukeye. ");
INSERT INTO khs_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aputa: eyawa ina tima:na: tisene sena semetei nowama holose ta:potose, ‘Epa ena tiyalape?’, e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Au selapita: tima:na: tisene sena amoke mene selese, “Ke ma:ewa mene minakeye. Aputa: potapola: ki atayawa kopolo kau e sa:le seli napowa sanakeye. Ko:yawemiye ke ma:ewa seli mene minakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aputa: ta:tapola:, sala ola:pe amowa sosolo konomonose koane suwemiwa eta: mina:na:makeye. Aputa: inayewi ine tese hopo seya. ");
INSERT INTO khs_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Alawamona, inama mene selese, ‘Ni ata keyawa ta:pa. Newa yapene ilima sopoke ke tima:na:wa hokole minakeye. Amowa mona tima:na: tisene sena epapula enekeye. Aputa: neyawa ke solo seyawa eta: iya:pelesemakeye. Ala emiwa keyawa newa nine ne manawanapulu epelemitekiwa nanekose e sa:le semetei nowa nemawa masanotiye kini selapokeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Alawamona, ki sa:le sipi epamokiwa ke ketea sopoke itapa kotetiyapola: ha:na: ela: eyawa iwei tisene kesalewalapulu enenapokeye. Ala:sela: enene amo mene inapita: keyawa sa:le kopolo kau e sa:le seli napowa sanotiye kiniselakeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aputa: inayewi selese, ‘Ni sa:le kewa ikila sopoke newanapulu enekeye. Alanase, ketea niwa sopoke kinakeye. ");
INSERT INTO khs_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Alanase, niyawa napuwa epelepa:. Apula: nine matana fa:na napolo tepa:. Ko:yawemiye, ke ma:ewa kulukeye. Alawamona ewa mene tesile falela apota: elakeye. Ewa kelekeye tiwamona napuwa ewa niyewi mene silikeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesuyewi Ewamo kulu hanosene senama pale selese, “Ketea muta tela sena amokiwa e ketea amo yesipela: tesene sena nowa enekeye. Aputa: sena noka inapola: ketea muta tela sena ama selese, ‘Ke ketea yesipela: tesene sena epamokiwa ketea kiwa eyewi tiya:sela: kotetikeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aputa: ta:tapola:, eyawa e ketea yesipela: tesene sena amowa holose selese, ‘Keyawa ko:yala? Neyawa ke timiya solo nowa topukeye. Keyawa ne ketea sopoke keyewi pote elaka momatetiye aketiye nine nema tiye ina:pa:. Alanase, kewa ne keteawa keyawa wa:ke mapote elaposakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Aputa: ketea amo yesipela: tesene sena amoke ene mene selese, ‘Newa ko:lu timinima:na:ne? Newamo yesila senayawa newa e tima:na: tiya:newa iya:pa:na:,’ e seyakeye. ‘Alanase, newa sena nowamo tima:na: tisene sena tepela: peleya: motole ha:na:na:wa penaiyawa itapakeye. Apula: sena nowamo salo newa moweni mita: halo ta:pa:na:wa newa ewakeye. ");
INSERT INTO khs_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Alanase, neye timinima:na: ketea nowa neyawa matanekeye. Alanase, newamo yesila senayewi newa e tima:na: tiwa iya:tapitekiwa, sena nokamokiwa newa ili koawemi siliyaposakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aputa: eyewi sena nokamoke mini hepe ewamo yesila sena alapulu ela amowa sopoke holakeye. Aputa: eyawa sena nowa ela:pe puwano inapita: ama ta:potose, ‘Keyawa sena newamo yesila sena alapuluwa mini heka ena ipa: telape?’ ");
INSERT INTO khs_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Aputa: sena amoke mene selese, ‘Neyawa i olofiwemi wela wasuwa sakopolo semetei (100) tolomowemi ta:pelese susawa neyewi tikeye.’ Aputa: ketea amo yesila senayewi ema selese, ‘Alalapita: keyawa kipila helese mini heka pukawemi momatelesekiwa sakopolo semetei (100) miya:na: telawamona amowa hetetise talo pipe miya:na: esa: pukawemi momatepa:.’ ");
INSERT INTO khs_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Apula: amo fo:suwemi sena nowa emi inapita: sena ama ta:potose, ‘Keyawala mini heka ena ipa: telape?’ Aputa: eyewi mene selese, ‘Neyawa witi fowa elalewemi selawa sakopolo semetei (100) tikeye,’ e seya. Aputa: ketea amo yesila senayewi ema selese, ‘Alalapita: keyawa sakopolo semetei mene miya:na: telawamona iya:tese talo oloipe miya:na:keye. Esa: mini heka pukawemi momatema,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aputa: potapola:, sena hele timiya:ne amo yesila senayawa e tima:na: ti amo potapola: e unua a falemi tila:pekeye. Ko:yawemiye eyawa matana napolo senayewi timinisene amupita: potapola:. Alanase sena kesale eta:wiye peleya: sosolo weyamo mane amo kulu ha:na: tesaleke, iyawa sena peleya: sosolo weyamo mane amo kulu ha:na: tese amowa iwamuna iwalapulu tima:na: tisene matana napolo elakeye. Sena ili amokiwa sena nono ho:liya tapo sitalaka iyewi heletetiye hanose ekeye. ");
INSERT INTO khs_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Alake, Yesuyewi ima selese, “Neyawa kima selakeye, nano ketea olokeyatela kiyewi peleya: sosolo weyemi tesela amokiwalapulu sena ke mana fa:na amoke siliya:pa:. Aluse, ketea kiwa emi kotetisekiwa iyawa kewa hepene peleya: kokolo kau tesene koane falemi mene siliyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Alake, sena nowamoke nano ketea kolotea nowa seli pote tesenaneke, sena amokiwa nano ketea sosowa eyawa seli pote elaposakeye. Aputa:, sena nowamoke nano ketea kolotea nowemiwa mane hekeya eta: timiyamananeke, sena amokiwa nano ketea sosowemiwa eyawa mane hekeya matiminikeye. ");
INSERT INTO khs_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Alanase, kiyawa moweni olokeyatela peleya: weyemima eta: seli pote enemananeke, sikapewemiwa kimawa heneye nano ketea sosowa kiyewi pote epesita: sena eta:wi kinaposape? ");
INSERT INTO khs_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Apula: kiyawa nano ketea sena nowamo eta: seli pote enemananeke, sikapewemiwa kimawa nano ketea kinewa sena eta:wi tiye kinaposape? ");
INSERT INTO khs_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Alanase, tima:na: tisene sena nowamokiwa yesila sena elipei hasu tapowemiwa eta: tesemakeye. Alusaleke, eyawa nowanapuluwa sosolo matanese nowamowa eyawa mapolopesakeye. Apula: eyewa nowamo seyawa ta:tese nowamowa fa:tapo apolaposakeye. Alanase, kiwa Kote hasu tapowemiwana apula: moweni tapowemiwana ha:na: elatepa,” Yesuyewi au seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aputa: ta:tapola:, Felesi sena iyawa moweni sosolo tima:na: matananase, Yesuwa potapola: iyawa akotiye tuwapokeye. ");
INSERT INTO khs_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aputa: Yesuyewi ima selese, “Sena kiyewi matanesekiwa sena kesale nokamoke potosekiwa kiwa hekeya sena esa: matane kamona Koteyawa ke himu matana fa:nemi mupapola: elaka potosekeye. Nano ketea senayewi napolo esa: matanekamowa Koteyewi potosekiwa hele heneya olokeyatela elakeye. ");
INSERT INTO khs_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Solo ele tuwapowala apula: sepatosene senayewi solo seya amowa ta:ta: minawa Yone hano toloyetisene kesila emi ine elepeyakeye. Alawamona, Yone kesila ikila emiwa Kote solo napolo Kote Piseiki epela: ela peleya: falemi tese peleya: sopoke emi ine hetetikeye. Aputa: potapola:, sena kesale sopoke iyawa Kote Piseiki epela: ela peleya: emi ha:na:pelekiwa iyawa i mene poluse musuluyetiye tuwatenekeye. ");
INSERT INTO khs_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Alanase, hepenewanapulu peleya:welapulu itapa tema:na: amowa nano sosomakeye. Alawamona, Koteyewi ele tuwatese penesolo ipi kolotea muna:pe amowa mahete hanaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yesuyewi wa:ke me selese, “Alake, sena nowamoke ene kesalewa iya:pela: kesale pa:ta nowa wa:ke me tisaleke, sena amokiwa iwei tisene mane olokeyatela amowa sosolo tiyakeye. Aputa: sena nowamoke kesale nowa e senayewi iya:pela: enene tisaleke, amowana eyawa iwei tisene mane olokeyatela timinikeye.” ");
INSERT INTO khs_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Aputa: Yesuyewi wa:ke me selese, “Puwano fa:nemi nano ketea muta tela sena nowa enekeye. Eyawa ikila sopoke sao hili napolo i okane fo ipi mutusene epapula amoke popona amo kalesene. Apula: ela: ikila sopoke eyawa ma:na: napolo na:sela: seli enekeye. ");
INSERT INTO khs_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Aputa:, sena ketea muta tela amo koane isu ine hetetisene emiwa sena misitiya ketea itapa tela amowa sena nokamoke wa:tiye ine tese emi sapeya. Sena amo unua Lasalase. Sena amoke matanesekiwa ma:na: mena hepe sena ketea muta tela e tepolo hasuwemi sululuwalu kamo ma:na: matana:sele enekeye. Apula: e tomawa sopoke oloseseyawa ilimanase kasoyawa inapola: nakola kowa tapela:sela: tesene. ");
INSERT INTO khs_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Apula: sena misitiya amo sikapewemiwa Lasalase ewa kulukeye. Kulapita: potapola: hepene senayewi ewa siliyapola: Epalahame pomini tapowemi hapakeye. Apula: elapepela:, amo fasuwemi sena ketea muta tepela: enene amowana kulukeye. Kulapita: ewa tikilakeye. ");
INSERT INTO khs_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tikila amowa ewa Hetisi peleya: kolemi hanose kapo oya sosolo tise enekeye. Emi ela: e siyewi pama falemi wala potakamake Epalahamewa Lasalase elipei ka:la:lopela: elapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Potapola: holose selese, ‘Ni ata, Epalahame, keyawa newa hauwe kima. Apula: keyawa Lasalasewa ne salo ilikepima. Apula: eyawa e tiya: pinika hano potiawemi tikipela: inapola: ne tekemi ine kesakamake potulumita: hamona e sema. Ko:yawemiye, newa tei wa:la olapo weyemi telawa ne tomawa sosolo olokeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Alawamona Epalahameyewi ema selese, ‘Ni Sa:le, keyawa nano nowa matanepa. Kewa falela apota: enene emiwa nano ketea napolo sopoke kinapotane tisekeye. Alawamona, Lasalase eyawa nano ketea olokeyatela tisekeye. Alawamona, ewa napuwa peleya: weyemiwa seli napolo elakeye. Apula: kewa oya ilima tiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Apula: nano nowana elakeye. Amowa sena niwemi tiye apula: Kotewemi tiyapola: honosane epemiwa kokolose naiya ta:peya sosolo pale tiye hapa elakeye. Alanase, sena weyemi sitalaka epemi satepela: ki salo epemi mina:na:wa eta: mina:na: telamanakeye. Aputa: sena kili epe sita:ya ni salo weyemi satepela: mina:na:wa eta: ilimanakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Aputa: ketea muta tela sena Hetisi peleya: kolemi ela amoke ta:tapola: mene selese, ‘Alalaleke, ni ata, neyawa kema heneye ta:potose selakeye. Keyawa Lasalasewa ni ata koane ilikepima:na:wa ililapa? ");
INSERT INTO khs_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ko:yawemiye, neyawa ne ma:ela:wa pipe sitalakeye. Alanase, Lasalase eyewi ha:na: tese sowa talapoiya ima sela:pa:. Ko:yawemiye iwala kapo oloma:na: tela peleya: weyemi mina:pikitise.’ ");
INSERT INTO khs_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Alawamona Epalahameyewi selese, ‘Moseseyewi solo sepapowa apula: sepatosene sena nokamoke solo sepapolo amowa elakeye. Alanase iyawa amo ta:ta:sela: sitalakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Alawamona senamoke mene selese, ‘Ni ata Epalahame amowa eta: ilimanakeye. Alake, sena nowa kupula: mene tesile ha:na: tese ima selesaleke iwa matanawa emi notolopesakeye!’ ");
INSERT INTO khs_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Alawamona Epalahameyewi mene selese, ‘Iyawa Mosese solo seyawa apula: sepatosene sena ili sepapowa eta: topumananeke, sena semetei nowa kuluwa mene tesilaleke, sena amokiwala iwa eta: seli topuma elaposakeye.’” ");
INSERT INTO khs_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesuyewi Ewamo kulu hanosene sena ima selese, “Nano ketea kalikalila amowa ine hetetiyakamake sena kesale sopoke mane olokeyatelawemi sululuwalupesakeye. Alawamona, sena olokeyatela ma:ta: tiye timiya:ne amawa hele heneya haukula e selakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amowa sena nokamoke e kemakuwemi etewa koloteasuma nowa ewemi sepela: hano tawala ka:nawemi toliyetisaleke, amowa sa:le ilikeye. Ko:yawemiye, sena amokiwa sala tepiteni semetei weyemiwa mane olokeyatelawemi sutesimita: timinima:pikitise. ");
INSERT INTO khs_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Alake, kiyawa kiwa ki mene seli pote sita: elatipa:. Apula: kine ke ma:eyewi mane olokeyatela timinisaleke, keyawa mane eyewi timinika seli hekeye timita: ema sela:pa:. Apula: ewa matana notolosaleke, keyawa e olokeyatelawa kepoliyetiya:pa:. ");
INSERT INTO khs_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Apula: eyawa mane olokeyatelawa ikiwapo semetiwemi kewalapulu tomoipe timinipela: apula: ikila tomoipe ke salo inapola: kema ‘Haukula’ e selesaleke, keyawa e olokeyatelawa tiye iya:pela: kepoliyetiya:pa:.” ");
INSERT INTO khs_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu Ewamo kulu hanosene sena kukuluipeyewi Sena Sosoma selese, “Keyawa niyewi seli topuwa sosolo temita: apoma.” ");
INSERT INTO khs_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aputa: Eye mene selese, “Kiyewi seli topuwa aso kolotea i maseta mupusu amuna elaleke, keyawa i Mapilima selese, “Kewa tukutiye ha:na: tese hano tawala Ka:na honosanewemi ha:na: kepa:.” Keyawa au selesaleke, eyawa ke seyawamuse kulu hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesuyewi wa:ke me selese, “Kiwamo sitala honosane epemiwa tima:na: tisene sena semetei nowamowa a:lekena honosanewemi peleya: motola:sela: elape epelekiwala a:pele sipi pote elape epelekiwala ewa mene koane inapitekiwa keyawa ema selesekiwa, ‘Kewa kipila ine helese ma:na:wa maiya,” e sema:na:na? ");
INSERT INTO khs_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Eta: alusemakeye. Ewamo yesila senayewi e tima:na: tisene senama selesekiwa, “Keyawa ne ma:na:wa seli tima. Apula: keyawa sawa katiyapola: ne ma:na:wa emi tiye ina:pa:. Neyawa ela:pe puwano ma:na:wanapulu hawanapulu napela: elakemi kine kewa sikape ma:na:wanapulu hawanapulu emi na:pa:. ");
INSERT INTO khs_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Alanase, ewamo yesila senayawa e tima:na: tisene senamawa ene seya amo kulu hanapitekiwa eyawa ‘sa:le napolo’ e selaposapa? Eh, eta: alusemakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Alanase, keyawala Koteyewi kima seyawamunuse nano ketea sopoke timiyananeke, amowa kiyewi selesekiwa, ‘Niwa tima:na: tisene sena olokeyatelakeye. Alanase, nano ketea sopoke niyewi timinikamowa mokopo tima:na: tiyakeye,” e sela:pa:.’” ");
INSERT INTO khs_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesuwa Yelusaleme hanosene isuwemi hapakeye. Apula: Ewa hanosekiwa Kalili peleya:wemi tiye Samelia peleya:wemi tiye epela: honosane elewemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ewa koamesa: nowemi ine hetetise potakamake sena taloipewa nakola waka:pila pala amowa E salo mina:na:pela: minawamona iwa pama komemi ine sita:lapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Aputa: iyewi unuwapo holose selese, “Yesu, Sena Sosolo, Keyawa niwa hauweki popa,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Aputa: Yesuyewi iwamo potapola: selese, “Kili toma epa pilisiti senama ha:na: walopamona.” Apula: iwa emi ma:ta: tiye hanakamake ili tomawa napolo hili telakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sena ili amo honosanewemiwa ene tomawa napolo potapola: ewa mene hapakeye. Mene inisekiwa eyawa Kote unua unuwapo wapilise minakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sena ewa Yesu enewemi ine tese e onatu onapela:newemi sipupa:wa peleya: kolemi sine pano ka:pela:la: selese, ‘sa:le napokeye’ e seya. Sena amowa Samelia senakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aputa: Yesuyewi ema selese, “Neyawa sena taloipe sopoke fala:pe esa: matanakeye. Alawamona sena akotaipewa kaiye? ");
INSERT INTO khs_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Alake, sena pa:ta nowa Kote unu wapilima:na:wa menewa mainaposapa? Semeti peleya: pama nokemi tese mina ke kama? ");
INSERT INTO khs_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Apula: Yesuyewi senama selese, “Kewa tesi tiyapola: hamona. Kine seli topuwamoke kewa mene fala:pekeye. ");
INSERT INTO khs_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Felesi senayewi Yesuma ta:potose, “Kote Piseiki epela: ela peleya: amowa asu ine hetetiyaposape? Apula: Yesuyewi ima mene selese, “Kote Piseiki epela: ela peleya: amowa ine hetetima:na:wa kiyewi siyewi seli potosene epapulusekiwa mapotaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Apula: iyewi maselaposa, ‘We elakeye. Pote mina’ epela: ‘nono epemi elakeye. Emi potapamona.’ Iyawa auwa maselaposakeye. Ko:yawemiye, Kote Piseiki epela: ela peleya: amowa kili honosane epemi elakeye,” e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aputa: Yesuyewi Ewamo kulu hanosene senama selese, “Sikape ikila nowa ine hetetiyakemiwa kiyawa Sena Sa:wa pota:sela: epesene matanepesakeye. Alawamona, ikila emiwa kiyawa Ewa mapotaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Apula: sena nokamoke kimawa weyamo selaposakeye. ‘Pota. Epemi elakeye.’ Apula: ‘Weyemi elakeye,’ e selesaleke kiyawa emiwa kulu hanapa. ");
INSERT INTO khs_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Alanase Sena Sa: Newa mene inisekiwa saiyakolose meiwanapulu ho:lilitiye tuwatesene amupesakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Alawamona, puwano Ewa kapo oyawa ilima tiyaposakeye. Apula: sena a sitala weyamokiwa Emawa fa:tapo apolaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sena Sa: Newa mene ina ikila emiwa Noa enewemi mane emi timiya amunuse timinipesakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa enene ikila emiwa sena kesaleyawa ma:na:wanapulu hawanapulu kamo na:sela: sita:la: kesale tiye apula: kesale setateya: ela: ha:na: tese Noa ewa poti sosolo suwemi ha:na: talese hano ka:nese sena kesale iwa sopoke hano nase katolose iwamo sita:newa ikumutiye iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Aputa: Lote enene ikila emiwana alakeye. Emiwa sena kesale iyawa ma:na:wanapulu hawanapulu na:sela: sita:la: ketea wa:la:ya apula: wa:la:lomita: tiye tiye apula: nakela sa:le kela: apula: koane tiye ela:sela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Alawamona, Lotewa Sotome koamesa: amowa iya:pela: hanapita: ikila semetei kemi hepene falemi tese tei wa:lawalapulu etewa upula amowa hawamuna sinise sena kesale sopoke yasokolutiye iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Alanase Sena Sa:wa hokato honosane mene inisekiwa ikila emiwa mane puwano timiya epapupesakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ikila emiwa sena nowa koane tomo falemi fiyane enenaneke, apula: e keteawa koane suwemi tenewa mene masine tiyaposakeye. Aputa: sena nowa a:lekena honosanewemi enenaneke, ewa koanewemiwa mene hanapola: e keteawa eta: tiyamananumakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Alanase, keyawa Lote ekewemi timiya amowa matanepa:. ");
INSERT INTO khs_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Alake, sena nowamoke ene kokolo kau epesene amowa ene ketale tiye elaleke, kokolo kau epesene amowa itapa tepesakeye. Alawamona, sena nowamoke ene kokolo kau epesene amowa fo:su tapo apola: elaleke, kokolo kau epesene amowa seli napolo elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Neyawa kima selakeye. Nukulapo Sena Sa:wa mene inisekiwa, sena elipei nowa elipe wa:tawemi falopela: enewa nowa Koteyewi mene silise nowa iya:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kesale elipei nowa ma:ne feselema:na:pela: ha:la:sela: sita:newa nowa Koteyewi silise nowa ke iya:pela: hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Sena elipei nowa mowa sila:newa nowa Koteyewi silise nowa ke iya:pela: hanaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aputa: ta:tapola:, Yesu Ewamo kulu hanosene sena iyewi Yesuma mene ta:tese, “Sena Sosolo, Keye epe seleseya kami epesapa:? Apula: Yesuyewi mene selese, “Sena kululu posula telaleke a:nema: usunu amuna amowa emi ine kekenesene.” ");
INSERT INTO khs_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aputa: Yesu Ewamo kulu hanosene sena iyawa sopoke Kotema kulukulusewa mapoloma:pikitise ikila sopoke kulukulula:sela: sita:pisita: Yesuyewi pale selese, ");
INSERT INTO khs_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Aputa: taune honosane nowemiwa kotola mou ta:tesene sena nowa emi enekeye. Kotola mou ta:tesene yesila eyawa Kotewa eta: ipilisemakeye. Apula: eyawa sena kesale nokala eta: seli matanesemakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Apula: kesale sopa:la nowa taune emi tesekeye. Kesale amokiwa kotola ta:tesene sena amoke ewa sesemita: ikiwapo sopoke ema ine sela:sela:, ‘Keyawa newa seselese sena newamo olokeyale seya amowa kotoma,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Apula: kesale amoke ema ta:ta: ina:ne emiwa eyawa ewa eta: sesema:na:ma matanakeye. Alawamona, sikape eyewi matanese selese, ‘Neyawa Kotewa eta: ipilamakeye. Apula: sena kesalewa eta: seli matanama elakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Alawamona, kesale sopa:la epamokiwa ne salo ine ikiwapo sopoke solo semetei seya kamo ta:ta: tekamakiwa hililawa nema tiye kinatakeye. Alanase, neyawa ewa seselese kotoma:na:keye. Ko:yawemiye, neyawa ewa maseselesaleke, ikiwapo sopoke ne salo ine tesaleke, newa e solo seya amo ta:pa:na:wa mapoloma:na:nakeye!’” ");
INSERT INTO khs_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aputa: Sena Sosoyewi wa:ke selese, “Kiyawa kotola ta:tesene sena olokeyatela amo solo seyawa ta:ta:pa:. ");
INSERT INTO khs_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Alanase, sena kesale Kote ene ta:pele tiye apoya iyawa ikila sopoke apula: yopolotela sopoke Kotema ya:peya:sela: hola: tesaleke, Koteyawa iwa masesepesapa? Apula: Eyawa imawa ‘Asepakeye’ e selaposapa? ");
INSERT INTO khs_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Neyawa kima selakeye. Eyawa iwa ela:pe kipila sesepesakeye. Alawamona Sena Sa:wa mene ina ikila emiwa, Eyawa sena kesale peleya: sosolo weyemi sitalakamokiwa seli topuwa elapita: potaposapa?” ");
INSERT INTO khs_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aputa: sena nokamoke matanesekiwa iwa noka hekeya sena esa: matanesene apula: iwa sena noka mapolose mene hasu apolosekeye. Yesuyewi sena amuna amowa pale selese, ");
INSERT INTO khs_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Apula: sena elipei a:tawa kulukuluma:na: matanese Kote koane hapakeye. Apula: nowa Felesi senakeye. Apula: nowa takese tisene senakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Aputa: Felesi sena amoke kulukuluma:na:pelekiwa ewa sa:le tesitiye ela: ene matana fa:namoke Kotema selese, ‘Kote, Neyawa Kemawa sa:le napolo e selakeye. Newa sena nokamunamakeye. Sena nokamokiwa atu tisekeye. Apula: mane olokeyatela timinisekeye. Apula: kesale senala salo hanosekeye. Apula: newa takese tisene sena weyamunamakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Apula: neyawa sokatiye semetei honosane emi ikiwapo elipeiwa ma:na:wa eta: menamake ala:pela: tesekeye. Apula: nano ketea neye tisekiwa takalese talo semetiwa Kema kinise akotaipewa nine tisekeye.’ Aluse Felesi senayewi kulukululakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Alawamona, takese tisene sena amowa ewa enapotane pama ha:na: tesitiye enekeye. Apula: eyawa hepene fala eta: wala papomakeye. Alawamona, eyawa ene pominiwemi sanose Kotema selese, ‘Newa mane olokeyatela timinisene senakeye. Alake, kokona kiwamoke newa fopuma,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Alanase, Neyawa kima selakeye. Takese tisene sena semetei ewa ene koane mene hapa amoke ela: ewa Kote sikapowemi hekeya sena telakeye. Alawamona, Felesi sena amokiwa eta: epapu telamakeye. Ko:yawemiye, sena kesale ene unua wapilise elaleke, Koteyawa ewa me sine apolaposakeye. Apula: sena kesale ene ewa me sinapola: elaleke, Koteyawa ewa unua me tila:taposakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aputa: sena kesale iyawa sala kiaiya tepiteniwala sopoke Eyewi kesamita: sikilitiye minakeye. Aputa: Yesu Ewamo kulu hanosene sena iyawa amo potapola: sena kesale ima konomo seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Alawamona, Yesuyewi sala tepiteniwa E salo mina e selapita: Ewamo kulu hanosene senama selese, “Kiyawa sala tepiteniwa Ne salo minite apola:pa:. Alanase, kiyawa iwa kapa. Ko:yawemiye Kote Piseiki epela: ela peleya: amowa sala tepiteni epapula nekeye. ");
INSERT INTO khs_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Neyawa heneye kima selakeye. Sena semetei nowamokiwa Kote Piseiki epela: ela peleya: amowa sala tepiteniyewi tisene epapulusekiwa eta: timananeke, ewa Kote Piseiki epela: ela peleya: emiwa hele heneya mamusuluyetiye hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aputa: piseiki sena semetei nowamoke Yesuma ta:potose, “Walosene Sena Napolo, neyawa kokolo kau tesene amo tima:na:pelekiwa ko:lumeinapa?” ");
INSERT INTO khs_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Aputa: Yesuyewi ema mene selese, “Keyawa Newa sa:le napolo e selesewa ko:yawemi sela:? Kote semetei Ewa napokeye. ");
INSERT INTO khs_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Apula: keyawa Koteyewi ele tuwapowa ta:tesene kakeye ‘Kiyawa kesale senayewi tiwalapuluwa iwei tiyapa apula: sena kesale tiwalapuluwa iwei tiyapa. Apula: kiyawa sena nowa kumita: sanapa. Apula: kiyawa atu tiyapa. Apula: kiyawa ta:ma: selese sena nowa mokopo kotopa. Apula: kiyawa ki ata ki ama hasu tapowemi ela: a:tewi selakamunuse kulu ha:na:pa:.’” ");
INSERT INTO khs_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yesuyewi au selapita:, piseiki senayewi selese, “Newa sala a kolotea enene emi teleke ine napu weyemiwa ele tuwapo epa neyawa sopoke kulu hanosekeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aputa: Yesuyewi ta:tapola: ema selese, “Alawamona, nano semetei nowa kewa hepe tela elatakeye. Alake, nano ketea kiwa sopoke sena nokama wa:la:yalape apola: moweni emi tiwa misitiya sena kesale ama sakopa:. Kewa alusaleke, hepene falemiwa nano ketea sa:le napowa keyewi tiyaposakeye. Apula: kewa Newamo kulu ina:pa:.” ");
INSERT INTO khs_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Alawamona, eyawa Yesu solo seya amo ta:tapolekiwa, eyawa sosolo hili matanese eta: epeyamakeye. Ko:yawemiye, e ketea muta telanase. ");
INSERT INTO khs_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Aputa: Yesuyewi potakamake piseiki sena amo potapola: selese, “Sena kesale nano ketea muta tela amowa Kote piseiki epela: ela peleya: emi ha:na:wa hokolalape musuluyetiye hanaposakeye! ");
INSERT INTO khs_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Alanase, kopolo ka:mowa sao tupulusene ono uwalokemiwa ili musulupesakeye. Alawamona, sena ketea muta tela ewa Kote Piseiki epela: ela peleya: emi ha:na:na:wa hokolalape musuluyetiye hanaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aputa: sena kesale iyawa solo seya amo ta:tapola: ta:potose, “Auma:na: telalapitekewa, kokolo kau epesenewa eta:wi tiyaposape?” ");
INSERT INTO khs_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aputa: Eyewi mene selese, nano ketea senayewi eta: timinima:na: telamawa, Koteyawa ili timinisekeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aputa: Pitayewi selese, “Niyawa nano ketea sopoke iya:pela: Kewamo kulu minakeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Aputa: Yesuyewi ima selese, “Neyawa heneye kima selakeye. Sena kesale eta:wiye Kote piseiki epela: ela peleya: amo tima:na: matanesaleke iyawa ili koawana apula: ili kesalewala apula: ili ma:ewana apula: ili inawana apula: ili e amawala apula: ili salawala sopoke iya:pela: inisaleke, iwa peleya: sosolo weyemi a sitalakemiwa Koteyawa nano ketea amuna ilima ima kinaposakeye. Apula: sikape seta: minama fa:nemi Koteyawa kokolo kau epesenewa tiye kinaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Aputa: Yesuyewi Ewamo kulu hanosene sena kukuluipewa siliyapola: ha:na: tese selese, “Ta:ta, napuwa niwa Yelusaleme koamesa:wemi hanakeye. Puwano sepatosene senayewi momatelese selese nano ketea Sena Sa:wemi timinima:na:keye. E sepapowa heneye napu hetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Apula: iyawa Ewa Yu senama tela ama tiye kinaposakeye. Apula: iyawa Ewa akowata: apula: itipilipesakeye. Apula: Ewemiwa kepese ela: epesakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Apula: iyawa Ewa mei naiya akotaipe emi nano mina sewaya amoke pananepesakeye. Apula: Ewa kumita: sanaposakeye. Alawamona, ikila usulupe elapepela: Ewa mene tesile fiyanaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Alawamona, Yesu kulu hanosene sena iyawa Yesuyewi solo seya amo mouwa eta: seli matanamakeye. Solo amo mouwa Koteyawa imawa mupapokeye. Alanase, iyawa Yesu solo seyawa eta: seli matanamakeye. ");
INSERT INTO khs_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesuwa Yeliko taune pawemi inise potakamake sena semetei sikola nowa isu hemawemi hela: moweni tima:na:pela: haya:sela: elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Aputa: ewa hela: ta:takamake sena kesale ilima ine tipita: eyawa sena ima ta:tese, “Epa ko:lupa:?,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aputa: iyewi ema selese, “Na:selete sena Yesu hanose ekeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aputa: eyewi ho selese, “Yesu, Tepiti E Sa:le, Keyawa newa hauwekilise sesema!” ");
INSERT INTO khs_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Au selapita: ta:tapola:, sena putupela: ha:na: tiya:ne iyawa sena sikola ama konomo selese, “Keyawa sowa selapa,” e seya. Alawamona, eyawa kokolo ka hola:sela: selese, “Tepiti E Sa:le, Keyawa newa hauwekilise sesema!”, e seya. ");
INSERT INTO khs_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Aputa: Yesuwa ine tese selese, “Sena epa weyemi siliye mina,” e seya. Aputa: sena amowa Yesu pawemi inapita: Yesuyewi ema ta:potose, ");
INSERT INTO khs_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kewa Neyawa ko:lumita: matanepa:?” Aputa: eyewi mene selese, “Sena Sosolo, Neyawa wa:ke me popa:na: matanekeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aputa: Yesuyewi ema selese, “Alalapita:, ke siwa fake popa. Kine seli topuwamoke ekeye.” ");
INSERT INTO khs_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kipila kemi eyawa wa:ke me papokeye. Apula: eyawa Yesu kulu hanose Kote unua wapiyakeye. Apula: sena kesale iyawa amo potapola: iyawala Kote unua wapiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Aputa: Yesuwa Yeliko taune emi ine hetetiyapola: Ewa emi musuluyetiye ha:na:sela: enekeye. ");
INSERT INTO khs_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Apula: taune emiwa sena nowa enekeye. E unua Sakiase. Sakiase ewa takese tisene sena amo yesila senakeye. Apula: ewa moweniwa ilimakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eyawa Yesuwa sena ikamuna inape esa: popa:na:pela: elawamona sena kesale ilimawanapulu minanase Yesuwa eyawa misiwa eta: popa:na:ma telakeye. Ko:yawemiye Sakiase ewa sena kasa pounase. ");
INSERT INTO khs_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aputa: ewa puwano kipila neiye ha:na: tese ewa i ko:lu tuwemi Yesu popa:na:pela: fiyanekeye. Ko:yawemiye, eyawa Yesuwa isu nono emi inapita: potapola:. ");
INSERT INTO khs_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Alanase, Yesuwa i mou emi ine tese wala potakamake Sakiase emi helapita: potapola: ema selese, “Sakiase, kewa kipila mene sipa:lema. Ko:yawemiye, napuwa Newa ke koane ha:na: epesenekeye.” ");
INSERT INTO khs_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yesuyewi au selapita:, Sakiasewa kipila sine sipa:lepela: ewa epeya ilima tese Yesuwa e koane siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aputa: sena kesale sopoke amo potapola: iyawa konomonose o:sulu selese, “Ewa sena olokeyatela tisene koane siliye hanatakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aputa: Sakiase ewa tesitiye ela: Yesuma selese, “Sena Sosolo, ta:pa. Nano ketea niwa sopoke honosane takalepela: sena misitiya sitala ama sakoma:na:keye. Apula: neyewi sena nowamo ketea atu tilaleke, neyawa sena amawa wa:la:ya heka nano pinipe mene miya:na:keye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Au selapita: Yesuyewi ema selese, “Napu ikila weyemiwa, Koteyawa koane weyamo suwemi sita:newa mene siliyakeye. Ko:yawemiye, sena amowana Epalahame e sa:keye. ");
INSERT INTO khs_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sena Sa: minawa sena kesale sopoke kelekeyeti wamuna sitalapita: potapola: keye hanapola: mene silima:na: minakeye.” ");
INSERT INTO khs_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sena kesaleyawa Yesuyewi solo seya amowa ta:ta:sela: sitalapita: Yesuyawa solo nowa wa:ke ima pale seyakeye. Ko:yawemiye, Ewa Yelusaleme pawemi ine hetetima:na: mapatopita:. Aputa: iyewi matanesekiwa Kote piseiki epela: ela peleya: amowa hokato honosane ine kipila hetetiyaposakeye esa: matana. ");
INSERT INTO khs_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aputa: Eyawa au seya, “Sena sosolo nowa peleya: pama nowemi ewa Kini ta:peletiye apomita: ha:na:na: matana. Apula: ewa sikapewa ene peleya: mene inaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ewa ha:na:na:elekiwa, e tima:na: tisene sena taloipewa ho tiyapola: moweniwa kopolo pisei momateya (K20) semetei semetei esa: sakolakeye. Apula: eyewi ima selese, ‘Kiyawa moweni we tiyapola: pisinisi timinipa:. Timiye ha:na: tese newa mene inakemi elepela:pa:.’ ");
INSERT INTO khs_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Alawamona, e koane a:talu sena nokamokiwa sena sosolo amawa mapoyakeye. Apulapita: sena sosolo ewa hapa elapita: tima:na: tisene sena taloipeyawa ewa selapamonota: sena noka peleya: ewamo hapa emi ilikepilise selese, ‘Niyawa sena ewa kini temitekiwa eta: matanamakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Alawamona, ewa kini tepela: mene minakeye. Ewa mene inapola: ela: selese, ‘Sena tima:na: tisene taloipe neyewi moweni miwa minite homa’ e seya. Neyawa iyewi pisinisi timiya:ne emi moweni hetetiwa sosolo telapele esa: popa:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aputa: tima:na: tisene sena nowamoke ine selese, ‘Sena Sosolo, keyewi nema moweni kopolo pisei momateya (K20) kinanakamoke neyewi pisinisi timiyawemiwa sakopo elipei (K200) hetetikeye.’ ");
INSERT INTO khs_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Aputa: kini sena amoke ema mene selese, ‘Keyawa tima:na: napolo tiyakeye. Alake, kewa tima:na: tisene sena napokeye. Kewa nano koloteasuwa seli pote enenase, keyawa napuwa taune taloipewa keyewi pote elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aputa: tima:na: tisene sena nowamoke ine selese, ‘Sena sosolo, keyewi nema moweni kopolo pisei momateya (K20) kinanakamoke neyewi pisinisi timiyawemiwa sakopo semetei (K100) hetetikeye.’ ");
INSERT INTO khs_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aputa: kini sena amoke ema mene selese, ‘Alalapita: keyawa taune pipe pote elaposakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Aputa: tima:na: tisene sena nowamoke ine selese, ‘Sena sosolo, keyewi nema moweni kopolo pisei momateya (K20) kinanaka neyewi saoyewi sakotiye seli tuwapola: enene amowa wekeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Apula: sena amoke kini ama selese, ‘Kewa sena komonase, newa ipikeye. Ko:yawemiye nano ketea sena nokamoke tiye tiwa keyewi tisekeye. Apula: nakela sa:le sena nowamo kelawa keyewi tisekeye.’ ");
INSERT INTO khs_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Au selapita: kiniyewi ema mene selese, ‘Alanase, tima:na: tisene sena kewa olokeyatela senakeye. Kine solo epamoke ela: kewa neyewi kotoma:na:keye. Alanase, keyawa newa sena komono elakeye. Elawa matana kakeye. Apula: neyawa nano ketea sena nowamoke tiye tiwa tisene. Apula: nakela sa:le sena nowamo kelawa neyewi tisekeye. Alanase, keyawa nano ketea sopoke epapulusene epamowa eta: matanamana? ");
INSERT INTO khs_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Alawamona, keyawa ne moweniwa panekewemi tuwapokiwa nine newa mene inise moweni wa:ke me papela: timapetapa?’ ");
INSERT INTO khs_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Aputa: eyewi sena kesale noka pakemi sita:nema selese, ‘Kiyawa sena epamawa niyewi moweni kopolo pisei momateya (K20) miwa tiyapola: sena tima:na: tisene moweni sakopolo elipei (K200) heteti ama kina:pa:.’ ");
INSERT INTO khs_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aputa: iyewi selese, ‘Sena sosolo, eyawa moweniwa sakopolo elipei (K200) ili telakeye.’ ");
INSERT INTO khs_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Aputa: eyewi mene selese, ‘Neyawa kima selakeye, sena kesale eta:wiye nano ketea noka teselaleke, sena amawa nano ketea nokala me miya:na:keye. Alawamona sena kesale nokamokiwa nano ketea aso kolotea tiya:nenaneke, e ketea amowa neyewi asutiye iya:pa:na:keye. ");
INSERT INTO khs_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Apula: sena newanapulu kisi tese selese newa kini tepa e sela:ne sena iwa sopoke sikilitiye inapola: ne sikapo weyemi kumita: yasokolupa:.’” ");
INSERT INTO khs_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesuyewi sowa pale selalape kopela: ewa puwano putupela: Yelusalemewemi fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Apula: hanosekiwa Yesuwa koamesa: elipei Petafase apula: Petani amo pawemi mapatolose tokomo Olofiwemi ha:na: sita:la: Yesuyawa Ewamo kulu hanosene sena elipei ilikepilise selese, ");
INSERT INTO khs_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","‘Ka:ko: koamesa: epemi hanose potakamakiwa kopolo toki a penamu iyewi koma:pela: elakeye. Kopolo toki emiwa puwanowa sena nowamokiwa e fa:se emiwa seta: helesemakeye. Alanase, kakiwa faketiye siliye ina:pa:. ");
INSERT INTO khs_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Alawamona, sena nowamoke ka:ma ta:potose, ‘Ka:tawa ko:luma:na: fakela:?’ e selesaleke, ka:tewi selesekiwa ‘Sena Sosoyawa tima:na: elakeye’ e sela:pa: e seya. ");
INSERT INTO khs_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Au selapita:, a:ko: ka hapa. Ha:na: tese potakamakiwa Yesuyewi solo seya amuna amowa sopoke ala elapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Aputa: a:tawa kopolo toki kakiwa fakela:newanapulu kopolo toki inayewi a:ma selese, “Ka:tawa kopolo toki kakili weyamowa ko:luma:na:pela: fakela:sela:?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aputa: a:tewi selese, “Sena Sosoyawa tima:na: nowa elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aputa: a:tawa kopolo tokiwa Yesu salo siliye hapa. Siliye hanapola: a:tawa eli sao kalesewa ko:lutiye kopolo toki fa:kemi fepela: Yesuwa kopolo toki amo fa:kemi Ewa emi sapeyakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Aputa: Ewa kopolo toki wapa:kemi helepela: hanapitekiwa sena kesale sopoke iyawa sao kalesewa Yesu ha:na:na:wemi fela hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hanapola: Olofi tokowa sakote tiyapola: sine sipa:lewemi sipa:kilipita: sena kesale muta Ewamo kulu hapayawa epeyawa ilima telakeye. Ko:yawemiye, iyawa mono tema:na: tela ketea amowa paponase amo matanese iyawa unuwapo Kote unua wapilise hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aputa: iyawa holose selese, “Kote unuwemi kini sena epe iniseyamowa sa:le napokeye apula: hopola tesewa hepene falemi elakeye. Alanase, Kote unua a falemi tili tise wapilima!” ");
INSERT INTO khs_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aputa: potapola: Felesi sena noka sena kesale ili honosane sita:ne amoke Yesuma selese, “Walosene Sena, Keyawa Kewamo kulu hanosene sena kesale iwa konomonose halaloma,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aputa: Yesuyewi mene selese, “Neyawa kima selakeye. Sena kesale weyamokiwa solama tesaleke, etewayewi sowa holose selaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesuwa Yelusaleme siti amowa ine mapatolose Eyawa siti amowa pota:la: ya:lese selese, ");
INSERT INTO khs_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Yelusaleme, napu ikila yemi Neye matanawa keyawa hopola napolo tesene ketea amowa matanepe. Alawamona napu weyemiwa nano ketea weyamowa ke sikapowemiwa o:sulu mupataposakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Alake, ikila sikape nowemi kisi sena ine hetetisekiwa siti kiliwa peleya: tuwaye fiyanaposakeye. Apula: kisi senayewi ine hema sopoke sotiye hekeyetiye elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Apula: kisi senayawa kine kewala ke salawala sukulu tiyapola: peleya: kolemi talusupela: kumita: yasokolutiye iya:taposakeye. Apula: etewa koane tise kalote fiyanewa semetei nowa etewa nowamo wa:pa:kemiwa matelaposakeye. Amowa kisi senayewi sopoke eketiye iya:taposakeye. Ko:yawemiye, Kotewa ki salo inapola: kiwamo sesema:na:wa eta: seli matanama elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aputa: Yesuwa Kote koawemi musuluyetiye tuwatene potakamake sena kesale iyawa Kote koane suwemi nano ketea wa:la:ya:sela: sita:lapita: Yesuyewi iwa sopoke ma:ta: tiye alu taletiye iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aputa: Eyewi ima selese, “Kote Pukawemiwa sowa weyamo sepapokeye, ‘Ne koawa Kotema kulukulusene koane elakeye.’ Alawamona, kiyawa atu tisene sena sita:tesene amunuselakeye.” ");
INSERT INTO khs_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ikila sopoke Eyawa Kote sowa Kote koawemi sena kesalema waya:sela: tesekeye. Alawamona pilisiti sena sosoyawala apula: ele walosene senayawana apula: sena kesale piseiki sena iyawa sopoke Yesuwa sama:na:pela: isuwa keyakeye. ");
INSERT INTO khs_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Alawamona, sena kesaleyawa Yesu sowa penanose kulu hanose topukeye. Alanase, piseiki sena iyawa Yesu sama:na:wa isuwa eta: papomakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ikila nowemi Yesuyawa Kote koane sulu honosane solose hekela amo hemawemi sena kesalema Kote solo napowa waya:sela: enene. Apula: pilisiti sena sosoyawala apula: ele walosene senayawala apula: sena kesale piseiki sena iwa sopoke Yesu salo inapola: Ema selese, ");
INSERT INTO khs_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Keyawa nima sema. Kema penaiya opola mini amowa kami tese tiyapola: nano ketea sopoke epa ke timiyana? Apula: penaiya opola amowa kemawa eta: tiye mina?” ");
INSERT INTO khs_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aputa: Eyewi mene selese, “Alalapita:, Neyawana kima solo nowa mene ta:potakeye. Kiyewi mene semita:, ");
INSERT INTO khs_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Alake, Yoneyewi sena kesale hano tolusule mina mane amowa hepene falemi tese minana? Apula: mane amowa senayewi matanawamunuse tima:na: tila?” ");
INSERT INTO khs_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Au selapita: ta:tapola:, iyawa ikene kekelese selese, “Alake niyawa ‘hepene falemi tese minakeye’ e selesaleke, Yesuyawa emiwa ‘eta: seli topumawa ko:luse elala?,’ e selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Apula: niyawa ‘Yoneyewi sena kesale hano tolusule mina mane amowa senayewi matanawamunuse tima:na: tikeye’ e selesaleke, sena kesale sopoyawa niwa etewayewi tapapuluse yasoko:lupesakeye. Ko:yawemiye, iyawa Yonewa heneye sepatosene sena esa: seli matananase.” ");
INSERT INTO khs_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aputa: iyewi Yesuma selese, “Niwana eta: matanamakeye. Yone eyawa matanawa kami tese tiyapola: hano tolusulale,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aputa: Yesuyewi ima selese, “Alanase, Neyawana kimawa Nema penaiya opola kinapola: amoke tima:na: tiwa kimawa eta: sema:na:makeye. ");
INSERT INTO khs_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesuyewi sena kesalema pale weyamowa selese, “Sena nowamoke a:lekenawemi waine sa:wa emi kelakeye. Apula: eyawa sena nokamoke a:lekena pota:tesene iyawa pote ela: pisinisi tima:na: tiya:sela: epesita: apoya. Apula: ene ewa peleya: pama nowemi ha:na: tese ewa ikila muta tema:na: hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Aputa: waine amowa fowa helesene kiwemi eyawa tima:na: tisene sena semetei nowa a:lekena yesila sena amo salo hanapola: waine fo amowa noka ema mita: ilikepiya. Alawamona, a:lekena yesila sena amoke tima:na: tisene sena amowa sananape apola: ewa henese mene hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aputa: a:lekena ina eyawa tima:na: tisene sena nowa ilikepiya. Alawamona, a:lekena yesila sena ili amoke ewa sananape apola:. Apula: ewa itipili selalape apola: ewa henese mene hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aputa: a:lekena ina eyawa tima:na: tisene sena nowa ilikepiya. Alawamona, a:lekena yesila sena iyewi ewa fale sananape apola: ewa hema tapo sukulutiye toliyetikeye. ");
INSERT INTO khs_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aputa: a:lekena inayewi selese, ‘Neyawa ko:lu timinima:na:ne? Neyawa ni sa:le semetei nine himu hapawa ilikepima:na:keye. Alusaleke, iyawa ni sa:wa seli siliyaposakeye,’ esa: matana. ");
INSERT INTO khs_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Alawamona a:lekena yesila sena iyawa sala amowa inapita: potapola: iyewi ipitane kekelese selese, ‘Sena epamokiwa inayewi topunu ketea tima:na:wa epakeye. Alanase, niyawa ewa kumita: sanapose ekeye. Alake, ewa kulusaleke, ina topuwa sopoke niyewi tima:na:keye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Alanase, iyewi ewa waine a:lekena hemawemi sukulutiye ha:na: tese sanakamake kulukeye. Alalaleke, a:lekena inayawa tima:na: tisene sena imawa ko:lu timinipesapa:?”, esa: Yesuyewi ima mene ta:papokeye. ");
INSERT INTO khs_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Aputa: Yesu ene mene selese, “Alusaleke, a:lekena ina ene ewa inapola: a:lekena yesila sena iwa sopoke yasoko:lutiye iya:pela: waine a:lekena amowa sena nokama tiye kinaposakeye.” Au selapita: ta:tapola: iye selese, “Niyawa epapu timinimitekiwa eta: matanamakeye!” ");
INSERT INTO khs_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aputa: Yesuyewi iwa pota:la: ta:potose, “Alawamona Kote pukawemi momateya weyamo mowa ko:luma:na:pela: elala? ‘Etewa amowa koane tisene senayewi pote iya:peya amowa napuwa sa:le koane tise sole fiyanese kukunane etewa talapa:pa:na: tela hetetikeye.’ ");
INSERT INTO khs_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Alanase, sena kesale sopoke etewa amowa wa:pa: emi ine sutesinisaleke, ewa sanowatese munuko:lutiye iya:taposakeye. Apula: etewa amowa sena wa:pa:kemi sutesinisaleke, sena amowa sopoke ikomunuye tiyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Aputa: ele walosene senayawana apula: pilisiti sena sosoyawala iyawa sopoke solo amowa iwa pale selatakeye esa: matana. Aluse, iyawa opo si semetei kemi Yesuwa kipila saliyapola: sukulutiye ha:na:na: matanakeye. Alawamona, sena kesale noka sitalapita: iwa ipilise eta: alamakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aputa: pilisiti sena sosoyawala apula: ele walosene senayawana iyawa sopoke Yesuwa kulu pepeya:sela: enekeye. Apula: iyawa sena noka ai pamita: ilikepiya. Apula: ai pama:na: mina sena iwa hekeya sena mene tepela: enekeye. Ko:yawemiye, Yesuyawa solo nowa iyewi ta:takamakiwa hekeya maselesaleke, iyawa Yesuwa tiya: saliyapola: sukulutiye kamani piseiki sena penaiya opola ama kotomita: tiye miya:na: esa: matanepela: yesipela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aputa: ai pama:na: mina sena iyewi Yesuma ta:potose, “Walosene Sena, niyawa matanakeye Keyawa sena kesalemawa sowa hekeya setiye kinisekeye. Apula: Keyawa sena kesale ununawana apula: ununamawana sowa seya semetei kamunuse selesene. Keyawa Koteyewi mane alusewa heneye solo selatakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Alanase, Niyawa Sisamawa takesewa tuwapa:na:wa ililapa?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Alawamona Yesuyawa ai pama:na: mina senayewi Ewamo tikitise e tapo esa: matane tiyapola: ima selese, ");
INSERT INTO khs_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kiyawa moweni usu nowa Nema waloma. Ipi pikisa momateya elatapa? Apula: moweni usu emiwa ena momateyalapa?” ");
INSERT INTO khs_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aputa: iyewi mene selese, “Sisa pikisa apula: Sisa unu telatakeye,” e seya. Au selapita: Yesuyewi ima selese, “Alalapita:ke, Sisa nenaneke Sisa ene ema kina:pa:. Apula: Kote nenaneke Kote Ene Ema kina:pa:.” ");
INSERT INTO khs_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Alanase, iyawa Yesuwa E solo seyawa sena kesale sikapowemiwa matikitipesakeye. Au selapita:, iwa Yesu solo seya amo ta:tapola: tuteilise iwa meaka kata tiye sita:la: sowa eta: seyama. ");
INSERT INTO khs_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aputa: Satusi sena noka Yesu salo minakeye. Apula: Satusi sena iye matanesekiwa sena kulusaleke, ewa menewa eta: tesilisemakeye, e seya. Sena ili amoke Yesuma ta:potose, ");
INSERT INTO khs_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Walosene Sena, Moseseyewi ele tuwatese nima momatetiye tuwatesekiwa weyamo seyakeye. Sena nowamoke kesalewa tiyapola: salawa eta: kesilama kulusaleke, e ma:e nowamoke kesale sopa:la amowa tiyapola: kesale amoke salawa e ma:e kulu ewamopela: kesilakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Apula: sena maya sola nowemiwa e ma:ela:wa tomoipe sita:nekeye. Emiwa e ma:e ola:tewi kesalewa tiyapola: salawa eta: kesilama kulukeye. ");
INSERT INTO khs_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aputa: amo fo:suyewi kesale sopa:la amowa eyewi me tikeye. Ala sala eta: kesilama kulukeye. ");
INSERT INTO khs_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Amo honosaneyewi kesale sopa:la me tiyapola: salawa eta: kesilama ewala kulukeye. Ka epapuluse sena tomoipewa sopoke kesale amowa tiyapola: salawa eta: kesilama ya:te telakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Amo fo:suwemi kesale sopa:la amowana kulukeye. ");
INSERT INTO khs_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Alanase, sena kuluwa mene tesila kemiwa kesale sopa:la amowa a:me nene tepesape? Ko:yawemiye ewa puwanowa sena tomoipeyewi tikeye. ");
INSERT INTO khs_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aputa: Yesuyewi ima selese, “Sena kesale napu weyemiwa kesale setateye apula: kesale tiye ela:sela: sita:keye. ");
INSERT INTO khs_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Alawamona, sena kesale Koteyewi selese ‘Kiwa ili mene tesilaposakeye,’ e selesaleke, sena kesale amokiwa kesalewa matiye apula: kesalewa masetatiye epesakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ko:yawemiye, iwa wa:kewa makulaposakeye. Iwa hepene senawamupela: sita: elaposakeye. Koteyawa iwa tikilawemi mene tesa:penase iwa Kote E sala elakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Alawamona, Mosese eyawa nimawa waloselesekiwa sena kuluwa mene tesikeye. Apula: i tepiteni olapowemi tei wa:lakeye esa: pula wala amowa Mosese eyewi selese, ‘Sosowa Epalaheme Kote elakeye. Apula: Aisake Kote elakeye. Apula: Yakope Kote elakeye,’ e seya. ");
INSERT INTO khs_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Amoke ela: nima waloselesekiwa, Kotewa sena kulu amo nene elapakeye. Eta: alamakeye. Ewa sena apota: sitala weyamo Kotekeye. E sikapowemiwa sena kesalewa sopoke falela apota: sitalakeye.” ");
INSERT INTO khs_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aputa: ele matana walosene sena nokamoke mene selese, “Walosene Sena, Keyawa ili selakeye!” ");
INSERT INTO khs_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Apula: senala:yawa Yesuwa nano nowa ta:popa:na:wa ipilakeye. ");
INSERT INTO khs_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Aputa: Yesuyewi ima selese, “Kelesowa Tepiti e sa:keye e selesewamowa iyawa ko:luse seyala? ");
INSERT INTO khs_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tepiti ene kisala pukawemiwa momateyawa wekeye, ‘Sosolo, Koteyewi ne Sosoma selese, “Kewa Ne tiya: ili tapo helema. ");
INSERT INTO khs_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Aputa: ha:na: tese Neyawa ke kisi senawa ke hasuwemi apoma:na:keye.” ’ ");
INSERT INTO khs_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tepiti eyewi ela: selese sena amowa Ne Sosokeye, e seya. Alanase, sena amowa Tepiti e sa:keye e seya amowa ko:lu matanese seyala?” ");
INSERT INTO khs_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aputa: sena kesale sopoke Yesu solo seya amo ta:ta:ne emiwa Yesuyewi Ewamo kulu hanosene senama selese, ");
INSERT INTO khs_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kiwa ele matana walosene senawa selikeye. Sena ili amokiwa saowa senatolo kapela: sila:pesene matanesekeye. Iye matanesekiwa kekena peleya: nano ketea wa:la:ya honosanewemi sena kesaleyawa imawa tiya: hapola:sela: epesape esa: matanesekeye. Apula: iyawa Yu sena kulukulu koane suwemi iwa puwano sena sikapowemi helema:na: matanasene apula: iyawa kekenese ma:na: mena okemiwa iwa sena ununa ka:la:losene emi ka:la:loma:na: matanesekeye. ");
INSERT INTO khs_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Apula: iyawa kesale sopa:wayawa tikitisene apula: ili koawa iyewi atu tisekeye. Apula: iyawa Kotema ta:ma: kulukulusekiwa senato selesekeye. Alanase, kotoma:na: ikilawemiwa iwa falasima:na:wa sosokeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesuyewi siyewi wala potakamake sena ketea muta tesene nokamokiwa Kotema mokopo miya:na:pela: Kote koane moweni selawatesene pokose suwemi selawalopita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Apula: Eye potakamake kesale sopa:la misitiyayewi moweni usu kuluwa elipei ine selawatapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Potapola:, Yesuyewi selese, “Neyawa heneye kima selakeye. Misitiya kesale sopa:la weyamokiwa moweniwa sosolo selawatakeye. Alawamona sena kesale ketea muta tesene iyewi selawa aso koloteakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sena kesale ketea muta tela iyawa moweniwa aso heka pokose suwemi selakeye. Alawamona, misitiya kesale sopa:la amokiwa ewa nano ketea itapanase eyewi ma:na: wa:la:loma:na: tela kamowa pokose suwemi selawapokeye. ");
INSERT INTO khs_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aputa: Yesu Ewamo kulu hanosene sena nokamoke Kote koawa potapola: selese, “Iyawa etewa sololo napolo tiyapola: seli tise sena kesale nokamoke Kotema mokopo mi ketea napolo sopolo amowa koane suwemi momatetiye seli napolo elapita: papokeye,” e seya. Alwamona Yesuyewi selese, ");
INSERT INTO khs_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kiyewi napu nano napolo epe potose amo selakeye. Ikila nowa ine hetetiya kemiwa etewa koane tise kalote fiyane epa eketiye iya:takemiwa etewa semetei nowa etewa nowamo wa:pa:kemiwa matelaposakeye. Etewa sopoke sululuwalupesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Au selapita: iyewi Ema ta:potose, “Walosene Sena, nano ketea sopoke epe seleseyamowa asu hetetiyaposapa:? Apula:, nano ketea sopoke epe seleseyamowa, puwano ela: niyewi matanepela: epesitekiwa nano ena walopesapa:?” ");
INSERT INTO khs_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aputa: Eyewi selese, “Kiwa selikeye! Sena semetei nowamoke kimawa patiye sema:pikitise pota:pa:, ko:yawemiye, sikapewemiwa sena mutayewi Ne unuwemi inapola: selesekiwa, ‘Newa sena anase itapa tema:na: oka mapatokeye,’ e selaposakeye. Au selesaleke, kiyawa ewemiwa kulu hanapa. ");
INSERT INTO khs_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Apula:, kiyawa peleya: hepe nokemi kisi tetakeye e selapitekiwala apula: kamani senawanapulu mapolose kisi tetakeye e selapitekiwala kiyawa amo ta:tapolekiwa ipipa. Ko:yawemiye, nano ketea epamowa puwano ela:pe hetetiyaposakeye. Alawamona, itapa tema:na: e seya oka kipila sema hetetiyaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aputa: Eyewi wa:ke selese, “Sena peleya: nokemi sita:neyewi peleya: nowanapulu kisi tetaposakeye. Apula: kamani nowamoke kamani nowanapulu kisi tetaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Apula: henewa sosolo inaposakeye. Apula: peleya: hepe nokemiwa meina sosolo hetetise senawa nakola sosolo tiyaposakeye. Apula: kiwa ipima:na:tela ketea noka kalikalise hetetiyaposakeye. Apula: mei falemiwa nano ipima:na:tela ketea sosolo ine hetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Alawamona, puwanowemiwa nano ketea kalikalila epa a hetetima:na: elapita:, kiwa iyewi saliyapola: sukulutiye ha:na: tese mete ikomonose sanaposakeye. Apula: iyawa kiwa kulukulu koane suwemi kotolalape apola: tipolo selawataposakeye. Apula: kiwa kamani sena apula: kini sena salowemi sukulutiye hanaposakeye. Ko:yawemiye, kiwa Ne unu tiye sita:nenase. ");
INSERT INTO khs_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Alusaleke, kiyawa Kote solo napolo waloma:na: isu falose epesakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Alanase, kine himu fa:namoke matane tiya:pa:. Apula: kiyewi ima mene sema:na:wa seli tiyapola: hanapa. ");
INSERT INTO khs_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ko:yawemiye, Nine Neyewi kima hekeya semita: sowa matana napowa kima tiye miya:na:keye. Alanase, sena kiwamo kotoma:na: sena iyawa kili sowa masanotiye toliyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Aputa: ki ata ki ama ke ma:e apula: maya pepeta semetiyawala apula: ke mana iyawala kiwa sopoke kisi sena tiya: wa:pa:kemi tiye kinaposakeye. Apula: iyawa kiwa noka kumita: sanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aputa: sena kesale sopoke kiwalapulu mapolopesakeye. Ko:yawemiye Ne unua kiwemi enenase. ");
INSERT INTO khs_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Alawamona, kili pisei fano semetei nowa mahopano hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Alanase, kiwa penana:pela: tesi tiye sitalatipa:. Alusaleke, kokolo kau epesenawa kiyewi tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Alanase, kiyewi potakamake Yelusaleme sitiwa ikomoma:na:pela: ami ta:le tiyewi sotiye hekeyetiye sitalapita: potosaleke, Yelusaleme siti ikomoma:na:wa mapatotakeye esa: matanepa:. ");
INSERT INTO khs_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ikila emiwa sena kesale Yutia peleya: sita:newa tokowemi ha:na:pa:. Apula: sena kesale Yelusaleme siti sulu honosane sita:newa sitiwa iya:pela: peleya: nokemi ha:na: tipa:. Apula: sena kesale noka Yelusaleme siti hema tapo sita:neyawa Yelusaleme siti suwemiwa hanapa. ");
INSERT INTO khs_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ikila amowa Kote pukawemi momate tiye tuwatese Koteyewi falasima:na: e seya amo hetetise epesakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Alake, kesale alela elakala apula: kesale sala yo po kinanakala haukula e selakeye. Ko:yawemiye, ikila emiwa hilila koloteasuma peleya: emi hetetiyaposakeye. Apula: Koteyewi konomonawa sena kesale ima toliyetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aputa: kisi senayewi iwa sapa elipei mina senatolo amoke olokeletiye iya:taposakeye. Apula: sena kesale noka sikilitiye ha:na: tese peleya: nokemi tipolo selawataposakeye. Aputa: Yu senamayewi Yelusaleme sitiwa amoke ine fe onanaposakeye. Ale ha:na: tese Koteyewi Ene ta:peyawamunuse hetetiyapita: iyawa Yelusaleme sitiwa iya:pela: ha:na: tipesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesuyewi selese, “Ikila emiwa mei falemi oposiwala apula: kuneiwana apula: yepisiniwanapulu sopoke emiwa nano kalila walopita: potaposakeye. Aputa: sena kesale peleya: sosolo weyemi sitalakamokiwa hano tawala feya ta:tese ipilise ko:luma:na:ne esa: kete matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sena noka amo potose tutelise pipilise peleya: kolemi sululuwalupesakeye. Ko:yawemiye iyawa mei falemi ketea emi elaka sopoke ila:litepita: potapola:, apula: nano kalila noka wa:ke peleya: weyemiwa ko:ya hetetiyapesape esa: matanese epesakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ikila emiwa sena kesaleyewi potakamakiwa Sena Sa:wa akopa: suwemi helepela: inise penaiyawalapulu ho:liyawalapulu inapita: potaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Alanase nano sopoke epa ma:ta: tiye hetetiyapitekiwa, kiwa tesi tiyapola: piseiwa hekeya falemi wala pota:pa:. Ko:yawemiye, Koteyewi kiwa mene silima:na: ikilawa mapatolose epesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Aputa: Yesuyewi ima pale selese, “Kiyawa i ko:luwala apula: i nokala potosekeye. I mowa heli selesaleke amo potapola: matanesekiwa hepoloma:na: mapatotakeye,” e selesene. ");
INSERT INTO khs_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Alusene amunuse, kiyewi nano ketea sopoke amowa hetetisaleke, kiye matanesekiwa Kote piseiki epela: ela peleya: amowa mina:na: mapatotapo, e sela:pa:. ");
INSERT INTO khs_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Alanase, Neyawa heneye kima selakeye. Sena kesale napu weyemi a sitalaka seta: kuluma a elapita: nano ketea epa selakamo emi hetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aputa: hepene falala peleya: weyala sopoke itapa tepesakeye. Alawamona Ne Sowa maitapa tepesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Alake, kiwa sopoke selikeye. Kiyawa hano olokeyatela napela: nanano tepela: ela: kine kewamo teleke ha:na:na: tapowemiwa himuyawa sosolo hili matanepela: epesa:pekise selikeye. Apula:, ikila amowa, sita:newemi Newa mene ki salo inisekiwa, ka:ne opoya uluyetiyakamake kipila sutesinisene epapupesakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Alanase, auma:na: ikila amowa sena kesale peleya: sosolo weyemi sitalakamokiwa i salo emiwa hetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Auma:na: telanase, ikila sopoke kiyawa seli menapepeya:sela: sitalatipa:. Ala:sela:, Koteyewi penaiyawa kima tiye mita: ikila sopoke kulukulula:sela: sitalatipa:. Alusaleke, nano ketea hetetima:na: epamowa kiwemiwa sitiyetiye hanaposakeye. Apula: kiwa Sena Sa: sikapowemi ine tesi tepesakeye,” aluse, Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ikila sopoke Yesuyawa sena kesale imawa Kote koane suwemi Kote sowa waya:sela: enekeye. Apula: nukulapowemiwa Ewa Olofi tokowemi ha:na: enisene. ");
INSERT INTO khs_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aputa: kiapo ha:li ikiwapowemi sena kesaleyawa Kote koawemi E solo ta:pa:na: inisene. ");
INSERT INTO khs_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ikila sosolo Falawawa Solosene ketea Yisiwa Itapa Apola: Sapolo amo unu nowa Ikila Sosolo Koteyewi Isolaiya sena kesale Semeti Helepa:pe amo opo tewa mapatoyakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aputa: pilisiti sena piseiyawala ele walosene sena iyawala Yesuwa kumita: ko:lu sama:na:ne esa: isuwa nakeya:sela: enekeye. Ko:yawemiye, iyawa sena kesale sopoke iwamo ipilise. ");
INSERT INTO khs_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aputa: Seteneyawa Yutase Isikaliote kupu suwemi fiyanekeye. Yutase ewa Yesu Ewamo kulu hanosene sena kukuluipe amowa nowa ekeye. ");
INSERT INTO khs_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eyawa ha:na: tese pilisiti sena pisei alapulu apula: Kote koane suwemi ta:le ti sena elawalapulu sita:newemi eyawa sowa ilipe kekema:na:pela: hapakeye. Eyawa Yesuwa ili tiya:wemi tiye miya:na:pela: isu kelese hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aputa:, sena iyawa Yutase ewamo potapola: epelese sowa semetei tuwatese emawa moweni miya:na:keye e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Au selapitekiwa Yutase eyawa “ilikeye,” e seya. Apula: eyawa Yesuwa imawa ko:lu tiye miya:na:ne esa: isuwa nakeyakeye. Apula: eyawa sena kesalewa Yesuwalapulu masitalapita: emi tiye miya:na: esa: yesipela: enekeye. ");
INSERT INTO khs_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ikila Sosolo Falawa Solosene Ketea Yisiwa Itapa Apola: Sapolo amowa hetetikeye. Aputekiwa, Ikila Sosolo Koteyewi Isolaiya Sena Kesale Semetei Helepa:pe amo matanesekiwa a:pele sipi nowa sanosene. ");
INSERT INTO khs_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aputa: Yesuyewi Pita Yoneyeniwa ilikepilise selese, “Ka:ko: hanapola: Niyewi Ikila Sosolo Koteyewi Isolaiya Sena Kesale Semeti Helepa:pe amo matanese ma:na:wa seli tiye elatipa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aputa: a:tewi Ema ta:potose, “Keyawa na:tawa ma:na:wa nokami sela:pita: sela:?” ");
INSERT INTO khs_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Aputa: Eyewi mene selese, “Ka:ko: Yelusaleme siti honosane epemi hanose potakamake sena semetei nowamoke hawa wasutiye ina:neke koliyetiyaposakeye. Apula: koane ewamo hanakemi e fo:su kulu tiye ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Apula:, ka:tawa koane inama sela:pa:, ‘Walosene Senayewi kema ta:papokeye, “Makene mina ma:na:ma:na: koane numu apoyawa kami elapa:? Apula: Neyewi Newamo kulu hanosene sena niyewi Ikila Sosolo Koteyewi Isolaiya Sena Kesale Semeti Helepa:pe amo matanese ma:na:ma:na:wa selakeye,” e sela:pa:. ");
INSERT INTO khs_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Alusaleke eyawa ka:mawa numu sosolo nowa wa:pa:se falemi elakamo walopesakeye. Numu emiwa nano ketea sopoke iliyetiye elapita: potaposakeye. Alanase, ka:tawa ketea sopoke emi seli tiye apola:pa:. ");
INSERT INTO khs_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesuyawa a:mawa au selapita: ta:tapola: ha:na: potakamake nano ketea sopoke Eyewi seyawamunuse papo. Apula: a:tawa Ikila Sosolo Koteyewi Isolaiya Sena Kesale Semeti Helepa:pe amo matanese ma:na:ma:na: e seya amowa emi seli tiye apoyakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Aputa: ma:na:ma:na: e seya okemi Yesuwa apasolo sena kukuluipewalapulu iwa sopoke tepolo pawemi ine ka:la:lopela: enene. ");
INSERT INTO khs_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aputa: Yesuyewi ima selese, “Neyawa kiwalapulu ka:la:lopela:la: Ikila Sosolo Koteyewi Isolaiya Sena Kesale Semeti Helepa:pe amo matanase ma:na:ma:na:wa epeyawa sosolo tekeye. Alawamona, sikapewemiwa Newa kapo oya tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ko:yawemiye, Neyawa kima selakeye. Newa kiwalapuluwa Ikila Sosolo Koteyewi Isolaiya Sena Kesale Semeti Helepa:pe amo matanese ma:na:ma:na:wa wa:ke eta: ma:na:makeye. Alawamona, Kote Piseiki epela: ela peleya: falemi heneye hetetiyapita: emi wa:ke emi ma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Au selapola:, Eyawa waine hano kapowemi wasuwa tiyapola: Kotema sa:le napolo e selapola: apula: ima selese, “Waine hano we kiyewi tiyapola: kolotea esa: napela: nowama kine ela: ha:na:pa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","“Ko:yawemiye, Neyawa kima selakeye. Newa waine fo ipi amowa wa:ke eta: ma:na:makeye. Alawamona, Kote Piseiki epela: ela peleya: amowa hetetiyapita: wa:ke emi ma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Au selapola:, Eyawa falawa towapo semetei nowa tiyapola: Kotema sa:le napolo e selapola: Eyawa hotokeneye tiyapola: Ewamo kulu hanosene senama mikeye. Apula: kinise selese, “Ma:ne falawa we Ne toma kima mokopo kinakeye. Alanase, kiyawa epapula:sela: sita:lekiwa Newamo matanesela: elatipa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Apula: iyawa ma:na:wa napela: kotetiyapita:, Eyawa waine hano kapowemi wasuwa tiyapola: Ene ima seya amunuse selese, “Waine hano kapowemi wasulu we Ne pepeta kima mokopo kinakeye. Apula: kima kotolaka hili tima:na: timita: kinakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Alawamona, kiyawa pota! Sena nowamoke tiya:yewi Newa tiyapola: kisi sena tiya:wemi miya:na:wa Newanapulu tepolo pawemi helatakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Alanase, Sena Sa:wa isu puwano fa:nemi heka:pe emi hanaposakeye. Alawamona, sena eta:wiye Sena Sa:wa kisi senama tiye kinisaleke, sena amawa, ‘Sosolo haukula’ e selakeye!” ");
INSERT INTO khs_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Au selapita: ta:tapola: Yesu Ewamo kulu hanosene sena iyawa i kene kekelese selese, “Epe selese amowa sena eta:wi epesapa:?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aputa: Yesu kulu hanosene sena iyewi tapota: selese, “Sena puwano elaka ipa:? e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Aputa: Yesuyewi ima selese, “Yu senamawemi kiniwa emi tepela: penaiya opola amoke ela: iwa me pote tesene. Apula:, iwa penaiya opola tela sena iyawa iwa seli pote tesene sena iwa unuwa tesekiwa, seli pote tesene sena esa: unuwapokeye. ");
INSERT INTO khs_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Alawamona kiyawa au timinipa. Sena kili honosane epemi puwano elakamowa sikape me ha:na: tese ewa a sala mene tepa:. Apula: sena puwano putupela: ela sena amowa tima:na: tisene sena mene tepa:. ");
INSERT INTO khs_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Alake, puwano elaka sena ipa:? Sena tepolo pawemi hela amowa puwano elaka ewama? Apula: ema timonu tisene sena amowa puwano elaka ewama? Apula: sena puwano elaka ma:na: na:sela: hela sena epama? Alawamona, Newa kiwamo honosane epemi ela: kili tima:na: tisene sena amupula: enekeye. ");
INSERT INTO khs_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Apula: ta:peya kalikalila noka Ne salo minawamona kiwa Newanapulu enekeye. ");
INSERT INTO khs_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Apula: Ni Ata Piseiki Epela: Ela Peleya: amowa Nema mikeye. Ala amunuse Neyawa Kote Piseiki Epela: ela peleya: amowa kima kinakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Apula: kiwa Neyawa Piseiki epela: ela peleya: emiwa tepolo pawemi ine helese ma:na:wa hawanapulu emi naposakeye. Apula: kiwa kini sena helesene seawemi ine helese Isolaiya sena maya kukuluipewa kiyewi kotoma:na:pela: pote elaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aputa: Yesuyewi selese, “Saimone, Saimone, ta:ta:pa:. Setene eyawa Kotema penanose ta:potose witi tapo katalese henewa tise taka iya:tesene epapuluse kiwa auma:na: e seyakeye.” ");
INSERT INTO khs_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Alawamona, Neyawa kewamo matanese Kotema kulukululakeye. Kulukulusekiwa ke seli topuwa sutesima:pikise. Aputa: kewa me notoloyetiye mene inisekiwa, keyawa ke ma:ela:yewi seli topuwa keyewi talapa:walopesakeye.” ");
INSERT INTO khs_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aputa: Pitayewi Ema mene selese, “Sena Sosolo, newa Kewalapulu tipolo koane ha:na:na: seli tiye elakeye. Apula: newa Kewalapulu kuma:na:pela: seli tiye elakeye.” ");
INSERT INTO khs_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Aputa: Eyewi selese, “Pita, Neyawa kema selakeye. Napu emiwa kokono kalosene seta: kayama elapita:, keyawa Newa eta: potosemakeye esekiwa usulupe selaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aputa: Eyewi ima selese, “Neyewi kiwa Ne tima:na: timita: ilikepila:la: emiwa kiyawa moweni selalesene pausewa apula: yetuwala apula: tamakawala nano ketea epa sopoke eta: tiye hapamakeye. Alanase, ikila emiwa kiwa nano nowa hepe telala?” Au selapita: iyewi mene selese, “Eta: alamakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aputa: Eyewi ima selese, “Alawamona napu wemiwa kiyawa moweni selawatesene pausewala apula: yetuwala telaleke, tiye ha:na:pa:. Apula: kiyawa sapa senato elipei mina amowa itapalaleke, kiyawa kili sao kalesene epamowa sena nowama wa:la:lopa:. Wa:la:ya moweni amoke ela: sapa senato elipei mina amowa moweni amoke wa:la:lo tiyapola: ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ko:yawemiye, Kote Pukawemi Newemi auma:na: e seyawa heneye hetetiyaposakeye e seya amowa wekeye, ‘Ewa sena kesale nokamoke potakamakiwa ele tuwapo papaselesene sena amuna elapita: papokeye.’ Alanase, Neyawa kima selakeye, nano ketea sopoke Newemi auma:na: esa: Kote Pukawemi momateyawa heneye hetetiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Au selapita: Yesu Ewamo kulu hanosene sena selese, “Sena Sosolo, pota. Sapa senato elipei minawa elipei weye telakeye.” Aputa: Eyewi mene selese, “Ililakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aputa: Yesuwa Yelusaleme sitiwa iya:pela: Olofi tokowemi ha:na: tesenase ka hapakeye. Aputa: potapola:, Ewamo kulu hanosene sena iwala sopoke ilipe hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ha:na: fiyatese Yesuyewi ima selese, “Kiyawa kulukulula:sela: sitalatipa:. Ko:yawemiye ta:peyawa ki salo inakamake kiwa sutesima:pikitise. ");
INSERT INTO khs_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Apula: Ewa kolotea pama senayewi etewa sotukepilakamake ha:na: epapulawemi ha:na: kuniuwa kula:pela: ela: kulukulula:sela: selese, ");
INSERT INTO khs_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ni Ata, Kine Keyewi matanekamunuse kapo Newemi telaka tiye iya:ta:pa:. Alawamona, Keyawa Neye matana amunusekiwa timinipa. Keyewi matana amunuse timinipa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aluse kulukulula:sela: enewemi hepene sena semetei nowa inapola: Ewa penaiyawa tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Alawamona, Yesuyawa hilila matanawa ilima tese Kotema penanose kulukulukamake Ewemi hepepilawa peleya: kolemi tulusekiwa pepetawamuna tuyakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Apula: Ewa kulukulupela: tesi tiyapola: Ewamo kulu hanosene sena sitalakemi mene inise potakamake iwa falopela: elapita: papokeye. Ko:yawemiye, iwa himu nakola tise. ");
INSERT INTO khs_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aputa: Yesuyewi ima selese, “Kiwa ko:lupita: falopela: ela:? Tesima! Apula: ta:peyawa ki salo inakamake kiwa sutesima:pikitise Kotema kulukuluma,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesuyawa au sela:sela: Enewanapulu sena muta ilimawa Ewamo kulu hanosene sena Yutaseyewi putupela: inapita: papokeye. Yutase ewa Yesu kulu hanosene sena kukuluipe amowa nowa ekeye. Aputa: Yutase eyawa Yesu salo makalu tese minipa:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Alawamona, Yesuyewi ema selese, “Yutase keyawa Sena Sa:wa kisi senama tiye miya:na: esa: minita?” ");
INSERT INTO khs_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Aputa: Ewamo kulu hanosene sena iwa Yesuwalapulu sita:la: nano nowa hetetima:na: telalapita: potapola: selese, “Sena Sosolo, Niyawa sapa senato elipei mina weyamoke iwa sama:na:wa ililapa?” ");
INSERT INTO khs_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aputa: Ewamo kulu hanosene sena semetei nowamoke sapa senato elipei mina amoke pilisiti piseiki sena sosolo amo tima:na: tisene sena kena: ilitapowa aloye tikeye. ");
INSERT INTO khs_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Alawamona, Yesuyewi mene selese, “Mane keyewi epe timiniseya iya:pa!” e seyakeye. Aputa: Yesuyewi tima:na: tisene sena amo kena:wemi kesakamake e kena:wa napolo me telakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Apula: pilisiti sena solowalapulu apula: Kote koane suwemi ta:le ti sena alapulu apula: Yu piseiki sena iyawa Yesu salima:na: inapita: Eyewi ima selese, “Kiyawa sapa senatolo elipei minawanapulu apula: samenewanapulu tiyapola: epe inise amowa Newa atu tisene sena elapita: potapola: esa: ela? ");
INSERT INTO khs_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ikila sopoke Newa Kote koane suwemi kiwalapulu elakemiwa kiyawa Newa eta: ine salimakeye. Alawamona, napu opo weyamowa kili nenakeye. Apula: yopolotela penaiya weyamowa kili nenakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aputa: sena muta mina amoke putupela: hanapita: Yesuwala siliyapola: pilisiti piseiki sena amo koane suwemi siliye hapakeye. Aputa: Pitawa sikape pama komemi halute iwamo kulule hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kulu tiye ine potakamake, sena nokamoke pilisiti piseiki sena koanewemi tese sine sipa:lesene pakiya honosanewemi teiwa kititiyapola: ka:la:lopela: sita:lapita: potapola: Pita ewala ilipe kemi ine heyakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aputa: tei wa:ka:piya ho:liyawemi tima:na: tisene kesale nowamoke Pitawa potapola: selese, “Sena epa Yesuwalapulu tesekeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Au selapita: Pitayewi patiye selese, “Kesale, Neyawa Ewa eta: potosemakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Apula: komaiyamakemi sena nowamoke Pita potapola: selese, “Kewa Yesu kulu hanosene sena nowa kekeye,” e seya. Aputa: Pitayewi mene selese, “Sena, Newa Yesu kulu hanosene senamakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Apula: opo si semetei itapa tepela: sena nowamoke sowa unuwapo selese, “Hele henekeye sena epa Yesuwalapulu elapita: papokeye. Ko:yawemiye ewa Kalili senakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aputa: Pitayewi mene selese, “Sena, keyewi epe seleseya newa tikilitekeye,” e selakamake kokonowa kaiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aputa: Sena Sosowa mene notolose Pitawa siyewi kulu papokeye. Aputa: potapola:, Pitayawa Yesuyewi puwano fa:nemi ema selese, “Keyawa napu emiwa kokonowa seta: kayama elapita:, keyawa Newa eta: potosemakeye e sekiwa usulupe selaposakeye” e seya amowa me matanakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Amo matanese ewa hematapo fatemi hanapola: ya:lawa ilima telakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Aputa: senala: Yesu yesi sita:ne iyawa Yesuwa itipilise sanakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Apula: iyawa Yesu siwa saoyewi polopola: sanose selese, “Keyawa sena Kewamo sanaka unuwa sema. Sepatosene senayewi selesene amunuse sela:pa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Apula: iyawa Emawa itipilise solo olokeyatela ilima seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aputa: kiapo ikiwatapita:, Yu sena kesale piseiki senala: amowa pilisiti sena sosowala apula: ele walosene sena iyawala sopoke Yesuwa iyewi kekenesene koawemi siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hanapola: iyewi Ema selese, “Kewa heneye Kelesolaleke, nima sela:pa:,” e seya. Aputa: Yesuyewi mene selese, “Neyawa kima selapitekiwa, kiyawa eta: seli ta:pa:na:manakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","“Apula: Neyewi kima solo nowa ta:potosaleke, kiyawa Nemawa menewa eta: sema:na: telamanakeye. ");
INSERT INTO khs_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Alawamona napu weyemi ma:ta: tiyapola: sikape fa:nemiwana Sena Sa:wa Kote penaiya tiya: ili tapowemi helaposakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aputa: iyewi sopoke Ema ta:potose, “Auma:na:napita:, Kewa heneye Kote E Sa:la?” Aputa: Eyewi mene selese, “Kiye epe seleseya Nekeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aputa: iyewi selese, “Niyawa papolo sena nowa ina:pa: e selesewa ko:luma:na:pela: sela:? Niyawa Ene meatewi seya topu kakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Au selapita: ta:tapola:, sena muta sopoke iwa tesitiyapola: Yesuwa siliyapola: Pailete salo hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Siliye hanapola:, iyewi Yesuwa ma:ta: tiye kotose selese, “Sena weyamokiwa sena kesale niniwe sopoke Eyewi siliye isu nokemi ha:na:na:keye. Apula: Eyawa nimawa Sisa takase tisene sena amawa takesewa tuwatapa e sela:nekeye. Apula: Ene ela: mene selese Ewa Kelesowala apula: kiniwana ekeye, e seyakeye.” ");
INSERT INTO khs_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Aputa: Pailete eyewi Yesuma ta:potose, “Yu sena kiniwa Keya?” Aputa: Eyewi ema mene selese, “Kine epe seleseya kakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Au selapita: Pailete eyewi pilisiti piseiki senamawana apula: sena kesale sopoke ima selese, “Neyewi potakamakiwa sena weyamokiwa hele timiya nowa mapotakeye.” ");
INSERT INTO khs_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Alawamona, iyawa penanose selese, “Kalili peleya:wemi tese ma:ta: tiyapola: ine Yutia peleya: napu nini sitala weyemiwa sena weyamokiwa sena kesalemawa waya:sila: tekamake iwa matanawa tutemita: selesekeye.” ");
INSERT INTO khs_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Alawamona, Pailete eyawa solo amo ta:tapola: ima selese, “Sena we Kalili senaya?” ");
INSERT INTO khs_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aputa: Pailete eyawa Yesuwa Kalili senanapita: potapola: Ewa Helote salo ilikepiya. Ko:yawemiye Kalili peleya:wa Helote ene yesilanase. Ikila emiwa Helote ewa Yelusaleme emi makene minakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yesuwa Helote salo siliye inapita: potose epeyawa ilima telakeye. Ko:yawemiye, Eyawa Yesuyewi timiya sowa topunase eyawa Ewa popa:na: matanakeye. Apula: eyawa Yesuyewi mono tema:na: tela ketea nowa timinimita: matanakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Alanase, Helote eyawa Yesumawa topukanesela: telawa ilima telakeye. Alawamona, Yesuyawa solo semetei nowa menewa eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aputa: pilisiti sena soloyawala apula: ele walosene sena iwa pawemi tesi tiyapola: sita:la: Yesuma sowa penanose kotolakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kotola:selekiwa, Helote e ta:le ti sena iyawa sopoke Yesuwa ikumunuse itipilise sao napolo hili senatowa kapela: apola: Pailete salowemi mene ilikepiyakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ala:ne, ikila emiwa Helote Pailete elipeiwa mana tuwapokeye. Alawamona, puwano fa:nemiwa elipe kisi enekeye. ");
INSERT INTO khs_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Aputa: Pailete eyawa pilisiti sena sosowala apula: Yu piseiki senawana apula: sena kesale kiwa sopoke mina e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Apula: iwa inapita:, ima selese, “Kiyawa sena epa ne salo siliye minakeye. Emi selesekiwa Eyawa sena kesale matanawa sopoke Eyewi tutemita: selesekeye. Alawamona, neye Ewa kili sikapowemi potakamakiwa hele timiya kiyewi papolo selesewa itapalapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aputa: Helote eyawala hele timiya nowa Yesuwemiwa mapotapita: ni salo mene ilikepiyalakeye. Alake, kiyawala pota:pa:. Sena epamokiwa hele timiya semetei nowa itapawemi kuma:na:wa ililapa? ");
INSERT INTO khs_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Alanase, neyawa Ewa mona falasipela: mene hamona e sema:na:keye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Au selapita:, sena kesale sopoyewi sowa unuwapo holose selese, “Sena epa siliye hamona. Apula: Panapasewa mene silikepila:pa:!” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Aputa: sena Panapase eyawa siti honosane emi kamani senawanapulu tepa:na: ma:ta: tisewa ekeye. Aluse, sena nowa eyewi sana kulukeye. Aputa: potapola: ewa tipolo selawapokeye. ");
INSERT INTO khs_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aputa: Pailete eyawa Yesuwa iya:pa:na: matanese ima wa:ke me seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Alawamona, iyewi unuwapo holose selese, “Ewa i kelipa:peyawemi ikokoyewi fe oma! Ewa i kelipa:peyawemi ikokoyewi fe oma!” ");
INSERT INTO khs_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aputa: Pailete eyewi ima osolo weyamo selese, “Ko:yawemiye? Apula: sena epamokiwa hele timiyawa enana? Alanase, Ewa kumita: sama:na:wa mouwa eta: papomakeye. Alanase, Ewa neyewi mona falasipela: mene hamona e sema:na:keye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Alawamona, iyawa hele unuwapo holose Paileteyewi Yesuwa i kelipa:peyawemi i kokoyewi fe oma esa: ili sowamoke Pailete solo seyawa foye tikeye. ");
INSERT INTO khs_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aputa: potapola: Pailete eyawa sena kesale iyewi matanawamunuse timinimita: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Apula: Pailete eyawa sena siti honosanewemi kamani senawanapulu tepa:na: ma:ta: tise sena nowa sana kulapita: tipolo selawapo sena amowa mene silikepiyakeye. Ko:yawemiye sena kesale iyawa ewa mene silikepima e selalapita:. Aputa: ili matanawamunuse Yesuwa tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Aputa: iyawa Yesuwa saliyapola: hanose potakamake sena nowa unua Saimone e peleya:wa Sailini Yelusaleme hemawemi enewa ine emi elapita: papo. Sena amowa iyewi saliyapola: i kelipapoyawa emawa uwapola: apolose tinenise Yesu hapa sikapewemi uwapola: hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Aputa: sena kesale ilima Yesuwa kulu tiye hanose kesale nokamokiwa Ewamopela: hauwekila: apula: ya:pelese ilima tela hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Aputa: potapola:, Yesuyewi notolo potose ima selese, “Yelusaleme E la:lela:, kiyawa Newamopela: ya:lapa. Kiyawa kiwamopela: ya:pelepa:. Kiyawa kili salawamopela: ya:pelepa:. ");
INSERT INTO khs_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ko:yawemiye, ikila nowemiwa fiyatepita: iyewi selesekiwa, ‘Kesale initela apula: e salawemi salawa eta: kesilisema apula: po ipi salayawa eta: mima, ili amokiyawa epelepesakeye!’ ");
INSERT INTO khs_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ikila emiwa iyewi tokomoma selese, “Niwemi ine feselema!” Apula: iyewi tupuyama selese, “Niwemi o:sula:pa:!” ");
INSERT INTO khs_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aputa: napu iyawa i ima emi mane weyamowa timinisaleke, i oyawemiwa iyawa mane ena timinipesapa:?” Aluse Yesuyewi seyawa wekeye. ");
INSERT INTO khs_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Au selapola: iyewi sena elipei puwano mane olokeyatela timinisene a:ko: Yesuwalapulu saliyapola: sanose kumita: hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Siliyapola: hapa peleya: amo unua Piseiki peleya: emi ha:na: hetetipela: iyewi Yesuwa i kelipa:peyawemi fe ola. Apula: sena elipei mane olokeyatela timinisene amowana i kelipapoyawemi fe ola. Nowa Yesu tiya: ili tapowemi fe olakeye. Nowa Yesu tiya: hukalo tapowemi fe olakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aputa: Yesuyewi selese, “Ni Ata, Keyawa ili olokeyatela timiya epa kepoliyetima. Ko:yawemiye iyewi epe timiniseya eta: matanamakeye,” e seya. Aputa: iyawa E sao kala amo tima:na:pela: napa etewawemi momateya ela amo fesamonakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Aputa: sena kesale sopoke Ewamo pota:sela: sita:ne. Apula: Yu pisei sena iyawa Yesuma itipilise selese, “Sena kesale noka Eyewi seselakeye. Alanase, Ewa Koteya Keleso ta:pele tiye apoyalaleke, Ene mene ela: sesema.” ");
INSERT INTO khs_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aputa: ta:le ti sena iyawala Yesu E salo inapola: Ema itipilise solo olokeyatela seyakeye. Aputa: iyawa waine hano ha:ka:la amowa Ema ta:pelese mikeye. ");
INSERT INTO khs_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Aputa: iyewi selese, “Kewa Yu sena kesale kini elaleke, kine mene sesema!” ");
INSERT INTO khs_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Aputa: iyewi sepapo solo momateya amowa tiyapola: Yesu pisei ela amo wa:pa:se falemi papela: apoyakeye. Amoke selesewa, “Sena epamowa Yu sena kesale kini elakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aputa: sena semetei nowa mane olokeyatela timinisene i kelipa:peyawemi fe ola amoke Yesuma itipilise selese, “Kewa Kelesowa? Alanase, kine mene seselese na:ko:lapulu sesepa:!” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Alawamona, sena mane olokeyatela timinisene nowamoke sena nowama konomonose selese, “mane falasila semetei keyewi ti kamunanase keyawa Kotewa maipipa? ");
INSERT INTO khs_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aputa: na:tawa mane olokeyatela timiya weyamo falasima:nawa amowa hekeyakeye. Alawamona sena epa olokeyatela hele timiyawa itapakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aputa: eyewi Yesuma selese, “Yesu, Kewa Kote piseiki epela: ela peleya: falemi elekiwa Keyawa newa kepoliyetiyapa.” ");
INSERT INTO khs_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aputa: Yesuyewi mene selese, “Neyawa heneye kema selakeye. Napu kewa Newanapulu hepene peleya: napolo emi elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Napu emiwa oka olo (12) tekeye. Aputa: yopolotelayewi peleya: sopolo we fopula: ha:na: tese oka osolo tikeye. ");
INSERT INTO khs_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ko:yawemiye, ho:liya weyamo oka eta: ho:liyama enekeye. Aputa: Kote koane sulu sao teya amowa honosane keseleye tikeye. ");
INSERT INTO khs_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Aputa: Yesuyewi unuwapo penaiya holose selese, “Ni Ata, Ne ho amowa ke tiya:wemi kinakeye.” Au selapola:, Ewa a hepa:la:newa ke ulutikeye. ");
INSERT INTO khs_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Aputa: ta:le ti piseiki sena amoke potapola:, Kote unua wapilise selese, “Heneye, Sena epamowa hekeya senanakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aputa: sena kesale sopoke ine kekene tiye nano timiya amo potapola: iyawa hauwekilise ili pominiwemi sanose mene hapa. ");
INSERT INTO khs_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Alawamona, sena kesale Ewa matana apula: Kalili kesale nokala Ewamo kulu tiye mina iyawa sopoke kolotea pama sita:la: nano ketea emi timinikamo pota:sela: sita:ne. ");
INSERT INTO khs_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aputa: sena semetei nowa unua Yosepe enekeye. Sena amowa e peleya:wa Yu siti semetei nowa unua Alematia. Ewa sena napolo apula: hekeya senakeye. Yu piseiki sena kekenesene nowa Yosepe ekeye. Apula: eyawa Yu piseiki sena nokalapulu mane iyewi timiya amowa solo semetei eta: sepapomakeye. Eyawa Kote piseiki epela: ela peleya: fala yesipela: enekeye. ");
INSERT INTO khs_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aputa: sena amowa Pailete salo Yesu toma tima:na:pela: ta:popa:na: hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Aputa: Eyawa Yesu tomawa tiyapola: sine tuwapola: sao napoyewi sakotiyapola: etewa apana ta:la emi ha:na: tuwapokeye. Apula: etewa apana ta:la amowa puwanowa sena kuluwa emiwa eta: tuwatesemakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Aputa: ikila opo weyamowa Yu sena kesaleyewi nano ketea sopoke seli timoniyetikeye. Ko:yawemiye Ha:le Tesene Ikila amowa aso fiyatema:na: pa telakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aputa: Kalili kesale Yesuwamo kulu tiye mina iyawa Yosepe kulu tiye etewa apana ta:la amo popa:na: hapakeye. Aputa: iyawala Yesu tomawa ko:lu tuwatape esa: popa:na: hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aputa: potapola:, iwa meneyetiye hanapola: wela hano ikumu hoseya alapulu apula: pauta amuna amowa Yesu tomawemi mupa:na:pela: seli tiye tuwapo. Aputa: Ha:le Tesene Ikila emiwa ele seya amunuse iwa ha:le sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aputa: sokatiye semetei ikila towemiwa ha:li ikila emiwa kesale ili amokiwa etewa apana ta:la emi hapa. Apula: iwa emi hanose wela hano ikumu hoseya napolo apula: pauta amuna iyewi seli tiye tuwapowa tiyapola: minakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Apula: iwa inapola: potakamake etewa kepiya etewa apana isu etalesene amowa kepelela hapa elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Alawamona, iwa suwemi musuluwate sane potakamake Sena Sosolo, Yesu tomawa eta: papomakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aputa: iyawa Yesu tomawa kami elape esa: matanawa ilima telakeye. Apula: iyewi kipila potakamake kesalela: iwamo sita:ne hema emiwa sena elipei eli sao kala amowa ho:liyawa ilima elapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aputa: potapola:, kesalela: iwa ipilise ili mitiwa peleya: tapo kotote sinikeye. Aputa: sena elipei amoke ima selese, “Kiyewi sena falela ela amowa sena kulu tuwatesene etewa apana emiwa ko:luma:na: popa:na: minana? ");
INSERT INTO khs_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ewa weyemiwa maelakeye. Ewa mene tesikeye. Puwano Eyewi Kalili peleya: sila:sela: seya amowa ikila emiwa amo mene matanepa:. ");
INSERT INTO khs_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Eyewi ela: kima selese, ‘Sena Sa:wa olokeyatela timinisene senama kinaposakeye. Apula: iyewi Ewa i kelipa:peyawemi ikokoyewi fe olaposakeye. Apula: ikila usulupe tepela: Ewa mene tesilaposakeye,’” e seya. ");
INSERT INTO khs_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aputa: iyawa Yesu solo seyawa amo mene matanakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aputa: iwa etewa apana ta:la emi tepela: meneye tiye hanapola: Yesu kulu hanosene sena keneneipemawanapulu apula: sena kesale nokamawana nano ketea sopoke weyamu hetetikeye esa: ima seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aputa: kesale iyawa Apasolo sena ima solo weyamowa seyakeye. Kesale semetei amowa e unua Meli e peleya:wa Makatala. Apula: nowa Yoana. Apula: nowa Yemese Yo unua Meli. Apula: kesale nokala iwalapulu sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Aputa: kesale iyewi solo seyawa Apasolo senala: iyawa eta: seli topumakeye. Ko:yawemiye, iyawa kesalela: iyewi seyawa mokopo selapele esa: matanakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Alawamona, Pitawa tesitiyapola: etewa apana ta:la emi nesile hapakeye. Apula: ewa kula:pela: potakamake Yesu tomawemi sakola saowa telapita papokeye. Aputa: potapola:, ewa ene mene kete matanese “Ko:yale?” esa: meneyetiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ikila semetei kemi Yesu kulu hanosene sena elipei amowa Emease koamesa: emi ha:na:nekeye. Apula: Yelusaleme sitiwemi tiye Emease koamesa: amowa aso kolotea pama kilomitawa keneneipe epapula hanosenekeye. ");
INSERT INTO khs_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aputa: sena elipei amowa a:petane nano ketea sopoke heteti amo sela hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Apula: a:ko: ha:na:sela: nano ketea sopoke heteti amo wapilise. Ikila emiwa Yesu Ene Ewa ine hetetipela: a:ko:lapulu hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Alawamona, nano semetei nowamoke eli siwa etapeyakeye. Alanase, a:tewa Ewa Yesulapo esa: eta: seli misili papomakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aputa: Eyewi a:ma ta:potose, “Ka:ko: ha:na:selekiwa ena wapilise ha:na:sela:?”, e seya. Au selapita: a:ko: ke enetela eli mitiwa himu nakola ilima telakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sena elipei nowa unua Kiliopase eyewi mene ta:potose, “Kewa Yelusalemewemi makene epe iniseya nano ketea sopoke napu weyemi hetetiyaka Keyawa eta: matanamana?” ");
INSERT INTO khs_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aputa: Yesuyewi mene ta:potose, “Ena nano ketea hetetila?” Aputa: a:tewi mene selese, “Na:tawa Na:selete sena Yesuwamo selakeye. Ewa sepatosene senakeye. Apula: Eyewi tima:na: tiye hanosene apula: e solo seyawa Kote sikapowemiwana apula: sena kesale sikapowemiwana penaiya enekeye. ");
INSERT INTO khs_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Alanase, pilisiti sena sosowala apula: nini piseiki senawana iyawa Ewa Lome kamanima kinise Ewa kula:pa: esa: kinise iyawa Ewa i kelipa:peyawemi ikokoyewi fe olakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Alawamona, Niyewi sosolo matanesekiwa Ene Eyawa Isolaiyawa mene tima:na: pa telakeye. Apula: nano ketea sopoke weyamo wa:pa:sewemiwa nowa elakeye. Aputa: napu ikila usulupe sikapewemiwa nano ketea sopoke amowa emi hetetikeye. ");
INSERT INTO khs_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aputa: napu weyemiwa nini kesale nokamoke nima mona:pekeye. Ha:li ikilawemi iwa etewa apana ta:la hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Aputa: iyawa Yesu tomawa eta: papomakeye. Alanase, iwa meneyetiye hanapola: sela:sela: iyewi potakamake hepene senala: selese “Ewa faleyetiye elakeye” e seyawa papokeye. ");
INSERT INTO khs_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aluse, sena nini nokamoke etewa apana ta:la emi hanapola: kesale iyewi nano ketea sopoke seyawa kamuna papokeye. Alawamona, iyawa Yesuwa eta: papoma” e seya. ");
INSERT INTO khs_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aputa: Eyewi a:ma selese, “Ka:ko: eta: seli matanesemanase sepatosene senayewi nano ketea sopoke seyawa amowa ka:li seli topuwa himu matanawa halute elatakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ko:yala? Puwanowa Kelesoyawa nano ketea sopoke weyamowa oya sosolo tiyapola: elapita: sikapewemiwa Eyawa E penaiya opola papalola tiyaposakeye,” Yesuyewi au seya. ");
INSERT INTO khs_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Apula: Eyawa a:mawa sowa walo tiye mikeye. Eyawa Mosese solo seyawala apula: sepatosene sena solo seyawala sopoke amowa a:ma ma:ta: tiye sema:na:pela: elakeye. Eyawa a:mawa Kote puka suwemi ene ewamo momateya amowa mouwa we esa: wayakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Aputa: iyawa koamesa: a:ko:mo epesene ela amo pawemi ha:na: telakeye. Alawamona, Yesu Eyawa mokopo ha:na:nekeye. ");
INSERT INTO khs_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Alanase, a:tawa Yesuma penanose selese, “Kewa na:ko:lapulu epesene mina. Ko:yawemiye, nukuluma:na: mapatokeye. Apula: ikila we itapa tema:na: tekeye.” A:tawa au selapita:, Ewa a:ko:lapulu koane suwemi tuwatene enekeye. ");
INSERT INTO khs_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Apula: Ewa a:ko:lapulu tepolo pawemi ka:la:lopela: ela: falawa tiyapola: Kotema sa:le napolo e sepela: panotiye a:ma ma:ta: tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aputa: Eye au timinikamake, eli siwa faka:pela: a:tawa Ewa Yesuwa elapa esa: papokeye. Apula: eli sikapowemiwa kipila Ewa enene kamona itapa telakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aputa: a:mene selese, “Niwa isu weyemi inise Kote pukawemi momateyawa Eyewi na:ma se tiye mikeye. Ikila emiwa na:ni himuwa tei wa:la amuna telalapa? ");
INSERT INTO khs_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aputa: a:tawa au selapola:, a:ko: kipila tesi tiyapola: Yelusaleme mene hapakeye. Apula: a:tawa Yesu kulu hanosene sena keneneipewala apula: sena kesale nokalapulu sopoke iwa kekene tiye sita:lapita: papo. ");
INSERT INTO khs_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aputa: iyewi a:ma selese, “Amowa henekeye! Sena Sosolo Ewa mene tesilapola: Ene mene Saimonema wayakeye.” ");
INSERT INTO khs_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Aputa: a:tawa nano ketea sopoke isu honosane ha:na:newemi heteti amowa ima kekena emi wa tiye mikeye. Aputa: a:tawa Yesuyewi falawa pano tiye kinapita: a:tawa emi ela: misili papolo amowana ima emi wa tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aputa: Yesu kulu hanosene senayewi nano ketea weyamowa sela:sela: sitalapita: Yesu Ene Ewa iwamo honosane ke ine tesi tiyapola: ela: selese, “Himu hopola kiwalapulu elatipa:,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Apula: iwa tuteilise ipilise iyawa sena nowamo kulu ho esa: matanese papokeye. ");
INSERT INTO khs_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aputa: Eyewi ima selese, “Kiyawa epa tuteiliseya ko:luse ela:? Kiyawa kili himu matana fa:nemi kete matanesewa ko:luse ela:? ");
INSERT INTO khs_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kiyawa ne tiya:le ne onatu we popa! Newa Nine Newamo elakeye. Ne tomawa kesama apula: popa. Alanase, howa fowa itapa apula: kiwa itapakeye. Alawamona, kiyawa Newa fowa kiwa elapita: potakeye.” ");
INSERT INTO khs_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Au selapola:, Eyawa E tiya:wa E onatuwa ima wayakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Apula: Yesuyewi nano sopoke weyamowa ima wayakeye. Alawamona, iyawa eta: seli topumakeye. Ko:yawemiye, ili himu matana fa:na tuteilise epeya sosolo telakeye. Ikila emiwa Yesuyewi ima ta:potose, “Kiyawa weyemiwa ma:na:wa telapa?” e seya. ");
INSERT INTO khs_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aputa: iyewi ewawa sona hepe amowa Ema mikeye. ");
INSERT INTO khs_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Apula: ili sikapowemi Eyawa tiyapola: menakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aputa: Eyewi ima selese, “Newa kiwalapulu ene ikila emi kima seyawa amo wekeye, Puwano iyewi Newamo nano ketea sopoke amowa momateyawa Mosese elewemiwana apula: sepatosene sena pukawemiwana apula: kisala pukawemiwana nano ketea sopoke amowa sa:le heneye hetetiyaposakeye,” e seya. ");
INSERT INTO khs_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aputa: Yesuyewi ili matanawa me kola:pemita: apula: iyawala Kote Puka momateya amowa matanemita: elakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aputa: Eyewi ima selese, “Kote Pukawemiwa au seyakeye, ‘Keleso Ewa oya sosolo tiyapola: apula: Ewa ikiwapo usulupe tepela: kuluwa mene tesilaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Apula: E unuwemi ela: iyawa peleya: sopoke hanose sena kesalema emi sitalaka matana notoye apula: ili mane olokeyatela timinisene amowana iya:pita: solo amowa sela:pa:. Kiyawa tima:na: weyamowa Yelusalemewemi ma:ta: tiye ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aputa: nano ketea sopoke weyamowa kili siye papokeye. ");
INSERT INTO khs_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aputa: puwanowa Ni Atayewi ela: nano nowa miya:na:pela: sepapokeye. Amowa Neye kima ilikepima:na:keye. Alawamona, kiwa Yelusaleme siti honosane weyemi elatipa: Kote penaiya opola amoke falemi tepela: sinapola: kiwa sopoke amoke fopulaposakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Aputa: Yesuyewi Ewamo kulu hanosene senawa siliyapola: Petani koamesa:wemi Eyewi putupela: hapakeye. Apula: Eyawa E tiya:wa tilitiyapola: Kotema selese, “Iwa Keyewi napola:ta:pa:” e seyakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Au sela:sela: “napola:ta:pa:” e sela:ne emiwa Eyawa iwa iya:pela: Koteyewi Ewa hepene falemi tiye fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Apula: iwa sopoke Yelusalemewemi mene hanose iwa epeyawa sosolo tiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Apula: ikila sopoke iyawa Kote koane suwemi elekiwa E unua wapiya:sela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nano ketea sopoke ma:ta: ti ikila emiwa, E unuwa Solo puwano kokolo kao enekeye. Sowa Kotewalapulu semetei enekeye. Sowa Ene Kotekeye. ");
INSERT INTO khs_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nano ketea sopoke ma:ta: ti ikila emiwa Ewa Kotewalapulu semetei kokolo kao enekeye. ");
INSERT INTO khs_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ewemi tese nano ketea sopoke ma:ta: tikeye. Ewa iya:pela: nano ketea sopoke ma:ta: timakeye. Alawamona, Ewa emi tese ma:ta: tikeye. ");
INSERT INTO khs_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kokolo kao elakamoke mouwa Ewa Ene ekeye. Kokolo kao elakamoke ho:liyawa senamawana kinisekeye. ");
INSERT INTO khs_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ho:liya amoke yopolotela olapo honosane sosolo ho:lilise elakeye. Yopolotelayewi ho:liyawa eta: sekakoma:na: telamakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Aluse ho:liyawa selapose sena semetei nowa Koteyewi hamona seyakeye. Hamonapita: minawa Ewa unuwa Yonekeye. Sena kesale sopoke ta: timita: eyewi selapose minakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ho:liyawa emakeye. Ho:liyawa eyewi selapose minakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Aputa: heneye ho:liyayewi peleya: weyemi sena kesale sopoke ho:lilimita: minakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Alawamona puwano fa:nemiwa Eyewi peleya: weyamowana senala: amowana timiyakeye. Eyewi Ene timiya kamunuse Ewa peleya: sosolo weyemi mina ikila emiwa sena kesale Ewa kepoliyetikeye. Koteyewi Ewa hamonapita:, minawa sena kesale eta: matanemakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ene sena maya koamesa: inapitekiwa iyawa Ewa eta: seli silimakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Alawamona sena kesale nokamoke Ewa nekanese Eyewi Ewa unuwapowa papela: Ema himu semetei matanesaleke ima Eyewi selese, “Kiwa Kote Salakeye,” esa: seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kote e sa:keye, au seyawa sena kesaleyawa tiyapola: sala tiye apoya amakeye. Sena kesaleyewi tiyapola: sala kesa:pe sala amowa senayewi Ene matanawamoke akeye. Alawamona, Kote sala sita:pesita: Koteyewi Ene matanese selese, “Kewa Neyewi nine Ni Sa:keye.” Aluse Ene E Sa:le sita:pesita: apolowayakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Aputa: Solo nini sena tomawa tiye, peleya: weyemi inapola: niwanapulu enekeye. Eyawa niwamo matanese sosolo seselese, heneye solo amowa Ewemi woliyetiye ela: se tiye kinisekeye. Solo kinakamokiwa Yesuyewi penaiya ho:liyawa niyewi papokeye. Ene penaiya ho:liyawa Ene Kote sala semetei kanase Kote penaiya ho:liyawa akeye. ");
INSERT INTO khs_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Aputa: Kote sala amowa Yoneyewi seyakeye. Yoneyewi penanose selese, “Sena sikape mina:na:wa Ewa Ene hene heneye puwanokeye. Newa a kesima:na: Ewa puwano kokolo kao enekeye. Puwano kokolo kao enenase Ewa Ene hene heneye sosokeye. Newa koloteakeye,” aluse Yoneyewi seyawamunuse potakamake Yesuwa inapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yesuyewi niwa sopoke mokopo sosolo seselakeye. Me wa:ke sikapewala, wa:kiwala mokopo seselese elaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kote solo elewa Moseseyewi senama sowa mikeye. Aputa: mokopo seselesewana, heneye selesewana, Yesu Kelesoyewi nima mikeye. ");
INSERT INTO khs_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Senayewi Kotewa eta: potesemakeye. Alawamona, Ene E Sa:le semetei kamunuse elipe semetei sita:nenase, Sala amoke Koteyewi alusewa waloma:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yu sena tililayawa pilisiti senamawana, Lifai senamawana selese, “Kiwa Yelusaleme siti iya:pela: Yonema nano ta:pa:na:wa ha:na:pa:.” Aputa: iwa hanapola: Yone enewemi inapola: selese, “Kewa ipa:? Koteye hamona seya senawa kewama?” ");
INSERT INTO khs_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aputa: Yoneyewi eta: mupapomakeye. Eyewi hokatolose selese, “Newa Kelesomakeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Au selapita: iyewi selese, “Kewa ipa:? Ilaiya kewama?” Aputa: eyewi selese, “Aupa, newa Ilaiyamakeye.” Au selapita: iyewi selese, “Sepatosene sena sosowa kewama?” Au selapita: eyewi selese, “Nemakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Au selapita: iyewi selese, “Kewa ipa:? Niwa hamona seya sena amawa niyewi sema:na:pela: keyewi sema.” ");
INSERT INTO khs_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aputa: eyewi selese, “Moawemi unuwapo selese sena amowa nekeye. Piseiki mina:na:wa isu kiwemi koakenananeke heka:ta:pa: au sema:na:wa sena amowa nekeye. Newa Aisaiayewi momateyalakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aputa: Felesi senayewi hamona seya sena amoke selese ");
INSERT INTO khs_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Kelesowa sikapewala, Ilaiya amowana, apula: sepatosene sena sosowa kemakeye. Alake ko:lupita: keyewi sena kesalewa hawemi toliyetisiye?” ");
INSERT INTO khs_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Au selapita: Yoneyewi selese, “Neyewi sena kesale hawemi semetei toluyetiyakeye. Newa enewemi sena semetei nowa mina:na:keye. Ewa mina:na:wa kiwalapulu elakeye. Aluse kiyawa Ewa mamatanekeye. Ewa sena sosonase tima:na: tisene sena e tamaka amowa fakelesene aluse neyewi fakema:na:wa eta: ilimanakeye. Ewa sena sosonase neyewi Ewamopela: tima:na: tisene tima:na:pela: elawamona sikapewala newa koloteanase neyewi tiyakamakiwa eta: ilimanakeye. Newa Ewalapulu eta: ilimakeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Aluse Yoneyewi Petani koawemi seyakeye. Hano Yotane tapo fa:nemi Petani koamesa: elakeye. Hano Yotanewemi Yoneyewi sena kesale hawemi tolusulakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nukulapo semetei eniyapola:, kiapo Yoneyewi potakamake Yesu inapita: potose selese, “Pota:pa:. Kote a:pele sipi E Sa:wa inatakeye. Sena kesaleyewi peleya: sosolo we sita:ne himu matanawemi nano olokeyatelawa Eyewi iya:pa:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Puwano Ewane neyewi kima selaka akeye. Alake neyawa puwano minanase sena nowa sikape mina:na: seyawa iniseya epalakeye. Alake sena amowa newa eta: kesilama Ewa Ene puwano fa:nemiwa kokolo kao enekeye. Alake sena amowa Ene hene heneye puwanokeye. ");
INSERT INTO khs_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Puwano sena nowa Koteyewi hamonama:na: e seyawa neyewi ta:tese ipi inaposapei, aluse matanese newa eta: kolaiyamakeye. Alawamona Isolaiya sena kesaleyewi kiyawa Ewa matanemita: kiwa neyewi hawemi toluyetiyakeye. Hawemi toluyetiyapola: Ewa walosene amunuse walokeye,” aluse Yoneyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Au seya wa:ke Yoneyewi selese, “Puwano Koteyewi nema hawemi toluyetima:na: hamona seyakeye. Koteyewi se tiye mini kemi selese, ‘Ho Napolo inapola: sena semetei nowemi helepita: eye ene kemi Ho Napowa sena kesalema miya:na:keye.’ Au seya Koteyewi seyawamunuse sena amowa hetetiya inapita: puwano Ewa neyewi eta: kolaiyamakeye. Tikilitelawane Ho Napowa a:nema: tumu amuna Ewemi helepita: potose neyewi matanese, ‘Koteyewi puwano solo amowa Ewalakeye,’ esa: neyewi matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Matanepela: Ewane ne siyewi potapola: selese, ‘Ewa heneye Kote E Sa:keye. Koteyewi ta:peya Sena Epa ewalakeye,’ esa: neyewi selese elakeye.” Au seya Yoneyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yopolotela semetei eniyapola:, kiapo Yone ene sena semetei hanosene sena elipei sita:la:, eyewi potakamake ");
INSERT INTO khs_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yesuwa hanapitekiwa potapola: holose selese, “Pota:pa:. Koteyewi a:pele sipi e sa:le Ewa hanatakeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Au seya hopita: Yoneyewi sena semetei hanosene a:ko: amoke ta:tapola: Yonewa iya:pela: Yesuwa kulule hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kulule hanose inapita: Yesuyewi fa:tapo elipei kulule hanose inapitekiwa potapola: selese, “Ka:ko: ena popa:na:pela: ina:?” Au selapita: a:te selese, “Lapai, (e seya amowa mouwa, Walosene sena) Kewa koane kami enisena?” ");
INSERT INTO khs_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Apula: Yesuyewi selese, “Potapose mina.” Aputa: elipei Yesuwalapulu hanapola: E koane enisewa papokeye. Papo ikila kemi Yesuwalapulu sita:nekeye. Yesuwalapulu sita:ne ikila amowa ka:le opo pinipikeye. ");
INSERT INTO khs_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yone sowa ta: tiyapola: Yesu kulu hanose hapa sena a:ko: nowa unuwa A:nitulukeye. A:nitulu ewa Saimone Pita e ma:ekeye. ");
INSERT INTO khs_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Puwano A:nitulu ewa e ma:e Saimone amowa keye hapakeye. Hanapola: ewa keyalapepela: potapola: selese, “Sena Koteyewi hamonama:na: Mesaiyawa mina e seyawa na:te papokeye. Mesaiya amo mouwa Kelesokeye. Kelesowa Koteyewi Piseiki ta:pele tiyapola: apoya alapokeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Au seya A:nituluyewi Saimone amowa siliye Yesu enewemi minakeye. Inapita: Yesuyewi ewa potapola: selese, “Kewa Yone e sa:le Saimone elakeye. Yemiwa Neyewi kewa unuwatese Sifase unu tuwatakeye,” esa: Yesuyewi seyakeye. Aputa: Sifase unuwapowa Kiliki solopela:la: Pita unuwapokeye. ");
INSERT INTO khs_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yopolotela semetei eniyapola:, kiapo Yesu Kalili peleya:wemi hapakeye. Hanapola: Filipi potosekiwa selese, “Newamo kulu ina:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aputa: Filipi ene Pesaita taunewemi enekeye. A:nituluwala, Pitawala iwa Pesaita taunewemi ilipe sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi hanapola: Natanio potapola: ema selese, “Moseseyewi solo ele pukawemi momate tiye apoya sena amowa niyewi papokeye. Sepatosene senayawala Ewane momateyawa niyewi papokeye. Ewa Yosepeyewi e sa:le Yesukeye. E koamesa: Nasalete koakeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Au selapita: Natanioyewi selese, “Nasalete koamesa: emiwa sena napolo eta: inisemakeye.” Au selapita: Filipiyewi selese, “Potapose mina,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aluse a:ko: hanapola: Natanio inapita: Yesuyewi potapola: selese, “Isolaiya sena napowa ewalakeye. Eyewi nano mokopo eta: selesemakeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Au selapita: Natanioyewi selese, “Keyawa newa noko:lu matanese potapola: sela:?” Au selapita: Yesuyewi selese, “Filipiyewi kema mine e seyawa kewa i kalu mouwemi helapita: Neyewi kewa papokeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Au selapita: Natanioyewi selese, “Walosene sena, Kote sena Sa:wane Kewalakeye. Kewa Isolaiya sena kesale Piseikeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aputa: Yesuyewi selese, “Kewa i kalu mouwemi helapita: Neyewi papokeye. Alanase keyawa Newa himu semetei matanekeye. Alawamona Neyewi nano seya weyamowa koloteakeye. Sikape nano ketea sosolo nowa keyewi potaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aluse wa:ke Yesuyewi selese, “Neyewi heneye selakeye. Mekifala takalese kola:tese, takalese koya:sela:, Sena Sa:yawa Newa piseiwemi wapa:se falemi Kote hepene senawa inapola: mene hanapita: kiyewi potaposakeye,” aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ikiwapo a:ko: itapa tepela:, ikila osokemi sena nowamoke kesale tise tikinakeye. Kalili peleya: emi Kena taunewemi tikinakeye. Tikinisene koawemi Yesuyewi Ene e amawa hanapola: henekeye. ");
INSERT INTO khs_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aputa: Yesuwala, Ene sena ilipe hanosewana, ima sena pisili mina selapita: iwa hanapola: emi sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Aputa: sena kesale sopoke sita:neyawa waine hawa napela: kotetiyapita:, Yesu Ene yoyewi Ema selese, “Waine hawa iyewi sopoke napela: kotetikeye.” ");
INSERT INTO khs_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Au selapita: Yesuyewi E amama selese, “Ni amao, ko:lupita: keyawa Nema sela:? Ne okane a seta: hetetimakeye.” ");
INSERT INTO khs_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Au selapita: Yesuyewi E amayewi sena pisili tima:na: tisene senama selese, “Yesuyewi kima nano timita: selapitekiwa, semeteiwa kamunuse ta: tiyapola: tima:na: tiya:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Au selapita: potakamake hano wa:tesene etewa timiya tekapeipe talamo sosolo amuna sita:newa papokeye. Aputa: Yu sena tililayawa matanesekiwa, “Koteyewi nima epelemita: niyewi tiya:le selakolosekeye.” Aluse matanemita: tiya:le selakomita: etewa talamowemi semetei semetei talo oloipe litawa amuna hano wasu tiye koawemi tiye tikeye. ");
INSERT INTO khs_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Potapola: sena pisili tima:na: tisene senama, Yesuyewi selese, “Etewa talamo sosowa woliyetimita: hawa wasu tiye selama.” Au selapita: iyewi hawa wasu tiye selatiye woliyetikeye. ");
INSERT INTO khs_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Woliyetipela: potapola: Yesuyewi tima:na: tisene senama selese, “Etewa talamo sosolo emiwa hano ka:nawane, wasu tima sena tikina emi tikina pisili maita: wasu tiye ha:na:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Au selapita: iyewi wasu tiye hanapola:, sena tikina pisilima kinapita: eye menakeye. Hene hawa waine hano notoyawa eyewi eta: matanemakeye. Aputa: tima:na: tisene sena hano towayama iyewi semetei matanakeye. Sena pisili waine hawa na:sela: sena kesale napute tili e ko:luwa mina e seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Mina selapita: eyewi selese, “Niyewi alusewa wekeye. Waine hano hene heneye napolo noiyawa puwano sena kesale tikinawemi minama kinisekeye. Puwano miwa iyewi ili napita: potapola:, waine hano kolotea noiyawa sikape kinisekeye. Alawamona, keyewi waine hano kolotea noiyawa puwano kinatakeye. Heneye noiyawa sikape kinatakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aputa: senayewi matanemita: Yesuyewi Kote penaiyayewi matanepela: tisene puwanowa wekeye. Hene hawa waine hano notolomita: timiyakeye. Kalili peleya: emi Kena taunewemi Eyewi timiyakeye. E penaiya ho:liya sosolo amowa sena kesale sopoyawa popita: E penanose timiyakeye. Timinipitekiwa Ene sena ilipe hanoseyewi potapola: Ema himu semetei matanepela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aputa: tikina kekenepela: usuyetipela: Yesuwala, Yesu E amawana, E ma:ewana, Ewa sena ilipe hanosewana, iwa sopoke hanapola: Kapaneame taunewemi hanapola: ikilale mutamayewi eniya:sela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Koane Helepa:pe Matanema:na:pela: Tikina ikila amowa mapatopita:, Yesuwa Yelusaleme sitiwemi fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Fiyanapola: Kote koane solawa suwemi musuluyetiye potakamake senayewi kopolo kaowala, apula: a:pele sipiwala, apula: a:nema:wana wa:la:ya:sela: sitalapita: potapola:, sena noka tepolowemi ka:la:lopela:la: moweni senisila:sela: papokeye. ");
INSERT INTO khs_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Potapola: Yesuyewi mei kakiyewi sita:newa tiyapola:, kakili inapola:, kakili amoke senawana, ilipe kopowa kaowala, a:pele sipiwala Kote koane siliye minawa nesile hamonite sama:na: a:lakeye. Sama:na: a:pita: senayewi moweni senisila:sela: ka:la:lopela:ne amoke tepolowemi notoloyeti moweni usu sutiye iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sutiye iya:pela: sena a:nema: wa:la:ya:sela: sita:nema Yesuyewi selese, “A:nema: amowa tiye ha:na:pa:. Ni Ata koane weyamowa nano wa:la:losene koane amuna aupa.” ");
INSERT INTO khs_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aputa: ta:tapola: E sena ilipe hanoseyewi Kote pukawemi momateyawa matanakeye. Momateyawa wekeye. “Koteo, Ke koawa hene heneye napolo sopowa Neyewi matanekemiwa puwano matanekeye. Alanase, Neyewi tima:na:wa penanose koane weyamowa napolo temita: tiyakeye.” Aluse momateyawa Yesu E sena ilipe hanoseyewi matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Aputa: Yu sena tililayawa Yesuma selese, “Kewa ipa: alake alalole? Kewa puwano enewa niyewi popa:na:ke walopa:. Kote penaiyayewi matanese tima:na: tisewa keyawa tima:na: tiya:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Au selapita: Yesuyewi selese, “Kote koane weyamowa ekeyetiye ikila usulupe kotetipela: wa:ke Neyewi titima:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Au selapita: iyewi selese, “Koane weyamowa tiya:sela: sita:la: yapene talo pinipe epela: tekapeipe (46) itapa tepela: emi titilo. Alawamona noko:lu ikila usulupe yemi Keyawa koane we titiyaposele?” ");
INSERT INTO khs_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Au selapita: Yesuyewi Ene ho koawa Ene tomawa pale seya koane tima:na: seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aluse seyawa Yesu Ene kupula: tesile hapa ikila emiwa seya mouwa E sena ilipe hanoseyewi matanakeye. Ikila emiwa Kote pukawemi momateyawala Yesuyewi seyawala seli topukeye. ");
INSERT INTO khs_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Aputa: Koane Helepa:pe Matanema:na:pela: Tikina ikila emiwa Yesuwa Yelusaleme sitiwemi ela:, Kote penaiyayewi matanese tima:na: tisewa Eyewi timiyakeye. Timinipitekiwa sena kesale mutayewi potosekiwa Ema himu semetei matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Alawamona, senala: himuyewi matanawa Yesuyewi potose Eyewi ima himu semetei eta: matanemakeye. ");
INSERT INTO khs_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Sena matanawa sena nowamoke Yesuma selese eta: waiyamakeye. Yesu Ene Eyewi sena matanawa papokeye. ");
INSERT INTO khs_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yu sena semetei nowa unuwa Nikitimasekeye. Ene Yu sena tilila piseikipela: enewa ewa Felesi senakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nukulapo Yesu enewemi ewa inapola: selese, “Walosene sena, Kote Kewalapulu semetei enenase Keyewi Kote penaiyayewi matanese tisewa timiyanakeye. Alake nini walosene sena tepela: timita: Koteyewi hamona e seyawa Kewakeye. Aluse niye matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Au selapita: Yesuyewi selese, “Neyewi heneye selakeye. Sena wa:ke kesila maelaleke, sena amowa Kote piseikipela: potapola: maelaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Au selapita: Nikitimaseyewi selese, “Sena tililawa noko:lu wa:ke kesima:na:ne? Sala amuna mene tepela: e ama sulu fa:nemi wa:ke me kesima:na:wa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Au selapita: Yesuyewi selese, “Ho Napoyewi sena amowa wa:ke makesilisaleke, apula: hawemi matoliyetisaleke amunawa Kote piseikipela: pote ela senawanapulu mapapesakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sena kesaleyewi sala kesilisewa kapo, ki, fo, kesilisewa tomane akeye. Alawamona sena kesale i kene ho hili temita:, Ho Napolone akeye. ");
INSERT INTO khs_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Neyewi kema selese, ‘Kiwa wa:ke hili kesipela: sita:latipa:,’ au seyawane kewa ta:tapola: howa hanapa. ");
INSERT INTO khs_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Aputa: alopowa hanapita: kena:yewi semetei topukeye. Alawamona, siyewi eta: potesemakeye. Alopoyewi nano nowa popaselepita:, siyewi potosekeye. Alopo ko:lu inapo? Inapola: kami hanape? Au selesene amunuse sena kesale himu fa:nemi Ho Napolo elekiwa ewa tima:na: fa:ne tiseyane sena nowamoke potosekeye.” ");
INSERT INTO khs_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Au selapita: Nikitimaseyewi selese, “Keyewi epe selese amowa noko:lu hetetiyaposape? Newa tikili tekeye.” ");
INSERT INTO khs_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Au selapita: Yesuyewi selese, “Nikitimase, Isolaiya walosene sena kekeye. Kote pukawemi momateya mouwa keye se tiye kinisekeye. Alawamona Keyewi solo se tiye mouwa keye mamatanepa? ");
INSERT INTO khs_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Alamakeye, ta:ta:pa:. Neyewi kema heneye selakeye. Niyawa nano heneye matanawamoke semeteiwa selesekeye. Aputa: niyawa nano papolo semeteiwa selesekeye. Alawamona, seya amowa kiyawa eta: ta:tesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Peleya: weyemi nano ketea timinisewa Neyewi selapitekiwa kiyawa eta: ta: tisemakeye. Aputa: hepene falemi nano ketea timinisewa Neyewi selapitekiwa kiyawa ta: tiyaposelele? Alamakeye, ma ta:taposakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Alake hepene falemi nano ketea timinisewa potapose sena nowa hepene falemi hanapola:, peleya: weyemi selapose eta: minamakeye. Newa Nine semetei hepene emi tese inapola:, Sena Sa:yawa Newa peleya: weyemi selapose minakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Aputa: puwano moawemi Moseseyewi heseke amuna tese timini tiyapola: i kepela: heseke papela: tilise amunuse, Sena Sa:yawa Newa epapuluse papela: tilitaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Newa papita: sena kesale eta:wiye Newemi himu semetei matanepela: sita:latipe kamunuse kao sitalaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Alake peleya: sosolo we sena kesale sopoke sita:newa Koteyewi himu hapa sosolo matananase Ene E Sa:le semeteiwa kamona hamona seyakeye. Hamonapita: Ene E Sa:le minakeye. Inapita: sena kesale eta:wiye Ewemi himu semetei matanepela: sita:newa kokolo kao sitalaposakeye. Iwa maolokeyatepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kote Ene E Sa:yewi senala: falasima:na:pela: eta: minamakeye. Senala:wa mene silima:na:pela: hamona seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Aluse Kote E Sa:le sowa sena kesale eta:wiye ta:tiyapitekiwa iwa mafalasipesakeye. Alawamona Kote E Sa:le sowa ma seli ta:tiyapitekiwa, fala:sima:na:wa puwano kao ta:pele tiyapola: apoyakeye. Alake Kote Ene E Sa:le semeteiwa amoke E unuwa eta: seli ta:timanase fala:sima:na:wa puwano kao ta:pele tiyapola: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Falasima:na: mouwa wekeye. Ho:liya peleya: sosolo weyemi minakeye. Alawamona, ho:liya minawa sena kesaleyewi mapolose i kene olokeyatela tima:na:pela: yopolotela kemi sita: tesekeye. Sena kesaleyewi i kene olokeyatela timiyawa sena nowamoke popa:pekise ho:liya emiwa eta: inisemakeye. Ho:liyawa heneye mapolose, ho:liya emi sita:pesena:pela: eta: inisemakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Alawamona hene heneye seli tisene sena kesale amowa ho:liya emi sita:pesena:pela: inisekeye. Alake iyewi Kote sowa ta:tese kulu hanose timinise sita: tesewa sena sopoyawa popita: iwa ho:liya emi tima:na: tiya:sela: sita: tesekeye. ");
INSERT INTO khs_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aputa:, Yesu E sena ilipe hanosewanapulu Yutia peleya:wemi hapakeye. Emi hanose sita:la: iyewi sena kesalewa hawemi tolusulakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aputa: Ainone koamesa: Salime taunewemi pawemi, hano sosolo emi tenenase sena kesalewa inapitekiwa iwa Yoneyewi hawemi tolusulakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yoneyewi hawemi toliyeti opo emi ewa tipolo seta: selawapomakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aputa: Yu sena semetei nowamoke Yone e sena ilipe hanosene nokamawa nano olokeyatela itapa tema:na:pela: hawemi selakoma:na:pela: konomonose seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Konoma:pela:la: selapitekiwa Yone sena ilipe hanosene sopowa Yone enewemi inapola: selese, “Walosene sena, hano Yotane satepela: kewa enene fatemi sena minawa matanepa? Ewa inaposa isu sosowa seila:pa:na:pela: keye solo kinisekeye.” Au selapita: Yoneyewi, “Henekeye. Ewa neyewi matanekeye.” Au selapita: iyewi selese, “Sena amoke sena kesalewa noka hawemi toluyetiyakeye. Alake sena kesale sopoyawa kewa iya:pela: Ewamo Enewemi hanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Au selapita: Yoneyewi selese, “Koteyewi kinapita: semetei kamunuse senayewi tisekeye. Koteyewi makinisaleke senayewi eta: tisemakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Puwano neyewi selese, ‘Newa Kelesomakeye. Keleso mina:na: isuwa sosowa neyewi seila:pa:na:pela: newa puwano minakeye.’ Au seya neyewi seyawa kiyewi topukeye. ");
INSERT INTO khs_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Aputa: sena kesale semiwa sena nowamoke eta: tisemakeye. Kesale semiwa sena amoke ene eyewi tisekeye. Kesale tima:na: e seya sena amoke selapitekiwa ene e ma:eyewi ta:tese epelesekeye. Ene e ma:e epelesene amunuse newa sosolo epelese tima:na: tiya:sela: elakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yesuwa Ene sosolo tese wapilise epesena:keye. Newa kolotea epesena:keye.” Aluse Yoneyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Aputa: sena hepene falemi tese minawa ene hene heneye putupela: elakeye. Alawamona peleya: weyemi selati sena amowa ene peleya: nekeye. Ene peleya: weyemi nano ketea timinisewa selesekeye. ");
INSERT INTO khs_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Alake ewa hepene falemi tese minanase hepene falemi nano papowala, nano topuwala, eyewi selesekeye. Sowa sena nokamokiwa ma seli ta:tiyapitekiwa kemi, eyewi nano papowala topuwala kao selesekeye. ");
INSERT INTO khs_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Aputa: sena nokamokiwa e sowa ta: tiyapola: sita:la: selese, “Henekeye, Kote sowa henenakeye,” au selesekeye. ");
INSERT INTO khs_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Aputa: ewa Koteyewi hamonapita: inapola: Kote sowa se tiye kinakeye. Ho Napowa kolotea kolotea Koteyewi ema eta: mimakeye. Sosolo woliyetiye kinisekeye. ");
INSERT INTO khs_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ata Sosoyewi Ene E Sa:le amowa himu hapawa matanepela: ela:, Ene E Sa:le nano sopoke pota: epesita: ta:pele tiyapola: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Alake Kote Ene E Sa:le sowa sena kesaleyewi ta:tiyapitekiwa iwa Kotewalapulu kokolo kao sitalaposakeye. Alawamona, Kote E Sa:le sowa tikape tesaleke iwa Kotewalapulu kokolo kao masitalaposakeye. Ko:yawemiye, sena kesale amoke ta:ta: kolaiye tinase Kote kao konomonose epesena:keye. ");
INSERT INTO khs_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Sena kesale amowa Yesuyewi hawemi eta: toliyetimakeye. Alawamona Ene sena ilipe hanoseyewi hawemi tolusulakeye. Sena nokamoke potapola: selese, “Yesu kulu hanosene sena kesalewa mutawa Yesu Ene sena ilipe hanoseyewi hawemi toliyetiya:pa: au seyakeye. Alake Yesu kulu hanosene sena kesale amowa mutawa tekeye. Aputa: Yoneyewi hano toliyeti sena kesale amowa mutamakeye. Yesu sena kesale hano toliyeti amokiwa Yoneyewi sena kesale hano toliyetiya:pa: helete tiye hanakeye.” Aluse selapita: Felesi senayewi topukeye. Alake Yesuyewi matanese, “Neyewi nano timinisewa senayewi selapita: Felesi senama mikeye.” Aluse matanese Yesu Yutia peleya: iya:pela: Kalili peleya:wemi wa:ke meneye tiye ha:na:na:pela: ");
INSERT INTO khs_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","5","inapola: Samelia peleya: honosane hanapola: emi enekeye. Samelia peleya: honosane Saika taune emi elakeye. Saika taune pawemi peleya: amowa Yakopeyewi ene e sa:le Yosepema puwano fa:nemi mikeye. ");
INSERT INTO khs_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakopeyewi hano ka:mita: peleya: ta:la emi Yesuwa hanapola: henekeye. Opo honosanewemi E onatuyewi onapela: minanase Ewa hokopita: henekeye. ");
INSERT INTO khs_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Henewanapulu E sena ilipe hanoseyewi nano ma:na:wa wa:la:loma:na:pela: taunewemi hapakeye. Hanapita: Yesu enewemiwa Samelia kesale hano wa:tapose inapita: Yesuyewi selese, “Keyawa Newa hano wasu tiye miya:na:wa ililapa?” ");
INSERT INTO khs_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Au selapita: Samelia kesaleyewi matanese, “Yu sena Samelia sena elipe semetei eta: tesemakeye. Yu senayewi Samelia senawa asuwatapita:, aputa: Samelia senayewi Yu senawa asuwatapita: eta: asuwatesemakeye.” Aluse matanepela: kesaleyewi selese, “Ko:lupita: Keyawa nema hano wasu tiye tine e seleseye? Kewa Yu senakeye. Newa Samelia kesalekeye. Ko:lupita: Keyewi newa asuwapita: seleseye?” ");
INSERT INTO khs_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Au selapita: Yesuyewi kesalema selese, “Koteyewi nano ketea mokopo sosowala, keyawa matanese, apula: keyawa Newana potapola:, enekeye, aluse matanakiwa, keyawa Nema aluse eta: sema:na: telamakeye. Neyewi kema selese, ‘Newa hano wasu tiye tine,’ au selapitekiwa keyawa Newa potapola: matanakiwa keyawa Nema selese, ‘Newa hano wasu tiye tine,’ au sema:na: telakeye. Aputa: Neyewi kewa hano si fiyatela miya:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Au selapita: kesaleyewi selese, “Peleya: ta:lawa pama sininase wapa:na:wa Keyawa potolo itapalakeye. Hano siwa noko:lu wa:pa:na:ne? ");
INSERT INTO khs_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Niyewi tilila kouwa mei Yakopeyewi peleya: weyamowa ta:lakeye. Puwano fa:nemiwa ewalapulu ene salayawala ene a:pele sipiyawala peleya: ta:la hano ka:na semeteiwa menakeye. Yakope kulapita: e peleya:wala hano ta:lawala niyewi potapola: sitalakeye. Peleya: ina tilila kouwa mei Yakopewa sena koloteasula? Keyewi hano pa:ta si fiyatela heneye napolo miya:na: kewa kine semeteiwa sena puwanole? Yakopewa koloteasu eselele?” ");
INSERT INTO khs_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Au selapita: Yesuyewi selese, “Peleya: ta:la hano ka:nawane sena kesaleyewi menawa wa:kiwala ‘Hano ma:na:tepo,’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Alawamona, Neyewi hano wasu tiye kinapita: sena kesaleyewi na:sela: wa:ke, ‘Hano ma:na:tepo,’ elawa eta: sema:na:makeye. Neyewi hano epe kiniseya hano siwa epapuluse ke suwemi waluse fiyanaposakeye. Aluse kewa kokolo kao elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Au selapita: kesaleyewi selese, “Sena puwanowo, hano si fiyatelawa nema tine. Kinapita: wa:ke, “Hano ma:na:tepo,” elawa eta: sema:na:makeye. Aputa: wa:ke neyewi wa:tapose mahelepesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Au selapita: Yesuyewi selese, “Kine ke senawa siliyapola: ina:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Au selapita: kesaleyewi selese, “Ne senawa maelakeye.” Au selapita: Yesuyewi selese, “Heneye selakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Puwano sena pipe sopoyewi kewa tikeye. Alawamona, yemiwa sena kewawanapulu ela epa, kewa heneye sena eta: timakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Au selapita: kesaleyewi selese, “Sena puwanowo, neyewi alusewa keyawa matanese semeta: Kewa sepatosene senanakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kiwa Yu senayewi selese, ‘Yelusaleme sitiwemi Kotema wapilipa:.’ Alawamona, niyewi selese, ‘Nini tilila kouwa mei Samelia peleya: tokowemi hanapola: emi iyewi Kotema wapiyakeye.’” ");
INSERT INTO khs_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Au selapita: Yesuyewi selese, “Sikape epe hetetiseya ikila emiwa Ni Ata Sosoma wapilise Samelia peleya: tokomowala, Yelusaleme sitiwemiwana elipei semetei emiwa semetei mawapilipesakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ewa wapiyawa kiyewi Samelia sena kesaleyewi heneye napolo mamatanekeye. Yu sena maya emi kesilanase Ewa wapiyawa nini Yu senayewi matanekeye. Koiyawemiye, Koteye ela: niwa Yu sena tapelepela: sena kesale sopoke mene silimita: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Alawamona sikapewala yemiwana sena kesaleyewi tomayewi matanese wapilima:na:wa himuyewi Kotema heneye napolo matanepela: wapilipesakeye. Sena kesaleyewi hoyawana wapilipesakeye. Heneye matanepela: wapilisene sena kesale amowa Koteyawa epelesekeye. ");
INSERT INTO khs_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kotewa Ene hokeye. Honase Ewa wapilisene sena kesaleyewi hoyewi ela: wapilipa:. Apula:, himuyawala heneye seli matanese wapilipa:.” ");
INSERT INTO khs_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Au selapita: kesaleyewi selese, “Koteyewi Piseikipela: epesita: ta:peya sena Mesaiya inaposakeye. Amowa iye selese Kelesokeye. Aluse neyewi matanakeye. Ewa inisekiwa nano sopoke nima selaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Au selapita: Yesuyewi selese, “Keye epe selese amowa, Nekeye.” Au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aputa: Yesu sena ilipe hanosene mene inise potakamake Yesuyewi kesalema selapita: potapola:, howa hanose nano nowa eta: seyamakeye. “Ko:lupita: kesalema seleseye? Nano ena halosapeya:?” Alusewala iyewi eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Aputa: kesaleyewi ene potolowa iya:pela:, koamesa: kipila mene hanapola: sena kesalema selese, ");
INSERT INTO khs_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Neyewi puwano hela: nano ketea sopoke timiyawa senayewi nema selesapekeye. Puwano Eyewi newa eta: papoma amowa neyewi alusene sopowa selesapekeye. Ewa popa:na:ke mina. Kelesowa Ewamone?” ");
INSERT INTO khs_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aputa: sena kesaleyewi ili koamesa: iya:pela: Yesu elakemi popa:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yesu sena ilipe hanoseyewi Ema penanose selese, “Walosene sena, nano maiya.” ");
INSERT INTO khs_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Alawamona Yesuyewi selese, “Neyewi nano nasewa kiyawa mamataneselakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aputa: sena ilipe hanoseyewi i kene kemi selese, “Sena nowamoke nano ma:na:wa tiyapola: ine Ema kinisapele?” ");
INSERT INTO khs_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Au selapita: Yesuyewi selese, “Eyewi Newa hamone E matanawa Neyawa kulu hanose, Ene nano tima:na: tisewa Neyewi timini tiyapola: tiyapitekiwa Neyewi nano nasene amunawa epakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aputa: kiyewi selese, ‘Kunei pinipe itapa tepela: witi fo kenepita: supa:na:no.’ Apula: Neyewi selese, Alekenawa pota:pa:. Witi fo supita: yemiwa kenakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Witi fo sutakemiwa senayewi nano wa:la:ya hepe yemiwa tiseno. Witi fo sutakemiwa epapuluse sena Yesuwalapulu kokolo kao sita:pesita: siliyakeye. Witi fo kelesene senawana, apula: witi fo sutakemiwa senawana, elipei a:tewi epelepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Puwano sena nowamoke selese, ‘Sena nokamoke nano e sa:le keleseno. Aputa: sena nokamoke sutesinikeye.’ Aluse seyawa heneye sepapolakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aputa: sena nokamoke nano e sa:le fipipela: potapola: elapepela:, nano e sa:le fipilawa fiyanenapita: alekenawemi fowa heyawa kiyewi sutapola: Neyewi hamona e selakeye. Sena nokamoke hokolose timiya kamowa fo heyawa kiyewi sutusenekeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aluse Yesuyewi Ene sena ilipe hanosema pale sela:sela: enewemi kesaleyewi e koawemi selese, “Newa puwano hela: nano ketea sopoke timiyawa nema selesapekeye.” Au seyanase Samelia sena kesale mutayewi Yesuma himu semetei matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iyewi ili koamesa: iya:pela: Yesuwa enewemi inapola: selese, “Kewa nini koawemi eniya:sela: elapose mina.” Au selapita: Yesuwa ili koawemi hanapola: iwalapulu ikila elipei eniya:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Eniya:sela: ela: Eyewi solo kinapita: sena kesale muta nokamokiwala E seyawa seli topukeye. ");
INSERT INTO khs_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ta: tiyapola: kesalema iyewi selese, “Keye seya semetei ta:tapola: Ema himu semetei matanese eta: alamakeye. Yesuyewi Ene Ewala selapitekiwa ta:tapola: niyawa Ema himu semetei matanekeye. Eyewi sena kesale sopoke peleya: sosolo we sita:ne mene silima:na:pela: inatakeye, aluse niyewi matanekeye,” aluse iyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ikiwapo elipei itapa tepela:, Yesuyewi Saika koamesa: iya:pela: Kalili peleya: kemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Hanapola: Yesuyewi puwano imawa selese, “Kote solo kinisene sepatosene senayewi ene koamesa: sena semetei sita:ne amokiwala, ene koane enisewa sena semetei sita:ne amokiwala, ewa puwano eta: putulesemakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ala amowa Ewa Kalili peleya:wemi inapitekiwa potapola: Kalili senayewi Ewa timanenakeye. Puwano Koane Helepa:pe Matanema:na:pela: Tikina ikila emiwa iwa ilipe Yelusaleme sitiwemi hanapola: potakamake Yesuyewi nano ketea sopoke timinipita: papokeye. Paponase Yesuma timanenakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aputa: Kalili peleya: emiwa Kena taunewemi Yesuwa mene hapakeye. Puwano Kena taunewemi Eyewi hene hawa waine hano notoyakeye. Aputa: Kena taunewemi kamani piseiki e tima:na: tisene sena Kapaneame taune emi makene minakeye. Ene koawemi e sala nakola ka:pelalapita: iya:pela: Kena taunewemi makene minakeye. ");
INSERT INTO khs_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Makene inapola: ela ikila emiwa ta:takamake, Yesu Yutia peleya:wa iya:pela: Kalili peleya: weyemi mina e selapita: ta:tapola:, ewa Yesu enewemi inapola: selese, “Ne sena sa:wa sosolo nakola kuma:na: telakeye. Sala amowa itapa tepa:se Kapaneame taunewemi mina.” ");
INSERT INTO khs_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Au selapita: Yesuyewi selese, “Kote penaiyayewi matanepela: timinisene mapotapitekiwa kiyawa Nema himu semetei mamatanepesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Aputa: kamani piseiki e tima:na: tisene senayewi selese, “Sena puwanowo, Ni sa:wa kuma:pikitise ne koawemi mina.” ");
INSERT INTO khs_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Au selapita: Yesuyewi selese, “Kewa ha:na:pa:. Ke sa:wa napolo elakeye.” Aputa: solo amowa kamani piseiki senayewi ta: tiyapola: ene koawemi hanapola: ");
INSERT INTO khs_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","isu kiwemi inakamakiwa, e tima:na: tisene sena noka iyewi ewa ko:luye tise selese, “Ke salawa fala:pekeye. Napolo elakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Au selapita: kamani piseiki e tima:na: tisene senayewi selese, “Fala:lawa oposi asuwemi fala:lale?” Au selapita: iyewi selese, “Eli ka:lewemi oposi akele e toma ofolawa itapa telakeye.” ");
INSERT INTO khs_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aputa: salawa ene e atayewi matanese, “Eli ka:lewemi oposi akele Yesuyewi selese, ‘Ke sa:wa napolo elakeye.’ Ala ikila emiwa toma ofolawa kotetikeye.” Aluse matanepela: ene ewala ene ekewala, ene salayawala, ili i kene sopoke Yesuma himu semetei matanepela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Alake Yesu Yutia peleya:wemi iya:pela: Kalili peleya:wemi mene mina ikila emiwa, sala fala:pe amowa Kote penaiyayewi matanese tisene ikila elipei amowa epakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kolotea elapepela: Yu senayewi Kotema wapilima:na:pela: tikinakeye. Tikina ikila emiwa Yesu Yelusaleme sitiwemi fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yelusaleme sitiwemi etewayewi sola isu muta hotawayakeye. Isu semetei hota:pe nowa unuwapo A:pele Sipi Isu Hota:pekeye. Aputa: isu hota:pewa pawemi hano si elakeye. Yu sena Hipulu solopela:la: hano si amowa unuwapo Peteseita unuwapokeye. Hano si hano hema wasa kolotea pipe tiwemi emi sena muta nakola towaya tuwapolo teselakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Emi tesewa sena noka si kolawala, sena noka onatu olokeyatelawala, sena noka olale telawala iwa falopela:la: teselakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tuwapowane potakamake Piseiki hepene sena inapola: hano si iminanapita:, sena nakola towaya falopela: semetei nowa puwano hanapola:, hawa iminanapita: hano mutakamake ene nakolawa kotetiyapita: esekeye. ");
INSERT INTO khs_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Alusenase sena semetei nowa yapene talo usulupe apula: oloipe (38) nakola ela:, wasa kolotea ka:pelalapita:, ");
INSERT INTO khs_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesuyewi potapola: matanese, “Sena epamowa ikila sosoyewi nakola enekeye.” Aluse matanese Yesuyewi sena ama selese, “Kewa nakolawa itapa temita: matanepa?” ");
INSERT INTO khs_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Au selapita: senayewi selese, “Hano imina epa ikila emiwa newa hawemi ha:na:na:pela: elawamona, sena nowamoke newa hawemi tiyapola: eta: hapamakeye. Newa tiyapola: mahanosaleke halute hanose enewemi, sena nowa puwano hanapola: hawemi mupe e seyakeye.” ");
INSERT INTO khs_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Au selapita: Yesuyewi selese, “Kewa tesima. Ke keatawa kopo tiyapola: ha:na:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Au selakamake sena amowa ela:pe itapa tepela: tesile ene keatawa kopo tiyapola: hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ha:le tesene ikila emiwa sena amoke keatawa tiyapola: hanapitekiwa, Yu sena tilila piseiki sopoyewi sena nakola itapa tela ema selese, “Napu ha:le tesene ikilakeye. Ha:le tesene ikila emiwa keatawa tiyapola: hanapa. Aluse puwano solo elewa tuwapolapo.” ");
INSERT INTO khs_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Au selapita: senayewi selese “Sena newa fala:pe amoke selese, ‘Kine keatawa tiyapola: ha:na:pa:,’ au seyakeye.” ");
INSERT INTO khs_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Au selapita: iyewi selese, “Keatawa tiyapola: hamona e seyawa sena etewi aluse selesapeye?” ");
INSERT INTO khs_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Alawamona sena kesale muta kekenawemi Yesu musuluyetiye hapakeye. Hanapita: sena nakola fala:peyawa selese, “Sena epamowa ipei. Newa tikili tekeye. Ewa hapalakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aluse kolotea elapepela: Yesuwa Kote koawemi sila:sela: ela:, Eyewi sena fala:pewa potapola: selese, “Ke nakolawa itapalapo. Nano olokeyatela timinisewa wa:ke timinipa. Nano hilila sosolotema:pekitise mane olokeyatelawa heneye iya:ta:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Au selapita: sena amowa hanapola: Yu sena tilila sopoma selese, “Yesuyewi newa fala:pekeye.” ");
INSERT INTO khs_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Aputa: iyewi matanese ha:le tesene ikila emiwa Yesuyewi sena nakola towayawa fala:wayakeye. Aluse matanemita: iyewi Yesuwa ikomonakeye. Yesuyewi ha:le tesene ikila emiwa timiyanase iyewi Yesuwa kotolakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iyewi kotopita: Yesuyewi selese, “Ikila sopoke Ni Atayewi tiya:sela: elakeye. Neyawana tiya:sela: elakeye.” ");
INSERT INTO khs_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Au seya selapitekiwa Yu sena tilila sopoyewi, “Yesuwa sana kulaposakeye,” aluse matanakeye. Ha:le tesene ikila ala:pewa Yesuyewi iya:pela:, apula: Eyewi selese, “Kotewa Nine Ni Atakeye.” Au seya Yesuyewi Ene ela: tili tise, Newa Kote epapulakeye au selakeye. Alanase Yesuwa sana kulaposakeye, aluse Yu sena tilila sopoyewi matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yu sena tilila sopoyewi Yesuma kotopita: Yesuyewi ima solo mene selese, “Neyewi kima heneye selakeye. Newa Kote e Sa:nase, Neyewi Nine matanawamunuse eta: tisemakeye. Nine Ni Atayewi timinisewa potapola: semetei kamunuse timinisekeye. Nine Ni Atayewi timinisene amunuse, Neyawana semetei kamunuse timiyanakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ni Atayewi himu hapawa Newa matanese Ene Ewa nano ketea timinisene sopowa Nema walokeye. Waiyawa sitiyetiye nano ketea sosolo nowa waloma:na:keye. Walopita: Neyewi nano ketea sosowa timinima:na:keye. Timinipitekiwa kiyewi potapola: selese, ‘Uo, heneye timinipesapo,’ au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aputa: Ni Atayewi sena kuluwa mene tesilapola: fala:la kao tesewa kina amunuse, Neyawana amunuse fala:la kao tesewa miya:na:keye. Neyewi Nine matanawa sena ta:peyama fala:la kao tesewa miya:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aputa: Ni Atayewi sena kesalewa falasipela: eta: kotosemakeye. Eyewi Ene E Sa:le Nema selese, ‘Sena kesalewa fala:sima:na:wa Keyawa kotopa:,’ au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Au seyanase senayewi Kote sosolo amunuse Kote Ene E Sa:wa solomita:, ‘Keyewi kotopa:,’ aluse Kote Ene E Sa:le ta:pele tiyapola: apoyakeye. Senayewi Kote E Sa:wa mawapilisaleke, E Sa:le hamona seya amo Ene Ata Kotewala mawapilipesakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Alamakeye, ta:ta:pa:. Neyewi kima heneye selakeye. Ne solo amowa sena kesaleyewi ta: tiyapola:, aputa: Newa hamona seya amawa himu semetei matanepela: sita: tesene sena kesale amowa kao sita:la: maitapa tepesakeye. Iwa kotopela: mafalasipesakeye. Kuma:na:wa itapa tepela: fala:la tesene tapowemi sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Alamakeye, ta:ta:pa:. Neyewi heneye selakeye. Sena kesaleyewi Kotema himu semetei eta: matanama elaleke kulu epapula sitalakeye. Sena kesale kulu epapula sita:ne amo Ne sowa ta:tapola: kulu hanosaleke, sikape mene teisa:pa:na: ikila emiwa iwa kokolo kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kokolo kao tesene mouwa Nine Ni Atakeye. Nine Ni Atayewi kokolo kao tesewa Ene E Sa:le Nema mikeye. Minase kokolo kao tesene mouwa Newanapokeye. ");
INSERT INTO khs_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sena Sa:wa Nekeye. Alanase kotola ikila emiwa senawa takalemita: Ni Atayewi Ene E Sa:le Newa ta:pele tiyapola: apoyakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Titolupa. Sikape sena kesale sopoke kuluwa peleya: tikila amokiwa, iyewi sopoke Ne sowa ta:tapola:, ");
INSERT INTO khs_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","peleya: tikilawa iya:pela: mene tesa: waloma:na:keye. Sena kesale a potala sita:ne ikila emiwa seli sita:ne sena kesale amowa mene tesa: walopita: ima Neyewi selese, ‘Newalapulu kokolo kao epese,’ au selaposakeye. Alawamona sena kesale a potala sita:ne ikila emiwa olokeyale timiya:sela: sita:ne sena kesale amowa mene tesa: walopita: ima Neyewi selese, ‘Kiwa falasisewa Neyewi tuwatakeye,’ au selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aputa: Yesuyewi selese, “Neyewi Nine matanawa Neyewi kulu hanose eta: tisemakeye. Koteyewi, ‘Aluse kotopa:,’ au selesaleke Neyewi epapuluse kotoma:na:keye. Eyewi Newa hamone E matanawa epapuluse Neyawana aluse matanese timinisekeye. Ne matana amowa me sikape apoyakeye. Alanase Neyewi napolo hekeya kotopela: hekelesekeye. ");
INSERT INTO khs_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nine Neye alusewa Nine Neye ela: selakamakiwa eta: ilimanakeye. Nine Neye alusewa Nine Neye semetei selapitekiwa kiyawa pateya selakeye, au selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Alawamona, Kote Ene wikinisi pa:ta nowa ela:, Neyewi alusewa selaposakeye. Newa alusewa Koteyewi selapita: Eyewi heneye selesekeye, aluse Neyewi matanekeye. ");
INSERT INTO khs_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Puwano Yu sena tilila eneno sena nokama selese, ‘Yoneyewi solo mouwa ta:tapose ha:na:pa:.’ Au selapita: Yone enewemi iyewi ta:tapose hapakeye. Hanapola: Yone enewemi inapita: Yoneyewi Newamo heneye seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yone solo amowa Neyewi ta:pita: Yoneyewi eta: seyamakeye. Kiyewi ta:pita: Yoneyewi seyakeye. Alanase kiwa mene silima:na:pela: Neyewi kima matanese selakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Aputa: nafa ho:lulusene epapuluse, Yoneyewi seila:pa:na:pela: inapola: solo minase, nafa ho:lulusene epapuluse ho:liyakeye. Ho:liya emiwa kiwa ikila koloteawemi sita:la: eye solo amowa epelese topukeye. ");
INSERT INTO khs_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Aputa: Neyewi nano okemiwa Yoneyewi seyawa heletakeye. Alanase Nine Ni Atayewi timinisewa Nine penanose timinipita: kiyewi potapola: matanese, ‘Ewa Koteye hamone.’ Aluse kiyawa matanemita: timiyanakeye. Timinipitekiwa Koteyewi Newa hamona e seyawa kima walokeye. ");
INSERT INTO khs_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aputa: Ni Atawala Neye alusewa potapola: walokeye. Eyewi Ene Newa hamone Neye alusewa selakeye. Selapita: E sowa kiyewi mata:teselakeye. E mitiwa kiyewi mapotoselakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Eyewi hamonapitekiwa mina sena amawa kiyewi himu semetei mamataneselakeye. Eta: matanamanase Eyewi hamone sowala kiyewi mamataneselakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kokolo kao sita:pesena:pela: kiyewi Kote pukawemi momateyawa keyalapepela: akelesekeye. Kote pukawemi momateya amo Newamo walose selakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Selapita: kemi kokolo kao sita:pesena:pela: Newa elakemi kiwa mainiselakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Kili himuwa Neyewi potakeye. Potakamake kiyawa Kotema himu hapawa eta: matanamanase potakeye. Alanase kiyawa Nema wapilisewala, kolotea meapolosewala, amowa mokopo nano ketea epapulakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aputa: Nine Ni Atayewi matanawa Neyewi kulu hanose, Ene unuwemi Newa minakeye. Newa minawa kiyewi fa:se walokeye. Alawamona sena nowamoke ewa ene matanawa me solose tima:na: tiye inisaleke, ewa ene unuwa tilitapita: ema kiyawa nekanesekeye. ");
INSERT INTO khs_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Senayewi kima potapola: selese, ‘Sena amowa napokeye,’ au semita: kiyewi i kene kemi tomayewi tiyatakeye. Alawamona Koteyewi kiwa potosekiwa, ‘Sena amowa napokeye,’ au semita: kiyewi eta: tisemakeye. Matiyapitekiwa Kote sowala kiyewi eta: ta: tima:na:manakeye. Kote Ene semeteikeye. Kote nowa maelakeye. ");
INSERT INTO khs_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","47","Kiyewi selese, ‘Niyewi Moseseyewi solo elewa kulu hanose sitalapita: Koteyewi niwa mene silima:na:keye.’ Aluse matanesewa mokopo matanekeye. Puwano Moseseyewi Newamo momateyakeye. Momateyawa kiyewi ta:ti e seyakiwa, Ne sowala ta: timapekeye. E sowa kiyewi heneye eta: seli ta:timanase Ne sowala ma ta:taposakeye. E sowa eta: ta:timanase Eyewi kiwa siliyapola: Kotema kotopesakeye. Neyewi kiwa siliyapola: Atama eta: kotoma:na:makeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Koane Helepa:pe Matanema:na:pela: Tikina kekena ikilawa mapatopita:, Yesuwa mene hanapola:, hano Kalili satepela: nono fa:nemi hapakeye. Hano Kalili amowa unuwapowa nowa hano Taipililasekeye. Sena kesalewa nakola towayawa Yesuyewi fala:tapita: sena kesale mutayewi paponase Ewa kulu hanose inapita:, Yesuwa tokowemi fiyanapola: E sena ilipe hanosewanapulu ka:la:lopela:la: ");
INSERT INTO khs_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","potakamake, sena kesale muta inapita: potapola: Filipima Yesuyewi selese, “Sena kesale sopoke ma:na: ma:na:wa niyewi kami wa:la:loma:na:ne?” ");
INSERT INTO khs_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aluse Filipiwa toma popa:na:pela: Yesuyewi seyakeye. Alake Yesuyewi Ene auma:na:wa matanepela: elakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ta:tapita: Filipiyewi selese, “Sena kesale mutawemi iyewi sopoyawa kolotea maita: silifa moweni usu sakopo elipei (200) eta: wa:la:loma:na: telamanapo.” ");
INSERT INTO khs_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aputa: sena ilipe hanosene semetei nowa Saimone Pita e ma:ewa A:nituluyewi selese, ");
INSERT INTO khs_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Sena sala nowamoke Pali falawa towapo koleya pipe, apula: ewalo elipei aluse telakeye. Alake sena mutawemi ili eta: ma:na: telamakeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Au selapita: Yesuyewi sena ilipe hanosema selese, “Sena kesale sopoke ka:la:lomei.” Au selapita: hutiya enenase emi ka:la:lopela:nekeye. Sena emi ka:la:lopela:ne sopowa akeyawa taosene pipe (5,000) aluse akeyakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Aputa: Yesuyewi falawa tiyapola: Kotema napolo esa: kulukulupela: elepela: sena ka:la:yama mikeye. Ewalowala tiyapola: Kotema napolo esa: kulukulupela: elepela: sena ka:la:yama mikeye. Kinapita: sena ilipe hanoseyewi mikeye. Kinapita: sena sopoyewi iliye tiye menakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ili tiyapola: napita: sena ilipe hanosema Yesuyewi selese, “Falawa napela: iliye tiyapita: noka kemi teselapita: time. Mokopo mowa iya:tapa.” ");
INSERT INTO khs_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Au selapita: iwa hanapola: Pali falawa towapo kemi teselapita: tiyapola:, elale kukuluipe sopowemi selatiye woliyetiye tiye tikeye. ");
INSERT INTO khs_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Aputa: falawa mutama pipe sopoke Yesuyewi solo se aluse, Kote penaiyayewi matanepela: tisewa tiyapita: senayewi potapola: selese, “Sepatosene sena sosolo peleya: weyemi mina:na: seyawa ewalakeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aputa: Yesuyewi matanese, “Sena kesale sopoke Newa tiyapola: Lome kamani sena amowa sitiyetiye Piseikipela: pote epesita: apoma:na:pela: matane hanatakeye.” Aluse Yesuyewi matanese iyewi auma:pekitise Ene Enapotane tokowemi fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka:lewemi opo sinakemiwa Yesu E sena ilipe hanosewa hano Kalili hanapola:, ");
INSERT INTO khs_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","potiwa tapela: Kapaneame taune nono fa:nemi mene ha:na:na:pela:, potiwa kolo tiye hanose sita:nekeye. Potiwa kolo tiye hanose sita:la:kasele mowa yopoyakeye. Yopolotelawemi Yesuwa mainapita: potiwa kolo tiye hanose sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kolo tiye hanose sita:la: alopowa hano ko:luwalapulu sosolo minakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Inapita: hano honosane kolo tiye hanose sita:la: potakamake potiwa hekeyawemi Yesu hano wapa:kemi onane inapita: potapola:, iwa sosolo ipilise sosolo kete matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Alawamona, Yesuyewi ima selese, “Nekeye. Ipipa.” ");
INSERT INTO khs_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Au selapita: iyewi selese, “Henekeye, potiwemi tame.” Apula: Yesuwa potiwemi tapita: potakamake poti amowa hano hema nono fa:nemi kipila hetetiyapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kiapowemi ikiwatapita: sena kesaleyewi meneye tiye sita:newa matanese, “Potiwa semetei koma:peya Yesu sena ilipe hanosewa tapela: hapakeye, alawamona, Yesu iwalapulu ilipe tapela: eta: hapamakeye. Yesu ko:yawamunane?” Aluse matanepela: ");
INSERT INTO khs_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","potakamake poti noka Tapiliase taune emi inapola: koma:peyawa papokeye. Aputa: Piseiki Yesuyawa falawawala, ewawala, Kotema napolo esa: selese, nano iliye tiye mena peleya: amowa mapatopita: potiwa noka koma:pelapita: papokeye. ");
INSERT INTO khs_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Aputa: iyewi Yesuwala E sena ilipe hanosewala kelekamakewa itapalapita: potapola:, poti koma:peya emi iwa tapela:, iyewi Yesu keye Kapaneame taune nono fa:nemi kolo tiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Aputa: senayewi poti kolo tiye hanose nono fa:nemi hanapola: iyewi Yesuwa keyalapepela: potose selese, “Walosene sena, Kewa asu minana?” ");
INSERT INTO khs_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Au selapita: Yesuyewi selese, “Neyewi heneye selakeye. Kiyawa falawa iliye tiye menanase kiyawa Newa keye inatakeye. Ne Kote penaiyayewi matanepela: timinisewa timinipitekiwa kiyawa potapola: matanese keye minamanapo. ");
INSERT INTO khs_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Peleya: weyemi ma:ne nasewa po:supesakeye. Ma:ne amopela: timinipa. Alawamona, kiwa kokolo kao tesene ma:ne nasewa tima:na:pela tiya:pa:. Ma:ne nasewa Neyewi kima miya:na:keye. Sena Sa:wa Nekeye. Kokolo kao tesene ma:ne nasewa kima miya:na:keye. Mite Nine Ni Ata Kote Ene ela: Newa ta:pele tiyapola: apoyakeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Au selapita: iyewi selese, “Koteyewi nano ketea timinisewa niyewi ena timinima:na:ne? Koteyewi nano ketea ena epelesene?” ");
INSERT INTO khs_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Au selapita: Yesuyewi selese, “Kote nano ketea timinisene epelesewa wekeye. Koteyewi Ewa hamonapita: mina Sena amawa himu semetei matanepela: sita:latipa:.” ");
INSERT INTO khs_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Au selapita: iyewi Ema ta:potose, “Niyawa Kema matanemita: Keyawa nano ena penana:pela: timinima:na:napa? Niyewi Kema himu semetei epesena:pela:, Keyewi Kote penaiyayewi matanese tisewa Keyewi matiminima. ");
INSERT INTO khs_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Puwano fa:nemi moawemi ma:ne nasewa sululuwalupita: niyewi tilila nini kouwayewi menakeye. Kote pukawemi momatelese, ‘Hepene falemi tese Eyewi ma:ne ma:na: mikeye.’ Aluse momateyawa niyewi akeyakeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Au selapita: Yesuyewi selese, “Neyewi heneye selakeye. Hepene falemi tese ma:ne nasene miwane Moseseyewi mimakeye. Alawamona yemiwa hepene falemi tese heneye ma:ne nasewa Nine Ni Atayewi kinisekeye. ");
INSERT INTO khs_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Alake Kote heneye ma:ne nasewa kinaka Ewa hepene falemi tese inapita: peleya: weyemi sena kesale sopoma kokolo kao tesewa kinisekeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Au selapita: iyewi selese, “Sena puwanowo, ma:ne nasewa nima kokolo kao kinise elatipa:.” ");
INSERT INTO khs_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Au selapita: Yesuyewi selese, “Heneye kokolo kao epesene ma:ne nasewa Nekeye. Nema himu semetei matanepela: sita:laleke, wa:ke ‘meinipe,’ elawa maselaposakeye. Ne sowa ta: tiyapola: sita:laleke, ‘hano ma:na:tepo,’ elawa maselaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kiyawa Newa potapola:, potose aluse kiyawa Newemi himu semetei mamataneselakeye. Mamatanepita: Neyewi kima selese akeye. ");
INSERT INTO khs_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Sena kesale sopowa Nine Ni Atayewi Nema kinapita:, iwa Newamo elakemi inaposakeye. Inapita: ima Neyewi inapa elawa eta: sema:na:makeye. ");
INSERT INTO khs_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Newa Nine matanawa tima:na:pela: hepene falemi eta: minamakeye. Alawamona, Nine Ni Atayewi Newa hamone matanawa Neyewi tima:na:pela: minakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nine Ni Atayewi Newa hamona seyakeye. E matanawa wekeye. Sena kesalewa Eyewi Nema miwane, semeteiwala hele kelema:pekitise, sopoke Neyewi maiya:taposakeye. Itapa tela ikila emiwa iwa Neyewi mene tesi timita:, aluse Koteyewi matanepela: selese apoyakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Alake Nine Ni Atayewi matanawa wekeye. Sena kesale eta:wiye Kote E Sa:le Newa potose selese, ‘Ewa Kote E Sa:keye,’ aluse selese, iyewi Kote E Sa:le Newemi himu semetei matanepela: sitalapita:, kokolo kao tesewa tiyaposakeye. Alake itapa tema:na: ikila emiwa iwa Neyewi mene tesima:na:keye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Au seya selapitekiwa Yu sena tilila sopoyawa ta:tapola: mapoyakeye. Ko:yawemiye, Yesuyewi selese, “Hepene falemi tese mina ma:ne nasewa Nekeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mapolose selese, “Sena amowa Yesukeye. Ene Yosepe E sa:keye. Ene e atawa ene e amawa niyawa potosekeye. Ko:luse hepene falemi tese mina e seleseye?” ");
INSERT INTO khs_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Au selapita: Yesuyewi selese, “Kiyawa i kene sopolo mapolose selapa. ");
INSERT INTO khs_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Senayewi matanese, ‘Newa Yesuma himu semetei matanepela: epesena:keye,’ aluse matanesene amowa Nine Ni Atayewi ema kinapita:, sena amoke Newa kulu hanaposakeye. Kulu hanosaleke, itapa tema:na: ikila emiwa sena amowa Neyewi mene tesima:na:keye. Aputa: senayewi Nema himu semetei matanesewa Nine Ni Atayewi sena amawa makinisaleke sena amokiwa Newa kulu mahanaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Aputa: sepatosene sena sopoyewi momatelese, ‘Sena sopoke matane timita: Koteyewi waloma:na:keye,’ aluse momateyalakeye. Alake Ni Ata sowa sena kesaleyewi ta: tiyapola:, Newemi sita:pesena:pela: amuna tese, Newemi himu semetei matanepela: kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Aputa: Kote peleya: emi tese mina Sena semeteiyewi Ni Ata amowa papokeye. Sena nowamoke Ni Ata amowa eta: papomakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Neyewi heneye selakeye. Ta:tesene sena kesale amowa Kotewalapulu kokolo kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kokolo kao tesene ma:ne nasewa Nekeye. ");
INSERT INTO khs_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Puwano fa:nemi mowa peleya:wemi ma:ne nasewa kili tilila kouwa meiyewi na:sela:, kolotea sitalapepela:, sikape kulukeye. ");
INSERT INTO khs_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Alawamona, hepene falemi tese ma:ne nasene minawa kiyewi tiyapola: napita: kokolo kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kokolo kao tesene ma:ne nasene hepene falemi tese minawa Nekeye. Ma:ne nasene amowa sena kesaleyewi napita: kokolo kao sitalaposakeye. Sena kesale sopoke kokolo kao sita:pesita: ma:ne nasene miya:na:wa Ne tomakeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Au selapita: Yu sena tilila sopoyewi ta:tapola: i kene konomonose selese, “Niyewi maita: E toma nima noko:lu miya:na:na?” ");
INSERT INTO khs_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Au selapita: Yesuyewi imawa selese, “Neyewi kima heneye selakeye. Newa Sena Sa:wa ela:, Ne tomawa Ne pepetawa kiyewi ma nasaleke, kokolo kao tesewa ke suwemi ma:ta: timakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ne tomawa, Ne pepetawa, sena kesaleyewi na:sela:, kokolo kao tesewa ke suwemi ma:ta: tiye apoya akeye. Itapa tela ikila emiwa Neyewi kiwa mene tesilapola: kokolo kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ma:ne nasene henewa Ne tomakeye. Hano nasene henewa Ne pepetakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ne tomawana, Ne pepetawala napita:, kewa Ne suwemi elakeye. Newana ke suwemi elakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ni Atayewi Newa hamonapita: inapola:, E penaiyayewi Neyewi opola:la: penaiya elakeye. Aluse kiyawala Newa napita: Ne penaiyayewi kiyawa opola:la: penaiya sitalakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Heneye ma:ne nasene hepene falemi tese minawa Nekeye. Sena kesaleyewi napita: Kotewalapulu kokolo kao sitalaposakeye. Alawamona ma:ne nasene kili tilila kouwa meiyewi menawa semetei amakeye. Ma:ne amowa iyewi napela: sitalapepela: kulukeye. Alawamona hepene falemi tese mina ma:ne nasene amowa napita: Kotewalapulu kokolo kao sitalaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Au seya Kapaneame Yu sena kekenesene koawemi Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aputa: Yesuyewi selapita: Ewamo kulu hanosene sena mutayewi ta:tapola: selese, “Sowa hililalakeye. Ko:luse ta: tiyaposelele?” ");
INSERT INTO khs_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Alawamoma ili himu matanawa Yesuyewi potapola: selese, “Ko:lupita: kiwa mapolose sita:la:? ");
INSERT INTO khs_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Newa Sena Sa:wa inapola: elapepela:, puwano enewemi peleya: epemi mene hanapita: kiyawa potapola: ena matanema:na:na? ");
INSERT INTO khs_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Aputa: Kotewalapulu kokolo kao sita:pesena:wa Ho Napoyewi kinisekeye. Sena tomayewi penaiyawamoke eta: kinisemakeye. Neyewi epe seleseya weyamowa Ho Napoyewi penaiyawana, kokolo kao sita:pesenenase penaiyawana seya epakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Aluse selapita: kiyawa nokamoke ta:tese topuwamona, eta: seli ta:tesemakeye.” Aluse Yesuyewi seyakeye. Aputa: ma:ta: ti ikila emiwa Yesuyewi sena sopoke potapola: matanese, “Eta: seli ta:tima sena amowa akeye. Newa sihelelema:na: sena amowa akeye.” Aluse matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Me wa:ke Yesuyewi selese, “Nema himu semetei matanepela: elaposakeye. Aluse matanesewa Koteyewi makinisaleke sena amokiwa Nema himu semetei matanepela: maelaposakeye. Aluse Neyewi seya akeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Au seya Yesuyewi selapitekiwa, Ewalapulu sena ilipe hanosene mutayewi Ewa iya:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iya:pela: hanapita: Yesuyewi Ene sena ilipe hanosene kukuluipe sopoma selese, “Kiyawala Newa iya:pa:na:napa?” ");
INSERT INTO khs_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Au selapita: Saimone Pitayewi selese, “Piseiki, nowa itapa niwa hanaposapele? Kokolo kao tesene mouwa Keyewi se tiye kinatakeye. ");
INSERT INTO khs_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Se Tiye kinapita: niyewi ta:tesekeye. Kewa Kote E Sa:le ta:pele tiyapola: hamona seyakeye. Nano olokeyatelawa takala:pela: napolo sopolo tesewa Kekeye. Aluse niyewi matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Au selapita: Yesuyewi selese, “Kiwa sena kukuluipe amowa Neyewi ta:peyakeye. Semetei kukuwa Seteneyewi sena mayakeye.” ");
INSERT INTO khs_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aluse Isekeleote sena Saimoneyewi e sa:le Yutasewa Yesuyewi seyakeye. Sena ilipe hanosene semetei kukuwa Yutasekeye. Yesu Ene Ewa sihelelema:na:wa seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aputa:, Yesu Kalili peleya: sila:sela: elapepela:, ko:yawemiye, Yutia peleya: emi Yu sena tilila sita:newa selese, “Yesuwa sana kulaposakeye,” auma:pekitise Yesuwa Yutia peleya: emiwa eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Puwano fa:nemi Koane Kolotea Titiyapola: Sita:ne ikilawa Yu sena kesaleyewi Matanema:na:pela: Tikina telakeye. Tikina selama:na:pela: pa tepita: ");
INSERT INTO khs_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesu Ene E ma:yewi Ema selese, “Kewa kulu hanosene sena kesale Yutia peleya:wemi sitalakamokiwa Keye penanose tima:na: tisewa popita:, peleya: weyamowa iya:pela: Yutia peleya: emi ha:na:pa:. ");
INSERT INTO khs_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Senayewi wapilise epesena:pelekiwa e nano ketea timinisewa mupapola:la: eta: tisemakeye. Sena kesale sopoyewi popita: hokatolose timinisekeye. Alake Keye penanose tima:na: tisewa sena kesale sopoyewi potapola: Kema himu semetei matanemita: tima:na: tiya:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aluse Ene E ma:yewi Yesuma himu semetei eta: matanemakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aluse selapita: Yesuyewi selese, “Sena kesale sopoke popita: nano ketea tima:na: tima:na: ikila amowa napu weyamakeye. Ikila sopoke kiyawa hanakamakiwa ililakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yemiwala sikapewala kiyawa tima:na: tisewa senayewi potosekiwa mamapolopesakeye. Nema semetei mapoloselakeye. Koiyawemiye, Neyewi hokato selese, ‘Kiyawa olokeyatela timiyanakeye.’ Au selapita: senayewi Nema mapoyalakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kiwa kilipe tikina kekenema:na: ha:na:pa:. Yemiwa Newa mahanaposakeye. Napu kili opolakeye. Ne ikilawa a seta: hetetimakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Au seya Ewa Kalili peleya: emi ke enekeye. ");
INSERT INTO khs_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Alawamona, Yesuyewi Ene e ma:ewa puwano Yelusaleme sitiwemi hanapita:, Yesuwa kolotea pote elapepela:, sikape sena kesale sopoke popa:pekise Ewa o:sulu sikape halute halute hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aputa: Yelusaleme sitiwemi Yu sena tilila nokamoke selese, “Yesuwa ko:yale?” aluse tikina kekena koane keye hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Aputa: sena noka kekenepela: i kene sopolo o:sulu selese, “Yesuwa Ene sena napolakeye.” Alawamona sena nokamoke selese, “Alamakeye. E sena kesale isu hele hamonite siliye walokeye.” Aluse sena mutayewi o:sulu sowa sepapokeye. ");
INSERT INTO khs_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sowa sepapola: o:sulu seyawane Yu sena tililayawa ta:tapola: kotoma:pekitise iyewi unuwapo hokatolose eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Alawamona, tikinise sita:la: honosanewemi iya:pa:na: mapatopita: Yesuwa Kote koawemi hanapola: sowa se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Se tiye kinapita: Yu sena tililayawa howa hanose selese, “Sawi akelesewane Eye noko:lu matane tile. Ewa niyewi solo elewa walosene sena sosoyewi eta: waiyamakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Au selapita: Yesuyewi selese, “Koteyewi Newa hamone Nema solo se tiye kinapita: Neyewi kima solo se tiye kinakeye. Neyewi Nine matana amunuse solo se tiye makinakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Neyewi Nine matana semeteiwa Neye solo se tiye kinisewalo, Kote matanawa Neyewi se tiye kinisewalo, noko:lu kiyawa matanema:na:na? Kote matanawa kulu hanose tima:na:pela: matanesene senayewi Ne seyawa takalepela: mouwa matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aputa: senayewi ene ewa wapilima:na:pela: ene matanawa solo kinisekeye. Alawamona Newa hamona seya sena amowa sosolo tema:na:pela: matanese Neyewi heneye napolo solo kinisekeye. Newa Nine wapilise se tiye eta: kinisemakeye. Mokopo sowa eta: selesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Aputa: Moseseyewi solo elewa kima se tiye mini kamowa kilipe sena semetei kulu hanose matanepela: eta: tisemakeye. Ko:lupita: kiyawa Newa kumita: sama:na: matanepa:?” ");
INSERT INTO khs_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Au selapita: sena kesale sopoyewi selese, “Ho olokeyatela Ke suwemi elatakeye. Etewi Kema sana kulaposakeye, e seyale?” ");
INSERT INTO khs_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Au selapita: Yesuyewi selese, “Ha:le tesene ikila semetei nowemiwa Neyewi matanepela: penanose tiyapita: kiyawa selese, ‘Eyewi ko:luseye? Ha:le tesene ikila ala:pewa Eyewi tikapeye tiyakeye,’ au selesapekeye. ");
INSERT INTO khs_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Alawamona kiyawa kili tilila kouwa meiyewi sena sa:wa keisa:tapita:, sala selati tiye akeya amowa akeye hanapola: oloipe sena sala kapo hekelesa: nana:pa:, aluse kiyawa kilipe tilila kouwa meiyewi solo elewa tuwapokeye. Iyewi seyawa Moseseyewiwala aupa: seyakeye. Alanase ha:le tesene ikila kemiwa ikila olo tekemiwa hetetiyapita: sena sala tomawa hekelesa: nanesekeye. ");
INSERT INTO khs_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Aluse Moseseyewi solo elewa kolaiye tima:pekitise ha:le tesene okemiwana, kiyawa sena sala tomawa hekelesa: nanesekeye. Moseseyewi au seya amunuse ha:le tesene okemi Neyewi sena nakola fala:pewa ko:lupita: kiyawa konomonoseye? ");
INSERT INTO khs_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kolotea potapola: kipila kotokamakiwa eta: ilimanakeye. Mouwa napolo matanepa:. Mouwa heneye matanepela: hekeya takalepela: kotokamakiwa ililakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yelusaleme sena kesale nokamoke Yesuwa potosekiwa i kene ta:potose “Sena sana kulaposape e seyawa Ewama? ");
INSERT INTO khs_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sena kesale sopoyewi ta:pita: peleya: hokatonase emi Eyewi solo se tiye kinatakeye. E sowa sena nowamoke matoliyetiyaposakeye. E sowa eta: toliyetimanase Kote Piseikipela: epesita: ta:peya sena Kelesowa Ewamone,” aluse iyewi matanepela: seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Aputa: “Keleso hetetiyapita: Ene heteti mouwa niyawa mamatanepesakeye. Alawamona Yesuwa Ene selati koawa niyawa papokeye. Paponase Ewa Kelesomakeye.” Aluse Yelusaleme sena kesale nokamoke seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Au selapita: Yesuyewi Kote koawemi se tiye a kina:sela: ela: unuwapo holose selese, “Kiyawa Newa heneye potosekeye. Newa selati koawana kiyawa potosekeye. Kiyawa papolo kamowa Neyewi heneye mouwa kiyawa tikili tese mamatanekeye. Alawamona Newa Nine matanawamunuse kulu hanose eta: minamakeye. Nowamoke Newa hamonapita: Newa minakeye. Ewa kiyawa tikili tese, ");
INSERT INTO khs_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","alawamona, Neyewi Ewa matanesekeye. Eyewi Newa hamonapita: Ewemi tese Newa minakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aputa: Yesuwa iyewi supa:na:pela: elawamona, supa:na: ikilawa eta: hetetimake Ewa eta: supumakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Alawamona sena kesale mutayewi Yesu sowa ta: tiyapola: selese, “Yesu penaiya timinisewa hene heneye sosolo napokeye. Yesuyewi nano ketea timiyawa sena nowa hetetiya kemiwa tima:na: tiya:sela: eta: helepa:na: telamakeye. Alanase Yesuwa Kote Piseikipela: epesita: ta:peya Sena Epa, Ewa Keleso enekeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aputa: Felesi senayewi sena kesale muta sowa seyawa ta:tapola:, iyawala, pilisiti sena sosoyawala, Kote koawemi ta:le ti sena potapola: sita:nema selese, “Kiyawa Yesu supa:na:pela: hamone.” Au selapita: Yesu enewemiwa ta:le ti sena hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesuyewi selese, “Ikila kolotea nowemi Newa kiwalapulu epesena:keye. Kolotea elapepela: Eye Newa hamone peleya: kemi Newa fiyama:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hanapita: kiyawa Newa kelesaleke itapalapita: potaposakeye. Newa fiyama:na: peleya: emi kiwala ha:na:na:wa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Au selapita: Yu sena tilila sopoyewi Yesu seyawa tikili tese i kene sopolo selese, “Niyewi Ewa mapotaposakeye, au selakamowa Ewa kami hanaposape? Yu senama tela koamesa: hanaposape? Emi hanosekiwa Yu sena noka sita:nemawana, Yu senama tela sita:nemawana, selapose emi hanapita:keye. ");
INSERT INTO khs_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Eyewi selese, ‘Newa kelesaleke mapotaposakeye. Newa fiyama:na: peleya: emi kiwa hanakamakiwa eta: ilimanakeye,’ au selakamowa, solo mou amowa ko:luse selape?” Aluse Yu sena tilila sopoyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tikina ikila emiwa ikilale sikapewa ikila sosokeye. Ikila emi Yesuwa tesile unuwapo selese, “Hano menipita: Newamo elakemi hawa ma:na:pela: mina. ");
INSERT INTO khs_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ta:tesene sena kesale kiwala, kiwa Newamo elakemi inapola: hano maiya. Alake Kote pukawemi momateyawa wekeye. Hano si fiyatelawa epapuluse Newemi himu semetei matanesene sena amowa himu matanawemi kokolo kao tesewa hawa woliyetiye sakotese elaposakeye.” Aluse momateyawa Yesuyewi pale seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Aputa: Yesuyewi seya mouwa wekeye. Senayewi Yesuma himu semetei matanepela: sitalapitekiwa Ho Napolo ili himu matanawemi woliyetiye apolowaloma:na:keye. Alawamona Yesuyewi seya ikila emiwa Kote ho:liyawa peleya: falemi Yesuwa a ha:na:na:no ela:, Ho Napowa peleya: weyemi eta: minamakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesuyewi seyawa sena muta kekenayewi ta:tapola: selese “Sena epamowa heneye sepatosene senanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Au selapita: sena nokamoke selese, “Kelesowa Ekeye.” Aputa: sena nokamoke selese, “Kalili peleya: emi Keleso eta: inisemakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Aputa: Kote pukawemi momateyawa wekeye. Tepitiyewi sena maya Keleso keisa:taposakeye. ‘Tepitiyewi ene koamesa: Peteleheme taunewemi keisa:taposakeye.’ Aluse momateyalakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aluse selapita: sena kesale kekenawa kalikalila matanase senawa takalese iwa elipei kaseyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iyewi nokamoke, “Ewa tipolo selawata:pa:,” au seyakeye. Au seyawa heneye tipolo selawapomakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Aputa: Kote koane potapola: sita: tesene ta:le ti senayewi Yesuwa iya:pela: mene inapita:, pilisiti sena sosoyawala, Felesi senayawala, iyewi ima ta:potose, “Yesuwa siliye eta: minamawane ko:lupita: elale?” ");
INSERT INTO khs_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Au selapita: ta:le ti senayewi selese, “Eye selesene aluse sena nowamoke puwano eta: seyamakeye. Eye selesene aluse puwano selapita: niyawa eta: topumakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Au selapita: Felesi senayewi selese, “Yesuyewi kiwa hopolose Eyewi mokopo selapita:, kiyawala ta:teselele? ");
INSERT INTO khs_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Niyewi ninipe sopoke Yu sena tililayawala, Felesi senayawala sopoke E seyawane ta:te iya:takeye. Niyewi semetei nowamokiwala eta: ta:tesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sena kesale muta kekenayewi Mosese solo elewa napolo mamataneselakeye. Mamatanepita: iwa falasima:na: peleya: hanaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Au selapita: Felesi sena ilipe kemi Nikitimase ewa puwano Yesuma seya eyewi Felesi sena sopoma selese, ");
INSERT INTO khs_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Niyewi solo elewa tuwaponase, solo elewa amowa senayewi tikapeye tipela: olokeyatela timinisaleke ene ema puwano topukeye. Ta:tapola: heneye alalapita: potapola:, falasisewa apoyakeye. Sena amawa a ta:tapose, falasisewa eta: apolosemakeye.” ");
INSERT INTO khs_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Au selapita: iyewi selese, “Kewala Kalili senale? Kote puka napolo akepa:. Sepatosene senawa Kalili peleya: emi eta: inisemakeye.” Aluse iyewi matanepela: seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aluse selese apola: sena sopoke ili koawemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sena ili koawemi hanapita: Yesu Ewa enapotane tokomo Olifiwemi hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kiapo ikiwatapita: Kote koawemi Yesuwa mene hanapola:, sena muta Ewa elakemi kekenepitekiwa Ewa hela: solo se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Se tiye kina:sela: enewemi, kesale sena ekele sena nowanapulu mokopo hanapita: sena nokamoke potapola:, kesale amowa siliye inapola:, Kote solo elewa walosene senayawala, Felesi senayawala ewa siliyapola: Yesu elakemi minakeye. Inapola: sena sopoke kekenepela: sita:newemi sena sopoyewi popita: kesalema selese, “Sena sopoke sikapo kewa epemi epesa,” esa: kotolakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kotopela: iyewi Yesuma selese, “Walosene sena, kesale amowa sena nowanapulu mokopo hanapita: sena nokamoke papokeye. ");
INSERT INTO khs_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Puwano Moseseyewi solo elewa tuwapowa wekeye. Kesale sena nowanapulu mokopo hanosaleke, kesale amowa etewayewi omita: toliyetiya:pa:. Aluse Moseseyewi solo elewa tuwapokeye. Solo ele tuwaponase Keyawa noko:lu matanepa:?” Aluse iyewi Yesuma seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aluse selakamakiwa Yesuyewi hele selapele esa:, iyewi Yesu kapo popa:na:pela: aluse hopolose Ewane kotoma:na:pela: seyakeye. Aluse selapita: Yesu kotopola: kelipolupela:la: ela:, tiya:yawa peleya:wemi momatelese enekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Helapita: iyewi ilipe wa:ke ta:tapola:, wa:ke ta:tapola: au selapitekiwa Yesuwa kotopola: elapepela: tesile selese, “Kiyawa sena semetei nowamoke nano olokeyatela eta: timinisemayemi, etewawa tiyapola: keyewi kine puwano ola:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aluse Yesuwa wa:ke kotopola: kelipolupela:la: ela: peleya:wemi momatelese enekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Momatelese henewemi sena tilila puwano hapalapita:, sena semetei semetei esa: hanapola: itapalapita:, kesale amowa semetei kemi elapita: Yesuyewi papokeye. ");
INSERT INTO khs_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesuwa kotopola: elapepela: tesile kesalema selese, “Kesaleo kewa, sena sopoke ko:yale? Sena semetei nowamoke kewa kotoma:na:pela: kemi elapele?” ");
INSERT INTO khs_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Au selapita: kesaleyewi selese, “Alamakeye. Sopolo hanapola: kotetikeye.” Au selapita: Yesuyewi selese, “Neyawana kewa eta: kotoma:na:makeye. Kewa hamone. Hanosekiwa sikape wa:ke olokeyatela timinise elatepa,” esa: Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sena kesale kekenepitekiwa Yesuyewi wa:ke selese, “Peleya: weyemi sena kesale sita:newa ho:liyawa tesene mouwa Nekeye. Sena kesaleyewi Newa kulu hanapola: sita:newa iwa yopolotela mahanaposakeye. Koiyawemiye, ho:liya epamowa kiwa kokolo kao tesewa timita: putupela: hanaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Au selapita: Felesi senala:yewi selese, “Keyewi Kine au sela amoke Keyewi Kine kamunuse selakeye. Keyewi Kine au sela amoke nima selakamakiwa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Au selapita: Yesuyewi selese, “Neyewi Nine epe selese amowa heneye selakeye. Newa mina peleya:wala Newa fiyama:na: peleya:wala Neyewi Nine semetei matanekeye. Alawamona kiyawa matanese, ‘Ewa minawa noko:lu minane? Ewa ha:na:na:wa noko:lu hanaposape?’ Aluse kiyawa tikili tese matana selakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Senayewi ene matanawa kotola epapuluse kiyawa kotosekeye. Alawamona yemiwa Neyewi enewa makotolakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Alawamona Neyewi kotosaleke napolo kotopela: hekelesekeye. Kotopela: hekelesewa Neyewi Nine matanawamunuse kotopela: hekelesemakeye. Ni Atayewi Newa hamona seya amoke matanawa Neyewi kulu hanose kotopela: hekelesekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aputa: kiyawa solo elewa pukawemi momatelese, ‘Wikinisi sena elipeiyewi nano papolo semetei kamunuse selapita:, henenapo au selesekeye.’ Aluse momateyalakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aputa: Neyewi Nine epe selese amowala, Nine Ni Atayewi Newa hamone Eye Newa epe selese amowala, na:tewi wikinisi elipei semetei kamunuse seyalakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Au selapita: iyewi selese, “Kine Ki Ata kaiye?” Aputa: Yesuyewi selese, “Newana Nine Ni Atawala kiyawa mamatane selakeye. Kiyawa Newa matanakiwa, Nine Ni Atawala kiyawa matanenuwamona ke elalapo.” ");
INSERT INTO khs_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aluse Yesuyewi Kote koane solo se tiye kinisekeye. Aputa: koane lumua moweni selawatesene pokose tiye ti amowa mapatopita: Yesu ela: solo se tiye mikeye. Aputa: iyewi Yesuma konomonose kemi Ewa kuma:na: ikila hetetiya seta: minamanase Ewa kotopela: eta: supumakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sikape, Yesuyewi wa:ke ima selese, “Newa enewa iya:pela: hanaposakeye. Newa hanapita: kiyawa Newa keyalapepela: mapotaposakeye. Kili olokeyatelawa kemi timinise sitalapepela: kupula: tepesakeye. Newa fiyama:na: peleya: emiwa kiwa hanakamakiwa eta: ilimanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Au selapita: Yu sena tililayawa selese, “Eyewi selese, ‘Newa fiyama:na: peleya: emiwa kiwa hanakamakiwa eta: ilimanakeye,’ au selakeye. Au selakane mouwa ena selape? Ewa Ene mene kulaposapa? ");
INSERT INTO khs_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Apula: Yesuyewi selese, “Kiwa peleya: weyemi sitalakeye. Newa falemi tese minakeye. Kiwa heneye peleya: senakeye. Peleya: we heneye Ne peleya:makeye. ");
INSERT INTO khs_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Neyewi puwano seyawa wa:ke selakeye. Kili olokeyatelawa kemi timinise sitalapepela: kupula: tepesakeye. Newa Nine kokolo kao tesekeye. Alake solo se tiye weyamowa kiyawa mata:tesaleke kiwa kemi olokeyatelawa timinise sitalapepela: kupula: tepesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Au selapita: iyewi penanose selese, “Kewa ipa:?” Apula: Yesuyewi selese, “Neyewi puwano kima se tiye mini kamona, Nekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kiyawa nano alusewa Neyewi kima se tiye miya:na:wa muta elakeye. Kima kotoma:na:wa muta elakeye. Nine Ni Atayewi Newa hamone Ene heneye selesekeye. Eyewi seyawa Neyewi ta: tiyapola: sena kesale sopoma selakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aluse Ene Ata Kotewa Yesuyewi selapita: iyawa ta:tapola: eta: heke matanamakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ma heke matanepita: Yesuyewi selese, “Sena Sa:wa Nekeye. Newa i kelipapoya papela:la: tili tiyapola: kelesewamunuse ikila emiwa Newa Nine kaluse tesekeye, esa: kiyawa matanema:na:keye. Ikila emiwa kiyawa sela:sela:, ‘Eyawa Ene matanawa matiminitakeye. E Atayewi selapita: sowa sepapolakeye.’ Aluse kiyawa selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Aputa: Eyewi Newa hamone Newa eta: iya:tesemakeye. Ewa Newanapulu elakeye. Ewa epelemita: Neyewi timinipita: Eyewi Newa eta: iya:tesemakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aputa: sena kesale mutayewi Yesu seyawa ta: tiyapola: Ema himu semetei matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Aputa: Yu sena kesale Yesu himu semetei matanepela: imawa Yesuyewi selese, “Ne solo amowa ta: tiyapola: sitalaleke, kiwa heneye Newa kulu hanosene sena kesalewa sitalakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Heneye sowa kiyawa ta:tiyapitekiwa heneye seyawa kiwa silikepima:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Au selapita: iyewi selese, “Niwa silikepima:na:keye, au selakamowa mouwa ena selape? Epalahameyewi sena i maya minawa niwakeye. Sena nokamoke niwa wa:la:lopita: niwa tipolo timinisene epapuluse niyawa sena nokamopela: tima:na: tisene sena eta: timakeye. Niwa tima:na: timita: sena nowamoke eta: wa:la:yamanase eyewi niwa silikepima:na:keye, au seyawa noko:lu silikepima:na:na?” ");
INSERT INTO khs_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Aputa: Yesuyewi selese, “Neyewi heneye selakeye. Senayewi olokeyatela timinisene amoke e inawa nano olokeyatela akeye. Nano olokeyatela amoke selese, aupa:, Au selapita: senayewi ta: tiyapola: tima:na: tisene sena timinisekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tima:na: tisene sena wa:la:ya inayewi ene matanese tima:na: tisene senawa iya:pela: sena nowama wa:la:losekeye. Alawamona e atayewi ene salawa eta: iya:tesemakeye. Sena nowama salawa eta: wa:la:losemakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aputa: nano olokeyatelayewi kiwa tipolo talapita: sita:newa, Kote E Sa:yewi kiwa fakekepilapita:, kiwa heneye fakekepiya sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kiwa Epalahameyewi sena i maya minawa Neyewi matanekeye. Epalahameyewi sena i maya mina amoke Newa kumita: sama:na: matanese hanatakeye. Ne sowa kiyewi eta: seli ta:timanase Newa sana kulapose matanese hanatakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Alake Nine Ni Atayewi Nema nano waiyawa Neyewi Nine kima selakeye. Sowa kiyewi ta:te iya:tapita:, kiyawa kili atayewi seyawa ta:tesekeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Au selapita: iyewi selese, “Nini atawa maya mina Epalahamekeye.” Aputa: Yesuyewi selese, “Kiwa Epalahameyewi sala maya telakiwa Epalahameyewi timiya epapuluse kiyawa timinimapekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Timinimape kamona kiyawa Newa kumita: sama:na: matanese hanatakeye. Kote heneye sowa Neyewi ta:tapola: kima se tiye mikeye. Se tiye kinapita: kiyawa Newa sama:na:pela: matanese hanatakeye. Aluse Epalahameyewi eta: matanemakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Alake kiyawa kili ata matana amunuse kiyawa tiyatakeye.” Au selapita: iyewi selese, “Isu olosane tela sala nimakeye. Nini ata semetei Kote Ene ekeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aputa: Yesuyewi selese, “Kili Kote Ata matanakiwa kiyawa himu hapawa Newa matanenuwamona ke elalapo. Kote ela peleya: emi Newa minakeye. Newa Nine matanawamunuse Newa eta: minamakeye. Koteyewi Newa hamonapita: minakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ne sowa ta:tapola: mamatanesaleke ko:luma:na:pela: ela:? Ne sowa kiyewi matanema:na: mapolose sita:nenase, Ne sowa kiyewi ta:tapola: mamatane selakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kili atawa Setenekeye. Kili atayewi matana amunuse kiyawa epelese kulu hanose timiyanakeye. Sena sana kumita: ma:ta: tiwa Eyewi ma:ta: tikeye. Aputa: heneye selesewa eyewi nanese nasulu tiye iya:peyanase eyewi mokopo selesewa semetei matanesekeye. Heneye sowa semeteiwala Setene Ewemi matelakeye. Mokopo sowa sopolo e himu matanawemi woliyetiye elakeye. E himu emiwa mokopo solo sopolo se tiye kinise tesekeye. Mokopo solo mouwa Setenekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Neyewi Nine sowa heneye sopolo selesekeye. Alawamona, heneye sopolo selapitekiwa kiyawa eta: seli ta:tesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Neyewi olokeyatela matanepela: timinisewa kiyawa papola? Alamakeye. Kiyawa eta: papomakeye. Neyewi heneye selapita: kamona ko:lupita: kiyawa ta:ta: iya:pela: sita:la:? ");
INSERT INTO khs_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kote sowa Ene E sa:yewi topukeye. Kiwa Koteyewi Ene salamanase Kote sowa kiyawa ta:tapose hapawa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Aputa: Yu sena tililayawa selese, “Kewa Samelia senakeye. Ho olokeyatelayewi Ke ho tikeye. Niyewi heneye selakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Apula: Yesuyewi selese, “Ho olokeyatela Ne ho eta: timakeye. Aluse kiyawa epe selese amowa kiyawa heneye maselatakeye. Nine Ni Atawane Neyewi tiyapola: puwano apolose wapilikeye. Alawamona kiyawa Newa tiyapola: sikapetapo kolotea apolakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aputa: Neyewi Nine kemi unuwapo wapilise selapose mamatane selakeye. Koteyewi Newa unuwapowa sosolo meapolaposakeye. Newa wapilipesakamowa Koteyewi sosolo meapolaposakeye. Eyewi sena kesale sopowa takalese takalepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Aputa: Neyewi kima heneye selakeye. Ne sowa sena kesaleyewi ta:tiyapitekiwa amowa, iwa heneye makulaposakeye. Iwa kokolo kao sitalaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Au selapita: Yu sena tililayawa selese, “Ho olokeyatela Ke howa heneye tilakeye. Alake Kewa matakolose matana tikili tese seleselakeye. Epalahame kulukeye. Sepatosene senawana kulukeye. Alawamona Keye selese, ‘Ne sowa ta: tisene sena kesale amowa makulaposakeye. Kokolo kao sitalaposakeye.’ ");
INSERT INTO khs_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Au seya amowa Epalahame kuluwa Keyawa toliyetiselele? Kewa sena Piseiki sosola? Sepatosene senawana kulukeye. Kewa ipise matanana?” ");
INSERT INTO khs_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aputa: Yesuyewi selese, “Newa Nine ela: wapilise seya e seyakiwa mokopo wapilise semapekeye. Alawamona Nine Ni Atayewi Newa wapilise apolakeye. Nine Ni Ata kiyawa Kotekeye au selesekeye. Nine Ni Atawane kili Kote semeteiwa kakeye. Kote semetei ela: Newa wapilikeye. ");
INSERT INTO khs_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ewa kiyawa heneye napolo eta: matanemakeye. Ewa Neyewi heneye matanekeye. Alake Neyewi Ewa eta: papoma Neyewi seya telakiwa Neyawa mokopo semapekeye. Kiyawa mokopo selesene epapuluse Neyawa eta: selesemakeye. Neyewi Ewa matanese E sowa Neyewi heneye ta:tapola: kulu hanosekeye. ");
INSERT INTO khs_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aputa: Newa peleya: weyemi mina:na:wa kili tilila kouwa mei Epalahameyewi matanakeye. Eyewi Newa mina:na:wa potapola: epelese enekeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Au selapita: Yu sena tililayawa Yesuma selese, “Epalahamewa Keyawa papola? Kewa yapene talo piipe (50) aluse Kewa emi enemakeye. Kewa tililamakeye. Keyawa noko:lu Epalahame papola?” ");
INSERT INTO khs_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Au selapita: Yesuyewi selese, “Neyewi heneye selakeye. Epalahame eta: kesilama Newa kao enekeye.” ");
INSERT INTO khs_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Alanase Yu sena tililayawa Yesuwa oma:na:pela: etewa tiyapita: papowamona Yesuwa o:sulu tepeya hanapola: Kote koawa iya:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu isu hemawemi hanose potakamake sena nowa si kola elapita: papokeye. Sena amowa ene e amayewi selati ikila emiwa si kolakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sena si kolawa potapola: sena ilipe hanoseyewi Yesuma ta:potose, “Walosene sena, sena si kolawa etewi olokeyatelawa eta: timinipita: ewa falasise si kolale? Eyewi ene olokeyatelawa timinipita: ewa falasi elale? Ene e amayewi e atayewi a:tawi olokeyatelawa timinipita: ewa falasi elale? Etewi olokeyatelawa timinipita: ewa falasi elale?” ");
INSERT INTO khs_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Au selapita: Yesuyewi selese, “Eyewi ene olokeyatelawa timinipita: ewa falasise si eta: kolamakeye. Ene e atawa e amawa a:tawi olokeyatelawa timinipita: ewa falasise si eta: kolamakeye. Koteyewi penaiyawamoke ewa si fala:walopita: sena sopoyawa popita: ewa selati ikila emiwa si kolakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aputa: nukuluma:na: tela ikila ho:lulusene ela: Neyewi nano timiyanakeye. Koteyewi Newa hamone e seyanase Eyewi nano timinisewa niyawa kipila tima:na: tiya:pa:. Yopolotelawemi Neyawana kiyawala nano eta: timinima:na:makeye. Nukuluma:na: mapatotakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Alawamona, Newa peleya: weyemi a elekiwa sena kesale peleya: weyemi sitalakamokiwa ho:liyawa Nekeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Au seya Yesuyewi selapola: peleya: kepesepela:, tiya:yawa sosokelapepela: tiyapola:, sena si kolawa siwemi mupukeye. ");
INSERT INTO khs_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Itipaiya mutapola: apola: Yesuyewi ema selese, “Kewa hanapola: hano Siloame Si epemi ke mitiwa selakomita: hamona.” Hano Siloamewa unu mouwa hano Ilikepiya aluse unuwapokeye. Hano si epemi sena amowa hanapola:, mitiwa selakokamake siyewi napolo papokeye. ");
INSERT INTO khs_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Potapita: sena e manawala, puwano moweni mita: helapita: papolo senawala selese, “Sena puwano moweni mita: helakane Ewamone?” ");
INSERT INTO khs_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Aputa: sena nokamoke selese, “Henekeye, sena epakeye.” Apula: sena nokamoke selese, “Alamakeye. E manakeye. Sena nowa e mitiwa kamuna elakeye.” Apula: sena si kola itapa telayewi selese, “Henekeye, moweni mita: helakane nekeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Au selapita: iyewi selese, “Ko:luse ke si fala:lale?” ");
INSERT INTO khs_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aputa: eyewi selese, “Sena nowa Ene unuwa Yesuyewi peleya: kepesepela:, ne siwemi mutapola: selese, ‘Kewa hanapola: hano Siloame Si selakomita: hamona.’ Aputa: newa hanapola: hano si selakokamake napolo papokeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aputa: iyewi selese, “Yesuwa kami elape?” Au selapita: senayewi selese, “Newa tikili tekeye. Ewa kami hapamita:pe,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Aputa: ha:le tesene ikila emiwa sena si kolawa itipaiya mutakamake Yesuyewi fala:pekeye. Fala:tapita: iyewi ewa siliye Felesi sena sita:ne emi siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Felesi sena sita:ne emi siliye inapitekiwa, Felesi senayewi sena si kola itapa tela ema selese, “Kewa si kolawa noko:lu fala:lale?” Au selapita: eyewi selese, “Sena nowamoke itipaiya tiyapola: ne siwemi mutakamake hayewi selakokamake itapa telakeye. Itapa tese napolo potalakeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Aputa: Felesi sena nokamoke selese, “Ha:le tesene ikila emiwa Eyewi nano tima:na: tiyanase Ewa Koteyewi hamonapita: mina sena amanakeye.” Au selapita: sena nokamoke selese, “Eyewi penanose timinisewa mokopo sena olokeyatela enene senayewi aluse penanose eta: tisemakeye.” Aluse ili matana kalikalise matanese i kene konomonakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Konoma:pela:la: sena si kola itapa tela ema Felesi senayewi wa:ke selese, “Kewa si fala:pe sena amowa keyawa ipise matanana?” Au selapita: sena si kola fala:peyawa selese, “Neye matanawa, Ewa sepatosene senanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aputa: Yu sena tililayawa selese, “Sena amowa ene e amayewi selati ikila emiwa ewa si olokeyatelamita:po. Heneye si kola itapa telamita:po.” Aluse matanese ene e amayewi e atayewi a:ko: mina e seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mina selapita: minakeye. Inapita: Yu sena tilila amoke selese, “Sena amowa ka:tawa ka:lipe ke sa:lele? Si kola kesilalole? Yemiwa napolo epe potoseya noko:lu napolo potoseye?” ");
INSERT INTO khs_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Aputa: ene e amayewi e atayewi a:te selese, “Ewa na:ni salakeye. Selati ikila emiwa e si kolakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yemiwa napolo epe potoseya noko:lu potape. E si fala:pewa sena ipei. Ema ta:pota:pa:. Ewa ene sena salanase ene ela: matanama:pita:keye. Eyewi selakamakiwa ililakeye.” Aluse a:tawi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A:tewi Yu sena tilila amowa ipilise sita:nenase aluse seyakeye. A:tewi seta: seyamake puwano Yu sena tililayawa selese, “Sena nowamoke selese, ‘Yesu Ene Kelesokeye,’ au selesaleke sena amawa Yu senayewi kekenesene koawemi inapa, au selaposakeye.” Aluse Yu sena tililayawa seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aluse semeta: ene e amayewi e atayewi a:tawi matanese, “Na:ko:lapulu inapa, au sema:na:napo.” Aluse matanese a:tawi selese, “Sena si kola fala:pewa sena salanase ewa ene ema ta:pota:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aputa: wa:ke Yu sena tililayawa sena si kola itapa tela ema mina e seyakeye. Mina selapita: minakeye. Inapita: iyewi selese, “Koteyewi ta:pita: keyawa heneye hekilase sela:pa:. Kote puwano apola:pa:. Yesuyewi mane olokeyatela enewa niyewi matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Au selapita: senayewi selese, “E matanawa neyewi eta: potesemakeye. E matanawa napololakeye. E matanawa olokeyatelakeye. Amowa neyewi mamatanekeye. Alawamona neyewi nano semetei matanawa wekeye. Newa puwano si kola enewa, yemi neyewi napolo potalakeye. Amowa neyewi matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Au selapita: iyewi selese, “Eyewi noko:lu ke si fakepela?” ");
INSERT INTO khs_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Au selapita: eyewi selese, “Neyewi kima napu selesapeye? Seyawane kiyawa eta: seli ta:tesemakeye. Ko:lupita: wa:ke nema ta:ta:? Kiyawala Ewa kulu hanapola: sita:pesena:pela: seleseye?” ");
INSERT INTO khs_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Aputa: iyewi konomonose ema itipilise selese “Sena amowa kulu hanosene senawa kekeye. Niwa Mosese kulu hanosekeye. ");
INSERT INTO khs_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Koteyewi Mosesema seyakeye, aluse niyawa matanekeye. Alawamona, Sena amowa nono kami minane? aluse niyawa matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Au selapita: sena si kola fala:peyawa selese, “Kiyewi ko:lu seleseye? Kiwa kaluse tikili tepa? Kiyewi selese, ‘Sena amowa nono kami minane?’ aluse kiyewi selesewamona, sena amoke newa si fala:pekeye. ");
INSERT INTO khs_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sena himu olokeyatela matanepela: elakamoke Kotema hopita: Koteyewi eta: ta:tesemakeye. Kotema wapilise Koteyewi matanawamoke timinisewa timiya:sela: elakamoke hopita:, Koteyewi topukeye. Amowa niyawa matanekeye. ");
INSERT INTO khs_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Puwano fa:nemiwa peleya: sosolo we ma:ta: ti ikila emiwana, sena maya mina tilila kouwa sita:ne ikila emiwana, tilila kouwa sita:ne ikila emiwana, ata enene ikila emiwana, sena ene e amayewi supeliwatesene okemi si kola kesilawa sena nowamoke fala:pe e seyawa niyewi eta: ta:tesemakeye. Puwano epapuluse eta: fala:pemakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Koteyewi nano tima:na: tisewa tima:na:pela: eta: hamona e seyama telakiwa, sena amo aluse ma itapa temapekeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Au selapita: iyewi selese, “Ke atawala ke amawana himu olokeyatela ela:, kewala himu olokeyatela selatikeye. Kewa napolo temita: nima solo se tiye kiniselele? Niyewi ke sowa eta: ta:pa:na:makeye. Yu senayewi kekenesene koane weyamowa iya:pela: hamone.” Alanase ewa hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Hanapita: sena si kola itapa tela ema kotopela: hamona e seyawa Yesuyewi ta:tapola:, sena amowa kelese potapola: selese, “Sena Sa:wa keyawa himu semetei matanana?” ");
INSERT INTO khs_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Au selapita: senayewi selese, “Piseiki, ema himu semetei matanema:na:wa nema walose sema. Ewa ipa:?” ");
INSERT INTO khs_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Au selapita: Yesuyewi selese, “Keyawa yemiwa potosewane Nekeye. Neyewi kema selakeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Aputa: sena amokiwa selese, “Piseiki, neyewi Kema himu semetei matanekeye.” Aluse eyewi wapilise selapita: ");
INSERT INTO khs_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesuyewi selese, “Sena kesaleyewi Kotema himu semetei sita:newana, sena kesaleyewi Kotema himu semetei eta: sita:nemawana, kaselepita: Newa peleya: weyemi minakeye. Sena nowamoke selese, ‘Neyewi nano sopoke eta: potesemakeye,’ e seyawa sena amowa si ho:lilise elaposakeye. Alawamona sena nokamoke selese, ‘Newa ilikeye. Ne siyewi nano sopoke potosekeye,’ e seyawa sena amowa si yopoloyetiye elaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Au selapita: Felesi sena mapatopita: sita:neyawa ta:tapola: ta:potose, “Niwana si kola sitalapita: Keyewi potapola: seleseye?” ");
INSERT INTO khs_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Au selapita: Yesuyewi selese, “Kiyewi selese, ‘Niwa si kola sitalakeye,’ aluse hokatolose e selesaleke, kili himu olokeyatelawa Neyewi itapa temapekeye. Alawamona kiyewi mahokatolo selapo. Kiyewi selese, ‘Niyewi nano sopoke matanepela:, apula: nano sopoke potapola: ili sitalakeye.’ Aluse epe selese amowa kili himu olokeyatelawa kemi sitalakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesuyewi sena kesalema wa:ke selese, “Neyewi kima heneye selakeye. A:pele sipi sola sena isu tenamo emi mainisaleke, solawa honosane emi papaseye tiye inapita: sena amokiwa a:pele sipiwa ikomonose atu tima:na:pela: inisekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sena ene isu tenamo emi inisaleke a:pele sipi pota:tesene sena akeye. ");
INSERT INTO khs_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A:pele sipi pota:tesene senawa sola suwemi minite, isu tenamo pote tesene senayewi isu tenamowa kolo tisekeye. Kolo tiyapitekiwa a:pele sipi pota:tesene senayewi a:pele sipi unu tiye tiwa unuwa sepela: holosaleke, a:pele sipi sopoke inapita: ili pota:tesene senayewi siliye mowa hanosekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Potapola: tesene sena putupela: hanapita:, e sowa iyewi ta:tapola: kulule hanose hanosekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A:pele sipi pote enemawane, iyewi kulule hanose eta: hanosemakeye. Sowa ta:takamake solo nowa ta:tesaleke, neiye mene hanosekeye.” ");
INSERT INTO khs_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aluse Yesuyewi pale selapitekiwa, iyewi solo mouwa eta: kolaiyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Au selakamake iwa eta: kolaiyama tepita: wa:ke Yesuyewi selese, “Neyewi kima heneye selakeye. A:pele sipi ka:mita: sola isu tenamo amunawa Nekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Puwano sena minawa atu tisene senakeye. Iyewi mokopo hopita:, ili sowa a:pele sipiyawa ta:takamake, himini ta:tesaleke, kulule hanose eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Isu tenamo amunawa Nekeye. A:pele sipi isu tenamowemi musuluyetiye mina sopowa Neyewi potapola: ela: mene siliyaposakeye. Isu tenamo emi inapola: mowa hutiya napolo ma:na:pela: hanosekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Alake atu tisene senayewi nano o:sulu tise sanose ikomonose auma:na:pela: inisekeye. Alawamona sena kesale Kotema napolo sita:pesita: Newa minakeye. Yemiwa iwa sopoke peleya: we epesita:yemiwa Koteyewi iwa napola:tapita: matanepela:, nano sopoke iliye tiye sita:la:, epelese epapuluse napolo sita:pesita: Newa minakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","A:pele sipi pota:tesene sena napowa Nekeye. ‘A:pele sipi napolo sita:pesita: pota:tesene senawa kulapitekiwa ililakeye,’ aluse a:pele sipi pota:tesene sena napoyawa matanesekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Alawamona sena nowamoke a:pele sipi potose ela: moweni tima:na:pela tima:na: tisene sena timinisekeye. Sena amokiwa a:pele sipiwa heneye eyawa ene eta: akeyamanase eye potakamake, mowa kasolo inapitekiwa potapola: a:pele sipiwa iya:pela: nesile hanosekeye. Nesile hanapitekiwa mowa kasoyewi a:pele sipi noka yaso napita:, noka mowa nesile netale tiye walosekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Alake senayewi moweni semetei matanepela: tima:na: tisene sena timinise a:pele sipiwa enamanase napolo matanepela: potapola: eta: tesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Alawamona a:pele sipi pota:tesene sena napowa Nekeye. Nine Ni Atayewi Nema matanepela:, Ni Atama matanepela: ela aluse, Neyewi Nine a:pele sipiwa matanepela:, Nine a:pele sipiyawa Newemi matanepela: epapuluse sita: tesekeye. Neyewi a:pele sipi epela: Newa kulapitekiwa ililakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Aputa: a:pele sipi noka sola we eta: talamawana Ninakeye. Iwala Neyewi siliye mina:na:keye. A:pele sipi mokopo mowa sita:neyawala, Neyewi sowa ta:tiyapitekiwa, siliye mina:na:keye. Mowa sita:newana, sola suwemi sita:newana, solawemi semetei selawapola: sopoke kekene tiye sita:pesena:keye. Alake pota:tesene senawa Newa semeteikeye. ");
INSERT INTO khs_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Newa tesile ha:na:na:nase kuma:na:keye. Auma:na:nase Ni Atayewi Newa himu hapawa matanekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Senayewi matanawamunuse Newa sanose makulaposakeye. Neyewi mailisaleke amowa Newa sanose eta: kuma:na:makeye. Neyewi Nine matanawa ili e seyanase Newa sanose kuma:na:nakeye. Senayewi Newa sanose kumita: Neyewi Nine matanawamunuse Ne tomawa miya:na:keye. Newa kupula: wa:ke mene tesile hanakemiwa penana:pela: tesile ha:na:na:keye. Aluse Nine Ni Atayewi matanepela: apoyakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Au seya Yesuyewi selapitekiwa Yu sena kesale ta:tapola: matanayewi kalikalise matanawa i kene elipei kaseyakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Matanepela:la: sena nokamoke selese, “Ho olokeyatela E ho tinase Eyawa etakeye. Ewa matakola tetakeye. Ko:lupita: E sowa kiyewi ta:ta:?” ");
INSERT INTO khs_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Au selapita: sena nokamoke selese, “Ho olokeyatela epamoke ho tinase aluse eta: selesemakeye. Sena si kolawa ho olokeyatelayewi eta: fala:tesemakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Puwano fa:nemi Kote Koane Titiwa Kotema Napolose Matanema:na:pela: Tikina kekena ikila amowa hetetikeye. Tikina kekenema:na:pela: yapene potia kiwemi kemiwa Yu sena kesale Yelusaleme sitiwemi kekenakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kote koawemi Yesuwa hanapola: koane wasa unuwapowa Solomone koane sola pakia isuwemi sila:sela: enewemi ");
INSERT INTO khs_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yu sena tilila kekenepela: iyewi Yesuma selese, “Niyewi Kewa potose himu elipei sitalakeye. O:suwemi nima hokato sema:na:ne? Kewa Kelesokeye au selakamowa Keyawa nima hokato hokatolose sela:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Au selapita: Yesuyewi selese, “Puwano Neyewi kima selakane kiyawa mata:tesapekeye. Ni Atayewi E unuwa tila:tesa: Ene penaiyayewi matanese tisene emiwa Newa kima walokeye. Walopita: kemi kiyawa seli mamatane selakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Alawamona kiwa Ne a:pele sipimanakeye. Kiyawa Ne sowa eta: seli ta:tesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","28","Aputa: Ne sowa Ne a:pele sipiyawa ta: tiyapola: kulule hanose inapita:, Neyewi iwa matanese heneye kokolo kao sita: tesewa kinisekeye. Kinapita: iwa heneye maolokeyatepesakeye. Iwa sena nowamoke sutapola: ma o:sulu tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","A:pele sipiwa Nine Ni Atayewi Nema mikeye. Ni Ata Ene heneye sosokeye. Sena nowamoke ewa Ni Ata Ene tiya:wemi eta: sulu tiye toliyetisemakeye. A:pele sipiwa Ene potapola: elakeye. Ene potapola: elanase sena nowamoke ma o:sulu tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ni Ata Na:ko: na:nipe semetei kakeye.” ");
INSERT INTO khs_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Au selapita: ta:tapola: Yu sena tililayawa etewayewi sama:na:pela: tikeye. ");
INSERT INTO khs_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tiyapita: Yesuyewi selese, “Kiyawa popita: Ni Atayewi Nema penana:pela: timinisewa nano muta Neyewi timiyakeye. Neyewi nano ena hele tiyapita: kiyewi etewayewi Newa sama:na:pela: ela:?” ");
INSERT INTO khs_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Au selapita: Yu sena tililala: selese, “Keye napolo timiyakiwa niyawa Kewa etewayewi masamapekeye. Alawamona Keye selese, ‘Kote Na:ko: na:nipe semetei kakeye,’ au selesewa emi ela: Keye Kotewa hanetapo meapolapita: Kewa etewayewi sama:na: ekeye. Keye selese, ‘Newa Kotekeye,’ au selakeye. Alawamona Kewa heneye sena sa:keye.” ");
INSERT INTO khs_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Au selapita: Yesuyewi selese, “Kote pukawemi momateyawa heneye kamunuse momateyalakeye. Momateya amowa sena nowamokiwa mahotolaposakeye. Puwano momateyawa wekeye. Koteyewi Ene solo ta:tapola: senama selese, ‘Kiwa sopoke kotela:keye,’ au seyawa momateyakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Koteyewi e seyawa emiwa Newa ta:pele tiyapola: hamonapita: Newa peleya: weyemi minakeye. Inapola: selese, ‘Newa Kote E Sa:keye.’ Au selapita: kiyewi selese, ‘Eyewi Kotewa kolotea me apolatakeye.’ Aluse kiyawa epe selese amowa ko:lu seleseye? ");
INSERT INTO khs_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ni Ata nano timinisewa Neyewi matiminisaleke Ne sowa kiyewi ta:te iya:tesewa ililakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Alawamona, Ni Ata nano penanose timinisewa Neyewi timinisaleke, nano timinisewa potapola: kiyewi himu semetei matanepa:. Nema himu semetei eta: matanemake, Neyewi timinisewa potapola: himu semetei matanepa:. Newa Atawalapulu semetei ela:, apula: Ni Atawane Newanapulu semetei ela:, epapuluse elapita: kiyawa potapola: matanema:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Alanase iyewi wa:ke Ewa tipolo selawapa:na:pela: sukulu tima:na:pita: elawamona, ili tiya:wa sutetiye hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aputa: Yesu hanapola:, hano Yotane satepela: nono fa:nemi hanapola:, Yoneyewi sena hano toliyeti peleya: kemi hanapola: enekeye. ");
INSERT INTO khs_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Enewemi sena kesale muta inise ilipe sopolo selese, “Niyewi popita: Kote penaiyayewi matanese timinisewa Yoneyewi eta: timakeye. Alawamona Yesuyewi alusewa Yone seyawa hene henenakeye.” ");
INSERT INTO khs_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aluse sena kesale mutayewi Yesu seyawa seli topukeye. ");
INSERT INTO khs_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Sena semetei nowa e unuwa Lasalase, Petani koamesa: enekeye. Koane semetei kemi Meliwala e ate Matawala a:ko: sita:nekeye. Lasalase ewa nakola tenekeye. ");
INSERT INTO khs_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Aputa: puwano Meliyewi nano noiya ikumu Yesu onatuwemi suluse, e pisei fayewi helakeye. Kesale amoke e atewa Lasalasewa nakola wa:tawemi telakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wa:ta telapitekiwa Meliwalapulu Mata a:tawi sena nowama selese sekepilise, “Keyawa Piseiki Yesuma selapose ha:na:pa:. Keyawa weyamu sela:pa:. Piseikio, Keyewi Kine sena ke mana himu hapa Lasalasewa nakola ka:pelalakeye, e sela:pa:.” Aputa: sena amowa hanapola: a:tawi selese sepapowa Yesuma seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Selapita: Yesuyewi ta:tapola: selese, “Ewa kuma:na:pela: nakola telamakeye. Sena kesaleyewi Kotema matanepela: wapilimita: nakola wa:tawemi telakeye. Sena Sa:wa Nekeye. Nemawala matanepela: wapilimita: ewa nakola wa:tawemi telakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Aputa: Yesuyewi Matawala, e ate Meliwala Lasalasewala, iwa sopoma himu hapawa matanese, ");
INSERT INTO khs_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasalase nakola ta:tapitekiwa kemi, Yesuwa E elakemiwa peleya: emi ikila elipei enikeye. Eyewi popa:na:pela: eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ikila elipei eniya:sela: ikila osokemi Yesuyewi selese, “Yutia peleya: epemi niwa mene ha:na:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Au selapita: E sena semetei hanoseyewi selese, “Walosene sena, napute Kewa kumita: Yutia peleya: emi Yu sena tililayawa etewayewi omita: kemi, Kewa wa:ke omita: mene hanoselele?” ");
INSERT INTO khs_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aputa: Yesuyewi selese, “Ikiwapo semetei kukuwemi (12) awa ho:lilisekeye. Opo emiwa ho:liyanase siyewi pote hanose apela kolose sanose eta: keyalewatesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yopolotelawemi hanose yopolotelanase apela kolose sanose keyalewatesekeye. ");
INSERT INTO khs_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Niyewi sena nini mana Lasalasewa ene enikeye. Eniwamona Neyewi mene kila:pa:na:pela: ha:na:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aluse pale selapita:, E sena sopoke hanoseyewi tikili tese sita:la: selese, “Piseikio, e nakola ka:pela:newa fala:pesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Aluse Lasalase mokopo nakola ka:pela:nenase matanepela:, Lasalase ene heneye kuluwa Yesuyewi pale selapita:, iyewi eta: kolaiyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Makolalese sitalapita: potapola: Yesuyewi hokatolose selese, “Lasalase kulukeye. ");
INSERT INTO khs_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E nakola ka:pela:la Newa eta: hapamakeye. Ewa kuluwa apana tuwapola: potapose ha:na:na:keye. Ikila emi Neyewi nano timinipita:, kiyewi Nema himu semetei matanema:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Au selapita: Tomase e unuwa nowa Titimase e sena semetei hanosene nokamawa selese, “Ewalapulu niwa sopoke ha:na:na:keye. Ewalapulu niwa kulapose ha:na:na:keye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","19","Yesu E sena ilipe hanosewanapulu Petani koamesa: inapitekiwa sena mutayewi selese, “Lasalase kuluwa apana tuwapowa napu ikila pinipi telakeye,” au seyakeye. Apula: ta:tapola: potakamake Petani koamesa: Matawala Meli a:tawi e atewa Lasalasenase himu nakolose sita:pesepekitise ekela temita:, Yu sena kesale mutayewi sesemita: inapola: sitalapita: papokeye. Petani koamesa: Yelusaleme siti emi panase senawana, kesalewala, muta minakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aputa: Yesu inape e selapita: Matayawa Ewa koluma:na:pela: hanapola:, Meli koane kemi elapita:, Mata hanapola: Yesuma selese, ");
INSERT INTO khs_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","“Piseikio, Kewa weyemi elaleke ne atewa makumapekeye. Aluse ewa kulukeye. ");
INSERT INTO khs_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Alawamona, yemiwa Keyewi Kotema holose epapume selapita: Eyewi epapuluse timinipesakeye, aluse neyewi matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Au selapita: Yesuyewi selese, “Ke ate mene teisataposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Aputa: Matayawa selese, “Itapa tela ikila emiwa sena kesale sopoke mene tesilapola: ewala mene teisataposakeye, aluse neyewi matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Aputa: Yesuyewi selese, “Kokolo kao epesita: mene teisa:pa:na: sena amowa Nekeye. Sena kesaleyewi Nema himu semetei elaleke, sena kesale amowa kuluse kuluwamona, elawamona mene tesile hanapola: kokolo kao elaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Newalapulu kokolo kao ela: Newemi himu semetei matanepela: enene sena amowa heneye makulaposakeye. Mata, Sowa kewa ta:teselele?” ");
INSERT INTO khs_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Au selapita: Matayawa selese, “Henekeye, Piseikio, neyewi ta:takeye. Kote E Sa:le Kewalakeye. Aputa: Koteyewi Kewa ta:peya sena Kelesowa peleya: sosolo weyemi minawa Kewalakeye, aluse neyewi matanekeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matayawa selese itapa tepela: ene koawemi mene hanose sena kesale sopoke ta:pa:pekitise Matayawa Melima o:sulu selese, “Walosene sena mina elakeye. Kewa popa:na:pela: holosapekeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Aputa: Meliyewi ta:tapola: kipila tesile hanakamake ");
INSERT INTO khs_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu koamesa: eta: minamanapita:, puwano Matayawa Yesu koluye tise papolo kemi Yesu elapita: popa:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hanapita: Yu sena kesaleyewi Meliwa ekela temita: seselese ka:la:yawamoke potakamake Meli kipila tesile hanapita: papokeye. Potapola: matanese, “Meli apana ya:ma:na:pela: hanatakeye,” aluse iyewi matanepela: kulule hanose hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Aputa: Yesu enewemi Meli inapola: kuniu kula:pela: hela: selese, “Piseikio, Kewa weyemi enekiwa ne ate makumapekeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Aputa: Yesuyewi potakamake Meliyewi ya:lapita: Yesuyewi potakamake Yu sena kesale kulu hanose mina amokiwala ya:pelepita: potapola:, Yesuyewi himu sosolo nakolose selese, ");
INSERT INTO khs_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Lasalase kuluwa apana kami tuwapole?” Au selapita: iyewi selese, “Piseikio, popa:na:pela: mina.” ");
INSERT INTO khs_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Apula: Yesuyewi ya:lakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ya:lapita: Yu sena kesale nokamoke potapola: selese, “Eyewi sena manawa sosolo matanese ya:latakeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Alawamona, Yu sena kesale nokamoke selese, “Sena si kola fala:peyawa Lasalasewala kuma:pikitise itapa temapekeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu wa:ke himu sosolo nakolose apana hanapola: potakamake apana uwalokemi etewayewi etayalapita: potapola: ");
INSERT INTO khs_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","selese, “Etewa etapeyawa kolo tiye hemawemi kikilikepime.” Au selapita: sena kulu e atewa Matayawa selese, “Piseikio, apana tuwapowa napu ikila pinipikeye. Napu po:sula ikumu hosonopesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Au selapita: Yesuyewi selese, “Neyewi kema puwano selese, ‘Ne sowa ta:tiyapitekiwa Kote penaiyawa ho:liyawa potaposakeye.’ Aluse Neyewi seyakeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aputa: etewayewi etapeyawa kola:tapita: potapola: Yesuyewi hepene falemi pote selese, “Ni Atao, Neyewi Kema holose Keyewi ta:tiyapitekiwa Kema napolo selakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ikila sopoke Ne sowa Keyewi ta:tiyapitekiwa Neye matanekeye. Sena kesale sopolo epela: Newa hamona e seyawa Kewakeye. Aluse iyewi matanemita: Neyewi Kema unuwapo hokeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aluse kulukulusekiwa itapa tepela: unuwapo selese, “Lasalase kewa weyemi mina.” ");
INSERT INTO khs_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aputa: sena kuluwa Lasalase inapola:, saoyewi tiya:wala onatuwala piseiwala sako tiyapola: inapita: Yesuyewi selese, “Saowa fakema. Ewa hamonite,” e seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Aputa: Yu sena kesale mutayewi Meli sesemita: mina amoke Yesuyewi Lasalase kulu mene tesilapita: potosekiwa, iyewi Yesuma himu semetei matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Alawamona, Yu sena kesale noka Felesi sena sita:ne hanapola:, Yesuyewi timiyawa seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Selapita: Felesi senayawana, pilisiti putupela: senayawana, ilipe kekene tiyapola: kanasolo sena Sanahitilini selese, “Yesuwa niyewi ko:luma:na:na? Eyewi heneye penana:pela: timiyanakeye. Niyewi Ewa kama:na:wa noko:lu timinima:na:napa? ");
INSERT INTO khs_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","E sowa eta: naiyama tesaleke, sena kesale sopoke E sowa ta: tiyaposakeye. Ta: tiyapitekiwa Lome kamani senayewi Kote koawa ekeye tiyaposakeye. Eke tiyapola: niwa Yu sena kesale sopoke sana kuma:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Apula: sena ilipe nowa ene unuwa Kaiafasekeye. Yapene emiwa Kaiafase pilisiti sena sosolo putupela: enekeye. Kaiafase selese, “Kiwa tikili tese sitalakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sena kesale sopoke kuma:na:wa eta: ilimanakeye. Sena kesale sopowamopela: sena semetei kulapitekiwa ililakeye. Neye ela: napu we selale kiyawa eta: matanamakeye.” ");
INSERT INTO khs_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aluse seyawa Kaiafase ene matanawa emi ela: eta: seyamakeye. Yapene emiwa Ewa pilisiti sena sosolo putupela: enenase eye sepatose Yutia sena kesale iwamopela: asuwatese Yesuwa kulaposakeye e seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yu sena kesale semeteiwamopela: kuma:na:wa eta: seyamakeye. Sena kesale nokamokiwala Kotema himu semetei sita:newa kalikalila nesile sitala amowa kekenemita: Ewa kuma:na:keye, au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ala ikila emiwa Felesi senayeliye pilisiti sena ilipe Yesu sana kuma:na:pela: matanese isu keyakeye. ");
INSERT INTO khs_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Alanase, Yu sena kesale sita:newemi Yesuwa hokato sila:sela: emi enemakeye. Mowa senanama seleya peleya:wemi mapato Ifeliame taunewemi hanapola: eniya:sela: enekeye. Koamesa: epemi E sena sopoke hanosewanapulu eniya:sela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yu senayewi Koane Helepa:pe Matanema:na:pela: Tikina kekena ikilawa mapatopita: Yu sena kesale muta ilipe himu olokeyatela itapa temita: Kote sikapowemi papaya napolo temita: ilipe peleya: iya:pela: Yelusaleme sitiwemi fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Fiyanapola: Kote koawemi musulupita: pilisiti sena sosoyawala Felesi senayawala selese, “Kiyewi Yesu potosekiwa nima sela:pa:.” Au seya, iyewi Yesu tipolo selawapa:na:pela: selapita: sena sopoke Yesu potapose kelese ilipe sopolo kekelese selese, “Tikina weyemi Yesu inaposapele? Kiyawa nokamoke noko:lu matanepa:?” Aluse ilipe sopolo kekelese seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Koane Helepa:pe Matanema:na:pela: Tikinima:na:pela: ikila tekapeipe epesita: Yesu Petani koamesa: hapakeye. Hanapola: Lasalase kuluwa Yesuyewi mene teisa:pe elakemi koane Yesuwa hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hanapola: Lasalase koane Yesuwa inapita:, Yesupela: nano ma:na: sapokeye. Satapola: Lasalasewala Yesu a:ko: sena nokalapulu tepolo pawemi ka:la:lopelelapita:, Matayawa nano ma:na: satapola: mikeye. ");
INSERT INTO khs_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Aputa: Meliyewi potolowemi nano ikumu hosonosene unuwa nate selawa tiyapola: inapola:, Yesu onatuwemi nano noiya ikumu moweni sosolo wa:la:yawa suluse, Meliyewi e pisei fayewi helakeye. Helapita:, koane we sopolo suwemi nano noiya ikumu hoseya woliyetikeye. ");
INSERT INTO khs_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hosolopita: Yesu sena sopoke hanosene semetei nowa Yutase Isekeleote eyewi sikape Yesuwa sihelelema:na: sena amoke selese, ");
INSERT INTO khs_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Moweni silifa sakopo usulupe (300) nano noiya hosonosene potolowemi wasuwa wa:la:lopela: sena kesale nano misitiyama eta: mimakeye.” ");
INSERT INTO khs_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Au seyawa sena nano misitiyama heneye miya:na:pela: matanepela: eta: seyamakeye. Yutasewa ene atu tisene sena enenase seyakeye. Aputa: sena ilipe hanosene sopoke moweniwa kekenepela: hosewemi sela tiye, Yutaseyewi potapola: enekeye. Potapola: ela: moweni noka eyewi o:sulu atu tikeye. ");
INSERT INTO khs_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Aputa: Yesuyewi Yutasema selese, “Kesale amowa ka apola:pa:. Kesale amo ene tima:na:pela: matana amunuse tikeye. Nano noiya ikumu Newamo kuma:na: tomawa seila:tese sukeye. Newamo kuma:na:wa matanepela: ta:pele tiyapola: sukeye. ");
INSERT INTO khs_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ikila sopoke sena kesale nano misitiyawa kiwalapulu kilipe kemi kao sitalaposakeye. Alawamona ikila sopoke Newa kiwalapulu ninipe maelaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yesu Petani koamesa: ela e selapita: Yu sena kesale mutayewi ta:tapola: popa:na:pela: hapakeye. Iyewi Yesuwala, Lasalase kulu teisa:pewala, popa:na: hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hanapita: pilisiti sosolo senayewi selese, “Lasalasewala sana kuma:na:keye.” Aluse matanepela: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lasalase mene teisa:penase, Yu sena kesale mutayewi pilisiti sena sowa iya:pela:, Yesuwamo kulu hanose, pilisiti senayewi konomonose Lasalasewa sana kuma:na:keye, au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nukulapo semetei eniyapola:, Yelusaleme sitiwemi tikinima:na:pela: sena kesale muta kekena emiwa Yesu inape e selapita: ta:tapola: ");
INSERT INTO khs_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ilipe topalo falo epapula na tiye tiyapola: Ewa popa:na:pela: hanapola:, Ewa inapitekiwa potapola:, unuwapo holose, “Nini Kotema wapiyakeye. Piseiki Koteyewi Kewa hamone Ene unuwemi minase Kema napola:tesekeye. Isolaiya peleya: Yu sena kesale sita:ne ili Piseiki sosowa Kewakeye.” ");
INSERT INTO khs_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Apula: Yesuwa kopolo toki e sa:wemi helepela: hapakeye. Puwano fa:nemi Kote pukawemi momatelese, ");
INSERT INTO khs_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saione koamesa: sita:ne sena kesale kiwa ipipa. Pota:pa:, kili Piseikiwa kopolo toki e sa:le wapa:kemi helepela: inapekeye.” Aluse, puwano fa:nemi momateyawa epe iniseya epalakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yesu kopolo toki e sa:le wapa:kemi helepela: mina ikila emiwa sena ilipe hanoseyewi puwano Kote pukawemi momateya amo mouwa eta: matanemakeye. Alawamona Yesu hepene falemi hapawemi iyewi matanese, “Puwano Kote pukawemi momate tiye sena Piseiki aluse inaposakeye, au seyawa Yesu epe inaka epalakeye.” Aluse Yesu hepene falemi hapawemi sikape iyewi matanakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aputa: Yesu Yelusaleme sitiwemi inape e selapita: sena kesale mutayewi popa:na:pela: hapakeye. Yesuyewi Lasalase kuluwa mene tesilapola:, senayawala kesaleyawala iyewi nokamoke papoke inapola: selapita:, sena kesale nokamoke ta:tapola: Yesuwa inape e selapita: popa:na:pela: hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Yesuyewi Kote penaiya monotela timiya e selapita: topunase, sena kesale mutawa Yesu popa:na: minakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hanapita: Felesi senayewi potapola: i kene sopolo selese, “Nano napu niyewi matana timinima:na:pela: elawa eta: hetetima:na:manakeye. Nini sowa sena kesale sopoke iya:pela:, Yesu sowa ta: tiyapola: Ewamo kulu hanatakeye.” Aluse Felesi senayewi ilipe sopolo seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tikina kekenema:na: sita:ne ikila emiwa Kiliki sena noka Yelusaleme sitiwemi Kotema wapilima:na:pela: fiyanekeye. ");
INSERT INTO khs_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Fiyanapola: Filipima seyakeye. Filipiyewi e koane koamesa: Pesaita taune Kalili peleya:wemi enekeye. Filipima iyewi selese, “Sena puwano, niyewi Yesu popa:na: ha:na:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Au selapita: Filipi hanapola: A:nituluma selese, elipe a:ko: hanapola: Yesuma seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Selapita: Yesuyewi selese, “Sena Sa:wa Nekeye. Koteyewi Ne unuwa wapilise apoma:na:wa Newa kuma:na: ikilawa opo weyalakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Neyewi heneye selakeye. Witi fo tikipelesaleke, tomawa peleya:wemi po:sula, henewa sopopela: fiyatesekeye. Sopopela: fiyatela amoke fo muta watosekeye. Tikipiyawa toma mapo:sulusaleke henewa sopopela: eta: fiyanesemakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Peleya: weyemi senayewi e hepa:la himu hapawa elaleke, ene hene heneye kokolo kao epesenewa iya:takeye. Alawamona, peleya: weyemi tomayewi timinisewa mapolose iya:pela:, fa:se apolosaleke, ene hene heneye kokolo kao elaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sena kesale semetei nowamoke Neye timinisene epapuluse tima:na:pela: matanesaleke amowa, Newamo kulu ina:pa:. Alake Ne elakemi Neyewi nano timinisene sena kesale amowa Newanapulu ninipe sita:pesena:keye. Neyewi nano timinisene sena kesale amowa Ni Atayewi sosolo meapolaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yesuyewi selese, “Newa kuma:na:wa kete matanese Ne himu hilila sosolo tekeye. Ni Atama ko:lu sema:na:ne? Ni Atao, ikila yemiwa Newa kuma:pekitise sesepa:, aluse maselaposakeye. Kuma:na:nase Newa peleya: weyemi minakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ni Atao, senayewi Kewa wapilimita: Ke unuwa tilita:pa:.” Au selapita: hepene emi tese Koteyewi selese, “Senayewi Newa wapilimita: Ne unuwa puwano tilapekeye. Me wa:ke sikapewala Ne unuwa tilipa:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aluse hepene emi tese selapitekiwa sena kesale sopoke kekenepela: sita:neyawa ta:tapola:, iyewi matanese, “Kunukunakeye,” aputa: iyewi nokamoke selese, “Alamakeye, hepene senayewi Ema nano sowa selakeye.” ");
INSERT INTO khs_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Apula: Yesuyewi selese, “Neyewi ta:pita: hepene emi tese maselatakeye. Kiyawa ta:pita: sowa selakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Napute peleya: sosolo weyemi sena kesaleyewi mane olokeyatela tiyapose Koteyewi kotopesakeye. Aputa: napute peleya: weyemi Setene piseikipela: elakamowa e penaiyawa sano tiye toluye tise iya:taposakeye. Alake Koteyewi auma:na:wa napu ikila yemiwa mou apolakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aputa: Newa i kelipapoyawa palese tili tise kelesewamunuse ikila emiwa sena kesale sopoke Newemi himu semetei matanemita: Neyewi sima:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Alawamona Ewa senayewi i kelipapoyawa papita: kuma:na:wa Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aluse selapita: sena kesale kekenayewi selese, “Kote pukawemi momateyawa wekeye. ‘Kote Piseikipela: epesita: ta:peya Sena Kelesowa kokolo kao elaposakeye.’ Aluse momateya amowa Keyewi selese, ‘Sena Sa:wa i kelipapoyawa papelaposakeye.’ Au selakane ko:lupita: aluse seleseye? Sena Sa: amowa ipa:?” ");
INSERT INTO khs_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Au selapita: Yesuyewi selese, “Ho:liyawa kiwalapulu ikila kolotea elaposakeye. Ho:liya kiwalapulu elakemi ikila emiwa seli ha:na:pa:. Yopolotesaleke eta: seli hanosemakeye. Yopolotela emiwa isuwa ha:na:na:wa tikili tese sita: tesekeye. ");
INSERT INTO khs_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Newa ho:liya elapita: ho:liyawa ama himu semetei matanepela: sitalapitekiwa, kiwa sopoke sena kesale ho:liyawemi sita:pesena:keye.” Aluse Yesuyewi se tiye kinapola: itapa tepela:, Ewa o:sulu hanapola: iyewi popa:pekise itapalapo. ");
INSERT INTO khs_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesuyewi E penaiyayewi matanepela: timinipita: kemi, iyewi siyewi potapola: pote iya:peyakeye. Pote iya:pela: Ema himu semetei eta: matanemakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aisaiayewi selese auma:na: seyawa heneye kaluse kemi iyewi pote iya:peyakeye. Puwano Aisaiayewi selese, “Piseikio, Ke sowa niyewi se tiye miwa iyewi eta: topumakeye. Piseiki, Ke penaiyayewi matanepela: timinisewa nima waiyawa iyewi pote iya:peyakeye.” ");
INSERT INTO khs_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aluse Aisaiayewi selese ta:te iya:tesewa mouwa matanemita: se tiye nowa solo mikeye. Solo nowa wekeye. ");
INSERT INTO khs_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pote iya:tesewa sena kesale amokiwa siyewi popa:pekise siwa Koteyewi kowa:pekeye. Himuyewi matanema:pekise himu matanawa talapa:pekeye. Puwano Kote solo ta:ta: iya:pela: iyewi sikape selese, ‘Koteyewi niyawa mane olokeyatelawa fala:pita: matanakeye.’ Aluse matanese sita:pesena:pela: mene hanapekitise ili himuwa Koteyewi matana talapa:pekeye. Ili siwa kowa:pekeye.” ");
INSERT INTO khs_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aluse Aisaiayewi seyakeye. Puwano Yesu seta: minama ela: Yesuyewi ho:liyawa Aisaiayewi potapola: aluse seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Alawamona, ikila semetei kemi, sena kesale mutawala, Yu sena putupela: sita:ne sena nokamokiwala, Yesu sowa seli topukeye. Ta: tiyapitekiwa Felesi senayewi ta:tapola: ima kotoma:pekitise iwa ipilise sita:nekeye. Felesi senayewi ima selese, “Yu senayewi kekenesene koawemi inapa,” au selapita: matanepela: Yesuwalapulu sita:pesena:wa ke iya:peyawa sena sopoma hokatolose eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Sena nokamoke selese, “Kewa eta: napomakeye,” au selapita: hokatolose eta: seyamakeye. Sena nokamoke selese, “Kewa napokeye,” au semita: senayewi sowa tiye puwano hapakeye. Koteyewi selese, “Kewa napokeye,” au semita: solo amowa tiye puwano eta: hapamakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sena kesale sopoyewi ta:pita: Yesuyewi unuwapo selese, “Sena kesaleyewi Nema himu semetei matanepela: sitalapitekiwa, Koteyewi Newa hamona seya Emawana himu semetei matanepela: sitalakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kiyewi Newa potosekiwa Newa hamona seya Kotewala kiyewi potosekeye. ");
INSERT INTO khs_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Peleya: weyemi Newa ho:lilise minakeye. Ho:liya inapita: senayewi Ne sowa ta: tise yopoyawa iya:pela: ho:liyawemi kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sena kesale sopoke mene silima:na:pela: Newa minakeye. Sena kesale amowa kotoma:na:pela: Newa eta: minamakeye. Aputa: sena kesaleyewi Ne sowa ta:tapola: ta:te iya:tapitekiwa, sena kesale amowa Neyewi takalese eta: kotoma:na:makeye. ");
INSERT INTO khs_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sena kesaleyewi Nema fa:se iya: tese, Ne sowa ta:ta: iya:peya, solo amoke iwa kotopesakeye. Napu Ne seyawa iyewi ta:te iya:peyanase kotola ikila emiwa seya amowa hetetise seya amoke iwa kotopesakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ne sowa Neyewi Nine matanawamunuse maselakeye. Ni Atayewi Newa hamone selese sepapowa Neyewi selakeye. ");
INSERT INTO khs_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","E sepapowa sena kesaleyewi ta:tiyapitekiwa iwa kokolo kao sitalaposakeye, aluse Neye matanekeye. Alake Ni Atayewi Nema selese sepapowa Neyewi kima se tiye kinakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Koane Helepa:pe Matanema:na:pela: Tikina kekena puwano kolotea ikila amowa, aluse Yesuyewi matanese, “Peleya: we iya:pela: Ni Ata elakemi peleya: falemi fiyama:na: ikila amowa mapatotakeye.” Aluse matanepela:, E sena ilipe hanosene himu hapawa matanakeye. Napute E himu hapawa matana amunuse honosane eta: iya:peyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yopolotelawemi Yesu E sena ilipe hanosewanapulu ma:na: na:sela: ka:la:lopela:nekeye. Ma:na: na:sela: ka:la:lopela: elapita: Setene inapola: Isekeleote sena Saimoneyewi e sa:le Yutase himu matanawemi selese, “Keyawa Yesu sihelelema,” aluse Yutasema seyakeye. Au selapita: sikape ilipe semetei ka:la:lopela:la: ma:na: menakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma:na: napela: ka:la:lopela:la: Yesuyewi matanese, “Ni Atayewi penaiya sopowa Nema kinapita: Newa ilise elakeye. Newa Kote elakemi emi minakeye. Kote elakemi mene fiyama:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aluse matanepela: Ewa tesile sao wapa:kemi kalawa kolu tiye, tawelo tiyapola: kenawemi welopela:, ");
INSERT INTO khs_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tisiwemi hano wasu tiye hanapola: sena ilipe hanosene onatu selakolose, tawelo kenawemi welopela:newa fake tiye helakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Saimone Pita enewemi inapitekiwa Saimone Pitayewi selese, “Piseikio, Ne onatu selakoma:na:na? ");
INSERT INTO khs_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Au selapita: Yesuyewi selese, “Onatu selakola mouwa kiyewi yemi mamatane selakeye. Alawamona, sikape matanepesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Aputa: Pitayewi selese, “Yemiwala sikape honosanewemiwala, ne onatu Keyewi maselakoma:keye.” Au selapita: Yesuyewi selese, “Ke onatu maselakosaleke kewa Newanapulu na:nipe maelaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Au selapita: Saimone Pitayewi selese, “Piseikio, Onatu semetei selakopa. Onatu selakolose, tiya:wala, piseiwala, sopoke selakopa:.” ");
INSERT INTO khs_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Au selapita: Yesuyewi selese, “Hano mutuse toma akeleya itapalapita:, wa:ke toma sopolo hano eta: mutusemakeye. Onatu semetei selakolosekeye. Kiwa sopoke akeleya itapa tepela:, sena semetei nowa akeleya kemi elakeye.” ");
INSERT INTO khs_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aluse seyawa Yesu E sihelelema:na: senawa matanepela: seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Onatu selakolose itapa tepela: Yesuyewi E sao wapa:kemi kala kolu tiye tuwapowa, wa:ke kapela: tepolo mapatopita: hela: selese, “Neyewi kiwa onatu selakolawa mouwa kiyawa matanana? ");
INSERT INTO khs_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kiyewi Nema, ‘Walosene sena, Piseikio,’ e seyawa Nekeye. Kiyewi heneye au selesekeye. ");
INSERT INTO khs_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kili walosene senawala, kili piseikiwala, Nekeye. Alawamona Newa tima:na: tisene sena amuna me tepela: kili onatuwa selakolose. Kiyawala epapuluse i kene kemi nowa onatuwa selakopa:. ");
INSERT INTO khs_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Neyewi alusewa kima walokeye. Aluse Neyewi kiwamopela: tima:na: tisene sena tima:na: tisewa epapuluse, kiyawala sena kesale nokamopela: tima:na: tisene sena tima:na: tiya:pa:. ");
INSERT INTO khs_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Alake Neyewi heneye selakeye. Tima:na: tisene senayewi e inawa eta: helete tiye hanosemakeye. Aputa: selapose hamonapita: mina senayewi e hamona seya senawa eta: helete tiye hanosemakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yemiwa heneye seyawa kiyawa matane tiyakeye. Matanepela: epapuluse timinisaleke kiwa epelese sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Kiwa sopoke Neyewi maselakeye. Kiwa sopoke Neyewi ta:peya matanekeye. Alawamona puwano Kote pukawemi momateyawa heneye aupesakeye. Aluse Kote pukawemi momateyawa wekeye. ‘Newalapulu na:nipe ka:la:lopela:la: ma:na: mena sena amoke matana nowa hetetise Nema mapolose kisi tepela: enekeye.’ Aluse, puwano momateyawa napu kalusekeye. ");
INSERT INTO khs_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Sikape auma:na:wa napu Neyewi kima selakeye. Ala ikila emiwa kiyewi potapola: matanese, ‘Ewa heneye Kelesokeye.’ Aluse matanemita: sikape auma:na:wa napu Neyewi kima selakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Neyewi heneye selakeye. Neyewi hamona seya sena amowa inise se tiye kinapita:, sena nowamoke ta: tiyapola:, Ne sowala ta:tesekeye. Aputa: sena kesaleyewi Ne solo ta:tesaleke, Newa hamona seya Kote amokiwa sowala ta:tesekeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu au selapita:, E himu nakolose ela: selese, “Neyewi heneye selakeye. Kili semetei nowamoke Newa sihelelepesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Apula: sena ilipe hanosene ka:la:yawamoke i kene mene potapola: selese, “Ipi elape?” ");
INSERT INTO khs_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aluse tikili tese ka:la:lopelelapita:, sena ilipe hanosene semetei nowama Yesuyewi himu hapa matanawa Yesu mapato henekeye. ");
INSERT INTO khs_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Helapita: Saimone Pitayewi si kapo tilitise, “Keyawa Yesuma ta:ta:pa:. Sena amowa ipa:? Aluse ta:ta:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aluse si kapo tilitapita:, Yesuyewi matana sena semeteiwa elipe semetei kalotese ka:la:lopela:la:, piseiyewi na:nipe nunuse hanapola: Yesu kena:wemi selese, “Piseikio, sena semetei Keye seyawane ipa:?” ");
INSERT INTO khs_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Au selapita: Yesuyewi selese, “Neyewi falawa tiyapola: hano weila tikipela: kinapita:, sena epakeye.” Aluse Eyewi falawa tiyapola: hano weila tikipela:, Isekeleote sena Saimoneyewi e sa:le Yutasema mikeye. ");
INSERT INTO khs_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kinapita: falawa Yutaseyewi tikeye. Tiyapola: ikila emiwa Setene inapola: e himuwemi musuluyetikeye. Musuluyetiyapola: Yesuyewi selese, “Keyewi timinima:na:wa kipila tiya:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Alawamona sena ilipe hanosene Yesuwalapulu ilipe ka:la:yawamoke sowa ta:tapola: eta: kolaiyamakeye. Iyewi nokamoke tikili tese matanese, ");
INSERT INTO khs_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","“Yutaseyewi moweni hose potapola: enenase, Yesuyewi ema tikinima:na:pela: nano ma:na: wa:la:loma:na:pela: hamone e seyakeye.” Aluse matanakeye. Aputa: iyewi nokamoke tikili tese matanese, “Sena nano misitiyama moweni miya:na:pela: hamone e seyakeye.” Aluse iwa tikili tese sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Makolalese, falawa Yutase tiyapola: kipila tesile, yopolotela kemi mowa hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutase hapalapita: Yesuyewi selese, “Sena Sa:wa Nekeye. Ne penaiya kiyawa popita: yemiwa Neyewi kima waloma:na:keye. Newa emi tese Kote penaiyawana kima waloma:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Alake Kote penaiyawa walosaleke Ne penaiyawana Koteyewi walopesakeye. Yemiwa waloma:na: ikila amowa mapatotakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ne sala, ikila sopoke kiwalapulu Newa maelaposakeye. Kolotea elapepela: sikape kiyawa Newa kelepesakeye. Newa hanapitekiwa kiwa Newanapulu ninipe hanakamakiwa eta: ilimanakeye. Solo weyamowa puwano Neyewi Yu sena tililama seyakeye. Seya semeteiwa kamona Neyewi kima selakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Alake solo elewa hili pa:ta Neyewi kima se tiye kinakeye. Kiwa kilipe ki kene himu hapa matanepela: sita:latipa:. Neyewi kiwa himu hapawa matanepela: ela amunuse kiyawa kilipe kemi epapuluse himu hapa matanepela: sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aluse himu hapa matanese sitalapitekiwa sena kesale sosolo amoke potapola: selese, ‘Iwa Yesu kulu hanosene sena kesale epalakeye,’ aluse selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimone Pitayewi selese, “Piseikio, Kewa kami ha:na:na:na?” Au selapita: Yesuyewi selese, “Newa fiyama:na: amowa yemi kewa kulule hanose hanakamakiwa eta: ilimanakeye. Sikape kewa ha:na:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Au selapita: Pitayewi selese, “Ko:lupita: newa yemi kulule hanose maha:na:na: seleseye? Neyewi Kewa matanese Kewamopela: newa kulapose eta: mapolosemakeye.” ");
INSERT INTO khs_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Au selapita: Yesuyewi selese, “Kewa Newamopela: heneye kuma:na:na? Alamakeye, ta:ta:pa:. Neyewi kema heneye selakeye. Kokono seta: kayamawemi keyawa ‘Yesuwa neyewi eta: potesemakeye.’ Aluse keyawa ikila usulupe mokopo selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesuyewi E sena ilipe hanosema selese, “Kiyawa sosolo matanepela: himunama tepa. Kotema himu semetei matanepela: sita:latipa:. Nemawala himu semetei matanepela: sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nine Ni Ata koawemi, koane numu muta sitalakeye. Koane numu muta eta: telamakiwa Neyewi kima aluse eta: sema:na: telamakeye. Kiwa hepene falemi hanosekiwa sita:pesa:na: koawa Newa puwano hanosekiwa kiwamopela: seila:pa:na:pela: ha:na:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Newa hanapola: kiwamopela: koane heke tiye, iliye tiye apola: sikape Newa elakemi peleya: ninipe semetei sita:pesena:pela: kiwa silima:na:pela: Newa mene mina:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Alake Newa elakemiwa peleya: fiyama:na: isuwa kiyewi matanesekeye.” ");
INSERT INTO khs_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Au selapita: Tomaseyewi selese, “Piseikio, Kewa epesene peleya:wa niwa tikili tekeye. Isuwala, niwa tikili tekeye.” ");
INSERT INTO khs_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Aputa: Yesuyewi selese, “Isuwa Nekeye. Heneye selesewa Nekeye. Kokolo kao tese mouwala Nekeye. Sena kesale nowa ni Ata elakemi peleya: ha:na:na:wa Newa talaleye tiye mahanaposakeye. Newemi himu semetei sita:newa hanaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kiyawa Newa heneye matanesaleke Nine Ni Atawala matanesekeye. Napu yemiwa ni Ata kiyawa potapola: matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Aputa: Filipiyewi selese, “Piseikio, Ki Atawane nima waloma. Walopita: niyawa potapola: selese wa:ke waloma elawa eta: sema:na:makeye.” ");
INSERT INTO khs_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Aputa: Yesuyewi selese, “Ikila sopoke Newa kiwalapulu enekeye. Alawamona Filipio, kewa Newa mamatanepa? Kiyawa Newa potosaleke Nine Ni Atawala potakeye. Ko:luma:na:pela: Ki Ata waloma, e seleseye? ");
INSERT INTO khs_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Neyewi Ni Atawemi elakeye. Ni Atawane Newemi elakeye. Na:nipe kekene tiyapola: semetei kamunuse sitalakeye. Filipio, nano amowa keyawa mamatanepa?” Aluse E sena ilipe hanosewa sopoma Yesuyewi selese, “Kima nano sowa kina weyamowa Neye Nine matanawamunuse kima se tiye makinakeye. Alawamona, Ni Ata Newemi ela: Eyewi penanose timinisewa walopita: Neyewi timiyanakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Neyewi Ni Atawemi opola: ela:, Ni Atayewi Newemi opola: ela:, epapuluse na:nipe semetei kamunuse sitalakeye. Ne solo seya weyamowa himu semetei mamatanepa? Kiyawa ma seli ta:tiyapitekiwa amowa, Ne penaiya epe tiseya kiyawa siyewi potapola:, Newemi himu semetei matanepa:. ");
INSERT INTO khs_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Neyewi heneye selakeye. Sena kesaleyewi Ne sowa ta: tiyapola: himu semetei sita:laleke, Neyewi timinisene epapuluse sena kesale amokiwa aluse timinipesakeye. Newa Ni Ata ela falemi hanosekiwa, kiwa Neyewi nano timinisewa sitiyetiye kiwa nano sosolo timinipesakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kiyewi Newemi himu semetei sita:laleke Ne unuwa puwano matanese kulukulula:sela: nano ketea aupa:, esaleke, Neyewi auma:na:keye. Ni Atayewi penaiya sosowa sena sopoke popita: kiyawa aupa: esaleke, Ene E Sa:le Neyewi auma:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kiyewi Newemi himu semetei sita:laleke Ne unuwa puwano matanese nano ketea sopoke aupa:, esaleke nano ketea sopoke Neyewi auma:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Kiyewi Nema himu hapa matanese sitalapitekiwa Ne solo elewala kiyewi ta:tapola: kulu hanose kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aputa:, Neyewi Ni Atama ta:potose, kiwa sesemita: Seselesene Sena pa:ta, Ho Napolo hamonopa:, au sema:na:keye. Aputa: Ho Napoyewi kiwa sesemita: Ni Atayewi hamonapesakeye. Hamonapita: inaposakeye. Inisekiwa Ho Napolo kiwalapulu kokolo kao elaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ho Napowa Heneye Selesene Howa Ekeye. Ho Napowa peleya: we mokopo sena kesaleyewi, ‘Niwanapulu semetei epesa,’ elawa eta: selesemakeye. Eyewi alusewa iyewi eta: potesemakeye. Aputa: Ewa iyewi eta: matanesemakeye. Alawamona kiyewi Ho Napowa matanesekeye. Alake, yemiwa Ho Napolo kiwalapulu elakeye. Sikape kili himu matanawemi semetei semetei epela: Ho Napowa elaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aputa: kiwa alale sala epapuluse sita:pesita: Neyewi kiwa maiya:taposakeye. Newa ki salo mene mina:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aputa: ikila kolotea tepela: eta: topuma sena kesaleyewi peleya: sosolo we sita:la: Newa wa:ke mapotaposakeye. Alawamona, kiyawa Newa potaposakeye. Newa kokolo kao epesenanase, kiwala kokolo kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ikila emiwa Newa Atawemi ela:, apula: kiwa Newemi ela:, apula: Newa kiwemi ela:, epapuluse ninipe sopoke semetei sita:la: kiyewi matanema:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ne solo elewa ta:tapola: kulu hanose sena kesale amoke Nema himu hapa matanesekeye. Nema himu hapa matana sena kesale amowa Nine Ni Atayewi himu hapa matanepesakeye. Sena kesalema, Neyawana himu hapa matanepesakeye. Iyewi Newa heneye seli matanemita: Neyewi alusewa ima waloma:na:keye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Aputa: Yutaseyewi Yesuma nano seyakeye. Alawamona Isekeleote sena Yutase Yesu siheleya amakeye. Eyewi E taiya Yutase nowamo selese, “Piseikio, Keyewi alusewa nima semetei walose, mokopo sena kesalema eta: waloma:na:makeye, au selakamowa ko:lu seleseye?” ");
INSERT INTO khs_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Aputa: Yesuyewi selese, “Sena kesaleyewi Newemi himu hapa matanesaleke Ne sowala sena kesale amoke ta:tapola: kulu hanaposakeye. Ta:tesene sena kesalema Nine Ni Atawala himu hapa matanepesakeye. Sena kesale alapulu Ni Ata Na:ko: inise sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Aputa: sena kesaleyewi Newemi himu hapa eta: matanamanase, sena kesaleyewi Ne sowa ma ta:taposakeye. Ne solo kinapita: kiyewi topuwa Neyewi Nine matanawa kima se tiye mimakeye. Ni Atayewi Newa hamone E matanawa Neyewi kima se tiye mikeye. ");
INSERT INTO khs_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yemiwa Newa kiwalapulu a elekiwa se tiye kinakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Alawamona, sikape, Ni Atayewi Ne unuwemi kiwa sesemita: Seselesene Sena Ho Napolo hamonapesakeye. Inisekiwa kiyewi nano sopoke matanese matanemita: Eyewi se tiye kinaposakeye. Neyewi selapita: kiyawa topuwa wa:ke matanemita: kili himu fa:nemi Ho Napoyewi matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Aputa: Neyewi o:sulu hopola tesewa kima kinakeye. Peleya: weyemi senayewi o:sulu hopola tesewa kima epapuluse eta: kinisemakeye. Neyewi hopola tesewa kima kinapita: kiwa himunama tese ipilise sitalatepa. ");
INSERT INTO khs_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Neyewi puwano selese, ‘Newa kiwa iya:pela: Newa fiyanapola:, sikape kiwa epesita:ya mene mina:na:keye.’ Au seyawa kiyewi topukeye. Kiyewi himu hapawa Newemi matanesaleke, Nine Ni Ata elakemi fiyama:na: e seyawa ta:tapola: epelese matanepa:. Ni Atawane hene heneye putupela: ela:, Ni Ata fa:se Newa elakeye. Ewa elakemi Newa hanaposakeye au seyawa kiyewi ta:tapola: epelese matanepa:. ");
INSERT INTO khs_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Newa a ha:na:na:no ela weyemiwa kima selakeye. Ne sowa kiyewi ta: timita: sikape auma:na:wa, yemi Neye kima selakeye. Newa hanapitekiwa kiwa potose Ne sowa ta: tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aputa: kima selese ikilawa iya:pa:na: mapatotakeye. Peleya: weyemi piseiki Setene mina:na:wa mapatopita: elakeye. Seteneyewi ene penaiyayewi Newa eta: sulu tiye toliyetisemakeye. Eyewi Nema epapume selapita: Neyewi eta: ta: tisemakeye. ");
INSERT INTO khs_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ni Atayewi epapume selapita: Neyewi ta: tisekeye. Ni Atama Neyewi himu hapa matanesekeye. Neyewi Ni Atama himu hapa matanepela: enewa sena kesale sopoke matanemita:, Nine Ni Atayewi epapume selapita: Neyewi ta: tisekeye. Aputa: yemiwa Ne sowa kakeye. Kiwa sopoke tesima. Niwa hanakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesuyewi selese, “Heneye mei kalepe mou Nekeye. Mei kalepe alekena inawa Ni Atakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Newemi i elewa opola: apola: ela: fowa eta: heyamawane, alekena inayewi elewa amowa nasolo tiye sotukalesekeye. Aputa: elewa opola: apola: ela: fowa heyawa wa:ke helemita: ele senatowa mou honosane nanesekeye. Nanapita: mou emi wa:ke howapola: fo muta napolo watosekeye. ");
INSERT INTO khs_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Alake kiyawa Ne sowa ta: tinase kiwa mane olokeyatelawa Ne solo amoke nasolo tiye sotukaiyakeye. Alanase, kiwa papaya sita:la:keye. ");
INSERT INTO khs_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kiwa Newemi elatipa:, Newana, kiwemi ema:na:, epapuluse ninipe semetei kekene tiyapola: sita:pesena:keye. Mei kalepe elewa peleya: hela: ene matanese fo eta: helesemakeye. Mei kalepe elewa mouwemi opola: apola: elapita: fo watosekeye. Fowa wata: elakemi aluse kiyawa Newemi himu semetei opola: apola: sita:la: seli tima:na: tiye hanose sita:pesena:keye. ");
INSERT INTO khs_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mei kalepe mou Nekeye. Mei kalepe elewa kiwakeye. Sena kesaleyewi Newemi opola: apola: sitalapita:, Neyewi mou emi ipi falela elewa hanapola:, fo wata: sita:la: epapuluse kiwa aluse sitalaposakeye. Newemi opola: apola: eta: telamake, fo eta: heyama sita:la: epapuluse kiwa aluse sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Newemi opola: apola: eta: telamakiwa sena kesale amowa mei kalepe elewa na tiye iya:tesene epapulakeye. Nasolo tiye iya:tapola: onose olo tisekeye. Olo ti amowa iya:tapola: sopoke kekenepela: sako tiye teiwemi kilisekeye. ");
INSERT INTO khs_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kiyawa Newemi himu semetei matanese sita:laleke, Ne sowa kiyewi ta: tiyapola: matanese kulu hanose tima:na: tiye hanapola:, kiwa Nema epapume selapita: Neyewi auma:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aputa: fo muta helesene epapuluse Newa kulu hanosene sena kesale kilipe kiyawa hene heneye napolo sitalaposakeye. Apula: sitalapita: sena kesale nokamoke potapola: Nine Ni Atawane wapilima:na:keye. ");
INSERT INTO khs_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ni Atayewi Newemi himu hapawa matanepela: ela epapuluse, Neyawana kiwa epapuluse himu hapawa matanepela: elakeye. Neyewi himu hapa matana amunuse kiyawa iya:tapa. Kokolo kao tiye sita:latipa:. ");
INSERT INTO khs_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ni Ata sowa Neyewi ta:tiyapitekiwa Ni Atayewi Newa kaluse himu hapawa matanepela: elakeye. Matanepela: ela epapuluse, Ne solo elewala kiwa ta:tiyapitekiwa, kiwala, Neyewi kaluse himu hapawa matanepela: epesena:keye. ");
INSERT INTO khs_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ne epelesewa kiwemi sita:pesita: Neyewi kima selakeye. Kiyawa sosolo epelese ekela ilise hapomita: matanekeye. ");
INSERT INTO khs_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne solo elewa wekeye. Neyewi kiwa himu hapawa matanese epa hanoseyamunuse aluse, kiyawa kilipe kemi epapuluse himu hapa matanepa:. ");
INSERT INTO khs_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Senayewi e sena manawa kakasilise kuma:na:wa amowa, himu hapa matanawa hene heneye puwanokeye. ");
INSERT INTO khs_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ne solo elewa kiyawa ta:tapola: kulu hanosaleke kiwa Ne manakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yemiwa kima Neyewi tima:na: tisene senakeye, au seyawa alamakeye. Koiyawemiye, tima:na: tisene senama inayewi ene matanawa eta: selesemakeye. Aputa: Ni Atayewi Ne sowa nano sopoke kima Neyewi selakeye. Sena e manama selesene epapuluse Neyewi kima selakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kiyewi Newa ta:pele tiyapola: eta: silimakeye. Neyewi kiwa ta:pele tiyapola: silikeye. Alake mei fo wata: kao epesita:ya aluse kiwa aumita: Neyewi kiwa siliyapola: ta:pele tiyapola: nano tima:na:pela: hamona seyakeye. Hamonapita: kiyewi Ne unuwa wapilise matanepela: sita:la:, Ni Atama epapume selapita: Eyewi aupesakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Aputa: Neyewi kima solo elewa kina wekeye. Kiyewi kilipe kemi nowamoke nowa himu hapa matanepela:, apula: nowamoke nowa himu hapa matanepela: aluse sita:latipa:.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Aputa: Yesuyewi selese, “Sena kesaleyewi peleya: sosolo weyemi sita:ne kima mapolosekiwa, Nema puwano mapoyawa, kiyewi matanepa:. ");
INSERT INTO khs_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kiwa mokopo senawanapulu palakiwa iyewi kima himu hapa matanemapekeye. Alawamona Neyewi kiwa siliyapola: ta:peyanase kiwa mokopo senawanapulu eta: palemakeye. Kiwa iwalapulu semetei amunamanase iyewi kima mapolopesakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Puwano Neyewi kima seyawa kepoliyetiyapa. Seyawa wekeye. ‘Tima:na: tisene senayewi ene inawa eta: helete tiye hanosemakeye.’ Aluse puwano Neyewi seyakeye. Alanase mokopo senayewi Newa ikomona amunuse, kiwala ikomopesakeye. Aputa: Ne sowa iyewi ta:tiyapitekiwa, kili sowala ta: tiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kiyewi Newa kulu hanose enase iyawa kiwa ikomopesakeye. Koteyewi Newa hamona e seyawamona iyawa mamatanekeye. ");
INSERT INTO khs_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Newa peleya: weyemi inise mane olokeyatela timinisewa hokato seyakeye. Seyanase ili mane olokeyatela timiyawa hokatolose iya:papekeye. Alawamona Ne sowa iyewi ta:tapola:, mane olokeyatela timiyawa eta: iya:peyamake, kamunuse eta: pote iya:tesemakeye, ili mane olokeyatela amoke iwa kotopesakeye. Alawamona, napute sena kesaleyewi mane olokeyatela timiyawa iya:pita:, Neyewi selapose eta: minamakiwa ili mane olokeyatelawa tikila:pela: kao timinimapekeye. ");
INSERT INTO khs_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Aputa: Newemi mapoya sena kesaleyewi Nine Ni Atamawana mapoloselakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Neyewi penanose timinise aluse, puwano sena semetei nowamoke aluse penanose eta: timakeye. Neyewi penanose eta: timiyamakiwa sena kesale nokamoke matanese, ‘Penanose tisewa niyawa eta: papomakeye,’ au semapekeye. Alawamona Neyewi penanose timiyawa iyawa potapola: pote iya:tese, ili mane olokeyatela timiyawa eta: iya:peyamakeye. Eta: iya:peyamanase iyawa mane olokeyatela amokiwa iwa kotopesakeye. Neyewi penanose timiyawa sena kesaleyewi papokeye. Potapola: kemi Nemawana, Ni Atamawana, mapolose sitalakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Aputa: puwano Kote pukawemi momateyawa wekeye. ‘Iyewi Nema mokopokemi mapolokeye.’ Aluse puwano momate tiye auma:na: seyawa yemi alalakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Aputa: Seselesene Sena, Ho Napolo kiwa sesemita: mina:na:wa Ni Ata elakemi emi inaposakeye. Hene sowa sena kesaleyewi matanemita: se tiye kinapola:, aputa: walopola:, auma:na:pela: inaposakeye. Ni Ata ela falemi hanosekiwa Ho Napoyewi kiwa sesemita: Neyewi Ni Atama selese, Ho Napowa hamonopa:, au sema:na:keye. Au selapita: Ni Atayewi hamonapesakeye. Hamonapitekiwa inaposakeye. Inisekiwa Newamo heneye walose se tiye kinaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aputa: peleya: weyemi sila:sela: ela: Neyewi mane ma:ta: tiye timiya ikila emiwa kiwa Newanapulu ninipe sita:nekeye. Ikila sopoke ninipe semetei sita:nenase Neye papowa kiyewi sena kesale nokamawa se tiye kina:pa:.” Aluse Yesuyewi E sena ilipe hanosema seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yesuyewi E sena ilipe hanosema selese, “Kiyewi Newemi himu semetei matanawa iya:pa:pekitise, sikape auma:na:wa yemi Neyawa nano ketea sopoke kima se tiye kina wekeye. ");
INSERT INTO khs_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sikape Newa eta: kulu hanosema senayewi kima selese, ‘Yu senayewi kekenesene koane Kotema wapilima:na:pela: inapa,’ au selaposakeye. Iyewi kiwa kumita: sanaposakeye. Sanose selese, ‘Niyewi Kote timinisewa timinise kiwa sanakeye,’ aluse selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sena amoke Ni Atawala Newana eta: matanamanase kiwa ikomopesakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ikomopesakane Neyewi yemi selese weyamowa sikape kiwa ikomoma:na: ikila emiwa Ne seyawa kiyewi matanepesakeye. Matanepela: sita:pesita: sikape auma:na:wa yemi Neyewi kima selakeye. Puwano ninipe semetei sita:newemiwa solo weyamowa Neyewi kima eta: seyamakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yesuyewi selese, “Alake Koteyewi Newa hamona seya amoke peleya: ha:na:na:pelekiwa yemi Neyawa kima selakeye. Selapita: kiyawa Nemawa ta:potose, ‘Kewa kami ha:na:na:na?’ au maselakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Neye selalapita: kiye ta:tese sosolo matanepela: himu nakolose woliyeti elakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Alawamona Neyewi heneye selakeye. Kiwa seila:pa:na: epela: Newa hanakeye. Newa mahanosaleke, Ho Napoyewi kiwa sesemita: mainaposakeye. Newa hanosekiwa Seselesene Sena, Ho Napoma hamonapita: Ho Napoyewi kiwa sesemita: inaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Inisekiwa sena kesale sopoke peleya: weyemi sita:nema semetei semetei esa: selese, ‘Ke olokeyatela timiyawa epakeye. Aputa: mane hekeya alusene sopowa epakeye. Aputa: sena kesaleyewi olokeyatela timiyawa Koteyewi kotopesakeye.’ Aluse Ho Napoyewi walose selaposakeye. Aputa: sena kesaleyewi hele matanawa Ho Napoyewi walopesakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","‘Aluse sena kesaleyewi Newemi himu semetei matanepela: eta: sita:nema tesaleko amowa mane olokeyatelayewi mouwa epakeye.’ Aluse mane olokeyatelayewi mouwa Ho Napoyewi walose selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aputa: heneye hekeya selesene sena amowa Nenakeye, esa: matanemita: Ho Napoyewi kima walopesakeye. Alanase Newa solo se sekepilapita:, Ni Ata elakemi Newa hanapitekiwa kiyawa Newa mapotaposakeye. Eta: potosema ikila emiwa hekeya selesene sena amowa Newa enekeye, aluse kiyewi matanepesakeye. Matanemita: Ho Napoyewi walose selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aputa: kotoma:na: emiwa mouwa Ho Napoyewi kima walopesakeye. Newa peleya: weyemi minanase peleya: weyemi piseiki Setenewa Koteyewi sano tiye toliyetikeye. Sano tiye toliyetiwamona Ho Napoyewi kima walose selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Aputa: nano nokala Neyewi sema:na: elawamona solo sosonase kiyawa ta:tapola: eta: ilimanakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Alawamona Ho Napowa inisekiwa heneye solo mouwa kiyewi matanemita: Eyewi heneye solo sopowa kima se tiye kinaposakeye. Eyewi matanawamunuse maselaposakeye. Ne sowala Ni Ata sowala Eyewi topuwa kima selaposakeye. Sikape auma:na:wana selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Eyewi Newa sosolo meapolaposakeye. Neye alusewa Eyewi kima selaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ni Ata kinawa Ninakeye. Alanase Neyewi alusewa kiyawa matanemita: Ho Napoyewi kima selaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesuyewi E sena ilipe hanosema selese, “Kolotea sitalapepela: kiyawa Newa mapotaposakeye. Alawamona kolotea sitalapepela: kiyawa Newa wa:ke potaposakeye.” ");
INSERT INTO khs_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Au selapita: sena ilipe hanoseyewi i kene sopolo selese, “Yesuyewi Ene selese, ‘Kolotea sitalapepela: kiyawa Newa mapotaposakeye. Kolotea sitalapepela: kiyawa Newa wa:ke potaposakeye.’ Aluse Yesuyewi solo nowa selese, ‘Ni Ata elakemi Newa ha:na:na:nase kiyawa Newa mapotaposakeye.’ au selakamowa mouwa ena selape? ");
INSERT INTO khs_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yesuyewi selese, ‘Kolotea sitalapepela:,’ aluse epe selese amowa mouwa ena selape? Niwa tikili tekeye.” ");
INSERT INTO khs_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Aputa: Yesuyewi selese, “Kolotea sitalapepela: kiyawa Newa mapotaposakeye. Aputa: kolotea sitalapepela: kiyawa Newa wa:ke potaposakeye, aluse Ne selakamakiwa kiyawa ki kene sopolo sowa me keketakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Neyewi kima heneye selakeye. Newa sanose kulusekiwa peleya: weyemi Newemi mapolose sita:ne sena kesaleyewi sosolo epelepesakeye. Alawamona kiyawa Newamopela: kete matanese ya:pelepesakeye. Alawamona, kiyawa Newa wa:ke potosekiwa iya:peyawa iya:pela: kipila epelepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aputa: sala ha:na:na:wa kesale tomawa oiya kinisekeye. Kesipela: sala tiyapola: hela:, toma oiyawa, itapa tepela:, kepoliyetise, epelese helesekeye. Sala hili kesilanase epelese kinisekeye. ");
INSERT INTO khs_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Alusene amunuse yemi kiwala himu nakolose sitalakeye. Alawamona, kolotea sitalapepela: Newa mene tesilapola: kiwa popa:na:pela: inapitekiwa, kiwa epelese sitalaposakeye. Kili epelesewa kaluse sitalaposakeye. Sena nowamokiwa kili epeya epa matiyaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","24","Newa mene tesile hanapola: hepene falemi hanakemi ikila emiwa kiyewi nano semetei Nema eta: ta:pa:na:makeye. Ni Atama ta:tapola: kulukuluma:na:keye. Kiyewi Ne unuwa puwano putupela: matanepela: Ni Atama epapume selapita: Eyewi aupesakeye. Puwanowala yemiwana Ne unuwa puwano putupela: matanepela: kiyewi Ni Atama epapume seyamakeye. Sosolo epelese ekela sita:pesena:pela: Ni Atama epapume selapita: Eyewi aupesakeye. Neyewi kima heneye selakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesuyewi E sena ilipe hanosema selese, “Puwano Neyewi kima pale seyakeye. Aluse sikape Ni Atawamo Neyewi hokato hokatolose sema:na: ikilawa mapatotakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ikila emiwa kiyewi Ne unuwa puwano putupela: matanepela: sita:la:, kiyewi kilipe kemi Ni Atama ta:taposakeye. Kiwamopela: Neyewi Ni Atama ta:pa:na: eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Alake, Newa Kotewemi tese minawa kiyawa ta: tiyapola:, apula: kiyawa Newemi himu hapa matanepela: amunanase Koteyewi kiwa himu hapa matanepela: elakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ni Ata enewemi tese Newa peleya: weyemi minakeye. Inapola: kolotea elapepela: peleya: we iya:pela: Ni Ata enewemiwa falemi wa:ke fiyama:na:keye.” ");
INSERT INTO khs_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Au selapita: sena ilipe hanoseyewi selese, “Keyawa pale seyawa iya:pela:, yemi nima hokato hokatolose seleselakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nano sopoke Keyawa matanese hanatakeye. Niyewi Kema ta:popa:na:wa, a ta:tapose Keyewi Kine matanese selesekeye. Alanase Kewa heneye Koteyewi hamona seyakeye, aluse niyawa matanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Aputa: Yesuyewi selese, “Kiyewi Nema heneye himu semetei matanepela: sita:la:? ");
INSERT INTO khs_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ikila koloteawemi sitalapepela:, kiyawa Newa iya:pela: kiwa kili koane kalikalilawemi nesile hanaposakeye. Nesile hanapita: Newa Nine Ninapotane epesa:na elawamona Ni Ata Newanapulu elaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kiyewi Newemi himu semetei sita:la: ipilisewa itapa tepela:, o:sulu hopola tesewa ekela sita:pesita:, sikape auma:na:wa Neyewi selakeye. Peleya: we senayewi kiwa ikomopesakeye. Ikomopita: kemi, eta: ipilamake penana:pela: sita:latipa:. Peleya: we Nema kisi tepela: sita:ne sena kesale amowa Ne penaiyayewi sano tiye toliyetiyaposakeye.” Aluse Yesuyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesuyewi E sena ilipe hanosema selese itapa tepela:, hepene falemi pote kulukuluse, “Ni Atao, Keyewi puwano auma:na: seyawa ikila weyemiwa hetetiyakeye. Neyewi Kewa solomita: Keyewi Kine Sala Newa wapilise sekepila:pa:. ");
INSERT INTO khs_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sena kesale peleya: sosolo we sita:ne sopoke Neye Piseikipela: potapola: epesita: Keyewi Newa apoyakeye. Alanase sena kesale Keyewi ta:pele tiyapola: Nema miwa Neyewi iwa pota: ela:, kokolo kao sita: tesewa imawa mikeye. ");
INSERT INTO khs_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Alake kokolo kao sita: tesewa mouwa wekeye. Ni Atao, heneye Kote semeteiwa Kewakeye. Aputa: Yesu Keleso peleya: weyemi hamona e seyawa Nekeye. Nemawala Kemawala himu semetei matanepela: sita:ne sena kesale amowa Na:ko:lapulu semetei kokolo kao sitalaposakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Keyewi Nema aluse timinisewa Neyewi timini tiyapola: tikeye. Tiyapola: tinase Kewa solose enene sena kesaleyewi matanemita: Neyewi waiyakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ni Atao, peleya: weyamowa a hetetima:na:no Newa Kewalapulu solose ho:liya enekeye. Solose ho:liyawa enene epapuluse wa:kiwala, epapuluse solose ho:liya elapose Keyawa Nema kina:pa:. ");
INSERT INTO khs_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Peleya: weyemi sena sopoke sita:newa Keyawa potapola:, noka keye ta:pele tiyapola: siliyapola: Nema mikeye. Alanase Keyawa Nema mini sena amowa Keyawa Kine alusewa matanemita:, Neyewi waiyakeye. Sena amowa puwano Ke sena sita:nekeye. Aputa: Keyewi sena amowa Nema mikeye. Mini sena amoke Ke sowa heneye ta: tiyapola: timiyakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Aputa: Ne penaiya tima:na: fa:ne tiseyane mouwa Ke tapo minanase iyewi matanekeye. ");
INSERT INTO khs_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Keyewi selese sepapowa Neyewi imawa se tiye mikeye. Se tiye kinapita: iyewi seli topukeye. Newa Kewalapulu puwano enewala, Keyewi Newa hamona e seyawala, iyewi ta: tiyapola: matanekeye. ");
INSERT INTO khs_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iwa Keyewi sesemita: Neyewi kulukulula:la:keye. Aputa: Kema mapoya sena amopela: Neyewi eta: kulukululamakeye. Keyewi sena siliyapola: Nema miwane Kine kinawa iwamopelekiwa Neyewi kulukulula:la:keye. ");
INSERT INTO khs_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Niwane sopoke na:tewi na:nipe Kinakeye. Apula: Kiwala na:tewi na:nipe Ninakeye. Newemi kulu hanosene senayewi Ne unuwa wapilise waiyalakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iwa peleya: weyemi sitalaposakeye. Alawamona Newa peleya: weyamowa iya:pela:, Kewamo elakemiwa mina:na:keye. Ni Ata Ho:liya, Keyawa Nema mini senayewi Kema himu semetei matanepela: sita:pesita:, Keyawa iwa potapola: elatipa:. Na:tewi na:nipe himu semetei matanese epapuluse aluse, iyawala epapuluse himu semetei matanepela: sita:pesita: sesepa:. ");
INSERT INTO khs_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Newa iwalapulu enene ikila emiwa iwa Neyewi seli pote enekeye. Iyewi Kewa alusewa matanemita: Neyewi iwa potapola: enekeye. Potapola: elapita: iwa eta: mene hapamakeye. Alawamona sena semetei nowa ene mene ikomonose ene matanawamunuse mene hapakeye. Ke pukawemi momate tiye aupesakeye, au seyawa heneye semetei ewamona hetetise elakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Napute, Newa Kewa elakemi mina:na:keye. Newa epelese ela epapuluse iwala sosolo epelese sita:pesita: Neyewi Kema kulukulula:la:keye. Newa peleya: weyemi ela yemi Neyewi iwamopelekiwa kulukulula:la:keye. ");
INSERT INTO khs_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ke sowa Neyewi imawa se tiye kinapita: iyewi seli topukeye. Iyewi ta: tise peleya: weyemi mane timinisene matanawa nasulu tiye iya:peyanase, mokopo sena kesaleyewi imawa mapoloselakeye. Aputa: peleya: weyemi mane timinisene Neyewi eta: matanesema epapuluse iyawala mamatanekeye. Aluse imawa mokopo sena keslaeyewi mapolose sitalakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Iwa peleya: weyamowa iya:pita: Keyawa mene siliya:pa:, aluse Neye eta: kulukululamakeye. Seteneyewi iwa pote epesene ikomoma:pekitise, Keyawa holilise potose elatipa:, aluse Neyewi kulukulula:la:keye. ");
INSERT INTO khs_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Peleya: weyemi mane timinisene Neyewi eta: matanesema epapuluse iyawala aluse mamatanekeye. ");
INSERT INTO khs_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ke sowa heneye sokeye. Hene solo amowa ta: tiyapola: sita:pesita: Keyawa iwa sesepa:. Hene solo emiwa semetei sita:pesita: sesepa:. ");
INSERT INTO khs_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Sena kesale peleya: weyemi sita:nema se tiye miya:na:pela: Keyewi Newa hamona seya epapuluse, iyawala sena kesalema se tiye miya:na:pela: Neyewi iwa hamona e seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Apula:, Neyewi iwamopela: asuwapo Ne falelawa Neye ima sopolo tiye mikeye. Apula:, iwa sena kesale kina hekeye tepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Aputa: iwamopelekiwa semetei Neyewi eta: kulukululamakeye. Iyewi se tiye kinapita: sena kesaleyewi ta: tiyapola:, Newemi himu semetei sita:pesa:na: sena kesale amopela: iwala Neye kulukulula:la:keye. ");
INSERT INTO khs_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aputa: iyewi ilipe nowamoke nowama matanepela:, nowamoke nowama matanepela: epapuluse himu semetei sita:pesita: sesepa:. Ni Atao, Kewa Newemi ela:, apula: Newa Kewemi ela:, epapuluse Na:ko: na:nipe himu semetei kamunuse epesita:ya aluse, iyewi na:ma himu semetei opola:la: tikipela: epapuluse sita:pesita: sesepa:. Alake ta: tisene sena kesaleyewi himu semetei matanepela: sitalapitekiwa, eta: ta: tima sena kesaleyewi potapola: matanese, ‘Koteyewi Yesuma peleya: weyemi hamona e selakeye.’ Aluse iye matanepesakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ke ho:liya alusewa Nema miwa, Neyewi ima ho:liya aluse semetei kamunuse mikeye. Na:nipe semetei kamunuse epesita:ya epapuluse iyawala ilipe semetei kamunuse aluse sita:pesita: Ke ho:liya alusewa ima mikeye. ");
INSERT INTO khs_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kewa Newemi ela:, Newa iwemi ela:, epapuluse ninipe himu semetei sitalakeye. Himu semetei sita:newa eta: ta: tima sena kesaleyawa potapola: selese, ‘Koteyewi Yesuwa himu hapa matanese epa hanoseyamowa epapuluse, ta: tisene sena kesalewala, Koteyewi matanekeye. Aluse Koteyewi Yesu peleya: weyemi hamona seyakeye, au seyawa henenakeye.’ ");
INSERT INTO khs_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ni Atao, Keyewi Nema sena kesale miwa Newanapulu ninipe epesena: tekeye. Peleya: weyamowa ma:ta: tiye seta: timiyama ela: Keyawa Nema himu hapa matanakeye. Matanese Ke penaiya ho:liya napowa Nema mikeye. Penaiya ho:liya napowa Nema miwa iyewi popita: Newanapulu semetei epesena: tekeye. ");
INSERT INTO khs_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ni Atao, Hekeya timinisene mowa Kewakeye. Aluse Ke solo mapoya sena kesaleyewi Kewa mamatanekeye. Alawamona, Kewa Neyewi matanekeye. Keyewi Newa hamona e seyawa Ne sena ilipe hanoseyewi matanese hanatakeye. ");
INSERT INTO khs_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kewa iyewi matanemita: Neyewi imawa waiyakeye. Waiyawa kaluse walose elaposakeye. Alake Keyewi Nema himu hapawa matanese epapuluse aluse, himu hapa matanesewa ili himuwemi matanepiyo. Aputa: Newana iwalapulu semetei epesena:keye.” Aluse Yesuyewi kulukululakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesuyewi kulukulupela: itapa tepela: Yesu tesile koamesa: iya:pela:, Ene sena ilipe hanosewanapulu hanapola:, kukuya kolotea unuwa kukuya Kitolone satepela: hanapola:, i olife alekenawemi hanapola: musuluyetiye sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Aluse Yesu Ene sena ilipe hanosewanapulu alekenawemi ka:la:lomita: hanapola:, alekenawemi wa:ke ka:la:loma:na:pela: hapakeye. Aputa: alekena amowa Yesu sihelelema:na: sena Yutaseyewi potosekeye. ");
INSERT INTO khs_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Potosenase alekenawemi Lome kamani ami senayawana, apula: Kote koane ta:le ti sena potapola: sita:newana Yutaseyewi siliye hapakeye. Aputa: puwano pilisiti senayeliye Felesi sena iyewi ta:le ti senama selese, “Kiwa Yutasewalapulu papela: ha:na:pa:.” Apula: iwa Yutaseyewi siliyapola:, Yesuwa sihelelema:na:ke alekenawemi hanapola:, iyewi tetesene keteawa tiyapola:, napa tutapola:, apula: kotea tu tiye aluse hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Hanapola: inapitekiwa, Yesuyewi potosekiwa Ema nano auma:na:wa Eyewi Ene matanakeye. Yesuyewi E sena ilipe hanosewanapulu ilipe sita:newa, iwa kemi iya:pela:, senayewi Ewa supa:na:pela: mina tapowemi hapakeye. Hanosekiwa Yutaseyewi sena siliye minama Yesuyewi selese, “Kiyawa ipi keye ina:?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aputa: Ewa sihelelema:na: sena Yutasewa iwalapulu ilipe kemi elapita:, iyewi sopoke selese, “Nasalete sena Yesuwa niyawa keye minakeye.” Au selapita: Yesuyewi selese, “Nekeye.” ");
INSERT INTO khs_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Aputa: iwa sopoke howa hanose kolotea mene kikiya hanapola:, peleya: kolemi sululuwaya falopela: teselakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sululu polupela: sita:lapita:, Yesuyewi wa:ke selese, “Kiyawa ipi keye ina:?” Au selapita: iyewi selese, “Nasalete sena Yesuwa niyawa keye minakeye.” ");
INSERT INTO khs_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aputa: Yesuyewi selese, “Kima Neyewi selesewamona akeye. Kiyewi Newa keye inise, Ne sena ilipe hanosewa hamonite iya:ta:pa:. Hanapita: kapa,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Aputa: puwano Ewa Kotema selese, “Sena amowa Keyewi Nema miwa, semetei nowa hele eta: sulukepiyamakeye.” Aluse Kotema semeta: supa:na:pela: mina senama Yesuyewi selese, “Sena semetei nowa kiyewi sanapa. Iya:ta:pa:,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aputa: Saimone Pitayewi e sapawa sili tiyapola: pilisiti puwano sena ola:tewi tima:na: tisene sena kena:wa ili noka aloyeti iya:peyakeye. Tima:na: tisene sena amokiwa unuwa Malokuse, e kena:wa aloyeti iya:peyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aloyeti iya:pela: Yesuyewi Pitama selese, “Sapawa keyewi sapa selawatesene hose tekapo hapa emi selawapome. Keyawa Ni Atayewi kapo Nema maite tiye miwa mamaite eseya? Ni Atayewi Newa kuma:na:wa apoyanase himu nakolose, kapo olose kuma:na:keye. Kuma:na:wa maiya:taposakeye.” Au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Aputa: ami senayawana, ili ami yesila senawala, ta:le ti senawana, iyewi Yesu tiya:wa elipe polo tiyapola: sukulu tiye, ");
INSERT INTO khs_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anase koawemi siliye hapakeye. Anase e la:wa Kaiafase tikeye. Yapene emiwa Kaiafase ene pilisiti sena putupela: enekeye. ");
INSERT INTO khs_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Aputa: puwano Kaiafase Yu tilila senama selese, “Sena kesale sopowamopela: sena semetei kulapitekiwa ililakeye.” Aluse Kaiafase seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yesuwa puwano siliye hanapitekiwa, Saimone Pitawala, sena semetei hanosene nowana, sikape kulule hanose hapakeye. Hanapola: pilisiti sena puwano koawemi hanapola:, sena ilipe hanosene elipei mina amoke sena semetei nowamoke pilisiti sena puwanowa potosekeye. Potosenase koane solawa isu tenamo emi musuluyetiye hanapola:, Yesuwalapulu koane peleya: pakiawemi hanapola: sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita himini inapola:, isu tenamo mowa tapowemi elapita:, sena semetei hanosene nowa puwano hapawa isu tenamowemi mene minakeye. Mene inapola: solawa isu tenamo pote tesene kesalema selese, “Pita minite isu tenamo kola:pa:na:wa ililapa?” Apula: kesaleyewi ili selapita:, isu tenamowa kola:pela: silikeye. Kola:pelapita: Pita inapita: ");
INSERT INTO khs_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","kesaleyewi ema selese, “Yesu sena ilipe hanosene nowa Kewama?” Au selapita: Pitayewi mokopo selese, “Nemakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Aputa: ta:le ti senawana, pilisiti tima:na: tisene senawala potulupita: tei kilipela: wa:pita:, tiya: teiwemi ofolose pota:la: sita:newanapulu, Pitawala tei ka:ma:na:pela: inapola:, iwalapulu ilipe sita:nekeye. ");
INSERT INTO khs_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pitawa sena nokalapulu kekenepela: tei ofolose sita:newanapulu, pilisiti sena puwanoyewi Yesuma selese, “Keyawa Kine sena ilipe hanosewa ipa:? Senayewi matanemita: Keyawa ena walo selesena?” Aluse Yesuma ta:potapita:. ");
INSERT INTO khs_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Aputa: Yesuyewi selese, “Sena sopoke ta:pita: Neyewi hokato seyakeye. Yu senayewi kekenesene koawana, Kote koawana, epemi Yu sena inapola: kekenepitekiwa se tiye mikeye. Neyawa o:suluwemiwa nano semetei eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ko:lupita: Keyawa Nema ta:ta:? Ne solo miwa topu senama ta:pota:pa:. Ne sowa iyewi ta:tapola: matanepela: sitalakeye. Ima ta:pota:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Au selapita: ta:le ti sena semetei nowamoke Yesu mitiwemi sanakeye. Sanapita: penanose selese, “Keyawa pilisiti sena ola:pema aluse selapa.” ");
INSERT INTO khs_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aputa: Yesuyewi selese, “Neyewi olokeyatela selapita: keyawa topu sena sopoke ta:pita: sema. Neyewi heneye selapitekiwa kemi ko:lupita: keyawa Newa sanoseye?” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Aputa: Yesu E tiya:wemi pololawa kaluse epesita: kemi, Anaseyewi ta:le ti senama selese, “Sena amowa pilisiti sena puwano Kaiafase kotomita: siliye ha:na:pa:.” Aluse Anaseyewi seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Anaseyewi aluse seya ikila kemi Pitawa tei ofolose elapita: sena nokamoke ema selese, “Sena amokiwa sena ilipe hanosene sila:tesene Kewama?” Au selapita: Pitayewi mokopo selese, “Nemakeye,” au seyakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aputa: pilisiti sena puwano tima:na: tisene sena e kena:wa Pitayewi aloyeti iya:peya e manayewi selese, “Kewa i olife alekenawemi Ewalapulu elapita: Neye papowa Kewama?” ");
INSERT INTO khs_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Au selapita: Pitayewi wa:ke mokopo selese, “Nemakeye.” Au selapita:, ikila emiwa a:nema: kokonowa kayakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kiapo ikiwatapita: kemi, Kaiafase koawa iyewi iya:pela: kamani sena putupela: elakamoke koawemi Yesuwa siliye hapakeye. Siliye hanapola: senawa Yu senama, e koane Yu sena eta: musuyemakeye. Koane Helepa:pe Matanema:na:pela: Tikinima:na:pela: Yu senayewi matanese, “Yu senamawalapulu koane ilipe kekenepela: sita:la:, sikape tikinise ikila emiwa nano kewa eta: ilimanakeye. Koiyawemiye, musuluyetisaleke, iwa Kote sikapowemi eta: papayamakeye.” Aluse matanese kamani sena koawemi eta: musuyemakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yu sena musuluyetiye mainapita: Pailate tesile e koawa iya:pela: mowa popa:na:pela: hapakeye. Hanapola: imawa selese, “Sena amawa kiyewi nano kotoka, nano enanopela: kotoma:na:na?” ");
INSERT INTO khs_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aputa: iyewi selese, “Eyewi olokeyatela eta: timiyamakiwa kewa elakemi siliye maminapekeye.” ");
INSERT INTO khs_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aputa: Pailateyewi selese, “Kiyewi kili solo elewa elakeye. Aluse kiyewi kilipe kemi Ewa kotopa:.” Aputa: Yu senayewi selese, “Kiwa Lome kamaniyewi selese, ‘Sena sana kuma:na:wa kiwa Yu senayewi nemakeye. Niwa Lome senayewi nekeye’”. ");
INSERT INTO khs_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iyewi seta: seyamake puwano Yesuyewi selese, “Sikape Newa i kelipapoya papita: sanose kuma:na:keye,” au seyawa yemiwa heneye kalusekeye. ");
INSERT INTO khs_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Aputa: Pailate e koane mene hanose Yesuma mina e seyakeye. Ewa inapitekiwa Pailateyewi selese, “Yu sena piseikiwa Kewama?” ");
INSERT INTO khs_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Au selapita: Yesuyewi selese, “Keyawa kine matanawamunuse, ‘Kewa piseikile?’ aluse ta:ta:? Sena nowamoke kema selapita: keyawa Nema ta:ta:?” ");
INSERT INTO khs_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Aputa: Pailateyewi selese, “Newa Yu senamakeye. Neyewi Kewa falasimita: Keyawa Kine sena maya Yu senayawala, pilisiti sena sosoyawala, Kewa siliye minakeye. Ke olokeyatela timiyawa, nano ena olokeyatela timiyana?” ");
INSERT INTO khs_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Aputa: Yesuyewi selese, “Peleya: weyemi Neyewi Piseikipela: pote maelakeye. Peleya: amowa Neyewi pote Piseikipela: elakiwa Newa supa:pekitise, Ne sena ilipe hanoseyewi Yu sena tililawalapulu tepapekeye. Tepa:na:pela: elawamona peleya: weyemi Newa Piseikipela: eta: enemanase eta: tepemakeye.” ");
INSERT INTO khs_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Aputa: Pailateyewi selese, “Alake, Kewa Piseikiya? Aputa: Yesuyewi selese, “Newa piseikiwa keyawa selese akeye. Keye epe selese amowa Newa seleselakeye. Heneye solo miya:na:pela: Newa peleya: weyemi minakeye. Heneye solo tapowemi sita:ne sena kesaleyewi Ne sowa ta:tesekeye.” ");
INSERT INTO khs_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aputa: Pailateyewi ta:potose, “Heneye sowa enana?” au seyakeye. Pailateyewi ene koawa iya:pela: mowa hanapola:, Yu sena tililama selese, “Ewa falasima:na:pela: elawamona E olokeyatelawa eta: timakeye. ");
INSERT INTO khs_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Koane Helepa:pe Matanema:na:pela: Tikina ikila sopoke sena tipolo sela semetei nowa neyewi silikepilisekeye. Yemiwa kiyawa Yu sena piseikiwa silikepima:na:na?” ");
INSERT INTO khs_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aputa: iyewi unuwapo holose, “Aupa. Ewa silikepilapa. Palapasewa semetei silikepila:pa:,” au seyakeye. Palapase ewa nano atu tiye tete esene senakeye. ");
INSERT INTO khs_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pailateyewi Yesuwa siliye e koawemi hanapola:, ami senama sama e selapita: meiyewi sanakeye. ");
INSERT INTO khs_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Alake Lome ami senayewi Yesuwa itipilise mei ona sita:ne kopotiye hekelese Piseiki sosolo ha:ti ta:pele tiyapola: timiyawa Yesu piseiwemi kataopola: apoyakeye. Aputa: piseikiyewi sao napolo i okane fo ipi mutusene epapula amoke popona amo Yesu kapela: apola: ");
INSERT INTO khs_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","itipilise selese, “Yu senayewi piseikiwa Kewakeye. Kewa niyawa wapilikeye.” Aluse selese E mitiwemi iyewi tiya:yawa sanakeye. ");
INSERT INTO khs_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sanapita: Pailateyewi e koawa wa:ke iya:pela:, Yu sena kekenama selese, “Kiyawa popita: wa:ke Neyewi Yesuwa siliye minakeye. Ewa falasima:na:pela: elawamona Eyewi olokeyatelawa eta: timiyamanakeye.” ");
INSERT INTO khs_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Au selakamake Yesuwa mei ona sita:newa piseiwemi kataopola: apola:, piseikiyewi sao keyalo kapela: apola:, aluse Pailateyewi koawa iya:pela: mowa tapowemi inapitekiwa, Pailateyewi selese, “Sena Ewa epe iniseya pota:pa:?” ");
INSERT INTO khs_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Aputa: pilisiti sena sosoyawala, ta:le ti senayawala Yesu potosekiwa unuwapo holose, “Ewa i kelipapoya papela: kepema. Ewa i kelipapoya papela: kepema.” Au selapita: Pailateyewi selese, “Kiyewi kilipe Ewa siliye hamona. Siliye hanapola: kiye kipitane Ewa i kelipapoya papela: kepema. Eyewi olokeyatela timiyawa neyawa mamatanekeye.” ");
INSERT INTO khs_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Aputa: Yu sena tililayawa selese, “Niyewi solo elewa tuwatese, ‘Kote kolotea meapolose selesene sena amowa sana kula:pa:.’ Aluse solo elewa tuwaponase Yesuyewi selese, ‘Newa Kote E Sa:keye,’ au seyanase Ewa sana kula:pa:.” ");
INSERT INTO khs_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Au seya selapitekiwa Pailateyewi ta:tapola:, sosolo ipilise enekeye. ");
INSERT INTO khs_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ipilise ela: Yesuwa siliye e koane mene hanapola: Yesuma selese, “Kewa peleya: nono kami minana?” Alawamona Yesuyewi nano solo nowa wa:ke eta: seyamakeye. ");
INSERT INTO khs_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Sowa eta: seyamake Pailateyewi selese, “Kewa nema nano maselatakeye. Ko:luse eseye? Kewa i kelipapoya papela: sana kuma:na:wala Kewa mene silikepima:na:wala neyewi auma:na:keye. Amowa neyewi hekelesekeye. Kewa mamatanepa?” ");
INSERT INTO khs_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Au selapita: Yesuyewi selese, “Keyawa auma:na:wa keyewi kine matanawamunuse auma:na:keye. Alawamona, Koteyewi henekeyepita: kewa auma:na:keye. Kewa Newa kotopela: falasimita: senayewi Newa siliye minawa e olokeyatelawa hene sosokeye.” ");
INSERT INTO khs_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Aputa: Pailateyewi ta:tapola:, Yesuwa silikepima:na: matanakeye. Silikepima:na: au selapitekiwa, Yu sena sopoyawa holose, “Aupa. Silikepilisaleke, Lome kamani piseiki Sisa kewa mana matepesakeye. Sena amokiwa selese, ‘Newa Piseikipela: elakeye.’ Au seya sena amowa Sisawalapulu kisi tepela: elakeye. Alake sena amowa keyawa sesewatesaleke Sisa kema kisi tepesakeye.” ");
INSERT INTO khs_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Aputa: Pailateyewi ta:tapola: Yesuwa siliye e koawa iya:pela: mowa hanapola:, falasima:na:pela: kotosene senayewi sea henekeye. Kotoma:na: senayewi sea enene amowa, peleya: unuwa Etewa Semenesekeye. Yu sena solopela:la:wa unuwatese Kapata unuwapokeye. ");
INSERT INTO khs_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aputa: Koane Helepa:pe Matanema:na:pela: Tikina Kekenema:na:wa eliwemi auma:na:nase napu sena kesale sopoke nano ketea sopoke hekelesekeye. Aputa: hekelesene ikila emiwa opo kukuwemi (12) hetetiyapita: Pailateyewi Yu senama selese, “Pota:pa:, kili piseikiwa ekeye.” ");
INSERT INTO khs_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aputa: iyewi unuwapo holose, “Ewa siliye hamona. Ewa siliye hamona. Sanose i kelipapoya papema.” Au selapita: Pailateyewi selese, “Kili piseikiwa i kelipapoya papema, aluse neyewi aluse semita: eselele?” Aputa: pilisiti sena sosoyewi selese, “Nini piseiki sosowa kamani piseiki Sisa ewa semeteikeye.” ");
INSERT INTO khs_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Alanase Pailateyewi ene ami senama selese, “Yesuwa i kelipapoya pamita: siliye hamona.” Aputa: iyewi Yesuwa siliye hapakeye. ");
INSERT INTO khs_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesu siliye hanapola: i kelipapowa Yesuyewi Ene tiyapola: hapakeye. Hanapola: pisei ki peleya: emi hanapola: sita:nekeye. Peleya: amowa Hipulu solopela:la: unuwapowa Kokata peleya:keye. ");
INSERT INTO khs_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Peleya: emi Yesuwa i kelipapoya palese kepeyakeye. Kepela: sena elipei amowala i palese, nowa Yesu tiya: ili tapowemi kepeyakeye. Nowa Yesu tiya: hukalo tapowemi kepeyakeye. Kepela: Yesuwa honosane kepeyakeye. ");
INSERT INTO khs_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Kepela: apola: Pailateyewi nano momateyakeye. Momateyawa wekeye. “Yesuwa Nasalete senakeye. Yu senayewi piseikiwa ekeye.” Aluse Pailateyewi momateyawa e ami senayewi tiyapola:, Yesu pisei wapa:kemi fala papeyakeye. ");
INSERT INTO khs_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yesu i pape