﻿USE sofia;
DROP TABLE IF EXISTS sofia.khj_vpl;
CREATE TABLE khj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES khj_vpl WRITE;
INSERT INTO khj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ɔrɔ ɔmɔmɔrʊ Itiyofolus, orokru na pany wɔrɔ bikywi ʊʊma sini ʊsi bi idɔɔ eri. ");
INSERT INTO khj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Orokru men wɔri arʊ nɛmɛr kǝni sini akʊng, orong bi tee ni. ");
INSERT INTO khj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Imyɛ kam, ipyerhe ʊʊmamen noshushong nɛmɛr wroo bai itee, Irii ini igyang iwɔrɔ atananw nɛmɛr kǝni ushoyoni ari ɔmɔmɔrʊ Itiyofalus. ");
INSERT INTO khj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aki ʊkpɛrhi ngɛ nashisha asani imisini ɛmɛr nwʊ ʊbrʊbrʊwɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Akywa dang Ihiridus ngee ani ogumo Iyahudiya, Ogoku Ʊnʊng nʊwɔ amisini ayirhi ʊtʊwa ngɛ ni Izakariya. Arʊ sini okuni bai edei ʊna Ogoku Abija. Kǝnawɔ eree Alisabatu kaa okuni bai edei Iharuna Ogu ubyen Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Izakariya kǝni eree Alisabatu kukumo aki nashisha bite Ʊnʊng. Asa nɛmɛr kǝni sini ɛwɛi bi ogro Ete pɛri ni. ");
INSERT INTO khj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Asamɔ ni ɔnɔɔ, bɛkɛi sini Alisabatu saa ni ubyere ngɛ. Eme ɔkɔrɔmɔ kukummo. ");
INSERT INTO khj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Akywa ka fwa sini Izakariya kǝni orobyoo amu ʊna Abija ani bi ʊtina, ani owroo ʊsa ʊtina ogoku bi ite Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Apari wɔ oko shoo nʊ uworo nge kǝni sini ɛrɛn uworo ogoku, ɛngɛɛ nʊ raa ubyen Ʊnʊng Ete aka pya ɛnyɛ ʊnyang ʊduduma. ");
INSERT INTO khj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sini akywa ʊpya ɛkǝri ɛnyɛ ʊnyang ʊduduma fwa, kukum orokru ni besing asʊ sɔrhɔ Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Atina Ete ko kuno bi itee, ka ting ba avu ʊra ʊnara ɛnyɛ ʊnyang ʊduduma. ");
INSERT INTO khj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Akywa sini Izakariya rii ɛkǝri atina Ʊnʊng aka kung irung nge asuya owroo ");
INSERT INTO khj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Atina Ʊnʊng ka sani, “Izakariya bekya kung irung! Ʊnʊng kʊng ʊsɔrhɔnw, erenw Alisabatu nʊ byerenw ɛnɛ ɛrimɛ, inyi nʊ yirha ʊtʊwa ngɛ ni Iyohana. ");
INSERT INTO khj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Anʊ konyi ofofuru ba, orokru napany nʊmɛ ni ubyere nge. ");
INSERT INTO khj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Anʊ shoo ɔrɔ mɔmɔrʊ eberi Ete. Ana ʊsaa omung inabi ko akama, wroo bai idɔɔ ofo akwaa Ering Ʊshisha nʊ shoo kǝni ɛngɛ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anʊ tere arʊ Isrela na pany ke ba eberi Ete Ʊnʊng mɔ. ");
INSERT INTO khj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Anʊ kpite Ete, akywa sini eye ba, eye ba ni ʊring kǝni ikrʊ edei eying ni Iliya. Anʊ tere ikywi ɛkpɛri kya eberi ɔnɔmɔ, etere ikywi arʊ larha amraa ke kya ɛsɛr ara amraa asa iminisi ini nɛgbɛn, anʊ kyene orokru okyo asʊ ʊsha ukye ba Ete.” ");
INSERT INTO khj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Izakariya ko gyurho atina Ʊnʊng ka sani, “Ini sa nenyee kǝ kperhi ni iring yen nʊ tirɛ? Imye we ito ɛkpɛri, erem kaa ɔkɔrɔ ngɛ nagang.” ");
INSERT INTO khj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɛkǝri atina Ʊnʊng ka sani ɛngɛɛ ni, imyɛɛ ni Ijebrilu. Ko ikina ikpara ini bi ite Ʊnʊng. Ɛngɛɛ atʊmim iba pya onuo ni ɔnwɔ atananw iring ididima yen. ");
INSERT INTO khj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bai kaimen ʊnʊ rana na kprʊkpring ʊna sʊ branw ʊpya onuo kekya ʊnʊng sini ʊring men nʊ tirɛ, bi ɛkɛi sini unoyorong ni iring mi, imisini inʊ tirɛ akywaa ba fwa. ");
INSERT INTO khj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Bakywa sini atina Ʊnʊng kʊ pɛrɛ ni Izakariya orokru kʊ shaa besing, akasʊ wɔrɔ ofo ikimɔ yɔ isi Izakariya dɛrhi ngɛ kǝn bi ubyen Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Akywa sini obo kuno ana braa ʊpya onuo ni ɔmɔ, orokru kǝ kperhi ni ara ni ɔmɔrʊ bidɔɔ ubyen Ʊnʊng, ʊwɔɔ Izakariya kʊ pɛrɛ ni ɔmɔ ni ivʊ bau ʊbra ʊpya onuo. ");
INSERT INTO khj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Akywa sini awri ʊtʊna ngɛ tirɛ Izakariya kɔsɔɔ ngɛ apya. ");
INSERT INTO khj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Anakywa naji eree Alisabatu ka kpin ofo kasa ipɛri itong bau ukuno esing. ");
INSERT INTO khj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Aka sani, “Ete karha sam inyen ima,” “Ete sam ima ididima, oworom ʊwaa bi eberi orokru.” ");
INSERT INTO khj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Akywa sini ofo Alisabatu fwa ipɛri iten, Ʊnʊng ka tʊma atina ngɛ Ijebrilu kya apya sini ayirhi ʊtʊwa yɔ ni Inazaret bi ibʊng Igalili, ");
INSERT INTO khj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kya eberi adira sini ɛnɛkpɛrhi ngɛ ɛrɛrimɛ sini owo lorho ʊbarha Isufu ɛyɛri Idouda. Ʊtʊwa ɛkǝri adira ni Imeri. ");
INSERT INTO khj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Atina Ʊnʊng kii eberi ngɛ, iku fong, ka sani ngɛ ni, “Ʊnwʊɔ ʊni arʊ sini Ʊnʊng wɛinwʊ nagang! Ete ni kǝni ɔnwɔɔ.” ");
INSERT INTO khj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Imeri kǝ pen uwure ngɛ nagang ni iring ngɛ, kasʊ wɔrɔ ofo ni akyina edei ufo ni kǝn. ");
INSERT INTO khj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ɛkǝri atina Ʊnʊng ka sani ɛngɛɛ ni, “Imeri bekya kung irung, kii upen ʊyirha eberi Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ʊnʊ kpara ofo ebyere ɔnɔ ɛrɛrimɛ, ʊnʊ yirha ʊtʊwa ngɛ ni Iyesu. ");
INSERT INTO khj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Anʊ shoo ɔrɔ mɔmɔrʊ, anʊ yirha ngɛ ni Ɔnɔ Arayaya Ʊnʊng, Ete Ʊnʊng nʊ maa igɔgɔrʊ Igumo Ɛkpɛri ngɛ Idouda. ");
INSERT INTO khj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Anʊ kong igumo ʊna Iyakubu ishishaa, igumo nge sayo na akʊrha ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Imeri ko gyurho atina Ʊnʊng ni “Iring yen nʊ shoo nenyee wo, imyɛ arʊ sini inɛ kpɛrhim ɛrɛrimɛ?” ");
INSERT INTO khj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Atina Ʊnʊng ko yoro ngɛ ka sani, “Ering Ʊshisha nʊ shuro ba yanw, ikrʊ Ʊnʊng ara yaya nʊ franw. Bi kǝna Ɔnɔ sini ʊnʊ byere anʊ shoo nashisha, anʊ yirha ngɛ ni Ɔnɔ Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kǝnawo arʊpyanw Alisabatu nʊ byere ɔnɔ bi idɔɔ ʊkɔrɔ ngɛ. Kǝni sini akpari ni anasʊ ubyere ngɛ ni, nɛchiyɛn okofo ipɛri iten, ");
INSERT INTO khj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","bai ima sini igyi ni Ʊnʊng ʊsa.” ");
INSERT INTO khj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Imeri ko yoro ni, “Ina agara Ete ngɛ” kǝni sini ʊpɛri ni ishoo kǝna bi ikywim. Atina Ʊnʊng ka shere ngɛ akyaa. ");
INSERT INTO khj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Akywa dang, Imeri ko tuno ʊʊma akpin ʊtira nekǝkǝrhe kyaa ki opyo apya ki oyokro sini ayirhi ni Iyahudiya. ");
INSERT INTO khj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sini afwi ɛkǝri apya, aka raa ʊna Izakariya, oko rong Alisabatu nge ofoo. ");
INSERT INTO khj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ni sini Alisabatu kʊng ufo Imeri Ɔnɔ idɔfoo kǝyin ni ɛmɛ, Ering Ʊshisha karaa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aka takpa ayaya kani: “Ʊnʊng tanw onuo adadʊma. Ʊnʊng ta Ɔnɔ sini ʊnʊ byere onuo adadʊma. ");
INSERT INTO khj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ikisi Ʊnʊng pri ni ʊwaami kǝn, sini ogro Etem nʊ ba bi owrom? ");
INSERT INTO khj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ikpara sini ikʊng ihywi oshongnwu, ɔnɔ idɔɔ ofom kǝ yin ni ɛmɛ. ");
INSERT INTO khj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ʊnʊng ta arʊ sini oyori ni Ete nʊsa ima sini ɛpɛri bi ikywi ngɛ onuo adadʊma!” ");
INSERT INTO khj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Imeri ka sani, “Ipam dɔɔ Ete ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kǝnawo ʊring mi ku mɛ ni imisini Ʊnʊng mi arʊsam oforo sim, ");
INSERT INTO khj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kii adirha ni ɛmyɛ agara ngɛ arʊ sini akpari ʊkaa atata. Bai kaimen kukum orokru nʊ yirham ni arʊ ofofuru ");
INSERT INTO khj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kii Arayaya sam nɛgbɛn. Ʊtʊwa ni ashisha. ");
INSERT INTO khj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ese kʊng okwo arʊ sini akʊng irung ngɛ, bai ituo kyekya ituo. ");
INSERT INTO khj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ʊnʊng sarʊ ʊring ujujire ni avuɔ, eyeri arʊ fwa igɔng bidɔɔ ikywimo, ");
INSERT INTO khj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","oshuro ogumo bi igɔgɔrʊ igumo mo, eke shwe arʊ sini akpari ʊkamɔ atata ayaya. ");
INSERT INTO khj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ama arʊ kʊng ihywʊng ʊmʊduduma, Aka shirha arʊ shoo nʊ ʊmaa avu akʊrʊ. ");
INSERT INTO khj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ekǝ shɛ agara ngɛ Isrela, ka dirha ni okwo, ");
INSERT INTO khj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kya eberi Ibraim kǝni ɛyɛri ngɛ ishishaa, kǝni sini atani ɛkpɛri arʊ ni.” ");
INSERT INTO khj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Imeri kikii kǝni Alisabatu nge, etekya ʊsa ipɛri itaru ko shoo nʊ sɔɔ ngɛ kidɔɔ Ʊnaa. ");
INSERT INTO khj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sini akywa fwi ami ubyere Alisabatu ekǝ byere ɛnɛɛrimɛ. ");
INSERT INTO khj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ariyoyou kǝni arʊpyaa akʊng sini Ete kʊng okwo ngɛ nagang ɛkǝ mɛ kǝni ɛngɛɛ. ");
INSERT INTO khj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sini Ɔnɔ fwa awri ochupari, aka ba ushoo igang, aka waa ʊyirha ngɛ ni ʊtʊwa ɛkpɛri ngɛ Izakariya, ");
INSERT INTO khj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Akwa ɔnɔ ka sani, “O-o anu yirha ngɛ ni Iyohana.” ");
INSERT INTO khj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aka sani ɛngɛɛ ni, “Bi idɔɔ arupyanw ararʊ saa ni ʊtʊwa dang ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Oko gyurho ɛkpɛri ɔnɔ ni ivu ʊwaa ʊkpɛrhi, ni ʊkina ʊtuwawɔɔ ɛwɛi ni ama ɔnɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ekǝ yen ni, amaa ima ʊwɔrɔ. Ikʊ iyang ko gyo avu bi kɔw nisini ɔwɔri, “ʊtʊwa ni Iyohana”. ");
INSERT INTO khj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Akywakywa dang onuo kɔ furɔ irimɛɛ ka shire, akasʊ pya onuo, asu dɔɔ Ʊnʊng ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kukum arʊ iyoyow ka kʊng irung, kukum bi ibʊng oyokro Iyahudiya orokru ku pɛrɛ ʊring men kukum. ");
INSERT INTO khj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ikuyaa sini akung iring yen akasu wɔrɔ ofo bi ikywimɔ ko gyurho, “Ɔnɔ wen anushoo ikimɔyɔ?” Kii Ete niskǝni ɛngɛɛ. ");
INSERT INTO khj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ʊring Ʊshisha kǝ tirɛ ɛkpɛri ngɛ Izakariya, ka tana itina Ʊnʊng: ");
INSERT INTO khj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Arʊ dɔ Ete, Ʊnʊng Isrela, kii ɛngɛɛ abii eberi aruo asamɔ oforo. ");
INSERT INTO khj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɛshinɛ arʊ ni arʊ sa oforo ɛrɛrɛ baa ʊduna agara ngɛ Idouda ");
INSERT INTO khj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(kǝni sini ɛpɛri uwruwroo ni bi onuo arʊ tana onuo Ʊnʊng ʊshisha), ");
INSERT INTO khj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ani ɛngɛɛ nʊsa arʊ oforo bai avu arʊ sini atiirʊ bi ite, kǝni bai ivʊ arʊ sini ana waamɔ arʊ ");
INSERT INTO khj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ka kʊng okwo ɛkpɛri arʊ aka dirha ni imi sini olorhi iring nashisha, ");
INSERT INTO khj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ɔkɔ kro ukro kǝni ɛkpɛri arʊ Ibraim kani: ");
INSERT INTO khj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","anʊ karha arʊ bavu arʊ sini ana waamɔ arʊ, sini arʊ nʊ sa ʊtina ngɛ bai irung ");
INSERT INTO khj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","arʊ nʊ sa ʊtina ngɛ shoo nashisha, ʊpʊpʊrhi bite Ʊnʊng kukum bi ʊkiki arʊ bi eyesing. ");
INSERT INTO khj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Ʊnwɔ, ɔnɔm, anʊ yirhanw ni arʊ tana onuo Ʊnʊng Ayaya, unuvo Ete ngɛ ite ʊkya ukyene nge ʊtira, ");
INSERT INTO khj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ʊnʊ tana orokru ngɛ ani anʊ pen oforo akywa sini Ʊnʊng nʊ pʊnanyi ʊyanyi, ");
INSERT INTO khj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","bekai sini okwo Ʊnʊng ni ɔgrɔɔ Ʊnʊng nʊ marʊ arʊ sa oforo kǝni sini Ʊnʊng nʊta arʊ baa ayaya ni, ");
INSERT INTO khj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ata arʊ shoo idɔɔ eting kǝni idɔɔ uwru ukpo, ekyeng ni arʊ bi ʊtira ʊyari ikywi.” ");
INSERT INTO khj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ɛkǝri ɔnɔ ko fɔnɔ kasa ikrʊ bi idɔɔ ʊring Ʊnʊng, aka kiki bi idɔɔ orumo kekya akywa sini okuni eyen ʊkaa owro ɔnɔ Isrela. ");
INSERT INTO khj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ba kywa dang, Agostus, arʊ sini ɛngɛɛ ni Ikaisar okong Igumo ibʊng Irom, aka ta okro asani apara orokru kukum bi igumo Irom. ");
INSERT INTO khj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Uwen wo ʊni ʊpara orokru itee sini apari akywa sini Ikwirinus okong igumo ibʊng Isiriya.) ");
INSERT INTO khj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ikʊyang ka kyaa ki apyaa aki apara ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Kǝnawɔ Isufu sheri Inazaret ngɛ bi Igalili kyaa ki Ibetalami bi ibʊng Iyahudiya ba apya Idouda. Okuni baw ʊdʊna edei Idouda. ");
INSERT INTO khj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Aki aparamɔ kǝni Imeri sini owo lorho ʊbarha ngɛ, akywa dang Imeri kong ofo ɔkɔng. ");
INSERT INTO khj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Akywa sini eshi bi Ibetalami akywa ka fwa sini anʊ byere ɔnɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ekǝ byere ɔnɔ itee, ɛnɛɛrimɛ, aka gǝrha ngɛ ni arigidi bi ʊbɔrʊ upiri anama aka yara ngɛ bidɔɔ ukyo, bekai sini baw ʊbɔrʊ bi ʊna ekyeng sini oshuri ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bi ɛkǝri ibʊng asha nuo kyi orumo akʊ sha inaa ni eting. ");
INSERT INTO khj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Atina Ete ko kuno bi itemo, uyen ʊmʊmɔrʊ Ʊnʊng ka ta ɛkǝrimɔ, aka kʊng irung. ");
INSERT INTO khj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ekǝri atina Ʊnʊng ka sanomoni, “Inyi bekya kʊng irung. Ikony iring ididima yɔ ba, imi ofofuru nagang imi orokru kukum. ");
INSERT INTO khj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ɛchiyɛ ebyerenyi arʊsa oforo kya apya Idouda ɛngɛɛ ni Ikristi, Ete. ");
INSERT INTO khj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Imisini inyi nʊ rong ʊpɛ inyi kǝ kpɛrhi ngɛ a sani Ikʊ tananyi ʊbrʊbrʊ wɔɔ, inyi nʊ darha ɔnɔ agǝrhi ngɛ ni arigidi aka yara ngɛ bidɔɔ ukyo.” ");
INSERT INTO khj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bi akywakywa dang Atina Ʊnʊng napany ko kuno baa ayaya aba darha Atina Ʊnʊng itite dang akasʊ dɔɔ Ʊnʊng ngɛ a sani, ");
INSERT INTO khj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Arʊ dɔɔ asa Ʊnʊng ngɛ ija, bidɔɔ ayaya, ayarhi omung, ofofuru bi eyesing kyekyaa eberi arʊ sini Ʊnʊng kʊng idimamɔ.” ");
INSERT INTO khj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Akywa sini ɛkǝri atina Ʊnʊng juri kyamɔ ayaya esheremo asha ka sani opyoomo ni, “Arʊ kyeng ki Ibetalami oyorong ʊʊma men sini ʊsini kǝni sini Ete tana arʊ ni.” ");
INSERT INTO khj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aka kyamɔ nekǝkǝrhe ko ri Imeri nge kǝni Isufu ka darha ɔnɔ yari bidɔɔ ukyo bi ʊbɔrʊ anama. ");
INSERT INTO khj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Akywa sini asha roo, aka tana mɔ, imi sini ɛkǝri Atina Ʊnʊng tanimɔ bɛkai ɛkǝri ɔnɔ. ");
INSERT INTO khj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kukum arʊ sini ʊkʊng iring sini asha pɛri, ekǝ jijire nge. ");
INSERT INTO khj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Imeri kɔsɔ ʊring men kukum kasʊ wɔrɔfomo bidɔɔ ikywie. ");
INSERT INTO khj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ɛkǝri asha ko juro kyamɔ idɔɔ rumo mo, kasʊ taa ɛtɛ ʊdɔɔ Ʊnʊng ngɛ bekai imi sini akʊng, orong kǝni sini atina tanimɔni. ");
INSERT INTO khj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Akywa sini ɛkǝri ɔnɔ fwa awri ochupari oko shoo igang ka yirha ngɛ ni Iyesu, ʊtʊwa sini Atina Ʊnʊng mie oko shoo nʊ ʊkpara ofoo. ");
INSERT INTO khj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sini akywa fwa amisini anʊ kurho inamaa kǝni sini ogro Imusa pɛri ni Imeri kǝni Isufu nʊ naa ɔnɔ, oko kong Iyesu ngɛ ki Urushelima aki anaa ngɛ bavʊ Ete, ");
INSERT INTO khj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","s(kǝni sini ɔwɔri bi ogro Imusa, “ko kina ɛnɛɛrimɛ sini ebyeri ngɛ bitee anʊ naa ngɛ nashisha bi avʊ Ete.”) ");
INSERT INTO khj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aka naa ikara kǝni sini ogro Ete pɛri asani, “ukrim ʊpari ko ɔnɔ uukure ʊpari.” ");
INSERT INTO khj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bi akywa dang opyo orokru nuo bi Urushelima ayirhi ʊtʊwa ngɛ ni Isimiyon, ani nashisha ami ikywi bi ʊring Ʊnʊng, akʊsha akywa sini Ʊnʊng nʊ ta ɔnɔ Isrela ikrʊ, Ering Ʊshisha ni kǝni ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ɛkǝri ering Ʊshisha kǝ yennge asani anasu kpoo ba, anʊ ri ikristi sini Ete tʊmi. ");
INSERT INTO khj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ering Ʊnʊng ka kpara ngɛ kyekya ʊgba ubyen Ʊnʊng. Akywa sini arʊ byere ngɛ a rii ni Iyesu aki anaa ngɛ kǝni sini ogro Imusa peri ni, ");
INSERT INTO khj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Isimyon ka yirha ngɛ ko koo bi ʊvʊ kɔ dɔɔ Ʊnʊng ngɛ, ka sani: ");
INSERT INTO khj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ete kukum, kǝni sini ʊpɛri ni nɛchiyɛn, shirha agaranw ni ʊyari ikywi. ");
INSERT INTO khj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kii ikram rong oforonw, ");
INSERT INTO khj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","amisini ukyeni bi ikra orokru no kukum, ");
INSERT INTO khj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ɛngɛɛ nʊ shoo uyen ʊfʊrɔ ikra arʊ sini ɛnɛkpɛrhimɔ Ʊnʊng, ɛngɛɛ nʊ shoo uyen sini ʊnʊ konw ʊdɔ ba bi owro orokrunw Isrela.” ");
INSERT INTO khj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ekǝri ekperi kǝni akwaa ɔnɔ ko gyo avu bi kɔw kasu wɔrɔfo imisini ɛpɛri bekai ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Isimiyon katamɔ onuo adadʊma ka sani Imeri akwaa ni, “Ɔnɔ wen nʊ kong ʊkpaa ba kǝni ʊshinɛ orokru napany bi Isrela, anʊshu shoo ɛpɛ sini orokru nasu waamɔ. ");
INSERT INTO khj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kǝnawo anʊ kpɛrhi imisini ini bidɔɔ ikywi orokru ngɛ. Ʊnʊ kʊng ʊra kǝni oturi ikywinw ni Ikama ʊraa ni.” ");
INSERT INTO khj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Opyo arʊ pɛrɛ onuo Ʊnʊng nuo ayirhi ngɛ ni Ana, ɔnɔ Ipenuwel enere okuni bai Ipya Ashar. Ɔkɔrɔ ngɛ nagang, a kii ʊbara kǝni ɛrimɛ ngɛ ɛnyɛɛ etensara, ");
INSERT INTO khj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ɛrimɛ ko kpoo. Aka ki baa ɛrɛrimɛ kyeba nɛchiyɛn ani ɛnyɛɛ isochupari na narhi. Ko ikina ikpara ani bi ubyen Ʊnʊng. Eting kǝni awri akʊ dɔɔ Ʊnʊng, ukusɔrɔ kǝni ʊsɔrhɔ. ");
INSERT INTO khj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Aka raa akywa sini Isimyon kʊ pya onuo akasa Ʊnʊng ngɛ ija, ka tana arʊ sha ʊring bi ikywi ɛkǝri ɔnɔ asʊ ku ikra ni ukye ba arʊ sini anʊ be shire arʊ Urushelima. ");
INSERT INTO khj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Akywa sini Isufu kǝni Imeri kywɛrɛ ikukying sini ogro Ete peri ɔkɔ sɔɔmɔ Igalili kya apyamɔ Inazaret. ");
INSERT INTO khj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ɛkǝri ɔnɔ kɔ fɔnɔ kasi ikrʊ, kǝni amraa, epen ʊyirha eberi Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ko kina ɛnyɛɛ arʊ byere ngɛ esekyer ipara ʊwɔrɔ bi Urushelima. ");
INSERT INTO khj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Akywa sini Iyesu ni ɛnyɛɛ atarhi na pari aka kya ipara kǝni sini asirhi ni. ");
INSERT INTO khj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Akywa sini ekyweri ipara arʊ byerenge kasu kyeng sɔɔ mɔ, ene yemo asani Iyesu ɔnɔmɔ rana ngɛ be Urushelima. ");
INSERT INTO khj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Aka sʊ kpara asani Iyesu ni kǝni ɔmɔɔ, bi ɛkǝri ukyeng akywa sini ekyeng okyoro awri eying ono romo ngɛ. Akywa dang oko kuno upyerhe ngɛ owro arʊpya kǝni orokyoro. ");
INSERT INTO khj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Akywa sini ono rongmo ngɛ oko juro kyamo Urushelima upyerhe ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Akywa sini asi awri atarʊ aka kya aya darha ngɛ bi idɔɔ ubyen Ʊnʊng akiki bidɔɔ avwa asʊ kung mɔ kǝni ugyurho mo ʊring. ");
INSERT INTO khj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ko iyaa sini akwʊɔ ekǝ jijire nge bɛkai ʊkpɛrhi kǝni uyoro ʊring ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Akywa sini arʊ byere ngɛ rie ekǝ jijire nge, akwaa ko gyurho ngɛ, “Ɔnɔm ikisi ʊsirʊ kǝn? Imyɛ kǝni ɛkpɛrinw arʊ pyerhenw ko kywa ube arʊ no romo nwɔ.” ");
INSERT INTO khj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Iyesu ko gyurho, “Ikisi inyi ku pyerhem? Inyi ne yeny asani itɔɔyo ishoo bi idɔɔ ʊna Ɛkpɛrim?” ");
INSERT INTO khj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ɛnɛ kpɛrhimɔ imisini akʊ tanamɔ. ");
INSERT INTO khj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Oko juro kyaa Inazaret kǝni arʊ byere ngɛ kakʊng imisini aruo tani ngɛ akwaa ko kong ʊring men kukum bi idɔɔ ikywie. ");
INSERT INTO khj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iyesu ko fɔnɔ, kǝtire ni amraa kǝ epen ʊyirha bi owro Ʊnʊng kǝni orokru. ");
INSERT INTO khj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bidɔɔ ɛnyɛɛ atarhi ni ɔtɔng ami igumo Ikaisar arʊ sini ayirhi ngɛ ni Itibariya, akywa dang Ipontos Ibilatus kɔn ibʊng Iyahudiya, Ihiridus shoo ogumo Igalili, arupya Ifilibus ku igumo Ituruya kǝni Itarakunitas, Ilisaniyas kaa oshoo ogumo Abiliya. ");
INSERT INTO khj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Bakywa dang Annas kǝni Ikayafas ani ogu ubyen Ʊnʊng. Bakywa dang Ʊnʊng ka ma Iyohana ɔnɔ Izakariya ngɛ itina ikpara sini ani bi idɔɔ orumo. ");
INSERT INTO khj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iyohana kǝkǝri kukum ʊbʊng ʊkʊkǝri Ugro Ijodan, asu tana irhing Ʊnʊng, “Inyi tere eshere ʊya ngɛ aki asany ibaptisma, Ʊnʊng nʊpʊna ʊya nyi ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kǝni sini ɔwori bidɔɔ ʊyaa ʊsha iring arʊ pɛrɛ onuo Ʊnʊng Ishaya ni: “Ihywi opyo arʊ ku yirha bi idɔɔ orumo, ‘Kyene Ete ngɛ ʊtira, kyene ngɛ ʊtira itituku. ");
INSERT INTO khj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ku kǝni ukwoo anu tirɛ wɔ, ku kǝni ukro kǝni ʊvra anu wurho wo okyo nɛmɛr, Itira ugugumo nʊ nawa itituku, itira ʊgbragbrarha nʊ sa igyang. ");
INSERT INTO khj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Orokru kukum nu rong oforo Ʊnʊng.’ ” ");
INSERT INTO khj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iyohana ka sani ʊshi orokru sini okuni asu kyeng ba aki asamo Ibaptisma ni, “Inyi ɔnɔ iyow ibibi! Iyaa taniny ni inyi ting anang Ʊnʊng sini akye ba? ");
INSERT INTO khj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Inyi si imi sini inu yen asani inyi tere baa ʊyany. Inyi bekya tikpa ʊsa nʊ opyo nyi ni Ibraim ngɛ ni ekperi arʊ. Kii itani nyi ni Ʊnʊng nʊ shu ukyene Ibraim ngɛ ɔnɔ ni atari yen. ");
INSERT INTO khj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ikywerhe karha to ba para ashi, kǝnawo ku kǝni ʊshi sini uno sumowo ɔnɔ adadʊma anu kpawo ɛfɛn kidɔɔ ʊra.” ");
INSERT INTO khj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ushi orokru ko gyurho, “Arʊ nʊ sa nenyee nɛchiyɛn?” ");
INSERT INTO khj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Iyohana ko yoromo, “Arʊ sini ani ʊgbɛ ʊpari ngɛ ama arʊ sini asa ni yoo, arʊ sini oboshoo ni ʊmʊra ngɛ kaa asa kǝna.” ");
INSERT INTO khj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Arʊ yirha ogon kamo abii aba samɔ Ibaptisma oko gyurho ngɛ, “Avuwa, ikimoyo arʊ nʊ sa?” ");
INSERT INTO khj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Iyohana kasani moni, “Karhi inyi kya yirha epiri imasini inyi tani ʊyirha.” ");
INSERT INTO khj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ikpara dang opyoo arʊ tɛi ikɔ ko gyurho ngɛ asani, “Arʊ ni sa nenyee wo?” Oko yoromo asani, “Karha inyi kya karha ʊfɛ bavu araru ni ikrʊ, boshoo orokru sesa ima inyi sani asayo, inyi yoro ni ima sini akʊ kpurany.” ");
INSERT INTO khj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Orokru kasu yoro ʊsha asu tiri ikywi ni arʊ sa oforo, kukummo akasʊ wɔrɔfo asani kii inushe ushoo asani Iyohana ngɛ ani ɛkǝri Ikristi. ");
INSERT INTO khj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Iyohana ka yoro mo kukum, “Isiny Ibaptisma ni omung. Yip opyo arʊ sini eprimi ni imɔru yeba, sini ko iwe ataka ngɛ isamam ushereyo. Anu sany Ibaptisma ni Ʊring Ʊshisha kǝni ʊra. ");
INSERT INTO khj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ʊfrɔɔ ʊpɛrhɛ ngɛ ni ba avu sini ani puna ʊgba ʊpɛrhɛ ngɛ otuno ikiri ogro asa kidɔɔ ɔfɔ, anu pya ɛkǝri iwung ni ʊra sini unokpowo.” ");
INSERT INTO khj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Iyohana kɔ wɔɔ atung ɛkǝri orokru bekai ʊring napany nisini akʊ tanamɔ ʊring Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yip ni sini Iyohana tani ogumo Ihiridus ngɛ ʊyaa ngɛ bekai ubara ngɛ kǝni Ihirudiya ere arupya Ifilibus, kǝni kukum eteting sini asi, ");
INSERT INTO khj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ihiridus kojo sa opyo eteting ba aya anyan ngɛ. Sini asi aka afri Iyohana ngɛ bidɔɔ ʊbɔrʊ eting. ");
INSERT INTO khj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sini Iyohana kywɛri ʊsa orokru Ibaptisma kukum, aka sa Iyesu ngɛ Ibaptisma kaa. Ni sini akʊ sɔrhɔ Ʊnʊng ayaya kayewe. ");
INSERT INTO khj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ering Ʊshisha ko shuro bayaa ani kǝni Ikrim ni. Ihywi ko kuno ba ayaya: “Ʊnwʊɔ ʊni Ɔnɔm, sini ɛwɛi ngɛ; ini ofofuru ngɛ nagang ni ʊnwɔ.” ");
INSERT INTO khj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nɛchiyɛn Iyesu ʊkaa ete kyu fwa ɛnyɛɛ isitarʊ aka kpin ʊtʊna ngɛ. Ɛngɛɛ ni ɛkǝri ɔnɔ, orokru kasu yirha ngɛ ni ɔnɔ Isufu, Isufu ngɛ ni, ɔnɔ Iheli ");
INSERT INTO khj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ngɛ ni ɔnɔ Imatthat, Imatthat ngɛ ni ɔnɔ Ilevi, Ilevi ngɛ ni ɔnɔ Imelki Imelki ngɛ ni ɔnɔ Ijanni, Ijanni ngɛ ni ɔnɔ Isufu, ");
INSERT INTO khj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isufu ngɛ ni ɔnɔ Imattatias, Imattatias ngɛ ni ɔnɔ Amos, Amos ngɛ ni ɔnɔ Inahum ɔnɔ Esili, Esili ngɛ ni ɔnɔ Inaggai ");
INSERT INTO khj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Inaggai ngɛ ni ɔnɔ Imaat, Imaat ngɛ ni ɔnɔ Imattatiyas, Imattatiyas ngɛ ni ɔnɔ Isemein, Isemein ngɛ ni ɔnɔ Ijosech, Ijosech ngɛ ni ɔnɔ Ijoda, ");
INSERT INTO khj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ijoda ngɛ ni ɔnɔ Ijowana, Ijowana ngɛ ni ɔnɔ Irhesa, Irhesa ngɛ ni ɔnɔ Izerubbabel, Izerubbabel ngɛ ni ɔnɔ Isheyatiyel, Isheyatiyel ngɛ ni ɔnɔ Ineri, ");
INSERT INTO khj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ineri ngɛ ni ɔnɔ Imelki, Imelki ngɛ ni ɔnɔ Addi, Addi ngɛ ni ɔnɔ Ikosam, Ikosam ngɛ ni ɔnɔ Elmadan, Elmadan ngɛ ni ɔnɔ Eri, ");
INSERT INTO khj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri ngɛ ni ɔnɔ Ijoshua, Ijoshua ngɛ ni ɔnɔ Iliyaza, Iliyaza ngɛ ni ɔnɔ Ijorim, Ijorim ngɛ ni ɔnɔ Imattat, Imattat ngɛ ni ɔnɔ Ilevi ");
INSERT INTO khj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ilevi ngɛ ni ɔnɔ Isimiyon, Isimiyon ngɛ ni ɔnɔ Iyahuda, Iyahuda ngɛ ni ɔnɔ Isufu, Isufu ngɛ ni ɔnɔ Ijonam, Ijonam ngɛ ni ɔnɔ Iliyakim, ");
INSERT INTO khj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iliyakim ngɛ ni ɔnɔ Imeleya, Imeleya ngɛ ni ɔnɔ Imenna, Imenna ngɛ ni ɔnɔ Imattata, Imattata ngɛ ni ɔnɔ Inathan, Inattata ngɛ ni ɔnɔ Idouda, ");
INSERT INTO khj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Idouda ngɛ ni ɔnɔ Ijesi, Ijesi ngɛ ni ɔnɔ Obed, Obed ngɛ ni ɔnɔ Iboaz, Iboaz ngɛ ni ɔnɔ Isalmon, Isalmon ngɛ ni ɔnɔ Inashon, ");
INSERT INTO khj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Inashon ngɛ ni ɔnɔ Amminadab, Amminadab ngɛ ni ɔnɔ Iram, Iram ngɛ ni ɔnɔ Ihezron, Ihezron ngɛ ni ɔnɔ Iperez, Iperez ngɛ ni ɔnɔ Ijuda, ");
INSERT INTO khj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ijuda ngɛ ni ɔnɔ Iyakubu, Iyakubu ngɛ ni ɔnɔ Ishaku, Ishaku ngɛ ni ɔnɔ Ibraim, Ibraim ngɛ ni ɔnɔ Iterah, Iterah ngɛ ni ɔnɔ Inabor, ");
INSERT INTO khj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Inabor ngɛ ni ɔnɔ Iserug, Iserug ngɛ ni ɔnɔ Ireu, Ireu ngɛ ni ɔnɔ Ipeleg, Ipeleg ngɛ ni ɔnɔ Iber, Iber ngɛ ni ɔnɔ Ishelah, ");
INSERT INTO khj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ishelah ngɛ ni ɔnɔ Ikɛnan, Ikɛnan ngɛ ni ɔnɔ Arfaza, Arfaza ngɛ ni ɔnɔ Ishem, Ishem ngɛ ni ɔnɔ Inuu, Inuu ngɛ ni ɔnɔ Ilamek, ");
INSERT INTO khj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ilamek ngɛ ni ɔnɔ Imetusela, Imetusela ngɛ ni ɔnɔ Enok, Enok ngɛ ni ɔnɔ Ijared, Ijared ngɛ ni ɔnɔ Imahalale Imahalale ngɛ ni ɔnɔ Ikɛnan, ");
INSERT INTO khj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ikenam ngɛ ni ɔnɔ Enosh, Enosh ngɛ ni ɔnɔ Iset, Iset ngɛ ni ɔnɔ Adamu, Adamu ngɛ ni ɔnɔ Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iyesu shere ugro Ijodan ngɛ, ekǝ tirɛ ni Ʊring Ʊshisha, ɛkǝri Ʊring Ʊshisha ka kpara ngɛ kyaa idɔɔ rumo. ");
INSERT INTO khj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Bi ʊpʊrha wɔ Ishari ka marha ngɛ bi idɔɔ awri isi narhi. Bi idɔɔ awri dang akyana raa iririma, kyeba ba akurha ngɛ ihywunw ka kpin ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ishari kasani ngɛ ni, “Uboshoo ɔnɔ Ʊnʊng sani ʊtari wen ni utere oshoo ʊmʊra.” ");
INSERT INTO khj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iyesu ko yoro ngɛ asani,“Ɔwori bidɔɔ ʊyaa ʊsha Ʊnʊng asani: ‘Saa ni ʊmʊramɔɔ eyeyimo orokru nʊ gya ba.’” ");
INSERT INTO khj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ishari ka kpara Ngɛ ke kya opyo owro sini ani ayaya bi ukro kǝyen Ngɛ kukum igumo eyesing ba anakywa naji. ");
INSERT INTO khj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ishari kasani ngɛ ni, “Inu manw kukum ikrʊ kǝni igyang mo kukum. Amam yo kǝnawo ini shu ma arʊ sini iwa maa. ");
INSERT INTO khj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ubo kpukporo ɔdɔm, inu shoo inwɔ nokukum.” ");
INSERT INTO khj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iyesu kǝ yoro ngɛ asani, “Shinɛ ben Ishari kii ɔwori bi idɔɔ iring Ʊnʊng ni: ‘Ete ngɛ eyeyie ʊnʊ kpukporo asaa ʊtina.’” ");
INSERT INTO khj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ishari ka kpara ngɛ kya Urushelima aka saa utiting kya ayaya ubyen Ʊnʊng, ka sani ɛngɛɛ ni, “Uboshoo ɔnɔ Ʊnʊng, funo baw upen kekya ibʊng” ");
INSERT INTO khj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kii ɔwori bi ʊyaa ʊsha Ʊnʊng ni: “Anu ma atina ngɛ bekai nwu aki asha nwu, ");
INSERT INTO khj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Anu konw ni ivumo, aki ubekya ogyo ifraa bi ʊtari.” ");
INSERT INTO khj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iyesu ko yoro ngɛ, kasani, “Asini: ‘Bekya marha Ete Ʊnʊng nwu.’” ");
INSERT INTO khj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Akywa sini Ishari kweri ʊmarha ngɛ aka shere ngɛ kekya opyo akywa sini anu pen apara. ");
INSERT INTO khj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iyesu ko sɔɔ ngɛ bi Igalili ɛtirɛ ni ikrʊ Ʊring Ʊnʊng. Ɛkǝri ʊring ngɛ ka fwa kukum apya ʊkʊkǝri. ");
INSERT INTO khj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aka sʊmɛr mo bi owro utuno Ayaudiya ikuyang kɔ dɔɔ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Iyesu ka kya bi idɔɔ Inazaret apyang sini asi ɔkɔng ngɛ. Oshoo awri uwuro Ayaudiya aka raa idɔɔ owro utuno Ayaudiya kǝni sini ɛrɛn ʊsirha ni. Ekǝ shinɛ awaw ʊpara, ");
INSERT INTO khj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ʊyaa ʊsha Ishaya arʊ pɛrɛ onuo Ʊnʊng ʊmi sini amie. Nisini akʊ shireyo, oko rong owro sini ɔwori ni: ");
INSERT INTO khj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ering Ete ni bayam, kii akarha akyu worom aki iya tana iring ididima eberi ara ayarha. Atumim itana arʊ sini afrimo bi ʊbɔrʊ eting aki epen ʊgya aki arʊ sini ani ofow epen urong, aki arʊ sini aku rong ayarha bi ivʊ orokru epen ʊgya, ");
INSERT INTO khj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ojo tumam itana ni akywa fwa sini Ete nʊ sa arʊɔ ne nɛgbɛn.” ");
INSERT INTO khj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Okɔ guno ɛkǝri ʊyaa ʊsha, ka nawa ɔnɔ ʊtina ɛkǝri owro utuno Ayaudiya ka kiki. Ikra orokru kukum bi ɛkǝri owro utuno ini bi owroo. ");
INSERT INTO khj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Oko shoo ngɛ ʊtana moni, “Ɛchiyɛ iring Ʊnʊng tirɛ ba atungnyi.” ");
INSERT INTO khj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kukummo ekǝ pɛrɛ ʊring ʊdʊdʊma bi ikywie kǝ jijire ngɛ ni ʊring sini ukuni bai idɔɔ onuo oko gyurho ni, “Sa ɔnɔ Isufu ngɛ wee?” ");
INSERT INTO khj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iyesu kasani mo ni, “Ikpɛrhi ngɛ ni nyi nʊ tanam igbra yen: ‘Avʊwa ikang ma ʊkanw ikrʊ!’ Inyi nʊ tanam, ‘Sa ben ba apyanw imi sini arʊ kung ʊsi bi Ikafarnahum.’ ” ");
INSERT INTO khj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Oko shoo ngɛ ni ʊsani, “Itaniny ʊbrʊbrʊwɔɔ, arʊ tana onuo Ʊnʊng ene pen ngɛ ʊyirha ba apyaa. ");
INSERT INTO khj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Iku tanany ʊbrʊbrʊwɔɔ ani erere sini ɛrimɛ mo kpomo agbugbrii bi Isrela ba akywa Iliya, akywa sini afri ayaya akarha avra ʊkpaa ɛnyɛɛ atarʊ ni uting ngɛ, akai ihywung ka kpaa be ɛkǝri ibʊng. ");
INSERT INTO khj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ʊnʊng kyana tuma ngɛ Iliya ngɛ eye she ararumo ngɛ ba, yip Ʊnʊng katuma ngɛ kekya owro erere sini ɛrimɛ ngɛ kpoo bi Izarifa bai Isidɔn, ");
INSERT INTO khj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","kǝnawo arʊ udumo ʊkɔngnuwo napany bi Isrela ba akywa Elisha arʊ tana onuo Ʊnʊng, bi kǝn Ʊnʊng na ma ararumo ikrʊ, Inaaman ari Isiriya ngɛ eyeyie ami ikrʊ.” ");
INSERT INTO khj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Akywa sini kukum orokru sini anu owro utuno Ayaudiya akung imi sini Iyesu peri, akata anang nagang. ");
INSERT INTO khj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ekǝ shinɛ ɔwɔɔ kya utumo apya okoo kya aya ʊtʊng ʊvra sini avuri ɛkǝri apya ngɛ kii ɛwɛi ʊtaa ivʊ ɛfɛn ni ikywirhikywi aki okpoo. ");
INSERT INTO khj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yip aka sara bidɔɔ ushi orokru ekyeng kyaa. ");
INSERT INTO khj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iyesu kǝ kyeng shuro ngɛ kyaa Ikafarnahum bidɔɔ apya Igalili, akasʊ mɛr orokru bi awri uwuro Ayaudiya. ");
INSERT INTO khj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Orokru kǝ jijire ni ʊmɛr ngɛ, kii ʊring ngɛ ni ikrʊ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bidɔɔ owro utuno Ayaudiya opyo orokru nuwo sini ering ishari rii ngɛ. Aka taa akpa ayaya asani, ");
INSERT INTO khj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Shere arʊ, Iyesu ari Inazaret! Ʊwɛi ikying ni arʊ? Ʊbii ʊwaa ʊpɛrɛ arʊ? Ikperhi ʊni iyaa. Ʊnwʊɔ ʊni ami Ʊnʊng Ʊshisha!” ");
INSERT INTO khj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iyesu ka tana ɛkǝri ʊring ubibi ʊraa ngɛ asani,“Shywi, kuno eshire ngɛ!” Ikpara dang ɛkǝri ʊring ishari ko gyo ɛkǝri orokru bi ibʊng be itemo kukum ko kuno wo bau saa unuru. ");
INSERT INTO khj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kukum orokru ka jijire kasu sani opyomo, “Akina edei ʊring yo ni kǝn? Ni igumo kǝni ikrʊ atani ering ebebi okuno ekǝ kuno!” ");
INSERT INTO khj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Orokru ka su pɛrɛ ʊring sini Iyesu si ɛkǝri ʊring ka fwa kukum apyang ʊkʊkǝri. ");
INSERT INTO khj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iyesu sheri owro utuno Ayaudiya ngɛ aka kyeng kya ʊna Isimon. Akywa dang akwa kyerhe Isimon saa akru inama ngɛ kasi ipi nagang, ɔkɔ sɔrhɔ Iyesu ni ɛshɛ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Iyesu ko kpukporo bayaa katana ɛkǝri udumo ni ushere ngɛ, ɛkǝri udumo kǝ shere ngɛ. Ba kywakywa dang ɛkǝri erere kǝ shinɛ akpin ukɛnemo ʊmʊra. ");
INSERT INTO khj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Akywa sini ʊnʊng ku raawo, orokru ko kuro ni kukum ari idumo ededei ba owro Iyesu. Aka saa avu baya kukina arʊ udumo aka mamo ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ʊshari ko kuno bi idɔɔ orokru napany asu takpa asani, “Ʊni Ɔnɔ Ʊnʊng ngɛ!” Iyesu katana moni ashwi akarhamɔ ngɛ ʊpya onuo, kii ekperhi asani ɛngɛɛ ni Ikristi. ");
INSERT INTO khj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ni ʊbʊyɛrɛ ikywa Iyesu kǝ kyeng kya owro sini ani akpʊkpring. Orokru kasu pyerhe ngɛ akywa sini abi bo owro sini ɔnuo, oko sɔrhɔ ngɛ ani ebekya kyaa eshere mo. ");
INSERT INTO khj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Iyesu ka sani mo ni, “Itɔɔyo Inu tana iring ididima igumo Ʊnʊng ki opyo apya kamo, kii imi sini Ʊnʊng tumim nyina.” ");
INSERT INTO khj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Oko suno ngɛ ʊtana ʊring Ʊnʊng bi idɔɔ owro utuno Ayaudiya bi ibʊng Iyahudiya. ");
INSERT INTO khj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Upyu ʊnʊng sini Iyesu titing bi ikwo irɔng Ijennesaret orokru ko tuno ekǝkǝri ngɛ asu kung ʊring Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iyesu ko rong ɔgɔrʊ omung apari bo onuo omung arʊ abran sheriyo akyamo ukurho ukǝlimo. ");
INSERT INTO khj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iyesu ka raa bidɔɔ ʊgɔrʊ uying ʊmi Isimon ka sɔrhɔ ɛngɛɛ ni a taa avu ngɛ naji bau ʊtʊng ibʊng. Ikpara dang Iyesu ka kiki kasu mɛr orokru bidɔɔ ɛkǝri ʊgɔrʊ omung. ");
INSERT INTO khj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Akywa sini ɛkywɛri ʊpya onuo aka sani Isimon ngɛ, “Ojoying ni ɛkǝri ʊgɔrʊ omung kyaa owro sini ani ikwoo ngɛ efer ukǝli akpin utofuru.” ");
INSERT INTO khj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Isimon ko yoro, “Avʊwa, arʊ sa ʊtʊna nagang kukum ating baw ʊkpin iririma. Uba sani kǝna Ini fen ɛkǝri ukǝli.” ");
INSERT INTO khj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ni sini asi kǝna, aka kpin otofuru napany sini ukǝli mo kasu garamo. ");
INSERT INTO khj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Aka yirha orobyomo sini ani ʊwan ʊgɔrʊ omung ni ivu ni aba ɛshɛmɔ ngɛ, aka ba ɛtirɛ ɛkǝri ɔgɔrʊ apapari ɛtitirɛ sini atʊ mirimɔ. ");
INSERT INTO khj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Akywa sini Isimon Ibitrus rii kǝn aka kpaa okpukporo ni orung bi ite Iyesu ka sani, “Kyanw eshirem, Ete; Ini arʊya ngɛ!” ");
INSERT INTO khj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kii Ingɛɛ kǝni orobyoo ejijire ni akai otofuru sini akpin, ");
INSERT INTO khj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","kǝnawo Iyakubu kǝni Iyohana, ɔnɔ Izebedi, orobyoo ʊtina Ibitrus ejijire ngɛ kamo. Iyesu kasani Isimon ni, “Bekya kung Irung, bai kaimen men ʊni kpir orokru mo.” ");
INSERT INTO khj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aka wara ɔgɔrʊ omung mo ba bi ʊvra ibʊng, kǝshere kukum ʊmamɔ ko kroo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Akywa sini Iyesu ni bi idɔɔ opyo apya, opyo orokru ka ba arʊ sini udumo ʊkɔng koo. Ni sini erii Iyesu ngɛ aka kpaa ni itirite be ibʊng, ɔkɔ sɔrhɔ ngɛ, “Ete, uba yoro ʊmam ikrʊ.” ");
INSERT INTO khj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iyesu ka naa avu apya ɛkǝri orokru asani, “Iyoro, sa akrʊ.” Akywakywa dang ɛkǝri udumo ʊra owro kǝ shere ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iyesu kɔ wɔɔ atʊng asani “Bekya atana araru. Kya eyeyen ʊkanw eberi ogoku ubyen Ʊnʊng, ama ikara kǝni sini Imusa tii ogro ni imu kurho,” Inyina nuyen mo asani upen ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ʊring sini asi ka fwa ko kyu ubee bi idɔɔ anakywa, sini eshi orokru ka ba ʊkʊngwɔ adarha upen ikrʊ bai idumo mo. ");
INSERT INTO khj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Iyesu rɛn ukyaa owro sini orokru samɔ ngɛ aya ɔsɔrhɔ Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ʊpyu Ʊnʊng sini Iyesu ku mɛr, opyo Afarisiya kǝni avʊwa ʊmɛr ogro Imusa onuo akiki burha. A bi bai kukum apyang Igalili kǝni Iyahudiya adarhi Urushelima. Ikrʊ Ete ni kǝni Iyesu ngɛ imu ma arʊ ra ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Opyo orokru ko kong arʊ ʊra ba ba aya aban aka waw ʊraa ne ngɛ bidɔɔ ʊna ayara ngɛ bi ite Iyesu. ");
INSERT INTO khj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ni sini enepenmo ʊtʊra ʊsakǝna bekai ushi orokru, aka kirhamo ni ɛngɛɛ baya ʊbɔrʊ ka ta igara bi ʊsɔrɔ oko shuro ni ɛngɛɛ bi aya aban ngɛ abarating ushi orokru itituku bi ite Iyesu. ");
INSERT INTO khj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ni sini Iyesu rii ʊma ʊbrʊbrʊmo. Aka sani ɛkǝri arʊ ʊra ni “Orokyorom apʊnanw ʊyanw ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ɛkǝri Afarisiya kǝni Avʊwa ʊmɛr ogro Imusa kasu wɔrɔfo bi idɔɔ opyomo ni, “Iyaa we aku pya onuo kǝni ʊtira ngɛ ni? Iyaa nʊ bra ʊpʊna ʊya ngɛ? Yip Ʊnʊng ngɛ eyeyie amaa ʊsa kǝna.” ");
INSERT INTO khj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iyesu kperhi ʊwɔrɔfomo ngɛ oko gyurho mo asani “Ikisi nyi ku wɔrɔfo ʊring men bi idɔɔ ikywiny? ");
INSERT INTO khj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ikinayo isayo iraa ʊpɛrɛ, asani: ‘Apʊnanw ʊyanw ngɛ,’ kii asani, ‘Shinɛ a kyanw?’ ");
INSERT INTO khj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yip Iwei ni nyi kperhi ngɛ asani ɔnɔ orokru ni ikrʊ ʊpʊna ʊya ngɛ bi eyesing.” Ni kǝna akasani ɛkǝri arʊ ʊra sini anabraa ukyeng,“Itananw, shinɛ, akpara aban nwu akyanw ʊduna.” ");
INSERT INTO khj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Akywakywa dang ekǝ shinɛ bi itemo, ka kpara ima ʊsʊ yari ngɛ ka kyaa ʊduna asu dɔɔ Ʊnʊng ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kukum orokru kǝ jijire kasu dɔɔ Ʊnʊng ngɛ. Aka kung irung ngɛ nagang asani, “Arʊ rong ʊʊma ujijire ededei echiye.” ");
INSERT INTO khj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kǝ kywɛrɛ kǝna Iyesu ka kyaa esing ko rong arʊ yirha ogon sini a yirhi ʊtʊwa ngɛ ni Ilevi akiki bi ʊbɔrʊ ʊyirha ogon ngɛ Iyesu kasani ɛngɛɛ ni, “kroomi ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ilevi kǝshine, eshere ʊʊma kukum okroo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ilevi kǝ kyene Iyesu ngɛ ipara irirɛ bi idɔɔ ʊnaa, ushi arʊ yirha ogon ʊrʊrɛ kǝni opyoo arʊ kasu ra ʊmʊra kǝni omo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yip Afarisiya kǝni avʊwa ʊmɛr ogro Imusa ka yen uwure mo bi ikywi ɔnɔ ʊmɛr Iyesu ni, “Ikisi inyi ku ra ʊmʊra asu sa kǝni arʊ yirha ogon adarha arʊya men?” ");
INSERT INTO khj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iyesu ko yoro mo, “Arʊ sini anakru ana waa ngɛ Avuwa ʊʊma ikang, arʊ sini asaa akrʊ ngɛ ɛwɛi avuwa ʊʊma ikang. ");
INSERT INTO khj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ise bam ʊyirha arʊ sa nɛgbɛn, ibii ʊyirha arʊya aki etere eshere ʊya ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Opyoo orokru kasani Iyesu ngɛ ni, “Ɔnɔ ʊmɛr Iyohana akirhi ukusoro kǝni ʊsɔrhɔ Ʊnʊng kǝnawo ɔnɔ mɛr Afarisiya. Yip ɔnwɔ karana asu ra kǝni ʊsawɔ?” ");
INSERT INTO khj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iyesu ko yoro mo kasani “Inyi nʊ sa orokyoro arʊ sini owo lorho ubara ukusoro arʊ lorho ubara shoo kǝni ɔmɔɔ? ");
INSERT INTO khj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yip akywa yeba ba sini anu kpara orokru sini owo lorho ubara ngɛ baa owromo; ba awri dang moo anu kusoro.” ");
INSERT INTO khj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iyesu ka tana mo ushosho wen: “Baa arʊ sini anu gara ʊtʊgbɛ bi igbɛ isa onuro bi ititɛn. Arʊ sini abasa kǝna, anu bura ɛkǝri igbɛ isa ngɛ, kǝnawo ɛkǝri ʊtʊgbɛ bai igbɛ isa ʊnasu kyawo igbɛ iteny ngɛ ba. ");
INSERT INTO khj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kǝnawo baa ararʊ sini anu tere asira bidɔɔ obom ʊwɔwsɛtɛng. Aba sakǝna asira nʊ vɛrhɛ ɛkǝri obom ʊwɔw ɛtɛng ngɛ. Ɛkǝri asira nu kuno mo ɛkǝri obom ʊwɔw nʊ burayo. ");
INSERT INTO khj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Itɔɔyɔ akʊna asira bidɔɔ obom ʊwɔw ʊsa kǝnawɔ kukum mo nʊ ki akrʊ. ");
INSERT INTO khj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kǝnawɔ ba arʊ sini ɛbɛ kwɛrɛ ʊsa asira ɛtɛng anʊ waa ʊsa asa, kii asi ni, ‘Ɛtɛng ni agyang.’ ” ");
INSERT INTO khj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Opyo awri uwuro Ayaudiya Iyesu kǝni ɔnɔ ʊmɛr ngɛ akasʊ wɔrɔ bi idɔɔ abya ogro, ɔnɔ ʊmɛr ngɛ kasu hywurha akywi ogro ekǝ wrem ikiri ngɛ asu ra. ");
INSERT INTO khj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Opyo Afarisiya ko gyurho, “Ikisi inyi kusa imisini isayo nɛmɛr ni ogro awri uwuro Ayaudiya?” ");
INSERT INTO khj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iyesu ko yoro mo kasani, “Inyi se parany imisini Idouda si bakywa sini ingɛɛ kǝni orobyoo akʊng ihywung? ");
INSERT INTO khj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Arii Ʊna Ʊnʊng ka kpara agbankrɔ imu pupuna, aka ra imisini isayo nɛmɛr, ogoku ubyen Ʊnʊng ngɛ eyeyie nushu ʊra, kojo ma orobyoo ipyoo.” ");
INSERT INTO khj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iyesu ka tanamo ni, “Ɔnɔ orokru ngɛ ni Ete awri uwuro Ayaudiya.” ");
INSERT INTO khj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bo opyo awri uwuro Ayaudiya Iyesu kakya owro utuno Ayaudiya kasu mɛr, opyo orokru sini avu amu raa rhie shoo burha. ");
INSERT INTO khj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Afarisiya kǝni avʊwa ʊmɛr ogro Imusa nuwo akʊ roo asu yara ngɛ, orong kii anu ma ɛkǝri arʊ ra avu ikrʊ ʊnʊng uwuro Ayaudiya aki imo kpin ngɛ ni ʊya. ");
INSERT INTO khj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Iyesu kperhi ʊwɔrɔfomo ngɛ aka sani ɛkǝri arʊ ra avuni,“shinɛ aba atiting bi ite ben.”Ekǝ shinɛ atiting burha. ");
INSERT INTO khj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iyesu ka sani ɔmɔ ni, “Iwɛi ugyurhony, ikimɔyɔ ogro Imusa tani arʊ, arʊ sa imisini inɛmɛr awri uwuro Ayaudiya? Asa ima ididima kii ima ibibi? Asa oforo ofo kii abura ngɛ?” ");
INSERT INTO khj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Oko gyo ikra asu rongmo kukum, aka sani ɛkǝri arʊ ra avu ni, “Naa avunw.” Aka naa, avuɔ kasa akrʊ kǝni ushoyo ba akywaa ni. ");
INSERT INTO khj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ekǝri Afarisiya kǝni avuwa ʊmɛr ogro ka kung anang ngɛ nagang, oko sunomoo ʊpɛrɛ ni opyoomo ani ikimoyo imo nusa Iyesu ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Upyu ʊnʊng bi idɔɔ awri dang Iyesu ka kyaa ʊsɔrhɔ Ʊnʊng ki aya ukro, aka kpara eting okokuro akʊ sɔrhɔ Ʊnʊng ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ni sini ikywa yeri aka yirha arʊ kroo ngɛ, ko woro arʊ atarhi na apari bi idɔɔmo aka yirhamɔni ɔnɔ ʊmɛr. ");
INSERT INTO khj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ʊpya atina ngɛ ni Isimon (arʊ sini ayirhi ngɛ ni Ibitrus), arupyaa Andirawus, Iyakubu, Iyohana, Ifilibus, Ibatalomi, ");
INSERT INTO khj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Imatiyu, Itoma, kǝni Iyakubu, (ɔnɔ Ihaifa), Isimon arʊ sini ani arʊ waa ibʊng ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","kǝni Iyahuda (ɔnɔ Iyakubu) kaba darha Iyahuda Iskariyoti (arʊ sini agbuni Iyesu ngɛ). ");
INSERT INTO khj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iyesu kata shuro ngɛ kǝni ɔmɔ kaya atiting bi opyo owroo sini asi neterh, ɔnɔ ʊmɛr ngɛ kukum kǝni akai orokru bai kukum owro bi Iyahudiya, kǝni Urushelima, kǝni a marha Ibung Itaya kǝni Isidɔn arʊ sini ani bi onuo ugro ʊrɛ ");
INSERT INTO khj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Abii awa ba kuwɔ epen ikrʊ bai idumo ededei sini iku wuremo. Arʊ sini ering ebebi kuwuremo ma epen ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kukum orokru kasu sunomo ngɛ ʊwaa ʊpya Iyesu ngɛ kii ikrʊ kusu kuno bai owroo kasu mamo ikrʊ kukum mo. ");
INSERT INTO khj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Oko kong ɔnɔ ʊmɛr ngɛ ikra ka sani, “Ʊnʊng tany onuo adadʊma inyi ara ayarha, kii igumo Ʊnʊng ni inyiyo. ");
INSERT INTO khj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ʊnʊng tany onuo adadʊma inyi arʊ sini inyi kʊng ihywunw kaimen men, kii inyi nʊ ra oshuro. Ʊnʊng tany onuo adadʊma inyi arʊ su utei kaimen men, kii inyi nʊ sina. ");
INSERT INTO khj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Onuo adadʊma ni enyi, akywa sini orokru tirimɔ nyi, okyony bi itung, atirany ayirha ʊtʊwa nyi ere etetingmo, Bekai ɔnɔ orokru. ");
INSERT INTO khj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Inyi sumɛ ʊnʊng dang ofuno ni ɛmɛ kii ʊkara nyi ni ʊgrɔɔ bayaya, kii kǝnawo ɛkpɛrimɔ si ni arʊ tana onuo Ʊnʊng bai itee. ");
INSERT INTO khj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Yip okwo ne nyi arʊ shoo ni ima avu ngɛ, kii inyi kywɛrɛ ʊkʊng ididima kaimen men. ");
INSERT INTO khj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Okwo ne nyi arʊ sini inyi ra oshuro kaimen men, kii ihywunw nʊ rany. Okwo ne nyi arʊ su sina kaimen, kii inyi nʊ tei kǝni ʊbʊra ikywi ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Okwo ne inyi ikpara sini orokru kukum ku tana ʊring udidima bi ikywiny, kii kǝnawo ekperimo si ni arʊ pɛrɛ onuo Ʊnʊng upre eteting. ");
INSERT INTO khj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Yip kyeba eberi nyi arʊ sini inyi ku kung isini: Inyi waa arʊ sini atirimo nyi, asa arʊ sini ana waamɔ nyi nɛgbɛn. ");
INSERT INTO khj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yip arʊ sini ating onuo ebebi, inyi tamo onuo adadʊma arʊ sini akʊ sanw ibibi inyi sɔrhɔ Ʊnʊng bekaimo. ");
INSERT INTO khj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Araru ba gyong bi uwen ʊtama utere ngɛ ʊwan ʊtama kawo. Araru ba kparanw igbɛ irɛ ngɛ bekya karha ngɛ ni imi dɔɔ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Arʊ sini ɔbɔ sɔrhɔnw ʊmaa, arʊ sini aba kparanw iririma, bekya sani ngɛ ni ojuro amanw. ");
INSERT INTO khj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ima sini ʊwɛi ni orokru. ");
INSERT INTO khj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ikimoyɔ unupen ʊba waa arʊ sini ɛwɛinwʊ mɔ ko arʊya sa waa arʊ sini ɛwɛimɔ kamɔ. ");
INSERT INTO khj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iboshoo arʊ sini a sanw nɛgbɛn mo ʊnʊ samɔ nɛgbɛn ʊsa kǝna nʊ manw iking? Kǝnawɔ arʊya sirhi kamɔ. ");
INSERT INTO khj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Bushoo arʊ sini inyi ku ʊtira ikywi anushe ʊkpʊrany mo inyi ku mamo ita, ikimoyo inyi nupen bi sakǝna, kǝnawo ere eteting sema arʊya ʊta kǝni ʊkpɛrhi ngɛ asani anu kpura mo napʊpʊrhi. ");
INSERT INTO khj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Inyi waa arʊ sini ana waamɔ nyi, inyi samɔ nɛgbɛn, inyi mamo ʊta, oworo ikywiny ngɛ. Ikpara dang inyi nʊpen ʊkara nyi napany baa ayaya, inyi nu shoo ɔnɔ Ʊnʊng Ayaya, kii Ʊnʊng ni ari agbagba ngɛ eberi arʊ na sirhi ija kǝni ari eteting. ");
INSERT INTO khj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Inyi kung okwo kǝni sini Ɛkpɛriny ni okwo ngɛ ni. ");
INSERT INTO khj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Bekya kywa ararʊ iring, kii anasu kywamo nwu iring. Inyi bekya sani ararʊ ni aya, inyi kany anasʊ samɔni inyi ya, inyi pʊna ʊya orokru ngɛ, anu pʊna unyi ngɛ kany. ");
INSERT INTO khj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ma orokru Ʊnʊng nʊ maunw kanw ɛtitirɛ isong ojujuro ojo sanw ngɛ isu nirayo, anu sha ʊparha ɛshɛɛ akwunanw bi ivʊ. Kii isɔng sini ʊmarhi ngɛyɔ anʊ marhanw niyɔ.” ");
INSERT INTO khj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iyesu ka tanamɔ ushosho wen ofow nuyen ofow itira? Apaparimɔ naw kpaamɔ kidɔɔ igara? ");
INSERT INTO khj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɔnɔ ʊmɛr ne pri ngɛ avuwa, arʊ sini abakya mɛr nashisha anu shoo kǝni avuwa ngɛ ni. ");
INSERT INTO khj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ikisi uku rong isu sini ini bi ikra arupyanw. Yip uyuronwoo ni ukumo ʊshi sini ʊni bi ikraunw? ");
INSERT INTO khj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ʊnʊ sanenyewo ka sani arupyanw ni ‘Arupya, ting aki iworonw isu bi ikraunw,’ ekwere sini ʊnwɔ ʊnabranw urong ukumo ʊshi sini ʊni bidɔɔ ikraunw? Inyi arʊ pre eteting, inyi woro ukumo ʊshi sini ʊni bidɔɔ ikrany noru orong owro nashisha ko shoo nʊ uworo isu sini ini bi ikra arupyanw. ");
INSERT INTO khj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ushi ududuma no sumowo ɔnɔ ebebi, kǝnawo ʊshi ubibi nosumowo osumo ɔnɔ adaduma. ");
INSERT INTO khj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ese kpɛrhi ʊshingɛ bi usumo ngɛ. Anau karhamo osumo uwee bi ʊshi akara, ko inabi bi ikyura oku. ");
INSERT INTO khj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Orokru adadʊma ese sa ima ididima bai idɔɔ ikywi ididima ngɛ. Kǝnawo ere ebebi se sa ʊring ubibi bai ikywi ibibi. Ima sini inidɔɔ orokru yen imisini inu kuno bi onuonw. ");
INSERT INTO khj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ikisi inyi ku yirham ni ‘Ete, Ete,’ atiranyi ʊsa imi sini Isini inyi sa? ");
INSERT INTO khj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Arʊ sini aba ba beberim akʊng ʊringmi a samɔ, inu yen nyi ushoo mo. ");
INSERT INTO khj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ani kǝni orokru sini akʊ vura ʊna, arʊ sini otumi ibʊng kyaa idɔɔ asa atari ngɛ aka sai ikpa ʊvʊra ngɛ, akywa sini ugro be tirɛ, ʊgyang ko kuno ogyoo ɛkǝri ʊbɔrʊ akana brayɔ ukono jurowo bekai sini avuri nɛgbɛn. ");
INSERT INTO khj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Arʊ sini aba kung ʊringmi atira ngɛ ʊsa ʊtina ni ɔmɔ, ani kǝni orokru sini avuri ʊbɔrʊ ba ukyo tumo ibʊng asa atari ngɛ bai ikpa ʊvʊra, akywa sini ugro be tirɛ, ʊgyang ko kuno ogyoo ɛkǝri ʊbɔrʊ, ʊka kpaawo no prob abuburawo.” ");
INSERT INTO khj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ikpara sini Iyesu kywɛri ʊtana ʊring men kukum orokru sukuwɔ, aka raa ngɛ Ikafarnahum. ");
INSERT INTO khj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Bi ʊpʊrha agara opyo ɔrɔmɔmɔrʊ arʊ tɛikɔ nuwo, arʊ sini epri ni usho iyoyow ni ɛngɛɛ saa akrʊ etekya ukpoo. ");
INSERT INTO khj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ikpara sini ɛkǝri ɔrɔmɔmɔrʊ ʊtɛikɔ kung imi sini Iyesu ku sa, aka tuma opyo ɔrɔkɔng Ayaudiya ɔyo sɔrhɔ ngɛ aba ma agara ngɛ ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ikpara sini abii owro Iyesu, ɔkɔ sɔrhɔ ngɛ nagang, asani “Orokru wen maa sini ʊnʊshɛɛ ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kii ɛwɛi ararʊ aka vura arʊ owro utuno Ayaudiya.” ");
INSERT INTO khj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iyesu ko kroomo ngɛ. Eneshie ikarha ni ɛkǝri ʊna, ɛkǝri ɔrɔmɔmɔrʊ arʊ tɛikɔ ka tuma orokyoro ngɛ aya sani ɛngɛɛ ni: “Ete, bekya wure ʊkanw kii ise mam sini ʊnʊ bi ʊnam ba, ");
INSERT INTO khj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ʊwɔɔ inakparami ʊkam ni imaa uba eberinw nivum ba. Tana irima agaram nupen ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kii ini ari igumo ngee, oshoo ni agara ngɛ ba atata ne emye. Ise sani arʊ wen ni, ‘Kya,’ akan kyaa; asani awan arʊ ni ‘Ba,’ akan ba. Ise sani agaram, ‘Sakǝn’, akan sayo.” ");
INSERT INTO khj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ni sini Iyesu kung kǝna, imaa ka maa ʊwɔrɔ ofo ngɛ. Ekǝ tere asani arusu kroo ngɛ ni, “Iku tanany, ko bi ibʊng Isrela isepenmi ʊma ʊbrʊbrʊ kǝn.” ");
INSERT INTO khj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ekǝri arʊ sini atumimo oko juro kya bi ɛkǝri ʊna aya darha ɛkǝri agara ngɛ sa akrʊ. ");
INSERT INTO khj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ni ʊkywɛrɛ kǝna Iyesu ka kyaa opyo apya sini ayirhi ni Inayin, ɔnɔ ʊmɛr ngɛ kǝni orokru napany ko kro ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ni sini akʊ fwa onuo apya, asu kuno ni ʊkwʊng opyoo orokru sini ɛngɛɛ ni ɔnɔ ɛkǝri ereere eyeyie, ɛkǝri ereere ɛrimɛ ngɛ kpoo, ushi orokru napany bai idɔ ɛkǝri apya ni kǝni ɛngɛɛ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ni sini Ete rie, aka kung okwoo ka sani ɛngɛɛ ni, “Bekya tei.” ");
INSERT INTO khj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aka kya aya apya ima aban sini okoo ngɛ ɛkǝri arʊ sini okowo katiting neding. Iyesu ka sini, “Anagyang, Isini ɔnwɔni, shinɛ!” ");
INSERT INTO khj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ɛkǝri arʊ ukpo kǝ shinɛ akiki akasu pya onuo, Iyesu ka kpara ngɛ ama akwaa. ");
INSERT INTO khj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Irung ka kpinmo kukummo, ɔkɔ dɔɔ Ʊnʊng ngɛ akani, “Arʊ pɛrɛ onuo Ʊnʊng erere kuno bi idɔɔ eri!, Ʊnʊng bʊshɛ arʊɔ ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ushoshoo imi sini Iyesu siyen ka kyawo kokywu ube bi idɔɔ Iyahudiya kǝni ʊbʊng ʊkʊkǝrimɔ. ");
INSERT INTO khj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ɔnɔ ʊmɛr Iyohana arʊ Ibaptisma ka tana Iyohana ngɛ kukum ʊʊma men Iyesu kusani. Kǝnawo Iyohana ka yirha ɔnɔ ʊmɛr ngɛ ara pari, ");
INSERT INTO khj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","aka tumamo ki iberi Ete oyo gyurho ngɛ asani, “Ʊnwʊɔ ʊni arʊ sini arʊ kusha ukyee baa, kii arʊ si ikra ni ɛshɛshɛru?” ");
INSERT INTO khj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ikpara sini ɛkǝri orokru bii owro Iyesu, aka sani, “Iyohana arʊ Ibaptisma ngɛ atumi arʊ ni ɔnwɔ ani arʊ ba gyurhonw, ‘Ʊnwʊɔ ʊni arʊ sini arʊ kusha ukyee baa, kii arʊ si ikra ni ɛshɛshɛru?’ ” ");
INSERT INTO khj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bakywakywa dang Iyesu kurhi orokru idumo ngɛ, arʊ ʊsang ikrʊ, ɛyɛri ering ʊshari kǝni ʊʊma arʊ sini ani ofow urong owro. ");
INSERT INTO khj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Oko yoro ɛkǝri atina asani, “Inyi juro kya tana Iyohana ngɛ ima sini inyi rii a kung: Ofow pen urong owro, ogoru sa akrʊ, arʊ udumo ʊkɔng pen ikrʊ, arang ku kung ʊring ngɛ, akʊ shinɛ ikwʊng, asu tana iring ididima eberi ara ayarha. ");
INSERT INTO khj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Onuo adadʊma ni ami arʊ sini ana kpaa bɛkɛi mi.” ");
INSERT INTO khj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bakywa sini ɛkǝri atina Iyohana kpin ʊtira, Iyesu kasu tana orokru ʊring bi ikywi Iyohana: “Ikimoyo inyi kii urong bi idɔɔ orumo? Inyi kii urong ʊbʊng ʊgbʊgbang sini uwroo ku pyawo? ");
INSERT INTO khj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ibasayo kǝna, inyi kii urikimɔyɔ? Ararʊ sini ɔsɔmi ʊʊma ʊdʊdʊma? O-o arʊ ʊʊma ʊsɔmɔ ʊfɛ kǝni arʊ ʊkaadima ani arʊ kiki bi ozoro mo. ");
INSERT INTO khj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Inyi nɛchiyɛn ikimoyo inyi kuni kya urong? Arʊ pɛrɛ onuo Ʊnʊng? Kǝnawo, Itananyi, epri atina Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iyohana ngɛ ni arʊ sini irhing Ʊnʊng peri bi ikywie asani: “Inu tuma atinam akpi itenw, sini anu kyenenw ʊtira ʊkyebanw. ");
INSERT INTO khj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iku tananyi, kukum bi idɔɔ ubyere ereere araru na saangɛ Iyohana. Kukum kǝna arʊ sini ani atang bi idɔɔ igumo Ʊnʊng sai ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Kukum ɛkǝri orokru, kǝni arʊ yirha ogon ngɛ ma, sini akʊng irhing Iyesu, oko yoro asani ʊtira Ʊnʊng ni ɛmɛr, bekai sini Iyohana ngɛ asimo Ibaptisma. ");
INSERT INTO khj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ekǝri Afarisiya kǝni avʊwa ogro Imusa ka tiramo ʊwɔrɔfo Ʊnʊng bi ikywimo aka tiramo karhi Iyohana kya samɔ Ibaptisma.) ");
INSERT INTO khj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iyesu ko shoo ngɛ, asani,“Ini marha orokru ikparha yen ni ikimoyo nɛchiyɛn? Ani kǝni ikimoyoni? ");
INSERT INTO khj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ani kǝni ɔnɔ sini akiki bi ʊgba Ize asu yirha opyomo asu sani, “ ‘Arʊ pwiny ipwe, inyi ka tirany ʊya; arʊ ka tany ʊtɛ ukpo, inyi ka tirany utei.’ ");
INSERT INTO khj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kii Iyohana arʊ sa Ibaptisma bii ana rii ngɛ ʊmʊra, ana sirhi ngɛ asira, inyi ka sani, ‘Ani ʊshari ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ɔnɔ Orokru ka ba asu ra, asu sa, inyi kasani, ‘Orong ʊkʊma kǝni arʊ sa ʊʊma, orokyoro arʊ yirha ogon kǝni arʊya.’ ");
INSERT INTO khj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ʊkiki orokru sini ani amraa ngɛ useyen asani amraa nɛmɛr.” ");
INSERT INTO khj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Upyu Afarisi kɔ sɔrhɔ Iyesu ngɛ aya ra ʊmʊra ʊrɛ kǝni ɛngɛɛ ngɛ, aka kya ʊna ɛkǝri ʊbafarisi aya kiki eberi ʊrʊmʊra. ");
INSERT INTO khj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Opyo erere arʊya ɔnuo ni ʊkiki bi ɛkǝri apya, ni sini akʊng asani Iyesu ku ra ʊmʊra bi ʊna opyo Afarisi, aka ba burha ni ɔnɔ obom sini akyeni ni ʊtari sini ayirhi ni Alibasta ɛtiri ni ɛnyɛ ʊnyang ʊdʊdʊma. ");
INSERT INTO khj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aka ba atiting bi utumo ngɛ bi ishi ifraa kasu tei, kasu rono ngɛ ifraa ni ere, aka punamɔ ni ʊfʊrhi ikywie ko mo ifraa Iyesu kasu kuna ɛnyɛ ʊnyang ʊdʊdʊma dang bayamo. ");
INSERT INTO khj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ikpara sini ɛkǝri Afarisi sini ɔsɔrhi ngɛ rii kǝna, ekǝ pɛrɛ bi idɔɔ ikywie asani, “Akyusani orokru wen ni arʊ pɛrɛ onuo Ʊnʊng ngɛ anakyu kperhi ngɛ asani, akinadǝi ereere ngee akʊpirha ngɛ, kii arʊya ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iyesu ka sani ɛkǝri ubafarisi ni, “Isimon, ini imisini iwa tananwu.” Aka sani, “Avuwa, tanam.” ");
INSERT INTO khj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Opyo orokru nuwo arʊmita ami arapari ʊtʊfɛ ereying kong ngɛ udinari akʊma ɔtɔng awan arʊ udinari isitɔng. ");
INSERT INTO khj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sini anabramoɔ ʊkpʊra ngɛ ɛkǝri arʊmita ka pʊnamɔ ʊtamɔ ngɛ, nɛchiyɛn akina arʊ ngɛ bi idɔɔmɔ anʊpri ni ʊwaa ɛkǝri arʊmita?” ");
INSERT INTO khj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Isimon ko yoro ngɛ asani, “Arʊ sini apʊna ʊta ngɛ ʊrʊrɛ.” Iyesu ka sani ɛngɛɛ ni, “Ʊpɛrɛ nɛmɛr.” ");
INSERT INTO khj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ekǝ tere ki isha ɛkǝri ereere ka sani Isimon ngɛ ni, “Urii ereere wen? Ikpara sini irhii ʊnanw, ʊkyana manw ɛmyɛ omung aki ikurho ifraam ngɛ, yip ɔrɔni ifraam ngɛ ni eree, apuna ni ʊfʊrhi ikyie. ");
INSERT INTO khj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Sini irii ben use kǝnwu ɛmyɛ, uwe wroo bi ikpara sini irii ʊnanw, ereere wen nuwo akumo ifraam. ");
INSERT INTO khj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Use kunaunw emye ɛnyɛ bi ikywi, eewe akʊnam ɛnyɛ ʊnyang ʊdʊdʊma bi ifraa. ");
INSERT INTO khj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bi kǝnawo itananw apuna ereere wen akai ʊya ngɛ, kii eyen mi ʊwaa nagang, arʊ sini apuna ngɛ ʊya naji anu waa naji.” ");
INSERT INTO khj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iyesu ka sani ɛkǝri ereere ni,“Akarha pʊnanw ʊyanw ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ekyeng sini ani burha akasʊ pɛrɛ bi idɔɔ opyomo ni, “Iyaa ewe arʊ sini ese pʊna ʊya ngɛ ni?” ");
INSERT INTO khj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iyesu ka sani ɛkǝri erere ni, “Kii ʊma ʊbrʊbrʊnw sanw oforo kyanw bidɔɔ ofofuru.” ");
INSERT INTO khj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ni ʊkywɛrɛ kǝn, Iyesu ka shinɛ kya asu kǝri apyapya kǝni apyang asu tanamɔ iring ididima gaa ni igumo Ʊnʊng. Ɔnɔ ʊmɛr ngɛ atarhi ni apari ni kǝni ɛngɛɛ ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","adarha opyo erere sini amimo ikrʊ kǝni arʊ sini oworimo ering ʊshari bidɔɔ inamamo; bidɔɔmo Imeri bai Imadala arʊ sini owori ʊshari uten sara bi idɔɔ inama ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ijowana ere Ikuza arʊ sini ɛngɛɛ ani arite ɔnɔ ʊtina ʊna Ihiridus adarha Isuzana kǝni erere napany arʊ sini akʊ she Iyesu ngee kǝni ɔnɔ ʊmɛr ngɛ ni imisini aniyoo. ");
INSERT INTO khj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ni sini ushi orokru bi owro Iyesu bai apya pya obotuno napany aka tanamo ushosho wen: ");
INSERT INTO khj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Opyo arʊ wro kii ʊpʊra irhɔw. Sini akʊ zara ipyoo kakpaa baya atira, ekǝ titɛɛ ɔnɔnʊng ayaya ka tanayo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ipyoo ka kpa baya ibʊng atari. Akywa sini emeri ekǝ ne penyo omung nɛgbɛn ikɔ rɔɔyo akurayo. ");
INSERT INTO khj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ipyoo irhɔw ka kpa idɔɔ Akara kǝ mɛrɛ kǝni ɔyo ngɛ ɛkǝri akara ko turoyo a karhayo ʊfɔnɔ. ");
INSERT INTO khj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ipyoo irhɔw kakpaa bi ibʊng ididima. Ikǝmere kɔ fɔnɔ asa akywi ʊsʊsɔng epri imisini apʊri.” Sini ekyweri ʊtanamɔ, aka sani,“Arʊ sini ani atung akʊng ngɛ, akʊng.” ");
INSERT INTO khj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ɔnɔ ʊmɛr Iyesu ko gyurho ngɛ ikimoyo ɛkǝri ushosho wen ku pɛrɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aka sani, “Eyenyi ʊʊma sini ɔsusi bakywa bidɔɔ igumo Ʊnʊng sini inyi nʊ kperhi ngɛ, ʊparha ɛshɛ ini pɛrɛ ni ɔmɔ ni oshoshoyo, “ ‘aki, anu ku ikra, anasu romo; anu kungwo, anasu kperhimo.’ ");
INSERT INTO khj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Imisini ushosho wen peri ye: ɛkǝri irhɔw yo ini Iring Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imi sini kpii baya ʊtira, ɔmɔmɔ ani arʊ sini akʊng ɛkǝri irhing, ishari ka karhayo ngɛ bi idɔɔ ikywimo, sini anau yoromo epen ʊgya. ");
INSERT INTO khj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Imisini ikpii baya ibʊng atari iyoyo ini arʊ sini akʊng ɛkǝri iring aka yirhayɔ ni ofofuru, uwe ese mɛrɛmo ikang, oyoro ba anakywa ʊmarha ka ba aka kpa. ");
INSERT INTO khj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Irhɔw sini ikpii bi idɔɔ akara iyoyo ini arʊ sini akʊng ka yirha nisini akpin okyoro uwure ʊkiki eyesing, ʊkaa adʊma kǝni ʊkʊng ididima ka karhamo ngɛ ɔkɔrɔ. ");
INSERT INTO khj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Irhɔw sini ikpii bi ibʊng ididima iyoyo ini arʊ sini akʊng ɛkǝri iring aka yirha okong nagigi bi idɔɔ ikywi ididima nɛmɛr asu wura ikywi ama ɔnɔ. ");
INSERT INTO khj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ararʊ nasu ta uyen aka frawo ni isong ba. Kǝnawo araru nasu ta uyen ɔsɔmɔ ba atata Ipro. Aba ta uyen anu sawɔ bi owro ukyo uyen aki arʊraa ɛkǝri ʊna nuruyeng. ");
INSERT INTO khj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kii kukum ima sini ini ʊsʊsɔ, anu kuno niyo besing, kǝnawo imisini afriyo, anu fʊrɔyo okoba bi uyen. ");
INSERT INTO khj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Inyi sa noshong ni imisini inyi kukung. Arʊ sini ani ima ngɛ anujo ma; arʊ sini asa niyo; ko ani ima sini akʊ wɔrɔfo ni ingɛɛ niyo anu karha.” ");
INSERT INTO khj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ikpara dang akwa ubyere kǝni arʊpya Iyesu kaba owroo, ʊrɛ orokru kasa ana bramo ʊfwa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Opyo arʊ ka tana ngɛ a sani, “Akwa ubyerenw kǝni arupyanw titing besing akuwaw urong.” ");
INSERT INTO khj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Oko yoromo a sani, “Akwa ubyerem kǝni arupyam ɔmɔmɔ ani arʊ sini akʊng iring Ʊnʊng akasʊ ʊtina niyo.” ");
INSERT INTO khj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Upyu Ʊnʊng Iyesu ka sani ɔnɔ ʊmɛr ngɛ ni, “Arʊ bro kyu ʊwan ʊbya ugro ʊrɛ.” Ikpara dang aka raa ɛkǝri ʊgɔrʊ omung aka kpin ʊtira. ");
INSERT INTO khj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ni sini akubro ʊmɔrɔ ka kpara Iyesu ngɛ. Uwroo avra ʊmi ikrʊ kǝ shinɛ baya omung sini ʊgɔrʊ ubro omung ugro ʊrɛ ʊtʊ tirɛ ni omung aka kpaa eyi ngɛ atu rong asani imɔ kywɛrɛyo. ");
INSERT INTO khj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɔnɔ ʊmɛr ngɛ kǝyɛ shinɛ ngɛ asu takpa asani, “Arite, Arite, arʊ tekya ʊmirimɔ!” Iyesu kǝshine aka tana ɛkǝri uwroo avra ʊmi ikrʊ kǝni omung, akayari owro kasa na kprukpring. ");
INSERT INTO khj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iyesu ko gyurho ɔnɔ ɛmɛr ngɛ, “Eki ʊma ʊbrʊbrʊnyi?” Akyu tirɛ ni irung asuya owro, akasʊ gyurho opyomo ani, “Iyaa we sini apyii onuo ni uwroo avra ʊmi ikrʊ kǝni omung aka kwɔɔ.” ");
INSERT INTO khj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iyesu kǝni ɔnɔ ʊmɛr ngɛ kobro kyamo kii ibʊng Igarasi sini ini uteri isha irɔng Igalili. ");
INSERT INTO khj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iyesu ku shuro wurha bi ibʊng, aka darha opyo orokru bai idɔɔ apya arʊ sini ʊshari ni bidɔɔ ngɛ. Orokru wen dɛrhɛ ngɛ ono sono ngɛ ʊʊma ʊsɔmɔ ana kiki ngɛ bi idɔɔ ʊduna akʊ kiki bi idɔɔ ɔgrɔnmɔ. ");
INSERT INTO khj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ni sini eri Iyesu ngɛ ekǝ fen akpa ayaya ka karhakpaa bi ite, kasu takpa ayaya asu sani, “Iyesu Ɔnɔ Ʊnʊng arayaya, ikimo ʊwɛi ni emye, iku sɔrhɔnw bekya ogyurhom!” ");
INSERT INTO khj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ɛpɛri kǝnawo, kii Iyesu karha kyu tana ering ebebi usho bidɔɔ inama ngɛ ni ukuno. Bekai sini ɛrɛn ʊraa ngɛ eshuwe ngɛ ɛfɛn. Kǝni sini ese lorho ngɛ ivʊ kǝni ifraa ni, okyo asha, akan karha ɛkǝri itomo ngɛ, ʊshari kon wɔɔ kyamo idɔɔ orumo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iyesu ko gyurho ngɛ asani,“Ʊtʊwanw ni iyang?” Oko yoro asani, “Inapany,” eperi kǝnawo bekai sini ʊshari sini ʊrii inamange ʊnʊgrɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɛkǝri ʊshari kasu sɔrhɔ Iyesu ngɛ ani ebekya yerimɔ kidɔɔ ukwoo sini ʊsawɔ ni akurha ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ugrii ku piri Iyoyow burha bi obru ukro. Ɛkǝri ʊshari ko sɔrhɔ Iyesu ngɛ ani esheremo imo raa bi idɔɔ ɛkǝri Ugrii. Iyesu ko Yoromo. ");
INSERT INTO khj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bakwya dang ɛkǝri ʊshari ko kuromo bi idɔɔ ɛkǝri orokru ka raamo idɔɔ ɛkǝri Ugrii. Kukum ɛkǝri Ugrii ko shuro ni atara aramo bi idɔɔ ɛkǝri irɔng asa omung okyurhomo ekeremo kukum mo. ");
INSERT INTO khj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ni sini arʊ piri ɛkǝri Uugrii rii kǝna oko gyoo atara aya tana imi sini isi kidɔɔ apya kǝni apya ʊkʊkǝri mo. ");
INSERT INTO khj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Orokru kaba okuno oborong imi sini isi. Ni sini abii eberi Iyesu, aka darha ɛkǝri orokru sini ʊshari kuni bi idɔɔ ngɛ akiki bi ite Iyesu ɔsʊsɔmi igbɛ ngɛ, asa akrʊ. Irung ka kpinmo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Arʊ sini ani burha ori imisini isi ngɛ akasʊ tana arʊ sini abi bi ututumo, sini owori ɛkǝri orokru ʊshari bi inama. ");
INSERT INTO khj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ikpara dang kukum arʊ ʊkʊkǝri ibʊng Igarasi kɔ sɔrhɔ Iyesu ngɛ ani esheremo apya ngɛ, kii akʊng irung ngɛ nagang. Iyesu karaa ʊgɔrʊ omung sɔɔ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ɛkǝri orokru sini ʊshari kuni bi idɔɔ inama kɔ sorho Iyesu ngɛ a sani ingɛɛ nʊ kroo ngɛ Iyesu ka shirha ngɛ a sani, ");
INSERT INTO khj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Juro kyanw owro arunw aya tanamo imi sini Ʊnʊng sinw.” Ekǝri orokru kakyaa kidɔɔ apya kukum asu tana imi sini Iyesu sie. ");
INSERT INTO khj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ni sini Iyesu juri ba ʊwan ʊbya orokru ka yirha ngɛ ni ofofuru kii akaru shaa. ");
INSERT INTO khj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ani aya ʊsirha kǝna opyo orokru sini ayirhi ʊtʊwa ngɛ ni Ijerus, arite owro utuno Ayaudiya kaba okpukporo bi ite Iyesu, asu sɔrhɔ ngɛ akya ʊdʊnaa, ");
INSERT INTO khj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kii ɔnɔ eying enere arʊ sini etekya ʊsa ɛnyɛɛ atarhi na apari etekya ukpo. Ni sini Iyesu nibi ʊtira ushi orokru ko mumun ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Opyo erere sini akʊ kung igara ni udumo ʊnira eyi ɛnyɛɛ atarhi na apari, ɔnuo burha. Eperi imi sini aniyoo ngɛ bi ʊkikie eberi avuwa ikang, ekɛne pen ngɛ ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aka sara bidɔɔ orokru bau utumo Iyesu ka pya afri igbɛ ngɛ, ba kywakywa dang ʊnira eyi nge kating. ");
INSERT INTO khj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iyesu ko gyurho a sani, “Iyaa apim?” Orokru kara amaa ngɛ, ikpara dang Ibitrus ka sani, “Avuwa akai orokru men ekǝkǝrinw a su tanw ivʊ bai ikwu ikinisha keba ni ɔnwɔ.” ");
INSERT INTO khj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iyesu ka sani ni, “Ararʊ pyam; ikung sini ikrʊ kuni yo ngɛ bidɔɔmi.” ");
INSERT INTO khj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ni sini ɛkǝri erere rii anasu braa ʊsɔ ngɛ, oko kuno ni ʊyawro aba okpukporo ni orung bi ite Iyesu. Aka tana nashisha imi sini isi ingɛɛ pie kǝni sini eyi ting na kyarh bakywakywa dang. ");
INSERT INTO khj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iyesu ka sani ɛngɛɛ ni, “Ɔnɔm, ʊma ʊbrʊbrʊnw manw ikrʊ. Kyanw ni ofofuru.” ");
INSERT INTO khj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ni sini Iyesu ni aya ʊpya onuo, opyo orokru kaba ni itina bau ʊni Ijerus, arite ʊna utuno Ayahudiya. Kaba sani Ijerus ngɛ ni, “Ɔnɔnw kywɛrɛ ukpoo, bekya ojo ma avuwa ngɛ igara.” ");
INSERT INTO khj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ni sini Iyesu kʊng kǝna aka sani Ijerus ngɛ ni, “Bekya kung irung; yoro! Anu gya.” ");
INSERT INTO khj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sini afwi ʊna Ijerus, akya noyoro ngɛ ni araru raa kǝni ɛngɛɛ ngɛ. Ibitrus, kǝni Iyohana kǝni Iyakubu adarhi Akwa ɔnɔ kǝni ekperi ngɛ mo oyori ni araa kǝni ɛngɛɛ. ");
INSERT INTO khj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Orokru titiri ɛkǝri ʊna asu tei kǝni ʊwʊra ikywi ngɛ bekai ɛkǝri ɔnɔ. Iyesu kasani ɔmɔni, “Shere utei ngɛ ɛkǝri ɔnɔ se kpo ba, akʊ morowo.” ");
INSERT INTO khj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Orokru ka sina ngɛ, sini ekperhi ngɛ asani ekywere ukpoo. ");
INSERT INTO khj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iyesu ka kpin ngɛ bavu kasani,“Ɔnɔm, shinɛ!” ");
INSERT INTO khj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ʊring ngɛ ko juro bawo idɔɔ ngɛ ekǝ shinɛ akiki bakywakywa dang. Iyesu ka sani ɔmɔni amaa ʊmʊra ara. ");
INSERT INTO khj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Arʊ byere ngɛ kǝjijire, Iyesu ka sani ɔmɔni ebekya tana araru imi sini isi. ");
INSERT INTO khj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nisini Iyesu yirhi ɛkǝri ɔnɔ ʊmɛr ngɛ atarhi ni apari kukum, aka mamo ikrʊ imu ʊyɛri kukum ʊshari kǝni ʊʊma ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aka tuma mo aya tana iring Igumo Ʊnʊng ama aruraa ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Atanimo:“Inyi bakya kpara iririma bi ukyeng nyi, ko ʊshi ukyeng, ʊbʊrhʊ, ʊmʊra, ʊfɛ ko iri igbɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ʊrʊ ʊna sini inyi ba raa, inyi ki burha kekya akywa sini inyi nʊ shere ɛkǝri apya ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ekǝri orokru bana yirha monyi inyi krikri ifraanyi bi ɛkǝri apya eshere mo ʊpɛ itenomo.” ");
INSERT INTO khj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Oko tuno ikpara ka kpin ʊtira kyamo bai apyang yen kekya apyang yan, asu tana iring ididima kǝni ʊʊma orokru ikrʊ kokyu ube. ");
INSERT INTO khj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ikpara dang Ihiridus ogumo Igalili ka kʊng kukum imisini iku kyeng ngɛ. Ekǝ pen uwure ngɛ nagang kii opyo arʊ kusani Iyohana ngɛ ɛshinɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Opyo arʊ susani Iliya ngɛ okuni, opyo arʊ susani irɛ ying bi idɔɔ arʊ pɛrɛ onuo Ʊnʊng uwruwroo ngɛ shini. ");
INSERT INTO khj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ihiridus kasani,“Ikywa Iyohana ngɛ ikywi ngɛ, yip Iyaa we nɛchiyɛn sini ikusu kung edei ʊring men bi ikywie ni?” Bau ʊpʊrha akasu waa sini ngɛ nuri Iyesu ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ikpara sini ɛkǝri ɔnɔ ʊmɛr ngɛɛ ojuri, aka tana Iyesu ngɛ kukum imisini imo si. Ikpara dang aka kparamo ʊsʊsɔ kya opyo apya sini ayirhi ni Ibasaida. ");
INSERT INTO khj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Yip ɛkǝri ushi orokru ka kung owro sini awa kya ngɛ oko kroomo ngɛ. Aka yirhamɔ, ka tanamo irhing igumo Ʊnʊng, ka ma aruraa ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ni ukye ba ʊrɛ ɛkǝri ɔnɔ ʊmɛr atarhi ni apari ka ba eberi ngɛ ka sani, “Shirha ushi orokru men aki akya kidɔɔ ipyang mo kǝni apyang ʊkʊkǝri aya waa ʊmʊra kǝni owro umoro, kii arʊ ni ikarha ni apyang.” ");
INSERT INTO khj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Oko yoromo asani,“Inyi mamo iririma ara.” Aka sani,“Ʊpara ikyɛɛ ʊtɔng kǝni utofuru ʊpari mɔɔ arʊ nʊmɔɔ ʊwɛi arʊ yɛrɛɛ kukum ushi orokru men ʊmʊra?” ");
INSERT INTO khj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ɛrɛrimɛ sini ani burha nusa ʊsɔng ʊtɔng.) Yip akasani ɔnɔ ʊmɛr ngɛ ni, “Inyi samɔ akiki ɛshɛshi sini anusa isititong.” ");
INSERT INTO khj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɔnɔ ʊmɛr ngɛ kasa kǝna, ikuyang ka kiki. ");
INSERT INTO khj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iyesu ka kpara ɛkǝri ʊpara ikyɛɛ ufuforho ʊtɔng, kǝni utofuru ʊpari kasu ro ayaya, kasa ija, kojujurho. Ka ma ɔnɔ ʊmɛr ngɛ akaa orokru. ");
INSERT INTO khj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kukummo aka ra oshushuro, ɔnɔ ʊmɛr ngɛ ko tuno owurhu ngɛ sini aparhi ɛshɛ ɛtirɛ ʊkɔrɔ atarhi ni apari. ");
INSERT INTO khj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ʊpyu Ʊnʊng Iyesu ka shinɛ kyaa ʊsɔrhɔ Ʊnʊng eyeyie. Ɔnɔ ʊmɛr ngɛ mo eyeyimo ani kǝni ɛngɛɛ ngɛ. Iyesu ko gyurhomo asani, “Orokru kʊ pɛrɛ asani imyɛ ini iyaa?” ");
INSERT INTO khj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Oko yoro asani,“Opyo arʊ sini Iyohana ari Ibaptisma, opyo arʊ sini Iliya, opyo arʊ su sani ereying bi idɔɔ arʊ tana onuo Ʊnʊng uwruwroo ngɛ shinɛ.” ");
INSERT INTO khj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Oko gyurho mo asani,“Inyi ʊkany nyi peri asani ini iyaa?” Ibitrus ko yoro asani,“Ʊnwʊɔ ni Ikristi amu Ʊnʊng.” ");
INSERT INTO khj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iyesu ka wɔɔmɔ atung nagang katanamo ebekya tana ararʊ. ");
INSERT INTO khj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Aka sani,“Itɔɔyo ɔnɔ orokru kung igara ededei. Ɛkpɛri, ogu ubyen Ʊnʊng kǝni Avʊwa ʊmɛr ogro nʊ tiramo ngɛ, ɛpɛrɛ ngɛ.Yip awri ʊmang tarʊ Ʊnʊng nʊ shinɛ ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ikpara dang akasani kukummo ni: “Kukum arʊ sini aba waa okroomi ngɛ itɔɔyo atiramo ʊkamɔ akpara agara mo ko ʊkina ʊnʊng okromi ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kii arʊ sini aba waa ʊsha ʊfɛr mo anu taawo, arʊ sini aba taa ʊfɛrmɔ bi ikywim anu sawɔ oforo. ");
INSERT INTO khj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ikimɔyɔ ididima sini orokru nu pen ebe pen kukum eyesing, ataa ʊfɛr ngɛ? ");
INSERT INTO khj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Arʊ sini aba kung ʊwam kǝni iring mi, ɛkǝri Ɔnɔ Orokru nʊ kung ʊwaa bi ikpara sini aba ba bi idɔɔ immɔru ngɛ kǝni imʊmɔrʊ Ɛkpɛri kǝni Atina Ʊnʊng Ʊshisha. ");
INSERT INTO khj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Ʊbrʊbrʊwɔɔ itaniny, opyo arʊ sini atiting bi upen anasu kpomo kekya ikpara sini oborong Igumo Ʊnʊng.” ");
INSERT INTO khj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kekyaa ʊkpin awri ochupari mɔɔ sini Iyesu pɛri iring yen aka kpara Ibitrus ngɛ, Iyohana kǝni Iyakubu aka kirha kyamo ʊsɔrhɔ Ʊnʊng ki aya ukro. ");
INSERT INTO khj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nisini akʊ sɔrhɔ Ʊnʊng itee kǝ tere ʊʊma ʊsɔmɔ ngɛ kasa navarh kǝni uyen ʊnʊng ni. ");
INSERT INTO khj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Akywakywa dang orokru apari ko kuno, Imusa kǝni Iliya asu pya onuo ni Iyesu. ");
INSERT INTO khj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Okuni bidɔɔ imʊmɔrʊ ayaya kasu pɛrɛ sini Iyesu etekya ushere eyesing ngɛ, imisini itekyu ba tirɛ bi Urushelima. ");
INSERT INTO khj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ibitrus kǝni orobyoo kumoro nagang,nisini ʊmɔrɔ karhamɔ oko rong imʊmɔrʊ ngɛ kǝni orokru apari sini atiting kǝni ɛngɛɛ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nisini Imusa kǝni Iliya ku shere Iyesu ngɛ, Ibitrus kasani ɛngɛɛ ni, “Avuwa, ini igyang sini arʊ ni bi upen. Shere arʊ tany ɔsɔrɔ ataru, uying ʊnwɔ, uying ʊmi Imusa, uying ʊmi Iliya.” (Ene kperhi ngɛ ima ʊsʊ pɛrɛ ngɛ.) ");
INSERT INTO khj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ani aya ʊpya onuo, umung ko kuno afraa mo, aka kung irung ngɛ sini arii idɔɔ ɛkǝri umung. ");
INSERT INTO khj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ihywi ko kuno bai idɔɔ ɛkǝri umung, asani,“Ɔnɔm ngɛ we, ikarha akyu woro ngɛ, inyi kung imisini atanany!” ");
INSERT INTO khj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ikpara sini ɛkǝri ihywi karha apya onuo, oko rong Iyesu ni eyeyie. Ekǝri ɔnɔ ʊmɛr kɔ sɔ ɛkǝri iring bi idɔɔmo. Bakywa dang akana tanamo araru imisini erii. ");
INSERT INTO khj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Uwuni ikywa, sini oshuri baa aya ukro, akai ushi ka darha ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Opyo orokru bidɔɔ ɛkǝri ushi kata onuo ayirha ngɛ, “Avuwa isɔrhɔnw akyu upyerhe ɔnɔm, kii ɛngɛɛ ni ɔnɔm eyeyie! ");
INSERT INTO khj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ering ebebi se raa ngɛ akywakywa akan ta akpa kansu nunaa asu ba ʊfʊ bi onuo. Ekǝri ering sesa ʊkɔrhɔ owro bau ushere ngɛ nekǝkǝrhe asu gyurho ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Isɔrhɔ ɔnɔ ʊmɛr nwu oworo ngɛ ɛkǝri ʊring Ishari ngɛ anabramo.” ");
INSERT INTO khj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iyesu ko yoro, “Inyi ipyoo ʊsang ʊma ʊbrʊbrʊ kǝni ari eteting! Ke kyaa akina akywa yo ini kiki kǝni enyi ngɛ asu wura ikywi ne nyi? Ko ɔnɔnw ba ben.” ");
INSERT INTO khj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nisini ɛkǝri ɔnɔ ku kyeng ba, ɛkǝri ering Ishari kǝshwe ngɛ ogyo bi Ibung inamaa kasu ya. Yip Iyesu ka tana ɛkǝri ering Ishari ʊraa ngɛ, kama ɛkǝri ɔnɔ ikrʊ ka naa ekperi ngɛ kyaa. ");
INSERT INTO khj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kukummo kǝ jijire ngɛ ni ʊrɛ ikrʊ Ʊnʊng. Akywa sini kukum orokru ku jijire ni ʊmasini Iyesu sa, akasani ɔnɔ ʊmɛr ngɛ ni, ");
INSERT INTO khj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Inyi kung nɛgbɛn imisini iwa tanany: Anu ma Ɔnɔ orokru bavu arʊ sini ana waamɔ ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Yip ene kpɛrhimɔ imisini akʊ pɛrɛ. Ɔswimo ngɛ karha ekǝ kpɛrhi. Aka darha ngɛ akʊng irung ugyurho ngɛ ɛkǝri iring. ");
INSERT INTO khj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Amaa kǝ shinɛ bi idɔɔ ɛkǝri ɔnɔ ʊmɛr asani iyaa nʊ shoo arite arʊ. ");
INSERT INTO khj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iyesu, kpɛrhi ʊwɔrɔfomo ngɛ bi ikywimo, aka kpara ɔnɔ ajaji ko kyo atiting bi ikwoo. ");
INSERT INTO khj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ikpara dang akasani ɔmɔni,“Arʊ sini aba yirha ɔnɔ ajaji wen bidɔɔ ʊtʊwam ayirhim imyee; kǝnawo arʊ sini aba yirham ayirhi arʊ sini atumim ngɛ. Kii arʊ sini ani ara ajaji bi idɔɔ nyi kukum ɛngɛɛ ni arʊ erere.” ");
INSERT INTO khj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iyohana ko yoro asani, “Avʊwa, arʊ rii araru ku yeri ʊshari bidɔɔ ʊtʊwanw arʊ kasu karha ngɛ, kii asaa bidɔɔ arʊ.” ");
INSERT INTO khj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iyesu kasani,“Inyi bekya akarha ngɛ, kii kukum arʊ sini abana tiraa enyi ani kǝni enyi ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nisini ikpara tokyu fwa sini Ʊnʊng nʊ kpara ngɛ kekya ayaya, Iyesu ko suno ngɛ ni ʊwaa ukya Urushelima. ");
INSERT INTO khj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Aka tuma atina akpi itee, arʊ sini aki opyo apyang Isamariya otuno ngɛ ʊʊma asha ubaa, ");
INSERT INTO khj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","yip ɛkǝri orokru burha ka tiramo ʊyirha ngɛ, kii ani bi ʊtira ukyaa Urushelima wo. ");
INSERT INTO khj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nisini ɔnɔ ʊmɛr ngɛ Iyakubu kǝni Iyohana rii kǝna, oko gyurho, “Ete, ʊwɛi ni arʊ yirha ʊra ba ayaya aki ʊramɔ ngɛ?” ");
INSERT INTO khj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yip Iyesu kǝ tere atana mo ʊraa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ikpara dang Iyesu kǝni ɔnɔ ʊmɛr ngɛ ɔkɔ wɔrɔ kyamo opyo apyang. ");
INSERT INTO khj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nisini akʊ kyeng bi ʊtira, opyo orokru kasani ɛngɛɛ ni, “Ini kroo ʊnwɔ ku kyu ube.” ");
INSERT INTO khj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iyesu ko yoro ngɛ, “Ibri ni igaramo ngɛ ɔnɔnʊng ayaya ni Ibɔru ngɛ, yip Ɔnɔ Orokru saa ni owro sini anusomo ikywi ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Akasani opyo orokru ni, “Kroo mi ngɛ.” Ekǝri orokru ko yoro, “Ete, shere ikya eye mine ɛkpɛrim noru.” ");
INSERT INTO khj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iyesu ka sani ɛngɛɛ ni,“Shere arʊkpo mine opyomo, yip ʊnwɔ kyanw yasu tana iring igumo Ʊnʊng.” ");
INSERT INTO khj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Opyo arʊ ka sani,“Ini kronwuo, Ete, yip shere ikya aya shirha arʊm noru.” ");
INSERT INTO khj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iyesu ka tana ngɛ asani,“Arʊ sini ɛwɛi uwro ni inaa uwro ka kpin ituo inaa, atikpa uwro ikpara dang akasu pyerhe utumo ese maa ʊsa ʊtina bi idɔɔ Igumo Ʊnʊng ba.” ");
INSERT INTO khj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ekǝ kywɛrɛ Ete, ko woro arʊ isi tensara na pari ka tuma mo arapapari asu kyeeng ashubaa ki ko kina apya kǝni owro sini eye kyaa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aka tanamo asani, “Ʊkana ni atana, yip arʊ tina ni aji. Inyi sɔrhɔ Ʊnʊng ngɛ Ete itina akyi a tumanyi ni arʊ ʊtina. ");
INSERT INTO khj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Inyi kya! Iku tumanyi kǝni atam ni bidɔɔ ava orumo. ");
INSERT INTO khj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Inyi be kya kpari ipa ʊfɛ, ʊbʊrhʊ kǝni ataka, Inyi bekya fo araru bi ʊtira. ");
INSERT INTO khj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ʊna sini inyi baraa, inyi fomo ngɛ a sani, ‘Ʊnʊng manyi ʊyari ikywi.’ ");
INSERT INTO khj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ɛkǝri arʊ ʊna ba waa ʊyeri ikywi anu pen ʊyari ikywi, aba na waa ngɛ ʊnʊ juro bawo nʊ nwɔ. ");
INSERT INTO khj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aba yirhanyi inyi ki burha, inyi ra asa imi sini abamany, kii etiri maa sini ama ʊfɛɛ, bekya su kyeng ʊkǝri ina kya ina. ");
INSERT INTO khj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ko kina kywa sini inyi ba kya arapya aba yirhanyi, inyi ra imi sini aminy. ");
INSERT INTO khj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ama arʊ samɔ akrʊ, ikrʊ, atanamo asani, ‘Igumo Ʊnʊng to iyoyou nenyi.’ ");
INSERT INTO khj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Apya sini nyi baraa, abana yirhamɔ nyi, inyi kyany ki tiramo ka tanamo, ");
INSERT INTO khj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ku ukyuro apyany sini ʊkpin arʊ bi ifraa arʊ nʊ pʊnanyi mo. Arʊ wɛini inyi kperhi ngɛ asani igumo Ʊnʊng to iyoyow nenyi.’ ");
INSERT INTO khj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ikʊ tani nyi ʊnʊng ʊkyɛrhɛ ʊring Ʊnʊng nʊ pri nʊ ʊkʊng okwo Isɔdɔm ni apya dang. ");
INSERT INTO khj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Okwo ne nyi arʊ Ikorazin!, Okwo ne nyi arʊ Ibasaida!, Ana akyusani, ʊʊma ujijire men asi bidɔɔ nyi ni asamo bi Itaya kǝni Isidɔn. Uwruwro anakyu shere eteting ngɛ a shere ʊya ngɛ, akiki bi bʊng, ɔsɔmo ʊʊma ukrukru azara ʊtɔng bi inamamo. ");
INSERT INTO khj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Inu pri Itaya kǝni Isidɔn ʊnʊng ʊkyɛrhɛ ʊring ne nyi. ");
INSERT INTO khj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Inyi ari Ikafarnahum inyi kung anu shwe nyi kya ayaya?. O-o, anu fen nyi kya apya ering. ");
INSERT INTO khj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Arʊ sini aba kuny akum, arʊ sini aba tiraa nyi, atira eme, arʊ sini aba tiraa emye atira arʊ sini atumim.” ");
INSERT INTO khj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ɛkǝri arʊ isitensara ni apari juri ni ʊmɛ, kasu sani, “Ete ni, ʊshari sa kung arʊ, arʊ ba yirhi ʊtʊwanw.” ");
INSERT INTO khj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iyesu kasani omoni,“Iri Ishari kpi kǝni iyɛyɛrhi ni ba ayaya. ");
INSERT INTO khj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rong!, Imany ikrʊ ʊtɛɛ Iyow kǝni Inang kukum, ka manyi ikrʊ kukum bayi arʊ sini ana waamɔ nyi, bai rima sini inʊ rany inama. ");
INSERT INTO khj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inyi bekya ɛmɛ asani ering eteting kuniny inyi ba waa ʊmɛ, inyi mɛ asani ɔwɔrɔ ʊtʊwany ba yaya.” ");
INSERT INTO khj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ba kywa dang Iyesu kǝ tirɛ ni eme bi idɔɔ ʊring ʊshisha, aka sani,“Ɛkpɛrim, Ete arayaya kǝni eyesing! Isanw ija kii ʊsɔ ɛrɛsɛr kǝni arʊ kperhi ʊring ngɛ ni ʊmamen ka ba eyen Ɔnɔ ajajirhi. E, kǝnawo, ɛkperim ʊwaanwu wurha. ");
INSERT INTO khj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ɛkpɛrim mam ikukin. Ba arʊ sini ɛkpɛrhi Ɔnɔ sai Ɛkpɛri. Kǝnawo baa arʊ sini ɛkpɛrhi Ɛkpɛri ngɛ sai Ɔnɔ arʊ sini Ɔnɔ bo yoro ni ngɛ anu yen ngɛ Ɛkpɛri.” ");
INSERT INTO khj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iyesu kǝtere eberi ɔnɔ ʊmɛr ngɛ ʊsʊsɔ kani, “Onuo adadʊma arʊ sini erii imisini inyi rong. ");
INSERT INTO khj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Itana inyi asani, arʊ pɛrɛ onuo Ʊnʊng kǝni ogumo napany awa urong imisini inyi rong onoromo, awa ʊkʊng imisini inyi kung ene pen mo ʊkʊng.” ");
INSERT INTO khj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Upyu ʊnʊng avʊwa ʊmɛr ogro Imusa shini awa marhi Iyesu ngɛ. Okɔ gyurho, “Avʊwa, ikimoyo inisa kǝ pen ofo ʊshishaa?” ");
INSERT INTO khj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iyesu ko gyurho ngɛ, “Ikimo iring (ogro) Ʊnʊng peri? Ʊkpɛrhi ngɛ nenyee wo?” ");
INSERT INTO khj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ɛkɛri orokru ko yoro kasani owori bidɔɔ iring Ʊnʊng kasani “ ‘Waa Etenw kǝni Ʊnʊng nwu, ni kukum ikywinw, ni kukum Ipanw, ni kukum ikrʊ, kǝni kukum ʊwɔrɔfonw’, ‘Ka waa ari yoyou ni ʊnwɔ kǝni sini ʊwɛi ʊkanw ni.’” ");
INSERT INTO khj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iyesu ko yoro ngɛ kasani,“Ʊpɛrɛ nɛmɛr. Kya ya sakǝna ʊni gya.” ");
INSERT INTO khj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ɛkǝri avʊwa ʊmɛr ogro Imusa ka waa ukurho ʊkaa, ka gyurho Iyesu asani, “Iyaa ni ari iyoyow ni ɛmyɛ?” ");
INSERT INTO khj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iyesu ko yoro ngɛ ka sani, “Upyu ʊnʊng opyo orokru ku kyeng asu tashuro ngɛ bai Urushelima kekyaa Ijeriko, aka kpaa ba avu eyi ʊtira. Oko woro ngɛ ʊʊma ngɛ, aka kraa otow ʊpɛrɛ, ka kyamo ni ikpara ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Anakywa naji ipyoo ogoku ubyen Ʊnʊng kasu kyeng bi ʊtira dang, ko rong orokru yari aka buban ngɛ kyaa. ");
INSERT INTO khj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kǝnawo opyo ɛyɛri Ilevi bi ko bo roo ka buban akpin ʊtira kyaa kaa. ");
INSERT INTO khj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ipyii Isamariya ni bo kyoro ngɛ, ka ba rong orokru sini eyi krie ayari aka kung okwoo. ");
INSERT INTO khj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Aka kya ka puna ngɛ onuru ka saa ɛnyɛ ngɛ ka saa asira ngɛ, ko lorho ngɛ ni ʊtʊgbɛ. Ka shwe ngɛ a saa bayi Ijaki aya ma opyoo arʊ bi ʊna ushuro ekyeng aki asu roo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Uwunikyaa akaba ma ɛkǝri arʊ ʊna ushuro ekyeng udinari kani ɛngɛɛ ni ro ngɛ imi sini ube pɛrɛ ngɛ ini ba kpuranw ibɔsɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Bidɔɔ arataru men, bidɔɔ ikywinw, iyaa epri ni iyoyow ni arʊ sini akpi ba avu eyi ʊtira?” ");
INSERT INTO khj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ɛkǝri avuwa ʊmɛr ogro ko yoro ka sani, “Arʊ sini akung okwo.” Iyesu kasani ɛngɛɛ ni, “Kya ya sa kǝna kanw.” ");
INSERT INTO khj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sini Iyesu mo kǝni arʊ kro ngɛ akʊ kyeng kyamo Urushelima aka fwa anapyang, opyo erere sini ayirhi ʊtʊwa ngɛ ni Imata aka yirha ngɛ bi idɔɔ ʊnaa. ");
INSERT INTO khj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ani ɔfɔrɔ ngɛ sini ayirhi ngɛ ni Imeri arʊ sini akiki bi ikwo ifraa Ete asu kung ʊmɛr ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Imata kasu shishishii ukyene ʊmʊra, aka ba owro Iyesu kasani ɛngɛɛ ni, “Ete unorong sini ɔfɔrɔm sherim eyeyim iku sa ʊtina? Tana ngɛ aba sham ngɛ!” ");
INSERT INTO khj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ete ko yoro ngɛ ka sani, “Imata, Imata,” “Ikywinw burayo uku kung anang ni ʊʊma napany. ");
INSERT INTO khj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ima iying yo ini ididima, Imeri karha woro imasini ipri ni idima, imi sini ba arʊ sini anu karha ngɛ bavuɔ.” ");
INSERT INTO khj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Upyu ʊnʊng Iyesu ku sɔrhɔ Ʊnʊng bi opyo owro. Sini ekywere, opyo arʊ bi idɔɔ Ɔnɔ ʊmɛr ngɛ ka sani ɛngɛɛ ni, “Ete, mɛr arʊ sini arʊ nʊ sɔrhɔ Ʊnʊng kǝni sini Iyohana mɛr Ɔnɔ ʊmɛr ngɛ ni.” ");
INSERT INTO khj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Iyesu ka sani moni, “Inyi bawaw ʊsɔrhɔ Ʊnʊng, inyi sɔrhɔ kǝn: “ ‘Ɛkpɛri, she arʊ ngɛ arʊ dɔ Ʊtʊwanw, aki igumo nwu ba. ");
INSERT INTO khj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Maru ʊmʊra sini arʊ wɛi ku kina ʊnʊng ");
INSERT INTO khj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","pʊna arʊ ʊyarʊ ngɛ, kǝni sini arʊ se pʊna arʊ ʊyarʊ ni. Bekya kong arʊ kya iberi ʊmarha.’ ” ");
INSERT INTO khj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iyesu ka sani ɔmɔni, “Asani araru bi idɔɔ nyi ani orokyoro ngɛ, aka kya eberi ngɛ ni abarating ating, ka sani ɛngɛɛ ni, ‘Orokyorom, mam ʊta ʊmʊra ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ima orokyorom sini okuni baa okyoro, uwe isam imisini ini maa aki ara.’ ");
INSERT INTO khj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɛkǝri orokyoronw bai ididang ka sani, ‘Bekya ewurem. Akarha afra ɔnɔgrɔ, imye kǝni ɔnɔm arʊ karha yarimɔ, ina bram ʊshinɛ amanw iririma.’ ");
INSERT INTO khj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Isini enyi ni abadana su shinɛ ngɛ amanw ʊmʊra, bekai sini inyi ni orokyoromo, yip bekai ʊsang ʊwanw uko sunonwuo ʊkwʊna ɔnɔgrɔ nagang anʊ shinɛ amanw amarha ima sini ʊwɛi. ");
INSERT INTO khj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kǝnawo itanany: Inyi gyurho kii anʊ many; Inyi waa Inyi nʊ pen; Inyi kwʊna ɔnɔgrɔ anʊ yɛɛ nyi. ");
INSERT INTO khj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kii kukum arʊ sini obo gyurho anu yirha. Arʊ sini aba waa anu pen. Kǝnawo arʊ sini aba kuna ɔnɔgrɔ anu yɛɛ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Akina ekperi ngɛ bi idɔɔ nyi, Ɔnɔɔ bo gyurho ngɛ Itofuru, aka ma Iyowbi ʊka Itofuru? ");
INSERT INTO khj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kii obo gyurho ngɛ Ikpa, aka maa Inang? ");
INSERT INTO khj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Iboshoo inyi, ereteting kperhi ʊʊma Ɔnɔny iima igigyang ngɛ, ka parha ɛshɛ Ɛkpɛri nyi kya ayaya anu ma kukum arʊ sini ɔsɔrhi ngɛ Ering Ʊshisha!” ");
INSERT INTO khj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Upyu ʊnʊng sini Iyesu ku yeri ishari bi idɔɔ orokru sini anabraa ʊpya onuo. Ni sini ɛkǝri ishari kuniyo, ɛkǝri orokru sini anabraa ʊpya onuo, kasu kapya onuo, ɛkǝri ushi orokru kǝ jijire. ");
INSERT INTO khj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yip opyo arumo kasani, “Brʊbrʊ akʊ yeri ʊshari. Epen ikrʊ ba eberi Ibelzebul, ogumo ʊshari.” ");
INSERT INTO khj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Opyo arʊ ka waa ʊmarha Iyesu ngɛ, oko gyurho ngɛ ani eyenmo ʊpɛ iririma ba ayaya. ");
INSERT INTO khj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iyesu kperhi ʊwɔrɔ ofomo ngɛ, aka sa ni ɔmɔni: “Igumo sini orokru ku pya ɔkɔɔ ni ipyoo inasʊ dɛrhɛyo ngɛ, kǝnawo ʊna sini ukong ɔkɔ ni ʊkawɔ inu sarhayo. ");
INSERT INTO khj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ishari bating ite ni ʊkaa anu sane nye igumo ngɛ kating? Igyurhiny kǝn, bekai sini inyi kpari asani iku yeri ʊshari ni ikrʊ Ibelzebul yo. ");
INSERT INTO khj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nɛchiyɛn ibeyeri ʊshari ni ikrʊ Ibelzebul, arʊ kro nyi ngɛ ku yerimo ni ikrʊ iyangyo? Iboshoo kǝnawo ɔmɔmɔ anushoo arʊ kyɛrhɛ ʊring nyi. ");
INSERT INTO khj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yip iboshoo iku yeri ʊshari ni ikrʊ Ʊnʊng yo, Igumo Ʊnʊng ba bi idɔɔ nyi wurha. ");
INSERT INTO khj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Akywa sini arikru, ani ʊʊma ʊraa ngɛ ne terh, asusha ʊnaa ʊmaa ni bi ʊyari ikywi. ");
INSERT INTO khj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yip ikpara sini arʊ sini epri ngɛ ni ikrʊ be shinɛ ɔkɔɔ ne ngɛ, eyen ngɛ ikrʊ, anu karha ngɛ ʊʊma ʊraa sini atirikywi ngɛ aka kaa ʊkaadima ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Arʊ sini asaa kǝni ɛmyɛ ngɛ ating ite ni ɛmyɛ, arʊ sini asaa sutuno kǝni ɛmyɛ ngɛ, arʊ sarha ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ikpara sini ering ishari bo kuno ngɛ bi idɔɔ orokru, ese kya eberi akwakwʊrʊ ʊwaa owro uwuro, abana pen ngɛ, akan sani, ‘Inʊ juro kyam ʊna sini isheri ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ni sini obo juro anʊ darha ɛyɛrhɛ ɛkǝri ʊna napʊpʊrhi okyowo nɛmɛr. ");
INSERT INTO khj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ikpara dang anu juro kya aya barha ering ʊshari eten sara sini epri ngɛ ni eteting aka raa akiki burha. Ʊkiki ɛkǝri orokru bi ikpara dang ka burawo epri ʊmi itee.” ");
INSERT INTO khj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ikpara sini Iyesu naya ʊtana ʊring men opyo erere ka ta onuo bai idɔɔ ushi orokru, “Ʊnʊng ta akwa sini ebyerinw, eprinw onuo adadʊma.” ");
INSERT INTO khj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Iyesu ko yoro ngɛ asani, “Ʊnʊng pri ni ʊta arʊ sini akʊng irhing ngɛ asu ʊtina niyo onuo adadʊma.” ");
INSERT INTO khj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ni sini ɛkǝri eshi orokru ku fɔnɔ, Iyesu ka sani, “Orokru ipyoo yen ni eteting. Ewei ni eyenmo ʊpɛ, yip imi sini Inushoo uyenmo iyoyoo ini ʊpɛ Ijona. ");
INSERT INTO khj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kii kǝni sini Ijona ni ʊpɛwɔ eberi ari Inineva ni, kǝnawo ɔnɔ orokru nushoo ʊpɛwɔ eberi ipyoyen. ");
INSERT INTO khj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ʊnʊng ʊkyɛrhɛ ʊring, Ogumo erere ibʊng Isheba anʊ titing burha kǝni orokru ipyoyen ngɛ eyen mo ni imi sini akusa isayo igyang. Bekai sini abii bai akurha eyesing kya ki ikǝkarha ʊkʊng ʊkpɛrhi Ogumo Isolomon. Nɛchiyɛn opyo arʊ sini ipri Isolomon ngɛ we ani ben. ");
INSERT INTO khj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ʊnʊng ʊkyɛrhɛ ʊring ari Inineva nʊ ting eyen mo ni imi sini akusa isai igyang, kii eshere ʊya ngɛ akywa sini Ijona tanimo irhing Ʊnʊng. Uwe nɛchiyɛn arʊ sini epri Ijona ngɛ we. ");
INSERT INTO khj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Araru nasu taa uyen oko kyowo bi owro sini ɔsusi. Araru nasu taa uyen afraawo ni isong. Anu kyowo bi owro ukyo uyen sini arʊ keba nʊ ru uyen. ");
INSERT INTO khj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ikranwyo inu uyen inamanw. Ikranw boshoo ikrʊInamanw kukum nʊ tirɛ ni uyen. Yip iba sayo ikrʊ inamanw kayo inu tirɛ ne eting. ");
INSERT INTO khj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sa sini uyen ushoo bidɔɔnwʊ naw terewo oshoo eting. ");
INSERT INTO khj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Boshoo inamanw kukum itiri ni uyen, eting neshiyo ngɛ bi irisha, inamanw nʊ tirɛ ni uyen kǝni sini uyen se ta bayanw ni.” ");
INSERT INTO khj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ni sini Iyesu kywɛri ʊpya onuo, opyo Afarisi kayirha ngɛ ʊra ʊmʊra bidɔɔ ʊnaa; aka kya aya kiki kǝni omoo bi owro ʊra ʊmʊra. ");
INSERT INTO khj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yip ɛkǝri Afarisi kǝjijire ni sini orii Iyesu rii ʊmʊra baa ukurho ivʊ. ");
INSERT INTO khj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ikpara dang Ete ka sani ɛngɛɛ ni, “Inyi Afarisiya dirhi ni utumo ɔsɔng kǝni isɔng, yip idɔɔ nyi tiri ni ʊwaa ikywi kǝni eteting. ");
INSERT INTO khj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Inyi obobo orokru! Sii Ʊnʊng ngɛ ekyeni esing ojo kǝni idɔɔ? ");
INSERT INTO khj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yip inyi ma arʊ sini ɛwɛi ni ikywi iying imi sini inyi niyo, ikpara dang ikukying nusany napʊpʊrhi. ");
INSERT INTO khj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Yip okwo nenyi Afarisiya, kii inyi mi Ʊnʊng ngɛ ima iying bi idɔɔ atarhi bai idɔɔ ani ʊʊma ajajirhi sini inyi se pen kǝni ayaa ukyene ʊmʊra ʊmʊ sini inyi wrini, yip inyi kata utumo ni iring ʊbrʊbrʊ adarhi ʊwaa Ʊnʊng. Imi sini inyi tani ʊsaye bai itee ojo dirha ʊsa ʊman. ");
INSERT INTO khj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Okwo nenyi Afarisiya, kii inyi pri ni ʊwaa owro ʊkiki ɔmɔmɔrʊ bi owro utuno Ayaudiya, awaani orokru fony, ufo ʊmʊmɔrʊ bi ize. ");
INSERT INTO khj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Okwo nenyi, kii inyi ni kǝni ɔgrɔn sini ana tamo ʊpɛ ngɛ ni, orokru kasu kyeng bayaa baw kperhi.” ");
INSERT INTO khj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Opyo avuwa bi idɔɔ avʊwa ʊkpɛrhi ogro, ko yoro Iyesu ngɛ asani, “Avʊwa, ʊtira arʊ bi ikpara sini uku pɛrɛ ʊring men.” ");
INSERT INTO khj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iyesu ko yoro, “Inyi avʊwa ʊkpɛrhi ogro, okwo ne nyi kany, kii inyi so lorho orokru ikpara ʊʊma sini anabramo ukong, inyi ʊkarha ikywiny inyi natany mo ani ivʊ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Okwo ne inyi, kii inyi vuri arʊ pɛrɛ onuo Ʊnʊng ɔgrɔn. Arʊ sini ekperi nyi mo epyerhimo. ");
INSERT INTO khj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kǝnawo inyi yen asani inyi yoro ni imisini ɛkpɛri nyi si. Ɛpyerhi atina Ʊnʊng inyi ka vura mo ɔgrɔn. ");
INSERT INTO khj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bekai kǝnawo, Ʊnʊng bidɔɔ ʊkpɛrhi ngɛ aka sani, ‘Ini tumamo ni arʊ tana onuo Ʊnʊng kǝni ɔnɔ ʊmɛr ami sini opyo arʊ bi idɔɔmo anʊ pɛrhɛmɔ ama opyo arʊmɔ igara.’ ");
INSERT INTO khj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kǝnawɔ eyi kukum arʊ pɛrɛ onuo Ʊnʊng sini epyerhimo wro bai ikpa eyesing, nʊ shoo baya orokru ipyoyen, ");
INSERT INTO khj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","bai eyi Abila kya ki eyi Izakariya, arʊ sini ɛpɛri ngɛ ba para ʊnara kǝni ʊna Ʊnʊng. Iku tanany ʊbrʊbrʊ, anu waa eyimo kukum bavu ipyoyen. ");
INSERT INTO khj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Okwo ne nyi avʊwa ʊkpɛrhi ogro, kii inyi karha akpara ʊmʊ yɛɛ ʊkpɛrhi ngɛ. Inyi ikywiny na raa nyi akarha arusu raa ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ikpara sini Iyesu kuni ngɛ esing ɛkǝri Afarisi kǝni avʊwa ʊmɛr ogro Imusa kasu tana ʊring ubibi bi ikywie ni ʊbʊra ikywi kasu waa ngɛ ni ogyurho ʊring adedei, ");
INSERT INTO khj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","asu sha ʊwaa ʊkpin ngɛ ni iririma sini anushe ʊpɛrɛ. ");
INSERT INTO khj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ni sini, eshi orokru ʊsʊsɔng tuni, asu tɛɛ opyoomo, Iyesu kasu pɛrɛ ni ɔnɔ ʊmɛr ngɛ noru, aka sa nɔmɔni, “Inyi sa noshong ni edei ʊmɛr upre eteting Afarisiya use sa orokru ibobomo wurha. ");
INSERT INTO khj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Akywa yeba amu sini iririma sini afrii anu yɛɛ yo, imi sini ini ʊsʊsɔ anu kperhi yoo. ");
INSERT INTO khj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kukimo inyi bɛpɛrɛ bidɔɔ eting anʊ kʊyo bidɔɔ uyen, imisini inyi bɛpɛrɛ iwɛrhiwɛ bi ikuu idang anʊ tanayo ayaya kyaya ʊsɔrɔ ʊbɔrʊ aki orokru kukum kʊwɔ. ");
INSERT INTO khj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Iku tanany, orokyorom, inyi bekya kung irung arʊ sini anu Peri inamany, bi ʊkywɛrɛ anabramo ʊsany iririma. ");
INSERT INTO khj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ting itananyi arʊ sini inyi nʊ kung irung ngɛ; Inyi kung irung arʊ sini, abakyu pɛrɛny ani ikrʊ fennyi ngɛ kidɔɔ igara ʊra. Iringyo itaniny, inyi kʊng irʊng ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sa ɔnɔ ʊgyʊrhʊ ɔtɔng mo ese gbuna ikiri ʊfɛ ʊpari? Ni kǝna Ʊnʊng sene yuro ngɛ ni ereyingmo. ");
INSERT INTO khj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ko ʊfʊrhi ikywiny Ʊnʊng kperhi ʊrɛmɔ ngɛ. Bekya kung irung; Imɔriny pri imu ushi ɔnɔ ʊgyʊrhʊ. ");
INSERT INTO khj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Itanany ʊbrʊbrʊwɔɔ, arʊ sini anuting bi ite orokru a sani ingɛɛ ni arʊ kroo mi ngɛ, Imye Ɔnɔ Orokru Inutana bi ite Atina Ʊnʊng ni ani arʊ kroo mi ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yip arʊ sini aba tiraa ngɛ emye bi ite orokru, anu tiramo ngɛ bi ite atina Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kǝnawo arʊ sini ɛbɛpɛrɛ iring ibibi bi ikywi Ɔnɔ Orokru anʊ pʊna ngɛ ʊyaa ngɛ, yip arʊ sini aba tana irhing ibibi bi ikywi Ering Ʊshisha anasʊ pʊnamɔ ngɛ ʊyaa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Akywa sini orokru bokong nyi ba owro utuno Ayaudiya, kǝni eberi arʊ kyerhe ʊring adarha ari igumo bekya wure ʊkanw ni imisini ʊnʊ yoromo kǝni imisini ʊnʊ tanamo, ");
INSERT INTO khj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kii bakwya dang Ering Ʊshisha nʊ mɛr nwu imasini ʊnʊtana.” ");
INSERT INTO khj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Opyoo arʊ bi idɔɔ ushi orokru ka sani ɛngɛɛ ni, “Avuwa, tana arupyam akaa ʊʊma ekperi arʊ sini okpue amam ʊmyɛ.” ");
INSERT INTO khj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iyesu ko yoro ngɛ, “Orokyoro, iyaa mim ushoo arʊ kyɛrhɛ ʊring, kii iyaa mim apara ʊkaa nyi edei imayen?” ");
INSERT INTO khj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aka sanomoni, “Inyi sa noshong asha ʊkany ni ko kina dǝi ʊwaa ikywi, kii ofony si ʊʊma sini inyi tuni moo ʊni ushony ba.” ");
INSERT INTO khj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aka tanamo ushosho wen ka sani: “Abya opyo orokru shuri ikiri nɛgbɛn. ");
INSERT INTO khj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oko wɔrɔ ofo aka sani ʊkaa ni, ‘Ikimoyo inisa? Isam ni owro ɔgrɔɔ sini inukyo ʊmam ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ikpara dang aka sani, ‘Imi sini ini saye, ini vɛrhɛ ɔfɔm ngɛ aka vura ɔkɔkɔ, ʊpʊrhawɔ inukyo ʊmʊram kǝni ʊʊma ududumam ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Akasa ni ipam ni, “Ini akai ʊmʊra ngɛ, yarinw ɛnyɛɛ napany, kpara noshong, asu ra, asu sa, asu kung ididima ʊkanw.” ’ ");
INSERT INTO khj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Yip Ʊnʊng ka sani ɛngɛɛ ni, ‘Ʊnwʊɔ obobo! Ni eting yen anʊ waa ofonw. Nɛchiyɛn ʊʊma sini utuni nʊ shoo umu iyaa?’ ");
INSERT INTO khj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Kǝnawo ushoo arʊ sini okywi ʊkamɔ ʊʊma be eyesing, yip oshoo ara ayarha bi ite Ʊnʊng.” ");
INSERT INTO khj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ikpara dang Iyesu ka sani ɔnɔ ʊmɛr ngɛ ni: “Ʊwɔwɔ Itaniny, inyi bekya wure ni ʊkikiny, imi sini inyi nura kǝni imi sini inyi nʊ sɔmɔ bi inamanyi. ");
INSERT INTO khj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kii ʊfɛnnyi pri imura, inamanyi kayo ipri ʊʊma ʊsɔmɔ. ");
INSERT INTO khj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Inyi rong ɔnɔnʊng. Ana puramɔ ana kanamɔ, asamɔ ni iboru ukyo ʊmʊra ngɛ, asamɔ ni ɔfɔ ngɛ: yip Ʊnʊng kupirimo. Inyi ne pri nyi ɔnɔnʊng ni imimɔrʊ? ");
INSERT INTO khj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Iyaa bidɔɔ nyi bidɔɔ uwure ngɛ anushu sai itɔmɔ akywa iying ngɛ bi ʊfɛr ngɛ? ");
INSERT INTO khj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bushoo inyi nabrany ʊsa animawen, ikisi inyi ku wure ʊkany ni ʊparha she ʊʊma? ");
INSERT INTO khj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Inyi rong sini ufurho orumo se mɛrɛ. Ana sirhamɔ itina ene kyenemo ʊmʊsɔmɔ. Yip iku tananyi, ogumo Isolomon kǝni imʊmɔrʊ akai ʊmaa dang ngɛ, ese sɔmɔ ngɛ edei ʊʊma ʊsɔmɔ ududuma kǝni ereying bidɔɔ ufurho men ni. ");
INSERT INTO khj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Uboshoo kǝnawo Ʊnʊng se sɔrɔ ʊbʊng orumo, sini uniben ɛchiyɛ, ikywa akwunamo kidɔɔ ʊra, anu sane nyee ene pri ngɛ ni ʊsɔrɔ nyi ʊʊma? Inyi arʊ larha uyoro! ");
INSERT INTO khj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bi kǝna bekya wure ʊkany ni imisini inyi nura kǝni imisini inyi nusa inyi bekya wure ʊkany niyɔ. ");
INSERT INTO khj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kii arʊ sini ɛnɛkpɛrhimɔ Ʊnʊng bi eyesing mɔ ese su wɔrɔ ofo ʊʊma men. Ɛkpɛriny yoo asani inyi wɛi ʊʊma men. ");
INSERT INTO khj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Inyi ti ʊwaa igumo Ʊnʊng bi ite, kii Ʊnʊng nʊ many kukum ʊʊma men. ");
INSERT INTO khj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Inyi bekya kung irung, ene eshi arʊkroo mi ngɛ, kii Ɛkpɛri nyi kunegben ni ʊmany ɛkǝri igumo. ");
INSERT INTO khj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Inyi gbuna ʊkaadumanyi ngɛ akaa ara ayarha. Ekyene ʊkany ipa ʊfɛ sini inasʊ kɔrɔyo, ko asani iburayo. Inyi kyo ʊka adʊma nyi kya ayaya ʊmisini ʊnasu kywɛrɛwo, owro sini eyi neke baa uyurho adarha ngɛ iyi nasu rayo. ");
INSERT INTO khj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kii owroo sini ʊkaadumanw nuwo bi ʊpʊrhawɔ ikywinw nuwo adarha ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Sɔmɔ ʊʊma ʊtina, eshere ifitilany isura ʊra, ");
INSERT INTO khj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","kǝni orokru sini akusha Ete sɔɔ baa owri ipara ubara, kii ikpara sini abakyuba aba kuna ɔgro, anu yɛɛ ngɛ ɔgro bakywakywa dang. ");
INSERT INTO khj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Agara sini Ete ʊnamɔ darhimɔ akusha ukye baa, nʊkʊng ididima. Iku tanany ʊbrʊbrʊwɔɔ arite nʊ somo ʊʊma ʊwaa ʊsa ʊtina, anʊ sa agara kiki aka ba mamɔ ʊmʊra. ");
INSERT INTO khj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Agara sini akʊ sha dang anu mɛ, bodoshoo ni abarating etingyo kii ʊba ʊyɛrɛ itikywa. ");
INSERT INTO khj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Inyi kperhi irhing yen ngɛ, asani ari ʊna nʊ kperhi ikpara sini eyi kyeba ʊnaa anau shere ngɛ aki ɛvɛrhɛ ngɛ ʊna araa. ");
INSERT INTO khj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Itɔɔyo inyi ʊkany nu kyene ʊkikiny, kii imye Ɔnɔ orokru kyeba bakywa sini inyi ne kperhiny ni ekye ba.” ");
INSERT INTO khj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ibitrus ko gyurho ngɛ asani, “Ete, uku tana arumo ɔnɔ ʊmɛr nwu ushoshoo wen, Kii kukum orokrumo?” ");
INSERT INTO khj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ete ko yoro asani, “Nɛchiyɛn iyaa ni arite atina arʊ uyen ʊbrʊbrʊ kǝni ɛsɛr ngɛ, sini ete ʊna nʊ shere ʊfɛ ʊmʊra agara ngɛ bavuɔ amamɔ bidɔɔ kywa? ");
INSERT INTO khj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Agara dang sini ete ʊnaa bosoo anu darha ngɛ asa ʊtina ngɛ nɛgbɛn, anu kʊng ididima. ");
INSERT INTO khj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Itaniny ʊbrʊbrʊwɔɔ, aritee nʊ shere ʊʊma ʊnaa kukum bavuɔ. ");
INSERT INTO khj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ikpara sani ɛkǝri agara ka kpara bidɔɔ ikywi a sani, ‘Ete ʊnam yo otuturo ngɛ,’ Ikpara dang aka kpin ʊkra ʊparha ɛshɛ agara ɛrɛrimɛ kǝni agara erere, kasu ra kǝni ʊsa avuvuna. ");
INSERT INTO khj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ete ʊna agara dang keba ʊnʊng sini onokyoo ni ekye ba kǝni akywa sini ene kperhi ngɛ. Anu kyerhe ngɛ owowurhu emurhe ngɛ ki eberi arʊ ʊsang ʊma ʊbrʊbrʊ. ");
INSERT INTO khj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Agara dang sini ekperhi imisini ete ʊna wɛi ngeni aka tira ngɛ ukɛne ʊkiki, a tira ngɛ ʊsa imisini ete ʊna wɛi nʊkʊng ʊta uturu ededei. ");
INSERT INTO khj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yip agara sini ɛnɛkpɛrhi ngɛ imisini ete ʊna wɛi, akasʊ sa imisini imaa ʊkra anutaa uturu naji. Arʊ sini Ʊnʊng mie napany, anuwaa asani asaa ʊtina napany, arʊ sini amie epri napany, Ʊnʊng nuwaa ni asaa ʊtina epri napany. ");
INSERT INTO khj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ibii uturo ʊrawɔ bi eyesing, asani ʊwaa miwɔ ʊna kyusu yirha. ");
INSERT INTO khj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ini igara ibaptisma ibibi ngɛ bi item, kǝni uwure nagang ke kya akywa sini inu tirɛ. ");
INSERT INTO khj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Inyi ku wɔrɔ ofo ni iku ʊyari ikywi ba be eyesing? Isayo kǝna, iku tananyi, iku ubanawo ba ");
INSERT INTO khj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bai ʊkaimen orokru nʊ shoo ɔtɔng bi ʊnamɔ anʊ bana ating ite ni opyo, ara taru nʊ ting ite ni ara pari. Ara pari ni ting ite ni ara taru. ");
INSERT INTO khj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Anu bana, ekperi nuting ite ni ɔnɔ, ɔnɔ nʊ ting ite ni ekperie akwa nuting ite ni ɔnɔɔ, ɔnɔ nuting ite ni akwaa, akwekyerhe nuting ite ni abara ngɛ, abara nʊ ting ite ni akwekyerhe ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iyesu ka sani ɛkǝri ushi orokru ni, “Inyi bakyu rong umung kutuno bi ʊrɛ bakywakywa dang inyi kan sani, ‘Avra nʊ kpaa,’ akan kpaa. ");
INSERT INTO khj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Akywa sini uwroo ba pya baa ata, inyi kan sani, ‘anu sa ʊpara,’ akan sa. ");
INSERT INTO khj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Inyi arʊ pre eteting! Inyi kpɛrhi sini inyi nʊpɛrɛ ushoo eyesing ngɛ kǝni ayaya ayarhi imung. Anu sane nyee inyi ne kpɛrhiny sini inyi nʊpɛrɛ enyen akywa amukai men? ");
INSERT INTO khj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ikisi inyi nabrany ʊkywa imisini inɛmɛr nivuny? ");
INSERT INTO khj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ikpara sini inyi basu kyeng kyany eberi arʊ kyɛrhɛ ʊring kǝni eshuwenw. Sunonwoo sini inyi nukyene uwure nyi kǝni ɛngɛɛ bi ʊtira karha ɔkyowɔnw kyekya ite arʊ kyerhe ʊring. Arʊ kyerhe ʊring kya naanwu bavu arite aranishi, arite aranishi ke lorhonw ɛfɛn nwu ki ʊbɔrʊ eting. ");
INSERT INTO khj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iku tananw ʊnʊ kpura ikiri ʊfɛ napʊpʊrhi ko shoo nukuno.” ");
INSERT INTO khj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ba akywa dang arʊ sini ani burha aka tani Iyesu ngɛ asani Ibilatus karha akyu ma apara ɛpɛrɛ opyo orokru ari Igalili akywa sini akʊ ma ikara be ubyen Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iyesu ka yoromo ka sani, “Inyi ku wɔrɔ ofo asani ari Igalili men epri orokru kukum ni uyawo usi akʊ kung igara kǝn? ");
INSERT INTO khj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iku tanany, isayo kǝna! Inyi bana shereny ʊyaa okroo Ʊnʊng ngɛ, inyi kany inyi nʊ kpoony kukumnyi. ");
INSERT INTO khj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Inyi dirha ni ari atarhi ni ochupari sini igren Isiliyom kpii bayamo ɛpɛrhɛmo inyi ku wɔrɔ ofo ni epri arʊshoo bidɔɔ Urushelima ni uyawo? ");
INSERT INTO khj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iku tanany, isayo kǝna! Inyi bana shereny ʊyany ngɛ okro Ʊnʊng ngɛ inyi kany inyi nukpoony kukumnyi.” ");
INSERT INTO khj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iyesu ka tanamo ushosho wen asani, “Opyoo arʊ puri ʊshi uwee bidɔɔ ɔvroo upyunung aka kyu ʊkarha osumo ngɛ ekɛne pen ngɛ iririma. ");
INSERT INTO khj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Aka sani arʊ sini akʊ shaa ɛkɛri ɔvro ngɛ ni, ‘Ɛnyɛɛ atarʊ me nɛchiyɛn sini iku ber uwaa usumo ʊshi uwee wen ise pen mi iririma. Kpawo ɛfɛn bi ibʊng ikisi unura owro ngɛ kǝkǝwe?’ ");
INSERT INTO khj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ɛkǝri arʊ sini akʊ shaa ɔvro ngɛ kasani, ‘Ete, sherewo ɛnyɛɛ eying inu tai ibʊng ekǝkǝri asa ibʊng inaa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ubo sumo ɛnyɛɛ ʊkeba, nɛgbɛn! Ubono sumowo ikpara dang aka kpawo ɛfɛn.’ ” ");
INSERT INTO khj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Opyo awri uwuro Ayaudiya sini Iyesu ku mɛr bi owro utuno Ayaudiya. ");
INSERT INTO khj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Opyo erere nuo bi upurhan sini ering ʊshari sie ogoru ɛnyɛɛ atarhi ni ochupari. Ogomo ngɛ sini ana bra ushine anaa itituku. ");
INSERT INTO khj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Akywa sini Iyesu rie, aka yirha ngɛ keba ka sani ngɛ ni, “Erere, eshirenw bai udumonw.” ");
INSERT INTO khj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aka sai ivʊ ba yaa, ba kywakywa dang aka naa itituku kɔ dɔɔ Ʊnʊng ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Orokru sini ɛngɛɛ ni arite owro utuno ayahudiya ka kung anang ngɛ nagang kii Iyesu mi ikrʊ ʊnʊng uwuro Ayaudiya. Aka sani orokru ni, “Awri eten nuwo amu utuna! Inyi ba ebe pen ikrʊ ba awri dang, Inyi ba kya ba awri uwuro Ayahudiya.” ");
INSERT INTO khj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ete ka yoro ngɛ ni, “Inyi arʊ pre eteting! Kukumnyi sene sherenyi inaanyi kǝni ijaki owro upyerhemɔ awri uwuro Ayaudiya aya mayo omung? ");
INSERT INTO khj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Erere wen ni ɔnɔ Ibraim ngɛ, arʊ sini ishari lorhi ngɛ ɛnyɛɛ atarhi ni ochupari me, isayo idima amaa ikrʊ awri uwuro Ayaudiya?” ");
INSERT INTO khj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ni sini Iyesu peri kǝna, kukum arʊ sini ana waa mo ngɛ ka kung uwaa, uparha ɛshɛ orokru kasu mɛ ni ʊma ʊkʊkɔ sini akusa. ");
INSERT INTO khj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iyesu ko gyurho asani, “Igumo Ʊnʊng ni shoo ne nyee wo? Ini marha yo ni ikimoyo? ");
INSERT INTO khj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ini kǝni ikiri imusta ni, sini orokru kpari aya pura bidɔɔ ɔvroo. Ikǝ mɛrɛ ko shoo ʊshi ɔnɔnʊng ayaya kata ibʊru ba anang ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iyesu kojo sani, “Ini marha igumo Ʊnʊng ni ikying? ");
INSERT INTO khj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ini kǝni ɛdɛrɛ ofuru sini erere kpari kǝyɛnɛ ubre isɔng umara utarʊ ʊka kpin ɛdɛrɛ ofuru kukum ka fuwa.” ");
INSERT INTO khj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Akywa sini Iyesu kusu kyeng kyaa Urushelima, aka su mɛr orokru bidɔɔ apya kǝni ipyang. ");
INSERT INTO khj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Opyo arʊ ko gyurho ɛngɛɛ ni, “Ete, orokru sini anu pen ʊgya asamɔ ɔgrɔɔ?” Iyesu ko yoromo ka sani, ");
INSERT INTO khj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Inyi sɔmɔ ising ngɛ araa bi ɔgrɔ ushwirh, kii orokru napany nʊ waa uraa bidɔɔ anasu bramɔ. ");
INSERT INTO khj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Akywa sini arʊ una beshine afraa ɔgrɔ, inyi bakyu su titing besing asu kuna ɛkǝri ɔgrɔ asu sani, ‘Ete, furɔ arʊ ɔgrɔ.’ “Yip anu yorony asani, ‘Inɛkpɛrhim monyi ko owro sini inyi kuni ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Akywa dang inyi nʊ sani, ‘Aru ra asa kǝni unwoo, umer arʊ bidɔɔ itira arʊ.’ ");
INSERT INTO khj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Yip anu jo sane nyi ni, ‘Inɛkpɛrhim inyi ko owro sini inyi kuni ngɛ. Inyi shinɛ ben, inyi arʊ eteting!’ ");
INSERT INTO khj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Utei nuwo kǝni uraa ere, ba akywa sini inyi borong Ibraim ngɛ kǝni Ishaku kadarha Iyakubu kǝni opyo arʊ pɛrɛ onuo Ʊnʊng. Bidɔɔ Igumo Ʊnʊng, yip anu inyi kunany besing. ");
INSERT INTO khj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Orokru nʊ kuno bei ipara kǝni isha aya, kǝni isha ure, kǝni isha ata aba akiki urumura ipara bidɔɔ Igumo Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Uwe arʊ sini ani bi utumo anu bamo ite, arʊ sini anu bi ite anu juro kyamo utumo.” ");
INSERT INTO khj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Akywa dang opyo Afarisiya abi uwroo Iyesu ka sani ɛngɛɛ ni, “Shere upen ngɛ kii Ihiridus kuwaa ʊpɛrɛnw.” ");
INSERT INTO khj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iyesu ka sa nɔmɔni,“Inyi kya sani ava orumo dang ni, ‘Iku kurho ʊshari ama orokru ikrʊ echiye kǝni ikywa. Ba awri uman atarʊ inu kweri utinam.’ ");
INSERT INTO khj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bikǝn itɔɔyo ishoo mi ngɛ ni utinam echiye kǝni ikywa adarha edere, kii isayo igyang arʊ pɛrɛ onuo Ʊnʊng kpoo bi orowro sai bi Urushelima! ");
INSERT INTO khj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Urushelima, Urushelima, inyi arʊ pyerhɛ arʊ pɛrɛ onuo Ʊnʊng ata arʊ sini atumi mo eberiny ni atari, ni imerhime iwaa utuno ɔnɔny eberi eying, kǝni sini akwa onung so tuno ɔnɔ onung aframo ni ushɔng ni, yip inyi no yorony emye. ");
INSERT INTO khj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nɛchiyɛn una utunony to ɔvro. Iku tanany ʊbrʊbrʊ ni inyi no ojorony emye sai inyi ba sani, ‘Ʊnʊng ta arʊ sini abi bidɔɔ ʊtʊwa Ete onuo adadʊma.’” ");
INSERT INTO khj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ʊpyu ʊnʊng uwuro Ayaudiya sini Iyesu kii ʊra ʊmʊra bi idɔɔ ʊna opyo ɔrɔmɔmɔrʊ Afarisiya, ikuyang kasu kong Iyesu Ikra. ");
INSERT INTO khj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Opyo arʊ sini ivʊ adarhi Ifraa ngɛ murhi kaba bi ite Iyesu. ");
INSERT INTO khj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iyesu ko gyurho ɛkǝri Afarisiya kǝni avʊwa ogro Imusa, “Ogro mi apara ni ama ikrʊ awri uwuro Ayaudiya?” ");
INSERT INTO khj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yip aka shywimo ngɛ na kprukpring, ikpara dang Iyesu ka pyaa amaa ikrʊ kasani ɛngɛɛ ni akyaa. ");
INSERT INTO khj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kǝ kwere Iyesu kǝ gyurho ɛkǝri orokru asani, “Araruny boshoo ni ɔnɔ ngɛ ko inaa imu sini ikpii bi idɔɔ igara ʊnʊng uwuro Ayaudiya inyi nasu worony ngɛ ba kywakywa dang?” ");
INSERT INTO khj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Akana bramo uyoro ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nisini Iyesu rii ekyeng sini abarhimo, ikuyang kuworo owro ʊkiki ɔrɔmɔmɔrʊ. Aka tana mo ushosho wen: ");
INSERT INTO khj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Akywa sini araru ba barhanw ʊra ʊmʊra ipara ubaraa bekya ya kiki bi owro ɔrɔmɔmɔrʊ, inu she ushoo asani abarhi opyo arʊ sini eprinw ni imimɔru, ");
INSERT INTO khj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ɛkǝri arʊ sini abarhiny anu ba asani ɔnwɔ ni, ‘Ʊshinɛ ama orokru wen owro ʊkiki.’ Ikpara dang, ʊnʊ kʊng ʊwaa aya kiki bi utumo. ");
INSERT INTO khj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kǝnawo aba barhanw, kya ya kiki bi utumo, kii arʊ sini abarhiny ba ba anu sani ɔnwɔ ni, ‘Orokyoro, shinɛ ba bi owro agyagyang.’Kina nʊ manw imʊmɔrʊ bi ite ʊparha ɛshɛ ekyeng sini inyi kiki kǝni ɔmɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kii kukum arʊ sini aba kpara ʊkaa ayaya anu roo ne kwerh, arʊ sini aba kpara ʊkaa ne kwerh anu kpara ngɛ ayaya.” ");
INSERT INTO khj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iyesu ka sani arʊ sini a barhi ngɛ ni, “Uba waa ubarha orokru ʊra ʊmʊra awri ko ʊmʊra ʊrɛ bekya barha orokyoronw, ko arupyanw ko ɔfɔrɔnw, ko onogronw, ko arʊ ʊfɛ iyoyow nu nwɔ. Uba sa kǝna, anu shu barhanw ʊkamɔ, akpuranw. ");
INSERT INTO khj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Uba waa ubarha orokru ʊra ʊmʊra, ubarha ara ayarha, ogoru, arʊ sini anabramo ukyeng kǝni ofow, ");
INSERT INTO khj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","inyi nupen onuo adadʊma. Kii edei orokru men anasubramo ʊkpʊranw. Ʊnʊng nʊ kpʊranw ʊnʊng ʊshinɛ arʊ shoo nashisha eyesing.” ");
INSERT INTO khj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ni sini ereying bi idɔɔ arʊ sini akʊ ra ʊmʊra kǝni ɛngɛɛ kʊng kǝna, akasani Iyesu ni, “Ʊnʊng ta arʊ sini anu ra ʊmʊra ipara bi idɔɔ igumo Ʊnʊng onuo adadʊma.” ");
INSERT INTO khj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iyesu ka sani ɛngɛɛ ni, “Opyo orokru ku tuno ʊʊma ʊsa ipara irirɛ akywa dang akabarha orokru napany. ");
INSERT INTO khj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Akywa sini ikpara ipara fwa aka tuma agara ngɛ akya tana arʊ sini abarhi mo ni, ‘Inyi ba kii ekywere ukɛne ʊmʊra.’ ");
INSERT INTO khj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ekyeng sini abarhi mo kukummo eye ying ka su tana ngɛ imisini isi imo nasu bamo ba. Ari itite ka sani, ‘Ingɛɛ rɛi owro, itɔɔyo ingɛɛ ye pyerhe yo orong. Iku sɔrhɔnw kparam afraa ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Opyo arʊ kasani, ‘Irɛi inaa ʊtina atarhi iwa kyam ʊmarhayɔ wo we. Iku sɔrhɔnw kparam afraa ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Kǝnawo opyo arʊ kaa, ka sani, ‘Ikpari ubara wɔ we kaimen inabram uba ba.’ ");
INSERT INTO khj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ekǝri agara ko juro baa aba atana Ete ʊnaa sini imɔsi. Ete ʊna ka ta anang, kasani agara ngɛ ni, ‘Kya na gbrugbram ekyeng bi ʊtʊtʊra kǝni ʊʊsʊsɔ apya, ayirha ara ayarha, ogoru kǝni ofow adarha arʊ sini ana bramo ukyeng.’ ");
INSERT INTO khj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Agara ka sani, ‘Ete, imisini ʊtani ni arʊ sa arʊ sayo, yip owro shushoo.’ ");
INSERT INTO khj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ete ʊna ka sani agara ngɛ ni, ‘Kuno akya bidɔɔ itira kǝni idɔɔ apya asa orokru ni aba, aki ʊnam tirɛ. ");
INSERT INTO khj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Itanany, ko ereying sini a barhi ngɛ anasu rɛnɛ ngɛ ʊmʊra iparam.’ ” ");
INSERT INTO khj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ushi orokru napany akʊ kyeng kǝni Iyesu, ekǝ tere ka sani ɔmɔni: ");
INSERT INTO khj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Arʊ sini eye ba eberim kana tira ngɛ ɛkpɛri ngɛ, kǝni akwaa, kǝni ɔnɔɔ, kǝni arupyaa, kǝni ɔfɔrɔ ngɛ, adarha ikuru ʊkaa ngɛ ese maa ushoo ɔnɔ ʊmɛr mi ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kukum arʊ sini ana kparange agara ngɛ okro mi ngɛ ese maa ushoo ɔnɔ ʊmɛr mi. ");
INSERT INTO khj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Asani araru bidɔɔnyi waa vura ʊna ayaya. Ana su kikie epyerhe orong ikimoyo ɛkǝri ʊna nushu ra, kii anʊ ni akai ʊfɛ sini ʊnʊ maa ʊvʊrawɔɔ? ");
INSERT INTO khj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kii aba nuwa atari ikpa ʊvʊra akana brayɔ ʊkywɛrɛwɔ kukum arʊ sini oborowo anʊ sinanw. ");
INSERT INTO khj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Anʊ sani, ‘Orokru wen ti ikpa ʊvʊra akana brayɔ ʊkywɛrɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Adarha ngɛ akina ogumo ngɛ nʊ waa ukyaa ʊraa ni opyo ogumo. Akana kikie epyerhe kii ɛngɛɛ nʊ bra ʊsa ʊraa ni arʊ sini ani orokru ʊsɔng isipari kǝni ɛngɛɛ ari ʊsɔng atarhi? ");
INSERT INTO khj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Obo orong ingɛɛ nasu braa, anu tuma atina aya darha awan ogumo akywa sini eshishi ki ikǝkarha ogyurho ngɛ imusa ʊyari ikywi. ");
INSERT INTO khj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kǝnawo, kukum arʊ sini abana woro ngɛ ikywie ngɛ ni imisini aniyoo ese maa ɔnɔ ʊmɛr mi ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ʊnuɔ nʊ ʊdʊma, yip ʊpʊpʊwa ngɛ bɛ kywɛrɛwo anʊ sa nenyee ukojo sa napʊpʊwa? ");
INSERT INTO khj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ʊsamɔ ni ʊrʊ ʊtina ngɛ bi ibʊng ko asa ʊʊma ʊfɔnɔ; anʊ kʊna anira ngɛ. “Arʊ sini obo shoo ni atʊng ʊkʊng ngɛ, akʊng.” ");
INSERT INTO khj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ʊpyu ʊnʊng arʊ yirha ogon kǝni arʊya napany kaba tuno ekǝkǝri Iyesu ngɛ awa kuwɔ. ");
INSERT INTO khj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yip Afarisiya kǝni avʊwa ʊmɛr ogro Imusa kasu tana ʊring atata asani, “Orokru wen ku yirha arʊya asu ra ʊmʊra kǝni omoo.” ");
INSERT INTO khj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ikpara dang Iyesu ka tana mo ushosho wen asani: ");
INSERT INTO khj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Asani araruny ni Atam ʊkʊma ngɛ eying bi idɔɔmo ko vroyo. Anasu shere ngɛ ʊparha ɛshɛ isi echetarhi ni echetarhi bo rumo akyaa upyerhe Atam sini ovruyo kekya akywa sini anʊ penyo? ");
INSERT INTO khj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aba penyo, anʊ saayo baya ʊvʊ asu mɛ ");
INSERT INTO khj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","waa sini aba ba ʊduna, anu tuno orokyoro ngɛ kǝni arʊ iyoyow ne ngɛ katanamo ni, ‘Inyi shem ngɛ ume; kii ipen Atam mi sini ovruyo.’ ");
INSERT INTO khj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iku tanany ushooyo wurha anu pri nʊ ʊmɛ kya ayaya arʊya eying beshere ʊyaa ngɛ ni ari ise echetarhi ni echetarhi arʊ sini akpari asani imo nashisha, ana waamɔ shere ʊya ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ko asani erere ni ikiri ʊfɛ atarhi ngɛ uying ko vrowo ngɛ. Anasu taa uyen, ɛyɛrhɛ ɛkǝri ʊna epyerhe noshong kekya akywa sini anu rowo? ");
INSERT INTO khj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akywa sini obo rowo, anu yirha orokyoroo kǝni ari iyoyow ne ngɛ kasa ni ɔmɔ ni, ‘Inyi shem ngɛ ume; Kii irong ikiri ʊfɛm sini ivriwo.’ ");
INSERT INTO khj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iku tanany, ushooyo wurha, ima ofofuru yoo eberi atina Ʊnʊng kya ayaya baya arʊya eying sini eshere ʊya ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iyesu ko suno ngɛ ni ʊtanamɔ asani, “Opyo orokru sini ani ɔnɔ apari ngɛ nuwo. ");
INSERT INTO khj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Araji kasani ekperi ngɛ ni, ‘Ɛkpɛri, mam imisini ini imye bi idɔɔ ʊmanw.’ Kǝnawo aka kaa mo ʊmaa. ");
INSERT INTO khj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Bidɔɔ anawri naji, arajaji ko tuno ʊʊma kukum, eshere ʊna ngɛ akyaa opyo apya ki ikǝkarha bi ʊpʊrha wɔ asarhi ʊmaa ngɛ no kukum bi ʊkiki sini ʊsawɔ ʊdʊma. ");
INSERT INTO khj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Sini ekyweri ʊsarha ʊmaa ngɛ kukum, ihywʊng ka kpaa nagang be ɛkǝri ibʊng sini ɔnuo kukum. Ikpara dang ihywung ka raa nagang bi sini asaa ni imʊra ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ʊwɔwɔ aka kya aya waa ʊtina owro opyo ɔnɔ apya, ɛkǝri ɔnɔ apya ka tʊma ngɛ kya ɔvro aya su upiri ngɛ ugrii. ");
INSERT INTO khj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Akawa asani ingɛɛ na ara ʊmʊra ugrii oshuro, ekɛne pen ngɛ arʊ maa iririma. ");
INSERT INTO khj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nisini ojuri baa bidɔɔ ʊkaa, aka sani, ‘Agara arʊ ʊsa ʊtina ɛkpɛrim gbrii ni ʊmʊra ʊra aparha ɛshɛ, imye we bi upen ihywung we pɛrɛm! ");
INSERT INTO khj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ini shinɛ kya eberi ɛkpɛrim asani ngɛ ni: Ɛkpɛri, Iya Ʊnʊng ngɛ ara yaya akyu ʊyanw. ");
INSERT INTO khj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nɛchiyɛn ise mam ayirham ni ɔnɔnw; kparam kǝni ere ying bidɔɔ agara ʊtinanw ni.’ ");
INSERT INTO khj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ikpara dang ekǝ shinɛ ko juro kya owro ɛkpɛri ngɛ. “Yip sini eshi kikǝkarha ekperie ko roo akung okwo ngɛ; oko gyo atara aya kǝkǝn ngɛ asu upyoo igɔn. ");
INSERT INTO khj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ɛkǝri ɔnɔɔ kasani ɛngɛɛ ni, ‘Ɛkpɛri, Iya Ʊnʊng ngɛ ara ayaya akyu ʊyanw. Nɛchiyɛn ise mam ujo yirham ni ɔnɔnw.’ ");
INSERT INTO khj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Yip ɛkpɛri ngɛ ka sani agara ngɛ ni, ‘Inyi sa nagbrugbram! Okom igbɛ irirɛ ba igyigyang ɔsɔmɔ ngɛ. Inyi sɔmɔ ngɛ imaa ba ani ivʊ ɔsɔmɔ ngɛ ataka bi ifraa. ");
INSERT INTO khj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Inyi yokong ɔnɔ inaa sini amumurhi ba arʊ waa. Aki arʊ sa ipara ara ʊʊma. ");
INSERT INTO khj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kii ɔnɔm wen kpoo bakywaa nɛchiyɛn ujo su fer; ovrie bakywa nɛchiyɛn epen ngɛ.’ Kǝnawo oko sunomo ngɛ ni ipara. ");
INSERT INTO khj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nisini akʊ sirha kǝna ɔnɔ ɔkɔkɔng ngɛ ni kya orumo. Akywa sini oto iyoyow ni ʊna, aka kung ʊkra ʊʊma kǝni aya. ");
INSERT INTO khj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ʊwɔwɔ aka yirha opyo agara ogyurho ngɛ asani, ‘Ikimɔyɔ iku kyeng ben?’ ");
INSERT INTO khj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ɛkǝri agara ka sani ɛngɛɛ ni, ‘Arupyanw ngɛ ojuro ba ʊna, ekperinw kawa ɔnɔ inaa erere kii ɔsɔɔ akrʊ.’ ");
INSERT INTO khj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ɔrɔ ɔkɔkɔng ka kung anang ngɛ nagang atira ngɛ ʊraa ʊna. Ɛkpɛri ngɛ ko kuno ba asu sɔrhɔ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yip oko yoro ɛkpɛri ngɛ a sani,‘Rong! Kukum ɛnyɛɛ men iku sanw ʊtina ko ni ying ise mʊmarham ʊtɛɛ ogronw. Ikimoyo ʊmim? Ko ni iying use marhanw ʊmam ananama aki iwa ara asa ipara kǝni orokyorom. ");
INSERT INTO khj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ʊwɔɔ ni sini ɔnɔnw wen, arʊ sini asarhanw ʊʊma ngɛ bi owro erere ukǝkǝe, ɔsɔi, ʊkawaa ɔnɔ inaa ɛrɛrɛ!’ ");
INSERT INTO khj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“ ‘Ɔnɔm’, Ekperi ngɛ ka sani, ‘ko ikini ikpara ʊni kǝni ɛmyɛɛ, kukum imisini iniyɔɔ inwɔyo. ");
INSERT INTO khj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yip ini idima oshoo igyang arʊ si ipara asu mɛ, kii arupyanw kpoo bakywaa, nɛchiyɛn ani akrʊ; ovrie, yip nɛchiyɛn epen ngɛ.’ ” ");
INSERT INTO khj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iyesu ka tana ɔnɔ ʊmɛr ngɛ ushosho wen:“Opyo arʊ ʊfɛ nuwo arʊ sini ani arite atina ngɛ sini aku roo ʊʊma ngɛ. Yip akaba tana ngɛ asani ɛkǝri agara ku sarha ngɛ ʊʊma ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kǝnawo aka yirha ngɛ ogyurho ngɛ, ‘Ikimoyo ye sini iku kʊng bi ikywinw? Tanam kukum sini uku kyeng ni ʊtʊnanw, kii ʊna su shinw arite ɔnɔ ʊtina nɛchiyɛn.’ ");
INSERT INTO khj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ɛkǝri arite atina kasa ni ʊkaa ni, ‘Ikimoyo ini sa nɛchiyɛn? Aritem waa karhami ukyeng ni ʊtʊna ngɛ imye isam ni ikrʊʊ nagang imuwro, ojo kʊng ʊwa ʊsɔrhɔ. ");
INSERT INTO khj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ikpɛrhi imasini inu saa sini, akywa ukyeng ni ʊtʊnam bɛkywɛrɛyɔ, orokru nʊ yirham bidɔɔ ipyang mɔ.’ ");
INSERT INTO khj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kǝnawo aka yirha kukum arʊ sini okong arʊ ʊʊna ʊta eyeyiny. Ko gyurho aritee, ‘Nenyee wɔ ukong aritem?’ ");
INSERT INTO khj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Aka sani, ‘Odum ʊsɔng ise echetarhi ʊmi ɛnyɛ.’ “Ekǝri arite ka sani ngɛ ni, ‘Yirha ʊyaa ʊsha ʊtanw we, kiki kaimen ɔwɔrɔ ni ʊsɔng isi inarhi ni ɔtɔng.’ ");
INSERT INTO khj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ikpara dang oko gyurho arʊ mang pari, ‘Ʊnwɔ kanw nenyee wo ʊta sini ukong?’ “ ‘Oko yoro asani, abuu ʊkʊma uying ʊmi ikiri ogro.’ “Ekǝri arite kasani ɛngɛɛ ni, ‘Yirha ʊyaa ʊsha ʊtanw we terewo asani ʊsɔng isi ochupari.’ ");
INSERT INTO khj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ekǝri arʊ ʊfɛ ko dɔɔ ɛkǝri arite atina ʊsang ʊbrʊbrʊ kii eyen ɛsɛr ngɛ. Kii arʊ eteting men epri ni ɛsɛr bi ʊkikimɔ kǝni opyomo ni arʊ uyen ");
INSERT INTO khj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Iku tanany, inyi sa ʊtʊna ni ʊkaa adumanyi ʊmi eyesing epen ʊkany orokyoro, kii akywa sini ʊkaa adumany ʊmi eteting ba kyu kywɛrɛ wɔ, anu yirhany bi ʊna ʊshishaa bayaya. ");
INSERT INTO khj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Arʊ uyen ʊbrʊbrʊ bi ani ima ajaji anujo uyen ʊbrʊbrʊ bi ima irirɛ, arʊ sang ʊbrʊbrʊ ngɛ bi ima ijiji kǝnawo arʊ sang ʊbrʊbrʊ ngɛ bi ima irirɛ. ");
INSERT INTO khj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kǝnawo inyi ba sany ni uyen ʊbrʊbrʊ ngɛ bi kyeng ni ʊkaa adima eyesing nyi, iyaa nʊ yoro ʊmany ʊkaa adima ʊbrʊbrʊ? ");
INSERT INTO khj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kǝnawo inyi ba sany ni sa ʊbrʊbrʊ ni ʊʊma orokru, iyaa nʊ many imisini ini nyi? ");
INSERT INTO khj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Baa agara sini anʊ sa ʊtʊna arite apari. Kii anu atira ngɛ ere ying awaa ere ying, ko oyoro ni ere ying abyerhe ere ying. Inyi se many ukroo Ʊnʊng ngɛ awaa ʊfɛ ba kywa eying.” ");
INSERT INTO khj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ekǝri Afarisiya arʊ ʊwaa ʊfɛ, ka kung kukum ʊring men kasu sina Iyesu ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iyesu ka sani moni,“Inyi mɔ inyi ni arʊ sini ese waa uyen orokru ni inyi na ashisha, yip Ʊnʊng kpɛrhi ikywiny ngɛ. Imisini orokru wɛiyɔ nagang iyɔyɔɔ Ʊnʊng na waa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ɛkǝri ogro Imusa kǝni imisini arʊ pɛrɛ onuo Ʊnʊng wɔri yoo orokru ku sa ʊtina ngɛ kyeba ba akywa sini Iyohana bii. Wroo bakywa dang, aku tana iring ididima imi Igumo Ʊnʊng, kukum orokru kasu sɔmɔ ikywi ngɛ kekya ʊraayɔ. ");
INSERT INTO khj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Inu sayo iraa ngɛ asani eyesing kǝni ayaya ovroyo ni ani irhing ajaji bi idɔɔ ogro Ʊnʊng nʊ taa ikruyo. ");
INSERT INTO khj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Arʊ sini aba shirha eree olorho ubara ɛshɛshɛ erere asa ʊya ʊya ʊyari ni ere ararʊ. Kǝnawo orokru sini olorhi ubara erere sini ɛrimɛ ngɛ shirhi ngɛ asa ʊya ʊya ʊyari ni ere ararʊ. ");
INSERT INTO khj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Opyo arʊ ʊfɛ nuwo arʊ ʊsɔmɔ ʊʊma ʊfɛ ususeng aki bidɔɔ ʊkʊng ididima kukina ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bo onuo ʊnaa opyo arʊ sɔrhɔ nuo sini ayirhi ʊtʊwa ngɛ ni Ilazarus kukum inama ngɛ anuru yo ");
INSERT INTO khj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","asa waa asani ɛngɛɛ pen ʊmʊra ɛkǝri arʊ ʊfɛ sini uku kyurha mo bi ibʊng ara.Ko ava kamo ber ʊrɛnɛ anʊrʊ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Akywa ka ba sini ɛkǝri arʊ ʊsɔrhɔ ko kpoo. Atina Ʊnʊng ka ba kpara ngɛ okyo ba ikwo Ibraim kya ayaya. Ekǝri arʊ ʊfɛ kaa ko kpoo ekǝ mine ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ipaa ka kyayo owro arʊ ukpo akasʊ kʊng igara. Sini ani bi idɔɔ igara ekǝ pyerhe ayaya ko rong Ibraim ngɛ kyaa ki ikǝkarha, Kǝni Ilazarus ngɛ bi ikwo. ");
INSERT INTO khj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ekǝri arʊ ʊfɛ ka yirha ngɛ asani, ‘Ekperi Ibraim, kʊng okwom atuma Ilazarus ngɛ aki oturo ikywi ani ivʊ bi idɔɔ omung otomom ɛrimɛ ngɛ, kii ini bi idɔɔ igara bi ʊra wen.’ ");
INSERT INTO khj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ibraim ko yoro ngɛ asani, ‘Ɔnɔm, dirha akywa sini ʊni akrʊ beyesing ʊyirha ʊʊma ududuma Ilazarus ka yirha ʊʊma ubibi, yip nɛchiyɛn epen ʊyari ikywi ngɛ ben ʊnwɔ usho bidɔɔ igara. ");
INSERT INTO khj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ekywere kukum kǝn, ukwoo ʊrʊrɛ nuwo abara ting arʊ, aki arʊ sini awa kya owrony ba eberi arʊ ana bramo kǝnawo araruny na su braa ubro ba eberiny kyeba eberi arʊ.’ ");
INSERT INTO khj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ikpara dang ɛkǝri arʊ ʊfɛ ko yoro asani,‘Iku sɔrhɔnw, ɛkpɛri Ibraim, tuma Ilazarus ngɛ kya ki ʊna ekperim, ");
INSERT INTO khj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kii ini arʊ pya ngɛ otong. Tana ngɛ akya aya wɔɔ mɔ atung, kii karha akyaba bi owro igara yen kamo.’ ");
INSERT INTO khj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ibraim ko yoro ngɛ ni, ‘Imusa kǝni arʊ pɛrɛ onuo Ʊnʊng nuwo kǝni omoo. Akun imi sini aku tanamo.’ ");
INSERT INTO khj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“ ‘Aka sani, O-o, ɛkpɛri Ibraim, yip araru sini okpue be shinɛ akya eberi mo anu shere ʊya ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Yip Ibraim ka sani ngɛ ni, ‘Aba na kʊmo Imusa ngɛ kǝni arʊ tana onuo Ʊnʊng, ko araru sini okpue be shinɛ akyaa aya tanamo anasu yoromo ngɛ.’ ” ");
INSERT INTO khj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iyesu ka sani ɔnɔ ʊmɛr ngɛ ni: “Uma sini unusa orokru uya kyeba, yip okwo ni arʊ sini asimo uba. ");
INSERT INTO khj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Inu pri olorho ngɛ utari ukɔ bi ʊmrɔɔ ɛfɛn bidɔɔ irɔng irirɛ nisini anu sa ere ying bidɔɔ ɔnɔ ajajirhi men akyi aya. ");
INSERT INTO khj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Inyi sa noshong ni ʊkany. “Arupyanw ko oforonw ba sanw uya, uwoo ngɛ atung, ebe shere ʊya, upuna ngɛ ʊyaa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ko abada sani asanw uya asi iten sara ba wri. Oko juro ba obo ɔsɔrhɔnw asi iten sara asani ‘Ɛngɛɛ shere ʊya,’ itɔɔyo upuna ngɛ uyaa ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɛkǝri ɔnɔ ʊmɛr Iyesu ka sani Ete, “Jo saa arʊ ʊma ʊbrʊbrʊ arʊ ngɛ!” ");
INSERT INTO khj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ete ko yoromo asani, “Inyi boshoo ni ʊma ʊbrʊbrʊ ngɛ naji kǝni ikiri imusta ni (ikiri imusta ini animaa kǝni ikiri ikpong ni), inyi nusani okru ushi ukumo wen ni, ‘Yere ʊkanw ben aya pura ʊkanw bidɔɔ irɔng irirɛ,’ ʊnu kuny asa imisini inyi sini ʊsa. ");
INSERT INTO khj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Asani ararʊny ni agara ngɛ sini akuwroo ko akushaa atam. Akywa sini obo sɔɔ anu shusani agara ngɛ ni, ‘Ba kaimen ba kiki ara umura’? ");
INSERT INTO khj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Anasu tana ngɛ kǝna, anu sani, ‘Sɔmɔ uma utina, ekyenem umura aki ira asa; ikpara sini ibɛ kywɛrɛ unwo kanw ʊka ra asa.’ ");
INSERT INTO khj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Anu sa ɛkǝri agara ngɛ ija kii asi imisini atani ngɛ ni asaa? ");
INSERT INTO khj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kǝnawo kany. Ikpara sini inyi basa kukum imisini atany inyi sa, inyi nʊ sani, ‘Aru ni agara mo; itɔɔyɔ arʊ sa utina arʊ.’ ” ");
INSERT INTO khj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nisini Iyesu ni bi ʊtira ukyaa Urushelima, aka fwa amarha ibʊng Igalili kǝni Isamariya. ");
INSERT INTO khj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nisini akʊ raa opyo apyang, opyo orokru atarhi sini oku udumo ʊkɔng ka darha ngɛ. Aka ting bi ikǝkarha ");
INSERT INTO khj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ka yirha ngɛ ayaya, “Iyesu, Arite, kʊng okwo arʊ!” ");
INSERT INTO khj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Akywa sini erimo, aka sani, “Inyi kya yen ʊkany eberi ogoku ubyen Ʊnʊng.” Nisini akʊ kyeng kyamo, ekǝ pen ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nisini ere ying bidɔɔ mo, rii ingɛɛ pen ikrʊ, oko juro asu dɔɔ Ʊnʊng ngɛ ni ihywi ayaya. ");
INSERT INTO khj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Aka kpaa okpukpuro ni orung bi ite Iyesu asaa ija. Orokru wen ni ari Isamariya ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iyesu ko gyurho, “Sa ara atarhi mo epen ikrʊ kukum? Eki uparha ɛshɛ ere ichetarhi? ");
INSERT INTO khj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ba arʊ sini ojuri ba aba dɔɔ Ʊnʊng ngɛ sai ekyeng wen?” ");
INSERT INTO khj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ikpara dang aka sani ngɛ ni, “Shinɛ akyanw; ʊma ʊbrʊbrʊnw manw ikrʊ.” ");
INSERT INTO khj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Upyo unung Afarisiya gyurhi Iyesu ngɛ ikini ikpara yo Igumo Ʊnʊng kyeba, Iyesu ko yoromo asani, “Ukyeba Igumo Ʊnʊng isayo irima sini orokru nʊ rong ekperhi asani iba ba, ");
INSERT INTO khj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ko orokru sani, ‘Inye ben,’ ko ‘Inya ban,’ kii Igumo Ʊnʊng ni bidɔɔ nyi.” ");
INSERT INTO khj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ikpara dang Iyesu kasa ni ɔnɔ ʊmɛr ngɛ ni,“Ekǝri akywa yeba sini inyi nʊ waa urom, Ɔnɔ Orokru bi igumo, ko awri eying, yip inyi na su rong yo. ");
INSERT INTO khj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Orokru nʊ tanany ni, ‘Awa ban!’ Ko ‘Ewe ben!’ Inyi be kya kuno kyaa aya su ting kroo edei mo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kǝni sini uyen iyɛyɛrhi avra se ta uyen kya ayaya bai iyen isha kekya inyan isha kǝni ɔnɔ orokru nushoo bidɔɔ awrie. ");
INSERT INTO khj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yip bi itee itɔɔyo anu shi igara ededei bavu ipyoo yen ujo tiramo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kǝni ushoo yo bakywa Inuu ni, kǝnawo inu shoo bakywa Ɔnɔ Orokru. ");
INSERT INTO khj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Orokru ku ra, asu sa, asu ulorho ibara kǝni ʊʊma ibarha ke kya ʊnʊng sini Inuu rii ʊgɔrʊ omung ʊrʊrɛ. Ikpara dang ʊgyang ka ba pyerhemo kukum. ");
INSERT INTO khj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Inɛ mɛr kǝni bakywa Ilitu ni. Orokru ku ra, asu sa, akʊ rɛɛ asu gbuna, akʊ pura asu vura. ");
INSERT INTO khj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yip unung sini Ilitu sheri Isɔdɔm ngɛ, Ʊnʊng ka sa ura kǝni itari ura ka kpaa ba ayaya kǝ pyerhemo kukum. ");
INSERT INTO khj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Inu shoo nɛmɛr kǝn ba awri sini Ɔnɔ orokru nʊ kuno. ");
INSERT INTO khj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ba wri dang arʊ sini ani bi ʊsɔrɔ ʊbɔrʊ, oshoo ni umaa bidang, ebe kya shuro asani ingɛɛ weyeremo. Kǝnawo, arʊ shoo kyu orumo bekya juro baa ukpara iririma bi una. ");
INSERT INTO khj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Inyi dirha ni imisini isi ere Ilitu ngɛ! ");
INSERT INTO khj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Aru sini aba waa usha ofo nge, anu taa yo, Yip arʊ sini aba taa ʊfɛr ngɛ anu penwo. ");
INSERT INTO khj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Itaniny ni eting dang ara pari nʊ yuyari bi ipro; anu kpara ereying eshere ereying. ");
INSERT INTO khj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Erere apari nusu kɔ bi ʊtari bi owro eying; anu kpara ereying ekǝ shere ereying.” ");
INSERT INTO khj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ɛrɛrimɛ apari nusu wro bi orumo anu kpara ereying eshere ereying. ");
INSERT INTO khj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ɔnɔ ʊmɛr ngɛ ko gyurho ngɛ, “Ete, bi ubewo anu sa inyen ima ngɛ?” Iyesu ko yoro mo asani, “Owro sini ʊkʊng inama nuwo ʊpʊrha wɔ ulobung se tuno ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iyesu tani ɔnɔ ʊmɛr ngɛ ushosho wen ekǝ eyen mo ni asu sɔrhɔ Ʊnʊng ko kina akywa, ebekya woro ikywimo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Akani: “Bi opyo apya arʊ kyɛrhɛ ʊring nuwo arʊ sini ana kung irung Ʊnʊng ko asani adirhi ni araru. ");
INSERT INTO khj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Erere okro nuwo bi ɛkǝri apya dang, akasʊ kyer eberi ngɛ asu sɔrhɔ ngɛ, ‘Ani eyen ʊbrʊbrʊ bi idɔɔ mo kǝni arʊ sini atie bi ite.’ ");
INSERT INTO khj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Kii bo opyo akywa atiri ngɛ yip ba akurha ngɛ akasa ni ʊkaa ni, ‘Koni sini ina kʊm irung Ʊnʊng, ina dirham ni orokru, ");
INSERT INTO khj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yip erere okro wen ku wurem, inu ri imisini ini sa akyi epen ʊbrʊbrʊ, aki eshere uber uwurem ngɛ!’ ” ");
INSERT INTO khj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ikpara dang Ete kasani, “Inyi kung imisini arʊ kyɛrhɛ ʊring ʊsang ʊbrʊbrʊ ngɛ pɛri. ");
INSERT INTO khj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Akani Ʊnʊng nasu kpura ngɛ arʊɔ sini oworimo ʊbrʊbrʊ, arʊ sini aku tei ngɛ eting kǝni awri? Ʊnʊng nʊ bura akywa owro uyoro ʊsɔrhɔ moo? ");
INSERT INTO khj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iku tanany, Ʊnʊng nʊ kpura nekǝkǝrhe. Yip ikpara sini Ɔnɔ Orokru bo juro, anu darha ʊma ʊbrʊbrʊ ngɛ bi eyesing?” ");
INSERT INTO khj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iyesu ka tanamɔ ushoshoo wen: opyo arʊ sini atirikywi ni ʊkamɔ nimɔ ni nashisha ana kparamɔ ʊparha ɛshɛ orokru bi onuo iririma, ");
INSERT INTO khj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ɛrɛrimɛ apari kii ʊsɔrhɔ Ʊnʊng bi idɔɔ ubyen Ʊnʊng, ereying ni Afarisi awan arʊ ni arʊ yirha ogon. ");
INSERT INTO khj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ɛkǝri Afarisi ka shinɛ asu sɔrhɔ Ʊnʊng bi ikywie ani, ‘Ʊnʊng, Isi ija ni isam kǝni ʊparha ɛshɛ orokru ni, kii isam eyi, isam ere eteting, isam arʊ ʊyari ni erere ararʊ. Isanw ija kii sam kǝni arʊ yirha ogon wan ni. ");
INSERT INTO khj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ise kusoro ni pari bidɔɔ awri etensara, kukum imisini ibe pen ise ma iying bidɔɔ atarhi.’ ");
INSERT INTO khj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Yip arʊ yirha ogon kǝ shinɛ atiting ki ikǝkarha. Akyana bra ushwe ikra oro ayaya, yip akasʊ kra ikou ngɛ ani, ‘Ʊnʊng, kung okwom kii ina arʊya ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Itanany, ɛkǝri arʊ yirha ogon wen ban ni Afarisi ojuri kya ʊduna ni ɛmɛ sini epen ʊyirha be eberi Ʊnʊng. Kii kukum arʊ sini aba kpara ʊkamɔ ni imo ni iririma Ʊnʊng nʊ shuro ni ɔmɔ bi ibʊng, arʊ sini aba kpara ʊkamɔ ni imo samɔ bi onuo iririma Ʊnʊng nʊ shwemo ayaya.” ");
INSERT INTO khj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Orokru kusu kong ɔnɔmɔ ba eberi Iyesu aki apyamɔ atamɔ onuo adaduma. Nisini ɔnɔ ʊmɛr ngɛ rii kǝn, aka tanamɔ ʊraa ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yip Iyesu ka yirha ɛkǝri ɔnɔ ajajirhi ke ba eberi ngɛ asani, “Eshere ɔnɔ ajajirhi aba eberim, ebe kya karhamo ngɛ, kii igumo Ʊnʊng ni imi edeimo yo. ");
INSERT INTO khj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Iku tanany ʊbrʊbrʊwɔɔ, arʊ sini abana yirha ngɛ igumo Ʊnʊng kǝni ɔnɔ ajaji ni anasu raa ngɛ yo ishishaa.” ");
INSERT INTO khj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Opyo ari igumo ko gyurho Iyesu ngɛ, “Avʊwa agyagyang, inu sa ikimɔyɔ epen ofo Ʊshishaa?” ");
INSERT INTO khj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iyesu ko yoro ngɛ, “Ikisi ʊyirhim ni ara agyagyang? Baa ara agyagyang sai Ʊnʊng eyeyie. ");
INSERT INTO khj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ʊkpɛrhi ɛkǝri ogro ngɛ: ‘Bekya yari ni ere ararʊ, ʊnasu pɛrɛnw araru, ʊnasu sanw uyi, bekya tana upre eteting bi ikywi araru, ma ekperinw kǝni akwanw imimoru mo.’” ");
INSERT INTO khj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ekǝri orokru kasani, “Kukum ʊʊma men ikywere ʊsa kǝna wroo sini ini anagyang.” ");
INSERT INTO khj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nisini Iyesu kung kǝn akasani ɛngɛɛ ni, “Ima iying shushoo sini ʊtani ʊsa. Gbuna kukum imisini ʊniyɔɔ ama araayarha ɛkǝri ʊfɛ, ʊnʊ pen imavʊ bayaya. Ikpara dang ʊka ba okro mi ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nisini akʊng kǝn, ikywie ka burayo, kii ani ima avu ngɛ napany. ");
INSERT INTO khj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nisini Iyesu rii ikywie burayɔ akasani, “Ini iraa ngɛ kǝni ikinni arʊ imavʊ raa igumo Ʊnʊng! ");
INSERT INTO khj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kii inu pri asani Irakumi nuworo bi idɔɔ igara anumra nisini ari ima avu nʊ raa igumo Ʊnʊng.” ");
INSERT INTO khj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Arʊ sini akʊng irhing yen oko gyurho asani, “Nɛchiyɛn iyaa nʊ gya?” ");
INSERT INTO khj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iyesu ko yoromo, “Imisini orokru nabraa ʊsa, Ʊnʊng nʊbra ʊsayɔ.” ");
INSERT INTO khj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ibitrus ka sani ngɛ ni, “Arʊ shere kukum imisini arʊ niyo ngɛ ko kro nwoo!” ");
INSERT INTO khj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iyesu kasani ɔmɔni, “Iku tanany ʊbrʊbrʊwɔɔ, baa arʊ sini anʊ shere ʊnaa ngɛ ko ere ko arupyaa ko ɔfɔrɔ ngɛ ko arʊ ubyere ngɛ ko Ɔnɔɔ bekai igumo Ʊnʊng, ");
INSERT INTO khj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","sini anasu yirha ngɛ napany eprimo kǝna bi ipyoo yen epen ofo ʊshishaa bi ipyoo ukye ba.” ");
INSERT INTO khj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iyesu ka kpari ɔnɔ ʊmɛr ngɛ ara tarhi na pari dang kyaa ishiying ka tanamo, “Arʊ ye kyamo Urushelima. Kukum imisini ɔwori baa onuo arʊ pɛrɛ onuo Ʊnʊng bekai Ɔnɔ Orokru nʊ tirɛ. ");
INSERT INTO khj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Anu maa bavu arʊ sini ɛnɛkpɛrhimɔ Ʊnʊng. Anu sina ngɛ, atira ngɛ, ataa ekpe. ");
INSERT INTO khj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Anu kraa ɛpɛrɛ ngɛ. Bawri ʊmang tarʊ anujo shinɛ.” ");
INSERT INTO khj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yip ɔnɔ ʊmɛr ngɛ kyana kperhimo iririma bi idɔɔ ʊmamen. Kii Ʊnʊng swimo ngɛ ni ɛkǝri ikuri iring, kǝnawo ekyene kpɛrhimɔ imisini Iyesu ku pɛrɛ. ");
INSERT INTO khj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nisini Iyesu tekya ʊfwa Ijeriko ofow kiki bo nuwo ʊtira asu sɔrhɔ. ");
INSERT INTO khj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nisini akʊng ushi orokru ku woro, oko gyurho ikimoyo ikusa. ");
INSERT INTO khj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aka tana ngɛ ni, “Iyesu ari Inazaret ngɛ akʊ woro.” ");
INSERT INTO khj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ɛkǝ yɛɛ ihywi ayirha ngɛ, “Iyesu, ɔnɔ Idouda, kʊng okwom!” ");
INSERT INTO khj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Arʊ sini ani bi ite ɛkǝri okyoro ka tana ngɛ ʊraa ngɛ asani ashwi, yip ekǝ yɛɛ ihywi nagang, “Ɔnɔ Idouda, kʊng okwom!” ");
INSERT INTO khj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iyesu ka ting kasani ɔkɔng ɛkǝri orokru ba eberi ngɛ. Nisini abii iyoyow, Iyesu ko gyurho ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ikimoyo ʊwɛi ni isanw?” Oko yoro ngɛ asani, “Ete, iwɛi ujo rong owroo.” ");
INSERT INTO khj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iyesu kasani ngɛ ni, “Nɛchiyɛn rong owro! Ʊma ʊbrʊbrʊnw manw ikrʊ.” ");
INSERT INTO khj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ba kywakywa dang akasʊ rong owro ko kroo Iyesu ngɛ, asu dɔɔ Ʊnʊng ngɛ. Nisini kukum orokru rii, ɔkɔ dɔɔ Ʊnʊng ngɛ ʊkamɔ. ");
INSERT INTO khj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iyesu ka raa kasu wɔrɔ bidɔɔ Ijeriko. ");
INSERT INTO khj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Opyo orokru nuwo ʊtʊwa ngɛ ni Izaka. Ɛngɛɛ ni ogumo arʊ yirha ʊfɛ ogon, oshoo ni ima avu ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aka waa urong kii iyaa ni Iyesu. Ana braa urong Iyesu ngɛ bidɔɔ orokru bekai sini ani ekwekwi. ");
INSERT INTO khj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aka ting kyaa ni ite ka kirha ʊshi uwee, bi onuo ʊtira sini Iyesu ku kyeng ngɛ akuwaa uroo. ");
INSERT INTO khj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Akywa sini Iyesu fuwi ɛkɛri owro. Ɔkɔ gyo ikra oro ayaya ka sani ngɛ ni Izaka shuro ne nekǝkǝrhe kii ini shuro ʊʊnanw ɛchiyɛ. ");
INSERT INTO khj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Izaka ko shuro nekǝkǝrhe ka yirha ngɛ kidɔɔ ʊnaa ni ofofuru. ");
INSERT INTO khj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ni sini orokru kukum erii kǝna akasʊ pɛrɛ ni opyomo ka sani, “Akyaa ushuro bi ʊna arʊya.” ");
INSERT INTO khj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Izaka ka shinɛ atiting ka sani, “Ete, ini ma ara ayarha ʊsari imi sini iniyɔɔ. Arʊ sini ira ne ngɛ ini kpura ngɛ asa inarhi ʊrɛ imi sini iyirhi.” ");
INSERT INTO khj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iyesu ka sani ngɛ ni, “Echiye oforo ba ʊdʊnanw, kii orokru wen kaa ɔnɔ ʊna Ibraim ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kii Imye Ɔnɔ Orokru bii upyerhewo asa oforo, okyo imi sini ivriyo.” ");
INSERT INTO khj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Akʊ kyeng ba iyoyow ni Urushelima, ɛkǝri orokru sini akʊ kuwɔ kasu wɔrɔfo a sani akywa sini imo ba kya Urushelima akywakywa dang igumo Ʊnʊng nʊ tikpa, aka tanamo ushosho. ");
INSERT INTO khj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ikpara dang aka sani ɔmɔni: “Opyo orokru nuwo ari igumo akyi okyoro ki ipyii ibʊng kikǝkarha aya yirha igumo ikpara dang ko juro baa. ");
INSERT INTO khj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Aka yirha agara ngɛ atarhi amamɔ ʊfɛ sini ayirhi ni iminaikiri iyiying asani inyi tere avʊ ngɛ kyekya ujuro bam. ");
INSERT INTO khj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ɛkǝri ara pya na waamɔ ngɛ aka tuma atina okroo ngɛɛ a sani, ‘Arʊ na waamɔ orokru wen oko igumo arʊ.’ ");
INSERT INTO khj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Akywa sini aya yirhi igumo kɔ sɔɔ, aka tuma ʊyirha agara sini amimo ʊfɛ. Ɔkɔ gyurhomo awaw kperhi ikimoyo epen baya ʊfɛ sini amimo. ");
INSERT INTO khj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Arʊ sini ovo ite uba, ka sani, ‘Ete, ikiri ʊfɛ sini ʊmim iteri avʊ ngɛ kǝpen atarhi bayaa.’ ");
INSERT INTO khj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Ete ʊna ka sani ngɛ ni, ‘Agaram agyagyang, ʊsa nɛgbɛn bɛkɛi sini uyen ʊbrʊbrʊ bi ima ijiji imanw igumo apya atarhi.’ ");
INSERT INTO khj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Agara ʊmang pari ngɛ kaba, ka sani, ‘Ete ʊna ʊmim ikiri ʊfɛ ikǝ itere avu ngɛ kǝpen ikiri itɔng bayaa.’ ");
INSERT INTO khj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ete ʊna ka sani ngɛ ni, ‘Imanw igumo apya ɔtɔng.’ ");
INSERT INTO khj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Opyo agara kaba ka sani, ‘Ete ʊna, yirha ikiri ʊfɛnw, ilorhi ba ani ʊtʊgbɛ kɔsɔ. ");
INSERT INTO khj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ikung irung nwu bekai sini ʊsang adʊma. Use kpara ɔwroo sini use kyonw ngɛ, akana ɔwroo sini use puranw.’ ");
INSERT INTO khj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ete ʊna ka sani ngɛ ni, ‘ʊnwɔ agara ebebi, Ini kywanw iring ni imisini ʊpɛri. Uyoni ise kpara imi sini iso kyom, akana imi sini ise puram? ");
INSERT INTO khj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ikisi uno kyonw bi ʊna kyu ʊfɛ, Iba sɔɔ bi ikpara ngɛ iba yirha ʊfɛm kǝni ara yaa ngɛ?’ ");
INSERT INTO khj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ete ʊna ka tana arʊ titing burha a kani, ‘Akarha ikiri ʊfɛ dang ngɛ bavuɔ ama arʊ shoo ni ikiri atarhi ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aka sani ngɛ ni, ‘Ete ʊna, ani Imina atarhi ngɛ!’ ");
INSERT INTO khj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Okɔ yoro ka sani, ‘Iku tana nyi arʊ sini ani ʊʊma ngɛ anujo maa nagang, arʊ sini asaa niyoo anima sini aniyoo anu karha ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Arʊ sini ana waamɔ ɛmyɛ ni igumo, inyi komo ba ben ɛpyɛrhɛmo bi item.’ ” ");
INSERT INTO khj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Akywa sini Iyesu kywɛrɛ ʊpɛrɛ ʊring men aka kpa itemo asu kyeng kirha ngɛ kyaa Urushelima. ");
INSERT INTO khj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Akywa sini afwi iyoyow ni Ibaitafeji kǝni Ibetani bi ikwo ukro sini a yirhi ni Izaitun aka tuma ɔnɔ ʊmɛr ngɛ arʊ apari asani moni, ");
INSERT INTO khj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Inyi kya kidɔɔ apya sini ani ite nyi, inyi ba raa inyi nʊ darha eniri ani ijaki ami sini ba arʊ sini akirha ngɛ. Inyi shire ngɛ okɔba ben. ");
INSERT INTO khj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Arʊ sini obo gyurho inyi, ‘Ikisi inyi ku shire ngɛ?’ Inyi sani ɛngɛɛ ni, ‘Ete ngɛ ɛwɛi.’ ” ");
INSERT INTO khj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Arʊ sini atumimo aka kyaa aya darha nɛmɛr kǝni sini Atanimo ni. ");
INSERT INTO khj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Akywa sini a ku shire ɛkɛri ani Ijaki, ɔkɔrɔ ko gyurhomo, “Ikisi inyi ku shire ɛkɛri ani Ijaki?” ");
INSERT INTO khj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aka sani, “Ete ngɛ ɛwɛi.” ");
INSERT INTO khj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Oko koo ba owro Iyesu, okɔ wuro ʊgbɛ ʊsɔmɔ mo kɔ sɔrɔ ani Ijaki ekǝ she Iyesu ngɛ akirha bayaa. ");
INSERT INTO khj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sini a kpin ʊtʊra orokru kasu ta ʊʊma ʊsɔmɔmɔ bi ʊtira. ");
INSERT INTO khj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Akywa sini afwa bi iyoyow ni Urushelima owro sini ʊtira shuri kyawo ukro Izaitun, ɔnɔ ʊmɛr ngɛ napany ka kpin ʊbrir Ʊnʊng ngɛ ayaya bekai ʊʊma ujijire sini erii. ");
INSERT INTO khj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aka su ta akpa kasu sani, “Ʊnʊng ta onuo adaduma baya ogumo sini abii bidɔɔ ʊtʊwa Ete!” “Ʊyari ikywi kya ayaya, kǝni ʊdɔ kyekya owro Ʊnʊng kya ayaya!” ");
INSERT INTO khj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Opyoo Afarisi sini ani idɔɔ orokru ka sani Iyesu ngɛ ni, “Avʊwa, tana ɔnɔ ʊmɛr nwu ni ashywi!” ");
INSERT INTO khj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Iyesu ko yoromo,“Iku tanany arʊ men ba shywimo ngɛ, atari yen nʊ shoo akpa.” ");
INSERT INTO khj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Akywa sini a fwa iyoyow ni Urushelima ni sini atii ikra ni ɛkɛri apya ekǝ shire ere ");
INSERT INTO khj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ka sani,“Asani inyi kperhi echiye imi sini ini kong ʊyari ikywi ba inoshoo igyang. Uwe ɔswiny yongɛ. ");
INSERT INTO khj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Akywa yeba arʊ sini ana waamɔ nyi anu tany ukro ɛkɛriny asu raa ni enyi bai ku ikina isha. ");
INSERT INTO khj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Anu kurhonyi bi ibʊng, anu perheny kǝni ɔnɔ nyi. Ene sheremo ʊtari uying bayu upyoo. Kii inyi ne kperhiny akywa sini Ʊnʊng bii aba sany oforo.” ");
INSERT INTO khj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iyesu ka raa Ubyen Ʊnʊng kasu yeri arʊ gbuna ʊʊma. ");
INSERT INTO khj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Aka sani mo ni,“Owori bi idɔɔ iring Ʊnʊng a sani ‘ʊnam nʊ shoo owro ʊsɔrhɔ Ʊnʊng yo’; uwe inyi tereyo oto ‘ʊtara eyi.’ ” ");
INSERT INTO khj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Aka su mɛr orokru ku ʊkina Ʊnʊng bi idɔɔ Ubyen Ʊnʊng. Ogu Ubyen Ʊnʊng kǝni avʊwa ʊmɛr ogro Imusa kǝni ɔrɔmɔmɔrʊ mɔ kasu ʊwaa sini imɔ nʊ pɛrɛ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ekywere ekene pen mo ʊrʊ tira sini anu pɛrɛ ngɛ, bekai sini orokru kǝkǝri ngɛ asu kung ididima ʊring sini akʊ mɛr mo. ");
INSERT INTO khj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ʊpyu ʊnʊng, Iyesu ni bi idɔɔ ubyen Ʊnʊng asu mɛr orokru asu tanamo iring ididima, ogu ubyen Ʊnʊng adarha avʊwa ʊmɛr ogro Imusa kǝni ɔrɔkɔng ka ba owroo. ");
INSERT INTO khj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Aka sani ngɛ ni, “Tana arʊ akina edei igumoyo ʊni iyoo imusa ʊring men? Iyaa minw ikrʊ yen?” ");
INSERT INTO khj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Okɔ yoro mo ni, “Imye ma Ini gyurhony kam inyi tanami ");
INSERT INTO khj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ibaptisma Iyohana ikuni baa yaya wɔ, ki baa ɔwroo orokru?” ");
INSERT INTO khj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ekǝ tere asu pya onuo ni ʊkamɔ ka sani, “Arʊ ba sani, ‘Ba ayaya,’ anu sani, ‘Ikisi inyi no yoronyi ni ngɛ?’ ");
INSERT INTO khj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yip arʊ ba yoro asani, ‘Ikuni baa ɔwroo orokru,’ kukum ɛkǝri orokru nʊ ta arʊ ni atari ɛpyerhe. Kii oyori ngɛ asani Iyohana ni arʊ pɛrɛ onuo Ʊnʊng ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Okɔ yoro ngɛ asani “Arʊ ne kperhimo ikuni baa ube wo.” ");
INSERT INTO khj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iyesu ka sa nɔmɔni, “Imyɛ kam ina tanamo nyi, arʊ sini amim ikrʊ ʊsa ʊring men.” ");
INSERT INTO khj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ikpara dang Iyesu ko suno ngɛ ni ʊtana orokru ushosho wen, “Opyo arʊ puri inabi aka ma opyo arʊ ʊta ɛkǝri abya ka kyaa okyoro ki opyo apya kikǝkarha ekǝ dɛrhɛ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sini akywa ʊkana fwa aka tuma agara ngɛ kya owro arʊ sini amimo abya ʊta, akya ayirha ngɛ osumo inabi sini akani.Yip ɛkǝri arʊ sini ayirhi orumo ʊta aka kraa ɛkǝri agara ɛyɛri ngɛ avu akʊrʊ. ");
INSERT INTO khj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ekǝ jo tuma opyoo agara ngɛ, aka kraa amaa ʊwaa, ayeri ngɛ avu akʊrʊ. ");
INSERT INTO khj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aka tuma ʊmang ataru ngɛ aka saa onuru ɛfɛn ngɛ ke esing. ");
INSERT INTO khj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ekpara dang ɔkɔrɔ ɛkǝri abya, ka sani, ‘Ikimo ini sa nɛchiyɛn? Ini tuma ɔnɔm sini ipri ni ʊwaa ngɛ, oboroo anushe maa imimoru ngɛ.’ ");
INSERT INTO khj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Yip akywa sini erie, aka sani opyomo ni. ‘Ekǝri ɔnɔ ɔkɔrɔ ari orumo we, inyi ba arʊ pɛrɛ ngɛ, aki abya shoo amaru.’ ");
INSERT INTO khj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aka kraa ɛfɛn ngɛ bi esing kǝ pɛrɛ ngɛ. “Ikimɔyoɔ nɛchiyɛn ɔkɔrɔ ɛkǝri abya nʊsa ni ɔmɔ? ");
INSERT INTO khj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Eyeba ebe epyerhe ɛkǝri arʊ sini amimo abya ʊta ama opyo arʊ ɛkǝri abya.” Sini orokru kung ʊring men, akani, “Ʊnʊng sa ibe kya shoo kǝna!” ");
INSERT INTO khj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iyesu ko komo ikra ka sani,“Nɛchiyɛn ikimoyo ini imisini ɔwori bi idɔɔ iring Ʊnʊng asani: “ ‘Ʊtari sini arʊ vura tiramɔwɔ ʊwɔwɔɔ uto ʊtari itung’? ");
INSERT INTO khj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Arʊ sini aba kpaa bayu ʊtari wen anʊ vɛrhɛ ngɛ nɔyʊyɔw, arʊ sini ʊba kpaa ba aya ʊnʊ kɔɔ kǝni ubre ni.” ");
INSERT INTO khj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Avʊwa ʊmɛr ogro kǝni ogu ubyen Ʊnʊng, kawaa apara sini anu kpin Iyesu ngɛ ba kywakywaa, kii ekperhi asani atani ushosho wen bi ikywimowo.Yip aka kung irung orokru. ");
INSERT INTO khj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Akasu yara ngɛ asu waa apara sini anu kpin ngɛ ni ʊya aka tuma opyoo orokru aki oyovuno nge kǝni imɔ ni arʊ ʊbrʊbrʊmɔ ni. Akʊ tiri ikwyi imɔ nʊ kpin ngɛ ni iririma sini ɛpɛri, aki imɔ naa ngɛ bavu ari igumo Iroma. ");
INSERT INTO khj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɛkǝri arʊ sini atumimɔ ko gyurho Iyesu ngɛ asani “Avuwa, arʊ kpɛrhi ngɛ asani ʊringnwʊ kǝni ʊmɛrgnwʊ ʊbrʊbrʊwɔɔ. Une pyerhe ite ararʊ, use mɛr ʊtira Ʊnʊng nɛmɛr kǝni ushoyo ni. ");
INSERT INTO khj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ini idima arʊ kpura ikaisar ngɛ ʊfɛ ogon kii isayo nɛmɛr?” ");
INSERT INTO khj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iyesu kperhi ʊwɔrɔfomo ngɛ wo aka sani mo ni, ");
INSERT INTO khj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Yen mi ikiri ʊfɛ. Uwurowu iyang wɔ ʊni ba yaa adarha ɔwɔri ni ikin?” Oko yoro ngɛ ni, “Imi Ikaisar”. ");
INSERT INTO khj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aka sani omo ni, “Nyi ma Ikaisar ngɛ ima sini ini mi Ikaisar, ama Ʊnʊng ngɛ ima sini ini mi Ʊnʊng.” ");
INSERT INTO khj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Akana bramo ʊkpin ngɛ bekai iring ye bite orokru, ekǝ jijire sini oyori mo ka sa na kprukpring. ");
INSERT INTO khj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Akywa dang opyo arʊ sini ayirhimo ni Asadukiya (arʊ sini ono yoromo ni ʊshinɛ arʊ sini okpuimo), aka ba ɔwroo Iyesu ko gyurho ngɛ asani. ");
INSERT INTO khj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Avuwa, Imusa wori arʊ bi idɔɔ ogro asani, arupya orokru bo kpoo eshere eree asamo ni ɔnɔ ngɛ, itɔɔyo arupya nʊ lorho ubara ɛkǝri erere okro ebyere ɔnɔ bi ʊka arupya. ");
INSERT INTO khj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nɛchiyɛn opyo arʊpya nuwo ani etensara, ɔrɔkɔng mɔ ko lorho ubara ngɛ ko kpoo asaa ni ɔnɔ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Arʊ ʊmang pari ko lorho ubara ngɛ ko kpoo baa ʊkyepen ɔnɔ kaa. ");
INSERT INTO khj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kǝnawo arʊman taru ngɛ ko lorhi ubara ngɛ. Ima iying dang kukum mo ere tensara dang olorho ubara ɛkǝri erere okpomo ekɛne penmo ɔnɔ. ");
INSERT INTO khj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bakurha ngɛ kukum ɛkǝri erere ko kpoo kaa. ");
INSERT INTO khj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ʊnʊng ʊshinɛ eyesing kǝni sini arʊ pya etensara dang olorho ubara ngɛ anu shoo ere iyaa bi idɔɔmo?” ");
INSERT INTO khj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iyesu ko yoro, “Orokru ipyoo yen ku lorhi ubara asu ma ibara. ");
INSERT INTO khj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yip ɛrɛrimɛ kǝni erere arʊ sini amaa ʊshinɛ bi ukpo akiki be ipyoo ukyeba ana su lorhomo ubara anasu mamɔ ubara. ");
INSERT INTO khj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Anasu jo kpomo kii ani kǝni atina Ʊnʊng ni. Ani ɔnɔ Ʊnʊng mo, bekai sini ani ɔnɔ ʊshinɛ bai idɔɔ ukpowo. ");
INSERT INTO khj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yip bidɔɔ ushosho ʊpya orumo, Imusa yen napʊpʊrhi asani arʊ sini okpuimo anu shinɛ, kii ayirhi ɛkǝri Ete ngɛ ni, ‘Ʊnʊng Ibraim, Ʊnʊng Ishaku, adarhi Ʊnʊng Iyakubu.’ ");
INSERT INTO khj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Asaa Ʊnʊng arʊ sini okpomo, yip ani Ʊnʊng arʊ sini ani akrʊmɔ, kii bekai ngɛ wɔ kukum ni akrʊ.” ");
INSERT INTO khj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Opyo avʊwa ʊmɛr ogro Imusa ka sani “Avʊwa ʊpɛrɛ ne mɛr!” ");
INSERT INTO khj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aka samɔ ni ikywi sini anu jo gyurho ngɛ ipyoo ima ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iyesu ko gyurhomo asani, “Ikisi orokru yirhi Ikristi ngɛ ni ɔnɔ Idouda? ");
INSERT INTO khj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ekǝri Idouda kaa wori bidɔɔ ʊyaa ʊsha ete uber: “ ‘Ete sini etem ngɛ ni: “Kiki ba avu ʊram ");
INSERT INTO khj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ke kya akywa sini ini tere arʊ sini ana waamɔnwɔ aki oshoo igɔgɔru ʊtɛ ifraanw.” ’ ");
INSERT INTO khj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Idouda yirhi ngɛ ni ‘Ete.’ Anusa nenyee ɔkɔ jo shoo ɔnɔɔ?” ");
INSERT INTO khj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sini orokru kukum aku kung Iyesu ngɛ, akasani ɔnɔ ʊmɛr ngɛ ni, ");
INSERT INTO khj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Inyi sa noshong ni avʊwa ʊmɛr ogro Imusa men. Ese waa ukyeng kǝri nʊ ʊgbe ʊgbʊgbang ɛwɛi orokru fomo ngɛ bi idɔɔ Ize, awaa uwro kikii ɔmɔmɔrʊ bi owro utuno Ayaudiya kǝni owro ipara. ");
INSERT INTO khj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ɔmɔmɔ ani arʊ ra ni ina ere ukpo. Ʊwaa uyen ʊkamɔ okong otuturo ngɛ bo owro ʊsɔrhɔ Ʊnʊng. Ɔmɔmɔ anu yirha igara irɛ.” ");
INSERT INTO khj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Akywa sini Iyesu shishi bi owro usɔrhɔ Ʊnʊng oko gyo ikra orong arʊ sini ani uma avu ngɛ akʊ ma ʊfɛ bi owro usa ʊfɛ bi owroo usɔrhɔ Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Oko rong opyo erere okro araa yarha asi ikiri ʊfɛ ipari ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iyesu ka sani, “Itanany ʊbrʊbrʊwo, erere okro ara ayarha wen asi imi sini ipri kukum mo: ");
INSERT INTO khj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kukum orokru men ami bai idɔɔ akai ʊma sini ani umoo, yip ɛkǝri erere bidɔɔ ayarha ngɛ ami kukum ima imi sini iparha ɛshɛ bi ukikie.” ");
INSERT INTO khj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Opyo arʊ kroo ngee kasu pere edei sini ekyeni ubyen Ʊnʊng ni atari agyagyang adarha uma ududuma sini ami Ʊnʊng ngɛ. Yip Iyesu ka sani, ");
INSERT INTO khj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“kǝni sini inyi rii umamen ni, akywa yeba sini anau sheremo uru utari baya upyo; anu burayo ngɛ kukum. ");
INSERT INTO khj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Avuwa” oko gyurho ngɛ a sani, “Akina akywa yo anusa umamen? Adarha ngɛ ikimɔyɔ inu shoo ʊpɛ sini arʊ nurong akywa sini umamen ye ba?” ");
INSERT INTO khj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Iyesu ko yoromo asani,“Inyi sa noshong kii ararʊ ke derhiny. Kii orokru napany yeba bi ʊtʊwam, asani, ‘Imye ni ikristi’, ‘Akywa tow ʊfwa.’ Inyi bekya okromoo. ");
INSERT INTO khj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Akywa sini inyi ba kung oshosho ʊraa kǝni ʊshinɛ ɔkɔɔ ededei, inyi bekya kung irung. Itɔɔyo ʊmamen yeba noru, Yip akurha nekebaa kakaimen.” ");
INSERT INTO khj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iyesu ko suno ngee ni ʊtanamɔ asani,“Ibung nushinɛ ʊraa ni ibʊng, igumo nuting ite ni igumo. ");
INSERT INTO khj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ujuro ibʊng nʊ shoo nagang, ihywung nukpaa kǝni idumo ki owroo ededei, uuma irung kǝni ʊpɛ ɔkɔkɔ kyeba baa ayaya. ");
INSERT INTO khj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Yip kekya akywa umamen kukum, anu kpir nyi, ogyurhony. Anu naanyi kya eberi owro utuno Ayaudiya, anu kpir nyi afrany bi ʊbɔrʊ eting, anu kongny kya ite ogumo kǝni ari ite kukum bekai ʊtʊwam. ");
INSERT INTO khj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Yip akywa yenyo inyi nʊ pen apara atanamo imisini Ʊnʊng sa. ");
INSERT INTO khj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yip inyi shere ikywiny, inyi bekya wure ʊkany bekai imisini inyi nʊ yoro ɛkǝri ogumo kǝni arite. ");
INSERT INTO khj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kii ini many urhing kǝni amraa sini ararʊ bidɔɔ arʊ sini ana waamo nyi anubra utin bi iteny ko asa nenyi ni urhingnyi samo nɛmɛr. ");
INSERT INTO khj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ko arʊ byereny, arʊpyany kǝni ɔfɔrɔny, ɔnɔ grony kǝni orokyorony anu gbunanyi ngɛ. Ekǝ pyerhe opyo arʊny. ");
INSERT INTO khj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Orokru kukum nasu waamo nyi bekai ʊtʊwam. ");
INSERT INTO khj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Yip ko ifung ikywi ararʊny iying naw uvroyo. ");
INSERT INTO khj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Inyi bawʊra ikywi, inyi nʊ pen ʊgya. ");
INSERT INTO khj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Akywa sini inyi bakyu rong arʊ tei ikɔ ɛkǝri Urushelima, inyi nʊ kperhi ngɛ asani akywa bura ɛkǝri apya oto iyoyow. ");
INSERT INTO khj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Akywa dang arʊ sini ani bi Iyahudiya itɔɔyɔ atin kyamo ki oyokro, arʊ sini ani idɔɔ apya akuromo, arʊ sini ani idɔɔ afa ebekya raa idɔɔ apya. ");
INSERT INTO khj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kii akywa igara yoye, urhing men nʊ tirɛ kǝni sini ɔwɔri bidɔɔ irhing Ʊnʊng ni. ");
INSERT INTO khj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yip ima okwo ni erere arʊ ko ofo, kǝni arʊ ma ɔnɔ iyan bakya dang! Uma ubibi napany nupen ibʊng yen, anang Ʊnʊng nʊ shuro baya orokru men. ");
INSERT INTO khj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Anu pyerhe opyo arʊmo ni ikama uraa, anu yerhe opyo arʊ kya kukum ibʊng olorho mo ni ʊjang. Arʊ sini ɛnɛkpɛrhimɔ Ʊnʊng nʊ sarhi Urushelima ngɛ kekya ikpara sini akywamo nʊ tirɛ. ");
INSERT INTO khj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ɛpɛ uma ubibi nʊ shoo bi ikra unung, Uperi kǝni Uuyeri. Bi eyesing, kukum Ibʊng nʊ raa idɔɔ igara kǝni uwure adarhi irung bekai utei kǝni ujuro omung. ");
INSERT INTO khj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Orokru nʊ su kyurho bekai irung, ʊwɔrɔ ofo imi sini inupen ari eyesing, kii anu juro ʊʊma ujujire ki ayaya. ");
INSERT INTO khj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bakywa dang anu rong Ɔnɔ Orokru kukyeng ba bidɔɔ umung ni ikrʊ kǝni akai imimɔru. ");
INSERT INTO khj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Akywa sini uumamen nʊ tikpa usa, inyi shinɛ epyerhe ayaya kii akywa oforonyi te ba iyoyow.” ");
INSERT INTO khj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aka tanamo ushoshoo wen: “Inyi rong ʊshi uwee kǝni kukum ashi. ");
INSERT INTO khj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Inyi bo rong atu turo ayaa inyi nʊ kperi ngɛ nivuny asani ikpirhi te ba wurha. ");
INSERT INTO khj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kǝnawo Inyi bakywu rong ʊmamen tusa, inyi kperhi ngɛ asani igumo Ʊnʊng to iyoyow. ");
INSERT INTO khj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Itaniny ʊbrʊbrʊwɔɔ, orokru ipyoo yen anasu kpomo kukummo, umba kukum ʊʊmamen be tirɛ ba. ");
INSERT INTO khj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ayaya kǝni eyesing nʊ kywɛrɛyo, yip iring Ʊnʊng nasu kywɛrɛyo. ");
INSERT INTO khj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Inyi sa noshong ni ʊkany. Inyi bekya yoro ikywiny tirɛ ni uwaa ura uma kǝni uwaa usa uma adarhi uwaa uku ididima eyesing yen, inyi bekya yoro awri dang kya tira kpin nyi kǝni opo ni. ");
INSERT INTO khj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kii eye ba baya orokru kukum kǝni opo ni kokywu ubee bi eyesing. ");
INSERT INTO khj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Inyi sha ʊkany ku kǝni ikpara, ɔsɔrhɔ Ʊnʊng sini inyi nʊ pen ikrʊ imi ʊgya ni kukum uring men sini utekyu usani, adarha ngɛ sini inyi nʊbra uting bi ite ɔnɔ orokru.” ");
INSERT INTO khj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kukyunu unung Iyesu kyer umer bi ɛkǝri ubyen Ʊnʊng, kǝnawo kukyunu ure ese kuno kyaa ɔyoo mɔrɔ ki aya uvra sini ayirhi ni ukro Izaitun. ");
INSERT INTO khj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ni ititikywa kukyunu unung orokru kyer ukuwo bi ubyen Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nɛchiyɛn ipara agbangkrʊ imusang ɛdɛrɛ ofuru, sini ayirhi ni ipara ʊwɔrɔ to iyoyow. ");
INSERT INTO khj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ogu ubyen Ʊnʊng kǝni avʊwa ʊmɛr ogro Imusa kasu waa ʊtira sini imɔ nʊ pɛrɛ Iyesu ngɛ, awaa ʊsa kǝna ʊsʊsɔ bekai sini akung irung ɛkǝri orokru. ");
INSERT INTO khj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ishari ka raa ikywi Iyahuda, arʊ sini ayirhi ngɛ ni Iskariyoti, arʊ sini ani eying bi idɔɔ arʊ atarhi na apari dang. ");
INSERT INTO khj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Iyahuda ka kya eberi Ogubyen Ʊnʊng kǝni arite asha ubyen Ʊnʊng aya pya onuo sini ingɛɛ nʊ gbunamo Iyesu ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aka kung ididima ko yoro asani imo nʊ maa ʊfɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iyahuda ko yoroni kǝna, kaba raa upyerhe apara sini ingɛɛ numa Iyesu ngɛ bavumo sini araru nasu ʊkpɛrhi ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ekǝri awri ipara agbankrɔ ka fwa ami anu ma ikara anatam Ipara ʊwɔrɔ. ");
INSERT INTO khj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iyesu ka tuma Ibitrus mo kǝni Iyohana, a sani, “kya eye kyene arʊ ʊmʊra sini arʊ nura bi ipara ʊwɔrɔ.” ");
INSERT INTO khj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Oko gyurho ngɛ, “Ʊwɛini arʊ ye kyene bi ubewo?” ");
INSERT INTO khj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Oko yoromo a sani, “Inyi basu raa ɛkǝri apya, Inyi nʊ sira ni opyoo orokru okong obom omung. Inyi kroo ngee kekya ʊna sini anʊ raa ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","asani ɛkǝri arʊ ʊna ni, ‘Avuwa gyurhi ni: eki ʊbɔrʊ ekyeng, owro sini imye kǝni ɔnɔ ʊmɛr mi nura ʊmʊra ipara ʊwɔrɔ ngɛ?’ ");
INSERT INTO khj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Anu yen nyi okru ʊbɔrʊ bi ʊna ayaya sini ekywere ukɛnewo, inyi nʊ darha asa ʊʊma ngɛ nɛmɛr. Inyi kyene ʊmʊra burha.” ");
INSERT INTO khj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aka kyaa aya darha nɛmɛr kǝni sini Iyesu tanimo ni. Ekǝ kyene ɛkǝri ʊmʊra ipara ʊwɔrɔ. ");
INSERT INTO khj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sini akywa fwi, Iyesu ka kiki kǝni ɔnɔ ʊmɛr ngɛ awaa ʊra ʊmʊra. ");
INSERT INTO khj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aka sani ɔmɔni, “Iwaa akyu sani ira ʊmʊra ipara ʊwɔrɔ men kǝni enyi kekya ikpara sini inu kung igara. ");
INSERT INTO khj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kii iku tana nyi, inojo rammɔ, sai ibɛ tirɛ bi idɔɔ igumo Ʊnʊng.” ");
INSERT INTO khj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iyesu ka kpara ɔsɔng, kasa Ʊnʊng ngɛ ija, ka sani, “Inyi yirha akǝkaa bi idɔɔ opyony. ");
INSERT INTO khj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Iku tana nyi, inojo sam omung osumo ʊshi inabi men, sai igumo Ʊnʊng ba ba.” ");
INSERT INTO khj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aka kpari ipara ɔgbɔnkrʊ, kasa Ʊnʊng ngɛ ija, ka yurhayɔ, amamɔ, a sani, “Inamam yɔɔye aminy; inyi sa kǝn asu dirha ni emye.” ");
INSERT INTO khj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kǝni sini asini, sini ɛkywɛri ʊra ʊmʊra ʊrɛ aka kpara ɔsɔng, ka sani, “Ɔsɔng yen ulorho iring isayo sini afri ni eyi mi, sini aniri ngɛ bi ʊkany. ");
INSERT INTO khj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yip ekǝri arʊ sini anu gbunam ngɛ we akiki kǝni emye ngɛ ben. ");
INSERT INTO khj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ɔnɔ orokru nʊ kpoo kǝni sini Ʊnʊng kyoni, yip ima okwoyo ini arʊ sini anu agbuna ngee!” ");
INSERT INTO khj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Akywa dang ɔnɔ ʊtina ngɛ ka tikpa ʊsʊ gyurho opyoomo, iyaa bi idɔɔmɔ, anushe ʊsi ima yen. ");
INSERT INTO khj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yip ɛkǝ shinɛ amaa ni opyoomo, bɛkai sini akʊ wɔrɔ ofo iyaa anʊshoo arite bi idɔɔmɔ. ");
INSERT INTO khj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iyesu ka sani ɔmɔni, “Ogumo arʊ sini ɛnɛkpɛrhimɔ Ʊnʊng ese yen arʊmɔ ikrʊ, ese yirha opyoomo ni arʊshɛ orokru. ");
INSERT INTO khj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yip inyi naw shoony kǝni ɔmɔni. Bi ʊka kǝna arite bi idɔɔ nyi anu shoo kǝni ara ajajini, arʊ sini ani ogumo anu shoo kǝni arʊ sa ʊtʊna ni. ");
INSERT INTO khj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Iyaa ni arite, arʊ sini akiki asura ʊmʊra ngɛ kii arʊ ʊkaa ɛkǝri ʊmʊra ngɛ? Arʊ sini akiki asura ngee? Yip ini bi idɔɔ nyi kǝni arʊ kaa ʊmʊra ni. ");
INSERT INTO khj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Inyimo inyi ting kǝni emye ngɛ bi idɔɔ ʊmarha sini isii. ");
INSERT INTO khj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kǝni sini Ɛkpɛri mim ikrʊ igumo ni, kǝnawo ikumany nɛmɛr kǝna. ");
INSERT INTO khj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Inyi nʊ ra asa kǝni emyee bi idɔɔ igumom. Inyi nʊ kiki bi igɔgɔrʊ igumo, okong igumo baya edei atarhi na pari ami ɔnɔ Isrela. ");
INSERT INTO khj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Isimon, Isimon, shywi akʊng! Ishari waa apara ʊwaw ʊmarhany, akaanyi oworo igigyang kǝni ibibi kǝni sini arʊ owro so woro ikiri ogro bai idɔɔ iwʊng ni. ");
INSERT INTO khj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Yip Ikarha sɔrhɔ Ʊnʊng ngɛ bi ʊkanw, Isimon, sini ʊma ʊbrʊbrʊnw nasu kpaawɔ. Kǝnawɔ akywa sini ube tere ba ni ɛmyɛ ʊta onogronw ikrʊ ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Isimon kasani, “Ete, ikarha ekywere utuno ʊʊma iye kya kǝni nwoo ko bi ʊbɔrʊ eting ko bi ukpo.” ");
INSERT INTO khj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iyesu ko yoro, “Itananw, Ibitrus, kekya akywa sini ɔkɔrɔ nʊpɛn echiye, ʊnʊ raa amaa ngɛ asi itaru asani ʊnɛ kperhinw imye.” ");
INSERT INTO khj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ikpara dang Iyesu ko gyurho mo, “Akywa sini ituminy bai ipa ʊfɛ, bai ʊbʊrhʊ ko ataka, inyi tii iririma?” Oko yoro, “Bai iririma.” ");
INSERT INTO khj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Akasani omoni, “Yip nɛchiyɛn arʊ sini oboshoo ni ipa ʊfɛ ngɛ akpara yo, kǝnawo ʊbʊrhʊ; kǝnawo uba sanw ni ikama igbang ngɛ, ʊgbʊna igbɛ irenw ere iying ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kii itaniny asani ɛkǝri iring Ʊnʊng peri asani: ‘Apari ngɛ bidɔɔ arʊya.’Ika tanany asani itɔɔyo inyeen tirɛ bi ikywim. Kii imisini ɔwɔri bi ikywim ʊkʊ kyeeba ʊtirɛ.” ");
INSERT INTO khj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɔnɔ ʊmɛr ngɛ kasani, “Rong, Ete, ʊkama ʊgbang ʊpari me.” Oko yoromo asani, “Imaa kǝna!” ");
INSERT INTO khj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iyesu ko kuno kyaa kǝni sini ɛrɛn ngɛ ni kya aya ukro Izaitun, ɔnɔ ʊmɛr ngɛ ko kroo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ni ʊsʊ fwa eberi ngɛ akasani ɔmɔni,“Inyi sɔrhɔ Ʊnʊng kii inyi kya kpaa bidɔɔ ʊmarha.” ");
INSERT INTO khj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ekǝ yin ngɛ naji ikarha ngɛ ini kǝni ʊfɛn ʊtari ni ko kpukporo ɔsɔrhɔ Ʊnʊng asani, ");
INSERT INTO khj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ɛkpɛri, iboshoo ʊwaanw wɔ, ʊkparam ɔsɔng igara yen ngɛ. Yip sa imisini ʊnwʊɔ ʊwɛi bekya sa imisini imyee iwɛi.” ");
INSERT INTO khj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Atina Ʊnʊng ba ayaya kaba eberi ngɛ aba taa ikrʊ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɔkɔ sɔrhɔ Ʊnʊng nagang, kii akung irung igara ukyeba, idung ngɛ ku tono bi ibʊng kǝni eyi ni. ");
INSERT INTO khj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nisini ɛshini baa owro ʊsɔrhɔ Ʊnʊng ko juro baa owro ɔnɔ ʊmɛr ngɛ, aka darha mo aku moro. Ofokru mo samɔ ʊkara. ");
INSERT INTO khj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oko gyurho mo asani, “Ikisi inyi ku moro? Inyi shinɛ ɔsɔrhɔ Ʊnʊng kii inyi kya kpaa bi idɔɔ ʊmarha.” ");
INSERT INTO khj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nisini eshishi ʊpya onuo ushi orokru ka ba. Ereying bi idɔɔ ɔnɔ ʊmɛr ngɛ sini ayirhi ngɛ ni Iyahuda ɛngɛɛ kpite okomo ba. Ekǝ yin ba ikwo Iyesu ɛwɛ kǝn ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yip Iyesu ko gyurho ngɛ, “Iyahuda ni ukɛnwɔ ʊwa gbuna ɔnɔ orokru ngɛɛ?” ");
INSERT INTO khj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nisini ɔnɔ ʊmɛr Iyesu rii imisini iku waa ukyeng, akasani, “Ete, arʊ kpa orokru men ni ikama igbang arʊ?” ");
INSERT INTO khj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ereying bi idɔɔmo ka kpa agara ogu ubyen Ʊnʊng, ʊtʊng ngɛ ʊʊma avu ʊra. ");
INSERT INTO khj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yip Iyesu ko yoro asani, “Imaa kǝna!” Aka pya ʊtʊng ɛkǝri orokru ekǝ pen ikrʊ. ");
INSERT INTO khj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iyesu kasani ɛkǝri ogu ubyen, arite asha ubyen Ʊnʊng, adarha ɔrɔkɔng, arʊ sini abii ʊwaa ʊkpin ngɛ ni, “Ikisi inyi kuno ni ʊkama ʊgbang kǝni ʊkʊma ashi ʊwaa kpin mi kǝni ine eyi ni? ");
INSERT INTO khj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ku kyunu ʊnʊng ini kǝni inyi ngɛ bi idɔɔ ubyen Ʊnʊng, inyi kyana pyany imye. Yip akywany yoye sini ini imi igumo eting.” ");
INSERT INTO khj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aka kpin Iyesu ngɛ akyamo ne ngɛ kidɔɔ ʊna ogu ubyen Ʊnʊng. Ibitrus su kroo ngɛ bai ikǝkarha. ");
INSERT INTO khj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nisini opyoo arʊ kǝni ʊra bi ʊgba ʊpyang akiki kukum asu ʊwɛri ʊra, Ibitrus ka kiki kǝni ɔmɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Opyo agara erere rie akiki burha bi idɔɔ uyen ʊra. Oko koo ikra nɛgbɛn kasani,“Orokru wen ni kǝni ɛngɛɛ ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yip aka ra amaa ngɛ asani, “Erere, inɛ kperhim ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Anakywa naji opyo arʊ ko roo ka sani, “Ʊnwɔ kanw ʊnidɔɔ mɔ.” Ibitrus ko yoro kasani, “Ɛrɛrimɛ, isam idɔɔ mɔ!” ");
INSERT INTO khj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kekya ʊkpin itɔmɔ iying opyo arʊ kojo sani, “Ʊbrʊbrʊwɔɔ orokru wen ni kǝni ɛngɛɛ ngɛ, kii ari Igalili ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ibitrus ko yoro asani, “Ɛrɛrimɛ, inɛ kperhim imisini uku tana!” Nisini eshishi ʊpya onuo ɔkɔrɔ kǝpɛn. ");
INSERT INTO khj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ete Iyesu kǝ tere ikramo ka sira itituku kǝni Ibitrus. Akywa dang Ibitrus ka dirha ni iring sini Ete tani ngɛ:“Kyekya upɛn ɔkɔrɔ echiye ʊna ra amaa ngɛ ni ʊnɛ kperhinw emye asi taru.” ");
INSERT INTO khj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Oko kuno kyaa esing eye tei nagang. ");
INSERT INTO khj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Arʊ tɛi ikɔ sini akʊ sha Iyesu ngɛ aka raa ʊsina ngɛ kǝni ʊkraa. ");
INSERT INTO khj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Oko lorho ngɛ ikra ni ʊtʊgbɛ aka sani ngɛ ni, “Tana onuo Ʊnʊng! Iyaa ogyung?” ");
INSERT INTO khj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aka tana ngɛ ʊring ukǝkǝǝ idedei. ");
INSERT INTO khj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ni ʊba ʊyɛrɛ itikywa ɔrɔkɔng tuno, bi ʊpʊrha ogu ubyen Ʊnʊng kǝni avʊwa ʊmɛr ogro nikǝni ɔmɔɔ, oko kong Iyesu ba bi itemo. ");
INSERT INTO khj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Akasani ɛngɛɛ ni, “Tana arʊ, ʊnwʊɔ ʊni Ikristi?” Iyesu ko yoro mo, “Iba tany inyi nasu yorony ni ɛmyɛ, ");
INSERT INTO khj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ibo gyurhony inyi nasu yorony ɛmyɛ. ");
INSERT INTO khj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Yip Imisini ikpin bai kaimen, ɔnɔ orokru nʊ kiki ba avu ʊra Ʊnʊng ogumo ikrʊ kukum.” ");
INSERT INTO khj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kukummo oko gyurho ngɛ, “Nɛchiyɛn ʊnwɔ ni ɛkǝri Ɔnɔ Ʊnʊng?” Oko yoro mo asani, “E Inyi pɛrɛ nɛmɛr imyee.” ");
INSERT INTO khj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Akasani, “Ikisi arʊ ku waa araru jo tana arʊ, arʊ kyu karha kuwɔ ni atung arʊ sini eperi ni onuo.” ");
INSERT INTO khj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ekǝri akywa dang kukum orokru sini ani burha ka shinɛ kpaa ngɛ kyaa bi ite Ibilatus. ");
INSERT INTO khj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aka kpin upre ngɛ, eteting asani, “Arʊ darha orokru wen aku dɛrhi ararʊ. Akarhamɔ ʊkpʊra Ikaisar ngɛ ogon asani ɛngɛɛ ni Ikristi, oshoo ogumo.” ");
INSERT INTO khj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ikpara dang Ibilatus ko gyurho Iyesu ngɛ ni, “Ʊnwʊɔ ni ogumo Ayaudiya?” Iyesu ko yoro ngɛ, “Ʊpɛrɛ nɛmɛr.” ");
INSERT INTO khj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ibilatus katana ɛkǝri ogu ubyen Ʊnʊng kǝni ɛkǝri ushi, “Ine penmi ngɛ ni irhirhing ibibi.” ");
INSERT INTO khj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yip akya noyoromo, oko sunomo ngɛ ʊsani, “Akʊ dɛrhi orokru kukum Iyahudiya ni ʊmɛr ngɛ. Atiikpa bai Igalili nɛchiyɛn ewe oto ben.” ");
INSERT INTO khj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ni ʊkʊng kǝna, Ibilatus ko gyurho kii ɛkǝri orokru ni ari Igalili ngee. ");
INSERT INTO khj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nisini a kperhi ngɛ asani Iyesu ni bai ibʊng Igumo Ihiridus yo aka tuma ni ngɛ kya eberi Ihiridus arʊ sini ani bi Urushelima kaa bi ikpara dang. ");
INSERT INTO khj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nisini Ihiridus rii Iyesu ngɛ, aka kung nɛgbɛn! Nagang, kii uwruwroo aku waa sini ingɛɛ nʊ roo. Bekai imisini akung bi ikywie, aku tira ikywi ngɛ nʊ rong asi ʊʊma ujijire sini inuyen ikrʊ Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ɔkɔ shɔrhɔ Iyesu ngɛ ni ugyurho napany, yip Iyesu kyana yoroo ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ɛkǝri ogu ubyen Ʊnʊng kǝni ɛkǝri avʊwa ʊmɛr ogro titing burha, asu tana ʊraa ngɛ nagang ani Iyesu si ima ibibi. ");
INSERT INTO khj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ikpara dang Ihiridus kǝni arʊ tɛikɔ ngɛ kasu maa ʊwa, asu sina ngɛ, ɔkɔ sɔmɔ ngɛ igbɛ irɛ igigyang okojo tuma ni ɛngɛɛ kyamo eberi Ibilatus. ");
INSERT INTO khj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ʊnʊng dang Ihiridus kǝni Ibilatus ko to orokyoro kii uwruwroo ana siramo ni opyo. ");
INSERT INTO khj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ibilatus kayirha ogu ubyen Ʊnʊng kǝni arite adarha orokru owro eying, ");
INSERT INTO khj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kasani moni, “Inyi kom orokru wen ba ani akʊ derhi orokru ni ɛshinɛ ɔkɔɔ ni igumo. Igyurho ngɛ ʊring bi itenyi ben Ine penmi ngɛ ni irhirhing ibibi kǝni sini inyi pɛrɛ bi ikywie ni. ");
INSERT INTO khj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kǝnawo Ihiridus kǝne pen ɛngɛɛ ni irhirhing ibibi, ʊwɔwɔ ojo tuma ni ɛngɛɛ ba owro arʊ. Kǝni sini inyi rii ni ese sa iririma sini imaa ukpo. ");
INSERT INTO khj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bi kǝna wɔ, Ini kyerhe ngɛ ʊwɔwɔrhʊ eshere ngɛ akyaa.” ");
INSERT INTO khj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kii itɔɔyo Ibilatus eshiremo orokru eying bau idɔɔ ʊbɔrʊ eting, arʊ sini orokru sɔrhi bakywa ipara ʊwɔrɔmɔ. ");
INSERT INTO khj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ekǝri ushi orokru kukum ka fen akpa, “Pere orokru wen! Eshire arʊ Ibarabas ngɛ!” ");
INSERT INTO khj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ibarabas arʊ sini odo shoo bi ʊbɔrʊ eting, ɛngɛɛ ɛshini ɔkɔɔ bi idɔɔ Urushelima, ɛpɛrɛ orokru.) ");
INSERT INTO khj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ibilatus waa ushere Iyesu ngɛ, oko jo sɔrhɔ ɛkǝri ushi orokru. ");
INSERT INTO khj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yip oko susuno mo ngɛ ʊtakpa, “Kpaa baya agara akii okpoo! Kpaa ba agara akii okpoo!” ");
INSERT INTO khj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Okojo pɛrɛ ni ɔmɔ ʊmang taru ngɛ: “Ikiyɔ? Akina eteting yo orokru wen si? Ise penmi ngɛ ni iriring sini imaa ukpo. Bi bʊkǝnawɔ Inʊ kyerhe ngɛ ʊwɔwɔrhʊ eshere ngɛ akyaa.” ");
INSERT INTO khj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Yip kǝni ʊta akpa ngɛ ayaya oko sunomoo ngɛ ni ʊwaa ni akpaa baya agara. Ba kurha ngɛ akpamo kamamo imu waamɔ. ");
INSERT INTO khj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bi bʊkǝnawɔ Ibilatus ka kywa iring ʊpɛrɛ Iyesu ngɛ kǝni ʊwaa moni. ");
INSERT INTO khj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ekǝ shere ɛkǝri Ibarabas ngɛ arʊ sini afrii bi ʊbɔrʊ eting bekai ʊshinɛ ɔkɔɔ kǝni ʊpɛrɛ orokru, arʊ sini ani imɔ wɛi, ka mamɔ Iyesu ngɛ asa imisini imo wɛi ni ɛngɛɛ. ");
INSERT INTO khj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nisini ɛkǝri arʊ tɛi ikɔ ku kyamɔ ni Iyesu, aka kpin Isimon ngɛ arʊ Isayirin, arʊ sini akʊ juro kyebaa idɔɔ apya bai ibʊng ʊkʊkǝri, akakpin ngɛ asaa ngɛ agara, asaa ʊkparayɔ okroo Iyesu ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Akai ushi orokru ko kroo ngɛ, bi idɔɔmo erere nuwo arʊ sini ɛtiri ni ofo okru asu tei kǝni ʊnira ere ngɛ bekai ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iyesu ka tere asani ɔmɔni,“Erere Urushelima, inyi bekya etei mi; inyi tei ʊkany kǝni ɔnɔny. ");
INSERT INTO khj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kii ɛkǝri akywa yeba sini inyi nusani, ‘Ʊnʊng ta erere sini asamo ni ɔnɔ ngɛ, ofo sini ese byere yo ko niying kǝni ayan sini ɔnɔ sesamo! Onuo adadʊma!’ ");
INSERT INTO khj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ikpara dang, “ ‘Orokru nʊ sani ukro ni, “Kpa baya arʊ!” Ka sani avra, “Fra arʊ!” ’ ");
INSERT INTO khj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kii orokru basa ʊring men akywa sini ʊshi negǝgǝre, ikimoyo inushoo nenyee ʊba kʊrawɔ?” ");
INSERT INTO khj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Opyo arʊ sa ʊʊma ubibi apari nuo kǝni Iyesu ngɛ sini akpin mɔ ɛwɛyɛ pɛrhɛmɔ. ");
INSERT INTO khj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nisini abii owro sini ayirhi ni “Ukʊri ikywi”, Burha aka kpaa baya agara kǝni arʊ sa ʊʊma ubibi apari dang ere ying ba avu ʊra, opyo arʊ ba avʊ ʊprʊma. ");
INSERT INTO khj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iyesu kasani, “Ɛkpɛri, pʊnamɔ ʊyamɔ ngɛ, kii ɛnɛ kpɛrhimɔ imisini akʊsa.” Aka kǝkaa igbɛ ngɛ kǝ fer atari orong iyaa nʊ kpara ikina ni. ");
INSERT INTO khj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Orokru titing asu rong ngɛ, arite orokru kasu saa ʊwa, asu sina ngɛ. Aka sani, “Asa opyo arʊ oforo; asu ʊkaa ibo shoo asani ɛngɛɛ ni Ikristi, arʊ sini Ʊnʊng karha oworo ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ekǝri arʊ tɛi ikɔ kaba asu sina ngɛ. Aka maa imusa ʊkpakpam, ");
INSERT INTO khj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","asani, “Ibo shoo ʊnwʊɔ ni ogumo Ayaudiya, sa ʊkanw oforo.” ");
INSERT INTO khj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ɔwɔri ʊwɔrɔ akpa bayarhi ikywie ʊmʊsini ʊsini: EWEN NGƐƐ NI OGUMO AYAUDIYA ");
INSERT INTO khj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ereying bidɔɔ ɛkǝri arʊ sa ʊʊma ubibi sini osuni ngɛ ba agara burha kasu ushorho ngɛ ʊtira ani: “Si ʊnwʊɔ ni Ikristi? Sa ʊkanw Oforo kǝni arʊɔ!” ");
INSERT INTO khj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yip orobyoo ɛkǝri arʊ sa ʊʊma ubibi ka tana awan arʊ ʊraa ngɛ. Kasani, “Ʊna kung irung Ʊnʊng, bekai sini akywiny iring ukpo nɛmɛr kǝni ɛngɛɛ? ");
INSERT INTO khj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Igara arʊ nɛmɛr, kii arʊ ku pen nɛmɛr ni imisini arʊ si, yip orokru wen sesaa irima ibibi.” ");
INSERT INTO khj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ikpara dang aka sani, “Iyesu dirha ni imye akywa sini uba ba bidɔɔ igumonw.” ");
INSERT INTO khj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iyesu ko yoro ngɛ, “Ʊbrʊbrʊwɔɔ itaninw, ɛchiyɛ yen ʊnʊ shoo kǝni ɛmyɛɛ bi Iparadai.” ");
INSERT INTO khj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kekyaa ni ikpakpaa awri wɔ, owro kasa eting bi kukum ibʊng kekyaa akywa itomo itaru ni awri, ");
INSERT INTO khj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kii ʊnʊng shere ʊta ngɛ. Ikyɛri sini akai owro ʊshisha kǝni ubyen Ʊnʊng ka sarayo ba barating bayaya kyeba atata. ");
INSERT INTO khj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iyesu ka ta onuo ayaya ayirha kasani, “Ɛkpɛri, ima ʊring mi ba avunw.” Nisini eperi kǝna, aka wara ʊfɛn ngɛ ʊʊma akurha ko kpoo. ");
INSERT INTO khj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nisini arite arʊ tɛikɔ rii imasini isi, oko dɔɔ Ʊnʊng ngɛ asani, “Iyoro ni orokru wen ni nashisha.” ");
INSERT INTO khj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nisini orokru sini otuni burha owo orong imisini iku kyeng, rii imisini isi, akasʊ kra ikɔw mɔ akyamɔ. ");
INSERT INTO khj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yip kukum arʊ sini ekperhi ngɛ, kǝni erere sini okrii ngɛ bai Igalili, atiting bai ikǝkarha, kasu rong ʊmamen. ");
INSERT INTO khj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Opyo orokru nuwo burha arʊ sini ayirhi ʊtʊwa ngɛ ni Isufu, ani ere ying bidɔɔ ari igumo Ayahudiya, ani nɛgbɛn oshoo nashisha. ");
INSERT INTO khj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Arʊ sini atiri ngɛ ʊwɔrhɔ utumo imisini asi. Okuni ba apya Ayaudiya bi Ibung Arimatiya, ingɛɛ kaa aku sha igumo Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Aka kya owro Ibilatus ɔyo sɔrhɔ ʊkʊng Iyesu. ");
INSERT INTO khj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ikpara dang oko shurowo bi bʊng, ka gǝrhawo ni ʊpɛri ka yara ngɛ bi ɔgrɔn sini ɔsɔi bi ʊpang, amisini ese minemo ararʊ ngɛ wroo sini ɔsɔiyo. ");
INSERT INTO khj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Asi ʊmamen kukum ʊnʊng ukyene ʊʊma Ayaudiya sini anakywa shi naji ni awri uwuro Ayaudiya tikpa. ");
INSERT INTO khj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Erere sini abii kǝni Iyesu ngɛ bai Igalili ko krii Isufu ngɛ oyo rong ɛkǝri ɔgrɔn kǝni sini ayari inama ngɛ bidɔɔyɔ. ");
INSERT INTO khj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Akywa dang oko juro kyamo ʊduna ekǝ ye kyene ɛnyɛ ʊnyang ʊdʊdʊma kǝni anayaa ʊnyang ʊdʊdʊma. Yip oko wuro awri uwuro Ayaudiya kǝni sini ogro peri ni. ");
INSERT INTO khj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ni ititikywa awri etensara itee isati, ɛkǝri erere ka kpara ikang kǝni ɛnyɛ ʊnyang ududuma sini ekyeni okyo ka kpin ʊtira kyamo ɛkǝri owro ɔgrɔn. ");
INSERT INTO khj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Aka darha eyin ʊtari ngɛ bo nuwo ɔgrɔn, ");
INSERT INTO khj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","yip nisini arii idɔɔ ɔgrɔn, onoromo ʊkʊng Ete Iyesu. ");
INSERT INTO khj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Anayu ʊwɔrɔfo bi ikywi ʊmamen, ba kywakywa dang opyo orokru apari sini ɔsɔmi ʊʊma ufufuru sini ʊkʊ yana kǝni uyen ʊnʊng ni ko kuno atiting bi itʊngmɔ. ");
INSERT INTO khj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ikpara dang ɛkǝri erere ka kʊng irung ngɛ nagang ko susuno akywimɔ ibʊng, yip ɛkǝri orokru kasani ɔmɔ ni,“Ikisi inyi kʊ pyerhe arʊ akrʊ bidɔɔ arʊ sini okpuimo? ");
INSERT INTO khj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Asaa ngɛ ben! Akarha akyushinɛ! Inyi dirha imisini atany, bi ikpara sini eshishi kǝni enyi ngɛ bi Igalili: ");
INSERT INTO khj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Itɔɔyo ama ɔnɔ orokru ba avu arʊya, anu kpaa baya agara. Yip bi awri ʊmang taru anu shinɛ.’ ” ");
INSERT INTO khj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ekpara dang aka dirha ni ʊring ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nisini ojuri bai owro ɔgrɔn, aka tana ɔnɔ ʊmɛr ngɛ atarhi ni eying kǝni ʊparha ɛshɛ arʊ kroo ngɛ kukum ʊring men. ");
INSERT INTO khj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Imeri arʊ kuno bai Imadala, Ijowana kǝni Imeri akwa Iyakubu adarha ʊparha ɛshɛ erere sini ani kǝni ɔmɔɔ. Ɔmɔmɔ atani ɔnɔ ʊmɛr ngɛ ʊring men. ");
INSERT INTO khj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yip ʊsang uyoromo ni imisini ɛkǝri erere peri, kii akʊng kǝni iring ukǝkǝe yoni. ");
INSERT INTO khj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bi kǝna, Ibitrus kǝ shinɛ ni atara kya ɛkǝri owro ɔgrɔn. Oko kpukporo kǝ ten kidɔɔ ko rong uperi sini agǝrhi Iyesu ngɛ ʊyari bi itung, akywa dang oko juro kyaa ʊduna, asu wɔrɔfo asani ikimoyo isi. ");
INSERT INTO khj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ba awri eying dang ɔnɔ ʊmɛr Iyesu apari aku kyeng kyamo opyo apyang sini ayirhi ʊtʊwa ni Imawus, amisini ikarha ngɛ kǝni Urushelima ini kekyaa ʊkpin ikilomita atari ni eying. ");
INSERT INTO khj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Akasʊ pɛrɛ ni opyomo bekai kukum ʊmʊsini ʊsi. ");
INSERT INTO khj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nisini akʊ pɛrɛ asu pya onuo ʊring men ni opyo mo, Iyesu ko kuno nivuo asu kyeng kǝni ɔmɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Oroo ngɛ, yip ɛkǝne kperhimo asani Iyesu ngee. ");
INSERT INTO khj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Iyesu ko gyurho mo, “Ikimoyo inyi ku pɛrɛ ni opyony, sini inyi ku kyeng bi ʊtira?” Aka ting nakprukpring, abubura ikywi. ");
INSERT INTO khj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ereying bi idɔɔ mo, sini ayirhi ʊtʊwa ni Ikilopas, ko gyurho ngɛ, “Ʊnwʊɔ eyeyinw ʊni ekyeng bi Urushelima sini ʊnɛ kperhinw ʊring men sini uku kyeng ba awri men ni?” ");
INSERT INTO khj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Iyesu ko gyurho mo,“Ʊkina ʊma?” Oko yoro ngɛ, “Ʊma sini upen Iyesu ari Inazaret. Ani arʊ pɛrɛ onuo Ʊnʊng ngɛ. Ʊring ngɛ kǝni ʊʊma ʊsaa ni ikrʊʊ bi ite Ʊnʊng adarha bi ite orokru kukum. ");
INSERT INTO khj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ogu ubyen Ʊnʊng kǝni ogumo akpari ngɛ ama aki akywaa iring ukpo imisini anu aka kpaa baya agara ɛpɛrɛ ngɛ, ");
INSERT INTO khj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","yip arʊ ku ʊtira ikywi ngɛ asani ɛngɛɛ nʊ basa ari Isrela oforo. Si ʊkywɛrɛwɔ wurha, echiye ni awri ʊmang taru wro kǝni sini ʊmamen si ni. ");
INSERT INTO khj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Adarha ngɛ opyo erere bi idɔɔ arʊ kǝ jijire arʊ nagang, sini ɛshini ni ititikywa yen akya eberi ɔgrɔn, ");
INSERT INTO khj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yip akyana romo ʊkʊng ngee. Oko juro aba tana arʊ asani imɔ rong opyo atina Ʊnʊng arʊ sini atana arʊ asani Iyesu ni akrʊ. ");
INSERT INTO khj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ikpara dang opyo arʊ bi idɔɔ arʊ kǝ shinɛ kya ɔgrɔn owro sini emine ngɛ aya darha nɛmɛr kǝni sini ɛkǝri erere pɛrɛ ni, yip akya no romo Iyesu ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Akywa dang Iyesu ka sani ɔmɔ ni, “Inyi sine nye inyi ni egmee kǝn, inyi sine nye inyi ni oshong owro oyoro bidɔɔ ikywiny ni kukum imisini arʊ pɛrɛ onuo Ʊnʊng pɛri! ");
INSERT INTO khj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Si itɔɔyo Ikristi kung igara ʊmamen ko shoo ni ʊraa igumo ngɛ?” ");
INSERT INTO khj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iyesu ka tana mo kukum imisini ɔwori bi idɔɔ iring Ʊnʊng bi ikywie, kpara bai ogro Imusa adarha kukum ʊwɔrɔ arʊ pɛrɛ onuo Ʊnʊng. ");
INSERT INTO khj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nisini etekya fwa ɛkǝri apyang sini eye kyamo ngɛ, Iyesu ko suno ngɛ ni okyoro kǝni aya kyaa ki ikǝkarhawo ni. ");
INSERT INTO khj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yip oko sɔrhɔ ngɛ asani, “Ki kǝni arʊ ngɛ, kii ewure kpaa; ʊnʊng kywɛrɛwo.” Bi kǝna Iyesu ka raa ʊna akiki kǝni ɔmɔɔ. ");
INSERT INTO khj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Akywa sini akiki kǝni ɔmɔɔ awa ra ʊmʊra, aka kpara agbankrɔ, kasa ija, oko jurho ama mo. ");
INSERT INTO khj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ikpara dang ikramo kǝ yɛɛ, ekǝ kperhi ngɛ asani Iyesu ngee, akywa dang oko vroo moni urong. ");
INSERT INTO khj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aka sani opyo omo ni, “Ʊbrʊbrʊ! Ikywi arʊ kasu pyayo sini akʊ pɛrɛ ni arʊ bi ʊtira asu furɔ arʊ iring Ʊnʊng” ");
INSERT INTO khj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Aka tira shinɛ ojuro kyamo Urushelima. Aka ya darha atina ngɛ atarhi ni eying dang otuni eberi ying kǝni opyoo arʊ, ");
INSERT INTO khj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","akʊ tana ni, “Ʊbrʊbrʊwɔɔ! Ete karha akyu shinɛ! Eyen ʊkaa bi ite Isimon roo ngɛ.” ");
INSERT INTO khj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɛkǝri ɔnɔ ʊmɛr apari ka tanamo imisini isi bi ʊtira, adarha sini ekperhi ni Iyesu ngɛ bakywa sini ojurhi ikyɛɛ ufuforho. ");
INSERT INTO khj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Akywa sini eshi ʊtʊtana ʊring men Iyesu nivuo oko kuno abarating mo ofomo ngɛ asani, “Ʊyari ikywi kyeba eberi nyi.” ");
INSERT INTO khj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ekǝ jijire ngɛ ka kung irʊng ngɛ nagang, asu wɔrɔfo kii imo rii ering ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iyesu ka sani ɔmɔ ni, “Ikisi inyi kpi eyi, ikisi ikywiny ni ipari? ");
INSERT INTO khj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Inyi rong ivum kǝni ifraam. Imyee nivum! Inyi pyam akʊng; kii ering saa ni inama ngɛ kǝni okwoo, kǝni sini inyi rii ini oyo ngɛ ni.” ");
INSERT INTO khj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nisini eperi kǝna ekǝ yen mo ivuo kǝni ifraa. ");
INSERT INTO khj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bʊkǝna ʊsang uyoromo, bekai ofofuru kǝni ujijire. Ikpara dang Iyesu ko gyurho mo, “Inyi ni iri ʊmʊra ngɛ ben?” ");
INSERT INTO khj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aka maa uting itofuru ufuforho, ");
INSERT INTO khj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","aka yirha ara bi ite mo. ");
INSERT INTO khj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iyesu kasa ni ɔmɔ ni,“Imisini itanayi ye akywa sini ishishi kǝni enyi ngɛ: Kukum ʊmasini ɔwɔri bi idɔɔ ogro Imusa, arʊ pɛrɛ onuo Ʊnʊng kǝni ɛtɛ, itɔɔyo itirɛ bi ikywim.” ");
INSERT INTO khj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ikpara dang ekǝ yɛɛ mo ikywi aki ɛkperhi iring Ʊnʊng ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aka tana mo, “Imisini ɔwɔri ye: Ikristi nʊ si igara, ɛshinɛ, ba awri ʊmang taru. ");
INSERT INTO khj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Okojo wɔrɔ asani bidɔɔ ʊpyaawɔ anu tana iring ididima bidɔɔ ʊtʊwa ngɛ kya kukum Ibʊng atikpa bai Urushelima, ni orokru shere ʊya ngɛ aki Ʊnʊng pʊnamɔ ʊyamɔ ngɛ. ");
INSERT INTO khj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Inyimo inyi ni arʊ sini inyi rii imisini isi ben. Itɔɔyo inyi tana opyo arʊ bekaiyo. ");
INSERT INTO khj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nɛchiyɛn inyi kung, Inu tumany ni ʊma onuo Ɛkpɛrim Ering ʊshisha bayany; yip inyi sha bidɔɔ apya noru kekya akywa sini inyi nʊ tirɛ ni ikrʊ ba ayaya.” ");
INSERT INTO khj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iyesu ko kuno ni ɔnɔ ʊmɛr ngɛ bi idɔɔ apya kekyaa ʊkpin Ibetani, ekǝ shwe ivʊ ayaya kasa ija. ");
INSERT INTO khj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nisini asa ija, ekǝ sheremo Ʊnʊng ka kpara ngɛ kyaa ayaya. ");
INSERT INTO khj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Oko kpukporo akywa dang ko dɔɔ ekǝ tirɛ ni ofofuru nagang oko ojuro kyamo Urushelima. ");
INSERT INTO khj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kukina ʊnʊng anʊ bi ubyen ʊnʊng asʊ dɔɔ Ʊnʊng ngɛ kǝni ʊsa ija.");
ALTER TABLE khj_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
