﻿USE sofia;
DROP TABLE IF EXISTS sofia.kgpNT_vpl;
CREATE TABLE kgpNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kgpNT_vpl WRITE;
INSERT INTO kgpNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesus Cristo jóg'jóg ve ag rán ke vẽ. Jesus Cristo vỹ tỹ Davi krẽ'krẽ nĩ, kỹ Davi vỹ tỹ Abraão krẽ'krẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraão vỹ Isaque han. Kỹ Isaque vỹ Jacó han. Kỹ Jacó vỹ Judá han, ti mré ke ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Kỹ Judá vỹ Peres han. Zera ti ke gé. Ã prũ tỹ Tamar fi ki tóg ag hyn han, Judá ti. Kỹ Peres vỹ Esrom han. Kỹ Esrom vỹ Arão han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Kỹ Arão vỹ Aminadabe han. Kỹ Aminadabe vỹ Nasom han. Kỹ Nasom vỹ Salmom han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Kỹ Salmom vỹ Boaz han, ã prũ tỹ Raabe fi ki. Kỹ Boaz vỹ Obede han, ã prũ tỹ Rute fi ki. Kỹ Obede vỹ Jessé han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Kỹ Jessé vỹ pã'i mág tỹ Davi ẽn han. Kỹ pã'i mág tỹ Davi vỹ Salomão han, ã prũ ẽn fi ki, ũ tỹ Urias prũ ja nĩ ẽn fi ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Kỹ Salomão vỹ Roboão han. Kỹ Roboão vỹ Abias han. Kỹ Abias vỹ Asa han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Kỹ Asa vỹ Josafá han. Kỹ Josafá vỹ Jorão han. Kỹ Jorão vỹ Uzias han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Kỹ Uzias vỹ Jotão han. Kỹ Jotão vỹ Acaz han. Kỹ Acaz vỹ Ezequias han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kỹ Ezequias vỹ Manassés han. Kỹ Manassés vỹ Amom han. Kỹ Amom vỹ Josias han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Kỹ Josias vỹ Jeconias han, ti jãvy ag ke gé. Israel ag tỹ cidade Babilônia ra mũ ẽn kã tóg ag hyn han, Israel ag tỹ sigse kỹ mũ ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ag tỹ cidade ẽn tá vỹnvỹn ke kar kỹ Jeconias vỹ Salatiel han. Kỹ Salatiel vỹ Zorobabel han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Kỹ Zorobabel vỹ Abiúde han. Kỹ Abiúde vỹ Eliaquim han. Kỹ Eliaquim vỹ Azor han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Kỹ Azor vỹ Sadoque han. Kỹ Sadoque vỹ Aquim han. Kỹ Aquim vỹ Eliúde han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Kỹ Eliúde vỹ Eleazar han. Kỹ Eleazar vỹ Matã han. Kỹ Matã vỹ Jacó han. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kỹ Jacó vỹ José han, Maria fi mén ẽn ti. Maria ẽn fi ki Jesus tóg mur ja nĩ, hã vỹ: Cristo, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hã kỹ ag tóg 14 (ke) nỹtĩ, Abraão krẽ'krẽ ag, Davi mré nĩgkrén kỹ. Kỹ Davi krẽ'krẽ ag tóg 14 (ke) nỹtĩ gé, ag tỹ ag sigse kỹ nỹtĩ tá ag nĩgkrén kỹ, ag tỹ cidade tỹ Babilônia tá sigse kỹ nỹtĩ tá ag nĩgkrén kỹ. Tag pãte ag krẽ'krẽ vỹ 14 (ke) nỹtĩ gé, Cristo mré nĩgkrén kỹ. Cristo jóg'jóg ve ag hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Cristo mur vỹ ge nĩ, ha mẽ. Ti mỹnh fi vỹ tỹ José prũnh ke fi nĩ, hã ra fag tóg ver jagnẽ mré nỹ ja tũ nĩ. Ẽn kã fi tóg kufy nĩ ha. Topẽ kuprĩg tỹ fi mỹ gĩr han jan hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kỹ José tóg mẽg mũ sir, fi tỹ kufy nĩ ti, kỹ tóg ti mỹ e tĩ. Ũn jykré kuryj vẽ mỹr, José ti, hã kỹ tóg fi mỹ'ãg han sór tũ nĩ, kỹ tóg fi to vĩ tũ nĩ sir. Hã ra tóg fi pin kỹ fi mỹ: “kỹ inh hỹn ã tỹ prũ nĩnh ke tũ nĩ ha.” he sór mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ti tỹ ver fi tovãnh to jykrén kỹ Topẽ tỹ jẽnẽ jafã tóg ti mỹ vẽnh ven mũ sir, ti vẽnh péti kỹ. Kỹ tóg ti mỹ: “José,” he mũ. “Tỹ ã Davi krẽ'krẽ ag kã ũ nĩ,” he tóg. “Maria fi to jykrén kónãn tũg nĩ. Jatun mỹ fi tỹ prũg nĩ, fi tovãnh tũg nĩ. Ũ tũ pijé', fi kósin ti. Topẽ kuprĩg tỹ fi mỹ han ja vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ti mur kỹ tóg gré nỹnh mũ, ha vemnĩ. Kỹ ti mỹ: Jesus, hemnĩ. Ã povo krenkren han jé tóg ke mũ, ag tỹ Topẽ vĩ mranh mũ ra,” he tóg, José mỹ, Topẽ tỹ jẽnẽ jafã ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hã ra Topẽ vỹ vãsỹ ã vĩ tó tĩ ũ mỹ tag tó ja nĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ũn mén ja tũ fi vỹ kufy nĩnh mũ,” he ja tóg nĩ. “Fi kósin fi ki mur ken kỹ ag tóg ti to: Emanuel, henh ke mũ,” he ja tóg nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki. Emanuel to ke vẽ, hã vỹ: “Topẽ vỹ ẽg ki rĩr há han mũ,” he mũ, ẽg vĩ ki, hã vỹ: Emanuel, he mũ. José vỹ Topẽ vĩ tag ve ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kỹ José tóg rĩr mũ sir, ti vẽnh péti kar kỹ. Kỹ tóg Topẽ tỹ jẽnẽ jafã ẽn vĩ ki króm mũ sir. Vẽnh prũg han tóg mũ, Maria fi mré. ");
INSERT INTO kgpNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hã ra tóg ver fi mré nỹ tũ nĩgtĩ. Kejẽn fi tóg ã kósin vég mũ. Kỹ José tóg ti jijin kỹ ti mỹ: Jesus, he mũ. Fi tỹ ti ve kar kỹ tóg vãhã fi mré nỹ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Fi tỹ Jesus ve ẽn kã fag tóg cidade tỹ Belém tá nỹtĩ, ga tỹ Judéia tá. Herodes vỹ tỹ pã'i tỹ rei nĩ, fi tỹ ti ve ja ẽn kurã ki. Kỹ kejẽn ũ ag tóg Jerusalém tá junjun mũ. Kuvar há tá ag tóg kãmũ ja nĩ, rã jur ja tá, ãjag jamã tá. Ũn estudo mág han mũ ag vẽ, krĩg to ag tóg estudar he mág han tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ag tỹ Jerusalém tá junjun kỹ ag tóg sir: “ũ tỹ ũri mur mũ vỹ tỹ Israel ag pã'i mág nĩnh mũ,” he mũ. “Ti kri ẽg krĩg vé, ẽg tỹ ẽg jamã tá nỹtĩn kỹ, rã jur ja tá nỹtĩn kỹ. Ẽg tỹ ti venh kãmũ vẽ, ẽg tỹ ti mỹ nén ũ há vin sór vẽ. Ẽg hỹn hẽ tá ti venh ke mũ?” he ag tóg, ũ tỹ kuvar há tá kãmũ mũ ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ag vĩ tag vỹ pã'i tỹ Herodes mỹ e tĩ, kỹ tóg krĩ kufy nĩ sir. Jerusalém tá ke kar ag mỹ tóg e tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kỹ Herodes tóg Topẽ tũ ki rĩr tĩ to pã'i ag jé prẽr mũ sir, Topẽ vĩ to professor ag ke gé. Kỹ tóg ag mỹ: “Cristo hỹn hẽ tá mur ke mũ nẽji?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kỹ ag tóg ti mỹ: “Belém tá ke nẽji, ga tỹ Judéia tá,” he mũ. “Topẽ vĩ tó tĩ ũ vỹ vãsỹ ti to tag rán ja nĩ, ha mẽ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Sĩ ti nĩ, cidade tỹ Belém ti, ga tỹ Judéia tá, he ja tóg nĩ. Ti sĩ nĩ ra tóg cidade mág ag kar kãfór kar nĩ, pã'i mág ẽn tỹ tá mur kenh ke tugrĩn. Pã'i mág ẽn vỹ tỹ ẽg povo tỹ Israel kri pã'i mág jẽnh ke mũ, ũ tỹ Belém tá mur ke mũ ẽn ti, he ja tóg nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki,” he ag tóg, professor ag, Herodes mỹ. “Hã kỹ tóg Belém tá mur ke mũ, Cristo ti,” he ag tóg, professor ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kỹ Herodes tóg vẽnh péju kỹ fóg ẽn ag mré vẽmén mũ sir, ũ tỹ krĩg to estudo mág han mũ ẽn ag mré. Kỹ tóg ag mỹ: “kurã tỹ hẽ ki ãjag krĩg ẽn ve vén?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ag tỹ ti mỹ kurã tó kỹ tóg Belém ra ag jẽgnẽg mũ sir. “Ãjag tỹ tá junjun kỹ ti jãvãnh nĩ,” he tóg. “Vẽnh kar ki ti jẽmẽmnĩ. Ãjag tỹ ti ve kỹ inh mỹ tónh kãmũmnĩ. Kỹ sóg ti venh tĩg sór mũ gé, sỹ ti mỹ nén ũ há nĩm jé,” he tóg, Herodes ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ag tỹ pã'i ẽn vĩ mẽ kar kỹ ag tóg mũ mũ sir, Belém ra. Ag mũ ẽn ki ag tóg krĩg ẽn ve mãn mũ gé sir, ag tỹ rã jur ja tá krĩg vég mũ ẽn. Krĩg ẽn vỹ ag jo tĩ mũ. Ag tỹ Belém tá junjun kỹ krĩg tóg ũn sĩ nĩgja kri hã sa nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ag tỹ krĩg ẽn ve kỹ ag fe tóg mrin ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ĩn kãra ge kỹ ag tóg ũn sĩ ti vég mũ, ti mỹnh fi ke gé. Kỹ ag tóg ti krẽm grĩnhgrĩnh ke mũ, ti mỹ: “tỹ ã Topẽ kósin nĩ,” he jé. Kỹ ag tóg sir ti mỹ ãjag tũ ti vin mũ, ouro ti, ka jẽnjo tỹ incenso ti ke gé, ẽg tỹ ti pũn kỹ ger há han jafã ẽn, kar kỹ ka tỹ mirra jẽnjo ke gé, ẽg tỹ ti pũn kỹ ger há han jafã ũ vẽ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hã ra Topẽ tóg, ag vẽnh péti ki (tóg) ag mỹ: “Herodes mỹ tó tũg nĩ,” he mũ sir. Hã kỹ ag tóg ẽpry ũ jagma mũ mũ, ẽmĩn ũ jagma mũ kỹ ag tóg ãjag jamã ra vỹnvỹn ke mũ sir, rã jur ja ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ag mũ kar kỹ José tóg kejẽn Topẽ tỹ jẽnẽ jafã vég mũ, ti vẽnh péti kỹ. Kỹ Topẽ tỹ jẽnẽ jafã tóg ti mỹ: “nĩ ra,” he mũ. “Ũn sĩ va tĩg, ga tỹ Egito ra, ti mỹnh fi mré. Herodes vỹ ũn sĩ tag tén sór mũ. Hã kỹ vẽnh péju kỹ Egito ra tĩg. Kejẽn sóg ã mỹ: ha vỹn ké, henh ke mũ. Egito tá inh vĩ jãvãnh nĩ,” he tóg, Topẽ tỹ jẽnẽ jafã ti, José mỹ. Ti vẽnh péti kỹ tóg ti mỹ ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kỹ José tóg kuty ẽn kã jẽgnẽ kỹ fag tatĩn tĩ mũ sir, ga tỹ Egito ra, vẽnh péju jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tá tóg nĩ nĩ. Herodes tỹ kejẽn ter kỹ tóg tá vỹn ke mũ. Hã ra ti tĩg ja tag vỹ rán kỹ nĩ gé. Vãsỹ Topẽ tóg ã vĩ tó tĩ ũ mỹ: “tag rán ra,” he ja nĩ, hã vỹ: “ga tỹ Egito ra sóg vẽnh vĩ jẽnẽ, inh kósin tỹ tá vỹn ke jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hã ra Herodes tóg fagrĩnh mỹ fóg ẽn ag jãvãnh ja nĩ, ũn estudo mág han mũ ẽn ag. Vãhã tóg: “ag tỹ inh mỹ tó tũg hỹn,” he mũ. Kỹ ti fe tóg gỹm ke mũ sir. Kỹ tóg ã pã'i ag mỹ: “ha mũ jẽg, Belém ra,” he mũ. “Tá gĩr ag kygrẽn kãn nĩ, ũn gré ag, ũn kri prỹg tỹ 2 anos tá krỹg tũ ẽn ag,” he tóg, ag mỹ. Ag mỹ tóg 2 anos tó, fóg ag tỹ ti mỹ: “1 ano kãfór ti nĩ ha, ẽg tỹ ti kri krĩg ve ja ti,” hen kỹ. Kỹ polícia ag tóg gĩr ag kãgtén mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hã ra tag tóg rán kỹ nĩ gé. Vãsỹ Topẽ vĩ tó tĩ tóg tag rán ja nĩgtĩ, ti jiji hã vỹ: Jeremias, he mũ. Ẽn tóg tag rán ja nĩ, ha mẽ: ");
INSERT INTO kgpNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“cidade tỹ Ramá tá ẽg tóg vẽnh kygfỹ mẽg mũ, vẽsỹrénh mág ke gé. Raquel fi vỹ vẽsỹrénh mũ, fi krẽ ag jé. Ag tỹ fi mỹ: fỹ tũg nĩ, he mũ ra fi tóg vẽsỹrénh mũ. Fi kré ag vỹ tũ' he kãn, hã kỹ fi tóg fỹ mũ, vẽsỹrénh mũ,” he ja tóg nĩ, Jeremias ti. Hã ra tóg tag ri ke nĩ, polícia ag tỹ gĩr ag kygrẽn mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kejẽn Herodes ẽn vỹ ter mũ gé sir, pã'i ti. Kỹ Topẽ tỹ jẽnẽ jafã vỹ José mỹ vẽnh ven mũ, ti vẽnh péti kỹ. Ga tỹ Egito tá tóg ti mỹ venh ven mũ. Tá fag tóg nỹtĩ nĩ, ga tỹ Egito tá. Tá tóg ti mỹ vẽnh ven mũ, José mỹ, Topẽ tỹ jẽnẽ jafã ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Kỹ tóg ti mỹ: “nĩ ra,” he mũ. “Gĩr va tĩg, ti mỹnh fi pére tĩg gé, ga tỹ Israel ra. Ũ tỹ fi kósin tén sór mũ ẽn vỹ hur ter,” he tóg, Topẽ tỹ jẽnẽ jafã ti, José mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kỹ tóg jẽgnẽ kỹ tĩ mũ sir. Gĩr va tóg tĩ mũ, ti mỹnh fi pére tóg tĩ mũ gé. Kỹ fag tóg Israel ag ga ra mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tá jun kỹ tóg pã'i mág tãg jyjy jẽmẽg mũ, José ti. Hã ra tóg tỹ Arquelau nĩ. Ti panh tỹ Herodes ri kén tóg tỹ pã'i tỹ rei nĩ, ga tỹ Judéia tá. Kỹ tóg ti kamẽg mũ. Kỹ Topẽ tóg ti vẽnh péti kỹ ti mỹ: “ga tỹ Judéia tá nĩ mãn sór tũg,” he mũ. Kỹ tóg tĩg mãn kỹ ga tỹ Galiléia ra tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kỹ tóg cidade tỹ Nazaré tá jamãn mũ sir. Hã ra tóg rán kỹ nĩ gé, Nazaré ti. Vãsỹ Topẽ vĩ tó tĩ ũ tóg tag rán ja nĩ gé, kỹ tóg: “ti to ag tóg: Nazaré tá ke vẽ, henh ke mũ,” he ja tóg nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki, Jesus to. Hã ra tóg ge nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kejẽn João tóg ẽmã tũg ja ra tĩ mũ, ga tỹ Judéia tá ga kórég ra. João Batista ẽn vẽ. Ga kórég tá jẽ kỹ tóg ag jyvẽn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Ãjag jykre tovãnh nĩ, ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ãjag pã'i nĩ jé,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","João ẽn to tóg tag rán ja nĩ, vãsỹ Topẽ vĩ tó tĩ ẽn ti, Isaías he mũ ẽn, ha mẽ. “Ẽmã tũg ja tá tóg jẽnh ke mũ, ga kórég tá,” he ja tóg nĩ. “Tá tóg ag mỹ jamã hár(a) ke mũ sir. “Ẽg Senhor kãtĩg ke jo vẽnh jãnhkrigkrig nĩ,” he jé tóg ke mũ. “Ẽpry kurég ãjag tóg tĩ, ẽmĩn kurynh ãjag tóg tĩ gé, ãjag pã'i mág jun ken kỹ. Kỹ tag ri ke han nĩ, ãjag jykre pãno togvãnh nĩ, ẽg Senhor kãtĩg ken jo,” he jé tóg ke mũ,” he ja tóg nĩ, Isaías ti, João to. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jo João ẽn kur tóg tỹ cavalo pãnĩ sór kyki tỹ há nĩ. Nén ũ fár tỹ tóg vẽsógfĩn ja han tĩ gé. Ópã hã ko ti tĩ, mỹg mré hã, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kỹ ag tóg ti tá junjun kãn mũ sir, cidade tỹ Jerusalém tá kãmũ kỹ, ga tỹ Judéia kar tá kãmũ kỹ, goj tỹ Jordão tá ke kar ag ke gé. João tá ag tóg junjun kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kỹ tóg ag kygpég mũ sir, goj tỹ Jordão ki, ag tỹ: “Topẽ vĩ mranh ja sóg nĩgtĩ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kỹ ũ tỹ Fariseu he mũ ag vỹ ti tá junjun mũ gé sir, ũ tỹ Saduceu he mũ ag ke gé, pã'i ag. Ón kỹ ag tóg ti to kãmũ mũ, ti tỹ ag kygpe jé. Kỹ tóg ag jyvẽn tar han mũ sir, João ti. “Pỹn ri ke ãjag tóg nỹtĩ, ãjag jykre pãno tãvĩ nĩn kỹ,” he tóg ag mỹ. “Ũ nỹ ãjag mỹ: “Topẽ jũ venh ke tũ ãjag nĩ,” he tĩ'? ");
INSERT INTO kgpNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ãjag jykre si tovãnh nĩ, ãjag tỹ ti jũ ve jãvãnh tĩn kỹ. Vẽnh jykre há han nĩ, ẽg tỹ ãjag jykre tãg hã ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hã ra ãjag tóg jagnẽ mỹ: “Abraão vỹ tỹ ẽg jóg'jóg ve nĩ, kỹ Topẽ hỹn tóg ẽg to jũnh ke tũ nĩ, ẽg tỹ tỹ Abraão krẽ'krẽ nỹtĩn tugrĩn,” he tĩ. Ke tũ vẽ hã ra. Ãjag jykre kórég ẽn to ãjag tóg jagtar ke mũ, ha vemnĩ. Topẽ vỹ Abraão krẽ'krẽ hyn han ki kanhró nĩ, pó tag tỹ mỹr, ti tỹ Abraão krẽ'krẽ ve sór kỹ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hã ra tóg ãjag tỹ tũ' henh ke mũ, ãjag tỹ ãjag jykre kórég tovãnh tũ nĩn kỹ. Ẽg tỹ ka gỹn ri ke tóg nĩ. Ti kanẽn vãnh kỹ ẽg tóg ti gỹn tĩ, ti tỹ pĩ han jé. Ri ke han jé tóg ke mũ, Topẽ ti, ãjag tỹ vẽnh jykre há han sór tũ nĩn kỹ. Kỹ tóg pĩ ki ãjag vãm ke mũ, Topẽ ti,” he tóg ag mỹ, João ti, Fariseu ag mỹ, Saduceu ag mỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kỹ João tóg vẽnh kar mỹ: “goj hã tỹ sóg ãjag kygpég tĩ, ãjag tỹ ãjag jykre tovãnh kỹ,” he mũ. “Inh nón tóg kãtĩg mũ hã ra, Cristo ti. Inh kãfór ti nĩ. Tỹ sóg ti camarada nĩ jãvãnh nĩ, sỹ tỹ ti krẽm ke pẽ jẽn kỹ. Ẽg camarada ag vỹ ẽg pẽn né gé mũgtĩ, ẽg pẽn to ró ti. Sỹ ti mỹ gé tĩg ke vẽ vẽ, hã ra sóg tỹ ti krẽm ke pẽ nĩ, ti tỹ inh kãfór nĩn kỹ. Ẽn hã tóg Topẽ kuprĩg tỹ ãjag jagrẽ han ke mũ. Kỹ tóg tỹ pĩ nĩ ve nĩ. Ti tỹ ãjag kygpenh ken hã vẽ,” he tóg, João ti, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Ti kãtĩg vỹ ẽg tỹ rãgró rẽn ri ke nĩ. Ti rẽn kar kỹ ẽg tóg ti fár pũn tĩ. Ti kanẽ hã vin han ẽg tóg tĩ. Cristo kãtĩg ken kỹ tóg ge nĩnh mũ. Ti to há nỹtĩ ag mỹ tóg: “ha kãmũ jẽg,” henh ke mũ. Ti to há nỹtĩ tũ ag vãm jé tóg ke mũ, pĩ ki, hã ra tóg nhyn kenh ke tũ pẽ nĩ,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ẽn kã kejẽn Jesus tóg João tá jun mũ gé sir, goj tỹ Jordão tá. Ga tỹ Galiléia tá tóg kãtĩ mũ. Kỹ tóg João mỹ: “ha inh kypé gé,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hã ra tóg João mỹ e tĩ, kỹ tóg ti mỹ: “ã hã tỹ inh kypenh ke vẽ vẽ,” he mũ. “Inh mỹ tóg e tĩ, ã tỹ inh mỹ: ha inh kypé, hen kỹ,” he tóg mũ, João ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Hã ra Jesus tóg ti mỹ: “hỹ,” he mũ. Hã ra tóg isỹ vẽnh jykre kuryj han kãn há tĩ,” he tóg, João mỹ. Kỹ tóg ti kypég mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ti tỹ Jesus kype kar kỹ ag tóg goj kãtá kãpa mũ sir. Kỹ Jesus tóg kanhkã nor nĩ ẽn vég mũ, ha mẽ, kỹ tóg Topẽ kuprĩg kãtére ẽn vég mũ. Sórãg ri ke tóg nĩ, ti kãtére ti. Jesus kri tóg kãtére mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kỹ vẽnh vĩ tóg mẽ há tĩ, kanhkã tá, kỹ tóg: “inh kósin pir vẽgtĩ,” he mũ. “Inh fe pẽ vẽgtĩ,” he tóg, ũ tỹ kanhkã tá vĩ mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kỹ Topẽ kuprĩg vỹ Jesus mỹ: “ẽmã tũgja ra tĩg,” he mũ. Kỹ tóg tĩ mũ. Ẽmã tũgja tá nĩn kỹ Japo vỹ ti tỹ ã jóg vĩ mranh han sór mũ, hã ra Jesus tóg ke jãvãnh nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kurã tỹ 40 (ke) han tóg, ẽmã tũgja tá nĩn ki. Kỹ tóg jẽg tũ nĩ, kurã tỹ 40 (ke) ẽn ki, kuty mré ke gé. Kar kỹ tóg sir kókĩr mũ, vẽjẽn tũ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kỹ Japo tóg ti to kãtĩ mũ sir, ũ tỹ ẽg tỹ Topẽ vĩ mranh han sór mũ ẽn ti. Kỹ tóg Jesus mỹ: “Topẽ kósin vỹ tỹ ã nĩ,” he mũ. “Ã tỹ tỹ Topẽ kósin nĩn kỹ pó tag tỹ ẽmĩ han, ã tỹ kon jé,” he tóg ti mỹ, Nén-Kórég ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kỹ Jesus tóg ti mỹ: “hã ra tag tóg rán kỹ nĩ, ha mẽ,” he mũ. “Ẽg pi(jé) ẽmĩ tãvĩ jamẽn kỹ rĩnrĩr mũgtĩ', hã ra ẽg tóg Topẽ vĩ hã jamẽn kỹ rĩnrĩr mũgtĩ, he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki. Kỹ tóg isỹ ti vĩ mranh jãvãnh tĩ, ẽmĩ to,” he tóg, Jesus ti, Nén-Kórég mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kỹ Japo vỹ ti pére tĩ mũ, Jerusalém ra, cidade mág ẽn ra. Tá ag tóg Topẽ jo ĩn kri nỹtĩnh mũ mũ. Hã ra kãgnó tóg tá nĩ, Topẽ jo ĩn mã tá. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kỹ Japo tóg Jesus mỹ: “ã hã ne tóg tỹ Topẽ kósin nĩ',” he mũ. “Ha kema ki hũm,” he tóg. “Topẽ vĩ ki tag tóg rán kỹ nĩ, hã vỹ: ã tỹ jẽgnẽ jafã ag mỹ tóg tónh mũ, Topẽ ti, kỹ ag tóg ã jy nĩgãn mũ, he mũ. Kỹ ã tóg rỹj ke tũ nĩ. Ã pẽn vỹ rỹj ke tũ nĩ, ag tỹ ã ki rĩr kỹ, he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki. Kỹ ki kema hũm,” he tóg, Japo ti. “Rỹj ke tũ ã nĩ ã tỹ tỹ Topẽ kósin nĩn kỹ,” he tóg, Nén-Kórég ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kỹ Jesus tóg ti mỹ: “kỹ tag vỹ rán kỹ nĩ gé, ha mẽ,” he mũ. “Topẽ mỹ: ã mỹ ã tỹ tó ja ẽn han mũ vỹ? he tũg nĩ, he tóg mũ gé, Topẽ vĩ tỹ rán kỹ nĩ ki. Hã kỹ sóg ti tỹ inh mỹ nén to: “han ra,” he mũ ẽn hã han tĩ, kỹ sóg hũm ke tũ nĩ,” he tóg, Jesus ti, Nén-Kórég mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kỹ Japo tóg ti mré tĩg mãn mũ. Pãnónh téj ra ag tóg mũ mũ sir. Kỹ Japo tóg ti mỹ ga kar ven kãn mũ, ga kri mũ kar ag ke gé. Ti sĩnvĩ kar ẽn ven tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kỹ tóg ti mỹ ke mũ. “Isũ vẽ, tag kar ti,” he tóg. “Hã ra sóg ã mỹ tovãnh kãn sór mũ, ã tỹ ã jakrĩ tỹ krỹ' hen kỹ, inh krẽm, inh mỹ: Topẽ vỹ tỹ ã nĩ, he jé,” he tóg, Nén-Kórég ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kỹ Jesus tóg ti mỹ: “ha tĩg, Satanás,” he mũ. “Ẽg pã'i tỹ Topẽ hã krẽm ẽg tóg ẽg jakrĩ tỹ krỹ' he tĩ, ti hã to ẽg tóg: Topẽ vẽ, he tĩ, hã kỹ tóg rán kỹ nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki,” he tóg, Jesus ti, Nén-Kórég mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kỹ Japo vỹ tóg sir tĩ mũ, ti tovãnh kỹ. Kỹ Topẽ tỹ jẽgnẽ jafã ag tóg sir ti tá junjun mũ, Jesus ki rĩr jé. Ã jóg vĩ mranh ja tũ tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kejẽn ag tóg João ség mũ sir, kỹ Jesus tóg mẽg mũ, ag tỹ ti se ti. Kỹ tóg ga tỹ Galiléia ra tĩ mũ, vẽnh péju jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Cidade tỹ Nazaré tá kãkutẽ kỹ tóg cidade tỹ Cafarnaum ra tĩ mũ, tá nĩ jé, goj nig tá, Zebulom ag jamã tá, Naftali ag jamã tá. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hã ra tag tóg rán kỹ nĩ gé. Vãsỹ Topẽ vĩ tó tĩ tóg tag rán ja nĩ, Isaías ti, kỹ tóg: ");
INSERT INTO kgpNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulom ag jamã tá ti nĩnh mũ, Naftali ag jamã tá, goj nig tá, goj tỹ Jordão mã tá. Fóg ag jamã tá ti nĩnh mũ, Israel tũ ag jamã tá, ũ tỹ Topẽ ki kagtĩg ag jamã tá, goj nig tỹ Galiléia fyr ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tá ag tóg Topẽ ki kagtĩg nỹtĩ, hã kỹ tóg tá ag kri kuty ri ke nĩ. Ti tỹ tá jun kỹ tóg ag kri kurãg ẽn ri ke han mũ, ag kanhrãn kỹ. Ag kãgter ke vẽ vẽ, hã ra tóg ag kanhrãn mũ ag krenkren jé,” he tóg, Topẽ vĩ rán ki. Kỹ tóg ge nĩ, Jesus tỹ tá nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ga ẽn tá nĩ kỹ tóg ag jyvẽn mũ, kỹ tóg ag mỹ: “ãjag jykre si tovãnh ra,” he mũ, “ãjag tỹ ũri ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ ve jé,” he tóg, Jesus ti. Ti tỹ ũ tỹ ki kagtĩg ag mỹ Topẽ vĩ tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kỹ tóg kejẽn goj nig tỹ Galiléia ẽn fyr jagma tĩ mũ. Kỹ tóg tá ũn régre ag vég mũ. Ũ vỹ tỹ Simão nĩ, ag tỹ ũ to: Pedro, he mũ tag ti. Kỹ ti jãvy vỹ tỹ André nĩ. Kur tỹ pirã kugmĩ jafã tỹ ag tóg goj kãki fón mũ, pirã kugmĩ jé. Ag rãnhrãj vẽ, pirã kugmĩg tĩ ag vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kỹ Jesus tóg ag ve kỹ (tóg) ag to tĩ mũ sir. Kỹ tóg ag mré vĩ mũ. “Inh mré kãmũjẽg,” he tóg mũ ag mỹ. “Pirã kugmĩ há ãjag nỹtĩ. Ãjag kanhrãn jé sóg ke mũ, ãjag tỹ ẽprã ke ag tỹ inh ki ge han jé,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kỹ ag tóg vẽsỹmér ãjag tỹ nén tovãnh kỹ mũ mũ, ti mré, Pedro ti, André ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kỹ ag tóg mũ mũ, goj fyr jagma. Ag mũ sĩ han mũ ra Jesus tóg ũn régre ũ ag ve mãn mũ gé. Tỹ ti Tiago nĩ, Zebedeu kósin, kỹ ti jãvy vỹ tỹ João nĩ gé. Canoa kãki ag nỹtĩ, kur tỹ pirã kugmĩ jafã ki ag tóg han nỹtĩ nĩ. Ag panh vỹ ag mré nĩ nĩ. Kỹ Jesus tóg ag jé prẽr mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kỹ ag tóg vẽsỹmér (ag tóg) ãjag tỹ nén tovãnh kỹ ti to kãmũ mũ, canoa tovãnh kỹ, ãjag panh ti tovãnh kỹ ke gé. Jesus mré ag tóg mũ mũ, Tiago ti, ti jãvy tỹ João ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kỹ Jesus tóg ga tỹ Galiléia kar mĩ tĩ mũ sir, ag mré. Judeu ag vẽnh kanhrãn jafã krẽm tóg ag kanhrãn mũ. Ag mỹ tóg Topẽ vĩ sér tó mũ, ũ tỹ kanhkã tá nĩ tỹ tỹ ẽg pã'i nĩ tĩ. Ũn kagyga kar ag hyn han tóg, fag kar ke gé, gĩr kar ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hã kỹ ti kãme tóg vẽnh kar kri rũm mũ sir, ga tỹ Síria tá ke kar kri. Kỹ ag tóg sir ũn kagyga ag tatĩn kãmũ mũ, ti to, vẽnh kaga vẽnhmỹ han mũ ag mré hã, kỹ tóg ag tỹ há' he kãn mũ sir. Vẽnh jagrẽ kórég ag pan kãn tóg mũ gé. Ũ tỹ ter tĩ han mũ ag tỹ hághá' he tóg mũ gé, ũn grĩngrĩn kỹ nỹtĩ ag tỹ ke gé, fag kar tỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hã kỹ ũn tỹ hẽn ri ke ag tóg ti mré mũ mũ sir. Ũ ag tóg ga tỹ Galiléia tá kãmũ mũ, kỹ ũ ag tóg cidade tỹ Decápolis tá kãmũ mũ gé, cidade tỹ Jerusalém tá ke gé, ga tỹ Judéia tá ke gé, goj tỹ Jordão mã tá ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ũn e ag tỹ Jesus venh kãmũ kỹ tóg ag mré pãnónh ra tãpry mũ. Tá tóg nĩ mũ, kỹ ti mré mũ tĩ ag tóg ti mré nĩgnĩ mũ, ti rã hã. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kỹ tóg sir ag kanhrãn mũ, ag mỹ kãmén kỹ. Kỹ tóg ag mỹ tag tó mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Topẽ vỹ ãjag ve há han mũ, ãjag tỹ: kórég inh nĩ, hen kỹ. Sỹ Topẽ kuprĩg tỹ jagrẽn kỹ nĩ tũ nĩ ra sóg tỹ ũn kórég nĩnh mũ vẽ, hemnĩ. Kỹ Topẽ vỹ ãjag ve há han mũ. Kỹ ãjag tóg ti tỹ tỹ ẽg pã'i nĩ venh ke mũ, kanhkã tá,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Topẽ vỹ ãjag ve há han mũ, ãjag fỹn kỹ. Kỹ tóg ãjag fỹ ẽn tỹ tũ' henh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Topẽ vỹ ãjag ve há han mũ, ãjag tỹ vẽnh kar mỹ komẽr hã vĩn kỹ. Kỹ ãjag tóg ga kar kri tỹ pã'i nỹtĩnh ke mũ, ũn mág pẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Topẽ vỹ ãjag ve há han mũ, ãjag tỹ vẽnh jykre kuryj ve sór nỹtĩn kỹ, ti tỹ ãjag mỹ ãjag kókĩr ri ke tĩn kỹ, ãjag tỹ vẽnh jykre kuryj ve sór nĩn kỹ. Kỹ ãjag tóg venh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Topẽ vỹ ãjag ve há han mũ, ãjag tỹ jagnẽ jagãgtãn kỹ. Kỹ Topẽ vỹ ãjag jagãgtãn ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Topẽ vỹ ãjag ve há han mũ, ãjag jãnhkri nỹtĩn kỹ. Kỹ ãjag tóg Topẽ venh mũ, ãjag jãnhkri nỹtĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Topẽ vỹ ãjag ve há han mũ, ãjag tỹ jagnẽ krĩ tỹ kãnhvy' hen kỹ. Kỹ Topẽ tóg ãjag to: “inh krẽ ag vẽ,” henh ke mũ, ãjag tỹ jagnẽ krĩ tỹ kãnhvy' hen kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Topẽ vỹ ãjag ve há han mũ, ag tỹ vẽnh jykre kuryj to ãjag vóg kónãn mũ ra. Topẽ vỹ tỹ kanhkã tá ãjag pã'i nĩnh mũ, ag tỹ ti tugrĩn ãjag vóg kónãn mũ ra,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Topẽ vỹ ãjag ve há han mũ, ag tỹ isugrĩn ãjag mỹ vĩ kónãn mũ ra, ag tỹ ãjag vóg kónãn mũ ra. Ag tỹ ón kỹ ãjag to vĩ vĩ he kỹ tóg há tĩ, ag tỹ ón kỹ ãjag jykre pãno tó mũ ra, isugrĩn. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mỹ sér nỹtĩmnĩ, ãjag fe tỹ há' hemnĩ, ag tỹ ón kỹ ãjag kato vĩn kỹ. Kanhkã tá ãjag tóg nén kar há venh ke mũ, vẽnh kato. Ge ja ag tóg nĩgtĩ vãsỹ, Topẽ vĩ tó tĩ ag mỹ, ãjag jo ke ag mỹ. Ag ri kén ãjag tóg tag venh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sa ri ke ãjag nỹtĩ, ãjag tỹ ga kri mũn kỹ. Sa kãhór nĩn kỹ ẽg tóg ti tỹ sa há han mãn ki kagtĩg nỹtĩ. Kórég ti nĩgtĩ, ti kãhór nĩn kỹ. Kỹ ẽg tóg ti vãm tĩ sir, kỹ tóg tũ' he tĩ sir,” he tóg, Jesus ti. Ti tỹ ẽg tỹ ti jykre tovãnh ke tũ kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ga kri mũn kỹ ãjag tóg jẽngrẽ ri ke nỹtĩ, ãjag tỹ vẽnh jykre há han kỹ, ag tỹ ãjag ki ve jé, Topẽ jykre há ti. Cidade mág vỹ ve há tĩgtĩ, kuvar há tá jẽ kỹ, ti tỹ pãnónh kri nỹn kỹ. Ti pi(jé) vẽnh péju kỹ nỹ'. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ri ke ti nĩ, néj gru ti. Ẽg tỹ ti grug kỹ ẽg pi(jé) lata krẽm ti fẽg tĩ'. Ti fẽg jafã kri ẽg tóg ti fẽg tĩ. Kỹ vẽnh kar tóg ẽn vég tĩ sir, ĩn kãtá nỹtĩ kar ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gemnĩ, néj gru ri ke nỹtĩmnĩ. Topẽ jykre han nĩ, vẽnh kar tỹ ãjag ki ve jé, ãjag jykre há ti. Hã kỹ ag tóg ẽg jóg tỹ Topẽ mỹ vĩ há han mũ, ẽg jóg tỹ kanhkã tá nĩ ẽn mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ãjag hỹn iso: ti hã ne tóg Moisés tỹ ẽg mỹ nén tó ja tỹ tũ' he sór mũ', he mũ, ti hã ne tóg Topẽ jykre ẽn tỹ tũ' he sór mũ', he ãjag hỹn tĩ. Vãsỹ Topẽ vĩ tó tĩ ag vỹ ẽg mỹ tó ja nĩgtĩ, Topẽ jykre ẽn ti, hã ra tóg tỹ tũ' he sór mũ', he ãjag hỹn tĩ iso. Hã tũ vẽ. Sỹ ki króm kãn sór vẽ, Moisés tỹ nén tó ja ẽn ki, sỹ ki króm kỹ sóg tỹ ãjag kanhrãnrãn kãn ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Topẽ vỹ ã jykre ẽn tỹ tũ' henh ke tũ nĩ, ha mẽ. Ga tỹ ver kanhkã mré nỹn kỹ tóg ã jykre tỹ tũ' henh ke tũ nĩ, ga tỹ ver tũ' he tũ nĩn kỹ. Sỹ ki króm kãn ke vẽ, kỹ tóg ki krov kãn kỹ nỹnh mũ, Topẽ jykre kar ti mỹr, ha mẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Kỹ ãjag tỹ tỹ tũ' he sór kỹ tóg kórég nỹ, ãjag tỹ ti vĩ pir tỹ tũ' he sór kỹ. Ãjag tỹ ti vĩ pir to ũ mỹ: han tũg nĩ, hen kỹ ãjag tóg tỹ ũn kãsir nỹtĩnh mũ, vẽnh kar krẽm, kanhkã ki. Ãjag tỹ hã ra han kãn kỹ ãjag tóg tỹ ũn mág nỹtĩnh mũ, ãjag tỹ vẽnh kar mỹ: “ki króm kãn sórmnĩ,” hen kỹ. Kỹ ãjag tóg tỹ ũn mág nỹtĩnh mũ, kanhkã tá,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Fariseu ag ri ke nỹtĩ sór tũg nĩ. Topẽ vĩ to professor ag ri ke nỹtĩ sór tũg nĩ gé. Ón kỹ ag tóg Topẽ vĩ ki króm tĩ, hã ra ag tóg ki króm há han tũ nĩgtĩ. Ag jykre pi(jé) kuryj nỹ'. Ãjag tỹ kanhkã ve sór nỹtĩn kỹ vẽnh jykre kuryj han nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Topẽ tỹ vãsỹ ẽg si ag jyvẽn mẽ ãjag huri, hã vỹ: ũ tén tũg nĩ, he mũ. Ã tỹ ũ tén kỹ ag tóg ã senh ke mũ, ã tỹ ti mré ter jé, he ja tóg nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sỹ ũri ãjag jyvẽn hã vẽ, ha mẽ. Ã régre to ã fe tỹ gỹm ke tũg nĩ. Ã tỹ ã régre to ã fe tỹ gỹm ke kỹ tóg ã tỹ ti tén ri ke nĩ. Kỹ tóg inh mỹ há tĩnh mũ, ag tỹ tag to ã se kỹ. Kỹ ã régre mỹ vĩ kónãn tũg nĩ gé. Ã tỹ ã régre mỹ vĩ kónãn kỹ tóg inh mỹ há tĩnh mũ, ag tỹ tag to pã'i mág mỹ ã ven kỹ. Kỹ ã régre mỹ féfén tũg nĩ gé. Ã tỹ ã régre mỹ féfén kỹ ã tóg nũgme ki kutẽnh ke mũ, inferno ki, pĩ ẽn ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Tag to jykrén nĩ, ã tỹ Topẽ mỹ nén ũ pũn sór kỹ. Topẽ jo ĩn krẽm. Ã tỹ tá jẽn kỹ ã régre kar mĩ ẽkrén nĩ. “Ũ mỹ iso jykrén kónãn tũ nĩ vỹ?” he jé ã tóg ke mũ. “Inh mỹ ũ jũ han tũ nĩ vỹ?” he jé ã tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ũ tỹ ã to jykrén kónãn kỹ ti venh tĩg nĩ ver, Topẽ mỹ nén ũ pũn tovãnh nĩ ver. Ã régre ẽn mỹ: “inh mỹ vẽnh pãte fón nĩ,” hemnĩ ver. Kar kỹ Topẽ mỹ nén ũ pũn sórmnĩ sir, ã tỹ ã régre mré vĩ kar kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Kejẽn ã tóg ã mré ke ũ mỹ név(e) jẽ, kỹ tóg pã'i ag mỹ ã kãmén tĩg ke mũ. Ti tỹ pã'i ag mỹ tónh tĩg ke mũ ẽn ti to hã ti mré vĩmnĩ, ti mỹ: “kajãm jé sóg ke mũ,” hemnĩ. Ke tũ nĩ (mũ) ra pã'i vỹ ã jykre pãno venh ke mũ, kỹ tóg polícia mỹ: “ti se ra,” henh ke mũ sir, kỹ tóg sir ã senh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ha mẽ, ki hã sóg tó mũ. Tá ã kãnhmar kãkutẽ mãn ke tũ nĩ. Ã tỹ kajãm kãn kar ã tóg kãkutẽ mãn mũ, tá, hẽn ri ke mũn,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Topẽ tỹ ẽg si ag jyvẽn ũ tag mẽ ãjag huri, ke gé, hã vỹ: “ã prũ tũ fi mré nỹ tũg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sỹ ũri ãjag jyvẽn hã vẽ, ha mẽ: ã tỹ ũn tỹtá ũ fi ki vẽ'ĩ kỹ tóg ã tỹ fi mré nỹ sỹ han ẽn ri ke nĩ sir, ã tỹ fi ki vẽ' ĩ mũ ti. Ã tỹ ũn tỹtá ũ fi mrẽ nũr sór kỹ tóg ã tỹ fi mrẽ nũr ri ke nĩ sir, ã tỹ fi to én mũ ti. Ke tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ã tỹ nén ũ ki vẽ'ĩ tugrĩn Topẽ vĩ mranh kỹ ã kanẽ tỹ nám kemnĩ, ã tỹ ki vẽ'ĩ jagy han mãn tũ nĩ jé. Ã kyvó nĩn kỹ tóg jagy tĩ gé vẽ vẽ. Ã tỹ hã ra nũgme ki kutẽ kỹ tóg jagy kãfór nĩ. Jagy pẽ ti nĩ, ã tỹ inferno ki kutẽ ti. Kỹ tag hã ve sór tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ã tỹ ã nĩgé tỹ nén ũ kórég han kỹ ã nĩgnó kym nĩ, ã tỹ ke mãn tũ nĩ jé. Ã nĩgnó pir nĩn kỹ tóg jagy tĩ gé. Ã tỹ hã ra nũgme ki kutẽ kỹ tóg jagy kãfór nĩ sir, kỹ tag hã kamẽg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Tope tỹ ẽg si ag jyvẽn ũ hã vỹ nỹ gé, hã vỹ: “ã tỹ ã prũ fi fón sór nĩn kỹ tóg há tũ nỹ,” he mũ. “Ã tỹ ge ra fi fón sór nĩn kỹ fi mỹ vẽnh rán kỹ nĩm nĩ, fi tỹ vẽnh rán ma tĩg jé,” he ja tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sỹ ũri ãjag jyvẽn hã vẽ, ha mẽ: ãjag prũ fón tũg nĩ. Ã tỹ fi fón kỹ fi tỹ ũ mré nỹ mãn kỹ fi tóg ã tugrĩn Topẽ vĩ mranh mũ sir, ã tỹ tỹ fi mén pẽ ra. Fi tỹ ã jãvo vẽsóg ki ũ mré nỹ ja nĩn kỹ tóg há sĩ nỹ, ã tỹ fi mỹ: ha tĩg, hen kỹ. Kỹ fi mén tỹ fi fón kỹ fi tỹ prũg sór tũg nĩ gé. Ã prũ tũ fi vẽ, fi mén tỹ fi fón ja nĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Vãsỹ Topẽ tỹ ẽg si ag jyvẽn ũ tag mẽ ãjag tóg huri ke gé, hã vỹ: “jagnẽ mỹ ón tũg nĩ,” he mũ. “Ã tỹ ũ mỹ: Topẽ vỹ ki kanhró nĩ, hen kỹ ti mỹ ón sór tũg nĩ. Kỹ hã han nĩ gé, ã tỹ Topẽ mỹ: tag hã han jé sóg ke mũ, hen kỹ. Ón kỹ vĩ tũg nĩ,” he ja tóg nĩ, ẽg si ag mỹ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sỹ ũri ãjag jyvẽn hã vẽ, ha mẽ: “Topẽ vỹ ki kanhró nĩ,” he sór tũg nĩ, ón kỹ. “Ũ tỹ kanhkã tá nĩ ẽn vỹ ki kanhró nĩ,” he sór tũg nĩ gé, ón kỹ. Topẽ nĩgja vẽ, kanhkã tá, kỹ ón kỹ tag tó sór tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kỹ: “ũ tỹ ga kri ke ẽn vỹ ki kanhró nĩ,” he tũg nĩ gé. Topẽ tũ vẽ, ga ti, hã kỹ ón kỹ tag tó sór tũg nĩ. Kỹ: “ũ tỹ Jerusalém tá ke ag ki rĩr tĩ ẽn vỹ ki kanhró nĩ,” he tũg nĩ gé. Ẽg pã'i mág tũ vẽ mỹr, Jerusalém ti, hã kỹ ón kỹ tag tó sór tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kỹ: “ũ tỹ inh krĩ han mũ ẽn vỹ ki kanhró nĩ,” he tũg nĩ gé. Ã tỹ ã gãnh kuprig sór mũ ra ã tóg ã tỹ nén tỹ ã gãnh kuprig ke mũ ẽn ki kagtĩg nĩ, ã tỹ ã gãnh sán sór mũ ra ã tóg ã tỹ nén tỹ sán ke mũ ẽn ki kagtĩg nĩ gé. Hã kỹ ón kỹ tag tó sór tũg nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ki hã tómnĩ, jagnẽ mỹ, ón sór tũg nĩ. Ón kỹ Topẽ jiji tó sór tũg nĩ gé. Ũ tỹ ã mỹ ki hã tó kỹ: hỹ, hemnĩ. Ti tỹ ki hã ke tũ nĩn kỹ: vó, hemnĩ gé. Ã tỹ han ke nĩn kỹ: hej, hemnĩ. Ã tỹ han ke tũ nĩn kỹ: nejé, hemnĩ. Ki hã tómnĩ, jagnẽ mỹ. Ã tỹ ón sór kỹ ã tóg Nén-Kórég jykre hã han ke mũ. Ke tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Topẽ tỹ ẽg si ag jyvẽn ũ tag mẽ ãjag huri, hã vỹ: “ũ tỹ ã kanẽ pir ki tãnh kỹ vẽnh kato ti kanẽ pir ũ ki tãnh nĩ gé,” he ja tóg nĩ. “Ũ tỹ ã jã pir ki tãnh kỹ mranh kỹ vẽnh kato ti jã pir ki tãnh kỹ mranh nĩ gé. Pãtén tũg nĩ,” he ja tóg nĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sỹ ũri ãjag jyvẽn mũn hã vẽ, ha mẽ: ũ tỹ ã vóg mũ ra ti vóg tũg nĩ. Ti tỹ ã jamẽ ki tãnh kỹ ti mỹ ã jamẽ ũ ti ven nĩ, ti tỹ ã mỹ ki tãnh jé gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ti tỹ ã palitó mãn sór kỹ ti mỹ ã camisa mré nĩm nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ti tỹ ã mỹ: “mũ nỹ, tag tá, kakó ja tá inh fón nĩ,” hen kỹ ti mré tĩg nĩ, hã ra ti mỹ: “kór há tá inh ã fón tĩg mũ ha,” hemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ti tỹ ã mỹ nén ũ to: “inh mỹ nĩm,” hen kỹ ti mỹ nĩm nĩ. Ti tỹ ã mỹ: “inh mỹ prestar hemnĩ,” hen kỹ ti mỹ: vó, he tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Topẽ tỹ ẽg si ag jyvẽn ũ mẽ ãjag huri, hã vỹ: “ã mré ke ag to há nĩmnĩ, kỹ ũ tỹ ã kato vãsãnsãn mũ ag to jũ nĩmnĩ gé,” he ja tóg nĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Isỹ ũri ãjag jyvẽn hã vẽ, ha mẽ: ũ tỹ ãjag kato vãsãnsãn mũ ag to há nỹtĩmnĩ, ũ tỹ ãjag vóg kónãn mũ ag to Topẽ mré vĩmnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hã ki ãjag tóg tỹ Topẽ krẽ nỹtĩ, ti ri ke han kỹ, ãjag jóg tỹ kanhkã tá nĩ ẽn ri ke han kỹ. Ti hã ne tóg rã han', ti tỹ vẽnh kar kri jẽngrẽg kỹ san jé, ũn jykre kuryj ag kri, ũn jykre pãno ag kri ke gé. Ta han ti ke gé, ti tỹ vẽnh kar há han jé, ũn jykre kuryj ag, ũn jykre pãno ag ke gé. Ver tóg vẽnh kar to há nĩ, Topẽ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Ãjag mré ke ũ ag tóg ãjag to há nỹtĩ. Ãjag tỹ tag ag hã to há nỹtĩn kỹ tóg tỹ nén ũ tũ tĩ ver. Ũn jykre kórég ag vỹ ge nỹtĩgtĩ gé, governo mỹ jãnkamy mãg tĩ ag. Ũ tỹ ãjag to há nỹtĩ ag hã to ag tóg há nỹtĩ, vẽnh kato. Há ti nĩ, hã ra tóg tỹ nén ũ tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kỹ ãjag tỹ ãjag mré ke ag hã mỹ: ã mỹ há? hen kỹ tóg tỹ nén ũ tũ nĩ gé ver. Ũ tỹ Topẽ vĩ ki kagtĩg ag vỹ ge nỹtĩgtĩ gé. Ãjag mré ke ag hã mỹ ag tóg: ã mỹ há? he tĩ gé, hã ra tóg tỹ nén ũ tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Hã kỹ vẽnh kar to vẽnh jykre kuryj han kỹ nỹtĩmnĩ, ũ tỹ ãjag kato vãsãnsãn mũ ag mré hã, ẽg jóg tỹ kanhkã tá nĩ ẽn ri ke han nĩ. Ti hã ne tóg vẽnh kar to vẽnh jykre kuryj han kỹ nĩ nĩ'. Ti ri ke han nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Kỹ ãjag tỹ Topẽ jykre han sór kỹ ũ tỹ vẽnh jykre pãno han mũ ag jykre ri ke han tũg nĩ. Ón kỹ ag tóg vẽnh kar rĩnve Topẽ jykre han sór tĩ, vẽnh kar tỹ ag ve jé, ag tỹ Topẽ jykre han mũ ẽn ti. Kar kỹ ag tóg hã ra hã tũ han tĩ sir. Kỹ ag ri ke han tũg nĩ, ke tũ nĩ (mũ) ra ẽg jóg tỹ kanhkã tá nĩ ẽn vỹ tóg ãjag mỹ ven ke tũ nĩ, ãjag tỹ ẽg jóg jykre han mũ ẽn kaja ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Hã kỹ ãjag tỹ ũn jagãgtar ag jagãgtãn kỹ ũ mỹ: “ag jagãgtãn inh tĩ,” he tũg nĩ. Ũ tỹ vẽnh jykre régre han mũ ag jykre ri ke han tũg nĩ. Ag tỹ ón kỹ ũ jagãgtãn kỹ ag tóg ẽpry jagma mũ kỹ (ag tóg) vẽnh kar mỹ: “ag jagãgtãn inh tĩ,” he tĩ. Ẽg vẽnh kanhrãn jafã jo ĩn krẽm ag tóg tag tó tĩ gé. Ag tỹ ẽprã ke ag tỹ ag mỹ vĩ há han ve sór vẽ, hã jé ag tóg ón kỹ ũn jagtar ag jagãgtãn tĩ. Ag ganho hã vẽ, ẽprã ke ag tỹ ag mỹ vẽnh vĩ há tó mũ ẽn ti. Kanhkã tá ag ganho ũ ve mãn ke tũ nĩ ha. Ãjag mỹ sóg ki hã tó mũ, ha mẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Ag ri ke han tũg nĩ. Ũn jagtar ag jagãgtãn nĩ. Ũ mỹ tó tũg nĩ, ãjag tỹ ũn jagãgtãn mũ ẽn ti, ãjag mré ke fag mỹ tó tũg nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kỹ ãjag tỹ ag jagãgtãn kỹ ẽg jóg tỹ kanhkã tá nĩ ẽn tóg ãjag vég mũ sir, kỹ tóg ãjag mỹ nĩm ke mũ sir, ãjag ganho ti. Ẽg tỹ vẽnh vatánh tá nén han mũ ẽn ve kãn tóg tĩ (mỹr), Topẽ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kỹ ãjag tỹ Topẽ mré vẽmén kỹ ũ tỹ vẽnh jykre régre han mũ ẽn ag jykre ri ke han tũg nĩ gé. Ag tỹ ón kỹ Topẽ mré vĩ kỹ ag tóg ẽg vẽnh kanhrãn jafã jo ĩn kãki jẽgjẽ kỹ nỹtĩ, ke tũ nĩ kỹ ẽmĩn kri, ĩn to hã. Kỹ vẽnh kar vỹ ag tỹ Topẽ mré vĩ mũ tag vég mũ sir. Kanhkã tá ag tóg ganho ũ ve mãn ke tũ nĩ ha. Ãjag mỹ sóg ki hã tó mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ag jãvo ãjag tỹ Topẽ mré vẽmén kỹ ãjag ĩn kãra gemnĩ. Kỹ jãnkã nĩfénh nĩ. Kỹ tá Topẽ mré vĩmnĩ sir, ẽg jóg mré, ẽg tỹ ũn vég tũ ẽn mré. Kỹ tóg kanhkã tá ãjag mỹ nĩm ke mũ, ãjag ganho ti. Ẽg tỹ vẽnh vatánh tá nén han mũ ẽn vég tóg tĩ (mỹr), Topẽ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ãjag tỹ ti mré vẽmén kỹ fagrĩnh mỹ ti mré vẽmén mág han tũg nĩ. Ũ tỹ Topẽ vĩ ki kagtĩg ag ri ke han tũg nĩ. Ãjag jãnjãn kỹ ag tóg ón kỹ vĩ mág han tĩ. “Ẽg tỹ vĩ mág han kỹ ti hỹn ẽg vĩ mẽg mũ,” he ag tóg tĩ, ón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ag ri ke han tũg nĩ. Ẽg jóg vỹ nén kar ki kanhró nĩ, ãjag tỹ ti mỹ tó tũ ra tóg ki kanhró nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ãjag tỹ Topẽ mré vĩ kỹ tag tómnĩ, ha mẽ: “Ẽg jóg mág, kanhkã tá ã tóg nĩ nĩ. Ã jiji tó ẽg tóg tĩ, kỹ vẽnh kar jé ã tỹ tỹ ũn mág nĩ vé. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ẽg jé kãnhmar ã tỹ tỹ ẽg pã'i nĩ vé. Vẽnh kar jé ã tỹ nén to jykrén mũ ẽn han sór, ga tá ke kar, ag jé kanhkã tá ke kar ag ri ke han. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ẽg mỹ ũri ẽg jẽn ti nĩm, ẽg tỹ kurã kar ki ko tĩ ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kỹ ẽg mỹ vẽnh pãte fón nĩ, ẽg tỹ ã vĩ mranh ja ti. Hã jé ẽg tóg ẽg tỹ jagnẽ to jũ tỹ jagnẽ mỹ vẽnh pãte fón ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kỹ ẽg tỹ ã vĩ mranh sór kỹ ẽg kren han nĩ, ẽg tỹn mranh tũ nĩ jé. Nén-Kórég jo ẽg vemnĩ. Ã hã ne tóg tar nĩ'. Ã hã ne tóg mág nĩ inhhã'. Ã jykre tóg tũ' henh ke tũ nĩ,” hemnĩ, Topẽ mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Hỹ, ge ti nĩ,” he tóg. “Ũ tỹ ãjag to jũ kỹ ti mỹ vẽnh pãte fón nĩ. Ũ tỹ ãjag mỹ vĩ kónãn kỹ ti mỹ vẽnh pãte fón nĩ gé. Ãjag tỹ gen kỹ ẽg jóg vỹ ãjag mỹ vẽnh pãte fón ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ãjag tỹ tag han tũ nĩn kỹ, kỹ ẽg jóg tóg ãjag mỹ vẽnh pãte fón ke tũ nĩ gé, ãjag tỹ ti vĩ mranh ja ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kỹ ãjag vãkre kỹ fe ũ nỹtĩ tũg nĩ, ãjag tỹ Topẽ mỹ há nỹtĩ jé jẽg tũ nỹtĩn kỹ. Vãkre ki ũ tỹ vẽnh jykre régre han mũ ag jykre ri ke han tũg nĩ. Ag tỹ ón kỹ vãkre kỹ ag tóg fe ũ nỹtĩnh mũ sir, vẽnh kar tỹ ag vãkre ve jé. Ag ganho hã vẽ. Kanhkã tá ag tóg ganho ũ vẽnh ke tũ nĩ ha. Ãjag mỹ sóg ki hã tó mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ãjag vãkre kỹ ãjag gãnh tãg nĩ, ãjag jamẽ kupemnĩ, festa han nỹtĩ ve nĩmnĩ, ãjag vãkren kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hã kỹ ag tóg vég tũ nĩ, ãjag vãkrég mũ ti. Ẽg jóg hã ne vég mũ inhhã', ẽg tỹ ũn vég tũ ẽn hã vỹ vég mũ. Kỹ tóg kanhkã tá ãjag mỹ nĩm ke mũ, ãjag ganho ti. Ẽg tỹ vẽnh vatánh tá nén han mũ vég tóg tĩ (mỹr), Topẽ tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ga kri mũn kỹ ricon ke to vãsãn sór tũg nĩ. Ga vỹ ãjag tỹ nén kar ti konh ke mũ, ãjag tỹ rico hã to vãsãn mũ ra. Kỹ ãjag jãnkamy vỹ vẽso jãgfanh ke mũ gé sir, ti e nỹtĩn kỹ. Kỹ ag tóg pigju kỹ ma mũnh ke mũ gé sir, ãjag tỹ nén ti, ti e nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ãjag tỹ inhhã kanhkã tá tũ mág pẽ nỹtĩn kỹ tóg inhhã ãjag mỹ há tĩnh mũ. Tá ti pi(jé) tỹ ga nĩ', ãjag tũ ti, tá ti pi(jé) vẽso jãgfanh mũ'. Tá ag pi(jé) péju kỹ ma mũnh mũ'. Hã kỹ tá ãjag tũ vin han sórmnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ãjag tỹ ga kri tỹ nén ũ mág nỹtĩn kỹ ãjag tóg ga kri mũ mág sór mũ. Ãjag tỹ hã ra kanhkã tá tỹ nén ũ mág nỹtĩn kỹ ãjag tóg kanhkã ra mũ sór mũ, kỹ tag hã ne há nĩ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ẽg kanẽ tỹ ẽg vég tĩ. Kỹ tóg tỹ ẽg mỹ kurã ri ke nĩ, ẽg kanẽ ti, ti há nĩn kỹ. Tỹ ẽg tóg kurã ve há han tĩ, ẽg kanẽ há nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ẽg kanẽ kórég nỹtĩn kỹ tóg ẽg mỹ kuty tĩnh mũ. Kỹ tóg ẽg mỹ kurã vég tĩ ẽn mỹ (tóg) kuty nĩ sir, kỹ kuty tag vỹ kuty kar kãfór nĩ. Ge ti nĩ, ẽg jykre kórég nĩn kỹ. Ẽg kanẽ kórég ri ke vẽ sir, ẽg jykre kórég ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ã jagrẽ régre nĩn kỹ tóg vẽnhmỹ tĩ. Ã tỹ Topẽ hã tỹ jagrẽ nĩn kỹ jãnkamy tãn ẽn tỹ jagrẽ nĩ sór tũg nĩ. Ã tỹ jãnkamy e ve sór kỹ ti hã mĩ ẽkrén kỹ ti hã vỹ tỹ ã jagrẽ nĩnh mũ. Kỹ ẽg tóg Topẽ tỹ ẽg mỹ nén tó mũ ẽn to jykrén há han tũ nĩgtĩ. Ã tỹ Topẽ to há nĩn kỹ ã tóg sir ga kri rico to vãsãn sór ke tũ nĩ. Ã tỹ ga kri rico nĩ sór kỹ ã tóg Topẽ mĩ ẽkrég tũ nĩ, hã vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hã kỹ sóg ãjag mỹ tó mũ. Ãjag tỹ nén ve sór mág mũ to krĩ kufy han tũg nĩ. “Inh hỹn ũri ne konh mũ', inh hỹn ne tunh mũ'?” he tũg nĩ. Topẽ tỹ ẽg han ja vẽ mỹr, ẽg tỹ ga kri mũ jé. Hã kỹ tóg ẽg mỹ ẽg jẽn ki rĩr mũ gé sir, ẽg kur ki ke gé, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sẽsĩ to jykrén nĩ. Ag mỹ ẽkrãn tĩ? Vó. Ag mỹ pãjó krẽm vin tĩ? Vó, ke tũ ag tóg nĩgtĩ. Ge ra ẽg jóg tỹ kanhkã tá nĩ ẽn tóg ag ki rĩr nĩ nĩ. Ãjag mỹ jẽsĩ kãfór tũ nỹtĩ', Topẽ mỹ'? Vó, sẽsĩ kãfór ãjag tóg nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Topẽ tỹ ẽg kã ũ jé prẽr kỹ ẽg tóg ter ke mũ, ẽg ter sór tũ ra. Ter jé ẽg tóg ke mũ gé, ẽg tỹ to krĩ kufy han mũ ra. Ẽg krĩ kufy ẽn pi(jé) ẽg kren han mũ'. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kỹ kur to krĩ kufy han tũg nĩ gé. Ka fej hã to jykrén nĩ. Jatun mỹ tóg mog tĩ. Rãnhrãj tũ tóg nĩgtĩ, kur han tũ tóg nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hã ra tóg sĩnvĩ nỹtĩ, ka fej ti. Kỹ pã'i mág tỹ Salomão kur tóg ri ke tũ nĩgtĩ, ti sĩnvĩ ra, vẽnh kar kur sĩnvĩ kãfór ti nĩ, Salomão kur ti. Hã ra tóg ka fej sĩnvĩ ri ke tũ nĩ. Ki hã sóg tó mũ mỹr. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Topẽ hã ne ka fej sĩnvĩ han, tỹ tóg kur sĩnvĩ ri ke nĩ, ka fej ti. Hã ra tóg kãnhmar kãgter tĩ, ka fej ti, ti sĩnvĩ ra. Ũri tóg há nỹtĩ. Kỹ tóg vaj kỹ kógungun kỹ pũr mũ sir, re mré. Hã kỹ Topẽ tóg ãjag ki rĩr kãfór han mũ, ãjag kur mré hã. Hã kỹ Topẽ ki ge kỹ nỹtĩmnĩ, ti vĩ kri fi kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Krĩ kufy han tũg nĩ. “Inh hỹn ne konh mũ'? Inh hỹn ne kron mũ'? Inh hỹn ne tunh mũ'?” he tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ũ tỹ Topẽ vĩ ki kagtĩg ag vỹ tag to jykrén mág tĩ, hã ra ẽg jóg tỹ Topẽ vỹ ẽg vég tĩ, ẽg tỹ nén ve sór mág mũ ti. Kỹ to krĩ kufy han tũg nĩ. Ti hã ne ẽg vég mũ, ẽg jóg tỹ Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Topẽ tỹ tỹ ẽg pã'i nĩ ẽn hã ve sórmnĩ. Kỹ tag hã to vãsãn nĩ. Ti jykre kuryj tag hã to vãsãn nĩ. Kỹ tóg ãjag mỹ ãjag tỹ nén ve sór mág mũ ẽn tỹ ãjag mỹ vin ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hã kỹ ãjag tỹ vaj kỹ nén venh ke to krĩ kufy han tũg nĩ. Vaj kỹ ãjag tóg venh ke mũ, kỹ ãjag tóg to jykrén ke mũ sir. Ũri ãjag tỹ nén tỹ ũri vég mũ hã to jykrén há han nĩ. Ãjag tỹ ũri nén ũ jagy vég mũ vỹ há nĩ, kỹ ãjag tỹ vaj kỹ nén venh ke to jykrén tũg nĩ, ũri,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ã régre to jykrén kónãn tũg nĩ, ti jykre kórég ra. Kỹ Topẽ vỹ ã to jykrén kónãn ke tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ã tỹ ũ to jykrén mũ ẽn ri ke han jé tóg ke mũ, Topẽ ti, ã mỹ. Ã tỹ ũ mỹ kãmun mũ ri ke han jé tóg ke mũ, ã mỹ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Jykre kórég mág ã tóg nĩ gé, hã ra ã régre jykre pãno sĩ ẽn ne ã mỹ kórég nỹ'. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kỹ ã hã ne tóg ã régre mỹ: ã jykre kórég kurynh jé sóg ke mũ, he mũ', ã tỹ ã jykre pãno tãvĩ ẽn kurynh jãvãnh (hã) ra'. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ke tũg nĩ. Ke tũ nĩ (mũ) ra ã tóg jykre régre nỹtĩ. Ã jykre kurynh vén nĩ. Kar kỹ ã tóg sir ã régre jykre kurynh há han mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Hã ra cachorro jykre ri ke ag mỹ Topẽ jykre sĩnvĩ tó tũg nĩ. Porco jykre ri ke ag mỹ Topẽ jykre sĩnvĩ ẽn tó tũg nĩ gé. Jykre kavéj ag nỹtĩ, hã kỹ ag tóg Topẽ jykre to é henh ke mũ. Ti tỹ tũ' he sór ag tóg tĩ, ti sãn kỹ, Topẽ jykre sĩnvĩ ẽn ti. Kar kỹ ag tóg sir ã mré vẽnh génh sór mũ gé, ha vemnĩ, ã tỹ ag mỹ Topẽ jykre sĩnvĩ ẽn tó kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Topẽ mỹ nén kar to vĩmnĩ, kỹ tóg ãjag mỹ han mũ. Ãjag tỹ ti mỹ nén ũ to vĩ mũ ẽn jãvãnh nĩ, kỹ ãjag tóg venh ke mũ. Ti mré vĩ kỹ ẽg tỹ ti jãnkã tỹ tórón tórón ke ẽn ri ke han nĩ. Kỹ tóg ãjag mỹ nón ri ke han mũ sir, ti tỹ ãjag mỹ ãjag tỹ nén to vĩ mũ ẽn han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Hỹ, hã vẽ. Ãjag tỹ ti mỹ nén (ũ) to vĩn kỹ tóg ãjag mỹ han mũ sir. Ãjag tỹ ti jãvãnh kỹ ãjag tóg ti venh mũ sir. Ãjag tỹ ẽg tỹ jãnkã tỹ tórón tórón ke ri ke han kỹ tóg ãjag mỹ nón ri ke han mũ sir,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kejẽn ãjag kósin tóg ãjag mỹ ẽmĩ to vĩ mũ. Kỹ ãjag pi(jé) ti mỹ pó nĩm ke mũ'. Ti mỹ ãjag tóg ẽmĩ hã nĩm ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ãjag kósin tỹ ãjag mỹ pirã to vĩn kỹ, kỹ ãjag pi(jé) ti mỹ pỹn nĩm ke mũ'. Pirã hã nĩm jé ãjag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jykre pãno ãjag nỹtĩ. Ge ra ãjag tóg ãjag krẽ mỹ nén ũ há vin tĩ. Ge ti nĩ gé, ãjag tỹ Topẽ mỹ nén ũ to vĩn kỹ. Nén ũ há hã nĩm jé tóg ke mũ. Hã ra tóg ãjag kãfór han tĩ, ẽg jóg tỹ kanhkã tá nĩ ti. Ãjag tỹ ti mỹ nén (ũ) to vĩn kỹ tóg ãjag mỹ nén ũ há tãvĩ han tĩ mỹr,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ãjag tỹ ãjag mré ke ũ to: “ti tỹ ẽg mỹ tag han há tóg tĩ vẽ,” he mũ ra ẽg hã tóg ti mỹ han ke mũ. Moisés tỹ ẽg jyvẽn hã vẽ, Topẽ vĩ tó tĩ ag tỹ ẽg jyvẽn hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ũ tỹ inh ki rã mũ vỹ tỹ jãnkã sĩ fĩn rãm ke ri ke nĩ. Jãnkã sĩ fĩn rãm jé ẽg tóg vãsãn tĩ. Ri ke ti nĩ, ũ tỹ inh ki rãnh ke mũ ti. Jãnkã mág vỹ nĩ gé. Hã ra ũ tỹ fĩn rãm ke mũ ag vỹ kãgter pẽ han ke mũ. Ãjag tỹ jãnkã mág ẽn fĩn rãm sór kỹ tóg ver jagy tũ nĩ, fĩn rãm há tóg tĩ. Kỹ nũgme to ẽpry jagma tĩg, pĩ to ẽmĩn jagma tĩg pi(jé) jagy tĩ', ti mág pẽ nĩn kỹ. Hã kỹ ũ tỹ hẽn ri ke ag vỹ jagma mũ mũ. Kar kỹ ag tóg kãgter pẽ han mũ sir, pĩ ki vár kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ag jãvo jãnkã sĩ ẽn fĩn rãm nĩ, ãjag tỹ rĩr krỹg ja tũ ve jé. Sĩ ti nĩ, kanhkã to ẽpry ti, kanhkã to ẽmĩn ti. Ũn pipir ag vỹ jagma mũnh mũ. Ã sĩ san kỹ tóg vég tũ sag tĩ, hã kỹ ũ tỹ jagma mũnh ke mũ ag vỹ pipir nỹtĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ón kỹ Topẽ vĩ tó tĩ ẽn ag vĩ kri fig tũg nĩ. Há nỹtĩ ve ag tóg nỹtĩ, hã ra ag tóg ãjag kókén sór nỹtĩ. Ãjag kókén sór to ag tóg mĩg jũ ẽn ri ke nỹtĩ, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ãjag tỹ ag jykre tugnỹm kỹ ãjag tóg ag tỹ Topẽ vĩ mranh mũ ẽn ki kanhró nỹtĩ. Ha vé, vãnh tỹ jóhó ki ẽg tóg uva vég tũ nĩgtĩ mỹr. Kỹ ẽg tóg sónh ki pẽnva vég tũ nĩgtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ka vỹ ge nỹgtĩ. Ti há nĩn kỹ tóg kanẽ há han tĩ, kỹ ẽg tóg ko tĩ. Ti kórég nĩn kỹ tóg kanẽ kórég han tĩ, kỹ ẽg pi(jé) ko tĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ka há vỹ kanẽn kónãn ki kagtĩg nĩ, kỹ ka kórég vỹ kanẽ há han ki kagtĩg nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kỹ ẽg tóg ka kórég ẽn gỹn tĩ, tỹ ẽg pĩ han tĩ. Ka tỹ kanẽ há han vãnh ẽn tỹ ẽg pĩnh ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ge ti nĩgtĩ, ón kỹ Topẽ vĩ tó tĩ ag tỹ. Ag tỹ Topẽ vĩ mrynhmranh kỹ ag tóg ón kỹ Topẽ vĩ tó tĩ. Ag tỹ nén han mũ ki ẽg tóg ag jykre kórég vég mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Vẽnh kar tóg iso: “pã'i vẽ, pã'i vẽ,” he tĩ. Hã ra ũ ag tóg Topẽ tỹ nén tó mũ ẽn han vãnh nỹtĩgtĩ. Hã kỹ ag tóg Topẽ tỹ tỹ ẽg pã'i mág nĩ venh ke tũ nĩ. Ũ tỹ inh jóg vĩ han mũ ẽn ag hã vỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kurã ẽn kã, isỹ vẽnh kar jykre tugnỹm ke kurã ẽn kã ag tóg inh mỹ tag tónh mũ, ha mẽ. “Senhor, Senhor, ã jykre tó ẽg mỹr,” he jé ag tóg ke mũ. “Ã jykre hã ki ẽkrén kỹ ẽg tóg ẽg tỹ nén han vãnh han ja nĩgtĩ mỹr. Ã jykre hã tỹ ẽg tóg vẽnh jagrẽ kórég pan mỹr,” he jé ag tóg ke mũ, inh mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hã ra sóg ag mỹ: “ãjag pi(jé) tỹ inh mré ke nỹtĩ',” henh ke mũ. “Ãjag ki kagtĩg sóg nĩ mỹr. Ha mũ jẽg. Jykre kórég ãjag tóg nỹtĩ,” he jé sóg ke mũ, ũ tỹ inh panh vĩ han vãnh ag mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ha mẽ, inh vĩ mẽg ãjag tóg nỹtĩ,” he tóg. “Ãjag tỹ inh vĩ ki króm kỹ ãjag tóg sir ũn há ri ke nỹtĩ. Ĩn han ken kỹ tóg to jykrén mũ. To jykrén há nĩn kỹ tóg ga kũm kỹ pãró kri ĩn nũna ka fẽg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kỹ vãhã ta tóg kutẽ mũ, kỹ goj vỹ var mũ sir. Kóho jũ vỹ kãtĩ mũ, ĩn to, hã ra tóg kutẽ tũ nĩ sir, ĩn ti. Pãró kri tóg nỹtĩ, ti nũna ti, hã kỹ tóg kutẽ tũ nĩ. Ge ti nĩ, ãjag tỹ inh vĩ kri fi kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ãjag tỹ inh vĩ mẽg mũ ra ki króm tũ nĩn kỹ ãjag tóg ũn jykre kórég ri ke nỹtĩ. Ĩn han ken kỹ tóg to jykrén kónãn mũ, kỹ tóg ga tỹ rỹnhrỹj hã ki ka fẽg mũ, krĩg mỹ, ĩn nũna ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kỹ ta tóg kutẽ mũ, kỹ goj vỹ var mũ sir. Kóho jũ vỹ kãtĩ mũ gé, ĩn to, kỹ ĩn tóg vom ke tére kỹ kutẽ mũ sir. Mráj kãn tóg mũ sir, ĩn ti. Ge ti nĩ, ãjag tỹ inh vĩ kri fig tũ nĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hã ki Jesus tóg krỹg he mũ sir, ag kanhrãn ki. Kỹ tóg vẽnh kar mỹ e tĩ sir, ti vĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ti vĩ tóg vẽnh kar vĩ kãfór nĩ, Topẽ vĩ to professor ag vĩ kãfór ti nĩ, kỹ tóg pã'i vĩ kãfór pẽ nĩ gé, ti vĩ ti. Hã kỹ tóg ki hã tó mũ. Kỹ tóg ag mỹ e tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus tỹ ag mỹ tó kãn kỹ tóg pãnónh ẽn to tére mũ sir. Kỹ ũn e ẽn ag tóg ti nón mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kỹ vãhã ũ tóg ti tá jun mũ. Vẽnh kaga kren vãnh han kỹ tóg nĩ, vẽnh kaga tỹ lepra he mũ ẽn, ũ tỹ tá jun mũ ti. Kỹ tóg ti krẽm grĩnh ke kỹ ã jakrĩ tỹ jẽ nĩ, kỹ tóg ti mỹ: “Senhor,” he mũ. “Ã mỹ isỹ há' he sór tũ nĩ'? Ã hã tóg isỹ há henh mũ, ã tỹ isỹ há' he sór kỹ,” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kỹ Jesus tóg ti mỹ: “hej,” he mũ. “To há sóg nĩ, há' he ja há ã tóg nĩ,” he tóg ti mỹ, Jesus ti. Kỹ tóg ti kaga kren vãnh ẽn tỹ kren han mũ vẽsỹmér. Jãnhkri tóg nĩ, ti fár ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kỹ Jesus tóg ti mỹ: “ker ũ mỹ tó hẽ', ã han tag ti,” he mũ. “Ha tĩg, Topẽ tũ ki rĩr tĩ to. Ti hã mỹ tómnĩ. Kỹ ti mỹ nén ũ nĩm nĩ, ti tỹ Topẽ mỹ pũn jé, Moisés tỹ vãsỹ ẽg mỹ nén tó ja ẽn ti. Hã tugrĩn vẽnh kar vỹ ã tỹ há' he mũ tag ki kanhrãn mũ,” he tóg ti mỹ, Jesus ti. Kỹ tóg tĩ mũ, há' hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kỹ Jesus tóg kejẽn cidade tỹ Cafarnaum tá jun mũ. Kỹ fóg tỹ capitão tóg ti venh kãtĩ mũ, ti mỹ nén ũ to vĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Kỹ tóg ti mỹ: “Senhor,” he mũ. “Inh camarada tóg nỹ nĩ, inh ĩn tá. Kãnhgrĩn kãn kỹ tóg nỹ nĩ, hã ra tóg kaga jagy nỹ,” he tóg ti mỹ, capitão ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kỹ Jesus tóg ti mỹ: “kỹ inh hỹn tóg ti venh tĩg ha, ã mré, sỹ ã mỹ ti han jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Hã ra capitão tóg Jesus mỹ ke mãn mũ. “Ã mỹn hỹn jagy nĩ, ã tỹ inh ĩn kãki sãn ke ti, isỹ tỹ fóg nĩn kỹ,” he tóg ti mỹ. “Ã vĩ pir ki inh camarada vỹ há' henh mũ. Ã vĩ hã tỹ ã tóg ti tỹ há' henh ke mũ,” he tóg, capitão ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“Ha vé, tỹ sóg pã'i krẽm ke nĩ gé, kỹ soldado ag tóg tỹ inh krẽm ke nỹtĩ gé. Hã kỹ sóg pã'i jykre ki kanhró nĩ. Isỹ soldado ũ mỹ: kutĩg, hen kỹ tóg tĩ mũ. Sỹ ti mỹ: kunĩg, hen kỹ tóg kãtĩ mũ gé. Isỹ inh camarada mỹ: tag han ra, hen kỹ tóg han mũ. Inh vĩ tỹ sóg ag jẽgnẽg tĩ. Hã kỹ sóg ki kanhró nĩ. Ã vĩ tỹ ã tóg inh camarada tỹ há' he há nĩ,” he tóg, capitão ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kỹ tóg Jesus mỹ e tĩ, ti vĩ tag ti. Kỹ tóg ã mré mũ ag mỹ: “ha mẽ, Israel ag vỹ ti ri ke tũ nỹtĩ,” he mũ. “Ki kanhró tóg nĩ (mỹr), kỹ tóg inh ki rã kỹ jẽ. Ge ve ja tũ sóg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Ha vé, ũ tỹ hẽn ri ke ag vỹ kãmũnh ke mũ, rã jur ja tá ag kãmũnh mũ, rã pur ja tá ke gé. Abraão mré ag tóg ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ venh ke mũ, Isaque mré, Jacó mré ke gé, Topẽ tóg ag ki rĩr ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ag jãvo Israel krẽ'krẽ ag tóg kuty ki vár ke mũ. Ag tỹ ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ venh ke vẽ vẽ, hã ra ag tóg venh ke tũ nĩ. Kỹ ag tóg vẽsỹrénh ke mũ, ãjag jã tỹ ag gángán ke mũ, tỹ gangan ke mũ, vẽso jũn kỹ,” he tóg, Jesus ti. Ã mré nỹtĩ ag mỹ tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kỹ tóg capitão mỹ: “ha tĩg ge,” he mũ. “Inh ki rã kỹ ã tóg jẽ nĩ, hã kỹ ã tóg venh ke mũ sir, ã tỹ nén ve sór mũ ti. Ã camarada tỹ inh hur há' hẽ,” he tóg, Jesus ti, capitão mỹ. Kỹ tóg tĩ mũ sir. Hã ra ti camarada tóg há' he mũ. Hora ẽn ki tóg há' he mũ, Jesus tỹ hora ki tó mũ ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kỹ Jesus tóg sir Pedro ĩn kãra rã mũ. Kỹ tóg ti prũ fi mỹnh fi vég mũ. Kaga fi tóg nỹ nĩ, rỹg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kỹ tóg fi nĩgé mẽg mũ sir. Kỹ fi rỹg ẽn tóg tũ' he mũ sir. Kỹ fi tóg nĩ kỹ ag ki rĩr mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kuty ẽn kã ag tóg ũn jagrẽ kórég ag tatĩn kãmũ mũ ti to. Kỹ tóg ag mỹ vĩ mũ, kỹ ag tóg pa kãn mũ sir, vẽnh jagrẽ kórég ag. Ũn kagyga ag hyn han tóg mũ gé sir, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hã ra tag tóg rán kỹ nĩ gé. Vãsỹ Topẽ vĩ tó tĩ tỹ Isaías vỹ tag rán ja nĩ, ha mẽ: “ẽg kaga nỹtĩn kỹ tóg ẽg han, kỹ ẽg tóg há' he kãn mũ, ti tỹ ẽg jagfy jagtar tugrĩn,” he ja tóg nĩ, Isaías ti. Hã ra tóg ge nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kejẽn ag tóg Jesus pénĩn e nỹtĩ, kỹ Jesus tóg ag ve kỹ: “mũ jé ha,” he mũ, ã mré mũ tĩ ag mỹ. “Goj kafã ũ ra ẽg mũnh mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ag mũnh ke to hã Topẽ vĩ to professor ũ tóg ti mré vĩnh kãtĩ mũ. “Senhor,” he tóg. “Sỹ ã mré tĩg há tóg tĩ. Ã tỹ hẽ ra tĩg kỹ sóg ã mré tĩ mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hã ra Jesus tóg ti mỹ: “hã ra tóg jagy tĩ,” he mũ. “Ĩn tũ sóg nĩ,” he tóg. “Mĩg vỹ kré nỹtĩgtĩ. Sẽsĩ vỹ jagfe nỹtĩgtĩ gé. Ag jãvo isỹ hẽ tá nũr ke tóg tũ tĩ. Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kỹ Jesus mré tĩ ũ tóg Jesus mỹ vĩ mũ gé. “Ã mré sóg tĩ mũ, hã ra sóg ver inh panh tỹ ga ki ti fón sór mũ,” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kỹ Jesus tóg ti mỹ: “vó,” he mũ. “Ti kénh tĩ tũg,” he tóg. “Inh mré kãtĩg,” he tóg. “Inh ki ge tũ ag vỹ ã panh ti kej han mũnh mũ. Ã tỹ inhhã inh mré kãtĩg há tóg tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kỹ tóg sir canoa kãki rã mũ. Kỹ ti mré mũ tĩ ag tóg ti mré ki ge mũ gé sir, goj kafã ũ ra mũ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ag tỹ goj kãmĩ mũ (hã) ra kóho jũ tóg sir krog he mũ, ha mẽ. Kỹ goj tóg canoa kãki krém krém ke mũ, ti fãn sór tóg mũ. Hã ra Jesus tóg nũr kỹ nỹ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kỹ ag tóg ti rĩn kỹ ti mỹ: “Senhor,” he mũ. “Ẽg kren han nĩ,” he ag tóg. “Ẽg kãgter ha mẽ tóg tĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kỹ Jesus tóg ag mỹ: “ãjag tỹ nejé mũmẽgmẽg nẽ?” he mũ. “Ãjag mỹ inh ki ge há han tũ'?” he tóg. Kỹ tóg nĩ kỹ jẽgnẽ mũ sir, kỹ tóg goj mỹ vĩ mũ sir, kóho mỹ. Kỹ tóg tũ' he mũ sir. Katy' he tóg mũ, katy tãvĩ tóg tĩ mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kỹ tóg vẽnh kar mỹ e tĩ. “Ti jykre tóg ẽg mỹ e tĩ,” he ag tóg mũ. “Kóho tóg ti vĩ han, goj ti ke gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kỹ tóg goj fĩn rãm kỹ nig kafã ũ tá jun mũ sir, Gadara tá, Jesus ti, ti mré mũ tĩ ag ke gé. Kỹ ũn régre ag tóg ti kato tẽgtẽ mũ, ũn jagrẽ kórég ag. Vẽnh kej tá ag tóg kãmũ mũ. Ag jamã vẽ, vẽnh kej ti. Jũ mẽ ag tóg nỹtĩ, kỹ ũ ag tóg hẽn ra mũ vãnh nỹtĩ, ag kamẽg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesus kato ag tóg kãmũ mũ, ũn jagrẽ kórég ẽn ag. Ti ve kỹ ag tóg sir prẽr mũ, ha mẽ. “!..Ã hỹn ẽg tỹ hẽ ri kenh mũ ha, Topẽ kósin'..!” he ag tóg mũ. “!..Ã mỹ ẽg vóg kónãn sór mũ ha, ẽg kurã to hã..!” he ag tóg. Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hã ra porco tóg ki e nỹtĩ. Kakó tá ag tóg jẽg nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kỹ Nén-Kórég ag tóg Jesus mỹ: “ã tỹ ẽg pan kỹ ã tỹ porco to ẽg jẽgnẽnh há tóg tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kỹ tóg ag mỹ: “hej,” he mũ. “Ha mũ jẽg ge,” he tóg. Kỹ ag tóg ẽn ag togvãnh kỹ porco ki ge mũ sir, Nén-Kórég ag. Kỹ vãhã porco ag tóg rán ki re kãn mũ sir, goj nig ki ag tóg vár kãn mũ. Nãgnãr kãn ag tóg mũ sir, tũ' he ag tóg mũ sir, porco ẽn ag, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kỹ porco ki rĩr tĩ ag tóg pétẽ kãn mũ sir, cidade ra, kamẽg kỹ. Tá ag tóg kãmén kãn mũ. Nén-Kórég tỹ jagrẽ ja ẽn ag tó ag tóg mũ sir, Jesus tỹ ag pan ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kỹ vãhã cidade tá ke kar ag tóg sir Jesus venh kãmũ mũ. Kãmũ kãn ag tóg mũ. Kỹ ag tóg tá junjun kỹ (ag tóg) Jesus mỹ to vĩ mũ, ti tỹ tá kutẽ jé, ti tỹ ag rã hã nĩ tũ nĩ jé, hã kỹ tóg tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kỹ Jesus tóg canoa ki rã kỹ goj nig kafã ũ ra tĩg mãn mũ. Kỹ tóg ã jamã tá jun mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ti tỹ ã jamã tá jun kỹ vãhã ag tóg ti mỹ ũ vyn kỹ junjun mũ, ũn kónhgrĩn kỹ nỹ ẽn, ha mẽ. Ã cama kri tóg nỹ nĩ. Kỹ Jesus tóg ag tỹ ti ki ge mũ vég mũ sir. Hã kỹ tóg ũn kãnhgrĩ mỹ: “inh kósin',” he mũ. “Ã fe tỹ há' hé. Ã tỹ Topẽ vĩ mranh ja ẽn tỹ tũ' hen hã vẽ ha,” he tóg, ti mỹ, ũn kónhgrĩ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hã ra Topẽ vĩ to professor ag vỹ tá nỹtĩ gé. Ti vĩ mẽ kỹ ag tóg to jykrén mũ. “Topẽ to vĩ kónãn tóg mũ mỹr. Vẽsỹ tóg Topẽ han mũ mỹr,” he ag tóg mũ, Jesus to, ti tỹ ti mỹ: “ã tỹ Topẽ vĩ mranh ja ẽn tỹ tũ' hen hã vẽ,” hen kỹ. Kỹ tóg ag mỹ tỹ ũ nỹ, ti jykre ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hã ra Jesus tóg ki kanhró nĩ, ag tỹ nén to jykrén mũn ki. Kỹ tóg ag mỹ: “ãjag ne tog nén ũ vẽnhmỹ to jykrén mũ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Ne nỹ ãjag mỹ vẽnhmỹ nỹ?” he tóg. “Ũn tĩg vãnh tag mỹ sóg: “ã tỹ Topẽ vĩ mranh ja ẽn tỹ tũ' hen hã vẽ ha,” he mũ mỹr. Kỹn mỹ ãjag mỹ vẽnhmỹ?” he tóg. “Sỹ ti mỹ: “nĩ ra, tĩg ra,” henh ke vẽ gé. Kỹn mỹ ãjag mỹ vẽnhmỹ ke gé'?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Hã ra isỹ ãjag mỹ inh jykre ven sór vẽ. Tỹ sóg ẽprã ke fi kósin nĩ. Tá sóg krỹg ke mũ, Topẽ vĩ mranh tỹ vẽnh pãte fón ke tá, ũn kãnhgrĩ tag mỹ. Sỹ tá krỹg mũ ven jé sóg ke mũ, ãjag mỹ,” he tóg. Hã kỹ tóg ũn kónhgrĩ mỹ: “nĩ ra, jẽg ra, ã kur gé (g) tĩg ra, ã ĩn ra,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kỹ tóg vym ke nĩ mũ, kỹ tóg sir jẽgnẽ kỹ tĩ mũ. Ã ĩn ra tóg tĩ mũ (mỹr) sir, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kỹ vẽnh kar ag tóg vég mũ. Kỹ tóg ag mỹ e tãvĩ tĩ. Topẽ mỹ ag tóg vĩ há han mũ, ti tỹ Jesus mỹ vẽnh jykre há nĩm kỹ. Ẽg mré ke vẽ mỹr, Jesus ti, ẽprã ke, hã ra Topẽ tóg ti tar han, hã kỹ tóg ti tỹ há' he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kỹ Jesus tóg ã jamã tá kã kutẽ kỹ tĩ mũ sir. Kỹ tóg Mateus vég mũ sir. Governo mỹ tóg jãnkamy mãg tĩ, imposto kaja ti, kỹ tóg ã rãnhrãj han kỹ nĩ nĩ. Kỹ Jesus tóg ti mỹ: “inh mré kãtĩg,” he mũ, Mateus mỹ. Kỹ tóg jẽgnẽ kỹ ti mré tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kỹ tóg kejẽn ti mré jẽg mũ, Jesus ti. Kỹ ũ tỹ hẽn ri ke ag tóg tá vẽnh mãn mũ, ti ĩn krẽm, governo mỹ jãnkamy mãg tĩ ag, Topẽ vĩ mranh tĩ ag. Jesus mré ag tóg jẽgjẽg mũ, Jesus mré mũ tĩ ag mré ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kỹ Fariseu ag tóg vég mũ. Kỹ ag tóg ti mré mũ tĩ ag mỹ vĩ mũ. “Ãjag pã'i ne tóg ag mré jẽg mũ', governo mỹ jãnkamy mãg tĩ ag mré. Topẽ vĩ mranh tĩ ag mré hã tóg jẽg mũ',” he ag tóg, Fariseu ag, Jesus mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hã ra Jesus tóg mẽg mũ, ag vĩ ti. Kỹ tóg ag mỹ kãmén mũ, ha mẽ. “Ũn kagyga tũ ag vỹ médico venh mũ tũ nĩgtĩ,” he tóg. “Hã ra ũn kagyga ag hã vỹ ti venh mũ tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Ha vé, tag to jykrén, Topẽ vĩ tag to, ha mẽ. “Ãjag tỹ jagnẽ jagãgtãn kỹ tóg inh mỹ há tĩ inhhã,” he tóg, Topẽ ti. “Ãjag tỹ inh mỹ nén ũ pũn kãfór tóg nĩ, ãjag tỹ jagnẽ jagãgtãn mũ ti,” he tóg, Topẽ ti. Hã kỹ jagnẽ jagãgtãn nĩ, ag to vĩ tũg nĩ,” he tóg, Jesus ti. “Inh pi(jé) ũ tỹ vẽnh jykre kuryj han mũ ag mỹ: “ãjag jykre tovãnh nĩ,” he sór tĩ'. Ũ tỹ Topẽ vĩ mranh ja nĩ ẽn ag hã mỹ sóg: “ãjag jykre kórég tovãnh nĩ,” he sór tĩ. Hã jé sóg ãjag mỹ vẽnh ven,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kỹ João mré mũ tĩ ag tóg ti tá junjun mũ sir, Jesus tá. Kỹ ag tóg ti ki jẽmẽg mũ. “Ẽg hã ne tóg vãkrég tĩ', Fariseu mré ke ag ke gé. Ẽg jãvo ã mré mũ tĩ ag tóg vãkre vãnh nỹtĩgtĩ. Hẽ ri ke jé?” he ag tóg, Jesus mỹ, João mré mũ tĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kỹ Jesus tóg ag mỹ: “hỹ,” he mũ. “Vẽnh kyprũg to kãmũ ag pi(jé) vãkrég tĩ',” he tóg. “Festa vẽ mỹr, vẽnh prũgprũg ti, kỹ ti mré ke ag tóg ũn prũg mũ ẽn venh kãmũ tĩ. Hã ra sóg ũn prũg mũ ẽn ri ke nĩ, hã kỹ tóg inh mré mũ tĩ ag mỹ sér tĩ ver,” he tóg. “Vãhã tóg jun mũ, inh kurã ti. Kỹ hã ag tóg inh pére mũnh mũ. Ẽn kã hã ag tóg ãjag vãkrenh ke venh mũ, kurã ẽn kã, inh mré mũ tĩ ag,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ti si fag pi(jé) vãfe kygnej tũ tỹ kur si jar ki hyn han tĩ ja nỹtĩgtĩ'. Ũn kygnej tũ tỹ ki hyn han mũ ra tóg jaran kenh mũ. Kỹ kur si jar ẽn tóg mág mũ. Ũn kygnej hã tỹ fag tóg ki han han tĩ, kỹ tóg jaran ke tũ nĩ,” he tóg, Jesus ti. Ti tỹ ã jykre tãg tón hã vẽ, hã ra tóg kur kygnej ja tũ ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kỹ tóg ag mỹ: “kỹ vinho vỹ ge nĩgtĩ gé,” he mũ gé. “Ẽg pi(jé) vinho kajãg mũ tỹ ti fár si tỹ saco ki kujẽg tĩ'. Ke tũ nĩ (mũ) ra tóg kunãnh kỹ jaran ke mũ, kógnãj kỹ. Kỹ vinho ẽn tóg tũ' he mũ, saco ke gé. Vinho kajã tỹ ti fár tãg tỹ ki kujẽn ke vẽ mỹr',” he tóg, Jesus ti. Ti tỹ ã jykre tãg tó vẽ, hã ra tóg vinho kajãg mũ ri ke nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ti tỹ ver ag mré vẽmén kỹ pã'i ũ tóg tá jun mũ, ha mẽ. Ti krẽm tóg grĩnh ke mũ. Kỹ tóg ti mỹ: “ha vé,” he mũ. “Inh kósin fi tóg ter ke mũ. Fi venh kãtĩg. Ã tỹ ã nĩgé tỹ fi mẽ kỹ fi fe tóg mrin kenh ke mũ, ha vemnĩ,” he tóg, pã'i ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kỹ Jesus tóg jẽgnẽ kỹ ti mré tĩ mũ sir. Jesus mré mũ tĩ ag vỹ ti mré mũ mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ti tỹ ti mré tĩg mũ ra ũ fi tóg ti tá jun mũ, ũn kaga ũ fi. Kyvénh krỹg ja tũ han kỹ fi tóg nĩ, prỹg tỹ 12 (ke) ki. Jesus vatánh tá fi tóg ti kur mẽg mũ sir, ti kur mráj ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Sỹ hẽn ri ke mũn ti kur mẽ kỹ inh hỹn han mũ,” he fi tóg, to jykrén kỹ. Hã kỹ fi tóg ti kur mẽnh kãtĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Hã ra Jesus tóg vĩrĩn ke kỹ fi vég mũ. Kỹ tóg fi mỹ: “inh kósin',” he mũ. “Kamẽg tũg nĩ,” he tóg mũ. “Ã tỹ inh ki rã hã kỹ ã tóg há' he mũ,” he tóg. Kỹ fi tóg há' he mũ sir vẽsỹmér, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kỹ tóg tĩg mãn mũ, Jesus ti. Kỹ ag tóg pã'i ẽn ĩn tá junjun mũ sir. Kỹ tóg tá fór nĩ, ũn kygfỹ mũ fag tỹ, ag tỹ ẽg jẽnky tỹ vãkyr ẽn kynkyn tĩ ag tỹ ke gé, ti kósin fi ter kỹ. Kỹ Jesus tóg fag vég mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kỹ tóg: “ha mũ jẽg,” he mũ. “Gĩr sĩ fi vỹ ter tũ nĩ. Nũr fi nỹ nĩ,” he tóg. Hã ra fag tóg ti nyg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hã ra tóg fag pan kãn mũ sir. Kỹ tóg gĩr fi nĩgé kãgmĩg mũ sir. Kỹ fi tóg nĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kỹ tag kãme tóg vẽnh kar kri rũm ke mũ, ga ẽn kar mĩ hã, Jesus tỹ fi rĩn mãn mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kỹ Jesus tóg tá kãkutẽ mũ sir. Kỹ ũn kyvó régre ag tóg ti nón mũ mũ. Ti nón mũ kỹ ag tóg ti jé prẽr mũ: “!..Davi kósin'..!” he ag tóg. “!..Ẽg jagãgtãn ra..!” he ag tóg, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kỹ Jesus tóg ĩn kãra rã mũ sir. Kỹ ũn kyvó ẽn ag tóg ti nón ge mũ gé sir, ĩn kãra. Kỹ Jesus tóg ag mỹ: “inh mỹ ãjag mỹ ãjag hyn han há nĩ'?” he mũ. Kỹ ag tóg ti mỹ: “hỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kỹ Jesus tóg ag kanẽ mẽg mũ sir, ã nĩgé tỹ. Kỹ tóg ag mỹ: “ãjag tỹ inh ki ge kỹ nỹtĩn kỹ ãjag tóg há' henh mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kỹ ag kanẽ tóg mrin ke mũ sir. Ẽvãnh há' he ag tóg mũ. Kỹ Jesus tóg ag mỹ vĩ tar han mũ. “Ker ũ mỹ tó hẽ',” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hã ra ag tóg mũ kỹ (ag tóg) vẽnh kar mỹ tugtó mũ. Kỹ ti kãme ẽn tóg vẽnh kar kri rũm ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kỹ ag mũ kỹ ũ tóg ti tá jun mũ gé, ũn jagrẽ kórég. Ti jagrẽ tóg ti vĩ vãnh han. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kỹ Jesus tóg ti jagrẽ kórég kutẽm mũ sir. Ti tỹ ti kutẽm kỹ tóg sir vĩ há han mũ sir, ũn vĩ vãnh ja ẽn ti. Kỹ tóg vẽnh kar mỹ e tĩ. “Ge ve ja tũ ẽg tóg nỹtĩ, ẽg povo tỹ Israel kãmĩ,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hã ra Fariseu ag tóg mẽg mũ. Kỹ ag tóg ón kỹ Jesus to vĩ kónãn mũ. “Vẽnh jagrẽ kórég pan há tóg nĩgtĩ. Hã ra tóg vẽnh jagrẽ kórég ag pã'i jykre tỹ ag pan tĩ nĩ, ti tỹ tỹ Japo mré ke nĩn kỹ,” he ag tóg, ón kỹ, Fariseu ag. Ag tỹ Jesus to ón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kỹ Jesus tóg cidade kar mĩ tĩ mũ, ẽmã kar ẽn mĩ. Ẽg vẽnh kanhrãn jafã krẽm tóg ag kanhrãn tĩ. Ag mỹ tóg ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ ẽn tó tĩ sir. Kỹ tóg ũn kagyga ag hyn han tĩ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Vẽnh e ẽn tóg ti mỹ jagãgtar nỹtĩ. Ũ tỹ ag ki rĩr há han ke tóg tũ tĩgtĩ, jo ag tóg vẽnh ki rĩr há han ki kagtĩg nỹtĩ gé. Ti tỹ ag ve kỹ tóg carneiro tỹ mẽg mĩ ẽkrég mũ sir. Ũ tỹ carneiro tỹ mẽg ki rĩr tũ nĩn kỹ ag tóg véké mũgtĩ. Tag ri ke ag tóg nỹtĩ, Jesus mỹ, ũn e ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kỹ tóg ã mré mũ tĩ ag mỹ: “sỹ ag ve kỹ sóg ẽg jakré mĩ ẽkrég tĩ,” he mũ. “Ti e nĩn kỹ ẽg tóg kejẽn kre kãn tũ nĩgtĩ, ẽg pir nỹtĩn kỹ. Ge ti nĩgtĩ. Ũn e ag tóg inh ki ge to há nỹtĩ, hã ra tóg ver ũ tỹ ag mỹ tónh ke tóg tũ tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","“Hã kỹ Topẽ mré vĩ, ti tỹ ũ jẽgnẽ jé, ag tỹ ag mỹ ti vĩ tó jé,” he tóg, Jesus ti, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Kỹ Jesus tóg ũn tỹ 12 (ke) ag jé prẽr mũ sir, ti mré mũ tĩ ẽn ag jé. Kỹ tóg ag mỹ vẽnh jykre nĩm mũ, ag tỹ vẽnh jagrẽ kórég pan jé, ag tỹ ũn kagyga ag hyn han jé ke gé. Vẽnh kaga kar tỹ ag tóg hẽ ri ke mũ sir, ti tỹ ag mỹ tag to vẽnh jykre nĩm kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ũ tỹ 12 (ke) ag jijin hã vẽ, ha mẽ, Jesus tỹ ũn vin mũ ag jygjyn hã vẽ, ha mẽ. Ũn ve vỹ tỹ Simão nĩ, kỹ ti jiji ũ hã vỹ: Pedro, he mũ. Kar kỹ ti jãvy vỹ nĩ gé, hã vỹ: André, he mũ, Tiago ke gé, Zebedeu kósin tag ti, ti jãvy tỹ João ke gé, ");
INSERT INTO kgpNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipe ke gé, Bartolomeu ke gé, Tomás ke gé, Mateus ke gé, governo mỹ jãnkamy mãg tĩ tag ti, Tiago ũ ke gé, Alfeu kósin tag ti, Tadeu ke gé, ");
INSERT INTO kgpNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simão ke gé, ag tỹ ũ to: Zelote, he mũ tag ti, kar kỹ Judas Iscariotes ke gé, Jesus vatánh tá pã'i ag mỹ ti kãmén ke tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ẽn ag jẽgnẽg tóg mũ sir, Jesus ti, ag tỹ vẽnh kar mỹ Topẽ kãmén jé. Ũ tỹ 12 (ke) ẽn ag jẽgnẽg tóg mũ, Jesus tỹ ũn kuprẽg ja ẽn ag. Kỹ tóg ag mỹ: “ver fóg ag mỹ inh kãmén mũ tũg nĩ, kanhgág ag mỹ kãmén tũg nĩ gé ver,” he mũ. “Kỹ Samaria tá ke ag jamã ki ge tũg nĩ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","“Israel ag tãvĩ mỹ tómnĩ inhhã. Topẽ mỹ ag tóg tỹ carneiro vãfor ri ke nỹtĩ, kỹ ag hã mỹ tómnĩ ver,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Ãjag tỹ ag mỹ tó kỹ tag tómnĩ, ha mẽ. Ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ãjag pã'i nĩnh ke vẽ ũri, hemnĩ, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ũn kagyga ag hyn han nĩ gé. Ũn kãgter mũ ag rĩnrĩn mãn nĩ. Ũn kaga kren vãnh ẽn kren han nĩ. Vẽnh jagrẽ kórég ag pan nĩ. Ãjag mỹ sóg ge ra inh jykre nĩm mũ, kỹ ge ra ag mỹ han nĩ gé. Ag mỹ: inh mỹ kajãm, he tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kỹ jãnkamy ma mũ tũg nĩ, jãnkamy mág, jãnkamy sĩ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kỹ saco ma mũ tũg nĩ gé, bolso ẽn. Kur tỹ vẽnh kri rĩnh tũg nĩ, pẽn né ũ gé mũ tũg nĩ gé, pẽn to ró ẽn. Kỹ vãtó vyn tũg nĩ gé, kãtó ti. Inh rãnhrãj han ãjag tóg mũ. Kỹ ag tóg to ãjag jẽn ke mũ, vẽnh kato, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kỹ ãjag tóg kejẽn ẽmã ũ tá junjun ke mũ. Tá ũn jykre há jãvãnh nĩ. Kỹ ẽn ĩn ra gemnĩ. Ẽn ĩn krẽm ãjag tỹ kurã ki kã panh ke ẽn tá krỹg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kỹ ĩn ẽn krẽm nỹtĩ fag mỹ: “Topẽ jé ãjag ki rĩr, kỹ ãjag jé jatun mỹ nỹtĩ nĩ,” hemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Fag tỹ ãjag mỹ vĩ há han kỹ fag tóg jatun mỹ nỹtĩ. Fag tỹ ãjag mỹ vĩ há han tũ nĩn kỹ fag tóg jatun mỹ nỹtĩ tũ nĩ. Fag javo ãjag tóg jatun mỹ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kejẽn ũ tóg ãjag mỹ: “kãge jẽg ra,” henh ke tũ nĩ, ẽmã ũ tá. Kỹ tá kãpamnĩ, ag tỹ ãjag vĩ mẽ jãvãnh nỹtĩn kỹ. Tá kãpa kỹ ãjag pẽn hã kykũnh nĩ. Kỹ ag tóg ki kanhró nỹtĩ, Topẽ tỹ ag to kórég nĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ha mẽ, ki hã sóg tó mũ. Kurã tỹ ẽgno ki, isỹ vẽnh kar jykre tugnỹm ke kurã ẽn ki ag tóg jagãgtar nỹtĩnh mũ sir, ag tỹ ãjag vĩ mẽ jãvãnh nỹtĩn kỹ. Cidade tỹ Sodoma tá ke ag tóg jykre pãno nỹtĩ ja nĩgtĩ, cidade tỹ Gomorra tá ke ag ke gé. Kỹ ag tóg jagãgtar nỹtĩnh mũ gé, kurã ẽn kã. Hã ra ũn tỹ ãjag vĩ mẽ jãvãnh ẽn ag tóg ag jagãgtar kãfór han ke mũ (mỹr), ha mẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Carneiro vỹ vẽnh jy nĩgãn han ki kagtĩg nỹtĩ, mĩg tỹ ag mãn sór nĩn kỹ. Carneiro ri ke ãjag nỹtĩ, hã ra sóg ãjag jẽgnẽg mũ, ũ tỹ mĩg ri ke ag to, kỹ Topẽ hã tóg ãjag jy nĩgãn ke mũ sir. Hã kỹ vẽnh ki rĩr há han nĩ. Pỹn jykre han nĩ. Vãjig ti tĩ, pỹn ti, kỹ ẽg tóg kãnhmar ti tỹ hẽ ri ke tũ nĩgtĩ. Pỹn ri ke han nĩ. Kỹ sórãg jykre han nĩ gé. Jũ vãnh pẽ ti nĩ, nén ũ vẽnhmỹ han tũ ti nĩ. Kỹ sórãg ri ke han nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ẽprã ke ag tóg ãjag vóg kónãn ke mũ, isugrĩn. Ãjag pã'i ag mỹ ag tóg ãjag kãmén ke mũ, ag tỹ ãjag vóg kónãn jé. Ãjag vẽnh kanhrãnrãn jafã krẽm ag tóg ãjag mrãnmrãn ke mũ. Hã kỹ vẽnh ki rĩr há han nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Fóg tỹ pã'i mág mỹ ag tóg ãjag ven ke mũ, pã'i mág ũ ag mỹ ke gé. Isugrĩn ãjag tóg vẽnh jagtar tag venh ke mũ, ãjag tỹ ag mỹ inh vĩ ti tó jé, fóg ag kar mỹ ke gé, kanhgág ag mỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pã'i ag tỹ ãjag jé ke kỹ to jykrén tũg nĩ, ãjag tỹ ag mỹ nén tónh ke mũ ẽn ti to. Topẽ kuprĩg hã ne ãjag krĩn ke mũ', kỹ ãjag tóg ti tỹ ãjag mỹ nén tó mũ ẽn hã tónh ke mũ, hora ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hã kỹ ãjag tỹ tó tũ vẽ sir. Ẽg jóg kuprĩg tỹ ãjag tỹ vẽmén hã vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Hã ra ũ ag tóg ãjag mré pafa mũ fag kãmén ke mũ, pã'i ag mỹ, ag tỹ fag kãgtén jé. Kỹ ũ ag tóg ãjag krẽ kãmén ke mũ gé. Kỹ ũ ag tóg ãjag han mũ fag kãmén ke mũ gé, pã'i ag mỹ, ag tỹ fag kãgtén jé, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Vẽnh kar vỹ ãjag to jũ kỹ ãjag vóg sór nỹtĩ, isugrĩn. Hã ra ũ tỹ isovãnh tũ ẽn hã krenkren ke mũ, kurã tỹ ẽgno ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Ag tỹ cidade ũ tá ãjag vóg kónãn kỹ, kỹ cidade ũ ra pétẽmnĩ. Ki hã sóg tó mũ, ha mẽ. Israel ag cidade fĩn rãm kãn ke tũ ãjag nĩ, kurã ẽn kã. Sĩ ti nĩ, ag tỹ ãjag vóg kónãn ke kurã ti. Kãtĩg jé sóg ke mũ, ag tỹ ge kỹ ãjag vóg kỹ, mỹr, ha mẽ. Tỹ sóg ẽprã ke fi kósin nĩ, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Aluno pi(jé) ã professor kãfór nĩ'. Ũn camarada pi(jé) ã patrão kãfór nĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aluno tỹ ã professor ri ke nĩn kỹ tóg há tĩ. Ũn camarada tỹ ã patrão ri ke nĩn kỹ tóg há tĩ gé. Iso ag tóg: Belzebu, he ja nĩgtĩ, inh kato vãsãnsãn mũ ag, hã vỹ: Japo, he mũ, hã vỹ: Belzebu, he mũ. Tỹ sóg ãjag professor ri ke nĩ, ãjag patrão ri ke. Ag tỹ iso: Japo, hen kỹ ag tóg ãjag to vĩ kónãn ke mũ gé, ha vemnĩ, ãjag tỹ inh jykre hã han ti kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ge ra ag kamẽg tũg nĩ, pã'i ag. Ẽg tỹ péju kỹ nén han mũ tóg vẽnh ven kãn ke mũ, ẽg tỹ vẽnh kar vatánh tá nén to jykrén mũ tóg vẽnh ven kãn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Isỹ vẽnh kar vatánh tá ãjag mỹ nén tó mũ tag tỹ vẽnh kar mỹ tó kãn nĩ. Isỹ komẽr hã ãjag mỹ nén tó mũ tag tỹ vẽnh kar mỹ jamã há ra tómnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mũmẽg tũg nĩ, ag kamẽg tũg nĩ, pã'i ag. Ẽg tén há ag nỹtĩ, hã ra ag tóg nũgme ki ẽg vãm ke kagtĩg nỹtĩ, pã'i ag. Ũn pir kamẽg nĩ, hã vỹ: Topẽ, he mũ. Ti hã ne ẽg tén kar kỹ nũgme ki ẽg vãm ki kanhró nĩ', inferno ki, kỹ ti hã kamẽg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ha vé. Sẽsĩ vender he ag tĩ, jãnkamy to, kỹ ag tóg ũn régre to jãnkamy pir mãg tĩ. Hã ra Topẽ tóg jẽsĩ ag ki rĩr tĩgtĩ. Ti tỹ: “hej,” hen kỹ ẽg tóg ag pin tĩ, ke tũ nĩn kỹ ẽg tóg ag krenkren tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hã ki Topẽ tóg ag ki rĩr tĩgtĩ, sẽsĩ ag ki. Ẽg ki rĩr tóg tĩ gé, Topẽ ti. Ẽg tỹ nén vég mũ kar ki kanhró tóg nĩ. Hã kỹ tóg ẽg gãnh kar nĩgkrén ja nĩ gé, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Hã kỹ pã'i ag kamẽg tũg nĩ. Jẽsĩ kãfór ãjag tóg nỹtĩ, Topẽ mỹ. Ãjag kãmĩ ũn pir tóg sẽsĩ e kãfór nĩ, ti mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Hã kỹ inh kãmén nĩ, ẽprã ke ag mỹ. Ãjag tỹ ag kamẽg tũ nĩn kỹ ag mỹ inh kãmén kỹ sóg inh jóg tỹ kanhkã tá nĩ ẽn mỹ ãjag kãmén ke mũ gé, kurã ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ãjag tỹ hã ra inh kãmén tũ nĩn kỹ sóg inh jóg tỹ kanhkã tá nĩ ẽn mỹ ãjag kãmén ke tũ nĩ gé, kurã ẽn kã, ãjag tỹ iso: “ti ki kagtĩg sóg nĩ,” hen kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ãjag hỹn iso: “vẽnh kar tỹ jagnẽ to há han jé tóg ke mũ,” he tĩ. Hã tũ vẽ, ũ tỹ hẽn ri ke tỹ jagnẽ to jũ han jé sóg ke mũ, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hã kỹ ũ tóg ã panh kato tẽnh mũ, kỹ ũ fi tóg ã mỹnh fi kato tẽnh mũ gé. Kỹ ũ fi tóg ã má fi kato tẽnh mũ gé, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ti mré ke ag vỹ tỹ ti kato vãsãnsãn mũ ag nỹtĩnh mũ, kỹ fi mré ke fag tóg fi kato vãsãn ke mũ gé, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Iso há kãfor nỹtĩmnĩ, ãjag han mũ fag kri, ke tũ nĩ (mũ) ra ãjag tóg inh mỹ há tũ nỹtĩ. Iso há kãfór nỹtĩmnĩ, ãjag krẽ kri, ke tũ nĩ (mũ) ra ãjag tóg inh mỹ há tũ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Isỹ inh cruz va tĩg ri ke han nĩ gé, isỹ tá ter ke ti, hã vỹ: iser ẽn ri ke han sór mũ, he mũ. Ke tũ nĩ (mũ) ra ãjag tóg inh mỹ há tũ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ãjag tỹ iser ri ke han sór tũ nỹtĩn kỹ ãjag tóg nũgme ki kutẽnh mũ, ãjag tỹ ãjag jykre tovãnh sór tũ nỹtĩn kỹ. Ãjag tỹ isugrĩn kãgter sór kỹ ãjag tóg rĩr krỹg ja tũ ẽn venh ke mũ, ãjag tỹ ãjag jykre tovãnh kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ũ tỹ ãjag mỹ: hej, hen kỹ tóg inh mỹ: hej, he mũ gé sir, kỹ tóg inh ki rã mũ sir. Ti tỹ inh ki rã kỹ tóg ũ tỹ inh jẽnẽg mũ ẽn ki rã mũ gé sir, hã vỹ: Topẽ, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ũ tóg Topẽ vĩ tó tĩ ag mỹ: “ha kãrã,” he tĩ, ag tỹ Topẽ vĩ tó tĩ tugrĩn. Ti tỹ ag mỹ vĩ há han kỹ tóg Topẽ mỹ há nĩ sir. Kỹ tóg kejẽn ti mỹ nén ũ há tónh ke mũ, Topẽ ti, ũ tỹ ti vĩ tó tĩ ag mỹ: “ha kãrã,” he mũ ẽn mỹ. Ũ tóg ũn jykre kuryj ag mỹ: “ha kãrã,” he tĩ, ag jykre kuryj nỹtĩ tugrĩn. Ẽn mỹ tóg nén ũ há tónh ke mũ gé, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ũ tóg kejẽn ũn sĩ mỹ nén ũ nĩm tĩ, goj hẽn ri ke mũn. Ũn sĩ tỹ inh ki rã nĩ tugrĩn tóg ti mỹ nén ũ nĩm tĩ. Ẽn mỹ tóg nén ũ há tónh ke mũ gé, Topẽ ti. Ti pi(jé) to nén ũ há venh ke tũ nĩ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus tỹ ã mré mũ tĩ ag mỹ tó kãn kỹ tóg tá kãkutẽ mũ sir, ũ tỹ 12 (ke) ag mré. Kỹ tóg cidade kar mĩ tĩ mũ sir, vẽnh kar kanhrãn kỹ, ag mỹ Topẽ vĩ tón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kỹ kejẽn João tóg ti kãme mẽg mũ. Se kỹ tóg nĩ nĩ, João ti, hã ra tóg Jesus tỹ nén han mũ mẽg mũ sir. Kỹ tóg Jesus mỹ vẽnh vĩ jẽnẽg mũ, ã mré mũ tĩ ag tỹ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kỹ tóg Jesus mỹ: “ã hã mỹ'?” he mũ. “Ẽg tỹ ũn jãvãnh mũ mỹ tỹ ã nĩ'? Topẽ tỹ ũn jẽnẽg mũ hã mỹ tỹ ã nĩ'?” he tóg. “Ẽg mỹ ũ jãvãnh mãn ke tũ nĩ ha', ã pãte'?” he tóg, João Batista ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kỹ Jesus tóg ti mỹ vẽnh vĩ jẽnẽg mũ gé sir. “Ha João mỹ ãjag tỹ nén vég mũ tag ti tómnĩ, ãjag tỹ nén mẽg mũ tag ti, ha mẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Tag han inh tĩ, ha mẽ: ũn kyvó ag vỹ isugrĩn ẽvãnh há nỹtĩ. Ũn kãnhgrĩ ag vỹ mũ há han mũ, ũ tỹ vẽnh kaga kren vãnh han mũ ẽn ag krenkren han inh tĩ, lepra han mũ ag. Ũn kutu ag vỹ ẽmẽ há nỹtĩ ha, ũn kãgter mũ ag vỹ rĩnrĩr mãn nỹtĩ. Ũn jagãgtar ag vỹ Topẽ vĩ mẽg tĩ, ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩnh ke to. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kỹ tóg ti tỹ iso jykrén kónãn tũ nĩn kỹ há' he mũ. Kỹ Topẽ tóg ti ve há han mũ. Tag tómnĩ, João mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kỹ ag tóg sir mũ mũ, João mỹ tó jé, ti mré mũ tĩ ag. Ag mũn kỹ Jesus tóg vẽnh e ag mỹ João kãmén mũ. “Ãjag tỹ ẽmã tũg ja ra mũn kỹ, ti ve jé, kỹ ti jykre hỹn ne ri ke nĩ, ãjag mỹ?” he tóg. “Kejẽn kãka tóg goj jagma krã tỹ man man ke tĩ. João jykre mỹ ãjag mỹ tag ri ke tũ nĩ'? Hỹ, ri ke tũ ti nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kỹ ti jykre hỹn ne ri ke nĩ, ãjag mỹ? Ti mỹ ãjag mỹ ũn kur sĩnvĩ ag jykre ri ke nĩ'? Vó, ũn kur sĩnvĩ ag vỹ cidade mág tá nỹtĩ, pã'i mág ĩn krẽm. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kỹ ti jykre hỹn ne ri ke nĩ, ãjag mỹ? Ti jykre mỹ ãjag mỹ Topẽ vĩ tó tĩ jykre ri ke nĩ'? Hỹ, Topẽ vĩ tó tĩ vẽ mỹr. Hã ra tóg Topẽ vĩ tó tĩ ag kãfór kar nĩ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Topẽ vỹ João jẽnẽ, ti tỹ ijo tĩg jé. Hã kỹ tag tóg ti to rán kỹ nĩ, Topẽ vĩ ki, ha mẽ. “Ha vé, ã jo sóg ũ jẽnẽnh mũ, ti tỹ vẽnh kar jykre tỹ há' hen jé, ã tĩg ken jo,” he ja tóg nĩ, Topẽ ti, João to, iso ke gé,” he tóg, Jesus ti. “Ag jyvẽn jé tóg ke mũ, kỹ tóg ẽpry kure ri ke nĩ, ẽmĩn kurynh ri ke,” he ja tóg nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki, João to. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ki hã sóg tó mũ, hã kỹ sóg ke mũ, ha mẽ. Ẽprã ke ag kãfór kar ti nĩ, João ti, Topẽ vĩ tón ki. Ũ tỹ ga kri mũ ag kãfór kar ti nĩ. Hã ra ũ tỹ hẽn ri ke ag tóg ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩnh ke ẽn venh ke mũ. Ag tỹ venh ke mũ (hã) ra ag tóg kãsir nỹtĩnh mũ. Ũn kãsir ẽn ag tỹ ẽgno pẽ ẽn tóg João kãfór nĩnh mũ, hã ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“João Batista kãtĩg kar kỹ ẽg tóg vãsãn kỹ (ẽg tóg) ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ venh ke mũ. Ẽg vãsãn kỹ ẽg tóg venh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Topẽ vĩ tó tĩ ag kar vỹ Topẽ vĩ tó ja nĩgtĩ. Kỹ tóg rán kỹ nĩ gé, Topẽ tỹ ẽg jyvẽn mũ ti. Kỹ João tóg tó ja nĩ, ag nón. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","João vỹ Elias ri ke nĩ. Tag to jykrén. Rán kỹ tóg nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki, Elias kãtĩg mãn ke ti, Cristo kãtĩg ken jo. Ti hã vẽ, João hã vẽ, Elias kãtĩg mãn ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ũ nĩgrẽg nỹtĩ tỹ tỹ jẽmẽ jé, to jykrén jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ũri ke ag vỹ ge nỹtĩ gé, ha mẽ. Gĩr ag ri ke ag tóg nỹtĩ. Gĩr ag vỹ jagnẽ mré kanhinnhir mũgtĩ. Kỹ ag tóg ãjag mré ke ag jé prẽr tĩgtĩ, “mũ nỹ, kanhinnhir jé,” hen kỹ. Kỹ ag tóg kejẽn jũgjũ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ãjag mỹ ẽg tóg vãkyn, kanhinnhir kỹ, hã ra ãjag ne vẽnh gringrén jãvãnh nỹtĩ',” he ag tóg tĩ, gĩr ag, jagnẽ mỹ. “Ãjag vẽnh gringrén jãvãnh nỹtĩn kỹ ẽg tóg vẽsỹrénh mũ sir, ẽg kanhinnhir kỹ, hã ra ãjag tóg ẽg mré fỹ jãvãnh nỹtĩ gé,” he ag tóg tĩ gé, ón kỹ jagnẽ to jũ kỹ, gĩr ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gĩr tag ag ri ke ãjag nỹtĩ, João to, iso ke gé. João vỹ vãkre ja nĩgtĩ, jẽn mág tũ, kron tũ. Kỹ ãjag tóg ti to: “jagrẽ kórég ti nĩ,” he ja nĩgtĩ, ti vãkre to. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ti jãvo sóg vãkrég tũ nĩgtĩ, jẽg sóg nĩgtĩ, kron sóg nĩgtĩ, kỹ ãjag tóg iso: “ti hã ne jẽn mág nĩgtĩ', ti hã ne kronkron nĩgtĩ', ti hã ne governo mỹ jãnkamy mãg tĩ ag to há nĩgtĩ', ti hã ne Topẽ vĩ mranh tĩ ag hã to há nĩgtĩ',” he ãjag tóg sir, iso, ẽprã ke fi kósin to. Kỹ João jykre tóg ãjag mỹ kórég nỹ, ti vãkre to. Jãvo inh jykre tóg ãjag mỹ kórég nỹ gé, inh vãkrég tũ to. Hã ra ẽg tỹ ũ jykre tugnỹm kỹ ẽg tóg ti jykre há ẽn ki kanhró nỹtĩ sir. Kỹ tóg tỹ Topẽ krẽ nĩ sir, ũn jykre há ti, kỹ ẽg tóg ti ki Topẽ jykre ki kanhró nỹtĩ sir,” he tóg, Jesus ti. Ti tỹ ag mỹ João kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kỹ Jesus tóg cidade tá ke ag mỹ vĩ kónãn mũ sir. Cidade tỹ hẽn ri ke ki tóg ẽg tỹ nén han vãnh hyn han ja nĩgtĩ, milagre ti, hã ra ag tóg ãjag jykre tovãnh sór ja tũ nĩgtĩ, ti ki ag tóg ge sór ja tũ nĩgtĩ. Hã kỹ tóg sir ag to vĩ kónãn ja nĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Sỹ cidade tỹ Corazim ki ke ag mỹ tag tó sór mũ, ha mẽ,” he tóg. “Kórég ve jé ãjag tóg ke mũ,” he tóg. “Sỹ cidade tỹ Betsaida ki ke ag mỹ tag tó sór mũ, ha mẽ,” he tóg. “Kórég ve jé ãjag tóg ke mũ gé,” he tóg. “Milagre tỹ hẽn ri ke hyn han isóg ãjag mỹ, hã ra ãjag tóg ãjag jykre tovãnh sór tũ nĩgtĩ,” he tóg. “Cidade tỹ Tiro tá, cidade tỹ Sidom tá sóg ẽg tỹ nén han vãnh ẽn hyn han ja tũ nĩ. Sỹ tá milagre ẽn hyn han mũ ra ag tóg ãjag jykre tovãnh mũ vẽ, vãsỹ,” he tóg. “Kygfỹ ag mũ vẽ, ãjag mỹ e tĩn kỹ, ag jykre pãno ẽn, sỹ ag mỹ tó (hã) ra. Ag jãvo ãjag tóg tovãnh sór tũ nĩ, to jykrén sór tũ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Tiro tá ke ag vỹ vẽsỹrénh ke mũ, kurã tỹ ẽgno ẽn ki, Sidom tá ke ag ke gé, ag jykre pãno to. Hã ra ãjag tóg ag vẽsỹrénh kãfór han ke mũ, ha vemnĩ, ãjag tỹ inh vég mũ ra inh ki ge sór ja tũ nĩn kỹ. Ki hã sóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Sỹ cidade tỹ Cafarnaum ki ke ag mỹ tag tó sór mũ, ha mẽ,” he tóg. “Ũri tóg ver ãjag mỹ sér tĩ,” he tóg. “Ãjag tỹ kanhkã jykre vég nỹtĩ ra ãjag tóg to jykrén tũ nĩ, hã kỹ ãjag tóg nũgme ki vár ke kãn mũ. Cidade tỹ Sodoma tá ke ag vỹ ãjag jykre pãno to kãgter. Ag tỹ sỹ ãjag mỹ nén han mũ vég mũ ra ag vãsỹ to jykrén mũ vẽ, kỹ ag kãgter ke tũ nĩ vẽ. Kỹ ẽg tỹ ũri ag jamã ve vẽ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kurã tỹ ẽgno ki ag tóg vẽsỹrénh ke mũ, Sodoma tá ke ag. Hã ra ãjag tóg ag vẽsỹrénh kãfór han ke mũ, sỹ vẽnh kar jykre tugnỹm ke kurã ẽn kã, ãjag tỹ inh vég mũ ra inh ki ge sór tũ nỹtĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kỹ Jesus tóg tag tó mũ gé, ha mẽ. “Jóg',” he tóg. “Tỹ ã tóg kanhkã tãn ag kãfór kar nĩ, kar ã tóg tỹ ẽprã ke ag kãfór kar nĩ gé,” he tóg. “Inh mỹ tóg há tĩ, ã tỹ nén han mũ ti. Ũ tỹ: “ki kanhró mág inh nĩ,” he mũ ag mỹ ã tóg ã jykre ven ja tũ nĩ. Ag mỹ ã tóg kãmén ja tũ nĩ. Ũ tỹ gĩr ri ke ki kagtĩg ag hã mỹ ã tóg ven ja nĩ, ã jykre ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","“Hỹ, hã vẽ. Ã tỹ nén to jykrén mũn hã vẽ, hã kỹ ã tóg ag hã mỹ ã jykre ti nĩm. Hã ra tóg há tãvĩ nĩ, jóg',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kỹ tóg ag mỹ: “inh jóg tóg inh mỹ tovãnh kãn, ã tỹ nén han ja kar ti,” he mũ. “Kỹ ũ pi(jé) ti kósin ki kanhró nĩ'. Inh jóg hã ne inh ki kanhró nĩ'. Kỹ ũ pi(jé) inh jóg ki kanhró nĩ gé'. Inh hã ne ti ki kanhró nĩ', isỹ tỹ ti kósin nĩn kỹ. Hã ra sóg ãjag mỹ ti kãmén jé kãtĩ mũ, inh jóg ti. Isỹ tag to ũn kuprẽg mũ ag hã mỹ sóg ti kãmén tĩ, inh jóg ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ãjag jagãgtar nỹtĩn kỹ, ãjag tỹ Topẽ vĩ ki króm ki kagtĩg nỹtĩ tugrĩn jagtar nỹtĩn kỹ iso kãmũ jẽg. Nén ũ tỹ ãjag mỹ jagy tĩn kỹ iso kãmũ jẽg. Ãjag krĩ tỹ sóg kãnhvy' henh mũ mỹr, ha mẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","“Inh mré kãmũ jẽg. Ãjag kanhrãn jé sóg ke mũ. Komẽr hã sóg vĩ tĩ. Inh pi(jé) vẽsỹ ũn mág han tĩ', vĩ tar han vãnh sóg nĩgtĩ. Ãjag tỹ iso kãmũ kỹ ãjag krĩ tóg há' henh mũ, ha vemnĩ. Kuprã' he jé tóg ke mũ, ãjag krĩ ti, ha vemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","“Inh jykre pi(jé) kufy nĩ', ãjag mỹ'. Isỹ ãjag mỹ nén tó mũ pi(jé) han kórég nĩ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kejẽn Jesus tóg trigo jo ẽpỹ mĩ tĩ mũ, ti mré mũ tĩ ag tóg ti mré mũ mũ. Vẽnhkán ke kurã ki ke vẽ, hã ra ag tóg kókĩnkĩr mũ, vẽjẽn vég tũ nĩn kỹ. Hã kỹ ag tóg trigo mó ẽn tỹ kam ke kỹ ko mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kỹ Fariseu ag tóg ag vég mũ. Kỹ ag tóg Jesus mỹ vĩ mũ. “Ha vé,” he ag tóg mũ ti mỹ. “Ã mré mũ tĩ ag ne tóg ãjag tỹ nén han ke tũ han mũ ha', vẽnhkán ke kurã ki'. Vẽnh rãnhrãj vẽ mỹr, ag tỹ trigo tỹ kam ke ti,” he ag tóg, Jesus, mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Hã ra Jesus tóg ag mỹ: “vó,” he mũ. “Davi tỹ nén han mũ to jykrén nĩ,” he tóg. “Ti kókĩr nĩn kỹ tóg ã tỹ nén han ke tũ han gé, ti mré mũ tĩ ag mré, hã ra Topẽ pi(jé) ti to jũ mũ', ti tỹ ã tỹ nén han ke tũ han mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tag han ja ti nĩ, ha mẽ. Topẽ jo ĩn kãra rã kỹ tóg tá Topẽ jamĩ ẽn kó, tỹ ã tỹ konh ke tũ ra. Kỹ tóg ã mré mũ tĩ ag mỹ vin gé, Topẽ jamĩ ẽn. Topẽ tũ ki rĩr tĩ ag tỹ konh ke ja vẽ vẽ, Topẽ jamĩ ẽn, hã ra tóg ko ja nĩ, ti tỹ tỹ Topẽ tũ ki rĩr tĩ tũ ra, Davi ti. Hã kỹ tóg rán kỹ nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Kỹ Topẽ tũ ki rĩr tĩ ag jykre to jykrén nĩ gé. Tỹ vẽnhkán ke kurã ra ag tóg rãnhrãj mũgtĩ, Topẽ jo ĩn krẽm, hã ra ag tóg Topẽ tũ ki rĩr tĩ. Hã kỹ ag tóg tỹ vẽnhkán ke kurã ra ki vẽnhkán tũ nĩgtĩ gé, ge ra ag jykre tóg há nĩ, Topẽ mỹ. Hã kỹ tóg rán kỹ nĩ gé, Topẽ vĩ tỹ rán kỹ nĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ha mẽ, Topẽ jo ĩn vỹ tỹ Topẽ tũ nĩ. Kỹ ag tóg ti tũ ki rĩr tĩ, tỹ vẽnhkán ke kurã ra. Hã ra sóg Topẽ jo ĩn kãfór nĩ, Topẽ mỹ. Hã kỹ inh mré mũ tĩ ag tóg Topẽ mỹ há nỹtĩ, ag tỹ vẽnhkán ke kurã ki vẽnhkán tũ ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“Kỹ Topẽ vĩ tag to jykrén nĩ gé, ha mẽ. “Ãjag tỹ jagnẽ jagãgtãn kỹ tóg inh mỹ há tĩ,” he ja tóg nĩ. Topẽ ti. “Kỹ tag tóg inh mỹ ãjag tỹ inh mỹ nén ũ pũn kãfór nĩ, ãjag tỹ jagnẽ jagãgtãn tag ti,” he ja tóg nĩ. Topẽ ti. Ãjag tỹ tag to jykrén mũ ra ãjag tóg inh mré ke ag to jũnh ke tũ nĩ vẽ. Ag kókĩr vẽ mỹr. Nén ũ kórég han ja tũ ag tóg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","“Hã ra sóg tỹ vẽnhkán ke kurã to pã'i nĩ. Tỹ sóg ẽprã ke fi kósin nĩ” he tóg, Jesus ti, Fariseu ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kỹ tóg ẽmã ẽn tá kutẽ kỹ ẽmã ũ ra tĩ mũ, kỹ tóg ẽg vẽnh kanhrãn jafã kãra rã mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tã ũ tóg nĩ nĩ, ti nĩgé tóg tóg ja nĩ. Kỹ ag tóg Jesus mỹ: “mỹ há nỹ vỹ, ẽg tỹ vẽnhkán ke kurã ki ũ kygtãg ke ti?” he mũ. Hã ra ag tóg pã'i ag mỹ: “vẽnhkán ke kurã ki tóg Topẽ vĩ mranh tĩ, ũ kygtãg kỹ,” he sór mũ. Hã kỹ ag tóg ti ki jẽmẽg mũ. Ag mỹ tóg tỹ vẽnh rãnhrãj nĩ, ũ kygtãg ti. Vẽnhkán ke kurã ki ẽg nẽji ũ kygtãg ke tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hã ra Jesus tóg ag mỹ: “ãjag mẽg tỹ vẽnhkán ke kurã ki kãgnó ki kutẽ kỹ, ãjag mỹ ti kunũnh ke tũ nĩ, tỹ vẽnhkán ke kurã nĩn kỹ?” he mũ. “Ti kunũnh jé ãjag tóg ke mũ. Kỹ to jykrén nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ẽg mré ke vỹ ẽg mẽg kãfór nĩ,” he tóg. “Kỹ tóg há nĩ, ẽg tỹ ẽg mré ke kygtãg kỹ, tỹ vẽnhkán ke kurã ra,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kỹ tóg ũn nĩgé tóg ẽn mỹ: “ã nĩgé tỹ krỹg' hé,” he mũ. Kỹ tóg tỹ krỹg' he mũ sir. Hã ra tóg há' he mũ. Ti nĩgé há ẽn hã ri ke tóg nĩ, ti nĩgé kórég ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kỹ Fariseu ag tóg jũgjũ kỹ pa mũ sir, ĩn ẽn ki. “Ẽg hỹn hẽ ri kenh mũ, ti tén jé?” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Hã ra Jesus tóg ki kanhró nĩ, ag tỹ ti tén sór mũ ti. Kỹ tóg sir tá kãkutẽ mũ, ẽmã ũ ra tĩg jé. Ti tĩg kỹ ũn tỹ hẽn ri ke ag tóg ti nón mũ mũ sir, ũn kagyga ag ke gé, fag ke gé. Kỹ tóg ag tỹ há' he kãn mũ sir, fag tỹ ke gé, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kỹ tóg ag mỹ: “ker isỹ ãjag tỹ há' he kãmén hẽ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hã ra tóg rán kỹ nĩ gé, ti tỹ ag tỹ há' he mũ tag ti. Isaías ti, ũ tỹ vãsỹ Topẽ vĩ rán tĩ ẽn hã vỹ Jesus to tag rán ja nĩ, ti tỹ Topẽ vĩ tó kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Topẽ vĩ tag tó ja ti nĩ, ha mẽ: “ha vé, sỹ ũn kuprẽg mũ ẽn,” he tóg, Topẽ ti,” he ja tóg nĩ, Isaías ti. “Inh camarada ri ke ti nĩ, ti tỹ isỹ nén tó mũ ẽn ki króm há han kỹ. Inh fe pẽ vẽgtĩ, sỹ ti ve kỹ tóg inh mỹ sér tĩ. Ti hã mỹ sóg inh kuprĩg jẽnẽnh mũ, kỹ tóg inh vĩ tónh mũ sir. Fóg ag mỹ tóg tónh mũ, kanhgág ag mỹ ke gé, isỹ ag jykre tugnỹm ke ti,” he tóg, Topẽ ti,” he ja tóg nĩ, Isaías ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","“Vĩ jũ han ke tũ ti nĩ, jũ kỹ vĩ tar han ke tũ ti nĩ gé. Re tá ag tóg ti vĩ mẽnh ke tũ nĩ gé. Komẽr hã tóg vĩnh mũ,” he tóg, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","“Ẽprã ke ag tỹ inh vĩ mranh kỹ ag tóg vãn tỹ ã tỹ tóg' he kỹ kam ke ẽn ri ke nỹtĩ. Hã ra ti pi(jé) ag tỹ kam ke kãn ke mũ', isỹ ũ to: inh fe, he mũ ẽn ti. Néj gru tỹ nhyn ke sór ri ke ag nỹtĩ gé. Ti pi(jé) ag tỹ nhyn kenh ke mũ', hã ra'. Ag mỹ tóg vĩ há han ke mũ. Tag kar kỹ sóg kejẽn vẽnh kar jykre tugnỹm ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ẽn kã ũ tỹ ti ki ge kỹ nỹtĩ ag hã vỹ krenkren ke mũ, fóg ag mré hã, kanhgág ag mré hã,” he tóg, Topẽ ti,” he ja tóg nĩ, Isaías ti, Jesus to. Hã ra tóg ge nỹgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kejẽn ag tóg Jesus to ũ pére kãmũ mũ, ũn kyvó. Vĩ vãnh tóg nĩ gé. Hã ra tóg jagrẽ kórég nĩ gé, hã kỹ tóg ge nĩgtĩ. Kỹ Jesus tóg ti tỹ há' he mũ sir. Kỹ tóg vĩ há' he mũ sir. Ve há' he tóg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kỹ tóg vẽnh kar mỹ e tãvĩ tĩ. Kỹ ag tóg jagnẽ mỹ: “Davi kósin ẽn tũ mỹ'?” he mũ sir, Jesus to. “Ũ tỹ vãsỹ rán kỹ nĩ ẽn tũ mỹ'?” he ag tóg mũ. Ag mỹ tóg ti hã nĩ ve nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kỹ Fariseu ag tóg mẽg mũ sir, Jesus tỹ ti tỹ há' he mũ ti. Hã ra ag tóg Jesus to: “jagrẽ kórég ti nĩ,” he mũ. “Nén-Kórég ag pã'i tỹ ti jagrẽ nĩ, Belzebu ẽn tỹ,” he ag tóg mũ. “Hã kỹ tóg Nén-Kórég ag pan tĩ, hã kỹ tóg ag jagrẽ kórég ag pan tĩ. Nén-Kórég ag pã'i jykre tỹ tóg ag pan tĩ,” he ag tóg, Fariseu ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Hã ra Jesus tóg ki kanhró nĩ, ag tỹ nén to jykrén mũn ki. Kỹ tóg ag mỹ: “pã'i pir krẽm ke ag tỹ jagnẽ kato tẽgtẽn kỹ ag tóg jagnẽ kãgtén kãn ke mũ,” he mũ. “Ẽmã pir ki ke ag tỹ jagnẽ kato tẽgtẽ kỹ, ĩn pir krẽm ke fag tỹ jagnẽ kato tẽgtẽ kỹ fag tóg vẽnh kãpãm kỹ nỹtĩnh mũ, kỹ fag tóg jagnẽ kãgtén kãn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ge ti nĩ gé, Nén-Kórég ag. Nén-Kórég tỹ Nén-Kórég ũ kutẽm kỹ tóg Nén-Kórég ag tỹ jagnẽ kato tẽgtẽ han mũ sir. Kỹ ag tóg jagnẽ tỹ tũ' henh ke mũ gé, Satanás ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Belzebu tỹ tóg Nén-Kórég ag pan tĩ,” he ãjag tóg tĩ iso. Jãvo ãjag mré ke ag hỹn vẽnh jykre tỹ ne tỹ vẽnh jagrẽ kórég ag pan tĩ? Ag mỹ Nén-Kórég ag jykre ki ag pan mũ gé', Topẽ jykre ki mỹ vó? Topẽ jykre ki ag tóg ag pan tĩ. Ãjag tỹ tag to jykrén kỹ ãjag tóg inh jykre há ki kanhrãn ke mũ vẽ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Topẽ kuprĩg jykre tỹ sóg Japo ag pan tĩ mỹr. Topẽ kuprĩg tỹ Japo ag pan kãn kỹ Topẽ tóg tỹ ẽg pã'i nĩ vẽ mỹr. Tag to jykrén nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","mãn sór kỹ, ti ĩn tá, kỹ ẽg tóg ti se vén tĩ, ke tũ nĩ (mũ) ra tóg ã tũ ki rĩr ke mũ, kỹ ẽg tóg ti tũ mãn tỹ hẽ ri kenh ke tũ nĩgtĩ, ti tar nĩn kỹ. Ẽg tỹ ti se kar kỹ ẽg tóg ti tũ mãg mũ sir,” he tóg. “Ge ti nĩgtĩ, sỹ nén han mũ ti. Tar ti nĩ, Japo ti. Hã ra sóg hur ti sé, hã kỹ sóg ti tũ ag kygvãn ke mũ sir. Ag jagrẽ kórég pan sóg mũ sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ãjag tỹ tỹ inh mré ke tũ nỹtĩn kỹ ãjag tóg inh kato tẽgtẽ mũ. Ãjag tỹ inh mré ẽprã ke ag tỹ Topẽ to kãmũ han tũ nĩn kỹ ãjag tóg ag kãmũ kamẽg mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Hã kỹ sóg ãjag mỹ tó mũ. Ãjag tỹ Topẽ vĩ mranh mũ ra tóg ãjag mỹ vẽnh pãte fón sór mũ, Topẽ ti. Ãjag tỹ Topẽ to vĩ kónãn mũ ra tóg ãjag mỹ vẽnh pãte fón sór mũ gé. Ãjag tỹ hã ra Topẽ kuprĩg to: “Japo tỹ ẽg jagrẽ vẽ,” hen kỹ tóg ãjag mỹ vẽnh pãte fón mãn ke tũ nĩ ha sir, Topẽ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","“Ãjag tỹ iso vĩ kónãn mũ. Ãjag tỹ hã ra Topẽ kuprĩg to vĩ kónãn kỹ tóg ãjag mỹ vẽnh pãte fón mãn ke tũ nĩ ha. Ãjag tỹ ga kri mũn kỹ tóg ãjag mỹ vẽnh pãte fón mãn ke tũ nĩ, Topẽ ti, ãjag ter kar kỹ tóg ãjag mỹ vẽnh pãte fón mãn ke tũ nĩ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ẽg tỹ ka kanẽ ko há krãn kỹ ti kanẽ vỹ ko há nĩ, ẽg tỹ ka kanẽ ko vãnh krãn kỹ ti kanẽ vỹ ko kórég nĩ gé. Ẽg tỹ ti kanẽ ve kỹ ẽg tóg: “ũn kanẽ ko vãnh ja vẽ,” henh ke mũ. Ge ti nĩgtĩ, ẽg jykre ti. Ũn jykre há tóg há nĩ, ũn jykre kórég tóg kórég nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pỹn ri ke ãjag nỹtĩ. Kórég tãvĩ ãjag nỹtĩ, hã ra ãjag tóg ón kỹ nén ũ há tó sór tĩ. Ẽg jẽnky ki tóg kutẽ tĩ, ẽg tỹ nén to jykrén mũ ti. Ẽg jykre kórég tãvĩ nĩn kỹ ẽg tóg nén ũ kórég tãvĩ tó tĩ. Hã kỹ ãjag pi(jé) tó há han tĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ũn jykre há vỹ nén ũ há kar to jykrén tĩ, kỹ tóg ẽg mỹ tó há han tĩ gé sir, Ũn jykre kórég vỹ nén ũ kórég kar to jykrén tĩ, kỹ tóg ẽg mỹ tó kónãn tĩ gé sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ki hã sóg tó mũ ãjag mỹ, hã kỹ sóg ke mũ kurã tỹ ẽgno ki, sỹ vẽnh kar jykre tugnỹm ke kurã ẽn ki sóg ãjag vĩ tugnỹm ke mũ. Kỹ ãjag tỹ ón kỹ vĩ ja nĩn kỹ sóg ẽn venh ke mũ gé. Ãjag tỹ nén tó ja kar tugnỹm jé sóg ke mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","“Ãjag tỹ vĩ há han ja nĩn kỹ ãjag tóg inh mỹ há nỹtĩ gé. Ãjag tỹ vĩ kórég han ja nĩn kỹ ãjag tóg inh mỹ kórég nỹtĩ. Kỹ ã kato tẽ mũ ag mỹ Topẽ jykre tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kỹ Topẽ vĩ to professor ũ ag tóg Fariseu ũ ag mré Jesus mỹ: “Senhor,” he mũ. “Ẽg tỹ ã tỹ milagre han venh há tóg tĩ,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kỹ Jesus tóg ag mỹ: “kórég ãjag nỹtĩ,” he mũ. “Topẽ ki ge sór vãnh ãjag tóg nỹtĩ,” he tóg. “Ãjag tỹ milagre ve sór mũ tag venh ke tũ ãjag tóg nĩ. Nén pir hã ve jé ãjag tóg ke mũ, hã vỹ: Jonas tỹ nén ve ja ẽn ri ke, he mũ, vãsỹ Topẽ vĩ tó tĩ ẽn tỹ nén ve ja ẽn ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonas ẽn vỹ goj tãn nug kãkã nĩ ja nĩ, kurã tãgtũ ki, kuty tãgtũ ki ke gé. Tag ri ke ve jé sóg ke mũ gé. Ga krẽm sóg nỹnh mũ, kurã tãgtũ ki, kuty tãgtũ ki ke gé. Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Kỹ Nínive tá ke ag vỹ ãjag kato vĩnh ke mũ sir, kurã tỹ ẽgno ki, ha vemnĩ. Ag tỹ Jonas vĩ mẽ kỹ ag tóg ãjag jykre kórég tovãnh, Nínive tá ke ag. Tỹ sóg Jonas kãfór nĩ, hã ra ãjag tóg ãjag jykre kórég tovãnh sór tũ nĩ, sỹ Nínive tá ke ag jãvo ãjag mỹ tó mũ ra. Hã kỹ ag tóg ãjag jykre kórég tónh ke mũ, kurã ẽn kã, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kỹ pã'i mág ẽn fi, pã'i tỹ rainha ẽn fi, ũ tỹ kanhkã fyn ja tá kãtĩg ja ẽn fi vỹ nĩnh ke mũ gé, kurã tỹ ẽgno kã. Ãjag mré fi tóg jẽnh ke mũ, kỹ fi tóg ãjag to vĩ kónãn ke mũ gé. Kanhkã fyn ja tá fi tóg kãtĩg ja nĩ, vãsỹ, fi tỹ Salomão vĩ mẽ jé. Salomão kãfór vỹ tỹ inh nĩ, hã ra ãjag tóg inh vĩ jẽmẽ jãvãnh nỹtĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kejẽn sóg vẽnh jagrẽ kórég ũ kutẽm mũ. Kỹ sóg ga kórég mĩ tĩ mũ, ti jagrẽ ẽn ti. Goj venh ke tũ tóg nĩ tá. Vẽnhkán ke tũ tóg nĩ gé, ti tỹ hẽ ri ken kỹ vẽnhkán ke tũ tĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Kỹ tóg vãhã to jykrén mũ sir. “Inh hỹn ẽn ra tĩg mãn ha, sỹ ũ tá kãkutẽ ja ẽn ra. Inh mỹ tóg tỹ ĩn ri ke ja nĩ. Kỹ inh hỹn tóg ti kãra rã mãn ha,” he tóg mũ sir, ti jagrẽ ja ẽn ti. Kỹ tóg ti venh tĩ mũ sir. Hã ra tóg sir krĩ há nĩ, kỹ tóg ti mỹ ĩn há ri ke nĩ sir, in prur, ĩn kuprã, ĩn sĩnvĩ ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kỹ tóg Nén-Kórég tỹ 7 (ke) ag mỹ tónh tĩ mũ sir. “Ha kãmũ jẽg he tóg mũ sir. Hã ra ag jykre pãno tóg ti jykre pãno kãfór nĩ. Kỹ ag kar tóg ũ ẽn kãge mũ, tỹ ag ti jagrẽ nỹtĩ, isỹ ũn mỹ ti jagrẽ pir kutẽm ja ẽn ti. Hã kỹ to, kórég tãvĩ nĩ sir. Ti jagrẽ pir kutẽm inh nĩ vẽ, hã ra tỹ 8 (ke) ag tóg sir tỹ ti jagrẽ nỹtĩ, ti tỹ inh ki rã tũ nĩn kỹ. Ãjag mỹ tóg ge nĩnh mũ, kurã tỹ ẽgno ki. Ũri ãjag jykre vỹ pãno nỹ. Hã ra kurã ẽn ki tóg sir pãno kãfór nỹnh mũ. Kỹ ãjag tóg sir to jagtar tãvĩ nỹtĩnh mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ti tỹ ver tỹ vẽmén kỹ ti mỹnh fi tóg tá jun mũ sir, ti jãvy ag mré. Ti mỹ fag tóg vẽnh vĩ jẽnẽg mũ, fag tỹ ti mré vẽmén jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kỹ ũ tóg ti mỹ tónh kãtĩ mũ. “Ã mỹnh fi vỹ re tá jẽ, ã jãvy ag mré. Fag tỹ ã mré vẽmén ke nẽji,” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kỹ tóg ũ tỹ ti mỹ tó mũ ẽn mỹ: “inh mỹnh fi mỹ inh ve sór mũ', inh jãvy ag mré?” he mũ. “Inh mỹnh pẽ fi pijé', inh jãvy pẽ ag pijé',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kỹ tóg ti mỹ ã mré mũ tĩ ag ven mũ sir, ã nĩgé tỹ. Kỹ tóg ti mỹ: “inh mỹnh pẽ fi hã vẽ, inh jãvy pẽ ag hã vẽ,” he mũ, ã mré mũ tĩ ag to. ");
INSERT INTO kgpNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Ũ tỹ inh panh tỹ kanhkã tá nĩ ẽn vĩ ki króm mũ vỹ tỹ inh jãvy pẽ ag nỹtĩnh mũ, inh ve pẽ fag ke ge, inh mỹnh pẽ fi ke gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kurã ẽn kã Jesus tóg ĩn tá kãkutẽ mũ, kỹ tóg goj nig ra tĩ mũ. Tá tóg nĩ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kỹ ũ tỹ hẽn ri ke ag vỹ tá vẽnh mãn mũ sir, ti rã hã, kỹ tóg canoa kãkã nĩ mũ sir, jo ũn e ẽn ag tóg nig fyr tá nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kỹ tóg ag kanhrãn mũ sir. Ag mỹ tóg comparação tỹ hẽn ri ke hyn han mũ. Kỹ tóg ag mỹ: “ũ tỹ Topẽ vĩ tó mũ vỹ ge nỹtĩnh mũ, ha mẽ,” he mũ. “Kejẽn ũ tóg nén ũ fy vãvãm tĩ mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","“Ti tỹ vãvãm kỹ ti fy ũ tóg ẽpry kri, ẽmĩn kri kutẽ mũ, kỹ sẽsĩ tóg ti ko mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ti fy ũ tóg pãró kri kutẽ mũ, ga e tũ ki. Kỹ tóg kãnhmar mur mũ vẽ, ga sĩ ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hã ra rã tóg ã tỹ ẽg nĩno kã sa kỹ (tóg) ti pũn mũ. Ti jãre han tũ nĩn kỹ tóg tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ti fy ũ tóg sónh kãki kutẽ mũ, kỹ sónh tóg ti mré mur mũ, kỹ tóg ti kri rũm mũ. Kỹ tóg tũ' he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ti fy ũ tóg ga há kri kutẽ mũ, kỹ tóg mur há han mũ, mog há han tóg mũ, kanẽ há han tóg mũ gé. Ũ tóg kanẽ tỹ 100 (ke) han, jo ũ vỹ tóg kanẽ tỹ 60 (ke) han, jo ũ vỹ tóg kanẽ tỹ 30 (ke) han. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ũn nĩgrẽg nỹtĩ tỹ tỹ jẽmẽ jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kỹ ti mré mũ tĩ ag tóg ti to kãmũ mũ, kỹ ag tóg ti mỹ: “ã tỹ ne tó nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Kỹ Jesus tóg ag mỹ: “ãjag hã ne ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ ẽn ki kanhró nỹtĩnh mũ',” he mũ, “ũ tỹ inh jo nén tó ja tũ ẽn ti,” he tóg mũ. “Hã ra ũn e ẽn ag vỹ ki kanhrãn kãn ke tũ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","“Hã kỹ tóg ge nĩ. Ũ tỹ nén to jykrén há han kỹ tóg ũ to jykrén mãn', ũ to jykrén mãn' he mũ. Komẽr hã tóg to jykrén kãn ke mũ. Ũ tỹ nén to jykrén tũ nĩn kỹ tóg ti mỹ tũ' he mũ, ti tỹ to jykrén sĩ han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hã kỹ sóg ũn e ẽn ag mỹ comparação han mũ, ag tỹ mẽ há han sór tũ nỹtĩn kỹ. Kỹ ag tóg ón kỹ mẽg mũ ra ki kagtĩg nỹtĩ, to jykrén tũ ag nỹtĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hã ra tóg rán kỹ nĩ gé. Isaías tỹ vãsỹ Topẽ vĩ tó kỹ tóg tag tó ja nĩ, ha mẽ. “Mẽ jé ãjag tóg ke mũ ón kỹ, hã ra ãjag tóg to jykrén tũ nĩnh mũ, kỹ ãjag tóg ki kagtĩg nỹtĩnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Povo tag ag vỹ krĩ tũ nỹtĩ, nĩgrẽg kutu ag tóg nỹtĩ gé, kanẽ kyvó ag tóg nỹtĩ gé, ag tỹ nén ũ ve sór tũ nỹtĩn kỹ, ag tỹ jẽmẽ sór tũ nỹtĩn kỹ, ag tỹ to jykrén sór tũ nỹtĩn kỹ ke gé. Hã kỹ ag tóg inh ki ge sór tũ nỹtĩ gé, kỹ sóg ag tỹ há' henh ke tũ nĩ gé,” he ja tóg nĩ, Isaías ti, povo tag to,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ag jãvo ãjag hã vỹ nĩgrẽg há nỹtĩ, hã kỹ ãjag tóg ag jãvo jẽmẽ há han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ha mẽ, ũ tỹ hẽn ri ke ag vỹ inh ve sór e ja nĩgtĩ, vãsỹ, ãjag tỹ ũri vég mũ tag ti. Hã ra ag tóg inh kãtĩg ke jo kãgter. Topẽ vĩ tó tĩ ag vẽ. Jykre kuryj ag nỹtĩ ja nĩ, hã kỹ ag tóg ãjag tỹ nén vég mũ tag ve sór e ja nĩgtĩ. Hã ra ag tóg ve ja tũ nĩgtĩ, mẽ ja tũ ag nĩgtĩ, ãjag tỹ ũri nén mẽg mũ ti. Ag tỹ vég tũ ra ag tóg kãgter. Ãjag hã ne mẽg mũ', inhhã',” he tóg, Jesus ti. Ti mré mũ tĩ ag mỹ tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kỹ sóg ãjag mỹ kãmén mũ, nén fy kanẽ tag ti, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ũ tóg kejẽn ón kỹ Topẽ vĩ mẽg mũ, ti tỹ tỹ ẽg pã'i nĩ ti. Hã ra tóg to jykrén tũ nĩ, ã tỹ ón kỹ mẽn kỹ. Kỹ Nén-Kórég vỹ ti mỹ tỹ tũ' he mũ sir, ti tỹ mẽ ja ti tỹ. Kã jatu tóg nĩ sir. Ẽpry kri, ẽmĩn kri kutẽ mũ ẽn hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kỹ ti fy ũ tóg pãró kri kutẽ mũ. Ũ vẽ gé. Topẽ vĩ mẽg tóg mũ gé. Kỹ tóg kãnhmar: “hej,” he mũ sir. Ti mỹ tóg sér tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Hã ra tóg tỹ nén kré jãre tũ ri ke nĩ mỹr. Kỹ tóg tĩg sĩ han mũ, Topẽ mré. Nén ũ jagy kutẽ kỹ tóg Topẽ tovãnh mũ sir, ũ tỹ Topẽ vĩ tugrĩn ti kato tẽ kỹ. Kãnhmar tóg tovãnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ti fy ũ tóg sónh kãki kutẽ mũ. Ũ vẽ gé. Topẽ vĩ mẽg tóg mũ gé. Hã ra tóg ã rãnhrãj hã mĩ ẽkrég mũ sir. Nén kar to én tóg mũ sir, ón kỹ rico nĩ sór jé. Hã kỹ Topẽ vĩ tóg ti mỹ katy tĩ sir. Kỹ tóg han tũ nĩ sir, kanẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ti fy ũ tóg ga há kri kutẽ mũ. Ũ vẽ gé. Topẽ vĩ mẽg tóg mũ gé. Mẽ kỹ tóg to jykrén mũ sir. Kỹ tóg kanẽ han mũ sir. Kỹ ũ vỹ tóg kanẽ tỹ 100 (ke) han, jo ũ vỹ tóg kanẽ tỹ 60 (ke) han, jo ũ vỹ tóg kanẽ tỹ 30 (ke) han,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kỹ tóg comparação ũ han kỹ: “Nén-Kórég tỹ inh rãnhrãj kókén sór mũ vỹ ge nỹnh mũ, ha mẽ,” he mũ. Kỹ tóg: “ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ vỹ ge nĩ, ha mẽ,” he mũ. “Kejẽn ũ tóg nén fy vãvãm mũ, ti japỹ tá, tỹ ti jakré nỹ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kỹ tóg nũr tĩ mũ, ti camarada ag ke gé. Kỹ ti kato tẽ mũ ẽn tóg kutyg kỹ ra tĩ mũ, ti japỹ ẽn ra, kỹ tóg vãnh fy vãvãm mũ, trigo fy ẽn kãmĩ. Kỹ tóg tĩ mũ sir, vãnh fy ẽn vãvãm kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kỹ trigo tóg mur mũ, mog tóg mũ, kanẽ han tóg mũ sir. Hã ra vãnh tóg ti mré mur mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kỹ ti camarada ag tóg ãjag patrão mỹ tónh mũ mũ. “Trigo fy vãvãm ẽg tóg mũ vẽ, hã ra vãnh tóg ti mré mur mũ. Ne nẽ hỹn?” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kỹ tóg ag mỹ: “ẽg kato tẽ mũ ẽn rãnhrãj hã vẽ,” he mũ. “Ẽn hã ne isũ kókég',” he tóg. Kỹ ag tóg ti mỹ: “kỹ ẽg mỹ vãnh ẽn kunũnh ke tũ nĩ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kỹ tóg ag mỹ: “hỹ,” he mũ. “Ãjag tỹ vãnh ũ kunũnh kỹ tóg ãjag tỹ ti pẽn ũ kunũnh ha mẽ tĩ, vãnh mré. Kỹ kunũnh tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Vãnh hỹn tóg trigo mré mog mũ gé. Kỹ ẽg tỹ kre kỹ sóg ũ tỹ krég mũ mỹ tónh ke mũ. “Vãnh kre vén nĩ,” he jé sóg ke mũ. “Ti kre kar kỹ ti tógfĩ, ẽg tỹ ti pũn jé. Kar kỹ ãjag tóg trigo krenh ke mũ, sỹ pãjó krẽm vin han jé,” he jé sóg ke mũ,” he tóg, ag patrão ti,” he tóg, Jesus ti. Ti tỹ ũ tỹ ón kỹ Topẽ ki ge kỹ nỹtĩ ẽn ag tó jan hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kỹ tóg ag mỹ nén ũ tó mũ gé sir. “Ũ tỹ kanhkã tá nĩ tỹ tỹ ẽg pã'i nĩ vỹ ge nĩnh mũ, ha mẽ,” he tóg. “Ka tỹ mostarda fy ri ke tóg nĩ. Ti krãn ẽg tóg tĩ, ẽg japỹ ki, ka tỹ mostarda fy ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kãsir ti nỹtĩ, ti fy ti. Ũ fy vỹ ti sĩ ri ke tũ nĩ. Ti krãn kar kỹ tóg mog mũ. Kỹ tóg ẽgóho ag kãfór nĩ. Pẽ mág ti nỹtĩ, hã kỹ sẽsĩ ag vỹ kri krẽg tĩ, ti pẽ kri,” he tóg, Jesus ti. Ti tỹ ẽg tỹ ti vĩ tó vén kar kỹ vẽnh kar kri rũm ke mũ kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kỹ tóg ag mỹ comparação ũ tó mũ gé sir, kỹ tóg: “Topẽ tỹ tỹ ẽg pã'i nĩ vỹ tag ri ke nĩnh mũ, ha mẽ,” he mũ. “Ũn tỹtá fag tóg pão han tĩ. Pão han jé fag tóg pão jẽgja jafã tỹ fermento ẽn tỹ farĩnh mré jẽgjãg tĩ. Fermento sĩ ẽn tỹ pão kar ẽn tóg són ke kãn tĩ,” he tóg, Jesus ti. Ti vĩ tỹ vẽnh kar kri rũm ke kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Comparação tỹ ge han tóg tĩ, Jesus ti, vẽnh kar mỹ. “Topẽ tỹ tỹ ẽg pã'i nĩnh ke mũ vỹ ge nĩnh mũ,” he tãvĩ han tóg tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Hã ra tóg rán kỹ nĩ gé, Jesus tỹ comparação han ke mũ ti. Vãsỹ Topẽ vĩ tó tĩ ũ tóg Jesus kãmén kỹ tag tó ja nĩ ti to, ha mẽ. “Comparação han jé sóg ke mũ. Inh jo tó ja tũ ẽn tó jé sóg ke mũ. Ũ vỹ tag mẽ ja tũ nĩ ver, sỹ tónh ke mũ tag,” he ja tóg nĩ, Topẽ vĩ tó tĩ ẽn, Jesus to. Hã ra tóg hã tó tĩ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ag mỹ kãmén kãn kar Jesus tóg vẽnh e ẽn ré kỹ ĩn kãra rã mũ. Kỹ ti mré mũ tĩ ag tóg ti to kãmũ mũ, ti ki jẽmẽ jé. “Ẽg mỹ ã tỹ ag mỹ kãmén ja ẽn ti tó mãn nĩ, ã tỹ ag mỹ trigo mré vãnh tó ja ẽn ti. Ẽg tỹ ver to jykrén tũ tóg tĩ,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kỹ tóg ag mỹ kãmén mũ. “Ẽprã ke fi kósin vỹ trigo fy vãvãm mũ. Inh hã vẽ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","“Ga hã to sóg: ẽpỹ, he mũ. Kỹ trigo ẽn vỹ Topẽ krẽ ag ri ke nỹtĩ, kỹ vãnh vỹ Nén-Kórég krẽ ag ri ke nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ũ tỹ ag han mũ vỹ tỹ Japo ti nĩ, Nén-Kórég ẽn krẽ ag. Ti colher ke kurã hã vỹ: kurã tỹ ẽgno, he mũ. Ũ tỹ trigo colher ke mũ ag vỹ tỹ Topẽ tỹ jẽgnẽ jafã ag nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kurã tỹ ẽgno ki ag tóg ẽg tỹ vãnh pũn ẽn ri ke han ke mũ, Japo tũ ag tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ẽprã ke fi kósin ẽn, inh hã vỹ isỹ jẽgnẽ jafã ẽn ag jẽgnẽnh ke mũ sir, kỹ ag tóg ũ tỹ vẽnh jykre pãno han mũ kar ag génh kãn ke mũ, ũ tỹ ũ ag mỹ: “ha jatun mỹ Topẽ vĩ mranh,” he mũ kar ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ag génh kỹ ag tóg pĩ gru mág ẽn ki ag vãm ke mũ sir. Tá ag tóg vẽsỹrénh tãvĩ han tĩ. Ãjag jã tỹ ag tóg gyngyn henh ke mũ, gangan ke jé ag tóg ke mũ, jũ kỹ, vẽsỹrénh kỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kỹ ũn jykre kuryj ag vỹ há pẽ nỹtĩnh mũ, sĩnvĩ, kókov, rã gru ri ke, ag tỹ ãjag jóg tá nỹtĩnh ken kỹ sir, ag tỹ ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ ven kỹ. Ũn nĩgrẽg nỹtĩ tỹ tỹ jẽmẽ jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Kỹ ẽg tỹ ũ tỹ kanhkã tá tỹ ẽg pã'i nĩ venh ke vỹ tag ri ke nĩ gé, ha mẽ. Ũ tỹ ã patrão japỹ tá jãnkamy ne kunũnh kỹ péju mãn kỹ nĩm ri ke tóg nĩ. Ti péju mãn kỹ tóg ã tỹ nén kar fón kãn mũ sir, ti kaja to ẽpỹ ẽn vyn jé sir. Ẽpỹ ẽn vyn kar kỹ jãnkamy ẽn vỹ tỹ ti tũ nĩ sir,” he tóg, Jesus ti. Ti tỹ ẽg mỹ ẽg tỹ ti ki rã sór kỹ ẽg tũ fón kãn tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ẽg tỹ ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ venh ke vỹ tag ri ke nĩ gé, ha mẽ,” he tóg mũ gé. “Negociante ũ tóg jãnka han jafã tỹ negociar he tĩ, pérola tỹ. Hã kỹ tóg ũn há kuprẽg tĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kejẽn tóg ũn há pẽ ũ vég mũ sir, ũn kaja e. Kỹ tóg ã tũ vãm kãn mũ sir, ã tỹ ũn sĩnvĩ pẽ ẽn kajãm jé, ti tỹ tỹ tũ nĩ jé,” he tóg, Jesus ti. Ti tỹ ẽg mỹ ẽg tỹ ti ki rã sór kỹ ẽg tũ vãm kãn tó mãn hã vẽ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ẽg tỹ ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ venh ke to comparação vẽ gé, ha mẽ,” he tóg mũ gé. “Rede ri ke tóg nĩ, ẽg tỹ tỹ pirã kugmĩ jafã ẽn. Ti fig ẽg tóg tĩ, goj kãkã, ẽg tỹ pirã kugmĩ jé, kãkofár ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ki ti fón kar kỹ ẽg tóg nỹgnỹn mũ sir, goj ki ẽg tóg pirã mré kãkofár gég tĩ. Génh kỹ ẽg tóg ũn mág ag hã kuprẽg tĩ, ma mũ jé. Ũn kãsir ẽn togvãnh ẽg tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ge ti nĩgtĩ, kurã tỹ ẽgno ki. Topẽ tỹ jẽgnẽ jafã ag tóg ũn jykre kuryj ag kuprẽg ke mũ, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ũn jykre pãno ag vãvãm jé ag tóg ke mũ, pĩ gru mág ẽn ki. Tá ag vẽsỹrénh vẽ sir. Ãjag jã tỹ ag tóg gyngyn henh ke mũ, tỹ ag gangan kej ke mũ, jũ kỹ, vẽsỹrénh kỹ,” he tóg, Jesus ti. Ti tỹ ag mỹ ẽg tỹ ti ki rã sór jé kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kỹ tóg ã mré mũ tĩ ag mỹ: “ãjag mỹ tag to jykrén kãn mũ, sỹ ãjag mỹ nén kãmén mũ tag ti?” he mũ. Kỹ ag tóg ti mỹ: “hỹ,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kỹ tóg ag mỹ: “kỹ tóg há tĩ,” he mũ. “Ũ tỹ Topẽ vĩ to professor ẽn, ti tỹ kanhkã tá nĩ ẽn jykre ki rãn kỹ tóg ge nĩ, ha mẽ,” he tóg. “Ẽg panh ri ke tóg nĩ, ti tỹ tỹ nén ũ mág nĩn kỹ. Ẽg panh tóg kejẽn ẽg mỹ ã tỹ nén sĩnvĩ ven tĩ, ti tỹ ũri mãg mũ ti, ti tỹ vãsỹ mãn ja ẽn ke gé,” he tóg, Jesus ti. Ti tỹ ẽg mỹ ẽg tỹ Topẽ vĩ ki kanhrãn ke tó vẽ. Ẽg tỹ to estudo han kỹ ẽg tóg vãsỹ rán kỹ nĩ ẽn tónh ke mũ, kỹ ẽg tóg ũ tỹ ũri tó mũ tag tónh ke mũ gé. Jesus tỹ tag to ẽg mỹ comparação han hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ag mỹ kãmén kãn kar kỹ tóg tá kãkutẽ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kỹ tóg ã jamã ra tĩ mũ sir. Tá jun kỹ tóg ẽg vẽnh kanhrãn jafã ki ag kanhrãn mũ. Kỹ tóg ag mỹ e tĩ, ti vĩ ti. Kỹ ag tóg ti to vĩ kónãn mũ. “Hẽn tán hỹn ki kanhrãn, vẽnh jykre tag ki? Ũ nỹ hỹn ti kanhrãn, ti tỹ nén han vãnh tag hyn han jé?” he ag tóg ti to. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Ĩn han tĩ ẽn kósin vẽ mỹr,” he ag tóg. “Ti mỹnh fi vỹ tỹ Maria fi nĩ, kỹ ti jãvy ag vỹ ki nỹtĩ, Tiago, José, Simão, Judas. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kỹ ti ve fag vỹ tag ki nỹtĩ gé, ẽg mré. Ti tỹ ne jé ẽg kãfór nĩ sór nẽ hỹn?” he ag tóg mũ sir, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kỹ tóg ag mỹ tỹ ũ nỹ. Kỹ Jesus tóg ag mỹ: “ẽmã ũ tá ke ag tóg Topẽ vĩ tó tĩ to é he tũ nĩgtĩ mỹr,” he mũ. “Ti jamã tá ke ag tóg ti to é he tĩ jãvo, ti mré ke ag, ti kanhkã ag,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kỹ tóg tá milagre e hyn han tũ nĩ. Ũn kaga nỹtĩ pir ag tỹ há' he tóg, ũn e tỹ há' he tũ ti nĩ, ag tỹ ti ki ge jãvãnh nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kỹ kejẽn pã'i mág tỹ governador tỹ Herodes vỹ mẽg mũ, Jesus kãme ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kỹ tóg ã camarada ag mỹ: “João Batista vẽ hỹn, ãjag tỹ inh mỹ ũ tó mũ ti,” he mũ. “Ti hỹn tóg rĩr mãn, sỹ ti tén kar kỹ, hã kỹ tóg milagre tỹ hẽn ri ke hyn han tĩgtĩ,” he tóg, Herodes ti, ã camarada ag mỹ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes vỹ João se ja nĩ, vẽse ja kãki tóg ti fón ja nĩ, Herodias fi tugnĩn. Ti jãvy tỹ Filipe prũ fi ja vẽ, hã ra tóg fi kunũnh kỹ fi tỹ prũg mũ, Herodes ti. Kỹ João tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","“ã hã ne tóg ã mrẽ ke prũ fi tỹ prũg mũ',” he ja nĩ. “Fi ki ã tóg Topẽ vĩ mranh mũ,” he tóg, João ti, Herodes mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kỹ Herodes tóg ti tén sór mũ, hã ra tóg vẽnh kar kamẽg mũ. Vẽnh kar tóg João to: “Topẽ vĩ tó tĩ ũ vẽ,” he tĩ. Kỹ Herodes vỹ ag kamẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hã ra tóg kejẽn Herodes mur ja kurã tá krỹg mũ. Kỹ festa ẽn kã Herodias fi kósin fi vỹ ag jo vẽnh grén mũ sir, ti mré jẽg mũ ag jo. Kỹ tóg Herodes mỹ sĩnvĩ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kỹ tóg fi mỹ: “ã tỹ nén to vĩ kar nĩm jé sóg ke mũ ã mỹ, sỹ ke há vẽ,” he mũ, Herodes ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kỹ fi tóg ã mỹnh fi mỹ ke mũ. Kỹ fi mỹnh fi tóg fi krĩn mũ, fi tỹ João krĩ to vĩ jé. Kỹ fi tóg to vĩ mũ sir. “Inh mỹ ũri João Batista krĩ tỹ pénky kãkã nĩm,” he fi tóg mũ, Herodes mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kỹ tóg ti mỹ e tĩ sir, ti tỹ ti tén jé. Hã ra tóg fi mỹ: “sỹ ke há vẽ,” he ja nĩ, kỹ ti mré jẽg mũ ag vỹ mẽ kãn ja nĩ. Kỹ tóg fi mỹ: “hej,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kỹ tóg soldado jẽnẽg mũ sir, ti tỹ João krĩ kym jé. Hã ra João tóg vẽse ja kãkã nĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kỹ tóg ti krĩ kym mũ sir. Pénky kãkã nĩm kỹ tóg fi mỹ nĩm mũ, tátãg fi mỹ, ti krĩ ti. Kỹ fi tóg fi mỹnh fi mỹ ma tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kỹ ti mré mũ tĩ ag tóg mẽ kỹ ti vyn kãmũ mũ, vẽnh kej tá ti fón jé. Ti fón kar kỹ ag tóg Jesus mỹ tónh kãmũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus tỹ João ter mẽ kỹ tóg tá kãkutẽ mũ, canoa kãmĩ. Kỹ tóg ẽmã tũg ja ra tĩ mũ sir, ã pir mỹ nĩ jé. Hã ra vẽnh e ẽn tóg ti tĩg mẽg mũ. Kỹ ag tóg ti nón mũ mũ, ãjag pẽn kã, ẽmã kar tá kãmũ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kỹ Jesus tóg kafã ũ tá vag ke mũ, kỹ tóg tá ũn e ẽn ag vég mũ sir, ti nón kãmũ mũ ag. Kỹ ag tóg ti mỹ jagãgtar nỹtĩ. Ag jagãgtãn kỹ tóg ũn kagyga ag tỹ há' he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ti tỹ ũn e tỹ hághá' hen kỹ tóg rãké nỹ sir, ti tỹ ag kanhrãn ki. Kỹ ti mré mũ tĩ ag tóg ti mỹ tó jé kãmũ mũ. “Rãké ti nỹ ha,” he ag tóg mũ, ti mỹ. “Tag mĩ tóg ẽmã tũ tĩ. Kỹ tóg ã tỹ ag jẽgnẽnh há tĩ, ag tỹ ẽmã ũ ra mũ jé, vẽjẽn comprar he jé,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hã ra Jesus tóg ag mỹ: “ha inhhã ag jẽn, kỹ ag tóg hẽ ra mũnh ke tũ nĩ.” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kỹ ag tóg ti mỹ: “hã ra tóg tũ tĩ, vẽjẽn tĩ,” he mũ. “Pão tỹ 5 (ke) vỹ ki nỹtĩ, pirã régre ke gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kỹ tóg ag mỹ: “inh mỹ ma kãmũ jẽg ge,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kỹ tóg ũn e ẽn ag mỹ tó mũ, ag tỹ re tá nĩgnĩ kỹ nỹtĩ jé. Kỹ tóg pão tỹ 5 (ke) ẽn mãg mũ, pirã régre ẽn ke gé. Kỹ tóg kanhkã ki ẽvãnh mũ sir, vẽjẽn ẽn to tóg Topẽ mré vĩ mũ sir. Kỹ tóg pão kénh kỹ ã mré mũ tĩ ag mỹ vin mũ sir, ag tỹ vẽnh ken jé sir, ũn e ẽn ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kỹ vẽnh kar tóg ko kãn kỹ funfór mũ sir. Hã ra tóg kén mũ. Kẽj tỹ 12 (ke) fãn ag tóg mũ, ti ke tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pão ko mũ ẽn ag tóg tỹ mil tỹ 5 (ke) nỹtĩ, ũn tỹtá mré tó tũ, fag krẽ mré tó tũ, hã ra fag tóg tá e nỹtĩ gé mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kỹ tóg ã mré mũ tĩ ag mỹ tó mũ, ag tỹ canoa kãmĩ mũ jé, ag tỹ ti jo kafã ũ ra mũ jé. “Isỹ ver ũn e tag ag mỹ: ha mũjẽg, henh ke vẽ,” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kỹ tóg ũn e ag mỹ: “ha mũjẽg,” he mũ sir. Kỹ tóg pãnónh to tãpry mũ, Topẽ mré vĩ jé. Ã pir mỹ tóg tá nĩ nĩ. Kỹ tóg kutyg mũ sir. Hã ra Jesus tóg pãnónh tá nĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kỹ canoa tóg nig kãmĩ tĩ mũ sir, kafã ũ ra. Nig fyr tóg kór gy nĩ sir, kuvar gy ti nĩ ha. Kỹ goj tóg krém krém ke sa nĩ, kỹ tóg ag kutãn kỹ nĩ nĩ, goj ti. Kãka vỹ ag kato tẽ mũ, hã kỹ ag tóg mũ kónãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kỹ kurã ke ra Jesus tóg ag to kãtĩ mũ, goj kri tĩg kỹ, ã pẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kỹ ti mré mũ tĩ ag tóg ti vég mũ, ti tỹ goj kri tĩg kỹ, kỹ ag fe tóg jũrũn ke mũ. “Vẽnh kuprĩg vẽ,” he ag tóg mũ. Kamẽg kỹ ag tóg vẽkrẽnkrẽr mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hã ra Jesus tóg ag mré vẽmén mũ sir. “Kamẽg tũg nĩ, inh hã vẽ,” he tóg. “Jũrũn ke tũg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kỹ Pedro tóg ti mỹ: “ã hã mỹ'?” he mũ. “Kỹ inh mỹ tó, isỹ ã to tĩg jé, goj kri tĩg kỹ,” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kỹ Jesus tóg ti mỹ: “kunĩg ge,” he mũ. Kỹ Pedro tóg canoa ki kutẽ kỹ goj kri tĩ mũ sir, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Goj kri tĩg kỹ tóg vãhã kãka ki ẽvãnh mũ, kỹ tóg kamẽg mũ sir. Kamẽg kỹ tóg goj ki pun ke mũ. Kỹ tóg prẽr mũ. “Senhor, inh kren han nĩ,” he tóg mũ, prẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kỹ Jesus tóg vẽsỹmér ti kãgmĩg mũ. Kỹ tóg ti mỹ: “inh ki rã há han tũ ã tóg nĩ, vỹ,” he mũ. “Ã hã ne tóg: inh mỹ tá jun mũ vỹ? he mũ', hã kỹ ã tóg ki pun ke kren mũ,” he tóg, Jesus ti, Pedro mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kỹ ag tóg canoa kãki ge mũ sir. Ag tỹ ki ge kỹ kãka tóg tũ' he mũ, kóho ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kỹ tóg ag mỹ há tĩ, canoa kãki nỹtĩ ag mỹ. Kỹ ag tóg Jesus ki ge há han kỹ ti mỹ vĩ há han mũ sir. “Topẽ kósin vỹ tỹ ã nĩ, mỹr,” he ag tóg mũ sir ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kỹ ag tóg kafã ũ tá junjun kỹ (ag tóg) vag ke mũ sir, ẽmã tỹ Genesaré tá. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tá ke ag tóg ãjag tỹ Jesus ve kỹ ti ki kanhrãn mũ. Kỹ ag tóg ti to vẽnh vĩ jẽnẽg mũ sir, vẽnh kar mỹ, ga kar ẽn mĩ hã. Kỹ ag tóg ũn kagyga ag tatĩ kãmũ mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kỹ ag tóg Jesus mỹ to vĩ mũ, ag tỹ hẽn ri ke mũn ti kur mráj mẽ jé. Kỹ ag tóg há' há' he kãn mũ sir, ag tỹ ti kur mẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kỹ kejẽn Fariseu ũ ag tóg Jerusalém tá junjun mũ, Jesus tá, Topẽ vĩ to professor ag mré hã. Jesus mỹ ag tóg vĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ã mré mũ tĩ ag ne tóg ẽg jykre si mranh tĩ',” he ag tóg. “Ẽg jykre si ki ẽg tóg nĩgpég tĩ, ẽg jẽn ke jo, hã ra ag tóg nĩgpég tũ ra jẽg tĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kỹ Jesus tóg ag mỹ: “ãjag hã vỹ Topẽ vĩ mranh tĩ, ãjag tỹ ãjag jykre si han kỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Topẽ tỹ ẽg mỹ tón hã vẽ, ha mẽ: “ã mỹnh fi mré ã panh kamẽg nĩ, fag jagãgtãn nĩ,” he ja tóg nĩ. Kỹ tóg tag tó gé, ha mẽ: “ũ tỹ ã han mũ fag mỹ vĩ kónãn mũ ẽn tén jé ã tóg ke mũ,” he ja tóg nĩ gé, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ti jãvo ãjag tóg tag tó tĩ, ha mẽ: “ã panh mỹ nén ũ nĩm tũg nĩ, ã mỹnh fi mỹ nén ũ nĩm tũg nĩ, ã tỹ fag mỹ: “sỹ ãjag mỹ nén ũ nĩm ke vẽ vẽ, hã ra sóg Topẽ mỹ nĩm sór mũ,” hen kỹ. Ũ tỹ tag han kỹ tóg há tĩ,” he ãjag tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hã kỹ ãjag tóg Topẽ vĩ tỹ tũ' he tĩ, ãjag tỹ ãjag jykre si hã han kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Krĩ régre ãjag nỹtĩ, ha mẽ. Hã kỹ Isaías vỹ ãjag to vĩ ja nĩgtĩ, ti tỹ tag tó kỹ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Povo tag vỹ ãjag nũnẽ hã tỹ inh mỹ vĩ há han tĩ, hã ra ag jykre pi(jé) tỹ inh jykre nỹ',” he ja tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“Fagrĩnh mỹ ag tóg iso grĩnh ke tĩ, hã ra ag tóg ẽprã ke ag jykre to: Topẽ tỹ tón hã vẽ, he tĩ,” he ja tóg nĩgtĩ, Isaías ti,” he tóg, Jesus ti. “Ki hã tó ja tóg nĩ, ãjag to, ãjag krĩ régre nỹtĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kỹ tóg vẽnh kar jé prẽr mũ sir, ag tỹ ti rã hã nỹtĩ jé, ti vĩ jẽmẽ há han jé. Kỹ tóg ag mỹ: “ha mẽ, sỹ nén tó mũ ti, kỹ to jykrén nĩ gé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","“Ẽg jẽn pi(jé) ẽg kavénh tĩ',” he tóg. “Ẽg jẽnky kã ra ẽg tóg rãg tĩ, vẽjẽn ti. Nén ũ tỹ ẽg ki kãpa hã vỹ ẽg kavénh tĩ, ha mẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kỹ ti mré mũ tĩ ag ti to kãmũ kỹ ti mỹ: “ha mẽ,” he mũ. “Fariseu ag vỹ ã to jũ nỹtĩ, ã tỹ ag mỹ: vẽjẽn pi(jé) ẽg kavénh tĩ', hen kỹ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Kỹ tóg ag mỹ: “ẽg jóg mág tỹ nén krãn ja tũ vãm kỹ nĩ kãn ke vẽ, ẽg jóg tỹ kanhkã tá nĩ tỹ nén krãn ja tũ ẽn ti,” he mũ. “Ag pi(jé) tỹ Topẽ krẽ nỹtĩ', Fariseu ẽn ag, hã kỹ tóg ag vãm ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“Hã kỹ ag to jykrén tũg nĩ. Ũn kyvó ag mỹ ag tóg: “sỹ ã jãmĩ tĩg ke vẽ,” he tĩ, hã ra ag tóg ti kóm kyvó nỹtĩ gé, kỹ ũn kyvó tỹ ũn kyvó jãmĩ tĩg kỹ ag tóg kãgnó ki vár ke mũ, ha vemnĩ,” he tóg, Jesus ti. Ag tỹ nũgme ki vár to ken hã vẽ, hã vỹ: kãgnó ki vár ke mũ, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kỹ Pedro tóg ti mỹ: “ẽg mỹ kãmén há han nĩ, ã vĩ tag,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Kỹ Jesus tóg ti mỹ: “kỹ ãjag mỹ ver ki kanhrãn tũ nỹtĩ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Mỹ ãjag tỹ to jykrén tũ tĩ'?” he tóg. “Ha vé, ẽg tỹ ẽg jẽn tỹ ẽg jẽnky kãra rãg kỹ tóg ẽg nug kãra rã mũ, kar ẽg tóg gón mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nén ũ tỹ ẽg ki kãpa vỹ tỹ ẽg jykre nĩ, hã kỹ tóg ẽg kavénh tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nén ũ tỹ ẽg ki kãpa hã vẽ, ha mẽ: jykrén kónãn, ũ tén, ã prũ tũ fi mré nỹ, ã mén tũ mré nỹ, ũn mén tũ fag to én, nén ũ péju, ũ to ón, ũ to vĩ kónãn. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nén ũ tỹ ẽg ki kãpa hã vẽ, ẽg kavénh tĩn hã vẽ. Ẽg tỹ nĩgpég tũ ra jẽn kỹ ti pi(jé) ẽg kavénh tĩ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kỹ Jesus tóg tá kutẽ kỹ (tóg) ga ũ ra tĩ mũ, cidade tỹ Tiro ra, cidade tỹ Sidom ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ti tỹ tá jun kỹ ũ fi tóg ti venh kãtĩ mũ. Ga tỹ Canaã tá ke fi vẽ. Kỹ fi tóg Jesus tá jun mũ, kỹ fi tóg prẽr mũ. “!..Senhor, Davi kósin..!” he fi tóg. “!..Inh jagãgtãn ra..!” he fi tóg. “!..Inh kósin fi vỹ jagrẽ kórég tãvĩ nĩ, ã tỹ inh mỹ ti kutẽm há tóg te..!” he fi tóg, prẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hã ra Jesus tóg fi mỹ vĩ tũ nĩ. Kỹ ti mré mũ tĩ ag tóg ti to kãmũ kỹ ti mỹ: “ã mỹ fi ve sór tũ nĩ, fi tỹ kar kỹ ã ĩn ra tĩg jé?” he mũ. “Ẽg nón fi tóg ẽg jé prẽr mũ, kỹ tóg ẽg mỹ e tĩ,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hã ra tóg ag mỹ: “vó,” he mũ. “Topẽ vỹ inh jẽnẽ, sỹ Israel ag tỹ há' he jé inhhã, ũ tỹ Israel kãmĩ Topẽ vĩ mranh mũ ag tỹ,” he tóg, Jesus ti. Hã ra fi tóg tỹ fóg nĩ, hã kỹ tóg fi ve sór tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kỹ fi tóg ti tá jun mũ sir. Ti krẽm fi tóg grĩnh ke mũ. Kỹ fi tóg ti mỹ: “Senhor,” he mũ. “Ã mỹ inh jagãgtãn ke tũ?” he fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hã ra Jesus tóg fi mỹ: “há tũ tóg nĩ, ã tỹ nén to vĩ mũ ti,” he mũ. “Ẽg krẽ jamĩ vỹ tỹ ẽg krẽ tũ nĩ, kỹ ẽg tóg cachorro mỹ fón vãnh nĩgtĩ, ẽg krẽ jamĩ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kỹ fi tóg ti mỹ: “hỹ,” he mũ. “Hã ra cachorro sĩ ag tóg ẽmĩ mru ẽn ko tĩ, mesa krẽm,” he fi tóg, Jesus mỹ. “Hã kỹ inh kósin fi tỹ há' hemnĩ, ẽg tỹ tỹ cachorro ẽn ri ke nỹtĩ kỹ,” he fi tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kỹ tóg ũn tỹtá ẽn fi mỹ: “inh ki rã tãvĩ han ja ã tóg nĩ,” he mũ. “Hã kỹ sóg ã mỹ han mũ, ã tỹ inh mỹ nén to vĩ mũ tag,” he tóg fi mỹ. Ti tỹ tag tó kỹ fi kósin fi tóg há' he mũ, hora ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kỹ Jesus tóg cidade tá kãkutẽ kỹ (tóg) goj nig fyr jagma tĩ mũ, nig tỹ Galiléia ẽn fyr jagma. Kỹ tóg pãnónh to tãpry mũ, kỹ tóg nĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kỹ ũn tỹ hẽn ri ke ag vỹ junjun mũ, ũn kagyga ag ke gé, ũn kãnhgrĩ ag ke gé, ũn tĩg vãnh ag ke gé, ũn kaga ũ ag ke gé. Ti ki ag tóg junjun mũ, kỹ tóg ag tỹ hághá' he kãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kỹ tóg vẽnh kar ẽn mỹ e tĩ, ag tỹ tag ven kỹ. Ũn vĩ vãnh ag tóg vĩ há nỹtĩ, ũn kónhgrĩ ag tóg mũ há nỹtĩ, ũn kyvó ag tóg ẽvãnh há nỹtĩ. Kỹ ag tóg Topẽ mỹ vĩ há han mũ sir, Israel ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kỹ Jesus tóg ã mré mũ tĩ ag jé prẽr mũ. Kỹ tóg ag mỹ: “inh mỹ ag tóg jagãgtar nỹtĩ, ũn e tag ag,” he mũ. “Kurã tãgtũ han ag tóg mũ ẽg mré. Hã ra ag tóg vẽjẽn ve ja tũ nĩgtĩ. Kỹ tóg sỹ ag jẽg tũ ra ag jẽgnẽ jãvãnh tĩ, ag jamã ra. Ag mũn kỹ ũ ag hỹn kãgter ke mũ, kókĩnkĩr kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kỹ ti mré mũ tĩ ag tóg ti mỹ: “ki ti ẽmã tũ nĩ, ki ti ga kórég nĩ,” he mũ. “Ẽg hỹn hẽ tá vẽjẽn venh mũ, ẽg tỹ ũn e tag ag jẽn jé?” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Kỹ Jesus tóg ag mỹ: “ẽmĩ tỹ hẽ ri ke nỹ ki nỹtĩ ge?” he mũ. Kỹ ag tóg: “ũ tỹ 7 (ke) vẽ, kãkufár pipir ke gé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kỹ tóg ũn e ag mỹ tó, ag tỹ nĩgnĩ kỹ nỹtĩ jé, ga kri. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kỹ tóg ẽmĩ tỹ 7 (ke) mãg mũ, pirã mré, kỹ tóg to Topẽ mré vĩ mũ. Kỹ tóg vẽnh kãkénh mũ, ẽmĩ ti. Kỹ tóg ã mré mũ tĩ ag mỹ vin mũ, ag tỹ vẽnh kar mỹ kã vẽnh ken jé. Kỹ ag tóg kã vẽnh ken mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kỹ ag tóg ko kãn mũ, funfór ag tóg mũ, hã ra tóg kén mũ. Kre tỹ 7 (ke) ẽn fãn tóg mũ sir, ẽmĩ kén ti, Jesus mré mũ tĩ ag tỹ génh kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ũ tỹ ko mũ ag vỹ ũ tỹ 4 mil (ke) nỹtĩ, ag tãvĩ, ũn tỹtá mré tó tũ, ag krẽ mré tó tũ. Hã ra fag tóg tá e nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kỹ Jesus tóg ag jẽgnẽg mũ sir, ag jamã ra. Kỹ tóg canoa ki rã mũ sir, ẽmã tỹ Magadã tá ga ra tĩg jé, ã mré mũ tĩ ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kỹ Fariseu ũ ag tóg Jesus tá junjun mũ, Saduceu ag mré hã. Ag tỹ ón kỹ ti ki jẽmẽ sór vẽ, ag tỹ kar ti kato vĩ jé. Kỹ ag tóg ti mỹ milagre to vĩ mũ. Ag tỹ ti jykre to: “Topẽ jykre mỹ vỹ?” he sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Hã ra Jesus tóg ag mỹ: “ta to jykrén há ãjag nỹtĩ, ẽmé to ke gé,” he mũ. “Rãkãnh kỹ ãjag tóg kanhkã ki ẽvãnh tĩ. Rãren kỹ ãjag tóg: “ẽmãn ke vẽ,” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kỹ kusã ki ãjag tóg kanhkã ki ẽvãnh tĩ gé. Kanhkã pũr kỹ ãjag tóg sir: “ta vỹ kutẽnh mũ, kanhkã vỹ pũr mũ,” he tĩ. Tó há han ãjag tóg tĩ, rãre ve kỹ, kanhkã pũr ven kỹ ke gé. Hã ra ãjag tóg inh ki kagtĩg nỹtĩ, ãjag tỹ sỹ nén han mũ vég mũ ra. Hã kỹ ãjag tóg: “Topẽ jykre mỹ vỹ?” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kórég ãjag nỹtĩ, ãjag tỹ Topẽ ki ge jãvãnh nỹtĩn kỹ. Ũri ke kar vỹ ãjag ri ke kórég nỹtĩ. Milagre venh ke tũ ãjag tóg nĩ. Vãsỹ Topẽ vĩ tó tĩ ũ tóg nĩgtĩ, hã vỹ: Jonas, he mũ. Jonas tỹ nén ve ja ri ke hã ve jé ãjag tóg ke mũ, ũri,” he tóg, Jesus ti. Kỹ tóg ag ré kỹ tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kỹ tóg ã mré mũ tĩ ag mré tĩ mũ, goj nig kafã ũ ra. Ag tỹ kafã ũ tá junjun kỹ ag tóg ẽmĩ to jykrén mũ sir, Jesus mré mũ tĩ ag. Kã jatun kỹ ag tóg nỹtĩ ja nĩ, kỹ tóg tũ tĩ sir, ẽmĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kỹ Jesus tóg ag kanhrãn mũ. “Fariseu ag tỹ fermento há(r) kamẽg nĩ, Saduceu ag tỹ fermento há(r) ke gé,” he tóg mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Kỹ ag tóg jagnẽ mré vĩ mũ sir, Jesus vĩ tag to. “Ti tỹ ẽg tỹ pão mãg tũ ẽn tó hỹn,” he ag tóg mũ, jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Hã ra Jesus tóg ki kanhró nĩ, ag tỹ nén tó mũn ki. Kỹ tóg ag mỹ tó mãn mũ. “Inh ki ge há han tũ ãjag tóg nĩ ver,” he tóg. “Hã kỹ ãjag tóg jagnẽ mỹ: pão tũ, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ver tóg ãjag tỹ to jykrén tũ tĩ'. Pão tỹ 5 (ke) ẽn mĩ ẽkrén nĩ. Ũ tỹ mil tỹ 5 (ke) ag tóg ko kãn, hã ra tóg kén, ag kar tỹ ko mũ ra. Ti ke hỹn kẽj tỹ hẽ ri ke fãn?” he tóg. Kỹ ag tóg ti mỹ tó mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kỹ tóg ag mỹ: “jo pão tỹ 7 (ke) ẽn ti. Ũ tỹ mil tỹ 4 (ke) ag vỹ kó, hã ra tóg kén, ag kar tỹ ko mũ ra. Ti ke hỹn kẽj tỹ hẽ ri ke fãn?” he tóg. Kỹ ag tóg ti mỹ tó mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kỹ tóg ag mỹ: “kỹ inh vĩ to jykrén nĩ,” he mũ. “Pão tó tũ sóg nĩ. Fermento pẽ tó tũ sóg nĩ. To jykrén há han nĩ, ha mẽ. Fariseu ag tỹ fermento há(r) kamẽg nĩ, Saduceu ag tỹ fermento há(r) kamẽg nĩ gé, he sóg mũ ãjag mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kỹ ag tóg to jykrén há han mũ sir vãhã. Ti tỹ fermento pẽ tó pijé'. Ti tỹ Fariseu ag jykre tó ja vẽ, Saduceu ag jykre ke gé. Ag jykre hã to tóg: “ẽn kamẽg nĩ,” he ja nĩ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kỹ Jesus tóg cidade tỹ Cesaréia Filipe tá ga ra tĩ mũ, ti mré mũ tĩ ag mré. Kỹ tóg ag mỹ: “tỹ sóg ẽprã ke fi kósin nĩ,” he mũ. “Kỹ ag iso hẽ ri ke tĩ?” he tóg mũ, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kỹ ag tóg ti mỹ. “ũ ag tóg ã to: João Batista vẽ, he tĩ,” he mũ. “Jãvo ũ ag tóg: Elias vẽ, he tĩ, ã to. Jãvo ũ ag tóg: Jeremias vẽ, he tĩ gé, jãvo ũ ag tóg: Topẽ vĩ tó tĩ ũ vẽ, he tĩ gé, ã to,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kỹ tóg ag mỹ: “ag jãvo ãjag hẽ ri ke tĩ, iso?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kỹ Simão Pedro tóg ti mỹ: “tỹ ã Cristo nĩ,” he mũ. “Topẽ kósin vỹ tỹ ã nĩ. Topẽ vỹ rĩr nĩ, kỹ ã hã vỹ tỹ ti kósin nĩ,” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kỹ Jesus tóg ti mỹ: “Simão',” he mũ, “João kósin',” he tóg. “Ẽprã ke tỹ ã mỹ tó pijé',” he tóg. “Inh jóg tỹ kanhkã tá nĩ ẽn tỹ ã mỹ tó vẽ, isỹ tỹ ti kósin nĩ ti. Hã kỹ tóg ã ve há han mũ, Topẽ ti,” he tóg, Pedro mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Ha mẽ, tỹ ã Pedro nĩ, hã vỹ: pó, he mũ. Pãró tag kri sóg isũ han mũ, tỹ ĩn ri ke ẽn, hã vỹ: ã tỹ ag mỹ inh vĩ tó tugrĩn ag tóg inh ki genh ke mũ, he mũ. Kỹ ũ tỹ inh ki ge kỹ nỹtĩ ag vỹ tỹ igreja ri ke nỹtĩ. Ag fár tỹ tũ' he mũ ra ag tóg rĩnrĩr mãn ke mũ. Tũ' henh ke tũ ag nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ẽprã ke ag vỹ kanhkã ra mũnh mũ, ã vĩ ki. Jãnkã ri ke ti nĩ, kanhkã ra ge jafã ti, kỹ sóg ã hã mỹ ti nón jafã ti fig mũ sir, ti chave ti. Kỹ ã tỹ ũ mỹ: “kanhkã ra tĩg ke tũ ã tóg nĩ,” hen kỹ tóg ra tĩg ke tũ nĩ. Kỹ ã tỹ ũ mỹ: “kanhkã ra ã tóg tĩg ke mũ,” hen kỹ tóg ra tĩg ke mũ,” he tóg, Jesus ti, Pedro mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kỹ tóg ã mré mũ tĩ ag mỹ tó mũ, ag tỹ ti kãmén tũ nĩ jé ver. “Ker ũ mỹ sỹ tỹ Cristo nĩ tó hẽ'” he tóg mũ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kỹ tóg ag mỹ ã jagtar ke kãmén nĩ nĩ. Ã mré mũ tĩ ag mỹ tóg komẽr hã tó mũ. “Kãnhmar sóg Jerusalém ra tĩg mũ ha,” he tóg mũ. “Tá sóg hã ra jagtar ke mũ. Kófa ag vỹ iso kórég nỹtĩnh mũ, ha vemnĩ, Topẽ tũ ki rĩr tĩ to pã'i ag, Topẽ vĩ to professor ag ke gé. Ag tỹ isén ke vẽ, kỹ sỹ kurã tãgtũ ki rĩr mãn ke vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kỹ Pedro tóg ti pin kỹ ti mré vĩ mũ, ti tỹ tag to jykrén tũ nĩ jé. “Senhor,” he tóg, “Topẽ jé ã jy nĩgãn, ã tỹ ã jagtar ke tag vég tũ nĩ jé,” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hã ra Jesus tóg vẽsỹjãm ẽvãnh kỹ ti mỹ vĩ tar han mũ sir, ti to jũ kỹ. “Kutĩg, Satanás,” he tóg, Pedro mỹ. “Isỹ Topẽ vĩ mranh han sór ã tóg mũ,” he tóg. “Ã pi(jé) Topẽ jykre tó mũ'. Ẽprã ke jykre vẽ, ã tỹ inh mỹ nén tó mũ tag ti,” he tóg, Jesus ti, Pedro mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kỹ tóg ã mré mũ tĩ ag mỹ vĩ mãn mũ. “Ãjag tỹ inh mré kãmũ kỹ tóg há tĩnh mũ,” he tóg. “Kỹ ãjag jykre tovãnh nĩ, ãjag tỹ isũ tãvĩ hã han jé. Ha vé, ag tỹ inh cruz tỹ inh kri fi kỹ sóg tĩg ke mũ, ag tỹ to isa kỹ isén jé, ha vemnĩ. Vẽnh nenh ke tũ sóg nĩ. Isỹ tag han ri ke han nĩ, ãjag tỹ inh mré mũ sór nỹtĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Ãjag tỹ ãjag jykre hã han kỹ ãjag tỹ nũgme ki vár ke vẽ. Jãvo ãjag tỹ isugrĩn ãjag jykre tovãnh kỹ ãjag krenkren ke vẽ, ãjag kãgter ke mũ (hã) ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hẽn ri ke mũn ãjag hỹn mundo ki nén ũ kar ganhar henh ke mũ, hã ra ãjag kuprĩg vỹ vãfor ke mũ. Kỹ tóg kórég nỹ. Ẽg tỹ ne tỹ ẽg kuprĩg kajãm ke tóg tũ tĩ, ẽg tỹ ti ve mãn jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Tỹ sóg ẽprã ke fi kósin nĩ. Kãtĩg mãn jé sóg ke mũ, kanhkã tá, isỹ jẽgnẽ jafã ag mré, inh jóg tỹ isỹ ũn mág han ti kỹ. Kỹ sóg vẽnh kar mỹ ãjag tỹ nén han ja kaja ẽn ven ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ha vé, ki hã sóg tó mũ. Ãjag kãmĩ ũ ag tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ, ãjag ter ke to hã, tag ki ẽg mré nỹtĩ ũ ag. Ẽprã ke fi kósin ẽn ve jé ag tóg ke mũ, ti tỹ tỹ pã'i nĩ ti. Inh hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kar kurã tỹ 6 (ke) tũg kỹ Jesus tóg ag mỹ: “mũ nỹ, vyr mỹ,” he mũ. Pedro mỹ tóg ke mũ. Tiago mỹ ke gé, ti jãvy tỹ João mỹ ke gé. Ag hã mré tóg tĩ mũ, pãnónh ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kỹ tóg ag jo vẽnh ve ũ han mũ sir, kỹ ti kakã tóg kókov nĩ. Rã ri ke tóg nĩ, ti kakã ti. Ti kur vỹ kópréj nĩ gé, jẽngrẽ ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kỹ vãhã Moisés tóg ag mỹ vẽnh ven mũ sir, Elias ti ke gé. Jesus mré ag tóg vẽmén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kỹ Pedro tóg Jesus mỹ: “Senhor,” he mũ. “Tag ki tóg sér tĩ,” he tóg. “Ẽg mỹ pãjó tãgtũ han mũ', ã mỹ', Moisés mỹ', Elias mỹ ke gé'?” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro tỹ ver vẽmén mũ ra kanhkã góg kókov tóg ag kri rũm ke mũ. Kỹ vẽnh vĩ tóg mẽ há' he mũ, kanhkã góg kãtá, kỹ tóg: “inh kósin pir hã vẽ,” he mũ. “Ti vĩ jẽmẽ ra,” he tóg, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kỹ Jesus mré mũ tĩ ag tóg mẽg mũ, kỹ tóg ag mỹ e tĩ. Ag mỹ e tĩn kỹ ag tóg mũg ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Kỹ Jesus tóg ag to kãtĩg kỹ ag mẽg mũ sir, ã nĩgé tỹ, kỹ tóg ag mỹ: “nĩgnĩ ra,” he mũ. “Mũmẽg tũg nĩ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kỹ ag tóg mĩ ẽvãnh mũ, hã ra ag tóg Jesus hã vég mũ. Ti mré vẽmén mũ ag ve mãn tũ ag tóg nĩ, kanhkã tá kãmũ ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kỹ ag tóg pãnónh tá kãre mũ sir. Ag mũn kỹ Jesus tóg ag mỹ: “ker ũ mỹ tó hẽ',” he mũ. “Ãjag tỹ ũri nén vég mũ tag tó tũg nĩ ver,” he tóg. “Sỹ iser ja tá vỹn ke kar hã kãmén nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kỹ ti mré mũ tĩ ag tóg ti mỹ: “hã ra Topẽ vĩ to professor ag tóg Elias tó tĩ,” he mũ. “Kãtĩg jé tóg ke mũ nẽji, Cristo kãtĩg ke to hã, Elias ti. Hã mỹ'?” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kỹ tóg ag mỹ: “hỹ,” he mũ. “Kãtĩg jé tóg ke mũ mỹr, nén kar han mãn jé, Elias ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ha mẽ, kãtĩg ti huri. Hã ra ag tóg ti ki kagtĩg ja nỹtĩgtĩ. Hã kỹ ag tóg ti vóg kónãn ja nĩgtĩ, ag tỹ ti vóg kónãn sór kỹ. Hã kỹ ẽprã ke fi kósin ẽn tóg, inh hã tóg ag tugrĩn jagtar ke mũ gé, ag tỹ inh vóg kónãn ken kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kỹ ag tóg vãhã ti tỹ nén tó mũ to jykrén mũ, ti mré mũ tĩ ag. “João Batista to ke ja vẽ, ẽg kygpég tĩ ẽn to ke ja vẽ, hã vỹ: Elias, he mũ, ti tỹ Elias ẽn ri ke ja nĩn kỹ,” he ag tóg mũ sir, Jesus mré mũ tĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kỹ ag tóg vẽnh e ẽn tá junjun mũ sir. Kỹ ũ tóg Jesus to kãtĩ mũ, ag kãmĩ ũ. Ti krẽm tóg grĩnh ke mũ, ã jakrĩ tỹ, kỹ tóg ti mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Senhor,” he mũ. “Inh kósin jagãgtãn nĩ,” he tóg. “Ter tĩ tóg nĩgtĩ, to tóg jagtar tãvĩn tĩ. Kejẽn tóg pĩ ki kutẽ tĩ, ter tĩ ẽn han kỹ, kejẽn tóg goj ki kutẽ tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","“Kỹ sóg ã mré mũ tĩ ag mỹ ti ven ja nĩgtĩ, ag tỹ ti tỹ há' he jé, hã ra ag tóg ti tỹ hẽ ri ke tũ nĩ,” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kỹ Jesus tóg ti mỹ: “ãjag ne tóg inh ki rã há han tũ nĩgtĩ,” he mũ. “Jykre pãno ãjag tóg nỹtĩ,” he tóg. “Kysã tỹ hẽn ri ke ki inh hỹn ãjag mré tĩnh ke mũ'? Kysã tỹ hẽn ri ke ki inh hỹn ãjag to fe tĩnh mũ'?” he tóg. “Inh mỹ ti pére kãtĩg,” he tóg, Jesus ti, ti panh mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ag tỹ ti mré kãmũ kỹ Jesus tóg ti jagrẽ mỹ vĩ jũ han mũ sir, ti tỹ ti tovãnh jé. Kỹ tóg vẽsỹmér ti ki kãkutẽ mũ sir, kỹ tóg há' he mũ vãhã, kyrũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kỹ Jesus mré mũ tĩ ag tóg ti ki jẽmẽ sór mũ. Vyr mỹ ag tóg Jesus mỹ: “ẽg ne tóg ti tỹ há' he ja tũ nĩ',” he mũ. “Hẽ ri ken kỹ hỹn?” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Kỹ tóg ag mỹ: “ãjag tỹ inh ki ge tũ nỹtĩ tugnĩn ke vẽ, ãjag tỹ inh vĩ kri fig tũ tugrĩn ke vẽ,” he mũ. “Ha mẽ, ãjag tỹ inh ki ge sĩ han kỹ nỹtĩ ra ãjag tóg pãnónh tag mỹ: “ha tag ra tĩg,” he há nỹtĩnh mũ vẽ. Ãjag tỹ pãnónh mré vĩ kỹ tóg tĩg ke mũ vẽ, ha mẽ, ãjag tỹ inh ki ge sĩ nỹtĩ ra. Ka tỹ mostarda fy vỹ sĩ tãvĩ nĩ. Ãjag tỹ inh ki ge sĩ nỹtĩ ra, ka tỹ mostarda fy sĩ ẽn ri ke nỹtĩ ra tóg há tĩnh mũ vẽ. Kỹ ãjag tóg pãnónh tĩn há nỹtĩnh mũ vẽ. Nén kar han há ãjag nỹtĩnh mũ vẽ, ãjag tỹ inh ki ge kỹ nỹtĩ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hã ra vẽnh jagrẽ kórég tỹ ge kutẽm tóg jagy nĩ. Topẽ mré ẽg tóg vĩnh ke mũ, kỹ ẽg tóg ti mré vĩ kỹ vãkrenh ke mũ gé, nén ũ ko tũ jé ẽg tóg ke mũ, kỹ tóg vãhã kutẽnh mũ, vẽnh jagrẽ kórég tỹ ge ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tag kar kỹ ag tóg ga tỹ Galiléia tá nỹtĩ. Kỹ Jesus tóg ag mỹ: “ẽprã ke fi kósin vỹ jagtar nĩnh mũ. Inh hã vẽ,” he mãn mũ. “Ẽprã ke ag vỹ ãjag tỹ isỹ nén han sór mũ ẽn han ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ag tỹ isén ke vẽ. Ag tỹ isén kar kỹ sóg hã ra rĩr mãn mũ, kurã tãgtũ tũg kỹ,” he tóg, Jesus ti. Ag tỹ ti vĩ tag mẽ kỹ tóg ag mỹ e tãvĩ tĩ sir. Fe kaj ag tóg mũ sir, ti mré mũ tĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kỹ ag tóg mũ mãn kỹ (ag tóg) cidade tỹ Cafarnaum tá junjun mũ sir. Kỹ imposto kaja mãg tĩ ag tóg Pedro mỹ vĩ mũ, Topẽ jo ĩn jé imposto mãg tĩ ag. Imposto ẽn kaja hã vỹ: jãnkamy régre, he mũ. Pedro mỹ ag tóg: “ãjag Senhor mỹ kajãm tũ nĩgtĩ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kỹ tóg ag mỹ: “vó, kajãm ti tĩ,” he mũ. Kỹ tóg ã ĩn tá jun mũ sir, Pedro ti. Kỹ Jesus tóg ti mỹ vĩ mũ, imposto to, hã ra Pedro tóg ti mỹ nén ũ tó ja tũ nĩ ver. Kỹ Jesus tóg ti mỹ: “Simão',” he mũ. “Pã'i ag mỹ ã mỹ: “ha imposto kajãm,” he ja tũ nĩ?” he tóg, Jesus ti. “Tag to jykrén, ha mẽ. Ag mỹ ãjag krẽ mỹ: “kajãm nĩ,” henh ke mũ', ãjag mré ke tũ ag mỹ, vó?” he tóg, Jesus ti, Pedro mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kỹ Pedro tóg ti mỹ: “ãjag mré ke tũ ag mỹ ag tóg: “kajãm nĩ,” he tĩ,” he mũ. Kỹ Jesus tóg ti mỹ: “hỹ, hã vẽ,” he mũ. “Kỹ ag krẽ hỹn kajãm ke tũ nĩ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hã ra ag tóg ẽg to jykrén kónãn sór mũ, ẽg tỹ kajãm tũ to, ẽg tỹ tỹ Topẽ mré ke nỹtĩ ra. Ag tỹ ẽg to jykrén kónãn sór kỹ ẽg hỹn tóg kajãm ke mũ, Topẽ jo ĩn jé imposto ẽn, ẽg tỹ tỹ Topẽ krẽ nỹtĩ ra, Israel krẽ ke gé. Hã kỹ pirã sygsam tĩg, nig ẽn tá. Sygsam kỹ jẽ kỹ ã tóg pirã kãgmĩnh mũ. Ã tỹ ũn kãgmĩ vén mũ ẽn jẽnky tugnỹm nĩ. Jãnkamy vỹ kãkã nĩ, ti jẽnky kãkã, ã tỹ ẽg jo kajãm jé, ã jo, ijo ke gé,” he tóg, Jesus ti. Kỹ Pedro tóg tĩ mũ sir. Jãnkamy vég tóg mũ sir. Kỹ tóg tỹ imposto kajãm tĩ mũ, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kejẽn Jesus mré mũ tĩ ag tóg ti mỹ vĩ mũ, kỹ ag tóg: “kejẽn ẽg tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ,” he mũ. “Ẽg tỹ ti ve kỹ ũ tỹ hẽ nỹ hỹn ẽg kãfór kar nĩ?” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kỹ Jesus tóg gĩr ũ jé prẽr mũ, kỹ tóg ag kuju kã ti fẽg mũ, gĩr ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kỹ tóg ag mỹ tag tó mũ, ha mẽ. “Gĩr ri ke han nĩ, ãjag tỹ Topẽ tỹ tỹ ẽg pã'i nĩ ve sór kỹ, ke tũ nĩ (mũ) ra ãjag tóg venh ke tũ nĩ. Hã kỹ ãjag jykre tovãnh nĩ, gĩr jykre han jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","“Gĩr pi(jé) ũn sanh kãfór sór nĩ'. Kỹ ti ri ke han nĩ. Jagnẽ kãfór nĩ sór tũg nĩ. “Ũn sĩ vỹ tỹ inh nĩ, gĩr ri ke vỹ tỹ inh nĩ,” hemnĩ, ãjag tỹ kar kỹ tỹ ũn mág kãfór kar nỹtĩ jé, Topẽ tỹ tỹ ẽg pã'i nĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ãjag hã vỹ tỹ inh mré ke nỹtĩ. Ãjag tỹ inh mré ke nỹtĩn tugnĩn gĩr tỹ ge jẽ'ỹn nĩ, to há nỹtĩmnĩ, isugrĩn. Ãjag tỹ isugrĩn ũ tỹ ge to há nỹtĩn kỹ ãjag tóg iso há nỹtĩ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ũn sĩ tag tóg inh ki rã kỹ jẽ. Kejẽn ũ tóg ũn sĩ tỹ inh vĩ mranh han sór mũ. Ẽn jykre vỹ kórég tãvĩ nĩ. Ẽn hã mỹ tóg há nỹnh mũ vẽ, ũ tỹ pó mág tỹ ti nunh to sa kỹ goj nig ki ti fón jé, ti tỹ goj ki ter jé. Jagy tãvĩ tóg tĩ, ũ tỹ gĩr tỹ isovãnh han kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Topẽ vỹ ag ve kónãn pẽ han ke mũ, ag tỹ ũ tỹ iso há nỹtĩ ag krĩn kónãn kỹ. Ag tỹ ag krĩn kónãn kỹ tóg ag tỹ inh vĩ mranh ha mẽ tĩ. Ũ tỹ hẽn ri ke ag tóg ag krĩn kónãn tĩ. Hã ra ag tóg to jagãgtar tãvĩ han ke mũ gé. Topẽ vỹ ag ve kónãn pẽ han ke mũ, ag tỹ ũ krĩn kónãn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ã tỹ nén ũ vóg kỹ Topẽ vĩ mranh kỹ ã nĩgnó kym nĩ, ã tỹ ke mãn tũg jé. Ã tỹ hẽ kã tá tĩg kỹ Topẽ vĩ mranh kỹ ã pẽn kym nĩ, ã tỹ ke mãn tũg jé. Jagy ti nỹ, ã nĩgnó pir ti, ã tĩg vãnh ti ke gé. Ã tỹ nĩgnó régre ra nũgme ki kutẽ kỹ tóg jagy kãfór nĩ, ã tỹ pẽn régre ra inferno ki kutẽn kỹ, pĩ nhyr vãnh ẽn ki kutẽn kỹ mỹr. Ã tỹ rĩr krỹg ja tũ venh ke tóg hã ra há tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Ã tỹ nén ũ ki vẽ'ĩ kỹ Topẽ vĩ mranh kỹ ã kanẽ ũ nám nĩ, ã tỹ ke mãn tũg jé. Jagy ti nỹ, ã kyvó ti. Ã tỹ kanẽ régre ra nũgme ki kutẽ kỹ tóg jagy kãfór nĩ, ã tỹ inferno ki kutẽn kỹ, ã tỹ pĩ nhyr vãnh ẽn ki kutẽn kỹ. Ã tỹ rĩr krỹg ja tũ ẽn ve kỹ tóg hã ra há tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hã kỹ gĩr to é he tũg nĩ. Ũ tỹ ag ki rĩr mũ ag vỹ kanhkã tá nỹtĩ, mỹr, ha mẽ. Topẽ tỹ jẽnẽ jafã ũ ag vẽ, ũ tỹ gĩr ag ki rĩr mũ ag. Inh jóg mré ag tóg nỹtĩ, ti vég ag tóg nỹtĩ, ũ tỹ gĩr ag ki rĩr mũ ag. Hã kỹ gĩr ag to é he tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tỹ sóg ẽprã ke fi kósin nĩ. Ũn vãgfor mũ ẽn ag krenkren han hã jé sóg jun ja nĩ, mỹr, ha mẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Tag to jykrén nĩ. Ũ tóg carneiro tỹ 100 (ke) tỹ mẽg nĩ. Kejẽn ti mẽg pir tóg vãfor ja nĩ. Kỹ tóg ũn pir ẽn kanẽnh tĩ mũ sir, ti jãvãnh tĩ tóg mũ sir. Ti mẽg e ẽn tóg pãnónh tá nỹtĩ. Ag ré kỹ tóg tĩ mũ sir, ũn vãfor mũ ẽn jãvãnh jé, ũn pir ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kỹ tóg ti vég mũ sir. Kỹ tóg ti mỹ sér pẽ tĩ sir, ha mẽ. Ti mẽg e ẽn tóg ti mỹ há nỹtĩ, ũ tỹ 99 (ke) ẽn. Hã ra ti tỹ ũn pir ẽn ve mãn kỹ tóg ti mỹ há tãvĩ nĩ sir, ũn e ẽn tỹ ti mỹ há nỹtĩ kãfór. Kỹ ti fe tóg mrin ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hã kỹ tóg Topẽ mỹ kórég nĩ, ũn sĩ pir vãfor kỹ, ti kren tũ nĩn kỹ, gĩr sĩ pir mỹr. Topẽ pi(jé) tag to há nĩ', inh jóg tỹ kanhkã tá nĩ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kejẽn ã régre vỹ Topẽ vĩ mranh mũ. Kỹ ti venh tĩg nĩ, ã tỹ ti mré vẽmén jé, to. Vyrmỹ ti mré vẽmén vén nĩ. Hẽn ri ke mũn tóg ã vĩ jẽmẽnh mũ, kỹ ã tóg ti kren han mũ sir, ã régre ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ti tỹ ã vĩ jẽmẽ sór tũ nĩn kỹ ũ mỹ: inh mré ti jyvẽn tĩg, hemnĩ, ũn pir mỹ, ke tũ nĩ kỹ ũn régre ag mỹ. Kỹ ti mré vẽmén mãn nĩ, ag rĩnve, ag tỹ ã tỹ ti mré vĩ mẽ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ti tỹ ãjag vĩ mẽ sór tũ nĩn kỹ vẽnh kar mỹ tómnĩ sir, inh mré ke kar ag mỹ. Ti tỹ vẽnh kar vĩ mẽ sór tũ nĩn kỹ ti mré vĩ mãn tũg nĩ sir. “Topẽ vĩ ki kagtĩg ti nĩ, fóg kórég ag ri ke ti nĩ,” hemnĩ ti to. “Topẽ vĩ mranh sór ti mũ, governo mỹ jãnkamy mãg tĩ ag ri ke,” hemnĩ ti to. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ki hã sóg tó mũ, hã kỹ sóg ãjag mỹ ke mũ, ha mẽ. Ãjag tỹ tag ki ũ mỹ: “kanhkã venh ke tũ ã tóg nĩ,” hen kỹ tóg venh ke tũ nĩ. Ãjag tỹ ũ mỹ: “kanhkã ve jé ã tóg ke mũ,” hen kỹ tóg venh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ha mẽ, sỹ ãjag mỹ nén tónh ke mũ ti. Kejẽn ãjag kãmĩ ũn régre ag tóg nén ũ to jykrén, ag tỹ Topẽ mỹ nén to vĩ jé. Kỹ ag tóg ti mỹ nén to vĩ mũ sir. Tỹ ag ẽprã ke nỹtĩ, hã ra ag tóg Topẽ mỹ nén ũ to vĩ mũ. Kỹ inh jóg tỹ kanhkã tá nĩ tóg ag mỹ han ke mũ, ag tỹ nén to vĩ mũ ẽn ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“Kejẽn ãjag kãmĩ ũn régre ag vỹ iso vẽmén tĩ, kejẽn ũn tãgtũ ag. Inh jiji tó jé ag tóg vẽnhmãn kỹ nỹtĩ. Kỹ sóg ag mré nĩ nĩ sir, ag tỹ inh vég tũ ra. Hã kỹ Topẽ tóg ag mỹ han ke mũ, ag tỹ ti mỹ nén to vĩ mũ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kỹ Pedro tóg ti to kãtĩg kỹ ti mỹ: “Senhor,” he mũ. “Kejẽn inh régre tóg vẽnh jykre pãno han ja nĩ. Kỹ inh mỹ ti mỹ vẽnh pãte fón e han mũ'? Vẽnh pãte fón tỹ hẽ ri ke nỹ hỹn há nĩnh mũ? Ke tỹ 7 (ke) mỹ há nĩ'?” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kỹ Jesus tóg ti mỹ: “vó,” he mũ. “Vẽnh pãte fón tỹ 7 (ke) vỹ pir nĩ,” he tóg. “Vẽnh pãte fón tỹ 70 tỹ 7 (ke) vỹ pãgsĩ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ha vé, ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ to comparação ũ vẽ, sỹ tónh ke tag, ha mẽ. Pã'i mág ri ke ti nĩ. Camarada e ti nĩ, pã'i mág ẽn ti. Kỹ tóg kejẽn ag tũ ve sór mũ, ag tỹ ti mỹ név(e) ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kỹ tóg vég mũ. Hã ra ti camarada ũ tóg ti mỹ név(e) mág jẽ, hã vỹ: 10 mil (ke), he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hã ra ti tỹ ne tỹ kajãm ke tóg tũ tĩ, kỹ ti patrão vỹ ti fón sór mũ, jãnkamy to, ti prũ fi ke gé, ti krẽ ke gé, ti tũ kar mỹr, ti tỹ ã kaja to ã név(e) kajãm jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hã ra tóg ti mỹ jagy tĩ, kỹ tóg ti krẽm grĩnh ke kỹ ã jakrĩ tỹ jẽ mũ. Ti krẽm grĩnh ke kỹ tóg ti mỹ: “Senhor,” he mũ. “Ver isovãnh sĩ han, kajãm jé sóg (ke) mũ vãhã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kỹ ti patrão tóg ti jagãgtãn mũ sir, ã camarada ti, kỹ tóg ti tovãnh mũ. Ti mỹ tóg ti név(e) tỹ tũ' he mũ. “Ha tĩg, jatun mỹ,” he tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Kỹ ti camarada ẽn tóg tĩ mũ sir. Kỹ tóg ã mré camarada ũ vég mũ sir. Ti ki tóg név(e) sĩ jẽ, cruzeiro pir mỹr. Kỹ tóg ti mãg mũ sir. Ti nunh kã tóg ti kãgũg mũ, kỹ tóg ti mỹ: “inh mỹ kajãm, ã név(e) ti,” he mũ, ũn név(e) mág ja ẽn ti, ũ tỹ ã mỹ név(e) sĩ ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kỹ tóg ti krẽm grĩnh ke kỹ ã jakrĩ tỹ jẽ mũ. Kỹ tóg ti mỹ: “ver isovãnh, vãhã sóg kajãm kãn ke mũ ha,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hã ra tóg mẽ jãvãnh nĩ. Kỹ tóg vẽse jafã kãtá ti fón mũ sir, ti tỹ ti mỹ kajãm jé, ti név(e) ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hã ra ti mré camarada ũ ag vỹ vég mũ, kỹ tóg ag mỹ e tĩ. Kỹ ag tóg ãjag patrão mỹ tó kãn mũ sir, ti tỹ nén han mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kỹ ti patrão tóg ti jé prẽr mũ sir. Kỹ tóg ti to jũ mũ. “Jykre kórég pẽ han ã,” he tóg. “Ã név(e) mág tỹ sóg tũ' he vẽ, ã tỹ inh mỹ to vĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kỹ ã tỹ ã mré camarada ẽn jagãgtãn ke vẽ vẽ, isỹ ã jagãgtãn ri ke,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kỹ tóg ti to jũ mág han mũ sir, ti patrão ti. Kỹ tóg ti ség mũ. Ag mỹ tóg: “ha ti vóg kónãn,” he mũ gé, ti tỹ ã patrão mỹ kajãm kãn jé, ti név(e) mág ẽn ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Hã han jé tóg ke mũ, inh jóg tỹ kanhkã tá nĩ ti, ãjag tỹ ãjag régre ag mỹ vẽnh pãte fón pẽ han sór tũ nĩn kỹ, ag tỹ kygnẽ ja ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kỹ Jesus tóg tó kãn ja nĩ, ti tỹ ag mỹ nén tó sór mũ ti. Kỹ tóg Galiléia tá kãkutẽ kỹ goj tỹ Jordão mãra tĩ mũ sir. Israel ag jamã ũ vẽ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kỹ ũn e ag tóg ti nón mũ mũ. Kỹ tóg tá ag kygtãg kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kỹ Fariseu ag tóg ti tá junjun mũ gé sir. Ag tỹ ón kỹ ti vẽme mẽ sór vẽ, vẽnh prũ ke fón to. Kỹ ag tóg ti mỹ: “mỹ ẽg tỹ nén ũ ũ to ẽg prũ fag fón jé há nĩ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Kỹ tóg ag mỹ kãmén mũ. “Topẽ vĩ rá ki vemnĩ,” he tóg. “Tá tóg rán kỹ nĩ, Topẽ tỹ nén han mũ ti. Ti tỹ nén kar han ve ki tóg ti mré fi han. Hã kỹ tóg tag tó mũ, ha mẽ. “Hã kỹ ũn gré tóg ã prũ fi to ã panh ré kỹ tĩnh mũ, ã mỹnh fi ré kỹ ke gé. Ã prũ fi mré tóg tĩnh mũ. Fi mré tóg tỹ ũn pir nĩ sir, ã prũ fi mré,” he tóg, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hã kỹ fag tóg tỹ ũn pir nỹtĩ. Fag pi(jé) tỹ ũn régre nỹtĩ'. Hã kỹ fag tỹ vẽnh kãpãm tũg nĩ. Topẽ tỹ fag tỹ ũn pir han vẽ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kỹ ag tóg ti mỹ ke mãn mũ. “Hã ra Moisés tóg ẽg mỹ: “fi mỹ vẽnh rá nĩm kar kỹ fi fón nĩ,” he ja nĩ. Ti tỹ ne jé ẽg mỹ tag tó ja nẽ?” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Kỹ tóg ag mỹ: “hỹ,” he mũ. “Tag tó ja ti nĩ, ãjag mỹ, ãjag tỹ vẽnh kanhrãn sór tũ nỹtĩn kỹ, hã kỹ tóg ãjag mỹ: ha fi fón ge, he ja nĩ. Hã ra Topẽ tóg tag han ja tũ nĩ, ti tỹ nén kar han ve ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hã kỹ sóg ãjag mỹ ke mũ. Ãjag tỹ ãjag prũ fi fón kỹ ũ fi tỹ prũg mãn kỹ ãjag prũ tũ fi vẽ sir, ha mẽ. Ãjag tỹ fi tỹ ũ mré nỹ tugrĩn fi fón kỹ tag hã ne pãgsĩ nỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kỹ ti mré mũ tĩ ag mỹ tóg e tĩ, ti vĩ tag, hã kỹ ag tóg ti mỹ: “ge nĩn kỹ tóg tỹ ũ nỹ, ẽg prũg kỹ,” he mũ. “Ẽg tỹ ẽg prũ fi fón sór mũ ra fi fón tũ nĩn kỹ tóg vẽnhmỹ nỹ, kỹ ẽg hỹn prũg sór tũ nĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kỹ tóg ag mỹ: “ũn pipir ag tóg tag han ke mũ,” he mũ. “Topẽ tóg ũ ag mỹ: ha prũg tũg, henh ke mũ, ẽn ag hã vỹ prũg ke tũ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","“Ũ ag tóg kurĩ nỹtĩ, ag mur mũ kã. Kỹ ũ ag tóg kurĩ nỹtĩ gé, ag tỹ ag grãfy kym kỹ. Kỹ ũ ag tóg kurĩ ri ke nỹtĩ gé, ag tỹ Topẽ to jykrén kỹ, ag tỹ ũ tỹ kanhkã tá nĩ ẽn tugrĩn prũg sór tũ nỹtĩn kỹ. Ũ tỹ to jykrén mũ ẽn jé to jykrén,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kỹ fag tóg gĩr tatĩ kãmũ mũ, ti tỹ ã nĩgé tỹ ag mẽ jé, ti tỹ ag to Topẽ mré vĩ jé. Hã ra Jesus mré mũ tĩ ag tóg fag to jũ mũ, ũ tỹ ag tatĩ kãmũ mũ fag to. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hã ra Jesus tóg ag mỹ: “vĩ tũg nĩ, gĩr ag mỹ,” he mũ, “gĩr ag tỹ iso kãmũ kamẽg tũg nĩ,” he tóg. “Ũ tỹ ge hã vỹ ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ pã'i nĩ ẽn krẽm nỹtĩ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kỹ tóg ag mẽgmẽ kãn mũ sir, ã nĩgé tỹ. Ag mẽgmẽ kãn kỹ tóg tá kãkutẽ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kỹ vãhã ũ tóg ti tá jun mũ sir. Kỹ tóg ti mỹ: “Senhor,” he mũ. “Há ã tóg jẽ,” he tóg. “Sỹ inh rĩr krỹg ja tũ venh há tóg tĩ. Ti ve jé inh hỹn vẽnh jykre há tỹ hẽ ri ke han ke mũ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kỹ Jesus tóg ti mỹ: “ã tỹ ne jé inh ki vẽnh jykre há jẽmẽ sór nẽ?” he mũ. “Ũn pir tóg há nĩ, ha mẽ. Ti tỹ ẽg jyvẽn ẽn ki króm nĩ, ã tỹ rĩr krỹg ja tũ ve sór kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kỹ tóg ti mỹ: “ti tỹ ẽg jyvẽn tỹ hẽ ri ke nẽ?” he mũ. Kỹ Jesus tóg ti mỹ: “ti tỹ ẽg jyvẽn tag hã vẽ, ha mẽ: ũ tén tũg nĩ, ã prũ tũ fi mré nỹ tũg nĩ, nén ũ péju(g) tũg nĩ, ũ to ón tũg nĩ, ");
INSERT INTO kgpNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ã nỹ mré ã jóg kamẽg nĩ, ã régre ki rĩr há han nĩ, ã tỹ vẽnh ki rĩr há ri ke han nĩ, ã régre ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kỹ kyrũ tóg ti mỹ: “tag kar ki sóg króm tĩ,” he mũ. “Kỹ ne nỹ hỹn ver inh mỹ tũ tĩ'?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kỹ Jesus tóg ti mỹ: “ã tỹ vẽnh jykre há han sór kỹ tag han nĩ, ha mẽ,” he mũ. “Ã tũ kar vãm tĩg. Kỹ ũn jagãgtar ag mỹ vin, jãnkamy ti, kỹ ã tóg kanhkã tá tũ mág nĩ sir. Kar kãtĩg nĩ, ã tỹ inh mré tĩg jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kyrũ ẽn tỹ ti vĩ tag mẽ kỹ tóg fe kaj han kỹ tĩ mũ sir. Ti tũ vỹ e nỹtĩ, hã kỹ tóg ti mỹ vẽnhmỹ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kỹ Jesus tóg ã mré mũ tĩ ag mỹ kãmén mũ sir. “Sỹ ke há vẽ, hã kỹ sóg ke mũ. Jagy ti nỹ, ũn rico tỹ ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ venh ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","“Hã kỹ sóg ãjag mỹ ke mãn mũ. Cavalo pãnĩ sór vỹ préj nor fĩn kutẽ tũ nĩ mỹr,” he tóg. “Ti tỹ fĩn kutẽ há nĩ ra tóg ver jagy tĩ vẽ, ũn rico tỹ ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ venh ke ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kỹ tóg ti mré mũ tĩ ag mỹ e tĩ, ti vĩ tag. Kỹ ag kanẽ tóg jur mũ. “Kỹ ũ hỹn kren ke tũ nĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kỹ Jesus tóg ag ki ẽvãnh mũ, kỹ tóg ag mỹ: “ẽprã ke ag vỹ vẽsóg ki tá jun ke tũ nĩ,” he mũ. “Topẽ hã tóg ãjag tỹ tá jun han ki kanhró nĩ, ti tỹ nén ũ kar tỹ hẽ ri ken há nĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kỹ Pedro tóg ti mỹ: “ha vé,” he mũ. “Nén kar ré kỹ ẽg mũ mũ, ã mré. Tag to ẽg hỹn ne venh ke mũ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kỹ Jesus tóg ag mỹ: “sỹ ke há vẽ, hã kỹ sóg tó mũ,” he mũ. “Inh mré ãjag tóg mũ mũ. Tỹ sóg ẽprã ke fi kósin nĩ. Kejẽn sóg inh nĩgja kri nĩnh mũ, isỹ vẽnh kar jykre tugnỹm jé. Sĩnvĩ inh nĩnh mũ, kurã ẽn kã. Nén kar han mãn jé sóg ke mũ, kurã ẽn kã. Kỹ ãjag tóg ãjag nĩgja kri nĩgnĩg kỹ nỹtĩnh mũ gé, nĩgja tỹ 12 (ke) kri, ãjag tỹ povo tỹ Israel kar jykre tugnỹm jé, povo tỹ 12 (ke) tag ag jykre,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Jó ũ tóg isugrĩn ã jamã ré kỹ tĩ mũ, ã kãke, ã jãvy, ã ve, ã panh, ã mỹnh, ã japỹ ré kỹ tóg tĩ mũ, inh jykre tugrĩn. Ẽn vỹ tóg vẽnh kato ã tỹ ẽprã ré kỹ tĩg ja ẽn e ri ke venh ke mũ, tag ki, ẽprã. Kỹ tóg rĩr krỹg ja tũ ẽn venh ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Jãvo tag ki ũn mág ũ ag kãsir nỹtĩnh ke vẽ, tá tére kỹ, kỹ tag ki ũn kãsir ũ ag tỹ tỹ ũn mág nỹtĩnh ke vẽ, tá tỹ pã'i nĩnh ke vẽ,” he tóg, Jesus ti. Ti tỹ ag mỹ kanhkã jykre tó vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kỹ Jesus tóg ag mỹ: “ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ vỹ ge nĩ, ha mẽ,” he mũ, to comparação han kỹ. “Patrão ri ke tóg nĩ. Kusã ki tóg tĩ mũ, 6 horas ki, camarada ag jãvãnh jé, ag tỹ ti jakré ki rĩr jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kỹ tóg ũ ag vég mũ sir. Ag mré tóg vẽnh rãnhrãj kaja to jykrén mũ, hã vỹ: jãnkamy pir, he mũ, por dia kaja ti. Kỹ tóg ag mỹ: “ha ki rĩr mũjẽg,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kỹ ag tóg mũ mũ. Hora tãgtũ tũg kỹ, 9 horas ki tóg tĩg mãn mũ, ũ ag jãvãnh jé gé. Kỹ tóg ũ ag vég mũ gé sir. Véké ag tóg ẽmã kuju tá nỹtĩ, rãnhrãj tũ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kỹ tóg ag mỹ: “inh mỹ inh jakré ki rĩr mũjẽg,” he mũ gé. “Kajãm jé sóg ke mũ, ti kaja tỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kỹ ag tóg mũ mũ. Hora tãgtũ ũ tũg kỹ, meio dia ki tóg ũ ag jãvãnh tĩg mãn mũ, 3 horas ki tóg tĩg mãn mũ gé. Ag ve kỹ tóg ag mỹ ke mũ gé, kỹ ag tóg mũ mũ gé, ti jakré ki rĩr jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Vãhã tóg rãkãnh mũ sir. 5 horas ki tĩg mãn kỹ tóg ũ ag vég mũ gé, véké jẽgjẽ kỹ nỹtĩ ag. Kỹ tóg ag mỹ: “ãjag tỹ ne jé rãnhrãj tũ nĩ nẽ?” he mũ. “Kurã kar ki ãjag tóg ki nỹtĩ, rãnhrãj tũ nỹtĩ ra,” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kỹ ag tóg ti mỹ: “hã ra ũ tóg ẽg mỹ: ha inh rãnhrãj han, he ja tũ nĩ,” he mũ. Kỹ tóg ag mỹ: “ha inh jakré ki rĩr mũjẽg ge,” he mũ sir. Kỹ ag tóg mũ mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kuty kỹ ag patrão tóg ã tũ ki rĩr tĩ ẽn mỹ: “ha ag jé prẽr,” he mũ, 6 horas da tarde ki. “Ag mỹ ti kaja ti nĩm,” he tóg. “Ũn tỹ rãkãnh kỹ kãmũ mũ ag mỹ nĩm vén, kar kỹ ũ tỹ kusã ki kãmũ mũ ag mỹ nĩm rén,” he tóg ti mỹ. Kỹ tóg ke mũ, ti tũ ki rĩr tĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kỹ ũ tỹ rãkãnh kỹ junjun mũ ag vỹ ãjag kaja ti mãn mũ, hã vỹ: jãnkamy pir, he mũ. Ag rãnhrãj sĩ ra ag tóg por dia kaja vég mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kỹ ũ tỹ kusã ki rãnhrãj mũ ag tóg to jykrén mũ. “Ti hỹn ẽg mỹ ti kaja kãfór han ke mũ, ẽg tỹ kurã kar ki rãnhrãj kỹ,” he ag tóg mũ, to jykrén kỹ. Hã ra tóg ag mỹ jãnkamy pir ẽn nĩm mũ gé sir, por dia kaja ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ag tỹ jãnkamy ẽn mãn kỹ ag tóg ti to jũ mũ, ãjag patrão to. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kỹ ag tóg ti mỹ vĩ mũ. “Tag ag vỹ hora pir ki rãnhrãj, jãvo ã tóg ag mỹ ẽg kaja ri ke han. Kurã kar ki ẽg tóg rãnhrãj mỹr, to ẽg ron, ti rỹ jagy ra ẽg tóg to krónh ke ja tũ nĩ,” he ag tóg, ãjag patrão mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kỹ tóg ag kãmĩ ũ mỹ ke mũ, ag patrão ti. “Sỹ ã ki kygnẽ pijé',” he tóg. “Inh mré ã tóg jãnkamy pir to jykrén ja nĩ, hã kỹ sóg ã mỹ nĩm mũ, jãnkamy pir ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kỹ ã tũ mãn kỹ tĩg. Hã ra sóg ag mỹ nĩm sór mũ gé, sỹ ã mỹ nĩm ja ẽn ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Isũ vẽ mỹr, jãnkamy ti, kỹ sóg sỹ tỹ nén han sór mũ ẽn han mũ. Ã mỹ jũ', isỹ ag mỹ vĩ há han to?” he tóg ti mỹ, patrão ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Hã kỹ ẽgno tá kãmũ ag vỹ ũn kãmũ vén mũ ag ri ke nỹtĩnh mũ, tãpry kỹ, jãvo ũn kãmũ vén mũ ag vỹ ẽgno tá kãmũ mũ ag ri ke nỹtĩnh mũ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kỹ Jesus tóg Jerusalém ra tĩg sór mũ. Kỹ tóg vyrmỹ ũ tỹ 12 (ke) ẽn ag mré vẽmén mũ. Ag tỹ ã mré ẽpry jagma mũn kỹ tóg ag mré vẽmén mũ, ag tỹ ẽmĩn jagma mũn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ha vé,” he tóg. “Jerusalém ra ẽg tóg mũ mũ,” he tóg. “Ẽprã ke fi kósin ẽn vỹ jagtar ke mũ. Inh hã vẽ. Topẽ tũ ki rĩr tĩ to pã'i ag tóg ãjag tỹ isỹ nén han sór mũ ẽn han ke mũ, Topẽ vĩ to professor ag ke gé. Ag tỹ iso: “ter jé tóg ke mũ,” henh ke vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kỹ ag tóg fóg ag mỹ inh fẽg ke mũ sir, ẽn ag tỹ iso é he jé, ag tỹ inh mrãnmrãn jé, ag tỹ ka to isa jé. Kurã tãgtũ ki sóg hã ra rĩr mãn ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kỹ Zebedeu krẽ ag mỹnh fi tóg Jesus venh kãtĩ mũ, fi krẽ ag mré. Ti krẽm fi tóg mũg ke mũ, fi tỹ ti mỹ nén (ũ) to vĩ sór kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kỹ tóg fi mỹ: “ã tỹ ne to vĩ sór nẽ?” he mũ. Kỹ fi tóg ti mỹ: “kejẽn ã tóg tỹ pã'i nĩnh mũ,” he mũ. “Kỹ inh krẽ tag ag tỹ ã rã hã nỹtĩnh há tóg tĩ, ũ tỹ ã pẽgja tá nĩ jé, kỹ ũ tỹ ã jakãnh tá nĩ jé,” he fi tóg, ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kỹ Jesus tóg ag mỹ: “ãjag tỹ nén to vĩ mũ ki kagtĩg ãjag tóg nỹtĩ,” he mũ. “Jagy ti nỹ. Ãjag mỹ inh ri kén jagtar sór mũ'? Ãjag mỹ tovãnh ke tũ nĩ'?” he tóg. Kỹ ag tóg ti mỹ: “hỹ,” he mũ. “Tovãnh ke tũ ẽg nĩ,” he ag tóg, ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kỹ tóg ag mỹ: “hỹ, jagãgtar jé ãjag tóg ke mũ, inh ri kén,” he mũ. “Hã ra isũ tũ vẽ, sỹ ãjag mỹ: hej, he ti,” he tóg. “Ha inh pẽgja tá nĩ, henh ke tũ sóg nĩ. Ha inh jakãnh tá nĩ, henh ke tũ sóg nĩ gé, isũ tũ vẽ. Topẽ tỹ ũn mỹ: ha ti rã hã nỹtĩ, henh ke mũ ẽn ag hã tỹ inh rã hã nỹtĩnh ke vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hã ra ũ tỹ 10 (ke) ag tóg mẽg mũ, ũn régre ag tỹ Jesus mỹ tag to vĩ ja ti. Kỹ ag tóg ag to jũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hã ra Jesus tóg ag jé prẽr kãn mũ, kỹ tóg ag mỹ: “fóg ag pã'i ag jykre ki kanhró ãjag tóg nỹtĩ,” he mũ. “Vẽnh kar jẽgnẽg ag tóg tĩ mỹr, kỹ ag mág ag tóg vẽnh kar mỹ: gemnĩ, ge tũg nĩ, he tĩ, vĩ tar han kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","“Ag ri ke han tũg nĩ. Ãjag mỹ tỹ ũn mág nỹtĩ sór mũ'? Kỹ tỹ jagnẽ camarada ri ke nỹtĩmnĩ, jagnẽ tũ ki rĩr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ãjag mỹ tỹ pã'i nỹtĩ sór mũ'? Kỹ tỹ jagnẽ krẽm ke nỹtĩmnĩ, tỹ ũn kãsir nỹtĩmnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hã kỹ sóg camarada tũ nĩ gé. Sỹ tỹ camarada nĩ jé sóg kãtĩg, sỹ ãjag ki rĩr jé. Tỹ sóg ẽprã ke fi kósin nĩ. Hã kỹ sóg vẽnh kar jagfy ter ke mũ, sỹ ag krenkren han jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Hã ki ag tóg Jerusalém ra mũ mũ. Kejẽn ag tóg cidade tỹ Jericó fĩn rãm kỹ ag tóg tá pa mũ, hã ra ũ tỹ hẽn ri ke ag tóg Jesus nón mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ẽpry ẽn tá, ẽmĩn ẽn tá ũn kyvó ag tóg nĩgnĩ kỹ nỹtĩ nĩ, ũn régre ag. Vãhã ag tóg Jesus tỹ jagma tĩg mẽg mũ. Kỹ ag tóg ti jé prẽr mũ. “!..Senhor..!” he ag tóg. “!..Davi kósin', ẽg jagãgtãn ra..!” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kỹ ag tóg ag to jũgjũ mũ, ti nón mũ ũ ag. “Mẽ kã nỹtĩ,” he ag tóg mũ. Hã ra ag tóg prẽr mãn', prẽr mãn' he mũ, jamã hár(a). “!..Senhor, Davi kósin', ẽg jagãgtãn ra..!” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kỹ Jesus tóg krỹg he mũ, kỹ tóg ag jé prẽr mũ. Kỹ tóg ag mỹ: “ne to ãjag vĩ, sỹ ãjag mỹ han jé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kỹ ag tóg ti mỹ: “ẽg tỹ ẽvãnh há tóg tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kỹ Jesus tóg ag jagãgtãn mũ sir. Ag kanẽ mẽgmẽg tóg mũ sir. Kỹ ag tóg ẽvãnh há han mũ sir. Ti nón ag tóg mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ag mũn kỹ ag tóg Jerusalém kakó tá junjun mũ, ẽmã tỹ Betfagé tá, krĩ tỹ Oliveiras tá. Kỹ Jesus tóg ã mré mũ tĩ régre ag jẽgnẽg mũ, ẽmã ẽn ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kỹ tóg ag mỹ: “ẽmã ẽn ra mũjẽg, ẽg jo ẽmã nĩ ẽn ra,” he mũ. “Tá ãjag tóg burrica fi venh mũ. Se kỹ fi jẽ. Fi kósin vỹ fi mré jẽ nĩ. Ẽn fi kavãn kỹ fi pére kãmũmnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hẽn ri ke mũn ag tóg ãjag mỹ vĩ sór mũ, fi to. Kỹ ag mỹ: “ẽg Senhor vỹ fi ve sĩ han sór mũ. Kãnhmar tóg fi jẽnẽ mãn mũ,” hemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hã ra tóg rán kỹ nĩ gé, tag. Topẽ vĩ tó tĩ tóg tag rán ja nĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sião tá ke fag mỹ tag tómnĩ, ha mẽ. Hã vé, ã pã'i tỹ rei tóg ã ki jun ke mũ, hemnĩ. Vẽnh kar to tóg fe há nĩ, jũ vãnh nĩn kỹ, ã Senhor ti. Burrica kri tóg nĩ nĩ, fi kósin kri, ẽg tu tĩ ẽn fi kósin kri mỹr,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki. Hã ra tóg ge nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kỹ ti mré mũ tĩ ag tóg mũ mũ, burrica fi mãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Fi pére ag tóg kãmũ mũ, fi kósin mré. Kỹ ag tóg ãjag kur tỹ kri vãm mũ, kỹ tóg kri nĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kỹ vẽnh e ẽn ag tóg ãjag kur tỹ ẽpry kri kugjén mũ, ẽmĩn kri. Kỹ ũ ag tóg ka féj kre kỹ ẽpry kri vãvãm mũ sir. Ag tỹ ti jamĩn sĩnvĩ han sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kỹ ũ ag tóg ti jãmĩ mũ mũ, jo ũ ag ti nón mũ mũ. Ẽn ag tóg prẽnprẽr mũ sir. “!..Viva, Davi kósin..!” he ag tóg mũ. “!..Sér tóg tĩ, pã'i vỹ ẽg tá jun, ẽg Senhor mág tỹ ti jẽnẽn kỹ..! !..Topẽ tá tóg kãtĩg, ũ tỹ kynhmỹ nĩ ẽn tá, viva..!” he ag tóg, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hã ki ag tóg Jerusalém tá junjun mũ. Kỹ tá ke kar ag vỹ ti venh kãmũ mũ. Ag mỹ tóg e tĩ, kỹ ag tóg ti to: “ũ nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kỹ ti mré kãmũ mũ ag vỹ ag mỹ: “Topẽ vĩ tó tĩ ẽn vẽ,” he mũ. “Jesus vẽ, Nazaré tá ke ẽn vẽ, Galiléia tá ke ẽn,” he ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kỹ Jesus tóg Topẽ jo ĩn kãra rã mũ. Kỹ tóg tá ke ag pan kãn mũ sir, nén vender he tĩ ag, nén comprar he tĩ ag ke gé. Topẽ jo ĩn krẽm ag tóg negociar he tĩ, jãnkamy trocar he ag tóg tĩ gé. Ag tỹ nén kri vin jafã tỹ tóg vyryn ke mũ sir. Sórãg vender he tĩ ag nĩgnĩ jafã tỹ tóg vyryn ke mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ag mỹ tóg: “Topẽ vĩ rá to jykrén nĩ,” he mũ. “Tag vỹ rán kỹ nĩ, ha mẽ. “Inh ĩn jiji vỹ tỹ Topẽ mré vĩ jafã nĩ,” he tóg, Topẽ vĩ rá ki. Hã ra ãjag tóg Topẽ mré vĩ jafã tag krẽm nén kar pigju(g) mũgtĩ, kỹ tóg bandido ag jamã ri ke nĩ sir,” he tóg, Jesus ti. Ag pan kỹ tóg ke mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kỹ ũn kyvó ag tóg ti to junjun mũ sir, ũn kónhgrĩ ag ke gé, ti tỹ Topẽ jo ĩn krẽm jẽn kỹ. Kỹ tóg ag tỹ há' he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hã ra Topẽ tũ ki rĩr tĩ ag tóg tá nỹtĩ, Topẽ vĩ to professor ag ke gé. Ti tỹ ag tỹ há' he vég ag tóg mũ. Gĩr ag vĩ mẽg ag tóg mũ gé. Topẽ jo ĩn krẽm ag tóg nỹtĩ, gĩr ag, kỹ ag tóg Jesus mỹ prẽnprẽr mũ. “!..Viva, Davi kósin..!” he ag tóg mũ, prẽnprẽr kỹ. Kỹ pã'i ag tóg jũgjũ mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hã kỹ ag tóg ti mỹ vĩ mũ. “Ã mỹ ag prẽnprẽr mẽg tũ?” he ag tóg. Kỹ Jesus tóg ag mỹ: “vó,” he mũ. “Hã ra Topẽ vĩ rá to jykrén nĩ,” he tóg. “Ũn kãsir ag vỹ iso vĩ há han tĩ,” he tóg, Topẽ vĩ ki. “Ũn pafa mũ ag vỹ inh mỹ vĩ há pẽ han tĩ. Ã hã ne tag han', ũn kãsir ag tỹ inh mỹ vĩ há han jé,” he tóg, Topẽ mỹ, Topẽ vĩ tỹ rán kỹ nĩ ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Tag tó kỹ tóg ag ré kỹ tĩ mũ sir. Cidade tá tóg kãkutẽ mũ, ẽmã tỹ Betfagé ra tĩg jé. Tá tóg sir nũr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tỹ vaj kỹ kusã ki tóg cidade ra tĩg mãn mũ. Ã tĩg kỹ tóg kókĩr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kỹ tóg ka tỹ figueira vég mũ sir, kỹ tóg ra tĩ mũ, ti kanẽ ko jé. Hã ra tóg kanẽ tũ nĩ. Féj tãvĩ tóg jẽ, kỹ tóg ti mỹ vĩ mũ. “Kanẽ han mãn ke tũ ã nĩ ha,” he tóg mũ. Kỹ tóg tóg mũ sir vẽsỹmér, ka ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kỹ ti mré mũ tĩ ag tóg vég mũ sir, ti tóg mũ ti. Kỹ tóg ag mỹ e tĩ. “Vẽsỹmér tóg tóg ja nĩ,” he ag tóg. “Ti hẽ ri ké?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kỹ Jesus tóg ag mỹ kãmén mũ sir. “Ki hã sóg tó mũ, hã kỹ sóg ke mũ,” he tóg. “Inh ri ke han jé ãjag tóg ke mũ. Isỹ ka tỹ figueira mỹ: “tóg ra,” hen kỹ tóg tóg ja nĩ. Inh vĩ tag ri ke han jé ãjag tóg ke mũ, ãjag tỹ inh ki ge há han kỹ. Hã ra to: “Topẽ mỹ inh vĩ mẽg mũ vỹ?” he tũg nĩ. “Hỹ mỹ vỹ?” he tũg nĩ. Kỹ ãjag tỹ kejẽn pãnónh mỹ: ha kutẽ, goj nig ki, hen kỹ tóg kutẽ mũ, ãjag tỹ ti kutẽnh ke to: “hỹ mỹ vỹ?” he tũ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kỹ ãjag tỹ Topẽ mỹ nén ũ to vĩn kỹ to: “han jé tóg ke mũ,” hemnĩ. Kỹ tóg ãjag mỹ han mũ, ãjag tỹ ti mỹ nén to vĩ mũ ẽn ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kỹ tóg cidade tá jun kỹ (tóg) Topẽ jo ĩn kãra rã mãn mũ sir. Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag vỹ ti to kãmũ mũ, kófa ag mré hã. Ag tỹ ti ki jẽmẽ sór vẽ, hã kỹ ag tóg ti mỹ: “ũ nỹ ã mỹ: tag han nĩ, hé?” he mũ. “Ũ nỹ ã jẽnẽ?” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kỹ Jesus tóg ag mỹ: “ãjag ki sóg jẽmẽnh ke mũ gé, vẽnh kato,” he mũ. “Ãjag tỹ inh mỹ tó há han kỹ sóg ãjag mỹ ũ tỹ inh jẽnẽg mũ tónh ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“João vỹ ag kygpég tĩ ja nĩgtĩ. Kỹ ti mỹ kanhkã tá vẽnh jykre han ja nĩgtĩ', ẽprã vẽnh jykre vó? Ũ nỹ ti jẽnẽ?” he tóg, Jesus ti. Kỹ ag tóg ti vĩ to jykrén mũ jagnẽ mré. “Ẽg tỹ ti mỹ: Topẽ tỹ ti jẽnẽ ja vẽ, hen kỹ tóg ẽg mỹ: kỹ ãjag tỹ ne jé ti vĩ kri fig tũ nĩ nẽ? henh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ẽg tỹ hã ra ti mỹ: ẽprã ke jykre ja vẽ, hen kỹ ẽg tóg vẽnh kar kato tẽ mũ sir. Ag kar vỹ João to: Topẽ vĩ tó tĩ pẽ ja vẽ, he tĩ. Kỹ ẽg tóg ag kamẽg mũ, vẽnh e ẽn,” he ag tóg mũ, jagnẽ mỹ, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","To jykrén kỹ ag tóg Jesus mỹ: “ẽg pi(jé) João jykre ki kanhró nỹtĩ',” he mũ. Ón kỹ ag tóg ke mũ. Kỹ tóg ag mỹ: “kỹ sóg ãjag mỹ tónh ke tũ nĩ gé, ũ tỹ inh jẽnẽg mũ ti,” he mũ. Ã kato tẽ mũ ag mỹ tóg ke mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kỹ tóg ag kanhrãn kỹ ag mỹ: “tag to jykrén nĩ, ha mẽ,” he mũ sir. “Ũ tóg kósin régre nĩ. Kejẽn tóg ũn sanh to tĩg kỹ ti mỹ: “inh kósin,” he mũ. “Ũri inh jakré tugnỹgnỹm tĩg,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kỹ tóg ã panh ti mỹ: “vó,” he mũ. Kar kỹ tóg to jykrén mãn kỹ (tóg) tĩ mũ sir, ẽpỹ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kỹ ti panh tóg ti jãvy mỹ ke mũ gé sir. “Ũri inh jakré tugnỹgnỹm tĩg,” he tóg mũ gé. Kỹ ti jãvy tóg: “hej,” he mũ, ã panh ti mỹ. Hã ra tóg tĩ tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kỹ ũ tỹ hẽ nỹ ti panh vĩ ki króm hỹn?” he tóg, Jesus ti. Kỹ ag tóg ti mỹ: “ũn sanh ti,” he mũ. Kỹ Jesus tóg ag mỹ: “hỹ, hã vẽ,” he mũ. “Hã kỹ sóg ãjag mỹ ke mũ. Ũ tỹ governo mỹ jãnkamy mãg tĩ ũ ag vỹ Topẽ vĩ mranh, hã ra ag tóg to jykrén mãn kỹ (ag tóg) ãjag jykre tovãnh. Kỹ ũn mén e ũ fag vỹ ãjag jykre kórég tovãnh gé. Hã kỹ ag tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ, fag ke gé. Ti kósin sanh ri ke ag hã vẽ. Ag jãvo ãjag tóg kanhkã venh ke tũ nĩ, ãjag tỹ ón kỹ Topẽ mỹ: “hej,” he mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","João vỹ ãjag mỹ Topẽ vĩ tó ja nĩgtĩ, ãjag tỹ ti jykre kuryj jagma mũ jé. Hã ra ãjag tóg ti vĩ kri nĩm ja tũ nĩ. Ãjag jãvo ũ tỹ governo mỹ jãnkamy mãg tĩ ag vỹ ti vĩ kri fi ja nĩ, ũn mén e fag ke gé. Tag ve ãjag mỹr. Ge ra ãjag tóg ãjag jykre tovãnh tũ nĩ, João vĩ kri nĩm tũ ãjag nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kỹ Jesus tóg ag mỹ: “sỹ ãjag mỹ ãjag tỹ Topẽ tovãnh to comparação han mãn ke vẽ, ha mẽ,” he mũ. “Kejẽn ũ tóg nĩgtĩ. Uva krãn tóg nĩgtĩ, nén kanẽ tỹ vinho han jafã ẽn. Ã jakré tag to tóg rón mũ. Kỹ tóg kũm kỹ uva jẽgmĩ jafã han mũ. Kỹ tóg ki pãjó han mũ gé. Kỹ tóg ũ tỹ ki rĩr tĩ ag mỹ tovãnh mũ, ag tỹ ti mré ti kanẽ vẽnh kãpãm jé. Kỹ tóg tĩ mũ, ga ũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ti kanẽn kỹ tóg ã camarada ag jẽgnẽg mũ, ag tỹ ag mỹ ti tũ vin jé, uva kanẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hã ra ag tóg ag vóg kónãn mũ sir, ti camarada ag. Ũ mrãnmrãn ag tóg mũ, ũ tén ag tóg mũ, ũ pin ag tóg mũ, pó tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kỹ tóg ag mỹ ã camarada ũ ag jẽgnẽ mãn mũ gé sir, ũn e ag sir, hã ra ag tóg ag vóg kónãn kãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Vãhã tóg ag mỹ ã kósin jẽnẽg mũ. “Ag hỹn ti kamẽg mũ, inh kósin ti,” he tóg, hã kỹ tóg ti jẽnẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kỹ ag tóg ti vég mũ, ti kósin ti. Kỹ ag tóg jagnẽ mỹ: “kejẽn ẽkré tag vỹ tỹ ti tũ nĩnh ke mũ,” he mũ. “Mũ nỹ, ti tén jé, ti tũ tag tỹ tỹ ẽg tũ nỹnh jé,” he ag tóg mũ, patrão kósin to. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kỹ ag tóg ti kãgmĩg mũ sir. Ró pãte ag tóg ti kutẽm kỹ (ag tóg) ti tén mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kejẽn ag patrão vỹ kãtĩg ke mũ, ũ tỹ nén krãn ja ẽn. Kỹn hỹn hẽ ri kenh mũ, ã camarada ag tỹ?” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kỹ ũ tỹ ti vĩ mẽg mũ ag tóg ti mỹ: “vẽnh jykre pãno han ag tóg mũ mỹr, uva ki rĩr tĩ ag,” he mũ. “Ag kãgtén jé tóg ke mũ, jũ kỹ, ag patrão ti, kỹ tóg uva kré ẽn tỹ ũ mỹ tovãnh ke mũ, ag tỹ ti mré vẽnh kãpãm jé, ti kanẽ ti,” he ag tóg ti mỹ. Ũ tỹ ti vĩ mẽg mũ ag tóg ke mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kỹ tóg ag mỹ: “hỹ,” he mũ. “Kỹ Topẽ vĩ rá tag to jykrén nĩ gé, ha mẽ: pó tỹ ĩn han jafã fón ag tóg, pó tỹ ĩn han tĩ ag. Ag mỹ tóg kórég ja nĩ, pó ẽn ti. Hã ra Topẽ tóg pó ẽn hã tỹ ĩn nũna han mũ. Ẽg Senhor mág tỹ há vẽ mỹr, hã kỹ tóg ẽg mỹ e tĩ, ẽg tỹ ve kỹ,” he ja tóg nĩ, Topẽ vĩ rá ki,” he tóg, Jesus ti, vẽso pó tỹ comparação ũ han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Hã kỹ sóg ãjag mỹ ke mũ. Ãjag tỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke vẽ vẽ, hã ra ãjag tóg venh ke tũ nĩ. Ũ ag vỹ venh ke mũ, povo ũ ag, ag tỹ inh vĩ kri fi kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Ũ tỹ hẽn ri ke ag vỹ pó tag kri vár ke mũ, kỹ ag tóg kri vár kỹ tũ' henh ke mũ. Kỹ pó tag vỹ ũ tỹ hẽn ri ke ag kri kutẽnh ke mũ gé, kỹ tóg ag tỹ námnám ke kãn mũ, ag kri kutẽ kỹ,” he tóg, Jesus ti. Ti tỹ ag tỹ ti ki rã tũ tugrĩn nũgme ki vár ke tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kỹ ag tóg mẽg mũ sir, Jesus vĩ ti. Topẽ tũ ki rĩr tĩ to pã'i ag vỹ mẽg mũ, Fariseu ag ke gé. Mẽ kỹ ag tóg vãhã to jykrén mũ sir. “Ẽg hã to tóg uva ki rĩr tĩ kórég ag to comparação tag han ja nĩ,” he ag tóg mũ sir, ki kanhrãn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hã kỹ ag tóg ti se sór mũ. Hã ra ag tóg vẽnh e ẽn kamẽg mũ. “Topẽ vĩ tó tĩ pẽ vẽ,” he ag tóg, Jesus to, vẽnh e ẽn, hã kỹ pã'i ag tóg povo ẽn ag kamẽg kỹ ti ség tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kỹ Jesus tóg ag mỹ comparação ũ han mãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ vỹ ge nĩ, ha mẽ,” he tóg. “Tỹ tóg pã'i mág ri ke nĩ. Ti kósin prũg ken kỹ tóg to festa mág han sór mũ, pã'i mág ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Hã kỹ tóg ã camarada ag jẽgnẽg mũ, ag tỹ ti tỹ ũn mỹ tó ja ag mỹ: “ha kãmũ jẽg, festa kon jé,” he jé. Hã ra ag tóg kãmũ jãvãnh nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kỹ tóg ag mỹ ã camarada ũ ag jẽgnẽ mãn mũ. “Ag mỹ: “kãn inh huri, vẽjẽn ti, he ti, ẽg patrão ti,” hemnĩ,” he tóg. “Boi kãgtén inh huri, boi tãgy ẽn mré hã. Nén kar vỹ kynkar kỹ nỹtĩ. Kãmũ jẽg ra, inh festa to, he ti, ẽg patrão ti,” hemnĩ ag mỹ,” he tóg, pã'i mág ti, ã camarada ag mỹ. Kỹ ag tóg mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hã ra ag tóg kãmũ sór tũ nĩ, kỹ ag tóg ti camarada ag to é he mũ. Ũ tóg ã japỹ ra tĩ mũ, ũ tóg ã negócio nón tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ũ ag tóg hã ra ti camarada ag kugmĩ kỹ (ag tóg) ag vóg kónãn mũ gé sir, ag kãtén ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kỹ pã'i mág tóg ag to jũ mũ. Kỹ tóg ã krẽm pã'i ag jẽgnẽ kỹ ag kãgtén mũ gé sir, ũ tỹ ti camarada kãgtén ja ẽn ag. Ag ĩn kugprũg ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kỹ tóg ã camrada ag mỹ: “inh festa vỹ kar kỹ nĩ ha,” he mũ. “Hã ra ag tóg kãmũ jãvãnh nỹtĩ, isỹ ũn mỹ vẽnh vĩ jẽnẽ ja ag, ag kórég nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ha mũjẽg, ẽpry ra, ẽmĩn vẽnh kãpóv (ja) ra ke gé. Ãjag tỹ ũ ve kỹ ti mỹ: “ha festa venh kãtĩg,” hemnĩ,” he tóg, pã'i mág ti, ã camarada ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kỹ ag tóg mũ mũ. Ãjag tỹ ẽpry tá ũ ve kỹ ag tóg ag mỹ ke mũ. Vẽnh kar mỹ ag tóg tó mũ sir, ũn jykre há ag mỹ, ũn jykre kórég ag mỹ ke gé. Hã kỹ tóg fór mũ sir, clube ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kỹ pã'i mág tóg kãrã mũ sir, ag vigve jé, ũ tỹ festa to kãmũ ag. Kỹ ũ tóg tá jẽ nĩ, hã ra tóg festa to kur tu tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kỹ tóg ti mỹ: “festa to kur tu tũ ã tóg nĩ, vỹ,” he mũ. “Ã hã ne tóg kur kórég tu sór mũ', inh festa ki',” he tóg, ti mỹ. Hã ra tóg vĩ tũ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kỹ pã'i mág tóg ã camarada ag mỹ: “ha ti mrĩnh, ti pẽn, ti nĩgé, ha ti fón, re tá,” he mũ. Re tán kuty nĩ. Tá ag tóg jagtar tĩ. Ãjag jã tỹ ag tóg gyngyn ke tĩ sir, gangan ke ag tóg tĩ sir, vẽso jũgjũ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ge ti nĩ. Ũ tỹ hẽn ri ke jé sóg prẽr tĩ, hã ra ti pipir nỹtĩ, ũn kuprẽg kỹ nỹtĩ ag,” he tóg, Jesus ti. Ti tỹ ẽg tỹ kanhkã tá festa venh ke tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kỹ Fariseu ag tóg jagnẽ mré Jesus to jykrén mũ sir. Ag tỹ ti vĩ to ti se sór vẽ. Hã kỹ ag tóg: “ti vĩ tỹ hẽ to ẽg hỹn ti senh mũ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tag to jykrén kỹ ag tóg sir Jesus mỹ ãjag mré ke ũ ag jẽgnẽg mũ, Herodes mré ke ũ ag mré hã, ag tỹ ón kỹ ti ki jẽmẽ jé, ag tỹ ti vĩ to ti se jé. Ẽn ag tỹ Jesus tá junjun kỹ ag tóg ti mỹ: “Senhor,” he mũ. “Ã jykre kuryj nĩn ki kanhró ẽg tóg nỹtĩ,” he ag tóg. “Hã kỹ ã tóg Topẽ to ẽmĩn ki ẽg kanhrãn há han tĩ. Vẽnh jykre pir hã han ã tóg tĩ. Ũ tỹ vẽnh jykre há hã han ve nĩ mũ ra ã tóg ti jykre ki kanhró kar nĩ,” he ag tóg mũ, ón kỹ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","“Hã kỹ, ẽg mỹ ã tỹ nén to jykrén mũ tómnĩ. Mỹ ha nỹ', ẽg tỹ pã'i mág tỹ imperador mỹ jãnkamy ẽn nĩm ti', imposto kajãm jé'? Ẽg mỹ hỹn nĩm mũ', vó mỹ vó?” he ag tóg mũ, ón kỹ ti ki jẽmẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hã ra Jesus tóg ag jykre pãno ki kanhró nĩ. Hã kỹ tóg ag mỹ: “ãjag ne tóg ón kỹ inh ki jẽmẽ sór mũ'.” he mũ. “Jykre régre ãjag nỹtĩ mỹr,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","“Inh mỹ jãnkamy jun, imposto kajãm jafã ẽn ti,” he tóg. Kỹ ag tóg ti mỹ ũ jun mũ sir, jãnkamy ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kỹ tóg ag mỹ: “ũ jiji nỹ kã nĩ, ũ kãggrá nỹ kã nĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kỹ ag tóg ti mỹ: “pã'i mág tỹ imperador kãggrá vẽ,” he mũ. Kỹ tóg ag mỹ: “kỹ pã'i mág mỹ ti tũ nĩm nĩ, hã ra Topẽ mỹ ti tũ nĩm nĩ gé,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ag tỹ ti vĩ mẽ kỹ ti jykre tóg ag mỹ e tĩ sir. Kỹ ag tóg ti tovãnh kỹ mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kỹ kejẽn Saduceu ag tóg Jesus tá junjun mũ gé, kurã ẽn kã. Ag tỹ ón kỹ ti ki jẽmẽ sór vẽ gé. Hã ra Saduceu ag tóg: “ẽg ter ja tá ẽg vỹnvỹn kenh ke tũ nĩ,” he tĩ. “Rĩr mãn ke tũ ẽg tóg nĩ,” he ag tóg tĩ. Ẽn ag vỹ ón kỹ Jesus ki jẽmẽ sór mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Senhor,” he ag tóg mũ gé. “Moisés tỹ ẽg mỹ vẽnh jykre nĩm kỹ tóg ẽg mỹ: “ã régre tỹ ã krẽ tũ ra ter kỹ ã tỹ ti prũ fi tỹ prũg ke vẽ,” he mũ. “Ã tỹ ã régre mỹ ã krẽ han ke vẽ, fi ki,” he ja tóg nĩgtĩ, Moisés ti,” he ag tóg mũ, Saduceu ag, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Kỹ ũ tỹ jagnẽ mré pafa ja tỹ 7 (ke) vỹ nỹtĩgtĩ. Ag kãke tóg prũg mũ, hã ra tóg ã kósin tũ ra ter mũ. Kỹ ti jãvy tóg fi tỹ prũg mũ sir. Hã ra tóg ã kósin tũ ra ter mũ gé. Kỹ ti jãvy ũ tóg fi tỹ prũg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hã ra tóg ã kósin tũ ra ter mũ gé, ti jãvy ũ ke gé, hã ki ag kar vỹ kósin tũ ra kãgter kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kỹ vãhã ag kar prũ fi tóg ter mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kỹ fag kãgter ja tá rĩnrĩr mãn kỹ fi hỹn mén tỹ 7 (ke) nĩnh mũ vẽ. Ag kar vỹ fi tỹ prũg ja nĩ mỹr. Hã kỹ tóg vẽnhmỹ nỹ, ag tỹ: rĩr mãn jé ẽg tóg ke mũ, hen kỹ,” he ag tóg, Saduceu ag, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Hã ra Jesus tóg ag mỹ: “kygnẽ ãjag huri,” he mũ. “Ãjag pi(jé) Topẽ vĩ tỹ rán kỹ nĩ ki kanhró nỹtĩ', ãjag pi(jé) Topẽ jykre ki kanhró nỹtĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","“Ẽg rĩnrĩr mãn kỹ ẽg tóg prũg mãn ke tũ nĩ sir, kỹ ẽg mén mãn ke tũ nĩ gé. Topẽ tỹ jẽgnẽ jafã ri ke ẽg nỹtĩ, kanhkã tá,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Kỹ Topẽ vĩ rá ũ to jykrén nĩ, ti tỹ ẽg ter ja tá vỹn ke tó ti. Topẽ hã ne tỹ vẽmén ja nĩ mỹr, hã kỹ tóg tag tó ja nĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abraão vỹ iso: Topẽ, he tĩ, Isaque ke gé, Jacó ke gé,” he ja tóg nĩ, Topẽ ti. Kãgter ag huri, Abraão, Isaque, Jacó. Hã ra Topẽ tóg: “tỹ inh ag Topẽ nĩ,” he ja nĩgtĩ, ag ter kar kỹ. Hã kỹ ag tóg rĩnrĩr nỹtĩ, Topẽ tỹ ũn rĩnrĩr nỹtĩ ag hã kri ke nĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kỹ ag tóg ti vĩ mẽg mũ sir, kỹ ti jykre tóg ag mỹ e pẽ tĩ, ti vĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kỹ Fariseu ag tóg mẽg mũ, Jesus tỹ Saduceu ag mỹ vĩ há han ja ti. Ti tỹ ag mỹ vĩ há han kỹ ag tỹ ti mỹ hẽ ri ken kỹ kafãn ke tóg tũ tĩ sir. Hã mẽg ag tóg mũ, Fariseu ag. Kỹ ag tóg Jesus to vẽnhmãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kỹ ag kã ũ tóg ti mré vĩ mũ. Topẽ vĩ to professor vẽ, ũ tỹ Jesus mré vĩ mũ ti. Kỹ tóg Jesus mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Senhor,” he mũ. “Topẽ tỹ ẽg jyvẽn tỹ hẽ nỹ hỹn ti tỹ ẽg jyvẽn kar kãfór nỹnh mũ?” he tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kỹ Jesus tóg ti mỹ: “Topẽ to, ẽg jóg mág to há tãvĩ nỹtĩmnĩ, ti ki ge há han nĩ, ti to jykre pir nỹtĩmnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","“Topẽ tỹ ẽg jyvẽn kãfór kar hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kỹ ti tỹ ẽg jyvẽn ũ tóg hã ri ke nĩ gé, hã vỹ: ãjag régre ki rĩr nỹtĩmnĩ, ãjag tỹ vẽnh ki rĩr há han ri ke, he mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Vẽnh jyvẽn tag vỹ vẽnh jyvẽn kar kãfór nỹtĩ. Régre ti nỹtĩ, Topẽ tỹ ẽg jyvẽn kãfór nỹtĩ ti. Ẽg tỹ tag ki króm kỹ ẽg tóg Topẽ jykre ki króm kãn mũ. Ti tỹ ẽg jyvẽn mũ han kãn ẽg tóg mũ, Topẽ vĩ tó tĩ tỹ ẽg jyvẽn mũ mré hã, ẽg tỹ tag ki króm kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hã ra Fariseu ag vỹ vẽnh mãn kỹ nỹtĩ, kỹ Jesus tóg ag ki jẽmẽ sór mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Kỹ tóg ag mỹ: “Cristo to ãjag hẽ ri ke tĩ?” he mũ. “Ũ kósin nẽ hỹn, Cristo ti?” he tóg, Jesus ti. Kỹ ag tóg ti mỹ: “Davi kósin vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kỹ tóg ag mỹ: “hã ra Davi tóg ti to: inh Senhor, he ja nĩ,” he mũ. “Topẽ kuprĩg tỹ ti krĩn kỹ tóg tag tó ja nĩ, ha mẽ: ");
INSERT INTO kgpNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ẽg jóg tỹ Topẽ vỹ inh Senhor mỹ: “nĩ ra ver, inh pẽgja tá,” he mũ, “sỹ ã kato vãsãnsãn mũ ag tỹ ã krẽm vin ke vẽ, kỹ ag sigse vẽ sir. Tag jãvãnh nĩ ver,” he tóg mũ, Topẽ ti, inh Senhor mỹ,” he ja tóg nĩgtĩ, Davi ti,” he tóg mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Hã kỹ Davi tóg Cristo to: “inh Senhor,” he ja nĩ. Ti tỹ tỹ ti kósin nĩ ra ti kósin mỹ tỹ ti kri ke nĩnh mũ vẽ?” he tóg, Jesus ti. Ti tỹ Fariseu ag ki jẽmẽg mũn hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hã ra ag tỹ ti mỹ ne tónh ke tóg tũ tĩ, ag tỹ ti vĩ kafãn sór mũ ra. Vãhã ag tóg ti ki jẽmẽ sór mãn tũ nĩ. Ti kamẽg ag tóg mũ, hã kỹ ag tóg ti ki jẽmẽ sór mãn tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kỹ Jesus tóg vẽnh kar kanhrãn mũ sir, ti mré mũ tĩ ag mré hã. Kỹ tóg ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Moisés vỹ ẽg jóg ag kanhrãn ja nĩgtĩ,” he mũ. “Ti nón Topẽ vĩ to professor ag tóg ẽg kanhrãn sór mũ, Fariseu ag ke gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","“Ag tỹ ãjag mỹ nén tó mũ ẽn ki króm nĩ. Ag vĩ kri fimnĩ. Ag tỹ nén han mũ ri ke han tũg nĩ jãvo, ag jykre kórég ẽn han tũg nĩ. Ãjag kanhrãn há han ag tóg tĩ, hã ra ag tóg ki króm sór tũ nĩgtĩ, ãjag vĩ há ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ãjag mỹ ag tóg vẽnh jykre kufy vin tĩ, hã ra ag hã tóg han sór tũ nĩgtĩ, vẽnh jykre kufy ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ag tỹ nén ũ há han kỹ ag tóg tỹ ũn mág nỹtĩ sór mũ sir, vẽnh kar tỹ ag vigve jé. Ag tỹ Topẽ mré vĩ jé ag tóg ti vĩ rá tỹ ãjag nĩgé tógfĩg tĩ, ãjag kakã ke gé. Vẽsógfĩn ja tãpér tỹ ag tóg vẽsógfĩg tĩ. Topẽ jykre han jé ag tóg kur tóv mág tu tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Festa ki ag tóg jẽn vén sór tĩ. Vẽnh kanhrãn jafã krẽm ag tóg vẽnh kãpov kỹ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Cidade kuju ki vẽnh kar tóg ag mỹ: “ã mỹ há?” he tĩ, kỹ tóg ag mỹ sér tĩ. Kỹ ag tóg ag to: “Senhor,” he tĩ gé, kỹ tóg ag mỹ sér tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ag jãvo jagnẽ mỹ: “Senhor,” he sór tũg nĩ, kỹ ag tỹ ãjag mỹ: “Senhor,” he mũ ra ag mỹ: “inh pi(jé) tỹ ũn mág nĩ',” hemnĩ. Ũn pir vỹ tỹ ãjag kri ke nĩ, hã vỹ: Topẽ, he mũ, jó ãjag tóg tỹ jagnẽ mré ke nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kỹ ũ mỹ: “ẽg jóg,” he tũg nĩ gé, ẽprã. Ũn pir vỹ tỹ ãjag jóg nĩ, hã vỹ: Topẽ, he mũ, kanhkã tá nĩ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kỹ ũ tỹ ãjag mỹ: “ẽg kri tỹ ũn mág nĩmnĩ,” he kỹ ag mỹ: “vó, kenh ke tũ inh nĩ,” hemnĩ gé. Ũn pir vỹ ãjag kri tỹ ũn mág nĩ, hã vỹ: Cristo, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ãjag kãmĩ ũn mág ag jé ãjag ki rĩr há han, ãjag camarada tỹ ãjag ki rĩr há han tĩ ẽn ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ãjag tỹ tag ki vẽsỹ tỹ ũn mág han sór nỹtĩn kỹ ãjag tóg tá térenh ke mũ, ha vemnĩ. Ãjag tỹ hã ra: “tỹ inh ũn sĩ nĩ,” hen kỹ ãjag tóg tá jãprynh ke mũ, tỹ ũn mág ãjag nỹtĩnh mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ón kỹ Topẽ vĩ to professor',” he tóg. “Fariseu',” he tóg. “Jykre régre ãjag nỹtĩ,” he tóg. “Topẽ vỹ ãjag ve kónãn,” he tóg. “Ũ ag tóg ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩ ve sór nỹtĩ, hã ra ãjag tóg ag mỹ kanhkã ti nenh tĩ. Ag jãvo ãjag tóg ve sór tũ nĩgtĩ. Ãjag tỹ kanhkã ve sór tũ nĩn kỹ ãjag tóg ũ ag mỹ nenh tĩ gé, ag tỹ vég tũ nĩ jé, ãjag ri ke,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ón kỹ Topẽ vĩ to professor',” he tóg. “Fariseu',” he tóg. “Jykre régre ãjag nỹtĩ,” he tóg. “Topẽ vỹ ãjag ve kónãn,” he tóg. “Ãjag ne tóg ũn mén ter ja fag tũ mãn kãn tĩ'. Kar kỹ ãjag tóg ón kỹ Topẽ mré vĩ téj han mũgtĩ, ẽg tỹ ãjag to: “há ag nỹtĩ,” he jé. Hã kỹ Topẽ vỹ ãjag vóg kónãn kãfór han ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ón kỹ Topẽ vĩ to professor',” he tóg. “Fariseu',” he tóg. “Jykre régre ãjag nỹtĩ,” he tóg. “Topẽ vỹ ãjag ve kónãn,” he tóg. “Ãjag ne tóg kuvar há ra mũ tĩ', ga mĩ, goj mĩ ke gé, ãjag tỹ ũ tỹ Israel ag jykre han sór mũ ũ jãvãnh jé. Hã jé ãjag tóg mũ mág han tĩ. Kỹ ãjag tỹ ũ ven kỹ ãjag tóg ti tỹ Japo krẽ han mũ sir, ti tỹ ón kỹ Topẽ vĩ mẽ jé, ãjag ri kén, ti tỹ nũgme ki kutẽ jé, inferno ẽn ki. Kỹ ti jykre pãno vỹ ãjag jykre pãno kãfór nỹ sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Topẽ vỹ ãjag ve kónãn mỹr,” he tóg. “Kyvó ãjag nỹtĩ, hã ra ãjag tóg ũ tỹ ki kagtĩg ag tatĩn mũ sór mũ. Hã kỹ ãjag tóg kygnẽg tĩ. Kỹ ãjag tóg ag kanhrãn kónãn tĩ. “Ẽg tỹ ón kỹ: tag han jé sóg ke mũ, he sór kỹ ẽg tóg: “Topẽ jo ĩn krẽm nĩ ẽn vỹ ki kanhró nĩ,” henh ke mũ,” he ãjag tóg tĩ. “Ẽg tỹ hã ra: Topẽ jo ĩn krẽm ouro tãn ẽn vỹ ki kanhró nĩ, hen kỹ ẽg tóg ón ke tũ nĩ,” he ãjag tóg tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Vẽnhmỹ ti nĩ, ãjag vĩ tag. Krĩ tũ ãjag tóg nỹtĩ, kyvó ãjag tóg nỹtĩ. Ouro mỹ Topẽ jo ĩn kãfór nĩ'? Vó'. Ouro vỹ tỹ Topẽ tũ nĩ, ti tỹ Topẽ jo ĩn krẽm nĩn kỹ. Hã kỹ tóg tỹ Topẽ tũ kar nĩ sir, ouro ti, ti jo ĩn ti ke gé. Ón kỹ: “Topẽ hã vỹ ki kanhró nĩ,” he tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ãjag vĩ vẽnhmỹ ũ vỹ nĩ gé. “Ón kỹ ẽg tóg: ẽg tỹ mesa kri ũn mỹ nén ũ pũn mũ ẽn vỹ ki kanhró nĩ, henh ke mũ,” he ãjag tóg tĩ gé. “Ẽg tỹ hã ra: ẽg tỹ ũn mỹ ẽg mẽg pũn tĩ ẽn vỹ ki kanhró nĩ, hen kỹ ẽg ón ke tũ nĩ,” he ãjag tóg tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Vẽnhmỹ ti nĩ gé, ãjag vĩ tag ti. Kyvó ãjag nỹtĩ mỹr. Ẽg tỹ Topẽ mỹ ẽg mẽg pũn mũ mỹ mesa kãfór nĩ'? Vó'. Topẽ jo ĩn krẽm mesa kri ẽg tóg ẽg mẽg ti pũn tĩ, hã kỹ tóg Topẽ mỹ há tĩ, ẽg mẽg ti, ẽg tỹ ti jo ĩn tá ti mỹ mesa kri ti pũn tugrĩn. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ãjag tỹ Topẽ jo ĩn krẽm mesa tón kỹ, kỹ ãjag tóg ẽg tỹ ẽg mẽg tỹ mesa ẽn kri pũn mũ ẽn tó tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ãjag tỹ Topẽ jo ĩn tón kỹ, kỹ ãjag tóg Topẽ ti tó tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ãjag tỹ kanhkã tón kỹ, kỹ ãjag tóg Topẽ nĩgja tó tĩ gé, kỹ ãjag tóg Topẽ ti tó tĩ gé sir. Nén ũ pir vẽ, ti kar ti. Hã kỹ ón kỹ: Topẽ hã vỹ ki kanhró nĩ,” he tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ón kỹ Topẽ vĩ to professor',” he tóg. “Fariseu',” he tóg. “Krĩ régre ãjag nỹtĩ, kỹ Topẽ vỹ ãjag ve kónãn,” he tóg. “Ón kỹ ãjag tóg Topẽ mỹ ãjag jakré ki dízimo vin tĩ. Ãjag jakré tỹ hortelã tỹ 10 (ke) nỹtĩn kỹ ãjag tóg Topẽ mỹ ũn pir nĩm tĩ, ãjag jakré tỹ erva doce tỹ ke gé, ãjag jakré tỹ cominho tỹ ke gé. Há ti nĩnh mũ vẽ. Hã ra ãjag tóg ti tỹ ẽg jyvẽn mũ ẽn han tũ nĩgtĩ. Vẽnh jykre kuryj han tũ ãjag tóg nĩgtĩ. Ũn jagãgtar ag jagãgtãn tũ ãjag tóg nĩgtĩ. Topẽ vĩ kri fig tũ ãjag tóg nĩgtĩ. Ãjag tỹ ti vĩ ki króm tag tóg inh mỹ há nĩnh mũ vẽ, ha mẽ. Ãjag tỹ ti tỹ ẽg jyvẽn ki króm mré hã ãjag jakré ki dízimo vin (hã) ra tóg inh mỹ há nĩnh mũ vẽ, ha mẽ. Hã ra ãjag tóg ki króm sór tũ nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kyvó ãjag nỹtĩ, hã ra ãjag tóg ag tatĩn mũ sór nỹtĩ. Topẽ vĩ ũ ki króm sór ãjag tóg tĩ, ti tỹ Topẽ mỹ tỹ nén ũ sĩ (hã) ra, kỹ ãjag tóg ti vĩ ũ mrynhmranh tĩ, ti tỹ Topẽ mỹ kórég pẽ (hã) ra. Kỹ tóg goj ki ka ri ke nĩ. Ãjag tỹ ka gón tũ nĩ jé ãjag tóg kur ki kujẽg tĩ, kỹ tóg pan tĩ, goj ti. Hã ra ãjag tóg cavalo tỹ goj ki ter mũ ra (ãjag tóg) goj kórég ẽn kron tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ón kỹ Topẽ vĩ to professor',” he tóg. “Fariseu',” he tóg. “Krĩ régre ãjag nỹtĩ, kỹ Topẽ vỹ ãjag ve kónãn,” he tóg. “Copo venja kupég ãjag tóg tĩ, pénky venja, hã ra ti kãtá tóg kavéj nĩ. Kỹ ãjag vỹ ge nỹgtĩ gé. Jykre há nĩ ve ãjag tóg nỹgtĩ gé, hã ra ãjag tóg vẽnh jykre pãno han tĩ, hã vỹ: jãnkamy to ag lograr he tĩ, he mũ, ãjag prũ tũ fag mré nỹ tĩ, he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kyvó ãjag nỹtĩ, ãjag tỹ tỹ Fariseu nỹtĩ ra. Ãjag jykre pãno tovãnh nĩ, ãjag jãnhkri nỹtĩ jé. Kỹ vãhã vẽnh kar vỹ ãjag jykre há vég mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ón kỹ Topẽ vĩ to professor',” he tóg. “Fariseu',” he tóg. “Krĩ régre ãjag nỹtĩ, kỹ Topẽ vỹ ãjag ve kónãn,” he tóg. “Vẽnh kej sĩnvĩ ri ke ãjag nỹtĩ. Sĩnvĩ nĩ ve ti nĩ, vẽnh kej ti, ẽg tỹ pó tỹ kri tam kỹ, kar tinta tỹ pó to tĩn kỹ. Ti sĩnvĩ nĩ ve nĩ ra ti kãtá tóg kórég nĩ. Vẽser vỹ krẽm nỹ nĩ, vẽser vag mũ ti, ti kuka. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tag ri ke ãjag nỹtĩ. Há nĩ ve ãjag nỹtĩ. Jykre kuryj nĩ ve ãjag nỹtĩ, hã ra ãjag kãtá tóg kórég nĩ, ãjag jykre régre nỹtĩn kỹ, ãjag tỹ Topẽ vĩ ki króm sór tũ nỹtĩn kỹ mỹr, ha mẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ón kỹ Topẽ vĩ to professor',” he tóg. “Fariseu',” he tóg. “Krĩ régre ãjag nỹtĩ, kỹ Topẽ vỹ ãjag ve kónãn,” he tóg. “Ãjag jóg'jóg ag vỹ Topẽ vĩ tó tĩ ag kãgtén ja nĩgtĩ. Jãvo ãjag tóg ag kej sĩnvĩ han tĩ, ũn jykre kuryj han ja ag kej ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kỹ ãjag tóg ag to: “ẽg tỹ ẽg jóg'jóg ag mré ga kri mũ hã ra ẽg tóg ag kãgtén ke tũ nĩ vẽ,” he ti. “Ag mré ẽg ag vóg ke tũ nĩ vẽ,” he ãjag tóg tĩ, ón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hã ki ãjag tóg ãjag jóg'jóg ag tó tĩ. “Ẽg jóg'jóg ag vỹ ag kãgtén, Topẽ vĩ tó tĩ ag,” he ãjag tóg tĩ. “Ũ tỹ ag kãgtén mũ ag krẽ'krẽ vỹ tỹ ẽg nỹtĩ,” he ãjag tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kuri ãjag jóg'jóg ag ri ke han nĩ, kuri ãjag jóg'jóg ag tỹ ũn kãgtén ja tũ ẽn ag kãgtén nĩ, ãjag tỹ tỹ ãjag jóg'jóg ag krẽ'krẽ nỹtĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Pỹn ri ke ãjag nỹtĩ, mĩg ri ke ãjag nỹtĩ. Ãjag pi(jé) nũgme ki vár ke tũ nĩnh ke mũ', inferno ki',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Hã kỹ sóg ãjag mỹ Topẽ vĩ tó tĩ ag jẽgnẽnh ke mũ, vẽnh vĩ há tó mũ ag, Topẽ vĩ rán tĩ ag. Ag jẽgnẽ jé sóg ke mũ, ag tỹ ãjag jyvẽn jé. Kỹ ãjag tóg ag kãgtén ke mũ gé, ha vemnĩ. Ka to ãjag tóg ag sanh ke mũ. Ag mrãnmrãn jé ãjag tóg ke mũ, ãjag tỹ vẽnh kanhrãn jafã krẽm. Cidade kar ki ãjag tóg ag nón mũnh mũ, ãjag tỹ ag vóg kónãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hã kỹ tóg ãjag tỹ ũn jykre kuryj kar kãgtén mũ ri ke nĩ. Ũn tỹ hẽn ri ke ag kãgtén ag tóg huri, ẽprã ke ag, hã ra tóg ãjag tỹ ag kãgtén kãn ri ke nĩ sir, Abel, Abel nón ke ag mré hã, Zacarias ẽn mré hã, Baraquias kósin ẽn. Ẽn tỹ ãjag tóg Topẽ jo ĩn jo ti tén ja nĩ, Topẽ mỹ nén ũ pũn jafã ẽn tá ãjag tóg ti tén ja nĩ, Zacarias ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ãjag mỹ sóg tó mũ, ha mẽ. Ãjag hã to ti jũnh ke mũ, Topẽ ti, ãjag jóg'jóg ag tỹ ag kãgtén tugrĩn, ãjag tỹ ag kãgtén tugrĩn ke gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kỹ tóg Jerusalém ki ke ag to vẽmén mũ. Fe kaj han tóg, ag to, kỹ tóg: “Jerusalém tá ke ag mỹ sóg tag tó sór mũ, ha mẽ,” he mũ. “Topẽ vĩ tó tĩ ag kãgtén ag tóg tĩ. Topẽ tỹ ag mỹ ũn jẽgnẽg tĩ ag pin ag tóg tĩ, pó tỹ, ag tỹ ag kãgtén jé. Isỹ ag vẽnh mãn há tóg tĩ vẽ, isỹ ag ki rĩr jé, Jerusalém tá ke ag, hã kỹ sóg ag jé prẽr tỹ hẽn ri ke han mũ. Garĩnh fi jykre ri ke han sór isóg mũ vẽ, ag mỹ. Garĩnh fi vỹ ã krẽ kri jẽ nĩ, fi tỹ ag vẽsỹrénh tũ nĩ jé ke vẽ. Ẽn ri ke han sór sóg mũ vẽ, hã ra ag tóg ke jãvãnh nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hã kỹ ag tóg ag jamã pũn kãn ke mũ, kỹ vãpũr vẽ sir. Ũ vỹ kãnhmar tá nĩg mãn ke tũ nĩ ha, ag tỹ cidade kókén ja tá. ");
INSERT INTO kgpNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hã kỹ sóg ag mỹ ke mũ. Inh ve mãn ke tũ ag nĩ ha (mỹr). Kejẽn ag tóg iso: “Topẽ tỹ ti jẽnẽ ja vẽ,” henh ke mũ. “Topẽ vỹ ti ve há han, ti tỹ ti jiji tó kãtĩg kỹ,” he jé ag tóg ke mũ iso, kejẽn. Ẽn kã ag tóg inh ve mãn ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kỹ Jesus tóg Topẽ jo ĩn tá kãkutẽ kỹ tĩ mũ sir. Kỹ ti mré mũ tĩ ag tóg ti tá junjun mũ, kỹ ag tóg ti mỹ Topẽ jo ĩn ẽn ag venven mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kỹ Jesus tóg ag mỹ: “ãjag mỹ pó tỹ ĩn mág tag ag vigvég mũ'?” he mũ. “Kejẽn pó tóg jagnẽ kri nỹtĩ mãn ke tũ nĩ ha. Ag tỹ gũm ke kãn ke vẽ. Ki hã sóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kar kỹ tóg krĩ tỹ Oliveiras ra tĩ mũ sir. Ti tỹ tá nĩ kỹ ti mré mũ tĩ ag tóg vyr mỹ ti ki jẽmẽnh kãmũ mũ. Kỹ ag tóg ti mỹ: “ẽg mỹ ti kurã ti tó,” he mũ. “Ẽg tỹ ne ve kỹ ẽg ti kurã ki kanhró nỹtĩnh mũ, ã kãtĩg mãn ke kurã ẽn ti, nén kar tũg ke kurã ẽn ti?” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kỹ tóg ag mỹ: “ker ũ ãjag lograr hé hẽ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Cristo vỹ tỹ inh nĩ,” he jé ag tóg ke mũ, inh jyjy tó kỹ. Ũ tỹ hẽn ri ke ag tóg tag tónh ke mũ, kỹ ũ tỹ hẽn ri ke ag tóg ag vĩ kri nĩm ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Vẽnh génh to vẽme mẽ jé ãjag tóg ke mũ, tag ki vẽnh génh to, kuvar há tá vẽnh génh to ke gé. To jũrũn ke tũg nĩ, hã ra. Vẽnh génh enh ke vẽ. Hã ra kurã tỹ ẽgno to hã ke vẽ ver. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nação ag tỹ jagnẽ kato tẽgtẽnh ke vẽ, pã'i krẽm ke ag tỹ pã'i ũ krẽm ke ag to jũnh ke vẽ. Kỹ ga tỹ ragra ke tỹ hẽn ri ke han ke vẽ, ẽmã tỹ hẽn ri ke ki. Vẽjẽn tỹ tũ' henh ke vẽ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hã ra ãjag jagãgtar ke vẽnh ven vén vẽ ver,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kar kỹ ãjag jagtar ke mũ, ãjag tỹ inh ki ge kỹ nỹtĩ tugrĩn. Ãjag vóg kónãn jé ag tóg ke mũ, ãjag kãgtén jé ag tóg ke mũ gé. Nação kar vỹ ãjag to vĩ kónãn ke mũ gé, ãjag tỹ inh jiji tó tugrĩn. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kỹ ũ tỹ hẽn ri ke ag vỹ isogvãnh ke mũ sir, ẽn kã. Ãjag mré ke fag tó jé ag tóg ke mũ, inh kato vãsãnsãn mũ ag mỹ, kỹ ag tóg jagnẽ to vĩ kónãn tãvĩ han ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ón kỹ inh vĩ tó tĩ ag vỹ junjun ke mũ gé, kỹ ag tóg ũn e krĩnkrĩn ke mũ sir, ag tỹ isogvãnh jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kỹ vẽnh kar vỹ vẽnh jykre pãno to há nỹtĩnh mũ, hã kỹ ũ tỹ ón kỹ iso há sĩ nỹtĩ ẽn ag tóg isogvãnh ke mũ gé, ũn e ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Hã ra ũ tỹ isovãnh tũ pẽ ẽn ag tóg krenkren ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kỹ nação kar vỹ vẽnh vĩ sér mẽnh mũ, ga kar mĩ hã, kỹ ag tóg Topẽ tỹ tỹ ẽg pã'i nĩnh ke ẽn mẽnh mũ ha. Ag tỹ mẽ kãn kỹ kurã tỹ ẽgno vẽ sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kejẽn ãjag tóg vãhã sir ãjag tỹ nén (ũ) kamẽg tĩ ẽn venh ke mũ, ẽg kavénh mũ ẽn ti,” he tóg. “Topẽ vĩ tó tĩ tỹ Daniel vỹ ti tó ja nĩgtĩ. Topẽ jo ĩn tá tóg jẽnh mũ, ẽg kavénh mũ ẽn ti,” he tóg, Jesus ti. (Ũ tỹ vẽnh rá tag to ke mũ ẽn jé ki kanhró nĩ.) ");
INSERT INTO kgpNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ãjag tỹ ti ve kỹ ga tỹ Judéia ki ke kar ag jé vẽnh pigjunh mũjẽg, pãnónh ra, fag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ũ tỹ re tá nĩ ẽn jé kãra rã tũg nĩ, ti ĩn ki, ti tũ mãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kỹ ũ tỹ ã japỹ tá jẽ ẽn jé vỹn ke tũg nĩ gé, ti kur mãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ũn kufy fag jagtar mág ke vẽ, kurã ẽn kã, ũ tỹ gĩr pygfãm mũ fag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Topẽ mré vĩmnĩ, ti tỹ kusa kã vẽnh ven tũ nĩ jé, ti tỹ vẽnhkán ke kurã kã vẽnh ven tũ nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jagtar mág tỹ ge han ja tũ ẽg tóg nỹtĩ, Topẽ tỹ mundo han jãn ki. Kỹ ẽg ge han mãn ke tũ nĩ gé, kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ẽg tỹ kurã ki jagtar ke mũ ẽn vỹ e nỹtĩnh mũ vẽ, hã ra tóg térem kỹ nỹtĩ nĩ, Topẽ tỹ ũn kuprẽg ja ẽn ag tugrĩn. Ti tỹ térem tũ nĩ (mũ) ra ũ vỹ kren ke tũ nĩ vẽ, ag jagtar mág ẽn to,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ẽn kã ũ tỹ ãjag mỹ: Cristo vỹ tag kã jẽ nĩ, he mũ ra kri nĩm tũg nĩ, ag tỹ: tãtá ti jẽ nĩ, he mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ón kỹ Cristo ag vỹ vẽnh venven ke mũ, ón kỹ Topẽ vĩ tó tĩ ag ke gé. Ẽg tỹ nén han vãnh hyn han jé ag tóg ke mũ, milagre tỹ hẽn ri ke ti, ón kỹ Cristo ẽn ag. Ag tỹ vẽnh kar krĩn kónãn sór vẽ, ag tỹ kygnẽ jé, Topẽ tỹ ũn kuprẽg ja ẽn ag mré hã, hẽn ri ke mũn. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ãjag mỹ sóg tó kãn mũ, ti kutẽnh ke to hã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kejẽn ag tóg ãjag mỹ: ẽmã kórég tá tóg jẽ, Cristo ti, henh ke mũ. Ra ti venh mũ tũg. Ag tỹ ãjag mỹ: ĩn kãtá tóg nĩ nĩ, he mũ ra kri fi tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Inh kãtĩg mãn ke vỹ ta tỹ kóm kóm ke ri ke nĩ. Ti tỹ kóm kóm ke kỹ ẽg tóg nén kar vég tĩ, rã jur ja tá, rã pur ja tá ke gé. Inh kãtĩg mãn ke vỹ ri ke nĩnh mũ. Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Nén ũ ter nỹgja ri ke ti nĩ gé. Hã tá tóg vẽnh mãn tĩ, jãtã ti. Tag ri ke ti nĩnh mũ, inh kãtĩg mãn ke ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Jagtar ẽn kar kỹ rã vỹ nhyr ke mũ, kỹ kysã vỹ jẽngrẽ he mãn ke tũ nĩ gé. Krĩg vỹ vár ke mũ gé, kanhkã krẽm. Ẽg tỹ kanhkã tá nén vég tũ kar ẽn vỹ ragra ke kãn mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kỹ vãhã ẽprã ke fi kósin vỹ vẽnh ven ke mũ, kanhkã tá. Kỹ ga kri mũ kar ag vỹ kygfỹ kãn ke mũ sir, povo kar ti, ag tỹ inh kãtĩg ven kỹ. Kanhkã góg kãmĩ sóg térenh ke mũ. Kỹ sóg tar pẽ nĩnh mũ, ha vemnĩ, kỹ inh ve vỹ kókov pẽ nĩnh mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kỹ sóg isỹ jẽgnẽ jafã ag jẽgnẽnh mũ, ag tỹ ténténtén kynkyn jé, kỹ ag tóg isỹ ũn kuprẽg mũ ag jé prẽnprẽr kãn ke mũ sir, ga kar mĩ hã, kanhkã fyr mĩ hã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ka tỹ figueira to ki kanhrãn nĩ, to comparação han kỹ. Ka tỹ figueira pẽ tánh kỹ, ti féj tãg han kỹ tóg kakó tĩ sir, ẽkré tygtánh kurã ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ri ke ti nĩ, ãjag tỹ inh kãtĩg mãn ke kurã ki kanhró nỹtĩnh ke mũ ti. Ãjag tỹ isỹ ãjag mỹ nén tó mũ tag ve kỹ tóg sir kakó tĩnh ha, kakó tãvĩ tóg tĩnh ha, inh kãtĩg mãn ke ti, ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Sỹ ke há vẽ, hã kỹ sóg tag tó mũ, ha mẽ: ũri ũn rĩnrĩr mũ ag tỹ nén kar ẽn venh ke vẽ, ag kãgter ke to hã. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kanhkã vỹ tũ' henh ke mũ, ga ti ke gé. Jãvo inh vĩ vỹ tũ' henh ke tũ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hã ra ũ pi(jé) isỹ kurã ki kãtĩg mãn ke mũ ki kanhró nĩ', hora ki ke gé. Topẽ tỹ jẽgnẽ jafã ag pi(jé) ki kanhró nỹtĩ'. Inh pi(jé) ki kanhró nĩ gé. Ẽg jóg mág hã vỹ ã pin kỹ ki kanhró nĩ, kurã kã nén kutẽnh ke mũ ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Inh kãtĩg mãn ke kurã vỹ Noé tỹ ga mĩ tĩg ja ẽn ri ke nĩnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ta kutẽ to hã ag tóg jẽn ja nĩgtĩ, kron ja nĩgtĩ, jagnẽ tỹ prũg ja nĩgtĩ, jagnẽ tỹ mén ja nĩgtĩ, Noé mré ke ag. Ẽn kã kejẽn Noé tóg barco tỹ ĩn kãra rã mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hã ra tóg ag mỹ tỹ nén ũ tũ tĩ, ti tỹ barco kãra rã mũ ti. Kejẽn ta tóg kutẽ mũ, kỹ goj tóg var mũ sir. Kỹ ag tóg kãgter kãn mũ sir vãhã. Ge ti nĩnh mũ, ẽprã ke fi kósin kãtĩg mãn kỹ, inh kãtĩg mãn kỹ mỹr. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ẽn kã ũn régre ag vỹ ãjag japy ki rãnhrãj ke mũ. Inh kãtĩg mãn kỹ sóg ũn pir jé prẽr ke mũ, jãvo ti régre vỹ tá jẽnh mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ũn régre fag vỹ ẽgtynyn nỹtĩnh mũ, jagnẽ mré, kurã ẽn kã. Kỹ sóg ũn pir fi jé prẽr ke mũ, jãvo fi régre fi vỹ tá jẽnh mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Vẽnh ki ẽmẽmnĩ, nũr tũ ri ke han nĩ. Inh kãtĩg ke hora ki kagtĩg ãjag tóg nỹtĩ. Ãjag Senhor vỹ tỹ inh nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Kỹ tag to jykrén nĩ, ha mẽ. Ẽg pi(jé) ũ tỹ ẽg tỹ nén péju sór mũ kãtĩg ke ki kanhró nỹtĩ'. Ẽg tỹ ti kãtĩg ke tỹ hora ki kanhró nỹtĩ ra ẽg tóg to ẽg tỹ nén ki rĩr mũ vẽ, kỹ ũ pi(jé) ẽg ĩn kãra rãnh ke mũ vẽ'. Hã ra ẽg tóg ki kagtĩg nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ge ti nĩ, inh kãtĩg mãn ke ti. Ha vẽnh kãn, ha vẽnh ki ẽmẽ. Ẽprã ke fi kósin vỹ kãtĩg ke mũ, ãjag tỹ inh kãtĩg ke to jykrén tũ ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kỹ tóg ag mỹ ã kãtĩg mãn ke tó mãn mũ. “Kejẽn patrão ũ tóg hẽ ra tĩg sór mũ,” he tóg. “Kỹ tóg ã camarada ag kã ũ tỹ pã'i han mũ, ti tỹ ti jo ã mré camarada ag ki rĩr jé. Ũ tỹ ã rãnhrãj ki rĩr há han tĩ ẽn kuprẽg tóg mũ, ti tỹ ag mỹ vẽjẽn ven jé, vẽjẽn ke horan ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ti tỹ ag ki rĩr há han kỹ ti patrão vỹ ti mỹ vĩ há han ke mũ, ti kãtĩg mãn ken kã. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ti tỹ pã'i han jé tóg ke mũ, ti tỹ ti tũ ki rĩr kãn jé sir. Ki hã sóg tó mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kejẽn ti camarada ũ tóg hã ra jykre pãno nĩ. Kỹ tóg tag to jykrén mũ. “Ẽg patrão vỹ kãtĩg vãnh han mũ,” he tóg mũ sir, ũn jykre pãno ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kỹ tóg ã mré camarada ag vóg kónãn mũ sir, ag mrãnmrãn kỹ. Kỹ tóg ũn kronkron tĩ ag mré kron mũ gé sir, jẽn mág han tóg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kỹ ti patrão vỹ ti kãnhmỹ kãtĩg ke mũ sir, ti tỹ ti kãtĩg ke kurã ki kagtĩg nĩn kỹ, ti horan ke gé, ũn jykre kórég ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ã kãtĩg kỹ tóg ti kapãn ri ke han ke mũ sir, kỹ tóg ti fón ke mũ gé sir, ũn jykre régre ag mré. Tá ag tóg jagtar ke mũ, ãjag jã tỹ ag tóg gyngyn ke mũ, tỹ ag tóg gangan ke mũ, jũ kỹ, ũn jykre kórég ẽn ag,” he tóg, Jesus ti. Ti tỹ ũ tỹ ti rãnhrãj han kónãn mũ kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kỹ Jesus tóg ag mỹ ã kãtĩg mãn ke ẽn kãmén mãn mũ, kỹ tóg ag mỹ: “ẽn kã ũ tỹ kanhkã tá nĩ ẽn tỹ tỹ ẽg pã'i nĩnh ke vỹ ge nĩnh mũ, ha mẽ,” he mũ. “Tátãg fag ri ke ti nĩnh mũ. Ũ tỹ 10 (ke) fag vỹ nỹtĩ, tátãg fag. Vẽnh kyprũg ve jé fag tóg lampião vyn kỹ mũ mũ, ũn prũg mũ ẽn kato. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Fag tỹ 5 (ke) fag vỹ jykre kórég nỹtĩ, jãvo ũ fag vỹ jykre há nỹtĩ, ũ tỹ 5 (ke) ũ fag. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kỹ ũn jykre kórég fag vỹ vyrmỹ azeite ma mũ ja tũ nĩ, hã ra tóg sĩn kỹ lampião kãkã nĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Fag jãvo ũn jykre há fag vỹ azeite ma mũ mũ, vyrmỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hã ra tóg kãtĩg vãnh han mũ, ũn prũg mũ ti. Kỹ tóg kejẽn fag nũgnũr há tĩ sir, ti jun tũg ki, kỹ fag tóg nũgnũr kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Meia noite ki vẽnh vĩ tóg mẽ há tĩ, kỹ tóg: “!..nĩgnĩ ra..!” he mũ. “!..Ũn prũg mũ vỹ kãteg..!” he tóg. “!..Ha ti venh kãmũ jeg..!” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kỹ tátãg ẽn fag vỹ nĩgnĩg kỹ fag lampião gruggrug mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kỹ ũn jykre kórég fag vỹ ũn jykre há fag mỹ azeite to vĩ mũ. “Ẽg mỹ ãjag azeite vẽnh kãpãm. Nhyn ke ti nỹtĩ ha, ẽg lampião ti,” he fag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Hã ra ũn jykre há fag tóg fag mỹ: “vó',” he mũ. “Ẽg tỹ ãjag mỹ vẽnh kãpãm kỹ tóg ẽg mỹ kã kyn ke mũ gé, ãjag ri kén. Negócio ra mũjẽg, ãjag tỹ azeite ven jé,” he fag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kỹ fag tóg mũ mũ. Fag gunja tá tóg jun mũ sir, ũn prũg mũ ti. Kỹ fag tóg ti mré mũ mũ sir, ũn lampião gru nỹtĩ fag. Vẽnh kyprũg ve jé fag tóg mũ mũ, kỹ ag tóg jãnkã ti nĩfénh mũ sir, ũn jykre kórég fag jy. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kỹ vãhã tátãg ũ fag vỹ tá junjun mũ gé sir, kỹ fag tóg ti mỹ: “Senhor', Senhor',” he mũ sir. “Ẽg mỹ nón,” he fag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hã ra tóg fag mỹ: “ãjag ki kagtĩg sóg nĩ, mỹr, ha mẽ,” he mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Hã kỹ sóg ãjag mỹ: vẽnh ki rĩr, nũr tũ ri ke han kỹ, he mũ. Kãtĩg jé sóg ke mũ. Hã ra ãjag tóg inh kãtĩg ke kurã ki kagtĩg nỹtĩ, inh hora ki ke gé. Hã kỹ inh jãvãnh to krónh ke tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kỹ Jesus tóg: “inh kãtĩg mãn ke vỹ tag ri ke nĩnh mũ gé, ha mẽ,” he mũ. “Kejẽn ũ tóg ga ũ venh tĩg sór mũ, kỹ tóg ã camarada ag jé prẽr mũ, ti tỹ ag mỹ ã tỹ nén kar vẽnh kãpãm jé, ã jãnkamy kar. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ũ mỹ tóg jãnkamy kãmur tỹ 5 (ke) vin mũ, ũ mỹ tóg ti kãmur régre vin mũ, ũ mỹ tóg ti kãmur pir nĩm mũ. Ũn krĩ há ẽn mỹ tóg ti kãmur e vin mũ, ũn krĩ pãgsĩ ẽn mỹ tóg ti kãmur pir nĩm mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kỹ ũ tỹ ti kãmur tỹ 5 (ke) mãg mũ ẽn vỹ tĩ mũ. Jãnkamy ẽn tỹ rãnhrãj mág han kỹ tóg kejẽn ũ tỹ 5 (ke) ũ mãg mũ, kỹ ti tũ vỹ tỹ ti kãmur tỹ 10 (ke) nỹtĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kỹ ũ tỹ ti kãmur régre mãg mũ ẽn vỹ tỹ rãnhrãj mũ gé. Ti kãmur régre ũ mãg tóg mũ sir, ã rãnhrãj to, kỹ tóg tỹ 4 (ke) nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ag jãvo ũ tỹ ti kãmur pir mãg mũ ẽn vỹ ã tũ nég tĩ mũ sir. Ã patrão tỹ ti mỹ jãnkamy nĩm ẽn nég tóg mũ, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kejẽn ag patrão vỹ vỹn ke mũ sir, si há tĩ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kỹ ti camarada tóg ti venh kãtĩ mũ, ũ tỹ ti kãmur tỹ 5 (ke) mãn ja ẽn ti. Kỹ tóg ti mỹ ũ tỹ 5 (ke) ũ ẽn ven mũ sir, ti ganho ti, kỹ tóg ã patrão mỹ: “ũ tỹ 5 (ke) vin ã tóg inh mỹ,” he mũ, “hã ra sóg tỹ rãnhrãj kỹ ũ tỹ 5 (ke) ũ mãn ja nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kỹ ti patrão tóg ti mỹ: “jykre há ã tóg nĩ,” he mũ. “Ã tũ ki rĩr há han ã tóg nĩ mỹr. Nén sĩ ki rĩr há han ja ã tóg nĩgtĩ, kỹ sóg ã mỹ nén ũ e vin sór mũ, ã tỹ ki rĩr jé. Ã patrão fe tỹ mrin ke ã mỹr. Hã inh mré kãtĩg,” he tóg, ti patrão ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kỹ ti camarada ũ tóg jun mũ gé, ũ tỹ ti kãmur régre mãn ja ẽn ti. Kỹ tóg ti mỹ: “inh mỹ ã tóg ti kãmur régre vin ja nĩ,” he mũ. “Tỹ rãnhrãj kỹ sóg ũn régre ũ mã. Hã vẽ ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kỹ ti patrão tóg ti mỹ: “jykre há ã tóg nĩ,” he mũ gé. “Ã tũ ki rĩr há han ã tóg nĩ mỹr. Nén sĩ ki rĩr há han ja ã tóg nĩgtĩ, kỹ sóg ã mỹ nén ũ e vin sór mũ, ã tỹ ki rĩr jé. Ã patrão fe tỹ mrin ke ã mỹr. Ha inh mré kãtĩg,” he tóg, ti patrão ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kỹ ti camarada ũ tóg jun mũ gé sir, ũ tỹ ti kãmur pir mãn ja ẽn ti. Kỹ tóg ti mỹ: “Senhor',” he mũ. “Vĩ tar han ã tóg tĩgtĩ, ki kanhró sóg nĩ. Ã tỹ nén krãn ja tũ ẽn mãg ã tóg tĩgtĩ, ã tỹ ti fy vãm tũ ra ã tóg ti kanẽ ve sór tĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hã kỹ sóg mũmẽg kỹ ti kãmur né. Ã tũ ti hã vẽ ha,” he tóg, ti patrão mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kỹ ti patrão tóg ti mỹ: “jykre kórég ã tóg nĩ,” he mũ. “Ã tũ ki rĩr kónãn ã tóg nĩ mỹr. Inh mỹ isỹ nén krãn ja tũ mãg tĩgtĩ'? Inh mỹ isỹ nén ũ fy vãm tũ ra ti kanẽ ve sór tĩgtĩ'? Hã ki kanhró ã mỹ nĩ'? ");
INSERT INTO kgpNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ã tỹ ne jé inh jãnkamy tỹ banco ki rãnhrãj tĩ ag mỹ vin ja tũ nĩ nẽ? Kỹ sỹ ti juro ven kỹ sóg isũ kãfór mãn ke vẽ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ti tũ ma ra,” he tóg mũ sir, polícia ag mỹ. “Inh camarada ũ mỹ nĩm, sỹ ti mỹ nĩm ja ẽn ti. Ũ tỹ ti kãmur tỹ 10 (ke) mãg mũ ẽn mỹ nĩm, ti kãmur pir tỹ, sỹ ũn jykre kórég tag mỹ nén nĩm ja ẽn ti,” he tóg, ag patrão ti, polícia ag mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Ge ti nĩ. Ũn tũ mág vỹ mãn mãn mũ, kỹ tóg ti mỹ tũ' henh ke tũ pẽ nĩ. Ũn tũ tũ ẽn tũ sĩ mãn jé ag tóg ke mũ, kỹ tóg tỹ tũ tũ nĩ sir,” he tóg, patrão ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","“Kỹ inh camarada kórég tag fón, kutyg ja ẽn kãkã. Tá ag tóg jagtar tĩ, ãjag jã tỹ ag gyngyn ke tĩ, vẽso jũ kỹ,” he tóg, patrão ti,” he tóg, Jesus ti, ã tỹ ã kãtĩg mãn ke kãmén kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kỹ Jesus tóg ag mỹ: “ẽprã ke fi kósin ẽn kãtĩg mãn kỹn ge nĩnh mũ, ha mẽ,” he mũ. “Inh kãtĩg mãn kỹ sóg tar pẽ kãtĩ mũ, sĩnvĩ. Isỹ jẽgnẽ jafã ag vỹ inh mré kãmũnh ke mũ. Kỹ sóg inh nĩgja kri nĩnh ke mũ sir, kỹ inh jykre tar vỹ vẽnh ven ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kỹ ẽprã ke kar vỹ inh jo vẽnh mãn kãn ke mũ sir. Kỹ sóg vẽnh kar vẽnh kãpãm ke mũ sir, ha mẽ. Carneiro mré cabrito ki rĩr tĩ ẽn vỹ kejẽn ã mẽg vẽnh kãpãm tĩ. Carneiro ag tỹ tóg vyrmỹ vin tĩ, cabrito ag tỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kỹ tóg carneiro ag tỹ ã pẽgja tá vin tĩ, jó tóg cabrito ag tỹ ã jakãnh tá vin tĩ. Tag ri ke han jé sóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tỹ sóg vẽnh kar kri pã'i mág nĩnh mũ, kurã ẽn kã. Kỹ sóg inh pẽgja tá nỹtĩnh ke mũ ag mỹ: “ha inh mré kãmũ jẽg,” henh ke mũ. “Inh panh vỹ ãjag to vĩ há han mũ mỹr. Topẽ tỹ ga tãg mré kanhkã tãg venh kãmũ jẽg. Topẽ tỹ ga han kurã ẽn kã tóg ãjag hã kuprẽg ja nĩ, ãjag tỹ ti tỹ ga tãg mré kanhkã tãg tag ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kejẽn sóg kókĩr nĩ ja nĩgtĩ, kỹ ãjag tóg inh jẽn. Isỹ kron há nĩn kỹ ãjag tóg inh mỹ goj jun. Isỹ ãjag ĩn tá jun kỹ ãjag tóg inh mỹ: “ha kãrã, ẽg mré nĩ,” he ja nĩgtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Inh kur tũ nĩn kỹ ãjag tóg inh mỹ kur vin. Inh kaga nĩn kỹ ãjag tóg inh venh kãmũ ja nĩgtĩ. Ise kỹ jẽ kỹ ãjag tóg inh venh kãmũ ja nĩgtĩ gé,” he jé sóg ke mũ ag mỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Kỹ ũn jykre kuryj tag ag vỹ inh mỹ: “Senhor',” henh ke mũ. “Ẽg hẽ kã ã kókĩr vé, ẽg tỹ ã mỹ vẽjẽn ven jé? Ẽg hẽ kã ã kron há tĩ vé, ẽg tỹ ã mỹ goj ven jé? ");
INSERT INTO kgpNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ã hẽ kã ẽg ĩn tá jun, ẽg tỹ ã mỹ: “ha kãrã,” he jé? Ẽg hẽ kã ã kur tũ vé, ẽg tỹ ã mỹ kur vin jé? ");
INSERT INTO kgpNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ẽg hẽ kã ã kaga vé, ẽg hẽ kã ã se vé, ẽg tỹ ã venh kãmũ jé? Ki kagtĩg ẽg nỹtĩ,” he jé ag tóg ke mũ, inh mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kỹ sóg ag mỹ: “ũn jagãgtar ag jagãgtãn ja ãjag tóg nĩgtĩ, inh mré ke ag, hã ra tóg ãjag tỹ inh jagãgtãn ri ke nĩ, ãjag tỹ ag jagãgtãn ja ti, ki hã sóg tó mũ,” he jé sóg ke mũ, isỹ tỹ pã'i mág nĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kỹ sóg inh jakãnh tá nỹtĩ ag mỹ: “ha mũjẽg, tãra,” henh ke mũ gé. “Inh panh vỹ ãjag mỹ vĩ kónãn. Pĩ nhyr vãnh ra mũjẽg. Nén-Kórég mỹ tóg kar kỹ nĩ, pĩ nhyr vãnh ẽn ti, Nén-Kórég tỹ jẽgnẽ jafã ag mỹ tóg kar kỹ nĩ gé. Ẽn ra mũjẽg. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Inh kókĩr ra ãjag pi(jé) inh mỹ vẽjẽn ven'. Isỹ kron há ra ãjag pi(jé) inh mỹ goj jun'. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Isỹ ãjag ĩn tá jun mũ ra ãjag pi(jé) inh mỹ: “ha kãrã,” he ja nĩgtĩ'. Isỹ kur tũ ra ãjag pi(jé) inh mỹ ũ vin'. Inh kaga nỹ ra, ise kỹ jẽ ra ãjag pi(jé) inh venh kãmũ ja nĩgtĩ',” he jé sóg ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Kỹ ag tóg inh mỹ kenh ke mũ gé. “Senhor',” he jé ag tóg ke mũ gé. “Ẽg hẽ kã ã kókĩr vé, ã kron ha ti? Ã hẽ kã ẽg ĩn tá jun'? Ẽg hẽ kã ã kur tũ vé', ã kaga ti', ã se ti', ẽg tỹ ã ki rĩr jé? Ki kagtĩg ẽg nỹtĩ,” he jé ag tóg ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kỹ sóg ag mỹ: “ũn jagãgtar ag jagãgtãn ja tũ ãjag tóg nĩgtĩ,” henh ke mũ, “hã kỹ tóg ãjag tỹ inh jagãgtãn tũ ri ke nĩ, ki hã sóg tó mũ, mỹr, ha mẽ,” he jé sóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kỹ ag tóg jagãgtar kenh ke mũ, hã ra tóg tũ' henh ke tũ nĩ, ag jagtar ke ti. Ag jãvo ũn jykre há ag vỹ rĩr krỹg ja tũ venh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Vãhã tóg tó kãn ja nĩgtĩ, ti tỹ nén tónh ke ja ti, Jesus ti. Kỹ tóg ã mré mũ tĩ ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“kurã régre tũg kỹ tóg ẽg festa mág tỹ Páscoa nĩ,” he mũ. “Ẽn kã ag tóg ẽprã ke fi kósin ti senh ke mũ, kỹ ag tóg ti fẽg ke mũ, ka to ti sa jé. Inh hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hã ra Topẽ tũ ki rĩr tĩ to pã'i mág ag vỹ vẽnh mãn mũ sir, Topẽ vĩ to professor ag mré hã, kófa ag mré ke gé. Pã'i mág ĩn tá ag tóg vẽnh mãn mũ sir, pã'i ẽn jijin hã vỹ: Caifás, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kỹ ag tóg Jesus se to jykrén mũ sir. Ag tỹ ti vatánh tá ti kãgmĩ sór vẽ, ti se jé, ti tén jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kỹ ag tóg to jykrén kỹ: “festa tag to mẽ jé ẽg tóg ke mũ ver,” he mũ. “Ẽg tỹ festa kã ti se kỹ vẽnh génh mág hỹn tóg kutẽnh mũ, ha vemnĩ,” he ag tóg mũ sir jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ẽn kã Jesus tóg kejẽn ẽmã tỹ Betânia tá nĩ nĩ, Simão ĩn krẽm, vẽnh kaga kren vãnh han ja ẽn ĩn krẽm. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ti jẽg nĩ ra ũ fi tóg tá jun mũ, garrafa mãn kỹ. Pó kupri tãnãj tỹ tóg há nĩ, garrafa ti. Ti ki nĩ vỹ tỹ nén kar tãg nĩ, ger há ẽn, ũn kaja e ẽn. Ti gãnh tãg fi tóg mũ, ger há ẽn tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kỹ ti mré mũ tĩ ag tóg fi vég mũ, hã ra tóg ag mỹ kórég nĩ. Fi to jũ kỹ ag tóg: “fi tỹ ne jé nén kaja e kókén nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Ẽg tỹ ger há tag fón ke vẽ vẽ, kaja há to, ẽg tỹ ũn jagãgtar ag mỹ vin jé,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Kỹ Jesus tóg mẽg mũ, ag vĩ ti, kỹ tóg ag mỹ: “ãjag tỹ ne jé fi mỹ kaga han nẽ?” he mũ. “Inh jykre ki króm fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Inh hã tóg ver nĩ sĩ han mũ, ãjag mré, jãvo ũn jagãgtar ag vỹ kurã kar ki ãjag mré nỹtĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Fi tỹ inh kãn vẽ, ag tỹ vẽnh kej tá inh fón jé hã jé fi tóg ger há tag tỹ inh kri kujẽg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ag tỹ vẽnh vĩ sér tugtón kỹ ag tóg fi tỹ nén han mũ tag tónh ke mũ gé, ga kar mĩ hã, kỹ vẽnh kar vỹ fi tỹ nén han mũ mẽnh ke mũ, ha vemnĩ. Ki hã sóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kar kỹ ũ tỹ 12 (ke) ag kã ũ tóg Topẽ tũ ki rĩr tĩ to pã'i ag venh tĩ mũ. Ũn tĩg mũ jyjyn hã vỹ: Judas Iscariotes, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tá jun kỹ tóg ag mỹ: “sỹ ãjag mỹ Jesus ven ke vẽ, ãjag tỹ ti se jé,” he mũ. “Ãjag mỹ inh mỹ kajãm ke tũ, sỹ ãjag mỹ ti ven ke ti?” he tóg. Kỹ ag tóg ti mỹ: “vó,” he kỹ jãnkamy tỹ 30 (ke) tỹ kajãm mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti tỹ jãnkamy ẽn mãn kar kỹ tóg to jykrén mũ. “Inh hỹn hẽ ri kenh mũ, isỹ vẽnh kar vatánh tá ag mỹ Jesus ven jé?” he tóg mũ sir, Judas ti, ón kỹ Jesus mré tĩ mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kejẽn tóg pão jẽgja tũ konh ke kurã tá krỹg mũ, kỹ Jesus mré mũ tĩ ag tóg ti mỹ: “ẽg hỹn hẽ tá ã mỹ carneiro sĩ tãnh mũ, ẽg tỹ kon jé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kỹ tóg ag mỹ: “ẽmã mág tag ra mũjẽg,” he mũ. “Tá ũ tóg nĩ nĩ. Ti mỹ: “ẽg Senhor vỹ ã mỹ vẽnh vĩ jẽnẽg mũ,” hemnĩ. “Inh kurã vỹ kakó tĩ ha, kỹ sỹ ã ĩn krẽm Páscoa konh há tóg tĩ, inh mré mũ tĩ ag mré,” he tóg mũ,” hemnĩ ti mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kỹ ag tóg mũ mũ sir, ti mré mũ tĩ ag. Ti tỹ ag mỹ tó mũ han ag tóg mũ sir. Cordeiro tãnh ag tóg mũ sir, ag tỹ Páscoa kã ko tĩ ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Rã pur kar kỹ tóg tá jun kỹ ũ tỹ 12 (ke) ag mré nĩ mũ sir, jẽn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ag jẽn kã tóg ag mỹ: “ãjag kãmĩ ũ tóg pã'i ag mỹ inh ven ke mũ, ag tỹ ise jé, ki hã sóg tó mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kỹ tóg ag fe kaj tĩ sir, kỹ ag tóg ti mỹ: “inh mỹ vó'? Inh mỹ vó'?” he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kỹ tóg ag mỹ: “ũ tỹ inh mré pão tỹ kã punpun mũ ẽn hã vẽ,” he mũ. “Ũ tỹ ã nĩgé tỹ pénky kãki pão tỹ kã punpun mũ ẽn hã vẽ. Ẽn hã vỹ ag mỹ inh ven ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","“Tĩg jé sóg ke mũ, isỹ tỹ ẽprã ke fi kósin nĩn kỹ. Hã kỹ tóg rán kỹ nĩ, isĩg ke ti. Hã ra ũ tỹ ag mỹ inh ven ke mũ ẽn mỹ tóg vĩ kónãn tãvĩ han ke mũ, Topẽ ti. Ti tỹ mur ja tũ nĩ ra tóg ti mỹ há tĩ vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kỹ Judas tóg ti mỹ ke mũ gé sir, ũ tỹ pã'i ag mỹ ti ven ke mũ ẽn ti. Ẽn tóg ti mỹ: “Senhor', inh hã mỹ'?” he mũ gé. Kỹ tóg ti mỹ: “ki hã ã tóg tó mũ,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kỹ ag tóg jẽg mũ. Ag jẽn nỹtĩ ra Jesus tóg ẽmĩ mãg mũ sir. Topẽ mré tóg vĩ mũ sir, ẽmĩ to, kỹ tóg vẽnh kã kugpãn kỹ ag mỹ vẽnh kãpãm mũ sir, ti mré mũ tĩ ag mỹ. Kỹ tóg: “té, ha kó,” he mũ. “Inh hã vẽ,” he tóg, ẽmĩ to. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kar kỹ tóg copo vãg mũ gé sir, vinho tỹ ki jẽn kỹ. To tóg Topẽ mré vĩ mũ gé. Ag mỹ copo jun kỹ tóg: “ha kronkron,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Inh kyvénh hã vẽ,” he tóg, vinho to. “Inh kyvénh tỹ vẽnh kar jagfy kutẽn hã vẽ. Sỹ vẽnh e mré vẽnh jykre tãg han to ke hã vẽ, hã vỹ tỹ inh kyvénh ti nĩ. Inh kyvénh tag to Topẽ vỹ ãjag mỹ vẽnh pãte fón ke mũ, ãjag tỹ ti vĩ mranh ja ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","“Ha mẽ, uva me kron mãn ke tũ inh nĩ ha. Kejẽn sóg kron mãn ke mũ, inh panh tỹ tỹ ẽg pã'i nĩnh ke kurã ẽn kã. Kỹ sóg ãjag mré kron mãn ke mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kỹ ag tóg jãn mũ gé sir, ag jẽn kar kỹ. Ag tỹ Topẽ jé tó kar kỹ ag tóg krĩ tỹ Oliveiras ra mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ag tỹ ra mũn kỹ Jesus tóg ag mỹ kãmén mũ. “Kuty tag kã ãjag tóg inh fón kỹ mũ kãn ke mũ,” he tóg mũ, ã mré mũ tĩ ag mỹ. “Hã kỹ tóg rán kỹ nĩ. “Ũ tỹ carneiro ki rĩr tĩ ẽn tãnh jé sóg ke mũ, kỹ ti mẽg ag vỹ krig ke kãn ke mũ,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki,” he tóg, Jesus ti. “Hã ve jé ãjag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Hã ra sóg iser kar kỹ rĩr mãn ke mũ. Ẽn kã sóg ãjag jo tĩg ke mũ, ga tỹ Galiléia ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kỹ Pedro tóg ti mỹ: “inh pi(jé) ã fón kỹ tĩg ke mũ', ag kar tỹ ã ré kỹ mũ mũ ra,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Hã ra Jesus tóg ti mỹ: “ha vé,” he mũ. “Ũri, kuty tag kã ã tóg iso: ti ki kagtĩg sóg nĩ, he tãgtũ han ke mũ, galo kyr to hã. Ki hã sóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Hã ra Pedro tóg ti mỹ: “sỹ ã mré ter ke mũ ra sóg ã to: ti ki kagtĩg sóg nĩ, henh ke tũ pẽ nĩ,” he mũ. Kỹ ti mré mũ tĩ ag tóg hã tó kãn mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kỹ Jesus tóg ka krãn ja tá jun mũ sir, ag mré, ka krãn ja ẽn jijin hã vỹ: Getsêmani, he mũ. Kỹ tóg ã mré mũ tĩ ag mỹ: “ha ver nĩgnĩ, tag ki,” he mũ. “Sỹ ver Topẽ mré vĩnh ke vẽ, tãtá,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kỹ tóg Pedro mré Zebedeu krẽ ag mỹ: “inh mré kãmũ jẽg,” he mũ. Kỹ tóg fe kaj nĩ sir. Mũmẽg tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kỹ tóg ag mỹ: “inh fe kaj mág tóg tĩ,” he mũ, “kỹ inh fe kaj tóg inh mỹ iser ri ke nĩ,” he tóg. “Tag ki nỹtĩmnĩ, nũgnũr tũg nĩ, inh ri kén,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kỹ tóg tĩg sĩ han mãn kỹ mũg ke mũ sir, Jesus ti, kỹ tóg ga kri nỹ mũ. Topẽ mré tóg vĩ mũ. “Panh',” he tóg mũ. “Mỹ ã tỹ inh jagtar ke tag tỹ tũ' he jãvãnh?” he tóg. “Hã ra isỹ ã mỹ nén to vĩ mũ tag han tũg nĩ. Ã tỹ nén han ke mũ ẽn hã han nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kar kỹ tóg ã mré mũ tĩ ag venh tĩ mũ sir, hã ra ag kar tóg nũgnũr ja nĩ. Kỹ tóg Pedro mỹ: “mỹ ãjag mỹ hora pir ki nũr tũ kórég?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","“Nũr tũg nĩ, Topẽ mré vĩmnĩ, ãjag tỹ ti vĩ mranh tũ nĩ jé, ũ tỹ ãjag kutãn mũ ra. Ãjag tỹ mranh sór tũ vẽ vẽ, hã ra ãjag tóg to krój nỹtĩ, hã kỹ ãjag tóg mranh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kỹ tóg tĩg mãn mũ sir, kỹ tóg Topẽ mré vĩ mãn mũ. Kỹ tóg: “panh',” he mãn mũ. “Ã tỹ inh jagtar ke tag tỹ tũ' henh jãvãnh nĩn kỹ sóg jagtar ke mũ. Ã tỹ isỹ nén han ke mũ ẽn han nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kỹ tóg ag venh tĩg mãn mũ gé sir, hã ra ag tóg nũgnũr mãn nỹtĩ, ag nũr há pẽ tĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kỹ tóg ag mỹ vĩ tũ ra tĩ mũ sir, Topẽ mré vĩ mãn jé. Ti mỹ tóg ã tỹ tó ja ẽn tó mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kỹ tóg ã mré mũ tĩ ag venh tĩg mãn mũ gé sir, kỹ tóg ag mỹ: “ãjag ne tóg nũgnũr ja nĩ'” he mũ, “vẽnhkán ja ãjag tóg nĩ',” he tóg mũ. “Pétẽm ti huri, hora ti. Ti tỹ ag mỹ inh fẽg ke nẽ ha, Topẽ vĩ mranh tĩ ag mỹ, isỹ tỹ ẽprã ke fi kósin nĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","“Nĩgnĩ ra, mũ jé ha. Ũ tỹ ag mỹ inh ven mũ vỹ jun ke mũ ha,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ti tỹ ver tỹ vẽmén jẽ ra Judas tóg jun mũ sir. Ũ tỹ 12 (ke) ag kã ũ ẽn vẽ, Judas ti. Ti mré polícia ag tóg kãmũ mũ. Rógro génh kỹ ag tóg kãmũ mũ, ka kykyv génh kỹ ke gé. Topẽ tũ ki rĩr tĩ to pã'i ag tỹ ag jẽgnẽ vẽ, kófa ag tỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Hã ra ũ tỹ ag mỹ Jesus ven ke mũ ẽn tóg ag mỹ: “ti ki sóg nhun kenh mũ,” he ja nĩ. “Sỹ ũn ki nhun ke mũ ẽn hã semnĩ,” he ja tóg nĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hã kỹ tóg vẽsỹmér Jesus to grẽn ke kỹ ti mỹ: “ã mỹ há, Senhor'?” he mũ. Kỹ tóg ti ki nhun ke mũ, Judas ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hã ra Jesus tóg ti mỹ: “régre',” he mũ. “Ã tỹ nén han ke mũ ẽn han nĩ,” he tóg. Kỹ polícia ag tóg vẽsỹmér ti to ge kỹ ti ség mũ sir, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kỹ Jesus mré tĩ tĩ ũ tóg rógro kunũnh kỹ polícia ũ nĩgrẽg kym mũ sir. Topẽ tũ ki rĩr tĩ to pã'i mág camarada vẽ, ti tỹ ũn nĩgrẽg kym mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hã ra Jesus tóg ti mỹ: “ã rógro fẽg han ra,” he mũ. “Ẽg tỹ rógro tỹ ke kỹ ag tóg rógro tỹ ẽg tén ke mũ gé, ha vemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","“Isỹ inh panh mỹ to vĩ mũ ra tóg inh mỹ ã tỹ jẽgnẽ jafã ag jẽgnẽnh ke mũ vẽ, ũn e ẽn, 12 mil (ke) kãfór, ag tỹ ijy nĩgãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hã ra sóg ve sór mũ, nén tỹ iso rán kỹ nĩ ẽn ti, hã kỹ sóg ti mỹ tag to vĩ tũ nĩ. Ve jé sóg ke mũ ha, inh jagtar ke ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ẽn kã tóg polícia ag mỹ: “ãjag ne tóg rógro génh kỹ kãmũ mũ', ka kykyv mré', ãjag tỹ ise jé',” he mũ. “Inh pi(jé) tỹ bandido nĩ'. Kurã kar ki sóg ãjag mré jẽ ja nĩgtĩ, Topẽ jo ĩn krẽm. Vẽnh kar kanhrãn kỹ sóg tá nĩ ja nĩgtĩ, hã ra ãjag tóg tá iség tũ nĩ vẽ mỹr,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","“Hã ra sóg nén tỹ iso rán kỹ nĩ ẽn vég mũ, Topẽ vĩ tó tĩ ag tỹ iso nén rán ja ẽn ti, hã kỹ ãjag tóg ke mũ,” he tóg, Jesus ti. Kỹ ti mré mũ tĩ ag tóg ti ré kỹ pétẽ kãn mũ sir, vẽnh pigju jé, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kỹ ũ tỹ ti ség mũ ag tóg ti pére mũ mũ, Topẽ tũ ki rĩr tĩ to pã'i mág ra, hã vỹ: Caifás, he mũ. Tá ag tóg vẽnh mãn kỹ nỹtĩ, Topẽ vĩ to professor ag, kófa ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Hã ra Pedro tóg Jesus nón kãtĩ mũ, kuvar há tá, kỹ tóg Topẽ tũ ki rĩr tĩ to pã'i mág ĩn kãra rã mũ sir. Polícia ag mré tóg tá nĩ nĩ. Ti tỹ ag tỹ Jesus tỹ hẽn ri kenh ke mũ ẽn ve sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag tóg ũ ag jãvãnhvãnh mũ, ag tỹ Jesus jykre kórég tó jé. Ti vĩ to ag tóg ti tén sór mũ, kófa ag, vẽnh jyvẽn tĩ kar ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hã ra ag tóg ũ tỹ ki hã tó mũ vég tũ nĩ. Ũ tỹ hẽn ri ke ag tóg ón kỹ ti jykre kórég tó mũ, hã ra tóg ag mỹ ki krov tũ nĩ. Kỹ vãhã ũn régre ag tóg tá junjun kỹ ón kỹ ti to vĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ẽn ag vỹ tóg sir: “ti vĩ vẽnhmỹ mẽ ẽg,” he mũ. “Topẽ jo ĩn kókén há inh nĩgtĩ, he ja tóg nĩ. Kókén kar sóg ũ han mãn ke mũ. Kurã tãgtũ ki tóg kar kỹ nĩ, ĩn ti, ha vemnĩ, he ja tóg nĩ, Jesus ti,” he ag tóg mũ, ón kỹ ti to vĩ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kỹ Topẽ tũ ki rĩr tĩ to pã'i mág vỹ jẽgnẽ mũ sir, kỹ tóg ti mỹ: “ã tỹ nén tónh ke mỹ tũ'?” he mũ. “Ag hã ne ã vĩ kónãn tag tó ja nĩ gé'” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Hã ra Jesus tóg hun ke mũ, nén ũ tó mẽ kã. Kỹ pã'i mág tóg ti mỹ: “Topẽ vỹ rĩr nĩ,” he mũ. “Ũn rĩr nĩ vỹ ẽg vég mũ. Ti rĩnve sóg ã ki jẽmẽg mũ. Ã mỹ tỹ Cristo nĩ', ã mỹ tỹ Topẽ kósin nĩ'? Ha ẽg mỹ tó,” he tóg, pã'i mág ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kỹ Jesus tóg ti mỹ: “ki hã ã tóg tó mũ,” he mũ. “Kỹ sóg ãjag mỹ tag tó mũ gé, ha mẽ. Ẽprã ke fi kósin ẽn vỹ tỹ inh nĩ,” he tóg. “Kỹ ãjag tóg ũ tỹ nén (ũ) kar han mũ ẽn pẽgja tá inh venh ke mũ. Kỹ sóg kanhkã góg kãmĩ kãtérenh ke mũ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kỹ pã'i mág ẽn tóg ã kur tỹ jaran' ke mũ sir, jũ kỹ. Kỹ tóg: “Topẽ kato vĩ kónãn ti huri,” he mũ. “Mẽ kãn ẽg mỹr, kỹ ẽg tóg ũ tỹ ti jykre kórég tónh ke ũ jãvãnh mãn ke tũ nĩ ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","“Ẽg hỹn ti tỹ hẽ ri kenh mũ ha?” he tóg. Kỹ ag tóg ti mỹ: “ter jé tóg ke mũ, ti vĩ tag to,” he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kỹ ag tóg ti kakã to sugsug mũ sir, ti kakã ki tãnh ag tóg mũ gé sir. Ag kã ũ tóg ti vatánh tá ti tãnh kỹ ti mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Cristo nẽji tỹ ã jẽ, kỹ ã nẽji nén kar ki kanhró nĩ,” he mũ. “Ũ nỹ ã tãnh?” he tóg mũ gé. Ti tãnh kỹ tóg ke mũ. Gen kỹ ag tóg ti to é he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hã ra Pedro vỹ re tá nĩ nĩ, ĩn vãso kã. Kỹ pã'i camarada ũ fi tóg ti ve jé kãkutẽ mũ, kỹ fi tóg ti mỹ: “Jesus mré ã tóg tĩg mũ gé, Galiléia tá ke ẽn mré,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hã ra tóg: “vó,” he mũ. “Ã tỹ ne tó nẽ hỹn'?” he tóg mũ, Pedro ti. Kỹ ag kar vỹ ti vĩ mẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kỹ tóg jãnkã fĩn rãm sór mũ. Hã ra ũ fi tóg ti vég mũ gé, kỹ fi tóg tá ke ag mỹ: “Jesus mré ke ũ vẽ, Nazaré tá ke ẽn mré ke ũ vẽ,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hã ra tóg: “vó,” he mãn mũ. “Ti ki kagtĩg sóg nĩ, Topẽ vỹ ki kanhró nĩ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Si há ke tũ ra ũ tỹ tá nỹtĩ ag kã ũ ag tóg ti venh kãmũ kỹ ti mỹ hã tó mãn mũ gé. Kỹ ag tóg Pedro mỹ: “ha mẽ, ag kã ũ vỹ tỹ ã nĩ,” he mũ. “Ã vĩ ki ẽg tóg ã ki kanhrãn mũ,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Hã ra tóg: “vó',” he mãn mũ. “Inh pi(jé) ti ki kanhró nĩ'. Inh ón mũ ra Topẽ vỹ inh vóg kónãn mũ vẽ,” he tóg, Pedro ti. Hã ra vẽsỹmér galo tóg kyr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kỹ Pedro tóg Jesus vĩ to jykrén mũ, ti tỹ ti mỹ: “iso ã tóg: ti ki kagtĩg sóg nĩ, he tãgtũ han ke mũ, galo kyr ke to hã,” he ja ẽn mĩ. Tag mĩ ẽkrén kỹ tóg tá kãkutẽ mũ sir, hã ra tóg fỹ jagy han mũ sir, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tỹ vaj kỹ kusã ki ag tóg Jesus to jykrén mũ sir, Topẽ tũ ki rĩr tĩ to pã'i ag, kófa ag mré hã. Ag tỹ ti tén sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kỹ ag tóg ti mrĩnh mũ sir. Ti pére mũn kỹ ag tóg pã'i mág tỹ governador mỹ ti fẽg mũ sir, Pilatos ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Hã ra Judas tóg vég mũ. Pã'i ag mỹ tóg Jesus ti ven ja nĩ, ag tỹ ti se jé. Kỹ tóg ag tỹ ti tén sór mũ tag vég mũ, Judas ti. Kỹ tóg to jykrén mãn mũ sir. Vãhã tóg ti mỹ e tĩ. Kỹ tóg jãnkamy tỹ prata ẽn ma kãtĩ mũ sir, ũ tỹ 30 (ke) ẽn. Ma kãtĩg kỹ tóg Topẽ tũ ki rĩr tĩ to pã'i ag mỹ ven mũ, kófa ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kỹ tóg ag mỹ: “ti kórég han inh,” he mũ. “Ti pi(jé) nén ũ kórég han ja nĩgtĩ', hã kỹ tóg vẽnhmỹ nĩ, ti tỹ inh vĩ to ter kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hã ra ag tóg ti mỹ: “ẽg tũ pijé',” he mũ. “Ã tũ hã nẽ',” he ag tóg mũ. Kỹ tóg jãnkamy ẽn vãm mũ sir, Topẽ jo ĩn krẽm, kỹ tóg hẽn ra tĩ mũ sir. Tá tóg ã nunh kã vẽnh jãján mũ sir, kỹ tóg ter mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag vỹ jãnkamy ẽn mãn kỹ to jykrén mũ. “Ẽg tỹ Topẽ mỹ jãnkamy tag vin kỹ tóg vẽnhmỹ tĩ. Vẽnh kyvénh kajãm ja ti nĩ, hã kỹ ẽg tóg Topẽ mỹ vin sór tũ nĩ,” he ag tóg mũ sir, jãnkamy ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kỹ ag tóg to vẽnh mãn kỹ to jykrén mũ. To jykrén kỹ ag tóg tỹ ẽpỹ kajãm mũ, ag tỹ tá go'or vég tĩ ẽn. Tá ag tóg fóg ag kej han sór mũ, fóg tỹ Jerusalém ra pasa tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hã kỹ ẽg tóg ẽpỹ ẽn to: “ẽpỹ kyvénh,” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Hã ra Topẽ vĩ tó tĩ tỹ Jeremias vỹ Judas to tag rán ja nĩ, ha mẽ: “jãnkamy tỹ 30 (ke) tỹ ag tóg ẽpỹ kajãm ke mũ. Jãnkamy ẽn tỹ ag tóg ẽprã ke ũ kajãm vén ke mũ, Israel ag, ti kaja tag tỹ ag mỹ há nỹn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ẽprã ke ẽn tỹ kajãm kar kỹ ag tóg tỹ ẽpỹ kajãm mũ sir, ag tỹ tá go'or vég tĩ ẽn. Hã tó ja tóg nĩ, inh mỹ, ẽg jóg tỹ Topẽ ti,” he ja tóg nĩgtĩ, Jeremias ti. Hã ra tóg ge nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hã ra Jesus tóg fóg tỹ pã'i mág rã jẽ nĩ. Kỹ pã'i mág tóg ti ki jẽmẽ sór mũ, kỹ tóg: “ã mỹ tỹ Judeu ag pã'i nĩ'?” he mũ. Kỹ Jesus tóg ti mỹ: “ki hã ã tóg tó mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag tóg ti kato vĩ mág han mũ, kófa ag ke gé, hã ra tóg hun ke kỹ jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kỹ Pilatos tóg ti mỹ: “mỹ ã mỹ tỹ nén ũ tũ nĩ, ag tỹ ã kato vĩ mág han mũ tag ti?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hã ra Jesus tóg vĩ mãn tũ nĩ, kỹ tóg Pilatos mỹ e tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hã ra Pilatos tóg ag mỹ vése ag kar kã ũn pir kavãg tĩ, festar tỹ Páscoa kar ki. Ti jykre vẽ. Ag tỹ ũn to vĩ mũ ẽn kyvãg tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kỹ ũ tóg se kỹ jẽ nĩ, ẽn kã. Ũn vẽnhmỹ vẽ, ũ tỹ ag ri ke tũ, ti jijin hã vỹ: Barrabás, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jãvo ag tóg tá vẽnhmãn kỹ nỹtĩ, Judeu kar ag. Kỹ Pilatos tóg ag mỹ: “inh hỹn ũ kavãn ha?” he mũ. “Ũ nỹ ãjag mỹ há nĩ? Barrabás mỹ, Jesus mỹ vó, ag tỹ ũ to: “Cristo vỹ tỹ ti nĩ,” he tĩ ẽn?” he tóg, Pilatos ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pã'i ag tỹ véké Jesus to jũ nỹtĩn ki kanhró tóg nĩ, Pilatos ti. Ti há nĩn hã kỹ ag tóg ti to jũ mũ, hã kỹ tóg ti kavãn sór mũ, Pilatos ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Fóg tỹ pã'i ẽn tỹ vẽnh jyvẽn jafã tá nĩn kỹ ti prũ fi tóg ti mỹ vẽnh vĩ jẽnẽg mũ, kỹ fi tóg ti mỹ: “vẽnh jykre kuryj han ti tĩ,” he mũ, Jesus to. “Hã kỹ ti vóg sór tũg nĩ. Kuty tag kã sóg ti to vẽnh péti kónãn, ẽg jagtar ke ti ve inh, inh vẽnh péti ki,” he fi tóg, Pilatos mỹ vẽnh vĩ jẽnẽn kỹ, hã kỹ tóg ti kavãn sór tãvĩ han mũ, Pilatos ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hã ra Topẽ tũ ki rĩr tĩ to pã'i ag tóg vẽnh kar krĩn mũ sir, kófa ag mré, vẽnh kar ag tỹ Barrabás kavar kỹ jẽ ve sór jé, ag tỹ Jesus ter ve sór jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kỹ fóg tỹ pã'i tóg ag ki jẽmẽ mãn mũ. “Inh hỹn ũn régre tag ag kã ũ tỹ hẽ kavãn mũ ha?” he tóg. Kỹ ag tóg ti mỹ: “Barrabás ti,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kỹ Pilatos tóg ag mỹ: “kỹ inh Jesus tỹ hẽ ri kenh mũ?” he mũ. “Ag tỹ ũ to: “Cristo vỹ tỹ ti nĩ,” he tĩ ẽn tỹ inh hẽ ri kenh mũ?” he tóg. Kỹ ag tóg ti mỹ: “cruz to ti sã,” he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Kỹ fóg tỹ pã'i tóg ag mỹ: “ti kórég tỹ ne han ti?” he mũ. Hã ra ag tóg prẽnprẽr mũ sir. “!..Cruz to ti sã..!” he ag tóg mũ sir, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ag tỹ hẽ ri ke tũ tóg nĩ, Pilatos ti, hã kỹ tóg ag mỹ hã han sór mũ. Vẽnh génh kutẽ nĩ ve tóg nĩ, hã kỹ tóg goj jé prẽr mũ. Kỹ tóg kã nĩgpég mũ sir, vẽnh kar rĩnve, Pilatos ti, kỹ tóg ag mỹ: “inh jykre pijé',” he mũ. “Inh nĩgé kavénh ke tũ ti nĩ, ti kyvénh ti. Ũn jykre kuryj vẽ, kỹ sóg ti tén jãvãnh nĩ. Ãjag jykre vẽ,” he tóg, Pilatos ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kỹ vẽnh kar ag tóg ti mỹ: “ẽg jykre vẽ,” he kãn mũ. “Ẽg hã ne ti tén sór mũ'. Kỹ Topẽ ẽg hã vóg kónãn ke mũ, ẽg krẽ ag ke gé, ti tỹ ti ter to ũ vóg kónãn ken kỹ,” he ag tóg, vẽnh kar ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kỹ Pilatos tóg Barrabás kavãn mũ sir. Jesus to tóg soldado ag mỹ: “ha ti mrãnmrãn,” he mũ sir. Ag tỹ ti mrãnmrãn kar kỹ Pilatos tóg ag mỹ ti fẽg, soldado ag tỹ ka to ti sa jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kỹ fóg tỹ pã'i krẽm soldado ag tóg Jesus pére mũ mũ, pã'i ĩn ra, ĩn tỹ Palácio do Governador ẽn ra. Kỹ ag tóg soldado ũ ag jé prẽr kãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ti kur kunũg ag tóg mũ, kỹ ag tóg kur kusũg tỹ ti kri fón mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sónh pirĩn kỹ ag tóg tỹ ti krĩ tógfĩg mũ sir, krĩ tógfĩn ja rẽr tỹ. Vãn tỹ ag tóg ti nĩgé kã fẽg mũ, ti pẽgja tá. Kỹ ag tóg ti krẽm grĩnhgrĩnh ke mũ sir, ón kỹ. Ti to é he ag tóg mũ, hã kỹ ag tóg: “viva, Judeu ag pã'i',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kỹ ag tóg ti to sugsug mũ gé. Vãn ẽn tỹ ag tóg ti krĩ mĩ mrãnmrãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ag tỹ ti nyg kar kỹ ag tóg ti ki kunũg mũ, kur ẽn ti. Kỹ ag tóg ti tũ pẽ tỹ ti kãra rãg mãn mũ sir. Kỹ ag tóg ti pére mũ mũ, ag tỹ cruz to ti san jé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ag mũn kã ag tóg ũ kato tẽ mũ, Cirene tá ke ũ, ti jijin hã vỹ: Simão, he mũ. Ẽn mỹ ag tóg vĩ tar han mũ, ti tỹ Jesus cruz vyn jé ti jo, hã kỹ tóg vyn kỹ tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gen kỹ ag tóg Gólgota tá junjun mũ sir. Gólgota to ẽg tóg: vẽnh krĩ kuka, he tĩ, ẽg vĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tá junjun kỹ ag tóg ti mỹ vinagre ven mũ, nén ũ tỹmẽ jynh mré ha. Kỹ tóg kron sĩ han mũ, hã ra tóg kron sór tũ nĩ, vẽnhkagta tag. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kỹ ag tóg cruz to ti sãg mũ sir. Ti kur tỹ ag tóg jagnẽ mỹ vẽnh kãpãm mũ sir, to ag tóg jogar he mũ gé, ti kur to, soldado ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kỹ ag tóg nĩgnĩg kỹ nỹtĩ, ti ki rĩr jé, soldado ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ag tỹ nén tỹ ti kato vĩ mũ vỹ rán kỹ nĩ, hã vỹ: “Jesus, Judeu ag pã'i tỹ rei vẽ,” he mũ. Ti kri tóg sa, vẽnh rán ti. Ti tỹ nẽji vẽsỹ pã'i tỹ rei han mũ to ag tóg ti tén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ti kóm ag tóg ũn régre ag tỹ cruz to sãg mũ gé, bandido ag. Kỹ ũ tóg ti pẽgja tá sa, jó ũ tóg ti jakãnh tá sa. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kỹ ũ tỹ mĩ mũ mũ ag tóg ti nyg' he mũ gé, vỹn vỹn hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ã mỹ Topẽ jo ĩn kókén sór mũ'?” he ag tóg mũ. “Ã mỹ kurã tãgtũ ki ũ han mãn sór mũ'? Vẽnh kren han ra kema', cruz to kãtére kema', ã tỹ tỹ Topẽ kósin nĩn kỹ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ge ag tóg mũ gé. Topẽ tũ ki rĩr tĩ to pã'i ag, Topẽ vĩ to professor ag mré hã, kófa ag mré hã. Ti nyg ag tóg mũ gé, kỹ ag tóg jagnẽ mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ũ ag krenkren han tóg, hã ra tóg vẽnh hã kren han ki kagtĩg nĩ,” he mũ. “Israel pã'i tỹ rei jé cruz to kãtére kema', ẽg tỹ ve jé, ẽg tỹ ti ki ge jé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Topẽ ki ti nẽji rã kỹ jẽ, kỹ Topẽ jé ti kren han, ti tỹ ti to há nĩn kỹ. “Topẽ kósin vỹ tỹ inh nĩ,” he ti mỹr,” he ag tóg ti to, ti nyg kỹ, Judeu pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kỹ bandido ag, ũ tỹ ti kóm cruz to nỹtĩ ẽn ag tóg ti nyg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rã tỹ ẽg nĩno kã sa ra tóg kuty' he mũ sir, ga kar mĩ hã. Kuty ẽn tóg hora tãgtũ tũg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","3 hora ki Jesus tóg prẽr mũ sir, kỹ tóg: “Eli, Eli, lemá sabactani?” he mũ. Ẽg vĩ ki ẽg tóg tag to: “Topẽ, Topẽ, ã tỹ ne jé isovãnh nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kỹ ũ tỹ tá nỹtĩ ag tóg mẽg kỹ (ag tóg) jagnẽ mỹ: “Elias jé tóg prẽr mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kỹ ũ tóg vẽnhvãg mũ sir, kỹ tóg esponja tỹ vinho prãg mũ, vinho kaja pir tỹ. Ka jurỹn kỹ tóg tỹ kusón kỹ vinho kãra rãg kỹ ti mỹ ven mũ sir, ti tỹ ki ũnh' ũnh' ke jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hã ra ũ ag tóg: “toreg',” he mũ. “Hẽn ri ke mũn Elias kãtĩg mũ, ti kren han jé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Hã ra Jesus tóg prẽr mág han mãn kỹ hun ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hã ra Topẽ jo ĩn krẽm kur tỹ jãnkã nĩfe tóg jaran ke mũ, ha mẽ, ti jar tóg vẽnh kãkym ke kãn mũ sir, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kỹ ga tóg ragra ke mũ gé sir, pãró vỹ gỹm ke mũ, vẽnh kej tỹ hẽn ri ke vỹ nugnor mũ, kỹ ũ tỹ Topẽ ki ge kỹ nỹtĩ tỹ hẽn ri ke ag tóg rĩnrĩr mãn mũ gé, ũn kãgter ja ag. Ãjag kej tá ag kãpa mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ẽn ag vỹ Jesus rĩr mãn kar kỹ tá kãpa kỹ cidade tỹ Jerusalém kãra ge mũ, kỹ ag tóg ũn mỹ vẽnh venven mũ sir, kỹ ũ tỹ hẽn ri ke ag tóg ag vigvég mũ, Jerusalém tá ke ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hã ra capitão tóg soldado ag mré Jesus ki rĩr jẽ nĩ. Ga tỹ ragra ke ẽn vég ag tóg mũ, nén kar ti, Jesus ter ẽn kã. Kỹ tóg ag mỹ e tĩ. Kỹ ag tóg: “hã ja vẽ,” he mũ. “Topẽ kósin ja vẽ mỹr,” he ag tóg mũ, capitão ag. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kỹ ũn tỹtá fag vỹ tá nỹtĩ gé, ũ tỹ hẽn ri ke fag. Kuvar há tá nỹtĩ kỹ fag tóg ti vég nỹtĩ nĩ. Ti mré fag tóg kãmũ ja nĩ, ga tỹ Galiléia tá. Ti ki fag rĩr ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Fag kã ũ fi vỹ tóg tỹ Maria Madalena fi nĩ, kỹ ũ fi tóg tỹ Maria fi nĩ gé, José mré Tiago mỹnh tag fi. Kỹ ũ fi vỹ tỹ Zebedeu krẽ ag mỹnh fi nĩ gé. Fag mré ke ũ fag vỹ tá nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rãké tóg nỹ ha, kỹ ũn há tóg tá jun mũ. Arimatéia tá tóg kãtĩg ja nĩ. Ti jijin hã vỹ: José, he mũ. Jesus mré ke ũ vẽ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ẽn vỹ tóg Pilatos venh tĩ mũ, kỹ tóg ti mỹ Jesus to vĩ mũ, ti ter kar kỹ. Kỹ Pilatos tóg soldado ag mỹ: “ha ti mỹ ti fi,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kỹ José tóg Jesus va tĩg kỹ ti pãg mũ sir, kur jãnhkri tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kỹ tóg ã kej kãkã ti fig mũ sir. Pó kãkã tóg han ja nĩgtĩ, vẽnh kej ti, hã ra tóg tãg nĩ. José tũ vẽ, vẽnh kej ẽn ti. Ẽn kãkã tóg ti fig mũ sir, kỹ tóg pó tãpér tĩn mũ, vẽnh kej jãnkã to, pó ẽn tỹ tóg ti kej nĩfénh mũ sir, José ti. Kỹ tóg tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hã ra Maria Madalena fi vỹ tá nĩ nĩ, Maria ũ ẽn fi ke gé. Ti kej rã fag tóg nĩgnĩ kỹ nỹtĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tỹ vaj kỹ, festa kurã kã Topẽ tũ ki rĩr tĩ to pã'i ag tóg vẽnh mãn mãn mũ sir, Fariseu ag mré hã. Kỹ ag tóg Pilatos venh mũjẽg. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ti mỹ ag tóg: “governador',” he mũ. “Vẽnh kar krĩn kónãn tĩ ẽn tóg tag tó ja nĩ, ha mẽ: “kurã tãgtũ ki sóg rĩr mãn ke mũ,” he ja ti nĩ. Ẽg tỹ tag to jykrén kỹ ẽg tóg ã mỹ nén ũ to vĩ sór mũ gé ver. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Soldado ag tỹ ti kej ki rĩr há tóg tĩ, kurã tãgtũ ki. Ẽg mỹ tóg ti mré mũ tĩ ag tỹ ti to nón kỹ ti péjunh ha mẽ tĩ. Ẽg mỹ tóg ag tỹ ti péju kar vẽnh kar mỹ: “rĩr mãn ti, ã ter kar kỹ,” henh ha mẽ tĩ gé. Kỹ vẽnh ó tãg tag vỹ ti ón ja ẽn kãfór pẽ nỹnh ke mũ. Hã kỹ soldado ag jẽgnẽ, ag tỹ ti kej ki rĩr jé,” he ag tóg, Pilatos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kỹ Pilatos tóg ag mỹ: “hej,” he mũ. “Vỹ nỹtĩ, ti kej ki rĩr ke mũ ag,” he tóg, soldado ũ ag to. “Ti kej ki rĩr há han nĩ, ge kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kỹ ag tóg mũ kỹ ti kej to ag vin mũ, ti kej ki rĩr ti ẽn ag. Ti kej nĩfénh mũ ẽn ség ag tóg mũ gé, vãfe tỹ, pãró to. Kỹ ag tóg go'or tỹ vãfe ẽn kri tỹ tam ke mũ, ũ tỹ ti kej nĩfe kunũg tũ nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Vẽnhkán ke kurã tỹ vaj kỹ, semana tỹ kurã ve tag ki Maria Madalena fi tóg ti kej venh tĩ mũ, kusã ki, Maria ũ ẽn fi mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hã ra ga tóg ragra ke tar han mũ sir. Kỹ Topẽ tỹ jẽnẽ jafã tóg kanhkã tá kãtére mũ. Ti kej tá jun kỹ tóg pó tỹ jãnkã nĩfe ẽn tĩn mũ, kỹ tóg kri nĩ mũ sir, pó ẽn kri. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hã ra tóg tỹ ta tỹ kóm kóm ke ve nĩ, anjo ẽn ti. Ti kur vỹ kópréj nĩ, kukryr kó kupri ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kỹ soldado ag tóg jũrũn ke mũ, kamẽg kỹ ag tóg kãgter nỹtĩ ve nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kỹ Topẽ tỹ jẽnẽ jafã tóg ũn tỹtá fag mỹ vĩ mũ, kỹ tóg: “kamẽg tũg nĩ,” he mũ. “Jesus jãvãnh ãjag nỹtĩ, ag tỹ cruz to ũn sãg mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ki ti tũ nĩ, rĩr ti huri, hã kỹ tóg ãjag mỹ tó ja nĩgtĩ. Ki ti nỹ ja nĩgtĩ, ha kãge jẽg, ãjag tỹ ti nỹgja ve jé,” he tóg mũ, fag mỹ, anjo ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Kuri, ti mré mũ tĩ ag mỹ tónh mũjẽg, ti rĩr mãn ti, ti ter kar kỹ. Ha vé, ãjag jo tóg tĩg mũ, Galiléia ra. Tá ãjag tóg ti venh mũ, ha vemnĩ. Inh vĩ kã jatu' he tũg nĩ,” he tóg, Topẽ tỹ jẽnẽ jafã ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kỹ fag tóg ti kej tá kãpa mũ sir, to fũrũrũn kỹ. Fag mỹ tóg e tĩ. Fag mỹ tóg sér pẽ tĩ, hã kỹ fag tóg pétẽ mũ sir, fag tỹ Jesus mré mũ tĩ ag mỹ tó jé. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Fag mũ ra Jesus hã ne fag kato jun ke mũ', kỹ tóg fag mỹ: “mỹ sér nỹtĩmnĩ,” he mũ. Kỹ fag tóg ti to grẽn ke mũ, ti pẽn kãgmĩg fag tóg mũ sir. Ti krẽm fag tóg mũg ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kỹ Jesus tóg fag mỹ: “kamẽg tũg nĩ,” he mũ. “Ha mũjẽg, inh régre ag mỹ tónh mũjẽg, ag tỹ ga tỹ Galiléia ra mũ jé. Tá ag tóg inh venh ke mũ,” he tóg, Jesus ti. Kỹ fag tóg mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Fag mũn kỹ soldado ẽn ag tóg cidade ra mũ mũ, soldado tỹ Jesus kej ki rĩr mũ ẽn ag. Tá junjun kỹ ag tóg Topẽ tũ ki rĩr tĩ to pã'i ag mỹ tó kãn mũ, ag tỹ nén vég mũ ẽn ti. Kỹ tóg ag mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kỹ ag tóg kófa ag mré vẽnh mãn mũ sir, ag tỹ to jykrén jé. “Ẽg hỹn hẽ ri kenh mũ, vẽnh kar tỹ ti rĩr mãn tag to: ag ón vẽ, he jé?” he ag tóg mũ jagnẽ mỹ. Ag tỹ to jykrén kar kỹ ag tóg soldado ag mỹ jãnkamy e ven mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Jãnkamy tag to vẽnh kar mỹ un'ón,” he ag tóg mũ, pã'i ag, soldado ag mỹ. “Un'ón kỹ vẽnh kar mỹ: ẽg nũgnũr mũ jãvo Jesus mré mũ tĩ ag tóg ti péju ja nĩ, kuty si há tá, hã kỹ tóg ki tũ nĩ ha, hemnĩ,” he ag tóg, pã'i ag, soldado ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Hẽn ri ke mũn ãjag pã'i tỹ governador tóg mẽnh mũ, ãjag nũgnũr ja ti. Kỹ ẽg tóg ti mré vẽmén ke mũ, ti tỹ ãjag vóg kónãn tũ nĩ jé,” he ag tóg, Topẽ tũ ki rĩr tĩ to pã'i ag, soldado ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kỹ soldado ag tóg jãnkamy ẽn mãn kỹ mũ mũ sir. Vẽnh kar mỹ ag tóg un'ón mũ mũ sir, Jesus mré mũ tĩ ag to. Hã kỹ Judeu ag tóg ver tag tó tĩ, ũnri. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Hã ra ti mré mũ tĩ ag tóg ga tỹ Galiléia ra mũ mũ, pãnónh ũ ra, Jesus tỹ ag mỹ: “ẽn ra mũjẽg,” he ja ẽn ra. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kỹ ag tóg tá ti vég mũ sir, kỹ ag tóg ti krẽm mũgmũg ke mũ sir. Hã ra ag kãmĩ ũ ag mỹ tóg vẽnhmỹ tĩ, ag tỹ ti vég mũ ra, kỹ tóg ag mỹ ki hã ke tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kỹ Jesus tóg ag rã hã jun mũ, kỹ tóg ag mré vẽmén mũ sir. “Nén kar vỹ tỹ inh krẽm ke nĩ ha, kanhkã tá ke kar, ga tá ke kar ke gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","“Hã kỹ mũjẽg, povo kar kanhrãn jé, ag tỹ inh ki ge jé. Ag tỹ inh ki ge kỹ nỹtĩn kỹ ag kygpemnĩ gé. Inh panh jiji tómnĩ, ag kygpe kỹ, kỹ ti kósin jyjy tómnĩ gé, kỹ Topẽ kuprĩg jiji tómnĩ gé, ãjag tỹ ag kygpe kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kỹ isỹ ãjag mỹ nén tó mũ kãmén kãn nĩ gé, ag tỹ ki króm jé. Ha mẽ, ãjag mré sóg jẽ nĩ, kurã kar ki, ga tũg ke kurã ki ke gé. Ãjag tovãnh ke tũ sóg nĩ ha,” he tóg, Jesus ti. Ti tỹ ã mré mũ tĩ ag jẽgnẽg mũn hã vẽ.");
INSERT INTO kgpNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sỹ Jesus Cristo kãme sér tónh ke vẽ, Topẽ kósin ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Vãsỹ Jesus tóg rán kỹ nĩ, João ke gé, Jesus jo tĩnh ke ti. Topẽ vĩ tó tĩ tỹ Isaías vỹ Jesus rán ja nĩ, kỹ tóg: “ha vé, ã jo sóg ũ jẽnẽnh mũ, ti tỹ vẽnh kar kãn jé, ã tĩg ken jo,” he ja nĩ. “Ag jyvẽn jé tóg ke mũ, kỹ tóg ẽpry prun ri ke nĩ, ẽmĩn kurynh ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ẽmã tũg ja tá tóg jẽnh ke mũ, ga kórég tá. Tá tóg ag mỹ kãmén ke mũ. “Ẽg Senhor kãtĩg ke jo vẽnh jãnhkrigkrig nĩ,” he tóg mũ. “Ẽpry kurég ãjag tóg tĩ, ẽmĩn kurynh ãjag tóg tĩ, ãjag chefe jun ken kỹ. Kỹ tag ri ke han nĩ, ãjag jykre pãno togvãnh kỹ, ẽg Senhor kãtĩg ken jo,” he tóg, ã jo tĩnh ke ti,” he ja tóg nĩ, Isaías ti, João to. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kỹ João tóg jẽ mũ, ẽmã tũg ja ki, ag kygpég tĩ ti. Ag jyvẽn tóg jẽgtĩ, kỹ tóg: “ã kype jé sóg ke mũ, ã tỹ ã jykre kórég tovãnh kỹ, Topẽ tỹ ã tỹ ti vĩ mranh tỹ ã mỹ vẽnh pãte fón jé,” he tóg mũ sir, vẽnh kar mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kỹ ag tóg ti to kãmũ kãn mũ sir, ga tỹ Judéia tá, cidade tỹ Jerusalém tá ke gé. Kỹ tóg ag kygpég mũ sir, goj tỹ Jordão ki, ag tỹ: “Topẽ vĩ mranh sóg nĩgtĩ, tag han kỹ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jó João kur tóg cavalo pãnĩ sór kyki tỹ há nĩ. Nén ũ fár tỹ tóg vẽsógfĩn ja han tĩ gé. Ópã hã ko ti tĩ, mỹg mré, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kỹ tóg Jesus kãmén kỹ (tóg) ag mỹ: “ũ tóg inh nón kãtĩ mũ, ha mẽ,” he mũ. “Inh kãfór ti nĩ. Sỹ tỹ ti camrada nĩnh ke vẽ vẽ, sỹ ti pẽn né kunũnh ke vẽ vẽ, ti pẽn to ró ti, hã ra sóg tỹ ti krẽm ke pẽ jẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Goj hã tỹ sóg ãjag kygpenh ke mũ. Ũ tỹ inh nón kãtĩg ke ẽn tóg sir Topẽ kuprĩg tỹ ãjag jagrẽ han ke mũ. Ti tỹ ãjag kygpenh ken hã vẽ,” he tóg, João ti, vẽnh kar mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kỹ kejẽn Jesus tóg João tá jun mũ gé. Cidade tỹ Nazaré tá tóg kãtĩ mũ, ga tỹ Galiléia tá. Tá jun kỹ João tóg ti kypég mũ sir, goj tỹ Jordão ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ti tỹ goj kãtá kãkutẽ kỹ kanhkã vỹ nor mũ sir vẽsỹmér. Hã ra Jesus tóg vég jẽ nĩ. Kỹ tóg Topẽ kuprĩg vég mũ. Sórãg ri ke ti nĩ, ti kãtére ti. Kãtére kỹ tóg Jesus kri nĩ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kỹ tóg kanhkã tá vẽnh vĩ mẽg mũ gé sir, kỹ tóg: “tỹ ã inh kósin pir jẽ, tỹ ã inh fe pẽ jẽgtĩ,” he mũ, vẽnh vĩ tỹ mẽ há ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kỹ vẽsỹmér Topẽ kuprĩg tóg Jesus krĩn mũ, ti tỹ ẽmã tũg ja ra tĩg jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kurã tỹ 40 (ke) tũg tóg mũ, ẽmã tũg ja ki, Jesus ti. Tá nĩn kỹ Satanás tóg ti tỹ ã jóg vĩ mranh han sór mũ, hã ra tóg ke tũ nĩ. Nẽn kãmĩ bicho ag vỹ tá mũgtĩ gé, ẽmã tũg ja ki. Hã ra Topẽ tỹ jẽnẽ jafã ag tóg ti ki rĩr mũ sir, tá. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kejẽn ag tóg João ség mũ. Ag tỹ ti se kar kỹ Jesus tóg ga tỹ Galiléia ra tĩ mũ. Tá tóg ag mỹ Topẽ tỹ tỹ ẽg pã'i nĩnh ke kãmén mũ, vẽnh kãme sér ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kỹ tóg: “Topẽ vỹ tỹ pã'i nĩ,” he mũ. “Pétẽm ti huri, ti kurã ti, ẽg tỹ ti tỹ tỹ ẽg pã'i nĩ ẽn ve jé. Kỹ ãjag jykre kórég tovãnh nĩ. Ti vĩ kri fimnĩ, ãjag tỹ ti tỹ tỹ ẽg pã'i nĩ ẽn ve jé,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kejẽn Jesus tóg nig fyr tỹ Galiléia he mũ ẽn jagma tĩ mũ. Ã tỹ ti fyr mĩ tĩ ra tóg Simão Pedro vég mũ, ti jãvy tỹ André ke gé. Kur tỹ pirã kugmĩ jafã tỹ ag tóg goj kãki fón mũ, rede tỹ, pirã kugmĩ jé. Ag rãnhrãj hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kỹ Jesus tóg ag ve kỹ ag mỹ: “inh mré kãmũmnĩ,” he mũ. “Pirã kugmĩ há ãjag nỹtĩ,” he tóg. “Ãjag kanhrãn jé sóg ke mũ, ãjag tỹ ẽprã ke ag tỹ inh ki ge han jé,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Vẽsỹmér ag tóg ti mré mũ mũ, ãjag rede tovãnh kỹ, Pedro ti, André ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kỹ ag tóg mũ mũ, goj fyr jagma. Ag mũ sĩ han mũ ra ag tóg ũn régre ũ ag vég mũ gé. Ũ vỹ tỹ Tiago nĩ, kỹ ũ vỹ tỹ João nĩ, ti jãvy. Zebedeu krẽ ag vẽ. Canoa kãki ag nỹtĩ, pirã kugmĩ jafã ki han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ag ve kỹ tóg vẽsỹmér ag jé prẽr mũ, Jesus ti. Kỹ ag tóg ãjag panh ré kỹ mũ mũ, Zebedeu ti. Ag camarada ag vỹ ag panh mré canoa kãki nỹtĩ nĩ. Ag ré kỹ ag Jesus mré mũ mũ sir, Tiago ti, João ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kỹ ag tóg cidade tỹ Cafarnaum ki ge mũ sir. Vẽnhkán ke kurã ki tóg vẽsỹmér Judeu ag vẽnh kanhrãn jafã kãra rã mũ, ag kanhrãn jé, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ti tỹ ag kanhrãn kỹ tóg ag mỹ e tĩ, ti vĩ ti. Vẽnh kar vĩ kãfór ti nĩ. Topẽ vĩ to professor ag vĩ kãfór ti nĩ gé. Hã kỹ tóg ki hã tó mũ. Kỹ tóg ag mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hã ra ũ tóg tá nĩ nĩ, Judeu ag vẽnh kanhrãn jafã tá. Jagrẽ kórég ti nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ã tỹ Jesus ve kỹ tóg prẽr mũ. “Ã tỹ ẽg tỹ hẽ ri ke nẽ, Nazaré tá Jesus'?” he tóg. “Ã mỹ ẽg kókén sór tũ'? Ã ki kanhró sóg nĩ. Tỹ ã tóg ã pir mỹ Topẽ mré ke nĩ, ti tũ pẽ vỹ tỹ ã nĩ,” he tóg, ũn jagrẽ kórég ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hã ra Jesus tóg ti mỹ vĩ tar han mũ, kỹ tóg: “vĩ tũg ra,” he mũ. “Ti tovãnh ra,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kỹ ti jagrẽ kórég ẽn tóg ti ter tĩ han mũ sir, prẽr tóg mũ sir. Kỹ tóg ti tovãnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kỹ tóg vẽnh kar mỹ e tĩ mỹr sir. Jagnẽ mỹ ag tóg: “ne nẽ vé'?” he mũ. “Vẽnh vĩ tãg mỹ vó?” he ag tóg mũ. “Vẽnh jagrẽ kórég ag mỹ tóg vĩ tĩ, kỹ ag tóg ki ke tĩ, ti kamẽg kỹ. Ag kri ke hỹn,” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kỹ ti vẽme tóg vẽnh kar kri rũm mũ, Galiléia tá ke kar kri. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kar tóg Judeu ag vẽnh kanhrãn jafã ki kutẽ mũ, Jesus ti, kỹ tóg Simão Pedro ĩn ra rã mũ sir. André mré ti ĩn vẽ. Tiago vỹ João mré ra rã mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Hã ra Pedro prũ fi mỹnh fi vỹ kaga nỹ nĩ, rỹg nỹ fi nĩ. Kỹ ag tóg Jesus mỹ fi tó mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kỹ tóg fi venh tĩ mũ. Fi nĩgé kãgmĩ kỹ tóg fi nĩm mũ. Kỹ fi rỹg ẽn tóg tũ' he mũ sir. Ag ki rĩr fi tóg mũ sir, Pedro má fi. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kurã ẽn kã kuty tá ag tóg ũn kagyga ag tatĩ kãmũ mũ, ũn jagrẽ kórég ag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Cidade ẽn ki ke kar ag vỹ ti ĩn jãnkã tá nỹtĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kỹ Jesus tóg ag tỹ há' he kãn mũ sir, fag tỹ ke gé. Vẽnh jagrẽ kórég pan kãn tóg mũ gé. Kỹ ag tóg ti tó sór mũ, ag tỹ ti ki kanhró nỹtĩ kỹ. Hã ra tóg ag mỹ: “vĩ tũg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tỹ vaj kỹ tóg kurã ke ra (tóg) rĩr mũ, Jesus ti. Kỹ tóg ẽmã tũ ra tĩ mũ sir, Topẽ mré vĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kỹ Simão tóg ti kanẽg tĩ mũ, ti jãvãnh kỹ. Ti mré ke ag mré tóg tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kỹ ag ti vég mũ sir. Kỹ ag tóg ti mỹ: “vẽnh kar vỹ ã kanẽgnẽg mũ, ã jãvãnhvãnh kỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Kỹ Jesus tóg ag mỹ: “mũ nỹ, cidade ũ ra,” he mũ, “sỹ ag mỹ Topẽ vĩ tó jé gé. Hã jé sóg kãtĩg,” he tóg mũ ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kỹ tóg ga tỹ Galiléia kar mĩ tĩ mũ. Vẽnh kanhrãn jafã krẽm tóg ag mỹ Topẽ vĩ tó mũ sir. Ag jagrẽ kórég pan tóg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kỹ kejẽn ũn kaga kren vãnh vỹ ti to kãtĩ mũ, vẽnh kaga tỹ lepra he mũ ẽn han mũ ẽn. Kỹ tóg ti krẽm grĩnh ke mũ, ti mỹ nén ũ to vĩ jé. Kỹ tóg: “ã mỹ isỹ há' he sór tũ nĩ'?” he mũ. “Ã hã tóg isỹ há' henh mũ, ã tỹ isỹ há' he sór kỹ,” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kỹ tóg Jesus mỹ jagtar tĩ. Kỹ tóg ã nĩgé tỹ ti mẽg kỹ ti mỹ: “hej,” he mũ. “To sóg há nĩ. Há' he ja há ã tóg nĩ,” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kỹ tóg ti kaga kren vãnh ẽn kren han mũ sir vẽsỹmér. Kỹ tóg jãnhkri nĩ sir, ti fár ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kỹ Jesus tóg ti mỹ vĩ tar han mũ, ti tĩg jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kỹ tóg ti mỹ: “ker ũ mỹ tó hẽ',” he mũ. “Ha tĩg, Topẽ tũ ki rĩr tĩ to. Ti hã mỹ tómnĩ, kỹ Topẽ mỹ nĩm nĩ, Moisés tỹ vãsỹ ẽg mỹ nén tó ja ti, ã jãnhkri to. Hã tugrĩn vẽnh kar vỹ ã tỹ há' he mũ tag ki kanhrãn mũ,” he tóg ti mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hã ra tóg vẽnh kar mỹ tó mũ sir. Kỹ vẽme ẽn vỹ vẽnh kar kri rũm mũ. Hã kỹ Jesus tóg ẽmã ũ ki rã tũ nĩgtĩ, vẽnh ven jé. Ẽmã tũ mĩ tóg tĩgtĩ, hã ra ag tóg ẽmã kar tá ti to kãmũ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kãnhmar Jesus tóg kejẽn cidade tỹ Cafarnaum tá jun mãn, kỹ ag tóg mẽg mũ sir, ti tỹ tá nĩn ki, ti tỹ hẽ tá nĩ ẽn tá. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kỹ ũn e ag vỹ ti to vẽnh mãn, kỹ tóg fór nĩ, jãnkãn mĩ hã. Kỹ Jesus tóg ag mỹ Topẽ vĩ tó jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hã ra ũ ag tóg tá junjun mũ gé sir, ũn grĩngrĩn kỹ nỹ vyn kỹ, ũ tỹ 4 (ke) ag vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Hã ra ag tóg ti pétẽm tũ nĩ sir, ti tỹ ag jy fór tĩn kỹ. Kỹ ag tóg ĩn kunũg mũ, ti kri. Nor ẽn ki ag tóg ũn grĩngrĩn kỹ nỹ ẽn ti térem mũ, kur kãkã nỹ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kỹ Jesus tóg ag jykre vég mũ sir, ag tỹ ti ki ge kỹ nỹtĩ ti. Kỹ tóg ũn grĩngrĩn kỹ nỹ ẽn mỹ: “inh kósin,” he mũ. “Ã tỹ Topẽ vĩ mranh ja tỹ tũ' he vẽ ha,” he tóg ti mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hã ra Topẽ vĩ to professor ũ ag vỹ tá nỹtĩ gé. Ti vĩ to ag tóg jykrén mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ne nẽ hỹn', ti tỹ tó tag ti?” he ag tóg mũ, komẽr hã. “Topẽ to vĩ kónãn vẽ,” he ag tóg. “Topẽ hã ne ã pin kỹ ẽg tỹ Topẽ vĩ mranh ẽn tỹ tũ' he há nĩnh mũ. Ti hỹn vẽsỹ Topẽ han mũ,” he ag tóg mũ, ti to jykrén kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hã ra Jesus tóg ki kanhró nĩ, ã fe tỹ, ag jykrén ki. Kỹ tóg ag mỹ: “ãjag tỹ ne to jykrén kónãn nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Ne nỹ ãjag mỹ vẽnhmỹ nỹ?” he tóg. “Ũn grĩngrĩn kỹ nỹ tag mỹ sóg: ã tỹ Topẽ vĩ mranh ja ẽn tỹ tũ' he vẽ ha, hé,” he tóg. “Kỹn mỹ ãjag mỹ vẽnhmỹ?” he tóg. “Sỹ ti mỹ: nĩ ra, ã kur gé(g) tĩg, henh ke nẽ ha,” he tóg. “Kỹn mỹ ãjag mỹ vẽnhmỹ ke gé'?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“Hã ra isỹ ãjag mỹ inh jykre ven sór vẽ ha. Tỹ sóg ẽprã ke fi kósin nĩ. Tá sóg krỹg ke mũ, Topẽ vĩ mranh tỹ vẽnh pãte fón ke tá. Sỹ tá krỹg mũ ven jé sóg ke mũ, ãjag mỹ,” he tóg. Hã kỹ tóg ũn grĩngrĩn kỹ nỹ ẽn mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“nĩ ra, ã kur gé(g) tĩg,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kỹ tóg jẽgnẽ mũ sir, ã kur gég tóg mũ sir vãhã, kỹ tóg ag rĩnve tĩ mũ sir, ũn grĩngrĩn kỹ nỹ ja ẽn ti. Vẽnh kar mỹ tóg e tĩ, kỹ ag tóg Topẽ to: “ẽg jykre kãfór ti nĩ,” he mũ. “Ge ve ja tũ ẽg nỹtĩ,” he ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Kỹ Jesus tóg tĩg mãn mũ, goj nig tỹ Galiléia ra. Kỹ vẽnh kar ag tóg ti pénĩn vẽnh mãn mãn mũ sir. Kỹ tóg ag kanhrãn mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ã tĩg mãn kỹ tóg Levi vég mũ, Alfeu kósin. Governo mỹ imposto kaja mãg ti tĩ, hã ra tóg ã rãnhrãj han nĩ nĩ. Kỹ Jesus tóg ti mỹ: “inh mré kãtĩg,” he mũ. Kỹ tóg jẽgnẽ kỹ ti mré tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kỹ tóg kejẽn ti ĩn krẽm jẽg mũ, Jesus ti, Levi ĩn krẽm. Hã ra ti mré ag e nỹtĩ, governo mỹ jãnkamy mãg tĩ ag, Topẽ vĩ mranh tĩ ag ke gé. Jesus mré ag nĩgnĩg kỹ nỹtĩ, ti mré mũ tĩ ag mré ke gé. E tãvĩ ag nỹtĩ, ti nón mũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Hã ra Topẽ vĩ to professor ũ ag vỹ tỹ Fariseu nỹtĩ gé. Jesus vég ag tóg mũ, ti tỹ Topẽ vĩ mranh tĩ ag mré jẽn kỹ. Kỹ ag tóg Jesus mré mũ tĩ ag mỹ vĩ mũ. “Ti hã ne tóg ag mré jẽg mũ'” he ag tóg. “Governo mỹ jãnkamy mãg tĩ ag mré tóg jẽg mũ',” he ag tóg, “Topẽ vĩ mranh tĩ ag mré ke gé',” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hã ra Jesus tóg mẽg mũ, ag vẽme ẽn ti. Kỹ tóg ag mỹ: “ũn kagyga tũ ag vỹ médico venh mũ tũ nĩgtĩ',” he mũ. “Hã ra ũn kagyga ag hã vỹ ti venh mũ tĩ,” he tóg ag mỹ, Jesus ti. “Inh pi(jé) ũ tỹ vẽnh jykre kuryj han mũ ag mỹ: “ãjag jykre tovãnh nĩ,” he sór tĩ'. Ũ tỹ Topẽ vĩ mranh ja nĩ ẽn ag hã mỹ sóg: “ãjag jykre kórég tovãnh nĩ,” he sór tĩ. Hã jé sóg ãjag mỹ vẽnh ven,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Hã ra João mré mũ tĩ ag tóg kejẽn vãkrég mũ, jẽg tũ ag nĩ, ag tỹ Topẽ mỹ há nỹtĩ jé. Kỹ Fariseu ag vãkrég mũ gé. Kỹ ag tóg Jesus mỹ: “João mré mũ tĩ ag vỹ tóg vãkrég mũ, Fariseu mré mũ tĩ ag ke gé,” he mũ. “Jo ã mré mũ tĩ ag ne tóg vãkrég tũ nĩ'. Vãkre kurã vẽ mỹr,” he ag tóg ti mỹ, tá nỹtĩ ũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Kỹ Jesus tóg ag mỹ comparação han mũ. “Vẽnh kyprũg to kãmũ ẽn ag pi(jé) vãkrég tĩ',” he tóg. “Festa vẽ mỹr, vẽnh prũgprũg ti, kỹ ti mré ke ag tóg ũn prũg mũ ẽn venh kãmũ tĩ,” he tóg. “Ge ti nĩ, inh mré mũ ag mỹ. Isỹ ag mré nĩn kỹ tóg ver ag mỹ sér tĩ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","“Vãhã tóg jun mũ, inh kurã ti, kỹ ag tóg inh pére mũnh mũ, ẽn kã hã ag tóg ãjag vãkrenh ke venh mũ, kurã ẽn kã, inh mré mũ tĩ ag,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ti si fag pi(jé) vãfe kygnej tũ tỹ kur si jar ki hyn han tĩ ja nỹtĩgtĩ'. Ũn kygnej tũ tỹ ki hyn han mũ ra tóg jaran kenh mũ. Kỹ kur si jar ẽn tóg mág mũ. Ũn kygnej hã tỹ fag tóg ki han han tĩ, kỹ tóg jaran ke tũ nĩ,” he tóg, Jesus ti. Ti tỹ ã jykre tãg tón hã vẽ, hã ra tóg kur kygnej tũ ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kỹ tóg ag mỹ: “Kỹ vinho vỹ ge nĩgtĩ gé,” he mũ gé. “Ẽg pi(jé) vinho kajãg mũ tỹ ti fár si tỹ saco ki kujẽg tĩ mỹr',” he tóg. “Ke tũ nĩ (mũ) ra tóg kugnãj kỹ jar mũ, kógnãj kỹ. Kỹ vinho tóg tũ' he mũ, saco ti ke gé mỹr. Vinho kajã tỹ ti fár tãg tỹ ki kujẽn ke vẽ mỹr,” he tóg. Jesus tỹ ã jykre tãg tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kejẽn Jesus tóg ẽpỹ mĩ tĩ mũ, trigo kré mĩ. Ti mré mũ tĩ ag tóg ti mré mũ mũ. Vẽnhkán ke kurã vẽ. Ag mũ kỹ ti mré mũ tĩ ag vỹ trigo mugmó tỹ kam ke mũ, ko jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kỹ Fariseu ag tóg Jesus mỹ: “ha vé,” he mũ. “Ag tỹ ne jé ãjag tỹ nén han ke tũ han nẽ, vẽnhkán ke kurã ki?” he ag tóg mũ. “Vẽnh rãnhrãj vẽ mỹr, ag tỹ trigo tỹ kam ke ti,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Kỹ tóg ag mỹ: “vó,” he mũ. “Davi tỹ nén han mũ to jykrén nĩ,” he tóg. “Ti kókĩr nĩn kỹ tóg ã tỹ nén han ke tũ han gé, ã mré mũ tĩ ag mré, hã ra Topẽ pi(jé) ti to jũ mũ', tag han tugrĩn, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Topẽ jo ĩn kãra tóg rã, Davi ti, Abiatar tỹ Topẽ tũ ki rĩr tĩ to pã'i nĩn kỹ. Tá tóg Topẽ jamĩ ẽn kó, tỹ ti tỹ konh ke tũ ra, Topẽ tũ ki rĩr tĩ ag hã tỹ konh ke vẽ vẽ. Hã ra tóg kó, ti mré mũ ag mỹ tóg vẽnh ken gé, Davi ti,” he tóg, Jesus ti. “Rán kỹ tóg nĩ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kỹ Jesus tóg ag mỹ: “Topẽ vỹ ẽg mỹ vẽnhkán ke kurã nĩm, ẽg tỹ ki vẽnhkán jé,” he mũ. “Hã ra tóg tỹ kurã kórég han tũ nĩ, vẽnhkán ke kurã tỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","“Hã kỹ sóg tỹ vẽnhkán ke kurã to pã'i nĩ gé. Tỹ sóg ẽprã ke fi kósin nĩ mỹr,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kejẽn Jesus tóg vẽnh kanhrãn jafã ra rã mãn mũ. Tá ũ tóg jẽ nĩ, ti nĩgé tóg tóg ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kỹ ag tóg ti tugnỹm mũ sir, “kema ẽg tỹ ti tỹ vẽnhkán ke kurã kã ti tỹ há' he ve jé,” he ag tóg mũ sir. Hã ra ag tóg pã'i ag mỹ ti tó sór mũ, ti tỹ vẽnhkán ke kurã to Topẽ vĩ mranh kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hã ra Jesus tóg ũn nĩgé kórég ẽn mỹ: “kunĩg,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kỹ tóg ag mỹ: “vẽnhkán ke kurã ki ẽg hỹn ne han mũ'?” he mũ, “ẽg tỹ Topẽ vĩ ki króm jé,” he tóg. “Ẽg mỹ hỹn nén ũ há han mũ'?” he tóg. “Ẽg tỹ ũ tũ kókén kỹn mỹ kórég tũ nĩnh mũ'?” he tóg ag mỹ. “Ẽg mỹ ũ kren han mũ hỹn'?” he tóg. “Ẽg tỹ ũ tén kỹn mỹ há nĩnh mũ hỹn'?” he tóg. Hã ra ag tóg ti mỹ katy tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kỹ tóg ag ki ẽvãnh kỹ jũ mũ sir, fe kaj tóg nĩ sir, ag krĩ tũ nỹtĩn kỹ. “Ã nĩgé tỹ krỹg' hé,” he tóg ti mỹ, ũn nĩgé tóg ẽn mỹ. Kỹ tóg tỹ krỹg' he mũ sir, há' he tóg mũ sir, vãhã, ũn nĩgé tóg ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kỹ vãhã Fariseu ag mũ mũ sir, jagnẽ mré ti to jykrén jé, pã'i mág tỹ Herodes mré ke ag mré ke gé. “Ẽg hỹn hẽ ri ken kỹ ti tũg mũ?” he ag tóg mũ, Jesus ti to. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Hã ra Jesus tóg ti mré mũ tĩ ag mré goj nig tỹ Galiléia ra tĩ mũ, vẽnh e tũg ja ra. Hã ra vẽnh e ag tóg ti nón mũ mũ. Ga tỹ Galiléia tá ag tóg kãmũ mũ, ga tỹ Judéia tá ke gé, ");
INSERT INTO kgpNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","cidade tỹ Jerusalém tá, ga tỹ Iduméia tá, goj tỹ Jordão mã tá, cidade tỹ Tiro tá, cidade tỹ Sidom tá ke gé. E tãvĩ ag nỹtĩ, e pẽ. Ti tỹ nén hyn han kar mẽ kỹ ag tóg ti to kãmũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kỹ Jesus tóg ti mré mũ tĩ ag mỹ tó mũ, ag tỹ ti mỹ canoa jãján jé. Ti kutãn ag tóg, vẽnh kar ẽn ti, hã kỹ tóg canoa to vĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ũ tỹ hẽn ri ke tỹ há' he ja tóg nĩ, ũn kagyga ag tỹ, fag tỹ ke gé. Hã kỹ ag tóg ti kutãn mũ. Ag tỹ ti mẽ sór vẽ, ãjag nĩgé tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kỹ ũn jagrẽ kórég ag vỹ tá nỹtĩ gé. Ag tỹ Jesus ve kỹ ag tóg prẽnprẽr mũ sir. “!..Tỹ ã Topẽ kósin ne..!” he ag tóg mũ, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kỹ Jesus tóg ag mỹ vĩ tar han tĩ. “Ker inh kãmén hẽ',” he tóg tĩ, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kejẽn tóg pãnónh ra tĩ mũ, Jesus ti. Kỹ tóg ag jé prẽr mũ, ag kuprẽg kỹ. Kỹ ag tóg ti to mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kỹ tóg ũ tỹ 12 (ke) ag vin mũ sir, ag tỹ tỹ ti mré mũ tĩ nỹtĩ jé, ti tỹ ag jẽgnẽ jé ke gé, “Topẽ vĩ tó jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ag mỹ tóg vẽnh jykre nĩm mũ, ag tỹ vẽnh jagrẽ kórég pan jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ũ tỹ 12 (ke) ag hã vẽ, ha mẽ: Simão, Jesus tỹ ti jyjy ũ hã vỹ: Pedro, he mũ, ");
INSERT INTO kgpNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiago ke gé, ti jãvy tỹ João mré, Zebedeu krẽ tag ag. Jesus tỹ ag jiji ũ hã vỹ: Boanerges, he mũ, ẽg vĩ ki ke hã vỹ: ta tỹ tỹrỹrỹ he ri ke ag, he mũ, ");
INSERT INTO kgpNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André ke gé, Filipe ke gé, Bartolomeu ke gé, Mateus ke gé, Tomé ke gé, Tiago ke gé, Alfeu kósin tag ti, Tadeu ke gé, Simão ke gé, ag tỹ ũ to: Zelote, he mũ tag ti, ");
INSERT INTO kgpNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariotes ke gé, ũ tỹ pã'i ag mỹ Jesus ven ke ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kỹ Jesus tóg ag mré ã jamã tá jun mũ. Kỹ vẽnh kar tóg sir tá vẽnh mãn mũ, kỹ tóg ag jẽn ke mũ ra vẽnhmỹ tĩ, Jesus mré mũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kỹ Jesus kanhkã fag vỹ ti vẽme mẽ kỹ ti kãgmĩnh kãmũ mũ. “Krĩ vẽnhmỹ nĩ ve ti nĩ,” he fag tóg, hã kỹ fag tóg ti kãgmĩ sór mũ. Hã ra tóg fag mré tĩ tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kỹ Topẽ vĩ to professor ag tóg tá junjun mũ gé. Jerusalém tá ag tóg kãmũ jẽg, ti ve jé. Kỹ ag tóg ti to: “jagrẽ kórég ti hỹn nĩ,” he mũ. “Hã kỹ tóg vẽnh jagrẽ kórég ag pã'i ẽn jykre han mũ, vẽnh jagrẽ kórég ag pan jé,” he ag tóg. “Belzebu jykre tỹ tóg ag pan mũ, Nén-Kórég jykre tỹ,” he ag tóg, Jesus to, Topẽ vĩ to professor ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kỹ Jesus tóg ag jé prẽr kỹ ag mỹ comparação han mũ, kỹ tóg: “Satanás vỹ vẽnh jagrẽ kórég pan tũ nĩgtĩ mỹr,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Pã'i pir krẽm ke ag tỹ jagnẽ kato tẽgtẽn kỹ ag tóg jagnẽ kãgtén kãn ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","“Ĩn pir kã ki ke ẽn fag tỹ jagnẽ kato tẽ kỹ fag tóg jagnẽ kãgtén kãn ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","“Satanás krẽm ke ag tỹ jagnẽ kato tẽ kỹ ag tóg jagnẽ tỹ tũ' henh ke mũ gé, kỹ tóg tũ' he mũ sir, Satanás ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ẽg tỹ ũ tỹ nén ũ mãn sór kỹ, ti ĩn tá, kỹ ẽg tóg ti se vén tĩ, ke tũ nĩ (mũ) ra tóg ã tũ ki rĩr ke mũ, kỹ ẽg tóg ti tũ mãn tỹ hẽ ri kenh ke tũ nĩgtĩ, ti tar nĩn kỹ. Ẽg tỹ ti se kar kỹ ẽg tóg ti tũ mãg mũ sir,” he tóg. “Ge ti nĩgtĩ, sỹ nén han mũ ti. Tar ti nĩ, Japo ti, hã ra sóg hur ti sé, hã kỹ sóg ti tũ ag kygvãg mũ sir, ag jagrẽ kórég pan sóg mũ sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sỹ ke há vẽ, hã kỹ sóg tó mũ,” he tóg. “Topẽ vỹ ãjag mỹ vẽnh pãte fón kãn mũ, ãjag tỹ ti vĩ mranh kar ẽn tỹ, ãjag tỹ ti kato vĩ kónãn mré hã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","“Jãvo ãjag tỹ Topẽ kuprĩg kato vĩ kónãn kỹ tóg ãjag mỹ vẽnh pãte fón mãn ke tũ nĩ ha, Topẽ ti,” he tóg. “Ãjag tỹ Topẽ vĩ mranh ẽn vỹ ãjag hã kã nĩ nĩ, kurã tũ ti nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ag mỹ tóg ke mũ, Jesus ti, ag tỹ ti to: “jagrẽ kórég ti hỹn nĩ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kỹ ti mỹnh fi tóg ti jãvy ag mré ti venh kãtĩ mũ. Re kã fi jẽ ag mré, kỹ ag tóg ũ jẽnẽg mũ, ti jé prẽr jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jesus pénĩn vẽnh e vỹ tóg nỹtĩ, nĩgnĩg kỹ, kỹ ag tóg: “ha mẽ, ã mỹnh fi vỹ re kã jẽ, ã jãvy ag mré,” he mũ. “Fag tỹ ã mré vẽmén sór vẽ. Ã jé prẽr fag tóg mũ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hã ra Jesus tóg: “inh mỹnh fi mỹ inh ve sór mũ', inh jãvy ag mré'?” he mũ. “Inh mỹnh fi vẽ vẽ, inh jãvy ag vẽ vẽ, hã ra ag tóg tỹ inh mré ke pẽ tũ nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kỹ tóg ũn nĩgnĩg kỹ nỹtĩ ag ki ẽvãnh kỹ tóg: “inh mỹnh fi hã vẽ, inh jãvy ag hã vẽ gé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Ũ tỹ Topẽ vĩ han mũ ẽn ag vỹ tỹ inh jãvy nỹtĩ, inh ve fag ke gé, inh mỹnh ke gé,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kejẽn Jesus tóg goj nig tỹ Galiléia fyr tá ag kanhrãn mãn mũ. Hã ra vẽnh e vỹ ti pénĩn nỹtĩ, vẽnh e tãvĩ, hã kỹ tóg canoa kãra rã mũ, goj kãki, kỹ tóg canoa kãkã nĩ mũ, hã ra ag kar vỹ tar tá vẽnh mãn kỹ nỹtĩ, nig fyr tá. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ag mỹ tóg vẽnh vĩ e tó mũ, comparação han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Kỹ tóg kejẽn ag mỹ: “ha mẽ,” he mũ. “Ũ tóg nén ũ fy krigkrig tĩ mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","“Ti tỹ krigkrig kỹ ti fy ũ tóg ẽmĩn kri kutẽ mũ, ẽpry kri. Kỹ sẽsĩ tóg ti ko mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ti fy ũ tóg pãró kri kutẽ mũ, ga e tũ ki, kỹ tóg kãnhmar mur mũ vẽ, ga sĩ ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hã ra rã tóg ã tỹ ẽg nĩno kã sa kỹ (tóg) ti pũn mũ. Ti jãre han tũ nĩn kỹ tóg tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ti fy ũ tóg sónh kãki kutẽ mũ, kỹ sónh tóg ti mré mur mũ, ti kri rũm tóg mũ sir kỹ tóg kanẽ han tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ti fy ũ tóg ga há kri kutẽ mũ kỹ tóg mur há han mũ, mog há han tóg mũ, kanẽn ha han tóg mũ gé, ũ tóg kanẽ tỹ 30 (ke) han, jo ũ vỹ kanẽ tỹ 60 (ke) han, jo ũ vỹ kanẽ tỹ 100 (ke) han. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ũ nĩgrẽg nỹtĩ tỹ tỹ jẽmẽ jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ũn e ẽn ag mũn kar kỹ ti mré nỹtĩ ag tóg ti ki jẽmẽnh kãmũ mũ, nén fy kãmén ti. Kỹ ag tóg ti mỹ: “ã tỹ ẽg mỹ ne tó nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kỹ tóg ag mỹ: “ãjag hã tóg Topẽ tỹ tỹ ẽg pa'i nĩ ki kanhró nỹtĩnh mũ, ijo tó ja tũ ẽn ki,” he mũ. “Hã ra sóg ẽn ag mỹ comparação tãvĩ han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ag mỹ sóg tó há han ke tũ nĩ, ón kỹ mẽg mũ ag mỹ, kỹ ag tóg ãjag tỹ vég mũ ra ki kagtĩg nỹtĩ, ãjag tỹ mẽg mũ ra ag tóg to jykrén tũ nỹtĩ, kỹ ag tóg Topẽ ki ge tũ nỹtĩ gé, kỹ Topẽ tóg ag mỹ vẽnh pãte fón ke tũ nĩ gé,” he tóg, Jesus ti, ũ ag to. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kỹ tóg ag mỹ: “ãjag tỹ to jykrén tũ tóg tĩ',” he mũ, “sỹ ãjag mỹ nén fy kãmén kỹ,” he tóg. “Kỹ ti mỹ ãjag tỹ ũ to jykrén há nĩnh mũ', sỹ ãjag mỹ comparação ũ han kỹ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kỹ tóg jamã hár(a) ag mỹ kãmén mũ. “Ũ tóg nén fy vãvãm tĩ, kỹ ti tỹ Topẽ vĩ tó vẽ, hã vỹ: vãvãm, he mũ, nén fy ri ke vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Ti fy ũ vỹ ẽmĩn kri kutẽ mũ. Kỹ Topẽ vĩ mẽg mũ ũ ag vỹ ẽpry ri ke nỹtĩ,” he tóg. “Ag tỹ Topẽ vĩ mẽg mũ ra tóg ag mỹ tỹ tũ' he mũ, Satanás ti, Topẽ vĩ tỹ. Vẽsỹmér tóg ag mỹ tỹ tũ' he mũ, ag mỹ Topẽ vĩ tó tỹ. Kỹ ẽmĩn ri ke vẽ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hã ri ken hã vẽ gé, ti tỹ pãró kri vãvãm ẽn ti. Ag tỹ Topẽ vĩ mẽ kỹ ag tóg vẽsỹmér: hej, he mũ sir. Ag mỹ tóg sér tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hã ra ag tóg nén kré jãre tũ ri ke nỹtĩ, kỹ ag tóg mũ sĩ han mũ, Topẽ mré. Nén ũ jagy kutẽ kỹ ag tóg sir Topẽ tovãnh mũ vẽsỹmér, ũ tỹ Topẽ tugrĩn ag kato tẽ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ti tỹ sónh kãki vãm ẽn hã vẽ gé, hã vỹ tỹ Topẽ vĩ mẽg mũ ag nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Hã ra ag tóg ãjag rãnhrãj hã mĩ ẽkrég mũ, ón kỹ rico nĩ sór jé. Nén ũ kar to ag én, hã kỹ Topẽ vĩ tóg ag mỹ katy' he mũ sir. Kỹ ag tóg kanẽ há han tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hã ra ti tỹ ga há kri vãvãm mũ ẽn vỹ tỹ Topẽ vĩ mẽg mũ ag nỹtĩ gé. Hej, he ag tóg mũ sir, kanẽ há han ag tóg mũ, ũ tóg kanẽ tỹ 30 (ke) han mũ, ũ tóg kanẽ tỹ 60 (ke) han mũ, ũ tóg kanẽ tỹ 100 (ke) han mũ,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kỹ Jesus tóg ag mỹ: “ẽg pi(jé) néj gru ma kãmũ kỹ kẽj krẽm fẽg tĩ', ẽg pi(jé) cama krẽm fẽg tĩ',” he mũ. “Ti fẽg jafã kri ẽg tóg fẽg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hã kỹ ẽg tỹ nén vég tũ ẽn vẽnh ven kãn ke vẽ, hã jé tóg ver péju kỹ nĩ. Ẽg tỹ nén ki kagtĩg ẽn vẽnh ven kãn ke vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","“Ũn nĩgrẽg nỹtĩ tỹ tỹ jẽmẽ jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Hã kỹ jẽmẽ há han,” he tóg. “Ãjag mré ke ag jykre tugnỹm ãjag tóg tĩ, kỹ ãjag tóg ag mỹ vĩ tar han tĩ. Kỹ Topẽ vỹ ãjag mỹ vĩ tar han ke mũ gé, ãjag tỹ ãjag mré ke ag jykre ri ke nỹtĩn kỹ. Hã ra tóg ãjag mỹ vĩ tar kãfór han ke mũ, ha vemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","“Ũ tỹ nén ũ to jykrén há han kỹ tóg ũ to jykrén mãn', ũ to jykrén mãn', he mũ sir. Ũ tỹ nén ũ to jykrén há han tũ nĩn kỹ tóg ti mỹ tũ' he mũ sir, ti tỹ nén to jykrén sĩ han mũ ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kỹ Jesus tóg ag mỹ: “Topẽ tỹ tỹ ẽg pã'i nĩ vỹ ge nỹnh mũ, ha mẽ,” he mũ. “Ũ vỹ nén ũ fy vãvãm tĩg mũ, ẽpỹ ki,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","“Ũ tỹ vãvãm mũ vỹ nũr mũ sir, kutyg kỹ, tỹ vaj kỹ tóg rĩr mãn mũ sir. Hã ra ti fy ẽn vỹ mur mũ, mog tóg mũ, jo ũ tỹ vãvãm mũ tóg ki kagtĩg nĩ. “Ti hẽ ri ken kỹ mur'?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jãvo tóg vẽsóg ki mog, kar tóg mó han, kỹ vãhã ti kanẽ vẽ sir, ti mó kãki. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti kanẽn kar kỹ tóg ag mỹ: “ha kre jafã va kãmũ jẽg,” he mũ sir. Kỹ ti krenh ke kurã vẽ sir. Topẽ tỹ tỹ ẽg pã'i nĩ ri ken hã vẽ,” he tóg, Jesus ti, ã kãtĩg mãn ke tón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kỹ Jesus tóg: “inh hỹn tóg tag tónh mũ ha, sỹ Topẽ tỹ tỹ ẽg pã'i nĩ kãmén jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“Ka tỹ mostarda fy ri ke ti nĩ, Topẽ tỹ tỹ ẽg pã'i nĩ ti,” he tóg. “Ti krãn ẽg tóg tĩ, ẽg japỹ ki. Kãsir ti nĩ, ti fy ti. Ũ fy vỹ ti sĩ ri ke tũ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ti krãn kar kỹ tóg mog mũ, kỹ tóg ẽgóho kar kãfór nĩ. Pẽ mág ti nỹtĩ, hã kỹ sẽsĩ ag vỹ kãki krẽg tĩ, ti fẽnja ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Comparação tỹ hẽn ri ke hyn han tóg, ag mỹ Topẽ vĩ tón ki, ag tỹ to jykrén sór kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","“Tag vỹ ge nỹnh mũ,” he hã han tóg ag mỹ, Jesus ti. Ag mỹ tóg jamã hár(a) nén ũ tó tũ nĩ, ũn e ag mỹ. Hã ra tóg ã mré mũ tĩ ag mỹ kãmén há han mũ, ag pin kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hã tỹ kuty tá tóg ag mỹ: “mũ nỹ, goj nig kafã ũ ra,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Hã kỹ ag tóg vẽnh e ẽn ré kỹ mũ mũ sir, canoa kãmĩ, Jesus tỹ kãkã nĩn kỹ. Hã ra ũ ag tóg ti mré mũ mũ gé, canoa ũ kãmĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hã ra kãka tar tãvĩ vỹ tóg vãhã krog he mũ, kóho ti. Kỹ goj tóg canoa kãki krém krém ke mũ. Ti fãn sór tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Hã ra Jesus tóg nũr nỹ, fakrĩnh kỹ, canoa nér tá. Kỹ ag tóg ti rĩn kỹ ti mỹ: “Senhor,” he mũ. “Ẽg mỹ ẽg kãgter ha mẽ tóg tĩ. Mỹ ã mỹ tỹ nén ũ tũ?” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kỹ tóg rĩr mũ sir, kỹ tóg kóho mỹ vĩ tar han mũ, ti mỹ: “krỹg he ra,” hen kỹ. Kỹ kóho tóg tũ' he mũ, katy' he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kỹ tóg ag mỹ: “ãjag tỹ ne jé kanẽ jur nẽ?” he mũ. “Ãjag mỹ inh ki rã há han tũ?” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kỹ tóg ag mỹ e (pẽ) tãvĩ tĩ sir. Jagnẽ mỹ ag tóg: “ti jykre tóg ẽg mỹ e tĩ,” he mũ. “Kóho vỹ ti vĩ han, goj ti ke gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kỹ ag tóg goj nig kafã ũ tá junjun mũ sir, Gerasa tá ke ag tá. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus tỹ canoa ki vag ke mũ ra ũ tóg ti kato tẽ mũ. Jagrẽ kórég ti nĩ. Vẽnh kej tá tóg kãkutẽ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tá tóg ẽmã nĩ, vẽnh kej tá. Ag tỹ ti ség mũ ra tóg vẽnh mỹ nĩ, ferro mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ti se tỹ hẽn ri ke han ja ag tóg nĩgtĩ vẽ, ti nĩgé, ti pẽn ke gé, ferro tỹ. Hã ra tóg ferro tỹ kam ke ja nĩgtĩ, ã pẽn se ja ti mrynhmranh kãn ja tóg nĩgtĩ. Ag tỹ ti kanhrãn ke mũ ra ag tóg ti tỹ hẽ ri ke ja tũ nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kuty ki kurã mré tóg prẽr tĩgtĩ, vẽnh kej ki. Pãró ẽn ki pó génh kỹ tóg vẽsãnh tĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ti tỹ kuvar há tá Jesus ve kỹ tóg ti to vẽnhvãg tĩ mũ, kỹ tóg ti krẽm grĩnh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jamã hár(a) tóg prẽr mũ, kỹ tóg: “!..ã isỹ hẽ ri kenh mũ, Jesus'..!” he mũ, “!..kynhmỹ Topẽ kósin'..!” he tóg. “!..Ã mỹ sóg to vĩnh mũ, ã tỹ inh vóg kónãn tũ nĩn jé, kỹ Topẽ vỹ inh vĩ mẽg mo..!” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Hã ra Jesus tóg ti mỹ: “ti tovãnh ra, Nén-Kórég',” he ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kỹ Jesus tóg ti mỹ: “ã jyjy hẽ ri ke tĩ,” he mũ. Kỹ tóg: “Mil,” he mũ. “E tãvĩ ẽg nỹtĩ,” he tóg, Nén-Kórég ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kỹ tóg to vĩ', to vĩ', he mũ, Jesus tỹ ẽmã ẽn ki ti kutẽm tũ nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hã ra ag mẽg tỹ porco ag tóg jẽg nỹtĩ, pãnónh ẽn kri. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kỹ Nén-Kórég ag tóg Jesus mỹ: “ag mẽg to ẽg jẽgnẽ, ẽg tỹ ag kãki ge jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kỹ tóg ag mỹ: “hej,” he mũ. Kỹ Nén-Kórég ag tóg ẽn ti tovãnh mũ sir, porco ag ki ge ag tóg mũ sir. Kỹ ag tóg re mũ sir, porco ag. Rán ki ag tóg re mũ, kỹ ag tóg nỹgnỹr kãn mũ sir, goj nig ki. Kãgter kãn ag tóg mũ. Porco tỹ mil régre ag vẽ, hỹn. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kỹ porco ki rĩr tĩ ag tóg sir pétẽ mũ, cidade ra. Tá ag tóg kãmén kãn mũ, Nén-Kórég tỹ jagrẽ ja ẽn ti. Kỹ ag tóg Jesus to mũ kãn mũ sir, nén ẽn ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus tá ag tóg junjun mũ sir, kỹ ag tóg ũn jagrẽ kórég ja ẽn vég mũ, kur tu kỹ. Krĩ há' he tóg mũ, ũ tỹ mil tỹ jagrẽ kórég ja ẽn ti. Kỹ ag fe tóg jũrũn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kỹ ũ tỹ vég mũ ag tóg kãmén mũ sir ag mỹ Ũn jagrẽ kórég ja ti, porco ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hã kỹ ag tóg Jesus mỹ to vĩ mũ, ti tỹ tá kutẽ jé, ag rã hã nĩ tũ nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ti tỹ canoa kãki rã kỹ ũn jagrẽ kórég ja tóg: “nhỹ ã mré tĩg mũ,” he mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hã ra tóg ti mỹ nenh. “Ha tĩg, ã ĩn ra, ã tỹ ã mré ke ag mré nĩ jé,” he tóg ti mỹ. “Ag mỹ kãmén nĩ, ẽg jóg mág tỹ ã tỹ há' he mũ ti, ti tỹ ã jagãgtãn mũ ti,” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kỹ tóg tĩ mũ. Ẽmã tỹ 10 (ke) ki ga tá tóg kãmén mũ, Jesus tỹ ã tỹ há' he ti. Kỹ tóg ag kar mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kỹ Jesus tóg kafã ra tĩg mãn mũ, canoa kãmĩ. Kỹ vẽnh e tóg ti jo vẽnh mãn mũ. Hã ra tóg goj nig fyr tá jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kỹ ũ tóg kãtĩ mũ, ti jiji hã vỹ: Jairo, he mũ. Judeu ag vẽnh kanhrãn jafã to tóg tỹ pã'i nĩ. Ti tỹ Jesus ve kỹ tóg ti krẽm mũg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ti mỹ tóg: “inh kósin sĩ fi vỹ tũg sór mũ,” he mũ. “Kunĩg, ã tỹ ã nĩgé tỹ fi mẽ jé, fi tỹ há' he jé, fi kren jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kỹ tóg ti mré tĩ mũ. Hã ra ũn e ag tóg ti nón mũ kỹ ti kutãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jo ũn tỹtá ũ fi tóg tá nĩgtĩ. Kyvénh krỹg tũ han kỹ fi tóg nĩ, prỹg tỹ 12 (ke) ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Médico ag tỹ fi vẽsỹrénh mág han, to fi tóg ã tỹ nén vãm kãn, hã ra fi tóg há' he tũ nĩ, ke han han fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Hã ra fi tóg Jesus kãme mẽ ja nĩgtĩ, kỹ fi tóg vẽnh e kãmĩ tĩg kỹ ti nón ti kur mẽg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Sỹ hẽn ri ke mũn ti kur mẽ kỹ inh hỹn han mũ,” he fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Fi tỹ ti kur mẽ kỹ fi kyvénh tóg gym ke mũ sir vãhã, kỹ fi tóg ki kanhró nĩ, fi kaga tỹ há' he ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hã ra Jesus tóg ã fe tỹ ki kanhró nĩ, ã jykre kutẽ ẽn ki. Kỹ tóg vẽnh e kãki vĩrĩn ke mũ sir. “Ũ nỹ inh kur mẽ'?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kỹ ti mré mũ tĩ ag tóg ti mỹ: “vẽnh kar tỹ ã kutãn vẽ,” he mũ. “Jo ã tóg: ũ nỹ inh kur mẽ? he mũ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kỹ tóg tãmĩ ẽvãnh mũ, ũ tỹ ã mẽg mũ fi ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hã ra ũn tỹtá fi tóg ki kanhró nĩ, fi han mũn ki. Kỹ fi tóg kamẽg kỹ, jũrũn ke kỹ mũg ke mũ, ti krẽm. Kỹ fi tóg ti mỹ kãmén kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Hã ra tóg fi mỹ: “inh kósin,” he mũ. “Ã tỹ inh ki rã kỹ ã tóg há' hé,” he tóg. “Ha tĩg, jatun mỹ, ã han vẽ ha,” he tóg, fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ti tỹ ver fi mré vẽmén jẽ ra ũ ag tóg tá junjun mũ, pã'i tỹ Jairo ẽn ĩn tá. “Ã kósin fi vỹ hur ter,” he ag tóg. “Tũg ja fi tóg nĩ ha,” he ag tóg. “Hã kỹ ti mỹ: kunĩg, he mãn tũg nĩ, ti kutãn mãn tũg nĩ,” he ag tóg, Jairon mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hã ra Jesus tóg mẽg mũ, kỹ tóg: “kamẽg tũg nĩ, inh vĩ hã kri nĩmnĩ,” he mũ, pã'i ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kỹ tóg ũn e ag tỹ ti ĩn ra mũ kamẽg. “Pedro vỹ tĩg mũ inh mré, Tiago ke gé,” he tóg, “Tiago jãvy tỹ João ke gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ag tỹ Jairo ĩn tá junjun mũ ra Jesus tóg vẽnh e vég mũ sir, kygfỹ mũ fag, vẽsỹrénh jagy han mũ fag. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kỹ tóg kã rã kỹ fag mỹ: “ãjag tỹ ne jé kygfỹ nẽ, ãjag tỹ ne jé vẽsỹrénh nẽ?” he mũ. “Ter tũ fi nĩ, nũr fi nỹ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hã ra fag tóg ti nyg mũ. Hã ra tóg fag pan mũ sir, kỹ tóg fi panh mré, fi mỹnh fi mré fi venh tĩ mũ, ti mré kãmũ mũ ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Fi nĩgé kãgmĩ kỹ tóg fi mỹ: “talitá cumi,” he mũ. Ẽg vĩ ki ke vẽ, hã vỹ: nĩ ra, jỹ, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kỹ vãhã gĩr fi tóg nĩ mũ sir, kánẽ tĩ fi nĩ sir. Kri prỹg tỹ 12 (ke) fi nĩ. Kỹ tóg ag mỹ e tãvĩ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Hã ra tóg ag mỹ vĩ tar han, ag tỹ ũ mỹ tó tũg jé. “Ha fi mỹ vẽjẽn ven,” he tóg. Hã ra tóg fi ter kỹ nỹ ra fi rĩn mãn. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Kỹ Jesus tóg tá kãkutẽ kỹ ã jamã tá jun mũ sir. Ti mré mũ tĩ ag tóg ti mré mũ mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Vẽnhkán ke kurã ki tóg ag vẽnh kanhrãn jafã ki ag kanhrãn mũ. Ag tỹ ti vĩ mẽ kỹ tóg ag mỹ e tĩ. “Hẽ tán hỹn ki kanhrãn, vẽnh jykre tag ti ki? Ũ nỹ hỹn ti kanhrãn?” he ag tóg, ti jamã tá ke ag. “Ẽg tỹ nén han vãnh hyn han tóg tĩgtĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Ĩn han tĩ ẽn vẽ mỹr,” he ag tóg. “Maria fi kósin vẽ mỹr, Tiago kãke, José, Judas, Simão kãke, kỹ ti ve fag vỹ ẽg mré nỹtĩ gé mỹr. Ti tỹ ne jé tỹ ẽg kãfór nĩ sór nẽ?” he ag tóg. Kỹ tóg ag mỹ tỹ ũ nỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kỹ Jesus tóg ag mỹ: “ẽmã ũ tá ke ag tóg Topẽ vĩ tó tĩ to é he tũ nĩgtĩ mỹr,” he mũ. “Ti jamã tá ke ag tóg ti to é he tĩ jãvo, ti mré ke ag, ti kanhkã ag,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kỹ Jesus tóg tá nén ũ han tũ nĩ sir. Ũn kaga pipir ag hã tỹ há' he tóg, ã nĩgé tỹ ag mẽ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ag tỹ ti ki ge tũ tóg ti mỹ e tĩ, ti jamãn ki. Kỹ tóg ẽmã kãsir mĩ tĩg kỹ ag kanhrãn tĩ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kỹ Jesus tóg ũ tỹ 12 (ke) ag jé prẽr mũ. Kỹ tóg ag mũn mũ, ũn régre tĩn', ũn régre tĩn' he tóg. Ag mỹ tóg vẽnh jykre nĩm mũ, ag tỹ vẽnh jagrẽ kórég pan mũ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kỹ tóg ag mỹ: “ãjag mũn kỹ pão ma mũ tũg nĩ,” he mũ, “bolsa ke gé, jãnkamy ke gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","“Vãtó hã va mũmnĩ, kãtó ti, pẽ né ke gé, pẽn to ró ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kỹ tóg ag mỹ: “ãjag tỹ ẽmã ũ tá jun kỹ, ãjag tỹ ĩn ra rã mũ hã ki nũgnũr hemnĩ,” he mũ, “hã ki ãjag tỹ kurã ki panh ke mũ ẽn tá krỹgkrỹg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","“Ẽmã ũ tá ke ag tóg kejẽn ãjag mỹ: kãgemnĩ, henh ke tũ nĩ, ag tỹ ãjag vĩ mẽ jãvãnh nỹtĩn kỹ. Kỹ ãjag pẽn hã kykũnh nĩ, ãjag tỹ tá pa kỹ,” he tóg, “ag tỹ ve kỹ to ki kanhró nỹtĩ jé, Topẽ tỹ ag mỹ: vó', he ti,” he tóg ag mỹ. “Ha mẽ, ki hã sóg tó mũ. Kurã tỹ ẽgno ki, isỹ vẽnh kar jykre tugnỹm ke kurã ẽn ki ag tóg jagãgtar nỹtĩnh mũ, ag tỹ ãjag vĩ jẽmẽ jãvãnh nỹtĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kỹ ag tóg mũ mũ sir, ũ tỹ 12 (ke) ag. “Ãjag jykre tovãnh nĩ,” he ag tóg mũ, vẽnh kar mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Vẽnh jagrẽ kórég pan ag tóg mũ, ha mẽ. Ũn kagyga ag to tĩn ag tóg mũ, azeite tỹ, kỹ ag tóg tỹ há' he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kỹ pã'i mág tỹ rei tóg Jesus kãme mẽg mũ sir. Vẽnh kar vỹ ti kãmén tĩ, hã kỹ tóg mẽg mũ. Pã'i mág tỹ rei ẽn jijin hã vỹ: Herodes, he mũ. Kỹ tóg: “João hỹn (tóg),” he mũ, “ũ tỹ ag kygpég tĩ ẽn ti,” he tóg. “Ã ter jan tán hỹn vỹn ké,” he tóg. “Hã kỹ tóg ẽg tỹ nén han vãnh kar ẽn hyn han tĩ,” he tóg, Jesus to, Herodes ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hã ra ũ tóg Jesus to: “Elias vẽ,” he mũ. Kỹ ũ tóg: “Topẽ vĩ tó tĩ vẽ, vãsỹ Topẽ vĩ tó tĩ ag ri ke vẽ,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hã ra Herodes tóg ti kãme mẽ kỹ: “João hỹn ã ter ja tá vỹn ké, sỹ ũn krĩ kym ja ẽn ti,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes vỹ João se ja nĩ, vẽse jafã kãki tóg ti fón ja nĩ, Herodias fi tugrĩn. Tỹ fi Filipe prũ fi nĩ, ti jãvy, hã ra tóg fi tỹ prũg mũ, Herodes ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kỹ João tóg Herodes mỹ: “ã hã ne tóg ã mré ke prũ fi tỹ prũg mũ',” he ja nĩ. “Fi ki ã tóg Topẽ vĩ mranh mũ,” he ja tóg nĩ, João ti, Herodes mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tag to Herodias fi tóg ti to kórég nĩ, ti tén ke to fi tóg jykrén nĩgtĩ, hã ra fi tóg ti tỹ hẽ ri ke tũ nĩ, ");
INSERT INTO kgpNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes tỹ ti kamẽg kỹ. João vỹ tóg tỹ ũn jykre kuryj nĩ. Topẽ jykre hã han tóg tĩ. Hã kỹ Herodes tóg ti jy nĩgãn tĩ, ti tỹ ti jykre há ki kanhró nĩn kỹ. João vĩ tóg ti mỹ vẽnhmỹ tĩ, ge ra tóg ti mỹ mẽ há tĩ, Herodes mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kejẽn tóg fi mỹ ti tén ke ki króm ke mũ. Herodes tóg ã mur ja kurã ẽn ki festa mág han mũ, tenente ag mỹ, soldado ag pã'i ag mỹ ke gé, ũn rico ag mỹ ke gé, Galiléia tá ke ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kỹ Herodias fi kósin fi tóg ag jo vẽnh gringrén mũ, hã ra tóg ag mỹ sĩ tãvĩ tĩ, Herodes mỹ, ti mré nỹtĩ ag mỹ ke gé, ti mré jẽg mũ ag mỹ. Kỹ tóg fi mỹ: “ã tỹ nén to vĩ mũ tỹ sóg ã mỹ nĩm mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Fi mỹ tóg: “sỹ ke há vẽ,” he mũ. “Ã tỹ nén to vĩ mũ kar nĩm jé sóg ke mũ, isỹ nén kar kuju mré hã,” he tóg, tátãg fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hã ra fi tóg ã mỹnh fi to tĩ mũ sir. “Inh hỹn ne to vĩnh mũ?” he fi tóg mũ, ã mỹnh fi mỹ. Kỹ fi tóg: “João krĩ to vĩmnĩ,” he mũ, “ũ tỹ ag kygpég tĩ ẽn krĩ to,” he fi tóg, ã kósin fi mỹ, Herodias fi. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kỹ fi tóg vẽsỹmér pã'i mág ẽn to vẽnhvãg tĩ mũ. “Inh mỹ ũri João Batista krĩ nĩm, pénky kãkã,” he fi tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kỹ Herodes tóg fe kaj mág han mũ sir. Hã ra tóg fi mỹ: “sỹ ke há vẽ,” he ja nĩ, hã kỹ tóg fi mỹ han sór mũ, ti mré nỹtĩ ag tỹ mẽ kãn ja nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hã kỹ tóg polícia ũ jẽnẽg mũ, ti tỹ ti krĩ ma kãtĩg jé. Kỹ tóg ti krĩ kym mũ sir, vẽse ja kãtá. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kỹ tóg ti krĩ ma kãtĩ mũ sir, pénky kãkã nĩm kỹ. Kỹ tóg fi mỹ nĩm mũ, tátãg fi mỹ. Kỹ fi tóg ã mỹnh fi mỹ ma kãtĩ mũ, Herodias fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kỹ João mré mũ tĩ ag tóg ti venh mũ mũ, ti ter mẽ kỹ. Kỹ ag tóg ti há va mũ mũ, vẽnh kej ra. Tá ag tóg ti péju mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kejẽn Jesus tỹ ũn vin mũ ag tóg Jesus to vỹnvỹn ke mũ, ti mỹ kãmén jé, ag tỹ vẽnh kar mỹ nén tó ja ẽn ti, ag tỹ nén ũ han mũ kar ẽn ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kỹ tóg ag mỹ: “mũ nỹ, ẽg pir mỹ ẽmã tũg ja ra mũ jé, ẽg vẽnhkán sĩ han jé,” he mũ. Kãmũ ag tóg nỹ nĩ, e ag tóg tĩ ha, kỹ tóg ag jẽn ke mũ ra vẽnhmỹ tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kỹ ag tóg canoa kãmĩ mũ mũ sir, ẽmã tũg ja ra, ãjag pir mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hã ra ũn e ag tóg ag mũ ve kỹ ag ki kanhrãn mũ, kỹ ag tóg ãjag pẽn kã ag jy pétẽ mũ, ẽmã kar tá kãmũ kỹ. Ag jo ag tóg tá junjun mũ sir, vẽnh e ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus tỹ tá jun kỹ tóg sir ũn e ag vég mũ, kỹ ag tóg ti mỹ jagtar nỹtĩ. Ti mỹ ag tóg tỹ ẽg mẽg tỹ mé, ẽg mẽg tỹ carneiro ri ke nỹtĩ. Ũ tỹ ẽg mẽg ki rĩr tũ nĩn kỹ tóg jagãgtar nỹtĩgtĩ, ẽg mẽg ti. Tag ri ke ag nỹtĩ, ũn e ẽn ag, Jesus mỹ, ag tỹ Topẽ vĩ ki kagtĩg nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Hã ra tóg rãké nỹ sir, kỹ ti mré mũ tĩ ag tóg ti mỹ: “ki ti ẽmã tũ nĩ, rãké ti nỹ ha,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","“Ã tỹ ag mũn kỹ tóg há tĩ vẽ. Kỹ ag tóg ẽmã kar mĩ mũnh mũ, vẽjẽn jãvãnh jé,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hã ra tóg ag mỹ: “ha inhhã ag jẽn ge,” he mũ. Hã ra ag tóg: “kỹ ẽg mỹ jãnkamy tỹ hẽn ri ke tỹ pão kajãm mũ'?” he mũ, “ẽg tỹ ag jẽn jé?” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kỹ tóg ag mỹ: “pão tỹ hẽ ri ke nỹ ki nỹtĩ?” he mũ. “Ha venh mũ jẽg,” he tóg. Ag tỹ ve kỹ ag tóg: “ũ tỹ 5 (ke) vẽ,” he mũ, “pirã régre ke gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kỹ tóg ag mỹ: “nĩgnĩ ra, re gỹnh tánh kri, mrugmru kri,” he mũ, “vẽnhmãn kỹ,” he tóg, vẽnh kar ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kỹ ag tóg vẽnhmãn kỹ nĩ', vẽnhmãn kỹ nĩ' he mũ, ũ vỹ tóg 100 (ke) nĩ' he mũ, jo ũ tóg 50 (ke) nĩ' he mũ, ag vẽnhmãn ũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kỹ tóg pão tỹ 5 (ke) génh kỹ, pirã régre génh kỹ kanhkã ki ẽvãnh mũ, kỹ tóg Topẽ mré vĩ mũ sir, kỹ tóg pão kénh mũ sir, ã mré mũ tĩ ag mỹ tóg vin mũ, ag tỹ ũn e ẽn mỹ vẽnh kãpãpãm jé. Pirã régre tỹ tóg vẽnh kãpópãm mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kỹ vẽnh kar vỹ ko kãn kỹ funfór mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kẽj tỹ 12 (ke) fãn ag tóg mũ sir, pão ke tỹ, pirã ke tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pão ẽn ko mũ ag tóg tỹ 5 mil (ke) nỹtĩ, ũn tỹtá fag tó tũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kỹ Jesus tóg vẽsỹmér ã mré mũ tĩ ag mỹ tó mũ, ag tỹ canoa kãmĩ mũ jé, ag tỹ ti jo kafã ũ ra mũ jé, ẽmã tỹ Betsaida ra. “Isỹ ũn e tag ag mỹ: ha mũjẽg, henh ke vẽ ver,” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kỹ tóg ag mỹ: “ha mũjẽg,” he mũ sir. Ag mũn kar tóg pãnónh to tãpry mũ, Topẽ mré vĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kuty ẽn kỹ canoa tóg ver tĩ nĩ, goj kãmĩ. Jo Jesus tóg tar tá jẽ nĩ ver, ã pir mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hã ra ag tóg canoa vóg kỹ ronron mũ sir, mũ kónãn ag tóg mũ sir, kãka tỹ ag kato tẽn kỹ. Hã ra tóg ag ronron vég mũ sir, Jesus ti. Kỹ tóg kurã ke ra ag to kãtĩ mũ, goj kri tĩg kỹ, ã pẽn kã mỹr. Hã ra tóg ag tá jun mũ sir, kỹ tóg ag pãtén sór nĩ ve nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ag tỹ goj kri ti tĩg ve kỹ ag tóg: “vẽnh kuprĩg vẽ,” he mũ. Kỹ ag tóg vẽkrẽnkrẽr mũ, ");
INSERT INTO kgpNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ag tỹ jũrũn ken kỹ, ag kar tỹ ti ve kỹ. Hã ra tóg vẽsỹmér ag mré vĩ mũ, kỹ tóg ag mỹ: “kamẽg tũg nĩ,” he mũ. “Inh hã vẽ, jũrũn ke tũg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kỹ tóg canoa kãki rã mũ sir ag mré, Jesus ti. Kỹ kãka tóg tũ' he mũ sir. Kỹ tóg ag mỹ e (pẽ) tãvĩ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hã kỹ tóg ag tỹ to jykrén tũ tĩ. Ver ag tóg krĩ tũ nỹtĩ, hã kỹ ag tóg Jesus jykre ki kagtĩg nỹtĩ ver, ti tỹ pão pir tỹ ũn e jẽn ja ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ag tỹ canoa kãmĩ pa kỹ ag tóg ga tỹ Genesaré tá junjun ja nĩ. Kỹ ag tóg canoa nỹgnỹn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ag tỹ canoa kãmĩ pa kar kỹ tá ke ag tóg vẽsỹmér ti ki kanhrãn mũ, Jesus ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kỹ ag tóg ĩn kar mĩ pétẽ mũ sir, kỹ ag tóg ũn kagyga ag gé kãmũ mũ ti to. Kur kã ag tóg ag gé kãmũ mũ. Ti jẽg jan ra ag tóg ti nón mũ mũ, ag tỹ ti jẽg ja mẽ kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ti tỹ ẽmã ũ tá jun kỹ ag tóg vẽnh kaga gé kãmũ tĩ, kỹ ag tóg ĩn prur ki ag vin tĩ, ẽmã kãsir ki, ẽmã mág ki ke gé, vãnh kãmĩ ke gé. “Mỹ ã mỹ há, ẽg tỹ hẽn ri ke mũn ã kur mráj mẽ jé?” he ag tóg ti mỹ. Kỹ ag tóg há' há' he kãn mũ sir, ag tỹ ti kur mẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kejẽn Fariseu ag tóg Jesus to vẽnhmãn mũ, Topẽ vĩ to professor ag mré. Jerusalém tá ag kãmũ ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hã ra ag tóg Jesus mré mũ tĩ ũ ag jẽn vég mũ. Nĩgpég tũ ja ag tóg nĩ, hã kỹ tóg Fariseu ag mỹ jẽggryg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseu ag tóg nĩgpe kar kỹ tỹ jẽg tĩ, Israel kar ag ke gé, ag tỹ ti si ag jykre han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ag tỹ negocio tá kãmũ kỹ ag tóg vẽso tỹ kó he tĩ, goj tỹ, vẽso tỹ kó he kar hã ag tóg ko tĩ. Vẽnh jykre si tỹ hẽn ri ke hyn han ag tóg tĩ, caneca kupég tĩ, kukrũ kupég tĩ, lata kupég tĩ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kỹ Fariseu ag tóg Jesus mỹ ke mũ, Topẽ vĩ to professor ag mré hã. “Ã mré mũ tĩ ag tỹ hẽ ri ke jé ti si ag jykre han tũ nĩ nẽ?” he ag tóg mũ. “Ag tỹ ne jé ãjag nĩgé jẽggry ra jẽn nẽ?” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Hã ra tóg ag mỹ: “Isaías vỹ ãjag to vĩ ja nĩ, vãsỹ,” he mũ, “kỹ tóg rán kỹ nĩ,” he tóg. “Ti vĩn hã vẽ, ha mẽ: povo tag vỹ ãjag nũnẽ hã tỹ inh mỹ vĩ há han tĩ, hã ra ag jykre pi(jé) tỹ inh jykre nỹ'. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Fagrĩnh mỹ ag tóg iso grĩnh ke tĩ, hã ra ag tóg ẽprã ke ag jykre to: Topẽ tỹ tón hã vẽ, he tĩ, he ja tóg nĩgtĩ, Isaías ti,” he tóg, Jesus ti. “Hã kỹ tóg ãjag to ki hã tó ja nĩ, ãjag jykre régre nỹtĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Topẽ vĩ tovãnh ãjag tóg mũ,” he tóg. “Hã ra ãjag tóg ẽprã ke jykre han tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kỹ tóg ag mỹ: “ãjag hã ne tóg Topẽ vĩ mranh tĩ',” he mũ, “ãjag tỹ ãjag jykre si hã han jé,” he tóg. “Hã ra tóg ãjag mỹ há nỹ, ãjag jykre si ẽn ti,” he tóg, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Moisés tỹ ãjag mỹ Topẽ vĩ tó kỹ tóg ãjag mỹ: “ã mỹnh fi mré ã panh kamẽg nĩ, fag jagãgtãn nĩ,” he ja nĩgtĩ. “Ũ tỹ ã han mũ fag mỹ vĩ kónãn mũ ẽn tén jé ã tóg ke mũ,” he ja tóg nĩgtĩ, Moisés ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","“Moisés jãvo ãjag jykre vỹ ge nĩ, ha mẽ. Ũ tóg kejẽn ã han mũ fag jagãgtãn sór tũ nĩ. Kỹ tóg fag mỹ ón kỹ: “Topẽ tũ vẽ,” he tĩ, ti tỹ fag mỹ nĩm jafã ẽn to. Kỹ tóg fag ki rĩr ke tũ nĩ, kỹ tóg fag to é he mũ sir. Ãjag jykre kórég hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kỹ Jesus tóg ag mỹ: “Topẽ vĩ mranh ãjag tóg tĩ, ti jẽgja kã ãjag tóg ẽprã ke ag jykre hã ki króm sór tĩ. Ge tỹ hẽn ri ke han ãjag tóg tĩ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kỹ tóg vẽnh kar jé prẽr mãn kỹ ag mỹ: “inh vĩ jẽmẽ ra,” he mũ, “ãjag kar tỹ ki kanhrãn jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Vẽjẽn pi(jé) ẽg kavénh tĩ',” he tóg, “ẽg tỹn ko kỹ,” he tóg. “Nén tỹ ẽg ki kãpa vỹ ẽg kavénh tĩ, ẽg tỹ nén ũ vẽnhmỹ han ẽn vỹ ẽg kavénh tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Ũ nĩgrẽg nỹtĩ tỹ tỹ jẽmẽ jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ti tỹ ã pir mỹ ĩn kãra rã kỹ ti mré mũ tĩ ag tóg ti ki jẽmẽg mũ. “Ẽg mỹ kãmén há han nĩ, ã vĩ tag,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kỹ tóg ag mỹ: “kỹ ãjag mỹ ki kanhró tũ nỹtĩ ver?” he mũ. “Ẽg jẽn tỹ ẽg jẽnky kãra rã kỹ tóg ẽg kavénh tũ nĩgtĩ mỹr,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","“Ẽg nug kãra tóg rã mũ, kar ẽg fón mũ. Ẽg krĩ kãra tóg rã tũ nĩgtĩ,” he tóg. Hã kỹ Jesus tóg vẽjẽn kar to: “há ti nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kỹ tóg: “nén tỹ ẽg ki kãpa vỹ ẽg kavénh tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","“Nén tỹ ẽg ki kãpan hã vẽ, hã vỹ: jykrén kónãn, he mũ, ũn mén tũ fag to én, he mũ, nén ũ péju, he mũ, ũ tén, he mũ, ã prũ tũ fi mré nỹ, he mũ, ã mén tũ mré nỹ, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nén kar to én, he mũ, vẽnh jykre pãno han, he mũ, ã tỹ nén ũ nenh (ka)mẽ, he mũ, ũ kato vĩ kónãn, he mũ, vẽnhmỹ inh ag kãfór kar nĩ, he tĩ, he mũ, krĩ tũ, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nén kar kórég ẽn tóg ẽg ki kãpa tĩ, hã kỹ tóg ẽg kavénh tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kỹ Jesus tóg tá kãkutẽ mũ sir, ga ũ ra tĩg jé, cidade tỹ Tiro ra, cidade tỹ Sidom ra ke gé. Tá tóg ĩn ũ krẽm nĩ mũ, hã ra tóg: “ker ũ inh nĩgja ki kanhrãn hẽ',” he mũ. Ge ra ag tóg ki kanhrãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kỹ vẽsỹmér ũn tỹtá ũ fi tóg kãtĩ mũ. Fi kósin fi vỹ jagrẽ kórég nĩ. Fi tỹ ti kãme mẽ kỹ fi tóg kãtĩ mũ. Kỹ fi tóg ti krẽm mũg ke mũ sir, ũn tỹtá fi. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Hã ra fi vĩ vỹ tỹ Grego nĩ, ũ tỹ Siro-Fenício krẽ vỹ tỹ fi nĩ. Kỹ fi tóg to vĩ mãn', to vĩ mãn', he mũ, ti tỹ fi kósin fi jagrẽ kórég ẽn kutẽm jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kỹ Jesus tóg fi mỹ: “ẽg jẽn vỹ tỹ ẽg krẽ tỹ ko jafã nĩ,” he mũ. “Vẽnhmỹ ti nĩ, ẽg tỹ ẽg krẽ pão tỹ cachorro mỹ fón kỹ,” he tóg, fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hã ra fi tóg Jesus ti mỹ: “hỹ,” he mũ. “Hã ra cachorro sĩ ag tóg ẽg krẽ pão vár ẽn ko tĩ, mesa krẽm,” he fi tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kỹ Jesus tóg fi mỹ: “tó há han ã tóg,” he mũ. “Ha tĩg, fi jagrẽ kórég tóg hur kutẽ, ã kósin fi ki,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kỹ fi tóg ã ĩn ra tĩ mũ sir. Fi tỹ tá jun kỹ fi kósin fi tóg nỹ mũ, cama kri, hã ra fi jagrẽ kórég ẽn vỹ kutẽ ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kỹ Jesus tóg cidade tỹ Tiro ki ga ki kutẽ mũ, kỹ tóg cidade tỹ Sidom fĩn rãm mũ gé sir, kỹ tóg ga tỹ Galiléia ki goj nig ra tĩ mũ sir, cidade tỹ 10 (ke) fĩn rãm kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kỹ ag tóg ũ pére kãmũ mũ, ti to, ũn kutu, ũn vĩ kar vãnh. Kỹ ag tóg ti mỹ ti tó mũ, ti tỹ ã nĩgé tỹ ti mẽ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Hã ra Jesus tóg ti pére tĩ mũ, ti pin kỹ, kỹ tóg ã nĩgé juféj tỹ ti nĩgrẽg nor nĩgfénh mũ, kỹ tóg ti nũnẽ to sug mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kỹ tóg kanhkã ki ẽvãnh kỹ ỹnh' ỹnh' he mũ sir, kỹ tóg ti mỹ: “efatá,” he mũ. Ẽg vĩ ki ke hã vỹ: “ti nĩgrẽg jé nor hé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kỹ ti nĩgrẽg tóg nor' he mũ sir, ti nũnẽ tóg kavar mũ sir. Vĩ tóg mũ sir, há' he tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kỹ Jesus tóg ag tỹ tó kamẽg, hã ra ag tóg tugtó kãn mũ, ti tỹ: “ker tó hẽ', ker tó hẽ',” he mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kỹ ag fe tóg hẽn ri ke mũ. “Ti tỹ nén kar há vỹ tóg há tãvĩ nỹtĩ,” he ag tóg, Jesus to. “Ũn kutu ag ẽmẽ hyn han tóg, ũn vĩ vãnh ag vĩ hyn han tóg ke gé,” he ag tóg, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kejẽn ũn e ag tóg vẽnhmãnmãn mũ, hã ra ag tỹ nén ũ konh ke tóg tũ tĩ. Kỹ Jesus tóg ã mré mũ tĩ ag jé prẽr mũ sir, kỹ tóg ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“inh mỹ ag tóg jagtar nỹtĩ, ũn e tag ag,” he mũ. “Kurã tãgtũ han ag tóg huri, ẽg mré, hã ra ag tóg vẽjẽn ve ja tũ nĩgtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","“Sỹ ag kókĩr ra ag mỹ: ha mũjẽg, hen kỹ inh mỹ ũ ag kãgter ha mẽ tóg tĩ, ẽmĩn kri, ẽpry kri, ag tỹ ãjag jamã ra vỹnvỹn ke jé,” he tóg. “Kuvar gy tóg nĩ, ũ ag jamã ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kỹ ti mré mũ tĩ ag tóg ti mỹ: “ẽg hẽ ri ken kỹ pão venh mũ, ẽmã tũg ja tag ti ki, ẽg tỹ ag jẽn jé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Hã ra tóg ag mỹ: “pão tỹ hẽ ri ke nỹ ki nỹtĩ ge?” he mũ. Kỹ ag tóg ti mỹ: “ũ tỹ 7 (ke) vỹ nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kỹ tóg vẽnh kar mỹ: “nĩgnĩ ra, ga kri,” he mũ. Kỹ tóg pão tỹ 7 (ke) ẽn mãn kỹ (tóg) Topẽ mré vĩ mũ. “Inh mỹ tóg há tĩ,” he tóg. Kỹ tóg kupãg' he mũ sir, pão ti, ã mré mũ tĩ ag mỹ tóg vin mũ sir, ag tỹ vẽnh kar ken jé. Kỹ ag tóg vẽnh kar ken mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kãkufár pipir vỹ ki nỹtĩ gé. Kỹ tóg to Topẽ mré vĩ mũ gé, kỹ tóg ag mỹ: “ha vẽnh ken,” he mũ gé, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Kỹ ag tóg ko kãn mũ sir, funfór ag tóg mũ, hã ra tóg kén mũ sir. Kre tỹ 7 (ke) ẽn fãn tóg mũ, ti kén ti, Jesus mré mũ tĩ ag tỹ génh kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ũ tỹ 4 (ke) ag vẽ, hẽn ri ke mũn, pão ko mũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kar kỹ Jesus tóg ag mỹ: “ha mũjẽg,” he mũ. Kỹ tóg vẽsỹmér canoa kãki rã mũ, ti mré mũ tĩ ag mré, kỹ ag tóg Dalmanuta tá ga ra mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kỹ Fariseu ag tóg ti tá junjun mũ. Ag tỹ ón kỹ ti ki jẽmẽ sór vẽ, ag tỹ kar ti kato vĩ jé. Kỹ ag tóg ti mỹ to vĩ mũ, ti tỹ ag mỹ kanhkã tá vẽnh jykre ven jé, ti tỹ ag mỹ ẽg tỹ nén han vãnh han jé. Ag tỹ ti jykre to: “Topẽ jykre mỹ vỹ?” he sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kỹ Jesus tóg jẽnger jagy han, ã fe tỹ, kỹ tóg ag mỹ: “ãjag ne tóg ẽg tỹ nén han vãnh hã ve sór mũ',” he mũ. “Sỹ ke há vẽ, hã kỹ sóg ke mũ: venh ke tũ ãjag nĩ. Ũri ke ag vỹ ẽg tỹ nén han vãnh venh ke tũ pẽ nĩ,” he tóg, ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kỹ tóg ag ré kỹ tĩ mũ sir, canoa kãki tóg rã mãn mũ, kỹ tóg kafã ũ ra tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Hã ra ti mré mũ tĩ ag tóg pão mĩ ẽkrén ja tũ nĩ. Pão pir hã vỹ kã nĩ nĩ, canoa kãkã. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Hã ra Jesus tóg ag kanhrãn kỹ ag mỹ: “ha mẽ,” he mũ. “Fariseu tỹ fermento há(r) kamẽg nĩ,” he tóg, “Herodes tỹ fermento há(r) kamẽg nĩ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kỹ ag tóg jagnẽ mỹ: “pão kã ẽg jatun,” he mũ, “hã kỹ tóg tag tó mũ,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Hã ra Jesus tóg ki kanhró nĩ, kỹ tóg ag mỹ: “pão tũ ti tĩ, he tũg nĩ,” he mũ. “Inh vĩ ki kagtĩg nỹtĩ ve ãjag tóg nỹtĩ, sỹ nén han mũ to jykrén tũ nỹtĩ ve ãjag tóg nỹtĩ,” he tóg. “Krĩ tũ nỹtĩ ve ãjag tóg nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","“Ãjag kanẽ ra ãjag kyvó nỹtĩ ve nỹtĩ,” he tóg. “Ãjag nĩgrẽg ra ãjag tóg kutu nỹtĩ ve nỹtĩ,” he tóg. “Mĩ ẽkrén nĩ, ");
INSERT INTO kgpNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","sỹ pão tỹ 5 (ke) tỹ ũn e jẽn ja ẽn mĩ. Ũ tỹ 5 mil (ke) ag vỹ kó, mỹr, hã ra tóg kén,” he tóg. “Ãjag kẽj tỹ hẽn ri ke fãn ti, pão ke ti?” he tóg ag mỹ. Kỹ ag tóg: “kẽj tỹ 12 (ke),” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Kỹ tóg: “kỹ pão tỹ 7 (ke) to jykrén nĩ gé,” he mũ. “Ũ tỹ 4 mil (ke) ag vỹ kó,” he tóg, “hã ra kre tỹ hẽ ri ke nỹ fór, ti ke tỹ?” he tóg. Kỹ ag tóg: “kre tỹ 7 (ke),” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kỹ tóg ag mỹ: “ge ra ãjag tóg ki kagtĩg nỹtĩ,” he mũ. Ti tỹ ag mỹ Fariseu ag jykre tó jan hã vẽ, Herodes jykre ti. Ag jykre hã to tóg: ag tỹ fermento há(r), he ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kỹ tóg kafã ũ tá jun mũ sir, ẽmã tỹ Betsaida tá, ti mré mũ tĩ ag mré. Kỹ tá ke ag tóg ũn kyvó pére kãmũ mũ. Jesus mỹ ag tóg to vĩ mũ, ti tỹ ti mẽ jé, ã nĩgé tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kỹ tóg ũn kyvó nĩgé kãgmĩ kỹ ti pére kuté mũ, ẽmã ki. Kỹ tóg ti mỹ: “ã mỹ nén ũ vég mũ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kỹ tóg ẽvãnh kỹ ti mỹ: “ag ve inh,” he mũ, “hã ra ag tóg inh mỹ tỹ ka mũ ẽn ve nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kỹ tóg ã nĩgé tỹ ti kanẽ mẽ mãn mũ, kỹ tóg ẽvãnh há han mũ sir. Há' he tóg mũ. Tãmĩ tóg ve há han kãn mũ, ũn kyvó ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kỹ Jesus tóg ti mỹ: “ha vẽsỹmér ã jamã ra tĩg,” he mũ. “Ẽmã tag ki rã tũg nĩ,” he tóg ti mỹ, Jesus ti. Kỹ tóg tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Kỹ Jesus tóg ã mré mũ tĩ ag mré tĩg mãn mũ gé sir, ẽmã tỹ Cesaréia Filipe tá ga ra. Ẽmĩn jagma tĩg kỹ, ẽpry jagma tĩg kỹ tóg ã mré mũ tĩ ag ki jẽmẽg mũ, Jesus ti. “Ag iso hẽ ri ke tĩ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kỹ ag tóg ti mỹ ke mũ. “João Batista vẽ, he ag tóg tĩ ã to,” he ag tóg mũ sir. “Jãvo ũ ag tóg: Elias vẽ, he tĩ. Jãvo ũ ag tóg: Topẽ vĩ tó tĩ ũ vẽ, he tĩ, ã to,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Kỹ tóg ag mỹ: “ag jãvo ãjag iso hẽ ri ke tĩ?” he mũ. Kỹ Pedro tóg ti mỹ: “tỹ ã Cristo nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Kỹ tóg ag jyvẽn mũ, ag tỹ ũ mỹ kãmén tũ nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kỹ tóg ag kanhrãn mũ sir. “Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg. “Ijagtar jagy han ke vẽ,” he tóg. “Kófa ag tỹ iso: kórég ti nĩ, henh ke vẽ, Topẽ tũ ki rĩr tĩ ag ke gé, Topẽ vĩ to professor ag ke gé,” he tóg. “Ag tỹ isén ke vẽ, kurã tãgtũ tũg mũ ra sóg rĩr mãn mũ hã ra,” he tóg mũ, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kỹ ag tóg ki kanhrãn kãn mũ, ti tỹ ag mỹ nén tó mũn ki. Hã ra Pedro tóg ti pin kỹ ti mré vĩ mũ, kỹ tóg: “vĩ tỹ ge han tũg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hã ra Jesus tóg vẽsỹjãm ẽvãnh kỹ ti mré mũ tĩ ag ki ẽvãnh mũ. Kỹ tóg Pedro to jũ mũ. “Kutĩg, Satanás',” he tóg. “Ã pi(jé) Topẽ jykre tó mũ',” he tóg. “Ẽprã ke jykre vẽ, ã tỹ inh mỹ nén tó mũ tag ti,” he tóg, Pedro mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kỹ Jesus tóg ã mré mũ tĩ ag mré vẽnh kar jé prẽr mũ, kỹ tóg ag mỹ kãmén mũ. “Ãjag tỹ inh mré kãmũ kỹ tóg há tĩnh mũ,” he tóg. “Kỹ ãjag jykre tovãnh nĩ, ãjag tỹ isũ tãvĩ han jé. Ha vé, ag tỹ inh cruz tỹ inh kri fi kỹ sóg tĩg ke mũ, ag tỹ to isa kỹ isén jé, ha vemnĩ. Vẽnh nenh ke tũ sóg nĩ. Isỹ tag han ri ke han nĩ, kurã kar ki, ãjag tỹ inh mré mũ sór nỹtĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Ãjag tỹ ãjag jykre hã han sór kỹ ãjag tỹ nũgme ki vár ke vẽ,” he tóg. “Jãvo ãjag tỹ isugrĩn ãjag jykre toyãnh kỹ ãjag krenkren ke vẽ,” he tóg, “ãjag tỹ vẽnh vĩ sér tugrĩn kãgter ke mũ (hã) ra,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“Hẽn ri ke mũn ãjag hỹn mundo ki nén ũ kar ganhar henh ke mũ, hã ra ãjag kuprĩg tóg vãfor ke mũ. Kỹ tóg kórég nỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ẽg tỹ ne tỹ ẽg kuprĩg kajãm ke tóg tũ tĩ, ẽg tỹ ti ve mãn jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Ũri ke ag tóg vyr mỹ Topẽ ũ hyn han tĩ, kỹ ag tóg Topẽ vĩ mranh tĩ gé,” he tóg. “Ag kãmĩ iso mỹ'ãg tũg nĩ, inh vĩ to. Ãjag tỹ ũri iso mỹ'ãg kỹ sóg ãjag to mỹ'ãg ke mũ gé, inh kãtĩg mãn kỹ,” he tóg. “Ãjag to sóg mỹ'ãg ke mũ, sỹ Topẽ tỹ jẽnẽ mág ag mré kãtĩg ken kỹ. Ijóg vỹ tóg isỹ ũn mág han ke mũ, inh kãtĩg mãn ti kỹ,” he tóg. “Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Kỹ tóg ag mỹ: “ha vé, ki hã sóg tó mũ,” he mũ. “Ãjag kãmĩ ũ ag vỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ, ãjag ter ke to hã, tag ki ẽg mré nỹtĩ ũ ag. Topẽ vỹ tar nĩ. Ti tar nĩ ve jé ag tóg ke mũ, ãjag ter ke to hã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kar kurã tỹ 6 (ke) tũg kỹ Jesus tóg ag mỹ: “mũ nỹ, vyr mỹ,” he mũ. Pedro mỹ tóg ke mũ, Tiago mỹ ke gé, João mỹ ke gé. Ag hã mré tóg pãnónh ra tĩ mũ. Kỹ tóg ag jo vẽnh ve ũ han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ti kur vỹ tóg kókov tãvĩ nĩ sir, kópréj tãvĩ, fag tỹ kur kupri fãg mũ ẽn kupri kãfór tóg nĩ, ga kar mĩ hã. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kỹ Elias tóg sir vẽnh ven mũ, Moisés ke gé. Jesus mré ag tóg vẽmén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kỹ Pedro tóg Jesus mỹ: “Senhor,” he mũ. “Tag ki tóg ha nĩ,” he tóg. “Ẽg tỹ tag ki pãjó tãgtũ han kỹn hỹn ha nĩnh mũ, ã mỹ, Moisés mỹ, Elias mỹ ke gé,” he tóg. Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hã ra ag fe tỹ jũrũn ke kỹ tóg ti tỹ nén tónh ke ki kagtĩg nĩ, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kỹ kanhkã góg vỹ sir ag kri rũm ke mũ, kỹ, vẽnh vĩ tóg mẽ há' he mũ, kanhkã góg kãtá, kỹ tóg: “inh kósin hã vẽ,” he mũ. “Inh fe pẽ vẽ,” he tóg. “Ti vĩ jẽmẽ ra,” he tóg, vẽnh vĩ ti, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kỹ vãhã ti mré mũ tĩ ag tóg ki ẽvãnh mãn mũ sir, kỹ ag tóg Jesus hã vég mũ sir, ti mrẽ nỹtĩ ag ve mãn tũ ag tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kỹ ag tóg pãnónh tá kãre mũ sir. Kỹ Jesus tóg: “ker ũ mỹ ãjag tỹ ũri nén vég mũ tó hẽ',” he mũ. “Ẽprã ke fi kósin tỹ ã ter ja tã vỹn ke kar hã inh kãmén nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hã kỹ ag tóg ti vĩ han mũ sir. “Ne nẽ hỹn, ti tỹ: iser ja tá vỹn ke, he mũ tag ti?” he ag tóg mũ, jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kỹ ag tóg Jesus mỹ: “hã ra Topẽ vĩ to professor ag tóg Elias kãtĩg mãn ke tó tĩ. “Kãtĩg jé tóg ke mũ, Cristo kãtĩg ke to hã,” he ag tóg tĩ, Elias to. Hã mỹ'?” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Kỹ tóg ag mỹ: “hỹ,” he mũ, “kãtĩg jé tóg ke mũ, Elias ti, nén kar han mãn jé,” he tóg. “Hã ra sóg rán kỹ nĩ gé. Tỹ sóg ẽprã ke fi kósin nĩ mỹr,” he tóg. “Jagtar jagy mẽ jé sóg ke mũ. Ag tỹ iso é henh ke,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","“Kỹ Elias vỹ hur kãtĩg gé, kỹ ag tóg ti tỹ han, ag tỹ nén han sór mũ ẽn ti,” he tóg. “Hã kỹ tóg rán kỹ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kỹ ag tóg mũ mũ sir. Kỹ ag tóg vãhã Jesus mré mũ tĩ ũ ag tá junjun mũ sir. Kỹ ag tóg vẽnh e vég mũ, ag pénĩn, kỹ Topẽ vĩ to professor ag tóg ag vĩ kato vĩ ũ han mũ, Jesus mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kỹ tóg vãhã vẽnh e ẽn ag mỹ e tĩ, ag tỹ ti ven kỹ. Kỹ ag tóg ti to pétẽ kãmũ mũ sir, ti mỹ: “ã mỹ há?” he jẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kỹ Jesus tóg ag mỹ: “ãjag tỹ ne tỹ vẽmén nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kỹ ag kã ũ tóg ti mỹ: “Senhor,” he mũ. “Inh kósin pére sóg kãtĩ, ã to,” he tóg. “Jagrẽ kórég ti nĩ, hã kỹ tóg vĩ vãnh (pẽ) nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","“Ti jagrẽ kórég tỹ ti kã vyryn ke kỹ tóg kutẽ tĩ, kỹ tóg jãrãn tĩ, ã jã tỹ tóg gyngyn ke tĩ, tar' he tóg,” he tóg. “Ã mré mũ tĩ ag mỹ sóg to vĩ vẽ, ag tỹ ti jagrẽ kórég kutẽm jé, hã ra ag tóg tỹ hẽ ri ke tũ nĩ,” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kỹ Jesus tóg ag mỹ: “ãjag ne tóg inh ki rã há han tũ nĩgtĩ',” he mũ. “Jykre pãno ãjag nỹtĩ,” he tóg. “Kysã tỹ hẽn ri ke ki inh hỹn ãjag mré tĩ nĩ'? Kysã tỹ hẽn ri ke ki inh hỹn ãjag to fe tĩg nĩ?” he tóg. “Inh mỹ ti pére kãmũjẽg,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kỹ ag tóg ti mỹ ti pére kãmũ mũ sir. Jesus tỹ ti jagrẽ kórég vég mũ ra tóg kyrũ kã vyryn ke mãn mũ gé, kỹ tóg kutẽ mãn mũ gé sir, vĩrĩn', vĩrĩn' ke tóg mũ gé sir, jãrãn tóg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kỹ Jesus tóg ti panh ti mỹ: “mỹ si há tĩ ha?” he mũ. Kỹ tóg: “ã sĩ kã tóg ge nĩ,” he mũ, ti panh ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Kejẽn ti jagrẽ kórég tóg pĩ ki ti fón mũ, goj ki ke gé, ti tỹ ti tén jé,” he tóg. “Ã tỹ hẽ ri ken há nĩn kỹ ẽg jagãgtãn nĩ, ti tỹ há' hemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kỹ Jesus tóg ti mỹ: “ã tỹ hẽ ri ken hã nĩn kỹ, he tũg nĩ, inh mỹ,” he mũ. “Ũ tỹ Topẽ ki rã mũ ẽn tỹ hẽ ri ken há han mũ, nén kar tỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kỹ vẽsỹmér kyrũ panh tóg: “ti ki sóg rãnh mũ,” he mũ, jamã hár(a). “Isỹ ti ki rã tũ ẽn ti tỹ inh ki tỹ tũ' hemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Hã ra Jesus tóg ũ tỹ hẽn ri ke vẽnhmãn vég mũ, kỹ tóg ti jagrẽ kórég to jũ mũ. “Vẽnh jagrẽ vĩ vãnh',” he tóg, “vẽnh jagrẽ kutu',” he tóg, “ha kãkutẽ, ti ki rã mãn tũg,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kỹ tóg prẽr mũ sir, ti tỹ jũrũn ke han tóg mũ sir. Kỹ tóg kyrũ ki kãkutẽ mũ sir. Kỹ kyrũ tóg ter ve nĩ, kỹ ag tóg ti to: “tũg ja ti nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hã ra Jesus tóg ti nĩgé kãgmĩ kỹ ti nĩm mũ sir, kỹ tóg jẽgnẽ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kỹ Jesus tóg tĩ mũ. Ti tỹ ĩn kãra rã kỹ ti mré mũ tĩ ag tóg ti pin kỹ ti mỹ vĩ mũ. “Ẽg ne tóg ti tỹ há' he ja tũ nĩ'. Hẽ ri ken kỹ, hỹn?” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kỹ tóg ag mỹ: “vẽnh jagrẽ kórég tỹ ge kutẽm tóg jagy nỹ ẽg mỹ,” he mũ. “Topẽ mré ẽg vĩ tĩ, kỹ ẽg tóg mrẽ vãkrég tĩ gé sir. Kỹ tóg vãhã kãkutẽ tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kỹ ag tóg tá kãpa kỹ Galiléia mĩ mũ mũ. Hã ra tóg: “ker ũ ẽg tỹ mĩ mũ ki kanhrãn hẽ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ti tỹ ti mré mũ tĩ ag kanhrãn sór vẽ, hã kỹ tóg ke mũ. Kỹ tóg ag mỹ: “ẽprã ke fi kósin ẽn vỹ jagtar nĩnh mũ,” he mũ. “Inh hã vẽ. Ẽprã ke ag vỹ ag tỹ isỹ nén han sór mũ ẽn han ke mũ,” he tóg. “Ag tỹ isén ke vẽ. Ag tỹ isén kar kỹ sóg hã ra rĩr mãn mũ, kurã tãgtũ tũg kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kỹ tóg ag tỹ ti tỹ nén tó mũ tag to jykrén tũ tĩ, hã ra tóg ag tỹ ti ki jẽmẽg tũ nỹtĩ, ag tỹ ti kamẽg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kỹ ag tóg mũ mãn kỹ cidade tỹ Cafarnaum tá junjun mũ sir. Tá ag tóg ĩn ũ krẽm nỹtĩ. Ĩn ẽn tá junjun kỹ Jesus tóg ag mỹ: “ãjag tỹ ne tó mũ nẽ, ẽpry jagma?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Hã ra ag tóg ti mỹ tó tũ nĩ. Ẽmĩn jagma mũ kỹ ag tóg jagnẽ mỹ: “ũ nỹ hỹn ẽg kãfór kar jẽ?” he ja nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kỹ Jesus tóg nĩ mũ, kỹ tóg ũ tỹ 12 (ke) ag jé prẽr mũ sir, kỹ tóg ag mỹ: “ãjag mỹ tỹ ũn mág nỹtĩ sór mũ'?” he mũ. “Kỹ vẽsỹ ũn sĩ ri ke nỹtĩmnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kỹ tóg gĩr sĩ mỹ: “kunĩg,” he mũ. Ag kuju kã tóg ti fẽg mũ, kỹ tóg ti jagma ã pẽ fón mũ sir, kỹ tóg ũ tỹ 12 (ke) ag mỹ: “ãjag hã vỹ tỹ inh mré ke nỹtĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ãjag tỹ tỹ inh mré ke nỹtĩ kỹ gĩr tỹ ge jẽ'ỹn nĩ, ti to há nỹtĩmnĩ, isugrĩn. Ãjag tỹ isugrĩn ti to há nỹtĩn kỹ ãjag tóg iso há nỹtĩ gé,” he tóg. “Ãjag tỹ iso há nỹtĩ kỹ ãjag tóg ũ tỹ ijẽnẽg mũ ẽn to há nỹtĩ gé sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kỹ João tóg Jesus mỹ: “Senhor,” he mũ. “Ũ ve ẽg tóg, kỹ ẽn tóg ã jyjy tó kỹ vẽnh jagrẽ kórég pan tĩ, ẽg tỹ ũn vég mũ ẽn ti,” he tóg mũ, Jesus mỹ. “Hã ra tóg ẽg mré tĩ tũ nĩgtĩ, kỹ ẽg tóg ti mỹ: “vẽnh jagrẽ kórég pan sór tũg nĩ,” hé,” he tóg, João ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Hã ra Jesus tóg ti mỹ: “ti tỹ vẽnh jagrẽ kórég pan kamẽg tũg nĩ,” he mũ. “Ũ tỹ inh jiji tó kỹ nén han vãnh han kỹ tóg kar kỹ iso vĩ kónãn ke tũ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","“Ũ tỹ ẽg kato tẽ nĩ tũ nĩn kỹ ẽg mré ke vẽ sir,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Sỹ ke há vẽ, hã kỹ sóg tó mũ: kejẽn ũ tóg ãjag mỹ goj fẽg mũ, isugrĩn, ãjag tỹ tỹ inh mré ke nỹtĩ tugrĩn. Ẽn tóg vẽnh kato nén ũ há venh ke mũ ge,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Kỹ tóg ag mỹ ke mãn mũ. “Ũn sĩ tag vỹ inh ki rã kỹ jẽ. Kejẽn ũ tóg ti tỹ inh vĩ mranh han sór mũ. Ẽn jykre vỹ kórég tãvĩ nỹ,” he tóg. “Ẽn hã mỹ tóg há nỹnh mũ vẽ, ũ tỹ pó mág tỹ ti nunh to sa kỹ goj nig ki ti fón jé, ti tỹ goj ki ter jé. Jagy tãvĩ tóg tĩ, ũ tỹ gĩr tỹ isovãnh han kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Ã tỹ nén ũ vóg kỹ Topẽ vĩ mranh kỹ ã nĩgnó kym nĩ, ã tỹ ke mãn tũ nĩ jé. Jagy tóg nỹ, ã nĩgnó pir ti. Jãvo tóg há nĩ, ã tỹ rĩr krỹg ja tũ venh ke mũ ti. Ã tỹ ã nĩgnó régre ra nũgme ki kutẽn kỹ tóg jagy kãfór tĩnh mũ, inferno ki kutẽn kỹ, pĩ nhyr vãnh ki kutẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tá ga ga tóg ã konh mũ gé, hã ra tóg tỹ tũ' henh ke tũ nĩ. Tá pĩ ẽn nhyr ke tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ã tỹ hẽ kãtá tĩg kỹ Topẽ vĩ mranh kỹ ã pẽn kym nĩ, ã tỹ ke mãn tũ nĩ jé. Jagy ti nỹ, ã tĩg vãnh ti. Hã ra tóg há nĩ, ã tỹ rĩr krỹg ja tũ venh ke mũ ti. Ã tỹ ã pẽn régre ra nũgme ki kutẽn kỹ tóg jagy kãfór tĩnh mũ, inferno ki kutẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tá ga (ga) tóg ã konh mũ gé, hã ra tóg tỹ tũ' henh ke tũ nĩ. Tá pĩ ẽn nhyr ke tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ã tỹ nén ũ ki vẽ'ĩ kỹ Topẽ vĩ mranh kỹ ã kanẽ tỹ nám kemnĩ, ã tỹ ke mãn tũ nĩn jé. Jagy ti nĩ, ã kyvó ti. Jãvo tóg há nĩ, ã tỹ Topẽ tỹ tỹ ẽg pã'i nĩ ven kỹ. Ã tỹ ã kanẽ régre ra nũgme ki kutẽn kỹ tóg jagy kãfór tĩnh mũ, inferno ki kutẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tá ga (ga) tóg ã konh mũ, hã ra tóg tỹ tũ' henh ke tũ nĩ. Tá pĩ ẽn nhyr ke tũ nĩ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Pĩ tỹ ẽg pũn ri ke ti nĩ, ẽg jagãgtar ti. Kỹ ãjag jagãgtar nỹtĩn kỹ isugrĩn, kỹ ãjag jagãgtar ẽn ki ãjag jykre tóg kuryj nỹ sir. Kỹ tóg sa ri ke nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sa vỹ há nĩ. Hã ra sa kãhór nĩn kỹ tóg hã ra kórég nĩ, kỹ ẽg tỹ ne tỹ ti tỹ kajã' henh ke tóg tũ tĩ, tỹ sa' he mãn ke tóg tũ tĩ,” he tóg. “Kỹ sa há ri ke nỹtĩmnĩ. Jagnẽ to krĩ kusa nỹtĩmnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kỹ Jesus tóg tá kutẽ mũ, kỹ tóg ga tỹ Judéia ra tĩ mũ sir, goj tỹ Jordão mãra. Kỹ vẽnh e ag tóg ti to vẽnhmãnmãn mũ sir, kỹ tóg ag kanhrãn mãn mũ gé. Ti tỹ nén han tĩ ẽn han mãn tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kỹ Fariseu ag tóg ti tá junjun mũ gé sir. Ag tỹ ón kỹ ti ki jẽmẽ sór vẽ, vẽnh prũ fón ke to. Kỹ ag tóg ti mỹ: “ẽg tỹ ẽg prũ fi mỹ: ha tĩg, he tag mỹ kuryj nỹ'?” he mũ. Ag tỹ ón kỹ ti vĩ mẽ sór vẽ hã ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Kỹ tóg ag mỹ: “Moisés ãjag mỹ hẽ ri ké?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kỹ ag tóg ti mỹ: “Moisés hã tóg ẽg mỹ: ã tỹ ã prũ fi fón sór kỹ fi mỹ vẽnh rán kỹ nĩm, fi tỹ kar kỹ tĩg jé, he ja nĩ, Moisés ti,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Hã ra Jesus tóg ag mỹ: “ãjag fe kórég nỹtĩn kỹ, hã kỹ tóg ãjag mỹ tag tó ja nĩ, vẽnh rán ki, Moisés ti,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Topẽ tỹ nén kar han ve ki tóg ti mré fi han,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Hã kỹ ũn gré tóg ã prũ fi to ã panh re kỹ tĩnh mũ, ã mỹnh fi ré kỹ ke gé. Ã prũ fi mré tóg tĩnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Fi mré tóg tỹ ũn pir nĩ sir, ã prũ fi mré, he tóg. Topẽ ti. Hã kỹ fag tóg tỹ ũn pir nỹtĩ. Fag pi(jé) tỹ ũn régre nỹtĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Hã kỹ fag tỹ vẽnh kãpãm tũg nĩ. Topẽ tỹ fag tỹ ũn pir há(r) vẽ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ag tỹ ĩn kãtá nỹtĩn kỹ ti mré mũ tĩ ag tóg ti ki jẽmẽ mãn mũ, vẽnh prũ fón to. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kỹ Jesus tóg ag mỹ: “ãjag tỹ ãjag prũ fi fón kar kỹ ũ fi tỹ prũg mãn kỹ ãjag prũ tũ fi vẽ, ha mẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","“Kỹ fi tỹ ã mén fón kar ũ tỹ mén mãn kỹ fi mén tũ vẽ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jo fag tóg gĩr tatĩ kãmũ mũ, Jesus tỹ ã nĩgé tỹ ag mẽ jé. Hã ra ti mré mũ tĩ ag tóg fag to jũ mũ, ũ tỹ ag tatĩ kãmũ mũ fag to. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hã ra Jesus tóg vég mũ, kỹ tóg ã mré mũ tĩ ag to jũ mũ. Kỹ tóg ag mỹ: “vĩ tũg nĩ, gĩr ag mỹ,” he mũ, “gĩr ag tỹ iso kãmũ kamẽg tũg nĩ,” he tóg. “Ũ tỹ ge hã vỹ ẽg Senhor tỹ Topẽ krẽm nỹtĩ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Sỹ ke há vẽ, hã kỹ sóg tó mũ: gĩr ag vỹ iso há pẽ nỹtĩ. Ũn kãsir tag ag ri ke nỹtĩmnĩ, ke tũ nĩ (mũ) ra ãjag tóg venh ke tũ (pẽ) nĩ, Topẽ tỹ tỹ ẽg pã'i nĩ ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kỹ tóg gĩr jagma ã pẽ fón mũ sir, ã nĩgé tỹ tóg ag mẽ kãn mũ sir, ag to tóg Topẽ mré vĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kỹ Jesus tóg tĩg mãn mũ gé sir. Ti tỹ tĩg ke jẽ ra ũ tóg ti to vẽnhvãg kãtĩ mũ, kỹ tóg ã jakrĩ tỹ jẽ mũ, kỹ tóg ti mỹ: “Senhor,” he mũ. “Há pẽ ã tóg nĩ,” he tóg. “Sỹ inh rĩr krỹg ja tũ venh há tóg tĩ. Sỹ ti ve jé inh hỹn vẽnh jykre há tỹ hẽ ri ke han mũ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kỹ Jesus tóg ti mỹ: “ã tỹ ne jé iso: há ã nĩ, he nẽ?” he mũ. “Ẽg pi(jé) há nỹtĩ'” he tóg. “Topẽ hã ne ã pir mỹ há nĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“Topẽ tỹ nén to ẽg jyvẽn ki kanhró ã tóg nĩ, hã vỹ: ũ tén tũg nĩ, he mũ, ã prũ tũ fi mré nỹ tũg nĩ, he mũ, nén ũ péju(g) tũg nĩ, he mũ, ũ to ón tũg nĩ, he mũ, vẽnh mỹ mẽ nĩ tũg nĩ, he mũ, ã nỹ mré ã jóg kamẽg nĩ, he mũ,” he tóg ti mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Hã ra tóg Jesus ti mỹ: “tag kar ki sóg króm kãn, isĩn kã,” he mũ, kyrũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Kỹ Jesus tóg ti ki ẽvãnh mũ, kỹ tóg tỹ ti fe jẽ. Kỹ tóg ti mỹ: “nén ũ pir vỹ tũ nĩ ver,” he mũ. “Ã tũ kar vãm tĩg, ã tỹ ũn jagãgtar ag mỹ vin jé, jãnkamy ti. Kỹ ã tóg kanhkã tá tũ mág nĩ sir. Kar kãtĩg nĩ, ã tỹ inh mré tĩg jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kỹ tóg ti mỹ vẽnhmỹ tĩ, Jesus vĩ ti. Kỹ tóg fe kaj tĩ mũ sir, ti tũ e nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kỹ Jesus tóg vẽnh pénĩn ẽvãnh kỹ ã mré mũ tĩ ag mỹ ke mũ sir. “Jagy ti nỹ, ũn rico tỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kỹ ti vĩ tóg ti mré mũ tĩ ag mỹ e tĩ. Hã ra Jesus tóg ag mỹ ke mãn mũ. “Inh krẽ',” he tóg. “Jagy tãvĩ ti nỹ mỹr, Topẽ tỹ tỹ ẽg pã'i nĩ venh ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","“Cavalo pãnĩ sór vỹ préj nor fĩn kutẽ tũ nĩ,” he tóg. “Ti tỹ fĩn kutẽ há nĩn ra tóg ver jagy tĩ vẽ, ũn rico tỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kỹ tóg ag mỹ e (pẽ) tãvĩ tĩ. “Kỹ ũ hỹn kren ke tũ pẽ nĩ,” he ag tóg, jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kỹ Jesus tóg ag ki ẽvãnh kỹ ag mỹ: “ẽprã ke ag vỹ vẽnh krenkren han ki kagtĩg nỹtĩ,” he mũ. “Ag jãvo Topẽ tóg ẽg krenkren han ki kanhró nĩ,” he tóg. “Topẽ hã tóg nén kar han ke ki kanhró nĩ inhhã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kỹ Pedro tóg ti mỹ: “ha vé,” he mũ. “Ẽg tỹ nén ũ kar ré kỹ ẽg tóg ã mré mũ mũ,” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kỹ Jesus tóg ag mỹ ke mãn mũ. “Sỹ ke há vẽ, hã kỹ sóg tó mũ,” he tóg mũ. “Ũ tóg kejẽn isugrĩn ã jamã ré kỹ tĩ mũ, ã jãvy ré kỹ tĩ mũ, ti kãke, ti ve, ti mỹnh, ti panh, ti krẽ, ti japỹ ré kỹ tĩ mũ gé, isugrĩn, vẽnh vĩ sér tugrĩn,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","“Ẽn vỹ tóg sir vẽnh kato ũ tỹ 100 (ke) venh ke mũ, ũri hã ra, hã vỹ: ẽmã kar, he mũ, jãvy kar, kãke kar, ve kar, mỹnh kar, ẽpỹ kar ve jé tóg ke mũ. Hã ra ag tóg ti vóg kónãn ke mũ gé. Kar kỹ tóg vãhã sir rĩr krỹg ja tũ venh ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Jãvo tag ki ũn mág ũ tỹ tá tỹ ũn kãsir nỹtĩnh ke vẽ, tére kỹ, kỹ tag ki ũn kãsir ũ tỹ tá tỹ ũn mág nỹtĩnh ke vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kar kỹ ag tóg mũ nĩ sir, Jerusalém ra, Jesus mré mũ tĩ ag, kỹ Jesus tóg ag jãmĩ tĩ nĩ. Hã ra tóg ag mỹ e tĩ, ti nón mũ ag tóg mũmẽg mũ sir, ag tỹ Jerusalém ra mũn kỹ. Kỹ Jesus tóg ũ tỹ 12 (ke) ag mỹ vẽnh kãmén mãn mũ, vyr mỹ. Ti tỹ ag mỹ ã tỹ nén venh ke ẽn tó mãn sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kỹ tóg ag mỹ: “ha vé, Jerusalém ra ẽg tóg mũ mũ,” he mũ. “Ẽprã ke fi kósin ẽn vỹ jagtar ke mũ. Inh hã vẽ. Ón kỹ Topẽ tũ ki rĩr tĩ to pã'i ag tóg ag tỹ isỹ nén han sór mũ ẽn han ke mũ, Topẽ vĩ to professor ag ke gé,” he tóg. “Ag tỹ iso: ter jé tóg ke mũ, henh ke vẽ,” he tóg. “Kar kỹ ag tóg fóg ag mỹ inh fẽg ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","“Kỹ ẽn ag tỹ iso é henh ke vẽ, iso sug ke vẽ, inh mrãnmrãn ke vẽ gé, isén ke vẽ gé. Kar kurã tãgtũ ki sóg hã ra rĩr mãn mũ sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kỹ Tiago mré João ag tóg ti kukãm mũ mũ, Zebedeu krẽ ag. “Senhor,” he ag tóg ti mỹ. “Ẽg mỹ ẽg tỹ nén to vĩ tag ti han,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kỹ tóg ag mỹ: “ne nẽ, sỹ ãjag mỹ han ke ti?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kỹ ag tóg ti mỹ: “kejẽn ã tóg tỹ pã'i nĩnh mũ,” he mũ. “Kỹ sỹ ã pẽgja tá nĩnh há tóg tĩ vẽ,” he tóg, jo ũ tóg: “sỹ ã jakãnh tá nĩnh há tóg tĩ vẽ,” he mũ gé. “Ẽg tỹ ã rã hã nỹtĩnh há tóg tĩ vẽ, ã tỹ tỹ pã'i nĩn kỹ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hã ra Jesus tóg ag mỹ: “ãjag tỹ nén to vĩ mũ ki kagtĩg ãjag tóg nỹtĩ,” he mũ. “Ãjag mỹ inh ri kén jagtar sór mũ'?” he tóg. “Ãjag mỹ ãjag jagtar jagy tag to krónh kenh ke tũ nĩ vỹ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kỹ ag tóg ti mỹ: “hỹ, ke jé ẽg tóg ke mũ,” he mũ. Hã ra Jesus tóg ag mỹ: “hỹ, jagtar jé ãjag tóg ke mũ, inh ri kén,” he mũ. “Vẽsỹrénh jé ãjag tóg ke mũ, inh ri kén,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","“Hã ra isũ tũ vẽ, sỹ ãjag mỹ: hej, he ti,” he tóg. “Ha inh pẽgja tá nĩ, henh ke tũ sóg nĩ,” he tóg. “Ha inh jakãnh tá nĩ, henh ke tũ sóg nĩ gé,” he tóg. “Isũ tũ vẽ. Ũ tỹ inh rã nỹtĩnh ke ẽn ag tỹ inh rã nỹtĩnh ke vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hã ra ũ tỹ 10 (ke) ag tóg mẽg mũ, kỹ ag tóg ag to jũ mũ, João mré Tiago to. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kỹ Jesus tóg ag jé prẽr kãn mũ, kỹ tóg ag mỹ kãmén mũ. “Fóg ag pã'i ag jykre ki kanhró ãjag tóg nỹtĩ,” he tóg. “Vẽnh kar jẽgnẽg ag tóg tĩ, kỹ ag mág ag tóg vẽnh kar mỹ: kemnĩ, ke tũg nĩ, he tĩ, vĩ tar han kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Ag ri ke han tũg nĩ. Ãjag mỹ tỹ ũn mág nỹtĩ sór mũ'? Kỹ tỹ jagnẽ camarada ri ke nỹtĩmnĩ, jagnẽ tũ ki rĩr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ãjag mỹ tỹ pã'i nỹtĩ sór mũ'? Kỹ jagnẽ krẽm ke nỹtĩmnĩ, tỹ ũn kãsir nỹtĩmnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hã kỹ sóg camarada tũ nĩ gé,” he tóg. “Sỹ tỹ camarada nĩ jé sóg kãtĩg, sỹ ãjag ki rĩr jé. Tỹ sóg ẽprã ke fi kósin nĩ. Hã kỹ sóg vẽnh kar jagfy ter ke mũ, sỹ ag krenkren han jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kejẽn ag tóg ẽmã tỹ Jericó tá junjun mũ. Ag tỹ Jerusalém ra mũ vẽ. Kar kỹ tóg Jericó ki kutẽ mũ gé, Jesus ti. Ti mré mũ tĩ ag tóg ti mré mũ mũ, vẽnh e kar ag ke gé. Hã ra Bartimeu tóg ẽpry kri nĩ nĩ. Kyvó ti nĩ, hã kỹ tóg ẽmĩn fyr kri nĩ kỹ: “inh mỹ nén ũ nĩm,” he nĩgtĩ, Timeu kósin tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ẽn tóg Jesus tỹ ẽpry jagma tĩg mẽg mũ sir, Nazaré tá Jesus ti. Kỹ tóg prẽr mũ sir. “!..Jesus'..!” he tóg. “!..Davi kósin'..! !..IJagãgtãn ra..!” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hã ra ag tóg ti to jũgjũ mũ. “Mẽ kã nĩ nĩ,” he ag tóg ti mỹ. Hã ra tóg prẽr mãn', prẽr mãn', he mũ. “!..Davi kósin'..!” he tóg. “!..Ijagãgtãn ra..!” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kỹ Jesus tóg ti to krỹg he mũ. Kỹ tóg ti jé prẽr' he mũ sir. Kỹ ag tóg ũn kyvó ẽn jé prẽr mũ sir. “Ã fe tỹ há' hé, jẽg ra, ã jé prẽr tóg mũ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kỹ tóg ã palitó fón kỹ jẽgnẽ mũ sir, Jesus to tóg tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kỹ Jesus tóg ti mỹ: “inh ã tỹ hẽ ri kenh ke?” he mũ. Kỹ ũn kyvó tóg: “Senhor,” he mũ. “Sỹ venh há tóg tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kỹ Jesus tóg ti mỹ: “hej,” he mũ. “Ã tỹ há' henh ke nẽ ha,” he tóg. “Ã tỹ inh ki rã kỹ ã há' henh ke mũ,” he tóg. Kỹ tóg vẽsỹmér ẽvãnh há' he mũ sir, kỹ tóg ti nón tĩ mũ sir, ẽpry jagma. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Vãhã ag tóg cidade tỹ Jerusalém kakó tá nỹtĩ. Kỹ ag tóg ẽmã tỹ Betânia tá junjun vén mũ, ẽmã tỹ Betfagé tá, krĩ tỹ Oliveiras tá ke gé. Kỹ Jesus tóg ã mré mũ tĩ régre ag jẽgnẽg mũ, ag tỹ ẽmã ẽn ra mũ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ha ẽmã ẽn ra mũjẽg,” he tóg, “ẽg jo ẽmã nĩ ẽn ra. Ãjag tỹ tá jun kỹ ãjag tóg burrica fi krẽ venh ke mũ. Se kỹ tóg jẽ,” he tóg. “Ũ vỹ ver ti kri nĩ ja tũ nĩ,” he tóg. “Ti kavãn kỹ ti pére kãmũmnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Hẽn ri ke mũn ag tóg ãjag mỹ: ãjag tỹ ne jé ti kyvãn nẽ? henh mũ. Kỹ ag mỹ: ẽg Senhor tóg ti ve sĩ han sór mũ, hemnĩ. Kãnhmar tóg ti jẽnẽ mãn mũ, hemnĩ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kỹ ag tóg mũ mũ sir. Burrica krẽ vég ag tóg mũ, jãnkã rã tóg se kỹ jẽ, ẽmĩn kri. Kỹ ag tóg ti kavãg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Kỹ ag tóg ag mỹ ke mũ. “Ãjag tỹ ne jé burrica sĩ kyvãn nẽ?” he ag tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kỹ ag tóg Jesus tỹ ãjag mỹ nén tó ja ẽn ti tó mũ, kỹ ag tóg: “ha ma mũjẽg ge,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kỹ ag tóg burrica krẽ ma mũ mũ sir, Jesus to. Ãjag kur tỹ ag tóg ti kri kugjén mũ sir, jumento sĩ ẽn kri, kỹ tóg kri nĩ mũ sir, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kỹ vẽnh kar tóg ãjag kur kugjén mũ sir, ẽpry kri, jo ũ ag tóg ka féj krég mũ gé, ẽpỹ tá, ti jo vãvãm jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kỹ ũ ag tóg ti jãmĩ mũ mũ, jo ũ ag tóg ti nón mũ mũ. Ẽn ag tóg prẽnprẽr mũ sir. “!..Viva..!” he ag tóg, “!..pã'i vỹ ẽg tá jun, ẽg Senhor mág tỹ ti jẽnẽn kỹ..! ");
INSERT INTO kgpNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","!..Sér tãvĩ tóg tĩ..! !..Ẽg pã'i vẽ mỹr, ẽg jóg'jóg tỹ Davi ri kén..! !..Topẽ tá tóg kãtĩg, ũ tỹ kynhmỹ nĩ ẽn tá, viva..!” he ag tóg mũ, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kỹ tóg Jerusalém ra rã mũ sir, Jesus ti. Topẽ jo ĩn ra tóg rã mũ sir. Nén kar ki ẽvãnh kar tóg Betânia ra tĩg mãn mũ, ũ tỹ 12 (ke) ag mré, rãké ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tỹ vaj kỹ, ag tỹ Betânia tá kãmũ kỹ tóg kókĩr mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hã ra tóg ka tỹ figueira féj vég mũ sir, tãtá. Kỹ tóg to tĩ mũ sir, ti kanẽ ko jé. Tá jun kỹ tóg vég mũ, hã ra tóg féj tãvĩ jé. Ti kanẽn ke pétẽm tũ tóg nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kỹ tóg ka tỹ figueira mỹ: “ũ tóg ã kanẽ ko mãn ke tũ nĩ ha,” he mũ. Hã ra ti mré mũ tĩ ag tóg ti vĩ mẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kỹ ag tóg mũ mãn kỹ Jerusalém tá junjun mũ sir. Topẽ jo ĩn ra tóg rã mũ sir, Jesus ti, kỹ tóg tá ag pan kãn mũ sir, nén ũ vender he tĩ ag, nén ũ comprar he tĩ ag ke gé. Topẽ jo ĩn krẽm ag tóg negociar he tĩ, jãnkamy trocar he tĩ ag ke gé. Ag mesa tỹ tóg vyryn ke mũ, Jesus ti. Sórãg vender he tĩ ag nĩgnĩ jafã tỹ tóg vyryn ke mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kỹ tóg ag tỹ Topẽ jo ĩn fĩn nén gé mũ kamẽg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kỹ tóg ag kanhrãn kỹ ag mỹ: “Topẽ vĩ rá to jykrén nĩ,” he mũ. “Inh ĩn jiji vỹ: nação kar mỹ Topẽ mré vĩ jafã, he mũ, he tóg, Topẽ vĩ rá ki,” he tóg, Jesus ti. “Hã ra ãjag tóg Topẽ mré vĩ jafã tag krẽm nén kar pigju(g) mũgtĩ, kỹ tóg bandido ag jamã ri ke nĩ,” he tóg. Ag pan kỹ tóg ke mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hã ra Topẽ tũ ki rĩr tĩ to pã'i ag vỹ Jesus vĩ mẽg mũ, Topẽ vĩ to professor ag ke gé. Kỹ ag tóg: “ẽg hỹn ti tỹ hẽn ri kenh ke mũ'?” he mũ, “ẽg tỹ ti tỹ tũ' he jé?” he ag tóg mũ. Hã ra ag tóg ti kamẽg mũ. Vẽnh kar mỹ tóg há tĩ, ti tỹ ag kanhrãn kỹ. Hã kỹ ag tóg ti vóg tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kutyg kỹ ag tóg cidade mág ki pa mãn mũ sir, Jesus ti, ti mré mũ tĩ ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tỹ vaj kỹ ag tóg cidade ra mũ mãn mũ sir. Mũ kỹ ag tóg sir ka tỹ figueira ẽn vég mũ, hã ra tóg tóg ja nĩ, ti jãre mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kỹ Pedro tóg Jesus vĩ ki jykrén kỹ ti mỹ: “ha vé, Senhor,” he mũ. “Ã vĩ ja ẽn hã vẽ,” he tóg. “Ã tỹ ka to vĩ kónãn ẽn vỹ tóg ja nĩ, ka tỹ figueira ẽn ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kỹ Jesus tóg ag mỹ: “Topẽ ki ge pẽ han nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Sỹ ke há vẽ, hã kỹ sóg tó mũ: kejẽn ãjag tóg krĩ tag ti mỹ: ha goj nig ki kutẽ, henh ke mũ. Kỹ tóg ki kutẽnh mũ, pãnónh ti, ãjag tỹ ãjag fe tỹ: ti mỹ ki kutẽnh mũ vỹ? he tũ nĩn kỹ,” he tóg. “Inh vĩ han jé tóg ke mũ, pãnónh ti, hemnĩ, kỹ tóg kutẽnh ke mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“Hã kỹ sóg ãjag mỹ ke mũ,” he tóg. “Ãjag tỹ Topẽ mỹ nén ũ to vĩ kỹ to: han jé tóg ke mũ, Topẽ ti, hemnĩ, kỹ ãjag tóg venh ke mũ sir, ãjag tỹ ti mỹ nén ũ to vĩ mũ ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Ãjag tỹ kejẽn Topẽ mré vĩ jẽ ra ũ tỹ ãjag to jũ mũ ẽn tỹ ti mỹ vẽnh pãte fón nĩ,” he tóg. “Ãjag tỹ gen kỹ tóg ãjag mỹ vẽnh pãte fón ke mũ gé, ẽg jóg mág ti,” he tóg. “Ãjag tỹ ti vĩ mranh mũ ra tóg vẽnh kato ãjag mỹ vẽnh pãte fón ke mũ, ũ tỹ kanhkã tá nĩ ti, ãjag tỹ ãjag mré ke ag mỹ vẽnh pãte fón kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Ãjag tỹ hã ra ag mỹ vẽnh pãte fón tũ nĩn kỹ ẽg jóg mág vỹ vẽnh kato ãjag mỹ vẽnh pãte fón ke tũ nĩ gé, ũ tỹ kanhkã tá nĩ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kỹ ag tóg mũ mãn kỹ Jerusalém tá junjun mãn mũ sir. Topẽ jo ĩn tá tóg ẽvãnh tĩ mũ, Jesus ti. Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag tóg ti venh kãmũ mũ, Topẽ vĩ to professor ag ke gé, kófa ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Ũ nỹ ã mỹ: tag han nĩ, hé?” he ag tóg, ti mỹ. “Ũ nỹ ã jẽnẽ?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Kỹ Jesus tóg ag mỹ: “ãjag ki sóg jẽmẽnh ke mũ gé, vẽnh kato,” he mũ. “Ãjag tỹ inh mỹ tó há han kỹ sóg ãjag mỹ ũ tỹ inh jẽnẽg mũ tónh ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“João vỹ ag kygpég tĩ ja nĩgtĩ. Ti mỹ kanhkã tá vẽnh jykre han, ãjag mỹ, ẽprã ke jykre vó? Ũ nỹ ti jẽnẽ?” he tóg ag mỹ, Jesus ti. “Inh mỹ tó,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kỹ ag tóg jagnẽ mré to jykrén mũ. “Ẽg tỹ ti mỹ: Topẽ tỹ ti jẽnẽ ja vẽ, hen kỹ tóg ẽg mỹ: ãjag tỹ ne jé ti vĩ kri fig tũ ja nĩ nẽ? henh ke mũ,” he ag tóg jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Ẽg tỹ hã ra ti mỹ: ẽprã ke jykre ja vẽ, hen kỹ tóg vẽnhmỹ nỹ gé,” he ag tóg, ag tỹ vẽnh kar kamẽg kỹ. Vẽnh kar tóg João to: “Topẽ vĩ tó tĩ pẽ vẽ,” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hã kỹ ag tóg Jesus mỹ: “ẽg pi(jé) ki kanhró nỹtĩ',” he mũ. Ón kỹ ag tóg ke mũ. Kỹ Jesus tóg ag mỹ: “kỹ sóg ãjag mỹ tónh ke tũ nĩ gé, ũ tỹ inh jẽnẽg mũ ti,” he mũ. Ã kato tẽ mũ ag mỹ tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kỹ Jesus tóg ag kanhrãn kỹ (tóg) ag mỹ comparação ũ han mũ sir, kỹ tóg: “kejẽn ũ tóg nĩgtĩ,” he mũ. “Nén kanẽ tỹ uva krãn ja tóg nĩgtĩ,” he tóg. “Pénĩn tóg rón ja nĩ, kãki tóg kũm ja nĩgtĩ, uva jẽgmĩ jafã han jé. Ki tóg pãjó han ja nĩ gé, kỹ tóg ũ tỹ ki rĩr tĩ ag mỹ ré kỹ tĩg ja nĩ, ga ũ ra. Ag mré tóg jykrén ja nĩ, ag tỹ ti mré ẽkré ẽn kanẽ vẽnh kãpãm jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Ti tỹ kejẽn kanẽn kỹ tóg ag mỹ ã camarada ũ jẽnẽg mũ, ti tũ ki rĩr tĩ ag mỹ, ag tỹ ti mỹ vẽnh kãpãm jé, uva ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hã ra ag tóg ti kãgmĩg mũ sir, ti mrãnmrãn ag tóg mũ sir, kỹ ag tóg ti mỹ: “ha tĩg,” he mũ sir, ti mỹ nén ũ nĩm mẽ kã. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kỹ tóg ag mỹ ã camarada ũ jẽnẽ mãn mũ gé sir, kỹ ag tóg ti krĩ ki tãnh mũ sir, ti to é he ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kỹ tóg ag mỹ ũ jẽnẽ mãn mũ gé sir, hã ra ag tóg ti tén mũ gé sir. Ti camarada kar to ag tóg jũ mũ, ũ mrãnmrãn ag tóg, ũ tén ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kỹ hã ra ũ tóg kén mũ, hã ra ti kósin vẽ, ti fe pẽ vẽ hã ra. Kỹ tóg vãhã ag mỹ ti jẽnẽg mũ sir. “Hẽn ri ke mũn ag inh kósin kamẽg mũ,” he tóg, hã kỹ tóg ti jẽnẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ti tỹ tá jun kỹ ag tóg ti to jykrén mũ, jagnẽ mré. “Kejẽn ẽkré kar vỹ tỹ ti tũ nĩnh mũ, ha vemnĩ,” he ag tóg ti to. “Mũ nỹ, ti tén jé, ti tũ tag tỹ tỹ ẽg tũ nỹnh jé,” he ag tóg, jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kỹ ag tóg ti kãgmĩ kỹ ti tén mũ sir, ró mãtá ag tóg ti fón mũ sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Kỹ ẽkré tỹ tũn mũ ẽn hẽ ri kenh ke mũ?” he tóg. “Jun jé tóg ke mũ, ã camarada ag kãgtén jé. Kỹ tóg ẽkré ki rĩr tĩ ũ ag mỹ finh ke mũ, ti tũ ti,” he tóg. Jesus ti, ag mỹ comparação han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kỹ tóg ag mỹ: “Topẽ vĩ rá tag to jykrén nĩ, ha mẽ,” he mũ. “Pó tỹ ĩn han jafã fón ag tóg, pó tỹ ĩn han tĩ ag. Ag mỹ tóg kórég ja nĩ, pó ẽn ti. Hã ra Topẽ tóg po ẽn hã tỹ ĩn nũna han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ẽg Senhor mág tỹ há vẽ, hã kỹ tóg ẽg mỹ e tĩ, ẽg tỹ ven kỹ, he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki,” he tóg ag mỹ, Jesus ti. Ti tỹ ã kato vãsãnsãn mũ ag mỹ vẽnh kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kỹ ag tóg ki kanhró nỹtĩ, ti tỹ ag kato vĩ mũ ti. Hã kỹ ag tóg ti se sór mũ, hã ra ag tóg vẽnh e ẽn kamẽg mũ, kỹ ag tóg ti ség tũ nĩ ha. Kỹ ag tóg sir mũ mũ, ti ré kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Hã ra ag tóg ti to ũ ag jẽgnẽg mũ sir, Fariseu ũ ag, Herodes mré ke ũ ag ke gé, ag tỹ ti vĩ to ti se jé, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ag tỹ ti tá junjun kỹ ag tóg ti mỹ: “Senhor,” he mũ. “Ã jykre kuryj nĩn ki kanhró ẽg tóg nỹtĩ,” he ag tóg, ón kỹ. “Vẽnh jykre pir hã han ã tóg tĩ, vẽnh kar mỹ. Kỹ ag ve tóg ã mỹ tỹ nén ũ tũ nĩ. Hã kỹ ã tóg Topẽ jamĩn to, Topẽ japry to ã tóg ẽg kanhrãn há han tĩ,” he ag tóg, ón kỹ, Jesus mỹ. “Mỹ há nỹ', ẽg tỹ governo mỹ jãnkamy nĩm ke ti', imposto kajãm ke ti'? ");
INSERT INTO kgpNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ẽg mỹ hỹn nĩm mũ', vó mỹ vó?” he ag tóg. Hã ra Jesus tóg ki kanhró nĩ, ag jykre régre nỹtĩn ki. Kỹ tóg ag mỹ: “ãjag ne tóg ón kỹ inh ki jẽmẽ sór mũ',” he mũ. “Inh mỹ jãnkamy jun, sỹ ve jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kỹ ag tóg ti mỹ ũ jun mũ sir. Kỹ tóg: “ũ jiji nỹ kã nĩ?” he mũ. “Ũ kãggrá nỹ kã nĩ?” he tóg. Kỹ ag tóg ti mỹ: “pã'i mág tỹ imperador kãggrá vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kỹ Jesus tóg ag mỹ: “kỹ pã'i mág mỹ ti tũ nĩmnĩ, hã ra Topẽ mỹ ti tũ nĩmnĩ gé,” he mũ. Kỹ ti vĩ tóg ag mỹ e tĩ. Ag tỹ nén ũ to ti se sór mũ vég tũ ag tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kỹ Saduceu ag tóg ti tá junjun mũ gé, ti ki jẽmẽ jé. Hã ra Saduceu ag tóg: ẽg ter ja tá ẽg vỹn kenh ke tũ nĩ,” he tĩ. Kỹ ag tóg Jesus tá jun kỹ ti mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Senhor,” he mũ gé. “Moisés tóg ẽg mỹ tag tó ja nĩ, ẽg tỹ tỹ jykre nỹtĩ jé,” he ag tóg. “Ẽg mỹ tóg: ã régre tỹ ã krẽ tũ ra ter kỹ, ã tỹ ti prũ fi tỹ prũg ke vẽ, he mũ. Ã tỹ ã régre mỹ ã krẽ han ke vẽ, fi ki, he ja tóg nĩ, Moisés ti,” he ag tóg, Jesus mỹ, Saduceu ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Kỹ ũ tỹ jagnẽ mré pafa ja tỹ 7 (ke) ag vỹ nỹtĩ ja nĩgtĩ,” he ag tóg. “Ag kãke tóg prũg mũ, hã ra tóg ã kósin tũ ra ter mũ sir,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","“Kỹ ti jãvy tóg fi tỹ prũg mũ, hã ra tóg ã kósin tũ ra ter mũ gé sir. Kỹ ti jãvy ũ vỹ fi tỹ prũg mũ gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","“Hã ra ag kar tóg fi kósin tũ ra kãgter kãn mũ sir, ag kãke ti nón, ũ tỹ 7 (ke) ẽn ag. Kejẽn fi tóg vãhã ter mũ gé sir,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Kỹ fag kãgter ja tá vỹnvỹn ke kỹ fi hỹn mén tỹ 7 (ke) nĩnh mũ vẽ. Ag kar vỹ fi tỹ prũg ja nỹtĩgtĩ. Hã kỹ tóg vẽnhmỹ nỹ, ag tỹ: rĩr mãn jé ẽg tóg ke mũ, hen kỹ,” he ag tóg, Jesus ti mỹ, Saduceu ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Hã ra Jesus tóg ag mỹ: “ãjag pi(jé) Topẽ vĩ tỹ rán kỹ nĩ ki kanhró nỹtĩ',” he mũ, “Topẽ jykre ki kagtĩg ãjag nỹtĩ,” he tóg. “Hã kỹ ãjag tóg kygnẽ ja nĩ,” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","“Ẽg tỹ ẽg ter ja tá vỹn ke kỹ ẽg prũg ke tũ nĩ, kỹ ẽg mén ke tũ nĩ gé,” he tóg. “Topẽ tỹ jẽgnẽ jafã ri ke ẽg nỹtĩ, kanhkã tá,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Topẽ vĩ ũ to jykrén nĩ, ti tỹ ẽg tỹ ẽg ter ja tá vỹn ke kãmén kỹ. Moisés tỹ rán ki tag tóg rán kỹ nĩ, Topẽ tỹ Moisés mỹ nén tó ja tag ti, vãnh pũr kãmén jan ki,” he tóg. “Topẽ tóg ti mỹ: Abraão vỹ iso: Topẽ, he tĩ, he ja nĩ, Isaque ke gé, Jacó ke gé, he ja tóg nĩ, Topẽ ti. Kãgter ag huri, Abraão, Isaque, Jacó. Hã ra Topẽ tóg: tỹ inh ag Topẽ nĩ, he ja nĩ, ag ter kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Hã kỹ ag tóg rĩnrĩr nỹtĩ mỹr, Topẽ tỹ ũn rĩnrĩr nỹtĩ ag hã kri ke nĩn kỹ,” he tóg, Jesus ti. “Hã kỹ ãjag tóg kygnẽ tãvĩn mũ,” he tóg, Jesus ti, Saduceu ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Hã ra Topẽ vĩ to professor ũ tóg tá jun mũ gé sir. Kỹ tóg ag tỹ jagnẽ mré vĩ mẽg mũ, Jesus tỹ Saduceu ag mỹ tó há han ja ẽn ti. Hã kỹ tóg: “Topẽ tỹ ẽg jyvẽn tỹ hẽ nỹ hỹn ti tỹ ẽg jyvẽn kar kãfór nỹnh mũ'?” he mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kỹ Jesus tóg ti mỹ: “ũ tỹ kãfór nỹn hã vẽ, hã mẽ,” he mũ. “Ha mẽ, povo tỹ Israel,” he tóg mũ. “Ẽg pã'i vỹ tỹ Topẽ nĩ, ẽg pã'i vỹ tỹ ũn pir nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","“Topẽ to, ẽg jóg mág to há tãvĩ nỹtĩmnĩ,” he tóg, “ti ki ge há han nĩ, ti to jykre pir nỹtĩmnĩ, krĩ pir, ti to tar nỹtĩmnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","“Kỹ ti tỹ ẽg jyvẽn ũ tóg hã ri ke nĩ gé, hã vỹ: ãjag régre ki rĩr nỹtĩmnĩ, ãjag tỹ vẽnh ki rĩr há han ri ke, he mũ,” he tóg. “Ti tỹ ẽg jyvẽn ũ pi(jé) tag kãfór nĩ',” he tóg, Jesus ti, Topẽ vĩ to professor ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kỹ Topẽ vĩ to professor ẽn tóg ti mỹ: “ke tóg tĩ,” he mũ. “Ã tỹ ke há vẽ. Pir ti nĩ, Topẽ ti, ũ pi(jé) ti ri ke nĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","“Ẽg jé ti to fe há nỹtĩgtĩ, ẽg jé ti to krĩ há nỹtĩgtĩ gé, jykre pir ke gé. Ẽg jé ti to tar nỹtĩ gé. Ẽg jé ẽg régre ki rĩr nỹtĩ gé, ẽg tỹ vẽnh ki rĩr há han ri ke. Hã vỹ tóg nén kar kãfór nĩ,” he tóg. “Ẽg tỹ Topẽ mỹ nén ũ pũn kãfór tóg nĩ, ẽg tỹ ti to há nỹtĩ ẽn ti, ẽg tỹ ti mỹ nén ũ tãnh kãfór tóg nĩ gé,” he tóg, Topẽ vĩ to professor ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kỹ Jesus tóg ti tỹ tó há nĩ ve kỹ (tóg) ti mỹ: “nén ũ sĩ tóg tũ nĩ ver,” he mũ, “ã tỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke jé,” he tóg. Kar kỹ ũ tóg Jesus ki jẽmẽ mãn tũ nĩ sir. Ti kamẽg ag tóg mũ sir, hã kỹ ag tóg ti ki jẽmẽ mãn tũ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kỹ Jesus tóg Topẽ jo ĩn krẽm ag kanhrãn jé ag ki jẽmẽg mũ. “Topẽ vĩ to professor ag tỹ ne jé: Cristo vỹ tỹ Davi kósin nĩ, he nẽ?” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Davi vỹ Cristo tó ja nĩ, Topẽ kuprĩg tỹ ti krĩn kỹ, kỹ tóg: ẽg jóg mág tỹ Topẽ vỹ inh Senhor mỹ tag tó ja nĩ, hã kỹ tóg: “nĩ ra ver, inh pẽgja tá,” he ja nĩ. “Sỹ ã kato vãsãnsãn mũ ag tỹ ã krẽm vin ke vẽ, kỹ ag sigse vẽ sir. Tag jãvãnh nĩ ver,” he ja ti nĩ, Topẽ ti, inh Senhor mỹ, he ja tóg nĩ, Davi ti,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Hã kỹ Davi tóg Cristo to: inh Senhor vẽ, he tĩ. Ti tỹ tỹ ti kósin nĩ ra ti kósin mỹ tỹ ti kri ke nĩnh mũ vẽ?” he tóg, Jesus ti. Hã ra ag tóg ti mỹ tó tũg. Ag tỹ ne tónh ke tóg tũ tĩ, ti kato vãsãnsãn mũ ag mỹ. Hã ra vẽnh kar mỹ ti vĩ tag tóg há nỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kỹ Jesus tóg ag kanhrãn kỹ: “ón kỹ Topẽ vĩ to professor ag kamẽg nĩ,” he mũ. “Kur téj rĩnh ka(mẽ) ag nỹtĩ,” he tóg. “Kỹ vẽnh kar tỹ ag mỹ: ã mỹ há? he kỹ tóg ag mỹ sér tĩ, ag tỹ cidade kuju kãmĩ mũn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","“Ẽg tỹ vẽnh kanhrãn jafã krẽm ag tóg vẽnh kãpãm kỹ nỹtĩgtĩ, festa ki ag tóg jẽn vén tĩ, ag tỹ tỹ pã'i nỹtĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Hã ra ag tóg ũn mén ter ja fag tũ mãn kãn tĩ. Fag tũ mãn kãn kỹ ag tóg ón kỹ Topẽ mré vĩ mág han mũgtĩ, ẽg tỹ ag to: ũn há vỹ tỹ ag nỹtĩ, he jé,” he tóg. “Hã to ag vẽsỹrénh mág tãvĩ han ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kỹ Jesus tóg kejẽn Topẽ mỹ jãnkamy vin jafã kato nĩ mũ. Kỹ tóg ag tỹ kãki nén vin mũ vég mũ sir. Ũn rico ag tóg jãnkamy mág tỹ kãki vin mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kỹ ũn jagtar fi tá jun mũ gé, ũn mén ter ja fi. Hã ra fi tóg jãnkamy kãsir régre hã vin mũ sir, hã vỹ: 1 centavo, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kỹ Jesus tóg ã mré mũ tĩ ag jé prẽr mũ sir, kỹ tóg ag mỹ: “ve ra ha,” he mũ. “Ũn rico tỹ vin kãfór han fi tóg, fi tũ sĩ (hã) ra. Tỹ nén ũ tũ fi tóg nĩ, fi mén vỹ hur ter. ");
INSERT INTO kgpNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kỹ fi tóg ã tũ vin kãn ja nĩ, fi jẽn mré hã. Jãvo ũn rico ag vỹ ãjag tũ ke hã tỹ Topẽ mỹ vin mág tĩ. Hã ki fi tóg ag tỹ nĩm kãfór han, fi tỹ nĩm sĩ pẽ han mũ ra. Ki hã sóg tó mũ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kỹ Jesus tóg Topẽ jo ĩn tá kãkutẽ mũ sir. Re tá ti mré tĩ ũ tóg ti mỹ: “ve ra ha, Senhor,” he mũ. “Pó sĩnvĩ tỹ tóg há nỹtĩ, kỹ tóg sĩ(nvĩ) tãvĩ nỹtĩ, ĩn ti,” he tóg, Topẽ jo ĩn to. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Hã ra Jesus tóg ti mỹ: “ã mỹ ĩn mág tag ti vigvég mũ'?” he mũ. “Kejẽn ũ pó tỹ jagnẽ kafãn mãn ke tũ nĩ,” he tóg. “Ag ránhráj kãn ke vẽ,” he tóg Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kar kỹ Jesus tóg krĩ tỹ Oliveiras ra tĩg kỹ tá nĩ nĩ sir, Topẽ jo ĩn kakãm. Kỹ ag tóg ag pin kỹ ti mỹ ke mũ, Pedro, Tiago, João, André ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ẽg mỹ ti kurã ti tó,” he ag tóg ti mỹ. “Ẽg ne ve kỹ ti kurã ki kanhró nỹtĩnh mũ? Kurã tỹ hẽ ki ẽg hỹn nén kar tag venh ke mũ?” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kỹ Jesus tóg ag mỹ kãmén mũ sir. “Ker ũ ãjag lograr hé hẽ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","“Cristo vỹ tỹ inh nĩ,” he jé ag tóg ke mũ, ijiji tó kỹ. Ũ tỹ hẽn ri ke ag tóg tag tónh mũ, kỹ ũ tỹ hẽn ri ke ag tóg ag vĩ kri nĩm ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Vẽnh génh to vẽme mẽ jé ãjag tóg ke mũ, tag ki vẽnh génh ke to, kuvar há tá vẽnh génh to ke gé. To jũrũn ke tũg nĩ hã ra. Vẽnh génh enh ke vẽ. Hã ra kurã tỹ ẽgno to hã ke vẽ ver,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","“Nação ag tỹ jagnẽ kato tẽgtẽnh ke vẽ. Pã'i krẽm ke ag tỹ pã'i ũ krẽm ke ag to jũnh ke vẽ gé. Kỹ ga tỹ ragrag ke tỹ hẽn ri ke han ke vẽ gé, ẽmã tỹ hẽn ri ke ki. Vẽjẽn tỹ tũ' henh ke vẽ gé. Hã ra ãjag jagãgtar ke vẽnh ven vén vẽ ver,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ãjag kanẽ nĩm nĩ,” he tóg. “Ãjag jyvẽn tar han jé ag tóg ke mũ, pã'i ag, vẽnh kanhrãn jafã krẽm. Ãjag mrãnmrãn jé ag tóg ke mũ. Ãjag jé prẽr jé ag tóg ke mũ, pã'i mág tỹ ãjag ve jé, pã'i mág kar ti, isugrĩn, ãjag tỹ pã'i ag mỹ inh vĩ tugtó jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","“Kỹ inh kãtĩg ke to hã povo kar vỹ inh vĩ sér mẽnh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Ag tỹ vãhã sir ãjag sigse kỹ, ãjag gé kãmũ jé, kỹ ãjag tỹ nén tónh ke mũ to jykrén tũg nĩ, kã jatu' hemnĩ. Ag tỹ ãjag ki jẽmẽn kỹ ãjag tóg tónh ke mũ, Topẽ kuprĩg tỹ ãjag nĩgrẽg ki vĩ mũ ẽn ti,” he tóg. “Ãjag tỹ tó tũ vẽ sir, ti tỹ tó vẽ sir,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ũ vỹ tóg ã régre senh ke mũ, ti ter jé, ẽn kã,” he tóg. “Kỹ ũ panh tóg ã kósin senh ke mũ gé, ti ter jé,” he tóg. “Kỹ ũ krẽ ẽn tóg ã han mũ fag sigsenh ke mũ gé, fag kãgtén jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","“Vẽnh kar vỹ tóg ãjag to vĩ kónãn ke mũ gé, inh jiji tugrĩn,” he tóg. “Hã ra ũ tỹ isovãnh ke tũ (pẽ) ẽn kren ke vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kỹ Jesus tóg ag mỹ: “kejẽn ãjag tóg vãhã ãjag tỹ nén ũ kamẽg tĩ ẽn venh ke mũ,” he mũ, “ẽg kavénh mũ ẽn ti,” he tóg. “Topẽ vĩ tó tĩ tỹ Daniel vỹ ti tó ja nĩgtĩ. Ti jẽnh ke tũ tá tóg jẽnh mũ,” he tóg. Ũ tỹ to ke mũ ẽn jé ki kanhró nĩ. “Kỹ Judéia ki ke kar ag jé vẽnh pigjunh mũjẽg, pãnónh ra, fag mré hã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Ũ tỹ re tá nĩ ẽn jé kãra rã tũg nĩ, ti ĩn ki, ti tũ mãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kỹ ũ tỹ ã japỹ tá jẽ ẽn jé vỹn ke tũg nĩ gé, ti kur mãn jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Ũn kufy fag tỹ vẽsỹrénh ke vẽ, kurã ẽn kã, ũ tỹ gĩr pygfãm mũ fag ke gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Topẽ mré vĩmnĩ, ti tỹ kusa kã vẽnh ven tũ nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Vẽsỹrénh tỹ ge ve ja tũ ẽg nỹtĩ, Topẽ tỹ ẽg mundo han jan ki. Kỹ ẽg ge venh ke tũ nĩ gé, kar kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Ẽg tỹ kurã ki vẽsỹrénh ke mũ ẽn vỹ e nỹtĩnh mũ vẽ, hã ra tóg térem kỹ nỹtĩ nĩ, Topẽ tỹ ũn kuprẽg ja ẽn ag tugrĩn. Ti tỹ térem tũ nĩ (mũ) ra ũ vỹ kren ke tũ nĩ vẽ, ag vẽsỹrénh ẽn to,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Kỹ ũ tỹ ãjag mỹ: ha vé, Cristo vỹ tag kã jẽ nĩ, he mũ ra kri fig tũg nĩ, ti tỹ: tãtá ti jẽ nĩ, he mũ ra,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Ón kỹ Cristo vỹ vẽnh venven ke mũ, ón kỹ Topẽ vĩ tó tĩ ag ke gé. Ón kỹ milagre hyn han jé ag tóg ke mũ, milagre tỹ hẽn ri ke ti, ón kỹ Cristo ẽn ag. Ag tỹ vẽnh kar krĩn kónãn sór vẽ, ag tỹ kygnẽ jé, Topẽ tỹ ũn kuprẽg ja ẽn ag mré hã, hẽn ri ke mũn. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ha vé, sỹ ãjag mỹ tó kãn vẽ, ti kutẽnh ke to hã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Hã ra kurã ẽn kã, vẽsỹrénh ẽn kar kỹ rã vỹ nhyr ke mũ, kỹ kysã vỹ jẽngrẽ' he mãn ke tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kỹ krĩg vỹ vár ke mũ gé, kanhkã krẽm. Ẽg tỹ kanhkã tá nén vég tũ kar ẽn vỹ ragrag ke kãn mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kỹ vãhã vẽnh kar vỹ inh kãtére venh ke mũ sir, kanhkã góg jagma, inh jykre tar (pẽ) nĩn kỹ,” he tóg. “Tỹ sóg ẽprã ke fi kósin nĩ mỹr,” he tóg. “Inh ve vỹ kókov (pẽ) kãtĩ mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","“Kỹ sóg sỹ jẽgnẽ jafã ag mỹ: ha mũjẽg, henh ke mũ, ag tỹ sỹ ũn kuprẽg ja ag vẽnhmãn jé, ga kar tá, kanhkã fyr mĩ hã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ka tỹ figueira to ki kanhrãn nĩ, to comparação han kỹ,” he tóg. “Ti pẽ tánh kỹ, ti féj tãg han kỹ tóg kakó tĩ sir, ẽkré tygtánh kurã ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ri ke ti nĩ, ãjag tỹ inh kãtĩg mãn ke kurã ki kanhró nỹtĩnh ke mũ ti. Ãjag tỹ sỹ ãjag mỹ nén tó mũ tag ve kỹ tóg kakó tãvĩ tĩ ha, inh kãtĩg mãn ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Sỹ ke há vẽ, hã kỹ sóg tag tó mũ, ha mẽ. Ũri ũn rĩnrĩr mũ ag tỹ nén kar ẽn venh ke vẽ, ag kãgter ke to hã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","“Kanhkã vỹ tũ' henh ke mũ, ga ti ke gé. Jãvo inh vĩ vỹ tũ' henh ke tũ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hã ra ũ pi(jé) isỹ kurã ki kãtĩg mãn ke ki kanhró nĩ', hora ẽn ki ke gé',” he tóg. “Topẽ tỹ jẽgnẽ jafã ag pi(jé) ki kanhró nỹtĩ'. Inh pi(jé) ki kanhró nĩ gé', isỹ tỹ Topẽ kósin ra,” he tóg. “Ẽg jóg mág hã vỹ ã pin kỹ ki kanhró nĩ, kurã kã nén kutẽnh ke mũ ẽn ki,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Ãjag kanẽ vin han nĩ, vẽnh rinfig nĩ,” he tóg. “Topẽ mré vĩ, ãjag tỹ ti kurã ki kagtĩg nỹtĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ũ pasa ri ke vẽ,” he tóg. “Ã tỹ ã ĩn ki kutẽ kỹ tóg ã camarada ag mỹ: “ijo ki rĩr,” he mũ, “inh rãnhrãj ki,” he tóg. Kỹ tóg ũ tỹ jãnkã ki rĩr tĩ ẽn mỹ: “ã kanẽ nĩm han nĩ,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hã kỹ sóg ãjag mỹ: “ãjag kanẽ nĩm han nĩ,” he mũ gé,” he tóg. “Ãjag pi(jé) ti jun ke ki kanhró nỹtĩ', ĩn tãn ti',” he tóg. “Hẽn ri ke mũn tóg kutyg ke ra jun mũ, hẽn ri ke mũn tóg kuty kuju ki jun mũ, hẽn ri ke mũn tóg galo kyr mũ ra jun mũ, hẽn ri ke mũn tóg kusã ki jun mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","“Vẽnh ki ẽmẽmnĩ, nũr tũg nĩ. Ãjag tỹ ijãvãnh tũ ra sóg jun mũ, vẽsỹmér,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Vẽnh kar mỹ sóg tó mũ, sỹ ãjag mỹ tó mũ tag, hã vỹ: vẽnh ki ẽmẽmnĩ, he mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Hã ra festa tỹ Páscoa kurã kãtá kurã tãgtũ vẽ sir, pão jẽgja tũ konh ke kãtá. Kỹ Topẽ tũ ki rĩr tĩ ag tóg Jesus vatánh tá ti se sór mũ, vẽnh kar tỹ ti se vég tũ nĩ jé. Topẽ vĩ to professor mré ag tóg ti se sór mũ gé, ti tén jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hã ra ag tóg: “festa tag to mẽ jé ẽg tóg ke mũ ver,” he mũ. “Ẽg tỹ festa kã ti se kỹ vẽnh génh mág hỹn tóg kutẽnh mũ, ha vemnĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ẽn kã Jesus tóg kejẽn ẽmã tỹ Betânia tá nĩ nĩ, Simão ĩn krẽm, vẽnh kaga tỹ lepra han ja ẽn ĩn krẽm. Ti jẽg nĩ ra ũ fi tóg tá jun mũ, garrafa vyn kỹ. Pó tỹ alabastro tỹ tóg há(r) nĩ, garrafa ti. Ti ki jẽ vỹ tóg tỹ nén kar tãg nĩ, hã vỹ: nardo, he mũ. Nardo pẽ vẽ, kaja e pẽ ti nĩ, ger há ẽn ti. Garrafa ẽn mranh fi tóg mũ, kỹ fi tóg ti ki jẽ ẽn tỹ Jesus gãnh kri kugjẽg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hã ra ũ tỹ tá nỹtĩ ag kã ũ ag tóg jagnẽ mỹ: “fi tỹ ne jé nén kaja e tag kókén nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Ẽg tỹ nén ger há tag fón ke vẽ vẽ, kaja há to, jãnkamy tỹ hẽn ri ke to,” he ag tóg. “Ẽg tỹ ũn jagãgtar ag mỹ vin ke vẽ vẽ,” he ag tóg. Kỹ ag tóg fi mỹ vĩ tar han mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hã ra Jesus tóg ag mỹ: “fi mỹ vĩ tũg,” he mũ. “Ãjag tỹ ne jé fi fe kaj han nẽ?” he tóg. “Inh ki fi krov nĩ, inh jykre ki,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","“Ãjag mré sóg nĩg sĩ han mũ, jãvo ũn jagãgtar mũ ag vỹ ãjag mré nỹtĩg mág han tĩ,” he tóg. “Isĩg kar kỹ ag mỹ nĩmnĩ, ãjag tỹ ag mỹ nén nĩm ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","“Ã tỹ nén han ke mũn han fi tóg huri,” he tóg. “Inh kãn fi tóg huri, vẽnh kej tá inh fón ke to,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Ag tỹ vẽnh vĩ sér tugtó kỹ ag tóg fi tỹ nén han mũ tag ti tónh ke mũ gé, kỹ vẽnh kar vỹ fi tỹ nén han mũ tag mẽgmẽnh mũ sir, ha vemnĩ. Ki hã sóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kar kỹ Judas Iscariotes tóg tĩ mũ, Topẽ tũ ki rĩr tĩ ag ra, ag mré Jesus jẽnjẽn ke to jykrén jé. Hã ra ũ tỹ 12 (ke) ag kã ũ vẽ, Judas ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ag tỹ ti vĩ mẽ kỹ tóg ag mỹ sér tĩ sir. “Ã mỹ ẽg to jãnkamy vin mũ,” he ag tóg ti mỹ. Hã kỹ tóg: “inh hỹn hẽ ri kenh mũ, ag tỹ ti kãgmĩ jé?” he mũ, Judas ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pão jẽgja tũ konh ke kurã ve vẽ sir, cordeiro tãnh ke kurã vẽ sir, Páscoa kã. Kỹ ti mré mũ tĩ ag tóg Jesus mỹ: “ẽg hỹn hẽ tá ã mỹ carneiro sĩ tãnh mũ, ẽg tỹ kon jé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kỹ tóg ũn régre ag jẽgnẽg mũ, ti mré mũ tĩ ag. Kỹ tóg ag mỹ: “ha ẽmã mág ra mũjẽg,” he mũ. “Tá ãjag tóg ũ venh ke mũ, goj vyn kỹ jẽ ũ. Ẽn nón mũmnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","“Ti tỹ ĩn kãra rã kỹ ĩn tãn ẽn mré vĩmnĩ,” he tóg. “Ti mỹ tag tómnĩ,” he tóg. “Ẽg Senhor vỹ ã mỹ vẽnh vĩ jẽnẽg mũ, hemnĩ. Ti tỹ ã ĩn krẽm Páscoa konh há tóg tĩ, ti mré mũ tĩ ag mré, hemnĩ ti mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","“Kỹ tóg ãjag mỹ ven ke mũ, kroggrog tỹ kynhmỹ nỹ ẽn ti,” he tóg. “Éhé ti nĩ. Tá nén kar vỹ kynkar kỹ nỹtĩ. Ẽg nĩgja vỹ tá nỹtĩ gé. Tá ẽg mỹ han nĩ,” he tóg, ti mré mũ tĩ régre ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kỹ ag tóg mũ mũ sir, ẽmã mág ra, kỹ ag tóg sir vég mũ, Jesus tỹ ag mỹ nén tó ja ti. Kỹ ag tóg vẽjẽn kãn mũ sir, ag tỹ cordeiro ẽn ko jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Rã pur kar kỹ Jesus tóg ũ tỹ 12 (ke) ag mré tá jun mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ag jẽg mũ jãvo Jesus tóg ag mỹ: “ãjag kãki ũ tóg inh vatánh tá inh kato vãsãnsãn mũ ag mỹ inh ven ke mũ,” he mũ. “Inh mré jẽg mũ ũ vẽ, ki hã sóg tó mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kỹ ag tóg fe kaj' he mũ sir. Ti mỹ ag tóg: “inh mỹ vó'? Inh mỹ vó'?” he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hã ra tóg ag mỹ: “ãjag kã ũ vẽ,” he mũ. “Inh mré pão tỹ kã punpun mũ vẽ, pénky kãki,” he tóg. “Ẽn vẽ mỹr,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","“Ter jé sóg ke mũ, isỹ tỹ ẽprã ke fi kósin nĩn kỹ. Hã kỹ iser ke vỹ rán kỹ nĩ,” he tóg. “Vãsỹ sóg to rán kỹ nĩ,” he tóg. “Hã ra ũ tỹ pã'i ag mỹ inh ven ke ẽn mỹ tóg vĩ kónãn tãvĩ han ke mũ. Ti mur tũ nĩn ran há tĩ vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ag jẽg nỹtĩ ra Jesus tóg ẽmĩ mãg mũ sir, kỹ tóg Topẽ mré vĩ mũ sir, ẽmĩ to. Kỹ tóg vẽnh kã kugpãn kỹ ag mỹ vẽnh kãpãm mũ sir, ti mré mũ tĩ ag mỹ. “Inh hã vẽ,” he tóg, ẽmĩ to. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kar kỹ tóg copo vãg mũ gé sir, vinho tỹ ki jẽn kỹ. To tóg Topẽ mré vĩ mũ gé sir, kỹ tóg ũn pir mỹ ven', ven', he mũ sir. Kỹ ag tóg kãmẽ kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kỹ tóg ag mỹ: “inh kyvénh hã vẽ,” he mũ. “Vẽnh kar jagfy tóg inh ki kãkutẽnh ke mũ, inh kyvénh ti,” he tóg. “Topẽ vỹ vẽnh kar to há nĩ sór mũ, inh kyvénh tugrĩn,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Ha mẽ,” he tóg. “Inh pi(jé) vinho kron mãn ha'. Kejẽn sóg kron mãn ke mũ, Topẽ tỹ tỹ ẽg pã'i nĩ ẽn kã sóg kron mãn mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ag jẽn kar kỹ ag tóg Topẽ mỹ jãn mũ sir. Jãn kar kỹ ag tóg sir krĩ tỹ Oliveiras ra mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kỹ Jesus tóg ag mỹ: “ãjag kar vỹ inh ré kỹ mũ kãn ke mũ,” he mũ. “Hã kỹ tóg rán kỹ nĩ, hã mẽ. “Ũ tỹ carneiro ki rĩr tĩ ẽn tãnh jé sóg ke mũ, kỹ ti mẽg vỹ krig ke kãn ke mũ,” he tóg, iso, Topẽ ti, ti vĩ rá ki,” he tóg, Jesus ti. “Hã ve jé ãjag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Hã ra sóg iser kar kỹ rĩr mãn ke mũ. Ẽn kã sóg ãjag jo tĩnh ke mũ, ga tỹ Galiléia ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Kỹ Pedro tóg ti mỹ: “ag kar tỹ ã ré kỹ mũ mũ ra isóg ã ré kỹ tĩg ke tũ nĩ,” he mũ, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hã ra Jesus tóg ti mỹ: “ha vé,” he mũ. “Ũri, kuty tag kã ã tóg iso: ti ki kagtĩg sóg nĩ, he tãgtũ han ke mũ, galo kyr régre han ke to hã. Ki hã sóg tó mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hã ra Pedro tóg vĩ tar han. “Sỹ ã mré ter ke mũ ra sóg ã to: ti ki kagtĩg sóg nĩ, henh ke tũ pẽ nĩ,” he tóg, Pedro ti. Kỹ ti mré mũ tĩ ag tóg hã tó kãn mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kỹ ag tóg ka kré ra mũ mũ sir. Ka kré ẽn jijin hã vỹ: Getsêmani, he mũ. Kỹ tóg ã mré mũ tĩ ag mỹ: “nĩgnĩ ra ver, tag ki,” he mũ. “Sỹ ver Topẽ mré vẽmén ke vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kỹ tóg Pedro, Tiago, João ag mỹ: “inh mré kãmũ jẽg,” he mũ. Kỹ tóg ti mỹ e tĩ sir, jũrũn ke tóg mũ sir, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kỹ tóg ag mỹ: “inh fe kaj mág tóg tĩ,” he mũ, “kỹ inh fe kaj tóg inh mỹ tỹ iser ri ke nĩ,” he tóg. “Tag ki nỹtĩmnĩ, nũgnũr tũg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kỹ tóg tĩg sĩ han mãn kỹ mũg ke mũ, ga kri nỹ tóg mũ sir. Ã jóg mré tóg vĩ mũ sir, “isỹ hẽn ri ke mũn nén venh ke mũ ẽn vég tũ nĩ jé, hora ẽn ki,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kỹ tóg: “Aba', panh',” he mũ. “Nén kar han ki kanhró ã tóg nĩ,” he tóg. “Inh jagtar ke tag tỹ tũg' hemnĩ,” he tóg. “Hã ra isỹ ã mỹ nén to vĩ mũ tag han tũg nĩ, ã tỹ nén han ke mũ ẽn hã han nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kỹ tóg ã mré mũ tĩ ag venh tĩ mũ, hã ra ag tóg nũgnũr ja nĩ, kỹ tóg Pedro mỹ: “Simão, ã mỹ nũr'?” he mũ, “ã mỹ hora pir hã ki nũr tũ kórég?” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Nũr tũg nĩ,” he tóg. “Topẽ mré vĩmnĩ, ãjag tỹ ti vĩ mranh tũ nĩ jé, ũ tỹ ãjag kutãn mũ ra. Ãjag tỹ mranh sór tũ vẽ vẽ, hã ra ãjag tóg krój nỹtĩ, hã kỹ ãjag tóg mranh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kỹ tóg tĩg mãn mũ sir, Topẽ mỹ tó mãn jé. Ti vĩ ẽn hã tó mãn tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kỹ tóg ag tá jun mãn mũ gé sir, hã ra ag tóg nũgnũr mãn nỹtĩ, ag kanẽ krój nỹtĩn kỹ. Hã kỹ ag tỹ ti mỹ vĩnh ke ẽn tóg tũ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kỹ tóg tá jun tãgtũ han mãn mũ. Kỹ tóg ag mỹ: “ãjag ne tóg nũgnũr ja nĩ', vẽnhkán ja ãjag tóg nĩ,” he mũ. “Gen kỹ,” he tóg. “Pétẽm ti huri, hora ti,” he tóg. “Ũ tỹ Topẽ vĩ mranh tĩ ag tỹ isenh ke nẽ ha,” he tóg. “Tỹ sóg ẽprã ke fi kósin nĩ mỹr,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","“Nĩgnĩ ra, mũ jé ha. Ũ tỹ ag mỹ inh ven mũ tóg jun ke kãtĩg ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus tỹ ver tỹ vẽmén jẽ ra Judas tóg vẽsỹmér jun mũ sir. Ũ tỹ 12 (ke) ag kã ũ vẽ, Judas ti. Ti mré polícia ag tóg kãmũ mũ gé. Rógro génh kỹ ag kãmũ mũ, ka kykyv génh kỹ ke gé. Topẽ tũ ki rĩr tĩ ag pã'i ag vỹ ag jẽgnẽ, Topẽ vĩ to professor ag ke gé, kófa ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas ẽn, ũ tỹ ag mỹ Jesus ven mũ ẽn vỹ ag mỹ vẽnh jykre nĩm ja nĩ. “Sỹ ũn ki nhun ke mũ ẽn hã semnĩ. Ẽn hã pére mũmnĩ,” he ja tóg nĩ, Judas ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ã tỹ tá jun kỹ tóg vẽsỹmér Jesus to grẽn ke kỹ ti mỹ: “Senhor,” he mũ. Kỹ tóg ti ki nhun ke mũ sir, Judas ti, ón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kỹ ag tóg ti kãgmĩ kỹ ti ség mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesus mré tĩ tĩ ũ tóg rógro kunũnh kỹ polícia ũ nĩgrẽg kym mũ sir. Topẽ tũ ki rĩr tĩ to pã'i mág camarada vẽ, ti tỹ ũn nĩgrẽg kym mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kỹ Jesus tóg ag mỹ: “ãjag ne tóg rógro génh kãmũ mũ',” he mũ, “ka kykyv génh kỹ ke gé'” he tóg. “Inh pi(jé) tỹ bandido nĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","“Kurã kar ki sóg ãjag mré jẽ ja nĩgtĩ, mỹr, Topẽ jo ĩn krẽm,” he tóg. “Vẽnh kanhrãn kỹ isóg tá nĩ ja nĩgtĩ, hã ra ãjag tóg tá iség tũ nĩ vẽ mỹr,” he tóg. “Hã ra vãsỹ iso nén rán kỹ nĩ ẽn ki kenh ke hỹn,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kỹ ti mré mũ tĩ ag tóg ti ré kỹ pétẽ kãn mũ, vẽnh pigju jé, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hã ra kyrũ ũ tóg ti nón tĩ mũ. Vẽnh kãtor tãvĩ ti nĩ. Ti kãgmĩg ag tóg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Hã ra tóg kamẽg kỹ ã kur ré kỹ vẽnhvãg mũ, ti kator ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kỹ ag tóg Jesus pére mũ mũ, Topẽ tũ ki rĩr tĩ to pã'i mỹ. Ti ĩn tá ag tóg vẽnhmãn kãn kỹ nỹtĩ, Topẽ tũ ki rĩr tĩ to pã'i ag, kófa ag mré hã, Topẽ vĩ to professor ag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Hã ra Pedro tóg Jesus nón kãtĩ mũ, kuvar há tá. Kỹ tóg Topẽ tũ ki rĩr tĩ to pã'i ĩn vãso ra rã mũ gé. Kỹ tóg polícia ag mré pĩ to tón nĩ nĩ, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag tóg ũ jãvãnhvãnh mũ, ũ tỹ ón kỹ Jesus jykre kórég tó mũ ẽn. Ti vĩ tugrĩn ag tóg Jesus ti tén sór mũ. Hã ra tóg ag mỹ ki krov tũ nĩ. Vẽnh jyvẽn tĩ kar ag tóg ũ jãvãnhvãnh mũ, hã ra tóg ag mỹ ki krov tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ũ tỹ hẽn ri ke ag tóg ón kỹ Jesus jykre kórég tó mũ, hã ra tóg ag mỹ ki krov tũ pẽ nĩ sir, ag tỹ vẽnh jykre ũ tó', vẽnh jykre ũ tó' he mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kỹ ũ ag tóg vãhã jẽgjẽg kỹ nỹtĩn kỹ (ag tóg) ón kỹ ti jykre kórég ũ kãmén mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ti tỹ tó mẽ ẽg,” he ag tóg. “Topẽ jo ĩn tag kókén jé sóg ke mũ, he ja tóg nĩ, vẽnh nĩgé tỹ há tag ti, he ja tóg nĩ, hã ra sóg kurã tãgtũ ki ũ han mãn ke mũ, ẽg tỹ ẽg nĩgé tỹ han vãnh ẽn han jé sóg ke mũ, he ja tóg nĩ,” he ag tóg, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ge ra tóg ag mỹ ki krov tũ nĩ, ti jykre kórég ẽn vég tũ ag tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kỹ Topẽ tũ ki rĩr tĩ to pã'i mág tóg jẽgnẽ kỹ (tóg) ag kuju kã jẽ mũ sir. “Ã tỹ nén ũ tónh ke mũ mỹ ã mỹ tũ?” he tóg mũ. “Ag hã ne tóg ã vĩ kónãn tag tó ja nĩ gé',” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Hã ra tóg hun ke mũ, nén ũ tó tũ tóg nĩ. Kỹ pã'i mág ẽn tóg ti mỹ ke mãn mũ. “Ã mỹ tỹ Cristo nĩ'?” he tóg, “ẽg tỹ ũ to: há ti nĩ, he mũ ẽn kósin mỹ tỹ ã nĩ'? Ã mỹ tỹ Topẽ kósin nĩ'?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kỹ Jesus tóg ti mỹ: “hỹ, inh hã vẽ,” he mũ. “Ẽprã ke fi kósin ẽn vỹ tỹ inh nĩ. Inh ve jé ãjag tóg ke mũ ha. Ũ tỹ nén kar han mũ ẽn pẽgja tá sóg nĩnh ke mũ. Kanhkã góg kãmĩ sóg kãtérenh ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kỹ pã'i mág ẽn tóg ã kur tỹ jaran' ke mũ sir, jũ kỹ. Kỹ tóg: “ũ tỹ ti jykre kórég tónh ke ũ jãvãnh mãn ke tũ ẽg nĩ ha,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“Ti tỹ Topẽ kato vĩ kónãn ja ẽn mẽ ẽg huri,” he tóg. “Ẽg hỹn ti tỹ hẽ ri kenh mũ ha?” he tóg. “Ter jé tóg ke mũ, ti vĩ tag tugrĩn,” he ag tóg, ag kar ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kỹ ũ ag tóg ti to sugsug mũ sir. Ti kanẽ pãg ag tóg mũ gé sir, kỹ ag tóg ti tãnh kỹ ti mỹ: “ũ nỹ ã tãnh?” he mũ. Kar kỹ polícia ag tóg ti tãnh mũ gé sir, ti kakã ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Hã ra Pedro tóg ĩn vãso kã nĩ nĩ, Topẽ tũ ki rĩr tĩ to pã'i ẽn ĩn tá. Hã ra pã'i ẽn camarada fag vỹ tá nỹtĩ gé, kỹ fag kã ũn pir fi tóg Pedro to kãtĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kỹ fi tóg ti vég mũ sir, ti tỹ pĩ to tón nĩ ra. Kỹ fi tóg ti tugnỹm kỹ ti mỹ: “Jesus mré ã tóg tĩg mũ gé,” he mũ, “Nazaré tá ke ẽn mré,” he fi tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Hã ra Pedro tóg: “vó,” he mũ. “Inh pi(jé) ti ki kanhró nĩ',” he tóg. “Ã tỹ ne tó nẽ'?” he tóg. Kỹ tóg ĩn jãnkã ra tĩ mũ sir, ĩn kãra rã jé. Hã ra galo tóg kyr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Hã ra fi tóg tá ti vég mũ gé. Kỹ fi tóg tá nỹtĩ ag mỹ ke mãn mũ sir. “Tá jẽ ẽn tóg tỹ ag kã ũ jẽ gé,” he fi tóg, Pedro to. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Hã ra tóg: “vó',” he mãn mũ. Kar kỹ tá nỹtĩ ag tóg Pedro mỹ ke mãn mũ. “Ã hỹn tỹ ag kã ũ nĩ,” he ag tóg ti mỹ. “Tỹ ã Galiléia tá ke nĩ mỹr,” he ag tóg. “Ã vĩ vỹ tá ke ag vĩ ri ke nĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Hã ra Pedro tóg ag mỹ: “ãjag tỹ nén tó mũ ẽn ki kagtĩg sóg nĩ mỹr,” he mũ. “Inh ón mũ ra Topẽ tóg inh vóg kónãn ke mũ vẽ, hã kỹ sóg ón ke tũ pé nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hã ra vẽsỹmér galo tóg kyr mãn mũ. Kỹ Pedro tóg Jesus vĩ to jykrén mũ sir, Jesus tỹ ti mỹ nén tó ja ẽn to, hã vỹ: “iso ã tóg: ti ki kagtĩg sóg nĩ, he tãgtũ han ke mũ, galo kyr régre han to hã,” he mũ. Tag mĩ ẽkrén kỹ tóg vẽnh péju kỹ nĩ kỹ fỹ nĩ nĩ sir, Pedro ti. Vãhã tóg ti mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Tỹ vaj kỹ ag tóg kusã ki Jesus ti jykrén mũ jagnẽ mré, Topẽ tũ ki rĩr tĩ to pã'i ag, kófa ag mré hã, Topẽ vĩ to professor ag mré hã ke gé, vẽnh jyvẽn tĩ kar ẽn ag. Kỹ ag tóg Jesus mrĩnh kỹ ti pére mũ mũ, Pilatos mỹ ti fẽg jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kỹ Pilatos tóg ti mỹ: “ã mỹ tỹ Judeu ag pã'i nĩ'?” he mũ. Kỹ tóg: “ki hã ã tóg tó mũ,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hã ra Topẽ tũ ki rĩr tĩ to pã'i ag tóg ti kato vĩ tỹ hẽn ri ke han mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kỹ Pilatos tóg ti mỹ ke mãn mũ. “Mỹ ã tỹ ag mỹ nén ũ tó jãvãnh,” he tóg. “Ha mẽ, ã to ag tóg vĩ kónãn mág kỹ nỹtĩ,” he tóg, Pilatos ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hã ra Jesus tóg vĩ mãn tũ nĩ, kỹ tóg Pilatos mỹ e tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hã ra Pilatos tóg ag mỹ Vẽse ag kar kã ũn pir kavãg tĩ, festa tỹ Páscoa kar ki. Ti jykre vẽ. Ag tỹ ũ to vĩ mũ ẽn kavãg tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Hã ra ũ tóg se kỹ nĩ, ti jijin hã vỹ: Barrabás, he mũ. Vẽnh génh kutẽm ti ag mré tóg se kỹ jẽ nĩ, vẽnh génh kỹ ag tóg ũ tén ja nĨ, hã kỹ ag tóg nĩgfénh kỹ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kỹ vẽnh kar ẽn ag tóg Pilatos to mũ mũ sir, ti mỹ: “ẽg mỹ ã tỹ nén han tĩ ẽn han nĩ,” he jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","KỸ Pilatos tóg ag mỹ: “mỹ ãjag mỹ sỹ Judeu ag pã'i kyvãn há?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Topẽ tũ ki rĩr tĩ to pã'i ag tóg véké Jesus to jũ nỹtĩ, hã kỹ ag tóg nén (ũ) tũ to ti se ja nĩ. Hã ra Pilatos tóg ki kanhró nĩ, hã kỹ tóg ti kavãn sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hã ra Topẽ tũ ki rĩr tĩ to pã'i ag tóg vẽnh kar ag krĩn ja nĩ, ag tỹ Pilatos mỹ: “Barrabás hã kava ra,” he jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kỹ Pilatos tóg ag mỹ ke mãn mũ. “Kỹ sóg ti tỹ hẽ ri kenh mũ, ãjag tỹ ũ to: Judeu ag pã'i, he mũ ẽn tỹ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kỹ ag tóg prẽnprẽr mũ sir. “!..Cruz to ti sã..!” he ag tóg mũ sir, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Kỹ Pilatos tóg ag mỹ: “e ri ken kỹ?” he mũ. “Ti kórég tỹ ne han ti?” he tóg ag mỹ. Hã ra ag tóg prẽr mãn', prẽr mãn' he mũ sir. “!..Cruz to ti sã..!” he ag tóg, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kỹ Pilatos tóg ag mỹ hã han sór mũ sir, kỹ tóg ag mỹ Barrabás kyvãg mũ sir. Jesus mrãnmrãn tóg mũ sir, mrãn ke jafã tỹ, kỹ tóg ag mỹ ti fẽg mũ sir, ag tỹ ka to ti sa jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kỹ soldado ag tóg pã'i mág ĩn kãra Jesus pére mũ mũ sir, ag vẽnh jyvẽn jafã ẽn kãra. Kỹ ag tóg soldado kar ag jé prẽr mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ti kri ag tóg kur fón mũ, kur kusũg tỹ. Sónh pirĩn kỹ ag tóg ti krĩ tógfĩg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kỹ ag tóg ti mỹ: “viva, Judeu ag pã'i,” he mũ sir, ti nyg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kỹ ag tóg vãn tỹ ti krĩ mĩ mrãnmrãn mũ sir, ti to ag tóg sugsug mũ sir, kỹ ag tóg ti jo grĩnhgrĩnh ke mũ sir, ag tỹ ón kỹ ti to: “Senhor,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ag tỹ ti nyg kar ag tóg ti ki kunũg mũ, kur kusũg ẽn ti. Kỹ ag tóg ti kur pẽ tỹ ti kãra rãg mũ sir. Kỹ ag tóg ti pére mũ mũ, ag tỹ cruz to ti san jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hã ra ũ tóg vãnh kãtá kãtĩ mũ, hã vỹ: Cirene tá Simão, he mũ. Alexandre panh vẽ, Rufo panh vẽ gé. Ti tỹ mĩ mũ ra ag tóg ti mỹ vĩ tar han mũ, ti tỹ Jesus cruz vyn jé. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kỹ ag tóg Gólgota tá junjun mũ sir ti mré. Gólgota to ken hã vẽ, hã vỹ: vẽnh krĩ kuka, he mũ ẽg vĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kỹ ag tóg ti mỹ vinho ven mũ, Jesus mỹ, ka tỹ mirra jẽnjo grór mré hã, hã ra tóg kron jãvãnh nĩ, vẽnh kagta ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kỹ ag tóg cruz to ti sãg mũ sir. Ti kur tỹ ag tóg jagnẽ mỹ vẽnh kãpãm mũ sir, to ag tóg jogar he mũ gé, ti kur to, soldado ag. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kusã ki 9 hora vẽ sir, kỹ tóg cruz to ti sãg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ag tỹ nén tỹ kato vĩ tóg rán kỹ nĩ, hã vỹ: “Judeu ag pã'i tỹ rei vẽ,” he mũ. Ti kri tóg sa, vẽnh rán ti. Ti tỹ nẽji vẽsỹ pã'i tỹ rei han mũ to ag tóg ti tén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ti kóm ag tóg ũn régre ag tỹ cruz to sãg mũ gé, bandido ag. Ũ vỹ ti pẽgja tá sa, jó ũ vỹ ti jakãnh tá sa. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hã kỹ tóg nén tỹ ã to rán kỹ nĩ ẽn vẽ, hã vỹ: “ag mỹ tóg tỹ ũn jykre pãno ag mré ke nĩ,” he mũ, Topẽ vĩ rán ki. Hã ra tóg ge nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","KỸ ũ tỹ mĩ mũ mũ ag tóg ti nyg' he mũ gé, vỹn vỹn he kỹ. “Ó,” he ag tóg mỹ. “ã hã ne tóg: Topẽ jo ĩn kókén jé sóg ke mũ, he gé',” he ag tóg. “Kurã tãgtũ ki sóg ũ han mũ, he ã tóg mũ gé',” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","“Vẽnh kren han ra kema'. Cruz to kãtére kema',” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ge ag tóg mũ gé, Topẽ tũ ki rĩr tĩ to pã'i ag, Topẽ vĩ to professor ag mré. Ti nyg ag tóg mũ gé, kỹ ag tóg jagnẽ mỹ: “ũ krenkren han tóg, hã ra tóg vẽnh hã kren han ki kagtĩg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Cristo jé cruz to kãtére kema', Judeu ag pã'i ti', ẽg tỹ ve jé, ẽg tỹ ti vĩ kri nĩm jé,” he ag tóg. Kỹ bandido ag, ũ tỹ ti kóm cruz to nỹtĩ ẽn ag tóg ti nyg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Rã tỹ ẽg nĩno kã sa ra tóg kuty' he mũ sir, ga kar mĩ hã. Kỹ kuty ẽn tóg hora tãgtũ tũg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 hora ki Jesus tóg prẽr mũ sir, jamã hár(a), kỹ tóg: “Eloí, Eloí, lemá sabactani?” he mũ. Ẽg vĩ ki ẽg tóg tag to: “Topẽ, Topẽ, ã tỹ ne jé isovãnh nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kỹ tá nỹtĩ ũ ag tóg jẽmẽ kỹ (ag tóg) jagnẽ mỹ: “ha vé, Elias jé tóg prẽr mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kỹ ũ tóg vẽnhvãg mũ sir, kỹ tóg esponja tỹ vinho prãg mũ, vinho kaja pir tỹ. Ka jurỹn kỹ tóg tỹ kusón kỹ vinho kãra rãg kỹ ti mỹ ven mũ sir, ti tỹ ki ũnh' ũnh' ke jé. “Toreg',” he tóg. “Hẽn ri ke mũn Elias kãtĩ mũ, ti kãtérem jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Hã ra Jesus tóg prẽr mág (pẽ) han kỹ hun ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hã ra Topẽ jo ĩn krẽm kur tỹ jãnkã nĩfe tóg jaran ke mũ, ti jar tóg vẽnh kãkym ke kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hã ra capitão tóg ti vég jẽ nĩ. Ti prẽr mẽg tóg mũ, ti tỹ hun ke ẽn mẽg tóg mũ, kỹ tóg: “vẽnh vĩ há ja vẽ,” he mũ. “Topẽ kósin ja vẽ” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kỹ ũn tỹtá fag tóg tá nỹtĩ gé. Kuvar há tá nỹtĩ kỹ fag tóg ti vég nỹtĩ nĩ. Fag kã ũ fi vỹ tóg tỹ Maria Madalena fi nĩ, kỹ ũ fi tóg tỹ Salomé fi nĩ gé, kỹ ũ fi tóg tỹ Maria fi nĩ gé, José mré Tiago sĩ mỹnh tag fi. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ũn tỹtá ẽn fag tóg ti nón mũ ja nĩgtĩ, ti tỹ Galiléia mĩ tĩ mũn kỹ. Tá fag tóg ti ki rĩr ja nĩgtĩ gé. Kỹ ũn tỹtá tỹ hẽn ri ke fag tóg ti ve kỹ nỹtĩ gé, ti tỹ cruz to sa kỹ, ti mré Jerusalém ra mũ ja ẽn fag. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Rãké tóg nỹ ha, nén kar han jé kurã vẽ sir, hã vỹ: vẽnhkán ke jo kurã ẽn, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Hã ki Arimatéia tá José tóg Pilatos mỹ ke mũ, ti tỹ ti mỹ Jesus fár fi jé. Arimatéia tá José tóg tỹ vẽnh jyvẽn tĩ ag kã ũ nĩ. Jykre kuryj tóg nĩ. Topẽ tỹ tỹ ẽg pã'i nĩ ve sór tóg tĩ gé. Ẽn hã vỹ tóg mũmẽg vãnh kỹ Pilatos mỹ Jesus fár to vĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Kỹ Pilatos tóg: “kỹ ti mỹ ter huri'?” he mũ. Kỹ tóg capitão jé prẽr kỹ ti mỹ: “ti mỹ ter huri'?” he mũ, “mỹ vãsỹ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kỹ capitão tóg: “hỹ,” he mũ. “Ter ti huri,” he tóg. Kỹ Pilatos tóg José mỹ Jesus fár ti fig mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kỹ tóg sir kur kupri kym mũ, ũn há tãvĩ. Kỹ tóg Jesus kãtérem mũ. Kur ẽn tỹ tóg ti pãg mũ. Kỹ tóg vẽnh kej kãtá ti finh tĩ mũ sir, pãró nor kãkã. ag tỹ pãró nor han ja kãkã. Kỹ tóg pó tỹ nĩfénh mũ sir, ti jy. ");
INSERT INTO kgpNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Hã ra Maria Madalena fi tóg vég mũ sir, ag tỹ ti fi ti, Maria fi mré hã, José mỹnh fi. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vẽnhkán ke kurã tũg kỹ Maria Madalena fi tóg nén ger há mãg mũ, Salomé fi ke gé, Maria fi ke gé, Tiago mỹnh ẽn fi. Fag tỹ ti fár ger há han sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kỹ semana kurã ve ki fag tóg kusã (pẽ) ki ti kej ra mũ mũ, rã tỹ jun ke kỹ sa ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mũn kỹ fag tóg jagnẽ mỹ: “ũ nỹ hỹn ẽg mỹ ti kej ti nón mũ', tá', pó tỹ nĩfe ẽn ti'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hã ra fag tóg vẽnh jo vég mũ, ti kej tá, hã ra tóg nor nỹ nĩ, pó mág ẽn tóg tĩn kỹ nĩ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tá junjun kỹ fag tóg ti kej kãra ge mũ sir, kỹ fag tóg kãtá kyrũ vég mũ, hã ra tóg ti nỹgja pẽgja tá nĩ nĩ, kur kupri tu kỹ. Kỹ tóg fag mỹ e tĩ, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kỹ kyrũ ẽn tóg fag mỹ: “vẽnhmỹ' he tũg,” he mũ. “Ãjag hỹn Jesus jãvãnh mũ, Nazaré tá ke ti,” he tóg, “ag tỹ cruz to ũn sãg mũ ẽn ti,” he tóg. “Rĩr ti jẽ nĩ, tag ki ti tũ nĩ ha,” he tóg. “Ag tỹ ti fi ja hã vẽ ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Kur Pedro mỹ tónh mũ jẽg, ti mré mũ tĩ kar ag mỹ ke gé,” he tóg. “Ag mỹ: ãjag jãmĩ tóg tĩg mũ nẽji, hemnĩ, Galiléia ra, hemnĩ. Tá ãjag ti venh mũ, hã kỹ tóg ãjag mỹ to ja nĩ, hemnĩ,” he tóg, fag mỹ, kyrũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kỹ fag tóg ti kej tá fũrũrũn kỹ pa mũ. Pétẽ fag tóg sir mũ mũ, fag mỹ e tĩn kỹ, fag tỹ jũrũn ke kỹ. Kỹ fag pi(jé) ũ mỹ nén ũ tó mũ mỹr', fag kanẽ jur kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus tỹ kusã ki rĩr mãn kỹ, ti tỹ semana ki kurã ve ẽn ki rĩr mãn kỹ tóg Maria Madalena fi mỹ vẽnh ven vén mũ, ti tỹ ũn ki vẽjagrẽ kórég tỹ 7 (ke) pan ja ẽn fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kỹ fi tóg tĩ mũ, ti mré nỹtĩ ag mỹ tó jé, ag fe kaj nỹtĩn kỹ, ag kygfỹ' hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hã ra ag tóg kri nĩm tũ nĩ, fi tỹ ag mỹ kãmén mũ ra, ti tỹ rĩr nĩ ẽn ti, fi tỹ ã tỹ ti ve ja ẽn kãmén mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kar kỹ tóg ũn régre ag mỹ vẽnh ven mũ gé sir. Ag mỹ tóg vẽsỹ ũn kỹ tĩ nĩ. Ag mũ ra ag tóg ẽpry kri ti vég mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kỹ ag tóg vỹnvỹn ke kỹ (ag tóg) ũ tỹ tá nỹtĩ ag mỹ tó mũ gé sir, Jesus mré mũ tĩ ũ ag mỹ, hã ra ag tóg ag vĩ kri fig tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vãhã tóg ũ tỹ 11 (ke) ag mỹ vẽnh ven mũ gé, ag pin kỹ, ag jẽg nỹtĩ ra. Kỹ tóg ag mỹ vĩ tar han mũ, ag tỹ kri nĩm jãvãnh nỹtĩn kỹ, ag tỹ to jykrén tũ nỹtĩn kỹ. “Ãjag hã ne tóg ũ tỹ inh vég mũ ẽn fi vĩ kri fi ja tũ nĩ', ũ tỹ inh vég mũ ẽn ag vĩ kri nĩm ja tũ ãjag nĩ gé,” he tóg. “Ag tỹ inh rĩr mãn vég mũ ra ãjag tóg kri fi ja tũ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kỹ tóg ag mỹ: “ga kri mũ kỹ ẽmã kar mĩ vẽnh vĩ sér kãmén nĩ, Topẽ tỹ há(r) ag kar mỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","“Ũ tỹ ãjag vĩ kri fig mũ ẽn ag vỹ krenkren ke mũ, ũ tỹ inh ki ge kỹ kygpe kỹ nỹtĩ ẽn ag vỹ krenkren ke mũ,” he tóg. “Hã ra ũ tỹ kri fig tũ ẽn vỹ kren ke tũ nĩ, ũ tỹ inh ki rã tũ ẽn vỹ kren ke tũ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Ũ tỹ inh ki ge mũ ẽn ag vỹ milagre venh ke mũ inhhã,” he tóg. “Tag ve jé ag tóg ke mũ, ha mẽ. Vẽnh jagrẽ kórég pan jé ag tóg ke mũ, ijykre tỹ,” he tóg. “Ũn vĩ ũ ag vĩ tó jé ag tóg ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","“Ag tỹ kejẽn pỹn kãgmĩg mũ ra, ag tỹ kejẽn veneno kron mũ ra tóg ag tỹ hẽ ri kenh ke tũ nĩ,” he tóg. “Ũn kaga ag mẽgmẽ jé ag tóg ke mũ gé, ag nĩgé tỹ, kỹ ag tóg sir ag tỹ há' henh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesus tỹ ã mré mũ tĩ ag mỹ tag tó kar kỹ tóg kanhkã ra tãpry mũ sir, kỹ tóg tá jun kỹ (tóg) Topẽ pẽgja tá nĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kỹ ag tóg mũ mũ sir, ẽmã kar mĩ hã, ti mré mũ tĩ ag. Kỹ ag tóg tugtó mũ, vẽnh vĩ sér ẽn ti, kỹ ẽg Senhor tóg ag mré han tĩ nĩ, ag vĩ kóm tóg vẽnh kar tỹ nén han vãnh ẽn hyn han mũ. Hã vẽ.");
INSERT INTO kgpNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lucas tỹ rá vẽ. Sỹ ã mỹ rán vẽ, Teófilo'. Ũ tỹ hẽn ri ke ag vỹ to jykrén, ag tỹ kãmén jé, ẽg tỹ Jesus to nén ki kanhró nỹtĩ ẽn ti, Topẽ tỹ ti jẽnẽ ja ẽn ti, kỹ ag tóg rán huri. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ũ tỹ ti vég mũ ag tóg ẽg mỹ kãmén ja nĩgtĩ, ũ tỹ ti vĩ tó tĩ ag, ũ tỹ ti mré mũ ja ẽn ag. Ẽn ag tỹ nén tó rán ag tóg huri, ũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kỹ sóg vãhã rán to jykrén mũ gé sir, ha mẽ. Jesus kãme mẽ kãn ja inh nĩ ha, ti mur mré hã, kỹ sóg ti tỹ nén han mũ mẽ kãn gé. Hã kỹ sóg ã mỹ Jesus kãme rán mũ sir. Komẽr hã sóg rán kãn sór mũ. Tỹ ã tóg pã'i mág nĩ, Teófilo'. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mẽ ã huri, Jesus kãme ti. Sỹ ã mỹ rán vẽ, ã tỹ ti tỹ ki hã tó ja mẽn jé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kejẽn Herodes tóg tỹ Israel ag pã'i mág tỹ rei nĩ, ga tỹ Judéia tá. Kỹ Topẽ tũ ki rĩr tĩ ũ tóg nĩ nĩ, ti jiji hã vỹ: Zacarias, he mũ. Ti jóg'jóg ve jyjyn hã vỹ: Abias, he mũ. Arão krẽ'krẽ ũ vẽ, Abias ti. Semana pir ki tóg Topẽ tũ ki rĩr tĩgtĩ, Abias ti. Ti semana ki ti krẽ'krẽ tỹ Zacarias ẽn tỹ ki rĩr vẽ, ti tỹ tỹ Abias krẽ'krẽ nĩn kỹ. Prũ ti nĩ, Zacarias ti, kỹ ti prũ fi jiji hã vỹ: Isabel, he mũ. Arão krẽ'krẽ fi vẽ gé, Isabel fi. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ẽn fag vỹ vẽnh jykre kuryj han tĩ, kỹ fag jykre vỹ kuryj nỹtĩ, Topẽ mỹ. Ti vĩ ki króm fag tóg tĩ, ẽg Senhor vĩn ki. Ti tỹ ẽg jyvẽn han fag tóg tĩ, kygnẽ sór tũ fag tóg nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hã ra fag krẽ tóg tũ tĩ. Kurĩ fi tóg nĩ, Isabel fi, hã kỹ fag tóg krẽ tũ nỹtĩ. Krẽ tũ nỹtĩ ki fag tóg kófa nỹtĩ ha. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kejẽn Zacarias tóg ã semana pétẽm mũ sir, ti tỹ Topẽ tũ ki rĩr jé. Kỹ tóg cidade tỹ Jerusalém ra tĩ mũ, Topẽ tũ ki rĩr jé. Tá jun kỹ ag tóg jogar he mũ, ag tỹ ũ tỹ Topẽ mỹ ger há pũn ke mũ ẽn ve jé, incenso ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ag jykre vẽ, ag tỹ to jogar he sór ti. Ag tỹ to jogar hen kỹ tóg tỹ Zacarias nĩ sir, kỹ tóg Topẽ jo ĩn kãra rã mũ sir, ti mỹ pũn jé, ger há ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ti tỹ Topẽ jo ĩn krẽm pũn kỹ vẽnh kar tóg re tá nỹtĩ nĩ, Topẽ mré vĩn kỹ. Zacarias tỹ Topẽ mỹ pũn kỹ ag tóg Topẽ mré vĩ nỹtĩ nĩ, re ki, ũn e ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kỹ tóg ti mỹ pũn mũ sir. Kỹ Topẽ tỹ jẽnẽ jafã vỹ ti mỹ vẽnh ven mũ. Topẽ mỹ ger há pũn jafã vỹ tá jẽ nĩ, ĩn kãtá. Mesa ẽn pẽgja tá tóg jẽ nĩ, Topẽ tỹ jẽnẽ jafã ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarias tỹ ti ve kỹ tóg jũrũn ke mũ. Ti mỹ tóg e tĩ, ti tỹ ti ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Hã ra tóg ti mré vĩ mũ, Topẽ tỹ jẽnẽ jafã ti. Kỹ tóg ti mỹ: “Zacarias',” he mũ. “Kamẽg tũg nĩ,” he tóg. “Topẽ vỹ ã tỹ ti mỹ nén to vĩ mũ ẽn mẽ, kỹ tóg ã mỹ han ke mũ ha. Fi kufyg jé ã tóg ke mũ, ã prũ fi, Isabel fi. Fi tỹ ti ve kỹ tóg gré nỹnh mũ, ã kósin ti, ha vemnĩ,” he tóg, Topẽ tỹ jẽnẽ jafã ti. “Kỹ ã tỹ ti jyjy han kỹ: João, hemnĩ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Kỹ tóg ã mỹ sér tĩnh mũ. Ã fe tóg mrin kenh mũ. Ũ tỹ hẽn ri ke ag mỹ tóg há tĩnh mũ, fi tỹ ti ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Topẽ vỹ ti tỹ ũn mág han ke mũ. Vinho vóg ke tũ tóg nĩ, goj fa vóg ke tũ tóg nĩ gé. Ti vãkre vẽ. Topẽ kuprĩg vỹ tỹ ti jagrẽ nĩnh mũ, fi tỹ ver ti vég tũ ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel ag mỹ tóg Topẽ vĩ tónh mũ, kỹ ũ tỹ hẽn ri ke ag vỹ ti vĩ mẽ kỹ kri fi kỹ ãjag jykre tovãnh ke mũ. Topẽ jykre hã han jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ẽg Senhor jo tóg tĩg ke mũ gé. Vãsỹ Topẽ vĩ tó tĩ tỹ Elias jykre han jé tóg ke mũ. Elias vỹ Topẽ kuprĩg tỹ jagrẽ ja nĩgtĩ, kỹ tóg jykre tar han ja nĩgtĩ. Ẽn jykre han jé tóg ke mũ. Ã kósin tag tỹ ag jyvẽn kỹ ag panh tóg ãjag krẽ mré vẽnh jykre pir han ke mũ. Ũ tỹ Topẽ vĩ mranh tĩ ẽn tóg vẽnh jykre kuryj han sór ke mũ gé, ũ tỹ Topẽ vĩ ki króm tĩ ẽn ri ke. Hã ki tóg vẽnh kar jykre tỹ há' henh ke mũ, ag kugrynh kỹ, ã kósin tag ti. Topẽ mỹ tóg ag jykre tỹ há' henh mũ, Cristo tỹ kãtĩg ken jo, ag tỹ ti jãvãnh jé,” he tóg mũ, Topẽ tỹ jẽnẽ jafã ti, Zacarias mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kỹ Zacarias tóg ti mỹ: “hã ra sóg kófa nĩ ha,” he mũ. “Kar inh prũ fi vỹ kófa nĩ gé, inh mré. Kỹ inh hỹn hẽ ri kenh mũ? Inh mỹ tá krỹg mũ vỹ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kỹ Topẽ tỹ jẽnẽ jafã tóg ti mỹ: “tỹ sóg Gabriel nĩ,” he mũ. “Topẽ nĩgja tá inh jẽgtĩ. Hã ra tóg inh jẽnẽ, sỹ ã mré vĩ jé, sỹ ã mỹ vẽnh vĩ sér tag tó jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“Ha vé, vĩ vãnh nĩ jé ã tóg ke mũ ha, ha vemnĩ. Vĩ vãnh nĩ ki ã tóg isỹ ã mỹ nén tó mũ kurã ẽn pétẽm ke mũ. Ã hã ne tóg sỹ ã mỹ vĩ kri nĩm tũ nĩ'. Ti kurã ki ã tóg venh mũ, sỹ ã mỹ nén tó ja ti. Ã tỹ inh vĩ kri fig tũ nĩn kỹ ã tóg vĩ vãnh nĩnh mũ ha,” he tóg, Topẽ tỹ jẽnẽ jafã ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hã ra vẽnh kar ẽn tóg re tá nỹtĩ nĩ, Zacarias jãvãnh kỹ. Ag mỹ tóg e tĩ, ti kãkutẽ vãnh han kỹ, Topẽ jo ĩn kãtá. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Vãhã tóg kãkutẽ mũ, hã ra tóg sir vĩ vãnh jẽ. Kỹ tóg ag mỹ ven mũ, ã nĩgé tỹ. Hã ki ag tóg ki kanhrãn mũ sir, ti tỹ nén nẽ ve ja ẽn ti, Topẽ jo ĩn kãtá. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ti vĩ vãnh nĩn ki ti rãnhrãj tóg kejẽn tũ' he mũ sir, ti tỹ Topẽ tũ ki rĩr ẽn ti. Kỹ tóg ã ĩn ra tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ti tỹ ã ĩn tá jun kar kỹ ti prũ fi tóg kejẽn kufyg mũ sir, Isabel fi. Kỹ fi tóg vẽnh péju kỹ nĩ nĩ sir, fi mỹ sér tĩn kỹ. Kysã tỹ 5 (ke) han fi tóg, vẽnh péju kỹ nĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Topẽ hã ne inh jagãgtãn',” he fi tóg mũ. “Inh ve tóg, kỹ tóg inh mỹ'ãg tỹ tũg' hé. Inh kurĩ to fag tóg: “Topẽ hỹn fi to kórég nĩ,” he ja nĩgtĩ. Hã ra tóg fag vĩ tỹ tũg' hé, Topẽ ti,” he fi tóg mũ. Hã kỹ fi tóg kufyg mũ sir, ã kósin vãnh (hã) ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Fi kufy nĩ ki kysã tỹ 6 vẽ sir, kỹ Topẽ vỹ ã tỹ jẽnẽ jafã jẽnẽg mũ, ti tỹ Jesus mur ke tónh tĩg jé, Gabriel ẽn ti. Kỹ tóg ga tỹ Galiléia ra tĩ mũ, cidade tỹ Nazaré ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tá tátãg ũ fi tóg nĩ nĩ. Ũn mén ja tũ fi vẽ. Fi jijin hã vỹ: Maria, he mũ. Fi mén ken hã vỹ: José, he mũ. Davi krẽ'krẽ ũ vẽ, José ti, fi mén ke ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Fi hã mỹ tóg vẽnh ven mũ sir, Gabriel ti, kỹ tóg fi mỹ: “ã mỹ há?” he mũ. “Topẽ vỹ ã jagãgtãn, kỹ tóg ã vég mũ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Fi tỹ ti ve kỹ fi tóg jũrũn ke mũ. Ti vĩ tóg fi mỹ e tĩ, kỹ fi tóg to jykrén mũ sir, ti vĩ to. “Ti tỹ ne tó nẽ, hỹn?” he fi tóg mũ, to jykrén kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kỹ Topẽ tỹ jẽnẽ jafã tóg fi mỹ: “kamẽg tũg ra,” he mũ. “Topẽ vỹ ã jagãgtãn mỹr,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","“Ha vé, kufyg jé ã tóg ke mũ,” he tóg. “Kỹ ã tóg kósin ke mũ. Ã tỹ ti jyjyn kỹ ti mỹ: Jesus, hemnĩ,” he tóg, Topẽ tỹ jẽnẽ jafã ti, fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“Tỹn ũn mág jẽnh ke mũ, ã kósin tag ti, kỹ ag tóg ti to: ũ tỹ kynhmỹ nĩ ẽn kósin, henh ke mũ. Kỹ ẽg jóg tỹ Topẽ vỹ ti tỹ pã'i mág han ke mũ, vãsỹ ti jóg'jóg ve tỹ Davi jẽgja kã. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kỹ tóg tỹ pã'i nĩ sir, Jacó krẽ kar to pã'i. Ti tỹ tỹ pã'i nĩ tag vỹ tũ' henh ke tũ nĩ. Tỹ pã'i han kỹ tóg nĩ nĩ,” he tóg, Gabriel ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kỹ fi tóg ti mỹ: “hã ra sóg ũ mré nỹ ja tũ nĩ ver,” he mũ. “Kỹ inh hẽ ri kenh mũ?” he fi tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Kỹ tóg fi mỹ: “Topẽ kuprĩg vỹ ã kri tĩnh mũ,” he mũ, “kỹ ti kãnhvég vỹ ã kri tĩnh mũ gé, kỹ tóg ã jykre tỹ ã kósin ti han ke mũ, Topẽ ti. Hã kỹ ag tóg ti to: Topẽ tũ, henh ke mũ, ã tỹ ũn venh ke ẽn to. Topẽ kósin, he jé ag tóg ke mũ, ti to. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ha vé, ã mré ke fi vỹ kufy nĩ, Isabel fi. Ũn gré ve jé fi tóg ke mũ. Ã kófa (hã) ra fi tog kufy nĩ. Kysã tỹ 6 (ke) han fi tóg huri, kufy nĩ ki. Fi to ãjag tóg: kurĩ fi tóg nĩ, he tĩ vẽ, hã ra fi tóg kufy nĩ ha. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Topẽ hã ne nén kar han há nĩ', hã kỹ tóg fi mỹ han. Kỹ tóg ã mỹ han ke mũ gé, sỹ ã mỹ tó mũ tag ti,” he tóg, Gabriel ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kỹ fi tóg ti mỹ: “há ti nĩ,” he mũ. “Tỹ sóg Topẽ camarada nĩ mỹr, ti tũ pẽ. Kỹ tóg inh mỹ há tĩ, ã tỹ inh mỹ tó mũ tag ti,” he fi tóg ti mỹ. Kỹ tóg tĩ mũ sir, Topẽ tỹ jẽnẽ jafã ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ti tĩg kar kỹ Maria fi tóg tĩ mũ gé sir, Isabel fi jamã ra. Pãnónh e tá tóg nĩ, fi jamã ti, ga tỹ Judéia tá. Fi tỹ ra tĩg kỹ fi tóg fũrũn tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Fi tỹ Zacarias ĩn tá jun kỹ fi tóg Isabel fi mỹ: “ã mỹ há?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kỹ Isabel fi tóg fi vĩ mẽg mũ, kỹ fi kósin tóg vo mũ, fi kãki. Kỹ Topẽ kuprĩg vỹ fi krĩn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kỹ fi tóg prẽr mũ. “Topẽ tóg ã ve há han, fag kar kãmĩ tóg ã kuprẽg,” he fi tóg fi mỹ. “Kỹ Topẽ vỹ ã kósin ve há han mũ gé, ã tỹ ũn venh ke ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Inh Senhor mỹnh fi hã ne tóg inh venh kãtĩ mũ', kỹ tóg inh mỹ e tĩ',” he fi tóg fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","“Ha vé, isỹ ã vĩ mẽ kỹ inh kósin tóg vo ja nĩ, inh kãki. Ti mỹ tóg sér tĩ, ã vĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ã hã ne tóg Topẽ vĩ kri fi', ti tỹ ã mỹ vẽnh vĩ jẽnẽn kỹ. Hã kỹ tóg ã ve há han, Topẽ ti. Ã tỹ ti vĩ kri nĩm kỹ ã tóg venh ke mũ, ti tỹ ã mỹ nén tó ja ti,” he fi tóg, Isabel fi, Maria fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kỹ Maria fi tóg ke mũ gé. “Topẽ mỹ sóg vĩ há han sór mũ,” he fi tóg. “Inh mỹ tóg tỹ ũn mág nĩ, ẽg Senhor ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kỹ inh fe tóg mrin ke mũ, isỹ tỹ Topẽ tũ nĩn kỹ, isỹ tỹ ẽg kren han tĩ ẽn tũ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Inh ki tóg ẽvãnh mỹr. Tỹ sóg ti camarada nĩ. Tỹ sóg ũn sĩ nĩ, hã ra tóg inh ki ẽvãnh. Kỹ vẽnh kar tóg iso: “Topẽ vỹ fi ve há han,” henh ke mũ, inh krẽ'krẽ kar ke gé, ẽprã ke krẽ kar ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Topẽ hã ne inh mỹ ẽg tỹ nén han vãnh han'. Tar ti nĩ, Topẽ ti, hã kỹ tóg han, inh mỹ. Jykre kuryj ti nĩ, Topẽ ti, kỹ ti jiji tóg ẽg mỹ mẽ há tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ẽg jagãgtãn tóg nĩgtĩ, ẽg jóg'jóg ve ag ke gé, ẽg panh ag ke gé, ẽg ke gé, ẽg krẽ kar ke gé. Ũ tỹ ti kamẽg mũ kar jagãgtãn tóg nĩgtĩ mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jykre (ka)mẽ tóg nĩ, kỹ tóg ẽg tỹ nén han vãnh hyn han tĩ. Ũ tỹ: “vẽsóg ki inh nén kar han tĩ,” he mũ ẽn ag jykre tỹ tóg tũg' henh ke mũ,” he fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“Pã'i mág ag tỹ tóg ũn kãsir han, Topẽ ti. Kỹ tóg ũn kãsir ag tỹ ũn mág han. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ũn jagãgtar ag fónfan tóg mũ, nén ũ há tỹ, ũ tỹ ti vĩ mẽ sór mũ ag. Ũn rico ag mỹ tóg: “ha mũ jẽg,” hé, kỹ tóg ag mỹ nén ũ nĩm tũ nĩ, kỹ ag tóg jagãgtar nỹtĩ ha, ũ tỹ ti vĩ mẽ jãvãnh ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israel ag jagãgtãn tóg mũ, ã camarada ag, ã tỹ vãsỹ ag jagãgtãn tĩ ẽn to jykrén kỹ. Ẽg hã vẽ, ẽg jagãgtãn tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ẽg jóg'jóg ve ag mỹ tóg tó ja nĩ, Abraão mỹ, ti krẽ ag mỹ ke gé, ti tỹ ẽg jagãgtãn ke ti. Kỹ tóg ã vĩ ẽn to jykrén kỹ han, ti tỹ vãsỹ nén tó ja ti. Ti tỹ ẽg jagãgtãn ke ẽn tóg tũg' he jãvãnh nĩ,” he fi tóg, Maria fi. Fi tỹ Topẽ mỹ vĩ há han hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kar fi tóg kysã tãgtũ han mũ sir, Isabel fi mré, kỹ fi tóg ã jamã ra vỹn ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Fi tĩg kar Isabel fi vỹ fi kósin venh ke kurã pétẽm mũ sir, kỹ fi tóg vég mũ. Hã ra tóg gré nỹ, fi kósin ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kỹ fi rã nỹtĩ fag vỹ vég mũ, fi kanhkã fag ke gé. Topẽ tỹ fi jagãgtãn mẽg fag tóg mũ. Kỹ tóg fag mỹ sér tĩ sir, fi mré, fi kósin to. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kurã tỹ 8 (ke) ki ag tóg fi tá junjun mũ, ag tỹ ti gré junun fár kym jé. Kỹ ag tóg ti jyjy to jykrén mũ gé, hã vỹ: Zacarias, he mũ. Ti panh jiji tó sór ag tóg mũ, ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hã ra ti mỹnh fi tóg: “vó,” he mũ. “João, he jé tóg ke mũ, ti jyjy ti,” he fi tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kỹ ag tóg fi mỹ: “ã kanhkã jiji tũ vẽ hã ra,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kỹ ag tóg ti panh ki jẽmẽ sór mũ. Ãjag nĩgé tỹ ag tóg ti mỹ: “ti jyjy hỹn hẽ ri kenh mũ'?” he mũ, ti panh mỹ, ag nĩgé tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kỹ tóg ki rán jafã to vĩ mũ, Zacarias ti, kỹ tóg rán mũ. “Ti jijin hã vỹ: João, he mũ,” he tóg, vẽnh rán ki. Kỹ tóg ag mỹ e tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kỹ vãhã ti vĩ tóg punh ke mũ. Ti nũnẽ tóg krónh ke mũ, kỹ tóg vĩ mũ sir, Topẽ mỹ vĩ há han tóg mũ, ti mỹ sér tĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kỹ fag rã nỹtĩ kar vỹ kamẽg mũ. Kỹ vẽnh vĩ ẽn tóg vẽnh kar kri rũm mũ, ga tỹ Judéia kar mĩ hã. Vẽnh kar tóg tỹ vẽmén kãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kỹ ũ tỹ mẽg mũ fag vỹ to jykrén mũ. “Gĩr tag hỹn hẽ ri kenh mũ,” he fag tóg mũ. Topẽ vỹ ti ki rĩr há han, hã kỹ tóg fag mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kỹ Topẽ kuprĩg vỹ ti panh tỹ Zacarias krĩn mũ, kỹ tóg tag tó mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tỹ ti ũn mág jẽ, ẽg povo tỹ Israel kri, ẽg Senhor ti, hã vỹ: Topẽ, he mũ. Ẽg ki tóg ẽvãnh nĩgtĩ, Topẽ ti, ti tỹ ti tũ ag krenkren han jé. Ẽg hã vỹ tỹ ti tũ nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","“Ti camarada tỹ Davi krẽ'krẽ ẽn vỹ ẽg krenkren han ke mũ, ẽg tỹ ti vĩ jẽmẽn kỹ. Ũn mág pẽ vẽ, Davi krẽ'krẽ ẽn ti. Topẽ tỹ ẽg mỹ nén han hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Hã kỹ tóg tó ja nĩ, vãsỹ. Ti vĩ tó tĩ ag vỹ tugtó ja nĩ, vãsỹ, ẽg si ag, ti tũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ũ tỹ hẽn ri ke ag vỹ ẽg kato tẽgtẽ mũgtĩ, hã ra tóg ẽg krenkren han mũ, ag to, ũ tỹ ẽg to kórég tãvĩ nỹtĩ ag to. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ti tỹ ẽg jóg'jóg ve ag mỹ tó ja ẽn han ja tóg nĩ, ẽg jagãgtãn kỹ, Topẽ ti. Ag mré jykrén ja tóg nĩ, Topẽ ti. Ẽn to jykrén ja tóg nĩ, kỹ tóg ki króm ja nĩ sir, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ẽg jóg'jóg ve tỹ Abraão mỹ tóg vẽnh vĩ mág han ja nĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kỹ tóg ti mỹ: “ag krenkren han jé sóg ke mũ, ã krẽ ag, ag kato tẽgtẽ mũ ag to, ha vemnĩ,” he ja nĩ. “Sỹ ke há vẽ. Sỹ ag krenkren han kỹ ag tóg sir jatun mỹ isũ han ke mũ, mũmẽg tũ nĩn kỹ,” he ja tóg nĩgtĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","“Nén ũ vẽnhmỹ han ke tũ ag tóg nĩgtĩ, kurã kãtĩg ke mũ ẽn kã. Vẽnh jykre kuryj tãvĩ han jé ag tóg ke mũ, isũ han kỹ. Ag tỹ ga kri mũn kỹ ag tóg han ke mũ, isũ ti. Kurã kar ki ag tóg sir inh jykre hã han ke mũ,” he ja tóg nĩgtĩ, Topẽ ti, Abraão mỹ,” he tóg, Zacarias ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kỹ tóg ã kósin mỹ: “ha vé, vỹ,” he mũ. “Sĩ ã tóg nĩ ver. Ũ tỹ kynhmỹ nĩ ẽn vĩ tó jé ã tóg ke mũ, kỹ ag tóg ã to: “Topẽ vĩ tó ti tĩ,” henh ke mũ. “Ẽg Senhor jo ã tóg tĩnh mũ, ã tỹ ti japry kure ri ke han jé, ã tỹ ti jamĩn kurynh ri ke han jé, ã tỹ vẽnh kar mỹ Topẽ vĩ tón kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","“Ag kanhrãn jé ã tóg ke mũ, Topẽ tỹ ẽg krenkren han sór ẽn to. Ẽg tỹ ti vĩ mranh tỹ tóg ẽg mỹ vẽnh pãte fón ke mũ, hã ki tóg ẽg krenkren han ke mũ, Topẽ ti,” he tóg, Zacarias ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","“Topẽ tỹ ẽg jagãgtãn hã vẽ, ti tỹ ẽg to há tãvĩ nĩn kỹ. Ẽg ve jé tóg kãtĩg ke mũ, kỹ tóg rã tỹ jun ke ri ke nĩ, Cristo mur ke ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kuty ri ke ti nĩ, ẽg mỹ, ẽg tỹ ti ki kagtĩg nỹtĩn kỹ. Ti kãtĩg kỹ tóg ẽg mỹ kurã ri ke nĩ sir. Kãgter jé ẽg tóg ke mũ, kỹ tóg ẽg mỹ kuty ri ke nỹ sir. Hã ra tóg ẽg mỹ ã japry ven ke mũ, ã jamĩn ti. Jagma mũn kỹ ẽg tóg ti jykre kusa venh ke mũ,” he tóg, Zacarias ti. Ti tỹ ã kósin mỹ tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hã kỹ fi tóg João ve ja nĩ, ti han mũ fag tỹ kófa (hã) ra. Kỹ tóg mog mũ sir, kỹ tóg tar jẽ sir. Krĩ há tóg nĩ gé. Ẽmã tũ mĩ tóg tĩ mũ ver, ã kurã tỹ tá krỹg ki. Ã kurã ki tóg Israel ag mỹ vẽnh ven mũ, ag mỹ Topẽ vĩ kãmén jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","João mur kar kỹ ga kri pã'i mág tỹ imperador tỹ Augusto vỹ kejẽn vẽnh vĩ jẽnẽg mũ, vẽnh kar ag tỹ ãjag jyjy rán mũ jé. Ga kri mũ kar ag mỹ tóg vẽnh vĩ ẽn jẽgnẽg mũ, pã'i mág tỹ Augusto ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Vẽnh jiji rá ve vẽ, ge han ja tũ ag nỹtĩ. Cirênio vỹ tỹ ga tỹ Síria kri pã'i tỹ governador nĩ, Augusto tỹ vẽnh vĩ ẽn jẽnẽg mũn kã. Tỹ tóg Augusto krẽm ke nĩ, Cirênio ti. Ti tỹ tỹ pã'i nĩn kỹ ag tóg sir ãjag jyjy ránrán vén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kỹ ag tóg mũ kãn mũ, ãjag jóg'jóg ve ag jamã ja ra. Tá ag tóg ãjag jiji rá vin mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Kỹ José tóg tĩ mũ gé, ã prũnh ke fi mré, hã vỹ: Maria, he mũ. Cidade tỹ Nazaré tá fag tóg pa mũ, ga tỹ Galiléia tá. Kỹ fag tóg ga tỹ Judéia ra mũ mũ, cidade tỹ Belém ra. Davi krẽ'krẽ vẽ, José ti, hã kỹ tóg Belém ra tĩ mũ, ã jyjy rá nĩm jé. Davi jamã ja vẽ, Belém ti. Hã kỹ tóg ra tĩ mũ. Kỹ ti prũnh ke fi vỹ ti mré tĩ mũ, hã ra fi tóg kufy jagy nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Fag tỹ tá nỹtĩ ki fi tóg ã kurã pétẽm mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kỹ fi tóg ã kósin vég mũ sir. Gré ti nỹ, fi kósin ve tag ti. Kỹ fi tóg ti pãg kỹ koso kãkã ti fig mũ. Ĩn vỹ funfór nỹtĩ, hã kỹ fag tóg vẽnh mẽg jo ĩn krẽm nỹtĩ ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kỹ ũ tỹ mé ki rĩr tĩ ag vỹ tá nỹtĩ gé, carneiro ki rĩr tĩ ag. Ag japỹ ja tá ag nỹtĩ, ãjag mẽg ki rĩr jé, kuty ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kỹ vãhã Topẽ tỹ jẽnẽ jafã vỹ ag mỹ vẽnh ven mũ, kanhkã tá. Topẽ tỹ jẽngrẽ vỹ ag kri rũm ke mũ. Kỹ ag tóg kamẽg kỹ jũrũn ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kỹ Topẽ tỹ jẽnẽ jafã tóg ag mỹ: “kamẽg tũg ra,” he mũ. “Sỹ ãjag mỹ nén ũ tónh ke vẽ. Vẽnh vĩ há tó jé sóg ke mũ, kỹ tóg ãjag mỹ sér tĩnh mũ. Vẽnh kar vỹ mẽnh mũ, inh vĩ ti, povo kar, kỹ ag fe tóg mrin ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ãjag krenkren han tĩ vỹ ũri mur, hã vỹ: Cristo, he mũ. Ẽg Senhor vẽ ha mỹr. Davi jamã ja tá tóg mur mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ha mũ jẽg, ãjag tỹ gĩr ẽn ve jé. Koso kãkã tóg pãg kỹ nỹ nĩ. Hã ki ãjag tóg ti ki kanhró nỹtĩnh mũ,” he tóg ag mỹ, Topẽ tỹ jẽnẽ jafã ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kỹ vãhã ũ tỹ hẽn ri ke ag tóg vẽnh ven mũ sir. Topẽ tỹ jẽnẽ jafã ag, kanhkã tãn ag. Ẽn ag vỹ Topẽ mỹ vĩ há han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Topẽ vỹ tỹ ũn mág pẽ nĩ,” he ag tóg mũ. “Kynhmỹ ti nĩ, vẽnh kar kãfór ti nĩ, kỹ ẽprã ke ag vỹ jatun mỹ nỹtĩ, ãjag krĩ kusa tĩn kỹ, Topẽ tỹ ũ tó há ag,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kar ag tóg tũg' he mũ sir, ag tỹ kanhkã ra mũn kỹ. Ag tỹ tũg' hen kỹ ũ tỹ carneiro ki rĩr tĩ ag vỹ jagnẽ mỹ: “mũ nỹ, Belém ra, ẽg tỹ ve jé, Topẽ tỹ nén han ja ti, ẽg Senhor tỹ ẽg mỹ vẽnh vĩ jẽnẽ ja ẽn ti,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Kỹ ag tóg fũrũnrũn mũ mũ sir. Tá ag tóg junjun mũ. Kỹ ag tóg vég mũ, Maria fi, José ti ke gé, gĩr ti ke gé. Koso kãkã tóg nỹ nĩ, Maria fi kósin ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hã kỹ ag tóg vég mũ. Hã kỹ ag tóg kãmén mũ, vẽnh kar mỹ. Topẽ tỹ ag mỹ vẽnh vĩ jẽnẽ ja ẽn kãmén ag tóg mũ, gĩr ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kỹ tóg ũ tỹ mẽg mũ ag mỹ e tĩ sir. Ũ tỹ mé ki rĩr tĩ ag vĩ mẽg ag tóg mũ, kỹ tóg ag mỹ sér tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kỹ Maria fi tóg vẽnh vĩ tag to jykrén mũ gé sir. Fi pi(jé) kã jatun mũ', ag tỹ nén tó ja ẽn ti. To jykrén kỹ fi tóg nĩ nĩ, Maria fi. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kỹ carneiro ki rĩr tĩ ag tóg sir ãjag mẽg to vỹnvỹn ke mũ gé. Topẽ mỹ ag tóg vĩ há han mũ. “Ti hã ne tóg ẽg mỹ vẽnh vĩ jẽnẽ ja nĩ', ã tỹ jẽgnẽ jafã ag tỹ', kỹ ẽg tóg vé,” he ag tóg mũ sir, Topẽ to. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kar kurã tỹ 8 (ke) vỹ tũg mũ. Kỹ tóg ti gré junun fár kym ke kurã pétẽm mũ sir, gĩr sĩ ẽn ti. Kỹ fag tóg ti jijin kỹ ti mỹ: “Jesus,” he mũ. Topẽ tỹ jẽnẽ jafã vỹ ti jyjy tag tó ja nĩ, ti mỹnh fi tỹ ver ti tỹ kufyg tũ ra. Hã kỹ fag tóg sir tỹ ti jijin mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kejẽn fag vãkre tóg tá krỹg mũ, kỹ fag tóg vẽnh kykũnh sór mũ. Moisés vỹ tag rán ja nĩ, gĩr mur kar kỹ fag tỹ vẽnh kykũnh ke ti. Judeu ag jykre hã vẽ. Fag tỹ vẽnh kykũnh jé fag tóg cidade tỹ Jerusalém ra mũ mũ, fi tỹ Topẽ mỹ ã kósin ven jé, tá. “Ã tũ vẽ,” he sór fag tóg mũ, Topẽ mỹ, fi kósin ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Topẽ vĩ ki tag vỹ rán kỹ nĩ, hã vỹ: “fi kósin ve tỹ gré nỹn kỹ tóg tỹ ẽg jóg mág tỹ Topẽ tũ nỹ,” he mũ, Topẽ vĩ tỹ rán kỹ nĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hã kỹ fag tóg Topẽ jo ĩn ra mũ mũ, Topẽ mỹ nén ũ pũn jé. Rán kỹ tóg nĩ nĩ, ẽg jóg mág vĩn ki, fag tỹ ne tỹ ti mỹ pũn ke ti, hã vỹ: sórãg régre, ke tũ nĩ kỹ ton régre, he mũ gé. Ẽn ma fag tóg mũ mũ, fag tỹ Topẽ mỹ pũn jé. Topẽ tũ ki rĩr tĩ ag mỹ fag tóg vin tĩ, sórãg ti, kỹ ag tóg tãnh kỹ Topẽ mỹ pũn tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kỹ Jerusalém tá ũ tóg nĩ nĩ, ti jyjy hã vỹ: Simeão, he mũ. Ũn jykre kuryj vẽ, Simeão ti. Topẽ kamẽg tóg tĩgtĩ, Topẽ kuprĩg tỹ tóg jagrẽ nĩ. Topẽ tỹ Israel ag krenkren han mũ ẽn jãvãnh tóg nĩgtĩ, Simeão ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kỹ Topẽ kuprĩg vỹ ti mỹ: “Cristo ve jé ã tóg ke mũ, ã ter ke to hã, ẽg Senhor tỹ ti jẽnẽn kỹ,” he ja nĩgtĩ ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Topẽ kuprĩg tỹ ti krĩn kỹ tóg kejẽn Topẽ jo ĩn kãra tĩ mũ. Kỹ tóg tá jẽ nĩ, hã ra fag tóg Jesus ma kãmũ mũ, fag tỹ Topẽ mỹ sórãg pũn jé, Moisés tỹ Judeu ag mỹ nén tó ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ã tỹ Jesus ve kỹ tóg ti vãg mũ sir, kỹ tóg ti to Topẽ mỹ vĩ há han mũ, Simeão ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ẽg jóg mág,” he tóg, Topẽ mỹ. “Vãhã ã tóg inh jé prẽr ke mũ, kỹ sóg jatun mỹ tĩg mũ ha,” he tóg. “Ã tỹ inh mỹ nén tó jan han ã tóg huri,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","“Ve inh huri, ã tỹ ẽg krenkren han ke mũ ti. Cristo ve inh huri,” he tóg, Simeão ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","“Vẽnh kar rĩnve ã tóg han, ã tỹ ẽg krenkren han ke mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kỹ tóg ẽg mỹ jẽngrẽ ri ke nĩ, Cristo mur ti. Kỹ povo kar vỹ vég mũ, fóg ag kar, kanhgág ag kar ke gé, ã tỹ ag krenkren han ke mũ ti. Ẽg povo tỹ Israel tỹ ã tóg ũn mág han huri, vẽnh kar rĩnve, Cristo tỹ ẽg mré ke nĩn kỹ,” he tóg, Simeão ti, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kỹ Jesus jóg vỹ ti vĩ mẽg mũ, Jesus mỹnh fi ke gé, kỹ tóg fag mỹ e tĩ, ti tỹ Jesus to nén tó mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kỹ Simeão vỹ fag mỹ vẽnh vĩ há tó mũ gé. “Topẽ vỹ ãjag ve há han mũ,” he tóg mũ fag mỹ, Simeão ti. Kỹ tóg Maria fi mỹ: “ha vé,” he mũ. “Israel tỹ hẽn ri ke ag vỹ ti tugrĩn mũ há han ke mũ, jãvo ũ tỹ hẽn ri ke ag vỹ ti tugnĩn mũ kónãn ke mũ gé. Kỹ ag tóg ti kato vĩnh ke mũ gé, Topẽ tỹ ti jẽnẽ ja ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kỹ ã tóg ti tugrĩn vẽsỹrénh kenh ke mũ, jỹ, kỹ tóg rógro tỹ ã fe tỹ gynh ke ri ke nĩnh ke mũ, ã vẽsỹrénh ke ti. Kỹ ẽg tóg venh ke mũ, ag tỹ nén to ti to jykrén mũ ti,” he tóg, Maria fi mỹ, Simeão ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kỹ ũ fi tóg tá nĩ gé, Topẽ jo ĩn krẽm, fi jiji hã vỹ: Ana, he mũ. Topẽ vĩ tó tĩ fi vẽ gé. Fanuel kósin fi vẽ. Kỹ fi jóg'jóg ve vỹ tỹ Aser nĩ. Kófa fi nĩ ha, kófa tãvĩ. Ã mén kỹ fi tóg 7 anos han, fi mén mré, kar tóg ter ja nĩ, fi mén ti, fi mré 7 anos han kar. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kar fi tóg mén tũ tĩ nĩ sir. 84 anos han fi tóg, mén tũ tĩ ki. Ẽn fi vỹ Topẽ jo ĩn krẽm nĩ nĩ, kurã kar ki fi tóg tá nĩ nĩ sir. Tá fi tóg Topẽ tũ han nĩgtĩ, ti mré vĩ kỹ. Jẽg tũ fi nĩgtĩ, fi tỹ Topẽ mré vĩ jé. Kuty tá fi tóg ke tĩ, kurã tá ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ẽn fi vỹ hora ẽn kã Topẽ jo ĩn krẽm jẽ mũ, Simeão tỹ Jesus ven kỹ. Kỹ fi tóg Jesus vég mũ gé sir, Ana fi. Ti ve kỹ fi tóg Topẽ mỹ vĩ há han mũ. “Inh mỹ tóg há tĩ, sỹ ti ven kỹ,” he fi tóg mũ, Topẽ mỹ. Vẽnh kar mỹ fi tóg tó mũ, ũn krenkren sór mũ ag mỹ, Jerusalém tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kỹ fag tóg sir Moisés tỹ vẽnh kykũnh to nén rán ja ẽn han kãn mũ sir, Jesus mỹnh fi, Topẽ tỹ Judeu fag mỹ vẽnh jykre nĩm ja ẽn ti. Kar kỹ fag tóg sir cidade tỹ Nazaré ra vỹnvỹn ke mũ, ga tỹ Galiléia ra, fag jamã ra ke vẽ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kỹ gĩr sĩ ẽn tóg mog mũ sir, komẽr hã tóg tar jẽ sir. Kỹ tóg vẽnh kanhrãn há han mũ, kỹ Topẽ vỹ ti ve há han mũ gé, hã kỹ tóg vẽnh kanhrãn mág mũ sir, ũn sĩ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesus mỹnh fag tóg prỹg kar ki Jerusalém ra mũ tĩ, fag tỹ festa tỹ Páscoa venh mũ jé. Fag jykre hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus tỹ 12 anos han kỹ tóg fag mré tĩ mũ gé, fag tỹ festa ẽn venh mũn kỹ, Jerusalém ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Festa tỹ tũ ken kỹ fag tóg vỹnvỹn ke mũ, hã ra Jesus tóg Jerusalém tá nĩ nĩ. Hã ra fag tóg ki kagtĩg nỹtĩ, ti tỹ Jerusalém tá nĩ ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kỹ fag tóg: “ti hỹn ũ tỹ ẽg mré kãmũ mũ fag mré vyr, ẽg jo,” he mũ. Kỹ fag tóg kurã pir ki mũ mũ, fag jamã ra vỹnvỹn ke kỹ. Fag tỹ ãjag mré ke fag tá junjun kỹ fag tóg ti jãvãnh mũ, ãjag to há kar fag kãmĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Hã ra fag tóg tá Jesus vég tũ nĩ. Kỹ fag tóg Jerusalém ra vỹnvỹn ke mãn mũ gé, ti jãvãnh jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Vãhã fag tóg ti vég mũ, kurã tãgtũ tũ kỹ. Topẽ jo ĩn krẽm tóg nĩ nĩ, professor ag mré. Ag vĩ mẽg tóg nĩ nĩ, kỹ tóg ag ki jẽmẽg mũ gé, “ne nẽ?” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ũ tỹ ti vĩ mẽg mũ ag mỹ tóg e tĩ. To jykrén há han tóg, Jesus ti, kỹ tóg ag mỹ tó há han mũ. Ag tỹ ti vĩ mẽ kỹ tóg ag mỹ e tĩ, professor ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ti mỹnh fag tỹ ti ve kỹ tóg fag mỹ e tĩ gé sir. Kỹ ti mỹnh fi tóg ti mỹ: “inh kósin',” he mũ. “Ã tỹ tag kã ne han nĩ nẽ'? Ã jóg mré sóg ã jãvãnh jagy han. Ã jãvãnh to ẽg tóg kanẽ jur, ẽg tỹ ã vég tũ nĩn kỹ,” he fi tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hã ra tóg fi mỹ: “ã tỹ ne jé inh jãvãnh ja nẽ?” he mũ. “Hẽ ri ken kỹ hỹn'?” he tóg. “Inh panh pẽ ĩn krẽm sóg nĩ nĩ mỹr, kỹn mỹ ãjag mỹ vẽnhmỹ?” he tóg, ã mỹnh fag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hã ra tóg fag tỹ to jykrén tũ tĩ, fag kósin vĩ to. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kỹ tóg fag mré tĩ mũ, cidade tỹ Nazaré ra. Tá tóg fag mré nĩ nĩ sir, ti tỹ fag vĩ jẽmẽn kỹ. Kỹ ti mỹnh fi pi(jé) vẽnh vĩ kar tag kã jatun nĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kỹ Jesus tóg mog mũ sir. Krĩ há tãvĩ tóg nĩ. Topẽ vỹ ti ve há han mũ gé. Kỹ tóg vẽnh kar mỹ há tĩ sir, ag tỹ ti jykre ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kejẽn tóg Tibério tỹ pã'i mág tỹ imperador nĩ kri 15 anos han mũ. Ti tỹ Roma tá tỹ pã'i mág nĩ ẽn kã Pôncio Pilatos vỹ tỹ ga tỹ Judéia kri pã'i tỹ governador nĩ, Tibério krẽm. Ẽn kã Herodes vỹ tỹ Galiléia kri pã'i tỹ governador nĩ gé, Tibério krẽm. Herodes jãvy tỹ Filipe vỹ tỹ ga tỹ Ituréia tá pã'i tỹ governador nĩ gé, ga tỹ Traconites tá ke gé, Tibério krẽm. Jãvo Lisânias vỹ tỹ ga tỹ Abilene tá pã'i tỹ governador nĩ, Tibério krẽm. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ẽn kã Caifás vỹ tỹ Topẽ tũ ki rĩr tĩ ag pã'i mág nĩ, Anás mré hã. Kỹ vãhã Topẽ vỹ João mré vĩ mũ sir, Zacarias kósin ẽn mré. Ẽmã tũg ja mĩ tóg tĩ mũ, João ti. Kỹ Topẽ tóg ti mỹ: “ha Israel ag mỹ vẽnh ven tĩg,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kỹ tóg sir tĩ mũ. Goj tỹ Jordão jagma tóg tĩ mũ. Tĩg kỹ tóg vẽnh kar jyvẽn mũ, kỹ tóg ag mỹ: “ã kype jé sóg ke mũ, ã tỹ ã jykre kórég tovãnh sór kỹ, Topẽ tỹ ã tỹ ti vĩ mranh tỹ ã mỹ vẽnh pãte fón jé,” he tóg mũ sir, vẽnh kar mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","João tóg rán kỹ nĩ, vãsỹ. Topẽ vĩ tó tĩ tỹ Isaías vỹ João to tag rán ja nĩ, ha mẽ: “ẽmã tũg ja tá tóg jẽnh ke mũ, ga kórég tá,” he ja tóg nĩ, Isaías ti. “Tá tóg ag mỹ tónh ke mũ. “Ẽg Senhor kãtĩg ke jo vẽnh jãnhkrigkrig nĩ,” he jé tóg ke mũ. “Ẽpry kurég ãjag tóg tĩ, ẽmĩn kurynh ãjag tóg tĩ, ãjag chefe jun ken kỹ. Kỹ tag ri ke han nĩ, ãjag jykre pãno togvãnh kỹ, ẽg Senhor kãtĩg ken jo. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ti kãgnó tỹ ãjag tóg kyjer' he tĩ, kar ãjag tóg ẽpry sór kar kũm ke tĩ gé, ẽmĩn sór ti. Ti jonjor kugrynh kãn ãjag tóg tĩ, ti sunsór vãvãm kãn ãjag tóg tĩ gé, ãjag tỹ ẽpry han kỹ, ẽmĩn han kỹ. Kỹ tag ri ke han nĩ, ãjag jykre kórég to. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hã kỹ ẽprã ke kar vỹ venh ke mũ, Topẽ tỹ ẽg krenkren han ke ti,” he jé tóg ke mũ, kỹ vẽnh kar vỹ ti vĩ mẽnh mũ,” he ja tóg nĩ, Isaías ti, João to. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hã kỹ João tóg sir ag jyvẽn mũ sir, ag tỹ ti venh kãmũn kỹ, ti tỹ ag kygpe jé. E tãvĩ ag nỹtĩ, ũ tỹ ti venh kãmũ mũ ag. Ag jyvẽn kỹ tóg ag mỹ: “pỹn ri ke ãjag tóg nỹtĩ, ãjag jykre pãno tãvĩ nĩn kỹ,” he mũ. “Ũ nỹ ãjag mỹ: “Topẽ jũ venh ke tũ ãjag nĩ,” he tĩ'? ");
INSERT INTO kgpNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ãjag jykre si togvãnh ra, ãjag tỹ ti jũ ve jãvãnh tĩn kỹ. Vẽnh jykre há han ra, ẽg tỹ ãjag jykre tãg ve jé. Hã ra ãjag tóg jagnẽ mỹ: “Abraão vỹ tỹ ẽg jóg'jóg ve nĩ,” he mũ, “kỹ Topẽ hỹn ẽg to jũnh ke tũ nĩ, ẽg tỹ tỹ Abraão krẽ'krẽ nỹtĩn tugrĩn,” he ãjag tóg tĩ. Hã tũ vẽ hã ra. Ãjag jykre kórég ẽn to ãjag tóg jagtar ke mũ, ha vemnĩ. Topẽ vỹ Abraão krẽ'krẽ hyn han ki kanhró nĩ, pó tag tỹ mỹr, ti tỹ Abraão krẽ'krẽ ve sór kỹ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hã ra tóg ãjag tỹ tũ' henh ke mũ, ãjag tỹ ãjag jykre kórég tovãnh tũ nĩn kỹ,” he tóg, João ti. “Ẽg tỹ ka gỹn ri ke tóg nĩ. Ti kanẽn vãnh nĩn kỹ ẽg tóg ti gỹn tĩ, tỹ pĩ han jé. Tag ri ke han jé tóg ke mũ, Topẽ ti, ãjag mỹ, ãjag tỹ vẽnh jykre há han tũ nĩn kỹ. Kỹ tóg pĩ ki ãjag vãm ke mũ, Topẽ ti,” he tóg ag mỹ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kỹ ũn e ag tóg ti ki jẽmẽnh kãmũ mũ sir, João ki. Kỹ ag tóg ti mỹ: “kỹ ẽg hỹn hẽ ri kenh mũ ha, Topẽ jykre han jé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kỹ tóg ag mỹ: “ã kur régre nĩn kỹ ã kur pir nĩmnĩ, ũn kur tũ ẽn mỹ,” he mũ. “Ã jẽn tỹ ũn kókĩnkĩr ag mỹ vẽnh kãpópãm nĩ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kỹ ũ tỹ governo mỹ imposto kaja mãg tĩ ag vỹ João to kãmũ mũ gé, ti tỹ ag kygpe jé. Kỹ ag tóg ti mỹ: “professor',” he mũ. “Ẽg hỹn hẽ ri kenh mũ?” he ag tóg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kỹ João tóg ag mỹ: “pã'i mág tỹ ãjag mỹ nén tó mũ ẽn hã ri ke mãn nĩ, jãnkamy ti,” he mũ. “Ker ti kãfór mãn sór hẽ',” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kỹ soldado ag vỹ tá junjun mũ gé. “Kỹ ẽg hỹn hẽ ri kenh mũ?” he ag tóg mũ gé sir, soldado ag. Kỹ tóg ag mỹ: “ag tũ mãn sór tũg nĩ,” he mũ. “Ag to vãsãn ãjag tóg tĩ, ũ to ón ãjag tóg tĩ gé, ãjag tỹ ag jãnkamy ve jé. Ke tũg nĩ. Ãjag rãnhrãj to ãjag tóg jãnkamy vég tĩ. Ti kãfór mãn sór tũg nĩ,” he tóg, João ti, soldado ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kỹ vẽnh kar ag tóg ti to jykrén mũ, João to. “Ti mỹ tỹ Cristo tũ nĩ vỹ?” he ag tóg mũ sir ti to. João to ag tóg ke mũ, ag tỹ Cristo kãtĩg jãvãnh kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kỹ João tóg ag mỹ: “inh pi(jé) tỹ Cristo nĩ',” he mũ. “Goj hã tỹ sóg ãjag kygpég tĩ. Inh nón tóg kãtĩg mũ, Cristo ti, ha mẽ. Inh kãfór ti nĩ. Sỹ tỹ ti camarada nĩnh ke vẽ vẽ, sỹ ti pẽn né kunũ jé, ti pẽn to ró ti. Hã ra sóg tỹ ti krẽm pẽ jẽ. Ẽn vỹ tóg Topẽ kuprĩg jẽnẽnh ke mũ, ti tỹ tỹ ãjag jagrẽ nĩ jé, kỹ tóg pĩ jẽngrẽ ri ke nĩ. Ti tỹ ãjag kygpenh ken hã vẽ,” he tóg, João ti. mũ, ti tỹ tỹ ãjag jagrẽ nĩ jé, kỹ tóg pĩ jẽngrẽ ri ke nĩ. Ti tỹ ãjag kygpenh ken hã vẽ,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Ti kãtĩg vỹ tỹ ẽg tỹ rãgró rẽn ri ke nĩ. Ti rẽn kar kỹ ẽg tóg ti fár vãm tĩ, ẽg tỹ pãjó kuprãg jé. Ti kanẽ há vin han ẽg tóg tĩ. Ti fár pũn ẽg tóg tĩ. Cristo kãtĩg kỹ tóg ri ke nỹ. Ũ tỹ ã to há ag mỹ tóg: “ha kãmũ jẽg,” henh ke mũ. Ũ tỹ ã to kórég ag vãm jé tóg ke mũ, pĩ ki, hã ra tóg nhyn kenh ke tũ pẽ nĩ,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hã kỹ tóg vẽnh kar mỹ Topẽ vĩ sér tó mũ, ag jyvẽn kỹ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kỹ tóg pã'i mág tỹ Herodes jyvẽn mũ gé, ti prũ fi to, hã vỹ: Herodias fi, he mũ. Tỹ fi ti jãvy prũ ja nĩ, hã ra tóg fi péju kỹ fi tỹ prũg mũ, Herodes ti. Nén ũ vẽnhmỹ e han tóg tĩ, hã kỹ João tóg ti jyvẽn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kar tóg sir nén ũ vẽnhmỹ ũ han mãn mũ gé, Herodes ti. João ség tóg mũ, ti tỹ ti jyvẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hã ra tóg kãgmĩ kỹ jẽ tũ nĩ ver, João ti. Kỹ tóg ag kygpe kãn mũ. Kỹ tóg kejẽn Jesus kypég mũ gé. Kỹ Jesus tóg jẽ nĩ, ti tỹ Topẽ mré vĩn kỹ, João tỹ ti kype kar kỹ. Kỹ vãhã kanhkã tóg nor' he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kỹ Topẽ kuprĩg vỹ kanhkã tá kãtére mũ, ti kri. Tỹ sórãg ve ti nĩ, Topẽ kuprĩg ti. Kỹ kanhkã tá vẽnh vĩ tóg mẽ há tĩ, kỹ tóg: “tỹ ã inh kósin pir jẽ, tỹ ã tóg inh fe pẽ jẽgtĩ,” he mũ, vẽnh vĩ ti, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus vỹ 30 anos han mũ, ti tỹ vẽnh kar mỹ Topẽ kãmén ve ki. “José kósin vẽ,” he ag tóg tĩ ti to, hã ra tóg tỹ ti kósin tũ nĩgtĩ. Eli kósin vẽ, Jesus ti, kỹ Eli ẽn vỹ tỹ ti vovô nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli vỹ tỹ Matate kósin nĩ. Matate vỹ tỹ Levi kósin nĩ. Levi vỹ tỹ Malqui kósin nĩ. Malqui vỹ tỹ Janai kósin nĩ. Janai vỹ tỹ José kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José vỹ tỹ Matatias kósin nĩ. Matatias vỹ tỹ Amós kósin nĩ. Amós vỹ tỹ Naum kósin nĩ. Naum vỹ tỹ Esli kósin nĩ. Esli vỹ tỹ Nagai kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai vỹ tỹ Maate kósin nĩ. Maate vỹ tỹ Matatias kósin nĩ. Matatias vỹ tỹ Semei kósin nĩ. Semei vỹ tỹ José kósin nĩ. José vỹ tỹ Joda kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda vỹ tỹ Joanã kósin nĩ. Joanã vỹ tỹ Resa kósin nĩ. Resa vỹ tỹ Zorobabel kósin nĩ. Zorobabel vỹ tỹ Salatiel kósin nĩ. Salatiel vỹ tỹ Neri kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri vỹ tỹ Melqui kósin nĩ. Melqui vỹ tỹ Adi kósin nĩ. Adi vỹ tỹ Cosã kósin nĩ. Cosã vỹ tỹ Elmadão kósin nĩ. Elmadão vỹ tỹ Er kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er vỹ tỹ Josué kósin nĩ. Josué vỹ tỹ Eliézer kósin nĩ. Eliézer vỹ tỹ Jorim kósin nĩ. Jorim vỹ tỹ Matate kósin nĩ. Matate vỹ tỹ Levi kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi vỹ tỹ Simeão kósin nĩ. Simeão vỹ tỹ Judá kósin nĩ. Judá vỹ tỹ José kósin nĩ. José vỹ tỹ Jonã kósin nĩ. Jonã vỹ tỹ Eliaquim kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim vỹ tỹ Meleá kósin nĩ. Meleá vỹ tỹ Mena kósin nĩ. Mena vỹ tỹ Matata kósin nĩ. Matata vỹ tỹ Natã kósin nĩ. Natã vỹ tỹ Davi kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi vỹ tỹ Jessé kósin nĩ. Jessé vỹ tỹ Obede kósin nĩ. Obede vỹ tỹ Boaz kósin nĩ. Boaz vỹ tỹ Sala kósin nĩ. Sala vỹ tỹ Nassom kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nassom vỹ tỹ Aminadabe kósin nĩ. Aminadabe vỹ tỹ Admim kósin nĩ. Admim vỹ tỹ Arni kósin nĩ. Arni vỹ tỹ Esrom kósin nĩ. Esrom vỹ tỹ Peres kósin nĩ. Peres vỹ tỹ Judá kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá vỹ tỹ Jacó kósin nĩ. Jacó vỹ tỹ Isaque kósin nĩ. Isaque vỹ tỹ Abraão kósin nĩ. Abraão vỹ tỹ Tera kósin nĩ. Tera vỹ tỹ Nacor kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor vỹ tỹ Seruque kósin nĩ. Seruque vỹ tỹ Ragaú kósin nĩ. Ragaú vỹ tỹ Faleque kósin nĩ. Faleque vỹ tỹ Éber kósin nĩ. Éber vỹ tỹ Sala kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala vỹ tỹ Cainã kósin nĩ. Cainã vỹ tỹ Arfaxade kósin nĩ. Arfaxade vỹ tỹ Sem kósin nĩ. Sem vỹ tỹ Noé kósin nĩ. Noé vỹ tỹ Lameque kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque vỹ tỹ Metusalém kósin nĩ. Metusalém vỹ tỹ Enoque kósin nĩ. Enoque vỹ tỹ Jarete kósin nĩ. Jarete vỹ tỹ Maleleel kósin nĩ. Maleleel vỹ tỹ Cainã kósin nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã vỹ tỹ Enos kósin nĩ. Enos vỹ tỹ Sete kósin nĩ. Sete vỹ tỹ Adão kósin nĩ. Adão vỹ tỹ Topẽ tỹ há nĩ. Jesus jóg'jóg ve ag hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kỹ Topẽ kuprĩg vỹ tỹ Jesus jagrẽ nĩ. Kỹ Jesus vỹ goj tỹ Jordão tá vỹn ke mũ, ã kype kỹ jẽn kỹ. Ti tĩg kỹ Topẽ kuprĩg vỹ ti krĩn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kỹ tóg ti tỹ ti krĩn kỹ ẽmã tũg ja ra tĩ mũ sir, ga kórég ra. Tá tóg kurã tỹ 40 (ke) han mũ, ẽmã tũg ja ki. Kỹ Japo vỹ ti tỹ ã jóg vĩ mranh han sór mũ, tá, hã ra Jesus tóg ke tũ nĩ. Ẽmã tũg ja tá nĩn kỹ tóg jẽg tũ nĩ, kurã tỹ 40 ẽn ki. Kar kỹ tóg sir kókĩr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ti kókĩr nĩn kỹ Japo vỹ ti mỹ vĩ mũ. “Tỹ ã Topẽ kósin nĩ mỹr,” he tóg. “Ã tỹ tỹ Topẽ kósin nĩn kỹ pó tag tỹ ẽmĩ han nĩ, ã tỹ kon jé,” he tóg ti mỹ, Nén-Kórég ẽn ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Kỹ Jesus tóg ti mỹ: “hã ra tag tóg rán kỹ nĩ, ha mẽ,” he mũ. “Ẽmĩ tãvĩ jamẽn kỹ ẽg rĩnrĩr tũ nỹtĩ, Topẽ vĩ jamẽn kỹ ẽg rĩnrĩr nỹtĩ. Hã kỹ tóg sỹ ti vĩ mranh jãvãnh tĩ, ẽmĩ to,” he tóg, Jesus ti, Nén-Kórég ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kỹ Japo vỹ ti mré tãpry mũ. Kỹ tóg ti mỹ mundo ven kãn mũ, ũ tỹ kri ke kar ag ke gé. Ven pir ki tóg ti mỹ ven kãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kỹ tóg ti mỹ: “isũ vẽ mỹr,” he mũ, Japo ti. “Ã mỹ sóg tovãnh kãn sór mũ, ã tỹ tỹ vẽnh kar tag ag pã'i jẽ jé. Kỹ ti sĩnvĩ tag kar vỹ tỹ ã tũ nĩnh mũ. Isũ vẽ mỹr, ũ tỹn han ja ẽn tỹ inh mỹ: “té,” hen kỹ. Kỹ sóg sỹ ũn kuprẽg mũ ẽn mỹ vin tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ã hã mỹ sóg tovãnh sór mũ ha, ã tỹ inh krẽm grĩnh ken kỹ, ã tỹ iso: “Topẽ vỹ tỹ ã nĩ,” hen kỹ,” he tóg, Nén-Kórég ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kỹ Jesus tóg ti mỹ: “tag vỹ rán kỹ nĩ, ha mẽ,” he mũ. “Ẽg pã'i tỹ Topẽ hã krẽm ẽg tóg ẽg jakrĩ tỹ krỹ' he tĩ, ti hã to ẽg tóg: Topẽ vẽ, he tĩ,” he tóg, Topẽ vĩ tỹ rán kỹ nĩn ki. Hã kỹ sóg mranh jãvãnh nĩ,” he tóg, Jesus ti, Nén-Kórég mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kỹ Japo tóg ti mré tĩg mãn mũ, cidade tỹ Jerusalém ra. Tá tóg ti mỹ: “Topẽ jo ĩn kri jẽmnĩ, ti krĩ kri,” he mũ. Kỹ tóg ke mũ. Hã ra kãgnó tóg tá nĩ, Topẽ jo ĩn jo. Japo tóg Jesus mỹ: “Topẽ kósin vỹ tỹ ã nĩ,” he mũ. “Kỹ hũm hemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tag vỹ rán kỹ nĩ, ha mẽ: “ã tỹ jẽnẽ jafã ag mỹ tóg tónh mũ, Topẽ ti, kỹ ag tóg ã ki rĩr ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ãjag nĩgé tỹ ag tóg ã vyn ke mũ, kỹ ã tóg rỹj ke tũ nĩ. Ã pẽn vỹ rỹj ke tũ nĩ gé, hã jé ag tóg ã ki rĩr ke mũ,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ẽn ki. Kỹ jatun mỹ hũm nĩ,” he tóg, Nén-Kórég ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Kỹ Jesus vỹ ti mỹ ke mũ gé. “Kỹ tag vỹ rán kỹ nĩ gé, ha mẽ,” he tóg. “Topẽ mỹ: ã mỹ ã tỹ nén tó ja ẽn han mũ vỹ? he tũg nĩ,” he tóg mũ gé, Topẽ vĩ tỹ rán kỹ nĩ ẽn ki. Hã kỹ sóg Topẽ hã tỹ inh mỹ nén tó mũ ẽn han ke mũ, kỹ sóg hũm ke tũ nĩ, ti tỹ inh mỹ tó tũ nĩn kỹ,” he tóg, Jesus ti, Nén-Kórég mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kỹ Japo vỹ ã tỹ nén tónh ke ẽn tó kãn ja nĩ, hã kỹ tóg Jesus tovãnh mũ ver, ti tỹ kurã ũ kã ti mré vĩ mãn jé, kejẽn, ti tỹ ti mỹ há tĩ ve nĩn kỹ, Japo mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kỹ Jesus tóg tĩ mũ sir, Topẽ kuprĩg tỹ ti krĩn kỹ. Ga tỹ Galiléia ra tóg tĩ mũ. Kỹ vẽnh kar ti kãme mẽ kãn mũ sir, ga ẽn tá ke kar ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kỹ tóg ag kanhrãn mũ sir, Jesus ti, ag vẽnh kanhrãn jafã krẽm. Krẽm ag tóg Topẽ vĩ tó tĩ, Judeu ag. Jesus tỹ ag kanhrãn kỹ tóg ag mỹ e tĩ, ti vĩ ti. Hã kỹ ag tóg ti to vĩ há han mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kỹ Jesus tóg Nazaré tá jun mũ gé, ã jamã tá. Tá tóg mog ja nĩ, cidade tỹ Nazaré tá. Kỹ tóg ã tỹ nén han tĩ ẽn han mũ. Ag vẽnh kanhrãn jafã ra tóg tĩ mũ, vẽnh kán ke kurã ki. Tá tóg sir jẽgnẽ mũ, culto ki, ag vẽnh mãn kỹ nỹtĩ ẽn ki. Ti tỹ Topẽ vĩ to ke sór vẽ, hã kỹ tóg jẽgnẽ mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ti jẽ kỹ ag tóg ti mỹ livro nĩm mũ, Isaías tỹ rán ja ẽn ti, vãsỹ Topẽ vĩ tó tĩ tỹ rán ja ẽn ti. Kỹ tóg livro tỹ vym ke mũ. Kỹ tóg ã tỹ to ke sór mũ ẽn vég mũ, Isaías tỹ tó ja ti, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Topẽ kuprĩg vỹ inh krĩn mũ,” he tóg. “Inh jagrẽ vẽ mỹr, hã kỹ tóg inh krĩn mũ. “Ũn jagãgtar ag mỹ inh vĩ tómnĩ,” he tóg inh mỹ. Inh jẽnẽg tóg mũ, isỹ ũn sigse kỹ nỹtĩ ag kygvãn jé, isỹ ũn kyvó ag tỹ ẽvãnh (há) han jé, isỹ ag tỹ ũn vóg kónãn mũ ag ki rĩr há han jé, ag jatu nỹtĩ jé, ");
INSERT INTO kgpNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","isỹ vẽnh kar mỹ: “ũri ẽg jóg mág vỹ ẽg kren han sór mũ,” he jé,” he tóg, Isaías ti, vẽnh rá ki. Hã to ke tóg mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tag to ke kar kỹ tóg livro ẽn kri tỹ tam ke mãn mũ. Livro ki rĩr tĩ ẽn mỹ tóg jun mũ, livro ti. Kỹ tóg nĩ mũ sir. Hã ra vẽnh kar ag tóg ti ki ẽvãnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kỹ tóg ag mỹ kãmén mũ, kỹ tóg: “vãsỹ rán kỹ nĩ ja tag mẽ ãjag tóg,” he mũ. “Ũri ke vẽ, ũri ãjag tóg vég mũ, vãsỹ rán kỹ nĩ ja ẽn ti,” he tóg. “Inh hã to tóg tag tó ja nĩ, Isaías ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ag tỹ ti vĩ mẽ kỹ tóg ag mỹ e tĩ sir. “Ki hã tóg tó mũ, hã kỹ tóg ẽg mỹ e tĩ,” he ag tóg mũ. Kỹ ag tóg ti to vĩ mũ gé. “José kósin vẽ mỹr, ẽg mré ke ẽn, hã ra tóg ẽg vĩ kãfór han sór mũ,” he ag tóg mũ ti to. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kỹ Jesus tóg ag mỹ: “ãjag hỹn iso jykrén sór mũ,” he mũ. “Médico mỹ ẽg tóg: “kur vẽsỹ há' hé, ã tỹ tỹ médico nĩ sór nĩn kỹ,” he tĩ. Ãjag hỹn tag tó sór mũ inh mỹ. Ãjag hỹn inh mỹ: “cidade tỹ Cafarnaum tá ã tóg ag tỹ há' hé, ũn kagyga ag tỹ, kỹ kur tag ki ẽg tỹ há' hemnĩ gé, ã jamã tag ki, ã tỹ vẽnh kar tỹ há' he sór nĩn kỹ,” he sór ãjag hỹn mũ inh mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kỹ tóg ag mỹ: “ti jamã tá ke ag ne tóg Topẽ vĩ tó tĩ ẽn to é he tĩ',” he mũ. “Ti tỹ ke há vẽ. Hã kỹ ãjag tóg iso é he tĩ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","“Ha mẽ, sỹ nén tó mũ ti. Elias to jykrén nĩ. Ti tỹ ga kri tĩ mũ kỹ tóg ta kutẽ vãnh han ja nĩgtĩ, prỹg tãgtũ kri kysã tỹ 6 (ke) ki. Kỹ tóg prỹg tĩ sir, ga ẽn mĩ, vẽjẽn tóg tũ' he mũ sir. Kỹ Topẽ tóg Elias mỹ tó, ti tỹ cidade tỹ Sarepta ra tĩg jé, cidade tỹ Sidom kakó ra. Tá fóg fi tóg nĩ nĩ, ũn mén ter ja fi. Fi mré tóg jẽg tĩ sir, Elias ti, fi tỹ ti mỹ vẽjẽn tỹ vẽnh kãpãm kỹ, prỹg ra. Topẽ pi(jé) Israel fi to ti jẽnẽ ja nĩgtĩ'. Ti pi(jé) ti jamã ra ti jẽnẽ ja nĩgtĩ'. Tá fag tóg e nỹtĩ ja nĩgtĩ gé, ũn mén ter ja fag. Hã ra Topẽ tóg fóg ẽn fi to ti jẽnẽ ja nĩgtĩ, fi tỹ ti ki rĩr jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Kỹ Eliseu to jykrén nĩ gé, vãsỹ Topẽ vĩ tó tĩ ẽn to. Ti tỹ ga kri tĩ nĩn kỹ ũn kagyga ag tóg e ja nỹtĩgtĩ gé, ẽg povo tỹ Israel kãmĩ, vẽnh kaga kren vãnh han mũ ag, vẽnh kaga tỹ lepra han mũ ag. Hã ra ag tóg ti mỹ to vĩ ja tũ nĩgtĩ, ti tỹ ag tỹ há' hen jé. Kuvar há tá tóg kãtĩg ja nĩgtĩ, fóg ti, Naamã ti, ga tỹ Síria tá ke ẽn ti. Kỹ ti hã ne tóg Eliseu mỹ to vĩn kỹ há' he mũ sir inhhã. Ti kaga kren vãnh ẽn tóg tũ' he mũ sir. Ge ãjag tóg nĩgtĩ iso. Kuvar há tá ke fag vỹ inh ki ge tĩ, jãvo ãjag tóg inh ki ge jãvãnh nỹtĩ, ãjag tỹ tỹ inh jamã tá ke nỹtĩ ra,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kỹ ũ tỹ ti vĩ mẽg mũ ag fe tóg gỹm ke mũ sir, Jesus to, ũ tỹ vẽnh kanhrãn jafã ẽn krẽm nỹtĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jẽgjẽg nẽgnẽ ag tóg mũ sir. Kãpa ag tóg mũ sir. Ti vóg ag tóg mũ sir, pãnónh ra. Nazaré vỹ pãnónh tá nĩ, ag jamã ti. Pãnónh ẽn to jãpry kỹ ag tóg tá ti kutẽm sór mũ, kãgnó ki ti ter jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hã ra Jesus tóg ag ré kỹ tĩ mũ, ag jãmĩ. Ti tỹ hẽ ri ke tũ ag tóg nĩ sir, kỹ tóg ag fĩn rãm kỹ ag ré kỹ tĩ mũ. Hã ra ag tóg ti vĩ kri fi jãvãnh nỹtĩ, ti jamã tá ke ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kỹ Jesus tóg cidade tỹ Cafarnaum ra tĩ mũ. Ga tỹ Galiléia tá ti nĩ, Cafarnaum ti. Tá jun kỹ tóg ag kanhrãn mũ, vẽnh kán ke kurã ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kỹ tóg ag mỹ e tĩ, ag tỹ ti vĩ mẽn kỹ. Ti vĩ vỹ vẽnh kar vĩ kãfór nĩ, hã kỹ tóg ag mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kỹ vẽnh kanhrãn jafã ẽn krẽm ũ tóg nĩ nĩ. Jagrẽ kórég ti nĩ. Kỹ tóg prẽr mũ, kỹ tóg: ");
INSERT INTO kgpNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ha mẽ, ã tỹ ẽg tỹ hẽ ri kenh ke nẽ, Nazaré tá Jesus'?” he mũ. “Ã mỹ ẽg tũg sór mũ'?” he tóg. “Ã ki kanhró sóg nĩ. Tỹ ã tóg ã pir mỹ Topẽ mré ke nĩ, ti tũ pẽ vỹ tỹ ã nĩ,” he tóg, ũn jagrẽ kórég ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hã ra Jesus tóg ti mỹ vĩ tar han mũ, kỹ tóg: “vĩ tũg ra,” he mũ. “Ti tovãnh ra,” he tóg. Kỹ ti jagrẽ kórég ẽn tóg ti ter tĩ han mũ, vẽnh kar rĩnve, kỹ tóg ti ki kutẽ mũ sir. Ti kókég tũ tóg nĩ, ti jagrẽ kórég ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kỹ tóg vẽnh kar mỹ e pẽ tãvĩ tĩ sir. Jagnẽ mỹ ag tóg: “ne nẽ hỹn vé'?” he mũ. “Vẽnh jagrẽ kórég ag mỹ tóg vĩ tĩ, Jesus ti, kỹ ag tóg sir ki króm tĩ, ti vĩ ki, ti kamẽg kỹ, ti tỹ ag pan kỹ. Ti hỹn tỹ ag kri ke nĩ,” he ag tóg mũ sir, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kỹ ti kãme tóg vẽnh kar kri rũm ke kãn mũ sir, ga ẽn tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kỹ Jesus tóg vẽnh kanhrãn jafã ẽn ki kutẽ kỹ Simão ĩn ra tĩ mũ. Hã ra Simão prũ fi mỹnh fi tóg kaga nỹ nĩ. Rỹ jagy fi nỹ nĩ. Kỹ ag tóg Jesus mỹ fi tó mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kỹ tóg fi vẽnh tĩ mũ. Fi krĩ tá jẽ kỹ tóg fi mỹ: “rỹg mãn tũg nĩ,” he mũ. Kỹ fi rỹ ẽn tóg tũ' he mũ sir. Kỹ fi tóg vẽsỹmér nĩ nĩ. Ag ki rĩr fi tóg mũ sir, Simão má fi. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kỹ tóg sir kutyg mũ, rã tỹ pun ke kỹ. Kỹ ag tóg ũn kagyga ag tatĩn kãmũ kãn mũ. Kỹ tóg ã nĩgé tỹ ag mẽ kãn mũ, Jesus ti, kỹ ag tóg hághá' he kãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Vẽnh jagrẽ kórég pan kãn tóg mũ gé, ag to jũ kỹ. Ag panh ke to hã ag tóg prẽr mũ, kỹ ag tóg: “Topẽ kósin vỹ tỹ ã nĩ,” he tĩ. Hã ra tóg ag mỹ: “vĩ tũg ra,” he mũ. Ti ki kanhró ag tóg nỹtĩ, ti tỹ tỹ Cristo nĩ ti. Hã kỹ tóg ag mỹ: “vĩ tũg ra,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tỹ vaj kỹ Jesus tóg tá kutẽ kỹ ẽmã tũg ja ra tĩ mũ. Kỹ vẽnh kar ag tóg ti jãvãnh kãn mũ. Hã ra ag tóg ti vég mũ. Ti ve kỹ ag tóg ti mỹ: “ẽg ré kỹ tĩ tũg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hã ra tóg ag mỹ: “vó,” he mũ. “Cidade ũ ra sóg tĩg mũ, sỹ ag mỹ Topẽ vĩ tó jé gé, Topẽ tỹ tỹ ẽg pã'i nĩnh ke ti. Hã jé Topẽ tóg inh mỹ: “ha ag mỹ vẽnh ven,” he ja nĩ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kỹ tóg tĩ mũ sir. Ga tỹ Judéia mĩ tóg tĩ mũ. Vẽnh kanhrãn jafã krẽm tóg ag mỹ Topẽ vĩ tó tĩ mũ sir, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kejẽn Jesus tóg goj nig tỹ Genesaré fyr tá jẽ nĩ, Topẽ vĩ kãmén kỹ. Kỹ vẽnh kar vỹ ti pénĩn nỹtĩ nĩ, kỹ ag tóg ti kutãn mũ sir, ag e tãvĩ nỹtĩn kỹ, ag tỹ Topẽ vĩ mẽ sór kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ag tỹ ti kutãn kỹ tóg canoa régre vigvég mũ, nig fyr tá. Pirã kugmĩg tĩ ag vỹ tá kãpa kỹ nỹtĩ nĩ. Goj kãki jẽgjẽg kỹ ag tóg pirã kugmĩ jafã kunũnh kỹ kupég nỹtĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kỹ Jesus tóg canoa kãra rã mũ. Simão tũ vẽ, canoa ẽn ti. Kỹ tóg Simão mỹ: “tĩg sĩ han ra, canoa kãmĩ, goj kuju ra,” he mũ. Kỹ Simão tóg tĩ mũ. Hã ra Jesus tóg canoa kãkã nĩ nĩ, ti mré. Kãkã nĩ kỹ tóg ag kanhrãn mũ sir, vẽnh kar ẽn ag, ũ tỹ ti kutãn ja ẽn ag. Goj fyr tá ag tóg nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ti tỹ ag kanhrãn kãn kỹ tóg Simão mỹ: “goj kuju ra tĩg, ti nig ja ra,” he mũ. “Tá ã rede tỹ goj kãki fón, ã tỹ pirã kugmĩ jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kỹ Simão tóg ẽg Senhor mỹ: “hã ra ẽg tóg kuty tag kã goj ki ti fón', fón' he ja nĩgtĩ, fagrĩnh mỹ,” he mũ. “Nén ũ kãgmĩg tũ ẽg tóg nĩ mỹr,” he tóg. “Hã ra sóg ã vĩ tugrĩn ki fón sór mũ ha,” he tóg, Simão ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kỹ tóg ke mũ sir. Kỹ tóg kugmĩ mág mũ. Fór tóg nĩ, rede ti, kỹ tóg jaran ke mũ, ti kufy jagy tãvĩ nĩn kỹ, pirã e tugnĩn. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kỹ ag tóg ãjag régre ag mỹ ven mũ, ag tỹ canoa ũ kãki kãmũ jé. Ag tỹ tá junjun kỹ ag tóg canoa régre ẽn fãn mũ, pirã tỹ. Funfór ti nỹtĩ, hã kỹ tóg ki punpun ke kren mũ sir, canoa régre ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kỹ Simão tóg Jesus krẽm grĩnh ke mũ. Ti mỹ tóg e tĩ, pirã e ẽn to, kỹ tóg Jesus krẽm grĩnh ke mũ. Kỹ tóg ti mỹ: “Senhor',” he mũ. “Ã hỹn inh ré kỹ tĩg mũ ha. Topẽ vĩ mranh ja inh nĩgtĩ, kỹ inh hỹn ã mỹ kórég nĩ ha,” he tóg, Simão ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ti mỹ tóg e pẽ tãvĩ tĩ, ti tỹ pirã e ẽn ven kỹ, ti tỹ Jesus jykre ven kỹ. Ti mré ke ag mỹ tóg e tĩ gé, ");
INSERT INTO kgpNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiago mỹ ke gé, João mỹ ke gé, Zebedeu krẽ tag ag mỹ. Simão régre ag vẽ, Zebedeu krẽ tag ag, ti companheiro ag vẽ. Kỹ Simão tóg Jesus mỹ: “ã hỹn inh ré kỹ tĩg mũ ha,” he mũ. Hã ra Jesus tóg ti mỹ: “kamẽg tũg nĩ,” he mũ. “Pirã kugmĩ há ã tóg jẽ. Ã kanhrãn jé sóg ke mũ, ã tỹ ẽprã ke ag tỹ inh ki ge han jé,” he tóg, Simão mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kỹ ag tóg ãjag canoa vóg mũ, goj fyr ra. Tá junjun kỹ ag tóg ãjag tũ kar ré kỹ mũ mũ sir, Jesus mré. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kỹ tóg kejẽn cidade ũ tá nĩ nĩ. Kỹ ũ tóg ti tá jun mũ, ũ tỹ vẽnh kaga kren vãnh han kỹ nĩ ti, vẽnh kaga tỹ lepra he mũ ẽn. Ti kri tóg rũm ke kãn ja nĩ, vẽnh kaga ti. Ẽn tóg Jesus tá jun kỹ ti krẽm mũg ke mũ, kỹ tóg ti mỹ: “Senhor',” he mũ. “Ã mỹ isỹ há' he sór tũ nĩ'?” he tóg. “Ã hã tóg isỹ há' henh mũ, ã tỹ isỹ há' he sór kỹ,” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kỹ Jesus tóg ã nĩgé tỹ ti mẽg mũ, kỹ tóg ti mỹ: “hej,” he mũ. “To sóg há nĩ, há' he ja há ã tóg nĩ,” he tóg ti mỹ. Kỹ tóg ti kaga kren vãnh tỹ há' he mũ sir vẽsỹmér. Jãnhkri' he tóg mũ, ti fár ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kỹ Jesus tóg ti mỹ ke mũ, ti tỹ ũ mỹ tó tũg jé, ti tỹ há' he tag ti. “Ha tĩg,” he tóg. “Topẽ tũ ki rĩr tĩ to tĩg. Ti hã mỹ tómnĩ, kỹ ti mỹ nén ũ nĩm nĩ, ti tỹ Topẽ mỹ pũn jé, Moisés tỹ vãsỹ ẽg mỹ nén tó ja ẽn ti, ã jãnhkri to. Hã tugrĩn vẽnh kar vỹ ã tỹ há' he mũ tag ki kanhrãn mũ,” he tóg ti mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ge ra ti kãme tóg vẽnh kar kri rũm ke mũ, kỹ ũ tỹ hẽn ri ke ag tóg vẽnh mãn mũ sir. Ag tỹ ti vĩ mẽ sór vẽ, ag tỹ ãjag tỹ há' he ẽn ve sór vẽ gé. Hã jé ag tóg sir vẽnh mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hã ra Jesus tóg ẽmã tũg ja ra tĩ mũ, Topẽ mré vẽmén jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kejẽn tóg ag kanhrãnrãn mãn mũ. Kỹ Fariseu ũ ag tóg ti vĩ mẽgmẽg mũ gé sir, Topẽ vĩ to professor ag mré hã. Kór há tá ag tóg kãmũ ja nĩ, ga tỹ Galiléia tá, ga tỹ Judéia tá ke gé, cidade tỹ Jerusalém tá ke gé. Jesus pénĩn ag tóg nĩgnĩ kỹ nỹtĩ nĩ. Hã ra Topẽ tóg ti tar han ja nĩ, hã kỹ tóg ũ tỹ hẽn ri ke ag tỹ há' he mũ, ũn kagyga ag tỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kỹ vãhã ũ ag tóg tá junjun mũ gé. Ũ va ag tóg kãmũ jẽg, kur kã, ũn kãnhgrĩ, ũn kónhgrĩ. Ag tỹ Jesus mỹ ti ven sór vẽ, ag tỹ ti krẽm ti fi sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hã ra tóg fór tãvĩ nĩ, tá, kỹ ag tóg ti tá junjun tũ nĩ sir, Jesus tá. Kỹ ag tóg ĩn to jãpry kỹ ti kri ĩn kunũg mũ. Ti nor ẽn ki ag tóg ti térem mũ, Jesus jẽ ẽn kukãm. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kỹ Jesus tóg ag tỹ ti ki ge kỹ nỹtĩ tag vég mũ. Hã kỹ tóg ũn kãnhgrĩ mỹ: “ã tỹ Topẽ vĩ mranh ja ẽn tỹ tũ' he vẽ ha, vỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hã ra ti vĩ tag tóg Topẽ vĩ to professor ag mỹ e tĩ, Fariseu ag mỹ ke gé. Kỹ ag tóg ti vĩ tag to jykrén kónãn mũ. “Ti tỹ ne tó nẽ hỹn'?” he ag tóg mũ. “Topẽ to vĩ kónãn vẽ mỹr, ti vĩ tag to,” he ag tóg. “Topẽ hã ne ã pin kỹ Topẽ vĩ mranh ẽn tỹ tũg' he há nĩnh mũ', kỹ ti tỹ vẽsỹ tỹ Topẽ han vẽ sir, ti mỹ vẽnh pãte fón sór kỹ,” he ag tóg mũ, to jykrén kónãn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hã ra Jesus tóg ag tỹ nén to jykrén mũ vég mũ. Kỹ tóg ag mỹ: “ãjag tỹ ne jé to jykrén kónãn nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Ne nỹ ãjag mỹ vẽnhmỹ nỹ?” he tóg. “Ũn tĩg vãnh mỹ sóg: “ã tỹ Topẽ vĩ mranh ja ẽn tỹ tũ' he vẽ ha,” hé. Kỹn mỹ ãjag mỹ vẽnhmỹ?” he tóg. “Sỹ ti mỹ: “nĩ ra, tĩg ra,” henh ke vẽ gé. Kỹn mỹ ãjag mỹ vẽnhmỹ ke gé?” he tóg, tag to. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","“Hã ra sỹ ãjag mỹ inh jykre ven sór vẽ ha. Tỹ sóg ẽprã ke fi kósin nĩ. Tá sóg krỹg ke mũ, Topẽ vĩ mranh tỹ vẽnh pãte fón ke tá. Sỹ tá krỹg mũ ven jé sóg ke mũ ãjag mỹ,” he tóg. Hã kỹ tóg ũn kónhgrĩ mỹ: “nĩ ra, ã kur gég tĩg, ã ĩn ra,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kỹ tóg vẽsỹmér jẽgnẽ mũ sir. Ã kur gég tóg mũ vãhã, ag rĩnve. Ã ĩn ra tóg tĩ mũ, Topẽ mỹ vĩ há han kỹ, ũn kãnhgrĩ ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kỹ tóg vẽnh kar mỹ e tãvĩ tĩ. Topẽ mỹ ag tóg vĩ há han mũ gé, ti to: “ẽg kãfór ti nĩ,” hen kỹ. “Ge ve ja tũ ẽg nỹtĩ, kỹ ẽg tỹ ne to jykrén ke tóg tũ tĩ,” he ag tóg mũ sir, Jesus tỹ ũn kãnhgrĩ ja ẽn tỹ há' hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kar kỹ Jesus tóg tĩg mãn mũ. Kỹ tóg ũ tỹ governo mỹ jãnkamy mãg tĩ ũ vég mũ, imposto mãg tĩ ẽn ti. Ti jijin hã vỹ: Levi, he mũ. Ã rãnhrãj han kỹ tóg nĩ nĩ, ti rãnhrãj jafã krẽm, Jesus tỹ ti ve kỹ. Kỹ tóg ti mỹ: “inh mré kãtĩg,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kỹ tóg jẽgnẽ mũ sir. Ti mré tóg tĩ mũ sir, ã tũ kar ré kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kỹ Levi tóg ti mỹ festa mág han mũ, ti ĩn tá. Kỹ ti tỹ festa to ũn jé prẽr mũ ag vỹ tỹ ũ tỹ hẽn ri ke nỹtĩ, festa venh kãmũ mũ ẽn ag. Governo mỹ jãnkamy mãg tĩ ũ ag vẽ, ag mré ke ũ ag mré hã. Jesus mré ag tóg jẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kỹ Fariseu ag tóg vég mũ, Topẽ vĩ to professor ag ke gé, kỹ tóg ag mỹ kórég tĩ. Kỹ ag tóg ũ tỹ Jesus mré mũ tĩ ag to vĩ mũ gé. Ag mỹ ag tóg: “ãjag hã ne tóg governo mỹ jãnkamy mãg tĩ ag mré jẽg mũ',” he mũ. “Topẽ vĩ mranh tĩ ag mré ãjag tóg jẽg mũ',” he ag tóg, ũ tỹ Jesus mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hã ra Jesus tóg ag mỹ kãmén mũ. “Hỹ, ag mré sóg jẽg mũ,” he tóg. “Hã ra ũn kagyga tũ ag vỹ médico venh mũ tũ nĩgtĩ,” he tóg mũ. “Ũn kagyga ag hã vỹ ti venh mũ tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","“Inh pi(jé) ũ tỹ vẽnh jykre kuryj han mũ ag mỹ: “ãjag jykre tovãnh ra,” he sór tĩ'. Ũ tỹ Topẽ vĩ mranh ja ẽn ag hã mỹ sóg: “ãjag jykre kórég tovãnh ra,” he sór tĩ. Hã jé sóg ãjag mỹ vẽnh ven,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kỹ Fariseu ag tóg ti mỹ ke mãn mũ. “João mré mũ tĩ ag vỹ vãkre (ka)mẽ nỹtĩgtĩ, vẽjẽn ki, kỹ ag tóg Topẽ mré vĩ (ka)mẽ han tĩ gé, ag vãkre kỹ. Kỹ Fariseu mré ke ag tóg ge nỹtĩgtĩ gé. Hã ra ã mré mũ tĩ ag tóg ge tũ nỹtĩ. Jẽg ag tóg mũgtĩ, kurã kar ki. Vãkre vãnh ag nỹtĩ, ẽg vãkre kurã ki,” he ag tóg mũ sir, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kỹ tóg ag mỹ: “hỹ,” he mũ. “Hã ra vẽnh prũg tỹ festa to kãmũ ag pi(jé) vãkrég tĩ',” he tóg. “Festa vẽ mỹr, vẽnh prũg ti, kỹ ti mré ke ag tóg ũn prũg mũ ẽn venh kãmũ tĩ. Hã ra sóg tỹ ũn prũg mũ ẽn ri ke nĩ, hã kỹ tóg inh mré mũ tĩ ag mỹ sér tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","“Vãhã tóg jun mũ, inh kurã ti. Ẽn kã ag tóg inh pére mũnh mũ. Ẽn kã hã ag tóg ãjag vãkrenh ke venh mũ, kurã ẽn kã, inh mré mũ tĩ ag,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kỹ tóg ag mỹ comparação han mũ, kỹ tóg: “inh jykre tãg vỹ ge nỹnh mũ,” he mũ. “Ẽg pi(jé) ẽg kur tãg kókég tĩ', ẽg tỹ ẽg kur si jar kã nĩm jé,” he tóg. “Ke tũ nĩ mũ ra ẽg tóg ẽg kur há ẽn kókég mũ, hã ra tóg ẽg kur si ẽn ki par tũ nĩgtĩ gé, ũn há ti. Kỹ ẽg kur tóg kórég kar nỹtĩ nĩ sir,” he tóg. Ti tỹ ã jykre tãg tó vẽ, hã ra tóg kur tãg ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kỹ tóg ag mỹ: “vinho vỹ ge nĩgtĩ gé,” he mũ gé. “Ẽg pi(jé) vinho kajãg mũ tỹ ti fár si tỹ saco ki kujẽg tĩ', vinho tãg ẽn ti'. Ke tũ nĩ mũ ra tóg kunãnh kỹ jar mũ. Kỹ vinho ẽn tóg tũ' he mũ, bolsa ke gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Vinho kajãg mũ tỹ ti fár tãg tỹ bolsa ki kujẽn ke vẽ mỹr,” he tóg. Ti tỹ ã jykre tãg tó vẽ, hã ra tóg vinho kajãg mũ ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kỹ tóg ag mỹ: “ẽg pi(jé) vinho si kron kỹ ũn kajãg kron sór tĩ', ũn tãg ẽn ti',” he mũ gé. “Ti si hã tóg ẽg mỹ há nĩ,” he ẽg tóg tĩ,” he tóg, Jesus ti. Ti tỹ ã jykre tãg tó vẽ, hã ra ag jykre si tóg ag mỹ há tĩ, ũ tỹ ti vĩ mẽg mũ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kejẽn tóg vẽnhkán ke kurã tá krỹg mũ. Kỹ Jesus tóg ẽpỹ mĩ tĩ mũ, trigo jo ẽpỹ mĩ. Ti mré mũ tĩ ag tóg ti mré mũ mũ. Hã ra ag tóg sir trigo mó ẽn tỹ kam ke mũ sir. Ãjag nĩgé tỹ ag tóg rynhranh mũ, ag tỹ ti kanẽ ko jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hã ra Fariseu ũ ag tóg ag vég mũ. Ag mỹ vẽnh rãnhrãj vẽ, ag tỹ trigo rynhranh mũ ti. Hã ki ag tóg ag mỹ Topẽ vĩ mranh mũ, ag tỹ vẽnhkán ke kurã ki rãnhrãj kỹ. Hã kỹ ag tóg ag mỹ: “ãjag ne tóg nén han ke tũ han mũ nĩ', vẽnhkán ke kurã ki',” he mũ. “Vẽnh rãnhrãj vẽ mỹr', ãjag tỹ nén han mũ ti,” he ag tóg, Jesus mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hã ra Jesus tóg ag mỹ: “vó,” he mũ. “Ag kókĩnkĩr vẽ mỹr,” he tóg. “Davi to jykrén nĩ, ti mré mũ tĩ ag to ke gé. Ti kókĩr kỹ tóg ã tỹ nén han ke tũ han gé, hã ra Topẽ pi(jé) ti to jũ mũ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","“Topẽ jo ĩn kã ra tóg rã, Davi ti. Tá tóg Topẽ jamĩ ẽn kó. Ti tỹ konh ke tũ vẽ vẽ, Topẽ tũ ki rĩr tĩ ag hã tỹ konh ke vẽ vẽ. Hã ra tóg kó, ã mrẽ mũ tĩ ag mỹ tóg vẽnh kãpópãm gé, Davi ti. Rán kỹ tóg nĩ nĩ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kỹ tóg ag mỹ: “tỹ sóg vẽnhkán ke kurã to pã'i nĩ mỹr,” he mũ. “Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Vẽnhkán ke kurã ũ kã Jesus tóg Israel ag tỹ vẽnh kanhrãn jafã kãra rã mũ, ag kanhrãn jé. Tá ũ tóg jẽ nĩ. Ti nĩgé vỹ tóg ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kỹ Topẽ vĩ to professor ag tóg Jesus tugnỹm mũ, Fariseu ag ke gé, ag tỹ ti tỹ há' he mũ ẽn ven jé. “Ti mỹ ti tỹ há' he sór tũ, tỹ ẽg vẽnhkán ke kurã (hã) ra'?” he ag tóg. “Ti tỹ ti tỹ há' he kỹ ẽg tóg ti kãmén mũ, pã'i ag mỹ, ti tỹ vẽnhkán ke kurã kã rãnhrãj mũ ti,” he ag tóg. Hã kỹ ag tóg ti tugnỹm mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hã ra Jesus tóg ag tỹ nén to jykrén vég jẽ nĩ. Kỹ tóg ũn nĩgé tóg ẽn mỹ: “kunĩg,” he mũ. “Tag kã jẽnh nĩ,” he tóg ti mỹ. Kỹ tóg kãtĩg kỹ kã jẽ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kỹ tóg ag mỹ: “sỹ ãjag ki jẽmẽnh há tóg tĩ,” he mũ. “Vẽnhkán ke kurã ki ẽg hỹn ne han mũ'?” he tóg, “ẽg tỹ Topẽ vĩ ki króm jé?” he tóg. “Ẽg mỹ nén ũ há han mũ'? Ẽg tỹ ũ tũ kókén kỹn mỹ kórég tũ nỹnh mũ hỹn'?” he tóg. “Ẽg mỹ ũ kren han mũ hỹn'? Ẽg tỹ ũ tén kỹn mỹ kórég tũ nĩnh mũ hỹn'?” he tóg. Hã ra ag tóg ti mỹ nén ũ tó tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kỹ tóg ag ki ẽvãnh kãn kỹ ũn nĩgé tóg ẽn mỹ: “ã nĩgé tỹ krỹg hé,” he mũ. Kỹ tóg tỹ krỹg he mũ sir. Ti tỹ tỹ krỹg he kỹ tóg há' he mũ, ti nĩgé tóg ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kỹ tóg vẽnh kar mỹ e tĩ. Ag fe tóg gỹm ke mũ, kỹ ag tóg jagnẽ mré vẽmén mũ. “Ẽg hỹn ti tỹ hẽ ri kenh mũ hỹn', ti kãgmĩnh mũ vó?” he ag tóg, Jesus to. Hã ra tóg ũn nĩgé tóg ẽn tỹ há' he ja nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ẽn kã Jesus tóg kejẽn pãnónh ra tĩ mũ, ti tỹ Topẽ mré vẽmén jé. Kuty ẽn kã tóg Topẽ mré vĩ nĩ ki kurãg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tỹ vaj kỹ tóg ã mré mũ tĩ ag jé prẽr kãn mũ, kỹ tóg ag kãmĩ ũ tỹ 12 (ke) ẽn ag kuprẽg mũ. Ag to tóg: “sỹ ũn vin mũ ẽn ag,” he mũ, hã vỹ: apóstolo, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ag hã vẽ, ha mẽ: Simão, Jesus tỹ ti jyjy ũ hã vỹ: Pedro, he mũ, ti jãvy tỹ André ke gé, Tiago ke gé, ti jãvy tỹ João mré, Filipe ke gé, Bartolomeu ke gé, ");
INSERT INTO kgpNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus ke gé, Tomé ke gé, Tiago ke gé, Alfeu kósin tag ti, Simão ke gé, ag tỹ ũ to: Zelote, he mũ tag ti, ");
INSERT INTO kgpNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ke gé, Tiago kósin tag ti, Judas Iscariotes ke gé, ũ tỹ Jesus vatánh tá pã'i ag mỹ ti kãmén ke tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kỹ Jesus tóg ag mré pãnónh ẽn to tére mũ sir, kỹ tóg kyjer tá jẽ nĩ. Kỹ ti mré mũ tỹ hẽn ri ke ag vỹ tá nỹtĩ gé. Ũ tỹ hẽn ri ke ag vỹ ti ki junjun ja nĩgtĩ, ga tỹ Judéia tá kãmũ kỹ, cidade tỹ Jerusalém tá ke gé, goj kafã tũ fyr tá ke gé, hã vỹ: cidade tỹ Tiro, he mũ, cidade tỹ Sidom, he mũ gé. Ẽn kar vỹ ti ki junjun ja nĩgtĩ, ti tỹ ag tỹ há' he jé. Kỹ tóg fór pẽ nĩ, tá, ag tỹ e pẽ tãvĩ nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ũn jagrẽ kórég ag tỹ tóg há' he mũ gé, ag jagrẽ pan tóg mũ, Jesus ti, fag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kỹ vẽnh kar vỹ ti kã krỹ' he sór mũ sir, hã jé ag tóg ti ki junjun mũ. Kỹ ũ tỹ ti kã krỹ' he mũ ẽn ag vỹ há' he kãn mũ, ti tỹ ã jykre tar tỹ ag tỹ hághá' hen kỹ. Hã jé ag tóg vẽnh mãn ja nĩ. Hã kỹ ag tóg ti pénĩn e tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kỹ tóg ã mré mũ tĩ ag ki ẽvãnh mũ, kỹ tóg ag mỹ kãmén mũ, Jesus ti, kỹ tóg: “Topẽ vỹ ãjag ve há han mũ, ãjag tỹ: “kórég eg tóg nỹtĩ,” hen kỹ,” he mũ. “Kỹ ãjag tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Topẽ vỹ ãjag ve há han mũ, ãjag tỹ: “inh kókĩr ri ke tóg tĩ, sỹ vẽnh jykre kuryj ve sór tĩ ẽn ti,” hen kỹ. Kỹ ãjag tóg venh ke mũ,” he tóg. “Topẽ vỹ ãjag ve há han mũ, ãjag vẽsỹrénh mũn kỹ, ẽprã. Ãjag mỹ sér nĩ jé tóg ke mũ, tá,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Topẽ vỹ ãjag ve há han mũ, ag tỹ ãjag to kórég nỹtĩn kỹ isugnĩn, ag tỹ ãjag mỹ: “ha mũ jẽg,” hen kỹ, isugrĩn. Ag tỹ isugnĩn ãjag mỹ vĩ kónãn kỹ tóg há tĩ, ag tỹ ón kỹ ãjag jykre kórég tó kỹ. Tỹ sóg ẽprã ke fi kósin nĩ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Mỹ sér nỹtĩmnĩ, ãjag fe tỹ mrin kemnĩ, ag tỹ isugrĩn ãjag vóg kónãn mũ ra. Kỹ ãjag tóg kanhkã tá nén ũ há kar venh ke mũ, vẽnh kaja jé, isugnĩn. Ge ja ag tóg nỹtĩ ja nĩgtĩ, ũ tỹ ãjag vóg mũ ag jóg'jóg ag, vãsỹ Topẽ vĩ tó tĩ ag mỹ. Ag vóg kónãn ja ag tóg nĩ gé. Vãsỹ Topẽ vĩ tó tĩ ẽn ag ri ke ãjag tóg nỹtĩ, ag krẽ'krẽ tỹ ãjag vóg kónãn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Hã ra Topẽ vỹ ãjag ve kónãn mũ, ãjag tỹ: “há ẽg tóg nỹtĩ,” hen kỹ. Ga kri mũn kỹ ãjag tóg nén ũ há vég tĩ, kỹ ãjag tóg kanhkã tá jun ke tũ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Topẽ vỹ ãjag ve kónãn mũ, ãjag tỹ vẽnh jykre kuryj ve sór tũ nỹtĩn kỹ, ti tỹ ãjag mỹ ãjag kókĩnkĩr ri ke tũ nĩn kỹ, ẽprã. Kỹ ãjag tóg venh ke tũ nĩ. Kỹ tóg ãjag kókĩnkĩr ri ke tĩnh mũ, tá,” he tóg. “Topẽ vỹ ãjag ve kónãn mũ, ti tỹ ãjag mỹ sér tĩn kỹ, ẽprã. Vẽsỹrénh jé ãjag tóg ke mũ, kygfỹ jé ãjag tóg ke mũ, tá,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Topẽ vỹ ãjag ve kónãn mũ, vẽnh kar tỹ ãjag to vĩ há han mũn kỹ. Ãjag mỹ ti há tĩ, vẽnh kar tỹ ãjag to vĩ há han mũn kỹ, hã ra tóg Topẽ mỹ kórég nĩ. Ge ja ag tóg nỹtĩgtĩ, ũ tỹ ãjag mỹ vĩ há han mũ ẽn jóg'jóg ag, ón kỹ Topẽ vĩ tó (ka)mẽ ẽn ag mỹ, vãsỹ. Ag mỹ ag tóg vĩ há han ja nĩ gé. Ag ri ke ãjag tóg nỹtĩ, ón kỹ Topẽ vĩ tó (ka)mẽ ẽn ri ke ãjag tóg nỹtĩ, vẽnh kar tỹ ãjag mỹ vĩ há han kỹ. Hã kỹ tóg ãjag ve kónãn mũ, Topẽ ti,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ãjag jyvẽn sóg mũ, ãjag tỹ inh vĩ jẽmẽn kỹ, ha mẽ. Ũ tỹ ãjag kato vãsãnsãn mũ ẽn ag to fe nỹtĩmnĩ jãvo. Ũ tỹ ãjag to jũ mũ ag mỹ nén ũ há han nĩ jãvo. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ũ tỹ ãjag mỹ vĩ kónãn mũ ag mỹ vĩ há han nĩ gé. Ũ tỹ ãjag mỹ féfén mũ ag to Topẽ mré vĩmnĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ũ ag tỹ ãjag jamẽ ki tãnh kỹ ag mỹ ãjag jamẽ ũ ti ven nĩ gé, ag tỹ ãjag mỹ ki tãnh jé gé. Ũ ag tỹ ãjag capa mãn sór mũ ẽn ag mỹ ãjag camisa nĩm nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ũ ag tỹ ãjag mỹ nén ũ to: “inh mỹ nĩm,” he kỹ ag mỹ nĩmnĩ. Ũ ag tỹ ãjag tỹ nén ũ mãn kỹ ag mỹ: “inh mỹ isũ nĩm,” he tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ãjag tỹ ãjag mré ke ũ to: “ti tỹ ẽg mỹ tag han há tóg tĩ vẽ,” he mũ ra ẽg hã tóg ti mỹ han ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ũ ag tóg ãjag to há nỹtĩ. Ãjag tỹ tag ag hã to há nỹtĩn kỹ tóg tỹ nén ũ tũ tĩ ver. Vẽnh kar ag vỹ ge nỹtĩ gé. Ũ tỹ ãjag to há nỹtĩ ẽn ag to ag tóg há nỹtĩ gé, vẽnh kato, ũ tỹ Topẽ vĩ mranh mũ ag vỹ tag han tĩ. Tag vỹ há nĩ, hã ra tóg tỹ nén ũ tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ũ ag tóg ãjag mỹ vĩ há han tĩ. Ãjag tỹ ẽn ag hã mỹ vĩ há han kỹ tóg tỹ nén ũ tũ nĩ ver. Ge ag tóg nỹtĩ gé, Topẽ vĩ mranh tĩ ag. Ãjag tỹ ag mỹ vĩ há han kỹ ag tóg ãjag mỹ vĩ há han mũ gé, vẽnh kato. Há ti nĩ, hã ra tóg tỹ nén ũ tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ũ ag vỹ, ãjag tỹ ag mỹ prestar hen kỹ ag tóg ãjag mỹ nĩm mãn mũ, ãjag tũ ti. Ãjag tỹ ag hã mỹ prestar he mãn kỹ tóg tỹ nén ũ tũ nĩ ver. Topẽ vĩ mranh tĩ ag vỹ ge nỹtĩ gé. Ãjag tỹ ag mỹ nĩm mãn kỹ ag tóg ãjag mỹ prestar he mãn mũ sir, ãjag tũ ti. Há ti nĩ, hã ra tóg tỹ nén ũ tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ag jãvo ũ tỹ ãjag kato vãsãnsãn mũ ag to há nỹtĩmnĩ, ha mẽ. Vẽnh kar mỹ vĩ há han kãn nĩ. Vẽnh kar mỹ prestar he kãn nĩ, ag tỹ ãjag mỹ ãjag tũ nĩm tũ (hã) ra. Kỹ ãjag tóg kanhkã tá venh ke mũ, ãjag tỹ ũri nén han mũ tag ri ke ti. Hã ki ãjag tóg tỹ ũ tỹ kynhmỹ nĩ ẽn krẽ nỹtĩ, ãjag tỹ ti ri ke han kỹ. Ti hã ne vẽnh kar mỹ vĩ há han kãn tĩ ver', ũn jykre kórég kar ag mré hã, ag tỹ ti mỹ: “ẽg mỹ tóg há tĩ,” he tũ (hã) ra, ag tỹ vẽnh hã ki rĩr há han mũ (hã) ra tóg ag mỹ vĩ há han tĩ ver, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Vẽnh kar jagãgtãn kãn nĩ, ẽg jóg ri ke. Ẽg jóg tỹ vẽnh kar jagãgtãn kóm vẽnh kar jagãgtãn nĩ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kãnhmar ũ to vĩ kónãn tũg nĩ, kỹ Topẽ vỹ ãjag to vĩ kónãn ke tũ nĩ gé. Kãnhmar ũ to: “kórég ti nĩ,” he tũg nĩ, kỹ Topẽ vỹ ãjag to: “kórég ti nĩ,” henh ke tũ nĩ gé. Vẽnh kar mỹ vẽnh pãte fón nĩ, ke tũ nĩ mũ ra Topẽ vỹ ãjag mỹ vẽnh pãte fón ke tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ag mỹ nén ũ há kar nĩmnĩ, kỹ Topẽ vỹ ãjag mỹ nén ũ há kar nĩm ke mũ gé sir, hã ra tóg ãjag mỹ ẽn kãfór nĩm ke mũ. Ãjag mỹ nĩm mág han jé tóg ke mũ, Topẽ ti. Nĩm mág pẽ han jé tóg ke mũ, nén ũ há kar tỹ. Hỹ, ge ti nĩ. Ãjag tỹ ag mỹ nén ũ há han kỹ Topẽ vỹ ãjag mỹ nén ũ há han ke mũ gé. Ãjag tỹ ag mỹ nén ũ kórég han kỹ tóg ãjag mỹ hã ri ke han ke mũ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kỹ tóg ag mỹ: “ũ tỹ ki kagtĩg ra tỹ ãjag pã'i nỹtĩ sór mũ tag vỹ ge nỹnh mũ, ha mẽ,” he mũ gé. Kỹ tóg: “ũn kyvó tỹ ũn kyvó ũ mỹ: “sỹ ã pére tĩg ke vẽ,” hen kỹ ag tóg ag mũn kỹ kãgnó ki vár kãn ke mũ. Ge ag tóg tĩ, ãjag pã'i ag. Ãjag tỹ ũn ki kagtĩg ag mré mũn kỹ ãjag tóg mũ kónãn kãn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Aluno pi(jé) ã professor kãfór nĩnh mũ'. Ti tỹ kanhrãn há han kỹ tóg kejẽn ã professor ri ke nĩnh mũ, hã ra ti pi(jé) ti kãfór nĩnh mũ'. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jykre kórég mág ãjag tóg nỹtĩ, hã ra ãjag régre jykre pãno sĩ ẽn ãjag mỹ kórég nỹ'. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kỹ ãjag hã ne tóg ãjag régre ag mỹ: “sỹ ã mỹ ã jykre kórég kurynh há tóg tĩ,” he tĩ', ãjag tỹ ãjag jykre pãno tãvĩ ẽn kurynh jãvãnh (hã) ra. Ke tũg ra mỹr, ke tũ nĩ mũ ra ãjag tóg jykre régre nỹtĩ. Ãjag jykre kurynh vén nĩ, kar ãjag tóg ãjag régre ag jykre kurynh há han mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ha vé, ka há pi(jé) kanẽ kórég han tĩ'. Kỹ ka kórég pi(jé) kanẽ há han tĩ gé'. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ẽg tỹ ti kanẽ ve kỹ ẽg tóg: “ũn kanẽ ko há ja vẽ,” henh ke mũ, ke tũ nĩn kỹ ẽg tóg: “ũn kanẽ ko vãnh ja vẽ,” henh ke mũ. Sónh to ẽg tóg pẽnva vég tũ nĩgtĩ mỹr', kar ẽg tóg vãnh tỹ jóhó to uva vég tũ nĩgtĩ gé, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ge tóg nỹgtĩ, ẽprã ke ag jykre ti. Ũn jykre há vỹ nén ũ há kar to jykrén tĩ, ti jykre kuryj nĩn kỹ. Kỹ tóg ẽg mỹ tó há han tĩ gé sir. Kỹ ũn jykre kórég vỹ ũ kórég kar to jykrén tĩ, ti jykre pãno nĩn kỹ. Kỹ tóg ẽg mỹ tó kónãn tĩ gé sir. Hỹ, ge ti nỹgtĩ. Ẽg tỹ nén to jykrén tĩ ẽn kãmén ẽg tóg tĩ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ãjag ne tóg inh mỹ: “Senhor', Senhor',” he tĩ'. Hã ra ãjag tóg isỹ ãjag mỹ nén tó mũ ẽn han vãnh nỹtĩgtĩ. Kỹ tóg vẽnhmỹ nỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Inh ki ge kỹ ãjag nỹtĩ. Inh vĩ ki kanhró ãjag tóg nỹtĩ. Ãjag tỹ ki króm kỹ ãjag tóg sir tag ri ke nỹtĩnh mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ĩn han mũ ri ke vẽ. Ũ tóg, ti tỹ ĩn han jé tóg kũm tĩ, kã há tá. Kũm kỹ tóg pãró kri ĩn han mũ sir, pãró kri tóg ti nũna gunhgunh mũ sir. Kỹ vãhã goj tóg var mũ, kỹ tóg ĩn kri rũm ke mũ, goj var ti. Hã ra ĩn tóg jẽ nĩ. Ti kókég tũ tóg nĩ, goj var ti. Ti tỹ pãró kri jẽ hã kỹ tóg tar jẽ. Ge ti nĩ, ãjag tỹ inh vĩ ki króm kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ãjag tỹ inh vĩ ki króm tũ nĩn kỹ ãjag tóg sir tag ri ke nỹtĩnh mũ, ha mẽ. Ũ tóg ĩn han mũ gé, hã ra tóg jo kũm tũ nĩ, ti nũna vỹ jãvo krĩgmỹ nỹtĩ. Kỹ vãhã goj var vỹ ĩn kri rũm ke mũ sir, kỹ tóg kutẽ mũ sir, ĩn ti. Kỹ tóg mráj mũ sir, ha mẽ, ti nũna tỹ krĩgmỹ nỹtĩn kỹ. Ge ti nĩ, ũ tỹ inh vĩ jẽmẽ jãvãnh ẽn ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus tỹ ag kar kanhrãn kãn kar tóg cidade tỹ Cafarnaum ra tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tá fóg tỹ capitão tóg nĩ nĩ. Ti camarada tóg kaga nỹ nĩ. Vẽnhmỹ tóg nỹ, kỹ capitão tóg: “ti hỹn ter mũ ha,” he mũ. Hã ra tóg ti mỹ ti fe ri ke nĩ, ti camarada ti, capitão ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hã kỹ tóg Jesus kãme mẽ kỹ Israel kófa ag jẽgnẽg mũ, Jesus to, ag tỹ ti mỹ: “ti venh kãtĩg,” he jé. Jesus tỹ ti camarada tỹ há' he jé tóg ti mỹ vẽnh vĩ jẽnẽg mũ, fóg tỹ capitão ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kỹ ag tóg Jesus tá junjun mũ, Israel kófa ẽn ag. Kỹ ag tóg Jesus mỹ tó mũ. “Ã mỹ ti venh tĩg ke tũ nĩ?” he ag tóg mũ, Jesus mỹ. “Ũn há vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ẽg povo to tóg há tãvĩ nĩ, ti tỹ tỹ fóg (hã) ra. Ẽg mỹ tóg ĩn han ja nĩ, ẽg tỹ krẽm Topẽ vĩ tó jafã ti, ti tỹ tỹ fóg (hã) ra,” he ag tóg mũ, Jesus mỹ, fóg tỹ capitão ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kỹ Jesus tóg: “hej,” he mũ. Kỹ tóg ag mré tĩ mũ. Kỹ tóg ti ĩn kakó ki jun mũ. Kỹ capitão tóg ti mỹ vẽnh vĩ jẽnẽ mãn mũ gé. Ã mré ke ag jẽgnẽg tóg mũ, Jesus to. Kỹ ag tóg ti mỹ: “Senhor',” he mũ. “Ti venh kãrãnh ke tũ ã nẽji nĩ, ti tỹ tỹ fóg nĩn kỹ,” he ag tóg. “Ã mỹn hỹn jagy nỹ, ã tỹ fóg ĩn kãki sãn ken kỹ, Judeu ag tỹ fóg ĩn sãn jãvãnh nỹtĩn kỹ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","“Hã kỹ ti nẽji ã venh kãtĩg tũ nĩ gé, hã ra tóg ã mỹ vẽnh vĩ jẽnẽg mũ. Ã vĩ pir ki ti camarada nẽji há' henh mũ, ã tỹ ã vĩ tỹ ti tỹ há' henh há nĩn kỹ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Ha vé, tỹn ji pã'i krẽm ke nĩ gé, kỹ soldado ag nẽji tỹ ti krẽm ke nỹtĩ gé. Hã kỹn ji tóg pã'i jykre ki kanhró nĩ. Ti tỹ soldado ũ mỹ: “kutĩg,” hen kỹn ji tĩ mũ, ti tỹ ti mỹ: “kunĩg,” hen kỹn ji kãtĩ mũ gé. Ti tỹ ã camarada mỹ: “tag han ra,” hen kỹn ji han mũ. Ti vĩ tỹn ji ag jẽgnẽg tĩ. Hã kỹn ji ki kanhró nĩ. Ã vĩ tỹ ã nẽji ti camarada tỹ há' he há nĩ,” he ag tóg mũ, Jesus mỹ, capitão mré ke ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kỹ tóg Jesus mỹ e tĩ, ti vĩ tag ti. Kỹ tóg ã mré mũ tĩ ag mỹ ke mũ, ũn a ag mỹ, ti nón kãmũ ẽn ag mỹ. Kỹ tóg ag mỹ: “Israel ũ pi(jé) ti ri ke nĩ', ti tỹ tỹ fóg (hã) ra',” he mũ. “Ki kanhró tóg nĩ mỹr, kỹ tóg inh ki rã kỹ jẽ. Ge ve ja tũ sóg nĩ. Há' he kỹ ti nĩ ha, ti camarada ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kỹ ag tóg vỹnvỹn ke mũ, capitão ĩn ra, capitão tỹ ũn jẽgnẽg mũ ag. Hã ra ti camarada ẽn tóg há' he ja nĩ sir, ag tỹ tá junjun mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kãnhmar Jesus tóg tĩ mũ gé sir, ẽn ki. Kỹ tóg cidade tỹ Naim ra tĩ mũ. Ti mré mũ tĩ ag tóg ti mré mũ mũ, ũn e a g ke gé. Ti nón ag tóg mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kỹ tóg cidade ẽn fyr ki jun mũ, cidade to ró jãnkã ki. Kỹ ag tóg vẽser va kãmũ nĩ, ha mẽ. Ti mỹnh fi kósin pir vẽ mỹr. TI panh tóg ter ja nĩ. Kỹ ũ tỹ hẽn ri ke fag vỹ fi mré mũ nĩ, cidade tá kãmũn kỹ. ag tỹ ti péjunh mũ vẽ, vẽnh kej tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kỹ Jesus tóg fi vég mũ, kỹ fi tóg ti mỹ jagtar nĩ. Kỹ tóg fi mỹ: “fỹ tũg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kỹ tóg vẽser venh tĩ mũ, kỹ tóg tá jun kỹ ti mẽg mũ. Kỹ ũ tỹ ti va mũ ẽn ag vỹ krỹg'krỹg' he mũ. Kỹ Jesus tóg vẽser mỹ: “kyrũ',” he mũ. “Nĩ ra, he sóg mũ ã mỹ,” he tóg mũ, vẽser mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kỹ tóg nĩ mũ (mỹr) sir, ha mẽ, vẽser ẽn ti, kỹ tóg vĩ mũ sir, ũn ter ja ẽn ti. Kỹ Jesus tóg ti mỹnh fi mỹ ti fẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kỹ tóg vẽnh kar mỹ e tĩ, kỹ ag tóg Topẽ to vĩ há han mũ sir. “Topẽ vĩ tó tĩ kãfór vỹ ẽg ki jun,” he ag tóg mũ, “Topẽ vỹ ẽg ve há han, hã kỹ tóg ti jẽnẽ,” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kỹ ti vẽme tóg vẽnh kar kri rũm ke mũ sir, ga tỹ Judéia kar tá, ga kar ẽn kãmĩ ke gé, Jesus tỹ ũn ter ja ẽn rĩn mãn ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ẽn kã João vỹ se kỹ jẽ nĩ, João Batista ti, ũ tỹ ag kygpég tĩ ti. Kỹ João mré mũ tĩ ag tóg ti mỹ tó kãn mũ sir, Jesus tỹ nén han mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Kỹ tóg ti mỹ e tĩ. Kỹ tóg Jesus to: “Topẽ tỹ ũn jẽnẽg mũ hã mỹ vỹ?” he mũ. Hã kỹ tóg ã mré mũ tĩ régre ag jẽgnẽg mũ, ag tỹ Jesus venh mũ jé, ag tỹ ti ki jẽmẽ jé, ti mỹ: “ã hã mỹ'?” he jé. “Ẽg tỹ ũn jãvãnh mũ mỹ tỹ ã nĩ? Topẽ tỹ ũn jẽnẽg mũ hã mỹ tỹ ã nĩ? Ẽg mỹ ũ jãvãnh mãn ke tũ nĩ ha', ã pãte?” he sór ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kỹ ag tóg Jesus tá junjun mũ. Kỹ ag tóg ti mỹ: “João Batista vỹ ẽg jẽgnẽ, ẽg tỹ ã ki jẽmẽ jé,” he mũ. “Ã hã mỹ'? he tóg. Ẽg tỹ ũn jãvãnh mũ ẽn hã mỹ tỹ ã nĩ'? Ẽg mỹ ũ jãvãnh mãn ke tũ nĩ ha', ã pãte? he tóg, João ti, ã mỹ,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hã ra Jesus tóg ũn kaga ag tỹ há' he mũ, ag tỹ ti mré vĩnh kãmũ kỹ. Vẽnh jagrẽ kórég pan tóg mũ gé, kurã ẽn kã. Ũn kyvó ag tỹ há' he tóg mũ gé, ag kanẽ tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kỹ tóg João mré mũ ti ag mỹ: “Ha João mỹ tag tómnĩ, ha mẽ,” he mũ. “Ãjag tỹ nén vég mũ ta g tómnĩ, ãjag tỹ nén mẽg mũ ti ke gé,” he tóg. “Tag han inh tĩ, ha mẽ: ũn kyvó ag vỹ isugrĩn ẽvãnh há nỹtĩ ha. Ũn kãnhgrĩ ag vỹ mũ há han mũ ha, ũn kónhgrĩ ẽn ag. Ũ tỹ vẽnh kaga kren vãnh han mũ ag krenkren han inh tĩ, ũ tỹ lepra han mũ ag. Ũn kutu ag vỹ ẽmẽ há nỹtĩ ha. Ũn kãgter mũ ag vỹ rĩnrĩr mãn gé. Ũn jagãgtar e ag vỹ Topẽ vĩ sér mẽg mũ ha ke gé, Topẽ tỹ tỹ ẽg pã'i nĩnh ke to. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kỹ tóg ti tỹ iso jykrén kónãn tũ nĩn kỹ há' he mũ. Kỹ Topẽ tóg ti ve há han mũ sir. Tag tómnĩ, João mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kỹ João tỹ ũn jẽgnẽg mũ ag tóg mũ mũ sir, João mỹ tó jé, mỹr, ha mẽ. João tỹ ũn jẽgnẽg mũ ẽn ag mũ kar kỹ Jesus tóg ũn e ẽn ag kanhrãn mũ sir, kỹ tóg ag mỹ João kãmén mũ. “Ẽmã tũ ja ra ãjag tóg mũ ja nĩgtĩ, João ve jé,” he tóg. “Kỹ ti jykre hỹn ne ri ke nĩ, ãjag mỹ? Kejẽn kãka tóg goj jagma krã tỹ man man ke tĩ. João jykre mỹ ãjag mỹ tag ri ke tũ nĩ'? Hỹ, ri ke tũ ti nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kỹ ti jykre hỹn ne ri ke nĩ ãjag mỹ? Ti mỹ ãjag mỹ ũn kur sĩnvĩ ag jykre ri ke nĩ'? Vó. Ũn kur sĩnvĩ ag vỹ cidade mág tá nỹtĩ, pã'i mág ĩn krẽm, ũn jẽn mág mũ ag. Ag pi(jé) ẽmã tũg ja mĩ mũ tĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kỹ ti jykre hỹn ne ri ke nĩ ãjag mỹ? Ti jykre mỹ ãjag mỹ Topẽ vĩ tó tĩ ag jykre ri ke nĩ'? Hỹ, ri ke ti nĩ. Topẽ vĩ tó tĩ vẽ mỹr, hã ra tóg Topẽ vĩ tó tĩ ag kãfór kar nĩ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Topẽ vỹ João jẽnẽ, ti tỹ ijo tĩg jé. Hã kỹ tag tóg ti to rán kỹ nĩ, Topẽ vĩ ki, ha mẽ. “Ha vé, ã jo sóg ũ jẽnẽnh mũ, ti tỹ vẽnh kar tỹ há' he jé, ã tĩg ken jo. Ag jyvẽn jé tóg ke mũ, kỹ tóg ẽpry kure ri ke nĩ, ẽmĩn kurynh ri ke,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki, João to, ti tỹ ijo tĩg ke tag to,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ki hã sóg tó mũ, hã kỹ sóg ke mũ, ha mũ. Ẽprã ke ag kãfór kar ti nĩ, João ti, Topẽ vĩ tón ki. Ũ tỹ ga kri mũ kãfór kar ti nĩ. Hã ra ũ tỹ hẽn ri ke ag tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ mỹr. Ag tỹ venh ke mũ (hã) ra ag tóg kãsir nỹtĩ. Kỹ ũn kãsir ẽn ag tỹ ẽgno pẽ ẽn tóg João mág kãfór nĩnh mũ hã ra,” he tóg, Jesus ti, João to. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Jo João vĩ mẽg mũ e ẽn ag tóg João vĩ mẽ há han ja nĩgtĩ, hã kỹ ag tóg Topẽ vĩ tag ti to: “ki hã ã tóg tó mũ,” he ja nĩgtĩ, João tỹ ag mỹ nén tó ja to. Hã kỹ tóg ag kygpe ja nĩgtĩ, João ti, ũ tỹ governo mỹ imposto tỹ jãnkamy mãg tĩ ag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Hã ra Fariseu ag tóg João vĩ jẽmẽ jãvãnh ja nỹtĩgtĩ, Topẽ vĩ to professor ag ke gé. Hã kỹ ag tóg Topẽ tỹ ag mỹ nén han sór mũ ẽn tỹ ti mỹ nenh ja nĩgtĩ gé. Hã kỹ João tóg ag kygpe ja tũ nĩgtĩ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ũri ke ag vỹ ge nỹtĩ gé, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gĩr ag ri ke ag tóg nỹtĩ. Gĩr ag vỹ jagnẽ mré kanhinnhir mũgtĩ. Kỹ ag tóg ãjag mré ke ag jé prẽr tĩgtĩ, ag mré kanhinnhir jé. Kỹ ag tóg kejẽn jũ tĩ. “Ãjag mỹ ẽg tóg vãkyn, kanhinnhir kỹ, hã ra ãjag ne tóg vẽnh gringrén jãvãnh nỹtĩ',” he ag tóg tĩ, gĩr ag, jagnẽ mỹ. “Ãjag tỹ vẽnh gringrén jãvãnh nỹtĩn kỹ ẽg tóg ón kỹ vẽsỹrénh mũ sir, ẽg kanhinnhir kỹ, hã ra ãjag ne tóg ẽg mré fỹ jãvãnh nỹtĩgtĩ gé',” he ag tóg tĩ gé, ón kỹ jagnẽ to jũ kỹ, gĩr ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Gĩr tag ag ri ke ãjag tóg nỹtĩ, João to, iso ke gé,” he tóg, Jesus ti. “João vỹ vãkre ja nĩgtĩ, jẽn mág tũ, kron tũ. Kỹ ãjag tóg ti to: “jagrẽ kórég tóg nĩ,” he ja nĩgtĩ, ti vãkre to. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ti jãvo sóg vãkrég tũ nĩgtĩ. Jẽg sóg nĩgtĩ, kron sóg nĩgtĩ. Kỹ ãjag tóg iso: “ti hã ne jẽn mág tĩ',” he tĩ. “Ti hã ne kronkron tĩ', ti hã ne governo mỹ imposto tỹ jãnkamy mãg tĩ ag to há nĩ', ti hã ne Topẽ vĩ mranh tĩ ag to há nĩ',” he ãjag tóg tĩ iso, ẽprã ke fi kósin to. Kỹ João jykre tóg ãjag mỹ kórég nĩ, ti vãkre to, jãvo inh jykre tóg ãjag mỹ kórég nĩ gé, inh vãkrég tũ to. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hã ra ẽg tỹ ũ jykre tugnỹm kỹ ẽg tóg ti jykre há ẽn ki kanhró nỹtĩ sir. Kỹ tóg tỹ Topẽ krẽ nĩ sir, kỹ ẽg tóg ti ki Topẽ jykre ki kanhró nỹtĩ sir, ti jykre há ẽn tugrĩn,” he tóg, Jesus ti. Ti tỹ ag mỹ João kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kejẽn Fariseu ũ tóg Jesus mỹ tó mũ, ti tỹ ti mré jẽn jé. Kỹ tóg tĩ mũ, Fariseu ẽn ĩn ra. Tá tóg ti mré jẽg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti tỹ mré jẽg nĩ ra ũ fi tóg ti ki jun mũ, cidade tá ke ũ fi. Hã ra fi tóg mén ja e nĩ, Topẽ vĩ mranh kỹ. Jesus tỹ Fariseu ẽn ĩn krẽm jẽ mẽg fi tóg mũ, hã kỹ fi tóg garrafa va kãtĩ mũ. Garrafa kãki tóg ẽg tãg jafã nĩ, nén ger há tỹ. Pó kupri tỹ tóg han kỹ nĩ nĩ, garrafa ẽn, pó tãnãj tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ẽn va kãtĩg kỹ fi tóg ti pẽn to jẽ nĩ sir. Hã ra Jesus tóg cama kri nỹ kỹ jẽg mũ. Ag jykre vẽ, ag tỹ nỹ kỹ jẽn ke mũ ẽn ti. Kỹ fi tóg ti pẽn to jẽ kỹ fỹ mũ. Fi tỹ Topẽ vĩ mranh ja ẽn tugrĩn fi tóg fỹ mũ. Kỹ fi tóg ã kanẽ var tỹ ti pẽn kupég mũ, kỹ fi tóg ã gãnh tỹ ti pẽn kykũg mũ gé. Ti pẽn ki nhun ke fi tóg mũ gé. Kỹ fi tóg ti pẽn tãg mũ sir, garrafa ki jẽ ẽn tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kỹ Fariseu ẽn tóg vég mũ, ũ tỹ Jesus mỹ: “inh mré jẽn kãtĩg,” he ja ẽn ti. Kỹ tóg to jykrén mũ, ũn tỹtá fi to, Jesus to ke gé. “Ti tỹ tỹ Topẽ vĩ tó tĩ nĩ ra tóg fi ki kanhró nĩnh mũ vẽ,” he tóg. “Hã ra tóg ki kagtĩg nĩ ve nĩ. Ũn mén ja e fi vẽ mỹr, Topẽ vĩ mranh fi tóg tĩgtĩ mỹr, hã ra tóg fi tỹ ã pẽn mẽ ẽn kamẽg tũ nĩ, Jesus i,” he tóg, to jykrén kỹ, Fariseu ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hã ra Jesus tóg ki kanhró nĩ. Kỹ tóg ti mỹ: “Simão',” he mũ. “Sỹ ã mré vẽmén ke vẽ,” he tóg. Kỹ tóg ti mỹ: “ha tó,” he mũ sir, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Kỹ tóg: “kejẽn patrão ũ tóg nĩgtĩ,” he mũ. “Ti camarada régre ag tóg ti mỹ név(e) nỹtĩ. Ũn név(e) ẽn vỹ tỹ 500 (ke) nĩ, kar ũn név(e) vỹ tỹ 50 (ke) nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hã ra ag tỹ ne tỹ kajãm ke tóg tũ tĩ, kỹ tóg ag mỹ tỹ tũg' he mũ, ag név(e) tỹ, ag patrão ti. Kỹ ti camarada tỹ hẽ nỹ hỹn ti to há kãfór nĩ?” he tóg, Jesus ti, ti tỹ Simão ki jẽmẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Kỹ Simão tóg ti mỹ: “ũn név(e) mág ja ẽn hỹn tóg ti to há kãfór nĩ,” he mũ. Kỹ Jesus tóg ti mỹ: “ki hã ã tóg tó mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kỹ tóg fi jé vĩrĩn ke mũ sir, ũn tỹtá kórég ẽn fi jé, kỹ tóg Simão mỹ: “ã mỹ fi vég mũ'?” he mũ. “Ã kanẽ var tỹ fi tóg inh pẽn kugpég mũ, kar fi tóg ã gãnh tỹ inh pẽn kykũg mũ gé,” he tóg. “Fi jãvó ã tóg inh mỹ goj ven tũ nĩ, isỹ inh pẽn kugpe jé, sỹ ã ĩn kãra rã kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","“Inh ki nhun ke ja tũ ã tóg nĩ, ã jãvo fi tóg inh pẽn ki nhun ke mũ, to fi krónh ke tũ nĩ jãvo,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Ã pi(jé) inh gãnh tãg ja nĩ', ã jãvo fi tóg inh pẽn tãg,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Hã kỹ sóg ã mỹ tó mũ. Topẽ vĩ mranh tỹ hẽn ri ke han fi tóg. Hã ra tóg fi mỹ vẽnh pãte fón kãn mũ sir, Topẽ ti, fi tỹ iso há tãvĩ nĩn kỹ, sỹ tỹ fi fe nĩn kỹ. Ũ mỹ tóg kejẽn vẽnh pãte fón pir han tĩ, Topẽ ti, ũ tỹ patrão ki név(e) sĩ ẽn ri ke mỹ. Kỹ ẽn tóg ti to há sĩ nĩ gé sir, fi tỹ iso há tãvĩ jãvo,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kỹ tóg fi mỹ: “ã tỹ Topẽ vĩ mranh ja ẽn tỹ sóg vẽnh pãte fón mũ,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kỹ ti mré jẽg mũ ag tóg to jykrén mũ sir, ti vĩ to. Kỹ ag tóg jagnẽ mỹ ke mũ. “Ti hã mỹ ẽg tỹ Topẽ vĩ mranh kỹ vẽnh pãte fón ke mũ vỹ?” he ag tóg mũ. “Topẽ hã ne vẽnh pãte fón há nĩ', hã kỹ tóg ẽg mỹ vẽnhmỹ tĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Hã ra Jesus tóg fi mỹ ke mãn mũ. “Ã tỹ inh ki rã kỹ sóg ã kren han mũ,” he tóg. “Ha jatun mỹ tĩg,” he tóg, Jesus ti, ũn tỹtá kórég ja ẽn fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tag pãte Jesus vỹ cidade kar mĩ tĩg kãn mũ, ẽmã kãsir mĩ ke gé. Topẽ vĩ tó tóg tĩ mũ. Ag mỹ tóg: “Topẽ tỹ tỹ ãjag pã'i nĩ sór vẽ,” he mũ. Kỹ ũ tỹ 12 (ke) ag tóg ti mré mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kỹ ũn tỹtá fag tóg ti mré mũ mũ gé sir. Jesus tóg fag tỹ há' he ja nĩ. Ũ fag tóg kaga ja nỹtĩgtĩ, kỹ ũ fag tóg jagrẽ kórég ja nỹtĩgtĩ gé. Hã ra Jesus tóg fag tỹ hághá' he kãn ja nĩ. Ũ fi vỹ tỹ Maria fi nĩ, Madalena he mũ tag fi. Jesus vỹ fi jagrẽ kórég pan ja nĩ, ũ tỹ 7 (ke) vẽ, ha mẽ, fi jagrẽ kórég ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kar ũ fi vỹ tỹ Joana fi nĩ gé, Cuza prũ fi vẽ, pã'i mág tỹ Herodes tũ vég nĩ ẽn prũ fi vẽ. Kar ũ fi vỹ tỹ Suzana fi nĩ gé. Kar ũ fag vỹ ti mré mũ mũ gé, ti mỹ vẽjẽn han jé. Ãjag tũ tỹ fag tóg ti mỹ vẽjẽn han tĩ, kar ti mré mũ tĩ ag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kejẽn ũn e ag vỹ vẽnh mãn mũ sir, ẽmã tỹ hẽn ri ke tá kãmũ kỹ. Jesus to ag tóg vẽnh mãn mũ. Kỹ tóg ag kanhrãnrãn kỹ ag mỹ: “ũ tỹ Topẽ vĩ tó tĩ vỹ ge nỹnh mũ, ha mẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Kejẽn ũ tóg trigo fy vãvãm tĩ mũ. Ti tỹ vãvãm kỹ ti fy ũ tóg ẽpry kri, ẽmĩn kri vár mũ, kỹ ag tóg ti sãn mũ, kỹ sẽsĩ ag vỹ ko mũ gé sir, jẽsĩ tóg tỹ tũg' ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ti fy ũ tóg pãró kri vár mũ. Kỹ tóg mur mũ vẽ, hã ra tóg tóg mũ sir. Ga tỹ sĩ nĩn kỹ tóg goj ve ja tũ nĩ, hã kỹ tóg tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ti fy ũ tóg sónh kãki vár mũ. Kỹ sónh tóg ti mré mur mũ, ti kri tóg rũm ke mũ sir. Kỹ tóg ter mũ sir, sónh kãki. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ti fy ũ tóg ga há kri vár mũ. Kỹ tóg mur há han mũ, kanẽ há ke gé. Kanẽ tỹ 100 (ke) han tóg mũ sir, ga há kri,” he tóg, Jesus ti. Kỹ tóg tag tó kar kỹ prẽr mũ. “!..Ũ nĩgrẽg nỹtĩ ag tỹ ki ẽmẽn jé..!” he tóg, prẽr kỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kỹ ti mré mũ tĩ ag tóg ti ki jẽmẽg mũ. “Ne to ke nẽ, trigo fy kãme tag ti?” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kỹ tóg ag mỹ: “ãjag hã mỹ sóg Topẽ tỹ tỹ ẽg pã'i nĩ ẽn kãmén há han ke mũ, ijo tó ja tũ ẽn ti,” he mũ. “Hã ra sóg ũ ag mỹ comparação tãvĩ han mũ. Ag mỹ sóg tó há han ke tũ nĩ, ũ tỹ ón kỹ mẽg mũ ag mỹ, kỹ ag tóg ãjag tỹ vég mũ ra ki kagtĩg nỹtĩ, ãjag tỹ mẽg mũ ra ag tóg to jykrén tũ nỹtĩ, kỹ tóg ag tỹ to jykrén ke tũ tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kỹ tóg ag mỹ kãmén mũ. “Nén fy kãme vỹ ge nỹnh mũ, ha mẽ,” he tóg. “Topẽ vĩ vỹ trigo fy ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ũ ag tóg Topẽ vĩ jẽmẽg tĩ. Jẽmẽ kar kỹ Japo tóg ag mỹ tỹ tũg' he tĩ, Topẽ vĩ tỹ. Kỹ ag tóg sir ti ki ge tũ nĩgtĩ, krenkren ke tũ ag nĩgtĩ sir. Kỹ tóg ẽpry ẽn, ẽmĩn kri vár mũ ẽn ri ke nĩ, ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kar ũ ag tóg pãró kri vár mũ ẽn ri ke nỹtĩ gé. Mẽg ag tóg tĩ vẽ, Topẽ vĩ ti. Kỹ ag tóg: “hej,” he mũ. Ag mỹ tóg sér tĩ sir. Hã ra ag tóg tỹ nén kré jãre tũ ri ke nỹtĩ mỹr, ha mẽ. Mũ sĩ han ag tóg mũ, Topẽ mré. Nén ũ jagy kutẽ kỹ ag tóg Topẽ tovãnh mũ sir, ag tỹ Topẽ vĩ mranh sór kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kar ti tỹ sónh kãki vár mũ vỹ ge nỹtĩgtĩ gé. Topẽ vĩ mẽg ag tóg tĩ gé. Hã ra ag tóg mũ mũ sir, ãjag rãnhrãj nón. Ón kỹ ag tóg rico nỹtĩ sór mũ, ãjag rãnhrãj to. Hã to ag tóg krĩ kufy nỹtĩ. Nén kar to én ag tóg tĩ, kỹ tag hã ne ag mỹ há tĩ'. Hã kỹ ag tóg Topẽ vĩ to jykrén mãn tũ nĩgtĩ sir. Hã kỹ ag tóg kanẽ há han tũ nĩ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kar ga há kri vár mũ vỹ ge nĩ gé. Jẽmẽg ag tóg tĩ gé, Topẽ vĩ ti. Kỹ ag tóg ãjag fe tỹ ti ki rãg mũ sir, ag tỹ ti vĩ ki króm jé. Kỹ ag tóg kanẽ há han mũ sir. Komẽr hã ag tóg kanẽ há han', han', he mũ, ag tỹ nén ũ jagy vég mũ ra,” he tóg. Ti tỹ ag mỹ ẽg tỹ Topẽ tovãnh ke tũ kãmén hã vẽ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kỹ tóg ag mỹ: ẽg tỹ lampião grug kỹ ẽg pi(jé) kẽj krẽm fẽg tĩ',” he mũ. “Ẽg pi(jé) cama krẽm fẽg tĩ gé', néj gru ti. Ti fẽg jafã kri ẽg tóg ti fẽg tĩ. Kỹ vẽnh kar tóg vég mũ sir, ag tỹ ẽg ĩn kãra kãgen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ge ti nỹ, sỹ ãjag mỹ nén tó mũ kar ti. Ver ãjag tóg to jykrén tũ nĩgtĩ. Ãjag tỹ vãhã to jykrén kãn ke vẽ. Ver ãjag tóg ki kagtĩg nỹtĩ. Ãjag tỹ vãhã ki kanhrãn kãn ke vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Hã kỹ jẽmẽ há han nĩ. Ũ tỹ to jykrén há han kỹ tóg ũ to jykrén mãn', ũ to jykrén mãn', henh ke mũ. Ũ tỹ inh vĩ to jykrén há han tũ nĩn kỹ tóg ti mỹ tũg' he kãn mũ, ti tỹ nén ũ to jykrén mũ kar ẽn mré hã,” he tóg. Ti tỹ ag mỹ ẽg tỹ ti vĩ to jykrén há han ke kãmén hã vẽ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kejẽn Jesus mỹnh fi vỹ ti venh kãtĩ mũ, ti jãvy ag mré. Hã ra fag tóg ti ki junjun tũ nĩ. Ti pénĩn tóg fór tãvĩ tĩ, hã kỹ ag tóg ti ki junjun tũ nĩ, ti mỹnh fi mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kỹ ũ tóg ti mỹ: “ã mỹnh fi vỹ re tá jẽ, ã jãvy ag mré,” he mũ. “Fag tỹ ã venh kãmũ vẽ,” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hã ra Jesus tóg ti mỹ: “mẽ',” he mũ. “Hã ra ũ tỹ Topẽ vĩ jẽmẽg mũ fag vỹ inh mỹnh pẽ ri ke nỹtĩ, inh jãvy pẽ ri ke ke gé, ũ tỹ Topẽ vĩ ki króm mũ ag,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kejẽn tóg canoa kãra rã mũ, ti mré mũ tĩ ag mré. Kỹ tóg ag mỹ: “mũ nỹ, goj nig kafã ũ ra,” he mũ. Kỹ ag tóg mũ mũ, canoa kãmĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ag mũn ki Jesus tóg nũr mũ sir. Kỹ vãhã kóho jũ tóg kraug he mũ sir. Króg ke tóg mũ sir, kóho ti. Kỹ goj tóg canoa kãki krém ke mũ. Ti fãn sór tóg mũ sir. Kỹ tóg ag mỹ ag kãgter ha mẽ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kỹ ag tóg ti rĩn mũ mũ. Ti mỹ ag tóg: “Senhor', Senhor',” he mũ. “Ẽg mỹ ẽg kãgter ha mẽ tóg tĩ,” he ag tóg ti mỹ. Kỹ tóg rĩr mũ sir. Kỹ tóg kóho mỹ vĩ mũ, goj mỹ ke gé, goj vóg nén ẽn mỹ. Kỹ tóg krỹg' he mũ sir, kóho ti. Katy' he tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kỹ tóg ag mỹ ke mũ. “Ajag tỹ ne jé inh ki ge há han tũ nĩ nẽ?” he tóg. Kỹ ag tóg kanẽ jur nỹtĩ nĩ. Ag mỹ tóg e tĩ, kỹ ag tóg jagnẽ mỹ: “ti jykre tóg ẽg mỹ e tĩ,” he mũ. “Kóho mỹ tóg vĩ mũ, Kỹ tóg ki hã ke mũ, kóho ti, goj ti ke gé,” he ag tóg mũ, jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kóho tỹ tũg' hen kỹ ag tóg Gerasa ag jamã tá junjun mũ sir. Goj nig kafã ũ tá tóg nĩ, ga tỹ Galiléia to hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kỹ tóg canoa kãki kãkutẽ mũ, Jesus ti. Kỹ ũ tóg ti kato tẽ mũ, cidade tá ke ũ, hã ra tóg jagrẽ kórég tỹ hẽn ri ke nĩ. Si há tóg tĩ ha, ti jagrẽ e nĩ ti. Kỹ tóg kur tũ nĩ. Kato r tóg nĩ. Ĩn tũ ti nĩ gé. Vẽnh kej tá tóg jẽgtĩ, pãró tỹ vẽnh kej tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ẽn tóg Jesus kato tẽ mũ. Kỹ tóg ti krẽm mũg ke mũ. Prẽr kỹ tóg: “!..ã isỹ hẽ ri kenh mũ, Jesus'..!” he mũ. “!..Kynhmỹ Topẽ kósin'..!” he tóg. “!..Ã mỹ sóg to vĩnh mũ, ã tỹ inh vóg kónãn tũ nĩ jé..!” he tóg, prẽr kỹ, ũn jagrẽ kórég ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Hã ra Jesus tóg Nén-Kórég mỹ: “ti ki pa jẽg,” he ja nĩ, hã kỹ tóg prẽr mũ. Ti ki vĩrĩn ke', ti ki vĩrĩn ke' tỹ hẽn ri ke han ja ag tóg nĩgtĩ, Nén-Kórég ag. Kỹ ti mré ke ag tóg ti se ja nĩgtĩ gé, ti mrĩnh kỹ, ferro tỹ, ti nĩgé, ti pẽn ke gé. Hã ra tóg ã se ja kykym kãn ja nĩgtĩ. Kỹ Nén-Kórég ag tóg ẽmã tũg ja ra ti tĩn ja nĩgtĩ. Hã kỹ tóg vẽnh kej mĩ tĩgtĩ, ũn jagrẽ kórég ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kỹ Jesus tóg ti mỹ: “ã jiji hẽ ri ke tĩ?” he mũ. Kỹ tóg: “Mil,” he mũ. Nén-Kórég tỹ hẽn ri ke ag tỹ tóg jagrẽ nĩ, hã kỹ tóg: “Mil,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kỹ ag tóg Jesus mỹ to vĩ mũ, Nén-Kórég ag, ti tỹ nũgme ra ag jẽgnẽg tũ nĩ jé, inferno ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hã ra porco tỹ hẽn ri ke tóg tá jẽg nỹtĩ nĩ, pãnónh tá. Kỹ Nén-Kórég ag tóg Jesus mỹ to vĩ e han, ti tỹ ag mỹ: “ha porco ki ge jẽg, ge kỹ,” he jé. Kỹ tóg ag mỹ ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kỹ ag tóg ẽn ki kãpa mũ sir, Nén-Kórég ag. Porco ag ki ag tóg ge mũ sir. Kỹ porco ag tóg mer ki re mũ, rán ki, goj nig ra. Goj ki ag tóg vár mũ sir. Nãgnãr kỹ ag tóg tũ' he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kỹ ũ tỹ porco ki rĩr tĩ ag tóg vég mũ. Kỹ ag tóg pétẽ mũ, cidade ra. Tá ag tóg kãmén mũ, ẽmã kãsir mĩ hã ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kỹ tá ke ag tóg ra mũ kãn mũ, ag vĩ mẽg mũ ag. Ag tỹ nén ẽn ve sór vẽ. Ra mũ kỹ ag tóg Jesus tá junjun mũ. Kỹ ag tóg ti vég mũ sir, ũn jagrẽ kórég ja ti. Nĩ tóg mũ ha, Jesus rã hã. Kur tóg nĩ ha, krĩ há tóg nĩ ha. Kỹ ag fe tóg jũrũn ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ũ tỹ Jesus tỹ ti tỹ há' he mũ vég mũ ẽn ag tóg kãmén kãn mũ sir, ũ tỹ ũri ti venh kãmũ mũ ẽn ag mỹ. Ũn jagrẽ kórég tó ag tóg mũ, ag mỹ, Jesus tỹ ti han ja ti, porco kãgter ja ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kỹ tá ke ag tóg ti mỹ to vĩ mũ, Jesus mỹ, ti tỹ tá kãkutẽ jé. Gerasa tá ke kar ag tóg kanẽ jur nỹtĩ, hã kỹ ag tóg ti mỹ: “ã tĩg kỹ tóg ẽg mỹ há tĩnh mũ,” he mũ. Kỹ tóg canoa kãra rã kỹ tĩg sór mũ, ti mré mũ tĩ ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kỹ ũn jagrẽ kórég ja tóg ti mỹ to vĩ e han mũ, “nhỹ ã mré tĩg mũ,” hen kỹ, Jesus mỹ. Hã ra Jesus tóg ti pẽre tĩg jãvãnh nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ã jamã ra vỹn ké,” he tóg ti mỹ. “Tá ag mỹ kãmén nĩ, Topẽ tỹ ã tỹ há' he ja tag ti,” he tóg, Jesus ti. Kỹ tóg tĩ mũ sir, ũn jagrẽ kórég ja ti. Cidade kar mĩ tóg tĩ mũ. Ag mỹ tóg kãmén mũ sir, Jesus tỹ ti tỹ há' he ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kỹ Jesus tóg vỹn ke mũ, nig kafã ũ ra. Kỹ tóg vẽnh e ẽn mỹ sér tĩ, ag tỹ ti ven kỹ. Ti jãvãnh ja ag tóg nĩ, hã kỹ tóg ag mỹ sér tĩ, ag tỹ ti ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kỹ vãhã ũ tóg ti ki jun mũ, Jesus ki. Israel ag vẽnh kanhrãn jafã to pã'i vẽ, ti jyjyn hã vỹ: Jairo, he mũ. Ẽn tóg Jesus krẽm mũg ke mũ, ã jakrĩ tỹ tóg jẽ mũ, kỹ tóg ti mỹ vĩ mũ, ti tỹ ti ĩn ra tĩg jé, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ti kósin pir fi vỹ kaga tãvĩ nỹ, kỹ fi kaga tãvĩ ẽn vỹ fi tén sór mũ. Kri prỹg tỹ 12 (ke) fi nĩ, Jairo kósin pir ẽn fi. Kỹ tóg ti mré tĩ mũ, Jesus ti. Ti tĩg kỹ ũn e ag tóg ti nón mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kỹ ag kã ũ fi tóg ag pétẽm mũ. Kyvénh krỹg tũ han kỹ fi tóg nĩ, prỹg tỹ 12 (ke) ki. Hã ra ag tóg fi kaga tỹ hẽ ri ke ja tũ nĩ, ag tỹ fi kygtãg mũ ra, médico ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ẽn fi tóg ti nón ti kur mráj vóg mũ. Kỹ vẽsỹmér fi kyvénh tóg tũ' he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kỹ Jesus tóg: “ũ nỹ inh kur vóg?” he mũ. Hã ra vẽnh kar tóg: “inh hã tũ vẽ, inh hã tũ vẽ,” he mũ. Kỹ Pedro tóg ti mỹ vĩ mũ, Jesus mré mũ tĩ ag kar ke gé. Ti mỹ ag tóg: “ã kur mẽ kãn ẽg tóg, hã ra ã tóg: “ũ nỹ inh kur vóg?” he mũ,” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hã ra Jesus tóg: “vó,” he mũ. “Ũ tóg inh kur vóg,” he tóg. “Inh kuprĩg tóg inh ki kãtére, hã kỹ sóg ki kanhrãn mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kỹ ũn tỹtá ẽn fi tóg to jykrén mũ sir. “Ti hỹn tóg inh vé,” he fi tóg. Hã kỹ fi tóg jũrũn ke kỹ kãtĩ mũ. Jesus krẽm fi tóg mũg ke mũ. Kỹ fi tóg ti mỹ tó kãn mũ, vẽnh kar rĩnve. Ti mỹ fi tóg ã kaga ja ẽn kãmén kãn mũ, fi tỹ ti kur vóg ja ẽn ti ke gé, fi tỹ há' he ja ti ke gé. “Isỹ ã kur vóg kỹ sóg vẽsỹmér há' hé,” he fi tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kỹ tóg fi mỹ vĩ há han mũ, Jesus ti. “Inh kósin',” he tóg. “Ã tỹ inh ki rã kỹ ã tóg há' hé. Ha tĩg, jatun mỹ. Há ã tóg nĩ ha,” he tóg fi mỹ, fi han kar kỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ti tỹ ver fi mré vẽmén jẽ ra ũ tóg jun mũ, pã'i tỹ Jairo ẽn ĩn tá. “Ã kósin fi hur ter,” he tóg, pã'i mỹ. “Tũg ja fi tóg nĩ ha,” he tóg, Jairon mỹ. “Hã kỹ ti mỹ: kunĩg, he mãn tũg nĩ, ti kutãn mãn tũg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hã ra Jesus tóg mẽg mũ, kỹ tóg ti mỹ: “mũmẽg tũg nĩ,” he mũ. “Inh vĩ hã kri fimnĩ, kỹ ã kósin fi tóg há' henh mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kỹ ag tóg mũ kỹ ti ĩn tá junjun mũ sir, Jairo ĩn tá. Kỹ Jesus tóg ag tỹ ĩn kãra ge kamẽg mũ. “Pedro vỹ ĩn ra rãnh mũ, inh mré, João ke gé, João kãke tỹ Tiago ke gé, gĩr fi panh ke gé, fi mỹnh fi ke gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hã ra ũn e fag vỹ tá nỹtĩ nĩ gé, kygfỹ fag nỹtĩ nĩ, vẽsỹrénh kỹ, Kỹ Jesus tóg fag mỹ: “kygfỹ tũg ra,” he mũ. “Fi pi(jé) ter mũ'. Fi nũr vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hã ra fag tóg ti nyg mũ. Fi ter ki kanhró fag tóg nỹtĩ, hã kỹ fag tóg ti nyg mũ. Hã ra Jesus tóg fag mỹ: “ha mũjẽg,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Fag mũn kar kỹ Jesus tóg fi nĩgé kãgmĩg mũ, kỹ tóg prẽr mũ sir. “!..Nĩ ra, já..!” he tóg, jamã hár(a). ");
INSERT INTO kgpNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kỹ fi kuprĩg tóg fi to vỹn ke mũ. Nĩ fi tóg mũ sir, mỹr, ha mẽ, ũn ter mũ ẽn fi. Kỹ Jesus tóg fag mỹ tó mũ, fag tỹ fi mỹ vẽjẽn ven jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kỹ tóg fi han mũ fag mỹ e tãvĩ tĩ sir. Hã ra Jesus tóg fag mỹ tó mũ, fag tỹ ũ mỹ tó tũg jé, fi rĩr mãn ja tag ti. Hã ra tóg fi ter mũ ra fi rĩn, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kỹ Jesus tóg ũ tỹ 12 (ke) ag jé prẽr mũ, ti tỹ ũn vin mũ ẽn ag, ag vẽnh mãn jé. Ag vẽnh mãn kỹ tóg ag tar han mũ sir, ag tỹ vẽnh jagrẽ kórég pan jé, ag tỹ ũn kagyga ag tỹ há' he jé gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kỹ tóg ag jẽgnẽg mũ sir, ag tỹ Topẽ tỹ tỹ ẽg pã'i nĩ ẽn kãmén jé, vẽnh kar mỹ, ag tỹ ũn kagyga ag tỹ há' he kãn jé gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hã kỹ tóg ag mỹ ke mũ sir. “Ãjag mũn kỹ nén ũ ma mũ tũg nĩ, vãtó va mũ tũg nĩ, sacon ke gé, bolsa ẽn, pão ke gé, jãnkamy ke gé. Kur régre rĩnh tũg nĩ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Ãjag tỹ ĩn ra ge mũ hã ki nũgnũr' hemnĩ, hã ki ãjag tỹ kurã ki kãpanh ke tá krỹg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Ag tỹ ãjag mỹ: “kãge jẽg ra,” he jãvãnh nĩn kỹ tá kãpamnĩ. Tá kãpa kỹ ãjag pẽn hã kykũnhkũnh nĩ, ag tỹ to ki kanhró nỹtĩ jé sir, Topẽ tỹ ag tovãnh ken ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ti tỹ ag jẽgnẽn kỹ ag tóg mũ sir, ũ tỹ 12 (ke) ag. Ẽmã kar mĩ ag tóg mũ sir. Topẽ kãmén ag tóg mũ mũ sir. Ũn kagyga ag tỹ há' he kãn ag tóg mũ gé sir, fag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kỹ pã'i mág tỹ governador tỹ Herodes vỹ mẽg mũ sir, Jesus tỹ nén han mũ ti. Kỹ tóg ti mỹ e tĩ. Kỹ ti tỹ ne to jykrén ke tóg tũ tĩ. Hã ra ũ ag tóg Jesus to: “João Batista vẽ,” he tĩ. “João hỹn tóg ã ter kỹ rĩr mãn,” he ag tóg tĩ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jo ũ ag tóg ti to: “Elias vẽ,” he tĩ gé. “Ti hỹn vẽnh ven mãn, vãsỹ Topẽ vĩ tó tĩ ẽn, Elias ti,” he ag tóg tĩ gé, Jesus to. Kỹ ũ ag tóg ti to: “vãsỹ Topẽ vĩ tó tĩ ũ hỹn rĩr mãn,” he tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hã jẽmẽ tóg, Herodes ti, kỹ tóg to jykrén kỹ: “João mỹ vó?” he mũ, Jesus to. “Hã ra sóg João krĩ kym, kỹ tóg tũ' he mũ. Kỹ ũ nẽ, hỹn'?” he tóg. “Nén han vãnh tỹ hẽn ri ke hyn han tóg huri. Ũ nẽ, hỹn'?” he tóg. Herodes ti. Kỹ tóg kejẽn ti ve sór mũ, ti tỹ ti mỹ e tĩn kỹ, hã ra Jesus vỹ ti venh tĩ tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kejẽn Jesus tỹ ũn vin mŨ ag vỹ Jesus to vỹnvỹn ke mũ, ti tỹ ag jẽgnẽ ja ẽn tá. Ti mỹ ag tóg kãmén mũ sir, ag tỹ nén han ja ẽn kar ti. Kỹ tóg ag mré vẽnh péju kỹ tĩ mũ, ẽmã tỹ Betsaida ra, vyr mỹ ag mré vẽmén jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hã ra ũn e ẽn ag tóg mẽg mũ, Jesus tĩg ti, kỹ ag tóg ti nón mũ mũ. Ag tỹ ti pétẽm kỹ tóg ag mỹ vĩ há han mũ, Jesus ti. Ag mỹ tóg kãmén mũ, Topẽ tỹ tỹ ẽg pã'i nĩ sór ti. Ag kãmĩ ũn kagyga tỹ há' he tóg mũ gé, fag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ti tỹ ag mỹ tó jẽ ki tóg rãké nỹ sir, kỹ ũ tỹ 12 (ke) ag tóg Jesus to kãmũ mũ. Ti mỹ ag tóg: “ã tỹ ag jẽgnẽnh há tóg tĩ,” he mũ, “ag tỹ ẽmã kar mĩ mũ jé, pão comprar he jé, tá nũgnũr jé ke gé. Tag ki tóg ẽmã tũ nĩ,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hã ra Jesus tóg ag mỹ: “vó,” he mũ. “Ha inhhã ag jẽn,” he tóg. Kỹ ag tóg ti mỹ: “hã ra vẽjẽn tóg ẽg mỹ tũ tĩ,” he mũ. “Pão tỹ 5 (ke) hã vỹ ki nỹtĩ, pirã régre mré ke gé. Ẽg mỹ ag jo comprar henh mũ vỹ, vẽjẽn ti?” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ũ tỹ mil tỹ 5 (ke) ag vẽ, ag tãvĩ, fag mré tó tũ ra. Hã ra fag tóg tá e nỹtĩ gé, gĩr mré ke gé. Ag tỹ ti mỹ ke kỹ Jesus tóg ã mré mũ tĩ ag mỹ: “ag mỹ tugtó, ag nĩgnĩ jé,” he mũ, “ag tỹ vẽnh nĩkrén jé, ũ tỹ 50 (ke) pãte ũ tỹ 50 (ke) ũ pãte nĩgnĩ jé,” he tóg, Jesus ti, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kỹ ag tóg ke mũ sir. Kỹ vẽnh kar tóg nĩgnĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kỹ tóg pão tỹ 5 (ke) in gég mũ, pirã régre ẽn mré. Kỹ tóg kanhkã ki ẽvãnh mũ, kỹ tóg Topẽ mré vĩ mũ sir. Kỹ tóg pão vẽnh kãpópãm mũ sir. Kỹ tóg ã mré mũ tĩ ag mỹ vin mũ, ag tỹ ũn e ẽn mỹ vẽnh kãpópãm jé, pirã ẽn mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kỹ vẽnh kar tóg ko kãn kỹ funfór mũ sir. Kỹ ag tóg ti ke ẽn gég mũ. Kẽj tỹ 12 (ke) fãn tóg, vẽjẽn mru ẽn ti. Hã kỹ Jesus tóg pão tỹ 5 (ke) tỹ ũn e ag fónfãn ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kejẽn Jesus tóg Topẽ mré vĩ mũ, ã pin kỹ. Hã ra ti mré mũ tĩ ag tóg ti mré nỹtĩ nĩ. Kỹ tóg ag mỹ ke mũ. “Ag iso hẽ ri ke tĩ?” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kỹ ag tóg ti mỹ: “ũ ag vỹ: João Batista vẽ, he tĩ, jãvo ũ ag vỹ: Elias vẽ, he tĩ gé, jãvo ũ ag vỹ: vãsỹ Topẽ vĩ tó tĩ ũ vỹ rĩr mãn, he tĩ gé, ã to,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kỹ tóg ag mỹ: “ag jãvo ãjag hẽ ri ke tĩ, iso?” he mũ. Kỹ Pedro vỸ ti mỹ kãmén mũ. “Tỹ ã Cristo nĩ, Topẽ tỹ ẽg mỹ ũn jẽnẽg mũ ẽn vỹ tỹ ã nĩ,” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kỹ tóg ti mỹ vĩ tar han mũ, Jesus ti, ag tỹ ũ mỹ tó tũ nĩ jé ver, ti tỹ tỹ Cristo nĩ ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kỹ tóg ag mỹ kãmén mũ. “Tỹ sóg ẽprã ke fi kósin ẽn nĩ,” he tóg. “Ijagtar jagy han ke vẽ,” he tóg. “Kófa ag tỹ iso: kórég ti nĩ, henh ke vẽ, Topẽ tũ ki rĩr tĩ to pã'i ag ke gé, Topẽ vĩ to professor ag ke gé. Ag tỹ isén ke vẽ. Kurã tãgtũ tũg mũ ra sóg rĩr mãn mũ hã ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kỹ Jesus tóg vẽnh kar mỹ tó mũ. “Ãjag tỹ inh mré kãmũ kỹ tóg há tĩnh mũ,” he tóg. “Kỹ ãjag jykre tovãnh nĩ, ãjag tỹ isũ tãvĩ han jé. Ha vé, ag tỹ inh cruz tỹ inh kri fi kỹ sóg tĩg ke mũ, ag tỹ to isa kỹ isén jé, ha vemnĩ. Vẽnh nenh ke tũ sóg nĩ. Isỹ tag han ri ke han nĩ, kurã kar ki, ãjag tỹ inh mré mũ sór nỹtĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Ãjag tỹ ãjag jykre hã han sór kỹ ãjag tỹ nũgme ki vár ke vẽ. Jãvo ãjag tỹ isugrĩn ãjag jykre tovãnh kỹ ãjag krenkren ke vẽ, ãjag kãgter ke mũ (hã) ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ãjag tỹ ga kri mũn kỹ ãjag tóg nén kar ganhar he sór mũ. Kỹ ãjag kuprĩg vỹ vãfor ke mũ. Kỹ tóg kórég nỹ sir, ãjag rico tãvĩ nỹtĩ ra. Ganho há venh ke tũ ãjag tóg ke mũ, gen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iso mỹ'ãg tũg nĩ, inh vĩ to. Ãjag tỹ ũri iso mỹ'ãg kỹ sóg ãjag to mỹ'ãg ke mũ gé, inh kãtĩg mãn ken kỹ. Tỹ sóg ẽprã ke fi kósin ẽn nĩ. Sĩnvĩ ti nĩnh mũ, inh kãtĩg mãn kỹ, inh jóg tỹ inh jẽnẽn kỹ, ti tỹ isỹ ũn mág han kỹ. Kỹ ti tỹ jẽgnẽ jafã ag vỹ inh mré kãmũnh mũ gé, Topẽ tũ ag. Ẽn kã sóg ãjag to mỹ'ãg ke mũ, ãjag tỹ ũri iso mỹ'ãg kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Ki hã sóg tó mũ, ha mẽ. Ãjag kãmĩ ũ ag vỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ, ag ter ke to hã, tag ki ẽg mré nỹtĩ ũ ag,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesus tỹ tag tó kar kỹ kurã tỹ 8 (ke) vỹ tũg mũ. Kỹ tóg kejẽn ag mỹ: “mũ nỹ, vyrmỹ,” he mũ. Pedro mỹ tóg ke mũ, João mỹ ke gé, Tiago mỹ ke gé. Ag hã mré tóg tĩ mũ, pãnónh ra, Topẽ mré vẽmén jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tá jun kỹ tóg Topẽ mré vĩ mũ sir. Kỹ tóg vãhã vẽnh ven ũ han mũ, vẽnh ven kupri han tóg mũ. Ti kur tóg kópréj nĩ, kókov tóg nĩ, ti kur ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Kỹ ũn régre ag tóg vãhã tá vẽnh ven mũ sir. Kỹ ag tóg Jesus mré vẽmén mũ sir. Moisés vẽ, Elias mré hã, ũn régre ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ag ve vỹ ti ve ri ke nĩ gé, Moisés mré Elias ti. Jesus mré ag tóg vẽmén mũ, ti ter ken kãmén ag tóg mũ sir, ti tỹ Jerusalém tá ter ke mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro ag mỹ tóg nũr há tãvĩ tĩ, ge ra ag tóg ag vég mũ sir, ag mỹ nũgnũr há (hã) ra. Hã kỹ ag tóg Jesus tỹ ag mỹ vẽnh ven ũ han mũ ẽn vég mũ sir, ti kókov ẽn ti, ti mré vẽmén mũ ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kỹ ũ tỹ Jesus mré vẽmén kỹ nỹtĩ ag tóg mũ sór mũ sir. Kỹ Pedro tóg Jesus mỹ: “Senhor',” he mũ. “Tag ki tóg há nĩ,” he tóg. “Ẽg tỹ tag ki pãjó tãgtũ han kỹn hỹn há nĩnh mũ, ã mỹ, Moisés mỹ, Elias mỹ ke gé,” he tóg, Pedro ti. Hã ra tóg krĩ tũ nĩ, hã kỹ tóg pãjó tó mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro tỹ ver ti mỹ vẽmén kỹ kanhkã góg vỹ ag kri rũm ke mũ sir. Kỹ ag tóg kamẽgmẽg mũ, kanhkã góg ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kỹ vẽnh vĩ tóg mẽ há' he mũ, kanhkã góg ẽn kãtá, kỹ tóg: “inh kósin hã vẽ,” he mũ. “Inh fe pẽ hã vẽ,” he tóg. “Ti vĩ jẽmẽ ra,” he tóg, vẽnh vĩ ti, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ag tỹ tag mẽ kar kỹ Jesus tóg ã pir mỹ tá jẽ nĩ sir. Ti mré vẽmén ja ẽn ag ve mãn tũ ag tóg nĩ sir, Pedro ag. Kỹ ag tóg mũ mũ. Hã ra ag tóg ũ mỹ tó tũ nĩ ver, ag tỹ nén ve ja ti. Tỹ vẽmén tũ ag tóg nĩ ver, ag tỹ kanhkã tá vẽnh jykre ve ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tỹ vaj kỹ ag tóg pãnónh ẽn tá kãre mũ, Jesus mré. Kỹ ag tóg ũ tỹ hẽn ri ke ag vigvég mũ sir. Jesus kato ag tóg kãmũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kỹ vãhã ũ tóg ag kãmĩ prẽr mũ, ha mẽ. “!..Senhor..!” he tóg. “!..Inh kósin ve ra..! Inh kósin pir vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jagrẽ kórég ti nĩ, ha mẽ. Kỹ tóg kejẽn ti kã vyryn ke tĩ, kỹ tóg prẽr tĩ, kỹ tóg ti ter tĩ han tĩ gé, kỹ tóg jãrãn mũ. Jãrãn kỹ tóg jũrũn' jũrũn' ke tĩ gé, kỹ tóg kejẽn ti tovãnh mũ sir, komẽr hã, ti rỹj kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ã mré mũ tĩ ag mỹ sóg to vĩ mũ vẽ, ag tỹ ti jagrẽ kórég tag kutẽm jé, hã ra ag tóg ti tỹ hẽ ri ke tũ nĩ,” he tóg, ti panh ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kỹ Jesus tóg ti mỹ: “ãjag ne tóg inh ki ge há han tũ nĩgtĩ',” he mũ. “Jykre pãno ãjag nỹtĩ,” he tóg. “Kysã tỹ hẽn ri ke ki inh hỹn ãjag mré tĩ nĩ'? Kysã tỹ hẽn ri ke ki inh hỹn ãjag to fe tĩg nĩ?” he tóg. “Inh mỹ ti pére kãtĩg nĩ,” he tóg, Jesus ti, ti panh mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kỹ ag tóg ti pére kãmũ mũ. Ti jun kỹ ti jagrẽ tóg ti kã vyryn ke mũ. Ti tỹ jũrũn', jũrũn' ke han tóg mũ sir. Kỹ Jesus tóg ti jagrẽ mỹ vĩ jũ han mũ, ti tỹ ti ki kãkutẽ jé. Hã ki tóg kyrũ ẽn tỹ há' he mũ sir. Kỹ tóg ti panh mỹ: “té,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kỹ tóg vẽnh kar mỹ e tãvĩ tĩ. “Topẽ ne tóg tỹ ũn mág tãvĩ nĩ', ti jykre tóg há tãvĩ nĩ,” he ag tóg mũ sir, ag tỹ Jesus tỸ nén han mũ to jykrén kỹ. Kỹ Jesus tóg ã mré mũ tĩ ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ha mẽ há han,” he mũ. “Ẽprã ke fi kósin ẽn vỹ jagtar nĩnh ke mũ. Inh hã vẽ,” he tóg. “Ẽprã ke ag vỹ ãjag tỹ inh ki nén han sór mũ ẽn han ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hã ra tóg ag tỹ ti tỹ ã ter ke kãmén tag to jykrén tũ nĩgtĩ. Ag tỹ to jykrén mũ ra ag tóg ki kagtĩg nỹtĩ. Kỹ ag tóg ãjag tỹ ti ki jẽmẽ sór mũ ra ti kamẽg mũ gé, hã kỹ ag tóg ti mỹ: “ã tỹ ne tó nẽ?” he tũ nĩ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kejẽn Jesus mré mũ ag vỹ jagnẽ mỹ vĩ jũ han mũ. “Ẽg kã ũ tỹ hẽ nỹ jagnẽ kãfór nĩ?” he ag tóg jagnẽ mỹ. Tag to ag tóg jagnẽ mỹ vĩ jũ han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hã ra Jesus tóg vég mũ, ag tỹ nén to jykrén mũ ti. Kỹ tóg gĩr jé prẽr mũ, ti tỹ ti mré jẽ jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kỹ tóg ag mỹ tag tó mũ, ha mẽ. “Gĩr tỹ ge jẽ'ỹn nĩ, ti to há nỹtĩmnĩ, isugnĩn,” he tóg. “Ãjag tỹ isugrĩn ti to há nỹtĩn kỹ ãjag tóg iso há nỹtĩ gé sir. Ãjag tỹ iso há nỹtĩn kỹ ãjag tóg ũ tỹ inh jẽnẽg mũ to há nỹtĩ gé sir. Kỹ ãjag tỹ ẽgno kar vỹ tỹ ãjag mág kãfór kar nĩnh mũ, ha mẽ, ãjag tỹ tỹ ũn mág nỹtĩ sór kỹ. Tag to jykrén nĩ,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Kỹ João tóg Jesus mỹ: “Senhor',” he mũ. “Ũ ve ẽg tóg vẽnh jagrẽ pan tĩ, ã jiji tó kỹ, ẽg tỹ ũn vég mũ ẽn ti,” he tóg, Jesus mỹ. “Hã ra tóg ẽg mré tĩ tũ nĩgtĩ, hã kỹ ẽg tóg ti mỹ: “vẽnh jagrẽ kórég pan sór tũg nĩ,” hé,” he tóg, João ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kỹ Jesus tóg ti mỹ: “ũ mỹ: “vẽnh jagrẽ kórég pan tũg nĩ,” he tũg nĩ,” he mũ. “Ũ tỹ ẽg kato tẽ tũ nĩn kỹ ẽg mré ke vẽ sir,” he tóg, Jesus ti, João mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kejẽn Jesus ter ke kurã tóg kakó nĩ sir. Kỹ tóg to jykrén kỹ Jerusalém ra tĩg sór mũ, ag tỹ tá ti tén jé. Kỹ tóg tĩg kỹ ũ ag jẽgnẽg mũ, vẽnh jo, ag tỹ ti jun ke tó jé, cidade kãsir tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kỹ ag tóg mũ mũ, ag tỹ tón jé. Kỹ ag tóg cidade sĩ ũ ki jun mũ. Samaria tá ke ag jamã ũ vẽ. Tá ag tóg ti nũr ke ve sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hã ra tá ke ag tóg ag mỹ nenh mũ. Ag mỹ ag tóg: “ãjag tỹ hẽ ra mũ nẽ?” he mũ. Kỹ ag tóg: “Jerusalém ra,” he mũ. Kỹ tóg ag mỹ kórég nĩ, hã kỹ ag tóg ag mỹ cama ven sór tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kỹ Tiago tóg jũ mũ, João ke gé, Jesus mré mũ tĩ ag. Kỹ ag tóg Jesus mỹ: “Senhor',” he mũ. “Ẽg mỹ tóg há nỹnh mũ, ẽg tỹ Topẽ mỹ: “kanhkã tá pĩ tỹ ag pũn nĩ,” hen kỹ. Mỹ ã mỹ há nỹnh mũ?” he ag tóg. “Ẽg tỹ Elias tỹ nén han ja ẽn han há tóg tĩ,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hã ra Jesus tóg ag jé vĩrĩn ke kỹ ag mỹ: “vĩ tũg ra,” he mũ. “Topẽ jykre pijé', ãjag tỹ nén han sór mũ tag ti. Inh pi(jé) ag tũg sór mũ'. Isỹ ag kren han sór vẽ jãvo, hã jé sóg kãtĩ mũ, inh, hã vỹ: tỹ sóg ẽprã ke fi kósin ẽn nĩ, he mũ,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kỹ ag tóg cidade ũ ra mũ mũ, tá nũgnũr jé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ag mũn kỹ ũ tóg Jesus mỹ: “sỹ ã mré tĩg há tóg tĩ,” he mũ. “Ã tỹ hẽn ra tĩg kỹ sóg ã mré tĩg ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Kỹ Jesus tóg ti mỹ: “hã ra tóg jagy tĩ,” he mũ. “Ĩn tũ sóg nĩ. Mĩg vỹ kré nỹtĩgtĩ, jẽsĩ vỹ jagfe nỹtĩgtĩ gé, ag jãvo isỹ hẽ tá nũr ke tóg tũ tĩ. Tỹ sóg ẽprã ke fi kósin ẽn nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kỹ Jesus tóg kejẽn ũ mỹ: “mũ nỹ, inh mré,” he mũ. Hã ra tóg ti mỹ: “inh hỹn ver tĩg mũ ha, sỹ inh panh ter kỹ ga ki ti fón jé ver,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hã ra Jesus tóg ti mỹ: “vó,” he mũ. “Inh ki ge tũ ag vỹ ã panh kej han mũnh mũ. Ã tỹ inhhã inh mré tĩg há tóg tĩ, ã tỹ Topẽ tỹ tỹ ẽg pã'i nĩnh ke ẽn kãmén jé,” he tóg ti mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kỹ ũ tóg ti mỹ ke mũ gé sir, Jesus mỹ. “Sỹ ã mré tĩg há tóg tĩ,” he tóg. “Hã ra sóg inh jamã ra tĩg sór mũ ver, sỹ inh mré ke fag mỹ isĩg ke tó jé,” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kỹ Jesus tóg ti mỹ: “vó,” he mũ gé. “Ẽg tỹ arado tỹ ga kũm kỹ ẽg pi(jé) vẽsyjãm ẽvãnh tĩ',” he tóg. “Ge ti nĩ, ã tỹ inh mré tĩg sór kỹ. Inh mré ã tóg tĩg mũ. Ã tỹ ã tũ han sór tĩn kỹ ã tóg Topẽ tỹ tỹ ẽg pã'i nĩ tá krỹg ke tũ nĩ,” he tóg, Jesus ti, ũ tỹ ti mré tĩg sór mũ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kỹ Jesus tóg ũ ag vin mũ gé sir, ũ tỹ 70 (ke) ag. Kỹ tóg ag jẽgnẽg mũ sir, ag tỹ ti jo mũ jé. Ũn régre tĩn', ũn régre tĩn' he tóg. Ag mỹ tóg ke mũ, ag tỹ ẽmã kar mĩ Topẽ kãmén mũn jé, cidade kar mĩ ke gé. Ag nón tóg ra tĩg sór mũ gé, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kỹ tóg ag mỹ: “inh mỹ ag tóg ẽkré ri ke nỹtĩ, ãjag tỹ ũn mỹ tónh ke mũ ag,” he mũ. “Kejẽn ẽg jakré tóg éhé nỹgtĩ, hã ra ag pipir nỹtĩ, ũ tỹ krenh ke mũ ag. Kỹ ag tóg ãjag tỹ krég mũ (hã) ra kre kãn tũ nĩgtĩ sir. Ge ti nĩgtĩ, inh vĩ ti. Ũn e ag tóg inh ki ge sór mũ nĩ, hã ra ũ tỹ ag mỹ tónh ke tóg tũ tĩ,” he tóg. “Hã kỹ Topẽ mré vĩmnĩ, ti tỹ ũ ag jẽgnẽn jé, ag tỹ ag mỹ tugtón jé, ti vĩ ti,” he tóg, Jesus ti, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Ha mũjẽg. Ha vé, carneiro krẽ vỹ vẽnh jy nĩgãn ki kagtĩg nỹtĩ, mĩg tỹ ag mãn sór kỹ. Mé krẽ ẽn ri ke ãjag nỹtĩ, hã ra sóg ãjag jẽgnẽg mũ, kỹ Topẽ vỹ ãjag jy nĩgãn mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Kỹ ãjag mũn kỹ saco ma mũ tũg nĩ, bolso ẽn, jãnkamy tũ ke gé, pẽn né vẽnh kafã gé(g) mũ tũg nĩ gé, pẽn to ró ẽn. Kỹ ãjag tỹ ũ ven kỹ ti mỹ: “ã mỹ há?” he tũg nĩ gé. Jatun mỹ mũmnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kejẽn ãjag tóg ẽmã ũ tá junjun ke mũ. Kỹ ãjag tỹ ĩn ũ ra ge kỹ tá ke fag mỹ: “Topẽ jé ãjag ki rĩr, kỹ ãjag jé jatun mỹ nỹtĩ nĩ,” hemnĩ fag mỹ,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","“Kỹ tá ke ũ tỹ inh ki rã kỹ tóg jatu' he mũ sir, ti tỹ tỹ Topẽ kósin nĩn kỹ. Tá ke ũ tỹ inh ki rã jãvãnh nĩn kỹ tóg jatu' he tũ nĩ sir. Ti jãvo ãjag tóg jatu' he mũ sir inhhã. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ĩn ẽn krẽm nũgnũrmnĩ, ãjag tỹ kãra ge ja ẽn krẽm. Fag tỹ ãjag mỹ nén nĩm mũ ẽn komnĩ gé. Ũn rãnhrãj han mũ ẽn tóg ti kaja venh ke mũ, ti rãnhrãj kaja ti, hã kỹ ag tóg ãjag jẽn ke mũ sir, vẽnh kaja jé. Ĩn ũ kãra ge tũg nĩ, ẽmã ẽn tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ãjag tỹ ẽmã ũ tá junjun kỹ ĩn pir krẽm nỹtĩmnĩ, tá ke ag tỹ ãjag mỹ: “kãge ra,” hen kỹ. Ag vẽjẽn hã komnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ũn kagyga ag tỹ há' hemnĩ. Ag mỹ: “Topẽ vỹ tỹ ãjag pã'i nĩnh mũ, ũn ri,” hemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kejẽn ẽmã ũ tá ke ag tóg ãjag mỹ: “kãge ra,” he jãvãnh nỹtĩnh mũ. Kỹ ẽmã ẽn fĩn rãm kỹ ag mỹ tag tómnĩ, ha mẽ: ");
INSERT INTO kgpNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“ha vé, ẽg pẽn nug hã kykũnh ẽg tóg mũ, ãjag tỹ ẽg kavénh tũ nĩ jé,” hemnĩ. “Ge ra ẽg tóg ãjag mỹ tó mũ, ẽg tỹ ãjag mỹ nén tónh kãmũ jan ki, hã vỹ: “Topẽ vỹ tỹ ẽg pã'i nĩnh mũ, ũn ri,” he mũ,” hemnĩ ag mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Ha mẽ, kurã tỹ ẽgno ki ag tóg vẽsỹrénh ke mũ, ag tỹ ãjag vĩ mẽ jãvãnh kỹ. Cidade tỹ Sodoma tá ke ag vẽsỹrénh kãfór han jé ag tóg ke mũ, kurã ẽn kã, ha vemnĩ,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kỹ tóg: “sỹ cidade tỹ Corazim ki ke ag mỹ tag tó sór mũ, ha mẽ,” he mũ. “Kórég ve jé ãjag tóg ke mũ,” he tóg. “Sỹ cidade tỹ Betsaida ki ke ag mỹ tag tó sór mũ gé, ha mẽ. Kórég ve jé ãjag tóg ke mũ gé,” he tóg. “Ẽg tỹ nén han vãnh tỹ hẽn ri ke hyn han isóg ãjag mỹ, milagre tỹ hẽn ri ke, hã ra ãjag tóg ãjag jykre tovãnh sór tũ nĩgtĩ,” he tóg. “Cidade tỹ Tiro tá, cidade tỹ Sidom tá sóg ẽg tỹ nén han vãnh ẽn hyn han tũ nĩ. Sỹ tá milagre hyn han mũ ra ag tóg ãjag jykre kórég tovãnh mũ vẽ, vãsỹ,” he tóg. “Ãjag jykre pãno to ag jykrén ke mũ vẽ, kygfỹ ag mũ vẽ, ag mỹ ti e tĩnh mũ vẽ, sỹ ag mỹ tó mũ ra. Ag jãvo ãjag tóg tovãnh sór tũ nĩ', to jykrén sór tũ pẽ nĩ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","“Tiro tá ke ag vỹ vẽsỹrénh kãn ke mũ, kurã tỹ ẽgno ẽn ki, Sidom tá ke ag ke gé, ag jykre pãno to. Ag vẽsỹrénh kãfór han jé ãjag tóg ke mũ jãvo, ha mẽ,” he tóg, Corazim tá ke ag to, Betsaida tá ke ag to ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kỹ tóg: “sỹ cidade tỹ Cafarnaum ki ke ag mỹ tag tó sór vẽ, ha mẽ,” he mũ. “Ũri tóg ver ãjag mỹ sér tĩ,” he tóg. “Kanhkã ve jé ẽg tóg ke mũ,” he ãjag tóg tĩ, ón kỹ. Hã ra ãjag tóg nũgme ki vár ke mũ jãvo, inferno ki,” he tóg, Jesus ti. Ti tỹ ã vĩ jẽmẽ jãvãnh mũ ag mỹ vi kónãn hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kỹ tóg ã mré ke ag mỹ tag tó mũ. “Ũ tóg ãjag vĩ mẽ sór mũ, ha vemnĩ,” he tóg. “Kỹ tóg sir inh vĩ mẽg mũ gé, ti tỹ ãjag vĩ mẽn kỹ. Ũ tóg ãjag vĩ mẽ sór tũ nĩ, ha vemnĩ. Kỹ tóg inh vĩ mẽnh ke tũ nĩ gé. Ti tỹ inh vĩ mẽnh ke tũ nĩn kỹ tóg ũ tỹ inh jẽnẽg mũ ẽn vĩ mẽnh ke tũ nĩ gé sir, Topẽ vĩ ti,” he tóg, Jesus ti. Ti tỹ ã mré mũ tĩ ag mỹ tón hã vẽ, ag tỹ ti vĩ kãmén mũ jé, kór há mĩ, kuvar há mĩ. Kỹ ag tóg sir mũ mũ, ũ tỹ 70 (ke) ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kejẽn ag tóg ti to vỹnvỹn ke mũ, kỹ ag tóg ti mỹ vĩ sér han mũ sir. “Senhor',” he ag tóg mũ. “Vẽnh jagrẽ kórég ag vỹ ẽg vĩ ki han tĩ. Ã jiji tó kỹ ẽg tóg ag mỹ vĩ tĩ, kỹ ag tóg ki hã han tĩ,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kỹ tóg ag mỹ: “vãsỹ inh Japo vé, ti tỹ kanhkã tá kãtére kỹ,” he mũ. “Ti fĩn rãm sóg, hã kỹ sóg ti fón. Ta tỹ kómkóm ke ri ke nĩ ja ti nĩ, ti kutẽ ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ti kri ke vỹ tỹ inh nĩ. Ha vé, ãjag to sóg vãsãn mũ, pỹn tỹ ãjag kókén tũ nĩ jé, ãjag tỹ ti sãn mũ ra, pỹn kakrã ke gé, Nén-Kórég kar ag ke gé. Ũ vỹ ãjag kókén ke tũ pẽ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hã ra tag to mỹ há nỹtĩ tũg nĩ ver. Tag vỹ tỹ nén ũ tũ nĩ ver. Vẽnh jagrẽ kórég vỹ ãjag vĩ han, vẽnh kuprĩg ke gé. Hã ra tag to mỹ sér nỹtĩ tũg nĩ. Nén ũ vỹ há pẽ nĩ, kỹ tag hã to mỹ sér nỹtĩmnĩ. Ãjag jyjy vỹ ránrán kỹ nỹtĩ, Topẽ livron ki, kanhkã tá, ãjag tỹ kanhkã tá junjun jé. Kỹ tag hã to mỹ sér nỹtĩmnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kỹ tóg Jesus mỹ sér tĩ, hora ẽn kã. Topẽ kuprĩg tỹ ti krĩn kỹ tóg ti mỹ sér tĩ: “jóg',” he mũ. “Tỹ ã tóg kanhkã tãn ag kãfór kar nĩ, kar ã tóg tỹ ẽprã ke ag kãfór nĩ gé,” he tóg. “Inh mỹ tóg há tĩ, ã tỹ nén han mũ ti. Ũ tỹ: “ki kanhró mág inh nĩ,” he mũ ag mỹ ã tóg ã jykre ven ja tũ nĩ. Ag mỹ ã tóg kãmén ja tũ nĩ. Ũ tỹ gĩr ri ke ki kagtĩg ag hã mỹ ã tóg ven ja nĩ, ã jykre ti,” he tóg. “Hỹ, hã vẽ. Ã tỹ nén to jykrén mũn hã vẽ, hã kỹ ã tóg ag hã mỹ ã jykre ti nĩm. Hã ra tóg há tãvĩ nĩ, jóg',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kỹ tóg ã mré mũ tĩ ag mỹ: “inh jóg tóg inh mỹ tovãnh kãn, ã tỹ nén han ja kar ti,” he mũ. “Kỹ ũ pi(jé) ti kósin ki kanhró nĩ'. Inh jóg ne inh ki kanhró nĩ'. Kỹ ũ pi(jé) inh jóg ki kanhró nĩ gé'. Inh hã ne ti ki kanhró nĩ', isỹ tỹ ti kósin nĩn kỹ. Hã ra sóg ãjag mỹ ti kãmén jé kãtĩ mũ, inh jóg ti. Isỹ tag to ũn kuprẽg mũ ag hã mỹ sóg ti kãmén tĩ, inh jóg ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kỹ tóg ã mré mũ tĩ ag mỹ nén ũ kãmén mũ gé. Vyrmỹ tóg ag mỹ ke mũ, kỹ tóg: “ãjag hã ne vég mũ', Topẽ jykre ti, hã kỹ Topẽ tóg ãjag ve há han mũ,” he mũ. “Sér pẽ ti tĩ, ũ tỹ ti jykre vég mũ ag mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","“Ki hã sóg tó mũ, ha mẽ. Ũ tỹ hẽn ri ke ag vỹ inh ve sór tãvĩ ja nỹtĩgtĩ, vãsỹ, ãjag tỹ ũri nén vég mũ tag ti. Hã ra ag tóg inh mur ken jo kãgter kãn. Topẽ vĩ tó tĩ ag ja vẽ, pã'i mág ag ja vẽ, hã kỹ ag tóg ãjag tỹ nén vég mũ ve sór tãvĩ ja nỹtĩgtĩ. Hã ra ag tóg ve ja tũ nĩ, mẽ ja tũ ag tóg nĩ gé, ãjag tỹ ũri nén mẽg mũ ti. Ãjag hã ne mẽg mũ inhhã',” he tóg, Jesus ti, ti mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kỹ vãhã Topẽ vĩ to professor ũ vỹ ag kãmĩ jẽgnẽ mũ, kỹ tóg Jesus ki jẽmẽ sór mũ. Ti tỹ ón kỹ ti vĩ mẽ sór vẽ, hã kỹ tóg ti mỹ: “Senhor',” he mũ. “Inh hỹn hẽ ri kenh mũ, isỹ rĩr krỹg ja tũ ve jé?” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Kỹ Jesus tóg ti mỹ: “ne nỹ hỹn rán kỹ nĩ, Topẽ vĩ ki?” he mũ. “Topẽ jykre tỹ ne han jé ã ke mũ hỹn'?” he tóg. “To ke há ã tóg nĩ, ha inh mỹ tó,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kỹ tóg ti mỹ: “Topẽ vỹ tỹ ã kri ke nĩ, kỹ ti hã to há nĩmnĩ, ti ki rã há han nĩ, ti to jykre pir nĩmnĩ, ti to tar nĩmnĩ, ti mỹ ã tỹ nén han mũ kar ẽn han nĩ, ha mẽ. Kỹ ã régre kar ki rĩr nĩmnĩ gé, ã tỹ vẽnh ki rĩr há han ri ke. Topẽ tỹ nén tón hã vẽ,” he tóg, Topẽ vĩ to professor ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Kỹ Jesus tóg: “hỹ,” he mũ. “Ki hã ã tóg tó mũ,” he tóg. “Tag han ra, kỹ ã tóg rĩr krỹg ja tũ venh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hã ra tóg ti mỹ há tũ nĩ, Jesus vĩ tag ti, hã kỹ tóg ti mỹ: “kỹ ũ nỹ tỹ inh régre nĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Kỹ Jesus tóg ti mỹ tag tó mũ, ha mẽ. “Kejẽn ũ tóg nĩgtĩ. Hã ra tóg Jerusalém tá kãtĩg kỹ Jericó ra tĩ mũ. Ẽpry jagma, ẽmĩn jagma ũn jykre kórég ag tóg ti jo vãjig mũ, bandido ag. Kỹ ag tóg ti kãgmĩ kỹ ti kur kunũg mũ. Ti mrãnmrãn ag tóg mũ. Ti tén kren ag tóg mũ, kỹ ag tóg hã ki ti tovãnh kar mũ mũ sir, ti tũ mãn kãn kỹ. Kỹ tóg tá nỹ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ti tỹ tá nỹ ra ũ tóg ẽpry ẽn jagma kãtĩ mũ gé. Topẽ tũ ki rĩr tĩ ũ vẽ. Ti vég tóg mũ, ũn vẽsỹrénh kỹ nỹ ẽn ti, hã ra tóg ti venh rã tũ nĩ. Ẽmĩn jagma tóg tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kỹ vãhã Levi krẽ ũ tóg ẽpry jagma kãtĩ mũ gé. Tá jun kỹ tóg ti vég mũ gé, hã ra tóg ti venh rã tũ nĩ gé. Ẽmĩn jagma tóg tĩ mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kỹ vãhã Samaria tá ke ũ tóg ẽpry jagma kãtĩ mũ gé. Kỹ tóg tá jun mũ, kỹ tóg ti vég mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kỹ tóg ti venh rã mũ inhhã. Ti kygtãg tóg mũ sir, azeite tỹ, vinho tỹ ke gé, ti mỹ to tĩn kỹ. Ã kur tỹ tóg ti pãg mũ sir. Kỹ tóg ã mẽg kri ti nĩm mũ, ã tỹ ti ma tĩg jé. Hã kỹ tóg ag tỹ ĩn krẽm nũr jafã tá jun mũ sir. Kỹ tóg tá ti ki rĩr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tỹ vaj kỹ tóg tĩg mãn sór mũ, hã kỹ tóg ũ tỹ ĩn ki rĩr mũ ẽn mỹ jãnkamy régre vin mũ, kỹ tóg ti mỹ: “ti ki rĩr há han,” he mũ. “Jãnkamy tag tỹ ã mỹ tá krỹg tũn kỹ sóg ã mỹ kajãm mãn mũ, sỹ vỹn ken kỹ,” he tóg. “Kajãm kãn jé sóg ke mũ, sỹ vỹn ken kỹ,” he tóg, Samaria tá ke ẽn ti. Ti tỹ ũn kaga ki rĩr mũn hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kỹ tóg: “kỹ ũn tãgtũ ag vỹ ti ve ja nĩ. Ag kã ũ tỹ hẽ nỹ tỹ ti régre ja nĩ, ag tỹ ũn vóg kónãn ja ẽn régre? Ha to jykrén (ke)ma',” he tóg, Jesus ti, Topẽ vĩ to professor ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kỹ ũ tỹ ti ki jẽmẽg mũ ẽn tóg ti mỹ: “ũ tỹ ti jagãgtãn mũ ẽn vỹ tỹ ti régre ja nĩ,” he mũ. Kỹ Jesus tóg ti mỹ: “hỹ, tó há han ã,” he mũ. “Kỹ ẽn ri ke han nĩ. Ũn vẽsỹrénh mũ ag jagãgtãn kãn nĩ, ti ri kén,” he tóg, Jesus ti. Ti tỹ ũ tỹ ón kỹ ti ki jẽmẽg mũ mỹ tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kejẽn ag tóg mũ mũ, Jesus ag, kỹ ag tóg ẽmã sĩ ũ ki junjun mũ. Tá ũ fi tóg nĩ nĩ, fi jijin hã vỹ: Marta, he mũ. Ẽn fi vỹ Jesus mỹ: “inh ĩn kãra ge jẽg, ãjag tỹ ẽg mré nỹtĩ jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kỹ fi jãvy fi vỹ nĩ gé, hã vỹ: Maria, he mũ. Kỹ Maria fi vỹ Jesus mré nĩ nĩ, ti vĩ jẽmẽ jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Hã ra Marta fi vỹ rãnhrãj (ka)mẽ nĩ, Jesus ag mỹ vẽjẽn han jé. Jãvo Maria fi tóg nĩ nĩ. Kỹ Marta fi tóg Jesus mỹ: “Senhor',” he mũ. “Rãnhrãj mág han tĩ sóg nĩ, hã ra fi tóg nĩ nĩ. Fi mỹ ké, fi tỹ inh mré vẽjẽn ki rĩr jé,” he fi tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hã ra Jesus tóg fi mỹ: “krĩ kufy ã tóg nĩ, nén ũ tũ to, hã ra fi tóg inh vĩ jẽmẽg nĩ nĩ,” he mũ, Marta fi mỹ. “Vẽjẽn to vẽnh kutãn tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nén ũ pir hã ne há nĩ', hã vỹ: inh vĩ, he mũ. Maria fi vỹ inh vĩ hã jẽmẽ sór mũ, kỹ sóg fi mỹ: “ha nén ũ han,” he jãvãnh nĩ. Nén ũ há kuprẽg fi tóg, fi tỹ inh vĩ mẽ sór kỹ,” he tóg, Jesus ti, Marta fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kejẽn tóg Topẽ mré vĩ mũ, Jesus ti, ẽmã ũ tá nĩ kỹ. Ti tỹ Topẽ mré vẽmén kar kỹ ti mré mũ tĩ ag tóg ti mré vĩnh kãmũ mũ. Kỹ ag tóg ti mỹ: “Senhor',” he mũ. “Ẽg kanhrãn nĩ, ẽg tỹ Topẽ mré vĩ há han jé. João vỹ ã mré mũ tĩ ag kanhrãn. Ge ki ẽg kanhrãn nĩ gé,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kỹ tóg ag kanhrãn kỹ ag mỹ: “Topẽ mré vĩ kỹ tag tómnĩ, ha mẽ,” he mũ. “Ẽg jóg mág, ã jyjy tó ẽg tóg tĩ. Kỹ vẽnh kar jé ã tỹ tỹ ũn mág nĩ vé. Ẽg jé kãnhmar ã tỹ tỹ ẽg pã'i nĩ vé. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ẽg mỹ ẽg jẽn ti nĩm, kurã kar ki, ẽg tỹ kurã kar ki ko tĩ ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kỹ ẽg mỹ vẽnh pãte fón nĩ, ẽg tỹ ã vĩ mranh ja ti, hã jé ẽg tóg ẽg tỹ jagnẽ to jũ tỹ jagnẽ mỹ vẽnh pãte fón ke mũ gé. Kỹ ẽg tỹ ã vĩ mranh sór kỹ ẽg kren han nĩ, ẽg tỹ mranh tũ nĩ jé,” hemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kỹ tóg ag mỹ ẽg tỹ Topẽ mré vẽmén tĩ ẽn kãmén mãn mũ. Kỹ tóg ag mỹ: “kejẽn ũ tóg nĩgtĩ,” he mũ. “Kuty si há tá tóg ã régre ĩn ki jun mũ. Kỹ tóg ti mỹ: “régre',” he mũ. “Inh mỹ ẽmĩ tãgtũ nĩm, sỹ kar ã mỹ ti ri kén kỹ nĩm jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Inh mré ke ũ vỹ jun. Kór há tá tóg kãtĩg, kuvar há tá. Hã ra sỹ ti mỹ ne han ke tóg tũ tĩ,” he tóg, ã régre mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kỹ ti régre tóg ti mỹ: “hã ra sóg nũr nỹ nĩ,” he mũ. “Kar inh krẽ tóg inh mré nũgnũr nỹtĩ gé. Jãnkã vỹ nĩfénh kỹ jẽ nĩ. Hã kỹ tóg inh mỹ vẽnhmỹ tĩ, inh nĩnh ke mũ ra, sỹ ã mỹ ẽmĩ nĩm jé. Ũ ki jãvãnh,” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hã ra tóg sir to vĩ mãn', to vĩ mãn' he mũ. Hã kỹ tóg nĩ kỹ ti mỹ nĩm mũ sir, ti tỹ ti mỹ ẽmĩ to vĩ mũ ti. Ti régre vẽ, ũ tỹ ti mỹ to vĩnh kãtĩ mũ ti. Ge ra tóg ti mỹ nĩm ke tũ nĩ vẽ, ti tỹ tỹ ti régre ra. Ti tỹ ti mỹ to vĩ mãn', to vĩ mãn' he tugrĩn tóg sir ti mỹ nĩm mũ jãvo. Ẽg tỹ Topẽ mré vĩ ri ken hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ha mẽ, sỹ ãjag mỹ nén tó mũ tag ti. Topẽ mỹ nén kar to vĩmnĩ, kỹ tóg ãjag mỹ han mũ sir. Ãjag tỹ ti mỹ nén ũ to vĩ mũ ẽn jãvãnh nĩ, kỹ ãjag tóg venh ke mũ sir. Ti mré vĩ kỹ ẽg tỹ ti jãnkã tỹ tórón tórón ke ri ke han nĩ, kỹ tóg ãjag mỹ ti róm ri ke han mũ, ti tỹ ãjag mỹ ãjag tỹ nén to vĩ mũ ẽn han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Hỹ, hã vẽ. Ãjag tỹ ti mỹ nén to vĩn kỹ tóg ãjag mỹ han mũ. Ãjag tỹ ti jãvãnh kỹ ãjag tóg venh ke mũ. Ãjag tỹ ẽg tỹ jãnkã tỹ tórón tórón ke ri ke han kỹ tóg ãjag mỹ ti róm ri ke han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kejẽn ãjag kósin tóg ãjag mỹ pirã to vĩ mũ. Kỹ ãjag pi(jé) ti mỹ pỹn nĩm ke mũ'. Pirã hã nĩm jé ãjag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kejẽn tóg ãjag mỹ garĩnh ovo to vĩ mũ, ãjag kósin ti. Kỹ ãjag pi(jé) ti mỹ pỹn kakrã nĩm ke mũ'. Garĩnh ovo hã nĩm jé ãjag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jykre pãno ãjag nỹtĩ. Ãjag jykre pãno (hã) ra ãjag tóg ãjag krẽ mỹ nén ũ há nĩm tĩ. Ge ti nĩ gé, ãjag tỹ Topẽ mỹ nén ũ to vĩn kỹ. Nén ũ há hã nĩm jé tóg ke mũ. Hã ra tóg ãjag kãfór han tĩ, ẽg jóg tỹ kanhkã tá nĩ ti. Ãjag tỹ ti mỹ to vĩn kỹ tóg ã kuprĩg tỹ ãjag jagrẽ han ke mũ mỹr, Topẽ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kejẽn tóg ũn jagrẽ kórég mỹ ti jagrẽ kutẽm mũ. Ti vĩ vãnh han ja tóg nĩ, ti jagrẽ ti. Jesus tỹ ti kutẽm kar tóg vĩ há nĩ sir. Kỹ tóg vẽnh kar mỹ e tĩ sir, ag mỹ tóg sér tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hã ra ũ ag tóg ti to: “jagrẽ kórég ti nĩ,” he mũ. “Nén-Kórég ag pã'i vỹ tỹ ti jagrẽ nĩ, Satanás ẽn, Belzebu he mũ ẽn,” he ag tóg mũ, ón kỹ. “Hã kỹ tóg Nén-Kórég ag pan tĩ, ag jagrẽ kórég ag. Nén-Kórég ag pã'i jykre tỹ tóg ag pan tĩ,” he ag tóg ón kỹ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hã ra ũ ag tóg ón kỹ ti jykre ve sór mũ gé, kỹ ag tóg ti tỹ ẽg tỹ nén han vãnh han mũ ve sór mũ sir, ti tỹ ag mỹ kanhkã jykre ven jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hã ra Jesus tóg ki kanhró nĩ, ag tỹ nén to jykrén mũn ki. Hã kỹ tóg ag mỹ: “pã'i pir krẽm ke ag tỹ jagnẽ kato tẽn kỹ ag tóg jagnẽ kãgtén kãn ke mũ,” he mũ. “Ĩn pir krẽm ke fag tỹ jagnẽ kato tẽn kỹ fag tóg jagnẽ kãgtén kãn ke mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ge ti nĩ, Nén-Kórég ag jykre ti. Nén-Kórég ag tỹ jagnẽ kato tẽn kỹ ag tóg jagnẽ tỹ tũ' henh mũ gé vẽ, Satanás ag. Hã kỹ tóg vẽnhmỹ nĩ, ãjag vĩ ti, ãjag tỹ iso: “Satanás jykre tỹ, Belzebu ẽn jykre tỹ tóg Nén-Kórég ag pan tĩ,” he mũ ti. Ag tỹ jagnẽ kato tẽgtẽ to ken hã vẽ sir, ha mẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Belzebu jykre tỹ tóg ag pan mũ, Nén-Kórég ag,” he ãjag tóg tĩ iso. Ãjag mré ke ag to jykrén nĩ. Nén-Kórég ag pan ag tóg tĩ gé, ãjag mré ke ag. Ag pi(jé) Satanás jykre ki ag pan tĩ'. Topẽ jykre ki ag tóg ag pan tĩ (mỹr') Ãjag tỹ tag to jykrén kỹ ãjag tóg inh jykre há ki kanhrãn ke mũ vẽ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Topẽ kuprĩg jykre tỹ sóg Japo ag pan tĩ mỹr, ha mẽ. Topẽ kuprĩg tỹ Japo ag pan kãn kỹ Topẽ tóg tỹ ẽg pã'i nĩ vẽ, mỹr. Tag to jykrén nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ũ tỹ é he (ka)mẽ ag tóg ãjag tũ ki rĩr há han ti. Ag rógro vỹ jẽgtĩ, kỹ ag tóg ãjag ĩn ki rĩr tĩ sir, ũ tỹ ag tũ mãg tũ nĩn jé. Kỹ ũ tóg ag tũ vóg ke tũ nĩ gé, ag tỹ ki rĩr há han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kejẽn ũ tóg ũ tóg ũ tỹ é he (ka)mẽ ẽn in tá jun mũ, ũ tỹ ti tar kãfór nĩ ti. Ti rárá kãfór nĩn kỹ tóg ti tỹ hẽn ri kenh mũ sir. Kỹ tóg ti rógro vãg mũ. Ti tỹ ũn kãgtén jafã vãg tóg mũ, kỹ tóg ti tũ mãn kãn mũ gé sir. Ge ti nĩ, isỹ nén han mũ ẽn ti. Ũ tỹ é he (ka)mẽ ri ke ti nĩ, Japo ti, hã ra sóg ũn tar ẽn ri ke nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ãjag tỹ tỹ inh mré ke tũ nỹtĩn hã kỹ ãjag tóg inh kato tẽgtẽ mũ. Ãjag tỹ inh mré ẽprã ke ag tỹ Topẽ to kãmũ han tũ nĩn kỹ ãjag tóg ag kãmũ kamẽg mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kejẽn sóg vẽnh jagrẽ kórég ũ kutẽm mũ. Kỹ tóg ga kórég mĩ tĩ mũ, ti jagrẽ ẽn ti. Goj venh ke tũ tóg nĩ, tá. Vẽnhkán ke tũ tóg nĩ gé, ti tỹ hẽ ri ken kỹ vẽnhkán ke tũ tĩn kỹ. Kỹ tóg vãhã to jykrén mũ sir. “Inh hỹn ẽn ra tĩg mãn ha, sỹ ũ tá kãkutẽ ja ẽn ra. Inh mỹ tóg tỹ ĩn ri ke ja nĩ, kỹ inh jé hỹn ti kãra rã mãn ha,” he tóg mũ, ti jagrẽ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kỹ tóg ti venh kãtĩ mũ. Hã ra tóg sir krĩ há nĩ. Kỹ tóg ti mỹ ĩn há ri ke nĩ sir, ĩn prur, ĩn sĩnvĩ ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kỹ tóg Nén-Kórég tỹ 7 (ke) ag mỹ tónh tĩ mũ sir. “Ha kãmũ jẽg,” he jé tóg ke mũ. Hã ra ag jykre pãno tóg ti jykre pãno kãfór nĩ. Kỹ ag tóg sir ũ ẽn kãge ge mũ, tỹ ag tóg ti jagrẽ nỹtĩ sir, isỹ ũn mỹ ti jagrẽ pir kutẽm ja ẽn ti. Hã kỹ tóg kórég tãvĩ nĩ sir. Ti jagrẽ kórég pir kutẽm inh nĩ vẽ, hã ra ũ tỹ 8 (ke) ag tóg tỹ ti jagrẽ nỹtĩ, ti tỹ inh ki rã tũ nĩn kỹ,” he tóg, Jesus ti. Ti tỹ ag mỹ vẽnh jagrẽ jykre tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kỹ ũ tỹ ti vĩ mẽg mũ ũ fi tóg prẽr mũ sir, fi tỹ ti vĩ tag mẽ kỹ. Ũn e ẽn kãmĩ fi tóg jẽ nĩ, kỹ fi tóg ti mỹ ke mũ. “!..Topẽ vỹ ã mỹnh fi ve há han, fi tỹ ã han tugrĩn, fi tỹ ã pafãm tugnen..!” he fi tóg, prẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kỹ Jesus tóg fi mỹ: “hỹ,” he mũ. “Hã ra Topẽ vỹ ã ve há han ke mũ gé, ã tỹ ti vĩ jẽmẽn kỹ. Hã kỹ ã tỹ ti vĩ mẽ kỹ ke króm nĩ, kỹ tóg ã ve há tãvĩ han ke mũ,” he tóg, Jesus ti, ũ tỹ prẽr mũ ẽn fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hã ra ũ tỹ hẽn ri ke ag tóg sir tá junjun mũ, ti vĩ mẽ jé. Kỹ tóg fór tãvĩ tĩ. Kỹ Jesus tóg ag mỹ: “kórég ãjag nỹtĩ,” he mũ. “Ón kỹ ãjag tóg nén han vãnh ve sór mũ. Venh ke tũ ãjag tóg nĩ. Nén ũ pir hã ve jé ãjag tóg ke mũ, hã vỹ: Jonas tỹ nén ve ja ẽn ri ke, he mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","“Jonas vỹ cidade tỹ Nínive tá ke ag mỹ Topẽ vĩ tó ja nĩ, kỹ ag tóg ti vĩ mẽ há han ja nĩ. Ẽn ri ke han jé sóg ke mũ, ãjag mỹ. Tỹ sóg ẽprã ke fi kósin ẽn nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Kỹ pã'i mág ẽn fi, kanhkã tãpér tỹ sul tá kãtĩg ja ẽn fi, tã tá kãtĩg ja ẽn fi vỹ nĩnh ke mũ gé, kurã tỹ ẽgno ki, sỹ vẽnh kar jykre venh ke kurã ẽn ki. Ãjag mré fi tóg jẽnh mũ, kỹ Topẽ tóg ãjag mỹ vĩ kónãn ke mũ, fi ve kỹ. Kanhkã fyr ja tá fi tóg kãtĩg ja nĩ, vãsỹ, fi tỹ pã'i mág tỹ Salomão vĩ mẽ jé. Salomão kãfór vỹ tỹ inh nĩ, hã ra ãjag tóg inh vĩ mẽ jãvãnh nỹtĩ fi jãvo,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Kỹ Topẽ vỹ Nínive tá ke ag ve kỹ ãjag mỹ vĩ kónãn ke mũ gé, kurã tỹ ẽgno ẽn ki, ha vemnĩ. Nínive tá ke ag tỹ Jonas vĩ mẽ kỹ ag tóg ãjag jykre togvãnh ja nĩ. Tỹ sóg Jonas kãfór nĩ, hã ra ãjag tóg ãjag jykre tovãnh jãvãnh nỹtĩ, sỹ ãjag mỹ tó tĩ (hã) ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ẽg tỹ lampião grug kỹ ẽg pi(jé) ĩn krẽm péju kỹn fẽg tĩ', ẽg pi(jé) kẽj krẽm fẽg tĩ'. Ti fẽg jafã kri ẽg tóg fẽg tĩ, lampião gru ti. Kỹ ẽg tóg ti gru tỹ ve há jẽgtĩ, ẽg tỹ ĩn kãtá kãmũ kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Ẽg kanẽ hã tóg tỹ ẽg tỹ ve jafã nĩ. Kỹ tóg ẽg jo kurã han tĩ, ẽg kanẽ ti, ti há nĩn kỹ. Kỹ tóg ẽg jo kurã kar nĩ sir, ẽg kanẽ há nĩn kỹ. Ẽg kanẽ kórég nĩn kỹ tóg ẽg jo kuty ke kãn mũ sir. Kỹ tóg ge nĩ, ẽg jykre kórég ti. Ẽg kanẽ kórég ri ke ti nĩ, ẽg jo kuty han tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kỹ vẽnh kanhrãn nĩ. Ke tũ nĩ mũ ra tóg ãjag jo kuty ri ke nĩ. Vẽnh jykre kórég hã vẽ. Kỹ vẽnh jykre kórég han sór tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ãjag jo kurã nĩn kỹ tóg há tãvĩ nĩ, ãjag jo kuty tũ nĩn kỹ, ãjag jo kuty sĩ tũ nĩn kỹ ke gé. Ãjag jykre há tãvĩ nĩn kỹ tóg ãjag jo kurã ri ke nĩ. Kỹ ãjag tóg sir lampião gru ri ke nỹtĩ gé. Lampião gru mág nĩn kỹ tóg kómkóm ke tĩ, ẽg kanẽ jo, kỹ tóg ẽg mỹ jẽngrẽ há han tĩ. Ge ẽg nỹtĩ, ẽg jykre há tãvĩ nĩn kỹ, ti kórég sĩ tũ nĩn kỹ,” he tóg, Jesus ti. Ti tỹ ag mỹ Topẽ jykre há tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ti tỹ ag mré vẽmén kar Fariseu ũ tóg ti mỹ: “inh mré jẽn kãtĩg,” he mũ. Kỹ tóg ti mré tĩ mũ, ti mré jẽn jé, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hã ra Jesus tóg Judeu ag jykre han ja tũ nĩ, ag jẽn jé ag tóg vẽnh nĩgpég tĩ. Kỹ tóg Fariseu ẽn mỹ e tĩ. Kỹ tóg to jykrén kónãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kỹ Jesus tóg ki kanhró nĩ, kỹ tóg ti mỹ kãmén mũ. “Fariseu vỹ tỹ ãjag nỹtĩ,” he tóg. “Kỹ ãjag tóg copo ven ja kugpég tĩ, pénky ven ja ke gé, hã ra ti kãtá ke tóg kavéj nĩ. Kỹ ãjag jykre vỹ ge nỹtĩ gé. Jykre há nĩ ve ãjag tóg nỹtĩ, hã ra ãjag tóg vẽnh jykre pãno han tĩ, hã vỹ: jãnkamy to ag lograr he tĩ, he mũ, ãjag prũ tũ fag mré nỹ, he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Krĩ tũ pẽ ãjag nỹtĩ. Ũ tỹ ẽg ven ja han mũ vỹ ẽg jykre han mũ gé mỹr. Ẽg jykre há nĩn kỹ ẽg ven ja vỹ há nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ũ jagãgtãn ra, ãjag tỹ nén ũ tỹ. Vẽnh jykre há kar han ra, kỹ tóg ãjag tỹ nén ũ kar jãnhkri nĩ ri ke nĩ sir,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Fariseu', Topẽ vỹ ãjag ve kónãn. Ón kỹ ãjag tóg Topẽ mỹ ãjag jakré tỹ dízimo han kãn tĩ. Ãjag jakré tỹ hortelã tỹ 10 (ke) nĩn kỹ ãjag tóg Topẽ mỹ ũn pir nĩm tĩ, dízimo han kỹ. Ãjag jakré tỹ arruda tỹ ãjag tóg dízimo nĩm tĩ gé, ãjag jakré tỹ vẽnh kagta kar tỹ mỹr, ãjag tỹ nén ũ kar mré hã. Nén ũ kar tỹ ãjag tóg dízimo vin tĩ, Topẽ mỹ. Hã ra ãjag tóg vẽnh jykre kuryj han tũ nĩ jãvo. Topẽ to há tũ ãjag tóg nỹtĩ, ti vĩ jẽmẽ jãvãnh ãjag tóg nỹtĩ. Ãjag tỹ ti tỹ ẽg jyvẽn ki króm mré hã ãjag jakré tỹ dízimo vin ra tóg há tãvĩ nĩnh mũ vẽ, ha mẽ. Hã ra ãjag tóg ki króm sór tũ nĩgtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Fariseu', Topẽ vỹ ãjag ve kónãn. Vẽnh kanhrãn jafã krẽm ãjag tóg vẽnh kãpãm kỹ nỹtĩ, vẽnh kar tỹ ãjag ve jé. Cidade kuju tá ãjag tóg mũgtĩ, kỹ vẽnh kar tỹ ãjag mỹ: “Senhor, ã mỹ há?” hen kỹ tóg ãjag mỹ sér tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Topẽ vỹ ãjag ve kónãn mỹr. Vẽnh kej si ri ke ãjag nỹtĩ, vẽnh kej to ró tũ ri ke. Kri mũ ag tóg tĩ, vẽnh kar, kỹ ag tóg ki kagtĩg nỹtĩ, ti tỹ tỹ vẽnh kej nĩ ti. Kỹ ag tóg vẽnh vatánh tá vẽnh kavénh tĩ. Tag ri ke ãjag tóg nỹtĩ. Kỹ ãjag krẽm ke ag vỹ Topẽ vĩ mranh tĩ, ãjag ven kỹ,” he tóg, Jesus ti, Fariseu ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kỹ Topẽ vĩ to professor ũ tóg Jesus mỹ: “ã tỹ Fariseu ag mỹ tag tó kỹ ã tóg ẽg to vĩ kónãn tĩ nĩ gé, ag mré,” he mũ, ẽg Senhor mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kỹ tóg: “ón kỹ Topẽ vĩ to professor',” he mũ. “Hỹ, Topẽ vỹ ãjag ve kónãn gé,” he tóg. “Vẽnh kar mỹ ãjag tóg vẽnh jykre kufy nĩm tĩ. Kufy jagy ti nỹ, vẽnh jykre ẽn ti, kỹ ãjag tóg han sór tũ nĩgtĩ. Ge ra ãjag tóg ag mỹ: “ha ki króm,” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Topẽ vỹ ãjag ve kónãn mỹr. Ãjag jóg'jóg ve ag vỹ Topẽ vĩ tó tĩ ag kãgtén. Jãvo ãjag tóg ag kej ki rĩr há han tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hã ki ãjag tóg ãjag jóg'jóg ve ag tỹ ag kãgtén to: “há ti nĩ,” he tĩ. Hã ki tóg ãjag mỹ há nĩ mỹr, ag tỹ ag kãgtén ja tugrĩn. Ag hã vỹ ag kãgtén ja nĩ, kỹ ãjag hã nỹ ag kej ki rĩr há han tĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Hã kỹ Topẽ vỹ ãjag to vĩ ja nĩ. Ki kanhró ti nĩ, Topẽ ti, hã kỹ tóg ãjag to vĩ kónãn ja nĩ, ha mẽ. “Inh vĩ tó tĩ ag jẽgnẽ jé sóg ke mũ ag mỹ, isỹ ũn vin mũ ag ke gé, ag tỹ ag mỹ inh vĩ tó jé. Hã ra ag tóg ag vóg kónãn ke mũ, ag kãgtén jé ag tóg ke mũ,” he ja tóg nĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ãjag jóg'jóg ve ag vỹ ag kygrẽn kãn, hã ra tóg ãjag mỹ há tĩ, hã kỹ Topẽ vỹ to ãjag vóg kónãn ke mũ. Ũ tỹ hẽn ri ke ag kygrẽn ag tóg, ãjag jóg'jóg ve ag, Topẽ tỹ ẽprã ke ag han kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ti kãke tóg Abel tén. Ti nón ke ag kãgtén ja ag tóg nĩ gé, ãjag jóg'jóg ve ag, Zacarias mré hã. Topẽ ĩn jãnkã krẽm ag tóg ti tãnh, Topẽ mỹ nén ũ pũn jafã ẽn ki, Zacarias ti. Topẽ tỹ jẽgnẽg mũ ag kãgtén tovãnh tũ pẽ ag nỹtĩ, ãjag jóg'jóg ve ag. Hã ra tóg ãjag mỹ há tĩ. Ãjag tỹ ag kygrẽn kãn ri ke ti nĩ. Ũn kãgter mũ tag jagfy kajãm kãn jé ãjag tóg ke mũ, ha vemnĩ. Ãjag mỹ sóg tó mũ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ón kỹ Topẽ vĩ to professor', Topẽ vỹ ãjag ve kónãn. Topẽ vĩ tỹ ẽg kanhrãn mũ ẽn ki ge jãvãnh ãjag tóg nỹtĩ mỹr'. Kỹ ũ tỹ ki rã sór mũn kỹ ãjag tóg ti mỹ tó kónãn tĩ, ti tỹ ki vẽnh fón tũ nĩn jé. Kỹ tóg ẽg tỹ ũ jo ĩn nĩfenh ẽn ri ke nĩ, ãjag tỹ ag tỹ Topẽ ki ge kamẽg ti,” he tóg, Jesus ti. Ti tỹ ũ tỹ ón kỹ Topẽ vĩ to professor ag mỹ vĩ kónãn hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ti tỹ tag tó kar kỹ tóg hẽn ra tĩ mũ sir. Tag pãte Topẽ vĩ to professor ag tóg ti mré mũ kỹ ti tugnỹm tĩ, Fariseu ag ke gé. Ag tỹ ti vĩ to ti se sór vẽ. Hã kỹ ag tóg ón kỹ ti ki jẽmẽgmẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ón kỹ ag tóg ti vĩ jẽmẽg tĩ gé sir, ag tỹ ti vĩ to ti kãgmĩn jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hã ra ũ tỹ hẽn ri ke ag vỹ vẽnh mãn kỹ nỹtĩ nĩ. E tãvĩ ag tóg tĩ ha, mil tỹ hẽn ri ke ag. Kỹ ag tóg jagnẽ sãnsãn mũ sir, ag e nỹtĩn kỹ. Kỹ Jesus tóg ag kanhrãnrãn mũ. Ã mré mũ tĩ ag kanhrãn vén tóg mũ, kỹ tóg ag mỹ: “Fariseu ag jykre han sór tũg nĩ,” he mũ. “Pão jẽgja jafã ri ke ti nĩ, ag jykre ti, hã kỹ tóg Topẽ mỹ kórég nĩ. Ag jykre hã vẽ, ha mẽ: jykre régre ag nỹtĩ. Kỹ tag tóg Topẽ mỹ kórég tãvĩ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Ẽg tỹ péju kỹ nén han mũ vỹ vẽnh ven kãn ke mũ, ẽg tỹ vẽnh kar vatánh tá nén to jykrén mũ vỹ vẽnh ven kãn ke mũ, kurã tỹ ẽgno ki,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","“Ãjag tỹ vẽnh kar vatánh tá vẽmén ja ẽn mẽ kãn jé ag tóg ke mũ, vẽnh kar. Ãjag tỹ kékén kỹ nén tó ja ẽn tó kãn jé ag tóg ke mũ, jamã hár(a), ãjag tỹ ĩn kãtá nén tó ja ẽn. Hã kỹ vẽnh jykre régre han tũg nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ha mẽ, iso há ãjag nỹtĩ. Ag kamẽg tũg nĩ, ũ tỹ ẽg tén tĩ ag, pã'i ag. Ag tỹ ẽg tén kar kỹ ag tóg ẽg tỹ hẽ ri kenh ke tũ nĩ sir. Hã kỹ ag kamẽg tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ãjag mỹ sóg tónh mũ ha, ãjag tỹ ũn kamẽg ke ti, hã vỹ: Topẽ, he mũ. Ti hã ne ẽg tén kar nũgme ki ẽg vãm ki kanhró nĩ', mỹr ha mẽ'. Kỹ ti hã kamẽg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sẽsĩ vãm ag tóg tĩ, jãnkamy kato, ẽg tỹ ko jé. Jẽsĩ tỹ 5 (ke) kato ẽg tóg jãnkamy pir mãg tĩ. Hã ra Topẽ pi(jé) ag kã jatun mũ'. Ag ki rĩr nĩ tóg nĩ, sẽsĩ ẽn ag ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ẽg ki rĩr tóg nĩ gé, Topẽ ti. Ẽg tỹ nén vég mũ kar ki kanhró tóg nĩ. Hã kỹ tóg ẽg gãnh ki kanhró nĩ gé. Nĩkrén kãn ja tóg nĩ, Topẽ ti, ẽg gãnh ti. Jẽsĩ kãfór ãjag tóg nỹtĩ, Topẽ mỹ. Ãjag kãmĩ ũn pir tóg sẽsĩ e kãfór nĩ, ti mỹ. Hã kỹ ag kamẽg tũg nĩ, ũ tỹ ẽg tén sór mũ ag,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Hã kỹ sóg ãjag mỹ tag tó mũ. Ẽprã ke ag mỹ: “tỹ sóg ti mré ke nĩ,” hemnĩ, iso. Ag kamẽg tũg nĩ. Kỹ sóg ãjag tónh ke mũ gé, Topẽ tỹ jẽnẽ jafã ag mỹ, kurã ẽn kã, ãjag tỹ tỹ inh mré ke nỹtĩ ti. Tỹ sóg ẽprã ke fi kósin ẽn nĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ãjag tỹ ẽprã ke ag mỹ inh kãmén tũ nĩn kỹ sóg ãjag tónh ke tũ nĩ gé, Topẽ tỹ jẽnẽ jafã ag mỹ, ãjag tỹ iso: “ti ki kagtĩg sóg nĩ,” hen kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Tỹ sóg ẽprã ke fi kósin ẽn nĩ. Ag tỹ iso vẽme jũ han kỹ sóg ag mỹ vẽnh pãte fón sór mũ. Ag tỹ hã ra Topẽ kuprĩg to vẽme jũ han kỹ Topẽ tóg ag mỹ vẽnh pãte fón mãn ke tũ nĩ ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ãjag vin jé ag tóg ke mũ, pã'i ag mỹ, governador ag mỹ ke gé, ag tỹ ãjag sigse jé. Ẽg vẽnh kanhrãn jafã krẽm ag tóg ãjag ki jẽmẽ sór ke mũ, ãjag tỹ inh ki ge kỹ nỹtĩ ti, ha vemnĩ. Hã ra to krĩ kufy han tũg nĩ, ãjag tỹ ag mỹ inh kãmén ke ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Topẽ kuprĩg hã ne ãjag kanhrãn ke mũ', kurã ẽn kã. Hã kỹ ãjag tóg tónh ke mũ sir,” he tóg, Jesus ti, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kỹ ũn e ag kãmĩ ũ tóg Jesus mỹ: “Senhor',” he mũ. “Inh jo inh kãke mré vĩmnĩ, ẽg tỹ ẽg panh ter ja tỹ nén kar vẽnh kãpãm jé, ti kuge ti,” he tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hã ra Jesus tóg ti mỹ: “vó,” he mũ. “Isũ pijé',” he tóg. “Inh pi(jé) ã mỹ ã kuge ve sór mũ'. Inh pi(jé) ã tũ tỹ vẽnh kãpãm sór mũ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kỹ tóg ag kar mỹ: “ker nén ũ to én hẽ',” he mũ. “Ẽg tỹ nén kar pi(jé) ẽg rĩr han ke mũ'. Ẽg tũ mág nĩ ra ẽg pi(jé) mũ há han ke mũ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kỹ tóg ag mỹ: “vẽnh jykre há vỹ ge nỹnh mũ, ha mẽ,” he mũ. “Ũn rico tóg nĩ ja nĩgtĩ mỹr,” he tóg. “Ti japỹ vỹ nén kar kanẽ e han ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kỹ tóg to jykrén mũ sir, ũn rico ti. “Inh hỹn ne han mũ ha?” he tóg. “Inh pãjó mág vó, inh pãjó kãsa vó, sỹ krẽm isũ kar rãg jé?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Inh pãjó kókén jé sóg ke mũ, sỹ ti jẽgja ki ũn mág han jé, kỹ sóg krẽm isũ kar vin mũ, inh jakré kanẽ kar ti,” he tóg mũ, to jykrén kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Kỹ sóg jatu nĩ sir. Isũ vỹ prỹg tỹ hẽn ri ke pétẽm mũ, kỹ sóg rãnhrãj mãn ke tũ nĩ ha. Jatun mỹ sóg jẽg nĩnh ke mũ, kron nĩ jé inh ke mũ gé. Inh mỹn sér tĩ sir, sỹ jatu nĩn kỹ,” he tóg, to jykrén kỹ, ũn rico ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hã ra Topẽ tóg ti mỹ vĩ mũ. “Krĩ tũ ã nĩ,” he tóg ti mỹ. “Kuty tag kã ã tóg ter ke mũ ha, kỹ ã tũ mág tag tỹ tỹ ũ tũ nĩnh ke mũ ha ke gé. Ma tĩg ke tũ ã tóg nĩ. Ã ter ke vẽ,” he tóg ti mỹ, Topẽ ti,” he tóg, Jesus ti, ũ tỹ ã panh tũ mãn sór mũ ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ge tóg tĩ, ẽg tỹ ga kri nén ũ há ve sór kỹ, ẽg tỹ kanhkã tá tỹ nén ũ tũ nĩn kỹ, Topẽ mré. Ẽg pi(jé) ga kri ẽg tũ mág ẽn ma mũnh mũ'. Ẽg tỹ kanhkã tá tũ mág nỹtĩn kỹ tag hã tóg há nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kỹ tóg ã mré mũ tĩ ag mỹ: “ha vé,” he mũ. “Vẽjẽn to jykrén kỹ krĩ kufyg tũg nĩ,” he tóg. “Inh hỹn ũri ne konh mũ'? Inh hỹn ne tunh mũ'?” he tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Topẽ tỹ ẽg han ja vẽ, ẽg tỹ ga kri mũ jé. Hã kỹ tóg ẽg jẽn ki rĩr ke mũ gé, ẽg kur ki ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sẽsĩ to jykrén nĩ. Ag mỹ ẽkrãn tĩ'? Vó. Ag mỹ ãjag jakré kunũg tĩ'? Vó. Ag mỹ pãjó han tĩ'? Vó, ke tũ ag tóg nĩgtĩ, ge ra Topẽ tóg ag jẽn tĩ. Jẽsĩ kãfór ãjag tóg nỹtĩ, Topẽ mỹ, hã kỹ tóg ãjag jẽn ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kỹ, Topẽ tỹ ẽg jé prẽr kỹ ẽg tóg mũnh mũ gé. Ẽg pi(jé) mũnh ke tũ nĩ', ti tỹ ẽg jé prẽr kỹ'. Ẽg tỹ to krĩ kufy han mũ ra ẽg tóg tĩg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ẽg pi(jé) ẽg krĩ kufy tugrĩn, ẽg krĩ há tugnĩn mũnh ke tũ nĩ'. Mũ jé ẽg tóg ke mũ, ti tỹ ẽg jé prẽr kỹ. Hã kỹ nén ũ ũ to krĩ kufy han tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ka fej to jykrén nĩ gé. Jatun mỹ tóg mog tĩ. Rãnhrãj tũ tóg nĩgtĩ, kur han tũ tóg nĩgtĩ. Hã ra tóg sĩnvĩ nỹtĩgtĩ, ka fej ti, kỹ pã'i mág tỹ Salomão ẽn kur tóg ri ke tũ nỹtĩ ja nĩgtĩ, ti sĩnvĩ ja ra, vẽnh kar kur sĩnvĩ kãfór ti nĩ, Salomão kur ti. Ki hã sóg tó mũ mỹr. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Topẽ hã ne ka fej sĩnvĩ han tĩ'. Hã ra tóg kãnhmar kãgter tĩ, ka fej ti, ti sĩnvĩ ra. Ũri tóg há nỹtĩ, tỹ vaj kỹ tóg kógungun tĩ. Topẽ tỹ ka fej sĩnvĩ han kỹ tóg ãjag kur ki rĩr ke mũ gé, ha vemnĩ. Kỹ ti to: “ti mỹ ẽg mỹ kur nĩm mũ vỹ?” he tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Inh hỹn ne konh mũ', ũri?” he tũg nĩ gé. To krĩ kufy han tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Topẽ ki ge tũ ag vỹ tag to jykrén mág tĩ. Hã ra ẽg jóg tỹ Topẽ vỹ ẽg ki kanhró nĩ, ẽg tỹ nén konh ke mũ ti, ẽg kur ti ke gé. Kỹ to krĩ kufy han tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Topẽ tỹ tỹ ẽg pã'i nĩ ẽn hã ve jé vãsãnsãn nĩ. Kỹ tag hã to jykrén nĩ. Kỹ Topẽ vỹ ãjag mỹ ãjag tỹ nén ve sór mág ẽn vin ke mũ sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kamẽg tũg nĩ, ãjag pipir nỹtĩ ra. Ẽg jóg tỹ Topẽ vỹ ãjag to há nĩ, hã kỹ tóg ãjag mỹ kanhkã ti ven sór mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ãjag tỹ nén kar vin nĩ, ũn vẽsỹrénh mũ ag mỹ. Hã kỹ ãjag tóg kanhkã tá tỹ nén ũ mág nỹtĩnh mũ. Tá ãjag kuge tóg tũ' henh ke tũ nĩ. Tag ki ẽg tóg ẽg jãnkamy fón tĩ, nén ũ kar to. Tá tóg tũ' he jãvãnh nĩ, ẽg kuge ti. Tá ũ tóg péjunh kãtĩg ke tũ nĩ gé, tá ti ga tóg kaggranh ke tũ nĩ gé. Kanhkã tá ẽg tũ vỹ ge nĩ. Tũg jãvãnh ti nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ãjag tỹ ga kri tỹ nén ũ mág nỹtĩn kỹ ãjag tóg ga kri mũ mág sór mũ. Ãjag tỹ hã ra kanhkã tá tỹ nén ũ mág nỹtĩn kỹ ãjag tóg kanhkã ra mũ sór mũ, kỹ tag hã ne há nĩ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ẽg kur tỹ ẽg tóg vẽsógfĩg tĩ, ẽg tỹ rãnhrãj há han jé. Ẽg lampião grug ẽg tóg tĩ, kuty kã, ẽg tỹ ve há han jé. Ẽn ri ke han nĩ, ãjag tỹ inh kãtĩg mãn ke jãvãnh kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kỹ ãjag tóg ũn camarada ri ke nỹtĩ. Kejẽn ag patrão vỹ hẽn ra tĩg mũ, ã prũ ke festa mág han jé. Kỹ ti camarada ag vỹ ti tỹ tá vỹn ke jãvãnh nỹtĩ. Ag tỹ ti jãvãnh há han kỹ tóg há tĩ, ag nũgnũr tũ nĩn kỹ. Kỹ ag tóg kãnhmar ti tỹ jãnkã tỹ tórón tórón ke kỹ mẽnh mũ, kỹ ag tóg ti mỹ róm ke mũ sir, ti jun kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kỹ tóg kejẽn jun mũ sir, ag patrão ti. Kỹ tóg sér tĩ, ti camarada ag tỹ ti jãvãnh nỹtĩn kỹ. Kỹ tóg ag mỹ vĩ há han ke mũ sir. Kỹ tóg vẽsóg fĩn kỹ ag mỹ: “nĩgnĩ ra ver, mesa to,” henh ke mũ sir. Kỹ tóg ag mỹ vẽjẽn ven ke mũ. Ag patrão hã ne ã camarada ag mỹ vẽjẽn ven ke mũ', ha vemnĩ. Ki hã sóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Hẽn ri ke mũn tóg meia noite ki jun ke mũ, hẽn ri ke mũn tóg galo kyr mũ ra jun ke mũ. Ti camarada ag tỹ ti jãvãnh kỹ nỹtĩn kỹ tóg ag mỹ vĩ há tãvĩ han ke mũ sir, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Kỹ tag to jykrén nĩ, ha mẽ. Inh kãtĩg mãn ke vỹ ũ tỹ nén ũ pigju(g) tĩ kãtĩg ri ke nĩnh mũ. Ũ tỹ ti ĩn krẽm nĩ ẽn pi(jé) ki kanhró nĩ', hora kã ti kãtĩg ke mũ ti. Ũ tỹ ti tỹ nén ũ péju sór mũ tóg ẽn ge nĩ, ha mẽ. Ti tỹ ti kãtĩg ke hora ki kanhró nĩ (hã) ra tóg ã kanẽ fãn mũ vẽ, ti tỹ ti ĩn kãra rã tũ nĩ jé. Hã ra tóg ki kagtĩg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ge ti nĩ, inh kãtĩg mãn ke ti. Vẽnh ki rĩr, vẽnh ki ẽmẽ. Ẽprã ke fi kósin vỹ kãtĩg ke mũ, ãjag tỹ ti kãtĩg ke to jykrén tũ (hã) ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kỹ Pedro vỹ ti mỹ: “Senhor',” he mũ. “Ã tỹ ũ mỹ ke nẽ, ã tỹ tó ja tag ti? Ã tỹ ũ tỹ ã ki ge tũ ag mỹ ke mỹ, ẽg mỹ ke mỹ vó?” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kỹ ẽg Senhor tóg ti mỹ: “hỹ,” he mũ. “Kejẽn patrão tóg hẽn ra tĩg sór mũ, kỹ tóg ã camarada ag kã ũ tỹ pã'i han mũ, ti tỹ ti jo ã mré camarada ag ki rĩr jé. Ũ tỹ ã rãnhrãj ki rĩr há han tĩ ẽn kuprẽg tóg mũ, ti tỹ ag mỹ vẽjẽn ven jé, vẽjẽn ke horan ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ti tỹ ag ki rĩr há han kỹ ti patrão vỹ ti mỹ vĩ há han ke mũ, ti kãtĩg mãn kỹ, ũ tỹ ag ki rĩr há han mũ ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tỹ pã'i mág han jé tóg ke mũ, ti tỹ ti tũ ki rĩr kãn jé sir. Ki hã sóg ke mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ti camarada ẽn jykre kórég nĩn kỹ tóg vẽnhmỹ nĩ jãvo, ha mẽ. To jykrén kỹ tóg: “ẽg patrão vỹ kãtĩg vãnh han mũ,” he mũ. Kỹ tóg ã mré camarada ag vóg kónãn kỹ ag mrãnmrãn mũ sir, fag ke gé. Kỹ tóg jatun mỹ jẽn mág han mũ, ũn kronkron tĩ ag mré tóg kronkron kỹ pépév tĩ nĩ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kỹ ti patrão vỹ ti kãnhmỹ jun ke mũ, ha vemnĩ, ti tỹ ti jun ke kurã ki kagtĩg nĩn kỹ, ti hora ti ke gé, kỹ tóg ti vóg kónãn ke mũ gé sir, ti patrão ti, kỹ tóg ti fón ke mũ, Topẽ vĩ mranh tĩ ag mré hã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Topẽ camarada ũ vỹ ã patrão kãtĩg ken jo ki rĩr há han tũ nĩgtĩ, ti patrão tỹ ti mỹ tó mũ ra. Ã patrão vĩ ki króm tũ ti nĩgtĩ. Ti mrãnmrãn mág jé tóg ke mũ, ti patrão ti, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ũ tóg ã tỹ nén han ke mẽ ja tũ nĩ, ti patrão vĩ ti, ti camarada ũ ti. Hã ra tóg kórég han mũ gé. Kỹ ti patrão tóg ti mrãnmrãn ke mũ gé. Ti mrãnmrãn sĩ han jé tóg ke mũ jãvo. Ũ tóg vẽnh kanhrãn mág han tĩ. Kỹ Topẽ tóg vẽnh jykre há tãvĩ ve sór mũ sir, ti tỹ ki kanhrãn mág han mũ ẽn to. Ũ mỹ ti vĩ mág tĩ, Topẽ ti, kỹ tóg ti tỹ ki króm há han ve sór mũ gé sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ga kri inh mur, isỹ re pũr tĩg ri ke han jé, hã vỹ: ũn e tỹ inh ki ge mũ, he mũ. Sỹ re pũr tĩg ri ke ẽn venh há tóg tĩ, hã ra tóg ver gru tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ti grug to hã sóg vẽsỹrénh ke mũ. Iser ke vẽ, kỹ tóg inh mỹ e tĩ. Sỹ ve jãvãnh tóg tĩ, inh vẽsỹrénh ke ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Ãjag hỹn iso: “vẽnh kar tỹ jagnẽ to há han jé tóg ke mũ,” he tĩ. Hã tũ vẽ. Ũ tỹ hẽn ri ke tỹ jagnẽ kato tẽ han jé sóg ke mũ, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ha vé, ĩn pir krẽm ke fag vỹ jagnẽ kato tẽnh ke mũ. Ũn tãgtũ fag vỹ ũn régre fag kato tẽgtẽnh mũ ha. Kar ũn régre ẽn fag vỹ ũn tãgtũ fag kato tẽgtẽnh mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jagnẽ kato fag jagnẽ to jũgjũnh mũ. Ũ tóg ã kósin kato tẽnh ke mũ, kỹ ũ tóg kejẽn ã panh kato tẽnh ke mũ gé. Ũ fi vỹ ã kósin fi kato tẽnh ke mũ, kỹ fi vỹ ã mỹnh fi kato tẽnh ke mũ gé. Kỹ ũ tóg ã má fi kato tẽnh ke mũ, kỹ fi tóg ã jamré kato tẽnh ke mũ gé sir. Ge ti nĩgtĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kỹ tóg vẽnh kar mỹ tó mãn mũ gé, kỹ tóg ag mỹ: “kanhkã ve kỹ ãjag tóg ta ki kanhró nỹtĩ,” he mũ. “Kanhkã góg tỹ tãtá kãtĩn kỹ ãjag tóg: “ta vỹ kutẽnh mũ,” he tĩ. Ki kanhró ãjag tóg nỹtĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kar ãjag tóg kãka ki kanhró nỹtĩ gé. “Tag tán kãtĩ mũ, kãka ti, kỹn hỹn jũ jagy nĩnh mũ, ha vemnĩ,” he ãjag tóg tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ki kanhró ãjag tóg nỹtĩ, ta jykre ti, kãka jykre ti, ga jykre ti ke gé. Hã ra ãjag tóg inh jykre ki kanhrãnrãn sór tũ nĩ, sỹ ũri ãjag mỹ tó mũ tag ti. Kutu ãjag nỹtĩ, ha mẽ, hã kỹ ãjag tóg ki kanhrãnrãn sór tũ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Kỹ ãjag tóg vẽnh jykre kuryj to jykrén tũ nĩ gé, ãjag tỹ jagnẽ mỹ vẽnh pãte fón jé, ãjag tỹ ver ga kri mũn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kejẽn ãjag tóg jagnẽ mỹ vẽnh jykre vẽnhmỹ tó tĩ. Kỹ ãjag tóg pã'i mỹ tónh mũ sir. Ã tỹ ũ to jũ mũ ẽn vỹ ã tónh tĩg sór mũ. Ti tỹ pã'i tá jun ke to hã ti mré vĩmnĩ. Ti mỹ: “inh mỹ vẽnh pãte fón,” hemnĩ. Ke tũ nĩ mũ ra pã'i vỹ ã jykre pãno venh ke mũ, kỹ tóg polícia mỹ: “ti se ra,” henh ke mũ. Kỹ tóg ã senh ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ha mẽ, tá ã kãnhmar kãkutẽ mãn ke tũ nĩ. Ã tỹ kajãm kãn kar kỹ ã hẽn ri ke mũn tá kãkutẽ mãn ke mũ sir,” he tóg. Jesus tỹ ẽg tỹ jagnẽ mỹ vẽnh pãte fón kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kejẽn ũ ag tóg Jesus tá junjun mũ, hã ra ag tóg ti vĩ mẽ kỹ nỹtĩ. Kurã ẽn kã ũ ag tóg ti mỹ Galiléia tá ke ag tó ja nĩ, fóg tỹ pã'i tỹ Pilatos tỹ ũn kãgtén ja ẽn ag. Topẽ mỹ ag tóg ãjag mẽg tãnh ja nĩ, ti mỹ pũn jé, hã ki Pilatos tóg ag kygrẽn ja nĩ, hã kỹ ag kyvénh tóg ãjag mẽg kyvénh mré kutẽ ja nĩ. Hã kãmén ag tóg, Jesus mỹ, ti tỹ ag mỹ e tĩn kỹ, ag tỹ ũn kãgter mũ ag to: “ag hỹn Topẽ vĩ mranh mág,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Kỹ Jesus tóg ag mỹ: “ãjag hỹn Galiléia tá ke ẽn to jykrén sór mũ, ũn kãgter mũ ẽn ag to,” he mũ. “Topẽ vĩ mranh mág tĩ ag vẽ,” he ãjag tóg mũ ag to. “Ag hỹn vẽnh jykre pãno han mũ nĩ, ag hỹn Galiléia tá ke ag jykre pãno kãfór han mũ nĩ, hã kỹ Topẽ hỹn tóg ag vóg kónãn mág,” he ãjag tóg tĩ ag to. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ke tũ vẽ hã ra. Ãjag ri ke ag tóg nỹtĩ, mỹr, ha mẽ. Ãjag tỹ ãjag jykre tovãnh tũ nĩn kỹ ãjag tóg nũgme ki vár ke mũ, ha vemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Ũ tỹ 18 (ke) ẽn ag to jykrén nĩ, ũ tỹ goj tỹ Siloé tá kãgter mũ ẽn ag. Ĩn téj ẽn tóg ag kri kutẽ, ĩn vag jẽ ẽn ti, hã kỹ ag kãgter mũ. Jerusalém tá ke kar ag jykre ri ke ja ag tóg nỹtĩ. Ag pi(jé) ag jykre pãno ẽn kãfór ja nỹtĩ'. Ag ri ke han ja ag nỹtĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kỹ sóg ãjag mỹ ke mũ. Ãjag tỹ ãjag jykre pãno tovãnh tũn kỹ ãjag tóg nũgme ki vár ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kỹ tóg ag mỹ: “ũ tỹ Topẽ jykre han sór tũ ag vỹ ge nỹtĩnh mũ, ha mẽ,” he mũ. “Kejẽn ũ tóg nĩgtĩ. Ka há krãn ja tóg nĩgtĩ, ka tỹ figueira. Ka kanẽ ũ vẽ, ko há ti jẽ. Ẽn krãn ja tóg nĩ. Uva kãmĩ tóg ti krãn ja nĩ. Kỹ tóg kejẽn ti kanẽ ko sór mũ, kỹ tóg venh kãtĩ mũ. Hã ra tóg kanẽn ja tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kỹ tóg uva ki rĩr tĩ mỹ: “ti gỹn ra,” he mũ. “Prỹg tãgtũ tóg nĩ ha, sỹ ti kanẽ vég tũ ki. Kanẽn vãnh ti hỹn jẽ. Ti gỹn ra, ti tỹ ga kókég tũ nĩn jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hã ra tóg ã patrão mỹ: “ti tovãnh ra ver,” he mũ, uva ki rĩr tĩ ti. “Ti pénĩn sóg kũm mũ ver, sỹ ti krẽm ga jẽgja han jé ver. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hẽn ri ke mũn tóg kanẽ há hyn han ke mũ ha. Ke tũ nĩn kỹ sóg ã mỹ ti gỹn ke mũ vãhã,” he tóg mũ, uva ki rĩr tĩ ti,” he tóg, Jesus ti. Ti tỹ ũ tỹ ã jykre kórég tovãnh sór tũ tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kejẽn tóg ag vẽnh kanhrãn jafã krẽm ag kanhrãn mũ, Jesus ti, vẽnhkán ke kurã ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kỹ ũ fi tóg tá jẽ nĩ. Jagrẽ kórég fi nĩ, hã kỹ fi tóg pãnh ke kỹ jẽ nĩ. Vẽnh ra hã jẽ kórég fi tóg nĩ, fi jagrẽ tugnĩn. Prỹg tỹ 18 (ke) han fi tóg, fi jagrẽ tỹ fi kagãg tĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kỹ Jesus tóg fi vég mũ, kỹ tóg fi jé prẽr mũ. “Kunĩg, jỹ,” he tóg. “Ã kaga tỹ sóg tũ' henh mũ,” he tóg fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kỹ tóg ã nĩgé tỹ fi kri fig mũ. Kỹ fi tóg vẽnh ra hã jẽg há han mũ, ha mẽ. Kỹ fi tóg Topẽ to vĩ há han mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hã ra vẽnh kanhrãn jafã to pã'i tóg Jesus to jũ mũ, ti tỹ vẽnhkán ke kurã ki fi tỹ há' hen kỹ. Ti mỹ tóg tỹ vẽnh rãnhrãj nĩ, fi tỹ há' he mũ tag ti, hã kỹ tóg Jesus to jũ mũ. Kỹ tóg vĩ mũ sir. Vẽnh kar jyvẽn kỹ tóg ag mỹ: “kurã tỹ 6 (ke) hã ki ẽg tóg rãnhrãj ke mũ ha,” he mũ. “Hã kỹ kurã tỹ 6 (ke) ẽn ki kãmũmnĩ, ti tỹ ãjag tỹ há' hen jé. Vẽnhkán ke kurã ki vẽnh kygtãg kãmũ tũg nĩ,” he tóg mũ, pã'i ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hã ra Jesus tóg ti vĩ kãfãn mũ, kỹ tóg: “jykre régre ã nĩ (mỹr),” he mũ. “Vẽnhkán ke kurã kã ãjag tóg ãjag mẽg ki rĩr tĩ gé, monh ki, cavalo ki ke gé, ha mẽ. Ãjag mẽg kygvãn ãjag tóg tĩ, ãjag tỹ ti kron mũn jé, ti tỹ ĩn kãkã se kỹ jẽ kỹ, cocho to. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kỹ tag fi vỹ se kỹ jẽ ẽn ri ke jẽ ja nĩ gé, ha mẽ. Satanás hã vỹ fi sé', prỹg tỹ 18 (ke) ki. Ẽg jóg'jóg ve tỹ Abraão kósin ũ fi vẽ, ẽg mẽg kãfór fi tóg jẽ, hã ra ã tóg jũ sór mũ, isỹ vẽnh kán ke kurã ki fi tỹ há' hen kỹ, isỹ fi kavãn ri ke han kỹ. Vẽnh jykre vẽnhmỹ han sór ã tóg nĩ,” he tóg, Jesus ti, pã'i ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ti vĩ tag to ag tóg mỹ'ãg'ãg mũ sir, ti kato tẽ mũ ag. Hã ra tóg vẽnh e ẽn mỹ sér tĩ sir. Ag mỹ tóg nén ũ kar há han tĩ, hã kỹ tóg ag mỹ sér tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kỹ Jesus tóg ag mỹ: “Topẽ tỹ tỹ ẽg pã'i nĩnh ke vỹ ge nĩ, ha mẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","“Vãnh tỹ mostarda fy ri ke ti nĩ. Sĩ ti nĩ, ti fy ti. Ẽg japỹ ki ẽg tóg krãn tĩ, kỹ tóg mog tĩ. Kỹ tóg ka ri ke nĩ, ti tỹ pẽ téj nĩn kỹ. Hã kỹ sẽsĩ tóg kri jagfénh ke mũ, ti pẽ kri, ti pẽ mág nĩn kỹ. Topẽ tỹ tỹ ẽg pã'i nĩ kãme tỹ vẽnh kar kri rũm ke to ken hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kỹ tóg ag mỹ: “Topẽ tỹ tỹ ẽg pã'i nĩn kỹ tóg tag ri ke nĩnh mũ, ha mẽ,” he mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","“Ũn tỹtá fag vỹ pão han tĩ, farĩnh tỹ. Pão han jé fag tóg pão jẽgja jafã tỹ fermento ẽn tỹ farĩnh mré jẽgjãg tĩ. Kejẽn ũ fi tóg farĩnh e kãki ti jãgja jafã pir tỹ kãki vãm ja nĩ, hã ra tóg tỹ són ke kãn,” he tóg, Jesus ti. Ti vĩ tỹ vẽnh kar kri rũm ke kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kỹ Jesus tóg tĩ mũ. Cidade e fĩn rãm tóg mũ, ẽmã kãsir fĩn ke gé. Tĩg kỹ tóg ag kanhrãnrãn mũ sir. Ge kỹ tóg komẽr hã cidade tỹ Jerusalém kukãm tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kỹ ũ tóg ti mỹ: “Senhor',” he mũ. “Ũn krenkren mũ ag mỹ pipir nỹtĩ, e nỹtĩ vó?” he tóg ti mỹ. Kỹ tóg ti mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“hỹ,” he mũ. “Inh ki rã vỹ jãnkã sĩ ra rã ri ke nĩ,” he tóg. “Vãsãn nĩ, ã tỹ ra rã jé. Kejẽn ũ tóg ra rã mãn ke tũ nĩ ha. Ẽn kã ũ tỹ hẽn ri ke ag vỹ ra ge sór mũ, hã ra ag tóg tỹ hẽ ri kenh ke tũ nĩ ha sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ĩn ki rĩr tĩ ẽn tỹ nĩfénh ja vẽ mỹr, hã kỹ ag tóg ĩn kãra genh ke tũ nĩ ha. Kanhkã to ken hã vẽ, ĩn ti. Ĩn ki rĩr tĩ ẽn hã ne nĩfénh ke mũ', kỹ ãjag tóg sir re tá nỹtĩnh kỹ tỹ tórón' tórón' kenh ke mũ. “Senhor', ẽg mỹ róm, ẽg mỹ nón, jãnkã ti,” he jé ãjag tóg ke mũ. Hã ra tóg sir ãjag mỹ: “ãjag ki kagtĩg sóg nĩ,” henh ke mũ, ĩn ki rĩr tĩ ti. “Ãjag tỹ ũ nỹtĩ?” he jé tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kỹ ãjag tóg ti mỹ: “ã mỹ ẽg ki kagtĩg?” henh ke mũ. “Ẽg hã vỹ ã mré jẽn ja nĩ, ẽg hã vỹ ã mré kron ja nĩ, ẽg kanhrãn ja ã tóg nĩ, ẽg jamã tá. Ẽg hã vẽ,” he jé ãjag tóg ke mũ, ãjag tỹ re tá nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hã ra tóg ãjag mỹ: “inh pi(jé) ãjag ki kanhró nĩ',” henh ke mũ. “Ãjag pi(jé) tỹ inh mré ke nỹtĩ'. Ha mũjẽg. Vẽnh jykre pãno han ãjag tóg mũgtĩ,” he jé tóg ke mũ, ĩn ki rĩr tĩ ti, ãjag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ãjag tỹ ra mũnh ke tá ãjag tóg vẽsỹrénh ke mũ, tá ãjag jã tóg gyngyn ke mũ, gangan ke jé ãjag tóg ke mũ, tá. Kór há tá ãjag tóg Abraão venh ke mũ, tá, Isaque ke gé, Jacó ke gé, Topẽ vĩ tó tĩ ag kar ke gé. Ẽn ag kar vỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh mũ sir, ãjag jãvo. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ẽn kã Topẽ ki ge kỹ nỹtĩ kar ag tóg kãmũnh mũ, rã jur ja tá, rã pur ja tá, kanhkã fyr tá, rã krẽm tĩg ja tá. Kãmũ kỹ ag tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ, ti tỹ ag ki rĩr nĩ ti, kỹ ag tóg tá jẽg nỹtĩnh mũ ãjag jãvo. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kỹ tag ki ũn kãsir ũ ag tóg mág nỹtĩnh mũ, tá pã'i nỹtĩnh mũ. Kỹ tag ki ũn mág ũ ag tóg kãsir nỹtĩnh mũ gé, tá, tére kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kurã ẽn kã Fariseu ũ ag tóg tá junjun mũ, Jesus mré vẽmén jé. Ti mỹ ag tóg: “ha mẽ,” he mũ. “Pã'i mág tỹ Herodes vỹ ã tén sór mũ. Hã kỹ vẽnh péju tĩg, ẽmã ũ ra,” he ag tóg mũ sir, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kỹ tóg ag mỹ: “mĩg sĩ ri ke ti nĩ, Herodes ti,” he mũ. “Hã kỹ tóg ke mũ. Ver sóg vẽnh jagrẽ kórég pan mũ, ũn kagyga ag tỹ há' he jé sóg ke mũ, ũri, vaj kỹ ke gé, kurã tỹ hẽn ri ke ki. Kãnhmar sóg ter ke mũ, inh kurã ki, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ũri sóg ver tĩg mũ, vaj kỹ ke gé, vaj ũn kỹ ke gé. Iser ken kỹ sóg Jerusalém tá ter ke mũ. Tag ki ke pijé'. Topẽ vĩ tó tĩ vỹ tỹ inh nĩ, jo Jerusalém tá ke ag tóg ag kãgtén tĩ, Topẽ vĩ tó tĩ ag. Hã kỹ sóg Jerusalém tá ter tĩg ke mũ gé. Tag tómnĩ, Herodes mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kỹ tóg Jerusalém ki ke ag to vẽmén mũ. Fe kaj han tóg, ag to, kỹ tóg: “Jerusalém tá ke ag mỹ sóg tag tó sór mũ, ha mẽ,” he mũ. “Topẽ vĩ tó tĩ ag kãgtén ag tóg tĩ. Topẽ tỹ ag mỹ ũn jẽgnẽg tĩ ag pin ag tóg tĩ, pó tỹ, ag tỹ ag kãgtén jé. Isỹ ag vẽnh mãn há tóg tĩ vẽ, isỹ ag ki rĩr jé, Jerusalém tá ke ag, hã kỹ sóg ag jé prẽr tỹ hẽn ri ke han mũ. Garĩnh fi jykre ri ke han sór isóg mũ vẽ, ag mỹ. Garĩnh fi vỹ ã krẽ kri jẽ nĩ, fi tỹ ag vẽsỹrénh tũ nĩ jé ke vẽ. Ẽn ri ke han sór sóg mũ vẽ, hã ra ag tóg ke jãvãnh nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Hã kỹ ag tóg ag jamã pũn kãn ke mũ, kỹ vãpũr vẽ sir. Ũ vỹ kãnhmar tá nĩg mãn ke tũ nĩ ha, ag tỹ cidade kókén ja tá. Hã kỹ sóg ag mỹ ke mũ. Inh ve mãn ke tũ ag nĩ ha (mỹr). Kejẽn ag tóg iso: “Topẽ tỹ ti jẽnẽ ja vẽ,” henh ke mũ. “Topẽ vỹ ti ve há han, ti tỹ ti jiji tó kãtĩg kỹ,” he jé ag tóg ke mũ iso. Ẽn hã kã ag tóg inh ve mãn ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kejẽn tóg vẽnhkán ke kurã tá krỹg mũ. Kỹ tóg pã'i ũ ĩn krẽm nĩ nĩ. Fariseu ag pã'i vẽ. Ti tỹ ti ĩn krẽm jẽn ke vẽ. Hã ra ag tóg tá ti tỹ rĩr mũ, “ti mỹ vẽnhkán ke kurã ki rãnhrãj ke tũ?” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hã ra ũ tóg tá nĩ gé, ũn kaga ũ. Kãnhpar kãn kỹ tóg jẽ. Jesus rĩn ja tá tóg jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kỹ Jesus tóg Topẽ vĩ to professor ag mỹ ke mũ, Fariseu ag mỹ ke gé. Ag mỹ tóg: “ẽg tỹ vẽnhkán ke kurã kã ũ tỹ há' hen mỹ há nĩ, mỹ kórég nĩ vó?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hã ra ag tóg ti mỹ nén ũ tó tũ nĩ. Kỹ Jesus tóg ũn kaga ẽn kri ã nĩgé fi kỹ ti tỹ há' he mũ sir. Kỹ tóg ti mỹ: “ha tĩg ge,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kỹ tóg ag mỹ: “kejẽn ãjag kósin ũ tóg goj ki kutẽnh mũ,” he mũ, “goj nig ki, ke tũ nĩn kỹ ãjag mẽg tỹ monh. Vẽnhkán ke kurã ki tóg goj ki kutẽnh mũ, hẽn ri ke mũn. Kỹ ãjag tóg ti kunũg tĩ gé, ti tỹ vẽnhkán ke kurã kã ki kutẽn kỹ. Kỹ ãjag tỹ ne jé iso jũ sór nẽ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kỹ tóg ag tỹ ti mỹ nén tónh ke tóg tũ tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kỹ Jesus tóg vẽnh kar kanhrãn jé tag tó mũ sir, ha mẽ. Ti mré jẽgjẽn kỹ nỹtĩ ag mỹ tóg kãmén mũ. Ag jẽn vén sór vẽ, ag tỹ tỹ ũn mág nỹtĩ jé. Hã vég tóg mũ, hã kỹ tóg ag kanhrãnrãn sór mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kỹ tóg ag mỹ: “kejẽn ũ tóg ãjag mỹ: “kurã ẽn kã sóg vẽnh prũg ke to festa han ke mũ. Ha inh mré jẽn kãtĩg,” henh ke mũ. Kỹ ti festa kã jẽn vén sór tũg nĩ. Hẽn ri ke mũn ã kãfór nĩ ũ tóg ki jun mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kỹ festa ki rĩr mũ tóg ã mỹ: “toreg ver',” henh ke mũ. “Ti jẽn kar kỹ ã tóg jẽn ke mũ. Mẽ kỹ jẽ nĩ ver,” he jé tóg ke mũ ã mỹ, ũ tỹ festa ki rĩr tĩ ti. Kỹ tóg ã mỹ'a tĩnh mũ sir, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kỹ ã tỹ festa venh tĩg kỹ mẽ kỹ nĩmnĩ ver, vẽjẽn jãvãnh kỹ. Kỹ festa ki rĩr mũ vỹ ã mỹ: “ha jẽn vén, fag mré,” henh ke mũ. Kỹ ã pi(jé) mỹ'ãg ke mũ',” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Hã kỹ tóg ũ tỹ ag kãfór nĩ sór mũ térem ke mũ, vẽsỹkã, Topẽ ti, ha vemnĩ. Jãvo tóg ũ tỹ: “tỹ inh ũn sĩ nĩ,” he mũ ẽn jãnfyn ke mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kỹ tóg ũ tỹ ã kógfyn mũ ẽn mỹ kãmén mũ gé. Ti mỹ tóg: “ã tỹ festa han sór kỹ ũn rico ag mỹ tó sór tũg nĩ, ã mré ke fag mỹ, ã kãke ag mỹ, ã jãvy ag mỹ, ã rã nỹtĩ ag mỹ tó tũg nĩ gé,” he mũ. “Ã tỹ ũn rico ag mỹ tó mũ ra ag tóg vẽnh kaja jé ã mỹ festa han sór mũ gé. Kỹ ã tóg ã festa kaja ti vég mũ sir, ẽprã. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ã tỹ festa han sór kỹ ũn kaga kỹ rãnhrãj vãnh ag mỹ tómnĩ, ũn kãnhgrĩ ag mỹ, ũn kyvó ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ã tỹ tag han kỹ Topẽ vỹ ã ve há han ke mũ, ha vemnĩ. Ã mỹ ag tóg festa han ke tũ nĩ, ag tỹ nén ũ tũ nĩn kỹ. Kỹ ã tóg ã rĩr mãn ken kỹ ti kaja venh ke mũ, Topẽ tỹ ũn jykre kuryj kar rĩnrĩr mãn ke kurã ẽn kã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kỹ tóg tá nĩ ũ mỹ mẽ há tĩ, Jesus vĩ tag ti. Tá nĩg kỹ tóg ag mré jẽg mũ gé, hã kỹ tóg Jesus vĩ mẽg mũ. Kỹ tóg ti mỹ: “ũ tỹ Topẽ tỹ tỹ ẽg pã'i nĩ vég mũ mỹn hỹn sér pẽ tĩnh mũ, ũ tỹ tá festa vég mũ ẽn mỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kỹ Jesus tóg ti kanhrãn kỹ ti mỹ: “kanhkã tá festa vỹ ge nĩnh mũ, ha mẽ,” he mũ. “Kejẽn ũ tóg nĩgtĩ. Festa mág han sór tóg mũ, kỹ tóg ũ tỹ hẽn ri ke ag mỹ tó ja nĩ, ti tỹ festa han ke to hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ti festa kurãn kã tóg ã camarada jẽnẽg mũ, ti tỹ ũn kógfyn kỹ nỹtĩ ag mỹ: “ha kãmũjẽg,” he jé. “Kar kỹ tóg nĩ ha, inh festa ti,” hemnĩ,” he tóg, ã camarada mỹ. Kỹ tóg ag mỹ tónh tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hã ra ag tóg ve sór tũ nĩ, ag kar ti, hã kỹ ag tóg ti mỹ vĩ mũ. Ũ tóg ti mỹ: “ga kajãm inh,” he mũ. “Hã kỹ sóg ijapỹ venh tĩ mũ ver. Ũri tóg inh mỹ vẽnhmỹ tĩ. Sỹ festa venh tĩg ke vẽ vẽ, hã ra tóg vẽnhmỹ tĩ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Kỹ ũ tóg ti mỹ: “monh génh sóg, monh tỹ 5 (ke) régre,” he mũ gé. “Kỹ sóg ag venh tĩ mũ ver. Sỹ festa venh tĩg ke vẽ vẽ, hã ra tóg vẽnhmỹ ti,” he tóg mũ gé sir, ũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Kỹ ũ tóg ti mỹ: “ũri sóg prũg mũ ha, hã kỹ tóg vẽnhmỹ tĩ,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kỹ ti camarada tóg ti mỹ tónh kãtĩ mũ, ã patrão mỹ. Kỹ tóg jũ mũ. Ti mỹ tóg: “ẽpry ra tĩg, ẽmĩn mág ra, ẽpry kãsir ra ke gé, ẽmã kar ki,” he mũ. “Kỹ ũn jagtar ag tatĩ kãtĩg, ũn kónhgrĩ ag, ũn kyvó ag, ũn tĩg vãnh ag ke gé,” he tóg. Ã camarada mỹ tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kỹ tóg tĩg mãn mũ, ti camarada ti. Kỹ tóg tá vỹn ke kỹ ã patrão mỹ: “ke kãn inh huri,” he mũ. “Ag tatĩ kãtĩg inh huri, hã ra tóg fór tũ nĩ ver, festa jo ĩn ti,” he tóg mũ, ti camarada ti, ti patrão mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kỹ ti patrão tóg ti mỹ: “vẽsỹkã tĩg mãn ge,” he mũ. “Vãnh kãmĩ tĩg, ẽmã kãsir pẽ kãmĩ ke gé, ẽpry ra, ẽmĩn jagma,” he tóg. “Tá ag mỹ tugtónh tĩg. Ag kutãn nĩ, ag kãmũ jé, festa jo ĩn fór jé,” he tóg, patrão ti, ã camarada mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Hã kỹ sóg ãjag mỹ ke mũ,” he tóg. “Ũ mỹ sóg tó vén ja nĩ, hã ra ag tóg inh festa venh ke tũ pẽ nĩ, sỹ ũ mỹ tó vén ja ag,” he tóg. Jesus tỹ Fariseu ag mré jẽn kỹ ag mỹ kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kejẽn ũn e ag tóg Jesus nón mũ mũ. Kỹ tóg ag jé vĩrĩn ke kỹ ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ha mẽ,” he mũ. “Ũ tỹ inh mré tĩg pẽ han sór mũ jé inh hã to há kãfór nĩ, ã han mũ fag kri, ti prũ fi kri, ti krẽ kri, ti kãke ag kri, ti jãvy ag kri, ti ve fag kri, vẽnh kri ke gé, mỹr, ha mẽ,” he tóg. “Ke tũ nĩ mũ ra tóg inh mré kãtĩg ke tũ nĩ, kỹ tóg tỹ inh mré ke nĩnh ke tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ha vé, ag tỹ inh cruz tỹ inh kri fi kỹ sóg tĩg ke mũ, ag tỹ to isa kỹ isén jé, ha vemnĩ. Vẽnh nenh ke tũ sóg nĩ. Ũ tỹ inh ri ke han sór tũ nĩn kỹ tóg inh mré kãtĩg ke tũ nĩ, kỹ tóg tỹ inh mré ke nĩnh ke tũ nĩ gé,” he tóg, Jesus ti, ");
INSERT INTO kgpNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“To jykrén, ũ tỹ ĩn téj han sór mũ ẽn to. Ti tỹ ĩn téj han sór kỹ tóg ã jãnkamy nĩkrén vén ke mũ. Kỹ tóg ĩn kaja to jykrén ke mũ gé sir. Kar kỹ tóg ĩn han sór ke mũ vãhã. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ti tỹ to hã to jykrén há han tũ ra tóg vẽnhmỹ tĩ. Kỹ tóg ĩn jẽg ken ki kũm kỹ ti króggróg han ke mũ sir. Ti króggróg han kỹ ti jãnkamy tóg tũ' henh ke mũ, kỹ tóg tovãnh ke mũ sir, ti tỹ ĩn han ti. Kỹ ti mré ke ag tóg ti to vĩ kỹ ti nynh mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ti to ag tóg: “ha mẽ, ĩn téj han sór tóg mũ vẽ, hã ra tóg to jykrén há han ja tũ nĩ, hã kỹ tóg kar tũ nĩ,” henh ke mũ, ti régre ag,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kar pã'i mág to jykrén nĩ gé. Pã'i ũ tỹ ti mré vẽnh génh sór kỹ tóg ã krẽm ke ag nĩkrén ke mũ gé sir, vẽnh génh ke to hã. “10 mil (ke) ẽg nỹtĩ,” he jé tóg ke mũ. “Ẽg mỹ ag tỹ hẽn ri kenh mũ vỹ?” he jé tóg ke mũ. “20 mil (ke) ag nỹtĩ. Ag mỹ ẽg tỹ tũ' he kãn ke tũ nĩ vỹ? Ẽg kãfór ag tóg nỹtĩ. Ẽg hỹn hẽ ri kenh mũ, ag tỹ ẽg tovãnh jé?” he jé tóg ke mũ, pã'i ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ti tỹ tag to jykrén kỹ tóg pã'i ũ ẽn mỹ vẽnh vĩ jẽnẽnh mũ, ti tỹ kór há tá nĩ (hã) ra, kuvar há tá. Ti mỹ vẽnh vĩ jẽnẽn kỹ tóg ti mỹ: “ã mỹ ẽg tovãnh ke tũ nĩ'?” he mũ. “Inh ã mỹ ne nĩm mũ, ã tỹ isovãnh jé?” he jé tóg ke mũ, pã'i ẽn mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Hã kỹ to jykrén nĩ, ãjag tỹ inh mré mũ pẽ han ke to. Iso há kãfór nỹtĩmnĩ, ãjag tũ kar kri. Ke tũ nĩ mũ ra ãjag pi(jé) inh mré mũ pẽ han mũ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sa vỹ há nĩ. Hã ra sa kãhór tĩn kỹ ẽg tỹ ne tỹ ti tỹ kajã' henh ke tóg tũ tĩ, tỹ sa' he mãn ke tũ tóg tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","“Ti kãhór tĩn kỹ tóg kórég nĩ, kỹ ẽg tóg fón tĩ. Ẽg pi(jé) ẽg japỹ ki ti fón tĩ', ti tỹ ẽg jakré tỹ há' he tũ nĩn kỹ, sa kãhór ti. Ti fón pẽ han jé ẽg tóg ke mũ. Ri ke ãjag nỹtĩ, ãjag tỹ inh mré mũ pẽ han tũ nĩn kỹ. Jẽmẽ há han nĩ, sỹ ãjag mỹ nén tó mũ tag ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kejẽn ũ tỹ imposto mãg tĩ ag tóg ti to kãmũ mũ, Topẽ vĩ mranh tĩ ag ke gé. Ag tỹ ti vĩ mẽ sór vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kỹ tóg Fariseu ag mỹ kórég nỹ, Topẽ vĩ to professor ag mỹ ke gé. Kỹ ag tóg ti to vĩ vĩ he mũ sir. “Topẽ vĩ mranh tĩ ag to tóg há nĩgtĩ, tag ti,” he ag tóg mũ. “Ag mré tóg jẽg tĩ mỹr,” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kỹ tóg ag kanhrãn jé ag mỹ: “ũ tỹ Topẽ vĩ mranh mũ tỹ ã jykre kórég tovãnh kỹ tóg ge nỹnh mũ, ha mẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ũ tóg nĩ ja nĩgtĩ,” he tóg. “Ti mẽg tỹ mé vỹ tỹ 100 (ke) nỹtĩ, ti mẽg tỹ ovelha ti. Kỹ ti mẽg pir tóg vãfor mũ. Hã ra tóg ti kanẽg tĩ mũ, ti jãvãnh tĩ tóg mũ, ha mẽ. Ũn e ẽn tovãnh kỹ tóg ũn pir ẽn nón tĩ mũ. Ga kórég tá ag nỹtĩ, ti mẽg kar ẽn ag. Ag togvãnh kỹ tóg ũn pir ẽn nón tĩ mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kỹ tóg ti vég mũ sir, ti mẽg vãfor ja ẽn ti. Kỹ tóg ã nunh kri ti fi kỹ ma tĩ mũ. Ti fe tóg mrin ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kỹ tóg ã ĩn tá jun mũ. Tá tóg ã kanhkã fag jé prẽr mũ, ti rã hã nỹtĩ fag kar. Kỹ tóg fag mỹ tó mũ. “Inh mré ti to mỹ sér,” he tóg. “Inh mẽg vỹ vãfor ja nĩ, hã ra sóg ti ve mãn mũ ha,” he tóg mũ, ã mẽg to,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Hã ra tóg ge nĩ, ha mẽ. Ũ tỹ 99 (ke) ag tỹ vẽnh jykre kuryj han kỹ tóg há tĩ sir, kỹ tóg mỹ sér tĩ sir, kanhkã tá ke ag mỹ. Hã ra tóg mỹ sér kãfór tĩ, ũn pir tỹ ã jykre kórég tovãnh kỹ, ti tỹ ã tỹ Topẽ vĩ mranh mũ ẽn tovãnh kỹ, ha mẽ. Kỹ isũ ag vỹ e nỹtĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kỹ ũn tỹtá to vẽme vỹ ge nĩ, ha mẽ,” he tóg. “Jãnkamy tỹ 10 (ke) tỹ fi tũ nĩ, jãnkamy tỹ por dia kaja tỹ 10 (ke) tỹ. Kejẽn ũn pir tóg fi mỹ vãfor mũ, kỹ fi tóg lampião grug mũ sir. Fi ĩn kãmĩ fi tóg prun kãn mũ. Ve há han fi tóg mũ, jãnkamy ẽn kanẽg jé, ĩn péno kar mĩ hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Vãhã fi tóg kejẽn ve mãn mũ sir. Kỹ fi tóg ã mré ke kar fag jé prẽr mũ, fi rã hã nỹtĩ fag kar ke gé. Kỹ fi tóg fag mỹ: “inh mré to mỹ sér,” he mũ. “Inh jãnkamy vỹ vãfor ja nĩ, hã ra sóg ve mãn mũ ha,” he fi tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hã ra tóg ge nĩ, kanhkã tá, ha mẽ. Topẽ tỹ jẽnẽ jafã ag mỹ tóg sér tãvĩ tĩ, ũ tỹ ã jykre kórég to jũn kỹ, ti tỹ ã tỹ Topẽ vĩ mranh ẽn tovãnh kỹ, ha mẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kỹ tóg ag mỹ tag tó mũ gé sir, ha mẽ. “Ũ vỹ tóg kósin régre ja nĩgtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","“Kỹ ti kósin tỹ ẽgno tóg ã panh mỹ: “panh',” he mũ. “Inh mỹ ũri isũ nĩm, ã tỹ inh mỹ nén nĩm ke mũ ẽn ti,” he tóg, ã panh mỹ. Ti tỹ to vĩnh ke tũ vẽ vẽ, hã ra tóg to vĩ mũ. Ge ra ti panh tóg ã krẽ mỹ ã tũ vẽnh kãpãm mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kãnhmar ti kósin kyrũ tóg ã tũ mãn kỹ kór há ra, kuvar há ra tĩ mũ, ga ũ ra. Tá tóg ã tũ vãm kãn mũ, nén ũ kórég kar to. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Vãm kãn ja tóg nĩgtĩ, ti jãnkamy ti. Kỹ tóg kejẽn tá prỹg han mũ sir, ga ẽn tá. Kỹ kyrũ ẽn tóg kókĩr mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kỹ tóg tá ke ũ mré vẽmén tĩ mũ, ti tỹ ti mỹ vẽnh rãnhrãj nĩm jé. Kỹ tóg ti jẽnẽg mũ, ti tỹ ti porco ki rĩr jé sir, ti safra tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kỹ tóg porco jẽn ko sór mũ, ti kókĩr nĩn kỹ. Hã ra ag tóg ti mỹ nén ũ nĩm tũg mũ, ti tỹ ko jé. Hã kỹ tóg kókĩr tãvĩ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kỹ tóg kejẽn krĩ há han mũ. To jykrén tóg mũ sir. “Inh panh mỹ rãnhrãj tĩ ag vỹ pão mág ko tĩ. Ag mỹ tóg kén tĩ, ag jén tĩ. Jo sóg kókĩr kỹ ter ke mũ,” he tóg, kyrũ ti, ã pir mỹ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Inh jé hỹn inh panh kukãm tĩg ha,” he tóg. “Kỹ sóg ti mỹ: “panh',” henh ke mũ. “Kanhkã tá nĩ ẽn vĩ mranh inh, ã vĩ ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kỹ sóg vẽnhmỹ tỹ ã kósin tũ nĩ. Sỹ tỹ ã camarada nĩnh há tóg tĩ,” he jé sóg ke mũ, inh panh mỹ,” he tóg mũ, kyrũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Kỹ tóg tĩ mũ sir, ã panh kukãm. Hã ra ti panh tóg kór há tá, kuvar há tá ti vég mũ, kỹ tóg ti kato tẽ mũ. Ti kato tẽ kỹ tóg ti ki póm ke mũ sir, ti ki nhun ke tóg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kỹ ti kósin tóg ti mỹ: “panh',” he mũ. “Kanhkã tá nĩ ẽn vĩ mranh inh, ã vĩ ke gé. Hã kỹ sóg vẽnhmỹ tỹ ã kósin tũ nĩ ha,” he tóg, ti panh mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hã ra ti panh tóg ti mỹ: “vó, vẽnh pãte fón kỹ tóg nĩ,” he mũ. Kỹ tóg ã camarada ag mỹ: “kur há tãvĩ ẽn ma kãmũjẽg,” he mũ, “ti tỹ kur tãg ra rã jé. Ti mỹ nĩgé kãnĩm ja nĩm gé. Pẽn né ẽn tỹ, pẽn to ró ẽn tỹ ti mỹ jun gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Monh tãgy ẽn venh mũjẽg. Ti tãnh ra, ẽg tỹ ko jé, ẽg fe tỹ mrin ke jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Inh kósin vỹ inh mỹ ter ja ri ke han, hã ra tóg rĩr mãn ri ke han. Vãfor ti vẽ vẽ, hã ra tóg kãtĩg mãn huri,” he tóg, ti panh ti. Kỹ tóg ag mỹ sér tĩ sir, ag tỹ festa han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Hã ra ti kósin sanh tóg ti japỹ tá rãnhrãj jẽ. Kỹ tóg vãhã tá kãtĩg kỹ ã ĩn tá jun mũ. Tá jun kỹ tóg vãkyr mẽg mũ, fag vẽnh gringrén ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kỹ tóg ã camarada jé prẽr mũ. Ti mỹ tóg: “festa tỹ ne nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kỹ tóg ti mỹ: “ã jãvy vỹ jun, kỹ ã panh vỹ monh tãgy ẽn tãnh,” he mũ. “Ti mỹ tóg sér tĩ, ti tỹ ti ve mãn kỹ. Kaga tũ tóg jẽ, há tóg jẽ, hã kỹ tóg ã panh mỹ sér tĩ,” he tóg, ti camarada ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kỹ tóg jũ mũ sir. Kỹ tóg ĩn kãra rã tũg mũ, jũ kỹ. Kỹ ti panh tóg ti mré vẽmén tĩ mũ. Ti mỹ tóg: “ẽg mré festa venh kãrã,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Hã ra tóg ti mỹ: “vó,” he mũ. “Prỹg tỹ hẽn ri ke ki sóg ã rãnhrãj ti han, ha mẽ. Inh pi(jé) ã vĩ mranh ja nĩgtĩ'. Ge ra ã tóg inh mỹ nén ũ nĩm ja tũ nĩ. Ã pi(jé) inh mỹ cabrito fẽg tĩ', sỹ inh mré ke ag mỹ festa han jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hã ra ã kósin ẽn tóg jun mũ sir, jo ã tóg ti mỹ monh tãgy ẽn tãnh. Kórég ti nĩ, ã kósin ẽn ti. Ã tũ fón kãn tóg mỹr, ũn tỹtá kórég fag to, hã ra ã tóg festa mág han mũ, ti kãtĩg kỹ,” he tóg, ti kósin sanh ti, ã panh mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hã ra ti panh tóg ti mỹ: “vó,” he mũ. “Inh mré ã tóg jẽ nĩ, kỹ tóg inh mỹ sér tĩ. Kỹ isũ kar vỹ tỹ ã tũ nỹtĩ, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hã ra festa tag vỹ há nĩ, ha mẽ. Ẽg mỹ tóg sér tãvĩ tĩ. Ã jãvy vỹ inh mỹ ter ja ri ke han, hã ra tóg rĩr mãn ri ke han. Vãfor ti vẽ vẽ, hã ra tóg kãtĩg mãn huri,” he tóg, ti panh ti, ã kósin sanh mỹ,” he tóg, Jesus ti. Ti tỹ Topẽ kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kỹ Jesus tóg ã mré mũ tĩ ag mỹ tag tó mũ, ha mẽ. “Kejẽn ẽprã ke ũ tóg nĩgtĩ, ũn rico. Kỹ ti tũ ki rĩr tĩ tóg nĩgtĩ gé. Ti patrão mỹ név(e) nỹtĩ ag vég ti tĩ, ti mỹ, ti tũ ki rĩr tĩ ti. Kejẽn ag tóg ti camarada ẽn to vĩ mũ, ti tũ ki rĩr tĩ ẽn to. Ti lograr ke (ka) mẽ ti nẽji nĩ, ti tũ to, ti camarada ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kỹ tóg ti jé prẽr mũ, kỹ tóg ti mỹ: “ã tỹ han mũ mẽ inh,” he mũ. “Sỹ ã rãnhrãj tugnỹm ke vẽ. Ki rĩr mãn ke tũ ã tóg nĩ ha,” he tóg mũ ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kỹ tóg to jykrén mũ sir, ti camarada ti. “Inh hỹn hẽ ri kenh mũ ha?” he tóg mũ. “Inh patrão vỹ inh kutẽm, inh rãnhrãj ki. Kỹ inh hỹn ne konh ke mũ ha? Inh ẽpỹ jé sóg krój nĩ. Kỹ sóg vẽnh kar mỹ: “inh mỹ nén ũ nĩm, inh mỹ jãnkamy nĩm,” he sór tũ nĩ gé. Inh mỹ a tóg tĩ, sỹ ag mỹ tónh ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kejẽn tóg: “ũri hã sóg ki kanhró nĩ ha, sỹ nén han ke ti,” he mũ. “Sỹ tag han kỹ ag tóg iso há nỹtĩnh mũ, kỹ ag tóg inh mỹ: “inh mré nĩnh kãtĩg,” henh ke mũ, inh patrão tỹ inh fón kar kỹ,” he tóg mũ, ti camarada kórég ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kỹ tóg ũ tỹ ã patrão mỹ név(e) nỹtĩ ẽn ag jé prẽr kãn mũ sir. Kỹ tóg ũ mỹ: “ã név(e) hẽ ri ke nĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kỹ tóg ti mỹ: “azeite tỹ lata tỹ 100 (ke) ki inh név(e) jẽ,” he mũ. Kỹ tóg ti mỹ: “hỹn, ã vẽnh rán ti, sỹ ã mỹ ã név(e) térem kỹ 50 (ke) rán jé,” he mũ. Kỹ tóg rán mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kỹ tóg ũ ũ mỹ: “jo ã?” he mũ gé. “Ã név(e) hẽ ri ke nĩ?” he tóg mũ gé. Kỹ tóg ti mỹ: “trigo tỹ saco tỹ 100 (ke) ki inh név(e) jẽ,” he mũ. Kỹ tóg ti mỹ: “hỹn, ã vẽnh rán ti, sỹ ã mỹ ã név(e) térem kỹ 80 (ke) rán jé,” he mũ gé. Kỹ tóg rán mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kỹ ti patrão tóg mẽg mũ, ti camarada tỹ nén han mũ ti. Kỹ tóg ti mỹ: “jykre (ka)mẽ ã tóg nĩ, kỹ ã tóg ũ tỹ hẽn ri ke tỹ ã to há nĩ han, ã tỹ ag mỹ ag név(e) rem kỹ,” he mũ, ti patrão ti,” he tóg, Jesus ti. “Kỹ hã vẽ. Ũ tỹ inh ki ge tũ ag vỹ ãjag tũ to jykrén há han tĩ, inhhã, ha mẽ. Ãjag krĩ há kãfór han ag tóg tĩ ag tũ to jykrén ki. Ãjag tỹ inh ki ge mũ ra ag tóg ãjag krĩ há kãfór han tĩ. Tỹ ag ẽprã ke nỹtĩ, hã kỹ ag tóg tag ki nén to jykrén há han tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Hã kỹ sóg ãjag mỹ tó mũ. Ti camarada ẽn ri ke han nĩ, ãjag tũ tỹ ũn mỹ vẽnh kãpãm nĩ, ãjag tỹ ga kri mũn kỹ. Kỹ ag tóg ãjag to há nỹtĩnh mũ. Kejẽn ãjag tóg ãjag tũ ré kỹ mũnh mũ. Ẽn kã ãjag tóg mũ há han ke mũ gé. Kỹ ãjag tóg kanhkã tá junjun ke mũ sir, ãjag tỹ ag mỹ ãjag tũ tỹ vẽnh kãpãm kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ũ tỹ nén ũ sĩ ki rĩr há han kỹ tóg nén ũ ki rĩr há han kãn ke mũ gé. Jãvo ũ tỹ nén ũ sĩ ki rĩr kónãn kỹ tóg nén ũ ki rĩr kónãn kãn ke mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ẽg tỹ ga kri nén vég mũ vỹ kãnhmar tũ' he mũ. Ãjag tỹ hã ra ga kri ãjag tũ ki rĩr há han tũ kỹ ãjag tóg kanhkã tá tỹ nén ũn tũ nỹtĩnh mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ãjag tỹ ẽprã nén vég mũ vỹ tỹ Topẽ tũ nĩ. Ti hã mỹ ãjag tóg ki rĩr ke mũ. Ãjag tỹ ti tũ ki rĩr há han tũ kỹ tóg sir ãjag mỹ ãjag tũ pẽ ẽn nĩm ke tũ nĩ gé, kanhkã tá,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ã jagrẽ régre nĩn kỹ tóg vẽnhmỹ tĩ. Ã tỹ Topẽ hã tỹ jagrẽ nĩn kỹ jãnkamy tãn ẽn tỹ jagrẽ nĩ sór tũg nĩ. Ã tỹ jãnkamy e ve sór kỹ ti hã mĩ ẽkrén kỹ ti hã vỹ tỹ ã jagrẽ nĩnh mũ. Kỹ ẽg tóg Topẽ tỹ ẽg mỹ nén tó mũ ẽn to jykrén há han ke tũ nĩgtĩ. Ã tỹ Topẽ to há nĩn kỹ ã tóg sir ga kri rico to vãsãn sór ke tũ nĩ. Ã tỹ ga kri rico nĩ sór kỹ ã tóg Topẽ mĩ ẽkrég tũ nĩ, ha vemnĩ,” he tóg, Jesus ti. Ti tỹ ẽg tỹ ti tũ hã to jykrén há to jykrén há han ke tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hã ra Fariseu ag tóg mẽg mũ, ti tỹ nén tó mũ ti. Jãnkamy mág hã to ag tóg há nỹtĩ, rico ke sór ag nỹtĩ, Fariseu ag. Kỹ ag tóg Jesus vĩ tag mẽ kỹ ag tóg ti to é he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hã ra Jesus tóg ag mỸ: “ẽprã ke ag mỹ ãjag tóg há nỹtĩ ve nỹtĩ,” he mũ. “Hã ra Topẽ vỹ ãjag tỹ nén to jykrén mũ ẽn vég nĩ. Ón kỹ ãjag tóg há nỸtĩ. Ẽprã ke kãmĩ ãjag tóg tỹ ũn mág nỹtĩ. Topẽ mỹ ãjag tóg kórég nỹtĩ jãvo, ti mỹ kavéj ãjag tóg nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moisés tỹ ẽg mỹ Topẽ vĩ tó ja ẽn vỹ João tá krỹg, vãsỹ Topẽ vĩ tó tĩ ag tỹ ẽg mỹ nén tó ja kar ẽn ti. João tá ti krỹg, ẽg kygpég tĩ ẽn tá. João tá jun kỹ vẽnh ũ tỹ hẽn ri ke ag tóg vãsãnsãn tĩ, ag tỹ ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hã ra Topẽ jykre si ẽn tóg tũ' henh ke tũ nĩ gé, Moisés tỹ ẽg mỹ nén tó mũ ẽn ti. Ga vỹ tũ' henh ke tũ nĩ. Ki króm kãn kỹ tóg nĩnh mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ẽg prũg kỹ tóg ge nĩ, ha mẽ. Ã tỹ ã prũ fi fón kar kỹ ũ fi tỹ prũg mãn kỹ ã prũ tũ fi vẽ sir. Kỹ fi mén tỹ fi fón kỹ ũ tỹ fi tỹ prũg mãn kỹ fi mén tũ vẽ gé sir,” he tóg, Jesus ti. Ti tỹ Topẽ jykre kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kỹ Jesus tóg ag mỹ: “kejẽn ũ tóg nĩgtĩ, ũn rico pẽ,” he mũ. “Kur kaja e tu ti tĩgtĩ, ũn tánh sá, kur ha pẽ. Kurã kar ki tóg vẽjẽn há ko tĩ. Festa ri ke han tóg tĩ, kurã kar ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kỹ ũn jagtar tóg nĩgtĩ gé. Ti jiji hã vỹ: Lázaro, he mũ. Vẽnh kaga fugfo han vãnh han tóg tĩ, kỹ tóg nỹ nĩ, ũn rico jãnkã ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ẽn vỹ kókĩr tĩgtĩ, ã kaga to. Kỹ tóg ũn rico jẽn vár ko sór tĩgtĩ, ti jẽn mru, hã ra tóg ti mỹ nĩm tũg tĩ. Cachorro hã ne ti pénĩn e nỹtĩ. Vẽnh fugfo han vãnh ẽn tugmãn ag tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kejẽn tóg ter mũ, ũn jagtar ẽn ti. Kỹ Topẽ tỹ jẽnẽ jafã ag vỹ ti va mũ mũ, ti kuprĩg ti, kanhkã ra. Tá Abraão tóg nĩ nĩ, ẽg jóg' jóg ve ti, kỹ tóg ti mré nĩ nĩ sir, ti tỹ tỹ ti krẽ'krẽ nĩn kỹ. Kar ũn rico tóg ter mũ gé sir. Kỹ ag tóg ga kãtá ti péju(g) mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hã ra tóg nũgme ki kutẽ mũ, ti kuprĩg ti. Inferno tá ti vẽsỹrénh jagy han mũ sir. Kejẽn tóg kanhkã ki ẽvãnh mũ, kỹ tóg tá Abraão vég mũ, Lázaro ke gé, ti tỹ Abraão mré nĩn kỹ, kuvar há tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kỹ tóg ag mỹ prẽr mũ. Kỹ tóg Abraão mỹ: “!..Ijóg'..!” he mũ. “!..Abraão..!” he tóg “!..Ijagãgtãn ra..!” he tóg. “Lázaro jẽnẽ ra, ti tỹ ã nĩ(gé) juja junun mrãn kỹ inh nũnẽ mrãn sĩ han jé. Inh mỹ tóg rỹjgy tãvĩ tĩ, pĩ kãki,” he tóg, Abraão mỹ, ũn rico ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kỹ Abraão tóg ti mỹ: “inh kósin,” he mũ. “Ã tỹ ga kri tĩg ja ẽn ki ẽkré. Tá ã tóg há tĩ ja nĩgtĩ, jãvo Lázaro tóg jagtar ja nĩgtĩ. Kỹ tóg tag ki há han tĩ nĩ, jo ã tóg vẽsỹrénh jẽ nĩ, ã tỹ ti jagãgtãn ja tũ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kỹ ẽg kuju ki tóg tỹ kãgnó nĩ, kỹ ũ tóg pãte rãnh ke tũ nĩ. Tag ki ke pi(jé) ẽn ra tĩg mũ', ẽn tá ke pi(jé) tag ra kãtĩg mũ gé', kãgnó tag tugrĩn',” he tóg, Abraão ti, ũn rico ja ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kỹ ũn rico ja tóg ã jóg tỹ Abraão mỹ: “kỹ sóg ã mỹ nén ũ tó sór mũ, ha mẽ,” he mũ. “Ã mỹ inh jóg ĩn ra ti jẽnẽnh ke tũ? Tá inh mré ke ag vỹ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","5(ke) ag nỹtĩ, inh mré pafa ja ag. Ti tỹ ag mỹ tónh tĩg jé, ag tỹ tag ki junjun tũ nĩ jé, ag tỹ inh mré vẽsỹrénh tũ nĩn jé,” he tóg, ũn rico ja ti, Abraão mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kỹ Abraão tóg ti mỹ: “tá ag tóg Moisés tỹ ẽg mỹ nén tó ja ẽn mẽnh mũ, Topẽ vĩ tó tĩ kar ag vĩ ke gé. Hã kỹ ag tóg Topẽ vĩ jẽmẽnh mũ, ag tỹ mẽ sór kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Hã ra tóg ã jóg tỹ Abraão ti mỹ: “vó” he mũ. “Vẽser tỹ ag tá jun mũ ra ag jẽmẽ há han ke mũ vẽ, kỹ ag tóg ãjag jykre pãno ẽn tovãnh ke mũ vẽ, vẽser tỹ ag mỹ tó mũ ẽn ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Hã ra tóg: “vó,” he mũ gé. “Ag tỹ Moisés vĩ jẽmẽ sór tũ nĩn kỹ ag tóg vẽser vĩ mẽnh ke tũ nĩ gé, ag tỹ Topẽ vĩ tó tĩ ag vĩ mẽ jãvãnh nỹtĩn kỹ,” he tóg, Abraão ti, ũn rico ja ẽn mỹ,” he tóg, Jesus ti. Ti tỹ ag mỹ ẽg tỹ Topẽ vĩ jẽmẽ jãvãnh nỹtĩn kỹ vẽsỹrénh ke ẽn tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kỹ Jesus tóg ã mré mũ tĩ ag mỹ: “ũ tỹ hẽn ri ke ag vỹ ũ tỹ iso há ẽn tỹ isovãnh han sór mũ, ha mẽ,” he mũ. “Vẽsỹrénh tãvĩn mũ jé ag tóg ke mũ, tag to. Topẽ vỹ ag ve kónãn tãvĩn mũ, ag tỹ ũn krĩn kónãn mũ tag to. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ũ tỹ ag krĩn kónãn mũ mỹ tóg há nỹnh mũ vẽ, ẽg tỹ pó tỹ kra mág tỹ ag nunh to sa kỹ goj nig kuju ki ag vãm jé. Tag vỹ ag mỹ jagy tĩ vẽ. Hã ra ag tóg ti jagy tag kãfór venh ke mũ, ag tỹ ũn sĩ tỹ inh ki rã kỹ nĩ (hã) ra ti tỹ inh vĩ mranh han sór kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","To jykrén, vẽnh ki rĩr kỹ. Kejẽn ã régre vỹ Topẽ vĩ mranh mũ. Kỹ ti mỹ tómnĩ, ti tỹ kygnẽ ti. Ti tỹ tovãnh sór kỹ ti mỹ vẽnh pãte fón nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Hẽn ri ke mũn tóg ã tỹ Topẽ vĩ mranh han sór mũ han mãn', han mãn' he mũ, kejẽn. Kurã pir ki tóg ã jũ tỹ hẽn ri ke han sór mũ, hẽn ri ke mũn. Hã ra tóg ã jũ han kar kỹ: “inh pi(jé) ke mãn mũ ha',” henh ke mũ gé. Ã jũn kỹ tóg tónh kãtĩg mãn', tónh kãtĩg mãn' he mũ gé. Kỹ ti mỹ vẽnh pãte fón to krónh ke tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kỹ Jesus tỹ ũn vin mũ ag tóg ti mỹ: “ẽg tỹ Topẽ ki rã há pẽ han há tóg tĩ,” he mũ. “Kỹ to ẽg tar han nĩ,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kỹ tóg ag mỹ: “ãjag tỹ Topẽ ki rã kỹ tóg há tĩ,” he mũ. “Ka tỹ mostarda fy mĩ ẽkrén nĩ,” he tóg. “Sĩ ti nĩ, hã ra tóg mog tĩ. Tag ri ke han nĩ, Topẽ ki rã kỹ. Ti ki rã kỹ ãjag tóg nén ũ kar to tar nỹtĩnh mũ. Ka tag ve ra, ka krén tag ti. Ãjag tỹ ti mỹ: “ã jãre tỹ ga tá kãkutẽ, kỹ goj nig ki vẽnh krãn,” hen kỹ tóg kenh mũ, ãjag tỹ Topẽ ki rãn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ãjag camarada jykre to jykrén nĩ,” he tóg. “Ãjag japỹ ki tóg rĩr tĩ, ga tỹ vĩrĩn ken kỹ, ke tũ nĩn kỹ tóg ãjag mẽg ki rĩr tĩ gé. Rãkãnh kỹ tóg ã rãnhrãj ja tá kãtĩ tĩ. Kỹ ãjag pi(jé) ti mỹ: “kunĩg, jẽn jé,” he tĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ti mỹ ãjag tóg: “inh mỹ vẽjẽn han, ijẽn jé,” he tĩ. “Kuri ã kur tãnfyn kỹ tógfĩn, ã tỹ inh mỹ vẽjẽn jun jé, ijẽn jé, kron jé, kar kỹ ã tóg jẽn ke mũ gé sir, kron ke mũ gé sir, ijẽn kar kỹ,” he ãjag tóg tĩ, ãjag camarada mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kỹ ãjag tóg ti mỹ vĩ há han tũ nĩ gé, ti tỹ ãjag vĩ ki króm mũ ra. Ãjag camarada vẽ mỹr, ti rãnhrãj vẽ, hã kỹ tóg ãjag vĩ ẽn han ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kỹ ãjag camarada ag ri ke han nĩ, Topẽ mỹ, ha mẽ. Ãjag tỹ Topẽ vĩ ki króm kãn kỹ jagnẽ mỹ: “ti camarada vỹ tỹ ẽg nỹtĩ,” hemnĩ. “Ti tỹ ẽg mỹ nén tó mũn hã han ẽg tóg, kỹ tóg tỹ nén ũ tũ nĩ,” hemnĩ jagnẽ mỹ. “Ti vĩ han kãn tugrĩn ẽg tóg há nỹtĩ,” he tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kỹ Jesus tóg Jerusalém ra tĩg sór mũ. Hã kỹ tóg ga tỹ Samaria fyr mĩ tĩ mũ. Ga tỹ Galiléia mré ti fyr vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tá tóg ẽmã ũ ki rã mũ, kỹ ũ tỹ 10 (ke) ag tóg ti kato tẽgtẽ mũ sir. Vẽnh kaga kren vãnh hyn han ag tóg mũ, lepra han kỹ. Hã kỹ ag tóg kór há tá nỹtĩ, kuvar há tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jamã hár(a) ag tóg prẽnprẽr mũ, kỹ ag tóg: “!..Jesus'..!” he mũ. “!..Senhor'..!” he ag tóg mũ. “!..Ẽg jagãgtãn ra..!” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kỹ tóg ag ki ẽvãnh mũ, kỹ tóg ag mỹ: “Topẽ tũ ki rĩr tĩ ag mỹ vẽnh ven mũjẽg,” he mũ. Kỹ ag tóg mũ mũ. Ag mũn kã ag tóg jãnhkri' he mũ sir, ag fár ti, tá junjun to hã. Hághá' he ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kỹ ag kãmĩ ũn pir tóg kyrã mũ, Jesus to. Topẽ mỹ tóg vĩ há han mũ, ã tỹ há' hen kỹ. Kỹ vẽnh kar vỹ ti vĩ mẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ti tỹ Jesus tá jun kỹ tóg ti krẽm mũg ke mũ. Ti mỹ tóg: “inh mỹ tóg há tĩ, ã tỹ isỹ há' hen kỹ,” he mũ. Samaria tá fóg ũ vẽ, Jesus to ũn kyrã mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kỹ Jesus tóg: “ũ tỹ 10 (ke) tũ mỹ', hã vỹ: há', he mũ?” he mũ. “Hã ra ũn pir ne kãtĩg ja nĩ'. Hỹn, ũ ag, ũ tỹ 9 (ke) ẽn ag?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","“Fóg tag hã vỹ ã pir mỹ kyrã, Topẽ to: “ũn mág vỹ tỹ ti nĩ,” he jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kỹ tóg fóg ẽn mỹ: “jẽgnẽ ra,” he mũ. “Ha tĩg,” he tóg. “Ã tỹ inh ki rã kỹ, hã kỹ ã tóg há' he mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kejẽn Fariseu ag tóg ti ki jẽmẽnh kãmũ mũ. “Topẽ tỹ tỹ ẽg pã'i nĩ ẽn mỹ ver kór gy nĩ, mỹ kuvar gy?” he ag tóg ti mỹ. Kỹ tóg ag mỹ kãmén mũ sir. “Ti vég tũ ẽg tóg nĩ, ẽg kanẽ tỹ, Topẽ tỹ tỹ ẽg pã'i nĩ ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Hã kỹ ẽg tóg to: “tag kã ti nĩ, tãtá ti nĩ,” henh ke tũ nĩ gé. Ha mẽ, ãjag kãmĩ ti huri vẽnh ven, ti tỹ tỹ ẽg pã'i nĩ ti, ãjag tỹ ti vég tũ (hã) ra,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kỹ tóg ã mré mũ tĩ ag mỹ: “tỹ sóg ẽprã ke fi kósin nĩ,” he mũ. “Kejẽn tóg ãjag tỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ha pẽ tĩnh mũ. Ti tỹ kurã pir ki vẽnh ven mũ vỹ ãjag mỹ há tĩnh mũ vẽ, hã ra ãjag tóg venh ke tũ nĩ ver,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Kỹ ag tóg ãjag mỹ: “tag ki ti jun ja nĩ,” henh ke mũ. “Ẽn tá tóg jẽ nĩ,” he jé ag tóg ke mũ gé. Kỹ venh mũ tũg nĩ hã ra. Ag vĩ jẽmẽ sór tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Inh kãtĩg mãn ke vỹ ta tỹ kóm kóm ke ri ke nĩ. Ti tỹ kóm kóm ke kỹ ẽg tóg nén kar vég tĩ, kanhkã krẽm. Kỹ vẽnh kar vỹ ti tỹ kóm kóm ke ẽn vég tĩ gé. Inh kãtĩg mãn ke vỹ ri ke nĩnh mũ, inh kurã ẽn kã. Vẽnh kar vỹ inh ve kãn mũ. Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Inh kãtĩg mãn ke to hã sóg hã ra vẽsỹrénh mág han ke mũ ver. Ũri ke ag vỹ iso é henh ke mũ ver,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kỹ inh kãtĩg mãn ke kurã ẽn kã ẽprã ke ag tóg han kãn ke mũ, ag tỹ Noé tỹ ga mĩ tĩ mũ kã nén han ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ta kutẽ to hã ag tóg jẽn ja nĩgtĩ, jẽn kar kỹ ag tóg kron ja nĩgtĩ gé, vẽnh prũ kutẽm ja ag nĩgtĩ gé. Ẽn kã Noé tóg kejẽn barco tỹ ĩn kãra rã ja nĩ. Ti tỹ kãra rã kar kỹ ta tóg sir kutẽ ja nĩ, kỹ ag tóg goj var ki kãgter kãn ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kỹ tóg ri ke pẽ ja nĩ gé, Ló tỹ ga mĩ tĩg ki. Ẽn kã ag tóg jẽn ja nĩgtĩ gé, jẽn kar kỹ ag tóg kronkron ja nĩgtĩ gé. Vender ke mũ ja ag nĩgtĩ gé, kygjãm ke mũ ja ag nĩgtĩ gé. Ẽkrãn ja ag nĩgtĩ gé, ĩn hyn han ja ag nĩgtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ẽn kã Ló tóg kejẽn cidade tỹ Sodoma tá kãkutẽ ja nĩ, kỹ pĩ tóg kanhkã tá kãtére ja nĩ, cidade kri, pó tỹ enxofre nĩja ẽn ke gé. Kỹ ẽn tóg ag kãgtén kãn ja nĩ. Topẽ tỹ ag vóg kónãn ke to jykrén sór tũ ja ag nỹtĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ge ti nĩnh mũ gé, ẽprã ke fi kósin tỹ vẽnh ven mãn ke kurã ẽn kã. Mĩ ẽkrén ke tũ ag nĩgtĩ gé, ti to há tũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ũ tỹ kurã ẽn kã ã ĩn rã hã tĩn kỹn jé ã tũ mãn rã sór tũg, ti tũ tỹ ti ĩn krẽm nỹtĩ ti. Ũ tỹ ẽpỹ tá tĩ ẽn jé ã tũ to vỹn ke tũg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ló prũ fi to jykrén. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ãjag tỹ ãjag jykre hã han sór kỹ ãjag nũgme ki vár ke mũ, ha vemnĩ. Ãjag tỹ isugrĩn ãjag jykre fi mãn kỹ ãjag krenkren ke vẽ, ha vemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Hã kỹ sóg tag tó mũ, ha mẽ. Kuty ẽn kã, inh kãtĩg mãn ke kuty ẽn kã ũn régre ag vỹ jagnẽ mré nũgnũr nỹtĩnh mũ. Ag kãmĩ ũn pir jé prẽr sóg ke mũ, kỹ tóg inh mré tĩnh mũ, jãvo ti régre vỹ kã nỹnh mũ, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ũn régre fag vỹ ẽgtynyn nỹtĩnh mũ, jagnẽ mré, ẽn kã. Kỹ sóg ũn pir fi jé prẽr ke mũ, kỹ fi tóg inh mré tĩnh mũ, jãvo fi régre fi vỹ kã jẽnh mũ, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ũn régre ag vỹ ẽpỹ ki rãnhrãj mũnh mũ, ẽn kã. Kỹ sóg ũn pir jé prẽr ke mũ, kỹ tóg inh mré tĩnh mũ. Jãvo ti régre vỹ tá tĩnh mũ gé, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kỹ ti mré mũ tĩ ag tóg ẽg Senhor mỹ: “tag hẽ tá ke nĩnh mũ hỹn'?” he mũ. Kỹ tóg ag mỹ: “kurã ẽn kã ãjag ki kanhró nỹtĩnh mũ,” he mũ. “Nén ũ ter nỹg ja ri ke ti nĩ. Hã tá tóg vẽnh mãn tĩ, jãtã ti, he ẽg tóg tĩ. Tag ri ke ti nĩnh mũ, ha vemnĩ,” he tóg, Jesus ti. Ti tỹ ã kãtĩg mãn ke tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kỹ Jesus tóg ag mỹ: “ãjag tỹ Topẽ mré vẽmén ke vỹ ge nỹnh mũ, ha mẽ,” he mũ. Ẽg tỹ kurã kar ki Topẽ mré vẽmén kỹ tóg há tĩnh mũ, ẽg tỹ to krónh ke tũ nĩn kỹ. Tag tỹ tóg ag kanhrãnrãn sór mũ, ã mré mũ tĩ ag, hã kỹ tóg tag tó mũ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Kejẽn pã'i tóg nĩgtĩ, ẽmã ũ tá,” he tóg. “Ag tỹ jagnẽ to jũ vég ti tĩ. Ti rãnhrãj hã vẽ. Hã ra tóg Topẽ kamẽg vãnh nĩ, ti jykre pãno nĩn kỹ. Kỹ tóg ã mré ke ag kamẽg vãnh pẽ nĩgtĩ gé. Kórég pẽ ti nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti jamã tá ũ fi tóg nĩgtĩ gé, ũn mén ter ja fi. Ẽn fi vỹ kejẽn ti to kãtĩg kỹ ti mré vẽmén mũ. Kỹ fi tóg ti mỹ: “inh lograr ke sór mũ ẽn ag jo inh vemnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Hã ra tóg mẽ jãvãnh nĩ. Jatu tóg nĩ nĩ, kysã tỹ hẽn ri ke ki. Kỹ fi tóg ti tá jun tỹ hẽn ri ke han mũ, to krónh ke tũ fi nĩ. Kỹ tóg kejẽn to jykrén mũ. “Topẽ kamẽg vãnh inh nĩgtĩ,” he tóg. “Ũ kamẽg vãnh inh nĩgtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Hã ra fi tóg isovãnh tũ pẽ nĩ, ũn mén ter ja ẽn fi. Kurã kar ki fi tóg inh mỹ to vĩnh kãtĩ tĩ. Kỹ inh hỹn fi jy rãnh mũ ha, ke tũ nĩ mũ ra fi tóg ijũ han ke mũ, fi tỹ inh venh kãtĩ to krónh ke tũ nĩn kỹ, ha vemnĩ,” he tóg, pã'i kórég ti,” he tóg, ẽg Senhor tỹ Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kỹ tóg ag mỹ: “ti vĩ jẽmẽ ra,” he mũ. “Jykre pãno ti nĩ, pã'i kórég ẽn ti, hã ra tóg fi tỹ ti mỹ vĩ e ẽn to fi kren han sór mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“Hã kỹ Topẽ vỹ ãjag krenkren han ke mũ gé. Ãjag kuprẽg ja tóg nĩ mỹr, kỹ ti mré vẽmén nĩ. Kurã ki ti mỹ vĩmnĩ, kuty tá ke gé. Ãjag kren han vãnh nĩ ve ti nĩ, kejẽn. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Hã ra tóg ãjag krenkren han ke mũ, kãnhmar, ha vemnĩ. Ki hã sóg tó mũ,” he tóg. “Hã ra ẽprã ke fi kósin ẽn tỹ kãtĩg mãn kỹ ag mỹ ti ki ge sór mũ vỹ?” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kỹ Jesus tóg ag kanhrãn mãn mũ gé. Ũ tóg ũ tỹ ti vĩ mẽg mũ ẽn ag kãmĩ nỹtĩ, hã ra ag tóg vẽso: “tỹ ẽg tóg ũn há nỹtĩ,” he tĩ. “Kórég tũ ẽg nỹtĩ, jo ũ ag ne kórég nỹtĩ',” he ag tóg tĩ, vẽso, Jesus vĩ mẽg mũ ũ ag. Ẽn ag kanhrãnrãn sór tóg mũ, Jesus ti. Kỹ tóg ag mỹ: “ãjag jykre vỹ ge nỹnh mũ, ha mẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kejẽn Fariseu ũ tóg nĩgtĩ. Topẽ jo ĩn ra tóg tĩ mũ, tá Topẽ mré vĩ jé. Ti mré ũ tóg ra tĩ mũ gé, ũ tỹ governo mỹ jãnkamy mãg tĩ ti. Topẽ mré vĩ sór tóg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kỹ Fariseu tóg Topẽ mré vẽmén jẽ nĩ. “Topẽ,” he tóg. “Inh mỹ tóg há tĩ, isỹ jykre kórég tũ nĩn kỹ, ag jãvo. Ũ ag tóg nén ũ péju(g) tĩ, hã ra sóg han tũ nĩgtĩ. Ũ ag tóg nén ũ vẽnhmỹ han tĩ inhhã, jãvo inh pi(jé) han tĩ'. Ãjag prũ tũ fag mré ag tóg nỹgtĩ inhhã. Kỹ governo mỹ jãnkamy mãg tĩ tag ti vỹ kórég nĩ gé inhhã. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ag jãvo sóg vẽnh jykre há han tĩ. Semana kar ki sóg vãkre régre han tĩ, jẽg mẽ tĩ ki. Hã ki sóg ã jykre ki króm tĩ. Isũ tỹ sóg dízimo kajãm tĩ, ã mỹ. Sỹ nén ũ tỹ 10 (ke) ki sóg ũn pir nĩm tĩ, ã mỹ dízimo han kỹ,” he tóg, Fariseu ti, Topé mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Hã ra governo mỹ jãnkamy mãg tĩ ẽn tóg kór há tá jẽ nĩ, kuvar há tá, mỹ'ãg kỹ. Kỹ tóg kanhkã ki ẽvãnh tũ nĩ gé. Ã fe kri tóg kãgmĩg mũ, ti tỹ mỹ'ãg mág kỹ. Kỹ tóg Topẽ mré vĩ mũ. “Topẽ,” he tóg mũ gé. “Ã vĩ mranh inh mỹr,” he tóg. “Ã mỹ inh jagãgtãn ke tũ hã ra,” he tóg, Topẽ vĩ mranh tĩ ẽn ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ha mẽ, Topẽ vỹ ti mỹ vẽnh pãte fón, hã kỹ tóg jatun mỹ vyr. Jãvo tóg Fariseu ẽn mỹ vẽnh pãte fón tũ nĩ. Ge ti nĩgtĩ. Ẽg tỹ vẽso: “há inh nĩ,” hen kỹ Topẽ tóg ẽg to kórég nĩ. Kỹ tóg ẽg térem mũ sir. Ẽg tỹ hã ra vẽso: “kórég inh nĩ,” hen kỹ Topẽ vỹ ẽg to há nĩ, kỹ tóg ẽg tỹ ũn mág han ke mũ gé sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kỹ fag tóg gĩr tatĩ kãmũ mũ ti to, ti tỹ gĩr kri ã nĩgé fi jé. Hã ra ti mré mũ tĩ ag tóg vég mũ, kỹ ag tóg fag to jũ mũ, ũ tỹ ag tatĩ kãmũ mũ fag to. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hã ra Jesus tóg fag jé prẽr kỹ ag mỹ: “vĩ tũg nĩ, gĩr ag mỹ,” he mũ. “Gĩr ag tỹ iso kãmũ kamẽg tũg nĩ,” he tóg. “Ũ tỹ ge hã vỹ ẽg Senhor tỹ Topẽ krẽm nỹtĩnh mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Sỹ ke há vẽ, hã kỹ sóg tó mũ. Gĩr ag vỹ iso há pẽ nỹtĩ. Ũn kãsir tag ag ri ke nỹtĩmnĩ, ke tũ nĩ mũ ra ãjag tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke tũ nĩ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kỹ kejẽn ũ tóg Jesus ki jẽmẽnh kãtĩ mũ, pã'i ũ. Kỹ tóg ti mỹ: “Senhor',” he mũ. “Há ã tóg nĩ,” he tóg. “Sỹ rĩr krỹg ja tũ venh há tóg tĩ. Sỹ ti ve jé inh hỹn vẽnh jykre há tỹ ne han ke mũ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kỹ Jesus tóg ti mỹ: “iso: “há ã nĩ,” he sór tũg nĩ,” he mũ. “Ẽg pi(jé) há nỹtĩ',” he tóg. “Topẽ hã ne ã pir mỹ há nĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","“Topẽ tỹ nén ũ to ẽg jyvẽn ja ẽn ki kanhró ã tóg nĩ, hã vỹ: ã prũ tũ fi mré nỹ tũg nĩ, he mũ, ũ tén tũg nĩ, he mũ, nén ũ péju(g) tũg nĩ, he mũ, ũ to ón tũg nĩ, he mũ, ã nỹ mré ã jóg kamẽg nĩ, he mũ,” he tóg ti mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hã ra tóg: “ki króm kãn sóg, isĩn kã,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kỹ Jesus tóg ti mỹ: “nén ũ pir vỹ tũ nĩ ver,” he mũ. “Ã tũ vãm kãn nĩ, ã tỹ ũn vẽsỹrénh mũ ag mỹ vin jé, jãnkamy ti. Kỹ ã tóg kanhkã tá tũ mág nĩ sir. Kar kãtĩg nĩ, ã tỹ inh mré tĩg jé,” he tóg ti mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kỹ tóg ti mỹ vẽnhmỹ tĩ, Jesus vĩ ti, ti rico pẽ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hã ra Jesus tóg ti mỹ vẽnhmỹ ẽn ki kanhrãn mũ. Kỹ tóg ã mré mũ tĩ ag mỹ: “jagy ti nỹ, ũn rico tỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke ti,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","“Cavalo pãnĩ sór vỹ préj nor fĩn rãm ke tũ nĩ,” he tóg. “Ti tỹ fĩn rãm ke ra tóg jagy tĩ vẽ, ũn rico tỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kỹ ti vĩ mẽg mũ ag tóg to vẽmén mũ. “Kỹ ũ hỹn kren ke tũ pẽ nĩ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Kỹ Jesus tóg ag mỹ: “ẽprã ke ag vỹ tá junjun ke tũ nĩ vẽ,” he mũ. “Hã ra Topẽ hã tóg ẽg tỹ tá junjun han ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kỹ Pedro vỹ: “ha vé,” he mũ. “Ẽg tỹ nén ũ kar ré jé ẽg tóg mũ mũ, ẽg tỹ ã mré mũ jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kỹ Jesus tóg ag mỹ: “sỹ ke há vẽ, hã kỹ sóg tó mũ,” he mũ. “Ũ tóg kejẽn ã jamã ré kỹ tĩ mũ, ti prũ fi, ti kãke, ti jãvy, ti han mũ fag, ti krẽ ré kỹ tóg tĩ mũ, Topẽ tỹ tỹ ẽg pã'i nĩ tugrĩn, ti tỹ ti vĩ ki króm jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","“Ẽn vỹ tóg sir vẽnh kaja jé nén kar ẽn tỹ ũn e venh ke mũ, ag jẽgja kã, ga kri, kar kỹ tóg vãhã sir ẽg rĩr krỹg ja tũ venh ke mũ gé sir, kanhkã tá,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kỹ tóg ũ tỹ 12 (ke) ag jé prẽr mũ, vyrmỹ, ag mỹ kãmén jé. “Ha vé,” he tóg. “Jerusalém ra ẽg mũ mũ, kỹ sóg tá ve kãn ke mũ, vãsỹ Topẽ vĩ tó tĩ ag tỹ iso nén rán ja ẽn ti,” he tóg. “Tỹ sóg ẽprã ke fi kósin ẽn nĩ, hã kỹ ag tóg inh kãmén ja nĩ, Topẽ vĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Fóg ag mỹ ag tóg inh fẽg ke mũ, pã'i ag, Jerusalém tá, ha vemnĩ, ag tỹ iso é he jé, ag tỹ inh vóg kónãn jé, ag tỹ iso sug ke jé gé, ");
INSERT INTO kgpNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ag tỹ inh mrãnmrãn jé. Ag tỹ isén ke vẽ. Hã ra sóg kurã tãgtũ tũg kỹ rĩr mãn ke mũ, ha vemnĩ,” he tóg, ti mré mũ tĩ ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Hã ra ag tóg ti vĩ tag to jykrén tũ nĩ, ũ tỹ 12 (ke) ẽn ag. Ti vĩ tóg ag mỹ vẽnhmỹ tĩ. Kỹ ag tóg ki kagtĩg nỹtĩ. “Ti tỹ ne tó nẽ hỹn'?” he ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ag mũn kỹ ag tóg Jericó to hã mũ mũ. Tá ũn kyvó vỹ ẽpry kri nĩ nĩ, ẽmĩn kri. “Inh mỹ jãnkamy nĩm,” he tóg tĩ, vẽnh kar mỹ, ti kyvó nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ẽn vỹ vẽnh kar tỹ ẽpry jagma mũ mẽg tĩ. Kỹ tóg ag mỹ: “ũ nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kỹ ag tóg ti mỹ: “Jesus vẽ, Nazaré tá ke ẽn vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kỹ tóg prẽr mũ sir. “!..Jesus'..., Davi kósin'..., ijagãgtãn ra..!” he tóg mũ, prẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kỹ Jesus jo mũ ag vỹ ti mỹ vĩ jũ han mũ. “Ẽmẽ kã nĩ nĩ,” he ag tóg ti mỹ. Hã ra tóg prẽr mãn', prẽr mãn' he mũ. “!..Davi kósin'..., ijagãgtãn ra..!” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kỹ Jesus tóg krỹg he mũ, kỹ tóg: “ti jé prẽr,” he mũ. Kỹ ag tóg ti pére kãmũ mũ. Ti ki jun kỹ tóg ti mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“inh ã tỹ hẽ ri kenh ke?” he mũ. Kỹ tóg ẽg Senhor mỹ: “sỹ venh há tóg tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kỹ Jesus tóg ti mỹ: “kỹ tỹ vé,” he mũ. “Ã tỹ inh ki rã kỹ ã há' henh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kỹ tóg vẽsỹmér ẽvãnh há' he mũ sir. Kỹ tóg ti mré tĩ mũ. Topẽ mỹ tóg vĩ há han mũ. Kỹ tóg vẽnh kar mỹ há tĩ, ag tỹ ti tỹ há' he mũ ẽn ven kỹ. Kỹ ag tóg Topẽ mỹ vĩ há han mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kỹ Jesus tóg cidade tỹ Jericó ki rã mũ sir, kỹ tóg fĩn rãm kỹ tĩg sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Hã ra ũ tóg tá nĩ nĩ, ti jyjy hã vỹ: Zaqueu, he mũ. Governo mỹ jãnkamy mãg tĩ ag pã'i vẽ. Rico pẽ ti nĩ, rico tãvĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ẽn tóg Jesus ve sór mũ, ti tỹ Jericó fĩn rãm kỹ. Hã ra tóg rur jẽ, hã kỹ tóg ti vég tũ nĩ, vẽnh e ag tỹ ti pénĩn mũn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Hã kỹ tóg ti jo vẽnhvãg tĩ mũ, kỹ tóg ka tỹ krén to tãpry mũ, ti tỹ Jesus ve jé, ti tỹ jagma tĩg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kỹ Jesus tóg ka ẽn tá jun mũ. Hã ra tóg krĩg mỹ ẽvãnh kỹ ka kri ti vég mũ. Kỹ tóg ti mỹ: “Zaqueu',” he mũ. “Kur kãtére to fũrũn ké. Isỹ ã ĩn krẽm nũr ke vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kỹ tóg tére tỹ mrãnh ke mũ sir. Jesus mỹ tóg: “mũ jé ha,” he mũ. Ti mỹ tóg sér tĩ, Jesus tỹ ti ĩn krẽm nũr sór kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hã ra vẽnh e ẽn tóg Jesus to vĩ mũ sir, ti to jũ kỹ. “Topẽ vĩ mranh tĩ vẽ, ẽn ti, hã ra tóg ti ĩn krẽm nũr sór mũ, vẽnh jykre pãno han tĩ ẽn mré,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kỹ Jesus tóg ti ĩn krẽm nĩ nĩ. Kỹ Zaqueu vỹ ti mỹ vẽnh kãmén kãtĩ mũ, ã jykre to jykrén kỹ. Kỹ tóg ẽg Senhor mỹ: “ha vé,” he mũ. “Isũ kuju vin jé sóg ke mũ, ũn jagtar ag mỹ. Ũ ag lograr he ja sóg nĩgtĩ, ag tũ ki, hã ra sóg ag mỹ ti kãfór nĩm sór mũ ha. Sỹ jãnkamy pir ki ũ lograr he jan ki sóg ti mỹ ũ tỹ 4 (ke) vin sór mũ,” he tóg, Zaqueu ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kỹ Jesus tóg ti mỹ: “há ti nĩ,” he mũ. “Ũri ã tóg kren mũ, ã mré ke fag mré hã,” he tóg. “Abraão kósin vỹ tỹ ã nĩ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“Tỹ sóg ẽprã ke fi kósin nĩ. Ũn vãfor mũ ẽn jãvãnh jé sóg kãtĩg, sỹ ag krenkren han jé, ũn jykre pãno han mũ ẽn,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hã ra ag tóg ti vĩ mẽ há han mũ, kỹ tóg ag mỹ Topẽ tỹ tỹ ẽg pã'i nĩnh ke ti kãmén sór mũ. Jerusalém to hã tóg nĩ, hã kỹ ag tóg ti to: “Topẽ tỹ tỹ ẽg pã'i nĩ hỹn vẽnh ven ke mũ, ti tỹ tá jun kỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kỹ Jesus tóg ag mỹ kãmén mũ, Topẽ tỹ tỹ ẽg pã'i nĩnh ke tỹ ver vẽnh ven ke tũ nĩ. Kỹ tóg tag tó mũ, ha mẽ. “Kejẽn pã'i tóg nĩgtĩ,” he tóg. “Ẽn tóg ga ũ ra tĩg sór mũ, tá ã tũ ve jé, ga ẽn tá ã tũ han jé. Tag han kar tóg tá vỹn ke sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pã'i ẽn vỹ ã camarada tỹ 10 (ke) ag jé prẽr mũ, kỹ tóg ag mỹ jãnkamy prestar he mũ sir. Ag kar mỹ tóg ti kãmur pir nĩm mũ, jãnkamy tỹ, ũ tỹ 10 (ke) ag mỹ. Kỹ tóg ag mỹ: “ha inh mỹ tỹ rãnhrãj,” he mũ. “Kejẽn sóg vỹn kenh ke mũ, kỹ sóg tugnỹm ke mũ, ãjag rãnhrãj ti,” he tóg. Kar tóg tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hã ra ti krẽm ke ũ ag vỹ ti to há tũ nỹtĩ, kỹ ag tóg ti nón vẽnh vĩ jẽnẽg mũ. Kỹ ag tóg: “ã tỹ ẽg kri tỹ pã'i nĩn kỹ tóg vẽnhmỹ nĩ,” he mũ, “ẽg tỹ tag ve jãvãnh tóg tĩ,” he ja ag tóg nĩgtĩ, ag tỹ ti mỹ vẽnh vĩ jẽnẽg mũn kã. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Hã ra tóg tỹ pã'i nĩn kỹ kẽjẽn vỹn ke mũ, ga ẽn ve kar kỹ, tá ti rãnhrãj han kãn kar. Kỹ tóg tỹ pã'i mág jẽ. Vỹn ke kỹ tóg ã camarada ag jé prẽr mũ sir, ti tỹ ũn mỹ jãnkamy vin ja ẽn ag. Ti tỹ ag rãnhrãj tugnỹm sór vẽ, ag ganho ve sór vẽ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kỹ ũ tóg ti tá jun kỹ ti mỹ: “pã'i',” he mũ. “Ti kãmur pir nĩm ã tóg mỹr. Hã ra sóg kri ũ tỹ 10 (ke) ganhar ké,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kỹ ti patrão tóg ã camarada mỹ: “jykre há tãvĩ ã tóg nĩ,” he mũ. “Nén sĩ ki rĩr há han ã tóg, hã kỹ ã tóg cidade tỹ 10 (ke) ki rĩr mũ ha,” he tóg, pã'i ti, ã camarada mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kỹ ũ tóg ti tá jun mũ gé. Kỹ tóg ti mỹ: “pã'i',” he mũ gé. “Ti kãmur pir nĩm ã tóg mỹr. Hã ra sóg kri ũ tỹ 5 (ke) ganhar ké,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kỹ ti patrão tóg ti mỹ: “cidade tỹ 5 (ke) ki rĩr jé ã tóg ke mũ ha,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kỹ ũ tóg tá jun mũ gé. Kỹ tóg ti mỹ: “pã'i',” he mũ gé. “Ha vé, ã tũ ti,” he tóg. “Inh krĩ pãgja ki sóg tógfĩn kỹ nĩm han. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ã kamẽg ja inh nĩ, ã vĩ tar to. Ã tỹ nén vin ja tũ ẽn mãn sór ã tóg tĩ, ã tỹ nén krãn ja tũ kunũnh sór ã tóg tĩ,” he tóg, ti camarada ti, pã'i ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kỹ ti patrão tóg ti mỹ: “ã vĩ tóg ã jykre pãno han mũ, ha mẽ,” he mũ. “Inh mỹ vĩ tar han tĩ'? Inh mỹ sỹ nén vin ja tũ mãn sór tĩ'? Inh mỹ sỹ nén krãn ja tũ kunũnh sór tĩ'? Hã ki kanhró ã mỹ nĩ'? ");
INSERT INTO kgpNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kỹ ã tỹ ne jé inh jãnkamy tỹ banco ki rãnhrãj tĩ ag mỹ vin ja tũ nĩ nẽ? Ã tỹ ag mỹ vin mũ ra sóg ti juro venh mũ vẽ, kỹ sóg isũ kãfór mãn ke mũ vẽ,” he tóg, ti patrão ti, ã camarada mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kỹ tóg tá nỹtĩ ag mỹ: “ti nĩgã ti tũ mã,” he mũ. “Ũ tỹ ti kãmur tỹ 10 (ke) mãn ja ẽn mỹ nĩm, ti tũ pir ti,” he tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kỹ ag tóg ti mỹ: “pã'i',” he mũ. “Ti kãmur tỹ 10 (ke) vỹ tỹ ti tũ nỹtĩ. Tũ mág ve ti huri,” he ag tóg, pã'i mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kỹ tóg: “hỹ,” he mũ. “Hã kỹ sóg tó mũ. Ũn tũ mág vỹ mãn mãn ke mũ. Ũ tỹ tũ sĩ nĩ ẽn tũ kunũnh kãn jé ag tóg ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Kỹ inh kato tẽ mũ ag pére kãmũmnĩ, ũ tỹ iso: “ti tỹ ẽg kri tỹ pã'i jẽn kỹ tóg ẽg mỹ kórég nĩ,” he mũ ẽn ag. Ag kãgtén ra, inh rĩnve,” he tóg, pã'i ti,” he tóg, Jesus ti. Ti tỹ ẽg tỹ ti rãnhrãj ki rĩr há han ke kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tag tó kãn kỹ tóg tá kãkutẽ mũ sir, kỹ tóg cidade tỹ Jerusalém ra tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ti tỹ Jerusalém ra tĩg kỹ tóg ẽmã tỹ Betfagé to hã jun mũ, ẽmã tỹ Betânia tá, pãnónh tỹ Oliveiras he mũ ẽn tá. Tá jun kỹ tóg ã mré mũ tĩ régre ag jẽnẽg mũ, ag tỹ ti mỹ ag mẽg tỹ burrica ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hã kỹ tóg ag mỹ: “ẽmã ẽn ra mũmnĩ, ẽg jo ẽmã ẽn ra,” he mũ. “Tá junjun kỹ ãjag tóg burrica fi kósin venh mũ. Kri nĩ ja tũ ja tóg jẽ ver. Ẽn kavãn kỹ ti pére kãmũmnĩ, ti kyvãn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Hẽn ri ke mũn ag tóg ãjag mỹ: “ãjag tỹ ne jé ti kavãn nẽ?” henh mũ. Kỹ ag mỹ: “ẽg Senhor vỹ ti ve sór mũ,” hemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kỹ ag tóg mũ mũ, Jesus tỹ ag jẽgnẽn kỹ. Ti tỹ ag mỹ tó mũ ve kãn ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kỹ ag tóg ti kyvãg mũ. Kỹ ti tỹ tỹ ũn mẽg mũ ag tóg ag mỹ vĩ mũ. “Ãjag tỹ ne jé burrica kósin tag kavãn nẽ?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kỹ ag tóg: “ẽg Senhor vỹ ti ve sór mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kỹ ag tóg Jesus mỹ ti pére kãmũ mũ. Ãjag kur kugjén ag tóg mũ sir ti kri. Kỹ Jesus tóg kri nĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kỹ tóg tĩ mũ. Kỹ ag tóg ãjag kur kugjén mũ sir, ẽpry jagma, ẽmĩn jagma. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ge kỹ ag tóg Jerusalém to hã junjun mũ sir, pãnónh tỹ Oliveiras to re kỹ. Ag tỹ pãnónh ẽn to re kỹ vãhã ag kar ẽn tóg Topẽ mỹ vĩ há han mũ sir, Jesus mré mũ kar ẽn ag. Ag mỹ tóg sér tĩ. Jesus tỹ nén han mũ ve ja ag tóg nĩgtĩ, ti tỹ nén han vãnh hyn han mũ ti. Ẽn mĩ ẽkrén kỹ ag tóg Topẽ mỹ vĩ há han mũ, jamã hár(a). ");
INSERT INTO kgpNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kỹ ag tóg: “!..sér tóg tĩ ẽg mỹ..!” he mũ. “!..Ẽg Senhor vỹ ẽg ki jun..., ẽg jóg mág tỹ ti jẽnẽn kỹ..!” he ag tóg. “!..Kanhkã tá ke ag tóg jatu nỹtĩ..! Topẽ mỹ ẽg tóg vĩ há han sór mũ, kynhmỹ nĩ ẽn mỹ..!” he ag tóg, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Hã ra Fariseu ũ ag tóg tá nỹtĩ gé, vẽnh e ẽn kãmĩ. Kỹ ag tóg Jesus mỹ: “Senhor',” he mũ. “Ã mré mũ tĩ ag mỹ: “prẽnprẽr tũg ra,” hé,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Hã ra Jesus tóg ag mỹ: “vó,” he mũ. “Ha mẽ, ag prẽnprẽr tũ nĩ ra pó hỹn prẽnprẽr mũ vẽ, ag mỹ sinsér mũ vẽ,” he tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ge kỹ ag tóg cidade tá junjun mũ sir. Cidade ẽn ve kỹ tóg to fỹ mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Jerusalém tá ke ag vỹ ki kanhrãnrãn sór tũ nỹtĩ,” he tóg. “Ag tỹ ũri ki kanhrãnrãn há tóg tĩ vẽ, hã ra ag tóg ke jãvãnh nỹtĩ. Ãjag tỹ ki kanhrãnrãn' he mũ ra ãjag tóg jatu kenh ke mũ vẽ, mỹr, ha mẽ, hã ra ãjag tóg jẽmẽ sór tũ nĩ. Kutu ãjag tóg nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Hã kỹ ãjag tóg vãhã kurã kórég pẽ venh ke mũ. Ãjag kato tẽgtẽ mũ ag vỹ ãjag to ráránh ke mũ. Kũm'kũm ke jé ag tóg ke mũ, ãjag cidade jy ró pénĩn. Komẽr hã ag tóg ãjag to grẽngrẽn kenh ke mũ, kỹ ag tóg ãjag mãn vỹrỹn kenh ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ãjag tỹ tũg' he kãn jé ag tóg ke mũ, ãjag krẽ ke gé. Ãjag ĩn kókén kãn jé ag tóg ke mũ gé. Kỹ ĩn tỹ pó pi(jé) jagnẽ kri nỹtĩnh mũ'. Kurã há ki ãjag tóg Topẽ vĩ mẽ jãvãnh nỹtĩ, ũri. Topẽ vỹ ũri ãjag mỹ vĩ há han mũ ver, hã ra ãjag tóg mẽ jãvãnh nỹtĩ. Hã kỹ ãjag tóg ti kórég venh ke mũ,” he tóg, Jesus ti. Fỹ pẽ han kỹ tóg tó mũ, cidade mĩ tĩg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kỹ tóg Topẽ jo ĩn tá jun kỹ kãra rã mũ sir. Kỹ tóg ũ tỹ tá nén ũ vender he tĩ ag pan mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ag mỹ tóg tag tó mũ, ha mẽ. “Topẽ vĩ rá to jykrén nĩ,” he tóg. “Tag vỹ rán kỹ nĩ, ha mẽ. Inh ĩn jiji vỹ tỹ Topẽ mré vĩ jafã nĩ, he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki. Hã ra ãjag tóg Topẽ mré vĩ jafã tag krẽm nén kar pigju mũgtĩ, kỹ tóg bandido ag jamã ri ke nĩ sir,” he tóg, Jesus ti. Ag pan kỹ tóg ag mỹ tó mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hã ki tóg kurã kar ki ag kanhrãnrãn mũ, Topẽ jo ĩn krẽm. Hã ra Topẽ tũ ki rĩr tĩ to pã'i ag mỹ tóg kórég nĩ, Topẽ vĩ rán tĩ ag mỹ ke gé, pã'i kar ag mỹ. Hã kỹ ag tóg ti tén ke to jykrén mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hã ra tóg ag mỹ ki króm sór tũ nĩ. Vẽnh kar mỹ tóg mẽ sér tĩ, ti vĩ ti, hã kỹ pã'i ag tỹ ti tén sór mũ ra tóg vẽnhmỹ tĩ sir ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kurã kar ki Jesus tóg Topẽ vĩ tó jẽ nĩ, vẽnh vĩ sér ẽn, Topẽ jo ĩn krẽm. Kỹ tóg kejẽn tá jẽ nĩ. Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag tóg ti to kãmũ mũ, Topẽ vĩ to professor ag ke gé, kófa ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ti mỹ ag tóg: “ẽg tỹ ã ki jẽmẽnh há tóg tĩ,” he mũ. Kỹ tóg ag mỹ: “hej,” he mũ. Kỹ ag tóg: “ã vẽnh jykre tỹ ne tỹ tag han mũ'?” he mũ. “Ũ nỹ ã jẽnẽ?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kỹ tóg ag mỹ: “ãjag ki sóg jẽmẽnh ke mũ gé, vẽnh kato,” he mũ. “Ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","João vỹ ag kygpég tĩ ja nĩgtĩ. Kỹ ti mỹ kanhkã tá vẽnh jykre han mũ', ẽprã jykre vó?” he tóg. “Ũ nỹ ti jẽnẽ?” he tóg. “Inh mỹ tó,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kỹ ag tóg jagnẽ mré to jykrén mũ sir. “Ẽg tỹ ti mỹ: “Topẽ tỹ ti jẽnẽ vẽ,” hen kỹ tóg ẽg mỹ: “ãjag tỹ ne jé ti vĩ kri fig tũ ja nĩ nẽ?” henh ke mũ,” he ag tóg jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Ẽg tỹ hã ra ti mỹ: “ẽprã ke jykre ja vẽ,” hen kỹ vẽnh kar vỹ ẽg pin sór ke mũ, pó tỹ, ha vemnĩ. João to ag tóg: “Topẽ vĩ tó tĩ pẽ ja vẽ,” he tĩ, hã kỹ ag tóg ẽg to jũnh ke mũ, ẽg tỹ: “hã tũ vẽ,” hen kỹ,” he ag tóg mũ jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","“Topẽ jykre han ja ti nĩ,” he sór tũ ag nỹtĩ, kỹ ag tóg: “ẽprã ke jykre han ja ti nĩ,” he sór tũ nỹtĩ gé. Hã kỹ ag tóg Jesus mỹ: “ẽg pi(jé) ki kanhró nỹtĩ',” he mũ, João jykre to. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kỹ Jesus tóg ag mỹ: “kỹ sóg ãjag mỹ ũ tỹ inh jẽnẽg mũ ẽn tónh ke tũ nĩ gé,” he mũ. Ã kato tẽ mũ ag mỹ tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kỹ tóg vẽnh kar kanhrãnrãn kỹ ag mỹ: “ẽg tỹ Topẽ kato tẽ kỹ tóg ge nỹnh mũ, ha mẽ,” he mũ. “Kejẽn ũ tóg nĩgtĩ. Uva krãn ja tóg nĩ, nén kanẽ tỹ vinho han jafã ẽn. Kỹ tóg ũ tỹ ki rĩr tĩ ag mré to jykrén kỹ ag mỹ tovãnh mũ sir. Ag mỹ tovãnh kỹ tóg ga ũ ra tĩ mũ. Hã ra tóg kãtĩg vãnh han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ti uva kanẽn kỹ tóg ag mỹ ã camarada jẽnẽg mũ, ũ tỹ ki rĩr tĩ ag mỹ, ag tỹ ti mỹ ti tũ nĩm jé, ẽkré kanẽ ẽn ti. Hã ra ag tóg ti mỹ vin tũg mũ. Ti mrãnmrãn ag tóg mũ. Kỹ ag tóg ti mỹ: “ha tĩg,” he mũ. Nén ũ tũ ra tóg tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kỹ tóg ã camarada ũ jẽnẽg mũ gé sir. Hã ra ag tóg ti mrãnmrãn mũ gé. Ti mỹ féfén kar kỹ ag tóg ti mỹ: “ha tĩg,” he mũ gé sir. Nén ũ tũ ra tóg tĩg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kỹ tóg ag mỹ ũ jẽnẽ mãn mũ gé sir, hã ra ag tóg ti mrãnmrãn kỹ ti rãnh kỹ ti tĩn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kỹ uva kré tỹ ũn tũn mũ tóg to jykrén mũ. “Inh hỹn hẽn ri kenh ha,” he tóg, to jykren kỹ. “Inh kósin jẽnẽ jé sóg ke mũ, inh fe pẽ ẽn, hẽn ri ke mũn ag ti kamẽg mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ti kósin tỹ ag tá jun kỹ nén kré ki rĩr tĩ ag tóg ti vég mũ. Kỹ ag tóg ti to jykrén mũ, jagnẽ mré. “Kejẽn ẽkré tag vỹ tỹ ti tũ nỹnh mũ,” he ag tóg. “Mũ nỹ, ti tén jé, ti tũ tag tỹ tỹ ẽg tũ nỹnh jé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kỹ ag tóg ró mã ra ti pére mũ kỹ tá ti tén mũ sir. Kỹn hỹn hẽ ri kenh ke mũ', ẽkré tỹ ũn tũn mũ ẽn ti'?” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Kãtĩg jé tóg ke mũ, ẽkré ki rĩr tĩ ag kãgtén jé. Kỹ tóg camarada ũ ag mỹ finh mũ sir, ã jakré ti,” he tóg, Jesus ti. Kỹ ag tóg mẽg mũ, ti vĩ ti, ti pénĩn nỹtĩ ẽn ag. Kỹ tóg ag mỹ e tĩ. “Ẽg jé tag venh ke tũ nĩ,” he ag tóg mũ, ũ tỹ Jesus vĩ mẽg mũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Hã ra Jesus tóg ag ki ẽvãnh kỹ ag mỹ: “Topẽ vĩ rá tag to jykrén nĩ, ha mẽ,” he mũ. “Pó tỹ ĩn han jafã fón ag tóg, pó tỹ ĩn han tĩ ag. Ag mỹ tóg kórég ja nĩ, pó ẽn ti. Hã ra Topẽ tóg pó ẽn hã tỹ ĩn nũna han mũ,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki,” he tóg, Jesus ti. Ti tỹ ã kato vãsãnsãn mũ ag mỹ vẽnh kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kỹ tóg ag mỹ: “ũ tỹ hẽn ri ke ag vỹ pó tag kri vár ke mũ, kỹ ag tóg kri vár kỹ tũ' henh ke mũ,” he mũ. “Kỹ pó tag vỹ ũ tỹ hẽn ri ke ag kri kutẽnh ke mũ gé, kỹ tóg ag tỹ nám nám ke kãn mũ sir, ag kri kutẽ kỹ,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki,” he tóg, Jesus ti. Ti tỹ ag tỹ ti ki rã tũ tugrĩn nũgme ki vár ke tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kỹ Topẽ vĩ to professor ag vỹ ti vĩ mẽg mũ, Topẽ tũ ki rĩr tĩ to pã'i ag ke gé. Ag hã to tóg kãmén ja nĩ, “ẽg tỹ Topẽ kato vãsãn tag vỹ ge nỹnh mũ,” he mũ ẽn ti. Kỹ ag tóg ki kanhró nỹtĩ sir, hã kỹ ag tóg ti se sór mũ. Hã ra ag tóg ũn e ẽn kamẽg mũ. Ti vĩ vỹ vẽnh kar mỹ mẽ há tĩ, hã kỹ pã'i ag tóg ti ség tũ nĩ ver, ag tỹ ti se sór mũ (hã) ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kỹ ag tóg hã ra ti tugnỹm mũ. Ti vĩ to ag tóg vãjig mũ, ag tỹ ti vĩ to fóg tỹ pã'i mỹ ti fẽg jé. Ag tỹ ti vĩ tugnĩn fóg tỹ pã'i mág mỹ: “ha ti vóg kónãn,” he sór vẽ. Hã je ag tóg ũn jykre kuryj nỹ ve ag jẽgnẽg mũ, ag tỹ ón kỹ Jesus ki jẽmẽ jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kỹ ẽn ag tóg sir Jesus mỹ: “Senhor',” he mũ. “Vẽnh jykre kuryj hã tó ã tóg tĩ, hã kãmén ã tóg tĩ. Hã kỹ ẽprã ke ag ve tóg ã mỹ tỹ nén ũ tũ nĩ. Hã kỹ ã tóg Topẽ japry to, Topẽ jamĩn to ẽg kanhrãn há han tĩ,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","“Kỹn mỹ há nỹ, ẽg tỹ fóg tỹ pã'i mág tỹ imperador mỹ jãnkamy ẽn nĩm ti, imposto kajãm jé? Ẽg mỹ hỹn nĩm mũ', nĩm ke tũ nĩ vó?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Hã ra Jesus tóg ki kanhró nĩ, ag jykre régre ti. Hã kỹ tóg ag mỹ: “ãjag ne tóg ón kỹ inh ki jẽmẽ sór mũ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Inh mỹ jãnkamy ven. Ũ jiji nỹ kã nĩ? Ũ kãggrá nỹ kã nĩ?” he tóg. Kỹ ag tóg ti mỹ: “pã'i mág kãggrá vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kỹ tóg ag mỹ: “kỹ pã'i mág mỹ ti tũ nĩm, jo Topẽ mỹ ti tũ nĩm gé,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hã kỹ tóg ag tỹ ti vĩ to ti senh ke tóg tũ tĩ, ti vĩ há han kỹ. Kỹ tóg ag mỹ e tĩ, ti vĩ há tãvĩ ẽn ti. Kỹ ag tóg ti mỹ vĩ mãn tũ nĩ sir. Hã ra vẽnh kar vỹ ti vĩ mẽg nỹtĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kỹ Saduceu ag tóg ti tá junjun mũ gé, ti ki jẽmẽ jé. Hã ra Saduceu ag tóg: “ẽg ter ja tá ẽg tóg vỹn ke mãn ke tũ nĩ, rĩr mãn ke tũ ẽg tóg nĩ,” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ẽn ag vỹ Jesus ki jẽmẽ sór mũ gé, ón kỹ. Kỹ ag tóg ti mỹ: “Senhor',” he mũ gé. “Moisés vỹ ẽg mỹ vẽnh jykre tag nĩm, hã vỹ: ã régre tỹ ã krẽ tũ ra ter kỹ ã tỹ ti prũ fi tỹ prũg ke vẽ, he mũ. Ã tỹ ã régre mỹ ã krẽ han ke vẽ, fi ki, he tóg mũ gé. Moisés tỹ ẽg mỹ tó jan hã vẽ,” he ag tóg mũ, Saduceu ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Kỹ ũ tỹ jagnẽ mré pafa ja tỹ 7 (ke) ag vỹ nỹgtĩ. Ag kãke vỹ prũg mũ, hã ra tóg ã kósin tũ ra ter mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kỹ ti jãvy vỹ fi tỹ prũg mũ sir, hã ra tóg ã kósin tũ ra ter mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kỹ ti jãvy ũ tóg fi tỹ prũg mũ gé, hã ra tóg ter mũ gé, ti kósin tũ ra. Gen kỹ ag tóg kãgter kãn mũ kejẽn, ũ tỹ 7 (ke) ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kỹ vãhã ag prũ fi vỹ ter mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kỹ fag kãgter ja tá rĩnrĩr mãn kỹ fi hỹn mén tỹ 7 (ke) nĩnh mũ vẽ. Ag kar vỹ fi tỹ prũg ja nỹtĩgtĩ. Hã kỹ tóg vẽnhmỹ nỹ, ag tỹ: “rĩnrĩr mãn jé ẽg tóg ke mũ,” hen kỹ,” he ag tóg. Saduceu ag tỹ Jesus mỹ ken hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kỹ Jesus tóg ag mỹ kãmén mũ. “Ẽprã ke ag vỹ prũgprũg tĩ, kỹ fag vỹ ag tỹ mén tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ag kãmĩ ũ ag tóg ãjag kãgter ja tá rĩnrĩr mãn ke mũ, ti kurã tá krỹg kỹ. Ẽn ag vỹ prũg mãn ke tũ nĩ sir, mén mãn ke tũ fag tóg nĩ gé sir, ãjag rĩnrĩr mãn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ter mãn ke tũ ag tóg nĩ gé, mỹr, ha mẽ, hã kỹ ag prũg mãn ke tũ nĩ, kỹ fag mén mãn ke tũ nĩ gé. Kanhkã tãn ri ke ag nỹtĩ, Topẽ tỹ jẽgnẽ jafã ag ri ke mỹr, ũn rĩnrĩr mãn mũ ag. Topẽ krẽ vỹ tỹ ag nỹtĩ sir, ag tỹ ãjag kãgter tá rĩnrĩr mãn ken kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Rĩnrĩr mãn jé ag tóg ke mũ, ũn kãgter mũ ag, ha vemnĩ. Hã kỹ Moisés tóg Topẽ to tag tó ja nĩ, ha mẽ. Ti tỹ vãnh pũr nĩ ẽn tá ti mré vẽmén kar kỹ tóg Topẽ to: “Abraão tỹ ũn to: Topẽ, he mũ ẽn vẽ, Isaque tỹ ũn to: Topẽ, he mũ ẽn, Jacó tỹ ũn to: Topẽ, he mũ ẽn,” he ja nĩ, Moisés ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kãgter ag huri, Abraão, Isaque, Jacó, hã ra Moisés tóg Topẽ to: “Abraão tỹ ũn to: Topẽ, he mũ ẽn vẽ,” he ja nĩ. Ti tỹ tỹ ag Topẽ nĩn kỹ ag tóg rĩnrĩr nỹtĩ, ha mẽ, ag kãgter mũ ra. Ũn kãgter kar ag vỹ Topẽ mỹ rĩnrĩr nỹtĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kỹ ũ tỹ Topẽ vĩ rán tĩ ũ ag tóg ẽg Senhor tỹ Jesus mỹ: “vĩ há han ã, ẽg ter ja tá vỹn kenh ke mũ tag to,” he mũ, ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kỹ ũ tóg ti ki jẽmẽ mãn sór tũ nĩ sir. Ti kamẽgmẽg ag tóg mũ, hã kỹ ag tóg ti ki jẽmẽ mãn sór tũ nĩ ha. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kỹ Jesus tóg ag ki jẽmẽg mũ gé sir. Kỹ tóg ag mỹ: “Topẽ vĩ rán tĩ ag ne tóg: “Cristo vỹ tỹ Davi kósin nĩ,” he tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","“Hã ra Davi tóg Cristo tó ja nĩ, ti tỹ Topẽ jé rán kỹ. Kỹ tóg: “ẽg jóg mág tỹ Topẽ vỹ inh Senhor mỹ tag tó ja nĩ, ha mẽ: “nĩ ra ver, inh pẽgja tá,” he ja ti nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“Isỹ ã kato vãsãnsãn mũ ag tỹ ã krẽm vin ke vẽ, kỹ ag sigse ri ke vẽ sir. Tag jãvãnh nĩ ver,” he ja ti nĩ, Topẽ ti,” he ja tóg nĩgtĩ, Davi ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Hã kỹ Davi tóg Cristo to: “inh Senhor,” he ja nĩ. Kỹ ti kósin mỹ tỹ ti kri ke nĩ'?” he tóg mũ, Jesus ti. Hã ra ag tóg ti mỹ tó tũg mũ. Ag tỹ ne tónh ke tóg tũ tĩ, ti kato tẽgtẽ mũ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Vẽnh kar tóg mẽg mũ, Jesus vĩ ti. Kỹ tóg ã mré mũ tĩ ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ón kỹ Topẽ vĩ to professor ag kamẽg nĩ,” he mũ. “Kur téj rĩnh ka(mẽ) ag nỹtĩ,” he tóg. “Kỹ vẽnh kar tỹ ag mỹ: “ã mỹ há?” hen kỹ tóg ag mỹ sér tĩ, ag tỹ cidade kuju kãmĩ mũn kỹ. Vẽnh kanhrãn jafã krẽm ag tóg vẽnh kãpãm kỹ nỹtĩgtĩ. Festa ki ag tóg jẽn vén tĩ, ag tỹ tỹ pã'i nỹtĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Hã ra ag tóg ũn mén ter ja fag tũ mãn kãn tĩ. Fag tũ mãn kãn kỹ ag tóg ón kỹ Topẽ mré vĩ mág han mũgtĩ, ẽg tỹ ag to: “ũn há vỹ tỹ ag nỹtĩ,” he jé. Hã to ag vẽsỹrénh mág tãvĩ han ke mũ,” he tóg, Jesus ti. Ti tỹ ũ tỹ ón kỹ Topẽ to há nỹtĩ ag kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kỹ Jesus tóg Topẽ jo ĩn tá jẽ kỹ tãmĩ ẽvãnh kỹ ũn rico ag vigvég mũ. Jãnkamy vin jafã ki ag tóg ãjag tũ vin tĩ, Topẽ mỹ, jãnkamy ti. Vin mág ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kỹ ũn mén ter ja fi vỹ tá jun mũ gé sir. Tỹ nén ũ tũ fi tóg nĩ, hã ra fi tóg jãnkamy kãsir régre vin mũ, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kỹ Jesus tóg fi to: “ve ra ha,” he mũ. “Ũn rico tỹ vin kãfór han fi tóg, fi tũ sĩ (hã) ra. Tỹ nén ũ tũ fi tóg nĩ, fi mén vỹ hur ter. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kỹ fi tóg ã tũ vin kãn ja nĩ, fi jẽn mré hã. Jãvo ũn rico ag vỹ ãjag tũ ke hã tỹ Topẽ mỹ vin mág tĩ. Hã ki fi tóg ag tỹ nĩm kãfór han, fi tỹ nĩm sĩ pẽ han mũ ra. Ki hã sóg tó mũ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ẽn kã ũ ag tóg Topẽ jo ĩn to vĩ há han mũ. “Sĩnvĩ pẽ ti jẽ,” he ag tóg mũ. “Ti pó ve ra ha, mág ti nỹtĩ. Ti sĩnvĩ han jafã vỹ e nỹtĩ gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Kỹ Jesus tóg ke mũ. “Mỹ ãjag mỹ sĩ?” he tóg. “Kejẽn tóg kókén kãn kỹ nỹnh mũ, ha vemnĩ, kỹ pó vỹ jagnẽ kri nỹtĩ mãn ke tũ nĩ ha. Gũm ke kãn jé tóg ke mũ, tag ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kỹ ag tóg ẽg Senhor ti mỹ: “kurã tỹ ne kã ke nẽ hỹn'?” he mũ. “Ẽg hỹn hẽn ri ken kỹ ti kurã ki kanhró nỹtĩnh mũ hỹn'? Topẽ hỹn ne han ke mũ, ẽg tỹ kurã ẽn ki kanhró nỹtĩ jé?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kỹ tóg ag mỹ: “ker ũ vĩ jẽmẽ hẽ',” he mũ. “Ũ tỹ hẽn ri ke ag vỹ inh jiji tó kãmũnh mũ. “Cristo vỹ tỹ inh nĩ,” he jé ag tóg ke mũ. “Inh kurã vỹ hur jun,” he jé ag tóg ke mũ. Ag nón mũ tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Vẽnh génh mẽgmẽ jé ãjag tóg ke mũ, jagnẽ kato vãsãnsãn mũ ag. Kamẽg tũg nĩ hã ra. Vẽnh génh tỹ hẽn ri ke han jé ag tóg ke mũ, kurã tỹ ẽgno to hã. Ti kurã kã ke pijé',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kỹ tóg ag mỹ: “povo ag tỹ jagnẽ kato vãsãnsãn ke vẽ, pã'i krẽm ke ag tỹ pã'i ũ krẽm ke ag to jũnh ke vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","“Ga tỹ ragrag ke jagy tỹ hẽn ri ke han ke vẽ gé, ẽn kã. Kỹ vẽjẽn tóg tũ' henh ke mũ gé. Vẽnh kaga kórég (ka)mẽ vỹ vẽnh vinven ke mũ, ẽn kã sir. Nén ũ vẽnhmỹ vỹ vẽnh vinven ke mũ gé, kanhkã tá, kỹ vẽnh kar vỹ kanẽ junjur ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Tag to hã ag tóg ãjag sigsenh ke mũ gé, ãjag vóg kónãn jé ag tóg ke mũ gé, vẽnh kanhrãn jafã krẽm ag tóg ãjag jykre vigvenh ke mũ gé, vẽnh se ja kãki ag tóg ãjag vin ke mũ gé. Pã'i mág tỹ rei ag mỹ ag tóg ãjag venven ke mũ, pã'i tỹ governador ag mỹ ke gé, ãjag tỹ inh jyjy tó ja tugnĩn. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ãjag tỹ inh vĩ tó jé, hã jé ag tóg ãjag tỹ genh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ẽn kã ãjag tỹ nén ũ tónh ke to jykrén tũg nĩ, to krĩ kufy han tũg nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Inh hã vỹ ãjag vĩ han ke mũ, inh jykre nĩm jé sóg ke mũ ãjag mỹ, ãjag tỹ ag mỹ tón jé,” he tóg. “Kỹ ag tỹ ãjag vĩ kafãn sór mũ ra tóg ag mỹ vẽnhmỹ tĩnh mũ, ha vemnĩ, ãjag kato tẽgtẽ mũ ag mỹ. Ag tỹ ne tónh ke tóg tũ tĩnh mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ẽn kã ãjag han mũ ẽn vỹ ãjag senh mũ, ãjag mré pafa mũ ag ke gé, ãjag mré ke ag ke gé, ãjag to há kar ag mỹr,” he tóg. “Ãjag kãmĩ ũ ag kãgtén jé ag tóg ke mũ gé, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Vẽnh kar vỹ ãjag to kórég tãvĩ nỹtĩnh mũ, inh jiji tugrĩn. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hã ra ãjag véké vẽsỹrénh ke tũ nĩ, ãjag gãnh pir vỹ fagrĩnh mỹ kutẽnh ke tũ nĩ, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","To tar nỹtĩmnĩ, ãjag vẽsỹrénh ke to, kỹ ãjag tóg rĩr krỹg ja tũ ẽn venh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kejẽn ag tóg Jerusalém jy nỹtĩnh mũ, soldado ag, ag tỹ cidade ẽn kókén jé. Ãjag tỹ tag ve kỹ ãjag tóg ki kanhró nỹtĩnh mũ. Ag tỹ ti kókén kãn ke kurã vỹ jun ke mũ, kurã ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kỹ vẽnh pigju mũmnĩ, pãnónh ra, ãjag tỹ Judéia ki nỹtĩn kỹ. Ãjag tỹ cidade mág tá nỹtĩn kỹ pétigtẽmnĩ, vãnh kãra. Ãjag tỹ vãnh kãmĩ ẽmã kãsir ki nỹtĩn kỹ cidade ra mũ tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Topẽ tỹ ag vóg kónãn ke kurã vẽ sir, ag jykre kórég to, hã kỹ tóg vãsỹ rán kỹ nĩ. Vẽnh rá ẽn ve jé ãjag tóg ke mũ, kurã ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kỹ ũn kufy fag vỹ vẽsỹrénh mág ke mũ, kurã ẽn kã, gĩr pygfãm mũ fag ke gé. Ẽprã ke ag vẽsỹrénh mág tãvĩ han ke vẽ, Topẽ tỹ povo tag to jũ jagy han ke vẽ, kurã ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ãjag kãmĩ ũn e tãvĩ kãgter ke vẽ, rógro tỹ. Kỹ ãjag kãmĩ ũ ag vỹ sigse kỹ mũnh mũ, povo kar kãmĩ. Kỹ Jerusalém vỹ kókén kãn kỹ nĩnh ke mũ. Fóg ag vỹ sãnsãn ke mũ, ãjag cidade mág ti. Kejẽn fóg ag tỹ tũ' henh ke kurã vỹ jun ke mũ gé hã ra,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kurã ẽn kã rã vẽnhmỹn ke vẽ, kysã ti ke gé, krĩg ti ke gé. Kỹ ga kri mũ ag vỹ kamẽgmẽg kãn ke mũ. Kanẽ junjur mág jé ag tóg ke mũ, povo kar ẽn ag. Kỹ goj vỹ krém ke mũ, goj kafã tũ vỹ jũnh ke mũ, ti kurã jun kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kỹ ẽprã ke ag fe vỹ vo kónãn ke mũ, ag tỹ jũrũn ke vỹ ag kãgtén ke mũ, ag tỹ ãjag tỹ nén venh ke to jũrũn ken kỹ. Ẽg tỹ kanhkã tá nén vég tũ kar ẽn vỹ ragrag ke kãn mũ mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kỹ vãhã vẽnh kar vỹ ti kãtĩg ẽn venh ke mũ, ẽprã ke fi kósin ẽn ti. Kanhkã góg kãmĩ sóg kãtĩg ke mũ vãhã sir. Inh ve vỹ tar nĩnh mũ, inh kãtĩg mãn kỹ. Kókov kãtĩg jé sóg ke mũ vãhã sir,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Ãjag tỹ isỹ ãjag mỹ nén tó mũ ẽn ve sĩ han kỹ ãjag kanẽ nĩm nĩ, ãjag krĩ ti ke gé, ti tỹ ãjag mỹ sér gy tĩn kỹ. Isỹ ãjag krenkren han ken vẽ ha, isỹ kurã ẽn hã kã jun kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kỹ tóg ag mỹ: “inh kãtĩg mãn ke vỹ ge nỹnh mũ, ha mẽ,” he mũ. “Ka tỹ figueira to ki kanhrãn nĩ, ka ũ to ke gé, to comparação han kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","“Ti pẽ tánh kỹ, ti féj tãg han kỹ tóg kakó tĩ sir, ẽkré tygtánh kurã ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ẽn ri ke ti nĩ, ãjag tỹ inh kãtĩg mãn ke kurã ki kanhró nỹtĩ ti. Ãjag tỹ sỹ ãjag mỹ nén tó ja ẽn ve kỹ tóg kakó tãvĩ tĩ ha, inh kãtĩg ke ti,” he tóg. “Ẽn kã Topẽ tỹ tỹ ẽg pã'i nĩ kenh ke vẽ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sỹ ke há vẽ, hã kỹ sóg tag tó mũ, ha mẽ. Ũ tỹ nén kar ẽn vég mũ ag vỹ inh kãtĩg mãn ke tag venh ke mũ, ũri, ag kãgter ke to hã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","“Kanhkã vỹ tũ' he mũ, ga ti ke gé. Jãvo inh vĩ vỹ tũ' henh ke tũ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Vẽnh ki ẽmẽ, ãjag tỹ vẽjẽn e to nug kaga tũ nĩ jé, tógá nĩnh to, ãjag tỹ kronkron to krĩ vẽnhmỹ tũ nĩ jé gé. Kỹ vẽjẽn to krĩ kufy han tũg nĩ gé, kur to, tag ki nén ũ kar to. Ke tũ nĩ mũ ra kurã ẽn vỹ ãjag vatánh tá jun ke mũ, inh kãtĩg mãn ke kurã ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ãjag tỹ to vẽnh kãn kỹ nỹtĩ tũ nĩn kỹ tóg ãjag mỹ sẽsĩ tỹ ẽgje ki kutẽ ri ke nĩ. Vẽnh vatánh tá tóg ki kutẽ tĩ, jẽsĩ ti. Ge ti nĩnh mũ, inh kãtĩg mãn ke ti, ga kri mũ ag kar mỹ. Ag vatánh tá sóg jun ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Hã kỹ ãjag kanẽ nĩm nĩ, nũr sór tũg nĩ. Inh kãtĩg kã jatu to ken hã vẽ, hã vỹ: nũr, he mũ. Topẽ mrẽ vĩ tovãnh tũg nĩ, ãjag tar nỹtĩ jé, nén ũ jagy ẽn ve kỹ. Kỹ ãjag tóg ẽprã ke fi kósin rĩnja tá jẽnh ke mũ sir, mỹ'ãg tũ nĩn kỹ, isỹ vẽnh kar jykre tugnỹm kurã ẽn kã,” he tóg, Jesus ti. Ti tỹ ag mỹ kurã tỹ ẽgno kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hã ki tóg kurã kar ki Topẽ jo ĩn krẽm ag kanhrãnrãn tĩ, Jesus ti. Kutyg kỹ tóg cidade tá kãkutẽ kỹ pãnónh ra tĩ tĩ, tá nũr jé. To ag tóg: Oliveiras, he tĩ, pãnónh ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ti tỹ kusã ki Topẽ jo ĩn tá jun kỹ ag tóg tá ti vĩ jẽmẽnh kãmũ tĩ, ũ tỹ hẽn ri ke ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ẽn kã festa tóg kakó tĩ sir. Festa ẽn ki ag tóg pão ũ ko tĩ, hã ra tóg jãgja tũ ja nĩgtĩ. Festa ẽn jijin hã vỹ: Páscoa, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kỹ Topẽ tũ ki rĩr tĩ to pã'i ag vỹ Jesus to jykrén mũ. Ag tỹ ti tén sór vẽ. Topẽ vĩ to professor ag vỹ ti tén sór mũ gé. Hã ra ag tóg povo kamẽg mũ, kỹ ag tóg to jykrén kỹ nỹtĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ẽn kã Judas ẽn, ũ tỹ Iscariotes he mũ ẽn vỹ jagrẽ vég mũ sir, Satanás tỹ. Hã ra tóg tỹ ũ tỹ 12 (ke) ag kã ũ nĩ, Jesus tỹ ũn vin mũ ag kã ũ vỹ tỹ ti nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ti tỹ Satanás tỹ jagrẽ nĩn kỹ tóg Topẽ tũ ki rĩr tĩ to pã'i ag venh tĩ mũ sir, soldado to pã'i ag ke gé. Ti tỹ ag mỹ Jesus ven sór vẽ, ag tỹ ti se jé. Kỹ tóg tá jun kỹ ag mỹ tó mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Kỹ tóg ag mỹ sér pẽ tĩ sir. Kỹ ag tóg ti mỹ jãnkamy tó mũ. Ag tỹ ti mỹ vin sór vẽ, ti tỹ ag mỹ Jesus ven kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Kỹ tóg ag mỹ: “hej,” he mũ sir. Kỹ tóg to jykrén mũ, ti tỹ ã mỹ ki króm ke to, ag mỹ: “ha ti kãgmĩ ha,” he jé, Judas ti. Ag tỹ vẽnh kar vatánh tá ti se sór vẽ. Hã kỹ Judas tóg ti tó sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kỹ tóg pão jãgja tũ ẽn konh ke kurã tá krỹg mũ sir. Kurã ẽn ki ag tóg mé tãg tãnh tĩ, ovelha tãg ẽn, ag tỹ kurã tỹ Páscoa kã ko tĩ ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kỹ Jesus tóg Pedro jẽnẽg mũ sir, João mré. Kỹ tóg ag mỹ: “ha mũjẽg, mé tãnh jé, ovelha ẽn, ẽg tỹ kon jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Kỹ ag tóg ti mỹ: “ẽg hẽ tá ti tãnh mũ hỹn'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kỹ tóg ag mỹ: “ha vé,” he mũ. “Ẽmã mág tag ra mũjẽg. Tá ãjag tóg ũ venh mũ. Goj vyn kỹ tóg tĩ mũ. Ẽn nón mũmnĩ. Kỹ ti ĩn tá junjun kỹ ti nón gemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kỹ ĩn ki rĩr tĩ mỹ: “ẽg Senhor vỹ ã mỹ vẽnh vĩ jẽnẽg mũ,” hemnĩ. “Inh hỹn hẽ tá ovelha konh ke mũ, inh mré mũ tĩ ag mré?” he ti, ẽg Senhor ti,” hemnĩ. “Mỹ ki vẽnh kánkán jafã tũ?” hemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kỹ tóg ãjag mỹ ven ke mũ sir, kroggrog tỹ kynhmỹ nỹ ẽn ti, assoalho tỹ kynhmỹ nỹ ẽn ti. Éhé ti nĩ, kỹ mesa to nỹtĩ jafã vỹ tá nỹtĩ gé. Ẽn tá ti kãn nĩ ẽg mỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kỹ ag tóg mũ mũ sir. Jesus tỹ ag mỹ tó ja ẽn ve kãn ag tóg mũ, kỹ ag tóg mé tãnh mũ sir, tá. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kỹ tóg ag tỹ konh ke hora tá krỹg mũ sir. Kỹ Jesus tóg tá nĩ nĩ, ti tỹ ũn vin ja ag mré hã, apóstolo ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kỹ tóg ag mỹ vẽmén mũ sir. “Sỹ ovelha tag konh ha pẽ tóg tĩ vẽ ãjag mré,” he tóg. “Sỹ inh vẽsỹrénh ke to hã ãjag mré ko sór ja vẽ,” he tóg, Jesus ti, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","“Ti ko mãn ke tũ inh nĩ ha, ha vemnĩ. Topẽ tỹ tỹ ẽg pã'i nĩ vỹ vẽnh ven ke mũ. Ti tỹ vẽnh ven ja ẽn kã sóg ko mãn ke mũ, kejẽn,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kỹ tóg copa mãg mũ sir. To tóg Topẽ mré vĩ mũ, kỹ tóg ag mỹ: “ha kron,” he mũ. “Ha vẽnh kãpãm,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","“Tag kron mãn ke tũ inh nĩ ha, ke gé, ha vemnĩ. Topẽ tỹ tỹ ẽg pã'i nĩnh ken kỹ sóg kejẽn kron mãn ke mũ, ha vemnĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kỹ tóg ẽmĩ mãg mũ sir. To tóg Topẽ mré vĩ mũ. Kupãn kỹ tóg ag mỹ vẽnh pipin mũ. Kỹ tóg ag mỹ: “inh hã vẽ,” he mũ. “Ãjag jagfy sóg vẽnh fẽg ke mũ. Kỹ inh mĩ ẽkrén nĩ, ãjag tỹ pão tag konh ken kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ag tỹ ko kar kỹ tóg copa mãg mũ gé. Kỹ tóg ag mỹ: “copa ki jẽ tag vỹ inh kyvénh ri ke nĩ,” he mũ. “Ãjag jagfy tóg inh ki kãkutẽnh mũ, inh kyvénh ti. Inh jykre tãg to ken hã vẽ, isỹ inh kyvénh tugrĩn ãjag mỹ vẽnh pãte fón jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Hã ra ãjag kãmĩ ũ tóg inh vatánh tá isónh ke mũ, inh kato tẽ ag mỹ. Inh mré tóg mesa tag to nĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tĩg jé sóg ke mũ, sỹ tỹ ẽprã ke fi kósin nĩn kỹ. Vãsỹ Topẽ tóg to jykrén ja nĩ, hã kỹ sóg tĩ mũ. Hã ra ũ tỹ isónh ke ẽn mỹ tóg vĩ kónãn tãvĩ han ke mũ, Topẽ ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kỹ ag tóg jagnẽ mỹ ke mũ. “Ẽg kãmĩ ũ tỹ hẽ nẽ hỹn'?” he ag tóg mũ sir jagnẽ mỹ, ũ tỹ ti tónh ke ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ẽn kã ag tóg jagnẽ kãfór nĩ sór mũ. Hã kỹ ag tóg jagnẽ to jũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kỹ Jesus tóg ag mỹ ke mũ. “Fóg ag pã'i ag vỹ ãjag krẽm ke ag mỹ vĩ tar han tĩ, kỹ ag tóg ag kri ke ag mỹ: “ẽg jóg,” he tĩ, ag tỹ ag mỹ vĩ tar han mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ag ri ke han tũg nĩ. Ãjag mỹ tỹ ũn mág nỹtĩ sór mũ'? Kỹ tỹ ũn kãsir ri ke nỹtĩmnĩ jagnẽ mré,” he tóg, Jesus ti. “Ũ tỹ inh jykre ki tỹ pã'i nĩn kỹ tóg ã krẽm ke ag camarada ri ke nĩnh ke mũ, ag ki rĩr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kejẽn ẽg tóg mesa to nỹtĩ, kỹ ũ tóg mesa ki rĩr tĩgtĩ. Ũ tỹ hẽ nỹ hỹn mesa ki rĩr tĩ'? Ag patrão mỹ', ti camarada mỹ vó? Ti camarada vỹ ki rĩr tĩgtĩ. Jo sóg ãjag ki rĩr tĩgtĩ, ãjag camarada ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ãjag hã ne inh mré mũgtĩ'. Isovãnh ja tũ pẽ ãjag tóg nỹtĩ. Isỹ nén ũ jagy vég mũ ẽn ve kãn ãjag tóg tĩ, inh mré. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Inh panh vỹ isỹ pã'i han ke mũ, kỹ sóg ãjag tỹ pã'i han ke mũ gé, ti tỹ isỹ pã'i han kóm, ");
INSERT INTO kgpNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ãjag tỹ inh mré jẽn jé tá, inh mré kron jé tá, isỹ tỹ pã'i nĩn kỹ. Kỹ ãjag tóg ãjag nĩgja kri nĩgnĩ kỹ nỹtĩnh mũ, ãjag tỹ povo tỹ Israel ag jykre vigve jé, povo tỹ 12 (ke) ẽn ag,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kỹ ẽg Senhor vỹ Pedro mỹ: “Simão', Simão',” he mũ. “Ha vé, Satanás vỹ ãjag to vĩ, Topẽ mỹ. Ti tỹ ãjag jykre ve sór vẽ. Trigo tỹ ẽg tóg gren ki kãkag tĩ, ẽg tỹ ti fár pan jé. Ẽn ri ke han jé tóg ke mũ, ãjag tỹ, Satanás ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Hã ra sóg hur ã jagfy vĩ, ã tỹ inh ki rã tovãnh pẽ han tũ nĩ jé. Kỹ ã tóg kejẽn ã jykre to jykrén mãn ke mũ, ã tỹ inh jykre hã han jé. Ẽn kã ã tóg ã mré ke ag jyvẽn kỹ ag tỹ tar' he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hã ra Pedro tóg ti mỹ: “Senhor',” he mũ. “Ã mré sóg se kỹ jẽnh mũ, ã mré sóg ter ke mũ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hã ra Jesus tóg Pedro mỹ: “vó,” he mũ. “Ha vé, ũri ã tóg iso: “ti ki kagtĩg sóg nĩ,” he tãgtũ han ke mũ, galo kyr to hã, ha vemnĩ,” he tóg mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kỹ tóg ag kar mỹ: “ãjag jẽgnẽ ja inh nĩ, vãsỹ,” he mũ. “Kỹ ãjag tóg nén ũ ma mũ ja tũ nĩgtĩ, saco tũ, bolsa tũ, pẽn né tũ, pẽn to ró ẽn. Ẽn kã ãjag mỹ jagãgtar ja nỹtĩgtĩ'?” he tóg. Kỹ ag tóg ti mỹ: “vó,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kỹ tóg ag mỹ: “hã ra tóg ũri ke tũ nĩgtĩ,” he mũ. “Hã kỹ ãjag jãnkamy ma mũjẽg, ãjag sacon ma mũjẽg, ãjag bolsa ma mũjẽg. Ãjag tỹ nén ũ tũ nỹtĩn kỹ ãjag kur vender hemnĩ, rógro kajãm jé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nén ũ tóg iso rán kỹ nĩ, hã vỹ: ag mỹ tóg tỹ ũn jykre pãno nĩ, he mũ. Sỹ vãhã tag venh ke vẽ ha. Isỹ iso nén rán kỹ nĩ ẽn ve kãn ke vẽ ha, vãhã,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kỹ ag tóg ti mỹ: “Senhor',” he mũ. “Rógro régre vỹ ki nỹtĩ,” he ag tóg mũ. Hã ra tóg ag mỹ: “gen kỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kỹ tóg ã tỹ tĩ jafã ra tĩ mũ sir, hã vỹ: pãnónh tỹ Oliveira, he mũ ẽn ra. Ti mré mũ tĩ ag vỹ ti nón mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tá jun kỹ tóg ag mỹ: “Topẽ mré vĩ, ãjag tỹ ti vĩ mranh tũ nĩ jé, ãjag tỹ nén ũ jagy ve kỹ,” he mũ, Jesus ti, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kỹ tóg tĩg sĩ han mũ, kỹ tóg ã jakrĩ tỹ jẽg mũ. Kỹ tóg Topẽ mré vĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kỹ tóg: “panh',” he mũ. “Mỹ ã tỹ inh vẽsỹrenh ke tag tỹ tũ' he mũ jãvãnh? Hã ra isỹ ã mỹ nén to vĩ mũ tag han tũg nĩ. Ã tỹ nén han ke mũ ẽn hã han nĩ,” he tóg, Jesus ti, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kỹ Topẽ tỹ jẽnẽ jafã ũ vỹ ti mỹ vẽnh ven mũ sir, kanhkã tá, kỹ tóg ti tar han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hã ra tóg ã ter ke to kanẽ jur mũ, kỹ tóg Topẽ mré vĩ mãn', vĩ mãn', he mũ. Kỹ ti kãrãn vỹ kyvénh nĩ sir, kỹ tóg ga kri vẽnh kugjẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kỹ tóg Topẽ mré vĩ kar ã mré mũ tĩ ag to kãtĩ mũ. Hã ra ag tóg nũgnũr nỹtĩ nĩ. Krónh' krónh' he ja ag tóg nĩ, ag fe kaj tugrĩn. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kỹ tóg ag mỹ: “ãjag ne tóg nũgnũr nỹtĩ nĩ',” he mũ. “Nĩgnĩ ra, Topẽ mré vĩ, ãjag tỹ ti vĩ mranh tũ nĩ jé, ãjag tỹ nén ũ jagy ve kỹ,” he tóg, ti mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ti tỹ ver tỹ vẽmén jẽ ra ag tóg junjun mũ sir, Judas mré hã, ũ tỹ 12 (ke) ag kã ũ ẽn ti. Ti tỹ ag tatĩn kãtĩg hã vẽ, ũ tỹ ti senh ke mũ ag. Ũ tỹ ag jo tĩ mũ ẽn tóg sir Jesus to grẽn ke kỹ ti ki nhun ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kỹ Jesus tóg ti mỹ: “Judas',” he mũ. “Ã ne tóg inh ki nhun ke kỹ iso: “ti hã vẽ,” he mũ', inh kato tẽ ag mỹ, inh, hã vỹ: ẽprã ke fi kósin, he mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kỹ ti mré mũ ag tóg ag tỹ ti senh ke vég mũ. Kỹ ag tóg ti mỹ: “Senhor',” he mũ. “Ẽg mỹ rógro tỹ ag fynh ke tũ'?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kỹ ag kã ũ tóg polícia ũ fynh mũ, ti nĩgrẽg tỹ rãm ke tóg mũ, ti pẽgja tá. Topẽ tũ ki rĩr tĩ to pã'i krẽm ke ũ vẽ, polícia ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hã ra Jesus tóg ag mỹ: “ag vóg tũg ra, há ti nĩ,” he mũ. Kỹ tóg ti nĩgrẽg mãn kỹ to tỹ grẽn ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kỹ Jesus vỹ pã'i ag mré vẽmén mũ, Topẽ tũ ki rĩr tĩ to pã'i ag mré, Topẽ jo ĩn ki rĩr tĩ to pã'i ag mré ke gé, kófa ag mré ke gé. Ag kar vỹ ti se kãmũ mũ. Kỹ tóg ag mỹ: “ãjag ne tóg rógro génh kỹ iso kãmũ mũ', ka kyv génh kỹ ke gé,” he mũ. “Inh pi(jé) tỹ bandido nĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","“Kurã kar ki sóg Topẽ jo ĩn krẽm ãjag mré nĩ ja nĩgtĩ, hã ra ãjag tóg tá ise sór ja tũ nĩ, ãjag tỹ ag kamẽg kỹ,” he tóg. “Hã ra tóg ũri jun, ãjag kurã ti, Japo tỹ ã tỹ nén han sór tĩ ẽn han jé, ãjag tỹ. Jykre ki kuty ti nĩ, Japo ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kỹ ag tóg ti ség mũ sir. Ag tỹ ti pére mũ kỹ ag tóg Topẽ tũ ki rĩr tĩ to pã'i mág ĩn tá junjun mũ sir. Hã ra Pedro vỹ kuvar há tá ag nón tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ĩn vãso tá ag tóg pĩ grug mũ, soldado ag, kỹ ag tóg tugtón nỹtĩ nĩ. Kỹ Pedro vỹ ag mré tón nĩ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kỹ pã'i camarada ũ fi vỹ tá ti vég mũ, pĩ grun ki. Kỹ fi tóg ti tugnỹm mũ. Kỹ fi tóg ag mỹ: “ti mré tĩ ũ vẽ inh mỹ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Hã ra Pedro tóg: “vó,” he mũ. “Ti ki kagtĩg sóg nĩ, jỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kar kỹ ũ tóg ti tugnỹm mũ gé, kỹ tóg ti mỹ: “ag kã ũ vỹ tỹ ã nĩ,” he mũ. Hã ra Pedro tóg ti mỹ: “inh hã tũ vẽ, vỹ,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tag kar kỹ, hora pir tũg kỹ hẽn ri ke mũn ũ tóg ti tugnỹm mũ gé. Kỹ tóg tá nỹtĩ ag mỹ: “ha vé, Galiléia tá ke vỹ tỹ ti nĩ,” he mũ. “Inh mỹ tóg tỹ ti mré ke nĩ,” he tóg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hã ra Pedro tóg ti mỹ: “inh pi(jé) ti ki kanhró nĩ, vỹ',” he mũ. “Ã tỹ ne tó nẽ?” he tóg mũ sir. Ti tỹ ver tó nĩ ra galo vỹ kyr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kỹ ẽg Senhor vỹ vẽsỹjãm ẽvãnh kỹ Pedro tugnỹm mũ. Kỹ Pedro vỹ to jykrén mũ sir, ẽg Senhor tỹ ti mỹ nén tó ja to, hã vỹ: “iso ã tóg: “ti ki kagtĩg sóg nĩ,” he tãgtũ han ke mũ, galo kyr to hã,” he ja ẽn mĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kỹ Pedro vỹ tá kãkutẽ mũ, kỹ tóg fỹ mág han mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kỹ ũ tỹ Jesus ség mũ ag vỹ ti to é he mũ sir. Ti tãnh ag tóg mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ti kanẽ pãg kỹ ag tóg ti kakã ki tãnh kỹ ti mỹ: “ũ nỹ ã tãnh?” he mũ. “Ã tỹ nén kar ki kanhró nĩn kỹ ã hỹn ki kanhró nĩ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Gen kỹ ag tóg ti mỹ vĩ kónãn tỹ hẽn ri ke han mũ, ti to é he kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tỹ vaj kỹ kófa kar ag tóg vẽnh mãn mũ, Topẽ tũ ki rĩr tĩ to pã'i ag mré hã, Topẽ vĩ to professor ag mré hã. Ag vẽnh mãn kỹ ag tóg ti jé prẽr kỹ ag rĩnja tá ti fẽg mũ sir, ag tỹ ón kỹ ti jykre ve jé. Ag tỹ ti tén sór vẽ, hã ra ag tóg ón kỹ ti jykre ve vén sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Hã kỹ ag tóg ti mỹ: “ã mỹ tỹ Cristo nĩ?” he mũ. “Ha ẽg mỹ tó,” he ag tóg. Kỹ tóg ag mỹ: “ãjag pi(jé) inh vĩ kri fig tĩ', isỹ ãjag mỹ tó tĩ (hã) ra',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","“Isỹ ãjag ki jẽmẽ sór mũ ra ãjag tóg inh mỹ tó tũ nĩ gé. Kỹ ãjag tóg isovãnh tũ nĩ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","“Hã kỹ ẽprã ke fi kósin vỹ Topẽ pẽgja tá nĩnh ke mũ ha. Topẽ vỹ tar nĩ. Sỹ ti pẽgja tá nĩnh ken vẽ ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kỹ ag tóg ti mỹ ke kãn mũ. “Kỹ ã mỹ tỹ Topẽ kósin nĩ?” he ag tóg mũ ti mỹ. Kỹ tóg ag mỹ: “ki hã ãjag tóg tó mũ,” he mũ. “Inh hã vẽ,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kỹ ag tóg: “ti kato vĩ ũ jẽmẽ mãn ke tũ ẽg nĩ ha,” he mũ, jagnẽ mỹ. “Ti jẽnky ki kutẽ mẽ ẽg tóg huri. Topẽ to vĩ kónãn ti huri. Ti ter ke vẽ,” he ag tóg mũ sir, pã'i ag, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Hã ra tá ke kar ag vỹ Jesus pére mũ mũ, fóg tỹ pã'i tỹ Pilatos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tá ag tóg ti kato vĩ mũ sir, kỹ ag tóg Pilatos mỹ: “vẽnh kar krĩn kónãn han tóg tĩ, ag tỹ vẽnh jykre há tovãnh jé,” he mũ. “Kỹ tóg ag mỹ: “pã'i mág tỹ imperador mỹ imposto nĩm tũg nĩ,” he tĩ gé. Kỹ tóg vẽso: “tỹ inh Cristo nĩ, pã'i mág tỹ rei ti,” he tĩ gé,” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kỹ Pilatos tóg ti mỹ: “ã mỹ tỹ Judeu ag pã'i tỹ rei nĩ'?” he mũ. Kỹ tóg ti mỹ: “ki hã ã tóg tó mũ,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kỹ Pilatos vỹ ag mỹ kãmén mũ, Topẽ tũ ki rĩr tĩ to pã'i ag mỹ, povo kar mỹ ke gé, kỹ tóg: “ti tỹ nén ũ kórég han ja vég tũ sóg nĩ, ti ki,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Hã ra ag tóg ti tovãnh jãvãnh pẽ nỹtĩ. Kỹ ag tóg ti mỹ: “hã ra tóg vẽnh kar krĩ rỹg tĩgtĩ,” he mũ. “Ga tỹ Judéia kar mĩ tóg tĩg ja nĩ, ga tỹ Galiléia mĩ ke gé, tag mĩ ke gé. Tĩg kỹ tóg vẽnh kar krĩn kónãn tĩ,” he ag tóg ti mỹ, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kỹ Pilatos vỹ ga tỹ Galiléia tag to jykrén mũ, kỹ tóg: “ti mỹ tỹ Galiléia tá ke nĩ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Kỹ ag tóg ti mỹ: “hỹ,” he mũ. Hã ra Herodes vỹ tỹ ga tỹ Galiléia tá pã'i mág nĩ. Hã kỹ Pilatos tóg ti hã mỹ ti jẽnẽg mũ. Ẽn kã tóg Jerusalém tá nĩ gé, Herodes ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kỹ tóg Herodes tá jun mũ sir. Ti tỹ ti ve kỹ tóg ti mỹ sér tĩ. Ti tỹ ti ve sór ja vẽ. Ti kãme mẽ ja tóg nĩ, hã kỹ tóg ti ve sór ja nĩgtĩ, Herodes ti. “Hẽn ri ke mũn tóg nén ũ han vãnh han ke mũ, sỹ ve jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jesus tỹ ti ki jun kỹ Herodes tóg ti ki jẽmẽ sór mũ, nén tỹ hẽn ri ke ki, hã ra tóg ti mỹ vĩ tũg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hã ra pã'i ag vỹ tá nỹtĩ nĩ, kỹ ag tóg ti kato vĩ mág han mũ sir, Topẽ vĩ to professor ag ke gé. Hã ra Jesus tóg ag mỹ vĩ tũg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kỹ Herodes vỹ ti to é he mũ gé, ti mré ke kar ag ke gé, kỹ ag tóg ti nyg mũ sir. Kur kupri pẽ tỹ tóg ti kri fón mũ, ón kỹ. Kỹ tóg Pilatos mỹ ti jẽnẽ mãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kurã ẽn kã Pilatos vỹ Herodes mỹ vĩ há han mũ. Jagnẽ to há' he mãn ag tóg mũ ha. Ag tỹ Jesus ve jo ag tóg jagnẽ kato tẽ ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kỹ Pilatos vỹ Topẽ tũ ki rĩr tĩ to pã'i ag jé prẽr mũ sir, pã'i kar ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kar tóg ag mỹ: “ãjag ne inh mỹ ti fẽg',” he mũ, “kỹ ãjag ne ti to: “vẽnh kar krĩn kónãn tóg tĩ,” he mũ'. Ãjag rĩnve sóg ti ki jẽmẽ huri, hã ra sóg ve ja tũ nĩ, ãjag tỹ ti to nén tó ja ti. Nén ũ kórég han ja tũ tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kỹ Herodes vỹ vég tũ nĩ gé. Sỹ ti mỹ ti jẽnẽ ja vẽ, ãjag ke gé. Hã ra tóg inh mỹ ti jẽnẽ mãn mũ gé. Ẽg hẽ ri ken kỹ ti tén mũ hỹn'? Sỹ ki kagtĩg tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Hã kỹ sóg ti mrãnmrãn kar ti tovãnh ke mũ,” he tóg, Pilatos ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Festa tỹ Páscoa ki tóg ag mỹ vẽse pir tovãnh tĩ, prỹg kar ki. Ti jykren hã vẽ. Hã kỹ tóg: “Jesus tovãnh jé sóg ke mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Hã ra vẽnh kar ag tóg vãhã prẽnprẽr mũ sir. “!..Ti tén ra..!” he ag tóg mũ. “!..Barrabás tovãnh ra..!” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás vỹ vẽnh génh to se kỹ jẽ nĩ. Cidade tá tóg vẽnh génh han ja nĩgtĩ, ẽn kã tóg ũ tén ja nĩgtĩ, hã to tóg se kỹ jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kỹ Pilatos vỹ ag mỹ vĩ mãn mũ. Ti tỹ Jesus tovãnh sór vẽ, hã kỹ tóg ag mỹ vĩ mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hã ra ag tóg prẽnprẽr kỹ: “!..cruz to ti sã, cruz to ti sã..!” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kỹ tóg ag mỹ vĩ tãgtũ han mũ gé, Pilatos ti. “Ti kórég tỹ ne han ti? Sỹ vég tũ tóg tĩ. Ti tỹ ne to ter ke nẽ? Sỹ ki kagtĩg tóg tĩ. Hã kỹ sóg ti mrãnmrãn kar kỹ ti tovãnh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hã ra ag tóg prẽnprẽr tãvĩ han mũ sir, hã kỹ ag tóg ti kutãn mũ. Ti mỹ ag tóg: “!..cruz to ti sã..!” he tãvĩ han mũ. Kỹ tóg ag prẽnprẽr to ag mỹ han sór mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","To tóg jykrén mũ, kỹ tóg ag mỹ: “hej,” he mũ, ag tỹ ti kutãn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kỹ tóg ũ ẽn tovãnh mũ sir, ũ tỹ vẽnh génh to se kỹ jẽ ẽn ti, ũ tỹ ũ tén ja ẽn ti. Ag tỹ ũ to vĩ mũ ẽn tovãnh tóg mũ sir. Kỹ tóg ag mỹ Jesus ti fẽg mũ sir, ag tỹ ti ki han sór mũ ẽn han jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kỹ ag tóg ti pére mũ mũ, cruz to ti sa jé. Ag mũn kỹ ag tóg ũ kãtĩg vég mũ. Ẽpỹ tá tóg kãtĩ mũ, ti jijin hã vỹ: Cirene tá Simão, he mũ. Ti kri ag tóg Jesus cruz ti fig mũ, ti tỹ ti jo va tĩg jé, ti nón. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kỹ ũ tỹ hẽn ri ke ag vỹ Jesus nón mũ mũ, ũn tỹtá fag ke gé. Ẽn fag vỹ vẽsỹrénh mũ, kygfỹ mág han fag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hã ra Jesus tóg vẽsỹjãm ẽvãnh kỹ fag mỹ vĩ mũ. “Jerusalém tá ke',” he tóg. “Ijé kygfỹ tũg nĩ,” he tóg. “Vẽnh jé kygfỹmnĩ, ãjag krẽ jé kygfỹmnĩ,” he tóg fag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","“Ha vé, kurã kórég pẽ vỹ jun ke mũ ãjag mỹ. Ẽn kã ag tóg tag tónh ke mũ, ha mẽ: “ũn kurĩ fag mỹn pãgsĩ nĩnh mũ, fag tỹ ãjag krẽ ter vég tũ nĩn kỹ. Ũn krẽ tũ fag mỹn pãgsĩ nĩnh mũ, ũ tỹ gĩr pafãm tũ fag mỹ ke gé,” he jé ag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ẽn kã ag tóg pãnónh mỹ: “inh kri tỹ tam ké,” henh ke mũ gé, kỹ ag tóg sór mỹ: “inh péju ra, vẽnh krẽm,” henh ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ẽg kato tẽ ag tỹ ka tánh gỹn kỹ ag hỹn ka tóg tovãnh ke tũ pẽ nĩ. Ka tánh ẽn ri ke sóg nĩ, jo ãjag vỹ ka tóg ri ke nỹtĩ. Hã kỹ ãjag tóg inh vẽsỹrénh kãfór venh ke mũ, ha vemnĩ,” he tóg, Jesus ti. Jerusalém fĩn rãm kỹ tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ag tỹ Jesus pére mũn kỹ ag tóg ũn régre ag pére mũ mũ gé, ũn jykre pãno ag. Ag tỹ ka to ag sanh ke vẽ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kỹ ag tóg pãnónh tá junjun mũ sir, ti jyjyn hã vỹ: Krĩ Kuka, he mũ. Tá ag tóg cruz to ti sãg mũ sir. Ũn jykre pãno tỹ ag tóg cruz to sãg mũ gé, ti kóm, kỹ ũ vỹ ti pẽgja tá sa, jo ũ vỹ ti jakãnh tá sa. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kỹ Jesus vỹ: “panh',” he mũ. “Ag mỹ vẽnh pãte fón nĩ,” he tóg. “Ag pi(jé) ki kanhró nỹtĩ', ag tỹ nén han mũ tag ti',” he tóg. Kỹ soldado ag tóg ti kur tỹ jagnẽ mỹ tỹ vẽnh ken jé to jogar he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kỹ vẽnh e ag vỹ tá vég nỹtĩ. Hã ra pã'i ag tóg ti nyg mũ. Kỹ ag tóg jagnẽ mỹ: “ũ ag krenkren han ja tóg nĩgtĩ,” he mũ. “Cristo jé vẽnh kren han, Topẽ tỹ ti fẽg ja nĩn kỹ, ti tỹ ti kuprẽg ja nĩn kỹ, hã ra tóg vẽnh kren han ki kagtĩg nĩ,” he ag tóg mũ, Jesus to é he kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Kỹ soldado ag vỹ ti nyg mũ gé. Ti rã hã nỹtĩn kỹ ag tóg ti mỹ vinagre ven mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kỹ ag tóg: “ã mỹ tỹ Judeu ag pã'i mág nĩ'?” he mũ. “Vẽnh kren han ra, ã tỹ tỹ pã'i nĩn kỹ,” he ag tóg mũ ti mỹ, ti to é he kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hã ra ag tóg rán ja nĩ gé, ti tỹ cruz to sa kỹ jẽ ẽn ti. Ti to rán hã vẽ, hã vỹ: “Judeu ag pã'i mág tỹ rei hã vẽ,” he mũ. Ti kri tóg cruz to sa gé, ẽn rá ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kỹ ti kóm cruz to sa ũ tóg ti mỹ vĩ mũ gé, ũn jykre pãno ẽn. Ti to tóg é he mũ gé. Kỹ tóg ti mỹ: “ã mỹ tỹ Cristo nĩ?” he mũ. “Vẽnh kren han ra, kỹ ẽg krenkren han gé,” he tóg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hã ra ti kóm cruz to sa ũ ũ tóg ti mỹ vĩ jũ han mũ, ũ tỹ Jesus mỹ vĩ kónãn mũ ẽn mỹ. Kỹ tóg ti mỹ: “kỹ ã mỹ Topẽ kamẽg tũ?” he mũ. “Vẽsỹrénh ã tóg mũ gé, ti kóm. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ẽg tỹ ẽg tỹ nén han ja kajãm vẽ jãvo, ẽg jykre pãno to ẽg vẽsỹrénh nỹtĩ nĩ. Ẽg jãvo tóg jykre kuryj nĩ. Ti pi(jé) nén ũ kórég han ja nĩ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kỹ tóg Jesus mỹ: “Senhor',” he mũ. “Inh ki ẽkrén nĩ, ã tỹ tỹ pã'i ki rãn kỹ,” he tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kỹ Jesus tóg ti mỹ: “ha mẽ, ũri ã tóg inh mré nĩnh mũ, ẽmã há ẽn tá, Paraíso he mũ ẽn tá, kanhkã tá. Ki hã sóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kejẽn rã tóg ẽg nĩno kã sa mũ sir. Hã ra tóg kuty' he mũ sir, ga kar mĩ hã. Kuty ẽn tóg hora tãgtũ han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kỹ rã vỹ nhyn ke mũ sir. Topẽ jo ĩn krẽm kur tỹ jãnkã mág pẽ vỹ kã sa nĩ. Ẽn vỹ jaran ke mũ. Kuju mĩ tóg jaran ke kãtére mũ sir, fĩn rãm kãn tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kỹ Jesus vỹ prẽr mág pẽ han mũ. Kỹ tóg: “!..panh'..!” he mũ. “!..Sỹ ã mỹ vẽnh fẽg vẽ, inh kuprĩg ti..!” he tóg. Tag tó kar tóg hun ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Hã ra fóg tỹ capitão tóg ti ter vég mũ. Kỹ tóg Topẽ mỹ vĩ há han mũ. “Vẽnh vĩ há ja vẽ, ũn há ja vẽ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kỹ vẽnh e ẽn vỹ ti ter vég mũ gé. Kỹ ag tóg ãjag tỹ nén han ja to jykrén mũ sir. Vãhã tóg ag mỹ e tĩ. “Topẽ hỹn ẽg tỹ hẽ ri kenh mũ, ẽg tỹ ti tén kỹ?” he ag tóg mũ sir. Tag tó kỹ ag tóg ãjag ĩn ra vỹnvỹn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hã ra ti to há kar ag vỹ ti vég nỹtĩ nĩ, kakó ki, ũn tãtá fag ke gé. Galiléia tá ke fag tóg ti mré kãmũ ja nĩgtĩ gé. Ti ter ve kãn fag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kỹ ũ tóg tá nĩ gé, vẽnh jyvẽn tĩ ũ, ha mẽ, ti jijin hã vỹ: José, he mũ. Judeu ag tỹ cidade tỹ Arimatéia tá ke ti nĩ. Jykre kuryj tóg nĩ, jykre há. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ti pi(jé) ag tỹ Jesus tén ke to: “hej,” he ja nĩgtĩ', ag tỹ Jesus to jykrén kỹ. Topẽ tỹ tỹ ẽg pã'i nĩnh ke ve sór tóg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ẽn vỹ Pilatos venh tĩ mũ. Kỹ tóg ti mỹ Jesus to vĩ mũ, ti ter kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kỹ tóg cruz to ti kãtérem mũ, kỹ tóg kur há tỹ ti pãg mũ sir. Kỹ tóg pãró nor kãki vẽnh kej kãkã ti fig mũ. Vẽnh kej tãg vẽ, ag pi(jé) kãkã ũ fi ja nĩgtĩ ver'. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hã ra sexta-feira vẽ sir, vẽnhkán ke kurã ki rã tóg nỹ ha, sábado ki. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kỹ ũn tỹtá fag vỹ ag nón mũ mũ, ti kej ve jé, ag tỹ ti finh mũ ja tá. Ti mré Galiléia tá kãmũ ja ẽn fag vẽ, ũ tỹ ti fi han vég mũ fag. ");
INSERT INTO kgpNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ve kar kỹ fag tóg kyrãgrã kỹ nén ger há han mũ sir, ti tãg jafã ti, ti to tĩn jé. Hã ra fag tóg vẽnhkán mũ ver, vẽnhkán ke kurã kã, Topẽ vĩ ki króm jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kỹ semana kurã ve tóg tá krỹg mũ sir. Kỹ fag tóg kusã pẽ ki ti kej tá venh mũ mũ. Vẽser ger há han jafã ẽn ma fag tóg mũ mũ, fag tỹ han ja ẽn ti, ti kej ra mũn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hã ra pó ẽn tỹ ti kej nĩfénh kã nĩ ẽn vỹ kunũnh kỹ nĩ nĩ. Hã vég fag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kỹ fag tóg ti kej tá junjun kỹ ra ge mũ, hã ra fag tóg vég tũ nĩ, vẽser ti, Jesus ti, ẽg Senhor ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kỹ tóg fag fe kaj tĩ sir, fag tỹ ti vég tũ nĩn kỹ. Kỹ vãhã ũn régre ag vỹ kãge mũ, kur kupri rĩnh kỹ, kur kókov, Topẽ tỹ jẽnẽ jafã ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kỹ fag tóg kanẽ junjur mũ sir, kỹ fag tóg ẽprã ẽvãnh mũ. Hã ra ag tóg fag mỹ: “ãjag ne tóg vẽser jãvãnh mũ', ti rĩr ja (hã) ra',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“Ki ti tũ nĩ, rĩr ti jẽ ha. Hã kỹ tóg ãjag mỹ tó ja nĩgtĩ, ãjag tỹ Galiléia tá nỹtĩ ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kỹ tóg ãjag mỹ: “ẽprã ke fi kósin ẽn fẽg jé ag tóg ke mũ, ũ tỹ Topẽ vĩ mranh tĩ ag mỹ,” he ja nĩ. “Ka to ag ti sanh ke mũ, hã ra tóg kurã tãgtũ ki rĩr mãn ke mũ,” he ja tóg nĩgtĩ, Jesus ti, vẽso,” he ag tóg mũ, Topẽ tỹ jẽnẽ jafã ag. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kỹ fag tóg Jesus tỹ nén tó ja ẽn mĩ ẽkrén mãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kỹ fag vỹ ti kej tá kãpa kỹ mũ mũ sir, ũ tỹ 11 (ke) ag mỹ tó jé, ti mré mũ tĩ kar ag mỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Madalena fi vẽ, kar kỹ Joana fi ke gé, Maria ũ fi ke gé, Tiago mỹnh tag fi, ũ fag ke gé, fag mré. Fag hã ne Jesus tỹ ũn vin mũ ag mỹ kãmén mũ, apóstolo ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hã ra tóg ag mỹ tỹ vẽnh ó nỹ ve nĩ, hã kỹ ag tóg kri fi ja tũ nĩgtĩ, fag vĩn kri. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kỹ Pedro vỹ jẽ kỹ ti kej ra vẽnh vãg tĩ mũ. Pãnh ke tóg, kỹ tóg ki ẽvãnh mũ, kỹ tóg ti kur tãvĩ vég mũ sir, ti pãg ja ti. Kỹ tóg ti mỹ e tĩ. Ti tỹ to jykrén tũ tóg tĩ sir. Kỹ tóg tĩg mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kỹ vãhã ag kã ũ ag tóg mũ mũ, kurã ẽn kã, ũn régre ag. Ẽmã sĩ ra ag tóg mũ mũ. Jerusalém tán kakó nĩ, 10 (ke) quilômetros hỹn. Ẽmã ẽn jyjyn hã vỹ: Emaús, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ag mũn kỹ ag tóg jagnẽ mré vẽmén mũ sir, ãjag tỹ nén ve ja kar ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ag tỹ vẽmén nỹtĩ ra, ag tỹ jagnẽ mré tỹ vẽmén mág han nỹtĩ ra Jesus tóg ag tá jun kỹ ag mré tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hã ra ag tóg ti ki kagtĩg mũ, ag tỹ ti vég mũ (hã) ra. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kỹ Jesus tóg ag mỹ: “ãjag tỹ ne tó nẽ?” he mũ. “Vẽmén mág ãjag tóg mũ nĩ,” he tóg. Kỹ ag tóg krỹg he mũ sir, ve ũ han ag tóg mũ, ãjag fe kaj tugnĩn. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kỹ ũ tóg ti mỹ tó mũ. Cleopas he mũ ẽn tóg ti mỹ: “kỹ ã mỹ mẽg tũ?” he mũ. “Ũ tỹ festa venh kãmũ ja ag vỹ mẽ kãn. Ã hã mỹ ã pir mỹ mẽg tũ, ẽg tỹ nén ve ja ti, ã tỹ Jerusalém kã nĩ (hã) ra?” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kỹ tóg ag mỹ: “ne nẽ?” he mũ. Kỹ ag tóg ti mỹ: “Jesus ti,” he mũ. “Nazaré tá ke vẽ. Topẽ vĩ tó tĩ vẽ. Ẽg tỹ nén han vãnh hyn han ja tóg nĩgtĩ. Topẽ vĩ tó há han ja tóg nĩgtĩ, kỹ Topẽ vỹ ti mré han tĩ, milagre kar ti. Kỹ povo kar ag vỹ vég tĩ, kỹ tóg ẽg kar mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kỹ Topẽ tũ ki rĩr tĩ ag vỹ ti fẽg, ẽg pã'i kar ag, fóg tỹ pã'i tỹ ti tén jé, cruz to ti sa jé, hã kỹ tóg tũg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ẽg tỹ ti ve kỹ ẽg tóg ti to: “ti hỹn ẽg povo tỹ Israel ag krenkren han ke mũ,” he mũ vẽ. Hã ra tóg ter ja nĩ. Ũri tóg kurã tãgtũ han, ti ter kri,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Kỹ ẽg kã ũ fag vỹ ẽg mỹ nén ũ tó gé, kỹ tóg ẽg mỹ e tĩ gé. Kusã pẽ ki fag tóg ti kej ra mũjẽg. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Hã ra fag ti vég tũ nĩ, ti tỹ tá nỹ tũ nĩn kỹ. Kỹ fag tóg: “nén nẽ ve ẽg,” he mũ gé. Topẽ tỹ jẽnẽ jafã nẽji, kỹ tóg nẽji fag mỹ: “rĩr ti jẽ nĩ,” hé. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kỹ ẽg kã ũ ag vỹ ra mũ mũ, ti kej ra, kỹ ag tóg vég mũ gé, fag tỹ nén tó ja ti. Hã ra ag tóg ti vég tũ pẽ nĩ,” he ag tóg, Jesus mỹ, ag tỹ ti ki kagtĩg nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kỹ ũ tỹ ag mré tĩ mũ ẽn tóg ag mỹ: “ãjag tỹ ne jé vãsỹ Topẽ vĩ tó tĩ ag vĩ kri fi ja tũ nĩ nẽ?” he mũ. “Krĩ tũ ãjag nỹtĩ, to jykrén há han tũ ãjag tóg nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","“Cristo vẽsỹrénh ke vẽ, vẽsỹrénh kar kỹ tóg tỹ ũn mág nĩnh mũ vãhã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kỹ tóg ag mỹ vẽnh rá kãmén kãn mũ sir, Moisés tỹ rá ti, Topẽ vĩ tó tĩ ag kar tỹ rá ti, ag tỹ Jesus to rán ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ag mỹ kãmén tĩ ki tóg ẽmã ẽn tá jun mũ sir. Ag mré tá jun kỹ tóg mã ra tĩg mũ ve nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kỹ ag tóg ti kógfyn mũ sir, kỹ ag tóg: “ẽg mré nĩ,” he mũ. “Rãké tóg nỹ ha, kutyg ke rã tóg nỹ ha,” he ag tóg mũ sir. Kỹ tóg ag mré kãra rã mũ, ag mré nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kỹ tóg ag mré jẽn ke mũ gé sir. Ag mré jẽn ke kỹ tóg pão mãg mũ, ẽmĩ ti. Kỹ tóg Topẽ mré vĩ mũ, kar tóg kupãn kỹ tỹ vẽnh ken mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kỹ ag tóg ti ki kanhrãn mũ sir vãhã. Ti ve há han ag tóg mũ sir. Hã ra tóg ki tũ nĩ ha, ti ve mãn tũ ag tóg nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kỹ ag tóg jagnẽ mỹ: “ti tỹ ẽg mré vẽmén kỹ tóg ẽg fe ki rã,” he mũ. “Ẽg mỹ tóg ã to rán ja ẽn kãmén kãn, ẽg mũn kỹ. Hã ja vẽ,” he ag tóg mũ jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kỹ ag tóg vẽsỹmér Jerusalém ra vỹnvỹn ke mũ sir. Tá ag tóg ũ tỹ 11 (ke) ag vég mũ, ag mré ke ũ ag mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hã ra ẽn ag tóg ag mỹ: “ẽg Senhor vỹ rĩr mãn,” he vén mũ. “Simão Pedro mỹ tóg vẽnh ven, mỹr, ha mẽ,” he ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kỹ ag tóg ag mỹ: “hỹ, ti ve ẽg ke gé,” he mũ gé. Kỹ ag tóg ag mỹ ãjag tỹ nén ve ja ẽn tó mũ sir, ag tỹ ãjag mũ ki ti ve ja ti, ti tỹ ag mỹ ẽmĩ kupãn ja ti ke gé. “Hã ki ẽg tóg ti ki kanhró nỹtĩ, ẽmĩ kupãn ja ki,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ag tỹ ver tỹ vẽmén nỹtĩ ra Jesus tóg ag mré jẽ mũ vãhã, ti tỹ hẽ tá kãrãnh ke tũ nĩ ra. Kỹ tóg ag mỹ: “mỹ sér nỹtĩmnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hã ra ag tóg jũrũnrũn ke mũ sir. Ti kamẽg ag tóg mũ. “Vẽnh kuprĩg hỹn,” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kỹ tóg ag mỹ: “ãjag ne tóg jũrũnrũn ke mũ',” he mũ. Ãjag tỹ ne jé: “vẽnh kuprĩg hỹn,” he nẽ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Inh nĩgé ve ra, inh pẽn ve ra, inh hã vẽ,” he tóg. “Inh mẽgmẽ ra, ve há han ra. Vẽnh kuprĩg pi(jé) fár nĩ', ti pi(jé) kuka nĩ'. Inh fár ve ra, inh kuka ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Vĩ kỹ tóg ag mỹ ã nĩgé ven mũ, ã pẽn ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hã ra tóg ver ag mỹ e tĩ, ag fe tỹ mrin ke pẽ han kỹ, kỹ tóg ver ag tỹ ki kagtĩg tĩ. Hã kỹ tóg ag mỹ: “mỹ ki vẽjẽn tũ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kỹ ag tóg ti mỹ pirã nĩm mũ, mỹg mré. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Kỹ tóg mãn kỹ ko mũ, ag rĩnve. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kỹ tóg ag mỹ: “hã tó ja inh nĩ, ãjag mỹ, iser to hã, isỹ ãjag mré nĩgnĩn kã,” he mũ. “Vãhã sóg ve kãn ja nĩgtĩ, ag tỹ iso nén rán ja ti, Moisés ti, ti tỹ ãjag mỹ vẽnh jykre nĩm jan ki, kar kỹ Topẽ vĩ tó tĩ ag kar tỹ nén rán ja ki ke gé, Topẽ to jãn ki ke gé. Sỹ nén ven jan hã vẽ,” he tóg, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kỹ tóg ag mỹ kãmén há han mũ sir, hã kỹ ag tóg ti to nén rán ja ki kanhrãn kãn mũ sir, to jykrén há han ag tóg mũ sir, ti tỹ ag nĩgrẽg róm kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kỹ tóg ag mỹ: “tag vỹ rán kỹ nĩ, ha mẽ,” he mũ. “Hã kỹ Cristo vỹ vẽsỹrénh, kỹ tóg rĩr mãn gé, ã ter kar kỹ, kurã tãgtũ tũg kỹ. Tag ve kãn sóg huri,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Kỹ tóg rán kỹ nĩ gé, ũ ag tỹ vẽnh kar mỹ inh kãmén ke ti. Inh jijin tó jé ag tóg ke mũ, ag tỹ vẽnh kar mỹ: “ãjag jykre si tovãnh ra,” henh ken kỹ, ũ tỹ inh vĩ tó tĩ ag. “Tovãnh kỹ Topẽ tóg ãjag mỹ vẽnh pãte fón ke mũ, ãjag tỹ ti vĩ mranh ja ti,” he jé ag tóg ke gé. Povo kar mỹ ag tóg tónh ke mũ, hã ra ag tóg tag ki tó vén ke mũ, Jerusalém ki. Ãjag to ken hã vẽ. Inh kãmén jé ãjag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ve kãn ãjag tóg mỹr, hã kỹ ãjag tóg tónh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ha mẽ, inh panh vỹ ãjag mỹ nén ũ tó ja nĩ, ãjag tỹ venh ken jé. Ẽn jẽnẽ jé sóg ke mũ ãjag mỹ. Hã kỹ tag ki nỹtĩmnĩ ver, cidade tỹ Jerusalém tag ki. Hẽn ra mũ tũg nĩ. Vãhã ãjag tóg venh ke mũ, inh panh tỹ ãjag mỹ ũn tó ja ti, hã vỹ: ti kuprĩg, he mũ. Kanhkã tá tóg kãtĩg ke mũ, ũ tỹ ãjag tar han ke ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kỹ tóg ag jãmĩ tĩ mũ, ẽmã tỹ Betânia ra. Tá tóg ã nĩgé tỹ ag kri ven mũ. Kỹ tóg ag mỹ vĩ há han mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ag mỹ vĩ há han kỹ tóg ag ré kỹ tĩ mũ, kanhkã ra tãpry tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kỹ ag tóg ti to: “Topẽ vỹ tỹ ti nĩ,” he mũ sir. Kỹ ag tóg Jerusalém ra kãmũ mãn mũ, vẽsỹkã. Ag mỹ tóg sér pẽ tĩ vãhã. ");
INSERT INTO kgpNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kurã kar ki ag tóg Topẽ jo ĩn ra mũ tĩ, tá Topẽ to vĩ há han jé, ti mỹ nén ũ há kar tó jé, ti tỹ ag mỹ sér tĩn kỹ. Hã vẽ.");
INSERT INTO kgpNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Topẽ tỹ nén ũ kar han ja tũg ki tóg nĩ ja nĩ, ẽg tỹ ũ to: “Topẽ vĩ,” he mũ ẽn ti, hã to ẽg: Jesus, he mũ. Topẽ mré tóg nĩ. Topẽ vỹ tỹ ti nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Topẽ tỹ nén (ũ) kar han tũg ki tóg Topẽ mrẽ nĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ti hã tugrĩn tóg nén ũ kar han, Topẽ ti, ẽg tỹ ũ to: “Topẽ vĩ,” he mũ ẽn tugnĩn. Ã pir mỹ Topẽ tóg nén ũ han tũ nĩ, ti hã mrẽ tóg nén kar han kãn. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ẽg tỹ ũ to: “Topẽ vĩ,” he mu ẽn vỹ rĩr nĩ, hã kỹ tóg ẽg rĩnrĩr han mũ gé. Jẽngrẽ ri ke ti nĩ, ũ tỹ ẽg rĩnrĩr han mũ ẽn ti. Ti tỹ ẽg kanhrãn to ken hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ũn jykre pãno ag vỹ ũ tỹ kuty mĩ mũ ẽn ag ri ke nỹtĩ. Hã ra tóg ẽg mỹ jẽngrẽ ri ke nĩ, ẽg tỹ ũ to: “Topẽ vĩ,” he mũ ẽn ti. Kỹ Nén-Kórég vỹ ti tỹ tũ' he han sór ja nĩ, hã ra tóg ti tỹ hẽ ri ke ja tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kỹ kejẽn Topẽ tóg ẽprã ke ũ jẽnẽ, ti jiji hã vỹ: João, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ti mỹ tóg: “ag mỹ ũ tỹ ag mỹ jẽngrẽ hen mũ ẽn kãmén” he ja nĩ, hã kỹ tóg ke mỹ, ag kar tỹ ti vĩ mẽ jẽ, ag tỹ ti vĩ kri fi jẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","João pi(jé) ẽg mỹ jẽngrẽ han ja nĩ'. Ti tỹ ẽg mỹ: “ẽn hã vẽ,” henh kãtĩg ja vẽ, ũ tỹ ẽg mỹ jẽngrẽ han mũ ẽn to, hã vỹ: Jesus, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jẽngrẽ pẽ ẽn hã vẽ. Ẽprã tóg jun, ti tỹ ẽg kanhrãn jẽ, ẽprã ke kar, ũ tỹ ẽg ki jẽngrẽg pẽ han mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ga han tóg, ũ tỹ ẽg mỹ jẽngrẽ han mũ ẽn ti, kỹ tóg ẽg mré ga kri tĩnh kãtĩg gé, ga han kar kỹ. Hã ra ag tóg ti ki kanhrãn ja tũ nĩ, ẽprã ke ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ã povo kar mĩ tóg tĩg ja nĩ, hã ra ti mrẽ ke ag pi(jẽ) ti ki ge sór ja nĩgtĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ũ ag tóg hã ra ti ki ge mũ. En ag to tóg: “Topẽ krẽ,” he mũ, ũ tỹ ti ki ge kỹ nỹtĩ tãvĩ ag to. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ti ki ge kỹ nỹtĩ tugrĩn ẽg hã vỹ tỹ ti krẽ nỹtĩ. Ẽg mur tugrĩn ẽg tóg ver tỹ ti krẽ tũ nỹtĩ. Ẽg panh tỹ ẽg mỹnh fi mrẽ nỹ tugrĩn ẽg tóg mur mũ gé. Topẽ tỹ ẽg han mãn tugrĩn ẽg tóg tỹ ti krẽ nỹtĩ jãvo. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ẽg tỹ ũ to: “Topẽ vĩ,” he mũ ẽn vỹ ẽg ri ke mur, kỹ tóg tỹ ẽprã ke jẽ sir. Ẽg mrẽ tóg tĩg ja nĩgtĩ. Há kỹ sóg ti vẽ. Pã'i mág vỹ tỹ ti nĩ, ũn tar, tag ve inh. Ẽg to há pẽ tãvĩ ti nĩ, kỹ tóg ki hã tó ti gé. Topẽ kósin pir vẽ, kỹ Topẽ vỹ ti mỹ: “ũn mág vỹ tỹ ã nĩ,” hé, ti jóg ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João vỹ ti kãmén ja nĩ gé. Ti kãmén há han tóg, kỹ tóg: “inh nón kãtĩ mũ ẽn vỹ inh kãfór nĩ,” he ja nĩ. “Inh nón kãtĩg jẽ tóg ke mũ, hã ra tóg tỹ ijo ke nĩ. Ẽn tó inh huri ãjag mỹ. Ti hã vẽ,” he ja tóg nĩ, João ti, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ẽg to hã tãvĩ tóg nĩ, hã kỹ tóg mỹ nén ũ ha kar han, ẽg jagãgtãn kỹ. Ẽg jagãgtãn tag tovãnh ke tũ pẽ tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés vỹ ẽg mỹ Topẽ tỹ ẽg jyvẽn mũ ẽn tó ja nĩgtĩ, ẽg tỹ ti vĩ ki króm jẽ, kỹ Jesus tóg ẽg mỹ: “Topẽ vỹ ãjag mỹ vẽnh pãte fón sór mũ, ti tỹ ãjag to há nĩn kỹ,” he mũ. Ti hã ne ẽg mỹ vẽnh vĩ sér ẽn to mũ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ẽg pi(jẽ) Topẽ vég tĩ'. Kỹ ẽg kãmĩ ũ vỹ ti ve ja tũ nĩ gé. Ti kósin pir hã vỹ ẽg mỹ ti kãmén tĩ, ti hã vỹ ã jóg mrẽ nĩ nĩ, Topẽ mrẽ. Ti hã vỹ Topẽ ri ke nĩ. Kỹ tóg ẽg mỹ ã panh ti kãmén tĩ, Topẽ kósin ti, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kejẽn Judeu ag pã'i ag vỹ João mỹ vẽnh vĩ jẽnẽg mũ. Jerusalém tá ag nỹtĩ, pã'i ag, Topẽ tũ ki rĩr tĩ, Levi krẽ'krẽ ag ke gé. Ag João mỹ vẽnh vĩ jẽnẽ kỹ ag tóg mỹ: “ũ nỹ tỹ nĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kỹ tóg ag mỹ: “inh pi(jé) tỹ Cristo nĩ',” he mũ. Tó há han tóg, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kỹ ag tóg ti mỹ: “kỹ ã hỹn tỹ ũ nĩ?” he mũ. “Ã mỹ tỹ Elias nĩ'?” he ag tóg ti mỹ. Hã ra tóg ag mỹ: “vó” he mũ gé. Kỹ ag tóg ti mỹ: “Topẽ vĩ tó tĩ ũ nẽji kãtĩg ke mũ gé. Ti hã mỹ tỹ ã nĩ?” he mũ. Hã ra tóg: “vó,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kỹ ag tóg ti mỹ: “ũ nỹ tỹ ã nĩ, ge kỹ?” he mũ. “Pã'i ag vỹ ẽg jẽgnẽ, ẽg tỹ ã ki jẽmẽ jẽ. Ẽg hỹn ne tónh ke mũ, ag mỹ?” he ag tóg mũ. “Vẽso ã hẽri ke ti?” he ag tóg mũ, João mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kỹ João vỹ ag mỹ vẽnh kãmén mũ. Ã to nén rán kỹ nĩ ẽn tó tóg mũ, hã vỹ: “ũ tỹ ẽmã tũg ja tá jẽ kỹ vẽnh kar mỹ Topẽ jykre kãmén mũ ẽn vỹ tỹ inh nĩ,” he mũ. “Ũ tỹ vẽnh kar mỹ: “ẽg Senhor japry kure ra, ti jamĩn kurynh ra, ti tỹ jagma tĩg há han jé, he tĩ ẽn vỹ tỹ inh nĩ. Isaías tỹ inh kãmén hã vẽ,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jãvo ũ tỹ ti ki jẽmẽg mũ ag vỹ tỹ Fariseu ag mrẽ ke nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kỹ ag tóg ti mỹ: “ã tỹ hẽ ri ken kỹ ag kygpe sór nẽ, ã tỹ tỹ Cristo tũ hã ra?” he mũ. “Inh pi(jẽ) tỹ Elias nĩ', he ã tóg tĩ. Inh pi(jẽ) tỹ Topẽ vĩ tó tĩ ẽn nĩ', ẽg tỹ ũn kãtĩg jãvãnh mũ ẽn, he ã tóg tĩ, hã ra ã tóg ag kygpég tĩ,” he ag tóg mũ, João mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Kỹ tóg ag mỹ: “goj tỹ sóg ag kygpég tĩ,” he mũ. “Hã ra ũ tóg ãjag kãmĩ tĩ mũ ha, ãjag tỹ ũn ki kagtĩg ũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ẽn vỹ inh nón kãtĩg ke mũ, hã ra tóg inh kãfór nĩ. Sỹ ti camarada nĩnh ke vẽ vẽ, sỹ ti pẽn né kunũnh ke vẽ vẽ, ti pẽn to ró ti. Hã ra sóg tỹ ti krẽm ke pẽ jẽ,” he tóg, João ti ");
INSERT INTO kgpNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kỹ ag tóg mũ mũ, ti vĩ mẽ kar kỹ. Cidade tỹ Betânia tá ag tóg ti venh kãmũ ja nĩgtĩ, Fariseu ag, João ti, Jordão mã tá. Tá tóg ag kygpég jẽ nĩ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tỹ vaj kỹ João vỹ Jesus vég mũ sir. João tá tóg jun mũ, Jesus ti. Kỹ João tóg ti to: “ti hã vẽ,” he mũ. “Ẽg tỹ Topẽ mỹ ẽg mẽg tỹ carneiro krẽ tãnh ẽn ri ke ti nĩ, cordeiro ẽn ti. Ti hã vỹ ẽg kar tỹ Topẽ vĩ mranh jagfy ter ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Sỹ ũn kãmén mũ ẽn hã vẽ. Ũ tỹ ijo jẽ mũ vỹ inh nón kãtĩg ke mũ, he ja inh nĩ ti to. Inh kãfór ti nĩ, ti tỹ inh jo ke nĩn kỹ, he ja inh nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Inh pi(jé) ti ki kanhró ja nĩ', hã ra sóg goj tỹ vẽnh kar ag kygpé, ag tỹ ti ki kanhrãn kãn jé, povo tỹ Israel ag kar,” he tóg, João ti ");
INSERT INTO kgpNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kỹ tóg: “Topẽ kuprĩg ve inh,” he mũ gé. “Kanhkã tá kãkutẽ kỹ tóg ti krĩ kri nĩ nĩ. Tỹ sórãg ve ti nĩ, Topẽ kuprĩg ti, ti tỹ ti krĩ kri nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Inh pi(jé) Jesus ki kanhró nĩ vẽ'. Hã ra Topẽ tóg inh mỹ: ha ag kygpenh tĩg,” he ja nĩgtĩ, kỹ tóg inh mỹ: “ã tỹ inh kuprĩg ve kỹ ã tóg ti ki kanhró nĩnh mũ,” he ja nĩ gé. “Kanhkã tá kãkutẽ kỹ tóg ag kã ũn pir kri nĩnh mũ. Ti tỹ ũn kri nĩ mũ ẽn vỹ inh kuprĩg tỹ ag kygpenh ke mũ,” he ja tóg nĩ inh mỹ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tag ve inh, hã kỹ sóg ãjag mỹ: ti hã vỹ tỹ Topẽ kósin nĩ, he mũ” he tóg, João ti. Ti tỹ Jesus kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tỹ vaj kỹ João vỹ ã mrẽ mũ tĩ régre ag mré vẽmén jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kỹ tóg Jesus tỹ mĩ tĩg vég mũ, kỹ tóg ag mỹ: “Topẽ tũ vỹ tỹ ti nĩ,” he mũ. “Ẽg tỹ Topẽ mỹ ẽg mẽg tỹ cordeiro tãnh tĩ ẽn ri ke ti nĩ,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ag tỹ ti vĩ tag mẽ kỹ ag tóg Jesus nón mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kỹ Jesus vỹ ag vég mũ, ag tỹ ti nón mũ ti. Kỹ tóg ag mỹ: “ne nẽ?” he mũ. Kỹ ag tóg ti mỹ: “ã hẽ tá ẽmã nĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kỹ tóg ag mỹ: “mũ jé ha, inh mrẽ, ãjag tỹ inh jamã ven jé,” he mũ. Kỹ ag tóg ti mrẽ mũ mũ sir. Ti mré ag kurã ẽn tũg mũ. Rã ké ti nỹ ha, ag tỹ ti mrẽ mũ kri, 4 horas hỹn hẽn ri ke mũn. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ti mré mũ ag kã ũ vỹ tỹ André nĩ, ũ tỹ João tỹ Jesus tó ja ẽn mẽg mũ ag kã ũ, hã vỹ: Simão Pedro jãvy, he mũ, André ti, Jesus mrẽ vẽmén tĩ ẽn ag kã ũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ẽn tóg tá kãtĩg, kỹ tóg vẽsỹmér ã kãke tỹ Simão Pedro venh tĩ mũ, kỹ tóg ti mỹ: “Messias ve inh,” he mũ. “Messias,” he ag tóg tĩ, Topẽ tỹ ũn jẽnẽnh ke ẽn to, Cristo to. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","André tỹ ti mỹ Jesus tó kỹ tóg ti mré ti venh tĩ mũ. Kỹ Jesus vỹ ti ki ẽvãnh mũ, kỹ tóg ti mỹ: “Simão vỹ tỹ ã nĩ, João kósin,” he mũ. “Sỹ ã jyjyn mãn ke vẽ, hã vỹ: Cefas, he mũ,” he tóg, Jesus ti. Cefas to ken hã vẽ, hã vỹ: Pedro, he mũ, hã vỹ: pãró, he mũ, ẽg vĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tỹ vaj kỹ Jesus vỹ ga tỹ Galiléia ra tĩg sór mũ. Ã tĩg ke jo tóg Filipe kato tẽ mũ. Kỹ tóg ti mỹ: “inh mré kãtĩg,” he mũ. Kỹ tóg tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hã ra Filipe vỹ tỹ Betsaida tá ke nĩ, André mré Pedro jamã ẽn tá ke. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kỹ Filipe vỹ Natanael venh tĩ mũ, ti mỹ Jesus kãmén jé. Kỹ tóg ti mỹ: “Cristo ve inh huri,” he mũ. “Moisés vỹ ti kãtĩg ke rán ja nĩ, Topẽ vĩ tó tĩ ag ke gé. Jesus to ken hã vẽ, Nazaré tá ke ẽn to ken hã vẽ, José kósin ẽn ti. Ti hã vỹ tỹ Cristo nĩ,” he tóg, Filipe ti, Natanael mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kỹ tóg ti mỹ: “hã ra sóg Nazaré tá ũn há ve ja tũ nĩ ver,” he mũ. Hã ra Filipe tóg ti mỹ: “ge ra ti venh kãtĩg,” he mũ. Kỹ tóg ti mré tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ag tỹ Jesus tá junjun mũ ra Jesus tóg Natanael kãmén mũ, ũ tỹ tá nỹtĩ ag mỹ. “Ũ tỹ tá kãtĩ mũ ẽn ve ra,” he tóg. “Israel krẽ'krẽ pẽ vẽ,” he tóg. “ũn há vỹ tỹ ti nĩ, ón vãnh ti nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hã ra Natanael vỹ Jesus tỹ ã to vĩ tag mẽg mũ. Kỹ tóg ti mỹ: “kỹ ã mỹ inh ki kanhró nĩ'?” he mũ. Kỹ Jesus tóg ti mỹ: “Filipe tỹ ã jé prẽr to hã sóg ã vé,” he mũ. “Ã tỹ ka krẽm jẽ kỹ sóg ã vé, ka tỹ figueira ẽn krẽm,” he tóg,” he tóg. Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kỹ Natanael tóg Jesus mỹ: “mẽ',” he mũ. “Topẽ kósin vỹ tỹ ã nĩ,” he tóg. “Ẽg povo tỹ Israel kri pã'i vỹ tỹ ã nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kỹ Jesus tóg: “isỹ ã mỹ: ã ve ja inh nĩ, ã tỹ ka krẽm jẽ ra, hen kỹ tóg ã mỹ e tĩ, kỹ ã tóg inh vĩ kri fi sór mũ,” he mũ. “Hã ra tóg ver tỹ nén ũ tũ nĩ, sỹ ã ve ja tag ti. Isỹ kar kỹ nén han ke vỹ ã mỹ e pẽ tãvĩ tĩnh mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","“Ha vé, ki hã sóg tónh ke mũ, ha mẽ. Kanhkã nor kỹ nĩ ve jé ãjag tóg ke mũ. Tá ãjag tóg Topẽ tỹ jẽgnẽ jafã ag venh ke mũ gé. Kanhkã tá ag kãrenh ke mũ, iso, kỹ ag ra mũ mãn ke mũ gé. Tỹ sóg ẽprã ke fi kósin nĩ mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kurã tãgtũ tũg kỹ ũ tóg vẽnh prũg han mũ ẽmã tỹ Caná tá, ga tỹ Galiléia tá. Jesus mỹnh fi vỹ venh tĩg ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kỹ ag tóg Jesus mỹ tó mũ gé, ti tỹ festa venh kãtĩg jé, ti mré mũ tĩ ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ag tỹ tá nỹtĩ ra vãhã vinho tóg tũ' he mũ. Kỹ Jesus mỹnh fi tóg ti mỹ: “vinho hur tũg,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Hã ra Jesus tóg fi mỹ: “toreg', mỹnh',” he mũ. “Inh mré ke tũ vẽ, ã tỹ inh mỹ nén tó mũ tag ti,” he tóg, Jesus ti, ã mỹnh fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hã ra fi tóg ũ tỹ festa ki rĩr tĩ ag mỹ: “ti tỹ ãjag mỹ nén ũ tó kỹ han nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hã ra goj né mág tỹ 6 (ke) vỹ tá nỹtĩ, pó tỹ goj hé mág. Éhé ti nỹtĩ, balde fór tỹ 10 (ke) tỹ ẽg tóg ũn pir fãn tĩ. Judeu ag vỹ vẽnh kygpe e han tĩ, ag tỹ Topẽ mỹ há nỹtĩ jé. Ag jykre hã vẽ. Ag tỹ vẽnh kygpe hã jé tóg tá nỹtĩ, goj nén ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kỹ Jesus tóg festa ki rĩr tĩ ag mỹ: “goj né ẽn fónfãn, goj run kỹ,” he mũ. Kỹ ag tóg ke mũ. Fónfãn kãn ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kỹ tóg ag mỹ: “goj tag tỹ festa to pã'i mỹ ven,” he mũ. Kỹ ag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kỹ tóg kron mũ, festa to pã'i ẽn ti. Hã ra tóg tỹ vinho nĩ sir, ag tỹ run ja ti. Hã ra tóg ki kagtĩg nĩ, festa to pã'i ti. Ũ tỹ festa ki rĩr tĩ ag hã vỹ ki kanhró nỹtĩ, pã'i ẽn krẽm ke ag. Pã'i tỹ vinho hã ẽn kron kỹ tóg ũn prũg mũ ẽn jé prẽr mũ. Kỹ tóg ti mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“vẽnh jykre vẽnhmỹ han ã,” he mũ. “Ag tỹ kronkron vén kỹ ã tóg ag mỹ vinho há tãvĩ nĩm ke mũ vẽ, kar kỹ vinho pãgsĩ vỹ há nĩ vẽ. Jãvo ã tóg ag mỹ vinho pãgsĩ ẽn nĩm vén, kỹ ã tóg vinho há pẽ tag nĩm sór mũ ha vãhã,” he tóg, festa to pã'i ti, ũn prũg mũ ẽn mỹ. Hã ra tóg ki kagtĩg nĩ, Jesus tỹ goj tỹ vinho há ẽn han mũ ti, há kỹ tóg ti mỹ e tĩ, ti tỹ festa kuju ki vinho há ven sór kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus tỹ ẽmã tỹ Caná tá nén han mũn hã vẽ, Galiléia tá. Ẽg tỹ nén han ki kagtĩg hyn han tóg tĩ, kỹ tóg tag han vén. Ti tỹ nén han mũ ki ẽg tóg ti jykre tar ki kanhró nỹtĩ sir. Hã kỹ ag tóg ti ki ge mũ sir, ti mré mũ tĩ ag, ag tỹ ti jykre tar ẽn ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kar kỹ Jesus vỹ cidade tỹ Cafarnaum ra tĩ mũ, ti mỹnh fi mrẽ, ti jãvy ag mré hã, ti mrẽ mũ tĩ ag mré ke gé. Tá ag tóg nỹtĩg mág sĩ han. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ẽn kã Judeu ag festa tỹ Páscoa vỹ kakó nĩ ha Kỹ Jesus vỹ cidade tỹ Jerusalém ra tĩ mũ, ti mré mũ ti ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ti tỹ Topẽ jo ĩn tá jun kỹ tóg ũ tỹ boi vender he tĩ ag vég mũ, carneiro vender he tĩ ag ke gé sórãg vender he tĩ ag ke gé. Topẽ jo ĩn krẽm ag tóg ãjag negócio hyn han tĩ. Kar kỹ ũ ag tóg tá nỹtĩ gé jãnkamy trocar he tĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesus tỹ ag ve kỹ tóg ti mỹ e tĩ, ag tỹ Topẽ jo ĩn kavénh mũn kỹ. Hã kỹ tóg mrãn ke jafã fy tỹ ag mrãnmrãn jafã han mũ. Ẽn vyn kỹ tóg ag pan mũ, Topẽ jo ĩn kãtá, carneiro ti ke gé, boi ti ke gé. Ũ tỹ jãnkamy trocar he tĩ ag jãnkamy ẽn vãm tóg mũ gé, ẽprã, kỹ tóg ag mesa tỹ kréj ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ũ tỹ sórãg vender he tĩ ag mỹ tóg: “ãjag tũ ma mũjẽg,” he mũ. “Inh panh jo ĩn krẽm negócio han sór tũg nĩ. Bodega pijẽ', inh panh jo ĩn ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ti mré mũ tĩ ag tỹ tag ve kỹ ag tóg ti to rán kỹ nĩ ẽn mĩ ẽkrég mũ, ha mẽ: “ã ĩn tóg inh mỹ sĩnvĩ jẽ, kỹ tóg inh mỹ e tĩ, ag tỹn kavénh kỹ. Tag tugrĩn ag tóg inh krĩ rỹ han mũ, kỹ tóg kejẽn isén ke mũ sir, inh kri rỹ ti, ha vemnĩ,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kỹ Judeu ag pã'i ag vỹ Jesus tỹ ag pan mũ vég mũ gé. Kỹ ag tóg ti mỹ: “ã tỹ hẽ ri ke nẽ?” he mũ. “Ũ nỹ hỹn ã mỹ: tag han nĩ, hé? Milagre ũ han nĩ, ẽg tỹ ũ tỹ ã jẽnẽg mũ ki kanhrãn jé,” he ag tóg mũ, pã'i ag, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Hã ra Jesus tóg ag mỹ: “ãjag tỹ Topẽ jo ĩn tag kókén kỹ sóg ti jẽgja ki ũ han mãn ke mũ, kurã tãgtũ ki, ha vemnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kỹ tóg ag mỹ e tĩ. “Ũ tỹ Topẽ jo ĩn tag han mũ ag vỹ ano tỹ 46 (ke) ki rãnhrãj kỹ ti han. Jãvo ã mỹ kurã tãgtũ ki ti han sór mũ', in ti'?” he ag tóg mũ, Jesus mỹ, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Hã ra Jesus tóg ag mỹ ã ter ke tó ja nĩgtĩ, vẽnh kãmén ja ti nĩgtĩ, ti tỹ vẽso: “Topẽ jo ĩn ri ke inh nĩ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ti tỹ kejẽn ã ter kar kỹ rĩr mãn kỹ ti mré mũ tĩ ag tóg ti vĩ tag ki ẽkrén kỹ ki kanhrãn mũ, kỹ ag tóg Topẽ vĩ ki rán kỹ nĩ ẽn to jykrén há han mũ vãhã, Jesus vĩ to ke gé, kỹ ag tóg ti ki ge há han mũ ha. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kỹ ũ tỹ hẽn ri ke ag vỹ Jesus ki ge mũ, ti tỹ Jerusalém tá nĩn kỹ, festa tỹ Páscoa ẽn kã. Ag tỹ ti tỹ nén han mũ ve kỹ ag tóg ti ki ge mũ. Milagre hyn han tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hã ra tóg ag jykre ki kanhró nĩ, ũ tỹ ón kỹ ti ki ge mũ ag jykre ki. Ón kỹ ag tóg ti ki ge mũ, hã kỹ ag tóg ti ki fe tũ nỹtĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kỹ ũ tỹ ti mỹ: “ũ ẽn jykre vỹ ge nĩ,” hen kỹ tóg: “hỹ, ki kanhró inh nĩ,” he tĩ. Vẽsóg ki tóg ag jykre ki kanhró nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ẽn kã ũ tóg nĩgtĩ, ti jijin hã vỹ: Nicodemos, he mũ. Judeu ag pã'i ũ vẽ, Fariseu ũ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ẽn vỹ Jesus ve sór mũ, kỹ tóg kuty ra ti venh tĩ mũ, ti mré vẽmén jé. Kỹ tóg ti mỹ: “Topẽ vỹ ã jẽnẽ, tag ki kanhró ẽg tóg nỹtĩ,” he mũ. “Topẽ tỹ ẽg mỹ ũn jẽnẽ vỹ tỹ ã nĩ, hã kỹ ã tóg ẽg tỹ nén han vãnh ẽn hyn han tĩ. Topẽ tỹ ã mré han tũ nĩ ra ã tóg ã tỹ han mũ tag ki kagtĩg nĩnh mũ vẽ,” he tóg, Nicodemos ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Kỹ Jesus tóg ti mỹ: “sỹ ã mỹ tag kãmén ke vẽ, ha mẽ,” he mũ. “Ũn mur mãn kỹ nỹtĩ ag hã vỹ Topẽ tỹ tỹ ẽg pã'i nĩ venh ke mũ, ag tãvĩ. Ki hã sóg tó mũ mỹr,” he tóg, Jesus ti, Nicodemos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Kỹ Nicodemos tóg ti mỹ: “kỹ ũn sanh hỹn hẽ ri kenh mũ, ti mur mãn jé?” he mũ. “Ti mỹ vẽsĩ han ki kanhró nĩ, kỹn mỹ ã mỹnh fi nug ki rã mãn kỹ mur mãn ke mũ?” he tóg, Nicodemos ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Hã ra Jesus tóg ti mỹ: “vó,” he mũ. “Ẽprã ke ag krẽ vỹ tỹ ẽprã ke nỹtĩ, ag mỹnh fag ri ke, Jãvo Topẽ kuprĩg tỹ ũ han kỹ tóg Topẽ kuprĩg tỹ jagrẽ nĩ. Mur mãn to ken hã vẽ, hã vỹ: inh ki rã, he mũ, hã vỹ: mur mãn, he mũ. Goj tỹ ke vẽ, Topẽ kuprĩg tỹ ke vẽ gé. Ũ tỹ gen kỹ mur mãn ja tũ nĩn kỹ tóg Topẽ tỹ tỹ ẽg pã'i nĩ venh ke tũ pẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hã ra tóg ã mỹ e tĩ, sỹ ã mỹ: “mur mãn jé ã tóg ke mũ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kãka to jykrén nĩ. Ti tỹ mĩ tĩg sór mũ ẽn mĩ tóg tĩ tĩ kãka ti. Ti tỹ krog he mũ ẽn hã mẽg ẽg tóg tĩ, hã ra ẽg tóg ti vég tũ nĩ, kỹ ẽg ti tỹ hẽ ra tĩg ke mũ ki kagtĩg nỹtĩ, ti tỹ hẽ tá kãtĩg ẽn ti ke gé. Ge ti nĩgtĩ, Topẽ kuprĩg tỹ ũn han mãn mũ ag mré,” he tóg, Jesus ti, Nicodemos mỹ. (Topẽ kuprĩg vég tũ ẽg tóg nĩgtĩ. Ha ra tóg ẽg mỹ ã jykre tãg nĩm, ti tỹ ẽg han mãn kỹ. Hã kỹ Jesus tóg Nicodemos mỹ: “kãka ri ke nĩ,” he mũ) ");
INSERT INTO kgpNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kỹ Nicodemos tóg: “tag hỹn hẽ ri ke tĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kỹ Jesus tóg ti mỹ: “Israel ag kanhrãn ã tóg tĩ, hã ra ã tóg sỹ ã mỹ nén tó mũ tag ki kagtĩg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“Ki hã sóg tó mũ, hã kỹ sóg ã mỹ kãmén mũ. Sỹ nén ũ ki kanhrãn mũ ẽn hã tó sóg tĩ. Isỹ nén ũ ve ja ẽn hã kãmén sóg tĩ, hã ra ãjag tóg mẽ jãvãnh nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Isỹ ãjag mỹ ga kri vẽnh jykre kãmén mũ ra ãjag tóg jẽmẽ sór tũ nĩgtĩ. Kỹ ãjag hỹn hẽ ri kenh ke mũ', sỹ ãjag mỹ kanhkã tá vẽnh jykre kãmén kỹ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Ha vé, ãjag kãmĩ ũ vỹ kanhkã ra tãpry tũ nĩ, tá vẽnh jykre ẽn ve jé. Ãjag jãvo isóg tá kãkutẽ ja nĩ, hã kỹ sóg tó tĩ. Inh jamãn hã vẽ. Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Moisés vỹ pỹn tỹ ka to sa ja nĩgtĩ, ga kórég ẽn tá. Pỹn tỹ ferro kusũg tỹ há ẽn tỹ tóg ka to sa ja nĩgtĩ. Tag ri ke han jé ag tóg ke mũ, isỹ, isỹ tỹ ẽprã ke fi kósin nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kỹ ũ tỹ inh ki rãnh ke mũ ẽn vỹ kren ke mũ. Rĩr krỹg ja tũ ve jé tóg ke mũ. Hã jé ag tóg ka to isanh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Topẽ vỹ ga kri mũ ag to há nĩ, hã kỹ tóg ã kósin pir fẽg, vẽnh kar tỹ ti ki ge jé, ag tỹ tũ' he tũ nĩ jé, ag tỹ ẽg rĩr krỹg ja tũ ẽn ven jẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Topẽ vỹ ã kósin jẽnẽ, ti tỹ ẽprã ke ag krenkren han jé. Ti pi(jé) sỹ ãjag vóg kónãn jé inh jẽnẽ',” he tóg, Jesus ti, Nicodemos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ũ tỹ inh ki rãnh ke mũ to tóg jũnh ke tũ nĩ, Topẽ ti. Jãvo tóg ũ tỹ inh ki ge tũ ẽn ag hã to jũ nĩ isỹ tỹ ti kósin pir nĩn kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Topẽ tỹ ũ tỹ inh ki ge tũ ag to jũ vỹ ge nĩ, ha mẽ. Ga kri mũ ag kanhrãn sóg tĩ, hã ki sóg ag mỹ jẽngrẽ ri ke nĩ. Hã ra ag tóg mẽ sór tũ nĩgtĩ. Kuty mĩ ag tóg mũ sór mũ, jẽngrẽ tóg ag mỹ kórég nĩ, ag jykre pãno nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ũ tỹ vẽnh jykre pãno han mũ kar vỹ kurã to kórég nỹtĩ, kỹ ag tóg kurã ki vẽnh ven sór tũ nĩ, vẽnh kar tỹ ag jykre pãno venh ha mẽ tĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ũ tỹ Topẽ vĩ ki króm mũ ag vỹ kurã ki vẽnh ven sór tĩ. Kurã tóg ag mỹ sér tĩ, vẽnh kar tỹ ag jykre hã ven jé. Topẽ vỹ ag tar han tĩ, ag tỹ nén ũ há han jé. Hã ve jé ag tóg ke mũ, vẽnh kar ag,” he tóg, Jesus ti, Nicodemos mỹ. Ti tỹ ti mỹ Topẽ jykre kãmén ja hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ẽn kã kejẽn Jesus tóg ã mré mũ tĩ ag mré ga tỹ Judéia ra tĩ mũ, kỹ ag tóg tá nỹtĩ, vẽnh kar kygpe kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hã ra João vỹ ag kygpég mũ gé, ẽn kã, vãnh tỹ Enom tá, Salim tóg tá kakó nĩ. Tá goj vỹ éhé nĩ, hã kỹ tóg ag tỹ tá vẽnhmãn kỹ ag kygpég mũ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ẽn kã tóg ver se kỹ jẽ tũ nĩ, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kejẽn Judeu ũ tóg tá nĩ gé, hã ra tóg João mré mũ tĩ ag vĩ kafãn mũ. “Goj tỹ ẽg tóg Topẽ mỹ jãnhkri kỹ nĩgtĩ',” he tóg mũ, ag mỹ, Judeu ẽn ti. Hã to ag tóg jagnẽ vĩ kafãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kỹ João mré mũ ag tóg João mỹ tag tó mũ, ha mẽ. “Ũ tỹ Jordão mãtá ã mré nĩ ja ẽn vỹ ag kygpég jẽ nĩ, ã tỹ ẽg mỹ ũn kãmén ja ẽn ti. Hã ra vẽnh kar vỹ ti mré mũ mũ ha, hã kỹ ag tóg ã venh kãmũ mãn tũ nĩ ha,” he ag tóg mũ, João mỹ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Hã ra tóg ag mỹ: “há ti nĩ,” he mũ. “Topẽ tỹ ẽg mỹ ũn nĩm mũ ẽn hã vég ẽg tóg tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Mĩ ẽkrén nĩ, sỹ ãjag mỹ nén tó ja ti, hã vỹ: inh pi (jé) tỹ Cristo nĩ', he mũ. Sỹ ti jãmĩ tĩg ke hã jé tóg inh jẽnẽ, Topẽ ti, he ja sóg nĩ ãjag mỹ,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Vẽnh prũg to jykrén nĩ. Ũn prũg mũ hã vỹ ã prũ ke fi mré nĩ nĩ. Ti régre tóg hã ra ti rã hã jẽ, ũn prũg mũ ẽn rã hã, kỹ tóg ti vĩ mẽg mũ, hã ra tóg ti mỹ mẽ sér pẽ tĩ, ti, vĩ ti. Ge ti nĩ, inh mré. Inh mỹ tóg sér tĩ, vẽnh kar tỹ ti mré mũn kỹ, ti tỹ ũn prũg mũ ri ke nĩn kỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ũn e tỹ ti mré mũn kỹ tóg há tĩ, kỹ tóg tỹ ũn mág nĩnh mũ ha. Hã ra sóg tỹ nén ũ tũ nĩnh ha,” he tóg, João ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ũn tỹ kynhmỹ kãtĩ mũ ẽn vỹ vẽnh kar kafór nĩ. Ẽprã ke ag vỹ tỹ ẽprã ke nỹtĩ, kỹ ag tóg ẽprã ke jykre tỹ vẽmén tĩ. Ũ tỹ kanhkã tá kãtĩ mũ ẽn vỹ tỹ vẽnh kar kri ke jẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kỹ tóg ã tỹ tá nén ve ja ẽn hã tó mũ, ã tỹ tá nén mẽ ja ẽn, hã ra ag tóg ti vĩ mẽ sór tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ũ tỹ ti vĩ mẽg mũ ag hã ra Topẽ to: “ki hã tóg tó tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Topẽ tỹ ũn jẽnẽg mũ ẽn vỹ ti vĩ kãmén mũ. Topẽ kuprĩg vỹ Jesus tar han mũ, ti tỹ tỹ ti jagrẽ pẽ nĩn kỹ, ti tỹ ti ve mág han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Topẽ vỹ ã kósin to há tãvĩ nĩ, kỹ tóg ti mỹ nén (ũ) kar tovãnh, ti hã tỹ ki rĩr jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hã kỹ ũ tỹ ti kósin ki rã mũ vỹ ter mãn ke tũ nĩ. Rĩr krỹg ja tũ ve jé tóg ke mũ. Ũ tỹ ti vĩ han sór tũ ẽn vỹ tag venh ke tũ pẽ nĩ, rĩr krỹg ja tũ tag ti. Topẽ vỹ ti vóg kónãn ke mũ, kỹ tóg tũg' henh ke tũ nĩ, Topẽ tỹ ti vóg kónãn ke ti,” he tóg, João ti. Ti tỹ ã mré mũ tĩ ag mỹ Jesus kãmén jan hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kỹ Fariseu ag vỹ mẽg mũ, ũn tỹ hẽn ri ke ag tỹ Jesus mré mũ ẽn ti. Ũn e ag kygpég tóg mũ gé, Jesus ti, João tỹ ũn kygpe ja ag kãfór. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Hã ra Jesus vỹ ag kygpe ja tũ nĩ. Ti mré mũ tĩ ag hã vỹ ag kygpe ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kỹ Jesus tóg mẽg mũ, Fariseu ag tỹ ti tỹ tỹ ũn mág nĩ mẽ ja ti, hã kỹ tóg ga tỹ Judéia tá kãkutẽ kỹ ga tỹ Galiléia ra tĩ mũ, ti mré mũ tĩ ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Galiléia ra tĩg jé tóg ver ga tỹ Samaria fĩn rãm mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Fĩn rãm kỹ tóg Samaria tá cidade ũ tá jun mũ, hã vỹ: Sicar, he mũ. Tán kakó nĩ, Israel jóg'jóg ve tỹ Jacó japỹ ja ti. Ẽpỹ ẽn fi ja tóg nĩ, ã kósin tỹ José mỹ, Jacó ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kỹ Jacó tỹ poço vỹ tá nĩ gé. Jesus tỹ poço ẽn tá jun kỹ tóg tá vẽnhkán kỹ nĩ nĩ, poço ẽn rã hã. Rã tỹ ẽg nĩno kã sa ra ke ja vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jesus tỹ tá nĩn kỹ ũn tỹtá fi vỹ tá jun mũ, Samaria tá ke ũ fi. Goj run jé fi tóg kãtĩ mũ. Kỹ Jesus vỹ fi mỹ: “inh mỹ goj jun, sỹ kron jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ti mré mũ tĩ ag vỹ tá tũgtũ nỹtĩ, ã pir mỹ tóg tá nĩ nĩ, Jesus ti. Cidade ra ag kagáv, vẽjẽn comprar he jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jesus tỹ fi mỹ goj to vĩn kỹ fi tóg ti mỹ: “Judeu vỹ tỹ ã nĩ, hã ra ã tóg inh mỹ goj to vĩ mũ',” he mũ, “isỹ tỹ Samaria tá ke nĩ ra',” he fi tóg mũ, Jesus mỹ. Judeu ag vỹ Samaria tá ke ag to é he tĩ, hã kỹ fi tóg ti mỹ ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kỹ Jesus tóg fi mỹ: “Topẽ tỹ ã mỹ nén han sór mũ tag ki kagtĩg ã nĩ ver,” he mũ. “Kỹ ã tóg inh ki kagtĩg nĩ gé. Ke tũ nĩ mũ ra ã tóg inh mỹ: “inh mỹ goj nĩm,” henh ke mũ vẽ, kỹ sóg ã mỹ goj ror tỹ goj nĩm ke mũ vẽ,” he tóg fi mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kỹ fi tóg Jesus mỹ: “runja tũ ã nĩ,” he mũ, “kỹ ã hỹn hẽ ri kenh mũ, ã tỹ goj ror tỹ goj ẽn run jé? Téj jagy ti nĩ, poço ti,” he fi tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","“Ẽg jóg'jóg ve tỹ Jacó vỹ poço tag han, kỹ ag tóg ti goj kron, ti krẽ ke gé, ti mẽg ke gé. Ã mỹ ti kãfór nĩ, hã kỹ ã mỹ goj ror tỹ goj run sór mũ'?” he fi tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kỹ Jesus tóg fi mỹ: “ã tỹ goj tag kron kỹ ã tóg kãnhmar kron mãn sór mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","“Isỹ ã mỹ goj nĩm kỹ ã tóg kron pir han kar kỹ há nĩ ha, kron mãn sór ke tũ ã nĩ sir. Ã kãki tóg goj ror han ke mũ, sỹ ã mỹ goj nĩm ke ti. Kỹ goj tag vỹ ã ter ke tũ han ke mũ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kỹ fi tóg ti mỹ: “inh mỹ nĩm gé, goj tag ti,” he mũ. “Kỹ sóg tag ki run mãn ke tũ nĩ ha, kỹ sóg kron sór mãn ke tũ nĩ ha,” he fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Hã ra Jesus tóg fi mỹ: “kỹ ã mén jé prẽrmnĩ ge, ti mré inh venh kãtĩg nĩ,” he mũ fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Hã ra sóg mén tũ nĩ,” he fi tóg. “Hỹ,” he tóg, Jesus ti. “Mẽn tũ ã nĩ, ki hã ã tóg tó mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ã mén ag vỹ ũ tỹ 5 (ke) ja nĩgtĩ, kỹ ã tỹ ũri ũn mré nĩ ẽn pi(jé) tỹ ã mén nĩ'. Ki hã ã tóg tó mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kỹ fi tóg Jesus mỹ: “Topẽ vĩ tó jafã vỹ tỹ ã nĩ, vég isóg nĩ nĩ,” he mũ. “Kỹ inh mỹ tag tó, ha mẽ. Ẽg jóg'jóg ve ag vỹ tag ki Topẽ mré vẽmén tĩ ja nĩgtĩ, pãnónh tag kri, kỹ ẽg tóg ũri ke tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Hã ra tóg ãjag mỹ há tũ nĩ, tag, ãjag tỹ tỹ Judeu nỹtĩn kỹ. “Jerusalém tá ẽg Topẽ mré vẽmén ke mũ, Jerusalém tá ẽg tóg ti mỹ: ũn mág vỹ tỹ ã nĩ, henh ke mũ,” he ãjag tóg tĩ. Ti hỹn hẽ tá há nĩ, ẽg tỹ Topẽ mré vẽmén ke ti?” he fi tóg, Jesus mỹ ");
INSERT INTO kgpNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Hã ra Jesus tóg fi mỹ: “ha mẽ, sỹ ã mỹ nén kãmén ke ti,” he mũ. “Kãnhmar ãjag tóg pãnónh tag kri ẽg jóg tỹ Topẽ mré vẽmén mãn ke tũ nĩ, kỹ ẽg Jerusalém tá ti mré vẽmén mãn ke tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Topẽ mré ãjag tóg vẽmén sór ti, hã ra ãjag tóg ãjag tỹ ũn mré vẽmén mũ ki kagtĩg nỹtĩ. Ãjag jãvo ẽg tóg ti ki kanhró nỹtĩ, ũ tỹ vẽnh kar krenkren han ke ẽn tỹ tỹ Judeu krẽ'krẽ ag kã ũ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kãnhmar vẽnh kar vỹ Topẽ mré vẽmén há han ke mũ. Kakó ti nĩ ha, kurã tag. Kỹ ũ tỹ ti mrẽ vẽmén mũ ag vỹ Topẽ kuprĩg tỹ jagrẽ nỹtĩ, hã kỹ ag tóg ti mré vẽmén há han ke mũ, ẽg jóg mág mré. Ũ tỹ ge hã jãvãnh ti mũ, ẽg jóg mág ti, ag tỹ ti mré vẽmén jé, ti mỹ: “ũn mág vỹ tỹ ã nĩ,” he jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","“Ẽg pi(jé) Topẽ vég tĩ, hã ra tóg ẽg mré nĩ nĩ. Kỹ, ẽg tỹ ti mré vẽmén sór kỹ ẽg tóg ti kuprĩg tỹ jagrẽ nỹtĩnh mũ, ẽg tỹ ti mré vẽmén há han jé, ẽg tỹ ti vég tũ ra. Ẽg tỹ ti mỹ: “ũn mág vỹ tỹ ã nĩ,” hen kỹ ẽg tóg ti mỹ ón ke tũ nĩ, vẽnh vĩ há hã tó jé ẽg tóg ke mũ,” he tóg mũ, Jesus ti, fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kỹ fi tóg ti mỹ: “hỹ,” he mũ. “Messias ẽn vỹ kãtĩg ke mũ, ẽg tỹ ũ to: Cristo, he mũ ẽn. Ẽn vỹ ẽg mỹ kãmén kãn ke mũ, tag kar ti,” he fi tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kỹ Jesus tóg fi mỹ: “inh hã vẽ,” he mũ. “Ũ tỹ ã mré vẽmén jẽn hã vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti tỹ fi mỹ tag tó kỹ ti mré mũ tĩ ag tóg ti tá junjun mũ. Kỹ ag tóg ti tỹ fi mré vẽmén vég mũ, kỹ tóg ag mỹ e tãvĩ tĩ. Hã ra ag tóg ti mỹ nén ũ tó tũ nĩgtĩ. “Ã tỹ ne mẽ sór nẽ, fi ki?” he tũ ag tóg nĩgtĩ. “Ã tỹ ne tó nẽ, fi mỹ?” he tũ ag tóg nĩgtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hã ra fi tóg ã runja ré kỹ ti mũ, ã jamã ra. Kỹ fi tóg ã nĩgja tá ke ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“mũ nỹ, ũ ve jé,” he mũ. “Inh mỹ tóg sỹ nén han ja tó kãn. Ti mỹ tỹ Cristo tũ nĩ vỹ?” he fi tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kỹ ag tóg fi mré kãmũ mũ sir, ti ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Fi tĩg kar kỹ ti mré mũ tĩ ag tóg Jesus mỹ “vẽjẽn ti ko ra,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Hã ra tóg ag mỹ: “ijẽn vỹ nĩ nĩ, hã ra tóg ãjag jẽn ri ke tũ nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kỹ ag tóg jagnẽ mỹ: “ũ nỹ ti mỹ vẽjẽn nĩm hỹn?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hã ra Jesus tóg: “ijẽn to ken hã vẽ, hã vỹ: tỹ isỹ Topẽ rãnhrãj han kãn ke, he mũ, isỹ ũ tỹ inh jẽnẽg mũ ẽn vĩ han ke, he mũ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Ãjag mỹ ti kysã tỹ 4 (ke) nĩ ver, ẽg tỹ ẽg jakré kanẽ venh ke ti. Ha Sicar tá kãmũ mũ ag vigvé. Ũri ag tóg inh ke ge sór mũ, kỹ ag tóg inh mỹ ẽg jakré tóg nỹ ẽn ri ke nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","38","Fi mỹ sóg Topẽ vĩ tó, kỹ fi tóg ã mré ke ag mỹ tó. Hã ra sóg ãjag mỹ: “ha ag mỹ tó mãn, ag tỹ inh ki ge jé,” he mũ. Kỹ ãjag tóg ũ jakré kym ri ke han mũ, ãjag tỹ Sicar tá ke ag tỹ inh ki ge mũ ven kỹ. “Ũ vỹ krãn tĩ, kar kỹ ũ vỹ ti kanẽ mãg tĩ,” he ẽg tóg tĩ. Ki hã tó vẽ, tag, ẽg tỹ ẽprã ke ag tỹ inh ki genh ke to jykrén kỹ. Kỹ ũ tỹ ag mỹ tó mãn mũ mỹ tóg sér tĩ, ti tỹ ag tỹ inh ki ge mũ ven kỹ. Ã rãnhrãj kaja vég tóg mũ sir. Hã ra ũ tỹ ag mỹ tó vén ja ẽn mỹ tóg sér tĩ gé, ag tỹ inh ki ge mũ ti. Ã rãnhrãj kaja vég ti tĩ gé,” he tóg, Jesus ti, ã mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hã ra ũn tỹtá ẽn fi tóg ã mré ke kar ag mỹ: “inh mỹ tóg sỹ nén han ja tó kãn,” he ja nĩ, Jesus to. Kỹ ag tóg Jesus ki ge mũ, fi vĩ to. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kỹ ag tóg Jesus tá junjun mũ sir. Kỹ ag tóg ti mỹ: “tĩg tũg nĩ. Ẽg mré nĩmnĩ,” he mũ. Kỹ tóg ag mré kurã régre tũg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kỹ ũ tỹ hẽn ri ke ag tóg ti ki ge mũ sir, ti vĩ to. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ũn tỹtá ẽn fi mỹ ag tóg: “ã vĩ tugrĩn ẽg tóg ti ki ge mũ,” he mũ, “hã kỹ ẽg tóg ũri ti vĩ mẽg mũ, kỹ ẽg tóg ti vĩ tugnĩn ti ki ge pẽ han kỹ nỹtĩ, ũri. Ti ki kanhró ẽg tóg nỹtĩ ha. Vẽnh kar kren han tĩ ẽn vẽ mỹr,” he ag tóg mũ, ũn tỹtá ẽn fi mỹ. Hã kỹ Samaria tá ke tỹ hẽn ri ke ag vỹ Jesus ki ge kỹ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesus tỹ Samaria tá ke ag mré kurã régre tũg kar tóg ga tỹ Galiléia ra tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“Ũ tỹ Topẽ vĩ tó ti ẽn jamã tá ke ag ne tóg Topẽ vĩ tó tĩ ẽn to é he tĩ',” he ja tóg nĩ, Jesus ti, hã kỹ tóg kór há ra tĩ mũ, Galiléia ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hã ra ag tóg, ti tỹ tá jun kỹ (ag tóg) ti mỹ vĩ há han mũ. Ti ve ja ag tóg nĩ, Jerusalém tá, festa tỹ Páscoa ẽn tá, kỹ ag tóg ti tỹ tá nén hyn han ja ẽn ve kãn. Hã kỹ ag tóg ti mỹ vĩ há han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kỹ Jesus tóg ẽmã tỹ Caná ra tĩg mãn mũ, ga tỹ Galiléia tá ẽmã tỹ Caná ẽn ra. Tá tóg goj tỹ vinho han ja nĩgtĩ. Ẽn tá cidade tỹ Cafarnaum vỹ kakó nĩ. Cafarnaum tá pã'i mág tóg nĩgtĩ. Ti kosin vỹ kaga nỹ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kỹ tóg mẽg mũ, Jesus tỹ Judéia tá kãtĩg ja ti, ti tỹ Galiléia tá jun ja ti, pã'i mág ẽn ti. Kỹ tóg ti venh kãtĩ mũ. “Inh mré inh kósin venh kãtĩg,” he tóg mũ, Jesus mỹ. “Kaga jagy tóg nỹ, kỹ tóg inh mỹ ti ter ha mẽ tĩ. Ã mỹ ti tỹ há' henh ke tũ?” he tóg, pã'i mág ti Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Hã ra Jesus tóg ti mỹ: “isỹ ẽg tỹ nén han vãnh han mũ ve sór ãjag tóg mũ, ãjag tỹ hẽn ri ke mũn inh ki ge jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hã ra pã'i ẽn tóg Jesus ti mỹ: “vó,” he mũ. “Kuri inh mré tĩg, ti ter tũ nĩ jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kỹ Jesus tóg ti mỹ: “ha ã hã tĩg,” he mũ. “Há tóg nĩ ha, ã kósin ti,” he tóg. Kỹ tóg Jesus vĩ tag kri fi kỹ tĩ mũ sir, pã'i ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ti tĩg kỹ tóg ã camarada ag kato tẽ mũ. Tỹ vaj kỹ ke vẽ. Ti ĩn tá ag tóg kãmũ mũ, kỹ ag tóg ti mỹ: “ã kósin tóg há' hé huri,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kỹ tóg ag mỹ: “ti rã tỹ hẽ kã sa ra há' hé?” he mũ. Kỹ ag tóg ti mỹ: “rãké tá, meio dia pãte ke sĩ,” he mũ. “Ẽn kã ti rỹg tóg tũ' he mũ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Hora ẽn kã Jesus tóg ti mỹ: “ã kósin vỹ há nĩ,” he ja nĩ. Kỹ tóg to jykrén há han mũ sir, pã'i ẽn ti, kỹ tóg Jesus ki rã mũ, ti prũ fi ke gé, ti krẽ kar ag ke gé, ti camarada kar ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus vỹ ga tỹ Judéia tá kãtĩg kỹ ga tỹ Galiléia ra tĩg ja nĩ. Ẽn kã tóg milagre ẽn han, kỹ tóg tỹ régre nỹtĩ, ti tỹ ẽg tỹ nén ũ han vãnh hyn han mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tag pãte Judeu ag tỹ festa há ũ tóg kejẽn kutẽ mũ, kỹ Jesus vỹ Jerusalém ra tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tá goj nig tóg nĩgtĩ, cidade jy ró jãnkã rã hã, jãnkã ẽn jijin hã vỹ: carneiro jo jãnkã, he mũ. Goj pénĩn tóg ĩn tỹ 5 (ke) nỹtĩ, vẽnh kaga jo ĩn. Goj ẽn jyjy hã vỹ: Betesda, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ẽn tá vẽnh kaga tỹ hẽn ri ke ag vỹ nỹtĩgtĩ, ũn kyvó ag, ũn tĩg vãnh ag, ũn grĩn grĩn kỹ nỹtĩ ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Goj vãn vãn he mũ jãvãnh kỹ ag tóg nỹtĩ. Kejẽn Topẽ tỹ jẽnẽ jafã vỹ goj ki rã kỹ tỹ vãnvãn he han mũ. Ẽn kã ũ tỹ kãrãn vén mũ ẽn tóg há' he tĩ. Vẽnh kaga kar tỹ há' he ti tĩ, goj vãnvor mũ ẽn, ũ tỹ ki ge vén mũ ag kar tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ẽn tá ũ tóg nĩgtĩ, ũn kaga ũ. Kaga nĩ ki tóg 38 (ke) anos han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kỹ Jesus tóg tá jun kỹ ti vég mũ, ti tỹ tá nỹn kỹ. Hã ra tóg ki kanhró nĩ, ti tỹ vãsỹ tá kaga nỹ ki. Kỹ tóg ti mỹ: “ã mỹ há' he sór tũ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Hã ra tóg ti mỹ: “vó,” he mũ. “Hã ra tóg tũ tĩ, ũ tỹ goj kãkã inh fẽg ke ti,” he tóg, ũn kaga ti. “Goj tỹ vãn vãn he kỹ ag tóg inh jo kã ra ge tĩ, ijo tá jun kỹ,” he tóg, ũn kaga si ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kỹ Jesus tóg ti mỹ: “jẽg ra,” he mũ. “Ã cama va tĩg,” he tóg, Jesus ti, ũn kaga si ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Vẽsỹmér tóg há' he mũ, kỹ tóg ã cama va tĩ mũ sir. Vẽnhkán ke kurã ki ke vẽ, Jesus tỹ ti han mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ti tỹ vẽnhkán ke kurã ki ã cama va tĩg kỹ pã'i ag tóg ti mỹ: “vẽnhkán ke kurã ki ẽg tóg nén ũ va tĩg ke tũ nĩ vẽ,” he mũ. “Ã tỹ nén han ke tũ han ã tóg mũ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kỹ tóg ag mỹ: “ũ tỹ isỹ há' he mũ ẽn vỹ inh mỹ: “ã cama va tĩg,” he ja nĩ, hã kỹ sóg va tĩ mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Kỹ ag tóg ti mỹ: “ũ nỹ ã mỹ: “ã cama va tĩg,” hé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hã ra tóg ki kagtĩg nĩ, ũ tỹ ti tỹ há' he mũ ẽn ti. Jesus vỹ ti tỹ há' he kar tĩg ja nĩ, vẽsỹmér. E ag nỹtĩ, goj ẽn tá, vẽnh kaga ag, hã kỹ Jesus tóg ag ré kỹ tĩg ja nĩ. Kỹ ũn kaga ja ẽn tóg ti jiji mẽ ja tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kar kỹ Jesus tóg ti ve mãn mũ, Topẽ jo ĩn tá. Kỹ tóg ti mỹ: “ha vé,” he mũ. “Ã tỹ inh há' hé. Topẽ vĩ mranh mãn sór tũg nĩ, ã tỹ ti vĩ mranh mãn mũ ra ã tóg ã kaga kãfór venh ke mũ, ha vemnĩ,” he tóg ti mỹ, Jesus ti, ã tỹ ũ tỹ há' he ja ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Hã ra tóg tĩ mũ, pã'i ag mỹ Jesus ti tó jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kỹ ag tóg ti tén sór mũ sir, ti tỹ vẽnhkán ke kurã ki ũn kaga ẽn tỹ há' hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hã ra Jesus tóg pã'i ag mỹ: “inh panh vỹ rãnhrãj kỹ nĩ nĩ, ẽg jóg mág ti,” he mũ. “Kỹ sóg ver ti kóm isũ han ke mũ gé,” he tóg, Jesus ti, pã'i ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kỹ ag tóg ti to jũ jagy han mũ. “Ti tén jé ẽg tóg ke mũ,” he ag tóg mũ sir jagnẽ mỹ. Vẽnhkán ke kurã ẽn ki tóg ã tỹ nén han ke tũ ẽn han ja nĩ, Jesus ti, Judeu ag jykre tovãnh kỹ. Hã ra tóg Topẽ to: “inh panh vỹ tỹ ti nĩ,” he mũ gé. Ti tỹ vẽso: “Topẽ ri ke inh nĩ,” he vẽ. Hã kỹ ag tóg ti to jũ mũ, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kỹ Jesus tóg ag mỹ vẽnh kãmén mũ. “Ki hã sóg tó mũ, ha mẽ,” he tóg. “Ẽg jóg mág kósin vỹ ã pir mỹ nén ũ han ki kagtĩg nĩ. Ã panh vég ti tĩ, ẽg jóg mág kósin ti, kỹ tóg ã tỹ ã panh ki nén vég mũ ẽn hã han tĩ. Ẽg jóg mág tỹ nén han mũ ẽn hã han tóg tĩ gé, ti kósin ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ẽg jóg mág vỹ ã kósin to há tãvĩ nĩgtĩ, hã kỹ tóg ti mỹ ã tỹ nén han mũ ẽn ven kãn mũ. Ti tỹ nén han mũ ũ ve ãjag huri, hã ra ãjag tóg ti kãfór venh ke mũ ver, ha vemnĩ, kỹ tóg ãjag mỹ e tĩnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tag ve jé ãjag tóg ke mũ, ha mẽ. Ẽg jóg mág tóg ũn kãgter mũ ag rĩnrĩn mãn tĩ, ag rĩnrĩr nỹtĩ jé. Ẽn ri ke han jé tóg ke mũ gé, ti kósin ti. Ã tỹ ũn rĩn mãn mũ ẽn rĩn mãn jé tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Kỹ ẽg jóg mág vỹ vẽnh kar jykre tugnỹm ke mũ, hã ra tóg ã kósin mỹ tag tovãnh. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ti mỹ tóg tag tovãnh, vẽnh kar tỹ ti to: “ũn mág vỹ tỹ ti nĩ,” he jé, ag tỹ ẽg jóg mág to: “ũn mág vỹ tỹ ti nĩ,” he mũ tag ri ke. Ũ tỹ ti kósin mỹ: “ũn mág vỹ tỹ ã nĩ,” he jãvãnh kỹ tóg ẽg jóg mág mỹ tag tónh ke tũ nĩ gé. Ti hã vỹ ã kósin jẽnẽ ja nĩgtĩ. Inh hã vẽ, ti kósin ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ãjag mỹ sóg tag tó mũ, ha mẽ. Ki hã sóg tó mũ, ha mẽ. Ũ tỹ inh vĩ jẽmẽg mũ ẽn vỹ ter ke tũ nĩ, rĩr krỹg ja tũ ve jé tóg ke mũ, ti tỹ ũ tỹ inh jẽnẽg mũ ẽn ki rã kỹ jẽn kỹ. Ẽn to tóg jũnh ke tũ nĩ, Topẽ ti. Ti ter ke vẽ vẽ, hã ra tóg ter ke tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ki hã sóg tó mũ, ha mẽ. Kãnhmar ũn kãgter kỹ nỹtĩ ag vỹ Topẽ kósin vĩ mẽnh ke mũ, kỹ ũn tỹ ti vĩ mẽg mũ ag vỹ rĩnrĩr mãn ke mũ. Kakó tãvĩ ti nĩ ha, ag rĩnrĩr mãn ke kurã ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Inh panh vỹ ã pir mỹ vẽnh kar rĩnrĩr han ki kanhró nĩ, hã ra tóg inh mỹ ã jykre tag nĩm gé, sỹ vẽnh kar rĩnrĩr han mãn jé gé, isỹ tỹ ti kósin nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kỹ tóg inh mỹ: “ẽprã ke kar jykre tugnỹm nĩ,” he ja nĩgtĩ, isỹ tỹ ẽprã ke fi kósin nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tag hỹn tóg ãjag mỹ e tĩ, sỹ ãjag mỹ: “vẽnh kar rĩnrĩr han jé sóg ke mũ,” hen kỹ. Sỹ ke há vẽ, hã ra. Kejẽn ũn kãgter mũ kar ag vỹ inh vĩ mẽnh ke mũ, kỹ ag tóg ãjag kej tá kãpa kãn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kỹ ũn tỹ vẽnh jykre há han mũ ag vỹ rĩnrĩr mãn kỹ rĩr krỹg ja tũ ẽn venh ke mũ, jãvo ũn tỹ vẽnh jykre pãno han mũ ag rĩnrĩr mãn sĩ han kỹ nũgme ki vár kãn ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Kỹ tóg ag mỹ: “inh pi(jé) isỹ vẽsóg ki nén to jykrén mũ ẽn han tĩ',” he mũ, Jesus ti. “Inh panh tỹ inh mỹ nén tó mũ ẽn hã tó sóg tĩ, isỹ vẽnh kar jykre tugnỹm ken kỹ. Hã kỹ sóg ki hã tó tĩ, isỹ vẽsóg ki to jykrén tũ nĩn kỹ. Ũ tỹ inh jẽnẽg mũ ẽn tỹ inh mỹ nén tó mũ ẽn hã tó sóg tĩ, hã kỹ tóg há kar nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Kỹ isỹ vẽso: “ẽg jóg mág vỹ inh jẽnẽ, inh panh ti,” henh mũ ra ãjag tóg inh mỹ: “ã ón nẽ,” henh ke mũ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ũ vỹ iso: “Topẽ vỹ ti jẽnẽ,” he mũ. Hã ra tóg ki hã tó mũ, ũ tỹ iso tag tó mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Kỹ ãjag tóg João ki jẽmẽ sór ja nĩ gé, hã kỹ ãjag tóg ti mỹ vẽnh vĩ jẽnẽ ja nĩgtĩ. Kỹ tóg ãjag mỹ inh kãmén há han ja nĩgtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hã ra tóg inh mỹ tỹ nén ũ tũ nĩ, ẽprã ke tỹ iso: “Topẽ vỹ ti jẽnẽ,” hen kỹ. Hã ra sóg ãjag mỹ João vĩ tó mũ, ãjag tỹ ti vĩ kri fi jé, ãjag tỹ inh ki ge jé, ãjag krenkren jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","“João vỹ ãjag mỹ lampião gru ri ke ja nĩ, ãjag mỹ kurã sĩ han kỹ, ti tỹ ãjag mỹ Topẽ vĩ kãmén ja nĩn kỹ. Kỹ tóg ãjag mỹ sér tĩ ja nĩ, hã ra tóg kurã e han tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","João vỹ ãjag mỹ inh kãmén ja nĩ, hã ra nén ũ vỹ inh kãmén tĩ gé, kỹ tóg João vĩ kãfór nĩ. Inh panh vỹ inh mỹ: “ẽprã ke ag tỹ nén han vãnh hyn han nĩ, milagre ti,” he ja nĩ, hã kỹ sóg hyn han tĩ. Isỹ milagre hyn han mũ tag vỹ inh kãmén há han tĩ gé. Ãjag tỹ milagre tag vigven kỹ ãjag tóg ki kanhrãn ke mũ vẽ, ẽg jóg mág tỹ inh jẽnẽ jan ki, inh panh ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kar kỹ ẽg jóg mág vỹ, ũ tỹ inh jẽnẽg mũ ẽn vỹ inh kãmén tĩ gé. Ti vĩ jẽmẽg tũ ãjag nỹtĩ, kỹ ãjag tóg ti vég tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kỹ ãjag tóg ti vĩ to jykrén há han tũ nĩ gé, ãjag tỹ inh ki ge sór tũ nỹtĩn kỹ. Ti hã vỹ inh jẽnẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Topẽ vĩ to ke ãjag tóg tĩ. Há ti nĩ, tag ti. “Ẽg tỹ Topẽ vĩ rá to ken kỹ ẽg hỹn rĩr krỹg ja tũ venh ke mũ,” he ãjag tóg tĩ. Inh hã vỹ ki rán kỹ nĩ, ha mẽ, hã kỹ ki ve há han nĩ, vẽnh rán ki,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","“Hã ra ãjag tóg inh ki ge sór tũ nĩ. Ãjag tỹ inh ki ge kỹ nỹtĩ ra ãjag rĩnrĩr kỹ nỹtĩnh mũ vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ẽprã ke ag tỹ inh mỹ vĩ há han tũ ra tóg inh mỹ tỹ nén ũ tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Hã ra sóg ãjag jykre ki kanhró nĩ. Ãjag pi(jé) Topẽ to há nỹtĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ãjag mỹ sóg: “ẽg jóg mág vỹ inh jẽnẽ,” henh kãtĩg ja nĩ, hã ra ãjag tóg inh vĩ mẽ sór tũ nỹtĩ. Ũ tóg kejẽn ãjag mré vẽmén kãtĩg ke mũ, Topẽ tỹ ti jẽnẽg tũ (hã) ra. Ẽn vĩ jẽmẽ jé ãjag ke mũ, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Inh ki ge sór tũ ãjag nỹtĩ, ãjag tỹ ẽprã ke ag vĩ jẽmẽn kỹ. Ẽprã ke ag tỹ ãjag mỹ vĩ há han kỹ tóg ãjag mỹ sér tĩ. Kỹ ãjag tóg Topẽ tỹ ãjag mỹ nén tónh ke mũ mĩ ẽkrég tũ nĩgtĩ. “Inh jykre mỹ ti mỹ há nĩ vỹ?” he sór tũ ãjag nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ãjag hỹn iso: “ti hỹn ẽg to vĩ kónãn sór mũ, ẽg jóg mág mỹ,” he tĩ. Hã tũ vẽ. Ũ tỹ ãjag to vĩ kónãn ke mũ hã vỹ tỹ Moisés nĩ, ãjag tỹ ũ to: “ti hỹn ẽg to há tãvĩ nĩ,” he mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ãjag tỹ Moisés vĩ kri fi (hã) ra ãjag tóg inh vĩ kri nĩm ke mũ gé vẽ vẽ. Moisés vỹ iso livro han ja nĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hã ra ãjag tóg ti vĩ rá kri fi sór tũ nĩ, hã kỹ ãjag tóg inh vĩ kri nĩm sór tũ nĩ gé,” he tóg, Jesus ti. Ti tỹ pã'i ag mỹ vẽnh kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tag pãte Jesus tóg kejẽn ga tỹ Galiléia tá goj nig fĩn rãm mũ. Goj ẽn jiji hã vỹ: Tiberíades, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kỹ ũ tỹ hẽn ri ke ag vỹ ti venh kãmũ mũ, ti nón, ũn e tãvĩ ag. Ti tỹ nén han vãnh hyn han mũ ẽn ve ja ag tóg nĩ, ti tỹ ũn kagyga ag tỹ há' he mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kỹ Jesus tóg pãnónh tá ã mré mũ tĩ ag mré nĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Festa tỹ Páscoa ẽn vỹ kakó nĩ ha, Judeu ag tỹ festa han tĩ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kỹ Jesus vỹ ũn e ẽn ki ẽvãnh mũ, ũ tỹ ti vĩ mẽnh kãmũ mũ ag ki. Kỹ tóg Filipe mỹ: “ẽg hỹn hẽ tá vẽjẽn venh ke mũ, ẽg tỹ ũn e tag ag mỹ ven jé?” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Filipe mỹ tóg ke mũ, ti tỹ to ti jykre ve jé. Jãvo Jesus vỹ to jykrén há han huri, ti tỹ nén han ke mũ ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kỹ Filipe tóg ti mỹ: “ẽg tỹ ũn e tag ag mỹ nén ũ sĩ ven jé ẽg hỹn jãnkamy tỹ hẽn ri ke to comprar henh ke mũ, hã ran kãkyn kenh ke mũ, ha vemnĩ,” he tóg, Filipe ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Kỹ ag mré tĩ ũ tóg, André he mũ ẽn tóg, Simão Pedro jãvy ẽn tóg Jesus mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“kyrũ ũ tóg cevada tỹ ẽmĩ tỹ 5 (ke) ma kãtĩg ja nĩ, kãkufár régre mré,” he mũ. “Hã ra tóg tỹ nén ũ tũ pẽ nĩ, vẽjẽn sĩ tag. E tãvĩ ag nỹtĩ,” he tóg mũ, André ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hã ra Jesus tóg: “ag mỹ: “nĩgnĩ ra,” hé,” he mũ. Kỹ ag tóg nĩgnĩ mũ. Tá tóg re gỹnh nĩ, hã kỹ ag tóg tá nĩgnĩ kỹ nỹtĩ. Ũn tỹ 5 mil (ke) ag hỹn tá nỹtĩ, ẽg tỹ ag tãvĩ tón kỹ, hã ra fag tóg tá nỹtĩ gé, gĩr tỹ hẽn ri ke ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ag nĩgnĩ kỹ Jesus tóg ẽmĩ ẽn mãg mũ, kỹ tóg Topẽ mỹ: “há ti nĩ,” he mũ. Kỹ tóg ag mỹ vẽnh kãpópãm mũ sir, kãkufár ẽn ke gé. Kỹ vẽnh kar vỹ ag tỹ nén ko sór mũ ẽn ko mũ sir. Sĩ tũ tóg nĩ, vẽjẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ag funfór nỹtĩn kỹ Jesus tóg ã mré mũ tĩ ag mỹ: “ag tỹ ko ja tũ ẽn génh mũjẽg, ti vãgfor tũ nĩ jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kỹ ag tóg kẽj tỹ 12 (ke) fãn mũ, cevada tỹ ẽmĩ tỹ 5 (ke) ẽn ke tỹ, vẽnh e ẽn tỹ ko kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kỹ tóg ag mỹ e tĩ, ag tỹ Jesus tỹ milagre tag han mũ ven kỹ. Kỹ ag tóg ti to: “Topẽ vĩ tó tĩ ẽn hã vẽ,” he mũ. “Ẽg tỹ ũn jãvãnh mũ ẽn hỹn tóg,” he ag tóg, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Hã ra Jesus vỹ ki kanhró nĩ, ag tỹ nén han sór mũ ti. Ag tỹ Jesus tỹ pã'i mág tỹ rei han sór vẽ. Tag ki kanhró tóg nĩ, Jesus ti. Hã kỹ tóg ã pir mỹ tĩ mũ, pãnónh ra, vẽnh péju jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kutyg ke mũ ra ti mré mũ tĩ ag tóg goj nig ra mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Barco kãra ge kỹ ag tóg goj fĩn rãm sór kỹ Cafarnaum ra mũ sór mũ. Kejẽn tóg kuty pẽ nỹ ha, hã ra Jesus tóg ag to vỹn ke ja tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kỹ vãhã kóho jũ vỹ kãtĩ mũ, kỹ goj vỹ krém ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mũ sĩ han ja ag nĩ, 5 (ke) quilômetros, hỹn, ke tũ nĩ kỹ 6 (ke) quilômetros, goj kri. Vãhã ag tóg Jesus vég mũ sir, ti tỹ goj kri tĩg kỹ. Ag barco ki tóg jun mũ. Kỹ ag kanẽ tóg jũrũn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Hã ra Jesus tóg ag mỹ: “inh hã vẽ, mũmẽg tũg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kỹ tóg ag mỹ sér tĩ, kỹ tóg barco kãra rã mũ sir, ag mré. Ti tỹ ag mré nĩn kỹ ag tóg kãnhmar junjun mũ, kafã ũ tá. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hã ra vẽnh e ẽn vỹ kafã ũ tá nỹtĩ ver. Tỹ vaj kỹ ag tóg Jesus jãvãnh mũ, tá. Ti jãvãnh kỹ ag tóg: “barco pir vỹ kã nỹ ja nĩ, kuty kỹ,” he mũ. “Kỹ ti mré mũ tĩ ag vỹ barco ẽn kãra ge kỹ mũ ja nĩ, hã ra tóg ag mré tĩg ja tũ nĩ,” he ag tóg mũ sir jagnẽ mỹ, ũn e ẽn ag. Tag tó mũ ra ag tóg Jesus vég tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kỹ barco ũ tóg ki junjun mũ, cidade tỹ Tiberíades tá kãmũ ũ. Vẽnh e ẽn tá ag tóg junjun mũ. Tá Jesus vỹ ẽmĩ to Topẽ mré vĩ ja nĩ, kar kỹ tóg vẽnh e ẽn mỹ vẽnh kãpópãm ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Barco tỹ tá junjun mũ ra ag tóg kãra ge kỹ mũ mũ sir, Cafarnaum ra, ti ve jé. “Ki ti tũ nĩ, ti mré mũ tĩ ag vỹ ki tũgtũ nĩ gé. Mũ nỹ, ti nón,” he ag tóg mũ sir, ũn e ag, hã kỹ ag tóg ti nón mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ag tỹ Cafarnaum tá junjun kỹ ag tóg tá ti vég mũ sir, goj nig kafã ũ tá, ũn e ẽn ag. Kỹ ag tóg ti mỹ: “hẽ ri ken kỹ ã ki jun?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Kỹ Jesus tóg ag mỹ: “ha mẽ, ki hã sóg tó mũ,” he mũ. “Ãjag tỹ ẽmĩ ko ja tugrĩn ãjag tóg inh ve sór mũ,” he tóg. “Sỹ milagre hyn han tĩ ẽn vég ãjag tóg tĩ, hã ra ãjag tóg to jykrén há han tũ nĩgtĩ,” he tóg. “Ãjag tógá nỹtĩ tag hã ve sór ãjag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ẽg tỹ tag ki vẽjẽn vég mũ ẽn vỹ kãnhmar tũ' henh ke mũ, kỹ tag tãvĩ to vãsãn sór tũg nĩ. Vẽjẽn ũ jé vãsãn nĩ, ẽmĩ tỹ ãjag rĩnrĩr pẽ han mũ ẽn jé, ẽmĩ kórég vãnh ẽn jé. Sỹ ãjag mỹ ẽmĩ ẽn nĩm sór vẽ. Ẽg jóg tỹ Topẽ tỹ inh mỹ vẽnh rãnhrãj nĩm ja hã vẽ. Ti tỹ inh mỹ tag tó hã kỹ sóg ãjag mỹ nĩm sór mũ, ẽmĩ ti. Tỹ sóg ẽprã ke fi kósin nĩ mỹr,” he tóg ag mỹ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kỹ ag tóg ti mỹ: “kỹ ẽg hỹn hẽ ri kenh ke mũ, ẽg tỹ Topẽ jykre han jé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Kỹ Jesus tóg ag mỹ: “Topẽ tỹ ũn jẽnẽg mũ ẽn ki gemnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kỹ ag tóg ti mỹ: “kỹ ã hỹn ne han ke mũ, ẽg tỹ ve kỹ ã ki gen jé?” he mũ. “Ã hỹn ne han há nĩgtĩ? ");
INSERT INTO kgpNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ẽg jóg'jóg ve ag vỹ kanhkã tá pão ẽn kó, maná he mũ ẽn, ag tỹ ga kórég ẽn mĩ mũn kỹ. Ag to tag vỹ rán kỹ nĩ, ha mẽ: “kanhkã tá tóg ag mỹ pão jẽnẽ, ag tỹ ko jé,” he ja tóg nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki. Jãvo ã hỹn ẽg mỹ ne han ke mũ?” he ag tóg, Jesus mỹ, ti vĩ kãfãn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kỹ Jesus tóg ag mỹ: “Moisés pi(jé) ãjag mỹ kanhkã tá pão pẽ nĩm ja nĩ',” he mũ. “Ki hã sóg tó mũ, ha mẽ,” he tóg. “Ũ tỹ ãjag mỹ kanhkã tá pão pẽ nĩm mũ ẽn vỹ tỹ inh panh nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Topẽ jamĩ vỹ kanhkã tá kãtére mũ. Ẽn vỹ ẽprã ke kar rĩnrĩr han mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Kỹ ag tóg ti mỹ: “ẽg mỹ ẽmĩ ẽn nĩm, kurã kar ki,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kỹ Jesus tóg ag mỹ vẽnh kãmén mũ sir. “Inh hã vỹ tỹ ẽmĩ ẽn ri ke nĩ, inh hã vỹ ãjag rĩnrĩr han ke mũ,” he tóg. “Ẽg tỹ vẽjẽn ko mũ ra ẽg tóg kãnhmar kókĩr mãn' he tĩ, goj kron mãn sór ẽg tĩ gé. Ũ tỹ iso kãtĩg mũ ẽn mỹ tóg hã ra sér tĩnh mũ, ti tỹ inh ki rã kỹ. Ti mỹ sér tĩ ẽn vỹ tũg' henh ke tũ pẽ nĩ. Isỹ ti mỹ vẽnh jykre nĩm ke mũ ẽn vỹ vẽjẽn kãfór nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Hã ra ãjag tóg ãjag tỹ inh vég mũ ra inh ki ge sór tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Inh panh vỹ ũ ag kuprẽg mũ, ag tỹ tỹ isũ nỹtĩ jé. Ẽn ag vỹ iso kãmũ tĩ. Ũ tỹ iso kãmũ tĩ kar ag vỹ inh mỹ há nỹtĩ. Inh pi(jé) ũ mỹ: “inh mré kãtĩ tũg,” henh ke mũ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kanhkã tá sóg kãtére ja nĩ. Inh pi(jé) isỹ vẽsóg ki nén to jykrén mũ ẽn han sór mũ'. Ũ tỹ inh jẽnẽg mũ tỹ inh mỹ nén tó mũ ẽn hã han sóg tĩ, hã jé sóg tá kãtére ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ti tỹ inh mỹ nén tó mũn hã vẽ, ha mẽ. “Isỹ ã mỹ ũn jẽnẽnh ke mũ ẽn ki rĩr há han nĩ, ag vãgfor tũ nĩ jé,” he ja tóg nĩ, inh mỹ, inh panh ti. Hã kỹ sóg ke mũ. Kỹ sóg ag rĩnrĩn mãn ke mũ, kurã tỹ ẽgno ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Hỹ, tag vỹ inh panh mỹ há nĩ. Ũ tỹ ti kósin to kãmũ mũ ẽn mỹ tóg rĩr krỹg ja tũ ven ke mũ, inh panh ti, ũ tỹ inh ki ge kỹ nỹtĩ ag kar mỹ. Kỹ sóg kurã tỹ ẽgno ki ag rĩnrĩn mãn kãn ke mũ, ha vemnĩ,” he tóg, Jesus ti. Ti tỹ Judeu ag mỹ vẽnh kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kỹ Judeu ag tóg Jesus kato vĩ mũ, ti vĩ to, ti tỹ ag mỹ: “ẽmĩ tỹ kanhkã tá kãtére mũ ẽn ri ke inh nĩ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Ti ki kanhró ẽg nỹtĩ,” he ag tóg mũ. “José kósin vẽ, Jesus tag ti. Ti han mũ fag ki kanhró ẽg nỹtĩ. Hã ra tóg vẽso: “kanhkã tá sóg kãtére,” he sór mũ',” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hã ra tóg ag mỹ: “iso vĩ kónãn tũg nĩ, jagnẽ mỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","“Inh panh tỹ ũn krĩn mũ ag hã vỹ iso kãmũnh mũ. Ũ tỹ iso kãmũ mũ ag rĩnrĩn mãn jé sóg ke mũ, kurã tỹ ẽgno ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Topẽ vĩ tó tĩ ũ vỹ tag rán ja nĩ, ha mẽ: “Topẽ vỹ vẽnh kar kanhrãn ke mũ,” he ja ti nĩ. Hã kỹ ũ tỹ inh panh vĩ mẽg mũ ag hã tóg iso kãmũnh ke mũ, inh panh tỹ ũn kanhrãn mũ ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ẽprã ke ũ pi(jé) inh panh ve ja nĩ'. Ũ tỹ Topẽ tá kãtĩ mũ ẽn hã vỹ ti ve ja nĩ, inh,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Sỹ ãjag mỹ ki hã tó mũn hã vẽ. Ũ tỹ inh ki rã mũ ẽn vỹ rĩr krỹg ja tũ ẽn venh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inh hã vỹ ẽmĩ pẽ ri ke nĩ, inh hã vỹ ãjag rĩnrĩr han ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ãjag jóg'jóg ve ag vỹ, ag tỹ ga kórég mĩ mũn kỹ ag tóg kanhkã tá ẽmĩ ẽn ko ja nĩgtĩ, maná he mũ ẽn, ag tỹ ko mũ (hã) ra ag tóg kãgter kãn. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ũ tỹ ẽmĩ tỹ ẽg rĩnrĩr han mũ ẽn ko kỹ, ũ tỹ kanhkã tá kãtére ja ẽn ki rã kỹ tóg ter ke tũ pẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ẽmĩ ẽn hã vỹ tỹ inh nĩ, inh hã vỹ kanhkã tá kãtére, inh hã vỹ ãjag rĩnrĩr han ke mũ. Ãjag tỹ ẽmĩ tag ko kỹ ãjag ter ke tũ pẽ nĩ. Isỹ vẽnh kar mỹ vẽjẽn nĩm ke hã vẽ, hã vỹ: inh nĩ, he mũ. Ãjag tỹ inh nĩ kon kỹ ãjag rĩnrĩr nỹtĩnh mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kỹ Judeu ag vỹ jagnẽ mỹ: “ti mỹ ẽg mỹ ã nĩ nĩm ke mũ, ẽg tỹ ti nĩ ko jé?” he mũ. “Vẽnhmỹ ti nĩ, tag,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kỹ Jesus tóg ag mỹ: “isỹ ãjag mỹ ke há vẽ,” he mũ. “Ãjag tỹ inh nĩ ko sór tũ nĩn kỹ, ãjag tỹ inh kyvénh kron sór tũ nĩn kỹ, ãjag rĩnrĩr ke tũ pẽ nĩ. Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","“Ũ tỹ inh nĩ ko kỹ, ũ tỹ inh kyvénh kron kỹ tóg rĩr krỹg ja tũ venh ke mũ, kỹ sóg ti rĩn mãn ke mũ, kurã tỹ ẽgno ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Inh nĩ vỹ tỹ vẽjẽn pẽ nĩ, inh kyvénh vỹ tỹ ẽg tỹ kron jafã pẽ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ũ tỹ inh nĩ kon kỹ, ti tỹ inh kyvénh kron kỹ tóg inh ki rã kỹ jẽ nĩ, kỹ sóg ti kãki nĩ gé. Jagnẽ mré ke vỹ tỹ ẽg nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Inh panh vỹ rĩr nĩ. Ti hã vỹ inh jẽnẽ, ti tugrĩn sóg rĩr jẽ. Kỹ ũ tỹ inh ki rã mũ ẽn vỹ isugnĩn rĩr ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ẽmĩ tỹ kanhkã tá kãtére jan hã vẽ. Ãjag jóg'jóg ve ag tỹ ẽmĩ ko ja ẽn ri ke tũ ti nĩ. Ag hã vỹ ãjag tỹ ko mũ ra kãgter kãn ja nĩgtĩ. Ũ tỹ ẽmĩ pẽ tag ko kỹ tóg ter mãn ke tũ nĩ. Inh ki rã to ken hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Cafarnaum tá tóg ag kanhrãn mũ, kỹ tóg ag mỹ vẽnh kãmén kãn mũ, Jesus ti, ag tỹ vẽnh kanhrãn jafã ẽn krẽm. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kỹ tóg ti mré mũ tĩ ũ ag mỹ e tĩ, ti vĩ ti. Kỹ ag tóg: “ti vĩ vỹ ẽg mỹ mẽ jagy tĩ,” he mũ. “Mẽ jãvãnh ẽg tóg nỹtĩ, ti tỹ ũri ẽg mỹ nén tó mũ tag ti,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hã ra Jesus tóg ki kanhró nĩ, ag tỹ ti vĩ tag to vĩ kónãn mũ ti. Hã kỹ tóg ag mỹ: “tag mỹ ãjag mỹ há tũ nĩ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“Kỹ ãjag hỹn hẽ ri kenh ke mũ, ãjag tỹ hẽn ri ke mũn isỹ kanhkã ra tĩg mãn ven kỹ, isỹ hẽ tá kãtére ja ẽn ra tĩg mãn kỹ, isỹ tỹ ẽprã ke fi kósin nĩn kỹ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Ũ tỹ ẽg rĩnrĩr han mũ vỹ tỹ Topẽ kuprĩg ti nĩ. Isỹ ãjag mỹ inh nĩ ko mũ tag to ken hã vẽ, hã vỹ: inh ki rã, he mũ. Inh vĩ tag ki króm tugrĩn ãjag rĩnrĩr nỹtĩnh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hã ra ãjag tóg inh vĩ kri fi sór tũ nỹtĩ,” he tóg, Jesus ti. Ag jykre ki kanhró tóg nĩ, vẽsóg ki, Jesus ti, hã kỹ tóg ke mũ. Ũ tỹ ón kỹ ã ki ge mũ ẽn ki kanhró tóg nĩ. Kỹ tóg ũ tỹ pã'i ag mỹ ti tónh ke mũ ẽn ki kanhró nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kỹ tóg ag mỹ: “hã kỹ sóg ãjag mỹ: “inh panh tỹ ũn krĩn mũ ag hã vỹ iso kãmũnh ke mũ,” he ja nĩ,” he mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesus vĩ tag tugrĩn ti mré mũ tĩ ũ ag tóg ti tovãnh mũ sir, ti mré ag mũ mãn tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kỹ Jesus tóg ũ tỹ 12 (ke) ag mỹ: “ãjag hỹn isovãnh sór mũ gé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Kỹ Simão Pedro tóg ti mỹ: “ẽg tỹ ã tovãnh mũ ra ẽg hỹn ũ mré mũnh ke mũ'?” he mũ. “Ã hã vỹ ẽg mỹ Topẽ vĩ tó tĩ, kỹ ẽg tóg rĩr krỹg ja tũ vẽnh ke mũ, ẽg tỹ ã vĩ kri fi kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ã ki ẽg ge kỹ nỹtĩ, kỹ ẽg tóg ã ki kanhró nỹtĩ. Cristo vỹ tỹ ã nĩ, Topẽ vỹ ẽg mỹ ã jẽnẽ,” he tóg, Pedro ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kỹ Jesus tóg ũ tỹ 12 (ke) ag mỹ: “ãjag kuprẽg inh,” he mũ, “hã kỹ ãjag tóg tỹ ũ tỹ 12 (ke) nỹtĩ,” he tóg. “Hã ra ãjag kãmĩ ũn pir vỹ tỹ Japo tũ nĩ jãvo,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ti tỹ Judas ẽn tó vẽ, Simão Iscariotes kósin ẽn. Ẽn vỹ kejẽn Jesus tovãnh kỹ pã'i ag mỹ ti ven, ag tỹ ti se jé. Ũ tỹ 12 (ke) ag kã ũ ja vẽ, Judas ti. Hã ra Jesus tóg ti tỹ nén han ke mũ ẽn ki kanhró ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tag pãte Jesus tóg ga tỹ Galiléia mĩ tĩ mũ. Ga tỹ Judéia ra tĩg sór tũ ti nĩ ver, ag tỹ Judéia tá ti tén sór nỹtĩn kỹ, Judeu ag pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kejẽn tóg Judeu ag tỹ festa há ũ tá krỹg mũ. Festa ẽn kurã ki ag tóg pãjó krẽm nỹtĩ, Jerusalém tá. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kỹ Jesus jãvy ag tóg ti mỹ: “ga tỹ Judéia ra tĩg nĩ, Jerusalém ra,” he mũ. “Ã tỹ tag hã ki milagre hyn han kỹ tá ã mré ke ag tóg vég tũ nĩgtĩ, hã kỹ cidade mág ra tĩg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Vẽnh kar tỹ ẽg jykre ve jé ẽg tóg vẽnh kar rĩnve ẽg tỹ nén han ke mũ ẽn han tĩ. Hã ra ã tóg ag vatánh tá milagre ti hyn han tĩ. Ag rĩnve han nĩ, ã tỹ nén han ke ti,” he ag tóg mũ, Jesus mỹ, ti jãvy ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ag pi(jé) ti ki ge kỹ nỹtĩ', ti jãvy ag, hã kỹ ag tóg ti to é he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Hã ra Jesus tóg ag mỹ: “inh kurã vỹ jun ja tũ nĩ ver, hã kỹ sóg tĩg sór tũ nĩ ver,” he mũ. “Ãjag hỹn kurã tũ nỹtĩ, kurã kar hỹn ãjag mỹ há nỹtĩ, hã ra sóg kurã nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ũ tỹ iso jũ mũ ag pi(jé) ãjag to kórég nỹtĩ', hã ra ag tóg iso kórég nỹtĩ, isỹ ag mỹ: “ãjag jykre vỹ kórég pẽ nĩ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ha festa venh mũjẽg inhhã. Inh pi(jé) tĩg sór mũ', ver'. Inh kurã vỹ jun ja tũ nĩ ver,” he tóg, Jesus ti, ã jãvy ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tag tó kar kỹ tóg ver ga tỹ Galiléia mĩ tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ti jãvy ag mũ kar kỹ kejẽn Jesus tóg tĩ mũ gé, Jerusalém ra, festa ẽn ve jé. Hã ra tóg vẽnh kar vatánh tá tĩ mũ, vẽnh péju kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kỹ Judeu ag tóg festa ki ti jãvãnh mũ. Jagnẽ mỹ ag tóg: “ti hẽ kã nĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Vẽnh kar vỹ ti to vĩ mũ. Ũ ag tóg ti to: “ũn há vỹ tỹ ti nĩ,” he mũ. Jãvo ũ ag tóg: “vó, ẽg mỹ tóg ón tĩ,” he mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hã ra ag tóg jamã hár(a) ti to vẽmén tũ nĩgtĩ, pã'i ag kamẽg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Festa kuju ki Jesus kejẽn Topẽ jo ĩn ra tĩ mũ, ag kanhrãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kỹ ti vĩ tóg vẽnh kar mỹ e tĩ. “Estudo mág han ja tũ ti nĩ, hã ra tóg ki kanhró pẽ nĩ,” he ag tóg mũ ti to, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kỹ Jesus tóg ag mỹ: “isỹ ãjag mỹ Topẽ vĩ tó vẽ,” he mũ. “Inh jykre pijé'. Ũ tỹ inh jẽnẽg mũ ẽn jykre hã vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","“Ũ tỹ Topẽ vĩ ki króm sór mũ ag vỹ ki kanhró nỹtĩnh mũ, sỹ ãjag mỹ ti jykre tó mũ tag ti ki. Isỹ vẽsóg ki sỹ nén tónh ke to jykrén mũ pijé',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","“Ũ tỹ ã tỹ vẽsóg ki nén to jykrén mũ ẽn tó kỹ tóg tỹ ũn mág nĩ sór mũ. Hã ra sóg ũ tỹ inh jẽnẽg mũ ẽn to: “ũn mág vỹ tỹ ti nĩ,” he mũ. Hã kỹ ãjag tóg ki kanhró nỹtĩ, isỹ ki hã tó mũn ki. Inh pi(jé) vẽnh jykre vẽnhmỹ tó tĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés vỹ ãjag jyvẽn ja nĩgtĩ. Topẽ jykre to. Ãjag tỹ ne jé ti vĩ han tũ nĩ nẽ? Isỹ ti vĩ ki króm mũ ra ãjag tóg isén sór mũ',” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kỹ ũn e ẽn ag tóg ti mỹ: “krĩ vẽnhmỹ ã tóg nĩ.” he mũ. “Ã tén sór tũ ẽg nỹtĩ,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Hã ra Jesus tóg ag mỹ: “milagre pir han ja inh nĩ, vẽnhkán ke kurã ẽn ki, kỹ tóg ãjag mỹ e tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","“Vẽnhkán ke kurã ki ãjag tóg gĩr ag gré junun fár kym tĩ gé, Moisés tỹ ãjag mỹ: “ti mur pãte kurã tỹ 8 (ke) ki ti kym nĩ,” he ja nĩ ẽn kỹ. Hã ra ũ tỹ ã krẽ fár kym vén pi(jé) tỹ Moisés nĩ ja nĩ'. Ti jo ke ũ ja vẽ, ũ tỹ kym vén ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ãjag tỹ Moisés vĩ ki króm jé ãjag tóg vẽnhkán ke kurã ki gĩr fár kym tĩ. Hã ra ãjag tóg iso jũ sór mũ, isỹ vẽnhkán ke kurã ki ũn kaga pir tỹ há' hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ón kỹ ãjag tóg iso jũ sór mũ. Inh jykre vỹ ãjag mỹ kórég nĩ ve nĩ. Ãjag tỹ to jykrén há han mũ ra ãjag tóg inh jykre há nĩ venh mũ vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kỹ Jerusalém tá ke ag tóg Jesus to: “ti tén sór ja ag tóg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Hã ra tóg jatun mỹ vẽnh kar mré vẽmén jẽ nĩ. Ti mỹ ag tóg vĩ tũ nĩ, pã'i ag. Ag mỹ hẽn ri ke mũn ti to: “Cristo vỹ tỹ ti nĩ, Topẽ tỹ ũn jẽnẽg mũ vỹ tỹ ti nĩ,” he mũ vỹ, ẽg pã'i ag?” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Hã ra ẽg tóg ti tỹ hẽn tá kãtĩ mũ ki kanhró nỹtĩ. Cristo ẽn kãtĩg kỹ ẽg tóg ti tỹ hẽn tá kãtĩg mũ ki kagtĩg nỹtĩnh mũ, kỹ ti hỹn tỹ Cristo tũ nĩ,” he ag tóg mũ, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Hã ra Jesus tóg Topẽ jo ĩn tá jẽ nĩ, vẽnh kar kanhrãn kỹ. Kỹ tóg jamã hár(a) ag kanhrãn mũ. “Ti ki kanhró ẽg nỹtĩ, he ãjag tóg tĩ iso, ón kỹ,” he tóg. “Ti tỹ hẽn tá kãtĩ mũ ki kanhró ẽg tóg nỹtĩ gé, he ãjag tóg tĩ, ón kỹ. Inh pi(jé) vẽsóg ki: inh hỹn tĩg mũ, hé'. Ũ tỹ inh jẽnẽg mũ ẽn vỹ ki hã tó tĩ. Hã ra ãjag tóg ti ki kagtĩg nỹtĩ, ũ tỹ inh jẽnẽg mũ ẽn ti ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inh hã vỹ ti ki kanhró nĩ. Ti hã tá sóg kãtére, ãjag ve jé, ti tỹ inh mỹ: “ha ag venh tĩg,” hen kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kỹ ag tóg ti se sór mũ, hã ra ag tóg ti vóg tũ pẽ nĩ ver. Ti ter ke kurã vỹ jun ja tũ nĩ ver, hã kỹ ag tóg ag tỹ ti se sór mũ ra ti ség tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ag jãvo ũn e ag tóg Jesus ki ge mũ. Ti to ag tóg: “ẽg mỹ tóg tỹ Cristo nĩ ve nĩ,” he mũ. “Cristo kãtĩg kỹ ti nẽji milagre hyn han ke mũ. Jesus tỹ milagre hyn han vỹ e nỹtĩ. Ẽg mỹ tóg tỹ Cristo nĩ,” he ag tóg, Jesus to. Tag tó kỹ ag tóg ti ki ge mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kỹ Fariseu ag tóg mẽg mũ, ũn e ag tỹ Jesus to nén (ũ) tó mũ ti. Kỹ ag tóg Topẽ tũ ki rĩr tĩ to pã'i ag mré vẽmén mũ, ag tỹ Jesus senh ke to. Kỹ ag tóg polícia ag jẽnẽg mũ, ag tỹ ti se jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hã ra Jesus tóg: “ãjag mré sóg nĩ sĩ han ke mũ ver,” he mũ. “Tag pãte sóg tĩg ke mũ, isỹ ũ tỹ inh jẽnẽg mũ ẽn ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ẽn kã tóg ãjag tỹ inh venh há tĩnh mũ, hã ra ãjag tóg inh venh ke tũ nĩ. Ẽn tá junjun ke tũ ãjag tóg nĩ, isỹ hẽn ra tĩg ke ẽn tá,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kỹ Judeu ag tóg jagnẽ mỹ: “ti hỹn hẽ ra tĩg sór mũ?” he mũ. “Ẽg hỹn hẽ tá ti venh ke tũ nĩ? Ti hỹn hẽn ri ke mũn ga tỹ Grécia ra tĩg sór mũ, tá ẽg mré ke ag kanhrãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ne to ke nẽ, hỹn, hã vỹ: “ãjag tỹ inh venh há tóg tĩnh mũ, hã ra ãjag tóg inh venh ke tũ nĩ, he mũ tag ti?” he ag tóg, Judeu ag. Jesus vĩ vỹ ag mỹ e tĩ, hã kỹ ag tóg ki kagtĩg nỹtĩ, ti tỹ nén tó mũn ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Vãhã tóg festa tỹ kurã tỹ ẽgno tá krỹg mũ. Festa to kurã mág pẽ vẽ, kurã tỹ ẽgno ẽn ti, hã kỹ ag e tãvĩ nỹtĩ, Jerusalém tá. Kurã ẽn kã Jesus tóg jẽ kỹ vẽnh kar mỹ prẽr mũ sir. “!..Ãjag tỹ goj kron sór kỹ inh mỹ to vĩ, isỹ ãjag mỹ goj há ven jé..!” he tóg, prẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“!..Topẽ vĩ ki tag vỹ rán kỹ nĩ, ha mẽ: !..ãjag tỹ inh ki ge kỹ tóg ãjag kãki goj ror han ke mũ, isỹ ãjag mỹ goj nĩm ke ti..!” he tóg. “!..Kỹ goj tag vỹ ãjag rĩnrĩr pẽ han ke mo..!” he tóg, Jesus ti. Ti tỹ ag mỹ prẽr jan hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus tỹ ag mỹ Topẽ kuprĩg tón hã vẽ, hã to tóg: goj, he mũ. Topẽ kuprĩg tỹ tóg ag jagrẽn ke mũ, ũ tỹ ti ki ge mũ ag. Festa ẽn kã tóg ag mỹ ti jẽnẽ ja tũ nĩ ver, Topẽ kuprĩg ti, ti tỹ ver ã ter kar kỹ rĩr mãn ja tũ nĩn kỹ, ti tỹ ã panh ra tĩg mãn ja tũ nĩn kỹ ver. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kỹ Jesus vĩ mẽg mũ ũ ag tóg ti to: “Topẽ vĩ tó tĩ pẽ ẽn vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kỹ ũ ag tóg ti to: “Cristo vỹ tỹ ti nĩ, Topẽ tỹ ẽg mỹ ũn jẽnẽg mũ ẽn vỹ tỹ ti nĩ,” he tĩ gé. Hã ra ũ ag tóg: “Cristo mỹ hỹn ga tỹ Galiléia tá kãtĩ mũ vỹ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“Topẽ vĩ rá ki tóg: “Davi kósin vỹ tỹ ti nĩ, Cristo ti,” he mũ, “ẽmã tỹ Belém tá ke vỹ tỹ ti nĩ, Davi jamã ẽn tá ke,” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki. Hã kỹ tóg ẽg mỹ tỹ Cristo tũ nĩ, Jesus ti, ti tỹ tỹ Galiléia tá ke nĩn kỹ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hã kỹ ag tóg vẽnh kãpãm kỹ nỹtĩ, ti tugnĩn. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Kỹ ag kãmĩ ũ ag vỹ ti se sór mũ, hã ra ag tóg ti kãgmĩg tũ nĩgtĩ, ti kamẽg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kỹ polícia ag tóg Topẽ tũ ki rĩr tĩ to pã'i ag to vỹnvỹn ke mũ, Fariseu ag to ke gé, ũ tỹ ag jẽgnẽ ja ag to. Kỹ ag tóg ag mỹ: “hỹn, ti?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Kỹ ag tóg: “hã ra tóg vĩ há tãvĩ han mũ,” he mũ. “Vẽnh vĩ tỹ ge mẽ ja tũ ẽg nỹtĩ, hã kỹ ẽg tóg ti kãgmĩ ja tũ nĩ,” he ag tóg mũ, polícia ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kỹ Fariseu ag tóg ag mỹ: “kỹ ãjag mỹ ti vĩ kri nĩm sór mũ', ti ón mũ ra?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Pã'i ũ mỹ ti vĩ kri fig mũ'? Vó, ke tũ ẽg nỹtĩ. Fariseu ũ tỹ ti vĩ kri nĩm tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hã ra ag tóg ki kagtĩg nỹtĩ, ũ tỹ ti vĩ kri fig mũ ag. Topẽ vĩ rán ki kagtĩg ag nỹtĩ, kỹ Topẽ vỹ ag mỹ vĩ kónãn ke mũ, ha vemnĩ,” he ag tóg mũ, Fariseu ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hã ra Nicodemos vỹ ag mré nĩ gé, ũ tỹ kuty tá Jesus mré vẽmén ja ẽn ti. Ẽn tóg ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ẽg tỹ ti vóg kónãn sór kỹ ẽg tóg ti ki jẽmẽ vén ke mũ,” he mũ. “Ti tỹ nén han ja to jykrén há han jé ẽg tóg ke mũ, ẽg tỹ kar kỹ ti vóg kónãn jé. Topẽ tỹ ẽg mỹ vẽnh jykre nĩm jan hã vẽ,” he tóg, Nicodemos ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Hã ra ag tóg ti mỹ: “ã hỹn tỹ Galiléia tá ke nĩ gé', hã kỹ ã tóg ti jy nĩgãn sór mũ',” he mũ. “Topẽ vĩ ki ve há han nĩ, kỹ ã tóg venh ke mũ. Galiléia tá ke ũ vỹ Topẽ vĩ tónh ke tũ pẽ nĩ, Topẽ vỹ tá ke ũ jẽnẽnh ke tũ pẽ nĩ,” he ag tóg, Nicodemos mỹ. Kỹ ag tóg ãjag jamã ra mũ mũ sir, pã'i kar ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hã ra Jesus tóg pãnónh tỹ Oliveiras ra tĩ mũ, tá nũr jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kurã ke ra tóg Jerusalém ra tĩg mãn kỹ (tóg) Topẽ jo ĩn tá nĩ mãn mũ sir, kỹ vẽnh kar ag tóg ti vĩ mẽnh kãmũ mũ. Tá nĩ kỹ tóg ag kanhrãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kỹ Topẽ vĩ to professor ag vỹ ũn tỹtá fi pére kãmũ mũ, Fariseu ag ke gé. Ũn tỹtá ẽn fi ve ja ag tóg nĩ, fi tỹ fi mén tũ mré nỹn kỹ. Vẽnh kuju kã ag tóg fi fẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kỹ ag tóg Jesus mỹ: “Senhor,” he mũ. “Fi ve ẽg tóg, fi tỹ fi mén tũ mré nỹn kỹ,” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","“Moisés vỹ ẽg mỹ: “ãjag kãmĩ ũ fi tỹ fi mén tũ mré nỹn kỹ fi tén nĩ, pó tỹ fi pin kỹ,” he ja nĩ. Jo ã hỹn hẽ ri ke tĩ?” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ag tỹ ón kỹ ti vĩ mẽ sór vẽ, ag tỹ ti vĩ to ti se jé. Hã ra Jesus tóg pãnh ke kỹ nĩ kỹ ga kri rán mũ, ã nĩgé tỹ. Vĩ tũ tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hã ra ag tóg ti tovãnh sór tũ nĩ. Kỹ tóg vãhã ag ki ẽvãnh kỹ ag mỹ: “ãjag kãmĩ ũ hỹn Topẽ vĩ mranh ja tũ nĩ ver,” he mũ. “Ẽn hỹn fi pin vén ke mũ, pó tỹ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kỹ tóg pãnh ke mãn kỹ ga kri rán mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kỹ ti vĩ tóg ag mỹ e tĩ. Ag kar vỹ ãjag tỹ Topẽ vĩ mranh ja ẽn mĩ ẽkrég mũ sir, hã kỹ ag tóg mũ mũ sir. Ũn si há ag vỹ mũ vén mũ, kar kỹ vẽnh kar ag. Komẽr hã ag tóg mũ kãn mũ. Vãhã Jesus vỹ ã pir mỹ nĩ, fi mré. Fi hã vỹ tá jẽ nĩ, ti mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kỹ tóg fi ki ẽvãnh kỹ fi mỹ: “ag hẽ ra kagáv, ũ tỹ ã kato vĩ mũ ag?” he mũ. “Ag mỹ ã vóg kónãn tũ?” he tóg. Ag mũ kar kỹ tóg fi mỹ ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hã ra fi tóg ti mỹ: “hỹ,” he mũ. Kỹ tóg fi mỹ: “kỹ inh hỹn ã vóg kónãn ke tũ nĩ gé,” he mũ. “Ha tĩg, jatun mỹ. Hã ra Topẽ vĩ mranh mãn sór tũg nĩ,” he tóg, Jesus ti. Ũn tỹtá kórég ẽn fi vóg kónãn sór ja tũ ti nĩ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kỹ Jesus tóg Topẽ jo ĩn krẽm nĩ kỹ vẽnh kar kanhrãn mãn mũ. “Jẽngrẽ ri ke inh nĩ,” he tóg. “Ãjag tỹ inh mré mũn kỹ ãjag tóg kuty mĩ mũ tũ nĩgtĩ. Jẽngrẽ mĩ ãjag tóg mũgtĩ, kurã mĩ. Ãjag tỹ vẽnh jykre tãg han ke to ken hã vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Hã ra Fariseu ag tóg ti vĩ kafãn mũ, kỹ ag tóg ti mỹ: “vẽnh kãmén ã tóg mũ ha,” he mũ. “Ẽg tỹ vẽnh kãmén kỹ ẽg tóg ón kỹ vĩ tĩ,” he ag tóg mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Hã ra Jesus tóg ag mỹ: “hỹ,” he mũ. “Vẽnh kãmén inh tĩ, hã ra sóg ki hã tó tĩ,” he tóg mũ. “Isỹ hẽ tá kãtĩg mũ ẽn ki kanhró inh nĩ, isỹ hẽ ra tĩg ke mũ ti ke gé,” he tóg. “Hã ra ãjag tóg inh ki kagtĩg nỹtĩ, isỹ hẽ tá kãtĩg mũn ki, isỹ hẽ ra tĩg ken ki ke gé. Ẽprã ke ãjag nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kãnhmar ãjag tóg ũ to: “jykre kórég ti nĩ,” henh ke mũ. Ãjag jãvo sóg vẽnh kar jykre to nén ũ tó tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Isỹ hã ra ũ jykre to nén ũ tó sór mũ ra sóg tó há han ke mũ vẽ. Inh pi(jé) inh pir mỹ nén ũ to jykrén tĩ'. Ũ tỹ inh jẽnẽg mũ vỹ inh mré nén ũ kar to jykrén tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kỹ ũn régre ag tỹ vẽnh vĩ pir han kỹ tóg ãjag mỹ tỹ ki hã ke nĩ. Hã kỹ tóg rán kỹ nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Hã kỹ sóg vẽnh kãmén mũ, hã ra inh panh tóg, ũ tỹ inh jẽnẽg mũ tóg inh kãmén mũ gé. Régre ẽg nỹtĩ, ũ tỹ inh kãmén mũ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kỹ ag tóg ti mỹ: “hỹn, ã panh ti?” he mũ. Kỹ Jesus tóg ag mỹ: “ãjag pi(jé) inh ki kanhró nỹtĩ',” he mũ. “Hã kỹ ãjag tóg inh panh ki kagtĩg nỹtĩ gé,” he tóg. “Ãjag tỹ inh ki kanhró nỹtĩ ra ãjag tóg inh panh ki kanhró nỹtĩnh mũ vẽ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ti tỹ ag mỹ vẽnh kãmén hã vẽ. Topẽ jo ĩn krẽm nĩ kỹ tóg ag mỹ vẽnh kãmén mũ, ti tỹ jãnkamy vin jafã rã hã nĩn kỹ. Kỹ pã'i ag tóg ti se sór mũ, hã ra ag tóg ti kãgmĩg tũ nĩgtĩ, ag tỹ ti kamẽg kỹ. Ti ter ke kurã vỹ jun ja tũ nĩ ver, hã kỹ ag tóg ti tỹ hẽ ri ke tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Kỹ tóg ag mỹ kãmén mãn mũ. “Tĩg jé sóg ke mũ, kỹ ãjag tóg inh ve sór ke mũ, hã ra ãjag tóg inh venh ke tũ nĩ. Inh vég tũ ki ãjag tóg kãgter ke mũ, kỹ ãjag tỹ Topẽ vĩ mranh ja ẽn vỹ ãjag kãkã nĩ nĩ. Ãjag pi(jé) isỹ hẽn ra tĩg ke mũ ẽn ki kanhró nỹtĩ'. Isỹ hẽn ra tĩg ke mũ ẽn ki kagtĩg ãjag nỹtĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kỹ ag tóg jagnẽ mỹ: “ti mỹ hẽn ri ke mũn vẽsén sór mũ, hã kỹn mỹ: “ãjag pi(jé) isỹ hẽn ra tĩg ke mũ ẽn ki kanhró nỹtĩ',” he mũ?” he ag tóg, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hã ra Jesus tóg ag mỹ: “ẽprã ke vỹ tỹ ãjag nỹtĩ,” he mũ. “Jãvo sóg tỹ kanhkã tá ke nĩ. Ga tag ki ke tỹ ãjag nỹtĩ, jãvo inh pi(jé) tỹ ga tag ki ke nĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hã kỹ sóg ãjag mỹ: “kãgter jé ãjag tóg ke mũ, kỹ ãjag tỹ Topẽ vĩ mranh ja ẽn vỹ ãjag kãkã nĩ nĩ,” he ja nĩ. Ha vé, ãjag tỹ inh ki ge sór tũ nĩn kỹ tóg ãjag kãkã nĩnh ke mũ, ãjag tỹ Topẽ vĩ mranh ja ẽn ti. “Ũ ẽn vỹ tỹ inh nĩ,” he ja inh nĩ ãjag mỹ. Tag to: hỹ, hemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kỹ ag tóg ti mỹ: “tỹ ã ũ nĩ?” he mũ. Kỹ Jesus tóg: “vãsỹ sóg ãjag mỹ tó huri, isỹ ãjag mré vẽmén vén kỹ,” he mũ. “Ãjag mỹ sóg vẽnh kãmén tĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hã ra sóg ãjag mỹ tó kãn ja tũ nĩ ver, sỹ ãjag mỹ vĩ kónãn ke vỹ kã nĩ gé ver. Hã ra sóg ũ tỹ inh jẽnẽg mũ ẽn vĩ hã tó tĩ, ti tỹ inh mỹ tó ja kar ẽn ti. Ki hã tóg tó tĩ, ũ tỹ inh jẽnẽg mũ ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hã ra tóg ag tỹ to jykrén tũ nĩgtĩ, ti tỹ ag mỹ ã panh tó mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kỹ Jesus tóg ag mỹ ke mãn mũ. “Ãjag tỹ ka to isa kỹ, kỹ ãjag tóg inh ki kanhrãn ke mũ,” he tóg. “Tỹ sóg ẽprã ke fi kósin nĩ. Kurã ẽn kã ãjag tóg ki kanhró nỹtĩnh ke mũ, isỹ tỹ ũn ẽn nĩ ti. Inh pi(jé) vẽsóg ki nén ũ to jykrén tĩ'. Inh panh tỹ inh mỹ nén tó mũ ẽn hã tó sóg tĩ. Hã ki kanhró ãjag nỹtĩnh ke mũ, kurã ẽn kã, ãjag tỹ ka to isa kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kỹ ũ tỹ inh jẽnẽg mũ vỹ inh mré nĩ nĩ. Ti mỹ nén há nĩ ẽn hã han sóg tĩ, hã kỹ tóg inh mré nĩ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ag tỹ ti vĩ tag mẽ kỹ ũn e ag vỹ ti ki ge mũ, kurã ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kỹ Jesus tóg ũ tỹ ti ki ge kỹ nỹtĩ ag kanhrãn mũ. “Inh vĩ tovãnh tũg nĩ,” he tóg. “Kỹ ãjag tóg tỹ inh mré ke pẽ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kỹ ãjag tóg Topẽ vĩ pẽ ki kanhró nỹtĩnh mũ. Topẽ vĩ pẽ ki kanhró tugrĩn ãjag tóg patrão kórég ve mãn ke tũ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kỹ ag tóg ti mỹ: “Abraão krẽ'krẽ vỹ tỹ ẽg nỹtĩ,” he mũ. “Ẽg pi(jé) tỹ ũ camarada nỹtĩ', ũri, vãsỹ ke gé. Ne to ke nẽ, hã vỹ: patrão kórég ve mãn ke tũ ãjag nĩ, he mũ tag ti?” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Hã ra Jesus tóg ag mỹ: “ki hã sóg ke mũ, hã kỹ sóg tó mũ,” he mũ. “Ãjag tỹ Topẽ vĩ mranh kỹ ãjag tóg tỹ ti vĩ mranh jafã nỹtĩ, kỹ tóg ẽg tỹ ũn kórég tỹ patrão vég mũ ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ti camarada ag pi(jé) ti ĩn krẽm ẽmã nỹtĩgtĩ'. Ti kósin hã vỹ ti ĩn krẽm nĩgtĩ jãvo. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kỹ, Topẽ kósin tỹ ãjag tỹ Topẽ krẽ han kỹ ãjag tóg patrão kórég ve mãn ke tũ nĩ ha. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraão krẽ vỹ tỹ ãjag nỹtĩ. Ki kanhró inh nĩ. Hã ra ãjag tóg isén sór mũ, ãjag tỹ inh vĩ to há tũ nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Inh panh tỹ inh mỹ nén tó mũ ẽn hã tó sóg tĩ. Inh jãvo ãjag tóg ãjag panh tỹ ãjag mỹ nén tó mũ ẽn hã tó tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kỹ ag tóg ti mỹ: “hỹ, Abraão vỹ tỹ ẽg panh nĩ,” he mũ. Kỹ Jesus tóg ag mỹ: “ãjag tỹ tỹ Abraão krẽ nỹtĩn kỹ ti jykre han nĩ ge,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","“Hã ra ãjag tóg isén sór mũ. Ãjag mỹ sóg Topẽ vĩ pẽ tó ja nĩ, Topẽ tỹ inh mỹ nén tó mũ ẽn ti, hã ra ãjag tóg isén sór mũ. Abraão vỹ tag han ja tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Vyrmỹ ãjag panh ũ tũ hã han ãjag tóg tĩ,” he tóg. Kỹ ag tóg Jesus mỹ: “panh ẽg nỹtĩ, hã vỹ: Topẽ, he mũ. Ẽg pi(jé) panh tũ nỹtĩ',” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Hã ra Jesus tóg ag mỹ: “Topẽ tỹ tỹ ãjag panh nĩ ra ãjag tóg iso há nỹtĩnh mũ vẽ,” he mũ. “Inh panh tá sóg kãtére, hã kỹ sóg ãjag mré nĩ nĩ. Inh pi(jé) vẽsóg ki nén to jykrén kỹ kãtére mũ'. Ti hã vỹ inh jẽnẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hã ra ãjag tóg inh vĩ ki kagtĩg nỹtĩ. Mẽ sór tũ ãjag nỹtĩ, hã kỹ ãjag tóg ki kagtĩg nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Japo krẽ vỹ tỹ ãjag nỹtĩ, kỹ ãjag tóg ti tỹ nén to jykrén mũ ẽn han tĩ. Topẽ tỹ ẽprã ke ag han ẽn kã tóg ag kãgtén sór tĩgtĩ, Japo ti. Vãsỹ ti jykre vẽ, kỹ tóg ũri tỹ ti jykre nĩ gé ver. Ti pi(jé) ki hã tó tĩ'. Ki hã tó to ti kórég pẽ nĩ, Japo ti. Vẽnh ó vỹ tỹ ti tũ pẽ nĩ. Ón mẽ ti nĩgtĩ, vẽnh ón né vẽ. Ti hã vỹ tỹ ũn ón mũ ag panh kar nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ti jãvo sóg ki hã tó tĩ. Hã ra ãjag tóg inh vĩ kri nĩm sór tũ nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inh hỹ ne ki Topẽ vĩ mranh? Ha inh mỹ tó. Mranh ja tũ sóg nĩ. Hã ra sóg ãjag mỹ Topẽ vĩ pẽ tó tĩ. Ãjag hẽ ri ken kỹ inh vĩ kri fi sór tũ nĩ? ");
INSERT INTO kgpNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Topẽ krẽ ag vỹ Topẽ vĩ mẽg tĩ. Ãjag pi(jé) inh vĩ jẽmẽ sór tĩ', ãjag tỹ tỹ Topẽ krẽ tũ nỹtĩn kỹ,” he tóg, Jesus ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kỹ Judeu ag tóg ti mỹ: “Samaria tá ke ri ke ã tóg nĩ, ã tỹ ki kagtĩg nĩn kỹ, kỹ ã jagrẽ kórég nĩ gé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Hã ra Jesus tóg ag mỹ: “inh pi(jé) jagrẽ kórég nĩ',” he mũ. “Inh panh to sóg: ũn mág vỹ tỹ ti nĩ, he tĩ. Hã ra ãjag tóg iso é he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Inh pi(jé) vẽsỹ ũn mág han sór mũ'. Ũ tỹ isỹ ũn mág han ke mũ vỹ nĩ nĩ, ẽn vỹ vẽnh kar jykre tugnỹm ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ki hã sóg ke mũ, hã kỹ sóg tó mũ, ha mẽ. Ãjag tỹ inh vĩ kri fi kỹ ãjag ter ke tũ pẽ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kỹ Judeu ag tóg ti mỹ: “jagrẽ kórég ã tóg nĩ,” he mũ. “Vãhã tóg ve há tĩ, ã jagrẽ kórég ti,” he ag tóg mũ ti mỹ. “Abraão vỹ ter, kỹ Topẽ vĩ tó tĩ ag kar vỹ kãgter. Hã ra ã tóg ón kỹ: “ãjag tỹ inh vĩ kri nĩm kỹ ãjag kãgter ke tũ pẽ nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ã mỹ vẽsỹ ẽg jóg'jóg ve tỹ Abraão kãfór han sór mũ', ã tỹ ẽg mỹ: kãgter ke tũ ãjag nĩ, hen kỹ? Ter ja ti nĩ, Abraão ti, kỹ Topẽ vĩ tó tĩ ag kar vỹ kãgter kãn gé. Vẽsỹ ũn mág han kỹ nĩ ve ã tóg nĩ,” he ag tóg, Jesus mỹ, Judeu ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kỹ Jesus tóg ag mỹ: “isỹ vẽsỹ ũn mág han kỹ sóg ón kỹ ke mũ ve nĩ,” he mũ. “Hã ra inh panh hã vỹ isỹ ũn mág han ke mũ, ãjag tỹ ũ to: ẽg jóg mág, he mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hã ra ãjag tóg ti ki kagtĩg nỹtĩ, ãjag jãvo sóg ti ki kanhró nĩ. Isỹ ãjag mỹ: “ti ki kagtĩg inh nĩ,” he mũ ra sóg ãjag ón tag ri ke han mũ vẽ, hã ra sóg ti ki kanhró nĩ, kỹ sóg ti vĩ ki króm tĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ãjag jóg'jóg ve tỹ Abraão vỹ inh kurã ve sór ja nĩ, kỹ tóg kejẽn vé, kỹ tóg ti mỹ sér pẽ tĩ, ti tỹ inh kurã ve kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kỹ Judeu ag tóg ti mỹ: “50 (ke) anos han tũ ã nĩ ver, hã ra ã tóg: “Abraão ve inh,” he mũ. Vĩ vẽnhmỹ han ã tóg,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Hã ra Jesus tóg ag mỹ: “ki hã sóg ke mũ, hã kỹ sóg tó mũ, ha mẽ,” he mũ. “Abraão mur tũ ra sóg nĩ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kỹ ag tóg jũgjũ mũ, ti tỹ vẽso: “Topẽ ri ke inh nĩ,” hen kỹ. Hã kỹ ag tóg pó mãn kỹ ti pin sór mũ. Hã ra Jesus tóg Topẽ jo ĩn kãtá kãkutẽ mũ sir, kỹ tóg tĩ mũ, vẽnh péju jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kejẽn Jesus tóg tĩg kỹ ũn kyvó vég mũ. Ã mur mũn kã tóg kyvó nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kỹ ti mré mũ tĩ ag tóg ti mré ti vég mũ gé. Kỹ ag tóg Jesus mỹ: “ti han mũ fag hỹn Topẽ vĩ mranh',” he mũ, “ha kỹ tóg kyvó nĩ',” he ag tóg. “Ti tỹ vẽsóg ki Topẽ vĩ mranh kỹn mỹ kyvó nĩ vó?” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Kỹ Jesus tóg ag mỹ: “ti tỹ Topẽ vĩ mranh to ke pijé',” he mũ. “Ti han mũ fag tỹ Topẽ vĩ mranh to ke pijé',” he tóg. “Topẽ tỹ vẽnh kar mỹ ã tỹ nén han sór mũ ẽn ven sór vẽ, ti ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Isỹ ũ tỹ inh jẽnẽg mũ ẽn tỹ inh mỹ nén tó mũ ẽn han sór vẽ. Ver tóg inh mỹ kurã nĩ, sỹ rãnhrãj jé. Kãnhmar tóg kuty nỹnh mũ, kỹ ũ tóg rãnhrãj mãn ke tũ nĩ, iser ke kurã ẽn kã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","“Ver sóg ãjag mré tĩg mũ, kỹ sóg ãjag mỹ jẽngrẽ ri ke nĩ ver,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tag tó kar kỹ tóg sug mũ, ga kri, kỹ tóg óré sĩ han mũ. Óré ẽn tỹ tóg ũn kyvó kanẽ to tĩn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Kỹ tóg ti mỹ: “ha tĩg, goj tỹ Siloé ki vẽnh kype jé,” he mũ. Goj tỹ Siloé to ke hã vỹ: “ũ tỹ inh jẽnẽ ja,” he mũ, ẽg vĩ ki. Kỹ tóg tĩ mũ, ũn kyvó ti. Kỹ tóg tá kãtĩg kỹ ẽvãnh há han tĩ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ti tỹ ẽvãnh há han kỹ tóg ti rã hã nỹtĩ kar ag mỹ e tĩ. Vẽnh kar vỹ ti ki kanhró nỹtĩ, vẽnh kar mỹ tóg: “inh mỹ nén ũ nĩm,” he tĩ ja nĩgtĩ. Kỹ ag tóg, ag tỹ ti ẽvãnh há tag ve kỹ (ag tóg) ti to: “ũ tỹ ẽg mỹ: inh mỹ nén ũ nĩm, he tĩ ẽn hã tũ mỹ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Kỹ ag kãmĩ ũ tóg: “ti hã vẽ,” he mũ. Hã ra ũ ag tóg: “ẽn ri ke nĩ ve ti nĩ, hã ra tóg ẽg mỹ tỹ hã tũ nĩ,” he mũ gé. Hã ra tóg vẽso: “inh hã vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kỹ ag tóg ti mỹ: “kỹ ã hẽ ri ké, ã tỹ ẽvãnh há' he jé?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kỹ tóg ag mỹ: “ag tỹ ũ to: Jesus, he mũ ẽn vỹ óré han, kỹ tóg inh kanẽ to tĩn, kỹ tóg inh mỹ: “goj tỹ Siloé ra tĩg nĩ, tá vẽnh kupemnĩ,” hé. Kỹ sóg vyr. Vẽnh kupe sóg, kỹ sóg ẽvãnh há' he mũ sir,” he tóg, ũn kyvó ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kỹ ag tóg ti mỹ: “ti hẽ kã jẽ?” he mũ. Hã ra tóg ag mỹ: “ha'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kỹ ag tóg Fariseu ag mỹ ti pére mũ mũ, ũn kyvó ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hã ra tóg tỹ vẽnhkán ke kurã nĩ. Ẽn kã Jesus tóg óré han kỹ ti tỹ há' hé. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kỹ Fariseu ag tóg ti ki jẽmẽ sór mũ gé. “Ã hẽ ri ké, ã tỹ ẽvãnh há' he jé?” he ag tóg mũ gé. Kỹ tóg ag mỹ: “óré tỹ tóg inh kanẽ to tĩn, kỹ sóg vẽnh kupenh vyr, kỹ sóg ẽvãnh há' he mũ sir,” he mũ, ag mỹ, ũn kyvó ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kỹ Fariseu ũ ag tóg Jesus to: “Topẽ pi(jé) ti jẽnẽ',” he mũ. “Vẽnhkán ke kurã ki tóg vẽnhkán vãnh nĩgtĩ, kỹ tóg kórég nĩ,” he ag tóg mũ, Jesus to, Fariseu ũ ag. Hã ra ũ ag tóg ti to: “hã ra tóg nén ũ há tãvĩ han,” he mũ gé. “Ti kórég nĩ ran hỹn tag han ki kagtĩg nĩnh mũ vẽ,” he ag tóg, Fariseu ũ ag. Hã kỹ ag vẽnh kãpãm kỹ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kỹ ag tóg ũn kyvó ja ẽn ki jẽmẽ mãn mũ. “Ti mỹ tỹ ũn há nĩ', ũn kórég mỹ vó?” he ag tóg mũ. “Ã tỹ tóg há' hé mỹr,” he ag tóg. Kỹ tóg ag mỹ: “inh mỹ tóg tỹ Topẽ vĩ tó jafã nĩ,” he mũ, ũn kyvó ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Hã ra ag tóg ti vĩ kri nĩm sór tũ nĩ. “Ti mỹ kyvó ja nĩ vỹ?” he ag tóg mũ. Kỹ ag tóg ti han mũ fag jé prẽr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kỹ ag tóg fag mỹ: “ãjag kósin hã mỹ'?” he mũ. “Ti mỹ ã mur mũn hã kã kyvó ja nĩ? Kỹn hỹn hẽ ri ké, ti tỹ ũri ẽvãnh há nĩn jé?” he ag tóg mũ, ti han mũ fag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kỹ fag tóg: “hỹ, ẽg kósin hã vẽ,” he mũ. “Ã mur mũn hã kã tóg kyvó ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Hã ra tóg ũri ẽvãnh há nĩ. Hẽ ri ken kỹ'? Ha'? Ũ nỹ ti han'? Ha ti ki jẽmẽmnĩ. Sanh há ti nĩ ha. Ãjag mỹ ti tónh mũ,” he fag tóg, ti han mũ fag. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Hã ra fag tóg pã'i ag kamẽg mũ, hã kỹ fag tóg: “ha ti ki jẽmẽmnĩ,” he mũ. Pã'i ag vỹ tag tó ja nĩ, Jesus to: “ãjag kãmĩ ũ tỹ ti to: “Cristo vỹ tỹ ti nĩ,” hen kỹ ẽg ti kutẽm ke mũ,” he mũ, “ti tỹ tỹ ẽg mré ke tũ nĩ jé, ti tỹ ẽg mré vẽnhmãn tũ nĩ jé, ẽg vẽnh kanhrãn jafã krẽm,” he ja ag tóg nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hã kỹ ũn kyvó ja ẽn han mũ fag vỹ Jesus to nén ũ tó sór tũ nĩ, hã kỹ fag tóg pã'i ag mỹ: “sanh há ti nĩ ha, ãjag mỹ ti tónh mũ,” he mũ, fag kósin kyvó ja ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kỹ ag tóg ũn kyvó ja ẽn jé prẽr mãn mũ. Kỹ ag tóg ti mỹ: “ker ón hẽ', Topẽ vỹ ã vĩ mẽg mũ,” he mũ. “Ũ tỹ ã tỹ há' he mũ ẽn vỹ kórég nĩ, Topẽ vĩ mranh ti tĩ,” he ag tóg mũ ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kỹ tóg: “mẽ',” he mũ. “Ti mỹ Topẽ vĩ mranh tĩ'? Sỹ ki kagtĩg tóg tĩ. Nén ũ pir hã ki kanhró sóg nĩ. Kyvó inh vẽ vẽ, hã ra sóg ẽvãnh há nĩ ha,” he tóg, ũn kyvó ja ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kỹ ag tóg ti mỹ: “ti hẽ ri ké, ã tỹ há' he jé?” he mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Hã ra tóg ag mỹ: “ãjag mỹ inh hur tó, hã ra ãjag tóg mẽ sór tũ nĩ,” he mũ. “Ãjag tỹ ne jé mẽ mãn sór nẽ? Ãjag mỹ ti mré mũ sór mũ gé?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kỹ ag tóg ti nyg mũ. “Ã hã vỹ tỹ ti mré ke nĩ,” he ag tóg mũ. “Jãvo ẽg tóg tỹ Moisés mré ke nỹtĩ,” he ag tóg, pã'i ag, ũn kyvó ja ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","“Topẽ vỹ Moisés mré vẽmén ja nĩ, tag ki kanhró ẽg tóg nỹtĩ. Hã ra ẽg pi(jé) ẽn ki kanhró nỹtĩ'. Ti hỹn tỹ hẽ tá ke nĩ'?” he ag tóg, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kỹ ũn kyvó ja ẽn tóg ag mỹ: “mẽ',” he mãn mũ. “Ãjag mỹ ti ki kagtĩg nỹtĩ, ti tỹ tỹ hẽ tá ke nĩn ki? Isỹ tóg há' hé mỹr, inh kanẽ tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hã ra Topẽ tóg ẽg vĩ mẽg tũ nĩgtĩ, ẽg tỹ tỹ ti vĩ mranh jafã nỹtĩn kỹ. Ũ tỹ Topẽ kamẽg mũ ẽn vĩ hã mẽg ti tĩ. Ũ tỹ ti vĩ ki króm mũ ẽn vĩ hã mẽg ti tĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Inh mur mũ kã inh kyvó nĩ ja nĩ. Ũ tỹ ge tỹ há' he mũ tag ve ja tũ inh nĩ ver. Hã ra tóg isỹ há' hé. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ti tỹ Topẽ tá kãtĩg tũ ra tóg nén ũ há han ki kagtĩg nĩ vẽ,” he tóg, ũn kyvó ja ti, pã'i ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Hã ra ag tóg ti mỹ: “Topẽ vĩ mranh kỹ ã tóg mur, hã ra ã tóg ẽg kanhrãn sór mũ',” he mũ. Kỹ ag tóg ti kutẽm mũ, vẽnh kanhrãn jafã krẽm. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Hã ra Jesus tóg mẽg mũ, ag tỹ ti kutẽm ja ti. Kỹ tóg ti venh tĩ mũ. Kỹ tóg ti mỹ: “ã mỹ ẽprã ke fi kósin ẽn ki rã sór tũ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kỹ tóg Jesus mỹ: “kỹ ũn nẽ ge?” he mũ. “Sỹ ti ki rã sór vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kỹ Jesus tóg ti mỹ: “ti ve ã huri,” he mũ. “Ũ tỹ ã mré vẽmén jẽ mũ hã vỹ tỹ ti nĩ, inh hã vỹ tỹ ti nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kỹ ũn kyvó ja tóg ti mỹ: “Senhor,” he mũ. “Ã ki rã kỹ inh jẽ nĩ,” he tóg. Kỹ tóg ti krẽm mũg ke mũ, Jesus krẽm, ti mỹ: “Topẽ kósin vỹ tỹ ã nĩ,” he jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kỹ Jesus tóg ti mỹ: “ga tag ki sóg jun, sỹ vẽnh kar jykre tugnỹm jé,” he mũ. “Ũn kyvó ag tỹ ẽvãnh há han jé sóg ke mũ. Ag tỹ iso jykrén há han ke to ken hã vẽ. Kỹ sóg ũ tỹ ve há han mũ ag kyvó han ke mũ gé. Ag tỹ iso jykrén há han ki kagtĩg to ken hã vẽ,” he tóg, Jesus ti, ũn kyvó ja ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hã ra Fariseu ũ ag tóg ti vĩ mẽg mũ. Kỹ ag tóg ti mỹ: “kỹ ẽg mỹ kyvó nỹtĩ gé'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kỹ Jesus tóg ag mỹ: “ãjag tỹ: kyvó ẽg nỹtĩ, ki kagtĩg ẽg nỹtĩ,” he mũ hã ra Topẽ tóg ãjag to jũ tũ nĩ ver. Hã ra ãjag tóg vẽso: “ẽvãnh há ẽg nỹtĩ, ki kanhró ẽg nỹtĩ,” he tĩ. Hã kỹ ãjag tỹ Topẽ vĩ mranh ja vỹ ãjag kãkã nĩ nĩ,” he tóg, Jesus ti, Fariseu ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kỹ Jesus tóg ag mỹ vẽnh kãmén mãn mũ. “Ki hã sóg ke mũ, hã kỹ sóg tó mũ,” he tóg. “Ẽg tỹ ẽg mẽg tỹ carneiro jy ró han kỹ ẽg tóg ti jãnkã ra rã tĩ. Jãvo ũ tóg kejẽn ró to tãpry kỹ pãte rã sór tĩ. Ti tỹ carneiro péju sór vẽ, hã kỹ tóg ró to tãpry kỹ pãte rã sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ti jãvo ũ tỹ carneiro ki rĩr tĩ vỹ jãnkã ra rã mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jãnkã ki rĩr tĩ ẽn vỹ ti mỹ ró nón tĩ, jãnkã ti. Kỹ tóg carneiro jygji tó kãn mũ sir. Ti vĩ ki kanhró fag nỹtĩ, ti mẽg tỹ carneiro fag. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kỹ tóg fag jo tĩ mũ, re ra. Kỹ tóg ã mẽg fag jé prẽr kãn mũ sir, kỹ fag tóg pa kãn mũ, ũ tỹ carneiro ki rĩr tĩ ẽn mẽg fag. Kỹ tóg fag jo tĩ mũ, kỹ fag tóg ti nón mũ mũ sir, ti mẽg fag, fag tỹ ti vĩ ki kanhró nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Fag pi(jé) ũ nón mũnh ke mũ', fag tỹ ũn ki kagtĩg nón. Ũ jo fag vẽnh pigjunh ke mũ, fag tỹ ũn ki kagtĩg ẽn jo. Fag pi(jé) ti vĩ ki kanhró nỹtĩ', hã kỹ fag tóg ti jo vẽnh pigjunh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus tỹ ag mỹ comparação han vẽ. Ti mỹ ẽg tóg vẽnh mẽg tỹ carneiro ri ke nỹtĩ, ẽg tỹ ti nón mũn kỹ. Hã ra Fariseu ag tóg ti vĩ to jykrén tũ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Hã ra Jesus tóg ag mỹ kãmén mãn mũ. “Ki hã sóg tó mũ, hã kỹ sóg ke mũ,” he tóg. “Carneiro jy ró jãnkã ri ke inh nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","“Ũ tỹ inh jo kãmũ ag vỹ tỹ carneiro pigju(g) tĩ ag nỹtĩ ja nĩgtĩ, ũn jũ (ka)mẽ ag nỹtĩ ja nĩgtĩ. Hã ra carneiro fag vỹ ag vĩ mẽ ja tũ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inh hã vỹ fag mỹ jãnkã ri ke nĩ. Ũ tỹ inh ki rã mũ vỹ kren ke mũ, kỹ tóg ti tỹ jãnkã ra rã ri ke nĩ. Kỹ tóg kãra rã tĩ, kar kỹ tóg kãkutẽ tĩ gé, ti tỹ vẽjẽn ve kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Vẽnh mẽg tỹ carneiro pigju(g) tĩ ẽn vỹ carneiro pigju hã jé kãtĩ tĩ, fag kãgtén jé, fag kókén jé. Ti jãvo sóg fag ki rĩnrĩr há han hã jé kãtĩg, fag tỹ jagtar tũ nỹtĩ jé, fag mỹ sér tĩ jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ũ tỹ carneiro ki rĩr tĩ ri ke inh nĩ gé, ũn tỹ ki rĩr há ri ke inh nĩ. Ũ tỹ carneiro ki rĩr há han mũ vỹ ã mẽg jagfy ter ke mũ, fag krenkren jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kỹ ũ camarada vỹ tag ri ke tũ nĩgtĩ. Mĩg kamẽg jé tóg ke mũ, kỹ tóg mĩg ve kỹ vẽnhvãg tĩnh ke mũ, ã patrão mẽg tovãnh kỹ, ti camarada ti. Kỹ mĩg vỹ fag kugmĩnh ke mũ, kỹ fag tóg vẽnh kãpugpóv ke mũ gé, mĩg tugrĩn, carneiro fag. Ti camarada mẽg pi(jé)', ti patrão mẽg vẽ, hã kỹ tóg fag jy nĩgãn há han tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mĩg ve kỹ tóg vẽnh vãg tĩ mũ. Jãnkamy hã to tóg rãnhrãj jẽ nĩ, hã kỹ tóg mĩg kamẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ti jãvo sóg carneiro ki rĩr há han tĩ. Inh mẽg ki kanhró sóg nĩ, kỹ fag tóg inh ki kanhró nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ri ke ti nĩ gé, inh panh mré. Inh ki kanhró tóg nĩ, kỹ sóg ti ki kanhró nĩ gé. Kỹ sóg inh mẽg jagfy ter ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Inh mẽg ũ vỹ nỹtĩgtĩ gé ver, inh mẽg tỹ hẽ tá ke fag. Ãjag povo kãmĩ ke pijé'. Ẽn jé prẽr jé sóg ke mũ gé, kỹ fag tóg inh mré kãmũnh ke mũ gé. Inh vĩ mẽ jé fag ke mũ gé. Inh mẽg tỹ tag ki fag mré ke vỹ tỹ fag nỹtĩnh mũ. Fag kar jy sóg ró pir han ke mũ, inh mẽg kar jy, kỹ sóg inh pir mỹ fag ki rĩr ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Inh panh vỹ iso há nĩ, isỹ inh mẽg jagfy ter ken kỹ, kar kỹ sóg rĩr mãn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Iser sór tũ ra ũ pi(jé) isén ke mũ vẽ'. Hã ra sóg fag jagfy ter sór mũ. Iser sór kỹ sóg ter ke mũ. Inh rĩr mãn sór kỹ sóg rĩr mãn ke mũ gé, iser kar kỹ. Inh panh tỹ inh mỹ nén tó mũn hã vẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judeu ag tỹ ti vĩ tag mẽ kỹ ag tóg vẽnh kãpãm kỹ nỹtĩ mãn mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ũn e tóg ti to: “jagrẽ kórég ti nĩ, krĩ vẽnhmỹ ti nĩ, ti vĩ mẽ sór tũg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Hã ra ũ ag tóg: “ũn pi(jé) ã jagrẽ kórég hã ra vẽnh vĩ há tó tĩ',” he mũ. “Ũn kyvó tỹ há' he ki kagtĩg tóg nĩ gé, ũn jagrẽ kórég ti,” he ag tóg mũ, Judeu ũ ag, ũ tỹ Jesus to há nỹtĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kejẽn tóg Judeu ag tỹ festa há' ũ tá krỹg mũ. Vãsỹ ũ tỹ Judeu ag kato vãsãnsãn mũ ag vỹ Topẽ jo ĩn kókén ja nĩgtĩ, hã ra Judeu ag tóg kejẽn ti ĩn han mãn. Ag tỹ ĩn han mãn to festa hã vẽ sir. Prỹg kar ki ag tóg festa ẽn han tĩ. Kusãg mũ ẽn kã ke ja vẽ, festa ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hã ra Jesus tóg venh tĩg ja nĩ, kỹ tóg Topẽ jo ĩn mĩ pasa ke tĩ nĩ, Salomão tỹ jãnkã ẽn tá. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kỹ Judeu ag tóg ti venh kãmũ mũ, ag tỹ ón kỹ ti ki jẽmẽ jé. “Ã hẽ ri ke kã ẽg mỹ vẽnh kãmén há han ke mũ'?” he ag tóg mũ. “Ã mỹ tỹ Cristo nĩ? Topẽ tỹ ẽg mỹ ũn jẽnẽnh ke mũ ẽn mỹ tỹ ã nĩ'? Ha ẽg mỹ tó há han,” he ag tóg mũ, ón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Hã ra Jesus tóg ag mỹ: “ãjag mỹ sóg hur tó, hã ra ãjag tóg kri nĩm sór tũ nĩ,” he mũ. “Milagre hyn han sóg tĩ gé, inh panh tỹ inh mỹ nén tó ja ẽn. Ẽn ve kỹ ãjag tóg inh ki kanhró nỹtĩnh mũ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Hã ra ãjag tóg kri fi sór tũ nỹtĩ. Ãjag pi(jé) inh mẽg tỹ carneiro ri ke nỹtĩ', hã kỹ ãjag tóg kri nĩm sór tũ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Inh mẽg fag vỹ inh vĩ mẽg tĩ, fag ki kanhró sóg nĩ, hã kỹ fag tóg inh mré mũgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Fag jagfy sóg ter ke mũ, kỹ fag tóg kãgter ke tũ nĩ. Mĩg vỹ fag kugmĩnh ke tũ pẽ nĩ gé, isỹ fag jy nĩgãn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Inh panh tỹ inh mỹ fag vin mũn hã vẽ, inh mẽg fag. Hã ra tóg vẽnh kar kãfór nĩ, inh panh ti. Kỹ ũ pi(jé) inh panh tũ ag péju(g) tĩ', ti tỹ tỹ vẽnh kar kri ke nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inh panh mré sóg tỹ ũn pir nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ag tỹ ti vĩ tag mẽ kỹ ag tóg pó tỹ hẽn ri ke mãg mũ sir, Judeu ag, ag tỹ tỹ ti pin kỹ ti tén jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Hã ra Jesus tóg ag mỹ: “nén ũ há hã hyn han ja inh nĩ,” he mũ. “Inh panh tỹ inh mỹ: “tag han ra,” he ja ẽn hã han inh tĩ. Sỹ nén han ja tỹ hẽ nỹ hỹn ãjag mỹ kórég nĩ', hã kỹ ãjag tóg isén sór mũ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Hã ra ag tóg ti mỹ: “ẽg pi(jé) nén ũ há to ã tén sór mũ',” he mũ. “Ẽprã ke vỹ tỹ ã nĩ, ẽg mré ke vỹ tỹ ã nĩ, hã ra ã tóg vẽso: “Topẽ kósin vỹ tỹ inh nĩ,” he mũ. Ã tỹ Topẽ to vĩ kónãn hã vẽ. Tag to ẽg tóg ã tén ke mũ, pó tỹ ã pin kỹ,” he ag tóg mũ, Judeu ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kỹ Jesus tóg ag mỹ: “Topẽ vĩ tỹ rán kỹ nĩ ki tag vỹ rán kỹ nĩ, ha mẽ,” he mũ. “Topẽ vỹ ẽprã ke ag to: “Topẽ ri ke ãjag nỹtĩ,” he tĩ,” he tóg, Topẽ vĩ rá ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kỹ tóg ũ tỹ ti vĩ mẽg mũ ẽn ag mỹ: “Topẽ ri ke ãjag nỹtĩ,” he ja nĩ, Topẽ ti. Hã ra tóg ón tũ nĩgtĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Hã kỹ tóg vẽnhmỹ tũ nĩ gé, sỹ ãjag mỹ: Topẽ kósin vỹ tỹ inh nĩ, hen kỹ. Inh panh vỹ inh kuprẽg, kỹ tóg inh jẽnẽ gé, isỹ ãjag tá jun jé. Topẽ to vĩ kónãn pijé', sỹ nén tó mũ tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Isỹ inh panh vĩ ki króm tũ nĩ ra tóg há nĩnh mũ vẽ, ãjag tỹ inh vĩ kri nĩm sór tũ nỹtĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Hã ra sóg ti vĩ ki króm tĩ. Kỹ inh vĩ tỹ ãjag mỹ kórég nĩn kỹ isỹ milagre hyn han mũ ẽn vemnĩ. Isỹ milagre hyn han mũ ki tóg ve há tĩ, isỹ inh panh ri ke nĩ ti, kỹ inh panh vỹ inh ri ke nĩ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Kỹ ag tóg ti vĩ to ti se sór mãn mũ sir, hã ra tóg kren mãn mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kỹ tóg vẽnh péju kỹ tĩ mũ, goj tỹ Jordão mãra, Jesus ti. João vỹ ẽn tá vẽnh kar kygpég jẽ ja nĩgtĩ, ti tỹ ag kygpe vén kỹ. Ẽn ra tóg tĩ mũ sir, Jesus ti, kỹ tóg tá nĩ nĩ, ã mré mũ tĩ ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kỹ ũ tỹ hẽn ri ke ag vỹ tá ti venh kãmũ mũ. Jesus to ag tóg jagnẽ mỹ: “ha vé, João vỹ milagre han ja tũ nĩ,” he mũ. “Hã ra tóg Jesus kãmén. Tó há han ja tóg nĩ, João ti. Ki hã tóg tó ja nĩ, ti tỹ ẽg mỹ Jesus to nén tó mũ ti,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kỹ tá ũ tỹ hẽn ri ke ag tóg ti ki ge mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kejẽn ũ tỹ Jesus to há ũ tóg kaga nỹ nĩ, cidade tỹ Betânia tá. Ũn kaga ẽn jyjyn hã vỹ: Lázaro, he mũ. Ti ve fi vỹ tỹ Maria fi nĩ, Marta fi ke gé. Betânia tá fag ẽmã nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria ẽn fi vỹ kar kỹ kejẽn Jesus pẽn kri nén ger há kujẽ, kỹ fi tóg fi gãnh tỹ ti pẽn kykũg mũ gé. Ẽn fi mré pafa mũ vỹ kaga nỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kỹ ti ve fag vỹ Jesus mỹ vẽnh vĩ jẽnẽg mũ. Ti mỹ fag tóg: “ã tỹ ũ to há nĩ ẽn vỹ kaga nỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kỹ Jesus tóg mẽg mũ. Hã ra tóg ã mré mũ tĩ ag mỹ: “ti pi(jé) vẽnh kaga tag to ter ke mũ',” he mũ. “Topẽ vỹ tỹ ũn mág nĩ. Tag vỹ vẽnh ven ke mũ, ti kaga tugrĩn. Kỹ Topẽ kósin vỹ tỹ ũn mág nĩ gé. Tag vỹ vẽnh ven ke mũ gé, ti kaga tugnĩn,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus vỹ Marta fi to há tãvĩ nĩ, fi jãvy fi to ke gé, Lázaro to ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hã ra Jesus tóg, ti tỹ Lázaro kaga mẽg mũ ra (tóg ver) ti venh tĩ tũ nĩ. Ã tỹ hẽ tá nĩ ẽn tá tóg ver kurã régre han. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tag pãte tóg ã mré mũ tĩ ag mỹ: “mũ nỹ, ga tỹ Judéia ra,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kỹ ag tóg ti mỹ: “Senhor,” he mũ. “Ẽg tỹ Judéia tá nỹtĩn kỹ Judeu ag tóg ã pin sór ja nĩ, pó tỹ. Ra tĩ tũg nĩ,” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Hã ra Jesus tóg ag mỹ comparação han mũ, ti ter ke kurã jun ja tũ to. “Kurã pir vỹ tỹ 12 (ke) hora ke nĩ,” he tóg. “Ẽg tỹ kurã ẽn ki hẽn ra mũn kỹ ẽg tóg krĩm kenh ke tũ nĩ, ẽg tỹ kurã ve há han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ẽg tỹ hã ra kuty ra hẽn ra mũn kỹ ẽg tóg krĩm ke tĩ, ẽg tỹ kuty ki nén ũ vég tũ nĩn kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kỹ tóg ag mỹ: “ũ tỹ ẽg to há nĩ ẽn, Lázaro ẽn vỹ nũr nỹ,” he mũ. “Isỹ ti tỹ mrin ke han tĩg ke nẽ ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kỹ ag tóg ti mỹ: “ti nũr nỹn kỹn kren ke mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Hã ra Jesus tóg ti ter ja tó ja nĩ. Jó ag tóg: “ti nũr vẽ, ti vẽnhkán vẽ,” he mũ, ag tỹ ti vĩ mẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kỹ Jesus tóg jamã hár(a) ag mỹ kãmén mũ. “Lázaro vỹ ter huri,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","“Ãjag tugrĩn tóg inh mỹ sér tĩ, isỹ ti ter ve ja tũ nĩn kỹ. Ãjag tỹ isỹ nén han mũ ven kỹ ãjag tóg inh ki ge há han ke mũ. Mũ jé ha, ti ve jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kỹ Tomé he mũ ẽn, ag tỹ ũ to: “ũn vẽgnig mũ,” he tĩ ẽn vỹ ti mré mũ tĩ ag mỹ: “mũ jé ha, ti mré, ẽg tỹ ti mré kãgter jé,” he mũ. Kỹ ag tóg mũ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kỹ ag tóg Betânia tá junjun mũ. Hã ra Lázaro vỹ vẽnh kej tá nỹ nĩ. Kurã tỹ 4 (ke) vẽ sir, ag tỹ vẽnh kej tá ti fón ja kri. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Hã ra ag tóg Jerusalém kakó ki nỹtĩ, 3 quilômetros hỹn, ẽmã tỹ Betânia ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kỹ Judeu tỹ hẽn ri ke fag vỹ Marta fi venh kãmũ ja nĩ, Maria fi ke gé, fag mré vẽser kri fỹ jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kỹ Marta fi tóg mẽg mũ, Jesus kãtĩg ti. Kỹ fi tóg tim ke kỹ ti venh tĩ mũ. Hã ra Maria fi tóg ã ĩn krẽm nĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kỹ Marta fi tóg Jesus kato tẽ mũ. “Senhor,” he fi tóg. “Ã tỹ kãnĩ ra ti ter ke tũ nĩ vẽ,” he fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","“Hã ra sóg ã ki kanhró nĩ. Ã tỹ Topẽ mỹ nén ũ to vĩn kỹ tóg ã mỹ nĩm ke mũ, Topẽ ti,” he fi tóg, Marta fi, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kỹ tóg fi mỹ: “ã mré ke vỹ rĩr mãn ke mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Hỹ,” he fi tóg. “Vẽnh kar rĩnrĩr mãn ken kỹ tóg rĩr mãn ke mũ gé, ki kanhró sóg nĩ. Kurã tỹ ẽgno ki ke vẽ,” he fi tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Hã ra Jesus tóg fi mỹ: “inh hã vỹ vẽnh kar rĩnrĩr mãn han tĩ,” he mũ. “Vẽnh kar rĩnrĩn mũ vỹ tỹ inh nĩ,” he tóg. “Ũ tỹ inh ki rã mũ ẽn vỹ rĩr ke mũ, ti ter kỹ nỹ (hã) ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Kỹ ũn rĩr jẽ tóg, ti tỹ inh ki rã kỹ (tóg) ter mãn ke tũ pẽ nĩ. Ã mỹ inh vĩ tag kri fig mũ'?” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Hỹ,” he fi tóg. “Cristo vỹ tỹ ã nĩ, Topẽ kósin ti, ũ tỹ ga kri jun ke mũ ẽn ti. Tag vỹ inh mỹ tỹ hã nĩ,” he fi tóg, Jesus ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kỹ fi tóg tĩ mũ, fi jãvy fi jé prẽr jé, Maria fi. Kỹ Marta fi tóg Maria fi tá jun kỹ fi mỹ: “ẽg Senhor vỹ jun, kỹ tóg ã ve sór mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Fi tỹ tag mẽ kỹ fi tóg tim ke kỹ tĩ mũ, Jesus ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Hã ra tóg ẽmã ẽn ra rã ja tũ nĩ ver. Ver tóg tá nĩ nĩ, Marta fi tỹ hẽ tá ti mré vẽmén ja ẽn tá. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kỹ Judeu fag vỹ vég mũ, Maria fi tỹ tim ke kỹ tĩg mũ ti. Fi mré kygfỹ jé fag kãmũ ja nĩ, Judeu fag. Fag tỹ fi tĩg ve kỹ fag tóg fi nón kãmũ mũ gé. “Fi hỹn ti kej ra tĩg sór mũ, tá fỹ jé,” he fag tóg mũ, hã kỹ fag tóg fi nón kãmũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kỹ Maria fi tóg Jesus tá jun mũ. Fi tỹ ti ve kỹ fi tóg ti pẽn krẽm mũg ke mũ. Ti mỹ fi tóg: “Senhor,” he mũ. “Ã tỹ kãnĩ ra ti ter ke tũ nĩ vẽ,” he fi tóg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kỹ Jesus tóg fi fỹ mũ vég mũ, kỹ tóg Judeu tỹ hẽn ri ke fag vég mũ gé, fi nón kãmũ mũ fag. Kỹ tóg ti mỹ e tãvĩ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Ti hẽ kã nỹ?” he tóg mũ sir. Kỹ ag tóg ti mỹ: “mũ nỹ, ti ve jé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kỹ Jesus tóg fỹ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kỹ Judeu ag tóg: “ha vé,” he mũ. “Ti to há tãvĩ tóg nĩ, hã kỹ tóg fỹ mũ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hã ra ag kãmĩ ũ tóg: “ti tỹ há' he ja tũ tóg nĩ,” he mũ. “Ũn kyvó kanẽ tỹ há' he ja tóg nĩ, ti tỹ hẽ ri ken kỹ ti tỹ há' he ja tũ nĩ nẽ, ti ter tũ nĩ jé? Ti mỹ tỹ hẽ ri ke tũ nĩ vỹ, ti kaga tỹ'?” he ag tóg, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Kỹ tóg Jesus mỹ e tãvĩ tĩ. Kỹ tóg ti tỹ vẽnh kej kỹ nỹ ẽn ra tĩ mũ. Hã ra ti kej vỹ tỹ pãró nor nĩ, kỹ tóg pó mág tỹ nĩfénh kỹ nĩ, ti kej nor ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kỹ Jesus tóg ag mỹ: “ha pó tag kunũ,” he mũ. Kỹ Marta fi, ũn ter kỹ nỹ ẽn ve fi vỹ ti mỹ: “Senhor,” he mũ. “Ti hỹn ger nỹ ha. Kurã tỹ 4 (ke) vẽ ha, ẽg tỹ ti fón ja kri,” he fi tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Hã ra Jesus tóg fi mỹ: “ã mỹ sóg: ã tỹ inh ki rã há han kỹ ã tóg venh ke mũ, Topẽ tỹ tỹ ũn mág nĩ ti, he ja nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kỹ ag tóg pó ẽn kunũg mũ. Kỹ Jesus tóg kanhkã ki ẽvãnh mũ. Kỹ tóg: “panh',” he mũ. “Inh mỹ tóg há tĩ. Inh vĩ tag jẽmẽg ã tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jẽmẽg ã tóg tĩ, inh vĩ ti, hã kỹ ã tóg sỹ ã mỹ vĩ tag jẽmẽg mũ gé. Hã ra sóg jamã hár(a) ã mré vĩ mũ, ũ tỹ ki nỹtĩ kar fag tỹ inh vĩ mẽ jé, fag tỹ inh ki ge jé, fag tỹ iso: “Topẽ tỹ ti jẽnẽ vẽ,” he jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tag tó kar kỹ tóg jamã hár(a) prẽr mũ. “!..Lázaro, kuneg..!” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kỹ ũn ter ja ẽn tóg kãtĩg mũ sir, ã kej kãki tóg kãkutẽ mũ sir, mỹr, ha mẽ. Ti pẽn vỹ sigse kỹ nỹtĩ, ti nĩgé ke gé, kỹ ti kakã vỹ pãg kỹ nĩ gé. Kỹ Jesus tóg ag mỹ: “ha ti kava,” he mũ, “ti tĩg jé,” he tóg. Kỹ ag tóg ti kyvãn kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kỹ ũ tỹ Maria fi mré kygfỹ jé kãmũ tỹ hẽn ri ke fag vỹ Jesus ki ge mũ sir, fag tỹ Jesus tỹ ti rĩn mãn mũ ẽn ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Hã ra ũ ag tóg Fariseu ag mỹ tónh mũ mũ, Jesus tỹ ti rĩn mãn ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kỹ Fariseu ag tóg mẽg mũ, Jesus tỹ Lázaro rĩn mãn ja ti. Topẽ tũ ki rĩr tĩ to pã'i ag vỹ mẽ kãn mũ gé. Kỹ ag tóg vẽnh jyvẽn tĩ kar ag jé prẽr mũ. “Ẽg hỹn ti tỹ hẽ ri kenh ke mũ?” he ag tóg mũ, Jesus to. “Milagre tỹ hẽn ri ke hyn han tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ẽg tỹ ti kato vãsãn tũ nĩn kỹ tóg ẽg mỹ vẽnh kar tỹ ti ki genh ha mẽ tĩ. Kỹ ẽg fóg tỹ Romano ag vỹ ẽg kato vãsãnsãn ke mũ. Topẽ jo ĩn kókén jé ag tóg ke mũ, kỹ ag tóg ẽg kãgtén kãn ke mũ gé, ẽg fóg tỹ Romano ag, ha vemnĩ,” he ag tóg, vẽnh jyvẽn tĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kỹ pã'i ag kãmĩ ũ vỹ tỹ Caifás nĩ. Prỹg ẽn kã tóg tỹ Topẽ tũ ki rĩr tĩ to pã'i mág nĩ, Caifás ti. Ẽn vỹ tóg ag mỹ: “to jykrén há han tũ ãjag nỹtĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","“Tag to jykrén nĩ, ha mẽ. Ũn pir ter ke tóg kórég nĩ, hã ra tóg povo kãgter kãn kórég jakrẽm nĩ. Kỹ ti hỹn ẽg povo jagfy ter ke mũ, Jesus ti,” he tóg, Caifás ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hã ra tóg vẽsóg ki tag to jykrén ja tũ nĩ. Prỹg ẽn ki tóg tỹ Topẽ tũ ki rĩr tĩ to pã'i mág nĩ, hã kỹ Topẽ kuprĩg vỹ ti krĩn ja nĩ, ti tỹ Jesus to: “ẽg povo jagfy tóg ter ke mũ,” he jé, Caifás ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hã ra Judeu ag tãvĩ jagfy ke pijé'. Topẽ krẽ kar jagfy ke ja vẽ. Ti tỹ vẽnh kar tỹ ũn pir han sór ja vẽ, Jesus ti, hã jé tóg ẽg jagfy ter ja nĩ, ũ tỹ povo kar kãmĩ ti ki genh ke mũ ag kar jagfy. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pã'i ag tỹ tỹ vẽmén kar kỹ ag tóg ti tén ke to jykrén mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hã kỹ Jesus tóg vẽnh péju kỹ tĩ mũ, ga kórég ra, ẽmã tỹ Efraim ra. Judeu ag mĩ tóg tĩg mãn tũ nĩ sir. Efraim hã tá tóg nĩ nĩ ver, kỹ ti mré mũ tĩ ag vỹ ti mré tá nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Hã ra Judeu ag tỹ festa tỹ Páscoa há ũ vỹ kakó tĩ ha. Kỹ ũ tỹ hẽn ri ke ag tóg Jerusalém ra mũ mũ, Páscoa ẽn ve jé. To hã ag tóg ra mũ mũ, vẽnh jãnhkrigkrig jé, Judeu ag jykre ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tá ag tóg Jesus jãvãnh mũ, Topẽ jo ĩn tá nỹtĩ kỹ. Kỹ ag tóg jagnẽ mỹ: “ti ã mỹ hỹn hẽ ri ke mũ?” he mũ. “Ti mỹ hỹn festa to kãtĩg ke mũ vỹ?” he ag tóg mũ, jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hã ra Topẽ tũ ki rĩr tĩ to pã'i ag vỹ vẽnh kar mỹ vẽnh vĩ jẽnẽ ja nĩgtĩ, Fariseu ag mré hã. “Ãjag tỹ ti ve kỹ ẽg mỹ tónh kãmũmnĩ,” he ja ag tóg nĩ, vẽnh kar mỹ. Ag tỹ ti se sór vẽ, hã kỹ ag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Festa tỹ Páscoa to hã ke vẽ sir, kurã tỹ 6 (ke) vỹ jun nỹ ha. Kỹ Jesus tóg Betânia ra tĩg mãn mũ, Lázaro jamã ra, ũn rĩr mãn mũ ẽn jamã ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tá fag tóg Jesus mỹ festa han mũ. Kỹ Marta fi tóg vẽjẽn ki rĩr mũ. Lázaro vỹ Jesus mré nĩ nĩ, mesa to. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kỹ Maria fi tóg nén ger há ma kãtĩ mũ, garrafa fór, ũn kaja e. Ẽn tỹ fi tóg Jesus pẽn kri kujẽg mũ, kỹ fi tóg ã gãnh tỹ kykũg mũ, ti pẽn ti. Kỹ ger há ẽn tóg ĩn kar ẽn kri rũm ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kỹ tóg Judas Iscariotes mỹ e tĩ, ũ tỹ Jesus mré mũ ẽn ag kã ũ tag mỹ, ũ tỹ pã'i ag mỹ Jesus ven ke mũ tag mỹ. Fi tỹ ger há tỹ ti pẽn to tĩn kỹ tóg ti mỹ e tĩ, kỹ tóg fi to: ");
INSERT INTO kgpNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“fi tỹ ger há ẽn fón ke vẽ vẽ, jãnkamy tỹ hẽn ri ke to,” he mũ. “Fi tỹ ũn jagãgtar ag mỹ jãnkamy ẽn kã vẽnh kãpópãm jé vẽ vẽ,” he tóg mũ, Judas ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hã ra tóg tag tó, ti tỹ Jesus mỹ jãnkamy ki rĩr kỹ. Hã ra tóg ti jãnkamy péju(g) tĩ. Hã kỹ tóg fi to tag tó ja nĩ, Judas ti. Ti tỹ ũn jagãgtar ag to jykrén ja pijé'. Ti tỹ jãnkamy ẽn mãn sór ja vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Hã ra Jesus tóg ti mỹ: “fi to vĩ tũg,” he mũ. “Fi tỹ nén ger há ẽn nĩm han ja vẽ, fi tỹ iser jé inh kri kujẽn jé, isỹ inh kej kãkã nỹ jé. Ki hã fi tóg han ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ũn jagãgtar ag vỹ ãjag mré nỹtĩ, tũ' henh ke tũ ag tóg nỹtĩ. Ag jãvo sóg kãnhmar ãjag mré nĩ mãn ke tũ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kỹ Judeu tỹ hẽn ri ke ag vỹ mẽg mũ, Jesus tỹ Betânia tá nĩ ti, kỹ ag tóg ti venh kãmũ mũ. Hã ra ag tóg Lázaro ve sór mũ gé, ũn rĩr mãn mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pã'i ag tóg Lázaro tén sór mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Judeu tỹ hẽn ri ke ag vỹ Jesus ki ge kỹ nỹtĩ, ti tỹ Lázaro rĩn mãn ja tugrĩn, hã kỹ ag tóg Lázaro tén sór mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tỹ vaj kỹ Jesus tóg Jerusalém ra tĩ mũ. Kỹ ũn e ag tóg Jesus tỹ Jerusalém ra tĩ mẽg mũ sir, ũ tỹ festa venh kãmũ mũ ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kỹ ag tóg ti ve jé kãpa mũ, Jerusalém tá. Tãnh féj génh kỹ ag tóg ti venh kãmũ mũ. Kỹ ag tóg: “!..Viva..!” he mũ. “!..Sér tóg tĩ ẽg mỹ..! !..Ẽg jóg mág vỹ ti jẽnẽ..! !..Israel kri pã'i mág pẽ vẽ..!” he ag tóg, prẽnprẽr kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Hã ra Jesus vỹ burrico sĩ ve ja nĩ, kỹ tóg kri nĩ kỹ Jerusalém ra tĩ mũ. Hã ra tóg rán kỹ nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki, ti tỹ burrico sĩ kri tĩg ke ti, ha mẽ: ");
INSERT INTO kgpNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“kamẽg tũg nĩ, Sião tá ke kar',” he tóg. “Ãjag pã'i mág vỹ ũri jun ke mũ ha. Burrico sĩ kri tóg jun ke mũ ha,” he ja tóg nĩ, Topẽ vĩ rán ki, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kurã ẽn kã ag tóg ti rá tag to jykrén ja tũ nĩ ver, Jesus mré mũ tĩ ag. Jesus tỹ kanhkã ra vỹn ke kar kỹ ag tóg kejẽn to jykrén mũ ha, ti to rán kỹ nĩ ẽn to, hã ra tóg ge ja nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ũ tỹ Jesus mỹ prẽnprẽr mũ ag kãmĩ ũ ag tóg Lázaro ve ja nĩ, Jesus tỹ ti rĩn mãn kỹ. Lázaro tỹ vẽnh kej kãkã nỹ ra Jesus tóg ti jé prẽr kỹ ti rĩn mãn ja nĩ. Ũ tỹ tag vég mũ ẽn ag vỹ jagnẽ mỹ kãmén mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hã kỹ ũn e ẽn ag tóg Jesus kato pétẽ mũ, ti tỹ jun ke kỹ. Ũ ter kỹ nỹ rĩn mãn ẽn ve ja tũ ag tóg nỹtĩ, kỹ tóg ag mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kỹ Fariseu ag tóg jagnẽ mỹ: “ha vé, ag pi(jé) ẽg vĩ jẽmẽ sór mũ',” he mũ. “Ti hã mré ag tóg mũ mũ,” he ag tóg, ti to jũgjũ kỹ, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Festa venh kãmũ mũ ag vỹ e nỹtĩ. Ag kãmĩ ũ vỹ tỹ ga tỹ Grécia tá ke nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ẽn ag vỹ Jesus ve sór mũ. Hã kỹ ag tóg Filipe mré vĩ mũ. Ga tỹ Galiléia tá ẽmã tỹ Betsaida tá ke vỹ tỹ ti nĩ, Filipe ti. Kỹ fóg tỹ Grego ẽn ag tóg Filipe mỹ: “ẽg tỹ Jesus venh há tóg tĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kỹ Filipe tóg André mỹ tónh tĩ mũ, kỹ ag tóg Jesus mỹ tónh mũ mũ, Filipe ti, André ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Hã ra Jesus tóg ag mỹ: “inh kurã vỹ hur jun,” he mũ. “Topẽ vỹ isỹ ũn mág han ke mũ ha. Tỹ sóg ẽprã ke fi kósin nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Ki hã sóg ãjag mỹ tó mũ, hã kỹ sóg tó mũ. Isén jé ag tóg ke mũ, ũn e ag tỹ isugrĩn rĩnrĩr nỹtĩ jé. Ẽg tỹ nén ũ fy krãn ri ke ti nĩ. Ti péju(g) ẽg tóg tĩ, ga ki, kỹ tóg vag tĩ, nén ũ fy fár ti. Hã ra ti fy ẽn tóg rĩr mãn kỹ mur mũ, kỹ tóg mog kỹ kanẽ e han mũ. Ẽg tỹ ti krãn tũ nĩ ra tóg kanẽn ke tũ nĩ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ẽn ri ke tóg nĩ, ẽg mré hã. Ẽg hã vỹ tỹ nén ũ fy ri ke nỹtĩ gé. Ẽg tỹ ẽg jykre si tovãnh kỹ ẽg tóg ẽg rĩr krỹg ja tũ ẽn venh ke mũ. Jãvo ẽg tỹ ẽg jykre si tovãnh pẽ han tũ nĩn kỹ ẽg rĩnrĩr ke ẽn tóg krỹ' he mũ sir. Kỹ ẽg kanhkã tá vég tũ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ãjag tỹ inh rãnhrãj han sór kỹ inh ri ke han nĩ, kỹ ãjag tóg tỹ inh mré ke nỹtĩnh mũ, kỹ ãjag tóg inh mré kanhkã tá nỹtĩnh ke mũ gé, ãjag tỹ inh rãnhrãj han kỹ. Kỹ inh panh vỹ ãjag tỹ ũn mág han ke mũ gé, inh ri ke han jé tóg ke mũ, ãjag tỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ũri tóg inh mỹ e tĩ,” he tóg. “Krĩ kufy jagy isóg nĩ. Ge ra sóg inh panh mỹ: “inh kren han nĩ, inh jagtar tũ nĩ jé,” he sór tũ nĩ. Inh vẽsỹrénh hã jé sóg kãtĩg, ti tỹ inh mỹ jagy pẽ (hã) ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tag tó jé sóg ke mũ, inh panh mỹ, hã vỹ: “vẽnh kar mỹ ven nĩ, ã tỹ tỹ ũn mág nĩ tag ti,” he mũ,” he tóg, Jesus ti. Ti tỹ tag tó kỹ vãhã Topẽ tóg ti mỹ vĩ mũ, kanhkã tá nĩ kỹ. Kỹ tóg jamã hár(a) ti mỹ: “ag mỹ sóg ven huri,” he mũ. “Hã ra sóg ag mỹ ven mãn ke mũ gé, isỹ tỹ ũn mág nĩ ti,” he tóg, Topẽ ti. Kanhkã tá nĩg kỹ tóg ti mỹ tó mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kỹ ũn e ag tóg mẽg mũ, Topẽ vĩ ti, ag tỹ ẽprã nỹtĩ ra. Kỹ ag tóg ti vĩ to: “ta tỹ tỹrỹrỹ he hỹn,” he mũ. Ag tỹ ki kagtĩg nỹtĩn kỹ ag tóg Topẽ vĩ to: “ta hỹn,” he mũ. Hã ra ũ ag tóg: “Topẽ tỹ jẽnẽ jafã ũ hỹn ti mré vẽmén,” he mũ gé, ag tỹ ki kagtĩg nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Hã ra Jesus tóg ag mỹ: “Topẽ pi(jé) isugrĩn vĩ ja nĩ',” he mũ. “Ãjag tugnĩn ke ja vẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","32","“Hã kỹ ãjag tóg ka to isanh ke mũ, kynhmỹ. Topẽ tỹ ẽprã ke ag jykre to: “kórég ti nĩ,” he vẽ, ti tỹ tag ki ũn mág tỹ Japo he mũ ẽn to: ti kutẽ jé, he vẽ, hã kỹ ag tóg cruz to isãg mũ. Ẽn kã vẽnh kar ag vỹ inh ki genh ke mũ, isỹ ag krĩn kỹ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tag tó tóg, ã mré mũ tĩ ag mỹ, ã ter ke kãmén kỹ, ag tỹ cruz to ti sanh ke ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kỹ vẽnh kar ag tóg ti mỹ: “hã ra ag tóg ẽg mỹ: “Cristo vỹ ter ke tũ nĩ,” he tĩ. Topẽ vĩ ki ti nẽji rán kỹ nĩ,” he ag tóg mũ. “Jãvo ã tóg ẽg mỹ: ẽprã ke fi kósin ẽn tỹ ag tóg cruz to ti sanh ke mũ, kynhmỹ, he mũ. Ũ to ke nẽ, hỹn, ẽprã ke fi kósin ẽn?” he ag tóg, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kỹ tóg ag mỹ: “ver sóg ãjag mré nĩ nĩ, sỹ ãjag mỹ kurã han jé,” he mũ. “Kurã ki inh japry jagma mũmnĩ. Kãnhmar ti kuty nĩnh mũ. Ãjag tỹ kuty ra inh jamĩn jagma mũ sór mũ ra ãjag tóg vãgfor mũnh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Isỹ ver ãjag mré nĩn kỹ inh ki ge sórmnĩ, ãjag tỹ tỹ inh mré ke nỹtĩ jé. Kỹ ãjag tóg kurã ki nỹtĩ, isỹ tỹ jẽngrẽ ri ke nĩn kỹ,” he tóg, Jesus ti. Ã tỹ tag tó kar kỹ tóg tĩ mũ, ag ré kỹ. Vẽnh péju kỹ tóg tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus vỹ ag rĩnve nén tỹ hẽn ri ke hyn han ja nĩgtĩ, ẽg tỹ nén han vãnh tỹ hẽn ri ke, milagre tỹ hẽn ri ke, hã ra ag tóg ti ki ge sór tũ nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hã ra Isaías vỹ tag rán ja nĩ gé. “Ẽg jóg mág,” he ja tóg nĩ. “Isỹ ag mỹ ã kãmén mũ ra ag tóg inh vĩ kri nĩm sór tũ nỹtĩ,” he ja tóg nĩ. “Ag tỹ ã tỹ nén han mũ ẽn vég mũ ra ag tóg: “Topẽ jykre vỹ tar nĩ,” he ja tũ nĩ,” he ja tóg nĩ, Isaías ti. Hã ra tóg ge nĩgtĩ, Jesus tỹ ag mỹ Topẽ vĩ tón kỹ, ti tỹ ag mỹ milagre hyn han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Kỹ Isaías vỹ ag to tag tó gé, ha mẽ. “Topẽ vỹ ag kyvó han, nĩgrẽg kutu, hã kỹ ag tóg mẽg tũ nĩgtĩ, kỹ ag tóg to jykrén sór tũ nĩgtĩ gé, kỹ ag tóg inh ki ge sór tũ nĩgtĩ gé, kỹ sóg ag tỹ há' henh ke tũ nĩ gé,” he ja tóg nĩ gé, Isaías ti, ti tỹ Topẽ vĩ tó kỹ. Jesus to tóg ke mũ. Hã kỹ ag tóg Jesus ki ge sór tũ nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías vỹ Jesus ve ja nĩ, ti tỹ tỹ ũn mág nĩ ti, ũn tar ti. Jesus mur to hã ke ja vẽ, vãsỹ. Ti tỹ ti ve hã kỹ tóg tag tó ja nĩ, ti to, Isaías ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hã ra ũ ag tóg ti ki ge kỹ nỹtĩ gé, pã'i ũ ag mré hã. Hã ra ag tóg tó sór tũ nĩgtĩ. Fariseu ag kamẽg ag tóg tĩ, hã kỹ ag tóg tó sór tũ nĩ. “Fariseu ag vỹ ẽg pan ke mũ, ẽg tỹ ẽg vẽnh kanhrãn jafã ra mũ tũ nĩ jé, ẽg tỹ ẽg mré ke ag mré tá vẽnh mãn kỹ nỹtĩ tũ nĩn jé,” he ag tóg mũ, hã kỹ ag tóg Jesus tó tũ nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ẽprã ke ag tỹ ag to vĩ há han mũ tag vỹ ag mỹ sér tĩ, kỹ Topẽ tỹ ag mỹ vĩ há han mũ vỹ ag mỹ pãgsĩ tĩ. Há ti nĩ gé vẽ vẽ, hã ra ag tóg ẽprã pã'i ag hã kamẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kỹ Jesus vỹ jamã hár(a) ke mũ, vẽnh kar tỹ ti vĩ mẽ jé. Kỹ tóg: “ãjag tỹ inh ki ge kỹ ãjag tóg ũ tỹ inh jẽnẽg mũ ẽn ki ge mũ gé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","“Ãjag tỹ inh ve kỹ ãjag tóg ti vég mũ gé, ũ tỹ inh jẽnẽg mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Sỹ ãjag mỹ kurã han hã jé sóg kãtĩg. Ãjag tỹ inh ki ge kỹ sóg ãjag mỹ kuty ẽn tỹ tũ' he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ãjag tỹ ón kỹ inh vĩ mẽg mũ ra sóg ãjag to: “kórég ãjag nỹtĩ,” henh ke tũ nĩ. Inh pi(jé) ãjag mỹ: “kórég ãjag nỹtĩ,” he jé kãtĩg'. Sỹ ãjag krenkren han hã jé sóg kãtĩg. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ãjag tỹ iso é he kỹ, ãjag tỹ inh vĩ to é he kỹ tóg vẽnh ven mũ, ãjag jykre kórég ẽn ti, ha vemnĩ. Isỹ ãjag mỹ inh vĩ tó mũ ra ãjag tóg inh vĩ kri nĩm jãvãnh nỹtĩ. Hã tugrĩn tóg vẽnh ven ke mũ, ãjag jykre kórég ti, kurã tỹ ẽgno tá hã. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Inh pi(jé) isỹ vẽsóg ki nén to jykrén ja ẽn tó tĩ'. Inh panh vĩ hã tó ja inh nĩgtĩ, ũ tỹ inh jẽnẽg mũ ẽn vĩ ti. Ẽn vỹ inh mỹ: “tag tómnĩ, tag tó tũg nĩ,” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ti tỹ inh mỹ nén tó mũ vỹ ãjag rĩnrĩr han ke mũ, ki kanhró sóg nĩ. Hã kỹ sóg inh panh tỹ inh mỹ nén tó mũ ẽn hã tó tĩ, tag tãvĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Hã ra festa tỹ Páscoa vỹ kakó tãvĩ tĩ sir, hã ra tóg tá krỹg tũ nĩ ver. Kỹ Jesus vỹ ki kanhró nĩ, ti tỹ ũri ter ke ẽn ti. Ti kurã vỹ jun ja nĩ, ti tỹ ã panh ra tĩg jé. Ã mré mũ tĩ ag to tóg há tãvĩ ja nĩgtĩ, ag tỹ tỹ ti tũ nỹtĩn kỹ. Kỹ tóg ã ter ke kurã ẽn kã ag to há tãvĩ nĩ gé, tag ki, ẽprã, ti mré mũ tĩ ag to. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kỹ tóg rãkãnh kỹ ag mré jẽg mũ. Hã ra Japo vỹ Judas krĩn huri, ti tỹ pã'i ag mỹ Jesus ven tĩg jé, ag tỹ ti se jé. Judas Iscariotes ẽn vẽ, Simão kósin ẽn. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Hã ra Jesus tóg ki kanhró nĩ, ã tỹ Topẽ tá kãtĩg ja ẽn ki, kỹ tóg ki kanhró nĩ gé, ã tỹ ra tĩg mãn ken ki. Kỹ Topẽ tóg ti tar han mũ gé, ti tỹ nén ũ kar ki ag mỹ tỹ ũn mág jẽ jé. Ẽn ki kanhró tóg nĩ gé, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tag kar to jykrén kỹ tóg vãhã jẽgnẽ mũ sir, jẽn kar kỹ. Jẽgnẽ kỹ tóg ã capa kunũnh kỹ vẽnh pẽfĩ jafã tỹ vẽnh pẽfĩg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Goj tỹ tóg pénky kãki kujẽg mũ, kỹ tóg ã mré mũ tĩ ag pẽn kugpég mũ. Vẽnh pẽfĩ jafã ẽn tỹ tóg ag pẽn kykũg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kỹ tóg Simão Pedro tá jun mũ gé, ti pẽn kugpe jé. Hã ra Pedro tóg ti mỹ: ã pi(jé) inh pẽn kugpenh ke mũ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Hã ra Jesus tóg ti mỹ: “ã pi(jé) ki kanhró nĩ', sỹ ã mỹ nén han mũ ti',” he mũ. “Kar kỹ ã tóg kejẽn to jykrén ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Hã ra Pedro tóg ti mỹ: “vó,” he mãn mũ. “Inh pẽn kugpenh ke tũ ã tóg nĩ,” he tóg. Kỹ Jesus tóg ti mỹ: “isỹ ã pẽn kupég tũ nĩn kỹ ã tóg tỹ isũ tũ nĩnh ke mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Kỹ Pedro tóg ti mỹ: “inh kupe kãn nĩ, ge kỹ, inh pẽn, inh krĩ, inh nĩgé ke gé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Hã ra Jesus tóg ti mỹ: “mro ã huri,” he mũ. “Ã mro kar kỹ sóg ã pẽn hã kugpenh ke mũ. Jãnhkri ã nĩ, ã mro kar kỹ. Jãnhkri ãjag nỹtĩ, hã ra ãjag kãmĩ ũn pir vỹ jãnhkri tũ nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ũ tỹ pã'i ag mỹ ã ven ke mũ ẽn ki kanhró tóg nĩ, Jesus ti, hã kỹ tóg ag mỹ: “ãjag kãmĩ ũn pir vỹ jãnhkri tũ nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kỹ tóg ag pẽn kugpe kãn mũ. Ag pẽn kugpe kar kỹ tóg ã kur rĩnh mãn mũ, kỹ tóg nĩ mãn mũ. Kỹ tóg ag mỹ: “ãjag mỹ sỹ nén han ja ki kanhró nỹtĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Iso ãjag tóg: Senhor, he tĩ. Tó há han ãjag tĩ. Tỹ sóg ãjag Senhor nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kỹ sóg tỹ ãjag professor nĩ gé. Hã ra sóg ãjag pẽn kugpé. Hã kỹ tóg há tĩ, ãjag tỹ jagnẽ mỹ jagnẽ pẽn kugpe kỹ, inh ri ke han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Sỹ ãjag kanhrãn sór vẽ, hã kỹ sóg ãjag mỹ ãjag pẽn kugpé. Inh ri ke han nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ki hã sóg tó mũ, hã kỹ sóg ke mũ. Ẽg camarada pi(jé) ãjag patrão kãfór nỹtĩ'. Kỹ ẽg tỹ ũ jẽnẽn kỹ tóg ũ tỹ ti jẽnẽg mũ ẽn kãfór tũ nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tag ki kanhró ãjag nỹtĩ, kỹ tóg há tĩ, ãjag tỹ inh ri ke han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ãjag kãmĩ ũ tóg tag han ke tũ nĩ, ki kanhró sóg nĩ. Ãjag kuprẽg inh, kỹ sóg ãjag ki kanhró nĩ. Tag vỹ ãjag kãmĩ ũ to rán kỹ nĩ, ha mẽ: “ũ tỹ inh mré inh jamĩ ko mũ ẽn vỹ isovãnh ke mũ ha,” he ti nĩ, Topẽ vĩ tỹ rán kỹ nĩ ki. Isỹ tag ve jé sóg ãjag kuprẽg. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ũri sóg ãjag mỹ tó mũ, ti tỹ isovãnh ke to hã, ãjag tỹ ẽn ve kỹ inh ki ẽkrén' he jé. Ẽn ve kỹ inh ki ge kỹ nỹtĩmnĩ jãvo. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ki hã sóg tó mũ, hã kỹ sóg ke mũ. Isỹ ãjag jẽgnẽnh ke vẽ. Kỹ ũ tỹ ãjag mỹ vĩ há han kỹ tóg inh mỹ vĩ há han ke mũ gé, hã ra tóg ũ tỹ inh jẽnẽg mũ ẽn mỹ vĩ há han ke mũ gé, ãjag mỹ vĩ há han kỹ,” he tóg, Jesus ti, ti mré mũ tĩ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus tỹ tag tó kar kỹ tóg ti mỹ e tĩ. Krĩ kufy jagy ti nĩ, kỹ tóg ã mré mũ tĩ ag mỹ: “ki hã sóg tó mũ, hã kỹ sóg ke mũ,” he mũ. “Ãjag kãmĩ ũ vỹ pã'i ag mỹ inh ven ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kỹ tóg ag mỹ e tĩ. Ki kagtĩg ag nỹtĩ, kỹ ag tóg véké jagnẽ ki ẽvãnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hã ra ũ tóg Jesus rã hã nĩ nĩ, ẽn kã, ti tỹ ti to há nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kỹ Pedro tóg ti mỹ ã nĩgé ven mũ, kỹ tóg ti mỹ: “ti ki jẽmẽ há han,” he mũ, ũ tỹ Jesus rã hã nĩ ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kỹ tóg ti to grẽn ke kỹ ti mỹ: “Senhor,” he mũ. “Ũ tỹ hẽ nẽ?” he tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kỹ Jesus tóg ti mỹ: “ẽmĩ tỹ sóg ti kume kã tỹ pun ke mũ,” he mũ, “kỹ sóg ti mỹ nĩm ke mũ sir. Ẽn hã vẽ,” he tóg mũ, Jesus ti. Tag tó kỹ tóg ẽmĩ mãg mũ, kỹ tóg ti kume kã tỹ pun ke mũ sir, kỹ tóg Judas mỹ nĩm mũ, Simão Iscariotes kósin ẽn mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kỹ Judas tóg ko mũ. Ti tỹ ko kar mũ ra vẽsỹmér Satanás tóg ti kãra rã ja nĩ sir. Kỹ Jesus tóg ti mỹ: “ã tỹ nén han sór mũ ẽn han tĩg nĩ, to fũrũn nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Hã ra ũ ag tóg ki kagtĩg nỹtĩ, Jesus tỹ ti mỹ nén tó mũ ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas vỹ ag jãnkamy ki rĩr tĩ. Hã kỹ ag kãmĩ ũ tóg: “ti hỹn ti mỹ: “ẽg mỹ festa to compra ũ han tĩg,” he sór mũ, ke tũ nĩ kỹ ti tỹ ũn jagãgtar ag mỹ nén ũ nĩm ke hỹn,” he ag tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hã ra Judas tóg ẽmĩ ẽn ko kar kỹ (tóg) króm ke kãkutẽ mũ, re ra. Hã ra tóg kuty nỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas tĩg kar kỹ Jesus tóg ã mré mũ tĩ ag mỹ: “vãhã tóg vẽnh ven ke mũ, isỹ tỹ ũn mág nĩ ti,” he mũ. “Tỹ sóg ẽprã ke fi kósin nĩ. Hã ra sóg vẽnh kar mỹ Topẽ tỹ tỹ ũn mág nĩ tag ven ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Isỹ vẽnh kar mỹ Topẽ tỹ tỹ ũn mág nĩ ven kỹ Topẽ tóg vẽnh kar mỹ ven ke mũ gé, isỹ tỹ ũn mág nĩ ti. Vẽsỹmér tóg tag han ke mũ, Topẽ ti, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Inh jãvy', ãjag mré sóg nĩ sĩ pẽ han mũ ver,” he tóg. “Inh jãvãnh jé ãjag tóg ke mũ, hã ra ãjag tóg inh venh ke tũ nĩ. Tag tó inh, Judeu ag mỹ, hã ra sóg ãjag mỹ tag hã tó mũ gé, hã vỹ: ãjag pi(jé) isỹ hẽn ra tĩg ke mũ ẽn ki kanhró nỹtĩ', he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kỹ sóg ãjag mỹ vẽnh jykre tãg nĩm sór mũ, hã vỹ: jagnẽ to há tãvĩ nỹtĩmnĩ, he mũ. Ãjag to há tãvĩ sóg nĩ gé. Tag ri ke han nĩ, jagnẽ mỹ. Vẽnh jykre tãg hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ãjag tỹ jagnẽ to há nỹtĩn kỹ vẽnh kar vỹ ãjag jykre ki kanhrãn ke mũ. “Ti mré ke vỹ tỹ ag nỹtĩ,” he jé ag tóg ke mũ ãjag to, ag tỹ ãjag jykre há ve kỹ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kỹ Simão Pedro tóg Jesus mỹ: “Senhor,” he mũ. “Ã tỹ hẽ ra tĩg sór nẽ?” he tóg. Kỹ Jesus tóg: “ẽn ra ã tĩg ke tũ nĩ ver, inh mré,” he mũ. “Kar kỹ ã tóg kejẽn ẽn ra tĩg ke mũ gé, inh nón,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kỹ Pedro tóg ti mỹ: “isỹ ã mré tĩg há tóg tĩ,” he mũ. “Isỹ ã tugrĩn ter ken kỹ tóg inh mỹ tỹ nén ũ tũ tĩnh mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Hã ra Jesus tóg ti mỹ: “vó,” he mũ. “Ũri ã tóg ón kỹ iso: “ti ki kagtĩg sóg nĩ,” henh ke mũ. “Ti ki kagtĩg sóg nĩ,” he tãgtũ han jé ã tóg ke mũ, galo kynkyr to hã. Ki hã sóg tó mũ, ha vemnĩ,” he tóg, Jesus ti. Ti tỹ Pedro mỹ tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kỹ Jesus tóg ã mré mũ tĩ ag mỹ: “krĩ kufy han tũg nĩ,” he mũ. “Inh ki rã há han nĩ, kỹ Topẽ ki rã há han nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Inh panh jamã tá ãjag ĩn vỹ e nỹtĩ, ki hã sóg tó mũ. Ti tỹ tá tũ nỹtĩ ra sóg tónh ke tũ nĩ vẽ. Ra tĩg jé sóg ke mũ, isỹ ãjag mỹ ãjag ĩn kãnkãn jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Isỹ kãnkãn kar kỹ sóg tá kãtĩg mãn ke mũ gé, sỹ ãjag tatĩn tĩg jé, kỹ ãjag tóg inh mré tá nỹtĩnh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ti to ẽpry ki kanhró ãjag nỹtĩ, sỹ hẽ ra tĩg ke to ẽmĩn ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kỹ Tomé tóg ti mỹ: “ẽg pi(jé) ki kanhró nỹtĩ', ã tỹ hẽ ra tĩg ke ti',” he mũ. “Hã kỹ ẽg tóg ti to ẽpry ki kagtĩg nỹtĩ gé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Kỹ Jesus tóg ag mỹ: “ti to ẽmĩn vỹ tỹ inh nĩ,” he mũ. “Vẽnh vĩ há hã tó sóg tĩ. Inh hã vỹ ãjag rĩnrĩr han ke mũ. Ũ tỹ inh ki ge mũ ag vỹ inh panh venh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ãjag tỹ inh ki kanhró nỹtĩn kỹ ãjag tóg inh panh ki kanhró nỹtĩ gé. Inh ki kanhrãn ãjag tóg huri, inh ve ãjag tóg huri,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kỹ Filipe tóg ti mỹ: “ẽg mỹ ẽg jóg mág ti ven nĩ,” he mũ. “Ẽg tỹ ti venh há tóg tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kỹ Jesus tóg Filipe mỹ: “ã mỹ inh ki kagtĩg nĩ ver', isỹ ãjag mré tĩg mág ja ra?” he mũ. “Ã tỹ inh ve kỹ ã tóg inh panh ti vég mũ gé. Hã ra ã tóg inh mỹ: ẽg mỹ ti ven nĩ, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Inh panh mré sóg tỹ ũn pir nĩ, kỹ tóg inh mré tỹ ũn pir nĩ gé. Ã mỹ tag kri fig tũ? Inh pi(jé) isỹ vẽsóg ki nén to jykrén mũ tó tĩ'. Inh panh tũ hã tó sóg tĩ, ti tũ hã han sóg tĩ, inh mré tỹ ũn pir nĩ ẽn tũ ti. Kỹ tóg inh mré nén kar han mũ, inh panh ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Inh vĩ kri nĩmnĩ, isỹ ã mỹ: “inh panh mré sóg tỹ ũn pir nĩ,” hen kỹ. Ã tỹ hã ra inh vĩ kri fi sór tũ nĩn kỹ isỹ nén han mũ ẽn ki ẽvãnh nĩ, ã tỹ to jykrén há han jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ki hã sóg tó mũ, hã kỹ sóg ke mũ. Ũ tỹ inh ki rã há han mũ ẽn vỹ isỹ nén han mũ ri ke han ke mũ gé, hã ra tóg isỹ nén han mũ kãfór han ke mũ, ha vemnĩ, isỹ ũri inh panh venh tĩg ken kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kỹ sóg ãjag tỹ inh mỹ nén ũ to vĩ mũ ẽn hyn han kãn ke mũ, isỹ tỹ ãjag kãke nĩn kỹ. Isỹ vẽnh kar mỹ inh panh tỹ tỹ ũn mág nĩ ven ke vẽ, hã jé sóg ãjag mỹ ãjag tỹ nén to vĩ mũ ẽn hyn han ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Kỹ, ãjag tỹ inh mỹ nén ũ to vĩnh ken kỹ sóg ẽn hyn han kãn ke mũ, isỹ tỹ ãjag kãke nĩn kỹ, ha vemnĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ãjag tỹ iso há nỹtĩn kỹ han nĩ, isỹ ãjag mỹ nén tó mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kỹ isóg inh panh mỹ ti kuprĩg to vĩnh ke mũ, ti tỹ ãjag mỹ ti jẽnẽ jé, ti tỹ tỹ ãjag jagrẽ nĩ jé, ti tỹ ãjag tar han jé, kỹ tóg ãjag tovãnh mãn ke tũ nĩ. Ãjag mỹ tóg ki hã tónh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hã ra tóg ũ tỹ inh ki ge jãvãnh ẽn ag mỹ nén ũ tónh ke tũ nĩ, ag tỹ ti ki kagtĩg nỹtĩn kỹ. Ag jãvo ãjag tóg ti ki kanhró nỹtĩ. Ãjag kãtá tóg ãjag mré nĩ nĩ, Topẽ kuprĩg ti,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Inh pi(jé) ãjag tovãnh ke mũ'. Isĩg mũ ra sóg vỹn kenh ke mũ, ãjag to. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kãnhmar ũ tỹ inh ki ge jãvãnh ẽn ag tóg inh ve mãn ke tũ nĩ. Ag jãvo ãjag tóg inh ve mãn ke mũ. Rĩr inh nĩ nĩ, kỹ ãjag tóg inh ri kén rĩr mãn ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ãjag tỹ Topẽ kuprĩg tỹ ãjag jagrẽ venh ke kurã ẽn ki ãjag tóg inh ki kanhrãn há han ke mũ, isỹ inh panh mré tỹ ũn pir nĩ ẽn ti. Kỹ ãjag tóg inh mré tỹ ũn pir nỹtĩnh mũ gé, ha mẽ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ũ tỹ inh vĩ hã ki kanhrãn mũ ẽn, ũ tỹ inh vĩ hã ki króm mũ ẽn hã vỹ iso há nĩ. Kỹ ũ tỹ iso há nĩ ẽn to inh panh tóg há tãvĩ nĩ. Ẽn to sóg há tãvĩ nĩ gé. Ẽn vỹ inh venh ke mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kỹ Judas tóg ti ki jẽmẽg mũ. Judas Iscariotes pijé', Judas ũ vẽ. Ẽn vỹ Jesus mỹ: “ẽg mỹ ã tóg vẽnh ven sór mũ,” he mũ, “hã ra ã tóg ũ tỹ ã ki ge sór tũ ag mỹ vẽnh ven sór tũ nĩ. Ã hẽ ri kenh ke mũ?” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Kỹ Jesus tóg ti mỹ: “ũ tỹ iso há nỹtĩ kar ag vỹ inh vĩ ki króm ke mũ,” he mũ. “Ũ tỹ inh vĩ ki króm mũ to inh panh tóg há nĩ, kỹ tóg ti mré ẽmãn ke mũ. Kỹ sóg ti mré ẽmãn ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ũ tỹ iso há tũ ẽn vỹ inh vĩ han sór ke tũ nĩ gé. Inh pi(jé) inh vĩ hã tó tĩ'. Ũ tỹ inh jẽnẽg mũ ẽn vĩ hã tó sóg tĩ, inh panh vĩ ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ãjag mré sóg nĩ nĩ ver, kỹ sóg ãjag mỹ tag kãmén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Isĩg kar kỹ sóg ãjag mỹ vẽsỹmér ũ tỹ ãjag tar han ke mũ ẽn jẽnẽnh ke mũ, hã vỹ: Topẽ kuprĩg, he mũ. Inh panh vỹ ãjag mỹ ti jẽnẽnh ke mũ. Ẽn vỹ nén ũ kar to ãjag kanhrãn há han ke mũ. Kỹ tóg ãjag mỹ tó mãn ke mũ gé, sỹ ãjag mỹ nén tó mũ kar ti, ãjag tỹ kã jatun tũ nĩ jé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ãjag krĩ kãnhvy han jé sóg ke mũ. Sỹ ãjag mỹ nén nĩm ke mũ hã vỹ: krĩ kãnhvy, he mũ. Hã ra tóg ũ tỹ inh ki ge jãvãnh ag krĩ kãnhvy sĩ ẽn ri ke tũ nĩ, sỹ ãjag mỹ ãjag krĩ kãnhvy han mũ ti. Krĩ kãnhvy pẽ ãjag nỹtĩnh ha. Hã kỹ krĩ kufy han tũg nĩ. Kanẽ jur han tũg nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Inh vĩ tag mẽ ãjag tóg huri, isỹ ãjag mỹ: “tĩg jé sóg ke mũ, kar kỹ sóg ãjag to vỹn kenh ke mũ gé,” he mũ ti. Ãjag tỹ iso há nỹtĩ ra tóg ãjag mỹ sér tĩnh mũ vẽ, isỹ inh panh venh tĩg ke ti. Inh panh vỹ inh kãfór nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ũri sóg ãjag mỹ tag kãmén mũ, ãjag tỹ ẽn venh ke to hã. Kỹ inh mĩ ẽkrén nĩ, ãjag tỹ ẽn venh ken kỹ. Ẽn kã inh ki ge kỹ nỹtĩmnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Isỹ ãjag mré vẽmén tag vỹ rur nĩ ha. Ẽprã pã'i mág jun ke nẽ ha. Hã ra ti pi(jé) tỹ inh krĩg mỹ ke nĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Hã ra sóg sỹ nén han ke mũ ẽn han sór mũ, ẽprã ke kar ag tỹ inh jykre ve jé, isỹ inh panh to há tãvĩ nĩ ti. Kỹ sóg inh panh tỹ inh mỹ nén tó mũ ẽn han kãn tĩ. Hã ven sór inh mũ, ẽprã ke kar ag mỹ. Mũ jé ha, re ra,” he tóg, Jesus ti. Ti tỹ ã mré mũ tĩ ag mỹ ag tỹ nén venh ke kãmén hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ag mũn kỹ Jesus tóg ag mỹ: “uva fa ri ke inh nĩ,” he mũ. “Inh panh vỹ ũ tỹ uva ki rĩr mũ ẽn ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Kỹ ãjag uva pẽ ri ke nỹtĩ,” he tóg. “Ũ tỹ inh vĩ han sór tũ ẽn ag hã vỹ uva pẽ kanẽn vãnh ẽn ri ke nỹtĩ. Ẽn kym kỹ tóg fón tĩ, inh panh ti, uva pẽ kanẽn vãnh ẽn ti. Ũn kanẽ há han mũ ẽn ki rĩr há han tóg tĩ, ẽn féj rógrãm tóg tĩ, ti pẽ kãsir nẽgnẽm tóg tĩ gé, ti tỹ kanẽ e han jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tag ri ke han ti tĩ, inh panh ti, ãjag tỹ. Ãjag tỹ há' he tóg huri, inh panh ti, ãjag tỹ inh vĩ kri nĩm tugrĩn. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Isovãnh tũg nĩ, kỹ sóg ãjag tovãnh ke tũ pẽ nĩ gé. Uva pẽ ẽn ri ke ti nĩ. Ti tỹ ti pẽ rógrãm kỹ tóg tóg mũ. Jãvo ti pẽ tỹ uva fa ẽn to nỹgtĩn kỹ tóg kanẽ há han tĩ. Ẽn ri ke ti nĩ, ãjag tỹ inh ki ge kỹ nỹtĩ tag ti. Ãjag tỹ inh ki ge kỹ nỹtĩn kỹ ãjag tóg vẽnh jykre há hã han kỹ nỹtĩ nĩ, jãvo ãjag tỹ isovãnh kỹ ãjag tóg vẽnh jykre há tovãnh ke mũ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Uva fa ri ke inh nĩ, kỹ ãjag tóg uva pẽ ri ke nỹtĩ gé. Ãjag tỹ inh ki ge kỹ nỹtĩn kỹ ãjag tóg kanẽ e han ke mũ, ãjag tỹ isovãnh tũ nĩn kỹ. Ãjag pi(jé) ãjag pir mỹ nén ũ há han ki kanhró nỹtĩ'. Inh hã ne ãjag tar han tĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ũ tỹ isovãnh ke mũ ẽn fón jé tóg ke mũ, inh panh ti. Ẽg tỹ uva pẽ kórég kym kỹ vãm ẽn ri ke tóg nĩ. Ẽg tỹ ti pẽ kym kỹ fón kỹ tóg tóg mũ, kỹ ẽg tóg ti pũn tĩ sir. Ẽn ri ke han jé tóg ke mũ, inh panh ti, ũ tỹ isovãnh mũ ẽn tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ãjag tỹ isovãnh tũ nĩn kỹ, ãjag tỹ isỹ ãjag mỹ nén tó mũ ẽn to jykrén kỹ nỹtĩn kỹ, kỹ inh mỹ nén kar to vĩmnĩ. Han jé sóg ke mũ, ãjag mỹ, ãjag tỹ inh mỹ nén to vĩ mũ ẽn ti, ha vemnĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ãjag tỹ vẽnh jykre há han kỹ tóg uva pẽ tỹ kanẽ e han ri ke nĩ. Kỹ vẽnh kar ag tóg ãjag jykre ve kỹ Topẽ to: “ũn há vỹ tỹ ti nĩ,” henh ke mũ. Hã ki ag tóg ki kanhró nỹtĩnh mũ, ãjag tỹ tỹ inh mré ke nỹtĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Inh panh vỹ iso há tãvĩ nĩ. Ge inh nĩgtĩ gé, ãjag to. Ãjag to ha pẽ sóg nĩ gé. Inh ki ge kỹ nỹtĩmnĩ, sỹ ãjag to há tãvĩ nĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ãjag tỹ isỹ ãjag mỹ nén tó mũ ki króm kỹ ãjag tóg inh ki ge kỹ nỹtĩnh mũ, kỹ sóg ãjag to há nĩ gé. Hã kỹ sóg inh panh vĩ hã ki króm kãn mũ, kỹ tóg iso há tãvĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Inh mỹ tóg sér tĩ. Kỹ sóg ãjag mỹ tag tó mũ, ti tỹ ãjag mỹ sér tĩn jé gé, ti tỹ inh mỹ sér ẽn ri ke tĩn jé gé, ãjag mỹ. Ti tỹ ãjag mỹ sér tĩ hã jé sóg ãjag mỹ inh jykre kãmén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Sỹ ãjag mỹ vẽnh jykre nĩm mũn hã vẽ, ha mẽ. Jagnẽ to há pẽ nỹtĩmnĩ, sỹ ãjag to há nĩ ẽn ri ke han nĩ, he sóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ũ tỹ ã mré ke ũ ag jagfy ter sór mũ ẽn vỹ ag to há ja nĩgtĩ. Ũ tỹ ẽg to há kãfór pẽ ẽn venh ke tũ ẽg tóg nĩ, ẽprã. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Inh mré ke pẽ vỹ tỹ ãjag nỹtĩ, ãjag tỹ inh vĩ ki króm kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Hã kỹ sóg ãjag to: “inh camarada ag,” he tũ nĩgtĩ gé. Ẽg pi(jé) ẽg camarada ẽn ag mỹ ẽg tỹ nén to jykrén mũ ẽn kãmén tĩ'. Ẽg mré ke ag hã mỹ ẽg tóg kãmén tĩ. Ãjag mỹ sóg inh panh tỹ inh mỹ nén tó mũ ẽn kãmén kãn huri, hã kỹ sóg ãjag to: “inh mré ke ag,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ãjag pi(jé) inh kuprẽg'. Inh hã ne ãjag kuprẽg'. Kỹ sóg ãjag mỹ: “kanẽ e han nĩ,” he mũ ha, hã vỹ: vẽnh jykre há, he mũ. Vẽnh jykre há hã vỹ tũ' henh ke tũ nĩ. Ãjag tỹ ẽn han kỹ jatun mỹ Topẽ mỹ nén kar to vĩmnĩ, inh jyjy tó kỹ. Ãjag tỹ ti mỹ nén ũ to vĩ mũ ẽn han jé tóg ke mũ, Topẽ ti, ãjag tỹ vẽnh jykre há han kỹ nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sỹ ãjag mỹ nén tó mũn hã vẽ, hã vỹ: jagnẽ to há nỹtĩmnĩ, sỹ ãjag to há nĩ ẽn ri ke, he mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ũ tỹ inh ki ge tũ ag vỹ iso jũ vén ja nĩgtĩ, kỹ ag tóg ãjag to jũ nỹtĩ gé. Tag mĩ ẽkrén nĩ, ag tỹ ãjag to jũnh ken kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ãjag pi(jé) tỹ ag mré ke nỹtĩ'. Ãjag tỹ tỹ ag mré ke nỹtĩ ra ag tóg ãjag to há nỹtĩnh ke mũ vẽ, hã ra ãjag tóg tỹ ag mré ke tũ nỹtĩ. Ãjag kuprẽg inh, ag kãmĩ, ãjag tỹ tỹ inh mré ke nỹtĩ jé, hã kỹ ag tóg ãjag to jũ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Vãsỹ sóg ãjag mỹ: “ãjag pi(jé) inh kãfór nỹtĩ',” he ja nĩgtĩ. Tag mĩ ẽkrén nĩ. Inh camarada ri ke ãjag nỹtĩ, jãvo sóg tỹ ãjag patrão ri ke nĩ. Ag kãmĩ ũ tóg inh vóg kónãn ke mũ. Ẽn vỹ ãjag vóg kónãn ke mũ gé. Ag kãmĩ ũ tóg inh vĩ ki króm tĩ. Ẽn ag vỹ ãjag vĩ ki króm ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Hã ra ag tóg ãjag vóg kónãn ke mũ gé, ãjag tỹ tỹ inh mré ke nỹtĩn kỹ. Ag pi(jé) ũ tỹ inh jẽnẽg mũ ẽn ki kanhró nỹtĩ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Inh kãtĩ tũ ra, isỹ ag mỹ inh vĩ tó tũ ra ag tóg: “hã ra ẽg tóg ki kagtĩg nỹtĩ,” henh ke mũ vẽ. Hã ra sóg ag mỹ tó, hã kỹ ag tóg ki kanhró nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ũ tỹ iso jũ nỹtĩ ẽn ag vỹ inh panh to jũ nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nén ũ han vãnh hyn han sóg tĩ, ag rĩnve, kỹ ũ vỹ tag han ja tũ pẽ nĩ ijo. Isỹ tag han tũ nĩ ra ag tóg: “vég tũ ẽg nĩ,” henh ke mũ vẽ. Hã ra ag tóg vé, ag tỹ vég mũ ra ag tóg ge ra iso jũ nỹtĩ, kỹ ag tóg inh panh to jũ nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Hã ra ag tóg rán kỹ nỹtĩ, Topẽ vĩ tỹ rán kỹ nĩ ki. “Nén ũ tũ to ag tóg iso jũ sór mũ,” he tóg, Topẽ vĩ rá ki. Hã kỹ ag tóg ke tĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Hã ra tóg kãtĩg ke mũ, ũ tỹ ãjag tar han ke ti. Topẽ kuprĩg to ken hã vẽ. Ti hã vỹ ki hã tónh ke mũ, inh panh kuprĩg ti. Ẽn hã vỹ ãjag mỹ inh kãmén ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kỹ ãjag tóg vẽnh kar mỹ inh kãmén ke mũ gé, ẽn kã. Inh mré ãjag tóg mũ ja nĩ, isỹ ãjag mỹ tó vén mũn kã,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ãjag mỹ sóg tag kãmén kãn mũ, ãjag tỹ ki kanhró nỹtĩ jé, ãjag tỹ isovãnh sór tũ pẽ nĩ jé, ãjag jagtar ke kurã ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ãjag pan jé ag tóg ke mũ, pã'i ag, ãjag tỹ vẽnh kanhrãn jafã ra mũ mãn tũ nĩ jé. Kỹ ag tóg ãjag kãgtén ke mũ gé. Ãjag kãgtén kỹ ag tóg ón kỹ: “Topẽ vỹ ẽg mỹ tó, hã kỹ ẽg tóg ag kãgtén,” henh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ag tỹ ẽg jóg mág ki kagtĩg nỹtĩ hã kỹ ag tóg tag han ke mũ. Inh ki kagtĩg ag tóg nỹtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ũri sóg ãjag mỹ tó mũ. Kỹ ãjag tóg, ãjag tỹ tag ve kỹ (ãjag tóg): “ẽg mỹ tóg tó ja nĩ, ẽg tỹ ũri nén vég mũ tag ti,” henh ke mũ,” he tóg, Jesus ti. Vãsỹ sóg ãjag mỹ tag tó ja tũ nĩ ver. Vãsỹ sóg ãjag mré tĩg nĩ vẽ, hã ra sóg ãjag mỹ tag tó ja tũ nĩ, sỹ ũri ãjag mỹ nén tó mũ tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ũri sóg tĩg ke mũ, isỹ ũ tỹ inh jẽnẽg mũ ẽn ve jé. Kỹ ãjag pi(jé) inh mỹ: “ã tỹ hẽ ra tĩg ke nẽ?” henh ke mũ'. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ãjag mỹ tóg e tĩ, sỹ ãjag mỹ isĩg ke tag tó ja nĩn kỹ, kỹ ãjag tóg fe kaj nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Há ti nĩ hã ra, isĩg ke ti, ha mẽ. Isĩg tũ nĩn kỹ ũ tỹ ãjag tar han mũ ẽn vỹ kãtĩg ke tũ nĩ vẽ, Topẽ kuprĩg ti. Isĩg kỹ sóg ãjag mỹ ti jẽnẽnh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ẽn vỹ, ã kãtĩg kỹ (tóg) vẽnh kar mỹ: “Topẽ vĩ mranh ã huri,” henh ke mũ, kỹ tóg ag mỹ vẽnh jykre kuryj tónh ke mũ gé, kỹ tóg ag mỹ Topẽ tỹ ag vóg kónãn ke ẽn tónh ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","“Jesus ki ã tóg rã tũ nĩ, hã kỹ ã tóg Topẽ vĩ mranh tĩ,” he jé tóg ke mũ, vẽnh kar mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kỹ tóg ag mỹ vẽnh jykre kuryj tónh ke mũ gé, Topẽ kuprĩg ti. Jãvo sóg tĩg ke mũ, inh panh kukãm, kỹ ag tóg inh venh ke tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kỹ Topẽ kuprĩg tóg ag mỹ Topẽ tỹ ag vóg kónãn ke ẽn tónh ke mũ gé. Tag ki ũn tỹ tỹ ũn mág pẽ tỹ Nén-Kórég ẽn to tóg: “kórég ti nĩ,” hé huri, Topẽ ti. Hã to ẽg tóg ti tỹ ũn vóg kónãn ke mũ ẽn ag ki kanhró nỹtĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Sỹ ãjag mỹ nén tónh ke mũ vỹ ver e nỹtĩ, hã ra tóg ver ãjag mỹ mẽ jagy tĩ, hã kỹ sóg tónh ke tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Topẽ kuprĩg tỹ ãjag ki jun kỹ, ũ tỹ ki hã tó tĩ ẽn kãtĩg kỹ tóg komẽr hã ãjag mỹ tó kãn ke mũ, nén tỹ ki hã tó mũ ẽn ti. Ti pi(jé) ã tỹ nén to jykrén mũ ẽn tónh ke mũ', Topẽ kuprĩg ti. Inh panh tỹ inh mré nén to jykrén mũ ẽn hã tó jé tóg ke mũ. Kỹ tóg ãjag mỹ ãjag tỹ kar kỹ nén venh ke ẽn tónh ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ti hã vỹ iso: “ũn mág vỹ tỹ ti nĩ,” henh ke mũ gé. Inh vĩ hã tó jé tóg ke mũ ãjag mỹ, hã kỹ tóg isỹ tỹ ũn mág nĩ tónh ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Inh panh tỹ nén tó mũ ẽn hã tó sóg tĩ gé. Kỹ tóg ẽn hã tónh ke mũ gé, ti kuprĩg ti. Hã kỹ sóg ãjag mỹ: inh vĩ hã tó jé tóg ke mũ,” he mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kãnhmar ãjag tóg inh ve mãn ke tũ nĩ ha, kejẽn ãjag tóg kurã ũ ki inh ve mãn ke mũ gé,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Kỹ ti mré mũ tĩ ag tóg jagnẽ mỹ: “ti hỹn ne tó sór mũ, hã kỹ tóg: kãnhmar ãjag tóg inh ve mãn ke tũ nĩ ha, he mũ, hã kỹ tóg: kejẽn ãjag tóg kurã ũ ki inh ve mãn ke mũ gé, he mũ?” he ag tóg. “Ti tỹ ne tónh ke nẽ hỹn, hã kỹ tóg: inh panh kukãm sóg tĩg mũ ha, he mũ?” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Ne to ke nẽ hỹn, hã vỹ: kãnhmar, he mũ? Ẽg pi(jé) ti tỹ nén tó mũ ẽn ki kanhró nỹtĩ',” he ag tóg, jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Hã ra Jesus tóg ki kanhró nĩ, ag tỹ ti ki nén jẽmẽ sór mũ ẽn ki. Hã kỹ tóg ag mỹ: “inh vĩ mỹ ãjag mỹ e?” he mũ. “Kãnhmar ãjag tóg inh ve mãn ke tũ nĩ ha, kejẽn hã ãjag tóg kurã ũ ki inh ve mãn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ki hã sóg tó mũ, hã kỹ sóg ke mũ. Kygfỹ jé ãjag tóg ke mũ. Vẽsỹrénh jé ãjag tóg ke mũ. Hã ra tóg ũ tỹ inh ki ge tũ ag hã mỹ sér tĩnh mũ. Fe kaj han jé ãjag tóg ke mũ, tag pãte tóg ãjag mỹ sér tĩnh mãn ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ũn tỹtá fi tỹ gĩr venh ken kỹ tóg fi mỹ jagy tĩ, fi kaga jagy ẽn ti. Fi kósin tỹ fi ki mur kar kỹ tóg hã ra fi mỹ sér tĩ, kỹ fi tóg ã kaga ẽn mĩ ẽkrén mãn tũ nĩgtĩ. Fi tỹ ã kósin ve kỹ tóg fi mỹ sér tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ge ve jé ãjag tóg ke mũ. Ũri tóg ãjag mỹ jagy tĩ, hã ra sóg ãjag ve mãn ke mũ, kỹ ãjag fe tóg mrin kenh ke mũ, ãjag tỹ inh ven kỹ. Kỹ ũ tóg ãjag fe kaj han mãn ke tũ nĩ ha, inh kãtĩg mãn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ẽn kã ãjag tóg inh mỹ nén ũ to vĩ mãn ke tũ nĩ ha, isỹ ãjag mré nĩn kỹ. Ki hã sóg tó mũ, hã kỹ sóg ke mũ. Ãjag tỹ inh panh mỹ nén ũ to vĩn kỹ tóg ãjag mỹ vin kãn ke mũ, ãjag tỹ ti mỹ nén ũ to vĩ mũ ẽn tỹ, ãjag tỹ tỹ inh mré ke nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ver ãjag tóg ti mỹ nén ũ to vĩ ja tũ nĩ, ãjag tỹ ti mỹ: “ti mré ke vỹ tỹ ẽg nỹtĩ,” hen kỹ. Ti mỹ nén ũ to vĩmnĩ, kỹ tóg ãjag mỹ hyn han kãn ke mũ, ãjag tỹ nén to vĩ mũ ẽn ti, kỹ tóg ãjag mỹ sér tãvĩ tĩnh mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ãjag mỹ sóg comparação han kỹ inh panh kãmén tĩ, kãnhmar sóg jamã hár(a) ãjag mỹ inh panh kãmén ke mũ, kỹ sóg ãjag mỹ comparação han mãn ke tũ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kurã ẽn kã ãjag tóg vẽsóg ki inh panh mỹ nén ũ kar to vĩnh ke mũ, ãjag tỹ tỹ inh mré ke nỹtĩn kỹ. Kỹ sóg ãjag jagfy vĩ mãn ke tũ nĩ ha, ãjag tỹ vẽsóg ki ti mré vẽmén kỹ. Ãjag hã vỹ ti mré vẽmén ke mũ ha. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Inh panh vỹ ãjag to há tãvĩ nĩgtĩ, ãjag tỹ iso há nỹtĩn kỹ, ãjag tỹ iso: “Topẽ vỹ ti jẽnẽ,” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Inh panh tỹ inh jẽnẽn hã kỹ sóg ga tag ki jun mũ. Hã ra sóg ũri inh mur ja ré kỹ tĩg ke mũ ha, inh panh kukãm,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kỹ ti mré mũ tĩ ag tóg ti mỹ: “vãhã ã tóg ẽg mỹ kãmén há han mũ ha,” he mũ. “Vãhã ã tóg ẽg mỹ comparação tó tũ nĩ ha. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nén ũ kar ki kanhró ã tóg nĩ, vég ẽg tóg mũ. Ẽg tỹ ã ki nén ũ jẽmẽ sór kỹ ã tóg ki kanhró nĩ. Ẽg tỹ ã mỹ nén ũ tó tũ ra ã tóg ki kanhró nĩ. Hã ki ẽg tóg vég mũ, ã tỹ Topẽ tá kãtĩg ja ti,” he ag tóg mũ, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Kỹ tóg ag mỹ: “vãhã ãjag tóg inh ki ge kỹ nỹtĩ ha,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","“Hã ra ãjag tóg kãnhmar inh ré kỹ mũ kãn mũ ha, ãjag ĩn ra. Vẽnh kã pugpóv kãn jé ãjag tóg ke mũ, ũri. Hã ra sóg pir pẽ tũ nĩ, ãjag tỹ inh ré kỹ mũ kãn mũ (hã) ra. Inh panh vỹ ẽgno kã inh mré jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tag kãmén sóg ãjag mỹ, ãjag tỹ krĩ kãnhvy nỹtĩ jé, ãjag tỹ inh ki ge kỹ nỹtĩ tugrĩn. Tag ki ãjag tóg nén ũ jagy kar vég tĩ ver. Hã ra to krĩ kufy han tũg nĩ. Ẽprã ke kar kri ke vỹ tỹ inh nĩ, ẽprã ke kri pã'i ẽn, Japo ẽn kutẽm inh huri,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus tỹ ã mré mũ tĩ ag mỹ tag kãmén kãn kar kỹ tóg kanhkã ki ẽvãnh mũ, kỹ tóg: “panh',” he mũ. “Inh hora tán krỹg huri,” he tóg. “Ag mỹ isỹ tỹ ũn mág nĩ ven nĩ, isỹ tỹ ã kósin nĩn kỹ. Kỹ sóg ag mỹ ã tỹ tỹ ũn mág nĩ ven ke mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ẽprã ke kar kri ã tóg inh fẽg, isỹ ag mỹ rĩr krỹg ja tũ ven jé, ã tỹ inh mỹ ũn vin mũ kar ẽn ag mỹ, fag mỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ũ tỹ ã ki kanhrãn mũ ẽn vỹ rĩr krỹg ja tũ venh ke mũ, ũ tỹ ã to: “Topẽ vẽ,” he mũ kar ag, ũ tỹ ã to: “Topẽ ũ vỹ tũ nĩ,” he mũ kar ag, fag kar ke gé. Kỹ ag tóg inh ki kanhró nỹtĩ gé, isỹ tỹ Jesus Cristo nĩn ki, ã hã tỹ inh jẽnẽ ẽn ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ag hã mỹ sóg ã tỹ tỹ ũn mág nĩ tag ven, ẽprã ke ag mỹ, fag mỹ ke gé. Ã tỹ inh mỹ nén tó mũ ẽn han kãn inh. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Vãsỹ, ẽg tỹ ga tag han tũg ki sóg ã mré nĩ ja nĩgtĩ, ẽn kã sóg tỹ ũn mág pẽ nĩ ja nĩgtĩ, ã mré. Ẽn han mãn nĩ, inh mỹ. Isỹ tỹ ũn mág pẽ nĩ han mãn nĩ, panh'. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ũ ag kuprẽg ja ã nĩ, ag tỹ inh ki ge jé, fag ke gé. Ẽn ag mỹ sóg ã kãmén ja nĩgtĩ. Ã tũ ag vẽ, hã ra ã tóg inh mỹ ag vin, fag ke gé. Ã vĩ ki króm ag tóg tĩ, fag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ũri ag tóg ki kanhró nỹtĩ, isỹ ã tũ hã han mũ ẽn ki, fag ke gé. Ã hã ne inh mỹ nén kar ẽn tó tĩ'. Tag vég ag tóg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ag mỹ sóg ã vĩ ti tó tĩ, kỹ tóg ag mỹ sér tĩ, fag mỹ ke gé. Kỹ ag tóg vég mũ, ã tỹ inh jẽnẽ ẽn ti. Kỹ ag tóg iso: “Topẽ tỹ ũn jẽnẽg mũ ẽn vẽ,” he mũ, fag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ã tỹ inh mỹ ũn vin mũ ẽn ag hã jagfy sóg vĩ tĩ, fag ke gé. Ũ tỹ inh ki ge tũ ẽn ag jagfy sóg vĩnh ke tũ nĩ. Ã tũ ag hã jagfy sóg vĩ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ha vé, isũ kar vỹ tỹ ã tũ nỹtĩ, kỹ ã tũ kar vỹ tỹ isũ nỹtĩ gé. Ag hã tugrĩn sóg tỹ ũn mág nĩ, ũ tỹ inh ki ge kỹ nỹtĩ ẽn ag hã tugrĩn, fag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Inh mur ja ré kỹ sóg tĩg mũ, ijãvo ag tóg ẽgno mĩ mũ nĩ sir, isũ mré ã tũ ag. Ag jãvo sóg ã venh kãtĩg mũ ha. Inh panh mág, há tãvĩ ã tóg nĩ. Ag jy nĩgãn nĩ, ã jykre ki. Ã hã ne inh mỹ ag vin'. Ã mré sóg tỹ ũn pir nĩ. Ag tỹ jagnẽ mré tỹ ũn pir nỹtĩ han nĩ, isỹ ã mré tỹ ũn pir nĩ tag ri ke han nĩ, ag tỹ, fag tỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Isỹ ag mré nĩn kỹ sóg ag jy nĩgãn tĩ, ã jykre ki, ã tỹ inh mỹ ũn vin mũ ẽn ag kar jy, fag jy ke gé. Ag ki rĩr há han inh, kỹ ag kã ũ tóg vãfor ja tũ nĩ. Ũn pir tóg hã ra vãfor kỹ nĩ inhhã, hã ra tóg ti to rán kỹ nĩ, ti tỹ nũgme ki kutẽnh ke ti, hã kỹ ti tỹ ki kutẽnh ke nẽ ha. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ũri sóg ã kukãm kãtĩg mũ, hã ra sóg ver tag ki ag mỹ kãmén mũ, ti tỹ ag mỹ sér tĩ jé, ti tỹ inh mỹ sér tĩ tag ri ke tĩ jé, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ag mỹ sóg hur ã vĩ kãmén. Kỹ ũ tỹ inh ki ge tũ ag vỹ ag to jũ mũ, ag tỹ tỹ ag mré ke tũ nỹtĩn kỹ. Inh pi(jé) tỹ ag mré ke nĩ gé', ũ tỹ ag to jũ mũ ẽn mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Hã ra sóg ã mỹ: “ha ag jé prẽr,” he tũ nĩ, “ag tỹ ga tovãnh jé,” he tũ sóg nĩ. “Nén-Kórég jo ag jy nĩgãn nĩ,” he sóg mũ ã mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ag pi(jé) tỹ inh ki ge tũ ag mré ke nỹtĩ'. Tỹ sóg ag mré ke tũ nĩ gé, ũ tỹ inh ki ge jãvãnh ẽn ag mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ã vĩ há ki ag kanhrãn nĩ, ã tỹ ũn kuprẽg mũ ẽn ag, ag tỹ komẽr hã ã ri ke nỹtĩ jé. Ã vĩ ẽn vỹ tỹ vẽnh vĩ há tãvĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Inh jẽnẽ ã tóg, sỹ ga kri mur jé. Kỹ sóg ã kóm ag jẽgnẽnh mũ, ag tỹ ẽprã ke kar ẽn ag mỹ inh kãmén jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ag jagfy sóg ã mỹ vẽnh fẽg ke mũ, ag tỹ inh mré ã mỹ vẽnh vin kỹ nỹtĩ jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Hã ra sóg nén ũ to vĩ sór mũ gé, sỹ ã mỹ ag kãmén kar kỹ. Ũ ag tóg ag vĩ mẽ kỹ inh ki genh ke mũ. Ẽn ag to sóg vĩ sór mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ag kar tỹ tỹ ũn pir nỹtĩnh ken kỹ tóg há tĩ, ã tỹ inh mré tỹ ũn pir nĩ ẽn ri ke, isỹ ã mré tỹ ũn pir nĩ ẽn ri ke. Ag tỹ ẽg mré tỹ ũn pir nỹtĩn kỹ tóg há tĩ. Kỹ vẽnh kar vỹ venh ke mũ, ã tỹ nén to inh jẽnẽg mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Isỹ ã tóg ũn mág han. Kỹ sóg ag tỹ ũn mág han ke mũ gé, ag tỹ jagnẽ mré tỹ ũn pir nỹtĩ jé, ã tỹ inh mré tỹ ũn pir nĩ tag ri ke. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Inh mré ke vỹ tỹ ag nỹtĩ, kỹ sóg tỹ ag mré ke nĩ gé, kỹ ẽg kar vỹ tỹ ũn pir ri ke nỹtĩ. Ẽg tỹ tỹ ũn pir nỹtĩ tugrĩn vẽnh kar tóg venh ke mũ, ã tỹ inh jẽnẽ ẽn ti. Ũn tỹ inh ki ge kỹ nỹtĩ ẽn ag to há tãvĩ ã tóg nĩ, ã tỹ iso há nĩ tag ri ke. Tag ve jé ag tóg ke mũ, ẽprã ke ag, ag tỹ ẽg tỹ tỹ ũn pir nỹtĩ tag ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Panh', vãsỹ ã tóg iso há nĩgtĩ vẽ, ẽg tỹ ga tag han tũg ki. Hã kỹ ã tóg isỹ ũn mág pẽ han. Kỹ tóg inh mỹ há tĩnh mũ, ag tỹ inh mré nỹtĩn kỹ, ã tỹ inh mỹ ũn vin mũ ẽn ag. Ag tỹ inh mré nỹtĩn kỹ ag tóg venh ke mũ, ã tỹ isỹ ũn mág han ja ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Panh', jykre kuryj ã tóg nĩ. Ũ tỹ inh ki ge tũ ag vỹ ã ki kagtĩg nỹtĩ, ag jãvo sóg ã ki kanhró nĩ. Kỹ tag ki inh mré nỹtĩ ag vỹ ki kanhró nỹtĩ gé, ã tỹ nén to inh jẽnẽg mũ ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ag mỹ sóg ã kãmén huri, kỹ sóg ag mỹ ã kãmén mãn ke mũ gé, ag tỹ jagnẽ to há nỹtĩ jé, ag tỹ ã tỹ iso há tag ri ke nỹtĩ jé. Kỹ sóg ag mré ẽmãn ke mũ gé,” he tóg, Jesus ti, ã panh mré vẽmén kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus tỹ tag tó kar kỹ tóg ã mré mũ tĩ ag mré tĩ mũ sir. Goj tỹ Cedrom kafã ũ ra ag tóg pa mũ sir. Tá ka tóg krãnkrãn kỹ nỹtĩ. Ka kré ẽn krẽm ag tóg nĩgnĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hã ra Judas tóg ti tĩg ẽn ki kanhró nĩ gé. Tã tóg ã mré mũ tĩ ag mré vẽmén tỹ hẽn ri ke han huri, Jesus ti, hã kỹ Judas tóg ag tỹ ra mũnh ke ki kanhró nĩ, ũ tỹ pã'i ag mỹ Jesus ve ke mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kỹ tóg ag nón tá jun mũ sir, Judas ti, soldado ag mré, polícia ag mré hã ke gé, pã'i ag tỹ ag jẽgnẽn kỹ. Fariseu ag vỹ pã'i ag mré polícia ag jẽgnẽ ja nĩ gé. Lampião e gég ag tóg kãmũ mũ, pĩ jónhkó ke gé, ka kykyv mré hã. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Hã ra Jesus tóg ki kanhró nĩ, ã jagtar ken ki, kỹ tóg ag kato tẽ mũ sir. Kỹ tóg ag mỹ: “ãjag tỹ ũ tỹ hẽ ve sór nẽ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kỹ ag tóg ti mỹ: “Nazaré tá ke ẽn ve sór ẽg tóg mũ,” he mũ. “Jesus vẽ mỹr,” he ag tóg mũ. Kỹ Jesus tóg ag mỹ: “inh hã vẽ,” he mũ. Hã ra Judas tóg ag mré kãtĩg ja nĩ gé, ũ tỹ pã'i ag mỹ Jesus ven mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesus tỹ ag mỹ: “inh hã vẽ,” hen kỹ ag tóg ti jo ranh ke mũ. Rom ke ag tóg mũ sir, ẽprã. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kỹ Jesus tóg ag mỹ vĩ mãn mũ. “Ãjag tỹ ũ ve sór nẽ?” he tóg. Kỹ ag tóg ti mỹ: “Jesus, Nazaré tá ke ẽn,” he mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kỹ Jesus tóg ag mỹ: “ãjag mỹ sóg: inh hã vẽ, hé huri. Kỹ ãjag tỹ ise sór kỹ inh mré ke tag ag togvãnh nĩ sir,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Hã ra tóg tag tó, ã tỹ to hã ã panh mỹ: “ã tỹ inh mỹ ũn vin ja ẽn ag vỹ ki nỹtĩ, ag kãki ũ vỹ vãfor ja tũ nĩ,” he jan kỹ. Ã tỹ ag jy nĩgãn jé tóg polícia ag mỹ: “ag togvãnh ra,” he mũ, ã mré mũ tĩ ag to. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Hã ra Simão Pedro tóg ã rógro ẽn vyn kỹ tóg polícia ag kãki ũ nĩgrẽg kym ke mũ. Ti pẽgja tá ti nĩgrẽg jẽ ẽn tỹ tóg kym ke mũ. Topẽ tũ ki rĩr tĩ to pã'i mág camarada ja vẽ, ti tỹ ũ nĩgrẽg kym mũ ẽn ti, ti jijin hã vỹ: Malco, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kỹ Jesus tóg Pedro mỹ: “ã rógro tỹ ti pãg ja tá fẽg,” he mũ. “Inh panh tỹ inh mỹ: “vẽsỹrénh jé ã tóg ke mũ,” he ja vẽ, hã kỹ sóg ag mỹ vẽnh fẽg ke mũ ha. Vẽnh nenh ke tũ sóg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kỹ soldado ag tóg, ãjag pã'i mré (ag tóg) Jesus mrĩnh mũ sir, vãfe tỹ. Polícia ag vỹ ag mré ti mrĩnh mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kỹ ag tóg ti pére mũ mũ, Anás ĩn ra. Caifás kakrã vẽ, Anás ti, hã ra Caifás vỹ tỹ Topẽ tũ ki rĩr tĩ ag to pã'i mág nĩ, prỹg ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hã ra Caifás ẽn vỹ pã'i ag mỹ: “ũn pir tỹ ẽg povo jagfy ter kỹ tóg pãgsĩ nĩ,” he ja nĩ. Ẽn kakrã ĩn ra ag tóg Jesus pére mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kỹ Simão Pedro tóg Jesus nón tĩ mũ, Jesus mré ke ũ mré. Hã ra Jesus mré ke ũ ẽn tóg Topẽ tũ ki rĩr tĩ ag to pã'i mág ẽn ki kanhró nĩ, hã kỹ tóg Jesus nón Anás ĩn kãra rã mũ, ĩn vãso ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Hã ra Pedro tóg re tá jẽ nĩ, ĩn jãnkã rã hã. Kỹ Jesus mré ke ũ ẽn tóg ver ũ tỹ jãnkã ki rĩr mũ ẽn fi mré vẽmén mũ, kỹ fi tóg Pedro ti mỹ: “ha kãrã,” he mũ, ti mré ke ũ ẽn tỹ pã'i mág ki kanhró nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kỹ fi tóg ti mỹ: “ã hỹn tỹ Jesus mré ke nĩ,” he mũ, Pedro ti mỹ, ũ tỹ jãnkã ki rĩr jẽ ẽn fi. Hã ra tóg fi mỹ ón kỹ: “vó,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hã ra Anás camarada ũ ag vỹ tá nỹtĩ gé, polícia ag mré. Ĩn vãso ki ag tóg pĩ han kỹ nỹtĩ, ti tỹ kusa jagy tĩn kỹ. Pĩ to ag tóg tugtón nỹtĩ. Kỹ Pedro tóg ag mré tón nĩ gé, pĩ ẽn ti to. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kỹ pã'i mág tóg Jesus mỹ: “inh mỹ ã mré mũ tĩ ag kãmén,” he mũ. “Ã tỹ nén kãmén tĩ ẽn ti kãmén nĩ gé, inh mỹ,” he tóg, Anás ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Kỹ Jesus tóg ti mỹ: “vẽnh kar mỹ sóg jamã hár(a) tó tĩ,” he mũ. “Vẽnh kanhrãn jafã krẽm sóg tó tĩ, Topẽ jo ĩn krẽm ke gé. Judeu kar tỹ vẽnhmãn kỹ nỹtĩn kỹ sóg ag mỹ kãmén tĩ. Inh pi(jé) vẽnh péju kỹ tó tĩ', kỹ vẽnh kar vỹ ki kanhró nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hã ra ã tóg inh ki jẽmẽ sór mũ'. Inh vĩ jẽmẽg mũ ẽn ag ki jẽmẽmnĩ. Ki kanhró ag tóg nỹtĩ, isỹ ag mỹ nén tó ja ẽn ki,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus tỹ tag tó kỹ polícia ũ tóg Jesus tãnh mũ, kỹ tóg ti mỹ: “pã'i mág vẽ mỹr,” he mũ. “Hã ra ã tóg ti mỹ vĩ mũ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kỹ Jesus tóg ti mỹ: “kỹ inh hỹn vẽnh vĩ kórég tỹ ne tó?” he mũ. “Ha inh mỹ sỹ vẽnh vĩ kórég tó mũ ẽn tó,” he tóg. “Vĩ há han inh, ã tỹ hã ra ne tugnĩn isãnh nẽ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tag pãte Anás tóg Jesus jẽnẽg mũ sir, ti tỹ Caifás venh tĩg jé, Topẽ tũ ki rĩr tĩ ag to pã'i mág ẽn mỹ. Ti mrĩnh kỹ jẽ kỹ tóg ti jẽnẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Hã ra Simão Pedro tóg tón nĩ nĩ, pĩ to. Kỹ tá nỹtĩ ag tóg ti mỹ: “ã hỹn tỹ ti mré ke nĩ gé,” he mũ. Hã ra tóg ón kỹ: “vó,” he mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kỹ pã'i mág mỹ rãnhrãj tĩ ũ vỹ tá nĩ gé. Pedro tỹ ũ nĩgrẽg kym ja ẽn kanhkã ũ vẽ. Ẽn vỹ Pedro mỹ: “ã ve inh, ka kré krẽm,” he mũ. Tá ã tóg ti mré jẽ ja nĩ,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Hã ra Pedro tóg ón kỹ ti mỹ: “vó,” he mãn mũ. Ẽn kã galo vỹ kynkyr mũ ha. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kusã pẽ ki ag tóg Jesus pére mũ mũ, pã'i tỹ governador ĩn ra, ti vẽmén jafã ra, palácio ẽn ra. Caifás ĩn tá ag tóg ti pére kãpa mũ. Hã ra ag tóg pã'i tỹ governador ĩn kã ra ge sór tũ nĩ. Ag tỹ festa tỹ Páscoa han ke vỹ kakó tĩ ha, kỹ ũ tỹ pã'i tỹ governador ĩn kã ra ge mũ vỹ festa tỹ Páscoa ẽn ki jẽn ke tũ nĩ. Ag jykre vẽ. Hã ra ag tóg ko sór mũ, hã kỹ ag tóg kã ra ge ja tũ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kỹ Pilatos tóg re ra kãkutẽ mũ, ag mré vẽmén jé. Kỹ tóg ag mỹ: “ti hẽ ri ké?” he mũ. “Ti vẽnh jykre kórég tỹ ne han'?” he tóg, Pilatos ti, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kỹ ag tóg ti mỹ: “vẽnh jykre kórég han ti tĩ,” he mũ. “Ti há nĩ ra ẽg tóg ã mỹ ti ven ke tũ nĩ vẽ,” he ag tóg, Pilatos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kỹ Pilatos tóg ag mỹ: “ha mũjẽg,” he mũ. “Ãjag jykre ki ãjag tóg ti jykre kórég ẽn to jykrén kỹ tónh ke mũ, ti jykre ti,” he tóg. Hã ra ag tóg ti mỹ: “ti ter ke vẽ,” he mũ. “Kỹ ã hã vỹ ẽg mỹ: “ha ti tén,” henh ke mũ,” he ag tóg, pã'i ag, Pilatos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hã ra Jesus tóg ag tỹ fóg tỹ pã'i mỹ ã fẽg ke tag tó ja nĩ, fóg ag tỹ cruz to ti sa kỹ ti tén jé. Hã kỹ ag tóg Pilatos mỹ ti ven mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kỹ Pilatos tóg ã ĩn kãra rã mãn mũ, Jesus mré vẽmén jé. Kỹ tóg ti mỹ: “ã mỹ tỹ Judeu ag pã'i mág nĩ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Kỹ Jesus tóg ti mỹ: “ũ nỹ ã mỹ tag tó?” he mũ. “Ã tỹ vẽsóg ki to jykrén mỹ vó, pã'i ag tỹ ã mỹ tó mỹ vó?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kỹ Pilatos tóg: “inh pi(jé) tỹ Judeu nĩ',” he mũ. “Ã kanhkã ag vỹ inh mỹ ã fẽg, ã povo to pã'i ag. Ã hẽ ri ké?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kỹ Jesus tóg ti mỹ: “inh pi(jé) tỹ ga tag kri pã'i mág nĩ',” he mũ. “Isỹ tỹ tag ki ũn mág nĩ ra inh krẽm ke ag tóg Judeu ag mré jagnẽ génh ke mũ vẽ, kỹ ag tóg isenh ke tũ nĩ vẽ. Hã ra sóg tag ki tỹ ũn mág tũ nĩ, hã kỹ ag tóg isé, Judeu ag,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kỹ Pilatos tóg ti mỹ: “kỹ ã mỹ hã ra tỹ pã'i mág nĩ'?” he mũ. Kỹ Jesus tóg: “ki hã ã tóg tó mũ,” he mũ. “Isỹ ki hã tó jé, hã jé sóg ga kri mur ja nĩ, hã jé sóg ga kri tĩ mũ gé. Kỹ ũ tỹ ki hã tó to há nỹtĩ ẽn ag kar vỹ inh vĩ jẽmẽg mũ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kỹ Pilatos tóg ti mỹ: “ne nỹ tỹ ki hã ke nĩ'?” he mũ. “Sỹ ki kanhrãn jãvãnh mẽ tóg tĩ,” he tóg, Pilatos ti. Kỹ tóg re ra tĩg mãn mũ, pã'i ag mré vẽmén jé, kỹ tóg ag mỹ: “ti pi(jé) vẽnh jykre kórég han tĩ',” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","“Páscoa kar ki sóg ãjag mỹ vẽse ũ kavãg tĩ. Kỹ inh hỹn ãjag mỹ ãjag tỹ ũ to: “Judeu ag pã'i,” he mũ ẽn kyvãn ke mũ,” he tóg, Pilatos ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Hã ra ag kar tóg prẽnprẽr mũ sir. “!..Jesus pijé'..! Barrabás kava ra..!” he ag tóg mũ sir, prẽnprẽr kỹ. Hã ra Barrabás ẽn vỹ tỹ ũn jykre kórég pẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kỹ Pilatos tóg soldado ag mỹ: “ti mrãnmrãn ra, ge kỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kỹ ag tóg ti mrãnmrãn mũ. Ti mrãnmrãn kar kỹ ag tóg sónh pĩrĩn kỹ ti krĩ tógfĩg mũ sir. Kỹ ag tóg kur kusũg tỹ ti kri fón mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ti ki junjun kỹ ag tóg ti mỹ: “viva, Judeu ag pã'i',” he mũ, ti nyg kỹ. Kar ag tóg ti tãnh mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kỹ Pilatos tóg re ra kutẽ mãn mũ gé sir. Kỹ tóg vẽnh kar mỹ: “ha vé ha,” he mũ. “Ti jykre kórég mẽ ja tũ sóg nĩ vẽ. Kỹ sóg ãjag mỹ ti ven mũ. Nén ũ vẽnhmỹ han tũ ti nĩ vẽ,” he tóg, Pilatos ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Kỹ Jesus tóg kãkutẽ mũ, hã ra tóg sónh tỹ ã krĩ tógfĩn kỹ kãkutẽ mũ, kur kusũg ẽn tu kỹ ke gé. Kỹ Pilatos tóg vẽnh kar mỹ: “ti ve ra,” he mũ, ag tỹ hẽn ri ke mũn ti tovãnh jé, ag tỹ ti jagtar ẽn ve kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pã'i ag tỹ ti ve kỹ, polícia ag tỹ ti ve kỹ ag tóg prẽnprẽr mũ gé sir. “!..Ka to ti sã..! !..Ka to ti sã..!” he ag tóg mũ sir, prẽnprẽr kỹ. Kỹ Pilatos tóg ag mỹ: “kỹ ãjag hỹn inhhã ka to ti sa sór mũ',” he mũ. “Ti pi(jé) nén ũ kórég han mũ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kỹ ag tóg ti mỹ: “hã ra tóg: “tỹ inh Topẽ kósin nĩ,” he tĩ ẽg mỹ,” he mũ. “Ẽg tỹ ũ tỹ ge tén ke vẽ. Hã tó ja ti nĩ, ẽg mỹ, Topẽ ti, hã kỹ tóg rán kỹ nĩ,” he ag tóg mũ sir, Pilatos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kỹ Pilatos tỹ ti tỹ tỹ Topẽ kósin nĩ mẽ kỹ tóg ti mỹ e tãvĩ tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kỹ tóg ã ĩn kãra rã mãn kỹ Jesus mỹ: “tỹ ã hẽ tá ke nĩ?” he mũ. Hã ra Jesus tóg ti mré vẽmén mãn sór tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kỹ Pilatos tóg ti mỹ: “ã mỹ inh mré vẽmén ke tũ?” he mũ. “Isỹ ã kavãn sór nĩ kỹ sóg ã kyvãg mũ. Isỹ ka to ã sa sór kỹ sóg to ã sãg mũ gé. Tag to jykrén,” he tóg, Pilatos ti, Jesus mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Hã ra Jesus tóg ti mỹ: “Topẽ tỹ ã tỹ pã'i han tũ nĩ ra ã tóg tag han ki kagtĩg nĩnh mũ vẽ,” he mũ. “Hã kỹ ũ tỹ ã mỹ inh fẽg mũ ẽn vỹ ã tỹ Topẽ vĩ mranh mũ tag kãfór nĩ ha,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kỹ tóg Pilatos mỹ e pẽ tãvĩ tĩ, kỹ tóg ti kavãn sór mũ sir. Hã ra Judeu ag tóg ti mỹ: “ã tỹ tag kyvãn kỹ ã pi(jé) tỹ ẽg kar kri pã'i mág pẽ tỹ Imperador ẽn mré ke nĩ',” he mũ. “Ũ tỹ vẽsỹ pã'i mág han mũ ẽn vỹ Imperador kato tẽ mũ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kỹ Pilatos tóg ag vĩ tag mẽ kỹ mũmẽg mũ, kỹ tóg Jesus jé prẽr mũ, ti tỹ ti mré re tá jẽnh kutẽ jé. Kỹ tóg ã nĩgja ẽn kri nĩ nĩ, ã tỹ hẽ tá vẽnh kar jykre vég tĩ ẽn ki. Tá ag tóg pó nẽ ja nĩgtĩ, hã kỹ ag tóg to: “Pó Nẽ,” he tĩ, hã vỹ: “Gabatá,” he mũ, Hebreu vĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Meio dia ki ke vẽ. Tỹ vaj kỹ ag tóg festa tỹ Páscoa ẽn han sór mũ, hã kỹ ag tóg ũri vẽjẽn tỹ hẽn ri ke kãn mũ. Ẽn kã meio dia ki Pilatos tóg ã nĩgja kri nĩ nĩ, ag mỹ ag tỹ vẽnh jykre han ke mũ ẽn tó jé. Kỹ tóg Judeu ag mỹ: “ãjag pã'i mág hã vẽ ha,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Hã ra ag tóg prẽnprẽr kỹ: “!..ti tén ra, ti tén ra, ka to ti sã..!” he mũ sir. “Kỹ inh mỹ ãjag pã'i mág tỹ cruz to sanh mũ'?” he tóg, Pilatos ti. Kỹ pã'i ag tóg ti mỹ: “pã'i mág ẽg nỹtĩ, hã vỹ: Imperador, he mũ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kỹ Pilatos tóg ag mỹ: “ha cruz to ti sanh mũjẽg gé,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kỹ ag tóg Jesus mỹ cruz fig mũ, ti tỹ vyn kỹ pãnónh tỹ Calvário ra tĩg jé, ag tỹ Hebreu vĩ ki to: Gólgota, he mũ ẽn ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tá ag tóg cruz to ti sãg mũ sir. Ti mré ag tóg ũn régre ag tỹ cruz to ag sãg mũ gé, kỹ ũ vỹ ti pẽgja tá cruz to sa, jãvo ũ vỹ ti jakãnh tá cruz to sa gé. Jãvo Jesus vỹ ag kuju kã cruz ti to sa gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Hã ra Pilatos tóg Jesus to vẽnh rá han ja nĩ, kỹ ag tóg ti krĩg mỹ vẽnhrá ẽn sa ja nĩ, hã vỹ: “Nazaré tá Jesus vẽ, Judeu ag pã'i tỹ rei vẽ,” he mũ, vẽnh rán ki. Hebreu vĩ ki tóg rán kỹ nĩ, Latim vĩ ki ke gé, Grego vĩ ki ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kỹ Judeu tỹ hẽn ri ke ag tóg vég mũ sir, vẽnh rá ti. Jerusalém vỹ tá kakó nĩ, Jesus tỹ hẽ tá cruz to sa kỹ jẽ ẽn ti tá, hã kỹ ũ tỹ hẽn ri ke ag tóg ti venh kãmũjẽg sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kỹ tóg pã'i ag mỹ há tũ nĩ. Hã kỹ ag tóg Pilatos mỹ: “Judeu ag pã'i tỹ rei vẽ, he ja ã nĩ, vẽnh rán ki,” he mũ. “Hã ra tóg ki krov ja tũ nĩ. Vẽso tóg: “tỹ sóg Judeu ag pã'i tỹ rei nĩ,” he ja nĩ. Kỹ: Judeu ag pã'i mág vỹ tỹ inh nĩ, he rán nĩ,” he ag tóg, Pilatos mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Hã ra Pilatos tóg ag mỹ: “vó,” he mũ. “Rán inh huri, kỹ tóg rán kỹ nĩ ha,” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kỹ soldado ag tóg Jesus tỹ ka to sãg mũ. Kỹ ag tóg ti kur mãn kỹ vẽnh kãpãm mũ. Ũ tỹ 4 (ke) ag vẽ, soldado ag, hã kỹ ag tóg ti kur tỹ vẽnh kãpãm tỹ 4 (ke) han mũ. Hã ra ti vẽnh kri fẽg ja vỹ kur pir tỹ há nĩ. Kurỹr tũ ti nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kỹ ag tóg ti capa há ve kỹ jagnẽ mỹ: “ẽg hỹn tag kym ke tũ nĩ,” he mũ. “Ti capa to jogar he jé ẽg tóg ke mũ. Ũ tỹ mãg mũ ẽn hã vỹ tóg tunh mũ,” he ag tóg mũ. Kỹ ag tóg to jogar he mũ sir. Hã ra ag tỹ ti kur to jogar he mũ ẽn tóg rán kỹ nĩ gé, Topẽ vĩ rá ki, ha mẽ. “Inh kur tỹ vẽnh kãpãm ag tóg, hã ra ag tóg inh kur tỹ vẽnh kri fẽg ja to jogar he mũ,” he ja tóg nĩ, Topẽ vĩ rá ki, hã kỹ ag tóg ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hã ra Jesus mỹnh fi vỹ tá jẽ nĩ, cruz rã hã, fi jãvy fi mré. Kar kỹ Maria Madalena fi vỹ tá jẽ nĩ gé, kar kỹ Maria ũ fi ke gé, Clopas prũ fi. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kỹ Jesus tóg ã mỹnh fi vég mũ sir. Ti mré tĩ mũ ũ vỹ fi to grẽn ke kỹ jẽ nĩ, Jesus tỹ ũ to há pẽ ẽn ti. Kỹ Jesus tóg ã mỹnh fi mỹ: “tag vỹ tỹ ã kósin nĩnh mũ ha,” he mũ, ã mré tĩ mũ ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jãvo tóg ti mỹ: “fi hã vỹ tỹ ã mỹnh nĩnh mũ ha,” he mũ gé, fi to. Hã kỹ ti mré tĩ mũ ẽn tóg fi mỹ: “inh mré nĩnh kãtĩg,” he mũ, kỹ fi tóg ti ĩn krẽm nĩ nĩ, ti tỹ Jesus jẽgja ki fi jẽ'ỹn jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus tỹ ã mỹnh fi mỹ tag tó kar kỹ tóg sir ã tỹ nén hyn han ke mũ ẽn hyn han kãn ja nĩ. Hã to jykrén kỹ tóg hã ra nén tỹ ã to rán kỹ nĩ ẽn hyn han kãn sór mũ, hã kỹ tóg: “inh og há tóg tĩ,” he mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tá runja ũ vỹ nĩ nĩ, hã ra vinho kaja pir vỹ ki nĩ, runja ẽn ki. Kỹ ag tóg esponja tỹ vinho ki tỹ pun ke mũ, kỹ ag tóg ka tỹ hissopo jurỹn kỹ (ag tóg) nén kugpe jafã ẽn kusón mũ, kusón kỹ ag tóg vinho kãra rãg kỹ ti mỹ jun mũ sir, vinho ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kỹ tóg ki ũnh ũnh ge mũ sir, vinho ẽn ki. Kỹ tóg: “ke kãn inh huri,” he mũ. Kỹ ti krĩ tóg héré' he mũ, kỹ tóg hun ke mũ. Kỹ tóg hur ter. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kỹ Judeu ag tóg Pilatos mỹ to vĩ mũ, soldado ag tỹ ũ tỹ ka to sa kỹ nỹtĩ ag fa mrynhmranh jé, ag tỹ kãnhmar kãgter jé. Tỹ vaj kỹ ag mỹ festa mág vẽ, kỹ ag tóg ũri festa ẽn to nén kar kãnkãn tĩ gé. Hã ra tóg ag mỹ kórég nĩ, ũ tỹ ag festa kurã ki cruz to sa kỹ ter mũ ti. Hã kỹ ag tóg Pilatos mỹ ag kãgtén ke to vĩ mũ, ag tỹ ka to ag kãrem jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kỹ soldado ag tóg ũ tỹ Jesus mré cruz to vin kỹ nỹtĩ ag fa mrynhmranh mũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kỹ ag tóg Jesus fa mrynhmranh sór mũ gé, hã ra tóg hur ter, hã kỹ ag tóg mrynhmranh tũ nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kỹ soldado ũ tóg ã rógro tỹ ti jẽn'yr ki kusón mũ, kỹ ti kyvénh tóg ki kãkutẽ mũ, kyvénh jãpri mré. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tag ve inh, mỹr, ha mẽ, hã kỹ sóg ãjag mỹ tó mũ. Sỹ ki hã tó vẽ. Sỹ ãjag mỹ tag kãmén vẽ, ãjag tỹ inh vĩ tag kri fi jé, ãjag tỹ ti ki ge sór jé. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hã ra tóg rán kỹ nĩ gé, ag tỹ ti kusón ke tag ti. “Ag pi(jé) ti kuka mrynhmranh ke mũ',” he tóg, Topẽ vĩ tỹ rán kỹ nĩ ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kỹ tag tóg rán kỹ nĩ gé, hã mẽ. “Ag tỹ ũn kusón mũ ẽn ve jé ag tóg ke mũ,” he tóg mũ gé, Topẽ vĩ ki, Jesus to. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kỹ Jesus to há ũ tóg nĩgtĩ, Arimatéia tá José. Ẽn vỹ ti mré tĩg ja tũ nĩgtĩ, ti tỹ pã'i ag kamẽg kỹ, hã ra tóg Jesus to há nĩ. Ẽn vỹ tóg sir Pilatos venh tĩ mũ, kỹ tóg ti mỹ: “sỹ Jesus tỹ ka to ti kãtérem há tóg tĩ,” he mũ. Kỹ Pilatos tóg ti mỹ: “há ti nĩ,” he mũ. Kỹ Arimatéia tá José ẽn tóg Jesus tỹ cruz to ti kãtérem tĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kỹ Nicodemos vỹ kãtĩ mũ gé, ũ tỹ kuty tá Jesus mré vẽmén mũ ẽn ti. Ẽn vỹ ger há ma kãtĩ mũ, 45 (ke) quilos vẽ mỹr. Ka tỹ mirra jẽnjo ger há vẽ, kar ka tỹ aloés jẽnjo ger há mré. Ẽn ma kãtĩg tóg mũ, Nicodemos ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kỹ ag tóg Jesus ti kãtérem mũ sir, cruz to, José mré Nicodemos ti. Ti pãg ag tóg mũ sir, kur tỹ, hã ra ag tóg nén ger há ẽn tỹ ti pãg ke ẽn kãkã nĩm mũ gé. Judeu ag jykre hã vẽ, ag tỹ vẽnh kej tá ũ fi kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ka kré ũ vỹ Gólgota tá kakó nĩ, kỹ tóg tá vẽnh kej tãg nĩ, pãró nor ti, ka kré ẽn tá. Kuprã ti nỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ẽn kãkã ag tóg ti fig mũ, ti kakó nĩn kỹ. Hã ra tóg rãké nỹ ha, kỹ ag festa tóg kakó' he mũ ha, hã kỹ ag tóg vẽnh kej tãg ẽn kãkã Jesus fig mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tỹ vaj ũn kỹ, semana ki kurã ve ki Maria Madalena fi tóg Jesus venh tĩg sór mũ, ti kej tá. Kusã pẽ ki fi tóg ra tĩ mũ, kurã sĩ hã ra. Hã ra fi tóg tá jun kỹ (fi tóg) pó ẽn vég mũ, ti kej nĩfe ẽn ti. Kunũnh kỹ tóg jẽ nĩ, kỹ tóg sir nor kỹ nỹ nĩ, ti kej ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kỹ fi tóg Simão Pedro to vẽnhvãg tĩ mũ sir, Jesus mré tĩ tĩ ũ to ke gé, ũ tỹ Jesus to há tãvĩ ẽn to. Kỹ fi tóg ag mỹ: “ẽg Senhor va ag tóg mũ ja nĩ,” he mũ. “Ã kej kãki tóg tũ nĩ,” he fi tóg mũ. “Ag hỹn hẽ ra ti va kagáv,” he fi tóg mũ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kỹ ag tóg venh mũ mũ gé, Pedro ti, Jesus mré tĩ tĩ ũ ẽn ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pétẽ ag tóg mũ mũ, hã ra ũ ẽn tóg Pedro kã raran ke mũ, kỹ tóg tá jun vén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kỹ tóg pãró nor ẽn ki pãnh ke kỹ kãtá kur ẽn vég mũ, ti pãg ja ti, hã ra tóg kãra rã ja tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kỹ Simão Pedro tóg ti nón tá jun mũ gé, hã ra tóg inhhã kãra rã mũ, ti kej kãra, Pedro ti. Kỹ tóg kur ẽn vég mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ti krĩ pãg ja vỹ vyr mỹ nĩ nĩ, kónhpẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kỹ ũ ẽn tóg ti nón kãra rã mũ gé sir, kỹ tóg ã tỹ ven kỹ: “hã ja vẽ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Vãhã ag tóg ki kanhró nỹtĩ. Tag to hã ag tóg ti vĩ to jykrén há han ja tũ nĩ ver, ti to nén rán kỹ nĩ ẽn to, ti tỹ ã ter kar kỹ rĩr mãn ke ẽn to. Vãhã ag tóg ki kanhró nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ag tỹ ti kej tỹ kuprã nỹ ve kar kỹ ag tóg vỹnvỹn ke mũ, ãjag ĩn ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Hã ra Maria Madalena fi tóg tá jẽ nĩ, ti kej nor nĩ ẽn tá. Fỹ fi tóg jẽ nĩ. Fi fỹ kỹ fi tóg ti kej to pãnh ke kỹ (fi tóg) kãtá ẽvãnh mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kỹ fi tóg ũn régre ag vigvég mũ. Topẽ tỹ jẽgnẽ jafã ag vẽ. Kur kupri rĩnh kỹ ag nĩgnĩg kỹ nỹtĩ, Jesus nỹgja tá, ti kej kãtá. Ũ tóg ti krĩ nĩgja tá nĩ, kỹ ũ tóg ti pẽn nỹtĩgja tá nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Kỹ ag tóg fi mỹ: “ã tỹ ũ jãvãnh kỹ fỹ nẽ, jỹ?” he mũ. Kỹ fi tóg ag mỹ: “inh Senhor va ag tóg mũ ja nĩ, hã ra sóg ag tỹ hẽ ra ti va mũ ja ẽn ki kagtĩg nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kỹ fi tóg vẽsykã ẽvãnh mũ, hã ra Jesus tóg tá jẽ nĩ. Hã ra fi tóg ti ki kagtĩg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kỹ tóg fi mỹ: “ã tỹ ũ jãvãnh kỹ fỹ nẽ, jỹ?” he mũ gé. Hã ra fi tóg ti to: “ti hỹn tỹ ka kré tag ki rĩr tĩ jẽ, he sóg mũ,” he mũ. Hã kỹ fi tóg ti mỹ: “ã mỹ ag tỹ hẽn ra ti va mũ vég tũ, vỹ?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kỹ Jesus tóg fi mỹ: “Maria',” he mũ, fi jiji tó kỹ. Kỹ fi tóg ti tỹ fi mỹ fi jyjy tó kỹ (fi tóg) vãhã ti ki kanhrãn mũ sir. Kỹ fi tóg ti mỹ: “Raboni', ã hã mỹ'?” he mũ. Hebreu vĩ ki fi tóg tó mũ, hã kỹ fi tóg: “Raboni',” he mũ. Ẽg vĩ ki ẽg tóg tag to: “Senhor,” he tĩ. Fi tỹ vãhã Jesus ki kanhrãn kỹ nĩn kỹ fi tóg ti mỹ ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Hã ra Jesus tóg fi mỹ: “inh vóg tũg nĩ ver,” he mũ. “Isỹ ver inh panh ra tãprynh ke vẽ. Inh kanhkã ag mỹ tónh tĩg nĩ hã ra. Ag mỹ: “isỹ ver inh panh venh tĩg ke vẽ, hã ra tóg tỹ ãjag panh nĩ gé, he tóg,” hemnĩ. “Isỹ ver inh Topẽ to tãprynh ke vẽ, kỹ tóg tỹ ãjag Topẽ nĩ gé, he ti,” hemnĩ ag mỹ,” he tóg Jesus ti, Maria Madalena fi mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kỹ fi tóg tĩ mũ, ti mré mũgtĩ ag mỹ tó jé. “Ẽg Senhor ve inh,” he fi tóg mũ. Kỹ fi tóg ag mỹ tó kãn mũ sir, ti tỹ fi mỹ nén tó mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kurã ẽn kã, semana tỹ kurã ve ẽn tỹ rãkãnh kỹ ag tóg vẽnhmãn kỹ nỹtĩ, ĩn ũ krẽm, ti mré mũ tĩ ag. Hã ra ag tóg jãnkã nĩfénh ja nĩ, chave tỹ, ag tỹ ẽprã pã'i ag kamẽg kỹ. Hã ra Jesus tóg vãhã vẽnh ven mũ, ag kãki, kỹ tóg ag mỹ: “mỹ sér nỹtĩmnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tag tó kỹ tóg ag mỹ ã nĩgé nug ven mũ, ã jẽn'yr ti ke gé. Kỹ tóg ag mỹ sér tĩ sir, ag tỹ ẽg Senhor ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kỹ tóg ag mỹ ke mãn mũ. “Mỹ sér nỹtĩmnĩ,” he tóg. “Inh panh tỹ inh jẽnẽ vẽ. Kỹ sóg ũri ãjag jẽnẽg mũ gé, ti tỹ inh jẽnẽ ri ke,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tag tó kar tóg ag ki hu he mũ, ag kar ki, kỹ tóg ag mỹ: “Topẽ kuprĩg vỹ tỹ ãjag jagrẽ nỹtĩ ha,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“Ãjag tỹ ũ mỹ: “ã tỹ Topẽ vĩ mranh ja ẽn tỹ tóg vẽnh pãte fón mũ,” hen kỹ tóg vẽnh pãte fón kỹ nĩ nĩ. Ãjag tỹ ũ mỹ: “ã mỹ ti vẽnh pãte fón ke tũ nĩ,” hen kỹ tóg vẽnh pãte fón ke tũ nĩ,” he tóg, Jesus ti, ti tỹ ag mỹ vẽnh ven vén kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Hã ra Tomé vỹ ag mré nĩ ja tũ nĩ, ag tỹ Jesus vég mũ ẽn kã. Tomé ẽn vẽ, ag tỹ ũ to: “ũn vẽgni,” he mũ ẽn vẽ, Jesus mré tĩ tĩ ũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ag tỹ Tomé ẽn ve kỹ ag tóg ti mỹ: “ẽg Senhor ve ẽg,” he mũ. Hã ra tóg ag mỹ: “ti nĩgé nug ve sór inh mũ,” he mũ, “isỹ ag tỹ prego tỹ ti nĩgé nugnón ja ẽn mẽ jé, inh nĩgé tỹ,” he tóg mũ. “Kỹ sóg ti jẽn'yr ki mẽnh ke mũ gé, sỹ ki ti kusón ja ẽn mẽ jé. Ke tũ nĩ (mũ) ra isóg kri nĩm ke tũ pẽ nĩ, ti rĩr mãn kri,” he tóg, Tomé ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kurã tỹ 8 (ke) tũg kỹ ag tóg vẽnh mãn kỹ nỹtĩ gé, kỹ Tomé vỹ ag mré nĩ gé. Ĩn jãnkã vỹ ki chaven kỹ nỹtĩ. Kỹ Jesus tóg ag mỹ vẽnh ven mãn mũ, ag mré jẽn kỹ. Kỹ tóg ag mỹ: “mỹ sér nỹtĩmnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kỹ tóg vẽsỹmér Tomé mỹ: “ã nĩgé tỹ inh nĩgé nugnor mẽ,” he mũ. “Ã nĩgé tỹ inh jẽn'yr kusón ja ẽn ti mẽ gé. Kri nĩmnĩ, to: “vẽnh ó vẽ,” he mãn tũg nĩ,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kỹ Tomé tóg ti mỹ: “inh Senhor,” he mũ. “Topẽ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kỹ Jesus tóg ti mỹ: “vãhã ã tóg kri nĩm sór mũ ha, ã tỹ inh ve kỹ,” he mũ. “Ũ tỹ ã tỹ inh vég tũ ra kri nĩm mũ ẽn mỹ tóg vĩ há pẽ han ke mũ, Topẽ ti,” he tóg, Jesus ti, ti tỹ ag mỹ vẽnh ven mãn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus vỹ ag rĩnve ẽg tỹ nén han vãnh hyn han kãn ja nĩgtĩ, nén tỹ hẽn ri ke, hã ra sóg rán kãn ja tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sỹ livro tag rán vẽ, ũ tỹ vẽnh rá tag vég mũ kar ẽn ag tỹ Jesus ki ge sór jé, ag tỹ ti to: “Cristo vỹ tỹ ti nĩ, Topẽ kósin vỹ tỹ ti nĩ,” he jé. Kỹ ãjag tỹ ti ki ge kỹ ãjag tóg rĩr krỹg ja tũ ẽn venh ke mũ, ti tugrĩn, mỹr, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tag pãte Jesus tóg kejẽn goj tỹ Tiberíades tá ag mỹ vẽnh ven mãn mũ, kỹ tóg ge tĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simão Pedro vỹ tá nĩ, Tomé ti ke gé, ag tỹ ũ to: “ũn vẽgni,” he mũ ẽn ti, kar kỹ Natanael ti ke gé, ẽmã tỹ Caná tá ke ẽn, ga tỹ Galiléia tá ke ẽn, kar kỹ Zebedeu krẽ ag vỹ tá nỹtĩ gé, ũ tỹ Jesus mré mũ tĩ régre ũ ag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kỹ Simão Pedro vỹ ag mỹ: isỹ pirã kugmĩnh tĩg vẽ,” he mũ. Kỹ ag tóg ti mỹ: “ã mré ẽg mũnh mũ,” he mũ gé. Kỹ ag tóg barco ki ge mũ, goj kri mũ jé. Hã ra ag tóg nén ũ kãgmĩg tũ pẽ nĩ, kuty ẽn kã. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tỹ vaj kỹ kusã pẽ ki, rã tỹ jun ke mũ ra Jesus vỹ ga fyr tá jẽ nĩ, hã ra ag tóg ti ki kagtĩg nỹtĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kỹ tóg ag mỹ: “ãjag mỹ pirã ũ kãgmĩg tũ?” he mũ. Kỹ ag tóg ti mỹ: “hỹ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kỹ tóg ag mỹ: “rede tỹ barco pẽgja tá fón,” he mũ, “kỹ ãjag tóg kugmĩnh ke mũ, pirã ti,” he tóg mũ. Kỹ ag tóg ke mũ. Kỹ tóg fór mũ, rede ti, kỹ ag tóg kãtãnfyn kórég nỹtĩ, ti kufy tĩn kỹ, pirã e nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kỹ ũ tóg Pedro mỹ: “ẽg Senhor hã vẽ,” he mũ. Jesus tỹ ũ to há pẽ ẽn vỹ Pedro mỹ ke mũ. Kỹ Pedro tóg ti vĩ tag to ã kur rĩnh mãn mũ. Kunũnh ja ti nĩ, ti kur ti. Ã kur rĩnh kỹ tóg barco ki kãkutẽ kỹ (tóg) goj kãmĩ tĩ mũ sir, ti tỹ Jesus kukãm tĩg jé, goj kãmĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Hã ra ag tóg ti nón barco kãmĩ mũ mũ gé, rede ẽn raran ag tóg mũ mũ. Kakó ti nĩ ha, goj fyr ti, 100 (ke) metros hỹn. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ag tỹ vagvag ke pa kỹ ag tóg Jesus jãká vég mũ sir. Pirã kugjin tóg nĩ nĩ, kỹ ẽmĩ tóg tá ti rã nĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kỹ Jesus tóg ag mỹ: “ãjag pirã gé kãmũjẽg,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Kỹ Simão Pedro tóg barco kãra rã kỹ rede ẽn raran mũ. Goj fyr kukãm tóg ma tĩ mũ, kỹ tóg vag ke mũ sir, tar tá. Hã ra tóg fór nĩ, rede ti, pirã tỹ, 150 (ke) hỹn, pirã mág tãvĩ. Hã ra rede tóg jar ja tũ nĩ, ti e tãvĩ nỹtĩ ra. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kỹ Jesus tóg ag mỹ: “konh kãmũjẽg,” he mũ. Hã ra ag tóg ti mỹ: “tỹ ã ũ nĩ?” he jãvãnh nỹtĩgtĩ. Ti ki kanhró ag tóg nỹtĩ, ti tỹ tỹ ẽg Senhor nĩn ki. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kỹ Jesus tóg ag mỹ ẽmĩ ẽn kã vẽnh ken mũ sir, pirã ti ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus tỹ ag mỹ vẽnh ven tãgtũ vẽ ha, ẽn kã, ti ter kar kỹ rĩr mãn kar kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ag jẽn kar kỹ Jesus tóg Simão Pedro mỹ: “Simão',” he mũ. “João kósin',” he tóg. “Ã mỹ iso há tãvĩ nĩ, ã mré ke ag tỹ iso há nỹtĩ ẽn kãfór?” he tóg, Jesus ti, Pedro mỹ. Kỹ tóg ti mỹ: “hỹ, hã vẽ,” he mũ. “Ki kanhró ã tóg nĩ, isỹ ã to há pẽ nĩn ki,” he tóg, Pedro ti, Jesus mỹ. Kỹ Jesus tóg ti mỹ: “kỹ ũ tỹ inh ki ge kỹ nỹtĩ ag mỹ inh vĩ tómnĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Kỹ tóg ti mỹ vĩ mãn mũ, Jesus ti, Pedro mỹ. “Simão',” he mãn tóg. “João kósin',” he tóg. “Ã mỹ iso há nĩ?” he tóg. Kỹ tóg ti mỹ: “hỹ, hã vẽ,” he mãn mũ. “Ki kanhró ã tóg nĩ, isỹ ã to há nĩn ki,” he mãn tóg. Kỹ Jesus tóg ti mỹ: “kỹ ũ tỹ inh ki ge kỹ nỹtĩ ag mỹ inh vĩ tómnĩ,” he mãn mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kỹ Jesus tóg ti mỹ vĩ mãn mũ gé, vĩ tãgtũ han kỹ. “Simão',” he tóg. “João kósin',” he tóg. “Ã mỹ iso há nĩ?” he tóg. Kỹ tóg Pedro mỹ e tĩ, ti tỹ ti mỹ ke tãgtũ han kỹ. Ti ki jẽmẽ tãgtũ han tóg, hã kỹ tóg ti mỹ e tĩ. Kỹ tóg ti mỹ: “nén kar ki kanhró ã tóg nĩ,” he mũ. “Ki kanhró ã tóg nĩ, isỹ ã to há nĩn ki,” he tóg, Jesus mỹ, Pedro ti. Kỹ Jesus tóg ti mỹ: “kỹ ũ tỹ inh ki ge kỹ nỹtĩ ag mỹ inh vĩ tómnĩ,” he mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Ã mỹ sóg ki hã tó mũ, ha mẽ,” he tóg mũ. “Ã kyrũ kã ã tóg ã kur rĩnh kỹ ã tỹ hẽn ra tĩg sór mũ ẽn ra tĩg ja nĩgtĩ. Kejẽn ã kófa nĩnh ke vẽ. Ẽn kã ã tóg ag mỹ ã nĩgé tỹ vẽnh kri tỹ tam kenh mũ, kỹ ag tóg ã senh mũ, ha vemnĩ, kỹ ag tóg ã pére mũnh mũ, ã tỹ hẽ ra tĩg sór tũ ẽn ra,” he tóg, Jesus ti, Pedro mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ti tỹ ti mỹ ag tỹ ti tén ke tó vẽ. Hã ra ag tóg Topẽ tỹ tỹ ũn mág nĩ venh ke mũ, ag tỹ Pedro tén ke tugrĩn. Tag tó ti, Jesus ti, Pedro mỹ. Tag pãte tóg ti mỹ: “mũ jé ha, inh mré,” he mũ gé sir, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ag mũn kỹ Pedro tóg vẽsỹjãm ẽvãnh kỹ (tóg) ũ tỹ Jesus nón kãtĩg mũ ẽn vég mũ gé, Jesus tỹ ũ to há tãvĩ ẽn. Ag jẽn rén ja ẽn tá tóg Jesus rã hã nĩ ja nĩ, ti mré tóg jagnẽ to grẽn ke kỹ nĩ ja nĩ, Jesus tỹ ũ to há tãvĩ ẽn. Ẽn kã tóg Jesus ti mỹ: “ũ nỹ hỹn ã ven ke mũ, pã'i ag mỹ?” he ja nĩ. Ẽn hã vỹ Jesus nón tĩg mũ, Pedro tỹ ti mré tĩg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro tỹ ti tỹ ag nón kãtĩ mũ ve kỹ tóg Jesus mỹ: “jãvo ũ tỹ ẽg nón kãtĩg mũ tag ti?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kỹ Jesus tóg ti mỹ: “sỹ ti mỹ nén tó mũ vỹ vyr mỹ nĩ,” he mũ. “Kỹ sỹ ã mỹ nén tó mũ vỹ vyr mỹ nĩ gé,” he tóg mũ. “Sỹ ti mỹ: “ter ke tũ ã tóg nĩ, isỹ vỹn ke ve jé ã tóg ke mũ,” he sór mũ ra sóg ti mỹ tónh ke mũ vẽ,” he tóg. “Ã hã mỹ sóg ã tũ tónh ke mũ, hã kỹ sóg ã mỹ: mũ jé ha, inh mré, he mũ,” he tóg, Jesus ti, Pedro mỹ. Ti tỹ ũ tỹ ag mré kãtĩ mũ ẽn to ken hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesus vĩ tag tugrĩn vẽnh kar tóg ti to: “ter ke tũ ti nĩ,” he tĩ, Jesus ki ge kỹ nỹtĩ kar ag. Hã ra Jesus pi(jé) ti to: “ter ke tũ ti nĩ,” he ja nĩgtĩ'. Ti to tóg: “sỹ ti mỹ: ter ke tũ ã tóg nĩ, isỹ vỹn ke ve jé ã tóg ke mũ, he sór mũ ra sóg ti mỹ tag tónh ke mũ vẽ,” he ja nĩ, Pedro mỹ, ũ ẽn to. Hã kỹ ti to: “ter ke tũ ti nĩ,” he tũg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","João vỹ tỹ inh nĩ. Inh hã vỹ tag ve kãn ja nĩ, hã kỹ sóg rán. Ki hã tó sóg tĩ, vẽnh kar vỹ tag ki kanhró nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hã ra sóg Jesus tỹ nén hyn han mũ ẽn rán kãn ja tũ nĩ. Ti tỹ nén hyn han mũ ẽn vỹ e tãvĩ nỹtĩ, e tãvĩ. Ẽg tỹ tag rán kãn sór mũ ra ẽg tóg livro tỹ hẽn ri ke hyn han ke mũ vẽ. Kỹ ẽg hỹn hẽ tá livro kar tag vin han ke mũ'? Sĩ ti nĩ, ẽg ga ti, kỹ ẽg tỹ hẽ tá livro tag vin han ke tóg tũ tĩnh mũ, ẽg tỹ Jesus tỹ nén hyn han ja ẽn rán kãn sór mũ ra. Hã vẽ.");
INSERT INTO kgpNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, inh livro ve ki sóg ã mỹ Jesus tỹ nén han kar tó ja nĩ, ti tỹ nén han vén mũ ẽn ti, ti tỹ nén han rén ẽn ti ke gé. Ti tỹ ẽg kanhrãn mũ ẽn rán sóg huri ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Kỹ sóg ti tỹ kanhkã ra tãpry mũ rán huri ke gé. Ã tỹ kanhkã ra tãpry to hã tóg apóstolo ag mré vẽmén ja nĩ ver, ã tỹ ũn kuprẽg mũ ag mré. Topẽ kuprĩg tỹ ti mỹ nén tó mũ ẽn tó tóg mũ ag mỹ, ag tỹ ki hã han jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ã ter kar kỹ Jesus tóg ag mỹ vẽnh ven tỹ hẽn ri ke han ja nĩ, kurã tỹ 40 (ke) ki. Rĩr mãn kỹ tóg ag mỹ vẽnh ven ja nĩ, ti tỹ ũn kuprẽg ja ẽn ag mỹ. Ag tỹ ti ve kỹ, ag tỹ ti mré vẽmén kỹ ag tóg ti rĩr jẽ ki kanhró nỹtĩ, apóstolo ag. Ag mỹ tóg Topẽ tỹ tỹ ẽg pã'i nĩ kãmén mũ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kejẽn tóg ag mré nĩ nĩ. Kỹ tóg ag mỹ: “ver cidade tỹ Jerusalém tá kãpa tũg nĩ,” he mũ. “Tá nỹtĩ kỹ Topẽ tỹ ãjag mỹ nén tó ja jãvãnh nĩ,” he tóg, “isỹ ãjag mỹ nén tó ja ẽn ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","“João vỹ goj tỹ ẽg kygpe ja nĩgtĩ,” he tóg. “Hã ra kãnhmar ãjag tóg Topẽ kuprĩg tỹ jagrẽ venh ke mũ. Sỹ ãjag kypenh ken hã vẽ,” he tóg, Jesus ti. Kỹ tóg tĩ mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kejẽn ag tóg vẽnh mãn mãn mũ sir, Jesus tỹ ũn vin mũ ag. Kỹ tóg ag mré nĩ nĩ, Jesus ti. Kỹ ag tóg ti mỹ: “Senhor,” he mũ. “Ã mỹ ũ ri ẽg pã'i mág fẽg mãn mũ', ẽg povo tỹ Israel tỹ pã'i mág?” he ag tóg ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hã ra tóg ag mỹ: “vó,” he mũ. “Topẽ hã ki kanhro nĩ,” he tóg. “Ãjag tũ pijé',” he tóg. “Kurã ẽn ki kanhrãn ke tũ ãjag tóg nĩ, Topẽ tỹ ãjag pã'i mág fẽg mãn ke kurã ti. Topẽ hã ne kurã tag tónh ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","“Hã ra Topẽ kuprĩg vỹ tỹ ãjag jagrẽ nĩnh ke mũ. Kỹ ti hã vỹ ãjag tar han ke mũ, ãjag tỹ inh kãmén jé. Cidade tỹ Jerusalém tá ãjag tóg inh kãmén ke mũ, ga tỹ Judéia tá ke gé, ga tỹ Samaria tá ke gé, ga fyn ja tá hã ke gé mỹr,” he tóg, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ã tỹ tag tó kar kỹ tóg vãhã kynh mỹ tãpry mũ sir ag rĩnve, kỹ kanhkã góg vỹ ti kri rũm ke mũ sir, ti ve mãn tũ ag tóg nĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hã ra ag tóg kanhkã tugnỹm mũ, ag tỹ ti tĩg ven kỹ, ti tỹ ũn vin mũ ag. Kỹ vãhã ũn régre ag tóg tá nỹtĩ, kur kupri rĩnh kỹ. Topẽ tỹ jẽnẽ jafã ag vẽ, ũn régre ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kỹ ag tóg ag mỹ: “ha vé, Galiléia tá ke',” he mũ. “Ãjag hã ne tóg kanhkã tá ẽvãnh nỹtĩ nĩ',” he ag tóg. “Jesus vỹ vỹn kenh mũ, ti tĩg ja ẽn ri ke han jé tóg ke mũ. Ti tỹ kanhkã ra tãpry vẽ, hã ra tóg tá kãtére mãn ke mũ gé,” he ag tóg, Topẽ tỹ jẽnẽ jafã ag, Jesus tỹ ũn vin mũ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kỹ Jesus tỹ ũn vin mũ ag tóg vỹnvỹn ke mũ sir, Jerusalém ra, krĩ tỹ Oliveiras tá kãmũ kỹ. Jerusalém kakó kã ti nĩ, 1 quilômetro tá ti nĩ hỹn, krĩ tỹ Oliveiras ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ag tỹ Jerusalém tá junjun kỹ ag tóg ĩn to jãpry jafã to jãpry mũ, tá nỹtĩ jé, ĩn kri. Ũ tỹ tá nỹtĩ ag hã vẽ: Pedro, João, Tiago, André, Filipe, Tomé, Bartolomeu, Mateus, Tiago ũ hã vỹ: Alfeu kósin, he mũ, Simão ke gé, vĩ tar han tĩ tag ti, Judas ke gé, Tiago kósin tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ag kar ẽn tóg Topẽ mré vĩ mũ, jagnẽ mré, ũn tỹtá fag mré hã, Maria fi mré hã, Jesus mỹnh ẽn fi, Jesus jãvy ag mré hã ke gé, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kejẽn Jesus mré ke tỹ hẽn ri ke ag vỹ tá nỹtĩ nĩ, ĩn to jãpry jafã ẽn tá, ũ tỹ 100 kri 20 (ke) hỹn. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Kỹ Pedro vỹ tóg jẽg nẽ mũ, kỹ tóg: “ha vé, inh kanhkã',” he mũ. “Vãsỹ tóg rán kỹ nĩ, Judas to,” he tóg. “Topẽ kuprĩg tóg Davi krĩn ja nĩgtĩ, ti tỹ Judas to rán jé,” he tóg. “Hã ra tóg ki hã tó ja nĩ, vẽnh rán ki,” he tóg. “Ag jãmĩ tóg kãtĩg ja nĩ, Judas ti, ũ tỹ Jesus kãgmĩnh ke mũ ag jãmĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Hã ra tóg tỹ ẽg mré ke ja nĩ, kỹ ti tỹ nén han mũ tóg ẽg tỹ nén han mũ ri ke ja nĩ gé,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Hã ra tóg Jesus kato jãnkamy mãn ja nĩ, kỹ tóg jãnkamy ẽn tỹ ẽpỹ kajãm ja nĩgtĩ. Hã ra tóg ã nunh kã vẽnh jãján ja nĩ, kỹ tóg tam ke kỹ kutẽ ja nĩ, kỹ ti nug tóg jar ja nĩ, kỹ ti nug tóg kãkutẽ ja nĩ, kỹ tóg ter ja nĩ, Judas ti,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","“Kỹ Jerusalém tá ke kar ag tóg mẽg mũ sir, hã kỹ ag tóg ti japỹ to: Aceldama, he mũ, hã vỹ: ẽpỹ kyvénh, he mũ, ẽg vĩ ki,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ẽg tỹ Topẽ mỹ jãn jãn jafã ki tag tóg rán kỹ nĩ, hã mẽ: ẽn jamã vỹ vag ke mũ, ũ pi(jé) ki ẽmãn mãn mũ', he tóg, vẽnh rán ki, Judas to,” he tóg, Pedro ti. “Kỹ ũ vỹ ge nĩ gé, hã mẽ: ũ ũ tỹ ti jẽg ja kã jẽnh ke kỹ ti rãnhrãj han ke vẽ, he tóg mũ gé, vẽnh rán ki,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Hã kỹ ẽg tỹ ẽg mré mũ tĩ ũ jãvãnh ke vẽ. Jesus mré tóg tĩg ja nĩgtĩ, ẽg tỹ ũn jãvãnh ke mũ ti, kỹ tóg Jesus tỹ ga mĩ tĩ ẽn ve ja nĩgtĩ gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","João tỹ Jesus kype ve ja tóg nĩ gé. Jesus tỹ kanhkã ra tãpry ve ja tóg nĩ gé. Jesus tỹ nén han mũ kar ve ja tóg nĩ, ẽg tỹ ũn jãvãnh ke mũ ti. Kỹ tóg sir Jesus rĩr mãn tónh ke mũ ẽg mré,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kỹ ag tóg ũn régre ag vin mũ, hã vỹ: José, he mũ, ti jyjy ũ hã vỹ: Barsabás, he mũ. Fóg tỹ ti jiji hã vỹ: Justo, he mũ. Ti mré ag tóg Matias fẽg mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kỹ ag tóg Topẽ mré vĩ mũ, kỹ ag tóg tag tó mũ, ha mẽ. “Ẽg jóg',” he ag tóg ti mỹ. “Ẽg tỹ nén to jykrén mũ ki kanhró ã tóg nĩ,” he ag tóg mũ. “Ã hỹn ũ tỹ hẽ kuprẽg, ũn régre tag ag kã, ");
INSERT INTO kgpNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ti tỹ ẽg mré ã rãnhrãj tag han jé, ti tỹ tỹ ẽg mré apóstolo jẽ jé? Judas vỹ ã rãnhrãj tovãnh, kỹ tóg ã tỹ ra tĩg ke ẽn ra vyr. Kỹ ũ tỹ hẽ nỹ ti jẽg ja kã jẽnh mũ ha?” he ag tóg mũ, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kỹ ag tóg to jogar he mũ sir, hã ra Matias tóg Judas jẽgja kã jẽ nĩ. Hã kỹ tóg tỹ ũ tỹ 11 (ke) ag mré ke nĩ sir, tỹ tóg apóstolo jẽ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Vãhã tóg festa tỹ Pentecostes kurã tá krỹg mũ. Kỹ vẽnh kar vỹ vẽnh mãn kỹ nỹtĩ nĩ, Jesus ki ge kỹ nỹtĩ kar ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kỹ vãhã kanhkã tá kóho ri ke tóg mẽ há tĩ, króg he mũ ẽn ti. Kỹ ĩn tóg kóho ri ke ẽn tỹ fór mũ. Hã ra ag tóg ĩn ẽn ki nỹtĩ, Jesus ki ge kỹ nỹtĩ ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kỹ ag tóg nén nẽ vég mũ, hã ra tóg tỹ pĩ gru hã pẽ nĩ, nén nẽ ẽn ti. Vẽnh kãpópãm kỹ tóg nĩ nĩ, pĩ gru hã pẽ ẽn ti. Kỹ tóg ag kri nĩ' nĩ' he kãn mũ, pĩ gru hã pẽ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kỹ Topẽ kuprĩg tóg ag ki ge kãn mũ, kỹ ag tóg vẽnh vĩ ũ tugtó mũ, Topẽ kuprĩg tỹ ag krĩn kỹ, ti tỹ tỹ ag jagrẽ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Hã ra Jerusalém tá ke ũ ag tóg Topẽ to há nỹtĩ gé. Israel ag vẽ gé, hã ra ag tóg povo tỹ hẽn ri ke mĩ mogmog ja nĩ. Hã kỹ ag vĩ tóg tó tỹ hẽn ri ke nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ag tỹ kóho ri ke ẽn mẽ kỹ ag tóg vẽnh mãn mũ. Kỹ ag tóg ãjag vĩ e ẽn ki Pedro ag tỹ nén tó mũ mẽg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kỹ tóg ag mỹ e tĩ. Ag fe tỹ hẽn ri ke nĩn kỹ ag tóg: “ha vé, Galiléia tá ke ag vẽ mỹr,” he mũ. “Galiléia tá ke ag vỹ vyr mỹ vĩ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Hã ra ẽg tóg ẽg vĩ pẽ ki ag vĩ jẽmẽg mũ,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","“Ẽg kã ũ ag tóg Pártia tá kãmũ mũ, kỹ ũ ag tóg Média tá kãmũ mũ gé, ũ ag tóg ga tỹ Elão tá kãmũ mũ, ũ ag tóg ga tỹ Mesopotâmia tá kãmũ mũ, ũ ag tóg Judéia tá kãmũ mũ, ũ ag tóg Capadócia tá kãmũ mũ, kar kỹ Ponto tá, Ásia tá, ");
INSERT INTO kgpNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frígia tá, Panfília tá, Egito tá, ga tỹ Líbia tá, cidade tỹ Cirene ẽn mã tá. Ũ ag tóg cidade tỹ Roma tá kãmũ mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ũ ag tóg tỹ Israel nỹtĩ, kar kỹ ũ ag tóg tỹ fóg tỹ Israel jykre han mũ nỹtĩ gé. Ũ ag tóg goj vãso tỹ Creta tá kãmũ mũ, ũ ag tóg ga tỹ Arábia tá kãmũ mũ gé. Ẽg kar tóg ẽg vĩ pẽ ki ag tỹ Topẽ kãmén mũ mẽg mũ, ag tỹ Topẽ tỹ nén han ja kãmén mũ ti, Topẽ tỹ milagre hyn han ja ẽn ti,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ãjag mỹ e tĩn kỹ ag tóg jagnẽ mỹ: “ne nẽ hỹn'?” he mũ. Ag fe tóg jũrũn ke mũ, ag tỹ ge ve ja tũ nỹtĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ũ ag tóg hã ra nyg mũ. “Kronkron kỹ ag kãgter mũ mỹr,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kỹ Pedro tóg ũ tỹ 11 (ke) ag mré jẽgnẽ mũ, kỹ tóg jamã hár(a) ag mỹ: “inh kanhkã',” he mũ. “Jerusalém tá ke',” he tóg. “Jẽmẽ há han ra, sỹ ãjag mỹ nén tó mũ ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Ãjag hã tóg ẽg to: kronkron kỹ ag kãgter mũ, he mũ. Hã tũ vẽ hã ra. 9 horas vẽ ver, meio dia to hãn sa mỹr,” he tóg. “Ag kronkron kỹ ag tóg rãkãnh kỹ kronkron kỹ kãgter mũgtĩ, ũn kronkron mũ ẽn ag,” he tóg. “Hã kỹ ẽg tóg kron ja tũ nĩ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Hã ra tóg vãsỹ rán kỹ nĩ, ẽg tỹ ũri nén vég mũ ti. Topẽ vĩ tó tĩ tỹ Joel tóg vãsỹ tag tó ja nĩ, ha mẽ: ");
INSERT INTO kgpNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“kurã tỹ ẽgno to hã sóg inh kuprĩg jẽnẽnh mũ, vẽnh kar mỹ, ti tỹ tỹ ãjag jagrẽ nĩ jé,” he ja tóg nĩ, Topẽ ti. “Kỹ ãjag krẽ ag tỹ fag mré Topẽ vĩ mẽ kỹ tónh ke vẽ. Kyrũ ag tỹ nén nẽ venh ke vẽ. Kófa ag tỹ vẽnh pétinh ke vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sỹ inh camarada ag mỹ inh kuprĩg jẽnẽnh ke vẽ gé, fag mỹ ke gé. Kỹ fag tóg inh vĩ tónh ke mũ gé,” he tóg, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","“Ãjag tỹ nén han vãnh han jé sóg ke mũ gé, ãjag mỹ, kanhkã tá, ga tá ke gé, ẽprã, kyvénh mỹr, pĩ mỹr, nĩja mỹr. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kỹ rã tỹ kutyg ke vẽ, kysã kyvénh ke vẽ gé. Kar kỹ Topẽ kurã vẽ sir, kurã mág ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kỹ ũ tỹ Topẽ mỹ nén kar to vĩ mũ ẽn kren ke vẽ sir,” he tóg, Topẽ ti. Joel tỹ tón hã vẽ, vãsỹ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Inh kanhkã', inh vĩ jẽmẽ ra,” he tóg. “Nazaré tá Jesus vẽ mỹr,” he tóg. “Ti hã tóg nén han vãnh hyn han ja nĩgtĩ, Topẽ jykre hyn han ja tóg nĩgtĩ, Topẽ tỹ ti jẽnẽn kỹ. Hã ra Topẽ tóg Jesus mỹ tó ja nĩ, ti tỹ milagre ẽn hyn han jé. Kỹ tóg ãjag rĩnve hyn han, ãjag tỹ ve jé, Jesus to jykrén jé. Hã kỹ ãjag tóg vé,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","“Hã ra Topẽ tóg ãjag mỹ ti fẽg sór ja nĩ, Jesus ti. Kỹ tóg to jykrén kỹ ãjag mỹ ti fẽg ja nĩ. Jãvo ãjag tóg ka to ti sa ja nĩ, ti tén ja ãjag tóg nĩ. Kỹ ũ tỹ ka to ti sãg mũ ẽn ag jykre vỹ pãno tãvĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Hã ra Topẽ tóg ti rĩn mãn ja nĩ, hã kỹ tóg vẽser jagẽgtar ẽn tỹ tũ' he ja nĩ ti mỹ. Hã kỹ tóg vẽser jamã tá nĩg mág ja tũ nĩ, Jesus ti,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Hã kỹ Davi tóg Jesus jo tag tó ja nĩ, kỹ tóg Jesus tỹ ã jóg mré vĩ ri ke nĩ. Ti to tóg: “ẽg jóg',” he ja nĩ. “Ã vég isóg nĩ nĩ,” he ja tóg nĩ. “Inh pẽgja tá ã tóg nĩ nĩ, hã kỹ sóg krónh ke tũ nĩ,” he ja tóg nĩ, Davi ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","“Hã kỹ inh fe tóg mrin ke mũ. Vĩ sér han isóg nĩ nĩ. Iser kỹ inh fár tóg nỹnh ke mũ, hã ra sóg to krĩ kufy tũ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Inh kuprĩg vỹ vẽnh kuprĩg jamã tá nĩnh ke tũ nĩ. Inh fár vỹ vag ke tũ nĩ gé, sỹ tỹ ã tỹ kuprẽg ja nĩn kỹ,” he ja tóg nĩ, Davi ti, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","“Inh kanhrãn ã tóg nĩ nĩ, isỹ kanhkã to ẽpry ẽn ve há han jé, kanhkã to ẽmĩn ẽn ti. Isỹ ã mré nĩn kỹ tóg inh mỹ sér tãvĩ tĩ,” he ja tóg nĩ. Davi tỹ Jesus tón hã vẽ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Inh kanhkã',” he tóg. “Ẽg jóg'jóg tỹ Davi kãmén há han jé sóg ke mũ ãjag mỹ,” he tóg. “Vãsỹ ti ter mỹr, kỹ ag tóg vẽnh kej tá ti péju, hã ra ẽg tóg vég tĩ, ti kej ti, Davi kej ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","“Ã tỹ ga mĩ tĩg kỹ tóg hã ra Topẽ vĩ tó tĩ ja nĩgtĩ, Davi ti. Topẽ tóg ti mỹ: “ã krẽ'krẽ ag kã ũ vỹ tỹ pã'i tỹ rei nĩnh mũ,” he ja nĩgtĩ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Topẽ vĩ tag kri fi kỹ tóg Cristo rĩr mãn ke tó ja nĩgtĩ gé, Davi ti. Hã kỹ tóg ã vĩ ẽn tó ja nĩgtĩ. Cristo pi(jé) vẽser jamã tá nĩg mág han', kỹ ti fár vỹ vag ja tũ nĩ gé,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Cristo vẽ, hã vỹ: Jesus, he mũ. Topẽ vỹ ti rĩn mãn, kỹ ẽg kar tóg ti ve ja nĩgtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“Topẽ tóg ti mỹ: “kunĩg, inh pẽgja tá nĩ,” he ja nĩ, Jesus ti mỹ. Kỹ ẽg jóg tóg ti mỹ ã tỹ ẽg mỹ nén tó ja fẽg, hã vỹ: Topẽ kuprĩg, he mũ. Hã kỹ tóg ẽg mỹ tỹ jagrẽ han mũ, Topẽ kuprĩg tỹ, Jesus ti. Hã kỹ ãjag tóg ũri tag vég mũ, tag mẽg mũ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","“Davi hã tóg rĩr mãn ja tũ nĩ ver, kanhkã ra tóg tãpry ja tũ nĩ ver, ge ra tóg tag tó ja nĩ, ha mẽ: “ẽg jóg mág vỹ inh Senhor mỹ tag tó ja nĩ, hã vỹ: “nĩ ra ver, inh pẽgja tá,” he ja tóg nĩ, ");
INSERT INTO kgpNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","“sỹ ã kato vãsãnsãn mũ ag tỹ ã jakrẽm vin jé, ag sigse jé,” he ja tóg nĩ. Davi tỹ tón hã vẽ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Jesus tag hã vỹ, ãjag tỹ ka to ũn sãg mũ tag hã vỹ: tỹ ẽg Senhor nĩ, he mũ,” he tóg. “Topẽ vỹ ti to: “tỹ tóg Cristo nĩ,” he mũ. “Tỹ tóg vẽnh kar Senhor nĩ,” he tóg. Ẽg tỹ vẽnh vĩ tag kri finh ke vẽ. Ẽg povo tỹ Israel tỹ ti ki kanhrãn ke vẽ, ẽg vĩ tag kri nĩm ke vẽ,” he tóg, Pedro ti, ũ tỹ vẽnh mãn kỹ nỹtĩ kar ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ag tỹ ti vĩ jẽmẽ kỹ ti jykre tóg ag kãra rã mũ sir. Kỹ ag tóg ti mỹ: “kỹ ẽg hỹn hẽ ri kenh mũ, vỹ?” he mũ, Jesus tỹ ũn vin mũ kar ag mỹ ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Kỹ Pedro tóg ag mỹ: “ãjag jykre tovãnh ra,” he mũ. “Kỹ ẽg tóg ãjag kygpenh ke mũ, Jesus Cristo jiji tó kỹ,” he tóg. “Kỹ Topẽ tóg ãjag mỹ ãjag tỹ ti vĩ mranh ja ẽn tỹ vẽnh pãte fón ke mũ. Kỹ ãjag tóg Topẽ kuprĩg tỹ jagrẽ nỹtĩnh mũ gé, Topẽ tỹ ãjag mỹ ti jẽnẽn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ti tỹ ãjag hã mỹ ti nĩm ke vẽ inhhã, ãjag krẽ mré hã ke gé. Ti tỹ ũn mỹ vẽnh vĩ jẽnẽg mũ kar ag mỹ tóg nĩm tĩ, Topẽ ti, ẽg jóg mág ti, ag tỹ ver kuvar há tá mũ hã ra,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Vĩ tỹ hẽn ri ke han tóg, Jesus kãmén kỹ. Ag jyvẽn tóg mũ gé, kỹ tóg ag mỹ: “Jesus mỹ: “inh kren han nĩ,” hemnĩ,” he mũ. “Ẽg kar vỹ vẽnh jykre pãno han kãn, ã jykre han vãnh nỹtĩn kỹ. Kỹ inh kren han nĩ, hemnĩ, Jesus mỹ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ũ tỹ ti vĩ han mũ ag kygpég ag tóg mũ sir. Kurã ẽn kã ũn kygpe kỹ nỹtĩ ag vỹ tỹ ũ tỹ 3 mil nỹtĩ hỹn, hẽn ri ke mũn. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ẽn ag vỹ kurã kar ki Jesus tỹ ũn vin mũ ag vĩ jẽmẽ jé vẽnh mãn tĩ, jagnẽ ve jé ke gé. Kỹ ag tóg Jesus jamĩ ko mũ sir. Kỹ ag tóg ti mré vĩ mũ gé, kurã kar ki. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kỹ Jesus tỹ ũn vin mũ ag tóg ẽg tỹ nén han vãnh tỹ hẽn ri ke han tĩ nỹtĩgtĩ. Hã kỹ vẽnh kar tóg Topẽ kamẽg tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jãvo ũ tỹ Jesus ki ge kỹ nỹtĩ ag tóg jagnẽ mré vẽnh jykre pir han mũgtĩ. Kỹ ag kuge vỹ jagnẽ tũ ri ke nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ũ ag tóg ãjag kuge ũ vãvãm mũ gé, jãnkamy kato, kỹ ag tóg ũn jãnkamy tũ ag mỹ vẽnh kãpópãm mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kurã kar ki ag kar tóg Topẽ jo ĩn ra mũ tĩ, ag tỹ ti mré vĩ jé. Ãjag ĩn kãki ag tóg Jesus jamĩ ko mũgtĩ gé. Jatun mỹ ag tóg sir jẽgjẽg mũ. Kỹ tóg ag mỹ sér tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kỹ ag tóg Topẽ mỹ: “há ti nĩ,” he ti gé. Jó vẽnh kar tóg ag to há nỹtĩ gé. Kỹ Topẽ tóg kurã kar ki ũ ag mỹ krĩ há nĩm tĩ gé, kỹ ag tóg ti ki ge mũ, ag krenkren jé. Hã kỹ ag tóg komẽr hã e nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kejẽn Pedro tóg João mré Topẽ jo ĩn ra mũ mũ, meio dia pãte 3 horas ki. Israel ag tỹ Topẽ mré vĩ jafã vẽ, hã vỹ: 3 horas, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Topẽ jo ĩn tá ũ tóg nĩ nĩ, ũn grĩ. Ã mũr mũ kã tóg ge nĩ. Topẽ jo ĩn jãnkã tá tóg nĩ nĩ, jãnkã sĩnvĩ he mũ ẽn tá. Tá tóg: “inh mỹ nén ũ nĩm,” he nĩgtĩ, ũ tỹ Topẽ jo ĩn kãra ge mũ ag mỹ. Ẽn va ag tóg kãmũ mũ, jãnkã tá ti nĩm jé. Kỹ João mré Pedro tóg Topẽ jo ĩn tá junjun mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ũn grĩ tỹ Pedro ag ve kỹ tóg ag mỹ nén ũ to vĩ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Kỹ Pedro ag tóg ti tugnỹm mũ. Kỹ Pedro tóg ti mỹ: “ẽg ki ẽvãnh ra,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kỹ tóg ag ki ẽvãnh mũ. “Ag hỹn inh mỹ jãnkamy nĩm ke mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Hã ra Pedro tóg ti mỹ: “jãnkamy tóg inh mỹ tũ tĩ,” he mũ. “Sỹ nén ma tĩ hã tỹ sóg ã mỹ nĩm mũ, hã vỹ: Jesus Cristo jyjy hã tó kỹ, Nazaré tá ke ẽn jiji tó kỹ sóg ã mỹ: ha jẽg, he mũ, ha mĩ tĩg, he sóg ã mỹ,” he tóg, Pedro ti, ũn grĩ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kỹ tóg ti pẽgja tá ti kãgmĩ kỹ ti fẽg mũ. Kỹ vãhã ti pẽn tóg tar' he mũ sir, ti pẽn nágnán ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hũm hen kỹ tóg jẽ nĩ sir. Jẽg há' he tóg mũ sir. Mĩ tóg tĩ mũ sir. Ag mré tóg Topẽ jo ĩn kãra rã mũ sir. Tá tóg mĩ tĩ kỹ hũm hũm he mũ. Topẽ mỹ tóg vĩ há han mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kỹ vẽnh kar tóg ti vég mũ, ti tỹ mĩ tĩg kỹ, ti tỹ Topẽ mỹ vĩ há han kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ag tỹ ti ve kỹ ag tóg ti ki kanhró nỹtĩ. “Topẽ jo ĩn jãnkã tá nĩ ẽn hã vẽ mỹr,” he ag tóg mũ. “Jãnkã sĩnvĩ he mũ ẽn tá nĩ mũn hã vẽ mỹr,” he ag tóg mũ. “Vẽnh kar mỹ: inh mỹ nĩm, he tĩ ẽn hã vẽ mỹr,” he ag tóg ti to. Kỹ tóg ag mỹ e tĩ sir. Ag fe tóg jũrũn ke mũ sir, ag tỹ ti ven kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Hã ra tóg Pedro mré João mré tĩ mũ, ũn grĩ ja ẽn ti. Hã kỹ vẽnh kar tóg ag to vẽnh mãn mũ, Topẽ jo ĩn krẽm, pã'i tỹ Salomão he mũ ẽn sala tá. Vẽnh kar ag mỹ tóg e tĩ, ũn grĩ ẽn tỹ há' hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ã tỹ ũn e ẽn ag ve kỹ Pedro tóg ag mỹ: “inh kanhkã',” he mũ. “Ãjag fe hã ne tóg jũrũn ke mũ',” he tóg. “Ẽg tỹ vẽsóg ki ti tỹ há' he tũ vẽ. Topẽ tỹ ti tỹ tĩg há' he vẽ mỹr. Ẽg tỹ vẽnh jykre kuryj han mũ ra ẽg tóg ge han ki kagtĩg nỹtĩ vẽ,” he tóg, Pedro ti, ũn e ẽn ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Ẽg jóg'jóg ve ag vỹ Topẽ to há ja nỹtĩgtĩ, Abraão ti, Isaque ti, Jacó ti ke gé. Topẽ ẽn vẽ mỹr, ũ tỹ ti tỹ há' he mũ ti,” he tóg. “Topẽ ẽn vỹ ã kósin tỹ ũn mág han. Ti kósin hã vẽ, hã vỹ: Jesus, he mũ. Hã ra ãjag tóg fóg ag mỹ ti fẽg ja nĩgtĩ. Fóg tỹ pã'i tỹ Pilatos vỹ: “ti kavãn jé sóg ke mũ,” he mũ vẽ. Hã ra ãjag tóg ti mỹ: “nejé,” he ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ũ tỹ vẽnh jykre kuryj han mũ to ãjag tóg: “nejé,” he ja nĩgtĩ, Topẽ tỹ ũn kuprẽg mũ ẽn to, Jesus ẽn to. Hã ra ãjag tóg ũ tỹ ũn tén mũ to: “ti kyvãn ra,” he ja nĩgtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ũ tỹ ẽg rĩnrĩr han tĩ ẽn tén ja ãjag tóg nĩgtĩ mỹr. Topẽ tóg hã ra ti rĩn mãn ja nĩ, ti ter mũ hã ra, kỹ ẽg tóg ti ve ja nĩgtĩ,” he tóg, Pedro ti, ũn e ẽn ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Kỹ ẽg tóg Jesus ki ge mũ. Hã kỹ Jesus tóg ũn grĩ ja tag tỹ tar' he mũ, ãjag tỹ ũn vég mũ tag ti, ãjag tỹ ũn ki kanhrãn mũ tag ti. Jesus vỹ ti tỹ ã ki rã han. Kỹ ti tỹ Jesus ki rã kỹ tóg há' he mũ sir, ãjag rĩnve,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Inh kanhkã',” he tóg. “Ãjag tỹ ki kagtĩg nỹtĩn kỹ, hã kỹ ãjag tóg Jesus tén ja nĩgtĩ. Hã kỹ ãjag pã'i ag tóg ti tén ja nĩgtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","“Hã kỹ Topẽ tóg vãsỹ rán kỹ nĩ ẽn han. Topẽ vĩ tó tĩ ag kar tóg vãsỹ Jesus jagtar ke ti tó ja nĩgtĩ, Topẽ tỹ ag mỹ: ha tó, hen kỹ. “Topẽ tỹ ũn jẽnẽg mũ ẽn tỹ jagtar ke vẽ, Cristo ti,” he ja ag tóg nĩgtĩ, Topẽ vĩ tó tĩ ag,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Kỹ ãjag jykre tovãnh nĩ. Topẽ jykre ki gemnĩ, Topẽ tỹ ãjag tỹ ti vĩ mranh tỹ tũ' he jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Hã kỹ ãjag tóg tỹ Topẽ mré ke nỹtĩ, kỹ tóg ãjag krĩ tỹ kãnhvy' henh ke mũ, Topẽ ti. Kar kỹ tóg ãjag mỹ ti jẽnẽ mãn mũ gé, ti tỹ ãjag mỹ ũn jẽnẽnh ke ẽn ti, Cristo ti, hã vỹ: Jesus, he mũ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Ti tỹ kanhkã tá nĩ vẽ ver. Ti tỹ ã kurã pétẽm kỹ tóg vãhã tá vỹn kenh mũ, Topẽ tỹ nén kar han mãn ke kurã ẽn kã,” he tóg. “Hã kỹ Topẽ tóg vãsỹ ã vĩ tó tĩ ag mỹ tó ja nĩgtĩ, ag tỹ vẽnh kar mỹ ti vĩ tó jé, ti tũ ag kar mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Hã kỹ Moisés vỹ tag tó ja nĩ, ha mẽ: “Topẽ vỹ ãjag mỹ ã vĩ tó tĩ ũ jẽnẽnh ke mũ, ãjag mré ke ũ, ti tỹ ãjag mỹ Topẽ vĩ tó jé, inh ri kén. Ẽn ti vĩ jẽmẽmnĩ,” he ja tóg nĩgtĩ, Moisés ti,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","“Ũ tỹ ti vĩ jẽmẽ jãvãnh ẽn ter ke vẽ,” he ja tóg nĩgtĩ, “ẽn pi(jé) tỹ Topẽ tũ nĩ',” he ja tóg nĩgtĩ, Moisés ti,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Topẽ vĩ tó tĩ ag kar vỹ tó ja nĩgtĩ, ẽg tỹ ũri vég mũ tag ti. Samuel vỹ tag tó vén ja nĩgtĩ, kar ti nón ke ag kar tóg tag tó ja nĩ gé vãhã,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“Topẽ vĩ tó tĩ ẽn krẽ vỹ tỹ ãjag nỹtĩ,” he tóg. “Ãjag jóg'jóg ve ag hã mré tóg jykrén ja nĩgtĩ, Topẽ ti, Abraão hã mré. Hã kỹ tóg Abraão mỹ: “ã kósin ũ hã tugrĩn sóg vẽnh kar to há nĩnh mũ,” he ja nĩgtĩ, Topẽ ti,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Ãjag hã mỹ tóg ã kósin jẽnẽ, ti rĩn mãn kỹ, Topẽ ti. Ãjag hã mỹ tóg tó vén, ãjag tỹ tỹ Israel nỹtĩn kỹ. Ãjag hã mỹ tóg tó, ãjag tỹ ãjag jykre pãno tovãnh jé. Ti tỹ ãjag krĩn sór vẽ, ãjag tỹ tovãnh jé, ãjag jykre pãno ẽn ti,” he tóg, Pedro ti, ũ tỹ Topẽ jo ĩn krẽm vẽnh mãn kỹ nỹtĩ ẽn ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ag tỹ ver vẽmén kỹ nỹtĩ ra Topẽ tũ ki rĩr tĩ ag tóg tá junjun mũ. Topẽ jo ĩn to capitão vỹ ag mré tá jun mũ gé, Saduceu ag ke gé, ũ tỹ: “ẽg hỹn rĩnrĩr mãn ke tũ nĩ ha, ẽg ter kar kỹ,” he mũ ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro ag to ag tóg jũgjũ mũ, ag tỹ: “Jesus vỹ rĩr mãn,” hen kỹ. “Kỹ ẽg tóg ti ri kén rĩr mãn mũ gé, ẽg ter kỹ,” he ag tóg, Pedro ag. Hã kỹ pã'i ag tóg ag to jũgjũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hã kỹ ag tóg Pedro ag sigség mũ, vẽse jafã kãtá ag tóg ag vãm mũ, ag tỹ kãtá nũgnũr pir han jé. Rãké ti nỹ ha, hã kỹ ag tóg: “ha ver kãtá nũgnũr,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Hã ra ũ tỹ hẽn ri ke ag tóg Pedro ag vĩ mẽ ja nĩgtĩ, kỹ ag tóg sir ti vĩ kri fig mũ. Ũ tỹ 5 mil (ke) ag vẽ, Jesus ki ge kỹ nỹtĩ ag, ẽg tỹ ũn tỹtá fag mré tó tũ hã ra. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tỹ vaj kỹ pã'i ag tóg vẽnh mãn mũ, kófa ag mré hã, Topẽ vĩ to professor ag mré hã. Jerusalém tá ag tóg vẽnh mãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Topẽ tũ ki rĩr tĩ to pã'i mág jyjy hã vỹ: Anás, he mũ. Ag pã'i mág ũ jijin hã vỹ: Caifás, he mũ. Pã'i mág kanhkã ũ jyjy hã vỹ: João, he mũ, kỹ ũ jijin hã vỹ: Alexandre, he mũ. Pã'i mág mré ke kar ag vỹ tá vẽnh mãn kỹ nỹtĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Vẽnh kuju ki ag tóg Pedro ag vin mũ, kỹ ag tóg: “ũ nỹ ãjag mỹ vẽnh jykre tag nĩm, ãjag tỹ ũn grĩ ẽn tỹ há' he jé?” he mũ. “Ũ jykre tỹ ãjag ti tỹ há' hé?” he ag tóg mũ, Pedro ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kỹ vãhã Topẽ kuprĩg tóg Pedro krĩn mũ. Kỹ tóg: “ha vé,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“Nén ũ há to ãjag tóg ẽg kugmĩg mũ, ẽg tỹ ũn grĩ tỹ há' he mũ ẽn to,” he tóg. “Kỹ ãjag tóg vãhã ẽg jykre jẽmẽ sór mũ ha,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","“Ãjag mỹ sóg ẽg jykre tónh mũ, Israel kar tỹ ki kanhró nỹtĩ jé,” he tóg. “Jesus tugrĩn tóg há' hé, Nazaré tá ke ẽn tugrĩn tóg tar jẽ nĩ, ãjag tỹ ũ tỹ ka to sãg mũ ẽn hã tugrĩn. Topẽ tóg ti rĩn mãn ja nĩ, ũ tỹ cruz to ter mũ ẽn ti. Ẽn vỹ ti tỹ há' hé, ũn grĩ ja ẽn ti,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Jesus ẽn hã to tag tóg rán kỹ nĩ, Topẽ vĩ tỹ rán kỹ nĩ ẽn ki, ha mẽ: ãjag tỹ pó tỹ ĩn han kỹ ãjag tóg pó ũ fón, ti tỹ ãjag mỹ kórég nĩn kỹ. Hã ra Topẽ tóg pó ẽn hã tỹ ĩn nũna han mũ,” he ja tóg nĩ, Topẽ vĩ ki, Jesus to,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Ũ pi(jé) ẽg kren han ke mũ'. Topẽ tóg Jesus fẽg inhhã, ti hã tỹ ẽg kren han jé, ti hã tỹ ẽprã ke ag krenkren han kãn jé, kanhkã krẽm ke kar ẽn ag. Ẽg kren han ke mũ ũ venh ke tũ ẽg nĩ mỹr,” he tóg, Pedro ti, pã'i ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pã'i ag tỹ Pedro vĩ mẽ kỹ tóg ag mỹ e tĩ. “Ẽg kamẽg tũ ag tóg nĩgtĩ mỹr,” he ag tóg, Pedro to, João to ke gé. “Vẽnh rán sĩ ag nỹtĩ vẽ mỹr, escola ki ge mág ja tũ ag nỹtĩ vẽ,” he ag tóg. To jykrén kỹ ag tóg ag ki kanhró nỹtĩ. “Jesus mré ke ag vẽ,” he ag tóg mũ, Pedro ag to. Kỹ tóg ag mỹ e tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Hã ra ũn grĩ ja tóg tá jẽ ag mré. Kỹ ag tỹ ne tỹ ag kato vĩnh ke tóg tũ tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kỹ ag tóg Pedro ag mỹ: “ha ver kãpa jẽg,” he mũ. Kỹ pã'i ẽn ag tóg ver jagnẽ mré to jykrén mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kỹ ag tóg: “Ẽg hỹn ag tỹ hẽ ri kenh mũ ha'?” he mũ. “Jerusalém tá ke kar vỹ ag tỹ nén han mũ ki kanhró kar nỹtĩ. Kỹ ag jykre tóg vẽnh kar mỹ há nỹ. Kỹ ẽg tỹ ag to: ag ón vẽ, hen kỹ tóg tỹ ũn nỹ sir,” he ag tóg jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","“Ag tỹ hã ra vẽnh kar mỹ Jesus tó kỹ tóg tỹ ũ nỹ gé,” he ag tóg. “Kỹ ẽg tỹ ag mỹ: ha tó mãn tũg, henh ke vẽ,” he ag tóg. “Ãjag tỹ ti tó mãn kỹ ẽg tóg ãjag vóg kónãn ke mũ ha, he jé ẽg tóg ke mũ ag mỹ,” he ag tóg jagnẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kỹ ag tóg Pedro ag jé prẽr mãn mũ. Kỹ ag tóg: “Ker ũ mỹ tó mãn hẽ',” he mũ. “Ker Jesus tỹ vĩ mãn hẽ',” he ag tóg mũ ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Hã ra Pedro tóg João mré ag mỹ ke mũ. “Topẽ tóg ẽg mỹ: “ha vẽnh kar mỹ tó,” he ja nĩ. Ãjag tóg hã ra: “ker tó hẽ',” he mũ. Ẽg hỹn ũ tỹ hẽ vĩ han mũ', Topẽ vĩ vó, ãjag vĩ vó?” he tóg ag mỹ. “Ne nỹ hỹn Topẽ mỹ há nĩnh mũ?” he tóg. “Ẽg mỹ tó,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","“Ẽg pi(jé) tó tũg mũ', ẽg tỹ nén vég mũ ti, Jesus tỹ ẽg mỹ nén tó ja ẽn ti,” he tóg ag mỹ, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Hã ra pã'i ag tóg: “ker tó hẽ', ker tó hẽ',” he mãn mũ gé. Kỹ ag tóg ag kygvãg mũ sir. Ãjag tỹ ag vóg kónãn há ra ag tóg ag vóg kónãn tũ nĩ, vẽnh kar tỹ ag to há nỹtĩn kỹ, vẽnh kar tỹ Topẽ to: “há ti nĩ, ti hã ne tóg ũn grĩ ẽn tỹ há' he mũ',” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hã ra ũn grĩ ja ẽn tóg tĩ nĩ sir. 40 anos kãfór han tóg, kỹ Topẽ tóg ti tỹ há' hé. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro ag tỹ kygvar kỹ mũ kỹ ag tóg ãjag mré ke ag to mũ mũ. Kỹ ag tóg pã'i tỹ ãjag mỹ nén tó ẽn kãmén mũ, kófa ag tỹ: “ker Jesus tó hẽ',” he mũ ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kỹ vẽnh kar ag tóg tag jẽmẽ kỹ Topẽ mỹ vĩ há han mũ, jagnẽ mré. Kỹ ag tóg: “ẽg jóg mág',” he mũ. “Tỹ ã tóg vẽnh kar kri ke nĩ,” he ag tóg mũ. “Kanhkã han ã mỹr, ga ti, goj ti ke gé, mĩ mũ ag kar ke gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","“Ẽg jóg'jóg tỹ Davi krĩn ja ã tóg nĩgtĩ, ã camarada ẽn ti. Ã kuprĩg tỹ ã tóg ti krĩn ja nĩ. Kỹ tóg Jesus tó ja nĩgtĩ, kỹ tóg: “fóg kar ag ne tóg jũgjũ mũ, kanhgág ag ke gé,” he ja nĩ. “Inh kanhkã tỹ Israel ag ne tóg nén ũ tũ to jykrén',” he ja tóg nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","“Nação kar ag pã'i ag vỹ vẽnh génh kỹ nỹtĩ, ẽg pã'i ag ke gé, Topẽ kato tẽgtẽ jé, Topẽ tỹ ũn kuprẽg mũ ẽn ag kato,” he ja tóg nĩgtĩ, Davi ti,” he ag tóg, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Hã ra tóg ki hã tó ja nĩ. Ẽmã tag ki ag tóg vẽnh génh kỹ nỹtĩ, ã kósin kato, ã tỹ ũn kuprẽg mũ ẽn kato, ũn kuryj nĩ ẽn kato, hã vỹ: Jesus, he mũ,” he ag tóg. “Pãi mág tỹ Herodes vỹ ti kato tẽ mũ gé, pã'i tỹ Pilatos ke gé, ag tỹ ũ to: Pôncio, he mũ ẽn, fóg ag kar, Israel ag kar ke gé,” he ag tóg. “Tag ag kar vỹ vẽnh génh kỹ nỹtĩ, ã kósin kato,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","“Ã tỹ nén to jykrén mũ han ag tóg mũ sir, ã kato tẽgtẽ mũ tag ag. Vãsỹ ã tóg to: ge tĩ jé tóg ke mũ, he ja nĩgtĩ,” he ag tóg, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Pã'i ag tỹ ẽg mỹ nén tó mẽ ã tóg, ag tỹ ẽg mỹ: ker tó hẽ', he mũ tag ti. Kỹ ẽg tỹ tar' hemnĩ, ẽg tỹ ag kamẽg tũ nĩn jé, ẽg tỹ ã vĩ tó jé, ẽg tỹ tỹ ã camarada nỹtĩn kỹ,” he ag tóg, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","“Kỹ ẽg mré milagre hyn han nĩ gé. Ũn kagyga ag tỹ há' hemnĩ, ẽg tỹ nén han vãnh han nĩ, ẽg tỹ ã mỹ to vĩn kỹ, ẽg tỹ ã kósin tỹ Jesus jyjy tó kỹ, ẽg tỹ ũn kuryj nĩ ẽn tó kỹ,” he ag tóg, Topẽ mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ag tỹ ti mré vĩ kar kỹ ga tóg jũrũn ke mũ sir, ag tỹ tá nỹtĩ hã ra. Kỹ Topẽ kuprĩg tóg ag krĩn mũ gé. Kỹ ag tóg mũmẽg vãnh kỹ Topẽ vĩ kãmén mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ũ tỹ Jesus ki ge kỹ nỹtĩ ag tóg jykre pir han kỹ nỹtĩ. Ũ pi(jé) ã kuge to: “isũ vẽ,” he tĩ'. Ãjag kuge kar to ag tóg: “ẽg tũ vẽ,” he tĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesus tỹ ũn vin mũ ag tóg ẽg Senhor tỹ Jesus rĩr mãn tugtó mũ, to tar pẽ nỹtĩn kỹ. Kỹ Topẽ tóg ag ki rĩr há han mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ag mré ke ũ pi(jé) jagãgtar nỹtĩ' Ag kãmĩ ũ tóg ẽpỹ nỹtĩ, kar ũ tóg ĩn nỹtĩ gé. Ãjag tũ ẽn funfón ag tóg mũ, kỹ ag tóg ti kaja ma kãmũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jesus tỹ ũn vin mũ ag mỹ nĩm jé, jãnkamy ti. Kỹ ũn jagãgtar ag tóg jãnkamy ẽn to ãjag tỹ nén ve sór mũ ẽn mãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kỹ ũ tóg nĩ gé, ti jiji hã vỹ: José, he mũ. Jesus tỹ ũn vin mũ ag tóg ti to: Barnabé, he tĩ, hã vỹ: vẽnh jyvẽn krẽ, he mũ, hã vỹ: Barnabé, he mũ. Levi kósin'kósin ũ vẽ. Goj vãso tỹ Chipre tá ke vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ẽn hã vỹ ẽpỹ nĩ, kỹ tóg ã japỹ fón mũ, kỹ tóg Jesus tỹ ũn vin mũ ag mỹ ti kaja ma kãtĩ mũ. Kỹ ag tóg jagnẽ mỹ kãnhkrég mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kỹ ũ tóg nĩ gé, ti jyjy hã vỹ: Ananias, he mũ. Jãvo ti prũ fi jiji hã vỹ: Safira, he mũ. Ẽn vỹ tóg ã japỹ fón mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kỹ tóg ã prũ fi mỹ: “ti kaja vẽnh kãpóv péju kỹ ẽg tóg nĩm mũ,” he mũ. Ti vẽnh kãpóv ũ tỹ tóg Jesus tỹ ũn vin mũ ag mỹ nĩm mũ. “Ẽg japỹ kaja kar hã vẽ,” he tóg mũ ag mỹ, ón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kỹ Pedro tóg ti mỹ: “Satanás hã ne tóg ã krĩn ja nĩ',” he mũ. “Hã kỹ ã tóg Topẽ kuprĩg mỹ ón. Hã kỹ ã tóg ti kaja vẽnh kãpóv péju kỹ nĩm ja nĩ',” he tóg. “Hã ra ã tóg ti tỹ ã krĩn mũ ra: “nejé,” he ja tũ nĩ, Satanás mỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","“Ã japỹ vẽ (mỹr), ha mẽ,” he tóg. “Kỹ ti kaja vỹ tóg tỹ ã tũ nĩ gé sir,” he tóg. “Kỹ ã tỹ ma kãtĩ tũ nĩ hã ra tóg tỹ nén ũ tũ nĩ vẽ,” he tóg. “Hã ra ã tóg ã ón ke to jykrén ja nĩgtĩ, ã tỹ ti kaja to ón jé,” he tóg. “Hã kỹ ã tóg ẽg mỹ ón, hã ra ã tóg Topẽ hã mỹ ón mũ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias tỹ ti vĩ mẽ kỹ tóg kutẽ mũ, ti ter vẽ sir. Ũ tỹ mẽg mũ ag kar mỹ tóg e tĩ, kỹ ag fe tóg jũrũn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kỹ kyrũ ag tóg jẽgjẽg nẽgnẽ kỹ ag tóg ti fi han mũ. Kỹ ag tóg ti va mũ mũ, kỹ ag tóg ti kénh mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","3 horas tũg kỹ ti prũ fi tóg mĩ kãtĩ mũ gé. Hã ra fi tóg ã mén ter mẽ ja tũ nĩ ver. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Kỹ Pedro tóg fi mỹ: “ãjag mỹ ti kaja tag to fón, ãjag japỹ ti?” he mũ fi mỹ. Kỹ fi tóg: “hỹ, ti kaja tag to ẽg tóg fón,” he mũ, ón kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kỹ Pedro tóg fi mỹ: “ãjag ne tóg jagnẽ mré to jykrén ja nĩ gé',” he mũ. “Topẽ kuprĩg mỹ ãjag ón mỹr. Ũ tỹ ã mén kénh mũ ag vỹ mĩ kãmũ jẽg. Ã va ag tóg mũnh mũ gé,” he tóg fi mỹ, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kỹ fi tóg kutẽ kỹ hun ke mũ gé sir. Kyrũ ag tỹ junjun kỹ ag tóg fi ter vég mũ gé, kỹ ag tóg fi kénh mũ mũ gé, fi mén mré. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kỹ Jesus ki ge kỹ nỹtĩ kar ag fe tóg jũrũn ke mũ, ũ tỹ mẽg mũ kar ag ke gé. Hã kỹ Ananias fag tóg Topẽ mỹ ón tugrĩn kãgter mũ. Kỹ tóg vẽnh kar mỹ e tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesus tỹ ũn vin mũ ag tóg nén ve vãnh tỹ hẽn ri ke hyn han mũgtĩ, vẽnh kar mỹ. Jesus ki ge kỹ nỹtĩ kar ag vỹ kurã kar ki vẽnh mãn tĩ, pã'i tỹ Salomão he mũ ẽn sala tá, Topẽ jo ĩn krẽm. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jesus ki ge tũ ag tóg venh kãmũ tũ nĩgtĩ, ag tỹ ag kamẽg kỹ. Hã ra tóg vẽnh kar mỹ há tĩ sir, Jesus ki ge kỹ nỹtĩ ag jykre ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kurã kar ki ũ tóg to jykrén ke mũ, Jesus ki rã jé, ũ tỹ hẽn ri ke ag, fag ke gé. Hã ki ag tóg e nỹtĩ sir, Jesus ki ge mũ ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kejẽn ag tóg ũn kagyga gé kãmũ mũ gé vãhã, ẽpryn kri, ẽmĩn kri. Tá ag tóg cama kri nỹtĩ, nỹg jafãn ki. Kỹ ag tóg Pedro jãvãnh mũ. “Ti kãnhvég tỹ ẽg mĩ tĩg kỹ ũ tóg hẽn ri ke mũn tỹ há' henh ke,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ũ tỹ hẽn ri ke ag tóg Jerusalém tá vẽnh mãn mũ, ẽmã kar tá kãmũ ẽn ag. Ũn kagyga ag gé(g) ag tóg kãmũ mũ, ũn jagrẽ kórég ag ke gé. Kỹ ag tóg há' he kãn mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kỹ Topẽ tũ ki rĩr tĩ to pã'i mág tóg jũ tãvĩ nĩ, ti mré ke kar ag ke gé, Saduceu he mũ ẽn ag kar. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kỹ ag tóg Jesus tỹ ũn vin mũ ag sigség mũ, vẽse ja mág tá. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Hã ra kuty tá Topẽ tỹ jẽnẽ jafã tóg tére kỹ vẽse ja jãnkãn nugnón mũ, rugróm tóg mũ. Ag gé(g) tóg tĩ mũ, ag kygvãn kỹ, kỹ tóg ag mỹ: ");
INSERT INTO kgpNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ha mũ jẽg, Topẽ jo ĩn ra, ãjag tỹ vẽnh kar mỹ Topẽ vĩ tó jé, Topẽ tỹ ẽg rĩnrĩn mãn ke ẽn ti,” he mũ, Topẽ tỹ jẽnẽ jafã ti, ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ag tỹ ti vĩ mẽ kỹ ag tóg kusã pẽ ki Topẽ jo ĩn ra mũ mũ, tá Topẽ vĩ tó jé. Hã ra Topẽ tũ ki rĩr tĩ to pã'i mág tóg ã mré ke ag jẽgnẽg mũ, ag tỹ kófa ag jé prẽr jé, vẽnh jyvẽn tĩ kar ẽn ag, povo tỹ Israel to pã'i ag ke gé. Kỹ ag tóg vẽse ja ra ũ jẽgnẽg mũ, ag tỹ vẽsigse ag tatĩ kãmũ jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Polícia ag tỹ tá junjun mũ ra ag tóg vẽse ja kãtá tũgtũ nỹtĩ. Kỹ ag tóg vỹnvỹn ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Kỹ ag tóg: “vẽse ja tóg nĩfénh kỹ jẽ nĩ, nĩfénh jãfa tỹ,” he mũ. “Kỹ ũ tỹ ki rĩr mũ ag tóg tá nỹtĩ gé, ti jãnkãn tá. Ẽg tỹ nón mũ ra tóg kuprã jẽ nĩ,” he ag tóg mũ, pã'i ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Topẽ jo ĩn to capitão tỹ mẽ kỹ tóg ti mỹ e tĩ, Topẽ tũ ki rĩr tĩ to pã'i mág ag mỹ ke gé. Kỹ tóg ag krĩ tũ tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kỹ ũ tóg tá jun kỹ: “Topẽ jo ĩn krẽm ag nỹtĩ, ãjag tỹ ũn sigség mũ ag,” he mũ. “Tá ag tóg vẽnh kar mỹ Topẽ vĩ tó nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kỹ capitão tóg polícia ag mré tĩ mũ, ag tatĩ kãmũ jé. Komẽr hã ag tóg vĩ mũ, ag mré. “Ẽg vãsãnsãn kỹ ũ tỹ ag vĩ mẽg mũ ag tóg hẽn ri ke mũn ẽg pin ke mũ, pó tỹ,” he ag tóg, polícia ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Apóstolo ag tỹ ag mré junjun kỹ ag tóg pã'i ag jo ag vin mũ. Kỹ Topẽ tũ ki rĩr tĩ to pã'i mág tóg ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ãjag mỹ ẽg tóg: ker ẽn jiji tó mãn hẽ', he ja nĩgtĩ',” he mũ. “Ge ra ãjag tóg Jerusalém tá ke kar ag mỹ tugtó ja nĩgtĩ, ẽn vĩ ti,” he ag tóg, Jesus vĩ to. “Ãjag hỹn ti ter to ẽg jagãgtar han sór mũ,” he ag tóg, pã'i ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kỹ Jesus tỹ ũn vin mũ ag kar tóg ag mỹ tag tó mũ, ha mẽ. Pedro tóg ag mỹ tag tó mũ, ha mẽ: “Topẽ tỹ ẽg mỹ nén tó mũ ẽn han jé ẽg tóg ke mũ (mỹr),” he tóg. “Ẽprã ke ag tỹ ẽg mỹ: “ke tũg nĩ,” he mũ hã ra ẽg tóg ti tỹ ẽg mỹ nén tó mũ ẽn han mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Ẽg jóg'jóg ag vỹ Topẽ to há nỹtĩgtĩ. Ag tỹ ũ to há nỹtĩ ẽn vỹ Jesus ti rĩn mãn ja nĩgtĩ, ãjag tỹ ũn tén mũ ẽn ti, ka to ũn sãg mũ ẽn ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“Kỹ Topẽ tóg ti tỹ pã'i mág han mũ, ti tỹ ẽg kren han tĩ han kỹ, ti tỹ ti mỹ: “kunĩg, inh pẽgja tá nĩ,” hen kỹ. Jesus tỹ tóg ẽg kar krĩn sór mũ, ẽg povo tỹ Israel kar tỹ vẽnh jykre pãno tovãnh jé, ti tỹ ag tỹ ã vĩ mranh tỹ vẽnh pãte fón jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","“Nén kar ẽn ve ja ẽg tóg nĩgtĩ, hã kỹ ẽg tóg ti vĩ tó mũ sir. Kỹ Topẽ kuprĩg tóg ẽg kanhrãn mũ gé. Topẽ vỹ ũ tỹ ti vĩ han mũ kar ag mỹ ã kuprĩg jẽnẽg mũ,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pã'i ag tỹ ti vĩ mẽ kỹ ag fe tóg gỹm ke mũ, kỹ ag tóg ag kãgtén ke to jykrén mũ, Jesus tỹ ũn vin mũ ẽn ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kỹ vãhã ũ tóg jẽg nẽ mũ, Fariseu ũ, ti jyjy hã vỹ: Gamaliel, he mũ. Topẽ vĩ to professor ũ vẽ, kỹ vẽnh kar mỹ tóg há nỹ, ti jykre ti. Kỹ tóg: “ver ag kãpan nĩ,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ag mũ kar tóg ag mỹ: “inh kanhkã',” he mũ. “To jykrén nĩ ver, ãjag tỹ han tũ jé,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","“Pedro ag jo ke ũ tóg jẽ ja nĩ gé, ti jiji hã vỹ: Teudas, he mũ. Ti hã ne tóg vẽsỹ tỹ pã'i mág han ja nĩ, kỹ ũ tỹ 100 tỹ 4 ag vỹ ti nón mũ ja nĩgtĩ sir. Ti tén ja ag tóg nĩ jãvo, pã'i ag, kỹ ũ tỹ ti vĩ han mũ ag tóg tãmĩ mũ ja nĩ, kỹ tóg tũ' he mũ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Kar kỹ ũ vỹ jẽ ja nĩ gé, ti jyjy hã vỹ: Judas, he mũ. Galiléia tá ke ẽn vẽ. Ag tỹ vẽnh kar jygji ránrán mũ ra tóg tá jẽ ja nĩ, Judas ẽn ti, kỹ ũ tỹ hẽn ri ke ag tóg ti nón mũ ja nĩgtĩ gé. Ẽn tén ja ag tóg nĩ gé, pã'i ag, kỹ ũ tỹ ti vĩ han mũ ag tóg krig' ke ja nĩ, vẽnh pipin kỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Isỹ nén to jykrén hã vẽ, ha mẽ: Pedro ag tovãnh nĩ ver,” he tóg. “Ag mỹ: ha mũ jẽg, hemnĩ ver,” he tóg. “Ag tũ tỹ tỹ ẽprã ke ag jykre nĩn kỹ tóg tũ' henh ke mũ (mỹr), vẽsóg ki, ha mẽ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","“Ti tỹ hã ra tỹ Topẽ jykre nĩn kỹ ãjag tóg tỹ tũ' henh ke tũ nĩ,” he tóg. “Ãjag tỹ ge ra ag to jũ nỹtĩn kỹ ãjag tóg vãhã Topẽ kato tẽ mũ,” he tóg, Gamaliel ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kỹ ag tóg ti mỹ: “hej,” he mũ. Kỹ ag tóg Jesus tỹ ũn vin mũ ag jé prẽr mãn mũ. Ag mrãnmrãn ag tóg mũ. Kỹ ag tóg: “ker Jesus tó mãn hẽ',” he mãn mũ ag mỹ. Kỹ ag tóg: “ha mũ jẽg ge,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kỹ ag tóg mũ mũ, Jesus tỹ ũn vin mũ ag. Ag mỹ tóg sér tĩ, ha mẽ. Ag tỹ Jesus ri ke jagẽgtar mũ ra tóg ag mỹ sér tĩ, ag tỹ Jesus ri kén jagãgtar ke ki krỹg kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kurã kar ki ag tóg Topẽ jo ĩn tá Jesus tó tĩ, ti to: “Topẽ vỹ ti jẽnẽ,” hen kỹ. Vẽnh kar ĩn tá ag tóg ti kãmén mũ gé, ũ tỹ ag kógfyn kỹ. To ag tóg krónh ke tũ nĩgtĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kỹ ũ tỹ hẽn ri ke ag tóg Jesus ki ge mũ. Ũ ag tóg Grego vĩ tó tĩ, Jesus mré mũ ũ ag. Kỹ ũ ag tóg Hebreu vĩ tó tĩ gé, ti mré mũ ũ ag. Ag e nỹtĩn kỹ ũ tỹ Grego vĩ tó mũ ag tóg kejẽn vĩ kónãn mũ, Hebreu vĩ tó tĩ ag kato. “Ũ tỹ Hebreu vĩ tó mũ ag vỹ ẽg ki króm tũ nỹtĩ (mỹr),” he ag tóg. “Ag kã ũn mén ter ja fag vỹ kurã kar ki vẽjẽn há vég tĩ, ag tỹ fag mỹ vin kỹ,” he ag tóg. “Hã ra ẽg kã ũn mén ter ja ẽn fag kã ag tóg jatun nỹtĩ, fag tỹ ag vĩ tó tũ nĩn kỹ. Hã kỹ fag tóg jagãgtar nỹtĩ, ẽg mré ke fag,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kỹ ũ tỹ 12 ag tóg mẽg mũ, Jesus tỹ ũn vin mũ ag. Kỹ ag tóg Jesus mré mũ kar ag jé prẽr mũ. Kỹ ag tóg: “Ẽg tũ hã vẽ, hã vỹ ẽg tỹ tỹ Topẽ vĩ tó ti nỹ,” he mũ. “Ẽg tỹ vẽjẽn ki rĩr kỹ ẽg tóg kutar nỹtĩ, kỹ ẽg tóg ẽg tỹ nén han ke ki rĩr há han ke tũ nĩ gé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","“Kỹ ũ tỹ 7 (ke) ag vin nĩ, ũn kãme kórég tũ ag, ũn jykre há ag, ũ tỹ Topẽ kuprĩg tỹ jagrẽ nĩ ẽn ag,” he ag tóg. “Ẽn mỹ ẽg tóg vẽnh rãnhrãj ẽn nĩm mũ, ag tỹ vẽjẽn ki rĩr jé,” he ag tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","“Ẽg hã tóg hã ra Topẽ mré vĩ kỹ nỹtĩ, ti vĩ tó kỹ nỹtĩ. Ẽg tỹ nén han ken hã vẽ,” he ag tóg, Pedro ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ag vĩ vỹ vẽnh kar mỹ há nĩ ha, kỹ ag tóg Estêvão fẽg mũ sir, ũ tỹ Jesus ki rã kỹ jẽ ẽn ti, kỹ Topẽ kuprĩg vỹ tỹ ti jagrẽ nĩ. Ti mré ag tóg Filipe fẽg mũ gé, Prócoro ke gé, Nicanor ke gé, Timom ke gé, Pármenas ke gé, Nicolau ke gé, cidade tỹ Antioquia tá ke tag ti, fóg tỹ Israel jykre han mũ tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ẽn ag vin ag tóg mũ, Jesus tỹ ũn vin mũ ag jo. Kỹ ag tóg ag to Topẽ mré vĩ mũ, ag nĩgé tỹ ag mẽ kỹ. Hã kỹ ag tóg ag mỹ vẽnh rãnhrãj ẽn nĩm mũ, ag tỹ vẽjẽn ki rĩr jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kỹ Topẽ vĩ tóg vẽnh kar kri rũm ke mũ sir. Ũ tỹ Jesus mré mũ ag vỹ tóg hẽn ri ke nỹtĩ, Jerusalém tá. Kỹ Topẽ tũ ki rĩr tĩ ũ ag tóg Jesus vĩ kri fi kỹ ti ki ge mũ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Estêvão vỹ hã ra krĩ há nĩ, Topẽ tỹ ti mỹ vẽnh jykre nĩm kỹ. Kỹ tóg ẽg tỹ nén han vãnh tỹ hẽn ri ke hyn han mũ, vẽnh kar mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kỹ Israel ag vẽnh kanhrãn jafã ũ tá ag tóg ti vĩ kafãn mũ, ũn kygvãn kỹ nỹtĩ he mũ ẽn ag, cidade tỹ Cirene tá ke ag ke gé, cidade tỹ Alexandria tá ke ag ke gé, ga tỹ Cilícia tá ke ag ke gé, ga tỹ Ásia tá ke ag ke gé. Ẽn ag kar vỹ ãjag tỹ Estêvão mré vĩn kỹ ti vĩ kafãn mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Hã ra ag tỹ ti vĩ kafãn ke tóg tũ tĩ, ti krĩ há nĩn kỹ, ti tỹ Topẽ kuprĩg tỹ jagrẽ nĩn kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kỹ ag tóg ũ ag krĩn mũ, ag tỹ ti kato vĩ jé, Estêvão kato. Kỹ ag tóg: “ti vĩ mẽ ẽg (mỹr),” he mũ. “Moisés kato vĩ kónãn tóg (mỹr), Topẽ kato ke gé,” he ag tóg ón kỹ, Estêvão to. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hã kỹ vẽnh kar tóg ti to jũgjũ mũ, Estêvão to, kófa ag mré hã, Topẽ vĩ to professor ag mré hã. Kỹ ag tóg ti kãgmĩ kỹ ti ség mũ. Kỹ ag tóg pã'i ag jo ti pére kãmũ mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ũ tỹ ón kỹ ti kato vĩnh ke mũ ag jé ag tóg prẽr mũ gé, pã'i ag. Kỹ ag tóg ti kato: “Topẽ jo ĩn kato tóg vĩ kónãn tĩ, Topẽ tỹ ẽg mỹ nén tó ja ti kato ke gé,” he mũ ón kỹ. “Hã ra tóg ã vĩ kónãn to krónh ke tũ nĩgtĩ,” he ag tóg ón kỹ, Estêvão to. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","“Ti vĩ mẽ ẽg (mỹr),” he ag tóg. “Jesus kãmén tóg tĩgtĩ, Nazaré tá ke ẽn ti,” he ag tóg. “Topẽ jo ĩn kókén jé tóg ke mũ, Jesus ti,” he tóg nĩgtĩ, Estêvão ti, kỹ tóg Moisés tỹ ẽg mỹ vẽnh jykre nĩm mũ ẽn tỹ tũ' he sór mũ gé, ẽg mỹ vẽnh jykre ũ nĩm kỹ,” he ag tóg. Ag tỹ Estêvão to ón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kỹ pã'i kar ag tóg ti tugnỹm mũ, hã ra ti ve tóg sir Topẽ tỹ jẽnẽ jafã ve ri ke nĩ, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kỹ Topẽ tũ ki rĩr tĩ to pã'i mág tóg ti mỹ: “Ki hã ke mỹ'?” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Kỹ Estêvão tóg ag mỹ: “ijóg',” he mũ. “Inh kanhkã',” he tóg. “Ẽg jóg tỹ Topẽ vỹ tóg vẽnh kar kãfór nĩ,” he tóg. “Ti hã ne ẽg jóg'jóg tỹ Abraão mré vĩ ja nĩgtĩ, ti tỹ ver ga tỹ Mesopotâmia tá nĩ ki, ti tỹ ver ẽmã tỹ Harã ra tĩ tũ ki. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kỹ tóg ti mỹ: “ã jamã tá kutẽ,” he ja nĩ. “Ã kanhkã ag kar ré kỹ tĩg,” he ja tóg nĩ ti mỹ. “Ga ũ ra tĩg, isỹ tá ã mỹ: tag kã nĩmnĩ, he jé,” he ja tóg nĩ ti mỹ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hã kỹ tóg ga tỹ Caldéia tá kãkutẽ mũ, Hãra tá ẽmãn jé, Abraão ti. Ti panh ter kar kỹ Topẽ tóg ti mỹ: “ga tag ra tĩg sir,” he mũ. Ẽg jamãn hã vẽ, Abraão jamã ja ti,” he tóg, Estêvão ti, pã'i ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Ge ra Topẽ tóg Abraão mỹ ga ẽn nĩm ja tũ nĩ, ẽpỹ pir mré tó kỹ. Ti mỹ tóg hã ra: “ã tũnh ke vẽ, kar kỹ, ã krẽ tũnh ke vẽ gé,” he ja nĩ, Topẽ ti. Hã ra tóg ver kósin ja tũ nĩ, Topẽ tỹ ti mỹ: “ã krẽ tũnh ke vẽ,” he mũ ra. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kỹ Topẽ tóg ti mỹ: “ã krẽ ag tỹ fóg ũ ag mré mũnh ke vẽ, fóg ẽn jamã tá,” he mũ. “Fóg ẽn ag tỹ camarada han ke vẽ, ag vóg kónãn jé ag tóg ke mũ, prỹg tỹ 100 tỹ 4 ki,” he tóg, Abraão mỹ, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Hã ra ũ tỹ ag vóg kónãn mũ ẽn ag vóg kónãn jé sóg ke mũ gé, kar kỹ,” he tóg, Topẽ ti. “Isỹ ag vóg kónãn kar kỹ ã krẽ ag tóg tá kãpanh mũ. Kỹ ag tóg ga tag ki isũ ti han mũ,” he tóg, Topẽ ti. Ti tỹ Abraão mỹ ken hã vẽ,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Kỹ tóg ti mỹ vẽnh jykre nĩm mũ, ti tỹ ã krẽ ag gré junun fár kym jé. Kỹ ti sinal vẽ sir. Kar kỹ Abraão tóg Isaque han mũ. Ti tỹ kurã tỹ 8 han kỹ tóg ti mỹ kym mũ. Isaque tỹ Jacó han kỹ tóg ge han mũ gé, kỹ Jacó tóg ge han mũ gé, ti tỹ ã krẽ tỹ 12 ẽn ag han kỹ, ẽg tỹ ũ to: ẽg jóg'jóg kar, he mũ ẽn ag,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Hã ra ẽg jóg'jóg ẽn ag tóg ãjag jãvy tỹ José to jũgjũ nỹtĩ, ãjag tỹ ti tũ to én kỹ. Hã kỹ ag tóg ti vẽne he mũ, José ti, ũ tỹ ga tỹ Egito ra mũ mũ ag mỹ. Hã ra Topẽ tóg ti ki rĩr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Kỹ tóg ti jy nĩgãn mũ, ti tỹ vẽnh jagtar vég mũ ra. Ti jykre há nĩn kỹ tóg Egito tá ke ag pã'i mág mỹ há tĩ, ag tỹ ũ to: Faraó, he mũ ẽn mỹ. Hã kỹ tóg ti tỹ pã'i mág han mũ, Faraó ti, José ti tỹ. Ti tỹ tóg pã'i mág han mũ, ti tỹ Egito tá ke kar ag ki rĩr jé, Faraó mré ke kar ag ki rĩr jé gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kejẽn tóg prỹg han mũ, ga tỹ Egito mĩ hã, ga tỹ Canaã mĩ hã ke gé. Kỹ vẽnh kar tóg kókĩnkĩr mũ, prỹg kã. Kỹ ẽg jóg'jóg ẽn ag tóg kókĩnkĩr mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kỹ ũ tóg Jacó mỹ: “Egito tá ti vẽjẽn nĩ inhhã,” he mũ. Kỹ tóg ẽg jóg'jóg ag jẽgnẽg mũ, Jacó ti, ag tỹ Egito ra mũ vén jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ag tỹ ra mũ mãn kỹ José tóg vãhã ag mỹ: “inh hã vẽ,” he mũ, ã kãke ag mỹ. Hã kỹ Faraó tóg José kanhkã ki kanhró nĩ gé sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kỹ José tóg ã panh tỹ Jacó jé prẽr mũ, ti tỹ vẽnh kar tatĩn kãtĩg jé. Ũ tỹ 70 kri 5 ag vẽ, ti kanhkã ag. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kỹ Jacó tóg Egito ra tĩ mũ. Tá tóg ter mũ kejẽn. Kar kỹ ẽg jóg'jóg ag vỹ tá kãgter kãn mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ẽmã tỹ Siquém tá ag tóg kénh kỹ nỹtĩ, Abraão vỹ tóg vẽnh kej ẽn to jãnkamy nĩm ja nĩ, Emor krẽ ag mỹ, ẽmã tỹ Siquém tá,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Vãhã tóg kurã pétẽm ke mũ sir, Topẽ tỹ Abraão mỹ: “ã krẽ mỹ sóg ga ẽn nĩm mũ,” he mũ kurã ti. Kỹ ag tóg Egito tá vẽnh grun mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kejẽn ũ tá pã'i tóg tỹ pã'i jẽ, Egito tá. Hã ra tóg José mẽ ja tũ nĩ, pã'i tag ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ẽn tóg ẽg kanhkã ag kã'ug mũ, ag lograr ke tóg mũ, ẽg jóg ag vóg kónãn tóg mũ gé. Kỹ tóg ag mỹ: “ãjag krẽ kãsir ag vãm ra, ag kãgter jé,” he mũ, pã'i ẽn ti,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ti tỹ tag tó kar vãhã Moisés tóg mur mũ, kỹ tóg Topẽ mỹ há tĩ. Hã ra ti han mũ fag tóg kysã tãgtũ hã ki ti ki rĩr mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kysã tãgtũ tũg kỹ fag tóg sir ti fón mũ. Hã ra Faraó ẽn kósin fi tóg ti ve kỹ ti vãg mũ, ti jẽ'ỹn jé. Kỹ tóg fi kósin ri ke nĩ, Moisés ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kỹ tóg nén kar ki kanhrãn mũ, Egito tá vẽnh jykre kar ẽn ki. Kỹ ti jykre vỹ vẽnh jykre tỹ hẽn ri ke nĩ, kỹ ti vĩ vỹ vẽnh vĩ tỹ hẽn ri ke nỹ gé, Moisés ti,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Vãhã tóg prỹg tỹ 40 han mũ, Moisés ti. Kỹ tóg ã kanhkã pẽ ag to jykrén mũ, povo tỹ Israel to, ag tỹ nén han mũ venh tĩg jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kỹ tóg ũ vég mũ. Egito tá ke ũ vég tóg mũ, Moisés ti. Ti tỹ Israel vóg kónãn vég tóg mũ, nén ũ tũ to. Kỹ tóg ti to jũ kỹ Israel ẽn kajãm mũ, ti tén tóg mũ, Egito tá ke ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Inh kanhkã ag hỹn isỹ nén han mũ to jykrén mũ,” he tóg. “Hã kỹ ag tóg ki kanhró nỹtĩ, Topẽ tỹ inh tugrĩn ag kren han ke ti,” he tóg, Moisés ti. Hã ra ag tóg to jykrén tũ nỹtĩ, ti kanhkã ag,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Tỹ vaj kỹ tóg ag to tĩg mãn mũ, ã kanhkã ag to. Kỹ ũn régre ag tóg jagnẽ to jũ nỹtĩ, Israel ag. Kỹ Moisés tóg ag tỹ jagnẽ to há han sór mũ. Hã jé tóg ag mỹ: “tỹ ãjag tóg jagnẽ kanhkã nỹtĩ vẽ,” he mũ. “Ãjag tỹ ne jé jagnẽ vóg kónãn sór nẽ?” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ũ tỹ ã régre vóg kónãn mũ ẽn tóg ti vóg kỹ ti mỹ: “ã pi(jé) tỹ ẽg pã'i nĩ',” he mũ. “Ã pi(jé) ẽg jyvẽn mũ',” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","“Ã hỹn isén sór mũ, ã tỹ rãké tá Egito tá ke ẽn tén ri ke han sór ã hỹn mũ,” he tóg ti mỹ,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Kỹ Moisés tóg ã tỹ ti vĩ mẽ kỹ tóg vẽnh péju kỹ tĩ mũ. Kỹ tóg ga tỹ Midiã ra tĩ mũ. Povo ũ ag mĩ tóg tĩ mũ gé. Tá tóg prũg kỹ kósin régre han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Prỹg tỹ 40 tũg kỹ Topẽ tỹ jẽnẽ jafã vỹ ti mỹ vẽnh ven mũ, ti tỹ ẽmã tũ ja mĩ tĩ mũ ra, krĩ tỹ Sinai tá. Vãnh grug ki tóg ti vég mũ, Moisés ti, Topẽ tỹ jẽnẽ jafã ẽn ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ti tỹ ti ve kỹ tóg ti mỹ e tĩ. Kỹ tóg ra tĩ mũ, ti ve há han jé. Kỹ tóg vẽnh vĩ mẽg mũ. Topẽ vĩ vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Kỹ tóg ti mỹ: “tỹ sóg ã jóg'jóg ag Topẽ nĩ,” he mũ, “Abraão Topẽ, Isaque Topẽ, Jacó Topẽ,” he tóg, vẽnh vĩ ti. Hã ra Moisés tóg jũrũn ke mũ, ti kamẽg kỹ. Kỹ tóg tá ẽvãnh jãvãnh nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Hã ra Topẽ tóg ti mỹ: “ã pẽn né kunũ ra, ã pẽn to ró ti,” he mũ. “Inh jo ã tóg jẽ nĩ (mỹr), hã ra sóg vẽnh kar kãfór nĩ. Hã kỹ kunũ,” he tóg, Topẽ ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","“Egito tá ke ag tỹ isũ ag vóg kónãn vég isóg nĩ nĩ. Ag vẽkrẽnkrẽr mẽg sóg nĩ nĩ. Kỹ sóg tére, sỹ ag kygvãn jé. Hã kỹ sóg ã jẽnẽg mũ, ga tỹ Egito ra, ã tỹ ag kygvãn jé. Ha tĩg,” he tóg, Topẽ tỹ jẽnẽ jafã ti, Moisés mỹ,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moisés ẽn hã jẽnẽ ja tóg nĩ, Topẽ ti, ti tỹ ã kanhkã ag kren han jé, ti tỹ tỹ pã'i nĩ jé. Hã to Topẽ tỹ jẽnẽ jafã tóg ti mỹ vẽnh ven, vãnh gru ki. Hã ra ti kanhkã ag tóg ti to é he ja nĩgtĩ, ti mỹ: “ã pi(jé) tỹ ẽg pã'i nĩ',” hen kỹ, “ã pi(jé) ẽg jyvẽn mũ',” hen kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés tóg sir ẽg tỹ nén han vãnh hyn han, ga tỹ Egito tá, goj kafã tũ tá ke gé, goj kusũg he mũ ẽn tá ke gé. Kỹ ag tóg ẽmã tũ mĩ mũ mũ, prỹg tỹ 40 ki, ti kanhkã ag. Kỹ Moisés vỹ ag jo tĩ mũ, ti tỹ ga tỹ Egito tá ag kãpan kỹ. Hã ra tóg ag mũn ki ẽg tỹ nén han vãnh hyn han mũ gé,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Moisés tóg ã kanhkã ag mỹ, povo tỹ Israel ag mỹ tóg tag tó ja nĩ: “Topẽ vỹ ãjag mỹ ã vĩ tó tĩ ũ jẽnẽnh mũ, ãjag mré ke ũ, ti tỹ ãjag mỹ Topẽ vĩ tó jé inh ri kén,” he ja tóg nĩgtĩ, Moisés ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés ẽn hã ne tóg povo tỹ Israel ag mré ẽmã tũ mĩ tĩ ja nĩgtĩ. Ag tỹ kejẽn pãnónh tỹ Sinai tá nỹtĩn kỹ tóg Topẽ tỹ jẽnẽ jafã mré vĩ mũ, Moisés ti. Kỹ tóg ti mỹ vẽnh vĩ nĩm mũ, Topẽ ti, ẽg tỹ ti vĩ ẽn han kỹ ẽg tỹ ẽg rĩr krỹg ja tũ ve jé. Kỹ Moisés tóg ẽg jóg'jóg ag mỹ vẽnh vĩ ẽn tugtó mũ. Hã ra tóg ẽg mỹ tó mũ gé,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Moisés vĩ han vãnh ag nỹtĩ, ẽg jóg'jóg ag. Kỹ ag tóg ti tovãnh kỹ ga tỹ Egito ra mũ mãn sór mũ, kyrãgrã kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kỹ ag tóg Moisés jãvy tỹ Arão mré vĩ mũ. Kỹ ag tóg ti mỹ: “ẽg mỹ vẽnh kãggrá tỹ topẽ han, retrato tỹ, ẽg tỹ vẽnh jo ag gé(g) mũ jé,” he ag tóg. Hã ra Moisés vỹ ver pãnónh tỹ Sinai kri nĩ nĩ. Kỹ ag tóg Arão mỹ: “Moisés tóg ẽg jo tĩg ja nĩ,” he mũ. “Ẽg kãpan ja tóg nĩ, ga tỹ Egito tá, hã ran hẽ ra vyr hỹn'?” he ag tóg ti mỹ. Kỹ tóg ag mỹ: “hej,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kỹ ag tóg monh sĩ kãggran mũ. Kỹ ag tóg ti kãggrá ẽn mỹ ag tóg ãjag mẽg kugprũn mũ, retrato ẽn mỹ. Ag tỹ han mũ tóg ag mỹ sĩnvĩ tĩ. Kỹ tóg ag mỹ sér tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Hã ra Topẽ tóg vẽnh kaja jé ag tovãnh mũ gé, hã kỹ ag tóg rã to jãnjãn mũ, kysã to (mỹr), krĩg kar to (mỹr). Hã kỹ Topẽ vĩ tó tĩ ũ tóg ag to rán mũ gé, kỹ tóg: “Israel',” he mũ. “Ãjag tỹ ẽmã tũ ja mĩ mũn kỹ ãjag tóg inh mỹ nén ũ pũn ja tũ nĩgtĩ (mỹr),” he tóg. “Prỹg tỹ 40 ki ãjag tóg ẽmã tũ ja mĩ mũ ja nĩgtĩ,” he tóg, “hã ra ãjag tóg topẽ ũ ag mỹ kugprũn ja nĩgtĩ, inh mỹ pũn tũ nĩn kỹ,” he tóg, Topẽ ti, ã vĩ tó tĩ tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","“Topẽ tỹ Moloque ĩn sĩ va ãjag tóg mũ ja nĩgtĩ, krĩg kãggrá ke gé, hã vỹ: Renfã, he mũ, krĩg retrato ẽn ti,” he tóg. “Vẽnh kãggrá ẽn to ãjag tóg jãnjãn ja nĩgtĩ,” he tóg. “Hã kỹ sóg ãjag vóg kónãn kỹ Babilônia tá ke ag jẽgnẽnh mũ, ag tỹ ãjag tatĩn mũ jé, cidade tỹ Babilônia mã ra,” he tóg, Topẽ ti, ã vĩ tó tĩ tỹ,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ẽg jóg ag tỹ ẽmã tũg ja mĩ mũn kỹ ag tóg kur tỹ Topẽ pẽ jo ĩn han ja nĩ, ag tỹ tá Topẽ tũ han jé, ti ĩn tá. Topẽ vỹ Moisés mỹ tó ja nĩ, ti tỹ kur tỹ Topẽ jo ĩn han jé, kỹ tóg ti tỹ nén han ke ven ja nĩ ti mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ag krẽ tóg sir ag ri kén ĩn tỹ kur ẽn ma mũ ja nĩgtĩ gé, ag tỹ Topẽ tỹ ãjag mỹ ẽmã tó mũ ẽn ra mũn kỹ. Moisés ter kar Josué tóg sir ag jo tĩ mũ, kỹ ag tóg ga ẽn ra mũ mũ. Hã ra Topẽ tóg ga ẽn tá ke ag kãpan mũ, ẽg jóg'jóg ag jo. Kejẽn Davi tóg tỹ ag pã'i nĩ sir, prỹg tỹ hẽn ri ke kar kỹ. Hã ra ĩn tỹ kur ẽn tóg ver jẽ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Topẽ vỹ Davi to há nĩ. Kỹ Davi tóg ti mỹ: “sỹ ã mỹ ĩn há han há tóg tĩ vẽ,” he mũ. “Ã hã ne tóg tỹ ijóg'jóg tỹ Jacó Topẽ nĩ,” he tóg. “Kỹ tóg ã tỹ ĩn tỹ kur krẽm nĩn kỹ inh mỹ há tũ nĩ,” he tóg ti mỹ, Davi ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Hã ra Davi tóg han tũ nĩ ver. Ti kósin tỹ Salomão tóg ĩn ẽn han mũ,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kỹ tóg ag mỹ: “hã ra vẽnh kar kãfór ẽn tóg ẽg tỹ ti jo ĩn han mũ ẽn krẽm nĩ tũ nĩgtĩ (mỹr),” he mũ. “Hã kỹ Topẽ vĩ tó tĩ ũ tóg ti to tag tó ja nĩ, ha mẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Kanhkã tãn vỹ tỹ inh nĩ,” he tóg. “Inh nĩg ja ri ken hã vẽ,” he tóg. “Kỹ ga vỹ tỹ isũ nĩ gé. Sỹ tá vẽnhkán sór nĩn kỹ sóg kenh ke mũ. Isũ kar vẽ. Kỹ ãjag tỹ inh mỹ ĩn han sór kỹ ãjag hỹn hẽ ri kenh mũ'?” he tóg. “Pétẽm ke tũ ãjag nĩnh mũ, ãjag tỹ inh mỹ vẽnhkán jafã han ken ki,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","“Inh hã ne tóg nén kar hyn han ja nĩ inhhã,” he tóg, Topẽ ti, ã vĩ tó tĩ tỹ,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Kỹ tóg ag mỹ: “krĩ tũ ãjag nỹtĩ (mỹr),” he mũ. “Ki kanhrãn jãvãnh ãjag tóg nỹtĩ (mỹr),” he tóg. “Kỹ ãjag nĩgrẽg tóg kutu nĩ gé (mỹr), Topẽ kuprĩg kato ãjag tóg vãsãnsãn nỹtĩ. Ãjag jóg'jóg ag mré ãjag tóg ti kato vãsãnsãn nỹtĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","“Ãjag jóg'jóg ag ne tóg Topẽ vĩ tó tĩ ag kar vóg kónãn ja nĩgtĩ', ag kãgtén ja ag tóg nĩgtĩ'. Hã ra ẽn ag tóg ũ tỹ vẽnh jykre kuryj han mũ ẽn kãmén ja nĩgtĩ, hã vỹ: Jesus, he mũ. Ti kãtĩg ke jo ag tóg ti tó ja nĩgtĩ, Topẽ vĩ tó tĩ ag. Jãvo ãjag tóg ẽn kato vĩ ja nĩgtĩ, fóg mỹ. Kỹ ãjag tóg ti tén ja nĩgtĩ, Cristo ti,” he tóg, Estêvão ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","“Topẽ hã ne ãjag mỹ ã vĩ nĩm ja nĩ', ã tỹ jẽgnẽ jafã ag tỹ. Hã ra ãjag tóg ti vĩ mrynhmranh ja nĩgtĩ,” he tóg. Estêvão tỹ pã'i ag mỹ tón hã vẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ũ tỹ tá nỹtĩ ag tỹ ti vĩ mẽ kỹ ag fe tóg gỹm ke mũ. Kỹ ag tóg ãjag jã tỹ gyngyn he mũ, tỹ ag tóg gangan ke mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Hã ra Topẽ kuprĩg tóg Estêvão krĩn mũ, kỹ Estêvão tóg kanhkã ki ẽvãnh mũ. Kỹ tóg Topẽ vég mũ, ti kókov ti. Jesus vég tóg mũ gé, Topẽ pẽgja tá tóg jẽ nĩ, Jesus ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kỹ tóg: “ha vé,” he mũ. “Kanhkã tá sóg vég mũ,” he tóg. “Kỹ ẽprã ke fi kósin tóg Topẽ pẽgja tá jẽ nĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Kỹ ag tóg prẽnprẽr mũ sir, ãjag nĩgrẽg nĩgfénh kỹ. Ti to ag tóg vẽnh génh mũ sir, ag kar ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kỹ ag tóg ti ség mũ, cidade tỹ Jerusalém tá ag tóg ti kutẽm mũ gé. Kỹ ag tóg ti pin mũ, pó tỹ. Ãjag kur vãvãm ag tóg mũ, kỹ kyrũ tóg ki rĩr mũ, ag kur ki. Kyrũ ẽn jiji hã vỹ: Saulo, he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kỹ ag tóg Estêvão pin mũ sir, pó tỹ. Hã ra Estêvão tóg jamã hár(a): “!..inh Senhor'..!” he mũ. “!..Jesus'..!” he tóg. “!..Inh kuprĩg jãvãnh ra..!” he tóg mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kỹ tóg ã jakrĩ tỹ jẽ kỹ prẽr mũ, jamã hár(a), kỹ tóg: “!..inh Senhor'..!” he mũ. “!..Ag tỹ inh pin tỹ vẽnh pãte fón ne..!” he tóg mũ. Kar kỹ tóg hun ke mũ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jãvo Saulo ẽn mỹ tóg há tĩ, ag tỹ ti tén kỹ. Kurã ẽn kã ag tóg Jesus ki ge mũ kar vóg kónãn jagy han mũ, Jerusalém tá. Ũ tỹ vẽnh mãn tĩ ag vóg kónãn ag tóg mũ gé, ũ tỹ Topẽ vĩ mẽ jé vẽnh mãn tĩ ag. Kỹ ag tóg jagãgtar tãvĩ nỹtĩ. Kỹ ag tóg vẽnh kãpugpóv kãn mũ sir. Ga tỹ Judéia kar mĩ ag tóg mũ mũ, ga tỹ Samaria mĩ ke gé. Hã ra Jesus tỹ ũn vin mũ ag hã tóg Jerusalém tá nỹtĩ nĩ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ũ tỹ Topẽ to há tĩ ag tóg fe kaj nỹtĩ, Estêvão ter kỹ. Kỹ ag tóg kygfỹ mág kỹ ti kénh mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Hã ra Saulo tóg Jesus ki ge kỹ nỹtĩ kar ag vóg kónãn jagy han mũ, ũ tỹ Topẽ vĩ mẽ jé vẽnh mãn tĩ ag. Ti tỹ ag tũg sór vẽ, Saulo ti. Hã jé tóg ĩn kar kãra rã tĩ. Ti tỹ Jesus ki rã kỹ jẽ ũ ven kỹ tóg vẽse jan kãtá ti fón ti, ũn gré ag, ũn tãtá fag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ũ tỹ vẽnh kãpugpóv mũ ẽn ag vỹ vẽnh kar mỹ vẽnh vĩ sér tugtó mũgtĩ, Topẽ vĩ ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Kỹ Filipe tóg tĩ mũ gé. Ga tỹ Samaria ra tóg tĩ mũ, kỹ tóg cidade ũ ki ra mũ, Cristo kãmén jẽ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kỹ vẽnh kar tóg ti vĩ mẽgmẽg mũ. Jẽmẽ há han ag tóg mũ, Filipe vĩ ti. Hã ra Filipe tóg ẽg tỹ nén han vãnh hyn han mũ gé. Kỹ ag tóg vég mũ. Hã kỹ ag tóg jẽmẽ há han mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Vẽnh jagrẽ kórég tỹ hẽn ri ke pan tóg mũ, Filipe ti. Ti tỹ ag pan kỹ ag tóg jamã hár(a) prẽr mũ, kỹ ag tóg kãpa mũ. Ũ grĩ ag tỹ há' he tóg mũ gé, ũn vagvá ag tỹ ke gé, ũn vygvá ag tỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kỹ tóg vẽnh kar mỹ sér tĩ sir, cidade ẽn tá. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kỹ Simão tóg nĩ nĩ, cidade ẽn tá ke ũ. Kujá vẽ, Simão ẽn ti. Kỹ tóg nén vẽnhmỹ hyn han tĩgtĩ. Kỹ tóg ga tỹ Samaria tá ke ag tỹ ti tỹ nén han ve kỹ tóg ag mỹ e tĩ. Vẽso tóg: “ag kãfór inh nĩ,” he tĩ, ag tỹ ti kamẽg jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Hã kỹ vẽnh kar tóg ti kamẽg mũ sir, ũn sanh ag, gĩr ag ke gé. Ti to ag tóg: “Topẽ jykre han tóg tĩgtĩ, Topẽ jykre mág (pẽ) ẽn,” he tĩ, Simão ẽn to. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kysã tỹ hẽn ri ke ki tóg nén vẽnhmỹ hyn han ti, kỹ tóg vẽnh kar mỹ e tĩ, hã kỹ ag tóg ti kamẽg tĩ sir. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Vãhã ag tóg Filipe vĩ kri fig mũ, Samaria tá ke ag, ti tỹ Jesus Cristo tón kỹ. Topẽ tỹ tỹ ẽg pã'i nĩ kãmén tóg mũ, Filipe ti. Ũ tỹ ã vĩ kri fig mũ ag kygpég tóg mũ, ũn gré ag, ũn tãtá fag ke gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kỹ Simão ẽn tóg ti vĩ kri fig mũ gé, kujá ẽn ti. Kỹ Filipe tóg ti kypég mũ gé. Kỹ tóg Filipe mré nĩ nĩ. Kỹ tóg Filipe tỹ ẽg tỹ nén han vãnh hyn han mũ vég mũ, Topẽ jykre tỹ. Kỹ tóg ti mỹ e (pẽ) tãvĩ tĩ sir, Simão mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kỹ vãhã Jesus tỹ ũn vin mũ ag tóg kejẽn mẽg mũ, Samaria tá ke ag tỹ Topẽ vĩ kri fig mũ ẽn ti. Jerusalém tá ag tóg mẽg mũ, kỹ ag tóg João mré Pedro jẽnẽg mũ, ag tỹ ve jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pedro ag tỹ tá junjun kỹ ag tóg ag to Topẽ mré vĩ mũ, Samaria tá ke ag to, Topẽ tỹ ã kuprĩg tỹ ag jagrẽn jé. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tá ke ũ tóg tỹ jagrẽ tũ ja nĩ ver. Kygpe kỹ ag nỹtĩ inhhã, Jesus jiji tó kỹ, ẽg Senhor jyjy tó kỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kỹ Pedro ag tóg ãjag nĩgé tỹ ag mẽgmẽg mũ, kỹ Topẽ kuprĩg tóg ag kãra rã mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Hã ra Simão tóg vég mũ, Jesus tỹ ũn vin mũ ag tỹ nén han mũ ti. Ag tỹ ũ mẽ kỹ Topẽ kuprĩg tóg ag kãra rã mũ. Ẽn vég tóg mũ, Simão ti. Kỹ tóg ag mỹ jãnkamy ven mũ, Pedro ag mỹ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kỹ tóg ag mỹ: “inh mỹ vẽnh jykre tag nĩm nĩ, jãnkamy tag to,” he mũ. “Sỹ ũ mẽ kỹ Topẽ kuprĩg tóg ag kãra rãnh ke mũ. Sỹ vẽnh jykre ẽn ki kanhrãn há tóg tĩ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Hã ra Pedro tóg ti mỹ: “ã jãnkamy mré ã nũgme ki kutẽnh mũ,” he mũ. “Topẽ tỹ nĩm ja vẽ (mỹr), hã ra ã tóg jãnkamy ti mãn sór mũ, vẽnh jykre ti,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","“Ã pi(jé) Topẽ jykre tag ki kanhró nĩnh mũ', kỹ Topẽ tóg ã mỹ nĩm ke tũ nĩ,” he tóg. “Ã jykre pijé kuryj nỹ', Topẽ mỹ,” he tóg. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","“Ã jykre pãno tag tovãnh ra,” he tóg. “Topẽ mré vĩ. Hẽn ri ke mũn tóg ã mỹ vẽnh pãte fón mũ, ã tỹ vẽnh jykre pãno to jykrén mũ tag ti,” he tóg. Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","“Fe kórég tãvĩ ã nĩ (mỹr), kỹ ã jykre vỹ pãno nỹ gé sir,” he tóg, Pedro ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kỹ Simão tóg ti mỹ: “iso Topẽ mré vĩ, inh jagtar jẽg tũ nĩ jé, ã tỹ inh mỹ tó mũ tag ti,” he mũ. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Hã ra Pedro ag tóg mũ mãn gé, ag tỹ ẽg Senhor tỹ Jesus vĩ tó kar kỹ. Ãjag tỹ nén ve ja ẽn tó kãn ag tóg, Jesus tỹ nén han ja ti. Kỹ ag tóg Jerusalém to vỹnvỹn ke mũ sir. Ag mũ kỹ ag tóg ga tỹ Samaria mĩ Topẽ vĩ há tugtó mũ gé. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Hã ra Topẽ tỹ jẽnẽ jafã tóg Filipe mỹ vĩ mũ, kỹ tóg: “kanhkã tãpér ra tĩg, ẽpry jagma tĩg, ẽmĩn jagma,” he mũ. Jerusalém tán kãtĩ, Gaza mĩ, hã ra tóg ẽmã tũ fĩn kutẽ mũ. Ẽpry ẽn jagma tĩg, ẽmĩn ẽn jagma,” he tóg mũ, Topẽ tỹ jẽnẽ jafã ti. Kỹ tóg tĩ mũ sir, Filipe ti. ");
INSERT INTO kgpNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tá jun kỹ tóg ga tỹ Etiópia tá ke vég mũ, pã'i fi rãnhrãj han tĩ ti, pã'i tỹ rainha fi tỹ nén ũ kar vég tĩ ti,