﻿USE sofia;
DROP TABLE IF EXISTS sofia.kgkNT_vpl;
CREATE TABLE kgkNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kgkNT_vpl WRITE;
INSERT INTO kgkNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hesu Cristo Davi amyrĩ remiarirõ joapyri pyri voi. Ha Davi amyrĩ katu Abraão amyrĩ remiarirõ joapyri pyri voi. Hembypykwe héry kwéry a-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Yma ete va'ekwe oiko va'ekwe Abraão amyrĩ. Ta'ýry jevy jevyha ko va'e. Ta'ýry Isaque. Upéi Isaque ra'y jevy Jacó. Upéi ta'ýry jevy Judá tyvýry kwéry ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Upéi Judá ra'y jevy, Perez tyvýry Zerá ndive oiko va'ekwe. Isy héry Tamar. Upéi Perez ra'y jevy Esrom. Upéi ta'ýry jevy Arão. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Upéi ta'ýry jevy Aminadabe. Upéi ta'ýry jevy Naassom. Upéi ta'ýry jevy Salmom. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Upéi ta'ýry jevy Boaz. Isy katu héry Raabe. Upéi Boaz ra'y jevy Obede. Isy katu héry Rute. Upéi Obede ra'y jevy Jessé. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Upéi ta'ýry jevy mburuvixagwasu Davi. Upéixa Abraão amyrĩ-gwi mburuvixagwasu Davi amyrĩ peve oĩ va'ekwe quatorze he'ýi joapyri pyri va'ekwe. Upéi Davi ra'y jevy Salomão. Isy katu Urias rembirekokwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Upéi Salomão ra'y jevy Roboão. Upéi ta'ýry jevy Abias. Upéi ta'ýry jevy Asa. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Upéi ta'ýry jevy Josafá. Upéi ta'ýry jevy Jorão. Upéi ta'ýry jevy Uzias. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Upéi ta'ýry jevy Jotão. Upéi ta'ýry jevy Acaz. Upéi ta'ýry jevy Ezequias. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Upéi ta'ýry jevy Manassés. Upéi ta'ýry jevy Amom. Upéi ta'ýry jevy Josias. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Upéi ta'ýry jevy Jeconias tyvy kwéry ndive. Oiko jave Jeconias, he'ýi kwéry ndive oipyhy-ma íxupe heraha-vy Babilônia yvy akéno-py. Upéixa Davi amyrĩ-gwi yvy akéno-py ojereraha hagwe peve oĩ va'ekwe quatorze he'ýi joapyri pyri va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yvy akéno-py ojereraha rire, oiko va'ekwe Jeconias ra'y Salatiel amyrĩ. Upéi ta'ýry jevy Zorobabel. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Upéi ta'ýry jevy Abiúde. Upéi ta'ýry jevy Eliaquim. Upéi ta'ýry jevy Azor. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Upéi ta'ýry jevy Sadoque. Upéi ta'ýry jevy Aquim. Upéi ta'ýry jevy Eliúde. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Upéi ta'ýry jevy Eleázar. Upéi ta'ýry jevy Matã. Upéi ta'ýry jevy Jacó. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Upéi ta'ýry jevy José. Ha'e Maria ména. Upe Maria Hesu sy voi. Hesu héry ave Cristo, Nhandejáry rembiporavokwe voi, judeu kwéry remiha'arõ va'e voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Upéixa yvy akéno-py ojereraha hagwe-gwi Cristo peve oĩ va'ekwe quatorze he'ýi joapyri pyri va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hesu Cristo oikomaha a-rami. Oiko va'ekwe Maria isyrã José rembirekorã. Omenda e'ỹ mboyve, oikwaa-ma va'ekwe omembyrã. Ome'ẽ-ma va'ekwe íxupe imembyrã Nhe'ẽ Marangatu tee va'e. Ndaha'éi kwimba'e-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ha imenarã José katu tekoha-rupi voi oiko va'e. Oikwaa gwembirekorã imemby-tagwi, opoise mo'ã íxugwi: “Imemby rei-ta xe rembirekorã” he'i mo'ã. “Xe nda'e mo'ãi joty mba'eve atýra-py” he'i ojéupe ojepy'amongeta-vy. Upéa-gwi, “Apoi nhemi-ta íxugwi” he'i mo'ã ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pyhare onhemongeta ha'e ae opy'a ndive: “Mba'éixa po apoi-ta íxugwi?” he'i he'i ojéupe. Upéi ikéra-py ojehexa uka íxupe Nhandejáry rembigwái yváy pygwa: —Nde, José, Davi remiarirõre, he'i ohenói-vy íxupe. —Eraha katu Maria-pe nde róga-py ne rembirekorã. Ani katu eretĩ teĩ ereiko-vy indive. Ani erenotĩ teĩ ne rembirekorã ogwereko-ta va'e mitã, he'i íxupe. —Nhe'ẽ Marangatu tee va'e-rupi ae ogwereko-ta upe va'e mitã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","—Oiko-ta imemby kwimba'e va'e. Gwe'ýi kwéry-gwi omboyke va'erã hembiapo vaikwe, he'i íxupe ikéra pygwa. —Upéa-gwi erehenói va'erã íxupe Hesu-py. Pene resendeharã-gwi embohéry íxupe Hesu, he'i íxupe Nhandejáry rembigwái ikéra-py imombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","—Yma Nhandejáry nhe'ẽ-py omombe'u va'ety remimoĩgwe kwatia-rehe a-rami: “Oĩ oikwaa va'erã omembyrã omenda e'ỹ reheve. Ha upe rire katu oiko-ma va'erã imemby. Emanuel-py ohenói va'erã imemby-pe” he'i upe Nhandejáry rembiporavokwe Cristo syrã-rehe. Emanuel he'i Nhandejáry-rehe nhane moirũharã-rehe. Ipokatu voi upe va'e Nhandejáry kwatia nhe'ẽ. Upéa-gwi yma gware he'i hagwe-rami ãy oiko-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ko'ẽmba rire opáy-ma José. Ohendupa-ma Nhandejáry nhe'ẽ. Ogweraha-ma Maria gwóga-py gwembirekorã mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hembireko jepe, gwembireko e'ỹ-rami joty ogwereko. Omboete-gwi íxupe, ogwereko mombyry joty íxupe. Ndokéiry vyteri hendive. Ha upe rire ae katu imemby kwimba'e oiko-ma rire, ogwereko ete-ma katu gwembireko-pe, ojehe'a tee-ma hese. Ãy katu oiko tee gwembireko ndive. Maria memby rypykwe-pe, “Hesu” he'i ombohéry-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ha upéi katu Herodes mburuvixagwasu ramo oiko jave, oiko-ma Hesu. Belém tetã-my, Judéia yvy-py oiko-ma. Upe jave ogwahẽ-ma ou-vy Jerusalém tetã-my mombyrygwa hi'arandu eterei va'e. Mombyry-gwi kwarahy resẽ-gwi ou ra'e: ");
INSERT INTO kgkNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—Kipy tipo oime mitã'i judeu kwéry ruvixagwasurã oiko va'ekwe? he'i oporandu-vy. —Pe mitã'i oikomaha kwaa ukaha va'e jasytata ojeupi oho-vy ramo kwarahy resẽ-my, orohexa-ma va'ekwe. Upéa-gwi mitã'i-pe oroju oromboete-vy, he'i Jerusalém tetã mygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Judeu ruvixarã rerakwã ohendu-ma ramo judeu ruvixagwasu Herodes, onhemondýi voi. Ndaipy'agwapyvéi-ma voi upéa oikwaa ramo. Entéro Jerusalém tetã mygwa gwive onhemondyipa hikwái. Ndaipy'agwapyvéiry oikwaa ramo upéa hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Upéa-gwi Herodes ohenói ou hagwã pa'i ruvixa kwéry gwive judeu rekombo'ehaty kwéry ndive: —Mamo-py po oiko va'erã upe Nhandejáry rembiporavo Cristo? Kipy tipo hekwagwã? Mbava'e tipo he'i va'ekwe yma gware kwatia nhe'ẽ? he'i oporandu-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Belém tetã-my, Judéia yvy-py oiko-ta, he'i. —Nhandejáry nhe'ẽ-py omombe'u va'ety remimoĩgwe kwatia-rehe he'i a-rami: ");
INSERT INTO kgkNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ha'e-ta Belém tetã, Judéia yvy pygwa-rehe. Tetã'i jepe tuvixave va'e-rami joty. Upe-gwi oiko va'erã mburuvixagwasu. Gwymba-rehe onhangarekoha-rami, onhangareko va'erã Israel kwéry xe re'ýi kwéry-rehe” he'i Nhandejáry kwatia nhe'ẽ. Upéa-gwi upe Nhandejáry rembiporavo oiko-ta Belém-py, he'i Herodes-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Upe ramo Herodes ohenói ou hagwã upe hi'arandu va'e kwéry. Omoha'e anho ohenói-vy oporandu hagwã upe jasytata-rehe: —Araka'e pyhare po ojehexa uka ra'e peẽ-my jasytata? he'i oporandu-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Oikwaa-ma ramo omondo Belém-py: —Tapeho pejohu peve peheka íxupe, he'i. —Mamo pa oime pehexa porã. Petopa-ma ramo íxupe, peju jevy kuri pemombe'u xe-vy aikwaa hagwã xe ave aha hagwã ahexa íxupe, aha hagwã xe ave amboete íxupe, he'i mo'ã upe hi'arandu va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ohendu-ma ramo mburuvixa nhe'ẽ, oje'ói hikwái oheka-vy. Upéi upe jasytata ojeupi ypy jave kwarahy resẽ-my ohexa va'ekwe oho henonde-rupi. Upéi mitã'i oimeha ári opyta yvate-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ohexa ramo, ovy'a eterei. —Iporã ete katu. Jahexa jevy-ma jasytata, he'i herovy'a-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Upéi ogwahẽ oho-vy óga-py. Upe-py ohexa mitã'i-pe isy Maria ndive oiko ramo. Gwetypy'ã-rehe onhesũ imboete-vy íxupe. Omomba'egwasu íxupe hikwái. Upéi oipe'a imba'e ryru-gwi. Omboete eterei-vy, ome'ẽ rei mitã-pe ouro hepy va'e. Ome'ẽ íxupe hyakwã porã va'e, incenso héry va'e. Ome'ẽ ave íxupe hyakwã porã va'e mirra héry va'e ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pyhare ogwahẽ ou-vy Nhandejáry rembigwái yváy gwigwa. He'i: —Aníke peho jevy mburuvixa róga-rupi, he'i hi'arandu va'e-pe. Ike-py omombe'u íxupe. Upéa-gwi oikupe'o pe'o oje'ói-vy hikwái gwe'ýi ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Oho rire oje'ói-vy upe hi'arandu va'e, pyhare ojehexa uka ou-vy Nhandejáry rembigwái yváy gwigwa. José oke jave, ojehexa uka íxupe: —Epu'ã katu, he'i, —eraha isy ndive mitã'i. Erokanhy heraha-vy mitã'i Egito yvy-py. Epyta ranhe upe-py eiko-vy. Xe ha'e ramo ae, ereju jevy va'erã, he'i íxupe. —Mburuvixa Herodes katu oheka uka-ta íxupe ojuka uka hagwã. Upéa-gwi epyta upe-py, he'i íxupe Nhandejáry rembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Upe-ma ramo opu'ã pyhare ogwerokanhy heroje'ói-vy. Ogweraha isy ndive mitã'i. Oho Egito yvy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Upe-py opyta mitã'i ndive. Herodes omano ra'arõ-vy opyta Egito-py. Yma ete Nhandejáry nhe'ẽ-py omombe'u va'ety remimoĩgwe kwatia-rehe he'i a-rami: “Ahenói-ma xe ra'y-pe Egito yvy-gwi ou hagwã” he'i upe Nhandejáry rembiporavo Cristo-rehe. Ipokatu voi Nhandejáry nhe'ẽ. Upéa-gwi yma gware he'i hagwe-rami, ãy oiko-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ha upéi katu ndouvéi-ma Herodes renda-py pe hi'arandu va'e. Oikupe'o-ma ra'e oho-vy íxupe. “Xe mbotavy rei ra'e” he'i ojéupe Herodes. Upéa ombopoxy eterei-ma íxupe, ojéupe nomombe'úiry-gwi. Upéa-gwi omondo Hesu oiko hagwe-py. Mitã'i gwive he'i ojuka ukapa hagwã. Belém tetã mygwa ijerekwe rehegwa ave he'i ojuka ukapa hagwã mitã kwimba'e-pe gwive. Mokõi ro'y ogwereko va'e, ne'írã omboty vyteri mokõi ro'y va'e-pe gwive he'i ojuka ukapa hagwã. Pe hi'arandu va'e omombe'u ha-rupi rei íxupe, he'i ojuka ukapa hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Yma Nhandejáry nhe'ẽ-py omombe'u va'ety Jeremias remimoĩgwe kwatia-rehe a-rami he'i: “Omemby ohapirõ va'e nhahendu-ma tetã héry va'e Ramá-py. Raquel remiarirõre voi upe va'e ohapirõ omemby kwéry. Ojahe'o ramo omemby kwéry-rehe nhahendu-ma voi. Ndoikovéi-magwi omemby nohenduséiry voi ombopy'agwapyharã mo'ã nhe'ẽ” he'i va'ekwe imemby ojejuka va'ekwe-rehe. Upéixa yma he'i hagwe-rami, ãy oiko-ma Belém tetã-my. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ha upéi katu omano Herodes. Omano rire, ojehexa uka jevy José-pe Nhandejáry rembigwái yváy gwigwa. Egito-py vyteri oime ramo, ikéra-py ojehexa uka jevy íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Omano-ma mitã-rehe ija'e'ỹ va'ekwe. Ãy ereraha jevy jepe arã upe-py. Ijukaseharãgwe omano-ma. Epu'ã katu, he'i —eraha jevy mitã isy ndive. Ereiko hagwe-py tereho jevy. Israel kwéry yvy-py tereho, he'i José-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Upe-ma ramo opu'ã oje'ói-vy. Mitã ogweraha isy ndive jevy gwetã-my. Israel kwéry yvy-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ha upéi katu: —Ãy Herodes ra'yre Arquelau oiko jevy mburuvixagwasu ramo Judéia yvy-py, he'i José-pe omombe'u-vy. Upéixa-gwi ikyhyje oho hagwã ta'yre manda ha-py. Pyhare ojehexa uka jevy íxupe ou-vy Nhandejáry rembigwái yváy pygwa. José oke jave, ojehexa uka íxupe: —Ani ereho teĩ upe-py, he'i íxupe. Upéixa-gwi ndohóiry oyvy-py. Galiléia yvy-py ae ha'e oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Upe-py oho opyta Nazaré tetã-my. Yma Nhandejáry nhe'ẽ-py omombe'u va'ety remimoĩgwe kwatia-rehe he'i a-rami: “He'i va'erã íxupe Nazaré pygwa” he'i upe Nhandejáry rembiporavo Cristo-rehe. Ipokatu voi Nhandejáry nhe'ẽ. Upéa-gwi yma he'i hagwe-rami, ãy oiko-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Upe ramo ojekwaa-ma ou-vy João Batista. Tekwaty e'ỹ-my Judéia yvy-py ojekwaa-ma Nhandejáry nhe'ẽ mombe'u-vy: ");
INSERT INTO kgkNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Onhemo'agwĩ-ma katu ou-vy Nhandejáry nhande ruvixarã. Pemboasy katu pene rembiapo vaikwe. Perova pende rekoha pemoirũ hagwã íxupe, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Upearã-rehe yma gware Nhandejáry nhe'ẽ-py omombe'u va'ety Isaías remimoĩgwe kwatia-rehe a-rami: “Oĩ tekwaty e'ỹ-my onhe'ẽ hatã va'e. Pemopotĩ katu Nhandejáry raperã. Pembohape karẽ e'ỹ katu íxupe. Penhemoatyrõ katu henonde, he'i onhe'ẽ hatã-vy” he'i João Batista rekorã mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ha'e camelo mymba ragwekwe-gwi onhemonde oiko-vy. Ha ixumbe katu vaka pire gwigwa. Ho'u tukúry-pe oiko-vy. Ei ka'agwy ho'u ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Upe jave ohopa oje'ói-vy henda-py Jerusalém tetã mygwa, Judéia yvy pygwa ave. Jordão ysyry jere rupigwa ave ohopa iha-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ogwahẽ ramo henda-py, peteĩ teĩ onhemombe'u João-pe gwembiapo vaikwe-rehe: “Amboasy-ma xe rembiapo vaikwe” peteĩ teĩ onhemombe'u ramo, omongarai-ma íxupe. Jordão ysyry-py oporomongarai oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ha upéi katu ogwahẽ ave ou-vy heta fariseu saduceu ndive. Onhemongarai ukase-vy ou íxupe hikwái. Ohexa ramo íxupe kwéry João he'i: —Mbói-rami peẽ pende reko mbói reko-rami, he'i íxupe João. —Kiva'e po nde-vy he'i erekanhy hagwã? Ndikatúi erekanhy nde rereko asyharã-gwi, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","—Ererova ramo nde rekoha, ehexa uka nde reko porãha. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Abraão amyrĩ nhande ru voi. Nhande kwéry hemiarirõre tee voi” ere rei erenhemboete ukase-vy. Ani joty ere upéa. Pehexa katu ko va'e ita. Ha'e-ta peẽ-my. Ko itakwe Nhandejáry omondo kwaa va'erã kente ramo. Hetave omondo kwaa va'erã Abraão remiarirõre ramo. Ndaheko rasýiry arã hemimondo ramo ita. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yva máta hi'a e'ỹ va'e oity va'erã. Hapy hagwã-pyma ogweraha va'erã. Oĩ-ma háxa ijypy-py ombogwái hagwã hapo-rupi. Upéixa ete ogwereko asy va'erã hekoha vai va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Xe, he'i —y-py mante apomongarai va'e penhemboasy-gwi pende rekoha vaikwe-rehe ojekwaa hagwã peẽ penhemboasyha pende rekoha vaikwe-rehe. Ha oĩ xe rapykwerigwa katu napene mongarai mo'ãi xe oromongaraiha-rami. Ha'e ombogwejy va'erã omoingo-vy pende py'apy-py Nhe'ẽ Marangatu tee va'e, he'i. —Tata-py ae pene mongarai va'erã omokanhy ngatu-vy pende reko tujakwe pendéhegwi. Tata-py imombopyrã jahapyha-rami ave, pende reko tujakwe oipe'a va'erã pendéhegwi. Pende aigwe ohapypa-ma va'erã. Ha'e ipu'akave va'e xéhegwi. Upéa-gwi, xe reko'ive íxugwi-gwi, xe ave atĩ íxugwi. Ni hembigwái ramo jepe ndikatúiry aiko. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yrupẽ-my nhamombo yvate-koty imboveve-vy. Upéi inhongatu haty-py nhamoĩ ha'ỹigwe. Ha ha'ỹi e'ỹ va'e pirekwe katu jahapy. Upéixa ete ha'e ogwahẽ-ma ou-vy oipe'a hagwã hekoha vai va'e-gwi hekoha porã va'e. Upe va'e ogweraha va'erã oha-py. Ha hekoha vai va'e katu ogwereko asy va'erã íxupe. Okái voi Nhandejáry rata. Ndoikói voi imbogweharã, he'i judeu ruvixa kwéry-pe João Batista imombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Upe ramo ogwahẽ ou-vy Hesu Galiléia yvy-gwi. Jordão ysyry-py ou. Ojéupe ave oipota omongarai. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ha João katu nomongaraiséi íxupe: —Iporãve katu xe mongarai nde voi. Nde, nde reko porãve xéhegwi, he'i íxupe João. —Nde reko porãve jepe, ma'erã ereju joty xe renda-py? Ma'erã erenhemongarai ukase joty xe-vy, he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—Ãy eheja katu tanhemongarai, he'i Hesu. —Upéixa iporã jajapo entéro Nhandejáry oipota va'e gwive, he'i João-pe. Ha João he'i: —Néi. Aipo ramo toromongarai, he'i Hesu-pe. Ha omongarai íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Onhemongarai rire-ma, osẽ y-gwi ou-vy. Upe-ma ramo ojekwaa pya'e yváy-py. Upe-gwi ha'e ohexa ogwejy va'e. Pykasu-rami ogwejy ou-vy Nhe'ẽ Marangatu tee va'e. Ójehe ogwejy ramo ohexa. ");
INSERT INTO kgkNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Upéi ohendu yváy-gwi onhe'ẽ va'e. He'i: —Kóa xe ra'y xe rembiayhu voi. Xe rembierohory porã ete va'e voi ko va'e, he'i yváy-gwi onhe'ẽ va'e Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ha upéi katu ogweraha Hesu-pe Nhe'ẽ Marangatu tee va'e. Tekwaty e'ỹ-my ogweraha íxupe. Anháy renda-py ogweraha íxupe anháy ruvixa otantea hagwã íxupe ombojejavy hagwã mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Quarenta áry, quarenta pyhare ave ohasa okaru e'ỹ reheve. Ha upe rire ae katu ivare'a-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Upe ramo ohekoteta-vy ou anháy ruvixa. Ombojejavyse mo'ã íxupe. Anháy he'i íxupe: —Nde ere ndéjehe, “Xe Nhandejáry ra'y voi”. Aipo ramo ere ko ita-pe eremondo hagwã íxupe mbojape ramo, he'i Hesu-pe anháy itantea-vy, ombojejavyse mo'ã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Hesu ae ndojapóiry joty inhe'ẽ. Nhandejáry nhe'ẽ ae joty omombe'u íxupe: —Ko'a-rami ae voi Nhandejáry nhe'ẽ oĩ va'e kwatia-rehe, he'i íxupe: —“Nhane rembi'ukwe-rehe anho rei ndaha'éi nhande rekoverã tee. Nhandejáry he'i va'e gwive ae nhande rekoverã tee” he'i Hesu, Nhandejáry kwatia nhe'ẽ omombe'u-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Upe rire anháy ruvixa ogweraha íxupe Jerusalém tetã marangatu-py. Nhandejáry róga kakwaa-py ogweraha íxupe. Upe-py ijyvateve va'e ári omonhembo'y íxupe. Anháy he'i íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—“Xe Nhandejáry ra'y voi” ere nde ndéjehe, he'i íxupe. —Aipo ramo, he'a katu a-gwi. Ko'a-rami ae oĩ Nhandejáry kwatia nhe'ẽ he'i anháy Hesu-pe ombojejavy ukase mo'ã-vy: —“Nhandejáry omonhangareko uka va'erã nde-rehe gwembigwái yváy pygwa-pe. Ipo-py nde joko va'erã pono ere'a-vy ererokwa hatã nde py ita-rehe” he'i Nhandejáry kwatia nhe'ẽ oiporu rei-vy. —Upéa-gwi he'a katu, he'i mo'ã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ha Hesu ae katu ndojapóiry joty inhe'ẽ. Nhandejáry nhe'ẽ ae joty omombe'u íxupe: —Ko'a-rami ave oĩ Nhandejáry kwatia nhe'ẽ, he'i ave íxupe Hesu omombe'u-vy. —“Ani katu eretantea teĩ Tupã nde Járy-pe imbojejavy ukase-vy mo'ã” he'i anháy ruvixa-pe Nhandejáry kwatia nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Upéi ogweraha jevy Hesu-pe yvyatygwasu ári. Upe-py ohexa uka íxupe entéro tetã tetã ko yvy-py oĩ va'e gwive. Mburuvixa vixa róga kakwaa ohexa uka íxupe. Ijapo porã porãpyre, heta iporãve rãve va'e ohexa uka íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ohexa ukapa rire he'i íxupe: —Entéro ne rembiexakwe gwive ame'ẽ arã nde-vy, he'i íxupe anháy. —Ne retypy'ã-rehe erenhesũ ranhe ramo xe mboete-vy, ame'ẽ arã nde-vy, he'i otantea-vy imbojejavy ukase-vy mo'ã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ha Hesu ae katu ndojapóiry inhe'ẽ. He'i joty íxupe: —Tereho katu, nde Satanás, he'i joty íxupe. —Ko'a-rami ae oĩ Nhandejáry kwatia nhe'ẽ, he'i ave íxupe Hesu: —“Pemomba'egwasu katu Tupã pende Járy-pe. Íxupe anho mante pehendu pemboete-vy” he'i anháy ruvixa-pe onhe'ẽ mbojevy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Upéa he'i rire anháy ruvixa oheja íxupe oho-vy. Ha Nhandejáry rembigwái yváy pygwa ogwahẽ ou-vy iha-py. Hemikotevẽ ogweru. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ha upéi katu João Batista onhemoĩ preso. Oherakwã rendu ramo, Hesu osẽ jevy oho-vy Galiléia yvy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gwetã Nazaré-py ndopytái. Ova oho-vy Cafarnaum tetã-my. Pe Cafarnaum Galiléia yugwarusu rembe'y-py. Zebulon yvy pygwa, Naftali yvy pygwa ave he'i yma gware. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Upe-py ova Hesu yma gware he'i hagwe-rami oiko hagwã ãy. Yma Nhandejáry nhe'ẽ-py omombe'u va'ety Isaías remimoĩgwe kwatia-rehe a-rami: ");
INSERT INTO kgkNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Oĩ Zebulon yvy pygwa, Naftali yvy pygwa ave. Oĩ yugwarusu rape-koty oĩ va'e, oĩ Jordão ysyry rovái pygwa, oĩ Galiléia yvy pygwa, judeu e'ỹ kwéry va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Upe va'e kwéry pytũ-my rei oiko va'e-rami oiko va'ekwe. Ãy katu hendy va'e-py ohexa porã va'e-rami oiko-ma va'erã hikwái. Gwĩ omano va'erã-rami, ohexa jokupe rei-ma va'e-rami oiko va'ekwe hikwái, ãy katu ohesape íxupe va'e-rami oiko va'erã hikwái” he'i Nhandejáry kwatia nhe'ẽ. Yma he'i hagwe-rami, ãy oiko-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cafarnaum tetã-my ova rire, onhepyrũ Hesu Nhandejáry nhe'ẽ omombe'u-vy: —Pene mo'agwĩ-ma ou-vy Nhandejáry pende ruvixarã. Upéa-gwi pemboasy peteĩ teĩ pene rembiapo vaikwe. Perova katu pende rekoha vaikwe, he'i omombe'u-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ha upéi katu Hesu ogwata oho-vy Galiléia yugwarusu yke-rehe. Ohexa oho-vy Simão-pe, héry va'e Pedro ave, tyvýry André ndive. Ohexa omombo ramo oity hagwã y-py kyha oipyhy hagwã pira. Pira jopoihaty voi ha'e kwéry: ");
INSERT INTO kgkNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Peju katu xe moirũ, he'i íxupe kwéry. —Nde katu pira jopói kwaahaty. Ãy ae orohekombo'e-ta xe moirũ uka hagwã gwĩ kente kwéry-pe, he'i ohenói-vy íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Upe-ma ramo pya'e oheja okyha. Omoirũ-ma oho-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ha upéi ohasave Hesu oho-vy gwenonde-koty. Ohexa oho-vy mokõi Zebedeu ra'y, Tiago tyvýry João ave. Gwu ndive omoatyrõ oiko-vy kanoagwasu-py kyha. Ohenói íxupe ojéupe omoirũ hagwã: —Peju katu xe moirũ, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Upe-ma ramo pya'e oheja okanóa gwu reheve. Oho hupive omoirũ-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ha upéi katu Hesu oho Galiléia tetã tetã-rupi. Ojeporahéi haty haty-rupi oporombo'e. Nhandejáry nhande ruvixarã rehegwa nhe'ẽ porã omombe'u mbe'u. Entéro mba'asy-gwi oporombogwera gwera oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Upe-ma ramo isarambi oho-vy herakwã. Síria tetã tetã-rupi oho herakwã. Upéixa-gwi ogweru íxupe opamba'e mba'asy rerekoha va'e gwive. Gwĩ hasy ete va'e, gwĩ anháy rerekoha, gwĩ he'o'ã'o'ã va'e, gwĩ hajy jeapa va'e ogweru ave íxupe. Entéro hasy va'e íxupe ojereru va'ekwe gwive, ombogwerapa joty ha'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Upe ramo heta ojogweroaty Hesu-rehe hikwái. Oĩ heta Galiléia yvy pygwa, oĩ heta Dez Cidades oje'eha tetã mygwa. Oĩ heta Jerusalém tetã mygwa, Judéia yvy pygwa ave. Oĩ heta Jordão ysyry rovái pygwa. Heta eta kente oho ijave oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ha upéi katu heta eterei ijaty va'e omoirũse Hesu-pe. Ha ha'e katu ohexa ramo íxupe kwéry, ipa'ũ-gwi ojeupi oho-vy. Ijavyte kwéry-gwi ojeupi oho-vy. Yvyaty ári-ma ojeupi oho-vy. Upe-py ogwahẽ ramo, ogwapy-ma yvyaturu-rehe. Ogwapy rire, omoirũ íxupe hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Upe ramo onhepyrũ-ma ohekombo'e porã-vy gwemimbo'e kwéry-pe. He'i omombe'u-vy íxupe kwéry: ");
INSERT INTO kgkNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Gwĩ, “Iporiahu va'e-rami ko yvy-py xe aiko” he'i ójehe va'e, gwĩ, “Xejéhegwi rei ndikatúiry xe aiko” he'i ójehe va'e, heko vy'a tee va'e. Nhandejáry nhande ruvixa ndive gwarã voi. Upéa-gwi ovy'a. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Gwĩ gwembiapokwe omboasy-vy hasẽ va'e, heko vy'a tee joty. Nhandejáry remimbopy'agwapyrã voi upéa. Upéa-gwi ovy'a. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Gwĩ ipoxy pya'e e'ỹ va'e, heko kirirĩ va'e, heko vy'a tee va'e. Ko yvy pygwa íxupe gwarã. Ko yvy imba'e teerã. Upéa-gwi ovy'a joty. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Gwĩ Nhandejáry remimbota gwive ojaposeve seve va'e, heko vy'a tee va'e. Ivare'a va'e-rami, ijuhéi va'e-rami ave oiko hemimbota ojapose eterei-gwi. Ojapo rire ovy'a va'erã. Onhembopy'ajeko tee va'e-rami ovy'a-ma va'erã oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Gwĩ gwapixa-pe oiporiahuvereko va'e, heko vy'a tee va'e. Oiporiahuvereko va'erã ave íxupe Nhandejáry. Upéa-gwi ovy'a. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Gwĩ hesakatu reheve ipy'a potĩ va'e, heko vy'a tee va'e. Ohexa va'erã Nhandejáry-pe. Upéa-gwi ovy'a. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Gwĩ gwapixa peteĩxa omoingo porã va'e, ombojoja va'e, heko vy'a tee va'e. “Xe ra'y voi, xe rajy voi” he'i va'erã hese Nhandejáry. Upéa-gwi ovy'a. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Gwĩ Nhandejáry remimbota ojapo-gwi ogwereko asy ramo jepe íxupe, heko vy'a tee joty. Nhandejáry nhande ruvixa ndive gwarã voi. Upéa-gwi ovy'a. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Ha peẽ ave xe moirũ-gwi onhe'ẽ rei rei va'erã pende-rehe. Pende rereko asy va'erã. Xe-rehe ndaija'éi-gwi opaixagwa ivai va'e omombe'u vai va'erã pende-rehe, ijapu va'erã pende-rehe. Upéixa pende rereko jave, pende reko vy'a tee voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pevy'a katu. Perovy'a joty katu pende-rehe hembiapo vai va'e. Yváy-py heta eterei ombohekovia va'erã peẽ-my ome'ẽ-vy Nhandejáry. Upéa-gwi pevy'a joty. Pende rerekoha-rami ave ogwereko asy va'ekwe myamyrĩ Nhandejáry nhe'ẽ-py omombe'u va'ety-pe. Yma gware-pe pene renonderã-rehe ogwereko asy hagwe-rami ave, ãy pende rereko asy ave va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Pejeapysaka katu juky rehegwa nhe'ẽ-rehe. Juky-rami peẽ peiko ko yvy-py. Pono ine so'o-rehe juky nhamoĩ va'e-rami, peẽ peiko ko yvy-py ani hagwã teko rei ivaive ive oho-vy. He porã juky ha ndahe porãvéi ramo, ndikatuvéi-ma nhamoatyrõ íxupe. Naiporãvéi-ma nhamoatyrõ hagwã. Nde eremombo-ma va'erã. Erepyrũ va'erã hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Yvypóry kwéry-pe pehesape va'e-rami ave peẽ peiko. Ojekwaa porã tetã yvyaty ári onhemoĩ va'ekwe. Ndikatúiry onhomi nhomi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ojekwaa porã ave tataendy. Nhamoendy ramo, ndajajaho'íry nha'ẽ gwy-py. Tataendy'y ári ae nhamoĩ. Upe ramo entéro óga pygwa-pe pe tataendy ohesapepa oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Upéixa ete ohesape va'e-rami, tojekwaa porã ne rembiapo porãkwe. Upéixa ramo nde rapixa kwéry ohexa va'erã ne rembiapo porã. Ohexa ramo, omomba'egwasu va'erã nde Ru yváy pygwa-pe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Upéi he'i jevy Hesu: —Ani ere teĩ: “Ogwahẽ-ma ou-vy Hesu ohekoviarõ hagwã Moisés amyrĩ remimombe'ukwe tekoha” ani ere teĩ. “Ou-ma ohekoviarõ hagwã Nhandejáry nhe'ẽ-py omombe'u va'ety amyrĩ remimombe'ukwe tekoha” ani ere teĩ. Agwahẽ-ma ae aju-vy ipokatu hagwã upe Nhandejáry remimo'arandukwe nhe'ẽ oiko hagwã he'i hagwe-rupi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Upéi he'i ave: —Pejeapysaka katu xe nhe'ẽ-rehe. Anhetegwa va'e amombe'u-ta peẽ-my. Ko yvy áry ndive oiko jave, nonhemohekoviarõ mo'ãi va'erã Moisés amyrĩ remimombe'ukwe nhe'ẽ. Nomokanhy mo'ãi ni peteĩ ojehai va'ekwe. Ni peteĩ ndyky jaiporu va'e kwatia nhamonhe'ẽ porã hagwã nomokanhýi va'erã. He'i hagwe-rami oikopa peve nonhemohekoviarõ mo'ãi va'erã Nhandejáry kwatia nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Upéa-gwi oĩ ramo Nhandejáry kwatia nhe'ẽ ohendu rire mixĩ eterei va'e nohendusevéi va'e. Upéi ohendu e'ỹ uka hagwã ombo'e gwapixa-pe. Upe va'e apohare-pe nomomba'egwasúi arã voi Nhandejáry oiko ha-rupi nhande ruvixarã. Ombohekomixĩve va'erã ae voi íxupe. Ha Nhandejáry kwatia nhe'ẽ apoha, “Pehendu katu Nhandejáry kwatia nhe'ẽ Moisés amyrĩ remimombe'ukwe” he'i ae va'erã gwapixa-pe, omomba'egwasu va'erã íxupe Nhandejáry oiko ha-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ha gwĩ judeu rekombo'ehaty kwéry, fariseu kwéry ndive ojapose mo'ã Nhandejáry remimbota gwive ogwahẽ hagwã mo'ã oho-vy nhande ruvixa ramo Nhandejáry oiko haty-py. “Heta nhane rembiapo porã porã” he'i ójehe kwéry. “Upéa-gwi nhagwahẽ va'erã jaha-vy Nhandejáry oiko haty-py” he'i mo'ã ójehe kwéry. Ha nogwahẽ mo'ãi voi. Ha'e kwéry heko-rupi peiko ramo, napemoirũ mo'ãi Nhandejáry pene ruvixarã-pe. Nhandejáry remimbota gwive pehenduseve seve ramo ae, pemoirũ va'erã íxupe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Upe rire katu he'i jevy Hesu: —“Ani ereporojuka teĩ” he'i araka'e yma gware-pe. “Oporojuka va'ekwe-pe ogweraha va'erã mburuvixa rovagwy-py oporandu hagwã íxupe hembiapokwe-rehe” he'i araka'e yma gware-pe. Upéa pehendu-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ãy xe ae katu nde rekoha porãve hagwã amombe'u-ta peẽ-my. Gwe'ýi-rehe ipoxy rei va'e-pe gwive ogweraha va'erã mburuvixa renda-py ogwereko hagwã íxupe hembiapokwe-rami. Gwe'ýi-rehe onhe'ẽ rei va'e-pe ogweraha va'erã mburuvixa kwéry ojogweroaty haty-py omoporandu uka hagwã hembiapokwe-rehe íxupe. Ha, “Nde tavy. Ne arandu e'ỹ va'e” he'i va'e gwive gwapixa-pe katu, ojereraha va'erã tata opa rei rei e'ỹ va'e-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Upéixa ramo ereho ramo Nhandejáry róga-py ne remime'ẽrã ereme'ẽ-ma hagwã íxupe Nhandejáry apyka nhamboete haty-py, upe-py nde re'ýi nde-rehe ija'e'ỹha-rehe ne mandu'a ramo, ani ereme'ẽ ranhe teĩ Nhandejáry-pe ne remime'ẽrã. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Eheja rei katu Nhandejáry apyka renonde-py. Tereho ranhe katu nde rapixa ha-py erehekombojoja ranhe hagwã íxupe peteĩxa ereiko hagwã. Ha upe rire katu eju jevy Nhandejáry ha-py ne remime'ẽrã ereme'ẽ hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Embojoja mani katu nde-rehe ija'e'ỹha-pe peho jave mburuvixa ha-py. Ne'írã vyteri eregwahẽ jave, embojoja ranhe katu ne nhe'ẽ nde rapixa ndive erembovy'a jevy hagwã íxupe. Nerembojojái ramo íxupe, ne me'ẽ arã mburuvixa po-py. Upéi mburuvixa ne me'ẽ va'erã polícia po-py. Upéi nde reja va'erã preso. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Anhetegwa amombe'u-ta peẽ-my. Preso erepyta rire, ndopoi rei mo'ãi ndéhegwi. Nane mosẽ mo'ãi. Ndereve reveha gwive ne mbopaga uka va'erã. Erepagapa rire mante, ne mosẽ va'erã, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Upéi he'i jevy Hesu: —“Ani erenhomongy'a teĩ nde rapixa rembireko ndive, nde rapixa ména ndive ereiko-vy” he'i araka'e yma gware-pe. Upéa pehendu-ma. Ha ãy katu xe ae nde rekoha porãve hagwã amombe'u-ta peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","—Gwĩ opy'apy-py imandu'a gwapixa rembireko-rehe oikose-gwi indive va'e, hendive ndoikói vyteri ramo jepe, ojejavy joty. Gwesa-rupi joty ogwereko gwapixa rembireko. Omongy'a-ma va'e-rami, ojapo vai-ma hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","—Upéixa ramo nde resa nde akatúa-koty oĩ va'e-gwi erejejavy-ta ramo, ejejoko joty ne rembiapo vairãgwe-gwi. Enohẽ katu peteĩ nde resakwe emombo ndejéhegwi nde resakwe, peteĩ hesa pehẽ va'e-rami ereiko hagwã. Nde resa mokõi reheve nde reraha ramo tata ijapy e'ỹ va'e renda-py, ivai eterei va'erã nde-vy. Iporãve erenohẽ eremombo peteĩ nde resakwe ndejéhegwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—Ha nde po nde akatúa-koty oĩ va'e-gwi erejejavy-ta ramo, ejejoko ae katu ne rembiapo vairãgwe-gwi. Ejahya ae katu upe nde po emombo ndejéhegwi. Peteĩ ipo va'e rekoha-rami ae katu eiko. Mokõi nde po reheve nde reraha ramo tata ijapy e'ỹ va'e renda-py, ivai eterei arã. Iporãve erejahya peteĩ nde po ndéhegwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—“Gwembireko-gwi opoise va'e gwive, tojapo kwatia ome'ẽ hagwã gwembireko-pe, Apoi-ta ndéhegwi, he'i-vy va'e tome'ẽ íxupe” upéa he'i ave araka'e yma gware. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ha ãy katu xe ae nde rekoha porãve hagwã amombe'u-ta peẽ-my. Gwembireko-gwi opoi va'e ojapo vai hese. Upéi hembirekokwe omenda jevy ramo, onhemongy'a-ma va'erã. Ha Nhandejáry katu omoingo asy va'erã imenakwe-pe, omenda amboaese jevy-gwi oheja rei gwembireko hagwe-rehe. Ha kunha hejapyre-rehe omenda jevy va'e katu, onhemongy'a va'erã ha'e-rami ave. Ha kwimba'e ambue ndive ojohu va'e gwembireko katu, opoi ramo gwembireko-gwi, ndojapo vaíry hese, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Upéi he'i jevy Hesu: —“Ani erejapo e'ỹ teĩ ne nhe'ẽ. Xe apu ramo xe rendu va'erã Nhandejáry, ere ramo, ejapo katu ne nhe'ẽ” he'i araka'e yma gware-pe. Upéa ave pehendu-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","—Ãy ae katu nde rekoha porãve hagwã amombe'u-ta peẽ-my. “Nanhe'ẽ rei mo'ãi, ajapo-ta voi” ere ramo, ani ereiporu teĩ imba'e réry rei ererovia uka hagwã ne renduharã-pe ne nhe'ẽ. Ani ereiporu yváy réry. Upe-py Nhandejáry ogwapy haty. Nde ae ne nhe'ẽ eiporu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ani ereiporu teĩ yvy réry. Upe-py Nhandejáry opyrũ haty. Ani ereiporu teĩ Jerusalém tetã réry. Upe-py oiko Nhandejáry nhande ruvixagwasu. Nde ae ne nhe'ẽ eiporu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ani ereiporu teĩ ne akã réry ererovia uka hagwã ne renduharã-pe ne nhe'ẽ. Nhandejáry mba'e ne akã. Nde ávy peteĩ va'e neremomorotĩ kwaái, neremohũ kwaái ave. Nde ae ne nhe'ẽ eiporu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Erenhomongeta ramo, erejapose va'erã-rehe. “Ajapo-ta” ere. Ha nderejaposéi va'erã-rehe, “Ndajapo mo'ãi” ere ave. Imba'e réry rei ani ereiporu teĩ. Imba'e réry rei ereiporu ramo, nde rekombo'e ra'e anhaygwasu. Anhaygwasu rape-rupi ereiko ra'e, he'i Hesu gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Upéi he'i jevy Hesu gwemimbo'e kwéry-pe: —“Iporã erejepy” he'i araka'e yma gware-pe. “Nde resa ombyai ramo nde rapixa, embyai katu hesa hekovia. Ne rãi omopẽ ramo nde rapixa, emopẽ katu hãi hekovia. Nde-rehe ojapo hagwe-ramima nde rapixa ejapo ave hese” he'i araka'e nhande rekorã omombe'u-vy araka'e. Upéa pehendu-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","—Ãy ae katu iporãve amombe'u-ta peẽ-my. Aníke upéixa erejapo teĩ. Nde rapixa nde-rehe ojapose va'e ojapo ramo, ani joty kuri erejepy teĩ hese. Nde rovapete ramo jepe nde akatúa-gwi, ani joty kuri erejepy teĩ hese. Nde rovapete ramo jepe, ejerova rova joty íxupe. Eme'ẽ joty íxupe nde rova asu nde rovapete jevy hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nde reraha ramo mburuvixa renonde-py oipe'a hagwã ndéhegwi ne kamisa, eme'ẽ íxupe togweraha ne kamisa nde ao jo'a ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Eraha katu areko va'e peteĩ quilômetro” he'i ramo nde-vy peteĩ soldado omanda-vy, ejapo katu inhe'ẽ. Ejapove joty inhe'ẽ. Eraha joty katu ogwereko va'e mokõi quilômetro. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Gwĩ oikotevẽ va'e ojerure ramo nde-vy, eme'ẽ katu íxupe. Ne mba'e oiporuse va'e-pe eiporuruka joty ave íxupe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Upéi he'i jevy Hesu: —“Ehayhu katu nde re'ýi-pe ha nde-rehe ija'e'ỹ va'e-pe ani ave erehayhu teĩ” he'i araka'e yma gware-pe. Upéa pehendu-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","—Ãy ae katu nde rekoha porãve hagwã amombe'u-ta peẽ-my. Nde-rehe ija'e'ỹ va'e jepe, ehayhu joty íxupe. Nde rereko asy va'e-rehe, ejapo joty oração. Embojeupi joty katu ne nhe'ẽ Nhandejáry-pe hese kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Upéixa Nhandejáry rekoha. Upéixa ereiko va'erã nde Ru yváy pygwa ra'y tee ramo. Nhande resape uka va'e peteĩxa nhande rereko. Hekoha vai va'e-pe hekoha porã va'e-pe ave omosẽ kwarahy omoendy-vy peteĩxa Nhandejáry. Hembiapo porã va'e-pe hembiapo vai va'e-pe ave omongy peteĩxa. Enterove va'e-pe ohayhu-gwi ojapo upéixa. Pende Ru yváy-py oĩ va'e ojapoha-rami ave, peẽ pejapo katu. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Nde rayhu va'e-pe anho erehayhu ramo, “Hekoha porã eterei” nde'i mo'ãiry nde-rehe Nhandejáry. Nde reko-ramima ave oiko gwĩ plata-py nhane mbopaga va'ety, hese imandu'a vai va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nde re'ýi anho ererovy'a ramo, “Hembiapo porã eterei” nde'íry va'erã nde-rehe Nhandejáry. “Xe rekoha porã” ere rei arã ndéjehe. Nde reko-ramima ave oiko va'erã judeu e'ỹ va'e Nhandejáry kwaa e'ỹha, gwe'ýi anho ogwerovy'a-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","—Peiko ae katu Pende Ru yváy pygwa reko-rupi. Ha'e hekoha porã tee rei voi heko jejavy e'ỹ reheve. Ha'e-ramima peiko meme katu, he'i Hesu gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Hesu he'i jevy gwemimbo'e kwéry-pe: —Xáke, enhangareko porã katu ndéjehe, he'i. —Ne rembiapo porã ramo, ani erejapo teĩ enterove va'e resa-py erejehexa uka porãse-vy imandu'a porã hagwã mo'ã nde-rehe. Upéixa ereiko ramo, “Hekoha porã upe va'e. Íxupe gwarã ame'ẽ-ta” nde'i mo'ãi arã voi nde-rehe Nhandejáry pende Ru yváy pygwa. Nde rekoha oikwaa voi. Ani erejapo teĩ upéixa. Ndaipotái upéixa erenhemboete ukase ereiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Iporiahu va'e-pe ereme'ẽse ramo, ani ereiko gwĩ gweko-gwi rei enterove resa-py ojehexa uka porãse va'e reko-rupi, opy'a ky'aha omo'ã kwaa va'e reko-rupi. Atýra-py ojeporahéi haty-py omonhe'ẽ gwemimbygwasu, enterove imandu'a porã hagwã mo'ã hese. Tape-rupi ombopu onhemboete ukase-vy mo'ã. Anhetegwa va'e amombe'u-ta peẽ-my. Hexaháry-pe onhemboete uka rire, mba'eve nome'ẽ mo'ãvéi-ma íxupe Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Iporiahu va'e-pe ereme'ẽse ramo ae, eme'ẽ nhemi íxupe. Tojekwaa e'ỹ ne remime'ẽ. Toikwaa e'ỹ jepe nde po asu va'e nde po akatúa va'e rembiapo. Toikwaa e'ỹ nde reko irũ kwéry ne remime'ẽ. Upéixa nde Ru yváy pygwa ombohekovia va'erã nde-vy ome'ẽ-vy. Ndaipóri íxugwi okanhy va'e. Okanhy va'erãgwe jepe ae ojohu joty Nhandejáry, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Upéi he'i jevy Hesu: —Gwĩ nombojekwaái joty va'e opy'a ky'aha, ojehexa uka porãse-vy rei ojapo va'e mo'ã oração, onhembo'yse oração apo-vy. Ojeporahéi haty-py ojapo oração imandu'a porã hagwã mo'ã hese. Ojéhegwi rei ojapo mo'ã oração enterove resa-py. Onhemboete ukase-vy rei ae onhembo'yse tape kurusu-py. Anhetegwa va'e amombe'u-ta peẽ-my. Ojekwaa porã rire, mba'eve íxupe nombohekovia mo'ãvéi-ma Nhandejáry. Ani peiko teĩ ha'e kwéry heko-rami, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","—Oração erejapo jave ae, eike katu koty-py. Ne rokẽ emboty ndejeheve. Upéi ne anho ha-py embojeupi ne nhe'ẽ nde Ru jahexa e'ỹ va'e-pe. Ha upe rire katu nde Ru yváy pygwa ne anho ha-py erejapo va'e rexa-vy, nde rovasa porã va'erã ombohekovia-vy nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Gwĩ judeu e'ỹ va'e Nhandejáry kwaa e'ỹha onhembo'e mbo'e rei. Heta nhe'ẽ oiporu rei va'e omondo rei onhe'ẽ Nhandejáry-pe. “Xe nhe'ẽ puku ramo, anhe'ẽ porã-ma” he'i mo'ã ójehe. “Heta-gwi xe nhe'ẽ, ohendu-ta xe nhe'ẽ Nhandejáry” he'i mo'ã ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ani peiko teĩ ha'e kwéry heko-rami. Erejerure e'ỹ reheve ne remikotevẽ oikwaa-ma Nhandejáry nhande Ru. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Oração erejapo ramo, a-rami ae kuri ere: Ore Ru yváy-py ereime va'e. Opa-rupi tomboete nde réry marangatu va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ejehexa uka uka katu yvy pygwa-pe huvixarã. Ne remimbota yváy pygwa ojapoha-rami, tojapo yvy pygwa ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ãy eme'ẽ ore-vy ore remi'urã ãy gwarã. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ore poriahuvereko katu orojejavy rire. Ore rapixa-pe ore-rehe ojejavy rire oroiporiahuverekoha-rami, ore poriahuvereko katu ore-vy ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ani teĩ ereheja ore rekombo'e vai anháy. Ore resende ae katu íxugwi. Nde ae ko mburuvixa teeve voi. Nde pu'aka porãve va'e voi nde. Tane momba'egwasu enterove va'e opa e'ỹ reheve. Amém. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Ha'e-ta peẽ-my. Nde-rehe ojejavy rire nde rapixa-pe ereiporiahuvereko ramo, nde-vy ave nde poriahuvereko va'erã nde Ru yváy pygwa. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ha nde rapixa-pe ndereiporiahuverekói ramo katu, nde-vy ave nande poriahuvereko mo'ãi va'erã nde Ru yváy pygwa, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Upéi he'i jevy Hesu: —Gwĩ opy'a ky'aha omo'ã kwaa va'e gweko-rehe rei onhemboete ukase va'e, okaru e'ỹ reheve ohasa mo'ã Nhandejáry mboete-vy. Upéixa ojapo ramo, hova asy oiko-vy ovy'are'ỹ va'e-rami. Ndojehovahéiry. Ndojekyvu porãi ave ojehexa uka porã hagwã okaru e'ỹha onhemboete ukase-vy rei. Oipota enterove omanha hese. Anhetegwa va'e amombe'u-ta peẽ-my. Onhemboete rire, nombohekovia mo'ãi va'erã íxupe ome'ẽ-vy Nhandejáry. Ani peiko teĩ ha'e kwéry heko-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ha peẽ katu Nhandejáry mboete-vy pekaru e'ỹ reheve pehasa ramo, pejekyvu porã katu. Pejehovahéi katu. Upéixa pende rapixa-pe ndojekwaái va'erã pekaru e'ỹha. Ha Nhandejáry ha'e anho mante oikwaa va'erã pekaru e'ỹha. Ndaipóri íxugwi okanhy va'e. Ne rembiapo nhemi oikwaa ramo, ombohekovia va'erã nde-vy ome'ẽ-vy ne rembiapo porãgwe-rehe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Upéi he'i jevy Hesu: —Ani erenhongatu rei teĩ ko yvy-rehe ne mba'e kwéry. Onhembotapurupa arã nde ao. Onhembyaipa arã ne mba'e. Ombokwa arã nde róga-rehe imonda va'e oike hagwã nde koty-py. Ndaha'éi yváy pygwarã ko yvy pygwa va'e. Nhane rembiejarã meme voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nhandejáry reminhongatu yváy-py peẽ-my gwarã-rehe ae katu pepena peiko-vy ko yvy-py. Yváy-py onhongatu va'e-rami peiko katu ko yvy-py. Upe-py ndaipóri nhande ao ombotapuru rei va'erã. Ndaipóri nhane mba'e ombyai rei va'erã. Upe-py ndaipóri nhande róga-rehe ombokwa mbokwaharã nhande koty-py oike-vy omonda va'erã nhandéhegwi nhane reminhongatu va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nhane rakate'ỹha-ma nhane renonde-py nhamoĩ meme jaiko-vy. Upéa-gwi ani erenhongatu rei teĩ ko yvy-rehe ne mba'e kwéry. Hese anho ereity arã nde resa ereiko-vy. Epena ae katu nde reko porãrã yváy pygwarã-rehe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Upéi he'i jevy Hesu: —Ha nhande resa reheve katu ohexa va'e-rami oiko nhande rete. Jahexa porã ramo, ohexa vérami ave nhande rete. Hembipepa íxupe va'e-rami oiko. Upéixa nde rekoha porã tee ramo, arakatu pygwa vérami ereiko va'e, erejehesa rerova uka-vy Nhandejáry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ha naiporãi ramo nhande resa katu hesa e'ỹ va'e-rami oiko nhande rete. Ndohexa uka porãi ramo nhande-vy, pytũ-my oiko ave nhande rete. Upéixa voi nde rekoha vai ramo, pytũ-my vérami ereiko va'e, erejehesa rerova uka e'ỹ-vy Nhandejáry-rehe. Ipytũmba rei voi nde-vy. Ndahapéi voi nde-vy, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Upéi he'i jevy Hesu: —Avave ndikatúi ojáry mokõi va'e nhe'ẽ-py omba'apo. Oĩ ramo nhande-rehe mokõi omanda va'e, peteĩ va'e-rehe nanhande a'éi va'erã. Outro-pe jahayhu va'erã. Peteĩ va'e-rehe nhane rakate'ỹ va'erã. Ha outro-pe ndajahexaséi va'erã. Upéa-gwi naiporãi nhane rakate'ỹ eterei plata-rehe. Erembotuvixave ramo plata, ipu'aka va'erã nde-rehe. Nerepenái va'erã Nhandejáry-rehe. Nde kupe-py oĩ va'e-rami erereko va'erã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Upéa-gwi ha'e-ta peẽ-my. Aníke erepena pena anho rei ere'u va'erã-rehe ereikove hagwã. Nde aorã-rehe eremonde va'erã-rehe, gwĩa-rehe ani erepena eterei teĩ. Nhane remi'urã anho rei-rehe naiporãi jaiko. Nhande rete pegwarã anho voi nhande ao, nhane remi'urã ave. Naiporãi nhapena upe va'e anho-rehe jaiko-vy. Upe va'e anho-rehe ndikatúi nhapena jaiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pehexa katu gwyra reko. Onhemitỹ e'ỹ ramo jepe, koty-py onhongatu hagwã heraha-vy oikytĩ e'ỹ ramo jepe, omongaru joty íxupe nde Ru yváy pygwa. Ha gwyra kwéry natuvixamba'e etéiry Nhandejáry-pe. Ha peẽ katu pende tuvixave íxupe gwyra kwéry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ani erepena eterei teĩ ndéjehe. Ereiko pukuseve mo'ã-gwi rei, ndereiko pukuve mo'ãiry. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Nde aorã orã-rehe ani erepena eterei teĩ ereiko-vy. Pehexa katu yvoty reko. Nomba'apói opotyrã-rehe. Oipogwã va'e-rami ndoikóiry. Nomba'apói ramo jepe, opyta porã ete voi joty. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yma oiko va'ekwe myamyrĩ mburuvixa Salomão. Imba'e reta va'ekwe. Ijao porã ave va'ekwe. Upe va'e-rehe onhemomba'egwasu ete va'ekwe. Ha ha'e-ta peẽ-my. Xe ae katu amboeteve upéa yvoty-pe. Ha'e ijehexaha-rami e'ỹ jepe, iporãve joty katu íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ha Nhandejáry katu ombopoty porã kapi'i. Etería henhói porã. Ko'ẽ ramo oikytĩ-ma arã, omombo va'erã tata-py ohapy-vy. Pe kapi'i Nhandejáry remimbopoty voi. Onhangareko porã hese-gwi, ipoty porã voi. Ha pende-rehe katu onhangareko porãve. Ne monde uka va'erã. Ma'erã ndapejeroviái hese? Hese anho ae pejerovia katu. Ome'ẽ va'erã nde-vy nde aorã. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Upéa-gwi ani erepena ndéjehe. “Mbava'e tipo ja'u va'erã? Mbava'e tipo jay'u va'erã? Mbava'e-py tipo nhanhemonde va'erã?” ani ere teĩ upéixa. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Upeixagwa-rehe opena pena oiko-vy judeu e'ỹ va'e Nhandejáry kwaa e'ỹha. Ha nde Ru yváy pygwa katu ne remikotevẽ gwive oikwaa va'e. Upéa rehegwa ereikotevẽ va'e-rehe ha'e oikwaa voi. Upéa-gwi ani erepena pena teĩ hese ereiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pepena ranhe ae katu Nhandejáry pende ruvixarã-rehe. Pemoĩ meme pene renonde-py ha'e ae hemimbota erejapo hagwã. Hese anho mante epena eiko-vy. Upéi upéa rehegwa gwive ne remikotevẽ va'e ome'ẽ rei va'erã nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ani pepena teĩ ko'ẽ ramogwarã-rehe. Pono pene mytu'e'ỹ pendéjehe ani pepena teĩ ko'ẽ ramo ojehu-ta va'e-rehe, gwĩ ivai-ta va'e-rehe. Ko'ẽ ramo ae pepena kuri hese, he'i Hesu gwemimbo'e kwéry-pe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Hesu he'i jevy gwemimbo'e kwéry-pe: —Ani nde rapixa rembiapo-rehe, “Ivai” ere teĩ erepondera-vy. Ne rembiapo ojohu vai ave arã nde-rehe Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","—Upe erejavaeterekoha-rami ave, “Ivai” he'i arã nde-rehe Nhandejáry. Nde rapixa ererekoha-rami nde ave nde rereko va'erã Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—Ãy amombe'u-ta pene rekorã-rehe. Yvyra ra'ykwe rehegwa nhe'ẽ-rami aiporu-ta peẽ-my imombe'u-vy. “Oĩ ra'e nde resa-py yvyra ra'ykwe” ere teĩ nde rapixa-pe. Ha nde ave tuvixave nde resa-py oĩ va'e. Heko porã va'e-rami ereikose mo'ã nde rapixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Upéixa ramo ma'erã ere teĩ nde rapixa-pe: “Taipe'a nde resa-gwi pe yvyra ra'ykwe mixĩ oĩ va'e”. Nde ave tuvixave nde resa-py oĩ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nde, “Ndaxe py'a ky'ái”, ere mo'ã ndéjehe. Nde nde rekoha vai-ma. Erova ranhe katu nde rekoha. Eipe'a ranhe katu ndejéhegwi pe yvyra tuvixave va'e nde resa-py oĩ va'e. Upéi erehexa porã arã ereipe'a hagwã nde rapixa resa-gwi upe yvyra ra'ykwe mixĩ oĩ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ani ereme'ẽ teĩ jagwa-pe imarangatu porã va'e” ja'e. “Ojere arã nde su'u-vy.” “Ani eremombo kure rovagwy-py ne mba'e porã hepy va'e. Opyrũ rei arã hese omongy'apa-vy” ja'e. Nde rapixa ne nhe'ẽ porã ombojevy va'e, ndaha'éi ne nhe'ẽ porã íxupe gwarã. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Ejerure rure katu Nhandejáry-pe. Ha ne rembijerure katu ome'ẽ va'erã nde-vy. Eheka heka katu ndejéupe gwarã. Ha ne rembieka katu erejohu va'erã. Okẽ onhemboty va'e oipe'a uka hagwã ombota mbota va'e-rami, pene kyre'ỹ katu pejapo hagwã oração. Nde-vy oipe'a-ma va'e-rami okẽ, ohendu va'erã Nhandejáry pene nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gwĩ ojerure rure va'e-pe gwive ome'ẽ va'erã. Gwĩ oheka heka va'e gwive ojohu va'erã. Gwĩ ombota mbota va'e-rami oha'arõ oĩ-vy va'e-pe gwive ojepe'a va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ta'ýry gwemi'urã-rehe ojerure ramo, ndaipóri pene pa'ũ-my ita ome'ẽ va'erã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ta'ýry pira-rehe ojerure ramo, ndaipóri pene pa'ũ-my mbói ome'ẽ va'erã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Peẽ kwéry pende rekoha vai ramo jepe, peme'ẽ kwaa joty iporã porã va'e pende ra'y kwéry-pe. Ha pende Ru yváy pygwa katu hekoha porã tee va'e. Upéa-gwi ome'ẽ kwaa porãve voi pejerure va'e-pe gwive iporã porã tee va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ha nhande kwéry katu jaipota nhande rapixa ojapo porã nhande-rehe. Aipo ramo, nde hese ave ejapo porã. Peteĩxa pejapo porã ojóehe, he'i. —Tuvixa mba'eve ko va'e nhe'ẽ. Ko va'e nhe'ẽ-py anohẽ kuri peẽ-my judeu rekoharã Moisés amyrĩ remimombe'ukwe gwive, Nhandejáry nhe'ẽ-py omombe'u va'ekwe gwive ave. Peteĩ nhe'ẽ-py amombe'upa kuri peẽ-my, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Upéi Hesu he'i jevy: —Tapeho katu tape porã-rupi. Upe tape ypyrũha tape po'i voi. Upe-rupi tapeho katu. Ani peho teĩ tape vai-rupi. Upe tapegwasu mombyry nhande rerahaha voi Nhandejáry-gwi. Tapegwasu nhepyrũha tuvixa oĩ va'e. Ndahekorasýi jaha hagwã upe tapegwasu-rupi. Heta oho tapegwasu-rupi va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ha ndaupéixairy tape Nhandejáry ha-py oho va'e. Upe tape ypyrũha tape po'i voi. Hasy-py nhagwahẽ va'erã upe tape-rupi Nhandejáry ha-py. Ha upe tape-rupi ogwata va'e ndahetáiry, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Upéi Hesu he'i jevy: —Oĩ, “Nhandejáry nhe'ẽ-py amombe'u” he'i va'e mo'ã ójehe. Xáke. Ani penhembotavy uka íxupe. Ojehexa uka porã va'erã ogwahẽ ou-vy pende ha-py. Ou va'erã ovexa-rami. Ipoxy e'ỹ va'e-rami ou va'erã ojehexa uka-vy. Ha opy'apy-py kwéry katu ipoxy. Heko poxy va'e-rami, jagwarete ivare'a va'e-rami voi ipoxy opy'a-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pehexa kwaa va'erã hembiapo-rehe. Nhuatĩ-gwi ndikatúi jaipo'o hi'a uva. Karapíxu-gwi ndikatúi jaipo'o figo aju. Ndaha'éi figo aju-rami karapixu'a. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hi'a porã yvyra porã. Ha ndahi'a porãi yvyra vai. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ndoikói yvyra porã hi'a porã e'ỹ va'e. Ha yvyra vai hi'a porã va'e ndoikói ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Entéro yvyra ndahi'a porãi va'e gwive oity va'erã. Tata ári imombopyrã. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Upéixa yvyra'a-rami pehexa kwaa va'erã hekoha-rehe. “Nhandejáry nhe'ẽ-py oromombe'u” he'i ramo mo'ã, hembiapo-rehe pehexa kwaa va'erã, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Upéi Hesu he'i jevy: —Heta oĩ, “Nde xe Járy, nde xe Járy” he'i rei va'erã xe-vy. Upéa nomoirũi va'erã oho-vy Nhandejáry nhande ruvixa-pe. Nogwahẽi va'erã oho-vy oiko haty-py. Ha xe Ru yváy pygwa remimbota ojapo va'e ae katu omoirũ va'erã íxupe oho-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","—Upe áry-py, enterove va'e-pe hembiapo apokwe-rami areko hagwã áry-py, heta, “Nde xe Járy, nde xe Járy” he'i rei va'erã xe-vy. “Nde réry-py Nhandejáry nhe'ẽ oromombe'u va'ekwe. Nde réry-py oromosẽ mosẽ oromondo-vy anháy-pe. Nde réry-py heta hexapyrã-rupi ore rembiapo porã va'ekwe. Heta ipu'aka va'e orojapo va'ekwe” he'i va'erã mo'ã xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ha upe rire katu “Hesu réry-py xe rembiapo. Ãy ae Hesu re'ýi tee-ma voi xe” he'i ójehe mo'ã va'e-pe xe Hesu ha'e va'erã íxupe kwéry: Yma gwive ko'ánga ete peve peẽ ndaha'éi xe re'ýi. Ndoroikwaái voi. Xe re'ýi e'ỹ voi peẽ, xe ha'e va'erã íxupe kwéry. Pende rekoha vai. Tapeho jevy katu xéhegwi, ha'e va'erã íxupe kwéry, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Upéi Hesu he'i jevy: —Ko'ã va'e xe nhe'ẽ renduha, xe nhe'ẽ apoha hi'arandu porã voi. Ha hi'arandu va'e katu gwogarã ojapose ramo, ita ári omoĩ. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ojapopa rire, oky-ma. Oky-gwi y hygwasu ojaho'ipa hagwã óga. Ou ave yvytugwasu heity hagwã mo'ã ha ndo'áiry. Ita ári ojapo ra'e. Upéa-gwi ndo'áiry. Upéixa ete xe nhe'ẽ ojapo va'e oho porã voi ojeity ukase e'ỹ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ha ko'ã va'e xe nhe'ẽ renduse e'ỹ va'e xe nhe'ẽ ojapo e'ỹ va'e katu nahi'arandu porãi. Ha hi'arandu e'ỹ va'e katu gwogarã ojapose ramo, nomoĩry ita ári. Yvy ku'i ári rei omoĩ gwóga. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Upéi oky-ma. Oky-gwi ovu y óga ojaho'ipa hagwã. Ou yvytugwasu oity hagwã ave óga-pe. Ha upe rire katu ho'a. Ho'apa ete voi hóga. Ho'a e'ỹ va'ekwe ndopytáiry. Omboasy eterei ho'a va'ekwe hóga. Upéixa ete ojeity uka-vy oho vai hi'arandu e'ỹ va'e, xe nhe'ẽ renduse e'ỹha, he'i Hesu Nhandejáry nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Omombe'upa rire, heta ojogweroaty aty va'e ogwerovy'a inhe'ẽ omboete-vy íxupe hikwái: —Iporã ete Hesu nhe'ẽ, he'i hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","—Inhe'ẽ ndaha'éi gwĩ nhande rekombo'ehaty kwéry nhe'ẽ-rami, he'i Hesu nhe'ẽ-rehe hikwái. —Ha'e kwéry ndoikwaapáiry. Ha'e ae onhe'ẽ nomombe'úiry. Ha Hesu ae katu ha'e ae onhe'ẽ omombe'u. Oporomonhe'ẽgendu kwaa va'e-rami onhemonhe'ẽ. Imbaraete voi inhe'ẽ, he'i Hesu-rehe opondera-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ha upéi katu Hesu ogwejy jevy ou-vy upe yvyatyrusu ári-gwi. Ogwejy rire heta ijaty jaty va'e kente kwéry omoirũ íxupe oje'ói-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Upe jave ogwahẽ ou-vy iha-py mba'asy vai ogwereko va'e ijai aipa va'e. Gwetypy'ã-rehe onhesũ omboete-vy hovagwy-py: —Nhane mbogwerahaty voi nde, xe Járy. Xe-vy pa xe mbogwera ave arã nde? he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ha'e oipyso opo omoĩ hese: —Orombogwera-ta voi katu nde-vy, he'i íxupe. —Xe nhe'ẽ-py tane potĩ katu, he'i hasy va'e-pe. Upe-ma ramo opa-ma ojei íxugwi ijai aikwe. Okwera porã-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Upéi he'i Hesu: —Ejeapysaka katu xe nhe'ẽ-rehe. Ani eremombe'u avave-pe orombogwera-ma hagwe, he'i hasy va'ekwe-pe Hesu. —Tereho katu pa'i oĩ ha-py ejehexa uka-vy. Ehexa uka íxupe erekweramaha. Eme'ẽ íxupe upe myamyrĩ “Nhame'ẽ katu” he'i va'ekwe. Upéixa ramo, “Okwera-ma. Onhemopotĩ jevy-ma” he'i va'erã nde-rehe, atýra-py ne mombe'u-vy, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ha upéi katu ogwahẽ oho-vy Hesu Cafarnaum tetã-my. Upe-py oike rire ogwahẽ ou-vy iha-py capitão, soldado kwéry ruvixa va'e: ");
INSERT INTO kgkNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Xe pytygwõ katu, Xe Járy Hesu, he'i. —Xe rembigwái oime koty-py. Nopu'ãvéi-ma, hajy jeapa-gwi ndoryrýiry. Hasy ete voi oĩ-vy, he'i íxupe soldado ruvixa. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Aipo ramo, aha-ta nde róga-py ambogwera hagwã íxupe, he'i soldado ruvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Nde, nde tuvixa mba'e-gwi, mba'éixa ereike-ta ereho-vy xe róga gwy-py? he'i omboete-vy íxupe. —Erenhembohekomirĩve-ta para'e ereike ereho-vy. Tuvixave e'ỹ va'e-rami joty ereike-ta upe-py. Aipo ramo ne nhe'ẽ-py rei embogwera katu xe rembigwái-pe, he'i. —“Tokwera” ere ramo, okwera va'erã. A-gwi rei ne nhe'ẽ-py mante okwera va'erã xe rembigwái hasy va'e, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Oĩ xe-rehe omanda va'e. Inhe'ẽ ajapo va'e. Xe pogwy-py ave oĩ soldado xe amanda hese va'e. Kóa-pe, “Tereho katu” ha'e ramo, oho ave arã voi. Ha upéa-pe, “Eju katu” ha'e ramo, ou ave arã voi. Xe rembigwái-pe, “Ejapo katu xe nhe'ẽ” ha'e ramo, ojapo ave arã voi. Upéixa ave ne nhe'ẽ-py rei nde pu'aka nipo ra'e mba'asy-rehe erembogwera hagwã xe rembigwái-pe, he'i íxupe upe soldado ruvixa. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Upéa nhe'ẽ rendu-vy “Mba'éixa ojerovia tee xe-rehe” he'i Hesu opondera-vy hese. —Ojerovia tee voi xe-rehe upe va'e, he'i kente kwéry-pe hapykwéri ogwa'ẽ va'e-pe. —Amombe'u-ta peẽ-my anhetegwa, he'i. —Oĩ Israel remiarirõre judeu kwéry xe-rehe ojerovia va'e. Ha ko va'e soldado ruvixa judeu e'ỹ ramo jepe, ojerovia teeve joty xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","—Ha'e-ta peẽ-my. Heta mombyrygwa ogwahẽ va'erã oho-vy Nhandejáry nhande ruvixa ramo oiko haty-py. Heta kwarahy resẽ gwigwa oho va'erã jekarugwasu haty-py. Heta ka'aru gwigwa oho va'erã ave. Ogwapy va'erã okaru-vy Abraão ndive, Isaque ndive, Jacó ndive ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ha judeu kwéry va'e Nhandejáry re'ýi va'e oho va'erãgwe katu nogwahẽ mo'ãi va'erã upe-py. Omosẽ va'erã íxupe imondo-vy pytũ kwa-py. Upe-py ojahe'o va'erã. Hasẽ va'erã onhemboasy-gwi. Nhandejáry-rehe onhemoyrõ-gwi, onhemohãingyry ngyrýu va'erã oiko-vy, he'i judeu kwéry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Upéi he'i upe soldado ruvixa-pe: —Tereho jevy katu nde róga-py. Xe reroviaha-rami, toiko katu nde-vy, he'i. Upe-ma ramo okwera-ma hembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ha upéi katu Hesu oho Pedro róga-py. Ogwahẽ ramo upe-py ohexa Pedro raixo. Onheno ra'e oĩ-vy. Hasy ete voi heteraku-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Omboja opo ipo-rehe. Opa-ma íxugwi heterakukwe. Opu'ã-ma Hesu remi'urã-rehe onhangareko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ka'aru ete-ma ojereru iha-py heta anháy ojepota hese va'e. Onhe'ẽ-py rei omosẽ mosẽ anháy imondo-vy. Entéro hasy va'e-pe gwive ombogwera-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Upéa rehegwa ojapo Hesu, upéixa hembiapo yma gware he'i hagwe-rami oiko hagwã ãy. Yma Nhandejáry nhe'ẽ-py omombe'u va'ety Isaías remimoĩgwe kwatia-rehe a-rami: “Nhande kwéry nhande rasy ramo, omboyke-ma opaixagwa mba'asy heraha-vy nhandéhegwi”. Yma he'i hagwe-rami, ãy oiko-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ha upéi katu heta kente onhemboaty Hesu-rehe. Ohexa ramo heta onhemboaty hese, he'i gwemimbo'e kwéry-pe: —Jahasa katu y rovái, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ne'írã vyteri onhemboyru jave kanóa-py, ou ohogwaitĩ-vy íxupe peteĩ judeu rekombo'ehaty: —Xe oromoirũ-ta, porombo'eháry, he'i Hesu-pe. —Mamo ereho ha-rupi oromoirũ-ta, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hesu he'i jevy íxupe: —Mykurẽ, yvykwa oĩ íxupe hógarã. Gwyra, oĩ ave íxupe haityrã. Ha xe ae katu Nhande Ryke'y tee va'e, ndaipóri xe-vy xe renagwã atongea-vy xe apyta hagwã, he'i. —Xe moirũse joty pa nde? he'i pe tekombo'ehaty-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Upéi outro peteĩ hemimbo'e va'e he'i Hesu-pe: —Xe oromoirũ va'erã, xe Járy, he'i. —Aha'arõ ranhe-ta xe ru omano ramo ajaty hagwã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Nahániry. Ãy voi aipota xe moirũ, he'i íxupe. —Xe moirũse e'ỹ va'e ae taimandu'a ranhe katu omano va'ekwe ojaty hagwã-rehe, he'i upe gwemimbo'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Upéi onhemboyru-ma kanóa-py Hesu. Hemimbo'e kwéry onhemboyru ave indive. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Upe jave ou yvytugwasu marány. Ho'a yugwarusu-rehe omomýi hagwã yugwarusu. Upe-ma ramo omopu'ã pu'ã y-pe, ojaho'i ho'i kanóa-pe y. Ha Hesu ae katu oke joty oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ha hemimbo'e kwéry oho omombáy íxupe: —Ore resende katu, ore Járy, he'i. —Nhanheapymi-tama nhande, he'i Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—Mbava'e-gwi tipo pende py'amirĩ, he'i íxupe kwéry. —Ndapejerovia teéiry ra'e xe-rehe, he'i íxupe kwéry. Upéi opu'ã onhe'ẽ-py omokirirĩ hagwã. He'i yvytugwasu-pe, y opu'ã va'e-pe ave —Ekirirĩ katu, he'i ipoxy va'e-pe. Upe-ma ramo ohopa-ma yvytu. Opytu'u jevy y. Okirirĩ porãmba jevy-ma y. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ha'e kwéry opondera voi hese: —Mba'eixagwa heko va'e po, he'i opondera-vy hese. —Yvytugwasu jepe, y opu'ã pu'ã va'ekwe jepe ohendu inhe'ẽ, he'i Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Upéi ogwahẽ-ma oho-vy y rovái. Gadara yvy-py ogwahẽ. Upe-py ogwahẽ-ma ramo, ou ohogwaitĩ-vy íxupe mokõi anháy rerekoha va'e. Ijyta-gwi osẽ ou-vy. Heko poxy eterei va'e. Upéa-gwi ohasase va'e oikupe'o íxupe ohasa hagwã. Ndikatúi ohasa ijypy-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Onhe'ẽ hatã hatã Hesu-pe ombojevyse-vy mo'ã: —Nde ko Nhandejáry ra'y. Ma'erã ereju ko'a-py, he'i Hesu-pe ombojevyse-vy mo'ã. —Ne'írã vyteri ore moingo asyha áry. Ma'erã ereju? he'i. —Ore moingo asyha áry-py ae ereju va'erã mo'ã, he'i Hesu-pe. —Ãy katu ani ereju ore moingo asy-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mombyry-gwi ohexa heta kure okaru jave. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Upéa-gwi ojerure rure íxupe: —Ore mosẽ-ta ramo, ore mondo katu kure kwéry-pe. Ore mondo katu ipy'a kwéry-py, he'i anháy kwéry Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Tapeho, he'i íxupe kwéry. Inhe'ẽ-rupi osẽ oho-vy oike kure kwéry py'a-py. Ha kure kwéry katu oriparapa oje'ói-vy. Yugwarusu-py ogwejy oje'ói-vy. Hi'apỹ ogwejy oje'ói-vy. Ho'a onheapymi oje'ói-vy y-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ha kure nhangarekoha oripara oje'ói-vy. Atygwasu-py oho omombe'u-vy. Anháy rerekohare-pe ojehu va'ekwe gwive omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Upe ramo atygwasu pygwa Hesu rogwaitĩ-vy osẽ ogwa'ẽ-vy. Ohexa-ma ramo Hesu-pe, ombojevyse íxupe: —Ekwa jevy katu ore yvy-gwi, he'i Hesu-pe ojapura-gwi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ha upéi katu Hesu onhemboyru jevy-ma oho-vy kanóa-py. Upéi ohasa y rovái ogwahẽ oho-vy ha'e ae oiko ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Upe-py ojereru íxupe hajy jeapa apa va'e. Gwupa reheve ou onheno oĩ-vy. Ójehe ojerovia tee ramo, ohexakwaa hese. Upéa-gwi he'i upe hajy jeapa apa va'e-pe: —Ani erekyhyje teĩ, xe ra'y, he'i íxupe ombopy'agwapy-vy. Gwa'ýry-pe he'iha-rami he'i íxupe: —Amboyke-ma ndéhegwi ne rembiapo vaikwe, he'i upe hajy jeapa apa va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Upe-py oĩ judeu rekombo'ehaty. Ohendu-ma ramo Hesu nhe'ẽ, ndojohu porãi: —Onhemonhandejáry rei ou-vy, he'i mo'ã Nhandejáry Hesu-rehe. —Onhe'ẽ vai rei, he'i ojóupe hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ha ipy'apóry oikwaa Hesu: —Ma'erã-gwi erenhe'ẽ vai rei nde py'apy-py? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—Pejeapysaka porã katu xe nhe'ẽ-rehe. Oĩ ramo, “Amboyke-ma ndéhegwi ne rembiapo vaikwe” he'i va'e katu, ndajahexái hemimboyke. Omboyke para'e. Tapa nomboykéiry ra'e. Ndajahexáiry. Ha oĩ ramo, “Epu'ã katu egwata eho-vy” he'i rei va'e katu, jahexa ave. Nomopu'ãiry upe va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ãy aikwaa uka-ta peẽ-my xe nhe'ẽ rei e'ỹha ko yvy-py. Xe Nhande Ryke'y tee va'e xe nhe'ẽ-py rei amboyke-ma voi yvypóry rembiapo vaikwe, he'i Hesu onhe'ẽ-vy gwĩ imbo'eháry-pe. Upe ramo he'i hajy jeapa va'e-pe: —Epu'ã katu ehupi nde rupagwe. Tereho nde róga-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Upe-ma ramo opu'ã oho-ma gwóga-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Upéa ohexa ramo ijaty va'e kente, opondera eterei hese. Inhe'ẽ-py rei omopu'ã-gwi: —Omopu'ã-ma ngatu, he'i Hesu-rehe. —Iporã porã ete va'e voi hembiapo, he'i hese. —Nhandejáry omombaraete voi upe kwimba'e. Herovia hexapyrã-rupi ha'e hembiapo, he'i Hesu-rehe Nhandejáry-pe omomba'egwasu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Upe-gwi ohasave Hesu oho-vy. Oho jave, ohexa Mateus héry va'e-pe ogwapy oĩ-vy ramo. Nhane mbopaga haty-py ogwapy oĩ-vy: —Xe moirũ katu, he'i íxupe. Upe-ma ramo opu'ã omoirũ-ma íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Upéi oho okaru Mateus róga-py. Ha'e okaru jave gwemimbo'e kwéry ndive ogwahẽ ave ou-vy heta nhane mbopaga uka va'ety, heta ojejavy va'e ou ave okaru ojoha-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Upéa ohexa ramo fariseu kwéry, oporandu Hesu remimbo'e kwéry-pe: —Ma'erã-gwi ne mbo'eháry okaru nhane mbopaga uka va'ety ndive, ojejavy va'e ndive ave? he'i Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Upéa fariseu nhe'ẽ ohendu ramo Hesu: —Nhane resãi ramo, nanhaikotevẽi nhane mbogweraharã-rehe. Ha nhande rasy ramo ae katu, nhaikotevẽ-ma nhane mbogweraharã-rehe, he'i hemimopotĩse-rehe onhemoirũ uka hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","—Ko'a-rami ae oĩ Nhandejáry kwatia nhe'ẽ: “Ijukapyrã xe mboete-vy pejuka rei ramo, pende py'a porã e'ỹ reheve ojóupe, xe ndajohu porãi arã. Ha pejoporiahuvereko rei ramo katu xe ajohu porã arã pende reko. Upe va'e xe aipota voi, he'i Nhandejáry”. Upéixa he'i Nhandejáry kwatia nhe'ẽ. Upéa nhe'ẽ, tapeho katu peikwaa hagwã he'ise va'e. Ndajúi va'ekwe ahenói-vy “Xe potĩ” he'i ójehe va'e-pe ou xe moirũ. Gwĩ ojejavy va'e-pe ae aju arova uka-vy hekoha íxupe xe moirũ hagwã, he'i fariseu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Upéi ogwahẽ ou-vy Hesu renda-py João remimbo'e: —Ore orohasa orokaru e'ỹ reheve Nhandejáry oipotaha-rami, he'i. —Ohasa ave okaru e'ỹ reheve fariseu kwéry. Ha ne remimbo'e kwéry katu ndohasái voi okaru e'ỹ reheve. Ma'erã po ndoikói ore reko-rami, he'i Hesu-pe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Upéi Hesu he'i: —Amombe'u-ta peẽ-my arandu rehegwa nhe'ẽ omenda va'e rehegwa-rami. Oime vyteri ramo omenda va'e, ndovy'are'ỹiry he'ýi kwéry. Okaru e'ỹ reheve ndohasáiry. Ha ojererahaha óra ogwahẽ-ta. Upe óra-py ohasa va'erã okaru e'ỹ reheve he'ýi kwéry, he'i ojehegwa omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Upéi he'i jevy upe pygwa-pe: —Outro arandu rehegwa nhe'ẽ háma amombe'u-ta peẽ-my ao rehegwa-rami, uva rykwere rehegwa-rami ave. Nanharemendái ipyahu va'e-py ao tuja. Nharemenda ramo ae katu onhynhy arã ra'e ipyahu va'e. Ojepoapy-vy omondoro arã ao tuja. Osorogwasuve va'erã ao tuja. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nanhanhunháiry ave uva rykwere pyahu va'e hyrurã tuja-py vakapi ipererĩ va'e-py. Ha nhanhunha ramo ae katu, ovu va'erã ra'e ipyahu va'e. Gwyru tuja va'e omondoro va'erã. Osyrypa arã ra'e pe uva rykwere onhehẽ-vy. Osoropa arã hyrukwe. Ha uva rykwere pyahu va'e ae katu nhanhunha hyru pyahu-py. Upéixa ramo opyta porã gwyru ndive, he'i Hesu oipota-gwi fariseu kwéry onhemboheko pyahu. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Upéa he'i jave, ogwahẽ ou-vy peteĩ mburuvixa. Gwetypy'ã-rehe onhesũ Hesu rovagwy-py imboete-vy: —Omano-ma xe rajy, he'i. —Omano ramo jepe, iporã ereho joty katu eremoĩ nde po hese oikove jevy hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Inhe'ẽ-py opu'ã oho-vy mburuvixa ndive. Hemimbo'e kwéry hendive ave oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Upe-ma ramo ogwahẽ ou-vy peteĩ kunha. Are-ma hasy. Hasy doze ro'y ijysapy ogwejy eterei íxupe-gwi. Upéa-gwi ou hapykwéri, Hesu rapykwéri. Opoko-ma ijao poty-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Amboja ramo jepe xe po ijao-rehe, akwera-ma va'erã” he'i ra'e ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Upe-ma ramo ha'e ojere. Oma'ẽ ramo, ohexa-ma upe kunha-pe: —Ani erekyhyje teĩ xéhegwi, xe rajy, he'i imbopy'agwapy-vy íxupe. Gwajýry-pe he'iha-rami, he'i kunha-pe: —Nde erejerovia-magwi xe-rehe, erekwera-ma, he'i kunha-pe. Upéa nhe'ẽ he'i-ma ramo, pya'e okwera upe kunha. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ha upéi katu ojere jevy oho hagwã mburuvixa róga-py. Upe-py ohexa heta oĩ óga-py ijayvu va'e. Gwemimby ombopu ohapirõ-vy. Hasẽmba-ma ave. Ohexa ramo: ");
INSERT INTO kgkNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Tapehopa katu, he'i. —Nomano etéiry voi mitã kunha. Oke ae-ma oĩ-vy, he'i omosẽ-vy. Ha óga-py oĩ va'e gwive katu onhembohory hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Omosẽmba rire, oike koty-py mitã kunha oĩ ha-py. Oipopyhy íxupe imopu'ã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Upe ramo upe mitã kunha omopu'ã jevy va'ekwe rerakwã opa-rupi osarambi upe yvy-rupi oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Upe-gwi ohasave oho-vy Hesu. Ha mokõi hesapyso e'ỹ va'e katu ou hapykwéri: —Davi remiarirõre nhane remiha'arõ va'e, he'i ohenói hatã-vy íxupe. —Ore poriahuvereko katu, ore poriahuvereko katu, he'i ohenói hatã-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Upéi ha'e oike koty-py. Oike rire, ogwahẽ ave ou-vy upe mokõi hesapyso e'ỹ va'e: —Pejerovia tipo xe-rehe apombohesapyso porã hagwã, he'i íxupe kwéry Hesu. —Ha'e voi, he'i. —Orojerovia-ma nde-rehe, ore Járy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Upéi omoĩ hesa ári opo: —Xe reroviaha-rami pehexa porã katu, he'i hesapyso e'ỹ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Upe ramo hesapyso porã-ma. Ha Hesu ndohejái omombe'u ojehegwa: —Erekwera hagwe aníke eremombe'u mbe'u teĩ avave-pe, he'i íxupe omanda pohýi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ha okwera va'e katu ojoko ramo jepe íxupe, osẽ joty oho-vy. Omosarambi ra'e opa-rupi. Herakwã oho joty opa-rupi. Upe yvy-rupi osarambi joty ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Koty-gwi osẽ jave, ojereru Hesu renda-py anháy rerekoha inhe'ẽnge'ỹ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Omosẽ imondo-vy anháy-pe. Inhe'ẽnge'ỹ va'ekwe onhe'ẽ-ma. Ojogweroaty va'e kente ohexa ramo, opondera eterei hese: —Yma gwive ko'ánga ete peve ndajahexái voi a ramigwa, he'i. —Nhande kwéry yvy-rupi, Israel yvy-rupi ndajahexái voi a ramigwa, he'i opondera-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ha fariseu kwéry katu ndojohu porãi hembiapo: —Anháy ruvixa nhe'ẽ-py ae nipo ra'e omosẽ imondo-vy anháy-pe Hesu. Anháy ae nipo ombopu'aka ra'e Hesu-pe, he'i mo'ã hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ha upéi katu Hesu ohasa oho-vy tetã tetã-rupi gwive. Tetã'i tã'i-rupi gwive ave ohasa oho-vy. Ojeporahéi haty haty-rupi Nhandejáry nhande ruvixarã rehegwa nhe'ẽ porã omombe'u mbe'u. Opaixagwa mba'asy-gwi ombogwera gwera hasy va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ohexa ramo ijaty jaty va'e kente, oiporiahuvereko íxupe kwéry: —Ovexa-rami rei oiko ra'e hikwái, he'i. —Ndoikóiry ramo ovexa-rehe onhangareko va'e, ndoiko porãi. Ipyrasypa, heterasypa ave. Ho'a ramo, ndaipóri henohẽharã. Upéixa ete ovexa hasy va'e-rami, herekwa e'ỹ va'e-rami oiko ko ijaty va'e kente xe moirũse va'e. Upéa-gwi aiporiahuvereko-ma íxupe kwéry, he'i ojogweroaty va'e kente kwéry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Upe ramo omombe'u gwemimbo'e kwéry-pe nhe'ẽ mombe'uharã rehegwa nhe'ẽ temitỹgwe kytĩharã rehegwa nhe'ẽ oiporu-vy. —Heta hi'a porã ramo jepe, ndahetáiry joty oikytĩ va'e heraha-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Upéixa ete heta eterei oĩ ramo jepe nhe'ẽ porã ohenduse va'e, ndahetáiry joty imombe'uharã íxupe kwéry. Upéa-gwi pejapo oração temitỹgwe járy-pe omondo hagwã oikytĩharã, he'i Nhandejáry-rehe, nhe'ẽ porã mombe'uharã-rehe oração ojapo uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ha upéi katu Hesu ohenói gwemimbo'e kwéry omoirũ teeha doze va'e-pe. Upe va'e doze va'e ohenói ou hagwã. Ou ramo ombopu'aka íxupe kwéry omosẽ hagwã anháy imondo-vy. Opaixagwa mba'asy-rehe ave ombopu'aka íxupe kwéry ombogwera hagwã hasy va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gwĩ doze hemimondo va'e héry a-rami. Oĩ Simão ha'e tenonde va'e, tuvixave va'e. Pedro ombohéry jo'a íxupe. Tyvýry héry André. Oĩ ave mokõi Zebedeu ra'y Tiago, tyvýry héry João ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Oĩ ave Filipe Bartolomeu ndive. Oĩ Tomé Mateus ndive. Mateus nhane mbopaga uka va'ety plata-py governo pegwarã. Oĩ Alfeu ra'y Tiago. Oĩ Tadeu ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Oĩ ave Simão. Ha'e gwĩ ojehegwa e'ỹ va'e huvixa ramo oiko va'e-pe omosẽse va'e kwéry irũ va'ekwe. Indive oĩ Judas Iscariotes, upe va'e Hesu pyhy ukaharã voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Upéa doze gwemimbo'e omondo nhe'ẽ porã omombe'u hagwã: —Tapeho a-rami, he'i. —Ani ereho teĩ judeu e'ỹ va'e oiko ha-rupi. Tetã Samaritano oiko ha-rupi ani ereike teĩ upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tapeho ae katu Israel remiarirõre judeu kwéry oiko ha-rupi. Ovexa okanhy va'ekwe-rami oiko hikwái. Tapeho ae katu peheka-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pemombe'u mbe'u pehokwe-vy Nhandejáry rehegwa nhe'ẽ íxupe kwéry: “Ogwahẽ-ma ngatu hi'óra. Pene mo'agwĩ-ma ou-vy Nhandejáry pende ruvixarã” peje kuri judeu kwéry-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","—Pembogwera gwera katu hasy va'e-pe peho-vy. Pemoingove jevy katu omano va'ekwe-pe. Pembogwera katu mba'asy vai-gwi ijai aipa va'e-pe. Pemosẽ mosẽ katu anháy-pe. Pende rexakwaa rei hagwe-rami ave, pehexakwaa rei pende rapixa pembopaga e'ỹ reheve. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ani ereraha teĩ plata nde ku'akwaha gwy-py. Hepy va'e ouro ani ereraha teĩ. Ani ereraha plata. Moeda jepe ani ereraha teĩ. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nde vosa ani ereraha teĩ ave ne ndive ereho jave. Ne kamisa ani erembojo'a ave kuri. Nde pyryru, nde pykoka ave ani ereraha teĩ. “Omba'apo va'e-pe nhame'ẽ hemikotevẽ” ja'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Atygwasu-py ereike ramo, tetã'i-my ereike ramo ave, eporandu ranhe hembiapo porã porã va'e-rehe. “Kipy kipy tipo oĩ hembiapo porã va'e” peje. Epyta indive eresẽ peve pe tetã-gwi ereiko-vy upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ereike ramo óga-py, “Tapene mbopy'agwapy katu Nhandejáry” ere óga pygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Óga pygwa pene mogwahẽ porã ramo, peheja katu pene nhe'ẽ íxupe. Ha napene mogwahẽi ramo, ani peheja teĩ íxupe pene nhe'ẽ. Upe pene nhe'ẽ perupa jevy katu íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ha oĩ ramo óga pygwa pende rerohory e'ỹ va'e, oĩ ramo tetã mygwa ave pene nhe'ẽ renduse e'ỹha va'e katu, pe tetã-gwi eresẽ jave, embovava nde py ho'apa hagwã yvy timbore nde py-gwi. Upéixa erejapo ramo, eremomandu'a uka arã hembiapo vaikwe-rehe. “Nhandejáry re'ýi e'ỹ-rami nipo ra'e nhande” he'i va'erã ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Amombe'u-ta peẽ-my anhetegwa va'e. Upe áry-py, yvypóry rembiapo apokwe-rami ojererekoha áry-py, omoingo asy va'erã gwĩ hekoha vai va'ekwe-pe Sodoma tetã mygwa amyrĩ kwéry-pe. Gomorra tetã mygwa amyrĩ kwéry-pe ave. Ogwereko asy va'erã íxupe kwéry. Ha pe tetã mygwa-pe ne nhe'ẽ renduse e'ỹ va'e-pe katu ogwereko asyve syve va'erã Nhandejáry, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Upéi Hesu he'i jevy gwemimbo'e kwéry-pe: —Pejeapysaka katu xe nhe'ẽ-rehe. Xáke pende-rehe. Oromondo-ta hekoha vai va'e pa'ũ-rupi ereiko hagwã. Ovexa jagwarete pa'ũ-my oiko va'e-rami peẽ peiko arã ipa'ũ-my. Aipo ramo penhangareko porã katu pendéjehe peẽ. Ju'igwasu onhangareko ójehe ha-rami, peiko arandu katu peẽ ave. Pykasu inharõ e'ỹ va'e reko-rami, peiko katu peẽ ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","—Xáke pende reraha va'erã pende ruvixa renda-py. Ojeporahéi haty haty-rupi pene nupã va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Xe-rehe ha-py pende reraha va'erã mburuvixa renda-py. Mburuvixagwasu renonde-py ave pende reraha va'erã. Judeu kwéry-pe, judeu e'ỹ kwéry-pe ave, pemombe'u va'erã Nhandejáry tuvixa mba'e voiha. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pende reraha ramo, ani pemoĩ teĩ pende py'a-rehe pene nhe'ẽrã. Upe óra-py ou rei va'erã nde juru-py ne nhe'ẽrã. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Erenhe'ẽ ramo, ndaha'éi va'erã ne arandu-rupi. Nde juru-py ae Nhandejáry ombou va'erã nde-vy ne nhe'ẽrã. Pende Ru yváy pygwa va'e nhe'ẽ marangatu ou va'erã nde juru-py ne nhe'ẽrã ne monhe'ẽ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ha tyke'ýry oipyhy va'erã heraha-vy gwyvýry ojuka uka hagwã. Tyvýry ojuka uka va'erã gwyke'ýry-pe. Túvy ojuka uka va'erã gwa'ýry-pe gwajýry-pe ave. Ha ta'ýry kwéry tajýry kwéry ave ogwereko asy va'erã gwu-pe ojuka uka-vy. Imemby kwéry ojuka ukase va'erã osy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Xe-rehe ha-py enterovéa ipy'a vai va'erã oiko-vy pende-rehe. Ha xéhegwi ova e'ỹ va'e, ogwereko asy ukaharã-pe onheme'ẽ e'ỹ va'e, ojerereko asy ramo jepe onhembopyatã joty va'e katu, oresende va'erã íxupe Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pende rereko asy hagwe-gwi, tapekanhy katu peho-vy outro henda-py. Amombe'u-ta peẽ-my anhetegwa va'e. Xe Nhande Ryke'y tee va'e ajekwaa aju hagwã áry-py, oĩ vyteri va'erã Israel yvy pygwa tetã ne'írã vyteri pegwahẽ upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Hemimbo'e nonhembotuvixa mba'éi voi ombo'eháry-pe. Nonhembotuvixa mba'éi ave ojáry-pe hembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iporã katu ombo'eháry-pe ohekoarupityse ramo hemimbo'e. Ojáry-pe ohekoarupityse ramo hembigwái, iporã ave. Onhe'ẽ vai rei kuri xe-rehe, “Anháy ruvixa Belzebu” he'i kuri xe-rehe. Upéixa he'i ramo xe-rehe, onhe'ẽ vaive va'erã voi pende-rehe. Xe óga járy-rami. Peẽ óga pygwa. Xe-rehe onhe'ẽ vaiha-rami ave, pende-rehe onhe'ẽ vaive va'erã, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Upéi he'i jevy gwemimbo'e kwéry-pe: —Upéixa ramo, ani erekyhyje teĩ pende rereko asy ukaharã-gwi. Entéro nhanhomi va'ekwe gwive, ojehexa jevy joty va'erã voi. Entéro nhamokanhy va'e gwive, ojekwaa jevy joty va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","—Nhemi ha-py peẽ-my xe remimombe'ukwe, atýra-py pemombe'u mbe'u jevy. Pende apysa-py peẽ-my xe rembierovovo xe remimombe'ukwe, pende róga apotaha ári, penhomboaty haty haty-rupi, perosapukái va'e-rami pemombe'u jevy. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Oĩ nhande rete jukaharã. Ha nhane nhe'ẽgwe-rehe ae katu ndaipu'akáiry. Aníke erekyhyje teĩ íxugwi. Ha Nhandejáry katu ipu'aka nhane nhe'ẽgwe-rehe. Omondose ramo, omondo arã omondose ha-py. Tata opa opa rei e'ỹ va'e haty-py nhane mondose ramo, nhande rete reheve nhane mondo va'erã. Íxugwi ae katu pekyhyje. Íxugwi ae katu enhemokirirĩ. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mokõi gwyra'i ovende ramo, ndahepýi. Nanhapenái joty hese. Ha Nhandejáry katu onhangareko hese. Hymba voi. Yvy-py peteĩ ho'a ramo, ojéhegwi rei ndo'áiry. Nhandejáry nhe'ẽ-py ae ho'a omano-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Heta eterei gwyra'i ovende ramo jepe ndahepy etéi joty. Ha nde ae katu tuvixa mba'eve Nhandejáry-pe gwyra kwéry-gwi. Ne akã ragwe jepe, mbovy po oĩ oikwaa-ma. Peteĩ teĩ oipapa-ma nde-rehe opena eterei-gwi. “Tuvixa mba'e” he'i nde-rehe Nhandejáry. Upéa-gwi aníke pekyhyje teĩ pendéjehe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Upéi he'i jevy Hesu: —Atýra-py, “Hesu re'ýi voi xe” ere ramo katu, xe Ru yváy pygwa va'e renonde-py, “Xe re'ýi voi upe va'e” ha'e arã nde-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","—Ha atýra-py, “Hesu remimbo'e e'ỹ voi xe” ere ramo katu, xe Ru yváy pygwa renonde-py, “Xe re'ýi e'ỹ voi upe va'e” ha'e arã nde-rehe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Upéi he'i jevy Hesu: —“Ojekwaa-ma ou-vy Hesu entéro yvypóry ijoja porã hagwã” ani ere mo'ã ndejéupe. Upe va'erã-rehe ndajúi va'ekwe. Ha ijoja e'ỹ hagwã onhondive xe renduse e'ỹha xe renduseharã ave ae katu aju va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Xe aju va'ekwe-gwi, ndoiko jojái va'erã ta'ýry gwu ndive. Ndojoeko rayhu reíry va'erã imemby kunha osy ndive. Imemby rembireko ndoiko porãi va'erã ome sy ndive ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nhande róga pygwa jepe nhande a'e'ỹha voi, he'i Nhandejáry kwatia nhe'ẽ oiporu-vy. Upéi he'i jevy: ");
INSERT INTO kgkNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Oĩ ramo xe rayhu va'e, gwu-pe xéhegwi ohayhuve va'e, osy-pe ohayhuve va'e xéhegwi, ndaha'éi arã xe re'ýi tee. Oĩ ramo xe rayhu va'e, gwa'ýry-pe, gwajýry-pe ohayhuve va'e xéhegwi, omemby-pe ohayhuve va'e xéhegwi, ndaha'éiry xe re'ýi tee upe va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","—Gwĩ xe moirũ tee hagwã okurusugwasu ohupi heraha-vy va'e-rami ijukapyrã-rami oiko va'e ae, xe re'ýi tee va'erã, he'i. —Upéa reko-rupi ndereikói ramo, ndaha'éi arã xe re'ýi tee. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Gwekove-rehe hakate'ỹ va'e ndoikove mo'ãi va'erã Nhandejáry ndive. Ha xe-rehe ha-py gwekove-rehe nopenái va'e katu, oikove meme va'erã Nhandejáry ndive, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Upéi he'i jevy Hesu: —Ne mogwahẽ porã va'e, xe háma ave xe mogwahẽ porã va'erã. Xe mogwahẽ porã va'e, ha'e háma ave Nhandejáry xe mbou va'ekwe-pe omogwahẽ porã va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ogwahẽ ou-vy ramo nde róga-py Nhandejáry nhe'ẽ-py omombe'u va'ety, emogwahẽ porã katu íxupe Nhandejáry rembigwái-gwi. Nhandejáry ombohekovia va'erã upe inhe'ẽ-py omombe'u va'ety-pe. Ha'e-rami ave ne rembiapo porãkwe repy ohekoviarõ va'erã voi nde-vy yváy-py. Ogwahẽ ou-vy ramo nde róga-py hekoha porã va'e, emogwahẽ porã katu íxupe hekoha porã-gwi. Nhandejáry ombohekovia va'erã upe hekoha porã va'e-pe. Ha'e-rami ave ne rembiapo porãkwe repy ohekoviarõ va'erã nde-vy yváy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Xe remimbo'e va'e heko'ive va'e jepe ijy'uhéi-ma ramo, eme'ẽ y íxupe toy'u. Xe remimbo'e-gwi, emboy'u joty íxupe. Amombe'u-ta peẽ-my anhetegwa va'e. Ne rembiapo porãkwe repy ohekoviarõ va'erã voi nde-vy yváy-py, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Upéixa Hesu ombo'e mbo'e upe doze gwemimbo'e kwéry-pe. Ombo'epa rire, osẽ oho-vy Hesu rupive hikwái. Upe-gwi ohasave oho-vy tetã tetã-rupi. Oporombo'e mbo'e Hesu oho-vy. Omombe'u mbe'u oho-vy ave Nhandejáry nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ha João Batista katu onhemoĩ preso oiko-vy. Ohendu ramo Cristo Nhandejáry rembiporavo va'e rerakwã, mokõi gwemimbo'e omondo Hesu ha-py oikwaa hagwã: “Mba'eixagwa po nde” omoporandu uka hagwã omondo íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ogwahẽ oho-vy ramo he'i: —Nde tipo upe temiha'arõ va'e voi, he'i oporandu-vy íxupe. —Ndaha'éi tipo nde? Tapa outro ae nhaha'arõ va'erã? he'i oporandu-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","—Tapeho jevy katu, he'i João remimbo'e kwéry-pe. —Emombe'u João-pe ne remiendu endukwe, ne rembiexagwe xagwe ave emombe'u íxupe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","—Hesapyso e'ỹ va'ekwe hesapyso porã-ma. Ogwata e'ỹ va'ekwe ogwata porã-ma. Mba'asy vai-gwi ijai aipa va'ekwe okwera-ma. Ijapysa e'ỹ va'ekwe ijapysa porã-ma. Omano ete va'ekwe oikove jevy-ma. Ha iporiahu va'e kwéry-pe katu omombe'u-ma Nhandejáry rehegwa nhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Xe rembiapo rerakwã rendu ramo, ohexa kwaa-ma va'erã xe rekoha-rehe. Oikwaa-ma va'erã xe-rehe. Xe-rehe ojerovia ku'a ku'a va'e, “Nhandejáry rembiporavo tee para'e. Nhandejáry rembiporavo e'ỹ para'e” he'i rei va'e xe-rehe, ndovy'a mo'ãi va'erã. Ha xe-rehe ojerovia tee va'e, xe rerovia ku'a ku'a e'ỹ va'e katu xe rerovy'a tee va'erã, he'i João-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Osẽ-ma ramo oho jevy-vy João remimbo'e, omombe'u Hesu ojogweroaty aty va'e kente-pe João rehegwa nhe'ẽ omombe'u: —Peho kuri tekwaty e'ỹ-my. Ma'erã tipo peho araka'e? Upe-py heta oĩ kapiyvanhe'ẽ yvytu ogwerova rova va'e. Upéa-rehe ndapehói ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mbava'e rexa-vy rei tipo peho araka'e? Ijao porã va'e rexa-vy ndapehói araka'e. Mburuvixagwasu róga kakwaa-py oiko ijao porã va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Mbava'e rexa-vy rei tipo peho araka'e. Nhandejáry nhe'ẽ-py omombe'u va'ety rexa-vy rei po peho araka'e? Upéa-rehe voi katu peho araka'e. Ha'e-ta peẽ-my: Gwĩ Nhandejáry nhe'ẽ-py omombe'u va'ety kwéry-gwi tuvixave va'e, João Batista héry va'e pehexa voi araka'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pe Nhandejáry kwatia nhe'ẽ omotenonde íxupe va'ekwe-pe pehexa araka'e. Ko'a-rami ae oĩ Nhandejáry kwatia nhe'ẽ: “Xe nhe'ẽ mombe'uharã amondo va'erã íxupe ne renonde-rupi. Ne'írã ereho jave, omopotĩ va'erã nde raperã” he'i va'ekwe João Batista rekoharã-rehe, upe xe nhe'ẽ ohendu uka va'erã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Amombe'u-ta peẽ-my anhetegwa va'e. Yma gwive ãy peve ndaipóri va'ekwe João Batista-gwi tuvixave va'e. Ha ãy katu, Nhandejáry nhande ruvixa-pe omoirũ tee va'e gwive, tuvixave va'e João Batista-gwi. Onhomboete e'ỹ ete va'e jepe, Nhandejáry nhande ruvixa-pe omoirũ tee joty ramo, tuvixave va'e João Batista-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Are-ma va'ekwe João omombe'u va'ekwe ko'ánga ete peve. Heta kente onhemokyre'ỹ eterei omoirũ hagwã Nhandejáry-pe gwuvixarã. Ojapura-ma va'e-rami ikyre'ỹ. Oikese ha-py pya'e a'e oike ha-rami itarova-ma va'e-rami, omoirũse nga'u Nhandejáry-pe gwuvixarã. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Entéro yma gware Nhandejáry nhe'ẽ-py omombe'u va'ety gwive omotenonde va'ekwe ãy oiko va'erã. Nhandejáry nhande ruvixarã oiko va'erã omotenonde va'ekwe Nhandejáry kwatia nhe'ẽ-py omombe'u-vy. João Batista peve omotenonde va'ekwe omombe'u-vy: “Onhemoingove jevy va'erã Elias amyrĩ” he'i va'ekwe yma gware, Nhandejáry kwatia nhe'ẽ mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pehenduse ramo peẽ-my ha'e va'e, pejeapysaka katu. Upe Elias amyrĩ upe ou va'erã he'i va'ekwe yma gware, he'i João Batista-rehe, ojekwaa ramo va'e-rehe. Elias rekovia ojekwaa-ma João. Ãy nomotenondevéi imombe'u-vy. Yma he'i hagwe-rami, ãy oiko-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ne aranduse ramo ejeapysaka porã katu xe nhe'ẽ-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Xe amombe'u-ta peẽ-my mba'eixa po oiko ko'ãygwa. Mitã-rami voi ko'ãygwa. Mba'e jogwa haty-py onhembosarái mitã. Osapukái oirũrãgwe-pe: ");
INSERT INTO kgkNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ore remimby orombopu kuri ha peẽ ndapejerokyséi ra'e. Orohapirõ ra'anga kuri ha peẽ ndapejahe'oséiry ra'e” he'i oirũrãgwe-pe nonhembosaraiséi-gwi indive kwéry. Upe mitã oirũ remimbota ndojaposéiry. Upe mitãgwe reko-rami ãygwa ndogwerovy'ái gwapixa reko. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ojekwaa va'ekwe ou-vy João Batista. Nhandejáry oipotaha-rami ohasa okaru e'ỹ reheve. Uva rykwere ndo'úi va'ekwe. Ha hexaháry ae katu, “Anháy rerekoha” he'i mo'ã João Batista-rehe va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ãy xe Nhande Ryke'y tee va'e ajekwaa-ma aju-vy. Akaru-vy aju. Uva rykwere'u-vy aju. Ha xe rexaháry ae katu: “Okaru eterei upe va'e” he'i xe-rehe. “Ho'u eterei uva rykwere upe va'e. Oporombopaga uka va'ety ndive oiko va'e upéa. Gwĩ ojejavy va'e ndive ave oiko va'e upéa” he'i voi xe-rehe hikwái. Ha João rembiapo porã rexa kwaa-vy hese, xe rembiapo porã rexa kwaa-vy xe-rehe ave katu, “Hi'arandu tee nipo ra'e” peje va'erã ore-rehe, he'i João-rehe ijaty jaty va'e kente kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ha upéi katu Hesu ndojohu porãi upe tetã mygwa inhe'ẽ rendu e'ỹ va'e-pe. Upe-py heta heroviapyrã-rupi hembiapo porã porã ramo jepe, ndogwerovái joty gwekoha. Nomboasýi gwembiapo vaikwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Upe ramo he'i: —Apomboasy eterei peẽ-my Corazim tetã mygwa kwéry. Apomboasy eterei peẽ-my Betsaida tetã mygwa kwéry. Heroviapyrã-rupi xe rembiapo porã porã kuri pene retã pa'ũ-rupi apombojerovia ukase-vy mo'ã xéjehe. Ko'ã ramigwa voi ajapo ramo ra'e Tiro tetã-my Sidom tetã-my ave, pya'e voi omboasy arã araka'e gwembiapo vaikwe ra'e. Pya'e voi ogwerova arã araka'e gwekoha. Gwekoha-rupi ivy'are'ỹ va'e ao nhane mopirehatĩ va'e ao omonde arã araka'e. Tanimbu oipixy arã ójehe araka'e ojekwaa hagwã hese gwembiapokwe omboasyha. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—Upe áry-py yvypóry gwive hembiapo apokwe-rami ojerereko hagwã áry-py, ogwereko asy va'erã Tiro tetã mygwa-pe, Sidom tetã mygwa ndive. Ha peẽ ae pende rereko asy asyve va'erã katu. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ha peẽ Cafarnaum tetã mygwa katu, “Jajeupi va'erã yvate yváy-py jaiko hagwã” peje mo'ã pendéjehe penhembotuvixa ukase-vy. Ahániry, napene mbojeupi mo'ãi va'erã Nhandejáry. Pegwejy ae va'erã yvy gwy-py peho-vy, tata opa opa rei e'ỹ haty-py. Heroviapyrã-rupi xe rembiapo porã porã kuri pene retã pa'ũ-rupi apombojerovia ukase-vy mo'ã xéjehe. Upéixa ndajapói araka'e Sodoma tetã-my, upe hekoha vai eterei oiko va'e haty-py. Ha upéixa xe ajapo ramo ae katu araka'e upe-py, omboasy arã voi araka'e gwembiapo vaikwe, ogwerova arã araka'e gwekoha. Nonhehundíry arã araka'e. Ko'ánga ete peve opyta arã ra'e pe tetã. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Upe áry-py yvypóry gwive hembiapo apokwe-rami ojerereko hagwã áry-py, omoingo asy va'erã Nhandejáry Sodoma tetã mygwa-pe. Ha peẽ Cafarnaum tetã mygwa ae katu, pene moingo asyve syve va'erã voi, he'i Hesu upe tatã mygwa-pe omboasy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Upe ramo he'i Nhandejáry-pe Hesu: —Xe Ru, he'i —Nde yváy pygwa Járy, yvy pygwa Járy ave. Oĩ oakã-gwi rei hi'arandu va'e. Nahi'arandu porãi. “Ore ae oroikwaa va'e” he'i va'e mo'ã ójehe, upe va'e-pe ndereikwaa ukái inharandu porãrã. Ha gwĩ mitã vérami ne'írã inharandu va'e, “Ore oroikwaa va'e” he'i e'ỹ va'e ójehe katu, upéa va'e-pe ereikwaa uka inharandu porãrã. Upéa ne remimbota porã voi, xe Ru. Ereipota voi upe va'e. Upéa-rehe atima porã nde-vy, he'i Nhandejáry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Upéi he'i: —Opamba'e-rehe xe mbopu'aka va'ekwe xe Ru. Xe pogwy-py opamba'e omoĩ, he'i. —Xe kwaa porãha voi ndoikói. Xe Ru, ha'e anho mante xe kwaapa. Xe Ru kwaa porãha ndoikói. Xe ae Ta'ýry xe anho mante aikwaapa va'e íxupe. Ha outro kwéry-pe xe aikwaa ukase ramo katu, oikwaapa ave arã xe Ru-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Peju katu xe ha-py. Peẽ pene kane'õ va'e, ipohýi va'e ogwerahaha-rami oiko va'e-rami peiko va'e, peju katu xe ha-py. Apomotongea va'erã, apomombytu'u va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xe ko xe reko kirirĩ va'e. Xe reko amomirĩ va'e voi xe. Upéa-gwi xe nhe'ẽ pehendu katu, xe nhe'ẽ-rupi peiko katu. Xe remimbo'e ramo peiko ramo, pende py'agwapy va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","—Ndahasýiry niko xe remimombe'u pejapo hagwã. Pejapo ramo xe nhe'ẽ, omanda pohýi va'e pogwy-py ndapeikovéi-ma va'erã. Upéa-gwi pende py'agwapy porã va'erã peiko-vy, he'i Hesu upe pygwa-pe onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ha upéi katu nhande pytu'uha áry-py oho ogwata Hesu. Trigoty mbyte-rupi oho ogwata. Ha hemimbo'e kwéry katu ivare'a-ma oho-vy. Upéa-gwi oipo'o-ma oho-vy trigo rope ho'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Upéa ohexa ramo fariseu kwéry, he'i: —Ema'ẽ hese, he'i íxupe. —Ma'erã po ne remimbo'e oipo'o trigo rope pytu'uha áry-py? Yma gware reko-rupi ndoikóiry. Pytu'uha áry-py oipo'o ramo, ndatekoháiry ogwereko, he'i íxupe fariseu kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Upe-ma ramo Hesu he'i: —Pemonhe'ẽ nhe'ẽ rei peiko-vy ndapeikwaáiry Davi amyrĩ rehegwa nhe'ẽ kwatia-rehe omoĩ va'ekwe, he'i. —Nahembi'úi-gwi, ivare'apa va'ekwe Davi oirũ kwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Upéa-gwi oike koty-py va'ekwe, Nhandejáry-pe nhamboete haty-py oike va'ekwe. Oĩ upe-py upe mbojape Nhandejáry rovagwy-py pa'i remimoĩgwe. Nhandejáry nhe'ẽ-py ndaja'úi voi upe mbojape. Ha pa'i kwéry anho mante ho'u arã. Ha Davi katu pa'i e'ỹ ramo jepe, ho'u joty upe mbojape. Omongaru joty ave oirũ kwéry-pe. Ivare'a-gwi, Nhandejáry, “Pejejavy ko” nde'íry íxupe. Ojohu porã hembiapokwe, ogwerovy'a ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pemonhe'ẽ nhe'ẽ rei peiko-vy ndapeikwaái Moisés amyrĩ remimombe'ukwe nhane rekorã. Ndatekoha-ramiry jaiko nhamba'apo ramo pytu'uha áry-py. Ha pa'i kwéry katu omba'apo joty pytu'uha áry-py. Nhandejáry róga kakwaa-py omba'apo. Upe áry-py omba'apo ramo jepe, Nhandejáry, “Pejejavy ko” nde'íry joty íxupe. Pytu'uha áry-py omba'apo ramo Nhandejáry róga-py, ojohu porã joty huvixa kwéry hembiapo. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","—Ha xe katu xe mbaraeteve Nhandejáry róga ruvixa kwéry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","8","Xe Nhande Ryke'y tee va'e. Upéa-gwi xe ko pytu'uha áry járy ave. Upéixa-gwi iporã joty xe amba'apo pytu'uha áry-py. He'i Nhandejáry kwatia nhe'ẽ: “Ha peẽ katu ndapejoporiahuvereko kwaáiry peiko-vy. Aipo ramo, pene kyre'ỹ ramo jepe pejapo hagwã Moisés amyrĩ remimombe'ukwe gwive, pejapo rei joty. Xe aipota ae katu pende py'a porã onhondive” he'i Nhandejáry nhe'ẽ. Upéa kwatia nhe'ẽ pemonhe'ẽ rei peiko-vy, ndapeikwaáiry. Ne arandu ramo ra'e, ipy'a potĩ va'e-rehe, “Ipy'a ky'a” nde'íry arã ra'e, he'i fariseu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Upe-gwi Hesu ohasave oho-vy ojeporahéi haty-py oike oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Upe-py oĩ ipo ypi va'e. Ha fariseu kwéry, “Hembiapo vai va'e upe va'e” he'ise Hesu-rehe. Upéa-gwi oporandu íxupe hikwái: —Tekoha-rami pa jaiko ra'e nhambogwera ramo pytu'uha áry-py? he'i ombojase rei hese-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ha Hesu he'i: —Pytu'uha áry-py pene rymba ovexa ho'a ramo yvy kwa-py, ndapeheja reíry va'erã, he'i íxupe kwéry. —Pehupi jevy va'erã ae heraha-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","—Ovale voi nhane rymba ovexa. Ha tekove hasy va'e katu ovaleve voi ovexa-gwi. Ovaleve voi. Upéa-gwi pytu'uha áry-py nhaipytygwõ ramo nhande rapixa, tekoha-rupi joty jaiko, he'i fariseu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Upéa he'i rire: —Eipyso katu nde po, he'i ipo ypi va'e-pe. Oipyso-ma, okwera porã-ma. Ijoja-ma ipo mokõive. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ha fariseu kwéry ndojohu porãi hembiapo porã va'e. Osẽ oho-vy ha'e kwéry nhemi ha-py: —Mba'éixa tamo ra'e jajuka Hesu-pe? he'i. —Nhaha'arõ jajuka hagwã íxupe, he'i onhonhe'ẽrendu-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Upéa oikwaa ramo Hesu, otekwarai-ma oho-vy outro henda-py. Otekwarai oho jave, heta va'e ave oho hapykwéri. Heta va'e-pe ombogwera gwera oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ombogwera-ma ramo, “Aníke xe mombe'u teĩ” he'i okwera va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Upéixa ojapo ãy oiko hagwã Nhandejáry nhe'ẽ-py omombe'u va'ety Isaías amyrĩ he'i hagwe-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","A-rami voi omoĩ va'ekwe kwatia-rehe: “Upe va'e xe rembigwái, xe rembiporavo va'e. Ha'e xe rembihayhu. Xe rembierovy'a va'e upéa. Xe Nhe'ẽ Marangatu amoĩ-ta hese. Omombe'u va'erã entéro yvypóry-pe gwive. Nhandejáry pende py'a omopotĩharã, he'i va'erã xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ipoxy va'e onhonhe'ẽ mbojevy jevyha va'e-rami ndoikói va'erã. Osapukái va'e-rami ndoikói va'erã. Okirirĩ va'e-rami ae oiko va'erã. Atýra-py nohendúi va'erã íxupe onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Heko kirirĩ va'erã. Takwáry, Xýky, he'i heseve va'e nomopẽi va'erã. Upéixa opena va'erã iporiahu va'e-rehe. Tataendy ogwe-tama ramo, imbogwe e'ỹharã. Upéixa ete onhemboete e'ỹ va'e-pe ogwereko porã va'erã. Upéixa hembiapo porã porã va'erã. Ndovái va'erã Nhandejáry rape-gwi. Opa-rupi ojekwaa va'erã anhetegwa. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hese ojerovia-ma va'erã yvypóry kente kwéry: Nhaha'arõ katu íxupe jaiko-vy. Ou va'erã, he'i va'erã hese” he'i va'ekwe Nhandejáry kwatia nhe'ẽ gwa'ýry rehegwa omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Upe ramo ojereru íxupe, Hesu-pe peteĩ anháy rerekoha. Hesapyso e'ỹ va'e, inhe'ẽnge'ỹ va'e ave. Ombogwera-ma ramo íxupe, inhe'ẽnge'ỹ va'ekwe onhe'ẽ porã-ma, ha hesapyso e'ỹ va'ekwe hesapyso porã-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hembiapo porã rexa-vy, —Mba'éixa po oporombogwera, he'i ojóupe opondera-vy hese. —Upéa ko ndaha'éi para'e Davi amyrĩ remiarirõre, nhane remiha'arõ? he'i hese ijaty jaty va'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ha fariseu kwéry katu upéa ohendu ramo: “Ojéhegwi rei ndaipu'akái omosẽ hagwã anháy” he'i. “Anháy ruvixa Belzebu nhe'ẽ-rupi ae omosẽ imondo-vy” he'i mo'ã ojéupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ha ha'e ipy'apóry oikwaa ramo, he'i fariseu kwéry-pe: —Tape vai-rupi oho mburuvixagwasu re'ýi onhondive onhorairõ-vy. Naimbaraetevéi-ma. Tetã mygwa ndaija'éi ramo ojóehe, hóga pygwa ave ndaija'éi ramo ojóehe, tape vai-rupi oho. Hasy va'e-rami ndaipu'akavéi-ma ójehe. Ikangyve ngyve oho-vy, he'i arandu rehegwa nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","—Aipo ramo, gwĩ Satanás re'ýi kwéry ave ndaijojái ramo, ndoikovéi arã ra'e. Ndaijojái arã onhondive ra'e. Aipo ramo, ndaipu'akái arã joty ójehe ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","—“Belzebu nhe'ẽ-rupi omosẽ anháy” peje kuri xe-rehe. Aipo ramo, kiva'e nhe'ẽ-rupi pende re'ýi kwéry omosẽ anháy? Anháy ruvixa nhe'ẽ-rupi para'e, Nhandejáry nhe'ẽ-rupi para'e. Ha Nhandejáry nhe'ẽ-rupi omosẽ ramo katu, ma'erã po, “Anháy ruvixa nhe'ẽ-rupi hembiapo Hesu” peje kuri joty xe-rehe. “Ijapu” he'i va'erã pende-rehe pende re'ýi kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","—Ha Nhandejáry Nhe'ẽ Marangatu tee va'e-rupi katu xe amosẽ anháy. Aipo ramo, xe rekoha-rehe pehexa kwaa ramo ra'e, “Oiko-ma nipo ra'e Nhandejáry nhande ruvixa ramo” peje arã ra'e xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Amombe'u jevy-ta peẽ-my xe pu'akaveha Satanás-rehe. Ndikatúi avave oike imbaraete va'e róga-py omonda hagwã imba'e kwéry-rehe. Onhapytĩ ranhe ramo ae íxupe, ogwerahapa arã hóga-py oĩ va'e, he'i Hesu anháy rerekoha ombogwera-vy pono ipu'akave hese Satanás. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Upéi he'i jevy: —Xe ndive omba'apo e'ỹ va'e, ojoko xe rembiapo. Xe renda-py ogwenogwa'ẽ e'ỹ va'e, xe renda-gwi omondo mombyry omosarambi-vy, he'i ójehe ndaija'éi-gwi Satanás. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Upéi he'i jevy: —Aipo ramo, anhete ko xe ha'e-ta peẽ-my: Ne rembiapo vai ramo, erenhe'ẽ vai ramo Nhandejáry-rehe, omboyke-ta ndéhegwi Nhandejáry entéro ne rembiapo vaikwe gwive. Erenhe'ẽ vai ramo ave xe Nhande Ryke'y tee va'e-rehe, omboyke-ta ndéhegwi ne rembiapo vaikwe. Ha erenhe'ẽ vai ramo katu Nhe'ẽ Marangatu tee va'e-rehe, nande poriahuvereko mo'ãiry Nhandejáry. Nde py'a ky'a eterei-ma. Ãy nande py'a potĩ mo'ãvéi-ma va'erã. Ha upe áry-py xe aju jevyha áry-py nande py'a potĩvéi-ma va'erã opa e'ỹ-rehe, he'i fariseu kwéry-pe, “Anháy nhe'ẽ-rupi hembiapo ra'e Hesu” he'i-gwi Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Upéi omombe'u íxupe kwéry arandu rehegwa nhe'ẽ yva máta rehegwa-rami: —Yva máta jaikwaa hi'a-rehe. Yvyra porã hi'a porã meme. Ha yvyra vai ndahi'a porãi. Hi'a vai meme voi. Hi'a-rehe jaikwaa yvyra, he'i fariseu rekoha-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Upéi he'i jevy Hesu: —Peẽ mbói ipoxy va'e rekoha-rami peiko. Pende reko vai-gwi, ndikatúi penhe'ẽ porã. Nhande py'apóry-rehe nhande nhanhe'ẽ. Entéro nhande py'a-py jareko va'e-rehe, nhanhe'ẽ ave nhande. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ipy'a-py hekoha porã va'e reminhongatu iporã. Upe-gwi ogwenohẽ nohẽ ipy'apóry iporã va'e. Ha hekoha vai va'e reminhongatu ipy'a-py katu, ivai vai. Upe-gwi ogwenohẽ nohẽ ojéhegwi ivai va'e. Ipy'apóry ivai va'e ogwenohẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Amombe'u-ta peẽ-my anhetegwa va'e. Upe áry-py yvypóry gwive hembiapo apokwe-rami ojerereko hagwã áry-py, ogwereko asy va'erã onhe'ẽ rei rei va'e-pe. Peteĩ teĩ pene remimombe'ukwe rei-rehe pene monhe'ẽ uka va'erã Nhandejáry pende rereko asy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Erenhe'ẽ porã ramo, “Ipy'a potĩ-ma” he'i va'erã nde-rehe. Ha erenhe'ẽ rei ramo katu, “Ipy'a ky'a-ma” he'i va'erã nde-rehe, he'i gwĩ fariseu kwéry-pe hekoha mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Upe ramo oporandu Hesu-pe gwĩ fariseu kwéry, judeu rekombo'ehaty kwéry ndive: —Oroipota ne rembiapo porã, porombo'eháry, he'i íxupe. —Ore rembiexarã-rupi ejapo jahexa e'ỹ va'e, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Upéi Hesu he'i íxupe kwéry: —Peẽ katu ãy peiko va'e pende reko vai-ma. Ome tee-pe oheja va'e-rami peẽ peiko. Gwembireko tee-gwi opoi va'e-rami ave peẽ peiko. Pejehesa rerova rova va'e Nhandejáry-gwi. Upéa-gwi pejerure jahexa e'ỹ va'erã-rehe, he'i. —Ha ndahexa uka mo'ãi peẽ-my upeixagwa, he'i. —Ha Jonas amyrĩ rehegwa nhe'ẽ ojehu íxupe va'ekwe katu amombe'u-ta peẽ-my. Hexapyrã-rupi íxupe ojehu va'ekwe-rami ave, ojehu va'erã xe-vy. Upe va'erã anho mante ahexa uka-ta peẽ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","—Amombe'uve-ta peẽ-my Jonas amyrĩ rehegwa nhe'ẽ. Yma va'ekwe piragwasu omokõ-ma íxupe, Jonas-pe. Ha upe rire katu piragwasu rye py-py ohasa mbohapy áry mbohapy pyhare ave. Upéi osẽ jevy. Upéixa ete xe Nhande Ryke'y tee va'e anhemoĩ va'erã itagwasu kwa-py mbohapy áry mbohapy pyhare ave ko itagwasu rye py-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ha yma gware Jonas amyrĩ oho va'ekwe Nhandejáry nhe'ẽ omombe'u-vy. Nínive tetã mygware-pe omombe'u mbe'u va'ekwe. Upe nhe'ẽ ohendu ramo va'ekwe omboasy-ma gwembiapokwe, ogwerova-ma gwekoha va'ekwe. Ha ko'a-rupi oime tuvixa mba'eve va'e Jonas amyrĩ-gwi, he'i ójehe Hesu íxupe kwéry. —Ha xe nhe'ẽ rendu-vy jepe, ndaperovái joty pende rekoha ra'e. Upéa-gwi upe áry-py, yvypóry hembiapokwe pokwe-rami ojerereko hagwã áry-py, Nínive tetã mygware opu'ã jevy va'erã Nhandejáry rovagwy-py pene mombe'u-vy, he'i. —Ojohu vai va'erã pene rembiapokwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Yma va'ekwe peteĩ mburuvixagwasu kunha va'e arapopy-koty oiko va'ekwe, oho mombyry va'ekwe mburuvixagwasu Salomão renda-py. Onhemo'arandu uka-vy oho. Yvy apy gwive mombyry ete oho va'ekwe ohendu hagwã Salomão nhe'ẽ. Ha ko'a-rupi oime hi'aranduve va'e Salomão-gwi, he'i ójehe Hesu. —Upéa-gwi upe áry-py opu'ã jevy va'erã upe mburuvixa kunha Nhandejáry rovagwy-py pene mombe'u-vy. Pene rembiapokwe ndojohu porãi va'erã, he'i judeu ruvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Upéi he'i jevy upe pygwa-pe: —Mba'eixagwa pa pende rekoha amombe'u-ta peẽ-my. Anháy rerekoha-rami pende rekoha. Oĩ anháy heko ky'a va'e nhande-rehe ojepotase va'e. Ha ojepota rire osẽ-ma ramo katu oiko rei anháy tekwaty e'ỹ e'ỹha-rupi, y e'ỹha-rupi ohasa oho-vy. Otongease mo'ã ha ndojohúiry opytu'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Upe ramo he'i ojéupe anháy: “Aha jevy-ta xe taperekwe-py, aiko hagwe-py jevy” he'i. Ojevy oho-vy otaperekwe-py. Otaperekwe-py ogwahẽ ramo upe-py otopa nandi oĩ. Ikoty oitypei ra'e. Omoĩ porãmba ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Upe-ma ramo oho ogweru outro anháy hekoha vaive va'e íxugwi. Seteve ogweru. Hi'oitoha ojogweru, oike koty-py oiko hagwã. Upéixa oiko vaive anháy rerekoha. Osẽ rire íxugwi peteĩ anháy, hejahare oike jevy ipy'a-py. Sete hekoha vaive va'erã reraha-vy oike. Xe nhe'ẽ rendu e'ỹ-gwi, upéixa ete peiko va'erã. Peẽ, ãy peiko va'e, upe anháy rerekoha-rami peiko va'erã, he'i fariseu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Upéa he'i joty ramo Hesu atýra-rupi, ogwahẽ ou-vy isy tyvýry kwéry ndive. Opyta oĩ-vy oka-py. Onhomongetase hendive. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","—Nde sy ko nde ryvy kwéry ndive opyta oĩ-vy oka-py. Ne ndive onhomongetase, he'i íxupe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ha Hesu he'i: —Amombe'u-ta peẽ-my kiva'e pa xe sy, kiva'e pa xe ryvy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","—Pehexa katu, he'i oikwave'ẽ ve'ẽ-vy ojyva-py gwemimbo'e rexa uka-vy. —Ko va'e kwéry xe sy voi, ko va'e kwéry xe ryvy voi, he'i gwemimbo'e kwéry mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","—Upe xe Ru yváy pygwa nhe'ẽ ojapo va'e gwive, xe ryvy-py ahenói íxupe kwéry, he'i. —Upéa xe reindy, ha'e voi hese. Upéa xe sy, ha'e voi ave hese, he'i gwemimbo'e kwéry-rehe mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ha upe áry-py Hesu osẽ óga-gwi oho-vy. Oho yugwarusu rembe-py ogwapy ombo'e hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ha heta eterei ijatypa typa henda-py. Upéa-gwi onhemboyru kanoagwasu-py íxugwi kwéry. Kanóa py-py ogwapy-ma. Ha ha'e kwéry ijaty va'e kente opyta rei yvy-py. Onhembo'y oĩ-vy y rembe-py hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Upéixa ramo, heta omombe'u mbe'u íxupe kwéry arandu rehegwa nhe'ẽ. Temitỹgwe rehegwa nhe'ẽ-rami oiporu omombe'u hagwã arandu rehegwa nhe'ẽ íxupe kwéry: —Oho onhemitỹ onhemitỹ va'e. Omombo onhotỹ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Onhemitỹ jave oĩ temitỹ ra'ỹi tape-rupi ho'a va'e. Ha upéi ou gwyra ho'upa. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oĩ temitỹ ra'ỹi ave yvy pererĩ-rupi ho'a va'e. Upe-py oĩ mixĩmi yvy. Pya'e rei henhói-ma yvy ndahetáiry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kwarahy ojeupi rire, onhandu kwarahy aku hemitỹgwe. “Xĩ” he'i hogwe. Ha kwarahy ohapypa voi. Hovirupa ave ndahapói-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oĩ nhuatĩndy-rupi ho'a va'e ave. Ha nhuatĩ katu okakwaave íxugwi. Ojaho'ipa temitỹgwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Oĩ yvy porã-my ho'a va'e ave. Henhói hemitỹ hope-ma. Peteĩ hope katu cem voi ha'ỹi va'e, outro mixĩve va'e katu sessenta ha'ỹi va'e voi, outro mixĩve va'e katu trinta ha'ỹi va'e voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ne aranduse va'e, ejeapysaka katu ko xe nhe'ẽ-rehe, he'i oporombo'e-vy Hesu temitỹgwe rehegwa nhe'ẽ oiporu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Upéi hemimbo'e kwéry ogwahẽve ou-vy Hesu ypy-py: —Ma'erã po eremombe'u kuri íxupe arandu rehegwa nhe'ẽ temitỹgwe rehegwa nhe'ẽ-rami? he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","—Peẽ-myte oikwaa uka-ma kuri Nhandejáry mba'éixa pa oiko-ta pende ruvixarã. Mba'éixa po pemoirũ-ta íxupe pende ruvixarã oikwaa uka-ma ave. Ha ambue kwéry-pe katu ndoikwaa ukái. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Oĩ hi'arandu va'e. Omo'aranduve va'erã íxupe hi'arandu porã porã hagwã. Ha inharandu e'ỹ va'e katu, hi'arandurãgwe oipe'apa va'erã íxugwi. Opa va'erã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Upéa-rehe amombe'u íxupe arandu rehegwa nhe'ẽ temitỹ rehegwa nhe'ẽ-rami, he'i. —Oma'ẽ ma'ẽ hikwái, ndohexáiry voi mba'eve. Ohendu hendu hikwái, nohendu porãiry. Ijapysa e'ỹ va'e-rami mba'eve ndoikwaái. Okanhymba ete jevy íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yma gware Nhandejáry nhe'ẽ-py omombe'u va'ety Isaías omombe'u va'ekwe aỹgwa rekorã. He'i hagwe-rami ãy oiko-ma: “Pehendu hendu va'erã ha ijapysa e'ỹ va'e-rami pepyta va'erã. Pema'ẽ ma'ẽ rei va'erã xe-rehe ha ndapehexa kwaái va'erã xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Napehenduséi-gwi, aipe'a-ma pendéhegwi pene arandurãgwe. Ijapysa e'ỹ va'e-ramima peiko peẽ kwéry. Hesapyso e'ỹ va'e-rami ave peiko. Ha xe renduse ramo katu, hesapyso va'e-rami peiko va'erã. Ijapysa va'e-rami pehendu va'erã ave. Pene akã-my pereko-ma va'erã pene arandu porãha. Perova arã pende rekoha. Pende rekoha perova-ma ramo, apombogwera-ma va'erã, he'i Nhandejáry.” Upéixa he'i Nhandejáry kwatia nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ha peẽ katu pevy'a ete va'erã. Ãy katu peẽ hesapyso va'e-rami peiko-ma. Ijapysa va'e-rami ãy peẽ peiko-ma ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Amombe'u-ta peẽ-my anhetegwa va'e, he'i. —Heta yma gware Nhandejáry nhe'ẽ-py omombe'u va'ety amyrĩ ohexase eterei mo'ã va'ekwe pene rembiexa ramo va'e ha ndohexái. Heta va'ekwe heko marangatu va'ekwe amyrĩ ohexase mo'ã va'ekwe ave ha ndohexa jepéiry. Ãy pene remiendu ramo va'e ohenduse mo'ã va'ekwe ha nohendúiry. Peẽ pehendu-gwi pevy'a ete voi peiko-vy, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Upéi he'i jevy gwemimbo'e kwéry-pe: —Ãy pejeapysaka katu xe nhe'ẽ-rehe. Mbava'e-rehe po he'ise temitỹgwe rehegwa nhe'ẽ aikwaa uka-ta peẽ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","—Upe tape-rupi onhenhotỹ va'ekwe he'ise: Oĩ Nhandejáry nhande ruvixarã rehegwa nhe'ẽ ohendu va'e ha he'ise va'e ndoikwaáiry. Ohendu-ma ramo, ou anháy ruvixa hekoha vai ete va'e. Oipe'apa-ma íxugwi ipy'a-gwi inharandu porãrãgwe. Oike-tama va'e oipe'a jevy íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ha yvy pererĩ-rupi onhenhotỹ va'ekwe katu he'ise: Oĩ ohendu va'e nhe'ẽ porã. Ohendu-ma ramo, ovy'a ogwerovia-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ha ndahapóiry vyteri. Upéa he'ise: Sapy'a ete ogwerovia. Ndogwerovia teéiry voi. Ha upe rire katu nhe'ẽ porã rendu-gwi, omoingo asy íxupe. Ojerereko asy-gwi, ndogweroviasevéiry. Pya'e a'e oheja nhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ha nhuatĩndy-rupi onhenhotỹ va'ekwe katu he'ise: Oĩ nhe'ẽ porã rendu va'e. Ha hemikotevẽrã-rehe opena pena eterei oiko-vy. Oipotave tave rei ojéupe gwarã. Upéa-gwi ohendu rei joty nhe'ẽ porã. Hembiapo porãse ramo jepe, gwembiapo porãrã-rehe nopenái joty oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ha yvy porã-my onhenhotỹ va'ekwe katu he'ise: Oĩ ohendu va'e nhe'ẽ porã. Ohendu ramo mbava'e-rehe po he'ise oikwaa porã. Ogwerovia tee voi. Ogwerovia-gwi, oĩ trinta ha'ỹi va'e-rami hembiapo porã va'e. Oĩ sessenta ha'ỹi va'e-rami, hetave ogwereko va'e gwembiapo porãha. Oĩ cem ha'ỹi va'e-rami, hetave rei voi ogwereko va'e gwembiapo porãha, he'i omombe'u-vy gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Upéi omombe'u jevy upe pygwa-pe arandu rehegwa nhe'ẽ. Temitỹgwe rehegwa nhe'ẽ-rami oiporu omombe'u-vy: —Oiko onhemitỹ va'e, he'i. —Nhandejáry nhande ruvixa-rehe he'ise onhemitỹ va'e. Ha'e oho kokwe-py onhemitỹ porã hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","—Upéi nhande kwéry jake ramo pyhare, ogwahẽ ou-vy hese ija'e'ỹ va'e. Trigo pa'ũ-rupi onhotỹ trigo rehegwa e'ỹ va'e. Kapi'i onhotỹ. Ha upe rire katu oho jevy-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Henhói-ma upe trigo onhenhotĩ va'ekwe. Upéi hope-ma. Upe ramo henhói-ma ave upe kapi'i trigo rehegwa e'ỹ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Henhói-ma ramo, oho oje'ói-vy omombe'u ojáry renda-py hembigwái: “Upe nde kokwe-py erenhotỹ uka va'ekwe ne remitỹgwe trigo ra'ỹi voi ra'e” he'i. “Mba'eixagwa kapi'i po trigo pa'ũ-rupi henhói-ma erejaty e'ỹ va'ekwe” he'i ojáry-pe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Xe rehe ija'e'ỹ va'e rembiapokwe voi nipo ra'e aipo va'e” he'i gwembigwái-pe. “Ereipota tipo ore oroho oromondoro trigo pa'ũ-gwi gwĩ kapi'i?” he'i oporandu-vy ojáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ndikatúiry” he'i. “Aníke pejapo teĩ upéa. Pemondoro ramo kapi'i, ndaipotái pemondoro ave upe trigo onhenhotỹ va'ekwe” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Tokakwaa kapi'i trigo jave nhaikytĩ hagwã áry peve. Upe áry-py ha'e va'erã trigo kytĩharã-pe: Pemondoro ndoro ranhe katu kapi'i. Pemboaty aty pejokwa pehapy hagwã. Ha upe rire katu pemondoro trigo pemboaty jaraha hagwã nhanhongatu hagwã-py” he'i Hesu omombe'u-vy Nhandejáry irũ rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ha upéi omombe'u jevy upe pygwa-pe arandu rehegwa nhe'ẽ. Temitỹgwe rehegwa nhe'ẽ-rami oiporu: —Oĩ temitỹ héry va'e mostarda. Kwimba'e onhotỹ peteĩ temityrã okokwe-py. Nhandejáry nhande ruvixa irũ-rehe he'ise upe temitỹ mostarda. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nhanhotỹ ramo mixĩ eterei. Mixĩve opamba'e ra'ỹi-gwi, ko yvy arigwa ra'ỹi-gwi. Ha nhanhotỹ-ma rire, okakwaa porãve. Entéro temitỹ-gwi tuvixave xave oho-vy. Upéi imáta-ma, hakãmbe kãmbe ave. Upéa-rehe oveve ou-vy gwyra ogwapy hakãmby-rehe, he'i Hesu, Nhandejáry irũ hetave tave oĩ va'erã rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ha upéi katu omombe'u jevy joty upe pygwa-pe arandu rehegwa nhe'ẽ. Fermento mbojape mbovuha rehegwa nhe'ẽ-rami oiporu: —Oĩ kunha. Oipyhy mbojape mbovuha. Heta trigo ku'i reheve ombojehe'a ombovu hagwã. Ojavyky rire, omboapitajy ovupa ete hagwã. Upéixa ete Nhandejáry nhande Ruvixa irũ, he'i Hesu, Nhandejáry irũ hetave tave oĩ va'erã rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Upéixa omombe'u mbe'u aty atýra va'e kente kwéry-pe. Temitỹgwe rehegwa nhe'ẽ oiporu e'ỹ reheve, fermento mbojape mbovuha rehegwa nhe'ẽ oiporu e'ỹ reheve, outro rehegwa nhe'ẽ oiporu e'ỹ reheve nomombe'úi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Upéixa oiko-ma Nhandejáry nhe'ẽ-py omombe'u mbe'u va'ety he'i hagwe-rami: “Anhe'ẽ ramo, arandu rehegwa nhe'ẽ amombe'u va'erã, ambue kwéry va'e rehegwa nhe'ẽ aiporu-vy. Yma ko yvy onhemoingo hagwe gwive ãy peve ndojekwaáiry va'ekwe, ãy amombe'u-ta aikwaa uka-vy, he'i.” Upéixa he'i Nhandejáry kwatia nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ha upéi katu oheja oho-vy ijaty va'e kente. Ha'e ae katu oike koty-py. Oike rire, ogwahẽ ou-vy iha-py hemimbo'e kwéry: —Eikwaa uka katu ore-vy mbava'e-rehe tipo he'ise upe kapi'i rehegwa nhe'ẽ, kokwe-py oĩ va'e, he'i Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","—Upe temitỹ porã onhotỹ uka va'ekwe he'i xe-rehe Nhande Ryke'y tee va'e-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","—Upe kokwe he'i ko yvy-rehe. Upéi upe temitỹ porã he'i Nhandejáry re'ýi-rehe. Upéi upe kapi'i he'i hekoha vai va'e-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Upéi upe hese ija'e'ỹ va'e kapi'i onhotỹ va'ekwe he'i anháy ruvixa-rehe. Upéi upe nhaikytĩha áry he'i ombopapa va'erãha áry-rehe. Upéi upe trigo kytĩharã he'i Nhandejáry rembigwái yváy pygwa-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Upe kapi'i omondoro omboaty onhapytĩ omondo hagwã tata-py. Upéixa ete oiko va'erã ombopapa va'erãha áry-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","—Xe Nhande Ryke'y tee va'e amondo mondo va'erã xe rembigwái yváy pygwa va'e. Xe re'ýi pa'ũ-gwi oipe'a va'erã gwĩ oporombojejavy va'e-pe gwive. Entéro hembiapo vai va'e-pe gwive oipe'a va'erã heraha-vy ojohapy haty-py omombo hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Upe-py hasẽ va'erã, onhemohãingyry ngyrýu ave va'erã oiko-vy onhemoyrõ-gwi Nhandejáry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Upe-ma ramo hekoha porã va'e gwive kwarahy rendy-rami ojekwaa va'erã onhembohete resakã rendy-vy. Nhandejáry nhande ruvixa ramo oiko haty-py, ojekwaa va'erã onhemohesakã va'erã. Ne aranduse va'e, ejeapysaka katu ko xe nhe'ẽ-rehe, he'i Hesu gwemimbo'e kwéry-pe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Upéi omombe'u jevy íxupe, upe pygwa-pe mokõi arandu rehegwa nhe'ẽ. Hepy va'e rehegwa nhe'ẽ-rami oiporu omombe'u-vy: —Oĩ kokwe-py heta plata yvy gwy-py ijatypyre araka'e. Upe ramo ojohu rei íxupe ijáry e'ỹ va'e. Upe hepy va'e ojohu va'e he'i Nhandejáry nhande ruvixa-pe omoirũse va'erã-rehe. Otopa-ma ramo, upéi ojaty jevy. Ovy'a eterei ojohu va'ekwe-rehe. Upéa-gwi oho ovende entéro ogwereko va'e gwive ovendepa. Upe hemivende va'e repykwe ogweraha ojogwa hagwã upe kokwe, he'i Hesu omombe'u-vy, Nhandejáry-pe oate'ỹ e'ỹ reheve omoirũse va'e rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Upéi omombe'u jevy íxupe: —Oĩ onhemba'ejogwa va'ety. Oheka heka oiko-vy ita kyra porã va'e, hepy ete va'e, pérola héry va'e ojogwa hagwã. Upe hepy va'e oheka va'e he'i Nhandejáry nhande ruvixa-pe omoirũse va'erã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iporã ete va'e otopa ramo oho ovende entéro gwembiereko gwive ovendepa. Upéi hemivende va'e repykwe ogweraha. Gwemimbota nga'u upéa oho ojogwa, he'i Hesu omombe'u-vy, Nhandejáry-pe oate'ỹ e'ỹ reheve omoirũse va'e rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Upéi omombe'u jevy upe pygwa-pe arandu rehegwa nhe'ẽ. Pira kyha rehegwa nhe'ẽ-rami oiporu íxupe kwéry: —Oĩ pira kyha y-py omombo va'e. Upe omombo va'e he'i Nhandejáry nhande ruvixa rembigwái yváy pygwa-rehe. Yupa-py omombo rire, oipyhy opaixagwa pira. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hynyhẽ jave oipyhy ogwenohẽ y rembe'y-py. Upéi ogwapy oipe'a oiporavo imono'õ-vy. Pira porã omoĩ ajaka-py. Ha hi'upy e'ỹ katu omombo-ma voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Upéixa ete oiko va'erã ombopapa va'erãha áry-py. Nhandejáry rembigwái yváy pygwa oiporavo ravo va'erã oje'ói-vy. Hekoha porã va'e pa'ũ-gwi, oipe'a va'erã hekoha vai va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ojohapy haty-py omombo va'erã íxupe kwéry. Upe-py hasẽ hasẽ va'erã oiko-vy. Nhandejáry-rehe onhemoyrõ-gwi, onhemohãingyry ngyrýu ave va'erã oiko-vy ave, he'i omombe'u-vy ombopapa va'erãha áry oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ko'ã va'e he'i rire, oporandu gwemimbo'e kwéry-pe: —Mbava'e-rehe po he'i ko'ã va'e? Peikwaa-ma tipo? he'i. —Ha'e voi, he'i. —Oroikwaa-ma, he'i íxupe, Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","—Aipo ramo, gwĩ judeu rekombo'ehaty va'e iporã oiko Nhandejáry nhande ruvixa remimbo'e ramo. Ambo'epa rire íxupe, oiko va'erã óga járy-rami. Hóga-py oĩ heminhongatu pyahu va'e, oĩ heminhongatu tuja va'e ave. Oipota ramo, gweminhongatu pyahu ogwenohẽ va'erã. Oipota ramo, gweminhongatu tuja ogwenohẽ va'erã ave. Upéixa ete upe judeu rekombo'ehaty Nhandejáry nhande ruvixa remimbo'e oiko ramo, nhe'ẽ pyahu omombe'u va'erã oikwaa uka-vy, yma gware nhe'ẽ omombe'u va'erã ave, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Arandu rehegwa nhe'ẽ omombe'upa rire, upe-gwi osẽ oho-vy gwetã-my ha'e ae oiko ha-py. Upe-py ojeporahéi haty-py ombo'e mbo'e gwe'ýi kwéry-pe. Hexapyrã-rupi ombo'e porã oiko-vy. “Mba'éixa onhemonhe'ẽ” he'i opondera-vy hese. —Mamo-gwi po upéa ohendu aipo va'e nhe'ẽ? he'i hese. —Kiva'e omombe'u hi'arandu hagwã íxupe, he'i hese. —Hexapyrã-rupi voi Hesu hembiapo porã. Kiva'e po omombe'u íxupe ojapo hagwã upéa? he'i joa hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—Upéa óga apohaty ra'y voi, he'i. —Maria memby voi. Tiago José ndive, Simão Judas ndive ityvýry kwéry voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Heindýry kwéry oiko voi nhane pa'ũ-rupi. Aipo ramo, mamo-gwi po upéa ohendu aipo va'e nhe'ẽ? he'i joa Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","—Onhembotuvixa mba'e-ta tipo nhande-vy ra'e? he'i hese he'ýi kwéry. Upéa-gwi ndaija'éi hese hikwái. Upe ramo, —Nhandejáry nhe'ẽ-py omombe'u va'ety-pe omboete voi. Ha he'ýi kwéry katu nomboetéi íxupe. Anheigwa nde'íry hese hóga pygwa omboete e'ỹ-vy, he'i ójehe Hesu omombe'u-vy, ndaija'éi-gwi ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Upe-py hese ndojeroviái-gwi, ndahetái hembiapo porã hexapyrã-rupi upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Upe ramo, ohendu Hesu rerakwã mburuvixagwasu héry va'e Herodes. Galiléia yvy pygwa ruvixa voi upéa. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Hesu rerakwã ohendu ramo he'i, —Upéa João Batista nipo ra'e. Omano rire, oikove jevy-ma ra'e, ojekwaa jevy-ma ra'e, he'i mo'ã hese. —Upéa-gwi hexapyrã-rupi hembiapo porã porã oiko-vy, he'i mo'ã oirũ-pe Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Yma va'ekwe Herodes he'i va'ekwe oipyhy hagwã João-pe, ojepokwa reheve omoĩ hagwã preso. Upéa ojapo va'ekwe ombovy'a hagwã gwyvýry Filipe rembirekokwe Herodias. Ha'e omenda ra'e gwyvýry rembireko-rehe. Oipe'a ra'e gwyvýry-gwi hembireko. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ha João katu he'i: —Tekoha e'ỹ-rupi ereiko ra'e ne rembireko ereipe'a va'ekwe nde ryvy-gwi, he'iri iri ra'e Herodes-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Upéa-gwi ojukase mo'ã João-pe. Ha kente kwéry katu he'i hese, “Upéa ko Nhandejáry nhe'ẽ-py omombe'u va'ety voi” he'i João-rehe hikwái. Ha mburuvixa katu opy'apy-py ikyhyje ójehe. Nombopoxyséi íxupe kwéry. Upéa-gwi ndojukái joty íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Ha upéi katu mburuvixa oiko hagweha áry-py, oike ojeroky henonde-py Herodias memby kunhataĩ. Mburuvixa irũ gwéry renonde-py ojeroky kunhataĩ. Ogwerovy'a eterei-gwi íxupe, kunhataĩ-pe, he'i mburuvixa: “Ne rembijerure va'e gwive ame'ẽ-ta nde-vy” he'i íxupe. Pono oapu “Tupã réry-py ame'ẽ-ta nde-vy” he'i. Nde'i reíry pe kunhataĩ ojeroky va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Upéi osy nhe'ẽ-rupi he'i: “Aipota ereme'ẽ xe-vy João Batista akãgwe. A-py ete enterove va'e resa-py eme'ẽ mani katu xe-vy nha'ẽ-py” he'i mburuvixa-pe kunhataĩ. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Upe-ma ramo omboasy eterei he'i va'ekwe. Ha “Tupã réry-py ame'ẽ-ta nde-vy” he'i-gwi imboviapyre resa-py katu, he'i joty ome'ẽ hagwã kunhataĩ-pe hembijerure ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","He'i oho hagwã onhakã'o João-pe onhemoĩ preso haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Upéi ogweruruka nha'ẽ-py inhakãgwe ome'ẽ kunhataĩ-pe. Ha kunhataĩ ogweraha osy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ha João remimbo'e ohendu ramo, ou hetekwe ogweraha. Ombosuru tetekwe renda-py ijaty-vy. Upe rire oho omombe'u Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","João rerakwã ohendu ramo, oho Hesu kanóa-py tekwaty e'ỹ-my oho. Ha'e anho oiko hagwã-py oho. Oikwaa ramo ihoha ijaty va'e kente, gwetã gwetã-gwi osẽ oje'ói-vy. Hapykwéri oje'ói ojohu jevy hagwã Hesu-pe. Yvy-rupi oje'ói. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ha Hesu ojehexa uka jevy ramo, ohexa-ma ijaty va'e kente-pe jevy oha-py: —Ogwahẽ ogwa'ẽ-vy ra'e, he'i hese kwéry. Ohexa ramo, —Aiporiahuvereko íxupe kwéry, he'i. —Aipo ramo, hasy va'e-pe ambogwera-ta, he'i. Upe rire ha'e ombogwera hasy va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Upéi ka'aru-ma. Ogwahẽ ou-vy hemimbo'e kwéry iha-py: —Ndaipóri a-py mba'eve, he'i. —Ka'aru-ma. Ere íxupe kwéry toho tetã mirĩ-rupi ojogwa hagwã gwemi'urã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ha ha'e he'i: —Natekotevẽiry oho okaru hagwã, he'i. —Peẽ ae peme'ẽ íxupe kwéry hemi'urã, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—A-py ndahetáiry oĩ mbojape'i. Cinco oĩ mixĩ va'e. Mokõi pira ka'ẽ hendive oĩ, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ha'e he'i: —Peru katu a-py, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Upéi he'i ijaty va'e kente-pe ogwapy hagwã kapi'ipe ári. Upéi oipyhy upe cinco mbojape'i mokõi pira ndive. Hovayva otima porã Nhandejáry-pe temi'urã-rehe. Upéi ombopopóy upe mbojape, ome'ẽ me'ẽ gwemimbo'e kwéry-pe. Ha hemimbo'e ome'ẽ ho'u va'erã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Enterovete okaru, hygwyatãmba-ma ave hikwái. Upéi hemimbo'e kwéry omono'õ no'õ hembi'u rembyre kwéry. Doze ajaka omohynyhẽ hembyre kwéry-gwi ho'upa e'ỹ va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Upe mbojape ho'u va'ekwe heta heta voi oĩ. Oĩ cinco mil kwimba'e ho'u va'e. Heta kunha ave okaru va'e, heta ave mitã okaru va'e ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Upe-ma ramo he'i gwemimbo'e kwéry-pe onhemboyru hagwã kanóa-py: —Tapeho mani katu peẽ xe renonde y rovái, he'i. —Xe ae, “Tapeho jevy katu pende ro nde róga-rupi” ha'e-ta ijaty va'e-pe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Omondopa rire, ha'e anho ojeupi oho yvyaty ári. Ojapo oração hagwã ojeupi oho-vy. Ka'aru ete-ma, pytũ-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Upe ramo mombyry oĩ yvy ete-gwi kanoagwasu. Henonde-gwi ou ramo yvytu, ndogwata porãi. Omopu'ã y omoapỹ apỹ kanóa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ko'ẽtĩ pytũ vyteri jave, oho kanóa oĩ va'e ha-py Hesu. Y ári-rupi rei ogwata oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Y ári-rupi ogwata oho-vy ramo, onhemondýi eterei hexa-vy hemimbo'e kwéry. “Arygwypóry” he'i mo'ã hese hikwái. Osapukái, onhemondýi eterei-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Upe-ma ramo ha'e he'i: —Ani erejapura teĩ. Xe ae ko, xe ko Hesu, he'i gwemimbo'e kwéry ombopy'agwapy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Upe ramo he'i Pedro: —Nde voi ramo ra'e, ere xe-vy, “Eju katu y ári-rupi rei xe ha-py ave” he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aipo ramo, —Eju y ári-rupi rei xe ha-py, he'i. Upéi osẽ Pedro kanóa-gwi, ogwejy y-py ogwata y ári-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ha yvytugwasu rexa-vy, imytu'e'ỹ ójehe. Oypy oho-vy y gwy-koty. Onheapymi-tama ramo: —Xe resende katu, xe Járy, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Upe-ma ramo oipyso opo oipyhy íxupe: —Mixĩ joty xe rerovia ra'e. Upe va'e-gwi ae nde erenheapymi-ta mo'ã. Ma'erã po nderejerovia teéiry ra'e xe-rehe ra'e? he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Onhemopyrũ jevy rire kanóa-py ndayvytuvéi-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Upéi kanóa pygwa onhesũ íxupe gwetypy'ã-rehe: —Tupã Nhandejáry ra'y tee katu va'e nipo nde ra'e, he'i íxupe imboete-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ha upéi katu ha'e ohasa oho-vy yugwarusu rovái. Genesaré yvy-py ogwahẽ oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Upe pygwa oikwaa ramo íxupe, omombe'u ojóupe ogwahẽmaha Hesu. Tetã jerekwe-rupi omombe'u mbe'u ogwahẽmaha Hesu. Ogweru entéro hasy va'e-pe gwive: ");
INSERT INTO kgkNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Eheja hasy va'e tomboja jepe opo nde ao rembe-rehe, eheja tomboja jepe opo nde ao-rehe, he'i Hesu-pe. Ha omboja va'e gwive opo hese, okwera-ma joty hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Upe ramo ogwahẽ ou-vy Hesu ha-py gwĩ fariseu kwéry, judeu rekombo'ehaty kwéry ndive. Jerusalém tetã-gwi ou va'ekwe. Ogwahẽ ramo hikwái, oporandu íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Ma'erã tipo ne remimbo'e ndoikói nhane rembypy reko-rupi? Ma'erã tipo ojepohéi porã e'ỹ reheve okaru? Ma'erã tipo nonhemopotĩsevéiry nhande kwéry e'ỹ va'e ndive oiko rire? he'i íxupe. Ha ha'e he'i: ");
INSERT INTO kgkNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","—Ha peẽ katu ma'erã tipo ndapejapói Nhandejáry he'i va'ekwe? Nderejaposéi voi nde ra'e Nhandejáry he'i va'ekwe. Ne rembypy rembiapokwe-rupi ae ereiko va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","—Nhandejáry he'i va'ekwe a-rami: “Pemboete nde ru nde sy-pe ave. Ha entéro onhe'ẽ vai rei va'e gwive gwu-rehe osy-rehe ave, tojejuka katu” he'i Nhandejáry kwatia nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ha peẽ katu pepyrũ Nhandejáry nhe'ẽ-rehe. Ndapehejáiry gwu osy-pe ome'ẽ hagwã. Pembo'e mbo'e rei judeu kwéry-pe a-rami. Peje, “Ava he'i ramo gwu osy-pe ave, Voive ereporandu ramo, ame'ẽ arã nde-vy ra'e. Ãy katu ndikatuvéi-ma ame'ẽ nde-vy. Xe mba'e kwéry opa-ma. Ame'ẽmba-ma kuri Tupã Nhandejáry-pe. Aiporu jepe xe, Tupã mba'epa-ma, he'i gwu osy-pe ave.” Upéixa he'i ramo, iporã joty peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Upéixa ndapehejái oipytygwõ gwu osy-pe ave. Ne nhe'ẽ-py gwu osy-pe nomboetevéi. Ne rembypy reko-rupi joty peiko. Upéa-gwi pepyrũ joty Nhandejáry nhe'ẽ-rehe, pemboyke joty Nhandejáry nhe'ẽ peiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Peẽ katu pemo'ã kwaa va'e pende py'a ky'aha. Napetĩ kwaáiry peẽ. Ha Isaías amyrĩ anheiha-rupi omombe'u va'ekwe pende rekorã. Omoĩ va'ekwe kwatia-rehe a-rami: ");
INSERT INTO kgkNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ha'e kwéry xe mboete onhe'ẽ-py rei. Opy'a-py katu naxe mboetéiry. Ndojehesa rerovái xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xe momba'egwasu teĩ. Xe nhe'ẽ-py nombo'éiry. Ha teko rei nhe'ẽ-py ae, oporombo'e mbo'e oiko-vy” he'i Nhandejáry kwatia nhe'ẽ pende-rehe, he'i judeu kwéry ruvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Upéi ohenói jevy ou hagwã ijaty va'e kente kwéry oha-py. He'i: —Pejeapysaka porã katu xe nhe'ẽ-rehe peikwaa porã hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","—Jakaru jave ndikatúi nhane mongy'a tembi'u. Nanhande py'a mongy'áiry voi tembi'u. Ha pene nhe'ẽ vai ramo katu onhemongy'a arã pende py'a, he'i ijaty va'e-pe arandu rehegwa nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Upéi ogwahẽ ou-vy iha-py hemimbo'e kwéry: —Fariseu kwéry ojohu vai kuri pene nhe'ẽ. Ndereikwaái tipo upéa nde ra'e? Ne nhe'ẽ rendu-vy, “Aipo” he'i nde-rehe opondera eterei-vy. Ndojohu porãi voi, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Upéi ha'e omombe'u arandu rehegwa nhe'ẽ temitỹgwe rehegwa nhe'ẽ-rami, hesapyso e'ỹ va'e rehegwa nhe'ẽ-rami ave he'i: —Entéro temitỹgwe xe Ru yváy pygwa onhotỹ e'ỹ va'ekwe gwive, hapo gwive omondoro jevy va'erã, he'i fariseu kwéry rekoha vai-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","—Ani pepena hese. Hesapyso e'ỹ va'e-rami oiko ramo jepe, gwapixa ogwerahase joty tape-rupi. Ha mokõi hesapyso e'ỹ va'e ojogweraha ramo, ho'a arã oho-vy mokõive onhondive yvy kwa-py, he'i fariseu kwéry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Upe rire he'i Pedro: —Mbava'e-rehe po he'ise arandu rehegwa nhe'ẽ, eikwaa uka ore-vy, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Upéa-rehe he'i gwemimbo'e kwéry-pe: —Peẽ napene arandu porãi vyteri peiko-vy. Ha'e kwéry-rami voi ndapeikwaa porãi joty. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ma'erã tipo ndapeikwaa porãi vyteri? he'i. —Pekaru ramo, oho pende ryekwe-py tembi'u. Upéi osẽmba jevy pendéhegwi. Napene mongy'áiry voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","—Ha pene nhe'ẽ katu pende py'a-gwi osẽ-vy ombojekwaa-ma pende py'a pygwa, he'i. —Nde py'a ky'aha para'e, nde py'a potĩha para'e ombojekwaa-ma pende-rehe. Ivai ramo pene nhe'ẽ, pene mongy'a arã. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pende py'a-py katu penhemongeta peiko-vy pene rembiapo vairã-rehe. Upéa-gwi peporojuka. Pende py'a ky'a-gwi onhoembireko ndive, onhome ndive peiko. Kunha ndive pejogwereko rei ave. Pende py'a vai-py penhemongeta-gwi, pemonda rei peiko-vy, pende apu, pende rapixa-rehe penhe'ẽ vai rei peiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Upeixagwa pejapo pende py'a vai-gwi. Upéixa ramo pende py'a vai-gwi, pene mongy'a-ma. “Ha pejepohéi porã e'ỹ reheve pekaru ramo, pene mongy'a va'erã” he'i mo'ã fariseu kwéry. Upéixa ramo, napene mongy'avéi-ma va'erã, he'i Hesu fariseu kwéry remimombe'ukwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Upe-gwi osẽ oho-vy Hesu. Okanhy oho-vy outro yvy-koty osẽ oho. Tiro tetã jerekwe-rupi, Sidom tetã jerekwe-rupi oho ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Upe-py oiko kunha Canaã yvy gwigwa ogwahẽ ou-vy Hesu ha-py: —Xe Járy, Davi remiarirõre, xe poriahuvereko katu. Xe memby kunha ohasa asy eterei oiko-vy anháy ojepota hese va'e, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ha Hesu mba'eve nde'íry íxupe. Onhemokirirĩ íxugwi. Ogwahẽ ou-vy iha-py hemimbo'e kwéry: —“Tereho katu” ere, “Tereho katu” ere íxupe. Nhane moakã rasy osapukái-vy. Ejapo katu hemimbota-rupi íxupe oho jevy hagwã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Upéi Hesu he'i kunha-pe: —Ovexa okanhy va'ekwe-rami oiko Israel remiarirõre judeu kwéry. Íxupe kwéry anho mante xe mbou va'ekwe. Judeu e'ỹ va'e kwéry-pe naxe mboúi va'ekwe, he'i joty íxupe otantea-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ha kunha ou gwetypy'ã-rehe onhesũ hovagwy-py: —Xe pytygwõ katu, xe Járy, he'iri iri íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ha Hesu he'i: —Nde ko ndaha'éi xe re'ýi. Xe re'ýi kwéry aipytygwõ ranhe-ta. Ha upe rire katu xe re'ýi e'ỹ-pe aipytygwõ-ta ave. Mitãgwe katu nhamongaru ranhe. Nanhamombói jagwa-pe mitã remi'urã, he'i joty Hesu itantea-vy, ojekorerovia uka etese-vy kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Akói-ramima ngatu, xe Járy, he'i kunha Hesu-pe. —Ha tembi'u sururukwe ijáry apyka gwy-py ho'u joty jagwa, he'i Hesu-rehe ojerovia joty-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Upe-ma ramo he'i, —Nde kunha, erejerovia tee-ma ra'e xe-rehe, he'i íxupe. —Oiko-ta voi nde-vy gwarã ne remimbota, he'i kunha-pe. Upe-ma ramo okwera porã imemby. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Upe-gwi oho Hesu ohasa oho-vy Galiléia yugwarusu rembe'y-rupi. Upéi ojeupi yvyaty ári oho-vy ogwapy hagwã oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ogwahẽ oje'ói-vy ijaty jaty va'e kente iha-py. Heta hasy va'e reraha-vy ogwahẽ oje'ói-vy hikwái. Oĩ ijyva mbaraete e'ỹ va'e, oĩ ogwata e'ỹ va'e, oĩ hesapyso e'ỹ va'e, oĩ onhe'ẽnge'ỹ va'e, oĩ heta mba'asy oiporu va'e ave. Peteĩ teĩ hasy va'e pya'e ombogwejy imoĩ-vy ipy renonde-py. Ombogwerapa-ma íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Upe ramo ohendu inhe'ẽnge'ỹ va'e onhe'ẽ porã-ma. Ohexa onhemaxuka va'e onhemoatyrõ-ma. Ohexa ogwata e'ỹ va'e ogwata porã-ma. Ohexa hesapyso e'ỹ va'e hesapyso porã-ma ave. Upe va'e kwéry rexa-vy, —Mba'éixa ombogwera? he'i opondera eterei-vy. —Nhandejáry, Israelita kwéry Járy tuvixa mba'e voi, he'i omomba'egwasu-vy Nhandejáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ha upéi katu ohenói Hesu gwemimbo'e kwéry-pe ou jevy hagwã oha-py: —Peju katu xe ha-py, he'i. —Ijaty jaty va'e kente iporiahu va'e xe-vy. Mbohapy áry xe moirũ okwa-vy. Ndogwerekói ave gwemi'urã. Upéa-gwi aiporiahuvereko íxupe kwéry. Amondo ramo íxupe kwéry peteĩ teĩ hóga kwéry-rupi ivare'apa reheve, naipyatãvéi arã tape-rupi, ikangy arã tape-rupi oje'ói-vy, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Upe ramo hemimbo'e kwéry he'i íxupe: —Mba'éixa-ta mora'ẽ nhahembi'u me'ẽ ko'ãy ijaty jaty va'e kente kwéry-pe? A-rupi ndaipóri voi kente tembi'u me'ẽharã, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—Mbovy tipo erereko mbojape? he'i oporandu-vy gwemimbo'e-pe. —Sete voi, he'i. —Oĩ ave ndahetái pira'i ka'ẽ, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Upéi ha'e he'i ojogweroaty va'e-pe ogwapy hagwã kapi'ipe ári: —Pegwapy gwapy katu kapi'ipe ári, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Upe rire oipyhy upe sete mbojape pira'i reheve. Otima porã hese Nhandejáry-pe. Omboete rire, ombopo mbopóy ime'ẽ-vy gwemimbo'e kwéry-pe. Upéi ha'e kwéry ome'ẽ ho'u va'erã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Upéixa enterove okaru. Hygwyatã porãmba-ma hikwái. Upéi hemimbo'e kwéry omono'õ hembyre opyta va'ekwe omboyru sete ajakagwasu-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ha okaru va'e heta eterei voi. Oĩ irundy mil kwimba'e okaru va'e. Heta kunha okaru ave. Heta mitãgwe okaru ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Upéi he'i: —Tapeho jevy katu, tapeho jevy katu peteĩ teĩ pende róga-rupi, he'i ijaty va'e kente kwéry-pe. Ha upe rire katu ha'e onhemboyru kanoagwasu-py y-rupi oho hagwã. Magadã jerekwe-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ha upéi katu ogwahẽ ou-vy Hesu ha-py fariseu kwéry saduceu kwéry ndive. Ombojejavyse-vy mo'ã íxupe ou hikwái: —Hexapyrã-rupi ejapo katu ore-vy. Nhandejáry rembiapo porã ramigwa ejapo katu ore mbojerovia uka porã-vy, he'i Hesu-pe otantea-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ha Hesu he'i oporandu va'e-pe: —Ka'aru ete ramo, aragwaju-ma ramo, “Aragwaju-ma ra'e” peje, “Ndoky mo'ãiry ra'e” peje arã áry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ha ko'ẽmba-ma ramo, “Aragwaju-ma ra'e, araigwe-ma ave ra'e. Upéa-gwi oky-tama ra'e” peje ave arã áry-rehe. Aipo ramo, áry-rehe pema'ẽ ramo, peikwaa-ma oikotaha. Ha xe rembiapo porã porã rexa-vy, ndapehexa kwaái xe-rehe. Mbava'e-rehe po he'ise xe rembiapo porã ndapeikwaái voi. Nhandejáry rembiaporã ndapeikwaáiry ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Peẽ ãy peiko va'e pende reko vai-ma. Ome tee-pe oheja va'e-rami, gwembireko tee-gwi opoi va'e-rami ave peẽ peiko. Peẽ pejehesa rerova rova Nhandejáry-gwi. Pejere jere íxugwi. Upéa-gwi pejerure jahexa e'ỹ va'erã-rehe. Ha ndahexa uka mo'ãi peẽ-my upeixagwa. Ha Jonas amyrĩ rehegwa nhe'ẽ upe ojehu íxupe va'ekwe katu peikwaa voi. Hexapyrã-rupi íxupe ojehu hagwe-rami ave, ojehu va'erã xe-vy. Upe va'erã anho mante ahexa uka va'erã peẽ-my, he'i hembiaporã-rehe oporandu va'e-pe. Upéi katu Hesu oheja íxupe kwéry oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ha upéi katu oho yugwarusu rovái gwemimbo'e kwéry ndive. Gwemi'urã-rehe naimandu'avéi-ma hikwái, Hesu ndive oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Upe jave he'i Hesu: —Xáke! Penhangareko porã katu pendéjehe. Ivai voi upe mbojape mbovuha fariseu saduceu ave rembiporu, he'i fariseu kwéry remimombe'u vaikwe joko-vy. Upéa he'i gwemimbo'e kwéry-pe pono fariseu kwéry ohekombo'e vai íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ha mbava'e-rehe po he'ise Hesu ndoikwaái voi. Upéa-gwi, —Nanhane mbojapéi-gwi nipo omombe'u ra'e upéa nhande-vy, he'i mo'ã ojóupe onhonhe'ẽngendu-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ha Hesu oikwaa onhomongeta ramo: —Ma'erã po, “Nanhane mbojapevéi-ma” peje penhonhe'ẽngendu-vy? Mixĩ vyteri pejerovia xe-rehe peiko-vy ra'e, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","—Ne'írã vyteri pehexa kwaa-ma xe-rehe. Ne'írã vyteri pejerovia tee xe-rehe. Napene akã porãi voi. Upe cinco mil kwimba'e-pe ambopopóy kuri cinco mbojape ame'ẽ hagwã. Upe rire mbovy ajaka-py pemboyru hembyre? Napene mandu'avéi-ma tipo? he'i upe va'ekwe-rehe. —Ma'erã tipo napene mandu'avéi-ma hese? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","—Ha upe rire katu upe irundy mil kwimba'e-pe ambopopóy sete mbojape ame'ẽ hagwã. Upéi mbovy ajakagwasu-py pemboyru hembyre? Napene mandu'avéi-ma tipo? he'i upe va'ekwe-rehe. —Ma'erã tipo napene mandu'avéi-ma hese? he'i ndojeroviái-gwi hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","—Mbojape rehegwa nhe'ẽ namombe'úi kuri peẽ-my. Mbojape mbovuha ae katu fariseu kwéry saduceu kwéry ndive rembiporu amombe'u kuri peẽ-my. Xáke íxugwi. Mbava'e-rehe po ha'ese, ma'erã po ndapeikwaái? he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Upe ramo ipaha-py, mbava'e-rehe po he'ise, oikwaa porã-ma hemimbo'e: —“Xáke mbojape mbovuha-gwi” nde'i teéiry Hesu. Ndaha'éiry mbojape mbovuha tee-rehe he'i Hesu, he'i. —“Xáke pono pene mboheko vai fariseu kwéry saduceu kwéry ndive” he'ise ae nhande-vy Hesu, he'i ojóupe Hesu nhe'ẽ kwaa-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ha upéi katu ohasa oho-vy Hesu. Cesaréia de Filipe tetã jerekwe-rupi oho. Upe-py oporandu gwemimbo'e kwéry-pe: —Mbava'e tipo he'i ra'e xe-rehe, Nhande Ryke'y tee va'e-rehe? he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—Nane mombe'u porãiry. Ne mombe'u joavy avy kuri, he'i. —“João Batista onhemoingove jevy va'ekwe ra'e ko upe va'e” oĩ he'i va'e nde-rehe. “Elias onhemoingove jevy va'ekwe ra'e ko upe va'e” oĩ he'i va'e upéixa nde-rehe. “Jeremias onhemoingove jevy va'ekwe ra'e ko upe va'e” oĩ he'i va'e nde-rehe. “Outro Nhandejáry nhe'ẽ-py omombe'u va'ety oikove jevy va'ekwe ra'e ko upe va'e” oĩ nde-rehe he'i va'e, he'i íxupe hemimbo'e kwéry omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Ha peẽ ae katu, mbava'e tipo peje xe-rehe? he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Nde ko Cristo, Nhandejáry rembiporavo va'e, Nhandejáry tee ra'y voi nde, he'i íxupe Simão Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Nde Simão Jonas ra'y. Nde rerovy'a eterei-ma Nhandejáry, he'i Pedro-pe. —Ndaxe kwaa ukái nde-vy teko rei. Ha xe Ru yváy pygwa va'e ae katu xe kwaa uka-ma nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nde Pedro. Nde réry-rehe ita he'i. Nde reko ita-rami. Xe mombe'u porã-gwi ita-rami erenhemombaraete. Ãy, nde-rami heta nde rapykwerigwa onhemombaraete va'erã xe mombe'u porã ramo. Nde xe mombe'uha-rami ave, ha'e kwéry xe mombe'u porã ramo, xe-rehe ojerovia va'erã, amoingo va'erã xe re'ýi ramo. Xe re'ýi kwéry omano ramo jepe, ndaipu'akái va'erã hese anhaygwasu. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Xe nhe'ẽ-py eremombe'u va'erã Nhandejáry nhande ruvixarã rehegwa nhe'ẽ. Eremombe'u ramo, oĩ xe rerovia va'erã. Oĩ xe rerovia e'ỹ va'erã. Okẽ-rehe onhangareko mbaraete va'e-rami erepyta va'erã. “Ipy'a potĩ-ma” ere ramo nde rapixa-rehe, Nhandejáry ave he'i ave va'erã hese: “Ipy'a potĩ-ma” he'i ave va'erã hese. Ogwahẽ va'erã Nhandejáry ha-py. Ha “Ipy'a ky'a joty” ere ramo nde rapixa-rehe, Nhandejáry ave he'i ave va'erã, “Ipy'a ky'a” he'i ave va'erã. Nogwahẽ mo'ãi va'erã Nhandejáry ha-py. Ipokatu va'erã voi ne nhe'ẽ, he'i Pedro-pe Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Upéi he'i gwemimbo'e kwéry-pe: —Ãy katu aníke xe mombe'u teĩ kuri. “Cristo, nhane remiha'arõ va'e voi upe va'e” ani peje teĩ kuri xe-rehe avave-pe, he'i onhemombe'use e'ỹ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Upéa he'i rire, omombe'u jevy jevy gwemimbo'e kwéry-pe ojéupe ojehu va'erã oikwaa uka-vy: —Nhandejáry nhe'ẽ-py aha-ta Jerusalém tetã-my. Upe-py xe mbohasa asy va'erã gwĩ judeu ruvixa kwéry, pa'i ruvixa kwéry ndive. Gwĩ judeu rekombo'ehaty xe mbohasa asy va'erã. Xe juka uka va'erã. Ha mbohapy áry rire katu, anhemoingove jevy-ma va'erã, he'i gwemimbo'e kwéry-pe ojéupe ojehu va'erã oikwaa uka porã-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ha Pedro katu ogwenohẽ-ma ha'e anho ha-py hakate'ỹ-gwi: —Tane resende katu Nhandejáry, he'i íxupe. —Koixagwa ndojehu mo'ãi va'erã nde-vy, xe Járy, he'i onhe'ẽ joko-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ojere-ma Hesu: —Ejei xe ypy-gwi, he'i Pedro-pe, Satanás-py ohenói-vy íxupe. —Anháy ruvixa Satanás nhe'ẽ-py xe rekombo'e vaise mo'ã ereiko-vy, he'i íxupe. —Ereipota mo'ã xe ajere Nhandejáry rape-gwi, he'i. —Nhandejáry remimbota nde ndereipotái. Teko rei remimbota ae erejohu porã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Upe ramo he'i gwemimbo'e kwéry-pe: —Peẽ xe moirũse ramo, anive pejapo rei teĩ pejapose va'e anho mante. Anive pepena teĩ pende rekove-rehe. Xe moirũ ae katu peẽ. Okurusugwasu ohupi heraha-vy va'e-rami ijukapyrã-rami ae katu peiko. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","—Ha gwekove-rehe hakate'ỹ va'e katu, ndoikove mo'ãi Nhandejáry ndive. Ha xe-rehe ha-py gwekove-rehe nahakate'ỹiry va'e oikove meme va'erã Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nde para'e ko yvy apy gwive járy ramo ereiko va'erã. Ha Nhandejáry ndive ereiko e'ỹ ramo katu, mba'evete ndererekói va'erã. Opa ete-ma va'erã. Nhandejáry ndive ereiko e'ỹ ramo, nande reko repyvéi-ma va'erã. Nderetopái va'erã nde rekove repyrã. Eremano joty va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","—Xe Nhande Ryke'y tee va'e amano rire aju jevy va'erã. Upe áry-py xe Ru rendy pype-ma aju va'erã. Ipu'akaha reheve aju jevy va'erã. Xe rembigwái marangatu yváy pygwa ndive aju jevy va'erã. Petẽi teĩ yvypóry kente kwéry-pe hembiapo apokwe-rehe areko va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Anhete ko xe ha'e-ta peẽ-my. Xe Nhande Ryke'y tee va'e aju jevy va'erã peẽ-my pende ruvixarã. Ha oĩ ãy gwĩ pene pa'ũ-my xe rexa joty va'erã, xe aju jevy ramo. Xe rexa e'ỹ reheve nomano mo'ãi. Xe rexa rire ae mante omano va'erã, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis áry rire, mbohapy ogweraha gwupive Hesu. Pedro, Tiago tyvýry João ndive ogweraha. Ha'e kwéry anho ogwerojeupi heraha-vy yvyatyrusu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Upéi mbohapygwa resa-py ojehete rekoviarõ-ma Hesu. Kwarahy rendy-ramima ave hendy hova. Ijao rembipepa-ma ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Upe-ma ramo ojekwaa ave mokõive Hesu ndive onhomongeta oĩ-vy ramo. Moisés amyrĩ ndive ojekwaa Elias amyrĩ. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ohexa ramo, he'i Pedro: —Iporã nhande nhaime a-py, ore Járy, he'i Hesu-pe. —Ereipota ramo xe ajapo, ajapo-ta mbohapy tapýi, peteĩ va'e nde-vy gwarã, peteĩ va'e Moisés pegwarã, peteĩ va'e Elias pegwarã ave, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Onhe'ẽ vyteri jave, tatatĩ hesakã va'e ramigwa voi omo'ã-ma íxupe kwéry. Tatatĩ hesakã va'e pa'ũ-gwi ohendu-ma onhe'ẽ va'e: —Ko va'e xe ra'y, xe rembihayhu va'e, he'i. —Arovy'a porã voi íxupe. Ejeapysaka katu inhe'ẽ-rehe, he'i Hesu-rehe tatatĩ hesakã ramigwa pa'ũ-gwi onhe'ẽ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Upe va'e nhe'ẽ ohendu ramo, mbohapy hemimbo'e onhemondýi eterei. Ojeity-ma. Ovapy-py ho'a oho-vy, onhemondýi eterei-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ha Hesu opoko joty hese: —Epu'ã jevy katu, he'i. —Anive erekyhyje teĩ, he'i ovapy-py ho'a va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Onheakãrupi jevy ramo, avave ndohexáiry. Hesu-pe anho mante ohexa. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Upéi ogwejy jevy ou-vy yvyaty-gwi. Ogwejy jave he'i: —Anive eremombe'u teĩ ne rembiexagwe avave-pe, he'i. —Ha upe rire katu xe Nhande Ryke'y tee va'e amano rire, aikove jevy rire ae katu, emombe'u katu ne rembiexagwe, he'i íxupe kwéry omanda-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Upéi oporandu íxupe hikwái: —Jahexa kuri Elias oikove jevy ramo. Aipo ramo, ma'erã po he'i judeu rekombo'ehaty, “Toikove jevy ranhe ou-vy Elias Cristo renonde-rupi” he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Upéi he'i Hesu íxupe kwéry: —Ha'e-ma ngatu. Anhetegwa omombe'u hese judeu rekombo'ehaty. “Ou ranhe va'erã voi Elias” he'i, “omoatyrõmba hagwã” nde'i reíry hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ha ha'e-ta peẽ-my. Ou-ma va'ekwe Elias. Ojapose va'e rei, ojapo hese kuri, ndohexakwaáiry hese-gwi. Upéixa ete ave arã xe-rehe xe Nhande Ryke'y tee va'e-rehe ojapose va'e rei ojapo va'erã, he'i Elias rehegwa nhe'ẽ oikwaa uka-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Upe ramo: —João Batista-rehe nipo onhe'ẽ ra'e, he'i Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ogwahẽ jevy ou-vy ramo ijaty jaty va'e kente ha-py, oho onhesũ gwetypy'ã-rehe Hesu rovagwy-py: ");
INSERT INTO kgkNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ndikatúi pa ereiporiahuvereko xe ra'y-pe, xe Járy? he'i. —He'o'ã o'ã va'e oiko asy voi. Oime ha-py rei ho'a. Tata-rupi y-py ave ho'a oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aru teĩ kuri íxupe ne remimbo'e ha-py. Ha ndikatúi ombogwera íxupe, he'i íxupe túvy. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Upéi he'i Hesu upe pygwa-pe: —Peẽ xe-rehe pejerovia e'ỹ va'e, pene akã hatã va'e. Xe ae katu ndaxe are mo'ãi pene ndive. Ndoroipokwaa are mo'ãvéi-ma. Eru katu xe ha-py hasy va'e, he'i upe pygwa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ogweru rire, oja'o anháy-pe imondo hagwã. Ha anháy katu osẽ íxugwi oho-vy. Upe-ma ramo okwera porã-ma hasy va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ha upéi katu upe hemimbo'e ombogwerase mo'ã va'ekwe, oporandu nhemi Hesu-pe ha'e anho oho ha-py: —Ma'erã-gwi po ndore pu'akái anháy-rehe oromosẽ hagwã íxugwi imondo-vy, he'i íxupe ");
INSERT INTO kgkNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ha Hesu he'i: —Peẽ katu ndapejerovia teéiry xe-rehe peiko-vy. Anhetegwa amombe'u-ta peẽ-my. Oĩ temitỹ ra'ỹi mixĩ eterei va'e voi mostarda héry va'e. Upe temitỹ ra'ỹi mixĩ va'e-rami, mixĩ jepe xe rerovia tee ramo, imbaraete joty va'erã ne nhe'ẽ. Ere va'erã ko yvyatygwasu-pe: “Ejei katu outro henda-py tereho” ere ramo, ojepe'a va'erã. Ipokatu voi va'erã ne nhe'ẽ mbaraete-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","—Nde ae rei ramo, nosẽi va'erã anháy. Nande pu'akái va'erã hese. Ha Nhandejáry-pe ne nhe'ẽ eremondo mondo ramo, erekaru e'ỹ reheve erehasa ramo ave, upéixa ramo nde pu'aka arã hese. Eremosẽ va'erã imondo-vy, he'i gwemimbo'e-pe Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ha hemimbo'e kwéry katu ojogweroatypa jevy peteĩ henda-py. Galiléia yvy-py ojehe'a jevy ojóehe. Upe ramo he'i íxupe kwéry Hesu: —Xe Nhande Ryke'y tee va'e xe me'ẽ va'erã xe reraha-vy. Xe-rehe ija'e'ỹ va'e po-py xe me'ẽ va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Upe rire xe juka uka va'erã. Xe juka rire, mbohapy áry ohasa jevy rire katu, xe moingove jevy-ma va'erã Nhandejáry, he'i íxupe kwéry Hesu. Upéa ohendu ramo, ipy'a reraha, ipy'a nhemondýi. Ndovy'avéi hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ha upéi katu Hesu gwemimbo'e kwéry ndive ogwahẽ oho-vy Cafarnaum tetã-my. Upe-py ogwahẽ ramo, oho Pedro ha-py oporombopaga va'ety: —Ne mbo'eháry ndopagái tipo imposto Nhandejáry róga kakwaa pegwarã? he'i Pedro-pe hikwái oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Ome'ẽ-ta voi, he'i íxupe. Koty-py oike jevy ramo, Hesu he'i ranhe íxupe: —Kiva'e va'e-pe he'i ko yvy arigwa mburuvixagwasu va'e, “Peme'ẽ xe-vy imposto?” Gwe'ýi kwéry-pe pa ojerure ra'e? Gwe'ýi e'ỹ-pe pa ojerure ra'e? he'i Pedro-pe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Gwe'ýi e'ỹ-pe mante ojerure, he'i Pedro. —Aipo ramo, he'i Hesu. —“Peme'ẽ katu” nde'íry gwa'ýry-pe. Xe Nhandejáry ra'y. “Eme'ẽ katu” nde'íry xe-vy xe Ru, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","—Ha “Hesu ndopagái imposto, nopenái ra'e Nhandejáry róga-rehe” ndaipotái he'i ra'e xe-rehe. Upéa-gwi ekwa tereho yugwarusu-py. Eity nde pinda erenohẽ hagwã pira. Erenohẽ ypy va'e eipyhy pira ejurupe'a. Ijuru-py erejohu-ta peteĩ itaendy plata. Eraha ereme'ẽ hagwã oporombopaga va'e-pe. Xe-rehe, nde-rehe ave eme'ẽ íxupe, he'i Pedro-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Upe ramo ogwahẽ ou-vy Hesu ha-py hemimbo'e kwéry: —Nhandejáry nhande ruvixarã-pe omoirũ tee va'e gwive pa'ũ-my, kiva'e-pe tipo nhambotuvixave va'erã? he'i oporandu-vy íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Upéi ohenói mitã-pe ou hagwã. Omoĩ gwemimbo'e kwéry rovagwy-py omombe'u hagwã hesegwa nhe'ẽ: ");
INSERT INTO kgkNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Amombe'u-ta peẽ-my anhetegwa. Ha peẽ penhemboete ukase ramo mo'ã, napemoirũ mo'ãi va'erã Nhandejáry pende ruvixarã-pe. Ha pende rekoha perova ranhe ramo, mitã-rami pende reko pemomirĩ peiko-vy ramo ae katu, pemoirũ-ma va'erã Nhandejáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Upe onhemomirĩve va'e katu, ko mitã-rami oiko va'e katu ave, upéa ko omboeteve va'erã íxupe Nhandejáry oiko ha-rupi nhande ruvixarã. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Xe réry-py pemogwahẽ ramo koixagwa, ko mitã-rami oiko va'e gwive, xe-vy xe mogwahẽ va'erã ave, he'i gwĩ onhemboete ukase mo'ã va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Upéi he'i jevy Hesu: —Pejeapysaka katu xe nhe'ẽ-rehe, he'i. —Ko mitã-rami oiko va'e, heko mirĩ va'e, xe-rehe ojerovia va'e ave, oĩ ohesa rerova uka va'erã xéhegwi ombojejavy uka-vy. Hekoha vai eterei upe va'e. Iporã arã ra'e jajuka hagwã ombo'e vai e'ỹ ngatu. Iporãve arã ra'e nhanhapytĩ itagwasu ijaju'y-rehe ra'e. Iporãve arã ra'e nhamombo ygwasu-py ombo'e vai e'ỹ ngatu. Iporãve voi ko ra'e omano ranhe ra'e ombo'e vai e'ỹ ngatu pono xe-rehe ojeroviase va'e-pe ombo'e vaipa rei. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Ojekwaa va'erã ou-vy nhane mbojejavy ukase va'e. Ha inhe'ẽ renduharã-pe katu, amboasy eterei. Ha nhane mbojejavy ukase va'e-pe katu amboasy eterei ave hembiapo vairã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Xáke, penhangareko katu pendéjehe. Nde po-gwi para'e erejejavy ramo, nde py-gwi para'e erejejavy ramo, ejahya katu nde po, ejahya katu nde py ave eremombo-vy. Peteĩ ipo e'ỹ va'e rekoha-rami eiko. Peteĩ nde py e'ỹ va'e rekoha-rami ave eiko. Iporãve nde posogwe, ne karẽ ave, eregwahẽ hagwã ereho-vy Nhandejáry oiko haty-py. Ha ne mombo ramo tata opa opa rei e'ỹ va'e-py katu mokõi nde po reheve, mokõi nde py reheve ave, ivaive arã nde-vy. Nde poriahu ete va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ha nde resa ne mbojejavy ukase ramo, enohẽ katu nde resa emombo ndéhegwi. Peteĩ nde resa e'ỹ va'e rekoha-rami eiko. Iporãve peteĩ nde resa reheve eregwahẽ ereho-vy Nhandejáry oiko haty-py. Ne mombo ramo tata opa opa rei e'ỹ va'e-py mokõi nde resa reheve, ivaive arã nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Penhangareko porã katu pendéjehe. Oĩ hekoha porã va'e heko'ive va'e. Ha peẽ katu aníke pemboete e'ỹ teĩ íxupe. Nhandejáry rembigwái yváy pygwa va'e onhangareko va'e hese. Xe Ru rovagwy-py oĩ upe inhangarekoha. Upéa-gwi ani pemboete e'ỹ teĩ heko'ive va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Xe ave Nhande Ryke'y tee va'e, okanhy va'ekwe aresende hagwã ajekwaa aju-vy va'ekwe. Upéa-gwi aníke pemboete e'ỹ teĩ upe mitã-rami hekomirĩve va'e-pe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Upéi Hesu omombe'u arandu rehegwa nhe'ẽ ovexa rehegwa nhe'ẽ-rami oiporu: —Oĩ va'ekwe heta hymba ovexa va'e. Cem gwymba-rehe onhangareko oiko-vy. Upéi peteĩ okanhy ramo íxugwi, kóixa ojapo va'erã para'e, he'i. —Oheja va'erã upe noventa e nove okanhy e'ỹ va'e. Yvyatyrusu-py oheja va'erã mombyryve ryve oho arã oheka heka hagwã okanhy va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ojohu-ma ramo, ovy'a eterei gwymba-rehe, “Ajohu-ma peteĩ okanhy va'ekwe ajohu-ma upe okanhy va'ekwe” he'i. Heta okanhy e'ỹ va'e kwéry-rehe ovy'a joty. Ha upe peteĩ okanhy va'ekwe-rehe, ojohu jevy-ma va'ekwe-rehe ovy'a etereive voi oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Upéixa ete pende Ru yváy pygwa ndoipotái ni peteĩ mitã-rami ne'írã oikwaa vyteri va'e, heko mirĩ va'e, okanhy íxugwi mombyry oho-vy, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Upéi he'i jevy Hesu: —Ha nde rapixa, xe-rehe ojerovia va'e, hembiapo vai ramo nde-rehe, ne anho tereho kuri iha-py. Ekwa ha'e anho oiko ha-py, eikwaa uka katu íxupe katu nde-rehe hembiapo vaikwe. Ne rendu ramo, erenhombojoja jevy-ma ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","—Ha nde-vy anho nane renduséi ramo, eraha kuri ne irũ nde rupive peteĩ, mokõi para'e. Upéixa mokõi va'e, mbohapy va'e resa-py ojekwaa porã-ma va'erã ojehu va'erã gwive. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ha peẽ mbohapygwa napene renduséi ramo ave katu, emombe'u Hesu reroviaha-pe onhomboaty aty haty-py. Ha upe va'e kwéry-pe nohenduséi ramo ave katu, anive eremboete teĩ íxupe. Onhomboete e'ỹ va'e-rami ereko íxupe, nhande kwéry e'ỹ-rami. Plata-py oporombopaga va'ety-rami rei joty ereko íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Amombe'u-ta peẽ-my anhetegwa va'e. Penhomboaty haty-py ipokatu va'erã pene nhe'ẽ. “Ipy'a potĩ-ma” peje ramo pende rapixa-rehe, Nhandejáry ave he'i ave va'erã hese, “Ipy'a potĩ-ma” he'i ave va'erã hese. Ha, “Ipy'a ky'a joty” peje ramo nde rapixa-rehe, Nhandejáry ave he'i ave va'erã, “Ipy'a ky'a” he'i ave va'erã. Ipokatu va'erã voi pene nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Anhete ko xe ha'e-ta peẽ-my. Ko yvy-py peẽ mokõi va'e penhomboaty ramo, perojoja ramo oração apo-vy, ome'ẽ va'erã peẽ-my pene rembijerure xe Ru yváy pygwa. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Xe réry-py erenhomboaty ramo, peẽ mokõi va'e para'e, peẽ mbohapy va'e para'e, upe-py ete pene pa'ũ-my aime va'erã xe ave, he'i Hesu mba'éixa jaiko nhanhomboaty aty haty-py omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Upe ramo onhemo'agwĩve ou-vy Hesu ypy-py Pedro. He'i íxupe: —Xe re'ýi xe-rehe hembiapo vai vai ramo, iporã pa aiporiahuverekori kori joty íxupe? Sete vése peve pa aiporiahuvereko va'erã íxupe? he'i Hesu-pe Pedro oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ha Hesu he'i: —Sete vése anho peve nome'ẽi arã. Sete vése setenta vése peve ae katu eiporiahuverekori kori katu íxupe, he'i. —Nde-rehe hembiapo vairi iri ramo jepe, eiporiahuvereko meme meme joty katu íxupe, he'i Pedro-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Upéi he'i jevy: —Upéa-rehe amombe'u-ta peẽ-my arandu rehegwa nhe'ẽ mburuvixagwasu oporoporiahuvereko va'ety rehegwa nhe'ẽ poru-vy. Oĩ mburuvixagwasu, oĩ ave hembigwái kwéry oreve va'e. Ijáry oipota ombohekovia jevy íxupe oreve va'e repy. Upe mburuvixagwasu he'i Nhandejáry nhande ruvixa-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ohenói rire gwembigwái upe mburuvixagwasu, ou ijáry ha-py peteĩ hembigwái heta eterei oreve va'e, heta milhões oreve va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","“Erereve va'e repy eme'ẽ katu xe-vy” he'i gwembigwái-pe. Ha ndogwerekói-gwi ndikatúi ome'ẽ. Upe-ma ramo he'i hese ijáry outro gwembigwái-pe: “Eraha katu erevende hagwã entéro ha'e ae ogwereko va'e gwive. Hembireko, ta'ýry, tajýry, ha'e ave evende katu. Upéi eru katu xe-vy upe ne remivende va'ekwe repykwe” he'i hese ijáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Upe-ma ramo upe hembigwái heta eterei oreve va'e onhesũ gwetypy'ã-rehe ojáry rovagwy-py. “Aníke nde poxy teĩ xe-vy. Ãy ndikatúiry apaga nde-vy. Emoĩ katu xe-vy araka'e pa aju-ta apagapa hagwã nde-vy” he'i ojáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Upéi ijáry oiporiahuvereko-ma íxupe. Ohexakwaa rei-ma íxupe. Ireveha oheja rei. Nombopagái íxupe oiporiahuvereko-gwi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Osẽ rire ojáry ha-gwi, upe hembigwái otopa oirũ mixĩmi plata-rehe oreve va'e íxupe. Ojyryvirunga íxupe, ombovava vava íxupe ijaju'y-rehe omoingo asy-vy. “Eme'ẽ mani katu, eme'ẽ mani katu erereveha repy” he'i oirũ-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Upe-ma ramo gwetypy'ã-rehe onhesũ upe hembigwái rovagwy-py: “Aníke nde poxy teĩ xe-vy. Ani erejapura eterei teĩ. Apagapa arã voi ko nde-vy” he'i oirũ-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ha ndoiporiahuverekovéi-ma íxupe. Omoĩ uka preso opagaha óra peve. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ha outro hembigwái kwéry katu hexaháry voi. Omboasy eterei hembiapokwe. Oho omombe'u ojáry-pe entéro ojapo va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","—Ha upe rire katu ijáry ohenói jevy upe gwembigwái-pe. “Tou katu” he'i. “Nde rekoha vai voi ko nde ra'e” he'i íxupe. “Orohexakwaa-ma kuri erejerure-gwi xe-vy. Norombopaga ukáiry nde reveha repy gwive. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ma'erã po ndereiporiahuverekói ne irũ-pe oroiporiahuvereko hagwe-rami?” he'i upe gwembigwái-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Upéa-gwi ipoxy íxupe ogwereko asy-vy. “Emoĩ íxupe preso. Embopaga uka íxupe eremoingo asy-vy, enterove oreve va'e gwive opaga hagwã” he'i hese ijáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Upéixa ave pende rereko asy va'erã xe Ru yváy pygwa va'e. Nde re'ýi nde py'a gwive ereiporiahuvereko e'ỹ ramo, peẽ-my ave pende rereko asy va'erã, he'i Hesu arandu rehegwa nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Heta nhe'ẽ porã porã omombe'u Hesu ha upe rire katu osẽ oho-vy Galiléia yvy-gwi, ohasa ysyry Jordão rovái. Judéia yvy-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Upe-py heta eterei ijaty va'e oho hapykwéri. Oavyte-py ogweraha Hesu-pe. Ha hasy va'e kwéry-pe katu ombogwera joty oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Upe-py oĩ ave fariseu va'e. Ogwahẽ ou-vy iha-py. Omonhe'ẽavyse mo'ã Hesu-pe. Upéa-gwi oporandu íxupe: —Omenda va'ekwe opoi rei ramo gwembireko-gwi, oiko joty tipo tekoha-rupi, he'i omonhe'ẽavyse mo'ã-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Ha Hesu he'i: —Nhandejáry nhe'ẽ he'i a-rami: “Yma ete va'ekwe kwimba'e ypy-pe ndive ojapo-ma ave kunha ypy. Upéa-gwi kwimba'e oheja va'erã gwu-pe osy-pe ave gwembireko oirũrã omoirũ teeharã ndive omenda hagwã. Mokõi va'e-rami ndoikovéi-ma. Peteĩxa ae onhomoirũ-ma oiko-vy va'erã” he'i Nhandejáry kwatia nhe'ẽ. Ma'erã napemonhe'ẽi upéa rehegwa kwatia nhe'ẽ peikwaa porã hagwã, oikwaa uka porã hagwã peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nhandejáry kwatia nhe'ẽ he'i hagwe-rami jaikwaa omenda va'ekwe rekoha. Ndoikovéi ha'e anho rei. Peteĩxa ae hekoha. Upéa-gwi tomomboi uka e'ỹ katu teko rei Nhandejáry remimbojehe'a, he'i fariseu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ha'e kwéry katu he'i joty omonhe'ẽavyse-vy mo'ã íxupe: —Aipo ramo, ma'erã he'i va'ekwe Moisés amyrĩ: “Erepoise ramo ne rembireko-gwi, ehai ranhe kwatia-rehe ereikwaa ukapa hagwã. Upéi eme'ẽ íxupe kwatia erepoi hagwã íxugwi” he'i va'ekwe Moisés amyrĩ. Ma'erã he'i va'ekwe yma gware upéa? he'i Hesu-pe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ha Hesu he'i: —Pende py'a ratã-gwi napehenduséiry nhe'ẽ. Upéa-gwi Moisés amyrĩ he'i va'ekwe peẽ-my pepoi hagwã pene rembireko-gwi. Ha ojejapo hagwe áry-py kunha ypy kwimba'e ypy ndive katu, gwĩ omoirũ va'ekwe Nhandejáry nde'íry voi va'ekwe opoi poi hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","—Ha'e-ta peẽ-my: Gwembireko-gwi opoi rei va'e omenda jevy ramo, onhemongy'a va'erã, ojapo vai va'erã gwembirekokwe-rehe. Ha kwimba'e ambue ndive ae hembireko oiko va'e, gwembireko ojapo vai hese-gwi ae opoi va'e katu, nonhemongy'ái va'erã, ndojapo vaíry gwembirekokwe-rehe, he'i omenda va'ekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Upe ramo he'i íxupe hemimbo'e kwéry: —Aipo ramo, naiporãi-gwi japoi nhane rembireko-gwi, iporãve para'e nhande nhamenda e'ỹ jaiko-vy nhane anho rei jaiko, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ha Hesu he'i íxupe: —Nda'éiry upéixa, he'i. —Nda'éiry enterove va'e-pe omenda e'ỹ hagwã. Gwĩ Nhandejáry oipota omenda e'ỹ va'e-pe ae, upéa-pe aipo ha'e. Ndaha'éiry enterove va'e-pe rei ha'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","—Napeteĩxairy omenda e'ỹ va'e. Oĩ oiko ypy ramo nahesãiry va'e. Nomendáiry. Ndaha'éiry omendasere'ỹ-gwi. Oĩ omenda e'ỹ va'e ikatu e'ỹ va'e. Oĩ ave omenda e'ỹ va'e nomendaséi-gwi. Hetea'e a'e omba'apo hagwã Nhandejáry nhande ruvixa-pe. Upéa-gwi nomendaséiry. Tomenda e'ỹ oiko-vy omendase e'ỹ va'e, he'i omenda e'ỹ va'e-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Upe ramo ojereru okwa-vy Hesu renda-py mitã opo omoĩ hagwã hese, ojapo hagwã oração hese. Ha hemimbo'e kwéry katu: —Togweru e'ỹ katu mitã, he'i ojoko-vy mo'ã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ha Hesu he'i: —Ani pejoko teĩ mitã ou va'erã. Tou katu xe renda-py, he'i joty Hesu. —Ha'e-ta peẽ-my: Kente kwéry onhemboete ukase rei va'e nomoirũi-ma va'erã Nhandejáry gwuvixarã-pe. Ha gwĩ onhembotuvixase e'ỹ va'e, mitã-rami hekomirĩve va'e ae, omoirũ-ma va'erã Nhandejáry gwuvixarã-pe. Upéa-gwi ani pejoko teĩ mitã ou va'erã, he'i mitã-rehe oikwaa uka-vy kiva'e po omoirũ-ta Nhandejáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Upéi mitã-rehe opo omoĩ rire, osẽ oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Peteĩ óra-py ogwahẽ ou-vy Hesu ha-py karia'y imba'e reta va'e: —Mbo'eháry, he'i Hesu-pe, —Mba'eixagwa ajapo-ta iporã va'e aikove hagwã Nhandejáry ndive apave'ỹ reheve, he'i Hesu-pe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—Ma'erã ereporandu xe-rehe iporã va'e-rehe, he'i. —Nhandejáry ha'e anho mante hekoha porã tee va'e. Nhandejáry ndive ereikove memese ramo, eiko katu Nhandejáry remimombe'ukwe nde rekorã-rupi, he'i upe imba'e reta va'e-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Heta hemimombe'ukwe. Mbava'e va'e xe ajapo-ta? he'i Hesu-pe oporandu-vy. Upei he'i Hesu íxupe: —“Ani ereporojuka teĩ. Ani eremoingo ambue mbue teĩ. Ani eremonda teĩ. Ani nde apu rei teĩ nde rapixa-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Emboete ae katu nde ru nde sy ave. Ehayhu rei katu nde rapixa-pe ave nde rekove erehayhuha-rami” he'i upe imba'e reta va'e-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Upéa nhe'ẽ namokanhýi ahendupa aiko-vy, he'i Hesu-pe upe karia'y. —Kiva'e nhe'ẽ ajapove-ta? he'i oporandu-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Peteĩ anho nderejapói nde reko agwyje hagwã, he'i íxupe. —Nde reko agwyjese ramo, eraha ranhe evendepa erereko va'e. Upe rire katu eme'ẽmba hepykwe iporiahu va'e kwéry-pe. Nde reko agwyje-ma va'erã, he'i íxupe. —Hetave oĩ va'erã nde-vy gwarã yváy-py. Ha upe rire katu eju xe moirũ, he'i upe karia'y imba'e reta va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Upéa nhe'ẽ ohendu ramo, ndovy'avéi oho-vy. Heta mba'e porã porã ogwereko-gwi, ojepy'a reraha oho-vy. Imytu'e'ỹ-gwi omba'e kwéry-rehe ojepy'a reraha oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Upe ramo he'i Hesu gwemimbo'e kwéry-pe: —Amombe'u-ta peẽ-my anhetegwa va'e. Imba'e reta va'e hasy peve omoirũ va'erã Nhandejáry gwuvixarã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","—Amombe'u jevy-ta peẽ-my: Hasy eterei nhambohasa ka'ijugwasu kwa-rupi mymbagwasu camelo. Ha hasyve voi gwĩ imba'e reta-rehe ojerovia va'e omoirũ hagwã Nhandejáry nhande ruvixa-pe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ha ha'e kwéry katu onhemondýi eterei-ma upéa ohendu ramo. —Aipo ramo, kiva'e nipo onheresende va'erã, kiva'e nipo onheresende va'erã. Avave nonheresende mo'ãi arã ra'e, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ha ha'e katu osareko reko oĩ-vy hese kwéry: —Ojéhegwi rei nonheresendéi arã avave. Nhandejáry ha'e anho mante oĩ ne resendeharã. Ha'e opamba'e rereko kwaaha voi, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Upe ramo he'i Pedro: —Upe imba'e reta va'e, mba'eve voi novendéiry ne moirũ hagwã-rehe, he'i. —Ha ore katu opamba'e oroheja oromoirũ hagwã. Mbava'e tipo ombohekovia va'erã ore-vy? he'i íxupe Pedro oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Anhetegwa va'e amombe'u-ta peẽ-my, he'i. —Peẽ xe moirũ va'e ame'ẽ va'erã peẽ-my gwarã. Upe Nhandejáry ombopyahupa omoatyrõmbaha áry-py, xe Nhande Ryke'y tee va'e agwapy va'erã Nhandejáry ogwapy haty-rehe. Pe apyka resaupa hesakã va'e ári agwapy va'erã enterove areko hagwã hembiapokwe pokwe-rehe. Upe áry-py peẽ ave pegwapy va'erã mburuvixa ogwapy haty-rehe doze apyka ári pegwapy ave va'erã pereko hagwã hembiapokwe pokwe-rehe Israel re'ýi kwéry doze tetã tetã-rupi oiko va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ãy ha'e-ta enterove va'e-pe: Xe-rehe ha-py nde róga pygwa ereheja ramo, ombohekovia va'erã nde-vy ne rembiejare. Xe moirũ hagwã nde ryke'y ereheja ramo, nde ryvy ereheja ramo, ne reindy ereheja ramo, nde ryke ereheja ramo, nde kypy'ýry ereheja ramo, nde kyvy ereheja ramo, nde ru ereheja ramo, nde sy ereheja ramo, nde ra'y, nde rajy ereheja ramo, ne memby ereheja ramo, nde yvy ereheja ramo ave xe moirũ hagwã, ombohekoviarõ va'erã nde-vy ne rembiejare-rehe. Nde rexakwaa rei jevy va'erã. Hetave arã ome'ẽ va'erã nde-vy. Peteĩ ereheja va'ekwe rekovia ome'ẽ va'erã nde-vy cem peve, he'i. —Ereikove meme va'erã Nhandejáry ndive erepave'ỹ reheve. ");
INSERT INTO kgkNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Heta oĩ ãy onhemboeteve va'e. Ha upe rire katu ndatuvixa mba'éiry va'erã Nhandejáry-pe. Heta oĩ ãy onhemboete e'ỹ va'e. Ha upe rire katu tuvixa mba'e va'erã Nhandejáry-pe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Heta oĩ ãy onhemboete e'ỹ va'e. Ha upe rire katu tuvixa mba'e va'erã Nhandejáry-pe” he'i kuri Hesu. Upéa nhe'ẽ kwaa uka-vy gwemimbo'e kwéry-pe omombe'u íxupe arandu rehegwa nhe'ẽ uvaty járy rehegwa nhe'ẽ rami: —Oĩ va'ekwe uvaty járy, ha'e oporomomba'apo va'ekwe. Upe uvaty járy he'i Nhandejáry nhande ruvixa-rehe. Voi osẽ oho-vy oheka omba'apo va'erã uvaty-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","—Otopa ramo: “Peteĩ áry ne rembiapo repy ame'ẽ-ta nde-vy” he'i omba'apo va'erã-pe. Inhe'ẽ omoporã rire, “Tapeho pemba'apo xe uvaty-py” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ha upéi katu asaje ramo osẽ jevy oho-vy ijáry. Praça-py omba'apose va'e omomba'apoharã-pe oha'arõ haty-py oho ramo, ohexa omba'apo e'ỹ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Peẽ ave tapeho pemba'apo xe uvaty-py” he'i, “Ne rembiapo repy ame'ẽ va'erã nde-vy” he'i omba'apo va'erã-pe. Inhe'ẽ-py oho omba'apo. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Upéi larose osẽ jevy oho-vy. Otopa jevy ramo nomomba'apói íxupe va'e, omba'apo e'ỹ va'e, “Pemba'apo” he'i. “Ne rembiapo repy ame'ẽ va'erã nde-vy” he'i íxupe. Upéi ka'arugwasu osẽ jevy oho-vy. Otopa jevy ramo nomomba'apói íxupe va'e-pe, “Pemba'apo” he'i jevy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Upéi ka'aru ete osẽ jevy oho-vy otopa jevy omba'apo e'ỹ va'e, onhembo'y oĩ va'e-pe: “Ma'erã tipo penhembo'y rei peĩ-vy a-py ka'aru peve? Ma'erã tipo napemba'apói?” he'i íxupe kwéry oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Noromba'apói nore momba'aposéi-gwi” he'i uvaty járy-pe. “Aipo ramo, peẽ ave iporã peho pemba'apo xe uvaty-py” he'i omba'apo va'erã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ka'aru pytũ-ma jave, ijáry he'i gwembigwái-pe: “Ehenói omba'apo va'e kwéry-pe ou hagwã. Eme'ẽ peteĩ teĩ-pe hembiapokwe repy. Gwĩ ka'aru ae omba'apo va'e-pe, eme'ẽ ranhe íxupe. Ha upe rire katu eme'ẽ gwĩ voi gwive omba'apo va'e kwéry-pe” he'i gwembigwái-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ou ramo gwĩ ka'aru eteve omba'apo va'ekwe ome'ẽ íxupe peteĩ áry hembiapo repy. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Upéi ou ave gwĩ voi gwive omba'apo va'ekwe: “Ome'ẽve-ta nhande-vy” he'i mo'ã ojéupe. Ha ambue kwéry-pe ome'ẽha-rami ave ome'ẽ íxupe. Peteĩ áry hembiapo repy ae ome'ẽ íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ome'ẽ ramo, “Ma'erã po ambue kwéry-pe ereme'ẽha-rami ave ore-vy ereme'ẽ?” he'i ojáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Gwĩ ka'aru ete omba'apo va'ekwe sapy'a ete omba'apo. Mixĩ mante omba'apo. Ma'erã po ore-vy ereme'ẽha-rami ave ereme'ẽ íxupe?” he'i. “Ore kwéry katu ore kane'õ-ma oromba'apo-vy. Kwarahy hakugwasu-rupi oromba'apo. Voi gwive ka'aru ete peve oromb'apo” he'i. “Ma'erã po hetave nereme'ẽi ore-vy? Ka'aru ae omba'apo va'e-gwi ore oroganave va'erãgwe” he'i ijáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Xe rapixa” he'i. “Ndajapo vaíry nde-rehe” he'i. “Peteĩ áry ne rembiapo repy ame'ẽ-ta nde-vy, ha'e ramo, eremoporã-ma kuri xe nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eraha ne rembiapokwe repy tereho. Nde-vy ame'ẽha-rami ave ame'ẽse gwĩ ka'aru ete ae omba'apo va'ekwe-pe” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“Ndaipóri xe jokoharã xe ame'ẽse va'e ame'ẽ va'erã. Aiporiahuvereko kuri gwĩ ka'aru ete ae omba'apo va'ekwe-pe. Upéa-gwi nande a'éiry nipo ra'e xe-rehe” he'i omba'apo va'e-pe ijáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Upéixa ete heta oĩ ãy onhemboete uka e'ỹ ete oiko va'e. Ha upe rire katu tuvixa mba'e va'erã Nhandejáry-pe. Heta oĩ ãy onhemboete ukaseve va'e. Ha upe rire katu natuvixa mba'éiry voi va'erã Nhandejáry-pe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ha upéi katu Hesu ojeupi upi oho-vy. Jerusalém tetã-my ogwahẽ hagwã oho-vy. Ogwata jave ogwenohẽ gwĩ doze gwemimbo'e. Te'ýi jusu avyte-gwi íxupe kwéry anho ogwenohẽ omombe'u hagwã ojéupe oiko-ta va'e: ");
INSERT INTO kgkNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Pejeapysaka katu, he'i. —Jaha jaiko-vy Jerusalém tetã-my. Upe-py xe Nhande Ryke'y tee va'e xe pyhy va'erã xe me'ẽ hagwã pa'i ruvixa kwéry-pe, judeu rekombo'ehaty kwéry-pe ave. Upe-py, “Iporã eremano” he'i va'erã xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Upéi xe me'ẽ va'erã nhande kwéry e'ỹ va'e-pe xe-rehe onhembohory hagwã, xe mbopi hagwã, xe juka hagwã kurusugwasu-rehe xe rupi-vy, he'i. —Ha upe rire katu mbohapy áry rire anhemoingove jevy-ma va'erã, he'i gwemimbo'e kwéry anho-pe onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Upe ramo ogwahẽ ou-vy Hesu renda-py Zebedeu ra'y sy. Tiago João ndive ou isy. Onhesũ íxupe gwetypy'ã-rehe omba'e jerure hagwã: ");
INSERT INTO kgkNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—Mbava'e tipo ereipota? he'i kunha-pe. —Ne nhe'ẽ-py togwapy nde yke-rehe joja xe memby. Erejehexa uka ramo nhande ruvixa ramo, togwapy nde yke-rehe peteĩ nde akatúa-koty. Peteĩ nde asu-koty ave togwapy, he'i Hesu-pe ombotuvixa ukaseve-vy mo'ã omemby. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Upéi ha'e he'i: —Ndapeikwaái pene rembijerure-rehe, he'i. —Xe mbohasa asy hagwã-rami ave, pehasa asy-ta para'e, he'i oporandu-vy Zebedeu ra'y Tiago João ndive-pe. —Ha'e voi, he'i. —Ne ndive ore orohasa asyse, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Néi, he'i. —Xe mbohasa asy hagwã-rami ave, pehasa asy va'erã voi, he'i mokõigwa-pe. —Ha xe Ru nde'íry apombogwapy hagwã xe yke-rehe joja. Ha'e ae ombogwapyse va'e ae, ombogwapy va'erã xe yke-rehe. Ajehexa uka ramo nhande ruvixa ramo, ha'e ae ombogwapyse va'e ombogwapy arã xe yke-rehe, he'i mokõigwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ha hemimbo'e ojerure e'ỹ va'e katu oĩ dez. Ohendu-ma ramo onhembotuvixaseve mo'ã va'e-pe ogweropoxy voi. Tyvýry reheve Tiago-rehe ipoxy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ha Hesu katu he'i: —Peju katu xe ha-py, he'i entéro gwemimbo'e kwéry-pe. —Peikwaa voi judeu e'ỹ kwéry rekoha, Nhandejáry kwaa e'ỹha rekoha. Huvixa kwéry omanda voi hese oiko-vy. Ipu'aka voi hese gwĩ onhemboete va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","—Upe va'e rekoha-rupi xe ndaipotái peiko. Pende rekorã a-rami. Erenhembotuvixa mba'e ukase ramo, eiko katu nde rapixa rembigwái ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Erenhemboete ukaseve ramo, erejejokwái va'e-rami eiko, he'i. —Nde rerekoseha-rupi voi eiko. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Xe ave Nhande Ryke'y tee va'e jepe ndajúi va'ekwe xe rembigwái heta heta ajohu hagwã. Aju ae va'ekwe tembigwái-rami aiko hagwã. Ajejuka uka hagwã aju va'ekwe heta aresende va'erã-rehe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Osẽ jave Jericó tetã-gwi, heta te'ýi jusu avyte-py oho Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Upe-py tapegwasu rembe-py ogwapy oĩ-vy mokõi hesapyso e'ỹ va'e: —Hesu ko ra'e ohasa tape-rehe —oĩ he'i va'e íxupe. Upéa nhe'ẽ ohendu ramo he'i: —Ore poriahuvereko katu, Davi remiarirõre. Ore poriahuvereko katu, he'i onhe'ẽ hatã-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","—Pekirirĩmba katu, he'i íxupe ijaty va'e inhe'ẽ joko-vy. Ha ha'e ae katu onhe'ẽ hatãve: —Mbo'eháry, Davi remiarirõre, ore poriahuvereko katu, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Upe-ma ramo opyta Hesu. Ohenói ou hagwã: —Mbava'e tipo ereipota xe ajapo hagwã nde-rehe? oporandu hesapyso e'ỹ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Eipe'a katu ore resa, mbo'eháry, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ha'e katu oiporiahuvereko-ma hesapyso e'ỹ va'e-pe. Opo omoĩ hesa-rehe. Upe-ma ramo hesapyso jevy-ma hesapyso e'ỹ va'ekwe. Upe rire katu omokambara-ma íxupe tape-rupi iho ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ha upéi katu Hesu gwemimbo'e kwéry ndive ogwata oho-vy Jerusalém tetã-my. Hi'agwĩ oĩ ramo jepe tetã íxugwi, nogwahẽi joty upe-py oho-vy. Upe ramo ogwahẽ ranhe oho-vy Betfagé tetã mirĩ-my. Yvyaty Oliveiras-py ogwahẽ ranhe oho-vy. Upe ramo omondo mokõi gwemimbo'e gwenonde-rupi: ");
INSERT INTO kgkNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Tapeho upe tetã mirĩ-my xe renonde-rupi, he'i. —Upe-py ereike-ma ramo, pya'e eretopa va'erã mburika onhenhapytĩ va'e. Hendive mburika'i eretopa-ta ave. Ejora eru xe-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","—“Ma'erã erejapo upéa?” he'i ramo nde-vy upe pygwa, ere íxupe, “Oiporu-ta nhande ruvixa. Pya'e ogweruruka jevy-ta nde ha-py.” Upéi ne nhe'ẽ-py pya'e oheja arã peru mokõi xe renagwã, he'i mokõi gwemimbo'e-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Upéa he'i oiko hagwã myamyrĩ Nhandejáry nhe'ẽ-py omombe'u va'ety he'i hagwe-rami. Yma gware nhe'ẽ a-rami he'i: ");
INSERT INTO kgkNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Emombe'u Sião tetã mygwa-pe. Pehexa katu. Ogwahẽ-ma ou-vy pende ruvixagwasu. Pende ruvixagwasu ramo jepe, nonhembotuvixa mba'e ukáiry joty ogwahẽ ou-vy. Gweko kirirĩ reheve joty ou. Mburika ári ogwahẽ ou-vy. Mburika ra'y ári ou” he'i yma gware nhe'ẽ. Yma gware remimombe'ukwe-rupi, ãy oiko-ma Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ha upe mokõi hemimbo'e oho ojapo Hesu nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ogweru jevy mburika ta'ýry reheve. Omoĩ hi'ári oao. Upéi ojeupi-ma hi'ári Hesu oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Heta oĩ te'ýi jusu omomba'egwasu va'e íxupe. Omboi mboi oao oipyso hagwã Hesu renda opyrũ hagwã-rupi. Oikytĩ kytĩ omoĩ-vy yvy-rupi yvyra rogwe hakã reheve. Yvy-rupi omohasãi imoĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Osapukái joa henonde rupigwa. Hapykwerigwa osapukái ave imboete-vy: —Ereju-ma ra'e Davi remiarirõre ra'e, he'i íxupe. —Oromomba'egwasu voi, he'i íxupe. —Nhandejáry réry-py ra'e eregwahẽ-ma ereju-vy. Tande rovasa porã katu Nhandejáry. Nhamomba'egwasu katu íxupe, he'i Hesu-pe ijaty va'e kwéry hexa-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Upéi ogwahẽ oho-vy Jerusalém tetã-my. Upe-py oike rire, ndaipy'agwapyvéi-ma pe tetã mygwa. Ogweronhe'ẽmba rei hikwái oikwaase-vy: —Kiva'e po ou ra'e, kiva'e po ou ra'e? he'i oporandu randu-vy ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Upéa Hesu pe Nhandejáry nhe'ẽ-py omombe'u va'ety Nazaré da Galiléia gwigwa, he'i hese hikwái hendive ogwahẽ ou-vy va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Upéi oike Hesu Nhandejáry róga kakwaa-py. Upe-gwi omosẽmba omba'evende oĩ va'e-pe, omba'ejogwa oĩ va'e-pe omosẽ ave imondo-vy. Upe-py oĩ ave plata ombohekovia va'e hepy-rehe. Ombohekoviapa oiporu jevy va'erã-py. Imba'e renda ombovapy íxugwi kwéry. Ombovapy pykasu járy imba'e renda ave: ");
INSERT INTO kgkNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","—“Xe róga xe mboete haty-py héry va'erã oração apohaty” he'i Nhandejáry kwatia nhe'ẽ, he'i. —Ha peẽ katu pemoingo upe-py gwĩ oporosakea nhemi va'e, he'i Nhandejáry róga kakwaa roka-py omba'evende va'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ha hesapyso e'ỹ va'e, ikarẽ va'e ave katu ojereru íxupe Nhandejáry róga kakwaa-py. Ou ramo, ombogwera gwera íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ha pa'i ruvixa kwéry judeu rekombo'ehaty kwéry ndive katu ipoxy íxupe. Hembiapo porã jahexa e'ỹ va'e ohexa. Nhandejáry róga kakwaa-py mitãgwe nhe'ẽ ohendu: —Nde Davi remiarirõre voi ore oromboete oroiko-vy, he'i Hesu-pe mitãgwe. Upéa nhe'ẽ ogweropoxy judeu ruvixa kwéry: ");
INSERT INTO kgkNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—Erehendu-ma tipo mitãgwe nhe'ẽ? he'i hikwái oporandu-vy íxupe. —Ahendu voi mitã nhe'ẽ, he'i Hesu íxupe kwéry. —He'i Nhandejáry kwatia nhe'ẽ a-rami: “Erenhemomba'egwasu uka mitãgwe-pe. Mitã kambu-pe gwive erenhemomba'egwasu uka ave” he'i íxupe. “Ne mboete tee voi hikwái” he'i Nhandejáry kwatia nhe'ẽ. Pemonhe'ẽ rei upéa nhe'ẽ ndapeikwaáiry, he'i judeu ruvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Upéa he'i rire, oheja huvixa kwéry-pe. Osẽ Jerusalém tetã-gwi oho-vy. Ogwahẽ oho-vy Betânia tetã mirĩ-my. Upe-py oke. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iko'ẽ-my voi ou jevy Jerusalém tetã-my. Ou jave ovare'a ogweru. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ohexa figo máta tape rembe'y-rehe oĩ ramo. Oho ohexa hi'a pa ho'u hagwã mo'ã. Ha ogwahẽ ramo imáta-py, ndahi'áiry íxupe. Hogwe rei oĩ. Ndaipóri figo. Hesu he'i figo máta-pe: —Anive nde a, he'i íxupe. Upe-ma ramo ipirupa-ma voi oho-vy figo. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ohexa ramo, opondera hese ipiru ramo hemimbo'e kwéry: —Mba'éixa ipiru pya'e ra'e figo máta? he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ha Hesu he'i: —Anhetegwa va'e amombe'u-ta peẽ-my. Erejerovia tee ramo Nhandejáry-rehe, ererovia ku'a ku'a e'ỹ reheve ererovia ramo, kóa figo máta-rehe xe ajapo hagwe-rami ave nde erejapo va'erã, he'i gwemimbo'e kwéry-pe. —Iporãve va'e erejapo va'erã. Eremoĩ ramo ne nhe'ẽ upe yvyatyrusu-pe, “Ejeupi enheapymi hagwã ygwasu-py” ere ramo, oiko-ta nde-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","—Oime raẽ va'e-rehe erejerure ramo oração apo-vy, oiko va'erã ave nde-vy erejerovia tee ramo Nhandejáry-rehe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ha upéi katu oike jevy Nhandejáry róga kakwaa-py oporombo'e hagwã. Oporombo'e jave ogwahẽ ou-vy iha-py pa'i ruvixa kwéry. Gwĩ judeu ruvixa kwéry ou ave. Hesu rembiapo ndojohu porãi hikwái: —Kiva'e nhe'ẽ-py tipo ereporombo'e a-rami? he'i íxupe. —“Iporã ereporombo'e a-rami” kiva'e tipo he'i nde-vy ra'e ereporombo'e hagwã a-rami? he'i oporandu-vy Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hesu he'i: —Xe-vy peporanduha-rami ave aporandu-ta peẽ-my xe aikwaase pendéhegwi va'e-rehe, he'i íxupe kwéry Hesu. —Pemombe'u ranhe katu xe-vy peẽ-my aporandu-ta va'e-rehe, he'i íxupe Hesu. Upe rire, xe amombe'u-ta ave peẽ-my kiva'e nhe'ẽ-py pa aporombo'e, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Ãy aporandu ranhe-ta peẽ-my. Kiva'e nhe'ẽ-py oporomongarai araka'e João Batista amyrĩ? Nhandejáry nhe'ẽ-py para'e? Teko rei nhe'ẽ-py para'e? he'i íxupe kwéry. —Pemombe'u ranhe katu xe-vy, he'i huvixa kwéry-pe. Ha ha'e kwéry katu ndoikwaáiry onhe'ẽrã Hesu-pe: —Mbava'e ja'e rei-ta po Hesu-pe? he'i ojóupe oporandu randu-vy hikwái. —Nhandejáry nhe'ẽ-py oporomongarai va'ekwe João, ja'e ramo, “Ma'erã po ndapejeroviái araka'e hese?” he'i arã nhande-vy, he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","—Ha teko rei nhe'ẽ-py oporomongarai va'ekwe, ja'e ramo katu, nhane mytu'e'ỹ arã nhandéjehe, he'i ojóupe. —“Pende apu” he'i arã nhande-vy te'ýi jusu. “Nhandejáry nhe'ẽ-py omombe'u va'ety ae katu João” he'i arã. Mbava'e tipo ojapo arã nhande-rehe hikwái? he'i ojóupe huvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Upéa-gwi, —Ndoroikwaáiry, he'i mo'ã Hesu-pe okyhyje-gwi. —Aipo ramo, xe-vy napemombe'uiha-rami ave, kiva'e nhe'ẽ-py aporombo'e a-rami, ndaikwaa uka mo'ãi ave peẽ-my, he'i huvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Upéi he'i jevy íxupe kwéry ombo'ese-vy mo'ã: —Areko peteĩ arandu rehegwa nhe'ẽ amombe'u va'erã peẽ-my, he'i íxupe kwéry. —Oĩ va'ekwe mokõi ta'ýry va'e. Oho ranhe gwa'yrusu ha-py: “Tereho, ke'y, emba'apo etería xe uvaty-py” he'i gwa'yrusu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Aha-ta xe. Aha-tama xe amba'apo, xe ru” he'i ha ndohóiry. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Upéi oho gwa'ymirĩ ha-py: “Tereho, xiryvy, emba'apo katu etería xe uvaty-py” he'i. Ha xiryvy he'i: “Ndaha mo'ãi” he'i gwu-pe. Ha upe rire katu omboasy onhe'ẽgwe oho-vy xirivy gwu nhe'ẽ apo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ãy aporandu-ta peẽ-my: Kiva'e ojapo gwu nhe'ẽ? Tyke'ýry para'e? Tyvýry para'e? he'i oporandu-vy íxupe kwéry Hesu. —Tyvýry ojapo, he'i íxupe. —Aipo ramo, amombe'u-ta peẽ-my pende rekokwe. Gwĩ naimandu'a porãi hese va'e, nhane mbopaga uka va'ety kwéry, ikwimba'ese va'e kwéry ave omoirũ ranhe-ma Nhandejáry nhande ruvixarã-pe. Ha peẽ katu ne'írã pemoirũ Nhandejáry-pe. Pene renonde voive-ma ha'e kwéry omoirũ-ma íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","—Ojekwaa ou-vy va'ekwe João amyrĩ tape porã oikwaa ukase mo'ã-vy peẽ-my. Ha peẽ ndaperoviáiry joty va'ekwe inhe'ẽ. Ha gwĩ hekoha vai va'e ae ogwerovia inhe'ẽ. Gwĩ nhane mbopaga uka va'ety, gwĩ ikwimba'ese va'e ave katu ogwerovia-ma ave va'ekwe inhe'ẽ. Upéa pehexa ramo jepe, ndaperovái joty va'ekwe pende rekoha. “Anhei ete nipo ra'e” ndapejéiry joty va'ekwe João nhe'ẽgwe-rehe. Ndaperoviáiry joty va'ekwe inhe'ẽ, he'i huvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ha upéi katu omombe'u jevy huvixa kwéry-pe arandu rehegwa nhe'ẽ: —Pejeapysaka katu xe nhe'ẽ-rehe. Amombe'u-ta peẽ-my arandu rehegwa nhe'ẽ uvaty rehegwa-rami, he'i. —Oĩ va'ekwe heta yvy járy. Ha'e oho onhotỹ uva ojapo hagwã uvaty. Upéi ogweroajere imboty-vy. Ojo'o itakwa hykwere ryrurã. Omboyvate ojeupi hagwã orepara hagwã. Upéi ijáry oiporuruka omba'apo va'erã-pe. Hi'aju ramo, oipota omboja'o yva ojéupe. Ha upe rire katu osẽ mombyry oho-vy. Tetã ambue-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","—Hi'aju-ma ramo pe yva uva, ombou ivía ramo gwembigwái omboja'o íxupe hagwã mo'ã ombou. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ha uvaty-py omba'apo va'e katu oipyhy imboupyre-pe heraha-vy. Peteĩ va'e-pe oinupã. Peteĩ va'e-pe ojuka. Peteĩ va'e-pe ojapi japi ita-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hetave-ma ombou ivía ramo. Ha hemimbou ypy ogwereko hagwe-rami ave ogwereko íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ha upe rire katu ombou gwa'ýry. “Xe ra'y-pe katu omboete arã” he'i mo'ã ombou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ha gwĩ uvaty-py omba'apo va'e ta'ýry ohexa ramo katu, “Upéa uvaty jaryrã voi” he'i hese. “Jaha jajuka íxupe” he'i. “Uvaty-rehe nhanhembojáry arã” he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Upéa-gwi oipyhy íxupe. Omboyke uvaty-gwi ojuka. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ha upéi katu ogwahẽ jevy ou-vy ramo pe uvaty járy, mba'éixa ojapo-ta hese kwéry? he'i Hesu oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ha'e kwéry he'i: —Ogwahẽ ou-vy ramo, ojuka-ma va'erã katu gwĩ hembiapo vai va'e-pe, he'i. —Upéi ohekoviarõ va'erã outro omba'apo jevy va'erã. Hi'aju ramo pe yva uva, omboja'o va'erã ime'ẽ-vy yva aju heraha uka hagwã, he'i íxupe huvixa kwéry. Upéixa Hesu omombe'u judeu ruvixa kwéry rekoha vai uvaty rehegwa nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ha upéi katu he'i jevy judeu ruvixa kwéry-pe: —Pemonhe'ẽ nhe'ẽ teĩ peiko-vy yma gware nhe'ẽ Nhandejáry omoĩ uka va'ekwe kwatia-rehe, ha ndapeikwaáiry, he'i. —Yma gware nhe'ẽ a-rami he'i: “Ndovaléiry, he'i óga apoha ita-rehe. Ha upe ita katu ojohu vai ramo jepe, ojeporuve joty óga pytahoha ramo. Óga jekoha voi upe ita. Upéa Nhandejáry rembiapo porã, ja'e. Jahexa-vy, Iporã porã katu, ja'e Nhandejáry rembiapo-rehe” he'i xe-rehe yma gware nhe'ẽ. Ma'erã he'i va'e ndapeikwaáiry ra'e? he'i íxupe kwéry hekokwe mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Upéi he'i jevy: —Upéa-gwi ha'e-ta peẽ-my: “Xe moirũ katu pende ruvixarã” nde'ivéi-ma va'erã peẽ-my Nhandejáry. Ha peẽ kwéry e'ỹ va'e-pe katu, “Xe moirũ katu” he'i va'erã Nhandejáry. Ha'e kwéry ae katu ojapo va'erã hemimbota. Ogweroagwyje va'erã inhe'ẽ, he'i huvixa kwéry-pe hekorã mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Upéi oiporu jevy yma gware nhe'ẽ, Nhandejáry omoĩ uka va'ekwe kwatia-rehe. He'i íxupe kwéry: —“Upe ita-rehe ho'a va'e ojekaray'i va'erã ho'a-vy. Ha upe ita ho'a hese va'e omongu'i va'erã íxupe ho'a ramo hi'ári” he'i ójehe Hesu huvixa kwéry-pe hekokwe mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ha pa'i ruvixa kwéry fariseu kwéry ave ohendu Hesu nhe'ẽ. Uvaty rehegwa-rami ita rehegwa-rami ave arandu rehegwa nhe'ẽ ohendu hikwái. Ohendu ramo inhe'ẽ, oikwaa-ma ojehegwa nhe'ẽ hikwái: —Nhande rehegwa nhe'ẽ kuri omombe'u Hesu, he'i he'i ojóupe hikwaí. ");
INSERT INTO kgkNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Upéa-gwi upe judeu ruvixa oipyhyse mo'ã íxupe. Ha ndoipyhýiry: “Hesu ko Nhandejáry nhe'ẽ-py omombe'u va'ety” he'i hese te'ýi jusu. Ikyhyje-gwi, Hesu ndive heta oĩ va'e-pe nombopoxyséi-gwi, ndoipyhýiry íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ha upéi katu omombe'u jevy judeu ruvixa kwéry-pe. Arandu rehegwa nhe'ẽ jekarugwasu rehegwa nhe'ẽ-rami omombe'u: ");
INSERT INTO kgkNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Oĩ va'ekwe mburuvixagwasu ta'ýry omenda-ta va'e. Upe mburuvixagwasu he'i Nhandejáry nhande ruvixa-rehe. Ha omenda hagwã ta'ýry he'i ojapo hagwã omenda va'erã-pe jekarugwasu. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Upéi omondo gwembigwái gwemienói enói ohenói ou hagwã: “Peju katu jekarugwasu ajapo ha-py” he'i uka íxupe kwéry. Ha ndouséiry hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Upe-ma ramo omondo jevy joty outro gwembigwái ohenói uka-vy. He'i gwembigwái-pe: “Tapeho pemombe'u xe nhe'ẽgwe. Xe jekarugwasu amoĩmba-ma. Ojuka-ma kuri xe rymba vaka ra'y onhemongyra va'ekwe. Ojapo va'erã gwive ojapopa-ma kuri. Peju katu jekarugwasu ojejapo ha-py, peje kuri pemombe'u gwĩ ou va'erã-pe” he'i gwembigwái-pe imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ha hemienói mo'ã katu nopenái voi inhe'ẽ-rehe ou hagwã. Gwembiapo apo-rupi joty oho hikwái. Peteĩ oho kokwe-py, outro oho omba'e vende haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ha outro kwéry katu oipyhy hembigwái-pe. Onhembohory hese ojuka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ha mburuvixagwasu ogweropoxy eterei-ma upe hembiapo vai vai va'ekwe-rehe. Omondo soldado kwéry hese ogweru hagwã hereko asy uka-vy. Ojuka hagwã gwĩ oporojuka va'ekwe-pe, omondo heko heko ha-rupi ohapy hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ha upéi katu he'i jevy outro gwembigwái-pe: “Oĩmba-ma xe jekarugwasu ha xe remienoikwe xe motĩ voi” he'i. “Hekoha vai okwa-gwi, ndoúi okaru” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Upéa-gwi tapeho tapegwasu gwasu-rupi. Petopa va'e gwive peru okaru hagwã,” he'i. “Jaha katu jekarugwasu ha-py” peje íxupe kwéry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Inhe'ẽ-py osẽ hembigwái kwéry oho-vy tapegwasu-rehe. Omboaty aty heru-vy otopa va'e gwive ogweru. Hekoha porã va'e, hekoha vai va'e ave ogweru. Jekarugwasu oikoha renda-py omohynyhẽ heru-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Upéi mburuvixagwasu oike upe-py hemienoikwe rexa-vy. Oĩ peteĩ ou va'e nomondéi ra'e omendaha pygwa ao. Oao ae ra'e omonde ou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“Xe rapixa” he'i. “Ma'erã po ereike ra'e ko'a-py omendaha pygwa ao e'ỹ reheve?” he'i oporandu-vy íxupe. Mba'eve nde'íry oike rei va'e. Okirirĩ rei oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Upe-ma ramo: “Eipokwa eipykwa ave íxupe. Emosẽ íxupe imondo-vy pytũ kwa-py” he'i. “Upe-py ojahe'o va'erã. Nhandejáry-rehe onhemoyrõ-gwi” he'i, “onhemohãingyry ngyrýu va'erã oiko-vy. Hasẽ va'erã onhemboasy-vy” he'i gwembigwái-pe mburuvixagwasu, he'i Hesu arandu rehegwa nhe'ẽ mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Upe rire he'i: —Heta va'e-pe, “Xe moirũ katu pende ruvixarã” he'i ramo jepe Nhandejáry, ndahetáiry joty omoirũ va'erã íxupe. Ndahetáiry joty hembiporavo, he'i Hesu Nhandejáry irũ rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Upe ramo gwĩ fariseu kwéry onhomboaty oje'ói-vy: —Mba'éixa nhamonhe'ẽavy-ta Hesu-pe jaipyhy uka hagwã íxupe, he'i oporandu randu-vy ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Upéi ombou iha-py gwemimbo'e mburuvixagwasu Herodes re'ýi ndive: —Orohexa kwaa-ma voi nde reko apu e'ỹha nde-rehe, mbo'eháry. Ne nhe'ẽ ndojohu porãi ramo jepe, eremombe'u joty anhetegwa voi eremombe'u va'e. Avave-gwi neretĩry eremombe'u hagwã. Nhandejáry remimbota eremombe'u voi. Erehexa kwaa voi hekoha enterove-rehe. Upéa-gwi anheiha-rupi ne remimombe'u Nhandejáry rape kwaa uka-vy, he'i omboheko jejavy hagwã mo'ã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","—Aipo ramo, iporã para'e nhande, judeu reko-rupi jaiko va'e, japaga nhame'ẽ-vy mburuvixagwasu César-pe hemimbopaga uka? Iporã para'e japaga e'ỹ? he'i. —Ne mba'e tipo eremombe'u arã ore-vy upéa-rehe oroikwaa hagwã, he'i íxupe omonhe'ẽavyse-vy mo'ã hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ha ha'e ohexa kwaa hese hekoha vai: —Peẽ katu pende py'a ky'aha pemo'ã kwaa va'e, he'i. —Ma'erã xe monhe'ẽavyse? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—Pehexa uka xe-vy plata atã mburuvixagwasu remimbopaga uka, he'i huvixa kwéry-pe. Peteĩ ogweru. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—Kiva'e ra'anga pa upe va'e plata atã? Kiva'e ohai uka va'ekwe plata atã-rehe? he'i oporandu-vy íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—César ra'anga hembihai uka ave, he'i íxupe hikwái. Ha Hesu he'i: —Aipo ramo, César-pe imba'e eme'ẽ. Ne mbopaga uka ramo, eme'ẽ jevy íxupe, ijáry-pe. Ha Nhandejáry-pe katu hemimbota eme'ẽ íxupe, he'i huvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Upéa ohendu ramo, opondera Hesu nhe'ẽ-rehe hikwái. Ha ha'e kwéry he'i: —Hasy va'e-rehe jepe nhaporandu ramo íxupe, omombe'u porã joty nhande-vy, he'i hese opondera-vy hikwái. Upéi oheja íxupe oje'ói-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Upe áry-py ogwahẽ ou-vy henda-py gwĩ saduceu kwéry, “Nonhemoingove jevýi va'erã gwĩ omano va'ekwe” he'i va'e. Ou ramo he'i: ");
INSERT INTO kgkNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mbo'eháry, he'i Hesu-pe hikwái, —Moisés amyrĩ omombe'u va'ekwe nhande-vy nhande rekorã. “Kwimba'e omano ramo, oheja ramo gwembirekokwe naimembýi reheve, tomenda jevy tyvýry gwovajare-rehe. Upéixa ramo, Ke'y ra'y, he'i va'erã imemby ypy-rehe” he'i nhande-vy va'ekwe Moisés. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oĩ va'ekwe peteĩ tyke'ýry, seis tyvýry. Tyke'ýry omenda kunha-rehe. Upéi omano ta'ýry e'ỹ mboyve. Tyvýry omenda gwovajare-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tyvýry omano ramo, ndaita'ýryi ave. Upéi tyvýry ambue jevy omenda omano jevy ave. Peteĩ teĩ omenda hese gwovajare-rehe. Peteĩ teĩ omano ramo, ndaita'ýry jepéiry. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Omanomba rire, upe kunha omano ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nhane moingove jevy ramo, kiva'e rembirekorã upe kunha? Gwĩ sete tyvýry kwéry omenda ra'e hese, he'i Hesu-pe hikwái hasy va'e-rehe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Upéi Hesu he'i íxupe kwéry: —Pejavy-ma voi pene nhe'ẽ, he'i. —Nhandejáry nhe'ẽ kwatia-rehe ohai uka va'ekwe peẽ ndapeikwaáiry. Peẽ ndapeikwaái voi ave Nhandejáry opamba'e rereko kwaaha voi, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","—Nhane moingove jevyha áry-py, kwimba'e nomendavéi-ma va'erã. Kunha ave nomendavéi-ma va'erã. Oiko va'erã Nhandejáry rembigwái yváy pygwa reko-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Ha Nhandejáry kwatia nhe'ẽ katu omombe'u peẽ-my omano va'ekwe oikove jevymaha: “Xe katu Nhandejáry, xe Abraão járy, xe Isaque járy, xe Jacó járy ave” he'i Nhandejáry kwatia nhe'ẽ, omano va'ekwe oikove jevy-ma va'e oikwaa ukaha. Ma'erã ndapeikwaái pemonhe'ẽ nhe'ẽ va'ekwe? Aipo ramo, Nhandejáry ndaha'éi omano va'ekwe járy, tekove járy ae. Ha'e onhemoingove jevy va'e járy, he'i saduceu kwéry-pe nhane moingove jevyha kwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Upéa ohendu ramo, te'ýi jusu opondera hese: —Hasy ete va'e-rehe jepe oporandu ramo Hesu-pe, omombe'u porã joty oporombo'e-vy, he'i hese te'ýi jusu pygwa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ha upéi katu oĩ fariseu kwéry-pe omombe'u va'e: —Hesu ndive onhonhe'ẽ mbojevy jevy rire, ndoikwaavéi-ma onhe'ẽrã saduceu kwéry. Okirirĩmba-ma, he'i. Upéa ohendu ramo, ojogweroaty fariseu kwéry ou-vy Hesu renda-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fariseu pa'ũ-gwi peteĩ va'e, tekoha mombe'uhaty oporandu Hesu-pe omonhe'ẽavyse-vy: ");
INSERT INTO kgkNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mbo'eháry, he'i, —Heta oĩ nhande rekoha nhe'ẽ. Kiva'e tuvixave va'e? he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ha Hesu oiporu Nhandejáry kwatia nhe'ẽ. He'i íxupe: —“Ehayhu tee katu Nhandejáry-pe. Nde py'apy gwive ehayhu íxupe. Ehayhu íxupe nde koty gwive. Ne mandu'a meme katu hese hayhu-vy” he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","—Upéa nhande rekoha tuvixave va'e, nhande rekoha ypyve va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ha upe rire katu oĩ outro tuvixa va'e: “Ehayhu rei katu nde rapixa-pe nde ae nde rekove erehayhuha-rami” he'i Hesu Nhandejáry kwatia nhe'ẽ poru-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","—Upe mokõi nhe'ẽ-py ogwenohẽmba Moisés amyrĩ remimombe'ukwe tekoha rehegwa nhe'ẽ, gwĩ Nhandejáry nhe'ẽ-py omombe'u va'ety nhe'ẽ ave. Mokõi nhe'ẽ-py he'ipa, he'i fariseu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseu avyte-py oĩ jave Hesu, oporandu. He'i: ");
INSERT INTO kgkNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Mbava'e tipo peje ra'e Cristo Nhandejáry rembiporavo va'e-rehe? Kiva'e remiarirõ pa ha'e? he'i oporandu-vy fariseu kwéry-pe. —Davi amyrĩ remiarirõre voi, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—Aipo ramo, ma'erã po Davi ohenói íxupe xe Járy-py? Nohenói reíry íxupe. Ome'ẽ va'ekwe íxupe inhe'ẽrã Nhe'ẽ Marangatu tee va'e, he'i Hesu. —He'i va'ekwe Davi: ");
INSERT INTO kgkNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Nhandejáry he'i xe Járy-pe, Egwapy katu xe yke-rehe. Xe orombopu'aka va'erã ne a'e'ỹha-rehe. Orombopu'akapa peve eregwapy va'erã ereĩ-vy xe yke-rehe” he'i Davi va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Upéixa, xe Járy-py ohenói va'ekwe íxupe. Aipo ramo, hemiarirõ pa? Ha gwemiarirõ-rehe, “Xe Járy” nde'íry, he'i fariseu kwéry-pe Hesu omokirirĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Upe ramo, onhe'ẽrã ndoikwaáiry avave. Upe áry rire, ndaipy'agwasuvéi-ma oporandu-vy íxupe avave. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ha upéi katu omombe'u jevy Hesu te'ýi jusu-pe. Gwemimbo'e kwéry-pe ave omombe'u jevy hekorã: ");
INSERT INTO kgkNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Gwĩ judeu rekombo'ehaty kwéry fariseu kwéry ave omombe'u peẽ-my Moisés amyrĩ remimombe'ukwe. Nhandejáry nhe'ẽ-py omombe'u peẽ-my oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Upéa-gwi pehendu inhe'ẽ entéro he'i va'e gwive peẽ-my pejapo katu. Ha ha'e kwéry ae ndojapói peẽ-my he'iha-rami. Ombo'e mbo'eha-rupi ndoikói. Upéa-gwi inhe'ẽ pehendu ramo jepe, ha'e kwéry ae heko-rupi ani peiko joty katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","—Nhandejáry nhe'ẽ omombe'u rire, hasyve jajapo va'erã nhe'ẽ omombe'u nhande-vy. Jareko asy nhane rymba mba'e ipohýi eterei nhamoĩ ramo hese. Upéixa ete hasy nhe'ẽ jajapo va'erã omombe'u nhande-vy. Nhane rymba ipohýi va'e ogweraha ramo, nhande ae mba'eve ndajarahái. Nanhaipytygwõiry. Upéixa ete ha'e kwéry nanhane pytygwõiry voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Ojehexa uka porã hagwã ojapopa. Osyva-rehe, ojyva-rehe ave ojokwa imoĩ-vy Nhandejáry nhe'ẽ. Ombotuvixave ojokwa va'ekwe ojehexa porãve hagwã. Ojehexa hagwã ombopuku oao poty. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jekarugwasu-py oho ramo, óga járy yke-rehe ogwapyse onhemboete ukase-vy. Ojeporahéi haty-py oho ramo, mburuvixa kwéry pa'ũ-my ogwapyse. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mba'e jogwa haty-py oho ramo, onhemboete ukase-vy oho. Ojererovy'a ukase-vy gwapixa kwéry-pe oho. “Porombo'ehaty” oipota he'i ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—Ha peẽ katu ojoe'ýi. Pene mbo'eháry xe voi. Upéa-gwi, “Porombo'ehaty” ndaipotái peje ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Peteĩ oĩ pende Ru yváy pygwa. Upéa-gwi yvypóry-pe rei, ani peje teĩ, “Nhande Ru”. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Xe Cristo xe anho-ma ngatu pene mbo'eharã. Ndaipóri outro. Upéa-gwi, ani peje teĩ ojóupe, “Xe mbo'eháry” peje. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pene pa'ũ-my erenhembotuvixa mba'e va'e, eiko katu nde rapixa rembigwái ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Upe onhembotuvixa mba'e ukaseve va'e-pe katu nomboetéi va'erã voi Nhandejáry. Ha onhemboete ukasere'ỹ va'e-pe katu, omboete-ma va'erã voi Nhandejáry, he'i upe pygwa-pe Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Upe ramo, ojerova oma'ẽ-vy judeu rekombo'ehaty-rehe, fariseu kwéry-rehe ave: —Apomboasy voi peẽ-my. Pehasa asy va'erã peẽ. Peẽ katu pende py'a ky'aha pemo'ã kwaa. Pejoko omoirũse va'e-pe omoirũ e'ỹ hagwã Nhandejáry gwuvixarã-pe. Peẽ ae napemoirũséi íxupe. Ha imoirũseháry katu ndapeipotái omoirũ íxupe. Upéa-gwi pehasa asy va'erã, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Apomboasy voi peẽ-my. Pende poriahu va'erã. Pehasa asy va'erã peẽ, pende py'a ky'aha pemo'ã kwaa va'e. Tembirekokwe rembiporu pemonda heraha-vy. Upéi pejehexa uka porã hagwã, pene nhe'ẽ mbuku oração apo-vy Nhandejáry-pe. Upéa-rehe pene mbohasa asyve va'erã Nhandejáry. Apomboasy voi peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Pehasa asy va'erã peẽ pende py'a ky'aha pemo'ã kwaa va'e. Opa-rupi pegwata peho-vy. Tetã tetã-rupi peho ygwasu-rupi peho ave. Hatã eterei pemba'apo peteĩ judeu e'ỹ va'e ojehesa rerova uka hagwã pendéjehe. Ha upe rire katu ojehesa rerova uka rire, pembohekoha vai íxupe. Upe pemokambara íxupe va'e, pende rekoha vaiha-rami, pembohekoha vaive pendéhegwi. Upéa-gwi oromboasy voi, he'i fariseu kwéry ndive judeu rekombo'ehaty-pe. Upéi he'i jevy: ");
INSERT INTO kgkNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Pehasa asy va'erã peẽ. Ndapehexái pene renonderã. Upéixa reheve peporogwerahase joty mo'ã. Ndohexái gwenonderã va'e-rami peiko. Upéixa reheve peporombo'ese mo'ã joty peiko-vy. Peporombo'e avy peiko-vy: “Ajapo-ta xe nhe'ẽ Nhandejáry róga kakwaa réry-py ajapo-ta xe nhe'ẽ, ja'e ramo, ja'e rei. Ndajajapói ramo jepe nhane nhe'ẽ, mba'eve joty ndajajejavýi” peje mo'ã peiko-vy. Ha “Ajapo-ta xe nhe'ẽ Nhandejáry róga pygwa ouro gwigwa réry-py, ja'e ramo katu ndaja'e reíry. Ndikatúiry nhande apu ja'e va'ekwe-rehe. Jajapo-ta mo'ã va'ekwe-rehe, ndajajapói ramo, jajejavy-ma va'erã” peje peporombo'e avy-vy. Ha ha'e-ta peẽ-my: “Nhandejáry róga réry-py” ja'e ramo, “Nhandejáry róga pygwa ouro gwigwa” ja'e ramo ave peteĩxa. Pene remimoĩ mokõi mo'ã, ha xe katu amopeteĩxa joty. Peporombo'e avy voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Peẽ pene arandu e'ỹ. Ndohexái gwaperã va'e-rami peiko. Ma'erã, “Gwĩ Nhandejáry pygwa ouro gwigwa tuvixa mba'eve Nhandejáry róga-gwi” peje? Ndaha'éi upéixa. Nhandejáry róga kakwaa ae katu omomarangatu gwĩ ouro gwigwa, he'i inharandu e'ỹha kwaa uka-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Upéi he'i jevy: —A-rami peporombo'e avy peiko-vy: “Oĩ upe apykagwasu hi'ári nhamoka'ẽ haty Nhandejáry mboete-vy, altar héry va'e. Ha'e héry-py ajapo-ta xe nhe'ẽ, ja'e ramo, ja'e rei” peje. “Ha, Ajapo-ta apykagwasu ári Nhandejáry-pe nhane remime'ẽrã réry-py, ja'e ramo katu, ndaja'e reíry. Ndikatúi nhande apu ja'e va'ekwe-rehe” peje mo'ã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","—Pehexa e'ỹ va'e-rami peiko, he'i. —Ma'erã, “Nhane remime'ẽrã tuvixa mba'eve upe apykagwasu-gwi” peje. Ndaha'éi upéixa. Upe apykagwasu ae katu omomarangatu nhane remime'ẽrã hi'ári nhamoĩ va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","—Aipo ramo, “Upe apykagwasu kakwaa réry-py ajapo-ta xe nhe'ẽ” peje ramo, “Entéro apyka ári oiko va'e gwive réry-py ajapo-ta xe nhe'ẽ” he'i hagwe-rami ave peje. Ndikatúiry pejapo e'ỹ pene nhe'ẽ. Pene remimoĩ mokõi mo'ã, xe amopeteĩxa joty, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","—“Nhandejáry róga réry-py ajapo-ta xe nhe'ẽ” peje ramo, “Nhandejáry róga-py oĩ va'e réry-py ajapo-ta xe nhe'ẽ” he'i hagwe-rami ave peje. Peteĩxa ijoja pene nhe'ẽ. Ndikatúiry pejapo e'ỹ pene nhe'ẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","—“Yváy pygwa réry-py ajapo-ta xe nhe'ẽ” peje ramo, “Nhandejáry ogwapy haty réry-py ajapo-ta xe nhe'ẽ” he'i hagwe-rami peje. Upe-py ogwapy Nhandejáry nhande ruvixa. “Nhandejáry réry-py ajapo-ta xe nhe'ẽ” he'i hagwe-rami peje. Peteĩxa ijoja pene nhe'ẽ. Ndikatúiry pejapo e'ỹ pene nhe'ẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Upéi he'i jevy judeu rekombo'ehaty kwéry ndive fariseu kwéry-pe: —Apomboasy peẽ-my. Pehasa asy va'erã, peẽ pende py'a ky'aha pemo'ã kwaa va'e. Heta oĩ pene remitỹ ikarape va'e. Oĩ hortelã, oĩ erva doce, oĩ cominho. Upéa pene remi'urã ndive pene remimbojehe'arã pembohe porã hagwã tembi'u. Mixĩ eterei ramo jepe, dez-gwi peme'ẽ peteĩ joty Nhandejáry-pe. Ha Moisés amyrĩ remimombe'ukwe pende rekoharã tuvixave va'e-rehe katu napepenái. Imarangatuve va'e-pe napehenduséiry peiko-vy. He'i va'ekwe peẽ-my pejogwereko porã hagwã, pejoporiahuvereko hagwã, pende-rehe ojerovia tee hagwe-rami joty peiko hagwã. Upéa nhe'ẽ imarangatuve va'e napehenduséiry. Ha'e-ta peẽ-my: Mixĩve va'e-rehe pende resarái e'ỹha-rami ave, pepena katu tuvixave va'e-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","—Ndapehexái pene renonderã. Upéixa reheve peporogwerahase joty mo'ã. Pono mixĩ va'e reheve hoy'u, trapo-py ombogwa va'e-rami peiko. Ho'u va'erã-gwi oipe'ase va'e-rami peiko. Ha heta hi'upy e'ỹ reheve okaru va'e-rami peiko joty. Mixĩve va'e-rehe pepena. Tuvixave va'e-rehe ndapehexáiry. Tuvixave va'e-rehe napepenáiry, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Upéi he'i jevy gwĩ judeu rekombo'ehaty kwéry ndive fariseu kwéry-pe: —Apomboasy peẽ-my. Pende poriahu va'erã. Pehasa asy va'erã peẽ pende py'a ky'aha pemo'ã kwaa va'e. Eremopotĩ porã mo'ã kópo nde prato ave. Ijape rei eremopotĩ. Ipy pygwa katu neremopotĩry. Pendejéupe gwarã peipotave tave. Pemonda monda-py pekaru. Upéa-gwi nde kópo nde prato ave ijape rei eremopotĩ. Ipy pygwa katu naipotĩry. Ipy-py eremoĩ eremondapyre. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","—Ne arandu e'ỹ va'e. Hesapyso e'ỹ va'e-rami nde ereiko. Kópo eipyhéi ranhe. Upéixa hi'ári ipotĩ ave va'erã. Nde py'a potĩ ramo, ne rembiapo ave ipotĩ va'erã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Upéi he'i jevy gwĩ judeu rekombo'ehaty kwéry-pe, gwĩ fariseu kwéry-pe ave: —Apomboasy peẽ-my. Pehasa asy va'erã peẽ pende py'a ky'aha pemo'ã kwaa peiko va'e. Oĩ yta onhembojegwa va'ekwe morotĩ va'e-py. Ijehexa rei iporã ete voi. Ha ipy-py katu hynyhẽ oĩ-vy ivai va'e. Omano va'ekwe kãgwe heta oĩ ipy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Upéixa ete pende rekoha porã va'e-rami pende jehexa rei. Pende rova-py mba'eve ndaperekói. Pende koty py-py ivai voi. Pejapose va'e rei pejapo, he'i upe judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Upéi he'i jevy gwĩ judeu rekombo'ehaty ndive fariseu kwéry-pe: —Apomboasy eterei peẽ-my. Pehasa asy va'erã peẽ pende py'a ky'aha pemo'ã kwaa va'e. Pene ramói amyrĩ ojuka va'ekwe Nhandejáry nhe'ẽ-py omombe'u va'ety-pe. Heta hekoha porã va'e-pe ojuka ave va'ekwe. Ha ãy katu peẽ pejapo ijyta pemoĩ porã hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Peje ave: “Yma jaiko ramo ra'e, nanhamoirũiry arã ra'e nhane ramói amyrĩ-pe jajuka hagwã Nhandejáry nhe'ẽ-py omombe'u va'ety-pe” peje pendéjehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aipo ramo, pene nhe'ẽ-py gwĩ oporojuka va'ekwe remiarirõre voi ra'e peẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ha'e kwéry hekokwe-rami pende reko vai voi ra'e, he'i. —Aipo ramo, peiko katu hekokwe-rupi, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Peẽ mbói ipoxy va'e reko-rami peiko va'e. Pende ru reko vai niko mbói-rami. Mombyry ojéhegwi pene mondo va'erã Nhandejáry pende rereko asy hagwã-py. Ndaiporivéi pene resendeharã. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Upéa-rehe ambou va'erã peẽ-my gwĩ Nhandejáry nhe'ẽ-py omombe'u va'ety gwĩ hi'arandu va'e ave ambou va'erã, he'i. —Gwĩ porohekombo'e va'ety ambou va'erã ave peẽ-my. Oĩ gwĩ pene rembijuka ukarã. Oĩ gwĩ kurusugwasu-rehe pene remimoĩrã. Oĩ gwĩ peporahéi haty haty-rupi pene remimbopirã. Upéa tetã tetã-rupi pene remimosẽ mosẽrã. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Heta oĩ hekoha porã va'ekwe ne ramói amyrĩ rembia amyrĩkwe. Yma gware gwive ãy peve katu ojuka juka joty hekoha porã va'ekwe-pe. Yma ete oiko va'ekwe Abel amyrĩ. Ipy'a potĩ va'ekwe ha'e. Ha ojuka ypy íxupe va'ekwe. Upéi katu heta va'e-pema ojuka juka. Baraquias ra'y Zacarias amyrĩ peve, ojuka juka va'ekwe. Upe Zacarias Nhandejáry kwatia nhe'ẽ-rehe omoĩ paha-ma va'ekwe. Ha'e ipy'a potĩ va'e. Ha pene ramói ojuka joty íxupe Nhandejáry róga kakwaa-py. Imarangatu ete va'e ha-py, onhegwahẽ e'ỹ haty renonde-py, apykagwasu kupe-py, ipa'ũ-my ojuka íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Aipo ramo, anhetegwa va'e amombe'u-ta peẽ-my, he'i. —Abel amyrĩ gwive Zacarias amyrĩ peve ojuka meme hekoha porã va'e-pe. Upe ojejuka hagwe-rehe gwive apogwereko asy uka va'erã voi peẽ-my. Pene rembia amyrĩ-rehe apombohasa asy uka va'erã. Ãygwa ohasa asy va'erã entéro yma gwive ojejuka uka va'ekwe-rehe, he'i gwĩ judeu rekombo'ehaty-pe, fariseu kwéry-pe ave. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Upéi he'i Jerusalém tetã mygwa-pe: —Apomboasy eterei peẽ-my. Nhandejáry nhe'ẽ-py omombe'u va'ety pene rembijuka juka voi. Peẽ-my hemimbou ita-py pene rembiapi api voi. Upéixa pende reko jepe, xe apomboatyse tyse mo'ã joty peẽ kwéry-pe pene mitãgwe reheve apokwavã kwavãse-vy, he'i. —Yrugwasu ogwero'aha-rami gwa'ýry, apomboatyse mo'ã. Ha napenhekwavã ukaséi joty xe-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","—Pene retã peheja va'erã. Pende ro nde róga nandi-rupi oĩ va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Xe ha'e-tama ãy peẽ-my. Ndaxe rexa mo'ãvéi-ma ãy. Ha upe rire katu xe aju jevy ramo, “Nhandejáry réry-py eregwahẽ-ma ereju-vy. Tande rovasa porã katu Nhandejáry” peje va'erã. Upe áry-py xe rexa jevy va'erã peẽ, he'i Jerusalém tetã mygwa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ha upéi katu osẽ oho-vy Hesu Nhandejáry róga kakwaa-gwi. Oho jave ohogwaitĩ ogwahẽ-vy Hesu-pe hemimbo'e kwéry: —Ehexa katu óga kakwaa. Heta voi ikoty, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ha Hesu he'i: —Peẽ ae katu pehexa upéa óga kakwaa, he'i. —Ãy oime porã. Ha anhetegwa va'e amombe'u-ta peẽ-my, he'i. —Ita heta omohãimba va'erã, omosarambipa va'erã. Ndojepota mo'ãvéi ojóehe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ha upéi katu oho Hesu Oliveiras yvyaty-py. Hi'ári ogwapy. Ogwapy jave Hesu anho otopa ha-py oho hemimbo'e kwéry, he'i íxupe oporandu-vy: —Araka'e tipo omohãimba-ta? Araka'e tipo ojehu va'erã ne remimombe'u? he'i oporandu-vy íxupe. —Mba'éixa po oroikwaa va'erã imombe'uháry? Araka'e tipo ereju jevy va'erã? Opa-tama ramo ko yvy, mba'éixa po oroikwaa va'erã imombe'uháry? he'i oporandu-vy íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Upe ramo he'i Hesu: —Xáke pene mbotavyse va'erã. Ani joty pende tavy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Heta ojekwaa va'erã ou-vy xe réry-py vérami mo'ã ou va'e. “Xe Cristo pene remiha'arõ va'e voi” he'i va'erã mo'ã ójehe peẽ-my, onhembocristo ra'anga-vy, oporombotavy rei-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pehendu va'erã pene pa'ũ-rupi onhorairõ ramo. Mombyry onhorairõ va'e rerakwã pehendu ave va'erã. Pejeapysaka katu xe nhe'ẽ-rehe. Ani pekyhyje teĩ upéa-rehe. Upéa oiko va'erã voi. Upéa oiko-ma ramo, ne'írã vyteri ogwahẽ Nhandejáry nhe'ẽ apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ha tetã mygwa onhorairõ va'erã outro tetã mygwa ndive. Mburuvixagwasu re'ýi onhorairõ va'erã outro mburuvixagwasu re'ýi ndive. Ndaiporivéi-ma va'erã ho'u va'erã. Yvy ryrýi oiko va'erã ave heta renda-py. Opa-rupi ndoiko meméi ramo jepe, oiko va'erã joty, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","—Upéa-rupi pehasa asy ramo, ne'írã vyteri pehasa asy ete peiko-vy. Kunha imemby-ta va'e hasy íxupe. Ha upe rire katu hasyve syve oho-vy íxupe imemby hagwã. Upéixa ete yvypóry ohasa asy va'erã. Ha upe rire katu ohasa asyve syve oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Upe ramo pende pyhy va'erã pende rereko asy hagwã pende juka hagwã. Entéro tetã tetã rupigwa ndaija'éi va'erã pende-rehe. Xéhegwi katu pende rereko va'erã akói-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Upe-ma ramo heta ova va'erã Nhandejáry rape-gwi, he'i. —Ojopyhy uka va'erã ojóehe ija'e'ỹ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ojekwaa va'erã ojéhegwi rei omombe'use rei va'e. “Nhandejáry nhe'ẽ voi xe remimombe'u” he'i rei va'erã ójehe heko vai ombo'e hagwã. Heta oporombotavy rei va'erã oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hetave tave rei hekoha vai va'e. Heta hekoha vai oĩ va'e-gwi, hekoha porã va'e jepe, ndojohayhu porãve rãvéiry va'erã okwa-vy. Ojohayhu va'e-rami rei ojogwereko va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ha Nhandejáry rape-gwi ova e'ỹ va'e katu ko yvy opa ete peve, oresende va'erã íxupe Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Omombe'u ranhe va'erã opa-rupi nhe'ẽ porã. Nhandejáry nhande ruvixarã rehegwa nhe'ẽ omombe'u ranhe va'erã entéro tetã tetã-rupi oiko-vy, enterove ohendu hagwã. Ha upe rire ae katu omomba ete-ma va'erã ko yvy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Upéi oiporu Hesu Nhandejáry kwatia nhe'ẽ: —Kwatia-rehe Daniel amyrĩ remimoĩgwe a-rami he'i: “Oĩ va'erã pe ivai ete va'e, pene momarã va'e. Nhandejáry koty py-gwi pene mosẽ va'erã” he'i Hesu. Upéa nhe'ẽ eikwaa porã ãy eremonhe'ẽ va'e. Upéi he'i Hesu: —Yma he'i hagwe-rami, pehexa va'erã upe ivai ete va'e, Nhandejáry róga koty-py onhemoĩ ramo. Imarangatu ete va'e rendagwe-py, teko rei mba'e oĩ e'ỹ haty-py pehexa va'erã upe ivai ete va'e pene momarãharã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pehexa-ma ramo upe va'e, pya'e voi tokanhymba kuri Judéia yvy pygwa kwéry oje'ói-vy. Yvyatygwasu ári-rupi tokanhy kuri oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ogwejy ramo óga ári oĩ va'e, ani oike koty-py ogweraha hagwã mba'eve. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ha kokwe-py oĩ va'e ani oho jevy ranhe gwóga-py oipyhy hagwã oao. Pya'e ae kuri tokanhymba katu oje'ói-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","—Upe áry-rupi iporiahu va'erã kunha imemby-ta va'e, omokambu va'e ave. Apomboasy peẽ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","—Ro'y eterei-rupi pekanhy ramo, ivaive arã peẽ-my. Upéa-rehe pemoĩ katu Nhandejáry-pe pene nhe'ẽ pono ivai ete peẽ-my. Pono ro'yha óra-py ojehu, pono japytu'uha áry-py ojehu ave, pejapo oração. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Upéa áry-py ohasa asy eterei va'erã. Ko yvy rembypy oiko jave upéa áry e'ỹ mboyve ndohasa asy etéiry va'ekwe. Upéa áry-py ae ohasa asy eterei va'erã. Ha upe rire katu ndohasa asy etevéi-ma va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ha Nhandejáry katu nombohasa asy hetave áryiry va'erã. Ombohasa asy hetave áry ramo ra'e, opa-ma arã ra'e enterove ko yvypóry. Ha gwembiporavo-rehe opena porã-gwi ae katu, nombohasa asy hetave áryiry va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Upe-ma ramo, “Ema'ẽ katu. Upe va'e Cristo voi” oĩ he'i va'e para'e peẽ-my. “Ema'ẽ katu. Upe va'e Cristo voi” oĩ ave he'i va'e para'e peẽ-my. Ani perovia inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ojekwaa va'erã ou-vy hekoha vai va'e. “Cristo pene remiha'arõ va'e voi xe” he'i rei arã ójehe peẽ-my. “Nhandejáry nhe'ẽ amombe'u voi” he'i rei arã ave ójehe. Hexapyrã-rupi voi hembiapo va'erã ohekoporu ou-vy ramo. Ohexa uka va'erã gwembiapo tuvixa va'e, ikatu ramo itavy hagwã mo'ã íxupe Nhandejáry rembiporavo. Xáke. Ani joty pende tavy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pejeapysaka katu. Ko'ã mba'e oiko e'ỹ ngatu amombe'u-ma kuri peẽ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Aipo ramo, “Amoete tekwaty e'ỹ-my oime Nhande Ryke'y tee va'e” he'i va'erã para'e peẽ-my. Ani joty peho. “A-py koty-py oime Nhande Ryke'y tee va'e” he'i va'erã para'e peẽ-my. Ani joty pende tavy íxupe. Ani perovia joty inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Upéixa xe, Nhande Ryke'y tee va'e, ndaju jevy mo'ãiry. Kwarahy resẽ-gwi ka'aru peve overa va'e pehexaha-rami ae katu, xe aju jevy va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ojéhegwi rei yruvu mba'e retekwe-py pya'e ou meme va'e-rami ave ae aju jevy va'erã. Entéro xe remimombe'u oiko-ma ramo, aju jevy-ma va'erã, he'i Hesu omombe'u-vy gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Upéi he'i jevy Hesu: —Upe-ma ramo ohasa asy ete rire-ma, oje'o va'erã kwarahy rendy. Ha jasy nahendy mo'ãvéi. Ha okúi va'erã yváy-gwi jasytata. Ova ova va'erã gwendagwe-gwi entéro yváy rehegwa imbaraete va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Upe-ma ramo ojekwaa va'erã yváy-py oikwaa uka va'e xe aju jevy hagwã-rehe. Ha enterove tetã tetã mygwa ko yvy ári oĩ va'e gwive onheapirõ-vy ojahe'o va'erã. Xe Nhande Ryke'y tee va'e aju jevy ramo arai-rupi xe rexa va'erã. Xe pu'akaha reheve aju va'erã pende resa mbojevy va'erã xe rendy porã tee-gwi, xe rexa-ma va'erã aju ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mimbygwasu nhe'ẽ-py ambou va'erã xe rembigwái yváy pygwa ombojogweroaty hagwã heraha-vy xe rembiporavokwe. Opa-rupigwi ombojogweroaty va'erã. Kwarahy resẽ-gwi, kwarahy reike-gwi ave ombojogweroaty va'erã heraha-vy. Arapopy-gwi ave, yvyapy-gwi ave, yvyapy arendaja gwive ombojogweroaty va'erã, he'i íxupe kwéry omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Upéi he'i jevy Hesu: —Ãy amombe'u-ta peẽ-my ojehu va'erã rehegwa nhe'ẽ figo máta rehegwa-rami peikwaa porã hagwã xe agwahẽ jevytaha áry, he'i. —Oĩ figo máta. Hoky kyrýu jevy-ma ramo, hogwe pyahu jevy-ma ramo, pehexa-ma voi. Pehexa-ma ramo, peikwaa-ma voi opa-ma ra'e ro'y. Áry raku jevy-tama, peje. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","—Upéixa ete upe ojehu va'erã gwive pehexa ramo, peikwaa va'erã oike-ta va'e-rami xe agwahẽ jevytamaha áry. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Anhetegwa va'e amombe'u-ta peẽ-my. Entéro peẽ-my xe remimombe'u oiko va'erã. Judeu kwéry oiko reheve joty ojehu va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Opa va'erã áry yvy ave. Ha xe remimombe'u xe nhe'ẽ katu nombopapa mo'ãiry, he'i gwemimbo'e kwéry-pe omombe'u-vy gwenonderã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Upéi he'i jevy Hesu: —Mbava'e áry-py po ojehu va'erã ndajaikwaáiry, he'i. —Araka'e óra-ma po ojehu va'erã ndajaikwaáiry. Nhandejáry rembigwái yváy pygwa jepe ndoikwaáiry. Xe ta'ýry jepe ndaikwaái ave. Nhandejáry xe Ru ha'e anho mante oikwaa, he'i. —Araka'e óra-ma po aju jevy va'erã ndapeikwaái-gwi, perepara rei voi katu peiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","Xe Nhande Ryke'y tee va'e aju jevy ramo, yma gware-pe ojehu hagwe-rami ave ojehu jevy va'erã, he'i. —Yma ete Noé amyrĩ oiko jave, y ovu e'ỹ mboyve, okaru porã rei okwa-vy va'ekwe yma gware. Omenda va'ekwe okwa-vy. Upéixa va'ekwe oiko jave, oike-ma va'ekwe kanoagwasu-py Noé amyrĩ va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ojéupe ojehu va'erã ndoikwaái va'ekwe yma gware. Ojéupe ojehu va'erã-rehe naimytu'e'ỹiry va'ekwe oiko-vy hikwái. Upe-ma ramo, pya'e ovu íxupe kwéry imonhapymimbaharã y. Xe Nhande Ryke'y tee va'e aju jevy hagwã áry-py, upéixa ete ojehu jevy va'erã. Mbava'e nipo ojehu va'erã íxupe kwéry ndoikwaáiry yvypóry. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kokwe-py mokõi omba'apo jave, peteĩ ogweraha va'erã, peteĩ oheja va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Oĩ va'erã mokõi kunha oipokyty jave ojóehe itagwasu-py omongu'i hagwã. Peteĩ ogweraha va'erã, peteĩ oheja va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Upéa-gwi ha'arõ-vy perepara katu xe agwahẽ hagwã-rehe. Araka'e áry-pyma po xe pende Járy aju jevy va'erã ndapeikwaái-gwi, perepara rei katu peiko-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","—Pejeapysaka katu xe nhe'ẽ-rehe peikwaa porã hagwã. Óga járy rehegwa nhe'ẽ-rami amombe'u-ta peẽ-my peha'arõ hagwã peiko-vy. Óga járy-pe araka'e óra pyhare ou-ta imonda va'e he'i-vy, ndokéi arã ra'e orepara-vy. Nomoinge ukáiry arã ra'e imondase va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Upéixa ete perepara katu peiko-vy peẽ ave xe Nhande Ryke'y tee va'e aju jevy va'erã-rehe. Upéa-gwi xe ra'arõ-vy peiko katu, he'i gwemimbo'e kwéry-pe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Upéi oiporu jevy Hesu óga járy rehegwa nhe'ẽ jarepara porã hagwã nhande-vy oikwaa uka-vy. Tembigwái rekoha rehegwa nhe'ẽ-rami omombe'u: —Oĩ va'ekwe óga járy, he'i. —Heta oĩ hembigwái. Kiva'e po hekoha porã-ta, kiva'e po hekoha vai-ta amombe'u-ta peẽ-my. Óga járy mombyry oho-ta ramo, peteĩ gwembigwái hese ojerovia va'e-pe, hi'arandu va'e-pe ave: “Enhangareko porã katu xe róga pygwa-rehe gwive” he'i. “Jakaru karuha óra-py peteĩ teĩ va'e-pe emboja'o ja'o íxupe kwéry hemi'urã kwéry eremongaru-vy” he'i gwembiporavo-pe oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","—Upéi ogwahẽ jevy-ma ou-vy ijáry. Onhe'ẽ ojapo va'e-pe otopa ramo, ojohu porã va'erã hembiapokwe. Iporã va'erã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anhetegwa va'e amombe'u-ta peẽ-my: “Ãy ae xe mba'e reta-rehe gwive enhangareko meme ereiko-vy” he'i va'erã inhe'ẽ ojapo va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ha inhe'ẽ apo e'ỹha-pe katu ivai va'erã. Ndojohu porãi va'erã hembiapokwe. Upe inhe'ẽ apo e'ỹha: “Hi'are-ma xe járy” he'i rei arã ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Upéa-gwi oinupã nupã oirũ hembigwái kwéry-pe hereko asy-vy. Oka'u va'e ndive okaru oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Upe ramo ijáry ogwahẽ jevy va'erã ou-vy. Hese naimandu'avéi jave, oikwaa e'ỹ ete jave, ogwahẽ jevy-ma va'erã ou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ogwahẽ rire, ombohasa asy va'erã íxupe. Ojéhegwi mombyry omondo va'erã íxupe. Gwĩ opy'a ky'aha omo'ã kwaa va'e renda-py omondo va'erã íxupe. Upe-py ojahe'o va'erã Nhandejáry-rehe onhemoyrõ-gwi. Onhemohãingyry ngyrýu va'erã oiko-vy. Omondo hagwe-pe hasẽ va'erã onhemboasy-vy. Upéa-gwi perepara porã katu peiko-vy peẽ ave, he'i Hesu gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Upéi he'i jevy Hesu gwemimbo'e kwéry-pe: —Amombe'u-ta peẽ-my xe agwahẽ jevytaha áry kunhataĩ rehegwa nhe'ẽ-rami, he'i. —Oĩ va'ekwe dez kunhataĩ. Omenda-ta va'e-pe omoirũ. Upe kunhataĩ he'i Nhandejáry nhande ruvixa-pe omoirũse va'erã-rehe. Oho ohogwaitĩ-vy upe kwimba'e omenda va'e-pe. Tataendy reheve oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","—Cinco oĩ hi'arandu porã e'ỹ va'e. Cinco oĩ hi'arandu va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Upe inharandu porã e'ỹ va'e tataendy reheve oho. Ha tataendyvy ryru oheja. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ha upe hi'arandu va'e katu tataendyvy ryru reheve oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hi'are ogwahẽ hagwã ou-vy upe omenda va'e. Oha'arõ jave hapehýi oke-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ha upe rire katu pyhare mbyte-py oĩ onhe'ẽ hatã va'e: “Ogwahẽ-ta ou-vy omenda va'e. Tapeho katu pehogwaitĩ íxupe” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Upe-ma ramo opaypa-ma hikwái upe dez kunhataĩ. Upéi opu'ã pu'ã omoatyrõ gwataendy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","—Upéi hi'arandu porã e'ỹ va'e he'i: “Ogwe-tama ore rataendy” he'i. “Ne rataendyvy ryru-gwi eme'ẽ mani katu ore-vy” he'i hi'arandu va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—“Name'ẽ mo'ãi” he'i. “Orome'ẽ ramo, ore-vy gwarã ndoikovéi va'erã ore-vy. Tapeho katu ovende va'erã-py, pejogwa pendejéupe gwarã” he'i hi'arandu porã e'ỹ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Oho jave ojogwa hagwã, ogwahẽ-ma ou-vy omenda va'e. Pe kunhataĩ oho e'ỹ va'e oike oje'ói-vy indive jekarugwasu-py. Okẽnda-py omboty-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hi'areve ogwahẽ ou-vy hi'arandu porã e'ỹ va'e: “Ore járy” he'i. “Oroike-ta ore ave” he'i omenda va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ha ha'e he'i: “Anhetegwa amombe'u-ta peẽ-my. Xe ndoroikwaái voi. Peẽ ndaha'éi xe re'ýi” he'i oikese mo'ã va'e-pe, he'i Hesu omombe'u-vy kunhataĩ rehegwa nhe'ẽ-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Upéi he'i jevy: —Araka'e áry-ma po xe agwahẽ jevy va'erã, araka'e óra-ma po xe aju jevy va'erã ndapeikwaái voi. Ndapeikwaái voi xe aju jevy hagwã áry. Upéa-gwi xe ra'arõ-vy tapeiko meme katu, he'i Hesu gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Upéi he'i jevy gwemimbo'e kwéry-pe: —Ãy amombe'u-ta peẽ-my xe agwahẽ jevytaha áry plata atã rehegwa nhe'ẽ-rami, he'i. —Oĩ va'ekwe imba'e reta va'e. Upe imba'e reta va'e he'i Nhandejáry nhande ruvixa-rehe. Yvy ambue-py oho-tama ramo, ohenói ou hagwã gwembigwái kwéry: “Penhangareko katu xe mba'e kwéry-rehe” he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","—Oĩ oito moeda tuvixa va'e hepy va'e ouro gwigwa ogwereko va'e. Peteĩ va'e-pe cinco ome'ẽ. Peteĩ va'e-pe ome'ẽ mokõi. Peteĩ va'e-pe peteĩ ome'ẽ oiporuruka-vy. Peteĩ teĩ oiporu kwaa hagwã-rami ome'ẽ. Upe-ma ramo osẽ oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Upe cinco ome'ẽ ojéupe va'ekwe, pya'e oiporu porã oho-vy ome'ẽ va'ekwe ojéupe. Cincove ogana oiporu porã-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ha'e-rami ave upe mokõi ome'ẽ ojéupe va'ekwe ogana ave. Mokõive ogana oiporu porã-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ha upe peteĩ ome'ẽ ojéupe va'ekwe ndoiporúiry ijáry ome'ẽ va'ekwe. Oho ojo'o yvy-py ojaty hagwã ome'ẽ ojéupe va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Are rire upe hembigwái járy ogwahẽ jevy-ma ou-vy. Ohenói rire: “Mba'éixa peiporu peẽ-my ame'ẽ va'ekwe?” he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Upe cinco ome'ẽ íxupe va'ekwe, cincove ogweru jevy íxupe: “Cinco ereme'ẽ va'ekwe xe-vy, xe Járy” he'i, “Ko. Cincove agana va'ekwe” he'i ojáry-pe ome'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—“Iporã eterei” he'i íxupe. “Nde reko porã voi ra'e” he'i íxupe. “Ajerovia tee voi nde-rehe” he'i íxupe. “Mixĩ va'e-rehe erenhangareko porã ra'e xe mbotavy e'ỹ reheve” he'i íxupe. “Ãy tuvixave va'e-rehe oromonhangareko jevy-ta” he'i íxupe. “Xe moirũ katu onhondive javy'a hagwã” he'i cincove ogana va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Upe mokõi ome'ẽ íxupe va'ekwe ogwahẽ ou-vy ave, “Xe járy” he'i. “Mokõi ereme'ẽ va'ekwe xe-vy. Ko. Mokõive agana va'ekwe” he'i ojáry-pe ome'ẽ jevy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—Ohexa-vy ijáry, “Iporã eterei” he'i ovy'a-vy gwembigwái-pe ijáry. “Nde rekoha porã voi ra'e. Ajerovia tee voi nde-rehe” he'i íxupe. “Xe mbotavy e'ỹ reheve erenhangareko porã ra'e mixĩ va'e-rehe” he'i íxupe. “Ãy tuvixave va'e-rehe oromonhangareko jevy-ta” he'i íxupe. “Xe moirũ katu onhondive javy'a hagwã” he'i mokõive ogana va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Upéi ogwahẽ ave ou-vy upe peteĩ ome'ẽ íxupe va'ekwe: “Orohexa kwaa-ma, xe járy, nde reko-rehe” he'i. “Ne ma'e rakate'ỹ va'e voi ra'e nde. Nde rapixa-pe, Penhemitỹ xe kokwe-py, ere erejaty uka-vy. Ha upe rire katu entéro hi'a va'e gwive eremono'õ uka ndejéupe gwarã. Nde rapixa-pe, Pemohãi-vy penhemitỹ xe kokwe-py, ere erejaty uka-vy. Ha upe rire katu entéro hi'a va'e gwive eremboaty uka ndejéupe gwarã” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Upéixa-gwi xe kyhyje ndéhegwi. Xe kyhyje-gwi, aha ajaty ne remime'ẽgwe yvy-py anhomi-vy. Ko. Ne mba'e” he'i ojáry-pe ome'ẽ jevy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Nde rekoha vai voi ra'e. Ne ate'ỹ voi ra'e” he'i gwembigwái-pe. “Xe járy kokwe-py onhemitỹ e'ỹ reheve, omohãi e'ỹ reheve hemimono'õ ogwerahapa ojéupe gwarã, ere rei kuri xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aipo ramo, ma'erã nerenhongatúiry xe mba'e banco-py? Ma'erã neremoĩry ojeporu hagwã-py, banco pygwa kwéry oiporu hagwã. Aipo ramo, xe aju jevy ramo, ome'ẽ jevy-vy xe-vy, hetave ome'ẽ arã mo'ã xe-vy” he'i upe peteĩ ome'ẽ íxupe va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Upéi he'i upe pygwa-pe: “Peteĩ ogwereko va'e-gwi eipe'a jevy íxugwi, eme'ẽ dez ogwereko va'e-pe” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Ogwereko va'e-pe ome'ẽve va'erã hetave tave ogwereko hagwã. Ha ogwereko e'ỹ va'e katu mixĩ ogwereko va'e jepe oipe'a jevy va'erã íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ha xe rembigwái inhate'ỹ va'e-pe katu, pemosẽ katu íxupe imondo-vy pytũ kwa-rupi. Upe-py ojahe'o va'erã. Hasẽ va'erã onhemboasy-gwi. Nhandejáry-rehe onhemoyrõ-gwi, onhemohãingyry ngyrýu va'erã oiko-vy” he'i gwembigwái kwéry-pe, he'i Hesu ogwahẽ jevytaha óra kwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Upéi he'i jevy íxupe kwéry Hesu: —Xe Nhande Ryke'y tee va'e aju jevy va'erã. Xe ae xe reko-rupi aju va'erã, he'i. —Enterove va'e remimboeterã-rami ajehexa uka arã aju-vy. Xe ndive ou va'erã entéro Nhandejáry rembigwái yváy pygwa gwive. Oroju ramo, pe apykagwasu hesakã va'e, mburuvixagwasu gwapy haty ramigwa ári agwapy-ma va'erã peteĩ teĩ hembiapo apokwe-rehe areko hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","—Entéro tetã tetã mygwa ko yvy-py oĩ va'e gwive onhomboatypa va'erã ou-vy xe renonde-py. Ogwahẽ ramo ou-vy xe renonde-py aipe'a pe'a va'erã ojóhugwi hembiapokwe-rami. Herekwa cabrito kwéry-gwi ovexa oipe'aha-rami ave xe aipe'a va'erã hekoha vai va'e-gwi hekoha porã va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","—Hekoha porã va'e xe amoĩ va'erã xe akatúa-koty. Xe asu-koty amoĩ va'erã hekoha vai va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Upe ramo xe huvixagwasu va'e ha'e-ta xe akatúa kotygwa-pe: “Peju katu peẽ xe Ru rembihovasa va'e. Peju katu. Oĩ peẽ-my gwarã. Ko yvy rembypy gwive omoĩ va'ekwe pene renagwã. Peiko katu Nhandejáry pende ruvixa ndive pemoirũ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Xe vare'a ramo, xe mongaru va'ekwe. Xe y'uhéi ramo, xe mboy'u va'ekwe. Xe ndarekói ramo xe agwahẽ hagwã xe mogwahẽ joty va'ekwe nde ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Opi-vy aiko jave, ereme'ẽ va'ekwe xe-vy xe aorã. Xe rasy ramo, erenhangareko va'ekwe xe-rehe. Preso anhemoĩ jave, xe mbovy'a hagwã ereju va'ekwe. Upéa-gwi peiko katu Nhandejáry pende ruvixa ndive pemoirũ-vy” ha'e va'erã hekoha porã va'e-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Upe ramo he'i rei va'erã xe-vy: “Araka'e tipo erejehexa uka araka'e nde vare'a ramo, ore Járy? Araka'e tipo oromongaru araka'e? Araka'e tipo erejehexa uka nde y'uhéi ramo? Araka'e tipo oromboy'u araka'e? ");
INSERT INTO kgkNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Araka'e tipo eregwahẽse araka'e ore ha-py? Araka'e tipo erejehexa uka opi-vy ereiko ramo? Araka'e tipo orome'ẽ araka'e nde-vy nde aorã? ");
INSERT INTO kgkNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Araka'e tipo erejehexa uka araka'e nde rasy ramo? Araka'e tipo oronhangareko nde-rehe araka'e? Araka'e tipo preso erenhemoĩ ramo, orogwahẽ nde ha-py? Araka'e tipo orombovy'a orogwahẽ-vy araka'e nde ha-py” he'i va'erã oporandu-vy xe-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Upéi xe huvixagwasu va'e ha'e va'erã íxupe kwéry: “Anhetegwa amombe'u-ta peẽ-my. Erejapo porã jave xe re'ýi-pe, xe-vyma ave erejapo porã-ma. Xe re'ýi heko'ive va'e-pe jepe ereipytygwõ tygwõ jave, xe-vy ave-ma xe pytygwõ” ha'e va'erã hekoha porã va'e-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Upéi ha'e va'erã xe asu kotygwa-pe: “Tapeho katu xéhegwi. Xe remimboykerã-ma voi peẽ. Oime tata anháy ruvixa pegwarã, hembigwái kwéry pegwarã ave. Upe tata nhepyrũ opa e'ỹ va'e. Tapeho katu upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Xe xe vare'a ramo va'ekwe, napepena penáiry joty va'ekwe xe-rehe xe mongaru hagwã-rehe. Xe y'uhéi ramo, napepenái va'ekwe xe-rehe xe mboy'u hagwã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Xe ndarekói ramo xe agwahẽ hagwã, naxe mogwahẽ ukái va'ekwe pende ha-py. Xe opi-vy aiko ramo, napeme'ẽséiry va'ekwe xe-vy xe aorã. Xe rasy ramo, xe preso anhemoĩ ramo ave, napenhangarekóiry xe-rehe va'ekwe.” Upéixa xe ha'e va'erã xe asu kotygwa-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Upe-ma ramo he'i-ma va'erã xe-vy hikwái: “Araka'e tipo eregwahẽ ore ha-py nde vare'a ramo, ore Járy?” he'i va'erã xe-vy. “Araka'e tipo noromongarúi va'ekwe? Araka'e tipo erejehexa uka nde y'uhéi ramo? Araka'e tipo noromboy'úi va'ekwe? Araka'e tipo noromogwahẽ ukái ndererekói ramo eregwahẽ hagwã? Araka'e tipo noroipytygwõi opi-vy ereiko jave?” he'i va'erã xe-vy. “Nde rasy ramo, preso erenhemoĩ jave, araka'e tipo noroipytygwõi?” he'i va'erã xe-vy xe asu kotygwa, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Upe jave ha'e arã íxupe kwéry: Xe huvixagwasu va'e anhetegwa amombe'u-ta peẽ-my. Xe re'ýi-pe nderejapo porãi jave, xe-vyma ave nderejapo porãiry ra'e. Xe re'ýi hekomirĩve va'e-pe jepe nereipytygwõiry jave, xe-vyma ave naxe pytygwõiry ra'e, ha'e va'erã hembiapo vai va'e-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Upe jave ojerereko asy haty-py opa e'ỹ reheve oje'ói va'erã hekoha vai va'e. Ha hekoha porã va'e katu oikove meme va'erã Nhandejáry ndive opa e'ỹ reheve, he'i gwemimbo'e kwéry-pe Hesu ogwahẽ jevy hagwã óra-py oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ko'ã va'e nhe'ẽ omombe'upa rire, he'i jevy gwemimbo'e kwéry-pe Hesu: ");
INSERT INTO kgkNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Peikwaa mokõi áry rire oiko-ta aretegwasu héry va'e páscoa. Upe áry-py xe Nhande Ryke'y tee va'e kurusugwasu-rehe xe moĩ va'erã po-py xe me'ẽ va'erã xe reraha-vy xe juka uka hagwã, he'i ójehe, aretegwasu páscoa-rehe ave. Upe áry-py nanhambovúiry va'ekwe ja'u va'erã. Nhane mandu'a ave nhane rembypy ojerereko asy hagwe-rehe. Yma ete upe áry-py osẽ va'ekwe gwĩ hese ipu'aka va'e po-gwi. Upéa-rehe jareko aretegwasu páscoa ko'ãy peve. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Upe ramo pa'i ruvixa kwéry, judeu ruvixa kwéry ndive ojogweroaty-ma hikwái. Caifás pa'i ruvixagwasu róga kakwaa-py ojogweroaty. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Upe-py koty-py onhombo'e mbo'e Hesu-rehe hikwái: —Nhambotavy íxupe jaipyhy-vy jajuka hagwã, he'i Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Arete-py ae ani jaipyhy íxupe, he'i. —Atýra-py jaipyhy ramo, onhembopoxy arã ijaty jaty va'e kente kwéry nhande-vy, he'i ójehe Hesu pyhyharã kwéry. Upéa-gwi oipyhy nhemise Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ha Hesu katu oime Betânia tetã'i-my. Simão róga-py oime. Upe Simão mba'asy vai-gwi ijai aipa va'ekwe nhahenói íxupe va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Upe ramo ogwahẽ ou-vy peteĩ kunha. Hyakwã porã tee va'e hyru reheve ogweru. Pe hyru ojejapo va'ekwe alabastro-gwi. Ita kyra rendy-gwi ojapo va'ekwe. Ha hyakwã porã va'e hepy eterei voi. Upéa oipyhy onhohẽ Hesu akã-rehe. Ogwapy jave okaru-vy onhohẽ hese omohyakwã porã-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Upe va'e ohexa ramo, ogweropoxy-ma hemimbo'e kwéry: —Ma'erã po onhohẽ rei pe hyakwã porã va'e Hesu akã-rehe? he'i ojóupe hikwái oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","—Hepy eterei va'e onhohẽ rei, he'i ojóupe. —Ma'erã po ra'e hepy-rehe nome'ẽiry ra'e, he'i. —Ma'erã ndogwerúi ra'e hepykwe ome'ẽ hagwã iporiahu va'e kwéry-pe. Ome'ẽ ramo ra'e hyakwã va'e repykwe, iporãve arã ra'e, he'i kunha rembiapo-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Upéa he'i va'e oikwaa-ma Hesu: —Ma'erã po ko kunha-pe eremoakã rasy? ha'e he'i. —Hembiapo porã ete voi xe-vy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","—Pene pa'ũ-my oime meme va'erã iporiahu va'e. Ha xe ae katu naime meméi va'erã aiko-vy pene pa'ũ-my, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","—Omano va'ekwe jajaty hagwã nhamohyakwãha-rami, amano e'ỹ ngatu xe mohyakwã ranhe ko kunha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","—Ha'e-ta ko kunha-rehe anhetegwa va'e. Opa-rupi entéro ko yvy-rupi, mamo xe rehegwa nhe'ẽ porã omombe'u mbe'u ha-rupi ave omombe'u va'erã voi ko kunha rembiapo porã-rehe imandu'a hagwã hese, he'i gwemimbo'e kwéry-pe Hesu kunha-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Upe ramo peteĩ hemimbo'e kwéry va'e, Judas Iscariotes héry va'e, oho pa'i ruvixa kwéry ha-py: ");
INSERT INTO kgkNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—Aipyhy uka-ta peẽ-my Hesu, he'i. —Mbovy erepaga-ta xe-vy aipyhy uka ramo peẽ-my? he'i oporandu-vy Judas. Ha ipyhyharã he'i: —Trinta prata gwigwa moeda orome'ẽ-ta nde-vy, he'i Judas-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Upéa nhe'ẽ omoporã Judas. Omoporã rire-ma, orepara oiko-vy Hesu-rehe Judas ipyhyharã-pe omombe'u hagwã óra ra'arõ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ha upéi katu aretegwasu-py ogwahẽ ou-vy Hesu ha-py hemimbo'e kwéry. Upe va'e semana-py mbojape ovu e'ỹ va'e ja'u. Oiko-ma ramo upéa semana, ogwahẽ ou-vy Hesu ha-py hemimbo'e kwéry: —Kipy tipo orombogwejy-ta nde-vy ne remi'urã nhane mandu'a hagwã páscoa-rehe jakaru-vy? he'i oporandu-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ha Hesu he'i íxupe kwéry: —Tapeho katu tetã-my. Oĩ xe mogwahẽharã. Tapeho iha-py peje-vy: “He'i kuri nhane mbo'eháry: Onhemo'agwĩ-ma amano hagwã áry. Nde róga-py xe mandu'a-ta páscoa-rehe. Xe remimbo'e kwéry ndive akaru-ta” peje kuri óga járy-pe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Upéi oho ojapo Hesu nhe'ẽ ombogwejy hemi'urã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ka'aru ete ramo ogwapy ha'e doze gwemimbo'e kwéry ndive okaru hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Okaru jave he'i: —Anhetegwa va'e amombe'u-ta peẽ-my, he'i. —Peteĩ pene pa'ũ-my oĩ va'e xe mombe'u va'erã xe pyhyharã-pe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ohendu ramo inhe'ẽ, ojepy'a rerahapa-ma hese hikwái. Nombovy'avéi-ma íxupe kwéry: —Xe tipo oropyhy uka-ta, xe Járy? he'i. —Xe para'e, ndaxéiry para'e? —onhemopeteĩ teĩ oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—Peteĩ pende avyte-py oĩ va'e, hyru-py opo omoĩ va'e, xe mombe'u va'erã xe pyhyharã-pe, he'i. —Xe ndive omoakỹ va'e mbojape nha'ẽ-py xe mombe'u va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","—Xe Nhande Ryke'y tee va'e aha va'erã xe ajejuka uka hagwã-py, he'i. —Nhandejáry kwatia nhe'ẽ he'i hagwe-rami aha va'erã. Ha xe mombe'u va'erã katu xe pyhyharã-pe amboasy eterei íxupe. Ohasa asy eterei va'erã. Iporãve arã ra'e ndoikói ramo osyrã-pe ra'e, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Upe ramo: —Xe para'e, ndaxéiry para'e, xe mbo'eháry? he'i Judas, upe ipyhyharã-pe omombe'u-ta va'e. —Nde voi, he'i Hesu. —Nde erenhemombe'uha-rami voi nde, he'i Judas-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Okaru joa jave, ha'e oipyhy mbojape, otima porã Nhandejáry-pe. Upéi ombopo mbopóy mbojape ome'ẽ gwemimbo'e kwéry-pe omongaru joty: —Ko, he'i ome'ẽ-vy. —He'u katu. Ko mbojape xe rete-rehe he'i, he'i íxupe kwéry ojehegwigwa ome'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Upéi oipyhy ave copo, otima porã Nhandejáry-pe ome'ẽ íxupe kwéry: —Peẽ kwéry pe'u katu ko va'e copo pygwa, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","—Ko copo pygwa xe rugwy-rehe he'i, he'i íxupe kwéry. —Osyry va'erã xe rugwy imbaraete hagwã Nhandejáry he'i va'ekwe. Yma Nhandejáry, “Amopotĩ va'erã kente kwéry” he'i va'ekwe. Upéa nhe'ẽ imbaraete-ma va'erã xe rugwy osyry-ma ramo, he'i. —Heta kente-rehe ha-py osyry va'erã xe rugwy omboyke hagwã íxugwi kwéry hembiapo vaikwe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—Ha'e-ta peẽ-my. Ha'u-ma kuri uva rykwere. Ãy ae katu nda'u mo'ãvéi-ma. Ha upe rire katu, xe Ru pende ruvixa oiko haty-py, ha'u jevy va'erã, he'i. —Upe-py agwahẽ ramo uva rykwere pyahu ha'u jevy va'erã. Pene ndive ha'u jevy va'erã, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Upéi oporahéi rire, osẽ oho-vy. Oliveiras yvyaty-py oho oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Upe jave ha'e he'i gwemimbo'e kwéry-pe: —Peẽ kwéry pejehesa rerova-ta xéhegwi. Ko va'e pyhare-py xe reja-ta peẽ, he'i. —Oĩ Nhandejáry kwatia nhe'ẽ he'i va'e a-rami: “Ajuka va'erã herekwa osarambipa hagwã ovexa hymba kwéry” he'i. Yma he'i hagwe-rami, ãy xe juka-tama, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Ha upe rire xe anhemoingove jevy rire katu, aha va'erã Galiléia yvy-py, he'i. —Pene renonde aha ranhe va'erã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Upéi Pedro he'i: —Gwĩ ne irũ kwéry ndéhegwi ojehesa rerova ramo jepe, xe ae katu ndorohejái joty va'erã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Anhetegwa va'e amombe'u-ta nde-vy, he'i Hesu Pedro-pe. —Etería ko va'e pyhare-py, ne'írã osapukái ramo gáju, “Xe ndaikwaái voi” ere va'erã xe-rehe mbohapyha-rehe, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Ne ndive xe ajejuka uka ramo jepe, ndajehesa rerovái joty va'erã ndéhegwi, he'i íxupe Pedro. —“Xe ndaikwaáiry” nda'éiry joty arã nde-rehe, he'i Hesu-pe. Pedro he'i hagwe-rami ave he'i inhirũ kwéry Hesu remimbo'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ha upéi katu Hesu oho oje'ói-vy gwemimbo'e kwéry ndive. Ogwahẽ oho-vy Getsêmani yvaty-py: —A-py pegwapy katu, he'i. —Xe ae ahasave-ta upe-py Nhandejáry ndive anhomongeta hagwã, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Upéi mbohapy ondive ogweraha. Ogweraha Pedro. Mokõi Zebedeu ra'y ogweraha ave ondive. Upe ramo Hesu ovy'are'ỹ-ma oiko-vy. Ojepy'ajopy eterei-ma ave oiko-vy. Ogwahẽ vy'are'ỹgwasu íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Ogwahẽ-ma vy'are'ỹgwasu xe-vy xe juka-ta va'e-rami, he'i. —Epyta nde a-py. Xe moirũ katu ereke e'ỹ reheve, he'i gwemimbo'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Upéi ha'e ae oho mbykymi hova-py ojeity yvy-rupi: —Xe Ru, ereipe'ase ramo, eipe'a katu xéhegwi xe py'ajopyha. Xe-vy ojehu va'erã eipe'a katu xéhegwi. Ha ndereipe'aséi ramo ae katu, ani joty ereipe'a, he'i onhomongeta-vy Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Upéi ou jevy mbohapy gwemimbo'e ha-py. Ogwahẽ ramo, ikéra otopa: —Ma'erã po ereke e'ỹ reheve naxe ra'arõiry? Ma'erã peteĩ óra-py jepe naxe ra'arõiry? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","—Epáy katu. Ejapo katu oração xe ra'arõ-vy pono penhembojejavy uka avave-pe, he'i. —Nde py'a kyre'ỹ voi. Ereke e'ỹ reheve erejapose mo'ã oração. Ha nde rete katu okese voi, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Upéi oho jevy Nhandejáry ndive onhomongeta-vy: —Ndereipe'aséi ramo xe py'ajopyha jepe, ereipota ramo ave xe ahasa asy jepe, tojapo joty katu ne remimbota, xe Ru, he'i oração apo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ouri jevy ramo, ikéra otopa jevy-ma. Hapehýi eterei-gwi, okepa-ma hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Upéixa-gwi oheja jevy-ma oho-vy. Mbohapy jevy ojapo oração. Gwemimombe'ukwe omombe'u jevyri Nhandejáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Upéi ou jevy-ma gwemimbo'e oĩ ha-py: —Ma'erã po ereke joty eretongea-vy? he'i. —Ogwahẽ-ma ngatu xe óra. Xe Nhande Ryke'y tee va'e ãy xe me'ẽ-ta xe reraha-vy gwĩ ojejavy va'e Nhandejáry kwaa e'ỹha va'e po-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","—Epu'ã katu jaha. Ehexa katu. Onhemo'agwĩ-ma ra'e xéhegwi ou-vy upe xe pyhy ukaharã, he'i gwemimbo'e-pe omotenonde-vy opyhyharã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Onhe'ẽ vyteri jave Hesu, ogwahẽ-ma ou-vy Judas, peteĩ doze hemimbo'e kwéry va'e. Indive kwéry heta ou ave. Opo-py ogweru kyse puku. Yvyra ave ogweru hikwái. Upéa pa'i ruvixa kwéry remimbou, judeu ruvixa kwéry remimbou voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ha Judas he'i ra'e íxupe kwéry: “Ahexa uka-ta peẽ-my pene rembipyhyse” he'i ra'e Hesu-rehe. “Upe ahovapyte-ta va'e pene rembipyhyrã voi” he'i ra'e íxupe kwéry Judas. “Ahovapyte jave peẽ peikwaa-ma arã. Peipyhy mani kuri íxupe” he'i ra'e ipyhyharã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Upéa-gwi oho pya'e Hesu renda-py oipyhy hagwã. Judas he'i: —Mba'éixa pa xe mbo'eháry, he'i ogwahẽ-vy íxupe. Upéi ohovapyte Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ha Hesu he'i: —Xe irũ, he'i, —Mba'e apo-vy ereju ra'e, he'i íxupe. —Ejapo mani katu erejapose va'e, he'i Judas-pe. He'i-ma ramo, ou onhemoĩ-ma hese oipyhy hagwã íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Upe-ma ramo, peteĩ Hesu irũ va'e omopu'ã okyse oikytĩ-vy. Ombogwái pa'i ruvixagwasu rembigwái-pe. Ohupity inambi, ho'a inambikwe oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ha Hesu he'i: —Nde kyse katu emoĩ jevy hyru-py. Kyse omopu'ã va'e gwive kyse-py ave ojejuka va'erã, he'i kyse omopu'ã va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","—“Ndaipóri Hesu pytygwõharã” ere mo'ã. Xe Ru-pe ahenói ramo, pya'e ombou arã xe-vy heta gwembigwái yváy pygwa xe resendeharã. Setenta e dois mil ombou arã xe-vy xe resendeharã, he'i. —Hetave ombou arã xe-vy xe resendeharã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","—Ha nahenói mo'ãiry xe pytygwõharã-rehe. Oĩ Nhandejáry kwatia nhe'ẽ a-rami: “Ohasa asy va'erã Cristo” he'i va'ekwe. Aipo ramo, xe Ru-pe ahenói ramo xe resende hagwã, naimbaraetevéi arã Nhandejáry kwatia nhe'ẽ, he'i. —Yma he'i hagwe-rami, ãy ndoikói arã, he'i kyse omopu'ã va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Upe ramo he'i ijaty jaty va'e kente-pe: —Ma'erã po pegwahẽ peju-vy kyse reheve xe pyhy hagwã peju-vy? Ma'erã po yvyra reheve ave pegwahẽ peju-vy? “Hesu oporosakea va'e” peje tipo peju-vy xe-rehe? he'i íxupe kwéry. —Ha ndaha'éiry upeixagwa xe, he'i Hesu íxupe kwéry. Iko'ẽ ko'ẽ agwapy aporombo'e-vy ae Nhandejáry róga kakwaa-py aiko-vy. Ha ndaxe pyhýi voi ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ha Nhandejáry nhe'ẽ-py omombe'u va'ety remimoĩgwe kwatia-rehe katu ipokatu voi, imbaraete voi. Upéa-gwi yma he'i hagwe-ramima, ãy oiko-ma, he'i. —Kóixa ndojehúi ramo ra'e xe-vy, ndaipokatúi arã ra'e Nhandejáry kwatia nhe'ẽ, he'i íxupe kwéry. Upe-ma ramo, hemimbo'e kwéry gwive ohejapa íxupe. Okanhymba oje'ói-vy íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ha upéi katu Hesu pyhyhagwe ogweraha íxupe. Caifás pa'i ruvixagwasu róga kakwaa-py ogweraha. Upe-py ojogweroaty ra'e gwĩ judeu rekombo'ehaty, judeu ruvixa kwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ha Pedro katu oho hapykwéri meme. Hesu rapykwéri puku oho. Pa'i ruvixagwasu roka peve ogwahẽ oho-vy. Upe-py ogwahẽ ramo, oike ogwapy polícia kwéry ndive oiko-ta va'e ohexa hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ha pa'i ruvixa kwéry judeu ruvixa kwéry ndive, oheka heka mo'ã Hesu-rehe ijapu va'erã. Ojuka ukase íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hovagwy-py ou onhembo'y ramo jepe heta ijapu va'e, omombe'u joavy avy joty. Oipota peteĩxa omombe'u ojuka uka hagwã. Ha omombe'u joavy avy joty. Heta ijapu japu rire, ou onhembo'y mokõi va'e: ");
INSERT INTO kgkNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Upéa remimombe'ukwe oromombe'u jevy-ta peẽ-my, he'i. —“Aitypa uka-ta ko Nhandejáry róga kakwaa, mbohapy áry-rupi amopu'ã jevy hagwã” he'i Hesu nhe'ẽgwe mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Upe jave opu'ã onhembo'y-ma pa'i ruvixagwasu oĩ-vy: —Ne mombe'u kuri. Ma'erã-gwi nerenhemombe'úiry ra'e nde? he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ha Hesu katu opyta okirirĩ rei íxugwi. Mba'eve nde'íry íxupe. Upéi pa'i ruvixagwasu he'i: —Nhandejáry Tupã oikove va'e réry-py, oromonhe'ẽ-ta nde apu e'ỹ reheve, he'i íxupe. —Nde pa Cristo nhane remiha'arõ va'e? he'i oporandu-vy íxupe. —Nde pa Nhandejáry ra'y tee va'e? Emombe'u katu ore-vy nde apu e'ỹ reheve, he'i íxupe omonhe'ẽse-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Upéi Hesu he'i: —Xe ko ha'e voi, he'i. —Nde xe mombe'uha-rami xe Cristo voi, he'i pa'i ruvixagwasu-pe. Upéi he'i jevy Hesu: —Ha'e-ta peẽ-my kwéry. Xe Nhande Ryke'y tee va'e-pe xe rexa-ta kuri. Nhandejáry yke-rehe ijakatúa-koty agwapy ramo xe rexa va'erã. Imbaraeteve va'e Nhandejáry. Arai-rupi xe agwejy ramo xe rexa va'erã, he'i judeu ruvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Upéa nhe'ẽ ogwenohẽ-ma ramo ojéupe, ogweropoxy pa'i ruvixagwasu. Ogwerovái-gwi, omondoro oao: —Onhe'ẽ vai rei-ma onhemonhandejáry-vy mo'ã, he'i. —Pehendu-ma inhe'ẽ vaiha, he'i. —Outro imombe'uharã-rehe nanhaikotevéiry. Ojéhegwi rei onhe'ẽ vai-ma, he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","—Mbava'e tipo pejapo-ta hese? he'i oporandu-vy. —Tomano katu, tojejuka katu, he'i joa voi hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Upe ramo onygwõ nygwõ hese. Osokea íxupe opo-py. Oĩ íxupe oipete va'e ave: ");
INSERT INTO kgkNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Nde Cristo, Nhandejáry nhe'ẽ mombe'uhaty ra'e nde. Aipo ramo, emombe'u ore-vy kiva'e va'e ne nupã, he'i oinupã nupã-vy íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ha Pedro katu ogwapy oĩ-vy oka-py. Upe-ma ramo ogwahẽ ou-vy iha-py kunhataĩ pa'i ruvixagwasu rembigwái va'e: —Nde ave eremoirũ ra'e Hesu Galiléia pygwa, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ha Pedro he'i: —Ndaxéiry, he'i. —Namoirũiry va'e voi íxupe, he'i upe-py oĩ va'e apyte-py Hesu-rehe. —Ne nhe'ẽ katu ndaikwaáiry, he'i mo'ã kunhataĩ-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Upéi osẽ mbykymi oho-vy. Okẽ-my oho. Upe-py ohexa íxupe outro kunhataĩ: —Upéa omoirũ va'e oiko-vy ra'e. Hesu Nazaré pygwa ndivegwa, he'i upe pygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—Ndaxéiry, he'i jevy Pedro kunhataĩ-pe. —Xe apu ramo, taxe moingo asy katu Nhandejáry, he'i. —Ndaikwaáiry xe íxupe, he'i mo'ã Pedro kunhataĩ-pe Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Upe riremi onhemo'agwĩ-ma ou-vy Pedro renda-py upe-py opu'ã oĩ-vy va'e: —Galiléia pygwa nhe'ẽ-rami ave erenhe'ẽ. Hendivegwa voi nipo ra'e nde, he'i íxupe. —Nde rekoha-rehe oroikwaa, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Upe ramo he'i: —Xe apu ramo, taxe moingo asy katu Nhandejáry, he'i. —Upe va'e xe ndaikwaáiry voi, he'i mo'ã upe pygwa-pe. Upe-ma ramo pya'e osapukái gáju. ");
INSERT INTO kgkNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ha Pedro imandu'a-ma Hesu nhe'ẽgwe-rehe: “Ne'írã osapukái ramo gáju, Xe ndaikwaáiry voi, ere va'erã xe-rehe mbohapyha-rehe”. Upéa nhe'ẽ-rehe imandu'a-ma ramo Pedro, osẽ-vy ojahe'o. Hasẽ-ma osẽ oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ko'ẽmba-ma ramo, ojogweroaty jevy pa'i ruvixa kwéry, judeu ruvixa kwéry ndive: —Mba'éixa jajuka uka-ta Hesu-pe? he'i onhombo'e mbo'e-vy hikwái hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Upe-ma ramo, onhapytĩ-ma íxupe. Ipokwaha reheve ogweraha mburuvixa Pilatos po-py ome'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ha upéi katu. “Ojuka-ta voi nipo Hesu-pe ra'e” he'i ojéupe Judas pe Hesu mombe'uhare ipyhyharã-pe. Upéa-gwi omboasy eterei gwembiapokwe. Omboasy-gwi ome'ẽse jevy ojéupe ome'ẽ va'ekwe ime'ẽhare-pe. Upe trinta prata gwigwa moeda ome'ẽse jevy mo'ã íxupe kwéry: ");
INSERT INTO kgkNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Ajejavy-ma, he'i. —Heko jejavy e'ỹ va'e amombe'u kuri ijuka ukaharã-pe, he'i judeu ruvixa kwéry-pe Judas onhemombe'u-vy. Ha ha'e kwéry katu nopenái joty inhe'ẽ-rehe: —Noropenái ne nhe'ẽ-rehe, he'i. —Nde ae katu epena ne rembiaporã-rehe, he'i Judas-pe hikwái. Nopenái hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Upe ramo oity yvy-py upe trinta moeda. Nhandejáry róga kakwaa koty-py oity. Oity rire, osẽ ojejuvy hagwã-pyma oho. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ha pa'i ruvixa kwéry katu omono'õ no'õ jevy hembieitykwe: —Ko va'e moeda ojuka uka-ta mo'ã va'e repy, he'i. —Upéa-gwi ndatekoháiry nhamoĩ hagwã pirapire ryruty-py Nhandejáry róga oĩ va'e-py, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Upéixa ramo onhombo'e mbo'e onhondive oikwaa hagwã gwembiaporã. Oikwaa rire, oho ojogwa yvy. Upe yvy tuju-gwi mba'e ryru apohaty mba'ekwe. Gwĩ yvy akéno-gwi ou va'ekwe ojaty hagwã ojogwa upe va'e yvy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Upéa-gwi, ojejuka va'ekwe repykwe-py ojogwa-gwi, ombohéry, “Ojejuka va'ekwe yvy”. Ko'ánga ete peve héry upéixa. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ko'a-rami ae yma gware Nhandejáry nhe'ẽ-py omombe'u va'ety Jeremias remimoĩgwe kwatia-rehe: “Oipyhy upe trinta prata gwigwa moeda oho ojogwa tuju-gwi mba'e ryru apohaty mba'ekwe. Nhandejáry xe-vy he'i hagwe-rami oho ojogwa. Kwimba'e repykwe voi trinta moeda, he'i Israel re'ýi kwéry.” Yma he'i hagwe-rami ãy oiko-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ha upéi katu omonhembo'y imoĩ-vy Hesu-pe mburuvixa Pilatos rovagwy-py: —Nde tipo ereiko ra'e judeu kwéry ruvixagwasu ramo? he'i oporandu-vy íxupe Pilatos. Ha'e he'i: —Xe voi aiko, he'i. —Ereha-rami aiko, he'i joty mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ha pa'i ruvixa kwéry judeu ruvixa kwéry ndive, —Hembiapo vai-ma, hembiapo vai-ma, he'i joa ramo hese, mba'eve joty nomombe'úiry. Onhemokirirĩ rei joty Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Upéixa-gwi: —“Hembiapo vai vai-ma upe va'e” he'i ramo nde-rehe, ma'erã po ra'e nerenhemombe'úiry? he'i íxupe oporandu-vy Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ha ha'e katu mba'eve joty nde'íry. Heta nhe'ẽ ombojase mo'ã ramo jepe hese, mba'eve joty nomombe'úiry gwĩ ójehe onhe'ẽ vai vai va'e-pe. Upéa rexa-vy, “Ma'erã po Hesu nonhemombe'úi joty gwĩ ójehe onhe'ẽ vai vai va'e-pe?” he'i ojéupe mburuvixa opondera-vy Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ha oiko jave aretegwasu, oĩ opoi uka va'erã íxugwi. Peteĩ onhemoĩ preso va'ekwe-gwi oĩ opoi uka jevy va'erã imondo-vy mburuvixa. Upéixa tekoha. Upe ijaty va'e kwéry ojerure va'ekwe-gwi opoi uka-ma imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Upéa ojehu jave Hesu-pe, oĩ peteĩ onhemoĩ va'e preso héry va'e Barrabás. Upéa-pe enterove va'e oikwaa íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Ha upéi katu heta kente ojogweroatypa. Upe ramo he'i: “Ndaija'éi-gwi rei Hesu-rehe oipyhy ra'e íxupe heru-vy xe-vy hikwái” he'i ojéupe mburuvixa. Upéa-gwi he'i: —Kiva'e-gwi po peipota peẽ-my apoi, he'i, —arrabás-gwi para'e, Hesu Cristo héry va'e-gwi para'e? he'i oporandu-vy ijaty jaty va'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Upe ramo ogwapy jave Pilatos oĩ-vy mburuvixa ogwapy haty-py, ombou onhe'ẽ hembireko íxupe: —Upe va'e heko jejavy e'ỹ va'e. Eheja rei katu íxupe, he'i. —Pyhare ahexa kuri íxupe xe kéra-py. Íxugwi anhemondýi. Xe kéra-py ahasa asy ahexa ramo. Esyry katu ijypy-gwi, he'i omondo-vy onhe'ẽ ome-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ha pa'i ruvixa kwéry judeu ruvixa ndive katu, ombo'e mbo'e ijaty jaty va'e-pe: —“Epoi katu Barrabás-gwi. Hesu ae katu tojejuka” peje katu, he'i ijaty va'e kwéry-pe ojojurupypa opo'ẽ-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","—Oĩ mokõi. Kiva'e-gwi tipo peipota apoi? he'i oporandu-vy íxupe kwéry. Ha ha'e kwéry he'i: —Barrabás-gwi epoi toho, he'i mburuvixa-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—Aipo ramo, mbava'e tipo ajapo-ta Hesu Cristo héry va'e-rehe? he'i íxupe kwéry. —Ejuka uka katu íxupe. Kurusugwasu-rehe ejuka uka íxupe, he'i joa joty íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—Ajuka rei va'erã. Nahembiapo vaíry voíte Hesu ra'e, he'i Hesu-rehe íxupe kwéry. —Emboja katu, emboja katu imoĩ-vy kurusugwasu-rehe omano hagwã, he'i joa joa hikwái onhe'ẽ hatãve tãve-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Upe-ma ramo he'i: “Ndaxe pu'akavéi-ma upe ijaty va'e kwéry-rehe” he'i. “Xe rairõ rei-tama hikwái opoxy-gwi. Xe mongyhyje rei-ma hikwái” he'i ojéupe ikyhyje-vy. Upéa-gwi ojerure y-rehe. Upéa y-py ojepohéi atýra-py. Ojogweroaty va'e kwéry resa-py ojepohéi: —Xe potĩ-ma, he'i. —Ko heko jejavy e'ỹ va'e ndajukaséi, he'i. —Ndaxe py'a vaíry hese. Pene nhe'ẽ-py ae katu ojejuka va'erã Hesu, he'i Hesu-rehe Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—Ore nhe'ẽ-py voi tomano, he'i. —Hepyha ae katu ore-vy tojehu. Ore remiarirõ joapyri pyri-pe ave tojehu joty oho-vy, he'i mburuvixa-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Upe rire inhe'ẽ-py opoi Barrabás-gwi imondo-vy. Ha Hesu-pe katu he'i ombopi hagwã íxupe. Ome'ẽ ijukaharã-pe omboja hagwã kurusugwasu-rehe ijuka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Upe ramo mburuvixa rembigwái kwéry soldado va'e, ogweraha Hesu-pe. Mburuvixa róga kakwaa koty-py ogweraha íxupe. Upe-py entéro soldado gwive onhomboatypa hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ijao tee omboi íxugwi hikwái. Omonde hese ao pytã va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Upéi nhuatĩtĩ-gwi ojapo íxupe ijegwaka ra'angarã omoĩ hagwã inhakã-rehe. Ipo akatúa-py omoĩ takwáry. Upéi gwetypy'ã-rehe onhesũ hovagwy-py onhembohory-vy hese: —Toiko are katu judeu ruvixagwasu, he'i omboete ra'anga anga-vy íxupe, onhembohory-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Upéi katu onygwõ nygwõ-ma ave Hesu-rehe. Oipyhy ipo pygwa takwáry. Ipo pygware-py onhakãrupã rupã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Onhembohorypa rire hese, omboi íxugwi ao pytã va'e. Omonde jevy hese ijao. Upe rire ogweraha íxupe omboja hagwã kurusugwasu-rehe ijuka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ha upéi katu soldado kwéry Hesu reheve osẽ oje'ói-vy pe tetã-gwi. Osẽ jave, ohogwaitĩ Cirene tetã mygwa-pe héry va'e Simão-pe. Ogweraha uka íxupe Hesu kurusugwasurã. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ogwahẽ oho-vy Gólgota oje'e ha-py. Akãgwe rendaty-rehe he'i Gólgota. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Upe-py uva rykwere pohã hái va'e reheve ome'ẽ íxupe ho'u uka-vy. Ome'ẽ íxupe pono ohendu eterei ojéupe hasy va'e. Ha otantea rire katu ndo'úiry. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Upéi ijuka hagwã-pyma ogwenogwahẽ íxupe heraha-vy omboja hagwã íxupe kurusu-rehe. Omboja rire soldado kwéry ohuga onhomboja'o ja'o hagwã Hesu aokwe-rehe. Ogana gana va'e ogweraha ijaokwe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Upéi ogwapy hese orepara-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ha Hesu-rehe hemimombe'ukwe ohai omoĩ ikurusu-rehe inhakã ári: “Kóa Hesu judeu ruvixagwasu va'e” he'i omoĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Oĩ ave mokõi imonda va'e kurusu-rehe omboja ave imoĩ-vy. Hesu yke-rehe omoĩ, peteĩ ijakatúa-koty, peteĩ ijasu-koty. Imbyte-py oĩ Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Gwĩ ohasa oiko-vy va'e opuka hatã hese. Onhakãreity ity onhembohory-vy hese. He'i Hesu-pe hikwái: ");
INSERT INTO kgkNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—“Aity-ta mo'ã Nhandejáry róga kakwaa amopu'ãmba jevy hagwã mbohapy áry-rupi” ere mo'ã kuri ndéjehe. —Aipo ramo, enheresende katu, he'i. —“Xe Nhandejáry ra'y” ere mo'ã kuri ndéjehe. Aipo ramo egwejy katu kurusu-gwi, he'i onhembohory-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Upéixa ave onhembohory hese pa'i ruvixa kwéry judeu rekombo'ehaty ave. Upéixa ave onhembohory hese judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Upéa opororesende va'ety. Ha ndaipu'akáiry gwekove-rehe onheresende hagwã, he'i hese onhembohory-vy. —“Xe Israel kwéry ruvixagwasu” he'i kuri ójehe. Aipo ramo ãy togwejy kurusu-gwi jarovia hagwã íxupe, he'i joa hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—Nhandejáry-rehe ojerovia oiko-vy va'e. “Xe Nhandejáry ra'y” he'i kuri ójehe. Aipo ramo, oresendese ramo, toresende katu íxupe Nhandejáry ãy, he'i Hesu-rehe judeu ruvixa kwéry onhembohory-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Upéixa ete ave upe mokõi imonda va'e hendive kurusugwasu-rehe onhemboja va'e, onhe'ẽ rei rei ave hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Upéi kwarahy mbyte-py pytũmba-ma upe yvy ári. Mbohapy óra peve pytũ. Ka'arugwasu peve pytũmba. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Upe ramo onhe'ẽ hatã Hesu. He'i: —Eli, Eli, lamá sabactâni? he'i. Ha'e ae onhe'ẽ-py onhe'ẽ. Upéa he'ise: “Tupã xe Járy, Tupã xe Járy, ma'erã-gwi po xe rejapa xe anho eterei?” he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ha upe-py oĩ inhe'ẽ ohendu va'e: —Upéa ohenói Elias-pe, he'i mo'ã Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Upe-ma ramo oripara ogweru bucha. Omoakỹ uva rykwere hepy ete e'ỹ va'e-py. Takwáry-py omoĩ, oipyte uka Hesu-pe omboy'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ha outro kwéry katu he'i: —Eheja katu. Ou-ta para'e Elias oresende hagwã íxupe, he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Upéi onhe'ẽ hatã jevy-ma Hesu. Ha upe rire katu omano-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Upe-ma ramo pya'e ojeka Nhandejáry róga kakwaa pygwa okẽgwasu nhugwãha tuvixa ete va'e. Osoro hatã. Yvate-gwi yvy peve ojeka hatã ou-vy. Entéro-rupi omyimba yvy, itaty ojeka. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ojepe'a ijyta. Heta heko marangatu va'e omano va'ekwe onhembotekove jevy-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Oyta-gwi osẽ oho-vy. Oike oho-vy Jerusalém tetã marangatu-py heta kente va'e-pe ojehexa uka-vy. Hesu onhemoingove jevy rire upe onhembotekove jevy va'e kwéry ojehexa uka-vy oho Jerusalém-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ha gwĩ capitão, soldado ruvixa va'e Hesu-rehe orepara va'e kwéry ndive katu, ohexa yvy omýi ramo. Entéro ojehu va'ekwe gwive ohexa ave. Upéa rexa-vy onhemondýi eterei hikwái. Upe jave ae he'i hikwái: —Nhandejáry ra'y tee voi nipo ra'e, he'i Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Heta kunha oĩ upe-py. Galiléia yvy-gwi ou ra'e. Hesu irũ meme voi gwĩ kunha. Ome'ẽ me'ẽ Hesu-pe hemikotevẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Oĩ Maria Madalena. Oĩ Maria, ha'e Tiago tyvýry José ndive isy ra'e oĩ ave upe-py. Oĩ ave Zebedeu ra'y sy. Oĩ outro kunha kwéry ou va'ekwe ave. Gwĩ kunha mombyry-gwi oma'ẽ joa Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ka'aru ete-ma. Ogwahẽ ou-vy imba'e reta va'e héry va'e José. Arimatéia tetã-gwi ou va'ekwe. Ha'e Hesu nhe'ẽ renduha voi. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ogwahẽ rire oho mburuvixa renda-py ojerure Hesu retekwe-rehe: —Ekwa eme'ẽ íxupe Hesu retekwe, he'i gwembigwái-pe Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Upéixa-gwi ogweraha hetekwe onhugwã ao morotĩ iporã va'e-py. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Upéi oho ogweraha hetekwe imoĩ-vy hetekwe rendarã ipyahu va'e-py. Ita ojo'o ra'e hetekwe renagwã. Upe-py omoĩ hetekwe. Upéi omboapajeréi imondo-vy itagwasu. Omboty hagwã itakwa rokẽ heseve omboapajeréi imondo-vy itagwasu. Ombotypa rire, oheja-ma oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ha Maria Madalena, Maria José sy ndive opyta upe-py. Hetekwe renda rokẽ rovagwy-py ogwapy oĩ-vy mokõive. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Iko'ẽ-my aretegwasu pegwarã omoĩmba rire, oho oje'ói-vy Pilatos renda-py. Upe-py oho pa'i ruvixa kwéry fariseu kwéry ndive: ");
INSERT INTO kgkNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Nde, karai, he'i íxupe —Ore mandu'a upe ijapu va'e Hesu nhe'ẽgwe-rehe. “Mbohapy áry rire anhemoingove jevy va'erã” he'i va'ekwe oikove vyteri jave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","—Aipo ramo, mbohapyha áry peve, emonhangareko uka katu hyru-rehe, he'i. —Ou-ta para'e hemimbo'ekwe omonda hagwã hetekwe, he'i. —Ha upe rire katu, “Onhemoingove jevy-ma Hesu” he'i rei hagwã hese atýra-py. “Upéa Cristo, nhane remiha'arõ va'e” he'i ramo kuri hese, ijapu-ma va'erã voi hese. Ha ãy katu, “Onhemoingove jevy-ma” he'i ramo, ijapu vaive va'erã hese. Upéa-gwi emonhangareko uka katu hyru-rehe, he'i Pilatos-pe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—Néi, he'i íxupe kwéry. —Peraha katu soldado, he'i. —Tapeho jevy katu. Ani pene ate'ỹ teĩ ha'arõ-vy. Penhangareko porãha-rami, pemonhangareko uka porã porã katu hese, he'i judeu ruvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Soldado ome'ẽ rire íxupe ogweraha hagwã, oho oje'ói-vy hikwái. Oho onhangareko-vy hetekwe ryru-rehe. Itagwasu-rehe omoĩ imbotyha ete pono oike nhemi koty-py imonda va'e. Upéi he'i: —Perepara porã katu peiko-vy hetekwe ryru-rehe pono oike nhemi koty-py imonda va'e, he'i soldado kwéry-pe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pytu'uha áry rire, voi ete domingo-py, nako'ẽi vyteri ramo, oho ohexa Hesu retekwe renda. Upe-py oho Maria Madalena, Tiago sy ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Upe-ma ramo, omýi eterei yvy. Ogwejy ra'e ou-vy yváy-gwi Nhandejáry rembigwái. Oho hetekwe renda-py, oipe'a imbotyha itagwasu omboapajeréi jevy-vy, ogwapy hi'ári. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Overa va'e-rami hendy hova, nhande resa mbojevy-vy. Ijao morotĩ porã, iky'a e'ỹ va'e ijao resakã va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ha gwĩ hetekwe renda-rehe oreparaharãgwe onhemondýi eterei-ma íxugwi. Ombopy'a ryrýipa íxupe kwéry heity-vy. Omano va'ekwe-rami ho'a oje'ói-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ha Nhandejáry rembigwái va'e katu he'i kunha-pe: —Ani pekyhyje teĩ. Hesu kurusu-rehe onhemboja va'ekwe retekwe-pe peju-ma pehexa kuri. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Peheka ramo jepe, ndaiporivéi-ma ko'a-py, he'i. —Oikove jevy-ma kuri. Aipo ho'e hagwe-rami oikove jevy-ma kuri. Oho-ma kuri. Peju katu peẽ pema'ẽ hupagwe-rehe, he'i. —Hendagwe rei-ma oĩ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","—Ha upe rire katu ekwa pya'e emombe'u hemimbo'e kwéry-pe, “Oikove jevy-ma Hesu” peje. “Ne renonderã-rupi oho-ta Galiléia yvy-py” ere hemimbo'e kwéry-pe. “Upe-py erehexa va'erã íxupe” peje hemimbo'e kwéry-pe, he'i. —Upéa nhe'ẽ mombe'u-vy aju, he'i mokõi kunha-pe Nhandejáry rembigwái yváy pygwa. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Upe-ma ramo pya'e oripara oho-vy hetekwe rendagwe-gwi pe kunha. Okyhyje ramo jepe, ovy'agwasu joty oho-vy jevy. Hemimbo'e kwéry renda-py oripara oho-vy omombe'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Upe-ma ramo ohogwaitĩ íxupe Hesu: —Mba'éixa pa, he'i kunha-pe. Upéi kunha onhemo'agwĩ-ma íxugwi oipyhy ipy omboete íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Upéi Hesu he'i: —Ani pekyhyje teĩ. Ekwa teremombe'u gwĩ xe-rehe ojerovia va'e-pe, “Tapeho katu Galiléia yvy-py. Upe-py xe rexa va'erã, he'i kuri Hesu” ere íxupe kwéry, he'i kunha-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kunha oho jave, oĩ soldado Hesu retekwe-rehe orepara va'erãgwe va'e. Oho oje'ói-vy Jerusalém tetã-my omombe'u pa'i ruvixa kwéry-pe entéro ojehu va'ekwe gwive. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Upéi ojogweroaty pa'i ruvixa kwéry judeu ruvixa ndive onhombo'e mbo'e-vy. Aipo ramo, heta plata ome'ẽ soldado kwéry-pe ijapu hagwã Hesu retekwe-rehe: ");
INSERT INTO kgkNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Atýra-py peje, “Pyhare ou nhemi Hesu remimbo'ekwe. Oroke jave omonda hetekwe heraha-vy” he'i. —“Nororepara porãiry-gwi, ojereraha hetekwe” peje rire, ani pekyhyje teĩ, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","—Upéa nhe'ẽ ohendu ramo mburuvixa, oronhomongeta arã hendive. Noromoingo asy ukái va'erã íxupe, he'i soldado-pe hikwái plata me'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Upe ramo upe soldado kwéry ogweraha plata. Judeu ruvixa he'i hagwe-rami ojapo, onhemombe'u mbe'u-vy. Judeu kwéry pa'ũ-rupi oho inhe'ẽgwe. Ko'ánga ete peve upéa rehegwa nhe'ẽ omombe'u mbe'u joty ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ha upéi katu onze hemimbo'e kwéry va'e oho oje'ói-vy Galiléia yvy-py. Ojeupi oje'ói-vy yvyaty ári upe Hesu remimombe'ukwe-py ojeupi hagwã oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ohexa ramo íxupe, gwetypy'ã-rehe onhesũ omboete-vy íxupe hikwái. Ha oĩ joty hese ndojerovia teéiry va'e. “Hesu para'e, tapa ndaha'éi Hesu” he'i joty hese va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Upe ramo onhemo'agwĩ-ma gwemimbo'e kwéry-gwi ou-vy: —Xe mbopu'aka-ma Nhandejáry enterove va'e-rehe, he'i. —Entéro yváy pygwa, entéro ko yvy-py oĩ va'e gwive ave oheja xe pogwy-py meme imoĩ-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","—Aipo ramo, xe nhe'ẽ-py tapeho katu opa-rupi. Entéro tetã tetã ko yvy-py oĩ va'e-rupi gwive, tapeho xe moirũharã harã-pe xe mombe'u-vy, he'i. —Xe renduharã harã-pe xe mombe'u peiko-vy. Pemongarai rai íxupe kwéry xe Ru réry-py, xe ta'ýry réry-py ave. Nhe'ẽ Marangatu tee va'e réry-py ave pemongarai rai peiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Peje, “Opamba'e ore orojapo hagwã Hesu ore-vy he'i va'ekwe gwive, nde ave ejapo katu” peje xe renduharã-pe, he'i. —Ha xe ae katu apomoirũ tee meme va'erã. Ndapoheja mo'ãi voíte peẽ-my. Ko yvy oiko vyteri jave xe apomoirũ meme va'erã, he'i Hesu gwemimbo'e kwéry-pe omombe'u paha-vy onhe'ẽ.");
INSERT INTO kgkNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ãy anhepyrũ amombe'u-vy Hesu Cristo rehegwa nhe'ẽ porã. Ha'e katu Nhandejáry ra'y tee voi. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Yma va'ekwe oiko va'ekwe Isaías. Nhandejáry nhe'ẽ-py omombe'u-vy oiko va'ekwe. João Batista rekorã mombe'u-vy oiko va'ekwe. Hesu rekoha mombe'uha rekorã omombe'u va'ekwe. A-rami omoĩ va'ekwe kwatia-rehe onhe'ẽ: “He'i Nhandejáry: Ko va'e xe nhe'ẽ mombe'uhaty. Amondo-ta íxupe ne renonde omopotĩ hagwã nde raperã. Nde rerosapukái va'erã ne mombe'u-vy. Tekwaty e'ỹ-my nde rerosapukái va'erã. He'i va'erã upe pygwa-pe: Pemopotĩ katu Nhandejáry raperã. Pemokarẽ karẽ e'ỹ katu íxupe tape. Penhemoatyrõ katu henonde. Pembohape porã katu íxupe tape, he'i va'erã ne mombe'u-vy, he'i Nhandejáry.” Upéixa voi omoĩ va'ekwe kwatia-rehe onhe'ẽ Isaías, Nhandejáry nhe'ẽ-py omombe'u va'ety. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Upéa-gwi yma gware he'i hagwe-rami ojekwaa-ma Hesu rekoha mombe'uha. João Batista oporomongarai va'ety ojekwaa ou-vy. Tekwaty e'ỹ-my ojekwaa. Ojekwaa ramo, ohopa João renda-py ijaty va'e kwéry. Hemimombe'urã ohenduse hikwái: —Erova katu nde rekoha, he'i. —Enhemongarai uka katu nde ave, he'i. —Nde rekoha ererova ramo, erenhemongarai uka ramo ave, omboyke arã ndéhegwi Nhandejáry ne rembiapo vaikwe, he'i onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Upéixa ramo, ohopa João renda-py Judéia tetã mygwa. Ohopa ave entéro Jerusalém tetã mygwa. Onhemongarai uka hagwã Jordão ysyry-py oje'ói. Onhemombe'u ramo João-pe gwembiapo vaikwe-rehe, omongaraipa íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Camelo mymba ragwekwe-gwi onhemonde oiko-vy. Vaka pire iku'a jopyha. Tukúry-rehe okaru. Ei ka'agwy ave ho'u oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","He'i omombe'u-vy: —Ou-ta peteĩ xe rapykwerigwa va'e ipu'akave va'e xéhegwi. Amboete eterei íxupe. Upéa-gwi xe mirĩve-gwi, xe atĩ-gwi ave, ni hembigwái ramo jepe ndaikatúi apyta. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Xe katu oromongarai kuri y-py. Ha'e katu napene mongaraivéi-ma va'erã y-py xe oromongaraiha-rami. Omoingo va'erã ae peẽ-my Nhe'ẽ Marangatu tee va'e pende py'a-py opyta va'erã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Upe jave oiko joty Hesu Nazaré tetã-my. Galiléia yvy-py oiko. Ha upéi katu ogwahẽ ou-vy João renda-py. Ha João katu omongarai íxupe Jordão ysyry-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Osẽ jave y-gwi, Hesu ohexa-ma ojekwaa pya'e ramo yváy-py. Upe-gwi ha'e ohexa ogwejy va'e. Pykasu-rami ogwejy ou-vy Nhe'ẽ Marangatu tee va'e. Ójehe ogwejy ramo ohexa. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ha upéi katu onhehendu yváy-gwi onhe'ẽ va'e: —Nde katu xe ra'y xe rembihayhu. Xe orogwerohory ete va'e, he'i íxupe yváy-gwi onhe'ẽ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ha upéi katu pya'e ogweraha Hesu-pe Nhe'ẽ Marangatu tee va'e. Tekwaty e'ỹ-my ogweraha íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Upe-py opyta Hesu. Quarenta áry opyta ohekoteta hagwã íxupe anháy ruvixa Satanás. Ombojejavyse ramo jepe íxupe, ha'e ohexa uka joty Satanás-pe gweko mbaraeteha. Opyta oĩ-vy Hesu nhu pygwa mymba ndive. Ha upe jave ogwahẽ ou-vy yváy pygwa Hesu ha-py hembigwairã. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ha upéi katu João onhemoĩ preso. Onhemoĩ preso rire, Hesu oho outro tetã-my. Galiléia yvy-py oho. Oho omombe'u Tupã Nhandejáry rehegwa nhe'ẽ porã: ");
INSERT INTO kgkNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Ogwahẽ-ma hi'óra, he'i. —Pene mo'agwĩ-ma ou-vy Nhandejáry pende ruvixarã, he'i. —Emboasy ne rembiapo vaikwe, he'i. —Erova katu nde rekoha. Erovia katu Nhandejáry rehegwa nhe'ẽ porã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Upéi Hesu oho ogwata Galiléia yugwarusu yke-rehe. Ohexa oho-vy Simão-pe tyvýry ndive. Tyvýry héry André. Ohexa omombo ramo oity hagwã y-py kyha. Omombo ramo oipyhy hagwã pira-pe ohexa. Ha'e kwéry katu pira jopoihaty voi. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—Eju katu xe moirũ, he'i íxupe Hesu. —Nde katu pira jopói kwaahaty voi, he'i íxupe. —Ha xe orombo'e-ta xe moirũ uka hagwã yvypóry kente kwéry-pe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ohendu-ma ramo upéa nhe'ẽ, pya'e oheja okyha. Oho hupive omoirũ hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ha upéi henonde-rupi oho Hesu. Ohexa oho-vy mokõi Zebedeu ra'y, Tiago, tyvýry João ave. Ohexa omoatyrõ ramo kanoagwasu-py kyha. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ohexa ramo, pya'e ohenói íxupe kwéry Hesu. Ha ohejapa voi oirũ kwéry oho-vy. Kanoagwasu-py oheja íxupe kwéry oho-vy. Gwu Zebedeu ave oheja. Oheja ave gwembigwái. Oho hupive. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Upéi katu ogwahẽmba oho-vy Cafarnaum tetã-my. Pytu'uha áry-py pya'e oike Hesu ojeporahéi haty-py. Oike ramo onhemonhe'ẽ íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ha henduháry, —Mba'éixa po onhemonhe'ẽ, he'i opondera-vy hese hikwái: —Iporã ete inhe'ẽ, he'i. —Inhe'ẽ ndaha'éi gwĩ judeu rekombo'ehaty nhe'ẽ-rami, he'i hese. —Ha'e kwéry ndoikwaapáiry onhemonhe'ẽ hagwã. Ha'e ae onhe'ẽ nomombe'úiry hikwái. Ha Hesu katu ha'e ae onhe'ẽ ha'e omombe'u. Oporomonhe'ẽgendu kwaa va'e-rami onhemonhe'ẽ, he'i Hesu-rehe opondera-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Upe-ma ramo oime ojeporahéi haty-py anháy ojepota va'e hese. Osapukái he'i-vy: ");
INSERT INTO kgkNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Nde Hesu Nazaré pygwa. Ma'erã ore toryva? he'i íxupe. —Ereju-ma pa ore hundi hagwã? oporandu íxupe. —Xe oroikwaa voi kiva'e pa nde, he'i íxupe. —Nde katu Tupã Nhandejáry ra'y imarangatu va'e, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ha oja'o íxupe Hesu: —Ekirirĩ katu. Esẽ íxugwi, he'i anháy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ha upéa-gwi omboheteryrýi-ma íxupe anháy. Osapukái osẽ-vy anháy íxugwi oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ha ha'e kwéry, —Mba'éixa po omosẽ” he'i opondera eterei-vy hese: —Mba'eixagwa tipo kóa? he'i. —Teko pyahu-py nhane mbo'e ra'e, he'i. —Ohendu uka kwaa va'e-rami ombo'e Hesu. Omanda ramo, ohendu voi íxupe anháy, he'i hese ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Upe-ma ramo onhehendu herakwã opa-rupi. Enterovete ohendupa inhe'ẽ. Galiléia yugwarusu jerekwe rupigwa gwive ohendupa. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Osẽ ramo ojeporahéi haty-gwi, ogwahẽ oike reheve Simão róga-py. André oiko ave ojoha-py. Ogwahẽ onhondive Tiago João ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ha Simão raixo onheno oĩ-vy. Hasy heteraku-gwi. Pya'e omombe'u hese Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Oho Hesu. Oipopyhy. Omopu'ã íxupe. Oheja-ma íxupe heterakukwe. Ha upéi katu okwera rire Simão raixo, ha'e ogweru íxupe kwéry hemi'urã. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ka'aru ete. Oike-ma kwarahy. Oupa Hesu renda-py. Ogweru íxupe hasy va'e kwéry. Opa anháy rerekoha va'e gwive ogweru íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ha entéro tetã mygwa ijatypa hokẽ rovagwy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ha Hesu ombogwera heta-ma hasy va'e-pe. Opaixagwa mba'asy-gwi ombogwera. Omosẽ ave íxugwi kwéry heta anháy. Ha oikwaa voi íxupe anháy. Upéa-gwi omokirirĩ íxupe kwéry. Ndohejái onhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ko'ẽ morotĩ jave opu'ã Hesu. Osẽ oho ha'e anho tekwaty e'ỹ-my. Opyta upe-py onhomongeta-vy Tupã Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ha upéi katu oheka heka íxupe Simão inhirũ gwéry ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Otopa-ma ramo, he'i Hesu-pe: —Enterovete nde reka kuri, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ha Hesu he'i: —Jaha katu tetã ambue mbue-rupi tanhemonhe'ẽ upe-py ave. Upéa ajapo hagwã asẽ aju-vy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Upe rire oho Hesu opa-rupi. Galiléia yugwarusu jerekwe-rupi oho. Onhemonhe'ẽ nhe'ẽ oiko-vy ojeporahéi haty haty-rupi. Omosẽ mosẽ ave oiko-vy kente kwéry-gwi anháy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ha mba'asy vai-gwi ijaipa va'e katu ogwahẽ ou-vy iha-py. Onhesũ omboete-vy Hesu-pe. Ojerure íxupe okwera hagwã: —Nhane mbogwerahaty voi nde, he'i. —Xe-vy para'e xe mbogwera arã ave ra'e? he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ha Hesu oiporiahuvereko íxupe. Upéa-gwi oipyso opo. Opoko hese: —Orombogwera-ta voi katu nde-vy, he'i. —Ekwera katu, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hesu onhe'ẽ-ma ramo íxupe, okwera-ma. Opa aiai íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","—Aníke eremombe'u avave-pe orombogweraha, he'i jevy jevy íxupe. —Ekwa mani ehexa uka pa'i-pe erekweramaha, he'i íxupe. —Eme'ẽ íxupe upe Moisés amyrĩ ereme'ẽ hagwã he'i va'ekwe. Ha upéixa enterove oikwaa-ta erekweramaha, he'i íxupe. Upéi omondo pya'e íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ha upe okwera va'e katu osẽ omombe'upa joty. Opa-rupi omosarambi joty herakwã. Upéa-gwi ndikatuvéi-ma oike Hesu tetã tetãve-rupi. Tekwaty e'ỹ-my katu opyta oĩ-vy. Oupa vyteri Hesu renda-py. Opa-rupigwi ou hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ha Hesu katu nda'aréi oiko tekwaty e'ỹ-my. Oho jevy oike Cafarnaum tetã-my. Oike ramo, ohendu-ma oimeha hóga-py hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Upe rire heta ete ojogweroaty. Upéa-gwi ndikatúi oike avave hoga py-py. Gwĩ ogwahẽ va'e hokẽ rovagwy-rupi rei oiko hikwái. Ha Hesu katu omombe'u oiko-vy íxupe kwéry. Nhandejáry rehegwa nhe'ẽ porã omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Omombe'u jave, ogweru Hesu renda-py hajy jeapa va'e. Irundyve reheve ogweru henda-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Heta eterei ojogweroaty-gwi ndikatúi ogweroike Hesu renda-py. Upéa-gwi ojeupi oipe'a óga, Hesu ári ombokwa. Ombogwejy mbegwe katu imbou-vy. Ombogwejy hajy jeapa va'e-pe. Hupa reheve ombogwejy. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Irundyve-pe, hajy jeapa va'e-pe ave ohexa Hesu. Ohexa ojerovia-ma ramo ójehe. Upéi he'i hajy jeapa va'e-pe: —Amboyke-ma voi ne rembiapo vaikwe ndéhegwi, xe ra'y, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ha oĩ upe-py gwĩ judeu rekombo'ehaty. Onhepy'amongeta-vy ogwapy upe-py: ");
INSERT INTO kgkNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ma'erã upe va'e onhe'ẽ upéixa?” he'i oporandu-vy ojéupe. “Onhemonhandejáry ra'anga anga rei-vy, onhe'ẽ rei rei Hesu” he'i. “Tupã Nhandejáry ha'e anho mante omboyke kwaa va'e nhandéhegwi nhane rembiapo vaikwe” he'i. “Ndaipóri avave omboyke va'erã” he'i opy'a-py ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Onhepy'amongeta ramo upéixa hikwái, opy'a-py oikwaa-ma Hesu: —Ma'erã-gwi erenhe'ẽ vai rei nde py'apy-py? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","—Pejeapysaka porã katu xe nhe'ẽ-rehe, he'i íxupe kwéry. —Oĩ ramo, “Amboyke-ma ndéhegwi ne rembiapo vaikwe” he'i va'e katu, ndajahexái hemimboyke, he'i. —Omboyke para'e. Tapa nomboykéiry ra'e. Ndajahexáiry. Ha oĩ ramo, “Epu'ã katu, eraha nde rupagwe, egwata eho-vy” he'i rei va'e katu, jahexa ave. Nomopu'ãiry. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ãy aikwaa uka-ta peẽ-my xe nhe'ẽ rei e'ỹha ko yvy-py. Xe Nhande Ryke'y tee va'e voi. Xe nhe'ẽ-py rei amboyke-ma voi yvypóry rembiapo vaikwe. Peikwaa porã hagwã xe nhe'ẽ rei e'ỹha, ambogwera-ta upe hajy jeapa va'e-pe, he'i Hesu onhe'ẽ-vy gwĩ imbo'eháry-pe. Upe rire-ma ojere hajy jeapa va'e-pe: ");
INSERT INTO kgkNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ha'e-ta nde-vy. Epu'ã eraha nde rupagwe. Xe nhe'ẽ-py tereho nde róga-py, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ha upéi inhe'ẽ-py opu'ã oho. Gwupa ohupi heraha-vy. Osẽ oho enterove rovagwy-rupi. Upéixa Hesu ohexa uka íxupe kwéry onhe'ẽ rei e'ỹha. Upéa ohexa ramo ijaty va'e kente, —Mba'éixa po oporombogweraha, he'i ojóupe opondera-vy hese hikwái. Nhandejáry-pe omomba'egwasu hikwái. —Ndojehexáiry va'e koixagwa, he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ha upéi katu oho jevy Hesu yugwarusu rembe-py. Ojogweroatypa jevy hikwái upe-py. Ou Hesu renda-py. Onhemonhe'ẽ íxupe kwéry upe yugwarusu rembe-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Upéi ogwata oho-vy y rembe-rupi. Ohexa oho-vy Levi-pe. Ha Levi Alfeu ra'y. Ohexa íxupe nhane mbopaga haty-py: —Eju xe moirũ, he'i Levi-pe. Ha upéi katu opu'ã. Oho hupive. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ha Hesu okaru oĩ-vy Levi róga-py. Okaru ave Hesu ndive, hemimbo'e kwéry ndive ave, nhane mbopaga va'ety, heta ojejavy va'e ave. Heta oĩ Hesu irũ. Upéa-gwi heta voi okaru indive. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ha gwĩ fariseu judeu rekombo'ehaty va'e ohexa íxupe. Ohexa okaru ramo ojejavy va'ety ndive, nhane mbopaga va'ety ndive ave: —Ma'erã po okaru ra'e Hesu nhane mbopaga va'ety ndive, gwĩ ojejavy va'e ndive ave, he'i oporandu-vy hemimbo'e kwéry-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ohendu-ma ramo upéa Hesu, omombe'u íxupe kwéry arandu rehegwa nhe'ẽ nhane mbogwerahaty rehegwa-rami: —Nhane resãi ramo, nanhaikotevẽiry va'e nhane mbogwerahaty-rehe. Nhande rasy ramo ae, nhaikotevẽ va'e hese. Xe ndajúi ahenói hagwã, “Xe py'a potĩ” he'i ójehe va'e ou hagwã xe renda-py, he'i Hesu. —Ha gwĩ ojejavy va'e katu aju va'ekwe ahenói-vy, he'i joty íxupe kwéry Hesu hemimopotĩse-rehe onhemoirũ uka hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ha upéi katu ohasa okaru e'ỹ reheve João remimbo'e kwéry, fariseu kwéry ave. Ndaha'éi ojóupe gwarã-rehe upéixa oiko hikwái. Nhandejáry pegwarã-rehe ae upéixa oiko hikwái. Upe ramo ogwahẽ ou-vy Hesu renda-py oporandu va'e: —Ma'erã ohasa okaru e'ỹ reheve João remimbo'e kwéry fariseu kwéry ave? he'i. —Ha ne remimbo'e kwéry katu ma'erã po ndohasái okaru e'ỹ reheve? he'i oporandu-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ha Hesu oiporu mendaha rehegwa nhe'ẽ oikwaa uka porã hagwã. He'i íxupe kwéry: —Oĩ vyteri ramo omenda va'ekwe, ndikatúi ohasa okaru e'ỹ reheve he'ýi kwéry. Ma'erã ere kuri, “Tohasa okaru e'ỹ reheve” he'i oporandu-vy. —Ndikatúi ohasa okaru e'ỹ reheve onhondive oime ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ha upe rire katu ogwahẽ va'erã hi'áry. Ojereraha va'erã íxugwi kwéry omenda va'ekwe. Ojereraha rire nda'ivýi va'erã okaru he'ýi kwéry, he'i upe pygwa-pe ojehegwa omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Upéi Hesu oiporu ao rehegwa nhe'ẽ, uva rykwere rehegwa nhe'ẽ ave oikwaa uka porã hagwã íxupe kwéry. He'i íxupe kwéry: —Nanharemendái ipyahu va'e-py ao tujakwe. Nharemenda ramo, onhy arã ra'e ipyahu va'e ojepoapy-vy. Omondoro arã ao tujakwe-pe. Opyta arã ra'e osorove, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","—Nanhanhunháiry uva rykwere pyahu va'e hyru vakapi nda'ijyvéi ma va'e-py. Nhanhunha ramo, ovu omondoropa-ma va'erã gwyru tuja. Osyrypa arã pe uva rykwere ra'e. Osoropa arã hyrukwe. Uva rykwere pyahu va'e katu nhanhunha hyru pyahu-py ave, he'i Hesu ohekombopyahu kwaa uka hagwã íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ha upéi katu pytu'uha áry-py oho ogwata Hesu. Trigoty mbyte-rupi oho. Ha hemimbo'e kwéry oipo'o-ma oho-vy trigo rope. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ha he'i Hesu-pe fariseu kwéry: —Ema'ẽ hese, he'i. —Ma'erã po ha'e kwéry oipo'o trigo rope pytu'uha áry-py? Jaipo'o ramo trigo rope, nhamba'apo voi. Ndikatúi nhamba'apo pytu'uha áry-py, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ha he'i íxupe kwéry Hesu: —Ma'erã eremonhe'ẽ nhe'ẽ rei Nhandejáry kwatia nhe'ẽ, Davi amyrĩ rehegwa nhe'ẽ? Mba'éixa katu ndereikwaáiry? he'i oporandu-vy íxupe. Upéi he'i: —Nahembi'úi-gwi, ivare'apa va'ekwe Davi inhirũ gwéry ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Upéa-gwi oike koty-py va'ekwe. Nhandejáry-pe nhamboete haty-py oike, oiko ramo Abiatar pa'i ruvixagwasu ramo. Ho'u va'ekwe gwĩ mbojape Nhandejáry rovagwy-py pa'i remimoĩgwe. Nhandejáry ndohejái avave-pe ho'u va'erã upe mbojape. Pa'i kwéry rembi'u ae. Upéa ndikatúi ho'u avave. Ha Davi ae katu ho'u joty va'ekwe. Pa'i e'ỹ ramo jepe Davi ho'u joty va'ekwe. Omongaru ave oirũ gwéry va'ekwe, he'i oikwaa uka-vy íxupe kwéry. —Iporã voi ra'e ja'u trigo rope ko'ánga, he'i oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Upéi he'i jevy íxupe kwéry Hesu: —Omoĩ va'ekwe Tupã Nhandejáry upe pytu'uha áry nhane kane'õgwa hagwã. Teko rei remimombe'u nhane mbohasa asy hagwã nomoĩry va'ekwe. Nhande-rehe ha-py ae katu omoĩ va'ekwe pytu'uha áry, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","—Ha xe katu Nhande Ryke'y tee va'e. Upéa-gwi xe ae pytu'uha áry járy voi, he'i. —Xe ae pytu'uha áry moĩha voi, he'i. —Xe ae amandave va'e, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ha upéi katu oike jevy Hesu ojeporahéi haty-py. Oike ramo ohexa-ma oĩ ramo ipo ypi va'e. Upe ramo judeu ruvixa orepara Hesu-rehe: ");
INSERT INTO kgkNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","—Oporombogwera-ta para'e pytu'uha áry-py? he'i hese oporandu-vy ojóupe hikwái. Upéa-gwi orepara para hese hikwái ohexa hagwã. Oity vai ukase mo'ã Hesu-pe. Oporombogwera ramo, “Omba'apo ra'e”, he'ise hese. Tembiapo vai ombojase mo'ã hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ha Hesu he'i ipo ypi va'e-pe: —Eju katu enhembo'y ore kwéry rovái, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Upe rire oporandu judeu ruvixa-pe: —Iporã tipo pytu'uha áry-py nhane rembiapo porã e'ỹ? Erejohu porã va'erã tipo jajapo vai ramo? Iporã tipo pytu'uha áry-py nhaporombogwera e'ỹ? Erejohu porã va'erã tipo japorojuka ramo? he'i íxupe kwéry. Onhe'ẽreitypa íxupe kwéry. Ha ha'e kwéry katu opyta okirirĩmba hikwái íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ha upéi katu Hesu ndaija'éi ha'e kwéry heko vaiha-rehe orepara para-vy hese kwéry. Ndovy'avéi-ma. Ha'e kwéry nainhakã porãi-gwi, nainharanduséiry-gwi, ndovy'áiry: —Eipyso katu nde po, he'i íxupe, ipo ypi va'e-pe. Oipyso ramo, okwera-ma ipo. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ha fariseu kwéry osẽmba oho-vy íxugwi. Osẽ rire pya'e ojogweroaty Herodes irũ gwéry ndive: —Mba'éixa tamo ra'e jajuka íxupe, he'i oporandu randu-vy ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ha upéi katu oho jevy Hesu yugwarusu rembe-py. Gwemimbo'e kwéry ndive oho. Heta eterei Galiléa yugwarusu jerekwe rupigwa oho ave hapykwéri. Heta eta ou upe Hesu ojapo va'ekwe rerakwã rendu-vy. Ohendu heta Judéia pygwa ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ohendu heta Jerusalém pygwa, heta Iduméia pygwa ave. Heta Jordão ysyry rovái pygwa ave ohendu. Ohendu heta Tiro jere rupigwa. Sidom jere rupigwa ave herakwã ohendu. Upéa-gwi oupa ete voi Hesu renda-py hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Ou ramo hikwái omongwera gwera heta va'e-pe Hesu. Upéa-gwi ijatypa hasy va'e kwéry opoko hagwã hese onhembogwera ukase-vy. Upe ramo he'i Hesu: —Emoĩ porã katu xe-vy xe renagwã kanóa pono xe jopy eterei, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ha anháy rerekoha katu ohexa ramo íxupe, ojeity ity Hesu rovagwy-rupi osapukái-vy: —Nde katu Tupã Nhandejáry ra'y voi, peteĩ teĩ he'i ojeity-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","—Ani xe mombe'u mbe'u kiva'e pa xe, he'i peteĩ teĩ-pe oja'o-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Upéi ojeupi oho-vy yvyatyrusu-py. Ohenói gwembiporavokwe-pe. Ha oupa Hesu renda-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ha Hesu katu oiporavo doze kwimba'e-pe omoirũ hagwã íxupe: —Oromondo-ta erenhemonhe'ẽ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xe nhe'ẽ-py eremosẽ-ta anháy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Upéixa-rupi oiporavo Simão-pe. Ha Simão-pe ombohéry joapy Pedro-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Oiporavo ave Zebedeu ra'y-pe, Tiago, tyvýry João ave. Upe mokoĩve va'e ombohéry joapy ave Boanerges-py. Héry he'ise: Tyapu ramigwa. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Oiporavo ave André, Filipe, Bartolomeu ndive. Oiporavo Mateus, Tomé, Alfeu ra'y Tiago ndive. Oiporavo ave Tadeu, Simão ndive. Upe va'e gwĩ huvixa ramo oiko va'e-pe omosẽse va'e kwéry irũ va'ekwe. Oiporavo ave Judas Iscariotes. Upe va'e Hesu pyhyharã-pe omombe'u va'erã. Upe doze kwimba'e oiporavopa-ma Hesu oirũrã. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Upéi Hesu oike oho-vy oga py-py. Ha heta eta ojogweroaty jevy. Upéa-gwi ndikatúi okaru Hesu inhirũ gwéry ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Upéa ohendu ramo, Hesu róga pygwa osẽ oho onhangareko hagwã hese heraha-vy. —Itavy, he'i mo'ã hese hikwái. Upéa-gwi osẽ oho onhangareko hagwã mo'ã hese he'ýi kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ha judeu rekombo'ehaty katu Jerusalém-gwi ou va'ekwe he'i: —Gwĩ Belzebu anháy ruvixa katu ojepota ra'e Hesu-rehe. Upéa-gwi Belzebu nhe'ẽ-py omosẽ anháy imondo-vy. Upe anháy ruvixa nhe'ẽ-py omosẽ íxupe kwéry, he'i mo'ã hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Upe va'e-rupi ohenói íxupe kwéry Hesu. Arandu rehegwa nhe'ẽ omombe'u íxupe kwéry, tetã mygwa rehegwa nhe'ẽ poru-vy. Imbaraete va'e rehegwa nhe'ẽ oiporu ave: —Mba'éixa katu omosẽ-ta hesegwa Satanás, upe anháy ruvixa va'e, he'i. —Ndikatúiry omosẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ha mburuvixagwasu re'ýi ndaijojavéi-ma ramo, ndoiko porãvéi-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ha hóga pygwa ndaijojavéi-ma ramo, ndoiko porãvéi-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ha Satanás re'ýi kwéry ave ndaijojavéi-ma ramo ra'e, ndoiko porãvéi-ma arã ra'e Satanás. Ndoikovéi-ma arã ra'e. Opa-ma arã ra'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Ha ndikatúi avave oike imbaraete va'e róga-py omonda hagwã imba'e kwéry-rehe. Onhapytĩ ranhe ramo ae íxupe, ogwerahapa arã hóga-py oĩ va'e, he'i íxupe kwéry Hesu. Upéixa ha'e kwéry ijapuha oikwaa uka íxupe. Anháy ndikatúi omosẽ ojehegwa, he'i ramo oikwaa uka íxupe ha'e kwéry ijapuha. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","—Anháy ojepota ra'e Hesu-rehe, he'i mo'ã hese kuri hikwái. Hesu Nhe'ẽ Marangatu tee va'e-pe omoanha anháy hikwái. Upéa-gwi he'i íxupe kwéry Hesu: —Anhete ko xe ha'e-ta nde-vy. Ne rembiapo vai ramo, erenhe'ẽ vai ramo Nhandejáry-rehe, omboyke-ta ndéhegwi Nhandejáry ne rembiapo vaikwe. Ha erenhe'ẽ vai ramo katu Nhe'ẽ Marangatu tee va'e-rehe, nande poriahuvereko mo'ãiry. Nde py'a ky'a-ma. Nande py'a potĩ mo'ãvéi opa e'ỹ reheve, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Upe rire ou isy tyvýry kwéry ave. Opyta oka-py. Ohenói uka osẽ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Heta ogwapy hikwái Hesu jerekwe-vy: —Nde sy ou. Ou ave nde ryvy ne reindy ave. Oka-py ogwahẽ oĩ-vy, he'i íxupe. —Nde rexase, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ha ha'e nosẽiry joty oho-vy. Upéi he'i: —Amombe'u-ta peẽ-my kiva'e pa xe sy, kiva'e pa xe ryvy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Upe rire orepara gwenduha-rehe ojerekwe-rehe ogwapy va'e: —Ehexa, he'i gwenduha-pe, —ko va'e kwéry xe sy. Upe va'e kwéry xe ryvy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","—Nhandejáry nhe'ẽ ojapo va'e gwive upéa voi xe ryvy, he'i. —Upéa xe reindy, upéa xe sy ave, he'i gwenduha-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ha upéi katu onhemonhe'ẽ jevy-ma Hesu yugwarusu rembe-rehe. Ha heta eterei ijatypa henda-py. Upéa-gwi oike kanoagwasu-py íxugwi kwéry. Ogwapy-ma kanóa py-py. Y rembe'y-py oĩ kanóa. Ha enterove opyta yvy-py hikwái. Y rembe-rehe opyta. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ha heta onhemonhe'ẽ nhe'ẽ íxupe kwéry arandu rehegwa nhe'ẽ omombe'u-vy. Omombe'u arandu rehegwa nhe'ẽ íxupe kwéry temitỹgwe rehegwa-rami: ");
INSERT INTO kgkNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Pejeapysaka joa joa, he'i. —Oho onhemitỹ onhemitỹ va'e. Omohãi gwemitỹ. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Onhemitỹ jave, oime temitỹ ra'ỹi tape-rupi ho'a va'e. Ha upéi ou gwyra opa ho'u. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oime temitỹ ra'ỹi ave yvy pererĩ-rupi ho'a va'e. Upe-py oĩ mixĩmi yvy. Pya'e henhói-ma, yvy ndahetáiry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kwarahy haku-ma ramo, onhandu-ma temitỹgwe kwarahy aku. Ha kwarahy ohapypa voi. Ombohovirupa ave hapo e'ỹ reheve. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oime nhuatĩndy-rupi ho'a va'e ave. Ha nhuatĩ katu okakwaa-ma. Ojaho'ipa temitỹgwe-pe. Upéa-gwi ndahopéiry. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oime yvy porã-my ho'a va'e ave. Henhói-ma hemitỹ. Okakwaa. Hope-ma. Oĩ trinta ha'ỹi va'e. Oĩ sessenta ha'ỹi va'e. Oĩ ha'ỹive va'e cem ha'ỹi va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne aranduse va'e, ejeapysaka porã katu xe nhe'ẽ-rehe, he'i onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ijatypa va'e oje'ói rire, oporandu Hesu-pe doze hemimbo'e kwéry inhirũ gwéry ave: —Temitỹgwe rehegwa nhe'ẽ ereiporu kuri. Mbava'e-rehe po he'i upe va'e? he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Upéi he'i Hesu íxupe kwéry: —Ha peẽ katu peikwaa voi mba'éixa po nhamoirũ-ta Nhandejáry nhande ruvixa. Nhandejáry oikwaa uka-gwi peẽ-my peikwaa. Ha ambue kwéry-pe katu ndoikwaa ukáiry. Upéa-gwi temitỹgwe rehegwa-rami amombe'u kuri Nhandejáry nhande ruvixarã rehegwa nhe'ẽ, anhemonhe'ẽ-vy íxupe kwéry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","—Ha upéi oma'ẽ ma'ẽ hikwái. Ha ndohexái mba'eve. Ohendu hendu. Ha ndoikwaái mba'eve. Upéa-gwi ndogwerovái gweko. Ha Nhandejáry katu nomboykéiry íxugwi kwéry hembiapo vaikwe. Upéa-rehe arandu rehegwa nhe'ẽ aiporu mante amombe'u-vy íxupe kwéry Nhandejáry rehegwa nhe'ẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","—Ha peẽ katu ndapeikwaa porãi ave. Ma'erã ndapeikwaa porãi? Aipo ramo, mba'éixa peikwaa-ta arandu rehegwa nhe'ẽ gwive amombe'u mbe'u ramo? ");
INSERT INTO kgkNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Onhemitỹ va'e onhemitỹ. Upéa he'ise: Omoherakwã Nhandejáry rehegwa nhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ha tape-rupi onhenhotỹ va'ekwe katu he'ise: Oĩ ohendu va'e nhe'ẽ porã. Ohendu-ma ramo, ou anháy ruvixa Satanás. Oipe'a ipy'a-gwi inhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ha yvy pererĩ-rupi onhenhotỹ va'ekwe katu he'ise: Oĩ ohendu va'e inhe'ẽ porã. Ohendu-ma ramo, ovy'a ogwerovia-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ha ndahapóiry. Upéa he'ise: Sapy'a ete ogwerovia. Ndogwerovia teéiry voi. Ha upe rire katu nhe'ẽ porã rendu-gwi, omoingo asy íxupe. Ojerereko asy-gwi, ndogweroviasevéiry. Pya'e a'e oheja nhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ha nhuatĩndy-rupi onhenhotỹ va'ekwe katu he'ise: Oĩ ohendu va'e voi inhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ha onhesamondo mondo omba'e-rehe: “Mba'éixa po aiko-ta ko'ánga?” oporandu randu ojéupe. Ovy'a-ta mo'ã imba'e reta ramo. Oipotave tave ojéupe gwarã. Upéa-gwi ohendu hendu rei inhe'ẽ porã. Nahembiapo porã porãiry. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ha yvy porã-my onhenhotỹ va'ekwe katu he'ise: Oĩ ohendu va'e inhe'ẽ porã. Ohendu ramo ogwerovia tee voi. Ogwerovia-gwi, oĩ hembiapo porã porã va'e. Oĩ hembiapo porãve rãve va'e. Oĩ hembiapo porã eterei va'e ave, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ha upéi katu Hesu omombe'u jevy arandu rehegwa nhe'ẽ tataendy rehegwa-rami: —Ndajarúi voi tataendy nhamoĩ hagwã mba'e ryru gwy-py. Ndajarúi ave nhamoĩ hagwã tupa gwy-py. Tataendy katu jaru nhamoĩ hagwã tataendy rendaty-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Oime va'e gwive onhenhomi va'e ojekwaa-ta voi. Ha pe ereikwaa e'ỹ va'e gwive, upéa ereikwaa-ta voi ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ne aranduse va'e, ejeapysaka porã katu xe nhe'ẽ-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","—Ejeapysaka porã erehendu va'e-rehe. Ereme'ẽ me'ẽ va'ekwe ohekoviarõ-ta nde-vy. Hetave ave ohekoviarõ-ta. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Heta ogwereko va'e-pe hetave ohekoviarõ-ta. Ha naimba'e rexakwaái va'e-gwi katu, oipe'apa-ta íxugwi. Ogwereko va'e gwive oipe'apa-ta íxugwi, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ha upéi katu omombe'u jevy Nhandejáry nhande ruvixarã rehegwa nhe'ẽ temitỹgwe rehegwa-rami: —Kwimba'e oho onhemitỹ. Onhemitỹ yvy-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Upéi pyhare hare oke-ma. Iko'ẽmba ẽmba opu'ã-vy. Henhói rei temitỹ. Okakwaa. Ha ndoikwaáiry mba'éixa po henhói. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hemitỹgwe katu omohenhói rei yvy. Upe rire ombohope. Upe rire omoha'ỹi. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ijagwyje-ma ramo, oikytĩ uka ogwahẽ-ma hi'áry-gwi, he'i íxupe kwéry Hesu, Nhandejáry irũ ojekwaa va'erã rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","—Mba'éixa aikwaa uka-ta peẽ-my Nhandejáry nhande ruvixaha? Mba'eixagwa nhe'ẽ aiporu-ta pene mo'arandu hagwã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","—Amombe'u-ta Nhandejáry nhande ruvixarã rehegwa nhe'ẽ temitỹgwe mostarda rehegwa-rami, he'i. —Oĩ temitỹ héry va'e mostarda. Onhotỹ ramo, mixĩ eterei. Mixĩve opamba'e ra'ỹi-gwi yvy arigwa-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ha onhotỹ-ma rire, pya'e tuvixa. Entéro temitỹ-gwi tuvixave. Upéi hakãmby-ma. Upéa-rehe ojapo-ma gwyra gwaityrã. Hi'ã gwy-py ojapo, he'i íxupe kwéry Hesu, Nhandejáry irũ hetave tave oĩ va'erã rehegwa oikwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Upéixa voi omombe'u mbe'u íxupe kwéry Hesu arandu rehegwa nhe'ẽ temitỹgwe rehegwa-rami. Peteĩ teĩ oikwaa peve omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Onhemonhe'ẽ-vy íxupe kwéry, temitỹgwe rehegwa nhe'ẽ va'e-rupi, tataendy rehegwa va'e-rupi ave omombe'u íxupe. Upéa rehegwa oiporu e'ỹ reheve nomombe'úiry íxupe kwéry. Ha hemimbo'e kwéry anho hendive oime ramo, oikwaa ukapa-ma íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ha upéi ka'aru ete-ma. —Jaha jahasa y rovái, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Upéi ohejapa oho-vy ijaty va'e-pe hikwái. Ogwapy oĩ-vy kanoagwasu-py Hesu. Upéixa ramo ogweraha íxupe y-rupi y rovái. Oho ave hupive kanóa ambue va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ha upéi katu ou yvytugwasu. Opu'ã pu'ã-ma y. Oike kanoagwasu-py y. Upéa-gwi haimete-ma kanóa hynyhẽ y-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ha Hesu katu oke oĩ-vy kanóa-py. Hemimbo'e kwéry kupe-py oke. Oke inhakãngyta ári. Ha omombáy-ma íxupe hikwái. —Nhande nhanheapymi-tama, mbo'eháry, he'i omombáy-vy íxupe. —Nerepenái tipo nhande rekove-rehe? he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ha opáy-ma Hesu. Ha opáy jave Hesu ohexa-ma y opu'ã pu'ã va'e. Ha oja'o yvytugwasu-pe omombyta hagwã: —Ekirirĩ katu, he'i y-pe. Inhe'ẽ rupi opyta-ma yvytu. Okirirĩmba ete voi. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ha'e he'i: —Ma'erã nde py'amirĩ upéixa? Nderejeroviáiry xe-rehe. Ma'erã nderejeroviáiry xe-rehe? he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ha onhemondyipa-ma íxugwi hikwái. —Kiva'e po ko va'e? Oja'o ramo yvytugwasu-pe, oja'o ramo y-pe ave íxupe, ohendu voi inhe'ẽ, he'i ojóupe hikwái hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ha upéi katu Hesu gwemimbo'e kwéry ndive ohasa yugwarusu rovái. Ogwahẽ Geraseno kwéry retã-my. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Osẽ-ma ramo Hesu kanoagwasu-gwi, ou ohugwaitĩ-vy íxupe anháy ojepota va'e hese. Oyta-gwi ou. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Oiko rei oyta-rupi anháy ojepota va'e hese. Ndikatuvéi onhapytĩ íxupe avave. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Onhapytĩ jevy jevy rei íxupe. Oipokwa pokwa íxupe corrente-py. Oipykwa pykwa ave íxupe. Ha anháy-rehe omenda va'e katu omondohoypa-ma. Omopesẽgwe sẽgwepa, omondoho ndohoypa-ma íxugwi. Ndaipóri ipu'aka va'e hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pyhare osapukái oĩ-vy oyta-rupi, yvyaty aty-rupi ave. Áry ramo osapukái ave. Onhekytĩ oiko-vy ita-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mombyry-gwi ohexa-ma Hesu-pe. Oripara ojeity omboete hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","He'i osapukái hatã-vy: —Nde, Hesu, he'i. —Tupãgwasu ra'y nde, he'i. —Ma'erã tipo erepena xe-rehe? he'i oporandu-vy Hesu-pe. —Tupã Nhandejáry réry-py, ajerure nde-vy. Aníke xe mbohasa asy, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Upéa he'i jave, —Anháy, he'i, —esẽ katu íxugwi, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Upéi oporandu íxupe: —Mba'éixa nde réry? he'i íxupe. —Heta xe ae xe moirũ va'e. Upéa-gwi xe réry Heta ave, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Upéi ojapura anháy ojerure-vy Hesu-pe pono omondopa íxupe kwéry pe tetã-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ha upe-py heta eterei oĩ kure. Yvyaty rembe'y-rehe okaru hikwái kure. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ha anháy kwéry ojerure íxupe: —Ore mondo katu kure kwéry-rehe. Toroike ipy'a kwéry-py, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Tapeho, he'i íxupe kwéry Hesu. Ha anháy kwéry katu osẽ íxugwi. Oike kure kwéry yta-py. Ha kure kwéry oriparapa ogwejy. Y rembe'y-py ogwejy oho-vy. Hi'apỹ ho'a-vy. Otĩgwe-vy ho'a yugwarusu-py. Heta eterei onheapymimba y py-py. Mokõi mil-rupi, gweta hagwe-ma onheapymimba. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ha herekwa kwéry katu oriparapa oho-vy hikwái. Omombe'u tetã mygwa-pe. Tetã jerekwe-rehe oĩ va'e-pe omombe'u ave. Oupa ohexa ojehu va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ogwahẽmba Hesu renda-py. Ohexa anháy rerekohare hikwái. Ohexa íxupe ogwapy ramo. Onhemonde ramo ohexa. —Ndaitavyvéi-ma voi ra'e, he'i hexa-vy hikwái. Upéa-gwi ikyhyjepa-ma hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ha upe hexahare omombe'upa íxupe kwéry. Ojehu va'ekwe omombe'upa íxupe. Omombe'u ave anháy rerekohare rehegwa nhe'ẽ. Kure kwéry rehegwa nhe'ẽ omombe'u ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Upéa-gwi upe pygwa kwéry okyhyje-ma Hesu-gwi hikwái. Ojerure-ma íxupe osẽ hagwã hetã kwéry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Upe rire onhemboyru kanóa-py Hesu. Onhemboyru-ma ramo ojapura upe anháy rerekohare omoirũ hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ha ndohejái omoirũ íxupe: —Tereho ae katu nde róga-py. Ekwa emombe'u nde re'ýi kwéry-pe erekwera porãmaha. “Nhandejáry ojapo porã porã xe-rehe” ere katu emombe'u-vy, he'i íxupe. —“Xe poriahuvereko eterei-ma voi Nhandejáry” ere katu emombe'u-vy, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ha upéi katu oho omosarambi-vy anháy rerekohare Decapolis tetã mygwa-pe. “Ojapo porã porã xe-rehe Hesu” he'i omombe'u-vy. —Nhandejáry ojapo porã porã hese, he'i opondera-vy hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ha upéi katu Hesu oho jevy kanoagwasu-py. Ohasa oje'ói-vy y rovái. Ogwahẽ rire heta eterei jevy ijatypa henda-py. Ha Hesu yugwarusu rembe-py onhembo'y oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ha upéi ojapura ou-vy ojeporahéi haty-py omanda va'e. Héry Jairo. Ohexa-ma ramo íxupe, onhesũ omboete-vy Hesu renonde-py: ");
INSERT INTO kgkNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Omano-tama xe rajymi, he'i. —Jaha katu eremoĩ hagwã hi'ári nde po okwera hagwã, nomanovéi hagwã, he'i ojapura-gwi Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Upéa-gwi oho hendive Hesu. Ha ijaty va'e ojopypa íxupe oho-vy hapykwéri. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Oime kunha. Are-ma hasy. Hasy doze ro'y. Tuvixa hasyha ogwejy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ohasa asy ete va'ekwe. Heta oĩ imongweraharã mo'ã, ha nomongweráiry. Ha ome'ẽmba rei-ma va'ekwe ogwereko va'e íxupe kwéry okwera hagwã mo'ã. Ha ndokwerái joty. Opyta hasyve va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Upéi katu ohendu Hesu rerakwã. Upéa-rehe ojogweroaty aty ramo hikwái, oho hapykwéri, Hesu rapykwéri. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Apoko ramo xe ijao-rehe jepe, akwera arã”, he'i ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Upéa-gwi opoko ijao-rehe. Opoko-ma ramo hese, opi-ma íxupe imba'asy. Oikwaa okweramaha imba'asy-gwi hete. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ha Hesu katu oikwaa-ma omongweramaha kunha-pe. Upéa-gwi ojere-ma Hesu ijatypa va'e mbyte-py: —Kiva'e opoko-ma xe ao-rehe, he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ha hemimbo'e kwéry he'i íxupe: —Ema'ẽ katu ijatypa va'e-rehe. Ojejapipa voi nde-rehe ra'e. “Kiva'e opoko xe-rehe” ma'erã ere upéixa, he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ha Hesu oma'ẽ oĩ-vy ohexa hagwã kiva'e po ojapo upéixa ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ha kunha katu oikwaa okweramaha. Upéa-gwi ikyhyje-ma. Oryrýi-ma ave. Ou ojeity henonde-py. Omombe'upa íxupe anhete va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Xe rajy, he'i kunha-pe ipy'agwapy hagwã. Gwajýry-pe he'iha-rami, he'i kunha-pe, —nde erejerovia-ma kuri xe-rehe, upéa-gwi erekwera-ma. Tereho nde py'agwapy reheve. Nande rasyvéi-ma ne mba'asy-gwi, he'i kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Onhe'ẽ vyteri jave, ou mburuvixa róga-gwi omombe'u: —Omano ete-ma nde rajy, he'i túvy-pe. —Eheja katu toho mbo'eháry, he'i Jairo-pe omombe'u va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ha Hesu katu ohendu omombe'u ramo: —Aníke erekyhyje. Ejerovia katu xe-rehe, he'i mburuvixa Jairo-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ha upéi katu ndohejái omoirũ íxupe avave. Mbohapy hemimbo'e anho mante omoirũ íxupe. Oho indive omoirũ Pedro, Tiago, tyvýry João ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ogwahẽ-ma mburuvixa róga-py. Ohexa heta ijayvu joa va'e. Ha ha'e kwéry hasẽmba voi osapukái-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oike Hesu. He'i íxupe kwéry: —Ma'erã tipo pende ayvu? Ma'erã tipo pene rasẽmba rei pekwa-vy? he'i íxupe kwéry. —Nomano teéiry voi upe mitã kunha. Oke ae maniko oĩ-vy ra'e, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ha'e kwéry katu onhembohory Hesu-rehe. Ha ha'e katu omosẽmba imondo-vy. Ogweraha ondive mitã ru, isy oirũ ave. Oike mitã kunha oĩ ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Oipopyhy íxupe. —“Talita cumi” he'i íxupe. Ha'e ae onhe'ẽ-py ohenói omopu'ã hagwã, “Mitã kunha, epu'ã katu” he'i-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Upe mitã kunha opu'ã-ma ogwata-ma. Mitã kunha katu doze ro'y ogwereko va'e. Upéa-gwi, —Mba'éixa omoingove jevy íxupe? he'i opondera eterei-vy hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ha Hesu he'i: —Aníke avave ohendu, he'i jevy jevy íxupe kwéry Hesu. —Emongaru íxupe, mitã kunha-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Upe-gwi oho Hesu. Gwetã-my ogwahẽ jevy. Omoirũ íxupe hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ha pytu'uha áry-py Hesu onhemonhe'ẽ jevy-ma. Ojeporahéi haty-py onhemonhe'ẽ. Heta ohendu va'e inhe'ẽ, —Mba'éixa onhemonhe'ẽ? he'i opondera-vy hese hikwái: —Mamo-gwi upéa ohendu aipo va'e nhe'ẽ? he'i hese. —Kiva'e omombe'u hi'arandu hagwã íxupe? he'i hese. —Ema'ẽ hese. Hexapyrã-rupi voi Hesu rembiapo porã. Mba'éixa ojapo upéixa? he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—Upéa óga apohatygwe voi, he'i. —Maria memby voi. Tiago, José, Judas, Simão ave ityvýry kwéry voi. Heindýry kwéry oiko voi nhane ndive. Ma'erã onhembotuvixa ukase? he'i opondera-vy hese. Upéa-gwi ndija'evéi Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Upéi he'i íxupe kwéry Hesu: —Ha onhemonhe'ẽ va'ety onhemboete voi. Ha hetã mygwa katu nomboetevéiry íxupe. He'ýi kwéry ave nomboetevéiry íxupe. Hóga pygwa ave nomboetevéiry ave íxupe, he'i ójehe ndaija'evéi-gwi he'ýi kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Upéa-gwi ndikatúi hembiapo porã hexapyrã-rupi. Mbovymi hasy va'e-rehe mante omoĩ opo omongwera hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ha ndogweroviái-gwi hikwái, —Mba'éixa ndogweroviái? he'i opondera-vy hese kwéry Hesu. Upéi oho tetãgwasu jerekwe-rupi. Tetã mirĩ mirĩ oĩ ha-rupi oho onhemonhe'ẽ-vy Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ha upéi katu Hesu ohenói doze gwemimbo'e kwéry-pe ogwahẽ hagwã ha'e-py. Mokõ mokõi meme omboja'o ja'o imondo-vy: —Xe nhe'ẽ-py emosẽ imondo-vy anháy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Aníke ereraha mba'eve. Nde pykoka anho eraha, he'i. —Ani ereraha ne remi'urã ani ereraha nde vosa. Ani ave ereraha pirapire ne ku'asã gwy-py, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","—Emonde nde pyryru. Ne kamisa katu ani erembojo'a, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Ereike ramo óga-py epyta upe-py. Ani erembopopa ereiko-vy. Eresẽ peve upe tetã-gwi, eiko petẽi óga-py íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ha oĩ ramo tetã mygwa pende rerohory e'ỹ va'e, pene nhe'ẽ renduse e'ỹ va'e katu, eresẽ ramo upe tetã-gwi embovava nde py ho'apa hagwã yvy timbore nde py-gwi. Upéixa erejapo ramo, eremomandu'a uka arã hembiapo vaikwe-rehe. “Nhandejáry re'ýi e'ỹ-rami nipo ra'e nhande” he'i va'erã ójehe, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aipo-gwi hemimbo'e kwéry oho onhemonhe'ẽ-vy enterove va'e-pe: —Erova nde rekoha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Omosẽ imondo-vy heta anháy-pe. Hasy va'e-rehe omona nhandy omongwera hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ha Hesu rerakwã opa opa-rupi oho. Upéixa-gwi mburuvixagwasu Herodes ohendu ave Hesu rerakwã. Kente kwéry omombe'u mbe'u ojóupe Hesu rerakwã. Gwĩ Hesu rexa-vy, he'i ojóupe: —João Batista oikove jevy-ma, he'i mo'ã. —Upéa-gwi hexapyrã-rupi hembiapo porã porã voi, oĩ he'i va'e mo'ã Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hesu rexa-vy he'i ojóupe: —Upe va'e ko Elias, oĩ he'i va'e mo'ã ave Hesu-rehe. —Upe va'e ko onhemonhe'ẽ va'ety yma gwaréixa, oĩ he'i mo'ã va'e ave hese. Upéixa voi ha'e kwéry hupi e'ỹ omombe'u. Omombe'u jokupe kupe hesegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Upéixa ramo Herodes mburuvixagwasu va'e ohendu Hesu rerakwã. Upe ojapo japo va'ekwe ohendu: —Upe João xe anhakã'o uka va'ekwe, oikove jevy-ma nipo ra'e, he'i mo'ã hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Are-ma omenda va'ekwe Herodes. Gwyvýry rembirekokwe-rehe omenda va'ekwe. Gwovajáry Herodias-rehe omenda va'ekwe. Tyvýry héry Filipe. Ha João katu he'i va'ekwe íxupe, Herodes-pe: “Ereiko ramo nde ryvy rembireko ndive, ndatekoháiry erereko” he'i va'ekwe íxupe. Upéa-gwi mburuvixagwasu omondo va'ekwe ipiári oipyhy uka hagwã João-pe. Omoĩ uka va'ekwe íxupe preso. Gwembireko-rehe onhe'ẽ-gwi, omoĩ uka íxupe preso. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ha hembireko katu ndija'éi voi João-rehe. Ojuka-ta mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ndikatúi ojuka, omboete-gwi íxupe mburuvixagwasu Herodes. Ha mburuvixa katu oheko kwaa voi íxupe. “Hi'arandu va'e João, heko marangatu va'e voi ave” he'i hese. Upéa-gwi omoĩngatu joty íxupe. Ohendu ramo inhe'ẽ, ojapose vérami mo'ã inhe'ẽ. Ha ndojaposéi ave. Ndojapói ramo jepe, ogwerohory joty inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hi'áry ogwahẽ ojuka hagwã íxupe. Oiko hagwe áry-py mburuvixagwasu omongaru porã imboviapyre. Mburuvixa kwéry, soldado ruvixa kwéry, imba'e reta va'e kwéry, Galiléia pygwa va'e omongaru porã. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ojekaru ha-py oike-vy ojeroky hembireko memby kunha. Ombovy'a ojeroky ramo mburuvixagwasu Herodes-pe, imboviapyre ave ombovy'a. Ha upéi he'i kunhataĩ-pe mburuvixagwasu: —Ejerure xe-vy ne remimbota-rehe. Oime ra'ẽ va'e voi ame'ẽ-ta nde-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","—Oime ra'ẽ va'e-rehe erejerure ramo, ame'ẽ-ta nde-vy, he'i íxupe. Pono oapu-gwi —Tupã réry-py ame'ẽ-ta nde-vy, he'i. —Ha opamba'e xe areko va'e katu amombyte-ta nde-vy ime'ẽ-vy, he'i jevy jevy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Upéi osẽ oho-vy oporandu osy-pe: —Mbava'e-rehe tipo xe ajerure-ta, he'i omombe'u-vy osy-pe. Isy he'i íxupe: —Ejerure katu João Batista akãgwe-rehe, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ojapura oike hagwã jevy mburuvixagwasu oĩ ha-py. Pya'e oike ojerure-vy: —Ãy aipota eremboyru xe-vy pya'e nha'ẽ-py João akãgwe araha hagwã, he'i ojerure-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ha mburuvixagwasu katu onhe'ẽgwe omboasy eterei. “Tupã réry-py ame'ẽ-ta” he'i-gwi, ohendu-gwi ave imboviapyre inhe'ẽ, ndikatuvéi-ma João-rehe hakate'ỹ. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Upe-ma ramo omondo peteĩ gwembigwái soldado ogweruruka hagwã íxupe inhakãgwe. Ha oho onhakã'o João-pe onhemoĩ va'e preso haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ogweru nha'ẽ-py inhakãgwe ome'ẽ kunhataĩ-pe. Ha kunhataĩ katu ome'ẽ osy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ha João remimbo'ekwe ohendu ramo, ou hetekwe ogweraha. Omoĩ yvykwa-py hetekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ha hemimondo kwéry katu ou jevy Hesu ha-py. Omombe'u íxupe ojapo japo va'ekwe. Ombo'e mbo'e va'ekwe ou jevy omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ha heta ipohuha ou. Opohupáry-gwi ndikatuvéi okaru. Upéa-gwi he'i gwemimbo'e kwéry-pe: —Jaha katu nhane anho ojeiko e'ỹ ha-py. Japytu'u mixĩ-vy jaha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Akói ramo oho ha'e kwéry anho ojeiko e'ỹ ha-py. Kanoagwasu-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ha heta kente ohexa íxupe iho ramo. Oikwaa-ma ave. Upe ramo enterove tetã-gwi osẽ oho-vy. Yvy-rupi oripara oho-vy. Ha'e kwéry ranhe ogwahẽ y rovái. Ha Hesu nogwahẽi joty. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ogwahẽ ramo hembe'y-py, osẽ kanóa-gwi. —Heta ojohapypa ra'e onhomboaty, he'i hexa-vy. —Upéa ovexa ijáry e'ỹ va'e-rami ndoiko kwaáiry ha'e kwéry anho, he'i. —Ndaherekwáiry, he'i. Upéa-gwi oiporiahuvereko-ma íxupe kwéry. Oiporiahuvereko-gwi heta onhemonhe'ẽ nhe'ẽ íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ka'aru ete ou Hesu ha-py hemimbo'e kwéry: —Ndaipóri mba'eve a-py, he'i. —Ka'aru ete-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ere íxupe kwéry toho tetã mirĩ-rupi tetãgwasu-rupi ave ojogwa hagwã gwemi'urã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ha Hesu katu he'i gwemimbo'e kwéry-pe: —Peẽ katu peme'ẽ íxupe kwéry hemi'urã, he'i. —Oroho-ta tipo orojogwa duzentos repy mbojape hemi'urã kwéry orome'ẽ hagwã íxupe kwéry ho'u hagwã, he'i íxupe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Hesu he'i: —Mbovy a-py erereko mbojape? Ekwa terehexa, he'i íxupe. Upe rire oho ohexa. Oikwaa rire, ou omombe'u: —Cinco mbojape oĩ, he'i. —Mokõi pira ka'ẽ ave oĩ, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ha upéi katu he'i ojogweroaty mirĩ mirĩ hagwã ogwapy-vy. Kapi'i pyahu ári ogwapy hagwã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ha cem oĩ va'e, cinqüenta oĩ va'e ave ojoypy ypy-py ogwapy. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ha Hesu katu oipyhy upe cinco mbojape. Mokõi pira ave oipyhy. Upéi hovayva yvate-koty omboete-vy temi'urã-rehe. Otima porã ave. Omboja'o ja'o upe mbojape. Ome'ẽ me'ẽ gwemimbo'e kwéry-pe ombogwejy hagwã entéro va'e rovagwy-py. Omboja'o ja'o ave mokõi pira enterovéa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ha enterovete okaru. Hygwyatãmba-ma ave hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Upéi omono'õ ho'u va'ekwe rembyre, pira rembyre ave. Doze ajaka joty ra'e oĩ hembyre kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Upe okaru va'ekwe heta oĩ ra'e. Kwimba'e kwéry okaru va'e cinco mil oĩ ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Upe ramo Hesu he'i: —Eike katu kanoagwasu-py, he'i gwemimbo'e kwéry-pe. —Pekwa mani katu y rovái xe renonde, he'i. —Betsaida-py ekwa mani katu, he'i. Oho rire, he'i ojogweroaty va'e-pe: —Tapeho katu pende ro nde róga-rupi, he'i Hesu íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Upe rire, “Aha jevy-tama” he'i rire íxupe kwéry, oho yvyaty ári-rupi Hesu. Onhomongeta hagwã Nhandejáry ndive oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ojekwaa-ma pytũ ou-vy. Oĩ kanoagwasu y mbyte-py y ári ave. Ha Hesu katu opyta ha'e anho yvy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ohexa íxupe kwéry onhemombaraete ramo oipykúi-vy. Ndogwatavéi kanóa henonde-gwi ou ramo yvytu. Hembipe ramo Hesu oho gwemimbo'e kwéry ha-py. Pytũ joty reheve oho íxupe kwéry ogwata-vy y ári. Ohenonde'a-ta mo'ã kanóa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ha ha'e kwéry katu ohexa ramo íxupe ogwata y ári, —Arygwypóry, he'i mo'ã hese. Osapukái ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Enterovéa hemimbo'e kwéry ohexa íxupe. Onhemondýi eterei-ma ave. Upéa-gwi osapukái joa. Upe ramo pya'e he'i íxupe kwéry: —Anive erejapura teĩ. Xe ko Hesu, he'i voi. —Ani erekyhyje teĩ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Upéi katu oike-ma kanoagwasu-py hendive kwéry. Ndayvytuvéi-ma. —Mba'éixa omombyta yvytu? he'i opondera eterei-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ha Hesu ombopopóy ramo mbojape hexapyrã-rupi, ndoikwaáiry heko-rehe. Nainhakã porãi-gwi ndoikwaáiry heko-rehe hikwái. Upéa-gwi, —Mba'éixa omombyta yvytu? he'i opondera eterei-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Upéi katu oho yugwarusu rovái. Genezaré tetã-my ogwahẽ oho-vy hikwái. Isã-py onhapytĩ kanóa. Osẽ kanóa-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Osẽ jave, pya'e oikwaa Hesu-pe tetã mygwa. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Oripara oho-vy hikwái opa-rupi. Pe tetã kupe-rupi oripara para okwa-vy. Ha hasy va'e-pe katu ogweru Hesu ha-py. Hupa reheve ogweru. Ohendu-ma ramo Hesu oĩ ha-py ogweru-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ha Hesu katu ogwahẽ ramo tetãgwasu-py, ogwahẽ ramo tetã nhepyrũ-py, ogwahẽ ramo ave tetã mirĩ-my, óga pa'ũ-rupi ombogwejy meme hasy va'e-pe hikwái. Ojerure íxupe: —Tande pyhy nde ao rembe'y-rehe jepe hasy va'e, he'i íxupe hikwái oipyhy va'e gwive okwera-ma hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ha fariseu kwéry ojogweroaty Hesu ha-py. Ogwahẽ ave ou-vy judeu kwéry rekombo'ehaty. Jerusalém tetã-gwi ou va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","“Ndajajepohéi porãi ramo ndikatúi jakaru”, he'i va'e fariseu kwéry, opa judeu kwéry gwive ave. Ojepohe pohéi e'ỹ reheve ndokarúi va'e ojapo-gwi hembypy he'i va'ekwe. Ou jevy ramo mba'e jogwa haty-gwi nonhemopotĩry ramo ndokarúi. Ojohéi kopo'i, ojohéi japepo, ojohéi nha'ẽ kwarepoti-gwi ojejapopyre. Hupa ojohéi ave. Heta mba'e ojapo hembypy he'i va'ekwe ohendu-gwi. Ha gwĩ fariseu kwéry, judeu rekombo'ehaty ave ohexa Hesu remimbo'e kwéry-pe okaru ramo ojepohéi e'ỹ reheve. Upéa he'ise: Ojepohe pohéi rei e'ỹ reheve okaru. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Upéa-gwi oporandu Hesu-pe hikwái: —Ma'erã tipo ndoikói yma gware reko-rupi ne remimbo'e kwéry? Ma'erã okaru ojepohéi porã e'ỹ reheve? he'i. —Ma'erã tipo nonhemopotĩsevéiry nhande kwéry e'ỹ va'e ndive oiko rire? he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ha Hesu he'i íxupe kwéry: —Peẽ katu pende py'a ky'a pemo'ã kwaa va'e. Ha Isaías amyrĩ anheiha-rupi omombe'u va'ekwe pende rekorã. Omoĩ va'ekwe kwatia-rehe a-rami: “Ha'e kwéry xe mboete onhe'ẽ-py rei. Opy'apy-py katu naxe mboetéiry. Ndojehesa rerovái xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xe momba'egwasu teĩ. Xe nhe'ẽ-py nombo'éiry. Ha teko rei nhe'ẽ-py ae oporombo'e mbo'e oiko-vy”, he'i Nhandejáry kwatia nhe'ẽ pende-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ha Nhandejáry he'i ramo, nderejaposéi voi inhe'ẽ. Ha teko rei katu omanda ramo, he'i va'e gwive erejapo japo voi, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","—Nderejaposéi voi Nhandejáry he'i va'ekwe jajapo hagwã nhane rembypy he'i va'ekwe. Upéixa ramo, “Ore rembiapo porã” ere mo'ã ndéjehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ha Moisés amyrĩ he'i va'ekwe: “Pemboete nde ru, nde sy-pe ave. Ha entéro onhe'ẽ vai rei va'e gwu-rehe, osy-rehe ave, tojejuka katu”, he'i Nhandejáry kwatia nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ha peẽ katu pepyrũ Nhandejáry nhe'ẽ-rehe. Ndapehejáiry gwu osy-pe ome'ẽ hagwã. Pembo'e mbo'e rei judeu kwéry-pe a-rami. Peje, “Ava he'i ramo gwu osy-pe ave, Voive ereporandu ramo ame'ẽ arã nde-vy ra'e. Ãy katu ndikatuvéi-ma ame'ẽ nde-vy. Xe mba'e kwéry opa-ma. Ame'ẽmba-ma kuri Tupã Nhandejáry-pe. Aiporu jepe xe, Tupã mba'epa-ma, he'i gwu osy-pe ave.” ");
INSERT INTO kgkNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Upéixa he'i ramo, iporã joty peẽ-my. Upéixa ndapehejái oipytygwõ gwu osy-pe ave. Ne nhe'ẽ-py gwu osy-pe ave nomboetevéi. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ne rembypy reko-rupi joty peiko. Upéa-gwi pepyrũ joty Nhandejáry nhe'ẽ-rehe, pemboyke joty Nhandejáry nhe'ẽ peiko-vy. Heta gwĩa-rami erejapo japo ave, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Upe rire ohenói jevy oha-py kente kwéry ou hagwã he'i: —Pejeapysaka joa xe nhe'ẽ-rehe peikwaa porã hagwã, he'i arandu rehegwa nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","—Jakaru jave ndikatúi nhane mongy'a. Ndoikói tembi'u nhande py'a omongy'a va'erã. Ha nhane nhe'ẽ vai ramo ae katu onhemongy'a arã nhande py'a. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Pene arandu-ta ramo, pejeapysaka katu ko xe nhe'ẽ-rehe, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Upéi oheja íxupe kwéry Hesu. Oho oike koty-py. Oike rire, oporandu íxupe hemimbo'e kwéry. He'i: —Tembi'u rehegwa nhe'ẽ ereiporu kuri. Ha upéa, mbava'e-rehe tipo aipo va'e he'ise, he'i oporandu-vy íxupe hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ha Hesu he'i íxupe kwéry: —Peẽ katu kente kwéry-rami ave ndapeikwaa porãi joty. Ma'erã tipo ndapeikwaa porãi? Pekaru ramo, ndikatúi penhembohete ky'a. Ndaipóri tembi'u pene mbopy'a ky'a va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tembi'u katu pende py'a-rehe ndohói. Pende ryekwe-py ae oho. Upéi osẽmba jevy. Upéa-gwi napene mongy'áiry, he'i íxupe kwéry Hesu. —Upéixa jaikwaa entéro tembi'u ipotĩ voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Upéa-rehe he'i jevy íxupe kwéry Hesu: —Ha pene nhe'ẽ vai ramo katu, onhemongy'a arã pende py'a, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","—Pende py'apy-py katu penhemongeta peiko-vy pene rembiapo vairã-rehe. Upéa-gwi pende py'a vai. Pende py'a vai-gwi pejogwereko rei. Pende py'a vai-gwi pemonda rei peiko-vy, peporojuka ave. Pende py'a ky'a-gwi onhoembireko ndive, onhome ndive ave peiko. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pende py'a vai-gwi peipota rei pende rapixa mba'e, ha pene rembiapo vai, ha peporombotavy, ha pene akã vai, napende a'éi pende rapixa-rehe, penhe'ẽ rei rei pende rapixa-rehe, ha penhembotuvixaseve mo'ã ave peiko-vy, ha napene nhe'ẽ rendúi ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ha opaixagwa pejapo pende py'a vai-gwi. Upéixa ramo pende py'a vai-gwi penhemongy'a-ma, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Upéi opu'ã oho-vy Hesu. Upe-gwi oho ogweroajere Tiro tetã jerekwe-rupi. Sidom tetã jerekwe-rupi oho ave. Oike koty-py opyta hagwã. Ndoipotái mo'ã onhemombe'u. Ha ndikatúi onhemi. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ha peteĩ kunha pya'e ohendu herakwã. Ou ojeity Hesu rovagwy-py. Ha imemby kunha mixĩ va'e anháy rerekoha voi. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ha kunha katu onhe'ẽ outro nhe'ẽ-py. Grego nhe'ẽ-py onhe'ẽ. He'ýi Sirofenícia pygwa. Ojerure Hesu-pe: —Emosẽ katu imondo-vy xe memby-gwi anháy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","—Nde ko ndaha'éi xe re'ýi. Xe re'ýi kwéry aipytygwõ ranhe-ta. Ha upe rire katu xe re'ýi e'ỹ-pe aipytygwõ-ta ave, he'i. —Mitãgwe-pe katu nhamongaru ranhe. Nanhamombói jagwa-pe mitã remi'urã, he'i joty Hesu itantea-vy, ojeheko rerovia uka etese-vy kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ha kunha katu he'i íxupe: —Akói-ramima ngatu, xe Járy, he'i kunha Hesu-pe. —Ha tembi'u sururukwe ijáry apyka gwy-py ho'u joty jagwa, he'i Hesu-rehe ojerovia joty-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Ere porã-ma, he'i. —Ekwa jevy katu. Ne memby-gwi opoi-ma anháy, he'i kunha-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ha upéi oho gwóga-py. Ohexa omemby hupa-py. Onheno oĩ-vy ramo ohexa. Ha anháy osẽ-ma ra'e íxugwi oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ha upéi katu ojevy Hesu Tiro tetã jerekwe-gwi. Sidom-rupi ohasa oho-vy. Ohasa oho-vy ave Decápolis tetã-rupi. Galiléia yugwarusu-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ha upe pygwa ogweru Hesu-pe ndaijapysa porãi va'e. Ha'e inhe'ẽngopa va'e ave. Inhapekũ ratã va'e-rami oiko. Ojerure íxupe omoĩ hagwã hi'ári opo. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ha Hesu ogwenohẽ íxupe. Ojogweroaty ha-gwi ogweraha íxupe ha'e anho. Ijapysaka-py okwã omopo'ẽ. Upéi ondyvu okwã-rehe Hesu. Upe rire omoĩ inhapekũ apy-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Upe rire hovayva yvate-koty. Onhe'ẽ va'erã-rami ipytuhẽ hatã: —Efatá, he'i ha'e ae onhe'ẽ-py. Upe va'e he'ise: “Tojepe'a nde apysa mbotyha”. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ha upéi katu ikwa-ma ijapysa. Nainhapekũ ratãvéiry ave. Nainhe'ẽngopavéi-ma ave. Onhe'ẽ porã-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Upéi Hesu he'i íxupe kwéry omombe'u e'ỹ hagwã avave-pe: —Ani xe mombe'u teĩ, he'i jevy jevy mo'ã íxupe kwéry. He'iri iri íxupe Hesu ramo, ha'e kwéry katu omombe'uve uve joty. Ndogwereko nhemíry Hesu ombogwera hagwe. Nogwenotĩry Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ha henduháry gwive he'i: —Hembiapo porã e'ỹ va'e ndoikóiry. Hembiapo porã porã meme ae katu Hesu. Ijapysa e'ỹ va'e omboapysa jevy va'e. Ha nonhe'ẽi va'e omonhe'ẽ porã jevy va'e Hesu, he'i ojóupe hikwái opondera eterei-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Upe ramo heta ojogweroaty jevy ramo, ndogwerekói ramo gwemi'urã, ohenói Hesu gwemimbo'e kwéry-pe ou jevy hagwã íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Peju katu xe ha-py, he'i. —Ojogweroaty va'e iporiahu va'e xe-vy. Mbohapy áry xe mokambara okwa-vy. Ndogwerekói ave gwemi'urã. Upéa-gwi aiporiahuvereko íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Oĩ mombyry-gwi ou va'ekwe. Amondo ramo íxupe kwéry hóga-py ivare'a ramo, naipyatãvéi arã tape-rupi, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Upe ramo hemimbo'e kwéry he'i íxupe: —Mba'éixa tamo ra'e nhahembi'u me'ẽ ko'a rupigwa kente kwéry-pe? A-rupi ndaipóri kente tembi'u me'ẽharã, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—Mbovy tipo erereko mbojape, he'i oporandu-vy gwemimbo'e-pe: —Sete voi areko, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ha Hesu katu he'i ojogweroaty va'e-pe ogwapy hagwã yvy-py: —Pegwapy katu, he'i íxupe kwéry. Upe rire oipyhy upe sete mbojape. Otima Nhandejáry-pe. Otima rire ombopopóy ome'ẽ gwemimbo'e kwéry-pe. Ojogweroaty va'e rovagwy-rupi omoĩ hagwã ome'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ha pira'i ka'ẽ ndogwereko hetái hikwái. Ha Hesu omboete ranhe Nhandejáry-pe pira ho'u va'erã-rehe. Upe rire omoĩ uka ave hovagwy-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Upe rire ho'u-ma omohygwyatãmba porã ave íxupe kwéry. Upéi omboaty hembyre opyta va'e omboyru sete ajakagwasu. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ha heta eterei okaru va'e. Irundy mil para'e okaru va'e. Ha upéi he'i: —Tapeho katu pende ro nde róga-rupi, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Upe ramo pya'e oike kanoagwasu-py gwemimbo'e kwéry ndive oho hagwã. Dalmanuta jerekwe-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ha fariseu kwéry ou Hesu oĩ ha-py onhonhe'ẽ mbojevy jevy hagwã: —Ejapo katu ore-vy hexapyrã-rupi. Nhandejáry rembiapo porã ramigwa ejapo katu ore mbojerovia uka porã-vy, he'i Hesu-pe. Ombovyte íxupe ombojejavyse-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ha Hesu ndojohu porãi-gwi, opy'apy-py onhe'ẽ va'erã-rami ipytuhẽ hatã: —Ma'erã ãygwa ohexase hexapyrã-rupi xe rembiapo ramo. Anhete ko xe ha'e-ta peẽ-my. Ãygwa-pe katu naxe rembiapo mo'ãi hexapyrã-rupi, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Upéi oheja oho-vy íxupe kwéry. Oike jevy ramo kanoagwasu-py oho yugwarusu rovái. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ha hemimbo'e naimandu'avéi-gwi ndogwerahái mbojape. Peteĩmi ogweraha hendive. Peteĩ anho mbojape oĩ kanóa-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","He'i Hesu gwemimbo'e kwéry-pe: —Ivai voi mbojape mbovuha fariseu kwéry, Herodes irũ kwéry rembiporu, he'i íxupe kwéry Hesu omombe'u-vy, pono judeu ruvixa ohekombo'e vai íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ha mbava'e-rehe po he'ise upéa ndoikwaái voi. Upéa-gwi onhomongeta okwa-vy: —Ma'erã po omombe'u upéixa Hesu. Nanhane mbojapéi-gwi omombe'u upéixa, he'i mo'ã ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ha Hesu katu oikwaa onhomongeta ramo. Upéa-gwi he'i gwemimbo'e kwéry-pe: —Ma'erã pemombe'u mbojape pereko e'ỹha? Ma'erã, “Nanhane mbojapevéi” peje pemombe'u-vy? he'i. —Ma'erã tipo ndapehexa kwaavéi-ma xe-rehe? he'i. —Ma'erã tipo ndapeikwaavéi-ma xe reko? Napene akã porãi vyteri, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","—Oĩ pende resa. Ma'erã tipo ndapehexavéi-ma? Oĩ pende apysa. Ma'erã tipo napehenduvéi-ma? Ma'erã tipo napene mandu'avéi-ma? ");
INSERT INTO kgkNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xe ambopopóy kuri heta eta va'e-pe, cinco mil va'e-pe upe cinco mbojape. Ambopopóy rire, mbovy ajakagwasu-py eremboyru hembyrekwe? he'i íxupe kwéry oporandu-vy. —Doze ajaka, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Aje'i-ma ambopopóy ave kuri upe sete mbojape ame'ẽ hagwã irundy mil va'e-pe. Ambopopóy rire, mbovy ajaka-py eremboyru hembyrekwe? he'i íxupe kwéry oporandu-vy. —Sete ajaka, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Ndereikwaái joty? Ma'erã ndereikwaái? he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ha upéi katu ogwahẽmba-ma Hesu gwemimbo'e kwéry ndive. Betsaida tetã-my ogwahẽ. Ha ojereru Hesu ha-py hesa e'ỹ va'e-pe. Ojerure íxupe opoko hagwã hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ha Hesu katu oipopyhy ogweraha hesa e'ỹ va'e. Tetã avyte-gwi ogweraha. Onygwõ rire hesa-py, omoĩ hi'ári opo: —Erehexa-ma tipo? he'i íxupe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","—Ahexa-ma katu tekove-pe. Havẽ havẽ rei ahexa-vy, he'i. —Yvyra vyra-rami rei ahexa íxupe. Ogwata oĩ-vy ramo ahexa íxupe, he'i íxupe hovayva-vy hesa havẽ-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Upéi omoĩ jevy Hesu hesa ári opo. Ha upéi ohexa katu oĩ-vy. Hesapyso jevy-ma. Ndahesa tatatĩvéiry. Ohexa porãmba-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","—Tereho nde róga-py, he'i. —Ani ereike jevy te'ýi avyte-py, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ohasa jevy oho Hesu gwemimbo'e kwéry ndive. Cesaréia de Filipe jerekwe rupigwa tetã mirĩ mirĩ-rupi oho. Oho jave oporandu gwemimbo'e kwéry-pe: —Mbava'e he'i ra'e xe-rehe? he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ha'e kwéry he'i: —Nane mombe'u porãiry. Ne mombe'u joavy avy. Oĩ, “João Batista onhemoingove jevy va'ekwe ra'e” he'i va'e mo'ã nde-rehe. Oĩ, “Elias onhemoingove jevy va'ekwe ra'e” he'i va'e mo'ã ave nde-rehe. Oĩ, “Nhandejáry nhe'ẽ-py omombe'u va'ety onhemoingove jevy va'ekwe Hesu” he'i va'e mo'ã nde-rehe, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Upéi Hesu he'i: —Mbava'e ere xe-rehe? he'i íxupe kwéry oporandu-vy. —Nde Cristo voi, Nhandejáry rembiporavokwe. Enterove remiha'arõ voi ko nde, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Xáke ne nhe'ẽ ohendupa va'erã, he'i. —Ani xe mombe'u mbe'u teĩ avave-pe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Upe rire omombe'u-ma íxupe kwéry Hesu ojéupe ojehu-ta va'e: —Xe Nhande Ryke'y tee va'e voi, he'i. —Xe áry oma'emboypy hagwe-py heta-ma xe ahasa asy-ta. Xe mbojevy-ta, xe juka uka-ta ave judeu ruvixa kwéry, pa'i ruvixa kwéry, judeu rekombo'ehaty kwéry ave. Mbohapy áry rire katu aikove jevy-ma va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ohendupa hagwã-rami upéa he'i íxupe kwéry. Ha Pedro katu ogwenohẽ-ma Hesu-pe ha'e anho hakate'ỹ-gwi. —Aníke erenhe'ẽ teĩ upéixa, he'i inhe'ẽ joko-vy íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ha Hesu katu ojere ohexa gwemimbo'e kwéry. —Ani xe nhe'ẽ joko teĩ, he'i Pedro-pe. —Ejei xe ypy-gwi, he'i Satanás-py ohenói-vy íxupe. —Neremombe'úi voi Nhandejáry nhe'ẽ. Anháy ruvixa nhe'ẽ-py ae eremombe'u voi, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Upéi ohenói Hesu ou hagwã oha-py ojogweroaty va'e-pe. Gwemimbo'e kwéry-pe ave ohenói: —Peẽ xe moirũse ramo, anive pejapo rei teĩ pejapose va'e anho mante. Anive pepena teĩ pende rekove-rehe. Xe moirũ ae katu peẽ. Okurusugwasu ohupi heraha-vy va'e-rami ijukapyrã-rami ae katu peiko, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","—Ha gwekove-rehe hakate'ỹ va'e katu, ndoikove mo'ãi Nhandejáry ndive. Ha xe-rehe ha-py gwekove-rehe nopenái va'e, Nhandejáry rehegwa nhe'ẽ porã-rehe ha-py gwekove-rehe nopenái va'e ave, oikove meme va'erã Nhandejáry ndive, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","—Nde para'e ko yvy apy gwive járy ramo ereiko va'erã. Ha Nhandejáry ndive ereiko e'ỹ ramo katu mba'evete ndererekói va'erã. Opa ete-ma va'erã. Oipe'apa va'erã ndéhegwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nhandejáry ndive ereiko e'ỹ ramo, nande reko repyvéi-ma va'erã. Eremano rei va'erã. Ndererekói ereme'ẽ va'erã Nhandejáry-pe erejehepy hagwã. Eremano joty va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","—Ha ãygwa katu Nhandejáry-pe nomboetéi va'e, hekoha vai va'e ave. Upéa-rupi, “Ndaikwaái íxupe” peje ramo xe-rehe, xe nhe'ẽ napehenduséi ramo ave, xe, Nhande Ryke'y tee va'e, napena pena mo'ãi ave pende-rehe. Xe amano rire aju jevy ramo xe Ru rendy-rupi, hembigwái marangatu reheve, napena pena mo'ãi pende-rehe agwahẽ ramo, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ha Hesu katu he'i ondive oĩ va'e-pe: —Anhete ko xe ha'e-ta peẽ-my, he'i. —Pene pa'ũ-my oĩ ohexa va'erã Nhandejáry gwuvixarã-pe. Ombaraete reheve oiko ramo, ohexa va'erã. Ohexa e'ỹ reheve nomano mo'ãi. Ohexa rire mate, omano va'erã, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis áry rire, mbohapy ogweraha gwupive Hesu. Pedro, Tiago, João-pe ogweraha. Ogwerojeupi heraha-vy yvyatyrusu-rehe ha'e kwéry anho. Upe-py ha'e kwéry hovagwy-rupi ojehete rekoviarõ-ma Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Overapa ijao hendy-vy. Hesakã ete ipotĩ-gwi. Imorotĩ ete ijao. Upéixa omomorotĩ rei ijohéi hagwã, ndikatúi ko yvy-rehe oiko va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ha upéi mokõi ojekwaa íxupe kwéry. Moisés ndive ojekwaa Elias. Onhomongeta oĩ-vy Hesu ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ha Pedro katu he'i Hesu-pe: —Iporã nhande nhaime a-py, mbo'eháry, he'i Pedro íxupe, —Torojapo mbohapy tapýi, peteĩ nde-vy gwarã, peteĩ Moisés pegwarã, peteĩ Elias pegwarã ave, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Upéixa he'i ndoikwaái-gwi onhe'ẽrã, ikyhyje eterei-gwi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Upe rire omo'ãy-ma íxupe kwéry arai. Ohendu-ma arai-gwi onhe'ẽ va'e íxupe kwéry: —Upe va'e xe ra'y, he'i. —Xe rembihayhu va'e voi, he'i. —Ejeapysaka katu inhe'ẽ-rehe, he'i íxupe onhe'ẽ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Onhe'ẽmba rire-ma pya'e osareko reko oĩ-vy hemimbo'e. Avave ndohexavéi-ma. Hesu-pe anho mante ohexa gwupive oho ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ogwejy jevy yvyaty ári-gwi. Ogwejy gwejy ou ramo he'i íxupe kwéry Hesu: —Ani eremombe'u avave-pe erehexa va'ekwe, he'i íxupe kwéry. —Xe Nhande Ryke'y tee va'e, aikove jevy rire ae, emombe'u katu, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Upéa-gwi avave-pe nomombe'úi hembiexakwe. He'i ojóupe: —“Xe aikove jevy-ta” he'i ramo Hesu, mbava'e-pe po he'i Hesu? he'i oporandu randu-vy ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ha upéi katu oporandu íxupe hikwái: —Ma'erã, “Tou ranhe Elias” he'i judeu rekombo'ehaty, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—Ou ranhe voi Elias omoatyrõmba hagwã. Omoatyrõmba ramo jepe, omoĩ joty va'ekwe kwatia-rehe xe mbohasa asy va'e rehegwa nhe'ẽ. “Nhande Ryke'y tee va'e-pe ombohasa asy va'erã, ombojevy ave va'erã íxupe” he'i joty xe-rehe omoĩ-vy kwatia-rehe. Peikwaa tipo upe va'e nhe'ẽ? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","—Ha Elias katu ou ra'e. Ou voi kuri, ha'e-ta nde-vy. Ojapose va'e ojapo hese. Yma he'i hagwe-rami, ãy ojapo-ma hese, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ha upéi katu Hesu ogwahẽ jevy ou-vy gwemimbo'e kwéry renda-py. Ogwahẽ jevy ramo ohexa heta reheve ojogweroaty aty ramo hikwái. Heta oĩ kente kwéry ijerekwe-rehe. Imbyte-py oĩ Hesu remimbo'e kwéry. Hendive onhomongeta hatã hatã oiko-vy judeu rekombo'ehaty. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Upe ramo, osareko-ma Hesu-rehe hikwái. Hesu rexa-vy, “Mba'éixa ogwahẽ?” he'i opondera eterei-vy hese hikwái. Ndouitaha-gwi, ogwahẽ ou-vy. Ohexa ramo íxupe, oriparapa oje'ói-vy Hesu renda-py ohogwaitĩ hagwã íxupe. Ogwerohory-ma íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—Mbava'e-rehe tipo penhomongeta hatã hatã ra'e peiko-vy? he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ha ojogweroaty va'e avyte-gwi peteĩ va'e omombe'u: —Xe ra'y-rehe katu ojepota kuri anháy. Xe ra'y nonhe'ẽve ẽvéi-ma oĩ-vy anháy ojepota-gwi hese, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","—Aru mo'ã kuri nde ha-py erembogwera hagwã, xe Járy. Ha ndorotopái, he'i. —Ha ogwahẽ ha-py íxupe anháy, oity íxupe imondo-vy. Ijuruyjúi, onhemohãingyrýu, onhembohete hatã ave. Ajerure mo'ã ne remimbo'e kwéry-pe omosẽ hagwã imondo-vy íxugwi anháy. Ha ndikatúi omosẽ, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Upéi he'i Hesu íxupe: —Aỹgwa katu ndojeroviái vyteri xe-rehe. Ndapyta are mo'ãi ne ndive. Ndoroipokwaa are mo'ãvéi-ma. Eru katu íxupe xe ha-py, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ogweru íxupe kunumi hikwái. Ha anháy katu ohexa ramo Hesu-pe, omboheteryrýi-ma mitã kunumi-pe. Ho'a oho-vy yvy-py. Ijapajeréi oiko-vy yvy-rehe ijuruyjúi ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Upéi oporandu túvy-pe Hesu: —Are-ma voi tipo araka'e ojepota hese anháy? he'i íxupe. —Imitã gwive ãy peve ojepota joty hese, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Oity meme voi tata-py. Ojuka hagwã mo'ã y-py ave oity íxupe. Ha nde pu'aka ramo, erejapose va'e erejapo-ta hese, he'i. —Ore poriahuvereko katu ore pytygwõ hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Ma'erã tipo, “Nde pu'aka ramo” ere xe-vy? Ererovia tee ramo, opamba'e-rehe ipu'aka-ta Nhandejáry ojapo-vy nde-vy, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Upe ramo hatã onhe'ẽ mitã ru: —Xe arovia-ma. Ha arovia e'ỹ ramo, xe pytygwõ xe arovia porãve hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ha Hesu katu ohexa kente kwéry oripara joa ogwa'ẽ-vy. Ohexa ramo oja'o-ma anháy-pe: —Erejepota-gwi kunumi-rehe, nonhe'ẽvéi, nohenduvéi. Ha'e-ta nde-vy, Epoi íxugwi. Anive ereju erejepota hese, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ha anháy katu osapukái rire, omboheteryrýi eterei rire íxupe, opoi íxugwi anháy oho-vy. Te'õgwe-rami voi itúi yvy-rupi upe kunumi. Upéa-gwi, —Omano-ma ra'e, heta he'i mo'ã va'e kunumi-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ha Hesu katu oipyhy íxupe ipo-rehe omopu'ã hagwã. Ha opu'ã-ma kunumi. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Oike rire koty-py, oporandu Hesu-pe hemimbo'e kwéry ha'e kwéry anho: —Ma'erã tipo ore ae ndikatúiry oromosẽ imondo-vy anháy-pe, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Koixagwa ndikatúi eremosẽ imondo-vy neremondói ramo Nhandejáry-pe ne nhe'ẽ, he'i. —Ha eremondo ramo ne nhe'ẽ íxupe, erehasa ramo erekaru e'ỹ reheve ave katu, eremosẽ-ta imondo-vy, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Upe-gwi Hesu ohasa jevy oho-vy. Galiléia-rupi ohasa hasa oho-vy. Ohasa ramo, oiko va'erã omombe'u mbe'u oiko-vy gwemimbo'e kwéry-pe. Upéa-gwi ndoipotái Hesu oikwaa hapykwere entéro va'e: —Xe Nhande Ryke'y tee va'e voi. Xe mombe'u-ta voi xe pyhyharã-pe. Teko rei po-py voi xe me'ẽ-ta. Gwĩ xe jukase va'e xe pyhy-ta voi xe reraha-vy, he'i. —Xe juka va'erã hikwái. Ha xe juka rire, mbohapy áry rire, aikove jevy-ma va'erã, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hesu omombe'u porã ramo jepe, ndoikwaái joty inhe'ẽ. —Mbava'e-rehe po he'i nhande-vy, he'i rei hikwái ojóupe. Ikyhyje-gwi, noporanduvéi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Upéi ogwahẽmba-ma Cafarnaum tetã-my. Oime ramo koty-py, oporandu íxupe kwéry Hesu: —Mbava'e-rehe tipo penhomongeta ra'e pejukwe-vy tape-rehe? he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ha'e kwéry katu okirirĩmba ete Hesu-gwi. Ndoikwaái onhe'ẽrã hikwái. “Nhande kwaa-ma” he'i ojéupe hikwái. He'i ra'e hikwái tape-rehe ou-vy: “Kiva'e tipo onhembotuvixave va'erã nhane pa'ũ-gwi” he'i ojóupe. Upéa-gwi okirirĩmba ete íxugwi hikwái. Ndoikwaavéiry rei onhe'ẽrã hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ha Hesu katu ogwapy oikwaa uka íxupe kwéry: —Peju katu a-py, he'i doze oĩ va'e kwéry-pe. —Erenhemboete ukaseve tipo? he'i. —Aipo ramo, enhembohekomirĩve katu, he'i íxupe kwéry. —Enterove va'e rembigwái ramo oiko va'e ramo eiko, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Upéi oipyhy mitã ijavyte-py omoĩ. Upéi oikwavã íxupe, ohupi ojyva ári omoĩ-vy: ");
INSERT INTO kgkNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Eremogwahẽ ramo koixagwa mitã xe réry-py, xe-vy xe mogwahẽha-rami, eremogwahẽ va'erã. Xe mogwahẽ ramo katu, eremogwahẽha-rami ave xe mbouhare-pe, xe mogwahẽ va'erã, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ha João katu he'i íxupe: —Orohexa-ma kuri omosẽ ramo anháy-pe. Omosẽ imondo-vy nde réry-py rei. Ha nanhane mokambarái-gwi, “Ani eremosẽ teĩ Hesu réry-py rei” oro'e kuri íxupe, mbo'eháry, he'i João íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ha Hesu katu he'i: —Ani erejoko teĩ íxupe. Xe réry-py hexapyrã-rupi ojapo va'e ndikatúi onhe'ẽ vai vai xe-rehe. Hembiapo porã rire ndaikatúiry arã onhe'ẽ rei rei xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","—Ha nhane rembiapo ojoko e'ỹ va'e katu, nhane pytygwõ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Anhete voi ko xe ha'e-ta nde-vy. Ha ne mboy'u va'e katu erejerovia-gwi xe-rehe, ombohekovia va'erã voi katu íxupe Nhandejáry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—Pejeapysaka katu xe nhe'ẽ-rehe. Ko mitã-rami oiko va'e, heko'ive va'e, xe-rehe ojerovia va'e ave, oĩ ohesa rerova uka va'erã xéhegwi ombojejavy uka hagwã. Hekoha vai eterei upe oporombojejavy uka va'e. Iporã arã ra'e jajuka hagwã ombo'e vai e'ỹ ngatu. Iporãve arã ra'e nhanhapytĩ hagwã ijaju'y-rehe itagwasu hese nhamoĩ-vy ipohyive hagwã, he'i. —Iporãve arã ra'e nhamombo ygwasu-py ombo'e vai e'ỹ ngatu. Iporãve voi ko ra'e omano ranhe ra'e ombo'e vai e'ỹ ngatu pono xe-rehe ojeroviase va'e-pe ombo'e vaipa rei, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","—Xáke, penhangareko katu pendéjehe. Nde po-gwi para'e erejejavy ramo, enhepokytĩ katu eremombo-vy nde po. Peteĩ nde po e'ỹ va'e rekoha-rami eiko. Iporãve nde posogwe reheve eregwahẽ hagwã ereho-vy Nhandejáry nhande ruvixa ha-py. Ha ne mombo ramo tata opa opa rei e'ỹ va'e-py katu mokõi nde po reheve, ivaive arã nde-vy. Nde poriahu ete va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","—Upe-py ndopái tata. Nomanói te'õgwe'uha. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ha nde py-gwi para'e erejejavy ramo, enhepykytĩ katu eremombo-vy nde py. Peteĩ nde py e'ỹ va'e rekoha-rami, eiko. Iporãve nde pysogwe reheve eremoirũ hagwã Nhandejáry ne ruvixarã-pe. Ha ne mombo ramo tata opa opa rei e'ỹ va'e-py katu mokõi nde py reheve, ivai arã nde-vy. Nde poriahu ete va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Upe-py nomanói te'õgwe'uha. Ndopái tata. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ha nde resa ne mbojejavy ukase ramo, enohẽ katu nde resakwe emombo ndejéhegwi. Peteĩ gwesa ogwenohẽ va'ekwe-rami eiko. Iporãve peteĩ nde resa reheve eregwahẽ ereho-vy Nhandejáry nhande ruvixa oiko haty-py. Ne mombo ramo tata opa opa rei e'ỹ va'e-py mokõi nde resa reheve, ivaive arã nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Upe-py nomanói voi te'õgwe'uha. Ndopái tata. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Enterovéa tata-py ohasa va'erã onhemopotĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","He porã juky. Ha ndahéi ramo katu ndikatúi eremoatyrõ jevy. Aipo ramo ereko katu nde py'apy-py juky ramigwa pono nde poxy onhondive, ne nhe'ẽ piro'y hagwã onhondive, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Upe-gwi osẽ Hesu Judéia tetã tetã-rupi oho-vy. Y Jordão kupe-rupi ave oho. Ha gwĩ kente kwéry ojogweroaty aty joty iha-py hikwái. Ha Hesu katu ojapo memeha-rupi ombo'e mbo'e joty oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ha gwĩ fariseu kwéry katu ogwahẽ ou-vy iha-py ombovyte mo'ã hagwã íxupe. He'i: —Gwĩ omenda va'ekwe opoi rei ramo gwembireko-gwi, oiko joty tipo tekoha-rupi? he'i Hesu-pe oporandu-vy, ombojejavy ukase mo'ã-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Upe ramo Hesu oporandu íxupe kwéry: —Pene mandu'a vyteri pa Moisés amyrĩ he'i va'ekwe-rehe pejapo hagwã? he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Upéi ha'e kwéry he'i Hesu-pe: —Upéa he'i voi va'ekwe Moisés amyrĩ. He'i va'ekwe: “Erepoise ramo ne rembireko-gwi, ehai ranhe kwatia-rehe ereikwaa ukapa hagwã. Upéi eme'ẽ íxupe kwatia erepoi hagwã íxugwi” he'i va'ekwe Moisés amyrĩ, he'i hikwái Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ha Hesu katu he'i íxupe kwéry: —Ha pende py'aratã-gwi napehenduséiry inhe'ẽ. Upéa-gwi Moisés amyrĩ he'i va'ekwe peẽ-my pepoi hagwã pene rembireko-gwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","—Ha ojejapo hagwe áry-py kunha ypy kwimba'e ypy ndive katu gwĩ omoirũ va'ekwe Nhandejáry nde'íry voi va'ekwe opoi poi hagwã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","—Nhandejáry nhe'ẽ he'i a-rami: “Yma ete va'ekwe kwimba'e ypy ndive ojapo-ma ave kunha ypy. Upéa-gwi kwimba'e oheja va'erã gwu osy-pe gwembireko oirũrã-rehe omenda hagwã. Omoirũ teeharã ndive omenda. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mokõi va'e-rami ndoikovéi-ma. Peteĩxa ae onhomoirũ-ma oiko-vy va'erã” he'i Nhandejáry kwatia nhe'ẽ. Nhandejáry kwatia nhe'ẽ he'i hagwe-rami, jaikwaa omenda va'ekwe rekoha. Ndoikovéi ha'e anho rei. Peteĩxa ae hekoha. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Upéa-gwi tomomboi uka e'ỹ katu teko rei Nhandejáry remimbojehe'a, he'i fariseu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ha upéa nhe'ẽ-rehe oporandu jevy íxupe koty-py hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ha he'i íxupe kwéry: —Gwembireko-gwi opoise va'e omenda jevy ramo, ojapo vai voi hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ha kunha oména-gwi opoise va'e omenda jevy ramo, ojapo vai voi ave hese, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Upe ramo ojereru Hesu ha-py mitã opo omoĩ hagwã hese. Ha hemimbo'e kwéry ojoko íxupe kwéry: —Togweru e'ỹ katu mitã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ha Hesu katu ohexa ramo oja'o va'e, ojoko íxupe. —Ani pejoko teĩ mitã ou va'erã, he'i. —Tou katu xe renda-py, he'i joty Hesu. —Ha'e-ta peẽ-my: Koixagwa omoirũ-ma va'erã Nhandejáry gwuvixarã-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","—Anhete ko xe ha'e-ta peẽ-my, he'i. —Erenhemboete ukase rei va'e neremoirũi-ma va'erã Nhandejáry nde ruvixarã-pe. Ha gwĩ heko'ive va'e, mitã-rami onhemboete ukase e'ỹ va'e ae, omoirũ-ma va'erã Nhandejáry gwuvixarã-pe, he'i íxupe kwéry. —Upéa-gwi ani pejoko teĩ mitã ou va'erã, he'i mitã-rehe oikwaa uka-vy kiva'e po omoirũ-ta Nhandejáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Upéi ohupi mitã-me oikwavã ohupi-vy ojyva ári: —Nhandejáry tande rovasa katu, he'i peteĩ teĩ-pe Hesu omoĩ-vy opo hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Osẽ mo'ã oho-vy Hesu. Ha ohogwaitĩ peteĩ kwimba'e íxupe oripara ou-vy. Hovagwy-py onhesũ gwetypy'ã-rehe. Oporandu Hesu-pe: —Nde ko nde reko porã va'e, mbo'eháry. Mba'éixa ajapo-ta xe aikove hagwã Nhandejáry ndive apave'ỹ reheve, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Hesu he'i íxupe. —Ma'erã, “Nde reko porã va'e” ere xe-rehe? he'i oporandu-vy íxupe. —Ndaipóri ojejavy e'ỹ va'e. Nhandejáry ha'e anho mante heko porã ete va'e, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","—Ereikwaa-ma Nhandejáry omombe'u va'ekwe nde rekorã: “Ani ereporojuka teĩ ereiko-vy, ani ereiko teĩ ambue mbue ndive, ani eremonda teĩ, ani nde apu rei teĩ nde rapixa-rehe, ani erembotavy ereraha hagwã nde rapixa rembiereko. Emboete ae katu nde ru nde sy ave”. Upéixa omombe'u va'ekwe Nhandejáry, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Xe mitã ramogware ãy peve upéa nhe'ẽ namokanhýiry areko-vy, mbo'eháry. Ahendu vyteri aiko-vy xe, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ha Hesu oma'ẽ-vy hese, ohayhu voi íxupe: —Peteĩ oĩ va'e nderejapói vyteri, he'i íxupe. —Eraha ranhe terejerure hepy upe erereko va'e-rehe. Upe rire iporiahu va'e kwéry-pe ereme'ẽmba hagwã hepykwe, he'i íxupe. —Hetave oĩ va'erã nde-vy gwarã yváy-py, he'i íxupe. —Ha upe rire katu eju xe moirũ, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Upéa nhe'ẽ ha'e ohendu ramo, ipy'areraha-ma voi oiko-vy. Ndaipy'agwapyvéi-ma. Ndovy'avéi-ma oho-vy heta mba'e ogwereko-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ha Hesu oma'ẽ oĩ-vy gwemimbo'e kwéry-rehe: —Imba'e reta va'e hasy peve omoirũ va'erã Nhandejáry gwuvixarã-pe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ha ojapura hese hikwái. Ha Hesu katu he'i jevy íxupe kwéry: —Xe ra'y kwéry, he'i, —hasy eterei gwĩ imba'e reta-rehe ojerovia va'e omoirũ hagwã Nhandejáry gwuvixarã-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","—Hasy eterei nhambohasa ka'ijugwasu kwa-rupi mymbagwasu camelo, he'i. —Ha hasyve voi gwĩ imba'e reta va'e omoirũ hagwã Nhandejáry nhande ruvixa-pe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ha ha'e kwéry katu onhemondýi eterei-ma hikwái: —Aipo ramo, avave nonheresende mo'ãi arã ra'e. Kiva'e nipo onheresende va'erã? Kiva'e nipo onheresende va'erã? he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ha Hesu oma'ẽ oĩ-vy hese kwéry: —Ojéhegwi rei nonheresendéi arã avave, he'i. —Tupã Nhandejáry ha'e anho mante oĩ ne resendeharã, he'i. —Ha'e opamba'e rereko kwaaha voi, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ha upéi katu he'i íxupe Pedro: —Ha ore katu opamba'e oroheja oromoirũ hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—Anhete ko xe ha'e-ta nde-vy, he'i íxupe Hesu. —Xe-rehe ha-py nde róga pygwa ereheja ramo, ombohekovia va'erã nde-vy ne rembiejare. Xe moirũ hagwã, nde ryke'y ereheja ramo, nde ryvy ereheja ramo, ne reindy ereheja ramo, nde ryke ereheja ramo, nde kypy'ýry ereheja ramo, nde kyvy ereheja ramo, nde sy ereheja ramo, nde ru ereheja ramo, nde ra'y, nde rajy ereheja ramo, ne memby ereheja ramo, nde yvy ereheja ramo ave xe moirũ hagwã, ombohekoviarõ va'erã nde-vy ne rembiejare, he'i íxupe Hesu. —Xe rehegwa nhe'ẽ porã erehendu-gwi ereheja ramo, ombohekoviarõ va'erã nde-vy ne rembiejare. Nde rexakwaa rei jevy va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Hetave ome'ẽ va'erã nde-vy. Peteĩ ereheja rekovía ome'ẽ va'erã nde-vy cem peve, he'i íxupe Hesu. —Ome'ẽ va'erã nde-vy nde rogarã, nde ryke'yrã, nde ryvyrã, ne reindyrã, nde syrã ave. Ne mitãrã ome'ẽ va'erã nde-vy. Nde yvyrã ome'ẽ va'erã nde-vy. Heta nde-vy ome'ẽ ramo jepe, nde rereko asy joty va'erã. Ãy ome'ẽ va'erã nde-vy. Ha upe rire katu ko yvy opa rire-ma, ereikove meme va'erã Nhandejáry ndive erepave'ỹ reheve, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","—Heta oĩ ãy onhemboeteve va'e. Ha upe rire katu ndatuvixa mba'éiry va'erã Nhandejáry-pe. Heta oĩ ãy heko'ive va'e. Ha upe rire katu tuvixa mba'e va'erã Nhandejáry-pe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ha upéi Hesu ogwata oho-vy tapegwasu-rupi. Jerusalém tetã-my ojéupi oho-vy. Gwemimbo'e kwéry renonde-rupi oho. —Ma'erã po oho Jerusalém tetã-my, he'i opondera-vy hese hikwái. Ha hapykwérigwa katu oiko-tagwi ikyhyje hikwái. Upéi ogwenohẽ jevy gwĩ doze gwemimbo'e ha'e kwéry anho omombe'u hagwã ojéupe oiko-ta va'e: ");
INSERT INTO kgkNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Pejeapysaka katu xe nhe'ẽ rehe, he'i. —Jaha jaiko-vy Jerusalém tetã-my. Upe-py xe Nhande Ryke'y tee va'e, xe pyhy va'erã xe me'ẽ hagwã pa'i ruvixa kwéry-pe, judeu rekombo'ehaty-pe ave. Upe-py, “Tomano” he'i va'erã xe-rehe. Upéi xe me'ẽ va'erã xe reraha-vy nhande kwéry e'ỹ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Xe-rehe onhembohory va'erã, onygwõ ave va'erã xe-rehe. Xe mbopi va'erã ave, xe juka va'erã ave. Ha upe rire katu mbohapy áry rire anhemoingove jevy-ma va'erã, he'i gwemimbo'e kwéry-pe anho onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Upéi hi'agwĩ-ma ou Zebedéu ra'y, Tiago João ndive. Hesu ha-py ogwahẽ-ma ou-vy: —Oroipota erejapo ore-vy oime raẽ va'e orojerure va'e nde-vy, mbo'eháry, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—Mba'e pa ereipota xe ajapo nde-vy, he'i gwemimbo'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Nde yke-rehe joja torogwapy erenhemomba'egwasu ramo, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ha Hesu katu he'i íxupe kwéry: —Ndapeikwaái pene rembijerure-rehe xe-vy, he'i. —Xe mbohasa asy hagwã-rami ave, pehasa asy-ta para'e? Ajepy'apy hagwã-rami ave pejepy'apy-ta para'e? he'i oporandu-vy Zebedeu ra'y Tiago João ndive-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Ha'e voi, he'i. —Ne ndive ore orohasa asyse, he'i íxupe. —Néi, he'i, —Xe mbohasa asy hagwã-rami ave, pehasa asy va'erã voi. Ajepy'apy hagwã-rami ave, pejepy'apy va'erã voi, he'i íxupe kwéry mokõigwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","—Ha xe Ru nde'íry apombogwapy hagwã xe yke-rehe joja. Ha'e ae ombogwapyse va'e ae, ombogwapy va'erã xe yke-rehe, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ha hemimbo'e ojerure e'ỹ va'e katu oĩ dez. Ohendu-ma ramo onhembotuvixaseve mo'ã va'e-pe ogwerovy'are'ỹ voi. Tyvýry reheve Tiago-rehe ija'e'ỹ hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ha upéi katu: —Peju a-py, he'i entéro gwemimbo'e kwéry-pe Hesu. —Peikwaa voi judeu e'ỹ kwéry rekoha, Nhandejáry kwaa e'ỹha rekoha. Huvixa kwéry he'iha omanda voi hese oiko-vy. Ipu'aka voi hese gwĩ onhemboete va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Upe va'e rekoha-rupi xe ndaipotái peiko, he'i. —Pende rekorã a-rami. Erenhembotuvixa mba'e ukase ramo, eiko katu nde rapixa rembigwái ramo. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Erenhemboete ukaseve ramo, erejejokwái va'e-rami eiko, he'i. —Nde rerekoseha-rami eiko. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Xe ave Nhande Ryke'y tee va'e jepe ndajúi va'ekwe xe rembigwairã heta ajohu hagwã. Aju ae va'ekwe tembigwái-rami aiko hagwã. Ajejuka uka hagwã aju va'ekwe heta aresende va'erã-rehe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ogwahẽmba Jericó tetã-my. Ohasa oho-vy. Upéi osẽ oho-vy Hesu gwemimbo'e kwéry ndive. Heta ojogweroaty va'e oho ave indive. Osẽ jave ogwapy oĩ-vy tapegwasu rembe'y-py hesapyso e'ỹ va'e. Héry va'e Bartimeu. Ha Bartimeu Timeu ra'y. Omba'e repyrã-rehe ojerure va'evy. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ohendu ramo Hesu Nazaré pygwa ohasa ramo, onhe'ẽ hatã: —Hesu, Davi remiarirõre, xe poriahuvereko katu, he'i onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Heta oĩ va'e inhe'ẽ ojoko: —Ekirirĩ katu, he'i íxupe. Ha Bartimeu katu hatãve tãve joty onhe'ẽ: —Hesu, Davi remiarirõre, xe poriahuvereko katu, he'i onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ha upéi opyta-ma Hesu: —Ehenói katu íxupe tou xe ha-py. Hesu ne renói-ma kuri peje íxupe, he'i. Ha ohenói hesapyso e'ỹ va'e-pe hikwái: —Ani erejapura teĩ. Epu'ã katu. Hesu ne renói, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ha upéi onhenhugwãha omombo opu'ã pya'e oho-vy Hesu ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—Mbava'e tipo ereipota xe ajapo nde-rehe? he'i hesapyso e'ỹ va'e-pe. —Eme'ẽ jevy xe-vy xe resapysorã, mbo'eháry, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Upe-ma ramo Hesu he'i íxupe: —Tereho, he'i. —Xe-rehe erejerovia-gwi, erekwera-ma, he'i íxupe Hesu. Onhe'ẽ jave okwera-ma. Upe rire katu omokambara-ma íxupe tapegwasu-rupi oho jave. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ha Hesu gwemimbo'e kwéry ndive ogwahẽ ogwata oho-vy Jerusalém tetã-my. Hi'agwĩ oĩ ramo jepe íxugwi, nogwahẽi joty upe-py. Upe ramo ogwahẽ ranhe oho-vy Betfagé tetã mirĩ-my. Betânia-py yvyaty Oliveiras ypy-py ogwahẽ ranhe oho-vy. Ogwahẽ rire, omondo mokõi gwemimbo'e gwenonde-rupi: ");
INSERT INTO kgkNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Tapeho katu upe tetã mirĩ-my nhande rovarehéi, he'i. —Ereike-ma ramo eretopa va'erã mburika'i onhenhapytĩ va'e. Ndojeupíry vyteri hi'ári avave. Ejora eru ko'a-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","—“Ma'erã erejapo upéa?” he'i ramo nde-vy upe pygwa, ere íxupe, “Oiporu-ta nhande ruvixa” ere íxupe. “Pya'e ogweruruka jevy-ta” ere íxupe, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ha upéi katu oho otopa onhenhapytĩ ha-py mburika'i. Okẽ rovagwy-py, tape yke-rehe otopa. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ojora ramo mburika, oporandu íxupe mokõi hemimbo'e-pe, upe-py oĩ va'e: —Ma'erã erejapo upéa, he'i Hesu remimbo'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ha Hesu nhe'ẽgwe omombe'u íxupe kwéry. Upéa-rupi oheja ogweraha mburika'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ha upéi katu ogweru Hesu-pe. Omoĩ hi'ári oao. Ha Hesu ojeupi-ma hi'ári. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Heta va'e omboi mboi oao oipyso hagwã Hesu renda opyrũ hagwã-rupi. Oikytĩ kytĩ omoĩ-vy yvy-rupi yvyra rogwe hakã reheve. Yvy-rupi omohasãi imoĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Osapukái joa henonde rupigwa. Hapykwerigwa osapukái ave: —Ereju-ma, he'i imboete-vy. —Iporã ete katu, he'i onhe'ẽ hatã-vy. —Nhandejáry réry-py eregwahẽ-ma ereju-vy. Tande rovasa porã katu Nhandejáry, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","—Upe va'e ou va'e nhande ruvixagwasurã. Upe va'e ou va'e nhane ramoirusu Davi ramigwa voi. Ou ramo, tohovasa íxupe Nhandejáry. Nhandejáry yváy-py oĩ va'e-pe jaha nhamboete, he'i Hesu-rehe onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ha Hesu katu ogwahẽ-ma Jerusalém tetã-my. Nhandejáry-pe nhamboete haty-py óga kakwaa-py oike. Oike-vy osareko reko enterovéa-rehe. Osareko rire, ka'aru ete-ma. Upéa-gwi osẽ oho-vy Betânia-py. Gwemimbo'e kwéry ndive oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ko'ẽ ramo Betânia-gwi ou-vy, ovare'a ogweru Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Mombyry-gwi ohexa figo máta hogwe porã va'e. Oho ohexa: “Hi'a para'e” he'i oho-vy. Ha ogwahẽ ramo, ndahi'áiry íxupe. Hogwe rei oĩ. Ndaipóri figo. Ndaha'éi vyteri hi'aha áry: ");
INSERT INTO kgkNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","—Anive ho'u avave nde a, he'i figo máta-pe. Upéixa omoĩ onhe'ẽ yva máta-pe. Ha ohendu hemimbo'e kwéry inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ha upéi katu ogwahẽ jevy-ma Jerusalém tetã-my hikwái. Ha Hesu oike Nhandejáry róga kakwaa-py. Upe-gwi omosẽmba omba'e jogwa va'e. Oma'evende oĩ va'e ave omosẽ. Upe-py oĩ ave pirapire ombohekovia va'e hepy-rehe. Ombohekoviapa oiporu jevy va'erã-py. Upéa-gwi íxupe kwéry omosẽ imondo-vy. Imba'e renda ombovapy íxugwi kwéry. Ombovapy pykasu járy apyka kwéry ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ndohejái avave ogweraha mba'eve Nhandejáry róga kakwaa roka-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Onhemonhe'ẽ-vy he'i íxupe kwéry: —A-rami omoĩ va'ekwe Nhandejáry kwatia-rehe: “Xe róga xe mboete haty-py héry va'erã onhe'ẽ mondo mondo Nhandejáry-pe haty. Upe-py entéro va'e gwive ombojeupi inhe'ẽ Nhandejáry-pe” he'i. Ha peẽ katu pemoingo a-py gwĩ oporosakea va'e onhemi va'e-rami, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ohendu herakwã pa'i ruvixa kwéry judeu rekombo'ehaty ave. Ohendu ramo, oheka heka ojuka hagwã mo'ã Hesu-pe. Ikyhyje-gwi íxugwi ojukase. Ha enterovéa, “Iporã ete hemimombe'u mbe'u” he'i opondera-vy hese hikwái. Upéa-gwi ikyhyje íxugwi pa'i ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ka'aru ete ramo osẽ-ma Hesu gwemimbo'e kwéry ndive. Tetã-gwi osẽ oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ko'ẽ ramo ohasa jevy. Ohasa ramo, ohexa yva máta ipirupa ra'e hapo gwive. Hokuipa-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ha Pedro katu imandu'a Hesu nhe'ẽgwe-rehe: —Ema'ẽ erehexa hagwã, mbo'eháry, he'i Hesu-pe. —Ipiru-ma ra'e pe yva máta ere va'ekwe-pe, “Anive nde a ho'u avave” ere kuri íxupe. Ne nhe'ẽ pokatu voi nipo ra'e, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Ha upéi katu he'i íxupe kwéry Hesu: —Ejerovia katu Nhandejáry-rehe. Anhete ko xe ha'e-ta nde-vy. Eremoĩ ramo ne nhe'ẽ ko yvyaty-pe, “Ejeupi enheapymi ygwasu-py” oiko-ta nde-vy. Ne nhe'ẽ hagwe-rami oiko-ta. Oiko-ta voi ndererovia ku'a ku'ái ramo nde py'apy-py. Oiko-ta voi nde-vy ererovia tee ramo oikotaha ne nhe'ẽ hagwe-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Upéa-gwi ha'e-ta nde-vy: Oime raẽ va'e-rehe erejerure ramo erenhomongeta-vy Nhandejáry ndive, erovia porã katu íxupe. “Oime ra'e xe-vy gwarã” ere ndejéupe. Ererovia porã ramo, oiko-ta voi nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Erepu'ã ramo erenhomongeta hagwã Nhandejáry ndive, eiporiahuvereko katu nde-vy hembiapo vai va'ekwe, nde poriahuvereko hagwã nde Ru yváy-py oĩ va'e erejejavy va'ekwe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","—Ereiporiahuvereko e'ỹ ramo nde rapixa-pe, nande poriahuvereko mo'ãi nde Ru yváy-py oĩ va'e erejejavy va'ekwe-rehe, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ha upéi katu ogwahẽ jevy Jerusalém tetã-my hikwái. Ha Hesu ogwata jave Nhandejáry róga kakwaa gwy-rupi, ou henda-py pa'i ruvixa kwéry, judeu rekombo'ehaty kwéry, judeu ruvixa kwéry ave: ");
INSERT INTO kgkNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—Kiva'e nhe'ẽ-py tipo ereporombo'e? he'i íxupe. —Kiva'e he'i nde-vy ra'e erejapo hagwã a-rami? he'i oporandu-vy Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—Xe-vy peporanduha-rami ave aporandu-ta peẽ-my xe aikwaase pendéhegwi va'e-rehe, he'i. —Pemombe'u ranhe katu xe-vy peẽ-my aporandu-ta va'e-rehe. Upéi, xe amombe'u-ta ave peẽ-my kiva'e nhe'ẽ-py aporombo'e, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","—Ãy aporandu ranhe-ta peẽ-my. Kiva'e nhe'ẽ-py oporomongarai va'ekwe João Batista amyri? Nhandejáry nhe'ẽ-py para'e? Teko rei nhe'ẽ-py para'e? he'i íxupe kwéry. —Pemombe'u ranhe katu xe-vy, he'i huvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ha ha'e kwéry katu ndoikwaáiry onhe'ẽrã: —Mbava'e ja'e rei-ta po Hesu-pe? he'i ojóupe oporandu randu-vy hikwái. —“Nhandejáry nhe'ẽ-py oporomongarai va'ekwe João” ja'e ramo, “Ma'erã po ndapejeroviái va'ekwe hese?” he'i arã nhande-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ha “Teko rei nhe'ẽ-py oporomongarai va'ekwe João” ja'e ramo katu, nhane mytu'e'ỹ arã nhandéjehe. “Pende apu” he'i arã nhande-vy te'ýi jusu, he'i ojóupe hikwái. —“Nhandejáry nhe'ẽ-py omombe'u va'ety ae katu João” he'i arã. Mbava'e tipo ojapo arã nhande-rehe hikwái? he'i ojóupe huvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Upéa-gwi, —Ndoroikwaáiry, he'i mo'ã Hesu-pe okyhyje-gwi. —Aipo ramo, xe-vy napemombe'uiha-rami ave, kiva'e nhe'ẽ-py aporombo'e a-rami, ndaikwaa uka mo'ãi ave peẽ-my, he'i judeu ruvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ha upéi katu Hesu omombe'u jevy judeu ruvixa kwéry-pe. Arandu rehegwa nhe'ẽ uvaty rehegwa-rami omombe'u: —Oĩ va'ekwe uva onhotỹ va'ekwe. Oho onhotỹ uva ojapo hagwã uvaty. Upéi ogweroajere imboty-vy. Ojo'o itakwa hykwere ryrurã. Omboyvate ojeupi hagwã orepara hagwã. Upéi ijáry oiporuruka omba'apo va'erã-pe. Hi'aju ramo, oipota omboja'o yva ojéupe. Ha upe rire katu oho mombyry. Tetã ambue-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Hi'aju-ma ramo pe yva uva, ombou ivía ramo gwembigwái omboja'o hagwã yva mbyte-rupi heraha-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ha uvaty-py omba'apo va'e katu oipyhy imboupyre-pe oinupã ombojevy rei mba'eve e'ỹ-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Outro jevy ombou ivía ramo, ha'e kwéry katu onhakãrupã onhembosarái hese. Nomboetéiry íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Outrove ombou jevy. Ha'e kwéry katu ojuka íxupe. Heta ou ramo, onhembosarái hese kwéry. Ou va'e oinupã. Oinupã e'ỹ ramo, ojuka. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Peteĩ oikori vyteri ombou va'erã ta'ýry hembiayhu. Ipaha-py ombou íxupe kwéry gwa'ýry peteĩ. “Xe ra'y-pe katu omboete va'erã” he'i mo'ã imbou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ha gwĩ uvaty-py omba'apo va'e katu he'i ojóupe: “Upéa uvaty jaryrã voi” he'i. “Jaha jajuka íxupe. Uvaty-rehe nhanhembojáry va'erã” he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Upéa-gwi oipyhy íxupe ojuka omboyke uvaty-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ha upéi katu oikwaa-ma ramo pe uvaty járy, mba'éixa ojapo-ta hese kwéry? he'i. —Ogwahẽ ou-vy ramo, ojuka-ma va'erã katu gwĩ hembiapo vai va'e-pe. Upéi ohekoviarõ va'erã outro omba'apo jevy va'erã, he'i íxupe kwéry Hesu. Upéixa omombe'u judeu ruvixa kwéry reko uvaty rehegwa-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ha upéi katu he'i jevy judeu ruvixa kwéry-pe: —Pemonhe'ẽ nhe'ẽ teĩ peiko-vy yma gware nhe'ẽ Nhandejáry omoĩ uka va'ekwe kwatia-rehe, ndapeikwaáiry, he'i. —Yma gware nhe'ẽ a-rami: “Ndovaléiry, he'i óga apoha ita-rehe. Ha upe ita katu ojohu vai ramo jepe, ojeporuve joty óga pytahoha ramo. Óga jekoha voi upe ita. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Upéa Nhandejáry rembiapo porã, ja'e. Jahexa-vy, Iporã porã katu, ja'e Nhandejáry rembiapo-rehe” he'i xe-rehe yma gware nhe'ẽ. Ma'erã he'i va'e ndapeikwaáiry ra'e? he'i íxupe kwéry Hesu hekokwe mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ohendu ramo inhe'ẽ, oikwaa pya'e ojehegwa hikwái: —Nhande rehegwa nhe'ẽ kuri omombe'u Hesu, he'i ojóupe. Upéa-gwi upe judeu ruvixa oipyhyse mo'ã íxupe. Ha ndoipyhýi, ikyhyje-gwi. Nombopoxyséi-gwi Hesu ndive heta oĩ va'e-pe, ndoipyhýiry joty íxupe hikwái. Upe rire ohejari jevy oje'ói. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ha upéi katu judeu ruvixa kwéry omonhe'ẽ avyse mo'ã Hesu-pe. Upéa-gwi ombou iha-py fariseu-pe Herodes re'ýi ndive: ");
INSERT INTO kgkNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","—Orohexa kwaa nde reko apu e'ỹha nde-rehe, mbo'eháry. Ne nhe'ẽ ndojohu porãi ramo jepe, eremombe'u joty anhetegwa va'e. Avave-gwi neretĩry eremombe'u-vy. Nhandejáry remimbota eremombe'u voi. Erehexa kwaa voi hekoha enterove-rehe. Upéa-gwi anhei-rupi ne remimombe'u Nhandejáry rape kwaa uka-vy, he'i. —Aipo ramo, iporã para'e nhande, judeu reko-rupi jaiko va'e, japaga nhame'ẽ-vy mburuvixagwasu César-pe hemimbopaga uka? Iporã para'e japaga e'ỹ? he'i. —Iporã para'e nhame'ẽ? Iporã para'e nhame'ẽ e'ỹ? he'i. —Emombe'u ore-vy upéa-rehe oroikwaa hagwã, he'i oity vai ukase-vy íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ha ha'e ohexa kwaa hese hekoha vai: “Omo'ã kwaa voi opy'a ky'aha” he'i ojéupe hese. Upéi he'i judeu ruvixa kwéry-pe: —Ma'erã xe monhe'ẽ avyse? he'i. —Eru xe-vy moeda mburuvixagwasu remimbopaga uka tahexa, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Peteĩ ogweru. Upéi oporandu íxupe kwéry: —Kiva'e ra'anga pa upe va'e moeda? Kiva'e ohai uka va'ekwe moeda-rehe? he'i íxupe kwéry. —César ra'anga. Hembihai uka ave, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Aipo ramo, César-pe imba'e eme'ẽ. Ne mbopaga uka ramo, eme'ẽ jevy íxupe, ijáry-pe. Ha Nhandejáry-pe katu hemimbota eme'ẽ íxupe, he'i huvixa kwéry-pe Hesu. —Hasy va'e-rehe jepe nhaporandu ramo íxupe, omombe'u porã joty, he'i Hesu-rehe opondera-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ha upéi katu ou Hesu renda-py saduceu kwéry, “Nonhemoingove jevýi va'erã gwĩ omano va'ekwe” he'i va'e. Ou oporandu íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Moisés amyrĩ omombe'u va'ekwe nhande-vy nhande rekorã, mbo'eháry. “Tyke'ýry omano ramo, oheja ramo gwembirekokwe naimembýi vyteri ramo, tomenda tyvýry gwovajare-rehe. Upéixa ramo, Ke'y ra'y, he'i mo'ã va'erã imemby ypy-rehe” he'i nhande-vy Moisés. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oĩ va'ekwe peteĩ tyke'ýry, seis tyvýry. Tyke'ýry omenda kunha-rehe. Upéi omano ramo, ndaita'ýry jepéiry. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tyvýry omenda hovajare-rehe. Tyvýry omano ramo, ndaita'ýryi. Upéi tyvýry ambue jevy omenda omano. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Peteĩ teĩ omenda hese gwovajare-rehe. Peteĩ teĩ omano ramo ndaita'ýry jepéi. Omanomba rire, upe kunha omano ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nhane moingove jevy ramo, kiva'e rembirekorã upe kunha? Gwĩ sete tyvýry kwéry omenda ra'e hese, he'i Hesu-pe hikwái hasy va'e-rehe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—Ha peẽ katu pejavy-ma voi pene nhe'ẽ, he'i Hesu. —Nhandejáry nhe'ẽ kwatia-rehe ohai uka va'ekwe peẽ ndapeikwaáiry. Peẽ ndapeikwaái voi ave Nhandejáry opamba'e rereko kwaaha voi. Upéa-gwi pejavy voi pene nhe'ẽ, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","—Nhane moingove jevyha áry-py, kwimba'e nomendavéi-ma va'erã. Kunha ave nomendavéi-ma va'erã. Oiko va'erã Nhandejáry rembigwái yváy pygwa reko-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ha Nhandejáry kwatia nhe'ẽ katu omombe'u peẽ-my omano va'ekwe oikove jevymaha. Moisés amyrĩ ohai va'ekwe yvyra ra'y rehegwa nhe'ẽ a-rami: “Xe katu Nhandejáry, xe Abraão járy, xe Isaque járy, xe Jacó járy ave” he'i Nhandejáry kwatia nhe'ẽ, omano va'ekwe oikove jevy-ma va'e oikwaa ukaha. Ma'erã ndapeikwaái pemonhe'ẽ nhe'ẽ va'ekwe? ");
INSERT INTO kgkNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aipo ramo, Nhandejáry ndaha'éi omano va'ekwe járy, tekove járy ae. Ha'e onhemoingove jevy va'e járy. Pejavypa pene nhe'ẽ, he'i saduceu kwéry-pe Hesu nhane moingove jevyha kwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ogwahẽ ou-vy judeu rekombo'ehaty pa'ũ-gwi peteĩ va'e. Ohendu íxupe kwéry onhonhe'ẽ mbojevy jevy ramo. Ohendu ramo, “Iporã Hesu remimombe'u” he'i. Upéa-gwi oporandu Hesu-pe: —Heta oĩ nhande rekoha nhe'ẽ. Kiva'e tuvixave va'e? he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—Kiva'e tuvixave va'e amombe'u-ta nde-vy, he'i Hesu. Upéi oiporu Nhandejáry kwatia nhe'ẽ: —“Pehendu katu, Israel remiarirõ kwéry. Tupã Nhandejáry ha'e anho oiko va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ehayhu tee katu Nhandejáry-pe. Nde py'apy gwive ehayhu íxupe. Ehayhu íxupe nde koty gwive. Ne mandu'a meme katu hese hayhu-vy. Ehayhu mbaraete ete ave íxupe” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","—Ha upe rire katu oĩ outro tuvixa va'e: “Ehayhu rei katu nde rapixa-pe nde ae nde rekove erehayhuha-rami” he'i Hesu Nhandejáry kwatia nhe'ẽ poru-vy. —Upe mokõi nhe'ẽ-gwi ndaipóri nhande rekoha nhe'ẽ tuvixave va'e, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—Ha'e-ma ngatu, mbo'eháry, he'i íxupe. —Anheigwa eremombe'u ere ramo Nhandejáry-rehe ha'e anho. Ndaipóri ha'e-rami tupã. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ha Nhandejáry katu he'i va'ekwe nhande-vy, “Pehapy mymba xe mboete-vy, pemoka'ẽ ave.” Upéixa ramo iporã nhame'ẽ hembijukarã nhamboete-vy Nhandejáry-pe. Ha iporãve jahayhu íxupe nhande py'apy gwive, nhande koty gwive jahayhu. Jahayhu mbaraete ete ave. Iporãve ave jahayhu nhande rapixa-pe nhande ae nhande rekove jahayhuha-rami, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ha Hesu katu ohendu oarandu reheve omombe'u ramo: —Haimete-ma eremoirũ Nhandejáry nde ruvixarã-pe, he'i íxupe. Upe rire nonhembopy'agwasúi avave oporandu hagwã Hesu-pe mbava'e-rehe po he'i upéixa. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ha Hesu onhemonhe'ẽ nhe'ẽ oiko-vy Nhandejáry róga kakwaa-py. Onhemonhe'ẽ-vy oporandu: —“Davi remiarirõre voi Cristo nhane remiha'arõ va'e” he'i omombe'u-vy judeu rekombo'ehaty. Ma'erã po he'i upéa hikwái? ");
INSERT INTO kgkNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","He'i va'ekwe Davi amyrĩ: “Nhandejáry he'i xe Járy-pe, Egwapy katu xe yke-rehe. Xe orombopu'aka va'erã ne a'e'ỹha-rehe. Orombopu'akapa peve eregwapy va'erã ereĩ-vy xe yke-rehe.” Upéixa ome'ẽ va'ekwe Davi-pe inhe'ẽrã Nhe'ẽ Marangatu tee va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ha Davi katu xe Járy-py ohenói va'ekwe íxupe. Aipo ramo hemiarirõ pa? Ha gwemiarirõ-rehe, “Xe Járy” nde'íry, he'i íxupe kwéry Hesu omokirirĩ-vy judeu ruvixa kwéry-pe. Ha te'ýi jusu ohendu ramo inhe'ẽ, ogwerohory joa íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","—Xáke judeu rekombo'ehaty-gwi, he'i onhemonhe'ẽ-vy. —Ani erejapo teĩ ha'e kwéry hembiapo-rami. Oao puku reheve ogwatase voi. Ogwata oho-vy mba'e jogwa haty-py. Onhemboete va'erã-rehe oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ojeporahéi haty-py ogwapyse mburuvixa pa'ũ-my. Mburuvixa gwapy haty-py ogwapyse onhembovía ramo ojekarugwasu haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ha tembirekokwe rembiporu omonda heraha-vy. Upe rire omondo mondo ra'anga rei Nhandejáry-pe heta onhe'ẽ enterove ohexa hagwã. Upe va'e temiexagwã rei ra'e. Ombohasa asyve va'erã íxupe kwéry Nhandejáry, he'i judeu rekombo'ehaty-rehe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Upéi ogwapy-ma Hesu Nhandejáry róga kakwaa-py pirapire imboyru haty rovái. Oma'ẽ heta oĩ va'e-rehe pirapire omboyru ramo hyruty-py. Heta oikotevẽ e'ỹ va'e heta ome'ẽ me'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ha upéi ou tembirekokwe ogwereko e'ỹ va'e. Mokõi moeda ombohyru, ohupity va'e peteĩ plata hatã. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","—Peju katu. Peju a-py, he'i gwemimbo'e kwéry-pe. —Anhete ko xe ha'e-ta peẽ-my. Kóa tembirekokwe okwerĩ va'e, hetave ombohyru enterove ombohyru va'e-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ha'e kwéry katu heta ogwereko-gwi, ome'ẽ. Ha kunha katu opa ogwerekomi va'e hembi'u repyrã, ome'ẽmba ete voi, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ha upéi katu osẽ oho-vy Hesu Nhandejáry róga kakwaa-gwi. Oho jave he'i íxupe hemimbo'e: —Ema'ẽ ehexa ita iporã va'e, mbo'eháry. Óga tuvixa vixa va'e ehexa, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ha he'i íxupe Hesu: —Ehexa katu upéa óga tuvixa va'e, he'i. —Ha upe rire katu ita reta omohãimba va'erã, omosarambipa va'erã. Ndojepota mo'ãvéi-ma ojóehe, he'i gwemimbo'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ogwapy oĩ-vy yvyaty Oliveiras ári jave, Nhandejáry róga rovarehéi ogwapy oĩ-vy. Ogwapy ha'e anho jave, oporandu íxupe Pedro, Tiago, João, André ndive: ");
INSERT INTO kgkNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Emombe'u katu ore-vy, he'i. —Araka'e tipo omohãimba-ta? Araka'e tipo ojehu va'erã ne remimombe'u? he'i. —Mba'éixa po oroikwaa va'erã imombe'uháry? Ojehu-tama ramo ne remimombe'u gwive, mba'éixa po oroikwaa va'erã imombe'uháry? he'i Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Oporandu rire-ma he'i íxupe kwéry Hesu: —Xáke pene mbotavyse va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Heta ojekwaa va'erã xe réry-py vérami mo'ã ou va'e. “Xe Cristo pene remiha'arõ va'e voi” he'i va'erã mo'ã ójehe onhemocristo ra'angase-vy, oporombotavy rei-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pehendu va'erã herakwã hi'agwĩ pendéhegwi onhorairõ ramo. Mombyry onhorairõ va'e rerakwã pehendu ave va'erã. Pehendu ramo, ani pekyhyje teĩ upéa-rehe. Upéa oiko va'erã voi. Upéa oiko-ma ramo, ne'írã vyteri ogwahẽ pehendu va'e ijapy-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ha tetã mygwa onhorairõ va'erã outro tetã mygwa ndive. Ha mburuvixagwasu re'ýi onhorairõ va'erã outro mburuvixagwasu re'ýi ndive. Oiko oiko ha-rupi ae oiko va'erã yvyryrýi. Ndaiporivéi-ma ho'u va'erã. Upéa-rupi pehasa asy ramo, ne'írã vyteri pehasa asy ete peiko-vy. Kunha imemby-ta va'e hasy íxupe. Ha upe rire katu hasyve syve oho-vy íxupe imemby hagwã. Upéixa ete yvypóry ohasa asy va'erã. Ha upe rire katu ohasa asyve syve oho-vy, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Xáke pende pyhy va'erã pende reraha-vy mburuvixa oĩ ha-py. Ojeporahéi haty-py pene nupã va'erã. Xéhegwi pene monhe'ẽ uka va'erã mburuvixa rovagwy-py. Mburuvixagwasu rovagwy-rupi ave pene monhe'ẽ uka va'erã. Xe mombe'u mbe'u hagwã-py pene monhe'ẽ uka va'erã. Xéhegwi katu pende rereko va'erã akói-rami. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ha xe rehegwa nhe'ẽ porã katu pemombe'u ranhe va'erã enterove tetã-my. Ha upe rire ae katu ombopapa ave-ma va'erã ko yvy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","—Pene monhe'ẽ uka-vy pende reraha va'erã. Pende pyhy pende reraha-vy ramo oikwaa hagwã pene rembiapo vai para'e, ani erejapura teĩ ere va'erã-rehe. Ou rei va'erã nde juru-py ne nhe'ẽrã. Ome'ẽ va'erã nde-vy ne nhe'ẽrã Nhe'ẽ Marangatu tee va'e. Upéixa ramo eremombe'u va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","—Ha tyke'ýry oipyhy va'erã heraha-vy gwyvýry ojuka uka hagwã. Ha túvy ojuka uka va'erã gwa'ýry gwajýry ave. Ha ta'ýry kwéry tajy kwéry ave ogwereko asy va'erã gwu osy ave ojuka uka hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ha xe-rehe ha-py katu enterovéa ndaija'e mo'ãi pende-rehe, he'i. —Ha Nhandejáry rape-gwi ova e'ỹ va'e katu ko yvy opa ete peve, oresende va'erã íxupe Nhandejáry, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Upéi oiporu Hesu Nhandejáry kwatia nhe'ẽ: —“Oĩ va'erã upe ivai ete va'e, pene momarã va'e. Nhandejáry róga kakwaa koty py-gwi pene mosẽ va'erã” he'i Hesu. —Upéa nhe'ẽ eikwaa porã ãy eremonhe'ẽ va'e. Upéi he'i Hesu: —Yma he'i hagwe-rami, pehexa va'erã upe ivai ete va'e Nhandejáry róga-py, gwenagwã e'ỹ ha-py omonhembo'y ramo. Pehexa-ma ramo upe va'e, pya'e voi tokanhymba kuri Judéia yvy pygwa kwéry oje'ói-vy. Yvyatygwasu ári-rupi tokanhy kuri oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ogwejy ramo óga ári oĩ va'e, ani oike koty-py ogweraha hagwã mba'eve. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ha kokwe-py oĩ va'e ani oho jevy ranhe hóga-py oipyhy hagwã oao. Pya'e ae kuri tokanhymba katu oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Upe áry-rupi iporiahu va'erã kunha imemby-ta va'e omokambu va'e ave. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ro'y eterei-rupi pekanhy ramo, ivaive arã peẽ-my. Upéa-rehe pemoĩ katu Nhandejáry-pe pene nhe'ẽ pono ivai ete peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Upe áry-py ohasa asy eterei va'erã yvypóry kente kwéry gwive. Ko yvy rembypy Nhandejáry remimoingokwe oiko jave, upe áry e'ỹ mboyve, ndohasa asy etéiry va'ekwe. Upe ary-py ae ohasa asy eterei va'erã. Ha upe áry rire katu ndohasa asy etevéi-ma va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ha Nhandejáry katu nombohasa asy hetave áryiry va'erã. Ombohasa asy hetave áry ramo ra'e, opa-ma arã ra'e enterove ko yvypóry. Ha gwembiporavo-rehe opena porã-gwi ae katu, nombohasa asy hetave áryiry va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Upe-ma ramo, “Ema'ẽ katu. Ko va'e Cristo voi” oĩ he'i va'erã para'e peẽ-my. “Ema'ẽ katu. Upe va'e Cristo voi” oĩ he'i va'erã para'e peẽ-my. Ani perovia inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ojekwaa va'erã, “Cristo pene remiha'arõ va'e voi xe” he'i va'e mo'ã ójehe peẽ-my. “Nhandejáry nhe'ẽ-py mba'e xe-vy anho oikwaa uka xe remimombe'urã” he'i va'e mo'ã ójehe, ojekwaa va'erã ou-vy. Hexapyrã-rupi voi hembiapo va'erã ohekoporu ou-vy ramo. Ohexa uka va'erã gwembiapo tuvixa va'e, ikatu ramo, itavy hagwã mo'ã íxupe Nhandejáry rembiporavo. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Xáke. Ani joty pende tavy íxupe. Ko'ã mba'e oiko e'ỹ ngatu amombe'u-ma peẽ-my, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Upe-ma ramo ohasa asy ete rire-ma, oje'o va'erã kwarahy rendy. Ha jasy nahendy mo'ãvéi. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ha okúi va'erã yváy-gwi jasytata. Ova ova gwendagwe-gwi entéro yváy rehegwa imbaraete va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Upe-ma ramo xe rexa va'erã yvypóry kente kwéry gwive. Xe Nhande Ryke'y tee va'e-pe xe rexa va'erã aju jave arai-rupi. Xe pu'akaha tee jave nhande resa mbojevy va'erã xe rendy porã-rupi xe rexa va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","—Ambou va'erã xe rembigwái yváy pygwa ombojogweroaty hagwã xe rembiporavokwe. Opa-rupigwi ombojogweroaty va'erã íxupe kwéry. Kwarahy resẽ-gwi, ka'aru-gwi ave ombojogweroaty va'erã heraha-vy. Arapopy-gwi, yvy apy-gwi yvy apy arendaja gwive ombojogweroaty va'erã, he'i íxupe kwéry omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Upéi he'i jevy Hesu: —Aỹ amombe'u-ta peẽ-my ojehu va'erã rehegwa nhe'ẽ figo máta rehegwa-rami, he'i, —peikwaa porã hagwã xe agwahẽ jevytaha áry. Oĩ figo máta. Hoky kyrýu jevy-ma ramo, hogwe pyahu jevy-ma ramo, pehexa-ma voi. Pehexa ramo, peikwaa-ma voi opa-ma ra'e ro'y. Áry raku jevy-tama. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Upéixa ete upe ojehu va'erã gwive pehexa ramo, peikwaa-ma va'erã oike-ta va'e-rami xe agwahẽ jevytamaha áry. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Anhete ko xe ha'e-ta peẽ-my. Entéro peẽ-my xe remimombe'u oiko va'erã. Judeu kwéry oiko reheve joty ojehu va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Opa va'erã áry yvy ave. Ha xe remimombe'u xe nhe'ẽ katu nombopapa mo'ãiry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—Mbava'e áry-py po ojehu va'erã ndajaikwaáiry. Araka'e óra-ma po ojehu va'erã ndajaikwaáiry. Nhandejáry rembigwái yváy pygwa jepe ndoikwaáiry. Xe ta'ýry jepe ndaikwaái ave. Nhandejáry xe Ru ha'e anho mante oikwaa. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Araka'e óra-ma po aju jevy va'erã ndapeikwaái-gwi, xáke, perepara voi katu. Emondo mondo katu ave Nhandejáry-pe ne nhe'ẽ, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Upéi oiporu jevy Hesu óga járy rehegwa nhe'ẽ jarepara porã hagwã nhande-vy oikwaa uka-vy: —Oĩ va'ekwe óga járy, he'i. —Heta oĩ hembigwái. Ijáry oho ramo mombyry, oheja gwembigwái onhangareko hagwã hóga-rehe. Peteĩ teĩ-pe hembiaporã ome'ẽ. “Erepara porã hese” he'i okẽ-rehe onhangareko va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ha upéixa ha'e-ta peẽ-my, “Óga járy” he'i xe-rehe. Upéa-gwi perepara katu. Ndereikwaái voi araka'e po xe aju va'erã. Ka'aru ete para'e, pyhare mbyte para'e, gáju sapukái-py para'e, ko'ẽ hembypytĩ jave para'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Upéa-gwi perepara katu pono peha'arõ e'ỹ reheve aju pya'e orotopa peke jave. ");
INSERT INTO kgkNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Peẽ-my ha'eha-rami, ha'e-ta enterovéa-pe oikwaa hagwã. Xe ra'arõ arõ katu perepara-vy, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mokõi áry rire oiko-ta aretegwasu héry va'e páscoa. Upe áry-py nanhambovúiry va'ekwe ja'u va'erã. Nhane mandu'a ave nhane rembypy ojerereko asy hagwe-rehe. Yma ete upe áry-py osẽ va'ekwe gwĩ ipu'aka va'e po-gwi. Ha upéi katu ne'írã oiko ramo aretegwasu, pa'i ruvixa kwéry judeu rekombo'ehaty ave onhombo'e mbo'e Hesu-rehe hikwái: —Nhambotavy Hesu-pe jaipyhy hagwã íxupe jajuka hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Arete-py ae ani jaipyhy íxupe, he'i. —Atýra-py jaipyhy ramo, onhembopoxy arã ijaty jaty va'e kente kwéry nhande-vy, he'i ojóupe Hesu pyhyharã kwéry. Upéa-gwi oipyhy nhemise Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ha Hesu katu oime Betânia tetã'i-my. Simão róga-py oime. Ha Simão mba'asy vai-gwi ijai aipa va'ekwe nhahenói íxupe va'e. Ogwapy okaru-vy Hesu. Okaru ramo, ogwahẽ ou-vy peteĩ kunha. Ogweru hyakwã porã tee va'e. Hyru reheve ogweru. Ha hyru ojejapo va'ekwe ita kyra rendy-gwi héry va'e alabastro. Ha hyakwã porã va'e héry nardo. Ha nardo hepy eterei voi. Ojoka onhohẽ Hesu akã-rehe omohyakwã porã-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ha upe-py oĩ ipoxy va'e: —Ma'erã po onhohẽ rei upe hyakwã porã va'e Hesu akã-rehe? he'i ojóupe oporandu-vy. —Hepy eterei va'e onhohẽ rei, he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","—Ma'erã po ra'e hepy-rehe ae nome'ẽiry, he'i. —Iporiahu va'e kwéry-pe nhame'ẽ ramo ra'e hyakwã va'e repykwe, iporãve arã ra'e, he'i. —Hyakwã repy peteĩ ro'y tembiapo repy para'e, hetave para'e, he'i onhe'ẽngi ẽngi-vy kunha-pe hikwái. Upéixa ramo kunha ndive ipoxy voi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Upéi he'i íxupe kwéry Hesu: —Eheja katu, he'i. —Ma'erã po ko kunha-pe eremoakã rasy? he'i. —Hembiapo porã ete voi xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pene pa'ũ-my oime meme va'erã iporiahu va'e kwéry. Ereme'ẽse ramo, ereme'ẽ-ta íxupe kwéry. Ha xe ae katu naime meméi va'erã aiko-vy pene pa'ũ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","—Ha ko kunha katu ome'ẽseha-rami ome'ẽ xe-vy. Nhamano va'ekwe nhande retekwe nhamohyakwãha-rami, amano e'ỹ ngatu xe mohyakwã ranhe ko kunha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","—Anhetegwa va'e amombe'u-ta peẽ-my. Opa-rupi entéro ko yvy-rupi mamo xe rehegwa nhe'ẽ porã omombe'u mbe'u ha-rupi ave omombe'u va'erã voi ko kunha rembiapo porã imandu'a hagwã hese, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ha upéi katu oho peteĩ doze hemimbo'e kwéry-gwi. Héry va'e Judas Iscariotes. Pa'i ruvixa kwéry ha-py oho omombe'u Hesu pyhyharã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ha ha'e kwéry ohendu ramo inhe'ẽ, ovy'a joa eterei: —Ereipyhy uka ramo ore-vy, orome'ẽ-ta nde-vy pirapire, he'i Judas-pe. Ha Judas katu orepara oiko-vy Hesu-rehe ipyhyharã-pe omombe'uha óra ra'arõ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ha upéi oiko-ma aretegwasu. Upe va'e semana mbojape ovu e'ỹ va'e ja'u. Upe va'e áry-py jajuka ovexa nhamoka'ẽ-vy Nhandejáry-pe nhamboete-vy. Upe jave oporandu Hesu-pe hemimbo'e kwéry: —Kipy tipo orombogwejy-ta nde-vy ne remi'urã nhane mandu'a hagwã páscoa-rehe jakaru-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ha Hesu katu omondo mokõi gwenonde: —Tapeho katu tetã-my, he'i. —Pende topa-ta kwimba'e y ryru reheve. Tapeho hapykwéri. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Oike ramo hóga-py, peje óga járy-pe: “Kipy oĩ nde koty ereiporu e'ỹ va'e? Aiporu-ta. Xe remimbo'e kwéry ndive akaru hagwã aiporu-ta. Páscoa-rehe xe mandu'a hagwã aiporu-ta, he'i kuri nhane mbo'eháry” peje pemombe'u-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","—Upéi ohexa uka-ta nde-vy koty ijyvate va'e, tuvixa va'e, oĩmba voi va'e. Nhane mohenonde katu upe-py, koty tuvixa oĩmba va'e-py, he'i gwemimbo'e-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Upéi mokõi hemimondo osẽ oho-vy omohenonde hagwã. Ogwahẽ ramo, opamba'e ojohu Hesu nhe'ẽ-py. Upéa-gwi omohenonde okaru hagwã imandu'a hagwã páscoa-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ha upéi katu ka'aru ete ramo ogwahẽ-ma Hesu ou-vy. Óga-py ogwahẽ ou-vy doze gwemimbo'e kwéry ndive. Óga oiporuruka hagwe-py íxupe ogwahẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Okaru joa ramo, he'i íxupe kwéry Hesu: —Anhetegwa va'e amombe'u-ta peẽ-my, he'i. —Peteĩ pene pa'ũ-my oĩ va'e xe karu rovái xe mombe'u va'erã xe pyhyharã-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ohendu ramo inhe'ẽ ojepy'arerahapa-ma hese, ndovy'avéi-ma hikwái: —Xe para'e ndaxéiry para'e, he'i hikwái onhemopeteĩ teĩ oporandu-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Xe mombe'u va'erã peteĩ xe remimbo'e pende avyte-py oĩ va'e, nha'ẽ-py opo omoĩ va'e. Xe ndive omoakỹ va'e mbojape nha'ẽ-py xe mombe'u va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","—Xe Nhande Ryke'y tee va'e aha va'erã xe ajejuka uka ha-py. Nhandejáry kwatia nhe'ẽ he'i hagwe-rami aha va'erã. Ha xe mombe'u va'erã katu xe pyhyharã-pe amboasy eterei íxupe. Ohasa asy eterei va'erã. Iporãve arã araka'e ndoikói ramo araka'e osyrã-pe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Okaru joa jave Hesu oipyhy mbojape. Otima porã Tupã Nhandejáry-pe. Upéi ombopo mbopóy mbojape. Ome'ẽ íxupe kwéry omongaru joty: —Ko, he'i ome'ẽ-vy íxupe. —Ko mbojape xe rete-rehe ha'e, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Upéi oipyhy ave copo. Otima porã Nhandejáry-pe. Ho'u uka íxupe kwéry ome'ẽ-vy. Ho'u joa uva rykwere: ");
INSERT INTO kgkNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Ko copo pygwa xe rugwy-rehe he'i. Onhehẽ va'erã xe rugwy imbaraete hagwã Nhandejáry remimombe'u. Yma Nhandejáry, “Amopotĩ va'erã kente kwéry-pe” he'i va'ekwe. Upéa nhe'ẽ imbaraete-ma va'erã xe rugwy onhehẽ-ma ramo. Heta kente-rehe ha-py onhehẽ va'erã xe rugwy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","—Ha'e-ta peẽ-my. Ha'u-ma kuri uva rykwere. Ãy ae katu nda'u mo'ãvéi-ma. Ha upe rire katu, pende ruvixa ramo xe Ru oiko haty-py, ha'u jevy va'erã, he'i. —Upe-py agwahẽ ramo uva rykwere pyahu ha'u jevy va'erã, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Upéi Nhandejáry mboete-vy oporahéi joa. Oporahéi rire osẽ oho-vy Oliveiras yvyaty-py. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","—Peẽ katu pejehesa rerova-ta xéhegwi, he'i íxupe kwéry Hesu. —Oĩ Nhandejáry kwatia nhe'ẽ he'i va'e a-rami: “Ajuka va'erã herakwa osarambipa hagwã ovexa hymba kwéry” he'i. Yma he'i hagwe-rami, ãy xe juka-tama, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","—Ha upe rire xe anhemoingove jevy rire katu aha va'erã Galiléia yvy-py. Pene renonde aha ranhe va'erã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Upe ramo he'i Pedro: —Gwĩ ne irũ kwéry ndéhegwi ojehesa rerova ramo jepe, xe ae katu ndorohejái joty va'erã, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ha Hesu katu he'i: —Anhete ko xe ha'e-ta nde-vy: Etería ko va'e pyhare-py ne'írã vyteri osapukái ramo gáju imokõiha-rehe, “Xe ndaikwaái voi” ere va'erã xe-rehe mbohapyha-rehe, he'i íxupe, Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ha hatã hatã onhe'ẽ Pedro: —Xe ajejuka uka-ta ramo jepe ne ndive, ndajehesa rerovái joty va'erã ndéhegwi. “Xe ndaikwaáiry” nda'éiry joty arã katu nde-rehe, he'i Hesu-pe. Pedro he'i hagwe-rami ave, he'i inhirũ kwéry Hesu remimbo'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ohopa ogwata-vy hikwái. Getsêmani yvaty oje'e ha-py ogwahẽ oho-vy: —A-py pegwapy katu, he'i. —Xe anhomongeta jave Nhandejáry ndive, xe ra'arõ ranhe a-py, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Upéi mbohapy ondive ogweraha. Ogweraha Pedro, Tiago, João. Upéi ogwahẽ vy'are'ỹgwasu íxupe. Ojepy'ajopy eterei-ma ave oiko-vy: ");
INSERT INTO kgkNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Ogwahẽ-ma vy'are'ỹgwasu xe-vy xe juka-ta va'e-rami, he'i. —Epyta a-py. Xe moirũ katu ereke e'ỹ reheve, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Upéi ha'e ae oho mbykymi ojeity yvy-rupi. Ojerure Nhandejáry-pe: —Ikatu-ta ereipe'a xéhegwi xe ajepy'ajopyha? he'i oporandu-vy. Upéi he'i jevy: ");
INSERT INTO kgkNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Nde katu opamba'e erejapo kwaa va'e, xe Ru, he'i gwu-pe. —Upéa-gwi eipe'a katu xéhegwi xe ajepy'ajopyha. Ereipe'ase ramo, eipe'a katu xéhegwi. Ha ndereipe'aséi ramo, ani joty ereipe'a ave, he'i onhomongeta-vy Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Upéi ou jevy mbohapy gwemimbo'e ha-py. Ogwahẽ ramo ikéra otopa: —Ma'erã po ereke joty ereĩ-vy, Simão? he'i Pedro-pe. —Ma'erã po naxe ra'arõi peteĩ óra-py jepe? Ma'erã nem mixĩmi naxe moirũiry? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","—Epáy katu. Ejapo katu oração xe ra'arõ-vy. Nerenhembojejavy ukái arã, he'i íxupe. —Nde py'a kyre'ỹ voi. Ereke e'ỹ reheve erejapose mo'ã oração. Ha nde rete katu okese voi, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Upéi oho jevy Nhandejáry ndive onhomongeta-vy. Gwemimombe'ukwe omombe'u jevy. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ouri jevy ramo, ikéra otopa jevy-ma. Hapehýi eterei-gwi okepa-ma hikwái. Otĩ-gwi ndoikwaái onhe'ẽrã okwa-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ouri uri. Mbohapyha-rehema ou jevy. —Ma'erã po ereke joty eretongea-vy? he'i Hesu. —Ha'eve-ma. Ogwahẽ-ma ngatu xe óra. Xe ko Nhande Ryke'y tee va'e xe pyhy uka-tama hekoha vai va'e-pe. Xe me'ẽ va'erã gwĩ ojejavy va'e Nhandejáry kwaa e'ỹha va'e po-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","—Epu'ã katu. Jaha. Ehexa katu. Onhemo'agwĩ-ma ra'e xéhegwi ou-vy upe xe pyhy ukaharã, he'i gwemimbo'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Onhe'ẽ jave Hesu, pya'e ogwahẽ ou-vy Judas, petẽi Hesu remimbo'e kwéry va'e. Heta ou ave hendive ogweru opo-py kyse puku yvyra ave. Ogwahẽ ou-vy pa'i ruvixa kwéry remimbou, judeu rekombo'ehaty remimbou ave. Judeu ruvixa kwéry remimbou ave ogwahẽ ou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ha Judas katu Hesu pyhy ukaha he'i ra'e: “Ahexa uka-ta peẽ-my pene rembipyhyse” he'i ra'e. “Upe va'e ahovapyte-ta va'e pene rembipyhyrã voi” he'i. “Peipyhy hatã íxupe heraha-vy pono okanhy” he'i ra'e ipyhyharã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ãy ou pya'e ha'e anho Hesu oĩ ha-py ohovapyte hagwã Hesu-pe: —Mbo'eháry, he'i ogwahẽ-vy Judas íxupe. Upéi ohovapyte Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ha upéi katu ha'e kwéry ou onhemoĩ-ma hese oipyhy hagwã íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Upe-ma ramo peteĩ upe-py oĩ va'e omopu'ã kyse oikytĩ-vy. Ohaxea pa'i ruvixagwasu rembigwái-pe onambi'o-vy. Ohupity oinambi'o hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Ha Hesu katu he'i: —Ma'erã po pegwahẽ peju-vy kyse reheve xe pyhy hagwã peju-vy? Ma'erã po yvyra reheve ave pegwahẽ peju-vy? he'i oporandu-vy íxupe kwéry. —“Hesu oporosakea va'e” peje tipo peju-vy? Ha ndaha'éiry upeixagwa xe. Iko'ẽ ko'ẽ anhemonhe'ẽ nhe'ẽ aiko-vy Nhandejáry róga kakwaa-py. Anhemonhe'ẽ meme ramo, xe mokambara voi. Ha naxe pyhýiry voi ra'e. Ha Nhandejáry kwatia nhe'ẽ imbaraete voi. Upéa-gwi yma he'i hagwe-rami, ãy oiko-ma, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ha upéi katu ha'e anho ete-ma oheja Hesu-pe hikwái. Ohopa íxugwi hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ha upéi oho hapykwéri karia'y. Upe karia'y Hesu rapykwerigwa morotĩ va'e-py mante onhenhugwã. Oipyhy-ma mo'ã íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ijao rei oipe'a. Ha karia'y omboi oao oripara oho-vy. Opi-vy oheja oho-vy oaokwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ha upéi katu Hesu pyhy hagwe ogweraha íxupe. Pa'i ruvixagwasu róga kakwaa-py ogweraha Hesu-pe. Upe-py ojogweroaty pa'i ruvixa kwéry. Judeu ruvixa kwéry hekombo'ehaty kwéry ndive ojogweroaty. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ha Pedro oho hapykwéri meme. Hesu rapykwéri puku oho. Pa'i ruvixagwasu roka-py oike ogwahẽ-vy. Polícia kwéry ndive ogwapy oĩ-vy. Tata ypy-py ojepe'e oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ha pa'i ruvixa kwéry entéro judeu ruvixa kwéry ndive ojuka ukase voi Hesu-pe. Upéa-gwi oheka heka mo'ã Hesu-rehe onhe'ẽ va'erã. Ha ndotopái voi. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Heta omombe'u mbe'u apu rei Hesu-rehe. Ha ndaijojái inhe'ẽ kwéry. Omombe'u joavy avy joty. Upéa-gwi ndaipóri Hesu-rehe onhe'ẽ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ha upe rire katu ou onhembo'y va'e omombe'u. Apu rei omombe'u hese: ");
INSERT INTO kgkNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Upéa remimombe'ukwe orohendu va'ekwe oromombe'u-ta peẽ-my: “Aitypa uka-ta ko Nhandejáry róga kakwaa teko rei rembiapokwe xe ae amopu'ã jevy hagwã. Teko rei rembiapo e'ỹ amopu'ã jevy-ta xe. Mbohapy áry-rupi amopu'ã jevy-ta. Upéixa he'i Hesu” he'i omombe'u-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ha hemimombe'u katu ndaijojáiry vyteri. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Omombe'u joavy avy joty. Upe-ma ramo onhembo'y-ma oĩ-vy pa'i ruvixagwasu ha'e kwéry hovái: —Ejeapysaka katu, he'i. —Heta ne mombe'u mbe'u hikwái. Ma'erã po neremombe'u mo'ãi ne mombe'uhare-pe? he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ha ha'e katu opyta okirirĩ íxugwi. Mba'eve nomombe'úi. Upéi pa'i ruvixagwasu he'i: —Nde pa Cristo, nhane remiha'arõ va'e? Nde pa Nhandejáry onhemomba'egwasu va'e ra'y? he'i jevy íxupe, Hesu-pe, omonhe'ẽse-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Xe ko ha'e voi, he'i. —Xe Nhande Ryke'y tee va'e-pe xe rexa va'erã Nhandejáry yke-rehe ijakatúa-koty agwapy ramo xe rexa va'erã. Imbaraeteve va'e Nhandejáry. Arai-rupi xe agwejy ramo xe rexa va'erã, he'i onhemombe'u-vy judeu ruvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Upéa nhe'ẽ ogweropoxy pa'i ruvixagwasu. Ogwerovái-gwi omondoro oao: —Pehendu-ma voi inhe'ẽ vaiha, he'i. —Outro imombe'uharã-rehe nanhaikotevẽiry-ma, he'i. —Ojéhegwi rei onhe'ẽ vai-ma, onhemonhandejáry-vy mo'ã, he'i hese. —Mbava'e tipo pejapo-ta hese? he'i íxupe kwéry oporandu-vy: —Tomano katu, tojejuka katu, he'i joa joty voi hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Upéi onygwõ nygwõ Hesu-rehe. Ohesagwã ojokwa. Osokea kea íxupe opo-py: —Emombe'u ore-vy, kiva'e va'e ne nupã, he'i oinupã nupã-vy íxupe hikwái. Oinupã nupã ave íxupe polícia kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ha Pedro katu opyta oĩ-vy oka-py, pa'i ruvixagwasu rokẽ rovagwy-py. Upe-ma ramo ogwahẽ ou-vy kunhataĩ pa'i ruvixagwasu rembigwái va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ohexa Pedro-pe ojepe'e ramo. Omanha hova-rehe: —Upe Nazaré pygwa ndive ereiko va'e voi nipo nde ra'e. Hesu ndive ereiko va'e voi ave nde, he'i íxupe hembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—Ndaikói va'e voi xe, he'i. —Ndaikwaáiry mba'eve xe, he'i. —Ne nhe'ẽ katu ndaikwaái voi, he'i. —Mbava'e rehe po aipo ere, ndaikwaái voi xe, he'i mo'ã íxupe Pedro. Hesu irũ e'ỹ-rami ojejapo ha'e. Upéi katu osẽ oho-vy mbykymi. Okẽ-my oho. Ha osapukái gáju. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ha ohexa jevy-ma íxupe hembigwái: —Hesu ndivegwa voi upe va'e, he'i jevy upe-py oĩ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—Naháni, ndaxéiry, he'i jevy Pedro kunhataĩ-pe. Upe riremi he'i jevy íxupe upe-py oĩ-vy. —Galiléia pygwa voi nde. Hesu ndivegwa voi nipo ra'e nde, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Upe ramo he'i: —Xe apu ramo, taxe moingo asy katu Nhandejáry, he'i. —Upe kwimba'e ne remimombe'ukwe ndaikwaái voi xe, he'i mo'ã íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ha upéi imokõiha-rehema osapukái pya'e jevy gaju. Imandu'a-ma Hesu nhe'ẽgwe-rehe, “Ne'írã osapukái ramo gáju imokõiha-rehe, Xe ndaikwaáiry, ere va'erã xe-rehe mbohapyha-rehe”. Upéa nhe'ẽ-rehe imandu'a-ma ramo Pedro, ojahe'o-vy hasẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ko'ẽmba-ma ramo ojogweroaty jevy pa'i ruvixa kwéry, judeu ruvixa kwéry ndive, judeu rekombo'ehaty ndive ave. Entéro judeu ruvixa kwéry gwive ojogweroaty onhomongeta-vy: —Mbava'e tipo jajapo-ta Hesu-rehe? he'i onhombo'e mbo'e-vy hese. Upéi oikwaa-ma ramo, onhapytĩ-ma íxupe hikwái. Ipokwaha reheve ogweraha mburuvixagwasu Pilatos po-py ome'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","—Nde tipo ereiko ra'e judeu kwéry ruvixagwasu ramo? he'i oporandu-vy íxupe Pilatos. —Nde ae xe renói voi. “Judeu kwéry ruvixagwasu” nde ae ere-ma xe-rehe. Xe voi, he'i joty íxupe Hesu onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ha pa'i ruvixa kwéry heta omboja rei inhe'ẽ hese va'e. —Hembiapo vai-ma, hembiapo vai-ma, he'i joa hese. Ha Hesu katu nomombe'uvéiry. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","—Heta nde-rehe nhe'ẽ onhemboja mboja rei va'e. Ma'erã po nerenhemombe'úiry? he'i jevy íxupe Pilatos oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ha Hesu katu mba'eve joty nomombe'úiry. Nonhemombe'úi-gwi, “Ma'erã po nonhemombe'uséiry?” he'i ojéupe opondera-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ha oiko jave aretegwasu, oĩ opoi uka íxugwi va'erã. Peteĩ onhemoĩ preso va'ekwe-gwi oĩ opoi uka jevy va'erã imondo-vy mburuvixagwasu-pe. Upe ijaty va'e kwéry ojerure va'ekwe-gwi opoi uka-ma imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oĩ hembiapresakwe oporojuka va'ekwe. Ohekoviarõ hagwã mo'ã mburuvixagwasu-pe, oporojuka va'ekwe. Indive kwéry oĩ héry va'e Barrabás. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ha upéi katu ou ijaty va'e ojerure-vy ojapo hagwã íxupe kwéry ojapo japo hagwe-rami: —Epoi katu ore-vy toho jevy aretegwasu-py erepoi meme hagwe-rami, he'i Pilatos-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Ha mburuvixa oikwaa pa'i ruvixa kwéry rekoha vaiha. Ohexa kwaa hese: “Ndaija'éi-gwi rei hese, oipyhy ra'e íxupe heru-vy xe-vy hikwái” he'i ojéupe mburuvixa. Upéa-gwi he'i ijaty va'e-pe: —Peipota tipo apoi peẽ-my upe judeu kwéry ruvixagwasu-gwi? he'i íxupe kwéry oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ha pa'i ruvixa kwéry katu he'i: —Ejerure katu Hesu rekovía Barrabás-rehe, he'i jevy jevy ijaty va'e-pe ojojurupypa opo'ẽ-vy hikwái. Pa'i ruvixa nhe'ẽ-py he'i Pilatos-pe ijaty va'e: —Epoi ore-vy íxugwi, Barrabás-gwi toho, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—Aipo ramo, mbava'e tipo ajapo-ta Hesu-rehe? Upe va'e judeu ruvixagwasu pene remihenói, he'i jevy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Ejuka uka katu íxupe. Kurusugwasu-rehe ejuka uka katu íxupe, he'i joa joty íxupe onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Ajuka rei va'erã. Nahembiapo vaíry voíte Hesu ra'e, he'i íxupe kwéry Hesu-rehe. —Emboja katu, emboja katu imoĩ-vy kurusugwasu-rehe omano hagwã, he'i joa joa hikwái onhe'ẽ hatãve tãve-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ha Pilatos katu ombovy'ase íxupe kwéry. Upéa-gwi ha'e kwéry inhe'ẽ-py opoi imondo-vy íxugwi. Barrabás-gwi opoi Pilatos. Upéi he'i ombopi hagwã Hesu-pe. Ome'ẽ ijukaharã-pe omboja hagwã kurusugwasu-rehe ijuka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ha upéi katu soldado kwéry ogweraha koty-py Hesu-pe. Mburuvixa róga kakwaa-py ogweraha íxupe. Hoga kakwaa héry pretório. Upe-py enterove soldado gwive onhomboatypa hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Omonde Hesu-rehe ao pytã va'e. Upéi nhuatĩ-gwi ojapo íxupe ijegwaka ra'angarã omoĩ hagwã inhakã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Upe rire omboete ra'anga anga rei íxupe onhembohory-vy: —Toiko are katu, toiko are katu judeu ruvixagwasu, he'i onhembohory-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Onhakãrupã rupã íxupe takwáry-py. Onygwõ nygwõ hese. Onhesũ nhesũ gwetypy'ã-rehe omboete a'ã a'ã hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Onhembohorypa rire hese, omboi íxugwi ao pytã va'e. Omonde jevy hese ijao. Upe rire ogweraha Hesu-pe omboja hagwã kurusugwasu-rehe ijuka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Upe ramo oĩ ohasa rei va'e. Upe va'e Cirene pygwa héry va'e Simão. Simão Alexandre ru, Rufo ru ave. Tetã jerekwe-gwi ou ra'e. Ha soldado katu ogweraha uka íxupe Hesu kurusugwasurã. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Upéixa ramo ogweraha Hesu-pe. Gólgota oje'e ha-py ogweraha. Akãgwe rendaty-rehe he'i Gólgota. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Upe-py ogwahẽ ramo, uva rykwere-py omoĩ pohã héry va'e mirra. Ome'ẽ íxupe ho'u uka-vy. Ome'ẽ íxupe pono ohendu eterei ojéupe hasy va'e. Ha ndo'úiry. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ha upéi katu ijuka hagwã-pyma ogwenogwahẽ omboja íxupe kurusugwasu-rehe. Upéi omboja rire soldado kwéry ohuga onhomboja'o ja'o hagwã Hesu aokwe-rehe. Ogana gana va'e ogweraha ijaokwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pyhareve asaje ramo, omboja-ma íxupe kurusu-rehe imoĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ha Hesu-rehe hemimombe'ukwe ohai omoĩ ikurusu-rehe inhakã ári. “Kóa judeu ruvixagwasu” he'i imoĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Oĩ ave mokõi imonda va'e kurusu-rehe omboja ave imoĩ-vy. Hesu yke-rehe joty ave omoĩ peteĩ ijakatúa-koty, peteĩ ijasu-koty. Imbyte-py oĩ Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ogwereko íxupe ojejavy va'ekwe-rami. Nhandejáry kwatia nhe'ẽ he'i hagwe-rami, ãy oiko-ma. Upéa-gwi ogwereko asy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Gwĩ ohasa oiko-vy va'e opuka hatã Hesu-rehe. Onhakãreity ity onhembohory-vy hese: —Aa! Ereity-ta mo'ã Nhandejáry róga kakwaa eremopu'ãmba jevy hagwã mbohapy áry-rupi, he'i mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","—Aipo ramo, egwejy katu kurusu-gwi erenheresende-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ha upéixa ave onhembohory hese ojóupe pa'i ruvixa kwéry, judeu rekombo'ehaty ndive: —Upéa opororesende va'ety. Ha ndaipu'akáiry gwekove-rehe onheresende hagwã, he'i hese onhembohory-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—“Xe Cristo nhane remiha'arõ va'e. Xe Israel kwéry ruvixagwasu” he'i kuri ójehe. —Aipo ramo ãy togwejy katu kurusu-gwi. Jahexa ramo, jarovia arã, he'i joa hikwái. Hesu jave kurusugwasu-rehe onhemboja va'ekwe onhe'ẽ rei rei ave hese. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Upéi kwarahy mbyte-py pytũmba-ma upe yvy ári. Upe tetã-rehe pytũmba ete-ma. Mbohapy óra peve opyta. Ka'arugwasu peve opyta. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ka'arugwasu ramo onhe'ẽ hatã Hesu. Ha'e ae onhe'ẽ-py onhe'ẽ: —Eloí, Eloí, lamá sabactâni? he'i ha'e ae onhe'ẽ-py. Upéa he'ise, “Tupã xe Járy, Tupã xe Járy, ma'erã-gwi po xe rejapa xe anho eterei?” he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ha upe-py oĩ inhe'ẽ ohendu va'e: —Ejeapysaka katu. Upéa ohenói Elias-pe, he'i mo'ã Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Upe ramo oripara ogweru bucha. Omoakỹ uva rykwere hepy ete e'ỹ va'e-py. Takwáry-py omoĩ. Oipyte uka Hesu-pe omboy'u-vy: —Eheja katu. Ou-ta para'e Elias ombogwejy hagwã kurusu-gwi oresende-vy, he'i Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ha upéi katu onhe'ẽ hatã jevy-ma Hesu. Ha upe rire katu omano-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Upe-ma ramo pya'e ojeka Nhandejáry róga kakwaa pygwa okẽgwasu nhugwãha tuvixa ete va'e. Osoro hatã. Yvate-gwi yvy peve ojeka hatã ou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ha Hesu rovagwy-rupi oĩ capitão, soldado ruvixa va'e. Onhe'ẽ hatã omano hagwã ramo, ohexa íxupe: —Upe va'e Nhandejáry ra'y tee voi nipo ra'e, he'i Hesu-rehe ohexa-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ha kunha heta oĩ upe-py. Mombyry-gwi oma'ẽ joa Hesu-rehe hikwái. Oĩ Maria Madalena, oĩ Salomé, oĩ Maria, ha'e Tiago tyvýry José sy ndive voi. Tyke'ýry héry ave Tiago ikarapemi va'e. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Upéa kunha kwéry omoirũ irũ ra'e Hesu-pe Galiléia-rupi. Ome'ẽ me'ẽ ra'e Hesu-pe hemikotevẽ. Oĩ ave heta kunha ambue va'e hendive ou va'ekwe Jerusalém-my. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ka'aru ete-ma. Upe áry-py judeu kwéry omoĩ porãmba gwemi'urã iko'ẽ ho'u va'erã. Ndoikói vyteri pytu'uha áry. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ndoikói-gwi vyteri, oho José Pilatos renda-py. Upe va'e José Arimatéia pygwa, judeu ruvixa va'e, onhemboete va'e voi. Ha'e ave oha'arõ arõ va'e Nhandejáry nhande ruvixa-pe omoirũ hagwã. Upéixa ramo onhembopy'agwasu oho hagwã Pilatos renda-py ojerure Hesu retekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ha Pilatos ohendu ramo omanoha, —Pya'e omano ra'e, he'i Hesu-rehe opondera-vy. Upéi ohenói upe soldado ruvixa-pe oporandu hagwã íxupe: —Omano-ma tipo ra'e Hesu? he'i soldado ruvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Ha'e voi. Omano ete-ma voi, he'i íxupe omombe'u-vy. Upe rire he'i José-pe Pilatos: —Aipo ramo eraha hetekwe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ha upéi katu José oho ojogwa ao morotĩ iporã va'e onhugwã hagwã hetekwe. Ombogwejy kurusu-gwi. Onhugwã ao morotĩ-my. Upe reheve omoĩ itakwa-py hetekwe. Ita-gwi ojo'o ra'e hetekwe renagwã. Upe-py omoĩ hetekwe. Upéi omboapajeréi imondo-vy itagwasu. Omboty hagwã itakwa rokẽ omboapajeréi itagwasu. ");
INSERT INTO kgkNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ha Maria Madalena José sy ndive oma'ẽ oĩ-vy. Ohexa joty omoĩ ramo hetekwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pytu'uha áry rire oho Salomé ndive Maria Madalena, Maria Tiago sy ave. Oho ojogwa pohã hyakwã va'e omona hagwã hetekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Iko'ẽ ramo, domingo-py osẽ-ma ramo kwarahy, voi oho ogwata-vy. Itakwa-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Oho jave, —Kiva'e oipe'a-ta nhande-vy itagwasu itakwa rokẽ-gwi, he'i ojóupe oporandu randu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Oma'ẽ ramo ohexa-ma itagwasu ojepe'a va'ekwe. Ha ita tuvixa eterei voi. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ha upéi katu oike itakwa rye py-py. Oike ramo ha'e-py Nhandejáry rembigwái karia'y-pe ohexa-ma. Ohexa ogwapy oĩ-vy ramo ijyke-rehe. Ao morotĩ puku va'e omonde ramo ohexa. Ohexa ramo, onhemondýi-ma. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ha he'i íxupe karia'y: —Aníke penhemondýi teĩ, he'i. —Peju-ma ra'e, he'i. —Peheka voi peju-vy Hesu Nazaré pygwa kurusu-rehe onhemboja va'ekwe retekwe-pe, he'i. —Oikove jevy-ma kuri Hesu. Peheka ramo jepe ndaiporivéi-ma ko'a-py. Oho-ma kuri. Peju katu peẽ pema'ẽ hupagwe-rehe. Hendagwe rei-ma oĩ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","—Ha upe rire katu ekwa emombe'u hemimbo'e kwéry-pe, Pedro-pe ave. Ere íxupe: “Hesu oho-ta Galiléia tetã-my. Ne renonde oho-ta. Upe-py erehexa va'erã íxupe. He'i hagwe-rami erehexa va'erã” he'i íxupe kwéry karia'y. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ha kunhagwe katu osẽ pya'e itakwa-gwi. Oripara oho-vy. Ipy'a ryrýi-ma onhemondýi-gwi. Okyhyje-gwi nomombe'úiry avave-pe. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ha Hesu katu, oikove jevy ramo, ojehexa uka jevy. Voi domingo-py ojehexa uka Maria Madalena-pe. Íxugwi omosẽ va'ekwe imondo-vy sete anháy. Ãy katu íxupe anho ranhe ojehexa uka Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ohexa rire, Maria oho omombe'u Hesu irũgwe-pe. Ha'e kwéry hasẽ ojahe'o-vy hikwái. Upe jave omombe'u: ");
INSERT INTO kgkNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","—Hesu oikove jevy-ma, he'i omombe'u-vy. —Ahexa jevy-ma íxupe kuri, he'i íxupe kwéry omombe'u-vy. Ha ohendu ramo inhe'ẽ ndogweroviáiry voi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ha upe rire katu Hesu ojehexa uka jevy mokõi oirũgwe-pe. Gweko ambue va'e-rami ojehexa uka íxupe tetã jere-rehe ogwata ramo oiko-vy. Oirũgwe ramo jepe ndoikwaavéiry oirũgwe. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ha oikwaa-ma ramo oho jevy omombe'u Hesu remimbo'e kwéry-pe. Ha ndogweroviáiry voi inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ha upéi katu ojehexa uka jevy onze gwemimbo'e kwéry-pe. Okaru joa jave ojehexa uka íxupe. He'i íxupe kwéry Hesu: —Xe rexahare xe mombe'u ramo nde-vy, ma'erã ndereroviáiry? he'i. —Xe aikove jevymaha omombe'u ramo nde-vy, ma'erã ndereroviái? Nane akã porãi-gwi, nane mba'e reroviáiry-gwi, xe mombe'u ramo ndereroviáiry, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Upéi he'i íxupe kwéry: —Tereho opa-rupi emombe'u Nhandejáry rehegwa nhe'ẽ porã. Entéro yvypóry-pe kente kwéry va'e-pe gwive emombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Upe ogwerovia va'e, onhemongarai va'e ave, oresende va'erã íxupe Nhandejáry. Ha ogwerovia e'ỹ va'e katu, nomboyke mo'ãiry voi íxugwi hembiapo vaikwe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Ha xe rerovia va'e katu xe réry-py omosẽ va'erã imondo-vy anháy. Aỹ oikwaa e'ỹ nhe'ẽ va'e-py onhe'ẽ va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Oipyhy ramo mbói reheve, naimboirasy mo'ãiry. Hi'upy e'ỹ jepe ho'u ramo, ndahasýi ave arã. Hasy va'e-rehe omoĩ ramo opo, ombogwera va'erã íxupe. Upéixa voi hexapyrã-rupi hembiapo porã porã va'erã xe rerovia va'e, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Upéi omombe'u rire ogwerojeupi heraha-vy íxupe Nhandejáry. Ha Hesu ogwapy-ma Nhandejáry yke-rehe ipu'aka reheve. ");
INSERT INTO kgkNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ha hemimbo'e kwéry katu osẽ oho-vy opa-rupi onhemonhe'ẽ nhe'ẽ-vy. Ha Nhandejáry oipytygwõ íxupe kwéry. Upéa-gwi hexapyrã-rupi hembiapo porã porã hikwái. Nhandejáry Hesu Cristo rehegwa nhe'ẽ porã omombe'u ramo, ogwerovia inhe'ẽ henduháry. Hembiapo porã rexa-vy, Anhetegwa nipo ra'e inhe'ẽ, he'i ogwerovia-vy.");
INSERT INTO kgkNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Mba'éixa pa, Teófilo? Xe, Lucas, ahai-ta ko kwatia-rehe xe nhe'ẽ nde-vy gwarã. Hesu Cristo rehegwa nhe'ẽ ahai-ta nde-vy, Teófilo. Oĩ-ma Hesu Cristo rehegwa kwatia nhe'ẽ gwĩ ambue kwéry ohai va'ekwe. Hesu rerakwã, mbava'e tipo ojapo araka'e ore pa'ũ-rupi ha'e kwéry kwatia-rehe omoĩ va'ekwe. Hesu irũgwe kwéry ohexapa araka'e hembiapo, ohendu ave araka'e hemimombe'u, ha omombe'u mbe'u araka'e ojehegwa nhe'ẽ porã. Aipo ramo inhirũgwe omombe'u jevy ramo hesegwa nhe'ẽ, henduháry kwatia-rehe omoĩ va'ekwe gwemiendukwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ha xe katu, xe ave anhomongeta va'ekwe Hesu irũgwe kwéry ndive. Heta Hesu rehegwa nhe'ẽ aikwaase-gwi aporandu randu íxupe kwéry hesegwa nhe'ẽ-rehe. Aikwaa porãve hagwã aporandu randu aiko-vy va'ekwe íxupe kwéry. Omombe'upa va'ekwe xe-vy. Hexahare remimombe'ukwe ahai kuri nde-vy ko kwatia-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hesu rerakwã nhahendu meme-ma va'ekwe. Eremonhe'ẽ-ma rire ko kwatia, hesegwa nhe'ẽ anhetegwa ete ereikwaa va'erã. Ere arã “Omombe'u porã xe-vy Hesu rehegwa nhe'ẽ”. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes oime ramo mburuvixagwasu judeu kwéry yvy-pe pa'i ramo Zacarias oiko. Pa'i Abias re'yikwe ha'e Nhandejáry rembigwái ramo jevy oiko. Hembireko pa'i Arão re'yikwe va'e. Isabel hembireko réry. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ha pe mokõi ojapo meme Nhandejáry remimbota. Oiko meme Nhandejáry nhe'ẽ-rupi. Upéixa-gwi Nhandejáry he'i hese: “Ipy'a porã voi Zacarias, hembireko ave ipy'a porã” he'i Nhandejáry hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ha ha'e katu ndata'ýryi va'e voi. Imemby e'ỹ va'e voi hembireko. Ogwerogwaigwĩ-ma omemby e'ỹ. Ogwerotuja-ma gwa'ýry e'ỹ gwajýry e'ỹ ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","10","Ha peteĩ áry Nhandejáry nhe'ẽ-py inhirũ kwéry oiporavo Zacarias-pe omohyakwã hagwã koty'i. Abias re'yikwe ndive, Zacarias oime Nhandejáry róga kakwaa-py. Nhandejáry renonde-py omba'apo hikwái. Ha peteĩ va'e mate oike Nhandejáry koty'i-py imohyakwã hagwã. Upe jave ojogweroaty va'e oka-gwi rei omondo onhe'ẽ Nhandejáry-pe. Ha peteĩ áry hapixa kwéry Nhandejáry réry-py oiporavo Zacarias-pe omoinge hagwã koty'i-py. Hyakwã jave, oka-py joa-ma oĩ hikwái. Osẽ ramogwarã oha'arõ hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Upe jave ou Nhandejáry rembigwái yváy pygwa ojehexa uka hagwã Zacarias-pe. Onhembo'y hyakwã va'e renda yke-rehe ha upe-py ojehexa uka íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ohexa-ma ramo Nhandejáry rembigwái, onhemondýi Zacarias. Ndoikwaái mba'e pa ojapo-ta. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aipo ramo Nhandejáry rembigwái he'i íxupe: —Ani erekyhyje, Zacarias, he'i íxupe. —Nhandejáry ohendu-ma ne rembijerure. Igwaigwĩ eterei jepe ne rembireko ha'e imemby-ta joty. Nde ra'y tee oiko-ta, he'i íxupe. —Oiko-ma ramo embohéry íxupe João-py. João voi heryrã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","—Oiko-ma ramo nde ra'y, erevy'a va'erã. Heta heta-ta kente kwéry ovy'a arã nde ra'y reko porã-rehe, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","—Nhandejáry rovagwy-py nde ra'y oiko-ta heko marangatu va'erã. Ndo'u mo'ãi oporomonga'u va'e. Oiko e'ỹ mboyve Nhandejáry Nhe'ẽ Marangatu tee oiko-tama ipy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ha heta-pe ombojerovia uka va'erã Nhandejáry-rehe nde ra'y. Gwe'ýi kwéry, Israel remiarirõre kwéry, ombojerovia uka va'erã Tupã Nhandejáry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nhandejáry nhe'ẽ-py omombe'u va'etykwe Elias amyrĩ-rami oiko-ta nde ra'y, he'i íxupe. —Nhandejáry ombopu'aka-ta íxupe, omoarandu-ta íxupe ogwata hagwã gwenonde-rupi. Inhe'ẽ-rupi kente kwéry ogwerova arã gwekoha. Upéixa-gwi túvy ipy'a porã va'erã gwa'ýry ndive. Heta nhe'ẽrenduse e'ỹha omoarandu arã heko porã hagwã. Upeixagwarã nde ra'y oiko-ta, he'i Nhandejáry rembigwái Zacarias-pe ta'ýry-rehe omotenonde-vy hesegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Upe-ma ramo Zacarias he'i: —Mba'éixa ko arovia-ta ne nhe'ẽ? he'i íxupe. —Xe, xe tuja-ma, xe rembireko igwaigwĩ-ma ave, he'i joty ndogweroviái-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Upéi Nhandejáry rembigwái he'i íxupe: —Xe Gabriel, Nhandejáry rembigwái. Hendivegwa voi xe, he'i íxupe. —Ha'e xe mbou amombe'u hagwã nde-vy inhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Anhetegwa nhe'ẽ amombe'u kuri nde-vy. Ha nde, ndereroviái joty xe nhe'ẽ. Ndereroviái-gwi, nerenhe'ẽ mo'ãvéi-ta. Nde ra'y oiko rire ae, erenhe'ẽ jevy va'erã. Anhetegwa voi amombe'u kuri nde-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ha upe jave kente kwéry oha'arõ hikwái íxupe oka-py. “Hi'are eterei Zacarias. Ma'erã nosẽi Nhandejáry róga-gwi” he'i joa hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ha Zacarias osẽ-ma ramo koty'i-gwi ndikatuvéi onhe'ẽ íxupe kwéry. “Mba'e tipo? Ma'erã-gwi nonhe'ẽvéi Zacarias?” he'i hese. “Yváy pygwa para'e ojehexa uka íxupe” he'i hese. “Upéixa-gwi para'e nonhe'ẽvéiry” he'i hikwái. Ojepombovava rei omombe'u hagwã mo'ã onhe'ẽ. Ndojeroviái-gwi, opyta inhe'ẽngu Zacarias. Onhe'ẽ jokopa íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Upéi gwĩ omba'apo hagwã áry-py omba'apopa rire, oho jevy gwóga-py Zacarias. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ha upe rire hembireko oha'arõ oiko-vy omemby hagwã. Ha avave-pe nomombe'úi, opyta pyta meme gwóga-py hembireko. He'i ojéupe: “Xe rexakwaa ha xe poriahuvereko-ma Nhandejáry. Are-ma xe ndavy'ái. Naxe membýi-gwi ndavy'ái” he'i. “Atĩ eterei naxe membýi-gwi” he'i. “Ãy katu avy'a voi. Ndaijegwaruvéi arã kente kwéry xéhegwi” he'i. “Ajohu-ta mitã. Avy'a ete” he'i opy'apy-py Zacarias rembireko mitã'i ojohu-tarehe. Cinco jasy-rehema teĩ nomombe'úi avave-pe mitã'i oikotaha. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Ha upe rire, ohasa peteĩ jasy jevy Nhandejáry omondo gwembigwái omombe'u hagwã Maria-pe imembytaha reheha-ma. Omondo gwembigwái yváy pygwa omombe'u hagwã Maria-pe. Héry va'e Gabriel. Upéi Nhandejáry nhe'ẽ-rupi Gabriel ou Galiléia yvy-py. Nazaré tetã-my ou omombe'u hagwã Nhandejáry nhe'ẽ Maria-pe. Maria kunhataĩ rei oiko-vy. Omenda e'ỹ va'e ha imena'ỹ va'e voi Maria. Ndoikói va'e vyteri kwimba'e ndive. Imerã héry José. Mburuvixa Davi amyrĩ remiarirõkwe José. Upe ramo ndoikói vyteri Maria ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ha upéi katu ogwahẽ Nhandejáry rembigwái Maria ha-py. He'i ojehexa uka-vy: —Evy'a katu, Maria, he'i. —Nhandejáry nde rexakwaa-ma. Hembiporavo voi ko nde. Nhandejáry oĩ ne ndive, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Upéi ohendu-ma ramo Maria he'i ojéupe “Mba'e tipo, ma'erã tipo aipo he'i xe-vy?” he'i. “Tupã Nhandejáry rembigwái nipo ra'e ojehexa uka xe-vy ra'e” he'i. “Ma'erã tipo aipo he'i xe-vy?” he'i ojepy'amongeta-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Upe jave Nhandejáry rembigwái he'i jevy: —Ani erekyhyje teĩ. Tupã Nhandejáry ovy'a nde-rehe, nde poriahuvereko voi Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ome'ẽ-ta voi nde-vy ne membyrã, he'i íxupe. —Kunumi voi ne memby-ta. Oiko ramo ne memby, embohéry kuri Hesu-py he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","—Ne memby Nhandejáry voi. Teko jaryrã voi ne membyrã, he'i íxupe. —“Tupãgwasu ra'y” oje'e-ta íxupe. Tupã Nhandejáry nhe'ẽ-py oiko-ta mburuvixagwasu voi ne membyrã. Nhamoigwasu Davi amyrĩ oiko hagwe-rami, oiko-ta mburuvixagwasu ramo judeu kwéry-pe ne memby, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","—Jacó remiarirõ kwéry-gwi oiko va'erã mburuvixagwasu. Avave nohekoviarõi íxupe. Opave'ỹ arã voi ne membyrã mburuvixagwasu ramo oiko-ta. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ohendu-ma ramo inhe'ẽ he'i Nhandejáry rembigwái-pe Maria: —Xe, mba'éixa xe memby-ta, he'i íxupe. —Namendái vyteri niko. Ndaikói vyteri kwimba'e ndive, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—Ndoiko reíry-ta ne membyrã. Nhe'ẽ Marangatu tee-rupi oiko va'erã ne membyrã. Upe ohekokwaa va'e nhe'ẽ-rupi ae oiko va'erã, he'i íxupe. —Tupã marangatu ne membyrã. Imarangatu va'erã voi ne memby. Upéixa-gwi he'i arã hese hikwái “Nhandejáry Tupãgwasu ra'y” he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","—Ha nde ryke Isabel ave, igwaigwĩ-ma jepe imemby-ta joty, he'i omombe'u-vy íxupe. —Nde'ivéi arã hese “Ikatu e'ỹ-gwi naimembýi Isabel”. Ãy oha'arõ oiko-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","—Nhandejáry-pe ndaipóri ikatu e'ỹ va'e. Ohekokwaa hagwã ndahekorasýi voi Nhandejáry-pe. Ohekokwaapa va'e opamba'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Upéi Maria he'i: —Iporã. Arovia-ma Nhandejáry-pe, he'i. —Toiko katu hemimbota. Toiko katu ne remimombe'ukwe, he'i rire, ndohexavéi Nhandejáry rembigwái yváy pygwa-pe. Oho jevy-ma yváy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Upe rire, ndahi'aréi Maria oho oipohu hagwã gwyke Isabel-pe. Mombyry oho. Judéia yvy-py oho. Tetã mirĩ-my yvyaty-py oime Zacarias róga. Upe tape-rehe oho Maria. Ha ogwahẽ-ma ramo hóga-py: —Ereikove tipo? he'i oike oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ohendu-ma ramo Maria nhe'ẽ tykéry Isabel ovy'a. Omýi-ma imembyrã ohendu jave Maria nhe'ẽ. Ha Nhandejáry Nhe'ẽ Marangatu tee va'e omohynyhẽ Isabel py'a-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Upéixa-gwi Isabel onhe'ẽ-vy he'i. —Entéro kunha kwéry-gwi nipo nde rovasave ra'e Nhandejáry. Ne membyrã hembihovasa tee voi. Nhandejáry nde rovasa ete-gwi nipo erevy'a ra'e. Ha xe ave, xe mbovy'a kuri, he'i Isabel okypy'ýry Maria-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","—Nde, xe Jaryrã syrã voi, ereju ra'e xe pohu-vy. Avy'a eterei eregwahẽ ramo, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","—Ahendu jave ne nhe'ẽ, xe membyrã ovy'a-ma ave. Omýi-ma kuri ovy'a eterei-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nde ave erevy'a eterei nipo ra'e. Nhandejáry-pe ere ra'e “Arovia-ma. Toiko katu ne remimbota”. Upéixa-gwi nde rovasa ete-ma ra'e Nhandejáry, he'i Maria-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Upéi Maria omboete Nhandejáry-pe: —Xe Járy, he'i, —xe py'apy gwive aporahéi-ta oromboete hagwã oromomba'egwasu eterei-gwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","—Xe py'apy gwive arovy'a Tupã Nhandejáry-pe. Xe resendeha voi upe va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Xe rexakwaa voi xe poriahuvereko hagwã. Xe ko Nhandejáry rembigwái voi jepe, imandu'a joty xe-rehe Nhandejáry. Yvy opa e'ỹ mboyve kente kwéry he'i va'erã xe-rehe: “Tupãgwasu Nhandejáry rembihovasakwe voi upe va'e” he'i va'erã xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Nhande-vy ikatu e'ỹ va'e ojapo xe-vy Nhandejáry xe ruvixa. Héry imarangatu tee va'e, he'i Maria oporahéi-vy Nhandejáry mboete-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Upéi oporahéi jevy. Porahéi-py omombe'u pyahu jevy Maria: —Entéro ojerovia va'e gwive hese poriahuverekoha voi ha'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yvy apy-rehe gwive heta mba'e porã opu'aka-rupi ojapo Nhandejáry. Onhemomba'egwasu rei va'e-pe omosarambi ha'e ponove oakã-gwi rei ojapo opamba'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mburuvixagwasu imbaraete va'e kwéry jepe oipe'a omanda oikovyha-gwi kente rei-rami jevy oiko hagwã. Ha omomba'egwasu eterei heko'ive va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iporiahu va'e-pe heta imba'e porãrã ome'ẽ va'erã. Ivare'a va'e-pe ave ome'ẽ hemi'urã. Ha imba'e retave va'ekwe jepe omondo ipo nandi reheve he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","—Nhane ramoigwasu amyrĩ kwéry-pe omombe'u araka'e Nhandejáry: “Apohovasa-ta, ne remiarirõ kwéry-pe ave ahovasa-ta. Ãy peiko va'erã gwive apohovasa-ta.” Upéixa he'i nhane ramoigwasu Abraão amyrĩ-pe, hemiarirõ kwéry-pe ave. Ha imandu'a katu gwemimombe'ukwe-rehe oiko hagwã he'i va'ekwe. Ipokatu inhe'ẽ. Upéa he'i va'ekwe-gwi oiporiahuvereko meme nhande re'ýi kwéry-pe, Israel re'ýi kwéry-pe. Ohovasa porã nhande-vy Nhandejáry, he'i oporahéi-vy. Maria oporahéi Nhandejáry-pe omboete-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ha upe rire Maria hi'are jevy gwykéry róga-py. Mbohapy jasy ohasa rire, oho jevy gwóga-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Imemby oikotamaha áry-py imemby-ma Isabel. Kunumi voi imemby. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oiko-ma ramo, hóga ypy-rehe oĩ va'e, hapixa kwéry, ha he'ýi kwéry ave ou ogwerohory íxupe imemby jave. —Nhandejáry nde poriahuvereko-gwi ome'ẽ nde-vy ne membyrã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Upéi ogwereko-ma ramo ocho áry ogweraha íxupe oipirekytĩ uka hagwã ha ombohéry hagwã ave. Ha enterove omboheryse íxupe. —Nhambohéry-ta íxupe Zacarias-py, he'i hikwái. Omoĩse mo'ã túvy réry hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","—Ani eremoĩ túvy réry hese, he'i isy. —João ae ambohéry-ta íxupe, he'i isy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ndojohu porãi hikwái. —Ndaipóri nde re'ýi kwéry pa'ũ-my avave héry va'e João, he'i isy-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Upéixa-gwi oporandu hikwái túvy-pe. Onhepombovava hikwái oporandu-vy túvy-pe gwa'ýry reryrã omombe'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Upéi onhepombovava ojerure-vy ome'ẽ uka hagwã ojéupe kwatia. Ome'ẽ-ma rire ohai kwatia-rehe. “João héry” he'i ohai-vy. Omombe'u ramo, “Ma'erã po omboheryse João-py” he'i hikwái opondera-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ha ohai jave gwa'ýry réry, omonhe'ẽ uka jevy íxupe Nhandejáry. Nainhe'ẽnguvéi-ma. Onhe'ẽ porã jevy-ma ha omomba'egwasu Nhandejáry-pe: —Imarangatu tee va'e Nhandejáry, he'i onhe'ẽ-vy. —Ndaipóri ha'eixagwa ohekokwaa va'e, he'i Nhandejáry-pe omboete-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ha entéro oikwaa va'e opy'amirĩ reheve opondera ndera hesegwa hikwái. João rehegwa rerakwã omombe'u mbe'u Judéia yvy-rupi. Tetã ambue mbue mygwa-pe omombe'u mbe'u ave hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ha herakwã renduha kwéry onhemongeta opy'apy-py hese. —Mbava'e tipo ojapo-ta upe kunumi? he'i. —Okakwaa-ma rire, mba'e po oiko va'erã íxugwi? he'i oporandu randu ojóupe. —Ha'e Nhandejáry rembihovasa voi nipo ra'e, he'i ojóupe hese. Ha Nhandejáry ohovasa meme mitã-me. Omombaraete ave íxupe onhe'ẽ-py oiko hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ha upéi katu Nhandejáry Nhe'ẽ Marangatu tee va'e omohynyhẽ túvy Zacarias py'apy. Ome'ẽ íxupe hembiporaheirã: ");
INSERT INTO kgkNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Tonhemomba'egwasu katu Tupã Nhandejáry, he'i oporahéi-vy. —Gwe'ýi kwéry Israel remiarirõre kwéry-pe oipytygwõ-ma. Nhane resende-tama. Tuvixa mba'e voi Nhandejáry, judeu kwéry Járy, he'i oporahéi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","—Ombou-ma nhande-vy ipu'aka ete va'e nhane resende va'erã, he'i. —Gwembigwái Davi amyrĩ remiarirõ ombou, nhande re'ýi ete va'e voi, he'i oporahéi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","—Yma va'ekwe Nhandejáry omombe'u ha omotenonde-ma va'ekwe nhane resende va'erã rehegwa nhe'ẽ. Inhe'ẽ-py omombe'u va'ety kwéry heko marangatu ete va'ekwe omohenonde-ma va'ekwe omombe'u-vy hesegwarã voi va'ekwe nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","—Gwĩ nhande rayhu e'ỹ va'e-gwi nhane resende va'erã. Gwĩ nhande-rehe ija'e'ỹ va'e-gwi ave nhane resende ave va'erã imbaraete e'ỹ hagwã nhande-rehe, he'i oporahéi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","—Ha inhe'ẽ-rupi oiporiahuvereko meme araka'e nhane ramoigwasu kwéry-pe Nhandejáry. Imandu'a meme katu onhe'ẽ marangatu-rehe oikopa hagwã omombe'u hagwe-rami. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","—Onhomongeta araka'e nhane ramoigwasu Abraão amyrĩ ndive. He'i íxupe: “Hupigwa va'e voi amombe'u-ta nde-vy. Ne nhemonharã kwéry-pe aresende-ta hese ija'e'ỹ va'erãgwe-gwi xe mboete porã hagwã kyhyje e'ỹ reheve aresende-ta íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Heko marangatu reheve, py'a potĩ reheve xe mboete hagwã. Ko yvy-rehe oiko aja oiko porã meme hagwã xe ndive aresende-ta íxupe kwéry” he'i Nhandejáry. Nhande rehegwarã voi upéa nhe'ẽ Abraão amyrĩ-pe omombe'u araka'e Nhandejáry, he'i Zacarias Nhandejáry-pe omboete-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—Ha nde, he'i Zacarias gwa'ýry-pe hekorã omohenonde-vy íxupe, —Nde-rehe kente kwéry he'i va'erã “Nhandejáry Tupãgwasu nhe'ẽ omombe'u va'ety” he'i va'erã nde-rehe. Nhandejáry ne mondo-ta gwembiporavo va'e renonde-rupi. Ogwahẽtamaha óra-py eremombe'u va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Henonde-rupi ereho-ta eremombe'u-vy nhande re'ýi kwéry-pe. “Nhane resendeharã ou-tama” ere va'erã ereho-vy. “Nhane rembiapo vai omboyke-vy ou-ta. Nhane mopy'a potĩ-vy ou-ta” ere va'erã ereho-vy eremombe'u-vy, he'i. —Nhandejáry renonde-rupi eremombe'u-ta hembiporavo kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","—“Nhandejáry heko porã tee va'e oiporiahuvereko kwaa va'e nhande poriahuvereko va'erã voi” ere va'erã hese. “Nhande rayhu eterei-gwi ombou-ta yváy-gwi nhane resendeharã nhane moaranduharã” ere arã hesegwa nhe'ẽ eremombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","—“Nhande re'ýi e'ỹ resapeharã-rami ave upe ou-ta va'e. Ha'e kwéry pytũ mygwa-rami oiko. Oikwaa e'ỹ va'e Nhandejáry-rehe, ogwerovia e'ỹ-gwi íxupe, omano rire onhehundipa va'erã. Oikwaa uka va'erã íxupe kwéry Nhandejáry remimbota oiko porã hagwã hendive. Ombou-ta nhande-vy nhane resendeharã. Ohexa uka-ta nhande-vy nhane raperã nhane mbopy'agwapy hagwã inhe'ẽ-rupi jaiko hagwã.” Upe Nhandejáry nhe'ẽ eremombe'u meme-gwi he'i va'erã nde-rehe: “Nhandejáry, Tupãgwasu va'e nhe'ẽ-py omombe'u va'ety tee voi” he'i va'erã kente kwéry nde-rehe, he'i Zacarias. Nhe'ẽ Marangatu tee va'e omohynyhẽ íxupe ipy'apy. Upéa-rupi Nhandejáry ome'ẽ inhe'erã omombe'u hagwã gwa'ýry rekorã omotenonde hesegwarã. ");
INSERT INTO kgkNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Upéi okakwaa porã-ma upe mitã. Hi'arandu porã voi upéa oiko-vy. Nhandejáry nhe'ẽ-py oiko, ojerovia ete hese. Ava rekwaty e'ỹ-rupi ogwata gwata oiko-vy. Gwe'ýi kwéry-pe Israel remiarirõ kwéry-pe atýra-py ojehexa uka hagwã áry peve ogwata gwata oiko-vy ava rekwaty e'ỹ-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Quirino oiko jave Síria pygwa kwéry-pe mburuvixa ramo, Augusto ohai uka kwatia. Mburuvixagwasu voi Augusto. Omonhangareko uka entéro yvy pygwa kwéry-rehe. Omomarandu uka íxupe kwéry: “Ohai-ta kwatia-rehe pende réry. Ne ramoigwasu oiko hagwe-py tekotevẽ ereho. Upe-py mante ohai arã nde-vy nde réry.” Upéixa he'i oipapa hagwã entéro yvy pygwa kwéry-pe. Onhypyrũ upe pygwa kwéry-pe héry ohai-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Upéixa-gwi enterove oho. Gwamoigwasu oiko hagwe-py oje'ói-vy hikwái. Ohenói uka-gwi íxupe kwéry oho. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ha José ave oho gwamoigwasu oiko hagwe-py. Osẽ Galiléia yvy-gwi. Nazaré tetã-gwi osẽ oho hagwã Judéia yvy-py. Oho Belém tetã-my. Gwamoigwasu Davi oiko hagwe-py oho ohenói uka-gwi íxupe kwéry. Oho Maria ndive. Imemby-tama jave ogweraha gwembirekorã. Ha hembirekorã teĩ Maria. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Upéi ogwahẽ oje'ói-vy hikwái Belém tetã-my. Ha oime jave upe-py ogwahẽ-ma imemby hagwã áry. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Oiko-ma mitã. Kunumi voi imemby rypykwe. Oiko-ma ramo mitã isy onhugwã omemby huparã-py. Upéi omonheno omemby mymba karu haty-py rei imoĩ-vy. Mbohupa róga-py ndaipóri henagwã-gwi yvyranha'ẽ-py rei omoĩ omonheno-vy omemby-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","Upe-ma ramo gwĩ Belém pygwa-pe ojehexa uka Nhandejáry rembigwái yváy pygwa. Mymba rerekwa kwéry-pe ojehexa uka. Oime jave nhu-my, Belém jerekwe-rehe, pyhare ramo onhangareko gwymba ovexa-rehe. Upéi sapy'a ojehexa uka íxupe kwéry Nhandejáry rembigwái. Hembigwái ojehexa uka jave Nhandejáry omohendy hymba rerekwa jerekwe-rehe. Áry-rami rei hendy íxupe kwéry imarangatu tee va'e. Ohesapeve rei-ma ramo hendy va'e, omopy'amirĩ íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Upéi Nhandejáry rembigwái he'i íxupe kwéry: —Ani nde py'amirĩ teĩ ereiko-vy, he'i íxupe. —Aju pene momarandu-vy. Pene mbovy'a-ta ko nhe'ẽ porã, ha pende re'ýi kwéry-pe ave ombovy'a va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","—Pene resendeharã oiko-ma kuri. Pene ramoigwasu Davi amyrĩ oiko hagwe-py oiko-ma kuri. Mburuvixagwasu voi ha'e. Ha'e ko Cristo, Nhandejáry rembiporavo va'e voi, he'i íxupe. —Pende Járy voi ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","—Mitã'i oime-ma teĩ mymba karu haty-py. Ijao-py onhugwã rire-ma omonheno íxupe hupa-py mymba karu haty-py. Upe-py peho ramo, petopa-ma va'erã pene resendeharã-pe. Kóa nhe'ẽ amombe'u peẽ-my pene rembiexarã peikwaa porã hagwã pene resendeharã oikomaha, he'i Nhandejáry rembigwái ojehexa uka-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Upéa he'i jave heta heta Nhandejáry rembigwái yváy pygwa kwéry ou ojehexa uka okwa-vy íxupe kwéry. Onhe'ẽ va'e ndive oiko-vy ojehexa uka heta hikwái. Ha oporahéi omboete hagwã Nhandejáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Tomomba'egwasu Tupã Nhandejáry yváy pygwa oĩ va'e-pe. Iporã ete eterei Nhandejáry. Avave ha'eixagwa ndoikói. Yvypóry-pe ombopy'agwapy ohexakwaa rei-vy, he'i oporahéi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Upéixa oporahéi rire, oho jevy yváy-py oje'ói-vy hikwái. Oho-ma rire upe mymba rerekwa va'e kwéry he'i ojóupe: —Jaha katu, he'i. —Jaha-ta Belém tetã-my. Jahexa hagwã mba'e tipo oiko upe-py, he'i oje'ói-vy hikwái. —Jahexa-ta ko Nhandejáry omombe'u uka kuri nhande-vy va'ekwe jahexa-ta, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ha pya'e oje'ói hikwái. Ogwahẽ-ma ramo upe-py ojohupa íxupe kwéry. Ohexa isy Maria-pe, ohexa José-pe, ohexa ave mitã'i-pe ave. Ha mitã'i katu onheno oĩ-vy mymba karu haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ha ohexa-ma Nhandejáry remimombe'ukwe. Upéi omombe'u jevy mitã'i rehegwa nhe'ẽ. Nhandejáry rembigwái he'i va'ekwe omombe'u jevy mymba rerekwa va'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ha entéro ohendu va'e opondera-vy rei oiko hikwái. —Mba'eixagwa pa ko mitã, he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ha isy Maria katu opondera ndera oiko-vy. Onhongatu opy'apy-py hesegwa nhe'ẽ. Imandu'a ndu'a opamba'e-rehe oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Upéi hymba rerekwa kwéry oho jevy nhu-my. Oho jave oporahéi hikwái. Omomba'egwasu Nhandejáry-pe oporahéi-vy. —Tupã xe Járy nde tuvixa, he'i oporahéi-vy. —Iporã ete va'e erehexa uka kuri ore-vy. Iporã ete va'e oroikwaa kuri. Nde tuvixa ete, he'i oporahéi omboete-vy. Upe Nhandejáry rembigwái remimombe'ukwe otopa. Upéixa-gwi omboete ete Nhandejáry-pe oiko-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ogwereko-ma ramo oito áry oikytĩmirĩ uka mitã pire. Judeu va'e ra'y-gwi Nhandejáry réry-py oipirekytĩ íxupe. Oipirekytĩ uka rire íxupe ombohéry “Hesu” he'i íxupe. Nhandejáry rembigwái yváy pygwa omombe'u ramo oiko va'erãha omombe'u ave heryrã. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ha upe rire ogwahẽ-ma isy-pe, tuvanga-pe ave hi'óra ojapo hagwã Nhandejáry nhe'ẽ. Ohai uka va'ekwe Moisés amyrĩ-pe mba'éixa pa onhemopotĩ jevy kunha oiko-ma rire mitã. Upéixa-gwi oho Jerusalém tetã-my. Mitã'i ave ogweraha ohexa uka hagwã pa'i-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Moisés amyrĩ rembihaikwe he'i ave entéro judeu kwéry-pe “Ne mitã ypykwe kwimba'e ramo ereme'ẽ íxupe Nhandejáry pegwarã”. Upe Nhandejáry nhe'ẽ ojapo hagwã ogweraha íxupe Jerusalém-my, Nhandejáry róga kakwaa-py ogweraha íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mokõi gwymba ave ogweraha. Moisés rembihaikwe Nhandejáry nhe'ẽ: “Oiko-ma ramo mitã'i, erehapy uka mokõi ne rymba Nhandejáry-pe eremboete-vy” he'i va'ekwe ohai-vy. “Pa'i ojuka va'erã ohapy va'erã ereme'ẽ íxupe” he'i. “Pykasu ramo, mokõi pykasu ave eraha erehapy uka va'erã. Pyku'i ramo, mokõi pyku'i ave eraha erehapy uka va'erã.” Upéixa ohai uka va'ekwe Nhandejáry. Upéa ojapo hagwã oho hikwái Jerusalém-my. Upéa ojapo-vy oho hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","27","Ha ogwahẽ-ma ramo, oike Nhandejáry róga kakwaa-py. Nhandejáry nhe'ẽ ojapo-gwi oike. Oike jave oĩ ave upe-py peteĩ kwimba'e, héry va'e Simeão. Nhandejáry-rehe ojerovia eterei va'e Simeão oiko Jerusalém tetã-my. Hekoha porã Nhandejáry renonde-py. Imarangatu va'e. Nhandejáry rembiporavo va'e ogwahẽtaha óra ra'arõ-vy oiko Simeão. Israel remiarirõ kwéry ombopy'agwapy va'erã oha'arõ oiko-vy. Ha Nhe'ẽ Marangatu tee va'e oiko ipy'apy-py. Henonderã omombe'u araka'e íxupe: —Nde, Simeão, he'i íxupe Nhe'ẽ Marangatu tee va'e —erehexa-ta Nhandejáry rembiporavo va'e. Íxupe erehexa rire ae mate eremano va'erã, he'i íxupe. —Erehexa e'ỹ reheve neremano mo'ãi, he'i íxupe omombe'u mbava'e oiko-ta va'e íxupe. Upe rire Nhe'ẽ Marangatu tee va'e he'i íxupe oho hagwã Nhandejáry róga kakwaa-py. Ha upe-py oĩ jave oike Hesu sy, tuvanga ave ogweru Hesu-pe upe-py Nhandejáry nhe'ẽ ojapo hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Upéi Simeão ohupi Hesu mitã'i ojyva ári. Omboete ete Nhandejáry-pe, mitã'i-rehe he'i: ");
INSERT INTO kgkNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","—Xe Járy, yváy-py ereiko va'e, atima porã nde-vy ko mitã'i-rehe. Ko va'e ne rembiporavokwe ra'e, ne remimbou voi ra'e. Ko va'e ore resendeharã ra'e ahexa-ma katu. Ne remimbou ohexa-ma yvypóry. Erembou íxupe entéro opa opa kente ambue mbue kwéry-pe, judeu e'ỹ va'e-pe omo'arandu hagwã, pytũ-my rei oiko va'e-pe arakatu-py ae omoingo hagwã. Ne remimbota oikwaa va'erã. Nde pu'akaha reheve oikwaa uka-ta ave nde rekoha marangatu tee Israel remiarirõre kwéry-pe. Ko mitã katu ne remimbou ore resendeharã. Xe py'agwapy-ma. Ahexa-ma ore resendeharã. Naha'arõvéi-ma ore mbopy'agwapyharã-pe. Ahexa-ma katu íxupe. Xe mbovy'a voi. Xe, ne rembigwái, amano ramo jepe xe py'agwapy-ma va'erã aiko-vy. Ne remimombe'ukwe ãy ahexa-ma, he'i Nhandejáry-pe omboete-vy Simeão. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ha Hesu sy, tuvanga ave ohendu-ma ramo “Mba'eixagwa po ko mitã” he'i opondera-vy mitã'i-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Upéi Simeão omondo onhe'ẽ Nhandejáry-pe ohovasa hagwã íxupe kwéry. Upe rire Maria-pe, Hesu sy-pe he'i: —Ejeapysaka porã katu xe nhe'ẽ-rehe, he'i isy-pe. —Ko mitã'i Nhandejáry rembiporavo tee va'e voi, he'i. —Ombojoavy avypa va'erã Israel remiarirõre judeu kwéry. Ha'e kwéry onhemongeta va'erã hese opy'apy-py. Ha onhemongetaha Nhandejáry oikwaa uka va'erã enterove-pe. Heta voi ndaija'éi va'erã hese, ha upéa-rehe Nhandejáry ombohasa asy-ta íxupe kwéry. Heta ave ojerovia va'erã hese. Íxupe kwéry oresende va'erã. Oikwaa va'erã onhemongetaha okwa-vy. Ha nde, isy, eremboasy-ta íxupe. Ne memby-rehe ne mytu'e'ỹ-gwi, nde py'a kutu va'erã, he'i omotenonde-vy Maria-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Upéa he'i jave Simeão, igwaigwĩ ete va'e ogwahẽ-ma. Nhandejáry nhe'ẽ-py omombe'u va'ety upe kunha. Aser re'ýi gwigwa. Fanuel rajy. Héry Ana. Ha igwaigwĩ voi. Kunhataĩ ramo omenda araka'e. Upéi, sete ro'y rire omano ime. Ime omano rire-ma hi'are jevy. Ohupity-ma oitenta e quatro ro'y tembirekokwe ramo rei-ma oiko. Ha oiko meme joty Nhandejáry róga kakwaa-py. Nosẽi voi upe-gwi oiko-vy. Omboete ete Nhandejáry-pe oiko-vy upe-py. Áry ramo, pyhare ramo ave omboete ete oiko-vy. Omondo mondo ave onhe'ẽ Nhandejáry-pe. Okaru e'ỹ reheve omondo mondo onhe'ẽ Nhandejáry-pe ojerovia tee-gwi hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ha Simeão omombe'u jave mitã'i rehegwa nhe'ẽ, ogwahẽ-ma Ana ou-vy. Omondo onhe'ẽ Nhandejáry-pe. He'i: —Atima voi nde-vy xe Járy, he'i. —Nde pu'aka tee va'e xe mbovy'a eterei, xe Járy. Ahexa-ma ore resendeharã, he'i omboete-vy mitã'i Hesu rexa-vy. Upe rire omombe'u mbe'u mitã Hesu rehegwa nhe'ẽ heta judeu kwéry-pe. Gwesendeharã oha'arõ va'e-pe Jerusalém tetã mygwa-pe omombe'u igwahẽha. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ha ojapopa-ma ramo Nhandejáry remimombe'ukwe mitã ypykwe kwimba'e-rehe, oho jevy gwóga-py. Galiléia yvy-py, Nazaré tetã-my oime hóga. Ojapopa rire, ohexa ukapa rire, ogweraha jevy-ma íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Upéi imbaraete okakwaa-vy. Hi'arandu porã-ma voi Hesu. Nhandejáry rembihovasa voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ha túvy kwéry oho meme hikwái Jerusalém-my. Aretegwasu páscoa áry ohasa meme hagwã upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hesu ogwereko-ma ramo doze ro'y oho indive kwéry Jerusalém-my páscoa áry ohasa hagwã upe-py. Judeu kwéry reko-rupi oho hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ohasa-ma rire aretegwasu oho jevy-ma hikwái gwóga rape-rupi. Ha ohokwe-vy he'ýi kwéry anho-ma oje'ói hikwái. Ha Hesu katu nomoirũi íxupe kwéry oje'ói ramo. Ha ha'e opyta Jerusalém-my. Ha túvy kwéry ndoikwaái ipytaha. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Gwapixa kwéry ndive oho Hesu” he'i mo'ã hese. Ha ka'aru-ma ramo ae oheka mo'ã íxupe. Ha ndotopáiry. Gwe'ýi kwéry ndive ndoikóiry ave. Gwapixa kwéry ndive ndoikóiry ave. Upe pygwa pa'ũ-rupi oheka rei ave íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Íxupe ndojohúi-gwi oho jevy tuvanga, isy ave. Jerusalém-my Hesu reka-vy oho jevy. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Upe rire, ohasa-ma rire mbohapy áry otopa jevy íxupe. Nhandejáry róga kakwaa-py ogwapy oĩ-vy. Gwĩ Nhandejáry nhe'ẽ mbo'eha mbyte-py ogwapy oĩ-vy. Hesu ojeapysaka saka ohendu hagwã inhe'ẽ oiko-vy Hesu. Oporandu randu ave íxupe kwéry Nhandejáry nhe'ẽ oikwaave hagwã. Onhomongeta ave hendive kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ha onhomongeta jave porombo'eha kwéry ndive heta kente kwéry ohendu va'e ave. Ha'e kwéry opondera ndera voi hese hi'arandu eterei-gwi. Oporandu ramo íxupe, hi'arandu voi omombe'u hagwã oporandu va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Upéixa oiko jave ogwahẽ tuvanga, ha isy ave. Isy ohexa-ma ramo Hesu-pe he'i “Ma'erã po opyta ra'e ko'apy?” he'i opondera-vy hese. Upéi isy he'i íxupe: —Ma'erã-gwi ko va'e erejapo ore-vy? Ne ruvanga ndive orojapura voi kuri nde-rehe. Oroheka heka voi kuri nde-vy oroiko-vy, he'i íxupe isy onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ha'e katu he'i osy-pe: —A-py voi aime, he'i osy-pe onhemombe'u-vy. —Xe rendagwe-rupi xe reka rei ereiko-vy. Ndapyta reíry. Xe Ru yváy-py oĩ va'e remimombe'ukwe-rehe apena eterei-gwi apyta ko'a-py, he'i osy-pe. —Tekotevẽ amondo xe resa hese aiko-vy, he'i osy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ha isy, tuvanga ave nohendu kwaái inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Upéi Hesu oho jevy indive kwéry Nazaré-py. Ha tuvanga nhe'ẽ-py oiko. Isy imandu'a ndu'a opy'apy-py hese, omono'õ no'õ hesegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hesu katu okakwaa porã. Hi'aranduve nduve oiko-vy. Nhandejáry ndive kente kwéry ndive ave ipy'a porã ave oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tekwaty e'ỹ-my oiko ramo Zacarias ra'y João Batista, Nhandejáry omombe'u íxupe inhe'ẽrã. Upe jave Tibério César oiko mburuvixagwasu ramo. Ojapo-ma quinze ro'y oiko hagwe mburuvixagwasu ramo upe pygwa kwéry-pe. Ha Judéia yvy pygwa-pe katu Pôncio Pilatos oiko mburuvixa ramo ave. Ha Galiléia yvy pygwa-pe katu Herodes oiko mburuvixa ramo ave. Ha tyvýry Filipe katu oiko mburuvixa ramo Ituréia yvy pygwa-pe, Traconites yvy pygwa-pe ave. Ha Abilene yvy pygwa-pe katu Lisânias oiko mburuvixa ramo ave. Upe mburuvixa kwéry omanda-ma jave, Nhandejáry onhomongeta João Batista ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Upe jave oiko ave pa'igwasu Anás ha pa'igwasu Caifás ave. Pa'i kwéry-gwi imburuvixave va'e upe mokõi va'e. Ha upe jave Nhandejáry omondo João Batista-pe omombe'u hagwã inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Upéixa-gwi oho Jordão ysyry jere-rupi upe pygwa-pe Nhandejáry nhe'ẽ omombe'u mbe'u-vy. Ha upe pygwa okwa va'e kwéry-pe onhemonhe'ẽ ramo João Batista he'i: —Pende rekoha vai eterei. Taperova katu pende rekoha, he'i íxupe kwéry. —Enhemongarai uka katu Nhandejáry nhe'ẽ-rupi ereiko hagwã, he'i. —Nde rekoha ererova ramo, erenhemongarai uka ramo ave, ne rembiapo vaikwe omboyke arã ndéhegwi Nhandejáry, he'i Nhandejáry nhe'ẽ-rupi omombe'u-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nhandejáry nhe'ẽ kwatia-rehe ohai va'ekwe Isaías amyrĩ: “Tekwaty e'ỹ-my ou va'e-pe osapukái va'erã xe nhe'ẽ-py omombe'u va'ety: Ou-tama Nhandejáry rembiporavo va'e, osapukái va'erã ho'e-vy. Pembohape porã katu íxupe, he'i va'erã. Pemopotĩ íxupe haperã. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Entéro yvy pyko'ẽ ko'ẽ gwive emohynyhẽ katu. Eity entéro yvyatyrusu gwive. Entéro yvy atymirĩ ave eity katu erembojoja hagwã haperã. Emokarẽ karẽ e'ỹ katu tape ikarẽ va'e. Emboyke katu ne rembiapo vaikwe ndejéhegwi, he'i va'erã onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Enterove ohexa va'erã Nhandejáry rembiporavo nhane resendeharã voi, he'i va'erã onhe'ẽ hatã-vy tekwaty e'ỹ-my ou va'e kwéry-pe xe nhe'ẽ-py omombe'u va'ety” he'i Nhandejáry nhe'ẽ kwatia-rehe oĩ va'e. Isaías amyrĩ Nhandejáry nhe'ẽ-py omombe'u va'ety omotenonde va'ekwe ohai-vy João Batista rehegwarã nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ha upéixa-gwi Nhandejáry nhe'ẽ-py João Batista omombe'u gwenda-py ou va'e-pe gwive. Ojogweroatypa henda-py onhemongarai uka hagwã. Upéa-rehe João onhemonhe'ẽ íxupe kwéry: —Xáke, he'i. —Kiva'e nhe'ẽ-rupi po ereju erenhemokanhy uka hagwã mo'ã nde rereko asy eteharã-gwi? Mbói ramigwa voi peẽ, pende rekoha vai va'e. Ndikatúi erenhembotavy rei Nhandejáry-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","—Nhandejáry ko oikwaa. Erova tee nde rekoha. Ne rembiapo porãrã-rupi erehexa uka katu nde rekoha pyahurã. Ani ave ere rei nde py'apy-py “Xe Abraão remiarirõre, upéixa-gwi naxe mbohasa asy mo'ãi-ta Nhandejáry” ani ere rei aipo-rami nde py'apy-py. Xe ha'e-ta katu peẽ-my, oipota ramo Nhandejáry, onhe'ẽ-py rei omoingo arã ita-gwi rei Abraão remiarirõrã. Inhe'ẽ pokatu voi Nhandejáry. Opa mba'e rekokwaaha voi ko Nhandejáry, he'i onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","—Ha ndahi'aréi-tama ou hagwã Nhandejáry. Ogwahẽ-tama nhande rekoha vai rexa-vy. Yvyra hi'a vai va'e-rami nhande rekoha vai ramo nhane mbohasa asy-ta. Yvyra oityha-rami nhane mbohasa asy-ta. Oity rire ohapypa. Upe-rami ave omoingo asy-ta hekoha vai va'e-pe. Erova katu nde rekoha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ha ha'e kwéry he'i: —Mbava'e tipo orojapo-ta orogwerova hagwã ore rekoha oroiko porã hagwã Nhandejáry ndive, he'i hikwái oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","João Batista he'i íxupe kwéry: —Mokõi nde kamisa erereko ramo, eme'ẽ peteĩ ogwereko e'ỹ va'e-pe. Ne remi'urã erereko ramo, emboja'o ja'o ereme'ẽ hagwã ogwereko e'ỹ va'e-pe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Upéi gwĩ plata-py oporombopaga va'ety kwéry ave ou onhemongarai ukase-vy íxupe: —Ha ore tipo, he'i, —mbava'e tipo orojapo-ta? he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ha João Batista he'i: —Ereporokobra ramo, ani erembopaga hepy eterei. Ani eremombyta ndejéupe peipe'ave va'ekwe, he'i oporombopaga va'ety kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Upe rire soldado kwéry ave oporandu íxupe: —Ha ore tipo, he'i, —mbava'e tipo orojapo-ta orogwerova hagwã ore rekoha? he'i oporandu-vy. João he'i íxupe: —Ani pene rembiapo vai avave-rehe. Ani pembohasa asy avave-pe peipe'a vai hagwã íxugwi iplata. Ani ave pende apu avave-rehe nde platarã ome'ẽ hagwã peẽ-my. Pene rembiapo repy-rehe ani katu erenhe'ẽ rei rei ereiko-vy. Pevy'a joty, he'i onhemonhe'ẽ-vy soldado kwéry-pe oipe'a uka hagwã ha'e gwekoha vaikwe. —Pende rekoha porã katu, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Upeixagwa onhemonhe'ẽ ramo, kente kwéry onhemongeta opy'apy-py: —Hi'are-ma nhaha'arõ Nhandejáry rembiporavo tee va'e ou hagwã. Ogwahẽ vyteri para'e, nogwahẽi-ma para'e. João nipo ra'e Nhandejáry rembiporavo tee voi ra'e? Ha'e Cristo voi nipo ra'e, he'i rei João-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ha João Batista he'i enterovéa-pe: —Xe katu oromongarai y-py. Ou-ta peteĩ va'e xe rapykwerigwa ipu'akave va'e xéhegwi. Amboete eterei-gwi íxupe, atĩ amba'apo hagwã íxupe. Ha'e niko nane mongarai mo'ãi xe oromongaraiha-rami. Ha'e niko ombou-ta nde-vy Nhe'ẽ Marangatu tee va'e omohynyhẽ hagwã nde py'a erehupity hagwã nde rekoha porãrã. Temimombokwe jahapyha-rami ave ombou va'erã tata nde reko tujakwe pe'a-vy ndéhegwi, he'i Hesu rekorã mombe'u-vy João Batista. He'i ave: ");
INSERT INTO kgkNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","—Trigo rehegwa nhe'ẽ-rami aiporu-ta ereikwaa porãve hagwã Nhandejáry ogwahẽha rehegwa nhe'ẽ, he'i. —Jaipiro trigo-gwi ipire. Ha'ỹigwe katu hyru-py nhanhongatu imoĩ-vy ha ipirekwe katu nhamboaty jahapy hagwã. Upeixagwa pire oipiro va'e-rami nhande rereko arã. Ha'e nhande rekokwaaha. Hese ojerovia va'ekwe hendive opyta va'erã. Hese ojerovia e'ỹ va'ekwe trigo pirekwe-rami omboaty-ta tata-py. Tata opave'ỹ-my voi oiko-ta ohasa asy meme hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Upéixa voi onhemonhe'ẽ kente kwéry-pe. Nhandejáry Hesu rehegwa nhe'ẽ porã omombe'u mbe'u voi oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hembiapo vai-rehe onhemonhe'ẽ voi íxupe kwéry João Batista. Upéixa-gwi mburuvixagwasu Herodes-pe ave onhemonhe'ẽ. —Ne rembiapo vai nde ryvy-rehe, he'i íxupe. —Hembirekokwe ereipe'a araka'e íxugwi eremenda hagwã hese. Naiporãi voi erereko Herodias nde rovajare-pe. Ne rembiapo vai meme-ma nde. Nde rekoha vai voi, he'i mburuvixagwasu Herodes-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Upéa-rehe ojapo vai eteve jevy Herodes. Oipokwa uka João Batista-pe oapresa hagwã imoĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ne'írã oiko preso ramo João Batista omongarai heta kente kwéry-pe. Ha upe rire, omongarai ave Hesu-pe. Hesu onhemongarai jave omondo onhe'ẽ Nhandejáry-pe oiko-vy. Ha upe jave yváy-gwi ogwejy Nhe'ẽ Marangatu tee va'e ou-vy. Pykasu-rami ojehexa uka ogwejy-vy Hesu-rehe. Ha upe jave ohendu ave yváy-gwi onhe'ẽ va'e: —Nde xe ra'y tee va'e, xe rembihayhu tee voi nde, he'i Hesu-pe. —Nde xe mbovy'a voi ereiko-vy, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ogwereko-ma ramo trinta ro'y, Hesu onhepyrũ-ma oporombo'e mbo'e-vy. “José ra'y tee voi” he'i rei va'e hese heta oĩ. Tuvanga mate José. Ha José ratyu Eli. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Upéi myamyrĩ nhamoigwasu kwéry ko va'e: Eli Matã ra'y. Matã Levi ra'y. Levi Melqui ra'y. Melqui Janai ra'y. Janai José ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatias ra'y. Matatias Amós ra'y. Amós Naum ra'y. Naum Esli ra'y. Esli Nagaí ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaí Máate ra'y. Máate Matatias ra'y. Matatias Semei ra'y. Semei José ra'y. José Jodá ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodá Joanã ra'y. Joanã Resá ra'y. Resá Zorobabel ra'y. Zorobabel Salatiel ra'y. Salatiel Neri ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui ra'y. Melqui Adi ra'y. Adi Cosã ra'y. Cosã Elmadã ra'y. Elmadã Er ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josué ra'y. Josué Eliézer ra'y. Eliézer Jorim ra'y. Jorim Matã ra'y. Matã Levi ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi Simeão ra'y. Simeão Judá ra'y. Judá José ra'y. José Jonã ra'y. Jonã Eliaquim ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Meleá ra'y. Meleá Mená ra'y. Mená Matatá ra'y. Matatá Natã ra'y. Natã Davi ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davi Jessé ra'y. Jessé Obede ra'y. Obede Boaz ra'y. Boaz Salá ra'y. Salá Naassom ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naassom Aminadabe ra'y. Aminadabe Admim ra'y. Admim Arni ra'y. Arni Esrom ra'y. Esrom Farés ra'y. Farés Judá ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacó ra'y. Jacó Isaque ra'y. Isaque Abraão ra'y. Abraão Terá ra'y. Terá Nacor ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serugue ra'y. Serugue Ragaú ra'y. Ragaú Fáleque ra'y. Fáleque Éber ra'y. Éber Salá ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salá Cainã ra'y. Cainã Arfaxade ra'y. Arfaxade Sem ra'y. Sem Noé ra'y. Noé Lameque ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameque Metusalém ra'y. Metusalém Enoque ra'y. Enoque Jarete ra'y. Jarete Maleleel ra'y. Maleleel Cainã ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainã Enos ra'y. Enos Sete ra'y. Sete Adão ra'y. Adão Nhandejáry ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hesu py'a omohynyhẽmba Nhe'ẽ Marangatu tee va'e. Upe rire ombou íxupe jevy ysyry Jordão-gwi, ogweraha íxupe tekwaty e'ỹ-my. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Quarenta áry opyta upe-py anháy ruvixa ombojejavy uka mo'ã Hesu-pe. Ha mba'eve ndo'úi upe-py. Upéi ivare'a voi Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Upe-ma ramo anhaygwasu he'i íxupe: —Nde Tupã Nhandejáry ra'y tee ramo, kóa erejapo kwaa arã. Ita-gwi erejapo va'erã mbojape, he'i anhaygwasu Hesu-pe ombojejavy hagwã mo'ã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Hesu katu he'i íxupe inhe'ẽ ojoko-vy: —Nhandejáry ohai uka va'ekwe onhe'ẽ marangatu he'i uka nhande-vy: “Ndaha'éi tembi'u-rehe anho oikove kente kwéry, he'i Nhandejáry onhe'ẽ-py” he'i Hesu anhaygwasu-pe ojoko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","7","Upéi anhaygwasu ogweraha Hesu-pe ijyvate va'e ári. Cerro apyte-py oiko ramo ombojejavyse-gwi he'i Hesu-pe: —Tetã tetã erehexa pa? Entéro tetã yvy arigwa oĩ va'e gwive erehexa pa? Upe oĩ va'e gwive xe mba'e meme voi, he'i íxupe. —Upe oĩ va'e gwive xe-vy onheme'ẽmba va'ekwe. Ame'ẽse va'e-pe ame'ẽ jevy va'erã. Erenhesũ ramo xe-vy, xe momba'egwasu ramo, ame'ẽ va'erã nde-vy, he'i. —Apomomburuvixa va'erã enterove ne mboete hagwã, he'i ombojejavyse-vy mo'ã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ha Hesu katu he'i íxupe inhe'ẽ ojoko-vy: —Nhandejáry ohai uka va'ekwe onhe'ẽ, he'i uka nhande-vy: “Tupã Nhandejáry-pe mante erenhesũ va'erã. Ha'e ae eremboete tee va'erã” he'i nhande-vy Nhandejáry nhe'ẽ, he'i Hesu anhaygwasu-pe inhe'ẽ ojoko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Upe rire anhaygwasu ogweraha jevy íxupe Jerusalém tetã-my. Nhandejáry róga kakwaa apy-rehe omoĩ íxupe. Ombojejavy ukase mo'ã-gwi Hesu-pe he'i: —Nde Tupã Nhandejáry ra'y tee ramo, a-gwi erejeity va'erã yvy-py, he'i íxupe otantea-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","He'i ave —Tupã Nhandejáry nhe'ẽ ohai uka va'ekwe-py he'i: “Tupã Nhandejáry he'i va'erã gwembigwái yváy pygwa kwéry-pe onhangareko hagwã nde-rehe pono mba'e vai ojehu nde-vy, pono erevyapi. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ipo-py nde reraha va'erã pono ererokwa nde py ita-rehe” he'i anhaygwasu Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Upéi Hesu he'i: —Nhandejáry nhe'ẽ-py he'i ave: “Ani katu eretantea teĩ Tupã Nhandejáry-pe hemimbota e'ỹ erejapo-vy” he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Upéi anhaygwasu ndojohuvéi ombojejavy uka hagwã mo'ã. Upe rire anhaygwasu oho sapy'a jevy íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aipo ramo Hesu ou jevy Galiléia yvy-py. Nhandejáry Nhe'ẽ Marangatu tee va'e mbaraete reheve ogwahẽ jevy ou-vy Galiléia yvy-py. Ha enterove herakwã porã ohendu. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ha Hesu oho omombe'u mbe'u ojeporahéi haty-rupi. Ha henduháry kwéry omomba'egwasu íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hesu ogwahẽ jevy okakwaa hagwe-py. Nazaré tetã-my ogwahẽ jevy ou-vy. Ha oiko meme hagwe-rami joty oiko upe-py. Pytu'uha áry-py oho oike ojeporahéi haty-py. Opu'ã onhembo'y omonhe'ẽ hagwã Nhandejáry kwatia nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Upéi ome'ẽ íxupe hemimonhe'ẽrã Nhandejáry nhe'ẽ-py omombe'u va'ety héry va'e Isaías ohai va'ekwe. Oipe'a pe'a ojohu ramo peteĩ nhe'ẽ katu omonhe'ẽ-ma. Omonhe'ẽ ohendu hagwã ojogweroaty va'e: ");
INSERT INTO kgkNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—“Tupã Nhandejáry Nhe'ẽ Marangatu tee va'e oĩ xe py'apy-py. Amombe'u hagwã iporiahu va'e kwéry-pe inhe'ẽ marangatu xe poravo-ma. Preso oiko va'e kwéry-pe ha'e hagwã, Preso ereiko ha-gwi ne mosẽ-tama, ha'e hagwã íxupe kwéry xe mbou. Hesapyso e'ỹ va'e-pe ambohesapyso hagwã xe mbou. Anohẽ hagwã aresende-vy gwĩ ojerereko asy va'e-pe xe mbou. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Enterovéa-pe ha'e hagwã, Ndahi'are ete mo'ãi Nhandejáry oresende hagwã gwa'ýry tee kwéry-pe, gwajýry tee kwéry-pe ave, ha'e hagwã amombe'u-vy xe mbou” he'i omonhe'ẽ-vy kwatia nhe'ẽ Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Upéi omboty kwatia. Ome'ẽ jevy herekwa-pe. Upe rire ha'e ogwapy. Ha entéro upe-py ojogweroaty va'e oma'ẽ hese. Ohexa katu katu íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Upéi Hesu he'i íxupe kwéry onhemombe'u-vy: —Xe rehegwa ohai va'ekwe omotenonde-vy, ãy oiko-ma. Amonhe'ẽ kuri kwatia-py Nhandejáry nhe'ẽ. Xe rehegwa voi nhe'ẽ pehendu-ma kuri, he'i onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ha enterove ohendu va'e ojohu porã Hesu-rehe. Onhomongeta porã Hesu-rehe: —Iporã voi omonhe'ẽ va'e kuri, he'i. —Imarangatu voi inhe'ẽ hemimombe'u, he'i opondera-vy hese. —José ra'y ae nipo ra'e ko va'e, he'i ave opondera-vy ndojeroviaséi-gwi hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Upéi Hesu he'i ave íxupe kwéry: —Pejese mo'ã xe-rehe, “Xe ndaroviái voi. Ndajerovia mo'ãi hese” peje mo'ã xe-rehe. “Ne rerakwã orohendu va'ekwe Cafarnaum tetã mygwa-gwi ogwahẽ va'ekwe ko'a-py. A-py ave ne mongakwaa hagwe-py ejapo hexapyrã-rupi ave ore remiexagwã-rupi ejapo ave” peje mo'ã kuri xe-vy xe-rehe nderejeroviaséi-gwi, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","—Anhetegwa ha'e-ta peẽ-my, he'i. —Nhandejáry nhe'ẽ-py omombe'u va'ety gwetã mygwa-pe nohenduséi voi, he'i Hesu ojerovia e'ỹha-rehe onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","—Napene mandu'a porãi ra'e myamyrĩ nhande re'ýi hekoha kwéry-rehe. Nhande judeu kwéry Nhandejáry re'ýi tee jepe, myamyrĩ kwéry ndojeroviái-gwi hese Nhandejáry ndovy'ái joty. Upéa ereikwaa porã hagwã judeu e'ỹ va'e-pe ójehe ojerovia va'e-pe ohexakwaa porã va'ekwe Nhandejáry, he'i. —Israel remiarirõre judeu kwéry ndojeroviái va'ekwe ójehe jave, Elias amyrĩ-pe omondo va'ekwe oipytygwõ hagwã judeu e'ỹ va'e-pe. Nhandejáry nhe'ẽ-rupi oho. Sidom yvy-py, Sarepta tetã-my omogwahẽ. Judeu e'ỹ va'e-pe jepe Nhandejáry omogwahẽ joty. Peteĩ tembirekokwe-pe mate oipytygwõ. Ha ndaha'éi Israel remiarirõre-pe. Ha'e kwéry katu upe jave ivare'apa rei va'ekwe okwa-vy, hi'are eterei ndokyvéi-gwi. Mbohapy ro'y-rupi, ha seis jasy-rupi ave ndokyvéiry. Hi'upy ndoikovéi. Ha ivare'apa okwa-vy. Nahembi'uvéi. Ha judeu e'ỹ va'e-pe ójehe ojerovia va'e-pe mate oipytygwõ uka Nhandejáry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Upéi he'i jevy: —Nhandejáry nhe'e-py omombe'u va'ety Eliseu amyrĩ oiko jave oime ave heta mba'asy vai-gwi ijai aipa va'e Israel tetã mygwa judeu kwéry. Ha ha'e kwéry-pe nomopotĩry, nombogwerái íxupe kwéry. Peteĩ Israel e'ỹ va'e-pe mate ójehe ojerovia-gwi ombogwera joty. Síria gwigwa va'e-pe ombogwera. Héry va'e Naamã, he'i Hesu onhemonhe'ẽ-vy ojeporahéi haty-py oime va'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Upéi inhe'ẽ renduha ipoxy voi Hesu-rehe “Onhemonhe'ẽ rei nhande-vy Hesu” he'i mo'ã Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ipoxy eterei-gwi opu'ã onhembo'ypa hikwái ogwenohẽ hagwã Hesu-pe gwetã-gwi. Hesu rupive ojeupi oje'ói-vy oity hagwã mo'ã Hesu-pe yvyaty aty apyte-gwi. Upe tetã oime yvyaty aty yke-rehe. Yvateve teve hupive oje'ói oity hagwã mo'ã yvyaty apyte-gwi ojuka hagwã mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ha Hesu katu ohasa rei jepe ipa'ũ-rupi oho-vy. Ohose ha-py oho joty. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hesu ogwejy ou-vy Galiléia yvy-py. Cafarnaum tetã-my ogwahẽ ou-vy. Pytu'uha áry-py omombe'u upe pygwa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ha onhemonhe'ẽ ramo ohendu va'e kwéry opondera hese hikwái. —Onhemonhe'ẽ porã tee nipo ra'e Hesu, he'i hese ojóupe hikwái. —Onhe'ẽ voi omombe'u, he'i. —Oikwaa arandu tee omombe'u hagwã, he'i opondera eterei-vy hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ha upe-py, ojeporahéi haty-py, oĩ ave anháy ojepota va'e. Anháy réry-rupi ae osapukái he'i mo'ã Hesu-rehe: ");
INSERT INTO kgkNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Nde, Hesu Nazaré pygwa, ma'erã-gwi eregwahẽ? Nde katu Tupã Nhandejáry ra'y tee. Ne marangatu voi ko nde. Ore hundi hagwã ereju para'e? he'i Hesu-pe anháy. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Hesu ae oja'o-ma íxupe. Omokirirĩ uka íxupe: —Ekirirĩ katu, he'i íxupe. —Esẽ katu kwimba'e-gwi, he'i íxupe omosẽ-vy. Upéi anháy oity upe kwimba'e-pe yvy-py. Ojogweroaty va'e pa'ũ-my oity rire osẽ-ma íxugwi. Mba'eve jepe ndojapóiry kwimba'e-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ha upe pygwa oĩ va'e kwéry opondera Hesu-rehe. —Mba'eixagwa ko nhe'ẽ? he'i oporandu-vy ojóupe. —Hesu ipu'akave para'e anháy-rehe, he'i. —Ha'e onhe'ẽ-py rei omosẽ anháy kwéry imondo-vy, he'i ojóupe hikwái Hesu-rehe opondera-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Upeíxa-gwi Hesu réry opa-rupi oho. Upe yvy jerekwe-rupi oikwaapa-ma Hesu rehegwa nhe'ẽ herakwã porã eteha. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Osẽ-ma ramo ojeporahéi haty-gwi oho oike Simão róga-py. Ha Simão raixo katu hasy voi oĩ-vy upe-py. Heteraku eterei. Upéa-rehe ojerure hikwái Hesu-pe ombogwera hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Upéi Hesu oho hasy va'e renda-py. He'i: —Epoi íxugwi, he'i mba'asy-pe. Oipe'a heterakukwe íxugwi. Omoro'ysã hete inhe'ẽ-rupi. Okwera-magwi Simão raixo oho omomimói imbohupa remi'urã kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Oike-ma kwarahy. Oupa Hesu renda-py. Ogweru íxupe hasy va'e kwéry. Opaixagwa mba'asy oiporu va'e ogweru henda-py. Ha Hesu ombogwerapa íxupe kwéry. Peteĩ teĩ-rehe omoĩ opo ombogwera hagwã íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Heta anháy omosẽ ave íxugwi kwéry. Osẽ-vy osapukái imombe'u-vy. —Nde Hesu Nhandejáry ra'y tee nde, he'i. Oikwaa voi Hesu-pe. —Nde Cristo voi. Nhandejáry rembiporavo tee va'e voi nde, he'i anháy Hesu-pe. Upéi omokirirĩmba íxupe kwéry. —Ekirirĩ katu. Ani xe mombe'u avave-pe, he'i jevy íxupe Hesu. Omokirirĩmba íxupe kwéry. Ndohejái onhe'ẽ anháy. Omokirirĩ íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ko'ẽmba-ma ramo osẽ oho Hesu anho tekoha e'ỹ-my. Ha heta eta ou hapykwéri oheka heka íxupe. Otopa-ma ramo, he'i Hesu-pe: —Ani ereho teĩ. Epyta katu ko'a-py. Ani ore reja rei ereho-vy, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Upéi Hesu he'i: —Tekotevẽ aha tetã ambue mbue-rupi. Gwĩa-rupi ave taha tamombe'u Nhandejáry nhande ruvixarã rehegwa nhe'ẽ porã, he'i. —Upe va'e ajapo hagwã xe mbou Nhandejáry ko yvy-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Upe rire oho Hesu opa-rupi. Galiléia yvy jerekwe-rupi oho. Ojeporahéi haty haty-rupi ogwahẽ omombe'u hagwã nhe'ẽ oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","—Ha upéi katu onhemonhe'ẽ jevy-ma Hesu yugwarusu rembe'y-py. Genesaré yugwarusu héry. Ha heta eterei ijatypa henda-py ohendu hendu Nhandejáry nhe'ẽ hemimombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Upe jave Hesu ohexa mokõi kanoagwasu. Y rembe-rehe oĩ kanóa. Pira jopoihaty osẽsẽ kuri ra'e hikwái. Okyha pira mbo'a haty kwéry ojohéi-vy osẽsẽ ijáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Upéi oike Hesu kanóa-py. Simão mba'e voi kanóa. Aipo ramo Hesu he'i Simão-pe: —Jaha mixĩ y rembe'y-gwi enterove ohendu porã hagwã xe nhe'ẽ. He'i-vy ogwapy-ma kanóa-py. Ogwapy jave onhemonhe'ẽ nhe'ẽ ojogweroaty va'e-pe. Ojeapysaka Hesu remimombe'u-rehe ohendu hagwã yvy-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Opa-ma, onhemonhe'ẽ rire he'i Simão-pe: —Jaha hypyve ha-py ereity hagwã nde kyha heta pira ereipyhy hagwã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ha Simão katu he'i: —Oromba'apo kuri, mbo'eháry. Pyhare puku jave oromba'apo ha mba'eve norogwenohẽi. Ne nhe'ẽ-py ae oroity jevy-ta ore kyha kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","He'i-vy ombogwejy jevy hikwái ombo'a hagwã pira. Hesu nhe'ẽ-py oity jevy okyha opira jopói-vy. Upe rire heta pira oipyhy. Haimete omondoro kyha. Pira ipohýi eterei-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Upe-ma ramo ohenói opytygwõharã inhirũ kanóa ambue pygwa kwéry. Upéi ou hikwái omohynyhẽ kanoagwasu kwéry-py pira. Pira ipohýi eterei-gwi haimete-ma onheapymĩ kanóa mokõive va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pira heta eterei-ma ramo onhesũ Hesu renonde-py Simão Pedro Hesu omboete-vy. He'i íxupe: —Xe Járy, ejei katu xéhegwi. Xe py'a ky'a eterei aiko hagwã ne ndive, atĩ eterei aiko hagwã ne ndive, he'i Simão opondera ndera Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Heta eterei pira-gwi opondera hese. Inhirũ gwéry ave opondera ndera Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tiago, João ave opondera ave. Simão ndive ojopói meme upe mokõi Zebedeu ra'y. Onhemongeta opy'apy-py Hesu-rehe oiko-vy hikwái. “Mba'éixa po oikwaa Hesu pira-rehe?” he'i opondera-vy. Ha Hesu he'i Simão-pe: —Ani eretĩ teĩ xéhegwi, he'i. —Ãy erenhypyrũ-ta Nhandejáry nhe'ẽ eremombe'u-vy. Ne nhe'ẽ rendu ramo, heta kente kwéry xe moirũ va'erã. —Iporã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Upéi ogweru jevy okanóa kwéry y rembe-py omoĩ. Ha oheja okanóa oho Hesu omoirũ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hesu oime jave tetã-my ogwahẽ hasy vai va'e. Mba'asy vai oipiremboaipa íxupe. Ohexa-ma ramo Hesu-pe, onhesũ henonde-py. Ovapy-py ho'a oĩ-vy omboete-vy Hesu-pe. Ojerure rure íxupe: —Xe Járy, nde porombogwerahaty voi nde. Nde ae xe rexakwaa ramo xe mbogwera hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hesu katu oipyso-ma opo hese: —Xe katu orohexakwaa voi, he'i omoĩ opo hese-vy ombogwera hagwã íxupe. —Tane mopotĩ katu ko mba'asy vai-gwi, he'i íxupe ombogwera hagwã. Onhe'ẽ jave íxupe okwera-ma. Hesu opoko hese va'e ijai va'ekwe okwerapa-ma. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Upéi he'i jevy íxupe: —Aníke eremombe'u avave-pe, he'i. —Tereho mani ehexa uka pa'i-pe erekweramaha, he'i. —Eme'ẽ íxupe upe myamyrĩ Moisés he'i va'ekwe ereme'ẽ hagwã erenhemopotĩ jevy hagwã. Upéixa oikwaa-ta enterove erekweramaha, he'i omondo-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ha opa-rupi omosarambi Hesu rerakwã. Upéa-gwi hetave tave ojogweroaty henda-py ohendu hagwã inhe'ẽ onhembogwera uka hagwã ave entéro imba'asy-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hesu oho joty tekwaty e'ỹ-my Nhandejáry-pe ombojeupi-vy onhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Upéi Hesu omombe'u jevy Nhandejáry rehegwa nhe'ẽ porã. Óga py-py ogwapy va'e kwéry ohendu. Oĩ upe-py fariseu va'e kwéry. Oĩ Moisés amyrĩ rembihai va'ekwe omombe'u va'e kwéry. Opa rupi-gwi ha'e kwéry ou. Galiléia yvy jerekwe-rehe tetã'i tã'i-rupi oĩ va'e gwive ou, Judéia yvy jerekwe-rehe tetã'i tã'i-rupi oĩ va'e gwive ou ave. Jerusalém tetãgwasu-gwi ou ave. Ha Nhandejáry ombopu'aka Hesu ombogwera gwera hagwã hasy va'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Upe jave gwĩ kwimba'e kwéry ogweru hajy jeapa va'e. Hupa reheve ogweru Hesu renda-py. Ha ndaikatúi oike. Mba'éixa oike arã óga-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Heta eterei ojogweroaty-gwi ndikatúi ogwerohasa hasy va'e-pe okẽ-rupi. Upéa-gwi ojeupi oipe'a óga arigwa. Ombokwa Hesu ári. Ikwa-rupi ombogwejy hajy jeapa va'e. Hupa reheve ombogwejy gwejy íxupe. Ojogweroaty va'e pa'ũ-my, Hesu renonde-py omoĩ hasy va'e ombogwejy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ohexa-ma íxupe kwéry Hesu. Oikwaa-ma ojerovia etemaha ójehe. Upéa-gwi he'i hajy jeapa va'e-pe: —Amboyke-ma ne rembiapo vaikwe ndéhegwi, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ha judeu rekombo'ehaty kwéry, fariseu kwéry ave upe-py oĩ va'e onhepy'amongeta-vy ogwapy okwa-vy. “Onhe'ẽ vai rei nipo ra'e upe va'e. Onhemonhandejáry rei ra'e” he'i mo'ã hikwái Hesu-rehe. “Tupã Nhandejáry ha'e anho mante omboyke va'e nhandéhegwi nhane rembiapo vaikwe. Ha'eixagwa ndaipóri voi. Ndaipóri ambue omboyke va'erã nhane rembiapo vaikwe” he'i. “Ma'erã, Amboyke-ma ne rembiapo vaikwe ndéhegwi, he'i kuri Hesu. Onhemonhandejáryse mo'ã” he'i rei hikwái Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Upéi Hesu he'i íxupe kwéry: —Ma'erã-gwi aipo-rami ere nde py'apy-py xe-rehe? he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—Mbava'e pa hasyve jajapo hagwã nhambogwera íxupe para'e, nhamboyke hembiapo vaikwe íxugwi para'e? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","—Nhambogwera ramo pya'e enterove oikwaa arã. Ha nhamboykepa ramo hembiapo vaikwe íxugwi ndajahexáiry. Ajehexa uka-ta nde-vy xe ko ipu'aka tee va'e voi. Xe ko Nhande Ryke'y tee va'e amboyke kwaa voíte hembiapo vaikwe aporombogwera kwaa ave, he'i. —Xe nhe'ẽ-py joty amboyke yvy arigwa rembiapo vaikwe. Upéa peikwaa hagwã anhe'ẽ-ta hajy jeapa va'e-pe ambogwera hagwã íxupe, he'i Hesu. Upéi katu he'i hajy jeapa va'e-pe: —Epu'ã katu. Tereho nde róga-py. Eraha nde rupa ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aipo ramo inhe'ẽ-py opu'ã oho-vy. Enterove rovagwy-rupi opu'ã ohupi-ma gwupagwe heraha-vy. Gwóga-py oho jave omomba'egwasu-ma Tupã Nhandejáry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Upéa-gwi enterove opondera eterei Hesu-rehe hikwái. Onhemondýi okwa-vy. Otĩmba ete-ma hikwái. —Nhandejáry pu'aka-rupi nipo ombogwera ra'e, he'i. —Ipu'aka tee va'e jepe imandu'a porã nhande-rehe Nhandejáry, he'i omomba'egwasu-ma Nhandejáry-pe hikwái. —Ãy hembiapo porã hexapyrã-ma nipo ra'e jahexa-ma. Ohexa uka-ma nhande-vy heroviapyrã, he'i opondera-vy hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Upe rire-ma osẽ oho-vy. Ohexa plata-py governo pegwarã nhane mbopaga uka va'ety-pe. Héry va'e Levi. Ohexa íxupe ogwapy oĩ-vy nhane mbopaga haty-py. He'i íxupe: —Eju, xe moirũ, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ha upéi katu opu'ã, ohejapa omoirũ hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Upe rire Levi omongaru heta inhirũ gwéry-pe. Hesu ndive okaru hagwã ohenói íxupe kwéry. Oĩ upe-py heta nhane mbopaga va'ety. Levi remienói kwéry pa'ũ-my oime hikwái. Ogwapy oĩ-vy okaru va'e renda-py. Hesu ndive okaru ave hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ha gwĩ fariseu kwéry judeu rekombo'ehaty kwéry gwive hemimbo'e kwéry-pe onhe'ẽ rei rei: —Ma'erã-gwi pekaru gwĩ nhane mbopaga va'ety ndive, hekoha vai va'e ndive ave? he'i oporandu-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hesu katu onhemonhe'ẽ oporandu va'e-pe: —Nhane resãi ramo nanhaikotevẽi nhane mbogwerahaty-rehe. Nhande rasy ramo ae nhaikotevẽ-ma va'erã hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Upéixa voi ave hembiapo vai va'e oikotevẽ-ma va'erã xe-rehe ave, he'i. —Aju ahenói íxupe ogwerova-ma hagwã gwekoha. “Xe rekoha porã” he'i onhemboete-vy va'e-pe ndajúi ahenói-vy, he'i Hesu onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Upéixa-gwi he'i Hesu-pe: —João remimbo'e kwéry, fariseu remimbo'e kwéry ave heta gwembi'u ogwereko jepe, ohasa meme okaru e'ỹ reheve ombojeupi-vy onhe'ẽ Nhandejáry-pe. Ne remimbo'e kwéry ae okaru joty hoy'u joty ave oiko-vy. Ma'erã tipo upéixa ojapo? Ma'erã tipo ndohasáiry okaru e'ỹ reheve ne remimbo'e kwéry? he'i ojohu vaise mo'ã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Upéi Hesu oiporu omenda va'e rehegwa-rami nhe'ẽ omombe'u hagwã íxupe kwéry. —Ojogweroaty omenda va'erã-rehe. Upéi omenda rire oukwe-vy okaru hikwái. Avave nde'íry arã hendive oĩ va'e-pe ohasa hagwã okaru e'ỹ reheve. Ogwahẽ-ta joty hi'áry ojereraha va'erã íxugwi upe omenda va'ekwe kuri. Ojereraha rire ae, heta jepe ogwereko gwemi'urã, ohasa joty va'erã okaru e'ỹ reheve oiko-vy, he'i Hesu arandu nhe'ẽ oiporu-vy ojéhegwa nhe'ẽ omombe'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ha upéi katu Hesu omombe'u jevy tekoha pyahurã rehegwa nhe'ẽ. Ao nharemenda va'e rehegwa nhe'ẽ-rami oiporu omombe'u-vy. —Ao pyahu-gwi nanhaikytĩry nharemenda hagwã ao tuja-pe. Upéixa nharemenda ramo, ojepoapy arã ra'e ipyahu va'e. Ndojehe'a porãi arã ra'e ituja va'e ndive, he'i Hesu arandu nhe'ẽ oiporu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Upéi katu oiporu jevy arandu nhe'ẽ teko pyahu-rehe omombe'u jevy-vy. Uva rykwere ryru rehegwa nhe'ẽ-rami oiporu. —Nanhanhunhãiry uva rykwere pyahu va'e hyru tujakwe vakapi va'e-py. Nhanhunha ramo, ombovu omondoro arã ra'e gwyru vakapi tujakwe. Osyrypa arã pe uva rykwere osoropa arã hyrukwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Uva rykwere pyahu va'e nhanhunha hyru pyahu-py ave. Upéixa ramo mokõive hi'are porã. ");
INSERT INTO kgkNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ha'e-ta ave peẽ-my: Uva rykwere ituja va'e ho'u rire, ipyahu va'e ndo'uséiry avave. “He porã eterei ko va'e” he'i voi ituja-rehe hikwái, he'i Hesu arandu nhe'ẽ oiporu-vy omombe'u hagwã tekoha pyahu ndaha'éi tekoha tujakwe-rami. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ha upéi katu pytu'uha áry-py oho ogwata Hesu. Kokwe mbyte-rupi oho. Ha hemimbo'e kwéry oipo'o-ma trigo rope. Oipokyty opo-py ho'u hagwã inhapĩgwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ha gwĩ fariseu kwéry he'i íxupe kwéry: —Ma'erã tipo upéixa erejapo? Naiporãi voi jaipo'o trigo rope pytu'uha áry-py, he'i íxupe. —Tekotevẽ japytu'u opa nhane rembiapo-gwi, he'i ojohu vai-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Upéa he'i-gwi Hesu he'i ojohu vai va'e kwéry-pe: —Peẽ, pemonhe'ẽ rei ra'e Nhandejáry nhe'ẽ kwatia-rehe. Napene mandu'áiry nhane ramoigwasu Davi rehegwa nhe'ẽ-rehe. Yma, nahembi'úi-gwi ivare'a eterei va'ekwe myamyrĩ Davi inhirũ gwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Upéa-gwi oike Nhandejáry-pe nhamboete haty-py. Koty-py oike rire, ho'u gwĩ mbojape Nhandejáry rovagwy-py pa'i remimoĩgwe. Upéa ndaikatúi ho'u avave. Nhandejáry ndohejái avave-pe ho'u rei upe mbojape. Pa'i kwéry rembi'u va'e ae upéa. Pa'i e'ỹ ramo jepe ho'u joty va'ekwe Davi. Ome'ẽ ave oirũ gwéry-pe. Ha'e kwéry ho'u ave. Nhandejáry oheja rei íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ha xe katu, xe Nhande Ryke'y tee va'e. Upéa-rupi pytu'uha áry Járy voi ko xe, he'i íxupe kwéry Hesu onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ha upéi katu pytu'uha áry jevy-ma ramo Hesu oike ojeporahéi haty-py. Omombe'u jave ohexa oĩ ave upe-py ipo ijakatúa ypi va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ha gwĩ judeu rekombo'ehaty kwéry, fariseu kwéry ave omangea ngea mo'ã Hesu-rehe omboja reise mo'ã Hesu-rehe nhe'ẽ. “Hembiapo-gwi opytu'u-ta para'e, ndopytu'ú mo'ãi para'e?” he'i ojéupe hikwái. “Ombogwera hagwã omba'apo-ta para'e. Japytu'uha áry-py niporãi nhamba'apo. Ndaha'éi Nhandejáry remimbota” he'i rei ojéupe hikwái. Omboja rei Hesu-rehe nhe'ẽ. Upéixa-gwi Hesu-rehe oma'ẽ oha'arõ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hesu ae ipy'amongetaha jepe oikwaa-ma. Upéa oikwaa jave he'i ipo ypi va'e-pe: —Epu'ã katu. Eju enhembo'y ore mbyte-py, he'i íxupe. Upéixa-gwi ha'e opu'ã ou-vy Hesu rovagwy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Upe-ma ramo Hesu oporandu upe pygwa kwéry-pe. —Aporandu-ta peẽ-my pene arandurã-rehe, he'i íxupe kwéry. —Mbava'e tipo pejohu porãve jajapo hagwã pytu'uha áry-py? Jajapo porã tipo? Jajapo vai tipo? he'i. —Peẽ-my iporã tipo nhaporombogwera pytu'uha áry-py? Iporã tipo japorojuka para'e? Mbava'e pa pejohu porãve peẽ? he'i onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Upéi ojogweroaty va'e-rehe osareko ranhe. Upéi he'i ipo ypi va'e-pe: —Eipyso katu nde po, he'i íxupe. Oipyso-ma ramo opo. Pe ipo ypi va'ekwe okwera-ma. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","—Ombogwera-ma íxupe. Hembiapo-gwi ndopytu'úi Hesu, he'i rei ipoxy-vy hese hikwái. —Nhandejáry remimbota ndojapói ra'e. Mba'e tipo jajapo-ta hese? he'i oporandu randu-vy ojóupe hikwái. Ha ojapo vaise mo'ã Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ha upéi katu Hesu ojeupi oho-vy yvyatyrusu-py. Oho ombojeupi hagwã onhe'ẽ Nhandejáry-pe upe-py. Pyhare-rupi omondo mondo Nhandejáry-pe onhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko'ẽmba-ma ramo ohenói gwemimbo'e kwéry-pe ogwahẽ hagwã henda-py. Upéi oiporavo doze kwimba'e-pe. —Peẽ xe remimondorã kwéry voi, he'i upe doze gwembiporavo kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Oiporavo Simão-pe. Ha ombohéry joa íxupe Pedro. Oiporavo Simão ryvy André-pe ave. Oiporavo Tiago-pe ave, João-pe ave, Filipe-pe ave, Bartolomeu-pe ave, ");
INSERT INTO kgkNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus-pe ave, Tomé-pe ave, Alfeu ra'y Tiago-pe ave, Simão-pe ave. Ha'e gwĩ huvixa ramo oiko va'e-pe omosẽse va'e kwéry irũ va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Hesu oiporavo ave Tiago ra'y Judas-pe ave, Judas Iscariotes-pe ave. Doze kwimba'e-pe oiporavo omombe'u porãve hagwã inhe'ẽgwe. Ha Judas Iscariotes oiko va'erã Hesu pyhy ukaharã. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Upe rire ogwejy jevy gwemimondo va'erã kwéry ndive. Ogwahẽ-ma ramo yvyatyrusu renonde-py opyta. Upe-py heta eta onhe'ẽ renduha kwéry-pe otopa jevy. Heta eta ojogweroaty va'e oĩ ave upe-py ou araka'e Judéia yvy jerekwe rehegwa. Ou araka'e Jerusalém tetã mygwa ave. Ou ave araka'e mombyryvegwa. Ygwasu rembe'y rehegwa Tiro tetã jerekwe rehegwa, Sidom tetã jerekwe rehegwa ou ojogweroaty upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hesu nhe'ẽ rendu-vy ou. Onhembogwera uka hagwã ave mba'asy-gwi ou. Ha gwĩ anháy ombohasa asy va'e-pe ave Hesu ombogwerapa. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ha enterove ojogweroaty aty va'e omoĩse opo Hesu-rehe. Ipu'aka reheve onhembogwera ukase eterei-gwi omoĩse opo hese. Ha ombogwerapa joty enterovéa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ha upéi katu Hesu ojerova-ma oma'ẽ gwemimbo'e kwéry-rehe ohekombo'e hagwã íxupe kwéry. He'i ranhe iporiahu va'e kwéry-pe: —Peẽ, xe-rehe pepena-gwi pende poriahu va'e, pende reko vy'a ete joty peiko-vy. Nhandejáry pende ruvixa tee ndive gwarã voi peẽ. Upéa-gwi pevy'a katu. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—Peẽ pende vare'a va'e pende reko vy'a ete joty peiko-vy. Ãy ae joty pende vare'a. Nhandejáry pene moangapyhy porã va'erã. Upéa-gwi pevy'a. —Peẽ pejahe'o va'e pende reko vy'a ete joty peiko-vy. Ãy ae pejahe'o. Pepuka va'erã. Upéa-gwi pevy'a. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—Peẽ ave, xe moirũ-gwi pende rereko asy va'e, pende reko vy'a ete joty. Xe Nhande Ryke'y tee va'e. Oĩ ramo xéhegwi pende-rehe ndaija'éi va'e, pende joko ramo ave, onhe'ẽ rei rei ramo ave pende-rehe, pevy'a katu. Oĩ ramo nde-vy he'i va'e: “Nde Hesu-rehe erejerovia va'e ndorohexasevéi. Nahendusevéi ave nde réry. Ejei katu a-gwi” he'i ramo nde-vy, evy'a joty kuri eiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aipo-rami pende rereko ramo, pevy'a katu. Erovy'a joty katu nde-rehe hembiapo vai va'e. Pende rexakwaa-ta voi katu peẽ-my Nhandejáry yváy pygwa. Heta voi oĩ nde-vy gwarã yváy-py. Upéa-gwi evy'a katu. Yma va'ekwe myamyrĩ nhane ramoigwasu kwéry upéixa ave ogwereko asy va'ekwe Nhandejáry nhe'ẽ-py omombe'u va'ety kwéry-pe. Yma gware-pe pene renonderã-pe ogwereko asy hagwe-rami ave, ãy pende rereko asy ave va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Upe-ma ramo Hesu onhemonhe'ẽ imba'e reta-rehe ojerovia va'e kwéry-pe: —Peẽ, pene mba'e reta reta va'e, pendejéupe gwarã-rehe mate pepena rei va'e, apomboasy eterei pee-my. Pende reko vy'are'ỹ va'erã. A-py mate pevy'a va'erã peiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Peẽ, mba'eve pene rekotevẽ pene rygwyatã jepe va'e, apomboasy eterei peẽ-my. Pende reko vy'are'ỹ va'erã. Ivare'a ete va'e-rami peiko va'erã. —Peẽ, pepuka va'e, apomboasy eterei peẽ-my. Ãy ae pepuka. Teko rei-rehe pevy'a. Pejahe'o va'erã penheapirõ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Peẽ, opavave pene mboete va'e, apomboasy eterei peẽ-my. Pende reko vy'are'ỹ va'erã. Upéixa ave yma gware nhane ramoigwasu amyrĩ kwéry omboete rei va'ekwe Nhandejáry nhe'ẽ mombe'u a'ã a'ãha rei va'e kwéry-pe. Yma gware-pe pene renonderã-pe omboete rei hagwe-rami ave, ãy pene mboete rei ave. Apomboasy voi peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Ha peẽ, xe renduha kwéry, peẽ-my ha'e tee-ta katu. Peiko porã katu. Ehayhu katu nde-rehe ija'e'ỹ va'e-pe. Ejapo porã katu nde rayhu e'ỹ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ejerure Nhandejáry-pe ohovasa porã hagwã nde-rehe onhe'ẽ rei rei va'e-pe. Ha ne mbohasa asy va'e-rehe ejerure rure joty Nhandejáry-pe ohexakwaa porã hagwã íxupe oiporiahuvereko hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ha nde rova pete ramo, ejerova joty íxugwi eme'ẽ joty íxupe nde rova rovái nde rova pete jevy hagwã. Ha oipe'a ramo ndéhegwi nde kamisa, eheja joty togweraha nde ao jo'a reheve. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nde-vy ojerure va'e-pe eme'ẽ hemimbota. Ha ogweraha ramo ndéhegwi ne mba'e ani erejerureve teĩ joty ne mba'ekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Peiko porã joty. Nde rerekoseha-rami eiko enterovéa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Eiporiahuvereko katu enterovéa-pe. Nde rayhu va'e-pe anho erehayhu ramo, upe ne rembiapo porã-rehe “Hekoha porã voi” nde'i mo'ãiry nde-rehe Nhandejáry. Hekoha vai va'e ave ohayhu kwaa gwapixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nde-vy ojapo porã va'e-pe mante ne rembiapo porã ramo, ani ere upéa-rehe, “Ko xe rembiapo porã-rehe Nhandejáry xe rexakwaa arã”. Hekoha vai va'e kwéry ave ojapo porã ave íxupe hembiapo porã va'e-pe. Nde reko-rami ave oiko hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ha oiporuse va'e-rehe ani ere, “Aiporu uka ramo ko va'e-pe ohekoviarõ porã va'erã xe-vy. Upéixa-gwi aiporu uka-ta íxupe” ani aipo ere teĩ. Aipo he'i ave hekoha vai va'e gwapixa kwéry-rehe. Upéixa ereiporu uka ramo jepe, niporãi arã. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ha'e-ta katu peẽ-my: Ehayhu katu nde-rehe ija'e'ỹ va'e kwéry-pe gwive. Ejapo porã meme katu. Ani ereha'arõ mba'eve-rehe ne rembiporu ukakwe-rehe ome'ẽ jevy va'erã. Ani ere teĩ, “Ndaiporu uka mo'ãi nde-vy xe mba'e”. Eiporu uka rei katu, he'i Hesu ohekombo'e-vy. —Ko xe nhe'ẽ-rupi ereiko ramo, he'i, —pende rexakwaa va'erã voi peẽ-my Nhandejáry yváy pygwa, he'i. —Ha'e he'i arã ave nde-rehe “Xe ra'y, xe rajy” he'i arã ave nde-rehe Nhandejáry Tupãgwasu. Oĩ heta hembiapo vai va'e. Oĩ ave heta Nhandejáry-pe nomboetéi va'e. “Iporã voi Nhandejáry” nde'íry. “Ome'ẽ-ma xe-vy xe remikotevẽ” nde'íry. Ha Nhandejáry katu ipy'a porã hese kwéry. Ome'ẽ me'ẽ íxupe kwéry hemikotevẽ. Nhandejáry, Nhande Ru yváy-py oĩ va'e nhande poriahuvereko meme va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Upéixa-gwi ha'e-ta peẽ-my: Peiporiahuvereko porã enterovéa-pe. Nhandejáry nhande Ru yváy-py oĩ va'e-rami pejoporiahuvereko porã katu. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Ani erehekojohu rei nde rapixa-pe. Ani erejohu vai nde rapixa rembiapo ani hagwã upéixa ave Nhandejáry ojohu vai nde-vy ne rembiapo. Ani ave ere mo'ã teĩ nde rapixa-pe: “Tane mbohasa asy ne rembiapo vaikwe-rehe” ani upéixa ave Nhandejáry he'i hagwã nde-rehe. Eiporiahuvereko katu nde-rehe hembiapo vai va'ekwe-pe. Upéixa nde rapixa-pe ereiporiahuvereko hagwe-rami nde poriahuvereko va'erã Nhandejáry ne rembiapo vaikwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Eme'ẽ katu hemikotevẽ nde rapixa kwéry-pe. Hemikotevẽ ereme'ẽ porã ramo ne remime'ẽgwe rekovia hetave ome'ẽ va'erã nde-vy Nhandejáry. Eremboyru ime'ẽ-vy mba'e ryru-py. Upe va'ekwe-gwi hetave ome'ẽ arã nde-vy. Omohynyhẽve va'erã nde-vy ime'ẽ-vy ne mba'e ryru. Ojapete peteve va'erã imoĩ-vy mba'e ryru-py ome'ẽ hagwã nde-vy ombohekovia-vy hetave ome'ẽ va'erã nde-vy. Nde rapixa ererekoha-rami ave nde rereko arã Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Upe-ma ramo omombe'u íxupe kwéry arandu nhe'ẽ hesapyso e'ỹ va'e rehegwa nhe'ẽ-rami. —Ndovaléi voi hesapyso e'ỹ va'e oporogweraha hagwã. Ndaikatúi voi ogweraha gwapixa hesapyso e'ỹ va'e-pe ave. Ojopopyhy rei arã ojereraha uka mo'ã-vy ohexa e'ỹ-gwi. Mokõive rei ho'a arã yvykwa-py oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Upéixa ave ndaipóri heko tuvixave va'e ombo'eha-gwi. Avave ndaheko tuvixavéi ombo'eha-gwi. Ombo'e hagwe-rupi ae-ma ha'e oiko. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Upéi omombe'u jevy íxupe kwéry nde resa-py oĩ va'e rehegwa nhe'ẽ-rami omombe'u. —Nde, nde resa-py yvyravogwe oĩ va'e, ma'erã-gwi ere nde rapixa-pe “Nde resa-py oĩ yvyra ra'ykwe. Upéixa-gwi nande resapysovéi-ma”. Upéa ere jave tuvixave va'e oĩ joty nde resa-py. Ndovaléi voi ereheka rei hagwã mixĩve va'e nde rapixa resa-py oĩ va'e, nde resa e'ỹ jave. “Tanohẽ nde resa-gwi” ere rei nde rapixa-pe nde reko porã a'ã a'ã-vy. Enohẽ ranhe katu nde resa-gwi upe yvyravogwe nde rekoha ererova-vy. Upe rire ae erehexa porã-ta. Erehexa porã-ma ramo, erenohẽ arã hesa-gwi upe-py oĩ va'e, he'i Hesu íxupe kwéry onhemonhe'ẽ-vy. Arandu nhe'ẽ oiporu ponove ojohu vai rei gwapixa rekoha. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Upéi omombe'u jevy ipy'a rekoha rehegwa nhe'ẽ hi'a ro'opy-rehe jaikwaa yvyra rehegwa nhe'ẽ-rami. —Yvyra jaikwaa hi'a ro'opy-rehe. Ndaipóri yvyra porã hi'a vai va'e. Yvyra porã hi'a porã meme. Ndaipóri ave yvyra vai hi'a porã va'e. Hi'a vai meme. Yva aju-rehe ohexa uka nhande-vy gwekoha yvyra. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Peteĩ yvyra-gwi peteĩxa meme hi'a. Nhuatĩ máta-gwi nanhamondohóyry yva aju ja'u va'erã. Ha jukéri-gwi ndajaipo'ói yva aju ja'u va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Upéixa ave nhande kwéry, mba'e aju-rami jahexa uka nhande py'apóry nhande rekoha-rehe. Nhande py'a porã ramo nhande rekoha porã meme va'erã. Ha nhande py'a vai ramo nhande rekoha vai va'erã. Upéixa ave nhande py'a rekoha-ramima nhanhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Erejapo e'ỹ jave xe nhe'ẽ ere rei xe-vy “Xe Járy” he'i Hesu onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","—Amombe'u-ta peẽ-my mba'éixa pa oiko va'erã xe-rehe ojerovia va'e. Ou xe renda-py, ohendu porã xe nhe'ẽ, oiko meme xe nhe'ẽ-rupi. Aiporu jevy-ta xe-rehe ojerovia va'e rehegwa nhe'ẽ ita ári omoĩ gwoyrã va'e rehegwa nhe'ẽ-rami. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","—Peteĩ kwimba'e ojapo va'ekwe gwogarã. Ysyry rembe'y-py ojo'o okytakwarã. Yvykwa ipy pukukwe ojo'o okytakwarã. Ita ári omoĩ okyta. Ojapopa rire ou sapy'a peteĩ marány. Heta eterei oky-gwi, ysyrygwasu hynyhẽmba-ma. Oipete pete hóga-pe. Ha ndoitýiry joty hóga. Hatã joty oĩ hatã ojapo va'ekwe-gwi. Omombaraete porã gwóga-gwi ndo'áiry joty hóga. Ita ári omoĩ-gwi hatã joty hóga oĩ, he'i arandu nhe'ẽ omombe'u-vy. Upéi he'i jevy: —Ha'e-ta ave peẽ-my, Xe-rehe ojerovia va'e upéixa ete ave ndojeity ukase mo'ãi, oiko meme va'erã voi xe nhe'ẽ-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—Ha upe xe nhe'ẽ nohendu porãi va'e, ohendu rei-gwi ndoikói xe nhe'ẽ-rupi va'e-rehe amombe'u-ta peẽ-my gwĩ pya'e vérami gwóga ojapo va'e rehegwa nhe'ẽ-rami. —Peteĩ kwimba'e ojapo araka'e gwogarã. Pya'e a'e ojapo gwogarã. Ysyry rembe'y-py ojo'o okytakwarã. Yvykwa nandi rei-py omoĩ okyta. Ndaipy pukúi ave. Upéi oky heta ramo, ysyry okakwaa-ma ramo, y oipete hatã ramo hóga-pe, oitypa-ma hóga. Ojejapipa-ma hóga-rehe. Ndojapo porãiry gwóga. Upéa-gwi oity. Ijáry nahi'arandu porãi-gwi, oity uka gwóga, he'i arandu nhe'ẽ omombe'u-vy. Upéi he'i: —Ha'e-ta peẽ-my: Xe nhe'ẽ-rupi oiko e'ỹ va'e upéixa ave ojeity uka rei arã voi oho vai rei hagwã upe xe nhe'ẽ ohendu rei va'e nahi'arandu porãi-gwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ojogweroaty aty va'e-pe omombe'u heta rire Hesu ohasa-ma ou-vy oike hagwã Cafarnaum tetã-my. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ha upe-py oime capitão, soldado ruvixa va'e judeu e'ỹ va'e. Heta soldado-rehe omanda va'e, heta hembigwái ave. Ha peteĩ hembigwái hembihayhu porã va'e katu hasy ete. Omano-tama oĩ-vy hembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hasy ete jave hembigwái soldado ruvixa ohendu-ma Hesu rerakwã. Ohendu-ma ramo he'i gwĩ judeu ruvixa-pe: —Tereho Hesu renda-py. Emombe'u íxupe ou hagwã xe ha-py. Aikotevẽ hese. Aipota eterei ou ombogwera hagwã xe rembigwái xe rembiayhu ete va'e-pe, he'i omondo-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aipo ramo judeu ruvixa kwéry oho onhomongeta Hesu ndive. Ojerure rure Hesu-pe: —Iporã voi ereho erembogwera upe romano va'e soldado ruvixa rembigwái-pe, he'i íxupe. —Iporã voi ereiporiahuvereko íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ha'e nhande rayhu ra'e. Nhande re'ýi kwéry-pe hembiapo porã meme va'e. Ojapo uka va'ekwe peteĩ ogagwasu nhande porahéi hatygwã. Upéa-gwi iporã voi ereiporiahuvereko íxupe hembigwái-pe erembogwera hagwã, he'i jevy jevy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aipo ramo Hesu ou indive hasy va'e rexa-vy ou oiko-vy. Ogwahẽ-tama ramo ou-vy Hesu ohogwaitĩ jevy-ma íxupe ou-vy. Soldado ruvixa omondo gwapixa kwéry Hesu rogwaitĩ uka-vy. Ha igwahẽ ramo he'i íxupe: —Ani erenhemomirĩ eregwahẽ hagwã xe róga-py nde, mbo'eháry. Ne rembiapo porã eterei va'e atĩ eterei ereju hagwã xe renda-py. Naxe py'a porãi-gwi xe atĩ eterei orohogwaitĩ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Atĩ eterei-gwi ndahái kuri anhomongeta ne ndive. Iporãve ne nhe'ẽ-py rei erembogwera xe rembigwái-pe, he'i uka. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ha ha'e he'i uka ave —Aikwaa voi mburuvixa nomanda reíry. Xe ko, xe ave mburuvixave va'e nhe'ẽ gwy-py ave aiko. Ha oime ave soldado kwéry xe nhe'ẽ gwy pygwa ave. Ha'e ramo peteĩ soldado-pe, “Tereho” amanda ramo íxupe, oho joty. Ha'e ramo outro-pe, “Eju” ou joty ave. Ha'e ramo xe rembigwái-pe, “Ejapo ko xe remimbota” ha'e ramo, ojapo joty ave. Upéa-rehe aikwaa ne nhe'ẽ-py rei okwera arã xe rembigwái, he'i uka Hesu-pe soldado ruvixa. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ohendu-ma ramo inhe'ẽ kwéry Hesu ojere omongeta hagwã omoirũhaty-pe: —Ndajohúi vyteri Israel pygwa kwéry-pe ko judeu e'ỹ va'e-rami xe-rehe ojerovia va'e. Ne'írã ojerovia tee Israel pygwa kwéry xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Upe rire soldado ruvixa remimbou kwéry oho jevy. Ogwahẽ-ma ramo mburuvixagwasu róga-py, ohexa hembigwái. Hesãi jevy-ma hembigwái. Okwera porã-ma ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Upe rire Hesu oho tetã Naim-my. Hemimbo'e kwéry ave, ojogweroaty va'e ave oho indive. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ogwahẽ-tama ramo upe tetã rokẽ-my ohexa osẽsẽ va'e kwéry. Omano va'ekwe ogweraha-tama hetekwe rendaty-py. Túvy omano rire ae-ma omano ta'ýry ave. Isykwe tembirekokwe memby voi omano jevy. Peteĩmi oiko va'e. Ha heta upe tetã mygwa oho omoirũ upe tembirekokwe-pe. Osẽsẽmba hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ohexa-ma ramo kunha-pe Hesu oiporiahuvereko íxupe. He'i upe tembirekokwe-pe: —Ani erehapirõ ne memby-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Upéa he'i-vy ogwahẽ hyru ypy-py omoĩ opo hyru-rehe. Herahahare kwéry opyta. Opyta-ma ramo Hesu he'i: —Ha'e-ta nde-vy: Epu'ã katu, karia'y, he'i omano tee-ma va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","He'i-ma ramo upe omano tee va'ekwe opu'ã jevy ogwapy-vy. Onhypyrũ jevy-ma onhe'ẽ. Upéi Hesu he'i isy-pe: —Ko ne memby amoingove jevy-ma, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Upe-ma ramo ikyhyjepa rei Hesu-gwi hikwái. Ikyhyjepa-gwi omboete katu Nhandejáry-pe: —Ou-ma nipo nhane pa'ũ-my Nhandejáry nhe'ẽ-py omombe'u va'ety ra'e. Ipu'aka va'e voi oiko-ma nhane pa'ũ-my, he'i Hesu-rehe Nhandejáry-pe omomba'egwasu-vy. He'i ave hikwái: —Nhandejáry nipo ou-ma ra'e oresende hagwã oipytygwõ hagwã gwe'ýi kwéry-pe, he'i hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Opa-rupi oho Hesu rerakwã. Judéia pygwa kwéry ohendu-ma, ijerekwe-rupi ave tetã ambue mbue pygwa kwéry ohendu-ma Hesu rembiapo porãgwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ha João remimbo'e kwéry omombe'u jevy íxupe Hesu rerakwã: “Omano ete va'e omoingove jevy” omombe'u íxupe. Upéa ohendu-gwi João ohenói mokõi gwemimbo'e va'e: ");
INSERT INTO kgkNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","—Tereho Hesu ha-py, he'i ojokwái-vy. —Eporandu íxupe, “Nde tipo, Nhandejáry rembiporavo tee va'e nhane remiha'arõ va'e voi nipo ra'e nde?” ere íxupe. Ha ndoikói ramo, eporandu ave, “Ambueve va'e-rehe para'e tekotevẽ nhaha'arõ?” ere Hesu-pe, he'i João mokõi gwemimbo'e-pe imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ogwahẽ-ma ramo Hesu ha-py oporandu-ma íxupe: —João Batista ore mbou oroporandu hagwã nde-vy. Nde tipo, Nhandejáry rembiporavo tee va'e voi tipo nde ra'e? he'i íxupe. —Ambueve va'e-rehe pa tekotevẽ nhaha'arõ? he'i oporandu-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ha Hesu ae onhemokirirĩ íxugwi. Henonde-py ombogwera heta hasy va'e-pe, imba'asy va'ekwe ombogwera ave. Omosẽsẽ ave anháy kente kwéry-gwi, ohexa e'ỹ va'e kwéry-pe ombohesapyso ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Upéa ojapo rire ae-ma he'i João remimbou kwéry-pe: —Tapeho jevy katu. Emombe'u João Batista-pe mba'e pehexa kuri mba'e pehendu kuri ave. Hesapyso e'ỹ va'ekwe gwive hesapyso-ma. Ikarẽ va'ekwe opu'ã porã jevy-ma ave. Mba'asy vai-gwi ijai aipa va'ekwe ipire porã jevy-ma ave. Ijapysa e'ỹ va'ekwe ijapysa porã-ma ave. Omano ete va'ekwe oikove jevy ave. Iporiahu va'e kwéry-pe omombe'u Nhandejáry nhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hexapyrã-rupi voi ojapo Nhandejáry heroviapyrã-rupi ojapo. Upéixa-gwi heko vy'a va'erã upe xe-rehe ojerovia tee va'e kwéry. Ha ndovy'a mo'ãi arã upe xe-rehe, “Ha'e para'e, ndaha'éi para'e Nhandejáry rembiporavo tee va'e?” he'i va'e. Tereho eremombe'u hagwã João-pe jevy, he'i Hesu João remimbou kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","25","Oho jevy-ma ramo João Batista remimbou, Hesu omombe'u jevy ojogweroaty va'e-pe hesegwa nhe'ẽ: —Peho araka'e João Batista pehexa hagwã. Peho ae tekwaty e'ỹ-my. Ndapehói para'e ikangy kangy va'e rexa-vy jahapéixa onhembovava va'e ndapehexaséi para'e peho-vy ra'e. Ndapehói ave ijao porã porã va'e erehexa-vy. Ijao porã porã va'e ndopytái tekwaty e'ỹ-my. Gwĩ ijao porã porã va'e, imba'e reta reta va'e mburuvixagwasu róga-py oiko. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Peho ra'e pehexa hagwã ae Nhandejáry nhe'ẽ-py omombe'u va'ety. Anhete ha'e-ta: Upéa voi ko João Batista. João Batista oĩ ha-py peje'ói-vy ra'e. Ha'e-ta ave peẽ-my: Oĩ heta Nhandejáry nhe'ẽ-py omombe'u va'ety. João Batista rekoha ae ipu'akave hese kwéry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nhandejáry kwatia-rehe oĩ João Batista rehegwa nhe'ẽ. “Amondo-ta xe rembigwái ne renonde-py. Xe nhe'ẽ mombe'uha upe va'e. Amondo-ta íxupe omopotĩ hagwã nde raperã” he'i va'ekwe Nhandejáry ohai uka-vy hese va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Xe katu ha'e-ta peẽ-my: Yma gwive ãy peve ndaipóri va'ekwe Nhandejáry nhe'ẽ-py omombe'u va'ety João Batista rekoha-gwi tuvixave va'e. Upéixa ramo jepe oiko-ta hekoha tuvixave va'e kwéry íxugwi, he'i Hesu. —Nhandejáry nhande ruvixa-pe omoirũ tee va'e gwive, hese ojerovia va'e ogwereko arã gwekoha tuvixave João Batista rekohagwe-gwi. Gwĩ Nhandejáry ndive oiko va'e entéro upe pygwa-gwi heko mirĩve va'e jepe hekoha tuvixave va'erã João Batista rekohagwe-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Enterove ohendu va'e, gwĩ plata-py nhane mbopaga va'ety kwéry gwive, onhemongarai uka va'ekwe João Batista-pe va'e kwéry he'i: —Nhandejáry hembiapo porã meme ete va'e voi, he'i íxupe omboete-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gwĩ fariseu kwéry ae, ndoikoséi Nhandejáry reko potĩha-rupi, gwĩ Moisés remimombe'ukwe-rehe oporombo'eha ave ndoikoséi Nhandejáry reko potĩha-rupi ave. Upéixa-gwi nonhemongarai ukáiry va'ekwe João-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Upéi Hesu onhemonhe'ẽ jevy enterove upe-py ojogweroaty va'e-pe. He'i: —Mba'eixa pa oiko ko'ãygwa amombe'u-ta peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mitãgwe reko rami voi ãygwa reko. Onhembysarái mitã mba'ejogwa haty-py. Osapukái oirũrã-rehe “Mbaraka orombopu kuri ha peẽ katu ndapejerokyséi ra'e. Orohapirõ ra'anga kuri ha peẽ katu ndapejahe'oséiry ra'e” he'i oirũrã kwéry-pe nonhembysaraiséi-gwi. Ha ko'ãygwa mitãgwe ramigwa voi ndogwerovy'ái gwapixarãgwe reko, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Ou va'ekwe João Batista. Mbojape ndo'úi. Uva rykwere ndo'úi ave Nhandejáry-pe omboete tee-vy. Peẽ ae peje mo'ã hese: “Anháy voi ra'e ijáry” peje mo'ã hese napehenduséi-gwi rei inhe'ẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","—Xe-ma Nhande Ryke'y tee va'e voi xe. Xe aju-ma ko'a-py akaru reheve uva rykwere ha'u ave aiko-vy. Peẽ ae, peje mo'ã xe-rehe: “Uva rykwere ho'u eterei upe va'e” peje mo'ã xe-rehe napehenduséi-gwi. “Okaru eterei upe va'e” peje mo'ã xe-rehe. “Plata-py oporombopaga va'ety kwéry ndive oiko va'e upéa” peje vai xe-rehe. “Ojejavy va'e kwéry ndive oiko va'e upéa” peje vai ave xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Anhete voi ha'e-ta peẽ-my: Nhandejáry reroviaha oikwaa-ma voi Nhandejáry inharanduve ete va'e voi. Jaiko ramo Nhandejáry nhe'ẽ-rupi, nanhamombe'u pehẽ pehẽmba reíry mba'eve-rehe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Peteĩ fariseu va'e ohenói Hesu-pe okaru hagwã ondive. Héry va'e Simão. Ha ohenói-gwi Hesu oho hóga-py. Oike rire ogwapy-ma oĩ-vy okaru hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Oime jave upe-py peteĩ kunha ou Hesu renda-py. Upe tetã mygwa voi upe kunha. Enterove upe tetã mygwa kwéry oikwaa-ma mandu'aha porã e'ỹha voi upe kunha. Ha ohendu-ma ramo Hesu okaru-vy oĩ-vy fariséu róga-py, upe kunha ou-ma ave. Ogweru hyakwã porã tee va'e omboete hagwã Hesu-pe. Hyru reheve ogweru. Upe hyru ojejapo va'ekwe ita-gwi héry va'e alabastro. Hepy eterei. Hepy ave hyakwã va'e. Ha hyakwã va'e reheve ou oike fariseu róga-py. Onhemoagwĩve Hesu-gwi. Ovy'a eterei Hesu ombogwera hekoha-gwi. Ojahe'o opyta-vy. Omoakỹ akỹ Hesu py gwesay-py. Omokã mokã ipy ho'ávy-py. Oipyte pyte Hesu py omboete-vy. Hyakwã porã ogweru va'ekwe onhohẽ ave Hesu py-rehe otima porã hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Upéixa ojapo jave upe kunha, fariseu va'e ohexa katu íxupe. He'i rei opy'apy-py: “Ko kwimba'e Nhandejáry nhe'ẽ-py omombe'u va'ety mo'ã” he'i rei rei hese. “Nhandejáry nhe'ẽ-py omombe'u va'ety ramo, oikwaa-ma arã ra'e kóa ko kunha mandu'a vaiha voi. Ndoikwaái para'e” he'i mo'ã Hesu-rehe. “Ndoikwaái-gwi para'e: Ani eremoĩ nde po xe-rehe, nde'íry kunha tavy-pe. Ndoikwaái para'e” he'i rei rei Hesu-rehe opy'apy-py. Mba'eve nohendu ukái joty. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ha Hesu katu he'i íxupe: —Simão, anhomongetase ne ndive, he'i íxupe. —Mbava'e-rehe erenhomongetase xe ndive? he'i Simão Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Upéi Hesu omombe'u arandu nhe'ẽ oiporiahuvereko va'e rehegwa nhe'ẽ-rami omombe'u Simão-pe hesegwa nhe'ẽ: —Mokõi kwimba'e oiporu va'ekwe plata peteĩ oiporu uka va'e-gwi. Ha peteĩ oreve vyterĩ quinhentos opaga va'erã ha peteĩ oreve cinqüenta opaga va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ha ndogwerekói mba'eve ombohekovia hagwã ijáry-pe. Aipo ramo upe plata járy oiporiahuvereko íxupe kwéry. He'i íxupe kwéry: “Iporãve aheja rei nde-vy upe plata ereiporu va'ekwe xéhegwi” he'i íxupe. “Ani katu erembohekovia jevy xe-vy xe platakwe. Ne mba'e tee-rami voi ame'ẽ va'ekwe nde-vy” he'i íxupe kwéry. Upe mokõi nombohekoviái va'e ovy'a voi ijarykwe-rehe imboete-vy. Oheja rei-gwi nipo ha'e kwéry omboete voi plata jarykwe-pe ra'e. Kiva'e tipo nde-vy omboeteve arã upe pirapire jarykwe-pe? he'i Hesu omombe'u Simão-pe arandu rehegwa nhe'ẽ hesegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Xe-vy, pirapire hetave ojéupe ome'ẽ va'ekwe omboeteve arã, he'i. —Upéixa voi, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Upéi Hesu oma'ẽ upe kunha-rehe ha he'i jevy Simão-pe: —Peteĩ nhe'ẽve ha'e-ta nde-vy, he'i jevy. —Erehexa ko kunha, he'i íxupe. —Ha'e ojapo porã kuri xe-vy, he'i. —Agwahẽ ne mbohupa-vy kuri xe. Ha nhande re'ýi ojapoha ramigwa nderejapói kuri xe-vy. Nhande re'ýi ome'ẽ ombohupa-pe y ojepyhéi hagwã. Nde, nereme'ẽi kuri ajepyhéi hagwã. Nde rekovia ko kunha aje'i-ma ra'e xe py omoakỹ gwesay-py. Ho'ávy-py oikyty omokã hagwã omoakỹ va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ha nde, ndaxe rova pytéi voi nde nhande re'ýi ojapoha-rami. Ha agwahẽ gwive ko kunha oipyte pyte xe py. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nde neremohyakwãi xe akã aceite hyakwã porã va'e-py nhande re'ýi ojapoha-rami. Ha ko kunha nde rekovia ojapo porãve xe-rehe. Omohyakwã xe py. Onhohẽ nhohẽ xe py-rehe hepyve pyve va'e. Hyakwã porã va'e onhohẽ xe py-rehe omohyakwãmba xe py. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Anhete ha'e-ta nde-vy. Ko kunha-gwi amboyke-ma heta eta hembiapo vaikwe. Upéa-rehe xe rayhu-ma voi. Ha “Ndahetái xe rembiapo vaikwe” he'i va'e-gwi eremboyke ramo hembiapo vaikwe, mixĩ mate nde rayhu arã upe va'e, he'i Simão-pe onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Upéi: —Amboyke-ma ndéhegwi ne rembiapo vaikwe, he'i kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ohendu-ma ramo Hesu nhe'ẽ entéro upe-py ogwapy va'e oporandu randu ojéupe: “Kiva'e tipo ko kwimba'e: Amboyke-ma ne rembiapo vaikwe ndéhegwi, he'i kuri. Onhe'ẽ rei nipo ra'e” he'i rei hikwái opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Upéi Hesu he'i kunha-pe: —Xe-rehe erejerovia tee-ma. Upéixa-gwi Nhandejáry omboyke-ma ndéhegwi ne rembiapo vaikwe. Nde py'agwapy reheve tereho katu he'i kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ha upe rire-ma Hesu oho omombe'u Nhandejáry nhe'ẽ porã. Oho tetãgwasu kwéry-rupi. Oho tetã mirĩ kwéry-rupi ave. Oho-vy omombe'u mbe'u “Pemoirũ katu Nhandejáry pende ruvixarã-pe” he'i omombe'u mbe'u oho-vy. Upe doze hembiporavokwe va'e oho indive. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Gwĩ kunha hemimbogwerakwe ave oho indive. Gwĩ íxugwi omondopa va'ekwe anháy ave oho. Heta kunha oho. Oho Maria Madalena. Upe va'e-gwi omosẽ va'ekwe sete anháy. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Oho Joana, Cuza rembireko upéa. Cuza mburuvixa voi. Onhangareko mburuvixagwasu Herodes mba'e kwéry-rehe. Hembireko Joana oho. Oho Suzana ave. Hetave ave kunha Hesu ndive oho. Upe kunha kwéry ome'ẽ meme hemikotevẽ Hesu-pe, doze hembiporavo va'e-pe ave ome'ẽ hemikotevẽ. Oho meme indive ojapo hagwã gwemi'urã indive ho'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Upéi ojogweroaty aty kente kwéry oikwaa porã hagwã Hesu nhe'ẽ. Entéro tetã tetã-gwi osẽsẽ hikwái ojogweroaty aty-vy. Ha Hesu omombe'u arandu nhe'ẽ temitỹgwe rehegwa nhe'ẽ-rami. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Oho onhemitỹ va'e onhemitỹ hagwã. Omohãi temitỹ. Onhemitỹ jave oime temitỹ ra'ỹi tape rembe'y-rupi ho'a va'e. Ha upéi ohasa va'e opyrũmba hese, gwyra ou ho'upa ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oime ave temitỹ ra'ỹi itaty-rupi yvy pererĩ-rupi ho'a va'e ave. Upéi henhói-ma ramo pya'e ipirupa jevy nainhakỹi-gwi yvy. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oime ave temitỹ ra'ỹi nhuatĩndy-rupi ho'a va'e ave. Upéi ojoparapa henhói-vy hemitỹ ndive okakwaa nhuatĩ. Ojaho'ipa upe temitỹgwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Oime ave temitỹ ra'ỹi yvy porã-my ho'a va'e. Upéi okakwaa-ma hemitỹ. Hope porã-ma oho-vy. Hi'a porã-ma rire cem ha'ỹi meme-ma oĩ, he'i Hesu íxupe kwéry omombe'u-vy arandu nhe'ẽ. Upéi: —Ne aranduse va'e ejeapysaka katu ko xe nhe'ẽ-rehe, he'i onhe'ẽ hatã-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Upe rire Hesu reroviaha kwéry oporandu íxupe: —Mbava'e tipo eremombe'use kuri ore-vy? Ore, norohendu kwaái kuri upe temitỹgwe rehegwa nhe'ẽ, he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","—Peẽ peikwaa voi ra'e mba'éixa po nhamoirũ Nhandejáry-pe nhane ruvixarã. Nhandejáry ome'ẽ-ma peẽ-my pene arandurã. Oikwaa uka-gwi peẽ-my peikwaa-ma. Ha kente ambue kwéry-pe ndojeroviái va'e-pe ndoikwaa ukáiry. Upéa-gwi arandu rehegwa nhe'ẽ aiporu ramo, ndojeroviái-gwi okanhy inharandurã íxugwi kwéry, he'i. —Upéixa-gwi oma'ẽ ma'ẽ rei ha'e kwéry, ha mba'eve ndohexáiry. Ohendu hendu rei hikwái, mba'eve ndoikwaáiry. Ndojeroviái hese-gwi Nhandejáry ndoikwaa ukáiry íxupe kwéry, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Upéi he'i ave: —Temitỹgwe rehegwa nhe'ẽ amombe'u kuri aikwaa uka-ta peẽ-my, he'i. —“Temitỹ ra'ỹi” he'ise Nhandejáry nhe'ẽ porã. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Upe tape rembe'y-rupi ho'a va'e nhe'ẽ he'ise: Oĩ nhe'ẽ porã nohendu kwaái va'e. Ohendu-ma ramo, ou oipe'a anhaygwasu nhe'ẽ porã inharandu porãrãgwe ipy'a-gwi pono ogwerovia, pono onheresende uka Nhandejáry-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Ha itaty-rupi ho'a va'e nhe'ẽ he'ise: Oĩ nhe'ẽ porã ohendu rei va'e. Ohendu-ma ramo ovy'a ogwerovia-vy. Ha pya'e henhói ndahapóiry va'e-rami ndogweroviái ipy'apy reheve. Sapy'a ndogweroviavéi. Ohasa asy-tama ramo, imbojejavyharã ou ramo naimandu'avéi-ma Nhandejáry nhe'ẽ porã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Ha nhuatĩndy-rupi ho'a va'e nhe'ẽ he'ise: Oĩ nhe'ẽ porã ohendu mixĩ va'e. Ha onhesamondo mondo omba'e-rehe: “Mba'e tipo ojehu-ta xe-vy ko'ánga” he'i ojepy'apy-vy. Imba'e reta reta-rehe ojapura. Oipotave tave ojéupe gwarã. Opaixagwa ojapose ojererohory mo'ã hagwã. Omba'e retarã-rehe ete ha'e oikotevẽ. Nhandejáry remimbota, gwembiapo porãrã mo'ã ojapo. Ha nopenái inhe'ẽ porã-rehe. Temitỹgwe naha'ỹiry va'e-rami opyta. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ha yvy porã-my ho'a va'e nhe'ẽ he'ise: Oĩ nhe'ẽ porã-rehe ojeapysaka va'e. Ohendu-ma ramo ogwerovia tee voi. Ogwerovia-gwi ipy'a potĩ porã. Nhandejáry rape-rehe ogwata gwata. Hembiapo porãve rãve va'e ogwerovia-gwi. Upéixa-gwi “Heta ha'ỹi va'e ramigwa” ha'e hese, he'i Hesu gwemimbo'e kwéry-pe gwemimombe'ukwe oikwaa uka-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Upéi Hesu omombe'u jevy arandu nhe'ẽ tataendy rehegwa nhe'ẽ-rami: —Tataendy nhamoendy ramo jepe ndaha'éi nhamoĩ hagwã mba'e ryru gwy-py. Ndaha'éi ave nhamoĩ hagwã tupa gwy-py. Tataendy nhamoendy nhamoĩ hagwã tataendy rendaty-py, nhande resape porã hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Upéixa ave ojekwaa porã va'erã gwĩ onhenhomi va'ekwe gwive. Ha Nhandejáry oikwaa uka va'erã enterove va'e-pe oikwaa e'ỹ va'ekwe gwive oikwaa porãmba hagwã. Hesakã va'e ramigwa-py ojekwaapa va'erã. Nhande py'apy-py oime va'e gwive ojekwaa uka va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—Ejeapysaka porã katu xe nhe'ẽ-rehe. Ne arandu porã-ma ramo, hetave ojekwaa va'erã nde-vy ne aranduve nduve hagwã-vy ereho. Nahi'arandúi va'e ae nohendu kwaái-vy voi. Okanhymba va'erã íxugwi inharandurãgwe, he'i Hesu omombe'u-vy gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Upe ramo ou isy tyvýry kwéry ndive. Ndikatúi ogwahẽ henda-py. Hesu jerekwe-rehe heta eterei onhomboaty hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Upéi oikwaa va'e he'i Hesu-pe. —Nde sy oĩ oka-py. Nde ryvy kwéry ave oĩ upe-py. Nde rexase, he'i omombe'u Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ha'e katu he'i: —Nhandejáry nhe'ẽ ohendu va'e gwive, inhe'ẽ ojapo va'e gwive upe va'e kwéry-pe xe ha'e, “Xe sy, xe ryvy” ave, he'i íxupe kwéry Hesu hekorã omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ha upe rire, peteĩ áry-py, Hesu onhemboyru kanoagwasu-py gwemimbo'e kwéry ndive: —Jaha jahasa hagwã y rovái, he'i íxupe kwéry. He'i-vy oho hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Oipykúi oje'ói-vy jave hikwái Hesu oke oĩ-vy. Upe jave y-rehe ho'a yvytugwasu. Omopu'ã pu'ã y-pe. Onhehẽ-ma kanoagwasu-py y. Haimete ete y omohynyhẽ kanóa. Ombopohýi eterei kanóa y. Haimete ete omonheapymi kanóa y gwy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Upéixa-gwi oho omombáy Hesu-pe: —Epáy katu, mbo'eháry. Nhanheapymimba-tama. Onheapymi-tama nhande ryru y gwy-py, he'i Hesu-pe omombáy-vy. Opáy-ma Hesu. Oja'o yvytugwasu-pe. Omombyta y. Inhe'ẽ-py okirirĩ-ma. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Upéi he'i ondivegwa kwéry-pe: —Ma'erã nderejeroviái xe-rehe, he'i onhemonhe'ẽ-vy ondivegwa kwéry-pe. Ha oponderapa hese hikwái: —Mba'eixagwa po ko va'e? Onhe'ẽ ramo y-pe yvytu-pe ave omokirirĩ inhe'ẽ-py rei. Mba'eixagwa po ko va'e, he'i joa Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ha upe rire oipykúi pykúi oho-vy ogwahẽ hagwã Geraseno kwéry retã-my. Upe tetã opyta yrusu rembe'y-py. Galiléia yvy rovake opyta. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Ha osẽ-ma ramo kanóa-gwi, ou ohogwaitĩ-vy íxupe upe anháy ojepota va'e va'ekwe hese. Tetã-gwi ou. Hi'are-ma oiko opi-vy. Óga-py ndoikovéi ave. Oiko rei ijyta-rupi upe anháy ojepota va'e hese. Ojepota-gwi omenda va'ekwe anháy-rehe. Oiko meme indive. Upe tetã mygwa kwéry oapresa mo'ã íxupe. Ndikatuvéi onhapytĩ íxupe. Onhapytĩ jevy jevy rei íxupe. Ojokwa jokwa íxupe oipokwa oipykwa ave calena-py. Ha omondohoypa. Omopẽmba íxupe oho-vy. Anháy ogweraha íxupe tekwaty e'ỹ-my oheja. Upéi Hesu ou ohogwaitĩ íxupe. Ohexa-ma ramo Hesu-pe osapukái-vy ojeity íxupe: —Hesu Tupãgwasu ra'y tee voi ko nde, he'i íxupe. —Mba'e tipo erejapo-ta xe-rehe, he'i oporandu-vy íxupe. —Ajerure nde-vy ani xe mbohasa asy teĩ, he'i Hesu-pe anháy. Upe jave: —Esẽ katu ko kwimba'e-gwi, he'i Hesu anháy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ha kwimba'e-pe he'i: —Emombe'u xe-vy nde réry, he'i íxupe. —Ore reta-gwi xe réry Heta ave, he'i. Heta-ma voi anháy-rehe ojepota-ma va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Upéi ojerure rure Hesu-pe anháy kwéry pono omondopa íxupe kwéry anháy opyta hagwã-my. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Upe jave y rembe'y-py oĩ heta kure. Yvyaty rembe'y-rehe okaru joa kure. Ha anháy kwéry ojerure Hesu-pe oheja hagwã kure yta-py oike. —Tapeho katu, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ha anháy kwéry osẽ kwimba'e-gwi oike jevy kure yta-py. Ha kure kwéry oriparapa ogwejy-vy. Y rembe'y-py ogwejy oje'ói-vy yugwarusu-py. Onheapymimba y gwy-py oje'ói-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Upéa ohexa-ma ramo, kure-rehe onhangareko va'e kwéry oriparapa oho-vy hikwái. Omombe'u tetã mygwa kwéry-pe. Tetã jere rehegwa-pe ave omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Oupa ojehexapa ojehu va'ekwe gwive. Ogwahẽmba Hesu renda-py. Ohexa anháy rerekohare ave ogwahẽ hikwái. Ohexa íxupe Hesu renonde-py ogwapy-vy oĩ-vy. Onhemonde-ma oĩ-vy. Ndaitavyvéi-ma anháy rerekohare. Upéa-rehe ipy'amirĩmba hikwái. Ipu'aka eterei Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ha gwĩ hexahare omombe'upa íxupe kwéry. Anháy rerekohare rehegwa nhe'ẽ omombe'u. Mba'eixagwa pa ombogwera anháy rerekohare omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ha upéa-rehe ipy'amirĩmba Hesu-gwi Geraseno kwéry. He'i íxupe opoi hagwã hetã-gwi. Upéixa-gwi onhemboyru jevy kanóa-py Hesu hendive kwéry ave ohasa jevy y rovái oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Oike-ma ramo kanóa-py, anháy rerekohare ojerure íxupe omoirũse eterei íxupe. Ha ndohejái oho ondive. Omondo íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Tereho nde róga-py, he'i. —Emombe'u nde re'ýi kwéry-pe erekwera porãmaha. “Nhandejáry ojapo porã porã xe-rehe” ere katu emombe'u-vy íxupe kwéry, he'i Hesu íxupe. Ha upéi katu oho omoherakwã upe tetã mygwa-pe: —Xe-rehe ojapo porã porã Hesu, he'i. —Inhe'ẽ-py rei omosẽ imondo-vy xéhegwi anháy kwéry. Xe mbogwera-ma. Ndaxe tavyvéi-ma ãy, he'i. —Ojapo porã voi xe-rehe Hesu, he'i omombe'u-vy gwe'ýi kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ha y rovái ogwahẽ jevy ramo heta eta ojogweroaty aty y rembe'y-py Hesu ra'arõ-vy. Ogwerohory eterei Hesu ogwahẽ ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ha upe ramo ogwahẽ ou-vy kwimba'e. Ojeporahéi haty pygwa ruvixa upéa. Héry Jairo. Ogwahẽ-ma ramo onhesũ omboete-vy Hesu rovagwy-py. —Mbo'eháry, he'i, —Omano-tama xe rajy, he'i. —Eju katu, jaha, he'i íxupe. —Ha'enhomi xe rajy oiko, he'i. —Ogwereko-ma doze ro'y, ha omano-tama. Eju katu jaha embogwera íxupe ani hagwã omano, he'i ojapura-vy hese. Upéa-gwi Hesu oho hendive. Tape-rehe oho ramo, ijaty jaty Hesu-rehe ojoko-vy ojopypa íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tape ku'a-rupi ou kunha. Hapykwéri ete-ma ou. Are-ma hasy. Doze ro'y-ma ogwereko ojegwaha. Ome'ẽmba va'ekwe ogwereko va'e ombogwerahaty kwéry-pe okwera hagwã mo'ã. Opaga paga rei okwera hagwã mo'ã. Ha ndokwerái joty. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Upéa-gwi ou Hesu rapykwéri. Opoko ijao poty-rehe. Opoko-ma ramo omoĩ opo hese, opi-ma íxugwi ijegwaha. Okwera-ma kunha. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Upéa-rehe Hesu oporandu: —Kiva'e opoko kuri xe-rehe? he'i oporandu-vy onhomongeta hagwã indive. Enterove he'i joa: —Ndaha'éi xe, he'i Hesu-pe. Ha Pedro katu, oirũ gwéry ndive, he'i: —Ijatypa hikwái, mbo'eháry. Ojogweroaty aty oje'ói-vy nde rexa-vy. Ojejapi japipa oje'ói-vy, he'i íxupe. —Ereporandu rei para'e, “Kiva'e opoko kuri xe-rehe?” ere rei ra'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Upéi katu Hesu he'i jevy: —Opoko-ma voi xe-rehe kuri. Onhembogwera uka hagwã opoko xe-rehe kuri. Okwera-ma xe-rehe opoko-gwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ha kunha katu oikwaa. “Ndikatúi anhemĩ Hesu-gwi” he'i opy'apy-py. Ou, ikyhyje omboryrýi. Ou ojeity henonde-py. “Ipoxy para'e xe-rehe. Naxe mbogweraséi para'e” he'i mo'ã Hesu-rehe opy'a-py. Omombe'upa anhetegwa va'e. Ijaty va'e ohendu ave omombe'u ramo. —Anhembogwera uka hagwã kuri nde-rehe apoko kuri, he'i íxupe. —Xe po amoĩ ramo nde-rehe akwera-ma, he'i Hesu-pe hasy va'ekwe kunha. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—Ãy katu erekwera-ma. Xe rajy-rami voi oroporiahuvereko, he'i kunha-pe imbopy'agwapy-vy Hesu. —Nde erejerovia-ma xe-rehe. Upéa-gwi erekwera-ma. Ne resãi porã-ma. Nde py'agwapy reheve tereho, he'i Hesu íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Onhe'ẽ jave kunha-pe, ou mburuvixa Jairo róga-gwi omombe'u: —Omano ete-ma nde rajy. Ndovalevéi, natekotevẽi oho mbo'eháry nde róga-py. Eheja katu toho, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ha Hesu ohendu omombe'u ramo: —Ani eremboasy teĩ. Ejerovia katu xe-rehe. Ambogwera-ta íxupe, he'i túvy-pe. Upéi oho ohexa omano va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","54","Ogwahẽ-ma ramo óga-py ndohejái avave oike indive. Pedro mante oike, João, Tiago, mitã ru, mitã sy ave oike. Upe va'e mante oike omoirũ-vy Hesu-pe. Ha ijayvu joa hikwái gwĩ ndoikéi va'e kwéry. Hasẽmba hapirõ-vy. Hesu ae he'i: —Ani pene rasẽ teĩ, he'i. —Nomano tee mo'ãiry. Oke ae-ma oĩ-vy, he'i omano tee va'e-rehe. Ha ha'e kwéry onhembohory hese hikwái. —Omano ete-ma, he'i hikwái ohapirõ joa-vy. Upéi oike Hesu mitã kunhagwasu oĩ va'e ha-py. Inhirũ mbohapy reheve, mitã kunha ru, isy ave ogweroike ondive. Oipopyhy mitã kunhagwasu-pe: —Mitã kunhagwasu, epu'ã katu, he'i ohenói-vy mitã kunha omano va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","He'i-ma ramo Hesu, oikove jevy mitã kunha. Pya'e opu'ã. —Emongaru mani katu ne memby, he'i Hesu isy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","“Mba'éixa omoingove jevy íxupe?” he'i opondera eterei-vy hese hikwái. Ha Hesu katu he'i: —A-rami xe amoingove jevyha kuri, ani ae teĩ xe mombe'u kuri, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ha upéi katu Hesu ohenói doze gwemimbo'e kwéry-pe ojogweroaty hagwã henda-py. —Xe nhe'ẽ-py emosẽ sẽmba katu anháy imondo-vy, he'i íxupe kwéry. —Xe nhe'ẽ-py ereporombogwera-ta ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","—Tereho eremombe'u hagwã Nhandejáry rehegwa nhe'ẽ. “Pemoirũ katu Nhandejáry pende ruvixarã-pe” ere kuri xe mombe'u-vy, he'i íxupe kwéry. —Ha hasy va'e-pe erembogwera-ta ave, he'i íxupe kwéry imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—Ani ereraha mba'eve nde rupive. Nde pykoka ani ereraha teĩ. Nde plata ryru ani ereraha teĩ ave. Nde avío ani ereraha teĩ ave. Nde plata ani ereraha teĩ ave. Ne kamisa mokõi ani ave ereraha teĩ, he'i. —Nandi ete voi tapeho, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","—Ereike ramo óga-py, epyta upe-py. Eresẽ peve upe tetã-gwi, eiko peteĩ óga-py. Ani erembopopa óga ereiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ha tetã mygwa kwéry nane mogwahẽséiry ramo, eresẽ jave embovava nde py ho'apa hagwã yvy timbore nde py-gwi. Hekoha vaipaha eremombe'u hagwã emopotĩ porã nde py. He'i arã upe pygwa, “Nhande rekoha vai eterei-gwi nipo ra'e opy omopotĩ potĩ oho-vy” he'i arã nde-rehe. “Nhandejáry re'ýi e'ỹ-rami nipo ra'e nhande kwéry rekoha” he'i arã gwekoha vaiha oikwaa-vy hikwái, he'i íxupe kwéry Hesu omondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aipo ramo oho hemimbo'e kwéry. Tetã'i tã'i-rupi onhemonhe'ẽ enterove-pe oho-vy. Nhandejáry Hesu Cristo rehegwa nhe'ẽ porã omombe'u. Ha opa ohoha-rupi ombogwera hasy va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Upe jave Galiléia pygwa mburuvixagwasu ohendu-ma Hesu rerakwã. Herodes mburuvixagwasu réry. Ohendu-ma ramo herakwã, he'i: —Kiva'e tipo upe va'e, he'i opondera-vy. Omombe'u joavy avy, omombe'u jokupe kupe rei íxupe. Oĩ he'i va'e Hesu-rehe: “João Batista amyrĩ voi ra'e ojehexa uka jevy ra'e” he'i rei va'e hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oĩ ave he'i rei va'e hese: “Upéa ko myamyrĩkwe Elias ojehexa uka jevy ra'e” he'i rei hese. Oĩ ave he'i va'e hese: “Upéa ko yma myamyrĩkwe Nhandejáry nhe'ẽ-py omombe'u va'ety ojehexa uka jevy-ma ra'e” he'i rei va'e hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Upéa-rehe Herodes he'i: —Kiva'e tipo upe va'e, he'i. —João amyrĩ anhakã'o uka va'ekwe ndaha'éi nipo ha'e voi ra'e, he'i mo'ã hese. —Aipo ramo kiva'e nipo aipo va'e ra'e, he'i rei hese. —Ahendu herakwã jokupe kupe rei. Ahexase eterei Hesu-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Upe rire hemimondo kwéry ou jevy-ma ramo Hesu renda-py omombe'upa íxupe. Ojapo japo va'ekwe omombe'u íxupe. Upe-ma ramo ha'e ogweraha íxupe kwéry Betsaida tetã-my omokane'ogwa-vy mo'ã ogweraha. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Oikwaa-ma ramo jepe kente kwéry oho hapykwéri. Ogwahẽ-ma ramo hikwái ojogwerohory ogwahẽ-vy Hesu ha-py. Omombe'u íxupe kwéry. Nhandejáry nhande ruvixarã rehegwa nhe'ẽ omombe'u íxupe kwéry. Ha hasy va'e-pe ombogwera meme. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ka'aru ete-tama ramo upe doze hemimondo kwéry ou onhemoagwĩve-ma Hesu-gwi. He'i Hesu-pe: —Ere ojogweroaty va'e-pe toho tetã mirĩ-rupi tetã jerekwe-rupi gwemi'urã toheka, oke hagwã ave, he'i Hesu-pe. —Ndaipóri mba'eve a-py, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ha'e katu he'i íxupe kwéry: —Peẽ jepe peme'ẽ hemi'urã kwéry íxupe kwéry, he'i. —Ndahetái nhane remi'urã, he'i —cinco mbojape, mokõi pira ka'ẽ mate oĩ, he'i. —Oroho-ta tipo orojogwa heta hetave hemi'urã kwéry hetave ho'u hagwã, he'i oporandu-vy Hesu-pe. He'i ave íxupe: —Heta eterei oime kente kwéry ko'a-py, he'i onhomongeta-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Haimete cinco mil Hesu nhe'ẽ renduhaty oime upe-py. Upéixa-gwi he'i hese kwéry “Heta eterei voi oime kente kwéry ko'a-py” he'i. Ha Hesu he'i: —Nahániry, pembogwapy uka katu íxupe kwéry. Cinqüenta oĩ va'e ojoypy ypy-py ogwapy hagwã, he'i gwemimondo kwéry-pe. —Ojogweroaty mirĩ mirĩ-vy pembogwapy uka íxupe kwéry, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ha'e kwéry omombe'u enterove ogwapy hagwã. Ha ogwapypa-ma hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Upéi Hesu oipyhy upe cinco mbojape. Mokõi pira ave oipyhy. Upéi hovayva temi'urã-rehe omboete-vy. Hemime'erã-rehe Hesu otima porã Nhandejáry-pe. Upéi ombopopóy temi'urã. Ome'ẽ me'ẽ gwemimbo'e kwéry-pe ombogwejy hagwã enterove rovagwy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ha enterovete okaru. Hygwyatãmba-ma ave hikwái. Upéi ombohyru ho'u va'ekwe rembyre. Doze ajaka jevy joty ombohyru hembyre kwéry. Hynyhẽmba. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hesu omondo jevy onhe'ẽ Nhandejáry-pe. Ha'enho ombojeupi onhe'ẽ. Ha hemimbo'e kwéry oĩ ave hendive. Upéi oporandu íxupe kwéry ojekwaa uka hagwã. —Mbava'e tipo he'i ra'e kente kwéry xe-rehe? he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ha'e kwéry he'i: —Ne mombe'u joavy avypa kuri hikwái. “Yma myamyrĩ omano va'ekwe ojehexa uka jevy kuri nhande-vy” he'i joa kuri nde-rehe entero kente kwéry, he'i íxupe. —“João Batista amyrĩ voi ojehexa uka jevy nipo ra'e” oĩ he'i va'e nde-rehe. “Elias amyrĩ ojehexa uka jevy nipo ra'e” oĩ ave he'i va'e nde-rehe. “Myamyrĩ Nhandejáry nhe'ẽ-py omombe'u va'ety ojehexa uka jevy nipo ra'e” oĩ he'i ave va'e nde-rehe, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Ha nde katu, mbava'e ere xe-rehe? he'i ave oporandu-vy íxupe kwéry. Ha Pedro katu he'i: —Nde ko Cristo voi, he'i íxupe. —Nde ko Nhandejáry rembiporavokwe voi nde, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Ha'e voi xe. Ani ae katu xe mombe'u teĩ kuri avave-pe, he'i. —“Cristo nhane remiha'arõ voi upe va'e” ani peje teĩ avave-pe xe mombe'u-vy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—Xe Nhande Ryke'y tee va'e voi ko xe, he'i. —Tekotevẽ xe ahasa asy aiko-vy. Xe mbojevy-ta judeu ruvixa kwéry, pa'i ruvixa kwéry ave, judeu rekombo'ehaty kwéry ave. Upéi xe jukase-ta hikwái. Ha xe juka uka-ta joty hikwái. Xe juka-ma rire, mbohapy áry rire aikove jevy-ma va'erã, he'i ojehegwa omotenonde-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","—Xe moirũse ramo anive ne rakate'ỹ nde rekove-rehe. Okurusugwasu-rehe omano va'erã-rami ae katu eiko nderejapovéi hagwã erejapose va'e. Xe reko-rupi ae ereiko meme hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gwekove-rehe hakate'ỹ va'e ndoikói va'erã voi Nhandejáry ndive. Ha xe-rehe ha-py gwekove-rehe nopenái va'e oikove meme va'erã Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ndovaléi va'erã nde-vy ko yvy apy gwive járy ramo ereiko hagwã, ne mba'e retave tave erereko hagwã erepena e'ỹ Nhandejáry-rehe. Ndereiko porãi ramo Nhandejáry ndive, ndovaléi arã nde-vy nde rekoha porã mo'ã. Ha'e nde joko-ta gwenda-gwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","—Ha kente gwapixa renda-py ogwenotĩ he'i hagwã, “Ajerovia-ma Hesu-rehe” he'i hagwã va'e, nohenduséi ave xe nhe'ẽ. Upéa-rehe xe ave, xe Nhande Ryke'y tee va'e voi, napena mo'ãi ave hese, he'i. —Xe amano rire aju jevy va'erã. Xe pu'aka resakã reheve agwahẽ jevy va'erã aju-vy. Xe Ru pu'aka resakã reheve agwahẽ jevy va'erã aju-vy. Hembigwái marangatu va'e yváy gwigwa va'e ndive agwahẽ jevy va'erã aju-vy. Ha upéixa aju ramo, napena pena mo'ãi hese kwéry xéhegwi otĩ va'ekwe-rehe, he'i voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","—Anhete ko xe ha'e-ta nde-vy. Oĩ a-py gwĩ nhane pa'ũ mygwa ohexa ranhe-ta mba'eixagwa pa oiko va'e Nhandejáry nhande ruvixarã. Ohexa e'ỹ reheve nomano mo'ãi. Ohexa rire mate omano va'erã, he'i onhemombe'u-vy íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Peteĩ semana rire mbohapy ogweraha gwupive Hesu. Pedro, João, Tiago ave ogweraha omondo hagwã onhe'ẽ Nhandejáry-pe. Ogwerojeupi yvyatyrusu-rehe heraha-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ha Nhandejáry ndive onhomongeta jave ojehekoviarõ-ma oiko-vy Hesu. Ijao imorotĩgwasu ete va'e voi. Nhande resa mbojevy ete hesakã-gwi ijao. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ha sapy'a mokõi va'e ojereropyahu jevy va'ekwe onhomongeta indive. Moisés, Elias ave ");
INSERT INTO kgkNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ojereropyahu jevy ramo va'ekwe ojehexa uka jevy íxupe. Nhandejáry omoendy porã ijere-rehe. Upe reheve ojehexa uka. Hesu ndive onhomongeta jave ojehexa uka. Mba'e ojehu va'erã-rehe onhomongeta. Hesu ohasa asy va'erã Jerusalém-my. Ojuka-tama íxupe upe-py. Upéa-rehe onhomongeta-ma Hesu ndive upe mokõigwa. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ha upe jave Pedro, inhirũ ndive hapehýi eterei-gwi oke hatã-ma oĩ-vy. Opáy-ma ramo, ohexa Hesu hendy ete reheve. Mokõi indive onhomongeta va'e ave ohexa-ma ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ha upéi katu upe mokõigwa oje'ói-tama hikwái. Upe jave Pedro he'i Hesu-pe: —Iporã voi japyta ko'a-py, mbo'eháry. Iporã arã orojapo-ta peẽ-my gwarã tapyirã. Peteĩ nde-vy gwarã, peteĩ Moisés pegwarã, peteĩ Elias pegwarã orojapo-ta, he'i Pedro. Onhemondýi eterei íxugwi ndoikwaáiry mba'e pa he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Onhe'ẽ jave omo'ã-ma íxupe kwéry arai. Oiko jave arai-py onhemondyipa íxugwi hexa-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ohendu-ma arai pa'ũ-my onhe'ẽ va'e: —Hesu xe ra'y tee, he'i. —Xe rembiporavo va'ekwe, he'i. —Ejeapysaka porã katu inhe'ẽ-rehe, he'i. —Inhe'ẽ-rupi eiko katu, he'i íxupe kwéry Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Opa-ma ramo upe va'e nhe'ẽ, ohexa Hesu anho-ma opyta oĩ-vy. Mokõi indive onhomongeta va'ekwe-pe ndohexavéi-ma. Upéa-rehe Hesu remimbo'e okirirĩmba opyta-vy. Ohexa va'ekwe avave-pe ndoikwaa ukáiry. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Upéi áry ambue-ma ramo, ogwejy jevy hikwái yvyatyrusu ári-gwi. Ha heta eta ou ohogwaitĩ-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Upéi ojogweroaty va'e pa'ũ-my oĩ inhe'ẽ hatã va'e: —Ajerure-ta nde-vy xe ra'y-rehe, mbo'eháry. Ha'e anhomi xe ra'y. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ha anháy ojepota-ma hese. Ogwereko ramo sapy'a ombosapukái oity imondo-vy íxupe, he'i omombe'u Hesu-pe. —Onhembohete hatã ombojuruyjuipa-ma íxupe. Omboheteryrýi oiko-vy oityha óra. Ndopoi mo'ãi voi íxugwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","—Ajerure rei ne remimbo'e-pe omosẽ hagwã mo'ã imondo-vy. Ndikatúi omosẽ, he'i Hesu-pe ojerure-vy gwa'ýry ombogwera hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hesu katu he'i: —Ãygwa katu ndojeroviái vyteri xe-rehe. Ndogwerovaséi gwekoha xe ndive oiko hagwã. Ndapyta are mo'ãi pene ndive. Ndoroipokwaa mo'ãvéi-tama. Upéi he'i túvy-pe: —Eru katu nde ra'y xe ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ou-tama ramo nogwahẽ jepéiry ramo, anháy oity jevy-ma íxupe imondo-vy yvy-py, omboheteryrýi íxupe. Hesu ae oja'o-ma anháy-pe: —Epoi íxugwi. Anive erejepota hese, he'i anháy-pe ombogwera hagwã kunumĩ-pe. Ombogwera-ma rire he'i: —Eraha jevy nde ra'y, he'i túvy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ha entéro ohexa va'e opondera ndera oiko-vy: —Ipu'aka tee va'e voi nipo Nhandejáry ra'e, he'i hikwái hese. Ha Hesu rembiapo porã ete-rehe opondera-vy oiko jave, Hesu he'i gwemimbo'e kwéry-pe: ");
INSERT INTO kgkNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Pejeapysaka porã katu ko xe nhe'ẽ amombe'u va'erã-rehe peẽ-my. Ajekwaa uka-tama peẽ-my. Xe Nhande Ryke'y tee va'e xe mombe'u-ta voi xe pyhyharã-pe. Xe pyhy-ta xe reraha-ta kente kwéry xe juka hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ha Hesu nhe'ẽ katu ndoikwaái voi. Ojeapysaka rei hikwái ndoikwaái inhe'ẽ. Onhenhomi íxugwi, upéa-gwi ndoikwaái. Ha mba'eve noporandúi íxupe. Otĩ eterei oporandu hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ha onhomongeta onhondive hemimbo'e kwéry: —Kiva'e opyta-ta onhembotuvixave hagwã —oporandu randu ojóupe. Onhembotuvixaseve mo'ã hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Hesu ae katu oikwaa-ma joty mba'e-rehe onhepy'amongeta hikwái. Upéa-rehe oipyhy mitã oyke-py omoĩ omombe'u hagwã íxupe kwéry hekorã. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Eremogwahẽ ramo mitã xe réry-py, ererovy'a ramo íxupe, xe mogwahẽ ave arã. Xe mogwahẽ ramo katu, eremogwahẽ ave arã xe mbouhare-pe ave, he'i. —Nonhemboete ukái va'e-pe Nhandejáry ombotuvixa-ta joty imboete-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ha João katu he'i íxupe: —Orohexa-ma kuri kwimba'e omosẽ ramo anháy-pe, mbo'eháry. Omosẽ imondo-vy nde réry-py. Ha upe va'e nanhane moirũi-gwi oro'e íxupe “Ani eremosẽ teĩ Hesu réry-py” oro'e kuri íxupe, he'i Hesu-pe João. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ha Hesu katu he'i: —Ani erejoko teĩ íxupe xe nhe'ẽ-py oiko va'e. Nhande-rehe ndaija'e'ỹi va'e nhane pytygwõ va'e joty, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Haimete ogwahẽ-ma hi'óra ojeupi jevy hagwã yváy-py. Upe-ma ramo he'i gwemimbo'e kwéry-pe: —Taha jevy ranhe Jerusalém tetã-my, he'i. Ohose eterei jevy Jerusalém-my. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Omondo gwenonderã gwĩ hendive okwa va'e. Osẽ-ma oho-vy ohexa hagwã Hesu rejupagwã. Jerusalém tetã rape ku'a-py rei Samaria yvy pygwa tetã'i-my ogwahẽse mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ha upe pygwa oikwaa-ma ramo Hesu ohose Jerusalém-my, nomogwahẽ mo'ãi henonderã-rupi oho va'e-pe gwetã-my. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Upéa-rehe hemimbo'e Tiago, João ave oporandu Hesu-pe: —Mbo'eháry, ereipota tipo orohenói tata yváy-gwi ho'a hagwã ko tetã mygwa ári ohundipa hagwã íxupe kwéry, he'i oporandu-vy nomogwahẽ ukái-gwi íxupe upe pygwa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Hesu ojere ha onhemonhe'ẽ íxupe kwéry: —Naháni. Ndikatúi. Ani erejapo vai hese kwéry, he'i. —Ndereikwaái vyteri xe ae xe rekoha. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Xe Nhande Ryke'y tee va'e aju aresende hagwã kente kwéry. Nahundiséiry avave-pe, he'i onhemonhe'ẽ-vy íxupe kwéry. Upéi ohasa oho-vy tetã'i ambue-py ogwahẽ oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hesu ndive oje'ói hikwái. Ha peteĩ va'e he'i íxupe: —Oromoirũ meme-ta mamo ereho ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hesu ae he'i íxupe: —Mba'eixagwa pa xe amombe'use peẽ-my. Agwara kwéry ogwereko okeha yvyrakwa, gwyra kwéry gwaity ogwereko. Ha xe, Nhande Ryke'y tee va'e, ndarekói xe rupagwã anhemokane'õgwa hagwã, he'i oikwaa hagwã gwekorã. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Peteĩ upe-py oĩ va'e-pe ae he'i: —Xe moirũ katu, he'i. Upe va'e he'i Hesu-pe: —Xe reja ranhe aha'arõ hagwã xe ru omano. Upe rire ae-ma aha va'erã ne ndive oromoirũ hagwã, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Upéi: —Nahániry. ãy voi aipota xe moĩru, he'i íxupe. —Xe moirũse e'ỹ va'e ae taimandu'a ranhe katu omano va'ekwe ojaty hagwã-rehe, he'i. —Nde xe moirũ meme katu, he'i. —Emoherakwã Nhandejáry nhande ruvixarã rehegwa nhe'ẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Upéi peteĩ va'e he'i jevy íxupe: —Oromoirũ-ta xe Járy. Taha ranhe tamombe'u xe róga ygwa-pe oromoirũ hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hesu ae he'i íxupe: —Xe moirũ katu. Kavaju-py omba'apo va'e-rami ani erejapo. Kavaju omboasuru yvy jave ojeapa ramo, ojapo parĩ parĩ oho-vy. Gwapykwe-koty orepara-gwi ndohexái gwenonderã. Xe-rehe nderejerovia porãi ramo kavaju-py omba'apo va'e-rami upéixa nde rekoha karẽ karẽ arã ave. Upéixa ramo ou ramo Nhandejáry nhande ruvixarã nande py'a porãi va'erã ereiko hagwã indive, he'i íxupe. —Ani ererepara rei teĩ nde rekokwe-rehe. Xe moirũ ae katu, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Upe rire oiporavo Hesu setenta kwimba'e omondo hagwã gwenonderã. Onhe'ẽ mombe'uharã omondo mokõ mokõi tetã tetã-rupi oho hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Arandu nhe'ẽ temitỹgwe kytĩháry rehegwa-rami oiporu omombe'u hagwã íxupe kwéry hekoharã. He'i íxupe kwéry: —Tuvixa eterei voi kokwe ha temitỹgwe hi'aju va'ekwe heta eterei oĩ. Upéixa ave oĩ heta eterei nohendúi vyteri va'e Nhandejáry nhe'ẽ. —Ha temitỹgwe kytĩháry ndahetáiry. Ndahetáiry-gwi ojerure kokwe járy-pe ombohetave hagwã ikytĩharã imondo-vy. Upéixa ete peẽ pejerure katu Nhandejáry-pe ombohetave hagwã onhe'ẽ mombe'uharã omosarambi hagwã onhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—Tapeho, he'i ave íxupe kwéry. —Xe oromondo-ta ãy hembiapo vai va'ety ha-rupi, he'i. —Mymba ra'y jagwarete pa'ũ-my oiko va'e-rami peiko va'erã upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ani ereraha mba'eve rei nde rupive. Ani ereraha ne mba'e ryru. Nde plata ryru ave, ani ereraha teĩ. Nde py rehegwa ave ani ereraha teĩ. Ne rogwaitĩ ramo tape-rupi, ani joty erepyta teĩ. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Eregwahẽ-ma ramo óga-py ereike-ma ramo, ere-ta óga pygwa-pe “Nhandejáry tane mbopy'agwapy porã katu” ere arã óga pygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Upe óga pygwa kwéry ojohayhu porã ramo, ipy'agwapy porã va'erã. Ha ndojohayhu porãi ramo upe pygwa kwéry, ojevypa jevy arã nde-vy ne nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Peteĩ va'e óga-py mate erepyta. Ani erembopopa óga ereho-vy. Ome'ẽ arã ne remi'urã, ne mboy'u ave arã. Ani nde py'amirĩ teĩ erekaru hagwã. Omba'apo va'e-pe ohembi'u me'ẽ voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Tetã ambue-py eregwahẽ ereho-vy ramo, ne mogwahẽ porã ramo terepyta upe-py. Ne rembi'u me'ẽ rire tere'upa mani. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Terembogwera hasy va'e upe-py okwa va'e-pe ha teremombe'u mbe'u íxupe kwéry: “Hi'agwĩ-ma pendéhegwi hi'óra Nhandejáry oiko hagwã nhande ruvixarã” ere eremombe'u-vy, he'i Hesu gwemimondorã kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Upéi: —Eregwahẽ ramo tetã ambue-py ha nane mogwahẽ porãi ramo, hape heta-rupi teregwata gwata-vy eremombe'u-vy. Enhe'ẽ hatã atã eremombe'u-vy, “Oĩ xe py-rehe ne retã timbore. Ambovava-ta xe py xe py-gwi ho'apa hagwã ereikwaa tee hagwã Nhandejáry nhe'ẽ nerehenduséiha. Ne mo'agwĩ-ma ra'e ou-vy Nhandejáry nhande ruvixarã, ha nerehenduséi upe xe remimombe'u hesegwa nhe'ẽ. Upéixa-gwi napene arandu porãiry pejejavy-vy” emombe'u íxupe kwéry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—Anhetegwa ha'e-ta peẽ-my, Nhandejáry ojohu-ta enterovéa-pe hembiapokwe-rehe, ha ombohasa asy-ta ójehe ojerovia e'ỹ va'e-pe. Hekoha vai eterei va'ekwe Sodoma tetã mygwa kwéry. Upéixa-gwi Nhandejáry ombohasa asy va'ekwe íxupe kwéry. Ha ko'ãygwa nohenduséi ramo ne remimombe'u, nohenduséi-gwi ombohasa asy eterei va'erã íxupe kwéry. Sodoma tetã mygwa ohasa asy va'erã, ha upe ne nhe'ẽ xe rehegwa nohenduséi va'e ohasa asyve va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Upe rire Hesu omombe'u tetã ambue-rehe. —Peẽ Corazim tetã mygwa kwéry apomboasy peẽ-my. Pehasa asy ete va'erã. Peẽ Betsaida tetã mygwa kwéry apomboasy peẽ-my. Pehasa asy va'erã. Hexapyrã-rupi xe rembiapo porã meme pene retã-my ajapo-ma pejerovia hagwã mo'ã xe-rehe. Ko'ãixagwa hexapyrã-rupi xe rembiapo porã ramo ra'e Tiro tetã-my, Sidom tetã-my, pya'e voi ojerovia arã araka'e xe-rehe upe pygwa kwéry. Omboasy arã araka'e gwembiapo vaikwe. Gwekohakwe-rupi ivy'are'ỹ va'e ao omonde arã araka'e, ivy'are'ỹ va'e renda-py ogwapy arã araka'e onhehapirõ-ma voi arã araka'e. Tanimbu oipixy arã ójehe araka'e ojekwaa-vy. Ogwerova arã araka'e gwekoha, oiko arã mo'ã araka'e Nhandejáry reko-rupi. Ndaxe rexái-gwi ndojeroviái xe-rehe. Ohexa ramo araka'e, pya'e ogwerova arã gwekoha araka'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kente kwéry hembiapo apokwe-rehe ojerereko ramo, hembiapo vai va'e-pe ombohasa asy va'erã Nhandejáry. Upe áry ombohasa asy voi arã Tiro tetã mygwa-pe, Sidom tetã mygwa-pe ave. Ha peẽ-my ombohasa asyve syve va'erã íxugwi upe tetã mygwa kwéry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Peẽ Cafarnaum tetã mygwa napenhembojeupi mo'ãi Nhandejáry renda-py. Ndereho mo'ãi yváy-py. Peẽ-my pene mbogwejy va'erã tatagwasu ogwe e'ỹ va'e-py, anháy renda-py peho va'erã, he'i Hesu omotenonde-vy gwekoha vai-gwi ndogwerovái va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Upéi he'i gwemimondorã kwéry-pe: —Kente ohendu ramo ne nhe'ẽ, xe nhe'ẽ ave ohendu-ma va'erã. Ha nde-rehe ija'e'ỹ va'e, ija'e'ỹ ave arã xe-rehe. Ha xe-rehe ija'e'ỹ va'e, ija'e'ỹ ave arã Nhandejáry xe mbouhare-rehe ave arã. Tereho xe renonde-rupi xe nhe'ẽ eremombe'u hagwã tetã tetã-rupi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ha upéi katu omombe'u mbe'u Hesu nhe'ẽ rire, ou jevy upe setenta hemimondo va'ekwe, Hesu ha-py ogwahẽ jevy ou-vy. Ovy'a ete reheve ogwahẽ jevy omombe'u Hesu-pe: —Mbo'eháry, ore nhe'ẽ-py osẽsẽmba oje'ói-vy anháy hese omenda va'ekwe-gwi. Nde réry orohenói ramo, ore nhe'ẽ-py osẽmba oje'ói-vy, he'i omombe'u Hesu-pe ovy'a voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ha'e katu: —Ha'e voi. Ahexa-ma kuri anhaygwasu Satanás ho'a-ma yváy-gwi. Overa va'e-rami ho'a va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","—Pejeapysaka porã katu xe nhe'ẽ-rehe. Xe apombopu'aka-ma opamba'e vai-rehe, anháy-rehe jepe apombopu'aka-ma joty. Ndojehu mo'ãi peẽ-my mba'eve ivai va'e. Erepyrũ ramo mbói-rehe erepyrũ rei va'erã joty. Japeusa-rehe ave erepyrũ rei va'erã joty. Xe nhe'ẽ-py apombopu'aka-ma. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","—Anháy kwéry ohendu-ma jepe ne nhe'ẽ, ani erevy'a joty teĩ upéa-rehe. Oĩ iporãve va'e nde-vy ne mbovy'a tee hagwã. Oiko-ma peteĩ teĩ pende réry yváy-py. Ohai uka va'ekwe Nhandejáry kwatia-rehe. Peẽ he'ýi tee voi. Upéa-rehe ae voi peẽ pevy'a tee katu peiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ha upéi katu Hesu-pe ombohory ete Nhe'ẽ Marangatu tee va'e. Ovy'a eterei-gwi he'i: —Oromboete voi katu, oromomba'egwasu ave xe Ru, yváy-py ereiko va'e. Nde ko, yváy Járy voi, nde. Nde ko, yvy Járy ave ko nde. Ne arandu, nde rekoha rehegwa ereikwaa uka gwĩ ne arandu oikwaase va'e-pe. Ha onhemo'aranduseve va'e-pe nderejekwaa uka mo'ãiry nde. Eremokanhy uka ne arandu porã íxugwi. Nonhemo'arandusevegwasúi va'e-pe ae, gwĩ “Mitã-rami ne'írã aikwaapa” he'i ójehe onhemomixĩ-vy va'e-pe erejekwaa uka. Ne remimbota porã-rupi erejapo upéa. Ne arandu tee va'e nde, he'i Nhandejáry-pe omboete-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Upéi he'i: —Xe Ru omoĩ va'ekwe opa va'e xe pogwy-py. Xe mbopu'aka va'ekwe hese kwéry, he'i. —Ha xe kwaapaha ndaipóri. Xe Ru mate xe kwaapaha. Ha ndaipóri ave xe Ru kwaapaha. Xe ae, ta'ýry, xe anho mante aikwaapa íxupe. Aikwaa ukase ramo ambue va'e-pe, ha'e ave oikwaapa va'erã xe Ru-pe, he'i Hesu ojekwaa uka-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Upéi ojere onhe'ẽ mbegwe hagwã gwemimbo'e kwéry-pe. —Ovy'a ete va'erã pene rembiexa exa ohexa va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ha'e-ta voi peẽ-my: Yma gware, Nhandejáry nhe'ẽ-py omombe'u va'ety amyrĩ kwéry, mburuvixagwasu amyrĩ kwéry ave oipota eterei mo'ã va'ekwe ohexa pene rembiexa va'e ha ndohexáiry. Xe, Nhandejáry rembiporavo va'e xe rexase eterei mo'ã va'ekwe. Ndaxe rexáiry. Ohenduse eterei mo'ã ave va'ekwe pene remiendu endu va'e ha nohendúiry. Ha peẽ pehendu-gwi pevy'a ete voi peiko-vy, he'i Hesu gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Upéi peteĩ judeu rekombo'ehaty omonhe'ẽ avyse mo'ã Hesu-pe. Moisés amyrĩ rembihaikwe-rehe omombe'u meme upe va'e ha he'i Hesu-pe: —Mba'e tipo ajapo-ta opave e'ỹ hagwã xe rekove, mbo'eháry, he'i ombojejavy ukase mo'ã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ha Hesu katu he'i: —Moisés amyrĩ ohai va'ekwe kwatia-rehe jaikwaa hagwã Nhandejáry remimombe'ukwe. Nde, eremonhe'ẽ kwatia nhe'ẽ kwaa va'e ereikwaa-ma ra'e eremombe'u jevy hagwã. Mba'e tipo eremonhe'ẽ upe-py? he'i Hesu mbo'eháry-pe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Upéi upe mbo'eha he'i jevy Hesu-pe: —“Ejerovia katu Tupã Nhandejáry-rehe. Ehayhu íxupe nde py'apy gwive. Nde koty gwive ave ehayhu íxupe. Ne mandu'a meme hese hayhu-vy. Íxupe ehayhu mbaraete ete porã katu.” Ha “Ehayhu katu nde rapixa kwéry-pe. Nde ae nde rekoha erejehayhuha-rami ehayhu rei katu íxupe kwéry” he'i oikwaa-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Ere porã —Hesu he'i upe mbo'eha-pe. —Upéixa erejapo ramo nde rekove opave'ỹ va'erã, he'i Hesu íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","He'i-ma ramo upe Moisés remimombe'ukwe-rehe mbo'eha onhemboheko porãse mo'ã. Upéixa-gwi oporandu jevy Hesu-pe. —Kiva'e-rehe he'ise xéhegwi hi'agwĩ va'e? Kiva'e tipo ahayhu-ta? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Upéi Hesu omombe'u íxupe kiva'e jahayhu hagwã ojeporiahuvereko va'e rehegwa nhe'ẽ-rami: —Peteĩ kwimba'e ogwejy oho-vy Jerusalém tetã-gwi, he'i. —Ohose mo'ã Jericó tetã-my upe judeu va'e. Tape ku'a-rupi hekoha vai va'e oipyhy íxupe. Oipe'a ijao, oinupã íxupe, ogwerahapa imba'e kwéry omondapa íxugwi. Mba'eve ndohejái íxupe. Ogwerahapa imba'e kwéry íxugwi. Ha oinupã eterei-gwi haimete ojuka íxupe. Omano-tama ramo oheja íxupe tape yke-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","—Upe rire, oime jave tape yke-rehe ou pa'i judeu kwéry ruvixa pa'i va'e. Ohexa-ma ramo omano-tama va'e ohasa rei joty tape yke rovái-rupi oho-vy. Noipytygwõi hasy va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","—Upéixa ave ojapo pa'i pytygwõha ave. Noipytygwõi omano-tama va'e-pe. Ogwahẽ-ma ramo henda-py, ohexa-ma ramo íxupe oikupe'o hasy va'e-pe oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","—Upéi peteĩ Samaria pygwa va'e ogwahẽ ou-vy tape-rupi. Samaria yvy pygwa judeu kwéry-rehe ija'e'ỹ va'e jepe, ohexa-ma ramo omano-tama va'e-pe, oiporiahuvereko íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ha'e ae jepe oipytygwõ judeu va'e-pe. Oipohano íxupe. Ikutu hagwe-py omoĩ óleo, omoĩ ave vinho, ombogwera hagwã. Upéi ojokwa ave íxupe ikutu hagwe. Upe rire ohupi gwenda ári ogweraha hagwã ombohupa róga-py. Upe-py onhangareko hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","—Ko'ẽmba-ma ramo, oho mombyry e'ỹ ngatu, upe Samaria pygwa onhomongeta mbohupa róga járy ndive. He'i: “Taha xe tape puku-rupi. Mombyryve aha-ta. Ko, mokõi plata ame'ẽ-ta nde-vy. Enhangareko porã ko hasy va'e-rehe xe rekovia enhangareko porã hese” he'i. “Ereiporupa ramo ko plata hese erenhangareko-gwi, hetave ame'ẽ-ta nde-vy. Agwahẽ jevy ramo hepyve ramo ame'ẽ jevy-ta nde-vy. Enhangareko porã hese xe rekovia” he'i mbohupa róga járy-pe, he'i Hesu arandu rehegwa nhe'ẽ mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Upéa omombe'u rire, Hesu oporandu mbo'eha-pe: —Mbohapy ohexa upe haimete omano va'e-pe. Nde-vy ramo kiva'e tipo onhangareko hese ohayhu va'e ramigwa? he'i oporandu íxupe onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Upe oiporiahuvereko íxupe va'e, he'i Hesu-pe. —Upéixa voi, he'i Hesu. —Ha nde, nde ave tekotevẽ ereiporiahuvereko kente kwéry-pe ave, he'i Hesu upe oity vai ukase mo'ã va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","39","Hesu, gwemimbo'e kwéry ndive, ogwahẽ oike-vy tetã'i-my. Ogwahẽ-ma ramo opyta Marta róga-py. Ha ikypy'y Maria oime ave hóga-py ogwapy oĩ-vy Hesu ha-py ohendu hagwã inhe'ẽ. Ohenduse eterei inhe'ẽ naimandu'avéi mba'eve-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ha tykéry katu ojapura pura omba'apo-vy. Hemi'urã heta ojapo-vy oho ou oho ou. Upéi ou Hesu-pe ojapura-vy: —Nerepena mo'ãi tipo xe-rehe, xe Járy? Xe kypy'y xe reja rei. Naxe pytygwõiry, he'i. —Xe ae ajapopa hagwã nhane remi'urã xe reja ou-vy naxe pytygwõséi para'e, he'i okypy'ýry-rehe. —Ere íxupe xe pytygwõ hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ha Hesu he'i: —Nahániry, he'i íxupe. —Nde erejapura eterei opamba'e-rehe. Nande py'agwapyvéi-ma, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","—Nanhaikotevẽ mo'ãi heta mba'e-rehe. Peteĩ mate nhaikotevẽve va'e. Ha nde kypy'y katu imandu'a upéa-rehe. Íxupe gwarã opa e'ỹ va'erã-rehe imandu'a, he'i Hesu onhemonhe'ẽ-vy Marta-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gwemimbo'e kwéry ndive Hesu oime peteĩ henda-py. Upe jave Hesu omondo mondo onhe'ẽ Nhandejáry-pe. Onhe'ẽmba-ma rire, peteĩ indive oĩ va'e he'i íxupe ojerure-vy: —Ore Járy, emombe'u ore-vy orombojeupi kwaa hagwã ore nhe'ẽ Nhandejáry-pe, he'i. —João araka'e omombe'u gwemimbo'e kwéry-pe. Upe va'e ramigwa ave, nde emombe'u orombojeupi kwaa hagwã ore nhe'ẽ Nhandejáry-pe, he'i ojerure-vy íxupe. Oporandu onhe'erã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aipo ramo Hesu he'i omombe'u-vy: —Koixagwa nhane nhe'ẽ Nhandejáry ndive nhanhomongeta porã ramo: “Ore Ru” ja'e-ta. “Tonhemomarangatu kena nde réry. Nde ko ore ruvixa voi. Xe ruvixa ete ko nde, te'i enterove nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ha ãy katu eme'ẽ meme ore-vy ãy gwarã ore remi'urã, ore remikotevẽ ave eme'ẽ ore-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ore poriahuvereko katu ore rembiapo vaikwe-rehe anive hagwã ne mandu'a hese. Ore-rehe hembiapo vai va'ekwe-pe oroiporiahuverekoha-rami, ore poriahuvereko katu. Ani teĩ ereheja ore rekombo'e vai anháy.” Aipo-rami voi nhanhomongeta Nhandejáry ndive, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","Upéi omombe'u íxupe kwéry arandu rehegwa nhe'ẽ. Hemikotevẽ-rehe ojerure rure va'e rehegwa nhe'ẽ-rami omombe'u: —Nde, ne remikotevẽ-rehe ereho nde re'ýi róga-py. Pyhare mbyte-py ogwahẽ ramo ne mbohupa, ha ndaipóri ramo hemi'urã, ereho nde re'ýi róga-py erejerure-vy hemi'urã-rehe. “Eme'ẽ xe-vy xe mbohupa ho'u va'erã” ere erejerure-vy. “Mbohapy mbojape eme'ẽ xe-vy amongaru hagwã íxupe. Ogwahẽ kuri xe mbohupa. Ha xe, ndarekói hemi'urã ame'ẽ va'erã” ere nde re'ýi-pe. Oĩ ramo kóixa he'i va'e nde-vy: “Oronhenomba-ma. Mitã kwéry ndive oronheno-ma. Okepa-ma mitã. Ndikatúi apu'ã aipe'a hagwã ore rokẽ.” ");
INSERT INTO kgkNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Oĩ ramo aipo-rami he'i va'e nde-vy, erejerure rure jevy va'erã. Nde re'ýi-gwi jepe nopu'ã mo'ãi joty. Erejerure eterei-gwi joty opu'ã va'erã ome'ẽ va'erã nde-vy ne remikotevẽ, he'i omombe'u-vy arandu rehegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Ha xe katu, xe ha'e-ta peẽ-my: Upéixa va'e-rami tekotevẽ erejerure rure Nhandejáry-pe. Ejerure rure katu íxupe, ne rembijerure ome'ẽ va'erã nde-vy. Eheka eka katu ndejéupe gwarã. Ne rembieka katu erejohu va'erã. Okẽ onhemboty va'e oipe'a uka hagwã ombota mbota va'e-rami, pene kyre'ỹ katu pejapo hagwã oração. Nde-vy oipe'a-ma va'e-rami okẽ, ohendu va'erã Nhandejáry pene nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gwĩ ojerure rure va'e-pe gwive ome'ẽ va'erã. Gwĩ oheka heka va'e gwive ojohu va'erã. Gwĩ ombota mbota va'e-rami oha'arõ oĩ-vy va'e-pe gwive ojepe'a va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—Nde, túvy kwéry, ereme'ẽ mba'e porã nde ra'y kwéry-pe. Pão-rehe ojerure ramo, pão rekoviarã avave nome'ẽi ita gwa'ýry-pe. Upéixa ave pira-rehe ojerure ramo, pira rekoviarã avave nome'ẽi mbói íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yrygwasu rupi'a-rehe ojerure ramo, hekoviarã avave nome'ẽi japeusa íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Peẽ kwéry pende rekoha vai ramo jepe, peme'ẽ kwaa joty iporã porã va'e pene mitãgwe-pe. Ha pende Ru yváy pygwa katu hekoha porã tee va'e. Upéa-gwi ome'ẽ kwaa porãve voi peẽ pejerure va'e-pe. Omohynyhẽ-ta nde py'a Nhe'ẽ Marangatu tee va'e. Ojerure va'e py'a omohynyhẽ-ta. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ha upéi katu Hesu omosẽ kwimba'e-gwi anháy imondo-vy. Anháy ojepota hese-gwi nainhe'ẽi, inhe'ẽnge'ỹ va'e. Anháy osẽ-ma ramo íxugwi, onhe'ẽ jevy-ma. Upéa-rehe, —Mba'éixa po oporombogweraha? he'i ojóupe opondera-vy Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ha gwĩ ipa'ũ-my oĩ va'e he'i rei Hesu-rehe: —Belzebu ojepota ra'e hese, Hesu-rehe, he'i. —Belzebu anháy ruvixa. Upéa-gwi Belzebu nhe'ẽ-py omosẽ anháy imondo-vy, he'i rei Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ha kente ambue he'i ave íxupe: —Orohexase ne rembiapo porã voiha. Nderejapo kwaái para'e, erejapo kwaa para'e. Yváy-gwi hexapyrã-rupi orohexase erejapo ramo, he'i ave Hesu-pe. Opu'akaha oiporu avy ukase mo'ã íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ha Hesu katu oikwaa-ma ipy'a-py onhemongeta okwa-vy ramo. Upéa-rehe he'i íxupe kwéry: —Ndaha'éi Belzebu nhe'ẽ-py amosẽ anháy kwéry, he'i. —Mburuvixa reminhangareko kwéry ndaijojái ramo, onhorairõ ramo, ndikatuvéi arã oiko porã onhondive. Upéixa ave óga pygwa kwéry ndaijojái ramo, onhorairõ ramo, ndikatuvéi arã oiko porã onhondive. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ha anháy ruvixa Satanás re'ýi kwéry ave ndaijojái ramo ra'e, onhorairõ ramo ra'e ave, ndikatuvéi arã ra'e oiko porã ra'e anhaygwasu gwe'ýi ndive. Ndoikovéi arã ra'e gwe'ýi kwéry-pe mburuvixa. Aipo ramo omosẽ arã mo'ã ra'e avave-gwi anhaygwasu pe anháy ruvixa va'e réry-py voi, he'i. —Ere rei kuri xe-rehe, “Belzebu nhe'ẽ-py omosẽ anháy imondo-vy” ere rei kuri xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—Ha pende re'ýi kwéry omosẽ ave anháy imondo-vy. Ma'erã-gwi nderéiry “Belzebu nhe'ẽ-py omosẽ anháy imondo-vy nhande re'ýi kwéry”? Upéa ndere mo'ãi nde re'ýi-rehe. Nde re'ýi kwéry rembiapokwe-rehe enterove oikwaa ne akã tavyha, ne rembiapo vaiha ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","—Ndaha'éi Belzebu nhe'ẽ-py xe rembiapo. Nhandejáry nhe'ẽ-py voi amosẽ mosẽ imondo-vy anháy kwéry, he'i. —Aipo ramo, xe rekoha-rehe pehexa kwaa ramo ra'e, “Oiko-ma nipo Nhandejáry nhande ruvixa ramo ra'e” peje arã ra'e xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Imbaraete va'e rehegwa nhe'ẽ-rami omombe'u arandu nhe'ẽ. Anháy-rehe opu'akaveha omombe'u. —Omonda va'e ndoikéiry imbaraete va'e róga-py. Onhangareko voi omba'e-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ogwahẽ-ma ramo imbaraeteve va'e ipu'aka va'erã hese, oipe'apa-ma va'erã íxugwi. Inhemombaraeteha, imba'e kwéry ogwerahapa arã íxugwi omboja'o ja'o arã gwapixa-pe ime'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Xe ndive omba'apo e'ỹ va'e, ojoko xe rembiapo. Xe renda-py ogwenogwa'ẽ e'ỹ va'e, xe renda-gwi omondo mombyry omosarambi-vy, he'i Hesu onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Upéi he'i jevy: —Ojepota va'ekwe hese osẽ rire, ogwata gwata jevy-ma oiko-vy anháy. Opytu'u renda-py oheka eka-vy ojehasa asa y e'ỹha renda-rupi. Ha ndotopái gwenagwã. “Xe rendagwe-py jevy aha-ta, asẽ hagwe-py aha jevy-ta” he'i ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ogwahẽ jevy-ma ramo ohexa gwendagwe. Omoatyrõmba-ma opy'a kwimba'e. Ndaiporivéi anháy ipy'a-py. Gwendagwe ohexa jevy: “Iporã voi xe rendagwe” he'i, “Opyta rei” he'i ojéupe kwimba'e py'a-rehe. “Óga járy oitypei porã rire, omoĩ porã jevy imba'e kwéry omopotĩ-vy. Upéixa upe óga járy-rami omopotĩ opy'a kwimba'e ra'e. Opyta rei xe rendagwe” he'i anháy ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Upe-ma ramo, oho oheka oirũrã kwéry. Sete anháy ojohu ivaive va'e ojéhegwi. Ogweru, omoinge jevy gwendagwe-py. Oike rire pe kwimba'e reko ivai voi. Are va'ekwe pe kwimba'e peteĩ anháy ojepota hese ramo, omboheko vai voi íxupe. Ha ãy katu ombohekoha vaive ive, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Upe he'i jave peteĩ kunha omboaty va'e pa'ũ-gwi osapukái: —Tovy'a katu nde sy, he'i, —ne mokambuhare, ne moingohare. Tovy'a voi katu he'i omboete-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hesu katu: —Tovy'ave katu Nhandejáry nhe'ẽ renduha inhe'ẽ-rupi ogwata va'e tovy'ave xe sy-gwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ha upéi katu Hesu omombe'u jevy ojogweroaty va'e-pe: —Ãygwa heko vai voi Nhandejáry-rehe. Inhe'ẽ ndojaposéi-gwi, ndojeroviaséi ave xe-rehe. “Ne rembiaporã avave ndohexái vyteri va'e ramigwa erejapo ramo, oroikwaa arã mba'exagwa nde” ere rei xe-vy. Upéa erehexa hagwã ndajapo mo'ãi. —Pene mandu'a katu myamyrĩ Jonas rehegwa nhe'ẽ-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yma va'ekwe Nhandejáry omondo myamyrĩ Jonas-pe oho hagwã Nínive tetã-my. Upe tetã mygwa kwéry oikwaa hagwã ipu'aka tee va'e voi Nhandejáry, Jonas oho upe-py. Ha xe ave, Jonas ramigwa xe mbou ave Nhandejáry pende ha-py. Xe Nhande Ryke'y tee va'e voi xe mbou ãygwa oikwaa porã hagwã ipu'aka teeha Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Ha'e-ta ave peẽ-my: Gwenonde-py Nhandejáry ombojogweroaty va'erã kente kwéry peteĩ teĩ ogwereko hagwã hembiapokwe-rehe. Upe-py ko'ãygwa onhembo'y ramo ojekwaa hagwã hembiapokwe. Ãygwa onhembo'y jave, yma gware kunha mburuvixa Sabá tetã mygwa onhembo'y ave omombe'u hagwã pene rembiapo vaiha. —Upe kunha amyrĩ ou va'ekwe amo mombyry ete ko yvy apy gwive ou ohendu hagwã mburuvixagwasu Salomão amyrĩ. Ha xe aiko ko'a-py pene pa'ũ-my. Xe tuvixave myamyrĩ Salomão-gwi. Aikwaave íxugwi ha napehenduséi xe nhe'ẽ. Upe pene rembiapo vaiha-rehe omombe'u va'erã upe kunha. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ha yma gware Nínive pygwa kwéry opu'ã va'erã onhembo'y. Ãygwa omombe'u-vy onhembo'y va'erã Nhandejáry renonde-py. Pene rembiapo vaiha omombe'u va'erã. Ha'e kwéry ohendu-ma va'ekwe Jonas remimbo'e. Inhe'ẽ ohendu-gwi ogwerova gwekoha va'ekwe. Ojerovia-ma va'ekwe Nhandejáry-rehe. Ha xe aiko ko'a-py. Xe tuvixave myamyrĩ Jonas-gwi, ha napehendu mo'ãi xe nhe'ẽ, he'i onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Upeí he'i jevy ojogweroaty va'e-pe: —Nanhamoendýi tataendy nhanhomi hagwã. Nanhamoĩry mba'e ryru gwy-py. Tataendy nhamoendy nhamoĩ hagwã hendaty-py ohesape porã hagwã oike va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","—Upéixa ave nhande resa. Hesãi porã ramo nhande resa, jahexa porã. Hembipe porã-rupi jagwata porã. Upéixa nde py'a porã ramo, Nhandejáry arandu ohesape nde py'a-py hemimbota-rupi ereiko hagwã. Ha nde resa hasy ramo, nde resa ivai ramo katu, nande resapysovéi-ma. Ndereiko porãvéi-ma. Pytũ-my vérami rei ereiko. Opyta rei ndéhegwi Nhandejáry arandu. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","—Erepara katu nde py'a reko-rehe. Nande py'a porãi ramo, pytũ-my rei vérami ereiko va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nde py'a porã meme ramo, nde py'a vai e'ỹ reheve erehexa porã va'erã. Tataendy nde resape porãha-rami erehexa porã va'erã, he'i onhemonhe'ẽ-vy upe pygwa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Onhemonhe'ẽmba rire Hesu, peteĩ fariseu va'e he'i íxupe: —Jaha katu xe róga-py jakaru hagwã, he'i Hesu-pe. Upéixa-gwi oho indive. Ogwahẽ-ma ramo ogwapy okaru hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ha Hesu ndojepohéiry okaru hagwã judeu kwéry ojapoha-rami. Upéa-rehe upe fariseu he'i ojéupe: “Ma'erã-gwi ndojepohéiry Hesu? Nhande re'ýi kwéry ojapoha-rami ndoikóiry” he'i opy'apy-py opondera-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","41","Upéi Hesu he'i íxupe: —Peẽ fariseu kwéry erejohéi ramo copo, nha'ẽ ave, ijape meme rei mate erejohéi. Nderejohéiry ipy. Jahexa ramo, “Omopotĩ porã poku” ja'e mo'ã. Ha neremopotĩ porãi joty ra'e. Ipy iky'a vyteri. Upéixa ave peẽ, nde py'a ky'a meme ne rembiapo vai-gwi. Pendejéupe gwarã peipotave tave. Upéixa ave eremonda monda-py ereiko, nane arandu porãi. Ndereikwaái para'e ijapejapoha ipy'a ave ojapo va'ekwe. Ha'e-ta ko pe'ẽ-my: Ejepy'a me'ẽ kena Nhandejáry-pe. Upe rire nde py'a potĩha rexa uka-vy eme'ẽ iporiahu va'e-pe ne remime'ẽrã. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Apomboasy voi peẽ-my, fariseu kwéry. Pehasa asy va'erã peẽ. Nhande re'ýi ojapoha-rami pejapo meme ha Nhandejáry remimbota tee nderejapói. Pene mandu'a porã peme'ẽ hagwã pene mba'e Nhandejáry-pe, ha napene mandu'ái ae peiko porã hagwã indive, kente kwéry ndive ave. Ne rembiapo porã-rehe erejerovia eterei. Eremboaty mirĩ mirĩ ne mba'e kwéry dez oĩ va'e meme eremboaty. Ha upe rire ereipe'a dez-gwi peteĩ ereme'ẽ va'erã Nhandejáry-pe. Hembyre opyta va'erã nde-vy. Mixĩ mixĩ va'e gwive ereme'ẽ Nhandejáry-pe. Ereme'ẽ itái va'e, pohã ka'agwy pygwa ave, temitỹgwe nhane remimbojehe'a va'e ereme'ẽ ave. Upéa erejapo ramo iporã. Nhande re'ýi ojapoha-rami erejapo upe va'e mba'e ereme'ẽ meme hagwã Nhandejáry-pe. Oĩve joty erejapo va'erã íxupe. Tapejogwereko porã katu. Tapehayhu rei katu Nhandejáry-pe. Upéixa mixĩve va'e-rehe pende resarái e'ỹha-rami ave, pepena katu tuvixave va'e-rehe, he'i onhemboasy-vy fariseu kwéry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Apomboasy voi peẽ-my, fariseu kwéry. Pehasa asy va'erã peẽ penhemboetese rei-gwi, he'i. —Ojeporahéi haty-rupi ereho penhemboetese rei hagwã. Upéixa-gwi eregwapyse mburuvixa kwéry pa'ũ-my ha peho ramo mba'ejogwa haty-py ereipota enterove ne mboete rei. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Apomboasy voi peẽ-my, pemohembiapo vai uka kente kwéry-pe. Upéa-rehe erehasa asy va'erã, he'i. —Peẽ peikwaa niporãi voi judeu kwéry ogwata hetekwe renda ári. Ha oĩ omano va'ekwe retekwe omoĩ rei itagwy-py hendaty e'ỹ-py omoĩ. Upéi oikwaa e'ỹ-gwi judeu ogwata arã hi'ári. Ndoikwaái-gwi ojapo vai arã. Ha peẽ fariseu kwéry upéixa ave penhomi kente kwéry-gwi Nhandejáry nhe'ẽ hi'arandurãgwe ha upéixa pemohembiapo vai uka íxupe kwéry, he'i Hesu onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Upéa-rehe he'i íxupe peteĩ teko mbo'eha: —Mbo'eháry, upéixa ramo ere vai ore-rehe ave, erenhe'ẽngi arã mo'ã ore-rehe, he'i Hesu-pe ndovy'áiry-gwi. Ndojohu porãi inhe'ẽgwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ha Hesu katu he'i: —Apomboasy voi peẽ-my peẽ Moisés remimombe'ukwe mbo'eha kwéry, pehasa asy-ta ave. Pene rembiapo vai kente kwéry-rehe. Pemombe'u ramo Nhandejáry nhe'ẽ, Moisés amyrĩ ohai va'ekwe, hasyve nhe'ẽ pemombe'u. “Tapeiko ko nhe'ẽ-rupi” peje rei pene renduha kwéry-pe. Mba'e ipohýi eterei ogweraha mo'ã hagwãixa pene remimombe'ukwe oiko íxupe kwéry. Ha, “Tapeiko ko nhe'ẽ-rupi” peje hese. Peẽ ae ndereiko mo'ãi va'erã upe ne remimombe'ukwe-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","—Pehasa asy-ta ave pene rembiapo vaikwe-rehe. Myamyrĩ kwéry pene ramoigwasu kwéry ojuka meme va'ekwe Nhandejáry nhe'ẽ-py omombe'u va'ety-pe. Ha peẽ katu pemopu'ã ita'i pemoĩ porã hagwã ijukapyre rendagwe-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Upéa-rupi pemoĩru joty hembiapo vai va'e kwéry-pe. “Hembiapo porã oiko-vy va'ekwe nhane ramoigwasu” peje joty pemombe'u-vy. Nhandejáry nhe'ẽ omombe'u va'ety-pe ojuka va'ekwe, ha ãy katu peẽ pejohu porã upe hembiapo vaikwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Upéa-rehe Nhandejáry, inharandu tee va'e, he'i va'ekwe: “Amondo-ta íxupe kwéry xe nhe'ẽ-py omombe'u va'ety, xe nhe'ẽ mosarambihaty ave. Oĩ arã gwĩ pene rembijuka ukarã. Oĩ ave arã gwĩ pene remimbohasa asyrã” he'i va'ekwe Nhandejáry omombe'u-vy, he'i Hesu onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","—Ha ha'e-ta peẽ-my, he'i. —Upéa he'i va'ekwe Nhandejáry ombohasa asy hagwã ãygwa-pe ave. Ymagware inhe'ẽ-py omombe'u va'ety kwéry jukahare-rehe ombohasa asy-ta ãygwa-pe ave. —Ymagware Abel amyrĩ gwive Zacarias amyrĩ peve ojuka meme va'ekwe Nhandejáry nhe'ẽ mombe'uhaty-pe. Zacarias amyrĩ-pe ojuka Nhandejáry roka-py. Mymba ohapyhaty renda ypy-py onhegwahẽ e'ỹ haty renonde-py ipa'ũ-my oime jave Zacarias amyrĩ, ojuka va'ekwe ave íxupe. Ha ãygwa, “Iporã rei” he'i mo'ã ymagware rembiapokwe-rehe. Upéixa-gwi, ymagware rembiapo vaikwe ojohu porã-gwi ombohasa asy-ta ave ãygwa kwéry-pe Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Apomboasy voi peẽ-my, peẽ Moisés remimombe'ukwe mbo'eha kwéry. Pevy'are'ỹ va'erã. Naiporãi pende rekoha. Pemonhe'ẽ rei rei meme Nhandejáry nhe'ẽ. Ndaperoviaséi íxupe. Ha hese ojeroviase va'e-pe ndapehejái ojerovia ave hese peiko-vy. Upéa-rehe pehasa asy-ta voi, he'i Hesu Moisés amyrĩ remimombe'ukwe omombe'u va'e kwéry-pe onhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","He'i rire, Hesu osẽ oho-vy upe fariseu róga-gwi. Osẽ rire judeu rekombo'ehaty kwéry, fariseu kwéry ave opyta ipoxy hese. Ombojevy jevy inhe'ẽ. Oporandu opaixagwa-rehe omonhe'ẽ avy ukase mo'ã hagwã hikwái. Oheka heka rei ndotopái hembiapo vaikwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Inhe'ẽ-rehe, hembiapo-rehe hembiapo vai ombojase mo'ã hese. Ha ndikatúi omboja rei hese. Hembiapo porã meme mate Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Upe jave ojogweroaty aty heta kente. Heta eterei-gwi onhomoanhamba, opyrũmba ojóehe. Ha Hesu katu gwemimbo'e kwéry-pe ranhe he'i: —Ani kena ererovia rei fariseu nhe'ẽ. Pene mbotavyse. Mbojape mbovuha nhanhomiha-rami opy'a ky'aha omo'ã kwaa, he'i. —Ani katu upéixa ereiko teĩ. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Omokanhy va'ekwe gwive ojehexa uka jevy joty va'erã. Nhane reminhomigwe gwive ojekwaapa joty va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Opa ne remimombe'ukwe nhemi ha-py ere va'ekwe, atýra-py ohendu endu va'erã. Ere mbegwe mbegwe va'ekwe nde róga-py omombe'u hatã hatã jevy va'erã. Enterove remiendurã-rupi omombe'u hatã hatã va'erã. Fariseu rekoha-rami ani ereiko teĩ, he'i Hesu ohekombo'e-vy gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","He'i ave Hesu: —Peẽ, xe rembiayhu va'e kwéry, ani erekyhyje rei teĩ. Oĩ nhande rete jukaharã. Nhane nhe'ẽgwe-rehe ae ndaipu'akáiry voi. Ani erekyhyje rei teĩ íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tupã Nhandejáry tee-gwi ae erenhemokirirĩ erenhemomirĩ va'erã. Ha'e oipe'a va'erã ndéhegwi nde rekove. Ha upe rire oikwaa mamo pa ogwahẽ-ta ne nhe'ẽgwe. Ha'e ipu'aka tee va'e voi. Oikwaa ne mondo hagwã anháy renda-py. Upe nde rekove oipe'a kwaa va'e-gwi mate erenhemomirĩ va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","—Ani erekyhyje teĩ. Nhandejáry pene nhangarekoha voi. Ne mandu'a katu manimbe-rehe. Mixĩ eterei-gwi yvypóry nopenáiry hese. Nhavende ramo, mokõi-rehe mixĩmi nhagana arã. Ndovaléi voi yvypóry-pe. Nhandejáry ae onhangareko hese kwéry. Hymba tee voi manimbe. Omano ramo peteĩ, ha'e oikwaa gwymba omano ramoha hese kwéry opena-gwi. Ha nde-rehe openave gwembiayhu tee-gwi. Oikwaa voi nde rehegwa. Ne akã ragwe jepe peteĩ teĩ oipapapa-ma gwembiayhu tee-gwi. Upéixa-gwi ani erekyhyje teĩ va'erã avave-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Ha xe katu, he'i ave —xe Nhande Ryke'y tee va'e. Ere ramo nde rapixa-pe: “Hesu reroviaha voi ko xe” xe ave ha'e arã Nhandejáry rembigwái yváy pygwa kwéry-pe: “Xe rembiayhu voi upe va'e” ha'e arã nde-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ha ere ramo “Xe ndajerovia mo'ãi Hesu-rehe. Xe ndaiko mo'ãiry Hesu rembigwái ramo” ere ramo, xe ave ha'e arã Nhandejáry rembigwái yváy pygwa kwéry-pe: “Ndaha'éi voi xe re'ýi upe va'e” ha'e arã nde-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Xe ko Nhande Ryke'y tee va'e. Ne rembiapo vai ramo, xe-rehe erenhe'ẽ rei rei ramo jepe, omboyke-ta joty ndéhegwi Nhandejáry ne rembiapo vaikwe. Nhandejáry Nhe'ẽ Marangatu tee va'e-rehe ae erenhe'ẽ vai vai ramo nomboyke mo'ãvéi-ta ndéhegwi ne rembiapo vaikwe Nhandejáry. Nande py'a potĩ mo'ãvéi opa e'ỹ reheve. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Upéixa-gwi ou ramo ipoxy va'e nde pyhy nde reraha-vy, ani erejapura nde py'apy-py. Nde reraha ramo ojeporahéi haty-py, ani erejapura teĩ. Nde reraha ramo mburuvixa renonde-py, mburuvixagwasu renonde-py ave, ani erejapura teĩ ne nhe'ẽrã-rehe. “Mba'e tipo ha'e va'erã? Mba'éixa tipo anhe'ẽ-ta?” aipo-rami ani ere rei teĩ nde py'apy-py ereho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nhe'ẽ Marangatu tee va'e ae ne monhe'ẽ uka va'erã. Ipoxy va'e nde reraha jave, Nhe'ẽ Marangatu tee va'e ome'ẽ va'erã nde-vy ne nhe'ẽrã, he'i Hesu gwemimondo kwéry-pe pono ikyhyje oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ha ojogweroaty va'e pa'ũ-gwi peteĩ he'i Hesu-pe: —Mbo'eháry, emombe'u xe ryke'y-pe omboja'o ja'o hagwã ore ru amyrĩ mba'ekwe. Xe ave aipota xe mba'erã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Aipo ramo Hesu he'i íxupe: —Nahániry. Ndajúiry mba'ekwe amboja'o hagwã. Mba'eve namboja'o ukáiry. Ndaha'éi upearã xe aju. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Upéi he'i ave íxupe kwéry: —Pejeapysaka katu ko xe nhe'ẽ-rehe. Xáke, ani ereipota rei rei pende rapixa mba'e. Nhane mba'e reta reta rei ndaha'éi nhande rekoverã tee. Mba'eve ndererekói ramo jepe, nde py'a potĩ ramo ereiko porã va'erã, he'i onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Upéi arandu nhe'ẽ omombe'u ojogweroaty va'e kwéry-pe. Imba'e reta va'e rehegwa-rami omombe'u gwekorã: —Oime araka'e peteĩ imba'e reta va'e, ijyvy porã va'e. Ijyvy porã-gwi nipo opu'ã porã íxupe hemitỹgwe ra'e. Heta eterei hemitỹgwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Upéixa-gwi he'i opy'apy-py: “Upe xe remitỹgwe ryrurã mixĩ eterei. Heta eterei xe remitỹgwe. Ndaijái arã xe remitỹgwe ryru-py. Mba'e tipo ajapo-ta?” he'i opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Upéi he'i ave, “Aikwaa-ma ajapo va'erã. Aitypa uka-ta upe xe remitỹgwe ryru kwéry. Ambotuvixave-ta xe remitỹgwe ryrurã. Ipyahu va'e-py amboyru-ta xe remitỹgwe, xe mba'e reta ave” he'i opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","“Avy'a va'erã voi ko xe” he'i. “Xe mba'e reta reta xe mbovy'a va'erã” he'i. “Namba'apovéi arã aiko-vy, heta eterei-ma xe mba'e kwéry-gwi. Naxe kane'ovéi-ma va'erã” he'i. “Apytu'u-ta. Akaru-ta. Opaixagwa ajapo-ta anhembovy'a hagwã” he'i upe imba'e reta va'e opy'apy-py, he'i Hesu omombe'u-vy arandu rehegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","—Ha upéixa oiko jave upe imba'e reta va'e, Nhandejáry he'i íxupe: “Nde, nane arandu porãi voi. Ne rembiereko heta ndovalevéi va'erã nde-vy. Ko pyhare eremano ete-ma va'erã. Ne mba'ekwe opyta rei-ta. Nde rekoviare mate oiporu-ta. Ndovaléi voi arã nde-vy ne mba'e reta” he'i Nhandejáry upe omba'e reta-rehe opena eterei va'e-pe, he'i Hesu omombe'u-vy arandu rehegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Upéi he'i ave omombe'u-vy íxupe kwéry: —Upéixa voi omba'e reta-rehe opena eterei va'e. Omba'e reta reta ojéupe gwarã-rehe mate opena. Ha Nhandejáry remimbota-rehe nopenáiry. Ojéupe gwarã nonhongatu mo'aĩ yváy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Upéi omombe'u gwemimbo'e kwéry-pe imba'e-rehe: —Ani erejepy'apy teĩ ne remikotevẽrã-rehe. Anive ereporandu randu nde py'apy-py upéa-rehe. “Ma'erã tipo ajapo-ta xe remi'urã-rehe? Mba'éixa tipo ajapo-ta xe aorã-rehe?” niporãi aipo ere erejepy'apy eterei ereiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndaha'éi nhane rembi'u-rehe, nhande ao-rehe jaiko porã Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","—Ne mandu'a porã katu xopĩgwasu-rehe. Onhemitỹ e'ỹ va'e upéa, omono'õ e'ỹ va'e ave, ojapo e'ỹ va'e gwembi'u renagwã va'e ave, nomoĩngatúi gwemi'urã. Nhandejáry ae omongaru íxupe kwéry. Ha kente katu iporãve gwyra kwéry-gwi. Iporãve-gwi onhangareko porãve-ta hese kwéry Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","26","—Erejepy'apy eterei ne remikotevẽ-rehe. Nde ae nande pu'akái ndéjehe. Nde ae ni peteĩ áry nderehupity kwaáiry nde tujave hagwã. Nde ae nande pu'akái ndéjehe. Upéixa ramo anive erejepy'apy teĩ ne remikotevẽ-rehe, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Upéi he'i ave: —Tapene mandu'a katu yvoty nhu mygwa-rehe, okakwaa rei va'e-rehe. Nomba'apói, noipogwãiry. Iporã rei oĩ-vy. Ha'e-ta katu xe, Mburuvixagwasu Salomão amyrĩ ao iporã ete voi va'ekwe. Ha ijao-gwi iporãve voi yvoty. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ndahi'aréi va'e voi yvoty. Ãy katu oĩ, ko'ẽ ramo ipirupa jevy-ma va'erã, ohapy jevy-ma va'erã, ndaiporivéi jevy-ma va'erã. Nhandejáry mba'e voi yvoty. Onhangareko porã omba'e-rehe. Ha nde katu, nde ave Nhandejáry remimoingo va'e voi nde. Yvoty-gwi nde tuvixave íxupe. Upéixa-gwi onhangareko porãve ave nde-rehe Nhandejáry. Ma'erã nderejeroviái hese? Ejerovia ete katu hese nde py'agwapy hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","—Ani erejapura teĩ ani erevy'are'ỹ teĩ ne remikotevẽ-rehe. Ere rei rei nde py'a-py, “Mba'e tipo ajapo-ta ajohu hagwã xe remi'urã, xe ay'u hagwã?” ere rei nde py'apy-py. —Ani erejapura eterei teĩ ne remikotevẽ-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Entéro kente, Nhandejáry-rehe ojerovia e'ỹ va'e gwive upéa ojapo. Ha nde, ani erejapo ha'eixagwa. Nhandejáry, nde Ru yváy pygwa oikwaa-ma ne remikotevẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nde katu epena meme hese. Ha'e ne ruvixarã. Hemimbota-rehe mate epena. Upéixa erejapo meme ramo, ha'e nde rexakwaa porã-ta. Ome'ẽ-ta nde-vy ne remikotevẽ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Upéixa-gwi peẽ, xe rembiayhu kwéry ani pejapura rei teĩ. Napende retái ramo jepe, ani pekyhyje rei teĩ. Nhandejáry Nhande Ru yváy pygwa pende poravo-ma va'ekwe peiko hagwã hendive. Pemoirũ-ma va'erã íxupe pene ruvixarã. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Upéixa-gwi anive ne rakate'ỹ eterei ne mba'e kwéry-rehe. Iporãve ne rakate'ỹ Nhandejáry remimbota-rehe nde rekoha porãrã hagwã. Upéa-rehe evendepa ne mba'e kwéry hepykwe ereme'ẽ hagwã iporiahu va'e kwéry-pe. Upéixa erejapo nde rekoha porãve hagwã yváy-py. Hyru-py eremono'õ va'e, ne mba'e, ndohói arã ne ndive yváy-py. Ndaha'éi upe pygwarã ne mba'e ko yvy pygwa va'e. Nhandejáry remimbota-rupi ereiko ramo ae, nde rekoha porãrã erehupity arã yváy-py. Nde rekoha porãrã hemimonda e'ỹ va'e, hembi'u e'ỹ va'e ave nde ao raso rembi'u e'ỹ va'e ave nde rekoha porãrã. Ne rakate'ỹha-rehe erepena pena va'erã. Erepytase arã indive. Upéixa-gwi iporãve nde-vy ne rakate'ỹ Nhandejáry remimbota-rehe, he'i Hesu gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","37","Upéi he'i jevy Hesu: —Xe ra'arõ katu xe Nhande Ryke'y tee va'e agwahẽha óra. Amombe'u-ta peẽ-my mba'éixa pa tekotevẽ xe ra'arõ mburuvixa-pe oha'arõ va'e rehegwa nhe'ẽ-rami. —Oĩ va'ekwe imba'e reta va'e. Oho omenda va'e karugwasu ha-py. Ha hembigwái kwéry oha'arõ arõ íxupe ou jevy hagwã. Oku'a jopyha ndoipe'áiry. Tataendy nombogwéiry. Oha'arõ tee oiko-vy. Omonhenduha oha'arõ. Ogwahẽhaty oha'arõ sapy'a ogwahẽ ramogwarã oipe'a hagwã okẽ. —Ha'e-ta katu peẽ-my: Ovy'a voi va'erã upe ijáry-rehe oha'arõ va'e kwéry. Ogwahẽ ramo ijáry, ogwereko porã va'erã gwĩ gwembigwái ndokéiry va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","40","—Avave ndoikwaái igwahẽ hagwã áry. Pyhare pyte-py para'e ogwahẽ-ta, haimete-ma ko'ẽ jave para'e ogwahẽ-ta. Oha'arõ arõ joty oiko-vy hembigwái. Ogwahẽ ramo ijáry ndokéi va'e ovy'a va'erã. Ijáry joty ohexakwaa va'erã upe gwembigwái ha'arõha-pe. —Upe hembigwái ha'arõháixa peẽ katu tapeiko xe ra'arõ-vy, he'i Hesu. —Xe Nhande Ryke'y tee va'e aju jevy-ta. Avave ndoikwaái agwahẽ hagwã áry. Xe ra'arõ arõ-vy katu peiko kena. —Amombe'u jevy-ta mba'éixa pa tekotevẽ xe ra'arõ óga járy nhe'ẽ-rami, he'i Hesu. —Óga járy oikwaa ramo ra'e imonda va'e ogwahẽ ramoha áry ndokéi arã ra'e ha'arõ oiko-vy pono oike imondase va'e. —Upéixa ave peẽ xe ra'arõ-vy peiko katu. Ndereikwaái arã xe agwahẽ hagwã áry. Tane mandu'a meme katu xe-rehe. “Ogwahẽ-tama para'e” ere xe-rehe. Upéixa xe ra'arõ, he'i Hesu gwembiayhu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Upéi Pedro he'i Hesu-pe oporandu-vy: —Kiva'e-pe eremombe'u kuri arandu rehegwa nhe'ẽ, ore Járy? Ore-vy gwarã para'e, entéro va'e pegwarã para'e? he'i oporandu-vy. —Ore, ndoroikwaáiry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—Amombe'u-ta peẽ-my tembigwái rekoha rehegwa nhe'ẽ-rami peha'arõ hagwã peiko-vy, he'i. —Kiva'e po hekoha porã va'e, kiva'e po hekoha vai ave amombe'u-ta peẽ-my, he'i. —Oĩ va'ekwe kwimba'e heta hembigwái va'e. Mombyry ohose-gwi he'i gwembigwái hi'arandu va'e-pe: “Xe mba'e-rehe enhangareko katu. Xe rembigwái kwéry-rehe eremanda ave. Eremboja'o ja'o hagwã ereme'ẽ-vy hemi'urã kwéry íxupe gwarã” he'i. Upéa he'i rire oho oheja gwekoviarã ijáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","—Ogwahẽ jevy-ma ramo otopa jevy gwembigwái-pe. Ovy'a voi arã upe ijáry nhe'ẽ-rupi omanda porã va'e ogwahẽ jevy-ma ramo herekwa. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","—Anhetegwa amombe'u-ta peẽ-my: Upe herekwa va'e ovy'a eterei va'erã gwembigwái ndive. Ovy'a-gwi he'i va'erã íxupe: “Iporã voi ne rembiapokwe. Avy'a voi ne rembiapokwe-rehe. Upéixa-gwi xe areko va'e-rehe erenhangareko meme-ta.” Aipo he'i arã ijáry gwembigwái porã va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","—Ha ndovy'a mo'ãi va'erã upe ijáry nhe'ẽ-rupi ndoikói va'e, omanda vai va'e. Upéa, ndoúi jave ijáry, he'i rei arã nipo opy'apy-py “Hi'are-ta voi xe rerekwa.” Ha upéa-rehe nahembiapo porãvéi-ma. Tembiapo vai vai ojapo. Onhembosarái hembigwái ambue kwéry-rehe, kwimba'e-pe kunha-pe ave oinupã nupã oiko-vy. Okaru karu oiko-vy. Oka'u ka'u ave oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","—Ha hembiapo vai jave, ojáry-rehe naimandu'avéi jave, ogwahẽ jevy va'erã ijáry. Ogwereko asy asy ete uka va'erã gwembigwái hembiapo vaikwe-rehe. Omoĩ uka va'erã upe gwembigwái hembiapo vai va'e kwéry ha-py. Nhandejáry-rehe ndojeroviái va'e ha-py omondo arã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Ha'e-ta ave peẽ-my: Upe ijáry remimbota oikwaa-ma jave ojapo e'ỹ va'e ohasa asy asy va'erã. Gwembiapo porã e'ỹ-rehe ohasa asy va'erã. Ndojaposéi-gwi ndojapói. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ha upe ijáry remimbota ndoikwaái va'e hembiapo vai-rehe jepe ndohasa asy etéiry va'erã joty. —Heta ome'ẽ me'ẽ rire nhande-vy, hekovia heta ojerure rure ave arã. Hetave tave ome'ẽ rire, hetave tave ave ojerure rure arã nhande-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Upéi he'i jevy Hesu: —Aju va'ekwe ko yvy-py. Tata-rami aru xe pu'aka kente kwéry-rehe. Ambojepotase eterei va'e vérami aiko-vy pya'e hendy porã hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tekotevẽ ae ahasa asy xe aiko-vy ou e'ỹ mboyve. Ajepy'apy hese aha'arõ-vy. Ahasa asy ha'arõ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","—Pende py'a-py penhemongeta rei xe-rehe. “Ou ombopy'agwapy enterove-pe peteĩxa oiko hagwã hikwái. Ou ponove ndaija'éi ojóehe ou-vy” peje rei xe-rehe peiko-vy. Ndaha'éiry upéa-rehe xe aju. Aju kente kwéry amboja'o-vy. Ndaijojavéi voi va'erã kente kwéry xe-rehe ha-py. Napeteĩxáiry voi va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ãy gwive he'ýi kwéry, peteĩ óga gwigwa napeteĩxavéi va'erã xe moirũ va'e ipa'ũ-my oĩ-gwi. Ndaijojavéiry arã gwe'ýi kwéry ndive upéixa-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Túvy ija'e'ỹ va'erã gwa'ýry-rehe ha ta'ýry gwu-rehe. Kunha ija'e'ỹ va'erã omemby kunha-rehe ha imemby kunha osy-rehe. Kunha ija'e'ỹ va'erã ome sy-rehe. Imena sy ija'e'ỹ va'erã omemby rembireko-rehe ave. Napeteĩxái ojohayhu va'erã xe-rehe ha-py, he'i onhemombe'u-vy Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","He'i ave gwenonde-py ijaty okwa va'e-pe: —Ygwasu-gwi ou ramo arai oky hagwã, “Oky-tama nhande-vy” peje ramo, oky voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","“Yvy aku-gwi ou yvytu haku vai hagwã nhande-vy” peje ave. Haku vai voi ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Arai erehexa ramo ereikwaa-ma oky hagwã. Yvytu aku nde pete ramo ereikwaa-ma haku vai-ta ave. Áry-rehe ne arandu voi. Ma'erã-gwi nane arandu porãi Nhandejáry rehegwa nhe'ẽ erehendu hagwã. Nde, nde py'a ky'aha eremo'ã kwaa, ma'erã-gwi nane arandu porãi erehexa kwaa hagwã xe-rehe. Mbava'e-rehe po he'ise xe rembiapo porã ndapeikwaái voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ma'erã-gwi po nderejehexa kwaáiry nde rekoha-rehe ne arandu porã hagwã? he'i onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","—Oĩ ramo nde-vy ipoxy va'e, he'i ramo nde-vy: “Ne rembiapo vai va'ekwe xe-vy. Nerembohekoviái xe-vy xe mba'e ne rembiporu va'ekwe. Upéa-rehe aha-ta mburuvixa-pe oromombe'u-vy.” Aipo he'i ramo nde-vy, ani nde poxy teĩ joty. Enhe'ẽ mbegwe mbegwe joty íxupe. Nde reraha ramo mburuvixa renda-py, tape-rupi erenhe'ẽ porã porã joty íxupe ponove ipoxy ne ndive. Ereiko porã jevy hagwã indive embopy'a porã jevy ndejéupe. Ipoxy reheve ogwahẽ ramo mburuvixa renda-py, niporãi arã voi nde-vy. Ne rembiapo vai-rehe mburuvixa ne moĩ uka arã preso. Polícia-pe nde pyhy uka va'erã, nde reraha uka va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nde, neresẽvéi-ma va'erã ne moĩ hagwe-gwi. Erembohekoviapa ete-ma rire mate, ne mosẽ jevy va'erã, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Upe jave ogwahẽ Hesu ha-py omombe'u íxupe: —Mburuvixa Pilatos ojuka uka araka'e gwĩ galileu kwéry-pe. Oime jave Nhandejáry-pe ojeporahéi haty-py, ojuka íxupe kwéry. Nhandejáry-pe omboete jave gwymba ojuka uka-vy íxupe ave ojuka, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","Upéa-rehe Hesu he'i íxupe kwéry: —Ani ere teĩ nde py'apy-py: “Ojejavy eterei va'e-pe mate Nhandejáry ombohasa asy onhehundipa” ani ere teĩ upéa-rehe, he'i. —Anhete ha'e-ta nde-vy, ndererovái ramo nde rekoha, sapy'a ou va'erã Nhandejáry ne mbohasa asyharã, ne rembiapo vai-rehe eremano va'erã, he'i onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","5","—Ho'a-ma ramo va'ekwe upe óga yvate vate va'e héry Siloé, dezoito omano va'ekwe. Hi'ári ho'a-gwi omano joa-ma hikwái. Kóxa ani peje teĩ hese kwéry: “Hembiapo vai eterei va'e voi nipo ra'e. Jerusalém mygwa kwéry-gwi nipo ra'e hembiapo vaive ra'e. Upéa-gwi nipo ra'e ombohasa asy íxupe Nhandejáry onhehundipa hagwã.” Ani peje teĩ aipo-rami hese kwéry. Anhete ha'e-ta nde-vy. Ndererovái ramo nde rekoha, nderejeroviái ramo Nhandejáry-rehe, nde ave upeixa sapy'a eremano arã, erenhehundi arã, he'i Hesu onhemonhe'ẽ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ha upéi katu Hesu omombe'u arandu nhe'ẽ figo máta rehegwa nhe'ẽ-rami. —Uvaty mbyte-py kwimba'e onhoty va'ekwe peteĩ figo yvyrarã. Upéi hi'are rire ou oheka mo'ã ijyva figo. Ha ndojohúi. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Upéixa-gwi he'i gwembigwái-pe uvaty-rehe onhangareko va'e-pe: “Ohasa-ma mbohapy ro'y upe figo máta anhoty hagwe. Hi'a-rehe aju meme mo'ã. Ndaipóri. Ndahi'áiry joty. Oĩ rei-ma. Eity íxupe” he'i gwembigwái-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ha hembigwái he'i íxupe: “Iporãve ereheja peteĩ ro'yve íxupe” he'i hembigwái gwerekwa-pe. “Ajo'o porã-ta ijerekwe-rehe. Amohu'ũ-ta amoporãve yvy ijerekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Peteĩ ro'y rire jevy hi'a ramo iporã arã. Ha hi'a e'ỹ vyteri ramo katu, aity arã íxupe” he'i gwerekwa-pe. Upe arandu rehegwa nhe'ẽ, figo yvyra rehegwa-rami omombe'u Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Peteĩ pytu'uha áry-py Hesu oho jevy omombe'u ojeporahéi haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ha ogwahẽ kunha ikarapã va'e. Ojapo-ma dezoito ro'y ikarapãha oiko-vy. Ndahi'yvi porãvéi-ma. Anháy ojepota hese-gwi omokarapã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ha ohexa-ma ramo íxupe, Hesu ohenói gwenda-py. Upéi he'i íxupe: —Kunha, orombogwera-ma nde rasy vaikwe-gwi, ");
INSERT INTO kgkNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","he'i hese opo omoĩ-vy. Upe jave opu'ã porã-ma kunha. —Nhandejáry imarangatu tee va'e, he'i kunha omboete-vy. Nhandejáry ombogwerahare-pe omomba'egwasu. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Upéa-rehe ojeporahéi haty járy he'i ojogweroaty va'e kwéry-pe: —Ani teĩ ereju pytu'uha áry-py ne mbogwera uka hagwã, he'i. —Áry rei-py katu ereju va'erã, he'i íxupe. —Seis áry meme-py nhamba'apo meme. Peteĩ áry-py japytu'u. Anive ereju pytu'uha áry-py ne mbogwera hagwã, he'i íxupe ipoxy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hesu katu he'i íxupe: —Nde, nde py'a ky'aha eremo'ã kwaa eterei. Erenhemboete rei ereiko-vy. Ndereikwaa porãi Nhandejáry nhe'ẽ, he'i. —Pytu'uha áry-py meme eremboy'u ne rymba kwéry. Erejora ne rymba vaka, ne rymba mburika ave eremboy'u hagwã ereraha-vy y rembe-py imboy'u-vy, he'i. —“Ndaha'éi tembiapo rei ajapo amboy'u-vy” ere ereho-vy. “Áry meme hoy'u hagwã ndaha'éi hembiapo rei” ere. “Amboy'u hagwã ae xe rymba” ere. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","—Upéixa voi ave ambogwera arã pytu'uha áry-py. Kente iporãve voi mymba-gwi. Ha ko kunha Abraão remiarirõre voi. Ojapo-ma dezoito ro'y anhaygwasu Satanás ndopoíry íxugwi. Omokarapã-ma íxupe. Iporã voi pytu'uha áry-py imba'asy, anhaygwasu remimoĩgwe ajorapa-ma kunha-gwi, he'i oikwaa ukase-vy huvixa kwéry-pe gwembiapo porã. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Inhe'ẽgwe ohendu-ma ramo, otĩ-ma hese ija'e'ỹ va'e kwéry. Ha enterove ojogweroaty aty va'e ogwerovy'a Hesu rembiapokwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","He'i íxupe kwéry Hesu: —Mba'éixa aikwaa uka-ta peẽ-my Nhandejáry nhande ruvixaha? Mba'eixagwa nhe'ẽ aiporu-ta pene mo'arandu hagwã? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","—Ne arandurã amombe'u-ta temitỹ mostarda rehegwa nhe'ẽ-rami aiporu-ta, he'i. —Kwimba'e kokwe-py onhotỹ araka'e temitỹ. Héry va'e mostarda onhotỹ. Mixĩ ete va'e mostarda ra'ỹi. Okakwaa-ma rire ae oiko-ma tuvixa va'e yvyra. Hakãmby-py gwyra ojeaityvapo-ma, he'i Hesu Nhandejáry irũ hetave tave oĩ va'erã rehegwa kwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Upéi he'i jevy: —Mba'eixagwa nhe'ẽ aiporu-ta aikwaa uka hagwã peẽ-my Nhandejáry nhande ruvixaha? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","—Mbojape mbovuha rehegwa nhe'ẽ-rami amombe'u-ta. —Kunha oipyhy hu'i ojapo hagwã mbohapy mbojaperã. Ha hu'i-py omoĩ moĩ imbovuha. Ijavyte-rupi voi ojehe'apa hese. Indive ovu. Ombovupa-ma íxupe, he'i Hesu, Nhandejáry nhe'ẽ irũ hetave tave oĩ va'erã rehegwa kwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hesu ogwata gwata oho-vy Jerusalém-my. Tetã-rupi, tetã'i-rupi ohasa oho-vy. Ohasa ramo ombo'e mbo'e upe pygwa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Upe jave peteĩ oporandu íxupe: —Mbo'eháry, ndahetái tipo onheresende va'erã? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Hesu katu arandu nhe'ẽ omombe'u íxupe, okẽ rehegwa nhe'ẽ-rami. —Oĩ okẽ ereike hagwã yváy-py. Ipo'i va'e voi. Hasy peve ohasa va'erã. Heta va'e ohasase mo'ã pe okẽ-rupi. Anhetegwa ha'e-ta nde-vy. Ne kyre'ỹ re'ỹ katu erehasa porã hagwã pe okẽ-rupi, he'i Hesu ombojerovia ukase mo'ã-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Upéi omombe'u jevy Nhandejáry rehegwa nhe'ẽ óga járy rehegwa-rami. —Óga járy opu'ã omboty hagwã gwokẽ. Omboty-ma ramo ndikatuvéi-ma ereike koty-py. Okẽ-my rei erenhe'ẽ-ta. “Eipe'a ne rokẽ oroike hagwã” ere rei arã óga járy-pe. Ha upéixa ave ere rei arã Nhandejáry-pe. Ereipota mo'ã okẽ oipe'a-gwi nde-vy. “Ndoroikwaái voi nde” he'i arã nde-vy. “Ndaikwaái xe” he'i arã nde-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ha nde katu ere arã, “Nde karu rovái tee va'ekwe xe. Ne ndive hay'u va'ety tee va'ekwe xe. Xe retã-my xe mbo'e tee va'ekwe ave nde” ere arã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ha'e ae he'i arã nde-vy, “Xe katu, ndoroikwaái voi” he'i arã nde-vy. “Tereho mombyry xéhegwi. Nde ne rembiapo vai-gwi ndikatúi ereike ko'a-py. Nde-vy ndaipe'a mo'ãi ereike hagwã” he'i arã Nhandejáry nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Upéa-rehe erejahe'o va'erã. Ndaikatúi ereike-gwi Nhandejáry nhande ruvixa oiko haty-py, nde vy'are'ỹ va'erã. Ne ramói amyrĩ Abraão oiko-ta Nhandejáry ndive. Ne ramói amyrĩ Isaque ave oiko-ta Nhandejáry ndive ave. Ne ramói amyrĩ Jacó ave oiko-ta Nhandejáry ndive ave. Nhandejáry nhe'ẽ-py omombe'u va'ety amyrĩ kwéry ave oiko-ta indive. Ha'e kwéry meme Nhandejáry ndive oikopa va'erã. Ha nde, mombyry-gwi rei erehexa arã íxupe kwéry. “Ndikatúi ereike ko'a-py” he'i arã Nhandejáry nde-vy, he'i arandu nhe'ẽ oiporu-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","—Ha'e-ta peẽ-my heta heta judeu e'ỹ va'e omoirũ-ta Nhandejáry gwuvixarã-pe. Yvy apy gwive opa yvy arigwa oho-ta ave oiko hagwã Nhandejáry nhande ruvixa oiko haty-py. Upe-py ogwapy-ta indive yváy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ha heta oĩ ãy onhemboete uka e'ỹ va'e. Ha yváy-py tuvixa mba'e va'erã Nhandejáry-pe. Heta oĩ ave ãy onhemboete ukaseve va'e. Ha natuvixa mba'éiry voi va'erã Nhandejáry-pe, he'i íxupe kwéry Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ha upe jave gwĩ fariseu kwéry ogwahẽ ijukaharã omombe'u íxupe. —Nde jukaharã ogwahẽ-tama, he'i íxupe. —Ekwa katu. Ekanhy mani íxugwi. Herodes, nhande ruvixagwasu nde juka ukase-ma, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hesu ae he'i: —Xe areve-ta ko'a-py. Nakanhy mo'ãi voi íxugwi. Nhandejáry oipota-ma ramo mate amano va'erã. Ndaha'éi mburuvixa nhe'ẽ-py amano va'erã, he'i Hesu. —Mbarakajagwasu hembiapo nhemi nhemi ombotavy gwemi'urã-pe. Upéixa ete ne mbotavy meme Herodes, he'i Hesu Herodes-rehe. —Tereho jevy emombe'u íxupe xe nhe'ẽgwe, he'i. “Oĩve xe rembiaporã” ere íxupe. “Hetave anháy amosẽ-ta, hetave tave ambogwera-ta vyteri” ere íxupe, he'i Hesu omombe'u uka-vy. —“Ko'ẽ mbue mbue ramo mate ambopa-ta xe rembiaporã” ere íxupe kuri. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","“Aikwaa-ma amanotaha óra” ere íxupe, he'i. —“Ãy katu, ko'ẽ ramo ave ahase ha-py aha-ta” ere íxupe. “Ndaha'éi ko tetã-my amano va'erã. Aha ranhe-ta Jerusalém tetã-my amano hagwã upe-py” ere íxupe. “Jerusalém tetã mygwa meme ojuka Nhandejáry nhe'ẽ-py omombe'u va'ety-pe” ere íxupe, he'i Hesu omondo onhe'ẽgwe mburuvixagwasu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Upéi he'i Jerusalém tetã mygwa kwéry-rehe: —Yma gware ãy peve erejuka meme Nhandejáry nhe'ẽ-py omombe'u va'ety-pe. Ombou ramo nde ha-py, erejuka meme íxupe. Ita-py erejapi íxupe ijuka-vy. Upéixa pejapo meme voi peẽ. Xe aipota voi xe-rehe erejerovia. Xe rembiayhurã amboatyse xe ndive xe renda pygwarã. Ha nderejeroviaséi xe-rehe, he'i. —Yrygwasu ra'y kwéry ojerovia osy-rehe. Ojohu-tama ramo ivai va'e ou, omboaty ipepogwy-py. Ha'e onhangareko porã hese kwéry. Ohayhu porã gwa'y kwéry-pe. Xe ave, yrygwasu-rami, anhangareko porãse mo'ã pende-rehe kwéry. Ha nderejeroviaséi xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","—Pejeapysaka katu, anhete ha'e-ta nde-vy, aha-tama ko xe, oroheja-tama. Ava osẽ va'e-rami hóga-gwi, aha ave ne renda-gwi. Ha ndaxe rexavéi-ma va'erã. Agwahẽ jevy-ma ramo, xe rexa jevy-ma ramo, ere arã xe-vy: “Tande rovasa ete katu Nhandejáry. Ha'e ne mbouha-rupi eregwahẽ ore-vy” ere arã xe-vy, he'i Hesu onhemombe'u-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","3","Peteĩ pytu'uha áry-py Hesu oho okaru fariseu róga-py. Fariseu kwéry ruvixa upe va'e. Ha heta heta kente oĩ hóga-py. Orepara para Hesu-rehe oĩ-vy hikwái. Hi'ypa-ma kwimba'e irurupa va'e oĩ ave upe-py. Hesu renonde-py oĩ. Ha fariseu kwéry, Moisés remimombe'ukwe mbo'eha kwéry ave oha'arõ ohexa hagwã. —Mbava'e nipo Hesu ojapo arã, he'i ojóupe hikwái. —Oporombogwera-ta para'e pytu'uha áry-py. Ndopytu'u tee mo'ãi para'e gwembiapo-gwi, he'i ojóupe orepara para jave Hesu-rehe. Upéi Hesu he'i íxupe kwéry: —Mbava'e tipo iporã Nhandejáry-pe jajapo hagwã pytu'uha áry-py? Oipota tipo nhaporombogwera? Oipota tipo ndajaiporiahuverekói hasy va'e-pe? Peẽ nipo pejohu vai ra'e nhaporombogwera ramo pytu'uha áry-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ha okirirĩmba íxugwi. Upe-ma ramo ombogwera hasy va'e-pe. Upéi he'i íxupe: —Tereho jevy nde róga-py, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Upéi omombe'u jevy íxupe kwéry pytu'uha áry rehegwa nhe'ẽ. —Peẽ kwéry, sapy'a pemba'apo ave pytu'uha áry-py, he'i íxupe kwéry. —Nde ra'y ho'a ramo ygwa-py, ne rymba ho'a ramo ave, sapy'a erenohẽ jevy arã upe ygwa-gwi. Nderéi va'erã “Nanohẽ mo'ãi pytu'uha áry-py” aipo ndere mo'ãi. Erenohẽ pya'e va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ohendu-ma ramo upéa nhe'ẽ, ndikatúi ojohu vai. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ha gwĩ fariseu ohenói va'ekwe ou heta okaru porã hagwã. Ha ogwahẽ ramo peteĩ teĩ oiporavo gwenagwã ogwapy hagwã. Iporãve rãve va'e-py ogwapyse. Upéa-rehe Hesu omombe'u íxupe kwéry arandu rehegwa nhe'ẽ omenda va'e rehegwa nhe'ẽ-rami. He'i: ");
INSERT INTO kgkNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—Ne renói ramo erekaru hagwã omenda va'e ha-py, ani erenhembotuvixa eterei eregwapy hagwã. Ejehexa uka porã katu. Imbotuvixapyrã va'e renda-py ani eregwapy teĩ. Imbotuvixapyrã e'ỹ-rupi eiko pono ne mbova óga járy nde gwapy ha-gwi. “Niporãi eregwapy ko'a-py. Ko va'e mburuvixave renda ae ko. Ha'e ae ogwapy-ta ko'a-py. Nde, eregwapy mombyryve xéhegwi” pono he'i nde-vy. Aipo-rami ne mbova ramo nane mbovy'ái arã. Ne mopu'ã pu'ã ramo ne motĩ-ma arã. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Iporãve eregwapy imbotuvixapyrã e'ỹ hagwã-rami. Upe-py eregwapy jave óga járy ou arã nde ha-py: “Iporãve xe ypy pyve eregwapy ko'a-py erekaru porãve arã nde” he'i arã nde-vy ne mbotuvixave-vy va'erã. Upéixa ramo ohendu va'e ne mbotuvixave va'erã enterovéa-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ha'e-ta peẽ-my, onhembotuvixaseve va'e-rehe avave nopenáiry, ha upe onhemomirĩve va'e-pe katu ombotuvixave va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Upéa omombe'u rire he'i gwenoihare-pe: —Nde, ereporomongaru porãse ramo, ani erehenói nde-vy jevy ne mongaru va'erã kwéry-pe. Nde rapixa kwéry, nde ryvy kwéry, nde ryke'y kwéry, nde re'ýi kwéry, nde rapixa imba'e reta va'e kwéry ave ani erehenói upe va'e kwéry mante eremongaru porã hagwã. Ha'e kwéry ne renói jevy arã ne mohekoviarõ uka arã. Ha ko yvy-py mate iporã va'erã nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","14","—Iporãve ereporomongaru porãse ramo jepe ne mohekoviarõ e'ỹ va'erã-pe joty erehenói. Iporiahu va'e kwéry, ikarapã va'e kwéry, ogwata e'ỹ va'e kwéry, hesapyso e'ỹ va'e kwéry ave erehenói va'erã eremongaru porã hagwã íxupe kwéry. Upe va'e kwéry ndogwerekói mba'eve ne mongaru jevy hagwã. Upéa erejapo ramo Nhandejáry katu nde rovasa porã arã yváy-py, he'i íxupe. —Upe áry-py, entéro omano va'ekwe gwive omoingove jevy va'erã áry-py, nde rereko porã va'erã Nhandejáry ne rembiapo porãkwe-rehe, he'i Hesu ombo'e-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Peteĩ indive okaru va'e ohendu-ma ramo he'i íxupe: —Nhandejáry nhande ruvixa oiko haty-py, ovy'a ete va'erã indive okaru ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","—Néi, he'i Hesu. —Amombe'u-ta peẽ-my Nhandejáry ndive oiko va'erã rehegwa nhe'ẽ kente kwéry omongaru uka va'e rehegwa nhe'ẽ-rami. —Kwimba'e ojapo uka heta temi'urã omongaru porã hagwã heta kente-pe. Ha omombe'u heta va'e-pe ou hagwã okarugwasu ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ojapopa-ma rire omondo gwembigwái omombe'u hagwã okaru va'erã-pe. “Ejo katu, jaha jakaru. Ojapopa-ma nhane remi'urã, ere xe remihenói-pe” he'i omondo-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Ohenói-ma ramo avave ndouséi indive. Peteĩ va'e he'i uka íxupe: “Yvy ajogwa va'ekwe ahexa ranhe-ta” he'i uka. “Ahexa ranhe-ta ndaha mo'ãi ranhe. Ani erejohu vai teĩ aha e'ỹ ramo” he'i uka jevy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Upéi, hemienói ambue va'e ave he'i uka íxupe: “Heta xe rymba pyahu ajogwa va'ekwe. Tekotevẽ aikwaa nomba'apo porãi para'e, omba'apo porã para'e. Upéa-rehe ndaha mo'ãi akaru hagwã ne ndive. Ani erejohu vai teĩ, ndahái ramo” he'i uka jevy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Upéi, outro he'i uka ave íxupe: “Amenda-ma kuri. Ndikatúi aha” he'i uka ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Ogwahẽ jevy-ma ramo hembigwái omombe'upa gwerekwa-pe. Oikwaa-ma ramo ndovy'ái voi ijáry. Ima'eandu-gwi he'i gwembigwái-pe “Ekwa katu. Tereho hekoviarã embou iporiahu va'e kwéry okaru hagwã” he'i. “Tetãgwasu-py ekwa ehexa íxupe kwéry. Tapegwasu rupigwa, tape po'i rupigwa embou. Ikarapã va'e kwéry, hesapyso e'ỹ va'e kwéry, ogwata e'ỹ va'e kwéry ave embou katu okaru hagwã” he'i gwembigwái-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—Upéi oho jevy hembigwái. Ogwerupa ete rire-ma, he'i gwerekwa-pe: “Aha ambovía va'ekwe kuri ogwahẽmba-ma” he'i. “Ajohu va'e kwéry gwive ogwahẽmba-ma” he'i. “Nomboaty hetái joty. Hendarã kwéry ne'írã vyteri omohynyhẽmba” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—“Aipo ramo ekwa jevy tape tape-rupi tereho. Erejohu va'e gwive erembou hagwã henagwã-rupi ogwapy hagwã. Oĩ rei tenda va'e nhamohynyhẽ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Anhete ha'e-ta katu nde-vy: Tenonde-rupi ahenói uka va'ekwe ndo'u mo'ãvéi-ma xe rembi'u” he'i ndovy'ái-gwi hese kwéry, he'i Hesu arandu nhe'ẽ omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ogwata ramo Hesu heta eterei oho ave hapykwéri. Upéi ojere he'i hagwã íxupe kwéry: ");
INSERT INTO kgkNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Xe moirũse ramo ndikatúi xéhegwi erehayhuve avave-pe. Nde ru-pe, nde sy-pe, ne rembireko-pe, nde ra'y kwéry-pe, nde rajy kwéry-pe, nde ryke'y kwéry-pe, nde ryvy kwéry-pe, ne reindy kwéry-pe, ne ména-pe, ne memby kwéry-pe, nde ryke kwéry-pe, nde kypy'y kwéry-pe, nde kyvy kwéry-pe ave erehayhuve ramo xéhegwi ndikatúi arã xe moirũ. Xe moirũse ramo ndikatuvéi ne rakate'ỹ nde rekove-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tekotevẽ ereiko okurusugwasu ogweraha va'e-rami. Upéixa ijukapyrã-rami ndereikoséi ramo ndikatúi xe moirũ xe re'ýi tee ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Amombe'u-ta peẽ-my xe moirũse va'e rehegwa nhe'ẽ gwogarã omopu'ãse va'e rehegwa nhe'ẽ-rami. —Kwimba'e omopu'ãse ramo gwogarã ijyvate vate va'e, opy'a ndive onhemongeta porã arã. “Oĩ tipo heta xe plata ajapopa hagwã? Oĩ tipo xe pytygwõharã jajapo porã hagwã? Arekopa tipo ajapopa hagwã xe rogarã?” oporandu arã opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nonhemongeta porãi ramo omopu'ã rei ramo gwóga mo'ãrã, entéro ohexa va'e opuka va'erã hese hógarã-rehe mo'ã ohexa ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Omoĩ mo'ã gwóga renagwã. Omopu'ã ku'a ku'a rei henagwãrãgwe. Ndojapopái oheja hagwã” he'i va'erã onhembohory va'erã hóga-rehe. “Ojapo-ta mo'ã óga oheja jevy gwogarãgwe” he'i arã, he'i Hesu arandu nhe'ẽ omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Upéi he'i jevy: —Amombe'u jevy-ta peẽ-my xe moirũse va'e rehegwa nhe'ẽ mburuvixagwasu onhorairõ va'e rehegwa nhe'ẽ-rami. —Mburuvixagwasu onhorairõ-tama ramo mburuvixagwasu ambue ndive, onhemongeta porã opy'apy ndive soldado kwéry-rehe. Dez mil mate ogwereko ramo, ha hese ija'e'ỹ va'e hetave ogwereko ramo, vinte mil ogwereko ramo, oporandu arã opy'apy-py: “Isoldado kwéry imbaraeteve tipo xe soldado kwéry-gwi?” he'i arã. “Ome'ẽ-ta tipo aipe'a imburuvixave ramo oikoha íxugwi?” oporandu arã opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","—Ha nome'ẽi-tama ramo, nonhorairõsevéi-ma va'erã. Gwenonde-rupi omondo arã onhomongeta va'e. Ojerure uka-ta upe ipu'akave va'e-pe oiko porã jevy hagwã onhondive, he'i omombe'u arandu nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Upéixa ave, xe moirũse va'e tonhemongeta porã opy'a ndive. Nome'ẽi voi xe moirũ ku'a ku'a. Gwekove-rehe hakate'ỹ va'e, gwe'ýi kwéry-rehe hakate'ỹ va'e, omba'e-rehe hakate'ỹ va'e naxe moirũ etéi arã oiko-vy, he'i íxupe kwéry oiporavo uka hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Upéi he'i jevy: —Amombe'u jevy-ta peẽ-my xe moirũse va'e rehegwa nhe'ẽ juky rehegwa nhe'ẽ-rami. —He porã juky. Ha ndahéi ramo katu, ndikatúi eremoatyrõ jevy. ");
INSERT INTO kgkNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ndovalevéi-ma. Yvy pygwarã ndovaléiry. Ha ne remimomborã-ma voi va'erã upéa, he'i. —Ne aranduse ramo, ejeapysaka porã ko xe nhe'ẽ-rehe, he'i Hesu omombe'u-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Onhemboja Hesu renda-py plata-py oporombopaga va'ety kwéry, gwĩ ojejavy va'e kwéry ave inhe'ẽ rendu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ha upéa-rehe fariseu kwéry, judeu rekombo'ehaty kwéry ave onhe'ẽ rei rei hese: —Kóa nahi'arandúiry voi, he'i rei hese. —Gwĩ ojejavy va'e kwéry ndive oiko meme okaru ave indive kwéry, he'i hese ojohu vai-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Upéa-rehe Hesu omombe'u gwĩ ójehe ojerovia va'erã rehegwa nhe'ẽ ovexa kanhygwe rehegwa nhe'ẽ-rami. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Ne rymba ovexa heta ete erereko ramo, cem erereko ramo, erenhangareko hese. Peteĩ okanhy-ma ramo, ereheja upe okanhy e'ỹ va'e kwéry anho nhu porã-my ereheka heka hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Erejohu-ma ramo, “Ajohu-ma xe rymba” ere va'erã. Erehupi va'erã íxupe nde ati'y-rupi ereru hagwã ne rymba kanhygwe. Erevy'a eterei ne rymba erejohu jevy-ma ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Eregwahẽ-ma ramo rire nde róga-py erehenói arã enterove-pe jevy ovy'a ave hagwã. Nde re'ýi kwéry, nde rapixa kwéry ave erehenói arã ovy'a ave hagwã. “Ajohu jevy xe rymba okanhy va'ekwe” aipo ere arã eremombe'u-vy íxupe kwéry erembovy'a-vy jevy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Upéixa ave yváy pygwa ovy'a joa arã. Hembiapo vaikwe va'e ogwerova-ma oiko-vy ramo gwekoha ovy'a joa-ma va'erã oiko-vy. Ojejavy va'e ojerovia-ma ramo xe-rehe ovy'a joa-ma va'erã yváy pygwa ave. Heta heko porã va'e ojerovia oiko-vy ramo xe-rehe ombovy'a arã yváy pygwa kwéry. Ha peteĩ hekoha vai va'ekwe ogwerova ramo gwekoha katu, ombovy'agwasuve arã íxupe kwéry, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Upéi omombe'u jevy arandu rehegwa nhe'ẽ omba'e oheka va'e rehegwa nhe'ẽ-rami. —Kunha ogwereko araka'e dez plata, ovale voi va'e. Ha okanhy peteĩ íxugwi. Upéixa-gwi omohendy tataendy, oitypei porã koty-py. “Tajohu jevy xe mba'e kanhygwe” he'i. Ndohejái mba'eve gwendagwe-py oitypei oheka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ojohu-ma ramo ohenói kunha kwéry-pe ogwerovy'a jevy va'erã. Hapixa kwéry, he'ýi kwéry hóga ypy rupigwa kwéry ogwahẽ-ma ramo, omombe'u: “Ajohu-ma xe plata okanhy va'ekwe. Pevy'a katu xe ndive ajohu jevy-ma xe plata” he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Upéixa ave ogwerovy'a arã Nhandejáry hekoha vai va'ekwe-pe ogwerova-ma ramo gwekoha. Ovy'a arã gwembigwái kwéry yváy pygwa ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hesu omombe'u jevy arandu rehegwa nhe'ẽ ta'ymirĩ okanhy va'ekwe rehegwa nhe'ẽ-rami. —Oiko va'ekwe kwimba'e. Mokõi ta'ýry va'e upéa. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","—Ha ta'ymirĩ he'i gwu-pe: “Eme'ẽ mani xe-vy xe mba'erã. Ãy voi eme'ẽ xe-vy. Naha'arõséi eremano rire ae areko hagwã ne mba'ekwe” he'i gwu-pe. “Iporãve ereme'ẽ xe-vy ereikove reheve” he'i gwu-pe ta'ymirĩ hereko asy-vy. Upéixa-gwi túvy omboja'o ja'o opa omba'e. Heta voi omba'ekwe omboja'o ja'o gwa'y kwéry-pe ome'ẽmba íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","—Upéi, ndahi'aréi ta'ymirĩ oho-ma mombyry. Omboatypa omba'e gwu mba'ekwe ome'ẽ kuri va'e ovendepa oho-vy. Hepykwe ae ogweraha. Mombyry ete oho. Ogwahẽ ramo tetã ambue-py ojapo opaixagwa. Omokanhy rei rei omba'e repykwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Omokanhymba-gwi mba'eve ndogwerekói, ndaiporivéi-ma imba'e, ndaiporivéi-ma ave imba'e repyrãrãgwe. Iporiahu ete jevy opyta-vy. —Ha upe rire, iporiahu ete jave tetã ambue pygwa kwéry-pe nahenhóiry hemitỹgwe. Upéixa-gwi ohasa asy upe tetã mygwa. Ndogwerekovéi gwemi'urã-gwi ivare'apa upe pygwa. Ha ohasa asyve ta'ymirĩ. Ndaipóri tembi'u-gwi ohasa asy oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","—Ivare'apa eterei-gwi oho upe-py oiko va'e-pe ojerure gwemi'urã-rehe. Ha upe va'e omomba'apo íxupe. “Eremba'apose ramo, tereho xe yvy nhu-my enhangareko xe rymba kure kwéry-rehe, xe rymba kure mongaruha ramo ereiko hagwã” he'i upe pygwa ta'ymirĩ-pe. “Iporã. Apyta-ta ne rembigwái ramo” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","—Ha hymba kwéry-rehe onhangareko jave, ta'ymirĩ ivare'a vyteri oiko-vy. “Xe vare'a” he'i. “Akaruse eterei. Xe vare'a-gwi ha'use mo'ã kente rembi'u e'ỹ va'e, ko kure rembi'u rei-ma ha'use. Pono xe juka xe vare'a ha'use mo'ã ko kure rembi'u.” He'i-ma ramo ojéupe, avave ho'u va'erã nome'ẽséi ta'ymirĩ-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Upe rire ae imandu'a jevy gwu-rehe: “Oĩ heta xe ru rembigwái omba'apo va'e. Upe xe ru róga pygwa kwéry okaru porã. Hembigwái kwéry ave okaru porã ave. Ndaivare'ái voi xe ru ndive omba'apo va'e kwéry. Ha xe, amano-tama xe vare'a eterei-gwi ko xe yvy e'ỹ-py aiko-vy” he'i ojéupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","“Taha jevy xe ru róga-py. Ha'e-ta íxupe, Ajapo vai va'ekwe nde-rehe, aipo ha'e-ta íxupe. Nhandejáry-rehe ave ajapo vai va'ekwe ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ajapo vai eterei-gwi xe atĩ agwahẽ jevy hagwã. Xe rembiapo vai eterei nde-rehe, anive, Xe ra'y, ere xe-rehe. Atĩ eterei, Xe ra'y, ere hagwã xe-vy. Aikose eterei ne rembigwái ramo, aipo ha'e-ta xe ru-pe” he'i opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","—He'i-ma ramo osẽ upe yvy-gwi ojevy hagwã gwu renda-py. Mombyry-gwi ou jevy. Ogwahẽ e'ỹ jave gwu róga-py, mombyry vyteri gwu róga-gwi ou-vy ohexa-ma íxupe túvy. Ohexa-ma ramo, oiporiahuvereko gwa'ymirĩ-pe. Oripara oho-vy ohogwaitĩ hagwã gwa'ýry-pe. Ohova pyte pyte íxupe. Oiporiahuvereko voi gwa'ýry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","—Aipo ramo ta'ymirĩ he'i gwu-pe: “Xe rembiapo vai va'ekwe nde-rehe. Xe rembiapo vai va'ekwe Nhandejáry-rehe ave. Xe rembiapo vai-gwi xe atĩ voi ndéhegwi. Anive, Xe ra'y, ere teĩ xe-vy xe rembiapo vai eterei va'ekwe-gwi” he'i gwu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","23","—“Ani eretĩ teĩ xéhegwi. Nde xe ra'y tee” he'i. “Orohayhu eterei. Avy'a orohexa-vy” he'i túvy íxupe. —Upéi he'i gwembigwái kwéry-pe omanda-vy: “Pekwa pya'e peru xe ra'y aorã. Eru ao porã ete omonde hagwã. Ikwãyrurã eru ikwã-rehe omoĩ hagwã. Ipy ryrurã eru ave omonde hagwã. Iporã porãve va'e eru xe ra'y pegwarã” he'i. —“Peru ave vaka ra'y ikyrave va'e pejuka hagwã íxupe. Heta eta vaka ro'o ja'u-ta javy'a eterei-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ko xe ra'y okanhy va'ekwe oiko-vy ha ko'ánga ogwahẽ jevy ou-vy. Omano vérami va'ekwe ha oikove jevy-ma nipo ra'e” he'i hese gwembigwái kwéry-pe. —Upéi onhepyrũ ogwahẽ ramo ovy'a joa. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Upe jave ta'y rypykwe oime kokwe-py. Gwóga-py ogwahẽ-tama ramo ohendu ombopu va'e, ohendu ave ogwahu va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ohendu-ma ramo ohenói hembigwái oikwaa hagwã: “Mbava'e tipo aipo va'e?” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Nde ryvy ogwahẽ kuri. Hesãi porã ogwahẽ ou-vy. Ovy'a eterei nde ru. Upéixa-gwi ojuka uka vaka ra'y ikyrave va'e hemi'urã.” ");
INSERT INTO kgkNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Aipo ohendu-ma ramo ta'yrusu ipoxy gwyvýry-rehe, ndoikeséi gwóga-py. Upe-ma ramo túvy osẽ oho-vy ohogwaitĩ-vy íxupe. Ojerure rure gwa'y rypy-pe oike hagwã gwóga-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","—Upe va'e ae he'i gwu-pe: “Xe katu, xe are-ma amba'apo ne ndive. Are-ma aiko ne nhe'ẽ-rupi. Ne remimbota mate ajapo aiko-vy. Ne'íra vyteri ereme'ẽ xe-vy ne rymba mixĩ va'e ha'u va'erã xe rapixa kwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ha ko ne mba'e hundipahare katu ogwahẽ ramo, ne rymba ikyrave va'e erejuka íxupe. Hembiapo vai va'ekwe nde-rehe. Opa mba'e ojapo nipo oiko-vy ra'e kunha vai ndive nipo oiko ra'e ave ha ogwahẽ ramo, ne rymba ikyrave va'e erejuka nipo ra'e íxupe.” ");
INSERT INTO kgkNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—He'i-ma ramo, túvy he'i íxupe: “Xe ra'y, nde ko ereiko meme xe ndive. Entéro xe mba'e gwive ne mba'e voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tekotevẽ javy'a ko'ánga onhondive. Ko nde ryvy, Omano, ha'e mo'ã va'ekwe hese, oikove teĩ nipo ra'e. Okanhy va'ekwe ha ko'ánga ogwahẽ jevy ou-vy. Tekotevẽ nhanhombovy'a jevy katu” he'i túvy gwa'yrusu-pe, he'i Hesu, gwĩ ojejavy rire ojehesa rerova uka va'e-rehe Nhandejáry ovy'aha kwaa uka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hesu omombe'u jevy doze gwemimbo'e kwéry-pe. Arandu nhe'ẽ omombe'u tembigwái rehegwa nhe'ẽ-rami. —Kwimba'e onhangareko uka omba'e reta reta peteĩ gwembigwái-pe. Upe imba'e reta va'e oiporu uka meme omba'e kente kwéry-pe ombohekovia hetave hagwã íxupe. Ha ohekoviarõ-vy hembigwái-pe ogweru hikwái. Ijáry ete nonhangarekói voi hese, hembigwái mate ojapo. —Upe jave gwĩ oikwaa va'e he'i imomba'apoha-pe: “Nonhangareko porãi voi ne rembigwái ne mba'e-rehe. Ndohekoviarõ porãi nde-vy oiporuruka hagwe” he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","—Ha upéi katu upe va'e ohenói uka gwembigwái-pe: “Ne rembiapo vai rerakwã ahendu kuri. Anhete pa erejapo. Nerembohekovia porãi nipo xe mba'e aheja nde-vy va'ekwe ereiporuruka hagwã. Upéixa ramo noromomba'apo mo'ãvéi” he'i gwembigwái-pe, hembiapo vai va'ekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Ha upéi katu hembigwái onhemongeta opy'apy-py: “Mbava'e tipo ajapo-ta? Xe momba'apoha xe mosẽ-ta. Namba'apo mo'ãvéi-ma íxupe. Xe kangy eterei amba'apo hatã hagwã. Ndikatúiry amba'apo mbaraete hagwã. Ndajo'o kwaái yvy. Atĩ eterei ajerure rure hagwã xe remikotevẽ-rehe. Mbava'e tipo ajapo-ta aiko porã hagwã namba'apovéi-ma ramo a-py?” he'i opy'a-py onhemongeta-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","—Upéi he'i jevy opy'a-py: “Aikwaa-ma mba'e ajapo-ta kente kwéry xe moirũ porã hagwã, xe mogwahẽ hagwã gwóga-py” he'i opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—Upéi omomba'apoha mba'e oiporu va'ekwe ohenói. Ogwahẽ ypy va'e-pe he'i: “Mbovy tipo erereve vyteri xe momba'apoha-pe?” he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Heta nhandy aiporu va'ekwe. Cem ryrugwasu-rehe areve voi íxupe.” “Ki, ehai nde kwatia-py mixĩve ereve hagwã. Cinqüenta ryrugwasu-rehe erehai” he'i oreve va'e-pe. Ome'ẽ íxupe ikwatia ohai mixĩve oreve hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—Upéi oporandu kwimba'e ambue-pe: “Ha nde tipo, mbovy tipo erereve ave nde?” he'i. “Heta trigo aiporu va'ekwe. Cem ryrugwasu-rehe areve vyteri ne momba'apoha-pe” he'i. “Ehai mixĩve nde kwatia-rehe. Oitenta ryrugwasu-rehe mate erehai” he'i ome'ẽ-vy íxupe ikwatia ohai hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Ha upéa oikwaa-ma ramo imomba'apohare he'i hese: “Hi'arandu nipo ra'e xe rembigwaikwe xe mbotavy hagwã” he'i gwembigwaikwe-rehe, he'i Hesu arandu nhe'ẽ tembigwái rehegwa nhe'ẽ-rami omombe'u-vy. Ha Hesu he'i ave: —Ha'e-ta katu peẽ-my ko'ãygwa pytũ mygwa-rami oiko va'e hi'arandu voi ombovia uka hagwã gwapixa-pe. Ha oĩ arakatu pygwa-rami oiko va'e, Nhandejáry-rehe ojerovia va'e, nahi'arandu porãi gwapixa ndive oiko porã hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Ha'e-ta ave peẽ-my, ani ereiporu rei ne mba'e, nde pirapire ave ndejéupe gwarã anho-rehe. Iporãve ereme'ẽ hemikotevẽ iporiahu va'e kwéry-pe. Upéixa nde py'a porã reheve ereiporu ramo ne mba'e reta, gwĩ ereiporiahuvereko va'ekwe ovy'a jevy va'erã ne ndive. Ha eregwahẽ-ma ramo yváy-py ne mogwahẽ porã arã. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tereiporu porã ne mba'e ereiko porã hagwã. Ndahetái ramo ne mba'e, ereiporu kwaa ramo, iporã arã nde-vy. Hetave tave erereko ramo ereiporu kwaa arã upe ne mba'e reta voi ave. Nde py'a porã-gwi ereiporu kwaa ne mba'e. Ha ndahetái ramo ne mba'e, ndereiporu porãi ramo upe ne mba'e mbovy, hetave tave erereko ramo, ndereiporu kwaái arã upe hetave va'e ave. Nande reko porãi-gwi ndereiporu kwaái ne mba'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","—Ha nane arandu porãi-gwi ndereiporu porãi ne mba'e ko yvy pygwa. Mba'éixa po ereiporu kwaa va'erã Nhandejáry remime'erã? he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","—Ha ndereiporu porãi ramo ko'a-py ereiporu va'e, avave nome'ẽi arã ne mba'e teerã nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Ndaikatúi eremba'apo mokõive-pe. Peteĩ va'e-rehe nande a'e porãiry va'erã. Ambue katu erehayhu tee va'erã. Peteĩ va'e-rehe ne rakate'ỹve arã. Ha outro-rehe katu nerepenái arã. Peteĩ va'e nhe'ẽ-rupi mate ereiko arã, he'i omombe'u-vy. —Upéixa ave ereiko ramo Nhandejáry nhe'ẽ-py, ndikatuvéi erepena eterei ko yvy-rehe oiko va'e nde pirapire-rehe. Ne rakate'ỹ eterei ramo pirapire-rehe, ipu'aka va'erã nde-rehe. Nerepenái va'erã Nhandejáry-rehe. Nde kupe-py rei oĩ va'e-rami erereko va'erã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ohendu-ma ramo upe nhe'ẽ fariseu kwéry, onhembohory hese. Plata rayhuha ha'e kwéry. Omba'e reta rayhuha ave ha'e kwéry. Upéixa-gwi Hesu remimombe'u-rehe ndovy'áiry. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Upéa-gwi Hesu he'i íxupe kwéry: —Peẽ penhemboheko marangatu rei yvypóry renonde-py. Peje rei pendejéupe “Aiko porã Nhandejáry nhe'ẽ-py” peje mo'ã, pende apu rei pendéjehe, pende rerovia rei kente kwéry. Nhandejáry ae ohexa porã nde py'apy-py. Oikwaa-ma katu mbava'e-rehe erejerovia ete. Oikwaa-ma ave mbava'e-rehe erenhemongeta nde py'apy-py, he'i onhemonhe'ẽ-vy íxupe kwéry. —Oĩ heta mba'e, heta hembiapo ave ovale e'ỹ va'e voi katu Nhandejáry-pe. Ha kente kwéry he'i rei upe mba'e-rehe, “Iporã katu” he'i rei hembiapo-rehe. “Ovale voi” he'i rei hese. Ndoikói peteĩxa Nhandejáry ndive-gwi, aipo he'i rei hese, he'i Hesu onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Myamyrĩ ojerovia araka'e Nhandejáry-rehe. Upéixa-gwi oiko porã araka'e inhe'ẽ-py. Ohendu meme katu araka'e Moisés amyrĩ rembihaikwe. Nhandejáry nhe'ẽ-py omombe'u va'ety amyrĩ kwéry rembihaikwe ave ohendu meme ave araka'e. Upéa-rehe oikwaa-ma araka'e Nhandejáry remimbota ojapo hagwã, he'i. —Upe rire ou-ma va'ekwe João Batista. “Ou-tama Nhandejáry nhande ruvixarã” omombe'u meme. Upe rire ãy peve onhemosarambi rambi upe nhe'ẽ. Ha heta kente ikyre'ỹ voi omoirũ hagwã Nhandejáry-pe. Oikese ha-py pya'e a'e oike ha-rami ojapura-ma va'e-rami omoirũse eterei Nhandejáry-pe gwuvixarã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Ha'e-ta ave peẽ-my, áry opa va'erã. Yvy ave opa va'erã ave. Nhandejáry nhe'ẽ ae Moisés amyrĩ remimombe'ukwe ndopái va'erã. He'i hagwe-rami oikopa peve nonhehekoviarõ mo'ãi voi, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","He'i ave: —Gwembireko-gwi opoi va'ekwe omenda jevy ramo ambue kunha-rehe, ojapo vai voi Nhandejáry renonde-py. Ha kunha ome oheja va'ekwe-rehe omenda va'e ojapo vai ave Nhandejáry renonde-py, he'i Hesu ombo'e-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Upéi Hesu omombe'u jevy arandu nhe'ẽ mokõi kwimba'e rehegwa nhe'ẽ-rami. —Oiko va'ekwe peteĩ kwimba'e imba'e reta va'e. Hepyve pyve va'e ao meme voi katu ha'e omonde. Ha okaru porã porã meme ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ha hokẽ-my ogweru omoĩ-vy kwimba'e iporiahu ete va'e. Héry va'e Lázaro. Hasy va'e voi Lázaro. Ipire aipa va'e voi. Ikangy voi hasy ete-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ha ivare'a eterei-gwi ogwapy oĩ-vy upe-py. Oha'arõ ho'u va'erã mo'ã. Tembi'u sururukwe ho'a va'ekwe ho'u hagwã oĩ upe-py. Onhemohygwyatã-vy mo'ã ou oha'arõ oĩ-vy upe-py. Ha upéixa oĩ jave gwĩ jagwa ou ohere íxugwi ijai ai. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","—Upe rire omano Lázaro. Omano ramo Nhandejáry rembigwái yváy pygwa ou ogweraha íxupe oiko hagwã Abraão amyrĩ ndive ogwenogwahẽ íxupe heraha-vy Nhandejáry renda-py. —Upéi omano ave upe imba'e reta va'ekwe ave. Ha omoĩ hetekwe hetekwe rendaty-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Omano rire-ma oime jave nhane mbohasa asy va'e renda-py, ohasa asy-ma voi oiko-vy. —Upéi oma'ẽ jave mombyry-kotypy ohexa Lázaro amyrĩ-pe oiko ramo Abraão amyrĩ ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Upéi osapukái Abraão amyrĩ-pe. He'i “Xe poriahuvereko katu, xe ramoigwasu Abraão” he'i gwamoigwasu-pe. “Embou Lázaro xe pytygwõ uka-vy. Omoakỹmi hagwã jepe xe apekũ” he'i. “Okwã apy omoakỹ hagwã y-py omoro'ysã hagwã xe apekũ” he'i. “Aiko asy eterei ko tata rendy-py” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—Upéa-rehe Abraão amyrĩ he'i íxupe: “Namondo mo'ãi nde ha-py Lázaro” he'i íxupe. “Nde, tekotevẽ ne mandu'a nde rekohagwe-rehe. Eremano e'ỹ mboyve va'ekwe, ereiko ramo yvy ári ne mba'e reta-rehe mate erepena va'ekwe ereiko-vy. Ha upe-py nde rekoha porã va'ekwe. Ãy ae katu ereiko asy va'erã. Nde rekoha porãgwe ndovalevéi-ma va'erã nde-vy. Erehasa asy-ta voi katu ereiko-vy” he'i íxupe. “Ha Lázaro amyrĩ nde ramigwa e'ỹ va'ekwe. Ha'e oiko ramo va'ekwe yvy ári ohasa asy voi va'ekwe. Ãy katu ha'e oiko porã-ma” he'i Abraão amyrĩ imba'e reta va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Oĩ ave yvykwagwasu nhane mbyte-py. Ko'a pygwa ohasase mo'ã upe-py. Ndikatúi ohasa yvykwagwasu-gwi” he'i. “Ha ndikatúi ave upe pygwa ohasa ou hagwã ore ha-py ave” he'i Abraão amyrĩ upe imba'e reta va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—“Aipo ramo” he'i Abraão amyrĩ-pe, “Emondo emogwahẽ uka Lázaro amyrĩ xe ru róga-py” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","“Oiko cinco xe ryvy kwéry oikove va'e. Emondo Lázaro amyrĩ omombe'u hagwã íxupe kwéry Nhandejáry nhe'ẽ pono omano rire ha'e kwéry ave ou ko'a-py, ko ohasa asy hagwã-py” he'i ojerure-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Upéi Abraão amyrĩ he'i íxupe: “Oĩ Nhandejáry nhe'ẽ ohai uka va'ekwe. Upéa ae mate ha'e kwéry tohendu” he'i íxupe. “Nhandejáry nhe'ẽ Moisés amyrĩ rembihaikwe ogwereko nipo ra'e. Nhandejáry nhe'ẽ-py omombe'u va'ety rembihaikwe ogwereko ave nipo ra'e. Upéa nhe'ẽ ae katu ha'e kwéry tohendu” he'i Abraão amyrĩ íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Ha'e he'i “Nahániry” he'i jevy. “Nde, ereikwaa, upe hembihaikwe rehegwa nhe'ẽ ha'e kwéry nohenduséi voi. Ohexa ramo peteĩ omano va'ekwe oikove jevy-ma ramo ae ogwerovia arã inhe'ẽ. Ogwerova arã gwekoha ave” he'i ojerure rure-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—“Ndojeroviaséi voi nipo ra'e hikwái” he'i Abraão amyrĩ íxupe. “Nohenduséi nipo ra'e Moisés amyrĩ rembihaikwe. Nohenduséi nipo ra'e Nhandejáry nhe'ẽ-py omombe'u va'ety amyrĩ rembihaikwe ave. Omano va'ekwe oikove jevy-ma ramo nohenduséi ave arã voi inhe'ẽ. Nohenduséi ete voi Nhandejáry nhe'ẽ” he'i íxupe Abraão amyrĩ. “Namondo mo'ãi Lázaro amyrĩ upe-py” he'i ave Abraão amyrĩ, he'i Hesu omombe'u ramo arandu rehegwa nhe'ẽ íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Upéi Hesu he'i gwemimbo'e kwéry-pe: —Oĩ heta kente-pe ombotavy va'erã. Ohesa rerova uka va'erã xéhegwi ombojejavy uka-vy. Amboasy upe imbotavyharã-pe. Ohasa asy eterei va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iporãve arã ra'e jajuka ombo'e vai e'ỹ ngatu. Iporãve arã ra'e nhanhapytĩ nhamoĩ-vy ijaju'y-rupi itagwasu-rehe ipohyive hagwã. Iporãve arã ra'e nhamombo ygwasu-py ombo'e vai e'ỹ ngatu omano pono xe-rehe ojeroviase va'e-pe ombotavy rei. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Peẽ xe reroviaha va'e kwéry, penhangareko porã katu peteĩ teĩ pendéjehe. Oĩ ramo nde rapixa xe reroviaha va'e jepe nde-rehe hembiapo vai va'e, enhemonhe'ẽ porã jevy katu íxupe. Ha ohendu-ma ramo ne nhe'ẽ, “Arova-ta xe rekoha xe anhemboasy xe rembiapo vaikwe-rehe nde-vy” he'i ramo eiporiahuvereko íxupe. Anive eremomandu'a hembiapo vaikwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nde-rehe hembiapo vai meme ramo, ha onhemboasy meme gwembiapo vaikwe-rehe ramo, eiporiahuvereko meme katu íxupe. Eiko porã rei indive, he'i Hesu omombe'u-vy hekoha kwéryrã. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Upéa-rehe hemimbo'e kwéry he'i íxupe: —Ore pytygwõ katu orojerovia teeve hagwã Nhandejáry-rehe, he'i onhepytygwõ ukaseve-vy ojerovia ete hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—Erejerovia mixĩmi-ma ramo Nhandejáry-rehe, ome'ẽ-ta nde-vy ne rembijerure, he'i. —Oĩ temitỹgwe héry va'e mostarda. Mixĩ eterei haimete nome'ẽi erehexa hagwã. Upe mixĩgwe va'e-gwi osẽ tuvixa va'e. Yvyra-rami opyta. Upéixa ave mixĩmi jepe erejerovia tee ramo Nhandejáry-rehe, “Ehapo'o ehekỹi ko yvyragwasu” ere ramo, ohapo'o joty va'erã. “Erenhotỹ jevy ko yvyragwasu ygwasu-py” ere ramo íxupe, onhotỹ jevy va'erã y-py. Ne rembijerurekwe ojapo-ta Nhandejáry, he'i íxupe kwéry. —Nde-vy ikatu e'ỹ va'e ojapo va'erã nde-vy ne rembijerurekwe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","9","He'i ave íxupe kwéry: —Eremomba'apo heta ne rembigwái kokwe-py omba'apo va'e. Mymba-rehe onhangareko va'e omba'apo heta. Omba'apo rire-ma ogwahẽ jevy nde róga-py. Upéi ere íxupe: “Ekwa katu ejapo xe remi'urã. Eru xe-vy ha'u va'erã, hay'u hagwã ave”. Erekaru porã rire ae-ma ere ne rembigwái-pe, “Ekaru katu”. Avave nde'íry omba'apo va'e-pe: “Atima nde-vy ne rembiapo-rehe” nde'íry. Nde'íry ave, “Atima nde-vy xe nhe'ẽ-rupi eremba'apo-gwi” nde'íry. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Peẽ ave, peiko ramo Nhandejáry nhe'ẽ-py, hemimbota meme peteĩ teĩ pejapo ramo, ani peje pendéjehe, “Xe rembiapo porã voi ko xe” ani peje teĩ pendéjehe. Iporãve ere “Hembigwái porã ete ndaikói Nhandejáry-pe. Hemimbotami mate ajapo íxupe” peje ae katu pendéjehe, he'i hekoharã omombe'u gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hesu ogwata oho-vy Jerusalém tetã-my. Tape puku-rehe oho. Samaria pygwa yvy-rupi oho, Galiléia pygwa yvy-rupi ave oho. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Oike-tama peteĩ tetã'i-my ou ohogwaitĩ mo'ã íxupe dez aiai mba'asy vai ogwereko va'e. Ipire omboai mba'asy ani eremoagwĩ teĩ mba'asy vai ogwereko va'e-pe. Ogwahẽ mo'ã Hesu renda-py. Mombyry jave íxugwi opyta. Onhe'ẽ hatã he'i-vy: ");
INSERT INTO kgkNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—Mbo'eháry Hesu, ore poriahuvereko katu ore mbogwera katu, he'i onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hesu ohexa-ma ramo íxupe kwéry he'i: —Tapeho pejehexa uka pa'i kwéry-pe judeu kwéry rekoha-rupi, he'i íxupe kwéry. Ha oho hikwái. Tape-rupi ogwata oho jave okwerapa-ma hikwái. Hesu nhe'ẽ-py okwerapa-ma. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Oikwaa-ma ramo ikweraha peteĩ ou jevy ohogwaitĩ Hesu-pe: —Xe mbogwera-ma hexapyrã-rupi xe mbogwera-ma, he'i. —Tonhemomarangatu katu Nhandejáry réry. Onhemomba'egwasu ete va'e Nhandejáry, he'i. Omboete Nhandejáry-pe osapukái-vy ou jave tape-rupi ovy'a eterei-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ogwahẽ-ma ramo Hesu-pe onhesũ henonde-py omboete íxupe-vy: —Xe Járy, ne rembiapo porã eterei. Nde ko ne marangatu tee va'e. Atima voi nde-vy xe mbogwera-gwi. he'i íxupe. Ovy'a eterei okwera-ma ramo upe Samaria pygwa va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Upéi Hesu he'i íxupe: —Ndaha'éi ne anho orombogwera kuri, he'i. —Enterovéa-pe voi ambogwera kuri, he'i. —Ha ne anho mate ereju xe mboete-vy, he'i okwera va'e-pe. Ha ojogweroaty va'e-pe omombe'u. —Ko samaritano va'e mate ou jevy xe mboete-vy. Nhande re'ýi e'ỹ va'e mate ovy'a para'e ambogwera-magwi íxupe, he'i. —Nove ndoúiry va'e kwéry-pe ambogwera ave kuri, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Upéi he'i samaritano va'e-pe: —Epu'ã katu. Orombogwerapa-ma. Xe-rehe erejerovia-gwi ororesende-ma, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gwĩ fariseu kwéry oporandu Hesu-pe: —Araka'e tipo ojekwaa-ta Nhandejáry nhande ruvixarã, he'i oporandu-vy. —Ndaha'éi nhande resa-rupi jahexa Nhandejáry nhande ruvixa ramo, he'i omombe'u-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","—Upéa-rehe ndikatúi ere, “A-py ou-ma Nhandejáry. A-py ojekwaa-ma huvixarã”. Nde'íry ave “Upe-py ou-ma. Ojekwaa-ma huvixarã upe-py” nde'íry ave, he'i Hesu omombe'u-vy. —Avave ndohexái kipy po oiko. Nhande py'apy-py oiko nhande ruvixarã, he'i upe fariseu kwéry-pe ombo'e-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Upéi he'i doze gwemimbo'e kwéry-pe: —Ou va'erã peẽ-my peteĩ áry xe rexase eterei va'erã. Ha xe Nhande Ryke'y tee va'e-rehe peje-ta, “Ahexa nga'u íxupe. Peteĩ áry-rupi ahexa ramo íxupe avy'a va'erã” peje arã xe-rehe. Ha ndaxe rexa mo'ãi-ta vyteri. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Ogwahẽ-ma ko'a-py” he'i rei va'erã xe-rehe. Ijapu rei va'erã xe-rehe. “Ogwahẽ-ma upe henda-py” he'i rei va'erã xe-rehe ijapu va'e. Ani erejerovia teĩ hese kwéry. Ani teĩ ereho xe reka-vy ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Agwahẽ ramo xe, Nhande Ryke'y tee va'e, enterove oikwaa-ta, ohexa-ta xe gwahẽ ramo. Ha'e-ta peẽ-my: Omohembipepa aragwaju-rami va'erã peẽ-my agwahẽ-ma ramo. Xe rexapa va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","—Ahasa asy ranhe-ta. Ãygwa xe joko-ta ija'e'ỹ-ta xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Xe Nhande Ryke'y tee va'e agwahẽ jevy ramo, yma gware-pe ojehu hagwe-rami ave, ojehu jevy va'erã. Oikove vyteri jave Noé amyrĩ ");
INSERT INTO kgkNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","gwĩ kente kwéry oiko rei araka'e. Okaru, oy'u, omenda ave, ome'ẽ gwajýry omenda hagwã ave. Upéixa rei okwa araka'e hikwái. Nhandejáry-rehe katu nopenáiry araka'e hikwái. Upéi Noé oike okanoagwasu-py. Oike rire-ma, pya'e oky araka'e. Tuvixa oky. Yvu mbovu-vy araka'e oky. Ha onhehundipa oike e'ỹ va'ekwe gwive. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Upéixa ave ojehu araka'e myamyrĩ Sodoma tetã mygwa kwéry-pe. Oiko-ma jave Ló amyrĩ upe pygwa kwéry oiko rei ave araka'e. Okaru, oy'u rei, ojogwa omba'erã, ovende ave omba'ekwe, kokwe ojaty, gwogarã omopu'ã ave. Upéixa rei okwa araka'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Upéi Ló osẽ araka'e tetã-gwi oho-vy. Osẽha áry-py ho'a tata yváy-gwi ohapy hagwã araka'e tetã mygwa. Iku'i sa'yju va'e ho'a-ma araka'e ohapy hasyve hagwã tetã mygwa kwéry ohundipa hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","—Upéixa oiko-ta ave agwahẽ jevy ramo. Xe, Nhande Ryke'y tee va'e agwahẽ jevy-ta. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Agwahẽha áry ramo xe-rehe mate pepena va'erã. Agwahẽ jave ereime ramo óga ári, ani teĩ ereike koty-py mba'eve ereraha hagwã. Ereime ramo kokwe-py, ani erejevy nde róga-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ne mandu'a jevy katu Ló amyrĩ rembireko-rehe. Ojevyse mo'ã onhehundi-ma va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Gwekove-rehe hakate'ỹ va'e katu, onhehundipa ete va'erã. Ndohói va'erã Nhandejáry renda-py. Ha xéhegwi gwekove-rehe nopenái va'e, ohekoviarõ arã hekove íxupe. Oresende-ta íxupe Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Ha'e-ta ave peẽ-my: Pyhare-py agwahẽ jevy ramo, mokõi va'e oke jave koty-py. Peteĩ va'e-pe Nhandejáry ogweraha va'erã. Inhirũgwe-pe katu oheja va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mokõi kunha hu'irã ojoso va'e oime jave agwahẽ ramo, peteĩ va'e-pe Nhandejáry ogweraha va'erã. Inhirũgwe-pe oheja va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mokõi oime jave kokwe-py agwahẽ ramo, peteĩ va'e-pe ogweraha va'erã. Inhirũgwe-pe oheja va'erã, he'i ombo'e-vy doze gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Upéa-rehe oporandu íxupe: —Mamo tipo oiko va'erã upéa, ore Járy, he'i íxupe. Upéi Hesu he'i íxupe kwéry: —Anhete voi oĩ ramo hetekwe, yruvu kwéry ogwejy katu ete arã ho'u hagwã. Anheteve ha'e-ta nde-vy: Oikopa-ma ramo xe remimombe'u, aju jevy-ma va'erã, he'i Hesu omombe'u-vy gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Upéi Hesu he'i gwemimbo'e kwéry-pe: —Tapembojeupi meme katu pene nhe'ẽ Nhandejáry-pe peiko-vy. Ani ne ate'ỹ teĩ ne nhe'ẽ erembojeupi-vy, he'i. Upéi arandu nhe'ẽ omombe'u íxupe kwéry. Tembirekokwe rehegwa nhe'ẽ-rami omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Mburuvixa ipy'a vai va'e oĩ va'ekwe peteĩ tetã-my. Ndojeroviái Nhandejáry-rehe nopenái hese. Ojéupe gwarã mate ojapo. Ndojapóiry mba'eve avave pegwarã. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","—Ha peteĩ tembirekokwe upe pygwa va'e oho meme mburuvixa renda-py. Ojerure rure rei íxupe ohepy hagwã imbohasa asyhare-pe. Ha ndojapói inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ijerureha ndojapóiry íxupe. Are ohendu hendu rei kunha nhe'ẽ. Upéi he'i opy'apy-py: “Xe mokane'o eterei ko tembirekokwe nhe'ẽ. Upéa-gwi ajapo-ta inhe'ẽ. Ndaha'éi pono xe mbohasa asy Nhandejáry. Napenái hese. Ndaha'éi ave pono onhe'ẽ vai hagwã avave xe-rehe. Xe napenáiry avave-rehe aiko-vy. Pono xe toryvave ajapo-ta íxupe inhe'ẽ, aipytygwõ-ta íxupe” he'i mburuvixa kunha-rehe, he'i Hesu omombe'u ramo arandu nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Upéi he'ive íxupe kwéry: —Ha'e-ta peẽ-my: Upe mburuvixa ipy'a vai jepe hembiapo porã nainhate'ỹi va'e-pe. Hembijerure ojapo voi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ha Nhandejáry katu ipy'a porã ete nhane ndive. Gwembiporavo-pe oiporiahuvereko meme. Oipytygwõ-ta íxupe, omondo mondo íxupe onhe'ẽ va'e-pe oipytygwõ. Ohendu voi inhe'ẽ. Ani ere teĩ, “Hi'are eterei Nhandejáry xe rembijerure ojapo hagwã”. Omondo mondo íxupe onhe'ẽ va'e-pe oipytygwõ. Ani ave ere teĩ, “Xe nhe'ẽ nohendúi para'e ohendu para'e Nhandejáry” ani ere teĩ Nhandejáry-rehe, he'i Hesu omombe'u-vy. —Ereikokwe-vy joty ani ne ate'ỹ teĩ eremondo hagwã ne nhe'ẽ íxupe. Áry-py, pyhare-py ave eremondo mondo ne nhe'ẽ íxupe. Nde poriahuvereko-ta ne rembijerure ojapo-ta nde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ndahi'aréi ne pytygwõ hagwã nde hese erejerovia va'e, he'i. —Xe ko Nhande Ryke'y tee va'e. Agwahẽ jevy ramo, ndahetái arã voi nipo ra'e upéixa ojerure rure va'e xe ra'arõ va'erã. Ani katu ne ate'ỹ eterei ereiko-vy. Emondo mondo katu ne nhe'ẽ Nhandejáry-pe, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Upéi Hesu omombe'u jevy ojogweroaty va'e-pe. Upe-py oĩ onhemboete rei va'e kwéry. Oĩ ave gwapixa-rehe onhe'ẽ rei rei va'e kwéry. Upéa-rehe Hesu onhemonhe'ẽ íxupe kwéry. Arandu nhe'ẽ oiporu omombe'u hagwã mba'eixagwa py'a jareko nhambojeupi ramo nhane nhe'ẽ Nhandejáry-pe. Mokõi kwimba'e rehegwa nhe'ẽ-rami omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Mokõi kwimba'e oho ojeporahéi haty-py ojapo hagwã oração. Peteĩ fariseu va'e, outro plata-py nhane mbopaga va'ety. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ha omondo hagwã onhe'ẽ Nhandejáry-pe upe fariseu va'e onhembo'y. Ipy'apy-py ae onhemongeta. Onhembotuvixa eterei-gwi onhenohẽ porã mo'ã Nhandejáry-pe. —“Tupã xe Járy” he'i onhemongeta-vy. “Avy'a ete xe rekoha-rehe” he'i mo'ã. “Ambue kwéry-rami ndaikói voi xe” he'i. “Imonda e'ỹ va'e xe. Hekoha vai e'ỹ va'e ave xe. Namenda mendái kunha ambue-rehe ave aiko-vy. Naxe rembiapo vaíry voi avave-rehe” he'i mo'ã. “Avy'a eterei. Xe ndaikói voi ko plata-py oporombopaga va'ety rekoha-rami” he'i onhembotuvixa-vy. “Xe rembiapo porã voi aiko-vy” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“Ha nde-rehe ajerovia-gwi peteĩ teĩ semana mokõi áry meme ahasa asy karu e'ỹ reheve aiko-vy” he'i. “Xe areko va'e aipapa meme dez-gwi aipe'a peteĩ ame'ẽ nde-vy gwarã” he'i omondo-vy onhe'ẽ Nhandejáry-pe onhenohẽ porã hagwã mo'ã íxupe, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Ha upe oporombopaga va'ety otĩ oike hagwã ojeporahéi haty-py. Mombyry-rupi rei oiko. Noma'ẽ ma'ẽi voi oiko-vy otĩ eterei-gwi. Ndojeesaupíry ojahe'o voi oĩ-vy onhemboasy-vy “Xe ko xe py'a vai voi aiko-vy” ho'e-vy hasẽ. “Tupã, xe Járy” he'i, “Xe poriahuvereko katu” he'i onhemboasy-vy íxupe. “Xe rembiapo vai eterei voi aiko-vy” he'i onhemboasy-vy, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ha he'i ave Hesu: —Ha'e-ta katu xe: Onhemboasy va'e-gwi omboyke voi-ma hembiapo vaikwe Nhandejáry. Ohendu voi inhe'ẽ. Ipy'a potĩ-vy oho jevy gwóga-py. Ha upe fariseu va'e-gwi hembiapo vaikwe nomboyke mo'ãi voi onhenohẽ porãse mo'ã íxupe-gwi, he'i Hesu arandu nhe'ẽ oiporu-vy. Upéi he'i jevy. —Anhete ha'e-ta peẽ-my: Onhemboeteseve va'e-rehe avave nopenái arã, ha onhemomirĩ va'e-pe ae katu omboete va'erã, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ogweru ave okwa-vy Hesu renda-py mitãgwe Hesu omoĩ hagwã opo mitã kwéry-rehe ohovasa hagwã. Ha hemimbo'e kwéry ohexa-ma ramo, hakate'ỹ Hesu-rehe. —Ani ereru Hesu ha-py mitã mixĩ mixĩ va'e, he'i ojoko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ha Hesu katu he'i: —Eheja katu tou mitã'i gwive xe renda-py. Ani erejoko teĩ. Mitã'i reko mirĩ vérami va'e meme omoirũ-ta Nhandejáry gwuvixarã-pe, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","—Anhete ko ha'e-ta peẽ-my. Nhandejáry oiko ha-rupi huvixa ramo ndaipóri-ta onhembotuvixave va'e. Onhemohekomirĩve va'e ae omoirũ-ta íxupe, he'i Hesu omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Peteĩ mburuvixa oporandu Hesu-pe: —Mbo'eháry, nde reko porã va'e. Mba'e tipo ajapo-ta xe aikove hagwã Nhandejáry ndive apave'ỹ reheve? he'i oporandu-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—Ne mandu'a porã katu ne nhe'ẽgwe-rehe, he'i íxupe Hesu. —“Nde reko porã va'e” ere kuri xe-rehe. Nhandejáry, ha'e anho mante heko porã tee va'e, he'i Hesu íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","—Ereikwaa-ma Nhandejáry omombe'u va'ekwe nhande rekorã, he'i ave Hesu. —Ani ereiko teĩ ambue mbue ndive, he'i. —Ani ereporojuka teĩ. Ani eremonda teĩ. Ani nde apu teĩ avave-rehe. Emboete katu nde ru, nde sy ave. Upéixa omombe'u va'ekwe Nhandejáry nde rekorã, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Xe mitã ramogware ãy peve upéa nhe'ẽ namokanhỹi, he'i. —Ahendu vyteri aiko-vy xe, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ohendu-ma ramo, Hesu he'i íxupe: —Peteĩ oĩ va'e nderejapói vyteri, he'i íxupe. —Erereko va'e gwive evendepa katu. Hepykwe ae eru eme'ẽmba iporiahu va'e kwéry-pe. Upéixa erejapo ramo, nde rekoha porãrã erereko arã yváy-py. Upe rire eju katu xe moirũ, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ohendu-ma ramo inhe'ẽ ndovy'avéi-ma. Ipy'a reraha eterei omba'e reta reta-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ha Hesu oma'ẽ hese. Oikwaa-ma ndovy'avéi-ma upe va'e. Upéixa-gwi he'i onhondive oĩ va'e-pe: —Hasy peve opamba'e ogwereko va'e omoirũ hagwã Nhandejáry gwuvixarã-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","—Hasy eterei nhambohasa ka'ijugwasu kwa-rupi mymbagwasu camelo, ndaijaséiry. Ha hasyve imba'e reta va'e omoirũ hagwã Nhandejáry gwuvixarã-pe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ha ohendu va'e kwéry he'i: —Kiva'e onheresende-ta, aipo ramo? Hasy eterei nipo nhanheresende hagwã ra'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ha Hesu katu he'i: —Peẽ-my hasy eterei va'e ndahasy mo'ãi Tupã Nhandejáry-pe. Ha'e anho mante ne resende va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ha upéi katu he'i íxupe Pedro: —Ore niko orogwereko va'e gwive orohejapa oroju-vy oromoirũ hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—Anhete ko xe ha'e-ta nde-vy, he'i íxupe Hesu. —Xe moirũ hagwã gwóga, gwóga pygwa ave oheja va'e hetave ojohu va'erã gwembiejare rekoviarã. Gwembireko, gwyke'ýry, gwyvýry, gweindýry, gwa'ýry, gwajýry, oména, omembýry, gwykéry, okypy'y kwéry, okyvýry, gwu, osy oheja ramo omoirũ hagwã Nhandejáry gwuvixarã-pe, ");
INSERT INTO kgkNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hetave tave ome'ẽ va'erã íxupe Nhandejáry. Ohexakwaa rei va'erã íxupe ko'ãy, ha yvy opa-ma rire oikove meme va'erã Nhandejáry ndive opave'ỹ reheve, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Upéi ohenói jevy gwĩ doze gwemimbo'e íxupe kwéry anho omombe'u hagwã. —Jaha jaiko-vy Jerusalém tetã-my. Ha xe Nhande Ryke'y tee va'e ahasa asy-ta upe-py, he'i. —Nhandejáry nhe'ẽ-py omombe'u va'ety kwéry omohenonde va'ekwe ihai-vy mba'e pa ojehu-ta xe-vy. Upe ohai va'ekwe xe rehegwa ãy ojapopa-ta, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","—Xe pyhy-ta xe reraha judeu e'ỹ va'e kwéry-pe. Onhembohory-ta xe-rehe, xe rereko asy-ta ave, onygwõ-ta ave xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xe mbopi rire xe juka-ta. Mbohapy áry-py anhemoingove jevy-ma va'erã, he'i gwemimbo'e kwéry anho-pe onhemombe'u-vy Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ha hemimbo'e kwéry nohendu kwaái voi Hesu nhe'ẽ. Ojeapysaka rei hikwái. Onhenhomi voi íxugwi kwéry pono oikwaa he'ise va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ogwahẽ-tama Jericó tetã-my. Hi'agwĩ-ma oĩ ramo tetã hesapyso e'ỹ va'e ogwapy oĩ-vy tapegwasu rembe'y-py. Omba'e repyrã-rehe ojerure oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ha Hesu ndive ojogweroaty va'e ohasa oje'ói-vy tape-rupi. Ohendu ramo ijayvu, oporandu ohexa va'e-pe: —Mbava'e tipo ojapo oje'ói-vy? he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Hesu Nazaré pygwa ohasa oje'ói-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ohendu-ma ramo, onhe'ẽ hatã ohenói-vy: —Hesu, Davi remiarirõre, xe poriahuvereko katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Henonde-rupi ohasa va'e inhe'ẽ ojoko mo'ã íxugwi: —Ekirirĩ katu, he'i íxupe omongirirĩse mo'ã-vy íxupe. Ha'e katu hatãve tãve joty osapukái oĩ-vy: —Xe poriahuvereko katu, Davi remiarirõkwe, he'i joty. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Upéi opyta-ma Hesu. —Eru íxupe, he'i. Ou-ma ramo oporandu íxupe Hesu: ");
INSERT INTO kgkNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Mbava'e tipo ereipota xe ajapo hagwã nde-rehe? he'i hesapyso e'ỹ va'e-pe ijeroviaha ojekwaa uka hagwã. —Eme'ẽ xe resarã xe-vy, mbo'eháry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Ema'ẽ. Nde resapyso-ma ngatu, he'i. —Xe-rehe erejerovia-gwi erekwera-ma, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Onhe'ẽ jave okwera-ma. Okwera-ma ramo, omoirũ-ma íxupe oho-vy. Omboete ete Nhandejáry-pe oho-vy Hesu rapykwéri. Ha upe pygwa oĩ va'e gwive, upéa ohexa va'e gwive, Nhandejáry-pe omomba'egwasu ete voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ogwahẽ-ma Hesu Jericó tetã-my. Ohasa oho-vy tetã-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","3","Ha peteĩ mburuvixa ohexase eterei Hesu-pe. Pirapire-py nhane mbopaga va'ety kwéry-pe mburuvixa upéa. Imba'e reta va'e. Ikarape va'e. Héry va'e Zaqueu. Ikarape-gwi ndikatúi ohexa kente ári-rupi Hesu-pe. Heta eterei ojogweroaty va'e ogweroajere Hesu-pe omanha manha hese-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Upéi Hesu oho hagwã-rupi oho yvyra-rehe ojeupi Zaqueu. Oripara oho-vy yvate ojeupi oĩ-vy ohexa hagwã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ogwahẽ-ma ramo Hesu upe yvyra gwy-py, opyta. Orepara yvate-koty oma'ẽ Zaqueu-rehe. —Zaqueu, egwejy. Pya'e egwejy. Aha-ta nde róga-py, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pya'e ogwejy oho ohogwaitĩ Hesu-pe. Ovy'a eterei Zaqueu. He'i Hesu-pe: —Jaha katu, he'i. Pya'e oho indive. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hexaháry ndojohu porãi. Ojohu vaipa voi. Onhe'ẽ vai vai Hesu-rehe. —Hesu omoirũ rei opaixagwa va'e-pe. Ojejavy va'ety jepe, Hesu katu omoirũ joty íxupe, he'i hese ojohu vai-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ha upe rire, ogwahẽ-ma rire, hóga-py oĩ-ma rire, Zaqueu he'i: —Xe Járy, arova katu xe rekoha, he'i íxupe. —Iporiahu va'e kwéry-pe ame'ẽ-ta heta xe mba'ekwe. Amboja'o ja'o-ta xe rembierekokwe. Ame'ẽ-ta iporiahu va'e kwéry-pe. Ha xe rembiapo vaikwe-gwi heta voi xe pirapire, he'i. —Peteĩ va'e-rehe areko ramo xe rembiapo vai-rupi ahekoviarõ-ta ame'ẽve-ta voi. Ijarykwe-pe irundy voi ame'ẽ-ta hekovia. Arova-ta ave xe rekoha, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Upe-ma ramo Hesu he'i: —Ãy eremoirũ-ma Nhandejáry nde ruvixa-pe. Omboyke-ma ndéhegwi ne rembiapo vaikwe. Ne resende-ma. AAraão remiarirõre voi ko nde. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Xe, Nhande Ryke'y tee va'e agwahẽ-ma aju-vy aheka Nhandejáry-gwi mombyry oiko va'e-pe aresende hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Upe nhe'ẽ ohendu hikwái. Ha namombyry etéiry Jerusalém tetã-gwi. Upéixa-gwi ohendu-ma ramo upe nhe'ẽ ojogweroaty va'e he'i opy'a-py. “Ojekwaa-tama para'e Nhandejáry nhande ruvixarã. Ogwahẽ-tama Hesu Jerusalém-my” he'i. “Ojekwaa-tama para'e nhande ruvixarã.” Upéa-rehe Hesu omombe'u jevy íxupe kwéry arandu nhe'ẽ mburuvixagwasu oplata oiporuruka va'e rehegwa nhe'ẽ-rami. He'i: ");
INSERT INTO kgkNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Peteĩ mburuvixa oho mombyry. Yvy ambue-py oho onhemomburuvixagwasu hagwã. Oiko-ma ramo mburuvixagwasu, ou jevy va'erã oiko hagwe-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oho e'ỹ ngatu ohenói gwĩ dez va'e gwembigwái. Peteĩ teĩ-pe ome'ẽ plata. Peteĩ meme ome'ẽ íxupe kwéry. Ome'ẽ jave he'i gwembigwái-pe. “Ko xe plata eiporu porã erembohe'ýi hagwã xe rapykwe-py. Agwahẽ jevy-ma aju-vy ramo, aporandu jevy arã nde-vy he'yiverã-rehe” he'i omanda-vy gwembigwái-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—Ha heta he'ýi kwéry ndija'éi rei mburuvixa-rehe. Upéixa-gwi nhe'ẽ rei omondo hapykwéri mburuvixave va'e-pe: “Upe va'e ore ndoroipotái ore ruvixarã. Ipogwy-py ndoroikoséiry. Hekoha vai eterei” he'i rei hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Oiko-ma ramo mburuvixagwasu ramo, ogwahẽ jevy oyvy-py. Upéi ohenói gwembigwái kwéry oplata rehegwa oikwaa hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","—Ogwahẽ ypy va'e omombe'u íxupe: “Xe ruvixa, aiporu va'ekwe nde plata” he'i omombe'u-vy. “Ereme'ẽ peteĩ xe-vy va'ekwe amoĩve nde-vy. Ambohekovia nde-vy dez jevy” he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—Ovy'a hemimbohekoviakwe-rehe mburuvixa. “Iporã voi” he'i. “Xe rembigwái porã voi, nde. Ndahetái mba'e jepe erenhangareko kwaa porã hese. Upéixa-gwi dez tetã mygwa-pe ereiko-ta mburuvixa ramo” he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Upéa ogwahẽ rire, peteĩ jevy ogwahẽ: “Peteĩ nde plata aiporu-gwi amoĩve nde-vy cinco jevy ave” he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—“Aipo ramo erenhangareko kwaa ave nde. Upéixa-gwi ereiko-ta mburuvixa ramo. Cinco tetã va'e-rehe erenhangareko-ta” he'i gwembigwái-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Upe rire ou peteĩ jevy hembigwái ave he'i gwerekwa-pe: “Ame'ẽ jevy-ta nde-vy nde plata” he'i íxupe. “Upe peteĩ ereme'ẽ va'ekwe xe-vy anhangareko porã hagwã anhugwã imoĩ-vy ao-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Xe ko, atĩ voi ndéhegwi” he'i íxupe. “Aikwaa voi ne rakate'ỹha. Ereme'ẽ e'ỹ va'ekwe jepe, ereipe'a joty ijáry-gwi. Erenhemitỹ e'ỹ reheve, eremono'õ uka vai joty ne mba'erã ijarykwe-gwi. Upéixa-gwi atĩ ndéhegwi” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—“Ne rembiapo vai voi ko nde xe-rehe” he'i herekwa íxupe. “Nderevaléi voi” he'i ave. “Ma'erã-gwi ndereiporu porãi xe plata?” he'i íxupe. “Ere kuri xe-vy: Ne rakate'ỹha aikwaa voi, ere” he'i íxupe. “Ereme'ẽ e'ỹ va'ekwe ereipe'a ijáry-gwi, ere xe-vy, Eremono'õ uka vai ne mba'erã ijarykwe-gwi, ere ave kuri xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aipo ramo ma'erã-gwi nereme'ẽi va'ekwe xe plata pirapire oiporuruka va'e-pe? Oiporuruka va'ekwe repy ohekoviarõ jevy hagwã xe-vy. Ne rembiapo vai voi xe-rehe” he'i ovy'are'ỹ-vy inhate'ỹ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Upéi he'i gwembigwái ambue-pe: “Eipe'a jevy xe plata íxugwi. Upéa ave ereme'ẽ jevy hagwã upe dez plata omono'õ va'e-pe” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Upéa-rehe he'i gwerekwa-pe: “Ogwereko-ma dez. Naiporãi ereme'ẽve íxupe” he'i jevy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—“Iporã ereme'ẽve íxupe” he'i herekwa. “Nhande re'ýi he'i meme: Heta ogwereko va'e-pe hetave ome'ẽ jevy va'erã. Ha inhate'ỹ va'e, naimba'e rexakwaái va'e-gwi oipe'apa va'erã íxugwi. Mixĩ ogwereko ramo jepe, ogwereko va'e gwive oipe'apa jevy-ta íxugwi” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Ha'e-ta ave peẽ-my: Peru katu xe-rehe ija'e'ỹ va'ekwe. Ndaxe potáiry va'ekwe gwuvixarã. Xe renonde-py jevy pejuka íxupe kwéry” he'i omanda-vy ijukaharã-pe, he'i Hesu nhande ruvixa ramo ndojehexa uka pya'eséi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Upe rire, upéa omombe'u rire, Hesu oho Jerusalém tetã-my. Gwemimbo'e kwéry renonde-rupi oho tape-rupi oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ha nogwahẽi vyteri, onhemoagwĩ ranhe Betfagé tetã mirĩ-gwi. Betânia tetã-gwi ave. Yvyatyrusu Oliveiras ypy-py ogwahẽ gwahẽ ranhe oho-vy. Upe-gwi omondo gwenonde-rupi mokõi gwemimbo'e: ");
INSERT INTO kgkNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Tereho tetã mirĩ-my ore renonderã-rupi, he'i íxupe. —Ereike-ma ramo eretopa-ta mburika'i onhenhapytĩ ha-py. Hi'ári ojejeupi e'ỹ va'e. Ejora heru-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","—Erejora ramo mburika, “Ma'erã tipo erejora mburika?” he'i va'erã nde-vy. Aipo ramo ere íxupe, “Araha-ta. Oikotevẽ hese nhande ruvixa” ere kuri íxupe, he'i imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ha upéi katu oho upe mokõi va'e ha otopa omombe'u hagwéixa. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ojora jave mburika'i ijáry oporandu mokõi hemimbo'e-pe: —Ma'erã tipo erejora xe rymba mburika'i? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Nhande ruvixa oiporu-ta íxupe. Oiporu hagwã araha-ta, he'i. —Aipo ramo eraha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ha upéi katu ogweru Hesu-pe. Omoĩ hi'ári oao. Ha Hesu-pe ohupi omoĩ mburika ári oho mombyryve hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ha oho jave heta va'e omboi oao oipyso hagwã Hesu ogwata hagwã hi'ári. Haperã-rupi omoĩ omboete-vy. Hesu mboete-vy ha'e oipyso oao. Ogwejy oje'ói-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Upéi ogwahẽ-tama ramo ogwejy tape-rupi yvyaty Oliveiras ári-gwi. Ogwejy oje'ói-vy jave, ogwahẽ-tama ramo Jerusalém tetã-my, hese ojerovia va'e kwéry ogwerohory Hesu-pe. Osapukái joa oporahéi ave omboete Nhandejáry-pe. Heta hembiapo porã hexapyrã-rupi ohexa va'ekwe-rehe omboete íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Ereju-ma, he'i. —Iporã katu, he'i osapukái-vy íxupe. —Nhandejáry ombou-ma nhande-vy mburuvixagwasu. Tohovasa vasa katu Nhandejáry, he'i hese. —Toiko yváy-py py'agwapy porã. Nhandejáry yváy-py oĩ va'e-pe jaha nhamboete, he'i oporahéi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Upéa-rehe gwĩ fariseu va'e oĩ jave ojogweroaty va'e pa'ũ-my he'i Hesu-pe: —Mbo'eháry, ejoko katu íxupe kwéry pono aipo-rami he'i nde-rehe, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—Tekotevẽ oiko xe mboete va'erã. Kente kwéry naxe mboetéi ramo ra'e Nhandejáry omonhe'ẽ uka va'erã ra'e ita kwéry-pe xe mboete hagwã. Kente rekoviarã xe mboete hagwã, he'i Hesu fariseu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ogwahẽ-tama ramo, ohexa-ma ramo Jerusalém tetã Hesu ojahe'o upe pygwa kwéry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Apomboasy voi peẽ-my. Ndapeikwaái vyteri mba'eixagwa pa pene mbopy'agwapy, he'i. —Nhandejáry xe mbou va'ekwe pene mo'arandu hagwã mo'ã ha napehenduséi xe nhe'ẽ. Napehenduséi-gwi pene arandurãgwe okanhy-ma pendéhegwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ogwahẽ-tama peẽ-my pehasa asy hagwã. Pende-rehe ija'e'ỹ va'e kwéry ou va'erã. Pene retã jerekwe-rehe ojo'o-ta yvykwa. Omopu'ã-ta ave ne mbotyhaty ponove avave osẽ pene retã-gwi, pende jopy-ta. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Pene hundipa-ta. Oity-ta pene retã. Ha peẽ kwéry upe-py oĩ va'e onhehundipa-ta. Ita-gwi pejapo va'ekwe pende róga kwéry. Ha upe ita kwéry oity-ta. Ndohejái arã ni peteĩ ita hendagwe-py. Oitypa ete arã. Upéixa pene mbohasa asy-ta. Nhandejáry xe mbou-ma ha “Nhane remiha'arõ ogwahẽ-ma ra'e” nderéiry xe-rehe. Ndapejeroviáiry joty xe-rehe. he'i. —Upéa-rehe pene hundipa-ta Nhandejáry, he'i Hesu Jerusalém mygwa kwéry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Upe rire oike Hesu Nhandejáry róga kakwaa-py. Omba'evende va'e-pe omosẽmba. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","He'i íxupe kwéry onhemonhe'ẽ-vy: —Oĩ kwatia-rehe Nhandejáry nhe'ẽ he'i: “Héry-ta xe róga xe mboete haty inhe'ẽ mondo haty Nhandejáry-pe”. Ha peẽ katu peiporu Nhandejáry róga oporosakea nhemi va'e róga-rami, he'i íxupe kwéry Hesu omosẽ-ma ramo imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ha Hesu oho meme Nhandejáry róga kakwaa-py ombo'e mbo'e oiko-vy. Iko'ẽmba ẽmba ombo'e meme-vy upe-py. Ha pa'i ruvixa kwéry, judeu rekombo'ehaty kwéry, judeu ruvixa kwéry ave oheka heka ojuka hagwã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ha ndotopái mba'e-rehe ojuka íxupe. Enterovéa kente kwéry ojeapysaka katu katu eterei ohendu hagwã inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ha peteĩ áry Hesu oime jevy Nhandejáry róga kakwaa-py omombe'u mbe'u hagwã Nhandejáry nhe'ẽ porã. Ha omombe'u jave ou henda-py pa'i ruvixa kwéry, judeu rekombo'ehaty kwéry, judeu ruvixa kwéry ave: ");
INSERT INTO kgkNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Kiva'e nhe'ẽ-py ko'ã va'e erejapo? he'i. —Kiva'e tipo nde-vy a-rami oporombo'e uka ave nde-vy? he'i ave. Oporandu Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","—Xe ave aporandu-ta peẽ-my peteĩ mba'e, he'i. —Pemombe'u ranhe ramo xe-vy aporandu-ta va'e-rehe, amombe'u-ta ave nde-vy kiva'e nhe'ẽ-py xe rembiapo, he'i. Upéi oporandu omokirirĩ hagwã íxupe kwéry: ");
INSERT INTO kgkNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","—Kiva'e nhe'ẽ-py va'ekwe João Batista amyrĩ oporomongarai oiko-vy va'ekwe? Nhandejáry nhe'ẽ-py para'e, teko rei nhe'ẽ-py para'e oporomongarai oiko-vy ha'e ae ho'arandu-rupi rei para'e ojapo? he'i. —Emombe'u ranhe katu xe-vy, he'i íxupe kwéry Hesu. Ha'e katu oikwaa-ma. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Upéa-rehe oporandu randu ojóupe: —“Nhandejáry nhe'ẽ-py katu oporomongarai va'ekwe” ja'e ramo “Ma'erã nderejeroviái va'ekwe hese?” he'i arã nhande-vy, he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","—Ha, “Teko rei nhe'ẽ-py oporomongarai va'ekwe” ja'e ramo, nhande api va'erã ita-py kente kwéry nhande juka hagwã, he'i ojóupe. “João niko Nhandejáry nhe'ẽ-py omombe'u va'ety voi” he'i kente kwéry hese, he'i ojóupe hikwái. —Iporãve nhakirirĩ rei hese jaiko-vy, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Upéa-rehe he'i Hesu-pe: —Ndoroikwaáiry, he'i mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Aipo ramo, xe ave namombe'u mo'ãi peẽ-my kiva'e pa ojapo uka xe-vy ko'ã va'e, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ha upéi katu omombe'u upe pygwa-pe arandu rehegwa nhe'ẽ uvaty-py omba'apo va'e rehegwa-rami: —Oĩ va'ekwe uva onhotỹ va'ekwe. Oho onhotỹ uvaty omoĩ hagwã. Ha omoĩ rire oheja omba'apo va'erã-pe yva aju omboja'o ja'o arã ime'ẽ-vy va'e-pe. Upéi oho mombyry. Tetã ambue-py hi'are voi oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Hi'aju ramo omondo va'erã ivía ramo gwembigwái omboja'o hagwã yva mbyte-rupi ogweruruka hagwã ojéupe. Ha uvaty-py omba'apo va'e katu hembigwái-pe oinupã jevy imbou-vy. Nome'ẽi íxupe ogweraha va'erã. Ombojevy oinupã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ambue jevy omondo ivía ramo. Ha'e kwéry oinupã onhembosarái hese, ombojevy rei ave mba'eve e'ỹ ogweru hagwã íxupe nomboetéi-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ambueve omondo jevy ombohugwypa, omonha imbojevy imbou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Upe rire uvaty járy he'i opy'a-py: “Mbava'e tipo ajapo-ta” he'i opy'a-py. “Amondo jevy-ta xe rembiayhu tee. Amondo-ta xe ra'y. Omboete-ta para'e xe ra'y ogwahẽ oho-vy ramo” he'i mo'ã. Upéa-rehe gwa'ýry omondo. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ohexa-ma ramo ta'ýry omba'apo va'e he'i ojóupe: —Upéa uvaty jaryrã. Jaha jajuka íxupe, he'i jevy hese. —Upéixa ramo opyta arã nhande-vy imba'erãgwe, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Upéixa-gwi uvaty-gwi ogwenohẽ ojuka íxupe. Oikwaa-ma ramo uvaty járy, mba'e tipo ojapo-ta íxupe kwéry? ");
INSERT INTO kgkNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ohepy joty va'erã íxupe kwéry. Ogwahẽ-ta voi ojuka uka upe hembiapo vai va'e-pe. Ohekoviarõ-ta omba'apo va'erã, he'i Hesu judeu ruvixa kwéry rekokwe oikwaa uka-vy. Ohendu-ma ramo Hesu nhe'ẽ, upe uvaty rehegwa-rami hesegwa omombe'u va'e nhe'ẽ, he'i: —Niporãi voi oiko ramo upéixa, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Upéi Hesu oma'ẽ hese kwéry ha he'i jevy: —Pene mandu'a kena Nhandejáry nhe'ẽ ohai uka va'ekwe-rehe. “Ndovaléi upe ita, he'i óga omopu'ã va'e imboyke-vy. Ha ojohu vai jepe, upe ita óga pytahoha ramo oiporu. Óga pytahoha voi ita.” he'i Nhandejáry kwatia nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ho'a-ma ramo upe ita-rehe opẽmba va'erã ho'a va'e. Ha ho'a-ma ramo upe ita kente ári omongu'ipa-ma va'erã íxupe, he'i jevy ita rehegwa nhe'ẽ-rami ojéhegwa nhe'ẽ henduháry rehegwa nhe'ẽ ave omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ohendu ramo inhe'ẽ oikwaa pya'e ojéhegwa hikwái. —Nhande rehegwa nhe'ẽ omombe'u Hesu arandu nhe'ẽ oiporu ramo, he'i ojóupe judeu rekombo'ehaty kwéry, pa'i ruvixa kwéry ave. Upéa-gwi oipyhyse mo'ã íxupe. Ha ikyhyje-gwi ndoipyhýiry. Hesu reroviaha heta oĩ indive-gwi ikyhyje. Nombopoxyséiry íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Upéixa-gwi ome'ẽ plata gwembigwairã-pe: —Peho meme Hesu ndive pemonhe'ẽ avy hagwã íxupe, he'i ome'ẽ-vy inhe'ẽ mbojejavy uka va'erã-pe mo'ã hepyrã. —Pejeapysaka porã katu inhe'ẽ-rehe. Pende rekoha porã va'e-rami peiko-vy pehendu hendu ra'anga inhe'ẽ. Peteĩ nhe'ẽ va'e ojavy ramo nhamombe'u-ta mburuvixa-pe oipyhy uka va'erã ojuka uka hagwã, he'i omonhe'ẽ avyse mo'ã-vy Hesu-pe. Inhe'ẽ avy ramo ohendu hagwã mo'ã oiko indive. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Aipo ramo imonhe'ẽ avyharã mo'ã oho indive. Oporandu íxupe: —Mbo'eháry, jaikwaa anhei-rupi erenhe'ẽ. Anhei-rupi ne remimombe'u mbe'u, he'i omonhe'ẽ avyse-vy. —Nerepenái avave-rehe neremo'ãi avave-pe. Nde-vy enterovéa peteĩxante. Anheigwa eremombe'u Nhandejáry rape porã-rehe ereporombo'e ramo, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","—Iporã tipo nhande judeu reko-rupi jaiko va'e japaga nhame'ẽ-vy hemimbopaga uka mburuvixagwasu César-pe? Iporã tipo japaga e'ỹ íxupe? he'i oporandu-vy hikwái Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ha Hesu katu oikwaa voi hese. Ndogwerekói ramo gwova-py mba'eve, oikwaa joty ipy'a ky'aha. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Eme'ẽ xe-vy plata atã mburuvixagwasu remimbopaga uka xe ahexa hagwã, he'i. Ome'ẽ rire oporandu rei íxupe kwéry: —Kiva'e ra'anga oĩ ko'a-py? Kiva'e ohai uka va'ekwe? oporandu rei íxupe kwéry. —César ra'anga, he'i. —Hembihai uka ave, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Aipo ramo, eme'ẽ César-pe imba'e. Ha Nhandejáry-pe katu eme'ẽ hemimbota ave, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndikatúi omonhe'ẽ avy íxupe ojogweroaty pa'ũ-rupi. “Hasy va'e-rehe jepe nhaporandu ramo íxupe, omombe'u porã joty” he'i hese opondera-vy. Ha mba'eve noporanduvéi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ha upéi ou henda-py gwĩ saduceu kwéry. “Ndoikovéi-ma va'erã omano va'ekwe” he'i rei va'e saduceu kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ou oporandu Hesu-pe: —Mbo'eháry, he'i íxupe hikwái, —Moisés amyrĩ omoĩ va'ekwe kwatia-rehe Nhandejáry remimbota ohai nhande-vy: “Tyke'ýry omano ramo, oheja ramo gwembirekokwe naimemby jepéi ramo, tomenda katu tyvýry gwovajare-rehe. Upéixa ramo, Ke'y ra'y, he'i mo'ã va'erã imemby ypy-rehe.” Upéixa voi Moisés amyrĩ omoĩ va'ekwe nhande-vy kwatia-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","—Oĩ va'ekwe peteĩ tyke'ýry seis tyvýry. Tyke'ýry omenda kunha-rehe. Upéi omano ramo, ndata'ýry jepéiry. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Tyvýry omenda gwovajare-rehe. Ndata'ýry jepéi ramo omano ave tyvýry. Upéi tyvýry ambue jevy omenda hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Peteĩ teĩ omenda hese, gwovajare-rehe. Peteĩ teĩ omano ramo ndaita'ýry jepéi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Upe rire upe kunha ave omano-ma ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Oikove jevy ramo, kiva'e rembirekorã upe kunha? Gwĩ sete tyvýry kwéry omenda va'ekwe hese, he'i oporandu-vy Hesu-pe upe “Omano va'ekwe ndoikove jevýi” he'i va'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Ha upéa-rehe Hesu omombe'u íxupe kwéry: —Amombe'u-ta peẽ-my omano va'ekwe oikove jevymaha. Tekoha-rupi porã oiko va'ekwe gwive onhemoingove jevy rire katu nomendavéi-ma va'erã ãygwa omendaha-rami, he'i íxupe. —Kwimba'e kwéry nomendavéi-ma va'erã. Kunhagwe ave nomendavéi-ma va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Oiko va'erã Nhandejáry rembigwái yváy pygwa reko-rami. Upéixa-gwi nomendavéi-ma va'erã. Nomanovéi-ma va'erã ave, he'i. —Ha'e kwéry Nhandejáry ra'y voi, Nhandejáry rajy ave. Oikove jevy-ma va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Upéixa ave Moisés amyrĩ omombe'u ave omano va'ekwe oikove jevy va'erã. Yvyra ra'y okái va'e rehegwa nhe'ẽ omombe'u ramo, omombe'u ave Nhandejáry nhe'ẽ. He'i Moisés: “Nhandejáry a-rami he'i: Xe-ma Abraão Járy va'e xe. Isaque Járy va'e ave xe. Jacó Járy va'e ave xe” he'i Nhandejáry Moisés amyrĩ kwatia-rehe. Ha omanomba rire ae upe myamyrĩ, he'i va'ekwe upéixa, he'i Hesu. Upéi he'i: ");
INSERT INTO kgkNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","—Ha'e-ta katu xe: Nhandejáry ndaha'éi omano va'ekwe Járy. Oikove va'e Járy voi Nhandejáry. Íxupe oikovepa joty, he'i Hesu nhane moingove jevyha-rehe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Upéa-rehe gwĩ judeu rekombo'ehaty he'i íxupe: —Iporã voi ne nhe'ẽ. Hasy va'e-rehe jepe oroporandu ramo nde-vy, eremombe'u porã joty, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ha upe rire ave ndaipy'agwasuvéi oporandu mba'eve-rehe Hesu-pe. Ndikatúi omonhe'ẽ avy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ha upéi katu Hesu oporandu imonhe'ẽ avyse mo'ã va'e kwéry-pe. —Mba'éixa tipo Cristo ymagware Davi remiarirõre? ");
INSERT INTO kgkNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Iporahéi kwéry-py kwatia-rehe omoĩ-vy omombe'u va'ekwe Davi Cristo rehegwa nhe'ẽ: “Nhandejáry he'i xe Járy-pe: Egwapy katu xe yke-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Xe orombopu'aka-ta ne a'e'ỹha-rehe, he'i. Xe yke-rehe eregwapy ereha'arõ-vy nde pogwy-py amoingo hagwã ne a'e'ỹha kwéry, he'i Nhandejáry xe Járy-pe.” Upéixa ohai va'ekwe Davi amyrĩ Nhandejáry kwatia nhe'ẽ héry va'e Salmo-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ha Davi amyrĩ katu “Xe Járy” he'i Cristo-rehe. Nhane remiarirõ-rehe “Xe Járy” ndaja'éiry. Aipo ramo hemiarirõ pa? he'i Hesu omokirirĩ-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Enterovete va'e ohendu jave Hesu he'i gwĩ doze gwemimbo'e kwéry-pe: ");
INSERT INTO kgkNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Xáke, onhemboetese rei judeu rekombo'ehaty kwéry. Oao puku reheve ogwatase voi. Kente kwéry-pe omboete uka onhembotuvixa vixa oho-vy mba'e jogwa haty-py. Ojeporahéi haty-py ogwapyse mburuvixa pa'ũ-my. Mburuvixa gwapy haty-rupi ogwapyse onhembovía ramo jekarugwasu haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ha tembirekokwe rembiporu omonda heraha-vy. Upe rire temiexagwã rei omondo mondo ra'anga rei Nhandejáry-pe heta onhe'ẽ enterove ohendu hagwã. Ombohasa asyve-ta íxupe kwéry Nhandejáry, he'i judeu rekombo'ehaty-rehe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ohexa Hesu kente kwéry Nhandejáry roga kakwaa-py. Oma'ẽ oĩ-vy plata mboyru haty-rehe Hesu. Ogwahẽ imba'e heta va'e kwéry omoĩ heta jepe hetave tave omombyta joty ojéupe gwarã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ohexa ave kunha tembirekokwe okwerĩ ome'ẽ va'e mokõi plata atã, omoĩ hyru-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Upe-ma ramo Hesu he'i: —Anhete ha'e-ta peẽ-my, he'i. —Ko kunha tembirekokwe iporiahu va'e ome'ẽ hetave enterove-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ha'e kwéry katu ome'ẽ heta jepe hetave tave omohemby ojéupe gwarã kwéry. Ko kunha katu imboriahu-gwi ome'ẽmba-ma gwembi'u repyrãgwe, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Oĩ Nhandejáry róga kakwaa-rehe omombe'u mbe'u ojóupe. Iporã eterei omoĩ hese ombojegwa-vy. Hemime'ẽgwe ẽgwe-rehe ita porã porã va'e-rehe onhomongeta hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ha Hesu he'i: —Ogwahẽ va'erã áry gwĩ pehexa va'e gwive ho'apa va'erã. Ndopytái va'erã peteĩ ita ojo'ári, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ha oporandu hikwái Hesu-pe: —Mbo'eháry, araka'e tipo oiko va'erã upéa? Mbava'e tipo oiko-ta oroikwaa hagwã ojehu-ta ramo ne remimombe'ukwe gwive? he'i oporandu-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ha Hesu he'i: —Aníke penhembotavy teĩ. Heta he'i rei va'erã, “Xe ko Cristo, pene remiha'arõ va'e” he'i arã ijapu-vy. Ani ererovia teĩ íxupe. He'i rei arã ave, “Ogwahẽ-ma hi'óra oiko hagwã Nhandejáry nhande ruvixarã” he'i arã oapu rei-vy. Ani ererovia teĩ íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","10","Nhorairõ rerakwã erehendu ramo ani erekyhyje teĩ. Nhorairõ-py ohekoviarõ arã mburuvixa. Upéa oiko va'erã voi. Upe jave jepe ne'írã vyteri ogwahẽ inhe'ẽ ijapy-py, he'i. Upéi he'i jevy íxupe kwéry: —Ojehu va'erã pene mongyhyje va'erã. Yvypóry onhorairõmba va'erã onhondive. Tetã mygwa kwéry onhorairõ va'erã tetã ambue mygwa kwéry ndive. Mburuvixagwasu gwembigwái soldado kwéry-pe omonhorairõ uka ave arã ambue mburuvixagwasu rembigwái soldado kwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Heta tetã-rupi oiko va'erã yvyryrýi hatã, nhembyahýi ave, ha mba'asy ave oiko va'erã. Oĩ va'erã heta pene mongyhyjeharã. Yváy-rehe ave ojehexa va'erã hexapyrã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Ojehu e'ỹ mboyve upéixa pehasa asy ete va'erã. Nde pyhy arã nde reraha ne mbohasa asy-vy, ojeporahéi haty-py ne monhe'ẽ uka hagwã. “Erenhemonhandejáry rei Hesu-rehe” he'i arã nde-vy. Upéi katu ne mombo va'erã preso ojepyta haty-py. Xe-rehe ha-py nde reraha va'erã mburuvixa renda-py, mburuvixagwasu renda-py ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Upéixa nde rereko asy va'erã xe rehegwa nhe'ẽ eremombe'u hagwã íxupe kwéry. Emombe'u porã katu xe rehegwa nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ani nde py'a nhemondýi teĩ ere va'erã-rehe. Xe oromoarandu va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ne nhe'ẽrã ame'ẽ va'erã nde-vy, ne arandurã ave ame'ẽ va'erã nde-vy ndikatúi hagwã gwĩ nde-rehe ija'e'ỹ va'e ne mboapu. Onhe'ẽ poxy rei rei va'e nane nhe'ẽ mbojevy kwaái va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nde re'ýi ete va'e kwéry ave pende rereko asy va'erã. Nde ru, nde sy, nde ryke'y, nde ryvy, ne reindy, nde kyvy, nde kypy'y, nde ryke enterovete nde reraha uka va'erã nde rereko asy-vy, ne irũ kwéry ave xe-rehe ha-py pende rereko asy asy va'erã. Ija'e'ỹ va'erã pende-rehe. Oĩ gwĩ pene pa'ũ mygwa-pe ojuka va'erã ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xe-rehe ha-py enterove ija'e'ỹ va'erã pende-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Upéixa ramo jepe ne mbaraete katu. Xe ororesende jevy va'erã. Peteĩ jepe nde ávy nokanhýi va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Xe nhe'ẽ-py meme katu eiko erenheresende hagwã, he'i Hesu omotenonde-vy íxupe kwéry hekorã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Hesu he'i jevy: —Pehexa ramo Jerusalém tetã-my ogweroajere ramo soldado kwéry mburuvixa ndive peikwaa-ma va'erã onhehunditamaha. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Upe-ma ramo Judéia-py oĩ va'e tokanhymba katu yvyatyrusu-rupi tokanhymba oje'ói-vy. Tetã-my oĩ va'e tosẽ katu pya'e okanhy-vy. Nhu-my oĩ va'e ani oike teĩ tetã-my. Tokanhymba katu. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Upe áry-py Nhandejáry nhe'ẽ he'i va'ekwe gwive oiko va'erã. Judeu kwéry ohasa asy asy va'erã hembiapo apokwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ombovy'are'ỹ va'erã íxupe kwéry. Ivy'are'ỹve va'erã gwĩ kunha imemby va'erã, gwĩ imemby mixĩ va'e ave. Ohasa asy eterei va'erã hikwái. Judeu kwéry-pe ijyvy reheve Nhandejáry ombohasa asy-ta voi. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Oĩ va'e kysepuku-py omano va'erã. Oĩ va'e omboja'o heraha-vy tetã ambue-py oiko hagwã tembigwái ramo. Oĩ ave opyta va'e Jerusalém tetã-my judeu e'ỹ va'e pogwy-py. Hi'are va'erã upéixa. Judeu e'ỹ va'e kwéry ojapopa upe Nhandejáry omotenonde hesegwa peve, opyta va'erã ipogwy-py Jerusalém tetã upe-py oĩ va'e gwive. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Hesu he'i jevy: —Gwĩ yváy rehegwa ojei va'erã gwape-gwi. Yváy-gwi kwarahy oje'o va'erã. Jasy ave hendy'ã va'erã, jasytata ave ojei va'erã gwape-gwi. Kente kwéry tetã tetã mygwa katu onhemondýi va'erã ygwasu ryapu rendu ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kwimba'e kwéry katu ikyhyje ete-gwi omano va'e-rami oiko va'erã. Ova ova va'erã gwendagwe-gwi entéro yváy rehegwa imbaraete va'e. Upéa-gwi onhepy'a mondýi va'erã oha'arõ-vy ou va'erã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Upéi katu xe Nhande Ryke'y tee va'e ajehexa uka va'erã agwejy ramo arai-rehe. Xe pu'aka reheve, xe rendy marangatu pende resa mbojevy va'e reheve xe rexa va'erã aju-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Upe va'e ojehu-ma ramo, tane mbaraete katu. Ani katu ne kyre'ỹ e'ỹ teĩ, hi'agwĩ ne resende va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Upéi omombe'u jevy Hesu arandu rehegwa nhe'ẽ figo máta rehegwa-rami: —Pema'ẽ katu figo máta-rehe, opa yvyra rakã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Henhói-ma ramo hogwe pyahu-ma ramo peikwaa-ma voi ogwahẽ-tama áry hakuha. Pehexa ramo peikwaa. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Upéixa ave xe remimombe'ukwe. Pehexa ramo oikomaha xe remimombe'ukwe, peikwaa va'erã Nhandejáry oiko-tama entéro va'e ruvixarã. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Anhete ko ha'e-ta peẽ-my: Ãygwa omano e'ỹ mboyve ojehu va'erã ko va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Áry opa va'erã, ko yvy gwive opa va'erã. Xe nhe'ẽ, xe remimombe'ukwe ae ndopái va'erã. Opyta va'erã opa e'ỹ reheve. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","—Xáke! Perepara porã katu pende rekoha-rehe. Peiko porã katu xe ra'arõ-vy. Ani pene mandu'a eterei teĩ pene monga'uharã-rehe. Ani pene mandu'a eterei teĩ ave pene mbohoryharã-rehe. Ani ave pejepy'apy eterei teĩ pene remikotevẽ ko'a pygwa-rehe. Xe aju jevy hagwã-rehe ae tapene mandu'a ndu'a katu peiko-vy. Sapy'a, ndorepara porãiha óra-py ombo'a nhuhã mymba. Upéixa ave sapy'a naxe ra'arõ porãiha óra-py ojekwaa va'erã entéro ko yvy rupigwa kwéry-pe xe aju jevyha áry. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Upéa-rehe perepara katu ha'arõ-vy xe agwahẽ hagwã-rehe. Pejerure rure katu Nhandejáry-pe mba'eve rei ndoikói hagwã peẽ-my. Xe Nhande Ryke'y tee va'e aju jevy va'erã. Pejerure íxupe pene mbopy'a porã hagwã pono penotĩ pende rekoha xe renonde-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nhandejáry róga kakwaa-py Hesu oporombo'e áry jave. Pyhare ramo osẽ oho-vy yvyatyrusu Oliveiraty-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ha pyharevete meme ou jevy Nhandejáry róga kakwaa-py. Entéro tetã mygwa oho-ma ohendu hagwã Hesu remimombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ogwahẽ-tama aretegwasu. Upe-ma ramo gwĩ ija'e'ỹha ojukase eterei Hesu-pe. Judeu kwéry-pe mate upe aretegwasu. Héry va'e páscoa. Oime jave páscoa mbojape imbovuha e'ỹ va'e ho'u judeu kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ha ogwahẽ-tama ramo aretegwasu, gwĩ judeu va'e ojukase voi Hesu-pe. Pa'i ruvixa kwéry, hekombo'ehaty kwéry ndive ija'e'ỹha kwéry ojukase íxupe. —Mba'éixa pa jajuka-ta upe va'e, he'i meme ojóupe hikwái. —Iporãve jajuka uka nhemi íxupe ani hagwã nhambopoxy ija'eha kwéry-pe. Upéixa he'i meme ojóupe ojukase eterei-gwi Hesu-pe. Ijaty jaty va'e-gwi ikyhyje eterei-gwi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Upe jave anhaygwasu Satanás oike-ma gwembigwairã py'a-py. Judas Iscariotes héry ete. Peteĩ doze Hesu remimbo'e kwéry va'e Judas. Ha anhaygwasu ogwapy ijyke-rehe ojokwái hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Upéi Judas oho onhomongeta pa'i ruvixa kwéry ndive. Anhaygwasu nhe'ẽ-rupi oho. Oho otopa hagwã Hesu-rehe ija'e'ỹha kwéry. Pa'i ruvixa kwéry ndive Nhandejáry róga kakwaa-rehe onhangareko va'e kwéry ndive ave ojotopa he'i hagwã mba'e-rami po oipyhy arã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Upéa-rehe ovy'a eterei okwa-vy. —Nde, ereme'ẽ ramo Hesu ore-vy, orome'ẽ-ta nde-vy nde platarã. Hesu-rehe orome'ẽ-ta nde platarã, he'i Judas-pe ovy'a-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Iporã ereme'ẽ kuri xe-vy xe platarã, he'i íxupe kwéry. Upéixa-ma ramo, Judas orepara oiko-vy Hesu-rehe ipyhyharã-pe omombe'uha óra ra'arõ-vy. Ijaty aty e'ỹha óra-rehe oha'arõ arõ oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","8","Ogwahẽ-ma ramo aretegwasu, Hesu omondo Pedro, João ndive ojapo hagwã tembi'u aretegwasu-py ho'u va'erã. Páscoa áry-gwi judeu kwéry ojuka ovexa ho'u va'erã Nhandejáry-pe omboete-vy. Ojapo ave mbojape ombovu e'ỹ va'e ho'u va'erã. Upéixa ojapo hagwã Hesu omondo Pedro-pe, João-pe ave gwenonde. —Tapeho tetã-my, he'i. —Pejuka peteĩ mymba ovexa ja'u va'erã nhande ave aretegwasu-py so'o mbixy, he'i imondo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—Kipy tipo orojapo-ta? he'i oporandu-vy hikwái íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Peike jave ramo upe tetã-my, pehexa-ta peteĩ y ogweraha va'e. Kwimba'e y ryru ogweraha va'e pehexa-ta. Tapeho hapykwéri. Oike-ma ramo óga-py, pegwahẽ penhomongeta óga járy ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","A-rami penhe'ẽ kuri íxupe, he'i. —“Mbo'eháry ore mbou oroporandu hagwã nde-vy: Kiva'e koty-py ha'u-ta páscoa remi'urã xe remimbo'e kwéry ndive? Aiporuse nde koty ore mandu'a hagwã páscoa-rehe” ere íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ohexa uka-ta peẽ-my peteĩ koty jaiporu-ta va'e. Kotygwasu, ijyvate va'e oĩmba-ma va'e ohexa uka-ta peẽ-my. Upe koty-py ja'u-ta nhane remi'urã, páscoa-rehe imandu'a va'e pegwarã. Ore mohenonde pejuka mymba vexa nhande-vy gwarã, he'i Hesu omondo-vy gwenonde. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Upéi oho-ma okwa-vy. Mokõive oho tetã-my. Ha Hesu he'i hagwe-rami ojohu. Upéi ojapo tembi'u aretegwasu páscoa-rehe imandu'a-vy ho'u va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Upéi okaru hagwã óra-py Hesu ogwapy doze gwemimondo kwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Okaru-tama ramo he'i íxupe kwéry: —Ha'use eterei pene ndive ko aretegwasu-py tembi'u. Xe rereko asy amano hagwã e'ỹ mboyve akaruse pene ndive, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","—Ha'e-ta katu peẽ-my: Ko'a-py nda'uvéi-ma ãy-rami aretegwasu-py tembi'u. Xe are-ta ha'u jevy hagwã. Oikopa-ma rire, ha'u jevy va'erã, he'i íxupe kwéry. —Nhandejáry nhande ruvixa oiko haty-py mate ha'u jevy va'erã, he'i gwemimondo kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Upe-ma ramo Hesu oipyhy uva rykwere ryru. Omboete Tupã Nhandejáry-pe. Upéi ho'u uka gwemimondo kwéry-pe: —Pe'upa katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","—Anhete ha'e-ta peẽ-my. Nda'uvéi-ma voi uva rykwere. Nhandejáry nhande ruvixarã ojekwaa rire ae ha'u jevy va'erã, he'i onhemohekotenonde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Oipyhy ave mbojape páscoa áry pegwa. Upéi otima rire Nhandejáry-pe ombopo mbopóy ome'ẽ-vy gwemimbo'e kwéry-pe ho'u hagwã. Ha he'i: —Ko mbojape-rehe ha'e “Xe rete” he'i. —Pende-rehe ha-py anheme'ẽ va'erã peẽ-my amano hagwã, he'i. —Kóa ere'u ramo ne mandu'a kena xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Upéixa ojapo ave okarupa-ma rire. Ome'ẽ íxupe kwéry ho'u uka-vy uva rykwere: —Ko va'e pe'u katu, he'i. —Ko va'e-rehe ha'e “Xe rugwy” voi, he'i. —Osyry va'erã xe rugwy kente kwéry rekove-rehe. Tupã Nhandejáry he'i hagwã kente kwéry-rehe, “Ipy'a potĩ-ma. Hesu-rehe ojerovia-gwi omopotĩ-ma ipy'a” he'i hagwã Tupã Nhandejáry osyry va'erã xe rugwy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","—Xe Nhande Ryke'y tee va'e amano-ta. Xe ndive ogwapy oĩ-vy xe juka uka nhemi va'erã, he'i Hesu. —Tekotevẽ amano kente kwéry aresende hagwã. Amboasy upe xe juka ukaharã. Ohasa asy eterei va'erã, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Upe-ma ramo oporandu randu ojóupe hikwái: —Kiva'e pa ojuka uka nhemi-ta Hesu-pe, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ha hemimbo'e kwéry katu onhomongeta ngeta onhondive: —Kiva'e pa tuvixave nhane pa'ũ-my, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Upe-ma ramo Hesu he'i: —Mburuvixa kwéry, ko yvy pygwa ogwereko pu'aka yvypóry kwéry-rehe. Onhe'ẽ-py omanda manda íxupe kwéry. Ha oĩ gwĩ mburuvixa katu onhembotuvixave kente kwéry renonde-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Peẽ onhopa'ũ-my ndaikatúi upéixa peiko. Peẽ onhopa'ũ-my pende tuvixave ramo jepe penhemohekomirĩve katu peiko-vy onhopa'ũ-my. Mburuvixa katu toiko tembigwái-ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ha'e-ta ave peẽ-my: Tuvixave va'e-pe hembigwái ogweru hemi'urã. Ha xe katu tembigwái-rami voi aiko pene pa'ũ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Peẽ katu xe moirũ meme peiko-vy. Ambue kwéry xe mbojejavyse mo'ã meme jave xe moirũ-ma peẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yma va'ekwe Nhandejáry he'i xe-vy: “Xe ra'y, nde ereiko-ta mburuvixa ramo xe moirũ va'erã-pe”. Upe va'e-rehe, pe xe Ru ome'ẽ hagwéixa xe-vy, xe ame'ẽ va'erã peẽ-my ave. Peiko-ta ave mburuvixa ramo. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nhandejáry ha-py xe aiko-ma ramo nhande ruvixarã, peiko-ta xe ndive. Pekaru ha pey'u-ta xe ndive. Pegwapy-ta ave mburuvixa gwapy haty-rupi pejohu hagwã Israel re'ýi kwéry-rehe hembiapokwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","He'i ave Hesu: —Ejeapysaka porã kena xe nhe'ẽ-rehe, Simão. Anhaygwasu ojerure-ma kuri pende-rehe. Oikwaase kiva'e-rehe pa pejerovia ete. Ipirekwe osẽsẽ hagwã ovale va'e-gwi nhambovava trigo-pe. Upéixa ave anháy ruvixa Satanás pende rerekose. Pene mbotavyse ponove peiko xe nhe'ẽ-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Xe katu ambojeupi kuri xe nhe'ẽ Nhandejáry-pe nde-rehe, Simão, erejerovia tee hagwã xe-rehe pono inhe'ẽ-rupi ereiko. Erejerovia ete jevy ramo xe-rehe, emokyre'ỹ katu nde rapixa kwéry-pe oiko porãve hagwã xe nhe'ẽ-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Upe-ma ramo Pedro he'i: —Aháni, oromoirũ-ta xe. Nde erepyta ramo preso, xe apyta ave arã ne ndive preso, he'i íxupe. —Eremano ramo amano ave va'erã ne ndive, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hesu katu he'i íxupe: —Anhetegwa ha'e-ta nde-vy, he'i íxupe: —Etería gáju ndosapukái vyteri ramo jepe, mbohapy-ma ere-ta xe-rehe, “Upéa Hesu xe ndaikwaái” ere-ta xe-rehe, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Upéi he'i íxupe kwéry: —Apomondo mondo ramogware, peho nandi voi. Ndaperaháiry voi va'ekwe mba'eve. Pene mba'e ryru ndaperahái va'ekwe. Pende pirapire ryru ndaperahái ave va'ekwe. Upéixa nandi peho va'ekwe ramo mba'e tipo pene remikotevẽ? he'i joty Hesu oporandu-vy. —Mba'eve-rehe noroikotevẽi upe jave, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Ãy katu ha'e-ta peẽ-my: Ogwereko va'e opirapire ryru omba'e ryru ave, oipyhy-ta. Kysepuku ogwereko e'ỹ va'e kyse repyrã-rehe ome'ẽ-ta oao jo'a. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","—Nhandejáry nhe'ẽ kwatia-rehe ohai va'ekwe xe-rehe he'i: “Hembiapo vai va'e-rami ojerereko va'erã”. Anhete ha'e-ta: Ojehu-tama xe-rehe ojehai va'ekwe, he'i íxupe gwekoharã omotenonde-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Upe-ma ramo hemimbo'e kwéry he'i: —Ko'a-py niko oĩ mokõi kysepuku, ore Járy. Ha ha'e he'i: —Iporã, he'i joty. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Oho meme ha-py oho jevy Hesu. Yvyatyrusu héry va'e Oliveiras ha-py oho. Gwemimbo'e kwéry ndive oho. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ogwahẽ-ma jave oho-ta ha-py oiporavo hagwe-py, ha'e he'i: —Pejerure Nhandejáry-pe pono eremondo nde resa ne mbojejavy uka va'e-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Upe rire ojei íxugwi kwéry mombyrymive ojei. Gwetymy'ã-rehe onhesũ ha onhepyrũ onhomongeta-vy Nhandejáry ndive: ");
INSERT INTO kgkNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Ereipota ramo, xe Ru, eipe'a xéhegwi xe reko asyha. Ani oiko teĩ xe remimbota, ne remimbota ae toiko, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Upe jave Nhandejáry rembigwái yváy pygwa ojehexa uka omombaraeteve hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ojepy'ajopy jave Hesu imbaraete pyve onhomongetave Nhandejáry ndive. Ombojeupi jave onhe'ẽ Nhandejáry-pe mba'e rugwy-rami otyky yvy-py hy'aikwe ojepy'ajopy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Upéi opa-ma ramo hi'oração opu'ã jevy ou-vy gwemimbo'e kwéry renda-py, oke okwa-vy va'e ojohu. Tuvixa ima'emboasy omonge íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ha Hesu he'i: —Ma'erã tipo peke? Pepu'ã katu pejerure Nhandejáry-pe pene mombaraete hagwã, pono ne mbojehesa rerova uka íxugwi mba'eve nembojejavy uka-vy, he'i onhemonhe'ẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hesu onhe'ẽ vyteri oĩ-vy, ogwahẽ heta kente kwéry. Peteĩ doze hemimbo'e kwéry va'e, héry va'e Judas ogweru íxupe kwéry. Judas katu ogwahẽ Hesu ypy-py ohovapyte hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Upe-ma ramo Hesu he'i: —Judas, peteĩgwe xe rovapyte mo'ã xe pyhy uka hagwã, xe Nhande Ryke'y tee va'e xe pyhy uka-ma, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Upe jave hemimbo'e kwéry oĩ va'e Hesu ndive, ohexa-ma ramo ojehu va'erã he'i hikwái: —Mba'e tipo jajapo-ta, ore Járy? Oroipyhy-ta para'e ore kysepuku, orojoko hagwã íxupe kwéry? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Peteĩ hemimbo'e katu oinambi'o-ma pa'i ruvixa rembigwái. Ijakatúa-koty oĩ va'e inambikwe oipe'a-ma. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ha Hesu katu: —Iporãvete peheja, he'i-vy opoko inambikwe-rehe imbogwera-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Upe-ma rire he'i pa'i ruvixa kwéry-pe, porahéi haty pygwa ruvixa kwéry-pe ave, judeu ruvixa kwéry-pe ave gwĩ ou oipyhy hagwã Hesu va'e gwive-pe, he'i Hesu: —Niporãi katu peju pende kysepuku reheve, ha pende yvyra reheve, xe pyhy hagwã. Xe ndaikói oporosake'a va'e-rami kysepuku reheve xe reraha hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Heta áry-ma aiko pene ndive. Nhandejáry róga kakwaa-py aime meme ramo napemopu'ãiry pende po xe pyhy hagwã. Ãy mate xe pyhy-ta. Kóa pende óra pene remimbota pejapo hagwã xe-rehe. Gwĩ pytũgwy-rupi ipu'aka va'e nhe'ẽ-rupi peiko-ma pene rembiaporã pejapo hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Oipyhy-ma ramo Hesu-pe ogweraha íxupe pa'i ruvixagwasu róga kakwaa-py. Ha Pedro katu oho Hesu rapykwéri puku. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Omoendy-ma ramo tata, upe-py Pedro oho ave ojepe'e hagwã. Tata ypy-py ogwapy oĩ-vy va'e ndive ogwapy ave Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ohexa-ma ramo íxupe tata rendy-py Pedro-pe tembigwái kunha va'e, ohexa katu porã porã íxupe ha he'i: —Ko kwimba'e Hesu ndivegwa va'e ave ra'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Upe-ma ramo Pedro he'i: —Upéa ndaikwaái voi xe, kunha, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Upe riremi ohexa jevy íxupe peteĩ kwimba'e. —Nde ave ra'e ha'e kwéry va'e, he'i. Pedro he'i jevy: —Upéa xe ndaikwaái. Ndaha'éi hesegwa kwéry xe, he'i rei. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Upe rire peteĩ óra-rupi, he'i jevy Pedro-pe ambue va'e: —Anhete voi ra'e nde ave ereiko va'e indive. Nde ave ha'e Galiléia yvy pygwa ra'e, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","He'i jevy Pedro: —Upéa xe ndaikwaái, mba'e-rehe tipo aipo-rami ere xe-vy? he'i rei. Upéixa onhe'ẽ oĩ-vy jave ete, gáju osapukái. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Upe-ma ramo ojere Hesu oma'ẽ porã porã Pedro-rehe. Ha Pedro katu imandu'a Hesu he'i va'ekwe-rehe íxupe, “Ko'ánga gáju ndosapukái vyteri jepe, mbohapy-ma nde ere-ta xe-rehe: Upéa xe ndaikwaái, ere-ta”. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Upéa-gwi hasẽ-ma Pedro. Onhemboasy eterei-gwi ojahe'o oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Gwĩ kwimba'e Hesu-rehe onhangareko va'e onhembohory hese. Ogwerohasa asy eterei Hesu-pe. Oinupã eterei íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ohesamboty íxupe ha he'i: —Kiva'e pa ne nupã? Emombe'u katu, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Heta mba'e he'i rei rei íxupe onhembohory-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ko'ẽ jave ramo ojogweroaty jevy judeu ruvixa kwéry, pa'i ruvixa kwéry, judeu rekombo'ehaty kwéry ndive ave, onhomongeta geta okwa-vy. Upéi katu oipyhy heru-vy Hesu-pe mburuvixa kwéry renonde-py. Ogwahẽ-ma ramo oporandu íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Nde tipo Cristo judeu kwéry remiha'arõ va'e? Emombe'u katu ore-vy, he'i íxupe. Upe ramo Hesu he'i: —“Xe Cristo judeu kwéry remiha'arõ va'e voi” ha'e ramo, ndaperoviái joty arã. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Anhetegwa ha'e-ta peẽ-my: Aporandu ramo peẽ-my, napemombe'u mo'ãi xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Xe Nhande Ryke'y tee va'e ãy gwive agwapy-ta yváy-py Tupã Nhandejáry yke-rehe. Upe ipu'aka ete va'e ndive xe agwapy-ta, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Upe-ma ramo enterove oĩ va'e oporandu íxupe: —Aipo ramo Nhandejáry ra'y tee voi va'e tipo nde? he'i íxupe. —“Nde ha'e voi” peje kuri xe-vy, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Upe-ma ramo he'i ojóupe: —Nanhaikotevẽvéi-ma imombe'uharã-rehe. Nhande katu nhahendu-ma voi ha'e inhe'ẽ tee voi. Onhemonhandejáry rei Hesu, he'i ojohu vai-vy Hesu nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Upe jave kente kwéry ijaty va'e opu'ãmba ojereraha hagwã Hesu ndive mburuvixagwasu Pilatos renda-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","—Oroipyhy-ma katu ko kwimba'e. Ohekombo'e va'ekwe-gwi ore re'ýi kwéry ndoikosevéi-ma mburuvixagwasu César nhe'ẽ-rupi, he'i hese. —Ha'e katu omombe'u kente kwéry-pe pono ome'ẽ mburuvixagwasu César-pe mba'eve, he'i rei ave hese. —“Xe Cristo Nhandejáry remimbou va'e pene ruvixarã” he'i ójehe, he'i omoĩ vai-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Upe-ma ramo Pilatos oporandu Hesu-pe: —Nde tipo judeu kwéry ruvixagwasu? he'i íxupe. —Nde voi katu aipo ere kuri, he'i joty íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Upéi Pilatos he'i pa'i ruvixa kwéry-pe, ojogweroaty va'e kente kwéry-pe ave: —Ko kwimba'e katu nahembiapo vaíry va'e voi. Aipo ramo niporãi ajuka uka íxupe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kente kwéry katu he'i jevy jevy: —Hese ha-py hemimombe'u-gwi voi Judéia yvy pygwa kwéry ndogwerojojái onhonhe'ẽ onhomboja'o ja'o upéixa-gwi. Galiléia-gwi ko'a peve ndaija'evéi ojóehe íxugwi. Ãy katu ogwahẽ-ma ko'a-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aipo va'e rendu-vy Pilatos oporandu: —Ko kwimba'e tipo Galiléia yvy pygwa? he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Oikwaa-ma ramo Pilatos Hesu upe pygwaha, omondo Hesu-pe upe pygwa ruvixa héry va'e Herodes-pe. Upe va'e oiko ave Jerusalém tetã-my ombohupa-vy. Upéixa-gwi omondo Hesu Herodes renda-py oporandu hagwã hembiapokwe-rehe. Ojohuse mo'ã Hesu-rehe hembiapo vaikwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ovy'a mburuvixa Herodes ohexa-ma ramo Hesu-pe. Ohendu va'e voi ave Hesu rerakwã porã. Yma-ma upéa-gwi ohexase eterei íxupe. Ohexase ave Hesu ojapo ramo hembiapo porã va'e hexapyrã-rupi jahexa e'ỹ vyteri va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Oporandu heta Hesu-pe. Ha Hesu katu nonhe'ẽiry íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Upe-ma ramo pa'i ruvixa, judeu rekombo'ehaty kwéry ndive ijapu hese hembiapokwe-rehe omboja hagwã mo'ã hembiapo vai Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Soldado kwéry, huvixa ndive, omoingo asy-ma Hesu-pe. Omoingo vai-ma voi íxupe. Omoĩ hese ijahoja porã va'e omomburuvixa a'ã hagwã íxupe, onhembohory hory hese, ha upe rire omondo jevy Pilatos oĩ ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Upe mboyve Herodes, Pilatos ndive ndaija'éiry ojóehe. Upe áry gwive oiko porã onhondive. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Omboaty uka Pilatos pa'i ruvixa kwéry, judeu ruvixa kwéry, judeu kwéry ave. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Upéi he'i: —Ma'erã tipo peru xe-vy ko kwimba'e pemombe'u hagwã hese hembiapo vaiha. “Ohekombo'e va'ekwe-gwi ore re'ýi kwéry ndoikosevéi-ma mburuvixagwasu nhe'ẽ-rupi” peje rei kuri hese. Upéa-rehe xe ajohu-ma kuri hese pene renonde-py. Ndoikói ra'e hese ivai va'e penhe'ẽ vai hagwã hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes ave ndotopái hese mba'eve. Upéa-gwi ombou jevy nhande-vy. Upéixa ramo ko kwimba'e ndojapói ko ra'e mba'eve pejuka uka hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ambopi uka-ta mante íxupe upéi apoi-ta íxugwi oho jevy hagwã, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Aretegwasu ramo mburuvixagwasu rekoha-rupi opoi peteĩ onhemoĩ preso va'ekwe. Upéa-rehe, “Apoi-ta íxugwi” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Upéa ohendu-ma ramo entéro kente kwéry osapukái: —Tojuka kena ko kwimba'e, he'i osapukái-vy. —Epoi Barrabás-gwi ore-vy gwarã, he'i osapukái-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás katu onhemoĩ araka'e preso. Upe tetã-my onhorairõ araka'e ohekoviarõ hagwã mo'ã mburuvixagwasu. Oporojuka ave. Upéa-gwi onhemoĩ preso araka'e. Ha “Epoi Barrabás-gwi” he'iri iri hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Mburuvixa ae katu opoise mo'ã Hesu-gwi. Upéa-rehe onhe'ẽ jevy kente kwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ha'e kwéry ae katu osapukái hatãve tãve. —Ejuka uka katu íxupe ehupi uka kurusugwasu-rehe ijuka-vy, he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mbohapyha-ma Pilatos he'i hese: —Mba'eixagwa ivai va'e tipo ojapo? Ndahexái mba'eve ivai va'e hembiapokwe ajuka uka rei hagwã íxupe, he'i. —Ambopi uka rei-ta íxupe oho jevy hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aipo ramo ha'e kwéry osapukái joty: —Tojuka katu, he'i osapuka pukái okwa-vy hese. —Kurusugwasu-rehe tojuka kena. he'i hese hikwái Isapukái katu imbaraeteve ojapo uka hagwã gwemimbota. Upéa-rupi isapukái-rupi ipoxyha-rupi ojapo joty íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ijaty va'e nhe'ẽ rendu-vy, mburuvixa Pilatos ojapo uka hemimbota. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Upe kwimba'e onhorairõ va'ekwe, oporojuka va'ekwe ave, kente kwéry oipota va'ekwe osẽ preso onhemoĩ ha-gwi, upe kwimba'e-gwi opoi uka. Hesu rekovia opoi hembiapo vai va'e-gwi. Ha ome'ẽ Hesu ijukaharã-pe onhemboaty va'e remimbota rei-rupi ogwereko hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ha upéi katu soldado kwéry ogweraha Hesu-pe ojuka hagwã. Ogweraha jave ohogwaitĩ Cirene pygwa, héry va'e Simão. Ou oiko-vy tetã jerekwe-gwi. Oipyhy ave Simão: —Nde, eraha ko kurusugwasu Hesu rapykwéri, he'i-vy omoĩ kurusugwasu Simão ape-rehe ogweraha hagwã Hesu rapykwéri. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Heta oho va'e hapykwerigwa. Ipa'ũ-my kwéry oĩ ave kunha ojahe'o Hesu-pe ombyasy va'e. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Upe-ma ramo Hesu ojere ha oma'ẽ hese kwéry. He'i: —Ani xe mboasy, peẽ kunha. Peẽ ha pene memby ae kuri pemboasy, he'i Jerusalém mygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","—Ogwahẽ va'erã áry oporombohasa asy va'erã, entéro he'i va'erã: “Ovy'a ete gwĩ kunha imemby e'ỹ va'e. Ikatu e'ỹ imemby va'e ave. Oporomokambu e'ỹ va'ekwe ave. Naimembýi-gwi ovy'a” he'i va'erã oporombohasa asy-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Upe ramo he'i arã ave: “To'a yvyatyrusu nhande ári. Tanhande jatypa yvyatyrusu oitypa-vy. Nhande rekove reheve tanhande aty” he'i arã ohasa asy eterei-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","—Ha ko'ánga koixagwa ojapo xe-rehe. Vaive ojapo arã pende-rehe. Xe, yvyra aky-rami heko porã va'e ko xe, ha xe-rehe hembiapo vai joty. Hembiapo vaive ive arã pende-rehe. Peẽ yvyra pirukwe-rami pende reko porã e'ỹ va'e. Hembiapo vaive ive arã pende-rehe, he'i Hesu kunhagwe-pe omboasy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ha soldado kwéry ogweraha ave mokõi hembiapo vai va'e-pe Hesu ndive ojuka va'erã ogweraha. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Akãgwe renda héry va'e-py ogweraha. Ogwahẽ-ma ramo upe-py omoĩ íxupe kurusugwasu-rehe ohupi-vy. Upe mokõi hembiapo vai va'e ohupi ave hendive. Hesu kurusugwasu yke-rehe omoĩ kurusugwasu mokõi. Hesu oĩ hembiapo vai va'e mbyte-py. Ijakatúa-koty oĩ peteĩ, ijasu-koty oĩ ave peteĩ. Kurusugwasu-rehe meme ohupi ojuka-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Oime jave kurusugwasu-rehe Hesu ombojeupi onhe'ẽ Nhandejáry-pe: —Eiporiahuvereko íxupe kwéry, xe Ru. Ndoikwaái-gwi kóixa ojapo hikwái, he'i. Upéi onhomboja'o ja'o Hesu aokwe-rehe hikwái. Onhomboja'o hagwã ohuga soldado kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ha entéro ojogweroaty va'e oma'ẽ ma'ẽ oiko-vy. Ohexapa hikwái. Ha huvixa kwéry ave onhembohory ave Hesu-rehe. He'i rei rei-vy: —Kóa opororesende araka'e, he'i onhembohory hese. —Ãy katu tonheresende kena. Heta he'i hese araka'e: “Hesu ko Cristo nhane remiha'arõ va'e. Nhandejáry rembiporavo va'e voi Hesu” heta va'e he'i va'ekwe Hesu-rehe. Ha ãy tipo ndoikwaái para'e onheresende hagwã. Tonheresende kena, he'i huvixa kwéry onhe'ẽ rei rei onhembohory hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ha soldado kwéry ave onhembohory hese. Onhemoagwĩ íxugwi ome'ẽ íxupe uva rykwere ndahepýi va'e ho'u hagwã mo'ã. Onhe'ẽ rei rei íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Nde para'e judeu kwéry ruvixagwasu va'e. Aipo ramo enheresende kena, he'i onhembohory-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ha ohai omoĩ hagwã Hesu akã ári. “Kóa judeu kwéry ruvixagwasu” he'i ohai omoĩ-vy. Mbohapy nhe'ẽ-py ohai. Grécia pygwa nhe'ẽ-py ohai. Roma pygwa nhe'ẽ-py ohai. Hebreu kwéry nhe'ẽ-py ohai ave. “Kóa judeu kwéry ruvixagwasu” he'i. Mbohapy nhe'ẽ-py ohai rire omoĩ inhakã ári. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ha peteĩ hembiapo vai va'e ave onhe'ẽ rei rei íxupe. Oime jave okurusugwasu-rehe, onhe'ẽ rei rei Hesu-pe he'i-vy: —“Xe Cristo, Nhandejáry rembiporavo va'e” ere kuri ndéjehe. Aipo ramo enheresende katu. Ore ave ore resende katu. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","He'i-ma ramo, upe outro kurusugwasu-rehe oĩ va'e onhemonhe'ẽ oirũ-me: —Nde tipo, ma'erã-gwi nderekyhyjéi Tupã Nhandejáry-gwi? he'i. —Nhande ave nhamano-tama nhande kurusugwasu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nhane rembiapo vaikwe-rehe jahasa asy jaiko-vy. Ha'e ae rei ohasa asy. Mba'eve ndojapói, he'i gwembiapo vaikwe-gwi okurusugwasu-rehe oĩ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Upéi he'i ave: —Nde, Hesu, xe poriahuvereko erejehexa uka ramo nde ore ruvixa ramo, xe poriahuvereko katu. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aipo ramo Hesu he'i íxupe: —Anhete ko'ánga ereiko-ta xe ndive yváy-py, he'i Hesu upe ójehe ojerovia va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","46","Kwarahy mbyte-py pytũmba-ma upe yvy ári. Upe tetã pytũmba ete-ma. Opyta pytũ mbohapy óra-rupi. Ka'arugwasu peve opyta. Kwarahy ndohesapevéi-ma. Ka'arugwasu ramo onhe'ẽ hatã Hesu. Upéi he'i Nhandejáry-pe: —Xe Ru, xe mogwahẽ katu nde ha-py. He'i-ma ramo omano ete-ma Hesu. Ha upéi oĩ Nhandejáry róga kakwaa pygwa okẽgwasu nhugwãha tuvixa ete va'e. Omano-ma ramo Hesu, pya'e osoropa. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ha omano ramo soldado ruvixa ohexapa. Upéixa-gwi omboete Nhandejáry-pe: —Péa ha'e voínte hembiapo vai e'ỹ va'e, he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ha heta heta ojogweroaty aty va'e ou va'ekwe oma'ẽ hagwã ikurusu-rehe ojejuka va'e kwéry-rehe. Ha entéro ojehu va'ekwe gwive ohexa-ma ramo, onhemboasy oiko-vy. “Xe ko, xe py'a vai voi aiko-vy” he'i. “Upe kwimba'e-rami ndaikói voi-ma xe” he'i onhemboasy-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ha heta hese ojerovia va'e oĩ ave upe-py. Gwĩ kunhagwe Hesu rapykwéri ou va'ekwe Galiléia-gwi oĩ ave ijaty va'e pa'ũ-my. Mombyry-gwi oma'ẽ Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ha upéi katu José oho Pilatos renda-py. Arimatéia pygwa José. Judeu kwéry retã Arimatéia. Ha José judeu ruvixa va'e, hembiapo porã va'e. Onhemboete va'e voi. Judeu ruvixa ambue kwéry ojukase ramo Hesu-pe, José ndojohu porãi hembiaporã. Ha'e oha'arõ arõ voi Nhandejáry nhande ruvixa-pe omoirũ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ha José oho Pilatos renda-py ojerure Hesu retekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Upéi ombogwejy kurusugwasu-gwi hetekwe. Onhugwã ao morotĩ iporã va'e-py. Upéi omoĩ itakwa-py hetekwe. Ita-gwi ojo'o va'ekwe-py omoĩ. Ipyahu itakwa. Ne'írã onhemoĩ tetekwe upe itakwa-py. Hesu retekwe omoĩ upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ka'aru-tama, haimete-ma pytu'uha áry. Ha upe áry-py judeu kwéry omoĩmba-ma nga'u pono omba'apo pytu'uha áry-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ha kunha kwéry Hesu ndive ou va'ekwe Galiléia-gwi va'e oho José rapykwéri. Ohexa itakwa. Ohexa ave omoĩ ramo hetekwe hyepy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Upe rire oho jevy gwóga-py omongu'i ngu'i hyakwã porã va'e hykwere omona hagwã Hesu retekwe-rehe omohyakwã hagwã hetekwe. Ha pytu'uha áry-py Nhandejáry remimombe'ukwe-py opytu'u oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo kwarahy osẽ-ma ramo, voi oho kunha kwéry ogwata. Hyakwã porã va'e omongu'i ngu'i va'ekwe ogweraha omona hagwã Hesu retekwe-rehe. Itakwa-py oho. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ogwahẽ-ma ramo ohexa-ma itagwasu ojepe'a va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Oike voi itakwa rye py-py. Oike-ma ramo ndotopavéi-ma hetekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ha upéa-rehe mba'eve ndoikwaái. —Mbava'e tipo jajapo-ta, he'i. Opondera-vy oiko jave mokõi karia'y ohexa, yváy pygwa rembihexa uka ra'e. Ao hesakã ete hemimonde ohexa. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ohexa jave onhemondýi-ma, ojeayvy oma'ẽ yvy-rehe. Upéi karia'y he'i: —Ma'erã-gwi ereheka oikove va'e omano va'e renda-py? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","—Hesu ndaipóri a-py. Opu'ã jevy-ma kuri oho-vy, he'i Hesu-rehe. —Nane mandu'avéi tipo inhe'ẽgwe-rehe? Oime-ma ramo pene ndive Galiléia-py omombe'u-ma voi va'ekwe oikove jevymaha hagwã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","He'i va'ekwe nde-vy: “Xe Nhande Ryke'y tee va'e. Tekotevẽ xe pyhy xe reraha-vy hembiapo vai va'e kwéry-pe. Xe juka-ta kurusugwasu-rehe. Mbohapy áry-py katu aikove jevy-ta” he'i voi va'ekwe. Upe va'e he'i va'ekwe-rehe napene mandu'áiry nipo ra'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ohendu-ma jave imandu'a jevy inhe'ẽgwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Upéi oho jevy itakwa-gwi kunha kwéry. Oho ohexa Hesu remimbo'e kwéry-pe. Gwĩ onze hemimbo'ekwe-pe omombe'u. Hendive oĩ va'e-pe omombe'u ave. —Hesu oikove jevy-ma katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Heta kunha ohexa kuri omombe'u hagwã íxupe kwéry. Maria Madalena ohexa kuri. Joana ave ohexa kuri. Tiago sy héry Maria ave ohexa kuri ave. Hapixa kwéry, indive oiko-ma ave itakwa-py ohexa kuri ave. Ha enterove omombe'u peteĩxa nhe'ẽ Hesu remimondo kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ohendu-ma ramo, —Itavy kunha kwéry, he'i mo'ã. Ndogweroviái Hesu oikove jevymaha. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro ae opu'ã oripara oho-vy itakwa-py. Ojeayvy ohovapyexa hagwã. Inhugwã hagwe mate ohexa. Ijaokwe morotĩ va'e anho oime. Ohexa rire oho jevy gwóga-py. Opondera eterei-ma oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Upe áry-py mokõi inhirũgwe ogwata oho-vy Emaús tetã'i-my. Namombyrýi Jerusalém-gwi upe tetã'i. Dez quilômetro mate oĩ. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tape-rupi ogwata jave onhomongeta Hesu rehegwa nhe'ẽ-rehe. Hetekwe okanhy hagwe rehegwa nhe'ẽ-rehe onhomongeta hese oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Onhomongeta jave ogwahẽ-ma Hesu omoirũ íxupe kwéry ogwata-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ha'e katu ohexa teĩ Hesu-pe. “Ndoikovéi” he'i mo'ã hese-gwi ndoikwaái íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—Mbava'e-rehe penhomongeta peho-vy? Penhemboasyha-rehe para'e penhomongeta peho-vy, he'i Hesu íxupe kwéry, ogwahẽ-ma jepe íxupe. Upéi opyta rei onhemboasy-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ha peteĩ, héry va'e Cléopas he'i íxupe: —Nde tipo, ne anho nipo ndereikwaái ra'e mba'e pa oiko kuri Jerusalém-my? Enterove upe pygwa kwéry oikwaa-ma. Nde tipo upe-py ereiko rei nipo herakwã erehendu e'ỹ reheve ra'e? he'i oporandu Hesu-pe jevy. Ndohexa kwaáiry Hesu-pe Hesu voiha. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—Mba'e tipo oiko upe-py? he'i oporandu rei-vy Hesu. Upéi omombe'u hikwái: —Hesu rehegwa nhe'ẽ ndereikwaái nipo ra'e. Ha'e Nazaré pygwa. Nhandejáry nhe'ẽ-py omombe'u va'etykwe. Ipu'aka va'ekwe. Hexapyrã-rupi hembiapokwe. Nhandejáry nhe'ẽ-py oiko porã va'ekwe. Hemimombe'ukwe, hembiapokwe kente kwéry ojohu porã voi va'ekwe, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","—Upéi mburuvixa kwéry ojuka uka va'ekwe íxupe. Pa'i ruvixa kwéry, nhande ruvixa kwéry ave íxupe ogweraha uka-ma judeu e'ỹ va'e-pe ojuka uka hagwã Hesu-pe. Ha ojuka-ma íxupe. Kurusugwasu-rehe ojejuka-ma va'ekwe, he'i Hesu-pe jevy omombe'u-vy hesegwa. He'i ave: ");
INSERT INTO kgkNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","—Ha ore katu, oro'e mo'ã va'ekwe hese, “Israel remiarirõre judeu kwéry resendeharã” oro'e mo'ã hese. Ohasa-ma mbohapy áry omano hagwe rire, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","—Gwĩ ore ndive oiko meme va'e, kunha kwéry, ore mondýi kuri hesegwa nhe'ẽ omombe'u-vy. Kwarahy osẽ-ma ramo oho ra'e itakwa-py. Hetekwe rexa-vy mo'ã oho kuri. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ndaiporivéi itakwa-py. Ogwahẽ jevy ore ha-py omombe'u kuri: “Nhandejáry rembigwái yváy pygwa ojehexa uka-ma kuri ore-vy” he'i omombe'u-vy ore-vy. “Oikove jevy-ma, he'i ojehexa uka va'e” kunha kwéry he'i ore-vy omombe'u-vy, he'i Hesu-pe inhirũgwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","—Ha gwĩ ore irũ oho ohexa, he'i. —Kwimba'e oho itakwa-py kunha rapykwéri oho. Kunha omombe'u ha-rami voi omombe'u. Ndohexáiry ae Hesu-pe, he'i omombe'u-vy Hesu-pe jevy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Upe-ma ramo Hesu he'i íxupe kwéry: —Peẽ napene arandúi voi ra'e. Ndapeikwaái voi Nhandejáry nhe'ẽ, he'i íxupe kwéry. —Nde are eterei erejerovia tee hagwã inhe'ẽ-py omombe'u va'ety remimombe'ukwe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","—Nhandejáry nhe'ẽ-rupi tekotevẽ oiko upéixa. Tekotevẽ hembiporavo va'e ohasa asy, omano ave kente kwéry oresende hagwã. Tekotevẽ oho yváy-py onhemomba'egwasu hagwã. Nhandejáry remimombe'ukwe ojehu-ma íxupe, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Upéixa ojéhegwa nhe'ẽ omombe'u Hesu íxupe kwéry. Nhandejáry nhe'ẽ ohai uka va'ekwe Moisés amyrĩ-pe, onhe'ẽ-py omombe'u va'ety amyrĩ kwéry-pe ave. Upéa omombe'u jevy Hesu íxupe kwéry. Nhandejáry remimombe'ukwe ojéhegwa nhe'ẽ omombe'u mbe'u ogwata-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Upéi ogwahẽ oho ha-py, tetã'i Emaús-py ogwahẽ. Ha Hesu mombyryve oho-ta mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","—Epyta ore ndive. Ka'aru ete-ma. Oike-tama kwarahy, he'i Hesu-pe hikwái. Aipo ramo oho omoirũ íxupe kwéry. Oike hóga-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ho'u-tama ramo Hesu oipyhy mbojape. Ha gwemi'urã-rehe omboete Nhandejáry-pe. Íxupe omondo onhe'ẽ rire omboja'o ja'o mbojape ome'ẽ íxupe kwéry ho'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Upe jave ae oikwaa-ma hikwái Hesu-pe Hesuha. Oikwaa-ma jave ndohexavéi jevy-ma íxupe. Okanhy-ma Hesu hesa kwéry-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","—Nhane mbovy'agwasu kuri nhanhomongeta ramo tape-rehe. Nhandejáry nhe'ẽ, kwatia-rehe oĩ va'e omombe'u kuri tape-rehe. Oikwaa uka-ma kuri nhande-vy nhane mo'aranduve hagwã, nhane mbopy'agwapy voi kuri, he'i Hesu-rehe ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pya'e opu'ã jevy oho jevy Jerusalém-my. Ogwahẽ-ma ramo ojohu gwĩ onze Hesu remimondokwe. Indive hetave oiko ojogweroaty-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Oikove jevy-ma Nhandejáry Hesu, he'i omombe'u-vy. —Simão ohexa-ma íxupe, he'i hikwái upe mokõi ogwahẽ va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ha upéi katu ou va'e omombe'u ave Hesu rexahare. —Ore ave orohexa íxupe kuri, he'i omombe'u-ma. —Ore moirũ kuri tape-rehe Hesu, he'i omombe'u-ma. —Ore mbo'e jevy kuri tape-rehe. Orokaru-tama ramo ae orohexa kwaa hese, he'i. —Hembiapo-vy voi ojapo-ma Hesu. Omondo onhe'ẽ Nhandejáry-pe omboete-vy. Ha upe rire omboja'o ja'o mbojape. Upe ojapo jave oroikwaa-ma hese, he'i omombe'u-vy Hesu irũgwe-pe. —Oroikwaa-ma Hesu voi ra'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Upéa omombe'u jave Hesu ogwahẽ íxupe kwéry. Ipa'ũ-my ojekwaa-ma: —Pende py'agwapy tapeiko-vy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Onhemondýi voi íxugwi hikwái. Ndaipy'agwapyvéi-ma hikwái. Ikyhyje hexa-vy. —Aragwypóry, he'i mo'ã hese ikyhyje va'e onhemondýi íxugwi. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—Ani penhemondýi rei teĩ xéhegwi, he'i. —Ma'erã-gwi nde py'a-py ereporandu randu xe-rehe, “Oikove para'e Hesu, ndoikovéi para'e” anive upéixa peje teĩ xe-rehe. Ejerovia katu, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","—Pema'ẽ katu xe-rehe, he'i. —Xe po-rehe pema'ẽ, xe py-rehe ave pema'ẽ, he'i. —Epoko katu xe rete-rehe ereikwaa porã hagwã. “Aragwypóry rei-ma oiko” peje mo'ã xe-rehe kuri. Ha'e-ta peẽ-my: Aragwypóry ndaipiréi naikãgwéi ave. Ha xe ndaha'éiry. Xe rete renogwahẽ jevy peẽ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ho'e-vy ohexa uka íxupe kwéry opo, opy ave: —Pehexa katu xe kutu hagwe ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ha ohexa jepe ndogweroviái joty íxupe. Ovy'a eterei-gwi opondera ndera eterei-gwi mba'eve-rehe ndojeroviái hikwái. Aipo ramo Hesu oporandu: —Oime tipo temi'urã, he'i ohexa ukave hagwã gwekoha. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Upéi ome'ẽ íxupe hemi'urã, piky mbixypyre eíra ave ome'ẽ íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ha ha'e kwéry hesa-py ho'u. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ho'u-ma rire he'i jevy: —Oiko-ma xe remimombe'ukwe xe rehegwa amombe'u mbe'u va'ekwe peẽ-my. Aiko ramo va'ekwe pene pa'ũ-my amombe'u mbe'u va'ekwe upe nhe'ẽ peẽ-my. Xe rehegwa nhe'ẽ Nhandejáry ohai uka va'ekwe kwatia-rehe. Ymagware-pe Moisés amyrĩ-pe ohai uka va'ekwe, onhe'ẽ-py omombe'u va'ety amyrĩ kwéry-pe ave ohai uka va'ekwe. Davi amyrĩ-pe ave ohai uka va'ekwe porahéi kwéry héry va'e Salmo. Xe rehegwa nhe'ẽ meme ohai uka va'ekwe íxupe kwéry. Omotenonde xe rehegwa nhe'ẽ gwemimombe'ukwe ohai hagwã. Ha tekotevẽ oikopa Nhandejáry remimombe'ukwe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Upe-ma ramo oikwaa uka íxupe kwéry Nhandejáry nhe'ẽ kwatia-rehe omoĩ uka va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","He'i íxupe kwéry: —Yma va'ekwe Cristo rekorã omoĩ va'ekwe kwatia-rehe Nhandejáry nhe'e. “Xe rembiporavo va'e pene remiha'arõ ojerereko asy va'erã. Omano tee rire oikove jevy-ta. Mbohapy áry-py oikove jevy-ta. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Héry-py omombe'u mbe'u va'erã: Perova katu pende rekoha Nhandejáry omboyke hagwã pendéhegwi pene rembiapo vaikwe. Gwembiporavo réry-py omopotĩ va'erã pende py'a ky'akwe, he'i va'erã omombe'u-vy opa rupigwa ohendu hagwã Cristo rehegwa nhe'ẽ. Jerusalém mygwa-pe omombe'u ranhe-ta. Upe rire oho omombe'u entéro tetã tetã mygwa kwéry-pe.” Upéixa omombe'u Nhandejáry kwatia nhe'ẽ, he'i Hesu onhemombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Upéa pehendu va'ekwe, pemoherakwã pemombe'u mbe'u opa-rupi xe aikove jevymaha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","—Xe Ru nhe'ẽ amombe'u va'ekwe peẽ-my. “Ambou-ta Nhe'ẽ Marangatu tee va'e” he'i xe-vy va'ekwe xe Ru. Upe xe Ru remimbou ambogwejy-ta. Upéa-rehe peha'arõ Jerusalém tetã-my. Pene mbopu'aka tee rire-ma ae eresẽ upe-gwi, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Upe rire ogweraha íxupe kwéry Betânia ypy-py. Ohupi opo omondo onhe'ẽ Nhandejáry-pe. —Enhangareko porã xe irũgwe-rehe, he'i ohovasa hagwã íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Omondo jave onhe'ẽ Nhandejáry-pe ojei oirũgwe-gwi ojereraha yváy-py. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aipo ramo inhirũgwe omondo ave onhe'ẽ Nhandejáry-pe omboete-vy. —Ore Ru, nde tuvixa voi. Nde pu'aka tee va'e voi katu, he'i omboete-vy. Upe rire oho jevy Jerusalém tetã-my. Ovy'a eterei hikwái oje'ói-vy. ");
INSERT INTO kgkNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ha opyta meme Nhandejáry róga kakwaa-py. Omboete ete Nhandejáry-pe oiko-vy hikwái upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ko'yvy nhepyrũ e'ỹ vyteri ramo, oiko-ma va'ekwe Nhandejáry reko kwaa ukaha. Upe heko kwaa ukaha Nhandejáry ndive oiko. Upe heko kwaa ukaha Nhandejáry va'e ave voi ko. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ko'yvy nhepyrũ e'ỹ vyteri ramo, ha'e oiko va'ekwe Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Entéro mba'e rereko kwaaharã voi ha'e oiko va'ekwe. Ojapo e'ỹ ramo mba'eve ndoikói. Ha'e anho mba'e apoharã oiko. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ha'e nhane moingoharã voi. Nhane moingo rire, nhande py'a-py nhande resape va'e-rami nhane mo'arandu porã va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pytũ-my oiko vérami va'e-pe ohesape. Ha ndaipóri imbogweharã. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ha upéi katu ojekwaa va'ekwe kwimba'e héry va'e João. Ha'e Nhandejáry remimoĩ omombe'u hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ojekwaa ou-vy João anhetegwa mombe'uharã, hembiexagwe hemiendukwe mombe'uharã ave. He'i João: “Nhande resapeha va'e ko upe va'e nhane mo'arandu-vy” he'i ou-vy Nhandejáry reko kwaa ukaha-rehe. Ou omombe'u ogwerovia uka porã porã hagwã enterove va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ha João katu ndaha'éi nhande resape teeharã. Nhande resapeharã mombe'uharã ae ojekwaa ou-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ha upe Nhandejáry reko kwaa ukaha katu nhande resape teeharã va'e voi. Upe ramo ogwahẽ-ma va'ekwe nhande-vy ou-vy ko yvy ári upe heko kwaa ukaha. Peteĩ teĩ nhande resapepa hagwã nhane mo'arandu-vy ou va'ekwe. Ha'e nhande resape teeharã va'e voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ha'e oiko va'ekwe nhane pa'ũ-rupi. Nhande kwéry-pe nhane moingo ramo jepe va'ekwe, ndajaikwaáiry joty va'ekwe voi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ogwahẽ ou-vy ramo jepe va'ekwe gwe'ýi kwéry retã-my, ndogwerovy'áiry joty íxupe. Ombojevy ae íxupe he'ýi judeu kwéry va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ha inhe'ẽ renduha-pe gwive he'i: “Eiko katu xe nhe'ẽ-py Nhandejáry ra'y ramo” he'i peteĩ teĩ-me. Ojerovia héry-rehe va'e-pe gwive: “Eiko katu Nhandejáry ra'y ramo” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jaiko ramo nhande sy-gwi, ndajaikói vyteri Nhandejáry ra'y ramo. Jaiko ramo nhande ru gwa'yryrã oipota-gwi, ndajaikói vyteri Nhandejáry ra'y ramo. Ojereropyahu nhande rekoha rire ae, oiko Nhande Ru tee ramo Nhandejáry. Nhandejáry ra'y ramo jaiko. Teko rei remimbota-rupi ndajaikói Nhandejáry ra'y ramo. Nhandejáry remimbota-rupi ae jaiko Nhandejáry ra'y ramo. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ha Nhandejáry reko kwaa ukaha nhande rete poru-ma va'ekwe. Nhande-rami oiko-ma va'ekwe. Nhane pa'ũ-rupima oiko. Oroma'ẽ ma'ẽ va'ekwe hese. Ore resa-rupi oiko va'e. Hekoha porã tee va'e ra'e. Orohexa porã ramo: “Ha'eixagwa ndaipóri” oro'e hese. “Nhande Ru ra'y tee ha'e anho oiko va'e rekoha-rami voi upéa” oro'e orohexa-vy. Ha'e nhande rereko porã porã meme va'ety nhande rexakwaa rei-vy. Ha'e anhetegwa meme va'e mombe'uha ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ha João katu omombe'u va'ekwe hesegwa. He'i: —Upe va'e xe remimombe'ukwe kuri, he'i. —Ha'e kuri hese amombe'u-vy, “Ha'e ipyahuve ramo jepe xéhegwi, xe renondegwa joty” ha'e hese. “Upe va'e onhemboeteve va'e xéhegwi, hi'aranduve va'e xéhegwi. Xe rekove e'ỹ ramo vyteri, ha'e oiko va'ekwe yváy-py” ha'e kuri hese amombe'u-vy, he'i va'ekwe omombe'u-vy onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ha ha'e katu ojehegwigwa-py nhande rovasapa porã rei kuri. Iporãve rãve va'e-py nhande rexakwaa rei oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yma va'ekwe omombe'u nhande-vy va'ekwe tekoharã myamyrĩ Moisés omombe'u va'ekwe. Nhandejáry nhe'ẽ-py omombe'u nhane rekoharã. Ha upéi katu Hesu Cristo nhande rovasa kuri nhande rexakwaa rei-vy. Anhetegwa tee va'e omombe'u kuri nhande-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ha Nhandejáry katu nhane rembiexa e'ỹ va'e voi. Ha ta'ýry katu peteĩmi oiko va'e, Nhandejáry rembiayhu tee va'e voi, oikwaa uka nhande-vy Nhandejáry rehegwa. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ha judeu ruvixa kwéry katu ombou va'ekwe João renda-py Jerusalém pygwa ombou. Hemimbou pa'i levita héry va'e ave. Ogwahẽ ramo ha'e-py, oporandu João-pe: —Mbava'e tipo ere ndéjehe? he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ha João katu omombe'upa Hesu Cristo rehegwa nhe'ẽ. “Mbava'e tipo ere ndéjehe?” he'i ramo íxupe, nokirirĩry omombe'upa voi: —Xe ndaha'éi Cristo. Xe katu nhane resende ou-vy va'erã e'ỹ va'e voi. Pene remiha'arõ e'ỹ xe, he'i ójehe íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Upe-ma ramo Jerusalém-gwi ou va'ekwe oporandu jevy íxupe: —Aipo ramo, mbava'e tipo eremombe'u ndejehegwigwa? he'i íxupe. —Nde Nhandejáry nhe'ẽ-py omombe'u va'ety héry va'e Elias ymagware remimoherakwãkwe pa nde ra'e? he'i oporandu íxupe. Ha João katu he'i: —Upe va'e e'ỹ ave xe, he'i íxupe kwéry. Upéi oporandu jevy íxupe hikwái: —Nde Nhandejáry nhe'ẽ-py omombe'u va'ety nhane remiha'arõ va'e ymagware remimoherakwãkwe pa nde ra'e, he'i íxupe. —Ndaha'éiry. Upéa e'ỹ ave xe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—Aipo ramo, mbava'e tipo eremombe'u ndejehegwigwa? he'i íxupe. —Emombe'u katu ore-vy orogweraha hagwã ne nhe'ẽgwe ore mbouhare-pe, he'i. —Mbava'e tipo ere ndéjehe? he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Upéixa he'i-ma ramo, ha'e oiporu yma gware nhe'ẽ. Nhandejáry nhe'ẽ-py omombe'u va'ety héry va'e Isaías nhe'ẽ oiporu oikwaa uka hagwã mba'éixa hembiapo: —Xe ko tekwaty e'ỹ-my gwĩ ou va'e-pe anhe'ẽ hatã va'e: “Pemoatyrõ katu Nhandejáry raperã” ha'e va'e voi kente kwéry-pe. Amombe'u íxupe tape ramigwarã-rami ambojehesa rerova uka hagwã hese, he'i ójehe oporandu va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Upe ramo he'i íxupe hikwái. Upéa onhembou va'ekwe fariseu kwéry va'e he'i: ");
INSERT INTO kgkNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Aipo ramo mbava'e-gwi po ereporomongarai ereiko-vy? he'i íxupe. —Cristo ou va'erã e'ỹ nde. Elias héry va'e e'ỹ ave nde. Nhandejáry nhe'ẽ-py omombe'u va'ety, nhane remiha'arõ va'e e'ỹ ave nde. Upéa-gwi ma'erã po ereporomongarai ereiko-vy? he'i oporandu íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Upe ramo he'i: —Xe, he'i —y-py mante aporomongarai va'e. Ha pene pa'ũ-my katu oĩ peikwaa e'ỹ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ha'e ipyahuve ramo jepe xéhegwi, xe rekove e'ỹ ramo, oiko va'ekwe yváy-py, he'i. —Amboete eterei íxupe. Upéa-gwi, xe mirĩve-gwi, xe atĩ-gwi ave, ni hembigwái ramo jepe ndikatúi aiko, he'i íxupe kwéry oporandu va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Upéixa oporandu randu ojóupe Betânia tetã-my, Jordão ysyry rovái. João oporomongarai ha-py onhomongeta hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Iko'ẽmba-ma ramo ohexa Hesu-pe ogwahẽ ou-vy ramo henda-py. Ohexa ramo, he'i íxupe: —Upe va'e ko Nhandejáry gwigwa ovexa ra'y ijukapyrã ramigwa ou upéa. Nhane rembiapo vaikwe omboyke va'erã nhandéhegwi, he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","—Upe va'e xe remimombe'u kuri, “Xe rapykwerigwa jepe ha'e. Xe aiko e'ỹ ramo, oiko-ma voi ha'e. Upe va'e onhemboeteve va'e xéhegwi. Xe aiko e'ỹ ramo, oiko-ma voi va'ekwe ha'e” ha'e kuri hese amombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xejéhegwi rei ramo ndahexa kwaái hese hekoha. Ha Nhandejáry nhe'ẽ-py xe agwahẽ va'ekwe aju-vy aporomongarai hagwã y-py. Ojehexa uka hagwã myamyrĩ Israel remiarirõ kwéry-pe upe nhane remiha'arõ va'e aporomongarai aiko-vy, he'i Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Upéi João omombe'u gwembiexagwe, gwemiendukwe omombe'u ave: —Upe va'e, nhane remiha'arõ va'e ahexa ramo jepe, xejéhegwi rei ramo ndahexa kwaái hese hekoha. Nhandejáry oikwaa uka ramo xe-vy ae, aikwaa-ma hekoha. He'i va'ekwe xe-vy Nhandejáry: “Eporomongarai katu y-py” he'i. Upéi he'i jevy: “Erehexa-ta Nhe'ẽ Marangatu tee va'e ogwejy ou-vy ramo pykasu-rami. Ogwapy hese oĩ-vy ramo erehexa-ta ave. Upe va'e hese ogwejy va'erã voi omoingo va'erã pende py'a-py Nhe'ẽ Marangatu tee va'e-pe” he'i kuri xe-vy Nhandejáry. Ha upe rire katu ahexa Nhe'ẽ Marangatu tee va'e-pe pykasu-rami ogwejy ou-vy ramo. Yváy-gwi ogwejy ogwapy hese. Upe va'e ahexa voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ahexapa-ma voi. Upéa-gwi amombe'u peẽ-my ahexa va'ekwe. Upe va'e katu Nhandejáry ra'y voi, he'i João omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Iko'ẽ jevy-ma ramo, João onhembo'y jevy oĩ-vy mokõi hemimbo'e ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ha Hesu katu ohasa oho-vy. Ohexa ramo Hesu-pe: —Upe va'e ko Nhandejáry gwigwa ovexa ra'y ijukapyrã ramigwa upéa, he'i Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ha mokõi hemimbo'e katu ohendu ramo inhe'ẽ, oho Hesu ");
INSERT INTO kgkNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ha Hesu ojeapa hese ohexa ou ramo gwapykwéri: —Mbava'e tipo ereipota? he'i mokõive va'e-pe. —Kipy tipo ereiko va'e nde, porombo'eháry? he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Peju katu pehexa, he'i íxupe. Upe-ma ramo oho ohexa oiko ha-py. Ka'arugwasu-ma. Upéa-gwi opyta Hesu ndive. Ka'aru ete peve indive opyta. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Upe mokõi va'e ohendu rire João nhe'ẽ oho ra'e Hesu rapykwéri. Peteĩ héry va'e André. Ha'e Simão Pedro ryvy va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pya'e oho gwyke'ýry reka-vy. Otopa rire he'i íxupe: —Orotopa-ma Messias héry va'e, he'i íxupe. Cristo nhane remiha'arõ va'e-pe he'i Messias. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ogweru gwyke'ýry-pe Hesu renda-py. Ogwahẽ rire, ohexa katu katu íxupe Hesu: —Nde katu João ra'y. Nde réry Simão. Ha ahekoviarõ-ta nde réry. Erenhehenói-ta Cefas-py, he'i tyke'ýry-pe. Ha inhe'ẽ ambue-py ohenói Pedro-pe. Pedro he'ise ita. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Iko'ẽ jevy-ma ramo: —Jaha katu Galiléia yvy-koty, he'i Hesu. Upéi otopa Filipe-pe: —Eju, xe moirũ katu, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ha Filipe katu Betsaida tetã mygwa. André tyke'ýry ndive upe tetã mygwa ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ha upéi katu Filipe oho otopa Natanael-pe. Ha omombe'u íxupe: —Orotopa-ma voi José ra'y Hesu-pe, Nazaré pygwa va'e. Upe va'e-rehe yma ohai va'ekwe kwatia-rehe Moisés amyrĩ, nhane rekorã omombe'u jave nhande kwéry-pe. Ohai va'ekwe hese myamyrĩ Nhandejáry nhe'ẽ-py omombe'u va'ety kwéry ave, he'i Natanael-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—“Nazaré pygwa” ere kuri xe-vy, he'i. —Upéa tetã-gwi xe ndaikwaái osẽ porã va'e, he'i Filipe-pe imombe'u-vy. —Nde katu eju terehexa, he'i Natanael-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Upéi Hesu ohexa Natanael-pe ogwahẽ ou-vy ramo henda-py: —Upéa ko Israel re'ýi tee va'e. Nhane mbotavy e'ỹ va'e voi, he'i hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ohendu ramo inhe'ẽ, he'i: —Mba'éixa po xe kwaa? he'i Hesu-pe. —Eregwapy ereĩ-vy ramo vyteri figo máta gwy-py, orohexa-ma voi. Orohexa-ma voi kuri eregwapy ramo ha upe rire katu ne renói-ma Filipe, he'i Natanael-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Nde katu Nhandejáry ra'y tee voi, porombo'eháry. Myamyrĩ Israel remiarirõ ruvixagwasu ave nde, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Upe-ma ramo Hesu he'i íxupe: —Ha'e-ma kuri nde-vy, “Eregwapy ereĩ-vy ramo figo máta gwy-py orohexa-ma” ha'e nde-vy. Upe va'e-gwi mante xe rerovia-ma tipo? he'i. —Ha ko'ánga katu tuvixa mba'e va'e erehexa va'erã iporãve va'e ave, he'i Natanael-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Upéi he'i upe-py oĩ va'e-pe gwive: —Anhetegwa va'e amombe'u-ta peẽ-my. Pehexa va'erã ojekwaa ramo yváy-py, Nhandejáry rembigwái ojeupi ramo xéhegwi. Ogwejy jevy ou-vy ramo ave xe renda-py pehexa va'erã. Pehexa ramo, pehexa kwaa va'erã xe-rehe. “Ha'e ko Nhande Ryke'y tee va'e voi nipo ra'e” peje va'erã xe-rehe, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Mokõi áry rire omenda-ta Hesu re'ýi omenda va'erã. Caná tetã-my omenda-tama. Upe Caná Galiléia yvy pygwa. Upe-py omenda ha-py Hesu sy oĩ ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Onhehenói Hesu oho hagwã gwe'ýi menda hagwã-py: —Eju katu, he'i. —Ne remimbo'e kwéry ndive eju katu, he'i íxupe. Upe-ma ramo ohopa hikwái omenda va'erã ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Upéi katu omendaha óra ndoikovéi-ma uva rykwere. Ho'upa-ma ra'e hikwái. Opa ramo, oho Hesu ha-py isy: —Ndogwerekovéi-ma uva rykwere, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Ma'erã tipo eremombe'u xe-vy xe rembiaporã, he'i osy-pe. —Hi'óra-pyma voi xe xe rembiapo-ma va'erã, he'i osy-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Upéi he'i hembigwái kwéry-pe isy: —Peẽ-my he'i va'erã gwive pejapo katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Upe-py oĩ seis y ryrugwasu. Ita gwigwa ijapopyre y ryru. Ojoha'e-rami meme. Hynyhẽ ramo, peteĩ teĩ ogwereko oitenta litro para'e, cem litro para'e ogwereko. Upe y ryru-gwi judeu kwéry reko-rupi ogwenohẽ va'e y onhemopotĩ hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ha upéi katu Hesu he'i íxupe kwéry: —Pemohynyhẽ katu upe y ryru y-gwi, he'i hembigwái kwéry-pe. Omohynyhẽmba-ma. Ijuru gwive omoĩ omohynyhẽ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Upéi he'i íxupe kwéry: —Ãy pejara mixĩ mixĩ peraha temi'urã rerojaha-pe otantea hagwã, he'i. Upe-ma ramo ojara ogweraha. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Upéi pe huvixa otantea hembierukwe. Y omondo ra'e uva rykwere ramo. Hesu nhe'ẽ-py y ojere uva rykwere ramo ra'e. Otantea ramo ohendu: —Uva rykwere tee va'e, he'i ho'u-vy. —Kigwigwa po ojara ra'e? he'i. Ndoikwaái. Ha ijarahare ae oikwaa voi. Upéa-gwi pe huvixa ohenói ou hagwã omenda va'erã-pe. Osapukái ou hagwã: —Eju katu a-py, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ogwahẽ ramo, he'i íxupe: —Nhande kwéry uva rykwere tenonde nhame'ẽ va'e iporãve. Upe rire katu heta ho'u rire nhane remienoigwe, nhame'ẽ jevy va'e naiporãvéi-ma, he'i. —Ha nde katu nderejapo kwaáiry upéixa. Iporãve va'e eremoĩ ngatu-ma. Ko'ánga ete peve eremoĩ ngatu, he'i omenda va'erã-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Upéixa onhepyrũ Hesu heroviapyrã-rupi hembiapo porã. Caná, Galiléia tetã-my hembiapo porã. Ohexa uka gwemimbo'e kwéry-pe gwekoha porãha. Ohexa kwaa ramo hese hekoha porã, ojerovia-ma hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Upe rire oho Hesu Cafarnaum tetã-my. Omoirũ íxupe isy, tyvy kwéry hemimbo'e kwéry ave. Upe-py ndahi'aréiry opyta hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ha upéi katu hi'agwĩ-ma ogwahẽ hagwã aretegwasu áry héry va'e páscoa. Judeu kwéry remimboete upe arete. Upe-ma ramo Hesu oho Jerusalém tetã-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nhandejáry róga kakwaa-py oike ramo, otopa heta oma'e vende va'e. Upe-py oĩ vaka vendeha ovexa vendeha pykasu vendeha ave. Upe-py ogwapy oĩ-vy plata kambiaha. Okambiaseha-pe okambia. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Upe-ma ramo Hesu omosã ombopi hagwã. Omosẽmba Nhandejáry róga-gwi ovexa reheve. Vaka reheve omosẽmba íxupe kwéry imondo-vy. Ombohekovia va'e apyka ombovayva. Ombojerepa. Iplata oitypa yvy-py. Omosarambipa iplata. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ha pykasu járy-pe katu he'i: —Penohẽmba katu pykasu peraha-vy ko'a-gwi, he'i ijáry-pe. —Ani pereko teĩ xe Ru róga gwy-py pevende va'erã, imondopa hagwã he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Upe va'e ohexa ramo, imandu'a hemimbo'e kwéry Nhandejáry kwatia nhe'ẽ-rehe oĩ va'e-rehe: “Xe rakate'ỹ eterei nde róga-rehe. Upéa-gwi xe juka va'erã” he'i Nhandejáry kwatia nhe'ẽ Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ha judeu ruvixa kwéry katu ogwahẽ ou-vy iha-py: —Kiva'e nhe'ẽ-py erejapo-ma upéa? he'i íxupe. —Ejapo katu tuvixa mba'e oroikwaa hagwã Nhandejáry nhe'ẽ-py para'e erejapo hagwe, ne nhe'ẽ-py para'e, he'i íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—Néi, ajapo-ta. Pemboai ramo ko óga, mbohapy áry rire amopu'ã jevy arã, he'i judeu ruvixa kwéry-pe. Ha ndoikwaáiry inhe'ẽ hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—Imopu'ã hagwe Nhandejáry róga kakwaa quarenta e seis ro'y-ma ojapo, he'i íxupe. —Ma'erã ere kuri ore-vy, “Amopu'ã jevy-ta mbohapy áry rire” he'i oporandu-vy íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ha, “ko óga” he'i ramo, nde'íry óga tee-rehe. Gwete-rehe ae he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Upéa ohendu-ma ramo, ndoikwaáiry Hesu nhe'ẽ hemimbo'e kwéry. Ha omano rire onhemoingove jevy ramo katu, imandu'a hemimbo'e kwéry inhe'ẽgwe-rehe. Imandu'a ramo, ogwerovia-ma Nhandejáry kwatia nhe'ẽ. Hesu nhe'ẽgwe ogwerovia-ma ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Oiko jave aretegwasu héry va'e páscoa, oĩ Hesu Jerusalém-my. Heta hembiapo porã voi heroviapyrã-rupi. Upe-ma ramo Hesu rembiapo ohexa-ma ramo, heta oĩ ojerovia va'e hese: —Jajerovia-ma hese. Hesu réry-rehe jajerovia-ma, he'i hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ha Hesu katu ndojeroviái vyteri hese kwéry. Ndojerovia teéi vyteri ojeheha-gwi oikwaa voi. Upéa-gwi ndojeroviái vyteri hese kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nhande kwéry-pe peteĩ teĩ nhande kwaa porã-ma voi. Avave omombe'u e'ỹ reheve íxupe, nhande rekoha ohexa kwaapa-ma voi nhande-rehe. Oikwaapa voi nhande py'a-py oĩ va'e. Nhande py'apóry oikwaapa voi. Ndaipóri íxugwi okanhy va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ha upéi katu ogwahẽ ou-vy Hesu ha-py mburuvixa héry va'e Nicodemos. Pyhare-ma ou. Upe va'e fariseu kwéry va'e. Judeu kwéry ruvixa ave. Ogwahẽ rire he'i Hesu-pe: —Avave onhe'ẽ-py rei nahembiapo porãiry ne rembiapoha-rami, porombo'eháry. Nhandejáry nhe'ẽ-py ae hembiapo porã arã ne rembiapo porãha-rami. Upéa-gwi ne mbou-ma nipo ra'e Nhandejáry ore mbo'e hagwã, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Upe ramo Hesu he'i íxupe: —Ejeapysaka porã katu. Anhetegwa va'e amombe'u-ta nde-vy. Ndikatúi avave ojohu Nhandejáry-pe gwuvixarã. Onhembopyahu jevy ramo ae oikwaa va'erã, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ha mburuvixa he'i íxupe: —Mba'éixa po nhanhembopyahu-ta nhande tuja ramo? he'i. —Ndikatuvéi-ma jaike nhande sy rye py-py jaiko jevy hagwã, he'i íxupe mburuvixa. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","He'i jevy mburuvixa-pe: —Ejeapysaka porã katu. Anhetegwa va'e amombe'u-ta nde-vy, he'i. —Ojéhegwi rei avave nomoirũ mo'ãi Nhandejáry-pe gwuvixarã. Onhemopotĩ rire, onhembopyahu jevy-ma rire Nhe'ẽ Marangatu tee va'e oiko-magwi ipy'a-py ae, ojohu va'erã íxupe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","—Jaiko ramo nhande sy-gwi jaiko rei. Ha nhanhembopyahu jevy ramo katu, Nhe'ẽ Marangatu tee va'e-rupi jaiko va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ha'e kuri nde-vy, “Nhandejáry oipota erenhembopyahu jevy” ha'e nde-vy. Ma'erã po erepondera xe nhe'ẽ-rehe? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","—Oho yvytu. Ohose ha-koty rei oho. Nhahendu ou ramo hyapu va'e. Nhahendu ramo jepe, ndajaikwaái joty ki-gwi po ou. Ki-koty po iho hagwã ndajaikwaáiry ave. Upéixa ete voi Nhe'ẽ Marangatu tee va'e-rupi nhanhembopyahu jevy va'e gwive. Yvytu-rami rei ou Nhe'ẽ Marangatu tee va'e. Ndajaikwaái ki-gwi po ou. Ki-koty po iho hagwã ndajaikwaái ave, he'i upe mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Mba'éixa po oiko upéa? he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—Nde ko Israel remiarirõre judeu kwéry mbo'eháry voi. Imbo'eháry jepe, ndereikwaái joty voi xe nhe'ẽ. Ne arandu teĩ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","—Amombe'u-ta nde-vy anhetegwa va'e. Oroikwaa-gwi oronhe'ẽ va'e. Oromombe'u va'e ore rembiexagwe. Ha ndaperoviái voi joty ore nhe'ẽ, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","—Ndaxe reroviáiry-ma kuri amombe'u ramo peẽ-my yvy arigwa rehegwa. Aipo ramo, mba'éixa po xe rerovia-ta amombe'u ramo peẽ-my yváy pygwa rehegwa? ");
INSERT INTO kgkNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Upéa rehegwa avave ndoikwaái yváy-py ndojeupíry-gwi oho-vy. Ha xe ae katu Nhande Ryke'y tee va'e aiko upe-py. Upe-gwi aju kuri. Upéa-gwi xe aikwaa voi upéa rehegwa, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","—Amombe'u-ta nde-vy myamyrĩ Moisés rehegwa nhe'ẽ. Yma va'ekwe Moisés ohupi va'ekwe mbói ra'anga imoĩ-vy yvate yvyra-rehe. Tekwaty e'ỹ-my oiko jave ohupi va'ekwe. Upéixa voi Nhandejáry nhe'ẽ-py xe rupi-ta. Xe Nhande Ryke'y tee va'e-pe xe rupi-ta yvyra-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Xe moĩ-ta kurusugwasu-rehe entéro ojerovia va'erã gwive xe-rehe oiko porã meme ete hagwã Nhandejáry ndive. Opa e'ỹ va'erã voi, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Nhande kwéry va'e-pe nhande rayhu tee rei-ma va'ekwe Nhandejáry. Upéa-gwi nhande rayhu-gwi, ombou ime'ẽ-vy va'ekwe nhande-vy gwa'ýry ha'e anho oiko va'e. Upéixa ramo jajerovia va'e gwive hese, nanhane mondói va'erã mombyry ojéhegwi. Jaiko meme ete va'erã ae Nhandejáry ndive. Japave e'ỹ reheve jaikove joty va'erã voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nhande kwéry va'e-pe ombou va'ekwe gwa'ýry. Nomboúi íxupe nhane mbohasa asy hagwã. “Pene rembiapo vai ko” nde'íry nhande-vy ou-vy. Ombou rei ae va'ekwe nhande kwéry va'e-pe. Nhane resendeharã rei ombou va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","—Upéixa ramo jajerovia va'e gwive hese nhasẽ rei-ma nhane monhe'ẽ e'ỹ reheve. Ha jajerovia e'ỹ va'e gwive hese katu nhane mbohasa asy hagwã-ma voi. Ndajajeroviái-gwi Nhandejáry ra'y réry anho-rehe, nhane mbohasa asy va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ogwahẽ-ma va'ekwe ou-vy ko yvy ári nhande py'apy-py nhande resapeharã. Ha hembiapo vai va'e gwive katu ndojohu porãi nhande resapeha. Pytũ ae ha'e kwéry ojohu porã va'ekwe. Upéa-gwi Nhandejáry, “Ambohasa asy va'erã” he'i imandu'a hese kwéry ombohasa asy hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ha hembiapo vai va'e gwive ndaija'éi nhande resape va'e-rehe. Ndoipotái ojekwaa hembiapo vaikwe. Upéa-gwi ndohói nhande resape va'e ha-py. Hembiapo vaikwe ojekwaa hagwã-my ndohoséiry voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ha anhetegwa ojapo va'e gwive hembiapo ojekwaa porã hagwã-my oho va'e. Upe-py oho entéro ohexa porã hagwã hembiapo porãkwe. “Nhandejáry reko-rupi hembiapo porã” oipota he'i ójehe, he'i pe mburuvixa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Onhomongeta rire mburuvixa ndive, oho oje'ói-vy Hesu hemimbo'e kwéry ndive Judéia yvy-py. Upe-py hendive kwéry opyta oporomongarai uka oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Upe jave João oporomongarai oiko-vy ave. Enom tetã-my Salim ypy-py oporomongarai. Upe-py heta oĩ y. Heta oĩ va'e henda-py oje'ói. Onhemongarai uka-vy oje'ói. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Oĩ e'ỹ ngatu preso omongarai joty entéro va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ha upéi katu onhonhe'ẽ mbojevy jevy-ma João remimbo'e kwéry judeu kwéry va'e ndive: —Nhanhemongarai hagwã a-rami tekoha, he'i. —Ndaha'éi. Ndaikoséi nde reko-rupi. A-rami ae aikose, he'i outro. Nohenduséi onhonhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Upe-ma ramo oje'oipa João renda-py: —Naiporãi voi, porombo'eháry, he'i João-pe hikwái. —Oĩ va'ekwe kwimba'e ne ndive Jordão ysyry rovái. Hesegwa eremombe'u va'ekwe. Ha ko'ánga katu ogwahẽ ko'a-py upe va'e. Oporomongarai ko oiko-vy ko'a-py ave. Enterove ete oho henda-py, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ha João he'i: —Nhande-vy Nhandejáry remime'ẽgwe mante jareko, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","—Ha'e kuri hese: “Xe ko ndaha'éi Cristo héry va'e. Pene remira'arõ e'ỹ xe. Cristo renonde-rupi mante xe mbou-ma” ha'e hese. Pehendu-ma voi xe nhe'ẽ anhemombe'u ramo, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Upéi omombe'u íxupe kwéry peteĩ nhe'ẽ. —Kunha-rehe nhamenda-tama ramo, nhane rembirekorã voi pe kunha. Ndaha'éi nhane irũ rembirekorã. Ha nhane irũ katu, nomendái ramo jepe, ovy'a joty. Nhande ayvu ohendu ramo, ogwerohory joty nhande ayvu. Upéixa ete xe avy'a Hesu-rehe. Heta ojehesa rerova kuri hese oiko-vy. Ha xe irũ katu ndahetái. Ndahetái ramo jepe, xe avy'a joty Hesu-rehe. Xe avy'a eterei ko'ánga, he'i ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","—Nhandejáry nhe'ẽ-py ha'e onhembotuvixave xave oho-vy va'erã. Ha xe katu aiko kirirĩve rĩve aiko-vy va'erã, he'i ójehe João. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yváy-gwi ogwejy va'ekwe entéro va'e-gwi heko porãve va'e. Ha yvy pygwa katu oiko rei yvy ári ojehegwigwa mante omombe'u. Ha yváy gwigwa ou va'ekwe katu enterove va'e-gwi hekoha porãve va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ha'e omombe'u gwembiexagwe ha gwemiendukwe mate. Ha avave joty ndogweroviái joty íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Inhe'ẽ ogwerovia va'e ae: “Nhandejáry ijapu e'ỹ va'e. Anhetegwa voíte omombe'u va'e ae” he'i ete hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ha'e ko Nhandejáry remimbou va'e. Nhandejáry nhe'ẽ tee omombe'u va'e voi. Ha Nhandejáry katu nahakate'ỹiry ime'ẽ-vy íxupe Nhe'ẽ Marangatu tee va'e. Ome'ẽ me'ẽ rei íxupe. Upéa-gwi ha'e Nhandejáry nhe'ẽ tee omombe'u va'e voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ha Nhandejáry katu Nhande Ru va'e ohayhu va'e gwa'ýry. Enterove va'e járy-ma voi oiko ta'ýry. ");
INSERT INTO kgkNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jajerovia ramo Nhandejáry ra'y-rehe, jaiko-ma opa e'ỹ reheve va'erã Nhandejáry ndive. Ha nhahendu e'ỹ ramo katu inhe'ẽ, ndajaiko mo'ãvéi-ma va'erã Nhandejáry ndive. Ha'e nhande rereko asy va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Upe ramo omombe'u fariseu kwéry-pe: —Are-ma omoirũ heta João-pe. Ha ko'ánga katu hetave Hesu-rehe ojehesa rerovapa. Hesu-pe háma omoirũ heta. Omongarai-ma íxupe kwéry Hesu gwemimbo'erã, he'i omombe'u-vy. Upéa oikwaa-ma ramo, osẽ oho-vy Hesu Judéia yvy-gwi. Oho jevy Galiléia yvy-koty. Ha Hesu katu oporomongarai e'ỹ va'e. Hemimbo'e kwéry mante ae oporomongarai va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ha upéi katu ohasa oho-vy Samaria yvy-rupi. Upe-rupi ndoho reíry. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Upéixa ramo ogwahẽ oho-vy Samaria pygwa tetã héry va'e Sicar-py. Ha Sicar katu hi'agwĩ oĩ myamyrĩ Jacó yvykwe-gwi pe ome'ẽ gwa'ýry José-pe va'ekwe-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Upe-py oĩ Jacó ygwa. Ha upéi katu Hesu ogwahẽ rire ogwapy ygwa ypy-py. Ogwata puku ou-vy rire ikane'o. Upéa-gwi okane'o ramo ogwapy otongea-vy. Larose-ma ramo ogwapy oĩ-vy onhemokane'õgwa hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Upe-ma ramo ogwahẽ ou-vy kunha Samaria pygwa va'e. Ogwenohẽ hagwã y ou. He'i íxupe Hesu: —Hay'u-ta, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ha ndaipóri inhirũ. Hemimbo'e kwéry oje'ói kuri tetã-my oho ojogwa hagwã gwemi'urã kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ha upéi he'i íxupe pe kunha: —Nde ko judeu kwéry va'e. Xe katu Samaria pygwa va'e. Pende a'e'ỹha ore, he'i. —Aipo ramo ma'erã po erejerure xe-vy y-rehe. Judeu kwéry katu ndore rerohorýi va'e. Ndoiporúi ore mba'e, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Upéi Hesu he'i pe kunha-pe: —Ndereikwaái voi Nhandejáry remime'ẽrã. “Hay'u-ta” ha'e ramo nde-vy, ndaxe kwaái ave. Ha xe kwaa rire ra'e, erejerure arã xe-vy ra'e. Ame'ẽ arã nde-vy ra'e y. Yvu ramigwa va'e ame'ẽ arã nde-vy nde rekoverã, he'i kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Upéi he'i íxupe pe kunha: —Hypy voi ygwa, porombo'eháry, he'i. —Ndererekói henohẽha. Mamo-gwi nipo erenohẽ-ta y yvu ramigwa va'e, he'i íxupe kunha. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","—Ore ramói ypykwe Jacó ome'ẽ va'ekwe ore-vy upéa ygwa. Hoy'u ave íxugwi. Ta'ýry hoy'u ave íxugwi va'ekwe. Omboy'u ave íxugwi va'ekwe gwymba, he'i. —Ha nde nerenhembotuvixa mba'éi tipo íxupe? he'i íxupe kunha. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Upéi he'i kunha-pe: —Ko va'e y ja'u ramo, jay'u jevy jevy va'erã, nhande y'uhéi jevy va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ha xe remime'ẽrã ere'u ramo, nande y'uhéi mo'ãvéi-ma va'erã, he'i. —Xe mba'e y ame'ẽ va'erã nde-vy nde py'a-py ndopái va'erã. Yvu-rami opupu va'erã. Yvu-rami oĩ va'erã nde py'a-py nde rekoverã. Ndopái-gwi ereiko va'erã opa e'ỹ reheve Nhandejáry ndive, he'i kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Upe-ma ramo he'i íxupe kunha: —Eme'ẽ mani katu xe-vy, porombo'eháry, aipo erereko va'e y. Ndaxe y'uheivéi-ma va'erã. Ndajuvéi-ma va'erã y-rehe ko'a-py, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Upéi he'i kunha-pe: —Ekwa emombe'u ne ména-pe ou ave hagwã a-py. Upe rire peju katu ko'a-py, he'i. Ha kunha he'i íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Naxe ménai voi, he'i. Ha Hesu he'i íxupe: —“Naxe ménai” ere-ma ramo, anhetegwa voi eremombe'u xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Eremenda menda voi ereiko-vy va'ekwe. Cinco voi oiko ne menakwe. Indive ãy ereiko va'e ndaha'éi ne ména tee. “Naxe ménai” ere ramo, anhetegwa voi eremombe'u xe-vy, he'i kunha-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ohendu ramo inhe'ẽ: “Xe kwaa-ma ra'e” he'i ójehe. Upéa-gwi he'i íxupe kunha: —Nde ko, porombo'eháry, Nhandejáry nhe'ẽ-py eremombe'u va'ety nipo ra'e. Ahexa kwaa-ma nde-rehe, he'i oikwaa-gwi íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","—Upe va'e yvyaty ári ojeupi meme va'ekwe ore ramói kwéry. Nhandejáry nhamboete haty-py oho meme. Ha peẽ, judeu kwéry va'e katu ndapejohu porãi upe-py oroho ramo. Jerusalém tetã-my mante oipota jaha Nhandejáry mboete-vy. “Upe-py ae tekoha” he'i judeu kwéry, he'i kunha omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Upéi he'i kunha-pe: —Xe rerovia katu, kunha. Ogwahẽ-tama Nhandejáry óra, nhamboete tee hagwã íxupe óra. Ogwahẽ-ma rire, upe yvyaty ári napemboete mo'ãvéi-ma Nhandejáry Nhande Ru-pe. Napemboete mo'ãvéi-ma ave íxupe Jerusalém-my, upe oromboete haty-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ha pende kwéry niko peikwaa e'ỹ va'e pemboete va'e. Ha ore kwéry katu oroikwaa va'e oromboete voi. Nhane resendeharã ko judeu kwéry va'e. Upéa-gwi oromboete va'e oroikwaa voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ogwahẽ-ta hi'óra, he'i. —Ãy ogwahẽ pota-ma voi hi'óra. Ko'ánga katu Nhandejáry-pe omboete tee va'e gwive, omboete va'erã íxupe opy'a gwive. Nomboete ra'anga anga rei mo'ãvéi-ma íxupe. Upéa rehegwa omboete teeharã Nhandejáry oipota, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","—Ha Nhandejáry katu hete e'ỹ va'e jahexa e'ỹ va'e ha'e. Upéa-gwi jahexa e'ỹ ramo jepe, tanhamboete tee joty íxupe nhande py'a gwive. Ndikatuvéi-ma nhamboete ra'anga anga rei íxupe, he'i kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Upe ramo he'i íxupe kunha: —Nhane remiha'arõ ko ou va'erã, he'i. Nhane remiha'arõ va'e héry va'e Cristo. Upéi he'i: —Ogwahẽ rire ou-vy, opamba'e jaikwaa e'ỹ va'e gwive oikwaa uka va'erã nhande-vy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Xe voi niko ha'e. Xe Cristo-ma voi. Xe ne ndive anhomongeta va'e ha'e-ma voi, he'i kunha-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Upéa he'i-ma ramo, ogwahẽ ou-vy hemimbo'e kwéry. Opondera hese: —Mbava'e-gwi po onhomongeta kunha ndive oĩ-vy, he'i ojéupe. Ha Hesu-pe katu nomongetáiry: “Mbava'e tipo ereipota?” nde'íry. “Ma'erã tipo erenhomongeta kunha ndive ereĩ-vy?” nde'íry íxupe. Opondera rei hese. Noporandúiry. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Upe ramo pe kunha oheja omba'e y ryru oho jevy pe tetã-my: ");
INSERT INTO kgkNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Pekwa mani. Oĩ kwimba'e opamba'e xe rembiapokwe gwive omombe'u-ma va'e xe-vy. Peju katu jaha pehexa hagwã íxupe. Nhane remiha'arõ va'e para'e ha'e, he'i omombe'u-vy pe tetã mygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Osẽmba-ma upe tetã-gwi hikwái. Oime ou-ma hikwái. Hesu renda-koty ogwa'ẽ. Ne'írã vyteri ogwahẽ Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Upe-ma ramo ou jave hikwái: —Ekaru mani, ekaru mani, porombo'eháry, he'i íxupe hikwái. Ojapura okaru hagwã mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Nda'u mo'ãi, he'i. —Xe areko ha'u va'erã peikwaa e'ỹ va'e, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Upe-ma ramo he'i ojóupe hikwái: —Ndogwerúi tipo avave Hesu-pe hemi'urã ra'e? he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Upéi he'i gwemimbo'e kwéry-pe: —Xe ajapo meme xe mbouhare remimbota ajapopa peve xe rembiaporã. Peẽ pejapura pene remi'urã-rehe. Ha xe ajapurave xe rembiaporã-rehe. Upéa ajapo ramo, ndakarúi ramo jepe, xe rygwyatã vérami joty voi. Akaru-ma va'e-rami xe, he'i ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Upéi he'i jevy gwemimbo'e kwéry-pe: —“Irundy jasy rire ijagwyje-ma” ja'e va'e voi. Ha xe katu ha'e-ma peẽ-my. Pema'ẽ katu pehexa hagwã. Hi'aju-ma nipo ra'e temitỹgwe, he'i Hesu gweroviaharã-rehe temitỹgwe rehegwa-rami. Upéi he'i: ");
INSERT INTO kgkNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","—Peteĩ onhemitỹ va'e, outro kwéry oikytĩ va'e. Pe temitỹ omosarambi va'e-rami, peteĩ omombe'u mbe'u Nhandejáry nhe'ẽ. Pe oikytĩ va'e-rami, outro kwéry oporogwerovia uka va'e. Ko'ánga oĩ inhe'ẽ rerovia ukaha oikove opa e'ỹ reheve hagwã Nhandejáry ndive heroviaha. Hembiapo porã-rehe ohekoviarõ va'erã íxupe Nhandejáry. Peteĩ onhemitỹ, outro kwéry oikytĩ. Ovy'a onhondive hikwái. Peteĩxa hembiapo. Upéixa ete inhe'ẽ mombe'uhaty inhe'ẽ rerovia ukaha ndive ovy'a. Peteĩxa hembiapo. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Oromondo kuri peporogwerovia uka hagwã pemombe'u ranhe e'ỹ reheve. Outro kwéry oho pene renonde va'ekwe omombe'u hagwã Nhandejáry nhe'ẽ. Ha ko'ánga katu outro kwéry rembiapo porã porã-gwi, peporogwerovia uka-ma, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ha heta oĩ Samaria pygwa va'e ojerovia va'e Hesu-rehe. Pe kunha, “Entéro xe rembiapokwe gwive omombe'u-ma kuri xe-vy” he'i ramo tetã mygwa-pe omombe'u-vy, ojerovia-ma hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ha upéi katu ogwahẽ ou-vy Hesu renda-py hikwái: —Epyta katu ore ndive, epyta katu ore ndive, he'i íxupe. Upéa-gwi mokõi áry opyta hendive kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Inhe'ẽ ohendu ramo hetave-ma ogwerovia va'e oĩ. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","He'i kunha-pe hikwái: —Eremombe'u ramo kuri ore-vy orogwerovia-ma íxupe. Ha ko'ánga katu ore-vy tee-ma onhe'ẽ. Ore apysa-rupima orohendu inhe'ẽ. Upéa-gwi orogwerovia tee-ma voi íxupe, he'i. —Upe va'e entéro ko yvy ári oiko va'e gwive resendeharã nipo ra'e, he'i hese kunha-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mokõi áry rire upe-gwi oho jevy-ma Hesu. Ogwahẽ oho-vy Galiléia yvy-py: ");
INSERT INTO kgkNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","—Nhandejáry nhe'ẽ-py omombe'u va'ety ko nomboetéi íxupe hetã mygwa, he'i Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ha upéi katu ogwahẽ rire Galiléia yvy-py, ogwerohory íxupe upe pygwa kwéry. Oje'ói va'ekwe upe pygwa Jerusalém-my. Oiko jave aretegwasu héry va'e páscoa, upe-py ohopa. Upe-py ohexa va'ekwe entéro Hesu rembiapo porãgwe. Upéa-gwi ogwerohory voi íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ha upéi katu Hesu ogwahẽ jevy oho-vy Caná tetã-my, Galiléia yvy pygwa-py ogwahẽ oho-vy. Upe-py ykwe omondo va'ekwe uva rykwere ramo. Ha outro tetã-my héry va'e Cafarnaum mburuvixa ramo oĩ va'e upe-py. Hasy voi ta'ýry. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","—Ou-ma kuri Hesu Judéia yvy-gwi. Ogwahẽ-ma ko'a-py, he'i-ma ramo mburuvixa-pe, oho ogwahẽ Hesu renda-py. He'i Hesu-pe: —Jaha mani katu embogwera xe-vy xe ra'y-pe, he'i íxupe. —Omano hagwã rami-ma oĩ. Embogwera mani íxupe, he'i íxupe mburuvixa. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Upe-ma ramo he'i íxupe Hesu: —Ndaxe rerovia mo'ãi nde xe rembiapo erehexa e'ỹ reheve. Heroviapyrã-rupi xe rembiapo ramo, jahexa e'ỹ va'e ajapo ramo ae, xe rerovia va'erã, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Upe-ma ramo he'i íxupe mburuvixa: —Eju mani, porombo'eháry. Ani ne ate'ỹ teĩ ereju hagwã pono omano xe ra'y, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Tereho katu. Oikove jevy-ma nde ra'y, he'i mburuvixa-pe. Ogwerovia-ma inhe'ẽ oho-ma. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Oho jave, ohogwaitĩ íxupe hembigwái ou-vy: —Oikove jevy-ma nde ra'y, he'i íxupe omombe'u. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Upéi oporandu hembigwái-pe: —Mbovy óra-py oikove jevy-ma xe ra'y? he'i oporandu-vy gwembigwái-pe. —Kwehe larose rire nahete rakuvéi-ma, he'i túvy-pe hembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","“Upéa óra-py ete voi Hesu omombe'u kuri xe-vy nipo ra'e, Oikove jevy-ma nde ra'y, he'i voi xe-vy” he'i ojéupe. Upe-ma ramo ojerovia tee voi hese. Hóga pygwa gwive ave ojerovia tee ave hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Upéixa imokõiha-rehe hembiapo porã heroviapyrã-rupi ogwahẽ rire Galiléia-py Judéia yvy-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ha upe rire hi'agwĩ-ma ogwahẽ hagwã Judeu kwéry-pe arete áry hagwã. Upéa-rehe oho Hesu Jerusalém tetã-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Upe-py oĩ ygwa héry va'e Betesda hebreu nhe'ẽ-my. Ovexa rokẽ ypy-py oĩ. Ygwa ypy-py oĩ cinco ogapy onhemboty e'ỹ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Upe-py heta eterei oĩ hasy va'e. Onheno joa okwa-vy. Heta oĩ hesapyso e'ỹ va'e, heta oĩ ndogwata porãi va'e. Heta oĩ ijapa va'e ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ha Nhandejáry rembigwái yváy-py oiko va'e ogwejy ou-vy va'e. Ndogwejy meméiry. Hi'óra-py ae ogwejy ou-vy y-py. Omomýi hagwã mante y ou ogwejy. Omýi rire y, ha'e ranhe oike va'e y-py, okwera-ma. Oime raẽ va'e mba'asy opoi-ma íxugwi. Upéa oha'arõ oĩ-vy entéro hasy va'e gwive. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Upe-py oĩ kwimba'e. Are-ma hasy. Ojapo trinta e oito ánho hasy hagwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ha upéi katu ohexa íxupe Hesu. Ohexa kwaa hese are hasyha. “Are-ma onheno-vy rei oiko upe-py” he'i ojéupe. Upe-ma ramo ha'e he'i: —Erekwerase tipo? he'i hasy va'e-pe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Ndaipóri omýi jave xe moĩ va'erã y-py. Aikese mo'ã y-py, porombo'eháry. Ndaikatúi aike y-py. Oike xe renonde-rupi voive va'e, he'i Hesu-pe hasy va'e. Upe-ma ramo he'i íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Epu'ã katu, ehupi nde rupa. Upéi egwata, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Upe-ma ramo okwera-ma Hesu nhe'ẽ-py. Ohupi gwupa ogwata-ma voi. Japytu'uha áry-py okwera. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Upéa-gwi omombe'u mbe'u okwera va'ekwe-pe judeu ruvixa kwéry: —Etería ko japytu'uha áry. Nde rupa ereraha ramo, eremba'apo voi. Ha naiporãi eremba'apo pytu'uha áry-py, he'i omombe'u-vy hasy va'ekwe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Upéi he'i judeu ruvixa kwéry-pe: —He'i kuri xe-vy, “Ehupi nde rupa egwata katu” he'i xe-vy xe mbogwerahare, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—Kiva'e tipo, “Ehupi nde rupa egwata katu” he'i nde-vy, he'i oporandu-vy íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ha okwera va'ekwe katu ndoikwaáiry ombogwerahare réry. Upe-py oĩ heta ojogweroaty va'e. Ha Hesu katu ndojehexa ukavéi-ma oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ha upe rire katu Hesu otopa okwera va'ekwe-pe. Nhandejáry róga kakawaa-py otopa íxupe: —Nde ko erekwera-ma. Anive erejejavy teĩ pono ojehu jevy nde-vy ivaive va'e, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Upe ramo oho jevy omombe'u judeu ruvixa kwéry-pe: —Hesu ko xe mbogwerahare ra'e, he'i omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Upéa-gwi ojukase voi Hesu-pe judeu ruvixa kwéry: —Hesu ko omba'apo va'e japytu'uha áry-py, he'i ojóupe hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Upéi he'i íxupe kwéry Hesu: —Ko'ánga ete peve xe Ru ndopytu'úi omba'apo-vy. Omba'apo meme ha'e oiko-vy. Ha'e-rami xe amba'apo ave aiko-vy, he'i ójehe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Upéa ohendu ramo, ojukaseve voi íxupe hikwái. He'i ojóupe: —Upe va'e ojapo meme va'e jajapo e'ỹ va'e japytu'uha áry-py, he'i hese. —Ha ko'ánga katu, “xe Ru tee” he'i Nhandejáry-rehe. “Nhandejáry ko xe-rami” he'i. “Xe tuvixa mba'e Nhandejáry-rami” he'i Hesu ójehe. Upe va'e onhemonhandejáry ra'anga anga rei oiko-vy, he'i mo'ã Hesu-rehe onhombo'e mbo'e-vy judeu ruvixa kwéry. Upéa-gwi ojukase voi Hesu-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Upéi he'i jevy judeu ruvixa kwéry-pe Hesu: —Anhetegwa voi amombe'u-ta peẽ-my. Xe ko Nhandejáry ra'y tee ramo jepe, xejéhegwi rei mba'eve ndajapói. Xe Ru xe-vy ohexa uka va'e gwive ae ajapo. Xe Ru rembiapo gwive katu ajapo ave xe. Xe Ru-rami ave ajapo, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","—Xe ko xe Ru rembiayhu va'e. Entéro hembiapo gwive ohexa uka va'e xe-vy. Ha tuvixave va'e katu ohexa uka va'erã xe-vy pepondera va'erã hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Xe Ru ko ombotekove jevy va'e omano va'ekwe omoingove jevy íxupe. Ha'e-rami voi xe amoingove va'e amoingove va'erã-pe gwive. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ha xe Ru nomonhe'ẽi va'e avave-pe. He'i va'ekwe xe-vy xe Ru xe amonhe'ẽ ranhe hagwã enterove va'e-pe hembiapo apokwe-rami ajapo hagwã hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","He'i va'ekwe xe-vy xe Ru aporomonhe'ẽ hagwã entéro xe mboete hagwã omboeteha-rami xe Ru-pe. Avave xe mboete e'ỹ ramo, nomboetéi ave xe mbouhare-pe. Xe Ru-pe nomboetéi. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Anhetegwa va'e amombe'u-ta nde-vy. Peteĩ teĩ xe nhe'ẽ rendu va'e, xe mbouhare-pe ogwerovia va'e gwive, oikove-ma va'erã opa e'ỹ reheve Nhandejáry ndive. Ha'e nomondovéi-ma va'erã íxupe ojéhegwi ohasa asy hagwã. Oiko-ma va'erã opa e'ỹ reheve Nhandejáry ndive, he'i judeu ruvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Upéi he'i jevy omombe'u-vy: —Anhetegwa va'e amombe'u-ta peẽ-my. Ogwahẽ-tama omano va'ekweha áry, he'i. —Ãy ogwahẽ-ma voi. Ohendu-ta xe nhe'ẽ omano va'ekwe. Xe ko Nhandejáry ra'y tee voi. Xe nhe'ẽ rendu va'e oikove jevy-ta. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ojéhegwi rei voínte oiko xe Ru. Upéixa ete ome'ẽ xe-vy xejéhegwi reínte aiko hagwã ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Xe ko Nhande Ryke'y tee va'e voi. Upéa-gwi Nhandejáry nhe'ẽ-py amonhe'ẽ ranhe va'erã enterovéa-pe ajapo hagwã hese hembiapo apokwe-rami. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—Ani pepondera teĩ xe nhe'ẽ-rehe. Ogwahẽ va'erã omano va'ekweha áry. Ohendu va'erã xe nhe'ẽ entéro ijyta-py oĩ va'e gwive. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Osẽ va'erã ojejaty hagwe-gwi gwĩ hembiapo porã va'ekwe. Oikove jevy va'erã oiko meme hagwã Nhandejáry ndive. Ha gwĩ hembiapo vai va'ekwe oikove jevy va'erã amondo mombyry hagwã xejéhegwi, he'i omombe'u-vy judeu ruvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Upéi he'i jevy omombe'u-vy Hesu: —Xejéhegwinte mba'eve ndajapói. Nhandejáry remimombe'u xe-vy va'e ae xe ajapo. Xe ajapose va'e mante ndajapói ave. Xe mbouhare remimbota ae ajapose meme voi. Upéa-gwi “Ko va'e heko porã va'e. Upe va'e heko vai va'e” xe ha'e ramo, anhetegwa amombe'u va'e voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Xe amombe'u ramo xejehegwigwa mante: “Ijapu-ma” peje arã xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Oĩ outro xe rekoha omombe'u va'e. Hemimombe'u va'e xe-rehe anhetegwa voi. Xe aikwaa ijapu e'ỹha. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ha pene remimondokwe oho kuri João renda-py. Oporandu ramo xe-rehe, ha'e omombe'u-ma íxupe kwéry anhetegwa va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Teko rei remimombe'u xéjehe napenáiry. Xe mombe'u joty Nhandejáry. Ha amombe'u peẽ-my xe-rehe teko rei he'i va'e, xe rerovia hagwã, pene resende hagwã Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Ha João katu omombe'u porã va'ekwe xe rehegwa. Sapy'a perohory inhe'ẽ va'ekwe. Nhande resape sapy'aha-rami omombe'u. Ha tataendy hendy porã nhande resape-vy. Nhande resape jave javy'a voi. Upéixa ete voi sapy'a perohory inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Xe mombe'u porã va'ekwe João. Ha ko'ánga katu xe rembiapo porã porã rexa-vy, pehexa kwaa-ma va'erã xe-rehe xe rekoha. Ome'ẽ va'ekwe xe-vy xe Ru xe rembiaporã. Upe va'e xe ajapo voi. Ereikwaa porã ramo xe rembiapo, ere arã xe-rehe, “Upe va'e Nhandejáry Nhande Ru va'e remimbou voi nipo nhande-vy ra'e” ere arã xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ha xe mbouhare katu ha'e nga'u xe mombe'u-ma va'ekwe. Ha peẽ katu napehendúi va'e onhe'ẽ jave. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mba'eixagwa po Nhandejáry ndapehexái va'e. Nhandejáry remimbou ndaperoviái va'e. Upéa-gwi ndopytái voi pende py'a-py inhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Peje ojóupe, “Jaikwaa porã ramo Nhandejáry kwatia nhe'ẽ, jaikwaa va'erã mba'éixa po jaiko opa e'ỹ reheve va'erã Nhandejáry ndive” peje pendéjehe. Upéa-gwi pemonhe'ẽ nhe'ẽ mo'ã peiko-vy Nhandejáry kwatia nhe'ẽ. Ha ndapeikwaái voi he'ise va'e. Upe va'e nhe'ẽ pemonhe'ẽ nhe'ẽ va'e xe mombe'u voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Xe mombe'u ramo jepe inhe'ẽ, peẽ naxe moirũséiry joty peikove meme hagwã Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Naxe mboetéi ramo teko rei, apyta akirirĩ joty. Napenái joty hese. Xe Ru ae katu xe mboete va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ha peẽ katu peipota va'e pende rapixa ne mboete. Pende py'apy-py ndapehayhúi va'e Nhandejáry-pe. Aikwaa voi xe upe va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nhandejáry nhe'ẽ-py aju amombe'u-vy va'ekwe ha naxe rerovy'áiry joty-ma peẽ. Ha xe e'ỹ va'e katu onhe'ẽ-py rei ou ramo jepe, upe va'e perovy'a joty arã. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Peipota pende rapixa pene mboete. Ha Nhandejáry ha'e anho va'e katu napenhemboete ukáiry voi íxupe. Napepenái hese. Upéa-gwi ndikatúi xe rerovia. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ani “Hesu ko omombe'u va'erã Nhandejáry-pe nhande rekoha vai” ani peje teĩ pendejéupe. Myamyrĩ Moisés remimombe'ukwe-gwi ae ojekwaa-ma va'erã pende-rehe pende rekoha. “Nhande kwéry Moisés nhe'ẽgwe renduha va'e voi. Upéa-gwi nanhane mboykéi va'erã ojéhegwi Nhandejáry” peje mo'ã pendéjehe. Ha Moisés nhe'ẽgwe napehenduséi-gwi ae, ojekwaa-ma va'erã pende-rehe pende reko vaiha. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés omoĩ va'ekwe kwatia-rehe xe rehegwarã. Upéa-gwi perovia ramo íxupe ra'e, xe rerovia arã ra'e ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ha mba'éixa po xe rerovia-ta? Naperoviavéi-ma kwatia-rehe omoĩ va'ekwe. Upéixa ramo mba'éixa po xe rerovia-ta? he'i judeu ruvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ha upe rire Hesu ohasa oho-vy yugwarusu rovái. Upe yugwarusu mokõi héry va'e. Héry Galiléia yugwa. Héry va'e ave Tiberíades yugwa. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ha upéi katu heta eterei oĩ kente kwéry. Ohexa okwa-vy Hesu-pe omogwera gwera ramo hasy va'e-pe. Jahexa e'ỹ va'e hexapyrã-rupi ojapo ramo, ohexa. Upéa-gwi oho Hesu piári hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Upe ramo ha'e ojeupi oho-vy yvyaty-rehe. Upe-py ogwapy-ma oĩ-vy gwemimbo'e kwéry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Oiko-tama judeu kwéry aretegwasu va'e áry héry va'e páscoa. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ha upéi katu ha'e oma'ẽ ohexa heta eterei kente ogwa'ẽ ou-vy ramo henda-py ohexa. Upe-ma ramo he'i Filipe-pe: —Mba'e-rami po jajogwa-ta hemi'urã ho'u va'erã mbojape? he'i oporandu Filipe-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Upéa he'i oikwaa hagwã Filipe nhe'ẽ. Ha'e katu oikwaa-ma voi mbava'e tipo ojapo-ta. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","He'i íxupe Filipe: —Jajogwa ramo seis jasy omba'apo va'ekwe repy-rehe mbojape hemi'urã kwéry, nome'ẽi arã peteĩ teĩ ho'u mixĩmi hagwã, he'i íxupe kente kwéry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Upe-ma ramo he'i íxupe hemimbo'e Simão Pedro ryke'y, héry va'e André: ");
INSERT INTO kgkNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ko va'e karia'y ogwereko cinco mbojape cevada-gwi ojejapo va'ekwe. Mokõi pira ka'ẽ ogwereko ave. Ha upe va'e ndaha'éi heta kente remi'urã, he'i íxupe André. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Pembogwapy katu íxupe kwéry yvy-rupi, he'i gwemimbo'e-pe. Upe-py heta oĩ kapi'ipety. Ha upéi katu ogwapy-ma hikwái kapi'ipety-py. Cinco mil kwimba'e nunga-rupi ogwapy hikwái. Ndoipapái mitã-pe kunha-pe ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Upéi ha'e oipyhy mbojape, otima porã Nhandejáry-pe ome'ẽ me'ẽ ogwapy va'e kwéry-pe. Pira ome'ẽ ave ho'useha-rami. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Okaru porã hikwái, hygwyatãmba-ma hikwái. Okaru porã rire, he'i gwemimbo'e kwéry-pe: —Pemono'õ no'õ pembohyru tembi'u rembyre pono onhehundi rei ho'a va'ekwe gwive, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Upe-ma ramo omono'õmba cinco mbojape rembyre. Okaru va'e ho'u porã rire oheja ra'e. Upéa omono'õ no'õ omohynyhẽ nyhẽ doze ajaka jevy hembyre kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Upéi hexapyrã-rupi Hesu rembiapo porã ohexa ramo, he'i ojóupe hikwái: —Upe va'e ko Nhandejáry nhe'ẽ-py omombe'u va'ety ojekwaa va'erã voi va'ekwe ko yvy ári, he'i ojóupe Hesu-rehe upe pygwa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Upe-ma ramo he'i opy'a-py Hesu: “A pygwa voi ou-tama xe jopyse mo'ã xe pyhy-vy xe moingo hagwã huvixagwasu ramo” he'i ójehe. Upéa oikwaa ramo okanhy jevy ha'e anho yvyaty-rehe oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka'aru ete-ma. Ha hemimbo'e kwéry katu ogwejy oho-vy yugwarusu rembe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Upéi onhemboyru kanóa-py. Oho y-rupi hikwái. Cafarnaum tetã-ngoty oho. Pytũ-ma voi ha Hesu katu ne'írã vyteri ogwahẽ ou-vy gwemimbo'e kwéry renda-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yvytu eterei-ma ramo opu'ã y. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Oipykúi oho-vy cinco quilômetro para'e, seis quilômetro para'e. Ne'írã ogwahẽ ogwahẽse ha-py. Upe-ma ramo ohexa Hesu-pe hikwái y ári ogwata ou-vy ramo ohexa. Ohexa-ma ramo íxupe, onhemondýi voi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ha Hesu onhe'ẽ íxupe: —Xe ae ko, he'i. —Ani pekyhyje teĩ, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Inhe'ẽ ohendu ramo, ovy'a joa ogwerohory íxupe: —Eike katu kanóa-py, he'i Hesu-pe hikwái. Upe-ma ramo pya'e ogwahẽ kanóa ogwahẽse ha-py yvy ete-py oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ko'ẽmba-ma ramo, kente kwéry opyta va'e y rovái oho e'ỹ va'e he'i ojóupe: —Mamo po oho ra'e Hesu? he'i ojóupe. Oĩ ra'e peteĩ kanóa. Upe va'e-py onhemboyru jave hemimbo'e kwéry nonhemboyrúi ra'e Hesu. Hemimbo'e kwéry ae ha'e kwéry anho osẽ oje'ói-vy ra'e Hesu e'ỹ reheve. Upéa-gwi he'i ojóupe: “Mamo po oho ra'e Hesu?” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Upe jave ogwahẽ ou-vy outro kanóa Tiberíades tetã-gwi. Ogwahẽ-ma ou-vy yvy ete-py. Upe tetã-my Nhandejáry Hesu otima porã kuri Nhandejáry-pe upe va'e mbojape-rehe. Upe-py ho'u kuri upe va'e mbojape kente kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ha upéi katu gwĩ ogwahẽ ramo va'e he'i ojóupe: —Ko'a-gwi oho nipo ra'e Hesu. Hemimbo'e kwéry oho ave nipo ra'e, he'i ojóupe. Upéa-gwi onhemboyru-ma kanóa-py hikwái oho y-rupi Cafarnaum-my. Hesu piári oho. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ogwahẽ rire oho-vy y rovái otopa Hesu-pe hikwái: —Araka'e po ereju ra'e ko'a-py, porombo'eháry, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Upe-ma ramo he'i íxupe kwéry Hesu: —Anhetegwa va'e amombe'u-ta peẽ-my. Pe'u kuri upe va'e mbojape pene rygwyatãmba-ma voi kuri. Upéa-gwi peju-ma xe piári. Heroviapyrã-rupi xe rembiapo ramo, ndapeikwaái voi mbava'e-rehe xe rembiapo porã. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ani pepena eterei teĩ pene remi'urã-rehe. Pemoĩ porã ramo jepe, opa arã pendéhegwi. Pemba'apo ae katu pene rembi'u teerã-rehe peiko hagwã opa e'ỹ reheve Nhandejáry ndive. Pene rembi'u teerã ko xe Nhande Ryke'y tee va'e remime'ẽrã peẽ-my. Nhandejáry nhe'ẽ-py xe rembiapo. Upe va'e oikwaa uka-ma kuri peẽ-my Nhandejáry, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Upéi he'i íxupe hikwái: —Orojapose voi oipota va'e Nhandejáry orojapo va'erã. Mba'éixa tipo orojapo-ta hemimbota, he'i oporandu-vy íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—No'ã-rami pene rembiaporã. Xe ko Nhandejáry remimbou. Pejerovia katu xe-rehe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Upéi judeu kwéry: —Néi, he'i, —Mba'éixa ne rembiapo porã-ta heroviapyrã-rupi, orohexa va'erã orogwerovia hagwã. Ehexa uka ore-vy nde pu'akaha-rupi ne rembiaporã oropondera hagwã hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yma va'ekwe nhane ramoigwasu amyrĩ kwéry tekwaty e'ỹ-my oime jave va'ekwe ho'u va'ekwe tembi'u héry va'e maná: “Ome'ẽ va'ekwe íxupe kwéry yváy gwigwa mbojape ho'u va'erã.” Upéixa omoĩ va'ekwe kwatia-rehe Nhandejáry nhe'ẽ, he'i íxupe omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Upéi he'i Hesu: —Anhetegwa amombe'u-ta peẽ-my. Ndaha'éi Moisés ome'ẽ va'ekwe nhane ramói kwéry-pe upe va'e yváy gwigwa mbojape. Nhandejáry remime'ẽgwe ae upe va'e. Ko'ánga katu Nhandejáry ome'ẽ peẽ-my yváy gwigwa mbojape tee va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Upe mbojape tee Nhandejáry mba'e voi yváy gwigwa ogwejy va'ekwe pene moingove va'erã, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Eme'ẽ me'ẽ katu ore-vy upe va'e mbojape, porombo'eháry, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Xe ko mbojape tee ramigwa pene moingove va'e. Peteĩ teĩ xe moirũ va'e gwive ivare'a e'ỹ va'e-rami oiko va'erã. Ojerovia va'e gwive xe-rehe ijy'uhéi e'ỹ va'e-rami oiko va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Ha'e kuri peẽ-my, Peẽ ko xe rexa ramo jepe, ndapejeroviái joty xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Entéro xe rerovia uka va'e gwive xe Ru, xe moirũ va'erã. Xe-vy ou va'erã gwive, namboyke mo'ãvéi-ma va'erã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ndaha'éi ajapose va'e mante ajapo hagwã agwejy va'ekwe aju-vy yváy-gwi. Xe mbouhare remimbota ae mante ajapo va'erã agwejy aju-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ha xe mbouhare remimbota no'ã-rami. Ndoipotái xe amokanhy ni peteĩ xe moirũ uka va'ekwe gwive. Oipota xe amoingove jevy íxupe kwéry. Gwĩ omano va'ekwe opu'ã jevyha áry-py, oipota xe amoingove jevy enterove va'e xe moirũ uka va'ekwe gwive. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Xe Ru remimbota no'ã-rami. Oipota xe rexa va'e gwive, xe rerovia va'e gwive ave oiko opa e'ỹ reheve hendive. Upe va'e amoingove jevy va'erã gwĩ omano va'ekwe oikove jevyha áry-py, he'i judeu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Upe-ma ramo judeu kwéry ndojohu porãi inhe'ẽ: —“Xe ko Nhandejáry gwigwa. Mbojape-rami aju pene moingove hagwã” he'i kuri Hesu, he'i ojóupe hikwái. Hesu nhe'ẽ ndojohu porãi voi. Upéi he'i jevy hikwái: ");
INSERT INTO kgkNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Upe va'e ko José ra'y voi. Ha'e Hesu voi. Túvy isy ndive ikwaapy voi-ma upe va'e. Aipo-rami, ma'erã po, “Xe ko yváy-gwi agwejy va'ekwe” he'i kuri nhande-vy, he'i ojóupe hikwái. Ndojohu porãiry Hesu nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Upe-ma ramo ha'e he'i: —Anive penhe'ẽ poxy xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","—Ndou mo'ãi xe-vy avave ojéhegwite. Xe Ru xe mbouhare xe moirũ uka ramo ae, xe moirũ va'erã. Gwĩ omano va'ekwe oikove jevyha áry-py, amoingove jevy va'erã xe reroviaha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yma va'ekwe omoĩ va'ekwe kwatia-rehe Nhandejáry nhe'ẽ-py omombe'u va'ety nhe'ẽ. A-rami omoĩ va'ekwe: “Enterove va'e-pe ombo'e-ta Nhandejáry” he'i. Upéixa ramo entéro Nhandejáry nhe'ẽ ohendu va'e, Nhandejáry ombo'e íxupe va'e gwive, upe va'e gwive ou xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xe Ru-pe katu avave ndohexái va'e. Ha xe katu Nhandejáry-gwi aju va'ekwe ahexa va'e íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","—Anhetegwa va'e amombe'u-ta peẽ-my. Xe rerovia va'e gwive oikove-ma va'erã opa e'ỹ reheve Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Xe ko mbojape tee-rami pene moingove va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yma va'ekwe pene ramói kwéry ho'u va'ekwe maná héry va'e. Tekwaty e'ỹ-my ho'u hikwái. Ho'u ramo jepe, omano joty va'ekwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ãy katu ko va'e yváy gwigwa va'e mbojape tee ramigwa ndaha'éi upe maná héry va'e ramigwa. Ko mbojape tee ramigwa ho'u va'e gwive ae nomano mo'ãvéi-ma va'erã. Oikove meme va'erã Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Xe katu yváy-gwi agwejy va'ekwe aju-vy pene moingoveharã. Mbojape tee-rami xe ko pene moingove va'e. Upe mbojape tee ho'u va'e gwive oikove meme va'erã. Upe mbojape tee ame'ẽ va'erã kente kwéry-pe oikove hagwã. Upe mbojape tee xe rete voi, he'i ójehe judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Upéa nhe'ẽ ohendu ramo, onhe'ẽ poxy-ma ojóupe: —Hesu he'i kuri ja'u hagwã hete, he'i mo'ã ojóupe. —Mba'éixa po Hesu ome'ẽ-ta nhande-vy gwete ja'u va'erã, he'i. Upéa-gwi ogweropoxy Hesu nhe'ẽ hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Upe-ma ramo he'i judeu kwéry-pe: —Anhetegwa va'e amombe'u-ta peẽ-my. Xe ko Nhande Ryke'y tee va'e. Xe rete ndape'úi ramo, xe rugwy ndape'úi ramo, pemano va'erã, ndapeikovéi va'erã, name'ẽi va'erã peẽ-my pende rekoverã. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Xe rete ho'u va'e gwive, xe rugwy ho'u va'e gwive, ame'ẽ-ta íxupe hekoverã. Gwĩ omano va'ekwe oikove jevyha áry-py, amoingove jevy va'erã íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Xe rete ko pene rembi'u teerã voi. Xe rugwy pene rembi'u teerã voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xe rete ho'u va'e, xe rugwy ho'u va'e, xe moirũ tee va'e. Xe py'apy-py areko íxupe va'e voi. Opy'apy-py xe rereko voi ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nhandejáry Nhande Ru nhane moingove va'e xe mbou va'ekwe. Ome'ẽ va'ekwe-gwi xe-vy xe rekoverã, xe aiko ave. Upéixa ete voi xéhegwi okaru va'e ame'ẽ va'erã íxupe hekoverã. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ko va'e mbojape tee ramigwa yváy-gwi ogwejy va'ekwe kuri he'i xe-rehe. Ndaha'éi nhane ramói kwéry ho'u hagwe-rami. Ho'u ramo jepe, omano joty va'ekwe hikwái. Ko va'e mbojape tee ramigwa ae ho'u va'e gwive oiko meme va'erã, he'i judeu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Upe va'e he'i Cafarnaum tetã-my, ombo'e mbo'e jave Hesu judeu kwéry oporahéi haty-py. Oipota ojerovia tee ójehe gwete rehegwa nhe'ẽ, gwugwy rehegwa nhe'ẽ ave omombe'u-vy íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Upéa nhe'ẽ ohendu ramo, heta oĩ hemimbo'e kwéry va'e ndojohu porãi inhe'ẽ: —Ipohýi voi upe va'e nhe'ẽ. Ndikatúi nhahendu. Kiva'e po ohendu-ta, he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ha Hesu katu opy'a-py oikwaa-ma gwemimbo'e kwéry he'i va'e: “Ndojohu porãi xe nhe'ẽ” he'i ojéupe. Upéi he'i gwemimbo'e kwéry-pe: —Xe reja-ta tipo peẽ, he'i. —ndapejohu porãi-gwi xe nhe'ẽ? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","—Peẽ ko xe rexa va'erã para'e Nhande Ryke'y tee va'e xe ajeupi jevy aha-vy ramo xe rekwagwe-py. Upéixa xe rexa ramo, xe reja joty arã joty tipo, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","—Nhandejáry Nhe'ẽ Marangatu tee va'e ko nhane moingove va'e. Ha nhande kwéry katu nhandejéhegwi mba'eve ndajajapói va'e. Ha xe nhe'ẽ katu pehendu ramo opyta pende py'a py'apy-rupi nhe'ẽ marangatu ramo. Pene moingove va'e ave xe nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Xe nhe'ẽ pehendu ramo jepe, oĩ joty pene pa'ũ-my xe rerovia e'ỹ va'e, he'i gwemimbo'e kwéry-pe. Oikwaa voi ra'e kiva'e va'e po ndogweroviái voínte va'erã ra'e íxupe. Kiva'e po omombe'u hesegwa va'erã ra'e ija'e'ỹha-pe oikwaa-ma ra'e ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","He'i jevy gwemimbo'e kwéry-pe: —Oĩ pene pa'ũ-my xe rerovia e'ỹ va'e. Upe va'e-gwi ete ha'e kuri peẽ-my, “Ndou mo'ãi avave xe-vy ojéhegwi. Xe Ru, Tou, he'i ramo ae, ou va'erã” ha'e kuri peẽ-my, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Inhe'ẽ ohendu ramo, heta oĩ íxupe omoirũ va'e ojere íxugwi. Nomoirũsevéi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Upe ramo he'i upe doze gwemimbo'e kwéry-pe: —Ha xe rejase tipo peẽ ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ha Simão Pedro katu: —Oroheja ramo, ndaipóri ore mbo'eharã oroho hagwã ha'e-py, ore Járy. Ne nhe'ẽ ae mante orohendu ramo, oroiko-ma va'erã opa e'ỹ reheve Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ko'ánga katu orogwerovia tee-ma. Ne mbou tee va'ekwe nipo ra'e Nhandejáry. Nde reko marangatu tee nipo ra'e, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Upe ramo Hesu: —Xe apoporavo va'ekwe pepyta hagwã doze. Oroporavo ramo jepe, peteĩ pene pa'ũ-my oĩ joty anháy nhe'ẽngenduha, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Upéa he'i ramo omombe'u Simão Iscariotes ra'y Judas-rehe. Hese gwarã nhe'ẽ omombe'u. Ha Judas katu doze hemimbo'e kwéry va'e voi. Indivegwa jepe, omombe'u joty va'erã ija'e'ỹha-pe Hesu rehegwa. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ha upe rire katu ndogwatavéi-ma Hesu Judéia yvy-rupi. Upe pygwa judeu kwéry va'e ojukase íxupe. Upéa-gwi ndogwatavéi upe-rupi. Galiléia yvy-rupi ae ogwata oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ha upéi katu hi'agwĩ-ma oĩ ogwahẽ hagwã judeu kwéry arete áry, héry va'e Festa dos Tabernáculos, kwarahy ãy-my jaiko ramo peteĩ semana. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Upe ramo he'i íxupe Hesu ryvy: —Tereho katu Judéia yvy-py, ne nhe'ẽ renduha ohexa hagwã ne rembiapo, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","—Erejehexa ukase ramo, ani erejapo nhemi ne rembiapo. Nde pu'akaha-rupi, hexapyrã-rupi ne rembiapose ramo, atýra-py katu ejehexa uka, he'i íxupe tyvýry. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tyvýry jepe ndojeroviáiry joty hese: “Ha'e Cristo voi” nde'íry vyteri gwyke'y-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Upéi he'i gwyvýry-pe: —Nogwahẽi vyteri xe óra aha hagwã. Ha peẽ katu napende órai peho hagwã. Pehose ramo, tapeho mani katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","—Ha teko rei ndaija'e'ỹi pende-rehe. Ha xe katu aikwaa uka íxupe kwéry hembiapo vaikwe-gwi, ndaija'e porãi voi xe-rehe teko rei. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tapeho katu Jerusalém-my aretegwasu mboete-vy. Ha xe katu nogwahẽi vyteri xe óra aha hagwã. Upéa-gwi ndaha mo'ãi joty, he'i gwyvýry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Upe rire katu ndohói opyta joty Galiléia-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ha tyvýry oho-ma tenonderã. Aretegwasu mboete hagwã-py oho-ma. Oho rire hikwái, oho ave Hesu. Ha hexapyrã-rupi katu ndohói. Onhemo'ã ha-rupi ae oho. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ogwahẽ e'ỹ ngatu oheka Hesu-pe judeu ruvixa kwéry aretegwasu mboete haty-py: —Ne'írã vyteri tipo ogwahẽ, he'i oporandu Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ha kente kwéry omombe'u joavy avy hese: —Hekoha porã va'e ha'e, he'i hese. Outro he'i: —Ndaha'éi hekoha porã va'e. Nhane mbotavy rei oiko-vy va'e ae, he'i mo'ã hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ha atýra-py katu Hesu rehegwa nhe'ẽ nomombe'úiry. Hevovo rei onhe'ẽ-vy, judeu ruvixa kwéry-gwi ikyhyje-gwi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ha upéi katu oho Hesu upe-py. Aretegwasu mbyte-py oike oho-vy Nhandejáry róga kakwaa-py. Ombo'e upe pygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Inhe'ẽ ohendu ramo, opondera hese hikwái: —Mba'éixa po hi'arandu? he'i hese. —Onhembo'e e'ỹ reheve, oikwaa rei onhe'ẽrã, he'i judeu ruvixa kwéry hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Onhe'ẽ íxupe kwéry Hesu: —Ndaha'éi xejéhegwi xe ambo'e. Xe mbouhare rembigwaa uka xe-vy ae amombe'u. Nhandejáry rembiexa uka-py xe-vy ambo'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hemimbota ojapose va'e gwive oikwaa va'erã ki-gwi po ou ra'e xe nhe'ẽ, Nhandejáry gwigwa para'e, xejéhegwigwa rei para'e. Nhandejáry gwigwa voínte xe nhe'ẽrã. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ojéhegwi onhe'ẽ va'e onhembotuvixase mba'e. Ha imbouhare-pe ombotuvixase mba'e va'e katu, anhetegwa omombe'u. Ijapu e'ỹ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Pene rembypy Moisés omombe'u va'ekwe ramo jepe pende rekoharã, pene pa'ũ-my ndaipóri tekoha-rupi oiko va'e, he'i. —Upéa-gwi xe jukase voi. Ha naiporãi xe juka, he'i judeu ruvixa kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Anháy ojepota nde-rehe ra'e, he'i. —Kiva'e nipo nde jukase? he'i íxupe ijaty va'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Upéi Hesu he'i: —Peteĩ mba'e ajapo va'ekwe hexapyrã-rupi ajapo. Pehexa ramo pepondera joa hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ha peẽ katu ndapepytu'u teéiry japytu'uha áry-py. Japytu'uha áry-py ereikytĩ mixĩmi joty nde ra'y pire. Moisés nhe'ẽ-py ereikytĩ ipire. Ha Moisés nomombe'u ranhéi va'ekwe nhande-vy ko'a-rami nhande rekorã. Nhane rembypy ae omombe'u va'ekwe nhane rekorã. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Upéixa ramo japytu'uha áry-py jepe ereikytĩ joty arã ipire Moisés nhe'ẽgwe apo-vy. Upéa erejapo ramo, eremba'apo joty voi, he'i. —Nderepytu'u teéiry, eremba'apo ave nde. Ha ko'ánga katu xe amohesãimba kuri peteĩ hasy va'e. Japytu'uha áry-py amohesãimba-ma íxupe. Ma'erã po pende poxy xe-vy ra'e upeakwe-rehe? he'i íxupe kwéry. —Peẽ kwéry ave ndapepytu'u teéiry japytu'uha áry-py, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","—Ani ere rei teĩ nde rapixa-rehe, “Hembiapo vai ra'e”. Erehexa porã rire mante ae hembiapo vaikwe, “Hembiapo vai-ma” ere arã hese ra'e, he'i judeu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Upéixa ramo oĩ Jerusalém pygwa he'i va'e Hesu-rehe: —Upe va'e hembijukase voi, he'i ojóupe Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","—Ha'e ko atýra-py omombe'u. Ha mburuvixa kwéry nombojevýi joty inhe'ẽ. Ohexa kwaa para'e hese hekoha hikwái. “Ha'e Cristo nhane remiha'arõ va'e” he'i para'e hese hikwái, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ha oĩ he'i va'e, “Ojekwaa ramo Cristo, ki-gwi po ojekwaa uka ou-vy va'erã avave ndoikwaái” he'i Cristo, hemiha'arõ va'e-rehe he'i. Upéa-gwi he'i ojóupe: —Ha upe va'e ae katu, ki-gwi po ou ra'e jaikwaa voi ogwahẽha. Upe va'e ndaha'éi nipo Cristo ra'e, he'i mo'ã hese Jerusalém pygwa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ha upe-ma ramo Nhandejáry róga kakwaa-py oporombo'e jave, onhe'ẽ hatã Hesu: —“Jaikwaa voi íxupe. Ki-gwi po ou ra'e jaikwaa voi ogwahẽha” peje mo'ã xe-rehe, he'i. —Xe katu ndajúi va'ekwe xe nhe'ẽ-py. Oime voi xe mbouhare. Ha'e Nhandejáry tee va'e. Peẽ katu ndapeikwaái íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Xe ae aikwaa íxupe. Íxugwi-ma aju va'ekwe. Ha'e xe mbou va'ekwe. Upéa-gwi aikwaa voi íxupe, he'i ójehe íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Inhe'ẽ ohendu ramo, oipyhyse mo'ã íxupe hikwái. Ha nogwahẽi vyteri oipyhy hagwã óra. Upéa-gwi ndoipyhýi vyteri íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Heta oĩ jepe ojerovia va'e hese: —Heta hembiapo porã va'ekwe Hesu. Opu'akaha-py, hexapyrã-rupi hembiapo, he'i. —Ojehexa uka ramo Cristo nhane remiha'arõ va'e, hetave íxugwi ndojapo mo'ãi va'erã voi. Ha'e nipo Cristo voi ra'e, he'i ojóupe ojerovia va'e hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Upe ramo kente kwéry omombe'u joavy avy Hesu-rehe. Inhe'ẽ ohendu ramo he'i oipyhy hagwã íxupe pa'i ruvixa kwéry ndive fariseu kwéry. Oipyhy uka gwĩ Nhandejáry róga kakwaa-rehe onhangareko va'e polícia kwéry-pe mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Upe-ma ramo Hesu he'i: —Ndaxe are mo'ãi ne ndive aiko-vy. Upe rire katu aha jevy-ta xe mbouhare ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Peẽ xe reka va'erã ha ndaxe topa mo'ãi. Ndikatúi peju va'erã xe aha hagwã-py, he'i ójehe judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Upéi oporandu ojóupe hese hikwái: —Upe va'e mamo-py po oho-ta jatopa e'ỹ hagwã-py íxupe? Oho-ta para'e oiko hagwã judeu kwéry pa'ũ-my grego yvy-py oiko va'e pa'ũ-my? Ombo'e-ta para'e nhande kwéry e'ỹ va'e, grego kwéry va'e-pe? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","—He'i kuri nhande-vy: “Peẽ xe reka reka-ta ha ndaxe topa mo'ãi” he'i. Upéi he'i, “Ndikatúi peju va'erã xe aha hagwã-py” he'i. Upéa he'i ramo, mbava'e-pe po he'i, he'i oporandu-vy ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aretegwasu áry paha-py, iporã ete va'e-py, onhembo'y-ma Hesu. Hatã onhe'ẽ. Enterove ohendu hagwã-rami onhe'ẽ: —Ijy'uhéi va'e gwive tou katu xe ha-py hoy'u hagwã, he'i. —Ijy'uhéi va'e ouse va'e-rami y-py hoy'u hagwã, taxe moirũ katu xe moirũse va'e gwive, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","—Xe-rehe ojerovia va'e gwive, ipy'apy gwive osẽ oho-vy va'erã yvu ramigwa hapixa pegwarã. Upéixa he'i Nhandejáry kwatia nhe'ẽ, he'i ójehe omombe'u-vy Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yvu ramigwa he'i ramo, Nhe'ẽ Marangatu tee va'e-pe ae he'i. Entéro jajerovia hese va'e-pe gwive Nhe'ẽ Marangatu tee va'e hemime'ẽrã ae. Ne'írã omano Hesu oikove jevy hagwã onhembotuvixa mba'e hagwã. Upéa-gwi nome'ẽi vyteri Nhe'ẽ Marangatu tee va'e nhande-vy gwarã. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Hesu nhe'ẽ ohendu ramo, oĩ he'i va'e hese: —Upe va'e ko Nhandejáry nhe'ẽ-py omombe'u va'ety ou va'erã va'ekwe voi, he'i Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Oĩ outro he'i va'e: —Upe va'e ko Cristo nhane remiha'arõ va'e voi, he'i. Oĩ ave outro he'i va'e: —Cristo ndaha'éi ou va'erã va'ekwe Galiléia-gwi, he'i mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","—Ha'e ae ko myamyrĩ Davi remiarirõ voi, he'i. —Belém-gwi ou va'erã va'ekwe. Davi oiko hagwe-gwi ou va'erã va'ekwe. Upéixa voi he'i Nhandejáry kwatia nhe'ẽ, he'i hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Upéixa ramo omombe'u joavy avypa hesegwa nhe'ẽ. Ndogwerojojái inhe'ẽ hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Oĩ oipyhyse va'e mo'ã íxupe. Ha ndoipyhýi joty íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ha upéi katu ou jevy imondohare-pe gwĩ Nhandejáry róga kakwaa-rehe onhangareko va'e polícia. Ha pa'i ruvixa kwéry fariseu kwéry ndive oporandu polícia-pe: —Ma'erã po ndereipyhýi íxupe heru-vy? he'i oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ha polícia katu he'i: —Ha'eixagwa ndoikói onhe'ẽ porã va'e. Onhe'ẽ porã tee voi, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","He'i fariseu kwéry polícia-pe: —Penhembotavy nipo ra'e peẽ ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Ndojeroviái hese mburuvixave. Fariseuve ndojeroviái hese ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Teko rei katu nhande rekoha-rupi oiko e'ỹ va'e, ha'e kwéry anho ojerovia-ma hese. Ha gwĩ teko rei-rehe he'i vai-ma Nhandejáry, he'i mo'ã hese fariseu kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ha peteĩ ipa'ũ-my oĩ va'e ndojohu porãi inhe'ẽ. Héry va'e Nicodemos. Pyhare onhomongeta ra'e Hesu ndive. Ãy katu he'i hese: ");
INSERT INTO kgkNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—“Hembiapo vai ra'e” ja'e ramo hese nhamonhe'ẽ ranhe e'ỹ reheve íxupe ndajaikóiry tekoha-rupi. Jaikwaa e'ỹ reheve hembiapokwe, “Hembiapo vai ra'e” ja'e ramo ave, tekoha-rupi ndajaikói voi ave, he'i mburuvixa kwéry-pe Nicodemos. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","—Nde Galiléia gwigwa para'e, he'i íxupe. —Emonhe'ẽ nhe'ẽ katu Nhandejáry kwatia nhe'ẽ. Ndaipóri Nhandejáry nhe'ẽ-py omombe'u va'ety Galiléia-gwi ou va'erã. Upéa ereikwaa porã hagwã emonhe'ẽ katu, he'i Nicodemos-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Upe ramo mburuvixa kwéry ohopa jevy oje'ói-vy. Peteĩ teĩ jevy oje'ói hikwái. Gwóga gwóga-rupi oje'oipa jevy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ha Hesu katu osẽ oho-vy Oliveiras yvyaty-py. Upe-py oke. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Iko'ẽ-my oike jevy Jerusalém tetã-my. Nhandejáry róga kakwaa-py oike. Oike rire upe-py, enterove va'e ou henda-py. Upe-ma ramo ogwapy-ma ombo'e hagwã íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ha escriba kwéry fariseu kwéry ndive ogwenogwahẽ heru-vy kunha-pe. Upéi entéro va'e pa'ũ-my omoĩ íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","He'i Hesu-pe hikwái: —Porombo'eháry, ko va'e kunha orojohu íxupe kuri oména e'ỹ ndive oiko jave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","—Koixagwa kunha-pe gwive iporã ita-py jajapi jajuka hagwã he'i va'ekwe Moisés amyrĩ nhane rekorã mombe'u-vy, he'i Hesu-pe. —Ha ãy emombe'u katu ore-vy ne nhe'ẽ, he'i. —Mbava'e tipo ere-ta hese? he'i íxupe kunha-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Upéa he'i oipota-gwi mo'ã Hesu ojavy onhe'ẽ kunha-rehe. Ombojase mo'ã hese hikwái, “Ojejavy-ma Hesu” he'i hagwã mo'ã hese hikwái. Ha ha'e katu okirirĩ joty íxugwi. Ojeayvy ohai rei joty yvy oĩ-vy. Okwã-my ohai yvy oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","—Mbava'e tipo erejapo uka-ta hese? he'i jevy jevy oporandu-vy íxupe. Upe-ma ramo onhembo'y-ma oĩ-vy. He'i: —Pene pa'ũ-my ojejavy e'ỹ va'e tojapi ranhe katu íxupe, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Upéa he'i rire ojeayvy jevy. Ohai jevy ikwã-my yvy. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Itujave va'e ranhe osẽ oho-vy ojóupe, tenonderã voi ha'e osẽ oho-vy. Upéixa-gwi Hesu anho jevy-ma opyta. Ha upe kunha katu onhembo'y oĩ-vy hendive. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Upe ramo hovayva-ma Hesu. He'i: —Mamo tipo oje'oipa hikwái? he'i. —Ndopytái tipo peteĩ jepe he'i hagwã “Iporã ojejuka ko kunha” he'i hagwã nde-rehe? he'i kunha-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Peteĩ jepe ndopytáiry, porombo'eháry, he'i íxupe kunha. Upéi he'i kunha-pe: —Xe nda'e mo'ãi ave nde-rehe, “Iporã ojejuka ko kunha” nda'e mo'ãi nde-rehe, he'i íxupe Hesu. —Ha tereho katu. Anive katu erejejavy teĩ, he'i ae kunha-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ha upéi katu Hesu he'i jevy upe pygwa-pe: —Xe ko gwĩ pytũ-my oiko vérami va'e-pe ahesape va'e, he'i. —Xe moirũ va'e gwive ndoikói va'erã pytũ-rupi. Arakatu-rupi ae meme oiko va'erã Nhandejáry ndive, he'i upe pygwa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ha fariseu kwéry katu he'i íxupe: —Ndejehegwigwa rei mante eremombe'u-ma. Nde apu rei eremombe'u-vy, he'i íxupe mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ha Hesu he'i: —Ndaxe apúi voi, he'i. —Ha peẽ katu ndapeikwaái voi ki-gwi po aju ra'e. Kipy po aha jevy va'erã peẽ ndapeikwaái voi ave. Ha xe katu aikwaa voi xe aju hagwe. Xe aha hagwã aikwaa voi ave. Upéa-gwi xejehegwigwa amombe'u ramo jepe, anhetegwa joty amombe'u. Naxe apúi voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","—Ha peẽ pene akã gwigwa rei pemombe'u. “Ko va'e hembiapo porã va'e. Upe va'e hembiapo vai va'e” peje mo'ã ramo, peje rei-ma peẽ. Pene akã gwigwa rei mante pemombe'u. Peiporavo vérami mo'ã. Ha xe pene nhe'ẽ-rami namombe'úiry voi. Xe nda'e reíry pende rekoha-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","—Amombe'u ramo ae peẽ-my, anhetegwa tee voi amombe'u joty. Naxe anho reíry amombe'u. Xe Ru xe mbouhare ave omombe'u, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","—Pejeapysaka katu myamyrĩ Moisés he'i va'ekwe-rehe, kwatia-rehe omoĩ va'ekwe-rehe. He'i va'ekwe peẽ-my: “Mokõive ogwerojoja voi onhe'ẽ ramo, mba'e tee voi omombe'u” he'i pene rekorã mombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Xe amombe'u va'e xejehegwigwa. Ha xe Ru xe mbouhare xe mombe'u va'e ave. Ha ijoja voi ore nhe'ẽ. Upéa-gwi mba'e tee voi oromombe'u va'e, he'i fariseu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Upe va'e he'i-gwi: —Kipy oĩ nde Ru? Kipy oĩ nde Ru? he'i íxupe hikwái oporandu-vy. He'i fariseu kwéry-pe: —Naxe kwaái voi peẽ. Ndapeikwaái xe ae xe rekoha. Xe Ru ndapeikwaái ave. Ha xe kwaa ramo ra'e katu, xe Ru-pe ave peikwaa arã ra'e, he'i fariseu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Upéa he'i omombe'u, Nhandejáry róga kakwaa-py ombo'e jave. Pirapire omboyru haty-py ombo'e jave, he'i upéa. Ha nogwahẽi vyteri ojuka hagwã áry. Upéa-gwi ndoipyhýi íxupe heraha-vy avave. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ha upéi katu he'i judeu kwéry-pe: —Xe aha va'erã pendéhegwi. Aha rire xe reka rei va'erã peiko-vy. Xe reka ramo jepe, pemano joty va'erã. Pende py'a ky'a reheve pemano va'erã. Napegwahẽi va'erã xe ho ha-py, he'i judeu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Upe ramo he'i ojóupe hikwái: —“Napegwahẽi va'erã peho-vy xe aha hagwã-py” he'i kuri ore-vy. Ha'e voi ojeahéi-tapa ójehe ra'e? he'i mo'ã hese ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Upéi ha'e voi he'i: —Peẽ yvy pygwa voi. Ha xe katu yváy pygwa. Peẽ teko rei rekoha-rupi peiko va'e. Ha xe katu hemimbota-rupi ndaikói va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","—Pende py'a ky'a reheve pemano va'erã, ha'e kuri peẽ-my. Xéjehe ha'e va'e ndaperoviái ramo, pemano va'erã voi pende py'a ky'a reheve, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Upe ramo he'i íxupe hikwái: —Nde ko ma'erã tipo upéixa ere? Kigwigwa po nde? he'i oporandu-vy íxupe. —Upéa amombe'u meme va'e peẽ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","—Heta pende rehegwa nhe'ẽ xe amombe'u va'erã. Heta pende rekoha vai rehegwa nhe'ẽ xe amombe'u va'erã. Napehendúi ramo jepe xe nhe'ẽ, anhetegwa va'e joty amombe'u. Ha xe mbouhare anhetegwa va'e omombe'u va'e. Xe Ru nhe'ẽ ahendu va'e gwive amombe'u entéro yvypóry-pe gwive, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Upéa he'i ramo, Gwu rehegwa nhe'ẽ omombe'u. Ha judeu kwéry katu ndoikwaái voi inhe'ẽ. Naimba'ereroviái voi. —Kiva'e po imbouhare, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Upéixa ramo he'i jevy judeu kwéry-pe: —Xe ko Nhande Ryke'y tee va'e. Xe rupi rire xe moĩ-vy kurusugwasu-rehe xe juka hagwã, “Anhetegwa nipo ra'e he'i va'e ójehe” peje va'erã xe-rehe. “Ojehegwínte mba'eve ndojapói nipo ra'e. Túvy ombo'e íxupe va'ekwe mante omombe'u nipo nhande-vy ra'e” peje va'erã xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","—Xe mbouhare remimbota ajapo meme va'e. Upéa-gwi xe mbouhare naxe rejái xe anho. Xe moirũ meme voi oiko-vy, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ha henduha heta oĩ hese ojerovia va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Upéa-gwi he'i judeu kwéry-pe gwĩ hese ojerovia va'e-pe: —Xe nhe'ẽ pehendu ramo peiko-vy, xe remimbo'e tee ramo peiko, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","—Upéixa xe remimbo'e ramo peiko ramo, peikwaa va'erã anhetegwa va'e. Upe ramo peẽnte-ma pemanda va'erã pendéjehe, he'i judeu kwéry-pe, hese ojerovia va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","He'i íxupe hikwái: —Myamyrĩ Abraão ko nhane rembypy voi. Avave nomandái va'e nhande-rehe, he'i. —Ma'erã ere kuri ore-vy, “Pendejehénte-ma pemanda va'erã” he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Upéi he'i jevy judeu kwéry-pe: —Pejeapysaka katu xe nhe'ẽ-rehe. Amombe'u-ta peẽ-my anhetegwa va'e. Ojejavy va'e gwive hekoha porã hagwã ndaipu'akái ójehe. Anháy rembigwái-rupi oiko-gwi, nomandái ójehe. Ha naiporãi jaiko anháy rembigwái ramo. Iporãve jaiko Nhandejáry re'ýi ramo. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nhane irũ memerã voi nhande re'ýi ha nhane rembigwái katu ndaha'éi nhande re'ýi-rami. Nhamosẽse ramo, nhamosẽ íxupe oho hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ha xe ko Nhandejáry ra'y voi. Upéa-gwi xe oromoingo ramo Nhandejáry ra'y ramo, ndapeikói va'erã anháy rembigwái-rami, hembiapose e'ỹ va'e vérami. Nomandavéi va'erã pende-rehe anháy. Pende pu'aka va'erã pendéjehe ani pejejavy hagwã. Nhandejáry ra'y ramo peiko meme va'erã. Nomandavéi va'erã avave pende-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","—Ha Abraão katu pene rembypy voi. Aikwaa upéa. Ha hemiarirõkwe ramo jepe, ndapeikói heko-rupi. Xe jukase joty voi peiko-vy, napehenduséi xe nhe'ẽ-gwi. Upéa-gwi xe jukase joty peẽ peiko-vy, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Xe ko amombe'u va'e xe-vy ohexa uka va'ekwe xe Ru. Ha peẽ katu pejapo va'e peẽ-my he'i va'ekwe pende ru, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Upéi he'i hikwái: —Abraão ko ore ru tee voi, he'i íxupe. He'i jevy judeu kwéry-pe: —“Abraão ore ru tee voi” peje kuri xe-vy. Aipo ramo ma'erã ndapeikói Abraão reko-rupi? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","—Nhandejáry remimombe'ukwe xe-vy, anhetegwa tee va'e, amombe'u ramo jepe peẽ-my, xe jukase joty peẽ peiko-vy. Ha pende reko-rupi ndoikói va'ekwe Abraão, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","—Pende ru reko-rupi ae peiko peẽ, he'i judeu kwéry-pe. Upéi ha'e kwéry he'i: —Ore sy naimemby reíry va'ekwe. Nhandejáry ha'e anho ore Ru va'e. Ore kwéry ta'ýry tee, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Upéi ha'e he'i: —Nhandejáry-gwi aju va'ekwe. Nhandejáry gwigwa voi xe. Xe ae xe nhe'ẽ-py ndajúi va'ekwe. Nhandejáry nhe'ẽ-py ae aju va'ekwe. Upéa-gwi Nhandejáry pende Ru ramo oiko ramo ra'e, xe rayhu arã peẽ ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ma'erã po ndapeikwaái xe nhe'ẽ. Napehenduséi voi xe nhe'ẽ. Upéa-gwi ndapeikwaái voi xe nhe'ẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","—Anháy ruvixa ra'y voi peẽ, he'i. —Pende ru voi anháy. Peiko voi katu hemimbota-rupi. Yma ete gwive ko'ánga ete peve nhande jukase va'e voi. Anhetegwa tee va'e-rehe nopenái voi. Upéa-gwi anhetegwa va'e omombe'u e'ỹ va'e voi. Ha'e ijapu va'e. Ijapu va'e gwive ru ave. Upéa-gwi ojehegwínte ijapu. Gweko-rupi meme oiko. Ijapuse-gwite ijapu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","—Xe katu anhetegwa tee va'e amombe'u va'e. Upéa-gwi xe remimombe'u ndaperoviái peiko-vy. Ha peẽ katu anháy reko-rupi peiko-gwi ndaperoviái xe remimombe'u, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","—Kiva'e po pene pa'ũ-gwi he'i-ta xe-rehe, “Ipy'a ky'a nipo Hesu ra'e ojejavy-gwi?” Ha “Ojejavy ko ra'e” he'i va'erã xe-rehe, ndoikóiry. Upéixa ramo peikwaa ramo xe remimombe'u anhetegwa tee ramo, ma'erã katu ndaxe reroviaséiry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","—Nhandejáry re'ýi gwive ohendu inhe'ẽ. Ha peẽ katu ndaha'éi Nhandejáry re'ýi. Upéa-gwi napehenduséi voi inhe'ẽ, he'i judeu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Upe-ma ramo he'i íxupe judeu kwéry: —Nde ko ore kwéry e'ỹ va'e, Samaria pygwa va'e nipo ra'e. Anháy nipo ra'e ojepota nde-rehe oro'e hagwe-rupi ra'e, he'i mo'ã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Ndojepotáiry voi teĩ kuri xe-rehe anháy, he'i judeu kwéry-pe. —Xe Ru-pe amboete va'e. Ha peẽ xe mboete e'ỹ ramo, napemboetéi íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nanhemboete ukái voi teko rei-pe. Ha peẽ xe mboete e'ỹ ramo jepe oĩ joty xe mboeteseharã. Anhetegwa va'e xe amombe'uha oikwaa voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Anhetegwa va'e amombe'u-ta peẽ-my. Xe nhe'ẽ renduha gwive nomano mo'ãvéi-ma. Oiko va'erã opa e'ỹ reheve Nhandejáry ndive, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Upe ramo he'i íxupe hikwái: —Anháy ojepota-ma nipo nde-rehe oiko-vy ra'e. Anhete teegwa-ma, he'i mo'ã. —Ojepota-ma nde-rehe anháy. Oroikwaa-ma voi ojepotaha nde-rehe anháy. Omano va'ekwe Abraão. Omano va'ekwe ave Nhandejáry nhe'ẽ-py omombe'u va'ety kwéry. Omano ramo jepe, “Xe nhe'ẽ renduha gwive nomano mo'ãvéi-ma” ere kuri ore-vy. Ojepota-ma voi nde-rehe oiko-vy ra'e anháy, he'i mo'ã Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","—Omano-ma voi va'ekwe nhane ramói myamyrĩ Abraão. Ha Abraão enterove remimboete voi. Ha nde erenhemboete ukaseve mo'ã tipo ereiko-vy? Myamyrĩ Nhandejáry nhe'ẽ-py omombe'u va'ety omano-ma voi va'ekwe ave. Erenhemonhandejáry ra'anga anga rei nipo ra'e, he'i íxupe judeu kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Upéi Hesu he'i judeu kwéry-pe: —“Tuvixave va'e mba'e voi xe” ha'e ramo xéjehe, nanhemboete teéiry arã ra'e. Ha xe mboete va'e xe Ru. Upe va'e, “Ore Járy” peje mo'ã hese, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","—Nhandejáry kwaa e'ỹha peẽ. Xe katu aikwaa voi íxupe. “Xe ndaikwaáiry íxupe” ha'e ramo, xe apu-tama xe ave. Pende reko-rupima xe aiko arã ra'e. Ha Nhandejáry kwaaha xe. Aikwaa voi íxupe. Ahendu va'e inhe'ẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","—“Nhandejáry ra'y áry ahexa va'erã” he'i ojéupe myamyrĩ Abraão xe-rehe va'ekwe. Upéa-gwi ovy'a eterei va'ekwe. Upéi xe ajehexa ukaha áry ohexa rire, ogwerohory hembiexagwe, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ha'e kwéry he'i: —Ne'írã eremboty cinqüenta ro'y. Ma'erã po ere kuri ore-vy, “Myamyrĩ Abraão-pe ahexa va'ekwe” ere kuri? he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Amombe'u-ta peẽ-my anhetegwa va'e, he'i. —Ne'írã vyteri myamyrĩ Abraão oiko ramo imitã ramo, xe Nhandejáry ramo aiko-ma voi va'ekwe, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Upe-ma ramo ojapi hagwã mo'ã íxupe oheka heka-ma ita. Oipyhy pyhy ojuka hagwã mo'ã íxupe. Ha Hesu okanhy onhemo'ã íxugwi kwéry. Upéi osẽ oho-vy íxugwi kwéry Nhandejáry róga kakwaa-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ha upéi katu oho ogwata-vy Hesu. Ogwata jave ohexa peteĩ hesapyso e'ỹ va'e-pe. Imitã gwive ndahesapysóiry va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ohexa ramo, oporandu Hesu-pe hemimbo'e: —Mba'e-gwi upe va'e ndahesapysóiry va'e imitã gwive, porombo'eháry? Ha'e ojejavy-gwi para'e. Ojejavy-gwi para'e túvy isy ave? he'i íxupe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Upéi Hesu he'i íxupe: —“Upe va'e hesa e'ỹ va'e ojejavy-gwi para'e, túvy isy ave ojejavy-gwi para'e, onase hesa e'ỹ reheve” peje mo'ã. Ha ndaupéixairy, he'i. —Hesapyso e'ỹ va'e ae hembiapo porã hagwã íxupe Nhandejáry hexapyrã-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Áry ramo jajapo katu xe mbouhare rembiapo. Ou va'erã pyhare. Pytũ jave ndikatúi omba'apo avave. Ãy ome'ẽ nhamba'apo. Ha nhamba'apo e'ỹ va'erã óra-py, nanhamba'apo mo'ãvéi-ma va'erã, he'i ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","—Xe aime jave ko yvy ári, yvypóry kwéry-pe, pytũ-rupi oiko va'e-rami va'e-pe ahesape va'e, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Upéa he'i rire, onygwõ yvy-py ombotuju hagwã gwendy-py. Ombotuju rire katu omona-ma hesa e'ỹ va'e resa-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Tereho katu Siloé ykwa-py ejehesahéi, he'i hesa e'ỹ va'e-pe. Y ojereru va'ekwe-pe he'i Siloé. Ha upéi katu oho ojehesahéi. Hesapyso porã-ma oukwe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ha hapixa kwéry, imba'ejerure oĩ-vy ramo hexaháry ave he'i ojóupe: —Kiva'e tipo upéa? he'i. —Ogwapy va'evy va'ekwe ko upéa kwimba'e. Omba'e repyrã-rehe ojerure rure va'ekwe. Ha ãy hesapyso-ma nipo ra'e, he'i ojóupe hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Ha'e voi —oĩ he'i va'e hese. —Imba'ejerure va'ekwe hesapyso voi ra'e ãy, he'i. Outro kwéry he'i hese: —Ndaha'éi. Ijogwaha rei upe va'e, he'i mo'ã hese. Ha ha'e voi katu he'i: —Xe mba'ejerure va'ekwe voi xe, he'i ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Upe ramo he'i íxupe hikwái: —Mbava'e tipo erejapo nde resa-rehe erehexa porã hagwã? he'i oporandu-vy. Ha ha'e he'i: ");
INSERT INTO kgkNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Hesu héry va'e ombotuju kuri yvy omoĩ xe resa-rehe. Upéi, “Tereho katu Siloé ykwa-py ejehesahéi” he'i xe-vy. Upe ramo aha ajehesahéi xe resapyso-ma, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—Kipy oime Hesu? he'i íxupe hikwái. —Ndaikwaáiry kipy po oĩ, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Ha upéi katu hesapyso e'ỹ va'ekwe ojereru fariseu kwéry renda-py. Ndojohu porãi ra'e Hesu rembiapo fariseu kwéry: —Japytu'uha áry-pyte ombotuju Hesu hesapyso hagwã, he'i ojóupe fariseu kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Upéa-gwi oporandu íxupe: —Mba'éixa pa nde resapyso jevy-ma? he'i íxupe fariseu kwéry. —Xe resa-rehe omoĩ kuri tuju. Upéi aha ajehesahéi xe resapyso-ma, he'i fariseu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Upe ramo omombe'u joavy avy ojóupe fariseu kwéry: —Hesu ko japytu'uha áry reko-rupi ndoikóiry. Upéa-gwi Nhandejáry nhe'ẽ e'ỹ-py hembiapo, oĩ he'i va'e hese. Ha outro fariseu he'i: —Hesu hexapyrã-rupi hembiapo porã va'e. Ma'erã, “Ojejavy ra'e” peje hese mo'ã? he'i ojóupe hese hikwái. Upéixa ramo omombe'u joavy avy ojóupe Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Upéa-gwi oporandu jevy hesapyso e'ỹ va'ekwe-pe: —Mba'eixagwa hekoha va'e tipo nde resa apohare? he'i. —Emombe'u katu ore-vy hesegwa, he'i íxupe fariseu kwéry. —Nhandejáry nhe'ẽ-py omombe'u va'ety voi upe va'e, he'i fariseu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","“Xe resapyso-ma” he'i ramo, ndogweroviái inhe'ẽ judeu ruvixa kwéry. Upéa-gwi ohenói uka hesapyso e'ỹ va'ekwe ru-pe. Isy-pe ohenói uka ave ou hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ogwahẽ ramo, oporandu túvy-pe isy-pe ave: —Nde ra'y tipo upe va'e, he'i túvy-pe. —Imitã gwive ndahesapysóiry va'e peje hese va'e? Mba'éixa tipo ohexa oiko-vy? oporandu túvy-pe isy-pe ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","He'i judeu ruvixa kwéry-pe: —Ko va'e katu aikwaa voi xe ra'y teeha. Imitã gwive hesapyso e'ỹha aikwaa voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","—Ha ndoroikwaái mba'éixa po ohexa ãy. Kiva'e po ombohesa ra'e íxupe ndoroikwaái ave. Ha xe ra'y-pe katu peporandu peikwaa hagwã. Naimitãvéiry-ma voi xe ra'y. Ójehe gware omombe'u va'erã peẽ-my, he'i judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Upéa he'i ikyhyje-gwi judeu ruvixa-gwi. Onhombo'e ra'e ojóupe judeu ruvixa kwéry: —“Cristo, nhane remiha'arõ va'e voi Hesu” he'i va'e gwive, nhamosẽ katu ojeporahéi haty haty-gwi, he'i ojóupe. Upéa-gwi ikyhyje voi túvy isy ave. Upéa-gwi he'i: ");
INSERT INTO kgkNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","“Naimitãvéiry-ma voi xe ra'y. Ójehe gware omombe'u va'erã peẽ-my” he'i judeu kwéry-pe túvy isy ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Upéa he'i-gwi: —Eju katu, he'i jevy hesapyso e'ỹ va'ekwe-pe judeu ruvixa kwéry. —Ore kwéry ko oroikwaa voi pe kwimba'e Hesu héry va'e ojejavy javyha. Upéa-gwi etima porã katu Nhandejáry-pe nde resapyso jevymaha-rehe, he'i íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Ojejavy va'e para'e pe kwimba'e. Tapa ojejavy e'ỹ va'e. Xe ndaikwaáiry. Ha peteĩ mba'e xe aikwaa. Kwehe ndaxe resáiry va'e xe. Ãy katu xe resa-ma voi. Ãy katu ahexa porã-ma, he'i judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Upe ramo he'i íxupe hikwái: —Mbava'e tipo ojapo nde-vy ra'e ne mbohesa hagwã? he'i. —Mba'éixa tipo ne mbohesa hagwã ra'e? he'i jevy íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Ma'erã po pehenduse jevy? Napehenduséi kuri xe remimombe'u peẽ-my. Peikose para'e Hesu remimbo'e ramo peẽ ave, he'i judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Upe-ma ramo ipoxy-ma íxupe. Onhe'ẽ rei rei-ma íxupe: —Hesu remimbo'e voi nde. Ha ore kwéry katu Moisés remimbo'e voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","—Nhandejáry remimombe'ukwe nipo araka'e Moisés-pe. Ha ki-gwi po ou Hesu ra'e ndoroikwaáiry, he'i íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Upe ramo ha'e he'i: —Apondera voi pende-rehe. Hesu xe mbohesa ramo jepe, ki-gwi po ou ra'e ndapeikwaái joty, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","—Nhandejáry rekoha jaikwaa voi. Ojejavy va'e-pe gwive ndohexa mo'ãi. Ha imboeteha gwive katu hemimbota apoha ave, upe va'e-pe ohexa va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","—Pejeapysaka katu xe nhe'ẽ-rehe. Ko yvy nhepyrũ gwive ãy ete peve, “Hesapyso-ma imitã gwive hesa e'ỹ va'e” nde'íry va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","—Ojéhegwi mba'eve ndojapói va'e Hesu. Xe mbohesa-ma kuri. Nhandejáry remimbou voi nipo ra'e Hesu, he'i judeu ruvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Upe nhe'ẽ ohendu-ma ramo ipoxy-ma hikwái: —Nde py'a ky'apa-ma reheve ereiko va'ekwe. Upéa-gwi naiporãi voi nde ore mbo'e, he'i hesapyso e'ỹ va'ekwe-pe judeu ruvixa. Upe rire omosẽ íxupe: —Anive ereike teĩ ojeporahéi haty haty-rupi, he'i íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ha upéi katu: —Omosẽ ra'e hesapyso va'ekwe-pe judeu ruvixa, he'i Hesu-pe. Upéa-gwi oho oheka íxupe Hesu. Otopa ramo, he'i: —Erejerovia-ma tipo nde ereiko-vy Nhande ryke'y tee va'e-rehe, he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Kiva'e po ndaikwaái, porombo'eháry, ajerovia-ma hagwã hese, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Erehexa-ma ereĩ-vy íxupe. Xe voi, he'i ójehe. —Pende ryke'y tee va'e xe voi nde-vy anhe'ẽ va'e, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Ajerovia-ma nde-rehe, xe Járy, he'i íxupe. Gwetypy'ã-rehe onhesũ omboete-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ha upéi katu he'i upe pygwa-pe Hesu: —Ko yvy-py aju va'ekwe ojekwaa hagwã yvypóry kwéry rekoha, ipy'a-py oĩ va'e ojekwaa hagwã. Hesapyso e'ỹ va'e-rami voi oiko hi'arandu e'ỹ va'e. Aipota hesapyso-ma va'e-rami oiko hikwái. Ha, “Nhane arandu va'e” he'i ra'anga anga rei va'e katu, aipota hi'arandu e'ỹha enterove ohexa. Upéa-gwi aju va'ekwe ko yvy ári, he'i upe pygwa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Oĩ fariseu kwéry va'e hendive oĩ va'e, upéa ohendu va'e: —“Pene arandu e'ỹ peẽ ave” ere tipo ra'e kuri ore-vy ave, he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—Pende resapyso e'ỹ va'e-rami peiko ramo ra'e, ndaiky'ái arã ra'e pende py'a. Ãy katu, “Ore resapyso va'e-rami ore arandu porã va'e” peje mo'ã pendéjehe. Upéa-gwi pende apu-gwi, iky'a-ma voi oĩ-vy pende py'a, he'i fariseu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ha upéi katu he'i jevy upe pygwa-pe Hesu: —Amombe'u-ta peẽ-my anhetegwa va'e. Jaike ramo xikéro-py ovexa oĩ ha-my, okẽ-rupi jaike va'e. Ha imondaháry oporosakeahaty va'e ave katu okẽ-rupi ndoikéiry. Ojeupi ae ohasa xikéro ári-rupi oike hagwã ovexa oĩ ha-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","—Ha okẽ-rupi oike va'e katu ovexa rerekwa voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","—Ogwahẽ ou-vy ramo, imbotyhaty járy onhokendavo íxupe. Upéi ohenói gwymba. Peteĩ teĩ héry-py ohenói. Ohenói ramo, ohendu inhe'ẽ hymba. Upéi oka-py ogweraha. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ogwenohẽ rire gwymba gwive, oho henonde-rupi. Oikwaa inhe'ẽ. Upéa-gwi oho hupive hikwái, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","—Ha herekwa e'ỹ va'e-pe katu nomoirũséi voi. Ndohoséi hupive. Herekwa e'ỹ va'e nhe'ẽ ndoikwaái voi. Upéa-gwi okanhy oje'ói-vy íxugwi, he'i upe pygwa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Arandu rehegwa nhe'ẽ omombe'u íxupe kwéry ovexa rehegwa nhe'ẽ-rami. Ha henduha katu mbava'e-rehe po he'ise Hesu ndoikwaái voi hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Upéixa ramo he'i jevy íxupe kwéry Hesu: —Amombe'u-ta peẽ-my anhetegwa va'e. Ovexa rokẽ he'ise xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Xe renonde-py ou va'ekwe-rehe gwive he'ise imondaháry oporosakeahaty ave. Ha nohendúiry íxupe ovexa. Xe nhe'ẽ renduha-pe he'ise ovexa. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Okẽ, ha'e ramo xéjehe voínte ha'e. Okẽ-rupi oike va'e gwive xe-rehe ojerovia va'e aresende va'erã íxupe. Ndaikyhyjéi va'erã oike ike-vy. Ikyhyje e'ỹ reheve osẽ osẽ va'erã. Oĩ hese onhangareko va'e. Oheka va'erã ho'u va'erã, he'i gwĩ hese ojerovia va'e-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","—Ha imondaháry katu nopenái ovexa-rehe. Omonda hagwã mante íxupe ou va'e. Ijukapyrã voi ovexa. Ohundi hagwã mante íxupe ou. Ha xe katu aju va'ekwe amoingove hagwã ovexa-pe. Amoingove porãve rãve va'erã íxupe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Herekwa heko porã tee va'e gwymba ndive ojejuka uka hagwãixa opyta. Pe herekwa heko porã tee va'e xe-rehe voi he'i, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","—Hembigwái ae katu ogana hagwã mante omba'apo va'e ndaha'éi herekwa tee. Ijáry e'ỹ voi upéa. Upe va'e nopenái mymba-rehe. Ogana hagwã mante omba'apo. Upéa-gwi ogwahẽ ou ramo jagwarete, nonhangareko porãi hymba-rehe. Oripara mante íxugwi. Upe-ma ramo oipyhy mymba-pe jagwarete omosarambipa hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Pe ovexa rerekwa hekoha porã tee va'e, ha'e ramo, xéjehe voínte ha'e. Xe Ru rekoha aikwaapa voi. Xe kwaa ave xe Ru. Upéixa ete aikwaa xe rymba. Ha xe rymba xe kwaa ave. Xe rymba rekovía ajejuka ukase va'erã voi. Naxe rakate'ỹiry xe rekove-rehe xe rymba aresende hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","—Mombyry mbyry oĩ va'e xe rymba xe areko va'e ave. Ndaha'éi a pygwa, ko xikéro pygwa. Mombyrygwa-pe ajererovia uka va'erã. Xe nhe'ẽ ohendu va'erã. Henda henda-rupi peteĩxa oiko va'erã. Peteĩ mante oĩ va'erã herekwa. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Xe rymba rekovía ajejuka uka va'erã voi, xe aikove jevy hagwã. Upéa-gwi xe rayhu voi xe Ru. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Xe rekove-rehe ipu'akave va'e ndaipóri. Xe jukase-gwi mante naxe jukái va'erã avave. Xe nhe'ẽ-rupi mante xe juka va'erã. Xe nhe'ẽ-py joty ajejuka uka va'erã. Xe nhe'ẽ-py joty aikove jevy va'erã. Upe va'e ajapo hagwã he'i va'ekwe xe-vy xe Ru omanda-vy, he'i judeu kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Upe va'e nhe'ẽ ohendu ramo, omombe'u joavy avy judeu kwéry: ");
INSERT INTO kgkNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Ojepota-ma ra'e hese anháy, he'i. —Itavy voi. Ma'erã po pehenduse inhe'ẽ? he'i hese heta oĩ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Outro kwéry he'i: —Anháy ojepota hese va'e nonhe'ẽi ha'e-rami. Anháy rerekoha ndikatúi ombohesa jevy hesapyso e'ỹ va'e-pe, he'i ojóupe hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ha upéi katu oiko-ma Jerusalém tetã-my judeu kwéry arete. Nhandejáry róga kakwaa nhamoatyrõmba hagwe áry arete héry va'e. Upe ramo ro'y eterei voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ha Hesu katu ogwata oiko-vy Nhandejáry róga kakwaa-py. Ogapy onhemboty e'ỹ va'e gwy-py, Salomão onhehenói va'e gwy-py ogwata oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Upe-ma ramo ogwahẽ ou-vy judeu ruvixa kwéry. Ogwata jave Hesu, ogweroajere íxupe hikwái: —Are gwive ko'ánga ete peve orojapura eremombe'u hagwã ore-vy kiva'e tipo nde oroikwaa porã hagwã. Emombe'u porã katu ore-vy, he'i. —Nde tipo Cristo voi ore remiha'arõ va'e? he'i oporandu-vy íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Upéi Hesu he'i íxupe kwéry: —Xe jehegwigwa nhe'ẽ amombe'u kuri peẽ-my. Ha ndaperoviái voi xe nhe'ẽ. Xe Ru réry-py xe rembiapo porã va'e. Pende rexapyrã-rupi xe rembiapo. Upe va'e pehexa ramo, ma'erã peje xe-rehe, “Hesu nipo ndaha'éi Cristo ra'e” peje kuri xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","—Xe rymba kwéry e'ỹ va'e-rami peiko va'e xe-vy. Xe re'ýi e'ỹ va'e peẽ. Upéa-gwi ndaperoviáiry xe nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Xe rymba kwéry xe nhe'ẽ renduha va'e voi. Peteĩ teĩ va'e-pe aikwaa. Xe rupive oje'ói va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Xe rymba gwive amoingove va'e Nhandejáry ndive opa e'ỹ reheve opyta hagwã. Mombyry oréhegwi noĩry va'erã. Xe po pyte-py xe rembiereko meme voi. Ha ndikatúi ogweraha avave xe po pyte-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Upéa xe Ru remimonhangareko uka xe-vy ime'ẽ-vy. Ha'eixagwa ndaipóri. Ipo pyte-py xe Ru rembiereko voi. Ha ndikatúi ogweraha avave ipo pyte-gwi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","—Xe xe Ru ave peteĩxa, he'i judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Upéa he'i-ma ramo, ojapi hagwã íxupe, ita oipyhy hikwái. Ojukase íxupe mo'ã hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ha Hesu he'i: —Pene pa'ũ-rupi heta xe rembiapo porã. Xe Ru nhe'ẽ-py ahexa uka peẽ-my xe ajapo porãha. Kiva'eixagwa-rehe po xe api apise peẽ? he'i judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Ndorojapi mo'ãi ne rembiapo porã-rehe. Nhandejáry-rehe erenhe'ẽ rei hagwe-rehe ae orojapi-ta. Teko rei jepe erenhemonhandejáry ra'anga anga rei ereiko-vy. Upéa-rehe orojapise, he'i mo'ã íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Upe-ma ramo omombe'u judeu ruvixa kwéry-pe Nhandejáry nhe'ẽ: —Nhandejáry kwatia nhe'ẽ, pehendu va'e he'i no'ã-rami: “Tupã kwéry voi peẽ, ha'e-ma peẽ-my” he'i Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ha Nhandejáry nhe'ẽ anhetegwa tee va'e he'i meme. Upéa jaikwaa voi. Pejeapysaka katu xe nhe'ẽ-rehe. Gwĩ inhe'ẽ renduha-pe tupã kwéry-py ohenói va'ekwe Nhandejáry. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Xe katu Nhandejáry rembiporavo ko yvy-py hemimbou voi xe. Ha, Nhandejáry ra'y voi xe, ha'e ramo xéjehe, ndapejohu porãi va'erã voi xe nhe'ẽ. Teko rei-pe tupã kwéry-py ohenói rei va'ekwe Nhandejáry. Aipo ramo, ma'erã po, “Erenhe'ẽ rei rei ereiko-vy Nhandejáry-rehe” peje joty xe-vy, “Nhandejáry ra'y voi xe, ere ramo”. Ma'erã aipo peje joty xe-vy? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","—Xe Ru rembiapo ajapo e'ỹ ramo, ani xe rerovia teĩ peẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","—Ha hembiapo voi katu ajapo ramo, xe rerovia katu peẽ. Ha naxe reroviái ramo jepe peẽ, pejerovia joty katu xe rembiapo porã-rehe. Aipo ramo peikwaa porã-ma arã voi ore rekoha peiko-vy. Peteĩxa xe moirũ xe Ru oiko-vy. Ha xe katu amoirũ peteĩxa xe Ru aiko-vy. Upe va'e peikwaa porã arã, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Upéa he'i-gwi, oipyhyse jevy mo'ã íxupe hikwái. Ha judeu kwéry ndaipu'akái hese oipyhy hagwã. Osẽ oho-vy íxugwi kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ha upéi katu oho jevy Jordão ysyry rovái. João Batista oporomongarai hagwe-py oho. Upe-py opyta. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Oiko jave upe-py, heta ou oheka-vy: —Jahexa e'ỹ va'e ndojapói va'ekwe João. Ha Hesu-rehe hemimombe'u gwive anhetegwa nipo ra'e, he'i João-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Upéa-gwi upe-py heta oĩ ojerovia-ma va'e Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ha upéi katu oĩ hasy va'e Lázaro héry va'e. Oiko Betânia tetã'i-my. Upe-py oiko ave heindýry Maria, heindýry Marta ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Upéa Maria Nhandejáry Hesu py omohyakwã va'erã. Ho'a vuku apy-py oikyty va'erã ipy omokã hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Upe va'e Maria tykéry Marta ndive omomarandu uka Hesu-pe: —Porombo'eháry, ha'e ko ne rembiayhu va'e hasy-ma, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Upéa ohendu ramo: —Omano hagwã-rami ndahasýi. Hasy-ma ae oĩ-vy Nhandejáry ohexa uka hagwã gwembiapo porãha. Hasy-gwi xe Nhandejáry ra'y va'e ahexa uka va'erã ave xe rembiapo porãha anhembotuvixa mba'e hagwã, he'i hasy va'e-rehe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ha Marta Hesu rembiayhu voi. Ikypy'ýry ikyvy ave hembiayhu ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ha upéixa ramo jepe oikwaa-ma ramo Lázaro hasymaha, opyta joty upe oĩ ha-py. Mokõi áry opyta joty upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Upe rire ae he'i gwemimbo'e kwéry-pe: —Jaha jevy katu Judéia yvy-py, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Nde api apise kuri mo'ã ita-py judeu ruvixa kwéry, porombo'eháry. Ma'erã po erehose jevy joty ha'e kwéry oĩ ha-my? he'i íxupe hemimbo'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Upéi he'i ha'e: —Áry ramo hesakã meme voi. Jahexa nhande resapeha. Upéa-gwi jagwata porã nhanhepysanga e'ỹ reheve. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ha pyhare katu nhande resapeha e'ỹ reheve jaiko. Upéa-gwi jagwata ramo, nhanhepysanga ramo, ja'a arã, he'i ójehe omanotaha áry-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Upéa he'i rire, Lázaro rehegwa omombe'u gwemimbo'e kwéry-pe: —Oke oĩ-vy nhande rapixa Lázaro. Aha-ta amombáy íxupe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Oke oĩ-vy ramo, okwera arã, ore Járy, he'i íxupe hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ha Hesu omombe'u Lázaro omanoha rehegwa nhe'ẽ okeha rehegwa nhe'ẽ-rami. Ha hemimbo'e kwéry katu mbava'e-pe po he'ise Hesu nhe'ẽ ndoikwaái voi: “Lázaro oiko porã oke jave” he'i mo'ã ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Upéa-gwi omombe'u porã íxupe kwéry omano hagwe: —Omano ete-ma Lázaro, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","—Naiméi-gwi omano jave, avy'a joty xe. Naiméi-gwi pejerovia va'erã xe-rehe. Upéa-rehe avy'a. Omano jepe jaha katu jahexa íxupe, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","—Jaha katu nhande ave nhamano hagwã indive, he'i hapixa kwéry-pe Hesu-rehe Tomé. Dídimo héry ave Tomé. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Upe ramo oho oje'ói-vy Betânia tetã'i-my. Upe-py ogwahẽ ramo Hesu, Lázaro retekwe omoĩ-ma ra'e oheja-vy itakwa-py. Ojapo irundy áry oheja hagwe upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ha Jerusalém hi'agwĩ oĩ Betânia tetã'i-gwi. Mbohapy quilômetro para'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Upéa-gwi heta judeu kwéry ou Jerusalém-gwi omoirũ hagwã Marta-pe ikypy'ýry ndive. Ou pono omboasy eterei okyvýry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ha upéi katu ogwahẽ-tama Hesu Marta renda-py. Oikwaa-ma ramo Hesu ogwahẽtaha ou-vy, oho ohogwaitĩ íxupe. Ha ikypy'ýry katu opyta hóga-py. Ha upéi Marta ogwahẽ ohogwaitĩ-vy Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","—Ereime ramo ra'e a-py, xe Járy, nomanói arã ra'e xe kyvy, he'i Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","—Omano jepe, erejerure va'e-rehe gwive, ome'ẽ arã voi nde-vy Nhandejáry. Upéa aikwaa voi, he'i íxupe Marta. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Oikove jevy va'erã nde kyvy, he'i Marta-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Ha'e voi. Aikwaa voi upéa. Jaikove jevy va'eha áry-py oikove jevy va'erã, he'i íxupe Marta. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Upéi Hesu he'i: —Xe ko apomoingove jevy va'ety. Apomoingove meme va'ety voi xe. Xe-rehe ojerovia va'e gwive omano ramo jepe, xe ndive oikove meme va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","—Xe ndive oikove va'e gwive, xe-rehe ojerovia va'e gwive nomano mo'ãvéi-ma. Ha omano ramo katu, namombyry mo'ãi voi opyta xéhegwi. Xe moirũ va'erã voi opa e'ỹ reheve. Ererovia tipo ko xe nhe'ẽ? he'i Marta-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Ha'e. Arovia-ma, xe Járy, he'i. —Cristo voi nde nipo ra'e. Nhandejáry ra'y voi nde ra'e. Ko yvy-py ou va'erã va'ekwe voi nde nipo ra'e, he'i Hesu-pe Marta. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Upéa he'i rire oho ohenói okypy'ýry. Íxupe anho he'i: —Ogwahẽ-ma ou-vy porombo'eháry. Ne renói-ma, he'i nhemi okypy'ýry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Inhe'ẽ ohendu-ma ramo, pya'e opu'ã oho-ma Hesu ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ha Hesu nogwahẽi vyteri tetã'i-my. Oĩ joty Hesu Marta ohogwaitĩ íxupe hagwe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ha upéi katu ikypy'ýry Maria opu'ã osẽ pya'e oho iha-py. Ohexa ramo hupive oho ave judeu kwéry hóga-py oĩ va'e, omoirũ hagwã íxupe ou va'ekwe: —Oho-tama ijyta-py Maria ojahe'o hagwã upe-py, he'i mo'ã hese hikwái. Upéixa ramo oho hupive hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Upéi ogwahẽ oho-vy Hesu renda-py. Ogwahẽ-ma ramo, ojeity Maria Hesu rovagwy-py: —Ereime ramo ra'e a-py, xe Járy, nomanói arã ra'e xe kyvy, he'i íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Upe ramo ha'e ohexa Maria hasẽ ramo. Indive oĩ va'e judeu hasẽ ramo ohexa ave. Ohexa ramo, ndovy'avéi-ma. Ndaipy'agwapyvéi-ma voi Hesu: ");
INSERT INTO kgkNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—Kipy pemoĩ ra'e omano va'ekwe-pe, he'i oporandu-vy upe pygwa-pe. —Eju katu erehexa hagwã, porombo'eháry, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hesa'y-ma Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Aipo ramo: —Hembiayhu tee voi nipo ra'e, he'i omano va'ekwe-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Outro he'i: —Hesapyso e'ỹ va'ekwe-pe ombohesa kuri. Mba'éixa Hesu ndojapói Lázaro-rehe ombogwera hagwã? he'i Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Upe ramo ndaipy'agwapy etéi jevy-ma Hesu oho Lázaro retekwe ombosuru hagwe-py. Omoĩ araka'e itagwasu omboty hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Peipe'a katu imbotyha, he'i Hesu. —Ani ereipe'a teĩ. Ine-ma voi ra'e, xe Járy, he'i íxupe. —Xáke ine-ma voi. Ojapo irundy áry ombosuru hagwe, he'i íxupe Marta, omano va'ekwe reindykwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Upéi Hesu he'i: —Ha'e-ma kuri nde-vy, Xe rerovia ramo ojehexa uka va'erã nde-vy Nhandejáry. Tuvixa mba'eha-rupi ojehexa uka va'erã nde-vy, he'i Marta-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Upe ramo oipe'a ita imboty hagwe hikwái. Ha Hesu hovayva-ma oĩ-vy yvate-koty: —Erehendu-ma kuri xe nhe'ẽ, xe Ru, he'i Nhandejáry-pe. —Upéa-gwi atima porã nde-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","—Xe rendu meme va'e nde. Aikwaa. Upéa ha'e-ma a-py ijaty va'e ohendu hagwã, he'i hagwã xe-rehe, “Nhandejáry remimbou nipo ra'e ha'e” he'i hagwã xe-rehe, he'i Nhandejáry-pe oração apo-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Upéa he'i rire, he'i: —Lázaro, esẽ katu, he'i onhe'ẽ hatã-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Upe-ma ramo osẽ ou-vy omano va'ekwe. Onhenhugwãmba-ma ipy ipo ave ou-vy. Ohovami ra'e ao-py íxupe: —Pejora katu íxugwi oho hagwã, he'i upe pygwa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ha heta oĩ judeu Marta pohuháry ou va'ekwe. Hesu rembiapo ohexa ramo, ojerovia tee-ma hese oiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ha ojerovia e'ỹ va'e katu oho jevy fariseu kwéry-pe omombe'u Hesu rembiapokwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Upe-ma ramo ojogweroaty fariseu kwéry pa'i ruvixa kwéry ndive: —Jahexa e'ỹ va'e heta ojapo va'e Hesu. Mbava'e po jajapo-ta hese? ");
INSERT INTO kgkNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Anive erejapo teĩ koixagwa, ndaja'éi ramo íxupe, enterove ojerovia tee arã hese, he'i. —Aipo ramo, mburuvixa kwéry romano va'e omanda pohýi arã nhande-rehe kwéry. Ohundi arã Nhandejáry róga kakwaa nhamboete haty-py. Nhane retã ave ogwereko asy arã. Omosẽmba va'erã nhande ruvixa kwéry hekovia omanda mbaraeteve hagwã nhande-rehe, he'i ojóupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Upe ramo he'i íxupe kwéry Caifás. Upe ánho-py pa'i ruvixagwasu voi Caifás. Ha upéi he'i: —Mba'eve ndapeikwaáiry voi peẽ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","—Pejeapysaka katu xe nhe'ẽ-rehe. Nhane retã retã gwive ogwereko asy ramo, naiporãi arã nhande-vy. Nhande-vy iporãve arã nhande rekovía peteĩ va'e omano ramo, he'i Hesu-rehe ojogweroaty va'e-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Upéa he'i-ma ramo nomombe'úi ojehegwigwa. Upe ánho-py oiko pa'i ruvixagwasu ramo. Upéa-gwi Hesu rekorã-rehe omotenonde uka íxupe Nhandejáry: “Judeu kwéry rekovia omano va'erã Hesu” he'i ojehegwigwa e'ỹ va'e omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ndaha'éi judeu kwéry rekovia mante omano va'erã Hesu. Entéro Nhandejáry re'ýi kwéry opa-rupi osarambi va'ekwe rekovia ave omano va'erã. Henda henda-rupi peteĩxa ijoja hagwã oiko-vy omano va'erã Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Upéa-gwi upe va'e áry gwive onhombo'e mbo'e-ma okwa-vy mburuvixa kwéry judeu va'e ojuka hagwã íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Upéa-gwi ndogwatavéi-ma judeu kwéry oĩ ha-rupi. Oho oje'ói-vy tekwaty e'ỹ-koty. Efraim tetã-my oho. Upe-py gwemimbo'e kwéry ndive opyta. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ha upéi katu oiko-tama aretegwasu páscoa héry va'e, Egito yvy-gwi judeu rembypy osẽ hagwe áry arete héry va'e. Ne'írã oiko jave arete, heta judeu oho Jerusalém-my. Gweko-py oho. Tenondeve oho onhemopotĩ uka hagwã Nhandejáry róga kakwaa-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ogwahẽ ramo upe-py osareko reko Hesu-rehe hikwái: —Emombe'u katu ore-vy Hesu rehegwa nhe'ẽ. Ou-ta para'e. Tapa ndou mo'ãi katu Nhandejáry róga kakwaa-py, peteĩ teĩ he'i ojóupe Nhandejáry róga-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pa'i ruvixa kwéry fariseu ndive oipyhyse íxupe. Upéa-gwi he'i: —Ereikwaa ramo oimeha, emombe'u katu ore-vy, he'i Hesu-rehe omanda-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ha upéi katu oiko-ta aretegwasu páscoa héry va'e. Seis áry rire oiko-ta. Upe ramo Hesu ogwahẽ oho-vy Betânia tetã'i-my. Upe-py oiko Lázaro Hesu remimoingovekwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Upe-py ogwahẽ rire Hesu, omongaru porã íxupe. Ha Marta ogweroja íxupe hemi'urã oiko-vy. Heta Hesu karu irũ. Ipa'ũ-my ave okaru Lázaro. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Upe ramo Lázaro reindy Maria ogweru hyakwã porã tee va'e, nardo héry va'e. Hyru reheve peteĩ litro ogweru. Upe va'e hyakwã porã va'e hepy va'e. Upéi Maria onhohẽ Hesu py-rehe, omohyakwã-vy ipy. Upe rire ho'avuku-py oikyty ipy omokã hagwã. Ha ohasapa hyakwã. Ojohupa koty hyakwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Upe-ma ramo he'i Judas Iscariotes, Hesu mombe'uharã ipyhyharã-pe: ");
INSERT INTO kgkNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Hepy eterei hyakwã va'e. Ma'erã nome'ẽi hepy-rehe ra'e? he'i. —Doze jasy omba'apo va'ekwe repy upe va'e. Ma'erã po nome'ẽi ra'e iporiahu va'e-pe hyakwã va'e repy? he'i mo'ã Judas hyakwã va'e-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ndaha'éiry ome'ẽse-gwi iporiahu va'e-pe. Imondaháry voi Judas. Pirapire ryru-rehe onhangareko va'e. Ha hyru-py oĩ va'e omonda monda oiko-vy va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Upe ramo he'i Hesu: —Ani nde poxy teĩ Maria-rehe. Eheja taxe mohyakwã. Heko-rupi ha'e ou. Xe mohyakwãse rei amano e'ỹ ngatu. Upéa-gwi gweminhongatu omoĩ xe-rehe, he'i judeu rekoha-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","—Oiko meme pene pa'ũ-rupi iporiahu va'e kwéry. Peme'ẽse ramo, peme'ẽ va'erã íxupe kwéry. Xe ae ndaiko are mo'ãi pene pa'ũ-rupi, he'i upe pygwa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ha upéi katu heta ijaty va'e, judeu kwéry va'e, ohendu Hesu oimeha Betânia tetã'i-my. Upéa-gwi oje'ói ohexa-vy. Lázaro-pe, Hesu remimoingovekwe rexa-vy ave oje'ói. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ha pa'i ruvixa kwéry katu oje'ói ohexa va'e ndojohu porãi: —Heta judeu ko nanhane moirũvéi-ma, he'i. —Hemimoingovekwe-gwi ojehesa rerova-ma oiko-vy Hesu-rehe. Ojerovia-magwi, ojehesa rerova-ma hese, he'i Hesu-rehe Lázaro-rehe ave. Upéa-gwi onhombo'e mbo'e-ma Lázaro-pe ave ojuka hagwã hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","(y 17-18) Iko'ẽ-my heta oĩ ijaty va'e Jerusalém-my oho va'ekwe, páscoa aretegwasu-py oho va'ekwe. Upe ramo ohendu-ma Hesu rerakwã hikwái: —Ogwahẽ-tama ou-vy Hesu, he'i ijaty va'e-pe Hesu rerakwã omombe'u-vy. Upe-py oĩ Hesu rembiapo porã rexahare. Omoirũ ra'e Hesu-pe ohenói ramo Lázaro-pe oyta-gwi osẽ jevy hagwã. Omoingove jevy jave Lázaro-pe, omoirũ ra'e íxupe hikwái. Upéa-gwi omombe'u mbe'u herakwã. Ha upéi katu henduhare oho ohogwaitĩ-vy íxupe: —Jahexa e'ỹ va'e opu'akaha-py ojapo kuri Hesu, he'i hese omombe'u-vy. Upéa-gwi oho ohogwaitĩ-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Upe-ma ramo gwĩ henduhare oikytĩ heraha-vy pindo rogwe hakã reheve. Ohogwaitĩ-vy oho. He'i: —Tonhemomba'egwasu katu Nhandejáry, he'i onhe'ẽ hatã-vy hikwái. —Nhandejáry réry-py ou va'e-pe tohovasa katu, he'i. —Nhande ruvixarã-pe tohovasa katu. Nhande Israel kwéry ruvixagwasurã-pe tohovasa, he'i Hesu-rehe onhe'ẽ hatã hatã-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ha upéi katu Hesu ojohu gwenagwã mburika ra'y ojeupi hagwã hi'ári. Upéixa ete omombe'u va'ekwe Nhandejáry kwatia nhe'ẽ Hesu rehegwarã nhe'ẽ: ");
INSERT INTO kgkNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ani pekyhyje teĩ, he'i Sião mygwa-pe, Pene ruvixagwasurã ko ogwahẽ-ma ou-vy mburika ári ou. Upéa-gwi ani pekyhyje teĩ” he'i Nhandejáry nhe'ẽ Jerusalém pygwa-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Upéixa voi he'i va'ekwe Nhandejáry kwatia nhe'ẽ Hesu rekorã omombe'u-vy. Ha hemimbo'e ndoikwaái voi ra'e Hesu rekorã rehegwa nhe'ẽ. Mburika ári oho ramo, mbava'e-pe po he'ise upe va'e ndoikwaáiry voi. Ha onhembotuvixa mba'e rire katu Hesu, oikove jevy rire katu, imandu'a jevy Nhandejáry kwatia nhe'ẽ-rehe hikwái. Hesu rekorã rehegwa nhe'ẽ-rehe imandu'a jevy hikwái. Upe ramo: —Nhandejáry kwatia he'i hagwe-rami oiko nipo ra'e Hesu-pe. Hesu-pe jajapo va'ekwe, Nhandejáry nhe'ẽ-rupi jajapo nipo ra'e íxupe, he'i omombe'u ojóupe hemimbo'e kwéry. Ha mburika ra'y ári ou jave omboete ete Hesu-pe ijaty aty va'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","(-) ");
INSERT INTO kgkNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ha fariseu kwéry: —Erehexa pa? Enterove va'e ko ojehesa rerovapa-ma hese hikwái. Ha ojehesa rerova hagwã hese ndikatúi jajoko, he'i ojóupe fariseu kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ha Jerusalém-py ogwahẽ ogwa'ẽ-vy heta eta va'ekwe aretegwasu mboeteha. Ipa'ũ-my oĩ ave gwĩ judeu e'ỹ va'e grego-py onhe'ẽ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Upe ramo ou Filipe oĩ ha-py. Filipe Galiléia yvy pygwa voi. Betsaida tetã mygwa voi. Ha upéi: —Mba'ejáry, orohexase Hesu-pe, he'i Filipe-pe. Oporandu jevy jevy oho hagwã-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Upe ramo oho omombe'u André-pe. Upéi mokõive oho omombe'u Hesu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Inhe'ẽ ohendu ramo, he'i Hesu: —Xe Nhande Ryke'y tee va'e. Ogwahẽ-ma anhemomba'egwasu ukaha óra, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","—Amombe'u-ta peẽ-my anhetegwa tee va'e. Xejehegwa amombe'u-ta trigo ra'ỹi rehegwa nhe'ẽ-rami. Trigo ra'ỹi nhanhotỹ va'e yvy-py henhói hagwã. Henhói e'ỹ ramo trigo ra'ỹi mante oĩ. Peteĩ mante oiko. Ha henhói ramo katu ndoikovéi-ma ha'ỹigwe. Ndoikovéi ójehe. Henhói ijagwyje hagwã, onhembohetave hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","—Upéixa ete gwekove-rehe hakate'ỹ va'e, ojehéte oiko va'e, onhehundipa rei va'erã hekove. Ndotopái va'erã gwekove repyrã. Ha gwakate'ỹ hagwã gwekove-rehe nopenái va'e katu ko yvy ári, omoĩ ngatu va'erã gwekove Nhandejáry ndive oiko opa e'ỹ reheve hagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","—Xe rembigwái ramo oikose va'e gwive taxe moirũ katu, he'i. —Upéixa ramo xe aime ha-rupi, xe ndive oiko va'erã ave xe rembigwái. Xe rembigwái va'e gwive omboete va'erã íxupe xe Ru, he'i upe pygwa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ha upéi katu he'i jevy upe pygwa-pe Hesu: —Ko'ánga katu ajepy'apy-ma xéjehe, he'i. —Ndaxe py'agwapyvéi-ma xéjehe. Mbava'e po ha'e-ta xe Ru-pe, ndaikwaái. Ha'e-ta para'e, Xe resende katu xe áry-py. Xe amano hagwã áry-py xe resende katu, ha'e-ta para'e. Nahániry. Xe resende katu, aipo nda'e mo'ãiry. Amano hagwã-ma agwahẽ aju-vy xe óra-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","—Tomomba'egwasu uka nde réry, he'i Gwu-pe. Upe-ma ramo ohendu yváy-gwi onhe'ẽ va'e: —Xe réry amomba'egwasu-ma kuri. Ãy amomba'egwasu jevy-ta, he'i upe pygwa-pe Túvy. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ha ijaty va'e ohendu ave onhe'ẽ va'e. Hyapu va'e-rami ae ohendu inhe'ẽ: —Hyapu-ma. Osunu-ma, he'i mo'ã yváy pygwa nhe'ẽ rendu-vy hikwái. Outro he'i: —Nhandejáry rembigwái yváy pygwa omombe'u íxupe, he'i mo'ã onhe'ẽ va'ekwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Upéixa ramo he'i Hesu: —Ndaha'éiry xe-vy anho omombe'u va'ekwe. Peẽ-my ave omombe'u onhe'ẽ va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","—Ãy ogwahẽ-ma ãygwa óra. Yvypóry-pe ahexa uka-tama hekoha vaiha. Ha yvypóry ruvixa-pe amosẽ-tama imondo-vy, he'i anháy ruvixa-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","—Ha xe ko, ko yvy-gwi xe rupi rire kurusu-rehe, anhemoirũ uka-ta entéro kente kwéry-pe, he'i ijaty va'e-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Upéa he'i kurusu-rehe omanotaha omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ha upéi he'i íxupe ijaty va'e kwéry: —Nhandejáry kwatia nhe'ẽ, orohendu va'e, he'i no'ã-rami, “Nomanói va'erã Cristo. Oiko meme va'erã opa e'ỹ-rehe” he'i. Upéixa ramo ma'erã, “Ohupi va'erã omoĩ-vy ko yvy-gwi Nhande Ryke'y tee va'e-pe” ere kuri ore-vy? Kiva'e po ko Nhande Ryke'y tee va'e, ndoroikwaái, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Upéi he'i Hesu: —Sapy'a apombo'eve-ta ohesape va'e-rami. Ha upe rire katu, aha jevy-ma va'erã, he'i. —Pene pa'ũ-rupi xe aime jave, arakatu-rupi oiko va'e-rami tapeiko kena. Arakatu-rupi peiko ramo, ndapeikói va'erã hesapyso e'ỹ oiko va'e-rami. Pytũ-rupi oiko va'e gwive ndohexáiry gwaperã. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Apohesape jave pejerovia katu xe-rehe. Upéixa peiko-ma va'erã arakatu-rupi meme oiko va'e-rami, he'i ijaty va'e-pe Hesu. Onhe'ẽ oĩ-vy rire onhemo'ã-ma oho-vy Hesu. Ijaty va'e-gwi okanhy-ma oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Heta jahexa e'ỹ va'e gwive hexapyrã-rupi voi ojapo-ma. Ohexa jepe, ndojerovia etéi voi hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yma va'ekwe omoĩ kwatia-rehe. Hesu rekorã omoĩ va'ekwe Nhandejáry nhe'ẽ-py omombe'u va'ety héry va'e Isaías. Ohai va'ekwe no'ã-rami: “Kiva'e po ogwerovia nhane remimombe'u, xe Járy? Kiva'e-pe po ohexa uka Nhandejáry ipu'akaha?” he'i Nhandejáry nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Upéa-gwi hembihaikwe-rami ndogweroviáiry ave Hesu nhe'ẽ hikwái. Ohai jevy va'ekwe Isaías no'ã-rami: ");
INSERT INTO kgkNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ogwerovia e'ỹ va'e-pe omoingo Nhandejáry pytũ-rupi. Inharandu porãrãgwe oipe'apa íxugwi. Upéa-rehe hesapyso e'ỹ va'e-rami oiko. Nahi'arandu porãi voi. Ndojeréi Nhandejáry-rehe omoirũ hagwã íxupe, Nhandejáry ombogwera hagwã íxupe kwéry” he'i Nhandejáry nhe'ẽ. Upéixa ete ohai va'ekwe judeu rekorã Isaías amyrĩ. Upéa-gwi ohai hagwe-rami ndikatúi ojerovia Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ha Isaías upéte ojehexa uka va'ekwe Hesu rekoha. “Tuvixa mba'e” he'i Hesu rexa-vy. Upéa-gwi omoĩ va'ekwe kwatia-rehe Hesu rehegwarã. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Judeu kwéry ndogweroviái ramo jepe, heta oĩ mburuvixa judeu va'e ojerovia joty hese. Ha atýra-py katu nomombe'úiry ojeroviaha. Ikyhyje fariseu kwéry-gwi. Nonhemosẽ ukaséi ojeporahéi haty haty-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Onhemboete ukase ramo jepe Nhandejáry-pe, ojehexa uka porãse ave oiko-vy teko rei-pe. Upéa-gwi nomombe'úiry ojeroviaha atýra-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ha upéi katu onhe'ẽ hatã Hesu: —Xe-rehe ojerovia tee va'e gwive ojerovia xe mbouhare-rehe ave. Ndaha'éiry xe-rehete anho ojerovia va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","—Xe reko ohexa kwaa va'e gwive, xe mbouhare reko ohexa kwaa ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yvypóry kwéry-pe ahesape hagwã aju va'ekwe xe-rehe ojerovia tee va'e gwive oiko e'ỹ hagwã pytũ-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Xe remimombe'u renduse e'ỹ va'e gwive, namombe'u mo'ãi íxupe hekoha vaiha. Ndajúi va'ekwe yvypóry rekoha vai mombe'u-vy. Aresende-vy ae aju va'ekwe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","—Ha xe nhe'ẽ mbojevy va'e gwive, xe nhe'ẽ nohenduséi va'e gwive, oikwaa va'erã gwekoha vaiha. Xe aju jevytaha áry-py oikwaa va'erã gwembiapo vaikwe. Ãy xe remimombe'u nohenduséi-gwi ombohasa asy va'erã íxupe kwéry Nhandejáry, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","—Xe jehegwigwa namombe'úi va'e. Xe Ru nhe'ẽ ae amombe'u. Xe Ru xe mbouhare omombe'u xe-vy xe nhe'ẽrã. Xe remimombe'urã ave omombe'u xe-vy. Upéa-gwi xe aju jevytaha áry-py xe nhe'ẽ nohenduséi-gwi ojekwaapa va'erã íxupe hembiapo vaikwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ha xe Ru omombe'u va'e xe-vy xe nhe'ẽ katu ohendu va'e gwive amoingove va'erã íxupe Nhandejáry ndive opa e'ỹ reheve oiko hagwã. Xe jehegwigwa nhe'ẽ namombe'úi. Xe nhe'ẽrã xe Ru omombe'u va'ekwe ae amombe'u voi xe, he'i Hesu upe pygwa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ha upéi katu ogwahẽ-tama aretegwasu héry va'e páscoa. Ogwahẽ-ma Hesu omanoha óra oheja hagwã ko yvy oho-vy. Ojeupi jevy-tama oho-vy Gwu oiko ha-py. Upéa oikwaa voi Hesu. Ko yvy pygwa he'ýi va'e hembiayhu meme voi. Meme ete ohayhu íxupe kwéry. Omano peve ohayhu. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Okaru jave gwemimbo'e kwéry ndive, anháy ruvixa anhaygwasu ombo'e ra'e Simão ra'y Judas Iscariotes-pe. Omomandu'a uka ra'e Hesu pyhyharã-rehe: —Emombe'u katu Hesu oimeha a-py. Ipyhyharã-pe emombe'u katu, he'i ra'e íxupe anhaygwasu. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ha Nhandejáry omoingo ra'e Hesu-pe enterove va'e ruvixarã. Upéa oikwaa voi Hesu. Nhandejáry-gwi voi ou ra'e. Ko'ánga oho jevy-tama Nhandejáry oiko ha-py. Upéa oikwaa voi ave Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Upe-ma ramo opu'ã omboi oao jo'a. Oipyhy jepykytyhaty. Gwumby-rupi omoĩ oku'a jopy hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Upéi hyrurã-py y onhohẽ oipyhéi-ma peteĩ teĩ gwemimbo'e kwéry-pe oipyhéi. Peteĩ teĩ oipyhéi rire omokã jepykytyhaty-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ogwahẽ ramo Simão Pedro renda-py: —Nde ko xe pyhéi-ta tipo, xe Járy? he'i íxupe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Ko'ánga ndereikwaái voi mbava'e po xe ajapo-ta nde-rehe. Ha nde-vy oikwaa ukataha óra-py ereikwaa va'erã, he'i Simão Pedro-pe. Upe ramo he'i: ");
INSERT INTO kgkNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—Xe ko apa e'ỹ ngatu nde ndaxe pyhéiry va'erã, he'i íxupe Pedro. —Ndoropyhéiry ramo, naxe moirũ mo'ãvéi-ma voi nde, he'i Pedro-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—Aipo ramo, he'i —xe pyhéi katu, xe Járy. Upéi xe pohéi mani ave, he'i. —Xe akãhéi mani ave, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Upe ramo Hesu he'i: —Ne nhe'ẽ katu ndajapo mo'ãi. Jajahu rire, nhane potĩ-ma voi, he'i. —Nhande jajahu rire, nhande rete gwive ipotĩ. Upéixa ramo nhande py mante jaikyty. Upéixa ete peteĩ teĩ pende py'a onhemopotĩ-ma ãy. Ha peteĩ va'e katu opyta ipy'a ky'a reheve. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Upéa he'i kiva'e po oikwaa uka-ta ipyhyharã-pe oikwaa-gwi voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ha upéi katu oipyhéi rire omonde jevy oao jo'a omoirũ jevy hagwã íxupe kwéry: —Peikwaa tipo mbava'e ajapo kuri pende-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","—Peẽ, “Ore mbo'eháry” peje voi xe-rehe. “Ore járy” peje xe-rehe. Peje porã voi, he'i. —Pene mbo'eháry voi xe. Pende járy ave voi xe, he'i. —Peje porã voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","—Pende járy jepe, pene mbo'eháry jepe apopyhéi joty kuri, he'i. —Upéa-gwi iporã pejopyhéi. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Oropyhéi ranhe xe reko ra'ã hagwã peẽ, peiko hagwã-ma xe rekoha-rupi, penhopytygwõ hagwã tembigwái-rami. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Amombe'u-ta peẽ-my anhetegwa tee va'e. Ani, “Hembigwái voi xe jepe, xe járy-gwi tuvixave va'e voi xe” peje mo'ã pende py'apy-py. “Hemimondo voi xe jepe, xe mondohare-gwi tuvixave va'e voi xe” ani aipo peje mo'ã pende py'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pene rembiaporã peikwaa voi. Upéa pejapo ramo pevy'a va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Xe rembiporavo voi peẽ apokwaa voi. Ha pene pa'ũ-rupi oĩ peteĩ hembiapo porã e'ỹ va'e. Ovy'a va'erã, nda'éiry hese. Yma gwive he'i va'ekwe Nhandejáry nhe'ẽ upe va'e-rehe: “Xe karu irũ omoirũ-ma xe a'e e'ỹha-pe omoirũ” he'i Nhandejáry nhe'ẽ. Upéa-gwi Nhandejáry nhe'ẽ he'i hagwe-rami omoirũ-ma kuri xe a'e e'ỹha-pe xe irũ, he'i Judas Iscariotes-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","—Upéa ãy ha'e-ma peẽ-my peje hagwã xe-rehe, “Nhandejáry voi Hesu nipo ra'e” peje hagwã xe-rehe. Ne'írã ojehu xe-vy mba'eve. Ha ojehu rire katu, peje va'erã xe-rehe, “Hesu oikwaa ra'e ojehegwa nhe'ẽ ra'e. Nhandejáry voi Hesu nipo ra'e” peje va'erã xe-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","—Amombe'u-ta peẽ-my anhetegwa tee va'e. Xe remimondo omogwahẽ va'e, xe mogwahẽ ave. Ha xe mogwahẽ va'e xe mbouhare-pe omogwahẽ ave, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Upéa he'i rire, ndaipy'agwapyvéi-ma Hesu oiko-vy. Omombe'u porã gwemimbo'e kwéry-pe: —Amombe'u-ta peẽ-my anhetegwa tee va'e. Pene pa'ũ-rupi peteĩ va'e xe mombe'u va'erã xe pyhyharã-pe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Upe ramo osareko ojóehe hikwái. Kiva'e-rehe po he'i Hesu ndoikwaáiry. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ha xe katu Hesu remimbo'e, ijyke-rehe agwapy va'e. Xe Hesu rembiayhu voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Upe ramo Simão Pedro xe renói arepara hagwã hese. Upéi he'i: —Kiva'e-rehe tipo ere kuri, eporandu katu íxupe, he'i xe-vy Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Upe ramo ojoyke reheve aĩ ramo, ha'e Hesu-pe: —Kiva'e-rehe tipo ere kuri, xe Járy —ha'e Hesu-pe anho aporandu-vy. Ha Hesu he'i: ");
INSERT INTO kgkNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Upe ame'ẽ-ta va'e íxupe mbojape pehẽgwe amoakỹ rire. Upe va'e-pe ame'ẽ-ta, he'i xe-vy Hesu. Upe-ma ramo oipyhy-ma mbojape. Hyru-py omoakỹ rire ome'ẽ Simão Iscariotes ra'y Judas-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Upe-ma ramo Judas oipyhy rire íxugwi mbojape, oheko me'ẽ-ma íxupe anháy ruvixa anhaygwasu. He'i íxupe Hesu: —Ejapo pya'e katu erejapose va'e, he'i Judas-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ikaru irũ mbava'e-pe po he'ise Hesu ndoikwaái voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ha Judas katu pirapire ryru-rehe onhangareko va'e. Upéa-gwi he'i rei hese opy'apy-py hikwái: “Ojogwa-ta para'e nhane remi'urã” he'i rei hese. “Ome'ẽ-ta para'e iporiahu va'e-pe” he'i rei hese opy'apy-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ha Judas mbojape oipyhy rire-ma íxugwi, pya'e osẽ oho-vy. Pytũ-ma ramo osẽ oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Osẽ rire, he'i jevy Hesu gwemimbo'e kwéry-pe: —Ko'ánga xe Nhande Ryke'y tee va'e, aikwaa uka-ta peẽ-my xe rekoha porã tee. Xe-rehe ohexa kwaa va'e, ohexa kwaa ave Nhandejáry-rehe hekoha porã tee va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nhandejáry rekoha porã tee aikwaa-gwi, Nhandejáry oiko ha-rupi ohexa uka-ta enterove ohexapa va'erã xe rekoha porã tee. Ãy katu xe rekoha porã tee ohexa uka-tama, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","—Naxe are mo'ãi pene pa'ũ-rupi, xe ra'y kwéry. Aha rire, xe reka va'erã. Ko'ánga xe ha'e hagwe-rami judeu kwéry-pe, amombe'u-ta peẽ-my. Xe aha hagwã-py ndikatúi peho ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","—Ãy ame'ẽ-ta peẽ-my pende reko pyahurã: Pejohayhu rei katu. Xe apohayhuha-rami, pejohayhu katu peẽ ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pejohayhu peiko-vy ramo, “Hesu nhe'ẽ renduha tee voi nipo ra'e” entéro he'i va'erã pende-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ha upéi katu oporandu íxupe Simão Pedro: —Kipy tipo ereho-ta, xe Járy? he'i Hesu-pe. —Xe aha hagwã-py ndikatúi ereho ãy. Ha upe rire katu ereho va'erã xe rapykwéri, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Ma'erã tipo, xe Járy, ãy voi nderehejái aha nde rapykwéri, he'i íxupe. —Nde rekovía amano hagwã-rami aĩ, he'i íxupe Pedro. ");
INSERT INTO kgkNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—Upéa ere ramo, anhetegwa tipo ere xe-vy? he'i. —Amombe'u-ta nde-vy anhetegwa tee va'e. Ne'írã osapukái ramo gáju, ere mo'ã va'erã xe-rehe mbohapyha, “Ndaikwaái voi íxupe” ere mo'ã va'erã xe-rehe, he'i Pedro-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Upe ramo Hesu he'i jevy gwemimbo'e kwéry-pe: —Ndikatuvéi xe moirũ ramo jepe, anive pende py'agwapy e'ỹ peiko-vy. Pejerovia katu peiko-vy Nhandejáry-rehe. Pejerovia katu peiko-vy xe-rehe ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","—Xe Ru oiko ha-py heta oĩ jaiko hagwã. Ha ndaipóri ramo ra'e pene renagwã katu, amombe'u ave arã ra'e peẽ-my ra'e. Ha aha-tama amoĩ porã porã hagwã pene renagwã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","—Amoĩ porãmba rire katu, aju jevy arã pende-rehe apogweraha hagwã xe aiko ha-py peẽ ave peiko hagwã xe ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Xe agwahẽ hagwã-py peikwaa voi. Xe raperã peikwaa ave, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Upéi Tomé he'i: —Kipy po eregwahẽ-ta, ndoroikwaái voi, ore Járy. Upéa-gwi ndikatúi oroikwaa nde raperã, he'i íxupe Tomé. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Upéi Hesu he'i: —Xe ko Nhandejáry rape rexa ukaha voi, he'i ójehe. —Xe apu e'ỹ va'e. Anhetegwa mante mombe'uha voi xe, he'i ójehe. —Apomoingove va'e xe. Pene moingoveha voi xe, he'i ójehe Hesu. —Ojéhegwi rei nogwahẽi va'erã oho-vy xe Ru oiko ha-py avave. Ha xe ae araha ramo katu íxupe, ogwahẽ va'erã oho-vy xe Ru ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xe-rehe pehexa kwaa ramo ra'e, xe Ru-rehe pehexa kwaa ave arã ra'e. Ha ko'ánga katu pehexa kwaa-ma hese. Peikwaa-ma hekoha, he'i Tomé-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Upéi he'i Filipe: —Ehexa uka katu ore-vy nde Ru, ore Járy. Xe remiporandu va'e orohexa-ma ramo, orovy'a arã. Naporanduvéi-ma arã nde-vy, he'i íxupe Filipe. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Upe ramo Hesu he'i: —Xe are-ma voi pene pa'ũ-rupi aiko-vy. Ma'erã nderehexa kwaái vyteri xe-rehe, Filipe? Xe-rehe ohexa kwaa va'e, xe Ru-rehe ohexa kwaa-ma ave. Oikwaa-ma ave xe Ru-pe. Upéa-gwi ma'erã, “Ehexa uka katu ore-vy nde Ru” ere joty xe-vy. Ma'erã xe Ru erehexase joty? he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","—Xe reja e'ỹha voi xe Ru. Hembieja e'ỹ voi xe. Peteĩxa oronhomoirũ va'e voi, he'i. —Ma'erã po ndereroviái xe nhe'ẽ, he'i Filipe-pe. Upéi he'i jevy gwemimbo'e kwéry-pe: —Ndaha'éi xe jehegwigwa xe remimombe'u va'e peẽ-my. Xe Ru ae peteĩxa xe moirũ va'e. Xe Ru ae ojapo uka xe-vy xe rembiaporã. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Peteĩxa xe moirũ va'e xe Ru. Ha peteĩxa amoirũ va'e íxupe. Perovia katu xe nhe'ẽ. Ha ndaperoviaséi ramo jepe, pehexa-ma niko xe rembiapo porã. Upéa-rehe xe rerovia katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","—Amombe'u-ta peẽ-my anhetegwa tee va'e. Aha jevy-ta xe xe Ru oiko ha-py. Upéa-gwi xe-rehe ojerovia-ma oiko-vy va'e gwive, aipytygwõ va'erã íxupe kwéry. Xe rembiapo-rami hembiapo porã va'erã. Hembiapo porãve rãve va'erã katu aipytygwõ ramo íxupe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","—Oime raẽ va'e-rehe xe réry-py pejerure ramo, xe réry pehenói ramo, ajapo va'erã peẽ-my, aikwaa uka hagwã xe Ru rekoha porã tee peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Oime raẽ va'e-rehe pejerure ramo xe réry-py, xe-rehe pejerovia-gwi, ajapo va'erã peẽ-my, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Upéi he'i jevy Hesu: —“Xe rembiayhu va'e voi Hesu” peje ramo xe-rehe, xe nhe'ẽ pejapo-ma va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","—Xe nhe'ẽ pejapo ramo, xe ko ajerure va'erã xe Ru-pe pende-rehe. Xe rekovía ome'ẽ va'erã peẽ-my pene pytygwõharã. Pene ndive oiko meme hagwã ome'ẽ va'erã peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Upe va'e hemime'ẽrã Nhe'ẽ Marangatu tee va'e voi, anhetegwa tee va'e mombe'uha voi ha'e. Ha teko rei-pe katu nogwahẽ mo'ãiry ou-vy Nhe'ẽ Marangatu tee va'e. Ndohexa kwaái hese teko rei. Ndoikwaáiry íxupe. Ha peẽ katu peikwaa voi íxupe. Pene ndive oiko Nhe'ẽ Marangatu tee va'e. Pende py'apy-py oiko va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Pene tyre'ỹ hagwã ndapoheja mo'ãi. Pene renda-py aju jevy va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","—Ãy ndaxe rexa are mo'ãi ko yvypóry kwéry. Upe rire ndaxe rexa mo'ãvéi jevy-ma. Ndaxe rexái ramo jepe teko rei, peẽ katu xe rexa joty va'erã. Xe aikove jevy-ma va'erã. Upéa-gwi xe jave peikove ave va'erã peẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Xe aikove jevytaha áry-py peje va'erã xe-rehe, “Peteĩxa omoirũ nipo ra'e Gwu-pe. Peteĩxa nhamoirũ nipo ra'e Hesu-pe. Peteĩxa nhane moirũ nipo ra'e Hesu” peje va'erã xe-rehe, he'i. —Nhanhomoirũha peẽ peikwaa porã va'erã voi, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","—Xe nhe'ẽ renduha, xe nhe'ẽ apoha, xe rayhuha voi upe va'e. Ha xe rayhu va'e, ohayhu ave va'erã íxupe xe Ru ave. Xe ave ahayhu ave va'erã íxupe. Ajekwaa uka ave va'erã íxupe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Upe-ma ramo oporandu íxupe Judas, ndaha'éi upe Judas ipyhy ukaharã: —Ma'erã po nderejekwaa uka mo'ãi entéro yvypóry-pe, he'i íxupe. —Ma'erã po ore-vy anho erejekwaa uka-ta, ore Járy? he'i íxupe Judas oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Upéi Hesu he'i íxupe kwéry: —Xe rayhu va'e gwive ohendu va'erã xe nhe'ẽ. Ohayhu va'erã íxupe xe Ru ave. Upéa-gwi orogwahẽ va'erã íxupe oroju-vy. Hendive oroiko va'erã, he'i Gwu-rehe, ójehe ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","—Ha xe rayhu e'ỹ va'e gwive, nohendu mo'ãi xe nhe'ẽ. Ha xe remimombe'u peẽ-my ndaha'éi xe jehegwigwa. Xe Ru xe mbouhare remimombe'u ae amombe'u peẽ-my, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Upe va'e peẽ-my xe remimombe'u voi pene pa'ũ-rupi aime jave. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ha ndaikovéi ramo, pene mbo'e va'erã pene pytygwõharã. Nhe'ẽ Marangatu tee va'e voi upe va'e. Upe va'e xe Ru remimbourã xe réry-py voi. Entéro xe-rehe omombe'u va'ekwe-rehe gwive, entéro xe remimombe'ukwe-rehe ave pene momandu'a uka va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—“Tereho katu nde py'agwapy reheve” he'i rei teko rei. Ha xe katu nda'e reíry upéixa. Orombopy'agwapy-ta. Xe py'agwapyha-rami orombopy'agwapy-ta. Upéa-gwi anive pene py'agwapy e'ỹ teĩ. Anive pekyhyje teĩ, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","—“Aha jevy-ta. Ha upe rire katu aju jevy-ta pene ndive apyta hagwã” ha'e kuri peẽ-my. Upéa pehendu voi. Ãy xe rayhu tee ramo, pevy'a arã ra'e. Xe Ru ko tuvixave va'e xéhegwi. Aha-ta xe Ru-pe agwahẽ. Upéa-gwi aha jevy ramo jepe, pevy'a arã ra'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Aha e'ỹ reheve amombe'u-ma peẽ-my xe aha hagwã. Aha rire-ma katu, aipota, “Anhetegwa voi nipo ra'e hemimombe'u” peje va'erã xe-rehe pene mandu'a-vy. Upéa-gwi amombe'u ãy xe aha hagwã peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ãy ogwahẽ-ta ou-vy anhaygwasu gwĩ Nhandejáry-rehe ija'e'ỹha-rehe omanda va'e voi. Upéa-gwi nanhomongeta puku mo'ãi pene ndive. Ndaipu'akái xe-rehe anhaygwasu. Xe ndaikóiry inhe'ẽ-rupi. Xe Ru nhe'ẽ-py ae aiko. ");
INSERT INTO kgkNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Aipota teko rei oikwaa xe ahayhuha xe Ru-pe. Upéa-gwi xe Ru he'i va'e gwive ajapo-ta inhe'ẽ, he'i. —Nhapu'ã katu ko'a-gwi jaha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Upéi he'i jevy gwemimbo'e kwéry-pe Hesu: —Amombe'u-ta peẽ-my xe rehegwa nhe'ẽ uva máta rehegwa nhe'ẽ-rami. Uva máta tee va'e he'ise xe-rehe. Uva máta járy he'ise xe Ru-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hakã hi'a e'ỹ va'erã gwive oipe'a. Uva máta-gwi oipe'a. Ha hakã hi'a porã va'erã katu oheja íxupe. Hakã gwyre mante oipe'a íxugwi. Hi'a porãve hagwã omopotĩ íxupe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","—Upéixa pene potĩ-ma pende py'a-py. Xe remimombe'u pehendu va'e gwive pene potĩ-ma voi pende py'a-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xe moirũ katu peiko-vy peteĩxa. Ha xe ave peteĩxa oromoirũ-ta. Imáta-gwi oipe'a hakã va'e-rami upe va'e hakã ndahi'áiry. Upéixa ete naxe moirũvéi-ma ramo, napene rembiapo porãvéi-ma va'erã. Mba'eve ndapejapovéi-ma va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Ha uva máta he'ise xe-rehe. Pende-rehe he'ise uva rakã. Peteĩxa xe moirũ va'e, xe ave amoirũ íxupe va'e, upe va'e heta hembiapo porã porã va'erã hi'a porã porã oĩ va'e-rami. Xe e'ỹ reheve mba'eve ete voi ndapejapo mo'ãvéi-ma va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","—Ha peteĩxa xe moirũ e'ỹ va'e katu hi'a e'ỹ va'e rakã-rami onhemombo va'erã. Ipiru va'erã. Ipiru rire omboaty va'erã ohapy hagwã-py, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","—Peteĩxa xe moirũ ramo, pende py'a-py oiko ramo xe nhe'ẽ, oime raẽ va'e-rehe pejerure ramo katu, ome'ẽ va'erã peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pene rembiapo porã porã ramo, ohexa kwaa va'erã xe Ru-rehe hekoha porã tee. Upéixa ramo pene rembiapo porã ramo, xe remimbo'e ramo peiko va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Xe Ru xe rayhuha-rami, xe ave apohayhu peẽ-my. Pene mandu'a meme katu apohayhuha-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Xe nhe'ẽ pehendu peiko-vy ramo, pene mandu'a meme va'erã apohayhuha-rehe. Upéixa voi xe Ru nhe'ẽ ahendu-gwi xe mandu'a meme xe rayhuha-rehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","—Upéa ha'e-ma peẽ-my pevy'a hagwã. Xe avy'aha-rami aipota pevy'a ave. Pevy'apa hagwã peiko-vy ha'e-ma peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ãy ha'e-ta peẽ-my: Pejohayhu katu peiko-vy. Apohayhuha-rami pejohayhu katu, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","—Oirũ rekovia ojejuka uka va'e, ohayhu tee rei oirũ-pe. Ndoikói ohayhuve va'e, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","—Ha xe irũ voi peẽ. Xe nhe'ẽ pehendu ramo xe irũ tee voi peẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Xe rembigwái, nda'evéi-ma pende-rehe. Mbava'e po ojapo ijáry ndoikwaái voi hembigwái. Ha xe Ru nhe'ẽ ahendu va'ekwe gwive, amombe'u-ma peẽ-my. Upéa-gwi, Xe rembigwái, nda'evéi-ma pende-rehe. Xe irũ tee-py ae apohenói. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ndaxe poravóiry va'ekwe pene mbo'eharã. Apoporavo va'ekwe ae xe irũrã. Ame'ẽ va'ekwe peẽ-my pene rembiaporã hetave hi'a va'e-rami peiko hagwã. Aipota pende rekoha porã porã meme opa e'ỹ-rehe hi'a meme va'e-rami. Ndaipotái hesarái rei pende rekoha porã-rehe. Upéixa ramo oime raẽ va'e-rehe pejerure ramo xe réry-py ome'ẽ va'erã peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ha'e jevy-ta peẽ-my, Pejohayhu katu peiko-vy, ha'e, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Upe ramo he'i jevy gwemimbo'e kwéry-pe Hesu: —Ha teko rei katu ndaija'éi xe-rehe. Ãy ndaija'e mo'ãi pende-rehe. Ndaija'éi ramo pende-rehe, pene mandu'a katu xe-rehe ija'e'ỹ hagwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Teko rei reko-rupi peiko ramo ra'e, gwe'ýi-rami pende rayhu arã ra'e. Ha apoporavo va'ekwe ndapeikovéi-ma hagwã teko rei reko-rupi. Ndapeikói teko rei re'ýi va'e-rami. Upéa-gwi ndaija'éi pende-rehe teko rei, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","—Ha'e kuri peẽ-my, Ani, “Hembigwái jepe xe, xe járy-gwi tuvixave va'e voi xe” peje mo'ã pende py'apy-py pendéjehe. Ani pende resarái ha'e va'ekwe-rehe. Xe rereko asy hagwe-rami, pende rereko asy ave va'erã. Xe rendu hagwe-rami, pene nhe'ẽ ave ohendu va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Teko rei ndoikwaái xe mbouhare-pe. Upéa-gwi koixagwa gwive ojapose va'e ojapo va'erã pende-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ndajúi ramo ra'e, namombe'úi ramo yvypóry-pe ra'e, ndojekwaái arã ra'e ipy'a ky'aha. Ha ko'ánga katu, “Ndajaikwaái voi nhande py'a ky'aha” ndikatuvéiry he'i ójehe. Hekoha vaiha amombe'u teko rei-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Xe-rehe ndaija'éi va'e xe Ru-rehe ndaija'éi ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ipa'ũ-rupi xe rembiapo porã porã xeixagwa ojapo va'e ndaipóri. Upéa rehegwa ndajapói ramo ra'e, ndaipy'a ky'ái arã ra'e hikwái. Ha ko'ánga katu xe-rehe ohexa kwaa ramo jepe, ndaija'éiry rei xe-rehe. Xe-rehe ndaija'éiry jave xe Ru-rehe ndaija'éiry ave, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","—Yma va'ekwe he'i Nhandejáry kwatia nhe'ẽ judeu kwéry ohendu va'e. Ãygwa rekorã omombe'u-ma voi va'ekwe: “Ija'e'ỹ rei xe-rehe” he'i Nhandejáry nhe'ẽ ãygwa rekorã mombe'u-vy. Upéa-gwi hembihaikwe-ramima ija'e'ỹ rei xe-rehe hikwái, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","—Ha pene pytygwoharã Nhe'ẽ Marangatu tee va'e xe Ru gwigwa voi, anhetegwa tee va'e mombe'uha voi. Peẽ-my xe remimbourã voi upe va'e. Xe Ru-gwi xe remimbourã voi. Ou ramo xe mombe'u va'erã. “Anhetegwa voi” he'i xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ha peẽ katu xe anhepyrũ xe rembiapo gwive ãy peve xe moirũ-ma peiko-vy. Upéa-gwi xe mombe'u va'erã peẽ ave, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Upe ramo he'i jevy gwemimbo'e kwéry-pe Hesu: —Pende rereko asyharã amombe'u-ma peẽ-my. Xe aha rire pende rereko asy va'erã gwĩ pende-rehe ija'e'ỹ va'e. Pende rereko asy ramo, ndaipotái penhemondýi. Ndaipotái, “Ma'erã po nhande rereko asy oiko-vy” peje pendéjehe, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","—Pene mosẽ va'erã imondo-vy ojeporahéi haty haty-gwi. “Anive peike teĩ” he'i arã peẽ-my gwĩ pende-rehe ija'e'ỹ va'e. Upéi ogwahẽ va'erã peẽ-my pemano hagwã áry. Upe-ma ramo pende jukaharã: “Nhandejáry remimbota-rupi jajuka íxupe” he'i mo'ã va'erã pende-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Upéixa voi pene moingo asy va'erã hikwái, ndoikwaái-gwi xe Ru rekoha, xe rekoha ndoikwaái-gwi ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Upéixa amombe'u-ma peẽ-my pende-rehe ija'e'ỹ va'e rekorã. Ha upe rire katu pene moingo asy ramo, pene mandu'a va'erã xe remimombe'ukwe-rehe peẽ-my, he'i íxupe kwéry. Upéi he'i jevy gwemimbo'e kwéry-pe Hesu: —Yma gwive ko'ánga ete peve xe aiko pene pa'ũ-rupi. Upéa-gwi namombe'úi peẽ-my pende-rehe ija'e'ỹ va'e rekorã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","—Ha ko'ánga katu aha jevy-ta xe xe mbouhare oiko ha-py. Aha-tama jepe aiko-vy, “Kipy tipo ereho-ta?” ndapejéiry xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ha xe aha hagwã amombe'u-gwi katu ndapevy'avéi-ma voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ha anhetegwa tee va'e amombe'u-ta peẽ-my. Xe apytave ramo pene ndive, naiporãi arã peẽ-my. Ha aha ramo katu iporãve va'erã peẽ-my. Ndahái ramo, nogwahẽi arã ou-vy peẽ-my pene pytygwõharã. Ha aha ramo katu, ambou va'erã peẽ-my pene pytygwõharã. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Ogwahẽ ou-vy ramo pene pytygwõharã Nhe'ẽ Marangatu tee va'e, oikwaa uka va'erã yvypóry kwéry-pe ijapuha, “Jajejavy e'ỹ va'e voi nhande” he'i ramo mo'ã ójehe. Ndojeroviái voi xe-rehe oiko-vy. Upéa-gwi oikwaa uka va'erã íxupe kwéry hembiapo vaikwe. Ha Nhe'ẽ Marangatu tee va'e oikwaa uka ave va'erã íxupe kwéry ijapuha “Onhemonhandejáry rei voi Hesu” he'i ramo mo'ã xe-rehe. Ha aha ramo xe Ru oiko ha-py, peẽ ndaxe rexavéi-ma ramo katu, oikwaa uka va'erã íxupe kwéry xe-rehe ijapuha. Ha Nhe'ẽ Marangatu tee va'e oikwaa uka ave va'erã yvypóry kwéry-pe ijapuha, “Nhande rexakwaa rei va'erã voi Nhandejáry. Nhane rembiapo vaikwe-rehe katu nanhane rereko asy mo'ãi” he'i rei ramo ójehe. Ha ohexa kwaa-ma ramo anháy ruvixa-rehe gwĩ teko rei-pe ombo'e mbo'eha-rehe ndaipu'akaveimaha nhande-rehe katu, Nhe'ẽ Marangatu tee va'e oikwaa uka va'erã íxupe Nhandejáry-rehe ijapuha, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Hetave voi oĩ xe remimombe'use peẽ-my. Ha ãy amombe'u pukuve ramo katu, ipohýive arã peẽ-my. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ha upe rire katu Nhe'ẽ Marangatu tee va'e, anhetegwa tee mombe'uha ou ramo, oikwaa uka va'erã peẽ-my anhetegwa va'e gwive. Ojehegwigwa va'e nomombe'u mo'ãi. Ha hemiendu katu omombe'u va'erã. Oiko-ta va'erã pene renonderã omombe'u va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Xe rehegwa omombe'u va'erã peẽ-my. Upéa-gwi xe rekoha porã tee oikwaa uka va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ha xe rehegwa katu xe Ru rehegwa ave voi. Upéa-gwi ha'e kuri peẽ-my, Xe rehegwa omombe'u va'erã ave peẽ-my Nhe'ẽ Marangatu tee va'e ou ramo, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Upéi he'i jevy íxupe kwéry: —Ãy ndaxe rexa are mo'ãi peẽ, he'i. —Ha upe rire katu xe rexa jevy va'erã, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ha hemimbo'e kwéry ndoikwaáiry inhe'ẽ. He'i ojóupe: —“Ãy ndaxe rexa are mo'ãi peẽ. Ha upe rire katu xe rexa jevy-ta” he'i kuri nhande-vy. “Aha-gwi xe Ru oiko ha-py” he'i kuri nhande-vy, he'i ojóupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","—Ma'erã po, “Ha upe rire katu xe rexa jevy-ta” he'i kuri nhande-vy. Mbava'e-rehe nipo he'i nhande-vy, ndajaikwaáiry aipo he'i ramo, he'i ojóupe hikwái Hesu nhe'ẽ-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ha Hesu oikwaa-ma oporanduseha ojéupe. Upéa-gwi he'i íxupe kwéry: —Ha'e kuri peẽ-my, “Ãy ndaxe rexa are mo'ãi peẽ. Ha upe rire katu xe rexa jevy va'erã” ha'e kuri peẽ-my. Upe va'e xe nhe'ẽ-rehe peporandu randu tipo ojóupe peiko-vy? he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","—Amombe'u-ta peẽ-my anhetegwa tee va'e. Pene rasẽ va'erã pejahe'o-vy. Ha teko rei katu ovy'a va'erã. Pevy'a e'ỹ va'erã. Ha upe rire katu ndapevy'avéi rire, pevy'a jevy-ma va'erã peiko-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Imemby-ta va'e-rami peiko va'erã. Imemby-tama ramo kunha ndovy'avéi-ma. Imembytamaha óra-py ohendu-ma ramo gwasy, ndovy'avéi-ma. Ha imemby rire-ma katu, ovy'a jevy omemby-rehe: “Oiko-ma mitã'i. Kunumi ra'e” he'i ojéupe. Upéa-gwi gwasy hagwe-rehe naimandu'avéi-ma, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","—Upéixa ete peiko ãy. Imemby-tama va'e-rami peiko. Ãy ndapevy'avéi-ma. Ha upe rire katu apohexa jevy-ta. Xe rexa jevy ramo pevy'agwasu ete jevy-ma va'erã, he'i. —Upe ramo pene mbovy'are'ỹ va'e ndoikovéi-ma va'erã. Pevy'a meme ete va'erã, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","—Upe áry-py napeporanduvéi-ma va'erã xe-vy. Amombe'u-ta peẽ-my anhetegwa tee va'e. Oime raẽ va'e-rehe pejerure ramo xe Ru-pe xe réry-py, ome'ẽ va'erã peẽ-my xe Ru. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ko'ánga ete peve ndapejeruréiry xe réry-py. Ãy pejerure rure katu xe réry-py. Ome'ẽ va'erã peẽ-my. Hemime'ẽgwe-rehe pevy'apa-ma va'erã, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Upe ramo he'i jevy gwemimbo'e kwéry-pe Hesu: —Amombe'u-ma kuri peẽ-my xe Ru rehegwa nhe'ẽ ambue-py orombo'eha-rami. Ha ogwahẽ va'erã xe amombe'u porãha áry. Upe áry-py xe Ru rehegwa nhe'ẽ ambue va'e orombo'eha-rami namombe'uvéi-ma va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Upe áry-py pejerure va'erã xe Ru-pe. Xe réry-py pejerure va'erã íxupe. Pejeapysaka katu xe nhe'ẽ-rehe. Pende rekovía ndajerure mo'ãi íxupe. Xe Ru-pe voi katu pejerure va'erã xe réry-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Xe rayhu-gwi peẽ ha'e katu pende rayhu ave. “Nhandejáry-gwi ou va'ekwe nipo ra'e Hesu” peje-gwi xe-rehe, pende rayhu ave ha'e. Upéa-gwi xe Ru-pe voi katu pejerure va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xe ko asẽ va'ekwe xe Ru oiko ha-gwi aju-vy. Ko yvy-py aju va'ekwe. Ha ko'ánga katu aheja jevy-ta ko yvy aha-vy. Xe Ru oiko ha-py aha jevy-ta, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Upe ramo he'i íxupe hikwái: —Ãy katu eremombe'u porã-ma ore-vy. Nde rehegwa nhe'ẽ neremombe'uvéi-ma ambue-py ore mbo'eha-rami, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","—Opamba'e kwaaha voi nipo nde ra'e, he'i. —Oroikwaase va'e ereikwaa uka ore-vy. Ãy noroporandu mo'ãvéi-ma nde-vy. Upéa-gwi Nhandejáry-gwi ereju va'ekwe nipo ra'e, he'i íxupe hemimbo'e kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ha Hesu he'i: —Ne'írã pejerovia tee xe-rehe peiko-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","—Ogwahẽ-tama ou-vy xe áry. Upe áry-py pesarambipa-ta peteĩ teĩ pende róga-rupi peho-vy. Upéixa xe anho xe rejapa-ta peho-vy. Xe rejapa ramo jepe, naxe anhói joty apyta va'erã. Xe moirũ joty arã xe Ru, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","—Koixagwa peẽ-my xe remimombe'u voi. Aipota xe moirũ pende py'agwapy hagwã. Pene moingo asy va'erã teko rei. Pene moingo asy ramo jepe, ani joty pekyhyje teĩ. Ndaipu'akái va'erã pende-rehe teko rei. Xe ko xe pu'akave-ma aiko-vy xe rendu e'ỹha-rehe. Upéa-gwi ani pekyhyje teĩ teko rei-gwi, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Upéa he'i rire, hovayva Hesu ombojeupi onhe'ẽ Nhandejáry-pe: —Ogwahẽ-ma ou-vy xe aha hagwã óra, xe Ru, he'i íxupe. —Nde ra'y voi xe, he'i Gwu-pe. —Xe reko porãha ehexa uka katu ahexa uka hagwã nde reko porãha. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yma va'ekwe nde katu xe moingo entéro yvypóry gwive jaryrã, xe amoingove hagwã ne rembiporavo va'e gwive ne ndive oiko hagwã opa e'ỹ reheve. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ha xe remimoingove katu ohexa kwaa porã nde-rehe nde rekoha. Ne anho Tupã tee voi. Ne ramigwa ndaipóri. Ha xe ne remimbou voi. Xe rekoha ohexa kwaa porã ave xe-rehe xe remimoingove. Upéa-gwi ehexa uka katu xe reko porãha. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yvypóry-pe ahexa uka-ma nde reko porãha. Ereme'ẽ va'ekwe xe rembiaporã gwive ajapo-ma katu. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ko yvy oiko e'ỹ mboyve xe tuvixa mba'e-ma aiko ne ndive va'ekwe. Ko'ánga ne ndive aiko hagwe-rami, xe moingo jevy katu, xe Ru. Xe mbotuvixa mba'e jevy katu. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","—Yvypóry pa'ũ-gwi ereiporavo va'ekwe xe irũrã ereme'ẽ hagwã xe-vy. Íxupe aikwaa uka-ma nde rekoha. Ne rembiporavo nde re'ýi voi. Upéi ereme'ẽ va'ekwe xe-vy xe re'yirã. Ne nhe'ẽ ohendu hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ko'ánga katu, “Nhandejáry remime'ẽgwe voi íxupe nipo ra'e” he'i ereme'ẽ va'ekwe-rehe xe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Xe-vy ne remimombe'u amombe'u íxupe. Ha xe remimombe'u katu ohendu voi hikwái. “Nhandejáry-gwi ou nipo ra'e Hesu. Ombou nipo ra'e íxupe Nhandejáry” he'i nhande-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","—Ha teko rei-rehe katu ndajerure mo'ãi nde-vy. Xe-vy ne remime'ẽgwe-rehe ae ajerure-ta nde-vy. Nde re'ýi voi. Upéa-gwi ajerure-ta nde-vy hese. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Xe areko va'e gwive ne mba'e ave. Ha nde erereko va'e gwive xe mba'e ave. Ha xe remimbo'e katu xe-vy ne remime'ẽgwe xe irũrã ohexa uka-ma xe reko porã teeha. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ãy katu aha-ta xe nde ereiko ha-py. Ndaiko mo'ãvéi-ma ko yvy ári. Ha xe remimbo'e katu oiko joty va'erã ko yvy ári. Nde reko marangatu voi, xe Ru. Ne nhe'ẽ-rupi aikwaa uka-ma kuri íxupe kwéry nde rekoha. Ãy nde réry-py enhangareko porã katu hese ijoja meme oiko-vy hagwã. Peteĩxa nhande, nhande jojaha-rami, aipota ijoja ave onhondive hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Hendive xe aime jave ko yvy ári, anhangareko hese aiko-vy nde réry-py, ahexa uka íxupe va'ekwe-py. Anhangareko porã hese aiko-vy. Avave ndaxe rejái oho-vy. Peteĩ va'e mo'ã xe reja kuri oho-vy. Xe irũ tee e'ỹ va'e upéa anhaygwasu rembieraha. Yma hekorã omoĩ va'ekwe kwatia-rehe. Upéa-gwi hembihaikwe-rami naxe moirũvéi-ma ãy. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—Ko'ánga aheja-tama ko yvy aha-vy nde ereiko ha-py. Ha aime jave katu kóa xe nhe'ẽ amombe'u íxupe kwéry ovy'a hagwã. Xe avy'aha-rami aipota ovy'apa hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne nhe'ẽ amombe'u-ma kuri íxupe ha teko rei katu ndaija'éi-ma hese. Teko rei reko-rupi aiko e'ỹha-rami, xe irũ ave ndoikovéi-ma heko-rupi. Upéa-gwi ndaija'evéi-ma hese teko rei. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Eipe'a katu íxupe heraha-vy ko yvy-gwi” nda'e mo'ãi nde-vy. Ha'e-ta ae, “Eresende katu íxupe. Anháy reko e'ỹ-rupi oiko hagwã eresende katu” ha'e-ta ae nde-vy hese kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Teko rei reko-rupi xe aiko e'ỹha-rami xe irũ ave ndoikovéi-ma heko-rupi. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Teko rei reko-rupi ndoikovéi-gwi, ipotĩ-magwi eheja katu toiko ne irũ tee ramo. Anhetegwa tee va'e ne nhe'ẽ. Ne nhe'ẽ rendu ramo emoingo katu ne irũ tee ramo. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Yvypóry kwéry-pe amombe'u hagwã xe mbou va'ekwe. Upéixa ete, “Tapeho opa-rupi xe mombe'u-vy” ha'e kuri xe irũ-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ãy apena hese-gwi, napenavéi-ma xéjehe. Hekovia ae amano hagwã-rami aĩ. Nde-vy anheme'ẽ-ta ne irũ tee ramo oiko hagwã xe irũ. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Xe irũ-rehe ajerure-ma nde-vy. Ha ko'ánga katu xe irũ nhe'ẽ renduharã-rehe ave ajerure-ta ave. Inhe'ẽ rendu-gwi ojerovia-ma va'erã xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Xe-rehe ojerovia va'erã-rehe ajerure-ta nde-vy peteĩxa ijoja tee hagwã xe-rehe ojerovia va'e gwive. Nde ko xe moirũha-rami, xe Ru, xe oromoirũha-rami ave, aipota peteĩxa nhane moirũ hikwái, “Nhandejáry remimbou voi nipo ra'e Hesu” he'i hagwã xe-rehe yvypóry. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nde rekoha erehexa uka xe-vy va'ekwe-rami, ahexa uka ave kuri íxupe xe rekoha peteĩxa ijoja tee hagwã oiko-vy. Nhande nhande jojaha-rami aipota ijoja ave hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Peteĩxa amoirũ íxupe. Peteĩxa ave xe moirũ nde. Upéixa jaiko ha'e kwéry ijoja porã tee hagwã. Ijoja porã tee ramo, “Nhandejáry remimbou voi nipo ra'e Hesu” aipota he'i va'erã xe-rehe teko rei. Aipota he'i va'erã, “Hesu-pe ohayhuha-rami Nhandejáry, Nhandejáry reroviaha ave hembiayhu voi nipo ra'e” he'i va'erã. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Ãy, xe Ru, ko va'e xe-vy ne remime'ẽgwe voi xe irũrã. Xe aiko ha-rupi, aipota xe moirũ ave. Ndoikói výteri ramo ko yvy xe rayhu va'ekwe ereiko-vy. Upéa-gwi xe momba'egwasu va'ekwe xe rereko-vy. Ãy aipota xe moirũ xe momba'egwasuha ohexa hagwã hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nde ko erejejavy e'ỹ va'e, xe Ru. Teko rei katu nde kwaa e'ỹha voi. Xe ko ae nde kwaaha voi. Ha xe irũ katu oikwaa-ma nde xe mbouhare. ");
INSERT INTO kgkNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aikwaa uka va'ekwe íxupe nde rekoha aiko-vy. Ãy aikwaa uka jevy-ta aiko-vy, xe rayhuha-rami ereiko-vy, ojohayhu porãve rãve hagwã ave. Peteĩxa amoirũse ave íxupe kwéry, he'i Nhandejáry-pe onhe'ẽ ombojeupi-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Upe oração ojapo rire, Hesu osẽ oho-vy gwemimbo'e kwéry ndive. Cedrom y rupagwe-rupi ohasa oje'ói-vy. Upe-py oĩ yvotyty. Upe-py oike oho-vy hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Upe va'e yvotyty-py onhomboaty aty va'e gwemimbo'e kwéry ndive. Upéa-gwi Judas, Hesu pyhyharã-pe omombe'u va'erã oikwaa voi yvotyty. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Upéixa ramo Judas Hesu piári oho upe-py. Hendive oho soldado kwéry. Polícia pa'i ruvixa remimondo va'e, fariseu remimondo va'e ave indive oho. Gwesapeharã ave ogweraha. Gwataendyrã ave ogweraha. Ikutu hagwã reheve oho. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ha Hesu oikotaha gwive oikwaapa voi. Upéa-gwi oho ohogwaitĩ joty íxupe: —Kiva'e-pe tipo peheka peiko-vy? he'i oporandu-vy soldado kwéry-pe Hesu. Ha soldado kwéry he'i íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Oroheka Nazaré pygwa Hesu-pe, he'i íxupe hikwái. —Xe voi ko ha'e, he'i onhemombe'u-vy soldado kwéry-pe. Ha Judas katu Hesu pyhyharã-pe omombe'uhare ou ave Hesu pyhyharã ndive. Onhembo'y ave oĩ-vy upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Xe voi ko ha'e” he'i-ma ramo Hesu, onhemondýi hikwái. Ogwevi mo'ã ramo ho'a oje'ói-vy yvy-py soldado kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ha Hesu oporandu jevy íxupe kwéry: —Kiva'e-pe tipo peheka? he'i jevy íxupe kwéry. —Nazaré pygwa Hesu oroheka va'e, he'i jevy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Xe voi ko ha'e, ha'e-ma kuri peẽ-my. Néi. Xe voi xe reka peiko-vy ramo, peheja katu toho xe irũ gwéry, he'i soldado kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Upéa he'i oiko hagwã he'i hagwe-rami. He'i-ma kuri Gwu-pe: “Ne remime'ẽgwe-rehe anhangareko porã porã aiko-vy. Ndojehesa rerovái xéhegwi avave” he'i kuri gwemimbo'e kwéry-rehe. Upéa-gwi ãy he'i: “Peheja katu toho xe irũ gwéry” he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Upe-ma ramo Simão Pedro ohekýi hyru-gwi okyse. Omopu'ã-vy oikytĩ-ma pa'i ruvixagwasu rembigwái-pe, Malco héry va'e-pe. Oinambijo-ma íxupe. Ijakatúa kotygwa oikytĩ íxugwi inambi. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Upéi he'i Pedro-pe Hesu: —Emoĩ jevy katu hyru-py nde kyse, he'i. —Nhandejáry nhe'ẽ-py ahasa asy va'erã. Ani, “Ndohasa asy mo'ãi Hesu” ere erenhemongeta-vy teĩ nde py'apy-py, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Upe rire soldado kwéry huvixa ndive, judeu remimbou polícia ave oipyhy Hesu-pe oipokwa-ma heraha-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ogweraha ranhe Anás róga-py. Ha Anás katu Caifás ratyu. Ha Caifás upe va'e ro'y-py pa'i ruvixagwasu ramo opyta. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Upe va'e he'i-ma kuri judeu ruvixa kwéry-pe: “Peẽ-my iporãve arã nhande rekovia peteĩ va'e omano ramo” he'i kuri Hesu-rehe. Ha upéi katu ogweraha íxupe Anás róga-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ha Simão Pedro outro Hesu remimbo'e ndive oho hapykwéri. Pe outro hemimbo'e katu pa'i ruvixagwasu kwaaha. Upéa-gwi oike pa'i ruvixa róga kakwaa-py Hesu rapykwéri. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ha Pedro katu opyta oka-py. Okẽ-my rei oĩ. Upéi pe outro hemimbo'e pa'i ruvixagwasu kwaaha osẽ jevy ou-vy omombe'u pa'i rembigwái-pe okẽ-rehe onhangareko va'e-pe. Upe-ma ramo oheja Pedro oike: —Eike katu, he'i íxupe pa'i rembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Oike rire he'i jevy Pedro-pe pa'i rembigwái: —Nde tipo ndaha'éi Hesu remimbo'e, he'i oporandu-vy íxupe. —Ndaha'éi xe, he'i mo'ã. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ro'y eterei voi. Upéa-rehe pa'i rembigwái kwéry polícia ndive ohatapy ra'e ojepe'e hagwã. Ãy onhembo'y tata ypy-py ojepope okwa-vy. Ipa'ũ-my ave Pedro ojepope oĩ-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ha upéi katu pa'i ruvixagwasu oporandu Hesu-pe hemimbo'e kwéry-rehe. —Mbava'e eremombe'u ijaty va'e-pe? he'i íxupe oporandu-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ha Hesu he'i: —Xe ko atýra-py meme amombe'u-ma enterove va'e-pe aiko-vy. Ojeporahéi haty haty-rupi xe ambo'e-ma aiko-vy. Nhandejáry róga kakwaa-py ave ambo'e-ma aiko-vy. Judeu kwéry ojogweroaty aty ha-rupi ambo'e aiko-vy. Nhemi ha-rupi ae namombe'úiry aiko-vy, he'i. —Ambue mbue va'e katu namombe'úi nhemi ha-rupi aiko-vy, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","—Ani xe-vy ereporandu teĩ, he'i. —Xe renduhare-pe ae katu eporandu. Xe renduhare oikwaa porã va'e xe remimombe'ukwe, he'i pa'i ruvixagwasu-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Upe-ma ramo peteĩ polícia upe-py oĩ va'e ohovapete íxupe: —Ma'erã po nde py'agwasu-ma upéixa ere hagwã pa'i ruvixagwasu-pe, he'i íxupe pe polícia. Upéi Hesu he'i: ");
INSERT INTO kgkNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—Ereikwaa ramo xe nhe'ẽ porã e'ỹha, emombe'u katu a pygwa-pe xe apuha. Ha xe nhe'ẽ porã ramo jepe, ma'erã katu xe rovapete rei? he'i polícia-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Upe-ma ramo Anás omondo Hesu-pe. Pa'i ruvixagwasu Caifás oiko ha-py omondo. Ipokwaha reheve oho Hesu upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Upe ramo Pedro opu'ã joty ojepe'e oĩ-vy tata ypy-py. Ha oporandu íxupe upe pygwa: —Nde tipo ndaha'éi Hesu remimbo'e? he'i íxupe. —Nahániry xe, he'i joty mo'ã. —Ndaha'éiry Hesu remimbo'e xe, he'i mo'ã upe pygwa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Upéi oporandu íxupe pa'i ruvixagwasu rembigwái va'e. Inambikytĩpyre re'ýi voi. Ha upéi katu oporandu íxupe: —Nde tipo Hesu irũ? he'i. —Yvotyty-py nde orohexa voi kuri, he'i íxupe hembigwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—Xe ndaikói kuri, he'i jevy mo'ã Pedro. Upe-ma ramo osapukái-ma gáju. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ha upéi katu oipyhy jevy-ma Hesu-pe heraha-vy hikwái. Osẽ Caifás róga-gwi oje'ói hagwã mburuvixagwasu róga kakwaa-py. Voi ogwahẽ oje'ói-vy upe-py. Ha judeu ruvixa kwéry ndoikéiry mburuvixa róga-py. Pe mburuvixa ndaha'éi judeu kwéry va'e. Heko-rupi oiko e'ỹ-gwi ndoikéiry koty-py. Judeu kwéry e'ỹ va'e koty-py ndoikéiry. He'i judeu ruvixa kwéry: —Jaike ramo nhande kwéry e'ỹ va'e róga-py nhanhemongy'a arã. Aipo ramo, nhanhemongy'a ramo, ndikatúi arã jakaru aretegwasu-py, he'i ójehe kwéry. Ha judeu ruvixa kwéry okaruse voi aretegwasu-py. Upéa-gwi ndoikéiry voi mburuvixagwasu róga-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Upéixa ramo mburuvixagwasu Pilatos osẽ ou-vy koty-gwi: —Mbava'e tipo ojapo vai ra'e peru hagwã, he'i oporandu-vy judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—Nahembiapo vaíry ramo ra'e, ndorogwerúi arã ra'e íxupe nde ha-py, he'i joty hese mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—Néi, he'i Pilatos. —Peẽ ko peraha katu íxupe pende reko-rupi pejapo hagwã hese, he'i íxupe kwéry. Upéi he'i judeu ruvixa kwéry: —Nderejuka ukaséiry joty ore-vy hembiapo vai va'e, he'i. —Ne nhe'ẽ-py mante ojuka va'erã hembiapo vai va'e, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ha Hesu katu onhemombe'u-ma kuri mba'éixa omano-ta. Ãy onhemombe'u hagwe-ramima oiko-tama voi. Onhemombe'u hagwe-ramima onhe'ẽ-ma ãy judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ha upéi katu mburuvixa oike jevy koty-py ohenói tou Hesu. Ou ramo, oporandu íxupe: —Nde tipo judeu kwéry ruvixagwasu va'e? he'i íxupe mburuvixa Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ha Hesu he'i: —Ndejehegwi rei para'e ereporandu xe-vy xe kwaa hagwã. Xe mombe'u para'e nde-vy, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—Ndaha'éiry xe judeu kwéry va'e. Nde re'ýi ae pa'i ruvixa kwéry ave nde reru-ma ne moĩ xe po-py. Mbava'e tipo erejapo ra'e? he'i íxupe Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Upéi Hesu he'i: —Xe ko mburuvixagwasu jepe, namandái va'e yvypóry-rehe, he'i. —Amanda ramo hese kwéry ra'e, aheja arã ra'e xe irũ onhorairõ xe-rehe. Aheja arã ra'e xe resende judeu kwéry-gwi. Ko yvy arigwa-rami katu namandái va'e voi, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—Aipo ramo, nde mburuvixagwasu voi ra'e, he'i íxupe Pilatos. Upéi he'i Hesu: —Mburuvixagwasu-py xe renói-ma kuri, he'i. —Xe ko ndaju reíry va'ekwe ko yvy ári. Anhetegwa tee va'e mombe'uharã xe aiko-ma va'ekwe ko yvy-rehe. Ha anhetegwa reroviaha gwive katu xe nhe'ẽ ohendu ave arã, he'i mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—Mbava'e nipo anhetegwa va'e, he'i Hesu-pe Pilatos. Upéa he'i rire osẽ jevy koty-gwi omombe'u hagwã judeu kwéry-pe: —Nahembiapo vaíry ra'e, he'i Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","—Páscoa aretegwasu-py peteĩ preso oĩ va'e apoi-ta va'e íxugwi. Pende reko-rupi apoi íxugwi, he'i. —Aipo ramo, peipota tipo xe apoi pende ruvixagwasu Hesu-gwi, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Upe-ma ramo entéro judeu kwéry va'e gwive onhe'ẽ hatã-ma osapukái-vy hikwái: —Nahániry, he'i. —Hesu-pe katu ndoroipotáiry erepoi. Barrabás ae oroipota erepoi, he'i mburuvixa-pe judeu kwéry. Ha Barrabás katu oporasakeahaty voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ha upéi katu Pilatos omanda Hesu-rehe: —Peipyhy katu Hesu-pe peraha-vy. Pembopi mbopi katu íxupe heraha-vy, he'i omanda-vy Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Upe ramo soldado kwéry oipyhy ombopi íxupe. Upéi nhuatĩ-gwi ojapo íxupe inhakã rehegwarã. Ijegwaka ra'anga ojapo omoĩ hagwã inhakã-rehe hikwái. Omonde hese ao pytã va'e, mburuvixa omonde va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Upéi peteĩ teĩ ogwahẽ ou-vy hovagwy-py. Imboete ra'anga anga-vy ou hovagwy-py. —Toiko are katu, toiko are katu, judeu ruvixagwasu, he'i onhembohory-vy Hesu-rehe. Ohovapete pete íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Upe-ma ramo Pilatos osẽ jevy koty-gwi oho-vy he'i judeu kwéry-pe: —Pejeapysaka katu xe nhe'ẽ-rehe. Anohẽ jevy-ta íxupe xe ha'e va'e hese peikwaa porã hagwã. Hesu rembiapo vaikwe ndajohúiry voi, he'i judeu kwéry-pe Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","He'i rire-ma osẽ jevy-ma ou-vy koty-gwi Hesu. Inhakã-rehe oĩ nhuatĩ-gwi ijegwaka ra'anga. Ao puku pytã va'e-py onhemonde-ma ou-vy. Osẽ-ma ramo: —Pehexa katu íxupe. Ou-ma katu. Pema'ẽ katu hese, he'i Hesu-rehe Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ohexa-ma ramo íxupe pa'i ruvixa kwéry polícia kwéry ave onhe'ẽ hatã-ma osapukái-vy: —Ejuka katu íxupe. Kurusugwasu-rehe ejuka katu íxupe, he'i Hesu-rehe osapukái joa joa-vy hikwái. —Nahembiapo vaíry vérami ko xe-vy, he'i. —Upéa-gwi peẽ perahase ramo katu, peraha katu íxupe pehupi hagwã imoĩ-vy kurusu-rehe omano hagwã, he'i judeu kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Upéi ha'e kwéry he'i: “Xe ko Nhandejáry ra'y” he'i mo'ã ójehe. Ha ore katu ore rembypy Moisés remimombe'ukwe tekoha-rupi joty oroiko va'e. Hesu ae nainhe'ẽ rendúi. Upéa-gwi iporã katu ejuka íxupe, he'i mo'ã mburuvixa-pe Hesu-rehe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","“Hesu Nhandejáry ra'y” he'i-ma ramo, omongyhyjeve íxupe judeu kwéry nhe'ẽ. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oike jevy koty-py oporandu Hesu-pe: —Ki-gwi tipo ereju ra'e? he'i íxupe. Ha Hesu okirirĩ íxugwi. Mba'eve nde'íry mburuvixa-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Upéa-rehe oporandu jevy íxupe: —Ma'erã po neremombe'úi ra'e xe-vy? he'i. —Ejeapysaka katu xe nhe'ẽ-rehe, he'i. —Xe ko amanda va'e nde-rehe, he'i. —Apoi-ta para'e ndéhegwi. Orojuka uka-ta para'e kurusu-rehe, he'i íxupe Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Upe ramo Hesu he'i: —Nhandejáry nhe'ẽ-py mante eremanda xe-rehe ereiko-vy, he'i íxupe. —Ne rembiapo vai-ma xe-rehe. Ha judeu ruvixa nde-vy xe juka ukase va'e katu hembiapo vaivete-ma xe-rehe, he'i mburuvixa-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Upéa ohendu ramo opoise ise mo'ã íxugwi. Ha judeu kwéry onhe'ẽ hatã jevy-ma íxupe: —Mburuvixagwasu César katu ndojohu porãi onhemomburuvixa va'e-pe gwive. Upéa-gwi erepoi ramo íxugwi, ndojohu porãi va'erã erejapose va'e Hesu-rehe, he'i Pilatos-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Upéa ohendu ramo, he'i ogwenohẽ jevy hagwã Hesu-pe koty-gwi. Osẽ rire-ma, ogwapy-ma Pilatos oĩ-vy mburuvixa ogwapy haty-py. Upe opu'ã oĩ va'e ita-gwi ojapo va'ekwe ári ogwapy. Ha hebreu nhe'ẽ-py katu ohenói Gabatá-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ha upéi katu haimete-ma larose. Oiko-tama páscoa aretegwasu. Upe-ma ramo he'i judeu kwéry-pe Pilatos: —Pende ruvixagwasu ko ou-ma, he'i Hesu-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ha ha'e kwéry katu: —Emboja katu, emboja katu imoĩ-vy kurusu-rehe omano hagwã, he'i joa onhe'ẽ hatã-vy hese. —Pende ruvixagwasu ko peipota tipo xe ajuka íxupe, he'i oporandu-vy judeu kwéry-pe. Upe ramo he'i pa'i ruvixa kwéry: —Mburuvixagwasu César anho voi ko ore ruvixa va'e, he'i mo'ã Pilatos-pe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Upe-ma ramo Pilatos ojapo ha'e kwéry hemimbota. He'i omboja hagwã Hesu-pe imoĩ-vy kurusugwasu-rehe. Upéi ogweraha-ma íxupe omboja hagwã-py hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ha upéi katu Hesu osẽ oho-vy. Onhemboja hagwã kurusu-rehe oĩ-vy hagwã-py oho. Kurusugwasu ogweraha ho'yrã ojave oho-vy. Akã rendaty-py oje'e ha-py ogweraha íxupe. Ha hebreu nhe'ẽ-py katu ohenói Gólgota-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ha upéi katu ogwahẽ rire oho-vy upe-py, omboja íxupe imoĩ-vy kurusugwasu-rehe. Mokõi hembiapo vai va'e katu ave ohupi yvate. Hesu yke-rehe joja omoĩ íxupe kurusugwasu-rehe. Imbyte-py oĩ Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ha Pilatos katu ohai imombe'u hagwã: —Emoĩ katu kurusu-rehe Hesu akã ári, he'i omanda-vy. —“Ko va'e Hesu Nazaré pygwa judeu kwéry ruvixagwasu voi” he'i hagwã hese, he'i omanda-vy Pilatos. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Peteĩ nhe'ẽ ambue mbue-py ohai imoĩ-vy. Ohai hebreu nhe'ẽ-py, ohai latim nhe'ẽ-py. Grego nhe'ẽ-py ohai ave. Ha upéi katu heta judeu ou omonhe'ẽ ohai va'ekwe. Hi'agwĩ oĩ pe tetã-gwi Hesu rupi hagwe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Upéa-gwi pa'i ruvixagwasu oje'ói Pilatos oiko ha-py: —“Judeu ruvixagwasu” ani erehai teĩ. “Xe judeu ruvixa voi ko, he'i mo'ã ójehe” ehai ae katu, he'i íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ha Pilatos nohendúiry joty inhe'ẽ: —Upéixa ahai-ma kuri. Ndaipe'a mo'ãvéi-ma xe ahai va'ekwe, he'i judeu ruvixa kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ha irundy soldado katu omboja rire Hesu-pe imoĩ-vy kurusu-rehe, oipyhy ijaokwe omboja'o ja'o peteĩ teĩ ojóupe. Ha ikamisa pukukwe katu oipyhy ave. Onhembovyvy e'ỹ va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Upéixa ramo he'i soldado: —Ani eremondoro teĩ kamisa puku. Jahuga katu hese. Aipo ramo, ogana va'e togweraha katu, he'i ojóupe Hesu aokwe-rehe onhemogana-vy. Yma va'ekwe he'i Nhandejáry kwatia nhe'ẽ: “Xe aokwe omboja'o peteĩ teĩ ojóupe. Ohuga xe kamisa-rehe hikwái” he'i Hesu rehegwarã omombe'u-vy. Upéa-gwi hembihaikwe-rami voi ãy ojapo Hesu aokwe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ha upéi katu oĩ irundy kunha kurusu rovagwy-py. Oĩ Hesu sy. Upéi ikypy'ýry ave. Upéi Maria Madalena ave, Clopas rembireko Maria ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Upe ramo Hesu ohexa-ma osy-pe. Ijyke-rehe xe anhembo'y aĩ-vy. Xe hemimbo'e hembiayhu va'e. Xe rexa-ma ave. Ore rexa ramo, he'i osy-pe: —Ne memby voi upe va'e, he'i osy-pe xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Upéi he'i xe-vy: —Nde sy voi upe va'e, he'i xe-vy osy-rehe. Ha upe rire katu xe róga-py araha Hesu sy oiko hagwã xe ha-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ha upéi katu Hesu: “Ajapo va'erã gwive ajapopa-ma voi” he'i ojéupe. Ha Nhandejáry kwatia nhe'ẽ kwaaha voi Hesu. He'i va'ekwe Nhandejáry kwatia nhe'ẽ, “Xe y'uhéi-ma” he'i Hesu rekorã omombe'u-vy. Upéa-gwi hembihaikwe-rami: —Xe y'uhéi-ma, he'i ójehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Upe-py oĩ uva rykwere hepy e'ỹ va'e ryru. Upéi bucha omoakỹ. Yvyra apy-rehe, hissopo héry va'e apy-rehe omoĩ imondo-vy íxupe. Oipyte uka ho'u uka-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ho'u rire-ma: —Ajapo va'erã gwive, ajapopa-ma voi, he'i ójehe. He'i rire, onhakã reity-ma omano-ma. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Vierne omano Hesu. Iko'ẽ-my, sábado, oiko-ta aretegwasu. Omboete eterei upe va'e arete judeu kwéry. Upéa-gwi oipota omano pya'e: —Naiporãi oĩ arete-py omano hagwã-rami joty, he'i ojóupe judeu ruvixa kwéry. Upéa-gwi oho oje'ói-vy mburuvixa Pilatos oiko ha-py: —Ere katu omopẽ hagwã kurusu-rehe oĩ va'e retyma omano pya'e hagwã, he'i. —Ha upe rire katu eipe'a uka mani kurusu-gwi, he'i íxupe judeu ruvixa kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Upe ramo oho soldado omopẽ hetyma. Hesu yke-rehe ohupi va'ekwe-pe omopẽ hetyma. Upéi outro ijyke-rehe ohupi va'ekwe-pe omopẽ ave hetyma. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ha ogwahẽ ramo katu oho-vy Hesu oĩ ha-py: —Omano-ma oĩ-vy, he'i hese soldado. Upéa-gwi nomopẽiry hetyma. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nomopẽiry ramo jepe hetyma, oikutu joty kyse puku-py Hesu arokã-my. Upéi oikutu rire Hesu arokã-my osyry-ma hugwy y ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Xe ko hexahare voi. Amombe'u-ma ojehu va'ekwe perovia hagwã peẽ ave. Anhetegwa tee va'e amombe'uha peikwaa voi. Anhetegwa teeha xe aikwaa ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Ha upéi katu yma he'i va'ekwe Nhandejáry kwatia nhe'ẽ: “Ikãgwe ni peteĩ nonhemopẽi va'erã” he'i. Ha upéi he'i jevy outro Nhandejáry kwatia nhe'ẽ: “Kysepuku-py oikutu va'ekwe-rehe oma'ẽ va'erã hikwái” he'i va'ekwe Nhandejáry kwatia nhe'ẽ Hesu rekorã omombe'u-vy. Upéa-gwi hembihaikwe-rami katu ojapo-ma hese hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ha upe rire katu Arimatéia tetã mygwa José héry va'e ogwahẽ oho-vy Pilatos oiko ha-py. Upe-py oho ojerure hagwã Hesu retekwe-rehe: —Arahase amoĩ hagwã itakwa-py hetekwe, he'i Hesu-rehe oporandu-vy íxupe. —Eraha katu hetekwe, he'i íxupe Pilatos. Ha José katu Hesu nhe'ẽ renduha voi. Henduha jepe ikyhyje judeu ruvixa kwéry-gwi. Upéa-gwi teta-py nomoirũiry voi va'ekwe Hesu-pe. Ãy katu José oho-ma ogweraha-vy Hesu retekwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Hendive oho ave Nicodemos héry va'e. Upe va'e Hesu rexa-vy oho va'ekwe. Pyhare oho va'ekwe. Ãy oho ha'e José ndive. Heta ogweraha hyakwã va'e babosa mirra ndive héry va'e. Quarenta e cinco kilo ogweraha. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mokõive oipyhy hetekwe. Omohyakwã rire ae ao, onhugwã hetekwe ao-py. Upéa ojapo va'e judeu kwéry omano va'ekwe-pe heko-rupi ojaty rekovia omoĩ hagwã hetekwe itakwa-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hesu rupi hagwe-py oĩ yvotytygwasu. Upe-py oĩ itagwasu ikwa pyahu va'e. Ha'e-py nomoĩry vyteri hetekwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Hi'agwĩ voi oĩ upe yvotytygwasu. Ha sábado, judeu kwéry opytu'uha áry katu oiko-tama ave. Upéa-gwi pya'e omoĩ hetekwe itakwa-py. Ha itagwasu-pe ave omboty. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ha upéi domingo voi ramo, pyharevete kwarahy hembipe rei vyteri ramo, pytũ para para vyteri jave oho. Oho ohexa hagwã Hesu retekwe Maria Madalena. Upe-py ogwahẽ oho-vy ramo, ohexa-ma itagwasu imbotyhare. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ojepe'a-ma oĩ-vy. Upéa ohexa-ma ramo, oripara jevy imombe'u ou-vy. Ogwahẽ ou-vy Pedro oiko ha-py. Xe Hesu remimbo'e inhirũ tee va'e aiko ha-py ave ou omombe'u: —Oipe'a ra'e hikwái Nhandejáry Hesu retekwe-pe. Kipy po ogweraha omoĩ hagwã ra'e íxupe? he'i ore-vy ou-vy Hesu rehegwa omombe'u-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Upe-ma ramo ore mokõive va'e oroho orohexa hagwã hetekwe rendagwe-py. Pedro ndive xe aha. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ororipara oroho-vy. Ha xe hatãve aripara. Xe ranhe agwahẽ aha-vy upe-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Agwahẽ-ma ramo ajeayvy hetekwe rendagwe ahovapyexa hagwã. Ijaokwe imorotĩ porã va'e ahexa inhugwã hagwe mate oĩ ramo. Ha ndaikéiry. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Xe rapykwéri ogwahẽ ou-vy Simão Pedro ave. Ou-ma oike-ma itakwa rye py-py. Ijaokwe imorotĩ va'e mante ave ohexa. Inhugwã hagwe mo'ã oĩ. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Upe hovaho'i hagwe noĩry ijaokwe imorotĩ va'e ndive. Upe va'e anho oĩ. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Upéi xe agwahẽ ranhe va'ekwe, aike ave va'ekwe itakwa rye py-py. Ahexa-ma ramo, arovia-ma. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ha Nhandejáry kwatia nhe'ẽ, Hesu oikove jevy va'erã, he'i va'ekwe katu, ne'írã oroikwaa he'ise va'e. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ha upéi katu oroho jevy ore róga-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ha Maria Madalena katu ndoikéiry itakwa rye py-py. Ita yke-rehe opyta hasẽ oĩ-vy. Gwasẽ reheve ojeayvy ohovapyexa hagwã. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Upéi ohexa-ma mokõi Nhandejáry rembigwái yváy pygwa va'e. Ao morotĩ va'e omonde ramo ohexa. Hesu rupagwe ári ogwapy oĩ-vy. Peteĩ inhakã rupagwe-py, outro ikupy rendagwe-py. Mokõive oporandu íxupe: ");
INSERT INTO kgkNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","—Ma'erã tipo ne rasẽ, he'i kunha-pe. Kunha he'i íxupe: —Ogweraha ra'e xe Járy retekwe, he'i íxupe kunha. —Kipy po omoĩ ra'e íxupe, xe ndaikwaáiry, he'i mokõive va'e-pe kunha. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Upéa he'i rire, ojerova ramo ohexa Hesu-pe onhembo'y oĩ-vy ramo. Hesu teĩ nipo ra'e ohexa, ha kunha ndoikwaáiry íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—Ma'erã tipo ne rasẽ ereĩ-vy? he'i. —Kiva'e-pe tipo ereheka ereiko-vy, kunha, he'i kunha-pe Hesu. “Yvotyty-rehe onhangarekoha voi upéa” he'i mo'ã opy'apy-py kunha Hesu-rehe. Upéa-gwi he'i Hesu-pe: —Ereraha ramo ra'e íxupe, eremoĩ ambue henda-koty emombe'u katu xe-vy, xe araha hagwã íxupe, he'i mo'ã Hesu-pe ndoikwaái-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—Nde Maria, he'i íxupe Hesu. Upe-ma ramo oikwaa-ma íxupe ojerova Hesu ha-koty: —Nde Raboni, he'i íxupe onhe'ẽ-py hebreu nhe'ẽ-py. Raboni he'ise xe mbo'eháry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ha upéi katu he'i íxupe Hesu: —Ndajeupíry vyteri aha-vy xe Ru oiko ha-py, he'i. —Upéa-gwi anive xe kwavã teĩ. Tereho mani katu nde xe re'ýi oiko ha-py emombe'u xe nhe'ẽ: “Ajeupi-ta aha-vy xe Ru ha-py. Xe Ru ko ha'e kwéry Túvy ave. Xe Járy ijáry kwéry ave. Upe va'e ha-py ajeupi-ta aha-vy” he'i. —Ko va'e nhe'ẽ eraha emombe'u katu íxupe kwéry, he'i kunha-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Upe-ma ramo Maria Madalena oho jevy omombe'u Hesu remimbo'e kwéry-pe: —Ahexa-ma kuri Nhandejáry Hesu-pe, he'i gwemimbo'e kwéry-pe. Upéi omombe'u íxupe Hesu nhe'ẽgwe. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Upe áry-py domingo ka'aru ete ojogweroaty oĩ-vy koty-py Hesu remimbo'e kwéry. Ikyhyje voi judeu ruvixa-gwi hikwái. Upéa-gwi hatã omboty hikwái okẽ. Upe-ma ramo ogwahẽ-ma ou-vy Hesu. Ipa'ũ-my ojekwaa-ma oĩ-vy: —Tapende py'agwapy katu xe-rehe, he'i-ma íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Upéa he'i rire, ohexa uka íxupe kwéry opo oikutu hagwe. Oarokã oikutu hagwe ohexa uka ave. Ojáry-pe ohexa ramo, ovy'a eterei-ma hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Upe ramo he'i jevy íxupe kwéry: —Tapende py'agwapy katu xe-rehe, he'i. —Xe Ru nhe'ẽ-py aju va'ekwe-rami, ãy xe nhe'ẽ-py apomondo-ta ave pemba'apo apo hagwã-rupi, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Upéa he'i rire, oipeju peju íxupe kwéry: —Toike katu pende py'a-py Nhe'ẽ Marangatu tee va'e, he'i opytu-py oipejukwe-vy. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","—Peje ramo, “Tomboyke katu ne rembiapo vaikwe Nhandejáry” peje ramo, omboyke va'erã Nhandejáry íxugwi hembiapo vaikwe. Ha peje ramo katu, “Ani Nhandejáry omboyke ne rembiapo vaikwe” peje ramo, nomboykéi ave va'erã íxugwi hembiapo vaikwe, he'i gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ogwahẽ ramo Hesu, ndoikóiry koty-py hemimbo'e héry va'e Tomé. Dídimo-py ohenói íxupe ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Upe rire ogwahẽ ramo Tomé, omombe'u íxupe outro hemimbo'e kwéry: —Orohexa-ma kuri Nhandejáry Hesu-pe, he'i Tomé-pe omombe'u-vy. Upéi he'i íxupe kwéry Tomé: —Xe ndaroviáiry, he'i Tomé. —Xe ahexa e'ỹ reheve ipo ikutu hagwe, ndarovia mo'ãi, he'i. —Amoĩ e'ỹ reheve xe po inharokã-rehe ikutu hagwe-py, ndarovia mo'ãi voi xe, he'i oirũ kwéry-pe Tomé. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Peteĩ semana rire hemimbo'e kwéry ojogweroaty jevy-ma koty-py oĩ-vy. Hendive oĩ-ma Tomé. Onhemboty hatã hokẽ gwive. Onhemboty hatã ramo jepe, ogwahẽ-ma ou-vy Hesu ipa'ũ-my onhembo'y-ma oĩ-vy: —Tapende py'agwapy katu xe-rehe, he'i íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Upe-ma ramo he'i Tomé-pe: —Emoĩ a-py ne kwã erehexa hagwã xe po, he'i. —Eipyso katu nde po emoĩ katu ne kwã xe arokã-rehe xe kutu hagwe-py ereikwaa hagwã, he'i. —Ani ne mba'e rerovia e'ỹ teĩ. Erovia tee katu, he'i Tomé-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—Xe Ruvixa voi ko nde ra'e, he'i. —Xe Járy voi ra'e, he'i íxupe Tomé. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Upéi Hesu he'i íxupe: —Néi, he'i. —Xe rexa-gwi xe rerovia-ma, Tomé, he'i. —Ha gwĩ xe rexa e'ỹ reheve xe rerovia joty ramo, arovy'a voi íxupe. Oiko porã porã tee rei va'erã upéa, he'i Tomé-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ha Hesu katu heta hembiapo porã porã voi opu'akaha-rupi oiko-vy. Heroviapyrã-rupi ojapo gwemimbo'e kwéry remiexagwã. Ha namoĩmbáiry ko va'e kwatia-py. Heta kwatia-rehe amoĩ e'ỹ va'e oĩ. ");
INSERT INTO kgkNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ha ko va'e katu kwatia-rehe amoĩ va'ekwe. Peẽ-my gwarã amoĩ-ma peje hagwã Hesu-rehe: “Cristo nhane remiha'arõ va'e voi Hesu nipo ra'e. Nhandejáry ra'y tee voi nipo ra'e” peje hagwã Hesu-rehe amoĩ-ma. Aipota pejerovia-ma hese peiko-vy Hesu réry-py peiko meme hagwã Nhandejáry ndive. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ha upe rire katu Hesu ojehexa uka jevy gwemimbo'e kwéry-pe. Tiberíades ygwasu rembe-rehe a-rami ojehexa uka. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Upe-py ojogweroaty oĩ-vy Simão Pedro Tomé ndive. Dídimo-py onhehenói ave Tomé. Hendive oĩ ave Caná da Galiléia pygwa Natanael. Omoirũ ave íxupe Zebedeu ra'y. Outro mokõi Hesu remimbo'e omoirũ ave íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Upe ramo Simão Pedro he'i oirũ-pe: —Aha-ta ajopói pira, he'i oirũ-pe. —Ne ndive oroho-ta ave pirapói-vy, he'i Pedro-pe hikwái. Upe ramo ohopa onhemboyru kanóa-py oje'ói-vy. Pyhare-rupi oho ojopói pira mo'ã ha nogwenohẽiry mba'eve. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Iko'ẽ-my hembipe rei vyteri jave kwarahy, ohexa-ma Hesu-pe oĩ-vy ramo y rembe-py ojekwaa oĩ-vy. Hesu ohexa ramo jepe, ndoikwaáiry íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Upe ramo oporandu Hesu: —Napenohẽi tipo pira, xe ra'y? he'i íxupe kwéry. —Mba'eve norogwenohẽiry, he'i íxupe hikwái. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Aipo ramo, pemombo katu kyha kanóa akatúa-koty. Penohẽ va'erã pira, he'i íxupe kwéry Hesu. Inhe'ẽ-py omombo ramo ogwenohẽ. Upéi ndikatuvéi-ma ogwenohẽ jevy kyha ipohýi-gwi. Ndikatúi omboyru kanóa-py. Heta eterei pira ojepyhy ra'e kyha-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Upe-ma ramo xe Hesu irũ tee va'e ha'e Pedro-pe: —Nhandejáry Hesu voi upe va'e —ha'e amombe'u-vy. Upéa ohendu ramo, omboi va'ekwe oao jo'a omonde jevy ho'a hagwã y-py. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ha outro hemimbo'e kwéry katu ogwahẽ ou-vy kanóa-py. Hi'agwĩ oĩ y rembe-gwi. Cem metro-rupi ogwahẽ hagwã. Upéa-gwi ou kanóa-py ombotyryry heru-vy kyha pira reheve. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Osẽ rire kanóa-gwi ohexa tata. Tata ári omoka'ẽ-ta pira. Mbojape ohexa ave. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Upéi he'i Hesu: —Penohẽ va'ekwe-gwi pira, eruve nhamoka'ẽve va'erã pira, he'i gwemimbo'e kwéry-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Upe ramo Simão Pedro onhemboyru jevy kanóa-py kyha otira hagwã heru-vy. Upéi ombotyryry heru-vy yvy ete-py. Pira omohynyhẽ voi kyha. Kyha py-py oĩ cento e cinqüenta e três pira tuvixagwe va'e. Heta jepe pira, nomondoróiry joty kyha. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ha upéi he'i Hesu: —Peju katu jakaru, he'i íxupe kwéry. Ha ha'e kwéry katu oikwaa Nhandejáry Hesuha voi upe va'e. Upéa-gwi noporandúi íxupe onhemombe'u hagwã. Ndaipy'agwasúi oporandu hagwã. Upéa-gwi noporandu jepéiry. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ha upéi katu Hesu oho ome'ẽ me'ẽ va'erã oipyhy. Mbojape ome'ẽ íxupe kwéry. Upe rire ome'ẽ me'ẽ pira ka'ẽ ave íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Upéixa voi oikove jevy rire, mbohapyha-rehema ojehexa uka jevy gwemimbo'e kwéry-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Okaru rire, oporandu Simão Pedro-pe Hesu: —Xe rayhu tee tipo nde, João ra'y Simão? he'i. —Xe rayhu-ma voi ne irũ. Nde tipo xe rayhuve joty tipo nde? he'i Pedro-pe. —Ha'e katu. Ereikwaa voi xe orohayhuha, xe Járy, he'i Hesu-pe. —Aipo ramo, enhangareko katu xe re'ýi-rehe ereiko-vy. Ovexa-rehe onhangareko va'e-rami, enhangareko hese, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Upéi oporandu jevy íxupe: —Nde tipo xe rayhu, João ra'y Simão, he'i. —Ha'e katu, he'i. —Ereikwaa voi xe orohayhuha, xe Járy, he'i Hesu-pe. —Aipo ramo, enhangareko katu xe re'ýi kwéry-rehe. Ovexa rerekwa-rami eiko íxupe kwéry, he'i Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Upéi mbohapyha-rehema oporandu jevy íxupe: —Xe rayhu tipo nde, João ra'y Simão, he'i íxupe. Upe-ma ramo ndovy'avéi Pedro. Mbohapyha-rehe oporandu íxupe-gwi ndovy'avéi-ma. He'i Hesu-pe: —Opamba'e ereikwaa va'e, xe Járy. Xe orohayhuha ereikwaa ave, he'i Pedro. —Aipo ramo, he'i —enhangareko katu hereko-vy xe re'ýi kwéry-rehe. Ovexa rerekwa-rami enhangareko hese, he'i. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","—Ne mitã ramo katu, nde ku'a jopyha eremoĩ ndéjehe eremboty eregwata hagwã. Erehose ha-koty ereho voi va'ekwe. Ha amombe'u-ta nde-vy anhetegwa tee va'e. Nde tuja ramo, ereipyso va'erã nde po nde pokwa hagwã. Upéi nde reraha va'erã erehose e'ỹ ha-koty. Nde pokwaha-rehe ereho va'erã, he'i Pedro-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Upéa he'i oikwaa uka hagwã Pedro-pe, mba'éixa po Pedro omano hagwã: —Xe moirũ meme-gwi ojejuka uka ramo, omano ramo, ohexa uka va'erã enterove va'e-pe Nhandejáry rekoha porã, he'i Pedro omano-taha áry omombe'u-vy. Ha upéi katu he'i Pedro-pe: —Xe moirũ katu ereiko-vy, he'i íxupe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Upe rire ojerova Pedro xe rexa gwapykwe-gwi, xe Hesu irũ tee va'e aju ramo. Kwehe arete-py orokaru ramo, ha'e va'ekwe Hesu-pe ojoyke reheve aĩ-gwi: “Kiva'e tipo ne mombe'u-ta nde pyhyrã-pe” ha'e va'ekwe Hesu-pe. Ãy xe agwata aju-vy Pedro rapykwéri-gwi. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ha Pedro katu ojerova ramo xe-rehe xe rexa ramo, gwapykwéri aju ramo, oporandu xe-rehe Hesu-pe: —Mbava'e tipo oiko-ta ou xe rapykwéri va'e-pe? he'i Hesu-pe xe-rehe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—Xe aipota nomanói xe aju jevy peve ramo ra'e, namombe'úi arã nde-vy ra'e. Nde katu xe moirũ ereiko-vy, he'i Pedro-pe Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Upéa-gwi Hesu remimbo'e kwéry he'i mo'ã ojóupe xe-rehe: “Nomano mo'ãvéi-ma upe va'e”. Ha upéa nde'íry Hesu. He'i ae: “Xe aipota nomanói xe aju peve ramo ra'e, namombe'úi arã nde-vy ra'e” he'i hese Pedro-pe. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ko va'e Hesu rehegwa nhe'ẽ gwive katu xe remimombe'u voi. Xe rembihaikwe ave voi. Anhetegwa tee va'e amombe'uha jaikwaa voi. ");
INSERT INTO kgkNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Heta Hesu rembiapo apo xe remimombe'u. Heta xe remimombe'u e'ỹ ave. Peteĩ teĩ omoĩ meme ramo Hesu rembiapo gwive, kwatia-rehe omoĩmba ramo, heta eterei arã oĩ kwatia. Ko yvy ári ndaiporivéi-ma arã vérami henagwã. Heta verei-gwi, ndaijavéi-tama vérami xe-vy.");
INSERT INTO kgkNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Are-ma xe Lucas amondo va'ekwe nde-vy, Teófilo, xe nhe'ẽ kwatia-rehe. Hesu rehegwa nhe'ẽ gwive amoĩ va'ekwe kwatia-rehe. Hesu ojapo va'ekwe gwive rehegwa nhe'ẽ amoĩ va'ekwe. Omombe'u va'ekwe gwive rehegwa nhe'ẽ amoĩ ave. ");
INSERT INTO kgkNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Onhypyrũ ombo'e mbo'e ojererojeupi oho peve yváy-py rehegwa nhe'ẽ amoĩ ave. Ohenói va'ekwe gwemimondo va'e, gwembiporavõpyre-pe ome'ẽ hagwã hembiaporã. Ha Nhe'ẽ Marangatu tee va'e katu oikwaa uka porãve íxupe kwéry hembiaporã. Hesu ome'ẽ ranhe íxupe kwéry hembiaporã. Ome'ẽ rire katu ha'e ojererojeupi jevy oho-vy. ");
INSERT INTO kgkNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ko'ãy amondo jevy-ta xe nhe'ẽ nde-vy, Teófilo. Hesu omano rire ha'e onhemoingove jevy va'ekwe voi. Oikove jevy ramo, ojehexa uka porã porã va'ekwe voi oiko-vy gwemimondo kwéry-pe. Quarenta áry ojehexa uka uka jevy oiko-vy va'ekwe íxupe kwéry. Nhandejáry nhande ruvixarã rehegwa nhe'ẽ omombe'u oiko-vy. Ohexa ramo íxupe: “Ereikove jevy-ma nipo ra'e” he'i íxupe hemimondo kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ijave kwéry opyta ramo Jerusalém-my: —Ani pesẽ teĩ ko tetã-gwi, he'i. —Pepyta katu pekwa-vy a-py, he'i Hesu íxupe kwéry. —Xe Ru nhe'ẽ amombe'u va'ekwe peẽ-my: “Ambou va'erã Nhe'ẽ Marangatu tee va'e” he'i va'ekwe xe-vy xe Ru. ");
INSERT INTO kgkNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Upéa-gwi peha'arõ katu xe Ru remimbourã peẽ-my. Ha João Batista katu pene mongarai va'ekwe y-py. Ha ãy ae katu Nhandejáry omoĩ-tama kuri pende py'apy-py Nhe'ẽ Marangatu tee va'e. Pene mongarai jevy-ta vérami xe Ru, he'i íxupe kwéry Hesu. ");
INSERT INTO kgkNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Upéixa ramo Hesu ndive onhomboaty hemimondo kwéry: —Eremosẽ-ta tipo imondo-vy Israel re'ýi e'ỹ, mbo'eháry, he'i íxupe hikwái. —Eremosẽ-ta tipo íxupe kwéry Israel kwéry ae omanda jevy hagwã ojóehe, he'i oporandu-vy íxupe. ");
INSERT INTO kgkNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ha he'i Hesu: —Nhandejáry omoĩ va'ekwe onhe'ẽ peteĩ áry-py omosẽ hagwã imondo-vy Israel re'ýi e'ỹ kwéry-pe. Nhandejáry nhe'ẽ-py ogwahẽ va'erã hi'áry. Ha ndoikwaa ukái peẽ-my araka'e pa omosẽ-ta íxupe kwéry. ");
INSERT INTO kgkNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ha pene rembiaporã katu amombe'u-ta peẽ-my. Nhandejáry ombogwejy-ta peẽ-my Nhe'ẽ Marangatu tee va'e oiko hagwã pende py'apy-py. Ombogwejy-ta ne mbopu'aka tee hagwã.