﻿USE sofia;
DROP TABLE IF EXISTS sofia.kgf_vpl;
CREATE TABLE kgf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kgf_vpl WRITE;
INSERT INTO kgf_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Ic ségi ségiyaguc imi ic ʒipiliŋ ʒapalaŋa ionac niniŋ areŋgia imi ménda méndacma kemma, képésic ic ionac kekecac hénaiguc momacnec ménda namma, ʒédesi ic iniguc momacnec ménda tacanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Néŋ Yaweac héna acwac ewa siŋa heyu, siŋi kaiwe séc héna ac imi ʒéniŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Inéŋ ic hésa doku téfara giŋgiŋaiguc himicgic naŋanʒac ésécnec haréŋa ménda bura tiyu naléya méndacma héla gocmia haianʒac. Inéŋ imuac me imuac ai meyu hiabianec saima keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Néŋ ic ʒipiliŋ ʒapalaŋa imi imuhuc qahac. Inéŋ imi gorosoŋa sénéwéra luhucnéŋ mihilaŋgéyu keŋanʒac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Imuac niŋac ic ʒipiliŋ ʒapalaŋa ieneŋ imi Anutunéŋ kitiwa biria meleŋ énécmiyu hia ménda naŋselimu. Waŋu képésic ic ieneŋ ic solaŋa iniguc momacnec kecmuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Ic hiabia imi Yawenéŋ inicgaleŋ waŋ énécmianʒac, néŋ ic ʒipiliŋ ʒapalaŋa imi eneŋ tima keŋanʒu héna imuac tetecgia imi humu qai wawaŋa. ");
INSERT INTO kgf_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Némac niŋac baera baera ic embac ieneŋ qeqetali ac qeweloŋa wamma, imuac ic embac ieneŋ ai gorosoŋa imuhucyawac niŋareŋ waŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Waŋu Yawe ʒéma iwac halécnéŋ météré mima gésimimia iorac haʒéc waŋ érécmima baecac ic kewu ieneŋ ʒéréŋqéréŋ wamma naŋgic, baecac galeŋhéra ieneŋ momacnec toroqe amuma yomuhuc emininʒu; ");
INSERT INTO kgf_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Seŋ hésa ɋaté nénécmizac imi qetecgéma hésa selia ʒiki sipac menénéc mizac imi hulac gilidacbiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Waŋu ou kurumeŋiguc tacʒac inéŋ desi énécmizac. Miŋ Kewunéŋ isocfagociguc onopocʒac. ");
INSERT INTO kgf_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Inéŋ qeri geric wamma ac waŋ énécmizac, tericgé énécmima yomuhuc ʒézac; ");
INSERT INTO kgf_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","Nenaoc, nena ic kewu, nuac baec boŋa téréya Zioniguc kumuwa nanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Imuac ni miŋ kewuac ʒézé seli ac imi ʒéau énécmiwa baec séc kenʒac. Yawenéŋ yomuhuc nézézac; Gi imi nuac naŋna. Deguc ni héri haima mihicŋi génʒua. ");
INSERT INTO kgf_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Ʒéwelecnénna neŋ nuac mératéc baec séc ic embac hénia hénia imi gémba guac buŋa wandacmu. Waŋu baec tetecgia séc mocʒoŋ guac buŋa wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Waŋu geŋ aiŋ ɋarucganéŋ haʒéchécga unuwésémaŋ. Kewuc nomuŋ ésécnec qéséŋénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Imuac baera baera ic kewu ini niŋtegic qiŋtegic ginaguc wammu. Baera baera galeŋ ini goro ac imuac gezac haimu. ");
INSERT INTO kgf_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Bac yandi yandi wamma Yaweac weleŋ qemima, bac yandi yandi wamma ʒézé ségiségi wammimu. ");
INSERT INTO kgf_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Qeri geric waŋ énécmiyu baec hénaginaiguc biriwu niŋac. Iwac naŋa kiricne mima weleŋ qemimu. Qeri birianéŋ élanzaŋnec geric bélaŋ ésécnec yacma onowac niŋac. Iwac muru héima naŋanʒu imi eneŋ mocʒoŋ ségiségi ginaguc wammu. ");
INSERT INTO kgf_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","(Dawidinéŋ eŋeya naŋa Apsalomac wésia igucnec néŋgacma keŋec nalé imuaru oyec.) Yawe, haʒéc hécna imi yei sasala yanda. Ic embac haʒéc wannémma yaré qewiŋ ʒéma yacma nanʒu imi sasala yanda. ");
INSERT INTO kgf_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Ic embac sasalanéŋ nuac yomuhuc ʒéanʒu; Anutunéŋ aŋgéŋa ménda tianʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Néŋ Yawe, gi imi nuac saiwa, nuac edamuna, nuac orucna meyac néŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Ni Yaweac kucnec ewa ewananéŋ qacma héiwa, inéŋ iwac baec boŋa téréyaiguc acna meleŋ néŋanʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Ni ama siŋiyu gau heanʒua. Waŋu Yawenéŋ néŋgaleŋ waŋnéŋu siŋunec muŋguc yacanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Haʒéchécna tauseŋa tauseŋa ieneŋ lelecgé néŋgic, néŋ ni bac yandi yandi ménda waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","8","Aŋgéŋ titi imi Yawe guac murunec. Miŋ kewuac mériaŋ imi ic embachécga qacginaiguc mama heanʒac. Imuac niŋac, Yawe, gi yacna! Oh nuac Anutu, ni aŋgéŋna tina. Nuac haʒéchécna nekaŋgina kuma ic ʒipiliŋ ʒapalaŋa ionac ʒécgina héʒéŋgéna. ");
INSERT INTO kgf_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","(Legic galeŋawac; waŋgoŋ hésiaguc, Dawidiac legic ʒéra.) Anutu, nuac solaŋa miŋina, ni guac qacma guruwa acna meleŋ némbésémaŋ, ni baec wéŋwéŋgiaiguc kecba baec kondoŋa mihicŋi nénnec, imuac ewa hia niŋnémma ʒéwelecna niŋna. ");
INSERT INTO kgf_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Baec ic ionac naŋhéra ini nalé dahecac séc gamu qeqe mihicŋi némmu? Nalé dahecac séc edamuna imi meleŋgic gamu qeqeac buŋa waŋu, haka biriawac siŋa nimma baniara méndac énécmima kecmu? (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Yawenéŋ eŋeya niŋac wamma siŋ niŋmianʒac i gésimiyec imi niŋasarimu. Imuac ni ʒéwelec wamba Yawenéŋ nimma kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Ini bac yandi yandi wamma képésic ménda wammu. Gaugina hewiŋ ʒé emma acgina qaiyu bénʒéŋnec qeriginanéŋ ʒéma nimmu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Miŋ Kewuac muru hakagina solaŋa iminéŋ mulu ésécnec haimimu. Yaweac muru héima nammu. ");
INSERT INTO kgf_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Ic embac sasalanéŋ Mérénéŋ haka silic hiabia méŋ nénézéyu hémbiŋ? ʒéanʒu. Imuac Yawe gi guac kic tanecga asac mararaŋa gucnéŋ ninicna. ");
INSERT INTO kgf_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Miŋ Kewunéŋ nuac ewa qerinaiguc ségiségi kuneŋ yanda tiyu sécgéanʒac. Ségiségi iminéŋ padi me waiŋ ɋelianéŋ sécgéyu ségiségi waŋanʒiŋ imi qeyu maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ni imuhuc solaŋanec demiŋ menémma néŋgaleŋ waŋnéŋanʒac imi Yawe momacguc sac kecʒac, imuac mia ni ewana déŋ waŋu gauna heanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","(Legic galeŋawac; kuŋaguc héigic, Dawidiac legic.) Yawe nuac acnawac gezac haina. Nuac yaiwisisiŋ acna niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Méra némbésémaŋ niŋ wamma guru héhéli génʒua imi nimbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Yawe, siŋunec séc geŋ nuac ac ewana niŋanʒaŋ. Acna meleŋ némbésémaŋ niŋac siŋunec ʒéwelecma bénʒéŋnec mambéc kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Hénia imi yomuhuc; Miŋ Kewu gi biriawac siŋa ménda niŋanʒaŋ. Ic birianéŋ giguc hia tacyac ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Séwi eŋeŋ icnéŋ guac wéségaiguc nammuac séc qahac. Miŋ Kewu gi imi haka silic biria waŋanʒu imi onac méʒéga kuneŋ yanda tianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Yawenéŋ ikoc ac ʒéanʒu imi unuma sac naec énécmianʒu imi ʒéma tilic qilic ic ionac méʒéya tianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ni imi Miŋ Kewu guac goi héihéiganéŋ naŋgé néŋu kucna mihicŋima Miŋ Kewuac ocmuŋ téréyaiguc keremmaŋ. Eega héigémma simiŋ héigémba Miŋ Kewu guac ocmuŋ téréyawac muru kemmac. ");
INSERT INTO kgf_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Yawe, nuac leleciguc haʒéchécna sasala kecʒu, imuac Miŋ Kewu guac héna solaŋaiguc nuagicma kenna, Miŋ Kewu, hénaga dindiŋa imi nézéna hémba. ");
INSERT INTO kgf_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Imuac hénia imi yomuhuc; Kuaginaiguc imi ac héla méŋ ménda hezac. Ewa qerigina imi ic embac mebiri énécmiwiŋ ʒé niŋareŋgégic sécgédacʒac. Waŋu déméŋgina imi kic suaŋ aŋaŋgia ésécnec. Waŋu ezelaŋgina iminéŋ haléc ac efima ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Anutu, ionac imi képésic ginaguc ʒéénécmina. Waiénécmina eŋaŋ niniŋ bétaciguc eŋaoc hiŋgacgic inimac. Ieneŋ Miŋ Kewu andé qeanʒu, imuac niŋac wawaŋ memegina biria imuac niŋac wamma nesi énécmina kemmu. ");
INSERT INTO kgf_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Néŋ méŋnéŋ méŋ guac muru hama saŋgianʒu imi ségiségi mihicŋi énécmina. Ionac imi wai énécmina nalé tetecgia qahac ségiségiac legic héima kecmu. Ic imuhucya imi saiwa waŋ énécmina, guac waŋanʒu imi eneŋ guac niŋ wamma ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Yawe, gi imi hélacnec ic solaŋa mériaŋ mihicŋi énécmianʒaŋ. Guac ewa hiaganéŋ saiwa éséc demiŋ meénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","(Dawidiac ewa biricac legic, waŋgoŋ hésiaguc.) Yawe, qeri biricgaiguc ac ménda waŋnénna. Miŋ Kewu, guac qeri gericgaiguc ʒémindiŋi ménda waŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Yawe, ni kucna qahac, imuac ewa hia waŋnénna. Yawe, mehiaru nénna. Sicnawac toroya imi geriwa nozac. ");
INSERT INTO kgf_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Nuac kekec uŋananéŋ ʒuracgézac ésécnec geriwa nozac. Yawena nalé dahecac séc mambéc kecmaŋac hezac? ");
INSERT INTO kgf_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Yawe, liliŋgéma hama kekec uŋana metecgé nénna, Miŋ Kewuna goi héihéiganéŋ ni humuc igucnec aŋgéŋna tina. ");
INSERT INTO kgf_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Méŋnéŋ méŋ humumaguc Miŋ Kewu niŋɋelimacac séc qahac. Humuc ic ionac baec sasaŋgia igucnec mérénéŋ gi hia mepési gémmac? ");
INSERT INTO kgf_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ni ʒésilac wamma kecma birizua. Siŋi herec kic ɋelinec kecma siacba kic masinanéŋ hehena mézégézac. Siacma kecba aturu hehenanéŋ dokuyaguc wandacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Siac yanda waŋkecba kicnanéŋ biriyu hia hémmaŋac séc qahac wanʒac. Haʒéchécna niŋac siacba kic masinanéŋ waŋu kicnawac kuhanéŋ mazac. ");
INSERT INTO kgf_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Haka biria waŋanʒu ini mocʒoŋ nuac murunec néŋgacma kendacmu. Yawenéŋ nuac ʒésiacna niŋnénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Ewa biric waŋ némmac niŋac qerinanéŋ hélacnec qacma ʒéwelecba Yawenéŋ niŋnénʒac. Waŋu nuac ʒéwelecna imi késa aŋgétizac. ");
INSERT INTO kgf_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Nuac haʒéchécna imi gamu qeqe ʒéma bac yandi yandi kuneŋ yanda mihicŋi énécmiyu, gamugina nimma néŋgacma liliŋgéma kemmu. ");
INSERT INTO kgf_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","(Benʒaminac ɋelia méŋ Kusinéŋ ac wammiyu Dawidinéŋ ara bakia meleŋmiyec.) Yawe, nuac Anutuna, ni Miŋ Kewunawac muru saŋgi saŋgina mihicŋizua. Nesinénʒu mocʒoŋ yanda ionac murunec aŋgéŋna tima kératacnec népésina. ");
INSERT INTO kgf_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Imuhuc ménda waŋ némbaŋnec, ieneŋ laion yaŋ ésécnec kucnec hama kekec uŋana kiricqiric waŋ némbunec. Gi qahac waŋu metecgé nénéŋa méŋ ménda kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Yawe, nuac Anutuna, ni haka yomuhuc waŋi iguc, nuac méranaiguc hakana biria yomuhuc hezaciguc wai énécmina imuhuc hia waŋ némmu. ");
INSERT INTO kgf_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Ni ic méŋac képésic méŋ wammiyi iguc, héniaya qahac haʒécnawac iwawai méŋ wagiri iguc, ");
INSERT INTO kgf_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","wai énécmina haʒéchécna ieneŋ kekec uŋana nesima hama népésimu. Waŋu wai énécmina ieneŋ baeciguc kekecna tihumu némma edamuna imi seitotoŋiguc giligic hia mamac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Yawe, qeri biricgaguc yacbésémaŋ. Nuac haʒéchécna geric bélaŋginaguc haʒéc waŋ énécmima yacbésémaŋ. Anutuna, yacma nambésémaŋ. Héna ac nénézénec imuac séhaiguc waŋ énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Baera baera unuruna hama lelecgé géŋgic, geŋgaoc liliŋgéma hama ou eŋeŋa tacma inicgaleŋ waŋ énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Miŋ Kewunéŋ baera baera ic embac ʒégési nénécmimac. Yawe eŋeŋa miŋina, geŋgaoc solaŋ dindiŋa ʒéma haka héla qerinaiguc hezac imi héŋgésiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Qeri héhéŋ, solaŋa miŋina, gi imi niniŋnina batucgéma héŋanʒaŋ. Ic ʒipiliŋ ʒapalaŋa ionac haka biria imi metecgéma haka solaŋa mesolaŋanina nammac. ");
INSERT INTO kgf_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Eŋeŋa miŋina, Anutu, nuac saiwa kecʒac. Inéŋ ic embac qeri solaŋ kecʒu imi aŋgéŋ tiénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Anutu imi ʒégésigési ic solaŋa. Inéŋ naléya naléya qeri biric niŋénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Ieneŋ ewa qerigina ménda mindiŋimuiguc Anutunéŋ souya ʒéra qericma tewiya héré muimaŋac ʒé ʒéréŋ qéréŋ wammac. ");
INSERT INTO kgf_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Anutunéŋ ʒérabéra humumia ʒéréŋqéréŋ wandaru hezac. Inéŋ tewi geric bélaŋaguc miyacgéyu hezac. ");
INSERT INTO kgf_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Ic birianéŋ haka biria aʒi kiyu mihicŋizac. Inéŋ réwéri héri haima imuacnec merac ikora mezac. ");
INSERT INTO kgf_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Baec séséŋ tewi luacyaguc mihicŋianʒac i eŋeyaoc imuaru mama hiŋgacanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Kaiʒiliweŋa iminéŋ eŋeya oruc qahaiguc maanʒac. Ʒipiliŋ ʒapalaŋa iminéŋ eŋeya oruc siraiguc maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Ni Yawe imi solaŋawac niŋac ewa hia ac ézémaŋ. Eŋeŋa miŋinawac qara mepésimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","(Legic galeŋawac; Dawidiac legic ʒéra, waŋgoŋ hésiaguc.) Yawe neŋaŋ Miŋ Kewunina, guac qac buŋaganéŋ baec séc ʒézé ségiségiyaguc wanʒac. Gi imi ou kurumeŋiguc asac mararaŋga haina sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Miŋ Kewuac haʒéchéra ʒéma ac bakia melembiŋ ʒé waŋanʒu imi eneŋ acgina qaimac niŋac, Miŋ Kewunéŋ waŋu kokoc namu nene ieneŋ Miŋ Kewu mepésimigic kuhaguc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Miŋ Kewuna méraga merawanéŋ memeya kurumeŋ ʒéma imuac iwawai qeriaiguc haina hezac maso ʒéma ménni sikiluc imi kicna hima hémba kuneŋ yanda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Néŋ icac niŋna némaria waŋu, Miŋ Kewunéŋ niŋmianʒaŋ. Waŋu icac naŋa imi némaria waŋu héŋgaleŋ wammianʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Ic imi mihicŋima séha komora méŋ memamina kuaya meme uŋa ionac bacginaiguc kerec. Waŋu edamu ʒéma qac buŋa eŋeŋanéŋ ic kewuac opocya ésécnec haiminec. ");
INSERT INTO kgf_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Waŋu Miŋ Kewunéŋ ʒéhicŋiyec kekec iwawai imi mocʒoŋ inicgaleŋ wammac niŋac ʒémima iwac héna bawaiguc onopocnec. ");
INSERT INTO kgf_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Imi mia rama tuŋa tuŋa, burumakao tuŋa tuŋa, ʒéma ʒéléŋ baec kondoŋaiguc wiri yaŋ ʒéma ");
INSERT INTO kgf_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","sawaiguc nei hénia hénia ʒéma konduŋ dokuiguc lambéc ʒéma iwawai hicŋima héna hezac séc keŋha waŋanʒu imi mocʒoŋ yanda momacnec. ");
INSERT INTO kgf_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Yawe neŋaŋ Miŋ Kewunina, guac qac buŋaganéŋ baec séc ʒézé bipiyaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","(Legic galeŋawac; Dawidiac legic ʒéra; Soŋgoŋ legic ‘Naŋa humuzac’ imuac ewaiguc.) Oh, Miŋ Kewu, ni ewa qerina mocʒoŋnec Yawe qacma mepési génʒua. Ai welicwelicgia wamma menec imi mocʒoŋ ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Ni Miŋ Kewu guac ségiségi wamma ewa hia nimmaŋ. Eŋeŋa miŋina kecanʒaŋ guac qacga gita kulele qema mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Nuac haʒéchécna ieneŋ néŋgacbiŋ ʒé liliŋgégic, néŋ guac wéségaiguc qonʒontoŋ géma mama humudacgic. ");
INSERT INTO kgf_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Imi mia hénia yomuhuc niŋac; Geŋ mia nuac solaŋ dindiŋa ʒéma acna héipuc wannémma meselinec. Ic kewu tatacgaiguc tacma dindiŋanec ʒétecgénec. ");
INSERT INTO kgf_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Geŋ baera baera ac geriwaguc waŋ énécmima ic biria mebiri énécmima qacgina hémbénaŋawac auna qahac wandacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Humuc hémbénaŋanéŋ haʒéchécna énépésiyecac kecʒac. Waŋu ama areŋa areŋa yanda demiŋ seliaginaguc imi ic gétéya ésécnec héréma qéʒidacnec. Méŋnéŋ méŋ ama areŋ imuac méndagucnec niŋɋelianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Yawenéŋ hémbénaŋa kecanʒac. Inéŋ ʒégésigési ai niŋac ic kewu tatacya miyacgéyu hezac. ");
INSERT INTO kgf_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Inéŋ solaŋanec baera baera imuac tacyachéra ʒégési énécmianʒac. Waŋu dindiŋanec ic embac galeŋgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Yawe imi helanʒi énécmimia ionac kiropo selia wanʒac, ʒérabéra naléiguc eŋeyaoc demiŋ seli waŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Geŋ guac hochoc ai meanʒu imi ménda wai énécmianʒaŋ, imuac niŋac Yawe guac qacga ninʒu imi eneŋ guac héima nandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Ini imi Zion iguc kecanʒac Yawe imi mepési migic. Iwac haihaka imi baera baera ic embac sucginaiguc ʒéau énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Ic méŋac sacnéŋ mayu haka imuac ʒéqesi énécmianʒac inéŋ mia niŋɋeli énécmima kecmac. Inéŋ maqeqeya, gum bénʒénʒéŋ mema amuma kekec, tidacgé énécmimia ionac ʒésiacginawac ménda eluŋ qemac. ");
INSERT INTO kgf_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Yawe ewa hia waŋnénna, haʒéc wannénʒu ieneŋ tilanʒi néŋkecʒu imi hénna. Gi humuc ac saŋgulaŋaiguc ni meyac néŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Imuhuc waŋ nénna ni guac mepé qepésiac legic imi énézédacmaŋ. Ninna béracga tanec waŋanʒac Zion kiropo imuac saŋgulaŋ yandaiguc aŋgéŋ titi aiga menec imuac wamma ségiségi wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Baera baera ieneŋ baec séséŋ eŋaoc éségic imuaru mama hiŋgacgic. Waŋu ufic eŋaoc musaŋgéma haigic iminéŋ eŋaŋ hénagina késazac. ");
INSERT INTO kgf_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Yawenéŋ tasia meénécmima eŋeya hénia mewininiyu niŋgicac nindacʒu. Ic biria eneŋ iwawai eŋaŋ méraginanéŋ miyacgégic iminéŋ ʒiki sipac meénécmizac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Kaiʒiliweŋ ic ieneŋ humuc ic ionac baec saŋgeŋaiguc liliŋgéma kendacmu. Anutuac eluŋ unuyec imi eneŋ mocʒoŋ imuhuc wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Maqeqeya ionac imi nalé séc eluŋ ménda qemac. Maqeqeya imi onac kic hihi imi hémbénaŋa haréŋa ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Yawe gi yacma nanna. Baec icnéŋ meseliwu niŋac. Baera baera imi eneŋ guac kicgaiguc ʒétecgé énécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Oh Yawe, bac yandi yandi mihicŋi énécmina, baera baera imi eneŋ héniagina niŋtegicma baec icdac imuhucya kecʒu imi niŋasarimu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Yawe, némac niŋac lakec naŋkecʒaŋ? Némac niŋ ʒérabéra naléiguc saŋgima kecʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Ic birianéŋ séwi eŋeŋ wamma ic kucya mamaya nesi mikecʒac. Geŋ ʒéna manam batuc areŋgéyu hezac imuaru eŋeyaoc mama hiŋgacmac. ");
INSERT INTO kgf_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Ic birianéŋ eŋeya kekec uŋayawac ewa siŋ imuac mepési amuanʒac. Hémbaoc icnéŋ Yawe ʒéhiaru mimaguc mematiti wammima keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Ic birianéŋ séwi eŋeŋ ac kic tanecya wamma Yawenéŋ ménda kic hima néŋanʒac ʒéma niniŋa imuac me imuac séc Anutu ménda kecʒac. ʒéma niŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Iwac hénayanéŋ nalé séc seligima heyu, guac ʒégésigésiac tatacnéŋ ou taru inéŋ héŋtegicmacac séc qahac waŋu, haʒéchéra mocʒoŋ ionac imi mematiti waŋ énécmima kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Eŋeya ewa qerianéŋ ni imi keŋqe haqena qahac hicŋisaiya hicŋisaiya yéwéri méŋ ménda mihicŋimaŋ imuhuc ʒéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Iwac kuayaiguc imi saec ac ʒéma ikoc ac ʒéma ʒébiri qébiri acnéŋ sécgéma heyu ezelaŋa bawaiguc imi réwéri ʒéma kaiʒiliweŋnéŋ hezac. ");
INSERT INTO kgf_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Inéŋ ama areŋ maréŋaiguc mambéc tacma sasaŋgiaiguc ic képésic solaŋ kekera unuhumuanʒac. Waŋu ic maqeqeyawac niŋu neneyawac tanec waŋu imuac kiwa hima awima tacanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Inéŋ laion yaŋnéŋ ʒunʒuŋaiguc tacanʒac ésécnec sasaŋgiaiguc héima tacma ic maqeqeya késamaŋ ʒé mambéc keru hayu uficyanéŋ késahéréma keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Inéŋ tererema héima taru ic maqeqeyanéŋ mériaiguc eŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Waŋu ic birianéŋ ewa qeriiguc yomuhuc ʒéanʒac; Anutunéŋ eluŋ qeyu kecanʒac. Waŋu kic tanera imi usuyaguc imuac hémbénaŋa hémmacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Yawe, yacma nanna. Anutu, méraga meyacna eŋu. Ic maqeqeya helanʒi énécmimiawac eluŋ ménda gumac. ");
INSERT INTO kgf_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Ic birianéŋ Anutu mematiti wammima Inéŋ hakana biria yomuac ménda ʒéqesi waŋ némmac. ʒéma niŋanʒac imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Geŋ imi héndacʒaŋ. Ewa biric ʒéma yéwéri imi héŋsosolima méraganéŋ tasia melemmaŋ ʒé ninʒaŋ. Imuac ic maqeqeyanéŋ guac muru héianʒac. Gi imi becarunec gupaŋ merac héipuc wammianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Ic biriawac méria kuna. Ic biriawac haka biria imi mocʒoŋ mihicŋi dacmaguc hocma waiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Yawenéŋ tetecgia qahac hémbénaŋa ic kewu kecanʒac, baera baera ic embac imi iwac baec igucnec auénécmiyu humuqai wandacʒu. ");
INSERT INTO kgf_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Yawe gi imi ic memama amuma kecanʒu ionac ewa siŋgina imi niŋénécmianʒaŋ. Imuac ionac ewa qerigina meseli énécmima gezac qema niŋna. ");
INSERT INTO kgf_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Gupaŋ merac ʒéma helanʒi énécmimia ionac niŋac wamma ʒétecgé énécmina baec ic eneŋ muŋguc ménda tericgé énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Ni néŋgacma Yaweac muru saŋgizua. Ini némac niŋac kekec uŋanawac ézéma nei ésécnec néŋgacma nonac baec boŋaiguc hana ʒézu? ");
INSERT INTO kgf_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Ic biria ieneŋ tewiginaiguc ʒakoŋa mui hérétéŋ wanʒu. Ic qeri solaŋa tunumaŋiguc qewiŋ ʒé wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Baec nanaŋanéŋ bacgéyu ic solaŋanéŋ dimuhuc wammac? ");
INSERT INTO kgf_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Yawenéŋ eŋeya ocmuŋ téréyaiguc kecanʒac. Yaweac ic kewu tatacya imi kurumeŋiguc tacʒac. Imuacnec inéŋ kic hima baec ic neŋaŋ ninic tegicanʒac. Kicyanéŋ ninic sosolianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yawenéŋ ic solaŋa batucgé inicma ic biria ʒéma kaiʒiliweŋac siŋa niŋanʒac iwac kekec uŋayawac méʒia tianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Inéŋ ʒéyu salfanéŋ kia ésécnec mama ic biria onomac. Geric ʒéma salfa ʒéma luhuc bélaŋagucnéŋ ionac sokociguc mesécgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Yawe imi solaŋ dindiŋa, imuac ai solaŋawac siŋa niŋanʒac. Imuac ic solaŋa ieneŋ iwac kic tanera hémmu. ");
INSERT INTO kgf_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Yawe méra némbésémaŋ. Eega héianʒac imi humuqaimaŋ ʒé wanʒac. Ic hélanéŋ ic onac sucgina igucnec qahac wammaŋ ʒé wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Ic ieneŋ ama momac hécgina ac ikoc waŋ énécmima kecanʒu. Ac haléc ʒéma qeriginanéŋ lukeŋ luha waŋu ac ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Yawenéŋ haléc ac ʒéanʒu ionac kua taségina ʒéma séwi eŋeŋ ac ʒéanʒu ionac ezelaŋgina imi hericdacmac. ");
INSERT INTO kgf_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Ieneŋ ezelaŋ ninanéŋ meseliwiŋ, kuanina imi neŋaŋ buŋa, imuac mérénéŋ neuŋ hia héi nénécmimac? Imuhuc ʒéanʒu, imuac niŋac imuhuc waŋ énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Yawenéŋ yomuhuc ʒézac; Ic mété qététaŋa, helanʒi mimia ʒéma ic maqeqeya ionac ʒésilacgina niŋac ni deguc yacma onagicma baec imuhucgeŋ me imuhucgeŋ kembiŋ ʒé niŋkumu wanʒu baec ʒéra béra qahac imuaru keŋ onopocmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yaweac ackuaʒécnéŋ siliwa nomuŋ geric weŋweŋanéŋ hatac 7 ʒesolaŋaniyu hiaruyec ésécnec laclalac gocya qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Yawe, ic imi hicŋisai yomi onac murunec demiŋ memina hémbénaŋa guac buŋa kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Baec ic ionac sucginaiguc haka kai ʒiliweŋawac niŋgic eŋu ic biria imi baec séc lelecgéma keŋha wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Yawe némac naléac? Nuac nalé hémbénaŋa eluŋ guzac? Guac kic tanecga nuac murunec nalé dahecac séc musaŋgéwésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Nalé dahecac séc ni ewa qerinanéŋ niŋareŋgéma, kaiwe herec niŋyéwérimaŋ? Haʒécnanéŋ nalé dahecac séc mematiti wannémma tétéc qeqe wammac? ");
INSERT INTO kgf_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Yawe nuac Anutu, niŋnémma acna meleŋ némbésémaŋ. Kicna meɋeli nénna gau yanda hewi niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Haʒécnanéŋ ni ic imi ogicʒua ʒéwac niŋac. Ni qekeŋ qeha wamba haʒéchécna ieneŋ ségiségi wambu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Ni imi guac goi héihéigawac héima kecmaŋ. Nuac ewa qerinanéŋ guac aŋgéŋ titigawac niŋac wamma ségiségi wammac. ");
INSERT INTO kgf_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Yawenéŋ goina héinéŋanʒac imuac niŋac ni legicya héimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Ic qelaŋanéŋ ewa qerianéŋ ʒéma Anutu ménda kecʒac ʒéanʒac. Ic imuhucya eneŋ houdacma haka ewa loloŋa Anutuac wammianʒu. Imuac haka hiabiawac waŋanʒac imi méŋ ménda kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Yawenéŋ baeciguc ic méŋnéŋ niŋtegic qiŋtegicyaguc wamma Anutuac niŋkewu waŋanʒac méŋ kecʒac me qahac imi inicyacgémaŋ ʒé kurumeŋ igucnec sicgéma kic hiyu mazac. ");
INSERT INTO kgf_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Néŋ momac yanda sigima kemma momacnec ʒapi qeqe wandacgic. Imuac haka hiawac waŋanʒac méŋ ménda keru, qahac téŋgéŋ waŋu horec. ");
INSERT INTO kgf_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Képésic wamma saméŋ neanʒu ésécnec nuac ic embachécna neénécmianʒu. Waŋu Anutugina ni ménda nuruanʒu imi eneŋ niniŋgina qahac kecanʒu me? ");
INSERT INTO kgf_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Waŋu Anutunéŋ ic solaŋaguc kecanʒac imuac niŋac ieneŋ imuaru ʒénéŋ hirihiri wamma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Biria meme ini imi maqeqeya ionac niniŋ areŋgia imi gamu mamasuŋiguc opocanʒu, néŋ Yawenéŋ iwac saŋgi saŋgia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Israelac aŋgéŋ titi iminéŋ Zion igucnec hicŋimac niŋac wanʒua. Yawenéŋ ic embachéra meleŋ énécmiyu hésa ama igucnec éréma hamu nalé imuaru Yakoboac areŋhéra ieneŋ ségiségi wammu. Israel ieneŋ ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","(Dawidiac legic ʒéra.) Yawe mérénéŋ guac hali téréyaiguc hia tacyac wammac? Mérénéŋ guac baec boŋa téréyaiguc hia kecmac? Ic yomuhucyanéŋ kecmac; ");
INSERT INTO kgf_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Haka solaŋa wamma kecma qekeŋ qeha qahac namma ewa qerianéŋ ac héla ʒéanʒac ic imuhucyawac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Waŋu ezelaŋanéŋ mematiti ac ménda ʒéma alaya haka biria ménda wammima alahéra ménda ʒébiri énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Kicyanéŋ kaiʒiliweŋ ic mematiti wammima Yaweac ʒénéŋ hirihiri waŋanʒu ionac eegina héianʒac. Waŋu qerianéŋ wammaŋ ʒéma ac méŋ ʒéselima andiaiguc niŋu yéwériyuguc kileŋ ewaya hai netec ménda waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Soukiwa énécmimaciguc kosia ménda meanʒac. Waŋu ic képésicya qahac yéwéri miwiŋ ʒé héna ac logima soukiwa migic ménda késama ménda niŋénécmianʒac. Waŋu haka hiabia imuhuc wamma kecanʒac iminéŋ hémbénaŋa qekeŋ qeha qahac kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","(Dawidiac legic ʒéra.) Anutu, demiŋ menénna, ni néŋgacma guac muru hazua. ");
INSERT INTO kgf_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Ni Yawe guac yomuhuc ʒézua; Gi imi nuac Miŋ Kewuna. Nuac ségiségina imi tosara qahac, néŋ gi sac kecʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Baeciguc météré ic kecʒu imi mocʒoŋ eeginaguc. Nuac ségiségi imi mocʒoŋ ionac muru hezac. ");
INSERT INTO kgf_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Anutu méŋac muru sese hai énécmianʒu ionac imi yéwéri toroqe énécmiyu emmac. Sac muluac sokoc ieneŋ hai énécmianʒu imi ni ménda haimaŋ. Waŋu imuac qara acguc ménda ʒéwa kua tasénaiguc emmac. ");
INSERT INTO kgf_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Yawenéŋ nuac mératéc buŋa ʒéma sokocna kuaya qeqeya. Gi nuac buŋa héŋgaleŋ waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Qaŋaŋ sililic hainénʒaŋ imi baec hiabia, méra téc nuaru imi hiabia téŋgéŋ. ");
INSERT INTO kgf_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Ac pakeŋ waŋnéŋanʒac Yawe i simiŋ héimima ʒéhiaru mimaŋ. Siŋia séc nuac wéiwécnanéŋ ac pakeŋ waŋnéŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ni nalé séc Yawe wésénaiguc opocma aŋgétima kecanʒua. Waŋu inéŋ nuac méra héinaiguc keru ni keŋqe haqe qahac kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Imuac nuac ewa qerinanéŋ ségiségi waŋu nuac qeri uŋananéŋ ségiségi waŋu nuac séwina acguc bénʒéŋ heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Miŋ Kewuac ic téréya ménda waina houmac. Imuac niŋac gi nuac kekec uŋana imi humuc ic ionac baec saŋgeŋaiguc ménda waina hemac. ");
INSERT INTO kgf_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Geŋ imi kekecac héna nézéna hémmaŋ. Guac wéségaiguc imi ségiséginéŋ sécgéma hezac. Guac méra héigaiguc imi ségiségi hémbénaŋanéŋ heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","(Dawidiac ʒéwelecwelec ac.) Yawe, acna solaŋa nimbésémaŋ. Nuac qaqaciguc gezac haiwésémaŋ. Kua tasé ikora qahac imuacnec ʒéhicŋi hicŋiya ʒéwelecna imuac gezac haiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ac ʒésolaŋi nénéŋa imi ʒéna guac wéséga igucnec hamac. Kicganéŋ solaŋana hémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Geŋ nuac ewa qerina héŋgésima héipuc waŋ nénʒaŋ. Waŋu siŋiyaiguc ni hanémma kicganéŋ némma képésicna hocʒaŋ, imuac ni ewa qerinanéŋ ʒéseli amuma képésic méŋ ménda wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Baec ic nanaŋ ninaiguc hémma ʒénimba ni imi kaiʒiliweŋ ic ionac héna biria imi héŋara mema guac ackuaʒéc niŋtohoma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Keŋkeŋ hahanaiguc guac héna imi tima kemba seligiyu hénananéŋ tisuqisurac ménda waŋi. ");
INSERT INTO kgf_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Anutu gi acna niŋanʒaŋ imuac guruwa gezac haima acna niŋnémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Ic tosara haʒéc hécgina ionac murunec néŋgacma guac méra héigawac bawaiguc saŋgianʒu ionac aŋgéŋ titi ic imi gi, goi héihéiga imi nézéna hakaga welic welicgiaguc hicŋiyu hémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Ni guac kic gomacga ésécnec galeŋgé némma guac qeŋgaŋga amiaiguc musaŋgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","Ic biria helanʒi néŋanʒu imi ʒéma haʒéchécna wésé polaŋ ginagucnéŋ lelecgé némma nanʒu ionac murunec metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Ieneŋ eŋaŋ haléginanéŋ oso énécmiyu niniŋgina qahac waŋu kuaginanéŋ tétéc qeqe ac wamma ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Deguc nini kemma kecni lelecgé nénécmima nunugic baeciguc mama nunumac niŋ ninictima awima kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Ieneŋ imi laion yaŋnéŋ neneya kiric qiricmaŋ ʒé waŋanʒac ésécnec. Waŋu laion sac ɋelinéŋ sasaŋgiaiguc héima tacʒac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Yawe, geŋgaoc yacma ic biria ionac wésé bacginaiguc tima qéfacgé énécmina maunuyu. Guac souganéŋ ic biria ionac murunec nuac kekec uŋana metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Yawe, ic tosara baeciguc eŋaŋ buŋa késa kecʒu ionac murunec guac méraganéŋ metecgé némbésémaŋ. Ic imuhucya ieneŋ haleŋ guac buŋa haihaiyanéŋ tomeŋgina kuaya qeyu nambérac héraguc ségiségi wamma kecgic, ai buŋa saméŋa he énécmiyu kokoc onac acguc mératéc hai énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Ni imi solaŋ kekeciguc kecmanec guac kic tanecga hémmaŋ. Gau yanda igucnec yacmaŋ imuaru guac tanecga hémba ségiséginéŋ sécgé némmac. ");
INSERT INTO kgf_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","(Legic galeŋawac; Yaweac weleŋqeqe ic Dawidiac legic ʒéra. Yawenéŋ Dawidi haʒéchéra ionac murunec metecgémiyu legic yomi Yaweac héimiyec.) Nuac kucna Yawe, ni siŋga ninʒua. ");
INSERT INTO kgf_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Yawe imi nuac ʒamanʒiŋ, nuac demiŋ seli, aŋgéŋ titi ic, nuac Anutu, hoc seli musaŋgé nénéŋa, nuac saiwa, aŋgéŋ titiac iliha, neuŋ kiropo selina wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Ni mepé qepési miŋina Yawe guac muru acna ʒéwa kemmac. Ni haʒéchécna ionac murunec aŋgéŋna tinémmac. ");
INSERT INTO kgf_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Humucac hésianéŋ dérécgé néŋu héna logilogiac hakanéŋ doku ɋaoŋa luma keŋkeŋa ésécnec tericgé nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Kic suaŋac hésanéŋ dérécgé néŋu humucac bétacnéŋ wésé bacna tizac. ");
INSERT INTO kgf_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Waŋu ni ʒérabéraiguc Yawe ézéma nuac Anutu qacmiwa inéŋ iwac ocmuŋ téréyaiguc nuac ewana niŋu, wésiaiguc ʒésiacnanéŋ kemma gezawaiguc héiyu niŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Nimma qeri biric waŋu baecnéŋ hiriyu baec boŋawac qambaŋa acguc hiriyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Iwac suŋguruŋaiguc hofac mayu kuayaiguc geric bélaŋanéŋ éréma ʒeyu bélaŋ imuac qeriaiguc geric lokocnéŋ weŋweŋgéma ʒezac. ");
INSERT INTO kgf_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Inéŋ kurumeŋ tilicgéyu mayu tima mayec. Mayu iwac héna bawaiguc tunumaŋ yandanéŋ siŋindéŋgéma heyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Waŋu weleŋ qeqe uŋa qeŋgaŋaguc imuac qahaiguc emma tacma putitima luhuc qeŋgaŋanéŋ mihilaŋgéyu uuuknec mayec. ");
INSERT INTO kgf_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Inéŋ tunumaŋnéŋ hali ésécnec hoturumiyu saŋgianʒac. Sawaiguc dokuac tunumaŋ ʒéma hosusu dépaŋ yandanéŋ hoturumiyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Wésiaiguc asac mararaŋ iminéŋ hosusu dépaŋ yanda qéndémma keŋec. Waŋu komboc ʒéma geric lokoranéŋ mayec. ");
INSERT INTO kgf_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Kurumeŋiguc parandaŋ héiyu eŋeŋa miŋinanéŋ ac ewa ʒéhicŋiyu komboc ʒéma geric lokoc mayec. ");
INSERT INTO kgf_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Inéŋ luhucnéŋ ʒakoŋ ésécnec muiyu mama haʒéchéra héndéŋ énécmiyec. Waŋu pilitic sasalanéŋ nesi énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Nalé imuaru Yaweac ʒéqindiŋi ac waŋ énécmiyu konduŋ dokunéŋ keŋha waŋu dumuc sira wininiyu baec qambaŋa wininiyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Waŋu inéŋ ounec méramma mama népésiyec. Népésima doku yanda igucnec hérénéŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Ni haʒéchécna selia ʒéma nuac méʒétiti waŋanʒu ionac murunec metecgé néŋec. Kucginanéŋ kucna ogirec imuac mia imuhuc wannéŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Ieneŋ nuac ʒérabéra naléiguc hosucgé néŋgic, néŋ Yawenéŋ nuac héipuc wannéŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Waŋu ni nuagicma kemma baec kondoŋaiguc noporec. Inéŋ nuac ségiségi wamma aŋgéŋna tiyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Yawenéŋ nuac haka solaŋa niŋac bakia hiabia meleŋ néŋec. Waŋu mérana solaŋa niŋac tasia hiabia ku néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","Ni Yaweac héna ac tohotoho wamma ic biria ésécnec ménda wamma Anutu ménda waiyi imuac niŋac imuhuc wannéŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Waŋu héna ac imi nuarunec ménda giliwa keŋec, néŋ ʒégésigési acya imi nalé séc nuaru heyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Imuacnec sac qahac, ni iwac kiwaiguc solaŋanec kecma képésic igucnec nena aŋgéŋna tima galeŋgé amuyi. ");
INSERT INTO kgf_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Imuac niŋac Yawenéŋ nuac solaŋa niŋac wamma bakia hiabia menémma kiwaiguc mérana solaŋanec keri imuac séhaiguc tasia menéŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Goi héihéi icac imi goi héihéiga mewinini mianʒaŋ. Ic solaŋawac imi solaŋaga ézéna héŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Ic météré amuma kekec imi guac téréyaga mewinini mima ic ɋariŋ ɋariŋgiawac imi héimindiŋi wammianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Hénaoriŋ maqeqeya imi aŋgéŋgina tiénécmima sucginaiguc méŋnéŋ séwi eŋeŋ kic hiyu memama mianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Miŋ Kewu geŋ mia nuac kifana otorianʒaŋ. Yawe nuac Anutunanéŋ nuac tunumaŋ measarianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Ni guac muru héima namma haʒéchécna sucginaiguc usuŋnec keŋha waŋanʒua. Nuac Anutuac muru héima namma demiŋ héʒicgé nénéŋa imi hia técgélogima keŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Anutuac héna acnéŋ solaŋa wanʒac. Yaweac ackuaʒécnéŋ gocya qahac. Inéŋ eŋeya muru néŋgacma haanʒu séc saiwa waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Mérénéŋ Anutu kecʒac? Yawenéŋ sac Anutu kecʒac. Mérénéŋ neŋaŋ ʒamanʒiŋ wanʒac? Anutunéŋ sac neŋaŋ ʒamanʒiŋ wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Anutu iminéŋ kucyanéŋ rikuŋna menémma nuac héna mesolaŋanianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Nuac hénana imi haséŋ yaŋ dia hénaya ésécnec meefinémma ou baec boŋaiguc noporu naŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Inéŋ mérana yaré qeqeac hénia kumiyec. Kumiyu mérananéŋ aiŋ tewi neŋgocya héréanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Geŋ aŋgéŋ titigawac saiwaya nénnec, waŋu méra héiganéŋ meyac kumu nénnec. Waŋu guac gum bénʒénʒéŋganéŋ meyandi nénnec. ");
INSERT INTO kgf_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Gi héna titina mehoruginec. Waŋu meseli nénna tisuqisurac ménda waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Ni haʒéchécna nesi énécmima onogiri. Waŋu keŋkecma unuwa humuqai wandacgicguc liliŋgéyi. ");
INSERT INTO kgf_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Unu héʒéʒa énécmiwa yacbiŋ ʒé osigic. Osima héna bakanaiguc tendiŋgédacgic. ");
INSERT INTO kgf_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Geŋ mia yaré qemaŋ niŋac kucganéŋ rikuŋna menénnec. Waŋu haʒéc wannémma yacgic geŋ mebélacgé énécmina héna bakanaiguc sicgé néŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Geŋgaoc waŋ énécmina andégina numa néŋgacgic, haʒéc wannénʒu imi unudacba qahac wandacgic. ");
INSERT INTO kgf_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Qac kuc kuc waŋgic méŋnéŋ méŋ ménda metecgé énécmiyec. Miŋ Kewuninawac muru acguc wammigic, néŋ ac kitiwa méŋ ménda meleŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Neŋ unuma qéʒéʒa énécmiwa luhucnéŋ seitotoŋ mihilaŋgéyu keŋanʒac ésécnec kendacgic, waŋu hoŋnec qolacgé énécmiwa gizoŋ ésécnec séŋgaŋgeŋ mama hedacgic. ");
INSERT INTO kgf_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Geŋ mia ni baera baera ic embac ionac ʒébiri qébiri igucnec metecgé némma meyac nénna orucgina wamma kecba tosara ménda niŋénécmiyi imi eneŋ acguc hama weleŋ qenéŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Ieneŋ nuac buŋa nimma nalé sosola qahac acna tohoanʒu. Ic enia ieneŋ méra bacnaiguc qeka meka wandacʒu. ");
INSERT INTO kgf_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Ic méréra ieneŋ kucgina loloma mayu eŋaŋ neuŋ kiropo selia igucnec ʒénéŋ hiri wamma mama hadacanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Nuac ʒamanʒiŋ Yawe kekecyaguc, simiŋ héima ʒéhiaru mimia waŋu. Nuac aŋgéŋ titiac Anutu, meyac mimia waŋu. ");
INSERT INTO kgf_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Anutu iminéŋ mia nuac wamma haʒéchécna bakia meleŋ énécmima baera baera ic embac méra bacnaiguc onoporec. ");
INSERT INTO kgf_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Inéŋ ni haʒéchécna ionac murunec metecgé némma haʒéc wannénʒu ionac qacginaiguc meyac némma ic qeri gericginaguc ionac murunec metecgé néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Yawe, hénia imuac niŋac baera baera sucginaiguc ni ewa hia ac gézémaŋ. Waŋu guac qacga mepésigémma legic héigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Yawenéŋ eŋeya ic kewuya méra miyu haʒéchéra onogicdarec. Halécnéŋ météré mimia iwac goi héihéi wammianʒac. Waŋu Dawidi ʒéma ɋelihéra ionac momacnec hémbénaŋa imuhuc waŋénémianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Kurumeŋnéŋ Anutuac edamuya ʒéauanʒac. Waŋu iwawai iwac mérianéŋ meyec imi ou sawanéŋ mewininianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Kaiwe méŋnéŋ kaiwe méŋac ac ʒéhicŋimiyu, siŋi méŋnéŋ siŋi méŋac niniŋ ʒéaumianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Ac qahac ewa méŋ ménda niŋanʒiŋ, néŋ ");
INSERT INTO kgf_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","ac ewa imi baec séc keŋha wandaru ackuaʒéc iminéŋ baec tetecgia séc kereŋdacʒac. Anutunéŋ kaiwe niŋac wamma kurumeŋ imi hali ésécnec héréyec. ");
INSERT INTO kgf_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Kaiwe iminéŋ ic méŋ embac meyec iminéŋ ama giaŋiyu ama igucnec mazac ésécnec, waŋu ic kawali eŋeya héna ségiségi wamma usuŋnec keŋanʒac ésécnec, ");
INSERT INTO kgf_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Kurumeŋ néwéc igucnec éréma néwéciguc hénia méndacma keŋanʒac. Waŋu iwawai méŋnéŋ méŋ geriwa imuacnec ménda saŋgima kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yaweac héna acnéŋ solaŋa waŋu kekec uŋanina meɋeli nénécmianʒac. Yaweac héipuc acnéŋ niŋkinʒéŋaguc nambérac ewa kekec ic niŋtegic qiŋtegic mihicŋi mianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yaweac ac pakeŋ imi dindiŋa waŋu ewa qerininaiguc ségiségi mihicŋianʒac. Waŋu Yaweac ʒézé seli acnéŋ ɋala ɋala waŋu kicnina measari nénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Yawe eeya héimimiawac haka imi météré qeqe waŋu hémbénaŋa hema kecmac. Yaweac haka silicac pakeŋ ac imi héla waŋu mocʒoŋ solaŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Imi mia goli solaŋa ogicma waŋmimiawac séc waŋu, morombazecac dokuya, doku howia imi ogicma siŋaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Iminéŋ guac weleŋ qeqe icac goro ac wammianʒac. Waŋu nimma niŋtohoyu mériaŋ kuneŋ yandanéŋ bakia meleŋmiyu meanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Mérénéŋ eŋeya biriaya hia niŋtegicmac? Biriana musaŋ gégéya imuacnec hetecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Waŋu meseli nénna guac weleŋ qeqe icganéŋ séwi eŋeŋac képésic waŋaŋiac waŋanʒua imuac méra bawaiguc ménda kecmaŋ. Imuhuc waŋ nénna ni ikoc ménda wamma képésic kuneŋ yanda imuacnec ʒuacnénéŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Nuac ʒamanʒiŋ, nuac boŋhéré meme miŋina, Yawe, nuac kuanaiguc ac ʒézéna ʒéma ewa qerinaiguc ac ʒéma niŋanʒua imi guac kicgaiguc hénna sécgéyu késa aŋgé tiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Ʒérabéraiguc Yawenéŋ guac acga niŋgémmac. Qara qacna Yakoboac Anutunéŋ ou eŋeŋaiguc goporu tacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Ocmuŋ téréya igucnec méria sulugémmac. Zioniguc gi késa naŋgé gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Guac lémbaŋ sese imi mocʒoŋ niŋɋelimac. Guac hofac oo seseya imi aŋgé timac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ewa siŋga hezac séc niŋgémmac. Ai memaŋ ʒé niŋareŋgéna hezac séc héla mihicŋi gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Aŋgéŋ tinénécmina hériaŋ legic héima neŋaŋ Anutuac qaraiguc filacnina meyacni emmac. Yawenéŋ guac ʒéwelecga mocʒoŋ niŋgémmac niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Yawenéŋ eŋeya buŋa qemima halécnéŋ météré mimia imi aŋgéŋa tianʒac imi deguc ni ninʒua. Anutuac méra héiyaiguc aŋgéŋ titiac kuha hezac. Inéŋ kurumeŋ téréyaiguc iwac ara nimmima kuha iminéŋ mia méra mimac. ");
INSERT INTO kgf_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Tosara imi karisiiginawac, tosara imi becosicginawac niŋɋelianʒu, néŋ nini imi Yawe Anutuninawac qarawac niŋɋelianʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Ieneŋ imi licgéma madacanʒu, néŋ nini imi héŋgeŋnec yacma naŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yawe ic kewuninawac aŋgéŋa tina. Guru héhéli génʒiŋ séc, niŋnénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Yawe, ic kewu iminéŋ guac kucgaiguc ségiségi wammac. Guac aŋgéŋ titigawac niŋac kuneŋ yanda ségiségi wammac. ");
INSERT INTO kgf_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Geŋ, iwac qeriaiguc ewa siŋ haiminec. Waŋu iwac kua tasianéŋ ʒéweleru ménda qaecgémianʒaŋ. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Geŋ iwawai hiabianéŋ mériaŋ mihicŋi mima tétécgéminec. Imuhuc wamma iwac oruhaiguc ic kewuac opoc goli solaŋanéŋ memeya haiminec. ");
INSERT INTO kgf_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Inéŋ kekecac ʒéweleru mima kekec hémbénaŋa minec. ");
INSERT INTO kgf_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Guac aŋgéŋ titiganéŋ iwac edamuya meyandima eebipiya ʒéma qac buŋaya héiminec. ");
INSERT INTO kgf_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Nalé tetecgia qahac, mériaŋ mihicŋi mina meanʒac. Waŋu ézéna guac wéségaiguc ségiségi ʒéma ewa hia nimma kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Ic kewu iminéŋ Yaweac muru héima naŋanʒac. Imuac niŋac eŋeŋa miŋinawac goi héihéianéŋ wammiyu qekeŋ qehaya qahac kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Ic kewu, guac méraganéŋ guac haʒéchécga mocʒoŋ mihicŋima guac méra héiganéŋ méʒétiti waŋgéŋanʒu imi mocʒoŋ mihicŋi énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Geŋ wininiwésémaŋ nalé imuaru haʒéchécga ieneŋ geric lokoc weŋweŋa ésécnec wammu. Yawenéŋ qeri birianéŋ ɋécgé énécmiyu ʒema qahac wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Gi imi ɋelihécgina baec igucnec metecgé énécmina, ɋelihécgina ieneŋ baec ic ionac sucgina igucnec humu qai wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Ieneŋ mebirigémbiŋ ʒé haka biria niŋareŋ gémuiguc hia ménda meseli gémmu. ");
INSERT INTO kgf_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","Musuginaiguc tewiganéŋ héré mui wanna liliŋgéma néŋgacmu. ");
INSERT INTO kgf_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yawe, guac kucga mewininina meyac géŋgéŋa wammac. Nini guac kucga legiciguc héima mepési gémbiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","(Legic galeŋawac; Dawidiac legic ʒéra. Legic méŋ Siŋunecac dia yaŋ imuac ewaiguc.) Nuac Anutu, nuac Anutu, némac niŋac wainénʒaŋ? Némac niŋac lakec namma méra ménda nénʒaŋ? Némac niŋac nuac ʒésilacna ménda niŋnénʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Nuac Anutu, ni kaiweiguc qacma siŋiya acguc ac ewana ménda qaiyu guruwa acna ménda meleŋ nénʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Israel ic ieneŋ legic héigic imuaru tatac duŋga mihicŋima tacanʒaŋ gi imi téréya. ");
INSERT INTO kgf_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Yanda hécninanéŋ guac héima naŋaŋgic. Ieneŋ imuhuc waŋgic yéwérigina igucnec aŋgéŋgina tiénécmiaŋnec. ");
INSERT INTO kgf_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Ieneŋ guru héhélima aŋgéŋ titi mihicŋigic. Guac muru héima namma gamu ménda mihicŋigic. ");
INSERT INTO kgf_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Ni imi ic qahac, néŋ gisic ʒinaŋgoc ésécnec. Ic ieneŋ ʒédesi desiac buŋa ʒéma mema titiac buŋa nopocgic kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Néŋgic séc ʒédesi némma kichoc menémma orucgina gilima yomuhuc ʒéanʒu; ");
INSERT INTO kgf_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Inéŋ Yaweac héima nanʒac waigic inéŋ hama metecgé mimac. Iwac niŋac ségiségi wanʒaciguc i eŋeyaoc metecgé mimac. ");
INSERT INTO kgf_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Waŋu gi geŋgaoc ni neŋgocnawac héri qeri igucnec népésinec. Waŋu neŋgocnawac namu nekeri imuaru geŋgaoc waŋ nénna ni ewa déŋ keri. ");
INSERT INTO kgf_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Ni hicŋihicŋinaiguc guac buŋa ʒénénéŋa. Waŋu neŋgocnawac héri qeri igucnec hicŋiyi imuarunec geŋgaoc nuac Anutuna waŋnecac waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Imuac lakec ménda nambésémaŋ. Ʒérabéra hosucgé néŋu méra nénéŋa méŋ ménda kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Burumakao sasalanéŋ lelecgé nénʒu. Basan baec boŋawac burumakao kuc seliseli ginagucnéŋ ni lelecgé nénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Kiric qiric wamma qacma kuagina aŋgéanʒu laion imuhucya ésécnec waŋ nénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Waŋu ni doku ésécnec wamma mazua. Nuac sicna imi mocʒoŋ tecgéma sicsaoc waŋu nuac ewa qerinanéŋ kendol dokuya ésécnec pépélima mazac. ");
INSERT INTO kgf_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Nuac kuana imi ɋakaraŋgéyu ezelaŋnanéŋ kewuc nomuŋ ésécnec waŋu, nuac ezelaŋnanéŋ ewa siraiguc qékétazac. Geŋ mia muŋguc ni humumac seitotoŋiguc nopocna hezua. ");
INSERT INTO kgf_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kazu eneŋ lelecgé néŋgic. Ic biria tuŋaguc ieneŋ lelecgé némma méra hénana tiricqiric wannéŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Ni sicna ʒaŋgégina imi mocʒoŋ olommaŋac séc. Ieneŋ néŋtima ");
INSERT INTO kgf_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","nuac séwi usuna mena mewa wamma késama malekuna mewiŋ ʒé sumbic nézu. ");
INSERT INTO kgf_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Yawe lakec ménda kenna. Nuac kucna, focdac méra némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Nuac kekec uŋana imi sou ʒéra igucnec aŋgéŋa tina. Momacguc henénéŋa imi kazu onac kucgina igucnec aŋgéŋa tina. ");
INSERT INTO kgf_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Laionac kua igucnec kekec uŋana aŋgéŋa tina acna niŋnémma haséŋ burumakao ilicgina igucnec aŋgéŋna tinénna. ");
INSERT INTO kgf_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ni guac qacga imi dacmuna hécna ionac sucginaiguc ʒéau énécmima hénaoriŋ sucginaiguc mepésimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Yaweac bac yandi yandi wamma kecʒu ini i mepésimu. Yakoboac ɋelihéra ini mocʒoŋ qac buŋaya meyacmu. Israelac ɋelihéra ini mocʒoŋ eeya héimimu. ");
INSERT INTO kgf_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Inéŋ helanʒi énécmigic kecanʒu ionac helanʒi énécmimia imi niŋu eŋomia ménda waŋanʒac. Waŋu imuac ewa loŋloŋ ménda waŋanʒac. Inéŋ kic tanecya ménda musaŋgé énécmimac. Qacgic séc niŋénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Aʒoaʒoroiguc nuac mepé qepési imi guac murunec haanʒac. Eega héianʒu ionac sucginaiguc ac koroma ʒézé seli ac ʒéyi imi mocʒoŋ meselimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Memaamuma kekec imi eneŋ negic sécgé énécmimac. Yaweac hochoc waŋanʒu imi eneŋ i mepésimimu. Ewa qerigina imi heheseli kekecyaguc kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Baec tetecgia séc Yawe niŋɋelima liliŋgéma hamu. Baec séc ic embac hénia hénia imi eneŋ guac wéségaiguc sicgégémmu. ");
INSERT INTO kgf_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Héŋgaleŋ ama yanda imi Yaweac buŋa. Yawe imi baera baera ic embac ionac héŋgaleŋ waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Baec séc ic embac mériaŋginaguc ini negic sécgé énécmiyu mepésimimu. Eŋeya kekec uŋaya meɋeli amumacac séc qahac seitotoŋiguc maqezac i acguc iwac wésiaiguc simiŋ héimimac. ");
INSERT INTO kgf_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Ɋelihéra mocʒoŋ i weleŋqemimu. Imuhuc wamma hicŋisai ɋelia hahaya ionac miŋ kewuac hénia énézégic nimmu. ");
INSERT INTO kgf_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Hama iwac hénia solaŋa imi hicŋisai kecma hahaya ionac énézéma inéŋ haka waŋec imi suruc waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","(Dawidiac legic ʒéra.) Yawe imi nuac rama galeŋna, ni imuac me imuac ménda hocmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Inéŋ ni ɋézézac téŋgiŋ téŋgiŋiguc noporu hemaŋ. Waŋu doku giŋgiŋa hétéŋa qahac imuaru nuagicma keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Nuac kekec uŋana meɋeli nénna. Inéŋ eŋeya qac buŋaya niŋac wamma héna solaŋaiguc nuagicma keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Ni humucac baec wéŋwéŋgia siŋi déndéŋgiaiguc keŋha wammaŋiguc, geŋ mia niguc kecanʒaŋ, imuac kileŋ ʒérabérawac bac yandi yandi ménda wammaŋ. Guac tacga ʒéma ɋarucganéŋ ni qindiŋi néŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Geŋ mia nuac haʒécnawac kicginaiguc neneac ʒae hainémma halécnéŋ orucna naecma météré nénna nuac sokocnéŋ sécgéma mazac. ");
INSERT INTO kgf_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Nuac kekecnawac nalé séc, guac ewa hia ʒéma goi héihéiganéŋ hélacnec méndac néŋu, ni Yawe guac amaiguc hémbénaŋa kecammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","(Dawidiac legic ʒéra.) Baec ʒéma iwawai imuaru sécgéma hezac iwawai momac yanda ʒéma baec séc ic embac imi mocʒoŋ Yaweac buŋa wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Yawenéŋ baec qambaŋa imi konduŋ qeriaiguc haiyu naŋu doku téfara qeriaiguc miyacgéyu naŋec. ");
INSERT INTO kgf_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Mérénéŋ Yaweac baec boŋaiguc hia emmac? Mérénéŋ iwac baec boŋa téréya imuaru hia nammac? ");
INSERT INTO kgf_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Mérayaiguc képésira qahac ʒéma qeri solaŋaguc kecma haka sicsaocyawac eŋeya kekec uŋaya ménda oporu keŋu ʒéselima ac ikoc ménda waŋanʒac imuhucya. ");
INSERT INTO kgf_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Ic imuhucya imi Yaweac muru mériaŋ mema aŋgéŋ titiac Anutu iwarunec képésic solaŋ mihicŋimac. ");
INSERT INTO kgf_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Imuhucya imi hicŋisai Yaweac hochoc wamma Yakoboac Anutu guac kic tanecgawac waŋanʒu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Saŋgulaŋ séc orucgina meyacgic endacmac. Saŋgulaŋ hehe selia ini mocʒoŋ imuhuc wandacgic, Miŋ Kewu edamuyagucnéŋ keremmac. ");
INSERT INTO kgf_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Mérénéŋ ic kewu edamuyaguc? Kuc miŋina, wandac wandac miŋina, Yawe imi mia. Yaré miŋina Yawe imi mia. ");
INSERT INTO kgf_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Saŋgulaŋ séc orucgina meyacgic endaru. Saŋgulaŋ hehe selia ini mocʒoŋ imuhuc wandacgic, ic kewu edamuyagucnéŋ keremmac. ");
INSERT INTO kgf_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Mérénéŋ ic kewu asac mararaŋaguc? Kurumeŋac téŋgiŋ ic ionac Yawe iminéŋ mia ic kewu edamuyaguc wanʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","(Dawidiac legic ʒéra.) Yawe, nuac kekec uŋananéŋ kic hiwa eŋu génʒua. ");
INSERT INTO kgf_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Nuac Anutu, ni guac muru héima nanʒua. Imuac méra nénna, gamuna mihicŋiwi niŋac. Nuac haʒéc hécnanéŋ nogicbu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Guac kichihi waŋanʒu imi eneŋ gamu qeqeiguc ménda onopocgic emmu, néŋ hénia qahac ikoc waŋ énécmianʒu imi eneŋ gamu qeqe mihicŋimu. ");
INSERT INTO kgf_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Yawe, guac hénaga nézéna hémba. Guac héna imi nézéma ku némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Guac ac hélanéŋ ni ku némma ʒéqindiŋi nénna. Gi imi nuac aŋgéŋ titiac Anutu, imuac ni kaiwe herec guac ewa kewu wamma kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Yawe, guac wésé niniŋ ʒéma goi héihéiga hegéŋecac hegénʒac imuac niŋɋeliwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Yawe, komocnawac képésic ʒéma haka biria ménda niŋɋelina. Guac goi héihéiiguc ni niŋɋeli némma ewa hiagawac niŋac niŋnémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Yawe imi hiabia ʒéma solaŋa, imuac inéŋ eŋeya héna acnéŋ képésic ic ku énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Inéŋ gum bénʒénʒéŋ ic imi wagicma héna solaŋaiguc keŋanʒac. Waŋu gum bénʒénʒéŋ ic imi eŋeya héna kumianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Sésépac ac ʒéma héipuc ac niŋtohoanʒu ionac muru imi Yaweac héna imi mocʒoŋ goi héihéi ʒéma haka héla waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Yawe, nuac képésic imi kuneŋ yanda, guac qacga niŋac auna. ");
INSERT INTO kgf_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Mérénéŋ Yawe bac yandi yandiiguc eeya héimianʒac? Yawenéŋ ic imuhucyawac héna imuac me imuac aŋgé timacac hezac imuac kumimac. ");
INSERT INTO kgf_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Iwac kekec uŋayanéŋ luaeguc kecmac. Waŋu ɋelihéra ieneŋ baec mératéc memu. ");
INSERT INTO kgf_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Yaweac ala kekecnéŋ eeya héimianʒu ionac muru he énécmimac. Inéŋ sisipac acya énézéyu nimmu. ");
INSERT INTO kgf_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Nuac kicnanéŋ susucnec Yaweac hiwa eŋanʒac. Imuac niŋac, inéŋ ufic igucnec nuac hénana hetecgé némmac. ");
INSERT INTO kgf_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Ni nenacnec niŋgumbi niŋguŋ wamma kecba ʒérabéra mihicŋi néŋgic kecanʒua. Liliŋgéma ewa hia niŋ némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Nuac ewa qerinaiguc niŋyéwéc sasala henénʒac. Yéwécna igucnec metecgé néŋna. ");
INSERT INTO kgf_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Nuac yéwécna ʒéma ʒérabéra imi hémma nuac képésicna mocʒoŋ auna qahac waŋu. ");
INSERT INTO kgf_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Nuac haʒéchécna inicna, ʒaŋgégina imi sasala, waŋu nuac méʒé titi kuneŋ yanda waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Nuac kekec uŋana héŋgaleŋ wamma aŋgéŋna tiwésémaŋ. Ni néŋgacma guac muru hazua. Méra nénna gamu qeqe mihicŋi némbu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Ni ewa qerina mocʒoŋnec niŋtoho waŋgéŋanʒua. Imuac gi hakaga solaŋa ʒéma dindiŋanéŋ ni osonénna. ");
INSERT INTO kgf_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Anutu, Israel ʒérabéra hénia hénia imuacnec boŋhérégina meénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","(Dawidiac legic ʒéra.) Ni hakana solaŋanec waŋanʒua. Waŋu keŋqe haqe qahac Yaweac héima kecanʒua. Imuac Yawe néŋgési wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Yawe ni néŋsosolima batucgé némma nuac ewa qerina ʒéma nuac ewa siŋna mesolaŋi néŋna. ");
INSERT INTO kgf_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Guac goi héihéiganéŋ nuac wésénaiguc hezac ni guac haka héla imuac méndacma keŋha wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Ic gorosoŋa iniguc ménda tacyac waŋanʒua. Waŋu ic diwi qiwiliŋa iniguc momacnec keŋha ménda wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Ni kaiʒiliweŋ ic ionac aʒoaʒoro imuac méʒétiti wamma ic biria iniguc momacnec tacyac ménda wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Yawe ni képésicna qahac, imuac mérana ʒuacma guac ʒaki téréyaiguc kereŋ haré wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Ewa hia ac ʒéhicŋima guac haka welic welicgia imi ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Yawe ni guac tacyacwac ama ʒéma ocmuŋ téréya guac edamugaguc imuac qerinanéŋ wammianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Nuac kekec uŋana imi képésic ic iniguc, waŋu nuac kekecna imi sac naec ic iniguc momacnec ménda metocgéna. ");
INSERT INTO kgf_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Ionac méraginaiguc imi iwawai ʒéragucnéŋ heyu méra héiginaiguc imi ikociguc boŋhéré wawaŋawac iwawainéŋ sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Néŋ nenaoc solaŋanec hakana wamma kecmaŋ imuac ni boŋ héréna menémma ewa hia niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Ni hénana baec kondoŋaiguc tima nanʒua. Hénaoriŋ ionac sucginaiguc Yawe ʒéhiaru mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","(Dawidiac legic ʒéra.) Yawe imi nuac asac mararaŋ, nuac aŋgéŋ titi miŋina, ni mérac ʒénéŋ hirihiri wammaŋ? Yawe imi kuhanéŋ kekecnawac saiwa waŋnéŋanʒac, ni mérac mia bac yandi yandi wammaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Biria meme ic, haʒéc waŋ némma, héŋacna meanʒu, ieneŋ nuac séwi busuna newiŋ ʒé hagic, hama tisuqisura wamma maunudarec. ");
INSERT INTO kgf_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Téŋgiŋ ic tuŋagucnéŋ yaré waŋ némbiŋ ʒé areŋgéma lelecgémuiguc kileŋ nuac qerinanéŋ bac yandi yandi ménda wammac. Yaré hicŋi némmaciguc kileŋ niŋkinʒéŋgéma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Ni Anutunéŋ yomuhuc waŋ némmac niŋac qesimiyi imuac wamma kecmaŋ. Inéŋ niŋu sécgéyu ni ménda humumanec Yaweac ocmuŋ téréyaiguc emma kecma Yaweac hénia héŋsorocya imuac kic hihi wamma ocmuŋ téréyaiguc qerinanéŋ iwac wamma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Yawenéŋ ʒérabéra naléiguc eŋeya haliiguc ni sasaŋgianec néŋgaleŋ wannémma hali imuac saŋgi saŋgiiguc ni musaŋgé némmac. Waŋu kecma ʒamanʒiŋ yanda qahaiguc ou meyac néŋu nammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Inéŋ deguc nuac orucna meyac néŋu ni haʒéchécna lelecgé nénʒu imi mocʒoŋ onogicma ou emmaŋ. Waŋu ni hali téréya imuaru ewa hiawac hériaŋ wamma hofac omima legic héima Yawe mepésimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Yawe, ni ac ewanaguc qacba niŋnémma ewa biric waŋ némma acna meleŋ némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Ini nuac kic tanecnawac wamma kic hihi wammu ʒénec imuac mia ni guac kic tanecgawac wamma kic hihi wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Guac kic tanecga imi ménda musaŋgé nénna. Guac weleŋ qeqe icga qeri biric nimma ménda nesinénna. Gi imi méra néŋannecac néŋanʒaŋ. Nuac aŋgéŋ titina Anutu ni ménda wainémma kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Nuac neŋgoc maŋgocnéŋ wai némbaocnec, Yawenéŋ kileŋ aŋgéŋna timac. ");
INSERT INTO kgf_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Yawe, guac hénaga ku némma haʒéchécna kicgaleŋ wannénʒu imi inicma héna kondoŋaiguc hezac imuaru ni nuagicma kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Héipuc ic ikora ʒéma ac biria loŋanʒu imi eneŋ yacma nuwiŋ ʒé wanʒu, imuac nuac kekec uŋana imi haʒéchécna ionac méraginaiguc ménda opocna. ");
INSERT INTO kgf_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ni Yaweac haihaka hiabiawac hémmaŋ ʒéma ninʒéŋgéyiac deguc ic kekecginaguc ionac baeciguc kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Gi imi Yaweac ewa kewu wambésémaŋ. Kucgaguc wamma ʒénéŋ hirihiri qahac Yaweac ewa kewu wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","(Dawidiac legic ʒéra.) Yawe ni guac qacma guruzua. Nuac ʒamanʒiŋ gi gezacga ménda héʒicgéna. Acga qaiyu kecbésémaŋiguc ni imi kic suaŋiguc higacbi niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Ni guac ocmuŋ téréyawac qeria météré qeqeya imuac melemma mérana meemma ʒéwelecma guruwa nuac ʒésiacna niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Ic biria ʒéma haka biria waŋanʒu iniguc ni momacnec ménda hérénémma gilina. Ieneŋ imi ama momachéra luae ac énézémaguc ewa qeriginaiguc imi niniŋ biria doŋgégic heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Ionac haka silic séc wawaŋ meme biriawac séc tasia meleŋ énécmina. Méraginanéŋ waŋgic séc tasia memuac hezac séc meleŋ énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Ieneŋ imi ai Yawenéŋ meyec imi ʒéma mérianéŋ meyec imuac niŋgic ménda eŋanʒac, imuac niŋac Yawenéŋ mebiri énécmima muŋguc ménda meyacgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Ʒéwelecna niŋnénʒac imuac niŋac Yawe imi mepésimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yawe imi nuac kuc ʒéma nuac saiwa, ewa qerinanéŋ iwac niŋkinʒéŋ wamba méra nénʒac. Imuac ewa qerinanéŋ ségiségi kuneŋ yanda nimma legicnanéŋ i mepésimizua. ");
INSERT INTO kgf_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yawe imi halécnéŋ météré énécmimia ionac kucgina ʒéma aŋgéŋ titiac neuŋ kiropo wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","O, ic embachécga aŋgéŋgina tiénécmina, guac mératéc buŋaga mozoc ac waŋ énécmina. Geŋ rama galeŋ waŋ énécmima hémbénaŋa énépésima kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","(Dawidiac legic ʒéra.) Kucginaguc ini qac buŋa ʒéma kuc buŋa imi Yaweac meleŋmigic iwac buŋa waŋu. ");
INSERT INTO kgf_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Edamu asaha qac buŋayawac séha mihicŋi mima séwi usu téréya héima Yawe mepési migic. ");
INSERT INTO kgf_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yaweac ewa hétéŋ imi doku qahaiguc hicŋima hezac. Anutu edamuyaguc inéŋ parandaŋ mihicŋianʒac imuac Yawe imi doku yanda qahaiguc kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yaweac ewa hétéŋ imi kuhaguc. Yaweac ewa hétéŋ imi kuc eeyaguc. ");
INSERT INTO kgf_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yaweac ewa hétéŋ iminéŋ yéménʒéc ic kuanʒac. Yawenéŋ Lebanon yéménʒéc ic kuyu maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Inéŋ waŋu Lebanon imi haséŋ burumakao merawa tanec técgéyu Sirion imi burumakao sac ɋelia tanec técgézac. ");
INSERT INTO kgf_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yaweac ewa hétéŋnéŋ waŋu geric bélaŋa téma maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Yaweac ewa hétéŋ iminéŋ waŋu baec kisianéŋ hirianʒac. Inéŋ waŋu Kadesi baec kérakérasianéŋ hirizac. ");
INSERT INTO kgf_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yaweac ewa hétéŋnéŋ waŋu dia yaŋnéŋ aurima aʒi kiyu merac alia mezac. Waŋu ic ʒuŋ imi hetecgéyu katanec waŋanʒac. Imuac ocmuŋ téréyaiguc haka imi mocʒoŋnéŋ edamuyaguc! ʒémizu. ");
INSERT INTO kgf_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yawenéŋ doku ɋaoŋ luyu imuaru tatacya késa tarec. Waŋu Yawenéŋ tetecgia qahac ic kewu wamma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yawenéŋ ic embachéra kuha qeénécmianʒac. Yawenéŋ ic embachéra luaeac mériaŋa énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","(Dawidiac legic, ocmuŋ téréya ɋelia Anutuac buŋa qemima legic yomi héiyec.) Yawe geŋ mia meyac nénna haʒéchécna ieneŋ nuac niŋ ségiségi wammuac séc qahac waŋec. Imuac gi meyacgénʒua. ");
INSERT INTO kgf_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Yawe Anutu ni guac qachéhéliwa mehiaru nénnec. ");
INSERT INTO kgf_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Yawe geŋ mia kekec uŋana késa héréma humuc igucnec meɋeli nénna ni kicsuaŋiguc ménda hiŋgari. ");
INSERT INTO kgf_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Miŋ Kewuac météré énécmimia imi Yawe mepésimigic. Qara téréyawac ewa hia ac ʒému. ");
INSERT INTO kgf_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Qeri biria imi nalé hotoŋadac heheya, néŋ ewa hiayawac buŋa imi kekecnawac séc henémmac. Siŋiyaiguc ʒésiacnéŋ hama hemac, néŋ ama giaŋiyu ségiséginéŋ hama hemac. ");
INSERT INTO kgf_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Méŋac méŋ ménda osiaŋi nalé imuaru ni hémbénaŋa qekeŋ qeha ménda wammaŋ ʒéyi. ");
INSERT INTO kgf_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Yawenéŋ ewa hiawac nuac baec boŋa meyacgéyu seligima naŋec, néŋ kic tanera musaŋgéyu ni niŋyéwériyi. ");
INSERT INTO kgf_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Yawe ni guac qacma ʒéwelecma yomuhuc ʒéyi; ");
INSERT INTO kgf_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","kic suaŋiguc hiŋgacmaŋiguc sacnanéŋ némaciguc naŋgé némmac. Dimuhuciguc seitotoŋ wawaŋanéŋ gi mepésigémma guac ac héla imi ʒéau énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Yawe acna niŋnémma ewa hia niŋnémbésémaŋ. Yawe nuac héipuc icna waŋ némbésémaŋ imuhuc ézéyi. ");
INSERT INTO kgf_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Geŋ mia nuac soŋgoŋac ʒésiacna meleŋna legic hirihiri waŋu soŋgoŋac séwi usu hetecgéma ségiségiac rikuŋa menéŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Imi mia acna ménda qaiyu nuac kekec uŋananéŋ gi mepési gémmaŋ niŋac imuhuc waŋ néŋanʒaŋ. Yawe nuac Anutu ni nalé tetecgia qahac ewa hia ac ʒégémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Yawe ni néŋgacma guac muru hazua. Guac hiaganéŋ ni metecgé nénna gamuna méndagucnec nimmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Nuac gezac qema kératacnec népésina. Nuac wamma hoc baŋec kuhaguc ʒéma demiŋ seli aŋgéŋ tinénéŋa wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Gi imi nuac ʒamanʒiŋ ʒéma demiŋ seli baec boŋaiguc tatara, guac qacga niŋac ni nuagicma kemma hénana qindiŋi nénna. ");
INSERT INTO kgf_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Népésiwiŋ ʒé sasaŋgiaiguc ufic haigic hezac imuacnec héré némbésémaŋ. Gi imi nuac hoc baŋec. ");
INSERT INTO kgf_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Ni nuac qeri uŋana guac méragaiguc haizua. Haka hélawac Anutu gi boŋ héréna menec. ");
INSERT INTO kgf_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Ni imi iwawai eŋomia ikora mepésianʒu imi onac méʒéna tianʒac. Ni Yaweac muru héima naŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Geŋ nuac yéwécna héŋtegicma kekec uŋana ʒérabéraiguc kecʒac imi nimmizaŋ. Imuac guac goi héihéigawac qeriaiguc ewa hia nimma ségiségi wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Imuhuc wamma haʒéchécna ionac méraiguc ménda wainémma nuac hénana baec kawé qeqeya yandaiguc nopocʒaŋ. Imuac niŋac ni guac goi héihéiiguc ewa hia nimma ségiségi waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Yawe nuac ʒérabéra niŋac wamma ewa hia niŋnémbésémaŋ. Ni imi niŋ yéwécna niŋac kicna ʒéma kekec uŋana ʒéma séwinanéŋ méiméiya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Kekecna imi ewa biriciguc sohoanʒac. Yawuŋna imi ʒésilacguc hama kenʒac. Képésicna niŋac nimbiriwa séwinawac kuha imi mayu, sicna imi lokolima kenʒac. ");
INSERT INTO kgf_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Haʒéchécna ieneŋ ʒédesi waŋnéŋanʒu, waŋu ama momachécna imi eneŋ acguc ogicma imuhuc waŋnéŋanʒu. Alahécna eneŋ néŋqacgéma keŋanʒu. Waŋu ic tosara imi hénaiguc mihicŋi némma néŋgacanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Ni imi humuc ic ésécnec eluŋ unudacʒac. Waŋu ni kewuc nomuŋ tétéya ésécnec, ewa qeriginanéŋ ménda niŋnénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Ic tuŋagucnéŋ ʒébiri néŋgic niŋanʒua. Ieneŋ lelecgé némma tericgé nénʒu. Ieneŋ haʒéc waŋ némma ʒéeminiŋ wamma kekec uŋana nuagicbiŋ ʒé niŋareŋgézu. ");
INSERT INTO kgf_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Néŋ ni imi Yawe guac muru héima namma gi imi nuac Anutu ʒéanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Naléna imi méragaiguc hezac. Haʒéchécna ʒéma nunesi waŋanʒu ionac méragina igucnec kératacnec népésina. ");
INSERT INTO kgf_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Guac kic tanecga asahagucnéŋ weleŋ qeqe icga ni némma guac goi héihéiganéŋ aŋgéŋna tina. ");
INSERT INTO kgf_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Yawe, ni guruzua, gamuiguc ménda nopocma, ic biria ionac gamu qeqe mihicŋi énécmima kic suaŋiguc onopocna acgina qaimac. ");
INSERT INTO kgf_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Séwi eŋeŋ ac ʒéma ac ʒéragucnéŋ ic solaŋa unuanʒu ionac kua taségina ikora imi héʒicgéna acgina qaimac. ");
INSERT INTO kgf_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Guac bac yandi yandi wamma kecanʒu ionac niŋac sese qauqau haina emma hezac imi yei kuneŋ yanda wanʒac. Ewa hiawac buŋa imi guac néŋgacma haanʒu ionac niŋ wamma sasala haina hezac. ");
INSERT INTO kgf_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Geŋ ic imuhucya guac saŋgi saŋgiiguc musaŋgé énécmima, ic onac manam batucac ai areŋgégic hezac imuacnec metecgé énécmima, guac haliiguc musaŋgé énécmina, ic biria ionac ʒéhésiginawac qiʒiʒiŋgéma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Yawe ʒéhiaru mimia waŋu. Inéŋ ama areŋa demiŋ seliaguc imuhucgeŋ goi héihéiya welic welicgia nézéyu héŋi. ");
INSERT INTO kgf_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Ni aurima guac wéségaiguc elicgé nénéŋa wanʒua ʒéyi, néŋ guac qachéhéliwa nuac ʒéwelecna selia imuac hétéŋa niŋnec. ");
INSERT INTO kgf_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Ic embac météré énécmimia ini mocʒoŋ Yawe siŋa niŋmigic. Yawenéŋ ic hakagina héla imi inicgaleŋ waŋ énécmima, séwi eŋeŋ ic imi bakia yéwéria meleŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Yaweac mambéc kekec ini ʒénéŋ hirihiri qahac seligima nammu. ");
INSERT INTO kgf_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","(Dawidiac legic ʒéra.) Héna ac logiyu aumima képésicya hoturu mimia waŋu ségiségiyaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Qeri uŋaiguc ikoc ménda heyu Yawenéŋ képésiraguc ménda ʒémiyu imi ségiségiyaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Ni képésicna ménda lomma ʒeauyi nalé imuaru kaiwe herec héisilac wamba sicnanéŋ lokoliyec. ");
INSERT INTO kgf_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Hénia imi yomuhuc; Guac méraganéŋ siŋi kaiwe helanʒi néŋu kaiwe geriwanéŋ ʒeriru iwawai mocʒoŋ ʒicgéanʒac ésécnec nuac sépécna imi ʒicgédarec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Waŋu ni képésicna Yaweac muru ʒéaumaŋ ʒéma nuac képésicna ʒéma hakana biria ménda musaŋgéma auwa geŋ imi képésicnaguc ʒénénéŋa imuacnec metecgé nénnec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Imuac niŋac, Anutu eeya héimima kecanʒu imi wai énécmina, gi mihicŋi géŋgéŋa wammac nalé imuaru gi ʒéwelec waŋgémmu. Imuhuc waŋgic doku ɋaoŋ érémac imi ionac hia ménda emma énépésimac. ");
INSERT INTO kgf_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Gi imi nuac saŋgi saŋgina, ʒérabéraiguc ni néŋgaleŋ waŋ némma, aŋgéŋ titiac hériaŋ legicnéŋ ni lelecgé néŋanʒaŋ. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Ni imi gi imuhucgeŋ me imuhucgeŋ kemmaŋ ʒé niŋna héna imi gézéwa hémbésémaŋ. Waŋu géŋsosolima ʒéqindiŋi gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Ini imi becosic kuneŋ me komora niniŋgina qahac imuhucya ésécnec ménda wammu. Ieneŋ imi kuaginaiguc pinʒuŋ ʒéma déméŋginaiguc hésanéŋ koro ɋaté ménda énécmigic imi hosucginaiguc ménda haanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Ic biria ionac imi ewa biric sasala hicŋi énécmimac, néŋ Yawe niŋkinʒéŋ wammianʒu ionac imi goi héihéiya lelecgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Ic solaŋa ini Yaweac ségiségi wamma ʒézé ségiségi wammu. Ewa qeri dindiŋanec kecanʒu ini mocʒoŋ ségiségi wamma hériaŋ haimu. ");
INSERT INTO kgf_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Ic solaŋa ini Yaweac niŋac ʒézé ségiségi wammu. Mepé qepésiac legic imi ic solaŋa ionac buŋa sécya. ");
INSERT INTO kgf_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Gita ʒéma kulele hésia sasalanéŋ Yawe ewa hia wammima mepési mimu. ");
INSERT INTO kgf_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Legic ɋelianéŋ héimima ségiségiac ewa hétéŋnéŋ hiabianec meʒericma héimimu. ");
INSERT INTO kgf_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Yaweac ackuaʒéc imi solaŋ dindiŋa, waŋu iwac haka silic imi mocʒoŋ hélacnec. ");
INSERT INTO kgf_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Inéŋ haka solaŋa ʒéma haka dindiŋawac siŋa niŋanʒac. Imuac baec séc Yaweac goi héihéianéŋ sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yaweac ackuaʒécnéŋ kurumeŋa kurumeŋa mihicŋiyec. Iwawai sécgéma hezac imi mocʒoŋ kuaya wéséséyanéŋ mihicŋidarec. ");
INSERT INTO kgf_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Inéŋ konduŋ doku qauqau haiyu eŋu doku hiŋgac hiŋgara imi hofi yandaiguc haiyu heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Baec séc ic embac Yaweac bac yandi yandi waŋgic. Baera baera miŋina ini eeya héi mimu. ");
INSERT INTO kgf_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Imi mia hénia yomuhuc niŋac; Iwawai imi mocʒoŋ inéŋ ʒéyu hicŋidarec. Waŋu inéŋ ʒéseliyu seligima nandarec. ");
INSERT INTO kgf_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Yawenéŋ baera baera ionac niniŋ areŋgia imi nélicgéyu nenesic wandacʒac. Waŋu hicŋisai hénia hénia ionac niniŋ hiŋgac hiŋgara imi meleŋu eŋomia wandacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Yawenéŋ niniŋa niŋareŋgéyu hehe seli naŋselianʒac. Iwac niniŋa hiŋgac hiŋgaranéŋ hicŋisaiya hicŋisaiya emma hema kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Yaweac neŋaŋ Anutu ʒémima aŋgéŋ tigic Anutuac ic embac buŋa ʒéénécmiyu kecʒu imi eneŋ ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yawenéŋ kurumeŋiguc ninicsosolima baec ic mocʒoŋ ninicanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Tacyac waŋanʒac ama duŋa imuacnec mia baec séc tacyachéra imi mocʒoŋ kiwa hiyu mayu ninicanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Inéŋ mia ic séc ionac ewa qerigina héniagina meyacgéma wawaŋ memegina héŋsosolianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ic kewu méŋac aŋgéŋ timimia imi téŋgiŋ ichéra sasala ionac muru ménda hezac. Ic kawali méŋac aŋgéŋ timimia imi acguc eŋeya kuha kuneŋ yanda imuaru ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Kekecnina imi becosic me kuc yandanéŋ ménda aŋgéŋ tiwiŋac séc. ");
INSERT INTO kgf_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Ninʒu, Yawe imi eeya héimima goi héihéiyawac kic hihi waŋanʒu imi onac inicgaleŋ waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Imuhuc wamma ionac kekec uŋa imi humuc igucnec metecgé énécmima béti naléiguc méra énécmiyu kekecginaguc kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Kekec uŋaninanéŋ Yaweac kic hihi waŋanʒiŋ. Inéŋ mia neŋaŋ héipuc ic ʒéma saiwanina wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Ewa qerininanéŋ iwac ségiségi wamma iwac qac téréyawac héima naŋanʒiŋ imuac mia imuhuc waŋ nénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Yawe, guac mambéc waŋanʒiŋ nalé sura imuac séc guac goi héihéiga qacninaiguc hemac. ");
INSERT INTO kgf_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","(Dawidinéŋ ic kewu Awimelekac wésiaiguc ic moroha tanec haka waŋu nesimigic mayec nalé imuaru legic yomi oyec.) Ni Yawe nalé séc mepési mimaŋ. Mepé qepésiya imi nuac kuaiguc susucnec hemac. ");
INSERT INTO kgf_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Nuac kekec uŋananéŋ Yaweac niŋac ʒézé ségiségi ac wammaŋ. Maqeqeya ieneŋ nimma ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Niguc momacnec Yawe imi kuneŋ yanda kuneŋ ʒéni. Neŋawu iwac qac buŋaya meyacmini. ");
INSERT INTO kgf_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Ni Yawe ʒéwelecmiwa niŋnémma ʒénéŋ hirihirina hénia hénia igucnec metecgé néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Ieneŋ iwac niŋkumuma kecma asac mararaŋ séwi usu ésécnec héiénécmimia waŋec. Ionac kic tanecgina imi hémbénaŋa gamuyaguc ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Kekec uŋa maqeqeya imuhucyanéŋ qac héhéli miyu Yawenéŋ nimmima ʒérabéra hénia hénia imuacnec aŋgéŋa tiyec. ");
INSERT INTO kgf_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yaweac kua meme uŋanéŋ Miŋ Kewuac eeya héimianʒu imi onac lelecgé énécmima tacyac wamma aŋgéŋ tiénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Ini imi Yawe imi hiabia wanʒac imi batucgéma siŋa niŋgic. Néŋgacma iwac muru kemma kecanʒu imi eneŋ ʒézé ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Météré énécmimia ini Yawe eeya héimigic. Ninʒu! I eeya héimianʒu imi eneŋ sécgé énécmiyu iwawai méŋac méŋ niŋac ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Laion sac ɋelinéŋ yaka niŋ humuwacnec, néŋ Yaweac wamma kecanʒu imi eneŋ buŋa hiabia hénia hénia he énécmiyu ménda hocmu. ");
INSERT INTO kgf_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Nambérac ini hama gezac qema nimmu. Yawe eeya dimuhuc héimimu imuac hénia ku énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Mérénéŋ kekecac niŋ kumuma yawuŋ sasala kecma mériaŋ mihicŋimaŋ ʒé wanʒac? ");
INSERT INTO kgf_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Gi imi guac ezelaŋgawac neuŋ héiamuma kua tasianéŋ ac biria ménda ʒéna. ");
INSERT INTO kgf_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Haka biria gilina keŋu, haka hiawac wamma mema, luaeac wamma nesimiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Yaweac kiwanéŋ ic solaŋawac hiyu keŋanʒac. Waŋu ic imuhucya ionac qac héhéliginawac gezac qeanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Yaweac kic tanera imi kaiʒiliweŋ waŋanʒu imi onac musuqeqe waŋ énécmima ionac eluŋ unudacmac niŋac baeciguc metecgé énécmimaŋ ʒé niŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Qac héhélima ʒéwelecmianʒu imi onac niŋénécmima ʒérabéra hénia hénia igucnec metecgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Yawe imi ewa biri waŋkecʒu ionac hosucgé énécmima ewa qerigina meleŋ énécmianʒac. Waŋu ewa qerigina qéséŋu howuc howuc wanʒac imi aŋgéŋgina tiénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Ic solaŋanéŋ ʒérabéra sasala mihicŋimacac hezac, néŋ Yawenéŋ ʒérabéra séc metecgé mianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Sicya imi mocʒoŋ galeŋgéyu méŋ ménda ʒéŋgémac. ");
INSERT INTO kgf_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Birianéŋ ic biria qeyu humumac. Waŋu ic solaŋawac méʒétiti wammianʒu imi képésic ginaguc ʒéénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Yawenéŋ weleŋ qeqehéra ionac kekec uŋa imi mocʒoŋ boŋhérégina meénécmimac. Néŋgacma iwac muru keŋanʒu imi onac imi képésic ginaguc ménda ʒéénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","(Dawidiac legic.) Yawe, niguc tohalic wanʒu iniguc tohalic wamma, niguc euqeqe wanʒu iniguc euqeqe wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Saiwa yanda ʒéma asamaŋ késama yacma méra némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Luac héréma nesinénʒu imi onac hénagina héʒicgéna. Nuac kekec uŋanawac ʒéma Neŋ guac aŋgéŋ titi miŋina. ʒénénna. ");
INSERT INTO kgf_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Nuac kekec uŋanawac hochoc ai mezu imi onac gamu qeqe mihicŋi énécmina. Mebiri némbiŋ ʒé wanʒu imi nesi énécmina andé andé kemma gamunéŋ unu humudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Kua meme uŋahécga énézéna ieneŋ luhucnéŋ goc mihilaŋgéyu keŋanʒac ésécnec mihilaŋgé énécmiyu kendacmu. ");
INSERT INTO kgf_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Hénaginaiguc siŋi ʒéma susurac mihicŋi énécmima kua meme uŋaga ézéna nesi énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Ieneŋ héniana qahaciguc ni népésiwiŋ ʒé baec séséŋiguc ufic musaŋgé haima héniana qahaciguc kekec uŋana mebiri némbiŋ ʒé baec séséŋ éséma lekiŋ himicanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Ʒéna élanzaŋnec humucnéŋ hicŋi énécmimac. Ufic musaŋgégic hezac imuaru eŋaoc eŋgic énépésiyu humucac buŋa hiŋgacdacmu. ");
INSERT INTO kgf_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Nuac kekec uŋananéŋ Yaweac ségiségi wammac. Iwac aŋgéŋ titi niŋac ʒézé ségiségi wammac. ");
INSERT INTO kgf_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Nuac sicna mocʒoŋ yomuhuc ʒému; Mérénéŋ Yaweac séc wammac? Inéŋ maqeqeya imi kucginaguc helanʒi énécmianʒu ionac méragina igucnec metecgé énécmianʒac. Waŋu maqeqeya imi iwawaigina onagicanʒu ionac murunec metecgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Héipuc ic ikoranéŋ yacma haka ni ménda niniŋnawac qesinénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Hakana hiawac haka birianéŋ meleŋ néŋgic, kekec uŋananéŋ niŋgumbi niŋguŋ kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Ni imi ieneŋ hafi iniyu hegic ewa biricac séwi usu héima nene ʒiki kecma kekec uŋana helanʒi amuyi, néŋ ʒéwelecnanéŋ eŋ liliŋgéma hayu tétécgézua. ");
INSERT INTO kgf_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Nuac alana ʒénimma dac muna waŋ énécmianʒua ésécnec waŋ énécmiyi. Waŋu neŋgocnawac siari ésécnec ionac wamma sicgéma siari. ");
INSERT INTO kgf_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Waŋu ni ʒérabéra mihicŋima kecba ieneŋ ségiségi wamma aʒorogic. Waŋu kaiʒiliweŋ ic ni ménda nimmianʒua imi eneŋ sasaŋgiaiguc tocgéma susucnec nunesi néŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Waŋu ieneŋ ségiségi ariaciguc aʒoroma ʒébiri qébiri waŋanʒu ésécnec nuac niŋac ʒécgina kiʒéŋgéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Miŋ kewu, nalé dahecac séc eŋ inicma kecbésémaŋ? Nuac kekec uŋana imi kisikiyoŋ ic ionac murunec metecgéna. Momacguc sac henénéŋa imi laion imuhucya ionac murunec metecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Ni hénaoriŋ sucginaiguc mepésigémma, ic embac tuŋa tuŋa sucginaiguc gi mepésigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Ménda wai énécmina, nuac haʒéchécna ieneŋ sicsaoc nuac niŋac ségiségi wambu niŋac. Haʒéc waŋnéŋanʒu ieneŋ héniana qahaciguc kic hoc menémma ʒébiri némbu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Ieneŋ imi luaeac ac ménda ʒéma baeciguc bénʒéŋ kecanʒu imi onac ac ikocnéŋ yéwéri mihicŋi énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Waŋu ieneŋ kuagina kuneŋ yanda aŋgéma nuac ʒédesima ahaec, ahaec, kicnéŋ héipuc wamma héndacʒiŋ. ʒézu. ");
INSERT INTO kgf_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Yawe, geŋ mia haka imi héndacʒaŋ imuac acga qaiyunec ménda kecbésémaŋ. Waŋu lakec ménda kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Nuac Anutu, Miŋ Kewuna gau igucnec hetecgéma yacma nuac acna ʒégési wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yawe, nuac Anutu, guac haka solaŋaiguc ʒégési néŋna. Ieneŋ nuac niŋac ségiségi ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Ménda wai énécmina, ewa qeriginanéŋ ahaec ewa siŋnina séc hicŋizac, ic imi ɋécgé miziŋ. ʒéwu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Ʒéna yéwécna niŋac ségiségi waŋanʒu ieneŋ gamu qeqe mihicŋima gamu mamasuŋ kuneŋ yanda nimmu. Waŋu nuac muru séwi eŋeŋ waŋanʒu imi onac gamunéŋ qacginaiguc endacmac. ");
INSERT INTO kgf_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Nuac solaŋ dindiŋanawac niŋgic sécgéanʒac ionac imi ʒéna ségiségi wamma qacma ewa hia nimmu. Weleŋqeqe icya luaeiguc keru ségiségi waŋanʒac Yawe imi kuneŋ yanda! ʒéma nalé séc ézému. ");
INSERT INTO kgf_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Ni ezelaŋnanéŋ kaiwe herec guac haka solaŋa ʒénimma kaiwe herec gi mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","(Legic galeŋawac; Yaweac weleŋqeqe ic Dawidiac legic ʒéra.) Ic biria ionac héniagina biriawac niŋtegic qiŋtegic ac méŋ ewa qerinaiguc yomuhuc hicŋizac; Iwac kiwaiguc Anutuac bac yandi yandi méŋ ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Inéŋ séwi eŋeŋ wamma eŋeya képésicyawac ʒéma méŋnéŋ méŋ mewininimac me méʒia timacac séc qahac ʒéanʒac imuac mia. ");
INSERT INTO kgf_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Kuayawac ac imi képésicyaguc ʒéma ikocyaguc. Inéŋ niŋtegic qiŋtegicya ʒéma haka hia imi waiyu tecgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Inéŋ hehe tataciguc hema biria niŋareŋgéma eŋeya héna biriaiguc opocamuma haka biriawac méʒétiti qahac kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Yawe, goi héihéiga kurumeŋiguc sécgéma heyu, guac haka héla iminéŋ ou hosusu iguc sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Solaŋga imi Anutuac baec boŋa ésécnec. Guac ʒégésigésinéŋ konduŋ ésécnec. Yawe geŋ imi ic embac ʒéma yaŋ momacnec ninicgaleŋ waŋ nénécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Anutu guac goi héihéiganéŋ yei eeyaguc yanda wanʒac. Baec ic mocʒoŋ guac qeŋgaŋga amiayaiguc néŋgacma saŋgianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Ieneŋ imi guac amaiguc iwawai kindindiŋa hezac imi neʒéléléŋ wamma, ségiségiac doku téfara igucnec gumu énécmina neanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Kekec dokuac kiwanéŋ guac muru hezac. Guac asac mararaŋiguc asaha hémbiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Gi niŋgéŋanʒu ionac muru goi héihéi susucnec waŋ énécmima ewa solaŋ kecanʒu ionac guac solaŋga imuhucyanec mihicŋi énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Séwi eŋeŋ ic ionac héna tawéginanéŋ nesinémbac niŋac. Galeŋgé néŋna ic biriawac méraginanéŋ nesinémbac niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Kaiʒiliweŋ waŋanʒu imi eneŋ imuaru maunuyec. Ieneŋ mama hema muŋguc yacmuac séc qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","(Dawidiac legic ʒéra.) Haka biria waŋanʒu ionac niŋac qeri geric hélandaŋnec ménda wamma képésic waŋanʒu imi onac nimbupuc ménda wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Ieneŋ imi ɋézézac ésécnec focdac qeriru ɋasima mamu. Waŋu ʒuaʒua ésécnec méima humumu. ");
INSERT INTO kgf_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Yaweac muru héima namma haka hiabia wambésémaŋ. Baeciguc kecma iwac haka héla imi nene ésécnec nema kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Yaweac ségiségi wamma kecbésémaŋ. Inéŋ guac ewa siŋgawac héla mihicŋigémmac. ");
INSERT INTO kgf_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Guac kekecgawa hénaya imi Yaweac muru haimina. Iwac muru héima nanna, inéŋ wamma medacmac. ");
INSERT INTO kgf_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Inéŋ waŋgéŋu, guac solaŋga imi asac mararaŋ ésécnec, guac hakaga solaŋa imi meleŋu kaiwe wenʒoroŋiguc kaiwe asaha ésécnec wammac. ");
INSERT INTO kgf_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Yaweac wéséyaiguc bénʒéŋnec mambéc kecbésémaŋ. Ic birianéŋ héna ɋéréŋgé mimia waŋu ai areŋ biria meseliyu kindindiŋa yaru hémma qeri biric hélandaŋnec ménda wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Qeri geric waima qeri biric gilina keŋu. Ʒénasiŋ menasiŋ ménda wanna. Haka imuhucya imi haka biria mihicŋimac. ");
INSERT INTO kgf_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Haka biria waŋanʒu imi eneŋ qericénécmiyu qahac wandacmu, néŋ Yaweac mambéc kecanʒu imi eneŋ baec késamu. ");
INSERT INTO kgf_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Ic biria imi hotoŋadac kecma tecgéma qahac wandacgic imuaru hocma hocbipiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Waŋu gum bénʒénʒéŋ ic imi baec késamu. Waŋu ewa momac hakanéŋ sécgé énécmiyu ségiségi wamma kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Ic birianéŋ ic hiabia qemaŋ ʒé niŋareŋ wamma kic hiyu iwac muru keŋu ʒéra kiʒéŋgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Miŋ Kewunéŋ ic imuhucyawac naléya hosucgéyu héŋtegicʒac imuac niŋac ʒédesi wammianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Ic birianéŋ maqeqeya ʒéma iwawai niŋac hocanʒu imi eneŋ maunumac niŋac ʒéma ic dindiŋanec keŋha waŋanʒu imi unuhumumaŋ ʒé souya héréma tewiya awianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Néŋ sou iminéŋ eŋeya wéiwécya néʒéŋgémac. Waŋu tewi imi ʒéŋgédacmac. ");
INSERT INTO kgf_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","17","Ic biriawac méria imi ʒéŋgémac, néŋ ic hiabia imi Yawenéŋ késa seligimimac. Imuac niŋac ic solaŋawac iwawai komodianéŋ ic biria sasala ionac iwawai kuneŋ yanda imi ogicanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yawenéŋ ic képésicya qahac iwac kekec naléya imi mocʒoŋ nindaru hezac. Iwac mératéc ai buŋa imi heheseli hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Ic imuhucya ieneŋ imi ʒérabéra naléiguc gamugina ménda mihicŋima béti naléiguc acguc iwawai sécgé énécmiyu kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Ic biria imi birimac. Yaweac haʒéchéra imi rama merawawac haléc ésécnec ʒepépélima hofac qema aucgéma qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Ic biria imi iwawai mema tasia ménda meleŋanʒu, néŋ ic solaŋa imi ewa hiawac eŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Miŋ Kewuac mériaŋginaguc imi eneŋ baec késamu. Ic saecginaguc imi qeric énécmigic qahac wammu. ");
INSERT INTO kgf_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yawenéŋ ic onac tikeŋ tihagina meseligima kekecac héna imuac ségiségi waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ic imuhucya imi Yawenéŋ késaseligianʒac imuac niŋac qonʒontoŋ gémaciguc mocʒoŋnec ménda tendiŋgédacmac. ");
INSERT INTO kgf_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Ni komocna igucnec éréma deguc yandanaiguc, ic solaŋa andé qema waimimia méŋ ménda héŋiac hénʒua. Waŋu hémba iwac ɋelihéra méŋnéŋ méŋ yaka niŋ ménda ʒéwelec waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Ic imuhucya imi kaiwe herec ewa hiawac eŋ énécmima haiyu keŋ haiyu ha waŋanʒac. Imuac ɋelihéra eneŋ mériaŋ mihicŋi énécmiyu kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Haka biria waima haka hiawac wammu. Imuhuc wamma nalé tetecgia qahac kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Yawenéŋ haka solaŋawac siŋa nimma météré ic imuhuc waŋanʒu imi ménda wai énécmimac. Ic imuhucya imi nalé tetecgia qahac inicgaleŋ waŋ énécmimac, néŋ kaiʒiliweŋ ic ionac ɋelihéra imi qeric énécmigic qahac wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Ic solaŋa imi baec késama imuaru hémbénaŋa kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Ic solaŋawac kua imi ac niŋtegic qiŋtegicyaguc ʒéhicŋima, ezelaŋanéŋ haka dindiŋawac ʒémac. ");
INSERT INTO kgf_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Iwac ewa qeriaiguc imi Anutuac héna acnéŋ heyu keŋkeŋ hahaiguc tisuqisurac ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Ic biria eneŋ ic solaŋa unuwiŋ ʒé awima kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Yawe imi ic solaŋa ic biriawac mériaiguc ménda waimimac. Waŋu ʒégésigési naléiguc acguc képésiraguc ménda ʒémimac. ");
INSERT INTO kgf_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Yaweac niŋkumuma iwac kekecac héna imi méndacma kembésémaŋ. Inéŋ meyac gémma baec buŋa qegéŋu aŋgétiwésémaŋ. Waŋu kaiʒiliweŋ ic imi birima qahac waŋgic kicganéŋ hima inicbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Ni ic biriawac kuha hémba ic hésa téŋgiŋ téŋgiŋ eŋeya baeciguc nanaŋa ésécnec wanʒac, néŋ ");
INSERT INTO kgf_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","ic hésa imi éléŋnec humuqai waŋu hocma hocbipiyi. ");
INSERT INTO kgf_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Néŋ ic solaŋa héŋsosoligic. Ic dindiŋa héŋgic. Luae ic imuhucya imi eneŋ andiaginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Ac qeqe ic ieneŋ momacnec biridacmu. Kaiʒiliweŋ ic ionac tetecgia imi humu qaiyaguc. ");
INSERT INTO kgf_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Ic solaŋawac aŋgéŋ titi imi Yaweac muru hezac. Inéŋ ʒérabéra naléiguc hoc baŋec ésécnec wammimac. ");
INSERT INTO kgf_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Yawenéŋ méra énécmima metecgé énécmimac. Ic biria ionac murunec metecgé énécmimac. Ieneŋ imi néŋgacma iwac muru saŋgianʒu hénia imuac niŋac imuhuc waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","(Dawidiac legic yomi hofac omiwiŋ ʒé héiaŋgic.) Yawe, guac qeri biricganéŋ képésicna ménda ʒénénna. Guac qeri gericnéŋ ni ménda ʒéqindiŋi nénna. ");
INSERT INTO kgf_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Guac ʒakoŋnéŋ nuac séwinaiguc néʒéŋgéma hiŋgacʒac. Guac méraganéŋ selianec helanʒi nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Guac qeri biric niŋac séwi busuna solaŋa méŋ ménda hezac. Nuac képésic niŋac nuac sicna imi bénʒéŋa qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Nuac képésicnanéŋ orucnaiguc sécgéma eŋu hinac yéwéria tanec waŋu bisiqatéŋ wammaŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Nuac wizinanéŋ houyu wéréŋ biria haizac. Imi mia nuac haka qelaŋa imuac tasia. ");
INSERT INTO kgf_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Ni geriwa noyu ɋoucgéma kaiwe herec ewa biric wamma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Nuac maréŋnaiguc geriwa sécgénénʒac. Waŋu nuac séwina solaŋa méŋ ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Séwina héʒéʒayu humumia tanec wanʒac. Ewa qerina waiʒalaŋ waŋu ʒésilac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Miŋ Kewu nuac niŋ kewu imi mocʒoŋ guac muru hezac. Nuac ʒésilacnanéŋ guac wéségaiguc usuya qahac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Wéiwécnanéŋ hélandaŋ yaru kucnanéŋ mayu qeka meka wamma kicna imi acguc mugu mugumia waŋu asaha qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Numindiŋiga imi nuac séwinaiguc hezac imuac niŋac nuac sorochécna ʒéma alahécna lakec kecgic sac taséhécna ini acguc lakec nanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Nuac kekec uŋanawac hochoc ai meanʒu ieneŋ bétac hainénʒu. Mebiri némbiŋ ʒé wanʒu imi eneŋ humumia tericgé némma kaiwe herec andé nuwiŋ ʒé haka biria ʒéareŋgéma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Ni gezac héŋ ésécnec niŋbipima ic ara qahac ésécnec kuana ménda aŋgéma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Ni gezac héŋ ésécnec wamma acgina ménda meleŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Yawe ni guac niŋkumuma kecanʒua. Nuac Miŋ Kewu Anutu, gi acna meleŋ némbésémaŋac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Ni yomuhuc ʒézua; Ni tisuqisurac wamba ieneŋ nuac niŋac ségiségi wamma séwi eŋeŋ waŋ némbu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Ni léklék manumacac heyu niŋyéwécnanéŋ nalé séc henénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Hénia imi yomuhuc; Ni képésicna ʒéauma nuac képésic niŋac ewa biric waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Nuac haʒéchécna ieneŋ kucginaguc keŋha waŋanʒu. Waŋu téŋésima méʒétiti waŋnéŋanʒu ionac ʒaŋgégina imi sasala. ");
INSERT INTO kgf_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Waŋu haka birianéŋ haka hiawac meleŋ énécmianʒu imi eneŋ ni haka hiawac méndacma kemba hénia imuac niŋac mia haʒéc waŋ néŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Yawe gi ménda wainémma kenna. Nuac Anutu lakec ménda kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Focdac qenaŋgé waŋ nénna. Miŋ Kewu, gi nuac aŋgéŋ titina. ");
INSERT INTO kgf_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","(Dawidiac legic.) Neŋ yomuhuc ʒéyi; Ni hakana loloŋgéma wamma ezelaŋnanéŋ képésic ménda mihicŋimaŋ. Ic biria ieneŋ wésénaiguc nanʒu séc kuanaiguc neuŋ ʒékalaŋa haiwa hemac. ");
INSERT INTO kgf_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Ni acna qaiyu ac hiabia acguc ménda ʒéwa niŋ yéwécna imi muŋguc yandizac. ");
INSERT INTO kgf_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Nuac ewa qerina geriwaguc waŋu qerinanéŋ ʒénimba hiŋgacma éséyu qeri biric yaru ezelaŋnanéŋ yomuhuc ʒézua; ");
INSERT INTO kgf_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","Yawe, kekecnawac tetecgia ʒéma nalénawac séha imi nézéna niŋasarima nuac kekecna dodowima hazac imi niŋtegicmaŋ niŋac ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Geŋ mia nuac naléna imi méra tawé ésécnec mehotoŋina nuac kekecnanéŋ guac kicgaiguc ménda hezac tanec wanʒac. Icya icya naŋselima kecanʒu, néŋ hofac ésécnec aucgéanʒu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Hélacnec, ic neŋac neŋac imi héla qahac, néŋ uŋa tanec keŋha wamma ai eŋomiawac keŋkésa hakésa wamma iwawai mihicŋima saméŋaguc haini emma hezac, néŋ hélacnec mérénéŋ iwawai imi nonagicma késamac imi acguc ménda niŋasarima kecanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Miŋ Kewu ni erac némac iwawai niŋac niŋkumuma mambéc kecmaŋ? Nuac niŋkumuna imi guacnec hezac. ");
INSERT INTO kgf_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Ni képésicna mocʒoŋ imuacnec metecgé némma galeŋgé nénna, ewa soho ic ieneŋ ʒébiri qébiri waŋ némbu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Waŋu Miŋ Kewunéŋ haka imi waŋ nénʒac ʒéma nimma acna qaiyu kuana ménda auanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Guac numindiŋi nuac muru hezac imi nuagicma gilina keŋu. Méraganéŋ nuna ni qeka meka wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Geŋ ac ʒéénécmima ic unu qindiŋianʒaŋ nalé imuaru iwawaigina eeyaguc imi waŋ énécmina gisicnéŋ neyu qahac waŋanʒac ésécnec qahac wanʒac. Imuac icya icya imi wésésé ésécnec wanʒu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Yawe nuac ʒéwelecna niŋnémma nuac qacsilaciguc gezac hainéŋna. Kic masina maanʒac nalé imuaru acga ménda qaimac. Ni imi yandahécna ésécnec ic kiaŋ tanec, ic qaŋ tanec giguc kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Képésicnawac ménda héŋsosolima, hafina mehiaru némma kekecna komocdia dac mehorugina ségiségi nimmaguc humuwa. ");
INSERT INTO kgf_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Ni Yaweac mambécnéŋ mambéc kecba gezac haima ʒésiacna niŋec. ");
INSERT INTO kgf_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Inéŋ ni baec séséŋ biriqiria igucnec hérénéŋu éréwa hénana ʒamanʒiŋ hilaŋeŋiguc nopocma keŋkeŋ hahana imi meseli néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Legic ɋelia Anutuac mepé qepésiac buŋa, kuanaiguc haiyu ic embac sasalanéŋ némma bac yandi yandi wamma Yaweac muru héima nammu. ");
INSERT INTO kgf_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Yaweac héima namma séwi eŋeŋ ic ʒéma ac ikociguc lukeŋ luha waŋanʒu imi onac kichihi ménda waŋanʒu imi eneŋ ʒézé ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Yawe nuac Anutuna, wawaŋ meme welic welicgia geŋ wannec imi sasala. Waŋu niniŋga nonac niŋ wamma niŋna hiŋgacanʒac imi acguc sasala waŋu ni olomma ʒémaŋac séc qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Geŋ mia gezacnaiguc nézéna héiyu yomuhuc niŋi; Ni mulumanaŋ ʒéma seseac ewa hia ménda nimma hofac oo ʒéma képésic waiwaiac olémbaŋ imuac ménda waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Imuhuc ʒéna imuaru ni yomuhuc ʒéyi; Ni hazua, nuac ac ooya imi kiwi limbi limbiŋaiguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","O, nuac Anutu, ni guac ewa siŋ niŋtohomaŋ ʒé ségiségi waŋanʒua! Imuac guac héna acnéŋ nuac ewa qerinaiguc heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ni hénaoriŋ yandaiguc guac solaŋ dindiŋaga imuac buŋa suruc ségiségiyaguc imi ʒéau énécmianʒua. Ninʒaŋ, Yawe ni kua taséna ménda héiwa eŋ heanʒac imi gi nindacʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Ni guac solaŋga imi nuac ewa qerinaiguc ménda musaŋgéwa heyec, néŋ guac haka héla imi ʒéma aŋgéŋ titi imi ʒéau énécmima goi héihéiga ʒéma hakaga héla imi hénaoriŋ yandaiguc ménda musaŋgé énécmianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Yawe guac ewa biricga imi ménda héʒicgéna susucnec mayu. Waŋu goi héihéiga ʒéma hakaga héla iminéŋ ni nalé séc néŋgaleŋ waŋ némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Biria gelec malec qahac ni lelecgé néŋu nuac képésicnanéŋ méramma nuaru hayu kic hima gémmaŋac séc qahac. Képésic imuac ʒaŋgégina imi nuac oruc ʒucna ogicma heyu nuac ewananéŋ sohodacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Yawe ewa biric waŋ némma aŋgéŋna tina. Yawe focdac méra némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Nuac kekec uŋana mihicŋima mebiri némbiŋ ʒé wanʒu imi mocʒoŋ gamu qeqe ʒéma gamu mamasuŋ mihicŋi énécmina. Waŋu ʒéna ʒérabéra hicŋinéŋu ségiségi wanʒu imi mocʒoŋ néŋgacma kemma gamu qeqe mihicŋimu. ");
INSERT INTO kgf_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Waŋénécmina nuac niŋac ahaec ʒéma desianʒu ieneŋ eŋaŋ gamugina héŋtegicma aurimu. ");
INSERT INTO kgf_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Waŋénécmina, guac hochoc wamma mihicŋianʒu imi eneŋ guac niŋac ségiségi wammu. Waŋu guac aŋgéŋ titiac qerinéŋ wammianʒu imi eneŋ nalé séc Yawe imi kuneŋ yanda kuneŋ ʒému. ");
INSERT INTO kgf_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Ni imi maqeqeya kecma imuac me imuac hocanʒua. Imuac niŋac Yawe imi nuac niŋnémmac. Gi imi nuac méra nénéŋ ʒéma metec metec miŋna. Anutuna, nalé ménda mehorugina. ");
INSERT INTO kgf_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Kuc mama wamma kecanʒu ionac niŋkewu waŋ énécmianʒac ic imi ʒézé ségiségiyaguc, nalé biriaiguc Yawenéŋ hénaya méwéréŋgéyu orima kemmac. ");
INSERT INTO kgf_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Yawenéŋ demiŋ memima kekecya galeŋgé miyu baeciguc ʒézé ségiségiyaguc kecmac. Waŋu haʒéc onac ewa siŋiguc i ménda waimimac. ");
INSERT INTO kgf_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Hafi kiyu heyu Yawenéŋ naŋgémimac, Hehe tataciguc hafiya mehiaru midacmac. ");
INSERT INTO kgf_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Waŋu neŋ yomuhuc ʒéyi; Yawe, ewa hia niŋnénna. ni guac kicgaiguc képésicna mihicŋizua. Nuac kekec uŋana mehiaruna. ");
INSERT INTO kgf_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Haʒéc hécnanéŋ nuac ʒébiri némma némac naléiguc ic imi humuyu qara eluŋ nunudacmac ʒézu. ");
INSERT INTO kgf_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Ni némbiŋ ʒé hama ac gorosoŋa wamma néwéc ewa qeriginaiguc ʒébiri qébiri niŋtocgéma amana igucnec hiŋgacma kemma ʒésaigic keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Méʒétiti waŋ nénʒu ieneŋ mocʒoŋ nuac andé ac ʒéma mebiri némbiŋ ʒé areŋgéma yomuhuc ʒéanʒu; ");
INSERT INTO kgf_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Hafi biria késazac imuac ic imi hema muŋguc ménda yacmac. ");
INSERT INTO kgf_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Ala sorocna ninʒéŋgé miwa nuac saméŋ momacnec neaŋic i acguc haʒéc wannémma sou andianéŋ qéfacgé néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Waŋu Yawe Miŋ Kewuna ni ewa hia niŋnémma hafi igucnec metecgé nénna bakia meleŋ énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Haʒécnanéŋ hia ménda nogicʒac imuac gi nuac ségiségi wanʒaŋ imi ni ninʒua. ");
INSERT INTO kgf_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Ni qerina mesolaŋanima kecba naŋgé némma kecnec. Kumu nénna wéségaiguc hémbénaŋa nammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Miŋ Kewunina, Israelac Anutu hénihénia qahac, tetecgia qahac, mepési mimia wammac, hélacnec! hélacnec! ");
INSERT INTO kgf_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","(Legic galeŋawac; Korawac ɋelihéra ionac legic ʒéra niŋtegic qiŋtegicyaguc.) Anutu, dia yaŋ déméŋa qaŋgararaŋ qeyu hakhak géma doku téfara niŋac hocanʒac ésécnec nuac kekec uŋananéŋ guac ewa ewa waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Nuac kekec uŋananéŋ Anutu kekec miŋinawac déméŋa kérakérasia wanʒac. Ni némac naléiguc kemma Anutu wésiaiguc wininimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Ic embac eneŋ kaiwe herec nuac ac ʒénémma guac Anutu imi dimia ʒéma ʒézé qesi waŋ néŋgic nuac kic masinéŋ siŋi kaiwe nenena éséc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Ni becnec nalé téréyawac tacniniŋ kecaŋgic iniguc momacnec keŋha wamma ʒézé ségiségi wamma mepé qepési legic héima onagicma kemma Anutuac ocmuŋ téréyaiguc onopocaŋi. Waŋu deguc haka silicna imuac niŋɋelima ewa biric wamma ewa howucna qocgézua. ");
INSERT INTO kgf_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Kekec uŋana, gi némac niŋac niŋméima waiʒalaŋ nukecʒaŋ? Gi imi Anutuac niŋkumu wambésémaŋ. Ni imi iwac aŋgéŋ titiac kic tanera niŋac néwéc i mepésimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Anutuna, kekec uŋananéŋ qerinaiguc niŋméima mayu, ni Yodan baec ʒéma Herimon ʒéma Miza baec boŋaiguc gi niŋɋeli gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Guac konduŋ dokunéŋ qaru konduŋ hiŋgac hiŋgaranéŋ qac héhéli amugic, guac doku renduŋanéŋ ʒéma doku temboŋa limbima hama hoturu nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Kaiweiguc Yawenéŋ goi héihéiya waŋ némma siŋiyaiguc legicnéŋ nuac muru henéŋu, kekecnawac Anutu ʒéwelec mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ʒamanʒiŋna Anutu, yomuhuc ʒézua; Némac niŋac nuac eluŋ guzac? Némac niŋac haʒéc hécnanéŋ helanʒi néŋgic ewa biric wamma keŋha waŋanʒua me? ");
INSERT INTO kgf_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Sounéŋ sicna nézac ésécnec haʒéchécna eneŋ ʒébiri qébiri wannémma Anutuga imi dimia? ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Kekec uŋana, némac niŋac kucmama wamma, némac niŋac qerinaiguc siroŋ qaroŋ wamma kecʒaŋ? Gi imi Anutuac niŋkumu wambésémaŋ. Ni imi kileŋ kic tanecna meyac néŋanʒac Anutu i mepési mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Anutu ni niŋgési némma, baec yanda eega ménda héigéŋanʒu ionac muru, acna imi héipuc wannémma meselima, ikoc ic, héna ac logilogi ic ionac murunec ni metecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","Gi imi Anutu nuac hoc baŋecna kecmaguc némac niŋac ni héŋacna mena haʒéchécna ieneŋ helanʒi néŋgic ewa biric wamma keŋha waŋanʒua? ");
INSERT INTO kgf_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Guac asac mararaŋga ʒéma acga héla mélina hama ni qindiŋi némma nuagicma kemma guac baec boŋa téréya ʒéma haliga téréya imuaru nopocmac. ");
INSERT INTO kgf_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Imuac mia ni Anutuac ʒaki téréyaiguc keremma, nuac Anutu, ʒézé ségiségina, nuac ewa hiawac buŋa, guac muru harémaŋ. Anutu, Anutuna, ni waŋgoŋna hésiaguc imi qema gi mepésigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Kekec uŋana, némac niŋac kuc mama wamma némac niŋac qerinaiguc waiʒalaŋ numa kecʒaŋ? Gi imi Anutuac niŋkumu wambésémaŋ. Ni imi néwéc kic tanecna meyac néŋanʒac Anutu i mepési mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","(Legic galeŋawac; Korawac ɋelihéra ionac legic, niŋgic hiŋgac hiŋgara.) Anutu geŋ becnec yanda hécnina ionac naléiguc haka silic wannec imuac suruc imi nénézégic gezacninanéŋ niŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Gi imi baera baera hicŋisai wamma kecgic imi méraganéŋ nesi énécmina keŋgic, yanda hécnina imuaru ic hésa ésécnec himic énécminec. Hicŋisaia hicŋisaiya tosara imi yéwéri mihicŋi énécmima, yanda hécnina imi méndéŋ énécmigic baecgina séc kemma késagic ");
INSERT INTO kgf_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Ieneŋ souginanéŋ baec imi ménda késagic. Eŋaŋ méraginanéŋ yaréguc ménda onogicgic, néŋ geŋ mia ewa hia niŋénécmima hénia imuac niŋac guac méraga ʒéma huaga ʒéma kic tanecgawac asac mararaŋanéŋ imuhuc waŋ énécminec. ");
INSERT INTO kgf_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Anutu imi nuac ic kewuna, imuac Yakoboac niŋac wamma yaréiguc onogicdacmu ʒéma ʒétecgénec. ");
INSERT INTO kgf_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Nini guac muru héima namma haʒéchécnina helanʒi énécmima nunuwiŋ ʒé yacgic séc guac qacganéŋ tidacgé énécmianʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Ni imi tewinawac ménda héima nammaŋ. Sou acguc hia ménda metecgé némmac. ");
INSERT INTO kgf_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Gi sac haʒéchécna ionac murunec aŋgéŋnina tinénécmima méʒétiti waŋ nénécmianʒu imi onac gamu qeqe mihicŋi énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Nini kaiwe herec Anutuac niŋac ʒézé ségiségi wanʒiŋ. Nini Anutuac qara hémbénaŋa ewa hia ac wammiwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Kileŋdac deguc imi geŋ mia héŋacnina mema gamuiguc memama waŋ nénécmima téŋgiŋ ic hécnina iniguc momacnec ménda keŋha waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Geŋ imuhuc wanna nini haʒéchécnina wéséginaiguc liliŋgéma néŋgac énécmini, haʒéc waŋ nénécmianʒu imi eneŋ eŋaŋ siŋginawac nunuma iwawainina nonagicdacʒu. ");
INSERT INTO kgf_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Geŋ mia nini rama qeqeyawac buŋa ésécnec nonopocna, baera baera héndéŋ qéndéŋ rouc wamma kecʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Geŋ ic embachécga boŋtegic hai énécmina megic, néŋ imuac boŋa méŋ ménda géŋgic mezaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Geŋ imi lelec lelec tacyachéra ionac méraginaiguc nonopocna gamu mema kecni lelecgéma nanʒu imi eneŋ ʒédesi waŋ nénécmima isocfagociguc nonopocanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Geŋ baera baera ionac sucginaiguc gamu mamasuŋac nonopocna kuaginaiguc eŋanʒiŋ. Waŋu sucginaiguc oruc héinénéc mimiawac buŋa imuac sésécya wamma kecʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Séwi eŋeŋ wamma ac waŋ némma ʒébiri qébiri waŋ nénʒu ionac niŋac ʒéma haʒéchécna tasé meleŋ némbiŋ ʒé wanʒu imi onac niŋac, isocfagocnanéŋ kaiwe herec wésénaiguc henéŋu gamunanéŋ musuna hoturu nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Haka silic imuhucya mocʒoŋ hicŋi nénécmiyec, néŋ guac eluŋ ménda nunuyunec guac sisipac ac imi ménda logianʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Ewa qerininanéŋ héŋacga ménda mema liliŋgéyec. Waŋu keŋkeŋ haha ninaiguc imi guac héna imi ménda waiyiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Geŋ imi haséŋ kazuac baec kisiaiguc héʒéʒa nénécmima humucac tunumaŋnéŋ hoturu nénécmizaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Nini Anutuac qara eluŋ nunuyeciguc me méranina ic enia ionac anutu hécgina ionac muru sulu méraŋ waŋiŋiguc imi ");
INSERT INTO kgf_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Anutu inéŋ ewa qerininaiguc niniŋ saŋa hezac imi nindacʒac, imuac niŋac hénia imi hia menʒamma mihicŋiwacnec. ");
INSERT INTO kgf_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Nini kaiwe herec guac niŋac humuciguc nonopocgic kecanʒiŋ. Waŋu rama qehumumiawac buŋa ésécnec waŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Miŋ Kewu gi yacna, némac niŋac gau hekecʒaŋ? Yacma naŋna. Nini hémbénaŋa héŋacnina ménda mewésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Némac niŋac kic tanecga musaŋgé nénécmima ʒérabéranina ʒéma helanʒi nénécmimia imuac eluŋ guyu kecʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Kekec uŋanina imi baec gizoŋiguc mama héima hezac. Séwinina imi baeciguc mékétama hezac. ");
INSERT INTO kgf_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Gi yacma méra nénécmiwésémaŋ. Guac goi héihéigawac niŋac wamma nini boŋ hérénina menénéc mina. ");
INSERT INTO kgf_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","(Legic galeŋawac; Korawac ɋeli méŋnéŋ legic ʒéra niŋu hiŋgac hiŋgara yomi oyec. Sosannim waŋgoŋ hésiaguc. Ic kewuac kikiya mema siŋ nimmima legic yomi héigic.) Ewa qerina igucnec ac hiabianéŋ kuaya qema mayu ic kewuac ʒéareŋgéyiac hezac imuac ʒémaŋ. Ezelaŋna imi kiwi oo ic qacguc méŋac kirifi ésécnec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Ic kewu gi imi baec ic ionac naŋhécgina mocʒoŋ onogicma hiabia soroc wanʒaŋ. Waŋu ewa hia acnéŋ kuaga igucnec qocgéma maanʒac. Imuac Anutunéŋ nalé séc gi mériaŋ mihicŋi géŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Kuc miŋina gi, souga ʒikina hénaga kembaŋaiguc hiŋgaru, ic kewuac asac mararaŋ ʒéma qac buŋa séwi usu ésécnec héina. ");
INSERT INTO kgf_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Ic kewu gi, ac héla ʒéma gum bénʒénʒéŋ ʒéma haka solaŋawac wamma edamugaguc becosic qahaiguc tacma kemma yaréiguc onogicbésémaŋ. Guac méra héiganéŋ gi haka welic welicgia kugémmac. ");
INSERT INTO kgf_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Ic kewu, guac ʒakoŋganéŋ ʒéra qizilic, guac haʒéchécga ionac wéiwécgina néʒéŋgéma keremmac. Ic embac momac yanda guac wéségaiguc simiŋ héigémmu. ");
INSERT INTO kgf_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Anutu guac tatacga edamuyaguc imi hémbénaŋa, baec héŋgaleŋ wawaŋawac ic kewu ɋarucganéŋ héna ac dindiŋanec meselimac. ");
INSERT INTO kgf_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Gi imi haka solaŋawac siŋa nimma haka biriawac méʒéga tianʒac. Imuac Anutu, ic kewu guac Anutunéŋ ʒézé ségiségiac halécnéŋ météré gémma guac qocgégémma meyac géŋu alahécga onogicʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Guac séwi usuga imi mocʒoŋ hémbénaŋa guac hiabia, ʒiniŋ kiʒubera saŋkara imuac héméŋa héimimia waŋu elefante yaŋac ʒuŋanéŋ memeya guac ama kewuya igucnec gita kulele qacma mehiaru géŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Guac iniŋhécga eeginaguc ionac sucginaiguc imi baera baera ic kewu ionac bérac hécginanéŋ kecʒu. Guac iniŋga qéʒianéŋ Ofiri baecac golinéŋ meʒeric amuma guac méra héigaiguc nanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Béracna, gezac qema niŋna, gi geŋga ic embachécga ʒéma maŋgocgawac ama areŋa yanda imuac eluŋ gumac. ");
INSERT INTO kgf_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","Imuhuc wanna ic kewunéŋ guac tanec héŋ sorocya imuac ewa siŋsiŋ waŋgémmac. Inéŋ mia guac miŋga wanʒac imuac sicgé miwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Ic kewu guac imi Tirowac béraranéŋ sese eeyaguc haigémmac. Waŋu imuac ic embac ʒuŋa masapu ginaguc imi eneŋ ewa hia waŋ énécmimac niŋac huluŋga késama yaiʒézé ac waŋgémmu. ");
INSERT INTO kgf_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Guac béracganéŋ ʒuŋa masapuyaguc kecmac. Iwac séwi usuya imi golinéŋ biloŋgéma memeya. ");
INSERT INTO kgf_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Béracga séwi usu kiwiyaguc imi wagiru guac muru hamac. Alahéra embac seraŋa imi eneŋ momacnec onagiru hamu. ");
INSERT INTO kgf_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Waŋu onagiru ségiségi wamma ewa hia nimma ama kewuyaiguc keremmu. ");
INSERT INTO kgf_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Guac naŋhécga ieneŋ guac yandahécga mératécgina mema naŋgic geŋ imi baera baera imuac baec galeŋ buŋa onopocbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Ni waŋ énécmiwa ic kewu guac qacga hicŋisaiya hicŋisaiya niŋɋelimu. Imuac baec séc ic embac ieneŋ ic kewu gi hémbénaŋa mepési gémmu. ");
INSERT INTO kgf_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","(Legic galeŋawac; Korawac ɋelihéra ionac legic, Alamot legic imuac ewaiguc héihéiya.) Anutu imi saŋgi saŋginina ʒéma kucnina. Méra nénéŋnina soroc yéwéri qeriaiguc ha nénécmimia. ");
INSERT INTO kgf_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Imuac baecnéŋ meleŋu baec boŋanéŋ qekeŋ qeha wamma konduŋiguc hiŋgacmaciguc me ");
INSERT INTO kgf_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","konduŋ dokunéŋ qac silacma yacma sépéc sépéra loŋu baec boŋanéŋ sicsuc wamma hirimaciguc imi ni kileŋ bac yandi yandi ménda wammaŋ. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Imuac doku téfara imi téma séra sasala wamma eŋeŋa miŋina Anutuac ama areŋa yanda, ocmuŋ téréya imi ségiségi mihicŋi mianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Anutunéŋ ama areŋa yanda imuac suraiguc keru ama areŋa yanda imi seligima ménda hirimac. Waŋu ama giaŋimac imuaru Anutunéŋ méra mimac. ");
INSERT INTO kgf_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Baera baera qeweloŋ qegic héŋgaleŋ ama areŋa yanda imuac miŋina eneŋ ʒénéŋgina hirizac. Waŋu inéŋ ac ʒéyu baecnéŋ pépélima mazac. ");
INSERT INTO kgf_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋa imuac miŋina Yawenéŋ niniguc momacnec kecʒac. Yakoboac Anutu iminéŋ neŋaŋ hoc baŋec eŋeŋa wanʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Hama Yaweac wawaŋ meme imi hémmu. Inéŋ baec meleŋu kérasizac. ");
INSERT INTO kgf_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Waŋu inéŋ baec tetecgia séc yaré metecgéma tewigina kuma luacgina héʒéŋgéma becosicac karisi imi gericnéŋ odarec. ");
INSERT INTO kgf_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Ʒéyecnéŋ gi imi bénʒéŋ kecma ni Anutu wanʒua imi héŋ tegicbésémaŋ. Ni baera baera ʒéma baec séc ic embac ionac sucginaiguc meyac nénéŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Ic téŋgiŋa tauseŋa tauseŋa ionac Yawenéŋ niniguc kecʒac. Yakoboac Anutu imi neŋaŋ hoc baŋec eŋeŋa waŋanʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","(Legic galeŋawac; Korawac ɋelihéra ionac legic ʒéra.) Ic embac momac yanda ini méragina qema ewa ségiségiyaguc qacma Anutu mepésimu. ");
INSERT INTO kgf_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Eŋeŋa miŋina Yawenéŋ kuc buŋa eeyaguc kecma baec séc ic embac ionac ic kewu waŋ énécmima kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Yawenéŋ baec séc ic embac momac yanda imi nonac muru onopocma, baera baera ic embac imi weleŋ qenénécmimu niŋac hénanina duandiaiguc onoporec. ");
INSERT INTO kgf_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Neŋaŋ niŋac wamma mératécac baec imi gésima aŋgé tiyec. Imi mia siŋ niŋmianʒac Yakobo iwac ʒézé ségiségiyawac buŋa wanʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Anutu ségiségi legic héimini eŋanʒac. Tomuŋ hihini qacma eŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Mepésimigic, Anutu mepésimigic, mepésimigic, ic kewunina mepésimigic. ");
INSERT INTO kgf_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Hénia imi yomuhuc; Anutunéŋ baec ic embac momac yanda neŋaŋ ic kewu kecʒac. Legic ʒéra niŋtegic qiŋtegicyaguc mepésimimu. ");
INSERT INTO kgf_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Anutunéŋ baera baera inicgaleŋ wamma ic kewu tatac téréyaiguc tacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Saiwa baec séc hezac imi mocʒoŋ Yaweac buŋa. Inéŋ eŋeŋa miŋina wanʒac. Imuac mia baera baera imuac baec galeŋhéra, Abarahamac Anutu iwac ic embachéra wamma tocgogic. ");
INSERT INTO kgf_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","(Korawac ɋelihéra ionac legic ʒéma legic ʒéra.) Yawe imi kuneŋ yanda, Anutuninawac ama areŋa yanda demiŋ seliaguc, baec boŋa téréya imuaru i kuneŋ yanda mepési mimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Zion baec boŋa, ic kewu yandawac ama areŋa yanda, baec waŋgoŋa Not iguc nanʒac imi nanaŋa eŋeŋa ʒéma héŋ sorocya. Waŋu baec séc ic embac ieneŋ imuac ʒézé ségiségi wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Ic kewuac ama areŋa yanda demiŋ seliaguc imuac qeria séc Anutunéŋ kecʒac. Kecma eŋeyaoc imi aŋgéŋ tinénéc mimiawac neuŋ kiropo wanʒac imi ʒéauzac. ");
INSERT INTO kgf_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Ninʒu, imuaru ic kewu eneŋ aʒoroma momacnec ototoŋ qema keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Ieneŋ ama areŋa yanda imi hémma aurima bac yanidi yandi wamma néŋgacgic. ");
INSERT INTO kgf_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Waŋu ʒénéŋ hirihirinéŋ énépésiyu embacnéŋ aʒi kiyu merac mihicŋianʒac ésécnec geriwanéŋ kuneŋ yanda onoyec. ");
INSERT INTO kgf_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Gi imi luhuc Is igucnec hahayanéŋ Tarasisiac ʒéic imi mocʒoŋ qéséŋdacnec. ");
INSERT INTO kgf_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Gezac ninanéŋ niŋiŋ ésécnec, téŋgiŋ ic tauseŋa tauseŋa miŋina Yawe iwac ama areŋa yanda demiŋ seliayaguc, neŋaŋ Anutuac ama areŋa yanda demiŋ seliayaguc imuaru kicninanéŋ héŋiŋ. Anutunéŋ ama areŋa yanda imi hémbénaŋa meselimimac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Anutu, nini guac ocmuŋ téréya imuac suraiguc guac goi héihéigawac niŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Anutu guac qacga ésécnec mepé qepésiga imi acguc baec tetecgia kereŋdacʒac. Waŋu guac méra héigaiguc imi haka solaŋanéŋ sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Guac ʒégésigési niŋac Zion baec boŋanéŋ ségiségi wanʒac. Yuda baecac ama areŋa kuneŋ kuneŋ séc imi eneŋ ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Ini imi Zion baec boŋa imi baec héna tima kereŋdacma lelecgéma kemma awiawi ama horua imuac ʒaŋgégina olommu. ");
INSERT INTO kgf_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","Demiŋ seli imuac tanera héŋyacgéma ic kewuac ama imi mocʒoŋ héndacma énézégic biaŋ hicŋisaia hicŋisaia hema kecmac imi suruc imi acguc hema kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","Anutu imi hémbénaŋa neŋaŋ Anutu kecmac. Qindiŋi nénécmimacnec keru nalé tetecgia hamac. ");
INSERT INTO kgf_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","(Legic galeŋawac; Korawac ɋelihéra ionac legic ʒéra.) Ic embac momac yanda ini gezac qema niŋgic. Gezacgina nuac muru haima niŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Ic eŋeŋa me mamaya, ic ʒuŋa masapuyaguc me ic maqeqeya ini mocʒoŋ niŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Kuananéŋ niŋtegic qiŋtegic ac ʒéma ewananéŋ hénia héiɋelima nimmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Ni qeqaiŋ ac imuac gezacna haima gita kulele qema legiciguc haima nuac ɋelumbec ac imi measarimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","6","Ic tosara imi iwawai kindindiŋ he énécmimia ʒéma saméŋ bipiyaguc imuac héima namma séwi eŋeŋ waŋanʒu, haʒéchécna imuhucya ionac haka ɋariŋ ɋariŋgianéŋ méndac némma lelecgé némmac nalé imuaru ni némac niŋ bac yandi yandi wammaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Ic méŋnéŋ méŋ dac munaya méŋac kekecya boŋ héré waŋ mimacac séc qahac. Waŋu iwac niŋ wamma Anutuac muru mulu memeac soukiwa méŋ haimacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Hénia imi yomuhuc; Kekec uŋawac mulu meme imi eeyaguc wanʒac. Soukiwanéŋ hémbénaŋa boŋ mewiŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","Houhouya ménda mihicŋi mima hémbénaŋa kecmacac niŋ méra mimiawac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Méŋnéŋ méŋ hémma hénia yomi niŋtegicmac. Niŋtegic qiŋtegic ic imi humumu, waŋu ic qelaŋa ʒéma ic ʒampaliliŋa imi momacnec humuqai wandacmu. Humugic iwawai saméŋ bipiyaguc he énécmimia imi ic méŋnéŋ késaanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Waŋu qeriginanéŋ niŋgic amagina imi hémbénaŋa heyu baec tacyac waŋanʒu imi hicŋisaiya hicŋisaiya hema emma kecmac tanec waŋu baec imi qac waségina haimima qacanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Baec ic imi eeginagucnéŋ hémbénaŋa ménda kecanʒu. Yaŋqesi ésécnec humuanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Haka silicgina imi ionac niniŋ sicsaocya ʒéauanʒac, néŋ ɋelihécgina hahaya ieneŋ ionac ackuaʒéc imuac mepésimu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Rama ésécnec ieneŋ humucac buŋa ʒéénécmimia. Humucnéŋ ionac galeŋgina wammac. Ama giaŋiyu ic solaŋa ionac méra bacginaiguc kecmu. Waŋu ionac haihaka héŋsoroc sorocya imi humuc ac buŋa wandaru ama duŋgina imuhucyanec qahac wandacmac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Néŋ Anutunéŋ ni népésimac. Imuac nuac kekec uŋana imi humuc igucnec boŋhéré menémmac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Ic méŋnéŋ iwawai saméŋ bipiyaguc hemiyu amaya imi yandima eeyaguc waŋu gi kileŋ bac yandi yandi ménda wammiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Ic imi humumac nalé imuaru iwawai méŋ ménda mema kemmac. Qac buŋaya acguc ménda méndacmima kemmac. ");
INSERT INTO kgf_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Inéŋ kekec uŋayaguc kecmanec mepési amuma meʒeric amuyu ic embac eneŋ iwac niŋgic emmac, néŋ ");
INSERT INTO kgf_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","yandahécgina ionac muru liliŋgéma kemma toroqe énécmimac. Waŋu hémbénaŋa kaiwe asaha hémmacac séc qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Eŋeŋa kecma kekecac hénia ménda niŋtegicanʒu imi eneŋ haséŋ yaŋ ésécnec humumu. ");
INSERT INTO kgf_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","(Asafeac legic ʒéra.) Anutu, Yawenéŋ Is igucnec Wes igucgeŋ baec séc ic embac énézéma unuruyec. ");
INSERT INTO kgf_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Zion baec boŋa héŋsoroc sorocya imuarunec Anutunéŋ asaha qetagaliyu kenʒac. ");
INSERT INTO kgf_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Anutunina imi hama hétéŋ qahac ménda kecanʒac. Iwac wésiaiguc imi ɋécgé énécmimiawac geric bélaŋanéŋ naŋu wiliŋ wiliŋ luhucnéŋ lelecgémima humumia qeanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Anutunéŋ ic embachéra ʒégési énécmimaŋ ʒé ou kurumeŋiguc ʒéma baeciguc ʒéau énécmima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Nuac météré ic hécna mulu meme aiiguc niguc sisipac ac megic imi nuac wésénaiguc unuruna hadacmu. ");
INSERT INTO kgf_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Anutu imi ʒégésigési ai miŋina wanʒac. Imuac niŋac kurumeŋnéŋ iwac solaŋa measarimac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Ic embachécna gezac qema niŋgic neŋ énézémaŋ. Israel, neŋ héipuc ac waŋ énécmimaŋ. Ni imi Anutu, eŋaŋ Anutu kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Hofac ooginanéŋ nalé séc wésénaiguc hezacnec imuac mia ni ʒaki téréyawac iwawai niŋac ac ménda waŋ énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Ni imi amaginaiguc burumakao iwa me demiŋgina qeriaiguc noniŋ iwa imi ménda onagicmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Hénia imi yomuhuc; Haséŋiguc wiri yaŋ ʒéma ʒéléŋ boŋa boŋaiguc burumakao hezac imi mocʒoŋ nena. ");
INSERT INTO kgf_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Baec boŋaiguc nei hénia hénia imi mocʒoŋ neŋ kampititi nindacba hezu. Baec kisiaiguc keŋha waŋanʒu imi acguc mocʒoŋ nuac buŋa. ");
INSERT INTO kgf_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Waŋu baec kurumeŋ ʒéma iwawai imuaru sécgéma hezac imi mocʒoŋ nena buŋa, yaka niŋ waŋ némbacnec qesi énécmiwinec. ");
INSERT INTO kgf_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Niŋgic, ni burumakao busia nema noniŋ sawa neanʒua tanec wanʒac me? ");
INSERT INTO kgf_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Ewa hia acginanéŋ hofac oo ésécnec Anutu haimima eŋeŋa miŋina iwac muru ʒézé seli acgina megic imi wamma mema meleŋ midacgic. ");
INSERT INTO kgf_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Waŋu ʒéra béra naléiguc nurugic metecgé énécmiwa qac buŋana meyac némmu. ");
INSERT INTO kgf_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Ic biria ionac imi Anutunéŋ yomuhuc ʒézac; Gi dimuhuc nuac héna ac ʒéau énécmima nuac sisipac ac imi guac kuaga taségaiguc opocna eŋanʒac? ");
INSERT INTO kgf_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Geŋ imi ac pakeŋnawac méʒéga tiyu acna andégaiguc gilina mazac? ");
INSERT INTO kgf_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Kowu nene ic inicma toroqe énécmima kaisero ic iniguc ala waŋamuma ");
INSERT INTO kgf_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","kuaga haka biriawac buŋa qemima ezelaŋga ʒéma ac ikocga dérécgéma ʒéanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Tacma dac munahécga haʒéc ac waŋ énécmima, neŋgocgawac naŋa ʒébiri mianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Gi haka imuhucya waŋanʒaŋ, néŋ ni acna qaiyu kecba, gi imi nuac niŋna gi ésécnec waŋec. Waŋu neŋ gi ac waŋgémma képésicga guac kicgaiguc qererema areŋgéwa hémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Anutuac eluŋ unuyu kecanʒu ini deguc haka yomuac qeriginanéŋ niŋgic, imuhuc ménda wammuiguc imi neŋ ini meric qeric waŋ énécmiwa méŋnéŋ méŋ metecgé énécmimacac séc qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Ewa hia acnéŋ hofac onénʒu imi eneŋ mia nuac qac buŋana meyac néŋanʒu. Waŋu haka silic dindiŋanec wamma meanʒu imi onac mia neŋ Anutuac aŋgéŋ titi énézéwa hémmu. ");
INSERT INTO kgf_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","(Legic galeŋawac; Dawidiac legic, inéŋ Batsebaguc heyicguc Anutuac tiliŋ tiliŋ ic Natannéŋ hayec nalé imuaru legic ʒéra yomi oyec.) O Anutu, goi héihéigawac séhaiguc ewa hiawac waŋnénna. Ewa biricga ʒékéŋanéŋ acqeqe hakana auna qahac waŋu. ");
INSERT INTO kgf_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Hakana ɋariŋ ɋariŋgia imi mocʒoŋnec ʒuacnéndacna, képésicna solaŋanec ʒuacnénna. ");
INSERT INTO kgf_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Nuac képésicna imi nalé séc wésénaiguc heyu ni ac qeqe hakana niŋtegicanʒua, imuac mia imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ni guac, guacnec sac, képésic wamma, guac kicgaiguc haka biria waŋi. Imuac niŋac acga ʒéna nimba solaŋa wanʒac, ʒégésina nimba dindiŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Hénna! Ni hakana ɋariŋ ɋariŋgiaguc hicŋiyi. Neŋgocnawac héri qeriiguc keri nalé imuaru acguc képésicna qeriaiguc keri. ");
INSERT INTO kgf_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ewa qerinaiguc ac héla hemac niŋac ewa ewa waŋanʒaŋ. Qerinaiguc geŋgaoc niŋtegic qiŋtegic ku némma mihicŋi nénʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Ic hésa haréŋanéŋ ʒuacnénna, ni lalac lalac wammaŋ. Ʒuacnénna ni komboc saŋgeŋa lalac lalac imi ogicma lalac qeqe wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Ʒéhiaru nénna nimma ʒézé ségiségi wammaŋ. Sicna héʒéŋgénec imi ɋelima ségiségi wammac. ");
INSERT INTO kgf_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Képésicnawac musuqeqe imi waima képésicna imi mocʒoŋ auna. ");
INSERT INTO kgf_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Anutu nuac qerinaiguc ewa lalac lalac mihicŋi némma qeri uŋana seligima nanaŋa imuhucyawac meɋeli némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Guac wéséga igucnec ménda nesinénna. Uŋaga téréya ménda nuagicna. ");
INSERT INTO kgf_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Guac aŋgéŋ titiac ʒézé ségiségi imi meɋeli nénna. Wésé polaŋac qeri uŋana qenaŋgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Ni ac qeqe ic ionac guac héna ku énécmiwa, képésic ic ieneŋ guac liliŋgéma hamu. ");
INSERT INTO kgf_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Anutu, aŋgéŋ titiac Anutu, sac naec énécmimiawac képésicna igucnec kératacnec metecgé nénna. Ezelaŋnanéŋ hakaga solaŋawac qacma mepésigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Miŋ Kewu kuana meefina aŋgéma legicga héima ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Gi imi hofac oo niŋac ségiségi ménda waŋanʒaŋ. Imuhuc wambaŋnec bec hofac ogémbinec. Gi imi hofac oo imuac ewa hia ménda niŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Hofac oo Anutunéŋ niŋkumuanʒac imi ewa biric nimma kekec. Anutu gi imi qerinéŋ ewa biric wamma képésic niŋac ʒésiac wawaŋa imi mematiti ménda waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Guac hiagawac Zion mehiaruma Yerusalemac demiŋa imi meyacgéna. ");
INSERT INTO kgf_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Nalé imuaru imi gi mulu solaŋa ʒéma hofac oo solaŋa ʒéma hofac oo howiawac ségiségi wanna ieneŋ burumakao iwa hofac ogémmu. ");
INSERT INTO kgf_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","(Dawidiac Héŋgésigésiac legic ʒéra, Edom ic Doeknéŋ ic kewu Sauloac amaiguc hama Dawidinéŋ Ahimelekac amaiguc hayec ʒéma ézéyec nalé imuaru oyec.) Kaiʒiliweŋ ic gi, dimuhuc haka biria niŋareŋgéma imuac ʒézé ségiségi wanʒaŋ? Anutuac goi héihéianéŋ hémbénaŋa heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ezelaŋganéŋ haka biria téŋgéŋ ʒéareŋgéma sou ʒéra ésécnec ikoc waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Gi imi haka hiabia imuac niŋna mayu haka biriawac niŋna eŋu ac solaŋa waima ac ikorawac siŋa niŋanʒaŋ. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Ezelaŋ ikora miŋina gi imi ac ɋécgé énécmimia imuhucyawac siŋa niŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Imuac Anutunéŋ gi hémbénaŋa mebiri gémma gépésima guac ama igucnec héréma baec tacyac waŋanʒaŋ imuacnec hérégéŋu gété ʒaligaguc éréwésémaŋ. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Ic solaŋa eneŋ haka imi hémma bac yandi yandi wamma ic imuac ʒédesi wammima yomuhuc ʒému; ");
INSERT INTO kgf_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Ic imi Anutuac nuac saŋgi saŋginawac baŋec imuhuc ménda ʒénimma hinacyawac héima namma eŋeya haka birianéŋ meseli amuyec. ");
INSERT INTO kgf_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Néŋ ni imi oliwa ic téŋgiŋa Anutuac amaiguc nanʒac ésécnec Anutuac goi héihéiyaiguc hémbénaŋa héima nammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Ni imi haka silic wamma menec imuac wamma ewa hia ac gézémaŋ. Waŋu guac qacgaiguc héima nammaŋ. Qacga imi hiabia imuac niŋac météré ichécga ionac kicginaiguc imuac mambéc kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","(Legic galeŋawac; Dawidiac legic ʒéra niŋu hiŋgac hiŋgara, Mahalat legic imuac ewaiguc héihéiya.) Ic qelaŋ imi ewa qerianéŋ ʒéma Anutu ménda kecʒac ʒéanʒac. Ic imuhucya eneŋ houdacma haka ewa loloŋawac waŋanʒu. Imuac haka hiabiawac waŋanʒac imi méŋ ménda kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Anutunéŋ ic niŋtegic qiŋtegicyaguc, Anutuac hochoc ai meanʒac méŋ tacʒac me qahac imi hémmaŋ ʒé, kurumeŋ igucnec baec icac naŋhéra neŋaŋ niŋac kic hiyu mazac. ");
INSERT INTO kgf_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Héŋu momac yanda andé andé kemma momacnec biridacgic, imuac haka hiabia waŋanʒac méŋ ménda kerec, qahac téŋgéŋ waŋu horec. ");
INSERT INTO kgf_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Képésic wamma saméŋ neanʒu ésécnec nuac ic embachécna neénécmima Anutugina ni ménda nuruanʒu imi eneŋ niniŋgina qahac kecanʒu me? ");
INSERT INTO kgf_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Onac yaré qewiŋ ʒé areŋgéma nanʒu imi onac sicgina imi Anutunéŋ héndéŋ énécmiyec, imuac niŋac ieneŋ ʒénéŋ hirihiriac iwawai méŋ ménda heyec imuaru ʒénéŋ hirihiri yanda waŋgic. Anutunéŋ ionac héŋacgina meyec imuac niŋac gi gamu qeqe mihicŋi énécminec. ");
INSERT INTO kgf_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Israelac aŋgéŋ titi miŋinanéŋ Zion igucnec hamac. Anutunéŋ ic embachéra hésa ɋatégina igucnec onagiru liliŋgému nalé imuaru Yakobonéŋ ʒézé ségiségi waŋu, Israelnéŋ ewa hia nimmac ");
INSERT INTO kgf_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","(Legic galeŋawac; Dawidiac legic ʒéra niŋu hiŋgac hiŋgara, gita kuleleginaguc, Ʒip ic eneŋ Sauloac hama ézéma, Dawidinéŋ sucninaiguc ménda saŋgima tacʒac? ʒégic nalé imuaru oyec.) Yawe qacganéŋ aŋgéŋna tima kucganéŋ waŋ nénna solaŋanimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Anutu ʒéwelecna nimma kuana igucnec acna gezac qema niŋna. ");
INSERT INTO kgf_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Ic enianéŋ yacma nuwiŋ ʒé wanʒu. Helanʒi tilanʒi wannénʒu ieneŋ nuac kekec uŋanawac hochoc wanʒu, imuac niŋac guruzua. Ieneŋ imi Anutuac ewa éréhéc ménda waŋanʒu. Ohec ");
INSERT INTO kgf_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Héŋgic! Anutu imi nuac héipuc icna kecʒac, Miŋ Kewuna imi kekec uŋana qenaŋgé némma kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Inéŋ haʒéchécna bakia biria meénécmimac. Miŋ kewu, hakaga héla iminéŋ unuhumuna. ");
INSERT INTO kgf_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","7","Geŋ ʒérabéra hénia hénia igucnec metecgé néŋna haʒéchécna ieneŋ bakia megic kicnanéŋ iniri, imuac niŋac ni ewa siŋnawac sese haigémmaŋ. Qacga imi hiabia imuac niŋac, Yawe guac qacga qacma mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","(Legic galeŋawac; gita kuleleguc héihéiya, Dawidiac legic ʒéra, niŋu hiŋgac hiŋgara.) Anutu ʒéwelecnawac gezac qena. Guruhéhéliwa ménda saŋgiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Gezacga qema acna bakia meleŋ néŋna. Ni niŋ yéwérima waiʒalaŋ wamma ʒésilac mezua. ");
INSERT INTO kgf_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Imi mia haʒéchécna ionac ewa hétéŋ ʒéma ic biria ionac helanʒi nénéŋa niŋac imuhuc waŋanʒua. Ieneŋ yéwéri mihicŋi némma qeri biric wamma niniŋ haʒérawac héwiŋa meanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Qerinaiguc ewa qerina geriwa noyu humucnéŋ hosucgé néŋu ʒénéŋna hirizac. ");
INSERT INTO kgf_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Bac yandi yandi ʒéma ʒénéŋ hirihirinéŋ hicŋinéŋu humucnéŋ tericgé nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Ni yomuhuc ʒézua; Ni kembo nei ésécnec qeŋgaŋna henémbacnec putitima kemma bénʒéŋnec tac hiaruwinec. ");
INSERT INTO kgf_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Lakec putitima kemma baec kéra kérasiaiguc kemma kecbinec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Sasaŋgiaiguc focdac kemma murayo luhuc ʒéma yowaro luhucnéŋ qiʒiʒiŋgé néŋu kecbinec. ");
INSERT INTO kgf_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Ni neŋaŋ ama areŋa yanda neuŋ kiropo seliaguc imuac qeriaiguc kaiʒiliweŋ ʒéma euqeqe hicŋiyu héŋi. Miŋ Kewuna mebiri énécmima acgina héndéŋ énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Ieneŋ siŋi kaiwe neuŋ kiropo seli imuac qahaiguc keŋha waŋgic imuaru haka ɋariŋ ɋariŋgia ʒéma réwéri hicŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Kisikiyoŋ ʒéma helanʒi énécmimia ʒéma ac ikocnéŋ sombeŋ yandagina imi ménda waima kenʒac. ");
INSERT INTO kgf_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Ac geriwaguc wannéŋec imi haʒécna qahac. Haʒécnanéŋ imuhuc waŋ némbacnec hia bisiqatéŋ wammiwinec. Nuac hama séwi eŋeŋ wanʒu imi haʒécna qahac. Haʒécnanéŋ imuhuc wambacnec néŋgacma saŋgibinec. ");
INSERT INTO kgf_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Ic imi mia nuac séc. Waŋu alahécna, alahécna eŋomia qahac, néŋ nekawu qéqéhéréŋ wamma kecaŋic imi mia. ");
INSERT INTO kgf_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Niri nekawu siŋa nimma ʒéemi nimma ic embac tosara iniguc momacnec Anutuac ocmuŋ téréyaiguc eŋeŋ mama waŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Haka biria humumianéŋ ionac sucginaiguc acguc he énécmizac, imuac niŋac waŋ énécmina, humucnéŋ élanzaŋnec ionac muru haénécmiyu ménda humumanec kicsuaŋiguc hiŋgacmu. ");
INSERT INTO kgf_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Ni imi Anutu qachéhéliwa Yawenéŋ aŋgéŋna timac. ");
INSERT INTO kgf_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Siŋiya ʒéma siŋunec ʒéma kaiweiguc ni niŋyéwécnaguc ʒésilacba Yawenéŋ qacsilacna imi niŋnémmac. ");
INSERT INTO kgf_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Sasalanéŋ haʒéc waŋ néŋgic, inéŋ yaré mihicŋi nénéŋa imuacnec luae qema uŋana boŋhéré menéŋec. ");
INSERT INTO kgf_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Becarunec kerecac kecʒac Anutu iminéŋ acna niŋnémmac ohec wahec. Ewagina ménda melemma Anutu eeya ménda héimianʒu imi onac tasia meleŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Ic imi ic tosara luae qema momacnec kecanʒu imi ʒikiʒiki ac logima méria meyacma unuyec. ");
INSERT INTO kgf_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Kua dokuya imi namu haléc ogicma susurac wanʒac, néŋ ewa qeriaiguc imi yaré doŋgéma kecʒac. Ac ʒéanʒac imi mocʒoŋ haléc ogicma bénʒéŋa wanʒac, néŋ imuac héla imi sou bec meyacma nanaŋa ésécnec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Guac yéwécga Yaweac muru hetecgé haina, inéŋ ic solaŋanéŋ hémbénaŋa keŋqe haqe ménda wammac niŋac késaselimac. ");
INSERT INTO kgf_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Anutu ʒéna, ieneŋ humucac baec séséŋiguc hiŋgacmu. Sac naec énécmima ikoc waŋ énécmianʒu imi eneŋ kekec nalégina bakia ménda kecma humudacmu, néŋ ni imi guac muru niŋkinʒéŋna haima kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","(Legic galeŋawac; Yonawac legic Kembo nei lakecaru hétéŋ qahac tatara imuac ewaiguc, Dawidiac legic ʒéra Miktam taneraiguc, Fileset ic eneŋ Gat baeciguc i késagic nalé imuaru oyec.) Anutu, ewa biric waŋ nénna. Ic imi ɋécgé némmaŋ ʒéma kaiwe herec numa helanʒi nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Haʒéc hécnanéŋ kaiwe herec ɋécgé némbiŋ ʒé wanʒu. Waŋu séwi eŋeŋ wamma nuanʒu ionac ʒaŋgégina imi sasala imuac niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Bac yandi yandi wammaŋ nalé imuaru guac muru héima nammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Ni Anutuac muru héima namma ackuaʒécya mepési mimaŋ. Ni Anutuac muru héima nanʒua imuac bac yandi yandi ménda wammaŋ. Baec icnéŋ némac haka hia waŋ némmu? ");
INSERT INTO kgf_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Ieneŋ kaiwe herec acna megic ɋariŋ ɋariŋgia waŋu nuac niŋgic niniŋgina areŋareŋgia imi mocʒoŋ biria waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Ieneŋ qeriiguc ésé ésé waŋ énécmiyu euqeqe waŋanʒu. Nuac kekecna mebiriwiŋ ʒéma eŋaoc tocgo amuma saŋgima héna titinawac awima kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Ieneŋ haka ɋariŋ ɋariŋgia wamma dimuhuc tasiawac hia qiʒiʒiŋgéma kemmu me? Anutu qeri biric wamma ic embac imi memaénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Néŋgacma lelecgéma keŋha wamba gi yéwécna imi oloŋniŋnec. Nuac kic masi imi guac kiruŋiguc haina hiŋgaru. Haka imi guac kiwiiguc ooyawac hezac imuac oloŋnimbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Ni gi gurumaŋ nalé imuaru haʒéchécna ieneŋ héréamuma kemmu. Anutunéŋ nuac kecʒac imi ni ninʒua. ");
INSERT INTO kgf_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Ni Anutuac muru héima namma ackuaʒéc imi mepésima Yaweguc héima namma ackuaʒécya mepésimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Anutuac muru niŋkinʒéŋna haizua. Imuac ni bac yandi yandi ménda wammaŋ. Baec icnéŋ némac haka hia waŋ némmu? ");
INSERT INTO kgf_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Anutu ni ac ʒéseliyiac hezac. Ac imi meselima ni ewa hiawac sese haigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Geŋ nuac kekec uŋana humuc igucnec metecgé nénnec imuac mia imuhuc ʒézua. Ni Anutu wéségaiguc kekec asahaiguc keŋha wammaŋ niŋac geŋgaoc hénana galeŋgé nénna tisuqisura ménda waŋi, imi gi qahac waŋu méré? ");
INSERT INTO kgf_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","(Legic galeŋawac; Ménda mebiri nénécmina, Dawidiac legic ʒéra Miktam taneraiguc, Saulo inéŋ qemaŋ ʒéyu néŋgacma kemma baŋeciguc saŋgiyec nalé imuaru oyec.) Ewa biric waŋ nénna, Anutuna, kekec uŋananéŋ néŋgacma guac muru saŋgima hezac imuac niŋac, ewa biric waŋ nénna. Ʒéra béranéŋ nogicma kemmac nalé imuac suraiguc séc ni néŋgacma qeŋgaŋgawac amiaiguc hama kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Ni eŋeŋa miŋina Anutu, nuac niŋ wamma iwawai mocʒoŋ meseligianʒac iwac mia qachéhélizua. ");
INSERT INTO kgf_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Inéŋ kurumeŋ igucnec méramma ni ɋécgé némbiŋ ʒé wanʒu ionac murunec metecgé némmac. (Ohec) Anutunéŋ iwac goi héihéi ʒéma haka héla imi waŋ néŋu hicŋinémmac. ");
INSERT INTO kgf_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Ni laion yaŋ hémbaoc wamma ɋécgé énécmianʒu ionac sucginaiguc kecanʒua. Imi mia baec ic mia, néŋ ʒécgina imi luac ʒéma ʒakoŋ ʒéra ésécnec, waŋu ezelaŋgina imi sou ʒéraguc ésécnec. ");
INSERT INTO kgf_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Anutu, meyac génni ou kurumeŋiguc kecbésémaŋ. Guac edamuganéŋ baec séc ic embac ionac qacginaiguc ou meeŋmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Ieneŋ nuac keŋkeŋ hahanaiguc ufic haigic hezac. Imuac qerinanéŋ memamimiawac hezac. Waŋu ieneŋ wésénaiguc baec séséŋ éséma mihicŋigic, néŋ eŋaoc imuaru hiŋgacgic unuyec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Qeri uŋana imi béŋ qema hezac. O Anutu, qeri uŋananéŋ keŋqe haqeya qahac. Ni mepési gémma legic héigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Neŋ giaŋgiaŋa imi mindiwa yacmac. Nuac qeri uŋana gi yacna, gita kulelena iri yaric. ");
INSERT INTO kgf_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Ic embac momac yanda ionac sucginaiguc ewa hia ac gézémaŋ. Baera baera ionac sucginaiguc legic héigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Guac goi héihéiganéŋ imi kurumeŋiguc sécgéma heyu, guac haka héla iminéŋ ou hosusuiguc sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Anutu gi meyac géŋgéŋa wamma ou kurumeŋiguc kecbésémaŋ. Guac edamuganéŋ baera baera ionac qacginaiguc hemac. ");
INSERT INTO kgf_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","(Legic galeŋawac; legic ‘Ménda mebiri nénécmina’ imuac ewaiguc, Dawidiac legic ʒéra Miktam taneraiguc.) Icac naŋhéra ini, ini héna ac solaŋanec ʒéanʒu? Ini hénaoriŋ hécgina keŋkésa hakésaya qahac ʒégési énécmianʒu? ");
INSERT INTO kgf_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Qahacgucnec, ini qeriginaiguc haka biria wamma baeciguc eŋaŋ méraginawac kaiʒiliweŋ imuac yéwéria imi sasala korohémma énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Ic ʒipiliŋ ʒapalaŋa imi neŋgoc hériiguc kecmanec kemma rouc waŋgicac hicŋima imuarunec bec qiʒiʒiŋgéma kemma ikoc ac ʒéma kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Ionac sacmasi biria imi mokoleŋac sac masi biria ésécnec. Waŋu ieneŋ gezac héŋ qaté mokoleŋ gezacgina héʒicgé énécmimia ésécnec waŋu ");
INSERT INTO kgf_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","ʒina icnéŋ ac waŋu ménda niŋanʒac. Gété manirawac kuhanéŋ haréŋa waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Anutu ionac kuaginaiguc ʒécgina imi kuna. Laion sac ɋeli ʒérawac eriŋa imi kuna mayu. ");
INSERT INTO kgf_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Waiénécmina ieneŋ doku téfara focfoc keŋanʒac ésécnec keŋ qahac wammu. Ʒakoŋa muigic ʒéŋgéanʒac ésécnec ʒéŋgédacmu. ");
INSERT INTO kgf_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","Waŋénécmina, gulucnéŋ keŋkecma loloma humuanʒu ésécnec wammu. Waŋu kokocnéŋ naléya heyunec hicŋima asac mararaŋ ménda hémmanec humuanʒu ésécnec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Ic hésa waiyaguc imuac geric bélaŋanéŋ kuʒi ʒeyu geriwaguc ménda waŋunec nene ɋelikiŋ ʒéma geric bélaŋaguc momacnec luhuc neŋgocyanéŋ mihilaŋgéyu éléŋnec keŋanʒac ésécnec auénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Ic solaŋa ieneŋ ic biria eneŋ bakia megic inicma ségiségi wammu. Ionac saciguc hénagina ʒuacmu. ");
INSERT INTO kgf_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Nalé imuaru ic embac ieneŋ yomuhuc ʒému; Hélacnec ic solaŋa imi tasia hiabia ku énécmianʒac. Hélacnec baeciguc Anutunéŋ ʒégési nénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","(Legic galeŋawac; Dawidiac ‘Ménda mebiri nénna.’ Miktam tanera, Saulonéŋ Dawidi qehumumaŋ ʒé amayawac awima tacmu niŋ énézéyec nalé imuaru oyec.) Anutuna haʒéchécna ionac murunec ni metecgé némma, yacma nuwiŋ ʒé wanʒu ionac muruenc ni ou meyac néŋna. ");
INSERT INTO kgf_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Haka biria waŋanʒu ionac murunec metecgé néŋna. Siŋa nimma sac naec énécmianʒu ionac murunec kekecna aŋgéŋ tina. ");
INSERT INTO kgf_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Ieneŋ nuac kekecna mebiriwiŋ ʒé héima tacma mambécanʒu. Ic kawali eneŋ tocgéma ni nuwiŋ ʒé wanʒu. Yawe, imi mia ac qeqe hakana me képésicna niŋac qahac. ");
INSERT INTO kgf_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Hakana ɋariŋɋariŋgia qahac, néŋ ieneŋ kucnec hama eŋaoc ʒéréŋ qéréŋ wandacʒu. Gi kic ɋeli kecma méra némmaŋ ʒé nuac awima tacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Téŋgiŋ ic miŋina Yawe Anutu, Israelac Anutu, yacma baera baera bakia meleŋ énécmina. Andé qeqe ic biria ionac ewa biric ménda waŋ énécmina. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Ieneŋ ama siŋiyu liliŋgéma hama kazu eneŋ ésécnec qacma ama areŋa yanda séc lelecgéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Kua taséginaiguc sou ʒéraguc heyu Kuaginaiguc ac ʒéraguc géréréc mericma mérénéŋ gezac qema acnina hia nimmac imuhuc ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Yawe geŋ ʒédesi énécmina, baera baera ʒédesi énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Anutu, nuac neuŋ kiropona selia, nuac kuc miŋina, guac kic hihi wamma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Nuac Anutunéŋ goi héihéiyaguc tétécgé némmac. Waŋu haʒéchécna bakia megic nézéyu kicnanéŋ inicmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Gi imi ménda unuhumuna ic embachécna ieneŋ eluŋ unuwac niŋac. Saiwanina Miŋ Kewu, kucganéŋ héndéŋ énécmima memaénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Ezelaŋginawac ac imi kuaginawac képésic wanʒac. Saec ac ʒéma ikoc ac ʒéanʒu imuac niŋac waina séwi eŋeŋ wamma kecgicnec énéc énépésia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Qeri gericganéŋ onona, qahac wammuac séhaiguc onona. Hémma Anutunéŋ Yakoboac ɋelihéra sucginaiguc inicgaleŋ kecʒac imi niŋasarimu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Waŋu ieneŋ ama siŋiyu liliŋgéma hama kazu ésécnec qacma lelecgéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Ieneŋ nene niŋac hocma lelecgégic tomeŋgina ménda qeyu lelecgémanec kecgic ama giaŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Ni imi guac kucga mepésigémma siŋunec guac goi héihéiga meyacma legic héigémmaŋ. Gi imi nuac demiŋ selina baec boŋaiguc nanaŋa. Waŋu ʒérabéra naléiguc saŋgi saŋgina wanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Nuac kucna, ni gi mepésigémmaŋ. Anutu imi neuŋ kiropo selina baec boŋaiguc nanaŋa. Anutu imi ewa biric waŋ néŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","(Legic galeŋawac; ‘Sésépac acac baorac ʒariŋ.’ imuac ewaiguc héihéiya, Dawidiac legic ʒéra Miktam taneraiguc pakeŋ ac waŋ énécmimaŋ ʒé oyec. Dawidinéŋ Aram Naharaim ʒéma Aram Zobaguc yaré wamma yéwéri mihicŋiyecac eŋeya kawali ic Yoapnéŋ yaré ic énépésima liliŋgéma hama Edom ic 12,000 imuac séc baec boŋa wéŋwéŋgia sei heyec imuaru unugic nalé imuaru oyec.) Anutu héŋacnina mema héndéŋ nénécmima qeri biric waŋ nénécminec. Waŋu deguc mehiaru nénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Geŋ wanna baec mimiŋʒalizac, geŋ wanna baecnéŋ tézac. Téma hirizac imuac niŋac toroqema ɋotona. ");
INSERT INTO kgf_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Geŋ imi geŋga ic embachécga nalé yéwéria mihicŋi nénécmizaŋ. Waiŋ tarac turuc mihicŋi nénécmimia gumu nénécmina neyiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Néŋ eega héianʒu ionac filac énécmima énézéna ac hélawac meyacgic eŋec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Goi héihéi waŋ énécmianʒaŋ neŋaŋ metecgé nénécmimaŋ ʒé acnina meleŋ nénécmima méra héiganéŋ metecgé nénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Anutunéŋ ocmuŋ téréyaiguc nénézéyec imuac séciguc; Ni Dawidinéŋ técgéma aria memaŋ. Sikem baec méndémma Sukot baec wéŋwéŋgia imuac sécya olommaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Gileade imi nuac, Manase imi imuhucyanec nuac, Eferaim imi nuac aiŋ opocna, Yuda imi ic kewu ɋarucna. ");
INSERT INTO kgf_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Moabi imi nuac naec naecac doku pakena, Edom baeciguc imi héna usuna giliwa hemac, Fileset baec imi nuac wamma qacmac. ");
INSERT INTO kgf_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Mérénéŋ nuagicma ama neuŋ kiropo seliaguc keremmac? Mérénéŋ Edomoac héna nézéyu hémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Anutu geŋ nini ménda wai nénécmizaŋ me? Anutu gi neŋaŋ téŋgiŋ ic iniguc momacnec ménda kenʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Méra nénécmina haʒéchécnina unuwiŋ. Ic onac aŋgéŋ titi ai imi gorosoŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Imuac nini Anutuac muru héima namma efima kembiŋ. Inéŋ mia haʒéchécnina tidacgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","(Legic galeŋawac; waŋgoŋ hésiaguc qema héihéiya, Dawidiac legic ʒéra.) Anutu nuac qaqacna nimma ʒéwelecnawac gezac haina. ");
INSERT INTO kgf_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ewa qerina imi helanʒi mimia waŋu baec tetecgia igucnec guac qacma héhélizua. Nuagicma hoc yanda ni nogicʒac imuaru keŋ nopocna. ");
INSERT INTO kgf_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Gi imi nuac saŋgi saŋgina, neuŋ kiropona selia haʒéchécna héʒicgé énécmimia. ");
INSERT INTO kgf_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Ni hémbénaŋa guac haliiguc kecmaŋ. Néŋgacma qeŋgaŋgawac amiaiguc hama kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Anutu ʒézé seli acna nimma eega héianʒu ionac ai buŋa imi nuac qenénnec. ");
INSERT INTO kgf_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Ic kewu iwac kekecya imi mehorugina yawuŋa yawuŋa ogicma emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Inéŋ hémbénaŋa Anutuac wésiaiguc ic kewu waŋ énécmima kecmac. Goi héihéiga hémbénaŋa ʒéma hakaga héla ʒéréŋ qéréŋ wamma wammima héŋgaleŋ wammiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Imuhuc wanna ni guac qacga nalé tetecgia qahac mepésima kaiweya kaiweya ʒézé seli acna meselima wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","(Legic galeŋawac; Yédudun tanera méndacma ooya, Dawidiac legic ʒéra.) Qeri uŋananéŋ bénʒéŋnec Anutuacnec sac niŋkumuma kecmaŋ. Nuac aŋgéŋ titi imi iwarunec haanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Inéŋ sac nuac ʒamanʒiŋna, aŋgéŋ titina, demiŋ selina baec boŋa eŋeŋaiguc nanaŋa, imuac ni kuneŋ yanda keŋqe haqe ménda wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Nalé dahecac séc ini ic demiŋ ɋasima nanaŋa ʒéma demiŋ mimiŋʒalia imuhucya ni nuwiŋ ʒé momacnec néfacgé némbiŋ ʒé wanʒu? ");
INSERT INTO kgf_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Ieneŋ dimuhuc wammini ou eŋeŋa igucnec mama qemac ʒéma niŋareŋgéma ac ikoc efima ʒéanʒu. Kuaginanéŋ mériaŋ ac ʒéma qeriginanéŋ saec ac ʒéanʒu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Niŋkumuma kekecac kuha imi Anutu arunec sac haanʒac. Imuac niŋac qeri uŋana gi imi bénʒéŋnec iwacnec sac niŋ kumuma kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Inéŋ sac nuac hoc saiwana ʒéma aŋgéŋ titina ʒéma demiŋ selina baec boŋaiguc nanaŋa, imuac ni keŋqe haqe qahac kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Aŋgéŋ titina ʒéma edamunanéŋ Anutuac muru hezac. Nuac ʒamanʒiŋna selia ʒéma saŋgi saŋgina imi acguc Anutuac muru hezac. ");
INSERT INTO kgf_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Anutunéŋ neŋaŋ saŋgi saŋginina imuac mia, ic embac ini, naléya naléya iwac muru héima namma iwac wésiaiguc ewa qerigina ʒéqolacgégic mayu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Hélacnec baec ic maqeqeya imi héla qahac, ic eŋeŋa acguc ac ikocginaguc, momac yanda eŋaŋ eegina imuac qétéya imi komodia dac, korohénni wéséséac réwéria ménda ogicmac. ");
INSERT INTO kgf_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Hénia qahac hélanʒi énécmimia haka imuhucyawac héima namma iwawai onagicma késagic imuac nimbupuc héla qahac imuhucya ménda wammu. Waŋu hinacgina yandima kuneŋ yanda he énécmizaciguc kileŋ imuac ménda niŋkinʒéŋ wammu. ");
INSERT INTO kgf_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Anutunéŋ hatac éréhécnéŋ méŋ ʒéyu yomuhuc niŋi; Kuc imi Anutuac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","Miŋ Kewu, geŋ icya icya wamma meanʒu séc bakia meleŋ énénécmianʒaŋ imuac niŋac goi héihéi imi acguc guac buŋa. ");
INSERT INTO kgf_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","(Dawidiac legic ʒéra, baec kisiaiguc kerec nalé imuaru oyec.) Anutu, gi imi nuac Anutu, kekec uŋananéŋ mocʒoŋnec guac hochoc wamma baec kéra kérasia, kic giligili mihicŋi nénéŋa imuaru gi niŋ héhéli gémma kecba nuac séwina acguc guac siŋsiŋ waŋ néŋu kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ni guac kucga ʒéma edamuga hémmaŋ ʒé yomuhuc ocmuŋga téréyaiguc kichihi wamma kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Guac goi héihéiganéŋ kekec ogicʒac imuac kua tasénanéŋ mepési gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Imuac kekecnawac séc gi mepési gémma guac qacgaiguc mérana meyacma ʒéwelecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Aŋaroroc ʒéma haléc sic qeriaiguc heheya neanʒu ésécnec nuac qeri uŋananéŋ sécgémimia waŋu kua tasénanéŋ ségiségi wamma gi mepési gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Ni hehe tatacnaiguc gi niŋɋeli gémma siŋiyaiguc kicɋeli kecma qerinanéŋ guac ʒénimmaŋ nalé imuaru imuhuc wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Gi nuac héipucna waŋ nénnec imuac niŋ imuhuc wammaŋ. Ni guac qeŋgaŋgawac amiaiguc ségiségi wamma legic héimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Nuac kekec uŋananéŋ qéhéréŋgaiguc naŋu méra héiganéŋ népési seligianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Kekec uŋana mihicŋima qewiŋ ʒé wanʒu imi eneŋ baec séséŋ hiŋgac hiŋgaraiguc hiŋgacmu. ");
INSERT INTO kgf_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Sounéŋ énériyu haséŋ kazuac neneya wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Néŋ ic kewu inéŋ imi Anutuac ségiségi wammac. Waŋu guac ʒéseligéŋgic séc ʒézé bipi ac waŋgémmu, néŋ ac ikoc ʒéanʒu ionac kuagina imi wéʒéc qeénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Anutu, niŋyéwécnawac ewa hétéŋ imi nimma haʒéc hécnawac bac yandi yandi yandi igucnec metecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Gi ni musaŋgé némma ic biria ionac niŋareŋ areŋgia saŋa imuacnec ʒéma tilic qilic ic ionac qeweloŋ igucnec ni musaŋgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Ieneŋ ezelaŋginawac ʒéra imi sou ésécnec qericma acgina howura ʒakoŋ ésécnecnéŋ muinéŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Sasaŋgiaiguc ic solaŋa unuwiŋ ʒé bac yandi yandi ménda wamma éléŋnec unuanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Ieneŋ haka biria wambiŋ ʒé niŋkumugic heheya imuac selianec késa aŋgétima sasaŋgiaiguc bétac haiwiŋ ʒé eminimma mérénéŋ hia ninicmac ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Héna ac logilogiac haka imuac hohoc ai mema neŋaŋ héna diwi qiwiliŋa qacguc niŋareŋ gédacʒiŋ ʒéanʒu. Hélacnec eŋac eŋac ionac ewa siŋgina ʒéma ewa qerigina imi hiŋgac hiŋgara. ");
INSERT INTO kgf_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Néŋ Anutunéŋ ini unumac. Éléŋnec ʒakoŋnéŋ unuyu biridacmu. ");
INSERT INTO kgf_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Eŋaŋ ezelaŋ ginanéŋ waŋu qonʒontoŋ géma maunuyu birianʒu. Waŋu inicanʒu séc orucgina gilianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Ic momac yanda bac yandi yandi wamma Anutuac ai ʒéauma haka silicya qerianéŋ hiŋgac hiŋgarawac nimmu. ");
INSERT INTO kgf_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Ic solaŋa eneŋ Yaweac niŋac wamma ʒézé ségiségi wamma néŋgacma iwac muru kemmu. Qeri solaŋ kecʒu séc ségéra herec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","(Legic galeŋawac; Dawidiac legic ʒéra, ‘Legic’.) Anutu, mepé qepésiac legicnéŋ Zioniguc guac mambéc hezac. Ic eneŋ ʒézé seli acgina meselima wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Anutu gi ʒéwelecnina niŋanʒaŋ. Ic séwiginaguc mocʒoŋ guac muru hamu. ");
INSERT INTO kgf_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Képésicnéŋ nonogicʒac. Gi képésicnina aunénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Ic embac geŋ unuruna hosucgaiguc hama kecanʒu imi eneŋ ségiségi ginaguc. Guac amaga, guac ocmuŋ téréyawac tanec héŋsoroc sorocgia imi héŋni ʒézé ségiséginéŋ sécgé nénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Miŋ Kewu geŋ mia haka solaŋa méndacma haka silicga welic welicgianéŋ acnina meleŋ nénécmianʒaŋ. Neŋaŋ aŋgéŋ titinina Anutu, baec tetecgia ʒéma konduŋ lakec arunecnéŋ guac muru héima nammuac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Gi kucga imi rikuŋ ésécnec ʒikima kucganéŋ baec boŋa miyacgénec. ");
INSERT INTO kgf_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Konduŋac hétéŋa ʒéma temboŋawac hétéŋa ʒéma ic embac ionac qeweloŋ yanda imi mebélac géanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Baec tetecgiaiguc kecanʒu imi eneŋ guac asé kiwiga méréra niŋac bac yandi yandi waŋanʒu. Wainénécmina ama giaŋgiaŋawac naguya ʒéma ama mariyawac naguyaiguc séc ic embac kecʒu momac yanda neŋaŋ ségiségi legic héiwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Baec goiya héima doku haimima halécya mihicŋima Anutuac doku téfaraiguc doku tina sécgéanʒac. Baec imuhuc mindiŋima nene yaka mihicŋi nénécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Geŋ mia ai takareŋiguc doku sécya haimima baec boŋa héimindiŋima kia silic silicyanéŋ héiyu qérawia qeanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ai yawuŋnina imi guac ewa hiawac mériaŋnéŋ ic kewuac opoc héimina, tikeŋ tiha waŋanʒaŋ baec imuac séc halécyaguc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Baec kisia, baec lulucyaguc imi acguc halécyaguc waŋu, baec boŋa komoc komocnéŋ ʒézé ségiségiac séwi usuginaguc wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Baec lulucyaiguc ramanéŋ hoturu mima hezac. Baec wéŋwéŋgia kondoŋaiguc imi padinéŋ hoturuma hezac. Imuac momac yanda ieneŋ ségiségi wamma qacma legic héizu. ");
INSERT INTO kgf_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","(Legic galeŋawac; Legic méŋac legic ʒéra.) Baera baera Anutu ʒézé ségiségi wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Qac buŋayawac edamuya imuac legic héimima mepé qepési edamuyaguc héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Anutu yomuhuc ézégic; Yei guac aiga imi eeyaguc yéwéria. Guac kucga yanda niŋac haʒéchécga eneŋ méra bacgaiguc kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Waŋu baera baera eneŋ simiŋ héima legic héigémma guac qacga mepési génʒu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Hama haka silic Anutunéŋ wamma meyec imi héŋgic. Baec ic neŋaŋ niŋac wamma meyec imi eeyaguc yéwéria. ");
INSERT INTO kgf_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Anutunéŋ konduŋ meleŋu baec waŋec. Waŋu doku téfara qeriru baec héna doku néwéc hagic. Hama iwac niŋac ségiségi waŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Inéŋ kuhanéŋ hémbénaŋa ninicgaleŋ waŋ nénécmima kicyanéŋ baera baera héŋsosolianʒac. Imuac ac qeqe ic ini séwi eŋeŋ ménda wammu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Ic embac momac yanda ini Anutu mepésima legic héimigic. Ewa hétéŋ iminéŋ héiyu nimmac. ");
INSERT INTO kgf_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Inéŋ kekec uŋanina galeŋgé nénécmiyu kekecninaguc kecanʒiŋ. Waŋu inéŋ naŋgé nénécmiyu hénaninanéŋ tisuqisura ménda waŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Anutu gi imi manam batuc waŋ nénécmima siliwa oanʒu ésécnec meʒeric nénécminec. ");
INSERT INTO kgf_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Imuhuc wamma nonagicma uficiguc nonopocma yéwéri qacninaiguc hai nénécminec. ");
INSERT INTO kgf_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Waŋu wai énécmina ic embac ieneŋ orucnina tidacgéma keŋha waŋgic. Nini geric ʒéma doku yanda qericma hani geŋ mia héré nénécmima baec halécyaguc imuhucgeŋ nonopocnec. ");
INSERT INTO kgf_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Ni hofac ooac buŋa mema amaga téréyaiguc emma ʒézé seli acnawac tasia imi meleŋ gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Imi mia kua tasénanéŋ ʒéseliyi. ʒérabéra naléiguc nuac kuananéŋ ʒéseliyi. ");
INSERT INTO kgf_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Ni rama iwawac wéréŋaguc ʒéma halécyaguc hofac ogémma burumakao iwa ʒéma noniŋ momacnec haigémmaŋ. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Anutuac bac yandi yandi wamma kecanʒu ini mocʒoŋ hama niŋgic. Anutunéŋ kekec uŋanawac ai meyec imuac ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Neŋ nena kuananéŋ qacmima ezelaŋnanéŋ legic héimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Ni qerinaiguc képésic doŋgéma kecbinec inéŋ ménda niŋ némbacnec, néŋ ");
INSERT INTO kgf_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","inéŋ hélacnec niŋnémma nuac ʒéwelecnawac gezac qeyec. ");
INSERT INTO kgf_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Anutu mepésimigic, inéŋ ʒéwelecna ménda elicgéma goi héihéiya ménda aŋgé tinéŋec. ");
INSERT INTO kgf_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","(Legic galeŋawac; waŋgoŋ hésiaguc, legic méŋac legic ʒéra.) Anutu, goi héihéi waŋ nénécmima mériaŋ nénécmima kic tanecga asahagucnéŋ ninicna. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Imuhuc wamma guac héna imi baeciguc, guac aŋgéŋ titiac buŋa imi baera baera énézéna nimmu. ");
INSERT INTO kgf_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Anutu wai énécmina baec séc ic embac tuŋa tuŋa gi mepési gémmu. baec séc ic embac momac yanda ieneŋ legic héigémmu. ");
INSERT INTO kgf_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Énézéna baera baera ségiségi wamma ewa hia nimma legicya héimu. Inéŋ ic embac keŋkésa hakésaya qahac ʒégési énécmima baec qahaiguc ic embac hénia hénia imi galeŋgé énécmimac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Anutu wai énécmina baera baera ic embac ieneŋ gi mepési gémmu. Ic embac momac yandanéŋ gi legic héigémmu. ");
INSERT INTO kgf_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Baecnéŋ héla haizac. Anutunéŋ neŋaŋ muru mériaŋ nénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Anutunéŋ mériaŋ nénécmiyu baec tetecgia séc mocʒoŋ Anutu eeya héimu. ");
INSERT INTO kgf_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","(Legic galeŋawac; Dawidiac legic ʒéra, Legic.) Anutu yaru, haʒéchéra héndéŋ énécmiyu tuidacmu. Héŋara meanʒu ionac waŋ énécmiyu mocʒoŋ iwac murunec néŋgacma kendacmu. ");
INSERT INTO kgf_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Luhucnéŋ hofac mihilaŋgéyu keŋanʒac ésécnec nesi énécmiyu kendacmu. Gericiguc kendolnéŋ pépélima maanʒac ésécnec ic biria eneŋ Anutuac wésiaiguc humu qai wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Ic solaŋa eneŋ ségiségi wamma Anutuac wésiaiguc técgéma aria mema ewa hia nimma ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Anutuac muru legic héimima iwac qara mepésimimu. Hosusuiguc tacma baec kéra kérasiaiguc keŋha waŋaŋec i meyacmigic. Iwac qara imi Yawe, wésiaiguc técgéma aria memu. ");
INSERT INTO kgf_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Rara téréyaiguc kecanʒac Anutu iminéŋ gupaŋ merac onac maŋgoc ʒéma embac malé onac ʒégésigési ic kiwa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Anutunéŋ niŋgumbi niŋguŋ kecʒu imi ama géséhéra mihicŋi énécmima hésa amaiguc kecʒu imi metecgé énécmima kekecgina mébéréŋgé énécmianʒac. Néŋ acqeqe ic ionac tacyacac buŋa imi baec kérakérasia waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Anutu, ic embachécga wéséginaiguc walac keŋnec nalé imuaru, baec kéra kérasia qericma keŋec nalé imuaru, (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","baecnéŋ hiriyu kurumeŋnéŋ mayec. Waŋu Sinai baec boŋa acguc Israelac Anutu guac wéségaiguc hiriyec. ");
INSERT INTO kgf_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Anutu geŋ kia sécya haina mayec. Guac mératéc buŋahécganéŋ météqététaŋ waŋgic meseli énécminec. ");
INSERT INTO kgf_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Imuhuc wamma guac hénaoriŋ hécga imuaru onopocna kecgic. O Anutu, geŋga hiaga niŋac maqeqeya ionac imi iwawai mihicŋi énécminec. ");
INSERT INTO kgf_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Geŋ ackuaʒéc nénézéna embac gezac qéʒéŋ ac ʒéauanʒu imi tuŋ yandaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Téŋgiŋ ic tuŋa tuŋa ionac ic kewu hécginanéŋ ichéra iniguc néŋgacma kendacgic, embac amaiguc kecgic ieneŋ acguc téŋgiŋ ic onac ama baec saocyaiguc iwawai mema hama méndéŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Ini rama demiŋ qeriaiguc hegic tanera imi kembo nei qeŋgaŋa siliwanéŋ oso osoya, nei ʒucya goli ɋaoranéŋ oso osoya ésécnec waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Wandac wandac medac medac miŋinanéŋ ic kewu héndéŋ énécmiyu Zalmoniguc komboc efefia luhucnéŋ mihilaŋgéyu sicsaoc maanʒac tanec waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Basanac baec boŋa imi Anutuac buŋa. Basanac baec imi eŋeŋa yanda. ");
INSERT INTO kgf_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Baec boŋa eŋeŋa eŋeŋa ini némac niŋa baec boŋa Anutunéŋ tacyac wammaŋ ʒé wanʒac imuac nimbupuc wamma héŋ sosolizu? Hélacnec Yawenéŋ baec boŋa imuaru hémbénaŋa kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Anutuac yaré qeqeac becosicac karesi imi ʒaŋgégina tauseŋa tauseŋa wanʒu. Miŋ Kewunéŋ sucginaiguc keru héŋni Sinai baec boŋa tacyacac buŋa téréyaiguc kecʒac ésécnec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Gi ou eŋeŋaiguc eŋnec nalé imuaru hésa ic énépésinec imi héré énécmima kemma ic onac murunec me acqeqe ic ionarunec acguc momacnec sese menec. Mema Yawe Anutunéŋ imuaru tacyac wammaŋ ʒé eŋec. ");
INSERT INTO kgf_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Kaiweya kaiweya yéwérinina nonagicma bisianʒac Miŋ Kewu Anutunina imi mepésimimu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","Anutu imi aŋgéŋ titi miŋina. Humuc igucnec qiʒiʒiŋgéma keŋkeŋa imi Anutuac murunec. ");
INSERT INTO kgf_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Haʒéchéra ionac orucgina, nalé séc képésicac héna tima keŋha waŋanʒu imi onac oruc ʒuc ic kewuac opoc tanec meʒericgic heheya imi Anutunéŋ qésémma unumac. ");
INSERT INTO kgf_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Miŋ Kewunéŋ ʒézac; Neŋ waŋ énécmiwa ieneŋ Basan igucnec liliŋgéma hamu. Waŋu konduŋ hiŋgac hiŋgara igucnec muŋguc liliŋgéma érému. ");
INSERT INTO kgf_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","Hagic eneŋ humumia unuma sacginaiguc hénagina tinduŋgégic kazugina acguc sacgina nemu. ");
INSERT INTO kgf_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Anutuna, ic kewuna gi ocmuŋ téréyaiguc kereŋna ieneŋ géŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Walac legic héihéi ic eneŋ hocma keŋgic imuac andiaiguc waŋgoŋ ic eneŋ embac seraŋa tambariŋ ginaguc ionac sucginaiguc méndac énécmima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Israel hénaoriŋ sucginaiguc Miŋ Kewu Anutu mériaŋ ac wammigic. Israelac doku hogocya igucnec hicŋihicŋiya ini imuhuc wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Imuaru imi ʒiagina Benʒaminac sac taséhéra ieneŋ kiwa waŋ énécmima kecgic. Waŋu Yudawac galeŋhéra ʒéma Sebulonac galeŋhéra ʒéma Naftaliac galeŋhéra ieneŋ momacnec kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Anutunéŋ kucgina ʒéhiaru énécmizac. O, Anutu neŋaŋ niŋac waŋ nénéc minec imi meseligina. ");
INSERT INTO kgf_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Ocmuŋga Yerusalem tacʒac imuac niŋac wamma ic kewu eneŋ guac sese mema hamu. ");
INSERT INTO kgf_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Ʒéléŋ baeciguc haséŋ yaŋ ʒéma burumakao iwa tuŋaguc ʒéma baera baera imuac burumakao merawa imi ac geriwaguc waŋ énécmina. Anutunéŋ ic yaréac siŋa niŋanʒu imi héndéŋ énécmima siliwagina tidacgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Ic kuneŋ eneŋ Iʒipte baeciguc érégic, Etiopia ic eneŋ focdac méragina meyacma Anutuaru opocamumu. ");
INSERT INTO kgf_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Baecac héŋgaleŋ ama areŋa yanda mocʒoŋ Anutu legic héimimu. Miŋ Kewu mepésimimu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","Inéŋ kurumeŋ kerecac kecʒac imuac qahaiguc tacma parandaŋ ésécnec ac ʒéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Anutuac kuha ʒéau énécmigic. Iwac eeya yéwérianéŋ Israel qacginaiguc hezac. Iwac kuhanéŋ kurumeŋiguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","O Anutu ocmuŋgaiguc kecanʒaŋ gi imi welic welicgiaguc. Israelac Anutu imi eŋeya ic embachéra ionac kuc énécmima meseli énécmianʒac. Anutu mepésimigic! ");
INSERT INTO kgf_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","(Legic galeŋawac; ‘Baorac ʒariŋ’ ewaiguc, Dawidiac legic ʒéra.) O Anutu ni metecgé nénna. Dokunéŋ déméŋnaiguc éréma sécgéʒac. ");
INSERT INTO kgf_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Ni hauruc gizoŋ dumuŋa qahac imuac qeriaiguc hiŋgacmanec kecʒua. Ni doku hiŋgac hiŋgaraiguc hiŋgacba, temboŋ yandanéŋ hoturu nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Guac qacma kecba kucna qahac waŋu, déméŋna kérakérasia wanʒac. Anutunawac mambéc kecba kicna acguc méiméiya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Héniana qahac méʒétiti wannénʒu imi oruc ʒucna ogicma sasala wanʒu. Héniana qahac numa mebiri némbiŋ ʒé wanʒu imi eneŋ gelec malec qahac. Iwawai ni kowu ménda meyi, waŋu meleŋ énécmimaŋ niŋac téŋésima qesinéŋgic énécmimaŋac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Anutu, gi imi ni ic témpiŋa kecʒua héniana imi ninʒaŋ. Imuac képésicna kicgaiguc winiŋu hezac. ");
INSERT INTO kgf_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋa Anutu Yawe, guac niŋkumuma kecanʒu imi eneŋ nuac niŋac wamma gamugina nimbu niŋac. O Israelac Anutu, guac hochoc ai meanʒu imi eneŋ nuac niŋac mematiti mihicŋiwu niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Gamunéŋ kic tanecna osonénʒac. Waŋu ni guac niŋ wamma imi bisiqatéŋ wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Ni nuac dac munahécna ionac muru ic méréra ésécnec wamma kecʒua. Sac taséhécna ionaru ic enia tanec kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Imi mia guac amagawac siŋniŋ henénʒac iminéŋ geric bélaŋ ésécnec noyu imuhuc wanʒua. Ʒébiri géŋanʒu ionac ʒébiri qébirinéŋ nuac qacnaiguc mazac. ");
INSERT INTO kgf_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Ni nene ʒiki kecma kekec uŋana memaamuma kecba ic embac eneŋ ʒédesi waŋ nénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Ni ewa biricac séwi usuna héima kecba ic embac ieneŋ isocfagociguc nopocʒu. ");
INSERT INTO kgf_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Ama areŋ yanda imuac saŋgulaŋiguc tacʒu imi eneŋ ʒédesi waŋ nénʒu. Doku seli nema ewa soho kecʒu imi eneŋ acguc legiciguc nopocma ʒédesi waŋ nénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","O Yawe, ewa hiagawac naléiguc ʒéwelec génʒua. O Anutu, ʒéwelecna niŋnémma guac goi héihéiga yandanéŋ mehiaru némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Ni gizoŋ hiŋgac hiŋgara igucnec metecgé nénna hiŋgacbi niŋac. Haʒéc waŋ nénʒu ionac murunec ʒéma doku yanda igucnec metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Doku yandanéŋ hoturu némma ɋécgé néŋu dumuŋaiguc hiŋgacbi niŋac. Gizoŋ hiŋgac hiŋgaraiguc hiŋgacba kuayanéŋ qacnaiguc ha kiʒicgéwac niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Yawe guac goi héihéi imi hiabia. Imuac acna meleŋ némma guac ewa biric yanda niŋac nuac liliŋgéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Guac kic tanecga imi weleŋ qeqe icga ménda musaŋgé némbésémaŋ. Ni ʒérabéra qeriaiguc tacʒua focdac acna nimbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Qeri uŋanawac hosucgé némma mulu menémma haʒéchécna ionac murunec boŋhéré menémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Gi imi nuac gamuna ʒéma ʒébiri qébiri imi nindacʒaŋ. Nuac haʒéchécna imi mocʒoŋ wéségaiguc kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Ʒébiri qébirinéŋ nuac ewa qerina mebiriyu niŋyéwécna imi sécgénéŋu kic hima hocba ewa biric waŋ nénéŋa méŋ ménda kecʒac. Waŋu kic hima hocba mebélacgé nénéŋa méŋ ménda kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Ieneŋ sacmasi biria imi nemaŋ niŋac néŋgic. Déméŋna ʒicgéyu doku howuraguc nemaŋ niŋac néŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Waŋénécmina wéséginaiguc neneac tatacnéŋ hénagina dérécgéyu luaeginanéŋ bétac wamma iniyu. ");
INSERT INTO kgf_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Waŋénécmina kicginanéŋ siŋindéŋgéyu hémmuac séc qahac wammac. Kembaŋ ginanéŋ kuha qahac waŋu hirimu. ");
INSERT INTO kgf_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Qeri biricga qacginaiguc qocgéna mayu. Guac qeri biric bélaŋagucnéŋ ionaru suluma kemma énépésimac. ");
INSERT INTO kgf_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Tacyacginawac buŋanéŋ biridaru ama kisia wandacmac. ");
INSERT INTO kgf_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Ieneŋ imi ic geŋ ununec imi muŋguc ununesi waŋ énécmima, ic geric mihicŋi énécminec imuac suruc siŋa nimma wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Hakagina ɋariŋ ɋariŋgia imuac qahaiguc hakagina ɋariŋ ɋariŋgia muŋguc toroqe énécmina, guac ʒégésigési solaŋaiguc ménda keremmu. ");
INSERT INTO kgf_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Qacgina imi kekec hémbénaŋa imuac kiwiiguc auna ic solaŋa ionac qacginaiguc momacnec ménda hemac. ");
INSERT INTO kgf_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Ni imi maqeqeya wamma ʒérabéraiguc qenʒeŋ manʒeŋ qema kecʒua. Anutu guac aŋgéŋ titiganéŋ meyac némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Ni legiciguc Anutuac qara héimimaŋ. Ewa hia ac ézéma Anutuac qac buŋaya meyandimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","Iminéŋ mia burumakao ilihaguc ʒéma haséraguc imuhucya ogicma Yawe ségiségi mihicŋi mimac. ");
INSERT INTO kgf_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Gumbénʒénʒéŋ icnéŋ imi hémma ségiségi wanʒu. Anutuac hochoc waŋanʒu ini imi ewa qerigina meɋeligic kekecginaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Yawe imi maqeqeya niŋénécmima eŋeya hia niŋac wamma hésa ic kecʒu imi mematiti ménda waŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Baec kurumeŋnéŋ i mepésimiyic, konduŋ ʒéma doku yaŋ imuaru sécgéma hezu imi mocʒoŋ i mepésimu. ");
INSERT INTO kgf_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Anutunéŋ Zionac aŋgéŋa tima Yuda ama areŋa kuneŋ kuneŋ meyacgémac. Waŋu hénaoriŋ hécga imuaru kecma miŋina wammu. ");
INSERT INTO kgf_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Iwac weleŋ qeqe ichéra ionac ɋelihéra ieneŋ Zion baec imi mératéc memu. Qara siŋ nimmianʒu imi eneŋ imuac qeriaiguc kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","(Legic galeŋawac; Dawidiac legic ʒéra, haka méŋac niŋɋelima ooya.) Anutu focdac ni metecgé nénna, Yawe focdac méra némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Waŋénécmina nuac kekec uŋanawac hochoc waŋanʒu imi eneŋ gamu qeqe ʒéma gamu mamasuŋ mihicŋimu. Mebiri némbiŋ ʒé waŋanʒu imi waŋ énécmina andé andé kemma gamu mihicŋimu. ");
INSERT INTO kgf_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Ahaec, ahaec ʒéma desizu imi waŋ énécmina gamugina niŋac wamma andé andé kendacmu. ");
INSERT INTO kgf_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Guac hochoc waŋanʒu imi mocʒoŋ waŋ énécmina guac niŋ wamma ségiségi wamma ewa hia nimmu. Waŋu guac aŋgéŋ titiac niŋkumuma kecanʒu imi waŋ énécmina nalé séc Anutu imi kuneŋ yanda! ʒémanec kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Ni maqeqeya ʒéma météqététaŋ kecʒua. Anutu focdac hawésémaŋ. Gi imi nuac héipucna. Ni metecgé nénéŋa imuac miŋina, sosola ménda wamma focdac hawésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Yawe ni néŋgacma guac muru hazua. Hémbénaŋa gamunaguc ménda wammaŋ niŋac galeŋgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Hakaga solaŋanéŋ metecgéma hulac némbésémaŋ. Gezac qenimma metecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Gi imi nalé séc saŋgi saŋginawac baŋec wambésémaŋ. Gi imi nuac ʒamanʒiŋ ʒéma demiŋ seli baec boŋaiguc nanaŋa, imi aŋgéna timac niŋac ʒéna hicŋima hezac. ");
INSERT INTO kgf_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Anutuna ic biriawac méria igucnec metecgé nénna. Kaiʒiliweŋ ʒéma biria meme icnéŋ népésiyu méria igucnec metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Hénia imi yomuhuc; Miŋ Kewu Yawe, Nuac niŋkumuna imi guaru hezac. Komocna igucnec guac muru héima namma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Neŋgocnawac hériiguc kecbanec népésinecac népésianʒaŋ. Neŋgocnawac tomeŋaiguc kecba geŋ nuagicna mayi. Mepé qepésina ʒéŋgé toroya qahac imi guac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Ic tuŋagucnéŋ nuac niŋgic ic témpiŋa tanec waŋu néŋsosoligic. Waŋu geŋ mia nuac saŋgi saŋgi selina waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Nuac kuananéŋ kaiwe herec guac edamuga ʒéauwa mepé qepésiganéŋ sécgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Ic yanda wamma kecmaŋ nalé imuaru ménda wainémbésémaŋ. Kucna audacba mamaya waŋu ménda wai némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Haʒéchécna ieneŋ nuac ʒéemi ninʒu. Waŋu kekec uŋanawac awima tacʒu imi eneŋ nuwiŋ ʒé ʒéareŋ wamma yomuhuc ʒégic imuhuc ʒéwelecʒua; ");
INSERT INTO kgf_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Anutunéŋ i waimizac metecgé mimiawac ic méŋ ménda kecʒac, nesima késani. ");
INSERT INTO kgf_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Anutu lakec ménda néŋgac némma kembésémaŋ. Nuac Anutuna focdac méra némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Waŋénécmina qeri uŋanawac haʒéc wannénʒu imi eneŋ gamu qeqe ʒéma humuc mihicŋimu. Waŋénécmina mebiri némbiŋ ʒé wanʒu imi ʒédesi ʒéma mematitinéŋ hoturu énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Ni imi nalé séc guac niŋkumuma gi séc méŋ meemma mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Ni guac haka solaŋa oloŋ oloŋawac séc qahac imi ʒéma guac aŋgéŋ titiac ai imi kaiwe herec ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","O Miŋ Kewu Yawe, ni guac hama guac wawaŋ memega kuhaguc imi mepési gémmaŋ. Ni guac haka solaŋa imuacnec sac niŋɋelima ʒémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Anutu gi imi ni komocna igucnec ac pakeŋ ku nénnecac néŋanʒaŋ imuac mia ni éréma deguc guac wawaŋ memega welic welicgia imi ʒéau énécmianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","O Anutu ni ic yanda wamba oruc ʒucna lalac lalac wammac nalé imuaru acguc ni ménda wainémbésémaŋ. Ni kucga imi hicŋisai méndacma hahaya ionac énézédacmaŋ imuac nalé sura séc ménda wainémma niguc kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Anutu guac haka solaŋa imi eŋeŋa yanda. Anutu gi haka silic kuneŋ yanda menec, imuac mérénéŋ gi ésécnec wammac. ");
INSERT INTO kgf_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Ʒérabéra réwéria sasala mihicŋi nénnec Miŋ Kewu geŋ mia ni muŋguc meɋeli némma baec dumuc sira hiŋgac hiŋgara igucnec muŋguc hérénéŋna érémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Ni séc méŋ meyandi nénna. Liliŋgéma ewa qerina mebélacgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Anutuna ni gita kulelenéŋ gi mepésima guac haka héla imuac mepésigémmaŋ. Israelac Miŋ Kewu téréya ni gita kulelenéŋ gi mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Gi mepési gémba, kua tasénanéŋ ségiségi wamma qacmac. Waŋu kekec uŋana aŋgéŋa tinec imi acguc imuhuc waŋgémmac. ");
INSERT INTO kgf_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Nuac ezelaŋna acguc kaiwe herec guac haka solaŋa ʒéaumac. Imi mia mebiri némmaŋ ʒé wanʒu imi eneŋ gamu mihicŋima sicsaoc wanʒu imuac mia imuhuc waŋgémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","(Solomonac legic ʒéra.) Anutu guac niŋgési gésigawac kuha imi ic kewu iwac miwésémaŋ. Solaŋanec galeŋgé énécmimiawac kuha imi ic kewuac naŋa mina. ");
INSERT INTO kgf_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","Inéŋ ic embachécga solaŋanec niŋgésima maqeqe hécga héna ac méndacma dindiŋanec ʒégési énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Inéŋ imuhuc waŋu baec boŋa eŋeŋa eŋeŋanéŋ ic embac ionac mériaŋ mihicŋi énécmimu. Waŋu baec boŋa komoc komoc acguc imuhuc waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Waŋu inéŋ ic embac maqeqeya héipuc waŋ énécmima météqététaŋ ic aŋgéŋgina tima helanʒi énécmianʒu imi héʒéŋgé énécmidacmac. ");
INSERT INTO kgf_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Inéŋ kaiwe ʒéma maso naŋicnec naŋselima hicŋisaiya hicŋisaiya inicgaleŋ wammac niŋac wammiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Inéŋ ɋézézac qegic mama heheya imuaru kianéŋ mazac ésécnec, waŋu kia yanda baec mézécgéanʒac ésécnec waŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Iwac naléiguc imi ic solaŋa eneŋ yandi saima kecgic maso asaha naŋunec luae sécgé énécmima hemac. ");
INSERT INTO kgf_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Inéŋ konduŋ hénihénia igucnec tetecgiawac séc, doku téfara Yufurata igucnec baec tetecgiawac séc galeŋgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Baec ʒéléŋaiguc kecanʒu imi eneŋ iwac wésiaiguc sicgémigic haʒéchéra eneŋ seitotoŋ ezelaŋ ginanéŋ bézéma nemu. ");
INSERT INTO kgf_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Tarasisi ʒéma konduŋ baec komoc komoc imuac ic kewu ieneŋ takis haimimu. Arabia ʒéma Ediopia ic kewunéŋ sese eeyaguc mema hamu. ");
INSERT INTO kgf_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Ic kewu momac yanda wésiaiguc sicgémigic baera baera i weleŋqemimu. ");
INSERT INTO kgf_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Inéŋ ic embac iwawai niŋac osiqosi kecanʒu imi eneŋ qacgic metecgé énécmima maqeqeya héipuc ichécgina qahac imi metecgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Inéŋ maqeqeya ʒéma météqététaŋ kekec ionac ewa biric waŋ énécmima iwawai niŋac hochoc ai mema kecanʒu imi humuc igucnec metecgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Inéŋ ic embac helanʒi énécmianʒu ionac murunec ʒéma kaiʒiliweŋ ic ionac murunec sacginawac niŋu eeyaguc waŋu kekec uŋagina aŋgéŋgina tiénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Inéŋ kekecyaguc keru Sebawac goli mema hama iwac muru haimimu niŋac wanʒua. Waŋu ic embac ieneŋ iwac niŋac wamma nalé séc ʒéwelecma kaiwe herec legic héimimu niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Baec séc padinéŋ sécgéma hemimac. Baec boŋa qahaiguc acguc padi heyu luhucnéŋ mihilaŋgéyu Lebanonac ic hésa ésécnec hirima nammac. Ama areŋa yandaiguc imi ic embac eneŋ imi baec kisiaguc ʒéléŋ ésécnec kucginaguc saima kemmu. ");
INSERT INTO kgf_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Qara imi hémbénaŋa, kaiwe ésécnec hehe seli hemac. Ic embac ionac imi iwac niŋac wamma mériaŋ énécmiyu memu. Baera baera ic embac ieneŋ iwac mia mériaŋaguc ʒémimu. ");
INSERT INTO kgf_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Momacguc eŋeyanec wawaŋ meme welic welicgia waŋanʒac Israelac Anutu, Yawe mepésimimu. ");
INSERT INTO kgf_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Qara ʒézé bipiyaguc imi hémbénaŋa mepésimimu. Baec séc iwac edamuyanéŋ sécgéma hemac, hélacnec, hélacnec! ");
INSERT INTO kgf_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Yesiac naŋa Dawidiac ʒéwelec méŋnéŋ you hama tecgézac. ");
INSERT INTO kgf_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","(Asafeac legic.) Anutunéŋ Israel ionac sucginaiguc ewa qerigina lalac lalac kecanʒu ionac muru hia waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","3","Néŋ ni imi kaiʒiliweŋ ic ionac kekec mériaŋaguc imi hémma séwi eŋeŋ ic ionac nimbupuc waŋi imuac niŋac hénana tisuqisurac wamma manumaŋ ʒé waŋec. Waŋu nanaŋnawac qambaŋa imi keŋ saŋgimaŋ ʒé waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Ieneŋ imi humucac naléiguc acguc hafi geriwa qahac kucginaguc kecma humuanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Tosara ionac ésécnec ʒérabéra ménda mihicŋima yéwéri ménda mihicŋianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Imuac séwi eŋeŋginanéŋ soroŋgina waŋu kaiʒiliweŋ ginanéŋ ionac séwi usu waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Ieneŋ haléginaguc waŋu kicgina qégélianʒac. Waŋu iwawai ewa siŋginawac séc ogicma késa kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Ieneŋ ʒédesi waŋ énécmima ʒébiri qébiri waŋ énécmima séwi eŋeŋginaiguc tericgé énécmima helanʒi énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Kuagina imi kurumeŋac séc emma kecʒac. Waŋu ezelaŋgina imi baec séc lelecgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Imuac ic embac ieneŋ liliŋgéma keŋ toroqe énécmima dokugina kuaya qeqeya mocʒoŋ ɋécgéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Anutunéŋ dimuhuc niŋtegicmac? Eŋeŋa miŋina imi niniŋaguc wambacnec ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Inictegicgic. Ieneŋ imi ic biria ionac héniagina imi ewa éréhéc ménda wamma kecma hinacgina meyandianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Ni ewa qerina galeŋgé kecba lalac lalac waŋu mérana ʒuacma képésicna qahac ʒéma kecaŋi imi héla qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Ni kaiwe herec ʒérabéra mihicŋima siŋunec séc ʒéqindiŋi waŋnéŋu kecaŋi. ");
INSERT INTO kgf_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Ni imuhuc ʒéaumaŋ ʒé ʒéwinec miŋ kewuac nambérac héra ikoc waŋ énécmiwinec ");
INSERT INTO kgf_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Dimuhuc hénia imi niŋasarimaŋ ʒéma batucgéma nimba sécna ogicma yéwéria waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Waŋu Anutuac ocmuŋ qeriaiguc keremma nimmaguc kekecginawac tetecgia imi niŋasariyi. ");
INSERT INTO kgf_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Hélacnec geŋ mia ic biria ini baec susuraciguc onopocma humucac buŋa gili énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Ieneŋ dimuhuc éléŋnec birianʒu? Tericgé énécmina aurigic, usuŋénécmina qahac waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Ic neŋaŋ gau igucnec yacma gau héŋiŋ imuac ninni eŋomia waŋanʒac ésécnec gi yacbésémaŋ nalé imuaru ionac niŋna eŋomia wandacmac. ");
INSERT INTO kgf_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Ewa biric wamba wéiwécnaiguc néyu ");
INSERT INTO kgf_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","ni sicsaoc niniŋna qahac kecba kicganéŋ nénna wéségaiguc haséŋ yaŋ ésécnec waŋi. ");
INSERT INTO kgf_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Waŋu geŋ mia nuac méra héinaiguc késana ni nalé séc giguc kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Geŋ pakeŋ acganéŋ ʒéqindiŋi némma biaŋ kecma edamugaiguc nuagicma kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Gi qahac waŋu mérénéŋ kurumeŋiguc kecnénʒac? Gi qahac waŋu, baeciguc méŋac méŋ niŋkumuma kecmaŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Séwi qerina imi ɋasima kenʒac, néŋ Anutu gi imi ewa qerinawac kuha ʒéma buŋana hémbénaŋa wanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Anutu héŋacya mema lakec kecʒu imi eneŋ mocʒoŋ biridacmu. Gi waigémma keŋgic séc mebiri énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Anutuac hosuraiguc kekec iminéŋ nuac mériaŋna wanʒac. Gi imi nuac saŋgi saŋgina imuhuc ʒéma nimma wawaŋ memega mocʒoŋ ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","(Asafeac legic ʒéra.) O Anutu gi némac niŋac hémbénaŋa wai nénécmizaŋ? Dimuhuc ramahécga galeŋgé nénécmianʒaŋ ionac qeri biricac hofac qéfacgé nénécmizaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Hénaoriŋ hécga ionac kisic areŋ tuŋa tuŋa becarunec aŋgéŋ tima metecgé énécminec imi niŋɋeli énécmima guac baec boŋa téréya Zion imi momacnec niŋɋeliwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Hémbénaŋa mebiri mimia imuaru hénaga liliŋgéma hana, haʒéchécga eneŋ ocmuŋga téréyaiguc kaiʒiliweŋ hénia hénia wamma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Haʒéchécga eneŋ imi geŋ mihicŋi nénécminec ama areŋa yanda imuaru hériaŋ héima filacgina imuaru kumugic nanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Ieneŋ imi naka meyacma ic ʒuŋ héianʒu ésécnec waŋ nénécmima kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Deguc ieneŋ imi naka ʒéma aiŋ hamanéŋ ocmuŋac méra kiwi imi héiqéséŋ wamma ");
INSERT INTO kgf_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","ocmuŋga geric higic ʒeyu guac qacga heyec imi ʒapi qema hezac. ");
INSERT INTO kgf_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Qeriginanéŋ imi qéséŋni qahac wandacmac ʒéma Anutuac aʒoaʒoro amaya amaya baec yomuaru naŋgic imi mocʒoŋ kumugic ʒedarec. ");
INSERT INTO kgf_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Kiwi méréra méŋ ménda hénʒiŋ Anutuac tiliŋtiliŋ ic muŋguc ménda kecʒac. Nalé dahecac séc imuhuc mehorugima kecmac imi sucninaiguc méŋnéŋ méŋ ménda ninʒac. ");
INSERT INTO kgf_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Nalé dahecac séc haʒécganéŋ ʒédesi waŋgémmac? Inéŋ hémbénaŋa gi ʒébiri gémmac? ");
INSERT INTO kgf_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Némac niŋac méraga, guac méra héiga imi aŋgétima ʒikima kecʒaŋ? Méraga imi tétécga igucnec hulacma méra némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Anutu gi imi becarunec nuac ic kewu kecnecac kecʒaŋ. Waŋu ic embac sucginaiguc aŋgéŋ tinénéc mimiawac ai imi meaŋnec. ");
INSERT INTO kgf_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","Gi imi kucganéŋ konduŋ doku qericna éréhéc waŋec. Doku qeriaiguc mokoleŋ yandawac oruha qéséŋnec. ");
INSERT INTO kgf_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Oawac oruha héʒéŋgéma imi ʒéléŋ yaŋ baec kéra kérasiaiguc kecanʒu ionac nene buŋa énécminec. ");
INSERT INTO kgf_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Baŋa ʒéna téyu doku yanda mayec. Doku téfara hémbénaŋa keŋkeŋa imi ʒéna ʒicgédarec. ");
INSERT INTO kgf_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Siŋi kaiwe imi mocʒoŋ guac. Geŋ mia maso ʒéma kaiwe ʒéna hicŋiyoc. ");
INSERT INTO kgf_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","Baecac suc séré mihicŋima kaiwe nalé ʒéma kia nalé ʒéhicŋinec. ");
INSERT INTO kgf_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Haʒéc hécganéŋ ʒébiri gémma ic embac niniŋgina qahac ieneŋ guac qacga ʒébiri qébiri wammizu imi niŋ asariwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Kembo neiac kekec uŋa imi haséŋ yaŋ ménda énécmina, guac ic maqeqeya ionac kekec imi hémbénaŋa eluŋ ménda gumac. ");
INSERT INTO kgf_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Baec tosara siŋidéŋgézac imuaru kaiʒiliweŋ ic ionac baŋec sécgéma hezu. Imuac niŋac sisipac acga imi niŋɋeliwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Helanʒi énécmimia ieneŋ gamuginaguc andé andé ménda kemmu niŋac waŋ énécmina. Maqeqeya ʒéma iwawai niŋac osiqosi kecanʒu imi eneŋ mepésigémmu niŋac waŋ énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Anutu yacma ʒé solaŋanina. Ic témpiŋa imuhucyanéŋ kaiwe herec ʒébiri qébiri waŋgénʒu imi niŋɋeliwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Haʒéchécga ionac ewa hétéŋ imuac eluŋ ménda gumac. Yacma haʒéc waŋgénʒu imi onac qeweloŋ acginanéŋ nalé séc guac muru haanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","(Legic galeŋawac; Ménda mebiri nénécmina. Asafeac legic ʒéra.) Ewa hia ac gézéziŋ, o Anutu nini ewa hia ac gézéziŋ. Guac qacga qacni hosucninaiguc kecma meleŋ nénécmianʒaŋ. Ic eneŋ guac wawaŋ meme welic welicgiawac ʒéaugic guac qacga gezac ninaiguc heyu niŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Gi yomuhuc ʒézaŋ; Naléya imi mewa hezac, ni héna aciguc dindiŋanec ʒégési énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Baec ʒéma imuac tacyachéra imi hirimu, néŋ neŋ imi baecac tandéya késaseligima kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Séwi eŋeŋ ic ionac séwi eŋeŋ ménda waŋgic ʒéma kaiʒiliweŋ ic ionac ilicgina ménda meyacgic eŋu ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Ini ilicgina meyacgic ou ménda emmac. Waŋu séwi eŋeŋac déméŋginanéŋ ac ménda ʒému. ");
INSERT INTO kgf_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Meyac énécmimia imi baec waŋgoŋa Is me Wes me Saut igucnec hahaya qahac. ");
INSERT INTO kgf_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","Ʒégésigési miŋina Anutunina Yawenéŋ méŋac meyacmima méŋac memamianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Yaweac mériaiguc sokoc taru waiŋ hénia hénia lelecgégéya imuac sépéc sépéra qéitima érézac. Waiŋ imi inéŋ qocgéyu mazac. Mayu waiŋ imi imuac gocya momacnec baeciguc ic biria ieneŋ nedacmu. ");
INSERT INTO kgf_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Ni imi Yakoboac Anutu imi hémbénaŋa ʒéau énécmima mepésimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","Waŋu kaiʒiliweŋ ic ionac ilicgina imi mocʒoŋ mericdacma ic solaŋa ionac ilicgina meyac énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","(Legic galeŋawac; Gita kuleleginaguc, Asafeac legic ʒéra marayaguc.) Anutu imi Yuda baeciguc niŋmimia. Waŋu qara imi Israel sucginaiguc niŋgic kuneŋ yanda waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Haliya imi Salem héŋgaleŋ ama areŋaiguc, tacyacwac ama duŋa imi Zioniguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Imuaru inéŋ yaréac iwawai ʒakoŋ gericyaguc ʒéma saiwa ʒéma sou imi qéséŋu qahac wandarec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Gi imi baec boŋa yaré qema onagicna saocga waŋec imuaru edamugaguc wanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Ic kawali imi unuyu mama hezu. Méŋnéŋ méŋ méragina meyacmac ac séc qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Yakoboac Anutu gi ac waŋ énécmina yaréac karisi ʒéma becosic imi mocʒoŋ gau yanda hezu. ");
INSERT INTO kgf_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Gi momacguc sac bac yandi yandi waŋgéŋgéŋawac buŋa kecʒaŋ. Geŋ qeri biric wanna mérénéŋ guac wéségaiguc hia naŋselimac? ");
INSERT INTO kgf_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","Gi kurumeŋiguc ʒétecgéna baecnéŋ ʒénéŋ hirihiri wamma néŋ qema hezac. ");
INSERT INTO kgf_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","Imi mia, o Anutu geŋ baeciguc gum bénʒénʒéŋ ic aŋgéŋgina timaŋ ʒé yacnec nalé imuaru imuhuc hicŋiyec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Gi biriawac qeri biric wanna ic embac ieneŋ mepési génʒu. Qeri biricga saméŋa hegénʒac imi rikuŋ ésécnec ʒikiamuna hezac. ");
INSERT INTO kgf_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Ini imi Yawe Anutugina sisipac ac memima ac imi meselima meleŋ mimu. Lelec lelec kecʒu ini acguc mocʒoŋnec eeya héimimiawac hezac iwac mia sese haimimu. ");
INSERT INTO kgf_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Inéŋ kawali wéségina makikia wésé qoŋqoŋ mihicŋi énécmiyu ic kewu momac yanda bac yandi yandi wammizu. ");
INSERT INTO kgf_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","(Legic galeŋawac; Asafeac legic ʒéra Yédudun ewaiguc héihéiya.) Ni nuac ewananéŋ Anutuac muru qacmaŋ. Inéŋ gezac qenémmac. ");
INSERT INTO kgf_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Nuac ʒérabéra naléiguc ni Anutuac hochoc wamma siŋiyaiguc mérana meyacma ménda memayi. Nuac kekec uŋananéŋ ic onac héibélac qéibélac imuac héŋara meyec. ");
INSERT INTO kgf_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Anutuac nimma ewa goro wamma niŋyéwériwa nuac qerinanéŋ birima kemma ɋiritic numaŋac ʒé waŋ nénʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Kicna héméŋʒalimaŋ ʒéwa ménda wainénna niŋyéwérima acna ʒémaŋac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Becnecac naléna niŋɋelima ");
INSERT INTO kgf_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","legic méŋ siŋi méŋu héiyi imuac nimba qerinanéŋ hiŋgaru kekecac héniawac hocma ʒéyi; ");
INSERT INTO kgf_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","Miŋ Kewunéŋ hémbénaŋa wai nénécmimac me? Ewa hia muŋguc ménda waŋ nénécmimac? ");
INSERT INTO kgf_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Iwac goi héihéianéŋ hémbénaŋa tecgézac me? Inéŋ hémbénaŋa ménda niŋnénécmimac me? ");
INSERT INTO kgf_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Eluŋ qeyu ewa hiawac ménda waŋ nénécmianʒac me? Qeri biricnéŋ goi héihéiya héʒicgézac me? (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Waŋu muŋguc yomuhuc ʒéyi; Ewana mayu nimba birizac. Ni eŋeŋa miŋinawac méra héiyawac nalé imuac niŋɋelimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Ni Yaweac, wawaŋ memeya becnec waŋec imi niŋɋelima haka waŋec imi ʒéaumaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Imuacnec toroqema ai menec imi mocʒoŋ nimba hiŋgaru guac wawaŋ memega imi hiŋgac hiŋgarawac nimmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Yawe guac héna imi téréya yanda. Anutu méŋ gi éséc kuneŋ yanda méŋ ménda kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Gi imi Anutu haka welic welicgia wawaŋa. Imuac hicŋisaiya baeciguc kecʒu imi onac kucga imi énézéna hémmu. ");
INSERT INTO kgf_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Guac kucganéŋ guac ic embachécga Yakobo ʒéma Yosefeac ɋelihéra boŋhéré meénéc minec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Anutu doku yanda yandanéŋ gi géŋgic. Gémma bac yandi yandi wamma doku dumuŋanéŋ hiriyec. ");
INSERT INTO kgf_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Hosusunéŋ kia qocgéyu mayu sawanéŋ buŋ parandaŋ héiyu piliticga acguc ʒakoŋ ésécnec néwéc néwéc mayec. ");
INSERT INTO kgf_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Luhuc neŋgocya qeriaiguc guac parandaŋ qaru pilitic asahanéŋ baec séc qetagaliyu baecnéŋ hirima keŋha waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Guac héna duŋganéŋ konduŋ doku yandaiguc heyec. Waŋu héna tawégawac uŋaya imi hocanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Ic embachécga rama tuŋ ésécnec Mose ʒéma Aron iorac méragiranéŋ onagicma hayoc. ");
INSERT INTO kgf_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","(Asafeac Masikil legic ʒéra.) Ic embachécna ac pakeŋna nimma gezacgina kuanaiguc haigic. ");
INSERT INTO kgf_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Kuana aŋgéma qeqaiŋ aciguc héima ac saŋa becarunec imi ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","Imi yanda hécninanéŋ nénézégic gezacninanéŋ nimma niŋtegicma kecʒiŋ imi mia. ");
INSERT INTO kgf_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Nini imi ɋelihécgina ionac ménda musaŋgé énécmima Yaweac qac buŋa ʒéma kuha ʒéma haka welic welicgia imi hicŋisai hahaya ionac énézéni hema kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Héna ac imi Yawenéŋ Yakoboac niŋac kumuyu nanʒac. Ʒézé seli ac imi Israel onac énézéyec. Waŋu yanda hécninanéŋ héna ac imi ɋeli hécgina ku énécmimu niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","Imi mia ɋelihécgina biaŋguc hicŋi saima kecmu imi onac énézégic nimma ieneŋ acguc imuhucyanec waŋgic hema kecmac niŋac imuhuc énézéyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","Waŋu ɋelihécgina ieneŋ Anutuac niŋkumuma Anutuac wawaŋ meme imuac eluŋ ménda unuyu héna ac imi niŋtohoma kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Yandahécgina ewa seli wamma ac qeqe wamma ewa qeriginanéŋ eŋeŋ mama waŋu keŋhéi hahéi wamma Anutu solaŋanec ménda weleŋ qemigic ionac ésécnec ménda wamma kecmu niŋac imuhuc waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Eferaim ɋelihéra imi tewigina ʒéma yaréac iwawai tosara késa kecgic, néŋ yaré hicŋi énécmiyu andé andé kendacgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Ieneŋ Anutuac sisipac ac ménda niŋtohoma héna acwac héŋara mema ménda méndacma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Imuhuc wamma haka welic welicgia Yawenéŋ waŋec ʒéma énézéyu héŋgic imuac eluŋ unudarec. ");
INSERT INTO kgf_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Becnec Anutunéŋ Iʒipte baec yanda Soan baec kondoŋaiguc haka welic welicgia yandahécgina kicginaiguc waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Inéŋ konduŋ qeriru dokunéŋ néwéc néwéc qauqau emma naŋu onagiru sucnéŋ suc keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Waŋu kaiweiguc imi hosusunéŋ, siŋi herec imi geric bélaŋanéŋ walac andu waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Baec kéra kérasiaiguc imi baŋa qeriru dokunéŋ doku hogocya hiŋgac hiŋgaraiguc éréanʒac ésécnec éréyu doku sécgina gumu énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Waŋu doku imi baŋa imuacnec éréma doku téfara ésécnec wamma keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Waŋu kileŋ ieneŋ imi toroqemanec képésic wamma baec kéra kérasiaiguc eŋeŋa miŋina andé qegic. ");
INSERT INTO kgf_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Ieneŋ ionac séwiac siŋ méndacma nene yaka niŋ qesima ewa qeriginanéŋ Anutu manam batuc wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Imuacnec toroqema, Anutuac haʒéc wammima ac ʒéma Anutunéŋ baec kéra kérasiaiguc neneac tatac imi hia hai nénécmimacac séc? ʒégic. ");
INSERT INTO kgf_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Inéŋ Moseac mérianéŋ baŋa qema doku mihicŋi énécmiyu doku téfara ésécnec luma keŋec, néŋ ieneŋ muŋguc Anutu ʒégicsiŋ megicsiŋ ʒémima inéŋ saméŋ ʒéma yaŋ busia hia mihicŋi nénécmimac ac séc? ʒégic. ");
INSERT INTO kgf_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Waŋu Yawenéŋ nimma qeri biric wamma Yakoboac qeri biric geriwaguc wammima Israel onac haʒéc eŋeŋa waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Imi mia Anutu ménda ninʒéŋgémima iwac aŋgéŋ titi ai imuac ménda héima naŋgic imuac mia imuhuc waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Waŋu néwécgeŋaiguc inéŋ ou sawa ézéma kurumeŋac nagu auma ");
INSERT INTO kgf_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","ionac muru Mana imi kia ésécnec haiyu mayec. Mayu kurumeŋa nene haima gumu énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Baec icnéŋ kuc miŋina ionac saméŋ negic. Anutunéŋ nene énécmiyu sécgé énécmiaŋec. ");
INSERT INTO kgf_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Inéŋ ʒéyu baec waŋgoŋa Is igucnec luhucnéŋ yacma hayec. Waŋu iwac kuhanéŋ baec waŋgoŋa Saut igucnec luhuc wagicma hayec. ");
INSERT INTO kgf_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Imuhuc wamma ionac yaŋ busia imi seitotoŋ ésécnec haiyu mayec. Nei putitima keŋkeŋanéŋ mama konduŋ sakasac ésécnec sécgéma heyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","Tacyac wawaŋa imuaru mama sel haligina lelecgéma heyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Waŋu ieneŋ negic sécgé énécmiyec. Anutunéŋ séwiac siŋgina séc hai énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Waŋu ieneŋ séwiac siŋ imuac héŋacya ménda mema keŋgic kuaginaiguc nene he énécmiyunec, ");
INSERT INTO kgf_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Anutunéŋ ionac haʒéc waŋ énécmima sucgina igucnec haléginaguc imi unuyu Israelac sacɋeli ieneŋ tendiŋgéma mama humudacgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","Imuhuc waŋ énécmiyec, néŋ ieneŋ néwéc képésic susucnec wamma kileŋ haka welic welicgia imi ménda ninʒéŋgégic. ");
INSERT INTO kgf_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Anutunéŋ kekecac nalégina eŋ mesoho énécmima waŋ énécmiyu ʒénéŋ hirihiri waiʒalaŋiguc naŋgicnec yawuŋa yawuŋa hama keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Anutunéŋ tosara unuhumuyec nalé imuaru tosara ieneŋ ʒéwelecmima liliŋgéma hama Anutuac hochoc wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Imuhuc wamma Anutunéŋ eŋaŋ ʒamanʒiŋ hilaŋeŋ kecʒac imi ʒéma aŋgéŋ titi miŋina kecʒac imi niŋɋeligic. ");
INSERT INTO kgf_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Néŋ ieneŋ kuaginanéŋ haléc ac wammima ezelaŋ ginanéŋ ikoc ac wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Ewa qerigina Anutuac muru heyec iminéŋ keŋhéi hahéi waŋu sisipac acyaiguc hélacnec ménda héima naŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Waŋu kileŋ Anutunéŋ ewa biric waŋ énécmima képésicgina wai énécmima mocʒoŋ ménda unu humudacma hatac sasala qeri biria imi waima qeri geric mocʒoŋnec ménda pocgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Ieneŋ imi baec ic kecma luhuc ésécnec kemma muŋguc ménda hamu imi niŋɋelima imuhuc waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Baec kéra kérasiaiguc ieneŋ yei hatac dahec acqeqe wamma ewa biric mihicŋi migic? ");
INSERT INTO kgf_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Ieneŋ muŋguc muŋguc Anutu manam batuc wammima Israelac téréya miŋina qeri biric mihicŋi migic. ");
INSERT INTO kgf_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Ieneŋ iwac kuha ménda niŋɋelima haʒéc hécgina ionac murunec metecgé énécmiyec imuac naléya acguc ménda niŋɋelima kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","Nalé imuaru Anutunéŋ Iʒipte baec Soan baec kendoŋaiguc haka welic welicgia imi mihicŋi énécmima ");
INSERT INTO kgf_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","doku téfara yanda me komora meleŋu sac waŋu hima nemuac séc qahac wandarec. ");
INSERT INTO kgf_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Sék tuŋaguc méli énécmiyu hama awéénécmima inigic taŋa méli énécmiyu hama mebiri énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Waŋu padi imi kambiŋ onac buŋa qeyec. Waŋu aiiguc hicŋima heyec imi ʒikoŋ onac buŋa qeyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Waŋu waiŋ ic imi kombocnéŋ, saŋsaŋ ic imi siŋunecac doku saŋgeŋanéŋ unuyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Waŋu ama yaŋhécgina imi kombocac buŋa, rama yaŋhéra imi piliticac buŋa onoporec. ");
INSERT INTO kgf_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Qeri biric geriwaguc ʒéma qeri geric, ʒérabéra, tasé kukuac kua meme uŋahéra imuhucya méli énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Inéŋ qeri biric imi mewininimaŋ ʒé hénaya areŋgéma méndarec. Waŋu humucnéŋ qiʒiʒiŋgéma kemmu niŋac ménda wamma kekecgina imi wizi selia kuhaiguc onoporec. ");
INSERT INTO kgf_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Iʒipte baeciguc méréc merac, kucginawac hénihénia wawaŋa, Ham wac ama hali séc kecgic imi mocʒoŋ unuhumudarec. ");
INSERT INTO kgf_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Imuhuc wamma eŋeya ic embachéra imi rama ésécnec énépésima hama baec kéra kérasiaiguc rama tuŋ ésécnec qindiŋi énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Bénʒéŋnec walac andu waŋ énécmiyu ʒénéŋ hirihiri qahac kecgic, néŋ haʒéc hécgina ieneŋ imi konduŋiguc dokunéŋ téŋgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Waŋu baec téréya eŋeya méra héiyawac kuhanéŋ onagirec baec boŋa yomuaru ic embachéra imi onagicma hayec. ");
INSERT INTO kgf_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Waŋu baera baera imuac miŋina imi wéséginaiguc nesi énécmiyu keŋgic baec buŋagina ic suŋ qema méndéŋ énécmima Israel areŋa areŋa ama hali imuaru onoporu tacyac waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Néŋ kileŋ imi eneŋ eŋeŋa miŋina Anutu batucgéma acqeqe wamma héna acya imi ménda niŋtoho waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Yandahécgina ésécnec andé qeqe wamma haka biria waŋgic. Tewi merawa ɋariŋ ɋariŋgia muigic qelu qeluluma sigima keŋanʒac ésécnec andé qema keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Kemma baec boŋa eŋeŋa eŋeŋa séc ocmuŋ meyacgéma méraginanéŋ baniarawac ireha meyacgéma haima qeri biric mihicŋi migic. ");
INSERT INTO kgf_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Waŋu Anutunéŋ nimma qeri biric wamma Israel haʒéc kuneŋ yanda waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Waŋu Siloac ama hali téréya baec ic onac sucginaiguc hésicgéyec imi héŋara mema ");
INSERT INTO kgf_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","eŋeya kuha ʒéma eŋeya edamu asahawac buŋa héna acac katapa imi haʒéc hécgina ionac méraginaiguc haiyu mema keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Waŋu souac buŋa onopocma eŋeya buŋa ionac qeri geric waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Ɋapé wiliŋgina yaréac gericnéŋ onoyu humugic imuac niŋac seraŋa ionac muru ʒammaréŋac legic hétéŋa imi qahac wandarec. ");
INSERT INTO kgf_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Ionac hofac oo ic imi sou ʒéraiguc onoporu humudacgic. Waŋu neuŋ héiénécmiyu embac maléhécgina ʒésiac méŋ ménda waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Waŋu nalé imuaru Miŋ Kewunéŋ gau igucnec yacanʒu ésécnec yacma ic kawali waiŋ doku selianéŋ wammiyu qacanʒu ésécnec ");
INSERT INTO kgf_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","haʒéchéra ununesi waŋ énécmima gamu qeqe hémbénaŋa mihicŋi énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Yosefeac ama hali imuac méʒétiti wamma Eferaim areŋa imi ménda énépésima ");
INSERT INTO kgf_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Yuda areŋa ʒéma héŋsoroc wammimia Zion baec boŋanec sac énépésima ");
INSERT INTO kgf_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","eŋeya ocmuŋ téréya imi baec boŋa eŋeŋa ésécnec, baec hémbénaŋa hemac niŋ haiyec ésécnec meyacgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Waŋu eŋeya weleŋ qeqe icya Dawidi gésimimaŋ ʒé rama demiŋ qeriaiguc késayec. ");
INSERT INTO kgf_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","Waŋu rama namu nene imuac galeŋa imi wagicma eŋeya ai buŋa Yakoboac ɋelihéra Israel gumu énécmimac niŋac oporec. ");
INSERT INTO kgf_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Waŋu Dawidi inéŋ qeri hélanéŋ héŋgaleŋ waŋ énécmima méria welic welicgianéŋ galeŋgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Anutu, baera baera ieneŋ guac buŋaiguc haréma ocmuŋga téréya imi meʒapi qema Yerusalem mebiridacgic. ");
INSERT INTO kgf_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Ieneŋ weleŋ qeqehécga ionac qamoc imi sawa nei onac neniawac énécmima météré ichécga ionac séwigina imi yaŋ onac énécmigic neanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Sacgina imi Yerusalem leleclelec doku ésécnec qocgégic mayec. Waŋu qamocgina téŋgémuac icya méŋ ménda kerec. ");
INSERT INTO kgf_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Ama yanda lelec lelec imuac miŋina ionac ʒébiri qébiri imuac buŋa kecʒiŋ. Ieneŋ ʒédesi waŋ nénécmima isocfagociguc nonopocanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Yawe nalé dahecac séc? Hémbénaŋa qeri biric waŋ nénéc miwésémaŋ? Qeri biricganéŋ geric bélaŋ ésécnec nonomac me? ");
INSERT INTO kgf_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","7","Ieneŋ Yakoboac ama baecya imi mebirianʒu imuac niŋac Héŋgaleŋ amaya amaya gi ménda niŋgéŋanʒu imi onac ʒéma baera baera guac qacga ménda guruanʒu ionac mia qeri biricga qocgé énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Yanda hécninawac képésicgina niŋɋelima nonac muru ménda meleŋ nénécmiwésémaŋ. Nini maqeqeya gamu qeqeninaguc wamma kecʒiŋ. Ewa biric waŋ nénécmima tétécgé nénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Aŋgéŋ titi miŋina Anutu, guac qac buŋagawac niŋac méra nénécmina, guac qac buŋaga niŋac wamma metecgé nénécmima képésicnina waina. ");
INSERT INTO kgf_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Dimuhuciguc wai énécmina baera baera ieneŋ Anutugina imi dimia ʒénénzu? Weleŋ qeqehécga sac naec nénécmigic imuac bakia kicninaiguc baera baera meénécmina gi tasé kuku miŋina kecanʒaŋ imi niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Waina hésa ic ionac ʒésilacgina imi guac wéségaiguc hia harémac. Humucac buŋa qeénécmimia imi kucga yandanéŋ aŋgé tiénécmina kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Baera baera ic embac lelec lelec kecʒu ʒébiri qébiri waŋgéŋanʒu ionac imi taségina hatac 7ac séc meyandima meleŋ énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Imuhuc wanna ic embachécga rama héŋgaleŋ waŋ énécmimia nini hémbénaŋa ewa hia ac gézéma guac qac buŋaga hicŋisaiya hicŋisaiya énézéni hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","(Legic galeŋawac; Asafeac legic ʒéra, Legic ‘Ewa momacac baorac’ imuac ewaiguc.) Yosefeac ɋelihéra rama tuŋ ésécnec héŋgaleŋ waŋ énécmianʒaŋ, Israelac rama galeŋ gi, gezac qema niŋnénécmina. Kua meme uŋa Kerubim iorac sucgiraiguc kecanʒaŋ gi, asac mararaŋga qetagali nénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Eferaim ʒéma Benʒamin ʒéma Manase ionac wéséginaiguc kucga meɋelima mehiaru nénécmimaŋ ʒé hawésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Anutu acnina meleŋ nénécmina, guac kic tanecga asahagucnéŋ ninicna, aŋgéŋ titi guac murunec hahaya mihicŋiwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋa ionac Anutu Yawe, ic embachécga ionac ʒéwelecgina ménda niŋénécmima nalé dahecac séc qeri biric niŋnénéc miwésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Geŋ imi kic masigina imi nene ésécnec gumu énécmima kic masi sasala gumu énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Baera baera ic embac lelec lelec kecʒu ionac muru tohaliac buŋa nonopocna haʒéc hécnina ieneŋ eŋawu tacma desi nénécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋa ionac Anutu, acnina meleŋ nénécmima guac kic tanecga asahagucnéŋ ninicna aŋgéŋnina tinénécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Geŋ waiŋ ic momacguc Iʒipte baec igucnec mema hama baera baera ic embac imi nesina keŋgic baec imuaru himicnec. ");
INSERT INTO kgf_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Geŋ walac ʒéréŋqéréŋ wandacnec imuac niŋac ʒalianéŋ emu hiŋgacma baec késama sécgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Imuac amiyanéŋ baec boŋa hoturu énécmima imuac hawaya hawaya imi Anutuac yéménʒéc ic tanec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Hawa imi suluma kemma konduŋ késazac. Imuac hésia imi doku téfara Yufurataac séc kerenʒac. ");
INSERT INTO kgf_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Némac niŋ gi demiŋa imi héʒéŋgéna hénaiguc keŋha wanʒu imi eneŋ imuac héla gocmia metecgéanʒu? ");
INSERT INTO kgf_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Waŋu haséŋ bericnéŋ mebirigic haséŋ yaŋ eneŋ neanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋa ionac Anutu, ʒéwelecgénʒiŋ. Liliŋgéma kurumeŋ igucnec kic hina mayu hémma waiŋ ic imi héŋgaleŋ wammiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","Wariha imi méra héiganéŋ himicnec. Waŋu imi mia guac niŋac wamma meseli mimia waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Imi mia deguc qericma gericiguc ooya wanʒac. Geŋgaoc ac waŋ nénécmina ic embachécga imi biridacʒu. ");
INSERT INTO kgf_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Guac méra héigaiguc tacyac wawaŋa, guac niŋac wamma meyacna nanʒac ic iwac qahaiguc méraga haimina. ");
INSERT INTO kgf_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Imuhuc wanna nini imi guac murunec ménda waima kembiŋ. Meɋeli nénécmina nini qacga qacbiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋa ionac Anutu Yawe, meleŋ nénécmima guac kic tanecga asahagucnéŋ ninicna, nini aŋgéŋnina tinénécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","(Legic galeŋawac; Gitit waŋgoŋguc héimu. Asafeac legic ʒéra.) Kucnina Anutu imi ségiségi wamma kucnec qacma legic héimiwiŋ. Yakoboac Anutu ségiségi wamma hériaŋ héimiwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Legic ʒéra ʒéauma tambariŋ qema gita kulele momacnec hiabianec qemu. ");
INSERT INTO kgf_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Maso ɋeliawac témuŋ qemu. Maso bakianéŋ yandima howia waŋu kendoŋ aria naléiguc imuhuc wammu. ");
INSERT INTO kgf_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Imi mia Israelac ʒézé seli ac, Yakoboac Anutu iwac héna wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Anutunéŋ Iʒipte baec unumaŋ ʒé keŋec nalé imuaru Yosefeac areŋ ionac sucginaiguc ʒézé seli ac imi kumuyu naŋec. Ni imuaru ac méréra méŋ yomuhuc niŋi; ");
INSERT INTO kgf_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","Ni huaya igucnec hinac hetecgéma wagicmaŋ. Méria igucnec kodoc wagicba efima kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Gi ʒéra béraiguc qac héhélina metecgé gémma parandaŋ hétéŋaguc acga meleŋ gémma Meriba doku giŋgiŋaiguc batucgé géŋi. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Ic embachécna gezac qema niŋgic neŋ gorogina qema énézézua. Israel ini acna nimmu niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Sucginaiguc anutu tosara ménda onopocgic kecmu. Baera baera ionac anutuhécgina ménda sicgé énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Ni imi ini Iʒipte baec igucnec énépésima hayi onac Anutu Yawe wanʒua. Kuagina kuneŋnec aŋgégic kuaya qeénécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Nuac ic embachécna ieneŋ acna ménda niŋnémmu. Israel imi nuac niŋ ménda efimu. ");
INSERT INTO kgf_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Imuac ni ewa qerigina selia imi hezac séc wai énécmiwa hakagina siŋginawac sicsaoc wammu. ");
INSERT INTO kgf_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Ic embachécna imi eneŋ ni niŋtoho waŋ némmu niŋac wanʒua. Israel eneŋ nuac héna wamma memu niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Imuhuc waŋgic ni focdac haʒéc hécgina helanʒi énécmima mérana melemma haʒéc hécgina unumaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Yaweac méʒétiti waŋanʒu imi eneŋ ikoc wamma sicgémimu, néŋ taségina hémbénaŋa he énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Waŋu onac imi padi hiabia gumu énécmima morombazecac dokuya gumu énécmiwa niŋgic sécgémac. ");
INSERT INTO kgf_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","(Asafeac legic ʒéra.) Anutu imi nemu ionac sucginaiguc nammac. Waŋu anutu tosara sucginaiguc namma ʒégési énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Ini héna solaŋanec ménda ʒégési énécmima nalé dahecac séc ic biria ionac muru keŋhéi hahéi wammu? (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Maqeqeya ʒéma gupaŋ merac onac niŋac wamma ʒégési wammu. Yéwériginaguc ʒéma iwawai niŋac osiqosi wamma kecanʒu imi onac héna solaŋanec ʒégési énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Maqeqeya ʒéma mété qététaŋ kecanʒu imi aŋgéŋgina tima kaiʒiliweŋ ic ionac murunec metecgé énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","Ic biria imi eneŋ niŋtegic qiŋtegicgina qahac kecma siŋi qeriaiguc keŋha waŋgic baec qambaŋa mocʒoŋ hirima kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Ni énézéma ini mocʒoŋ anutu, eŋeŋa miŋinawac naŋhéra ʒéyi, ");
INSERT INTO kgf_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","néŋ ini ic eŋomia ésécnec humuma baec galeŋ tosara ésécnec maunudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Anutu yacma baec séc ic embac imi ʒégési énécmina baera baera ic embac imi mocʒoŋ guac buŋa wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","(Legic. Asafeac legic ʒéra.) Anutu, ac qahac ménda kecbésémaŋ. Acga ménda qaimac; ménda néŋ qemac. ");
INSERT INTO kgf_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Guac haʒéchécga ieneŋ hériaŋ haizu. Haʒéchécga ieneŋ orucgina meyacma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Ieneŋ ic embachécga unuwiŋ ʒé imuac héna humumia niŋareŋgéma geŋ musaŋgé énécmina kecʒu imi unuwiŋ ʒé eŋawu eminimma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Waŋu yomuhuc ʒéanʒu; Mebiri énécmini ionac héŋgaleŋ ama areŋa yanda imi muŋguc ménda meyacgému. Israelac qara imi eluŋ unudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Ieneŋ ewa momac wamma eminimma gi haʒéc waŋgémma acgina ʒikizu. ");
INSERT INTO kgf_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Ieneŋ imi Edomac ama hali ʒéma Isimael ic ʒéma Moap ʒéma Hagiri ic ");
INSERT INTO kgf_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","ʒéma Gebal ʒéma Ammon ʒéma Amalek ʒéma Tirowac tacyachéra, ");
INSERT INTO kgf_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","waŋu Asiria acguc iniguc toroqema Lot iwac ɋelihéra méra énécmizu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Gi imi Midian ic waŋ énécminec ésécnec, waŋu Kison doku téfaraiguc Sisera ʒéma Yabin onac waŋ énécminec ésécnec ionac acguc imuhuc waŋ énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","Ieneŋ imi Endoroiguc maunuyu baecac séʒéŋ wandacgic. ");
INSERT INTO kgf_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Ionac ic eŋeŋa imi waŋ énécmina, Orep ʒéma Ʒeep ésécnec wammu. Galeŋhécgina imi Ʒeba ʒéma Zalmunna ésécnec wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","Ieneŋ yomuhuc ʒéanʒu; Nini Anutuac rama baec imi onagicni nonac buŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Anutuna waŋ énécmina ieneŋ imi luhuc neŋgocyanéŋ seitotoŋ meyaru meleŋ qeleŋ waŋanʒac ésécnec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Gericnéŋ ic ʒuŋ ʒeanʒac ésécnec, waŋu geric bélaŋa baec boŋa ʒeanʒac ésécnec ");
INSERT INTO kgf_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","guac luhuc selianéŋ nesi énécmima guac luhuc humumianéŋ tericgé énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","Yawe, waŋ énécmina gamunéŋ kic tanecginaiguc sécgé énécmimac. Imuhuc waŋ énécmina ieneŋ guac qacgawac hoc hoc wammu. ");
INSERT INTO kgf_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Waŋénécmina gamuginaguc wamma aurima hémbénaŋa humu qai wammu. ");
INSERT INTO kgf_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Qacga imi Yawe wanʒac imi ʒéma gi sac baec séc ionac eŋeŋa miŋina kecanʒaŋ imi niŋtegicdacmu. ");
INSERT INTO kgf_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","(Legic galeŋawac; Korawac sac taséhéra ionac legic ʒéra.) Kurumeŋac téŋgiŋ ic tauseŋa tauseŋac Yawe, yei guac ama haliga imi héŋsorocya yanda. ");
INSERT INTO kgf_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Nuac kekec uŋananéŋ guac ama yanda demiŋaguc imuac niŋkumuma kecba séwi qerina momacnec kuc qahac waŋu kic ɋeli kecanʒac Anutu guac guru héhéli wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Nuac ic kewu, nuac Anutu, kurumeŋac téŋgiŋ ic tauseŋa tauseŋac Yawe, guac ocmuŋiguc reʒoreʒo nei acguc haecgina mihicŋiaŋgic ʒipilalec acguc haecgina mihicŋianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Guac amaiguc tacyac waŋanʒu imi eneŋ ʒézé ségiségi ginaguc. Ieneŋ imi nalé séc gi mepési gémma kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Guac murunec kuc mema ewa qerigina meefigic Zionac héna yanda béréŋgé énécmiyu kecanʒu imi eneŋ ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Ieneŋ imi baec wocwocya qara Baka imuacnec keremmu nalé imuaru doku hogocya sasala mihicŋianʒu. Waŋu kia nalé ménda ducŋiyunec hahaya imi acguc doku ʒékéŋa mihicŋi énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Ieneŋ imi kuc mema toroqema ogicma mema eŋac eŋac keremma guac baec boŋa Zioniguc, Anutuac wésiaiguc wininima nammu. ");
INSERT INTO kgf_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋac Yawe, ʒéwelecna niŋnénna. Yakoboac Anutu, gezac qema niŋna. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Saiwanina Anutu, gi halécnéŋ météré mimia iwac kic tanera imi hémma nimbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Guac ama yandagaiguc ai meme momacguc kekera iminéŋ ama tosaraiguc ai meme tauseŋ kekec imi qeyu mazac. Ic biria ionac ama yandaiguc kekec imuac nimba omaya wanʒac, néŋ guac amagawac saŋgulaŋ imuac galeŋdac wamma kekec imuac nimba eeyaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Yawe Anutu imi kaiwe ʒéma saiwanina waŋanʒac. Yawenéŋ ewa hia waŋ nénécmima kekec eeyaguc mihicŋi nénécmianʒac. Ikoc qahac kecanʒu ionac iwawai hiabia ménda aŋgé tiénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Kurumeŋac téŋgiŋ ic tauseŋa tauseŋac Yawe, guac héima naŋanʒu imi eneŋ ʒézé ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","(Legic galeŋawac; Korawac sac taséhéra ionac legic ʒéra.) Yawe, gi baecga yomuac ewa hia wammima Yakoboac areŋ hésa ic kecʒu imi onagicna liliŋgéma hagic. ");
INSERT INTO kgf_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Ic embachécga képésicgina imi wai énécmima képésicgina mocʒoŋ oso énécminec. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Qeri biricga imi mocʒoŋ waina keŋu, kimbeŋga imi qiʒiʒiŋgéna keŋu. ");
INSERT INTO kgf_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Aŋgéŋ titiac Anutu, acnina meleŋ nénécmina. Qeri biricga nonac muru hahaya imi waina qahac waŋu. ");
INSERT INTO kgf_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Geŋ imi hémbénaŋa qeri biric waŋ nénéc mima haʒéc waŋ nénéc miwésémaŋ me? ");
INSERT INTO kgf_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Meɋeli nénécmina ic embachécga guac niŋ wamma ségiségi wambiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Yawe goi héihéiga mewininina hémbiŋ. Waŋu aŋgéŋnina tina. ");
INSERT INTO kgf_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Inéŋ ic embachéra eŋeya météré ichéra luae qeénécmimac. Imuhuc wamma ieneŋ muŋguc képésic wambiŋ ʒé ménda liliŋgému niŋac meseli énécmimac. Imuac niŋac ac imuac me imuac Yawe Anutunéŋ ʒémaŋ ʒé wanʒac imi ni mocʒoŋ niŋtoho wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Hélacnec iwac aŋgéŋ titi ai imi eeya héimianʒu ionac muru hosuru hezac. Imuac niŋac odamuyanéŋ neŋaŋ baeciguc hemac. ");
INSERT INTO kgf_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Goi héihéi hémbénaŋa ʒéma haka héla iminéŋ aŋanʒaoc. Haka solaŋa ʒéma luaenéŋ kiricne amuzaoc. ");
INSERT INTO kgf_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Ac héla imi baeciguc doku éréanʒac ésécnec érézac. Haka solaŋa miŋinanéŋ kurumeŋiguc kicya hiyu maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Yawenéŋ iwawai hiabia nénécmiyu baecninanéŋ imuac héla gocmia haimac. ");
INSERT INTO kgf_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Haka solaŋanéŋ wéséyaiguc kemmac. Kemma iwac keŋkeŋ hahayawac héna héimindiŋi wammac. ");
INSERT INTO kgf_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","(Dawidiac legic ʒéra.) Yawe, ni kucna qahac, maqeqeya kecʒua. Gezac qema niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Eega héima kekera nuac qeri uŋana galeŋgé nénna. Miŋ Kewu Anutuna guac muru héima naŋanʒua. Weleŋ qeqe icga ni aŋgéŋna tina. ");
INSERT INTO kgf_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Ni kaiwe herec guac guru héhélizua, imuac wamma goina héina. ");
INSERT INTO kgf_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Miŋ Kewu, kekec uŋanawac kiwanéŋ hiwa éréyu génʒua. Weleŋ qeqe icga qeri uŋana ségiségi mihicŋi nénna. ");
INSERT INTO kgf_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Gi imi hiabia, ségiségi wamma képésic wai énécmianʒaŋ. Waŋu guac guru héhélima kecanʒu ionac goigina héianʒaŋ imuac niŋac imuhuc ʒéwelecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Yawe, nuac ʒéwelecnaiguc gezac qema niŋna. Ʒéwelecna selia niŋsima gézézua imi niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Nuac ʒérabéra naléiguc ni guac guru héhélizua. Gi nuac niŋnémbésémaŋ ʒéma ninʒéŋgézua. ");
INSERT INTO kgf_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Miŋ Kewu Anutu nemu ionac sucginaiguc guac séc méŋ ménda kecʒac. Méŋnéŋ méŋ wawaŋ memega imuac séc méŋ ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Héŋgaleŋ ama areŋa areŋa geŋ ʒéna hicŋima hezac mocʒoŋ wéségaiguc hama odamuga mepési gémmu. ");
INSERT INTO kgf_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Gi imi kuneŋ yanda imuac kiwi welic welicgia meanʒaŋ. Gi sac Anutu kecʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Yawe guac héna nézéna niŋareŋgémaŋ, ni guac ac héla méndacma kemmaŋ. Ewana momacguc waŋu qacga eeya héigémmaŋ niŋac méra nénna. ");
INSERT INTO kgf_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Nuac Anutu, ni ewa mocʒoŋnec legic héigémma hémbénaŋa guac qacga mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Imi mia goi héihéiga nuac hezac imi kuneŋ yanda waŋu kekec uŋana humucac déc igucnec metecgé nénnec imuac niŋac mia imuhuc waŋgémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Anutu, séwi eŋeŋ ic eneŋ yacma ni nuwiŋ ʒé wanʒu. Kaiʒiliweŋ ic tuŋagucnéŋ qeri uŋanawac hochoc ai megic. Waŋu ieneŋ guac niŋac niŋ éréhéc ménda wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Waŋu gi imi goi héihéiac Anutu, qeri biric focdac ménda wamma goi héihéi ʒéma haka héla iminéŋ guac muru sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Nuac liliŋgéma hama weleŋ qeqe icga ni meseli némma guac weleŋ qeqe embacgawac naŋa ni imi humuc igucnec metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Ewa hiagawac asé kiwiya imi mewininina hémba. Imuhuc waŋ nénna haʒéc waŋ nénʒu imi eneŋ gamugina nimmu. Yawe gi imi méra némma mebélacgé néŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","(Korawac sac taséhéra ionac legic ʒéra.) Inéŋ baec boŋa téréyaiguc tacyac waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Yawenéŋ Yakoboac tacyacac buŋa tosara onogicma Zionac nagu imuac siŋa niŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Anutuac ama areŋa yanda, guac ʒéma edamugaguc ʒéanʒu. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Ni niŋnéŋanʒu ionac sucginaiguc Rahab ʒéma Babilon hezaoc ʒémaŋ. Filisitia, Turo ʒéma Kusi imi acguc imuhucyanec Zion igucnec hicŋihicŋiya ʒéénécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Eŋeŋa miŋina eŋeyaoc Zion imi meyacgémac imuac niŋac Zionac yomuhuc ʒému; Ic yomi me imi imuacnec hicŋi hicŋiya. ");
INSERT INTO kgf_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Yawenéŋ ic embac qacgina oma ʒaŋgégina olomma ic yomi acguc imuacnec ʒémac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Legic héima hirianʒu imi eneŋ yomuhuc ʒému; Doku kiwana imi mocʒoŋ guac muru hezac. ");
INSERT INTO kgf_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","(Legic galeŋawac; Korawac sac taséhéra ionac legic ʒéra, Kuŋaguc.) Yawe, nuac aŋgéŋ titiac Anutu, ni siŋi kaiwe wéségaiguc guru héhélianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Nuac ʒéwelecnanéŋ guac wéségaiguc érémac niŋ wanʒua. Guru héhéliwa gezac qema niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Kekec uŋana imi yéwérinéŋ sécgé néŋu, kekecna imi humucac déciguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Nuac niŋgic ic kic suaŋiguc hiŋgac hiŋgarawac tanec kuc mama wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Ni imi humuc ic ionac sucginaiguc gilinénéŋa ésécnec. Nuhumugic kic suaŋ qeriaiguc heheya ésécnec. Humuc ic imi guac méra igucnec elicgé énécmimia, imuac niŋac gi imi ionac ménda niŋɋeli énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Gi imi ni baec séséŋ horua dumuc sira tunumaŋiguc nopocnec. ");
INSERT INTO kgf_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Guac qeri biricganéŋ ni réwérianec helanʒi nénʒac. Doku temboŋganéŋ nuagickeŋ nuagicha waŋ nénʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Ni niŋnéŋanʒu imi mocʒoŋ énézéna lakec kendacgic. Wainéŋna kekecnawac niŋgic qaorac qeqeya wanʒac. Ni imi nagu héinénéŋa waŋu, néŋgacma kemmaŋac séc qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Niŋ yéwérima kecba kicna mugu mizac. Yawe ni naléya naléya guac guru héhélima kecma méra éréhécna meyacma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Gi imi dimuhuc humuc ic ionac kiwi welic welicgia waŋ énécmina hia hémmu? Uŋaginanéŋ yacma gi hia mepési gémmu me? ");
INSERT INTO kgf_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Guac goi héihéiga imi kic suaŋ qeriaiguc, waŋu guac haka héla imi humuc ic ionac sucginaiguc hia ʒéau énécmimia wammac me? ");
INSERT INTO kgf_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Tunumaŋ qeriaiguc guac haka welic welicgia, waŋu baec eluŋ unuunuyaiguc guac haka solaŋa imi hia nimmu me? ");
INSERT INTO kgf_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Yawe ni guacnec sac guru héhéli génʒua. Siŋunec nuac ʒéwelecnanéŋ guac muru érémac. ");
INSERT INTO kgf_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Yawe némac niŋac nuac qeri uŋana imi waizaŋ? Némac niŋac guac kic tanecga musaŋgé nénʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Ni komocna igucnec yéwéri mihicŋima hakecma deguc humucac déciguc kecʒua. Bac yandi yandi mihicŋi néŋna niŋkinʒéŋna imi héla qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Guac qeri biricnéŋ hoturu nénʒac. Guac nimba ʒénéŋ hirihirinanéŋ bacna mésénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Haka imuhucya imuhucyanéŋ doku ésécnec kaiwe herec lelecgé némma momacnec hoturu nénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Geŋ imi ala sorochécna nuac murunec elicgé énécmina lakec kendacʒu. Tunumaŋnéŋ nuac ala sorochécna ésécnec niguc qéqéhéréŋ kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","(Eʒera ic qara Etanac Masikil legic.) Ni Yaweac goi héihéiya imi nalé tetecgia qahac legic héigémmaŋ. Guac haka héla imi kuananéŋ énézéwa hicŋisaiya hicŋisaiya hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Ni yomuhuc ʒéau énécmimaŋ; Goi héihéiga hémbénaŋa seligima naŋanʒac. Hakaga héla imi kurumeŋiguc kumuna seligima naŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Waŋu geŋ yomuhuc ʒénec; Ni nuac gésimimia i guc sisipac ac memaŋ. Weleŋqeqe icna Dawidiac sipacgéma yomuhuc ʒéyi; ");
INSERT INTO kgf_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","Neŋ ɋelihécga meseli énécmima guac ic kewu tatacga edamuyaguc imi kumuwa hicŋisaiya hicŋisaiya hema emma kecmac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Yawe guac haka welic welicgia imi kurumeŋ eneŋ mepésimu. Waŋu hakaga héla imi météré énécmimia ieneŋ kurumeŋac hénaoriŋ sucginaiguc mepésimu. ");
INSERT INTO kgf_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Sawaiguc mérénéŋ Yaweac séc wammac? Uŋa kucginaguc ionac sucginaiguc mérénéŋ Yaweac séc wammac? ");
INSERT INTO kgf_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Anutunéŋ kurumeŋac météré ic ionac aʒoaʒoroiguc eeyaguc yanda waŋu lelecgé mimia mocʒoŋ onogicma bac yandi yandi wammiwiŋac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Yawe, kurumeŋac téŋgiŋ ic tauseŋa tauseŋa ionac Anutu, mérénéŋ gi éséc kuhaguc wammac? Haka hélanéŋ lelecgé gémma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Geŋ mia konduŋ temboŋaguc galeŋgéanʒaŋ. Temboŋ yaru geŋ ʒéna néŋ qeanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Gi Rahab imi qegic bec humuma hayec ésécnec efefianec qéséŋnec. Haʒéchécga imi méragawac kuhanéŋ héndéŋ énécminec. ");
INSERT INTO kgf_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Kurumeŋ imi guac, baec imi acguc guac. Baec kurumeŋ ʒéma imuac qeriaiguc iwawai sécgéma hezac imi mocʒoŋ geŋ ʒéna hicŋidarec. ");
INSERT INTO kgf_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Baec waŋgoŋa Not ʒéma Saut imi geŋ ʒéna hicŋiyec. Saut baec boŋa Taboro ʒéma Not baec boŋa Helmon imi qacgawac niŋac ségiségi wanʒaoc. ");
INSERT INTO kgf_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Guac méraga imi kuha yanda, guac méraga imi selia, waŋu méra héiga imi eŋeŋa. ");
INSERT INTO kgf_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Hakaga solaŋa ʒéma ʒégésigésiga solaŋanéŋ tatacga edamuyaguc imuac qambaŋa wanʒac. Goi héihéiga hémbénaŋa ʒéma hakaga héla iminéŋ wéségaiguc heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","O, Yawe hériaŋ héigémma imuac hénia niŋtegicanʒu imi eneŋ ségiségi ginaguc. Ieneŋ imi kic tanecga asahaiguc keŋha wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Imuhuc wamma kaiwe herec qacgawac ʒézé ségiségi wanʒu. Waŋu imi eneŋ imi hakaga solaŋa niŋac meyac énécmimia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Gi imi ionac kucginawac edamuya wanʒaŋ imuac niŋac imuhuc waŋanʒu. Ilicninanéŋ ewa hiaga niŋac yandima eŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Saiwanina imi Yaweac muru hezac. Ic kewunina imi Israelac téréya miŋina iwac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Becnec qeri uŋawac haka méŋ hicŋi énécmiyu héŋgic imuacnec météré ichécga yomuhuc énézénec; Ni méra énécmimiawac kuha ic kawali méŋac mima i ic embachéra ionac sucginaiguc meyacba eŋec. ");
INSERT INTO kgf_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Ni weleŋ qeqe icna Dawidi mihicŋima haléc téréya qocgémiyi. ");
INSERT INTO kgf_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Mérananéŋ iguc ʒéŋgé toroya qahac hemac. Huananéŋ meseli mimac. ");
INSERT INTO kgf_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Ic imi haʒécya méŋnéŋ méŋ eŋeya méra bawaiguc opocmacac séc qahac. Ic biria méŋnéŋ méŋ helanʒi mimacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Ni wésiaiguc haʒéchéra mebiri énécmima haʒéchéra unudacmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Hakana héla ʒéma goi héihéinanéŋ i guc momacnec hemac. Qacnawac niŋac ilihanéŋ yandimac. ");
INSERT INTO kgf_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ni méria meyacba konduŋ qaha ʒéma doku téfara séc qahaiguc hemac. ");
INSERT INTO kgf_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Imuhuc wammiwa inéŋ nuac nézéma ʒémac; Gi imi nuac maŋgocna, nuac Anutu, aŋgéŋ titiac ʒamanʒiŋna. ");
INSERT INTO kgf_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Ni imi i méréc meracna kumuwa inéŋ baec séc ic kewu ionac orucgina wammac. ");
INSERT INTO kgf_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Iwac niŋ wamma goi héihéi wammima kecmaŋ. Sisipac ac ic imiguc memeya imi selianec meseligiwa hekecmac. ");
INSERT INTO kgf_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Waŋu ɋelihéra waŋ énécmiwa hémbénaŋa hicŋisai wamma kecmu. Waŋu ic kewu tatacya naléya mehorugiwa kurumeŋa kurumeŋanéŋ nalé horua heanʒac ésécnec horua hemac. ");
INSERT INTO kgf_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Ɋelihéra ieneŋ héna acna waima ʒézé seli acnawac séc niŋtoho ménda wamma ");
INSERT INTO kgf_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","héna acna mesohoma ʒézé seli acna ménda niŋtoho wammuiguc imi ");
INSERT INTO kgf_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","ɋarucnanéŋ képésic ginawac unumindiŋi énécmima hihilocnéŋ haka biriagina unumindiŋi énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Waŋu kileŋ goi héihéina mocʒoŋ ménda wagicma hakana héla wammima ikoc ménda wammimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Sisipac acna ménda auma ac kuananéŋ ʒéhicŋiyi imi ménda melemmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Hakana téréyanéŋ hatac momacguc ʒéseliwa heyecac hezac. Dawidi ac ikoc ménda wammimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","Ɋelihéra imi eneŋ hémbénaŋa hicŋisai wamma kecmu. Ic kewu tatacyanéŋ kaiwe ésécnec wésénaiguc nalé tetecgia qahac hema kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Waŋu sawawac héipuc ic qekeŋ qehaya qahac nanaŋa maso ésécnec hémbénaŋa seligima nammac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Néŋ gi kileŋ halécnéŋ météré mimia imi qeri biric kuneŋ yanda wamma ʒésure wammima héŋara menec. ");
INSERT INTO kgf_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Weleŋ qeqe icgawac sisipac ac imuac méʒéga tiyu ic kewu opocya imi baeciguc gilina qaurac qezac. ");
INSERT INTO kgf_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Waŋu demiŋa imi héʒéŋ gédacma neuŋ kiropo selia imi mebiridacʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Imuac héna keŋkeŋ haha waŋanʒu imi eneŋ kisikiyoŋ qemigic ama lelec lelec ieneŋ imi isocfagociguc opocanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Geŋ imi haʒéchéra ionac méra héigina imi meyac énécmina eŋu haʒéc eneŋ mocʒoŋ ségiségi wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Waŋu iwac souya mebirina ʒéra qahac waŋu yaréiguc kemmacac séc qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Edamuya auna tecgéyu ic kewu tatacya imi meleŋna baeciguc mazac. ");
INSERT INTO kgf_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Iwac sac ɋeli naléya imi meducŋima gamunéŋ qacyaiguc haina enʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Yawe nalé dahecac séc me? Geŋgaoc hémbénaŋa musaŋgé amuwésémaŋ? Nalé dahecac séc qeri biricga geric bélaŋa téma ʒeanʒac ésécnec waŋ némbésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Yei naléna hotoŋa dac wanʒac imi niŋɋeliwésémaŋ. Gi imi baec ic mocʒoŋ mihicŋi énécmima imuhuc wai énécmina kekecgina yei gorosoŋa ésécnec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Mérénéŋ kecma humuc ménda mihicŋima hémma eŋeya qeri uŋaya humucac kuha igucnec hia metecgé amumac? (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Miŋ Kewu hakaga héla iminéŋ Dawidi sisipac ac wamminec. Waŋu imuac goi héihéi becnec heaŋec imi dimuaru keŋ saŋgizac? ");
INSERT INTO kgf_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Weleŋ qeqe ichécga ʒébiri qébiri wammianʒu imi niŋɋelina, kucginaguc hicŋi saima kecʒu momac yanda ionac ʒébiri qébiriginanéŋ nuac wésénaiguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Yawe ʒébiri qébiri imi mia haʒéc hécganéŋ guac halécnéŋ météré wammimia inéŋ tima keŋec héna imuac mia ʒébiri qébiri wammizu. ");
INSERT INTO kgf_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Yawe, hémbénaŋa mepésimini, hélacnec! hélacnec! ");
INSERT INTO kgf_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","(Anutuac icya Moseac ʒéwelec welec.) Miŋ Kewu, guac niŋni gi imi hicŋisaiya hicŋisaiya nonac tacyacninawac ama ocmuŋ wanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Baec boŋa ménda hicŋigicnec, baec kurumeŋ ménda ʒéna hicŋiyunec hémbénaŋa igucnec hémbénaŋa gi imi Anutu kecanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Geŋ ʒéna ic embac eneŋ liliŋgéma seitotoŋ waŋanʒu. Geŋ mia baec ic ini liliŋgéma kemmu ʒénec. ");
INSERT INTO kgf_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Kicgaiguc yawuŋ tauseŋa imi oraŋ ésécnec hotoŋa waŋu siŋi bakia tanec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Geŋ mia doku ɋaoŋ ésécnec luma usuŋénécmima keŋanʒaŋ. Ieneŋ imi gau héhéŋ ésécnec, ʒariŋ siŋunec ʒuria qeanʒac ésécnec wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Ʒariŋ imi siŋunec ʒuria qema heyu kaiwenéŋ qeyu mariyaiguc sélécgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Nini imi guac qeri gericnéŋ nonoyu ʒema qahac wanʒiŋ. Waŋu guac qeri gericnéŋ hoturu nénécmizac. ");
INSERT INTO kgf_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Geŋ mia képésicnina wéségaiguc haima, hakanina biria saŋa imi kic tanecgawac asahaiguc haianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Nalénina mocʒoŋ imi qeri biricgawac qeriaiguc qahac waŋanʒac. Kekecnina howianéŋ wésénina ésécnec tecgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Yawuŋnina imi 70, waŋu tosara kucginaguc imi 80 wanʒac. Waŋu imuac surucya imi bisi qatéŋ ʒéma ʒésiac. Waŋu imi focdac keŋu nini putitima keŋ humuanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Mérénéŋ qeri gericgawac kuha hia niŋtegicmac? Mérénéŋ héniaga séha niŋtegicma bac yandi yandi wammac? ");
INSERT INTO kgf_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Ku nénécmina nalénina hia olomma niŋtegic qiŋtegic ewa qerininanéŋ doŋgéma kecbiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Yawe, némac naléiguc hawésémaŋ? Focdac liliŋgéma hana. Weleŋqeqe ichécga goi héihéi waŋ nénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Siŋunec guac goi héihéiganéŋ mesécgé nénécmina kekecninawac nalé howia séc ʒézé ségiségi wamma kecbiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Yéwéri mihicŋi nénécminec imuac naléya mocʒoŋ ʒéma qeri biric waŋ nénécminec imuac yawuŋ mocʒoŋ toroqema imuac séc ʒézé ségiségi mihicŋi nénécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Wawaŋ memega weleŋ qeqe ichécga ionac muru mewinini énécmima guac edamuga imi ɋelihécgina ionac muru mewinini énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Miŋ Kewu Anutuninawac ewa hia imi neŋaŋ muru haina mayu. Méraninanéŋ wamma meanʒiŋ imi meseligina nammac. O, méraninanéŋ wamma meanʒiŋ imi meseligina nammac. ");
INSERT INTO kgf_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Eŋeŋa miŋinanéŋ hoturumiyu saŋgima kecanʒac imi wandac wandac miŋinawac amiaiguc kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Ni Yaweac yomuhuc ʒéanʒua; Inéŋ saŋgi saŋgina, ʒéma neuŋ kiropo selina; Anutu iwac muru mia héima naŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Imuac mia inéŋ nei késakésa ic ionac ufic igucnec ʒéma yaŋhafi warihaguc humumia imuacnec metecgé gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Inéŋ gi kuruc neŋgocya ésécnec qeŋgaŋ ʒucyanéŋ hoturugéŋu qeŋgaŋa bawaiguc kemma saŋgiwésémaŋ. Imuhucyanec iwac haka héla iminéŋ saiwaga ʒéma asamaŋga ésécnec héʒicgé gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Gi imi siŋiyawac ʒéra imuac bac yandi yandi ʒéma kaiweac ʒakoŋ muigic hahaya imuac ʒénéŋ hirihiri ménda wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Yaŋhafi wariha tunumaŋiguc hahaya ʒéma kisi kiyoŋ kaiweiguc hicŋi hicŋiya imuhucyawac bac yandi yandi ménda wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Tauseŋ me 10 tauseŋnéŋ wésé andégaiguc mama humuwu, néŋ gi imi saec imuhucyanéŋ ménda hosucgé gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Gi imi kaiʒiliweŋ ic ieneŋ bakia megic kicganéŋ inicbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Gi imi Yawe aŋgétina saŋgi saŋgigawac buŋa wanʒac. Eŋeŋa miŋina aŋgétina tacyacgawac ama ocmuŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Imuac niŋac ʒérabéra guac muru ménda haréma yaŋ hafinéŋ ama haliga hosuraiguc ménda hosucgémac. ");
INSERT INTO kgf_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Inéŋ guac wamma kua meme uŋahéra énézéyu héna keŋkeŋ haha waŋanʒaŋ imuaru galeŋgé gémmu. ");
INSERT INTO kgf_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Ieneŋ méraginanéŋ gépésigic hénaga imi hocnéŋ ménda héimac. ");
INSERT INTO kgf_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Gi imi laion ʒéma qaté mokoleŋ tidacgéwésémaŋ. laion sacɋeli ʒéma mokoleŋ hénaga bawaiguc tidacgé énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Anutunéŋ yomuhuc ʒézac; Inéŋ goina héianʒac imuac aŋgéŋa timaŋ. Inéŋ qacna niŋnéŋanʒac imuac i meyacmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Inéŋ ʒéwelecnéŋu acya meleŋ mimaŋ. Ʒérabéra naléiguc i guc momacnec kecma metecgé mima méra miwa eebipiyaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Yawuŋa mehorugiwa niŋu sécgémac. Waŋu aŋgéŋ titiac ai ézéwa hémmac. ");
INSERT INTO kgf_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","(Legic ʒéra, Sabata naléiguc héihéiyawac legic.) Eŋeŋa miŋina Yawe, ewa hia ac gézéma guac qacga kikicmeloŋ legiciguc héigéŋgéŋa imi hiabia. ");
INSERT INTO kgf_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Siŋunec goi héihéiga ʒéauma siŋiyaiguc hakaga héla imuac ʒéauauya imi hiabia. ");
INSERT INTO kgf_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Gita kulele ʒéma waŋgoŋ qema mepési géŋgéŋa imi hiabia soroc. ");
INSERT INTO kgf_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Yawe, wawaŋ memeganéŋ ségiségi mihicŋi nénʒaŋ. Ni méragawac haka silic niŋac ewana meyacma mepési génʒua. ");
INSERT INTO kgf_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Yawe, wawaŋ memega imi yei kuneŋ yanda. Guac niniŋga imi yei kuneŋ yanda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Ic diwi qiwiliŋa imi ménda niŋasarianʒac. Ic sicsaocya imi ménda niŋtegicanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Ic biria imi ɋézézac ésécnec saigic. Kaiʒiliweŋ ic eneŋ kindindiŋ ginaguc wanʒu, néŋ kecma hémbénaŋa birima qahac wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Yawe, gi imi hémbénaŋa eŋeŋa miŋina wanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Niŋʒaŋ? Haʒéchécga, O, Yawe, haʒéchécga ieneŋ kileŋ biridacmu. Képésic meme ic imi héndéŋ qéndéŋ waŋ énécmimia wammac. Imuac mia imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Waŋu geŋ imi ilicna haséŋ burumakao ésécnec meyac néŋanʒaŋ. Haléc hiabia orucnaiguc qocgé nénʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Haʒéchécna haka biriawac bakia megic kicnanéŋ inicanʒua. Yacma nuanʒu imi tasia biria mezu ʒégic gezacnanéŋ niŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Ic solaŋa imi yéménʒéc ic ésécnec loŋgo biacbiac wamma Lebanoŋac sida ic ésécnec yandimu. ");
INSERT INTO kgf_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Yaweac ama, Anutuninawac ama yandaiguc himicgic loŋgo biacbiac wamma nanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Waŋu ic yanda wammaguc kileŋ héla haianʒu. Dokugina ménda ʒicgéyu téŋgiŋ téŋgiŋ waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Yawe hakaga dindiŋa imi mewininina. Yawe imi nuac ʒamanʒiŋ. Iwaru imi képésic méŋ ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Yawenéŋ héŋgaleŋ wamma eŋeyaoc héŋgaleŋ aiac kuha héiamuyu eeyaguc wanʒac. Yawe imi kuhanéŋ séwi usuya ʒéma rikuŋa héiamuzac. Imuac baec kurumeŋ kumuyu qekeŋ qehaya qahac seligima nammac. ");
INSERT INTO kgf_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Gi imi nalé hémbénaŋa igucnec kecnecac kecʒaŋ. Ic kewu tatacga imi becarunec héitumuna seligima tacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Yawe doku yandanéŋ luma yacʒac. Doku yandanéŋ luma hétéŋa meyacʒac. Doku yandanéŋ luma géréréc mericʒac. ");
INSERT INTO kgf_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Ou eŋeŋa tacanʒaŋ, Yawe guac kucga imi doku qara ʒéma konduŋ temboŋ yanda ogicma kuneŋ yanda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Yawe, ackuaʒécga imi héla téŋgéŋ. Téréyaganéŋ amaga meʒericna sécya waŋu hémbénaŋa hema kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Yawe, tasé kuku miŋina Anutu, bakia meleŋmeleŋ miŋina Anutu, geŋ asac mararaŋ qetagaliwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Yacna, baec yandawac ʒégésigési miŋina gi. Yacma séwi eŋeŋ ic tasé ku énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Yawe, ic biria eneŋ nalé dahecac séc hériaŋ haimu? Némac naléiguc haka imi tecgémac? ");
INSERT INTO kgf_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","Ieneŋ séwi eŋeŋ wamma ʒébiri qébiri waŋanʒu. Biria meme ieneŋ mocʒoŋ séwi eŋeŋ wamma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Yawe, ieneŋ ic embachécga qéʒéŋgé unuma guac buŋa imi helanʒi énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Embac malé ʒéma, ic kiaŋ unuhumuma, gupaŋ merac unuhumuanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Imuhuc wamma yomuhuc ʒéanʒu; Yawe imi ninicmacac séc qahac. Yakoboac Anutu imi niniŋa qahac. ");
INSERT INTO kgf_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Ic embac sucginaiguc ic qelaŋa kecʒu ini qeriginanéŋ niŋgic. Niniŋgina qahac ini, némac naléiguc niŋtegic qiŋtegic ginaguc wammu? ");
INSERT INTO kgf_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Gezacnina meyacgé nénécmiyec inéŋ acnina hia ménda nimmac me? Kicnina meyacgé nénécmiyec inéŋ hakanina hia ménda hémmac me? ");
INSERT INTO kgf_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Baera baera bakia meénécmima ic pakeŋ ac ku nénécmianʒac inéŋ niniŋa qahac ʒéma ninʒu me? ");
INSERT INTO kgf_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Yawenéŋ ic onac niniŋgina nindacʒac. Niniŋgina imi gorosoŋa wanʒac imi nindacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Yawe, gi ʒéqindiŋi mianʒaŋ ic imi ʒézé ségiségiyaguc. Héna acganéŋ pakeŋ ac wammianʒaŋ ic imi ségiségiyaguc. ");
INSERT INTO kgf_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Ic imi ʒérabéra naléiguc metecgé mima luaeiguc opocna kerunec, ic biria ionac imi baec séséŋ éséénécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Yawenéŋ ic embachéra ménda wai énécmianʒac. Waŋu eŋeya buŋa héŋacgina ménda meanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Ʒégésigési imi haka solaŋaiguc liliŋgéma hamac. Hayu ewa qerigina solaŋanec kecanʒu imi eneŋ mocʒoŋ qeriginanéŋ méndacmimu. ");
INSERT INTO kgf_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Mérénéŋ nuac niŋ yacma biria meme ic unumac? ");
INSERT INTO kgf_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Yawenéŋ ménda méra némbacnec kekec uŋananéŋ bec humuma néŋ qema kecbacnec. ");
INSERT INTO kgf_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Yawe, hénana tisuracgéyi nalé imuaru goi héihéiganéŋ ni népésinec. ");
INSERT INTO kgf_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Qerinaiguc niniŋ sasala hicŋinéŋu guac mebélac qebélac ainéŋ kekec uŋanaguc ségiségi mihicŋi néŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Héna aciguc koroma haka biria waŋanʒac gésigési ic kiwa biria imuhucyanéŋ dimuhuc giguc ala kekec wammac? ");
INSERT INTO kgf_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Ieneŋ tocgéma ic solaŋawac kekecya qewiŋ ʒé wamma ic képésicya qahac imi képésiraguc ʒéma ʒétecgéma sac naecmianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Yawe imi neuŋ kiropo selia baec boŋaiguc nanaŋa. Nuac Anutu imi ʒamanʒiŋ selia, réwéri igucnec néŋgacma imuaru saŋgianʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Képésicgina meleŋ énécmina ionac muru liliŋgéma kemmac. Haka biriagina niŋac mebiri énécmina qahac wandacmu. Yawe Anutunanéŋ mebiri énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Hagic nini Yawe legic héimima, neŋaŋ aŋgéŋ titiac ʒamanʒiŋ ségiségi wamma legic héimiwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Ewa hia ac ézéma wésiaiguc kemma legic ʒéra ʒéni iwac muru kemmac. ");
INSERT INTO kgf_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Yawe imi Anutu kuneŋ yanda, anutu mocʒoŋ ionac qacginaiguc eŋeŋa kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Baec hiŋgac hiŋgara imi mériaiguc hezac. Baec boŋa eŋeŋa acguc iwac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Konduŋ imi iwac, inéŋ ʒéyu hicŋiyec. Waŋu baec acguc mérianéŋ meyec. ");
INSERT INTO kgf_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Hagic nini sicgéma mepésimima, kekecnina mihicŋi nénécmiyec Yawe iwac muru simiŋ héimiwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","I imi Anutunina, nini imi ic embachéra, rama tuŋa mériaiguc ono onopora. Ini nalé yomuaru ewaya nimbiŋ ʒé wanʒuiguc imi; ");
INSERT INTO kgf_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","Meriba ʒéma baec kérakérasia Masa imuac nalé ésécnec ewa qerigina seliseli ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Nalé imuaru yandahécgina ni batucgé némma awinémma wawaŋ memena imi héŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Ni yawuŋ 40 séc hicŋisai imuac niŋyéwécnaguc wamma ʒéyi; Ieneŋ imi ic embac ewagina soho sohoya, nuac héna imi ménda ninʒu. ");
INSERT INTO kgf_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Imuac ni qeri biric wamma ʒéselima ʒéyi. Ieneŋ nuac tac hiahiaruiguc harémuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Legic ɋelia Yawe héimigic. Baec séc ic embac Yawe legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Yawe legic héimima qara mepési migic. Aŋgéŋ titi ai imuac naléya naléya ʒéau énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Edamuya imi baera baera ionac. Waŋu kiwi welic welicgia imi ic embac momac yanda ionac ʒéau énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Yawe imi kuneŋ yanda, imuac niŋac hélacnec mepésimimu. Anutu tosara mocʒoŋ onogicma eeya héimimu. ");
INSERT INTO kgf_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Anutu baera baera kecʒu imi mocʒoŋ eŋomia. Tosara qahac, néŋ Yawe inéŋ mia kurumeŋ ʒéyu hicŋiyec imuac mia imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Eeya eŋeŋa ʒéma ic kewuac ɋarucnéŋ iwaru hezac. Kuha ʒéma héŋsorocyanéŋ iwac ocmuŋ téréyaiguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Yawe ʒézé ségiségi wammigic. Baera baerawac ic embac hénia hénia ini, edamuya ʒéma kuha imuac Yawe ʒézé ségiségi wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Yaweac qara eeyaguc imuac séciguc edamuyawac ʒézé ségiségi wammigic. Sesegina mema iwac ama yandaiguc keremmu. ");
INSERT INTO kgf_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Héŋsorocya ʒéma téréya niŋac wamma Yawe mepési mimu. Baera baera iwac wésiaiguc ʒénéŋ hirihiri wammu. ");
INSERT INTO kgf_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Baera baera sucginaiguc ini yomuhuc ʒému; Yawenéŋ héŋgaleŋ wanʒac imuac baec momac yandanéŋ seligima qekeŋ qeha ménda wammu. Inéŋ ic embac momac yanda héna ac hezac séc dindiŋanec ʒégési énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Kurumeŋ imi ségiségi waŋu baec imi ʒézé ségiségi waŋu konduŋ ʒéma iwawai imuac qeriaiguc sécgéma hezac imi hériaŋ haimimu. ");
INSERT INTO kgf_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Nene ai lépaya lépaya ʒéma iwawai imuaru hezac imi mocʒoŋ ségiségi wammu. Imuhuc waŋgic ʒuŋiguc ic hésa acguc Yaweac wésiaiguc ségiségi wamma legic héimu. ");
INSERT INTO kgf_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Inéŋ hamac. Baec ʒégési énécmimaŋ ʒé hamac. Inéŋ solaŋanéŋ baec yanda ʒégési énécmima ikoc qahac, néŋ hélacnec ic embachéra ʒégési énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Yawenéŋ héŋgaleŋ waŋ énécmimac. Imuac baecnéŋ ségiségi waŋu konduŋiguc baec komoc komoc imi acguc ʒézé ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Hosusu ʒéma tunumaŋnéŋ lelecgémizac. Haka solaŋa ʒéma ʒégésigési solaŋa iminéŋ ic kewu tatacyawac qambaŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Geric bélaŋanéŋ wésia igucnec hicŋima haʒéchéra yanda lelec lelec kecʒu onodacmac. ");
INSERT INTO kgf_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Iwac piliticnéŋ baec séc keŋ qetagaliyu baecnéŋ hémma ʒénéŋa hirizac. ");
INSERT INTO kgf_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Baec boŋaya boŋaya iminéŋ Yawe baec yanda miŋina iwac wésiaiguc kufaŋ ésécnec pépélima mazac. ");
INSERT INTO kgf_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Kurumeŋnéŋ iwac solaŋ dindiŋa ʒéauyu ic embac mocʒoŋ edamuya héŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Anutu méraginanéŋ seima memeya weleŋ qemima iwawai eŋomia niŋac séwi eŋeŋ waŋanʒu imi eneŋ mocʒoŋ gamuginaguc wammu. Anutu sasala ini Yawe mepésimigic. ");
INSERT INTO kgf_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Yawe guac ʒégésigési imi Zionac hénaoriŋ eneŋ nimma ségiségi wanʒu. Yudawac ama areŋa kuneŋ kuneŋ séc ieneŋ imuac wamma ʒézé ségiségi wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Yawe gi imi baec séc eŋeŋa kecʒaŋ. Anutu momac yanda qacginaiguc onogicma kecʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Yawe siŋniŋ wammianʒu ini, biriawac méʒégina tiyu. Inéŋ hénaoriŋ héra galeŋgé énécmima ic biria ionac méragina igucnec metecgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Ic solaŋa onac asac mararaŋ ʒilaloŋa qesa énécmima qerigina dindiŋa kecanʒu ionac ségiségiac gocmia qesa énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Ic solaŋa ini Yaweac niŋac ségiségi wamma qara téréyawac ewa hia ac ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","(Legic ʒéra.) Yawenéŋ haka welic welicgia waŋec imuac niŋac legic ɋelianéŋ mepési migic. Iwac méra héiya ʒéma hua héiya téréyanéŋ onogicma kawali waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Yawenéŋ aŋgéŋ titi ai imi énézéyu héŋgic. Waŋu iwac solaŋ dindiŋa imi baera baera ionac kicginaiguc kawé qema mewininiyec. ");
INSERT INTO kgf_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Inéŋ goi héihéiya ʒéma haka héla imi Israel héna géséhéra ionac niŋac wamma sisipac acya niŋɋelima imuhuc waŋec. Waŋu baec ʒécgéria séc Anutuac aŋgéŋ titi ai imi héŋdacgic. ");
INSERT INTO kgf_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Baera baera ini ségiségi wamma Yawe hétéŋ héimigic. Ewagina meyacma ségiségi wamma legic héima mepési migic. ");
INSERT INTO kgf_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Gitanéŋ Yawe mepésigic. Gita ʒéma ewaginanéŋ mepési migic. ");
INSERT INTO kgf_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Tomuŋ mimisuleac hétéŋanéŋ ic kewu Yaweac wésiaiguc ségiségi wamma hériaŋ haimu. ");
INSERT INTO kgf_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Konduŋ ʒéma iwawai imuaru sécgéma hezac imi ʒéma baec ʒéma imuaru tacyac waŋanʒu imi mocʒoŋ hériaŋ haimimu. ");
INSERT INTO kgf_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Yaweac wésiaiguc dokunéŋ luma méra qeqe waŋgic baec boŋanéŋ momacnec ségiségi wamma legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Inéŋ mia baec ʒégési énécmimaŋ ʒé hamac. Inéŋ solaŋ dindiŋayanéŋ baec ʒégési énécmima, keŋkésa hakésaya qahac ic embachéra ʒégési énécmimac. Hénia imuac niŋac mia imuhuc mepé qepési wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Yawenéŋ héŋgaleŋ waŋ énécmizac, ic embac momac yanda ʒénéŋ hirihiri waŋgic. Yawenéŋ Kerubim kua meme uŋa qacginaiguc tacʒac. Baecnéŋ hiriyu. ");
INSERT INTO kgf_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Yawenéŋ Zioniguc kuneŋ kecʒac. Icembac hénia hénia ionac qacginaiguc meyac mimiawac kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Énézéna ieneŋ qacga yanda welic welicgia imi mepésimu. Inéŋ téréya wanʒac! ");
INSERT INTO kgf_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Ic kewunina imi kuhaguc. Inéŋ ʒégésigési dindiŋawac siŋa niŋanʒac. Inéŋ haka keŋkésa hakésaya qahac imi kumuyec. Yakoboac ichéra ionac sucginaiguc héna aciguc nanaŋ seli ʒéma haka solaŋa kumuyec. ");
INSERT INTO kgf_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Ini Yawe Anutunina meyacmima iwac héniaiguc mepésimu. Inéŋ téréya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Hofac oo ichéra ionarunec imi Mose ʒéma Aron, waŋu Anutuac qara qacanʒu ionarunec imi Samuel, ic imuhucyanéŋ ewagina mocʒoŋnec Yawe ʒéwelecmigic acgina niŋénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Yawenéŋ hosusu tandéyaiguc namma ionac énézéyu héna ac ʒéma ʒézé seli ac imi niŋtoho waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Yawe, Anutunina, gi imi acgina niŋénécminec. Nalé tosiaiguc bakia meleŋ énécminec, néŋ gi imi képésic waiwaiac Anutu kecanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Ini Yawe Anutunina meyacmima baec boŋa téréya imuaru i mepési mimu. Yawe Anutunina imi téréya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","(Ewa hia ʒémimiawac legic ʒéra.) Baera baera momac yanda, ségiségi wamma Yawe oŋhériaŋ haimigic. ");
INSERT INTO kgf_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Ségiségi wamma Yawe weleŋ qemima legic héima iwac wésiaiguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Yawe imi Anutunina wanʒac imi ini niŋasarigic. Inéŋ ʒéyu nini hicŋima kecʒiŋ. Waŋu nini imi iwac buŋa. Iwac ic embachéra ʒéma rama inéŋ ninicgaleŋ waŋ nénécmiyu kekera. ");
INSERT INTO kgf_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Ewa hia ac ézéma saŋgulaŋaiguc keremmu. Legic héimima ama yandayaiguc keremmu. Keremma ewa hia ac wammima legic héima qara meyac mimu. ");
INSERT INTO kgf_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Yawe imi hiabia. Goi héihéiya hémbénaŋa imi nalé tetecgia qahac heanʒac. Hakaya héla imi hicŋisaiya hicŋisaiya ionac muru hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","(Dawidiac legic ʒéra.) Ni goi héihéiga ʒéma ʒégési gésigawac legic héimaŋ. Yawe, ni gi gita kulele qehéi waŋgémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Ni héna solaŋawac ewama kecmaŋ. Néma naléiguc nuac hanémbésémaŋ? Ni amanaiguc ewa solaŋanec hakana wamma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Iwawai biria imi imuac me imuac kicnaiguc ménda haiwa hemac. Héna ac andé qema kecanʒu ionac méʒétiti wamma kecba haka iminéŋ ménda qéqéhéréŋ waŋnémmac. ");
INSERT INTO kgf_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Ewa qerigina ɋariŋ ɋariŋgia ieneŋ nuac murunec lakec kemma kecmu. Ni haka biria héŋara mema kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Méŋnéŋ méŋ alahéra sasaŋgiaiguc ʒébiri qébiri waŋ énécmianʒac imi mebiri énécmiwa qahac wandacmu. Ségéra herec ʒéma séwi eŋeŋ imi bisiqatéŋ ménda waŋ énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Kicna hima baec yomuaru ic héla imuhucya mihicŋi énécmima énézéwa niguc momacnec kecmu. Héna solaŋa tima keŋanʒu imi kumu énécmiwa weleŋ qenémmu. ");
INSERT INTO kgf_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Ikoc ic imi méŋnéŋ méŋ amanaiguc ménda kecmac. Ikoc ac ʒéanʒu imi eneŋ kicnaiguc ménda wai énécmiwa nammu. ");
INSERT INTO kgf_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Siŋunec séc ni baec yomuaru ic biria mocʒoŋ mebiri énécmiwa qahac wandacmu. Biria meme ieneŋ Miŋ Kewuac ama areŋa yandaiguc qahac wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","(Yéwéri mihicŋima ewa biric wamma niŋyéwécya imi Yawe ézéma ʒéwelerec.) Yawe, ʒéwelecwelecna niŋnénna. Waina guru héhéliwa qaqacnanéŋ guac muru haréyu. ");
INSERT INTO kgf_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Helanʒi nénéŋawac kecba nalé imuaru kic tanecga ménda musaŋgé némbésémaŋ. Guru héhélimaŋ imuaru gezac qema focdac acna kitiwa meleŋ némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Kekecnawac naléya imi hofac ésécnec emma sohoanʒac. Sicnanéŋ geric lokora ésécnec ʒeanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Ni eluŋ nuyu nene ménda neanʒua. Ewa qerina imi baec kérakérasiawac ɋézézac ésécnec ʒicgézac. ");
INSERT INTO kgf_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Ʒésilacna niŋac séwinanéŋ sicnaiguc qékétazac. ");
INSERT INTO kgf_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Ni imi baec kéra kérasiaiguc guae nei ésécnec, baec kisiaiguc kouteraŋ nei ésécnec wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Siŋiiguc kic ɋeli kecba ama bauyaiguc maulalac nei ésécnec wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Haʒéchécna eneŋ kaiwe herec ʒébiri qébiri waŋ némma meeŋqesac memaqesac waŋ némma sésécac wammac niŋac qacna imi saeciguc haianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Sigic newa nenena ésécnec waŋu doku newa kic masina mayu momacnec neanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","Hénia imi yomuhuc; Guac qeri biric ʒéma qeri geric niŋac imuhuc wanʒua. Gi ni népési yacmaguc duŋa gilina nuanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Naléna imi tecgémaŋ ʒé mariawac amia ésécnec melemma mazac. Ɋézézac ésécnec ʒaŋgéma kenʒua. ");
INSERT INTO kgf_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Néŋ Yawe gi imi hémbénaŋa kecanʒaŋ. Qacga imi niŋɋeligic hicŋisaiya hicŋisaiya hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Deguc imi Zion wéséniniŋ waŋmimiawac naléya. Nalé niŋna hezac imi ducŋizac. ");
INSERT INTO kgf_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Waŋu weleŋ qeqe ichécga nini Zionac hoc baŋec niŋac ségiségi wanʒiŋ. Waŋu imuac seitotoŋadac imuhucya acguc siŋa nimmianʒiŋ. Imuac niŋac geŋ yacma Zion ewa hia wammiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","baera baera ic embac imi Yawe guac qacga nimma bac yandi yandi wammu. Baec séc ic kewuhéra ieneŋ edamugawac eeya héimu. ");
INSERT INTO kgf_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Yawenéŋ Zion miyacgéma eŋeya edamuya qeriaiguc wininiyu imuhuc wammu. ");
INSERT INTO kgf_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Yawenéŋ maqeqeya inic sosoli waŋ énécmima ʒéwelecgina mematiti ménda waŋu imuhuc wammu. ");
INSERT INTO kgf_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Haka imi biaŋac hicŋisai ionac ogic heyu ic embac biaŋ hicŋimu imi eneŋ Yawe mepési mimu. ");
INSERT INTO kgf_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","22","Waŋu hésa ic ionac ʒésilacgina nimma humucac buŋa qeénécmimia hulac énécmiyu. Ic embac hénia hénia ʒéma héŋgaleŋ ama areŋa yanda Yawe mepésimiwiŋ ʒé tocgému nalé imuaru, Yaweac qara imi Zioniguc, waŋu qac buŋaya imi Yerusalemiguc ʒéau énécmimu niŋac Yawenéŋ ocmuŋ téréya eŋeŋa imuaru kic hiyu mayu ninicanʒac. Inéŋ kurumeŋ igucnec baec héŋgaleŋ waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Inéŋ kekec hénanawac suraiguc nuac kucna memama kekecnawac nalé imi mehotoŋiyec. ");
INSERT INTO kgf_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Waŋu ni yomuhuc ʒéyi; Anutuna, Anutuna, naléna kembaŋu ménda nuagicna. Guac yawuŋga imi hicŋisai lépaya lépaya hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Geŋ mia becnec baec qambaŋa hainec. Kurumeŋ acguc méraganéŋ mihicŋinec. ");
INSERT INTO kgf_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Baec kurumeŋ imi hia qahac wammac, néŋ gi imi hémbénaŋa kecanʒaŋ. Iwawai imuhucya imi séwi usu ésécnec méiméiya wamma tegicanʒac. Waŋu séwi usu ésécnec hainetec waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Gi imi ménda melemma imuhucyanec kecanʒaŋ. Yawuŋga imi tectecgia qahac. ");
INSERT INTO kgf_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Weleŋ qeqehécga ionac ɋelihécgina imi nalé séc kecmu. Ɋelihécgina imi wéségaiguc seligima nammu. ");
INSERT INTO kgf_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","(Dawidiac legic ʒéra.) Kekec uŋana, Yawe ʒéhiaru mina. Qerinaiguc heheya ini mocʒoŋ qara téréya ʒéhiaru migic. ");
INSERT INTO kgf_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Kekec uŋana, Yawe ʒéhiaru mima, ewa hiawac buŋa iwarunec hahaya mocʒoŋ imuac eluŋ ménda gumac. ");
INSERT INTO kgf_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Inéŋ képésicga mocʒoŋ augémma yaŋhafiga mocʒoŋ mehiaruma ");
INSERT INTO kgf_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","kekecga imi humuc igucnec metecgé gémma goi héihéia ʒéma wésé niniŋanéŋ ic kewu opoc héigémmac. ");
INSERT INTO kgf_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Waŋu iwawai hiabianéŋ ewa siŋga mesécgé gémmac. Waŋu séwigawac sac ɋeli imi meɋeligéŋu kunta nei ésécnec kucgaguc wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Yawenéŋ haka solaŋa wamma mema helanʒi énécmimia ionac niŋac wamma haʒéc hécgina héna acac séhaiguc ʒétecgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Imuhuc wamma hakaya Moseac muru, waŋu wawaŋ memeya imi Israel ɋelihéra énézéyu niŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Yawe imi wésé niniŋ waŋ énécmima ewa hia waŋ énécmima qeri biric focdac ménda niŋénécmima goi héihéi kuaya qeqeya waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Inéŋ képésicninawac nalé séc tualefic ac ménda waŋanʒac. Waŋu qeri biric nalé horua ménda doŋgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Képésic ninawac séc ménda meleŋ nénécmima, haka biriawac bakia howiacnec ménda meleŋ nénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Hénia imi yomuhuc; Kurumeŋnéŋ baec igucnec ou eŋeŋa hezac ésécnec, goi héihéiya imi eeya héimianʒu ionac muru kuneŋ yanda he énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Baec waŋgoŋa Is néŋ Wes igucnec lakec hezac ésécnec, inéŋ ac qeqe wawaŋanina imi qetecgéyu lakec keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Maŋgocnéŋ nambérac héra ionac wésé niniŋ waŋ énécmianʒac ésécnec, Yawe imi eeya héimianʒu imi onac wésé niniŋ waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Inéŋ séwininawac hénia nimma, nini imi seitotoŋ wanʒiŋ imi niŋɋelima imuhuc waŋ nénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Baec ic kekecninawac nalé imi ɋézézac ésécnec. Edamunina imi baec kisiawac ʒariŋ ʒuria ésécnec. ");
INSERT INTO kgf_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Imuhucya imi luhuc geriwagucnéŋ qacginaiguc qeyu qahac waŋu, baec kisianéŋ ʒariŋa hocanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Néŋ Yaweac goi héihéianéŋ eeya héimianʒu ionac hémbénaŋaiguc hémbénaŋa hema emma kecmac. Solaŋ dindiŋaya imi ɋelihécgina lépaya lépaya he énécmima kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","Imi mia sisipac acya niŋtoho wamma héna acya niŋɋelima wamma meanʒu ionac mia imuhuc waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Yawenéŋ ic kewu tatacya kurumeŋiguc meyacgéma, héŋgaleŋ kuhanéŋ kekec momac yanda galeŋgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Kucginaguc wamma Yaweac ackuaʒéc meselima, ac ewaya niŋtohoanʒu kua meme uŋa ini Yawe ʒéhiaru migic. ");
INSERT INTO kgf_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Yawe weleŋ qemima iwac ewa siŋ wamma meanʒu kua meme uŋa ini Yawe ʒéhiaru migic. ");
INSERT INTO kgf_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Yawenéŋ ʒéhicŋi énécmiyu baec imuaru me imuaru inéŋ héŋgaleŋ waŋanʒac séc kecnaʒu ini mocʒoŋ Yawe ʒéhiaru migic. Kekec uŋana Yawe ʒéhiaru mina. ");
INSERT INTO kgf_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Kekec uŋana, Yawe ʒéhiaru mina. Yawe Anutuna, gi imi kuneŋ yanda, eega eŋeŋa ʒéma edamuga imi maleku ésécnec héima kecanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Inéŋ asac mararaŋa imi séwi usu ésécnec héima, kurumeŋ imi sel hali ésécnec hérétéŋ haiyu hezac. ");
INSERT INTO kgf_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","Dokuiguc amayawac nanduŋ kumuma hosusu ézéyu kareya waŋu luhuc ézéyu qeŋgaŋa waŋu keŋha waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Luhuc oporu eŋeya weleŋ qeqe icya waŋu, geric oporu eŋeya ai icya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Baec imi qambaŋa qahaiguc haimiyu hémbénaŋa qekeŋ qeha ménda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Geŋ baec imi konduŋ doku yandanéŋ séwi usu ésécnec hoturuna baec boŋa qahaiguc naŋec. ");
INSERT INTO kgf_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Waŋu geŋ mia ac wammina dokunéŋ néŋgacma keŋec. Parandaŋga qaru foc foc keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","Keŋu baec boŋanéŋ eŋu baec wéŋwéŋgianéŋ hiŋgacma imuac me imuac ʒéminec séc mekemma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Waŋu dokunéŋ muŋguc ménda hama hoturumu niŋ ménda logimu ʒéma qaŋaŋ silic hai énécminec. ");
INSERT INTO kgf_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Yawenéŋ ʒéyu doku hogocyanéŋ baec boŋa wéŋwéŋgia séc hicŋima éréma baec boŋa namuŋ ginaiguc téfara wamma keŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Kemma baec kisiaiguc haséŋ yaŋ sécgina séc gumu énécmiyu haséŋ becosic eneŋ acguc negic déméŋgina qaŋgararaŋa imi méwécgéyu hiaruanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Sawa nei acguc imuac giŋgiŋaiguc aségina haima ic hawaiguc tacma ewa hétéŋ waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Inéŋ ou ai amayaiguc tacma baec boŋa séc doku haiyu aiyawac héla imi baeciguc sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Inéŋ waŋu ama yaŋ onac ɋézézac ʒéma ic neŋaŋ niŋac ʒuaʒua yandianʒac. Waŋu inéŋ ʒéyu baeciguc nene yaka hicŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","Icac ewa qeriaiguc ʒézé ségiségi mihicŋi mimia waiŋ ʒéma icac kic tanera measari mimia haléc ʒéma icac ewa qeriaiguc kuha mihicŋi mimia nene yaka imi inéŋ ʒéyu hicŋidarec. ");
INSERT INTO kgf_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Yaweac ic hésa dokunéŋ sécgé énécmiyu hezac. Lebanoŋac yéménʒéc ic imi inéŋ himiru hezac. ");
INSERT INTO kgf_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Nei eneŋ imuaru haegina haianʒu. Ʒanʒaŋ nei eneŋ imi kumbu iciguc amia mihicŋianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Baec boŋa eŋeŋa imi haséŋ noniŋ ionac buŋa, waŋu hoc baŋec imi nehec qérandeŋ ionac saŋgi saŋgiac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Inéŋ maso haiyu baec ai memeyawac naléya ʒéanʒac. Waŋu kaiwe imi naléya nimma hiŋgacanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Geŋ mia tunumaŋ mihicŋina ama siŋiyu haséŋ yaŋ hénia hénia mama keŋha waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Laion sac ɋelinéŋ neneyawac buŋa nesima qacma neneyawac Anutu guru héhélima kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Kaiwe éréyu kemma teŋginaiguc heanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Duŋa ic eneŋ mama kuc qema ai mema kecgic ama siŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Yawe ai geŋ menec imi yei sasala yanda wanʒac! Geŋ mia niŋtegic qiŋtegicganéŋ kekec imi mocʒoŋ mihicŋina mériaŋganéŋ baec séc sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Eri konduŋ hilaŋeŋ kuneŋ yanda hezac. Waŋu imuac qeriaiguc imi, iwawai bacginanéŋ héima keŋha waŋanʒu ʒéma doku yaŋ kuneŋ komora hénia hénia ʒaŋgégina ménda oloŋ oloŋawac séc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Ʒéicnéŋ imuac qahaiguc keŋha waŋgic geŋ ʒéhicŋi mimia konduŋ yaŋ oa gaʒugaʒu eneŋ doku imuac qeriaiguc lelecgéanzu. ");
INSERT INTO kgf_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Imuhucya ieneŋ mocʒoŋ nalégina séc méndacma geŋ nene gumu énécmiwésémaŋ niŋac guac kichihi wamma kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Gumu énécmina neanʒu. Méraga auna iwawai hiabia sécgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Kic tanecga musaŋgéna ieneŋ ʒénéŋ hirihiri wamma kecanʒu. Waŋu geŋ wéségina onagicna humuma baec igucnec hicŋigicac imuac muŋguc liliŋgéma keŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Waŋu geŋ uŋaga téréya mélina hama kekec hezac séc mihicŋi énécmiyec. Waŋu inéŋ baec séwiya imi muŋguc meɋelianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Yaweac edamuya imi hémbénaŋa hema emma kemmac. Yawenéŋ eŋeya ai niŋac ʒézé ségiségi wammac. ");
INSERT INTO kgf_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Inéŋ baec héŋu baecnéŋ hirianʒac. Waŋu baec boŋa osiyu hofacnéŋ yacanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Kekecnawac séc Yawe legic héimimaŋ. Kic ɋeli kecmaŋ imuac sura séc Anutuna gita kulele qemimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Ʒézé niniŋnanéŋ ségiségi mihicŋi mimac niŋac wanʒua. Ni imi Yaweac niŋac ʒézé ségiségi wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Ʒéna képésic ic baeciguc humuc qai waŋgic, kaiʒiliweŋ ic imuaru muŋguc ménda kecmu. Kekec uŋana, Yawe mepé qepési wammina, haleluya ohec wahec! ");
INSERT INTO kgf_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Yawe ewa hia ac ézéma qara qacma ézégic. Ic embac momac yanda sucginaiguc wawaŋ memeya imi ʒéau énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Legic héimima i mepésigic. Haka welic welicgia waŋec imi mocʒoŋ ʒéau énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Qara téréya mepésigic. Yawe hochoc waŋanʒu imi ewa qeriginaiguc ségiségi he énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Yawe ʒéma kuhawac niŋkewu waŋgic. Kic tanecyawac nalé séc niŋkewu waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Weleŋ qeqeya Abarahamac ɋelihéra, Yakoboac ɋelihéra, gési énécmimia ini haka welic welicgia ʒéma kiwi méréra ʒéma kuayaiguc ʒégésigési ac inéŋ wamma meyec imuac niŋɋeligic. ");
INSERT INTO kgf_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","I imi Yawe Anutunina wanʒac. Iwac ʒégésigésinéŋ baec séc sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Inéŋ sisipac ac hicŋisai lépaya tauseŋa imuac buŋa qeénécmima ʒéselima ʒéyec imi hémbénaŋa niŋɋelima kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","Imi mia sisipac ac Abarahamac ʒémiyec imi ʒéma ʒézé seli Isaka wammiyec imi mia. ");
INSERT INTO kgf_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","Waŋu inéŋ Yakoboac muru imi héna acwac buŋa meseligiyu Israelac sisipac ac hémbénaŋa waŋecac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","Ʒéyecnéŋ; Ni Kanaaŋ baec imi ic suc qema gémba mératécgina wammac. ");
INSERT INTO kgf_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Waŋu nalé imuaru imi ʒaŋgégina sasala qahac efefia komodia dac téŋgéŋ ic kiaŋ wamma kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Kecma hicŋisai méŋac murunec méŋac muru, héŋgaleŋ ama areŋa yanda méŋac murunec méŋac muru kiaŋ wamma lelecgégic. ");
INSERT INTO kgf_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Néŋ ic eneŋ mebiri énécmimu niŋac ménda wai énécmiyec, hélanec ionac niŋac wamma ic kewuya ic kewuya ac geriwaguc waŋ énécmima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","Nuac haléc qocgémimia imi ménda osigic, nuac tiliŋ tiliŋ ic imi ménda mebirigic. ");
INSERT INTO kgf_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Inéŋ baec imuaru béti ʒéhicŋi énécmima saméŋ padi imuac ura imi mocʒoŋ héʒéŋgéyu qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Béti igucnec aŋgéŋgina timaŋ ʒé ic méŋ méliyu walacgina mema keŋec. Qara imi Yosefe, weleŋ qeqe buŋa qeyu, mamboŋ mema wagicma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Hénaya imi iwawai sou ʒéragucnéŋ kima heyec. Séwiya imi seŋ hésanéŋ dérécgé migic heyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Yaweac ackuaʒécnéŋ hélaguc wandacmac nalé imuac sura séc, Yaweac ackuaʒécnéŋ Yosefe manam batuc waŋ mimanec kerec. ");
INSERT INTO kgf_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Keru baec imuac ic kewunéŋ icya mélimima hulacmiyec. Baera baera ic embac ionac ic kewunéŋ imuhuc wammiyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","22","Ic kewu inéŋ eŋeya ewa siŋa méndacma galeŋ ichéra dérécgé énécmima hésa amaiguc onopocma ic yanda niŋtegic qiŋtegic ku énécmimac ʒéma Yosefe oporu héŋgaleŋ ama areŋa yanda imuac galeŋa wamma iwawaiya mocʒoŋ galeŋgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Nalé imuaru Israelnéŋ Iʒipte baeciguc kereŋec. Yakobonéŋ Ham baeciguc ic kiaŋ kerec. ");
INSERT INTO kgf_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Yawenéŋ Israelac ic embachéra imi kuneŋ yanda mesai énécmiyu kucgina imi haʒéc hécgina ionac kucgina ogirec. ");
INSERT INTO kgf_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Waŋu Anutunéŋ haʒéc hécgina ionac ewa qerigina meleŋ énécmiyu ic embachéra ionac méʒétiti waŋ énécmigic. Anutuac weleŋ qeqe ichéra diwi qiwiliŋ waŋ énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Waŋu weleŋ qeqe icya Mose ʒéma ic gésimimia Aron méli érécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Iereŋ imi ic embac ionac sucginaiguc asé kiwiyawac haka énézéyic héŋgic. Ham baeciguc haka welicwelicgia waŋoc. ");
INSERT INTO kgf_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Yawenéŋ tunumaŋ méliyu siŋindéŋgéyec. Waŋu iereŋ ara qema niŋtohoyic ");
INSERT INTO kgf_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Anutunéŋ doku melemma sac mihicŋima lambéc unuhumudarec. ");
INSERT INTO kgf_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Waŋu baec imuaru taŋanéŋ sasala saima sécgéma kecgic. Ic kewuhécgina ionac ama qeriaiguc acguc sécgéma kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Yawenéŋ ʒéyu sék tuŋagucnéŋ hagic. Waŋu baec yanda imuac qeria séc imiŋ sasala sécgéma kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Kiawac melemma komboc luhuc hai énécmiyu mayec. Waŋu buŋ parandaŋ geric bélaŋagucnéŋ baecgina séc qocgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Qocgéma ionac waiŋ ic hésa ʒéma fik ic qeyu humudarec. Waŋu ic hésa lelec lelec imi héiyu madarec. ");
INSERT INTO kgf_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Yawenéŋ ʒéyu gaoc ʒéma kambiŋ eneŋ gelec malec qahac harégic. ");
INSERT INTO kgf_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Haréma baec imuac ʒuaʒua mocʒoŋ nedacma aiiguc héla gocmia heyec imi nedacgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Yawenéŋ baec imuac méréc merac mocʒoŋ unuyu humudacgic. Ieneŋ imi ionac séwiginawac kucya imuac hénihénia. ");
INSERT INTO kgf_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Waŋu ic embachéra énézéyu siliwa goli medacgic onagiru érégic. Waŋu areŋa areŋa séc méŋnéŋ méŋ météqététaŋ méŋ ménda waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Iʒipte ic eneŋ ionac ʒénéŋ hirihiri waŋgic imuac niŋac waima hagic ségiségi waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Yawenéŋ hosusu imi kaiweiguc amiaginawac, waŋu geric bélaŋa imi siŋiiguc asahaginawac lémbéc énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Waŋu ieneŋ ʒéwelecgic ʒéyu koneŋ nei hagic. Waŋu kurumeŋ nene mayu negic sécgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Waŋu baŋa kuaya auyu doku mama baec kéra kérasiaiguc doku téfara ésécnec hama keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Imi mia eŋeya ackuaʒéc téréya ʒéma weleŋ qeqeya Abaraham niŋɋelima imuhuc waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Ic embachéra waŋ énécmiyu ségiségi wamma mama hagic. Gési énécmimia ieneŋ legic héima mama hagic. ");
INSERT INTO kgf_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Héŋgaleŋ ama areŋa yanda yanda imuac baec imi onagicma énécmiyec. Baera baera ic embac ieneŋ ai yanda mema mihicŋigic imi mocʒoŋ ionac buŋa qeénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","Imi mia ieneŋ héna ac imi niŋtohoma ʒézé seli ac imi méndacmu niŋac imuhuc waŋ énécmiyec. Haleluya ohec wahec! ");
INSERT INTO kgf_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Haleluya, Yawe imi hiabia. Waŋu goi héihéiya imi hémbénaŋa. Imuac niŋac ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Mérénéŋ Yaweac wawaŋ meme kuhaguc imi hia énézéma qac buŋaya mocʒoŋ hia ʒéau énécmimac? ");
INSERT INTO kgf_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Héŋgaleŋ wawaŋawac héna ac tohodacma nalé séc haka solaŋa waŋanʒu imi eneŋ ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Yawe, ic embachécga ewa hia waŋ énécmiwésémaŋ nalé imuaru ni niŋɋeli nénna. Aŋgéŋgina tiwésémaŋ nalé imuaru nuac hanémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","Wainénna guac gési énécmimia ieneŋ mériaŋginaguc kecgic inicmaŋ. Inicma héŋgaleŋ ama areŋa yandagawac mératéc buŋa niŋac ségiségi wamma mératécgawac ʒézé ségiségi wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Nini yanda hécnina waŋgic éséc haka biria wamma kaiʒiliweŋ wamma képésic mihicŋiyiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Yanda hécninanéŋ Iʒipte baeciguc hakaga welic welicgia imuac hénia ménda niŋtegicma goi héihéiga yanda imi ménda niŋɋelima konduŋ, konduŋ pésia imuaru ac qeqe haka waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Waŋu Yawenéŋ eŋeya qac buŋaya niŋac wamma aŋgéŋgina tiénécmiyec. Imi mia kuha yanda imi énézéyu héŋtegicmu niŋac imuhuc waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Imuhuc nimma konduŋ pésia imi ac wammiyu focdac ʒicgéyu ic embachéra onagiru konduŋ dumuc sira imi baec kérakérasia ésécnec tima hagic. ");
INSERT INTO kgf_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Imuhuc wamma haʒéc hécgina ionac méragina igucnec aŋgéŋgina tiénécmima ununesi waŋ énécmigic ionac méragina igucnec boŋhéré meénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Waŋu haʒéc hécgina imi mia dokunéŋ hoturu énécmiyu mocʒoŋ humuqaigic méŋnéŋ méŋ ménda kerec. ");
INSERT INTO kgf_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Imuacnec ieneŋ ackuaʒéc imi ninʒéŋgéma legicya héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Waŋu ieneŋ nalé sosola ménda waŋunec haka imi eluŋ unuyu iwac ʒéareŋ areŋgiawac ménda mambéc waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Imuhuc wamma baec kéra kérasiaiguc hémbaoc kuneŋ yanda wamma baec sakasacya imuaru Anutu batucgégic. ");
INSERT INTO kgf_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Yawenéŋ ʒéwelecgic séc énécmiyec, néŋ kekec uŋaginawac imi hafi mihicŋi énécmiyu ʒaŋgéma keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Ieneŋ baec méŋ tacyac waŋgic imuaru Mose ʒéma Yaweac météré ic Aron iorac nimbupuc waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Imuhuc waŋgic baecnéŋ téma Datan ɋécgé mima Abiramac tohotoho ichéra imi hoturu énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Waŋu geric bélaŋanéŋ tohotoho ic tuŋ imi késama onodarec. ");
INSERT INTO kgf_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Ieneŋ Horep baec boŋaiguc burumakao merawa ireha meyacgégic. Goli opépélima qocgéma memeya baniara imi mepésimigic. ");
INSERT INTO kgf_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Imuhuc wamma Anutuac asac mararaŋ imi meleŋgic ɋézézac nema kekera burumakao tanec waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Iʒipte baeciguc haka kuneŋ yanda waŋec aŋgéŋ titi miŋina Anutu imi eluŋ unuyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Inéŋ Ham baeciguc kiwi méréra ʒéma konduŋ pésiaiguc haka welic welicgia waŋec imi mia. ");
INSERT INTO kgf_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Imuac Yawenéŋ unuhumumaŋ ʒéyec, néŋ gésimimia Mosenéŋ Anutu ʒéma icembac héra téamuma naŋgic imuac sucginaiguc Anutuac wésiaiguc namma ménda unumac niŋac qeri biria mebélacgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Waŋu ieneŋ ackuaʒécya ménda ninʒéŋgéma baec hiabia imi mematiti wammigic. ");
INSERT INTO kgf_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Haliginaiguc ʒébiri qébiri wamma Yaweac ackuaʒéc imi ménda niŋtohogic. ");
INSERT INTO kgf_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Imuhuc waŋgic inéŋ ʒéselima ʒéyec; Neŋ waŋ énécmiwa baec kéra kérasiaiguc maunudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","Waŋu ɋelihécgina imi héndéŋ énécmiwa baera baera ic embac ionac sucginaiguc kemma maunudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Ieneŋ Peol baec boŋawac Baal iwac muru toroqema baniara kekecya qahac imuac wamma nene saméŋ ohai wammigic imi mema negic. ");
INSERT INTO kgf_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Imuhuc wamma wawaŋ meme iminéŋ Miŋ Kewu qeri biric yanda mihicŋi migic yaŋ hafi humumianéŋ saima énépésiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Nalé imuaru Pinehasinéŋ yacma Anutuac ewa siŋa méndacma acqeqe ic imi bakia meleŋ énécmiyu saec buŋa imi tecgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","Imuhuc waŋu Anutunéŋ iwac niŋu ic solaŋa waŋec imi hémbénaŋa niŋyacgéwiŋac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Waŋu ieneŋ imi Meriba dokuiguc Yawe qeri biric mihicŋi migic haka imuac niŋac wamma yéwéri méŋ Moseac muru hicŋimiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","Imi mia ieneŋ Anutuac uŋawac ac qeqe wammigic Mose imi kua tasianéŋ ac sicsaocya ʒéyec imuac niŋac imuhuc hicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Waŋu ieneŋ Yaweac ʒézé seli imi ménda tohoma ic enia ménda unugic. ");
INSERT INTO kgf_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Imuhuc wamma iniguc momacnec tacyac wamma hakagina biria imi niŋareŋgéma késagic. ");
INSERT INTO kgf_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Késama baniarawac ireha imi mepésigic iminéŋ ionac muru bétac ésécnec waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Ieneŋ nambérac hécgina baniarawac mulu buŋa hai énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Sac solaŋa képésicya qahac, nambérac héra ionac sac imi qocgéma Kanaaŋ ic ionac baniarawac mulu buŋa hai énécmigic baec imi sac iminéŋ meʒapi qeyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Ieneŋ imi wawaŋ meme iminéŋ meʒapi qeamuma kaiseroac haka waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Hénia imuac niŋac Yawenéŋ eŋeya ic embachéra qeri biric kuneŋ yanda niŋénécmima eŋeya buŋa méʒétiti waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Imuhuc nimma baera baera ic embac ionac méraginaiguc onoporu méʒétiti waŋ énécmianʒu imi onac méra bacginaiguc kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Haʒéchécgina ieneŋ helanʒi énécmigic ionac méra bacginaiguc weleŋ qeqe ic kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Yawenéŋ hatac sasala mehiaru énécmiyec, néŋ niniŋgina ɋariŋɋariŋgia méndacma andé qegic. Waŋu eŋaŋ képésic niŋac memaénéc mimia waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Waŋu Yawenéŋ ionac qachéhéli imi niŋénécmiyec nalé imuaru ʒénaŋgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","Waŋu ionac niŋac wamma sisipac ac imi niŋɋelima goi héihéiya ʒékéŋaguc imi méndacma ewaya meleŋec. ");
INSERT INTO kgf_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Melemma ionac waŋ énécmiyu hésa ic énépésigic ieneŋ mocʒoŋ ewa biric waŋ énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Yawe Anutunina aŋgéŋnina tima baera baera igucnec tocgé nénécmina qacga téréyawac ewa hia nimma qac buŋaga mepési gémbiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Yawe Israelac Anutu hémbénaŋa igucnec hémbénaŋa mepésimigic. Ic embac momac yandanéŋ ‘Hélacnec!’ ʒému. Haleluya ohec wahec! ");
INSERT INTO kgf_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Yawe imi hiabia, waŋu goi héihéiya imi hémbénaŋa imuac niŋac i ewa hia ac ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Yawenéŋ boŋhéré meénécmiyu kecʒu imi eneŋ imuhuc ʒému. Ini Yawenéŋ haʒéc hécgina ionac méragina igucnec mulu meénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","Baec waŋgoŋa Is, Wes, Saut ʒéma Not igucnec tocgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Baec kéra kérasiaiguc rouc wamma tacyacwac tauŋa méŋ ménda mihicŋima ");
INSERT INTO kgf_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","nene doku niŋac humugic déméŋgina kérakérasia waŋec. Waŋu imuac niŋac kekec uŋaginanéŋ kuc mama wandacgic. ");
INSERT INTO kgf_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Imuac ieneŋ qeri yéwéc nimma Yawe qachéhéligic yéwéri igucnec metecgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Waŋu héna dindiŋa mihicŋi énécmima tacyacwac tauŋ méŋiguc kemma onoporec. ");
INSERT INTO kgf_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Yaweac goi héihéi ʒéma baec ic onac niŋac wamma haka welic welicgia inéŋ waŋec imuac niŋac i mepésimigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Inéŋ doku niŋ humuanʒu imi mesécgé énécmima yaka niŋac humuanʒu imi iwawai hiabia gumu énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Tunumaŋ ʒéma humucac amiaiguc tacgic yéwéri ʒéma seŋ hésanéŋ dérécgé énécmiyu kecʒu imi ");
INSERT INTO kgf_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","Anutuac ackuaʒéc andé qema eŋeŋa miŋinawac ewa siŋ imi mematiti waŋgic imuac mia imuhuc hicŋi énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Imuac ʒérabéra yéwéria mihicŋi énécmiyu maunuyec, néŋ méŋnéŋ méŋ méra ménda énécmigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Imuaru ieneŋ yéwéc qeriaiguc Yawe qachéhéligic, inéŋ ʒérabéra igucnec aŋgéŋgina tiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Inéŋ tunumaŋ ʒéma humucac amia igucnec énépésima hésa dérécgé énécmima heyec imi qéséŋu bororoŋanec madarec. ");
INSERT INTO kgf_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Yaweac goi héihéi ʒéma haka welic welicgia baec ic onac waŋec imi ʒéma ");
INSERT INTO kgf_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","inéŋ nagu aiŋnéŋ memeya imi qésémma aiŋ wétéya imi kuyec imuac wamma i ewa hia ac ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Tosara imi acqeqe wamma ic diwi qiwiliŋa wamma kecgic. Kecma képésicgina niŋac ʒérabéra mihicŋigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Ieneŋ imi nene yaka mocʒoŋ héŋacya mema kecma humucac saŋgulaŋiguc hosucgégic. ");
INSERT INTO kgf_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Nalé imuaru ieneŋ yéwérigina niŋac Yawe qachéhéli wammigic. Waŋu inéŋ helanʒi énécmiyec yéwéri imuacnec aŋgéŋgina tiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Inéŋ ackuaʒécya mélima humucac déc igucnec metecgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Yaweac goi héihéiya imuac ewa hia ac ʒémigic. Haka welic welicgia ic onac waŋec imuac ewa hia ac ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Ewa hiawac mulu haimima ʒézé ségiségiac legic héima wawaŋ meme Yawenéŋ waŋec imi ic embac momac yanda énézégic. ");
INSERT INTO kgf_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Tosara ʒéiciguc kemma konduŋ yandaiguc nénnagémba ai meanʒu imi eneŋ ");
INSERT INTO kgf_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Yaweac wawaŋ meme ʒéma haka welic welicgia konduŋ hiŋgac hiŋgaraiguc héŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Yawenéŋ ʒéyu luhuc selianéŋ yacma konduŋ temboŋa meyarec. ");
INSERT INTO kgf_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Yaru ieneŋ ou kurumeŋiguc emmaguc duŋa emu dumuc siraiguc hiŋgacgic. Waŋu haka iminéŋ tericgé énécmiyu ewa qerigina imi pépélima mayec. ");
INSERT INTO kgf_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Waŋu ieneŋ tendiŋ tendiŋ kemma qekeŋ qeha wamma duŋa waiŋ dokunéŋ waŋ énécmiyu waŋanʒu ésécnec sicsaoc ɋasikeŋ ɋasiha waŋgic niŋtegic qiŋtegicgina aulaŋgéyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Waŋu ieneŋ niŋ yéwérima Yawe qachéhéligic yéwéri helanʒi énécmimia imuacnec metecgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Waŋu luhuc selia imi ézéyu néŋ qema qahac waŋu konduŋ temboŋa ézéyu néŋ qeyec. ");
INSERT INTO kgf_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Néŋ qeyu ieneŋ bénʒéŋ kekec imuac ségiségi waŋgic Yawenéŋ ʒéic ala imuaru me imuaru kembiŋ ʒé niŋkumuma kecgic imuaru onagicma keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Yaweac goi héihéi ʒéma haka welicwelicgia ic onac waŋec imuac ewa hia ac ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Ic embac aʒoaʒoroiguc i mepési mima galeŋ ionac aʒoaʒoroiguc legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Yawenéŋ doku téfara melemma baec kérakérasia mihicŋianʒac. Waŋu doku hogocya melemma baec témbaŋa mihicŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","Tacyachéra ionac biria niŋac baec halécya melemma baec kérakérasia mihicŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Waŋu baec kérakérasia melemma doku ʒékéŋ mihicŋima baec témbaŋa melemma doku hogocya mihicŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Waŋu maqeqeya imi imuaru onoporu tacyacwac tauŋgina meanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Waŋu aiiguc iwawai gocmia qesama waiŋ ai galeŋgéma héla mihicŋianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Waŋu mériaŋ mihicŋi énécmiyu ʒaŋgégina saima sasala waŋanʒu. Waŋu ama yaŋhécgina ʒaŋgégina imi ménda maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Waŋu duŋa muŋguc yéwéri helanʒi énécmimia ʒéma ʒérabéra ʒéma yaŋhafinéŋ waŋ énécmiyu ʒaŋgégina maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Yawenéŋ galeŋ ionac qacginaiguc gamu qolacgé énécmima baec kérakérasia héna qahac imuhucgeŋ onoporu rouc waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Waŋu néwéc maqeqeya imi météqététaŋ igucnec meyac énécmima sac taséhéra rama tuŋ ésécnec mesai énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Ic dindiŋa imi haka imi hémma ʒézé ségiségi waŋanʒu, néŋ ic biria momac yanda eneŋ eŋaŋ kuagina wéʒéc qema ac qahac kecgic. ");
INSERT INTO kgf_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Eŋaŋ niŋac niŋgic niŋtegic qiŋtegic ginaguc wanʒuiguc Yaweac haka imuhucyawac héŋsosolima iwac goi héihéi imi niŋtegicgic. ");
INSERT INTO kgf_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","(Dawidiac legic ʒéra.) Anutu, ewa qerina imi keŋqe haqeya qahac, qeri uŋana mocʒoŋnec legic héima mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Gita kulele ʒéma waŋgoŋna, ini yacgic. Ni giaŋgiaŋa imi mindiwa yacmac. ");
INSERT INTO kgf_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Yawe ni ic embac momac yanda ionac sucginaiguc ewa hia ac gézéma baera baera ionac sucginaiguc gi mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","Guac goi héihéiga ou kurumeŋiguc kuneŋ yanda wanʒac. Waŋu guac haka héla iminéŋ ou hosusu igucgeŋ sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Anutu, ou kurumeŋiguc meyac géŋgéŋa wammac. Asac mararaŋga imi baec séc ic embac ionac qacginaiguc meyacyara wammac. ");
INSERT INTO kgf_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Méra héiganéŋ aŋgéŋna tima ʒéwelecna niŋna. Goi héihéi waŋ énécmianʒaŋ ionac muru aŋgéŋ titi hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Anutunéŋ ocmuŋ téréyaiguc ʒézac. Ni técgéma técgéma aria memaŋ. Sekem méndémma Sukot baec wéŋwéŋgia imuac qétéya memaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Gileate imi nuac, Manase imi acguc nuac, Eferaim imi nuac orucnawac opoc selia. Yuda imi héŋgaleŋ ainawac ɋarucya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Moap imi nuac doku naec pakeya wanʒac. Edomiguc nuac héna usuna giliwa hemac waŋu Filisitia qahaiguc ni hériaŋ haimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Mérénéŋ nuagicma ama neuŋ kiropo seliaguc imuaru keremmac? Mérénéŋ Edomac héna nézéyu hémmaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Anutu gi imi wai nénécmiʒaŋ me? Anutu gi imi némac niŋac téŋgiŋ icnina iniguc momacnec ménda keŋanʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","Méra nénécmina haʒéchécnina unuwiŋ. Baec icnéŋ méra nénécmigic gorosoŋa waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Nini Anutuaru héima namma bac yandi yandi qahac kembiŋ. Inéŋ haʒéchécnina tidacgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Nuac mepé qepésiac Anutu, acga ménda qaiyu. ");
INSERT INTO kgf_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Ieneŋ imi kua biria ʒéma kua ikora aŋgéma ni ʒébiri nénʒu. Ezelaŋgina ikoranéŋ ac waŋnéŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Waŋu méʒétiti ac wamma helanʒi némma hénia qahaciguc ʒébiri qébiri wannénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Ni imi ala waŋ énécmianʒua néŋ ieneŋ imi néwéc haʒéc wannénʒu imuac ni ʒéwelec sac waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Ieneŋ haka birianéŋ hakana hiawac bakia meleŋ nénʒu. Waŋu nuac ala siŋnawac bakiawac méʒétiti waŋ nénʒu. ");
INSERT INTO kgf_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Ieneŋ yomuhuc ʒégic; Kaiʒiliweŋ icac mériaiguc opocna helanʒi mimac. Haʒécya mihicŋi mina méra héiyaiguc namma aciguc opocmac. ");
INSERT INTO kgf_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Aciguc emmac nalé imuaru waina képésicyaguc ʒémimia wammac. Waina ʒéwelecya acguc melemma képésicya wammac. ");
INSERT INTO kgf_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Kekecyawac yawuŋ imi meducŋima ai buŋaya imi wagicma ic tosara énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Waiénécmina nambérac héra ieneŋ gupaŋ merac wandacmu. Iniŋa imi malé wammac. ");
INSERT INTO kgf_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Nambérac héra eneŋ lelecgéma yaka niŋac ʒéqesi énécmima kecmu. Amagina kisiya waŋu waima météqététaŋ wamma kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Soukiwa kosia meme icnéŋ iwawaiya mocʒoŋ wagicmu. Iwawai inéŋ kuc qema mihicŋiyec imi ic tosaranéŋ medacmu. ");
INSERT INTO kgf_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Ic méŋnéŋ méŋ iwac ewa hiawac susucnec ménda wammimac. Gupaŋ merachéra ionac méŋnéŋ méŋ ewa biric ménda waŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Ɋelihéra humuqai wandacmu. Kecma qacgina imi mocʒoŋ eluŋ unudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Yawe imi yandahéra ionac képésic imi nimmanec kecmac. Neŋgocginawac képésic imi ménda auna. ");
INSERT INTO kgf_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Képésicgina imi nalé séc Yaweac wésiaiguc waina hemac. Qac buŋaya imi auna baeciguc qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Imi mia inéŋ goi héihéi waŋénéc mimiawac haka imuac niŋ éréhéc ménda wamma maqeqeya ʒéma mété qététaŋa ʒéma ewa biric mihicŋima kecanʒu imi ununesi wamma unuhumumaŋ ʒé waŋec imuac mia imuhuc ʒéziŋ. ");
INSERT INTO kgf_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Inéŋ siŋa nimma saec ac énézéyec. Waŋu iminéŋ eŋeya muru liliŋgéyec. Mériaŋ ac ʒémaŋ ʒé méʒétiti waŋec imuac mériaŋnéŋ héŋacya mema lakec keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Inéŋ séwi usu héianʒac éséc saec ac waŋ énécmiyec. Waŋu saecnéŋ doku ésécnec qeriaiguc hiŋgaru haléc ésécnec sira mézécgéma késayec. ");
INSERT INTO kgf_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Wammina saecnéŋ séwi usu ʒéma rikuŋa ésécnec nalé séc héi ʒiki waŋu hemimac. ");
INSERT INTO kgf_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Qeri uŋana haʒéc wammima ʒébiri qébiri imuhuc wammianʒu ionac imi Yawenéŋ bakia imuhucyanec meleŋ énécmimac niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Yawe qacga niŋac wamma goina hiabianec héina. Guac goi héihéiga hiabia imuac niŋac wamma metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Ni imi maqeqeya météqététaŋ wamma kecba ewa qerinanéŋ birizac imuac mia. ");
INSERT INTO kgf_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Kekecna imi mariyawac amia ésécnec melemma mazac. Waŋu gaoc dac imuhucya luhucnéŋ mihilaŋgéyu kenʒu ésécnec efefianec kenʒac. ");
INSERT INTO kgf_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Nene sigi kecba simiŋna kuha qahac séwina mazac. ");
INSERT INTO kgf_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Ni imi ionac ʒébiri qébiriac buŋa wanʒua. Ieneŋ ni némma oruc gilianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Yawe Anutuna, méra néŋna goi héihéigawac niŋac ni metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Imuhuc wanna ieneŋ haka iminéŋ guac méraga wanʒac imi héŋtegicmu. Yawe geŋ imuhuc waŋ nénnec imi niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Ieneŋ saecnec sac ʒénémmu, néŋ geŋ mia mériaŋ mihicŋi némbésémaŋ. Ieneŋ haʒéc waŋ némma yacmu imuaru gamugina mihicŋimu, néŋ guac wleŋ qeqega imi ségiségi wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Waŋénécmina haʒéchécna ieneŋ ʒébiri qébiri séwi usu ésécnec héima kecmu. Gamugina imi saŋgeŋa maleku ésécnec he énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Ni kuananéŋ Yawe ewa hia kuneŋ yanda ʒémima ic embac tuŋaguc ionac sucginaiguc legic héimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Inéŋ maqeqe icyawac méra héiyaiguc nammac. Namma iwac qeri uŋayawac képésiraguc ʒéwiŋ ʒé wanʒu ionac méragina igucnec aŋgéŋa timac. ");
INSERT INTO kgf_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","(Dawidiac legic ʒéra.) Yawenéŋ Miŋ Kewuna yomuhuc ézéyec; Gi mérana héiyaiguc tacnanec ni haʒéchécga hénagaiguc héna titigawac buŋa onopocmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Yawe geŋ Zion igucnec ic kewu ɋarucga kuhaguc imi méranna kemmac. Miŋ Kewu gi haʒéchécga sucginaiguc inicgaleŋ wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Héŋgaleŋ kucgawac naléiguc hénaoriŋ hécga séwi usu météré mimiaguc ségiségi wamma weleŋ qema kecgic. Giaŋ giaŋawac héri igucnec sac ɋelihécga séŋéréc ésécnec hicŋima guac muru hamu. ");
INSERT INTO kgf_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Yawenéŋ ʒéselima méŋʒé méŋʒéya ménda waŋanʒac. Inéŋ mia yomuhuc ʒéyec; Gi Melikisedekac areŋ méndacma hofac oo ic hémbénaŋa wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Miŋ Kewuna guac méra héigaiguc kecʒac inéŋ qeri geric nimmac nalé imuaru ic kewu momac yanda unuyu wizi kukuginaguc wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Baera baeraiguc ʒégési énécmiyu qamocnéŋ ionacmuru sécgéma hemac. Orucgina qésémma unudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Unudacmaguc héna giŋgiŋaiguc doku téfara nema usuŋa meɋelima oruha meyacmac. ");
INSERT INTO kgf_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Haleluya, ni ic solaŋ dindiŋa ionac aʒoaʒoroiguc ʒéma hénaoriŋ ionac aʒoaʒoroiguc ewa qerina mocʒoŋnec Yawe ewa hia ac ézémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Yaweac wawaŋ meme imi kuneŋ yanda, imuac ségiségi waŋanʒu imi eneŋ mocʒoŋ hénia imuac niŋareŋ géanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Wawaŋ memeya imi eeya eŋeŋa, héŋgaleŋ kuc buŋayaguc. Waŋu solaŋ dindiŋanéŋ hémbénaŋa heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Haka welic welicgia imi ic embac waŋ énécmiyu niŋɋelimanec kecʒu. Yawe imi ewa hia waŋ nénécmima goi héihéi waŋ nénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Yawe imi eeya héimianʒu ionac nene yaka gumu énécmima sisipac acya hémbénaŋa nimmanec kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Inéŋ baera baera imi ic embachéra énécmima wawaŋ memeyawac kuha énézéyu héŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Mériawac wawaŋ meme imi héla ʒéma gésigési aiya imi solaŋa. Héna acya imi niŋkinʒéŋaguc. ");
INSERT INTO kgf_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Imi mia hémbénaŋawac buŋa qemimia, waŋu ewa héla ʒéma solaŋ dindiŋanec wamma memeya. ");
INSERT INTO kgf_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Yawenéŋ ic embachéra boŋhéré meénécmima sisipac ac hémbénaŋawac buŋa kumu énécmiyec. Imuac niŋac qara imi téréya ʒéma welic welicgiaguc. ");
INSERT INTO kgf_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Yaweac bac yandi yandi wawaŋa imi niŋtegic qiŋtegicac hénihénia wanʒac. Héna acya niŋtoho waŋanʒu imi eneŋ mocʒoŋ niŋtegic qiŋtegic ginaguc. Yawe mepé qepésiac haka imi ionac muru hémbénaŋa heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Haleluya, Yawe eeya héimima héna acyawac ségiségi kuneŋ yanda waŋanʒac inéŋ ʒézé ségiségiyaguc. ");
INSERT INTO kgf_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Ɋelihéra ieneŋ baeciguc kucginaguc kecmu. Ic solaŋ dindiŋa ionac ɋelihécgina ieneŋ ʒézé ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Amayaiguc mériaŋ hemimac. Hakaya solaŋ dindiŋanéŋ hémbénaŋa hemimac. ");
INSERT INTO kgf_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Ic solaŋ dindiŋa ionac imi tunumaŋ qeriaiguc asac mararaŋnéŋ éréanʒac. Asacmararaŋ iminéŋ ewa hia ʒéma ewa biric ʒéma haka solaŋ dindiŋa waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Ewa hia waŋ énécmima iwawaiyanéŋ ic tosara méra énécmianʒac imi hiaruanʒac. Inéŋ ai memaŋ ʒé héna ac séciguc dindiŋanec meanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Inéŋ qekeŋ qehaya qahac. Ic solaŋa imi hémbénaŋa niŋɋeli mimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Inéŋ gezac qéʒéŋ ac biriawac bac yandi yandi ménda waŋanʒac. Ewa qeria imi Yaweac héima naŋu waiʒalaŋa qahac. ");
INSERT INTO kgf_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Ewa qerianéŋ seligima heyu ʒénéŋ hirihiri ménda wammanec keru Haʒéchéra bakia megic inicmac. ");
INSERT INTO kgf_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Inéŋ iwawaiya méndémma maqeqeya ionac énécmiyec. Haka solaŋa imi hémbénaŋa heyu iliha imi ʒézé bipiyaguc meyac mimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Kaiʒiliweŋ ic imi haka imi hémma aric aric kima pépélima qahac wammac. Kaiʒiliweŋ ic ionac ewa siŋgina imi gorosoŋa wandacmac. ");
INSERT INTO kgf_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Haleluya, Yaweac weleŋ qeqehéra, Yaweac qara mepésigic! ");
INSERT INTO kgf_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Degucmuacnec hémbénaŋa Yaweac qara mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Baec waŋgoŋa Is igucnec Wes ac séc Yaweac qara mepési mimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Yawe imi baera baera mocʒoŋ yanda imuac qacginaiguc eŋeŋa kecʒac. Edamuya imi eŋeŋa ou kurumeŋiguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Mérénéŋ Yawe Anutunina éséc? Inéŋ ou eŋeŋa kecʒac. ");
INSERT INTO kgf_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Waŋu eŋeyaoc memaamuma kiwa hiyu mayu baec kurumeŋ héŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Hémma maqeqeya seitotoŋ igucnec meyac énécmima météqététaŋ ic muŋguc senduruŋ igucnec meyac énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Waŋu onoporu ic kiwa, ic embac ionac galeŋhécgina iniguc momacnec naŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Waŋu embac héfiŋa mehiaru miyu amaiguc bénʒéŋ kecma nambérac héra mihicŋima neŋgoc waŋ énécmima ségiségi wamma kecanʒu. Haleluya, Yawe mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Israel, Yakobo ʒémimia iwac ic embachéra ieneŋ Iʒipte baeciguc acgina méŋ ʒéaŋgic ionac murunec érégic. ");
INSERT INTO kgf_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Nalé imuaru Yuda imi Yaweac ocmuŋ téréya waŋec. Israel imi iwac ama baera waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Konduŋ imi hémma néŋgacma keŋec. Waŋu Yodan doku acguc héréma andé andé keŋec. ");
INSERT INTO kgf_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Baec boŋa imi eneŋ rama iwa ésécnec técgéma aria megic. Baec boŋa komoc komoc imi rama merawa ésécnec imuhuc waŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Konduŋ doku gi némac niŋac néŋgacma keŋnec? Yodan doku gi némac niŋac héréma andé andé keŋnec? ");
INSERT INTO kgf_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Baec boŋa ini némac niŋac rama iwa ésécnec técgéma aria megic? Baec boŋa komoc komoc ini némac niŋac rama merawa ésécnec técgéma aria megic? ");
INSERT INTO kgf_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Baec ini imi miŋ kewuninawac kiwaiguc, Yakoboac Anutu iwac wésiaiguc ʒénéŋ hirihiri wammu. ");
INSERT INTO kgf_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Inéŋ baŋa hilaŋeŋ melemma doku ʒékéŋ mihicŋima hoc selia melemma doku hogocya mihicŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Yawe, goi héihéiga ʒéma hakaga héla imuac niŋac guac qacgaiguc edamu yanda hemac. Nonac muru qahac, nonac muru qahac, guac muru hegémmac. ");
INSERT INTO kgf_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Némac niŋac baera baera ic embac ieneŋ Anutugina dimia ʒéma ʒédesi waŋ nénécmianʒu? ");
INSERT INTO kgf_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Anutunina imi kurumeŋiguc kecma imuac me imuac siŋa hemizac séc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Néŋ ionac baniara imi siliwa ʒéma goli mema ic onac méraginanéŋ memeya. ");
INSERT INTO kgf_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Kuaginaguc, néŋ ac ʒézégina qahac, kicginagucnéŋ kic hihigina qahac. ");
INSERT INTO kgf_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Gezacginaguc, néŋ ac nimmuac séc qahac. Suŋguruŋ ginaguc, néŋ wéréŋa nimmuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Méraginaguc, néŋ késa nimmuac séc qahac. Hénaginaguc, néŋ keŋha wammuac séc qahac. Waŋu déméŋginaguc, néŋ ewa hétéŋ wammuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Baniara meyacgéanʒu imi eneŋ ʒéma imuaru héima naŋanʒu imi eneŋ mocʒoŋ imuhucyanec. ");
INSERT INTO kgf_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Israel, Yaweac muru héima nammu. Inéŋ méra énécmima saiwa waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Aronac ama momachéra ini, Yaweac muru héima nammu. Inéŋ méra énécmima saiwa waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Yawe eeya héimianʒu ini, Yaweac muru héima nammu. Inéŋ méra énécmima saiwa waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Yawenéŋ niŋnénécmima mériaŋ mihicŋi nénécmianʒac; Israelac ama imuhucyanec, Aronac ama imuhucyanec. ");
INSERT INTO kgf_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Kuneŋ komora momacnec Yaweac muru héima naŋanʒu imi onac mériaŋ mihicŋi énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Yawenéŋ ini ʒéma ɋelihécgina séc méŋ meemma mesai énécmimac niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Ini imi baec kurumeŋ ʒéyu hicŋiyec Yawenéŋ mériaŋ mihicŋi énécmimac niŋ wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Kurumeŋ imi Yaweac buŋa. Waŋu baec imi ic neŋaŋ buŋa qenénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Humuc icnéŋ Yawe mepési mimuac séc qahac. Mérénéŋ hiŋgacma néŋ qema hema hia mepési mimac. ");
INSERT INTO kgf_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Nini imi deguc muacnec hémbénaŋa Yawe mepési miwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Yawenéŋ ac ewana ʒéma ʒéwelecna selia niŋnéŋanʒac imuac ni siŋa niŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Gezac qema niŋnéŋec imuac kekecnawac séc ʒéwelec wammimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Humucac hésanéŋ dérécgé néŋu kicsuaŋac ʒéra béranéŋ nuac muru hayu ʒérabéra ʒéma ewa biric mihicŋiyi. ");
INSERT INTO kgf_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Waŋu ni Yaweac qaraiguc yomuhuc ʒéweleri; Yawe ʒéwelec génʒua qeri uŋana metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Yawe imi ewa hia ʒéma solaŋ dindiŋayaguc. Anutu imi goi héihéiyaguc. ");
INSERT INTO kgf_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Yawe imi ic ewa éréhéc ménda wawaŋa galeŋgé énécmianʒac. Ni mematiti waŋ nénéŋawac kecba aŋgéŋna tiyec. ");
INSERT INTO kgf_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Kekec uŋana, liliŋgéma hama bénʒéŋ kecbésémaŋ. Yawenéŋ goihéihéi waŋgénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Inéŋ kekec uŋana imi humuc igucnec ʒéma kicna imi kic masi igucnec, waŋu hénana imi qonʒontoŋ igucnec metecgé néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Kekecninaguc kecanʒiŋ baec yomuaru ni imi Yaweac wésiaiguc keŋha wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Ni yéwéri kuneŋ yanda mihicŋizua imuhuc ʒéma keri nalé imuaru ninʒéŋgéma keri. ");
INSERT INTO kgf_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Focdac nimba ménda sécgéyu ic momac yanda imi ikoc ic ʒéyi. ");
INSERT INTO kgf_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","Ewa hiawac buŋa Yawenéŋ néŋec imi némac iwawainéŋ bakia meleŋmimaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Ni kekecna aŋgéŋ tinénéŋawac sokoc mema Yaweac qara qacma ");
INSERT INTO kgf_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Yaweac ic embachéra momac yanda ionac wéséginaiguc ʒézé selinawac tasia imi Yawe meleŋ mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Météré ic méŋnéŋ humuyu Yawenéŋ niŋu eeyaguc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Yawe ni hélacnec weleŋ qeqe icga wanʒua. Guac weleŋ qeqe embacgawac naŋa guac weleŋ qeqe ic wanʒua. Geŋ mia dérécgé nénéŋa imi hulac nénnec. ");
INSERT INTO kgf_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Ni guac muru ewa hiawac mulu haigémma Yawe guac qacga qacmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Ni Yaweac ic embachéra momac yanda ionac wéséginaiguc ʒézé seli acnawac tasia Yawe guac muru meleŋ gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","O Yerusalem, tacyachécga ionac sucginaiguc, Yaweac ocmuŋ téréyaiguc taséna meleŋ mimaŋ, haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Baera baera icembac ini Yawe mepésimigic. Ic embac momac yanda ini ʒéhiaru migic. ");
INSERT INTO kgf_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Anutuac goi héihéi imi nonac muru kuneŋ yanda he nénécmizac. Waŋu Yaweac haka héla imi hehe seli naŋselimac, haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Yawe ewa hia ac ʒémigic. Inéŋ hiabia waŋu goi héihéiya imi hémbénaŋa heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Israel ini goi héihéianéŋ hémbénaŋa ʒéma ʒémimu. ");
INSERT INTO kgf_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Aronac ama ini goi héihéianéŋ hémbénaŋa ʒéma ʒémimu. ");
INSERT INTO kgf_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Yawe eeya héimianʒu ini goi héihéianéŋ hémbénaŋa ʒéma ʒémimu. ");
INSERT INTO kgf_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Ni qenʒeŋ manʒeŋiguc Yawe qachéhéli miwa Yawenéŋ acna meleŋ némma ni baec kondoŋa yandaiguc hulac néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Yawe imi niguc kecʒac. Ni bac yandi yandi ménda wanʒua. Baec ic mérénéŋ némac waŋnémmac? ");
INSERT INTO kgf_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Yawenéŋ niguc kecʒac. Méra néŋanʒu ionac sucginaiguc kecʒac. Imuac haʒéc waŋ nénʒu imi bakia meleŋ énécmiyu hémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Yaweac muru héima nanaŋ imi ic onac héima nanaŋ ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Néŋgacma Yaweac muru keŋkeŋa imi galeŋ ionac niŋkinʒéŋ wawaŋa imi ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Baera baera icembac ieneŋ ni lelecgé nénʒu, néŋ ni Yaweac qaraiguc qeric énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Ieneŋ ni lelecgéma wésé andu lelecgé nénʒu imuac ni Yaweac qaraiguc qeric énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Ieneŋ morombazec ésécnec ni lelecgé nénʒu, néŋ sécmaŋ imuac geric bélaŋa ésécnec focdac ʒedacmu. Ni Yaweac qaraiguc qeric énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Néfacgé néŋgic manumaŋ ʒé waŋec, néŋ Yawenéŋ méra néŋec. ");
INSERT INTO kgf_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Yawe imi nuac kucna ʒéma mepé qepésina. Waŋu inéŋ nuac aŋgéŋ titina wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Ic solaŋawac haliiguc ʒézé ségiségi, aŋgéŋ titiac hériaŋ hicŋima hezac. Yaweac méra héiyanéŋ kuc yanda mihicŋima ");
INSERT INTO kgf_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Yaweac méra héiya imi ou meyac mimiawac hezac. Yaweac méra héiyanéŋ kuc mihicŋi nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Ni ménda humuma kicɋeli kecma Yaweac wawaŋ meme imi ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Yawenéŋ yéwéria humumia mihicŋi némma mindi qindiŋi néŋec, néŋ humucac buŋa ménda noporec. ");
INSERT INTO kgf_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Haka solaŋawac naguya naguya audacgic, ni keremma Yawe ewa hia ac ʒémimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Nagu imi Yaweac saŋgulaŋ, ic solaŋanéŋ imuacnec keremmu. ");
INSERT INTO kgf_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Inéŋ acna meleŋ némma nuac aŋgéŋ titina waŋec. Imuac ni miŋ kewu mepésimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Mericqe ic ieneŋ hoc méŋ héŋara mema giligic keŋkeŋa iminéŋ ama waŋgoŋaiguc ama imuac hoc oruha waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","Haka imi Yawenéŋ waŋec. Waŋu hénni kicninaiguc haka welic welicgia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Nalé yomi Yawenéŋ meyu heyec. Nalé imuaru nini ʒézé ségiségi wammanec ségiségi wambiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Yawe ʒéwelec génʒiŋ; Aŋgéŋnina tina. Nini ʒéwelecgénʒiŋ; Mehiaru nénécmina. ");
INSERT INTO kgf_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Yaweac qaraiguc hahaya imi mériaŋaguc. Nini Yaweac ocmuŋ téréyaiguc mériaŋ ac waŋgénʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Yawe imi Anutu, neŋaŋ muru qetagali nénécmiyec. Ic hésa haréŋa mema ségiségiac areŋiguc toroqema naŋgic, ʒaki téréya ilihaiguc kerembiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Gi imi Anutuna, ewa hia ac ʒégémmaŋ. Gi imi Anutuna, ni meyac gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Yawe ewa hia ac ézégic! Goi héihéiya imi hémbénaŋa heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Wawaŋ meme solaŋanec Yaweac héna ac méndacma wamma meanʒu imi eneŋ ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Yaweac héna ac niŋtohoma ewa qeri mocʒoŋnec Yaweac ewama kecanʒu imi eneŋ ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Ieneŋ haka biria ménda wamma iwac héna acya wamma meanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Geŋ héna ac ʒéseli nénécmima imi niŋtohodacbiŋ niŋac nénézénec. ");
INSERT INTO kgf_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Kekecac hénananéŋ imuhucyanec hemac niŋac wanʒua. Héna acga keŋhéi hahéi qahac niŋtohomaŋ niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Guac héna acga mocʒoŋ nimma héiɋelima kecmaŋ imi gamunaguc ménda wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Ʒégésigési aiga solaŋa niŋareŋgémaŋ imuaru ewa qeri solaŋanec mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Ni guac ʒézé seliga wamma medacmaŋ. Ni mocʒoŋ ménda wainémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Sac ɋeli méŋnéŋ némacnéŋ eŋeya wawaŋ memeya lalac lalac galeŋgéma kecmac? Imi mia ackuaʒécga méndacma kecma imuhuc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ni ewa qeri mocʒoŋnec guac hochoc ai meanʒua. Méra nénna guac héna acga ménda waima kemmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ni guac muru képésic ménda wammaŋ niŋac ackuaʒécga ewa qerinaiguc haiwa hezac. ");
INSERT INTO kgf_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Yawe, gi imi ʒéhiaru géŋgéŋa wanʒac. guac héna ac imi ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Kuagawac ʒézé seli ac mocʒoŋ kuananéŋ ʒéauanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ni baecac iwawai niŋac ségiségi waŋanʒua ésécnec guac héna acgawac ségiségi waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ni héna acga nimba hiŋgaru héna acga héŋ sosolianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ni guac ʒézé seli acga mocʒoŋ imuac me imuac ségiségi wamma ackuaʒécgawac eluŋ ménda numac. ");
INSERT INTO kgf_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Weleŋ qeqe icga hiabia waŋ nénna kecmaŋ. Imuhuc waŋ nénna ackuaʒécga niŋtohomaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Uŋanawac kiwa mebéréŋgéna héna acgawac hénia welic welicgia imi héŋtegicmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Baeciguc ic kiaŋ wamma kecʒua, héna acga imi ménda musaŋgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Héna acgawac nalé séc niŋkumuma kecba kekec uŋananéŋ kuha qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Séwi eŋeŋ ic saecginaguc héna ac waima keŋanʒu imuhucya ac geriwaguc waŋ énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Ni guac ackuaʒéc niŋtohoanʒua. Imuac ʒébiri qébirigina ʒéma mema titigina imi nuac murunec nesina keŋu. ");
INSERT INTO kgf_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Galeŋ eneŋ acguc tacma ʒébiri qébiri wannéŋgic, néŋ weleŋ qeqe icga ni imi héna acga nimma héiɋeliyi. ");
INSERT INTO kgf_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Guac héŋgaleŋ héna ac imi ségiségina ʒéma ʒéqindiŋi icna wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Qeri uŋananéŋ gizoŋiguc héima hezac, ackuaʒécga méndacma ni meɋeli némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Wawaŋ memena gézéwa acna meleŋ nénnec. Imuac guac héna ac imi ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Méra nénna ʒézé seli acgawac héna niŋtegicmaŋ. Imuhuc waŋ nénna guac haka welic welicgia imi nimma héiɋelimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Kekec uŋana imi helanʒi mimia waŋu pépélima mazac. Ackuaʒécga méndacma ni meyac nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Haka ikora, wawaŋ memena ikora metecgéna keŋu. Héna acga imi ewa hiawac bénʒéŋnec ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Ni héna héla méndacma héna acga wésénaiguc haianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Ni guac héŋgaleŋ héna ac imuaru qéqéhéréŋ kecanʒua. Yawe ménda wainénna gamunaguc wambi niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Ewa qerina meyandina hilaŋeŋ yanda waŋu ʒézépaŋ acgawac hénaiguc usuŋnec kemmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Yawe guac ʒézé seli acgawac héna imi ni ku nénna niŋtohomanec kemma kecma humumaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Méra nénna niŋtegicma héna acga niŋtohoma ewa qerina mocʒoŋnec wamma memaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Héna acga hezac imuac héna nézéna hémma tima kemmaŋ. Ni imuac ségiségi waŋanʒua imuac mia imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Ewa qerina meleŋna hémbaoc qahac, néŋ héna acgawac niŋkumu wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Kicna meleŋ nénna iwawai gorosoŋawac kic hihi ménda wammaŋ. Kekecna imi ackuaʒécga méndacma galeŋgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Eega héianʒu ionac guac sisipac acga ʒéselinec imi weleŋ qeqe icga nuac muru meselina. ");
INSERT INTO kgf_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Guac héna acga imi hiabia imuac niŋac ionac mema titigina ʒénéŋ hirihiri mihicŋi nénéŋa imi nesina keŋu. ");
INSERT INTO kgf_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Pakeŋ acgawac niŋkumuma kecanʒua. Solaŋ dindiŋaganéŋ ni héiɋeli néŋna. ");
INSERT INTO kgf_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Ackuaʒécgawac séciguc goi héihéiga imi ʒéma aŋgéŋ titiga imi hainémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Imuhuc waŋ nénna ʒébiri qébiri waŋ néŋanʒu ionac ac bakia mihicŋima énézémaŋ. Ni ackuaʒécga imuaru héima naŋanʒua imuac mia imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Ni héna acgawac niŋkumuma kecanʒua, imuac mia naŋgé nénna ac hélanéŋ kuana igucnec komodia méŋ ménda waima kemmac. ");
INSERT INTO kgf_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Ni héna acga nalé séc hémbénaŋa niŋtoho wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Ni héna acgawac ʒéwelecanʒua imuac solaŋanima keŋha wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Waŋu ic kewu momac yanda ionac wéséginaiguc guac héna ac ʒémaŋ nalé imuaru gamunaguc ménda wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Ni guac ʒézé seli acgawac niŋsiŋsiŋ waŋanʒua imuac niŋac imuaru ségiségi mihicŋianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Ʒézé seli acga hénia hénia niŋsiŋsiŋ waŋanʒua. Imuac mérana meyacma mepési génʒua. Ni héna ac imi nimma héiɋelianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Ackuaʒéc weleŋ qeqe icgawac ʒénec imuac niŋɋeliwésémaŋ. Geŋ ac imi ʒéma ewa qerinaiguc niŋkumu kumuna mihicŋi nénnec. ");
INSERT INTO kgf_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Iminéŋ yéwéri qeriaiguc ewana mehiaruanʒac. Ackuaʒécganéŋ kekec wésé polaŋaguc mihicŋi nénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Tétéc qeqe ic eneŋ gelec malec qahac ʒédesi néŋgic, néŋ ni guac héna ac imi ménda waiyi. ");
INSERT INTO kgf_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Yawe ni héna ac wahala imi niŋɋelima ni nenaoc mehiaru amuyi. ");
INSERT INTO kgf_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Ic biria héna acga andé qegic ionac niŋac qeri geric kuneŋ yandanéŋ népésizac. ");
INSERT INTO kgf_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Ama méŋu ic kiaŋ wamma tacba héna acganéŋ legic ʒéra hénia hénia waŋu héianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Yawe, ni siŋiyaiguc qacga niŋɋelizua. Héna acga imi niŋtoho wamma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Héna acga niŋtohowa kekec iminéŋ nuac mériaŋna wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Yawe, gi imi nuac buŋana ni ackuaʒécga imi niŋtohomaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Ni ewa qerina mocʒoŋnec kic tanecgawac ʒéwelecʒua. Ackuaʒécga ʒénec séc ewa hia niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Ni wawaŋ memena niŋgésima hénana melemma héna acgaiguc hazua. ");
INSERT INTO kgf_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Nalé ménda mehorugima héna acga focdac niŋtohomaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Kaiʒiliweŋ ic ionac hésanéŋ ni ɋaté néŋec, néŋ ni héna acgawac eluŋ ménda nuyec. ");
INSERT INTO kgf_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Guac héna ac solaŋa niŋac siŋiyaiguc yacma ewa hia ac gézémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Ni imi bac yandi yandi waŋgémma guac héna acga niŋtohoanʒu ionac alagina wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Yawe, goi héihéiganéŋ baeciguc sécgéma hezac. Héna acganéŋ ni ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Yawe, ackuaʒécga ʒénec séc weleŋ qeqe icga ni hiabia waŋ nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Ni héna acga ninʒéŋgézua. Niŋtegic qintegic ʒéma niniŋ ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Ʒérabéra qahac keri imuaru imi ni sicsaoc wamma keri, néŋ deguc imi ackuaʒécga tohoma wamma meanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Gi imi hiabia imuac wawaŋ meme hiabia waŋanʒaŋ. Héna acga nézéma ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Tétéc qeqe ic eneŋ ikoc mihicŋima mebiri némbiŋ ʒé waŋanʒu, néŋ ni imi ewa qeri mocʒoŋnec héna acga niŋtoho waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Ionac ewa qerigina imi haléc dépaŋ yanda ésécnec, néŋ ni imi héna acgawac ségiségi waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Ʒérabéra imuac nimba méra nénéŋa wanʒac. Iminéŋ waŋnéŋu ni héna acga niŋareŋgéyi ");
INSERT INTO kgf_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Kuagawac héna acnéŋ siliwa goli sasala ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Méraganéŋ ni mihicŋima kumu nénnec. Imuac méra nénna niŋtegicma héna acga niŋareŋgémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Ac kua ʒécgawac niŋac niŋkumuma kecba eega héigéŋanʒu imi eneŋ ni némma ségiségi waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Yawe, ni ʒégésigésiga imi solaŋa wanʒac imi ʒéma hakaga héla imuaru héima namma yéwéri mihicŋi nénnec imi ninʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Ʒéwelec génʒua, weleŋ qeqe icga sisipac ac waŋ nénnec séc méndacma waŋ nénna goi héihéiganéŋ ewana mehiarumac. ");
INSERT INTO kgf_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Guac ewa biric wawaŋawac hakanéŋ wannémma humuc igucnec meɋeli nénna. Héna acga imi nuac ʒézé ségiségina wanʒac imuac mia imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Tétéc qeqe ic eneŋ héniana qahaciguc yéwéri mihicŋi nénʒu. Gamugina mihicŋi énécmina. Ni imi héna acga ʒénimma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Eega héigéŋanʒu imi waŋ énécmina nuac liliŋgéma hamu. Imuhuc wanna ieneŋ héipuc acga imi niŋasarimu. ");
INSERT INTO kgf_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Ewa qerina mehiaruna héna acgawac séc képésicna qahac waŋu gamunaguc ménda wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Kekec uŋananéŋ aŋgéŋ titigawac nalé herec niŋkumu wamma kecma ɋiritic qezac, néŋ ni héna acgawac niŋkumu wammanec kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Kicna imi sisipac ac imuac hélawac mambéc kecma kucmama wanʒac. Qesigénʒua, gi némac naléiguc ewa qerina mehiaru némbésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Tanecna imi kiruŋ yaŋ séwélanéŋ memeya imi hofac qeriaiguc ʒapi qeyec ésécnec wanʒac, néŋ guac héna acga imi eluŋ ménda nuanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Weleŋ qeqe icgawac naléya imi dahec hezac? Nunesi waŋnéŋanʒu imi némac naléiguc ac geriwaguc waŋ énécmiwésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Tétéc qeqe ic héna acga ménda tohoanʒu. Imi eneŋ mebiri némbiŋ ʒé baec séséŋ ésézu. ");
INSERT INTO kgf_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Ieneŋ héniana qahaciguc ni nunesi waŋ nénʒu, Méra némbésémaŋ. Guac héna ac imi mocʒoŋ hélacnec! ");
INSERT INTO kgf_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Ieneŋ imi baec igucnec metecgé némbiŋ ʒé humumia nugic, néŋ ni guac héna acga ménda waiyi. ");
INSERT INTO kgf_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Goi héihéiga niŋac wamma meɋeli nénna. Imuhuc waŋ nénna kuagawac héipuc ac imi niŋtoho wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Yawe, guac ackuaʒécga kurumeŋiguc hémbénaŋa seligima hezac. ");
INSERT INTO kgf_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","hakaga héla iminéŋ hicŋisaiya hicŋisaiya hema emma kecmac. Baec imi geŋ hainecac nalé séc seligima heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Iwawai imi mocʒoŋ méra bacgaiguc hezac imuac mia baec kurumeŋnéŋ kuaga tohoma heyecac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Héna acganéŋ ségiségi ménda mihicŋi némbacnec qenʒeŋ manʒeŋ qeriaiguc bec humuwinec. ");
INSERT INTO kgf_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Gi héna acnéŋ kekecna galeŋgéna kecanʒua imuac ni héna acgawac hémbénaŋa eluŋ ménda numac. ");
INSERT INTO kgf_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Ni imi guac buŋa. Imuac mehiaru nénna. Ni héna acgawac hochoc wamma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Kaiʒiliweŋ ic ieneŋ nuhumuwiŋ ʒé néŋsosolima kecanʒu, néŋ ni guac héna ac nimma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Neŋ hémba iwawai solaŋa ʒézéya imi mocʒoŋ qétégina olombiŋac séc, néŋ héna acga imi hilaŋeŋ yanda qétéya olombiŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Yei ni héna acga kuneŋ yanda niŋsiŋsiŋ waŋanʒua. Ni kaiwe herec imuac nimma héiɋelianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Héna acganéŋ nalé séc niguc hema méra néŋu haʒéchécna onogicma niŋtegic qiŋtegicna kuneŋ yanda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Ni héna acga nimma héiɋeliwa kiwi ichécna mocʒoŋ onogicma niŋtegic qiŋtegicna kuneŋ yanda henénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Héna acga niŋtohowa ic yanda mocʒoŋ onogicma niŋtegic qiŋtegicna kuneŋ yanda henénʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Ni ackuaʒécga niŋtoho wammaŋ ʒé hénana neuŋ héima héna biria hénia hénia ménda kereŋi. ");
INSERT INTO kgf_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Geŋ héna ac ku nénnec imuac niŋac ni héna ac ménda waianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Ackuaʒécga imi yei siŋa kuneŋ yanda, kuanaiguc morombazecac dokuya ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Héna acgawac niŋac niŋtegic qiŋtegicnaguc wanʒua. Imuac haka ikora hénia hénia imuac méʒéna tianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Ackuaʒécganéŋ hénanawac kifa wamma baec hénawac asaha wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Héna acga solaŋa imi niŋtohomaŋ ʒé ʒéselima acna selianec ʒikizua. ");
INSERT INTO kgf_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Qenʒeŋ manʒeŋna imi gelec malec qahac imuac ackuaʒécgawac séc galeŋgé nénna kekecnaguc kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Yawe, ʒéwelec génʒua. Mepé qepésiac legic kuana igucnec imi aŋgétima héna acganéŋ ni ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Kekecna imi nalé séc humucac déciguc hezac, néŋ guac héna ac imi eluŋ ménda nuanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Kaiʒiliweŋ ic ieneŋ mebiri némbiŋ ʒé bétac haigic hezac, néŋ ni héna acga ménda waizua. ");
INSERT INTO kgf_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Héna acga imi hémbénaŋa mératécnawac buŋa opocba hezac. Iminéŋ ewa qerinawac ʒézé ségiségi waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Ni héna acga tetecgia qahac niŋtohomaŋ ʒé ewa qerinanéŋ doŋgéma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Ni ewa éréhéc waŋanʒu ionac méʒé titi wamma héna acga imuac siŋa niŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Gi imi nuac saŋgi saŋgina, nuac saiwa, ni ackuaʒécgawac niŋkumu wamma kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Biria meme ini wainémma keŋgic. Ni imi Anutunawac héna ac niŋtoho wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Ackuaʒécgawac séc ni népésima meɋeli nénna kecmaŋ. Galeŋgé nénna niŋkumunanéŋ gamuyaguc ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Népésima aŋgéŋna tina héna acgawac nalé séc kic hihi wamma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Héna acga waima kenʒu imi gi elicgé énécmianʒaŋ. Imi mia hakagina ikora imi gorosoŋa waŋanʒac imuac mia imuhuc waŋ énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Gi imi baeciguc ic biria imi nenesic ésécnec gilina keŋanʒac. Imuac ni héna acga siŋa niŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Séwinanéŋ guac bac yandi yandi wamba hirizac. Ni ʒégési gésigawac bac yandi yandi waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Ni haka solaŋa wamma héna acac séc wamma kecanʒua. Helanʒi néŋanʒu ionac méraginaiguc ménda nopocna. ");
INSERT INTO kgf_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Meseli nénna mériaŋnaguc kecba, tétéc qeqe ic eneŋ ni hia ménda helanʒi némmu. ");
INSERT INTO kgf_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Guac aŋgéŋ titi ʒéma guac ackuaʒéc solaŋawac kic hihi wamma kecba kicnanéŋ birizac. ");
INSERT INTO kgf_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Goi héihéiga méndacma weleŋ qeqega ni hia waŋ némma héna acga ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Ni imi guac weleŋ qeqe icga. Niŋtegic qiŋtegic mihicŋi nénna héna acga niŋasarimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Ic embac eneŋ héna acga qegic madacʒac. Deguc imi guac ai memegawac nalé wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Imuac ni imi héna acga goli, goli solaŋa ogicma eeya héianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Imuac ni wawaŋ memenawac séc héna acac nimba dindiŋa waŋu haka ikora mocʒoŋ imuac nimba méʒétitiyaguc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Héna acga imi welic welicgia imuac kekec uŋananéŋ niŋtoho waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Ic diwi qiwiliŋanéŋ ackuaʒéc auma oloŋu qetagalimiyu niŋtegic qiŋtegicyaguc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Kazunéŋ doku niŋac ezelaŋa tacgéyu kuaya aŋgéma wésésé kucnec héianʒac ésécnec ni héna acgawac niŋkumuma imuhuc waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Qacga eeya héianʒu ionac haka waŋ énécmianʒaŋ ésécnec nuac liliŋgéma ewa biric waŋ nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Hénana ackuaʒécgaiguc meseligima képésic méra bacyaiguc ménda nopocna. ");
INSERT INTO kgf_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Ic embac helanʒi nénécmianʒu ionac murunec ni metecgé nénna, ni héna acga hia niŋtoho wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Kic tanecga asahagucnéŋ ni némma héna acganéŋ ni ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Ic embac eneŋ héna acga ménda niŋtohoanʒu imuac kic masinanéŋ doku téfara ésécnec maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Yawe, gi imi solaŋa, guac ʒégésigésiga imi hélanec. ");
INSERT INTO kgf_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Héna acga ʒéselinec imi solaŋa ʒéma héla téŋgéŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Haʒéc hécnanéŋ ackuaʒécga eluŋ unuyu ni guac ackuaʒécgawac niŋkewu wamba geric bélaŋ ésécnec nozac. ");
INSERT INTO kgf_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Ackuaʒécga imi solaŋa imuac guac weleŋ qeqe icganéŋ imuac niŋsiŋsiŋ waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Ni ic mamaya kecba mema titi waŋ nénʒu. Néŋ héna acga imuac eluŋ ménda nuanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Dindiŋaga imi dindiŋa hehe selia, waŋu héna acga imi héla. ");
INSERT INTO kgf_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Nunesi ʒéma niŋyéwécnanéŋ népésizac, néŋ kileŋ ʒézé seli acganéŋ ségiségi mihicŋi néŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Guac ʒéauauganéŋ hehe seli solaŋanec hema kecmac. Niŋtegictegic mihicŋi nénna kekecnaguc kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Ni qeri howiacnec guru héhélizua, O Miŋ Kewu niŋnénna ni héna acga imi niŋtohomaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Ni Miŋ Kewu gi guru héhélizua ni metecgé nénna ʒéauau acga imi wamma mema kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Ni ama ménda giaŋiyunec yacma guruanʒua, guruma acgawac mambéc kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Guac ackuaʒécga imi hiŋgac hiŋgarawac nimmaŋ ʒé siŋi ménda horugiyunec kic ɋeli yacanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Goi héihéigawac wamma ewa hétéŋna niŋna. O Miŋ Kewu ʒéqindiŋigawac séciguc kekecna héŋgaleŋ wanna. ");
INSERT INTO kgf_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Haka biria méndacma waŋanʒu imi eneŋ hosucnu nesinénʒu. Ieneŋ imi héna acga andé qema kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Miŋ Kewu gi mia hosucgé némma kecʒaŋ. Waŋu héna acga imi mocʒoŋ hélacnec. ");
INSERT INTO kgf_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Ʒéauau acga imi becarunec niŋareŋgéyi. Guac ac imi hehe seli hemac niŋ hainec. ");
INSERT INTO kgf_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Ʒéra waiʒalaŋna hémma metecgé néŋna, ni héna acgawac ménda eluŋ nuanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Nuac héipuc ac énézéma boŋhéré menémbésémaŋ waŋu ʒézé seli acgawac séciguc kekec ɋelia hainémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Kaiʒiliweŋ ic ieneŋ ac seligawac hochoc ai ménda meanʒu. Imuac niŋac ionac imi aŋgéŋ titiganéŋ ménda hosucgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","O Miŋ Kewu, gi qeri bénʒéŋga yéwéria imuac ʒémindi mindiŋigawac séciguc kekecna meɋeli nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Sasalanéŋ nunesi wamma haʒéc waŋnéŋanʒu. Waŋu ni mia ʒéauau acga ménda waianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Ni acqeqe ic inicba Ieneŋ héna acga ménda tohoanʒu imuac niŋac lommaŋ ʒé wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Ni héna acga dimuhuc niŋsiŋsiŋ wammianʒua imi kicga hina mayu hénna. Yawe, goi héihéiga séciguc kekecna meɋeli nénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Acga mocʒoŋ héla wanʒac. Waŋu ʒégésigésiga dindiŋa mocʒoŋ hehe seli hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Galeŋ eŋeŋa ieneŋ téŋésima nunesi wanʒu. Néŋ qerinanéŋ ackuaʒécgawac eeya héimianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Ni imi hinac yanda onagicma ségiségi waŋanʒu ésécnec ni ʒézé seli acgawac ségiségi wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Ni ikocwac méʒéna tiyu ewa loloŋ waŋ néŋanʒac, néŋ héna acgawac siŋa imi niŋiac niŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Gésigési acga imi dindiŋa, imuac niŋ kaiwe séc hatac 7 mepési géŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Héna acgawac siŋa niŋanʒu ieneŋ luae kuneŋ yanda mihicŋianʒu. Ionac muru imi iwawai qonʒontoŋgé énécmimia méŋ ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Yawe, ni guac aŋgéŋ titiac kic hihi wamma guac héna acga tohoanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Kekec uŋananéŋ ʒéauau acga méndacanʒac. Ni imuac siŋa kileŋ yanda niŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Hénana imi mocʒoŋ kicgaiguc hedacʒac, imuac ni guac héna acga ʒéma ʒéauau acga tohoanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","O Yawe qac héhélinanéŋ wéségaiguc érémac niŋac wanʒua. Waŋu acgawac séciguc niŋtegic qiŋtegic hainénna. ");
INSERT INTO kgf_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Welec welecnanéŋ wéségaiguc érémac. Ackuaʒécgawac séciguc metecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Geŋ héna acga ku néŋanʒaŋ imuac niŋ kua taséna igucnec ʒézé ségiségi dunduŋaguc maanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Ʒézépaŋ acga imi mocʒoŋ solaŋanec. Imuac ezelaŋnanéŋ ackuaʒécgawac ʒézé ségiségi wammac. ");
INSERT INTO kgf_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Ni héna acga aŋgétiyi imuac niŋ méraganéŋ méra némmac. ");
INSERT INTO kgf_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","O Yawe, ni aŋgéŋ titigawac qerina héŋgeŋ héŋgeŋ waŋ néŋanʒac. Waŋu héna acgawac ewa hia niŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Qeri uŋana meɋeli nénna ʒéhiaru gémmac. Héna acganéŋ méra némmac. ");
INSERT INTO kgf_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Ni rama soho sohoya ésécnec rouc wamma kecʒua. Néŋ ni héna acgawac eluŋ ménda nuanʒac imuac weleŋ qeqe icga ni mihicŋi némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","(Ocmuŋ téréyaiguc eŋeŋawac legic.) Ni ʒérabéra qeriaiguc kecma kewu yomuhuc welecmiwa niŋnéŋec; ");
INSERT INTO kgf_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","O, Miŋ Kewu ic kua taséya ikora ʒéma ezelaŋa ikora igucnec metecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Ezelaŋ ikoraguc gi, Anutunéŋ némac waŋgémmac? Némac toroqema waŋgémmac? ");
INSERT INTO kgf_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Ic kawaliac tewi merawa ʒéraguc ʒéma ʒunipa ic geric weŋweŋagucnéŋ bakia meleŋ gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Ewa biric, Meseke baeciguc kekera nidac imuhucya, ewa biric Kedarawac haliiguc kekera nidac imuhucya. ");
INSERT INTO kgf_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Ni nalé horua luaeac méʒégina tianʒac ic imuhucya iniguc kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Ni luaeac wamma ac ʒéwa ieneŋ yaré qewiŋ ʒé wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","(Ocmuŋ téréyaiguc eŋeŋawac legic.) Ni kicna hiwa baec boŋaiguc enʒac. Méra nénéŋa imi dimuarunec hamac? ");
INSERT INTO kgf_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Méra nénéŋa imi baec kurumeŋ mihicŋiyec Yawe iwarunec hamac. ");
INSERT INTO kgf_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Inéŋ niŋu hénaga ménda tisurac géwésémaŋ. Galeŋga iminéŋ gau niŋac sicgéturuc ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Israel héŋgaleŋ wammianʒac inéŋ sicgéturuc me gau yanda ménda hemac. ");
INSERT INTO kgf_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yawe imi galeŋga kecanʒac. Yawe imi amiaga, héigaiguc nanaŋa. ");
INSERT INTO kgf_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Imuac kaiweiguc kaiwenéŋ ménda mebiri gémmac. Waŋu siŋiiguc masonéŋ acguc ménda mebiri gémmac. ");
INSERT INTO kgf_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Yawenéŋ galeŋgé gémma ʒérabéra mocʒoŋ yanda imuacnec aŋgéŋ tigéŋanʒac. Waŋu kekec uŋaga imi galeŋgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Yawenéŋ keŋkeŋ hahaga imi deguc muacnec hénima hémbénaŋa galeŋgémac. ");
INSERT INTO kgf_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","(Ocmuŋ téréyaiguc eŋeŋawac legic, Dawidinéŋ oyec.) Ic eneŋ Yaweac ocmuŋiguc enni ʒéma nézégic nimma ségiségi waŋi. ");
INSERT INTO kgf_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","O Yerusalem! Hénaninanéŋ guac demiŋ qeriaiguc tima nanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","O Yerusalem, tanecga imi héiɋelima megic amaya amaya toroqema qiŋ héima tacʒac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Ama areŋ yanda imuaru mia Yaweac qara mepési miwiŋ ʒé Miŋ Kewuac hénaoriŋ Israel énézéyec imuac séciguc enʒu. ");
INSERT INTO kgf_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Hénia imi yomuhuc; Imuaru mia ʒégésigésiac tatac eeyaguc imi sasala haiyecac tacma kenʒac. Imi mia tatac eeyaguc Dawidiac ama imuac buŋa qemimia. ");
INSERT INTO kgf_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Yerusalemwac luae niŋac ʒéwelecgic. Yerusalem guac siŋga niŋanʒu imi eneŋ ewa déŋ wamma kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Demiŋga qeriaiguc luae hema kecmac. Ama areŋga demiŋ seliaguc imuac qeriaiguc mériaŋ hema kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Ala sac taséhécna ionac niŋac wamma ʒémaŋ; Demiŋga qeriaiguc luae hekecmac. ");
INSERT INTO kgf_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Anutunina Yaweac ocmuŋ niŋac wamma Yerusalem gi mériaŋgaguc wambésémaŋ niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","(Ama téréyaiguc eŋeŋawac legic.) Kurumeŋiguc tacyac waŋanʒaŋ Miŋ Kewu guac mia ni kicna hiwa érézac. ");
INSERT INTO kgf_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Ninʒaŋ, weleŋ qeqe merac eneŋ miŋginawac méraiguc kic hianʒu ésécnec, waŋu weleŋ qeqe embac eneŋ embac kuneŋginawac méraiguc kic hianʒu éséc kicnina imi Miŋ Kewu Anutuninawac himanec kecni ewa hia waŋ nénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","Yawe ewa hia waŋ nénécmina. Mematiti humumianéŋ kuaya qeqeya sécgé nénécmizac. ");
INSERT INTO kgf_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Yéwéri qahac bénʒéŋnec kecanʒu ieneŋ ʒédesi nénécmima mema titi waŋ nénécmigic kekec uŋaninaiguc sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","(Dawidiac ocmuŋiguc eŋeŋawac legic.) Nonac muru kec nénécmiaŋec imi Yawe qahac ʒéma ninʒaŋiguc, Israel imi yomuhuc hia ʒémac; ");
INSERT INTO kgf_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","Ic ieneŋ haʒéc waŋ nénécmima yacgic nalé imuaru Miŋ Kewunéŋ nonac muru ménda kecnénécmiyec iguc, ");
INSERT INTO kgf_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","ionac qeri biricginawac bélaŋanéŋ ʒeyec nalé imuaru nini ɋeliɋeli keriŋnec focdac ɋécgé nénécmiwunec. ");
INSERT INTO kgf_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Waŋu imuaru doku ɋaoŋanéŋ qacninaiguc hoturu nénécmima nénépésima kerembacnec. Waŋu doku dunduŋanéŋ qeri uŋanina hoturu nénécmiyu hiŋgacbiŋnec. ");
INSERT INTO kgf_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","Waŋu doku dunduŋanéŋ tétéc qeamuma hoturu nénécmiwacnec. ");
INSERT INTO kgf_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Ʒécginaiguc nini neneginawac buŋa ménda hai nénécmiyec Miŋ Kewu imi mepésiwiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","Neinéŋ ʒuŋ meme ic ionac bétac igucnec néŋgacanʒac ésécnec bétac imi tegiru néŋgacdacʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Méra nénécmimia imi baec kurumeŋ ʒéyu hicŋiyec Yawe iwac qaraiguc hezac. ");
INSERT INTO kgf_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","(Ocmuŋiguc eŋeŋawac legic.) Yaweac héima naŋanʒu imi eneŋ Zion boŋanéŋ Yerusalem lelecgémima ménda hirima hémbénaŋa qiŋ héima tacselizac ésécnec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Baec boŋa imuac sia yandanéŋ Yerusalem lelecgéma nanʒac ésécnec Yawenéŋ hénaoriŋ héra deguc muacnec hémbénaŋa lelecgé énécmima kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Ic solaŋa ieneŋ képésic wambiŋ ʒé méragina suluwu niŋac Anutunéŋ imuhuc waŋ énécmianʒac. Ic biria ionac ic kewuac ɋarucnéŋ ic solaŋa ionac buŋa qeénécmimia baec imuaru ménda galeŋgé énécmima kecmac. ");
INSERT INTO kgf_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Yawe gi ic hiabia ʒéma ic qeri solaŋ kecanʒu ionac mia hiabia waŋ énécmina. ");
INSERT INTO kgf_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Eŋaŋ héna ɋariŋ ɋariŋgiawac liliŋgéma keŋanʒu imi onac imi Yawenéŋ waŋ énécmiyu biria meme ic iniguc momacnec kemmu, néŋ Israel ionac muru imi luae hema kecmac niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","(Ama téréyaiguc eŋeŋawac legic ʒéra.) Yawenéŋ hésa ic imi onagicma amagina Zioniguc liliŋgéma hayec nalé imuaru nini haka imi hénni gau tanec waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Nalé imuaru imi kuanina imi ʒédesi yandanéŋ sécgéyec. Ezelaŋnina imi legicnéŋ sécgéyec. Waŋu baera baera ic embac ieneŋ Yawenéŋ ionac niŋac wamma haka kuneŋ yanda meénécmizac ʒéma ʒégic. ");
INSERT INTO kgf_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Yawenéŋ nonac niŋ wamma haka kuneŋ yanda waŋec imuac nini ségiségi waŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","O Yawe, hésa ichécnina meleŋ nénécmina, kia hayu baec waŋgoŋa Saut iguc doku téfaranéŋ luma keŋanʒac ésécnec focdac hadacmu. ");
INSERT INTO kgf_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Iwawai gocmia siacma himicanʒu imi eneŋ ségiségi legicya héima imuac héla metocgé wammu. ");
INSERT INTO kgf_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Siacma gocmia eeyaguc qesamaŋ ʒé mema kenʒac imi kileŋ imuac héla déréc dérécgiaguc ségiségi wamma huama hamac. ");
INSERT INTO kgf_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","(Solomonac legic, ama tétéyaiguc eŋeŋawac legic.) Yawenéŋ ama ménda memaciguc imi ama meme ic ionac ai imi eŋomia wammac. Yawenéŋ ama areŋ yanda imuac demiŋa ménda galeŋ gémaciguc imi galeŋ meme ic ionac kicɋeli wamma kekec imi eŋomia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Siŋunec yanda yacma ai mema kecma gau nalé ogicma hema qenʒeŋ manʒeŋ qema héla mihicŋima neanʒu imi eŋomia wanʒac. Hénia imuac mia Yawenéŋ ala waŋ énécmimia ionac imi gaugina siŋaguc énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Ninʒu, naŋhécgina imi Yawenéŋ onac buŋa énécmimia. Héri qeriiguc hicŋima kecʒac imi bakia hiabia iwarunec hahaya. ");
INSERT INTO kgf_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Kucginaguc kecma merachécgina mihicŋi énécmigic merachécgina ieneŋ imi ic kawali ionac méraiguc tewi merawa ésécnec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Ic méŋ tewi ʒakoŋnéŋ hénéŋaiguc sécgéma hezac ésécnec naŋhéra kecʒu imi ʒézé ségi ségiyaguc. Imuac niŋac haʒéchéra iniguc ac gésigési ic ionac kemma ac wammu nalé imuaru gamuyaguc ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","(Ama téréyaiguc eŋeŋawac legic ʒéra.) Yawe eeya héimima iwac héna acwac wamma meanʒac inéŋ ségiségiyaguc. ");
INSERT INTO kgf_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Méraganéŋ ai mena imuac héla hicŋigéŋu newésémaŋ. Ai méŋac méŋ meanʒaŋ séc hiarudaru ségiségigaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Amaga qeriaiguc iniŋga imi waiŋ ic héla mériaŋaguc ésécnec waŋu, nambérac hécga ʒaega lelecgéma tacma kenʒu imi eneŋ olivaŋ ic séra qeqeya ésécnec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Ninʒu, Yaweac eeya héimianʒac imi hélacnec imuhuc mériaŋaguc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Yawenéŋ Zioniguc kecma mériaŋ haigémmac. Waŋu Yerusalemac mériaŋ imi kic ɋeli kecbésémaŋ nalé imuac suraiguc séc hémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Esahécga hicŋigic inicbésémaŋ. Israel héna géségaiguc luae hemac. ");
INSERT INTO kgf_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","(Ama téréyaiguc eŋeŋawac legic.) Israel imi deguc yomuhuc hia ʒémac; Ieneŋ komocna igucnec haisisiric eŋeŋa waŋ néŋaŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","Ieneŋ komocna igucnec haisisiric waŋ néŋaŋgic waŋu kileŋ ménda nogicgic. ");
INSERT INTO kgf_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Ieneŋ baec aiiguc takareŋ éséanʒu ésécnec gemacnaiguc wizi horua mihicŋi néŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Waŋu Yawe imi solaŋa kecʒac imuac niŋ kaiʒiliweŋ ic ieneŋ ɋaté nénécmigic heyec hésa imi héricma hulac nénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Zionac méʒé titi waŋanʒu imi gamu qeqe mihicŋi énécmiyu mocʒoŋ yanda andé andé kemma baecginaiguc liliŋgéma kendacmu. ");
INSERT INTO kgf_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Ieneŋ imi ama qahaiguc ɋézézac hicŋima ménda yandimanec ɋasianʒac ésécnec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","Qinʒiŋ imuhucya imi komocdiadac imuac niŋac dérécgéanʒac iwac tétéyaiguc me qericanʒac iwac mériaiguc hia ménda sécgémac. ");
INSERT INTO kgf_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Ic imuhucya ionac imi ic kiaŋ keŋha waŋanʒu imi eneŋ acguc inictegicma mériaŋ ac yomuhuc ménda énézéanʒu; “Yaweac mériaŋnéŋ onac muru hema kecmac!” “Yaweac qaraiguc mériaŋ ac waŋ énécmiziŋ!” ");
INSERT INTO kgf_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","(Ama téréyaiguc eŋeŋawac legic.) Yawe, ni yéwérinawac dumuc siraiguc gi guruzua. ");
INSERT INTO kgf_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Miŋ Kewu, ewa hétéŋna niŋna. Ʒéwelecna hélacnec imuac gezac haina. ");
INSERT INTO kgf_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Yawe, gi képésicnina héŋsosoli wambaŋnec mérénéŋ hia naŋseliwacnec? ");
INSERT INTO kgf_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Képésic waiwai imi guaru hezac, imuac mia nini eega héigéŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Ni, kekec uŋananéŋ Yaweac mambéc kecanʒua. Iwac ackuaʒéc niŋac niŋhéhélima kecanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Siŋi galeŋ eneŋ giaŋ giaŋawac mambécanʒu imuac séha ogicma kekec uŋananéŋ Miŋ Kewuac mambéc kecanʒac. Hélacnec siŋi galeŋnéŋ giaŋgiaŋawac mambéc kecanʒu imuac séha ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Israel ini Yaweac mambéc waŋgic. Iwaru imi gum bénʒénʒéŋ ʒéma boŋhéré hakanéŋ sécgéma hezac. ");
INSERT INTO kgf_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Inéŋ mia Israel hénagésé képésicgina mocʒoŋ yanda imuacnec metecgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","(Dawidiac legic ʒéra, ocmuŋ téréyaiguc eŋeŋawac legic.) Yawe, ni qeri eŋeŋ ménda kecanʒua. Waŋu iwawai méŋac méŋ sécna ogicma hezac imuac kic hihi ménda waŋanʒua. Ni ai qac buŋayaguc me ai tosara nuac séc ogicʒac imuac mia nimbupuc ménda waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Hélacnec ni qerina kuma mama mebélacgéwa kokoc namu nema sécgémiyu neŋgocyawac tawéiguc heanʒac imuac séc qerinanéŋ néŋ qema hezac. ");
INSERT INTO kgf_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Israel ini degucmuacnec hémbénaŋa Yaweac niŋkumu wammu. ");
INSERT INTO kgf_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","(Ocmuŋ téréyaiguc eŋeŋawac legic.) Yawe, Dawidiac niŋac wamma inéŋ yéwéri hénia hénia bisiqatéŋ waŋec imi niŋɋeliwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Inéŋ Yawe ʒépaŋgé mima Yakoboac wandac wandac miŋina ʒéseli mima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","Ni hélacnec amanaiguc ménda emmaŋ. Hehe duŋnaiguc ménda emma hemaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","Waŋu kicna galeŋgéwa gau niŋ ménda wammac, waŋu kicna amia ménda waiwa mamac. ");
INSERT INTO kgf_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","Imuhuc wammanec kecma ama geric méŋ Yawe guac buŋa mewa tecgémac. Yakoboac wandac wandac miŋina, ama méŋ guac buŋa mewa tecgéyuguc mia kicna waiwa gauya hemac. ");
INSERT INTO kgf_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Nini Efarata amaiguc tacma sisipac acgawac katapa imuac ʒégic niŋiŋ. Waŋu Yarim baec kisiaiguc mihicŋiyiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","Hagic iwac tacyac wawaŋawac amaya imuaru kerenni, keremma héna titiya imuac wésiaiguc sicgémini. ");
INSERT INTO kgf_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","O Miŋ Kewu gi yacma tacniniŋ amagaiguc hama embésémaŋ. Gi ʒéma sisipac acgawac katapa kuhaguc imi momacnec. ");
INSERT INTO kgf_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Waŋénécmina héfac oo ichécga ieneŋ haka solaŋanéŋ séwi usugina ésécnec héigic hiŋgacmac. Waŋu ichécga téréya ieneŋ ségiségi wamma qacmu. ");
INSERT INTO kgf_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Weleŋ qeqe icga Dawidiac niŋmiwésémaŋ. Guac haléc naecmimiaga imi ménda nesimina keŋu. ");
INSERT INTO kgf_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Yawenéŋ Dawidiac ac héla yomuhuc ʒépaŋgémiyec. Inéŋ imi ménda andé qema kemmac; Guac sac igucnec hicŋimu ionarunec méŋ tatacga edamuyaguc imuaru opocba tacmac. ");
INSERT INTO kgf_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Naŋhécga eneŋ ʒikiʒiki ac ʒéma héipuc acna ku énécmimaŋ imi tohoma wammuiguc imi naŋhécgina ieneŋ imuhucyanec tatacga edamuyaguc imuaru tetecgia qahac tacmu. ");
INSERT INTO kgf_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Yawenéŋ Zioniguc tacyac wammaŋ ʒé ama imi megésima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","Yomi mia nuac tac niniŋ wawaŋawac buŋa hémbénaŋa wanʒac. Ni imuac waŋi imuac mia yomuaru tacyac wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Ni imuac nene yaka kindindiŋa mesaima imuac ic embachéra maqeqeya gumu énécmiwa sécgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Waŋu hofac oo ichéra aŋgéŋ titina imi maleku ésécnec héiénécmimaŋ. Ocmuŋ imuac téré ichéra ieneŋ ségiségi wamma hémbénaŋa legic héima kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Neŋ ʒéwa ama imuaru Dawidiac niŋac wamma iliha méŋ éréma yandimac. Waŋu ni nenaoc halécnéŋ météré mimia iwac niŋ wamma kifa mézézéŋgéwa héŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Neŋ iwac haʒéchéra ionac imi gamu qeqenéŋ séwi usugina ésécnec héiénécmiwa hiŋgacmac, néŋ iwac imi ic kewuac opoc haimiwa asarimac. ");
INSERT INTO kgf_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","(Ocmuŋ téréyaiguc eŋeŋawac legic.) Ninʒu, dacmuna momac yanda aʒoroma ewa momac wamma kekera imuac hiabiaya ʒéma inicsoroc sorocya imi yei dimuhucya wanʒac! ");
INSERT INTO kgf_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Tanera imi mia haléc Aronac orucyaiguc qocgégic ewa ʒucya igucnec mama malekuya horua imi mézécgéma mama ʒécgériaiguc momacnec naecmiyec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Waŋu Herimon baec boŋawac tutulucnéŋ Zion baec boŋaya boŋayaiguc mama mebélac géanʒac ésécnec. Imuac hénia imi yomuhuc; Baec imuaru Yawenéŋ mériaŋ ac ʒéyec. Imi mia keckec hehe seliawac mériaŋ ac. ");
INSERT INTO kgf_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","(Ocmuŋ téréyaiguc eŋeŋawac legic.) Siŋiaiguc Yaweac amaiguc weleŋ qema naŋanʒu Yaweac weleŋqeqe ichéra ini mocʒoŋ Yawe mepésimu. ");
INSERT INTO kgf_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Méragina meyacgic ocmuŋ téréyaigucgeŋ kendaru Yawe mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Baec kurumeŋ ʒéyu hicŋiyec Yawe inéŋ mia Zion igucnec mériaŋ ac gézémac. ");
INSERT INTO kgf_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Haleluya, Yaweac qara mepésigic, Yaweac weleŋ qeqe ichéra ini i mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Yaweac ocmuŋ, Anutuninawac ocmuŋ imuac sombeŋiguc nanʒu ini ");
INSERT INTO kgf_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Yawe mepésigic. Yawe imi hiabia, waŋu qara imi niŋsoroc sorocya, imuac niŋac qara imi mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Yawenéŋ eŋeya niŋac wamma Yakobo, qara méŋ Israel i aŋgétiyu iwac buŋa waŋec. ");
INSERT INTO kgf_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Ni ninʒua, Yawe imi kuneŋ yanda, waŋu nemu momac yanda onogicʒac. ");
INSERT INTO kgf_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Yawe imi haka niŋu sécgéyu séc waŋanʒac. Kurumeŋiguc ʒéma baeciguc, waŋu konduŋiguc ʒéma ʒékéŋ hiŋgac hiŋgara horuaiguc. ");
INSERT INTO kgf_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Inéŋ ʒéyu baec ʒécgériaiguc hosusu yacanʒac. Waŋu kia mihicŋimaŋ ʒé pilitic mihicŋianʒac. Waŋu luhuc ézéyu hofiya igucnec éréma haanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Inéŋ mia Iʒipte baeciguc méréc merachécgina ic ʒéma yaŋhécgina momacnec unudarec. ");
INSERT INTO kgf_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Iʒipte baec, guaru mia Yawenéŋ haka sésécyaguc ʒéma haka welicwelicgia méliyu Farao ʒéma ichéra momac yanda ionac hayec. ");
INSERT INTO kgf_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Inéŋ baera baera sasala unuma ic kewu kucginaguc unuhumuyec. ");
INSERT INTO kgf_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Qacgina imi Amori ic ionac ic kewu Sihon ʒéma, Basan ic kewu Ok ʒéma, Kanaan baecac ic kewuya ic kewuya momac yanda. ");
INSERT INTO kgf_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Waŋu baecgina imi Israel ic embachéra ionac buŋa qema énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Yawe, guac qacga imi hémbénaŋa hema kecmac. Yawe, guac qacga imi hémbénaŋa niŋɋeli mimia wammac. ");
INSERT INTO kgf_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Yawenéŋ eŋeya ic embachéra ʒénaŋgé énécmimac. Waŋu weleŋ qeqe ichéra ewa biric niŋénécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Baera baera imuac nemu imi siliwa ʒéma goli, ic méranéŋ memeya. ");
INSERT INTO kgf_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Kua ginagucnéŋ ac ménda ʒéanʒu, kicginagucnéŋ kic hihigina qahac. ");
INSERT INTO kgf_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Gezac ginagucnéŋ ac ménda niŋanʒu. Waŋu kua ginaigucnéŋ wéséségina qahac. ");
INSERT INTO kgf_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Imuhucya meanʒu ini ʒéma imuaru héima naŋanʒu ini imi mocʒoŋ imuhucyanec wamma kecmu. ");
INSERT INTO kgf_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Israel héna gésé ini, Yawe mepésigic. Aronac héna gésé ini Yawe mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Lewi héna gésé ini Yawe mepésigic. Yawe eeya héimianʒu ini Yawe mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Yerusalemiguc tacyac waŋanʒac Yawe imi Zioniguc mepésimimia wammac. Haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Yawe imi hiabia, waŋu goi héihéiya imi hémbénaŋa heanʒac imuac niŋac i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac nemu momac yanda onogicma Anutu kecʒac i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac miŋ kewu momac yanda onogicma Miŋ Kewu kecanʒac i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac eŋeyaocnec kiwi welic welicgia kuneŋ yanda meanʒac i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac niŋtegic qiŋtegicyanéŋ kurumeŋa kurumeŋa ʒéyu hicŋidarec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac doku qahaiguc baec lémbécma haiyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac asac mararaŋ kuneŋ kuneŋ ʒéyu hicŋidarec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac kaiwenéŋ kaiwe séc galeŋ nammac niŋac ʒéyu hicŋiyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac maso ʒéma ménni sikilunéŋ siŋi galeŋ nammuac niŋ ʒéyu hicŋidarec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac Iʒipte baeciguc méréc merachécgina unuyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac Iʒipte ic ionac sucgina igucnec Israel héna gésé onagicma hayec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac méraya kuhagucnéŋ suluma naŋgé nénécmima nonagicma hayec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac konduŋ pésia qeriru néwéc néwéc naŋoc i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac Israel hénaoriŋ goigina héima konduŋ namuŋaiguc onagicma hayec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac Farao ʒéma téŋgiŋ ichéra konduŋ pésia imuaru hoturu énécmiyu melemma hiŋgacgic i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac ic embachéra onagicma baec kéra kérasia qericma keŋec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac ic kewu kuneŋ kuneŋ unuyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac ic kewu qac buŋaginaguc unuhumuyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac Amori ic ionac ic kewu Sihon qehumuyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac Basanac ic kewu Ogo qehumuyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac baecgina onagicma ic embachéra ionac buŋa qeénécmiyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac weleŋ qeqe ichéra Israel ionac wamma baec iwawai buŋa qeénécmiyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac maqeqeya kecni niŋnénécmiyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac haʒéchécnina ionac méragina igucnec metecgé nénécmiyec i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac séwiginaguc kecanʒu ionac nene yaka gumu énécmianʒac i ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Goi héihéiya imi hémbénaŋa heanʒac imuac niŋac kurumeŋac Anutu ewa hia ac ézégic. ");
INSERT INTO kgf_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Nini Babilon baecac doku téfara ʒécgériaiguc tacma Zion niŋɋelima siariŋ. ");
INSERT INTO kgf_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Imuaru suruŋ ic naŋu hawaiguc gita kulelenina koroni naŋec. ");
INSERT INTO kgf_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","Hénia imi yomuhuc; Hésa icac nénépésigic ieneŋ imuaru legic héiwiŋ niŋac nénézégic imuhuc waŋiŋ. Amanina kisikiyoŋ qenénécmigic imi eneŋ Zionac legic méŋ héigic nimma ségiségi wanni ʒégic imuhuc waŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Nini dimuhuciguc Yaweac legic imi baec méréraiguc kecma héiwiŋ? ");
INSERT INTO kgf_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Yerusalem ni guac eluŋ numaciguc imi méra héina imi gita qeqeac héniawac eluŋ qemac. ");
INSERT INTO kgf_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Guac eluŋ numaciguc, waŋu Yerusalemac nimba ségiségina tosara onogicma eŋeŋa ménda wammaciguc imi legic ménda héimaŋ niŋac ezelaŋnanéŋ owuruŋnaiguc mékétamac. ");
INSERT INTO kgf_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Yawe gi Yerusalem imi ʒérabéra mihicŋiyec nalé imuac niŋɋelima Edomac ɋelihéra ununa. Hénia imi ieneŋ imi yomuhuc ʒégic; Héndéŋ qéndéŋgic, ama wotuŋa momacnec hérédacma kisikiyoŋ qegic. ");
INSERT INTO kgf_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Kisikiyoŋac buŋa embac biria, Babilon baec gi, méŋnéŋ méŋ geŋ waŋ nénécminecac séc imuhucyanec waŋgémmac imi ségiségiyaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Méŋnéŋ méŋ kokochécga hociguc qéséŋ énécmimac imi ségi ségiyaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Ni qeri howiacnec ewa hia ac gézézua. Nemu ionac kicginaiguc gi mepésigénʒua. ");
INSERT INTO kgf_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Ni ocmuŋga téréyawac sicgégémba hazac. Waŋu goi héihéiga ʒéma hakaga héla imuac niŋ guac qacgawac ewa hia ac gézémaŋ. Imi mia gi qacga ʒéma ʒézé seli acga meyacna iwawai mocʒoŋ qehoturuma onogicma eŋec imuac mia imuhuc waŋgénʒua. ");
INSERT INTO kgf_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Ni guruyi nalé imuaru acna meleŋnec, waŋu kekec uŋanawac kuha meyandi nénnec. ");
INSERT INTO kgf_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Baecac ic kewu mocʒoŋ ieneŋ kuaga igucnec acga niŋgic imuac niŋac ieneŋ Miŋ Kewu gi ʒéhiaru gémmu. ");
INSERT INTO kgf_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Yaweac edamuya imi eŋeŋa yanda imuac ieneŋ Yaweac hakayawac mepésimimu. ");
INSERT INTO kgf_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Yawe imi eŋeŋa. néŋ mamaya hia inicgaleŋ waŋ énécmianʒac, waŋu tétéc qeqe ic imi acguc lakec kecma hia inictegicanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Ni ʒéra waiya qeriaiguc keŋha wamba gi kekecna héŋgaleŋ waŋanʒaŋ. Waŋu haʒéchécna ionac qeri gericgina igucnec méraga suluma méra héiganéŋ metecgé néŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Yawenéŋ nuac wamma eŋeya ewa siŋ hezac séc wandacmac. Yawe guac goi héihéiganéŋ hehe seli hema kecmac. Ai méraganéŋ memeya imi ménda waiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Yawe gi ésé hindihindi wannémma niŋtegic néŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Tacyacna nimma lakec kecma niniŋna niŋtegicanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Héna kekecna ʒéma hehena héŋgaleŋ wamma wawaŋ memena imi mocʒoŋ niŋtegicnecac niŋtegicanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Ac méŋ ezelaŋnaiguc ménda hicŋi tegirunec Yawe geŋ bec howiacnec niŋtegicanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Gi wésé andu lelecgé némma méraga nuac qacnaiguc hainéŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Niniŋ imuhucya imi eebipiya séc méŋ eŋeŋa waŋu nimmaŋ ʒéma nimbipizua. ");
INSERT INTO kgf_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Ni uŋaga waima dimia méŋ hia kemmaŋ? Kic ségéraga néŋgacmima dimuaru méŋ saŋgiwinec? ");
INSERT INTO kgf_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Kurumeŋiguc embinec imi imuaru gi kecʒaŋ. Humuc amaiguc hiŋgacma hehe tatacna lémbécbinec imi imuaru acguc gi kecʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Siŋunec imi asoŋ héiyu qeŋgaŋnaguc putitima kemma konduŋ tetecgiaiguc keremma tacbinec ");
INSERT INTO kgf_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","imuaru acguc méraganéŋ nuagicma méra héiganéŋ selianec népésiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Siŋi panamaŋnéŋ hoturunéŋu asac mararaŋ lelecgé némma hezac imi siŋidéŋgédaru ʒéwinec, ");
INSERT INTO kgf_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","guaru imi siŋi ʒéma kaiwe imi héniagira momacguc wanʒac imuac niŋac guac kicgaiguc imi siŋinéŋ iwawai méŋ ménda musaŋgémac. Waŋu siŋi imi kaiwe ésécnec asahaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Geŋ mia séwinawac qeriaiguc séwi taséna momac momac mihicŋidacnec. Neŋgocnawac héri qeriaiguc geŋgaoc mia séwina toro toroya mocʒoŋ areŋgéma mihicŋi nénnec. ");
INSERT INTO kgf_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Ni imi hiabianec welic welicgianec mihicŋi nénnec imuac niŋ ewa hia ac gézézua. Wawaŋ memega imi welic welicgiaguc imi qeri uŋana acguc héŋtegicanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Sasaŋgiaiguc menémma baec dumuc siraiguc welic welicgianec menénnec nalé imuaru nuac séwi busuac iwawai imi guac kicga igucnec ménda saŋgima heyec. ");
INSERT INTO kgf_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Séwinawac tanera ménda hicŋi tegirunec qérawa imi kicganéŋ bec hénnec naléna ménda ducŋiyunec bec séwinawac tasia hicŋima keŋec séc kiwigaiguc ona hedacʒac. ");
INSERT INTO kgf_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","O Anutu niniŋga imi nimba eebipiyaguc eŋeŋa wanʒac. Qétéya imi acguc yei eŋeŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Némacnanéŋ olombinec, qétégina imi sakasac ogicʒac. Ni gau igucnec yacmaŋ imuaru acguc giguc kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","O Anutu kaiʒiliweŋ ic unuwaŋnec, sac nene ieneŋ wainémma kembunec. ");
INSERT INTO kgf_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Ieneŋ guac ʒébiri qébiri waŋgéŋanʒu. Haʒéchécga ieneŋ kicgaiguc iwawai eŋomiawac séwi eŋeŋ waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O Miŋ Kewu guac méʒégina tianʒac imi onac ni acguc méʒéna tianʒac. Waŋu gi ʒébiri géŋanʒu ionac imi ewa loloŋ waŋ néŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Ieneŋ haʒéchécna wanʒu imuac ionac niniŋ biric hélacnec késa kecʒua. ");
INSERT INTO kgf_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O Anutu néŋsosolima batucgé némma qerinawac hénia niŋna. Batucgé némma niniŋna niŋtegicna. ");
INSERT INTO kgf_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Néŋgésina nuaru wawaŋ meme biria méŋ hezaciguc qindiŋi némma héna hémbénaŋawac buŋa imuaru nuagicna. ");
INSERT INTO kgf_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","(Legic galeŋawac; Dawidiac legic ʒéra.) Yawe ic biria ionarunec metecgé nénna. Kaiʒiliweŋ ic ionac murunec saiwa menénna. ");
INSERT INTO kgf_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","Ieneŋ qeriginanéŋ haka biria niŋareŋ mema nalé séc yaré mihicŋianʒu. ");
INSERT INTO kgf_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Ieneŋ mokoleŋ ésécnec ezelaŋgina qericgic ʒéraguc waŋanʒac. Waŋu ezelaŋgina bawaiguc imi qaté mokoleŋac kua doku ʒéraguc he énécmizac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","O Yawe galeŋgé nénna. Kaiʒiliweŋ ic méraginaiguc embi niŋac. Yaré qeqe ic ionarunec hetecgé nénna. Ieneŋ imi néfacgé némbiŋ ʒé wanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Séwi eŋeŋ ic ieneŋ mebiri némbiŋ ʒé bétac hainémma hésanéŋ ufic mema héna ewiaiguc haima baec séséŋna éségic hezac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Ni Yawe yomuhuc ʒéma gézézua; Gi Anutuna, O Yawe, guru héhélinawac gezac haina. ");
INSERT INTO kgf_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Nuac aŋgéŋ titi Miŋ Kewu Yawe, gi yaré naléiguc orucnawac saiwa menénnec. ");
INSERT INTO kgf_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Yawe kaiʒiliweŋ icac ewa siŋ imi ménda nimmina. Manambatucac niniŋ biria imi muŋguc ménda seligimac. Qahac waŋu séwi eŋeŋ wambu niŋac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Lelecgé néŋanʒu imi eneŋ orucgina meyacgic, ʒéna eŋaŋ ezelaŋginawac ʒéranéŋ liliŋgéma eŋaŋ hoturu énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Geric lokocnéŋ ionac mama hoturu énécmimac niŋ wanʒua. Gericiguc néfacgé énecmina baec séséŋ imuaru hiŋgacma muŋguc ménda érému. ");
INSERT INTO kgf_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Ʒébiri qébiri ic ieneŋ baeciguc ménda seligima nammu. Yaré qeqe ic imi birianéŋ méndacmima kemma inimac. ");
INSERT INTO kgf_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Ni ninʒua Yawenéŋ ʒérabéra mihicŋima kecʒu ionac acgina goiya héianʒac. Waŋu maqeqeya ieneŋ aciguc eŋgic ʒédiŋi énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Hélacnec ic solaŋa ieneŋ guac qacgawac ewa hia ac ʒému. Ic dindiŋa ieneŋ kicgaiguc tacyac wammu. ");
INSERT INTO kgf_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","(Dawidiac legic ʒéra.) Yawe ni guru héhélizua, focdac hanéŋna. Guruwa ewa hétéŋnawac gezac haina. ");
INSERT INTO kgf_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Ʒéwelecnawac niŋna hofac héméŋa hiabia ésécnec wammac. Mérana meyacba iminéŋ siŋiyawac mulu ai ésécnec wammac. ");
INSERT INTO kgf_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Yawe kuanawac galeŋ meme ai ic méŋ opocna naŋu. Kua tasénawac naguya galeŋgéma kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Imuhuc waŋ nénna qerinanéŋ haka biriawac ménda ɋasima mamac. Képésic meme ic iniguc momacnec haka biria ménda wammaŋ. Waŋu ionac nene halécyaguc imi ménda nemaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Waŋu ic solaŋanéŋ orucnaiguc numindiŋi néŋu nimba goi héihéiya ésécnec wammac. Waŋu qindiŋi néŋu nimba orucnawac météré haléc ésécnec waŋu orucnanéŋ imuac héŋacya ménda memac. Ionac haka biria imuac niŋac kileŋ ni ʒéwelec ai memaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Waŋu galeŋhécgina hocnéŋ unugic mama unuyu, ic embac ieneŋ ackuaʒécna imi siŋaguc wanʒac imi niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Waŋu ieneŋ ackuaʒéc yomi niŋɋelimu; Ai icnéŋ baec patoma hoc sira giligic hezac ésécnec sicnina imi kicsuaŋ kuayaiguc héndéŋ qéndéŋgiawac hezac. ");
INSERT INTO kgf_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Miŋ Kewu Yawe kicna hiwa guaru hayu néŋgacma guac hazua. Qeri uŋana imi katanec ménda waimina nammac. ");
INSERT INTO kgf_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Ni galeŋgé némma biria meme ic ieneŋ népésimaŋ ʒé bétac haigic imuacnec ʒéma ionac baec séséŋ igucnec metecgé néŋna. ");
INSERT INTO kgf_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Ic biria ieneŋ wai énécmina eŋaŋ bétacginaiguc momacnec hiŋgacgic inimac, néŋ ni imi técgéma ogicmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","(Dawidiac Masikil tanera legic. Baŋec méŋac qeriaiguc saŋgima ʒéwelec ac yomi ʒéyec.) Ni Yaweac qachéhélizua. Ni Yaweac qacma ʒéwelecmizua. ");
INSERT INTO kgf_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Ni ewa gorona wésiaiguc qocgéwa mazac. Waŋu nuac ʒéra waiya imi ʒéhicŋi mizua. ");
INSERT INTO kgf_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Qerinaiguc qeri uŋananéŋ kic gili gili waŋec séc, geŋ mia hénana bétacya qahac imi niŋdacma mihicŋi nénnec. Ni héna agaleŋ keriiguc ieneŋ saŋgima bétac hainéŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Nuac héinaiguc hima hénna, méŋnéŋ méŋ héniana ménda niŋnéŋu hocʒua. Haineʒic méŋ ménda hayu hocʒua. Méŋnéŋ méŋ qeri uŋana ménda galeŋgé néŋu hocʒua. ");
INSERT INTO kgf_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","O Yawe ni ʒésiac waŋgémma ʒézua. Miŋ Kewu geŋgaoc imi haineʒicna ʒéma kicɋeli kekec baec yomuaru gi imi nuac buŋa wanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Ʒésiacna niŋna, ni maqeqeya wamma kecanʒua, nunesi waŋnéŋanʒu ionac méra igucnec metecgé néŋna, ieneŋ kucgina eŋeŋa nuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Qeri uŋana imi hésa ama igucnec hulac néŋna, qacgawac ewa hia ac ʒémaŋ. Goi héihéi waŋ nénna, ic solaŋa ieneŋ lelecgé némma nammu. ");
INSERT INTO kgf_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","(Dawidiac legic.) Yawe gi ʒéwelecna niŋna. Guru héhélinawac gezac haina. Héniaga héla ʒéma héniaga solaŋawac séciguc acna niŋna. ");
INSERT INTO kgf_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Guac kicgaiguc imi baec ic méŋnéŋ méŋ képésic solaŋ ménda kecʒac. Imuac niŋac weleŋ qeqe icga niguc ac ai ménda mena. ");
INSERT INTO kgf_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Haʒécnanéŋ qeri uŋanawac ʒuŋ mezac. Kekecna qéʒiyu baeciguc maqezac. Siŋi tunumaŋ qeriaiguc noporu becaru humugic ionac séc wanʒua. ");
INSERT INTO kgf_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Imuac qerinaiguc qeri uŋananéŋ kic gili gili waŋ néŋu wésé bacna imi témaŋ ʒé wanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Ni nalé wahalawac nimba kenʒac. Ai menec imi qerinanéŋ nimma tacʒua. Waŋu iwawai méraganéŋ wamma menec imi nimma ");
INSERT INTO kgf_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","mérana guac murugeŋ suluzua. Baec irec irecgianéŋ doku niŋ humuanʒac imuac séc kekec uŋananéŋ guac wammiʒac. (Ohec) ");
INSERT INTO kgf_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Yawe gi acna foc niŋnénna. Qeri uŋana kuha mazac. Kic tanecga ménda musaŋgé nénna. Baec séséŋiguc hiŋgacanʒu ionac séc wambi niŋac. ");
INSERT INTO kgf_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Niŋkinʒéŋna imi guaru hezac imuac niŋ siŋunec goi héihéigawac ackuaʒéc nézéna nimba. Kekec uŋana guaru naŋgéwa érézac imuac mia héna kecmaŋ niŋ ninʒaŋ imi ku nénna. ");
INSERT INTO kgf_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Yawe haʒéchécna ionac méragina igucnec metecgé nénna, ni guac méraga bawaiguc saŋgizua. ");
INSERT INTO kgf_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Gi nuac Anutu kecʒaŋ, imuac niŋac ku nénna guac ewa siŋga méndacma wammaŋ. Uŋaga imi hiabia, imuac héna kondoŋaiguc nuagicma kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Yawe qacgawac wamma kekecna meɋeli néŋna. Solaŋ dindiŋagawac séciguc ʒéra waiya igucnec népésina éréwa. ");
INSERT INTO kgf_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Waŋu goi héihéiga nuac hezac imuac séciguc haʒéchécna qeric énécmina qahac waŋgic. Neŋ guac weleŋ qeqe icga kecʒua. Imuac niŋ qeri uŋana yéwéri mihicŋi mianʒu imi mocʒoŋ auénécmina qahac wandacmu. ");
INSERT INTO kgf_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","(Dawidiac legic.) Yawe haineʒicac ʒamanʒiŋna i ʒézé ségiségi wammimaŋ. Inéŋ mérana yaréac meefima mérana merawa yaré qeqeac hénia kumiyec. ");
INSERT INTO kgf_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Yawe imi goi héihéina, ʒamanʒiŋna ʒéma baŋecna, inéŋ neuŋ kiropo selina ʒéma metec metecna ʒéma saiwana, ni imi ic embac hécna méra bacnaiguc onopocanʒac iwaru mia héiselianʒua. ");
INSERT INTO kgf_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Yawe, gi ic imi némac hiaya niŋac eeya héianʒaŋ? Miŋ Kewu gi baec icac ninna némaria waŋu niŋmianʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Ic imi kua wésésé ésécnec hotoŋadac kecma qahac wammac, waŋu kekec naléyanéŋ amia timima keŋanʒac ésécnec focdac hama kemmac. ");
INSERT INTO kgf_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Miŋ Kewu gi kurumeŋ misicgéma tima mana. Baec boŋa séc onosina hofac téma yacmac. ");
INSERT INTO kgf_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Haʒéchécga pilitic giliénécmima héndéŋ énécmina. Ʒakoŋga muima héndéŋ énécmina keŋgic. ");
INSERT INTO kgf_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Ounec méraga suluma népésina éréwa. Doku ɋauŋ kuhaguc imuacnec ʒéma ic méréra ionac méragina igucnec metecgé nénna. ");
INSERT INTO kgf_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Ieneŋ kua taséginanéŋ ikoc ac ʒéma méra héiginanéŋ manam batuc ai meanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","O Anutu ni legic ɋelia héima gita hésia 10 imi qema legic héigénʒua. ");
INSERT INTO kgf_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Geŋ meseli énécmina ic kewuya ic kewuya yaréginaiguc onogicanʒu. Weleŋ qeqe icga Dawidi sou ʒéra igucnec metecgé néŋanʒaŋ guac mia legic héigénʒua. ");
INSERT INTO kgf_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Ic enia ionac méragina igucnec ni metecgé néŋna. Ieneŋ kua taséginanéŋ ikoc ac ʒéma méra héiginanéŋ manam batuc ai meanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Naŋ hécnina imi ic hésa komoranéŋ kecma séha séc yandianʒac ésécnec wammu. Waŋu bérac hécnina ieneŋ ic kewuac ama yanda meanʒu imuac hénia méndacma méra kiwi héimimia ama kewuac wotuŋa hocnéŋ memeya imuhucya ésécnec wammu. ");
INSERT INTO kgf_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Hofi amaninaiguc nene mériaŋ kuaya qeyu rama hécnina ieneŋ baec kisiaiguc saigic ʒaŋgégina imi tauseŋa tauseŋa ʒéma 10 tauseŋa 10 tauseŋa wammu. ");
INSERT INTO kgf_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Burumakao hécnina iwa ieneŋ haléginaguc réwéria wammu. Nununesi ménda hicŋiyu ama sombeŋnina iguc ʒésiac méŋ ménda hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Ic embac areŋ imuhucya imi ʒézé ségiségi ginaguc. Ic embac Yawenéŋ Anutu kecénécmimia imi ʒézé ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","(Dawidiac mepé qepési ac.) Ic kewu Anutuna, ni ʒézé ségiségi waŋgémma qacga nalé tetecgia qahac mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Ni kaiweya kaiweya ʒézé ségiségi waŋgémmaŋ. Waŋu qacga tetecgia qahac mepési gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Yawe imi kuneŋ yanda imuac kuneŋ yanda mepésimimia wammac. Kuneŋ yandayawac séha imi qétéya olombiŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Hicŋisaia hicŋisaia emma kemma guac wawaŋ memega imi mepésima haka silicga kuhaguc imi ʒéau énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Qac buŋaga eebipiyaguc ʒéma edamugaguc imi ʒéma guac haka welic welicgia imi qerinanéŋ ʒénimma kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Hakaga welic welicgia imuac kuha imi ʒéau énécmimia wammac. Ni acguc héniaga kuneŋ yanda imi ʒéau énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Ieneŋ guac sese kuneŋ yanda imuac buŋa ʒéma guac héniaga solaŋa imuac legic héimu. ");
INSERT INTO kgf_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Yawe imi ewa hiawac waŋ énécmima ewa biric waŋ énécmima qeri geric foc foc ménda wamma goi héihéi kuneŋ yanda waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Yawe imi kekec momac yanda hiabia waŋ énécmima ʒéyu hicŋima kecʒu séc goi héihéi waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Yawe geŋ ʒéna hicŋima kecʒu imi mocʒoŋ guac ewa hia ac ʒému. Guac muru météré amuma kekec ieneŋ gi mepésigémmu. ");
INSERT INTO kgf_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Ieneŋ guac héŋgaleŋ ama areŋa yanda imuac edamuya ʒéauma guac kucga ʒéeminiŋ wammu. ");
INSERT INTO kgf_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Guac ai kuhaguc imi ʒéma héŋgaleŋ ama areŋa yandagawac qac buŋayawac edamuya imi ic onac ɋelihécgina énézégic nimmu. ");
INSERT INTO kgf_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Guac héŋgaleŋ ama areŋa yanda imi héŋgaleŋ ama areŋa yanda hémbénaŋa. Waŋu héŋgaleŋ aiga imi hicŋisai lépaya lépaya hema emma kecmac. Miŋ kewu imi ʒéyu hicŋima kecʒu imi mocʒoŋ goigina héima méŋʒé méŋʒéya qahac ʒikiʒiki acya mocʒoŋ méndacanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Yawe imi tendiŋgéwiŋ ʒé waŋanʒu ionac naŋgé énécmianʒac. Waŋu mema titi waŋ énécmimia imi meyac énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Kekec momac yandanéŋ guaru kic hianʒu. Geŋ nalé ʒézéya méndacma nene yaka gumu énécmianʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Waŋu méraga suluma iwawai kekecginaguc imi mocʒoŋ galeŋgé énécmina sécgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Yawe imi wawaŋ memeya mocʒoŋ solaŋ dindiŋa waŋanʒac. Haka silicya mocʒoŋ ewa hiawac waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Yawe imi ʒéwelec wammima hélacnec ʒéwelecanʒu séc hosucgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Inéŋ mia eeya héimianʒu séc ewa siŋginawac sécgé énécmianʒac. Waŋu ionac qac héhéligina imi nimma aŋgéŋgina tianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Yawe imi goi héihéi wammianʒu séc héŋgaleŋ waŋ énécmianʒac, néŋ kaiʒiliweŋ ic imi mocʒoŋ mebiri énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Kuananéŋ Yaweac qac buŋaya ʒéaumaŋ. Waŋu séwiginaguc momac yanda ieneŋ qara téréya imi tetecgia qahac mepésimu. ");
INSERT INTO kgf_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Haleluya, kekec uŋana Yawe mepésina. ");
INSERT INTO kgf_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Ni kecma emma kecmaŋ séc Yawe mepésimaŋ. Kecma emma kecmaŋ séc Anutuna legic héimimaŋ. ");
INSERT INTO kgf_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Ini ic eŋeŋa ionaru ménda laheŋgému. Baec ic ieneŋ méra énécmimuac kuc ménda he énécmizac. ");
INSERT INTO kgf_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Ieneŋ imi uŋagina wai énécmiyu baeciguc liliŋgéma kemmu. Keŋgic kaiwe imuaru mia ionac niŋareŋ areŋgia imi mocʒoŋ qahac wandacmac. ");
INSERT INTO kgf_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Yakoboac Anutunéŋ méra mimac imi ségi ségiyaguc. Waŋu Yawe Anutuyawac niŋkumuma kecanʒac imi ʒézé ségi ségiyaguc. ");
INSERT INTO kgf_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Yawe imi baec kurumeŋ ʒéma iwawai imuaru sécgéma hezac imi mocʒoŋ ʒéyu hicŋidacgic. Waŋu hémbénaŋa qeri héla késa kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Inéŋ hédacgé énécmimiawac kecanʒu imi héna acac séc ʒédiŋi énécmima yaka niŋ humuanʒu séc nene yaka gumu énécmianʒac. Waŋu Yawenéŋ ɋaté énécmimia imi hulac énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Yawenéŋ kic hilic onac kic hihi meénécmianʒac. Yawe imi mema titi waŋ énécmimia imi meyac énécmianʒac. Waŋu Yawe imi ic solaŋa goi héihéi waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Yawe imi ic kiaŋa héŋgaleŋ waŋ énécmianʒac. Waŋu qawéc gupaŋ énépésima naŋgé énécmianʒac. Waŋu kaiʒiliweŋ ic ionac hénagina imi mebiri énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Zion ama areŋa yanda, Yawe guac Anutunéŋ hicŋisai lépaya lépaya hémbénaŋa héŋgaleŋ waŋgémmac. Haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Anutunina legic héimimia imi hiabia. Waŋu imi niŋsorocya ʒéma niŋu sécgémac. Imuac niŋac Yawe mepésini, haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Yawenéŋ Yerusalem meyacgéanʒac. Inéŋ mia Israel héndéŋ qéndéŋ waŋ énécmigic kecʒu imi qutulaŋgé énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Inéŋ ewa biric wamma kecʒu séc mehiaru énécmima wizigina oso énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Inéŋ ménni sikilu qétégina oloŋ énécmima qacgina qacénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Miŋ Kewunina imi kuneŋ yanda, kuc yandayaguc. Waŋu niŋtegic qiŋtegicya séha imi olombiŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Yawenéŋ memaamuma kecanʒu imi énépésima naŋgé énécmianʒac. Waŋu kaiʒiliweŋ ic imi giliyu baeciguc maunudacmac. ");
INSERT INTO kgf_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Saiwop ʒémima Yawe legic héimimu. Gita kulele qema Anutu legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Inéŋ hosusu haima kurumeŋ osoanʒac. Waŋu baecac wamma kia imi hofiaiguc haiyu heanʒac. Waŋu kia haiyu baec boŋaiguc ɋézézac éréma yandianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Inéŋ haséŋ yaŋ ʒéma koeckoec nei merawanéŋ qacma kecgic nenegina mihicŋi énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Yawe imi becosicac kuhawac niŋkumuma kenʒu ionac siŋgina ménda niŋanʒac. Waŋu ic méŋ eŋeya héna kuhawac niŋkumuma keŋanʒac imuac ménda héŋsorocanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Inéŋ eeya héimima goi héihéiyawac kic hihi waŋanʒu ionac mia ewa hia niŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Yerusalem gi Yawe legic héimina. Zion gi Anutuga legic héimina. ");
INSERT INTO kgf_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Inéŋ amagawac nagu wétéya imi meseligianʒac. Waŋu ama imuac qerigaiguc merachécga mériaŋ mihicŋi énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Inéŋ baecgawac suc séré yanda imuac qeriaiguc luae qegéŋu heanʒac. Waŋu nene héla gocmia hiabianéŋ gumu géŋu sécgéanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Inéŋ ʒézé seli acya baeciguc méliyu ackuaʒéc iminéŋ foc foc keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Inéŋ komboc rama ʒucya imuhucya ésécnec giliyu maanʒac. Waŋu komboc bororoŋa baeciguc hicŋi hicŋiya imi qesayu bucgazeŋ ésécnec heanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Inéŋ saméŋ bororoŋa ésécnec komboc giliyu maanʒac. Mérénéŋ saŋgeŋa imi ogicma hia ménda tétéŋgarimac? ");
INSERT INTO kgf_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Waŋu inéŋ ʒéyu komboc imuhucya imi pépélima doku waŋanʒac. Inéŋ luhuc ézéyu qeanʒac. Waŋu doku ézéyu keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Inéŋ ackuaʒécya Yakobo ʒéhicŋi miyec. Waŋu héna acya ʒéma pakeŋ acya imi Israelac ʒéhicŋi miyec. ");
INSERT INTO kgf_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Baec méŋac ic areŋ tosia ionaru imi imuhuc méŋ ménda waŋ énécmiyec. Imuac ieneŋ Anutuac héna ac imi ménda ninʒu. Haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Haleluya, kurumeŋiguc kecʒu ini Yawe mepésigic. Yawe mepésigic, ou eŋeŋaiguc kecʒu ini i mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Kua meme uŋahéra ini mocʒoŋ i mepésigic. Kawali areŋhéra ini i mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Maso kaiwe iri i mepésiyic. Sikilu asarianʒu ini mocʒoŋ i mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Kurumeŋac kurumeŋ ini acguc i mepésigic. Sawaiguc doku hedacʒac ini acguc i mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Momac yanda inéŋ ʒéyu hicŋima hezu imi wai énécmigic Yaweac qara mepésimu. ");
INSERT INTO kgf_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Inéŋ méŋnéŋ méŋ ménda logimac niŋ qaŋaŋ silic hai énécmima imuhucya imuhucya hémbénaŋa kumu énécmiyu nanʒu. ");
INSERT INTO kgf_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Baec igucnec Yawe mepésigic, konduŋac mokoleŋ yanda ʒéma konduŋ ʒékéŋa ʒékéŋa ini momacnec. ");
INSERT INTO kgf_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Geric ʒéma komboc ʒéma komboc boboroŋa ʒéma hosusu dépaŋ ʒéma luhuc kuaya tohoanʒu ini acguc imuhucyanec. ");
INSERT INTO kgf_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Baec boŋa ʒéma baec qindiŋ qindiŋa mocʒoŋ, ic gocmiaguc ʒéma yéménʒéc ic mocʒoŋ imuhucyanec, ");
INSERT INTO kgf_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","haséŋ yaŋ mocʒoŋ yanda ʒéma ama yaŋ mocʒoŋ ʒéma gisic ʒéma nei qeŋgaŋginaguc mocʒoŋ imuhucyanec. ");
INSERT INTO kgf_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Baera baera ic kewu mocʒoŋ ʒéma ic embac areŋa areŋa mocʒoŋ ʒéma ic eŋeŋa ʒéma baecac ʒétegictegic ic mocʒoŋ imuhucyanec, ");
INSERT INTO kgf_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","ic ɋapé, embac seraŋa, ic embac yanda ʒéma nambérac mocʒoŋ imuhucyanec. ");
INSERT INTO kgf_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Iwac qara momacgucnec sac eŋeŋa yanda wanʒac. Waŋu edamuya imi baec kurumeŋiguc kecʒu imi mocʒoŋ onogicma eŋeŋa wanʒac, imuac niŋac momac yanda ini Yaweac qara mepésimu. ");
INSERT INTO kgf_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Inéŋ mia héna géséhéra ilicgina meyac énécmiyec imuac niŋac i imi qéhéréŋgé mima kecanʒu météré énécmimia Israel ic ionac mepé qepésiac buŋa wanʒac. Haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Haleluya, legic ɋelianéŋ Yawe mepésigic. Météré ichéra ionac aʒoaʒoroiguc legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Israel imi eŋeya mihicŋi miyec iwac niŋac wamma ségiségi wammac. Zionac naŋhéra ieneŋ eŋaŋ ic kewu niŋac wamma ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Legic hirima qara mepésigic. Waŋgoŋ ʒéma gita qema legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Yawenéŋ eŋeya ic embachéra niŋac ségiségi waŋanʒac. Waŋu ic embac memaamuma kecanʒu séc aŋgéŋgina tima kiwi méréra héŋsoroc sorocya meénécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Météré énécmimia ieneŋ imi edamuya qeriaiguc ségiségi wamma eŋaŋ hehe tataciguc legic héimimu. ");
INSERT INTO kgf_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Kuaginaiguc imi Anutuac mepé qepési acnéŋ hemac. Waŋu méraginaiguc sou bawa andia ʒéraguc imi he énécmimac. ");
INSERT INTO kgf_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Waŋu iminéŋ mia baera baera ic bakia meleŋ énécmima ic embac areŋa areŋa tasé ku énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Waŋu ic kewuhécgina imi seŋ hésanéŋ, ic eŋeŋa hécgina imi aiŋ bétacnéŋ hénagina helanʒi énécmimu. ");
INSERT INTO kgf_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Ʒétegic tegic ac ooyawac hezac imuac séciguc imuhuc waŋ énécmimu. Ai eeyaguc imuhucya imi météré énécmimia ionac méraginaiguc hai énécmiyu hezac. Haleluya! ");
INSERT INTO kgf_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Haleluya, ocmuŋaiguc Anutu legic héimigic. Kuha héima hezac kurumeŋ imuaru legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Wawaŋ memeya kuhaguc imuac niŋac legic héimigic. Héniaya, kuneŋ yanda edamuyaguc imuac niŋac wamma legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Tomuŋ qema legic héimigic. Kulele ʒéma gita qema legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Tambariŋ qema legic hirima mepésigic. Kuŋa ʒéma gitanéŋ legic héimigic. ");
INSERT INTO kgf_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Aiŋ hilaŋa qara kuneŋ yanda imuhucya qema mepésigic. Aiŋ hilaŋa hétéŋ ou eŋeŋawac qema mepésigic. ");
INSERT INTO kgf_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Kua wésésé héima kecanʒu séc Yawe legic héimigic. Haleluya! ");
INSERT INTO kgf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abaraham ʒéma Dawidiac ɋeli, Kristo Yesuac sac kitichéra. ");
INSERT INTO kgf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarahamnéŋ Isaka mihicŋiyec. Isakanéŋ Yakop mihicŋiyec. Yakobonéŋ Yuda ʒéma iwac dac munahéra mihicŋi énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudanéŋ Tamari iwarunec Feresi ʒéma Ʒara mihicŋi érécmiyec. Feresinéŋ Hesiron mihicŋiyec. Hesironnéŋ Aram mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramnéŋ Aminadap mihicŋiyec. Aminadapnéŋ Nason mihicŋiyec. Nasonnéŋ Salmon mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonnéŋ Rahap iwarunec Boasi mihicŋiyec. Boasinéŋ Rut iwarunec Yobedi mihicŋiyec. Yobedinéŋ Yesi mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesinéŋ ic kewu Dawidi mihicŋiyec. Waŋu Dawidinéŋ Uriawac iniŋa iwarunec Solomon mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonnéŋ Rehoboam mihicŋiyec. Rehoboamnéŋ Abia mihicŋiyec. Abiyanéŋ Asafe mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafenéŋ Yosafat mihicŋiyec. Yosafatnéŋ Yoram mihicŋiyec. Yoramnéŋ Uʒia mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uʒianéŋ Yotam mihicŋiyec. Yotamnéŋ Ahaʒi mihicŋiyec. Ahaʒinéŋ Heʒekia mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Heʒekianéŋ Manase mihicŋiyec. Manasenéŋ Amosi mihicŋiyec. Amosinéŋ Yosia mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Waŋu Babilon baeciguc onagicma keŋkeŋa nalé imuaru Yosianéŋ Yekonia ʒéma dac munahéra mihicŋi énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Waŋu Babilon baeciguc onagicma keŋgicguc Yekonianéŋ Salatiel mihicŋiyec. Salatielnéŋ Ʒorobabel mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ʒorobabelnéŋ Abiut mihicŋiyec. Abiutnéŋ Eliakim mihicŋiyec. Eliakimnéŋ Aʒori mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aʒorinéŋ Sadok mihicŋiyec. Sadoknéŋ Akim mihicŋiyec. Akimnéŋ Eliut mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutnéŋ Eleaʒari mihicŋiyec. Eleaʒarinéŋ Matan mihicŋiyec. Matannéŋ Yakop mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakopnéŋ Mariawac euya Yosefe mihicŋiyec. Waŋu Maria iwarunec mia Yesu Kristo ʒémimia imi hicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Imuac Abaraham igucnec éréma Dawidiguc hayu hicŋisaiac qétégina imi 14 wanʒac. Waŋu Dawidi igucnec éréma Babiloniguc onagicma keŋkeŋawac naléiguc hayu hicŋisaiac qétégina imi 14 wanʒac. Waŋu Babiloniguc onagicma keŋkeŋawac nalé imuarunec éréma Kristoac naléiguc hayu hicŋisaiac qétégina imi 14 wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Waŋu Kristo Yesuac hicŋihicŋiya imi yomuhuc; Iwac neŋgocya Maria imi Yosefeac buŋa wammac niŋ ʒéérécmimia waŋec, néŋ ekawu momacnec ménda kericnec Uŋa Téréyanéŋ kiwi meyu hériyaguc waŋu héŋec. ");
INSERT INTO kgf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Waŋu iwac eu buŋa Yosefe imi ic dindiŋa kerec. Imuac niŋ, ara ʒéauyu kicginaiguc gamuyaguc wambac niŋac, éléŋnec waimiyu kemmac ʒé nimma niŋareŋgéyec. ");
INSERT INTO kgf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Imuhuc nimma keru Miŋ Kewuac kua meme uŋa méŋnéŋ gauiguc hicŋimima yomuhuc ézéyec; Dawidiac ɋeli Yosefe, iniŋ buŋaga Maria wagicmaŋ ʒé ʒénéŋga ménda hiriyu, tomeŋaiguc tacʒac imi Uŋa Téréyawac murunec. ");
INSERT INTO kgf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Inéŋ naŋawac mihicŋimac. Mihicŋiyu inéŋ kecma eŋeya ic embachéra képésicgina igucnec aŋgéŋgina timac, imuac niŋac qara Yesu ʒéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Haka hicŋiyec imi Miŋ Kewuninanéŋ kua meme icya kuaya mema ac yomuhuc ʒéyec imi mocʒoŋ meselimaŋ ʒé imuhuc hicŋiyec; ");
INSERT INTO kgf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ninʒu, embac seraŋanéŋ héri haima naŋa meyu iwac qara Immanuel ʒému (Hénia imi Anutunéŋ neŋaŋguc kecʒac). ");
INSERT INTO kgf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Imuhuc ʒéyu Yosefenéŋ gau igucnec yacma Miŋ Kewuac kua meme uŋanéŋ ʒéyec séc wamma iniŋ buŋaya wagicma hayec. ");
INSERT INTO kgf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Waŋu inéŋ i guc momacnec heyac ménda wamma kerunec embac imi méréc merac naŋa mihicŋiyec. Mihicŋiyu Yosefenéŋ qara Yesu ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ic kewu Herodeac héŋgaleŋ naléiguc Yesunéŋ Yuda baec Betelehem ama areŋa yandaiguc hicŋiyec. Gezac qema niŋgic, hicŋiyu Is igucnec niniŋ ic tosara Yerusalem hama yomuhuc ʒégic; ");
INSERT INTO kgf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Merac Yuda ic onac ic kewu buŋa hicŋiyec imi dimia? Nini Is iguc iwac widi méŋ hémma mepésimiwiŋ ʒé haziŋ. ");
INSERT INTO kgf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Imuhuc ʒégic ic kewu Herodenéŋ ac imi niŋu ewayaiguc niŋkéndéŋaguc waŋec. Imi mia inéŋnec qahac, Yerusalem miŋina i guc kecgic ieneŋ mocʒoŋ imuhuc waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Waŋu inéŋ hofac oo ic kiwahécgina ʒéma hénaoriŋ ionac héna acac kiwi ic unuruma Kristo dimuaru hicŋima kecʒac imuac qesiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Qesiénécmiyu yomuhuc ézégic; Yuda baec Betelehemiguc. Imi mia Anutuac tiliŋ tiliŋ ic méŋnéŋ yomuhuc oyecac hezac hénia yomuhuc niŋac imuhuc ʒégic; ");
INSERT INTO kgf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Betelehem ama areŋa, guac murunec galeŋ méŋnéŋ hama nuac hénaoriŋ Israel imi rama galeŋ ésécnec galeŋgé énécmimac. Imuac niŋ gi imi Yuda baeciguc ama areŋa yanda kuneŋ kuneŋ hema kenʒac imuac sucginaiguc komodia ménda wanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Imuhuc ʒégic nimma Herodenéŋ niniŋ ic éléŋnec unuruyu hagic eŋacnec tacma widi hicŋiyec imuac naléya dindiŋanec qesiénécmima niŋec. ");
INSERT INTO kgf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Qesiniŋu tecgéyu Betelehem ama areŋa yandaiguc méli énécmima yomuhuc énézéyec; Kemma merac imuac dindiŋanec qesinimmu. Waŋu mihicŋimuiguc liliŋgéma hama nézégic, ni acguc kemma mepési mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ic kewunéŋ imuhuc ʒéyu niŋgic tecgéyu, hénagina méŋgucnec toroqema keŋgic. Waŋu gezac qema niŋgic, widi Is imuaru héŋgic iminéŋ muŋguc hicŋi énécmima walac walac kemma mocʒoŋ merac heyec ama imuaru kemma héiselima tarec. ");
INSERT INTO kgf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Waŋu ieneŋ widi imi muŋguc hémma ségiségi kuneŋ yanda waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Waŋu ama imuaru haréma merac imi neŋgocya Mariaguc momacnec iricma simiŋ héima mepési migic. Imuhuc wamma géségina auma sese mema hagic goli, libanosi ic tutuha héméŋaguc ʒéma sacmasi haléc héméŋaguc imi sécgina séc haimigic. ");
INSERT INTO kgf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Waŋu gauiguc Herodeac muru ménda kemmu niŋ énézéyec. Énézéyu nimma héna méŋ igucnec ama baecginaiguc liliŋgéma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Liliŋgéma keŋgic, ninʒu, Anutuac kua meme uŋanéŋ gauiguc Yosefe hicŋimima yomuhuc ézéyec; Herodenéŋ merac yomi qemaŋ ʒé hochoc ai mezac, imuac gi yacma merac ʒéma neŋgocya oragicma Iʒipte baeciguc néŋgacma kemma kecna muŋguc gézémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Imuhuc ʒéyu Yosefenéŋ siŋiyaiguc yacma merac ʒéma neŋgocya oragicma Iʒipte baeciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Kemma imuaru kerunec Herode humuyec. Imi mia Miŋ Kewuninanéŋ eŋeya kua meme ic méŋac kuaya mema ʒéma yomuhuc ʒéyec ac yominéŋ héla héimac niŋ imuhuc hicŋiyec; Iʒipte baec igucnec naŋna qac hérémizua. ");
INSERT INTO kgf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Waŋu Herode imi niniŋ ic ieneŋ ikoc wammigic imi niŋtegicma qeri biric kuneŋ yanda waŋec. Waŋu yaré ic méli énécmiyu kemma Betelehem ama areŋa yanda ʒéma ama areŋ yanda yanda hosuraiguc tacma keŋec imuac qeriaiguc merac kecgic imi niniŋ ic qesiénécmima naléya niŋec imi méndacma yawuŋgina éréhéc ʒéma bawaiguc mocʒoŋ unugic humudacgic. ");
INSERT INTO kgf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Imuhuc waŋgic kua meme ic Yeremianéŋ yomuhuc ʒéyec ac imi héla héiyec; ");
INSERT INTO kgf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ewa hétéŋ méŋ Rama ama areŋa yandaiguc hicŋiyu niŋgic. Ewa biric yanda ʒéma ʒésiac yandanéŋ hicŋiyu niŋgic. Rahelnéŋ merachéra ionac niŋ siacʒac. Merachéra qahac wandacʒu imuac niŋ mebélac gémuac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Waŋu Herode humuyu, ninʒu, Miŋ Kewuac kua meme uŋa méŋnéŋ Iʒipte baeciguc Yosefe gauiguc hicŋimima yomuhuc ézéyec; ");
INSERT INTO kgf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Meracac kekecya qewiŋ ʒé hocgic ieneŋ humudacʒu, imuac gi yacma merac imi ʒéma neŋgocya oragicma Israel baeciguc liliŋgéma kenna. ");
INSERT INTO kgf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Imuhuc ʒéyu Yosefenéŋ yacma merac neŋgocyaguc oragicma Israel baeciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Néŋ Akelaonéŋ maŋgocya Herodeac tatac késama Yuda baec galeŋgézac imuhuc ʒégic nimma imuaru kemmaŋ ʒé ʒénéŋa hiriyec. Waŋu gauiguc kua meme uŋanéŋ ézéyu nimma Galilaia baeciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kemma tauŋ méŋ Naʒarete ʒéanʒu imuaru kerec. Haka imi mia kua meme ichéra kuagina mema ac yomuhuc ʒéyec imi hélaguc wammac niŋ imuhuc hicŋiyec; Naʒarete ic ʒémimu. ");
INSERT INTO kgf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nalé imuaru doku naec haka ic Yohanenéŋ hama Yuda baec kisiaiguc yomuhuc ʒéauyec; ");
INSERT INTO kgf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kurumeŋac héŋgaleŋ ama areŋa yandanéŋ hosucninu hazac, imuac niŋ ewa qerigina meleŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Waŋu ic iwac mia kua meme ic Yesaiawac kuaya mema yomuhuc ʒéyec; Ic méŋ baec kisiaiguc qacʒac, iwac ewa imi yomuhuc; Miŋninawac hénaya ʒéréŋ qéréŋ wamma megic, iwac hénaya héimindiŋigic dindiŋa waŋu. ");
INSERT INTO kgf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohane i imi maleku kamele ʒuanéŋ memeya imi héima rikuŋa yaŋ séwélanéŋ memeya imi kembaŋaiguc ʒikima kerec. Waŋu iwac neneya imi gaoc ʒéma haséŋ morombazecac dokuya. ");
INSERT INTO kgf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Waŋu imuhuc ʒéauyu Yerusalem ʒéma Yuda baec séc ʒéma Yodan doku néwéc néwéc ic embac mocʒoŋ iwac muru kendacgic. ");
INSERT INTO kgf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kemma képésicgina ʒéaugic Yodan Dokuiguc doku naec énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Waŋu doku naec énécmiyec imuaru Farisaio ic ʒéma Sadukaio ic sasala hagic inicma yomuhuc énézéyec; Qaté mokoleŋac ɋelihéra qeri geric hahaya imuacnec néŋgacmu niŋac mérénéŋ goro ac énézéyec? ");
INSERT INTO kgf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ewa meleŋ meleŋac séciguc héla mihicŋigic. ");
INSERT INTO kgf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Waŋu eŋaŋ qeriginanéŋ Abaraham imi neŋaŋ yandanina imuhuc ménda ʒéma nimmu. Ni énézéwa niŋgic, Anutunéŋ hoc yomi hia énézéyu yacma Abarahamac ɋelihéra wandacmu. ");
INSERT INTO kgf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ic hésa sasala imuac héniaiguc naka bec haiyu hedacʒac. Héla hiabia ménda haianʒac séc héiyu mayu gericiguc giliyu hiŋgacdacmac. ");
INSERT INTO kgf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ni imi qerigina melemmu niŋac dokunéŋ naec énécmianʒua, néŋ nuac andénaiguc hakecʒac inéŋ kuc yandayaguc ni nogicʒac. Nidac imuhucyanéŋ héna usuya metecgéma késamaŋac séc qahac. Inéŋ Uŋa Téréya ʒéma geric bélaŋanéŋ naec énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iwac méraiguc sarac yanda iminéŋ héla gocmia imi tocgéma hofiiguc haimac, néŋ gorosoŋa imi héiusuŋ wamma geric bélaŋ tectecgia qahac imuaru giliyu ʒemac. ");
INSERT INTO kgf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Waŋu nalé imuaru Yesunéŋ Galilaia baec igucnec Yodan dokuiguc hama Yohanenéŋ doku naecmimac niŋ ézéyec. ");
INSERT INTO kgf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ézéyu Yohanenéŋ qetalimima yomuhuc ʒéyec; Geŋ ni doku naec némbésémaŋ niŋac wanʒua, néŋ geŋ nuac muru hazaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesunéŋ melemma ʒéyec; Deguc imi acna niŋnénna imuhuc wamma nekaŋ haka solaŋa mocʒoŋ meseliwic, imuhuc ʒéyu ara nimmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nimmima doku naecmiyu Yesu imi doku igucnec éréyec. Éréyu kurumeŋ aŋgéyu Anutuac Uŋa Téréya kembo nei ésécnec mama hama iwac orucyaiguc naŋu héŋec. ");
INSERT INTO kgf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Waŋu kurumeŋ igucnec ewa méŋ yomuhuc hicŋiyec; Yomi imi nuac Naŋna. Iwac siŋ kuneŋ yanda niŋanʒua. Iwac niŋ ewa qerinanéŋ ségiségi yanda waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Waŋu Yesu Biria miŋinawac ala batuciguc emmac niŋ Uŋa Téréyanéŋ wagiru baec kisiaiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kemma siŋi kaiwe 40 imuac séc nene ʒikima ʒéwelecma kecma andiaiguc yaka niŋ humuyec. ");
INSERT INTO kgf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ara batuc miŋinanéŋ Yesuac muru hama yomuhuc ʒéyec; Gi Anutuac Naŋa wanʒaŋiguc ʒéna hoc sasala yominéŋ melemma saméŋ wammac. ");
INSERT INTO kgf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Yomuhuc mia ooyawac hezac; Icnéŋ saméŋ sac qahac, néŋ ackuaʒéc Anutuac kuaya igucnec haanʒac imi mocʒoŋ nimma kekecyaguc kecmac. ");
INSERT INTO kgf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Imuhuc ʒéyu Biria miŋinanéŋ Yesu wagicma Yerusalem kiropoc téréyaiguc emma ama téréya imuac witiyaiguc oporu naŋec. ");
INSERT INTO kgf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Naŋu yomuhuc ézéyec; Inéŋ guac wamma kua meme uŋahéra énézéyu ieneŋ méraginanéŋ gi gépésima osogéŋgic hocnéŋ hénaga ménda néʒéŋgémac. Imuhuc ooyawac hezac, imuac mia gi Anutuac Naŋa wanʒaŋiguc yomuacnec luma emu hiŋgacna. ");
INSERT INTO kgf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ʒéyu Yesunéŋ muŋguc yomuhuc ézéyec; Yomuhuc ogic hezac; Néŋ Miŋ Anutuga ménda batucgé miwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Imuhuc ʒéyu Biria miŋinanéŋ wagicma baec boŋa eŋeŋa yandaiguc emma héŋgaleŋ ama areŋa yanda sasala baec séc hema keŋkeŋa imi ʒéma imuac edamuya ézéyu héndarec. ");
INSERT INTO kgf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Héŋu yomuhuc ézéyec; Gi simiŋ héima mepési némbésémaŋiguc iwawai imi mocʒoŋ guac géndacmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Biria miŋina, gi néŋgacna! Yomuhuc mia ogic hezac; Miŋ Anutuga simiŋga héimima mepési miwésémaŋ, waŋu iwacnec sac weleŋ qemiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Imuhuc ʒéyu Biria miŋinanéŋ Yesu waimima keŋec. Keŋu kua meme uŋa eneŋ haréma Yesu weleŋ qemigic. ");
INSERT INTO kgf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Waŋu Yesunéŋ Yohane hésa amaiguc opocgic imuac buŋa suruc nimma Galilaia baeciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Waŋu Naʒarete ama waima Kafanaum amaiguc kemma kerec. Ama imi Ʒabulon ʒéma Naftali baec suciguc ʒékéŋ yanda hezac imuac giŋgiŋaiguc tacʒac. ");
INSERT INTO kgf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Imi mia Anutuac tiliŋtiliŋ ic Yesaiawac kuaya mema ac yomuhuc ʒéyec imuac héla héimac niŋac imuhuc hicŋiyec; ");
INSERT INTO kgf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ʒabulon baec, Naftali baec, Yodan doku néwécgeŋ konduŋ giŋgiŋawac héna ʒéma ic enia ionac baec Galilaia imuaru, ");
INSERT INTO kgf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ic embac tunumaŋiguc tacʒu eneŋ asac mararaŋ yanda hicŋiyu héŋgic. Waŋu humucac tunumaŋaiguc kecgic ionac muru asac mararaŋ qetagali énécmizac. ");
INSERT INTO kgf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Waŋu nalé imuaru mia Yesunéŋ aiya hénima yomuhuc ʒéauma énézéyec; Anutuac héŋgaleŋ ama areŋa yanda hosucginu hazac, imuac mia ewa qerigina meleŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Waŋu Yesunéŋ Galilaia konduŋ giŋgiŋaiguc keŋkecma héŋu Simon, Petero ʒémimia imi ʒéma iwac munaya Anderea iereŋ konduŋiguc uficgira gilimanec naŋoc. Waŋu iereŋ imi lambéc héréhéré ic keroc. ");
INSERT INTO kgf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Waŋu iricma yomuhuc érézéyec; Hama ni méndacnéŋic, neŋ ai méŋ érécmiwa iri ic embac héréhéré ic wammaoc. ");
INSERT INTO kgf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Imuhuc ʒéyu focnec uficgira waiyic taru Yesu méndaroc. ");
INSERT INTO kgf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Waŋu imuacnec keŋkecma héŋu dac muna éréhéc Ʒebedaioac naŋ héréra, Yokobo ʒéma iwac munia Yohane iereŋ maŋgocgira Ʒebedeguc eŋawu ʒéiciguc uficgina ɋotoma tacgic mihicŋi érécmima ururuyec. ");
INSERT INTO kgf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ururuyu focnec ʒéic ʒéma maŋgocgira imi waima Yesu méndacmiyoc. ");
INSERT INTO kgf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Waŋu Yesunéŋ Galilaia baec séc kereŋ haré wamma tocgotocgo amaginaiguc Anutuac héŋgaleŋ ama areŋa yandawac buŋa suruc hiabia imi ʒéauma ku énécmima ic embac sucginaiguc ic embac tosara hafi ʒepaginaguc hénia hénia imi mocʒoŋ mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Imuhuc waŋu iwac qac buŋaya imi Siria baec séc saima kendarec. Kendaru ic embac ieneŋ hafi ic hénia hénia; hafi ʒepaginaguc, uŋa biriaginaguc, humuc turucginaguc, ʒéma héna méragina séléc sélécgia imi onagicma hagic mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Waŋu Galilaia, Dekapoli, Yerusalem, Yuda, ʒéma Yodan doku néwéc igucnec ic embac tuŋa tuŋa hama méndacmigic. ");
INSERT INTO kgf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Waŋu Yesunéŋ ic embac tuŋa tuŋa imi inicma baec boŋaiguc emma tarec. Taru tohotoho ichéra ieneŋ iwac muru hagic. ");
INSERT INTO kgf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Waŋu kuaya auma ku énécmima ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Uŋa qerigina maqeqeya kecanʒu imi eneŋ ségiségi ginaguc, kurumeŋac héŋgaleŋ ama areŋa yanda imi ionac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ʒé siac wamma kecanʒu imi eneŋ ségiségi ginaguc, Anutunéŋ ewa hia qeénécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Gumbénʒénʒéŋ kecanʒu imi eneŋ ségiségi ginaguc, baec yanda baec imi mératéc énécmiyu késamu. ");
INSERT INTO kgf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Yaka ʒéma doku niŋ humuanʒu éséc haka solaŋawac waŋanʒu imi eneŋ ségiségi ginaguc, sécgé énécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Goi héihéi waŋ énécmianʒu imi eneŋ ségiségi ginaguc, Anutunéŋ goigina héimac. ");
INSERT INTO kgf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ewa qerigina ɋala ɋala imi eneŋ ségiségi ginaguc, ieneŋ Anutu hémmu. ");
INSERT INTO kgf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Luae qeqe ic imi eneŋ ségiségi ginaguc, Anutuac nambérac héra ʒéénécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Haka solaŋawac unuhéi waŋ énécmigic birizu imi eneŋ ségiségi ginaguc, kurumeŋac héŋgaleŋ ama areŋa yanda imi ionac buŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nuac niŋac ʒéma ʒébiri qébiri waŋ énécmima unuhéi waŋ énécmima ikoc wamma ac biria hénia hénia onac séwiginaiguc haimu imi ségiségi ginaguc, ");
INSERT INTO kgf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Anutuac kua meme ic walac hama kecgic imi imuhucyanec unuhéi waŋ énécmigic. Imuac niŋac ewa hia nimma ségiségi wammu. Imuac kitiwa kurumeŋiguc heheya imi kuneŋ yanda imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ini imi baec ic ionac sei kecʒu. Waŋu seinéŋ siŋa qahac wammaciguc némacyanéŋ iwawai méŋ hésiyu siŋaguc wammac? Qahacgucnec, iwawai omaya wamma iwawai méŋ ménda mehiarumac, néŋ momacguc waŋmimiawac séc imi giligic ic embac eneŋ tiʒiʒamu. ");
INSERT INTO kgf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Waŋu ini imi baec ic ionac asac mararaŋ, ama areŋa yanda méŋ baec boŋaiguc imi musaŋgémacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kifa imi acguc otorima kewuc guandiaiguc ménda haianʒu, qahac, imi mia tataraiguc haigic taru asahanéŋ ama qeriaiguc ic embac asari énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Imuac onac asac mararaŋ ginanéŋ imuhucyanec ic onac kicginaiguc measari énécmimac. Waŋu ieneŋ onac wawaŋ meme hiabia imi héŋgic hiaruyu Maŋgocgina kurumeŋiguc kecʒac imi mepési mimu. ");
INSERT INTO kgf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Niŋgic ni héna ac ʒéma kua meme ic ionac ac imi mesohomaŋ ʒé mazua tanec ménda wammac. Ni imi mesohomaŋ ʒé ménda mayi, néŋ meseligimaŋ niŋac mayi. ");
INSERT INTO kgf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ni hélacnec énézézua, héna ac igucnec ac kiwi siliha me bororoŋadac méŋ eŋ hema ménda qahac wammac, néŋ mocʒoŋ hélagucnec wandaruguc mia baec kurumeŋ imi hia qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Imuac ic méŋnéŋ méŋ héna ac imuarunec komocdiadac méŋ logima tosara imuhucnec wammu niŋ ku énécmimac imi, kurumeŋac héŋgaleŋ amaiguc ic mamaya ʒémimac. Waŋu méŋnéŋ méŋ wawaŋ memeyaiguc haima héna ac imi imuhuyanec tosara ku énécmimac imi, kurumeŋac héŋgaleŋ amaiguc ic eneŋa ʒémimac. ");
INSERT INTO kgf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Imuac énézéwa niŋgic, onac haka solaŋanéŋ héna acac kiwi ic ʒéma Farisaio ic ionac hakagina ménda ogicmac imi, kurumeŋac héŋgaleŋ amaiguc keremmuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yandahécgina yomuhuc énéc énézéya; Ic ménda qehumuwésémaŋ, waŋu méŋnéŋ ic qehumumac imi acac buŋa wammacac hezac, ac imi ini niŋgicac nindacʒu. ");
INSERT INTO kgf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Néŋ neŋ yomuhuc énézézua; Méŋnéŋ méŋ hénia qahac alaya qeri biric niŋmizac imi acac buŋa wammac. Méŋnéŋ méŋ imi alayawac niŋac, ic qelaŋa ʒémizac imi kua meme ic ionac kaunsol iguc onopocmu. Méŋnéŋ méŋ alayawac moroc ʒémizac imi geric siawac buŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Imuac gi ʒaki téréyawac sese mema hama alaganéŋ guac niŋac haʒéc ac méŋ késa kecʒac imi niŋɋelizaŋiguc ");
INSERT INTO kgf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sesega imi ʒaki téréya wésiaiguc haina taru walac alagawac kenna luae qegéŋuguc bec liliŋgéma hama sesega imi haimiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Gi haʒécgaguc hénaiguc kemmanec focdac ewa momac wammaoc. Imuhuc ménda wanna haʒécganéŋ gésigési icac muru goporu gésigési ic iminéŋ téŋgiŋ ic kuneŋginawac mériaiguc waigéŋu hésa amaiguc gopocmac. ");
INSERT INTO kgf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Goporu, ni hélacnec gézéwa niŋna, alagawac kitic imi mocʒoŋ ménda kudacma imuarunec mawésémaŋac séc qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yandahécgina yomuhuc énéc énézéya; Kaisero ai ménda mewésémaŋ, ac imi niŋgicac nindacʒu. ");
INSERT INTO kgf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Néŋ ni yomuhuc énézézua; Ic méŋnéŋ embac méŋ hémma ewayaiguc hémbaoc wammizac imi mia ewa qerianéŋ bec kaisero wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kicga héiigucnéŋ biriawac simbaiguc goporu, imi néfindiŋgéma gilina kemmac. Séwi taséga momacguc qahac waŋu séwiga yanda imi geric siaiguc ménda giliyu hiŋgacbésémaŋ iminéŋ hia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Méraga héiigucnéŋ biriawac simbaiguc goporu, imi hericma gilina kemmac. Séwi taséga momacguc qahac waŋu séwiga yanda geric siaiguc ménda giliyu hiŋgacbésémaŋ iminéŋ hia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ʒézéya méŋ imi yomuhuc; Ic méŋnéŋ méŋ iniŋa waimimac imi wai amuamuac kiwi oma mimac. ");
INSERT INTO kgf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Néŋ ni yomuhuc énézézua; Ic méŋnéŋ méŋ iniŋa kaiseroac qahac, néŋ yéwéri tosara niŋac waimizac imi, inéŋ embac imi kaiseroiguc opocʒac. Waŋu ic méŋnéŋ embac waimimia imi mezac imi, i acguc kaisero wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Waŋu muŋguc, yandahécgina yomuhuc énéc énézéya; Gi Anutuac kiwaiguc acga eŋ ménda ʒéseliwésémaŋ, néŋ guac ʒézépaŋ acga imi kewuac kiwaiguc wandacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Waŋu ni yomuhuc énézézua; Anutuac kiwaiguc ac méŋ méndagucnec ʒéselimu. Kurumeŋ qacma ménda ʒéselimu. Kurumeŋ imi Iwac ic kewu tatac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Waŋu baec acguc ménda qacma ʒéselimu. Baec imi Anutuac héna titiya wanʒac. Waŋu Yerusalem acguc ménda qacma ʒéselimu. Imi ic kewu eŋeŋawac ama areŋa yanda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Waŋu orucgaiguc acguc ménda koroma ʒéseliwésémaŋ. Imi mia gi oruc ʒucga meleŋna méŋac méŋ lalac me ʒapéla wammacac séc qahac imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Imuac bénʒéŋ dac, hélacnecac imi hélacnec, qahacwac imi qahac sac ʒému. Ac toroqeqeya imi Biria miŋinawac murunec hahaya. ");
INSERT INTO kgf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ac ʒézéya méŋ yomuhuc niŋanʒu; Kiwawac kitiwa imi kiwa, ʒécyawac kitiwa imi ʒécya. ");
INSERT INTO kgf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Waŋu neŋ yomuhuc énézézua; Haka biria kétik imuac nuna guwa ménda wammu. Méŋnéŋ huluŋga otomac imi, néwécgeŋga hia meleŋ mina qemac. ");
INSERT INTO kgf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Waŋu méŋnéŋ geŋga maleku niŋac aciguc guagicma keŋu saŋgeŋa malekuga imi momacnec wai miwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Méŋnéŋ héna hosuru guagicma kemmaŋac ʒéyu horua méndacmima kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Méŋnéŋ iwawaiga méŋ guagicmaŋ ʒé me lagulawac késamaŋ niŋac welecgéŋu eŋdac ménda mélina kemmac. ");
INSERT INTO kgf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Alaga siŋ nimmima haʒécga méʒétiti wammiwésémaŋ ac ʒézéya méŋ imuhuc niŋanʒu, ");
INSERT INTO kgf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","néŋ neŋ mia yomuhuc énézézua; haʒéc hécgina siŋgina niŋénécmimu. Waŋu ununesi waŋ énécmianʒu ionac niŋac wamma ʒéwelec wammigic goigina héimac. ");
INSERT INTO kgf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Imuhuc wamma kurumeŋ Maŋgoc ginawac nambérac wamma kecmu. Kurumeŋ Maŋgocginanéŋ kaiwe ʒéyu ic hia biria momacnec asari énécmianʒac. Waŋu kiaya imuhucyanec ic hia biria momacnec énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Siŋ niŋénécmianʒu ionacnec sac goigina héiénécmimu imi, némac kitiwa hiabia he énécmimac? Takis meme ic acguc haka imuhucya hia ménda waŋanʒu me? ");
INSERT INTO kgf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Waŋu alahécgina ionacnec sac ac qacguc waŋ énécmimu imi, némac iwawai kuneŋ yanda wanʒu wammac? Ic enia eneŋ haka imuhucya hia ménda waŋanʒu me? ");
INSERT INTO kgf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imuac mia kurumeŋ Maŋgocgina imi solaŋa kecʒac séc ini imuhucnec solaŋa kecmu. ");
INSERT INTO kgf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Técgina nimma kecmu. Haka solaŋa imi ic ieneŋ hémmu niŋac ʒéma kicginaiguc wambu niŋac. Imuhuc wammuiguc kurumeŋ Maŋgoc ginanéŋ bakia hiabia ménda meleŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kicac weleŋ qeqe imi ieneŋ tocgotocgo amaiguc ʒéma héna yanda séc kemma icnéŋ mepési énécmimu niŋac témuŋ hianʒu. Néŋ hélacnec ʒéwa niŋgic; Ic imi eneŋ baec icnéŋ mepési énécmigic bakiagina bec medacʒu. Gi imi geŋga wéségaiguc imuhuc ménda wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Néŋ maqeqeya iwawai méŋ énécmiwésémaŋ nalé imuaru méra héiganéŋ némac haka wanʒac imi méra kanaganéŋ ménda nimmac. ");
INSERT INTO kgf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Imuac niŋ haleŋ haihaiga imi sasaŋgiaiguc wambésémaŋ. Waŋu Maŋgocga sasaŋgiaiguc géŋanʒac inéŋ imuac bakia meleŋgémmac. ");
INSERT INTO kgf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Waŋu ʒéwelec wambésémaŋ imuaru ninʒéŋ ninʒéŋ ic ikora ieneŋ waŋanʒu ésécnec ménda wambésémaŋ. Ieneŋ mia inicmu niŋac tocgotocgo amaiguc ʒéma héna yanda séc namma ʒéwelec wawaŋa imuac siŋa niŋanʒu. Ni hélacnec énézézua; Ieneŋ imi boŋa bec késagic tecgézac. ");
INSERT INTO kgf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gi ʒéwelecbésémaŋ imuaru amagaiguc emma naguga héima maŋgocga sasaŋgiaiguc kecanʒac iwac muru ʒéwelec wambésémaŋ. Waŋu maŋgocga sasaŋgiaiguc hémma niŋanʒac inéŋ bakia imi meleŋgémmac. ");
INSERT INTO kgf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ini ʒéwelecbiŋ ʒé ic enia ésécnec ac héla qahac sasala ménda olommu. Ieneŋ mia ac sasala ʒéniguc niŋnénécmimac imuhuc ʒéma niŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Maŋgocgina imi ʒéwelec ménda waŋgicnec iwawai hocanʒu imi bec nindacʒac. Imuac ini ionac séc ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Imuac ini yomuhuc ʒéma ʒéwelec wammu; Kurumeŋ Maŋgocnina guac qacga mepésini téréya hemac. ");
INSERT INTO kgf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Guac héŋgaleŋ ama areŋa yanda mama hamac; Kurumeŋiguc hezac ésécnec baeciguc guac ewa siŋga wandac wandara wammac. ");
INSERT INTO kgf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gi deguc kaiwe yomuac nene sécnina nénécmina. ");
INSERT INTO kgf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nini ic ionac képésicgina wai énécmiziŋ, imuhucyanec képésicnina wai nénécmina. ");
INSERT INTO kgf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nini ménda wai nénécmina ala batuciguc kerembiŋ niŋac. Néŋ Biria miŋinawac murunec metecgé nénécmina. ");
INSERT INTO kgf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ini ic ionac képésic waimuiguc kurumeŋ Maŋgocginanéŋ onac képésic imuhucyanec waimac. ");
INSERT INTO kgf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Waŋu ini ic onac képésic ménda waimuiguc maŋgoc ginanéŋ képésicgina imuhucyanec ménda waimac. ");
INSERT INTO kgf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Waŋu nene ʒikima ʒéwelec wammuiguc ninʒéŋ ninʒéŋ ic ikora ieneŋ waŋanʒu ésécnec ewa biric tanec ménda wammu. Némac niŋ ieneŋ imi tanecgina wininiyu inictegicmu niŋac imuhuc waŋanʒu. Hélacnec énézézua; Ieneŋ imi bakiagina séha imi bec megic tecgézac. ");
INSERT INTO kgf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Geŋ mia nene ʒikima ʒéwelecbésémaŋ imuaru orucga haléc naec mima kic tanecga ʒuacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Waŋu nene ʒikima ʒéwelecma kecʒaŋ imi ic ionac muru qahac, néŋ Maŋgocga sasaŋgiaiguc kecanʒac iwac muru sac wininiyu géŋtegicmac. Waŋu Maŋgocga sasaŋgiaiguc iwawai hicŋiyu héŋanʒac inéŋ bakia meleŋ gémmac. ");
INSERT INTO kgf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ini hinac iwawaigina eeyaguc imi baeciguc ménda tocgégic emmac. Imuaru mia gureŋ ʒéma hufeŋanéŋ mebiriwac niŋac. Waŋu imuaru imi kowu nene ieneŋ héʒéŋgéma hiŋgacma kowu memu. ");
INSERT INTO kgf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Néŋ hinac iwawaigina eeyaguc imi kurumeŋiguc qutulaŋgégic emmac. Imuaru imi gureŋ ʒéma hufeŋanéŋ ménda mebirimac. Waŋu imuaru kowu nene ieneŋ ménda héʒéŋgéma hiŋgacma kowu memu. ");
INSERT INTO kgf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Hinac iwawaiga eeyaguc hemac imuaru mia ewa qeriga acguc hemac imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kicga imi séwigawac kifaya. Kicga hiabia hezaciguc asahanéŋ séwiga mocʒoŋ yanda sécgémac. ");
INSERT INTO kgf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Néŋ kicga birizaciguc imi tunumaŋnéŋ séwiga mocʒoŋ yanda sécgémac. Waŋu asac mararaŋ ewa qerigaiguc hezac iminéŋ siŋindéŋgézaciguc siŋi tunumaŋ dimuhucyanéŋ hicŋigémmac? ");
INSERT INTO kgf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ic momacgucnéŋ ic kewu éréhéc weleŋ qeérécmimacac séc qahac. Méŋac méʒétiti wammima méŋac siŋ nimmimac, me méŋac eeya héima méŋac niŋméimac. Ini Anutu ʒéma soukiwa momacnec weleŋ qeqe waŋ érécmimuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Imuac bec énézéwa; Némac dokuac me neneac newiŋ ʒéma kekecginawac qeri yéwéri ménda wammu. Séwiginawac némac iwawai héiwiŋ ʒéma qeri réwéri ménda wammu. Kekecganéŋ nenega ogicma eeyaguc ménda wanʒac me? Séwiganéŋ malekuga ogicma eeyaguc ménda wanʒac me? ");
INSERT INTO kgf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ini sawaiguc nei inicgic. Ieneŋ héihimic ménda waŋanʒu. Waŋu nene mequtulaŋ me hofiiguc haihai ménda waŋanʒu. Waŋu onac kurumeŋ Maŋgocnéŋ gumu énécmianʒac. Waŋu ini nei onogicma eeginaguc ménda wanʒu me? ");
INSERT INTO kgf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Waŋu onarunec mérénéŋ qeri réwéri wamma kekecginawac naléya komora méŋ hia mehorugimac? ");
INSERT INTO kgf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Waŋu ini némac niŋac malekugina niŋac qeri réwéri waŋanʒu? Sombeŋac baorac ʒurigina inicgic dimuhuc éréma yandianʒu? Ieneŋ malekugina niŋac hésadac méŋ taraŋ ménda héianʒu. ");
INSERT INTO kgf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Waŋu énézéwa niŋgic; Solomonnéŋ edamuyaguc meʒeric amuma kerec, néŋ ʒuria yomi ionarunec méŋ ménda ogirec. ");
INSERT INTO kgf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Anutunéŋ baec kisiawac ɋézézac deguc you heyu oraŋguc gericiguc giligic hiŋgacmacac hezac ʒariŋdac imuhucya imi imuhuc haioso meénécmianʒac iguc, yei ninʒéŋ ninʒéŋgina komodia ini, Anutunéŋ ini imi ʒuriadac imuhucya onogicma ménda haioso meénécmimac me? ");
INSERT INTO kgf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Imuac mia, némac neneac me dokuac newiŋ me némac iwawai héiwiŋ ʒéma qeri réwéri ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Imi mia ic enia eneŋ imuac waŋanʒu. Waŋu kurumeŋ Maŋgocginanéŋ iwawai imuhucyawac hocanʒu imi nindacʒac. ");
INSERT INTO kgf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Imuac bec walac imi Anutuac héŋgaleŋ ama areŋa yanda ʒéma iwac haka solaŋa niŋac wamma ʒéwelecmu. Iwawai tosara imi mocʒoŋ momacnec toroqe énécmidacmac. ");
INSERT INTO kgf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Imuac ini oraŋac qeri réwéri ménda wammu. Oraŋac qeri réwéri imi oraŋ eŋeya buŋa. Ai meme eŋac eŋac imi eŋeya réwéria sécya hemizac. ");
INSERT INTO kgf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ménda gési énécmimu imi, ini acguc imuhucyanec ménda gési énécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Imi mia gési énécmianʒaŋ imuhucyanec gésigéŋgéŋa wammac. Waŋu ac waŋ énécmianʒaŋ imuhucyanec ac waŋgéŋgéŋa wammac, hénia imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Gi némac niŋac alagawac kiwaiguc gocya hémma geŋga kicgaiguc ic ʒékalaŋa imuac mia ménda niŋtegicanʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Geŋgac kicgaiguc ic ʒékalaŋa heyunec, gi alagawac dimuhuc waina kicgaiguc gocya imi mewa mayu ʒéma hia ézéwésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ninʒéŋ ninʒéŋ ic ikora gi, walac ic ʒékalaŋa geŋga kicgaiguc imi mena mayuguc alagawac kiwaiguc gocya imi hiabianec hémma auwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ini iwawai téréya imi kazu ménda énécmimu. Waŋu décnaŋ boŋa eŋeŋaguc imi beric onac ménda gilimu. Imuhuc wammuiguc imi iwawai imi hénaginanéŋ tiʒiʒama liliŋgéma eŋaŋ kiricqiric waŋ énécmiwu niŋac. ");
INSERT INTO kgf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ʒéwelec waŋgic énécmimac. Hochoc ai mema mihicŋimu. Qoŋqoŋ qegic nagu auénécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mérénéŋ méŋ ʒéwelec waŋanʒac séc, énécmiyu meanʒac. Mérénéŋ méŋ hochoc ai meanʒac séc, mihicŋianʒac. Waŋu mérénéŋ méŋ qoŋqoŋ qeanʒac séc, nagu aumimia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Onarunec méŋnéŋ naŋa saméŋ niŋac weleru hoc hia mema mimac me? ");
INSERT INTO kgf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lambéc niŋac weleru qaté mokoleŋ hia mema mimac me? ");
INSERT INTO kgf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ini imi ic birianéŋ iwawai hiabia nambérac hécgina énécmimiawac hénia nindacʒu. Waŋu Maŋgocgina kurumeŋiguc kecʒac inéŋ welecmianʒu ionac iwawai hiabia sécgina ogicma ménda énécmimac me? ");
INSERT INTO kgf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Némac haka waŋgémmu niŋ niŋanʒaŋ séc ionac muru imuhucyanec waŋ énécmina. Ac iminéŋ héna ac ʒéma kua meme ic ionac ac imi mocʒoŋ dérécgédacma hezac. ");
INSERT INTO kgf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ini nagu géŋgéŋa imuaru keremma kemmu. Imi mia hénia yomuhuc niŋac imuhuc ʒézua; Nagu onagicma kisikiyoŋiguc keŋkeŋa imi kuneŋ yanda. Waŋu hénaya imi laŋhahala yanda, imuac mia imuaru ic embac kileŋnéŋ kereŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Nagu ʒéma héna kekeciguc nonagicma kenʒac imi komora ʒéma géŋgéŋa. Imuac niŋac ic embac éréhécdacnéŋ imi mihicŋianʒu. ");
INSERT INTO kgf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Kuameme ic ikora ionac galeŋ mema kecmu. Ieneŋ imi rama séwi hamu, néŋ qerigina imi haséŋ kazu yaréya. ");
INSERT INTO kgf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Héla gocmiagina hémma héniagina inictegicmu. Ini imi hésa waiyagucnéŋ waiŋ gocmia haiyu meanʒu me? Waŋu ɋézézacnéŋ fik ic gocmia haiyu meanʒu me? ");
INSERT INTO kgf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Qahacgucnec, imuac mia ic hésa hiabianéŋ héla hiabia haianʒac, néŋ ic hésa birianéŋ héla biria haianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ic hésa hiabianéŋ héla biria ménda haianʒac. Waŋu ic hésa birianéŋ héla hiabia ménda haianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Imuac ic hésa héla hiabia ménda haianʒac imi qericma geric qeriaiguc gilianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Imuac niŋ hélagina hémma héniagina inictegicmu. ");
INSERT INTO kgf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nuac niŋac Miŋ Kewuna, Miŋ Kewuna ʒénéŋanʒu séc mocʒoŋ kurumeŋac héŋgaleŋ ama areŋa yandaiguc kereŋdacmuac ménda hezac. Maŋgocna kurumeŋiguc kecanʒac iwac ewa siŋ tohoanʒac inéŋ sac keremmac. ");
INSERT INTO kgf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ic sasalanéŋ nalé yandaiguc yomuhuc ʒému; Miŋ Kewuna, nini guac qacgaiguc biaŋac ara ménda énézéyiŋ me? Guac qacgaiguc tiliŋtiliŋ biria ménda nesi énécmiyiŋ me? Guac qacgaiguc kiwi méréra yanda sasala ménda meyiŋ me? ");
INSERT INTO kgf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Imuhuc ʒégic ni yomuhuc ʒéasarimaŋ; Ni méndagucnec niŋénécmiyi, héna ac logima ai meanʒu ini nuac muru néŋgacgic! ");
INSERT INTO kgf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Imuac mérénéŋ méŋ nuac acna yomi nimma tohoma waŋanʒac imi, niŋtegic qiŋtegic icnéŋ amaya ʒamanʒiŋ qahaiguc meyec tanec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kia kiyu doku luyu luhuc qema ama lukunʒiyec, néŋ ménda hucgéyec. Ama séraŋ qambaŋa imi ʒamanʒiŋ qahaiguc ésékumuyec imuac niŋac imuhuc waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Waŋu mérénéŋ méŋ nuac acna yomi nimma ménda tohoma waŋanʒac imi ic niŋtegic qiŋtegicya qahac. Inéŋ amaya sakasac qahaiguc meyec tanec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kia mayu doku luyu luhucnéŋ qema ama qeyu kuneŋ yandanec héʒéŋ qéʒéŋgéma mayec. ");
INSERT INTO kgf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesunéŋ ac imuhuc ʒédaru tecgéyu ic embac tuŋ yanda imi eneŋ niŋgic ");
INSERT INTO kgf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","héna acac kiwi ic ésécnec qahac, néŋ ic kuc buŋaguc ésécnec ku énécmiyec imuac niŋac ku énécmima ʒézéya imuac welicgégic. ");
INSERT INTO kgf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesunéŋ baec boŋa igucnec mayu ic embac tuŋ sasala yandanéŋ méndacmigic. ");
INSERT INTO kgf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Waŋu ic méŋ wizi seliayagucnéŋ hama sicgémima yomuhuc ézéyec; Miŋ kewuna gi mehiaru némmaŋ ʒé wanʒaŋiguc imuhuc hia wambésémaŋac séc. ");
INSERT INTO kgf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Imuhuc ʒéyu Yesunéŋ méria suluma séwélaiguc haima ʒéyec; Ni siŋna imuac wanʒac, hiaruna. Imuhuc ʒéyu imuarunec mia wizi seliaya imi solaŋaniyec. ");
INSERT INTO kgf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Waŋu Yesunéŋ yomuhuc ézéyec; Ic méŋac méŋ ménda énézéwésémaŋ, néŋ kemma hofac oo ic ézéna séwiga héŋu, Mosenéŋ énézéyec séc sese haina kicginaiguc héipuc acga ésécnec waŋu hémma niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Waŋu Yesunéŋ Kafanaum ama areŋa yandaiguc kereŋu yaré ic 100 ionac orucgina méŋnéŋ iwac muru hama méra mimac niŋac ʒéwelec wammima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Miŋ kewuna, weleŋ qeqena méŋ imi séwiya humudaru amaiguc qenʒeŋ manʒeŋ réwéria qema hezac. ");
INSERT INTO kgf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ʒéyu Yesunéŋ yomuhuc ézéyec; Neŋ kemma mehiaru mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Imuhuc ʒéyu yaré ic 100 ionac galeŋginanéŋ ac yomuhuc melemma ʒéyec; Miŋ kewuna gi hana nidac imuhucya nuac ama baeŋanéŋ logigémmacac séc qahac, imuac acnec sac ʒéna, nuac weleŋ qeqena imi hiarumac. ");
INSERT INTO kgf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ni acguc eŋeŋa hécna ionac méra bawu kecba, nena ewa bacnaiguc yaré ichécna kecʒu. Waŋu méŋac niŋ kenna ʒéwa keŋanʒac. Waŋu méŋac niŋ hana ʒéwa haanʒac. Waŋu weleŋ qeqena méŋac yomi wanna ʒéwa waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesunéŋ ac imi nimma welicgéyec. Waŋu méndacmima kecgic ionac yomuhuc énézéyec; Ni hélacnec énézézua. Israel ic sucginaiguc ic ninʒéŋ ninʒéŋ kuneŋ yanda imuhucyaguc méŋ ménda mihicŋiyi. ");
INSERT INTO kgf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ni énézézua, Is igucnec ʒéma Wes igucnec ic embac sasalanéŋ haréma kurumeŋac héŋgaleŋ ama areŋa yandaiguc Abaraham, Isaka ʒéma Yakop iniguc tacma momacnec neʒéléléŋ wammu. ");
INSERT INTO kgf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Néŋ becarunec kurumeŋac héŋgaleŋ ama areŋa yanda imuac buŋa kecanʒu ieneŋ imi séŋgaŋgeŋ siŋi tunumaŋiguc giliénécmiyu hiŋgacdacmu. Hiŋgacma imuaru mia ʒésiac yanda wamma ʒécgina aric aric kimu. ");
INSERT INTO kgf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Waŋu Yesunéŋ yaré ic galeŋgina yomuhuc ézéyec; Amagaiguc kenna, ninʒéŋgézaŋ imuac séc hicŋigémmac. Waŋu weleŋ qeqe imi nalé imuarunec mia hiaruyec. ");
INSERT INTO kgf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesunéŋ Peteroac amaiguc emma héŋu Peteroac howuhaya imi séwi geric yanda wamma duŋaiguc hekerec. ");
INSERT INTO kgf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hekeru mériaiguc késayu hafiya waimiyu embac imi yacma Yesu weleŋ qemiyec. ");
INSERT INTO kgf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ama mari waŋu uŋa birianéŋ énéc énépésia sasala onagicma iwac muru hagic uŋa biria imi acyanéŋ ʒéma nesi énécmima hafiginaguc mocʒoŋ mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Imuhuc waŋu kua meme ic Yesaianéŋ ac méŋ yomuhuc ʒéyec imi héla héiyec; Inéŋ kucmama qeka mekanina nonagirec. Waŋu yaŋhafinina bisima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu imi ic tuŋagucnéŋ lelecgémigic inicma tohotoho ichéra ʒékéŋ yanda néwécgeŋaiguc kemmu niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Waŋu héna acac kiwi ic méŋnéŋ iwac muru hama ʒéyec; Kiwi ic, dimia dimia kembésémaŋ imi ni méndac gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ʒéyu Yesunéŋ ac yomuhuc ézéyec; Haséŋ kazu imi teŋginaguc sawaiguc nei imuhucnec haecginaguc, néŋ Icac Naŋa imi oruha haihaiyawac ama duŋa méŋ ménda hemizac. ");
INSERT INTO kgf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Waŋu tohotoho icya méŋnéŋ yomuhuc ézéyec; Miŋ kewuna, waina walac kemma maŋgocna téŋgémaguc hawa. ");
INSERT INTO kgf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ʒéyu Yesunéŋ yomuhuc ézéyec; Gi waima méndacnénna, humuc ic eŋaocnec humuc ichécgina téŋgé énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Imuhuc ʒéma ʒéiciguc eŋu tohotoho ichéra méndacma emma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Keŋgic nalé sosola qahac luhuc yandanéŋ qeyu temboŋ yanda yacma ʒéic hoturumaŋ ʒé waŋec. Waŋu Yesu imi gau hekerec. ");
INSERT INTO kgf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Waŋu tohotoho ichéra eneŋ kemma mindima ézégic; Miŋ kewunina, aŋgéŋnina tina, nini humuwiŋ ʒé wanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ʒégic acgina melemma ʒéyec; Ini ninʒéŋ ninʒéŋgina komocdiadac. Némac niŋac bacgina yandizac? Imuhuc ʒéma yacma luhuc ʒéma temboŋa ac waŋ érécmiyu mocʒoŋ néŋ qeyoc. ");
INSERT INTO kgf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Waŋu ic eneŋ welicgéma yomuhuc eminiŋgic; Imi némac ic méŋ imuhucya? Luhuc ʒéma konduŋ acguc ara tohozaoc? ");
INSERT INTO kgf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu ʒéma tohotoho ichéra ieneŋ ʒékéŋ qericma néwécgeŋ Gadara baeciguc kereŋgic ic éréhéc uŋa birianéŋ éréc érépésiya imi kicsuaŋ igucnec hama Yesu mihicŋiyoc. Ic éréhéc imi qeri yarégira eŋeŋa, imuac niŋac méŋnéŋ imuacnec kemmuac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Waŋu iereŋ kucnec qacma yomuhuc ʒéyoc; Guac némac méŋ norac muru heyu hazaŋ? Anutuac naŋa, nalé ménda ducŋiyunec ʒéra waiya nérécmimaŋ ʒé hazaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Waŋu baec imuaru mia lakec ésécdac kemma beric tuŋginaguc gumu énécmigic naŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Imuac uŋa biria ieneŋ Yesu welecmima ʒégic; Nesi nénécmimaŋac ʒé méli nénécmina beric ionac qeriginaiguc hiŋgacbiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ʒégic yomuhuc ʒéyec; Keŋgic! Waŋu Yesunéŋ imuhuc énézéyu uŋa biria imi mama kemma beric ionac qeriginaiguc hiŋgacdacgic. Waŋu, ninʒu, beric imi mocʒoŋ yanda siaiguc gindindiŋgéma kemma ʒékéŋiguc hiŋgacma humudacgic. ");
INSERT INTO kgf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Beric galeŋgé énécmigic imi eneŋ usuŋnec néŋgacma tauŋiguc keremma suruc imi mocʒoŋ ʒéma ic uŋa birianéŋ éréc érépésia iorac suruc momacnec waŋ énécmidacgic. ");
INSERT INTO kgf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Waŋu tauŋ imuac ic embac mocʒoŋ imi Yesu mihicŋiwiŋ ʒé hadacgic. Hama hémmaguc baec imi waima kemmac niŋac welecmigic. ");
INSERT INTO kgf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Waŋu Yesunéŋ ʒéiciguc emma konduŋ qericma eŋeya tauŋiguc hayec. ");
INSERT INTO kgf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Haréyu ic méŋ héna méria humumia sasaŋiguc haima huama iwac muru hagic. Waŋu Yesunéŋ ninʒéŋ ninʒéŋgina hémma ic héna méria humumia yomuhuc ézéyec; Naŋ, ewa qeriga déŋ, Képésicga waigéndac géndara wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Imuhuc ʒéyu, héna acac kiwi ic tosia ieneŋ qeriginaiguc yomuhuc niŋgic; Ic yomi Anutu ʒébiri qébiri wammizac. ");
INSERT INTO kgf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Waŋu Yesunéŋ qerigina niŋtegicma yomuhuc ʒéyec; Ini némac niŋac ewa qeriginaiguc niniŋ biria imuhucya niŋkecʒu? ");
INSERT INTO kgf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ac diminéŋ efefia wanʒac? Képésicga waigéndac géndara iminéŋ me Yacma kenna imi? ");
INSERT INTO kgf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Waŋu Icac Naŋa imi baeciguc képésic waiwaiyawac kuc buŋa hemizac imi hémma niŋtegicmu. Imuhuc ʒéma ic hénia humumia yomuhuc ʒéma ézéyec; Yacma sasaŋga mema amagaiguc kenna. ");
INSERT INTO kgf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Imuhuc ʒéyu ic imi yacma amayaiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Waŋu ic tuŋginaguc ieneŋ haka imi hémma welicgégic. Waŋu kuc buŋa imuhucya baec ic énécmiyec imuac niŋac Anutu mepési migic. ");
INSERT INTO kgf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Waŋu Yesunéŋ imuacnec kemma héŋu ic méŋ qara Mataio imi takis meme amaiguc taru hémma ézéma ʒéyec; Gi hama méndacnénna. Imuhuc ʒéyu yacma méndacmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Méndacmiyu iwac amayaiguc emma nene nema tarec. Taru takis meme ʒéma biria meme sasalanéŋ hama Yesu ʒéma tohotoho ichéra iniguc momacnec tacma nene negic. ");
INSERT INTO kgf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Imuhuc waŋgic Farisaio ic ieneŋ inicma tohotoho ichéra yomuhuc énézégic; Némac niŋac kiwi icgina imi takis meme ic ʒéma biria meme ic iniguc nene nezac? ");
INSERT INTO kgf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Imuhuc ʒégic, Yesunéŋ nimma yomuhuc ʒéyec; Yaŋ hafigina qahac ieneŋ mehiahiaru ic ionac niŋ ménda waŋanʒu, néŋ hafiginaguc ieneŋ mia ionac niŋ waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kemma ac yomuhuc hezac imuac hénia dimuhuc imi niŋareŋgému; Ni imi mulu meme imuac qahac, néŋ goi héihéi imuac waŋanʒua. Imuac ni ic embac solaŋa unurumaŋ ʒé ménda mayi, néŋ képésic ic unurumaŋ ʒé mayi. ");
INSERT INTO kgf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nalé imuaru Yohaneac tohotoho ichéra ieneŋ Yesuac muru hama yomuhuc qesigic; Nini ʒéma Farisaio ic nalé séc nene ʒikima ʒéwelecanʒiŋ. Waŋu guac tohotoho ichécga imi eneŋ némac niŋac nene ʒikima ʒéwelecwelec ai imi ménda waŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ʒégic Yesunéŋ yomuhuc énézéyec; Ʒammaréŋ ic buŋawac méŋac ic qaŋ ieneŋ dimuhuc ic imi iniguc kerunec ewa biric wammu? Naléya hayu ic buŋa onagicma keŋgicguc nene ʒikima ʒéwelecmu. ");
INSERT INTO kgf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ic méŋnéŋ méŋ séwi usu walaha bobogélaiguc ɋelia dépaŋa ménda nékétama ɋotomac. Imuhuc waŋu nékétatara iminéŋ icgéma wahala imi héré muʒucgéyu kuneŋnec tegicmac. ");
INSERT INTO kgf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Waiŋ ɋelia imi gésé wahalaiguc ménda tianʒu. Imuhuc wammuiguc imi luhucyanéŋ itiracgéyu téyu waiŋ imi qocgéma madacmac. Waŋu gésé acguc biridacmac. Imuac niŋ waiŋ ɋelia imi gésé ɋeliaiguc kisigic hiŋgacanʒac. Imuhuc waŋu waiŋ ʒéma gésé imi momacnec hiabianec hemaoc. ");
INSERT INTO kgf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ac imi énézémanec naŋu qeriawac galeŋ méŋnéŋ iwaru hama héniaiguc sicgémima ʒéyec; Béracna degucdacmi humuzac, néŋ gi hama méraga qahaiguc haimina ɋelima kecmac. ");
INSERT INTO kgf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Imuhuc ʒéyu Yesu yacma iguc keŋoc. Keŋic tohotoho ichéra imuhucyanec waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Keŋkecma kecgic embac méŋ yawuŋ 12 séc embac hafi wamma kecaŋec imi Yesuac andiaiguc hama malekuya susuria osiyec. ");
INSERT INTO kgf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Imuhuc wamma ewayanéŋ yomuhuc niŋec; Malekuya sac osiwa mehiaru némmac. ");
INSERT INTO kgf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Waŋu Yesunéŋ liliŋgéma hémma ʒéyec; Bérac, ewaga déŋ. Ninʒéŋ ninʒéŋganéŋ mehiaru génʒac. Imuhuc ʒéyu imuarunec mia embac imi hiaruyec. ");
INSERT INTO kgf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Waŋu Yesu imi qeriawac galeŋ imuac amayaiguc kemma héŋu kuŋa hihi ic ʒéma ic tuŋginaguc eneŋ héisiac wamma hétéŋ yanda wamma tacgic. ");
INSERT INTO kgf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Waŋu énézéyec; Ini yacma hiŋgacdacgic embac komoc imi ménda humuzac, néŋ eŋ gau hezac. Waŋu imuhuc ʒéyu desimigic. ");
INSERT INTO kgf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Desimima hiŋgacdacgic ama qeriaiguc emma embac komoc imi mériaiguc késayu yarec. ");
INSERT INTO kgf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Waŋu imuac buŋa surucya imi baera baera saima kendarec. ");
INSERT INTO kgf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Waŋu Yesu imi baec imi waima keŋu ic kic hilic éréhéc iereŋ méndacmima kucnec yanda qacma ʒéyoc; Dawidiac ɋeli, gi norac ewa biric wanna. ");
INSERT INTO kgf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Waŋu Yesu imi ama qeriaiguc eŋu kic hilic ic éréhéc imi iwac muru hayic qesiérécmiyec; Qesiérécmima yomuhuc érézéyec; Iri imi neŋ ai imi hia memaŋ niŋac ninʒéŋgézaoc? Ʒéyu iereŋ melemma ʒéyoc; Oo, Miŋ kewunira. ");
INSERT INTO kgf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Imuhuc ʒéyic, kicgiraiguc osima ʒéyec; Ninʒéŋgézaoc séc hicŋi érécmiyu. ");
INSERT INTO kgf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Imuhuc ʒéyu kicgira hiaruyec. Waŋu Yesunéŋ ʒéseli érécmima ʒéyec; Ninʒaoc, yomuac suruc imi ic méŋac méŋ ménda ʒéyic nimmu. ");
INSERT INTO kgf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Waŋu iereŋ kemma kileŋ suruc imi ʒésaiyic baec imuaru sécgédarec. ");
INSERT INTO kgf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Waŋu ic éréhéc imi séŋgaŋgeŋ keŋic duŋa ic méŋ uŋa birianéŋ késayu ac ménda ʒéaŋec imi wagicma Yesuac érégic. ");
INSERT INTO kgf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Waŋu uŋa biria imi nesiyu néŋgaru ic ara qahac imi ac ʒéyec. Ʒéyu ic embac tuŋginaguc hémma naŋgic imi eneŋ welicgéma ʒégic; Haka imuhucya méŋ Israel baeciguc ménda hicŋiyu héŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Waŋu Farisaio ic ieneŋ Yesuac yomuhuc ʒégic; Imi uŋa biria ionac kuneŋginanéŋ kuc buŋa miyu uŋa biria nesi énécmizac. ");
INSERT INTO kgf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu imuhuc imuhuc wamma ama areŋa yanda yanda ʒéma komoc komoc séc kendacma tocgotocgo amaginaiguc emma héŋgaleŋ ama areŋa yanda imuac buŋa suruc hiabia imi ʒéau énécmima ku énécmiyec. Imuhuc wamma wizi kukuginaguc ʒéma yaŋ hafiginaguc imi mocʒoŋ mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Waŋu ic embac tuŋginaguc imi iniru rama galeŋgina qahac kecanʒu ésécnec kucgina qahac tuima kecgic ewa biric waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Imuhuc inictegicmaguc tohotoho ichéra yomuhuc énézéyec; Ai yawuŋ imuac héla imi sasala, waŋu imuac ai ic imi efefiadac. ");
INSERT INTO kgf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Imuac niŋ ai ic méli énécmiyu aiyaiguc kemmu niŋac metocgo tocgoac ai yawuŋ miŋina ʒéwelec wammigic. ");
INSERT INTO kgf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu imi tohotoho ichéra 12 eŋeya muru unuruyu hagic uŋa biria nesi énécmima wizikuku ʒéma yaŋhafi mocʒoŋ mehiaru énécmimu niŋ imuac kuc buŋa énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesuac Méliméli ic 12 ionac qacgina imi yomuhuc; Walac Simon Petero ʒémimia, iwac munia Anderea, ʒéma Ʒebedaioac naŋa Yakobo ʒéma munia Yohane. ");
INSERT INTO kgf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Waŋu Filipo ʒéma Batolomaio, Toma ʒéma takis meme ic Mataio, Alfaioac naŋa Yakobo, waŋu Tadaio, ");
INSERT INTO kgf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Kanaan ic Simon ʒéma Yuda Karioto, waŋu inéŋ mia kecma Yesu andé qemiyec. ");
INSERT INTO kgf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu tohotoho ichéra 12 imi méli énécmima pakeŋ ac yomuhuc énézéyec; Ic enia ionac ménda kemmu. Waŋu Samaria ic ionac tauŋ imi imuaru me imuaru méŋ ménda keremmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Rama roucya Israel ic ionac sac kemmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Keŋkecma imuac séc yomuhuc ʒéma ʒéaumu; Kurumeŋac héŋgaleŋ ama areŋa yanda imi hosucgé énécmizac. ");
INSERT INTO kgf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Waŋu yaŋhafi ginaguc imi mehiaru énécmimu. Humuc igucnec meɋeli énécmimu. Wizi seliginaguc imi mesolaŋani énécmimu. Waŋu tiliŋtiliŋ biria nesi énécmimu. Waŋu boŋa qahac eŋ késazu imuac eŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Owo géséginaiguc soukiwa haréŋa ʒéma gocmia lalaha me pésia méŋ ménda tima kemmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Hénawac gésé me maleku saméŋa me héna usu me tacgina imi ménda mema kemmu. Ai ic imi nene yaka boŋa qahac énécmimuac hezac. ");
INSERT INTO kgf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ama areŋa yanda me ama areŋa hocma keremma ama miŋina méŋac niŋgic sécgéyu iwac ama igucnec sac heyac wamma opocma kemmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Waŋu ama imuac emma yomuhuc énézému; Luae onac muru hemac. ");
INSERT INTO kgf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Anutunéŋ ama imuac miŋinawac niŋu sécgéyu luae qeqe acginawac héla imi ionac muru hama hemac. Néŋ ménda sécgéyu luae qeqe acginawac hélanéŋ eŋaŋ muru liliŋgémac. ");
INSERT INTO kgf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Méŋnéŋ méŋ ménda héihéré énécmimac me acgina ménda nimmaciguc imi ama me tauŋ imi hénaginaiguc seitotoŋ qesagic mayu waima kemmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ni hélacnec énézéwa, gésigési nalé yandaiguc Sodom Gomora baec ic ionac taségina imi tauŋ yomuac ic ionac taségina ogicma meefiyu huahuayawac séc wammac. ");
INSERT INTO kgf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ninʒu, ni ini haséŋ kazu sucginaiguc rama ésécnec méli énécmizua. Imuac niŋtegic qiŋtegicgina mokoleŋac séc kecma kembo neiac séc képésic solaŋ kecmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ic ionac niŋ, galeŋgina mema kecmu. Ieneŋ mia ac gésigési ic ionac muru onopocgic, tocgotocgo amaiguc kocbiŋnéŋ unumu. ");
INSERT INTO kgf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Waŋu nuac niŋac wamma ini baec galeŋ ʒéma ic kewu wéséginaiguc onagicma kemmu. Keŋgic ionac muru ʒéma ic enia ionac muru nuac héipuc ic wamma nammu. ");
INSERT INTO kgf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Néŋ énépésimu imuaru némac ac ʒéwiŋ me dimuhuc ʒéwiŋ imuac ewa goro ménda wammu. Nalé imuaru némac ac ʒému imi énécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ac ʒézé ic imi eneŋ qahac, néŋ Maŋgoc ginawac Uŋanéŋ ac imi kuaginaiguc hai énécmiyu ʒému. ");
INSERT INTO kgf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Waŋu dac muna ekaocnec andé qeamuma méŋnéŋ méŋ késama humuciguc opocmac. Waŋu maŋgoc méŋnéŋ naŋa imuhucyanec wammimac. Waŋu nambérac eneŋ héna ac topec qema neŋgoc maŋgoc hécgina humuciguc onopocmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nuac niŋac ic embac mocʒoŋ yanda ieneŋ ini méʒétiti waŋ énécmimu, néŋ mérénéŋ méŋ deguc muacnec hénima emma nalé tetecgia hamac imuac séc naŋseligima kecmac imi késayu kekec hémbénaŋa kecmac. ");
INSERT INTO kgf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Waŋu unuhéi waŋ énécmigic tauŋ imuarunec néŋgacma baec méŋiguc kemmu. Ni hélacnec énézézua. Israel ama areŋa kuneŋ kuneŋ séc ménda kendacgicnec Icac Naŋa hamac. ");
INSERT INTO kgf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kiwi merac méŋnéŋ kiwi icya ménda ogicʒac. Waŋu weleŋ qeqe ic méŋnéŋ imuhucyanec miŋina ménda ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kiwi meracnéŋ kiwi icya ésécnec waŋu sécgémac. Waŋu weleŋ qeqe icnéŋ miŋina séc waŋu sécgémac. Amawac galeŋa imi Beelʒebul ʒémigiciguc tohotoho ichéra dimuhuc ogicma ʒébiri énécmimu? ");
INSERT INTO kgf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Imuac ionac niŋac bacgina ménda yandimac. Iwawai méŋ musaŋ musaŋgia imi auyu winiŋu ménda hemacac séc méŋ ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tunumaŋiguc ʒézua ac imi kaiwe asahaiguc ʒému. Waŋu gezacginaiguc ʒéwa ninʒu ac imi ama bauyaiguc namma ʒéaudacmu. ");
INSERT INTO kgf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Séwigina qehumumu, néŋ qeri uŋagina hia ménda qemuac séc wanʒu ionac niŋac bac yandi yandi ménda wammu. Néŋ uŋa ʒéma séwi momacnec geric siaiguc hia mebirimac iwac niŋ mia bac yandi yandi wammu. ");
INSERT INTO kgf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Sirikic nei dac éréhéc imi soukiwa momacgucnéŋ boŋ ménda meanʒu me? Waŋu Maŋgocginanéŋ ménda niŋuguc baeciguc méŋ ménda mama qemac. ");
INSERT INTO kgf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Onac imi oruc ʒucginawac qétéya acguc oloŋ nindac nindara wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Imuac ini bac yandi yandi ménda wammu. Ini imi sirikic nei sasala onogicma eebipiginaguc wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Méŋ ic onac kicginaiguc nimmizua ʒéma ʒéaunéŋu ni acguc kurumeŋ Maŋgocnawac kiwaiguc nimmizua ʒéma ʒéaumimaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Néŋ méŋnéŋ méŋ ic onac kicginaiguc ni qaecgé néŋu ni acguc kurumeŋ Maŋgocnawac kiwaiguc i qaecgé mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nuac niŋ baeciguc luae qemaŋ ʒé mayec gezaŋ imuhuc ménda ʒéma nimmu. Luae qahac, néŋ sou énécmimaŋ ʒé mayi. ");
INSERT INTO kgf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ni imi naŋa méŋ eŋeya maŋgocyawac murunec, bérara méŋ eŋeya neŋgocyawac murunec, waŋu eraŋiya méŋ eŋeya eraŋiya wac murunec héric énécmiwa téamumu niŋac mayi. ");
INSERT INTO kgf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Waŋu ic méŋac sac taséhéranéŋ eŋeya haʒéchéra wammu. ");
INSERT INTO kgf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Méŋnéŋ méŋ neŋgocyawac me maŋgocyawac mia sécna ogicma ewa siŋa eŋeŋa niŋérécmimac imi nuac ai ic buŋawac séc qahac. Waŋu méŋnéŋ méŋ naŋawac me bérarawac niŋ sécna ogicma ewa siŋa eŋeŋa nimmimac imi acguc nuac ai ic buŋawac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Waŋu méŋnéŋ méŋ imi eŋeya ic héŋgeŋa wéndara ménda huama méndac némmac imi imuhucyanec nuac ai ic buŋawac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Méŋnéŋ méŋ eŋeya kekecya aŋgétiyu kekecya imi sohomac. Waŋu méŋnéŋ méŋ nuac niŋac wamma kekecya waimac imi kekecya mihicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ic méŋnéŋ ini héihéré énécmimac imi ni héihéré nénʒac wammac. Waŋu ni héihéré némmac imi méli néŋec i héihéré mizac wammac. ");
INSERT INTO kgf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Méŋnéŋ méŋ kua meme ic méŋ kua meme ic kecʒac imuac niŋac héihéré mimac imi kua meme icac séciguc bakia memac. Waŋu méŋnéŋ méŋ ic solaŋa méŋ ic solaŋa kecʒac imuac niŋ héihéré mimac imi ic solaŋawac séciguc bakia memac. ");
INSERT INTO kgf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Waŋu hélacnec énézéwa niŋgic. Méŋnéŋ méŋ ic mamaya youmi ionarunec méŋ nuac tohotoho ic kecʒac imuac niŋ doku dac saŋgeŋa méŋ himimac imi boŋtegic méŋ ménda heselimac. ");
INSERT INTO kgf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesunéŋ tohotoho ichéra 12 pakeŋ ac imuhuc énézéyu tecgéyec. Tecgéyu Galilaia baec ama areŋa yanda yandaiguc ackuaʒéc ʒéau énécmima ku énécmimaŋ ʒé imuacnec waima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Waŋu Yohane imi hésa amaiguc tacma Yesunéŋ ai meyec imuac buŋa nimma tohotoho ichéra méli énécmiyu keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kemma yomuhuc ʒéma qesimigic; Hanénécmimac niŋac ʒézéya imi gi mia me méŋac mambéc kecbiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Imuhuc ʒégic Yesunéŋ yomuhuc énézéyec; Ini liliŋgéma kemma iwawai hémma ninʒu imuac buŋa surucya wamma Yohane yomuhuc ézému; ");
INSERT INTO kgf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Kic hilicnéŋ kicgina hima hénʒu. Héna méragina humumianéŋ héna kenʒu. Wizi seliginaguc ieneŋ séwigina solaŋa wanʒu. Gezacgina héhéŋgianéŋ ac ninʒu. Humuc icnéŋ ɋelima kecʒu. Waŋu maqeqeya ionac buŋa suruc hiabia énéc énézéya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ic méŋ nuac niŋ nimma ménda maqeanʒac imi ségiségiyaguc. ");
INSERT INTO kgf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Waŋu Yohaneac tohotoho ichéra ieneŋ liliŋgéma keŋgic imuaru Yesunéŋ Yohaneac niŋ ic embac yomuhuc hénima énézéyec; Ini baec kisiaiguc némac hémbiŋ ʒéma keŋgic? Uŋ téfara luhucnéŋ mihilaŋgéyu keŋha wamma hezu imuac hémbiŋ ʒéma keŋgic? ");
INSERT INTO kgf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Qahaciguc, némac iwawai hémbiŋ ʒéma keŋgic? Ic méŋ séwi usuya hiabia hima naŋu imuac hémbiŋ ʒéma keŋgic? Séwi usugina hiabia hianʒu imi eneŋ ama kewuyaiguc tacyac waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Waŋu némac iwawai hémbiŋ ʒéma keŋgic? Anutuac tiliŋ tiliŋ ic méŋac me? Iminéŋ mia héla wanʒac! Ni énézéwa, ic imi kua meme ic tosara onogicma séc méŋ wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iwac niŋac mia yomuhuc ogic hezac; Ninʒaŋ, ni kua meme icna méŋ méliwa wéségaiguc walac kemmac, kemma inéŋ mia guac hénaga héimindiŋi wamma ʒéréŋqéréŋ wammac. ");
INSERT INTO kgf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ni hélacnec énézéwa, embac igucnec hicŋihicŋiya ionarunec méŋnéŋ méŋ doku naec haka ic Yohane ménda ogicʒac. Néŋ kurumeŋac héŋgaleŋ ama areŋ yandawac qeriaiguc imi ic mamaya ginanéŋ i hia ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Doku naec haka ic Yohane iwac nalé igucnec érékecma deguc kurumeŋac héŋgaleŋ ama areŋa yanda imi seliseliiguc kereŋaŋgicac keremmanec nanʒu. Waŋu seliseli wamma kereŋanʒu ieneŋ imi aŋgétianʒu. ");
INSERT INTO kgf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Anutuac tiliŋ tiliŋ ic mocʒoŋ ʒéma Moseac héna ac mocʒoŋ yanda biaŋac ara ʒéaŋgic imi Yohaneac muru hama tecgédarec. ");
INSERT INTO kgf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Waŋu ac yomi késawiŋ ʒé qeriginanéŋ wanʒaciguc ʒéwa niŋgic; Elia hamac niŋ ʒézéya imi Yohane ic yomi mia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Imuac gezawagucnéŋ ac imi nimmac. ");
INSERT INTO kgf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nalé yomuac hicŋisai imi némaciguc séc héiénécmimaŋ? Yomi eneŋ imi mia nambérac eneŋ nénnagémba sombeŋiguc tacma alahécgina unuruanʒu ésécnec; ");
INSERT INTO kgf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nini onac kuŋa hihi wanni ini ménda hirizu. Ewa biric legic héini ini ʒésiac ménda wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Séséc imuhucyanec Yohanenéŋ hama nene me doku ménda nema ʒéwelec wamma keru hémma uŋa biriayaguc ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Waŋu Icac Naŋa mama nene doku neyu hémma ʒucnuŋguŋ ʒéma miŋgoŋ ic, waŋu takis meme ʒéma képésic ic ionac alagina ʒémianʒu. Waŋu nintegic qiŋtegic ac imi imuac wawaŋ memeyanéŋ mesolaŋani mimac. ");
INSERT INTO kgf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Waŋu kiwi méréra sasala ama areŋ tosara onogicma meyec ama areŋa yanda yanda imuac miŋina ieneŋ ewagina ménda meleŋgic. Imuac Yesunéŋ ionac yomuhuc ac waŋ énécmiyec; ");
INSERT INTO kgf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Korasin ʒéma Betsaida miŋina ini imi saecginaguc. Kiwi méréra icnéŋ ménda memeya sasala onac muru meénécmimia imi Tiro ʒéma Sidoniguc mewa hicŋiwacnec, ieneŋ becarunec ewa biricac toma héigic qacginu eŋu siacma ewa biri wamma ewagina melembunec. ");
INSERT INTO kgf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Énézéwa niŋgic, gésigési nalé yandaiguc, Tiro ʒéma Sidon baec ic ionac taségina imi ama areŋ yomuac ic ionac taségina ogicma meefiyu bisiqatéŋ hia wammuac séc wammac. ");
INSERT INTO kgf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Waŋu Kefanaum ama areŋa geŋ meeŋ amuma kurumeŋiguc embésémaŋ me? Qahacgucnec, gi humumia ionac baec dumuŋaiguc hiŋgacbésémaŋ. Kiwi méréra guaru hicŋiyec iminéŋ Sodom ama areŋiguc hicŋiwacnec ama areŋ imi ménda qahac wamma deguc youmi tacbacnec. ");
INSERT INTO kgf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Imuac ʒéwa niŋgic, gésigési nalé yandaiguc Sodom baec miŋina ionac taségina imi ama areŋ yomuac ic ionac taségina ogicma meefiyu bisiqatéŋ hia wammuac séc wammac. ");
INSERT INTO kgf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Waŋu nalé imuaru Yesunéŋ yomuhuc ʒéyec; Baec kurumeŋ miŋina, gi ackuaʒécga imi niŋtegic qiŋtegic ic ʒéma niniŋ ic ionac muru musaŋgé énécmianʒaŋ, néŋ nambérac komoc komoc ionac mia énézéna héŋanʒu. Maŋgoc, imuac mia gi mepésigénʒua. ");
INSERT INTO kgf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oo, Maŋgoc, yominéŋ ewa siŋga heyec imi mia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Maŋgocnanéŋ iwawai mocʒoŋ méranaiguc haidarec. Ic méŋ Naŋa ménda niŋmizac, néŋ Maŋgocyanéŋ sac niŋmizac. Waŋu méŋnéŋ méŋ Maŋgoc ménda niŋmizac, néŋ Naŋa ʒéma Naŋanéŋ énézéyu hémmu imi eneŋ sac nimmizu. ");
INSERT INTO kgf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Qekameka ʒéma iwawai réwéria bisiqatéŋ wamma kecʒu imi mocʒoŋ nuac muru hadacgic. Neŋ tac niniŋ mihicŋi énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ni imi ewa qerinanéŋ gum bénʒénʒéŋa ʒéma memaamu kekera, imuac nuac muru hagic. Hama boŋ ʒurana mema qacginu haima nuac murunec niŋareŋ waŋgic. Kekec uŋaginanéŋ tacniniŋ mihicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nuac boŋ ʒurana imi haŋ qeqeya waŋu nuac hinana imi efefia. ");
INSERT INTO kgf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nalé imuaru Yesunéŋ Sabata naléiguc wit ai qericma keŋec. Keŋu tohotoho ichéra ieneŋ yaka niŋ humuma wit héla tosara kuma negic. ");
INSERT INTO kgf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Negic Farisaio ic eneŋ inicma Yesu ézéma ʒégic; Inicna! Tohotoho ichécga eneŋ Sabataiguc haka ménda wawaŋawac wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ʒégic yomuhuc énézéyec; Dawidi ʒéma méndacmimia ieneŋ yaka niŋac humuma némac haka waŋgic imi ini méŋ ménda oloŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Inéŋ Anutuac ocmuŋ qeriaiguc emma méndacmimia iniguc saméŋ téréya imi negic. Haka hofac oo ic ieneŋ sac wawaŋawac séc imi waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Me Sabata séc hofac oo ic ieneŋ ocmuŋ téréyaiguc héna ac logima ai mema kendoŋ qesaulianʒu, néŋ képésic solaŋ kecʒu imi ini héna aciguc ménda oloŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Neŋ imuac énézéwa niŋgic, ocmuŋ téréya ogicma eŋeŋa wanʒac imi youmi nanʒua. ");
INSERT INTO kgf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ac kiwi méŋ yomuhuc hezac; Ni mulumanaŋ qahac, néŋ wésé niniŋac ewa siŋna heanʒac. Ini ac imuac hénia nimbunec képésic ginaguc ménda ʒéénécmiwunec. ");
INSERT INTO kgf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Imi mia Icac Naŋa imi Sabata kendoŋ imuac miŋina kecʒac imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Imuhuc ʒéma baec imuacnec kemma tocgotocgo amaginaiguc eŋec. ");
INSERT INTO kgf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Waŋu imuaru ic méŋ méria séléc sélécgia tarec. Taru ic embac eneŋ Yesu aciguc opocbiŋ ʒé héna hocma qesimigic; Sabata kendoŋiguc hafi mehiaru énécmimiawac hezac me? ");
INSERT INTO kgf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ʒégic Yesunéŋ yomuhuc énézéyec; Onac murunec méŋnéŋ rama momacguc késakeru Sabata kendoŋiguc baec séséŋiguc hiŋgaru ménda késahéréyu érémac me? ");
INSERT INTO kgf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Icnéŋ rama ogicma kuneŋnec eeyaguc wanʒac, imuac Sabata kendoŋiguc goi héihéi ai imi hia wammacac hezac. ");
INSERT INTO kgf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Imuhuc ʒéma ic imuac, Méraga suluna, ʒéyu méria suluyu mocʒoŋ kekec tataru wamma néwécyawac séc waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Imuhuc waŋu Farisaio ic ieneŋ hiŋgacma Yesu dimuhuc qewiŋ ʒéma sasaŋgiaiguc ʒéareŋ waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Waŋu Yesu imi niŋtegicma ama baec imi waima baec méŋu keŋec. Keŋu ic embac sasalanéŋ méndacmigic. Waŋu yaŋ hafiginaguc imi mocʒoŋ mehiaru énécmidarec. ");
INSERT INTO kgf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mehiaru énécmima eŋeya hénia ménda ʒéaumu niŋac neuŋ héiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Imi mia Anutunéŋ Yesaiawac murunec biaŋac ara yomuhuc ʒéyec imi héla héimac niŋac imuhuc waŋec; ");
INSERT INTO kgf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Youmi imi weleŋ qeqena, neŋ i gésimiyi. Nuac qeri uŋanéŋ iwac siŋ nimmima ségiségi yanda wanʒua. Ni Uŋana iwac muru haimiwa inéŋ ic enia kekec solaŋa ʒéau énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Waŋu inéŋ tohalicya qahac, qac silacya qahac. Méŋnéŋ méŋ héna yandaiguc ac ewaya ménda nimmac. ");
INSERT INTO kgf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Uŋ kétéŋaguc imi ménda kumac. Kifa ʒéra bouc bouc wanʒac imi ménda hiwécgémac. Imuhuc wammanec kecma kekec solaŋa qindiŋima keŋu ogicogira wandacmac. ");
INSERT INTO kgf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Waŋu ic enia ieneŋ ewagina kewugina Yesuac qaraiguc korodacmu. ");
INSERT INTO kgf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Waŋu nalé imuaru ic méŋ tiliŋtiliŋ birianéŋ késayu kic hilic waŋu ara qahac kerec imi Yesuac muru wagic keŋgic. Waŋu Yesunéŋ mehiaru miyu ac ʒéma kiwa hima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Waŋu ic embac mocʒoŋ welicgéma ʒégic; Youmi Dawidiac ɋeli me deic? ");
INSERT INTO kgf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ʒégic Farisaio ic eneŋ ac imi nimma yomuhuc ʒégic; Uŋa biria ionac kuneŋgina Beelʒebul iminéŋ kuc ménda miyu uŋa biria nesimacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Waŋu Yesunéŋ niniŋgina niŋtegicma yomuhuc énézéma ʒéyec; Héŋgaleŋ ama areŋa yanda méŋac ic embachéranéŋ eŋaocnec héndéŋ amugic héŋgaleŋ ama areŋa yanda imi kisi wammac. Waŋu ama areŋa yanda me ama méŋac ic embachéranéŋ eŋaocnec héndéŋ amuma hia ménda naŋselimu. ");
INSERT INTO kgf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Biria miŋinanéŋ Biria miŋina elicgézaciguc ekaocnec téamuzaoc. Imuhuc waŋu iwac héŋgaleŋ ama areŋa yanda imi dimuhuc naŋselimac? ");
INSERT INTO kgf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Waŋu ni Beelʒebulnéŋ kuha néŋu uŋa biria elicgé énécmianʒuaiguc, naŋhécginanéŋ mérac kuhaiguc nesi énécmianʒu? Imuac bec eŋaoc niŋgésigési wammuac hezac. ");
INSERT INTO kgf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Waŋu Anutuac Uŋanéŋ kuha néŋu uŋa biria nesi énécmianʒuaiguc, Anutuac héŋgaleŋ ama areŋa yanda imi bec onac muru ha énécmizac. ");
INSERT INTO kgf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Méŋnéŋ méŋ walac ama miŋina selia ménda késa ɋatémaguc dimuhuc amayaiguc emma iwac iwawaiya wagicma kemmac? ");
INSERT INTO kgf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ic méŋ niguc ménda kecanʒac imi andianéŋ nuanʒac. Ic méŋ niguc mequtulaŋ ménda waŋanʒac imi héndéŋ qéndéŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Imuac énézéwa niŋgic, képésic hénia hénia ʒéma Anutu ʒébiri qébiri wammimia imi waiwaiyawac séc wammac, néŋ Uŋa Téréya ʒébiri qébiri wammimia imi waiwaiyawac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Méŋ Icac Naŋa ʒébiri mimaciguc képésicya imi waiwaiyawac séc. Waŋu méŋ Uŋa Téréya ʒésure wammimac imi képésicya imi deguc baeciguc me baec biaŋguc hahaya imuaru momacnec ménda waiwaiyawac séc. ");
INSERT INTO kgf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ini ic hésa méŋac hiabia ʒéma hélaya niŋac imuhucyanec hiabia ʒému. Waŋu ic hésa méŋac biria ʒéma hélaya niŋac imuhucyanec biria ʒému. Ic hésawac hénia imi imuac hélanéŋ ʒéauanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Qerigina igucnec qesalecgéma mayu kuaginanéŋ ʒéanʒu imuac niŋac qaté mokoleŋac ɋelihécgina ini némaciguc ac hiabia méŋ hia ʒému? ");
INSERT INTO kgf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ic hiabianéŋ qeriawac hofia igucnec iwawai hiabia wiriru éréanʒac. Waŋu ic birianéŋ qeriawac hofiyaiguc iwawai biriawac wiriru éréanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ʒéwa niŋgic gésigési nalé yandaiguc ac sicsaocya ʒéanʒu imuac hénia mocʒoŋ ʒéasaridacmu. ");
INSERT INTO kgf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Imuac niŋac geŋga acganéŋnec mesolaŋani géŋgéŋa wammac. Imuhucyanec geŋga acganéŋnec képésicgaguc ʒégéŋgéŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Imuhuc ʒéyu, Farisaio ic ʒéma héna acac kiwi ic tosara ieneŋ ac yomuhuc meleŋmigic; Kiwi ic nini guac murunec séséc méréra méŋ hémbiŋ ʒé wanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Imuhuc ʒégic melemma énézéyec; Hicŋisai biria téŋgéŋ ʒéma kaiseroac buŋa yominéŋ séséc mérérawac hémbiŋ ʒé ʒéwelec wanʒu. Waŋu asé kiwiac séséc tosara qahac, néŋ kua meme ic Yonawac sésécya sac mihicŋi énécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona imi siŋi kaiwe haréwéc konduŋ yaŋ tomeŋa qeriaiguc heyec, imuhucyanec icac naŋa imi siŋi kaiwe haréwéc baec omoŋaiguc hemac. ");
INSERT INTO kgf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Niniwe ic embac ieneŋ Yonawac ackuaʒéc nimma ewagina meleŋgic, néŋ méŋ Yona ogicma eŋeŋa wanʒac imi youmi namba ewagina ménda melenʒu. Imuac niŋac gésigési naléiguc Niniwe ic embac ieneŋ hicŋisai yomi iniguc namma hicŋisai yomuac képésic ginaguc ʒéénécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Baec waŋgoŋa Saut imuac embac garatanéŋ Solomonac niŋtegic qiŋtegic ac nimmaŋ ʒé baec tetecgia igucnec hayec, néŋ méŋ Solomon ogicʒac imi youmi namba gezacgina ménda qeanʒu. Imuac niŋac gésigési naléiguc embac garata iminéŋ hicŋisai yomi iniguc namma képésic ginaguc ʒéénécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Uŋa birianéŋ ic méŋac qeria igucnec éréma tachiarumaŋ ʒé baec kisiaiguc lelecgéma kemma hocbipiyec. ");
INSERT INTO kgf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Imuhuc wamma yomuhuc ʒéyec; Ama waima hayi imuhucgeŋ liliŋgéma kemmaŋ. Imuhuc ʒéma liliŋgéma kemma héŋu ama imi miŋina qahac qeusuŋ wamma meʒeriru eŋ naŋec. ");
INSERT INTO kgf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Imuhuc hémma kemma uŋa biria 7 eŋeya ogicma mocʒoŋ biriqiria wanʒu imi onagiru hama ama imuaru hiŋgacma tacyac waŋgic. Imuhuc waŋgic ic imuac kekecyawac tetecgia imi kekecya walac kerec imi ogicma mocʒoŋ biridacʒac. Haka silic imuhucyanec hicŋisai biria yomi onac muru hicŋi énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesunéŋ ac imi ic embac tuŋginaguc énézémanec naŋu neŋgoc munahéra ieneŋ ac ézéwiŋ ʒé hama séŋgaŋgeŋ naŋkecgic. ");
INSERT INTO kgf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Imuhuc waŋkecgic ic méŋnéŋ ézéma ʒéyec; Ninʒaŋ, neŋgoc munahécga ieneŋ giguc ac ʒéwiŋ ʒé séŋgaŋgeŋ nanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Imuhuc ʒéyu Yesunéŋ yomuhuc énézéyec; Méré méré eneŋ nuac neŋgoc munahécna wanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Imuhuc ʒéma méria suluyu tohotoho ichéra ionac muru keŋu ʒéyec; Inicgic, nuac neŋgoc dac munahécna imi youmi tacʒu. ");
INSERT INTO kgf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Méŋnéŋ méŋ Kurumeŋ Maŋgocna iwac ewa siŋ tohoma wamma mezac imi mia nuac neŋgoc nauŋna ʒéma dac muna wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ai meme imuaru Yesu ama igucnec mama ʒékéŋ ʒécgériaiguc kemma tarec. ");
INSERT INTO kgf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tackeru tocgégic imi eneŋ tuŋ yanda imuac niŋ Yesu eŋeyaoc imi ʒéiciguc emma tarec, néŋ ic embac tuŋginaguc imi mocʒoŋ ʒékéŋ giŋgiŋa sakasaciguc naŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Naŋkecgic inéŋ qeqaiŋ aciguc ackuaʒéc sasala énézéma ʒéyec; Gezac haigic! Héihimic ic méŋnéŋ iwawai gocmia qesamaŋ ʒé aiiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Qesamanec keŋu tosara imi héna giŋgiŋaiguc mayec. Mayu nei eneŋ hama héima ɋécgédacgic. ");
INSERT INTO kgf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Waŋu tosara imi hoc sisic, baera haŋqeqeya imuaru mama héiyec. Waŋu baec dépaŋa imi komora waŋu qérawia imi focdac néʒéŋgéma éréyec. ");
INSERT INTO kgf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Néŋ ʒaligina ménda hiŋgac yacgéyu kaiwenéŋ éréma qeyu uririma humudarec. ");
INSERT INTO kgf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Waŋu tosara imi héféréréc qeriaiguc mama héiyu héférérécnéŋ yandima hédacgéyec ");
INSERT INTO kgf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Waŋu tosara imi baec hiabiaiguc mama héima ura méŋnéŋ 100, méŋnéŋ 60, méŋnéŋ 30 imuac séc héla sasala haidacgic. ");
INSERT INTO kgf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Méŋ gezawagucnéŋ ac yomi nimmac. ");
INSERT INTO kgf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Waŋu tohotoho ichéra eneŋ hosuraiguc kemma qesimigic; Némac niŋac ac qeqaiŋiguc haima énézékecʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ʒégic melemma énézéyec; Kurumeŋac héŋgaleŋ amawac niniŋ saŋa imi onac muru énécmimia waŋec, néŋ ionac muru imi qahac. ");
INSERT INTO kgf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ic mérénéŋ hemizac imi toroqema miyu ogicma hemimac. Waŋu ic mérénéŋ ménda hemizaciguc imi iwawai éréhécdac hemizac imi acguc momacnec wagiru qahac wandacmac. ");
INSERT INTO kgf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ieneŋ kicgina hibipima héŋanʒu, néŋ ménda héŋtegicanʒu. Waŋu gezacginanéŋ ac niŋanʒu, néŋ ménda niŋtegicanʒu. Hénia imuac niŋ qeqaiŋ aciguc énézéanʒua. ");
INSERT INTO kgf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yesaianéŋ biaŋac ara ʒéyec imuac héla imi ionac muru héizac. Ʒéyecnéŋ; Gezacginanéŋ nimmu, néŋ méndadac niŋtegicmu. Kic hima hémmu, néŋ méndadac héŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ic embac yomi onac ewa qerigina imi mehéŋgé énécmimia waŋu, gezacginanéŋ niŋbipima kicgina héméŋʒaligic. Imi mia kicginanéŋ héŋtegicma gezacginanéŋ niŋtegicma ewa qeriginanéŋ niŋasarima liliŋgégic mehiaru énécmiwi niŋac imuhuc waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Eneŋ imi kicginanéŋ héŋtegicma gezacginanéŋ nintegicanʒu imuac kic gezacgina imi mériaŋaguc. ");
INSERT INTO kgf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ni hélacnec énézéwa niŋgic; Kuameme ic ʒéma ic embac solaŋa sasalanéŋ ini hénʒu imuac hémbiŋ ʒé mambéc kecaŋgic, néŋ ménda héŋgic. Waŋu ini ninʒu imuac nimbiŋ ʒé mambéc kecaŋgic, néŋ ménda niŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Imuac bec héihimic icac muru qeqaiŋ ac imuac hénia ʒéwa niŋasarimu. ");
INSERT INTO kgf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Méŋnéŋ méŋ héŋgaleŋ ama areŋa yanda imuac ackuaʒéc nimmaguc ménda niŋasariyu iwac ewa qeriaiguc qesayu hezac imi Biria miŋinanéŋ hama paktak wagicma kemmac. Ic imuhucya imi iwawai gocmia héna giŋgiŋaiguc mama héianʒac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Waŋu gocmia hoc siraiguc qesayu mama héiyec ic imuhucyanéŋ ackuaʒéc nimma ségiségi wamma ewa qeriaiguc focdac késama kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Waŋu ewa qeriaiguc gétéya ménda késayacgéyu nalé hotoŋanec naŋselimac, néŋ ackuaʒéc imuac niŋac ʒérabéra me ununesi hicŋiyu focdac maqeanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Waŋu qesayu héféréréc qeriaiguc héiyec ic imuhucyanéŋ ackuaʒéc niŋanʒac, néŋ baecac ewa goro ʒéma hinawac ikocnéŋ héʒicgéyu gorosoŋa waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Waŋu qesayu baec halécyaguc mayec ic imuhucyanéŋ ackuaʒéc nimma hénia niŋasariyu méŋac héla 100, méŋac 60, waŋu méŋac 30 imuhuc haianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Waŋu Yesunéŋ qeqaiŋ ac méŋ yomuhuc énézéyec; Kurumeŋac héŋgaleŋ ama areŋa yanda imi ic méŋnéŋ aiyaiguc iwawai gocmia hiabia qesayec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Waŋu ic embac héra mocʒoŋ gaugina hedacgic haʒéranéŋ hama neneac gocmia qeriaiguc ɋézézac gocmia qesama néŋgacma keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Waŋu gocmia imi yandima héla haiyu duŋa ɋézézac imi acguc wininiyec. ");
INSERT INTO kgf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Waŋu ama miŋinawac weleŋ qeqehéra eneŋ imi hémma miŋgina ézéma ʒégic; Miŋ Kewunina gi aigaiguc gocmia hiabiawac qesanec, néŋ ɋézézac imi dimuacnec? ");
INSERT INTO kgf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Qesimigic melemma énézéyec; Haʒécna méŋnéŋ imuhuc waŋec. Waŋu weleŋ qeqehéra ieneŋ qesima ʒégic; Nini kemma qéʒima mutulaŋgéwiŋ niŋac waŋgénʒac? ");
INSERT INTO kgf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ʒégic, qahac ʒéma ʒéyec; Imuhuc waŋkecma padi imi momacnec hérégic éréwac niŋac. ");
INSERT INTO kgf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Imuac niŋac ini waigic momacnec yandima yacmu. Waŋu héla meme naléyaiguc héla meme ic énézéwa hama walac ɋézézac imi qéʒima gericiguc omu niŋac dérécgému. Waŋu neneya imi tocgéma hama hofinaiguc haidacmu. ");
INSERT INTO kgf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Waŋu qeqaiŋ ac méŋ yomuhuc énézéma ʒéyec; Kurumeŋac héŋgaleŋ ama areŋa yanda imi ic méŋnéŋ saiwa gocmia méŋ mema aiyaiguc himirec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Imi iwawai gocmia ionac komoragina téŋgéŋ. Waŋu yandimac imuaru aiiguc ichésa tosara onogicma kuneŋ yanda waŋanʒac. Waŋu sawawac nei eneŋ hama hawaiguc haecgina haima kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Waŋu qeqaiŋ ac méŋ muŋgucnec énézéma ʒéyec. Kurumeŋac héŋgaleŋ ama areŋa yanda imi yis embac méŋnéŋ mema padi uha sasala imuac qeriaiguc haima lelecgéyu tackecma mocʒoŋ sécgédaru yandianʒac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesunéŋ ackuaʒéc imi mocʒoŋ qeqaiŋ acguc qemanec ic embac tuŋaguc énézédarec. Qeqaiŋ ac qahac méŋ ménda énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Imuhuc waŋu Anutunéŋ kua meme icyawac murunec ac méŋ yomuhuc ʒéyec imi, héla héiyec; Ni kuana auma qeqaiŋ ac ʒémaŋ. Baec kurumeŋ ʒéyu hicŋiyec imuarunec sasaŋgiaiguc hema éréyec imuac mia ʒéaumaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Waŋu Yesunéŋ ic embac tuŋaguc imi méli énécmima ama qeriaiguc eŋec. Eŋu tohotoho ichéra ieneŋ iwac muru hama ʒégic; Ɋézézac aiiguc éréyec qeqaiŋ ac imuac hénia ʒéasarina ninni. ");
INSERT INTO kgf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ʒégic melemma énézéyec; Iwawai gocmia hiabia qesayec imi Icac Naŋa. ");
INSERT INTO kgf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ai imi baera baera. Ic gocmia hiabia imi kurumeŋac héŋgaleŋ ama areŋa yanda imuac naŋhéra. Waŋu ɋézézac imi Biria miŋinawac naŋhéra. ");
INSERT INTO kgf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Waŋu iwawai biria qesayec imi Biria miŋina imi mia. Hélawac ai yawuŋ imi mia baec yomuac nalé tetecgia. Waŋu héla meme ic imi kua meme uŋa eneŋ. ");
INSERT INTO kgf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Waŋu ɋézézac mutulaŋgéma gericiguc oanʒu ésécnec baec yomuac nalé tetecgiaiguc haka imuhucya hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Icac Naŋanéŋ kua meme uŋahéra méli énécmiyu hama héŋgaleŋ ama areŋa yanda igucnec iwawai képésic mihicŋianʒu imi ʒéma ic héna ac logianʒu imi mocʒoŋ gési énécmidacmu. ");
INSERT INTO kgf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Gési énécmidacma geric yanda qeriaiguc giligic hiŋgacdacmu. Hiŋgacma imuaru ʒésiac wamma ʒécgina aric aric kimu. ");
INSERT INTO kgf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Waŋu ic solaŋanéŋ Maŋgoc ginawac héŋgaleŋ ama areŋa yandaiguc kaiwe ésécnec asarima kecmac. Ic gezawagucnéŋ, ac yomi nimmac. ");
INSERT INTO kgf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kurumeŋac héŋgaleŋ ama areŋa yanda imi iwawai eeyaguc ai qeriaiguc saŋgima heyu ic méŋnéŋ mihicŋima muŋguc musaŋgéma ségiségi wamma kemma iwawai hemimia imi mocʒoŋ haidacma soukiwa mihicŋima baec imi boŋa meyec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Waŋu muŋguc méŋ imi yomuhuc; Kurumeŋac héŋgaleŋ ama areŋa yanda imi nénnagémba ic méŋnéŋ hoc welic welicgiawac hohoc ai meanʒac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Keŋkecma méŋ boŋa eŋeŋa sécya mihicŋiyec imuaru kemma iwawai hemiyec séc mocʒoŋ haidacma soukiwa mihicŋima iwawai imi boŋ meyec. ");
INSERT INTO kgf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Waŋu muŋguc méŋ imi yomuhuc; Kurumeŋac héŋgaleŋ ama areŋa yanda imi ufic konduŋiguc giligic hiŋgacma lambéc hénia hénia énépésiyec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Waŋu ufic imi kuaya qeyu hérégic konduŋ élélahu eŋu mama tacma hiabia imi neŋgeŋiguc tigic hiŋgarec, néŋ biria imi giligic keŋec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Baec yomuac nalé tetecgiaiguc haka silic imuhucyanéŋ hicŋimac. Kua meme uŋa ieneŋ hama biria meme ic imi ic solaŋa ionac sucgina igucnec gési énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Gésiénécmima geric yandaiguc giligic hiŋgacma imuaru mia ʒésiac wamma ʒécgina aric aric kimu. ");
INSERT INTO kgf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Imuhuc ʒéma qesiénécmiyec; Ini ac imi mocʒoŋ niŋasaridacʒu? Ʒéyu ʒégic; Oo Miŋ Kewunina. ");
INSERT INTO kgf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Waŋu énézéma ʒéyec; Imuac bec héna acac kiwi icya icya kurumeŋ amawac hénia ku énécmiyu tohotoho ic héla wamma kecʒu imi ama miŋina méŋ iwawai eeyaguc hénia hénia ɋelia ʒéma wahala momacnec hofi amaya igucnec mema maanʒac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesunéŋ qeqaiŋ ac imuhuc ʒédaru tecgéyu imuacnec waima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Waŋu eŋeya tauŋiguc hama tocgotocgo amaginaiguc ackuaʒéc hénima ku énécmiyec. Kuénécmiyu welicgéma qesiamuma ʒégic; Ic imi niŋtegic qiŋtegic ʒéma kuc imuhucya yomi dimuacnec meyec? ");
INSERT INTO kgf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Waŋu ic yomuac hénia hiadac nindacʒiŋ. Imi kamundawac naŋa, neŋgocyawac qara Maria, waŋu munahéra, Yakobo, Yosefe, Simon ʒéma Yuda. ");
INSERT INTO kgf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nauŋhéra imi neŋaŋguc ménda kecanʒiŋ? Waŋu ic yomi niniŋ ʒéma kuc imuhucya dimuacnec meyec? ");
INSERT INTO kgf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Waŋu niniŋ imuhucyanéŋ batucgé énécmiyu ninʒéŋgé mimuac séc qahac waŋec. Waŋu Yesunéŋ yomuhuc ʒéma énézéyec; Anutuac tiliŋ tiliŋ ic méŋnéŋ eŋeya ama areŋaiguc ʒéma taséhéra sucginaiguc sac imi eebipiyaguc ménda waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Waŋu ninʒéŋ ninʒéŋgina qahac imuac niŋac ama areŋ imuaru kiwi méréra kuhaguc sasala ménda meénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nalé imuaru baec galeŋ Herodenéŋ Yesuac buŋa suruc imi niŋec. ");
INSERT INTO kgf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Nimma weleŋ qeqehéra énézéma ʒéyec; Ic imi doku naec haka ic Yohane. Inéŋ mia humuc igucnec ɋelima yacʒac! Imuac niŋac kuha sasala imuhucyanéŋ iwac muru ai mezac. ");
INSERT INTO kgf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Becnec Herodenéŋ munaya Filipoac iniŋa qawéra Herodiawac niŋac wamma Yohane késa ɋatéma hésa amaiguc oporu tarec. ");
INSERT INTO kgf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hénia imi Yohanenéŋ, Gi embac qawécga menec imi héna qahac, imuhuc ʒéma ac ʒémiaŋec imuac niŋac imuhuc wammiyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nalé imuaru Herodenéŋ Yohane qehumumaŋ ʒé waŋec, néŋ ic embac eneŋ iwac niŋgic Anutuac kua meme ic waŋu ionac niŋac niŋyéwérima waiyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Waŋu Herodeac hicŋhicŋi naléya hayu neʒéléléŋ aria mekecgic Herodiawac béraranéŋ sucginaiguc legic hiriyu Herodenéŋ hémma ségiségi waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ségiségi wamma némac iwawai niŋac qesiyu hia midacmaŋ ʒéma ʒéseliyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Waŋu neŋgocyanéŋ ʒéqindiŋi wammiyu yomuhuc ézéyec; Doku naec haka ic Yohaneac orucya youmi ʒéiciguc haima nénna. ");
INSERT INTO kgf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Imuhuc ʒéyu ic kewu imi nimma ewa biric waŋec. Waŋu ic embac i guc momacnec tacgic ionac ʒéma ac ʒéselima ʒéyec imuac wamma qesiyec séc wammimu niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Énézéma ichéra méli énécmiyu Yohane hésa amaiguc taru déméŋa qericgic. ");
INSERT INTO kgf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Qericma oruha imi ʒéiciguc haima mehama embac seraŋa iwac migic duŋa neŋgocyawac mekeŋ miyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Waŋu Yohaneac tohotoho ichéra eneŋ hama qamora mekeŋ téŋgéma kemma Yesu ézégic. ");
INSERT INTO kgf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ʒégic nimma eŋeyanec ʒéiciguc emma baec kisiaiguc keŋec. Waŋu ic embac tuŋagucnéŋ imuhuc nimma tauŋ igucnec séc méndacmima baec héna keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Waŋu Yesunéŋ hama ic embac tuŋaguc imi inicma ionac niŋ ewa biric wamma yaŋ hafiginaguc imi méhiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ama mari waŋu tohotoho ichéra ieneŋ hama ʒégic; Yomi imi baec kisia, waŋu nalé bec tecgézac. Imuac ic embac méli énécmina ama areŋiguc kemma eŋaoc nenegina boŋ memu. ");
INSERT INTO kgf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Imuhuc ʒégic énézéyec; Kemmu niŋac ménda ninʒua. Eŋaoc énécmigic negic. ");
INSERT INTO kgf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Imuhuc énézéyu ézégic; Nini you imi saméŋ méra méŋ ʒéma lambéc éréhéc sac he nénécmizac. ");
INSERT INTO kgf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Imuhuc ʒégic ʒéyec; Imi mema you nuac muru hagic. ");
INSERT INTO kgf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Waŋu ic embac imi ɋézézaciguc mama tacmu niŋ énézéyec. Waŋu saméŋ méra méŋ imi ʒéma lambéc éréhéc imi mema kiwa kurumeŋiguc hiyu eŋu mériaŋ ac ʒéyec. Ʒéyu tecgéyu saméŋ imi mésémma tohotoho ichéra énécmiyu duŋa ieneŋ mema ic embac énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Waŋu ic embac mocʒoŋ yanda negic sécgé énécmidarec. Waŋu Yesuac tohotoho ichéra ieneŋ saméŋ bororoŋa waigic heyec imi tocgégic neŋgeŋ 12 kuagina qedarec. ");
INSERT INTO kgf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Saméŋ negic imi embac ʒéma nambérac imi ménda olomma ic sac oloŋgic ʒaŋgégina 5,000 ʒézéya séc waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Imuhuc waŋgic tecgéyu nalé imuarunec focdac Yesunéŋ ic embac onopocma naŋunec tohotoho ichéra ʒéiciguc emma walac walac ʒékéŋ néwéc kemmu niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Waŋu inéŋ ic embac onoporu kendacgicguc ʒéwelec wammaŋ ʒé eŋeyanec baec boŋayaiguc eŋec. Emma keru ama siŋiyu i eŋeyanec sac imuaru kerec. ");
INSERT INTO kgf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waŋu ʒéic imi bec baec ʒécgéria waima lakec kemma ʒékéŋ namuŋaiguc keŋkeru luhucnéŋ wéségina igucnec hayu konduŋ temboŋa yaru ai yanda mekecgic. ");
INSERT INTO kgf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ama ewia 3 kilok ʒéma 6 kilok sura imuaru Yesu imi ʒékéŋ qahaiguc tima tima ionac muru hayec. ");
INSERT INTO kgf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hayu tohotoho ichéra ieneŋ héŋgic bacgina ʒaʒagiyu ʒénéŋgina hiriyu kucnec qacma ʒégic; Kuwic erimi! ");
INSERT INTO kgf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Qacgic Yesu focnec énézéma ʒéyec; Bacgina ménda yandiyu! Yomi nenaoc, ʒénéŋgina ménda hiriyu. ");
INSERT INTO kgf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ʒéyu Peteronéŋ melemma ʒéyec; Miŋ kewuna geŋgaoc wanʒaŋiguc ʒéna doku ʒékéŋ qahaiguc guac hawa. ");
INSERT INTO kgf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Imuhuc qesiyu hia hana ʒéyec. Ʒéyu Peteronéŋ ʒéicigunec mama doku qahaiguc tima tima Yesuac murugeŋ keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Keŋu luhuc yandanéŋ hayu hémma bawa yandiyu hénima hiŋgacma qarec; Miŋ kewuna hama népésina! ");
INSERT INTO kgf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ʒéyu Yesunéŋ focnec méria suluma késayu éréyu ʒéyec; Ninʒéŋ ninʒéŋga komocdiadac! Némac niŋac ewa éréhéc wanʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Imuhuc ʒéma késayu ekawu ʒéiciguc eŋic luhuc imi néŋ qeyec. ");
INSERT INTO kgf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Waŋu ʒéiciguc tacgic eneŋ sicgémima ʒégic; Gi hélacnec Anutuac Naŋa. ");
INSERT INTO kgf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Waŋu ʒékéŋ handi handi qericma Genesarete baeciguc keremma ʒéic igucnec magic. ");
INSERT INTO kgf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Magic ama areŋ imuac miŋina eneŋ Yesu héŋtegicma ac haigic ama areŋ lelec lelec tacgic séc kendaru ic embac eneŋ tosara yaŋ hafiginaguc imi mocʒoŋ onagicma iwac muru hagic. ");
INSERT INTO kgf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hama Yesunéŋ niŋénécmiyu yaŋhafi ginaguc eneŋ iwac malekuya susuriadac imi eŋdac osimu niŋac ʒéwelec wammigic. Waŋu késagic séc hiarudacgic. ");
INSERT INTO kgf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Waŋu duŋa Yerusalemnec Farisaio ic ʒéma héna acac kiwi ic eneŋ Yesuac muru hama yomuhuc qesimigic; ");
INSERT INTO kgf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Némac niŋac tohotoho ichécga eneŋ yanda hécnina ionac haka silic imi logima méragina ménda ʒuacma nene nezu? ");
INSERT INTO kgf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ʒégic Yesunéŋ melemma énézéyec; Waŋu ini acguc némac niŋac eŋaŋ haka silic niŋac wamma Anutuac héna ac logianʒu? ");
INSERT INTO kgf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anutunéŋ yomuhuc ʒéyec; Neŋgoc maŋgocga eegira héiwésémaŋ. Waŋu mérénéŋ méŋ neŋgoc me maŋgocyawac ʒébiri mimac imi humucac buŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Néŋ ini yomuhuc ʒéanʒu; Méŋnéŋ méŋ neŋgoc me maŋgocya ézéma iwawai hezac imi guac gémbinec naŋgé gémbacnec, néŋ imi Anutuac buŋa qemimia, imuhuc ʒémuiguc ");
INSERT INTO kgf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","iwawai iminéŋ neŋgoc maŋgocya eegira efima ménda héiyu hia wammac ʒéma eŋaŋ haka silic imuac mia wamma Anutuac ackuaʒéc imi qiʒiʒiŋgégic ʒécgériaiguc keŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ini ic ikora! Yesaianéŋ onac biaŋac ara yomuhuc ʒéyec imi hélacnec; ");
INSERT INTO kgf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ic embac youmi kua taséginanéŋ sac mepési néŋanʒu. Waŋu qeriginanéŋ néŋgac némma lakec hezac. ");
INSERT INTO kgf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ic eŋaŋ pakeŋ ac ʒéma héna ac ku énécmima ni imi héla qahac eŋ mepési néŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Waŋu Yesunéŋ ic embac unuruyu hosuru hagic énézéma ʒéyec; Gezacginanéŋ nimma niŋasarigic. ");
INSERT INTO kgf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Iwawai ic méŋac kuaya igucnec hiŋgacanʒac iminéŋ ménda meʒapi qemianʒac, néŋ iwawai kuaya igucnec maanʒac iminéŋ meʒapi qemianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Waŋu tohotoho ichéra ieneŋ hosuru hama qesimigic; Acganéŋ Farisaio ic qeri yéwéc mihicŋi énécmizac imi nintegicʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Imuhuc ʒégic acgina melemma ʒéyec; Ic hésa kurumeŋ Maŋgocnanéŋ ménda himirec imi mocʒoŋ gété ʒaliginaguc qéʒidacmac. ");
INSERT INTO kgf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Waigic siŋginawac waŋgic. Ic imuhucya imi galeŋ kicgina hilic hilicgia. Ic méŋ kiwa hilic hilicgianéŋ kichilic méŋac galeŋgéma wagiru kemmaoc imi, ekawu momacnec baec séséŋiguc hiŋgacmaoc. ");
INSERT INTO kgf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Waŋu Peteronéŋ ara melemma ʒéyec; Qeqaiŋ ac imi nonac ʒéasari nénécmina ninni. ");
INSERT INTO kgf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ʒéyu Yesunéŋ yomuhuc ʒéyec; Ini niŋtegic qiŋtegicgina qahacnec kecʒu? ");
INSERT INTO kgf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Iwawai ic kua igucnec tomeŋiguc hiŋgacanʒac imi mocʒoŋ muŋguc hénaya igucnec maanʒac imi ini ménda héŋtegicʒu? ");
INSERT INTO kgf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Waŋu iwawai kua igucnec éréanʒac imi ewa qeria igucnec éréanʒac. Waŋu iminéŋ mia ic imi meʒapi qemianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ewa qerigina igucnec éréanʒac imi yomuhuc; Niniŋ biria, ic qeqe, kaisero, kaisero ewa ewa, seŋkowu, héipuc ac ikora, ʒébiri qébiri. ");
INSERT INTO kgf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iwawai imuhucyanéŋ ic imi meʒapi qemianʒac. Waŋu méra ménda ʒuacma nene nenia iminéŋ ic imi ménda meʒapi qemianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Waŋu Yesunéŋ baec imi waima Tiro ʒéma Sidon baeciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Gezac haigic, Kanaannec embac méŋ baec suc imuaru kecaŋec inéŋ Yesuac muru hama qacma yomuhuc ʒéyec; Miŋ Kewu, Dawidiac naŋa, nuac niŋ ewa biric wanna. Béracna imi uŋa birianéŋ gelec malec qahac lafeŋgé mianʒac. ");
INSERT INTO kgf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Imuhuc ʒéyu, Yesunéŋ nimma ac méŋ ménda meleŋec. Imuac tohotoho ichéra ieneŋ iwac hama hinocgémima ʒégic; Embac imi andéninaiguc qacmanec hazac imuac mélina keŋu. ");
INSERT INTO kgf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ʒégic melemma ʒéyec; Ni imi Israel amawac rama sohogic ionac sac méli néŋu hayi. ");
INSERT INTO kgf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Imuhuc ʒéyu embac imi haréma wésiaiguc sicgémima ʒéyec; Miŋ Kewu, méra nénna. ");
INSERT INTO kgf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Waŋu Yesunéŋ ara melemma ʒéyec; Nambérac ionac saméŋ mema kazu énécmimia imi hiabia qahac. ");
INSERT INTO kgf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Imuhuc ʒéyu embac iminéŋ yomuhuc ʒéyec; Oo, Miŋ Kewu imi hélacnec, néŋ kazu acguc nene bororoŋa miŋhécgina ionac ʒae igucnec mayu neanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Imuhuc ʒéyu, Yesunéŋ ézéma ʒéyec; Owec embac, gi ninʒéŋ ninʒéŋga kuneŋ yanda. Ʒéwelec wanʒaŋ séc hicŋigémac. Imuhuc ʒéyu nalé imuarunec dindiŋa bérara imi hiaruyec. ");
INSERT INTO kgf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesunéŋ baec imi waima Galilaia ʒékéŋ giŋgiŋanec kemma baec boŋaya méŋiguc emma tarec. ");
INSERT INTO kgf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Taru ic embac tuŋa tuŋanéŋ ʒeke puriŋa, kic hilic, acgina qahac, héna méragina biria, ʒéma tosara kileŋ onagicma haréma Yesuac wésiaiguc onopocgic hegic. Waŋu inéŋ mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ic acgina qahac imi ac ʒégic. Ʒeke puriŋa imi hiarugic. Hénagina biria imi hiaruma keŋha waŋgic. Kic hilic imi kicgina hima héŋgic. Waŋu ic embac tuŋaguc eneŋ haka imuhuc hémma welicgéma Israelac Anutu mepésigic. ");
INSERT INTO kgf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesunéŋ tohotoho ichéra unuruyu hosuru hagic énézéma ʒéyec; Ni ic embac tuŋ yomi onac ewa biric wanʒua. Ieneŋ niguc toroqema kecgic bec ai meme haréwéc waŋu iwawai neniawac méŋ ménda he énécmizac. Imuac yaka niŋac humugicguc eŋnec méli énécmiwa kemmu niŋac ménda wanʒua. Keŋkecma hénaiguc ɋiritic unuwac niŋac. ");
INSERT INTO kgf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ʒéyu tohotoho ichéra ieneŋ ara melemma ʒégic; Baec kisia yomuhucgeŋ saméŋ sasala imuhucya dimuacnec mihicŋima ic embac tuŋ yanda yomuhucya hia gumu énécmiwiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ʒégic qesiénécmima ʒéyec; Onac muru saméŋ dahec he énécmizac? Ʒéyu melemma ʒégic; Saméŋ 7 ʒéma lambéc éréhécdac sac he nénécmizac. ");
INSERT INTO kgf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Imuhuc ʒégic ic embac tuŋa imi baeciguc mama tacmu niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Imuhuc énézéma saméŋ 7 imi ʒéma lambéc imi mema ewa hia ac ʒéyu tecgéyu kuma tohotoho ichéra énécmiyu duŋa ieneŋ mema ic embac énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ic embac mocʒoŋ negic sécgé énécmidarec. Waŋu nene bororoŋa waigic tarec imi tocgégic neŋgeŋ yanda 7 kuagina qedarec. ");
INSERT INTO kgf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ic nene negic ionac ʒaŋgégina imi 4,000. Embac ʒéma nambérac imi ménda oloŋ énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesunéŋ ic embac méli énécmiyu kendacgic ʒéiciguc emma Magadan baeciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisaio ic ʒéma Sadukaio ic ieneŋ hama Yesunéŋ séséc kurumeŋ igucnec hahaya méŋ meyu hémbiŋ ʒé batucgéma qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Qesigic melemma ʒéyec; Ama mari waŋu kurumeŋ pésigiyu hémma kurumeŋ pésigizac imuac oraŋguc kaiwe qemac ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Waŋu siŋunec yacma héŋgic kurumeŋ pésic pésic wamma hosusunéŋ neʒicgéyu, kia kimac ʒéanʒu. Kaiwe kiwa imuhuc héŋtegicma hélacnec ʒétecgéanʒu, néŋ nalé yomuac séséc imi hia ménda niŋtegicanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hicŋisai biria ʒéma kaiseroya imuhucyanéŋ séséc icnéŋ ménda memeya imuhucyawac hémbiŋ ʒé waŋanʒu. Waŋu ionac séséc imi tosara qahac, néŋ Anutuac tiliŋ tiliŋ ic Yonawac séséc imi sac meyu hémmu. Yesu imi imuhuc ʒéma wai énécmima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kemma tohotoho ichéra iniguc ʒékéŋ néwéc keŋgic. Waŋu tohotoho ichéra ieneŋ eluŋ unuyu saméŋ méŋ ménda mema keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Waŋu Yesunéŋ yomuhuc énézéyec; Ini Farisaio ic ʒéma Sadukaio ic ionac yis niŋac técgina nimma galeŋ memu. ");
INSERT INTO kgf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Imuhuc ʒéyu sucginaiguc yomuhuc niŋgésima eminiŋgic; Saméŋ ménda mema haziŋ imuac niŋ imuhuc ʒézac. ");
INSERT INTO kgf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesunéŋ hénia niŋasarima yomuhuc ʒéma énézéyec; Ninʒéŋ ninʒéŋgina komocdiadac, saméŋ ménda mema hazu imuac némac niŋac ʒé eminiŋ waŋkecʒu? ");
INSERT INTO kgf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Saméŋ 5 imi ic 5,000 sécgé énécmiyuguc nene bororoŋa tocgégic neŋgeŋ dahec kuagina qedarec imi ini méndagucnec niŋasarizu? Waŋu némac niŋac méndadac niŋɋelizu? ");
INSERT INTO kgf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Waŋu saméŋ 7 imi ic 4,000 sécgé énécmiyuguc neŋgeŋ dahec metocgégic? ");
INSERT INTO kgf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Saméŋ niŋ ménda ʒézua, néŋ Farisaio ic ʒéma Sadukaio ic ionac yis niŋac galeŋ memu niŋac ʒézua imi némac niŋ ménda niŋasarizu? ");
INSERT INTO kgf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Imuhuc ʒéyu yis saméŋiguc haianʒu imuac galeŋ memu niŋ ménda ʒéyec, néŋ Farisaio ic ʒéma Sadukaio ic ionac pakeŋ ac niŋac imuhuc ʒéyec imi niŋasarigic. ");
INSERT INTO kgf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu Kaisarea Filipi baec tasiaiguc haréma tohotoho ichéra qesiénécmima ʒéyec; Ic embac ieneŋ Icac Naŋawac méré ʒéanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Qesiénécmiyu melemma ʒégic; Tosara imi doku naec haka ic Yohane ʒéanʒu, tosara imi Elia, Tosaranéŋ Yeremia me Anutuac tiliŋ tiliŋ ic ionarunec méŋ ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Imuhuc ʒégic qesiénécmima ʒéyec; Waŋu eŋaoc, nuac niŋac méré ʒénéŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Imuhuc qesiénécmiyu Simon Peteronéŋ ʒéyec; Gi imi Kristo, Anutu kekecyaguc iwac Naŋa. ");
INSERT INTO kgf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Yohaneac naŋa Simon, gi imi mériaŋgaguc! Ʒézaŋ imi séwi ʒéma sac igucnec hahaya qahac, néŋ kurumeŋ Maŋgocnanéŋ ʒéhicŋi génʒac. ");
INSERT INTO kgf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Imuac gézéwa niŋna, gi imi Petero waŋu ʒamanʒiŋ imuac qahaiguc hénaoriŋna meyacgémaŋ. Waŋu humumia ionac baec dumuŋa imuac kuhanéŋ méndagucnec onogicmac. ");
INSERT INTO kgf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Waŋu ni kurumeŋac héŋgaleŋ amawac nagu auauyawac kuha imi gi gémmaŋ. Némac iwawai baeciguc ʒikina kurumeŋiguc momacnec ʒikiʒikia wammac. Waŋu némac iwawai baeciguc hulacna kurumeŋiguc momacnec hulachulara wammac. ");
INSERT INTO kgf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Imuhuc ʒéma eŋeyaoc Kristo wanʒac imi méŋac méŋ ménda énézému niŋac tohotoho ichéra ʒéseli énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nalé imuaru hénima i Yerusalem keŋu ic kuneŋ ʒéma hofac oo ic kiwahécgina ʒéma héna acac kiwi ic ionac méraiguc emma qenʒeŋ manʒeŋ sasala mihicŋiyu qegic humuyu ai meme haréwéc waŋu humuc igucnec ɋelima yacmacac hezac imi tohotoho ichéra ʒéasari énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Imuhuc énézéyu Peteronéŋ wagicma qiʒiʒiŋgéma kemma ac yomuhuc ʒémiyec; Miŋ kewuna, goiga héina, haka imuhucya méndagucnec hicŋigémmac. ");
INSERT INTO kgf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Imuhuc ʒéyu Yesu imi liliŋgéma Petero ézéyec; Biria miŋina, andénaiguc kemma nanna. Gi imi tisuqisurac ɋaméŋ, nuac hénana héʒicgé nénʒaŋ; Gi imi Anutuac ewa siŋ ménda méndacma ic onac ewa siŋ méndacʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Imuhuc ʒéma duŋa tohotoho ichéra yomuhuc énézéyec; Ic méŋnéŋ ni méndac némmaŋ ʒé eŋeya qaecgé amuma eŋeya ic héŋgeŋa wéndaraya huama méndac némmac. ");
INSERT INTO kgf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ic méŋ kekecya aŋgétiyu sohomac, néŋ nuac niŋ wamma kekecya waimac imi mihicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ic méŋnéŋ baecac iwawai momac yanda aŋgétiyuguc duŋa kekecya sohomac imi némacnéŋ iwac muru hiabia wammac? Me némacnéŋ kekecyawac kitiwa hia kumacac séc wammac? ");
INSERT INTO kgf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Icac Naŋa imi Maŋgocyawac edamuiguc kua meme uŋahéra iniguc hama wawaŋ memeginawac séc kitic ku énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Imuac hélacnec énézézua, yomi nanʒu onac murunec tosara eneŋ ménda humugicnec Icac Naŋa imi Ic Kewu qac buŋayaguc hamac. ");
INSERT INTO kgf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ai meme 6 tecgéyu Yesunéŋ Petero, Yakobo ʒéma Yakoboac munia Yohane onagiru baec boŋaiguc eŋacnec eŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Waŋu kicginaiguc tanera méŋ waŋec. Kic ségéria imi kaiwe ésécnec asariyu, séwi usuya imi asac mararaŋ yanda ésécnec waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Waŋu ninʒu, Mose ʒéma Elia hicŋi énécmima Yesuguc ac waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peteronéŋ haka imi hémma Yesu yomuhuc ézéyec; Miŋ Kewunina, neŋaŋ you kecʒiŋ imi nimba hiabia wanʒac. Siŋganéŋ imuac waŋu hali haréwéc meni, méŋ guac, méŋ Moseac, méŋ Eliawac wammac. ");
INSERT INTO kgf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Imuhuc ʒémanec naŋu, ninʒu, hosusu asahagucnéŋ hoturu énécmiyec. Waŋu ninʒu, ewa méŋ hosusu igucnec yomuhuc ʒéyec; Youmi imi nena Naŋ sorocna. Iwac niŋ ségiségi yanda wanʒua. Imuac ara niŋtoho wammu. ");
INSERT INTO kgf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tohotoho ichéra ieneŋ imuhuc nimma bacgina kuneŋ yanda yandiyu baeciguc mama sicgéma kicgina musaŋgéma hegic. ");
INSERT INTO kgf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Waŋu Yesunéŋ hosucginu hama onosima ʒéyec; Yacgic, bacgina ménda yandiyu. ");
INSERT INTO kgf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Imuhuc ʒéyu kicgina hima meyacma héŋgic méŋ qahac, néŋ Yesunéŋ sac naŋu héŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Boŋa igucnec mawiŋ ʒé mama Yesunéŋ ʒéseli énécmima ʒéyec; Haka deguc hénʒu imi ménda énézégicnec keŋkecma Icac Naŋa humuc igucnec yacmac. ");
INSERT INTO kgf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ʒéyu tohotoho ichéra ieneŋ qesimima ʒégic; Imuhuc waŋu némac niŋac héna acac kiwi ic ieneŋ Elianéŋ walac hamacac hezac ʒéanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesunéŋ acgina melemma ʒéyec; Imi hélacnec, Elia hama iwawai mocʒoŋ héiɋeli wammac. ");
INSERT INTO kgf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Waŋu énézéwa niŋgic Elia imi bec hayec. Waŋu ieneŋ ménda héŋtegicma siŋginawac iwawai hénia hénia wammigic. Imuhuyanec Icac Naŋa imi acguc méraginaiguc emma qenʒeŋ manʒeŋ nimmac. ");
INSERT INTO kgf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Imuhuc ʒéyu tohotoho ichéra ieneŋ doku naec haka ic Yohaneac ʒéyec imi niŋasarigic. ");
INSERT INTO kgf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Waŋu ic embac tuŋ ionac muru keŋgic ic méŋnéŋ Yesuac muru hama wésiaiguc simiŋ héimiyec. ");
INSERT INTO kgf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Waŋu yomuhuc ʒéyec; Miŋ Kewu, nuac naŋnawac niŋ ewaga biriyu, humuc turucya gelec malec qahac wammiyu naléya naléya gericiguc me dokuiguc hiŋgacanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tohotoho ichécga ionac muru wagicma hawa ieneŋ mehiaru mimuac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Oh! hicŋisai yomi ninʒéŋ ninʒéŋgina qahac, kaiʒiliweŋ ginaguc imi, nalé dahecac séc kechoruma ini bisiqatéŋ waŋ énécmimaŋ? Ic merac imi you nuac muru wagicma hagic. ");
INSERT INTO kgf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Imuhuc ʒéyu wagicma hagic Yesunéŋ uŋa biria ac geriwaguc wammiyu ic merac iwac murunec éréma hama keŋec. Waŋu imuarunec mia merac imi hiaruyec. ");
INSERT INTO kgf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Waŋu tohotoho ichéra ieneŋ Yesu eŋeyacneciguc éléŋnec hicŋimima qesimigic; Némac niŋac nini uŋa biria nesimiwiŋac séc ménda waŋec? ");
INSERT INTO kgf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Qesimigic melemma ʒéyec; Ini ninʒéŋ ninʒéŋgina mocʒoŋ komocdiadac imuac niŋac nesimuac séc qahac waŋec. Ac hélawac ʒéwa niŋgic, ini ninʒéŋ ninʒéŋgina komocdiadac saiwa gocmia séc késa kecmu imi baec boŋa yomuac mia yomuacnec yacma eri kenna ʒégic hia yacma kemmac. Onac muru iwawai méŋ osiosiya ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Waŋu imuhucya imi nene ʒikima ʒéwelec ménda wammuiguc imi waima kemmacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Waŋu Galilaia baeciguc eŋawu haréma imuaru Yesunéŋ yomuhuc énézéyec; Icac Naŋa imi andé qemigic ic ionac méraiguc emmac. ");
INSERT INTO kgf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Eŋu qegic humumac. Waŋu ai meme haréwéc waŋu humuc igucnec meyac mimia wammac. Imuhuc ʒéyu tohotoho ichéra ieneŋ ewa biri kuneŋ yanda waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu ʒéma tohotoho ichéra eneŋ Kafanaum ama areŋa yandaiguc harégic ocmuŋ téréyawac ai yawuŋac takis meme ic ieneŋ Peteroac muru hama qesimigic. Kiwi icgina imi ocmuŋ téréyawac takis ménda haianʒac me? ");
INSERT INTO kgf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ʒéyu, Peteronéŋ haianʒac ʒéma ama qeriaiguc éréyu Yesunéŋ bec niŋtegicma yomuhuc qesimiyec. Simon, gi dimuhuc ninʒaŋ? Mérac murunec baecac ic kewu ieneŋ takis meanʒu? Naŋhécgina ionac murunec me tosara ionac murunec? ");
INSERT INTO kgf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Qesiyu Peteronéŋ melemma ʒéyec; Tosara ionac murunec. Imuhuc ʒéyu Yesunéŋ ʒéyec; Imuhuc waŋu naŋhécgina ieneŋ eŋ kecmu. ");
INSERT INTO kgf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Waŋu imuhuc wanni niŋgic biriwac niŋac, imuac ʒékéŋiguc kemma hawic gilina lambéc méŋ walac kimac imi héréna éréyu kuaya mesacgéma hénna qeriaiguc soukiwa gocmia momacguc heyu mema kemma geŋga ʒéma nuac buŋa haina hiŋgaru. ");
INSERT INTO kgf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nalé imuaru tohotoho ic eneŋ Yesuac hosucgéma ʒégic; Mérénéŋ kurumeŋac héŋgaleŋ ama areŋa yandaiguc kuneŋgina wanʒac? ");
INSERT INTO kgf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Imuhuc ʒégic merac komoc méŋ qaru hayu oporu sucginaiguc naŋec. ");
INSERT INTO kgf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Naŋu yomuhuc ʒéyec; Ni hélacnec énézézua, ini qerigina melemma nambérac ionac séciguc ménda wammu imi, kurumeŋac héŋgaleŋ amaiguc ménda keremmu. ");
INSERT INTO kgf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Imuac bec mérénéŋ merac komoc yomuhucya éséc memaamuma kecmac iminéŋ mia kurumeŋ amaiguc kuneŋgina wammac. ");
INSERT INTO kgf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Waŋu mérénéŋ méŋ nambérac komoc yomuhucya nuac qacnaiguc héihéré mizac imi mia ni héihéré nénʒac. ");
INSERT INTO kgf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Waŋu mérénéŋ méŋ merac komoc komoc ni ninʒéŋgé nénʒu ionac sucgina igucnec méŋ hinocgémiyu képésic wammaciguc ic hinocgémiyec imi mia déméŋaiguc hoc yandanéŋ ɋatémima konduŋiguc giligic dumuŋaiguc hiŋgacmac imi bakia efefia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yei ewa biric yandanéŋ manam batuc ai niŋac baeciguc heanʒac! Manambatuc imi hamacac hezac, néŋ méŋnéŋ méŋ manam batuc waŋ énécmimac iwac muru imi saec hemimac. ");
INSERT INTO kgf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Imuac méraganéŋ me hénaganéŋ manam batuc waŋgéŋu hericma gilina keŋu. Waŋu puriŋnéŋ kekec seliiguc kerembésémaŋ iminéŋ niŋna efefia wammac, néŋ héna méraga éréhécnec geric hémbénaŋaiguc giligic hiŋgacbésémaŋ iminéŋ niŋna réwéria wammac. ");
INSERT INTO kgf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Imuac kicganéŋ manam batuc waŋgéŋu képésic waŋanʒaŋiguc kicga néfindiŋgéma gilina kemmac. Kicga momacgucnéŋ kekec hémbénaŋaiguc kerembésémaŋ iminéŋ guac hia wammac. Waŋu kicga éréhécnec geric siaiguc giligic hiŋgacbésémaŋ iminéŋ niŋna réwéria wammac. ");
INSERT INTO kgf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Técgina nimma kecgic, nambérac komoc komoc yomuhucyawac niŋgic mamaya wambac niŋac. Ʒéwa niŋgic, ionac kua meme uŋagina imi kurumeŋiguc nalé séc kurumeŋ Maŋgocnawac kic ségéria hémma kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Icac Naŋanéŋ rouc wamma kekec képésicgina igucnec metecgé énécmimaŋ ʒé hayec. ");
INSERT INTO kgf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Deic ninʒu? Ic méŋ ramaya 100 hemizac ʒéwiŋ. Waŋu sucginaiguc méŋnéŋ sohoma kemmaciguc ramaya 99 imi onoporu naŋgic baec boŋaiguc kemma rama sohoyec imi ménda mihicŋimaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ni hélacnec énézézua sohoyec imi mihicŋizaciguc imuac niŋ mia 99 ménda sohogic ionac niŋac ségiségi wanʒac imuac séha ogicqogic wamma ségiségi yanda wammac. ");
INSERT INTO kgf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Imuhucyanec Maŋgocgina kurumeŋiguc kecʒac iwac kiwaiguc komoc komoc yomi ionarunec méŋnéŋ méŋ birima qahac wammac niŋac ewa siŋa ménda hemizac. ");
INSERT INTO kgf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Hénaoriŋ ionarunec alaga méŋnéŋ képésic waŋ gémmaciguc kemma ekacneciguc képésicya imi ézéna hémmac. Waŋu acga ninʒaciguc imi alaga biria igucnec muŋguc wagicʒaŋ wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Waŋu acga ménda ninʒaciguc, ic momacguc me éréhéc oragicna eŋawu kemma héipuc ic éréhéc iorac kuagiranéŋ alagawac ara momacguc momacguc meseligic ménda qaecgémac. ");
INSERT INTO kgf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Waŋu ewa seli wamma acgina ménda nimmaciguc hénaoriŋ énézégic nimmu. Waŋu hénaoriŋ ionac ac imuhucyanec ménda nimmaciguc, ic enia me takis meme ionac waŋ énécmiwu ésécnec wammimu. ");
INSERT INTO kgf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ni hélacnec énézézua, némac iwawai ini baeciguc ʒikimu imi kurumeŋiguc ʒikiʒikia wammac. Waŋu némac iwawai baeciguc hulacmu imi kurumeŋiguc hulachulara wammac. ");
INSERT INTO kgf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Waŋu muŋguc énézéwa niŋgic, baeciguc onarunec éréhécnéŋ iwawai méŋ niŋac ewa momac wamma qesimaoc imi Maŋgocna kurumeŋiguc kecʒac inéŋ niŋu mocʒoŋ orac muru wandac wandara wammac. ");
INSERT INTO kgf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Waŋu éréhécnéŋ me haréwécnéŋ nuac qacnaiguc tocgézu imi ni acguc imuaru sucginaiguc kecʒua. ");
INSERT INTO kgf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Waŋu Peteronéŋ Yesuac hama yomuhuc qesiyec; Miŋna, alananéŋ biria waŋnéŋu hatac dahec képésicya waimimaŋ? Keŋkecma hatac 7 imuac séc waimimaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Qesiyu yomuhuc melemma ʒéyec; Gézéwa niŋna, hatac 7 sac qahac, néŋ tuŋ 70 imi arec 7 imuac séc waimiwésémaŋac ʒézua. ");
INSERT INTO kgf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Imuac kurumeŋac héŋgaleŋ ama areŋa yanda imi ic kewu méŋ weleŋ qeqehéra iniguc taségina héimindiŋi wammaŋ ʒé waŋec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ic kewu imi héimindiŋi ai imi héniyec. Héniyu ic méŋ iwac muru taséya 10 tauseŋ Talanti hemiyec imi wagicma érégic. ");
INSERT INTO kgf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Waŋu ic iwaru soukiwa méŋ ménda hemiyu kumacac séc qahac waŋec. Imuac niŋac ic kewunéŋ ic imi eŋeya ʒéma iniŋ merachéra ʒéma iwawaiya hemiyec imi mocʒoŋ haigic boŋ megic soukiwa iminéŋ tasé imi kumac niŋ ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Imuhuc ʒéyu weleŋ qeqe ic imi wésiaiguc mama sicgémima welecma ʒéyec; Bénʒéŋ mambéc waŋnénna ni taséna mocʒoŋ kugémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Imuhuc ʒéyu weleŋ qeqe ic iwac miŋinanéŋ ewa biric wamma tasé imi audacma waimiyu keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Waŋu ic iminéŋ mama kemma ai ic momacya méŋ taséya 100 Denarion hemiyec imi mihicŋima déméŋaiguc késama melanʒima ʒéyec; Guac tasé nuac muru hegénʒac imi kuma nénna. ");
INSERT INTO kgf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Waŋu ai momacya imi ic iwac héniaiguc mama simiŋ héimima welecma ʒéyec; Bénʒéŋ mambéc waŋnénna kugémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Waŋu imuac ménda wamma taséya kudacmaguc mamac niŋac hésa amaiguc oporec. ");
INSERT INTO kgf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Waŋu ai ic tosara ieneŋ haka hicŋiyec imi hémma niŋgic biri qiria waŋu kemma haka hicŋiyec imi mocʒoŋ miŋgina ézédacgic. ");
INSERT INTO kgf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Imuhuc ʒégic miŋginanéŋ ic imi qaru eŋu yomuhuc ézéyec; Gi weleŋ qeqe biria kétik téŋgéŋ! Welec nénna guac tasé imi mocʒoŋ audari. ");
INSERT INTO kgf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Neŋ guac waŋi ésécnec gi acguc ai momacga goiya héimiwésémaŋac ménda heyec me? ");
INSERT INTO kgf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Imuhuc ʒéma haʒéc yanda wamma taséya imi kudaru hulacmimu niŋac hésa ama galeŋ ionac méraginaiguc oporec. ");
INSERT INTO kgf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Imuac niŋac méŋnéŋ méŋ alaginawac képésic imi ewa qeriginanéŋ ménda waimimuiguc kurumeŋ Maŋgocnanéŋ imuhucyanec mia waŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu ac imi ʒéyu tecgéyu Galilaia baec waima Yodan doku néwéc Yuda baec suciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Keŋu ic embac tuŋ yandanéŋ méndacmima keŋgic baec imuaru hafiginaguc imi mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Waŋu Farisaio ic ieneŋ hama batucgéma qesigic; Ic méŋnéŋ hénia imuac me imuac iniŋa hia waimimacac héna méŋ hezac me? ");
INSERT INTO kgf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ʒégic melemma ʒéyec; Mihicŋi mihicŋi miŋinanéŋ hénihéniaiguc ic momacguc ʒéma embac momacguc meérécmima ac yomuhuc ʒéyec imi ini ménda oloŋniŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hénia imuac niŋac icnéŋ neŋgoc maŋgocya wai érécmima kemma iniŋawac muru qékétayu éréhécnéŋ momacguc wammaoc. ");
INSERT INTO kgf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Imuac iereŋ imi éréhéc qahac, néŋ séwi momacguc, imuac Anutunéŋ toroqe érécmiyec imi icnéŋ ménda méndéŋ érécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Imuhuc énézéyu ieneŋ yomuhuc ʒégic; Waŋu hénia némac niŋac Mosenéŋ héric amuamuyawac kiwi omima mélina keŋu ʒéyec? ");
INSERT INTO kgf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Imuhuc ʒégic, Yesunéŋ melemma énézéyec; Mosenéŋ ewa qerigina selia imuac niŋ wamma wai énécmiyec, néŋ hénihénia igucnec imi imuhuc qahac. ");
INSERT INTO kgf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ni énézézua, mérénéŋ méŋ iniŋa saŋgima haka biria ménda waŋeciguc hénia tosara niŋac waimima embac méŋ memac imi kaisero wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Imuhuc ʒéyu tohotoho ichéra ieneŋ yomuhuc ézégic; Ic méŋnéŋ iniŋaguc héna ac imuhucya tohomacac hezaciguc embac ménda mema kecmac iminéŋ hia wammac. ");
INSERT INTO kgf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ʒégic Yesunéŋ melemma ʒéyec; Ac imi ic momac yandanéŋ niŋtohomuac séc qahac, néŋ imuhuc meénécmimia sac imuhuc wammu. ");
INSERT INTO kgf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ic tosia ieneŋ neŋgoc héri igucnec héfiŋ wamma hicŋianʒu. Waŋu méŋ imi icnéŋ waŋ énécmigic héfiŋ wamma kecanʒu. Waŋu tosia ieneŋ kurumeŋac héŋgaleŋ ama niŋac eŋaoc héfiŋ ic ésécnec wamma kecanʒu. Ac imi tohomuac séc imi eneŋ hia tohomu. ");
INSERT INTO kgf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Waŋu Yesunéŋ méria orucginaiguc haima ʒéwelec énécmimac niŋ ic embac tosara ieneŋ nambérac komoc komoc onagicma hagic tohotoho ichéra ieneŋ qetali énécmima ac waŋ énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Imuhuc waŋgic Yesunéŋ yomuhuc ʒéyec; Nambérac komoc komoc imi wai énécmigic nuac hagic, neuŋ ménda héiénécmigic. Kurumeŋac héŋgaleŋ ama imi komoc komoc imuhucya ionac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Imuhuc ʒéma méria ionac orucginaiguc hai énécmimaguc baec imi waima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Waŋu ninʒu? Ic méŋnéŋ iwac muru hosuru hama yomuhuc qesimiyec; Kiwi ic, ni némac haka hiabia wamma kekec hémbénaŋa imi memaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ʒéyu Yesunéŋ yomuhuc ʒéyec; Némac niŋ haka hiabiawac qesinénʒaŋ? Hiabia wanʒac imi momacguc sac kecʒac. Waŋu gi kekec hémbénaŋaiguc keremmaŋ ʒé wanʒaŋiguc imi héna ac tohowésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Imuhuc ʒéyu ʒéyec; Némac héna ac niŋac ʒézaŋ? Ʒéyu Yesunéŋ melemma ʒéyec; Ic ménda qehumuwésémaŋ. Kaisero ménda wambésémaŋ. Kowu ménda mewésémaŋ. Héipuc ac ikora ménda ʒéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Neŋgoc maŋgocga eegira héiwésémaŋ. Waŋu geŋga siŋ niŋamuanʒaŋ ésécnec alaga siŋ nimmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ʒéyu ʒéyec; Ni imi mocʒoŋ tohodacma kecanʒua, imuac némacnéŋ méŋ nuac muru ménda sécgézac? ");
INSERT INTO kgf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Imuhuc ʒéyu Yesunéŋ ézéma ʒéyec; Gi solaŋanimaŋ ʒé kemma hinac iwawaiga imi haina boŋa megic soukiwa iminéŋ maqeqeya énécmiwésémaŋ. Imuhuc wanna kurumeŋiguc iwawai eeyaguc hegémmac. Waŋu geŋga imi hama ni méndac némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Imuhuc ʒéyu ac imi nimma ic merac imi hinac ʒéma soukiwaya yanda hemiyec imuac niŋ ewaya biriyu keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Keŋu Yesunéŋ tohotoho ichéra énézéma ʒéyec; Ni hélacnec énézézua, ic hinac yanda ginaguc ieneŋ kurumeŋac héŋgaleŋ amaiguc kerembiŋ ʒé osimu. ");
INSERT INTO kgf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ni muŋguc énézézua, kamele yaŋnéŋ qodu kifaŋaiguc kereŋkereŋa imi bénʒéŋadac, néŋ ic hinac yanda ginagucnéŋ Anutuac héŋgaleŋ amaiguc kereŋkereŋa imi osiosiya. ");
INSERT INTO kgf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Imuhuc ʒéyu tohotoho ichéra ieneŋ nimma bacgina kuneŋnec yandiyu ʒégic; Imuhuc waŋu mérénéŋ aŋgéŋ timimiawac séc wammac? ");
INSERT INTO kgf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ʒégic Yesunéŋ inicma énézéyec; Imi ic eneŋ memuac séc qahac, néŋ Anutuguc imi iwawai mocʒoŋ yanda medac medara. ");
INSERT INTO kgf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Imuhuc ʒéyu Peteronéŋ melemma ʒéyec; Ninʒaŋ, nini méndac gémbiŋ ʒé iwawai mocʒoŋ waidariŋ, imuac némac iwawai késawiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Qesiyu Yesunéŋ énézéyec; Hélacnec énézézua, baec yomuac hainetec wawaŋa naléiguc Icac Naŋa imi eŋeya edamuya imuac ic kewu tataraiguc tacmac imuaru méndac néŋanʒu ini imi momacnec tatac 12 imuaru tacma Israelac kisic 12 imi niŋgésima galeŋgé énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Waŋu mérénéŋ méŋ nuac qacnawac wamma amaya me dara munia me nauŋa me neŋgoc maŋgocya me merachéra me baec aiya waizaciguc imuhucya imi 100 imuac séc ogicma mema kekec hémbénaŋa imi mératéc memu. ");
INSERT INTO kgf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Néŋ walac wanʒu ionarunec sasalanéŋ andia wammu. Waŋu andia wanʒu ionarunec sasalanéŋ walac wammu. ");
INSERT INTO kgf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kurumeŋac héŋgaleŋ ama areŋa yanda imi ai miŋina méŋnéŋ waiŋ aiyaiguc ai memu niŋac ai ic énépésimaŋ ʒé siŋunec yanda yacma keŋec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kemma ai meme momacguc imuac boŋa Denarion momacguc eŋac eŋac énécmimaŋ ʒéyu ewa momac waŋgic méli énécmiyu waiŋ aiyaiguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Waŋu siŋunec 9 kilok séc waŋu nénnagémba sombeŋiguc kemma ic tosara iniru eŋ naŋgic ");
INSERT INTO kgf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","yomuhuc énézéyec; Ini acguc nuac waiŋ aiiguc kemma ai megic boŋa séhaiguc énécmimaŋ ʒéyu nimma kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Waŋu 12 kilok ʒéma maria 3 kilok imuac séc imuaru muŋguc kemma imuhuyanec waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Waŋu maria 5 kilok séc waŋu kemma iniru ic tosara muŋguc ai qahac eŋ naŋgic yomuhuc énézéyec; Némac niŋac kaiwe herec ai ménda mema eŋ nanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ʒéyu melemma ʒégic; Méŋnéŋ méŋ ai icac ménda nénépésizac. Ʒégic ini acguc nuac waiŋ aiiguc kereŋgic ʒéma énézéyu kereŋdacgic. ");
INSERT INTO kgf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ama siŋima hayu ai miŋinanéŋ hama galeŋgina ézéma ʒéyec; Ai ic unuruna tetecgiaiguc hazu ionac murunec hénima ai boŋa énécmina keŋkecma walac hazu ionac énécmina tecgémac. ");
INSERT INTO kgf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ʒéyec séc waŋu maria 5 kilok imuaru hagic ieneŋ hama Denarion momacguc momacguc késagic. ");
INSERT INTO kgf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Késagic walac walac hagic ieneŋ hama hémma boŋgina meemma nénécmiyu késawiŋ ʒéma niŋgic, néŋ ini imuhucyanec Denarion momacguc sac eŋac eŋac énécmiyu késagic. ");
INSERT INTO kgf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Imuhuc késama ai miŋinawac ŋindic ŋunduc ac ʒéma ac yomuhuc ʒémigic; ");
INSERT INTO kgf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Anduguc hagic ieneŋ kaiwe kiwa 1 aua sac ai mezu. Waŋu neneŋ mia ai yéwéria ai meme momacgucac séc kaiwe geriwaiguc namma meziŋ, néŋ ionac aigina boŋa imi nonac séc énécmizaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Imuhuc ʒégic ai miŋinanéŋ ionarunec méŋ yomuhuc ézéyec; Ala Denarion momacguc niŋac acnira ménda ʒikizic me? Ni képésic méŋ ménda waŋgénʒua. ");
INSERT INTO kgf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Imuac boŋgawac mema kenna, andu hagic ionac aigina boŋa onac séciguc énécmimaŋ iminéŋ ewa siŋna wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nena iwawainanéŋ ewa siŋnawac wammaŋac héna ménda hezac me? Hakana hiabia imi kicginanéŋ hémma nimbupuc wanʒu? ");
INSERT INTO kgf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Suruc imuac séc andianéŋ walac wammu, waŋu walacnéŋ andia wammu. ");
INSERT INTO kgf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Waŋu Yesu imi Yerusalem kemmaŋ ʒé kemma hénaiguc tohotoho ichéra 12 eŋacnec énépésima yomuhuc énézéma ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ninʒu, neŋaŋ Yerusalem enʒiŋ. Imuaru Icac Naŋa imi hofac oo ichécgina ʒéma héna acac kiwi ic ionac méraginaiguc opocgic ieneŋ humucac buŋawac ʒétecgé mimu. ");
INSERT INTO kgf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Waŋu ʒédesi wammima hihilocnéŋ qericma qema ic héŋgeŋa wéndaraiguc qegic humumac niŋ ic enia ionac muru meleŋmigic kemmac. Waŋu ai meme haréwéc waŋu humuc igucnec yacmac. ");
INSERT INTO kgf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nalé imuaru Ʒebedaioac iniŋanéŋ naŋhéréra iriguc hama Yesuac muru sicgémima iwawai méŋ niŋac welecmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Welecmiyu ézéma ʒéyec; Gi némac iwawai niŋac wanʒaŋ? Ʒéyu embac iminéŋ yomuhuc ʒéyec; Nuac naŋhérécna yomi niŋérécmina guac héŋgaleŋ ama areŋ yandaiguc méŋnéŋ héigaiguc méŋnéŋ kanagaiguc tacmaoc. ");
INSERT INTO kgf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Ini hénia ménda nimma imuhuc qesinénʒu. Ni doku howuraguc nemaŋ ʒé wanʒua imi iri hia nemaoc? Ʒéyu ʒéyoc; Imi sécnira. ");
INSERT INTO kgf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ʒéyic Yesunéŋ ʒéyec; Imi hélacnec, iri doku howuraguc nemaŋ imi nemaoc, néŋ héinaiguc ʒéma kananaiguc tatara imi neŋ niŋéréc mimiawac ménda henénʒac. Tatac imi mérac méré maŋgocnanéŋ mézézéŋgé érécmiyec iorac buŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Imuhuc waŋgic tohotoho ichéra 10 ieneŋ ac imi nimma dara munia iorac niŋgic biriyec. ");
INSERT INTO kgf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Waŋu Yesunéŋ unuruyu hagic énézéyec; Ic enia ionac galeŋhécgina ieneŋ siŋginawac galeŋgé énécmianʒu. Waŋu ic kuneŋ hécgina ieneŋ ic kewu waŋ énécmianʒu imi ini hia ninʒu. ");
INSERT INTO kgf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Néŋ sucginaiguc imi imuhuc qahac, néŋ onarunec méŋnéŋ méŋ kuneŋgina wammaŋ ʒéma sucginaiguc weleŋ qeqe kecmac. ");
INSERT INTO kgf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Waŋu mérénéŋ méŋ walac wammaŋ ʒé wanʒaciguc weleŋ qeqe icgina wammac. ");
INSERT INTO kgf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Icac Naŋa imi weleŋ qemimu niŋac ménda mayec, néŋ weleŋ qeénécmimaŋ ʒé mayec. Waŋu eŋeya kekecya ic embac sasala ionac énécmima doegina memaŋ ʒé mayec. ");
INSERT INTO kgf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Waŋu ieneŋ Yeriko ama areŋa yanda waima keŋgic imuaru tuŋ yanda Yesu méndacmima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Keŋgic, ninʒu, kichilic ic éréhécnéŋ héna giŋgiŋaiguc tacma niŋic Yesu imi hama orogicma keŋu qacma ʒéyoc; Miŋ Kewunira Dawidiac ɋeli, wéséga niŋ nérécmina. ");
INSERT INTO kgf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Imuhuc qaric, ic tuŋ ieneŋ ac geriwaguc waŋ érécmima qetali érécmima acgira qaimac niŋac ac waŋérémigic, néŋ iereŋ muŋguc yanda qacma ʒéyoc; Miŋ Kewunira, Dawidiac ɋeli, wéséga niŋnérécmina! ");
INSERT INTO kgf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Qaric Yesu tilanʒima namma ururuma ʒéyec; Iri némacac waŋ érécmimaŋ niŋac wanʒaoc? ");
INSERT INTO kgf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Qesi érécmiyu ʒéyoc; Miŋnira, niri kicnira hima hémbi niŋac wanʒic. ");
INSERT INTO kgf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Imuhuc ʒéyic Yesunéŋ ewa biric waŋ érécmima kicgira osiyu imuarunec kicgira hima Yesu méndaroc. ");
INSERT INTO kgf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu ʒéma tohotoho ichéra ieneŋ Yerusalem hosuraiguc keŋgic nalé imuaru, Oliwa boŋaiguc Betfage ama areŋa taru imuaru keremma Yesunéŋ tohotoho ichéréra éréhéc méli érécmima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Iri eri wéségiraiguc ama areŋa tacʒac imuaru kemma nalé idacmuarunec doŋki méŋ merawaguc ɋatégic naŋic iricmaoc. Iricma imi hulacma oragicma nuac muru hamaoc. ");
INSERT INTO kgf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Waŋu méŋnéŋ ara méŋ érézémuiguc Miŋ Kewunéŋ imuac niŋac wanʒac imuhuc ʒéyic imuarunec doŋki éréhéc imi méli érécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Waŋu imi mocʒoŋ kua meme ic méŋac ackuaʒéc yomuhuc ʒéyec imi hélaguc wammac niŋac imuhuc hicŋiyec; ");
INSERT INTO kgf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Béracna Zion yomuhuc ézégic; Hénna! Ic kewuganéŋ guac hazac. Inéŋ gum bénʒénʒéŋ wamma doŋki qahaiguc tacma hazac, doŋki merawa qahaiguc. ");
INSERT INTO kgf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Waŋu tohotoho ic éréhéc iereŋ kemma Yesunéŋ érézéyec séc waŋoc. ");
INSERT INTO kgf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wamma doŋki ʒéma merawa imi oragicma hayic séwi usugina imi iorac qacgiraiguc lémbécgic Yesu imuac qacgiraiguc tarec. ");
INSERT INTO kgf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Waŋu ic embac tuŋ yandanéŋ malekugina hetecgéma hénaiguc lémbécgic keŋec. Waŋu tosaranéŋ ic hawa haréŋaguc imi kuma hénaiguc témbécgic. ");
INSERT INTO kgf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Waŋu ic tuŋ yanda walac andu wammima keŋgic imi eneŋ yomuhuc ʒéma hériaŋ haimigic; Ohec wahec! Dawidiac ɋelia! Ohec wahec! Mériaŋgaguc, Miŋ Kewuninawac qaraiguc hahaya! Ohec wahec, kurumeŋ ouac ouyaguc! ");
INSERT INTO kgf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Waŋu hama Yerusalem kereŋu ama miŋina momac yanda ieneŋ aurima welicgéma qesima ʒégic; Ic yomi mérénéŋ? ");
INSERT INTO kgf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Qesigic ic tuŋ yandanéŋ énézéma ʒégic; Yomi kua meme ic Yesu, Galilaia baec Naʒarete ama areŋa igucnec. ");
INSERT INTO kgf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesunéŋ ocmuŋ téréyaiguc emma imuac sombeŋiguc iwawai nénnagémba wamma naŋgic imi nesi énécmima soukiwa meamugic ionac ʒae ʒéma kembo nei haigic ionac tatac imi meleŋu madarec. ");
INSERT INTO kgf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Imuhuc wamma yomuhuc énézéyec; Ac kiwi yomuhuc oyecac hezac; Nuac amana imi ʒéwelec welecac ama ʒému ʒéyec, néŋ ini imuhuc waŋgic kowu nene ionac baŋec ésécnec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Waŋu kic hilic ʒéma ic puriŋa ieneŋ ocmuŋ téréyaiguc iwaru hagic mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Waŋu hofac oo ic kiwahécgina ʒéma héna acac kiwi ic ieneŋ haka welic welicgia Yesunéŋ waŋec imi ʒéma nambérac ieneŋ ocmuŋ téréyaiguc qacma, Ohec wahec, Dawidiac ɋeli! ʒégic inicgic qerigina biriyec. ");
INSERT INTO kgf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Waŋu qesima ʒégic; Gi nambérac ieneŋ némac ac ʒézu imi hia ninʒaŋ? Imuhuc ʒégic, Ninʒua ʒéma énézéyec; Ini imi ac yomuhuc hezac imi méŋ ménda oloŋgic? Nambérac ʒéma namu nene ionac kuaginaiguc mepé qepési hai énécminec. ");
INSERT INTO kgf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Imuhuc ʒémaguc wai énécmima ama areŋa yanda demiŋaguc imuacnec mama kemma Betania ama areŋaiguc kemma siŋiya imuaru kerec. ");
INSERT INTO kgf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Siŋunec ama areŋa yanda imuaru liliŋgéma kemmaŋ ʒé kemma hénaiguc nene niŋac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Imuhuc wamma héŋu héna giŋgiŋaiguc fik ic méŋ naŋu imuaru kemma hocma héla méŋ qahac, néŋ haréŋa sac hémma fik ic imuac ʒéyec; Nalé tetecgia qahac guarunec héla méŋ ménda hicŋimac. Imuhuc ʒéyu fik ic imi nalé imuarunec humuyec. ");
INSERT INTO kgf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tohotoho ichéra ieneŋ haka imi hémma welicgéma ʒégic; Fik ic yomi dimuhuciguc focdac humuzac? ");
INSERT INTO kgf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ʒégic Yesunéŋ acgina melemma énézéyec; Ni hélacnec énézézua, ini ewa éréhéc ménda wamma ninʒéŋgému imi haka fik ic imiguc hicŋiyec imuhucya sac qahac, néŋ baec boŋa yomuac niŋ yacma kemma konduŋiguc hiŋgacna ʒégic imi acguc hia hicŋi énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ini ʒéwelec aiiguc iwawai imuac me imuac ninʒéŋgéma ʒéwelecgic imi mocʒoŋ niŋénécmiyu medacmu. ");
INSERT INTO kgf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Waŋu keŋkecma Yesunéŋ ocmuŋ téréyaiguc emma ackuaʒéc ku énécmima keru hofac oo ic kiwa hécgina ʒéma galeŋ ieneŋ iwaru kemma yomuhuc ʒéma qesimigic; Gi némac kuc buŋanéŋ ai imi meanʒaŋ? Mérénéŋ kuc buŋa imi géŋec? ");
INSERT INTO kgf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ʒégic Yesunéŋ ac yomuhuc ʒéma meleŋ énécmiyec; Ni acguc ac momacguc qesi énécmiwa nézégic nimmaguc neŋ imuhucyanec némac kuc buŋaguc ai yomi meanʒua imi énézémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohaneac doku naec haka imi dimuacnec hayec? Kurumeŋ igunec me ic igucnec? Imuhuc ʒéma qesiyu ieneŋ eŋawu ac yomuhuc eminiŋgic; Kurumeŋ igunec hayec ʒéni némac niŋac ménda ninʒéŋgé migic ʒémac. ");
INSERT INTO kgf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Waŋu ic embac ieneŋ Yohaneac Anutuac kua meme ic ʒéma ninʒéŋgéanʒu imuac niŋ ic igucnec hayec ʒéwiŋ ʒéni ionac niŋac ʒénéŋnina hirizac. ");
INSERT INTO kgf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Imuhuc ʒéma Yesu yomuhuc ézégic; Ménda ninʒiŋ. Imuhuc ʒégic duŋa Yesunéŋ yomuhuc énézéyec; Ni imuhucyanec némac kuc buŋaguc iwawai yomi waŋanʒua imi ménda énézémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ini dimuhuc ninʒu? Ic méŋnéŋ naŋhéréra keric, naŋa walac iwac kemma ézéyec; Naŋna gi erac kemma waiŋ ai mena. ");
INSERT INTO kgf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Imuhuc ʒéyu melemma ʒéyec; Ménda kemmaŋ. Imuhuc ʒémaguc duŋa ewaya melemma keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Waŋu maŋgoc imi naŋa méŋac muru kemma imuhucyanec ézéyec. Ʒéyu melemma ʒéyec; Maŋgocna hia kemmaŋ. Waŋu inéŋ imuhuc ʒémaguc ménda keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sucgiraiguc mérénéŋ maŋgocac ewa siŋ méndacma waŋec? Ʒéyu melemma ʒégic naŋa walac. Ʒégic Yesunéŋ énézéyec; Ni hélacnec énézézua, takis meme ic ʒéma héna yanda embac eneŋ ini onogicma walac Anutuac héŋgaleŋ amaiguc keremmu. ");
INSERT INTO kgf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohanenéŋ haka solaŋawac héna énézémaŋ ʒé hayec. Waŋu ini ménda ninʒéŋgégic, néŋ takis meme ʒéma héna yanda embac eneŋ ninʒéŋgégic. Waŋu ini haka imi hémmaguc kileŋdac ewagina ménda melemma ménda ninʒéŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Qeqaiŋ ac méŋ ʒéwa niŋgic; Ai miŋina méŋnéŋ baec méŋiguc waiŋ ai medacma demiŋ meyu lelecgéyec. Waŋu waiŋ héla dokuya memeyawac hogoc méŋ meyacgéma imuaru galeŋ meme ama héŋgeŋa lesu herec méŋ megic eŋec. Imuhuc wamma boŋ meme ai ic ionac méraginaiguc haima baec méŋu keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kemma keru héla metocgémuac naléya ducŋiyu weleŋ qeqe ichéra ieneŋ héla memu niŋac boŋa meme ai ic ionac muru méli énécmiyu keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Boŋa meme ai ic ieneŋ weleŋ qeqe ic énépésima méŋ humumia qegic, méŋ qehumugic, méŋac hocnéŋ héigic. ");
INSERT INTO kgf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Imuhuc waŋgic muŋguc weleŋ qeqe ichéra ʒaŋgégina walac keŋgic imi ogicma méli énécmiyu keŋgic. Waŋu séc imuhucyanec waŋ énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Waŋu tetecgiaiguc naŋa mélima yomuhuc ʒéyec; Ieneŋ naŋna imi eeya héimimu. ");
INSERT INTO kgf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Waŋu boŋa meme ai ic ieneŋ naŋa hémma yomuhuc ʒéma eminiŋ waŋgic; Ic yomi kecma ai yomuac mératéc meme ic wammac imuac hagic qeni humuyu mératéc aiya yomi neŋaoc mewiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Imuhuc ʒéma waiŋ ai igucnec késama héréma séŋgaŋgeŋ hiŋgacma qehumugic. ");
INSERT INTO kgf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Imuac nalé méŋac waiŋ ai miŋinanéŋ liliŋgéma hamac imi boŋa meme ai ic imi dimuhuc waŋ énécmimac? ");
INSERT INTO kgf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Imuhuc ʒéyu melemma ʒégic; Ai ic biria imi humuc ʒérabéra mihicŋi énécmima waiŋ ai imi ai ic qacguc ai yawuŋ nalé séc héla hianec haimimuac séc ionac méraginaiguc soukiwa niŋac ai imi hai énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesunéŋ muŋguc toroqema ʒéyec; Ini kiwi téréyaiguc ac méŋ yomuhuc hezac imi ménda oloŋanʒu? Mericqe ic eneŋ hoc méŋ héŋara mema giligic keŋkeŋa iminéŋ ama imuac hoc oruha waŋec. Haka imi Miŋ Kewuac murunec hicŋiyu kicninanéŋ hénni welic welicgiaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Imuac niŋac ni énézézua, Anutuac héŋgaléŋ ama areŋa yanda imi méragina igucnec onagicma baera méŋac ic embac héla mihicŋimu ionac méraginaiguc hai énécmiyu memu. ");
INSERT INTO kgf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ic méŋnéŋ méŋ hoc imuac qahaiguc mayu ʒéŋgédacmac. Waŋu hoc iminéŋ ic méŋac qahaiguc mayu qéséŋu bororoŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Waŋu hofac oo ic kiwahécgina ʒéma Farisaio ic ieneŋ qeqaiŋ ac imi eŋaŋ niŋ imuhuc ʒéyec imi niŋtegicgic. ");
INSERT INTO kgf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Waŋu ieneŋ imi héna méŋ mihicŋima Yesu késawiŋ ʒé hochoc ai megic. Waŋu ic embac ieneŋ Yesu imi kua meme ic ʒéma nimmigic imuac niŋac ʒénéŋgina hiriyec. ");
INSERT INTO kgf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesunéŋ acgina melemma muŋguc qeqaiŋ ac wamma yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kurumeŋac héŋgaleŋ ama areŋa yanda imi ic kewu méŋnéŋ naŋawac ʒammaréŋ aria wammizac ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ʒammaréŋ ariacwac hamu niŋac kiwi oénécmiyec imi onac unurugic hamu niŋac weleŋ qeqehéra méli énécmiyu kemma énézégic, néŋ ieneŋ hawiŋ ʒé ménda waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Waŋu weleŋ qeqe tosara muŋguc méli énécmima yomuhuc énézéyec; Héihéré énécmiyi imi onac yomuhuc énézému; Ninʒu! Ni mariawac nene yanda oma nuac burumakao ʒéma beric yaŋ haléc yandaguc qe oma iwawai mocʒoŋ ʒéréŋqéréŋ wamma haidacʒua imuac ʒammaréŋ ariaciguc hagic. ");
INSERT INTO kgf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ʒéyu kemma énézégic, néŋ gezac qeqe ménda wamma méŋnéŋ aiyaiguc keŋu, méŋnéŋ nénnagémba ai niŋac keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Waŋu tosara eneŋ ic kewuac weleŋ qeqehéra imi énépésima ʒédesi énécmima unuhumugic. ");
INSERT INTO kgf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Imuhuc waŋgic ic kewu iminéŋ qeri biric nimma yaré ic tuŋa méŋ méli énécmiyu kemma sac nene ic imi unudacma ama areŋgina kumugic ʒedarec. ");
INSERT INTO kgf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Waŋu weleŋ qeqehéra énézéma ʒéyec; Ʒammaréŋ aria imi bec mézézéŋgéwa hezac, néŋ ic unuruyi imi eneŋ eeginaguc ménda wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Imuac héna séraiguc kemma ic embac mihicŋimu séc unurugic ʒammaréŋ ariacwac hamu. ");
INSERT INTO kgf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Imuhuc ʒéyu weleŋ qeqe ic eneŋ hénaiguc séc kemma ic embac hia me biria mihicŋi énécmigic séc onagicgic hagic. Hama tacma keŋgic ʒammaréŋ aria ama imi kuaya qeyec. ");
INSERT INTO kgf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Waŋu ic kewunéŋ ic embac hama tacgic imi inicmaŋ ʒé éréma héŋu ic méŋnéŋ owo malekuya séha ménda haima hama tarec. ");
INSERT INTO kgf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Taru ézéyec; Ala gi némac niŋac ʒammaréŋ ariacwac maleku ménda héima hazaŋ? Imuhuc qesimiyu ic imi ac méŋ ʒémaŋ ʒé osiyec. ");
INSERT INTO kgf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Waŋu ic kewu iminéŋ weleŋ qeqe ic yomuhuc énézéyec; Héna méria dérécgéma séŋgaŋgeŋ siŋi tunumaŋiguc giligic, imuaru siacma ʒéra kima tacmac. ");
INSERT INTO kgf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sasala unurugic, néŋ gési énécmima énépésimacac séha imi éréhécdac. ");
INSERT INTO kgf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yesunéŋ imuhuc ʒéyu tecgéyu Farisaio ic ieneŋ amaginaiguc kemma aʒoroma acnéŋ simba méŋ dimuhuc meni kimac ʒéma niŋareŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Niŋareŋ géma eŋaŋ tohotoho ichécgina ʒéma Herodeac ichéra tosara momacnec méli énécmigic Yesuac hama ʒégic; Kiwi ic, gi imi ic héla, Anutuac haka imi hélacnec ku nénécmianʒaŋ. Gi ic inicmaŋ ʒé séwiginawac ménda héŋanʒaŋ imuac ic eŋeŋa me mamaya ionac kicginaiguc ewa éréhéc ménda waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Imuac efima ʒéna ninni. Geŋ niŋna Kisawac takis haianʒiŋ imi héna ac logiʒac me qahac? ");
INSERT INTO kgf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ʒégic Yesunéŋ ionac qeri biric imi niŋtegicma ʒéyec; Ikoc ic ini némac niŋac acnéŋ simba menénʒu? ");
INSERT INTO kgf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis buŋawac soukiwa méŋ nézéna hémba ʒéyec. Ʒéyu Denarion momacguc mema hagic. ");
INSERT INTO kgf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Waŋu yomuhuc qesi énécmiyec; Yomi mérac ireha ʒéma némac kiwi ogic hezac? ");
INSERT INTO kgf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ʒéyu ʒégic; Kaisawac, imuhuc ʒégic énézéyec; Imuac Sisawac buŋa imi Sisa mima, Anutuac buŋa imi Anutu mimu. ");
INSERT INTO kgf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Imuhuc ʒéyu ieneŋ welicgéma waima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ai meme imuaru Sadukaio ic humuc igucnec yacyac ménda hezac ʒéanʒu imi eneŋ Yesuac muru hama yomuhuc qesimigic; ");
INSERT INTO kgf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kiwi ic, Mosenéŋ yomuhuc nénézéyec; Ic méŋ nambéracya qahac humumac imi munianéŋ qawéra mema darawac buŋa ɋeli mihicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Waŋu sucninaiguc dac muna 7 kecgic dacginanéŋ embac mema nambéracya qahac kecma humuyu, iwac iniŋa muniawac mériaiguc opocma keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Andia ʒéma andiawac andia imuhucyanec waŋgic keŋu 7 mocʒoŋ imuhuc wandacgic. ");
INSERT INTO kgf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Imuac tetecgiaiguc embac imi acguc imuhucyanec humuyec. ");
INSERT INTO kgf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Waŋu ieneŋ momac yanda embac imi megic imuac niŋ embac imi humuc igucnec yacyarawac naléyaiguc 7 ionac murunec mérac iniŋa wammac? ");
INSERT INTO kgf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ʒégic Yesunéŋ yomuhuc melemma énézéyec; Ini kiwi téréya me Anutuac kuha imi ménda niŋasarima dindiŋanec ménda niŋyacgézu. ");
INSERT INTO kgf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Humuc igucnec yacyarawac naléiguc imi ic me embac ménda meamumu. Imuaru imi ʒammaréŋac buŋa qeénécmimia imi ménda hemac, néŋ kurumeŋac Anutuac kua meme uŋa ésécnec kecmu. ");
INSERT INTO kgf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Waŋu eneŋ humuc igucnec yacyarawac Anutunéŋ ac yomuhuc énézéyec imi ménda oloŋgic? ");
INSERT INTO kgf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ni Abarahamac Anutu, Isakawac Anutu, Yakopac Anutu ʒéyec imi ménda oloŋ héŋanʒu? Anutu imi humuc ic ionac Anutu qahac, néŋ kic ɋeli ic ionac Anutu kecʒac. ");
INSERT INTO kgf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ic tuŋ yanda ieneŋ Yesunéŋ imuhuc ku énécmiyu nimma welicgégic. ");
INSERT INTO kgf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesunéŋ acnéŋ Sadukaio ic menéŋqe énécmiyu ara melemmuac séc qahac waŋec. Waŋu imuac surucya imi Farisaio ic ieneŋ nimma aʒorogic. ");
INSERT INTO kgf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aʒoroma ionarunec héna acac kiwi ic méŋnéŋ Yesu batucgé mima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Kiwi ic, héna ac sucginaiguc némac acnéŋ eŋeŋa wanʒac? ");
INSERT INTO kgf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ʒéyu Yesunéŋ yomuhuc ézéyec; Gi ewa qeriga mocʒoŋnec qeri uŋaga mocʒoŋnec ʒéma niniŋga mocʒoŋnec Miŋ Kewu Anutuga siŋa nimmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Héna ac iminéŋ walac walac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Séha imuhucyanec méŋ hezac imi yomuhuc; Gi geŋgac niŋac siŋniŋ waŋamuanʒaŋ séc alagawac siŋniŋ wammiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Héna ac éréhéc imuaru mia héna ac tosara mocʒoŋ ʒéma kua meme ic ionac ac mocʒoŋ imi koro koroyawac nanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisaio ic aʒoroma kecgic Yesunéŋ yomuhuc qesi énécmiyec; ");
INSERT INTO kgf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ini Kristoac dimuhuc niŋanʒu? Mérac ɋelia? Ʒéyu ʒégic; Dawidiac ɋelia. ");
INSERT INTO kgf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ʒégic Yesunéŋ énézéyec; Imuhuc waŋu Dawidi i Uŋanéŋ ézéyu dimuhuc niŋac Kristoac, Miŋ Kewuna ʒémima yomuhuc ʒéyec? ");
INSERT INTO kgf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Miŋ Kewunéŋ nuac Miŋ Kewuna ézéyec; Guac haʒéchécga hénagawac duandiaiguc tocgo énécmidacba tecgémac nalé sura imuac séc gi hama héinaiguc tacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dawidinéŋ Kristoac Miŋ Kewuna ʒémiyeciguc némaciguc iwac ɋelia wammac? ");
INSERT INTO kgf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Imuhuc ʒéyu ic méŋ ara méŋ ménda meleŋec. Waŋu nalé imuarunec éréma emma méŋnéŋ méŋ ac méŋ efima ménda qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Waŋu Yesunéŋ ic tuŋ ʒéma tohotoho ichéra yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Héna acac kiwi ic ʒéma Farisaio ic imi Moseac tataciguc tacanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Imuac niŋ ac ʒéanʒu imi mocʒoŋ nimma tohodacmu, néŋ wawaŋ memegina imi ménda méndacma wammu. Hénia imi yomuhuc; Ieneŋ ackuaʒéc imi kuanéŋ sac ʒéma ménda tohoanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Waŋu ieneŋ hinac réwéria bisiqatéŋ wawaŋawac séc qahac imuhucya dérécgéma ic onac huaginaiguc haimaguc eŋaoc imi iwawai imuhucya meyacbiŋ ʒé méragina merawa méŋ ménda haianʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Iwawai waŋanʒu imi mocʒoŋ icnéŋ inicsoromu niŋac sac waŋanʒu. Pakaginaiguc kiwi téréyawac katapaya meyandima ʒéwelecac niniŋ héiɋeli ɋeliac susuria imi maleku ginaiguc horuacnec meyandima haianʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Waŋu ariaciguc aʒoroma tatac ou walac tacʒac imuac siŋa nimma tocgotocgo amaiguc ic kiwawac tatac imuaru tacbiŋ ʒé waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nénnagémba sombeŋiguc méra qeqe waŋ énécmima kiwi ic ʒéénécmimu niŋac waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Waŋu ini imi kiwi ic ʒéénéc mimuac ménda wammu. Kiwi icgina imi momacguc sac kecʒac. Ini imi mocʒoŋ dacmuna wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Waŋu baeciguc ic méŋac niŋ maŋgoc ménda ʒémimu. Onac maŋgocgina imi momacguc sac kurumeŋiguc kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Waŋu galeŋ ʒéénécmimu niŋ ménda wammu. Galeŋ momacguc sac kecʒac imi mia Kristo. ");
INSERT INTO kgf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Onarunec kuneŋginanéŋ tosara ionac weleŋ qeqe ic wammu. ");
INSERT INTO kgf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Méŋnéŋ méŋ eŋeya niŋac niŋu eŋu imi memamimac. Méŋnéŋ méŋ eŋeya niŋac niŋu mamac imi meemmimac. ");
INSERT INTO kgf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Saecginaguc, ini héna acac kiwi ic ʒéma Farisaio ic! Ini ikoc ic. Ic embac ionac kicginaiguc ini kurumeŋac héŋgaleŋ ama areŋa yandawac naguya imi héʒicgéma namma eŋaŋ ménda keremma ic tosara kerembiŋ ʒé wanʒu imi imuhucyanec ménda wai énécmigic kereŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Ménda hezac.) ");
INSERT INTO kgf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Saecginaguc, ini héna acac kiwi ic ʒéma Farisaio ic! Ini ikoc ic. Ini ewa qeri meleŋ meleŋ ic momacguc mihicŋiwiŋ ʒé baec ʒéma konduŋ tiricma keŋanʒu, néŋ méŋnéŋ ewaya meleŋu wagicma mebirigic sécgina onogicma geric siawac buŋa waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Saecginaguc, ini ic kiwa, kicgina hilichilicgia! Ini yomuhuc ʒéanʒu; Ocmuŋiguc koroma ʒéselimuiguc héla qahac wammac, néŋ soukiwa goli ocmuŋiguc hezac imuaru koroma ʒéselimuiguc imi ac iminéŋ sipacgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ic qelaŋa ʒéma kic hilic ini! Némac iwawainéŋ kuneŋ wanʒac? Goli me goli météré mianʒac ocmuŋ imi mia? ");
INSERT INTO kgf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Waŋu méŋ yomuhuc ʒéanʒu; Ʒaki téréyaiguc koroma ʒézé seli ac ʒéyu héla qahac wammac, néŋ ʒaki téréya qahaiguc haihaiya sese imuac koroma ʒéseliyu ac iminéŋ sipacgémimac. ");
INSERT INTO kgf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kic hilic ini, némac iwawainéŋ kuneŋ wanʒac? Sese me sese météré mianʒac ʒaki téréya imi mia? ");
INSERT INTO kgf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Imuac méŋnéŋ ʒaki téréyaiguc koroma ʒéselimaciguc ʒaki téréya ʒéma iwawai mocʒoŋ imuac qahaiguc hezac imuac momacnec koroma ʒéselizac wammac. ");
INSERT INTO kgf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Waŋu méŋnéŋ ocmuŋiguc koroma ʒéseliyec imi ocmuŋ ʒéma méŋ ocmuŋiguc kecanʒac iorac muru koroma ʒéseliyec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Waŋu méŋnéŋ méŋ kurumeŋiguc koroma ʒéselimac imi Anutuac tatac ʒéma imuac qahaiguc tacanʒac i acguc momacnec koroma ʒéselizac tanec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Saecginaguc, ikoc ic ini, héna acac kiwi ic ʒéma Farisaio ic! Ini miŋsupe ʒéma ʒuaʒua hénia hénia imi méndéŋgic méra éréhéc waŋu imuacnec momacguc Miŋ Kewuac buŋa haianʒu. Waŋu néwécgeŋa héna acac héla yéwéria tosara, kekec solaŋa ʒéma goi héihéi ʒéma ninʒéŋ ninʒéŋ imi waidacgic. Waŋu méŋ néwécgeŋawac tohoma méŋ néwécgeŋawac héŋacya ménda memuac heyec. ");
INSERT INTO kgf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ic kiwa, kicgina hilichilicgia! Ini gisic iwawai kaiwe momacguc kecma humumia imuhucya imi Anutuac gésima giligic keŋanʒu, néŋ kamele yaŋ kuneŋ yanda imuhucya imi eŋaoc hémbaoc wamma ɋécgé énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Saecginaguc ikoc ic, héna acac kiwi ic ʒéma Farisaio ic ini! Ini ʒéic sokoc séwéla sac ʒuacma imuac qeriaiguc imi hémbaoc ʒéma séwiac siŋ imi tigic kuaya qeanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisaio ic, kicgina hilichilicgia! Ini sokoc ʒéma ʒéic imuac qeria imi walac ʒuacsorocgéna séwéla imuhucyanec lalacnec wammac. ");
INSERT INTO kgf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Saecginaguc ikoc ic, héna acac kiwi ic ʒéma Farisaio ic ini! Ini imi kic suaŋ mandéc ooya ésécnec séwéla imi héŋsoroc sorocgia, néŋ qeriginaiguc ic humumia ionac sicgina ʒéma iwawai gizoŋ bazoŋa hénia hénianéŋ kuaya qema hezac. ");
INSERT INTO kgf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ini imuhucyanec séwiginanéŋ ic kicginaiguc solaŋanima kecʒu, néŋ qerigina imi ikoc ʒéma héna ac logilogi imi koya qema hezac. ");
INSERT INTO kgf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Saecginaguc ikoc ic ini, héna acac kiwi ic ʒéma Farisaio ic! Ini kua meme ic ionac kic suaŋ meyacgéma ic solaŋa niŋɋeli énécmimiawac iwawai imi hiabianec meʒericma kumugic naŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Imuhuc wamma ini yomuhuc ʒéanʒu; Yanda hécnina kecgic nalé imuaru kecbiŋnec ieneŋ kua meme ic unugic toroqema méranina ménda énécmiwiŋnec. ");
INSERT INTO kgf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ini haka imuhuc wamma eŋaoc kua meme ic unuaŋgic ionac ɋelihécgina kecʒu imuac hénia imi kawéya qema ʒéasari amuzu. ");
INSERT INTO kgf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Yanda hécgina képésic waŋgic imuac séciguc waŋgic kuaya qeyu! ");
INSERT INTO kgf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mokoleŋ, qaté mokoleŋ imuac ɋeli ini, dimuhuc geric siawac buŋa ʒétecgé énécmimia imuacnec qiʒiʒiŋgéma ogicma kemmu? ");
INSERT INTO kgf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Imuac mia ni nenaoc onac muru kua meme ic ʒéma niŋtegic qiŋtegic ic ʒéma héna acac kiwi ic imi méli énécmiwa hagic ionarunec tosara unuhumugic tosara iciguc unuhumugic tosara tocgotocgo amaginaiguc kémbiŋnéŋ unuma tauŋ méŋ igucnec tauŋ méŋu ununesi waŋ énécmima kemmu. ");
INSERT INTO kgf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Imuac niŋac ic solaŋa Abelac sac igucnec hénima éréma ocmuŋ téréya ʒéma ʒaki téréya sucgiraiguc qegic humuyec Bakaraiawac naŋa Ʒarakiawac sac mayec nalé imuac suraiguc baeciguc sac solaŋa madarec imuac kitiwa mocʒoŋ onac muru liliŋgéma hamac. ");
INSERT INTO kgf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ni hélacnec téŋgéŋ énézéwa, haka imuac bakia mocʒoŋ hicŋisai youmi onac muru liliŋgéma hamac. ");
INSERT INTO kgf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yerusalem, Yerusalem, kua meme ic unuhumuma, méli énécmiyu hahaya imi hocnéŋ énérianʒaŋ. Kuruc neŋgianéŋ merachéra qeŋgaŋanéŋ tiʒoʒo énécmianʒac ésécnec neŋ hatac dahec guac ɋelihécga tocgé énécmimaŋ ʒé waŋi? Waŋu ini imuac ewa siŋsiŋ ménda waŋaŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Héŋgic imuac niŋ amagina imi kisia wandacʒac. ");
INSERT INTO kgf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ʒéwa niŋgic, ini hocnémma keŋkecma keŋkecgic naléya ducŋiyu némma yomuhuc ʒému; Ohec wahec, Miŋninawac qaraiguc hahaya! ");
INSERT INTO kgf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesunéŋ ocmuŋ téréya igucnec mama keŋu tohotoho ichéra ieneŋ ocmuŋ téréya ézégic hémmac niŋac iwaru hagic. ");
INSERT INTO kgf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Imuhuc waŋgic inéŋ ac yomuhuc melemma énézéyec; Hélacnec énézéwa niŋgic; Ini iwawai imi mocʒoŋ hia hénʒu? Waŋu kecma imi mocʒoŋ héʒéŋgégic madaru hoc méŋnéŋ hoc méŋac qahaiguc ménda hemac. ");
INSERT INTO kgf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Waŋu Yesunéŋ Oliwa ic baec boŋaiguc emma taru tohotoho ichéra eŋacnec éléŋnec hama ʒégic; Ʒéna ninni. Némac naléiguc haka imi hicŋimac. Waŋu guac hahagawac ʒéma baec yomuac nalé tetecgiawac séséc imi dimuhuc hicŋiyu hémbiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Imuhuc ʒégic Yesunéŋ yomuhuc énézéyec; Kecma méŋnéŋ ikoc ménda waŋ énécmimu niŋac galeŋ memu. ");
INSERT INTO kgf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ic sasalanéŋ nuac qacnaiguc hama Ni Kristo mianéŋ ʒéma ic embac sasala ikoc waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Waŋu yaré hélawac suruc ʒéma imuac luhuc ac momacnec nimmu. Waŋu auriwu niŋac galeŋ mema kecmu. Iwawai imuhucya kileŋdac hicŋimacac hezac, néŋ imi tetecgia qahacnec. ");
INSERT INTO kgf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Baec méŋac ic embac ieneŋ yacma baec méŋac ic embac haʒéc waŋ énécmimu. Héŋgaleŋ ama méŋac ic embac ieneŋ yacma héŋgaleŋ ama méŋac ic embac haʒéc waŋ énécmimu. Waŋu baera baeraiguc béti hicŋiyu naŋ memac. ");
INSERT INTO kgf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Waŋu haka imi mocʒoŋ aʒi kikiyawac hénihénia. ");
INSERT INTO kgf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Waŋu nalé imuaru ic embac eneŋ ini ʒérabéraiguc onopocma unuhumumu. Waŋu ini nuac qacna niŋac wamma baec séc ic embac eneŋ haʒéc waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Waŋu nalé imuaru ic embac sasalanéŋ manam batuciguc mama unumac. Waŋu eŋaoc hésa amaiguc opocamuma haʒéc waŋamumu. ");
INSERT INTO kgf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Waŋu kua meme ic ikora sasala hicŋima ic embac sasala ikoc waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Waŋu héna ac logilogi haka imi saiyu ic embac sasala ionac goi héihéigina iminéŋ saŋgeŋ qedacmac. ");
INSERT INTO kgf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Waŋu méŋnéŋ méŋ naŋseligiyu tetecgia hayu késayu kekec hémbénaŋa kecmac. ");
INSERT INTO kgf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Waŋu kurumeŋac héŋgaleŋ amawac buŋa suruc hiabia iminéŋ baec séc ic embac ionac muru ʒésaigic kendacmaguc imuaru mia nalé tetecgia hamac. ");
INSERT INTO kgf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Imuac niŋ ini kua meme ic Danielnéŋ ʒéyec séc Biria miŋina iwawai mebirianʒac iminéŋ ocmuŋ téréyaiguc naŋu hémma niŋtegicmu. (Olonʒu ini hénia imi niŋ asarimu.) ");
INSERT INTO kgf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nalé imuaru Yuda baeciguc kecmu imi eneŋ baec boŋaiguc néŋgacdacmu. ");
INSERT INTO kgf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Méŋnéŋ méŋ ama qahaiguc naŋkecmac imi iwawai ama qeriaiguc hezac imi memaŋ ʒé ménda mama emmac. ");
INSERT INTO kgf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Waŋu méŋnéŋ méŋ aiiguc kecmac imi maleku andiaiguc hezac imi memaŋ ʒéma ménda liliŋgémac. ");
INSERT INTO kgf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nalé imuaru imi embac hériginaguc ʒéma namu gumu énécmianʒu ionac muru yéwéri yanda hicŋi énécmima hemac. ");
INSERT INTO kgf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ini ʒéwelecmigic, kia naléya me Sabata naléiguc haka imi hicŋiwac niŋac. ");
INSERT INTO kgf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Némac niŋ nalé imuaru réwéri kuneŋ yanda hicŋimac. Réwéri imuhucya imi baec kurumeŋ ʒéyu hicŋiyec imuarunec éréma deguc méŋ ménda hicŋiyec. Waŋu imuac andiaiguc kecma muŋguc méŋ imuhucya ménda hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Waŋu nalé imi ménda mehotoŋiwacnec séwiguc ic mocʒoŋ humudacbunec. Waŋu gési énécmimia ionac niŋ wamma nalé imi meducŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Waŋu nalé imuaru méŋnéŋ méŋ énézéma Héŋgic, Kristo i you, me Kristo i erimi ʒégic, ménda ninʒéŋgému. ");
INSERT INTO kgf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kristo ikora ʒéma kua meme ic ikora sasala hicŋima séséc kuneŋ yanda ʒéma haka méréra memu. Waŋu wammuac séc waŋu gési énécmimia momacnec mesoho énécmiwiŋ ʒé batucgé énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ninʒu ni haka imi ménda hicŋiyunec walac énézézua. ");
INSERT INTO kgf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Imuac mia baec kisiaiguc Kristo hicŋima nanʒac ʒémuiguc ménda kemmu. Waŋu Kristo imi ama méŋac qeriiguc tacʒac ʒégic imi acguc ménda ninʒéŋgému. ");
INSERT INTO kgf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Piliticnéŋ néwéc Is iguc hicŋima néwécgeŋ Wes iguc kerenʒac ésécnec Icac Naŋawac hama hicŋi énécmimia imi tanec imuhucyanec wammac. ");
INSERT INTO kgf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Qamoc hezac imuaru kunta nei eneŋ tocgému. ");
INSERT INTO kgf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Qenʒeŋ manʒeŋ yanda imi tecgémac nalé idacmuaru imi kaiwe siŋidéŋgéyu maso acguc asaha qahac wammac. Waŋu ménni sikilu kurumeŋ igucnec tecgéma madacgic kurumeŋac kuhanéŋ hirimac. ");
INSERT INTO kgf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nalé imuaru Icac Naŋawac sésécnéŋ kurumeŋiguc wininiyu hémmu. Nalé imuaru baera baera ic embac eneŋ siacma qacma namma Icac Naŋanéŋ kuc yanda ʒéma kiwi asahaguc hosusuiguc mayu héndacmu. ");
INSERT INTO kgf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Inéŋ témuŋ hétéŋ yandaguc kua meme uŋahéra méli énécmiyu hamu. Hama gési énécmimia imi kurumeŋ néwéc néwéc baec waŋgoŋa kemboŋ qahac igucnec mocʒoŋ tocgé énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Fik icac séséc imi niŋareŋgému. Hawanéŋ dokuyaguc bébélacgia waŋu haréŋa hicŋiyu nalé geriwaguc ducŋizac imi niŋasarianʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Imuhucyanec ini haka imuhucya imi hicŋiyu héndacma Icac Naŋa hosucginu hama naguiguc nanʒac imi niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ni hélacnec énézézua. Hicŋisai youmi ménda qahac wandacmunec haka imi mocʒoŋ hicŋidacmac. ");
INSERT INTO kgf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Baec kurumeŋ qahac wammac, néŋ nuac ackuaʒéc imi ménda qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Waŋu imuac ai memeya ʒéma kaiwe kiwa imi ic méŋnéŋ ménda ninʒac. Kurumeŋac kua meme uŋa me Naŋa acguc ménda ninʒac, néŋ Maŋgoc eŋeyanec sac ninʒac. ");
INSERT INTO kgf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Icac Naŋawac hahaya imi Noawac naléiguc hicŋiyec ésécnec hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ic embac eneŋ nene ʒéma waiŋ doku neʒéléléŋ wamma ic embac meamumanec kecgic doku ɋaoŋ hicŋiyu Noanéŋ ʒéiciguc eŋec. ");
INSERT INTO kgf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ic embac eneŋ ménda niŋasarimanec kecgic doku ɋaoŋ luma kisaŋénécmima keŋec. Icac Naŋawac hahaya imi acguc imuac séciguc hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nalé imuaru ic éréhéc aiiguc keric méŋ wagicma méŋ waiyu tacmac. ");
INSERT INTO kgf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Embac éréhéc hoc hilaŋanéŋ héla qésémma taric méŋ wagicma méŋ waiyu tacmac. ");
INSERT INTO kgf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Miŋ Kewuginanéŋ némac naléiguc hamac imi ini ménda ninʒu imuac ini ʒenʒeŋ ɋeli ɋeli kecmu. ");
INSERT INTO kgf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ini hénia yomuhuc niŋanʒu; Ama méŋac miŋinanéŋ némac naléiguc kowu nene eneŋ hamu imi nimbacnec ʒenʒeŋ ɋeli ɋeli keru ama imi ménda héʒéŋgéwunec. ");
INSERT INTO kgf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Waŋu ini acguc ʒéréŋ qéréŋ wamma kecmu. Ini ménda nimmanec kecgic Icac Naŋanéŋ hamac. ");
INSERT INTO kgf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Mérénéŋ weleŋ qeqe solaŋa ʒéma niŋtegic qiŋtegicyaguc waŋu gésimiyu miŋinawac murunec amayawac héna géséhéra énépésima naléya méndacma nene yaka méndéŋ énécmimac? ");
INSERT INTO kgf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Miŋinanéŋ hama weleŋ qeqe ic imi haka imuhuc wamma keru hémmaciguc weleŋ qeqe iwac muru mériaŋ hemimac. ");
INSERT INTO kgf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ni hélacnec énézézua, imuhuc waŋu miŋinanéŋ iwawaiya mocʒoŋ weleŋ qeqe iwac mériaiguc haimidacmac. ");
INSERT INTO kgf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Néŋ weleŋ qeqe biria kecma qerianéŋ miŋna imi focdac ménda hamac ʒéma, ");
INSERT INTO kgf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ai momachéra unuhéi wamma alahéra iniguc doku seli nema kecmac imi ");
INSERT INTO kgf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nalé méŋ ménda nimma kekera imuaru, waŋu kaiwe kiwa méŋ ménda niŋtegirec imuaru weleŋ qeqe iwac miŋinanéŋ hamac. ");
INSERT INTO kgf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hama elicgémima ikoc ic ionac séciguc bakia meleŋ miyu imuaru ewa biric wamma siacma ʒéra aric aric kima kecmac. ");
INSERT INTO kgf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kurumeŋac héŋgaleŋ ama imi embac seraŋa méra éréhécnéŋ eu buŋagina mihicŋiwiŋ ʒé kifagina késama keŋgic ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Waŋu ionac murunec embac seraŋa méra méŋ imi qelaŋa, waŋu embac seraŋa méra méŋ imi niŋtegic qiŋtegic ginaguc. ");
INSERT INTO kgf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Qelaŋa ieneŋ kifagina megic, néŋ dokuya ménda mema keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Waŋu embac niŋtegic qiŋtegic ginaguc ieneŋ imi kiruŋiguc dokuya tima kifaginaguc momacnec késama keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Waŋu eu buŋagina imi naléya mehorugima éséŋ éséŋ hayu embac eneŋ mocʒoŋ gaunéŋ qéléléŋgé énécmiyu mama hegic. ");
INSERT INTO kgf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hegic siŋi namuŋaiguc qac méŋ yomuhuc hicŋiyec; Héŋgic, eu buŋagina hazac! Focdac mama hama héihérémigic. ");
INSERT INTO kgf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Imuhuc ʒégic embac seraŋa eneŋ mocʒoŋ ɋelima yacma ʒéréŋ qéréŋ wamma kifagina mindiŋigic. ");
INSERT INTO kgf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Waŋu qelaŋa ieneŋ niŋtegic qiŋtegic ginaguc ionac yomuhuc énézégic; Kifanina imi békémaŋ ʒé wanʒac imuac dokugina kisima méndéŋ nénécmigic. ");
INSERT INTO kgf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Imuhuc ʒégic embac niŋtegic qiŋtegic ginaguc eneŋ yomuhuc melemma énézégic; Méndémma haini ménda sécgé nénécmiyu neŋaŋ mocʒoŋ osiwiŋ niŋac. Imuac ini qisicnec amaiguc kemma sécgina boŋ megic. ");
INSERT INTO kgf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Imuhuc ʒégic ieneŋ kifa dokuya boŋ mewiŋ ʒéma kemma kecgicnec suraiguc eu buŋa imi haréyu embac seraŋa ʒéréŋ qéréŋ wamma kecgic ieneŋ eu buŋaginaguc momacnec ʒammaréŋ ariaciguc kereŋgic naguya héigic. ");
INSERT INTO kgf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Imuac andiaiguc embac seraŋa tosara hama ʒégic; Miŋ Kewunina Miŋ Kewunina nagu imi aunénécmina. ");
INSERT INTO kgf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ʒégic ʒéyec; Hélacnec énézéwa niŋgic neŋ ini ménda niŋénécmizua. ");
INSERT INTO kgf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hénia imuac niŋ ini ʒenʒeŋ ɋeli ɋeli kecmu. Ini imi némac naléiguc icac naŋa hamac imuac kaiweya ʒéma kaiwe kiwa ménda ninʒu. ");
INSERT INTO kgf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Imi mia ic méŋnéŋ baec méŋu kemmaŋ ʒé weleŋ qeqe ichéra unuruma iwawaiya hai énécmiyec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ai memeac sécginawac énécmima méŋac imi goli soukiwa méra méŋ, méŋac imi éréhéc, méŋac imi momacguc énécmima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Méra méŋ meyec inéŋ focdac kemma soukiwa iminéŋ iwawai boŋ mema nénnagémba ai mema méra méŋac séc mesaiyec. ");
INSERT INTO kgf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Éréhéc meyec i acguc imuhucyanec wamma éréhécac séc mesaiyec. ");
INSERT INTO kgf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Waŋu momacguc meyec inéŋ kemma baec éséma miŋinawac soukiwa imi musaŋgéyu heyec. ");
INSERT INTO kgf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Nalé horua tecgéyu weleŋ qeqe ionac miŋginanéŋ liliŋgéma hama iniguc momacnec tacma aigina dimuhuc megic imuac hénia ʒé qesiniŋ waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Méra méŋ meyec inéŋ méra méŋac séc mesaima mema hama yomuhuc ézéyec; Miŋ Kewu gi nuaru goli soukiwa méra méŋ nénnec, hénna neŋ méra méŋ muŋguc mesaima mezua. ");
INSERT INTO kgf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Imuhuc ʒéyu miŋinanéŋ ʒéyec; Hiabia waŋnec, weleŋ qeqe hiabia ʒéma ic héla, gi ai komora imi hiabianec menec, imuac ni iwawai sasala haigémba guac miŋga nuac ségiségiiguc toroqe nénna. ");
INSERT INTO kgf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Soukiwa éréhéc meyec i acguc hama ʒéyec miŋna nuaru éréhéc nénnec, hénna you muŋguc éréhécac séc mesaizua. ");
INSERT INTO kgf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ʒéyu miŋinanéŋ ʒéyec; Hiabianec waŋnec weleŋ qeqe hiabia ʒéma ic héla, gi ai komora hiabianec menec imuac neŋ iwawai sasala haigémba guac miŋga nuac ségiségiiguc toroqe nénna. ");
INSERT INTO kgf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Waŋu momacguc meyec inéŋ hama yomuhuc ʒéyec; Miŋna gi imi ic selia, ménda himicma mema, ménda méndéŋ énécmima tocgoanʒaŋ imi ni niŋasariyi. ");
INSERT INTO kgf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Imuac ʒénéŋ hiri wamma kemma guac soukiwa imi baec qeriaiguc musaŋgéwa heyec. Guac iwawaiga yomi hénna. ");
INSERT INTO kgf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Imuhuc ʒéyu miŋinanéŋ melemma ʒéyec; Weleŋ qeqe biria méʒé titigaguc, gi nuac ninna ménda himicma mema, ménda méndéŋ énécmima tocgoanʒua tanec waŋec? ");
INSERT INTO kgf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Imuhuc ninneciguc gi nuac soukiwa imi kileŋdac hofi amaiguc haiwaŋnec ni liliŋgéma hama soukiwa neŋgocya ʒéma sisia momacnec mewinec. ");
INSERT INTO kgf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Imuhuc ʒéyu tecgéyu ai ic kiwa yomuhuc ézéyec; Momacguc iwarunec wagicma méra éréhéc késa kecʒac iwac mina. ");
INSERT INTO kgf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iwawai hemimia inéŋ méŋac késayu kindindiŋa wammac. Waŋu ménda hemimia inéŋ komodia hemiyec imi acguc wagiru qahac wandacmac. ");
INSERT INTO kgf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Weleŋ qeqe eŋomia yomi séŋgaŋgeŋ siŋi tunumaŋiguc nesigic hiŋgacma imuaru ewa biric wamma siacma ʒéra aric aric kima kecmac. ");
INSERT INTO kgf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Icac Naŋa eŋeya kiwi asahaguc kua meme uŋa mocʒoŋ iniguc liliŋgéma hama eŋeya tatac asahaguc imuaru tacmac. ");
INSERT INTO kgf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tacma baera baera ic embac hénia hénia eŋeya kic ségériaiguc tocgé énécmima rama galeŋnéŋ rama ʒéma noniŋ gési énécmianʒu ésécnec gési énécmiyu eŋac eŋac nammu. ");
INSERT INTO kgf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Gési énécmima rama imi héiyaiguc noniŋ imi kanayaiguc onopocmac. ");
INSERT INTO kgf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nalé imuaru ic kewunéŋ héiyaiguc nanʒu ionac yomuhuc énézémac; Nuac Maŋgocnawac mériaŋ énécmimia ini haréma héŋgaleŋ ama areŋa yanda baec kurumeŋ ʒéyu hicŋiyec nalé imuaru bec onac niŋ wamma walac meyecac hezac imi mératéc késamu. ");
INSERT INTO kgf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Neŋ yaka niŋ humuwa gumu néŋgic. Waŋu doku niŋ humuwa doku hima néŋgic neyi. Waŋu ic kiaŋ kecba héihéré néŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Maleku niŋac hocba maleku héinéŋgic. Hafi niyu néŋgaleŋ wannéŋgic. Hésa amaiguc kecba hama néŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Imuhuc ʒéyu ic embac solaŋa eneŋ ʒégic; Miŋ Kewu nini némac naléiguc gi yaka niŋ humuna gémma gumugéŋiŋ? Némac naléiguc gi doku niŋ humuna gémma doku hima géŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Némac naléiguc gi ic kiaŋ kecna gémma héihéré géŋiŋ? Némac naléiguc gi maleku niŋac hocna gémma maleku héigéŋiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Némac naléiguc hafi giyec me hésa amaiguc tacna hagéŋiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Imuhuc ʒégic ic kewunéŋ melemma ʒémac; Ni hélacnec énézéwa niŋgic, ini ninʒéŋ ninʒéŋ dacmuna hécna you nanʒu ionarunec mamayagina méŋac iwawai wammigic imi nuac waŋgic tanec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Waŋu inéŋ kanayaiguc naŋgic ionac yomuhuc énézémac; Saecginaguc, ini wainémma Biria miŋina ʒéma iwac kua meme uŋahéra ionac niŋac geric hémbénaŋa walac meyu heyecac hezac imuaru hiŋgacgic. ");
INSERT INTO kgf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ni yaka niŋ humuwa ini yaka méŋ ménda gumu néŋgic. Doku niŋ humuwa ini doku méŋ ménda hima néŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ic kiaŋ kecba ménda héihéré néŋgic. Maleku niŋac hocba maleku méŋ ménda héinéŋgic. Hafi niyec me hésa amaiguc tacba ménda hama néŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Waŋu ieneŋ imuhucyanec melemma ʒému; Miŋ Kewu némac naléiguc génni yaka niŋ humunec me doku niŋ wannec me ic kiaŋ wamma hanec me séwi usu niŋac wannec me yaŋ hafi giyec me hésa amaiguc tacna méra ménda géŋiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Imuhuc ʒégic Ic kewunéŋ yomuhuc melemma ʒémac; Ni hélacnec énézéwa, mamaya yomi ionarunec momacguc yomuac iwawai ménda wammigic imi mia nuac niŋ ménda waŋgic wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ini ʒérabéra tetecgia qahaciguc kereŋgic, ic solaŋa yomi eneŋ kekec hémbénaŋaiguc keremmu. ");
INSERT INTO kgf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesunéŋ ac imi mocʒoŋ ʒédaru tecgéyu tohotoho ichéra yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ini ninʒu ésécnec ai meme éréhéc hama keŋu nagu sacyaguc ogicma keŋkeŋa imuac kendoŋ wammac. Waŋu Icac Naŋa ic héŋgeŋa wéndaraiguc qemu niŋac wamma wai énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Waŋu nalé imuaru hofac oo ic eŋeŋa ʒéma ic embac ionac galeŋ hécgina ieneŋ hofac oo ic kiwagina Kayafawac ama kewuyaiguc togégic. ");
INSERT INTO kgf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tocgéma ikoc wammima Yesu imi éléŋnec késama qewiŋ ʒéma sasaŋgiaiguc eminiŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Eminimma yomuhuc ʒégic; Kendoŋ yandaiguc imuhuc ménda wambiŋ, ic embac ieneŋ qeweloŋ qema qetali nénécmiwu niŋac. ");
INSERT INTO kgf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Waŋu Yesunéŋ Betania ama areŋaiguc séwi wizi ic ʒémimia Simonac amaiguc tarec. ");
INSERT INTO kgf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tacma nene neyu embac méŋnéŋ iwac muru kemma haléc héméŋa hiabia, boŋa yanda imi iwac oruhaiguc qocgéma naecmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Imuhuc waŋu tohotoho ichéra ieneŋ héŋgic qerigina biriyu ʒégic; Némac niŋac imi eŋ audacʒac? ");
INSERT INTO kgf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iminéŋ boŋa eŋeŋa mema ic maqeqeya énécmimacac séc wambacnec. ");
INSERT INTO kgf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Imuhuc ʒégic Yesunéŋ bec niŋtegicma yomuhuc énézéyec; Ini némac niŋac embac ʒéhési wammizu? Embac imi iwawai hiabia waŋ nénʒac. ");
INSERT INTO kgf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ic maqeqeya imi nalé séc iniguc kecmu, néŋ ni mia nalé séc iniguc ménda kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Embac imi haléc héméŋa hiabia séwinaiguc qocgé némma humuwa téŋgénémmu imuac mia ʒéréŋ qéréŋ waŋ nénʒac. ");
INSERT INTO kgf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ni hélacnec énézézua, baecac qahaiguc imuac me imuac buŋa suruc hiabia yomi ʒéauma kemmu séc haka embac yominéŋ wanʒac imi acguc énézégic niŋɋelimimu. ");
INSERT INTO kgf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nalé imuaru tohotoho ichéra 12 ionarunec méŋ qara Yuda Kariot inéŋ hofac oo ic kiwa ionac muru kemma qesima énézéyec; ");
INSERT INTO kgf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ni Yesu méraginaiguc opocba némac iwawai némmu. Imuhuc énézéyu ieneŋ soukiwa siliwa 30 migic. ");
INSERT INTO kgf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Waŋu ic imi nalé imuarunec Yesu méraginaiguc opocmaŋ ʒé naléyawac horec. ");
INSERT INTO kgf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Saméŋ yisya qahac imuac kendoŋ ducŋiyu tohotoho ichéra eneŋ Seiyaiguc Yesu qesimima ʒégic; Nini deguc ama dimuaru nagu sacyaguc ogicma keŋkeŋa kendoŋ imuac yaka omézézéŋ waŋgémbiŋ? ");
INSERT INTO kgf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Imuhuc ʒégic yomuhuc énézéyec; Ini ama areŋ yandaiguc keremma ic méŋac yomuhuc ézému; Kiwi icninanéŋ yomuhuc ʒézac; Naléna ducŋizac imuac niŋ tohotoho ichécna iniguc nagu sacyaguc ogicma keŋkeŋa imuac kendoŋ imi guac amaiguc tacmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Waŋu tohotoho ichéra eneŋ Yesu ʒéyec séc nagu sacyaguc ogicma keŋkeŋawac kendoŋ imuac nene imi memézézéŋ waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ama siŋiyu Yesu imi tohotoho ichéra 12 iniguc momacnec nene newiŋ ʒé tacgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nene nema tacma yomhuc énézéyec; Ni hélacnec énézézua, onac murunec méŋnéŋ andé numac. ");
INSERT INTO kgf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Imuhuc ʒéyu tohotoho ichéra ieneŋ ewa biric kuneŋ yanda wamma eŋac eŋac qesimima kemma yomuhuc ʒégic; Miŋ Kewu, hélacnec ni qahac, imi ni me? ");
INSERT INTO kgf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Waŋu inéŋ yomuhuc énézéyec; Niguc momacnec ʒéiciguc yaka tinduŋgézic inéŋ mia andé numac. ");
INSERT INTO kgf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Icac Naŋa imi kiwi téréyaiguc ooyawac hezac séc kemmac, néŋ Icac Naŋa andé qemac inéŋ saecyaguc wammac. Ic imi ménda hicŋiwacnec hia wambacnec. ");
INSERT INTO kgf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Imuhuc ʒéyu Yuda kecma Yesu andé qeyec inéŋ yomuhuc melemma ʒéyec; Kiwi ic, hélacnec ni qahac, imi ni me? Imuhuc ʒéyu yomuhuc ʒéyec; Geŋgaoc imuhuc ʒézaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Waŋu yaka nema tacgic Yesu saméŋ mema mozoc ac ʒéma méndémma tohotoho ichéra énécmima ʒéyec; Mema negic, yomi imi nuac séwi busuna. ");
INSERT INTO kgf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Imuhuc wammaguc sokoc mema ewa hia ac ʒéma énécmima ʒéyec; Ini mocʒoŋ yomi negic. ");
INSERT INTO kgf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yomi sisipac acac sacna. Képésic wai énécmimaŋ ʒé ic embac sasala onac niŋac pocgé énécmimia. ");
INSERT INTO kgf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ʒéwa niŋgic, ni deguc muarunec waiŋ ic hésawac gocmia yomi muŋguc ménda nema kecma nalé imuhucgeŋ Maŋgocnawac héŋgaleŋ ama areŋa yandaiguc iniguc waiŋ ɋeliawac nemaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Waŋu mepé qepési legic méŋ héigic tecgéyu yacma Oliwa baec boŋaiguc keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Waŋu imuaru kemmanec Yesunéŋ yomuhuc énézéyec; Ac méŋ yomuhuc ooyawac hezac; Ni rama galeŋgina imi qewa rama tuŋa imi qeqelalaŋ qedacmu. Imuac niŋ deguc siŋiya ini mocʒoŋ wainémma kendacmu. ");
INSERT INTO kgf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Waŋu humuc igucnec yacmaguc neŋ mia kiwa meénécmima Galilaia baeciguc walac kemmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Imuhuc ʒéyu Petoronéŋ ara melemma ʒéyec; Tosara eneŋ mocʒoŋ waigémbu, néŋ ni méndagucnec waigémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Imuhuc ʒéyu Yesunéŋ ʒéyec; Ni hélacnec gézézua, siŋi yomuaru kuruc ménda qarunec gi hatac haréwéc qaecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Imuhuc ʒéyu Petoronéŋ ʒéyec; Giguc humuwic ʒé hia humuwic, ni ménda qaecgé gémmaŋ. Inéŋ imuhuc ʒéyu tohotoho ichéra tosia mocʒoŋ imuhuyanec ʒédacgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Imuhuc ʒéma kemma kisi méŋ qara Gesemane imuaru keremma Yesunéŋ tohotoho ichéra yomuhuc énézéyec; Ni eri kemma ʒéwelec wamma kecbanec ini yomuaru tackecmu. ");
INSERT INTO kgf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Imuhuc ʒéma Petero ʒéma Ʒebedaioac naŋhéréra énépésima keŋec. Kemma niŋyéwérima ewa biric waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Waŋu énézéma ʒéyec; Ewa qerinanéŋ humucac déciguc hosuc gémacac séc ewa biric kuneŋ yanda wanʒac. Imuac ini you niguc kic ɋeli tacmu. ");
INSERT INTO kgf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Imuhuc ʒéma eŋeyaoc komodia méŋ kemma mama sicgéyu kic ségéria baeciguc mayu yomuhuc ʒéma ʒéwelerec; Maŋgocna, hia wawaŋawac séc waŋu qenʒeŋ manʒeŋ sokoc yomi ni nogicma kemmac. Waŋu nuac siŋnawac qahac, néŋ geŋga siŋgawac séc wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Waŋu imuacnec liliŋgéma tohotoho ichéra ionac hama iniru gau hekecgic Petoro qesimima ʒéyec; Ini niguc kaiwe kiwa momacgucac séc ʒenʒeŋ ɋeli ɋeli kecmuac séc qahac waŋec? ");
INSERT INTO kgf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Manambatuciguc maunuwac niŋac, kic ɋeli kecma ʒéwelec waŋgic. Ewa qeriginanéŋ efizac, néŋ séwiginanéŋ kuha qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Imuhuc ʒémaguc muŋguc kemma yomuhuc ʒéweleru hatac éréhéc waŋec; Maŋgocna, qenʒeŋ manʒeŋac sokoc yomi ménda newaguc ménda nogicmacac hezaciguc, guac ewa siŋga seligimac. ");
INSERT INTO kgf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Waŋu liliŋgéma iniru kicgina yéwéria yanda waŋu gaugina hekecgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Imuhuc inicma onopocma muŋguc kemma ac imuacnec ʒéma welerec. Weleru hatac haréwéc waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Weleru tecgéyu liliŋgéma tohotoho ichéra ionac hama énézéyec; Ini gaugina hezunec? Héŋgic nalé bec ducŋiyu Icac Naŋa imi andé qema képésic ic ionac méraginaiguc oporu emmac. ");
INSERT INTO kgf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yacgic kenni! Andé qeqe icna you hazac. ");
INSERT INTO kgf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ac imuhuc énézémanec naŋu, tohotoho ichéra 12 ionarunec méŋ, Yuda imi hayec. Waŋu i guc momacnec ic tuŋ yanda, hofac oo ic kiwa ʒéma galeŋ ieneŋ méli énécmigic tewi luacginaguc hagic. ");
INSERT INTO kgf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Waŋu andé qeqe ic iminéŋ séséc areŋ mindiŋidacma bec yomuhuc énézéyu nimma hagic; Ic méŋ kiric nemiwa imi mia ʒéma késamu. ");
INSERT INTO kgf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Waŋu ic imi focdac Yesuac muru hama Ohec wahec! Kiwi icna ʒéma kiric nemiyec. ");
INSERT INTO kgf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Imuhuc waŋu Yesunéŋ yomuhuc ézéyec; Ala, néma haka wammaŋ ʒé hazaŋ haka imuac mia wambésémaŋ. Imuhuc ʒéyu ic hagic imi eneŋ hama Yesu késagic. ");
INSERT INTO kgf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Imuhuc waŋgic Yesuguc naŋgic ionarunec méŋnéŋ méramma souya kupeŋa igucnec héréma hofac oo ic kuneŋac weleŋ qeqeya méŋac gezawa qeriru mayec. ");
INSERT INTO kgf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Imuhuc waŋu Yesunéŋ ʒéyec; Souga kupeŋaiguc haina hiŋgaru. Méŋnéŋ méŋ sougina hérému imi sou ʒéraiguc humudacmu. ");
INSERT INTO kgf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ini niŋgic neŋ Maŋgocna ézéwa degucdacmi kua meme uŋahéra tuŋ yanda 12 ogicma méli némmacac séc qahac wanʒac me? ");
INSERT INTO kgf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Waŋu neŋ imuhuc wambinec, ackuaʒéc téréyanéŋ imuhuc hicŋimac ʒézac iminéŋ dimuhuc héla héiwacnec? ");
INSERT INTO kgf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Imuhuc ʒéma ic tuŋ ionac yomuhuc énézéyec; Ini némac niŋac sac nene énépésianʒu ésécnec legic tewiginaguc hama népésiwiŋ ʒé wanʒu? Ni kaiweya kaiweya ocmuŋ téréyaiguc tacma ic embac ku énécmiaŋi, waŋu ini ménda népésigic. ");
INSERT INTO kgf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Waŋu haka yomi kua meme ic ionac kiwi imi héla héimac niŋac yomuhuc hicŋizac. Imuhuc ʒéyu tohotoho ichéra ieneŋ mocʒoŋ Yesu waimima néŋgacdacgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesu késagic ieneŋ héréma hofac oo ic kuneŋgina Kayafawac ama kewuyaiguc keŋgic. Waŋu imuaru mia héna acac kiwi ic ʒéma galeŋ eneŋ tocgéma tacgic. ");
INSERT INTO kgf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Waŋu Peteronéŋ andéginu Yesu lakec méndacmima hofac oo ic kuneŋgina iwac demiŋ qeriaiguc kereŋec. Keremma demiŋ galeŋ ionac sucginaiguc tetecgiaiguc dimuhuc wammimu imi hémmaŋ ʒé tarec. ");
INSERT INTO kgf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Waŋu hofac oo ic kiwahécgina ʒéma ic kiwa mocʒoŋ Yesu qehumuwiŋ ʒé ikoc ac tosara qemuac séc méŋ mihicŋiwiŋ ʒé hochoc ai megic. ");
INSERT INTO kgf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Waŋu héipuc ic ikora sasala wéséginaiguc hama naŋgic, néŋ ara méŋ ménda mihicŋigic. Waŋu imuac andiaiguc ic éréhéc wéséginaiguc hama naŋoc. ");
INSERT INTO kgf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Namma yomuhuc ʒéyoc; Ic yominéŋ yomuhuc ʒéyec; Ni Anutuac ocmuŋ téréya héwuratima ai meme haréwéc imuac qeriaiguc muŋguc memiʒicgémaŋac séc. ");
INSERT INTO kgf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Imuhuc ʒéyic nimma hofac oo ic kuneŋ imi yacma Yesu qesimima ʒéyec; Ac bakia méŋ ménda ʒéwésémaŋ? Haʒéc waŋgémma ʒézaoc ac imi némac ac? ");
INSERT INTO kgf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Qesiyu Yesu imi ara qaiyu naŋu hofac oo ic kuneŋginanéŋ ézéma ʒéyec; Anutu kerecac kecʒac iwac qaciguc hélacnec ʒéselimaguc ʒéna ninni, Gi imi Anutuac Naŋa Kristo me qahac? ");
INSERT INTO kgf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Qesiyu Yesunéŋ melemma ʒéyec; Geŋ mia bec ʒézaŋ, waŋu ʒéwa niŋgic andiaiguc Icac Naŋa ni imi Kuc buŋayaguc iwac méra héi igucnec tacma kurumeŋac hosusu qahaiguc namma hawa néndacmu. ");
INSERT INTO kgf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Imuhuc ʒéyu hofac oo ic kuneŋginanéŋ malekuya muʒuracgéma ʒéyec; Ic yomi Anutu ʒébiri mizac, imuac némac niŋac muŋguc héipuc ic tosara mihicŋiwiŋ ʒé wambiŋ? Ninʒu, eŋeyaoc mia Anutu ʒébiri miyu nindacʒu. ");
INSERT INTO kgf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Imuac ini dimuhuc ninʒu? Qesiyu ieneŋ ʒégicnéŋ; Ic yomi humucac buŋa. ");
INSERT INTO kgf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Waŋu Yesuac kic ségériaiguc sépécgé héima méragina misicgéma qegic. Waŋu tosaranéŋ nekaŋaiguc otoma ʒégic; ");
INSERT INTO kgf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Gi Kristo wanʒaŋiguc ʒéhicŋina, mérénéŋ guzac? ");
INSERT INTO kgf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nalé imuaru Petero imi demiŋ qeriaiguc tarec. Taru weleŋ qeqe embac méŋnéŋ iwac muru hama ʒéyec; Gi acguc Galilaia ic Yesuguc kecnec. ");
INSERT INTO kgf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Waŋu inéŋ tacgic mocʒoŋ yanda ionac kicginaiguc qaecgéma ʒéyec; Gi némac arawac ʒézaŋ imi ni ménda niŋacgézua. ");
INSERT INTO kgf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Imuhuc ʒéma saŋgulaŋaiguc keŋu embac méŋnéŋ hémma ic embac imuaru naŋgic imi énézéma ʒéyec; Ic yomi Naʒarete ic Yesuguc kecaŋec. ");
INSERT INTO kgf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Imuhuc ʒéyu Peteronéŋ muŋguc ʒéselima ʒéyec; Ni ic imi ménda ninʒua. ");
INSERT INTO kgf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Imuhuc ʒémaguc komora méŋ naŋu tosara imuaru naŋgic ieneŋ hosuru kemma Petero ézégic; Hélawac gi ionac areŋ igucnec, némac niŋ acgawac taneranéŋ ʒéhicŋi génʒac. ");
INSERT INTO kgf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Imuhuc ʒégic inéŋ hénima saecgé amuma ʒéselima ʒéyec; Ni ic imi ménda nimmizua. Imuhuc ʒétecgéyu nalé idacmuaru kuruc qarec. ");
INSERT INTO kgf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Qaru Petero imi Yesunéŋ ac yomuhuc ézéyec imi niŋɋeliyec; Kuruc ménda qarunec hatac haréwécac séc ni qaecgé némbésémaŋ. Imuhuc niŋɋelima séŋgaŋgeŋ hiŋgacma siac howuc siac siarec. ");
INSERT INTO kgf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ama ewiaiguc hofac oo ic kiwahécgina ʒéma galeŋ eneŋ ewa momac wamma Yesu humuciguc opocbiŋ ʒé tocgéma eminiŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Waŋu ʒétecgémaguc dérécgéma héréma kemma baec galeŋ Pilatoac méraiguc opocgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nalé imuaru Yuda, Yesu andé qeyec inéŋ héŋu Yesu imi képésiraguc ʒéma ʒétecgégic niŋu ewaya liliŋgéyu nimbiri amuma siliwa soukiwa 30 imi hofac oo ic kiwahécgina ʒéma galeŋ ionac muru mema keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kemma yomuhuc énézéyec; Ni ic képésic qahac iwac sac haima boŋa mema képésic waŋi. Imuhuc ʒéyu ieneŋ imi nonac ai qahac geŋgaoc mindiŋina ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Imuhuc ʒégic siliwa soukiwa imi giliyu ocmuŋ téréyaiguc eŋu kemma eŋeya ewa sac neyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Waŋu hofac oo ic kiwa ieneŋ soukiwa imi medacma ʒégic; Soukiwa yomi imi sac boŋa, sokociguc haiwiŋ imi héna ac sigimac. ");
INSERT INTO kgf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Imuhuc ʒéma ewa momac wamma soukiwa iminéŋ kewuc meme ic méŋac baec méŋ ic kiaŋ ionac kicsuaŋ buŋawac boŋ megic. ");
INSERT INTO kgf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hénia imuac niŋac nalé imuacnec éréma hama deguc baec imuac Sac Baera ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Haka imuhuc hicŋiyu kua meme ic Yeremianéŋ ʒéyec ac yominéŋ hélaguc waŋec; Israel ic eneŋ boŋawac ʒéyec siliwa soukiwa 30 imi mema ");
INSERT INTO kgf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Miŋnanéŋ nézéyec ésécnec kewuc meme ic méŋac baec boŋa niŋac haimigic. ");
INSERT INTO kgf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Waŋu Yesu imi Pilatoac kiwaiguc naŋu qesimima ʒéyec; Gi ta Yuda ic ionac ic kewu me? Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Geŋgaoc ʒézaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Waŋu hofac oo ichécgina ʒéma galeŋ ieneŋ ac séwélaiguc haima ʒégic acgina ménda meleŋec. ");
INSERT INTO kgf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Waŋu Pilatonéŋ qesimima ʒéyec; Gi haʒéc waŋgémma héipuc ac sasala ʒézu imi ménda ninʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ʒéyu ara méŋac méŋ, ac bakia méŋ ménda ʒéyec. Imuhuc waŋu baec galeŋ imi kileŋ welicgéyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kendoŋ séc baec galeŋ iminéŋ ic embac ionac ewa siŋ tohoma hésa ic méŋ hulacmiyu hiŋgacaŋec. ");
INSERT INTO kgf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Waŋu nalé imuaru hésa ic méŋ qara keŋkeŋa kerec, iwac qara imi Baraba. ");
INSERT INTO kgf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Waŋu ic tocgodacma naŋgic Pilatonéŋ qesiénécmiyec; Mérac hulac énécmimaŋ niŋac wanʒu, Baraba me Yesu Kristo ʒéanʒu imi mia? ");
INSERT INTO kgf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ic imi Yuda ic ieneŋ Yesu eŋ nimbupuc wamma iwac muru opocgic imi niŋtegicma imuhuc qesiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Waŋu Pilato imi ʒégési tatacyaiguc tacmanec keru iniŋanéŋ ac haima ʒéyec; Gi ic solaŋa iwac mia haka méŋ ménda wammiwésémaŋ, ni deguc siŋia gau hémma iwac niŋac niŋyéwéri kuneŋ yanda mihicŋizua. ");
INSERT INTO kgf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Waŋu hofac oo ic kiwahécgina ʒéma galeŋ ieneŋ Baraba hulac énécmima Yesu qegic humumac niŋac ic embac tuŋaguc ʒéqafeŋ waŋ énécmima ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Waŋu baec galeŋnéŋ muŋguc qesiénécmima ʒéyec; Sucgira igucnec mérac mia onac niŋ wamma hulacmimaŋ ʒé wanʒu? Ʒéyu ʒégic; Baraba! ");
INSERT INTO kgf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ʒégic Pilatonéŋ énézéyec; Waŋu Yesu Kristo ʒémianʒu i deic wammimaŋ? Imuhuc ʒéyu mocʒoŋ ʒégic; Imi iciguc biriŋnéŋ qegic. ");
INSERT INTO kgf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Imuhuc ʒégic baec galeŋnéŋ muŋguc qesiénécmiyec; Némac képésic niŋ? Imuhuc ʒéyu ieneŋ muŋguc yanda qac gigilaŋgéma ʒégic; Iciguc qegic! ");
INSERT INTO kgf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Imuhuc waŋgic Pilatonéŋ mebélacgé énécmimaŋ ʒé osiyec, néŋ néwécgeŋa qeweloŋnéŋ hénima yacmaŋ ʒé waŋu ic embac kicginaiguc dokuguc méria ʒuacma ʒéyec; Iwac sac kitiwa imi eŋaoc huamu. ");
INSERT INTO kgf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Imuhuc ʒéyu, ic embac mocʒoŋ yanda melemma ʒégic; Iwac sac kitiwa imi meleŋna neŋaŋ ʒéma ɋelihécnina qacninaiguc eŋu. ");
INSERT INTO kgf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Imuhuc waŋgic Baraba imi ionac niŋ wamma hulacmima Yesu likuŋ ʒéragucnéŋ qegic iciguc qemu niŋac téŋgiŋ ic ionac méraginaiguc oporec. ");
INSERT INTO kgf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Imuhuc waŋu baec galeŋac téŋgiŋ ichéra ieneŋ Yesu wagicma baec galeŋac ama kewuya imuac demiŋ qeriaiguc emma ʒégic téŋgiŋ ic mocʒoŋ iwac muru hama lelecgéma naŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Waŋu séwi usuya mocʒoŋ hetecgéma maleku pésianec méŋ héimigic hiŋgarec. ");
INSERT INTO kgf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Hiŋgaru hésa waiyaguc imi misicgéma oruhaiguc haigic hiŋgarec. Waŋu uŋ qaulalea méŋ miyu méra héiyanéŋ késama naŋec. Imuhuc wammima wésiaiguc simiŋ héima ʒédesi wammima ʒégic; Ohec, Yuda ic ionac ic kewu! ");
INSERT INTO kgf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Imuhuc wamma sépécgé héimima uŋ qaulalea imi wagicma iminéŋ oruhaiguc qegic. ");
INSERT INTO kgf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Qema ʒédesi wammigic tecgéyu maleku pésiha imi hetecgéma eŋeya séwi usu imi héimima iciguc qewiŋ ʒé wagicma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wagicma kemma hénaiguc ic méŋ mihicŋigic qara Simon Kirene ama areŋ igucnec imi seliseli wammigic Yesuac ic héŋgeŋa wéndara wagicma huayec. ");
INSERT INTO kgf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Waŋu kemma baec méŋ qara Golgota (Neŋaŋ aciguc oruc sic) imuaru keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kemma imuaru waiŋ doku selia howuraguc mesohoma Yesu gumuwiŋ ʒégic nenimma waiyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Waŋu iciguc biriŋnéŋ qegic naŋu malekuya imi sumbic néma méndémma késagic. ");
INSERT INTO kgf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Waŋu mama tacma galeŋ memima kecgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Waŋu oruha hanecgeŋ héniaya yomuhuc ogic heyec; Yomi Yesu Yuda ic ionac ic kewu. ");
INSERT INTO kgf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Waŋu Kowu nene ic éréhéc imi Yesuguc momacnec iciguc uruma méŋ imi ic héŋgeŋa wéndara méria héiigucgeŋ, méŋ imi ic héŋgeŋa wéndara méria kanaiguc geŋ urugic naŋoc. ");
INSERT INTO kgf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Waŋu ic embac héna imuaru keŋha waŋgic imi eneŋ orucgina gilima ʒébiri migic. ");
INSERT INTO kgf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Geŋ mia Anutuac ocmuŋ téréya héwuratima muŋguc ai meme haréwécac qeriaiguc memiʒicgémaŋ ʒénec. Gi Anutuac Naŋa wanʒaŋiguc metecgé amuma ic igucnec mana. ");
INSERT INTO kgf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Waŋu hofac oo ichécgina ieneŋ acguc héna acac kiwi ic ʒéma qeria galeŋ iniguc momacnec imuhuyanec ʒébiri mima ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ic imi ic tosara aŋgéŋgina tiénécmiaŋec, néŋ eŋeya aŋgéŋa tiamumacac séc qahac wanʒac. Inéŋ mia Israel ionac Ic Kewu wanʒac, imuac ic igucnec mayu hémma ninʒéŋgé miwiŋ. ");
INSERT INTO kgf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Inéŋ Anutuac muru héima namma ni Anutuac Naŋa ʒéaŋec imuac waini inéŋ iwac ségiségi wanʒaciguc metecgé mimac. ");
INSERT INTO kgf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Waŋu duŋa kowu ic éréhéc Yesuguc momacnec biriŋnéŋ iciguc urugic imi ereŋ imuhuyanec ʒébiri miyoc. ");
INSERT INTO kgf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Waŋu gau komoc waŋu baec yanda baec siŋidéŋgéma keŋkecma maria haréwéc waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Waŋu kaiwe kiwa haréwéc imuaru Yesunéŋ kucnec qacma ʒéyec; Eli Eli lama sabaktani. Hénia imi Anutuna Anutuna némac niŋ wainénʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Waŋu imuaru naŋgic ionarunec tosaranéŋ nimma ʒégic; Ic yomi Eliawac qacʒac. ");
INSERT INTO kgf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Waŋu ionarunec méŋnéŋ nimma usuŋnec kemma konduŋ kagali méŋ mema waiŋ howuraiguc tinduŋgéma uŋ tasiaiguc haima Yesu gumuyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Gumuyu tosaranéŋ ʒégic waina Elianéŋ hama metecgémac me qahac imi hénni. ");
INSERT INTO kgf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Waŋu Yesu muŋguc kucnec qaru uŋaya waimiyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Waimiyu ocmuŋiguc maleku neʒic neʒicgia yanda imi ounec ʒuracgéma mama emu tecgéyu éréhécnec waŋoc. Waŋu naŋ meyu baec hiriyu hocnéŋ téma mayec. ");
INSERT INTO kgf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Waŋu kic suaŋ hema keŋec imi kuaya aŋgéyu ic téréya becnec humugic ionarunec sasalanéŋ ɋelima yacgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Waŋu Yesu imi humuc igucnec yaruguc ieneŋ kicsuaŋ igucnec éréma ama areŋa yanda téréyaiguc keremma ic sasala hicŋi énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Téŋgiŋ ic galeŋgina ʒéma ichécgina Yesuac galeŋ naŋgic ieneŋ imi naŋ meyec imi ʒéma haka hicŋiyec imi hémma namma ʒénéŋgina kuneŋ yanda hiriyu ʒégic; Ic yomi hélacnec Anutuac naŋa kerec. ");
INSERT INTO kgf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Waŋu embac sasalanéŋ Galilaianec Yesu weleŋ qemima méndacmima hagic imi eneŋ lakecaru hémma naŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Sucginaiguc imi Maria Makdalanec ʒéma Maria méŋ Yakobo Yosefe iorac neŋgocgira ʒéma embac méŋ Ʒebedaioac naŋhéréra iorac neŋgocgira momacnec kecgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ama mari waŋu Arimataia ama igucnec ic méŋ Yosefe ʒémimia hayec. Ic imi soukiwa ʒéma hinac yandayaguc, waŋu i acguc Yesuac tohotoho icya kerec. Qara imi Yosefe. ");
INSERT INTO kgf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inéŋ hama Pilatoac kemma Yesuac qamoc imi nénna ʒéma qesimiyu Pilatonéŋ mimuac niŋ énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Waŋu Yosefenéŋ qamoc imi mema kemma maleku lalaha ɋelianéŋ osoyec. ");
INSERT INTO kgf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Osoma eŋeya kic suaŋa ɋelia hociguc kifaŋa mihicŋima mézézéŋgéyu heyec imuaru haima hoc yanda méŋ qililiŋgéyu kic suaŋ kuaya neʒicgéyu waima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Waŋu Maria Makdalanec ʒéma Maria méŋ iereŋ kic suaŋ imuaru kemma imuac néwécgeŋaiguc tacma héŋoc. ");
INSERT INTO kgf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sabata naléyawac ʒéréŋqéréŋ naléya imi siŋima giaŋiyu ai meme méŋ waŋec. Nalé imuaru hofac oo ichécgina ʒéma Farisaio ic aʒoroma Pilatoaru keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kemma ʒégic; Miŋ Kewu, ic ikora imi ɋeli ɋeli kerec nalé imuaru yomuhuc ʒéyec imi niŋɋelima ninʒiŋ; Ai meme haréwéc imuac andiaiguc humuc igucnec ɋelima yacmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Imuac ʒéna, kic suaŋ imuac ai meme haréwéc séc galeŋ memu. Tohotoho ichéra ieneŋ kemma qamoc imi kowu mema kemma inéŋ humuc igucnec ɋelima yarec ʒéma ic embac énézémuiguc imi manam batuc andiaiguc hicŋimac iminéŋ becnec hicŋiyec imi ogicbac niŋac. ");
INSERT INTO kgf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Imuhuc ʒégic Pilatonéŋ melemma ʒéyec; Onac muru galeŋ meme ic kecʒu imuac kemma kucginawac séc galeŋ mema nammu. ");
INSERT INTO kgf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Imuhuc ʒéyu ieneŋ eŋaŋ galeŋ meme icgina iniguc kemma hoc hilaŋa asé kiwi haima galeŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabata kendoŋ tecgéyu Sondaiguc ama giaŋimaŋ ʒé waŋu Maria Makdalanec ʒéma Maria méŋ iereŋ kicsuaŋ hémbic ʒéma keŋoc. ");
INSERT INTO kgf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Keŋic naŋ yanda, naŋ geriwaguc meyu Miŋ Kewuninawac kua meme uŋanéŋ kurumeŋ igucnec mama kicsuaŋiguc hoc yanda imi qililiŋgéyu keŋu imuac qahaiguc emma tarec. ");
INSERT INTO kgf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tanera imi qilitik asaha ésécnec, malekuya imi komboc ésécnec lalac lalac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Waŋu galeŋ meme ic galeŋ mema naŋgic imi ʒénéŋgina hiriyu awacwalima ic humumia éséc wandacgic. ");
INSERT INTO kgf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Waŋu kua meme uŋanéŋ embac érézéma ʒéyec; Iri imi bacgira ménda yandiyu, Yesu iciguc qegic iwac mia hocma hazaoc imi ni ninʒua. ");
INSERT INTO kgf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I you qahac, énézéyec séc bec yacʒac. Hama duŋa heyec imi héŋic. ");
INSERT INTO kgf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Hémma foc tohotoho ichéra ionac kemma yomuhuc énézéma ʒémaoc; Yesu humuc igucnec yacma bec Galilaia baeciguc walac kenʒac, imuaru kemma mihicŋi mimu. Gezac qéʒéŋ ac imuac mia érézéwa ninʒaoc. ");
INSERT INTO kgf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Imuhuc ʒéyu embac éréhéc imi ʒénéŋgira hirima heyunec ségiséginéŋ sécgé érécmiyu tohotoho ichéra énéʒéwic ʒé usuŋnec keŋoc. ");
INSERT INTO kgf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Imuhuc wamma keŋkeric Yesu eŋeyaoc hicŋi érécmiyec. Luae orac muru ʒéma érézéyu iereŋ iwac muru kemma hénia selianec késama sicgémima mepési miyoc. ");
INSERT INTO kgf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Imuhuc waŋic Yesunéŋ érézéma ʒéyec; Bacgira ménda yandiyu. Kemma dac munahécna Galilaia baeciguc kemmu niŋ énézémaoc. Imuaru mia ni némmu. ");
INSERT INTO kgf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Embac éréhéc imi hénaiguc keŋicnec galeŋ meme ic tosaranéŋ ama areŋa yandaiguc keremma haka hicŋiyec imi mocʒoŋ hofac oo ic kiwa éréhécgina érézédacgic. ");
INSERT INTO kgf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Héfac oo ic kiwa iereŋ galeŋ iniguc tocgéma eminimma galeŋ meme ic soukiwa eŋeŋa énécmima yomuhuc ʒégic; ");
INSERT INTO kgf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ini yomuhuc mia ʒému; Siŋiya gau heni tohotoho ichéra ieneŋ hama i kowu huama keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Waŋu ac suruc iminéŋ baec galeŋac muru keŋu nimmaciguc imi neneŋ ewaya meni niŋu sécgémac. Imuac mia ini ewa goro ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Imuhuc ʒégic galeŋ meme ic imi soukiwa imi mema ʒéqindiŋi waŋ énécmigic séc ʒégic éréma deguc ac iminéŋ Yuda ic ionac muru saima hezacnec. ");
INSERT INTO kgf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Waŋu tohotoho ichéra 11 imi Galilaia baeciguc kemma baec boŋa méŋ Yesunéŋ énézéyec imuaru eŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Emma Yesu hémma mepésimigic, néŋ tosara imi niŋ éréhéc waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Waŋu Yesu hosucginaiguc hama ʒéyec; Baec kurumeŋ imuac kuc buŋa imi mocʒoŋ néndac néndara wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Imuac ini kemma baera baera ic embac Maŋgoc ʒéma Naŋa ʒéma Uŋa téréya qacninaiguc doku naec énécmima ");
INSERT INTO kgf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ackuaʒéc énézéyi imi mocʒoŋ ku énécmigic imuac séciguc kecma tohotoho ic wandacmu. Ninʒu, ni iniguc nalé séc kecba nalé tetecgia hamac. ");
INSERT INTO kgf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anutuac Naŋa, Kristo Yesuac buŋa suruc hiabia imuac hénihéniya. ");
INSERT INTO kgf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anutuac tiliŋ tiliŋ ic Yesaianéŋ yomuhuc oyec hezac; Ninna, neŋ ac weleŋ qeqena méliwa, walac hama guac héna memac. ");
INSERT INTO kgf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ic méŋ baec kisiyaiguc qacʒac iwac ewa imi yomuhuc; Iwac hénaya megic, iwac hénaya héimindiŋigic kondoŋa waŋu. ");
INSERT INTO kgf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Oyec hezac imuac séc, Yohanenéŋ baec kisiaiguc wininiyec. Wininima Anutunéŋ ic embac képésicgina wai énécmimac niŋac ewa qeri meleŋ meleŋac ara ʒéau énécmima doku naec énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Waŋu Yuda baec séc ʒéma Yerusalemiguc tuŋ yanda kecgic ieneŋ mocʒoŋ iwaru kemma képésicgina ʒéaugic Yodan dokuiguc doku naec énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohane i maleku kamele yaŋ ʒuacnénnec meyacgégic imi héima rikuŋa yaŋ séwéla néŋnec meyacgégic imi kembaŋaiguc ʒikima gaoc ʒéma morombazecac dokuya nema kecaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Waŋu inéŋ yomuhuc ʒéma ʒéauyec; Andénaiguc hamac iwac kucyanéŋ ni nogicʒac. Waŋu nidac imuhucyanéŋ sicgéma iwac héna usuyawac hésaya hulacmaŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ni dokunéŋ naec énécmizua waŋu inéŋ hama Uŋa Téréyanéŋ naec énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Waŋu nalé méŋ suraiguc Yesu Galilaia Naʒarete ama areŋa waima hayu, Yohanenéŋ Yodan dokuiguc doku naecmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Waŋu doku igucnec éréyu imuarunec kurumeŋ aŋgéyu Uŋa imi kembo nei ésécnec wamma iwaru mayu héŋec. ");
INSERT INTO kgf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Waŋu kurumeŋ igucnec ac méŋ yomuhuc mayec; Gi nuac Naŋna, guac muru ewana kuneŋ yanda hezac. Guac niŋ ewa qerinanéŋ ségiségi yanda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Waŋu nalé imuaru Uŋanéŋ Yesu wagiru baec kisiaiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Waŋu baec kisiyaiguc siŋi kaiwe 40 keru Biria miŋinanéŋ batucgéyec. Waŋu haséŋ yaŋ iniguc keru kua meme uŋa eneŋ galeŋgé migic kerec. ");
INSERT INTO kgf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Waŋu Yohane hésa amaiguc opocgic kerec. Imuac andiaiguc Yesunéŋ Anutuac buŋa suruc hiabia ʒéauma ʒéauma Galilaia baeciguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Waŋu inéŋ yomuhuc ʒéyec; Nalé imi ducŋiyu Anutuac héŋgaleŋ ama areŋa yanda hosucginu hazac imuac ewa qerigina melemma buŋa suruc hiabia imi ninʒéŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kecma Yesunéŋ Galilaia doku konduŋ giŋgiŋa wagicma keŋec. Keŋu Simon ʒéma iwac munia Anderea iereŋ uficgiria konduŋiguc gilima naŋic irirec. Ic éréhéc dac muna imi lambéc héréhéré ic, imuac niŋac ai imi mema keroc. ");
INSERT INTO kgf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Waŋu Yesunéŋ yomuhuc érézéma ʒéyec; Hama ni méndacnéŋic ic embac héréhéré ai érécmiwa. ");
INSERT INTO kgf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ʒéyu imuarunec iereŋ uficgira waima méndacmiyoc. ");
INSERT INTO kgf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Waŋu baec imuarunec komora méŋ kemma Ʒebedaioac naŋhéréra, Yakobo ʒéma munia Yohane iriru, iereŋ ʒéiciguc uficgira qalicgéma taroc. ");
INSERT INTO kgf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Taric nalé sosola qahac ururuyu, maŋgocgira Ʒebedaio ʒéma ai ic tosara énépésigic imi ʒéiciguc wai énécmima méndacmiyoc. ");
INSERT INTO kgf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Waŋu ieneŋ Kafanaum ama areŋa yandaiguc keŋgic. Kemma Yesunéŋ Sabata nalé téréya bec hayu tocgotocgo amaiguc emma ackuaʒéc ku énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kuénécmiyu niŋgic tanera imi héna acac kiwi ic ésécnec qahac, néŋ ic kuc buŋa yandayaguc ésécnec ku énécmiyec. Imuac niŋ ic embac ieneŋ ac ʒézéyawac niŋac welicgégic. ");
INSERT INTO kgf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Waŋu nalé imuaru tocgotocgo amagina qeriaiguc ic uŋa biriaguc méŋ kerec. Waŋu inéŋ yomuhuc ʒéma qarec; ");
INSERT INTO kgf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yesu Naʒarete ama areŋa igucnec, gi niniguc némac wammaŋ ʒé wanʒaŋ? Gi nini mebiri nécnécmimaŋ ʒé hazaŋ? Ni ninʒua gi méré, gi Anutuac ic téréya imi mia. ");
INSERT INTO kgf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Imuhuc ʒéyu Yesunéŋ ac geriwaguc ʒémima ʒéyec; Acga qaiyu ic iwarunec éréma kenna. ");
INSERT INTO kgf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Imuhuc ʒéyu uŋa birianéŋ ic hérékeŋ héréha wammima qac biricbiric qacma éréma keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Éréma keŋu ic embac ieneŋ welicgéma eminiŋ qeminiŋ wamma ʒégic. Haka imi némac haka? Ku nénécmiyu ninni tanera méŋ wanʒac. Imi sac qahac, kuha eŋeŋa, ic imi kuc buŋa yandayaguc. Uŋa biria ac énézéyu ieneŋ kuaya tohoanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Waŋu iwac ac surucya imi Galilaia ama baec séc focdac sécgédarec. ");
INSERT INTO kgf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Waŋu tocgotocgo amagina waima kemma Yakobo ʒéma Yohane iriguc Simon ʒéma Anderea iorac amaiguc eŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Waŋu Simon howuhaya séwi geric wammiyu heyec. Waŋu Yesu amaiguc eŋu foc ézégic. ");
INSERT INTO kgf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ézégic iwaru kemma mériaiguc késama méra miyu, séwi geric imi waimiyu yacma nene gumu énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Waŋu kaiwe kiwa sima hiŋgaru ama siŋiyec. Siŋiyu ic hafiginaguc ʒéma ic uŋa biriaginaguc mocʒoŋ onagicma iwaru hagic. ");
INSERT INTO kgf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Waŋu ama areŋa yanda imuac hénaoriŋ mocʒoŋ nagu kuayaiguc tocgédacgic. ");
INSERT INTO kgf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Waŋu inéŋ ic sasala hafi hénia héniaguc mehiaru énécmiyec. Énécmima uŋa biria sasala momacnec nesi énécmiyu mama keŋgic. Waŋu uŋa biria ieneŋ héniaya niŋgic, imuac niŋ héniaya ménda ʒéaumu niŋac neuŋ héiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Siŋunec yanda siŋi bakia tarunec, Yesu imi yacma hiŋgacma baec kisiaiguc kemma welerec. ");
INSERT INTO kgf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Weleru Simon ʒéma ic tosara i guc kecgic ieneŋ Yesu hocma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kemma mihicŋima yomuhuc ézégic; Ic embac mocʒoŋnec guac hocgémma kecʒu. ");
INSERT INTO kgf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Imuhuc ʒégic énézéma ʒéyec; Neŋaŋ baec méŋu kenni. Kemma tauŋ tosara hosuc hosuc hezac séc lelecgéwiŋ. Lelecgéma imuaru momacnec neŋ ackuaʒéc ʒéaumaŋ. Ni imuac mia mayi. ");
INSERT INTO kgf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Waŋu inéŋ Galilaia ama séc lelecgéma tocgotocgo amaya amayaiguc ackuaʒéc énézéma ic embac tosara uŋa biriagina nesi énécmiyu mama keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Waŋu ic méŋ wizi seliagucnéŋ iwaru hama simiŋa héima welecma yomuhuc ézéyec; Ninna hia waŋu, hia mehiaru némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Imuhuc ʒéyu Yesunéŋ wésia kileŋ waŋu méria suluma ic imi osima yomuhuc ézéyec; Ni imuac wanʒua, hiaruna. ");
INSERT INTO kgf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Imuhuc ʒéyu imuarunec lepra wizi selia imi waimiyu séwiya hia waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Waŋu imuarunec Yesunéŋ ic imi mélima ac ʒézé selia yomuhuc wammima ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ninʒaŋ, gi imuac ac suruc ic méŋ ménda énézéwésémaŋ. Gi deguc hofac oo ic iwac muru kemma ézéna hémmac. Waŋu Mosenéŋ ackuaʒéc ʒéyec hezac ésécnec sese haimiyu Anutu héfac omiyu hémma ic eneŋ hafiga hiaruyec imi niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Waŋu ic inéŋ kemma efefianec ʒéauyu suruc imi sécgédacma keŋec. Waŋu hénia imuac niŋ Yesu imi tauŋ séc winiŋu ménda kemma kecma séŋgaŋgeŋ baec kisiaiguc kerec. Keru kileŋdac ic embac ieneŋ néwéc néwécnec iwac muru hagic. ");
INSERT INTO kgf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Waŋu ai meme tosara tecgéyu Yesunéŋ muŋguc Kafanaum ama areŋa yandaiguc kemma ama méŋiguc emma taru surucya saima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Waŋu sasalanéŋ tocgéma ama kuaya qema naguya momacnec héʒicgégic titiŋa qahac waŋec. Waŋu inéŋ ackuaʒéc énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Waŋu ic kemboŋ qahac ieneŋ ic héna méria humumia méŋ huama iwaru hagic. ");
INSERT INTO kgf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Waŋu ic embac sasalanéŋ héʒicgégic hosuraiguc kemmuac séc qahac waŋec. Imuac ama qahaiguc emma Yesu oruha igucnec ama bauya augic kifaŋa hicŋiyu, imuacnec hehe duŋa ic héna méria humumia heyec imi haigic hiŋgarec. ");
INSERT INTO kgf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hiŋgaru Yesunéŋ ninʒéŋ ninʒéŋgina hémma ic héna méria humumia yomuhuc ézéyec; Naŋ, képésicga waigénʒua. ");
INSERT INTO kgf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Imuhuc ʒéyu héna acac kiwi ic tosara imuaru tacgic ieneŋ qeriginanéŋ yomuhuc niŋgic; ");
INSERT INTO kgf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ic imi dimuhuc niŋac ac imuhuc ʒézac? Miŋ Kewu ʒébiri qébiri wammizac! Anutu qahac waŋu, ic mérénéŋ mia képésicnina hia waiwacnec? ");
INSERT INTO kgf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Imuhuc eminimma kecgic Yesunéŋ qeri uŋayaiguc focdac niŋtegicma ʒéyec; Némac niŋ qeriginaiguc ac imuhucya ʒéninʒu? ");
INSERT INTO kgf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ic héna méria humumia ézémaŋ ʒéma, némac acnéŋ efefia wammac? Képésicga waigénʒua ac iminéŋ efefia wammac me, Yacma hehega mema kenna, ac iminéŋ efefia wammac? ");
INSERT INTO kgf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Icac Naŋa i baeciguc képésicgina waimac niŋac kuc buŋaya yanda hemizac imi héŋtegicmu! Imuhuc ʒéma ic héna méria humumia yomuhuc ézéyec; ");
INSERT INTO kgf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Ni gézézua, yacma hehe duŋga mema amagaiguc kenna. ");
INSERT INTO kgf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Imuhuc ʒéyu i imuarunec kicginaiguc yacma hehe duŋa mema keŋu ic ieneŋ welicgéma Anutu mepé qepési wammima ʒégic; Nini haka imuhucya ménda héŋaŋiŋ. ");
INSERT INTO kgf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Waŋu Yesunéŋ méŋgucnec konduŋ giŋgiŋanec kemma keŋec. Keŋu ic embac tuŋagucnéŋ iwaru hagic ackuaʒéc ku énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Waŋu inéŋ imuacnec kemma Alfaioac naŋa Lewi soukiwa meme amaiguc taru hémma ézéyec; Hama méndacnénna imuhuc ʒéyu, inéŋ yacma méndacmima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Waŋu Yesunéŋ Lewiac amaiguc emma tarec. Waŋu soukiwa meme ʒéma biria meme sasalanéŋ Yesu méndacmima keŋgic imuac niŋ ieneŋ Yesu ʒéma tohotoho ichéra iniguc momacnec tacma nene negic. ");
INSERT INTO kgf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Waŋu Farisaio ic ionac héna acac kiwi ic tosara ieneŋ Yesu imi soukiwa meme ʒéma biria meme iniguc tacma nene neyu hémma tohotoho ichéra yomuhuc énézégic; Némac niŋac ic imi soukiwa meme ʒéma biria meme iniguc tacma nene nezac? ");
INSERT INTO kgf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Imuhuc ʒégic nimma Yesunéŋ yomuhuc ʒéma énézéyec; Ic hafigina qahac ieneŋ mehiahiaru ic niŋac ménda waŋanʒu, néŋ hafiginaguc ieneŋ mia imuac waŋanʒu. Ni ic hiabia unurumaŋ ʒéma ménda mayi, néŋ képésic ic unurumaŋ ʒéma mayi. ");
INSERT INTO kgf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yohaneac tohotoho ichéra ʒéma Farisaio ic ieneŋ nene ʒikima ʒéwelecma kecgic. Waŋu ic tosara ieneŋ Yesuaru hama yomuhuc qesimigic; Yohaneac tohotoho ichéra ʒéma Farisaio ic ionac tohotoho ichécgina ieneŋ nene ʒikima Anutuaru welecma kecʒu. Waŋu hénia némac niŋac guac tohotoho ichécga ini imuhuc ménda wanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ʒégic Yesunéŋ yomuhuc énézéyec; Ic qaŋ tosara ic méŋ embac memaŋ ʒé wanʒac ic imiguc kecʒu ieneŋ dimuhuc nene ʒikima ʒéwelec wammu? Ieneŋ i guc momacnec kecʒunec nene ʒikima ʒéwelec wammuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kecma ic embac mezac i késama kemmu nalé imuaru ieneŋ nene ʒikima ʒéwelec wammu. ");
INSERT INTO kgf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Méŋnéŋ méŋ maleku walaha tegictegiraiguc maleku susuria ɋelia ménda haianʒac. Imuhuc wambacnec maleku susuria ɋelianéŋ wahala héréyu tegicma titiŋa yanda hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Waŋu méŋnéŋ méŋ waiŋ doku ɋelia yaŋ séwélanéŋ gésé memeya wahalaiguc ménda tianʒac. Imuhuc wambacnec waiŋnéŋ gésé imi héʒuracgéyu waiŋ ʒéma gésé momacnec birimaoc. Imuac waiŋ ɋelia imi gésé ɋeliaiguc tianʒac. ");
INSERT INTO kgf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabata nalé téréya méŋiguc Yesu ʒéma tohotoho ichéra ieneŋ wit ai namuŋaiguc héna komora méŋ heyu imuacnec méndacma keŋgic. Kemma tohotoho ichéra ieneŋ héla momac momac méraginanéŋ mericgic. ");
INSERT INTO kgf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Imuhuc waŋgic Farisaio ic ieneŋ Yesu yomuhuc ézégic; Inicna, némac niŋ Sabata nalé téréyaiguc héna ac logizu? ");
INSERT INTO kgf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Imuhuc ʒégic Yesunéŋ melemma yomuhuc énézéyec; Dawidi ʒéma ichéra ieneŋ nene niŋ humuma imuaru haka waŋgic imi ini ménda olomma niŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Inéŋ hofac oo ic ionac eŋeŋagina Abiata iwac ai meme naléyaiguc Anutuac ama qeriaiguc emma saméŋ téréya Anutuac buŋa haihaiya imi mema neyec. Saméŋ imi hofac oo ic ieneŋ sac nemuac niŋ ʒéénécmimia. Waŋu inéŋ ichéra momacnec énécmiyu negic. ");
INSERT INTO kgf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Waŋu muŋguc énézéyec; Sabata nalé téréya imi ic embac onac niŋ wamma ʒéyu hicŋiyec. Waŋu Sabata nalé téréya niŋac wamma ic embac ménda mihicŋi énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Imuac niŋ Icac Naŋa imi Sabata imuac Miŋina kecʒac. ");
INSERT INTO kgf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Waŋu inéŋ muŋguc tocgotocgo ama qeriaiguc eŋec. Eŋu imuaru ic méria séléc sélécgia méŋ tarec. ");
INSERT INTO kgf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Waŋu ic tosaranéŋ Yesu aciguc opocbiŋ ʒé képésira hocma kecaŋgic imuac niŋac Sabata nalé téréyaiguc ic imi mehiarumac me imuhuc ʒéma hosuraiguc galeŋ mema kecgic. ");
INSERT INTO kgf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kecgic inéŋ ic méria sélécgéyec i yomuhuc ézéyec; Yacma sucginaiguc nanna. ");
INSERT INTO kgf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Imuhuc ʒéma qesiénécmiyec; Némacnéŋ héna ac séciguc? Sabata nalé téréyaiguc iwawai hiabia wambiŋ me iwawai biria wambiŋ? Kekec imi mehiaruwiŋ me qehumuwiŋ? Imuhuc ʒéyu acgina qaiyec. ");
INSERT INTO kgf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Acgina qaiyu inéŋ qeria biriyu hima iniru qeri seligina niŋac ewaya birima goro waŋu muŋguc ic imuac ézéyec; Méraga suluna. Waŋu suluyu méria hiaruyec. ");
INSERT INTO kgf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Waŋu Farisaio ic ieneŋ séŋgaŋgeŋ hiŋgacma imuaru Herodeac ichéra iniguc tocgéma dimuhuc wamma qehumuwiŋ ʒéma sasaŋgiaiguc eminiŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Imuhuc eminiŋgic Yesunéŋ tohotoho ichéra iniguc waima konduŋiguc keŋgic. Waŋu Galilaia baec igucnec ic tuŋ yanda hama méndac énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Waŋu Yuda, Yerusalem, Idumea, ʒéma Yodan néwéc igucnec, waŋu Tiro ʒéma Sidon giŋgiŋgira igucnec ic tuŋ yanda ieneŋ Yesu kiwi memeyawac buŋa nimma iwaru harégic. ");
INSERT INTO kgf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Waŋu ic tuŋ yandanéŋ haréma épépéŋgéma elicgémiwu niŋac tohotoho ichéra yomuhuc énézéyec; Ʒéic komoc méŋ hosucnaiguc mambéc tacmac. ");
INSERT INTO kgf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Imi mia inéŋ ic sasala mehiaru énécmiyu hafi wiziginagucnéŋ héfacgé amuma méragina suluma osiwiŋ ʒé waŋgic imuac niŋ imuhuc ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Waŋu uŋa biriaginaguc ieneŋ i héŋgic séc hénayaiguc mama hema kucnec qacma yomuhuc ʒéaŋgic; Gi Anutuac Naŋa. ");
INSERT INTO kgf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Waŋu inéŋ héniaya ménda ʒéaumu niŋac qetali énécmiaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Waŋu baec boŋa méŋiguc emma ichéra qerianéŋ énépésiaŋec ionac énézéyu iwaru hagic. ");
INSERT INTO kgf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hagic ic ʒaŋgégina 12 énépésima ai buŋa qeénécmiyec. Imi mia i guc nalé séc kecgic méliénémiyu ackuaʒéc ʒéaumu niŋac énépésiyec. ");
INSERT INTO kgf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Waŋu kuc buŋa qeénécmiyu mema kuwi nesi énécmimu niŋac énépésiyec. ");
INSERT INTO kgf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ic 12 énépésiyec imi yomuhuc; Simon (Qara ɋelia Petero ʒémiyec), ");
INSERT INTO kgf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ʒebedaioac naŋa Yakobo, Yakoboac munaya Yohane, (Iorac qacgira Boanege ʒéyec; Hénia imi parandaŋ naŋ héréra.) ");
INSERT INTO kgf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","waŋu Anderea, Filipo, Batolomaio, Mataio, Toma, Alfaioac naŋa Yakobo, Tadaio, Kanaan ic Simon, ");
INSERT INTO kgf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ʒéma Yuda Karioto, waŋu inéŋ kecma Yesu andé qeyec. ");
INSERT INTO kgf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Waŋu Yesunéŋ hama ama méŋac qeriaiguc eŋu ic tuŋ yandanéŋ méŋgucnec tocgégic. Imuac niŋac Yesu ʒéma tohotoho ichéra eŋacnec nene méŋ nemuac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Waŋu ic tosara ieneŋ Qeria sicsaoc wanʒac imuhuc ʒégic sac taséhéra ieneŋ imi nimma késawiŋ ʒéma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Waŋu héna acac kiwi ic Yerusalemnec mama hagic ieneŋ iwac niŋ yomuhuc ʒégic; Kuwic ionac kuneŋgina Beelʒebulnéŋ iwac qahaiguc eŋu iwac kucyanéŋ kuwic nesi énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Imuhuc ʒégic Yesunéŋ unuruma ɋelumbec ac yomuhuc ʒéma énézéyec; Biria miŋinanéŋ dimuhuc Biria miŋina nesimimac? ");
INSERT INTO kgf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ic kewu méŋac héŋgaleŋ ama areŋa yanda imi, imuac ichéranéŋ héndéŋ héndéŋ waŋ amuanʒuiguc iwac héŋgaleŋ ama areŋa yanda imi hia ménda naŋselimac. ");
INSERT INTO kgf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Waŋu ama méŋ imi imuac ic ʒéma iniŋ merahéra ieneŋ héndéŋ amuanʒuiguc ama imi hia ménda naŋselimac. ");
INSERT INTO kgf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Waŋu Biria miŋinanéŋ yacma haʒéc waŋamuma héndéŋ amuanʒuiguc hia ménda naŋselimu, néŋ bec qahac wammu. ");
INSERT INTO kgf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Waŋu ic méŋnéŋ walac ic kawali ménda ʒiki mimaguc amayaiguc emma hinaya wagicmacac séc qahac. Walac ic kawali imi ʒikimimaguc hinaya wagicma memac. ");
INSERT INTO kgf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ni hélacnec énézéwa, ic onaru képésicgina ʒéma ac biria imi hia waiwaiya hezac. ");
INSERT INTO kgf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Waŋu ic méŋnéŋ Uŋa Téréyawac ʒésure mimaciguc iwac képésic imi waiwaiyawac séc ménda hezac. Képésicya imi tetecgiya qahac hemacac hema kecmac. ");
INSERT INTO kgf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Imi mia Yesuac niŋ, Inéŋ Qeriaiguc kuwic biria késa kecʒac, imuhuc ʒémigic ac imuhuc melemma énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Waŋu neŋgoc munahéra harédacma ama sombeŋiguc namma ic méŋ méligic emma qarec. ");
INSERT INTO kgf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Qaru ic tuŋ yanda leclecgémima tacgic ieneŋ yomuhuc ézégic; Ninʒaŋ, guac neŋgocga ʒéma munahécga ieneŋ gi gémbiŋ ʒé wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Imuhuc ʒégic inéŋ melemma yomuhuc énézéyec; Mérénéŋ nuac neŋgoc munahécna wanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Imuhuc ʒéma ic lelecgéma tacgic ionaru kic hima ʒéyec; Inicgic, nuac neŋgoc dac munahécna youmi tacʒu. ");
INSERT INTO kgf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Méŋnéŋ méŋ Anutuac ackuaʒéc tohoanʒu imi eneŋ mia nuac nauŋ munana ʒéma neŋgocna wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Waŋu Yesunéŋ konduŋ giŋgiŋaiguc muŋguc ackuaʒéc ku énécmimaŋ ʒé hénima ʒéyec. Ʒéyu ic tuŋ yanda iwaru haréma tocgégic. Imuac niŋ inéŋ ʒéic méŋiguc emma konduŋiguc tarec. Taru ic tuŋ yanda ieneŋ mocʒoŋ baeciguc tacgic. ");
INSERT INTO kgf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Waŋu inéŋ ɋelumbec ac ʒéma iwawai sasala ku énécmiyec. Waŋu ku énécmima yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Énézéwa niŋgic, ai ic méŋnéŋ iwawai gocmia himicmaŋ ʒé aiiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kemma qesayu, gocmia tosaranéŋ hénaiguc mama héiyu nei eneŋ haréma nedacgic. ");
INSERT INTO kgf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Waŋu gocmia tosaranéŋ hoc sira baec komocdia dac heheya imuaru héiyu qérawia focdac qema éréyec. Waŋu imuaru baec sasala ménda heyec. ");
INSERT INTO kgf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Imuac niŋac ʒalianéŋ baec ménda késayacgéyu kaiwenéŋ éréma qeyu humuyec. ");
INSERT INTO kgf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Waŋu gocmia tosaranéŋ ic hésa waiyaguc imuac qeriaiguc héiyu haséŋnéŋ yandima neʒicgéyu héla ménda haiyec. ");
INSERT INTO kgf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Waŋu gocmia tosaranéŋ baec halécyaguc imuaru héiyu qérawia éréma néʒéŋgéma héla haiyu yandiyec. Yandiyu méŋac 30, méŋac 60, ʒéma méŋac 100 mesaiyec. ");
INSERT INTO kgf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Waŋu inéŋ toroqema ʒéyec; Ic méŋ gezawagucnéŋ ac imi niŋasarimac. ");
INSERT INTO kgf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Waŋu ic embac opocma kendacgic eŋeyanec taru tohotoho ichéra ʒéma tosara lelecgémima tacgic ieneŋ ɋelumbec ac imuac hénia qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Qesimigic inéŋ énézéyec; Onac imi Anutuac héŋgaleŋ ama areŋa yanda imuac ac saŋa ʒéasari énécmianʒua. Waŋu ic embac demiŋ séŋgaŋgeŋaiguc kecʒu ionac imi iwawai mocʒoŋ ɋelumbec aciguc énézéanʒua. ");
INSERT INTO kgf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Imuhuc wamba, hémmu waŋu hia ménda héŋtegicmu. Nimmu waŋu hia ménda niŋtegicmu. Qahac waŋu ieneŋ ewa qerigina meleŋgic Anutunéŋ képésicgina wai énécmiwacnec. ");
INSERT INTO kgf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Waŋu Yesunéŋ yomuhuc ʒéma énézéyec; Ɋelumbec ac ʒézua imuac hénia ménda ninʒuiguc ɋelumbec ac sasala dimuhuc hia niŋtecgicmu? ");
INSERT INTO kgf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ai icnéŋ gocmia qesazac imi Anutuac ackuaʒéc. ");
INSERT INTO kgf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gocmia tosara hénaiguc héiyec sécya imi yomuhuc; Ackuaʒéc niŋgic Biria miŋinanéŋ foc haréma qerigina igucnec mema néŋgacanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Waŋu gocmia tosara hoc siraiguc héiyec imuac sécya imi yomuhuc; Ackuaʒéc nimma ségiségi wamma focdac késaanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Waŋu qeriginaiguc ʒalia ménda hiŋgac késa yacgéyu nalé hotoŋa dac mema kecma ackuaʒéc imuac niŋac manam batuc me haʒéc mihicŋima focdac bélacgéma waianʒu. ");
INSERT INTO kgf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Waŋu gocmia ic hésa waiyaguc imuac qeriaiguc héiyec imuhucyanéŋ ackuaʒéc ninʒu, ");
INSERT INTO kgf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","néŋ baecac niŋyéwécya, hinawac iwawai ikora ʒéma iwawai hénia héniawac siŋginanéŋ qeriginaiguc hiŋgacma ackuaʒéc imi héihumuyu héla ménda haianʒac. ");
INSERT INTO kgf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Waŋu gocmia baec halécyaiguc héiyec imuhucyanéŋ ackuaʒéc nimma késama héla 30, 60, ʒéma 100 imuhuc mesaima haianʒu. ");
INSERT INTO kgf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Inéŋ muŋguc énézéma ʒéyec; Kifa imi kuʒi me tatac duandiaiguc haiwiŋ ʒé mema haanʒu? Imi ʒae qahaiguc ménda haianʒu me? ");
INSERT INTO kgf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Iwawai sasaŋgiaiguc hezac imi augic wininimacac musaŋgéyec. Waŋu iwawai sasaŋgiaiguc hezac imi augic hémmuac musaŋgéyec. ");
INSERT INTO kgf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ic méŋ gezawagucnéŋ ac imi niŋasarimac. ");
INSERT INTO kgf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Waŋu inéŋ ac toroqema yomuhuc ʒéyec; Ini ac niŋanʒu imi niŋgésimu. Eŋaoc ic embac ac néndéŋgé énécmima ʒéanʒu imuac bakia sécya liliŋgéyu nimmu. Waŋu imi sac qahac muŋguc toroqema énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Méŋ iwawai hemizac inéŋ méŋ muŋguc memac. Waŋu méŋ ménda hemizaciguc imi komocdia dac hemizac imi wagiru qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Inéŋ muŋguc toroqema ʒéyec; Anutuac héŋgaleŋ ama areŋa yanda imi yomuhuc; Ic méŋnéŋ baec aiiguc iwawai gocmia qesaanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Qesama siŋi kaiwe heyac waŋu gocmia imi néʒéŋgéma éréanʒac. Waŋu imuac hénia imi ménda niŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Baec i eŋeyaocnec héla mihicŋianʒac. Waŋu walac qérawia, andiaiguc merawa, andiaiguc héla haianʒac. ");
INSERT INTO kgf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Waŋu kecma héla waʒiyu imuarunec kuma héla meanʒac. Imi mia héla memeyawac naléya ducŋiyu imuhuc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Waŋu muŋguc toroqema ʒéyec; Anutuac héŋgaleŋ ama areŋa yanda imi dimuhuc éséc ʒéwa sécgémac? Ʒéasarimaŋ ʒé ɋelumbec ac dimuhucya ʒémaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Anutuac héŋgaleŋ ama areŋa yanda imi saiwa ic gocmia imuhucya ésécnec. Baeciguc himicanʒu imi komodia soroc. Ic gocmia tosara ionac mamayagina. ");
INSERT INTO kgf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Waŋu baeciguc haini, hicŋi yandima icya icya hezu imi mocʒoŋ onogicma ic yanda wammac. Waŋu nei sawaiguc kecʒu ieneŋ haréma ic imuac amiaiguc haecgina hia haimu. ");
INSERT INTO kgf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesunéŋ hia niŋasarimuac sécyawac ɋelumbec ac sasala ʒéma ackuaʒéc énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Waŋu inéŋ ic embac ackuaʒéc énézémaŋ ʒé ɋelumbec aciguc sac ʒéma énézéaŋec. Waŋu tohotoho ichéra iniguc sac eŋacnec kecma ɋelumbec ac imuac héniaya mocʒoŋ ʒéasari énécmiaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Waŋu kaiwe imuarunec ama mari waŋu, tohotoho ichéra yomuhuc énézéyec; Neŋaŋ konduŋ néwécgeŋiguc kerenni. ");
INSERT INTO kgf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Imuhuc ʒéyu, tohotoho ichéra ieneŋ ic tuŋ yanda ini méli énécmigic, Yesu bec ʒéiciguc emma taru, emma wagicma keŋgic. Keŋgic ʒéic tosara momacnec i guc keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Keŋkecgic, luhuc kuneŋ yanda méŋnéŋ haréma qeyu, sirinéŋ ʒéic qeriaiguc hiŋgacma kuaya qemaŋ ʒé waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Waŋu Yesu eŋeya imi ʒéic andiaiguc gau heyec. Waŋu tohotoho ichéra ieneŋ mindima yomuhuc ézégic; Kiwi ic nini humuwiŋ ʒé wanʒiŋ imuac gi ewa éréhéc ménda wanʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Imuhuc ʒégic inéŋ yacma luhuc ac ʒémima konduŋ yomuhuc ézéyec; Gi néŋ qema hena. Imuhuc ʒéyu luhucnéŋ tecgéyu sirinéŋ néŋ qeyec. ");
INSERT INTO kgf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Waŋu inéŋ tohotoho ichéra yomuhuc énézéyec; Ini némac niŋac ʒénéŋgina imuhuc hirizac? Ini ninʒéŋ ninʒéŋgina méŋ ménda késa kecʒu? ");
INSERT INTO kgf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Waŋu ieneŋ ʒénéŋgina kileŋ hiriyu eminiŋ qeminiŋ wamma yomuhuc ʒégic; Ic imi némac ic waŋu luhuc ʒéma konduŋ iereŋ kuaya tohozaoc? ");
INSERT INTO kgf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Waŋu ieneŋ konduŋ qericma néwécgeŋ Gerasa baeciguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Keremma Yesunéŋ ʒéic igucnec mayu, imuaru ic méŋ uŋa biriayagucnéŋ kic suaŋ namuŋa igucnec haréyu mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ic iminéŋ kic suaŋ namuŋaiguc heyac wamma kecaŋec. Waŋu méŋnéŋ méŋ ʒikimimacac séc ménda waŋec. Waŋu inéŋ seŋ hésa momacnec kileŋdac metecgéaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hatac sasala seŋ hésanéŋ dérécgéma iwawai yéwéria héna mériaiguc ʒikigic qeriaŋec. Waŋu méŋnéŋ hia meselimiyu bénʒéŋ tacmacac séc qahac waŋaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Waŋu siŋi kaiwe séc kic suaŋ namuŋaiguc me baec tewac tewaraiguc kecma qacma hocnéŋ héricamuaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Waŋu ic inéŋ Yesu lakecnec hémma usuŋnec hama wéséyaiguc simiŋ héimiyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Imuhuc wamma inéŋ selianec qacma ʒéyec; Anutu, Eŋeŋa yandawac Naŋa Yesu, gi ʒéma ni imi nekac nekac, Anutuac qaraiguc meseli gémba ménda mebiri némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Imi mia Yesunéŋ bec, Uŋa biria, gi ic iwarunec éréma kenna, imuhuc ézéma ʒéyec imuac niŋac imuhuc welerec. ");
INSERT INTO kgf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Weleru qesimiyec, Qacga méré? Qesiyu melemma ʒéyec; Nini sasalanéŋ kecʒiŋ imuac niŋac qacna imi yaré ic tuŋa ʒéanʒua. ");
INSERT INTO kgf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Imuhuc ʒéma seli seli wamma baec imuarunec ménda nesi énécmiyu kemmu niŋ ʒéwelerec. ");
INSERT INTO kgf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Waŋu tewac tewara maréŋaiguc beric sasala yanda hosuru kecgic. ");
INSERT INTO kgf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Waŋu kuwic ieneŋ seli seli wamma Yesu welec migic, Beric ionaru méli nénécmina kembiŋ, wai nénécmina kemma ionac qeriginaiguc hiŋgacbiŋ. ");
INSERT INTO kgf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ʒégic inéŋ hia ʒéma wai énécmiyu uŋa biria ieneŋ ic iwarunec éréma kemma beric qeriginaiguc hiŋgacgic. Hiŋgacgic beric ieneŋ usuŋnec kemma siaiguc hiŋgacma konduŋ qeriaiguc hiŋgacdagic. Beric tuŋaguc qétégina 2,000 ieneŋ konduŋ dokunéŋ hoturu énécmiyu wésésé unudarec. ");
INSERT INTO kgf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Unudaru beric galeŋ ieneŋ néŋgacma kemma ic tosara ama areŋa yanda me ama areŋa komoraiguc kecgic ionac suruc waŋ énécmigic ic ieneŋ haka hicŋiyec imi hémbiŋ ʒéma hagic. ");
INSERT INTO kgf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hama Yesuac muru harédacma ic yaré ic tuŋanéŋ késa kerec imi héŋgic hiaruma malekuya héima taru ʒénéŋgina hiriyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Waŋu haka héŋgic ieneŋ ic uŋa biriayaguc kerec iwaru haka imi dimuhuc hicŋiyec imuac ac suruc énézéma bericac ac suruc imi momacnec énézégic. ");
INSERT INTO kgf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ʒégic ic eneŋ Yesu baecgina waima kemmac niŋac hénima welecmigic. ");
INSERT INTO kgf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Welecmigic Yesu ʒéiciguc eŋu ic uŋa biriayaguc kerec inéŋ méndacmima kemmaŋ ʒé welecmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Weleru inéŋ qetali mima yomuhuc ézéyec; Gi sac taséhécga ionac niŋac wamma amagaiguc kemma Anutu Eŋeŋanéŋ goi héihéi dimuhuc waŋgémma némac ai megénʒac imuac ac suruc énézéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Imuhuc ʒéyu ic imi waima kemma Yesunéŋ dimuhuc wammiyec imuac ac suruc Dekapoli ama komoc komoc séc ʒéauma ʒéauma keŋu nimma welicgégic. ");
INSERT INTO kgf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Waŋu Yesu imi ʒéic komoraiguc konduŋ qericma muŋguc néwéciguc kemma doku giŋgiŋaiguc taru ic sasalanéŋ iwaru tocgégic. ");
INSERT INTO kgf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Waŋu tocgotocgo ama galeŋ méŋ qara Yairo inéŋ hama i hémma héniaiguc sicgémiyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sicgémima seli seli wamma welec mima ʒéyec; Nuac béracna komora imi humumaŋ ʒé wanʒac. Hama méraga iwac qahaiguc haina hafiya hiaruyu kecmac. ");
INSERT INTO kgf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Imuhuc weleru Yesunéŋ i guc keŋic ic sasala yanda ieneŋ méndacma hofac hofac amuma kemma osigic. ");
INSERT INTO kgf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Waŋu embac méŋ sacya mayecac mama keru hafiyawac yawuŋa imi 12 waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Waŋu mehiahiaru ic sasalanéŋ mebipigic qenʒeŋ manʒeŋ qema kecaŋec. Keru imuac boŋawac iwawai iwaru hemiyec imi mocʒoŋ énécmiyu qahac wandarec. Waŋu hafiya ménda efiyec, néŋ muŋguc yéwériyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Waŋu embac inéŋ Yesuac suruc nimma imuarunec sucginaiguc haréma iwac andia igucnec malekuya osiyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Osima yomuhuc ʒéma niŋec; Malekuya sac késawa hia hiaru némmac. ");
INSERT INTO kgf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Imuhuc waŋu imuarunec sacya focdac ʒicgéyu iwac qeriaiguc hafi biria heyec imi hiaruyu niŋec. ");
INSERT INTO kgf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Waŋu Yesunéŋ kuhanéŋ ai meyu ewa qerianéŋ focdac nimma sucgina igucnec liliŋgéma ʒéyec; Mérénéŋ malekuna osizac? ");
INSERT INTO kgf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Imuhuc ʒéyu tohotoho ichéra eneŋ yomuhuc ézégic; Ic sasala yanda eneŋ lelecgé gémma naŋgic hénʒaŋ, waŋu némac niŋac Mérénéŋ nosizac ʒézaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Waŋu Yesunéŋ ic méŋ haka imuhuc waŋec i hémmaŋ ʒé kic hiyu keŋha waŋunec naŋec. ");
INSERT INTO kgf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Imuhuc qesimanec naŋu embac imi séwiyaiguc haka hicŋiyec imi nimma ʒénéŋa hiriyu iwaru hama héniaiguc sicgéma ac suruc mocʒoŋ hélacnec ʒéauyec. ");
INSERT INTO kgf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ʒéauyu inéŋ yomuhuc ézéyec; Bérac, ninʒéŋ ninʒéŋganéŋ mehiaru génʒac. Ewa bénʒéŋ nimma kenna, qenʒeŋ manʒeŋga igucnec hulacgénʒua. ");
INSERT INTO kgf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Embac ac imuhuc ézéma naŋunec tocgotocgo ama galeŋ iwac ama igucnec ic tosara hama ʒégic; Béracga bec humuzac. Némac niŋ kiwi ic yéwéri muŋguc mikecbésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ʒégic Yesunéŋ acgina gezacnec sac eŋ nimma tocgotocgo ama galeŋ yomuhuc ézéyec; Ʒénéŋga ménda hiriyu, eŋ ninʒéŋgéna. ");
INSERT INTO kgf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Imuhuc ʒéma tosara ménda méndacmimu niŋac neuŋ héiénécmima Petero, Yakobo, ʒéma Yakoboac munaya Yohane sac onagiru keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kemma tocgotocgo ama galeŋac amayaiguc emma iniru ic embac ieneŋ qeweloŋ yanda wamma ʒésiac wamma kecgic. ");
INSERT INTO kgf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Siacma kecgic sucginaiguc kemma énézéyec; Ini némac niŋ ʒésiac yanda waŋkecʒu? Embac merac imi ménda humuzac, néŋ gauya hezac. ");
INSERT INTO kgf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Imuhuc ʒéyu ieneŋ desimigic. Waŋu énézéyu hiŋgadacgic neŋgoc maŋgocya ʒéma tosara i guc kecgic imi onagiru embac merac heyec imuaru kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Keremma embac merac iwac méria késama ʒéyec; Talita koum. (Neŋaŋ aciguc hénia imi yomuhuc; Embac merac gézézua, yacna.) ");
INSERT INTO kgf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ʒéyu imuarunec embac merac yacma keŋkeŋ haha waŋec. (Embac merac iwac yawuŋa imi 12 waŋec.) Waŋu ieneŋ kileŋ yanda welicgégic. ");
INSERT INTO kgf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Welicgégic Yesunéŋ ic ménda énézému niŋac neuŋ héiénécmiyec. Waŋu embac merac nene migic nemacac niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Waŋu inéŋ baec imi waima eŋeya tauŋaiguc keŋec. Waŋu tohotoho ichéra i méndacmima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kemma keru Sabata nalé téréya waŋu tocgotocgo amaiguc emma ac hénima ku énécmiyec. Waŋu ic sasala ieneŋ iwac ackuaʒéc nimma welicgéma ʒégic; Niniŋ imi dimuacnec meyec? Niniŋ hemizac imi némac niniŋ? Waŋu mérianéŋ haka méréra icnéŋ ménda memeya momacnec meanʒac imi némac haka? ");
INSERT INTO kgf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ic imi mericqe ic, Mariawac naŋa, Yakobo, Yose, Yuda ʒéma Simon ionac dacgina, imi hélacnec qahac me? Waŋu iwac nauŋhéra you neŋaŋguc ménda kecʒiŋ? Imuhuc ʒéma niŋgic biriyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Imuhuc ʒégic Yesunéŋ yomuhuc énézéyec; Anutuac tiliŋ tiliŋ ic méŋ imi eŋeya tauŋ ichéra ʒéma sac taséhéra ʒéma ama momachéra sac mianéŋ ménda mepési mianʒu. ");
INSERT INTO kgf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Waŋu imuaru haka icnéŋ ménda memeya méŋ ménda meyec, néŋ ic hafiginaguc éréhécdac sac mérayanéŋ haima mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Waŋu ionac ninʒéŋ ninʒéŋgina qahac imuac niŋac welicgéyec. Welicgéma ama séc lelecgéma ku énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesunéŋ tohotoho ichéra 12 unuruma éréhéc éréhéc méli énécmima uŋa biria nesi énécmimu niŋac kuc buŋa énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Waŋu Yesunéŋ ʒézé seli ac selianec énézéma ʒéyec; Keŋha wambiŋ ʒéma tacgina sac mema kemmu. Héna mauŋ me gésé me konoŋiguc soukiwa imi ménda mema kemmu. ");
INSERT INTO kgf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Waŋu héna usugina imi hia haima ʒikimu. Waŋu maleku saméŋa méŋ ménda mema kemmu. ");
INSERT INTO kgf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Imuhuc ʒéma énézéyec; Baec méŋiguc keremma ama geric méŋiguc emmuiguc imuaru tacyac waŋkecmu, waŋu baec méŋu kembiŋ ʒémaguc ama geric imi waimu. ");
INSERT INTO kgf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ama méŋ ala ménda waŋ énécmima acgina ménda nimmuiguc, héna usugina tawéyaiguc seitotoŋ tacmac imi qegic mayu kemmu. Waŋu ieneŋ onac hakagina imi hémma niŋasarimu. ");
INSERT INTO kgf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ʒéyu tecgéyu ieneŋ kemma ic embac qerigina melemmu niŋac ackuaʒéc ʒéau énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Waŋu ieneŋ uŋa biria sasala nesi énécmima ic embac hafaginaguc sasala haléc naec énécmima mehiaru énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yesuac qac buŋa imi saima keŋkecma ic kewu Herodearu haréyu niŋec. Waŋu ic tosaranéŋ yomuhuc ʒégic; Yohane doku naec énécmiyec i Anutunéŋ humuc igucnec meɋelimiyu yarec imuac niŋ i Kuha yandanéŋ ai imuhucya meanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ic tosaranéŋ ʒégic; Ic imi Elia. Waŋu tosaranéŋ yomuhuc ʒégic; Imi Anutuac kua meme ic becnec kecgic imuhucya. ");
INSERT INTO kgf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Waŋu Herodenéŋ nimma yomuhuc ʒéyec; Yohane déméŋa qeriri i humuc igucnec meɋelimiyu yacma kecʒac. ");
INSERT INTO kgf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Becnec Herodenéŋ munaya Filipo iwac iniŋa Herodia wagirec. ");
INSERT INTO kgf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Wagiru Yohanenéŋ Herode yomuhuc ézéyec; Gi munagawac iniŋa menec imi héna ac logi logiya wanʒac. Imuhuc ʒéyu Herode eŋeyaoc embac iwac niŋac wamma téŋgiŋ ichéra énézéyu Yohane késama dérécgéma hésa amaiguc opocgic. ");
INSERT INTO kgf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Opocgic Herodianéŋ Yohaneac qeri biric nimma qehumumaŋ ʒéma ʒéniŋec, néŋ osiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Imi mia Herodenéŋ Yohaneac ic solaŋa, ic téréya imuhuc ʒéma ʒénéŋa hiriyu galeŋgé miaŋec. Waŋu kuaya igucnec ac niŋu qeria imi yéwériaŋec. Waŋu iwac ackuaʒécya imi siŋa nimma niŋaŋec hénia imuac niŋac osiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Waŋu kecma nalé hia méŋ hayec. Herode inéŋ eŋeya hicŋi hicŋi naléya hayu ic kewuhéra ʒéma yaré ic ionac galeŋhéra ʒéma Galilaia baec igucnec ic eŋeŋa qutulaŋgé énécmidaru weleŋ qeqe ichéra eneŋ nene doku oma gumu énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Énécmiyu Herodiawac béracyanéŋ ionac muru emma wéséginaiguc legic hiriyec. Hiriyu Herode ʒéma ichéra ieneŋ hémma ségiségi waŋgic. Waŋu Herodenéŋ embac meracwac yomuhuc ʒéma ézéyec; Siŋgawac iwawai méŋ niŋac ʒéma qesina neŋ hia gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Imuhuc ʒéma ac selianec ʒikima ézéyec; Iwawai méŋac méŋ qesina nuac héŋgaleŋ ama areŋa yanda imi suc igucnec hia méndémma gémmaŋac séc. ");
INSERT INTO kgf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Imuhuc ʒéyu inéŋ kemma neŋgocya qesimiyec; Ni némac iwawai niŋac qesimimaŋ? Ʒéyu neŋgocyanéŋ ézéyec; Doku naec ic Yohaneac oruha niŋac ézéna. ");
INSERT INTO kgf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Imuhuc ʒéyu embac merac inéŋ ara mema focdac ic kewuac muru kemma ʒéyec; Gi degucmi doku naec haka ic Yohaneac orucya ʒéiciguc haima nénna. ");
INSERT INTO kgf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Imuhuc ʒéyu ic kewu imi qeria muŋguc yanda yéwériyec. Waŋu eŋeya ʒézé seliseliawac ʒéma ichéra i guc momacnec tacgic ionac niŋac qahac ʒémaŋ ʒé osiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Waŋu inéŋ focdac yaré ic méŋ keŋ Yohaneac oruha mehamac niŋac ézéma méliyu inéŋ kemma hésa ama qeriaiguc Yohaneac déméŋa qerirec. ");
INSERT INTO kgf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Qericma orucya ʒéiciguc haima mema hama embac merac miyu embac meracnéŋ neŋgocya miyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Waŋu Yohaneac tohotoho ichéra suruc imi nimma hama qamocya mema kemma hoc kifaŋaiguc haigic. ");
INSERT INTO kgf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Waŋu Yesuac Méliméli ic ieneŋ liliŋgéma hama Yesuaru tocgéma wawaŋ memegina ʒéma ackuaʒéc ku énécmigic imuac surucya ézégic. ");
INSERT INTO kgf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Waŋu ic embac sasalanéŋ keŋha waŋgic nene nemuac séc qahac waŋec imuac niŋ inéŋ tohotoho ichéra yomuhuc énézéyec; Ini eŋacnec éléŋ hagic baec kisiaiguc kenni, kemma bénʒéŋ tachiarugic. ");
INSERT INTO kgf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Waŋu eŋacnec éléŋ ʒéiciguc emma baec kisiaiguc keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Keŋgic sasalanéŋ inictegicma ama areŋa kuneŋ kuneŋ séc unuruma baec héna usuŋnec kemma imuaru walac kereŋdacgic. ");
INSERT INTO kgf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kereŋdacgic Yesunéŋ hama ic embac sasala yanda iniru rama galeŋgina qahac tanec kecgic ewa biric wamma iwawai sasala ku énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kuénécmiyu bec kaiwe kiwa sima hiŋgacmaŋ ʒé waŋec. Waŋu tohotoho ichéra ieneŋ iwaru kemma ʒégic; Baec yomi baec kisiaiguc lakec kecni kaiwe kiwa bec sima hiŋgacmaŋ ʒé wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Imuac méli énécmina ama komoc komociguc me ama lelec lelec tacʒac imuaru kemma eŋaoc nenegina mihicŋima boŋa mema nemu. ");
INSERT INTO kgf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ʒégic yomuhuc énézéyec; Eŋaoc gumu énécmigic nemu. Imuhuc énézéyu ʒégic; Nini kemma saméŋ 200 Denarionac sécya boŋa mema hama gumu énécmiwiŋ niŋac ʒézaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ʒégic inéŋ énézéyec; Saméŋ dahec késa kecʒu imuac keŋ héŋgic. Ʒéyu ieneŋ keŋ hémma ézégic; Saméŋ méra méŋ ʒéma konduŋ yaŋ éréhéc he nénécmizac. ");
INSERT INTO kgf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ʒégic Yesunéŋ luluc téŋgiŋ téŋgiŋaiguc tuŋa tuŋa tacmu niŋac areŋgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Areŋgé énécmiyu tuŋ méŋ 100, tuŋ méŋ 50 imuhuc imuhuc tacma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Waŋu saméŋ méra méŋ ʒéma lambéc éréhéc mema kurumeŋiguc hiyu eŋu Anutuac mériaŋ niŋac welerec. Welecma saméŋ kuma tohotoho ichéra énécmiyu ieneŋ méndémma énécmigic. Waŋu imuhucyanec konduŋ yaŋ momacnec méndémma énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Énécmigic ieneŋ mocʒoŋ negic sécgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Waŋu saméŋ bororoŋa ʒéma konduŋ yaŋ tasia tac keŋec imi mema neŋgeŋ yanda 12iguc tigic kuagina qedarec. ");
INSERT INTO kgf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Waŋu saméŋ negic imi ic ionacnec sac qétégina oloŋgic 5,000 waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Waŋu Yesunéŋ tohotoho ichéra ʒéiciguc emma néwécgeŋ Betsaida baec kisiaiguc walac hénima kemmu niŋac focdac wai énécmiyu kemma kecgic eŋeya imi ic embac onopocma naŋkerec. ");
INSERT INTO kgf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Naŋkecma onopodaru kendacgic inéŋ ʒéwelecmaŋ ʒé baec boŋaiguc eŋeyanec eŋec. ");
INSERT INTO kgf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Waŋu ama hénima siŋiyu ʒéic imi konduŋ doku namuŋaiguc kereŋu i eŋeyanec baeciguc kerec. ");
INSERT INTO kgf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Waŋu luhuc yandanéŋ qeyu Yesu tohotoho ichéra ieneŋ ʒéic puli qema ai yanda mema tacgic niŋtegirec. Waŋu ama giaŋimaŋ ʒé waŋu Yesunéŋ doku qahaiguc tima tima keŋkecma ic hosucgé énécmima onogicmaŋ ʒé waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Waŋu doku qahaiguc keŋu ieneŋ hémma Kuwic mia imuhuc ʒéma qac sambigégic. ");
INSERT INTO kgf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","(Ieneŋ momac yanda i hémma ʒénéŋgina hiriyec imuac niŋac imuhuc waŋgic.) Qacgic inéŋ focdac ac hénima énézéyec; Qerigina bénʒéŋ heyu, yomi neŋ mia. Ʒénéŋgina ménda hiriyu. ");
INSERT INTO kgf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Imuhuc ʒéma ʒéic qeriaiguc ionac muru eŋu luhucnéŋ néŋ qema qahac waŋec. Waŋu ieneŋ kileŋ yanda aurima welicgégic. ");
INSERT INTO kgf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Imi mia nene gumu énécmiyec imuac hénia ménda niŋasarigic ewa qerigina sipacgémanec heyu imuhuc aurigic. ");
INSERT INTO kgf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waŋu konduŋ qericma ogicdacma Genesarete baeciguc harédacma ʒéic ʒikigic tarec. ");
INSERT INTO kgf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Taru ʒéic igucnec magic ic embac ieneŋ focdac Yesu héŋtegicgic. ");
INSERT INTO kgf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Héŋtegicma ama séc usuŋnec kemma ic hafiginaguc tataciguc haima hua énécmima imuaru me imuaru kereciguc qesinimma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Waŋu inéŋ ama areŋa yanda me ama areŋa yandaiguc kereŋdaru ic hafiginaguc nénnagémba sombeŋiguc haigic hegic, malekuya susuria késamu niŋac qesimigic. Waŋu késagic séc hiarudacgic. ");
INSERT INTO kgf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Waŋu Farisaio ʒéma héna acac kiwi ic tosara Yerusalemnec harégic ieneŋ Yesuaru tocgégic. ");
INSERT INTO kgf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tocgéma iwac tohotoho ichéra tosara ieneŋ méragina ménda ʒuacma saméŋ negic inicgic. ");
INSERT INTO kgf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farisaio ic ʒéma Yuda ic ieneŋ mocʒoŋ yandahécgina ionac haka silic tohoma méragina ménda ʒuacmaguc nene ménda neaŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Waŋu nénnagémba sombeŋ igucnec liliŋgéma hama méragina ménda ʒuacmaguc nene ménda neaŋgic. Waŋu yandahécgina ionac haka tosara momacnec késakecma méndacaŋgic imi yomuhuc; Sokoc, kasoŋ, kewuc nomuŋ, ʒéic, ʒéma hehe tatac me ʒae ʒuacʒuara.) ");
INSERT INTO kgf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Waŋu Farisaio ic ʒéma héna acac kiwi ic ieneŋ Yesu yomuhuc qesimigic; Némac niŋ tohotoho ichécga ieneŋ yanda hécnina ionac haka silic imi ménda tohoma méragina ménda ʒuacma saméŋ imi nezu? ");
INSERT INTO kgf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ʒégic inéŋ yomuhuc énézéyec; Yesaianéŋ ikoc ic onac niŋ mia ac sécya imi yomuhuc andiawac ʒéyec; Héna oriŋ yomi kua taséginanéŋ sac mepési néŋanʒu, néŋ qeriginanéŋ lakec heanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Waŋu ic eŋaŋ héna acac kuamuma ni imi eŋ mepési néŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ini Anutuac héna ac waigic mayu ic eŋaŋ haka silic késakecanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Imuhuc ʒéma toroqema ʒéyec; Eŋaŋ haka silicgina imi tohoma kecmu niŋac Anutuac héna ac imi hiabianec andé qeanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosenéŋ ac yomuhuc ʒéyec; Gi neŋgoc maŋgoc éréhécga eegira héiwésémaŋ. Waŋu méŋ i neŋgoc maŋgoc éréhécya ʒébiri érécmimac imi qegic humumac. ");
INSERT INTO kgf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Waŋu ini yomuhuc ʒéanʒu; Ic méŋ neŋgoc maŋgocya iorac iwawai méŋ érécmimaŋ ʒé osizaciguc Anutuac buŋa ʒéma érézémac. ");
INSERT INTO kgf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Waŋu ac imi meselima neŋgoc maŋgoc haleŋ hai érécmimia imuac neuŋ héiénécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Imuhuc wamma yanda ionac haka silic imi tétécgéma Anutuac ackuaʒéc héfacgéanʒu. Waŋu ini haka imuhucya sasala waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Imuhuc ʒéma muŋguc ic embac tuŋginaguc imi unuruma énézéyec; Ini mocʒoŋ énézéwa niŋgic. Nimma ac yomi niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Iwawai méŋ negic hiŋgacanʒac iminéŋ ménda mebiri énécmianʒac, néŋ qerigina igucnec iwawai éréanʒac iminéŋ mebiri énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Méŋnéŋ méŋ gezacginaguc eneŋ ac imi niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Waŋu inéŋ ic embac wai énécmima imuac andiaiguc ama méŋiguc eŋec. Eŋu tohotoho ichéra ieneŋ ɋelumbec ac imuac qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Qesimigic énézéyec; Ini momacnec ménda niŋasarizu? Iwawai negic tomeŋginaiguc hiŋgacanʒac iminéŋ ic hia ménda mebirianʒac hénia imi ini ménda niŋasarizu? ");
INSERT INTO kgf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Waŋu iminéŋ ewa qeriginaiguc ménda hiŋgacanʒac, néŋ tomeŋginaiguc hiŋgaru gésiyu maanʒac. Imuhuc ʒéma Yesunéŋ nene hénia hénia imi mocʒoŋ hia newiŋac séc ʒéma héniya imi ʒéseliyec. ");
INSERT INTO kgf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Waŋu méŋ yomuhuc toroqema ʒéyec; Qerigina igucnec iwawai éréanʒac iminéŋ mebiri énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ic qerigina igucnec niniŋ biria éréanʒac imi yomuhuc; Kaisero ai, kowu nene, euqeqe, ");
INSERT INTO kgf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","embac mewai, hémbaoc, qeri biric, ikoc, siŋ biria, kic séséc, andé ac, séwi eŋeŋ, kaiʒiliweŋ. ");
INSERT INTO kgf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iwawai biria imi mocʒoŋ ic qerigina igucnec éréma ic mebiri énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Waŋu inéŋ yacma ama baec imi waima Tiro ama areŋa yandaiguc kemma ama méŋac qeriaiguc eŋec. Emma imuhucgeŋ tacʒac imi ic méŋnéŋ méŋ ménda nimmacac niŋec, néŋ sasaŋgia kekerawac séc ménda waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Eŋu imuarunec embac méŋ bérara uŋa birianéŋ késayec iminéŋ surucya nimma focdac haréma iwac muru simiŋ héimiyec. ");
INSERT INTO kgf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Embac imi Girik embac, Sirofoinikia ic ionac sac kiticgina. Waŋu bérara uŋa biria nesimimac niŋac welecmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Welecmiyu yomuhuc ézéyec; Waina nambérac hécna ieneŋ walac negic sécgémac. Ionac nene imi onagicma kazu ionac gilimaŋ iminéŋ hiabia qahac. ");
INSERT INTO kgf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Imuhuc ʒéyu melemma ézéyec; Miŋ Kewuna, imi hélacnec! Waŋu kazu ieneŋ acguc ʒae duandiaiguc nambérac ieneŋ nene negic bororoŋa mayu neanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Imuhuc ʒéyu Yesunéŋ yomuhuc ézéyec; Ac imuhuc ʒézaŋ imuac niŋ hia liliŋgéma kenna, uŋa birianéŋ béracga bec waimizac. ");
INSERT INTO kgf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ʒéyu embac imi liliŋgéma kemma héŋu uŋa birianéŋ bec waimiyu béracya imi heheyaiguc bénʒéŋ heyec. ");
INSERT INTO kgf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Waŋu Yesu i Tiro ama areŋa yanda imi waima Sidon ama areŋa yanda namuŋanec qericma kemma Dekapoli baec qericma Galilaia konduŋiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Imuaru kereŋu ic tosara ieneŋ ic méŋ gezawa héhéŋgia ʒéma ara hia ménda ʒéaŋec imi Yesuac muru wagicma hama mérianéŋ haimimac niŋac welecmigic. ");
INSERT INTO kgf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Welec migic ic imi wagicma wai énécmima ekacnec sura méŋu kemma méria merawanéŋ gezawaiguc néwéc néwéc haimaguc sépécgéma ezelaŋa osiyec. ");
INSERT INTO kgf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Osima kurumeŋiguc hiyu eŋu wéséséya héima, Efata! ʒéma ézéyec, ac imuac hénia imi ‘Béréŋgéna!’. ");
INSERT INTO kgf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ʒéyu gezawa béréŋgéyec, waŋu ezelaŋa hularu ac didiŋanec ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Waŋu Yesunéŋ suruc imi ménda ʒéaumu niŋac neuŋ héiénécmiyec. Waŋu muŋguc muŋguc qetali énécmiyec, néŋ ieneŋ muŋguc muŋguc kileŋdac ʒéau énécmigic keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ieneŋ kileŋ welicgéma yomuhuc ʒégic; Iwawai mocʒoŋ yanda hia mehiaruanʒac. Gezac héhéŋ meyu ac niŋanʒu, waŋu acgina qahac meyu ac ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nalé imuaru muŋguc ic tuŋ yanda iwaru tocgéma nene qahac kecgic. Yesunéŋ tohotoho ichéra unuruma énézéyec; ");
INSERT INTO kgf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ic embac ieneŋ ai meme haréwéc niguc kecʒu. Waŋu nene méŋ ménda he énécmizac. Imuac niŋ ni ic ionac wéséna wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Waŋu tosara ieneŋ lakecnec hagic imuac niŋ yaka niŋ humugicguc eŋ amaginaiguc méli énécmiwa hénaiguc kemma ɋiritic unuwac niŋac. ");
INSERT INTO kgf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Imuhuc ʒéyu tohotoho ichéra ieneŋ melemma ʒégic; Baec kisia yomuaru mérénéŋ dimuacnec nene saméŋ sécgina hia mihicŋima gumu énécmimac? ");
INSERT INTO kgf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Imuhuc ʒégic qesiénécmima ʒéyec; Onaru héna mauŋ dahec he énécmizac? Ʒéyu melemma 7 ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ʒégic nimma areŋgé énécmiyu baeciguc mama tacgic mauŋ qétéya 7 mema ewa hia ac ézémaguc énécmimu niŋac kuma tohotoho ichéra énécmiyu tohotoho ichéra ieneŋ weleŋ qema énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Waŋu lambéc komoc komoc taru imuhucyanec Anutuac mériaŋ niŋac welecmaguc méndémma énécmimu niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Waŋu ic embac ieneŋ nene imi negic sécgé énécmidarec. Waŋu nene bakia waigic tarec imi mutulaŋgéma neŋgeŋ yanda 7iguc tigic kuagina qedarec. ");
INSERT INTO kgf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Waŋu ic imuaru kecgic ionac qétégina imi 4,000. Waŋu inéŋ méli énécmiyu kendacgic. ");
INSERT INTO kgf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kendacgic imuarunec tohotoho ichéra iniguc ʒéiciguc emma keŋkecma Dalmanuta baeciguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kereŋgic Farisaio ic ieneŋ Yesuguc eminimbiŋ ʒé haréma séséc kurumeŋ igucnec méŋ meyu hémmu niŋac wamma batucgé migic. ");
INSERT INTO kgf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Batucgé migic qeriaiguc wésésé héima ʒéyec; Némac niŋ ic embac nalé yomuarunec imi kiwi méréra hémbiŋ ʒé hocanʒu? Ni hélacnec énézéwa niŋgic; Onaru kiwi méŋ ménda mewa hémmuac séc. ");
INSERT INTO kgf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Imuhuc ʒéma wai énécmima tohotoho ichéra onagiru muŋguc ʒéiciguc emma konduŋ néwécgeŋaiguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waŋu tohotoho ichéra ieneŋ eluŋ unuyu héna mauŋ sécgina ménda mema hagic. Waŋu ʒéic qeriaiguc momacguc sac he énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Waŋu Yesunéŋ yomuhuc selianec énézéyec; Ini Farisaio ic ʒéma Herode ic ionac yis niŋac héŋgaleŋ qacguc wammu. ");
INSERT INTO kgf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Énézéyu eŋaocnec eminiŋ wamma ʒégic; Imi nini héna mauŋ qahac imuac niŋ nénézézac gezaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ʒégic inéŋ niŋasarima énézéyec; Héna mauŋ ménda he énécmizac imuac niŋ némac niŋ eminiŋ qeminiŋ waŋkecʒu? Ini méndagucnec niŋtegicʒu me waŋu méndagucnec niŋasarizu? Qeriginanéŋ seligizac me? ");
INSERT INTO kgf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ini kic ginagucnéŋ iwawai imi ménda héŋanʒu? Ini gezac ginagucnéŋ kileŋdac ac ménda ninʒu me? Waŋu ini ménda niŋɋelizu me? ");
INSERT INTO kgf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ni mauŋ méra méŋ méndémma ic qétégina 5,000 gumu énécmiwa bororoŋa neŋgeŋ yanda dahecac séc hiŋgacma kuagina qeyu megic? Imuhuc qesiénécmiyu, neŋgeŋ 12, ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Waŋu mauŋ 7 imi méndémma ic qétégina 4,000 gumu énécmiwa bororoŋa heyu neŋgeŋ yanda dahecac séc kuagina qeyu megic? Imuhuc ʒéyu, 7, ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ʒégic énézéyec; Ini kileŋdac ménda niŋasarizu? ");
INSERT INTO kgf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Waŋu keŋkecma Betsaida ama areŋa yandaiguc kereŋgic ic ieneŋ ic kic hilic méŋ Yesuaru wagicma hama mérianéŋ haimimac niŋac welecgic. ");
INSERT INTO kgf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Welecgic ic kic hilic imi mériaiguc késama ama yanda waima séŋgaŋgeŋiguc hiŋgacma kiwaiguc sépécgéma méria iwac qahaiguc haima yomuhuc qesimiyec; Iwawai méŋ hénʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Qesimiyu kic hilic inéŋ hima yacma ʒéyec; Ni ic embac inicba ic hésa tanec wamma keŋha wanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ʒéyu inéŋ muŋguc mérianéŋ kiwaiguc haiyu ic imi kic selianec hima héŋu hiaruyu iwawai mocʒoŋ dindiŋanec héŋtegicdarec. ");
INSERT INTO kgf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Waŋu Yesunéŋ amayaiguc mélimima yomuhuc ézéyec; Gi ama yandaiguc ménda lelecgéma kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu i tohotoho ichéra énépésiyu Kaisarea Filipi baeciguc ama areŋa yanda yanda séc kembiŋ ʒéma keŋgic. Keŋkecma hénaiguc tohotoho ichéra qesiénécmima ʒéyec; Ic embac ieneŋ nuac niŋ méré ʒéanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Qesiyu ʒégic; Ic embac tosara ieneŋ doku naec haka ic Yohane imi mia imuhuc ʒéanʒu, waŋu tosara ieneŋ Elia, tosara ieneŋ mia Anutuac kua meme ic ionarunec méŋ ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ʒégic muŋguc qesiénécmiyec; Waŋu eŋaoc nuac niŋ méré ʒéanʒu? Ʒéyu Peteronéŋ yomuhuc ézéyec; Gi Kristo. ");
INSERT INTO kgf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Imuhuc ʒéyu inéŋ ic tosara ménda énézému niŋac neuŋ héiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Waŋu inéŋ yomuhuc hénima ku énécmiyec; Héna imi yomuhuc hezac; Icac Naŋa imi kecma qenʒeŋ manʒeŋ kileŋ nimmac. Niŋu ic galeŋ ʒéma hofac oo ic kuneŋ éréhécgina ʒéma héna acac kiwi ic ieneŋ andé qemigic qegic humumac. Humuyu kaiwe haréwéc waŋu humuc igucnec ɋelima yacmac. ");
INSERT INTO kgf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Inéŋ ac imuhuc ʒéauyu Peteronéŋ Yesu késama qetalimima ac wammiyec. ");
INSERT INTO kgf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Waŋu inéŋ melemma merac ionac muru kiwa hima Petero qetali mima ézéyec; Biria miŋina gi hocma andénaiguc nanna, gi Anutuac ackuaʒéc niŋac ménda wamma ic onac iwawai niŋac wamma kecʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Waŋu Yesunéŋ ic tuŋ yanda kecgic imi ʒéma tohotoho ichéra momacnec unuruma yomuhuc énézéyec; Ic méŋnéŋ ni méndac némmaŋ ʒémaciguc andé qeamuma eŋeya ic héŋgeŋa wéndara huama méndac némmac. ");
INSERT INTO kgf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ic méŋnéŋ méŋ kekecya aŋgé timaŋ ʒé waŋu kekecya imi sohomac. Waŋu ic méŋnéŋ méŋ nuac ʒéma buŋa suruc hiabia imuac niŋ wamma kekecya waiyu kekecya imi ménda sohomac. ");
INSERT INTO kgf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ic méŋnéŋ baecac iwawai mocʒoŋ késama keru uŋaya waimiyu iwawai iminéŋ dimuhuc naŋgé mimac? ");
INSERT INTO kgf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ic méŋnéŋ némac iwawaiyanéŋ uŋayaguc amuwagic waŋu sécgémac? ");
INSERT INTO kgf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ic méŋnéŋ ɋeli yackumu kaiseroya ʒéma képésic ginaguc ionac ségéra ginaiguc ni ʒéma acna niŋac gamuya ninʒaciguc imuhucyanec Icac Naŋa iminéŋ Maŋgocyawac edamuyaiguc kua meme uŋahéraguc liliŋgéma hamac nalé imuaru iwac niŋ gamuya nimmac. ");
INSERT INTO kgf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Waŋu inéŋ yomuhuc énézéyec; Ni hélanec énézéwa niŋgic; You nanʒu onarunec tosara ini humucnéŋ ménda énépésiyunec Anutuac héŋgaleŋ ama areŋa yanda imi kuhaguc hayu hémmu. ");
INSERT INTO kgf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Waŋu ai meme 6 tecgéyu Yesunéŋ Petero ʒéma Yakobo ʒéma Yohane onagiru baec boŋa yandaiguc eŋgic. Emma imuaru eŋacnec kecgic. Waŋu inéŋ imuaru kicginaiguc melemma tanera méŋ waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Waŋu iwac malekuya imi lalac koŋac koŋac waŋec. Baeciguc ic méŋ iwawai méŋnéŋ ʒuaru imuhucya wammacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Waŋu baec imuaru Mose ʒéma Elia iereŋ ionac kicginaiguc wininima Yesuguc acac waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Imuhuc waŋgic Peteronéŋ Yesu ézéyec; Kiwi ic you kecʒiŋ imi hiabia soroc. Nénézéna hali haréwéc meénécmini méŋ guac, méŋ Moseac, méŋ Eliawac wammac. ");
INSERT INTO kgf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Merac ieneŋ bacgina yandiyec imuac niŋac Peteronéŋ némac ac ʒémaŋ ʒéma hocma imuhuc ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Waŋu hosusunéŋ mama oso énécmiyu imuac qeria igucnec ac méŋ yomuhuc mayec; Yomi imi naŋna, héŋsorocanʒua, iwac ara nimmu. ");
INSERT INTO kgf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Waŋu liliŋgéma héŋgic élanzaŋnec aulaŋgéyic Yesunéŋ sac naŋec. ");
INSERT INTO kgf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Waŋu boŋa igucnec mama hama Yesunéŋ ac yomuhuc énézéma ʒéseliyec; Iwawai hénʒu imuac ac suruc imi méŋ ménda énézému, kecma biaŋ Icac Naŋa humuc igucnec yaruguc. ");
INSERT INTO kgf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Imuhuc énézéyu merac ieneŋ ac imi qeriginaiguc haima humuc igucnec yacyac imuac hénia hocma eŋaocnec eminiŋ qeminiŋ waŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Waŋu ieneŋ Yesu yomuhuc qesimima ʒégic; Némac niŋ héna acac kiwi ic ieneŋ Elia walac hamac imuhuc ʒéanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Imuhuc qesimigic énézéyec; “Hélacnec Elia i walac hama iwawai mocʒoŋ meɋeliyuguc. Waŋu némac niŋ Icac Naŋa i andé qemigic qenʒeŋ manʒeŋ kileŋ nimmac imuhuc ogic hezac me? ");
INSERT INTO kgf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Waŋu énézéwa niŋgic; Elia i hélacnec hama keru iwawai iwac niŋ kiwiiguc ogic hezac imuac sécya ieneŋ ewa siŋginawac wammigic.” ");
INSERT INTO kgf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Waŋu merac tosara wai énécmigic kecgic ionac muru haréma inicgic ic embac sasala oso énécmima naŋgic héna acac kiwi ic tosara merac iniguc tualefic emigic. ");
INSERT INTO kgf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Waŋu ic embac ieneŋ nalé qahacgucnec Yesu hémma kileŋ welicgéma usuŋnec kemma ewa hia ac ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ʒémigic inéŋ qesiénécmiyec; Ini némac niŋac tualefic emikecʒu? ");
INSERT INTO kgf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ʒéyu sucgina igucnec méŋnéŋ melemma ézéyec; Kiwi ic meracna uŋa birianéŋ késayu ara qahac kecanʒac imuac niŋac wagicba guaru hazic. ");
INSERT INTO kgf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Merac imi dimucgeŋ dimucgeŋ uŋa birianéŋ késama hérékeŋ héréha wamma baeciguc giliyu kua hololoŋa mayu ʒéra aric aric kiyu héna méria séréŋgéanʒac. Waŋu tohotoho ichécga ieneŋ nesimu niŋac énézéwa nesimuac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ʒéyu Yesunéŋ yomuhuc énézéyec; O! Nalé yomuac hicŋisaiya ini ninʒéŋ ninʒéŋgina qahac. Ni iniguc nalé dahecac séc kecmaŋ? Nalé dahecac séc ini bisiqatéŋ waŋ énécmimaŋ? Merac imi nuaru wagicma hagic. ");
INSERT INTO kgf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Imuhuc ʒéyu merac iwaru wagicma hagic uŋa biria inéŋ Yesu hémma merac hérékeŋ héréha yanda wammiyu tétéŋgéma baeciguc mama héima heyu kua hololoŋa mayec. ");
INSERT INTO kgf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Waŋu Yesunéŋ merac maŋgocya qesimima ʒéyec; Iwawai imi némac naléiguc hicŋimiyecac kecanʒac? Ʒéyu ʒéyec; Imi kokocya igucnec hicŋimiyecac kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Inéŋ merac imi nalé momac momac mebirimaŋ ʒéma geric bélaŋaiguc me dokuiguc gilianʒac. Iwawai méŋ wambésémaŋac séciguc ewa biric wamma méra nérécmina. ");
INSERT INTO kgf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Imuhuc ʒéyu Yesunéŋ ac yomuhuc melemma ézéyec; Hénia némac niŋac wambésémaŋac séciguc imuhuc ʒézaŋ? Ic méŋ ninʒéŋ ninʒéŋagucnéŋ iwawai mocʒoŋ hia wandacmac. ");
INSERT INTO kgf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ʒéyu imuarunec mia merac maŋgocyanéŋ ac qacma yomuhuc ʒéyec; Ni ninʒéŋgézua, geŋgaoc ninʒéŋ ninʒéŋna bébélacgia imi meseli nénna. ");
INSERT INTO kgf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Waŋu ic embac ieneŋ usuŋnec tocgéma hagic inicma uŋa biriawac yomuhuc ézéyec; Ac qahac kekerawac uŋaya ʒéma gezac héhéŋac uŋaya, ni gézézua, iwarunec éréma imuaru muŋguc ménda hiŋgacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ʒéyu uŋa birianéŋ qacsilacma selianec héréma qéfacgé mima éréma keŋu merac imi hélanec humumia tanec heyec. Heyu ic embac sasalanéŋ hémma, Humuzac, ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Waŋu Yesunéŋ iwac mériaiguc késama héréyu yacma naŋec. ");
INSERT INTO kgf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Waŋu Yesu imi ama qeriaiguc eŋu tohotoho ichéra ieneŋ sasaŋgiaiguc qesima ʒégic; Nini némac niŋac nesiwiŋac séc qahac waŋec? ");
INSERT INTO kgf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Imuhuc ʒégic melemma énézéyec; Imuhucya imi iwawai tosara méŋnéŋ nesi énécmiwiŋac séc qahac, néŋ ʒéwelecginanéŋ sac hia nesi énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Waŋu ieneŋ ama imi waima kemma Galilaia baec qericma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Waŋu Yesunéŋ tohotoho ichéra ku énécmimaŋ ʒéma i ʒéma tohotoho ichéra dimuaru kecʒu imi méŋnéŋ méŋ ménda nimmu niŋac waŋec. Waŋu yomuhuc ku énécmiyec; Icac Naŋa i ic ionac méraiguc eŋu qegic humumac. Humuma ai meme haréwéc waŋu yacmac. ");
INSERT INTO kgf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Waŋu ac imuac hénia ménda niŋasarima qesimiwiŋ ʒé niŋgic yéwériyec. ");
INSERT INTO kgf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Waŋu keŋkecma Kafanaum ama areŋa yandaiguc haréma ama méŋ qeriaiguc emma tacma imuaru tohotoho ichéra qesiénécmiyec; Hénaiguc némac iwawai niŋac tualefic emikecʒu? ");
INSERT INTO kgf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Imuhuc qesiénécmiyu ieneŋ neŋaŋ murunec mérénéŋ kiwanina kecʒac imuhuc ʒéma tualefic emizu imuac niŋac ara hia ménda meleŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Waŋu mama tacma 12 ini unuruma énézéyec; Méŋ i kiwagina kecmaŋ ʒémaciguc, tosara ionac mamayagina kecma weleŋ qeqegina wammac. ");
INSERT INTO kgf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Imuhuc ʒéma merac komora méŋ wagicma sucginaiguc haiyu naŋu tétécgé mima énézéyec; ");
INSERT INTO kgf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Méŋnéŋ merac yomuhucya nuac qacnaiguc ewa hia wammizac imi ni ewa hia wannénʒac wanʒac. Méŋnéŋ ni ewa hia wannénʒac imi nuac qahac, néŋ méli néŋec i ewa hia wammizac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Waŋu Yohanenéŋ yomuhuc ézéyec; Kiwi ic, nini ic méŋnéŋ guac qacga qacma uŋa biria nesi énécmiyu ménda méndac nénécmianʒac imuac niŋ neuŋ héimiyiŋ. ");
INSERT INTO kgf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ʒéyu Yesunéŋ yomuhuc énézéyec; Ménda qetali mimu. Méŋ i nuac qacna qacma ai kucyaguc mezac imuhucyanéŋ nalé hotoŋa imuac qeriaiguc efima ʒébiri némmacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Némac niŋac? Méŋ neŋaŋ andé ménda nunuanʒac iminéŋ haʒécnina qahac. ");
INSERT INTO kgf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ni hélacnec énézéwa; Ic méŋnéŋ ini Kristoac ichéra kecʒu imuac niŋ nuac qacnaiguc doku méŋ hima gumu énécmimac imi iwac boŋa imi kileŋdac ménda qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Waŋu méŋnéŋ nambérac komoc komoc ni ninʒéŋgé néŋanʒu ionarunec méŋ manam batuc wammiyu biria memac imi hoc yanda ic iwac déméŋaiguc ʒikimima konduŋiguc naŋgégic hiŋgacmac iminéŋ hia wammac. ");
INSERT INTO kgf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Waŋu méraganéŋ biriaiguc goporu méraga imi héricbésémaŋ. Gi méra éréhécgaguc geric sia tetecgia qahaciguc hiŋgacbaŋ niŋac, puriŋ wamma kekec hémbénaŋaiguc kerembésémaŋ iminéŋ hia. ");
INSERT INTO kgf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Ménda hezac.) ");
INSERT INTO kgf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Waŋu hénaganéŋ biriaiguc goporu héricbésémaŋ. Héna éréhécgaguc kecma geric siaiguc giligic hiŋgacbaŋ niŋac, puriŋ wamma kekec hémbénaŋaiguc kerembésémaŋ iminéŋ hia. ");
INSERT INTO kgf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Ménda hezac.) ");
INSERT INTO kgf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Waŋu kicganéŋ biriaiguc goporu kicga imi metecgéna. Gi kic éréhécgaguc geric siaiguc giligic hiŋgacbaŋ niŋac, kicga momacguc kecma Miŋ Kewuac héŋgaleŋ ama areŋa yandaiguc kerembésémaŋ iminéŋ hia. ");
INSERT INTO kgf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Imuaru ionac nanecgina imi ménda humumac, waŋu geric bélaŋa imi ménda békémac. ");
INSERT INTO kgf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mulu memeac buŋa mesolaŋaniwiŋ ʒé sei hésianʒu imuhucyanec ic momac yanda geric bélaŋanéŋ meʒeric énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sei imi qacguc, néŋ siŋa qahac waŋu némacnéŋ mindiŋigic siŋaguc wammac. Sucginaiguc sei hésigic luae heyu eŋawu kecmu. ");
INSERT INTO kgf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesunéŋ imuarunec yacma Yodan néwécgeŋ Yuda baeciguc haréyu ic sasala yandanéŋ muŋguc iwaru tocgégic. Waŋu waŋaŋec imuhucyanec muŋguc ackuaʒéc ku énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Waŋu Farisaio ic ieneŋ hosuru haréma manam batuc wammima qesimigic; Ic méŋnéŋ iniŋa waimimac imi héna acac sécya me qahac? ");
INSERT INTO kgf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ʒégic melemma énézéyec; Mosenéŋ deic ʒéma énézéyec? ");
INSERT INTO kgf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Énézéyu ʒégic; Mosenéŋ yomuhuc oaec ʒénénécmiyec; Embac waimaŋ ʒéma waia muamuac kiwi omima waimimac. ");
INSERT INTO kgf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Imuhuc ʒégic Yesunéŋ énézéyec; Mose i ewa seligina niŋac wamma héna ac imi oma énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Néŋ hénihéniaiguc imi Anutunéŋ ic ʒéma embac meérécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Imuac niŋac ic méŋnéŋ neŋgoc ʒéma maŋgocya wai érécmima iniŋawac muru héiselimac. ");
INSERT INTO kgf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Héiseliyu éréhécnéŋ séwi momacguc wammaoc, waŋu bec iereŋ éréhéc qahac, néŋ momacguc. ");
INSERT INTO kgf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Imuac niŋac iwawai méŋ Anutunéŋ dérécgéyec imi ic méŋnéŋ ménda méndéŋ érécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Waŋu ama qeriaiguc emma tohotoho ichéra ieneŋ ac imuac niŋac muŋguc qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Qesimigic inéŋ melemma énézéyec; Ic méŋnéŋ iniŋa waima méŋ memaciguc imi mia iniŋa kaisero wammizac tanec wammac. ");
INSERT INTO kgf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Waŋu embac méŋnéŋ euya waimima ic méŋ memac imi imuhucyanec kaisero wanʒac wammac. ");
INSERT INTO kgf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Waŋu ic embac ieneŋ Yesunéŋ mérianéŋ osiénécmimac niŋac nambérac hécgina onagicma iwac muru hagic. Waŋu tohotoho ichéra ieneŋ ac ʒéénécmima ʒéqeqetali waŋ énécmigic. ");
INSERT INTO kgf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Waŋu Yesunéŋ héŋu qeria biriyu énézéyec; Waigic nambérac nuaru hagic. Ʒéqeqetali ménda waŋ énécmigic. Anutuac héŋgaleŋ ama areŋa yanda imi nambérac imuhucya ionac buŋa. ");
INSERT INTO kgf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Hélacnec énézéwa; Méŋnéŋ Anutuac héŋgaleŋ ama areŋa yanda qeriaiguc emmaŋ ʒé nambérac ésécnec ménda wammaciguc inéŋ imuac qeriaiguc kileŋdac ménda keremmac. ");
INSERT INTO kgf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Imuhuc ʒéma tétécgé énécmima méria ionac qacginaiguc haima mériaŋ ac ʒéma énézéyec. ");
INSERT INTO kgf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Waŋu Yesunéŋ hénaiguc kemma keru ic méŋnéŋ usuŋnec iwaru hama iwac muru simiŋ héimima qesimima ʒéyec; Kiwi ic hiabia, ni dimuhuc wamma kekec hémbénaŋa imi késamaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ʒéyu Yesunéŋ ézéyec; Némac niŋ ic hiabia ʒénénʒaŋ? Ic méŋnéŋ hiabia qahac. Anutu momacguc sac hiabia. ");
INSERT INTO kgf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Gi héna ac yomuhuc niŋanʒaŋ; Kaisero ménda wambésémaŋ. Eu qeqe ménda wambésémaŋ. Kowu ménda newésémaŋ. Héipuc ac ʒémaŋ ʒé ikoc ac ménda ʒéwésémaŋ. Ikoc waŋ énécmima iwawai méŋ ménda onagicbésémaŋ. Neŋgoc maŋgoc éréhécga eegira héiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ʒéyu melemma yomuhuc ézéyec; Kiwi ic ni imi mocʒoŋ komocna igucnec tohoma keriac kecʒua. ");
INSERT INTO kgf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Waŋu Yesunéŋ hémma iwac siŋ nimmima yomuhuc ʒéma ézéyec; Haka hiabia momacgucnéŋ guaru ménda hegénʒac. Kemma iwawai hegénʒac imi haina boŋa géŋgic, mema ic maqeqeya énécmina, kurumeŋiguc héla hegémmac. Waŋu hama ic héŋgeŋa wéndara imi huama ni méndac némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Waŋu soukiwa ʒéma iwawai yéwéria hemiyec. Imuac niŋ, niŋ yéwériyu tanera méŋ waŋu waima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Keŋu Yesunéŋ kiwa hiyu lelecgéyu tohotoho ichéra yomuhuc ʒéma énézéyec; Ic soukiwa ʒéma hina yanda ginagucnéŋ Anutuac héŋgaleŋ ama areŋa yanda qeriaiguc kerembiŋ ʒégic yéwériyu hia ménda efima keremmu. ");
INSERT INTO kgf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Waŋu tohotoho ichéra ara imi nimma welicgégic. Waŋu inéŋ muŋguc toroqema énézéyec; Merachécna, Anutuac héŋgaleŋ ama areŋa yandaiguc eŋeŋa imi yéwéria yanda. ");
INSERT INTO kgf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yaŋ yanda kamelenéŋ qodu kifaŋa komoraiguc keremmac imi efefia, néŋ soukiwa yanda ʒéma iwawai yanda ginagucnéŋ Anutuac héŋgaleŋ ama areŋa yandaiguc keremmac iminéŋ yéwéria yanda. ");
INSERT INTO kgf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Imuhuc ʒéyu tohotoho ichéra ieneŋ nimma kileŋ yanda aurima eŋaoc eminiŋ qeminiŋ waŋamuma ʒégic; Imuhuc waŋu, mérac késayu kekec hémbénaŋa hia memac? ");
INSERT INTO kgf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesunéŋ inicma ʒéyec; Ic eneŋ imi meselimuac séc qahac, waŋu Anutunéŋ hia, Anutunéŋ iwawai mocʒoŋ imi hia memac. ");
INSERT INTO kgf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ʒéyu, Peteronéŋ hénima ézéyec; Ninna, nini iwawainina mocʒoŋ waima gi méndac géŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ʒéyu, Yesunéŋ melemma ʒéyec; Ni hélacnec énézéwa, méŋnéŋ nuac niŋ ʒéma buŋa suruc hiabia niŋac wamma ama geric me dac muna me neŋgoc maŋgoc me naŋa me bérara me baec ai imi waimac imi, ");
INSERT INTO kgf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","you baeciguc ama geric, dac munahéra, neŋgoc maŋgochéra, nambérac héra, ʒéma baec aiya sasala yanda imi qété 100 imuac séc ogicma memac. Waŋu haʒéc ac me yaré momacnec mihicŋimac. Waŋu biaŋguc kurumeŋ amaiguc kekec seli memac. ");
INSERT INTO kgf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Waŋu walac walac ionac murunec sasalanéŋ andia wammu. Waŋu andia ionac murunec sasalanéŋ walac walac wammu. ");
INSERT INTO kgf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kecma Yerusalem ekemma kecma Yesunéŋ walac walac kemma keru tohotoho ichéra ieneŋ bacgina yandiyec. Waŋu nesi énécmigic ieneŋ ʒénéŋgina hiriyec. Waŋu Yesunéŋ tohotoho ichéra 12 qutulaŋgé énécmima iwawai hicŋimimac imuac ac énézéma ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Héŋgic, neŋaŋ Yerusalem enʒiŋ. Enni imuaru Icac Naŋa imi andé qemiyu hofac oo ic kiwa ʒéma héna acac kiwi ic ionac méraginaiguc eŋu, képésiraguc ʒéma humucac buŋa ʒétecgéma ic enia ionac muru haimu. ");
INSERT INTO kgf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Haigic ieneŋ ʒébiri mima sépécgé mima rikuŋ ʒéragucnéŋ héimaguc qehumumu. Waŋu kaiwe haréwéc waŋu, inéŋ humuc igucnec ɋelima yacmac. ");
INSERT INTO kgf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ʒéyu Ʒebedaioac naŋhéréra Yakobo ʒéma Yohane iereŋ Yesuac muru hosuru hama ʒéyoc; Kiwi ic, niri iwawai imuac me imuac niŋac wamma qesigémbic imi geŋ hia menéréc miwésémaŋ niŋac ʒéma ninʒic. ");
INSERT INTO kgf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ʒéyic érézéyec; Néma iwawai meérécmimaŋ niŋac wanʒaoc? ");
INSERT INTO kgf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Waŋu iereŋ ʒéyoc; Gi edamuga winini géŋu, nururuna, méŋ héigaiguc méŋ kanagaiguc tacbic. ");
INSERT INTO kgf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ʒéyic Yesunéŋ érézéyec; Iri hénia ménda niŋasarima imuhuc welecʒaoc. Ni sokoc mema nemaŋ imi iri hia mema nemaoc? Waŋu doku naecnémmu imuac iri hia naecmaoc? ");
INSERT INTO kgf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ʒéyu, iereŋ ʒéyoc; Oo, imi hia wambic. Ʒéyic, Yesunéŋ yomuhuc érézéyec; Ni sokoc mema nemaŋ imi iri hélacnec nemaoc. Waŋu doku naecnémmu imi iri naecmaoc. ");
INSERT INTO kgf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Waŋu nuac héinaiguc me kananaiguc tatara imi énécmimia imi nuac ai qahac. Imi méŋac méŋ ʒéénécmiyec ionac énécmiyu késama tacmu. ");
INSERT INTO kgf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tohotoho ichéra 10 ieneŋ ac imi nimma Yakobo ʒéma Yohane iorac niŋgic ewagina biriyec. ");
INSERT INTO kgf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Waŋu Yesunéŋ unuruma énézéyec; Ic enia ionac ic kewu ieneŋ ic embac énépésigic, ic embac ieneŋ weleŋ qeénécmianʒu. Waŋu eŋeŋa ieneŋ mamaya méra bacginaiguc onopocma ic kewu waŋ énécmianʒu imi ini ninʒu. ");
INSERT INTO kgf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Waŋu onaru imi héna imuhuc ménda hezac. Onarunec méŋnéŋ kuneŋgina wammaŋ ʒéma alahéra ionac weleŋ qeqe kecmac. ");
INSERT INTO kgf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Onarunec méŋnéŋ walac walac kecmaŋ ʒéma alahéra ionac ai merac kecmac. ");
INSERT INTO kgf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Icac Naŋa i weleŋ qemimu niŋac ménda mayec. I eŋeyaoc weleŋ qeqe ai mema ic sasala onac niŋ mulu memeac iwawai ésécnec kekecya énécmimaŋ ʒé mayec. ");
INSERT INTO kgf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Waŋu ieneŋ hakecma Yeriko tauŋiguc harégic. Waŋu inéŋ tohotoho ichéra ʒéma ic sasala yanda iniguc ama areŋa yanda imi waima keŋkecgic, ic kic hilic méŋ qara Batimaio, Timaiuac naŋa inéŋ héna giŋgiŋaiguc iwawai niŋac welecma tarec. ");
INSERT INTO kgf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Waŋu inéŋ ic imi Yesu Naʒarete ama areŋa igucnec imuhuc ʒégic nimma hénima qarec; Dawidiac ɋeli Yesu, gi nuac niŋ ewa biric waŋ nénna! ");
INSERT INTO kgf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ʒéyu ic sasalanéŋ ac waima tacmac niŋac ʒéqeqetali wammigic. Waŋu inéŋ seli seli wamma selianec qacsilarec; Dawidiac naŋa, gi nuac niŋ ewa biric waŋ nénna! ");
INSERT INTO kgf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Qac keru, Yesunéŋ hénaiguc namma ʒéyec; Héihéré migic. Imuhuc ʒéyu, ic ieneŋ kic hilic ézégic; Efima yacma hana! Inéŋ héihéré génʒac. ");
INSERT INTO kgf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Waŋu kic hilicnéŋ malekuya gilima técgéma yacma Yesuac muru hayec. ");
INSERT INTO kgf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Waŋu, Yesunéŋ ac bakia ʒéma qesimiyec; Némac waŋgémmaŋ niŋac wanʒaŋ? Ʒéyu, kic hilicnéŋ ézéyec; Kiwi ic, ni kicna hima hémmaŋ niŋac wanʒua. ");
INSERT INTO kgf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ʒéyu, Yesunéŋ ézéyec; Gi kenna, ninʒéŋ ninʒéŋganéŋ mehiaru génʒac. Imuhuc ʒéyu, imuarunec kiwa béréŋgéyu hima héŋec. Waŋu hénaiguc Yesu méndac mima keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Waŋu Yerusalem hosuraiguc hama Oliwa baec boŋaiguc Betfage ama areŋa yanda ʒéma Betania ama areŋa taroc imuaru dodowigic. Dodowima Yesunéŋ tohotoho ichéréra méli érécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Waŋu méli érécmima yomuhuc érézéyec; Ama wéségiraiguc tacʒac imuaru keŋic, doŋki merawa méŋ icnéŋ qahaiguc ménda tacanʒu imi ɋatégic naŋu focdac mihicŋimaoc. Mihicŋima imi hulacma késama hamaoc. ");
INSERT INTO kgf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Hularic ic méŋnéŋ, Némac niŋ imuhuc wanʒaoc? Imuhuc ʒéyuguc, yomuhuc ézémaoc; Miŋ Kewuniranéŋ imuac wanʒac. Imuhuc ʒéic focdac haiyu yomuaru hamac. ");
INSERT INTO kgf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ʒéyu tecgéyu, iereŋ kemma doŋki merawa ama demiŋawac saŋgulaŋ séŋgaŋgeŋ hénaiguc ɋatégic naŋu mihicŋima hularoc. ");
INSERT INTO kgf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hularic ic naŋgic ionarunec tosaranéŋ yomuhuc érézégic; Iri doŋki merawa imi némac niŋac hulacʒaoc? ");
INSERT INTO kgf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Imuhuc ʒéyu Yesu ac érézéyec imuhucyanec melemma énézéyoc. Énézéyic wai érécmigic hayoc. ");
INSERT INTO kgf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Waŋu iereŋ Yesuaru doŋki wagicma hayoc. Hama qahaiguc malekugina haigic inéŋ emma tarec. ");
INSERT INTO kgf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Waŋu ic sasalanéŋ malekugina hénaiguc témbécgic. Waŋu tosaranéŋ ai igucnec ic hawa haréŋa ʒéma ʒuriaguc mericma hénaiguc lémbécgic. ");
INSERT INTO kgf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Waŋu ic tuŋ yanda ieneŋ walac andu wamma qacgic; Hosanna, ohec wahec! Miŋ Kewuac qac buŋaguc hazac ic imi ʒézé bipiyaguc. ");
INSERT INTO kgf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ambéc sakoŋnina Dawidiac héŋgaleŋ ama areŋa yanda imi Miŋ Kewuac qac buŋaguc hazac imi ʒézé bipiyaguc. Hosanna, ohec wahec! Anutu ou kurumeŋiguc eŋeŋa kecʒac. ");
INSERT INTO kgf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Waŋu Yesunéŋ Yerusalem keremma ocmuŋ téréyaiguc eŋec. Emma iwawai mocʒoŋ lelecgéma héŋu, bec ama mari mari waŋu, tohotoho ichéra 12 iniguc Betania ama areŋaiguc keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ama giaŋiyu ieneŋ Betania ama areŋa waima keŋgic. Keŋkecma Yesu nene niŋac waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Waŋu fik ic méŋ haréŋaguc lakec naŋu hémma héla tacʒac me deic imuhuc ʒéma kemma horec. Waŋu fik ic imuac naléya qahac imuac niŋac haréŋanec naŋec. ");
INSERT INTO kgf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Waŋu hémma fik ic imi yomuhuc ʒéma ézéyec; Deguc muacnec hénima hélaga ic méŋnéŋ muŋguc ménda nemac. Imuhuc ʒéyu tohotoho ichéra ieneŋ ac imi niŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Waŋu Yerusalem kereŋgic, Yesunéŋ ocmuŋ téréyaiguc emma ic embac imuaru iwawai nénna gémba ʒéma naŋgic, imi nesi énécmima ic tosara ʒae haima tacma soukiwa gocmianéŋ soukiwa haréŋa amuanʒu ionac ʒae ʒéma kembo haima imuac boŋa meanʒu ionac tatac imi meleŋ daru hiŋgarec. ");
INSERT INTO kgf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Waŋu ocmuŋ téréya qeriaiguc iwawai imuhucya ménda késa keŋha wammu niŋac qeqetali ac waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Waŋu yomuhuc ku énécmima ʒéyec; Amanawac niŋac baec séc ic embac onac ʒéwelec welec ama ʒému. Imuhuc kiwiiguc ménda ogic hezac me? Waŋu ini imuhuc waŋgic kowu nene ionac baŋec tanec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Imuhuc ʒéyu hofac oo ic kiwahécgina ʒéma héna acac kiwi ic ieneŋ niŋgic. Waŋu ic embac sasalanéŋ ackuaʒécya niŋac welicgémigic eŋeŋa waŋec. Imuac niŋac ʒénéŋgina hiriyu dimuhuc wamma qeni ʒéma héna hocgic. ");
INSERT INTO kgf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Waŋu ama mari waŋu Yesu ʒéma ichéra ieneŋ ama areŋa yanda imi waima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Waŋu ama muŋguc giaŋiyu ieneŋ muŋguc yacma keŋgic. Keŋkecma fik ic imi héŋgic hénia igucnec humuma naŋec. ");
INSERT INTO kgf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Waŋu Peteronéŋ niŋɋelima ézéyec; Kiwi ic, hénna, fik ic ʒébiri minec, imi humuma nanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Imuhuc ʒéyu Yesunéŋ melemma énézéyec; Anutu ninʒéŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Hélacnec énézéwa, méŋ i boŋa youmi bacgéma konduŋiguc hiŋgacna ʒéma qeriaiguc ewa éréhéc ménda wamma ara ʒézac imuac héla hicŋimac ʒéma ninʒéŋgéyu imi hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Imuac niŋac énézéwa niŋgic, ini iwawai imuac me imuac niŋac welecmu imi bec meziŋ ʒéma ninʒéŋgému. Imuhuc waŋgic ʒézu imuac sécya hicŋi énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Waŋu yacma welecmu nalé imuaru ic méŋac niniŋ biria méŋ késa kecʒuiguc képésira imi waimimu. Imuhuc waŋgic Maŋgocgina kurumeŋiguc kecʒac inéŋ imuhucyanec onac képésicgina wai énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Waŋu ini képésicya imi ménda waimimuiguc onac Maŋgocgina kurumeŋiguc kecʒac inéŋ imuhucyanec onac képésicgina ménda wai énécmimac.) ");
INSERT INTO kgf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Waŋu ieneŋ muŋguc Yerusalem liliŋgéma hagic. Hama Yesunéŋ ocmuŋ téréyaiguc emma lelecgéma keru hofac oo ic kiwa ʒéma héna acac kiwi ic ʒéma ic kiwa meme ieneŋ iwac muru hagic. ");
INSERT INTO kgf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Hama yomuhuc qesimima ʒégic; Néma qac buŋagaguc ai imi meanʒaŋ? Mérénéŋ gézéyu ai imi meanʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Imuhuc ʒégic Yesunéŋ melemma énézéyec; Ni imuhucyanec ac méŋ yomi qesiénécmiwa melemmu. Meleŋgicguc neŋ néma qac buŋanaguc ai imi meanʒua imi ʒéaumaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Imuhuc ʒéma yomuhuc qesiénécmiyec; Melemma ʒégic nimba, Yohaneac doku naec ai imi kurumeŋ igucnec me ic onarunec? ");
INSERT INTO kgf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Imuhuc énézéyu eŋaocnec eminiŋ qeminiŋ wamma ʒégic; Neŋaoc kurumeŋ igucnec ʒéni, Némac niŋ i ménda ninʒéŋgé migic? Imuhuc ʒémac. ");
INSERT INTO kgf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Waŋu ic igucnec ʒéwiŋ ʒéma niŋgic, ic embac mocʒoŋ Yohaneac niŋac ic imi Anutuac kua meme ic héla imuhuc ʒéma nimmigic, imuac niŋac ic embac ionac niŋ bacgina yandiyec. ");
INSERT INTO kgf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Imuhuc ʒénimma Yesu ézégic; Nini ménda ninʒiŋ. Imuhuc ʒégic Yesunéŋ énézéyec; Imuhucyanec néma qac buŋanaguc ai imi meanʒua imi ménda énézémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesunéŋ hénima ɋelumbec ac méŋ yomuhuc énézéyec; Ic méŋnéŋ baec méŋiguc waiŋ ic himicma lelecgéma imuac demiŋa meyec. Mema waiŋ gocmiawac dokuya gésiwiŋac ʒéma baec éséma kifaŋa yanda meyec. Mema imuaru galeŋ meme ama lesu herec méŋ meyu eŋec. Eŋu ai imi ai ic ionac méraginaiguc haima baec méŋiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kemma keru yawuŋa ducŋiyu héla memac niŋac weleŋ qeqe ic méŋ mélimiyec. ");
INSERT INTO kgf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mélimiyu, i késama qema nesigic eŋnec liliŋgéyec. ");
INSERT INTO kgf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Liliŋgéyu miŋinanéŋ weleŋ qeqe merac méŋ muŋguc méliyu keŋec. Keŋu oruha hocnéŋ qésémma gamu qeqe wammima nesigic keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Waŋu méŋ méŋgucnec mélimiyu keŋu ic imi qegic humuyec. Waŋu imuhucyanec weleŋ qeqe ic sasala méli énécmiyu ai ic ieneŋ tosara ʒépé unugic tosara humumia unugic. ");
INSERT INTO kgf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Waŋu momacguc kecmiyec imi eŋeya naŋ sorocya ewayanéŋ aŋgé tima kerec imi. Tetecgiaiguc i imuhucyanec mélimima yomuhuc ʒéyec; Nuac naŋna imi eeya héimu. ");
INSERT INTO kgf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Waŋu ai ic ieneŋ eŋaoc yomuhuc eminiŋgic; Inéŋ mia kecma ai imuac mératéc icya wammac imuac niŋ neŋaŋ qeni humuyu ai youmi neŋaŋ buŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Imuhuc ʒéma késama qegic humuyu ai imuac demiŋ séŋgaŋgeŋiguc giligic. ");
INSERT INTO kgf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Waŋu ai miŋina imi dimuhuc wammac me? I hama ai ic imi unudacma aiya imi ai ic méŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ini kiwi téréyaiguc ac yomuhuc ooyawac heyu ménda oloŋanʒu? Mericqe ic ieneŋ hoc méŋ héŋara mema giligic keŋkeŋa iminéŋ ama waŋgoŋaiguc ama imuac hoc oruha waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iwawai imi Miŋ Kewunéŋ waŋu imuhuc hicŋiyu, kicninanéŋ haka imi hénni, hiabia soroc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Imuhuc ʒéyu ieneŋ ɋelumbec ac imi ionac niŋ ʒéyec imi niŋasarima késawiŋac ʒéma hénaya hocgic. Waŋu ic tuŋ yanda ionac niŋac bacgina yandiyu waimima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kemma ieneŋ Yesunéŋ ac ʒébiriyu hémmu niŋac Farisaio ic tosara ʒéma Herodeac hénaoriŋ héra méli énécmigic hagic. ");
INSERT INTO kgf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ieneŋ Yesuac muru hama yomuhuc ézégic; Kiwi ic, gi ic héla imi nini ninʒiŋ séwi tanecginawac ménda héŋanʒaŋ, imuac niŋ ic méŋac niŋac bacga ménda yandianʒac. Waŋu Anutuac ac hélacnec ku énécmianʒaŋ. Waŋu Kaisawac soukiwa mimia imi héna ac séciguc me qahac? ");
INSERT INTO kgf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nini iwac miwiŋ me ménda miwiŋ? Ʒégic Yesunéŋ ikocgina hoturu amuma kecgic imi niŋasarima yomuhuc énézéyec; Némac niŋ ni batucgé nénʒu? Soukiwa gocmia méŋ mema hagic hémba. ");
INSERT INTO kgf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yesunéŋ ʒéyu mema hama ézégic héŋec. Hémma yomuhuc qesiénécmima ʒéyec; Irec ʒéma kiwi yomi mérac? Imuhuc ʒéyu melemma Kaisawac ʒégic. ");
INSERT INTO kgf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Imuhuc ʒégic énézéyec; Kaisawac buŋa imi Sisa mimu. Waŋu Anutuac buŋa imi Anutu mimu imuhuc ʒéyu welicgégic. ");
INSERT INTO kgf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Waŋu Sadukaio ic humuc igucnec yayac imi ménda hezac ʒéaŋgic ieneŋ Yesuaru hama yomuhuc ʒégic; ");
INSERT INTO kgf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kiwi ic, Mosenéŋ nonac niŋ wamma yomuhuc oyec; Ic méŋnéŋ embac mema ɋeli ménda mihicŋima humuyu munayanéŋ qawéra imi mema ɋeli mihicŋiyu darawac qac mema yacma kecmac. ");
INSERT INTO kgf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Waŋu nalé méŋu dac muna 7 kecgic, dac walacginanéŋ embac mema ɋeli qahac kecma humuyec. ");
INSERT INTO kgf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Humuyu andianéŋ qawéra imi mema imuhucyanec ɋeli qahac kecma humuyu andia méŋnéŋ imuhucnec waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Imuhucnéŋ imuhuc dac muna 7 ieneŋ embac imi mema ɋeli qahac kecma humudacgic. Humudacgic tetecgiaiguc embac malé imi momacnec humuyec. ");
INSERT INTO kgf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Waŋu ic 7 ieneŋ momac yanda embac imi medacgic, imuac niŋ yacyarawac naléyaiguc embac imi mérac iniŋa wammac? ");
INSERT INTO kgf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ʒégic Yesunéŋ melemma énézéyec; Ini kiwi téréya me Anutuac kucya imi ménda niŋacgézu imuac niŋac ini sic saoc nimma ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kecma humuc igucnec yacmu nalé imuaru imi ic me embac ménda memu. Waŋu ieneŋ kua meme uŋa kurumeŋiguc kecanʒu imuhucya wamma kecmu. ");
INSERT INTO kgf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Waŋu humuc igucnec yacyarawac ʒéwa niŋgic. Moseac kiwiiguc Anutunéŋ ic waiyaguc imuac bélaŋa qeriaiguc, Ni Abaraham ʒéma Isaka ʒéma Yakop ionac Anutu, imuhuc ézéyec. Ini ac imi ménda oloŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Inéŋ ic humumia ionac Anutu qahac, kic ɋeli kekec ionac Anutu. Ini imi ac hénia hia ménda niŋasarizu. ");
INSERT INTO kgf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Imuhuc eminiŋ qeminiŋ wamma kecgic, héna acac kiwi ic onarunec méŋnéŋ hama nimma Yesunéŋ ac bakia hiabianec melemma ʒéyec imi niŋasarima yomuhuc qesimiyec; Némac héna acnéŋ walac walac wanʒac? ");
INSERT INTO kgf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Imuhuc qesiyu Yesunéŋ melemma ézéyec; Oo, Israel! Ini niŋgic, Héna ac walac walac imi yomuhuc hezac; Miŋ Kewu Anutunina imi Miŋ Kewu Momacguc. ");
INSERT INTO kgf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Imuac ewa qeriga mocʒoŋnec, qeri uŋaga mocʒoŋnec, niniŋga mocʒoŋnec, kucga mocʒoŋnec Miŋ Kewu Anutugawac siŋ niŋmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Héna ac éréhéc imi yomuhuc; Gi geŋga siŋ niŋamuanʒaŋ imuac séciguc alagawac siŋ niŋmiwésémaŋ. Héna ac méŋnéŋ ac ʒézua imi orogicmacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ʒéyu héna acac kiwi ic inéŋ yomuhuc ézéyec; Anutu imi momacguc, waŋu méŋ ménda kecʒac. Imuac niŋ, kiwi ic, acga ʒézaŋ imi hélacnec wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ewa qeriga mocʒoŋnec, niniŋga mocʒoŋnec ʒéma kucga mocʒoŋnec Miŋ Kewugawac siŋ niŋmiwésémaŋ imi ʒéma geŋga siŋ niŋamuanʒaŋ imuac séciguc alagawac siŋ niŋmiwésémaŋ iminéŋ hofac oo ai me mulu meme ai tosara imi onogicʒaoc. ");
INSERT INTO kgf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ic imi imuhuc niŋasarima ʒéyu Yesunéŋ nimma yomuhuc ézéyec; Gi Anutuac héŋgaleŋ ama areŋa yanda lakeciguc ménda kecʒaŋ. Imuhuc ʒéyu qesiqesi muŋguc méŋ ménda qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Waŋu Yesunéŋ ocmuŋ téréya qeriaiguc ac ku énécmima yomuhuc qesiyec; Némac niŋ héna acac kiwi ic ieneŋ Kristo i Dawidiac ɋeli imuhuc ʒéanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawidi i eŋeyaoc Uŋa Téréyanéŋ hinocgémiyu yomuhuc ʒéyec; Miŋ Kewunanéŋ nuac Miŋ Kewuna yomuhuc ézéyec; Gi nuac héinaiguc tacnanec haʒéchécga hénagawac duandiaiguc qutulaŋgé énécmimaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawidi inéŋ Kristoac niŋac Miŋ Kewuna ʒémiyec imuac niŋ Kristo inéŋ dimuhuc wamma iwac ɋeli wammac? Imuhuc ku énécmiyu ic embac ieneŋ siŋa nimma niŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Waŋu Yesunéŋ toroqema ac ku énécmima yomuhuc ʒéyec; Ini héna acac kiwi ic ionac técgina nimma kecmu. Ieneŋ maleku horua héima keŋha wambiŋ ʒé waŋanʒu. Waŋu nénnagémba sombeŋiguc inicma mepési énécmimu niŋac waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Waŋu tocgotocgo amaiguc me neʒéléléŋ aria amaiguc ic kuneŋ tataciguc tacmu niŋac waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ic imuhucya ieneŋ embac malé ionac ama igucnec iwawai onagicma hémbaoc wamma neanʒu. Waŋu ikocgina hoturuma ʒéwelec welec horua waŋanʒu. Waŋu ieneŋ kecma kitiwagina yéwéria memu. ");
INSERT INTO kgf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu inéŋ soukiwa haihai imuac hosuraiguc tacma iniru ic embac ieneŋ soukiwa haigic hiŋgarec. Waŋu ic soukiwa yanda ginaguc ieneŋ soukiwa yéwéria haigic hiŋgarec. ");
INSERT INTO kgf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Waŋu embac malé maqeqeya méŋnéŋ hama soukiwa pésia éréhécdac haiyu hiŋgarec. ");
INSERT INTO kgf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Waŋu Yesunéŋ tohotoho ichéra unuruma énézéyec; Ni hélacnec énézéwa, embac malé yominéŋ soukiwa haizac imi tosia ionac qeyu mazac. ");
INSERT INTO kgf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tosia ieneŋ héla yanda he énécmiyu imuarunec mema haizu waŋu embac malé inéŋ qahac igucnec kekecyawac komodia késakecʒac imi mocʒoŋ haidaru qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Waŋu Yesunéŋ ocmuŋ téréya igucnec mama keŋu tohotoho ichéra ionarunec méŋnéŋ ocmuŋ imi hémma yomuhuc ézéyec; Hénna, hoc yanda yanda imi dimuhucya, ama kuneŋ kuneŋ imi dimuhucya! ");
INSERT INTO kgf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ʒéyu Yesunéŋ melemma yomuhuc ézéyec; Gi ama kuneŋ kuneŋ imi hénʒaŋ? Hoc imi mocʒoŋ netec qetecgégic madaru hoc méŋnéŋ hoc méŋac qahaiguc ménda hemac. ");
INSERT INTO kgf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Waŋu Yesu ocmuŋ téréya néwécgeŋ Oliwa boŋaiguc emma taru Petero, Yakobo, Yohane ʒéma Anderea ieneŋ eŋawunec qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nénézéna, haka imuhucya imuhucya imi némac naléiguc hicŋimac? Waŋu ac imi seligimaŋ ʒéyu haka dimuhucya dimuhucyanéŋ hicŋimac? ");
INSERT INTO kgf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Waŋu Yesunéŋ yomuhuc énézéyec; Técgina nimmaguc kecmu. Ewa qerigina mesoho waŋ énécmiwu niŋac. ");
INSERT INTO kgf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ic sasalanéŋ nuac qacnaiguc hama ikoc wamma ni imi mia ʒéma ic embac sasala ionac ewa qerigina mesohomu. ");
INSERT INTO kgf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Waŋu yaré héla me imuac luhuc acya ʒégic nimma bacgina ménda yandimac; Iwawai imuhucya imuhucya imi kileŋdac hicŋimac. Waŋu imi nalé tetecgia qahacnec. ");
INSERT INTO kgf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Baera baera ic embac ieneŋ euqac waŋamuwiŋ ʒé yacmu. Baec tosaranéŋ baec tosara unuwiŋ ʒé yacmu. Waŋu baera baera naŋ memac. Waŋu béti saec hicŋimac. Waŋu imi aʒi kiki imuac hénihéniya. ");
INSERT INTO kgf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ini eŋaocnec héŋgaleŋ waŋamuma kecmu. Ieneŋ ini aciguc onopocmu. Waŋu tocgotocgo amaiguc hihilocnéŋ unumu. Waŋu imi sac qahac, onagicma keŋgic baec galeŋ tosara ʒéma ic kewu tosara ionac kicginaiguc namma nuac héipuc ac énézému. ");
INSERT INTO kgf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Waŋu walac imi buŋa suruc hiabia ʒéaugic baec séc ic embac nindacmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Waŋu onagicma aciguc haigic ac dimuhuc ʒéwiŋ ʒéma walac ménda niŋyéwérimu. Nalé imuaru qeriginaiguc ac haimac imi sac ʒému. Ʒézé ic imi ini qahac, néŋ Uŋa Téréya. ");
INSERT INTO kgf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dac muna ekaocnec haʒéc waŋamuma humumacac ʒétecgé amumaoc. Waŋu maŋgocnéŋ naŋa imuhucnec wammimac. Waŋu nambérac ieneŋ neŋgoc maŋgoc hécgina haʒéc waŋ énécmima humumu niŋac onopocmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Waŋu nuac qacna niŋac ic mocʒoŋ yanda haʒéc waŋ énécmimu. Waŋu méŋnéŋ selima naŋkeru tetecgia waŋu Miŋ Kewunéŋ késama kekec hémbénaŋaiguc opocmac. ");
INSERT INTO kgf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kecma Biria miŋina iwawai mebirianʒac iminéŋ ocmuŋ téréyaiguc naŋu, (Olonʒu ini ac imuac hénia niŋasarimu.) hémma Yuda baec igucnec ic embac ieneŋ néŋgacma baec boŋaiguc kemmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Waŋu ic méŋ ama qahaiguc tacʒac inéŋ mama iwawai méŋ ama qeriaiguc hezac imi memaŋ ʒé ménda mama emmac. ");
INSERT INTO kgf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ic méŋ aiiguc kecʒac inéŋ malekuya andiaiguc hezac imi memaŋ ʒéma ménda liliŋgémac. ");
INSERT INTO kgf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nalé imuaru embac tosara hériginaguc ʒéma neŋgoc tosara merac namu gumu énécmianʒu ieneŋ qenʒeŋ manʒeŋ yanda mihicŋimu! ");
INSERT INTO kgf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yéwéri imi kia naléyaiguc ménda hicŋimac niŋac welecmimu. ");
INSERT INTO kgf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nalé imuaru qenʒeŋ manʒeŋ méréra méŋ hicŋimac imuac niŋac imuhuc ʒézua. Qenʒéŋ manʒeŋ imuhucya imi Anutunéŋ baec kurumeŋ ʒéyu hicŋiyecac hezac imuac suraiguc méŋ ménda hicŋiyec. Waŋu kecma imuac andiaiguc imuhucya imi muŋguc ménda hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nalé imi becnec Miŋ Kewunéŋ focdac ménda metecgéwacnec imi ic méŋnéŋ selima naŋkeru késamacac séc qahac wambacnec. Ichéra gési énécmiyec ionac niŋac wamma nalé imi meducŋiyu hotoŋa waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Waŋu nalé imuaru méŋnéŋ Kristo you nonac muru hicŋizac me Kristo eri ionac muru hicŋizac imuhuc ʒéyu ménda ninʒéŋgému. ");
INSERT INTO kgf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Imi mia Kristo ikora ʒéma kua meme ic ikora hicŋima hia wammuac séc waŋu gési énécmimia imi ikoc waŋ énécmiwiŋ ʒé séséc ʒéma haka méréra baec ic eneŋ memuac séc qahac imuhucya memu imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ac imi walac walac énézézua imuac héŋgaleŋ wamma kecmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Waŋu nalé imuaru, qenʒeŋ manʒeŋ yanda imuac andiaiguc kaiwe asac mararaŋa békéma siŋidéŋgéyu maso asaha qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Waŋu ménni sikiluc imi kurumeŋ igucnec madaru kuc yanda yanda kurumeŋiguc hezac iminéŋ hirimac. ");
INSERT INTO kgf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Waŋu duŋa Icac Naŋa hosusu qahaiguc kuc yandayaguc ʒéma edamu yandayaguc hayu ic embac ieneŋ héndacmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Waŋu nalé imuaru inéŋ kua meme uŋahéra méli énécmima ic embac gési énécmimia ini baec ʒécgéria kemboŋ qahac igucnec ʒéma baec kurumeŋ néwéc néwéc igucnec qutulaŋgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Fik ic imi hémma ɋelumbec ac hénia imi yomuhuc niŋareŋ gému; Imuac hawa bébélacgia éréma imuarunec séra qeyu hémma kaiwe naléya hosuru wanʒac imuhuc ʒéanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ini imuhucyanec iwawai imuhucya imuhucya hicŋiyu hémma inéŋ hosucgé nénécmima nagu andiaiguc nanʒac imuhuc niŋtegicmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ni hélacnec énéʒéwa baeciguc hicŋisaiya kecʒu ini ménda qahac waŋgicnec ac imuac héla hicŋidacmac. ");
INSERT INTO kgf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Baec kurumeŋ imi qahac wammac, néŋ nuac acna imi ménda qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Waŋu imuac kaiweya ʒéma kaiwe kiwa imi ic méŋnéŋ ménda ninʒac. Kurumeŋac kua meme uŋa imi eneŋ ménda ninʒu. Naŋa acguc ménda ninʒac. Maŋgoc eŋeyanec téŋgéŋ ninʒac. ");
INSERT INTO kgf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nalé ménda ninʒu imuac niŋ técgina nimma kecmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ic méŋnéŋ amaya waima baec horu kemmac niŋac weleŋ qeqehéra iwawai galeŋgému niŋac énézéma aigina méndéŋ énécmima nagu galeŋa i kawaliya mema kecmac niŋac ai buŋa énécmiyec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ama miŋina imi némac naléyaiguc hamac? Mariya me siŋi yanda me kuruc qacanʒac imuaru me siŋunec imi ini ménda ninʒu. Imuac niŋ ini técgina nimma kecmu. ");
INSERT INTO kgf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Waŋu gau yanda hekecgic élanzaŋnec hama inicbac niŋac. ");
INSERT INTO kgf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ewa ɋeli ɋelinec kecmu. Ac ʒézua imi onac sac qahac, ic embac tosara ini momacnec. ");
INSERT INTO kgf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nagu sacyaguc ogicma keŋgic imuac tac niniŋ ʒéma saméŋ yisya qahac imuac tacniniŋ imi ai meme éréhéc heyu bec hamac. Nalé imuaru hofac oo ic ionac kiwa ʒéma héna acac kiwi ic ieneŋ Yesu dimuhuc ikoc wammima késama qemu niŋac hochoc ai megic. ");
INSERT INTO kgf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mema yomuhuc ʒégic; Tac niniŋ naléyaiguc qahac, ic tosara ieneŋ qeweloŋ qewu niŋac. ");
INSERT INTO kgf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Waŋu Yesunéŋ Betania ama areŋaiguc kemma ic méŋ qara Simon becnec wizi seliayaguc kerec iwac amaiguc emma nene nema tarec. Taru embac méŋnéŋ nadaac halécya héméŋa hiabia boŋa eŋeŋa imi kiruŋaguc mema hama qésémma orucya qahaiguc mocʒoŋ qocgémiyec. ");
INSERT INTO kgf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Qocgémiyu ic tosara tacgic ieneŋ niŋgic biriyu eŋaocnec eminiŋ wamma yomuhuc ʒégic; Némac niŋ haléc imi eŋdac audacʒac? ");
INSERT INTO kgf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iminéŋ kiriru soukiwa ic méŋac yawuŋac ai boŋa ogicmacac séc imi mema ic maqeqeya énécmiwacnec! Imuhuc ʒéma embac imi ac ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Waŋu Yesunéŋ yomuhuc énézéyec; Ini embac imi waigic taru. Ini némac niŋ embac imi yéwéri mizu? Embac imi ai hiabia menénʒac. ");
INSERT INTO kgf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ic maqeqeya imi nalé séc iniguc kecgic méra énénécmiwiŋ ʒéma nalé tosia hia méra énécmimu. Waŋu ni mia iniguc nalé séc ménda kecmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Embac imi kucyawac séciguc wanʒac. Ni humuwa téŋgé némmu imuac wamma haléc héméŋagucnéŋ walac naecnénʒac. ");
INSERT INTO kgf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ni hélacnec énézéwa, ini baec séc baec imuaru me imuaru buŋa suruc hiabia imi ʒéau énécmimuiguc embac yomi niŋɋeli mima haka waŋec imuac surucya imi momacnec ʒéau énécmimu. ");
INSERT INTO kgf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Waŋu tohotoho ic ionarunec méŋ, Yuda Karioto, inéŋ Yesu ic onac méraginaiguc opocmaŋ ʒéma hofac oo ic kuaya ionac muru keŋec. ");
INSERT INTO kgf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kemma ʒéyu nimma ségiségi wamma soukiwa gémbiŋ ʒéma ʒéseligic. Waŋu inéŋ Yesu méraginaiguc opocmaŋ ʒéma imuac naléyawac mambéc waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Saméŋ yisya qahac imuac kendoŋ hénihéniaiguc nagu sacyaguc ogicma keŋgic imuac kendoŋ niŋac rama unuaŋgic. Imuac naléyaiguc tohotoho ichéra ieneŋ Yesu qesimima ʒégic; Siŋga dimuaru hezac? Ama dimuaru kemma nagu sacyaguc ogicma keŋgic imuac kendoŋ niŋac rama imi oma haigénni newésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Imuhuc ʒégic merac éréchéc méli érécmima ʒéyec; Iri ama areŋa yandaiguc keŋic ic méŋ kewuciguc doku hima huama keŋu mihicŋima méndac mimaoc. ");
INSERT INTO kgf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Méndac miyic ama méŋiguc eŋu imuaru emma ama miŋina yomuhuc ézémaoc; Kiwi icnéŋ yomuhuc ʒézac; Ama qeria dimuaru tohotoho ichécna iniguc nagu sacyaguc ogicma keŋgic imuac kendoŋ niŋac rama imi newiŋ? ");
INSERT INTO kgf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Imuhuc ézéyic ama qeria kuneŋ yanda méŋ qacyaiguc hezac imuaru oragicma keŋu duŋ tatac iwawai imi lémbécma areŋgégic heyu hémma imuaru nonac iwawai imi mindiŋimaoc. ");
INSERT INTO kgf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Imuhuc ʒéyu merac éréhéc iereŋ ama areŋa yandaiguc keremma Yesu ʒéyec séc imi mihicŋima nagu sacyaguc ogicma keŋgic imuac kendoŋ niŋac iwawai mézézéŋgéyoc. ");
INSERT INTO kgf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Waŋu maria waŋu kaiwe kiwa hiŋgaru Yesu tohotoho ichéra 12 iniguc harégic. ");
INSERT INTO kgf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Waŋu nene nema tacma Yesunéŋ yomuhuc énézéyec; Ni hélacnec énézéwa, onarunec méŋ niguc nene nema tacʒac iminéŋ andé numac. ");
INSERT INTO kgf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Imuhuc ʒéyu ieneŋ ewagina goro waŋu eŋac eŋac qesimima yomuhuc ézégic; Hélacnec, ni qahac! Gi nuac ʒézaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ʒégic yomuhuc énézéyec; Tohotoho ic 12 onarunec méŋ niguc ʒéic momacguciguc saméŋ quduŋgéma nezac imi mia. ");
INSERT INTO kgf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Icac Naŋa i iwac niŋ ogic hezac imuhucnec kemmac. Waŋu ic méŋ andé qemimac iminéŋ bakia yéwéria memac! Ic imi neŋgoc héri qeri igucnec ménda hicŋiwacnec iminéŋ hia wambacnec. ");
INSERT INTO kgf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Waŋu nene nema tacma Yesunéŋ saméŋ mema ewa hia ac ézéma kuma énécmima ʒéyec; Megic yomi nuac séwi busuna. ");
INSERT INTO kgf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Imuhuc ʒéma waiŋ sokoc mema ewa hia ac ézéma énécmiyu i mocʒoŋ nedacgic. ");
INSERT INTO kgf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Negic énézéyec; Sac yomi nuac ʒikiʒiki ac ɋelia imuac sacya, imi ic embac sasala onac niŋ wamma qocgéyi. ");
INSERT INTO kgf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ni hélacnec énézéwa, Ni waiŋ méŋ muŋguc ménda nema kecma Anutuac héŋgaleŋ ama areŋa yanda qeriaiguc méŋ ɋeliawac nemaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Waŋu ieneŋ legic méŋ héima ama imi waima Oliwa baec boŋaiguc eŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Waŋu Yesunéŋ yomuhuc énézéyec; Ni rama galeŋ qehumuwa rama héndémma keŋha wammu. Ac imi ackuaʒéciguc oyec hezac. Imuac niŋ deguc siŋiya ini momac yanda wainémma néŋgacdacmu. ");
INSERT INTO kgf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Waŋu humuc igucnec yacma Galilaia baeciguc onac miha mema kemmaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Imuhuc ʒéyu Peteronéŋ yomuhuc ézéyec; I momac yanda waigémmu gezaŋ. Waŋu ni qahac. ");
INSERT INTO kgf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ʒéyu Yesunéŋ yomuhuc ézéyec; Ni hélacnec gézéwa, deguc siŋiya kurucnéŋ hatac éréhéc ménda qarunec gi hatac haréwéc qaecgé némbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ʒéyu Peteronéŋ seli seli wamma ʒéyec; Ni ménda waigémmaŋ. Giguc humumaŋ ʒé humumaŋ. Waŋu kileŋdac ménda qaecgé gémmaŋ. Imuhuc ʒéyu tosara mocʒoŋ imuhucnec ʒédacgic. ");
INSERT INTO kgf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Waŋu ieneŋ baec méŋ qara Gesemane imuaru hagic. Hama Yesunéŋ tohotoho ichéra énézéyec; Ini yomuaru tacgic ni kemma ʒéwelecba. ");
INSERT INTO kgf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Imuhuc ʒéma Petero, Yakobo ʒéma Yohane onagiru keŋgic qeria yéwériyu ewaya goro waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Waŋu énézéma ʒéyec; Ni humumaŋac séc ewananéŋ ewa biric yanda wanʒua, imuac ini yomuaru gau ménda hema ʒenʒeŋ ɋeli ɋeli kecmu. ");
INSERT INTO kgf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Imuhuc ʒéma komora méŋ kemma baeciguc mama sicgéma nalé yéwéria imi hia ogicmimacac niŋ ʒéwelerec. ");
INSERT INTO kgf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Waŋu yomuhuc ʒéyec; Aba Maŋgocna, gi iwawai mocʒoŋ hia medacanʒaŋ. Nuac sokoc yomi nuarunec nuagicna, waŋu nuac siŋna qahac guac siŋganéŋ seligimac. ");
INSERT INTO kgf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Waŋu inéŋ liliŋgéma hama iniru gau hegic Petero yomuhuc ézéyec; Simon, gau hezaŋ? Nalédac hotoŋa imi ʒenʒeŋ ɋeli ɋeli hia ménda kecʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kic ɋeli kecma ʒéwelecgic, qahac waŋu manam batuciguc mama unuwac niŋac. Qeriginanéŋ imuac wanʒac, néŋ séwiginanéŋ bébélacgia. ");
INSERT INTO kgf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Imuhuc énézéma muŋguc liliŋgéma walac ʒéyec ésécnec ʒéma ʒéwelerec. ");
INSERT INTO kgf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Méŋguc liliŋgéma hama iniru gaunec hegic. Waŋu ieneŋ gau igucnec yacgic, néŋ kicgina yéwéria waŋec. Waŋu néma ac ʒéwiŋ ʒéma osigic. ");
INSERT INTO kgf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Waŋu muŋguc liliŋgéma hayu hatac haréwéc waŋu énézéyec; Ini gaugina hemanec keczu? Imi sécgézac, nalé imi ducŋizac. Héŋgic Icac Naŋa andé qemima oporu biria meme ionac méraginaiguc enʒac. ");
INSERT INTO kgf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yacgic kenni. Héŋgic, andé qeqe icnéŋ hosucninu hazac. ");
INSERT INTO kgf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Imuhuc énézémanec naŋu tohotoho ichéra ionarunec méŋ, Yudanéŋ wininiyec. Waŋu inéŋ sac qahac, hofac oo ic kuaya ʒéma héna acac kiwi ic ʒéma galeŋ ieneŋ ic tuŋ méŋ méli énécmigic sou legicginaguc hagic. ");
INSERT INTO kgf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Andé qeqe ic inéŋ bec yaré ic iniguc séséc imi yomuhuc énézéma areŋgéyec; Mérac kiric nemiwa hémma imi mia ʒéma késama galeŋgéma kemmu. ");
INSERT INTO kgf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Waŋu inéŋ haréma focnec iwaru kemma, Kiwi icna! ʒéma kiric nemiyec. ");
INSERT INTO kgf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nemiyu méragina suluma késagic. ");
INSERT INTO kgf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Késagic maréŋaiguc naŋgic ionac murunec méŋnéŋ souya héréma hofac oo ic kiwawac weleŋ qeqe ic méŋac gezawa qeriru mayec. ");
INSERT INTO kgf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Waŋu Yesunéŋ yomuhuc énézéyec; Nuac niŋgic kowu nene ic waŋu népésiwiŋ ʒéma sou legicginaguc hazu? ");
INSERT INTO kgf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ni kaiweya kaiweya iniguc kecma ocmuŋ téréyaiguc ku énécmiwa ménda népésigic. Waŋu ackuaʒéc kiwi téréyaiguc hezac imuac héla héimac. ");
INSERT INTO kgf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Waŋu tohotoho ichéra mocʒoŋ waimima néŋgacgic. ");
INSERT INTO kgf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Waŋu sac ɋeli méŋ gau hehe maleku sac aturuma Yesu méndaru késagic ");
INSERT INTO kgf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","gau hehe maleku imi hetecgé gilima katanec néŋgarec. ");
INSERT INTO kgf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Waŋu ieneŋ Yesu késama hofac oo ic kiwawac amaiguc keŋgic. Waŋu ama imuaru hofac oo ic kiwa mocʒoŋ ʒéma galeŋhécgina ʒéma héna acac kiwi ic ieneŋ tocgégic. ");
INSERT INTO kgf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Waŋu Petero i lakec lakec méndacmima kemma hofac oo ic kiwawac ama demiŋ qeriaiguc keremma weleŋ qeqe ionac sucginaiguc geric ʒonemma tarec. ");
INSERT INTO kgf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Waŋu hofac oo ic kiwa mocʒoŋ ʒéma kua meme ic ieneŋ Yesu opocgic qemu niŋac héipuc ac niŋac hocgic. ");
INSERT INTO kgf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Waŋu ic sasalanéŋ ac ikoc sasala ʒégicac imi tanera momacguc ménda waŋu méŋ ménda mihicŋigic. ");
INSERT INTO kgf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tosaranéŋ namma ac ikoc yomuhuc ʒégic; ");
INSERT INTO kgf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nini ninni, yomuhuc ʒéyec; Ni ocmuŋ téréya méranéŋ memeya yomi héndémma kaiwe haréwécac qeriaiguc méŋ memaŋ. Waŋu imi méranéŋ memeya qahac. ");
INSERT INTO kgf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Waŋu ac imi ʒégic imi acguc acgina momacguc ménda waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Waŋu hofac oo ic eŋeŋaginanéŋ sucgina igucnec yacma Yesu qesimima ʒéyec; Gi ac bakia ménda ʒéwésémaŋ? Ic eneŋ héipuc waŋamuma guac ac ʒézu. Imi némac ac? ");
INSERT INTO kgf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Waŋu inéŋ eŋ namma ac méŋ ménda ʒéyu hofac oo ic eŋeŋanéŋ muŋguc qesimima ʒéyec; Gi mia mepésianʒiŋ iwac Naŋa Kristo me qahac? ");
INSERT INTO kgf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Waŋu Yesunéŋ ʒéyec; Ni imi mia, waŋu ini Icac Naŋa i Kuc Miŋina iwac héiyaiguc tackecma kurumeŋac hosusuiguc hayu hémmu. ");
INSERT INTO kgf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Imuhuc ʒéyu hofac oo ic eŋeŋaginanéŋ eŋeya malekuya muʒuracgéma énézéyec; Némac niŋac héipuc ic méŋ niŋac hoc kecbiŋ? ");
INSERT INTO kgf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","I Anutu ʒébiri qébiri wammima ac imi ʒéyu nindacʒiŋ. Waŋu dimuhuc ninʒu? Imuhuc qesiénécmiyu ic eneŋ kua séc ʒétecgégic humucac buŋa waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Imuhuc ʒéma tosara ieneŋ sépécgéma kiwa osoma méragina kuma qema ʒégic; Gi kua meme ic kecʒaŋiguc mérénéŋ guzac imi ʒéna. Waŋu weleŋ qeqe ieneŋ méra tawé tawénéŋ otogic. ");
INSERT INTO kgf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Waŋu Petero i emu sombeŋiguc keru hofac oo ic eŋeŋaginawac weleŋ qeqe embac méŋnéŋ hosuru hayec. ");
INSERT INTO kgf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Hama Petero geric ʒonemma taru hémma ézéyec; Gi Yesu Nazaretenec i guc momacnec kecnec. ");
INSERT INTO kgf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ʒéyu Peteronéŋ qaecgéma yomuhuc ʒéyec; Némac acac ʒézaŋ imi ni ménda ninʒua. Waŋu imuac hénia imi ménda niŋasarizua. Imuhuc ʒéma néŋgacma sombeŋ méŋ ama kuaya hosuraiguc heyec imuaru hiŋgarec. ");
INSERT INTO kgf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Waŋu weleŋ qeqe embac inéŋ imuaru i muŋguc hémma ic embac lelecgéma naŋgic ini yomuhuc énézéyec; Ic yomi imi ionarunec. ");
INSERT INTO kgf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Waŋu inéŋ muŋguc qaecgéyec. Waŋu nalé ménda horugiyu ic embac hosuru naŋgic ieneŋ muŋguc Petero ézégic; Gi hélacnec ionarunec, gi Galilaia ic. ");
INSERT INTO kgf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ʒégic i eŋeyaoc ʒébiri amuma ʒéselima ʒéyec; Ic mérac niŋ ʒézu imi ni ménda ninʒua. ");
INSERT INTO kgf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ʒéyu imuarunec kuruc qaru hatac éréhéc waŋec. Waŋu Yesunéŋ Kurucnéŋ hatac éréhéc ménda qaru geŋ haréwéc qaecgé némbésémaŋ imuhuc ézéyec imi Peteronéŋ niŋɋelima siarec. ");
INSERT INTO kgf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ama giaŋiyu imucgeŋnec hofac oo ic kiwahécgina ieneŋ galeŋ tosara ʒéma héna acac kiwi ic tosara ʒéma kua meme ic mocʒoŋ iniguc focdac tocgéma ewa momacguc wamma ʒéareŋ wandacma Yesu dérécgéma wagicma kemma Pilato iwac muru opocgic. ");
INSERT INTO kgf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Opocgic Pilatonéŋ qesimiyec; Gi Yuda ic ionac ic kewu me? Ʒéyu inéŋ melemma ʒéyec; Geŋgaoc ʒézaŋ. ");
INSERT INTO kgf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Waŋu hofac oo ic kiwa ieneŋ képésira sasala ʒémigic. ");
INSERT INTO kgf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatonéŋ muŋguc qesimima ʒéyec; Ninʒaŋ? Ieneŋ guac képésic sasala ʒézu. Némac niŋac kitiwa méŋ ménda ʒézaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ʒéyu Yesunéŋ ac méŋ muŋguc ménda meleŋu Pilatonéŋ welicgéyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nagu sacyaguc ogicma keŋgic imuac Kendoŋ séc Yuda ic ieneŋ hésa ama ic méŋac qara qacma hulacmimac niŋac Pilato welecmigic inéŋ ionac niŋ wamma méŋ hulacmiaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Waŋu nalé imuaru ic tosara ic embac onac qeri kumu wamma yaré meyacma wawaŋ meme imuac suraiguc ic méŋ qehumugic énépésima hésa amaiguc onopocgic kecgic, ionac sucginaiguc ic méŋ kerec, iwac qara imi Baraba. ");
INSERT INTO kgf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Waŋu ic embac tuŋ yanda ieneŋ haréma Pilatonéŋ haka waŋaŋec séciguc muŋguc waŋ énécmimacac niŋac qesimigic. ");
INSERT INTO kgf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Qesimigic Pilatonéŋ melemma ʒéyec; Yuda ic onac ic kewu imi wai énécmimaŋ niŋac wanʒu? ");
INSERT INTO kgf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Inéŋ hofac oo ic kiwa ieneŋ Yesu eŋ nimbupuc nimmima iwaru haigic imi niŋasaridarec. Imuac imuhuc qesiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Waŋu hofac oo ic kiwa ieneŋ ic embac qeri kumu waŋ énécmigic ieneŋ yomuhuc qacma ʒégic; Yesu waina taru Baraba hulacna mayu! ");
INSERT INTO kgf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Waŋu Pilatonéŋ muŋguc qesiénécmiyec; Imuhuc ʒézuiguc Yuda ic onac ic kewu ʒémianʒu i dimuhuc wammimaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ʒéyu ieneŋ muŋguc qacma ʒégic; Ic imi ic héŋgeŋa wéndaraiguc qena! ");
INSERT INTO kgf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ʒégic Pilatonéŋ melemma énézéyec; Némac niŋac? Némac képésicac waŋec? Imuhuc ʒéyu selianec qacma ʒégic; Ic héŋgeŋa wéndaraiguc qena! ");
INSERT INTO kgf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Waŋu Pilatonéŋ ic embac niŋgic sécgémac niŋac Baraba hulac énécmima Yesu i mia hihilocnéŋ qema ic héŋgeŋa wéndaraiguc qemu niŋac yaré ic onac méraginaiguc haiyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Waŋu yaré ic ieneŋ Yesu wagicma baec galeŋac ama kewuya imuac demiŋ qeriaiguc keremma yaré ic tuŋ méŋ énézégic mocʒoŋ hama qutulaŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Waŋu yaréac maleku ɋouc ɋoucgia Yesu héimima hésa waiyagucnéŋ ic kewuac opoc méŋ miʒima orucyaiguc héimigic. ");
INSERT INTO kgf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Héimima mepésima ʒégic; Ohec Yuda ic ionac ic kewu! ");
INSERT INTO kgf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Imuhuc ʒéma uŋ qaulaleanéŋ orucyaiguc qema sépécgé mima simiŋ héima tacma sicgémigic. ");
INSERT INTO kgf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ʒéʒerec wammidacma yaréac maleku ɋouc ɋoucgia imi hetecgéma eŋeya malekuya héigic hiŋgacmiyu ic héŋgeŋa wéndaraiguc qemu niŋac wagicma séŋgaŋgeŋ mama keŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kemma hénaiguc ic méŋ ama areŋa méŋ komora igucnec haréyu mihicŋigic. Iwac qara imi Simon, Kirene tauŋ igucnec, Aleksande ʒéma Rufu iorac maŋgocgira. Waŋu yaré ic eneŋ ic héŋgeŋa wéndara Yesuarunec wagicma seli seli wamma migic huayec. ");
INSERT INTO kgf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Huayu Yesu wagicma baec méŋ qara Golgota (Neŋaŋ aciguc; Oruc sic) imuaru kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Waŋu baec imuaru waiŋ dokuiguc sacmasi qara mér imi haima lelecgéma Yesu migic inéŋ waiyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Waŋu ieneŋ i ic héŋgeŋa wéndaraiguc qedacma malekuya mérénéŋ méré késamu imi hémma nimbiŋ ʒéma sumbic néma sécgina méndémma késagic. ");
INSERT INTO kgf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Waŋu kaiwe kiwa 9 kilok waŋu qegic. ");
INSERT INTO kgf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Qema ou iwac oruha hanecgeŋa iguc ic kitiwa emma naŋu imuaru ac wammigic sécya yomuhuc oma qegic naŋec, Yomi Yuda ic ionac ic kewu. ");
INSERT INTO kgf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Waŋu kowu nene ic éréchéc momacnec ic héŋgeŋa wéndaraiguc urugic méŋ héiyaiguc méŋ kanayaiguc naŋoc. ");
INSERT INTO kgf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Waŋu kiwi téréyaiguc ackuaʒéc heyu héla héiyec iminéŋ yomuhuc; Biria meme ic qétégina oloŋgic imuaru i momacnec olommigic. ");
INSERT INTO kgf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Waŋu ic embac baec imi ogicma keŋha waŋgic ieneŋ orucgina gilima yomuhuc ʒébiri mima ʒégic; Aaha, gi ocmuŋ téréya héndémma kaiwe haréwéc imuac qeriaiguc mekiʒicgémaŋ ʒéanʒaŋ imi mia. ");
INSERT INTO kgf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Deguc geŋgaocnec ic héŋgeŋa wéndara igucnec metecgé amuma mana! ");
INSERT INTO kgf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Waŋu hofac oo ic kiwa ʒéma héna acac kiwi ic ieneŋ imuhucnec ʒédesi wammima eŋawunec eminimma ʒégic; Ic tosara aŋgéŋgina tiénécmiyec, néŋ eŋeya aŋgéŋa hia ménda tiamuzac. ");
INSERT INTO kgf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo Israel ic onac ic kewu inéŋ ic héŋgeŋa wéndara igucnec mayu hémmaguc ninʒéŋgéwiŋ. Ic urugic iguc momacnec naŋgic iereŋ imuhucnec ac imuhuc ʒéma ʒébiri miyoc. ");
INSERT INTO kgf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kecma kaiwe kiwa 12 kilok waŋu siŋinéŋ baec sécgéma heyu keŋkecma maria 3 kilok waŋu tecgéyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mariya 3 kilok imuaru Yesunéŋ selianec qacma ʒéyec; Eloi eloi lama sabaktani? Ac imuac hénia imi yomuhuc; Anutuna Anutuna némac niŋac wainénʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Waŋu ic hosuru naŋgic ionarunec tosaranéŋ nimma ʒégic; Niŋgic, Elia héihéré mizac. ");
INSERT INTO kgf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Waŋu ic méŋnéŋ foc kemma konduŋ kagalic méŋ doku howura winigaiguc qunduŋgéma ic suŋ susuriaiguc ʒikima Yesu gumuma ʒéyec; Waigic mambéc hénni, Elianéŋ hama wagicma mamac me qahac. ");
INSERT INTO kgf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Waŋu Yesu i muŋguc kucnec qaru uŋaya waimiyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Waimiyu maleku horua yanda ʒaki téréya neʒicgéma naŋaŋec imi namuŋa igucnec ounec ʒuracgéma emu héniaiguc tecgéyu éréhéc waŋec. ");
INSERT INTO kgf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Waŋu yaré ic qété 100 ionac galeŋgina méŋ Yesuac wésiaiguc namma héŋu humuyu yomuhuc ʒéyec; Hélacnec, ic yomi Anutuac Naŋa kerec. ");
INSERT INTO kgf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Embac tosara eneŋ momacnec lakec namma héŋgic. Waŋu ionac sucginaiguc Maria Makdalanec ʒéma Yakobo komora ʒéma Yose iorac neŋgocgira Maria ʒéma Salome i momacnec naŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ieneŋ Galilaia baeciguc Yesu méndacmima weleŋ qemima kecaŋgic. Waŋu embac sasala tosara Yesuguc Yerusalem éréma hagic ieneŋ momacnec imuaru naŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Oraŋ imi Sabata tac niniŋ, deguc imi imuac ʒéréŋ qéréŋ naléya, imuac niŋ ama siŋimaŋ ʒé waŋu, ");
INSERT INTO kgf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ic méŋ qara Yosefe Arimataia ama areŋa yanda igucnec inéŋ bawa ménda yandiyu Pilatoaru kemma Yesu qamocya niŋac qesiyec. Waŋu ic imi kua meme tuŋ ionac kiwa eŋeŋa kecma Anutuac héŋgaleŋ ama areŋa yanda imuac mambéc kecaŋec. ");
INSERT INTO kgf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Waŋu Pilatonéŋ Hélacnec bec humuzac? Imuhuc ʒéma nimma yaré ic qétégina 100 ionac galeŋgina ʒéyu hayu yomuhuc ʒéma qesimiyec; Ic imi bec humuzac? ");
INSERT INTO kgf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Imuhuc qesimiyu yaré ic qétégina 100 ionac galeŋginanéŋ ézéyu niŋasarima Yosefenéŋ qamoc imi hia mema kemmac niŋac ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Waŋu Yosefenéŋ kemma maleku qara linen imi boŋa mema Yesu qamora imi metecgéma maleku iminéŋ osoma mema kemma kic suaŋ hoc yanda qésémma kifaŋa yanda meyacgégic imuaru haima hoc méŋ qililiŋgéyu kemma kuaya néʒicgéyec. ");
INSERT INTO kgf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Néʒicgéyu Maria, Makdalanec ʒéma Maria, Yoseac neŋgocya iereŋ Yesu qamora dimucgeŋ haigic heyec imi hima héŋoc. ");
INSERT INTO kgf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabata nalé téréya tecgéyu, Maria, Makdalanec ʒéma Maria, Yakobo neŋgocya ʒéma Salome i Yesu qamora naecmimu niŋac haléc héméŋaguc boŋa medacgic. ");
INSERT INTO kgf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Waŋu Sondaiguc ama giaŋima kaiwe kiwa éréyu kic suaŋiguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Waŋu keŋkecma yomuhuc eminiŋgic; Kicsuaŋ kuaya igucnec mérénéŋ hoc imi qililiŋgé nénécmimac? ");
INSERT INTO kgf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Imuhuc ʒéma kic hima héŋgic hoc imi qililiŋ gégéyawac heyec, waŋu hoc imi kuneŋ yanda. ");
INSERT INTO kgf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Waŋu kic suaŋ qeriaiguc keremma héiginaiguc geŋ ic merac méŋ maleku horua lalac lalacyaguc taru hémma aurigic. ");
INSERT INTO kgf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Waŋu inéŋ énézéyec; Ʒénéŋgina ménda hiriyu. Ini Yesu Naʒaretenec, ic héŋgeŋa wéndaraiguc qegic i hémbiŋac ʒéma hazu imi ni ninʒua. Inéŋ bec ɋelima yarec. Yomuaru ménda hezac. Hehe duŋa haigic yomi héŋgic. ");
INSERT INTO kgf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ini kemma tohotoho ichéra ʒéma Petero yomuhuc énézému; Inéŋ énézéyec séc walac Galilaia baeciguc kenʒac. Imuaru kemma hémmu. ");
INSERT INTO kgf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ʒéyu embac ieneŋ ʒénéŋgina hiriyu welicgéma kic suaŋ qeria igucnec focdac mama néŋgacma keŋgic. Waŋu bacgina yandiyu ac imi ic méŋ ménda énézégic. ");
INSERT INTO kgf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesunéŋ Sonda giaŋ giaŋacnec ɋelima yacma Maria Makdalanec, becnec uŋa biria 7 nesi énécmiyec embac imi walac hicŋimiyec. ");
INSERT INTO kgf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hicŋimiyu kemma ic tosara Yesuguc kecaŋgic ieneŋ siacma kecgic suruc waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Waŋu ieneŋ Yesu ɋelima yacma embac hicŋimiyec suruc imi nimma ménda ninʒéŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Waŋu imuac andiaiguc ionarunec ic éréhéc ama méŋiguc keŋoc. Hénaiguc Yesunéŋ kic tanera melemma hicŋi érécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hicŋi érécmiyu kemma tosara énézéyic imi imuhucnec ménda ninʒéŋgégic. ");
INSERT INTO kgf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Imuac andiaiguc tohotoho ichéra 11 tocgéma nene nema tacgic hicŋi énécmiyec. Waŋu Yesu ɋelima yaru héŋgic ieneŋ imuac ac suruc énézégic. Waŋu qerigina seligiyu ménda ninʒéŋgégic niŋu ménda sécgéyu ac waŋ énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Waŋu toroqema yomuhuc énézéyec; Ini baera baera kemma ic kecʒu séc buŋa suruc hiabia imi énézému. ");
INSERT INTO kgf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ninʒéŋgéma doku naecmac imi Anutunéŋ késayu kekec hémbénaŋa kecmac. Waŋu ménda ninʒéŋgému imi képésicgina niŋac ʒétecgé énécmimac. ");
INSERT INTO kgf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ninʒéŋgému i haka icnéŋ ménda memeya yomuhucya méndac énécmimac; Nuac qacnaiguc uŋa biria nesi énécmimu, waŋu ac méréra ʒému. ");
INSERT INTO kgf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mokoleŋ késama doku kumiŋaguc negic ménda mebiri énécmimac, ic hafiginaguc ionac orucginaiguc méragina haigic hafigina qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Miŋ Kewu Yesunéŋ ac énézédaru Anutunéŋ i wagiru kurumeŋiguc emma Anutuac héiyaiguc tarec. ");
INSERT INTO kgf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Waŋu tohotoho ichéra ieneŋ kemma ama baec séc ackuaʒéc imi ʒéaugic Miŋ Kewunéŋ iniguc momacnec ai meyu haka icnéŋ ménda memeyanéŋ hicŋi énécmima ackuaʒéc imi meseliyec. ");
INSERT INTO kgf_vpl VALUES ("MK16_21","071_16_21","MRK","16","21","21","(Ménda hezac) ");
INSERT INTO kgf_vpl VALUES ("MK16_22","071_16_22","MRK","16","22","22","(Ménda hezac) ");
INSERT INTO kgf_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Neŋaŋ sucninaiguc haka hélacnec hicŋi nénécmiyec imuac ac suruc imi areŋgéma owiŋ ʒé sasalanéŋ batucgéma aigina hénigic. ");
INSERT INTO kgf_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Imi mia hénihéniya igucnec kicginanéŋ hémma ackuaʒéc imuac héipuc ic ʒéma ai ic kecgic ieneŋ nénézégic séc dindiŋanec ogic. ");
INSERT INTO kgf_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ni acguc haka imi mocʒoŋ hénihéniya igucnec dindiŋanec niŋgésima hicŋi hicŋima éréyec séc areŋgéma oma ic kewu eŋeŋana Tiofilus guac haiwa hamac iminéŋ hia wammac ʒéma niŋi. ");
INSERT INTO kgf_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Imuac mia kiwi yomi olomma ackuaʒéc gézégic imi hélacnec ʒéma nimbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodenéŋ Yuda baec imuac ic kewu kerec nalé imuaru ic méŋ kerec, qara imi Ʒakaraia. Inéŋ hofac ooic méŋ qara Abiya iwac ai areŋ igucnec. Waŋu Ʒakaraiawac iniŋa imi Aronac sac kitic igucnec. Waŋu iwac qara imi Elisabete. ");
INSERT INTO kgf_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iereŋ imi Anutuac kiwaiguc solaŋanec kecaŋoc. Kecma Miŋ Kewuac ʒézé seli ʒéma héna ac mocʒoŋ képésic qahac tohoma kecaŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Waŋu Elisabete imi héfiŋac kecaŋec imuac niŋ iereŋ ɋeligira qahac kecma ic embac yanda waŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nalé sura méŋu Ʒakaraianéŋ eŋeya ai ic tuŋa ionac ai nalégina ducŋiyu hofac oo ai imuac galeŋ wamma Anutuac wésiaiguc ai mema kerec. ");
INSERT INTO kgf_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Waŋu hofac oo ic eŋaŋ hakagina tohoma sumbic négic Ʒakaraiawac ai buŋa waŋu Miŋ Kewuac ama téréyaiguc emma héfac héméŋaguc héimiyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Héimiyu hofac oo ai imuac suraiguc ic embac mocʒoŋ yanda ieneŋ séŋgaŋgeŋiguc ʒéwelec welec ai mema naŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Waŋu Miŋ Kewuac kua meme uŋa méŋnéŋ iwaru wininima hofac oo ʒaki téréya imuac héiyaiguc naŋec. ");
INSERT INTO kgf_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Naŋu Ʒakarianéŋ héŋu qeri yéwéc wammiyu bac yandi yandinéŋ sécgémiyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Imuhuc waŋu kua meme uŋanéŋ yomuhuc ézéyec; Ʒakaraia, bac yandi yandi ménda wanna, ʒéwelec welecga imi niŋgéŋgéŋa waŋec. Imuac iniŋga Elisabetenéŋ héri haima merac méŋ megémmac. Megéŋu iwac qara Yohane ʒéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Waŋu guaru ségiségi yanda hicŋimac. Hicŋiyu ic embac sasala ieneŋ iwac hicŋi hicŋiya niŋac ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ségiségi wammu imi hénia yomuhuc niŋac; Inéŋ Miŋ Kewuac kiwaiguc kuneŋgina wamma kecmac. Waŋu inéŋ waiŋ ʒéma doku selia imuhucya méndagucnec nemac, néŋ neŋgocyawac héri qeriiguc heyunec Uŋa Téréyanéŋ ewa qeria sécgémima hemac. ");
INSERT INTO kgf_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sécgémiyu Israelac ɋelihéra sasala meleŋ énécmiyu Miŋ Kewugina Anutuac muru liliŋgéma hamu. ");
INSERT INTO kgf_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Qeri uŋa ʒéma kuhanéŋ Eliawac séc hemiyu, Miŋ Kewu ménda hayunec miha mema hama maŋgoc ionac qerigina meleŋu nambérac ionac liliŋgémac. Ewa seli ic meleŋ énécmiyu ic solaŋa ionac niniŋ areŋ imuac wamma liliŋgému. Imuhuc wamma Miŋ Kewuac hénaoriŋ sécya ʒémindiŋi énécmiyu iwac mambéc kecmu. ");
INSERT INTO kgf_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kua meme uŋanéŋ imuhuc ézéyu nimma Ʒakaraianéŋ ac kitiwa yomuhuc meleŋec; Ni imi ic yanda, waŋu iniŋna acguc yawuŋa sasala yanda, imuac dimuhuc acga imi niŋasarimaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ʒéyu kua meme uŋanéŋ yomuhuc ézéyec; Ni qacna Gabiriel, Anutuac kiwaiguc nanaŋa imi mia. Anutunéŋ buŋa suruc hiabia yomi gézéma ʒéau gémmaŋ ʒé méli néŋu mazua. ");
INSERT INTO kgf_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ninʒaŋ, acna ʒéwa ménda ninʒéŋgézaŋ, imuac niŋ degucmuacnec gi ac ʒéwésémaŋac séc qahac wamma ac qahac kecnanec haka imi hicŋimac. Naléya ducŋiyu acna imuac héla hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Waŋu Ʒakaraianéŋ Anutuac ocmuŋ téréya qeriaiguc nalé ogicma keru, ic embac ieneŋ iwac mambéc kecma welicgégic. ");
INSERT INTO kgf_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Imuhuc waŋkecgic inéŋ ionac muru mayec. Waŋu ac ʒémacac séc qahac waŋec. Waŋu ic embac ieneŋ imi inéŋ ocmuŋ téréya qeriaiguc iwawai tanec méŋ héŋec imi niŋtegicgic. Waŋu inéŋ méranéŋ séséc sac waŋ énécmima ara qahacnec kerec. ");
INSERT INTO kgf_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Waŋu weleŋ qeqeyawac ai meme sasala imi weleŋ qeyu tecgédaru amayaiguc liliŋgéma keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kemma keru ai meme tosara hama keŋu iniŋa Elisabetenéŋ hériyaguc wamma maso méra méŋ saŋgima kerec. ");
INSERT INTO kgf_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kecma yomuhuc ʒéyec; Sura yomuac Miŋ Kewunéŋ nuac wannémma ic embac sucginaiguc gamuna qahac wammac niŋac haka imuhuc wannéŋec. ");
INSERT INTO kgf_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Maso 6 waŋu Anutunéŋ kua meme uŋa Gabiriel Galilaia baec Naʒarete tauŋiguc mélimiyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Mélimiyu embac seraŋa méŋ qara Maria iwac muru keŋec. Waŋu embac imi ic méŋ qara Yosefe Dawidiac hicŋisai areŋa imuarunec iwac iniŋ buŋa qemigic kerec. ");
INSERT INTO kgf_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Waŋu hosucgé mima yomuhuc ézéyec; Ohec wahec! Anutuac héŋsorocya, Miŋ Kewunéŋ giguc kecʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Imuhuc ʒéyu Marianéŋ kuneŋ yandanec niŋbipima yomuhuc niŋec; Némac niŋ imuhuc yai ʒézéna ʒézac? ");
INSERT INTO kgf_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Waŋu kua meme uŋanéŋ yomuhuc ʒéyec; Maria, Anutunéŋ ewa hia waŋgéŋu hénʒaŋ imuac niŋ gi bacga ménda yandiyu. ");
INSERT INTO kgf_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ninʒaŋ, gi héri haima naŋga mewésémaŋ. Waŋu qara imi Yesu ʒéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Inéŋ Miŋ Kewu wamma keru, iwac qara imi Eŋeŋa miŋinawac Naŋa ʒémimu. Waŋu Miŋ Kewu Anutunéŋ iwac sakoŋa Dawidiac tatac edamuyaguc imi iwac miyu tacmac. ");
INSERT INTO kgf_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Waŋu Yakopac ɋelihéra ionac ama séc ic kewu waŋ énécmima keru, iwac héŋgaleŋ ama areŋa yanda imi nalé hémbénaŋa tetecgia qahac hema emma kecmac. ");
INSERT INTO kgf_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Imuhuc ʒéma ʒéyu, Marianéŋ kua meme uŋa yomuhuc ézéyec; Ni ic hénia ménda nimmanec seraŋa kecʒua, imuac niŋac haka imuhucyanéŋ dimuhuc hicŋi némmac? ");
INSERT INTO kgf_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ʒéyu kua meme uŋanéŋ ac kitiwa yomuhuc melemma ézéyec; Uŋa Téréyanéŋ guaru mayu Eŋeŋa miŋinawac kuhanéŋ hoturu gémmac. Imuac niŋac merac mewésémaŋ imi téréya. Waŋu iwac mia Anutuac Naŋa ʒémimu. ");
INSERT INTO kgf_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ninʒaŋ, sac kiticga Elisabete héfiŋa ʒémimianéŋ yawuŋa sasala yanda wammaguc merac méŋ héri haima keru, bec maso 6 wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Némac niŋ, Anutuaru imi haka osiosiya méŋnéŋ méŋ ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Imuhuc ʒéyu, Marianéŋ yomuhuc ézéyec; Ni Miŋ Kewuac weleŋ qeqe embac, imuac ʒézaŋ imuac séc hia hicŋi némmac. Imuhuc ʒéyu kua meme uŋa iminéŋ waima keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Keŋu sura méŋ imuaru, Marianéŋ yacma kemma Yuda baec boŋa méŋu Yuda tauŋiguc focdac ekeŋec. ");
INSERT INTO kgf_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ekemma Ʒakaraiawac amaiguc emma Elisabete yaiʒézé ac wammiyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wammiyu Elisabetenéŋ Mariawac yaiʒézé ac niŋec imuarunec, merac qeriaiguc heyec iminéŋ qitic qeyec. Waŋu Uŋa téréyanéŋ Elisabeteac ewa qeriaiguc sécgé miyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sécgé miyu ewaya meyu eŋu kucnec qacma yomuhuc ʒéyec; Embac, gi embac tosara sucninaiguc guagiru mériaŋ yandagaguc wanʒaŋ. Waŋu héri qerigawac héla gocmia imi acguc mériaŋ yandayaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Miŋ Kewunawac neŋgocyanéŋ nuaru hazac. Haka yomi némac hiana niŋac wamma hicŋinénʒac me? ");
INSERT INTO kgf_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ʒéwa ninna, yaiʒézéganéŋ gezacnaiguc hiŋgaru, kokocnanéŋ qerinaiguc qitic qema ségiségi wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ackuaʒéc ézéyec imi hélaguc wandacmacac hezac hénia imuac niŋac ninʒéŋgéyec embac imi mériaŋaguc. ");
INSERT INTO kgf_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Waŋu Marianéŋ yomuhuc ʒéyec; Inéŋ eŋeya weleŋ qeqe embac nidac imuhucyawac kiwa hinéŋec. Imuac niŋ qeri uŋananéŋ Miŋ Kewu mepésizac. ");
INSERT INTO kgf_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Qeri uŋananéŋ Anutu nuac aŋgéŋ titi miŋina iwac niŋ wamma ségiségi wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ʒéwa niŋgic, tetecgia qahac emma kemma ic embac hicŋisaiya mocʒoŋ yanda imi nuac niŋ mériaŋaguc ʒénémmu. ");
INSERT INTO kgf_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kuc miŋinanéŋ nuaru kiwi yanda mezac, waŋu iwac qara imi Téréya! ");
INSERT INTO kgf_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Anutu sicgémimia ionac muru Anutuac goi héihéi yandanéŋ ɋeli yackumu emma emma he énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Inéŋ méria suluma wawaŋ meme kuhaguc yanda waŋanʒac. Inéŋ ewa niniŋginaiguc séwi eŋeŋ niŋanʒu ic imuhucya héndéŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Inéŋ ic kewu tatac igucnec ic kuc buŋaginaguc imi memaénéc mianʒac, qeri memaamuma kekec imi meyac énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ic yaka niŋ humuanʒu ionac imi iwawai hia bia tiénécmianʒac, néŋ iwawaigina sasala he énécmimia imi méragina héla qahac nesi énécmiyu eŋ keŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Inéŋ eŋeya wésé niniŋa niŋɋelima ");
INSERT INTO kgf_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","yanda hécnina ʒikiʒiki ac énézéyec séc weleŋ qeqe ichéra Israel imi méra énécmiyec. Waŋu Abaraham ʒéma iwac ɋelihéra ionac imi tetecgia qahac waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Waŋu Maria imi Elisabeteguc keric, maso haréwéc tecgéyu, liliŋgéma amayaiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Waŋu bec Elisabetenéŋ naléya hayu naŋa meyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Waŋu ama momachéra ʒéma eŋeya sac kitichéra ieneŋ Miŋ Kewunéŋ goiya kuneŋ yanda héimiyec imi nimma iguc momacnec ségiségi waŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ai meme 8 waŋu meracac séwi taséya hericbiŋ ʒé hama maŋgocyawac qac imi mema Ʒakaraia ʒéwiŋ ʒé waŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Waŋu neŋgocyanéŋ qetali énécmima ʒéyec; Qahac, qara imi Yohane ʒéwiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ʒéyu ʒégic; Ee, sac kitichécgina sucginaiguc qac imuhuc ʒémimia méŋ ménda kecʒac. ");
INSERT INTO kgf_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ʒégic ménda sécgéyu maŋgocyanéŋ méré ʒémimia wammac ʒé ninʒac? Imuhuc ʒéma nimma qesinimbiŋ ʒé, méranéŋ séséc wammigic. ");
INSERT INTO kgf_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Imuhuc waŋgic inéŋ hilaŋeŋ ʒéma ʒékalaŋa niŋac waŋec. Waŋu keŋ mehama migic, qara imi Yohane imuhuc oyu, hémma welicgégic. ");
INSERT INTO kgf_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Waŋu duŋa kuaya ʒéma ezelaŋa momacnec hulacmimia waŋu, acac wamma Anutu mepési miyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Waŋu ic ama lelec lelec kecgic imi eneŋ ac imi nimma ʒénéŋgina hiriyec. Waŋu Yuda baec boŋa séc haka imuac eminimma kecgic. ");
INSERT INTO kgf_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Waŋu Miŋ Kewuac mérianéŋ iwaru imuhuc heyec imuac niŋac, suruc imi niŋgic séc ac imi qeriginaiguc késa kecma yomuhuc ʒéaŋgic; Merac imuhucyanéŋ yandima ic dimuhucya wammac me? ");
INSERT INTO kgf_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Waŋu maŋgocya Ʒakarianéŋ Uŋa téréyanéŋ qeria sécgéyu biaŋac ara yomuhuc ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Anutu i mama hama ic embachéra neŋaŋ doenina meyec. Mepé qepésinina imi neŋaŋ Miŋ Kewunina Israelac Anutuac muru hemac. ");
INSERT INTO kgf_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Waŋu nonac niŋ wamma weleŋ qeqeya Dawidi iwac ama areŋhéra neŋaŋ muru aŋgéŋ titiac ilicya meyac kumu nénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Imi mia baec yomuac nalé hama keŋec sura imuaru eŋeya ichéra téréya Anutuac tiliŋ tiliŋ ic ionac kuagina mema ackuaʒéc nénézéyec séciguc ");
INSERT INTO kgf_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","haʒécnina ionac murunec ʒéma nimbiri waŋ nénécmianʒu ionac méragina igucnec metecgé nénécmima aŋgéŋnina tiyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Inéŋ yanda hécnina goi héihéi waŋ énécmimaŋ ʒé iniguc sisipac ac téréya ʒéseliyec imi mia niŋɋeliyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Imi mia sisipac ac yandanina Abaraham ʒéselimiyec imi mia. ");
INSERT INTO kgf_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Bac yandi ménda wamma eŋeya mepésimiwiŋ niŋac haʒéc hécnina ionac méragina igucnec metecgé nénécmiyu, ");
INSERT INTO kgf_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Miŋ Kewuac wésiaiguc kecma météré amuma képésic solaŋ kecma kekecnina séc weleŋ qemiwiŋ niŋac ʒéseliyec. ");
INSERT INTO kgf_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Merac gi Eŋeŋa yandawac kua meme ic ʒégéŋgéŋa wammac. Miŋ Kewuac wésiaiguc miha mema kemma iwac héna mézézéŋ géwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Imuhuc wamma aŋgéŋ titiac niniŋa képésic waiwai igucnec hahaya imi Miŋ Kewuac ic embachéra énézéna niŋasarimu. ");
INSERT INTO kgf_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Anutuninawac wésé niniŋ imi bénʒéŋa, imuac niŋac ou kurumeŋ igucnec kaiwe ésécnec neŋaŋ muru éréma ha nénécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mama hama siŋi ʒéma humucac tunumaŋiguc tatara neŋaŋ measari nénécmima hénanina luaeac hénaiguc qindiŋi nénécmimac. (Ʒakaraianéŋ imuhuc ʒéyu tecgéyec.) ");
INSERT INTO kgf_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Waŋu merac imi séwiya yandiyu ewa qeria momacnec meseli mimia waŋec. Waŋu baec kisiaiguc kerecac Israel ic onacmuru wininiyec. ");
INSERT INTO kgf_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nalé imuaru Roma ic eŋeŋagina Kaisa Augusitonéŋ ic embachéra ionac qacgina mema odacmu niŋac ʒézé seli ac oma haiyu eŋeya héŋgaleŋ baera séc kendarec. ");
INSERT INTO kgf_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Waŋu ic kewu Kirinionéŋ méra bawu kecma Siria baec yanda imi galeŋgéyec. Waŋu nalé imuac suraiguc ic embac qac areŋgina megic hatac momacguc waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Waŋu ic embac ieneŋ mocʒoŋ qacgina ʒégic oénécmimu niŋac eŋaŋ tauŋgina séc liliŋgéma kendacgic. ");
INSERT INTO kgf_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosefe imi Dawidiac sac kitic igucnec imuac niŋ, i acguc imuhucyanec Galilaia baec Naʒarete tauŋ imi waima Yuda baeciguc Dawidiac ama areŋa yanda qara Betelehem imuaru ");
INSERT INTO kgf_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","eŋeya qara ʒéyu omimu niŋac iniŋ buŋa qemimia Maria hériyaguc imi wagiru ekawu ekeŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ekemma keric Maria merac meme naléya imi waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Waŋu embac iminéŋ naŋa méréc merac meyec. Waŋu ic kiaŋ amaiguc iorac ama duŋ méŋ ménda he érécmiyu, merac imi malekunéŋ osoma burumakao wedeyaiguc haiyu heyec. ");
INSERT INTO kgf_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Waŋu nalé imuhucgeŋ baec imuhucgeŋ rama galeŋ tosara baec kisia lulucyaguc imuaru tacyac wamma siŋi imuaru ramahécgina héŋgaleŋ wamma kecgic. ");
INSERT INTO kgf_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Waŋu Miŋ Kewuac kua meme uŋa méŋnéŋ wininima hosucginu naŋu Miŋ Kewuac edamuyanéŋ asac mararaŋ ésécnec hoturu énécmiyu bac yandi yandi kuneŋ yanda waŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Waŋu kua meme uŋanéŋ yomuhuc énézéyec; Bacgina ménda yandiyu. Ninʒu, ni ségiségiac buŋa suruc hiabia onac muru ʒéau énécmizua. Waŋu ac yomi baec séc ic embac mocʒoŋ eŋaŋ buŋa wammac. ");
INSERT INTO kgf_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Erac Dawidiac ama areŋa yandaiguc aŋgéŋ titi miŋina hicŋi énécmizac. Imi mia Miŋ Kewu Kristo. ");
INSERT INTO kgf_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ini kemma burumakao wedeyaiguc merac sacsac méŋ malekunéŋ oso osoya hezac imi mihicŋimu. Waŋu haka iminéŋ ac imuac asé kiwiya waŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Imuhuc ʒéyu imuaru kurumeŋ miŋina kua meme uŋa tuŋ yandanéŋ kua meme uŋa iwac muru élanzaŋnec wininima Miŋ Kewu mepésima yomuhuc ʒégic; ");
INSERT INTO kgf_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ou kurumeŋiguc Miŋ Kewuac muru mepé qepési hezac. Waŋu you baeciguc, ic embac Anutunéŋ inicsoroc wanʒac ionac muru luae hezac. ");
INSERT INTO kgf_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Imuhuc ʒémaguc kua meme uŋa ieneŋ wai énécmima kurumeŋiguc eŋgic. Waŋu nalé imuaru rama galeŋ ieneŋ eŋaoc yomuhuc eminiŋgic; Betelehem ama areŋaiguc haka méŋ hicŋiyu Miŋ Kewunéŋ ʒéau nénécmizac, kemma hénni. ");
INSERT INTO kgf_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Imuhuc ʒéma foc foc kemma Maria, Yosefe ʒéma merac sac burumakao wedeiguc heyec imi mihicŋi énécmigic. ");
INSERT INTO kgf_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Waŋu inicma ackuaʒéc merac iwac niŋac ʒéyu niŋgic imi ʒésaigic keŋu nindacgic. ");
INSERT INTO kgf_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Waŋu ic embac suruc imi niŋgic séc haka rama galeŋnéŋ énézégic imuac nimma welicgégic. ");
INSERT INTO kgf_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Waŋu Maria eŋeyaoc imi haka imi mocʒoŋ qerianéŋ doŋgé nimma kerec. ");
INSERT INTO kgf_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Rama galeŋ ieneŋ ac ʒéyu niŋgic imuac séc hicŋi énécmiyu héla hémma niŋgic imuac niŋac Anutu mepésima edamuyawac ʒéhiarumima liliŋgéma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Waŋu séwi tasé hericheric memeac naléya ai meme 8 hahéiyu qara Yesu ʒémiyoc. Waŋu qac imi merac imuac hériyaguc ménda waŋunec kua meme uŋanéŋ ʒémiyec imi mia. ");
INSERT INTO kgf_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Waŋu Moseac héna ac heyec séciguc météré amuma kecgic naléya sécgéyu, iereŋ merac imi wagicma Miŋ Kewuac buŋa qemiwic ʒéma Yerusalem ekeŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Imi mia Miŋ Kewuac héna aciguc yomuhuc ooyawac heyec imi tohoma imuhuc waŋoc; Embac méŋnéŋ héri haima merac ic méréc mérérawac memac séc, Miŋ Kewuac buŋa téréya qemimu. ");
INSERT INTO kgf_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Waŋu Miŋ Kewuac héna aciguc ʒézéya heyecac hezac imuac séc kembo susuc éréhéc me kembo nei sac ɋelia éréhéc mulu manaŋ omiwic ʒéma ekeŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Waŋu Yerusalem imuhucgeŋ ic méŋ kerec, qara imi Simeon. Ic imi ic solaŋa waŋu Anutuac ewa siŋsiŋ wammanec kecaŋec. Waŋu Israel ionac héibélac qéibélac niŋac mambéc keru, Uŋa Téréyanéŋ i guc kecaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Waŋu Uŋa téréyanéŋ i ménda humuyunec Miŋ Kewuac Kristo hicŋiyu hémmac ʒéma ʒéauyu niŋec. ");
INSERT INTO kgf_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Waŋu ic imi Uŋanéŋ tiliŋgémiyu ocmuŋ téréyaiguc eŋec. Eŋu imuaru mia merac Yesu iwac neŋgoc maŋgocya iereŋ merac imuac niŋac wamma héna acac haka tohoma éréyoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Éréyic Simeonnéŋ merac imi wagicma tétécgéma namma yomuhuc ʒéma Miŋ Kewu mepésiyec; ");
INSERT INTO kgf_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Miŋ Kewuna, gi deguc weleŋ qeqe icga ni ackuaʒécga nézénec séciguc ");
INSERT INTO kgf_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","nena kic éréhécnanéŋ aŋgéŋ titiga hénʒua, imuac niŋac, deguc hia waina luaeiguc guac hamaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aŋgéŋ titiga imi baec séc ic embac neŋaŋ kicninaiguc nénézéna hénʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Merac yominéŋ ic enia ionac muru héniaga ʒéau énécmimiawac asacmararaŋa wanʒac. Waŋu guac Israel nonac edamunina wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Imuhuc ʒéyu Yosefe ʒéma neŋgocya iereŋ merac iwac niŋac ʒézéya waŋec ac imuac mia welicgéyoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Waŋu Simeonnéŋ mozoc ac ʒéénécmima neŋgocya yomuhuc ézéyec; Hénna, merac yomi Israel sucninaiguc ic embac sasalanéŋ yacmu me mama unumac niŋac Anutunéŋ kumuyu asé kiwi ésécnec naŋu, haʒéc ac wammimuac niŋu hezac. ");
INSERT INTO kgf_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","(Imuhuc waŋgic sounéŋ geŋga ewa qeriga néʒéŋgémac tanec wammac.) Waŋu inéŋ ic embac sasala ionac ewa qeriginaiguc niniŋgina hezac imi usuya auyu hémma nindacmu. ");
INSERT INTO kgf_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Waŋu ama yanda imuaru Anutuac kua meme embac méŋnéŋ embac yanda wamma kerec. Qara imi Ana. Inéŋ Banuelac bérara, waŋu Aseriac areŋ igucnec. Inéŋ icya mema yawuŋ 7 imuac séc euyaguc keroc. ");
INSERT INTO kgf_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Waŋu euya humuyu malé wamma keru yawuŋa 84 waŋec. Inéŋ nalé séc ocmuŋ téréya ménda waima siŋi kaiwe séc nene ʒikima ʒéwelec wamma Anutu mepésima kecaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Waŋu nalé imuaru embac iminéŋ éréma Anutuac ewa hia ac ézéyec. Ézéma ic embac tosara Anutunéŋ Yerusalem ic embac doegina memac niŋac mambécma kecgic imi onac muru merac iwac hénia ʒéasari énécmiyu nindacgic. ");
INSERT INTO kgf_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosefe ʒéma Maria iereŋ Miŋ Kewuac héna ac tohoma ai imi mocʒoŋ meyic tecgédaru, Galilaia baeciguc liliŋgéma mekemma ekaŋ tauŋgina Naʒarete keŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Waŋu Merac imi séwiya yandiyu meseli mimia waŋu niŋtegic qiŋtegicyanéŋ sécgémiyec. Waŋu Anutuac goi héihéianéŋ iwaru hemiyec. ");
INSERT INTO kgf_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Waŋu Yesuac neŋgoc maŋgocya iereŋ imi yawuŋ séc nagu sacyaguc ogicogira imuac kendoŋa ducŋiyu, Yerusalem ekeŋaŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Waŋu keŋkecma Yesuac yawuŋa 12 waŋec nalé imuaru imuhucyanec kendoŋ imuac hakaya tohoma Yerusalem ekeŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ekemma ai meme sécya kecgic tecgédaru liliŋgéma ama areŋa yandagiraiguc mekeŋoc. Waŋu merac Yesu inéŋ Yerusalemiguc waima kerec. Waŋu Yosefe ʒéma neŋgocya iereŋ imi ménda niŋtegiroc. ");
INSERT INTO kgf_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Imuac niŋ ic kiaŋ sucginaiguc kenʒac ʒéma nimma héna imi ai meme momacgucac séc kemma sac taséhécgira ʒéma alahécgira ionac sucginaiguc horoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Waŋu ménda mihicŋima mihicŋiwi ʒé hocmanec Yerusalem ekeŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Imuhuc hocma keric ai meme haréwéc tecgéyuguc ocmuŋ téréyaiguc emma imuaru mia mihicŋiyoc. Mihicŋima héŋic héna acac kiwi ic ionac sucginaiguc tacma acgina nimma qesiénécmima tarec. ");
INSERT INTO kgf_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Waŋu iwac ara niŋgic séc niŋ asac asaria niŋac ʒéma ʒéqesiqesi ginawac héla énézéyu nimma welicgégic. ");
INSERT INTO kgf_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Waŋu neŋgoc maŋgocya iereŋ imi hémma auriyoc. Waŋu neŋgocyanéŋ yomuhuc ézéyec; Naŋna, gi némac niŋac haka imuhucya waŋ nérécmizaŋ? Niricna, maŋgocga ʒéma ni nekawu kuneŋ yanda niŋyéwérima hocgémma kecʒic. ");
INSERT INTO kgf_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Imuhuc ʒéyu Yesunéŋ ac bakia yomuhuc meleŋ érécmiyec; Iri némac niŋac ni hoc nénʒaoc? Ni Maŋgocnawac amaiguc kecmaŋac hezac hénia imi ménda niŋtegiroc? ");
INSERT INTO kgf_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Imuhuc ʒéyec, néŋ iereŋ ac érézéyec imuac hénia imi ménda niŋasariyoc. ");
INSERT INTO kgf_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Waŋu Yesunéŋ yacma iriguc mekemma Naʒarete ama areŋaiguc hagic. Hama imuaru acgira tohoma kerec. Waŋu neŋgocyanéŋ Yesuac ara imi mocʒoŋ qerianéŋ eeya héima késakerec. ");
INSERT INTO kgf_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu imi niniŋa ʒéma séwiya yandiyu, Anutu ʒéma ic embac ieneŋ hémma héŋsorocgic. ");
INSERT INTO kgf_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ic kewu eŋeŋagina Kaisa Tiberionéŋ Roma galeŋgéma keru yawuŋ 15 waŋec. Waŋu nalé imuaru Pontio Pilatonéŋ Yuda baec galeŋ keru, Herodenéŋ Galilaia baec galeŋ kerec. Waŋu munia Filiponéŋ Iturea ʒéma Trakoniti baec galeŋ kerec. Waŋu Lisanianéŋ Abilene baec galeŋ kerec. ");
INSERT INTO kgf_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Waŋu nalé imuaru Hanasi ʒéma Kayafa iereŋ hofac oo ic kiwa keroc. Waŋu nalé imuaru Anutuac ackuaʒéc méŋnéŋ baec ʒéléŋaiguc Ʒakariawac naŋa Yohane iwac muru mayec. ");
INSERT INTO kgf_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Mayu Yohanenéŋ Yodan doku téfara néwéc néwéc ama séc hama képésicgina qahac wammacac niŋ ewa qeri meleŋ meleŋac doku naec imuac hénia ʒéau énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anutuac tiliŋ tiliŋ ic Yesaiawac kiwiiguc yomuhuc oyecac hezac; Baec ʒéléŋaiguc ic méŋnéŋ qaru ac ewaya yomuhuc hicŋizac; Miŋ Kewuac héna héimindiŋi waŋgicguc. Iwac niŋ wamma hénaya mindiŋigic didiŋa waŋu. ");
INSERT INTO kgf_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Baec wéŋwéŋgia séc tilogi érédaru. Baec boŋa ʒéma baec héŋgeŋ héŋgeŋa imi mocʒoŋ madaru. Waŋu héna kukeŋ kuha imi didiŋa wandaru, waŋu héna eŋeŋ mamaya imi solaŋa wandaru. ");
INSERT INTO kgf_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Waŋu baec ic embac momac yanda Anutuac aŋgéŋ titi imi hémmu. ");
INSERT INTO kgf_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohanenéŋ ic embac tuŋ yandanéŋ doku naec énécmimac niŋac harégic, inicma yomuhuc énézéyec; Qaté mokoleŋ ionac ɋelihécgina Anutuac qeri geric hahaya imuacnec néŋgacmu niŋac mérénéŋ goro ac waŋ énécmiyec? ");
INSERT INTO kgf_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Néŋgacmuac séc qahac imuac, ewa qerigina melemma héla imuac séc haimu. Imuhuc ménda wamma ewa qeriginanéŋ Abaraham imi neŋaŋ yandanina imuhuc ménda ʒému. Ni énézéwa niŋgic, Anutunéŋ hoc yomuac ʒéyu meleŋ dacma Abarahamac ɋelihéra hia wandacmu. ");
INSERT INTO kgf_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Bec ic héniaiguc naka haiyu hezac. Imuac ic méŋac méŋ héla hiabia ménda haihaiya imi, héima geric bélaŋiguc giliyu hiŋgacdacmac. ");
INSERT INTO kgf_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Imuhuc ʒéyu, ic tuŋ eneŋ qesima ʒégic; Imuhuc ʒéna duŋa neneŋ dimuhuc waŋniguc sécgémac? ");
INSERT INTO kgf_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ʒégic yomuhuc melemma énézéyec; Ic méŋ malekuya éréhéc késama kecʒac inéŋ méndémma ic méŋ malekuya qahac kecʒac iwac méŋ mimac. Waŋu neneyagucnéŋ imuhucyanec waŋ énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis meme eneŋ acguc doku naec énécmimac niŋac hama ʒégic; Kiwi ic nini dimuhuc wambiŋ? ");
INSERT INTO kgf_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ʒégic ʒéyec; Ini soukiwa, qété ʒézéya imi ménda ogicma memu. ");
INSERT INTO kgf_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Téŋgiŋ ic eneŋ imuhucyanec haréma ʒégic; Waŋu nini dimuhuc wambiŋ? Ʒégic yomuhuc énézéyec; Ini ic ménda tericgé énécmima iwawaigina ménda onogicma héipuc ac ikora ménda ʒéma maso séc ai boŋgina imuac niŋgic sécgémac. ");
INSERT INTO kgf_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Waŋu icya icya Kristoac mambéc kecma ewa qeriginanéŋ Yohaneac nimma ic imi Kristo gezaŋ ʒéma niŋgumbi niŋguŋ waŋaŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Waŋu Yohanenéŋ acgina kitiwa melemma ic embac momac yanda yomuhuc énézéyec; Ni dokunéŋ naec énécmianʒua, néŋ ic méŋ ni nogicma kuc yanda késa kecʒac iminéŋ hamac. Nidac imuhucyanéŋ iwac héna usuyawac hésiya imi hulacmaŋac séc qahac. Inéŋ mia Uŋa Téréya ʒéma geric bélaŋanéŋ képésicgina ʒuac énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Inéŋ mériaiguc sarac yanda késama kecʒac. Waŋu sombeŋa imi mocʒoŋ usuŋ héréracgéma héla gocmia imi qutulaŋgéma hofiyaiguc haidacmac. Imuhuc wamma inéŋ gorosoŋa imi geric bélaŋa méwécgéwiŋac séc qahac imuaru giliyu ʒemac. ");
INSERT INTO kgf_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Inéŋ toroqema ac sasala imuhucya imuhucya énézéma qerigina meseli énécmima buŋa suruc hiabia imi ic embac ʒéau énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Waŋu nalé imuaru baec galeŋ Herodenéŋ muniawac iniŋa Herodia meyec. Waŋu imi sac qahac, haka biria hénia hénia momacnec waŋec. Imuac niŋac, Yohanenéŋ ac geriwaguc ʒémiyu niŋec. ");
INSERT INTO kgf_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nimma toroqema haka biria méŋ wamma Yohane késama hésa amaiguc oporec. ");
INSERT INTO kgf_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hésa amaiguc ménda kerecnec Yohanenéŋ ic embac mocʒoŋ doku naec énécmiyec, Yesu imuhucyanec iwac muru hayu, doku naecmiyec. Naecmiyu ʒéwelecma naŋu imuarunec kurumeŋ naguya aŋgéyec. ");
INSERT INTO kgf_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aŋgéyu Uŋa Téréyanéŋ kembo nei ésécnec héiyaguc mama iwac qahu mayu kurumeŋ igucnec ewa méŋ yomuhuc mayec; Gi nena naŋ sorocna ni guac niŋ ségiségi waŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Waŋu Yesunéŋ yawuŋa 30 imuac séc waŋu aiya hénima meyec. Waŋu ic embac ieneŋ iwac niŋgic Yosefeac naŋa waŋec. Waŋu Yosefeac maŋgocya imi Eli. ");
INSERT INTO kgf_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliac maŋgocya Matata, Matataac maŋgocya Lewi, Lewiac maŋgocya Melki, Melkiac maŋgocya Yannai, Yannaiac maŋgocya Yosefe, ");
INSERT INTO kgf_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefeac maŋgocya Matadia, Matatiawac maŋgocya Amosi, Amosiac maŋgocya Nahum, Nahumac maŋgocya Esili, Esiliac maŋgocya Naŋgai, ");
INSERT INTO kgf_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naŋgaiac maŋgocya Maati, Maatiac maŋgocya Matadia, Matatiawac maŋgocya Semein, Semeinac maŋgocya Yosek, Yosekac maŋgocya Yoda, ");
INSERT INTO kgf_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yodawac maŋgocya Yoanan, Yoananac maŋgocya Resa, Resawac maŋgocya Ʒorobabel, Ʒorobabelac maŋgocya Salatiel, Salatielac maŋgocya Neri, ");
INSERT INTO kgf_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriac maŋgocya Melki, Melikiac maŋgocya Adi, Adiac maŋgocya Kosam, Kosamac maŋgocya Elmadam, Elmadamac maŋgocya Eri, ");
INSERT INTO kgf_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eriac maŋgocya Yesua, Yesuawac maŋgocya Elieʒere, Elieʒereac maŋgocya Yorim, Yorimac maŋgocya Matata, Matatawac maŋgocya Lewi. ");
INSERT INTO kgf_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewiac maŋgocya Simeon, Simeonac maŋgocya Yuda, Yudawac maŋgocya Yosefe, Yosefeac maŋgocya Yonam, Yonamac maŋgocya Eliakim, ");
INSERT INTO kgf_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimac maŋgocya Melea, Meleawac maŋgocya Menna, Mennawac maŋgocya Matata, Matadawac maŋgocya Natan, Natanac maŋgocya Dawidi, ");
INSERT INTO kgf_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawidiac maŋgocya Yesi, Yesaiac maŋgocya Obedi, Obedac maŋgocya Boasi, Boasiac maŋgocya Salmon, Salmonac maŋgocya Nason, ");
INSERT INTO kgf_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonac maŋgocya Aminadap, Aminadapac maŋgocya Adimin, Adiminac maŋgocya Arini, Ariniac maŋgocya Hesiron, Hesironac maŋgocya Feresi, Feresiac maŋgocya Yuda, ");
INSERT INTO kgf_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yudawac maŋgocya Yakobo, Yakopac maŋgocya Isaka, Isakawac maŋgocya Abaraham, Abarahamac maŋgocya Tara, Tarawac maŋgocya Nahori, ");
INSERT INTO kgf_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoriac maŋgocya Serugu, Serukac maŋgocya Ragau, Ragauac maŋgocya Pelek, Pelek iwac maŋgocya Eberi, Eberiac maŋgocya Sala, ");
INSERT INTO kgf_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selawac maŋgocya Kainan, Kainanwac maŋgocya Arafaksat, Arafaksatac maŋgocya Sem, Sem wac maŋgocya Noa, Noawac maŋgocya Lamek, ");
INSERT INTO kgf_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekac maŋgocya Metusela, Metuselalac maŋgocya Enoko, Enokoac maŋgocya Yaret, Yaretac maŋgocya Mahalale, Mahalaleac maŋgocya Kainan, ");
INSERT INTO kgf_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainamac maŋgocya Enosi, Enosiac maŋgocya Set, Setac maŋgocya Adam, Adamwac maŋgocya Anutu, ");
INSERT INTO kgf_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Waŋu Uŋa Téréyanéŋ Yesu sécgémiyu, Yodan doku igucnec liliŋgéma hama baec kisiaiguc siŋi kaiwe 40 keru, Uŋa Téréyanéŋ wagiru keŋha waŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Waŋu ai meme 40 imuac séc Biria miŋinanéŋ ala batuc wammiyec. Waŋu iwawai méŋ ménda nema keru nalé imi mocʒoŋ tecgéyu yaka niŋ humuyec. ");
INSERT INTO kgf_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yaka niŋac humuma keru, Biria miŋinanéŋ hama ézéyec; Gi Anutuac Naŋa wanʒaŋiguc ʒéna hoc yominéŋ melemma nene waŋu. ");
INSERT INTO kgf_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ʒéyu melemma ʒéyec; Kiwi téréyaiguc ac yomuhuc ogic hezac; Ic méŋnéŋ séwiac nene sac nema ménda kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Imuhuc meleŋu Biria miŋinanéŋ Yesu wagicma ou emma héŋgaleŋ ama areŋa yanda baec séc hema kenʒac imi mocʒoŋ focnec ézéyu héndarec. ");
INSERT INTO kgf_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Waŋu ézéma yomuhuc ʒéyec; Iwawai mocʒoŋ yanda imuac kuc buŋa yanda ʒéma edamuya imi neŋ guac waigémmaŋ ʒé wanʒua. Imi mia nuac méranaiguc haihaiya imuac neŋ méŋac méŋ mimaŋ ʒé hia mimaŋac séc. ");
INSERT INTO kgf_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Imuac gi simiŋ héima mepési némbésémaŋiguc iwawai imi mocʒoŋ guac buŋa wandacmac. ");
INSERT INTO kgf_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Yomuhuc mia ooyawac hezac; Miŋ Kewu Anutuga mepésima iwacnec sac weleŋ qemiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Imuhuc ʒéyu Biria miŋinanéŋ i muŋguc wagicma Yerusalem keŋoc. Kemma ama téréya imuac witiyaiguc ou oporu naŋu yomuhuc ézéyec; Gi Anutuac Naŋa wanʒaŋiguc yomuarunec luma emu hiŋgacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ʒéyu ʒéyec; Ac méŋ yomuhuc ooyawac hezac; Anutunéŋ guac wamma galeŋgé gémmu niŋac kua meme uŋahéra énézémac. ");
INSERT INTO kgf_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Waŋu kua meme uŋa eneŋ gi ménda mama gumac niŋac méraginanéŋ loloŋgéma gépésigic hénaga hocnéŋ ménda héimac. ");
INSERT INTO kgf_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Imuhuc ʒéyu Yesunéŋ muŋguc melemma ʒéyec; Yomuhuc ooyawac hezac; Miŋ Kewu guac Anutuga ménda batucgé miwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Imuhuc ʒéyu Biria miŋinanéŋ manam batuc ai imi metecgéma waimima kemma nalé méŋac mambéc kerec. ");
INSERT INTO kgf_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Waŋu Yesunéŋ Uŋa Téréyawac kuciguc Galilaia baeciguc liliŋgéma keŋu iwac surucya imi ama lelec lelec tacma keŋec séc saima kendarec. ");
INSERT INTO kgf_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Waŋu Yesu eŋeyaoc tocgotocgo amaya amaya emma ackuaʒéc ku énécmiyu ic embac momac yanda ieneŋ mepésimigic. ");
INSERT INTO kgf_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Waŋu Yesunéŋ Naʒarete ama areŋaiguc kereŋec. Inéŋ ama areŋa yanda imuaru mia yandiyec. Waŋu Sabata nalé méŋu haka waŋaŋec ésécnec tocgotocgo amaiguc emma kiwi téréya olommaŋ ʒé naŋec. ");
INSERT INTO kgf_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Anutuac tiliŋ tiliŋ ic Yesaiawac kiwi limbi limbiŋa miyu hutuma kiwi ooya yomuhuc mihicŋiyec; ");
INSERT INTO kgf_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ic maqeqeya ionac buŋa suruc hiabia imi énézémaŋ niŋac Anutuac Uŋa téréyanéŋ ni halécnéŋ naecnémma météré néŋec. Waŋu hésa ic ionac ʒiki sipacgina metecgé énécmima kichilic ionac kichihi meénécmima weleŋ qeqe ic ionac yéwérigina metecgé énécmimaŋ niŋac inéŋ ni méli néŋec. ");
INSERT INTO kgf_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Waŋu Miŋ Kewuac goi héihéi yanda imuac yawuŋa hazac ʒéma ʒéau énécmimaŋ niŋac méli néŋec. ");
INSERT INTO kgf_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Imuhuc olommaguc kiwi imi limbima imuac galeŋa mima mama tarec. Taru tosara tocgotocgo ama imuac qeriaiguc tacgic ieneŋ héŋsosoligic. ");
INSERT INTO kgf_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Waŋu Yesunéŋ hénima ac yomuhuc énézéyec; Deguc kiwi ooya olomba gezacginanéŋ niŋgic imi hélaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ieneŋ mocʒoŋ héipuc ac ʒémima kuaya igucnec ackuaʒéc hiabia ʒéhicŋiyu nimma welicgéma yomuhuc ʒégic; Ic yomi Yosefeac naŋa ménda wanʒac? ");
INSERT INTO kgf_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Waŋu Yesunéŋ énézéyec; Niŋtegic qiŋtegic ac méŋ yomuhuc hezac; Mehiahiaru ic gi geŋgac séwiga mehiaruna. Ini imi ac imi mema tinduc yomuhuc nézému; Kafanaum amaiguc kiwi mena surucga ʒégic niŋiŋ. Waŋu haka imuhucya you geŋga tauŋgaiguc mena hénni. ");
INSERT INTO kgf_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Imuhuc ʒéma toroqema yomuhuc ʒéyec; Hélacnec énézéwa niŋgic, Anutuac tiliŋ tiliŋ ic méŋac méŋ eŋeya tauŋaiguc imi ʒézé ségiségi wammimia méŋ ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hélacnec énézéwa niŋgic, Elia kerec imuaru yawuŋ haréwéc ʒéma maso 6 séc kurumeŋ ʒikiyu, baec séc béti yanda hicŋiyec. Waŋu nalé imuaru Israel baec yandaiguc embac malé sasala kecgic. ");
INSERT INTO kgf_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Waŋu Anutunéŋ Elia imi méŋac méŋ ménda mélimiyec, néŋ Sidon baec Sarepta ama areŋa yandaiguc embac malé méŋ kerec iwac sac mélimiyu keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Waŋu Anutuac tiliŋ tiliŋ ic Elisa kerec nalé imuaru Israel baec yandaiguc ic wizi warihaguc sasala kecgic, néŋ sucginaiguc méŋac méŋ ménda mehiaruyec, néŋ Siria ic Naman sac mehiaruyec. ");
INSERT INTO kgf_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Imuhuc ʒéyu tocgotocgo amaiguc tuŋaguc tacgic eneŋ ac imi niŋgic qeri biricnéŋ sécgé énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Waŋu ieneŋ yacma tauŋ heyec baec imuac tetecgiaiguc sia yanda naŋec imuaru Yesu naŋgégic hiŋgacmac niŋ nesimima tauŋ imuac séŋgaŋgeŋiguc héréma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Waŋu inéŋ sucginaiguc qeric énécmima keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Waŋu Yesunéŋ Galilaia baec Kafanaum ama areŋa yandaiguc mama hama imuaru Sabata naléiguc ackuaʒéc ku énécmima kerec. ");
INSERT INTO kgf_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Waŋu niŋgic ara imi qac buŋayaguc waŋu welicgégic. ");
INSERT INTO kgf_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Waŋu tocgotocgo ama imuaru ic méŋ kuwic ʒapi qeqeyaguc méŋnéŋ tacma qac geŋgelaŋgéma qarec. ");
INSERT INTO kgf_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Aa, Naʒarete Yesu gi ʒéma nini imi neŋac neŋac. Waŋu gi mebiri nénécmimaŋ ʒé hazaŋ? Ni ninʒua gi méré, gi imi Anutu arunec Téréya. ");
INSERT INTO kgf_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Imuhuc ʒéyu Yesunéŋ qetalimima ʒéyec; Acga qaiyu ic iwarunec éréma mana. Imuhuc ʒéyu kuwic iminéŋ ic imi ic tuŋ imuac sucginaiguc hérékeŋ héréha wammima éréyu ic iminéŋ mama qeyec, néŋ séwiya méŋ ménda biriyec. ");
INSERT INTO kgf_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Waŋu haka imi hémma ic embac mocʒoŋ welicgéma eminimma ʒégic; Ackuaʒéc imi dimuhucya! Kuc buŋa ʒéma kuc yandayaguc! Kuwic ʒapi qeqeya ézéyu ara tohoma érézac! ");
INSERT INTO kgf_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Waŋu Yesuac surucya imi ama areŋ lelec lelec hezac séc saima kendarec. ");
INSERT INTO kgf_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Waŋu Yesunéŋ yacma tocgotocgo ama imuacnec mama kemma Simonac amaiguc eŋec. Eŋu Simonac howuhaya imi séwi geric yandanéŋ késayu heyu, ic embac eneŋ iwac niŋ wamma Yesu welecmigic. ");
INSERT INTO kgf_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Welecgic Yesunéŋ hosuraiguc namma séwi geric imi qetalimima ʒéyec. Ʒéyu hafi imi waimiyu embac iminéŋ nalé sosola qahac yacma weleŋ qeénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kaiwe hiŋgacmaŋ ʒé waŋu ic embac ieneŋ ic tosara hafigina hénia hénia ʒéma ʒepaginaguc imi onagicma harégic. Waŋu harégic séc Yesunéŋ méria hai énécmima mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Waŋu uŋa birianéŋ momacnec ic embac sasala ionarunec éréma qacma ʒégic; Gi imi Anutuac Naŋa. Imuhuc ʒégic uŋa biria ieneŋ Yesu imi Kristo wanʒac hénia imi niŋgic imuac niŋac Yesunéŋ qetali énécmima ac ménda ʒému niŋac neuŋ héiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Waŋu ama giaŋiyu Yesunéŋ séŋgaŋgeŋ mama baec kisia méŋ hétéŋa qahac imuaru kemma tackeru, ic tuŋ eneŋ hocma mihicŋima ménda wai énécmima kemmac niŋac ʒéqetali wammigic. ");
INSERT INTO kgf_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Imuhuc waŋgic Yesunéŋ yomuhuc énézéyec; Ama yanda tosara imuac ic embac ionac imuhucyanec Anutuac héŋgaleŋ ama areŋa yandawac buŋa suruc hiabia imi énézémaŋac hezac. Ni imi ai imuac mia méli néŋu mayi. ");
INSERT INTO kgf_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Imuhuc ʒéma kemma Yuda baeciguc tocgotocgo amaya amayaiguc ackuaʒéc énézéyec. ");
INSERT INTO kgf_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yesunéŋ Genesarete ʒékéŋ yanda giŋgiŋaiguc naŋkeru tuŋ yandanéŋ Anutuac ackuaʒéc nimbiŋ ʒé héfacgé amuma hosuraiguc lelecgé migic. ");
INSERT INTO kgf_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Waŋu Yesunéŋ héŋu ʒékéŋ giŋgiŋa imuaru ʒéic komora éréhéc taroc. Taric lambéc héréhéré ic ieneŋ imuacnec mama uficgina ʒuacma kecgic. ");
INSERT INTO kgf_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Waŋu Yesunéŋ ʒéic méŋiguc eŋec. Waŋu ʒéic imi ic méŋ qara Simon iwac ʒéic. Yesunéŋ Simon ézéyu ʒéic imi naŋgéyu élélahunec komora dokuguc mekemma taru imuaru tacma tuŋ yanda imi ku énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kuénécmiyu tecgéyu Simon yomuhuc ézéyec; Gi doku hiŋgac hiŋgaraiguc kemma uficga haima lambéc héréna. ");
INSERT INTO kgf_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ʒéyu Simonnéŋ melemma ʒéyec; Kiwi ic nini siŋiyaiguc ai yanda meni ama giaŋizac, néŋ méŋ ménda mihicŋiziŋ. Waŋu ʒézaŋ imuac wamma uficna mocʒoŋ muŋguc haiwa hiŋgacdacmu. ");
INSERT INTO kgf_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Imuhuc ʒéma Yesu ʒéyec séc wamma lambéc sasala yanda héréyu uficgina hénima tegirec. ");
INSERT INTO kgf_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Waŋu alahécgina ʒéic méŋiguc kecgic eneŋ hama méra énécmimu niŋac méra kaec ku énécmima welec énécmigic. Waŋu ieneŋ hama ʒéic éréhécnec tigic kuagira qeyu ʒéic éréhéc imi doku qeriaiguc hiŋgacbi ʒé waŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Waŋu Simon Peteronéŋ haka imi hémma Yesuac simiŋa igucgeŋ sicgéma yomuhuc ʒéyec; Miŋ Kewu ni imi képésic ic, imuac wainémma kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Imi mia eŋeya ʒéma ic tosara i guc kecgic eneŋ mocʒoŋ lambéc hérégic imi hémma welicgégic hénia imuac niŋ imuhuc ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Waŋu Ʒebedaioac naŋhéréra Simonac ai momac Yakobo ʒéma Yohane imuhucyanec welicgéyoc. Waŋu Yesunéŋ Simon yomuhuc ézéyec; Ʒénéŋga ménda hiriyu, kecma gi ic embac énépésiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Waŋu ieneŋ ʒéic héréma élélahu haima iwawai mocʒoŋ imuaru waidacma Yesu méndacma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesunéŋ ama areŋa yanda méŋiguc kerec. Keru ic méŋ wizi seli séwiya sécgémiyu kerec inéŋ Yesu hémma sicgéma welecma ʒéyec; Miŋ Kewu, nuac ewa siŋga hegéŋu ni hia mesolaŋi némbésémaŋac séc. ");
INSERT INTO kgf_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ʒéyu Yesunéŋ méria suluma osimima yomuhuc ʒéyec; Ni imuac wanʒua, solaŋa wanna. Imuhuc ʒéyu wiziya imi bec qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Waŋu Yesunéŋ ic imi neuŋ héimima yomuhuc ézéyec; Ic méŋac méŋ ménda ʒéwésémaŋ, néŋ kemma hofac oo ic séwiga ézéna hémma solaŋa wanʒaŋ imi héŋu Mosenéŋ ʒéyec séc Anutuac buŋa haina ogéŋu haka iminéŋ héipuc waŋ énécmiyu ninʒéŋgému. ");
INSERT INTO kgf_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Waŋu Yesuac qac buŋanéŋ muŋguc yanda saima keŋu ackuaʒécya nimma hafigina mehiaru énécmimac niŋ ic embac tuŋaguc sasala tocgéma hamanec hagic. ");
INSERT INTO kgf_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Waŋu Yesunéŋ eliŋgé amuma eŋeyanec baec kisiaiguc kemma ʒéwelerec. ");
INSERT INTO kgf_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kaiwe méŋu Yesunéŋ ic embac ac ku énécmimanec naŋu Galilaia ama areŋa areŋa ʒéma Yuda baec ʒéma Yerusalemnec Farisaio ic ʒéma héna acac kiwi ic eneŋ hama momacnec tacgic, Anutuac hafi mehiahiaruac kuhanéŋ iwaru hemiyec. ");
INSERT INTO kgf_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Waŋu ic tosaranéŋ ic puriŋ méŋ sasaŋiguc huama hama Yesuac wésiaiguc haiwiŋ ʒé wagicma embiŋ ʒé waŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Néŋ tuŋ yanda tacma hénaya héʒicgégic titiŋa qahac waŋec. Imuac ama qahaiguc emma ama bauya augic kifaŋa hicŋiyu ic puriŋa imi sasaŋaguc ic embac sucginaiguc Yesuac wésiaiguc haigic hiŋgarec. ");
INSERT INTO kgf_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesunéŋ ionac ninʒéŋ ninʒéŋgina imi hémma yomuhuc ézéyec; Ic ala guac képésicga waiwaiya wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Imuhuc ʒéyu héna acac kiwi ic ʒéma Farisaio ic eneŋ qeriginanéŋ yomuhuc niŋgic; Ic yomi mérénéŋ Anutu ʒébiri qébiri wammima imuhuc ʒézac? Baec ic méŋnéŋ méŋ neŋaŋ képésicnina aumacac séc qahac! Imi mia Anutunéŋ sac wammacac séc. ");
INSERT INTO kgf_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Imuhuc eminiŋgic Yesunéŋ imi niŋtegicma melemma ʒéyec; Ini qeriginaiguc némac ac emininʒu? ");
INSERT INTO kgf_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ic héna méria humumia ézémaŋ ʒéma ac diminéŋ efefia wammac? Képésicga waizua iminéŋ efefia me yacma hehega mema kembésémaŋ imi? ");
INSERT INTO kgf_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Icac Naŋa ni imi baeciguc képésicgina wai énéc mimiawac kuc buŋana henénʒac imi héŋtegicmu. Imuhuc ʒéma ic héna méria humumia i yomuhuc ézéyec; Ni gézézua, yacma sasaŋga mema amagaiguc kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Imuhuc ʒéyu ic imi zélandac kicginaiguc yacma iwawai heaŋec imi mema Anutu mepésima eŋeya amaiguc liliŋgéma keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Keŋu ic embac mocʒoŋ kileŋ yanda welicgéma Anutu mepésigic. Waŋu ʒénéŋgina hiriyu ʒégic; Deguc nini haka méréra hénʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Imuac andiaiguc Yeusunéŋ hiŋgacma kemma héŋu takis meme ic méŋ qara Lewi inéŋ ai amayaiguc taru hama ni méndac nénna ʒéma ézéyec. ");
INSERT INTO kgf_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ʒéyu inéŋ yacma iwawai mocʒoŋ andé qedacma méndac miyec. ");
INSERT INTO kgf_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewinéŋ Yesuac eeya héima amayaiguc aria yanda waŋu takis meme ic tosara ʒéma ic embac sasala tosara momacnec hama nene newiŋ ʒé tacgic. ");
INSERT INTO kgf_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Waŋu Farisaio ic ʒéma ionac kiwi oo ic eneŋ Yesuac tohotoho ichéra ŋidic ŋuduc ac waŋ énécmima ʒégic; Ini dimuhuc takis meme ic ʒéma képésic ic iniguc nene doku nema tacʒu? ");
INSERT INTO kgf_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ʒégic Yesunéŋ melemma ʒéyec; Ic hafigina qahac ieneŋ dokta niŋac ménda waŋanʒu, néŋ hafiginaguc ieneŋ mia imuac waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ni mia ic solaŋa unurumaŋ ʒéma ménda mayi, néŋ biria meme ic ewa qerigina melemmu niŋac unurumaŋ ʒé mayi. ");
INSERT INTO kgf_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Imuhuc ʒéyu ieneŋ Yesu yomuhuc ézégic; Yohaneac tohotoho ichéra ieneŋ hatac sasala nene ʒikima ʒéwelecanʒu. Waŋu Farisaio ic ionac tohotoho ichécgina imi imuhucyanec waŋanʒu. Waŋu guac tohotoho ichécga imi eneŋ nalé séc nene doku neanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ʒégic Yesunéŋ melemma énézéyec; Ic qaŋ tosara ic méŋ embac memaŋ ʒé wanʒac i guc kecʒuiguc nene ʒikima ʒéwelec ai memu niŋac hia énézémuac séc me? ");
INSERT INTO kgf_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Imi qahac, néŋ kecma nalé imi ducŋiyu euya imi wagicma keŋgic qahac waŋuguc nalé imuaru mia nene ʒikima ʒéwelecmu. ");
INSERT INTO kgf_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Imuhuc ʒéma toro qema séséc ac yomuhuc ʒéma énézéyec; Méŋnéŋ méŋ maleku ɋelia mericma maleku wahalaiguc ménda ɋotoanʒac. Imuhuc wammaciguc maleku ɋelia imi mebirimac, néŋ susuria ɋelia imi maleku wahalaiguc haimac imi, séc ménda héimac. ");
INSERT INTO kgf_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Waŋu méŋnéŋ méŋ waiŋ doku ɋelia yaŋ séwélanéŋ gésé memeya wahalaiguc ménda tianʒac. Imuhuc wammaciguc waiŋ ɋelianéŋ melemma waiŋ selia wammaŋ ʒé wéséséya mihicŋima gésé imi épépéŋgéyu tegiru waiŋ imi mama biriyu, gésé imi momacnec biridacmac. ");
INSERT INTO kgf_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Imuac waiŋ doku ɋelia imi gésé ɋeliaiguc timacac hezac. ");
INSERT INTO kgf_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Waiŋ imi nalé horua heheyawac waiŋ qacguc ʒéanʒac imuac niŋac méŋnéŋ waiŋ wahala kuhaguc imi nemaguc waiŋ ɋelia kuha qahac méŋ niŋac ménda waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabata nalé méŋu Yesunéŋ padi ai namuŋgina igucnec qericma keŋec. Keŋu tohotoho ichéra ieneŋ méndacma kemma padi héla momac momac kuma mema méraginanéŋ asasaŋgéma negic. ");
INSERT INTO kgf_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Imuhuc waŋgic Farisaio ic tosara eneŋ yomuhuc ʒégic; Némac niŋ haka Sabata naléyaiguc ménda wawaŋa imuhucya wanʒu? ");
INSERT INTO kgf_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ʒégic Yesunéŋ acgina melemma ʒéyec; Ini Dawidi ʒéma ichéra ieneŋ yaka niŋ humugic nalé imuaru, néma haka waŋec imi ménda oloŋ niŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Inéŋ Anutuac ama qeriaiguc emma saméŋ haimimia, tosara qahac, néŋ hofac oo ic ieneŋ sac nemuac héna aciguc hezac imi mema neyec. Nema ichéra i guc kecgic imi acguc énécmiyu nedacgic. ");
INSERT INTO kgf_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesunéŋ imuhuc ʒéma ac yomuhuc toroqema ʒéyec; Icac Naŋa imi Sabata naléyawac miŋina wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Waŋu Sabata nalé méŋu Yesunéŋ tocgotocgo amaiguc emma ackuaʒéc ku énécmiyec. Waŋu imuaru ic méŋ tarec. Waŋu iwac méra héiya imi séléc sélécgia. ");
INSERT INTO kgf_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Héna acac kiwi ic ʒéma Farisaio ic ieneŋ Yesu aciguc opocbiŋ ʒé képésira méŋ mihicŋiwiŋ ʒéma Sabataiguc hafi ic mehiarumac me qahac ʒéma awima kecgic. ");
INSERT INTO kgf_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Waŋu Yesunéŋ ewa qerigina niŋtegicma ic méraya séléc sélécgia ézéma ʒéyec; Yacma sucninaiguc nanna. Ʒéyu inéŋ yacma naŋec. ");
INSERT INTO kgf_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Naŋu Yesunéŋ yomuhuc énézéyec; Qesiénécmizua. Diminéŋ héna acwac séciguc? Sabata naléiguc haka hiabia wambiŋ me haka biria wambiŋ? Kekec imi mehiaruwiŋ me qehumuwiŋ? ");
INSERT INTO kgf_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Imuhuc ʒéma hénaoriŋ lelecgéma inicmaguc ic iwac mia yomuhuc ézéma ʒéyec; Méraga suluna. Imuhuc ʒéyu méria suluyu hiaruyec. ");
INSERT INTO kgf_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Imuhuc waŋu ieneŋ qerigina geric bélaŋanéŋ sécgé énécmiyu, Yesu dimuhuc wammiwiŋ ʒéma eminiŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Waŋu nalé imuaru Yesunéŋ ʒéwelec wammaŋ ʒéma baec boŋaiguc keremma siŋi herec séc tacma Anutu ʒéwelecmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Waŋu ama giaŋiyu tohotoho ichéra unuruma sucginaiguc 12 énépésima qacgina Yesuac Méliméli ic ʒéénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yesuac Méliméli ic ionac qacgina imi Simon (Petero ʒémimia, hénia imi ʒamanʒiŋ.) ʒéma iwac munia Anderea, waŋu Yakobo, Yohane, Filipo, Batolomaio, ");
INSERT INTO kgf_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio (qara méŋ Lewi), ʒéma Toma, Alfaioac naŋa Yakobo, Simon Ʒelote ʒémimia, ");
INSERT INTO kgf_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Waŋu Yakoboac naŋa Yuda, ʒéma Yuda Karioto, waŋu ic yominéŋ mia kecma Yesu andé qeyec. ");
INSERT INTO kgf_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Waŋu Yesunéŋ tohotoho ichéra iniguc baec boŋa igucnec mama baec kondoŋaiguc naŋec. Naŋu tohotoho ic tosara tuŋaguc ʒéma ic tuŋ kuneŋ yandanéŋ Yuda baec ama lelec lelec ʒéma Yerusalem ʒéma Tiro ʒéma Sidon ʒékéŋ yanda giŋgiŋa igucnec ");
INSERT INTO kgf_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ackuaʒéc nimbiŋ ʒé me hafigina mehiaru énécmimac niŋac hagic. Waŋu Yesunéŋ ic tosara uŋa ʒapi qeqeyanéŋ mebiri énécmiyu qenʒeŋ manʒeŋ qegic imi momacnec mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Waŋu Yesuarunec kuc yandanéŋ éréma icya icya mocʒoŋ mehiaru énécmidarec. Waŋu imuac niŋ ic embac mocʒoŋ méraginanéŋ Yesu osiwiŋ ʒé waŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesunéŋ kiwa hima tohotoho ichéra inicma yomuhuc ʒéyec; Anutuac héŋgaleŋ ama areŋa yanda imi ic maqeqeya onac buŋa, imuac niŋ, ic maqeqeya ini imi ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sécgé énécmimac, imuac niŋ deguc yaka niŋ humuzu ini imi ségiségi ginaguc. Ségiségi wamma desimu, imuac niŋ deguc siacma kecʒu ini imi ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Icac Naŋa iwac niŋac ic embac ieneŋ haʒéc waŋ énécmima elicgé énécmima ʒébiri énécmima onac qac buŋa imi biria ʒéma wai énécmimu nalé imuaru ini ségiségi ginaguc. ");
INSERT INTO kgf_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nalé imuaru imi ini ségiségi wamma ewa hia nimma legicgina hirimu. Héŋgic! Kurumeŋ amaiguc onaru bakia hiabia imi kuneŋ yanda he énécmimac. Haka biria imuhucya imi yandahécgina eneŋ Anutuac tiliŋ tiliŋ ic ionac acguc imuhuc waŋ énécmiaŋgic hénia imuac niŋac ini imuhuc wammuac hezac. ");
INSERT INTO kgf_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Saecginaguc, iwawai saméŋa heénécmimia ini. Ini imi bec ʒézé ségiségi he énécmidaru tecgézac. ");
INSERT INTO kgf_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Saecginaguc, deguc tomeŋgina qeanʒac ini. Ini imi Kecma yaka niŋ humumu. Saecginaguc, deguc desi yanda waŋanʒu ini. Ini imi kecma ewa biric yanda wamma siacmu. ");
INSERT INTO kgf_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ic embac mocʒoŋ ieneŋ onac ʒézé ségiségi waŋ énécmianʒu iguc, ini imi saecginaguc. Yanda hécgina ieneŋ Anutuac tiliŋ tiliŋ ic ikora ionac mia imuhuc waŋ énécmiaŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Waŋu gezacgina haima ninʒu onac ʒézua; Haʒécgina ala waŋ énécmigic. Waŋu ic tosara nimbiri énécmianʒu ionac haka hiabia waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Saecgé énécmianʒu imi onac mia mozocgé énécmimu. Waŋu gamu qeqe ac waŋ énécmianʒu ionac niŋac wamma ʒéwelec wammu. ");
INSERT INTO kgf_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Méŋnéŋ nekaŋga qeyu nekaŋga néwécgeŋa imi imuhucnec meleŋna qemac. Méŋnéŋ guac saŋgeŋa malekuga guagiru maleku qeriaiguc héihéiya imi acguc waimina. ");
INSERT INTO kgf_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Méŋnéŋ méŋ iwawai méŋ niŋac welec géŋu hia miwésémaŋ. Méŋnéŋ guac iwawaiga mema keŋu meleŋ nénna ménda ʒéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Waŋu haka hiabia méŋac méŋ alahécginanéŋ waŋ énécmimuac wanʒuiguc haka imuhucya imi eŋaoc walac waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ini ic tosara ala waŋ énécmianʒu ionac sac ala waŋ énécmianʒu iguc imi némac hiabianéŋ he énécmiwacnec? Képésic ic ieneŋ acguc ic tosara ala siŋ waŋ énécmianʒu ionac ala siŋ waŋ énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ic méŋnéŋ méŋ haka hiabia waŋ énécmianʒu ionac mia haka hiabia waŋ énécmianʒu iguc imi némac hiabianéŋ he énécmiwacnec? Képésic ic eneŋ acguc imuhuc waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ini bakia mewiŋ ʒé iwawai méŋ alahécgina méra mizuiguc imi némac hiabianéŋ he énécmiwacnec? Képésic ic ieneŋ acguc bakia séha mewiŋ ʒé niŋkumuma képésic ic méŋac méŋ méra énécmianʒu. ");
INSERT INTO kgf_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Imuac ini haʒéc hécgina ala waŋ énécmima goi héihéi waŋ énécmiwiŋ ʒé bakia niŋac ménda wamma eŋdac méra énécmimu. Imuhuc waŋanʒuiguc imi bakia héla yanda he énécmiyu, Eŋeŋa miŋinawac nambérac héra wammu. Inéŋ mia ewa hiawac énécmimia imi ménda niŋtegicanʒu ionac ʒéma kaiʒiliweŋ ic ionac imi, séc imuhucyanec goi héihéi waŋ énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Onac kurumeŋ Maŋgocnéŋ wéséséya niŋénécmianʒac imuac séciguc ini imuhucyanec wéségina niŋénécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ménda ʒégési énécmigic, ménda ʒégési énécmimia wammac. Képésicginaguc ménda ʒéénécmigic, képésic ginaguc ménda ʒéénécmimia wammac. Waŋu alahécgina ionac képésicgina wai énécmigic, eŋaŋ képésicgina imuhucyanec wai énécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Eŋ énécmigic, eŋ énécmimia wammac. Iwawai géséginaiguc tiyu, hiŋgacma kuaya qeyu, hélanʒima tima méndéŋu keŋha waŋu hiŋgaru, muŋguc tiyu kuaya qema mayu, onac énécmiyu tétécgéma memu. Eneŋ géségina tima énécmigic imuac sécyaiguc tima meleŋ énécmiyu memu. ");
INSERT INTO kgf_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Waŋu inéŋ muŋguc séséc ac wamma yomuhuc ʒéyec; Kic hilicnéŋ kic hilic méŋ hia hérémimac me? Imuhuc wammaciguc imi, éréhéc ekawu baec séséŋiguc ménda hiŋgacmaoc me? ");
INSERT INTO kgf_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tohotoho icnéŋ kiwi icya ménda ogicma kecʒac, néŋ méŋac méŋ kiwi icyanéŋ niniŋa mocʒoŋ didiŋanec kumiyu niŋareŋ gédacmaciguc, inéŋ mia kiwi icya éséc dac wamma kecmac. ");
INSERT INTO kgf_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Némac niŋac alagawa kiwaiguc goc héŋtegicma geŋgac kicgaiguc ic kembaŋa hezac imi ménda niŋtegicanʒaŋ me? ");
INSERT INTO kgf_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Gi imi guac kicga qeriaiguc ic kembaŋa hezac imi ménda héŋtegicma dimuhuc guac alagawac ʒéma Alana wainénna neŋ guac kicga qeriaiguc goc hezac imi memaŋ ʒéwésémaŋ me? Ic ikora gi walac guac kicga qeriaiguc ic kembaŋa hezac imi memaguc iwawai guac alagawac kiwa qeriaiguc hezac imi hiabianec hémma mewésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Némac niŋ? Ic hésa hiabia méŋnéŋ héla gocmia biria haimacac séc qahac. Waŋu ic hésa biria méŋnéŋ héla gocmia hiabia haimacac séc qahac, imuac mia imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ic hésa imi imuac héla gocmia hémma hénia héŋtegicanʒiŋ. Ic hésa waiyaguc imuarunec fik ic gocmia ménda mihicŋianʒiŋ. Waŋu saŋsaŋiguc waiŋ gocmia ménda mihicŋianʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ic embac eneŋ iwawai ewa qeriginaiguc qauqau haigic hezac imuacnec mema kuaginanéŋ ac ʒéanʒu, imuac niŋac ic hiabianéŋ ewa qeriaiguc niniŋ hiabia qauqau haigic hezac imuacnec mema ac hiabia ʒéhicŋianʒac. Waŋu ic birianéŋ niniŋ biria ewa qeriaiguc kuaya qema hezac imuacnec mema ac bira ʒéhicŋianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ini imi nuac niŋ Miŋ Kewu, Miŋ Kewu ʒénémmanec dimuhuc ac ʒéanʒua imi ménda tohoma waŋanʒu? ");
INSERT INTO kgf_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Méŋnéŋ méŋ nuaru hama nuac acna nimma tohoanʒu ieneŋ ic dimuhucya wanʒu imi séséc ac ʒéma énézéwa hémmu. ");
INSERT INTO kgf_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ic imuhucya imi ama memaŋ ʒé baec hiŋgac hiŋgarawac éséma baŋa mihicŋima imuac qahaiguc simeŋ haima mezac ésécnec. Doku yanda luma ama imi qeyec, néŋ hiabianec seligima naŋec imuac niŋ ménda mehiriyec. ");
INSERT INTO kgf_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Waŋu nimma ménda tohoanʒac inéŋ baec bébélacgia baŋa qahac imuaru amaya meyec ésécnec. Doku yandanéŋ luma qeyu ama imi focdac ʒéŋgéma kuneŋ yanda biriyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesunéŋ ackuaʒéc imuhuc mocʒoŋ énézéyu gezacginanéŋ niŋgic tecgéyu, Kafanaum ama areŋa yandaiguc kereŋec. ");
INSERT INTO kgf_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Imuaru téŋgiŋ ic 100 ionac galeŋgina méŋac weleŋ qeqe ic héŋ soroc wammimia méŋnéŋ hafi kiyu humumaŋ ʒé waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Waŋu galeŋ iminéŋ Yesuac suruc nimma Yesunéŋ hama weleŋ qeqe icya imi mehiaru mimac niŋ qesimimu niŋac Yuda ic ionac galeŋ tosara méli énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Méli énécmiyu kemma Yesuaru qeriginanéŋ mocʒoŋ yomuhuc welecmigic; Galeŋ imi ara niŋmiwésémaŋac séc ic héla kecanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Inéŋ Yuda ic nonac ala siŋ waŋ nénécmima tocgotocgo amanina menénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Imuhuc ʒégic Yesunéŋ iniguc momacnec keŋec. Kemma ama imi lakec qahac ʒézéyawac séc keŋkeru, téŋgiŋ ic 100 ionac galeŋginanéŋ alahéra Yesuaru méli énécmima ac yomuhuc haiyec; Miŋ Kewu, gi ai yanda ménda mewésémaŋ. Ni dac imuhucya nuac ama baeŋanéŋ logi gémmacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni nena niŋ nimba ménda sécgéyu guaru hamaŋ ʒé osizua. Imuac niŋ gi imuaru kecma eŋ ʒéna weleŋ qeqe icna imi hiarumac. ");
INSERT INTO kgf_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ni ic eŋeŋana ionac méra bacginaiguc kecanʒua. Waŋu nuac bacnaiguc imuhucyanec téŋgiŋ ic hécna kecanʒu. Waŋu neŋ méŋac kenna ʒéwa keŋu, méŋac hana ʒéwa haanʒac. Waŋu weleŋ qeqe icnawac, ai yomi mena ʒéwa meanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ara imuhuc ʒégic nimma Yesunéŋ welicgéma ic tuŋ méndacmigic ionac muru liliŋgéma yomuhuc énézéyec; Ni énézéwa niŋgic, Israel ic onarunec ninʒéŋ ninʒéŋ séha imuhucya méŋ ménda mihicŋiyi. ");
INSERT INTO kgf_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Waŋu méli énécmiyu hagic ieneŋ liliŋgéma amaiguc kemma héŋgic weleŋ qeqe ic inéŋ hiaruma séwiya hia kerec. ");
INSERT INTO kgf_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kecma Yesunéŋ tauŋ méŋ qara Nain imuaru keŋu tohotoho ichéra ʒéma ic tuŋ yandanéŋ méndacmima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Waŋu tauŋ imuac saŋgulaŋa hosuraiguc kereŋu qamoc méŋ huama magic. Waŋu humuyec imi embac malé méŋac naŋa. Naŋa imi momacguc sac kerec. Waŋu tauŋ imuac ic embac sasalanéŋ embac malé i guc momacnec magic. ");
INSERT INTO kgf_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Waŋu Miŋ Kewunéŋ embac malé imi hémma ewaya biriyu ʒéyec; Ménda siacna. ");
INSERT INTO kgf_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Imuhuc ʒéma hosuru kemma katapa osiyu ic wagicma keŋkecgic ieneŋ bénʒéŋ ʒikima naŋgic yomuhuc ʒéyec; Merac ni gézézua, yacna. ");
INSERT INTO kgf_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Imuhuc ézéyu humuc ic iminéŋ yacma acac hénima ʒéyec. Waŋu Yesunéŋ i neŋgocya miyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Waŋu ic eneŋ mocʒoŋ imi hémma ʒénéŋgina hiriyu Anutu mepésima yomuhuc ʒégic; Anutuac tiliŋ tiliŋ ic kuneŋ yanda méŋnéŋ sucninaiguc hicŋiyecac kecʒac. Tosara eneŋ ʒégic; Anutunéŋ ichéra niŋnénécmima hazac. ");
INSERT INTO kgf_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Waŋu Yesuac surucya iminéŋ Yuda baec séc ʒéma baec néwéc néwéc saima kendarec. ");
INSERT INTO kgf_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yohanenéŋ hésa amaiguc tackeru iwac tohotoho ichéra eneŋ haka hicŋiyec imi mocʒoŋ ézédacgic. Waŋu ac imi nimma tohotoho ic éréhéc héihéré érécmima ");
INSERT INTO kgf_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Miŋ Kewu yomuhuc ʒéma qesimimaoc niŋ méli érécmiyec; Ha nénécmimac niŋ ʒézéya imi gi mia me méŋac mambéc kecbiŋ? ");
INSERT INTO kgf_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Waŋu iereŋ Yesuaru kemma ʒéyoc; Doku naec haka ic Yohane yomuhuc ʒéma méli nérécmizac; Hanénécmimac niŋ ʒézéya imi gi mia me méŋac mambéc kecbiŋ? ");
INSERT INTO kgf_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Waŋu nalé idacmuaru Yesu imi ic hafi ʒepaginaguc ʒéma ic uŋa biriaguc imi sasala mehiaru énécmima kic hilic sasala imi kichihi meénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Waŋu imuhuc qesiyic yomuhuc melemma érézéyec; Iri kemma iwawai hémma niŋanʒaoc imuac suruc Yohane wammima yomuhuc ézémaoc; Kic hilicnéŋ kicgina hima héŋanʒu, puriŋ eneŋ héna kenʒu, wizi seliginaguc imi solaŋanima kecʒu, gezacgina héhéŋgia ieneŋ gezacginanéŋ ninʒu, humuc ic eneŋ ɋelima yacʒu, waŋu maqeqeya ionac buŋa suruc hiabia imi énézézac. ");
INSERT INTO kgf_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Waŋu méŋnéŋ méŋ nuac niŋ niŋ éréhécguc ménda qonʒoŋ toŋgézac imi ségiségiyaguc. ");
INSERT INTO kgf_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Imuhuc ʒéyu Yohaneac kua meme ichéréra iereŋ liliŋgéma keŋoc. Keŋic Yesunéŋ Yohaneac ʒéma yomuhuc énézéyec; Ini baec kisiaiguc némac iwawai hémbiŋ ʒé keŋgic? Uŋ méŋ luhucnéŋ qeyu hirima naŋu hémmu niŋac keŋgic? ");
INSERT INTO kgf_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Imi qahac waŋu némac iwawai hémbiŋ ʒé keŋgic? Ic méŋ malekuya hiabia héima kecʒac imuac hémbiŋ ʒé keŋgic? Qahac, ic maleku hiabia héima iwawaigina hiabia sasala késa kecanʒu imi eneŋ ama kewuyaiguc kecanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Waŋu imi qahac waŋu, némac iwawai hémbiŋ ʒé keŋgic? Anutuac tiliŋ tiliŋ ic méŋac me? O, imi hélacnec! Énézéwa niŋgic; Ic imi kua meme ic onogicdacma séc méŋ wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iwac mia ac kiwi méŋ yomuhuc oyec hezac; Héŋgic, ni kua meme icna méŋ méliwa walac kemma hénaga mindiŋimac. ");
INSERT INTO kgf_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Énézéwa niŋgic; Embac igucnec hicŋihicŋiya tosara yanda ionarunec méŋnéŋ méŋ Yohane ménda ogicʒac, néŋ Anutuac héŋgaleŋ ama areŋa yanda qeriaiguc mamayagina méŋnéŋ Yohane i hia ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ic momac yanda ʒéma takis meme ic ieneŋ Yohaneac doku naecgic imuac niŋac ackuaʒéc imi nimma Anutu imi solaŋa ʒéma ʒéaugic. ");
INSERT INTO kgf_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Waŋu Farisaio ic ʒéma héna acac kiwi ic ieneŋ sac Yohaneac doku ménda naecma Anutuac ewa siŋ eŋaŋ niŋac heyec imuac héŋara megic. ");
INSERT INTO kgf_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesunéŋ toroqema ʒéyec; Nalé yomuac hicŋisai imi iwawai némaciguc séc héimaŋ? Ieneŋ dimuhucya ésécnec ʒémaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Imi nambérac tosara nénnagémba sombeŋiguc aria meanʒu ésécnec. Nambérac ieneŋ sombeŋ imuaru tacma ac yomuhuc ʒékeŋ ʒéha waŋanʒu. Nini onac niŋac kuŋa héiénécmini ini legic ménda hirizu, nini soŋgoŋac legic héini ini ménda ʒésiac wanʒu! ");
INSERT INTO kgf_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hénia imi yomuhuc; Doku naec haka ic Yohanenéŋ hama nene ménda nema ʒéwelecma waiŋ doku ménda neyu, eneŋ hémma uŋa birianéŋ késazac ʒégic. ");
INSERT INTO kgf_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Waŋu Icac Naŋanéŋ hama nene nema waiŋ doku neyu, eneŋ yomuhuc ʒéanʒu; Héŋgic inéŋ hémbaoc wamma nene nema doku selia siŋa nimma nema takis meme ic ʒéma biria meme ic ionac alagina kecʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Waŋu niŋtegic qiŋtegic imi imuac nambérac héra ieneŋ méndacma wamma hénia solaŋa mewininianʒu. ");
INSERT INTO kgf_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisaio ic méŋnéŋ eŋeyaguc nene nemac niŋac Yesu héihéré miyu Yesunéŋ iwac amaiguc emma nene nema tarec. ");
INSERT INTO kgf_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tackeru ama areŋa yanda imuaru biria meme embac méŋ kerec inéŋ Yesunéŋ Farisaio ic iwac amaiguc emma tarec imi nimma alabasita kiruŋ halécyaguc imi mema hama éréyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Éréma Yesu hénaya suluma tackeru iwac qéhéréŋaiguc hénaya haiyec imuhucgeŋ namma siarec. Siacma tacma eŋeya kic masinéŋ hénaya naecmima oruc ʒucyanéŋ kereŋ meyu ʒicgéyu kuayanéŋ hénaya kiricne mima haléc héméŋa hiabia imi imuac qahaiguc qocgémiyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Qocgéyu Farisaio ic Yesu héihéré miyec inéŋ hémma qerianéŋ yomuhuc niŋec; Ic yominéŋ Anutuac tiliŋ tiliŋ ic kecbacnec eŋeya hénia osizac embac imi biria meme embac imuac niŋ embac imi mérénéŋ me dimuhucya imi niŋ tegicbacnec. ");
INSERT INTO kgf_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Imuhuc niŋu, Yesunéŋ imi niŋtegicma yomuhuc melemma ʒéyec; Simon, neŋ ac méŋ ʒémaŋac ninʒua. Ʒéyu ʒéyec; Kiwi ic, hia ʒéna nimba. ");
INSERT INTO kgf_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ʒéyu Yesunéŋ yomuhuc ʒéyec; Ic éréhécnéŋ soukiwa ic méŋac murunec soukiwa meyic méŋac muru tasia yawuŋ momacguc ʒéma maso éréhéc imuac ai boŋa séc hemiyu, méŋac muru tasia maso éréhéc imuac ai boŋa séc hemiyec. ");
INSERT INTO kgf_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Waŋu ic éréhéc ekaoc taségira meleŋ mimaocac séc qahac waŋu soukiwa ic iminéŋ tasé iorac muru hezac imi mocʒoŋ auérécmiyec. Waŋu sucgiraiguc mérénéŋ iwac siŋ kuneŋnec ogicma nimmimac? ");
INSERT INTO kgf_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Imuhuc qesiyu Simonnéŋ melemma yomuhuc ʒéyec; Neŋ nimba taséya kuneŋnec aumimia waŋec inéŋ mia siŋ kuneŋnec nimmimac. Ʒéyu ʒéyec; Gi dindiŋanec niŋgésizaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Imuhuc ʒéma embacac muru liliŋgéma Simon yomuhuc ézéyec; Embac yomi hénʒaŋ? Neŋ amagaiguc éréwa geŋ hénana ʒuacmaŋac doku méŋ ménda nénʒaŋ. Néŋ embac yominéŋ eŋeya kic masinéŋ hénana naecnémma oruc ʒucyanéŋ kereŋ menénʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Geŋ ménda kiricne menénʒaŋ, néŋ embac yominéŋ éréwa imuarunec hénima hénana kiric nemanec kecʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Geŋ orucnaiguc oliwa halécdac méŋ ménda naecnénʒaŋ, néŋ embac yominéŋ haléc héméŋaguc alabasitanéŋ hénanaiguc naecnénʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hénia imuac niŋ neŋ gézéwa ninna; Embac yominéŋ siŋ kuneŋ yanda hemizac imuac niŋ képésicya kuneŋ yanda aumimia wanʒac, néŋ képésic komodia dac aumimia wanʒac inéŋ siŋ komodia hemizac. ");
INSERT INTO kgf_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Imuhuc ʒéma embac imi yomuhuc ézéyec; Embac, képésicga waigéŋgéŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Imuhuc ʒéyu ic momacnec nene nema tacgic eneŋ qeriginaiguc yomuhuc niŋgic; Yomi némac icnéŋ képésicya waizac? ");
INSERT INTO kgf_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Waŋu Yesunéŋ embac yomuhuc ézéyec; Ninʒéŋ ninʒéŋ guac muru hezac iminéŋ gi aŋgéŋga tigénʒac imuac luaeiguc kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Imuac andiaiguc Yesunéŋ ama areŋ yanda yanda ʒéma ama areŋa areŋa lelecgéma Anutuac héŋgaleŋ ama areŋa yandawac buŋa suruc hiabia imi ʒéau énécmiyu tohotoho ichéra 12 ieneŋ momacnec keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Waŋu embac tosara Yesunéŋ uŋa biria nesi énécmima hafigina mehiaru énécmiyec ");
INSERT INTO kgf_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","imi eneŋ iniguc momacnec kemma eŋaŋ iwawaigina mema weleŋ qeénécmigic. Qacgina imi yomuhuc; Makdala embac Maria, Yesunéŋ becnec iwac murunec uŋa biria 7 nesi énécmiyec imi ʒéma Herodeac soukiwa galeŋ ic Kuʒa iwac iniŋa Yoana ʒéma Susana ʒéma embac tosara sasala. ");
INSERT INTO kgf_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ama areŋa yanda igucnec séc ic embac eneŋ tocgéma Yesuac muru hagic tuŋ yanda waŋu, Yesunéŋ séséc ac yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ai ic méŋnéŋ iwawai gocmia qesamaŋ ʒé keŋec. Kemma qesayu gocmia tosara imi héna ʒécgériaiguc mama héiyec. Héiyu tosara ic embac ieneŋ tigic biriyec. Tosara nei ieneŋ hama nedacgic ");
INSERT INTO kgf_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tosaranéŋ baŋa qahaiguc mama héiyec. Héiyu qérawia éréyec, néŋ dokuya qahac waŋu sélécgédarec. ");
INSERT INTO kgf_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Waŋu gocmia tosaranéŋ hésa waiyaguc sasala imuac qeriaiguc mama héiyec. Héiyu hésa waiyagucnéŋ momacnec yandima héʒicgégic. ");
INSERT INTO kgf_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Waŋu gocmia tosaranéŋ baec halécyaguc imuaru mama héiyec. Héiyu qérawia éréma 100 mesaiyec. Yesunéŋ ac imi ʒémaguc qacma yomuhuc ʒéyec; Gezacginaguc ieneŋ nimmu. ");
INSERT INTO kgf_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tohotoho ichéra eneŋ sésécac imuac hénia imi dimuhuc wammac ʒéma qesimigic. ");
INSERT INTO kgf_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Qesimigic ʒéyec; Onac imi wai énécmiyu Anutuac héŋgaleŋ ama areŋa yandawac hénia sasaŋgia imi hia niŋasarimuac hezac. Waŋu tosara ionac imi imuhuc qahac; Hémmu, néŋ hia ménda héŋtegicmu. Waŋu nimmu, néŋ hia ménda niŋtegicmuac niŋ qeqaiŋ aciguc énézéanʒua. ");
INSERT INTO kgf_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Séséc ac imuac hénia imi yomuhuc; Gocmia imi Anutuac ackuaʒéc. ");
INSERT INTO kgf_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Gocmia héna ʒécgériaiguc mama héiyec imi ic embac tosara ackuaʒéc niŋgic Biria miŋinanéŋ hama ic imi eneŋ ninʒéŋgégic aŋgéŋ tiénécmiwac niŋac ackuaʒéc imi qerigina igucnec onagicanʒac imuac sécya. ");
INSERT INTO kgf_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Gocmia tosara baŋa qahaiguc héizac imi ic embac tosara ackuaʒéc imi nimma ségiségi wamma késagic. Waŋu ʒalia ménda hiŋgac késayacgéyu nalé dahecac séc ninʒéŋgéma kecgic manam batuciguc onoporu waima keŋanʒu imuac sécya. ");
INSERT INTO kgf_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Gocmia tosara hésa waiyaguc imuac qeriaiguc mama héiyec imuhucyanéŋ ackuaʒéc ninʒu waŋu baecac niŋyéwéria me hinac yanda me séwiac siŋanéŋ héʒicgéyu ninʒéŋ ninʒéŋgina séha ménda yandianʒac imuac sécya. ");
INSERT INTO kgf_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Waŋu gocmia tosara baec halécyaguc imuaru héiyec imi ic embac tosara ewa héla ʒéma ewa hiabia kecma ackuaʒéc nimma selianec késama seliseli wamma héla haianʒu imuac sécya. ");
INSERT INTO kgf_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Méŋnéŋ méŋ lambe otorima kewucnéŋ ménda hoturumac me duŋ tatac bawu ménda haimac, néŋ ic embac ama qeriaiguc érému eneŋ asaha imi hémmuac wamma ʒae qahaiguc haianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Iwawai saŋa imi mocʒoŋ auyu hémmacac séc waŋu iwawai sasaŋgiaiguc hezac imi mocʒoŋ meyu wininimacac séc. ");
INSERT INTO kgf_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Imuac ini gezacginanéŋ dimuhuc niŋanʒu haka imuac héŋgésimu. Méŋnéŋ méŋ ackuaʒéc késakecʒac imi toroqemimia wammac. Waŋu méŋnéŋ méŋ ackuaʒéc ménda késakecʒac imi iwawai henénʒac ʒéma ninʒac imi momacnec wagiru qahac wandacmac. ");
INSERT INTO kgf_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesuac neŋgoc munahéra ieneŋ hagic. Waŋu ic embac tuŋ yanda niŋac hosuraiguc kembiŋac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Waŋu ic méŋnéŋ Yesu yomuhuc ézéyec; Guac neŋgoc munahécga ieneŋ gémbiŋ ʒé hama séŋgaŋgeŋ nanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ʒéyu Yesunéŋ melemma ʒéyec; Anutuac ackuaʒéc nimma tohoma séciguc kecanʒu youmi eneŋ mia nuac neŋgoc muna hécna wanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kaiwe méŋu Yesunéŋ tohotoho ichéra iniguc ʒéiciguc emma yomuhuc énézéyec; Doku ʒékéŋ néwécgeŋac kenni. Ʒéyu ieneŋ eŋawu ʒéic nesima hénima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kemma kecgic Yesu gauya heyec. Heyu nalé imuaru luhuc yandanéŋ konduŋ imuaru mama qeyu doku temboŋnéŋ éréma ʒéic qeriaiguc hiŋgaru ʒéicnéŋ konduŋiguc hiŋgacmaŋ ʒé waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yesuac tohotoho ic tosaranéŋ Yesuac muru kemma yomuhuc ʒéma mindigic; Galeŋnina, galeŋnina, nini humuqai wambiŋ niŋac. Ʒégic Yesunéŋ gau igucnec yacma luhuc ʒéma konduŋ temboŋ ʒéqetali érécmiyu néŋ qema heyoc. ");
INSERT INTO kgf_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Heyic tohotoho ichéra ionac yomuhuc énézéyec; Ninʒéŋ ninʒéŋgina dimia? Imuhuc ʒéyu ʒénéŋgina hiriyu welicgéma eŋaocnec eminimma ʒégic; Ic yomi méré waŋu, luhuc ʒéma doku ac érézéyu ara tohozaoc? ");
INSERT INTO kgf_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ieneŋ nesima kemma Galilaia doku qericma néwécgeŋaciguc Gerasa baeciguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Keremma Yesunéŋ imuacnec mama élélahu eŋu ama areŋa yanda imuac miŋina ic kuwiraguc méŋnéŋ hama Yesu mihicŋiyec. Waŋu ic iminéŋ nalé horua owo maleku ménda héima ama gericiguc ménda kecma kic suaŋ sucginaiguc heaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Inéŋ Yesu hémma qacma iwac wésiaiguc mama sicgéma kucnec qacma yomuhuc ʒéyec; Eŋeŋa miŋina Anutuac Naŋa Yesu, gi ʒéma ni nekac nekac, welecgénʒua, yéwéri ménda menémbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ac imi mia Yesunéŋ i hémma uŋa birianéŋ iwarunec éréma kemmac niŋac bec ézéyu nimma ara imuhuc melemma ʒéyec. Ic imi uŋa ʒapi qeqeyanéŋ hatac sasala késayu seŋ hésanéŋ hénia ɋatémima galeŋgégic, néŋ qericma uŋa birianéŋ hérémigic séc baec kisiaiguc kemma lelecgéaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Imuhuc ʒéyu Yesunéŋ qesimima ʒéyec; Gi qacga méré? Qesimiyu ʒéyec; Tuŋ yanda. Imi mia iwac qeriaiguc uŋa biria sasalanéŋ hiŋgacma kecgic imuac niŋ imuhuc ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Imuhuc ʒéma Yesunéŋ uŋa biria ionac baec dumuŋaiguc ménda nesi énécmiyu hiŋgacmu niŋac welecmigic. ");
INSERT INTO kgf_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Waŋu baec boŋa imuaru beric sasalanéŋ gété kulumma kecgic uŋa biria eneŋ wai énécmiyu beric ionac qeriginaiguc hiŋgacmu niŋac welecmigic niŋénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Niŋénécmiyu uŋa biria ieneŋ ic iwarunec éréma kemma beric qeriginaiguc hiŋgacgic beric tuŋ yanda ieneŋ usuŋnec kemma sia yanda igucnec hiŋgacma dokuiguc hiŋgacgic dokunéŋ hoturu énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ic tosara beric galeŋgéma kecgic ieneŋ haka hicŋiyec imi hémma focdac néŋgacma ama areŋa yanda ʒéma ai ama leleclelec heyec imuaru kemma ac suruc imi énézégic. ");
INSERT INTO kgf_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ʒégic nimma ic embac ieneŋ haka hicŋiyec imi hémbiŋ ʒéma Yesuac muru hagic. Hama héŋgic ic uŋa biria ieneŋ éréma kendacgic ic iminéŋ Yesuac héniaiguc malekuya héima solaŋanec wamma bénʒéŋ tackeru ʒénéŋgina hiriyec. ");
INSERT INTO kgf_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ic uŋa biriaguc kerec iminéŋ dimuhuc hiaruyec imi héŋgic imi eneŋ tosara suruc énézégic niŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Énézégic nimma Gerasa baec imuac miŋina ieneŋ ʒénéŋgina kuneŋ yanda hiriyu wai énécmima kemmac niŋac Yesu welecmigic. Inéŋ ʒéiciguc emma baec imi waima keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Waŋu ic uŋa biria waimima keŋec inéŋ Yesuguc kecmaŋ ʒé welecmiyec, néŋ Yesu imi yomuhuc ézéma mélimiyec; ");
INSERT INTO kgf_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Gi amagaiguc liliŋgéma kemma Anutunéŋ guac muru haka kuneŋ yanda dimuhucya waŋgénʒac imuac suruc imi énézéwésémaŋ. Imuhuc ʒéyu ic iminéŋ waima kemma Yesunéŋ némac iwawai wammiyec imuac suruc imi ama areŋa yanda séc lelecgéma énézédarec. ");
INSERT INTO kgf_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Waŋu Yesunéŋ doku néwéc liliŋgéma hayu ic embac tuŋ yandanéŋ Yesuac mambéc kecgic imuac niŋac ʒézé ségiségi wammima hérémigic. ");
INSERT INTO kgf_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Waŋu héŋgic, ic méŋ qara Yairo ʒémimia inéŋ hayec. Ic imi mia tocgotocgo ama méŋac galeŋ kerec. ");
INSERT INTO kgf_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Waŋu iwac muru bérara embac seraŋa momacguc sac kerec. Embac imi yawuŋa 12 waŋec. Waŋu inéŋ hafi kiyu humumaŋ ʒé waŋec. Imuac niŋac ic iminéŋ hama Yesuac héniaiguc sicgémima eŋeya amaiguc hamac niŋac welecmiyec. Weleru Yesunéŋ amayaiguc keŋu ic embac tuŋ yandanéŋ lelecgémima momacnec keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Keŋkecgic sucginaiguc embac méŋ kerec inéŋ yawuŋ 12 imuac séc sacya mayu hafi wamma kecaŋec. Waŋu inéŋ soukiwa iwawaiya késakerec imi mocʒoŋ séwi galeŋ ic énécmima audarec, néŋ méŋnéŋ méŋ mehiaru mimacac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Waŋu inéŋ Yesuac andiaiguc hosuru kemma malekuya susuriaiguc osiyec. Osiyu imuarunec sac maaŋec imi ʒicgéyec. ");
INSERT INTO kgf_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Waŋu Yesunéŋ qesima mérénéŋ nosizac ʒéma ʒéyec. Waŋu mocʒoŋ qaecgégic, Peteronéŋ yomuhuc ézéyec; Miŋ Kewunina, tuŋ yandanéŋ lelecgéma qéfacgé génʒu. ");
INSERT INTO kgf_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ʒégic Yesunéŋ melemma ʒéyec; Méŋnéŋ nosiyu kucnanéŋ éréma ai meyu ninʒua. ");
INSERT INTO kgf_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Imuhuc ʒéyu embacnéŋ qaecgémacac séc qahac waŋec imi niŋasarima bac yandi yandi wamma hama mama sicgéma hénia némac niŋ osiyec imi ʒéauma, osiyu hafiya imuarunec bec tecgéyec imi ic embac mocʒoŋ kicginaiguc ézédarec. ");
INSERT INTO kgf_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Imuhuc ʒéyu Yesunéŋ ézéyec; Béracna, geŋga ninʒéŋ ninʒéŋganéŋ mehiaru génʒac. Imuac gi ewaga luae waŋu bénʒéŋ kembésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Imuhuc ʒémanec naŋu tocgotocgo amawac galeŋ iwac amaya igucnec ic méŋnéŋ hama Yairo yomuhuc ézéyec; Guac béracga bec humuzac imuac niŋ kiwi ic yéwéri ménda miwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Imuhuc ʒéyu Yesunéŋ nimma yomuhuc ézéyec; Ʒénéŋga ménda hirimac. Waŋu ninʒéŋgéna béracga imi hiarumac. ");
INSERT INTO kgf_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Imuhuc ʒéma iwac amaiguc kemma ic embac tosara qetali énécmima Petero, Yohane, Yakobo ʒéma embac seraŋa iwac neŋgoc maŋgocya sac onagiru eŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Eŋgic ic embac ieneŋ embac merac iwac niŋ wamma ʒésiac yanda wamma qeweloŋ waŋgic Yesunéŋ énézéyec; Ménda siacgic embac merac yomi ménda humuzac, néŋ gauya hezac. ");
INSERT INTO kgf_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Imuhuc ʒéyu bec humuzac imi niŋtegicgic imuac niŋ ʒédesi wammigic. ");
INSERT INTO kgf_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Waŋu Yesunéŋ embac merac iwac mériaiguc késama qacma ʒéyec; Meracna yacma nanna. ");
INSERT INTO kgf_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Imuhuc ʒéyu uŋayanéŋ liliŋgéyu imuarunec yacma naŋec. Naŋu nene mimu niŋac énézéyec. ");
INSERT INTO kgf_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Waŋu neŋgoc maŋgocyanéŋ hémma welicgéyoc. Welicgéyic Yesunéŋ haka hicŋiyec imi méŋac méŋ ménda ʒému niŋac neuŋ héiérécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesunéŋ tohotoho ichéra 12 unuruma uŋa biria mocʒoŋ nesi énécmima hafi mehiaru énécmimu niŋac kuc buŋa ʒéma qac buŋa énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Anutuac héŋgaleŋ ama areŋa yanda imuac énézéma hafi ʒepa wanʒu imi mehiaru énécmimu niŋac méli énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Waŋu méli énécmima yomuhuc énézéyec; Ini keŋha wambiŋ ʒéma iwawai yomuhucya méŋ ménda mema eŋdac kemmu, tac me gésé me héna mauŋ me soukiwa me maleku saméŋa imuhucya. ");
INSERT INTO kgf_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kemma ama geric méŋiguc emmuiguc imuaru tacyac waŋkecmu, waŋu baec méŋu kembiŋ ʒémaguc ama geric imi waimu. ");
INSERT INTO kgf_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ic embac eneŋ ménda héihéré énécmimuiguc tauŋ imi waima kemmu. Waŋu waima kembiŋ ʒé imuaru héna usuginaiguc seitotoŋ tacmac imi qegic mamac. Waŋu ieneŋ hakagina imi hémma imuac hénia imi niŋasarimu. ");
INSERT INTO kgf_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Imuhuc ʒéyu tohotoho ic ieneŋ kemma ama areŋ yanda yanda lelecgéma ama areŋ séc buŋa suruc hiabia imi énézéma hafi ic embac mehiaru énécmigic. ");
INSERT INTO kgf_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Waŋu haka méréra imi hémma ic embac tosaranéŋ Yohanenéŋ humuc igucnec ɋelima yarec, imuac niŋ kuha imuhucya wininizac ʒégic. Imuac niŋ Perea baec galeŋ Herodenéŋ iwawai imi mocʒoŋ nimma nimbipiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Waŋu tosara imi Elianéŋ muŋguc wininima kecʒac ʒégic, néŋ tosara imi Anutuac tiliŋ tiliŋ ic walaha ionarunec méŋnéŋ humuc igucnec ɋelima yarec imuhuc ʒégic. ");
INSERT INTO kgf_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodenéŋ ʒéyec; Yohane imi becnec neŋ déméŋa qeriri. Waŋu suruc imuhucya imuhucya imi mérac niŋac ʒéma imuhuc ʒéanʒu? Imuhuc ʒéma Yesu imi hémmaŋ ʒé waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Waŋu Yesuac Méliméli ic ieneŋ liliŋgéma hama ai megic imuac suruc mocʒoŋ Yesu ézégic. Yesunéŋ suruc imi nimma onagicma eŋawu baec imi waima Betsaida ama areŋa yandaiguc keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Waŋu ic embac ieneŋ niŋtegicma méndac énécmima hagic. Hagic Yesunéŋ unuruma Anutuac héŋgaleŋ ama areŋa yandawac ackuaʒéc énézéyec. Waŋu hafigina qahac wammac niŋac waŋgic mehiaru énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kaiwe kiwa hiŋgacmaŋ ʒé waŋu Yesuac Méliméli ic 12 ieneŋ Yesuac muru hama ézégic; Nini you baec kisiaiguc kecʒiŋ imuac niŋ ic embac méli énécmina ama areŋa me ama komoc komoc lelec lelec hezac imuaru kemma nenegina ʒéma hehe duŋ tatacgina mihicŋimu. ");
INSERT INTO kgf_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Imuhuc ʒégic acgina yomuhuc melemma ʒéyec; Eŋaoc nene gumu énécmigic nemu. Ʒéyu ʒégic; Nini kemma ic embac ionac nene boŋ ménda mewiŋiguc nonaru imi saméŋ méra méŋ ʒéma lambéc éréhéc sac he nénécmizac. ");
INSERT INTO kgf_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Imi mia sucginaiguc ic ionacnec ʒaŋgégina oloŋgic 5,000 imuac séc waŋec imuac niŋ imuhuc ʒégic. Waŋu Yesunéŋ 50 imuac séc tuŋa tuŋa nene newiŋ ʒé tacmu niŋac tohotoho ichéra énézéyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Énézéyu ʒéyec séc waŋgic ic embac mocʒoŋ nene newiŋ ʒé tacdacgic. ");
INSERT INTO kgf_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Waŋu Yesunéŋ saméŋ méra méŋ ʒéma lambéc éréhéc imi mema kiwa hiyu eŋu mozoc ac ʒéma mésémma ic embac ionac wéséginaiguc hai énécmimu niŋac tohotoho ichéra énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Waŋu hai énécmigic mocʒoŋ negic sécgé énécmiyec. Waŋu tohotoho ic ieneŋ bororoŋa waigic heyec imi tocgégic neŋgeŋ yanda 12 kuagina qedarec. ");
INSERT INTO kgf_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nalé méŋiguc Yesunéŋ sasaŋgiaiguc kecma ʒéwelec waŋu tohotoho ichéra i guc momacnec kecgic. Waŋu inéŋ yomuhuc qesiénécmiyec; Ic embac ieneŋ nuac niŋ méré ʒéanʒu? ");
INSERT INTO kgf_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ʒéyu melemma ʒégic; Tosaranéŋ doku naec haka ic Yohane ʒéanʒu, waŋu tosaranéŋ Elia ʒéanʒu, waŋu tosaranéŋ Anutuac tiliŋ tiliŋ ic wahala becnec kecgic sucgina igucnec méŋnéŋ liliŋgéma hicŋizac imuhuc ʒéanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ʒégic ʒéyec; Waŋu eŋaoc imi nuac niŋ méré ʒéanʒu? Ʒéyu Peteronéŋ ara melemma ʒéyec; Anutuac Kristo. ");
INSERT INTO kgf_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Imuhuc ʒéyu ac imi ic méŋac méŋ ménda énézému niŋac neuŋ héiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Waŋu toroqema ʒéyec; Icac Naŋanéŋ qenʒeŋ manʒeŋ sasala nimma qeriawac galeŋ ʒéma hofac oo ic kiwa hécgina ʒéma héna acac kiwi ic ieneŋ waimigic qegic humumac. Waŋu ai meme haréwéc waŋu tinduc ɋelima yacmacac hezac. ");
INSERT INTO kgf_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Imuhuc ʒémaguc Yesunéŋ ic embac mocʒoŋ ionac yomuhuc énézéyec; Ic méŋnéŋ ni méndac némmaŋ ʒémaciguc eŋeya memaamuma naléya naléya eŋeya ic héŋgeŋa wéndara imi huama méndac némmac. ");
INSERT INTO kgf_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ic méŋnéŋ méŋ kekecya aŋgé timaŋ ʒé waŋu kekecya imi sohomac. Waŋu ic méŋnéŋ méŋ nuac niŋ wamma kekecya waimaciguc kekecya aŋgé timac. ");
INSERT INTO kgf_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ic méŋnéŋ baec imi mocʒoŋ aŋgé timaguc eŋeya kekecya sohomac me wagiru qahac waŋu, iwawai iminéŋ dimuhuc naŋgémimac? ");
INSERT INTO kgf_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Méŋnéŋ méŋ ni ʒéma nuac ackuaʒécna niŋac gamuya nimmaciguc Icac Naŋa imi Maŋgoc ʒéma kua meme uŋahéra téréya ʒéma eŋeya edamuyaiguc liliŋgéma hamac nalé imuaru imuhucyanec ic iwac niŋ mia gamuya nimmac. ");
INSERT INTO kgf_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ni hélacnec énézéwa niŋgic, you nanʒu onarunec tosara ini humucnéŋ ménda énépésiyu Anutuac héŋgaleŋ ama areŋa yanda imi hémmu. ");
INSERT INTO kgf_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ac imi ʒéyec imuac andiaiguc ai meme 8 waŋu Yesunéŋ Petero ʒéma Yohane ʒéma Yakobo onagicma ʒéwelecmaŋ ʒé baec boŋaiguc eŋec. ");
INSERT INTO kgf_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Inéŋ ʒéwelecma kerunec séwiyanéŋ melemma tanera méŋ waŋu malekuya melemma pilitic asaha ésécnec asariyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Imuaru mia ic éréhécnéŋ Yesuguc ac eminimma naŋgic. Imi mia Mose ʒéma Elia. ");
INSERT INTO kgf_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Asac mararaŋiguc hicŋiyic eŋawu kecma Yesunéŋ Yerusalemiguc humumac imuac ara eminiŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Waŋu Petero ʒéma i guc momacnec kecgic ieneŋ gau réwéria niŋ qeka meka wamma tacgicac mocʒoŋnec yacma Yesuac edamuya ʒéma ic éréhécnéŋ i guc naŋgic imi inicgic. ");
INSERT INTO kgf_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Waŋu ic éréhécnéŋ waima keŋic Peteronéŋ Yesu ézéyec; Kiwi ic nini you kecʒiŋ imi hiabia soroc. Imuac nini hali haréwéc meénécmini, méŋ Miŋ Kewu guac, méŋ Moseac, méŋ Eliawac wammac. Waŋu ac imi némac ac ʒékerec imuac hénia ménda niŋasarima imuhuc ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Waŋu ac imi ʒémanec naŋu hosusunéŋ mama hoturu énécmiyec. Hoturu énécmiyu hosusu qeriaiguc kecgic ʒénéŋgina hiriyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Waŋu hosusu qeriaiguc ewa méŋ hicŋima yomuhuc ʒéyec; Ic yomi nena naŋna imi nenaoc gésimiyi. Ini iwac ackuaʒéc imi niŋtohomu. ");
INSERT INTO kgf_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ac imi ʒéyu tecgéyu héŋgic Yesu eŋeyanec naŋec. Waŋu tohotoho ic ieneŋ iwawai héŋgic imi nalé imuac suraiguc méŋac méŋ ménda énézégic. ");
INSERT INTO kgf_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ama giaŋiyu Yesunéŋ baec boŋa imuarunec mama hayu ic embac tuŋ yandanéŋ mihicŋi migic. ");
INSERT INTO kgf_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tuŋ imuac sucginaiguc ic méŋnéŋ qacma yomuhuc ʒéyec; Kiwi ic, ni welecgénʒua nuac naŋnawac hama hénna. Imi mia nuac merac momacguc téŋgéŋ. ");
INSERT INTO kgf_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Waŋu uŋa birianéŋ élanzaŋnec késayu imuarunec qacma ɋeme qeyu kua hololoŋa mayu séwiya mebiri qebiri wammima waimaŋ ʒé waibipianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Waŋu nesigic kemmac niŋ tohotoho ichécga welec énécmiwa ieneŋ batucgégic ménda sécgéyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Yai hicŋisai ninʒéŋ ninʒéŋgina qahac ɋariŋ ɋariŋgia yomi. Nalé dahecac séc iniguc kecma bisiqatéŋ waŋ énécmimaŋ? Guac naŋga you wagicma hana. ");
INSERT INTO kgf_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Waŋu merac imi wagicma hamanec naŋu imuarunec uŋa birianéŋ mema baeciguc giliyu hiŋgacma ɋeme qeyec. Qeyu Yesunéŋ uŋa ʒapi qeqeya imi qetalimima merac imi mehiaruma melemma maŋgocya miyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Waŋu ic embac mocʒoŋ Anutuac kuha niŋac welicgégic. Ieneŋ mocʒoŋ iwawai Yesunéŋ mema waŋec imuac welicgéma naŋgic Yesunéŋ tohotoho ichéra yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ac yomi ʒémaŋ imi gezac haima hiabianec nimmu. Icac Naŋa imi kecma ic ionac méraginaiguc opocopora wammac. ");
INSERT INTO kgf_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Waŋu ieneŋ ac imuhuc ʒéyu nimma hénia ménda niŋtegicgic. Imi mia hénia ménda niŋtegicmu niŋac musaŋgé énécmiyec imuac niŋ hénia ménda niŋasarigic. Waŋu bac yandi yandi wamma hénia ménda qesimigic. ");
INSERT INTO kgf_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Waŋu tohotoho ic ionac sucginaiguc mérénéŋ kuneŋgina wanʒac me ʒéma tualefic hénima emigic. ");
INSERT INTO kgf_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Emigic Yesunéŋ qerianéŋ niniŋgina niŋtegicma merac komoc méŋ wagicma qéhéréŋaiguc haiyu naŋec. ");
INSERT INTO kgf_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Naŋu yomuhuc énézéyec; Méŋnéŋ méŋ qacnaiguc merac komoc yomi héihéré mizac imi ni héihéré nénʒac wanʒac. Méŋnéŋ méŋ ni héihéré nénʒac imi méli néŋec i héihéré mizac wanʒac. Sucginaiguc mamayagina kecʒac iminéŋ mia eŋeŋagina wammac. ");
INSERT INTO kgf_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Waŋu Yohanenéŋ yomuhuc ézéyec; Kiwi ic, nini ic méŋnéŋ guac qacga qacma uŋa biria nesi énécmiyu hémma ménda méndac nénécmianʒac imuac niŋ neuŋ héimiyiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Imuhuc ʒéyu Yesunéŋ yomuhuc ʒéyec; Ménda qetalimimu méŋnéŋ méŋ haʒéc ménda waŋ nénécmizac inéŋ nonac wamma kecʒac. ");
INSERT INTO kgf_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesunéŋ eŋeyaoc kurumeŋiguc emmac imuac naléya hosuru ducŋiyu Yerusalem emmaŋ ʒé niŋseliyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nimma kua meme ichéra walac méli énécmiyu keŋgic. Kemma iwawai mézézéŋ géwiŋ ʒé Samaria ic ionac ama areŋ komora méŋiguc kereŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Néŋ Yesunéŋ Yerusalem kemmaŋ ʒé waŋec hénia imuac niŋ ama miŋina eneŋ ménda héihéré énécmigic. ");
INSERT INTO kgf_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Imuhuc waŋgic tohotoho ic Yakobo ʒéma Yohane iereŋ haka imi hémma yomuhuc ʒéyoc; Miŋ Kewu nini geric bélaŋa kurumeŋ igucnec mama onomac niŋ ʒéwelecbiŋ niŋac wanʒaŋ me qahac? ");
INSERT INTO kgf_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Imuhuc ʒéyic Yesunéŋ liliŋgéma iricma ac geriwaguc waŋ érécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Waŋu ieneŋ ama areŋ méŋiguc keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Héna keŋkecgic ic méŋnéŋ Yesuac yomuhuc ézéyec; Gi dimia me dimia kembésémaŋ imi ni kileŋ méndac gémma kemmaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Haséŋ kazu ieneŋ teŋginaguc. Sawa nei ieneŋ haecginaguc, néŋ Icac Naŋa imi oruc qeheheac ama duŋa méŋ ménda hemizac. ");
INSERT INTO kgf_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Waŋu Yesunéŋ ic méŋac yomuhuc ʒéyec; Gi hama méndac nénna. Waŋu inéŋ ara yomuhuc melemma ʒéyec; Waina ni walac kemma maŋgocna téŋgémaguc. ");
INSERT INTO kgf_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Waina humumia ieneŋ qamocgina imi téŋgégic, néŋ geŋ imi kemma Anutuac héŋgaleŋ ama areŋa yandawac énézéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Waŋu ic méŋnéŋ muŋguc ézéyec; Miŋ Kewu, neŋ gi méndac gémma kemmaŋ, néŋ waina walac liliŋgéma kemma sac kitichécna ewa gezacgina énézé qemaguc hawa. ");
INSERT INTO kgf_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Imuhuc ʒéyu Yesunéŋ énézéyec; Méŋnéŋ méŋ baec méséŋ méséŋac kinoŋ mériaiguc késama kemma liliŋgéma andiaiguc hénʒac imuhucyanéŋ Anutuac héŋgaleŋ ama areŋa yandawac ai méŋ memacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Imuac andiaiguc Miŋ Kewunéŋ tohotoho ic tosara 70 kumu énécmima baera baera, ama areŋa kuneŋ kuneŋ séc eŋeyaoc kemmaŋac niŋec imuaru éréhéc éréhéc méli énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Méli énécmima yomuhuc énézéyec; Héla memeyawac séc imi sasala waʒima hezac, néŋ ai ic sasala qahac imuac ini ai miŋina Anutunéŋ ai ic méli énécmimac niŋac ʒéwelec wammimu. ");
INSERT INTO kgf_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ʒéwa niŋgic, neŋ ini méli énécmima nimba rama komoc komoc haséŋ kazu sucginaiguc méli énécmimiawac tanec wanʒac. Bec yacma keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ini soukiwa konoŋ me gésé me héna usu imi ménda mema kemmu. Kemma hénaiguc ic embac mihicŋi énécmimuiguc yaiʒézé ac ménda wamma kemmu. ");
INSERT INTO kgf_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kemma ama méŋiguc emmuiguc walac yomuhuc énézému; Ama yomuaru luae hemac. ");
INSERT INTO kgf_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Imuaru luae ic méŋ kecʒaciguc luae qeénécmizu imi iwac muru hemac. Waŋu qahac waŋu onac muru liliŋgéma hamac. ");
INSERT INTO kgf_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Waŋu ama imuaru tacyac waŋgic iwawai gumu énécmigic efima nemu. Ai icnéŋ ai boŋa memuac hezac. Waŋu ama areŋ méŋac qeriaiguc amaya amaya lelecgéma tacyac ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ama areŋa yanda méŋiguc kereŋgic héihéré énécmimuiguc wéséginaiguc nene haigic hemac imi efima nemu. ");
INSERT INTO kgf_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nema bec hafi ic mehiaru énécmima Anutuac héŋgaleŋ ama areŋa yanda hosucginu hazac imuhuc énézému. ");
INSERT INTO kgf_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama areŋa yanda méŋiguc kereŋgic ménda héihéré énécmimuiguc imuac héna yanda séc keremma yomuhuc énézému; ");
INSERT INTO kgf_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Onac tauŋiguc sei totoŋ nonac hénaiguc hezac imi qeni onac muru mazac. Waŋu ini Anutuac héŋgaleŋ ama areŋa yanda imi hosucginu hazac imi niŋasarimu. ");
INSERT INTO kgf_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Neŋ énézéwa niŋgic; Nalé tetecgiaiguc ama areŋa imi bakia yéwéria yanda Sodom tauŋ meyec imi ogicma memu. ");
INSERT INTO kgf_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","O, ewa biric! Korasin ama areŋa miŋina. O, ewa biric! Betsaida tauŋ yanda miŋina, onacmuru kuc yanda baec icnéŋ ménda memeya measariyi imi mocʒoŋ Tiro ʒéma Sidon ama areŋa yandaiguc wambinec imuac ama miŋina ieneŋ becnec soŋgoŋac maleku héima toma qahaiguc tacma siacma ewagina bec melembunec. ");
INSERT INTO kgf_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gésigési naléiguc Tiro ʒéma Sidon ama areŋa yanda miŋinanéŋ onogicma képésic ginawac bakia efefia memu. ");
INSERT INTO kgf_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kafanaum ama areŋa yanda miŋina ini eŋaŋac niŋgic emma kurumeŋ késamaŋ ʒé wanʒac me? Anutunéŋ memaénéc miyu humumia ionac baec dumuŋaiguc emu hiŋgacmu. ");
INSERT INTO kgf_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tohotoho ichécna ʒéwa niŋgic; Méŋnéŋ méŋ onac ackuaʒéc ninʒac imi nuac ackuaʒéc ninʒac wanʒac. Waŋu méŋnéŋ méŋ onac andé unuzac imi ni andé nuzac wanʒac. Waŋu méŋnéŋ méŋ andé nuzac imi méli néŋec i andé qezac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tohotoho ic 70 ieneŋ ségiségi wamma liliŋgéma hama yomuhuc ézégic; Miŋ Kewu, guac qacgaiguc uŋa biria eneŋ acnina tohogic. ");
INSERT INTO kgf_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Imuhuc ʒégic acgina melemma ʒéyec; Neŋ hémba Biria miŋinanéŋ kurumeŋ igucnec pilitic ésécnec baeciguc mama qeyec. ");
INSERT INTO kgf_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Neŋ ini mokoleŋ ʒéma girisoŋaŋ tima haʒéc ionac kucgina mocʒoŋ onogicmu niŋac qac buŋa énécmizua. Iwawai méŋnéŋ méŋ hia ménda mebiri énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Néŋ uŋa biria ieneŋ acgina tohozu, imuac niŋ ségiségi ménda wammu, néŋ qacgina kurumeŋiguc oyu hezac imuac niŋ mia ségiségi wammu. ");
INSERT INTO kgf_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nalé imuarunec Yesunéŋ Uŋa Téréyaguc ségiségi wamma yomuhuc ʒéyec; Maŋgoc, baec kurumeŋac miŋina, iwawai imi musaŋgéna niniŋ ʒéma niŋtegic qiŋtegicac kuha ginaguc eneŋ ménda hénʒu, néŋ nambérac ionac auénécmina héŋanʒu imuac ewa hia ac gézézua. Oaec, Maŋgoc, guac ewa siŋganéŋ imuac mia heyec. ");
INSERT INTO kgf_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Maŋgocna geŋgaoc mia iwawai mocʒoŋ nuac nénnec. Waŋu gi qahac waŋu, méŋnéŋ méŋ mérénéŋ Naŋga wanʒac imi ménda ninʒac. Waŋu méŋnéŋ méŋ qahac, néŋ Naŋganéŋ eŋeya ewa siŋiguc auénécmiyu hénʒu ieneŋ sac Maŋgoc gi méré imi ninʒu. ");
INSERT INTO kgf_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Imuhuc ʒémaguc tohotoho ichéra ionac muru liliŋgéma inicma ionacnec sac ewaya meyu mayu yomuhuc énézéyec; Iwawai ini hénʒu imi momacnec hénʒu ionac kicginanéŋ mériaŋaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Énézéwa niŋgic; Kuameme ic sasala ʒéma ic kewu ieneŋ iwawai ini hénʒu imi hémbiŋ ʒé waŋgic, néŋ ménda héŋgic. Waŋu iwawai ini ninʒu imi nimbiŋ ʒé waŋgic, néŋ ménda niŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Héna acac kiwi ic méŋnéŋ yacma Yesu batucgéma yomuhuc qesimiyec; Kiwi ic, ni némac iwawai wamma kekec hémbénaŋa imi mihicŋimaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ʒéyu Yesunéŋ ara yomuhuc melemma qesimiyec; Héna aciguc néma ac heyu gi dimuhuc oloŋ niŋanʒaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ʒéyu ʒéyec; Ewa qeriga mocʒoŋnec, kekecga mocʒoŋnec, kucga mocʒoŋnec ʒéma ewa siŋga mocʒoŋnec Miŋ Kewu guac Anutu goi héihéi wammiwésémaŋ. Waŋu gi geŋga siŋ niŋamuanʒaŋ ésécnec alagawac siŋ nimmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Imuhuc ʒéyu Yesunéŋ ara melemma ʒéyec; Ac bakia melenʒaŋ imi dindiŋa. Imuhuc tohoma kekec hémbénaŋa mewésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Imuhuc ʒéyu ic imi Yesunéŋ iwac niŋ niŋu hiarumac niŋac yomuhuc qesimiyec; Waŋu, mérénéŋ nuac alana wanʒac? ");
INSERT INTO kgf_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Imuhuc ʒéyu Yesunéŋ séséc ac méŋ yomuhuc ʒéyec; Ic méŋ Yerusalemnec yacma Yeriko kemmaŋ ʒé hiŋgarec. Hiŋgacma hénaiguc kowu nene ic mihicŋi énécmiyu kowu nene ic ieneŋ malekuya hetecgéma humumianec qema waima keŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nalé imuhucgeŋ hofac oo ic méŋnéŋ héna imuacnec hiŋgacma ic imi hémma héna néwécgeŋacnec qiʒiʒiŋ géma keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Waŋu Lewi ic méŋnéŋ imuhucyanec imuaru haréma ic imi hémma héna néwécgeŋacnec qiʒiʒiŋ géma ogicma keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Waŋu Samaria ic méŋnéŋ ic kiaŋ wamma kemma imuaru keremma ic imi hémma wéséniniŋ wammiyec. ");
INSERT INTO kgf_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Waŋu hosuraiguc kemma haléc ʒéma doku selia wiziyaiguc qocgéma naecmima osomiyec. Osomima doŋkiya qahaiguc haima ic kiaŋ ama méŋiguc wagicma kemma galeŋgé miyec. ");
INSERT INTO kgf_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ama giaŋiyu Romawac soukiwa Denarion éréhéc ic kiaŋ ama imuac miŋina mima yomuhuc ʒéyec; Ic yomi galeŋgé miwésémaŋ. Imuac me imuac wammimaŋ ʒé soukiwa imi ogicma kiriwésémaŋ imi liliŋgéma hamaŋ imuaru taséga meleŋ gémmaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Imuhuc suruc wandacma Yesunéŋ yomuhuc qesimiyec; Geŋ ninna ic haréwéc ionac sucginaiguc mérénéŋ mia kowu nene méraginaiguc eŋec iwac ala wanʒac me? ");
INSERT INTO kgf_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ʒéyu ara melemma ʒéyec; Ic goi héihéi wammiyec imi mia. Imuhuc ʒéyu Yesunéŋ yomuhuc ézéyec; Gi kemma imuhuc wambéséaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Héna keŋkecma Yesunéŋ ama areŋ komora méŋiguc kereŋec. Kereŋu embac méŋ qara Matanéŋ héihéré miyu iwac amaiguc eŋec. ");
INSERT INTO kgf_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Waŋu iwaru munia kerec, qara imi Maria. Inéŋ Yesuac héniaiguc tacma iwac ackuaʒéc niŋec. ");
INSERT INTO kgf_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Waŋu Mata imi ai yanda meyu ai yandanéŋ ewaya mesohoyec. Waŋu Yesuac muru hama yomuhuc ézéyec; Miŋ Kewu nuac munananéŋ wainéŋu ni nenacnec ai mema nanʒua. Waŋu gi imuac ewa biric ménda waŋ nénʒaŋ? Ézéna hama méra némmac. ");
INSERT INTO kgf_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ʒéyu Miŋ Kewunéŋ ara melemma ʒéyec; Mata, Mata, gi iwawai hénia hénia niŋac niŋyéwéri wanna ewaga goro wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Néŋ éréhéc dac sac mewésémaŋ, qahac waŋu momacdac imi sécgémac. Marianéŋ héna hiabia gésima aŋgétizac imuac imi iwarunec wagicmaŋac séc qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yesunéŋ baec méŋiguc ʒéwelerec. Ʒéweleru tecgéyu tohotoho ichéra ionarunec méŋnéŋ yomuhuc ézéyec; Miŋ Kewu doku naec ic Yohanenéŋ tohotoho ichéra dimuhuc ʒéwelecmu imuac hénia ku énécmiyec. Gi imuhucyanec ʒéwelec welecac hénia ku nénécmina. ");
INSERT INTO kgf_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ʒéyu ʒéyec; Ini ʒéwelecbiŋ ʒéma yomuhuc ʒéwelecmu; Maŋgocnina, guac qacga mepésini téréya hemac. Guac héŋgaleŋ ama areŋa yanda imi mama hamac. ");
INSERT INTO kgf_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gi kaiweya kaiweya imuac nene sécnina nénécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nini ic tosara biria waŋ nénécmigic séc képésicgina wai énécmiziŋ, imuac gi imuhucyanec képésicnina wai nénécmina. Waŋu manam batuciguc ménda nonopocbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Imuhuc ʒéma inéŋ yomuhuc toroqema ʒéyec; Sucgina igucnec méŋnéŋ alayaguc waŋu alaya iminéŋ siŋi yandaiguc iwac muru kemma yomuhuc welecmimac; Alana, saméŋ haréwéc nénna biaŋguc melemmaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ic kiaŋ alana méŋnéŋ nuaru hazac. Waŋu nene méŋ gumu mimaŋ ʒéma hocʒua. ");
INSERT INTO kgf_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Imuhuc ʒéyu alayanéŋ ama qeria igucnec yomuhuc melemma ʒémac; Gi gau ɋeli ɋeli nunuzaŋ, ni ama naguya bec héima nambérac hécna iniguc gau niŋac wamma heziŋ imuac niŋ yacma yaka gémmaŋac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Waŋu ʒéwa niŋgic, ama miŋinanéŋ ic imi alaya wanʒac imuac wamma ménda yacma nimmimac, néŋ ic imi seliseli wamma welecma naŋu imuac niŋac mia yacma iwawai méŋ niŋac wawaŋa imuac sécya mimac. ");
INSERT INTO kgf_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Méŋnéŋ méŋ weleru miyu meanʒac. Waŋu méŋnéŋ méŋ hochoc ai mema mihicŋianʒac. Waŋu méŋnéŋ méŋ nagu qeyu aumimia waŋanʒac. Imuac niŋac ʒéwa niŋgic; Welecgic énécmimac. Hochoc ai mema mihicŋimu. Naguya qegic auénécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Guac naŋganéŋ lambéc niŋac qesigéŋu maŋgoc onac sucgina igucnec mérénéŋ lambécac tasia qaté mokoleŋ mimac? ");
INSERT INTO kgf_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Waŋu kuruc gocmia niŋac welecgéŋu mérénéŋ tasia girisoŋaŋ mimac? ");
INSERT INTO kgf_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ini ic biria, néŋ kileŋ iwawai hiabia nambérac hécgina gumu énécmianʒuiguc onac kurumeŋ Maŋgocginanéŋ welecmianʒu onac Uŋa Téréya séc ogicqogicma dimuhucya énécmimac? ");
INSERT INTO kgf_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Waŋu Yesunéŋ uŋa biria ara qahac imi nesimiyu éréma keŋu merac imi ac ʒéyec. Ʒéyu ic embac tuŋ ieneŋ imi hémma welicgégic. ");
INSERT INTO kgf_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Waŋu sucginaiguc tosaranéŋ yomuhuc ʒégic; Inéŋ kuwic ionac ic kewugina Beelʒebulac kuha mema uŋa biria nesi énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Waŋu ic tosaranéŋ Yesu batucgémima séséc baec icnéŋ ménda memeya kurumeŋ igucnec mamaya méŋac meyu hémbiŋ niŋac welecmigic. ");
INSERT INTO kgf_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Welecmigic Yesunéŋ ionac niniŋgina niŋtegicma yomuhuc ʒéyec; Héŋgaleŋ ama yandawac miŋinanéŋ eŋaocnec euhéndéŋ waŋamuzu séc kisi waŋanʒac. Waŋu ama méŋac miŋinanéŋ eŋaocnec euhési waŋamuanʒu imi mama birianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Neŋ Beelʒebulac kuha mema uŋa biria nesi énécmianʒua imuhuc ʒénénʒu, néŋ Biria miŋinanéŋ eŋaocnec héndéŋ amuanʒuiguc ionac héŋgaleŋ ama areŋa yandanéŋ dimuhuc naŋselimac? ");
INSERT INTO kgf_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Neŋ Beelʒebulac kuha mema uŋa biria nesi énécmizuaiguc imi naŋhécgina ieneŋ mérac kuha mema uŋa biria nesi énécmianʒu? Imuac naŋhécgina eŋaoc mia ʒégési énécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Néŋ neŋ Anutuac méria merawanéŋ uŋa biria nesi énécmianʒuaiguc Anutuac héŋgaleŋ ama areŋa yandanéŋ bec onacmuru mama hazac. ");
INSERT INTO kgf_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ic kawalinéŋ tewi maleku séha meyu kiyunec amaya galeŋgéyu ama imi luaeiguc hia heanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Waŋu ic kawali kuha eŋeŋa méŋnéŋ hama ic imi ogicʒaciguc tewi maleku selia niŋkumuma mekecʒac imi mocʒoŋ wagicma iwac hinacya momacnec wagicma sécgina méndémma énécmianʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Méŋnéŋ méŋ niguc ménda kecʒac inéŋ andé nuzac. Waŋu iwawaina niguc ménda tocgézac inéŋ iwawaina héndénʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Uŋa biria méŋnéŋ ic méŋac murunec éréma kemma baec kisiaiguc keŋha wamma tachiarumaŋ ʒé waŋu ménda sécgézac. Ménda sécgéyu inéŋ yomuhuc ʒézac; Ni amana éréma hazua imuaru liliŋgémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Imuhuc ʒéma liliŋgéma hama héŋu ama imi usuŋma mindiŋiyecac hiabia hezac. ");
INSERT INTO kgf_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Heyu kemma uŋa biria kawalihéra 7 onagiru hama hiŋgacma kecgic walac birima kerec imi muŋguc yanda ogicqogic wamma kuneŋnec birima kecʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ac imuhuc ʒémanec naŋu tuŋ yanda imuac sucgina igucnec embac méŋnéŋ qacma ʒéyec; Gi héri haima megémma namu gumugéŋec neŋgoc iminéŋ ségiségiyaguc! ");
INSERT INTO kgf_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Imuhuc ʒéyu Yesunéŋ melemma ʒéyec; Ic méŋ Anutuac ackuaʒéc nimma tohoanʒac iminéŋ mia ségiségiyaguc wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ic tuŋ muŋguc yanda toroqe énécmima naŋgic Yesunéŋ hénima yomuhuc énézéyec; Nalé yomuac hicŋisai imi hicŋisai biria, séséc mérérawac hémbiŋ ʒé waŋanʒu, néŋ séséc méŋ qahac, néŋ Yonawac muru haka hicŋiyec imi sac hicŋi énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yonanéŋ Niniwe ama areŋa yanda imuac miŋhéra ionac muru séséc waŋec ésécnec, Icac Naŋa imuhucyanec nalé yomuac hicŋisai onac muru imuhuc wammac. ");
INSERT INTO kgf_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Héŋgaleŋ ama yanda méŋ baec waŋgoŋa Saut iguc hezac imuac embac garata méŋnéŋ Solomonac niŋtegic qiŋtegicac kuha nimmaŋ ʒé baec tetecgia igucnec hayec, néŋ nalé yomuac hicŋisai eneŋ Solomonac Kuneŋa neŋ you kecma énézéwa ménda niŋnénʒu. Imuac ʒégésigési naléya ducŋiyu embac garata iminéŋ ini ʒégési énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niniwe ic eneŋ Yonawac ackuaʒéc nimma ewagina meleŋgic, néŋ nalé yomuac hicŋisai eneŋ Yonawac Kuneŋa neŋ you kecma énézéwa ménda niŋnénʒu imuac niŋ ʒégésigési naléyaiguc Niniwe ic ieneŋ ini ʒégési énécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Méŋnéŋ méŋ lambegina otorima sasaŋgiaiguc me kewuc bawaiguc ménda haianʒu, néŋ qémbéŋ qahaiguc haianʒu. Imi mia ic embac ama qeriaiguc érému eneŋ asaha hémmu niŋac imuhuc waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Waŋu néwécgeŋac ʒéwa niŋgic; Guac kicganéŋ séwigawac lambe wanʒac. Kicganéŋ hia kecʒaciguc séwiga mocʒoŋ asahanéŋ sécgémimia wanʒac. Waŋu kicganéŋ birizaciguc séwiga mocʒoŋ siŋinéŋ sécgémimia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Imuac ewa qerigaiguc asac mararaŋ hezac imi ménda siŋidéŋgézac me qahac imi niŋgésina. ");
INSERT INTO kgf_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Imuac guac séwiga asaha sécgégéŋu siŋi méŋ ménda hegéŋu lambeac asahanéŋ asarigéŋanʒac ésécnec kekecga mocʒoŋ asahaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesunéŋ ac imuhuc ʒémanec naŋu Farisaio ic méŋnéŋ eŋeyaguc momacnec tacma nene nemac niŋac Yesu welecmiyu emma tarec. ");
INSERT INTO kgf_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Néŋ nene nemaŋ ʒé wamma méria ménda ʒuaru Farisaio ic iminéŋ hémma ewa éréhéc waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Waŋu Yesunéŋ yomuhuc ʒéyec; Farisaio ic ini sokoc ʒéma ʒéic séwéla imi hiabianec ʒuacanʒu, néŋ ewa qerigina imi hémbaoc haka ʒéma kaiʒiliweŋ hakanéŋ kuaya qema hezac. ");
INSERT INTO kgf_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Niniŋgina qahac ini, séwéla mihicŋiyec inéŋ qeria momacnec mihicŋiyec imi ménda niŋtegicʒu? ");
INSERT INTO kgf_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Waŋu qerigaiguc hegénʒac séciguc haleŋ énécmina iwawai mocʒoŋ solaŋa waŋgémmac. ");
INSERT INTO kgf_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Néŋ saecginaguc ini Farisaio ic, ini miŋsupe ʒéma ʒuaʒua héméŋa hiabia tosara imi méndéŋgic méra éréhéc waŋu momacguc mema Anutuac buŋa haianʒu. Néŋ haka dindiŋa ʒéma goi héihéi Anutuac buŋa haihaiya imi giligic qahac wanʒac. Méŋ ménda waima imuac me imuac momacnec wandacmu iminéŋ hia wammac. ");
INSERT INTO kgf_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Saecginaguc ini Farisaio ic, ini tocgotocgo amaiguc tatac ou eŋeŋa hezac imuaru tacbiŋ niŋac waŋanʒu. Waŋu nénnagémba sombeŋiguc ʒézé ségiségi waŋ énécmimu niŋac waŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Saecginaguc ini imi kicsuaŋ suaŋa qahac kondoŋa heheya ésécnec waŋu, ic embac ieneŋ imuac qahaiguc tima namma héniagina ménda niŋtecgicanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Imuhuc ʒéyu héna acac kiwi ic méŋnéŋ Yesu yomuhuc melemma ʒéyec; Kiwi ic gi imuhuc ʒéma nini momacnec mutulaŋgéma ʒébiri nénécmizaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Saecginaguc héna acac kiwi ic ini, iwawai yéwéria yanda sécgina ogicogicya imi ic tosara ionac hai énécmigic bisianʒu, néŋ ini eŋaoc imi méragina merawa méŋ ménda suluma osianʒu. ");
INSERT INTO kgf_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Saecginaguc ini, eneŋ Anutuac tiliŋ tiliŋ ic becnec yanda hécgina ieneŋ unugic ionac kicsuaŋ imi meyacgéanʒu, néŋ ackuaʒéc imi ménda tohoanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Yandahécgina Ieneŋ Anutuac tiliŋ tiliŋ ic unugic Farisaio ic eneŋ imi kua meme ic ionac kicsuaŋ meyacgézu. Imuhuc wamma ini yanda hécginawac ai imuac ewa momac wanʒu imuac héipuc ac ʒéauzu. ");
INSERT INTO kgf_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Imuac niŋ Anutunéŋ niŋtegic qiŋtegicac kuhaiguc yomuhuc ʒéyec; Neŋ ionac muru walac ʒézé ichécna ʒéma méliméli ic méli énécmimaŋ, waŋu ionarunec tosara unuhumumu, waŋu tosara ununesi waŋ énécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Baec kurumeŋ ʒéyu hicŋiyec imuarunec hénima éréma kecma deguc imuac suraiguc Anutuac tiliŋ tiliŋ ic unugic sacgina mayec imuac bakia mocʒoŋ nalé yomuac hicŋisai ionac qacginaiguc emmac. ");
INSERT INTO kgf_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Imi mia Abelac sac igucnec hénima éréma kecma ʒaki téréya sombeŋiguc naŋec imi ʒéma ama téréya imuac géŋgéŋaiguc qegic humuyec Ʒakaraia iwac sacya imuac bakia mocʒoŋ nalé yomuac hicŋisai eneŋ mia bisidacmu. ");
INSERT INTO kgf_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Saecginaguc héna acac kiwi ic ini, ini imi niniŋac nagu wétéya késa kecma eŋaoc ménda emma imuhucyanec naguya héʒicgéma naŋgic ic embac embiŋ ʒé wanʒu imi eneŋ momacnec emmuac séc qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Imuhuc ʒémaguc Yesu ama imi waima kemmaŋ ʒé mayu Farisaio ic ʒéma héna acac kiwi ic ieneŋ hénima haʒéc geriwaguc wammima acgina melemmac niŋac selianec hinocgémima ʒéqesiqesi sasala wammigic. ");
INSERT INTO kgf_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Imuhuc wamma ac képésira méŋ ʒéyu késawiŋ ʒéma galeŋ megic. ");
INSERT INTO kgf_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Suraiguc ic embac tuŋ yanda tauseŋa tauseŋa tocgéma hénagina tiloc paloc tima naŋgic. Yesunéŋ walac tohotoho ichéra yomuhuc énézéyec; Farisaio ic qeri ikocginaguc ionac yis imuac galeŋ memu. ");
INSERT INTO kgf_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Iwawai méŋnéŋ méŋ, usuyaguc hezac imi ménda auyu hemacac séc qahac, sasaŋgiaiguc hezac imi ménda niŋmimiawac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Imuac niŋ iwawai siŋiiguc ʒégic imi mocʒoŋ kaiweac asahaiguc ʒéaugic nindacmu. Waŋu iwawai ama qeriaiguc ʒégic imi mocʒoŋ ama bauyaiguc namma ʒéaugic nindacmu. ");
INSERT INTO kgf_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Alahécna onac énézézua, séwigina sac unuhumuma imuac andiaiguc iwawai méŋ toroqema waŋ énécmimuac séc qahac ionac niŋ ʒénéŋgina ménda hirimac. ");
INSERT INTO kgf_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mérac kileŋ ʒénéŋgina hirimac imi ʒéasariwa niŋgic. Unuhumuma imuac andiaiguc geric siaiguc gili énécmimacac kuc buŋaya hemizac iwac mia ʒénéŋgina hirimac. Owec, énézézua, iwac mia ʒénéŋgina hirimac. ");
INSERT INTO kgf_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Sirikic méra méŋac boŋa soukiwa Toya éréhécdac ménda haianʒu? Waŋu Anutuac kiwaiguc sirikic nei ionac murunec méŋac niŋ eluŋ ménda qeanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ini imi Anutunéŋ oruc ʒucgina ʒaŋgéya acguc mocʒoŋ oloŋ nindacʒac, imuac ʒénéŋgina ménda hirimac. Eŋac eŋac kekecgina imi sirikic nei sasala onogicma eŋeŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Waŋu ni énézéwa niŋgic; Méŋnéŋ méŋ ic embac kicginaiguc ʒéauma ni ninʒéŋgé némmaciguc ni imuhucyanec Anutuac kua meme uŋa kicginaiguc ʒéauma i ninʒéŋgé mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ic embac kicginaiguc ni qaecgé nénʒac imi ni Anutuac kua meme uŋahéra kicginaiguc qaecgémimaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Méŋnéŋ méŋ Icac Naŋa ʒébiri mizaciguc képésic imi waimimacac hezac, néŋ Uŋa Téréyawac ʒébiri wammizaciguc képésic imi ménda waimimac. ");
INSERT INTO kgf_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ic embac tosaranéŋ ini tocgotocgo amaiguc me galeŋ ʒéma ic kewu tosara qac buŋaginaguc ionac muru onagicma keŋgic ac bakia dimuhuc melemma ac dimuhucya ʒéwiŋ ʒéma ewa goro ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nalé imuaru mia Uŋa Téréyanéŋ némac ac ʒému imi ku énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Waŋu tuŋ imuarunec ic méŋnéŋ yomuhuc ʒéyec; Kiwi ic nuac dacna ac ézéna maŋgoc niranéŋ iwawai mératéc wainérécmiyec imi niguc méndémma mewic. ");
INSERT INTO kgf_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ʒéyu Yesunéŋ ézéyec; Ic mérénéŋ ni iwawaigira méndéŋ érécmimaŋ niŋac ʒégésigési ai icgirawac kumunéŋec? ");
INSERT INTO kgf_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Imuhuc ʒémaguc inéŋ ic embac yomuhuc énézéyec; Iwawai méŋac méŋ hémbaoc ménda wamma niniŋ biria imuac galeŋ memu. Ic méŋac kekecya imi iwac iwawaiya sasala imuaru ménda hezac. ");
INSERT INTO kgf_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Imuhuc ʒéma inéŋ ɋelumbec ac méŋ yomuhuc énézéyec; Soukiwa ic méŋ kerec. Keru iwac aiiguc héla gocmia kindindiŋa hicŋimiyec. ");
INSERT INTO kgf_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hicŋimiyu ewa qeriaiguc yomuhuc niŋec; Nuaru héla gocmia imi haihaiyawac titiŋa méŋ ménda hezac. Imuac dimuhuc wammaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Imuhuc ʒéma ʒéyec; Ni yomuhuc wammaŋ, nuac hofi ama komora imi hericma kuneŋ yanda ɋelia méŋ meyacgéma nuac ai yawuŋac héla ʒéma iwawai hiabia imi mocʒoŋ imuaru haiwa hemac. ");
INSERT INTO kgf_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Imuhuc wamma nuac uŋanawac yomuhuc ʒémaŋ; Nuac qeri uŋana, iwawai ai yawuŋ sasalawac sécya qolacgéma haiwa hezac. Imuac gi bénʒéŋ tacnimma nene kuluŋ nema ségiségi wamma kecbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Néŋ Anutunéŋ yomuhuc ézémac; Ic, gi imi niŋtegic qiŋtegicga qahac, deguc siŋiya guac qeri uŋaga guagicba iwawai qutulaŋgéma haina hezac imi mocʒoŋ mérac wammac me? ");
INSERT INTO kgf_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ic imuhucya imi eŋeyawac iwawai sasala tiloyu emma hezac, néŋ Anutuac muru imi saméŋ bipiyaguc ménda hemiyu kecʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Imuhuc ʒéma tohotoho ichéra énézéyec; Imuac néwécgeŋac yomuhuc énézéwa niŋgic; Kekecgina niŋac némac iwawai nemu, séwigina niŋac némac iwawai héimu imuac ewa goro ménda wammu. ");
INSERT INTO kgf_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kekec imi nene ogicʒac. Waŋu séwigina imi malekugina ogicʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Koeckoec nei imuac niŋgic, iwawai méŋ ménda héihimic wamma meanʒu. Waŋu ama saméŋa me hofi amaya méŋ ménda he énécmizac, néŋ kileŋ Anutunéŋ gumu énécmianʒac. Ini imi nei kuneŋ yanda ogicma eeginaguc wanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sucginaiguc mérénéŋ ewa goro wamma kekecya komodia méŋ mehorugimacac séc wanʒac me? ");
INSERT INTO kgf_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Iwawai komodia méŋ imuhucya hia mindiŋiwésémaŋac séc qahac waŋu dimuhuc méŋac méŋ ewa goro wambésémaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Baorac ʒariŋac niŋgic, imi dimuhuc yandianʒu? Ieneŋ ai ménda meanʒu waŋu hésa méŋ ménda meyacgéanʒu waŋu énézéwa niŋgic, Ic kewu Solomonnéŋ maleku héiyec imuac edamuya mocʒoŋ imi ʒariŋ méŋac asaha ogicmacac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Deguc keru oraŋguc qema oanʒu ʒariŋdac imuhucyawac Anutunéŋ imuhuc hiabianec héi énécmianʒac. Imuhucya imuhuc waŋ énécmianʒac iguc onac imi ogicqogic wamma ménda héiénécmimac me? O! ic embac, ninʒéŋ ninʒéŋgina imi komocdia dac. ");
INSERT INTO kgf_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ini némac iwawai newiŋ ʒéma ewa goro ménda wammu, waŋu imuac ménda ʒéwelecmu. ");
INSERT INTO kgf_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Baecac ic enia ieneŋ mia iwawai mocʒoŋ imuhucya niŋac wamma welecanʒu. Onac Maŋgocginanéŋ ini iwawai imuac me imuac osizu imi bec niŋdacaʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ini mia iwac héŋgaleŋ ama areŋa yanda imuac hochoc wammu. Imuhuc waŋgic iwawai tosara imi toroqema énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ic tuŋ komora ini ʒénéŋgina ménda hiriyu, Maŋgocnéŋ héŋgaleŋ ama areŋa yanda imi énécmimaŋ ʒé ewa hia ninʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Iwawaigina haima soukiwa mihicŋima maqeqeya ionac énécmigic. Gésé tegictegira qahac kurumeŋac buŋa mihicŋima imuaru mia iwawai boŋa eŋeŋa imi tigic hemac. Imuaru imi kowu nene hosuru keŋkeŋawac séc qahac, waŋu gisic ʒinaŋgoc nemuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iwawaigina boŋa eŋeŋa hezac imuaru onac ewa siŋgina heanʒac imuac niŋac imuhuc ʒézua. ");
INSERT INTO kgf_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kembaŋ ginaiguc rikuŋgina ʒikima kifagina otorigic ʒeyunec naŋkecmu. ");
INSERT INTO kgf_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ini imi ic tosara miŋginanéŋ ʒammaréŋ meme ariac igucnec liliŋgéma hama nagu qeyu focdac yacma nagu auwiŋ ʒé mambéc kecanʒu ésécnec wamma kecmu. ");
INSERT INTO kgf_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Miŋginanéŋ hama kic hihi kecgic inicmaciguc weleŋ qeqehéra imuhucya imi ségiségi ginaguc wammu. Hélacnec énézéwa niŋgic, miŋginanéŋ rikuŋa ʒikima namma énézéyu tacgic hosucginu hama weleŋ qeénécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Inéŋ siŋiyawac 12 kilok me 3 kilok imuaru hama iniru imuhuc wamma kecmuiguc imi ségiségi ginaguc wammu. ");
INSERT INTO kgf_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ini ninʒu ésécnec ama miŋinanéŋ némac naléiguc kowu nene hamu imi niŋaŋeciguc awima taru amaya imi ménda hésémma embunec. ");
INSERT INTO kgf_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Imuac niŋ ini acguc técgina nimma kecmu. Ménda nimma kecmu nalé imuaru Icac Naŋa imi hamac. ");
INSERT INTO kgf_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Imuhuc ʒéyu Peteronéŋ yomuhuc qesimiyec; Gi séséc ac imi nonac niŋ sac ʒézaŋ me nini mocʒoŋ niŋac ʒézaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ʒéyu Miŋ Kewunéŋ melemma ʒéyec; Waŋu mérénéŋ ai ic niŋkumu mimia ʒéma niŋtegic qiŋtegicyaguc wamma miŋinawac weleŋqeqe ichéra galeŋgé énécmima naléya ducŋiyu séc nene yakaginawac buŋa méndéŋ énécmiammac? ");
INSERT INTO kgf_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Waŋu miŋinanéŋ hama héŋu imuhuc wamma keru, weleŋ qeqe imuhucya imi ségiségiyaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ni hélacnec énézéwa niŋgic; Miŋinanéŋ ic imuhucya imi iwawaiya mocʒoŋ galeŋgémac niŋac opocmac. ");
INSERT INTO kgf_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Waŋu weleŋ qeqe icnéŋ imuhuc ménda wamma ewa qeriaiguc eŋeya miŋinanéŋ bénʒéŋ bénʒéŋ hamac ʒéma iwawai hémbaoc wamma nema doku selia nema niŋgoŋ wamma weleŋ qeqe ichéra ʒéma embachéra hénima unumac imi ");
INSERT INTO kgf_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nalé méŋ kic hihi ménda wamma kecmac imuaru, waŋu kaiwe kiwa méŋ ménda nimma kecmac imuaru mia miŋinanéŋ hama bakia réwéria meleŋ mima ic ninʒéŋ ninʒéŋgina qahac iniguc momacnec onopocmac. ");
INSERT INTO kgf_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Miŋinawac ewa siŋ imi dimuhuc hezac imi niŋtegicmaguc kileŋ técya ménda nimma iwac ewa siŋa tohotoho ménda wammac imi sasalanec qemac. ");
INSERT INTO kgf_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ménda niŋtegicma haka biria wanʒac imi efefia qemac. Iwawai sasala meyec iwac muru sasala memaŋ ʒé hocmac. Waŋu ai buŋa sasala késayec iwac muru imi iwawai sasala mihicŋimaŋ ʒé qesimimac. ");
INSERT INTO kgf_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ni baeciguc geric ʒéc gilimaŋ ʒé mayi. Waŋu bec ʒezaciguc némac iwawai méŋ niŋac wammaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ni météré naec ai méŋ waŋ némmuac hezac. Qeri yéwéri dimuhucyanéŋ kilanʒi némma keŋkeruguc yéwéri imi mocʒoŋ tecgénémmac! ");
INSERT INTO kgf_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ini niŋgic ni baeciguc luae qeénécmimaŋ ʒé hayi tanec wanʒac me? Énézéwa niŋgic; Imi qahac, méndéŋ énécmimaŋ ʒé hayi. ");
INSERT INTO kgf_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kecma ama momacgucac qeria igucnec ic embac méra méŋ kecma haréwécnéŋ éréhéc haʒéc waŋ érécmigic éréhécnéŋ haréwéc haʒéc waŋ énécmiyic méndéŋ amuma kecmu. ");
INSERT INTO kgf_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Maŋgocnéŋ naŋaguc, naŋanéŋ maŋgocyaguc, neŋgocnéŋ béraraguc, béraranéŋ neŋgocyaguc, eraŋiyanéŋ eraŋiyaguc héndéŋ amuma aŋaŋ qacgé amumu. ");
INSERT INTO kgf_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Imuhuc ʒéma toroqema ʒéyec; Ini hosusunéŋ konduŋ igucnec hayu hémma kia focdac hamac ʒégic imuhuc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Waŋu Saut baec kisia igucnec luhucnéŋ éréyu hémma geriwaguc wammac ʒégic imuhuc waŋanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ic ikocginaguc ini baec kurumeŋac tanera imi héŋtegicma dimuhuc nalé yomuac hakaginawac tanera imi ménda niŋtegicanʒu? ");
INSERT INTO kgf_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Waŋu némac niŋac némac hakanéŋ solaŋa wanʒac imi moacnec ménda niŋgésianʒu? ");
INSERT INTO kgf_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gi ic haʒécgaguc ʒégésigési icac muru kemmaoc imuaru hénaiguc ara mindiŋimaŋ ʒé meefima luae ac ʒémaoc. Imuhuc ménda wanna, inéŋ gésigési ic iwac muru hérégémma keŋu gésigési icnéŋ téŋgiŋ ic ionac méraginaiguc goporu téŋgiŋ ic ieneŋ hésa amaiguc giligémma gopocbu niŋac. ");
INSERT INTO kgf_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Gézéwa ninna, kitiwa melemma Toya tetecgiawac méŋ acguc mocʒoŋ ménda meleŋna tecgéyu hia ménda mama hawaŋ niŋac. ");
INSERT INTO kgf_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nalé imuaru tosaranéŋ Yesuac muru hama Pilatonéŋ Galilaia ic embac tosara unuhumugic sacginanéŋ mama ionac ʒucmanaŋ ginawac sacguc momacnec sicsaoc wamma keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ʒégic Yesunéŋ acgina melemma ʒéyec; Ini imi Galilaia ic ieneŋ haka imuhucya mihicŋigic inicma niŋgic ieneŋ Galilaia ic tosara onogicma képésic yanda waŋgic ésécnec wanʒac me? ");
INSERT INTO kgf_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ni énézéwa niŋgic, imi qahac, ewa qerigina ménda melemmuiguc mocʒoŋ yanda ini acguc imuhucyanec qahac wandacmu. ");
INSERT INTO kgf_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Waŋu ic embac 18 Siloam ama areŋaiguc awiawi ama héŋgeŋa horua herec imi mama qeyu imuac bawaiguc humugic. Waŋu eneŋ ionac niŋgic képésicgina imi Yerusalem imuac miŋhéra tosara ionac képésicgina ogicʒac ésécnec wanʒac me? ");
INSERT INTO kgf_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ni énézéwa niŋgic, imi qahac, mocʒoŋ yanda ini acguc ewa qerigina ménda meleŋgic imuhucyanec humuma qahac wandacmu. ");
INSERT INTO kgf_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Imuhuc ʒéma séséc ac méŋ yomuhuc ʒéyec; Ic méŋnéŋ waiŋ aiiguc fik ic méŋ himiru heyu hama imuac gocmia niŋac horec, néŋ méŋ ménda mihicŋiyec. ");
INSERT INTO kgf_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Waŋu inéŋ imuac ai ic yomuhuc ézéyec; Ni ai yawuŋ haréwéc hama fik ic yomuac gocmia niŋac hocma héla ménda mihicŋianʒua. Imuac ic hésa imi héina qahac wammac. Némac niŋac baec imi eŋdac késama nammac? ");
INSERT INTO kgf_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ʒéyu ʒéyec; Miŋ kewuna waina ai yawuŋ momacguc méŋ naŋu neŋ giŋgiŋaiguc baec imi éséma guwec haima héwiŋa héimaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Héiwa kecma biaŋguc héla haimac niŋac, kileŋdac héla ménda haimaciguc nalé imuhucgeŋ ʒéna héiwa qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Waŋu Yesunéŋ Sabata naléiguc tocgotocgo ama méŋiguc emma ackuaʒéc ku énécmima naŋec. ");
INSERT INTO kgf_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Waŋu ninʒu, embac méŋ yawuŋ 18 imuac séc hafi uŋanéŋ késayu gemara momacnec licgémiyecac dindiŋanec nammacac séc qahac kecaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Waŋu Yesunéŋ hémma ʒéyu hama kicginaiguc naŋu ézéyec; Embac gi hafi ʒepaga igucnec hulacgé géŋgéŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Imuhuc ʒéma méria haimima ʒéweleru embac iminéŋ imuarunec gemara mindiŋima dindiŋanec namma Anutu mepésiyec. ");
INSERT INTO kgf_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tocgotocgo amawac galeŋnéŋ Yesunéŋ Sabataiguc hafi mehiaru énécmiyu hémma qeri biric nimma ic tuŋ yomuhuc énézéyec; Ai meme 6 hezac, imuac niŋ imuac suraiguc hagic mehiaru énécmimac, néŋ Sabataiguc imi qahac. ");
INSERT INTO kgf_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Imuhuc ʒéyu Miŋ Kewunéŋ melemma ʒéyec; Ic onac kiciguc weleŋ qeqe ic ini sucgina igucnec méŋnéŋ méŋ Sabata naléiguc eŋeya burumakao me doŋki héréma kemma doku ménda gumuanʒac me? ");
INSERT INTO kgf_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Abarahamac bérara embac yomi Biria miŋinanéŋ késayu yawuŋ 18 ʒiki sipacyaguc kecaŋec. Waŋu Sabata naléiguc ʒiki sipacya imi hulac mimiawac ménda hezac? ");
INSERT INTO kgf_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesunéŋ imuhuc ʒéyu ic embac haʒéc wammigic imi eneŋ mocʒoŋ niŋgic gamuginaguc waŋec, néŋ ic tuŋ yanda tosaranéŋ haka mocʒoŋ kuc buŋayaguc imi meyu hémma ségiségi waŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Anutuac héŋgaleŋ ama areŋa yanda imi némac iwawai ésécnec wanʒac? Neŋ dimuhuciguc séc héima ʒémaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Imi mia, ic hésa méŋ qara ʒunʒuaŋ imuac gocmia ésécnec, ic méŋnéŋ gocmia imi momacguc mema kemma aiiguc himiru yandima ic yanda wamma naŋu nei sawaiguc kecanʒu imi eneŋ imuaru haecgina haigic. ");
INSERT INTO kgf_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Inéŋ muŋguc toroqema ʒéyec; Ni Anutuac héŋgaleŋ ama areŋa yanda imi némac iwawaiiguc séc héimaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Imi mia embac méŋnéŋ saméŋ omaŋ ʒéma fulawa uha sasala imuac qeriaiguc yis haiyu mocʒoŋ sécgémiyec ésécnec. ");
INSERT INTO kgf_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Waŋu Yesunéŋ Yerusalem kemmaŋ ʒé kemma hénaiguc ama areŋa areŋa, ama areŋa kuneŋ kuneŋ séc lelecgéma ackuaʒéc ku énécmimanec keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Waŋu ic méŋnéŋ yomuhuc qesimiyec; Miŋ Kewu, ic embac efefia dac humucac buŋa igucnec aŋgéŋ tiénécmimac me? Imuhuc ʒéyu melemma ʒéyec; ");
INSERT INTO kgf_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Énézéwa niŋgic, embiŋ ʒé waŋgic ionac murunec sasalanéŋ meselimuac séc qahac wammac, imuac niŋac nagu komoraiguc embiŋ ʒé seliseli wammu. ");
INSERT INTO kgf_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ama miŋinanéŋ yacma nagu héiyuguc ini séŋgaŋgeŋ namma nagu imi qema Miŋ Kewu nagu aunénécmina ʒégic, inéŋ melemma yomuhuc énézémac; Ini dimuacnec imi ni ménda niŋénécmizua. ");
INSERT INTO kgf_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Imuhuc ʒéyu ini yomuhuc hénima ʒému; Nini wéségaiguc nene ʒéma kuluŋ neyiŋ. Waŋu gi nonac ama areŋ imuac héna yandaiguc ackuaʒéc ku nénécminec. ");
INSERT INTO kgf_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ʒégic inéŋ yomuhuc énézémac; Ni imi ini dimuacnec imi ménda niŋénécmizua. Biria meme ic ini mocʒoŋ néŋgacgic. ");
INSERT INTO kgf_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yesunéŋ toroqema ʒéyec; Abaraham, Isaka, Yakop ʒéma Anutuac tiliŋ tiliŋ ic mocʒoŋ Anutuac héŋgaleŋ ama areŋa yanda imuaru kecgic inicmu, inicma duŋa liliŋgéma héŋgic ini eŋaoc imi nesi énécmimia waŋu séŋgaŋgeŋ hiŋgacma imuaru ʒésiac yanda wamma ʒécgina aric aric kima tacmu. ");
INSERT INTO kgf_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Waŋu ic embac eneŋ baec waŋgoŋa kemboŋ qahac imuacnec hama Anutuac héŋgaleŋ ama areŋa yandaiguc tacma nene nemu. ");
INSERT INTO kgf_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ninʒu, andu tosaranéŋ walac wammu, waŋu walac tosaranéŋ andu wammu. ");
INSERT INTO kgf_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Waŋu nalé imuaru Farisaio ic tosaranéŋ hama Yesu ézégic; Hiŋgacma ama areŋ yomi waima kembésémaŋ. Herodenéŋ gi gumaŋac ʒé wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Imuhuc ʒégic melemma ʒéyec; Kemma haséŋ kazu imi yomuhuc ézégic; Ni deguc ʒéma oraŋ uŋa biria nesi énécmima hafigina mehiaru énécmimaguc weruguc imi aina mocʒoŋ metecgémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Néŋ Anutuac tiliŋ tiliŋ icnéŋ Yerusalem imuac séŋgaŋgeŋiguc humumacac séc qahac. Imuac ni deguc, oraŋ ʒéma weru imi hénana ʒénéŋec imi kileŋdac tima kemmaŋac hezac. ");
INSERT INTO kgf_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusalem, Yerusalem, Anutuac tiliŋ tiliŋ ic unuma onac muru méli énécmimia hocnéŋ unuanʒaŋ. Kuruc neŋgocyanéŋ qeŋgaŋa bawaiguc eŋeya merachéra tiʒoʒo énécmianʒac ésécnec ni guac nambérac hécga tocgé énécmimaŋ ʒé aina mewa hatac dahec wanʒac? Néŋ ini imuac ménda waŋaŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Héŋgic amagina imi kisi wammac. Énézéwa niŋgic, ini ni ménda némma kecgicnec nalé méŋ hayu ini yomuhuc ʒéma legic héinémmu; Miŋ Kewuac qaraiguc hahaya imi mériaŋaguc. ");
INSERT INTO kgf_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yesunéŋ Sabata méŋiguc Farisaio ic galeŋgina méŋac amayaiguc nene nemaŋ ʒéma eŋec. Eŋu tosaranéŋ Yesuac awima naŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Waŋu ninʒu, imuaru iwac wésiaiguc ic méŋ nénémériŋ hicŋimimia méŋ tarec. ");
INSERT INTO kgf_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesunéŋ Farisaio ic qesiénécmima ʒéyec; Sabataiguc hafi mehiaru énécmimia imi niŋgic hia wanʒac me qahac? ");
INSERT INTO kgf_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Imuhuc ʒéyu ieneŋ acgina qaiyu tackecgic, Yesunéŋ ic imi késa osimima mehiaruma méliyu keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Keŋu Yesunéŋ ac bakia melemma yomuhuc ʒéyec; Sucginaiguc méŋnéŋ Sabataiguc naŋa me burumakaoyanéŋ baec séséŋiguc hiŋgacʒaciguc ménda héréyu érémac me? ");
INSERT INTO kgf_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Imuhuc qesiyu ieneŋ ac bakia melemmuac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Héihéré énécmimia eneŋ tatac eŋeŋa késa tacgic inicma séséc ac yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Méŋnéŋ ʒammaréŋac ségiségiiguc héihéré énécmiyu kemmuiguc tatac eŋeŋaiguc ménda tacmu. Ic kuneŋ gi gogicʒac méŋ héihéré miyu hawac niŋac. ");
INSERT INTO kgf_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hamaciguc miŋina gi ʒéma i héihéré érécmiyec iminéŋ hama tatacga imi ic yomuac wai miwésémaŋ ʒéma gézéyu imuaru gi gamuga nimma tatac tetecgia hezac imuaru kemma tacbaŋ niŋac. ");
INSERT INTO kgf_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Imuac héihéré géŋu kemma tatac tetecgiaiguc hezac imuaru tacbésémaŋ. Imuhuc wanna ic héihéré géŋec iminéŋ hama guac ʒéma alana eri emma tacna ʒéyu momacnec tacgic ionac kicginaiguc eebipigaguc wambésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Méŋnéŋ méŋ eŋeyaoc mepési amuyu memamimac. Waŋu méŋnéŋ méŋ eŋeyaoc memaamuyu meemmimac. ");
INSERT INTO kgf_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Waŋu miŋina Yesu héihéré miyec iwac yomuhuc ézéyec; Gi gau komoc me mariaiguc nene gumu énécmimaŋ ʒé alahécga, dac munahécga, sac kitichécga, ʒéma soukiwa ic ménda héihéré énécmiwésémaŋ. Imuhuc wambaŋnec ieneŋ imuhucyanec héihéré géŋgic bakia guac liliŋgéyu késawaŋ niŋac. ");
INSERT INTO kgf_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Imuac ségiségi hai énécmimaŋ ʒé maqeqeya, héna méria séléc sélécgia, puriŋ ʒéma kichilic ionac héihéré énécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Imuhuc wambésémaŋiguc ieneŋ bakia meleŋ gémmuac séc qahac wammac. Imuac niŋ gi ʒézé ségiségigaguc wambésémaŋ. Waŋu kecma ic solaŋa ionac yacyac naléiguc bakia meleŋgéŋu mewésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Imuhuc ʒéyu momacnec tacgic sucgina igucnec méŋnéŋ ac imi nimma yomuhuc ʒéyec; Anutuac héŋgaleŋ ama areŋa yandaiguc nene nemu imi eneŋ ségiségi mihicŋi énécmimia wammac. ");
INSERT INTO kgf_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Imuhuc ʒéyu Yesunéŋ yomuhuc ʒéyec; Ic méŋnéŋ nene yanda gumu énécmimaŋ ʒé ic embac sasala héihéré énécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Waŋu imuac naléya ducŋiyu héihéré énécmimia ionac muru weleŋ qeqe icya mélimiyu kemma yomuhuc énézéyec; Hagic iwawai mocʒoŋ mézézéŋ gédacʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Waŋu ic embac mocʒoŋ yomuhucyanec hénima héikeŋʒé héihaʒé wandacgic. Ic walac walacnéŋ yomuhuc ʒéyec; Ni erac héihimic baec méŋ boŋ mezua. Ʒéwelec énécmizua, waina kemma ai imi hémmaŋ ʒé wanʒua. ");
INSERT INTO kgf_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Waŋu méŋnéŋ yomuhuc ʒéyec; Ni imi ai memeac burumakao iwa 10 boŋ mezua. Imuac kemma ai hia mezu me qahac batucgé énécmimaŋ ʒé wanʒua. Imuac bénʒéŋdac niŋnénna. ");
INSERT INTO kgf_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Waŋu ic méŋnéŋ yomuhuc ʒéyec; Ni embacna degucmi mezua imuac hamaŋac séc qahac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Imuhuc ʒégic weleŋ qeqe icnéŋ liliŋgéma hama miŋgina ézéma hicŋiyec séc ézéyu nimma qeri biric nimma weleŋ qeqe icya yomuhuc ézéyec; Focdac tauŋ imuac héna yanda ʒéma héna komora séc kemma ic maqeqeya ʒéma héna méragina séléc sélécgia ʒéma kichilic ʒéma puriŋ kecʒu séc onagicma hamu. ");
INSERT INTO kgf_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Waŋu weleŋ qeqe ic inéŋ ʒéyec séc wandacma yomuhuc ézéyec; Miŋna ʒézaŋ éséc wandacʒua waŋu tatac imi sasala hezacnec. ");
INSERT INTO kgf_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ʒéyu ézéyec; Héna séra tosara ʒéma demiŋ giŋgiŋa séc kemma ic embac qeriganéŋ mocʒoŋ héihéré énécmina amana imi kuaya qemu. ");
INSERT INTO kgf_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ni gézéwa ninna, becnec héihéré énécmiyi ionarunec méŋnéŋ méŋ nuac ohaihaina imi méŋ ménda batucgéma nemac. ");
INSERT INTO kgf_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ic tuŋ yandanéŋ Yesu méndacmima keŋgic Yesunéŋ ionac liliŋgéma yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Méŋnéŋ méŋ nuac muru hama imi eŋeya neŋgoc maŋgocya, iniŋ merachéra, dac munahéra, nauŋhéra ʒéma eŋeya kekec imi momacnec haʒéc ménda waŋ énécmimac iguc imi nuac tohotoho ic wammacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Méŋnéŋ méŋ eŋeya ic héŋgeŋa wéndara imi ménda huama méndac némmac imi nuac tohotoho ic wammacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Onarunec méŋnéŋ galeŋ meme ama héŋgeŋa horua méŋ memaŋac ʒé ninʒaciguc inéŋ iwawai késakecʒac iminéŋ ai imi mocʒoŋ metecgémacac sécya wanʒac me qahac imi niŋgésimaŋ ʒé walac soukiwa ménda tacma oloŋnimmac me? ");
INSERT INTO kgf_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Imuhuc niŋgési ménda wamma hénia sac meyacgéma metecgémacac séc qahac waŋu ic embac eneŋ hémma yomuhuc ʒédesi wammiwu niŋac; ");
INSERT INTO kgf_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ic yomi amaya meyacgémaŋ ʒé aiya héniyec, néŋ metecgémacac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Waŋu ic kewu méŋnéŋ ic kewu méŋ qemaŋ ʒé yaréiguc kemmaŋ ʒéma walac tacma yaré ichéra 10 tauseŋ iminéŋ haʒécya yaré ichéra 20 tauseŋaguc hazac imi hia qemaŋac séc me qahac ʒéma ménda niŋgésimac me? ");
INSERT INTO kgf_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Waŋu niŋu ménda sécgéyu haʒécya lakec hamanec naŋu kua meme ic mélimima luae qemaoc niŋac welecmimac. ");
INSERT INTO kgf_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Imuhucyanec onarunec méŋnéŋ iwawaiya mocʒoŋ ménda waimaciguc nuac tohotoho ic wammac ac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sei imi iwawai qacguc, néŋ siŋa qahac waŋu némacnéŋ mindiŋigic siŋaguc wammac? ");
INSERT INTO kgf_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Imi mia baec aiiguc me guwec qahaiguc haimuac séc qahac waŋu giligic kendacmac. Gezacginaguc ieneŋ ac imi nimmu. ");
INSERT INTO kgf_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Takis meme ic ʒéma biria meme ic eneŋ mocʒoŋ ackuaʒéc nimbiŋ ʒéma hosucgémigic. ");
INSERT INTO kgf_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Waŋu Farisaio ic ʒéma héna acac kiwi ic eneŋ andé lukuc qema yomuhuc ʒégic; Biria meme ic héihéré énécmima iniguc momacnec nene nezac. ");
INSERT INTO kgf_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ʒégic Yesunéŋ qepaiŋ ac yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Onarunec mérénéŋ rama 100 késa keru sucgina igucnec méŋnéŋ sohozaciguc, 99 imi ɋézézac baeciguc wai énécmima momacguc sohozac imuac mihicŋimacac séc ménda kemma hocmac me? ");
INSERT INTO kgf_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Waŋu mihicŋimaciguc ségiségi wamma huama hamac. ");
INSERT INTO kgf_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Waŋu amaiguc hama alahéra ʒéma ama areŋ momachéra héihéré énécmima yomuhuc ʒémac; Ramana méŋ sohoyu mihicŋizua. Imuac niguc ségiségi wanni. ");
INSERT INTO kgf_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Énézéwa niŋgic, imuhucyanec biria meme ic méŋnéŋ ewaya meleŋu kurumeŋiguc ségiségi kuneŋ yanda hicŋimac. Waŋu ségiségi iminéŋ ic solaŋa 99 ewa qerigina melemmuac ménda hezac ionac niŋ ségiségi waŋanʒu imi ogicmac. ");
INSERT INTO kgf_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Embac méŋac muru soukiwa 10 hemiyu sucgina igucnec méŋ sohozaciguc mihicŋimaŋac ʒéma kifa otorima ama usuŋma ménda hocma kecmac me? Imuhuc wamma keŋkecma mihicŋimaguc hochoc ai imi waimac. ");
INSERT INTO kgf_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mihicŋizaciguc alahéra ʒéma ama areŋ momachéra héihéré énécmima, Niguc ségiségi wanni, ni siliwa soukiwa momacguc sohoyu hocma mihicŋizua, ʒéma énézémac. ");
INSERT INTO kgf_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Énézéwa niŋgic, hénia imuhucyanec biria meme ic méŋnéŋ ewaya meleŋu Anutuac kua meme uŋa ionaru ségiségi yanda hicŋi énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Imuhuc ʒéma Yesunéŋ muŋguc toroqema ʒéyec; Ic méŋaru naŋhéréra keroc. ");
INSERT INTO kgf_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Keric munianéŋ maŋgocya yomuhuc ézéyec; Maŋgoc, guac iwawaiga imuarunec nuac buŋa hezac imi nénna. Imuhuc ʒéyu maŋgocyanéŋ iwawai imi méndémma érécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Waŋu ai meme sasala ménda keŋu munayanéŋ iwawai mocʒoŋ haima soukiwaya mema baec méŋiguc lakec kemma imuaru kaiʒiliweŋ wamma iwawaiya imi mocʒoŋ eŋdac sicsaoc gilidarec. ");
INSERT INTO kgf_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Gilidaru qahac waŋu baec imuaru béti yanda hicŋiyec. Hicŋiyu inéŋ maqeqeya wamma iwawai niŋac wamma horec. ");
INSERT INTO kgf_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hocma ama areŋa yanda imuac miŋina ionarunec méŋac muru qékétama keru inéŋ ic imi beric galeŋgé énécmimac niŋac baec kisiaiguc mélimiyu keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kemma nene beric eneŋ neaŋgic imi neyu tomeŋa hélaguc wammac niŋac niŋec. Waŋu méŋnéŋ méŋ iwawai méŋ ménda miyec. ");
INSERT INTO kgf_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Imuac ewaya melemma yomuhuc niŋec; Maŋgocnawac ai ichéra imi daheac séc sasala kecma nene negic sécgé énécmiyu saméŋaguc heanʒac, waŋu ni you béti wamma humumaŋ ʒé wanʒua. ");
INSERT INTO kgf_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ni yacma maŋgocnawac kemma yomuhuc ézémaŋ; Maŋgoc ni kurumeŋ ʒéma guac kicgaiguc haka biria waŋi. ");
INSERT INTO kgf_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Degucmuacnec hénima guac naŋga ʒénémmuac séc ménda wanʒua, imuac nuac niŋ ninna soukiwa ai icga wammaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Imuhuc ʒéma nimma inéŋ yacma maŋgocyawac muru liliŋgéma keŋec. Kemma lakec hama naŋunec maŋgocyanéŋ i héŋtegicma wéséniniŋ wamma usuŋnec kemma ewayaiguc giliyu meyu tétécgéma kiric nemiyec. ");
INSERT INTO kgf_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kiric nemiyu naŋanéŋ yomuhuc Maŋgoc ézéyec; Ni kurumeŋ ʒéma maŋgocna guac muru képésic mihicŋiyi. Deguc muacnec nuac niŋ guac naŋga ʒénémbésémaŋac séc ménda wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Imuhuc ac ʒéyec. Waŋu maŋgocyanéŋ weleŋ qeqe ichéra yomuhuc énézéyec; Maleku hiabia mema hama héimima méria merawaiguc bineŋ haimima héna usuya héimigic. ");
INSERT INTO kgf_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Waŋu kemma burumakao merawa halécyaguc méŋ héréma hama qegic oma nema ségiségi wanni. ");
INSERT INTO kgf_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Naŋna yomi humuyec, néŋ ɋelizac, waŋu sohoyec, néŋ hicŋinénʒac imuhuc ʒéyu, nimma ségiségi waŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Waŋu méréc merac naŋanéŋ aiiguc kecma liliŋgéma hama ama hosuraiguc hama legic hirigic imuac hétéŋa niŋec. ");
INSERT INTO kgf_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nimma weleŋ qeqe ic méŋac qaru hayu qesimiyec; Haka wanʒu imi némac niŋ? ");
INSERT INTO kgf_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Qesiyu yomuhuc melemma ʒéyec; Guac munaganéŋ yaŋ hafi qahac, néŋ hia liliŋgéma hayu maŋgocganéŋ burumakao merawa halécyaguc méŋ qezac. ");
INSERT INTO kgf_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Imuhuc ʒéyu inéŋ qeri biric wamma ménda emmaŋ ʒé waŋu maŋgocyanéŋ mama ʒéwelecmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Waŋu inéŋ melemma maŋgocya yomuhuc ézéyec; Ni yawuŋ sasala weleŋ qegémma guac kuaga tohoma kecanʒua, néŋ nuac imi ala hécna iniguc aria mewiŋ niŋac noniŋ merawa méŋ méndadac nénnec. ");
INSERT INTO kgf_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Waŋu naŋga yomi guac iwawaiga mema kemma héna yanda embac iniguc nedacma liliŋgéyu iwac niŋ wamma burumakao merawa halécyaguc méŋ qezaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Imuhuc ʒéyu maŋgocyanéŋ yomuhuc ʒéyec; Gi imi nalé séc niguc kecanʒaŋ imuac nuac iwawai imi mocʒoŋ guac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Waŋu guac munaga yominéŋ humuyec, néŋ ɋelizac. Sohoyec, néŋ hicŋi nénʒac. Imuac neŋaŋ ʒézé ségiségi wamma ariac wambiŋac hezac. ");
INSERT INTO kgf_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesunéŋ tohotoho ichéra yomuhuc énézéyec; Ic soukiwa yandayaguc méŋac ama galeŋa méŋ kerec. Waŋu ai ic iminéŋ miŋinawac iwawaiya eŋ auanʒac ʒégic miŋinanéŋ niŋec. ");
INSERT INTO kgf_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nimma miŋinanéŋ ic imi héihéré mima ézéyec; Guac ac ʒégic ninʒua imi némac ac? Ama galeŋ ai imi muŋguc ménda mewésémaŋ, imuac ai dimuhuc galeŋ menec imuac hénia imi oma nénna. ");
INSERT INTO kgf_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Imuhuc ʒéyu ama galeŋa imi qerianéŋ yomuhuc niŋec; Miŋnanéŋ ama galeŋ ai imi nuagiru dimuhuc wammaŋ? Usuŋna qahac imuac baec ésémaŋac séc qahac. Waŋu iwawai niŋac welecmaŋ ʒé gamuna ninʒua. ");
INSERT INTO kgf_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Owec! Némacac wammaŋ imi niŋasarizua. Imuhuc wamba aina nuagicmac imuac andiaiguc ieneŋ eŋaŋ amaginaiguc ni héihéré némmu. ");
INSERT INTO kgf_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Inéŋ imuhuc ʒéma ic embac miŋinawac taséya he énécmizac séc unuruyu ic méŋ walac hayu yomuhuc qesimiyec; Guac muru miŋnawac taséya dahec hegénʒac me? ");
INSERT INTO kgf_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Qesiyu ʒéyec; Oliwa hénéŋ baŋa yanda 100 meyi. Imuhuc ʒéyu ʒéyec; Focdac tacma you guac tasé kiwiga yomi mema 50 imi sac ona heyu. ");
INSERT INTO kgf_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ʒéyu tecgéyu ic méŋac qesimiyec; Gi guac muru tasé dahec hezac? Qesiyu ʒéyec; Wit padi gésé yanda 100 meyi. Imuhuc ʒéyu ʒéyec; Gi tasé kiwiga yomi mema imuaru 800 sac ona hemac. ");
INSERT INTO kgf_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Miŋinanéŋ ama galeŋ biria iminéŋ ai imi imuhuc niŋtegic qiŋtegicyaguc meyu mepésimiyec. Imuac, baec yomuac nambérac héra eneŋ baec yomuac asac mararaŋac nambérac héra onogicma eŋaŋ hicŋisai sucginaiguc niŋtegic qiŋtegic ginaguc ai meanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Imuac yomuhuc ʒéwa niŋgic; Baecac soukiwa iminéŋ alahécgina méra énécmigic baecac iwawai imi qahac wammac nalé imuaru kekec hémbénaŋa ama imuaru héihéré énécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Méŋnéŋ méŋ ai komodiawac hélanec meanʒac iminéŋ ai kuneŋ yandawac imuhucyanec hélanec memac. Ai komodiawac ikoc ikoc waŋanʒac iminéŋ ai kuneŋ yandawac imuhucyanec ikoc ikoc wammac. ");
INSERT INTO kgf_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ini baecac iwawai méraginaiguc haigic hélanec ménda galeŋ géanʒuiguc mérénéŋ iwawai héla méraginaiguc hai énécmimac? ");
INSERT INTO kgf_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ini ic tosara ionac iwawai hélanec ménda galeŋ géanʒuiguc mérénéŋ eŋaŋ buŋa énécmimac. ");
INSERT INTO kgf_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Weleŋqeqe momacnéŋ miŋ kewu éréhéc weleŋ qeérécmimacac séc qahac. Imuhuc wammaciguc méŋac haʒéc wammima méŋac eeya héimimac. Waŋu méŋac niŋu eŋeŋa waŋu méŋac niŋu mamaya wammac. Imuac ini baecac iwawai ʒéma Anutu momacnec mepési érécmimuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisaio ic, soukiwa niŋac hémbaoc wawaŋa, ieneŋ imi mocʒoŋ nindacma desimigic. ");
INSERT INTO kgf_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Desimigic Yesunéŋ yomuhuc énézéyec; Ini eŋaoc ic embac kicginaiguc mepési amuanʒu. Waŋu Anutunéŋ ewa qerigina ninʒac. Waŋu ic embac sucginaiguc mepési énécmiyu eŋeŋa wanʒu, néŋ Anutuac kiwaiguc imi ewa loloŋaguc wammac. ");
INSERT INTO kgf_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Héna ac ʒéma Anutuac tiliŋ tiliŋ ic ionac naléya imi éréma Yohane hicŋiyu tecgéyec. Imuac andiaiguc éréma deguc Anutuac héŋgaleŋ ama areŋa yandawac buŋa suruc hiabia énézégic icya embacya imuaru seliseli wamma kereŋanʒu. ");
INSERT INTO kgf_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Baec kurumeŋ imi hia aulaŋgémac, néŋ héna ac imi kiwi kiticya méŋ ménda qahac wamma hélaguc wandacmac. ");
INSERT INTO kgf_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mérénéŋ iniŋa waima embac méŋ mezac imi kaisero wanʒac. Mérénéŋ embac waimimia imi mezac imi imuhucyanec kaisero wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Baec méŋu soukiwa ic méŋ kerec. Inéŋ maleku ɋouc ɋoucgia ʒéma maleku qara lineŋ hiabia imi héima naléya naléya kekec qaqula kecaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Waŋu soukiwa ic iwac demiŋac nagu andiaiguc welec welec ic méŋ kerec. Qara imi Laʒaro. Waŋu inéŋ wizi selianéŋ kima hoturumiyu imuaru heaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","hema soukiwa ic iwac ʒae igucnec nene boporoŋa mayu nemaŋ ʒé wamma heaŋec. Imuacnec sac qahac, kazu eneŋ acguc hama wiziya bézéaŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Waŋu keŋkecma welec welec ic imi humuyu kua meme uŋa eneŋ wagicma emma Abarahamac qéhéréŋaiguc opocgic taru soukiwa ic imuhucyanec humuyu téŋgégic. ");
INSERT INTO kgf_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Inéŋ humumia ionac baec dumuŋaiguc qenʒeŋ manʒeŋ nimma kiwa hima héŋu ou lakecnec Abaraham taru iwac qéhéréŋaiguc Laʒaro taru irirec. ");
INSERT INTO kgf_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iricma yomuhuc ʒéyec; Maŋgocna Abaraham wéséga niŋnémma Laʒaro mélina méria susurianéŋ dokuiguc tinduŋgéma hama ezelaŋnaiguc héiyu saŋgeŋ qeyu. Ni you geric bélaŋ qeriaiguc qenʒeŋ manʒeŋ yanda qezua. ");
INSERT INTO kgf_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Imuhuc ʒéyu Abarahamnéŋ ézéyec; Merac, gi imi baeciguc kecnec imuaru iwawai hiabia géŋu késa kecna, Laʒaronéŋ qenʒeŋ manʒeŋ qeriaiguc kerec imi niŋyacgéwésémaŋ. Deguc ic yomi ewaya mehiaru miyu taru gi imuaru imuhucyanec qenʒeŋ manʒeŋ qema kecʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Imi sac qahac, nini ʒéma ini sucninaiguc sia yanda haiyu hezac. Imuac niŋac yomuacnec imuaru kembiŋ ʒé wanʒu eneŋ kemmuac séc qahac. Waŋu imuacnec you hawiŋ ʒé wanʒu ieneŋ acguc hamuac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Imuhuc ʒéyu melemma ʒéyec; Imuhuc waŋu maŋgoc welecgémba niŋnénna, Laʒaro mélimina nena maŋgocnawac amaiguc kemmac. ");
INSERT INTO kgf_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ni dacmuna hécna méra méŋ kecʒu imi énézémac. Qahac waŋu kecma qenʒeŋ manʒeŋac geric sia yomuaru ieneŋ acguc hawu niŋac. ");
INSERT INTO kgf_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Imuhuc ʒéyu Abarahamnéŋ ʒéyec; Ionac muru Moseac héna ac ʒéma Anutuac tiliŋ tiliŋ ic ionac kiwi téréya he énécmizac, waina imuac oloŋgic nimmu. ");
INSERT INTO kgf_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ʒéyu ara melemma ʒéyec; Imi qahac, maŋgoc Abaraham, humuc ic ionarunec méŋnéŋ liliŋgéma kemma énézémaciguc kileŋdac nimma ewagina melemmu. ");
INSERT INTO kgf_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Imuhuc ʒéyu melemma ʒéyec; Mose ʒéma kua meme ic ionac kuagina ménda tohozuiguc humuc ic ionac murunec méŋnéŋ ɋelima kemma hinocgé énécmimaciguc ménda ninʒéŋgému. ");
INSERT INTO kgf_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Imuhuc ʒémaguc Yesunéŋ tohotoho ichéra yomuhuc énézéyec; Manambatuc imi qahac wammacac séc qahac. Waŋu méŋnéŋ méŋ manam batuc mihicŋi énécmianʒac imi saecyaguc. ");
INSERT INTO kgf_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nambérac komoc komoc yomuhucya sucgina igucnec méŋ manam batuc wammima mebirimacac hezaciguc imuac bakia ménda mema hoc yanda déméŋaiguc ʒikimima naŋgémigic konduŋiguc hiŋgacmac iminéŋ séc méŋ efefia wammac. ");
INSERT INTO kgf_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Imuac eŋaoc galeŋ meamumu. Guac ninʒéŋ ninʒéŋ dac munahécga ionarunec méŋnéŋ képésic waŋu ac ʒémimu. Waŋu ewaya melemmaciguc képésicya imi waiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kaiwe momacgucac qeriaiguc hatac 7 haka biria wamma guaru hatac 7 muŋguc muŋguc hama ewa qerina melenʒua ʒéyu kileŋdac képésicya imi waidacbésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Waŋu Yesunéŋ imuhuc ʒéyu, Yesuac Méliméli ic ieneŋ Miŋ Kewu yomuhuc ézégic; Ninʒéŋ ninʒéŋnina meyandi nénécmiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Imuhuc ʒégic melemma ʒéyec; Ninʒéŋ ninʒéŋgina imi delaŋ gocmiawac sécya komodia he énécmiyu, saŋsaŋ ic yomuac héréma kemma konduŋiguc hiŋgacma naŋna ʒéna iminéŋ guac ac imuhuc bec tohowacnec. ");
INSERT INTO kgf_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Weleŋ qeqe icga méŋ kinoŋnéŋ baec ai éséanʒac me rama galeŋgéanʒac imuhucya késa kecʒuiguc onarunec mérénéŋ ic imi ai igucnec liliŋgéma hayu hama hosucnu tacma nene newésémaŋ ʒéma ézémac me? ");
INSERT INTO kgf_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Qahac, imuhuc ménda ʒéma néwécgeŋac yomuhuc ézémac; Rikuŋga ʒikima nenena ohaima weleŋ qenénna. Gi imi ni newa tecgéyuguc newésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Waŋu weleŋ qeqe icnéŋ ʒézac séc tohoma waŋu, miŋinanéŋ ewa hia ac wammimac me? Qahac imuhuc ménda wammac. ");
INSERT INTO kgf_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Imuhucyanec ini acguc ai ʒéénécmimia imi mocʒoŋ wandacmuiguc yomuhuc ʒédacmu; Nini imi weleŋ qeqe eŋomia. Nonac ai buŋa mewiŋac ʒézéya hezac imi mia meziŋ. ");
INSERT INTO kgf_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesunéŋ Yerusalem kemmaŋ ʒé Galilaia ʒéma Samaria baec sucgiraiguc keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Keŋkecma ama areŋ komora méŋiguc kereŋu wizi selia warihaguc ic méra éréhécnéŋ Yesu mihicŋima lakec naŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Namma ewagina megic eŋu yomuhuc qacma ʒégic; Kiwi ic Yesu, nonac niŋ wéséga waŋu! ");
INSERT INTO kgf_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ʒégic inicma énézéyec; Ini kemma séwigina hofac oo ic énézégic hémmu. Imuhuc ʒéyu nimma kemma hénaiguc solaŋa wandacgic. ");
INSERT INTO kgf_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Waŋu ionarunec méŋnéŋ hiaruyec imi hémma liliŋgéma ewaya kuneŋ yandanec meyacma Anutu mepé qepési waŋ mimanec hayec. ");
INSERT INTO kgf_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hama Yesuac hénayaiguc mama sicgéma pakaya baeciguc héima ewa hia ac ézéyec. Waŋu ic imi Samaria ic. ");
INSERT INTO kgf_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Waŋu Yesunéŋ qesimima ʒéyec; Ic 10 mocʒoŋ hiaruzu, néŋ ic 9 imi dimia? ");
INSERT INTO kgf_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ic enia yomi qahac waŋu Anutu mepésimaŋ ʒé méŋnéŋ méŋ ménda hayu hénʒua. ");
INSERT INTO kgf_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Imuhuc ʒéma ic imi yomuhuc ézéyec; Yacma kenna, guac ninʒéŋ ninʒéŋganéŋ aŋgéŋga tizac. ");
INSERT INTO kgf_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farisaio ic tosaranéŋ Anutuac héŋgaleŋ ama areŋa yanda imi némac naléiguc hamac niŋac Yesu qesimigic, inéŋ yomuhuc melemma ʒéyec; Anutuac héŋgaleŋ ama areŋa yanda imi héhéŋac séc ménda hamac. ");
INSERT INTO kgf_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Imuac you tacʒac me eri tacʒac imuhuc ʒéwiŋac séc qahac. Anutuac héŋgaleŋ ama areŋa yanda imi sucginaiguc tacʒac. ");
INSERT INTO kgf_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Imuhuc ʒéma toroqema tohotoho ichéra yomuhuc énézéyec; Nalé méŋ hayu ini Icac Naŋa iwac naléya momacgucdac hémbiŋ ʒé ewa ewa wammu, waŋu ménda hémmu. ");
INSERT INTO kgf_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nalé imuaru ic embac eneŋ, Héŋgic you tacʒac. Héŋgic, eri tacʒac ʒému, néŋ ini ménda keŋ inicmu me ménda méndac énécmimu. ");
INSERT INTO kgf_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Piliticnéŋ asariyu kurumeŋac bawaiguc néwécnec néwéc mocʒoŋ asarianʒac ésécnec Icac Naŋanéŋ naléyaiguc imuhucyanec hayu héndacmu. ");
INSERT INTO kgf_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Waŋu inéŋ walac walac qenʒeŋ manʒeŋ sasala hicŋimiyu niŋu nalé yomuac hicŋisainéŋ andé qemimu. ");
INSERT INTO kgf_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Icac Naŋa iwac naléya hayu haka Noawac naléyaiguc hicŋiyec imuhucyanéŋ hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ic embac ieneŋ nene ʒéma doku selia siŋa nimma nema icnéŋ embac meyu embacnéŋ ic mema kecgic Noanéŋ ʒéic yanda qeriaiguc eŋec. Eŋu doku luma unuma hoturu énécmidarec. ");
INSERT INTO kgf_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Waŋu nalé imi imuhucyanec Lotac naléya ésécnec wammac. Lot kerec imuaru ic embac eneŋ nene ʒéma doku seli nema nénnagémba wamma iwawai himicma amagina megic. ");
INSERT INTO kgf_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Imuhuc memanec naŋgic, Lot inéŋ Sodom ama areŋa imi waima keŋec kaiwe imuaru, kurumeŋ igucnec geric ʒéma salfanéŋ kia yanda ésécnec mama unuyu qahac wandacgic. ");
INSERT INTO kgf_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Icac Naŋa hicŋimac nalé imuaru haka imuhucya hicŋimac. ");
INSERT INTO kgf_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nalé imuaru ic méŋnéŋ ama qahaiguc nammaciguc iwawai ama qeriaiguc hezac imi memaŋ ʒé ménda mama emmac. Ic méŋ aiiguc nanʒac imi acguc iwawai méŋ niŋac ménda liliŋgéma kemmac. ");
INSERT INTO kgf_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ini haka Lot iniŋawac muru hicŋiyec imi niŋyacgému. ");
INSERT INTO kgf_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Méŋnéŋ méŋ eŋeya kekecya aŋgé timaŋ ʒé waŋu kekecya imi sohomac, néŋ méŋnéŋ kekecya waimac iminéŋ keckecya aŋgé timac. ");
INSERT INTO kgf_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Énézéwa niŋgic, siŋi imuaru ic éréhéc ekawu gau heyic méŋ késama méŋ waimac. ");
INSERT INTO kgf_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Embac éréhécnéŋ hoc hilaŋanéŋ wit gocmia héʒéʒama taric méŋ késama méŋ waimac. ");
INSERT INTO kgf_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ic éréhécnéŋ baec aiiguc keric méŋ késama méŋ waimac. ");
INSERT INTO kgf_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Imuhuc ʒéyu qesimigic; Miŋ Kewunina, imi baec dimuaru hicŋimac? Waŋu Yesunéŋ melemma ʒéyec; Qamoc hemac imuhucgeŋ mia kunta tocgému. ");
INSERT INTO kgf_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nalé séc ʒéwelecma kucmama ménda wammu niŋac Yesunéŋ qepaiŋ ac yomuhuc ʒéma énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ama areŋa yanda méŋiguc ʒégésigési ic méŋ kerec. Inéŋ Anutu ehéihéi ménda wammiaŋec. Waŋu ic embac ionac imuhucyanec eegina ménda héiaŋec. ");
INSERT INTO kgf_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Waŋu ama areŋa yanda imuaru embac malé méŋ kerec. Inéŋ hatac sasala gésigési ic iwac muru kemma yomuhuc ʒéma welecmiaŋec; Héna aciguc ʒésolaŋima nuac haʒécna kitiwa wammiwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Imuhuc weleru suraiguc inéŋ ara nimmimaŋ niŋ ménda waŋec, néŋ imuac tetecgiaiguc i eŋeyaoc yomuhuc ʒéma niŋec; Hélacnec, ni Anutuac niŋac ʒénéŋna ménda hirianʒac. Waŋu ic embac ionac ehéihéi ménda waŋ énécmianʒua. ");
INSERT INTO kgf_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Néŋ embac malé yomi ʒézé meme waŋ néŋanʒac imuac haʒécyawac kitiwa memiwa muŋguc ménda hama pipinémmac. ");
INSERT INTO kgf_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Séséc ac imuhuc ʒéma Miŋ Kewunéŋ énézéyec; Gésigési ic birianéŋ ac ʒézac imuac gezac qema niŋgic. ");
INSERT INTO kgf_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Waŋu Anutunina hiabianéŋ eŋeya gési énécmimia eneŋ siŋiya siŋiya kaiweya kaiweya qacma welecmigic ménda niŋénécmimac me? Inéŋ seli seli wamma hia qeqetali waŋ énécmimac me? ");
INSERT INTO kgf_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Énézéwa niŋgic, inéŋ acgina focdac niŋénécmimac. Waŋu Icac Naŋa hamac imuaru inéŋ baeciguc ninʒéŋ ninʒéŋ komodia méŋ he énécmiyu hia inicmac me? ");
INSERT INTO kgf_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Waŋu ic embac eŋaŋ haka niŋac nimma dindiŋa ʒéma ninʒéŋgéma ic embac tosara memaénéc mianʒu ionac niŋ Yesunéŋ séséc ac yomuhuc énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ic éréhécnéŋ ʒéwelecbic ʒé ocmuŋ téréyaiguc eŋoc. Iorarunec méŋnéŋ Farisaio ic, waŋu méŋnéŋ takis meme ic. ");
INSERT INTO kgf_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisaio ic iminéŋ namma eŋeyawac yomuhuc ʒéma ʒéwelerec; Anutu, ni imi ic tosara ikoc waŋ énécmima iwawai onagicanʒu imuhucya, me biria meme ic, me kaisero ic, me takis meme ic yomuhucya ésécnec qahac imuac niŋ guac ewa hia ac gézézua. ");
INSERT INTO kgf_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ni imi Sonda séc ai meme éréhéc nene ʒikima ʒéwelecanʒua. Waŋu imi sac qahac iwawai mema méndémba 10 waŋu sucginaiguc momacguc imi guac buŋa ʒéma haigéŋanʒua. ");
INSERT INTO kgf_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Waŋu takis meme ic iminéŋ lakecnec namma kiwa hima Anutu hémmaŋ ʒé osima eŋeya tétécya qema yomuhuc ʒéyec; Anutu wéséniniŋ waŋ nénna ni imi képésic ic. ");
INSERT INTO kgf_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ʒéwa niŋgic, méŋ eŋeyawac mema eŋu Anutunéŋ memamimac. Waŋu méŋ eŋeyawac mema mayu Anutunéŋ meemmimac. Hénia imuac niŋ Farisaio ic qahac, néŋ takis meme ic iwac mia Anutunéŋ wésia nimmima solaŋa ʒéyu nimma liliŋgéma keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ic embac eneŋ Yesunéŋ mérianéŋ osiénécmimac niŋac merac komoc komoc onagicma hagic tohotoho ichéra eneŋ ʒéqetali waŋ énécmigic. ");
INSERT INTO kgf_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Waŋu Yesunéŋ merac komoc komoc imi unuruyu hosuru hagic yomuhuc énézéyec; Waigic nambérac nuac muru hamu, ménda qetali énécmimu. Anutuac héŋgaleŋ ama areŋa yanda imi imuhucya ionac buŋa wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ni hélacnec énézéwa niŋgic, méŋnéŋ Anutuac héŋgaleŋ ama areŋa yanda imi merac komocac séciguc ménda tétécgémaciguc imuaru emmacac séc qahac. ");
INSERT INTO kgf_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Imuhuc ʒéyu galeŋ méŋnéŋ yomuhuc qesimiyec; Kiwi ic hiabia, ni néma haka wamma kekec hémbénaŋa imi mératéc késamaŋ? ");
INSERT INTO kgf_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ʒéyu ʒéyec; Gi dimuhuc nuac niŋ hiabia ʒénénʒaŋ? Tosara qahac, néŋ Anutu momacgucnéŋ sac hiabia wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gi héna ac imi ninʒaŋ, kaisero ménda wambésémaŋ, ic kekecya ménda qehumuwésémaŋ, kowu ménda mewésémaŋ, héipuc ac ʒémaŋ ʒé ikoc ac ménda ʒéwésémaŋ, neŋgoc maŋgocga eegira héiwésémaŋ. Imuhuc hezac. ");
INSERT INTO kgf_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Imuhuc ʒéyu ara melemma ʒéyec; Imi mia ni komocna igucnec tohoanʒua. ");
INSERT INTO kgf_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Imuhuc ʒéyu nimma Yesunéŋ yomuhuc ʒéyec; Haka hiabia momacgucnéŋ guaru ménda hezac. Kemma iwawai hegénʒac imi mocʒoŋ haina boŋa géŋgic mema ic maqeqeya méndéŋ énécmina. Imuhuc wanna kurumeŋ amaiguc guac muru iwawai héla hiabia hegémmac. Imuhuc wammaguc hama ni méndacnénna. ");
INSERT INTO kgf_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Waŋu ic imi soukiwa ʒéma iwawai yéwéria hemiyu ackuaʒéc imi nimma ewa biric eŋeŋa waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Imuhuc waŋu Yesunéŋ hémma ewa biric yanda wamma yomuhuc ʒéyec; Ic soukiwa ʒéma hinac yanda ginaguc eneŋ Anutuac héŋgaleŋ ama areŋa yandaiguc kerembiŋ ʒé niŋyéwérima osimu. ");
INSERT INTO kgf_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yaŋ yanda kamelenéŋ qodu kifaŋaiguc ogicma kemmac imuac nimba bénʒéŋa wanʒac. Waŋu ic soukiwa yandayagucnéŋ Anutuac ama yandaiguc keremmac imuac nimba séc méŋ ogicma yéwéria wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Waŋu ac imi niŋgic eneŋ yomuhuc melemma ʒégic; Imuhuc waŋu mérac késayu aŋgéŋ titi hia mihicŋimac? ");
INSERT INTO kgf_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ʒégic ʒéyec; Haihaka ic eneŋ wamma memuac séc qahac imi Anutunéŋ hia wamma memacac séc. ");
INSERT INTO kgf_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Imuhuc ʒéyu Peteronéŋ yomuhuc melemma ʒéyec; Ninicna, nini iwawainina imi mocʒoŋ waima Miŋ Kewu gi méndac géŋanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Imuhuc ʒéyu melemma ʒéyec; Ni hélacnec énézéwa niŋgic; Anutuac héŋgaleŋ ama areŋa yanda niŋac ama geric, me iniŋa, me dac muna, me neŋgoc maŋgocya, me nambérac héra wai énécmiyec imi ");
INSERT INTO kgf_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Baec yomuac naléyaiguc sasala mesaima miyu memac. Waŋu kecma ama baec hémbénaŋa hahaya imuaru kekec hémbénaŋa imi késamac. ");
INSERT INTO kgf_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesunéŋ tohotoho ic 12 onagicma yomuhuc énézéyec; Ninʒu, nini Yerusalem kembiŋ. Kenni iwawai Anutuac tiliŋ tiliŋ ic eneŋ Icac Naŋa niŋac ogic hezac imi mocʒoŋ hélaguc wandacmac. ");
INSERT INTO kgf_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Icac Naŋa ic enia ionac méraginaiguc opocgic gamu qeqe wammima ʒébirimima sépécgémimu. ");
INSERT INTO kgf_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Imuhuc wamma hihilocnéŋ qemaguc qehumugic ai meme haréwéc waŋu humuc igucnec ɋelima yacmac. ");
INSERT INTO kgf_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Imuhuc ʒéyu niŋgic, néŋ tohotoho ichéra eneŋ ac imuac hénia imi komodia méŋ ménda niŋasarigic. Imi mia musaŋgé énécmimia waŋu ac ʒéyec imi ménda niŋasarigic. ");
INSERT INTO kgf_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesunéŋ Yeriko ama hosuraiguc hayu kic hilic méŋnéŋ hénaiguc iwawai niŋac welecma tarec. ");
INSERT INTO kgf_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Inéŋ ic tuŋ méŋ ogicma keŋgic hétéŋ nimma hénia qesiénécmiyec. ");
INSERT INTO kgf_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Qesiyu Naʒarete Yesunéŋ hama kenʒac imuhuc ʒégic niŋec. ");
INSERT INTO kgf_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Imuhuc ʒégic kic hilicnéŋ qacma ʒéyec; Dawidiac ɋeli Yesu, gi nuac niŋ ewa biric wanna. ");
INSERT INTO kgf_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Imuhuc waŋu, ic tosara walac walac keŋgic eneŋ ic imi qetalimima ac waima tacmac niŋac ézégic. Waŋu inéŋ muŋguc yanda qacma, Dawidiac ɋeli, gi nuac niŋ ewa biric wanna! ʒéyec. ");
INSERT INTO kgf_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Qaru Yesunéŋ namma wagicma hamu niŋac énézéyec. Waŋu inéŋ hosuraiguc hayu qesimiyec. ");
INSERT INTO kgf_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Némac iwawai waŋgémmaŋ niŋac wanʒaŋ? Ʒéyu ʒéyec; Miŋ Kewu ni kicna hima hémmaŋ ʒé wanʒua. ");
INSERT INTO kgf_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ʒéyu Yesunéŋ ézéyec; Hénna, guac ninʒéŋ ninʒéŋganéŋ gi mehiaru génʒac. ");
INSERT INTO kgf_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Imuhuc ʒéyu focnec kiwa hima héŋec. Hémma Anutu mepésima Yesu méndacmiyu ic embac mocʒoŋ haka imi hémma Anutu mepésimigic. ");
INSERT INTO kgf_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesunéŋ Yeriko ama areŋa keremma ogicma keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Waŋu imuaru ic méŋ kerec, qara imi Ʒakaio. Ic imi takis meme ic kiwagina kerec. Waŋu ic imi hinac yandayaguc. ");
INSERT INTO kgf_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Inéŋ Yesu imi méré ʒéma kic tanera hémmaŋ ʒé waŋec. Waŋu ic imi ic hotoŋadac, imuac niŋac ic embac sasala naŋgic hémmacac séc qahac waŋec. ");
INSERT INTO kgf_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Waŋu inéŋ hémmaŋ ʒéma usuŋnec kemma héna Yesu hama kemmac imuaru saŋsaŋ ic méŋ naŋu imuac qahaiguc eŋec. ");
INSERT INTO kgf_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eŋu Yesunéŋ imuaru hama kiwa hiyu eŋu hémma ézéyec; Ʒakaio, focdac mama hana ni deguc guac amagaiguc giguc tacbic. ");
INSERT INTO kgf_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Imuhuc ʒéyu inéŋ focdac mama hama ségiségi wamma wagiru keŋoc. ");
INSERT INTO kgf_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ic embac tosaranéŋ iricma andéluku ac yomuhuc ʒégic; Inéŋ biria meme ic iwac amaiguc tachiarumaŋ ʒé enʒac. ");
INSERT INTO kgf_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Waŋu Ʒakaionéŋ namma Miŋ Kewu yomuhuc ézéyec; Miŋ Kewu ninʒaŋ, nuac iwawaina imi sura igucnec hésémma bakia imi ic maqeqeya énécmimaŋ. Ni méŋac muru iwawai méŋ ikoc waŋ énécmima wagiriiguc iwawai wagicma késayi imuac sécya kemboŋ qahac mesaima meleŋ mimaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ʒéyu nimma Yesunéŋ yomuhuc ʒéyec; Ic yomi acguc Abarahamac ɋeli wanʒac imuac niŋ deguc aŋgéŋ tiénécmimia imi ama yomuaru hicŋizac. ");
INSERT INTO kgf_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Icac Naŋa imi ic soho sohoya hocma mihicŋima mehiarumaŋ ʒé hayi. ");
INSERT INTO kgf_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ic embac ieneŋ ac imi nimma yomuhuc ʒéma niŋgic; Yesu imi Yerusalem hazac imuac Anutuac héŋgaleŋ ama areŋa yanda deguc mihicŋi nénécmimac. Waŋu imuhuc niŋgic, séséc ac yomuhuc toroqema énézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ic eŋeŋa méŋnéŋ ic kewuac qac buŋa mema hamaŋ ʒéma buŋa memeac baec lakec heyec imuaru keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nalé imuaru weleŋ qeqe ichéra méra éréhéc unuruma siliwa soukiwa 10 énécmima yomhuc ʒéyec; Soukiwa yominéŋ nénnagémba ai galeŋgéma memanec kecgic ni liliŋgéma hamaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Waŋu ic embachéra ieneŋ haʒéc wammima kua meme ic méŋ mélimigic andiaiguc méndacmima kemma yomuhuc ézéyec; Nini imi ic yominéŋ ic kewu waŋ nénécmimac niŋac ménda wanʒiŋ. ");
INSERT INTO kgf_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Waŋu tinduc ic eŋeŋa imi ic kewu kumumigic kuc buŋa mema liliŋgéma hama siliwa énécmiyu késagic imi eneŋ mesaisai ai dimuhuc megic imi hémmaŋ ʒéma unuruyec. ");
INSERT INTO kgf_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Héihéré énécmiyu ic méŋ walac hayec iminéŋ yomuhuc ʒéyec; Miŋ Kewu guac siliwa momacguc iminéŋ mesaiwa 10 wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ʒéyu miŋinanéŋ ʒéyec; Hia wannec! Weleŋ qeqe hiabia, geŋ ai komodia imi ewaga hélanéŋ menec imuac ai memeac qac buŋaga gémba ama areŋa yanda 10 galeŋgéwésémaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ʒéyu tecgéyu andunéŋ hama ʒéyec; Miŋ Kewu guac siliwa momacgucnéŋ mesaiwa 5 wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Imuhuc ʒéyu miŋinanéŋ iwac imuhucyanec, Ama areŋa yanda 5 galeŋgéna ʒéma ézéyec. ");
INSERT INTO kgf_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Waŋu ic méŋnéŋ hama yomuhuc ʒéyec; Miŋ Kewu, guac siliwa momacguc imi you, ni usunéŋ osowa heyec. ");
INSERT INTO kgf_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Imi mia gi ic qeri gericgaguc imuac niŋ ni ʒénénna hiriyu imuhuc waŋi. Gi imi ménda hainecac meanʒaŋ. Waŋu ménda himicnecac metocgo waŋanʒaŋ. ");
INSERT INTO kgf_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Imuhuc ʒéyu miŋinanéŋ ʒéyec; Weleŋ qeqe biria ni geŋga acga iminéŋnec ac waŋgémmaŋ. Gi imi nuac ninna neŋ ménda haima mema ménda himicma metocgoanʒua me? ");
INSERT INTO kgf_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Imuhuc ninneciguc némac niŋac nuac siliwa imi hofi amaiguc ménda hainec? Gi imuhuc wambaŋnec ni hama siliwa imi imuac héla kosiaguc mewinec. ");
INSERT INTO kgf_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Imuhuc ʒéma ic tosara iwac qéhéréŋaiguc naŋgic ionac yomuhuc énézéyec; Siliwa momacguc imi wagicma ic siliwa 10 késa kecʒac iwac migic késamac. ");
INSERT INTO kgf_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Imuhuc ʒéyu melemma ʒégic; Miŋ Kewu, iwac muru imi bec siliwa 10 hezac. ");
INSERT INTO kgf_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ni énézéwa niŋgic, iwawai késa kecʒac iwac imi muŋguc yanda miyu késamac. Waŋu iwawai ménda késa kecʒac iwac imi komocdia késa kecʒac imi acguc wagiru qahac wammac. ");
INSERT INTO kgf_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Imuhuc ʒéma énézéyec; Waŋu haʒéchécna ni ic kewuac buŋa memaŋ niŋac ménda waŋgic imi onagicma you hama kicnaiguc unuhumugic. ");
INSERT INTO kgf_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesunéŋ ac imuhuc ʒéyu tecgéyu Yerusalem kemmaŋac ʒé walac mema ekeŋec. ");
INSERT INTO kgf_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesunéŋ baec boŋa qara Oliwa imuaru Betfage ʒéma Betania ama hosucgiraiguc kemma tohotoho ichéra sucginaiguc éréhéc méli érécmima yomuhuc érézéyec; ");
INSERT INTO kgf_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ama areŋ wéségiraiguc tacʒac imuaru keŋic. Kemma kereŋic doŋki merawa ic méŋnéŋ qahaiguc ménda emma tarec imi ɋatégic naŋu hémmaoc. Hémma imi hulacma wagicma hamaoc. ");
INSERT INTO kgf_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ic méŋnéŋ némac niŋ hulacʒaoc ʒéma qesi érécmimaciguc yomuhuc melemmaoc; Miŋ Kewunéŋ imuac wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Waŋu méli érécmimia iereŋ kemma ʒéyec séc mihicŋiyoc. ");
INSERT INTO kgf_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mihicŋima doŋki merawa imi hularic imuac miŋhéra ieneŋ ʒégic; Némac niŋ doŋki merawa imi hulacʒaoc? ");
INSERT INTO kgf_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ʒégic melemma ʒéyoc; Miŋ Kewunéŋ imuac niŋ wanʒac. ");
INSERT INTO kgf_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Imuhuc ʒéma doŋki imi héréma hama malekugira imuac qahaiguc haima Yesu ézéyic emma tarec. ");
INSERT INTO kgf_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tacma keŋu tohotoho ichéra eneŋ walac andu kemma malekugina hetecgéma héna yandaiguc lémbécgic keŋec. ");
INSERT INTO kgf_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oliwa boŋaiguc haréma héna hiŋgac hiŋgara imuac hosuraiguc keŋu tohotoho ichéra ieneŋ mocʒoŋ kiwi baec icnéŋ ménda memeya sasala meyu héŋgic imuac niŋac ségiségi wamma qacma Anutu mepésimigic. ");
INSERT INTO kgf_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mepésima yomuhuc ʒégic; Miŋ Kewuac qac buŋa mema hazac, ic kewu imi ségiségiyaguc. Ou kurumeŋiguc luae hezac, ou eŋeŋaiguc edamuya hezac. ");
INSERT INTO kgf_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Imuhuc ʒégic tuŋ ionarunec Farisaio ic tosaranéŋ Yesu yomuhuc ézégic; Kiwi ic guac tohotoho ichécga qetali énécmina. ");
INSERT INTO kgf_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ʒégic melemma ʒéyec; Ic embac imi eneŋ acgina qaiyu kecgic, hoc sasala yominéŋ imuhuc qacmu. ");
INSERT INTO kgf_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Waŋu Yesunéŋ Yerusalem hosuru hama ama areŋa yanda imi hémma siarec. ");
INSERT INTO kgf_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Siacma yomuhuc ʒéyec; Gi nalé yomuac luaeac iwawai héŋ tegicbaŋnec hia wambacnec, kicga hilicgéyu musaŋgé géŋgéŋawac hezac. ");
INSERT INTO kgf_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nalé ducŋiyu guac haʒéchécga ieneŋ hama demiŋ mema lelecgé géŋgic imuac me imuac séc kembiŋ ʒé osimu. ");
INSERT INTO kgf_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Deguc gi Anutu hahayawac nalé imi ménda niŋtegicʒaŋ, imuac gi ʒéma guac nambérac hécga demiŋga qeriaiguc kecʒu imi giligic mama unuyu hoc méŋnéŋ hoc méŋac qahaiguc ménda waigic tacmac. ");
INSERT INTO kgf_vpl VALUES ("LK19_45","072_19_45","LUK","19","