﻿USE sofia;
DROP TABLE IF EXISTS sofia.kfw_vpl;
CREATE TABLE kfw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kfw_vpl WRITE;
INSERT INTO kfw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham khat-um David sapa Jisu Christa, pilepu ngai ramingrui kha hingaihi eii. ");
INSERT INTO kfw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham in Isaac anei; Isaac in Jacob anei, Jacob in Judah khat-um ama unai ngai anei; ");
INSERT INTO kfw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Halli Judah le anumei Tamar in Pharez khat-um Zerah innei, Pharez in Hezron anei, Hezron in Ram anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram in Amminadab anei, Amminadab in Nahshon anei, Nahshon in Salmon anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon li Rahab in Boaz innei, Boaz li Ruth in Obed innei, Obed in Jesse anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","khat-um Jesse in Reng David anei. Uriah numei leika-e kha David in aneiya Solomon inleinei; ");
INSERT INTO kfw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon in Rehoboam anei, Rehoboam in Abijah anei, halli Abijah in Asa anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa in Jehoshaphat anei, Jehoshaphat in Joram anei, Joram in Uzziah anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah in Jotham anei, Jotham in Ahaz anei, Ahaz in Hezekiah anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah in Manasseh anei, halli Manasseh in Amon anei, Amon in Josiah anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","halli Josiah in Jechoniah le a-u anai ngaikha Babylonna raalringnga insurra inruoi pheiweikhan inleinei. ");
INSERT INTO kfw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Halli Babylonna inruoi suonuk Jechoniah in Shealtiel anei khat-um Shealtiel in Zerubbabel anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel in Abiud anei, halli Abiud in Eliakim anei, Eliakim in Azor anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor in Zadok anei, khat-um Zadok in Achim anei, halli Achim in Eliud anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud in Eleazar anei, khat-um Eleazar in Matthan anei, halli Matthan in Jacob anei, ");
INSERT INTO kfw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","halli Jacob in Mary ruothar Joseph anei, Mary hi Christa Jisu nu eii. ");
INSERT INTO kfw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Khanthoa, Abraham makheiya David katunghi khang soomleimili eii, David makheiya Babylon raalringnga inruoi katung khang soomleimili eii, khat-um khamakheiya Messiah innei katung khang soomleimili eii. ");
INSERT INTO kfw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisu Christa hi hinthoa inleinei. Anu Mary hi Joseph sik ah inleibiak, takkha inmani moi inruoima, Ratha Inthiangnga inphut ama'n nai awonjei ti inleijetjei. ");
INSERT INTO kfw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Aruothar Joseph hi mikatha akatuun katho miring inkhat ejarra, ama'n Mary hi mipui maikuungnga minjakzoot mak ah ruuk ah inthenpui nasik alei-ngaidon. ");
INSERT INTO kfw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ama'n hiwa jarra angaidon laikhan, Pumi marwaan tirton inkhat ama ramangnga inlarra ati, “David sapa Joseph, nanumei Mary hi kaneisik chimaro. Ama naiwon hi Ratha Inthiangnga inphut eii. ");
INSERT INTO kfw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ama'n sapa inkhat aneisik eii, halli nang in araming Jisu tia naphuo sik eii, ajarchu ama'n ami ngaikha inmanu ah inphut akatansik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pumi khan Pathian chongkachoi ngai diangnga ileiril ngaikha inthiangnga atungnasik hiwa rakip hi tuun asuokjei. ");
INSERT INTO kfw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Enru, inthiang nungaak inkhat in nai lawonta sapa inkhat aneisik eii, halli ama ramingkha Immanuel tia inkoi sik eii” (hiwa tinachu, “Einile kaom suom Pathian tina eii”). ");
INSERT INTO kfw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph in ahong inthei pha Pumi marwaan tirton ileiti angnga ama'n Mary kha anumeiya aneijei. ");
INSERT INTO kfw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Takkha Mary in sapa kha aneimak laiseng khan Joseph in amale lei-inchunpui mak, halli Joseph in ama raming kha Jisu tia aleiphuo jei. ");
INSERT INTO kfw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herod in Reng achanglai, Judea ramsuungnga kaom Bethlehem khuopuiya Jisu hi innei suopha, nisuo tiangnga arsi larik kathei mi ngaikhan Jerusalemma inhongnga, ");
INSERT INTO kfw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","inhongrakel, “Jihudi ngai sik ah innei reng naiteii kha hun omme? Ajarchu keini'n nisuo tiangnga ama arsi kha kinmu khat-um keini ama chubei kathosik ah kinhong eii.” ");
INSERT INTO kfw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Reng Herod in hiwa chonghi ajetpha, amale Jerusalemma kaom miring rakip inmalung aleipoong. ");
INSERT INTO kfw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ama'n thiampu kalian rakiple dan karu ngaikha akoichunna inmani diang, “Christa hunme inneisik?” tia aleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Inmani'n amadiang inleimasang, “Judea ramma kaom Bethlehem khuopui khan eiiz” “Ajarchu Pathian chongkachoipa khan hintia aleimajia: ");
INSERT INTO kfw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘E Judah ramma kaom Bethlehem, Nangchu Judah Reng waikaroon ngai karra akasiinkhet kha emakche; ajarchu kami Israel ngai lamkakei inkhat kha Nang diangnga inphut alahongsuok sik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Khawa jarra Herod in nisuo tiangnga kasing-kathei ngaikha ruuk ah akoiya angtikpha tak khanme khawa Arsi kha kasuok tikha inmani diang katha ah ajetjei. ");
INSERT INTO kfw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Khawasuo khan ama'n inmani kha Bethlehem tiang aleitirra, “Nangni'n si-inlang naiteii jarra katha ah entok inlang ningmu pha kei um kasiya chubei katho nasik keidiang naminjetru aleiti.” ");
INSERT INTO kfw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Inmani'n Rengchong kha inrangaiya insijei, halli enru, nisuo tiangnga inleimu arsi khan naiteii omna chungnga ahongngir maklaiseng inmani matiang asijei. ");
INSERT INTO kfw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Inmani'n arsi kha inmupha, karok khan aleisip. ");
INSERT INTO kfw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Inmani'n Innsuung kha inluut ah, naiteii khan anu Mary le inleiom inmupha, kemurkhup inthep ah inmani'n chubei inleithoa inkutchoi ngai inmalongnga, Soonna, Berou, khat-um myrrh, inkeisuoa amadiang kutchoi inleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Khawasuo khan Pathian in inmani kha Herod diang kirkhaimaru tia inramangnga aminjet ah inmani'n lam khattiang inrouwa inramtiang inleikirjei. ");
INSERT INTO kfw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Inmani'n inmathaanna insi suonuk, enru, Pumi marwaan tirton inkhat Joseph ramangnga inlarra ati, “Intheiro, naiteii khat-um anu ruoi-inlang, Egypt tiang taanru, kei'n khawa munkha mathaanru katimak laiseng khawakhan omru, ajarchu Herod in naiteii kha thatnasik ah ahong entoksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph in zaankhan intheiya, naidoong le anu kha aruoiya, Egypt tiang inleisijei, ");
INSERT INTO kfw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pumi'n Pathian chongkachoipa diangnga iril kha, “Kei'n Kasapa kha Egypt makheiya kakoi” tikha huuitungnasik Khawa munkhan Herod thimaklaiseng aleiom. ");
INSERT INTO kfw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Halli Herod in nisuo tiangnga kasing-kathei ngai'n ama diang maleisei innathojei ti ajetpha, araangtheiya, arsi larik kathei ngaidiang inthiangnga ijet dungjuiya Bethlehem khat-um akoolla kaom ramsuungnga pasal naiteii kumni makheiya nuoitiangnga kaom rakip hi chong apeya aleimithat. ");
INSERT INTO kfw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Hinthoa Pathian chongkachoi Jeremiah ileiti kha huuitungjei: ");
INSERT INTO kfw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramah ah rasa inkhat inleijet, khawa kha kapoongthei kachap rasa eii. Rachel in asa ngaisik achap; ama kha matheemtai matormu, ajarchu inmani inthisuojei.” ");
INSERT INTO kfw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod thisuo nuk, enru, Egypt ah Pumi marwaan tirton inkhat in Joseph ramangnga inlarra ati, ");
INSERT INTO kfw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Intheiro, naiteii li anu kha ruoi inlang, Israel ramtiang heikirtaro, ajarchu naiteii kha thatsik katho inmani ngaikha inthijei.” ");
INSERT INTO kfw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Khawa jarra Joseph intheiya, naiteii li anu aruoiya, Israel ramtiang inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Takkha Joseph in Archelaus hi apa Herod rathuulla Judea Reng ejeiti ajet ah, khawa munkhan kasisik aleichi. Halli Pathian in aramangnga kheella amindik ah ama'n Galilee ram khattiang aleisijei, ");
INSERT INTO kfw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pathian chongkachoi ngai'n inleiril, “Amahi Nazareth mi intisik eii” intikha huuitungnasik ah Ama'n Nazareth inti khuopui khan ahong-omjei. ");
INSERT INTO kfw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Khawapha takkhan John Baptist in Judea neelramma aheisuok ah chongril aleiphut, ");
INSERT INTO kfw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Manu ah inphut ningmalung thuultaru,” “Ajarchu marwaan Rengram kha anaijei!” ");
INSERT INTO kfw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ajarchu Pathian chongkachoi Isaiah in ileiril kha, “Neelram ah Mi inkhat in akheek, ‘Nangni Pumi sik ah lam boolru; Ama lamkha mintuunru!’ ” tia irilkha John hi eii, ");
INSERT INTO kfw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John apumtak Salaileem mulla inbool puondiar aleitho; ama'n sawun koongkhit akoongnga aleikhit, halli ama bak-inchu khaisor li ram khuoining alei eii. ");
INSERT INTO kfw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalemma inphut, Judea rampumpui, khat-um Jordan Tuidung sirra kaom mipuingai amadiang inleihong. ");
INSERT INTO kfw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Inmani'n inmanu inrilsuok ah, khat-um ama'n inmani Jordanna baptize aleitho. ");
INSERT INTO kfw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","John in Pharisee le Sadducee ngai baptize thonasik inheiwa amupha khan, inmani diang ama'n ati, “Nangni Maruul sangai akahongsik Pathian rachaakna akajuosik makheiya taanru tia tu-in nangnidiang narilpiya me? ");
INSERT INTO kfw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Manu ah inphut ningmalung thuulna kanaminmu sik chuon ngaikha thoru, ");
INSERT INTO kfw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Keini kinpu Abraham om keengnga poongraalna ah inphut taansuok mator kinte ti-inlang ngaidonmaru, ajarchu kei'n nangni diang kati, Pathian in hiwa lung ngaihin Abraham sangai amin eii mator! ");
INSERT INTO kfw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tuuntak hin thingkuung ngaikha tukpur nasik rei kha insuuk ah omjei; khawa jarra kara katha kakaramak thingkuung rakip kha intuk khiak ah mei suungnga indeeng luutsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Malung thuulna jarra kei'n nangni tuiya baptize kanatho, takkha kei kanuk ah akajuopa khachu keineek ah alok, keichu ama Hureikhaang kachoi sik um rahoi suokmong, Ama inchu nangni Ratha Inthiang li meiya baptize anathosik eii. ");
INSERT INTO kfw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ama'n saangzaapna kha akut ah achoi khat-um asaang kha inthiangnga zaapthiangta Ama'n saang ngaikha asapang suungnga athunsik eii, takkha arasi ngaikha akathimak mei suungnga adeengluut sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Khawa phakhan Jisu'n Galilee makheiya John diang Baptize intho nasik Jordan katung aleihong. ");
INSERT INTO kfw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Takkha John in zootmak ah aheiti, “Nang in kei kha baptize nanatho sik keeng,” “takkha nang in keidiang nahong bejei?” ");
INSERT INTO kfw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Halli Jisu'n aleimasang, “Tuunna sikchu nazootpi diro, ajarchu Pathian imanuom rakip kha hintho ah eini'n nithosik eii.” khawa jarra John in aleizootpi jei. ");
INSERT INTO kfw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisu baptize atholi, tui makheiya ahongsuok jei, halli marwaan kha inlongjei, halli Pathian Ratha kha wathu angnga juochumma ama chungnga ajuochong kha aleimu, ");
INSERT INTO kfw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Halli marwaanna inphut rasa inkhat in ajuoti, “Hiwahi kei'n kiminriang khet kasapa kha eii, ama chungnga kamalung atai.” ");
INSERT INTO kfw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Khawasuo Ratha khan Jisu kha neelramma Seitan in matheem nasik aruoi jei. ");
INSERT INTO kfw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Halli suun li zaan nisoommili bu angeipha, Jisu awon ahongchaam jei. ");
INSERT INTO kfw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Akathamak Seitan khan ama diang ahongli ati, “Nang Pathian Sapa kha na-e inchu, hiwa lung ngaihi waipool uolru ti-inlang chong pero.” ");
INSERT INTO kfw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Takkha Jisu'n aleimasang, “Chong inthiang in ati, ‘Waipool bitkhan miring ngai'n ring matormu, takkha Pathian murra kasuok chongramol ngaikhan inring sik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Khawasuo khan akathamak Seitan in Jisu hi Inthiang Khuopui khan aruoiya, Biak-inn insaangkhet chungnga aminngirra, ");
INSERT INTO kfw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ama diang ati, “Nang Pathian Sapa kha na-e inchu, natheinuo ah inchoomthaak ro, ajarchu chong inthiang in aril, ‘Pathian in nang jarra ama tirton ngaidiang chongpeii apesik eii; nakeii kha lungnga intook maknasik, inmani'n nangkha naleipom inte.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisu'n ama diang amasang, “Hiwahi um chong inthiang in ati, ‘Nang in Napumi Pathian kha madan in enmaro.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Khawasuo khan akathamak Seitan in insaangtak chingbungnga aruoiya nuoipilchung rengram rakip le inmani rakip poina ngaikha ama diang aleiminmu. ");
INSERT INTO kfw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Nang in keihi kemurkhup thep ah chubei nanatho inchu,” “Kei'n hiwangai rakip hi nang kanapesik eii” Seitan in ati. ");
INSERT INTO kfw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Khawapha Jisu'n aleimasang, “Siro, Seitan! chong inthiang in ati, ‘Napumi Pathian bitkha chubei thoro halli sepa thoro!’ ” ");
INSERT INTO kfw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Khawapha akathamak Seitan khan Jisu kha alei mathaanjei; halli marwaan tirton ngai'n injuo ah ama kha inleisanjei. ");
INSERT INTO kfw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","John hi mikhumna ah indajei ti Jisu'n ajetpha, Galilee tiang aleisijei. ");
INSERT INTO kfw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ama'n Nazareth amathaanna, Zebulun li Naphtali ram Galilee tuidiil koolla kaom khuopui Capernaumma asiya ajuo omjei. ");
INSERT INTO kfw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hiwahi Pathian chongkachoi Isaiah diangnga ileiminril kha huui tungna eii, ");
INSERT INTO kfw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun ram li Naphtali ram, tuipui lamma kaom Jordan raalkhat tiang, Zaatlop ngai ram, Galilee! ");
INSERT INTO kfw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Aziingna ah leikaom miring ngai'n war kalok kha inmujei. halli thina raliim ramma kaom ngai chungnga war kha ajuowar jei.” iti kha huui tungnasik eii. ");
INSERT INTO kfw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","“Ningmalung thuulru, ajarchu marwaan Rengram kha anaijei!” iti achong kha khawa pha makheiya Jisu'n karil aphut jei. ");
INSERT INTO kfw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisu'n Galilee tuidiil khamma aheiwapha, Peter intia inkoi Simon khat-um anaipa Andrew, ama'n unai inni tuidiil khan leen inwor kha aleimu, ajarchu inmani kha ngakasur in eii. ");
INSERT INTO kfw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisu'n inmani diang ati, “Heiwaru, kei najuiru, halli kei'n nangni mi kasur naminchu kate.” ");
INSERT INTO kfw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Khawapha takkhan inleen inda ah anuk inleijui jei. ");
INSERT INTO kfw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ama'n hin aheiwapha unai inni khat, James le John, Zebedee sa ngai, inpa Zebedee le inruoiya rakuong inkhat ah, inmani leen inboolla in-om aleimu, halli Jisu'n inmani aleikoi, ");
INSERT INTO kfw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Khawapha takkhan inmani inrakuong khat-um inpa inda ah, ama nuk injuijei. ");
INSERT INTO kfw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Khawasuo Jisu'n Galilee rampumpui khan asi ah synagogue ngaikhan aleiminchu, halli rengram jarra Chongkahoi ngai arilpiya, rirai rakip karoon mi ngai khat-um kanangai aleimindam. ");
INSERT INTO kfw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ama jarra chongngai hi Syria rampumpui kha alei-inthang jei, khawa jarra mi ngai'n ama diang akana, rirai rakip kana ah kapoong ngai: ratha kathamak kaluut, rikei karoon, apang kathi rakip inhong ruoiya Jisu'n inmani rakip kha aleimindam jei. ");
INSERT INTO kfw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilee le Khuo Soom tiya injet (decapolis), Jerusalem, Judea, khat-um Jordan ram raaltiangnga inphut mipui katamtak in ama nuk inleijuijei. ");
INSERT INTO kfw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisu'n mipui ngaikha amuli chingtiang khan akaljei, halli in-ongnga ompha, Ama siamruoi ngai'n akoolla inlei-inchun, ");
INSERT INTO kfw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","halli ama'n inmani kha kaminchu aphut jei: ");
INSERT INTO kfw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ratha ah kasuol kin-eii ti kajet ngaikha rawaan intha; ajarchu Marwaan Rengram hi inmanita eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Malung kapoong ngaikha rawaan intha; ajarchu Pathian in inmani alaminhoi sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Malung kadai ngaikha rawaan intha; ajarchu nuoipilchung hi inmanita esik asuok.” ");
INSERT INTO kfw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Chuon katuun sikbit ah wonchaam tuikaraal ngaikha rawaan intha; ajarchu Pathian in inmani kha alaminkhop sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Minriang kajet ngaikha rawaan intha; ajarchu Pathian in inmani diang aminriang sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Malung inthiang ngaikha rawaan intha; ajarchu inmani'n Pathian kha inlamusik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Hoina daina sik ah chuonkatho ngaikha rawaan intha; ajarchu inmani kha Pathian sangai tia akoisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Chuonkatuun jarra inrachaak ngaikha rawaan intha; ajarchu Marwaan Rengram hi inmanita eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Kei jarra mi ngai'n nangni innaran khat-um innarachaak, halli nangni chungnga kathamak rakip innanoon jei inchu nangni ningrawaan atha.” ");
INSERT INTO kfw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hoiru khat-um rokru, ajarchu marwaanna nangnisik chuonthoman kalok kha inda, ajarchu nangni matiangnga leikaom Pathian chongkachoi ngaikha hinthoa inleirachaak. ");
INSERT INTO kfw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nangnichu nuoipilchung machi kha ning eii. Takkha machi khan al makjei inchu, khawa kha angtho-thoa nimin-al sik me? khawakha kalekjuonna mi ngai keiiya intou eleiya iteii um anemna ommakjei.” ");
INSERT INTO kfw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nangnichu nuoipilchung pumpui war kha ning eii. Chingnga insak khuopui kha thup thamak.” ");
INSERT INTO kfw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mi ngai'n sariakmei kha inminkaili kok nuoiya damu; khawa rathuulla sariakmei kechungnga indali, innsuungnga kaom mirakip munasik inminwar. ");
INSERT INTO kfw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kha angnga mi ngai'n nangni chountho katha kha inmuwa marwaanna kaom ning Pa kha minpaak nasik nangni war kha mi ngai maikuungnga warrase. ");
INSERT INTO kfw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kei'n Moses Dan khat-um Pathian chongkachoi ngai chongkha kaminmang sik kijuo eii tia ngaidonmaru, keichu kaminmang kijuo emong, takkha khawa ngai huui kamintung kijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ajarchu kei'n nangni diang inthiangnga kiril hi eii. Marwaan li nuoipil ahek maklaiseng, Dan chongramol kasiin khet emakli wiarkhat bit um hiwarakip atungmaklaiseng inmangnuni. ");
INSERT INTO kfw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Khawa jarra, tuka-ang inkhat in chongpeii karra akasiin khet inkhat kha amakoiya mi ngaidiang khajek kha thoru tia aminchu inchu marwaan Rengramma akasiin khet esik eii, Inkhattiang, tuka-ang inkhat in Dan kha ajuiya mi ngaidiang aminchu inchu, amakha marwaan Rengramma akalok khet esik eii. ");
INSERT INTO kfw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ajarchu kei'n nangni diang kiril hi eii, nangni chuontho katuun kha Dan ocha ngai khat-um Pharisee ngai neek ah kheella ningthomak inchu, nangni marwaan Rengram supluut luut nutun. ");
INSERT INTO kfw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Mi ngai'n matiang khan inleiril kha nangni'n ningjetjei, ‘Mi thatmaru; tuka-ang inkhat in mi athat inchu achungnga chongtan kangar kha omsik eii.’ ");
INSERT INTO kfw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Takkha tuun kei'n nangni diang kati: tuka-ang inkhat in ama unai ngaidiang araang inchu chongtan kangar amusik eii, halli tuka-ang inkhat in a-u anai ngaikha ‘Anemna kaboi nang!’ tia akoi inchu ama kha Katar ngai maikuungnga inkeisuosik eii, halli tuka-ang inkhat in ka-am anemna kaboi nang atia akoi inchu chikaom meikhurra achulsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Khawa jarra nang in Pathian diang maichaam khan kutchoi nape siktiang na-u nanai ngai'n nachungnga angmekhat hoimakna kaom kha nahong ngaidon inchu, ");
INSERT INTO kfw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nakutchoi kha maichaam ma-khan da-inlang, woikhat kirnook inlang na-u nanai ngai khale juo-inzoot naru, halli heikir inlang Pathian diang nakutchoi kha jopero.” ");
INSERT INTO kfw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nang inhalpui mi inkhat in nang chungnga zootmak ah chongtanna munna anaruoi inchu, lamma ningsi lai innot ah inzootnaru, kha emak inchu ni-inhalpui ama'n nangkha chongkatanpa diang khan napeta, halli chongkatanpa in nangkha mikhumna kangaak ngaidiang napeta nang mikhumna khan nadasik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kei'n nang diang inthiangnga karil, nang in ahekna napesik kasuok sial kha nape maklaiseng khawa munna inphut heisuok thanunijei. ");
INSERT INTO kfw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Zool-inthai emaru, ‘inleiti kha nangni'n ningjetjei.’ ");
INSERT INTO kfw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Takkha tuun kei'n nangni diang kati, numeisa inkhat kha taksa manuom nakhan ka-en mi rakip in ama malungnga ama khale inruoiya zool-inthai kha ejei.” ");
INSERT INTO kfw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Halli namit changtiang khan nangkha manu ah anamachul sik e-inchu, kel-inlang kalekjuonro! ajarchu napumtak kha meikhurra kaminluut sikneek ah nataksa saram inkhat kamang khan nang sik ah athawiai. ");
INSERT INTO kfw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nakut changtiang khan nangkha manu ah anamachulsik e-inchu, tan-inlang kalekjuonro! ajarchu napumtak kha meikhurra kaluutsik neek ah nataksa saram inkhat kamang khan nangsik ah athawiai. ");
INSERT INTO kfw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Hiwahi inleiril jei, ‘tuka-ang in anumei inthenpui inchu, inthenpuina chongmajia kha numeisanu diangkhan perase.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Takkha tuun kei'n nangni diang kati: zool-inthai jarra elekleiya, mi inkhat in anumei inthenpui ngai asuok ah halli anumei khan inn aneinook inchu ama'n anumei kha zool-inthai amin ejei, halli numeisanu kaneinook mi kha um zool-inthai amin ejei. ");
INSERT INTO kfw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nangni'n, matiangnga mi ngai'n inleiril kha nangni'n ningjetjei, khachu ‘Nangni chong inkhitna kha makoi maru, takkha angme chongkhomaak ni-insaam kha Pumi diang khan thoro.’ ");
INSERT INTO kfw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Takkha kei'n nangni diang karil: Chong ning inkhit pha chongkhomaak insaam maru, marwaan rakook inlang khomaak insaam maru, ajarchu hiwahi Pathian in-ongna eii, ");
INSERT INTO kfw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","emakli nuoipil rakook inlang-um khomaak insaam maru, ajarchu ama ke dana kha eii; emakli Jerusalem rakook inlang-um khomaak insaam maru, ajarchu akalok Reng khuopui kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nalu ma-ou inlang khomaak insaam maro, ajarchu nang in samramol inkhat bit um minbang kate emakli minwom kate nimator emak. ");
INSERT INTO kfw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hintiro ‘Oh’ natili ‘Oh’ tiro emakli ‘Ngang’ natili ‘Ngang’ tiro. hiwa chungtiang heikasuok ngaisengchu Kathamak Mipa makheiya aheikasuok eii.” ");
INSERT INTO kfw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Hinna inleiti kha nangni'n ningjet, ‘Mit inkhat sik ah mit inkhat, ha inkhat sik ah ha inkhat.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Takkha kei'n nangni diang kati, nangni'n akathamak mi kha phaphu luok maru. Tuka-ang inkhat in nangem changtiang kabeen inchu, nangem kaangkhat tiang um doupiro. ");
INSERT INTO kfw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Halli tuka-ang inkhat in nang kha chongtanna khan anaruoiya nasongkol aleizoot ah chongkal inchu, ama diang khan napuonsil kha um leirase. ");
INSERT INTO kfw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Khat-um tuka-ang rup inkhat in aphur kha nazootmak pumma mile inkhat naminchoi inchu, mile inni choipiro. ");
INSERT INTO kfw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tuka-ang inkhat in nang diang phur khat anani pha, ama diang khan pero, halli tuka-ang inkhat in phur khat apuukzoot pha, ama diang khan minpuuk ro. ");
INSERT INTO kfw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Hinna inleiti kha nangni'n ningjet, ‘Na-indiang na-inwaipui ngaikha minriangro, ni-inhalpui ngaikha matirro.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Takkha tuun nangni diang kei'n kati: nangni inhalpui ngaikha minriangro, khat-um nangni kanaminpoong ngai sikbit ah nina neipiru, ");
INSERT INTO kfw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kha angnga marwaanna kaom ning Pa sangai kha ning esik eii, ajarchu ama'n akase li akatha ngai chungnga in-angnga ama'n kani aminsuok, halli mi katha li mi kathamak ngai sik um ruo aminsur. ");
INSERT INTO kfw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ajarchu nangni'n nangni kanaminriang mi ngaibit ningminriang inchu Pathian in nangni diang angtho-thoa thoman anapesik me? rampar kakhoom ngai innum khan intho emak abe! ");
INSERT INTO kfw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Khat-um nangni'n ning-u ningnai ngaidiang bit khoya ningtho inchu, mi ngai diangnga nangni'n ang kakheel ningthome? zaatlop ngai innum khan intho emak abe! ");
INSERT INTO kfw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Khawa jarra Marwaanna kaom ning Pa in pui itung angnga Nangni um puikatung kha eru. ");
INSERT INTO kfw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mipui maikuungnga inmani namu nasik ah nangni chuon katha ngaikha thomak nasik inringtheiru, khawakha ningtho inchu Marwaanna kaom ning Pa diangnga nangnisik thoman iteii um ommak.” ");
INSERT INTO kfw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Khawa jarra mi ngai naminpaak nasik akatha inleem ngai'n synagogues ah khat-um lampuiya intho angnga, nangni'n kutchoi ningpe pha malar maru. Kei'n inthiangnga nangni diang kati, inmani'n inthoman kha kahuuiya inralaang suojei.” ");
INSERT INTO kfw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nangni'n kaneimak ngaidiang kutchoi ningpe pha ningkut changtiang ningtho kha ningwei tiangnga ningkut in jetmarase, ");
INSERT INTO kfw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ajarchu ruuk ah kanamu ning Pa in nangni diang anape kirna sik ah; ningpe kha ruuk ah inpe erase. ");
INSERT INTO kfw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nangni'n ningni pha, akatha omchan kathongai angmaru! ajarchu mi rakip in inmani inmu nasik ah, chubei thona inna khat-um lamraki ngaikhan inngirra kani inmanuom. Kei'n nangni diang inthiangnga kati, inmani'n inthoman kha kahuuiya inmujei. ");
INSERT INTO kfw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Takkha nangnichu ningni pha, ning innsuung luutru, ning innkhar kha khar inlang, mit ah inmumak, ning Pa ama diang niru. Halli ruuk ah kanamu, ning Pa in nangni diang najuope kirte.” ");
INSERT INTO kfw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Halli nangni ningni pha, zaatlop ngai itho angnga anemna kaboiya inlet-inlet ah nikirmaru, ajarchu inmani'n kasoot ah inni kha inpathian ngai'n najetpite tia inngaidon. ");
INSERT INTO kfw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Khawa jarra inmani angmaru, ajarchu nangni'n ama diang ningni maklai nangni sik ah angme insam kaom kha ning Pa in anajetpi. ");
INSERT INTO kfw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Khawa jarra hintho inlang nangni'n niru: Marwaanna kaom kin Pa: Naraming kaya omrase; ");
INSERT INTO kfw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Narengram juotung rase; marwaanna nalungdou intho angnga nuoipilchungnga inthorase. ");
INSERT INTO kfw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Keini sik arei kaom bak le in awini napero. ");
INSERT INTO kfw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Halli keini chungnga kamasial ngai kinrangaidam angnga, Keini itho masialna ngaikha narangaidamro. ");
INSERT INTO kfw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Halli keini matheemna khan naminchulmaro, takkha Kathamak ah inphut keini nasanro. Ajarchu Rengram, ranak khat-um lurna-lianna ngaihi hektik kaboiya nangta erase Amen.” ");
INSERT INTO kfw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ajarchu “Nangni'n mi ngai intho masialna ngaikha ningngaidampi inchu, marwaanna kaom ningpa Pathian in nangni kha um anarangaidam sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Takkha nangni'n mi ngai ningngaidam mak inchu, ningpa Pathian innum nangni itho masial ngaikhan narangaidampi nuni. ");
INSERT INTO kfw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Halli nangni'n bu ningngei phakhan, akatha omchan katho ngai angnga maisuo kapoong malarmaru. Ajarchu inmani'n bu kinngei ti mi rakip in namurasu tia kapoong meelsuo inmalar. Kei'n inthiangnga kati, inmani inthoman kha kahuuiya inmusuojei.” ");
INSERT INTO kfw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Takkha nangnichu bu ningei pha, ninglu ah sariak kanoot ru halli ningmai phiaru, ");
INSERT INTO kfw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","halli ningbu ngei kha mi ngai'n jetmarasu, takkha mit ah inmumak ning Pa bit khan ajetsik eii. Halli ruuk ah kanamu, ning Pa in nangni diang najuope sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Inngeii li thir-ek ibakmator halli inruup ngai'n inmakoiya inmaruup mator neipilchung hin nangni sik ah neinaak bukmaru.” ");
INSERT INTO kfw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Takkha inngeii li thir-ek inbak matormakjei halli inruup ngai innum inmakoiya inmaruup theimak marwaanna nangni sik ah neinaak kha inbuk ru. ");
INSERT INTO kfw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ajarchu naneinaak omna khan namalung um aomsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Taksa sik ah meiserchu mit eii, khawa jarra namit atha inchu, napumpui kha war in asipsik eii, ");
INSERT INTO kfw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","takkha namit athamak inchu, napum kha kaziing in asipsik eii. Khawa jarra nasuungnga kaom war kha aziing inchu, angtuk chikaom tak ah kaziing mejei!” ");
INSERT INTO kfw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tu inkhat innum karu inni suok ematornutun; ajarchu inkhat amatir li inkhatpa kha aminriang sik eii, emakli ama'n inkhat sik nangir li inkhatpa kha donnuni. Khawa jarra nangni'n Pathian li sialsum inni suok emator nutun.” ");
INSERT INTO kfw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Hiwa sik ah kei'n nangni diang kiril eii, nangni'n ringna sikbit ah angme baksik, angme insik halli puondiar sik jarra angme kinthosik ti-inlang ningmalung mindongmaru.” Ringkhuo khan bak li in neek ah halli nipum in puondiar neek ah kakheel emak abe? ");
INSERT INTO kfw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chungnga wa ngaikhi enru, inmani'n wor um wormu, aat um aatmu, halli sapangnga um bukmu, takkha marwaanna kaom ning Pa in inmani kha aminbak! nangnichu wa ngai neek ah aman katam emakchube? ");
INSERT INTO kfw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Halli nangni tu inkhat in amalung minpoongli aringkhuo lekkhat kaminsei mator ningommabe? ");
INSERT INTO kfw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Halli puondiar jarra ang sikme malung poongna ningnei? Leiya rei ngaiso angtho-thoa inmoongme enru: inmani chuonnum thomu, pat um khermu, ");
INSERT INTO kfw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","takkha kei'n nangni diang kati, khachu Reng Solomon in inei neilenung rakip ah inliang innum hiwa reipar ngai thadan leiphamak.” ");
INSERT INTO kfw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Takkha awini moongnga kaom leihar ziingngachu meiya haalsik ramma kaom leihar kha Pathian in hituk katha ah aminliang inchu, E, ngamna kasiin ngai, ama'n nangnile kheella naminliang makniabe? ");
INSERT INTO kfw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Khawa jarra angme baksik, angme insik, emakli, angme kasilsik tia malung minpoong maru.” ");
INSERT INTO kfw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","(Ajarchu zaatlop ngai'n hiwa phur rakip hi in-entok.) Halli marwaanna kaom ning Pa in phur rakip hi nangni diang arei om ti anajetpi. ");
INSERT INTO kfw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Takkha nangni'n Pathian Rengram khat-um ama dikna kha ma-insa ah entokru, halli phur rakip hi nangni diang kheella anapedel sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Khawa jarra ziingnga sik malung minpoong maru; ajarchu ziingnga sikchu ziingnga atheinuo ah malung inpoongte. Nisuo khat ah poongna khan nisuo khat sik ah kahunthek kha ejei. ");
INSERT INTO kfw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Mi leiilak chungnga chong tanmaro, kha e-inchu Pathian innum nangni chungnga chong natannuni, ");
INSERT INTO kfw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ajarchu nangni chongtan khale in-angrip ah, nangni kha chong analatansik eii, halli nangni'n ningjuo uol dan khale in-angrip ah nangni diang um ana uol sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Halli namit ah kaom thinglek khachu khaisik ngaidon mak cheya, na-u nanai ngai mit ah kaom madir kha angsik ah ni-enme? ");
INSERT INTO kfw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Halli namit ah thinglek ompumma, angtho-thoa na-u nanai ngaidiang, namit ah kaom madir kha kei'n nakhaipi kate, natisikme? ");
INSERT INTO kfw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Akatha inleem nang! nang in ma-insakhet ah namit ah kaom thinglek kha khaidiro, halli khawasuoli nang in na-u nanai ngai mit ah kaom madir kha inthiangnga khaisik munate. ");
INSERT INTO kfw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Inthiang phurkha ui ngaidiang pemaru; halli ninglungman katam ngaikha wokngai matiang dapimaru. Inmani'n khawakha inkeiiya intouli khan inhong-inheiya nangnikha na-eicha.” ");
INSERT INTO kfw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Niru, nangni diang napete; Entokru, nangni'n muningte; halli inkhar kha rakhoongru, nangni diang namalong pite. ");
INSERT INTO kfw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ajarchu akani mi rakip in inchang, aka-entok rakip in inmu, halli akarakhoong amadiang inmalong pisik eii. ");
INSERT INTO kfw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nangni karra tume asapa in bu anili lung amadiang kapesik? ");
INSERT INTO kfw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Emakli nga ananili amadiang maruul kapesik? ");
INSERT INTO kfw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nangni ningthamak innum, ningsa ngaidiang akatha kutchoi ningpethei inchu, marwaanna kaom ning Pa in akani inmani diang kheella akatha phur kha apemaksik!” ");
INSERT INTO kfw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Khawa jarra nangni'n mi ngai ningchungnga ningmintho zoot angrakip kha nangni innum inmani diang khan thoru: ajarchu hiwahin Moses Dan khat-um Pathian chongkachoi ngai minchuna kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Nangni'n kot kasiin khan luutru, ajarchu poongnamun katung kot kha alok khat-um lam kha jui abei, halli mi katam in khawakha injui. ");
INSERT INTO kfw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Takkha ringna katung kotchu asiin khat-um lamkha jui-intak, halli khawa kaluut mi intoom.” ");
INSERT INTO kfw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Keelngam omchan katho, halli asuung ngachu awonkachaam malang angnga nangni diangnga kahong Pathian chongkachoi inleem ngaikha insingtheiru.” ");
INSERT INTO kfw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nangni'n angme intho khan inmani jetningte. Raling kuung makheiya theibom, halli raling kuungnga theichang inra ngai abe? ");
INSERT INTO kfw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Khawa jarra akatha thingkuung rakip in akatha kara inra, khat-um kathamak thingkuung in kathamak kara kha inra. ");
INSERT INTO kfw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Akatha thingkuung in kathamak kara inramak, halli akathamak thingkuung khan akatha kara karamak. ");
INSERT INTO kfw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Akatha kara kakaramak thingkuung rakipkha intukkhiak ah meisuungnga indeengluut. ");
INSERT INTO kfw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Khawajarra, inmani kara khan nangni'n inmani kha jetningte. ");
INSERT INTO kfw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kei diang ‘Pumi, Pumi’ kanati mi rakip in marwaan rengram kha luutnunu, takkha marwaanna kaom ka-Pa lungdou akatho ama bitkhan aluutsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Chongtan Nikhuo khan, mi katamtak in keidiang intisik eii, Pumi, Pumi! nang ramingnga keini'n Pathian chong kha kinleiril emak abe, nang ramingnga keini'n ratha kathamak angjet ngai kinleinong suok emak abe, khat-um inlakchuon angjet kinleitho emak abe? ");
INSERT INTO kfw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Khawa phakhan kei'n inmani diang inthiangnga karilsik eii, Kei'n angtikniteii nangni najetmong; nangni thomak sik kathongai, kei diangnga inphut suoktaru! ");
INSERT INTO kfw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Khawa jarra, kei kachong ngaihi jetli kajui miring rakip kha lungpui chungnga a-inn kasak akasing mi inkhatle in-ang.” ");
INSERT INTO kfw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Halli ruo katamma ahongsur, tuidung kha ahonglian, khat-um thi kana ah ahongraangnga inn kha aseem jei, takkha inn kha lung chungnga insak jarra leipurmak. ");
INSERT INTO kfw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Halli kei kachong ngaihi jetli kajuimak miring rakipchu neel chungnga inn kasak aka-am mi inkhatle in-ang. ");
INSERT INTO kfw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Halli ruo katamma ahongsurra, tuidung ahonglian, khat-um thi kana ah ahongraangnga, inn kha aseempur jei. Khawa kha setheiya apurjei!” ");
INSERT INTO kfw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisu'n hiwa rakip arilsuo pha, mipui ngai'n ama minchuna kha inleingak, ");
INSERT INTO kfw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ajarchu ama'n inmani Dan karu ngai khale in-angleiya; thomatorna kanei inkhat ah aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisu'n chingnga inphut ajuochum pha, mipui katamtak in ama nuk inleijui. ");
INSERT INTO kfw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Halli enru, takbangri karoon mi inkhat in ama koolla ahongnga chubei thoa ati, “Ocha, nang in nanazootpi inchu, keihi nanaminthiang mator.” ");
INSERT INTO kfw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisu'n akut aheisoonna ama kha akatook ah ati, “Kei'n kazootjei,” “Nang kadam etaro!” Khawaphatak takbangri kha inthiangjei. ");
INSERT INTO kfw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Halli Jisu'n ama diang ati, “Rangairo! nang tu-inkhat diang rilpimaro, takkha siro, thiampu diang napumtak juominmuro, halli inmani diang nang nadam jei tina sakhi inpenasik; Moses chongpeii dungjuiya pesik doiphur kha juopero.” ");
INSERT INTO kfw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Halli Jisu'n Capernaum aluut pha, Roman raalmi rajakhat lamkakei inkhat in ama diang hongnga, nasanro ahongti: ");
INSERT INTO kfw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ocha, kasuokpa kha apang kaangkhat kathi kana khan kapoongtak ah ana ah sithei mak ah inna azaalla omjei.” ");
INSERT INTO kfw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisu'n amadiang ati, “Kei'n sikata halli ama kamindamsik eii,” ");
INSERT INTO kfw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Emak ocha,”Raalmi rajakhat lamkakeipa khan aheimasang, nang in ka-inna nahongsik hi “Kei rahoi suokmong, takkha chongbit kha pero kasuok kanapa kha damte. ");
INSERT INTO kfw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ajarchu Kei kapumtak um, ranak kanei mi inkhat nuoiya kaom ka-eii, halli kanuoiya raalmi in-om, halli hiwa mipa diang, ‘Siro!’ katili ama asi; mikhat diang, ‘Heiwaro!’ katili aheiwa; halli kasuokpa diang, ‘Hi thoro katili’ ama'n atho.” ");
INSERT INTO kfw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisu'n hiwahi ajet pha, angak ah anuk kajui mipui ngaidiang ati, “Kei'n nangni diang inthiangnga karil, Kei'n Israel ngai karra hituk ngamna kanei miring inkhat um lamumong. ");
INSERT INTO kfw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kei'n nangnidiang karil, nisuo tiang li niluutna tiangnga inphut mikatam khat hong-inta marwaan rengramma bubakna khan Abraham, Isaac khat-um Jacob ngaile in in-ong suomsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Takkha Rengramma kaom sik ngai khan mi ngaikha rengram makheiya aziingna munkhan indiangjuon sik eii, khawamun khan inmani chapna li hakarialna esik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Khawasuoli Jisu'n raalmi rajakhat lamkakeipa diang aheiti, “Na-inna siro, na-inngamna angnga nangsik intho rase.” Halli khawa phatak khan asuokpa kha adamjei. ");
INSERT INTO kfw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisu'n Peter inna aheiwa pha, Peter tarpi ritun ana ah zaalmunna izaalkha aleimu. ");
INSERT INTO kfw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ama'n akut akatook pha ritun khan amathaanjei; halli ama intheiya ama kha sepa aphut jei. ");
INSERT INTO kfw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kholei aheitung pha, mipui in Jisu diang raikhuo kaluut angjet inheiruoi. Jisu'n kana rakip aleimindam khat-um chongnga ratha inthiangmak ngaikha aleipuutsuok. ");
INSERT INTO kfw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Pathian chongkachoi Isaiah diangnga ileiminril, “Ama apumtak in eini nana ngai kha anakhaipi khat-um niri nirai ngai anaroonpi” ti pui tungnasik eii. ");
INSERT INTO kfw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisu ama mipui ngai'n inhei-um amu pha, tuidiil khamkhat tiang rakaannasik asiamruoi ngaidiang chong aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dan ocha inkhat ama diang aleihongnga ahongti. “Ocha,” “Kei nasina rakip nanuk kajuisik ka-insuuk suojei.” ");
INSERT INTO kfw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Khawapha Jisu'n amadiang aleiti, “Ram-ui ngai'n inkhur innei, halli lairalak ah wa ngai'n rabu innei, takkha Miring Sapa alu danasik munchu ommak.” ");
INSERT INTO kfw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Siamruoi karra inkhat in ati, “Ocha, kapa kaphuum kasisik hi ma-insakhet ah nazootpidiro.” ");
INSERT INTO kfw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Takkha Jisu'n ama diang aleimasang, “Kanuk najuiro,” “Halli akathi ngaikhan inmani intheinuo ah inphuum rasu.” ");
INSERT INTO kfw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisu'n rakuong inkhat suungnga aleiluut pha, asiamruoi ngai ama nuk inleijui. ");
INSERT INTO kfw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Halli enru, jetlei-theileiya tuidiil chungnga akangartak thipui inkhat ahongraangnga, rakuong kha tuithisiip in aheimakhujei; takkha Jisu chu aleizaalla alei-om. ");
INSERT INTO kfw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Khawakhan siamruoi ngai'n insia ama injuokeitheili inti, “Pumi, nasanro!” “Keini kinthisik ejei!” ");
INSERT INTO kfw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Halli Jisu'n aleimasang, “E ngamna kasiin ngai, angsikme khatuk ningchi?” Halli ama'n intheiya thikaraang khat-um tuithisiip kha chong apeli akhaapjei; halli pumdai ajuodaijei. ");
INSERT INTO kfw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Halli mi ngaikhan inngak ah inti, “Thikaraang li tuithisiip ngai innum achong injui, hiwahi ang mi chat me?” ");
INSERT INTO kfw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisu'n Gadara tuidiil ram raalkhat tiang ahongpha, ranak kanei thaanna inphut heikasuok raikhuo iruoi miring inni alei-intongpui. Inmani kha chikaomthei in ejarra, khawa lam khan tu inkhat um leisi matormu. ");
INSERT INTO kfw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Halli enru, inmani'n inkheekli inti, “E Pathian Sapa, angme nang in keini diangnga nimanuom? apha heitungmaklai nang in keini naminpoong sik niheiwabe?” ");
INSERT INTO kfw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Inmani makheiya kalaakdet ah wok rahooi katamtak inbak ah inlei-om. ");
INSERT INTO kfw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Halli raikhuo ngaikhan Jisu diang inti, “Keini nanapuut suoksik e-inchu, wok rahooi ngai suungnga keini natirro.” ");
INSERT INTO kfw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisu'n “Siru,” inmani diang ati; halli inmani'n inheisuok ah wok ngai suungnga inleiluut jei. Enru, Wok rahooi rakip ngaikha insuk tuidiil pangtiang sumpalingkhang inthoa tuiya intali inthijei. ");
INSERT INTO kfw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Khawapha wok kakhaal ngaikhan intaanna khuopuiya inluut ah, akasuok thurchi rakip khat-um raikhuo in iruoi mi ngai jarra inleirilpi jei. ");
INSERT INTO kfw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Khawa jarra khuopui makheiya miring rakip in Jisu inmupui nasik inheisuokjei; khat-um inmani'n ama inmupha, inmani ram makheiya mathaan nasik inleiti. ");
INSERT INTO kfw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisu'n rakuong chuongnga khat-um tuidiil rakaanna akhuopui tiang akirnookjei, ");
INSERT INTO kfw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Halli enru, miring lekkhat in zaalmumna zaalla kaom apangkathi miring inkhat, ama diang inhongruoi. Jisu'n inmani ngamna kha amu pha, apangkathi miringpa diang ama'n ati, “Kasapa namalung minhoiro! namanu ngaikha kana-ngaidam pijei.” ");
INSERT INTO kfw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Halli enru, dan ocha lekkhat in, “Hiwa mipa in Pathian diang kase ah aril jei!” tia inmani inkhat li inkhat inlei-inti ");
INSERT INTO kfw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisu'n inmani ingaidon angme ti ajet ah aheiti, “Nangni'n kha ka-ang kathamak angsik ah ningngaidon me? ");
INSERT INTO kfw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘Namanu ngai kha kana-ngaidam suojei,’ emakli ‘Inthei-inlang siro’ tihi, hume kheella kabei? ");
INSERT INTO kfw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kha-enchu kei'n nangni diang nuoipil chungnga Miring Sapa in manu ngai ngaidamna ranak anei tikha namalarpi kate.” Halli apangkathi mipa diang ama'n ati, “Inthei ro, napher rut inlang, inna siro!” ");
INSERT INTO kfw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mipa kha intheiya inna asijei. ");
INSERT INTO kfw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mipui'n khawa inmu pha, inmani'n inleichi, khat-um mipui diang hika-ang ranak kape Pathian kha inleiminpaak. ");
INSERT INTO kfw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisu'n khawa mun amathaanna, khat-um ama'n hin aheiwa pha, ama'n rampar kakhoom araming Matthew inti inkhat, achuon thona munna, in-ongnga kaom aleimu. Ama'n ama diang ati, “Kei najuiro.” Matthew in intheiya anuk aleijui jei. ");
INSERT INTO kfw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisu'n Matthew inna bu abaklai, rampar kakhoom katamtak ngaile aleiilak manu karoon ngai'n inheiwa ah Jisu le ama siamruoi ngai bubakna khan inlei in-ong. ");
INSERT INTO kfw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisee lekkhat in hiwahi inleimu khat-um ama siamruoi ngaidiang inleirakel, “Angsik ah me nangni ochapa'n hika-ang rampar kakhoom khat-um manu karoon ngaile inruoiya inbaksuom?” ");
INSERT INTO kfw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisu'n inmani iti aleijet halli aleimasang, “Akanamak mi ngai sik achu kathiam rangai mak, takkha tuka-ang akana ngai sik bit chu arangai. ");
INSERT INTO kfw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Si inlang entokru chong inthiang in angme iti tikha: ‘Kei imanuom khachu riangwai kha eii, sa ah doiphur inpe kha emak.’ Kei'n kijuo hichu mi kadik ngai kakoi emong, takkha manu karoon ngai kakoi kijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","John Baptist nukkajui ngai'n Jisu diang inhongnga inhongrakel, “Keini le Pharisee ngai'n bak-in kinngei, takkha nasiamruoi ngai inchu angsik ah me bak-in inngeimak?” ");
INSERT INTO kfw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisu'n aleimasang, “Moipa in moiruoina khan omlaiseng asap-asuon ngai poong inte tia nangni ningngaidon be? kha emak! Takkha nikhuo kha laheiwate inmani diangnga inphut moipa kha inlaruoi suok nasik, khanna inphut inmani bak-in inngei sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tu inkhat innum songkol maruo chungnga puon kathar lek khat kathuidel ngai mu, akathar inkathuidel puon khan heikeirinta khat-um songkol kachet kha kheella achetpui sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tu inkhat innum tuong kamaruo khan theibom tuithar kha thunnamu, ajarchu tuong kha koita, theibomtui kha inhiai sik eii, khat-um theibomtui tuong kha ajuomang sik eii, Khawa rathuulla, theibom tuithar kha theibomtui tuong kathar khan inthun, halli innireella katha tak ah inda.” ");
INSERT INTO kfw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisu'n hiwa arillaitak khan, Jihudi chuonkaroon inkhat ama diang aleihong, ama maikuungnga inbok ah ati, “Kei kasanu hi tuuntak khan athijei; takkha heiwa inlang ama chungnga nakut najuoda piro, halli ama hongringte.” ");
INSERT INTO kfw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Khawa jarra Jisu intheiya ama nuk ajuijei, khat-um ama siamruoi ngai ama le inleisi suomjei. ");
INSERT INTO kfw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kumsoomleini thikasarra kana numeisa inkhat Jisu nuk ah aheijui khat-um ama puonmor aleikatook. ");
INSERT INTO kfw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ama'n atheinuo ah inti, “Kei'n ama puon bit kakatook inchu, Kei kadam sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisu'n numeisanu diang ahei-inlet ah aleiti, “Kasanu, malung minsiin maro! Na-inngamna khan anamindam jei.” Khawa pha chei khan numeinu kha adamjei. ");
INSERT INTO kfw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Khawasuoli Jisu'n chuon karoonpa inna aleiluut. Akathinu phuumna sik ah khuongli dar katho ngaile mipui chorkati ngaikha ama'n ajomu pha, ");
INSERT INTO kfw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ama'n ati, “Mi rakip suokru! Naipangnu hi kathi emak ama hi akalazaal eii!” Khawa pha khan inmani rakip in ama innuipuina inleinei. ");
INSERT INTO kfw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Takkha mipui masuoksuoli, Jisu'n naipangnu omna inn tiang aluut ah akut ajuo ma-ou ah ama ahong intheijei. ");
INSERT INTO kfw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hiwa chong ngai jar rakip hi rampumpui inthangjei. ");
INSERT INTO kfw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisu'n khawa mun mathaanna, khat-um ama'n hin aheiwapha, mitkacho miring inni'n ama kajui inleiphut. “David Sapa, Keini naminriangro!” tia inmani'n inleikheek. ");
INSERT INTO kfw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisu'n innsuung aluutsuo pha, mitkacho miring inni ngai ama koolla inheiwa, khat-um inmanidiang ama'n aleirakel, “Kei'n nangni kanamindam mator tihi ning-inngamna be?” Inmani'n inleimasang, “Oh, ocha!” ");
INSERT INTO kfw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Halli Jisu'n inmani mit katookpiya khat-um aleitipi, nangni inngamna dungjuiya ningchungnga, “Hiwa kasuok etarase!” ");
INSERT INTO kfw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","halli inmani inmit inhongmujei. Jisu'n chong kangartak inmani diang aleiril, “Enru tu inkhat diang um hiwahi rilmaru!” ");
INSERT INTO kfw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Takkha inmani inmathaanna khawa ram pumpui khan Jisu jarra chongngai inleiril thangjei. ");
INSERT INTO kfw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Inmani'n insuok pha, miring lekkhat in Jisu diang raikhuo kaluut chong kasuokmak miring inkhat inhongruoi. ");
INSERT INTO kfw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Takkha raikhuo kha apuutsuok li apuutsuokmak, mipa kha chong ahongriljei, halli mi rakip inleingakjei. “Keini'n Israel suungnga hinna kati iteii khat-um lamu ngaimung!” inleiti. ");
INSERT INTO kfw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Takkha Pharisee ngai'n inleiti, “Ama'n raikhuo ngai waikaroonpa ranak ah hiwa raikhuo ngai ipuutsuok eii.” ");
INSERT INTO kfw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisu'n khuopui rakip le khuo rakip khan aleisi. Synagogue suungnga ama'n aleininchu, Rengram jarra chongkahoi ngai aleiril khat-um rirai kana mi ngaile kana rakip aleimindam. ");
INSERT INTO kfw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ama'n mipui ngai kha akakhaal kaboi keelngam ngai angnga inmalung inpoong khat-um kasansik kaboi kha amupha, amalungnga inmani kha aleipoongpui. ");
INSERT INTO kfw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Khawa jarra ama'n asiamruoi ngaidiang aleiti, “Leirakhool sik chu alok, takkha khawa akarakhool sik chuonmi chu intoom. ");
INSERT INTO kfw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ama leikarakhool sik chuonmi kha ajuotir nasik leimapupa diangkhan niru.” ");
INSERT INTO kfw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisu'n ama siamruoi soomleini ngai aleikoichun halli ratha kathamak ngai puutsuok nasik khat-um rirai le kana rakip mindam nasik thomatorna ranak inmani diang aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hiwa ngaihi tirton soomleini ngai raming ngaikha eii: Inkhat changna, Simon (Peter tia inkoi) khat-um ama anaipa Andrew; James le ama anaipa John, Zebedee sangai; ");
INSERT INTO kfw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip le Bartholomew; Thomas khat-um Matthew, rampar kakhuompa; James Alphaeus sapa, le Thaddaeus; ");
INSERT INTO kfw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Zealot Simon, khat-um Judas Iscariot, Jisu kapesuokpa. ");
INSERT INTO kfw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hiwa miring soomleini ngaihi anuoiya minchuna angjet ngaile inruoiya Jisu'n aleitir suok: “Zaatlop ngai ram khan simaru emakli Samaritan khuopui khannum luutmaru.” ");
INSERT INTO kfw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Khawa rathuulla, Israel mi ngai kamangnga kaom keelngam ngaidiang nangni siru. ");
INSERT INTO kfw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Nangni'n hin ningsipha, Marwaan Rengram hi anaijei! ti-inlang rilru. ");
INSERT INTO kfw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Akana kha mindamru, akathi kha minring nookru, tuka-ang chikaom taksa kana in kana ah kaom ngai mindamru, raikhuo ngaikha puutsuokru. Nangni'n aman kaboiya ningmu kha, aman kaboiya peru. ");
INSERT INTO kfw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nangni ningmarsa ah soonna, dangka, emakli sumsenpum iteii choimaru; ");
INSERT INTO kfw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ramma ningsipha, sialkok, songkol inliak, kekok emakli sinasik kherol inchoimaru. Ajarchu chuonmi khan angme inmanisik arei kaom kha inpesik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nangni'n khuopui emakli khuo inkhat ningluut ah ningheiwa pha, tuka-ang inkhat in nangni karok ah kanadon ngai entokru, halli khawa munkha ningmathaan maklaiseng amale omsuomru. ");
INSERT INTO kfw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nangni'n innsuung ningluut phakhan, nangni chungnga kahoi kadai erase, tiru. ");
INSERT INTO kfw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Khawa inna kaom mi ngai'n nangni karok ah innadon inchu, ningmalung kadai donnachong kha omchak rase; takkha inmani'n karok ah innadon emak inchu, ningmalung daina donnachong kha nangni diang heikir rase. ");
INSERT INTO kfw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Khat-um innsuung emakli khuopui lekkhat in nangni karok ah innadon emakli nangni innarangai emak inchu, khawa munkha mathaanru halli ning keiiya rahut kha kathing thaakru. ");
INSERT INTO kfw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kei'n nangni diang inthiangnga karil khachu khawa khuopui mi ngai diang neek ah, Chongtan Nikhuo khan Pathian in Sodom li Gomorrah mi ngaidiang kakheel riangwai amalarsik eii!” ");
INSERT INTO kfw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Rangairu! kei'n nangni hi malang ngai karra keelngam khale in-angnga kinatir eii. Maruul angnga insingtheiru khat-um wathu angnga malungkadai eru.” ");
INSERT INTO kfw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Insingtheiru, ajarchu khawa khan nangni kanasursik tuka-ang inom khat-um chongtanna khan nangni innaruoisik eii, halli inmani'n nangni Synagogue ah inawuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Halli kei kajarra ramwai karoon ngaile rengngai maikuungnga zaatlop ngaile inmani diang sakhi sik ah innaruoisik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Inmani'n nangni sakhi sik innakeisuo pha, angme katisik emakli angtho-thoa karilsik me tia ningmalung minpoong maru. ");
INSERT INTO kfw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nangni rilsik chongramol ngaikha nangnita enuni; chongramol ngaikha nangni diangnga karil ning Pa ratha ah inphut hongkasuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mi ngai'n inmani unai ngaitak kha thatna sik ah inpesuoksik eii, khat-um pa ngai innum khale in-angrip ah inmani sangai diang inthosik eii; halli sangai innum inmani nu le pa ngai chungnga hei-inlet inta inmani inminthatsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kei jarra mi rakip in nangni innamatirsik eii. Takkha ahekna katung kadei ngaikha inringsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Khuopui inkhat ah inmani'n nangni innaminpoong pha, khuopui inkhat tiang taandelru. Kei'n inthiangnga nangni diang karil Miring Sapa juokir makma, nangni Israel khuopui rakip ah ningchuon leiminhek nutun. ");
INSERT INTO kfw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Siamruoi inkhat in ama ochapa neek ah lokmak; suok inkhat in amapupa neek ah lokmak.” ");
INSERT INTO kfw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Khawajarra siamruoi inkhat in ama ochapa hong angjei, khat-um suok inkhat in ama mapupa ahong ang jei inchu hunjei. Innsuung khurra alu kha Beelzebul tia inkoi inchu, innsuungkhur mi ngai khachu angtuk ah kase ah inkoisik me! ");
INSERT INTO kfw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ajarchu mi ngaikha chimaru. Ang e-innum tuunna inmakhu rakip la inkhununi, khat-um ruuk ah intho rakip inlajet wiaksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kei'n nangni diang aziingna ah angme kiril kha nangni'n suunwarra ningril kirsik eii, halli angme ruuk ah ningjet kha innchungnga ninglarilsuok sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Taksa chu kathat mator takkha ratha kathat matormak ngaikha chimaru; khaneek ah, taksa li ratha innireella meikhurra kaminmang mator Pathian kha khella chiru. ");
INSERT INTO kfw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Dangkapum inkhat ah wacharek inni nangni'n ningracho mator, takkha wacharek inkhat-um neipilchungnga ning Pa lungdou eleiya juotamak. ");
INSERT INTO kfw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nangni sik achu, ningluwa kaom ningsam ramol katung ateelsuo jei. ");
INSERT INTO kfw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Khawajarra chimaru; wacharek katamtak ngai neek ah nangni aman katam ning-eii! ");
INSERT INTO kfw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tu-ennum mipui maikuungnga kei kanaralaang kha kei innum ama kha marwaanna kaom Kapa maikuungnga karalaangsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Takkha mi ngai maikuungnga kei kanazootmak kha, Kei innum marwaanna kaom Kapa maikuungnga zootpinuning. ");
INSERT INTO kfw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kei'n nuoipilchungnga kadai kapesik kijuo eii ti ngaidon maru. Emak, kei kadai heikachoi sik ah kijuo emak, takkha raalchem kape sik kijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kei'n pa li asa ngai, nu li asanu ngai, halli tarpi li amoinu ngai kaminhal sik kijuo eii; ");
INSERT INTO kfw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nangni inhalpui kasekhet khachu na-innsuung mi ngaikha in esik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tuka-ang kei neek ah apa emakli anu kaminriang ngaikha kei siamruoisik rahoi suokmu; khat-um tuka-ang kei neek ah insapa emakli insanu kaminriang ngaikha kei siamruoi sik rahoi suokmu. ");
INSERT INTO kfw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tuka-ang in inmani cross kadom leiya kei kanajui ngaikha kei siamruoi sik rahoi suokmu. ");
INSERT INTO kfw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tuka-ang inringkhuo kaminriang ngaikhan khawakha inminmang sik eii; takkha tuka-ang inringkhuo kei sik ah kaminmang ngaikhan khawakha inmu sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tu-ennum nangni kanadon ngaikhan kei innadon eii; khat-um tu-ennum kei nakadon khan kei najuokatirpa kha idon eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ajarchu tuka-ang in Pathian chongkachoi inkhat kha ama Pathian chongkachoi eii tia akadon khan Pathian chongkachoipa tum kha aralaangsik eii; halli tuka-ang in mikadik inkhat kha ama hi mikadik inkhat eii tia akadon khan mikadikpa tum kha aralaangsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kei'n nangni diang inthiangnga kiril eii, tu-ennum hiwa ngai karra akasiin khet kasiamruoi inkhat kha tuidai rabing inkhat kape khan suoileiya ama tum amusik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisu'n ama siamruoi soomleini ngai hiwa minchuna ngai apesuo pha, khawa munkha amasuo ah Galilee khuopui ngaikhan kaminchusik li chongkarilsik aleisijei. ");
INSERT INTO kfw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","John Baptist in mikhumna suungnga angme Christa itho ngai jarra ajet pha, Christa diang ama siamruoi ngai lekkhat ama'n aleitir. ");
INSERT INTO kfw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jisu diang inmani'n inrakel, “Keini diang narilpiro,” “John in alajuo sik eii itipa kha nang na-ebe, emakli tuka-ang khat kinlangaak sikbe?” ");
INSERT INTO kfw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisu'n aleimasang, “Kirru halli angme ningmu khat-um ningjet ngaikha John diang rilpiru: ");
INSERT INTO kfw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mitkacho in amu, kekakiak in asithei, tuka-ang chikaom takbangri kana ngai aminthiang, kuorkaseet in ajet, akathi kha aminringnook, khat-um Chong Kahoi ngaikha sara ngaidiang aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tuka-ang kei jarra inngamsamna kaneimak mi kha angtuk rawaan kathame!” ");
INSERT INTO kfw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John siamruoi ngai'n insisuo phakhan, Jisu'n John jarra mipui ngaidiang aleiril: “Nangni'n neelramma ningsi pha, angme nangni'n enkinte tia ningsi? Leihardoon thikaraang in iseemkun kha be? ");
INSERT INTO kfw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Emakli angme enkinte tia ningsi? Puondiar kathatak ah inliang mipa kha be? Khawa ka-ang inliang mi ngai khachu reng koolla in-om! ");
INSERT INTO kfw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kei diang rilru, nangni ang musik tia ningsuok me? Pathian chongkachoi kha be? Oh inthiangtak ah, kei'n nangni diang kati, John kha Pathian chongkachoi inkhat neek ah akalok kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","John amatak jarra eii chong inthiang in ileiti kha: Pathian in ati, kei'n kei chongkachoipa nang namatiang nangsik ah lam kamalong kajuotirsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Inthiangnga kei'n nangni diang kanarilpi, numeisa ngai'n innei karra John Baptist neek ah kalok tuteii la-injir mak, takkha marwaan rengramma kasiinkhet kha ama neek ah kalok kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","John Baptist in achong aril pha makheiya inphut tuun katung marwaan rengram hi poongraalna nuoiya alaom halli poongraalna kape mi ngai'n khawa kha surnasik inlatho. ");
INSERT INTO kfw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ajarchu John pha katung Pathian chongkachoi ngaile Moses Dan khan Rengram jarra inleiril; ");
INSERT INTO kfw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","John hi alakajuo sik Elijah kha eii tia inleiril inmani chong kha ningralaang zoot inchu, ");
INSERT INTO kfw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Rangairu, ningkuor indou inchu!” ");
INSERT INTO kfw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tuun, kei'n hiwa khang hi angleme kaminkhi sik? Inmani ngai khachu naipang phurjuorna munna in-ong ngai khale in-ang. Rupkhat ngaikhan aleiilak ngaidiang inkheek ah inti, ");
INSERT INTO kfw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Keini'n moiruoi khuong li dar nangni sik ah kinsut, takkha nangni'n laam makchu! keini'n kathi laa kinsak, takkha nangni'n chapmakchu!’ ");
INSERT INTO kfw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ajarchu John in bak inleiya aleijuo, halli inmani'n ‘Ama suungnga raikhuo om inti!’ ");
INSERT INTO kfw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","han miring Sapa ajuo ah bu bak halli tui in, han inmani'n inti enro olkalok ju ka-inpa, rampar kakhoom ngaili ‘Manu karoon ngai sap!’ takkha Pathian singna hi ama chuon khan adik tia amalar.” ");
INSERT INTO kfw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisu'n ama chuon-inlak katam athona khuopuiya kaom mi ngai'n inmanu ah inphut malungthuul nunu, khawa jarra ama'n khawa khuopui ngaikha aleiran. ");
INSERT INTO kfw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Hiwahi nangni sik ah angtuk poong kaom sikme, Chorazin! nang sik um angtuk poong kaom sikme, Bethsaida, nang sik um angtuk poong kaomme! chuon inlak nangni chungnga kitho ngaikha Tyre li Sidon chungnga kaleitho inchu, matiang khan khanna kaom mi ngaikhan inmani manu ah inphut malung thuulna kapoong puondiar tho inta khat-um inmani chungnga rahut inlei innootsik ejei! ");
INSERT INTO kfw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kei'n nangni diang inthiangnga karil khachu Chongtan Nikhuo khan Pathian in nangni neek ah Tyre li Sidon mi ngaidiang minriang kha amalarsik eii! ");
INSERT INTO kfw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Khat-um Capernaum nang um marwaan katung natheinuo ah na-indom saang zootbe? Nang chu meikhurra innahiai sik eii! nangni diangnga intho chuon inlak ngaikha Sodom chungnga inleitho inchu, wini katung sodom laleiom sik eii! ");
INSERT INTO kfw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Takkha kei'n nangni diang kati, khachu Chongtan Nikhuo khan Pathian in nangni diang neek ah Sodom ram sik ah kheella minriang amalarsik eii!” ");
INSERT INTO kfw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Khawa phakhan Jisu'n ati, “Pa, marwaan li nuoipil Pumi! kei'n nang kanaminpaak ajarchu nang in angme kasing li kajet ngaidiang nathup kha kasiin naipang ngaidiang namalarjei.” ");
INSERT INTO kfw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oh, Pa, hiwahi nalungdou kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Kapa'n angrakip kei diang anapesuojei. Pa khan eleiya tu inkhat innum Sapa kha jetmu, khat-um Sapa khan eleiya tu inkhat innum Pa kha jetmu halli Sapa in ikadang ngaikha ama diang amalar.” ");
INSERT INTO kfw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Phurrik karoonna kapoong nangni rakip kei diang hongru, halli kei'n nangni soong kanamachum sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kanamkol lei-inlang roonru, kei diang inphut inchuru, ajarchu keichu kamalung adai khat-um kanunchan inchuol; halli nangni'n ning ratha sik ah soongmachumna muningte. ");
INSERT INTO kfw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ajarchu kanamkol roon abei khat-um kaphur zaang.” ");
INSERT INTO kfw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Khawasuo sootlekleiya Jisu'n Sernikhuo inkhat ah gehubil asamma aleisi. Ama siamruoi ngaikha inwon aleichampi, khawa jarra inmani'n gehu wuui inchinna khat-um gehuru kha kabak inleiphut jei. ");
INSERT INTO kfw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hiwahi pharisee ngai'n inmupha, inmani'n Jisu diang inleiti, “Enru, Hiwa Sernikhuo ni nasiamruoi ngai'n thomak sik eini sina Dan izootmak kha intho!” ");
INSERT INTO kfw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisu'n aleimasang, “David inruoipui ngaile ama awon achampha angme inleitho nangni lateel ngaimak chube? ");
INSERT INTO kfw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ama'n Pathian inna aluut ah, thiampu ngai bit bak kacha inmani bak sik chu Dan izootmak, Pathian diangnga inpe waipool kha, ama khat-um ama inruoipui ngai'n inleibak. ");
INSERT INTO kfw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kha emakli Jihudi ngai sernikhuo rakip thiampu ngai'n Biak-inn suungnga Jehudi ngai sernikhuo Dan inmakoi innum inmani masialna ommak ti Moses Dan kha nangni lateel ngaimak chube? ");
INSERT INTO kfw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Biak-inn neek ah akalok angmekhat hin om tihi kei'n nangni diang kanarilpi eii. ");
INSERT INTO kfw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Chong inthiang in ati, ‘Kei imanuom khachu riangwai kha eii, sa ah doiphur inpe kha emak.’ Nangni'n hiwahi inthiangnga angtiname ningleijet inchu, thosialna kaneimak mi ngaidiang nangni'n noonkuung ninglei pemak sik eii; ");
INSERT INTO kfw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ajarchu miring Sapa hi Sernikhuo Pumi kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Khawa mun amathaanna Jisu Synagogue inkhat ah aleisi, ");
INSERT INTO kfw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Khawa munkhan akut kathi miring inkhat aleiom. Halli Jisu ithosial noonkuung pesik kamanuom mi lekkhat kha khan inlei-om, “Sernikhuo ni mi mindam sik hi eini sina Dan izootbe?” tia inmani'n ama diang inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisu'n aleimasang, “Nangni karra inkhat in keelngam inkhat anei halli khawa kha inthuuk khur inkhat ah Sernikhuo ni ata inle ama'n mahuum li keisuo makniya be? ");
INSERT INTO kfw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Miring inkhat in keelngam inkhat neek ah aman atamwiai! khawa jarra, Sernikhuo ni chuon katha thosik hi Dan izoot kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Halli ama'n kut kathi mipa diang ati, “Nakut heisoonro.” Ama'n akut aheisoon, halli kaangkhat tiangle in-angrip ah, akut kha adamjei. ");
INSERT INTO kfw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Halli Pharisee ngai'n insuok ah khat-um Jisu thatnasik ah ininsiam jei. ");
INSERT INTO kfw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisu'n ama chungnga thatnasik ininsiam kha ajetpha, khawa mun makheiya aleisijei; khat-um mi katamtak in ama inleijui. Ama'n akana rakip aleimindam ");
INSERT INTO kfw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","halli inmani diang ama jarra aleiilak ngai diang rilpi maknasik ah chong kanatak aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Hiwa ama'n athona jarchu Pathian chongkachoipa Isaiah diangnga Pathian in angme ileiti kha huui tungnasik eii: ");
INSERT INTO kfw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Enru, kei'n kikadang jei, kasuok, kiminriangpa kha, achungnga kamalung atai, Kei'n ama chungnga karatha kajuotirsik eii, halli ama'n zaat rakip diang kachongtanna kha arilsuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ama'n murruolsiak thonuni emakli kheeknuni, halli tu inkhat innum lampui ngaikhan arasa jetnunu. ");
INSERT INTO kfw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Matorna chongtan katuun aminsi maklaiseng, ama'n tuoitung kakui inkhat minkiak nuni, thisikkatho meiser kha thatnuni. ");
INSERT INTO kfw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","halli ama chungnga mi rakip in ngamna indasik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Miring lekkhat in Jisu diang raikhuo kaluut mitkacho khat-um chongkaril theimak miring inkhat inhongruoi. Jisu'n mipa kha aleimindam, khawa jarra ama'n chong rilthei jei halli amujei. ");
INSERT INTO kfw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mipui rakip in Jisu ithohi angme tia inleingak, “Amahi David Sapa emak be?” tia inmani'n inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pharisee ngai'n hiwahi inleijet pha, inmani'n inleimasang, “Ama'n raikhuo ngai ipuut suok hi inmani lamkakei Beelzebul in ama diang ranak ape jarra eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisu'n angme inmani ngaidon kha aleijet, halli inmani diang ama'n aleiril, “Rengram rakip in intheinuo ah rup inthenkhoiya inkhat li inkhat ininsuol inchu kasoot ah ngirmatornunu. Halli khuopui inkhattak emakli innsuungkhur inkhat li inkhat ininsuolla rup inthenkhoi inchu lekni ah chulsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ajarchu Seitan in Seitan kha apuutsuok inchu ama amatak chungnga inthenkhoi jei, kha ejei inle ama rengram kha langir matorniabe? ");
INSERT INTO kfw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kei'n Beelzebul ranak ah raikhuo ngai kapuut suok inle ningnuk kajui ngai'n tu ranak ah inmani inpuut suok me? khawa jarra inmani'n nangni chongkatan ngaikha in esik ejei! ");
INSERT INTO kfw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Takkha kei'n Pathian ratha ah raikhuo ngai hi kapuut suok jei inchu Pathian Rengram kha nangni chungnga ajuokatung ejei. ");
INSERT INTO kfw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Emakli akaraat mipa kha ma-insa ah khit leiya tume mi karaatpa inn kha makoi li ama phurpai ngai kalei matorsik? Inkhit suoli bit ama inna kaom phurngai kha amaruup matorsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tu e-innum kei le inruoimak ama kha kei na-inhalpui eii; halli tu e-innum kei le inruoiya nakakhompui mak ama kha inthiangnga akakalekchen kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hiwajarra kei'n nangni diang kiril eii, miring ngai manu rakip le inmani'n inril akathamak rakip kha inngaidam pisik eii, takkha tu e-innum Ratha Inthiang kha kase ah karil kha rangaidam nuni. ");
INSERT INTO kfw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Halli Miring Sapa chungnga karilse tuka-ang ama kha arangaidam sik eii, takkha Ratha Inthiang chungnga akaril tuka-ang ama khachu tuun emakli apha rakip ah rangaidam omnuni jei. ");
INSERT INTO kfw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Thingkuung kha mintharu halli akara kha atha sik eii; emakli thingkuung kha minthamaru halli ama kara kha thanuni, ajarchu thingkuung khachu ama kara khanna nijet eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E, maruul tusuon ngai, nangni'n kathachu emak chu ah angtho-thoa akatha chong ningril sikme? Ajarchu angme ningmalungnga kasip ngaikha murra ningrilsuok. ");
INSERT INTO kfw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mikatha mi'n akatha phur kha akarei makheiya akatha phur aheikeisuo, khat-um akathamak mi in akathamak phur kha akarei makheiya akathamak phur ngai aheikeisuo. ");
INSERT INTO kfw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Kei'n nangni diang karil, mi ngai'n inleiril chongriam rakip ngai Chongtan Nikhuo khan ajar kha inlape sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ajarchu nang hi akadik emakli kadikmak eii ti malar nasik nachongril ngaikha neiman inta nang kha chong innatanna sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Halli Dan ocha lekkhat li Pharisee lekkhat ngai'n inti, “Ocha,” “keini'n nang diangnga chuon-inlak inkhat nitho kinmuzoot.” ");
INSERT INTO kfw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","“Khawakhan Jisu'n aleimasang, kathamak li zool-inthai tuunna khang mi ngai'n chuon-inlak kha innarakel, takkha Pathian chongkachoi Jonah diangnga inpe chuon-inlak kha elekleiya chuon inlak inkhat-um khawa khan napenuni jei. ");
INSERT INTO kfw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah apumtak nga kalok suungnga suunthum le zaanthum alei-om khale in-angrip ah, Miring Sapa kha nuoipil suungnga suunthum zaanthum alaomsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nineveh mi ngai'n Chongtan Nikhuoni hongngir inta halli nangni kha noonkuung innape sik eii, ajarchu Jonah chongril kha inmani'n injet pha inmanuwa inphut inmalung inleithuul; kei'n nangni diang kiti khachu enru Jonah neek ah kalok inkhat hin aom. ");
INSERT INTO kfw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Chongtan Nikhuoni khan Sheba Rengnu in hongngirta halli nangni kha noonkuung innapesik eii, ajarchu aram makheiya Reng Solomon singna iminchu kha akarangai sik aleihong; takkha enro, kei'n nangni diang kati, Solomon neek ah kalok inkhat kha hin aom! ");
INSERT INTO kfw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Miring inkhat suungnga ratha kathamak inkhat aheisuok pha, ama'n tui ommakna ramma aleisiya soongmachum nasik mun inkhat aleiratok, takkha leimumak. ");
INSERT INTO kfw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ama'n atheinuo ah inti, ‘Kei ka inna kei kirtak te.’ Halli ama akirra inn karuok, inthiang khat-um katha ah inda kha ajuomu. ");
INSERT INTO kfw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Khawa phakhan ama asuok ah amaneek ah akathamak ratha sari aheiruoi, halli khawa khan inmani inhongnga in-om jei. Khawa jarra miringpa ringkhuo kha matiangnga omchan neek ah ahekna kha kheella thamakjei. Hiwahi eii tuunna khang mi kathamak ngai diang alakasuok sik.” ");
INSERT INTO kfw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisu'n mipui ngaidiang chongril laitak khan, enru, anu le anai ngai'n ama in-inbiakpui zoot ah inmani'n tuolla inleingir. ");
INSERT INTO kfw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Khawa jarra mi inkhat in ama diang aleiti, “Enro, nanu li nanai ngai'n nang inna-inbiakpui zoot ah inmani'n tuolla inngirra inom.” ");
INSERT INTO kfw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisu'n ama diang aleimasang, “Tume kei kanu? Tu ngaime kei kanai ngai?” ");
INSERT INTO kfw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Halli akut akhiinna asiamruoi ngaidiang aleiti, “Enru! Hinna kaom ngai hi kanu le kanai ngaikha in eii! ");
INSERT INTO kfw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ajarchu marwaanna kaom Kapa lungdou katho ngaikha kanai, kasar khat-um kanu in eii.” ");
INSERT INTO kfw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Khawa nikhuo takkhan Jisu'n inn kha amathaanna asuok ah tuidiil khamtiang aleisi, khawakhan ama'n kaminchu sik ah alei in-ong. ");
INSERT INTO kfw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mipui katamtak ama koolla inlei inchun khawa jarra ama'n rakuong inkhat suungnga aluut ah alei in-ong, halli mipui katamtak in tuikham khan inleingir. ");
INSERT INTO kfw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Khawa khan Jisu'n chongminkhina aneiya chong angjet inmani diang aleirilpi. “Enru, leikaneipa kha amuchi kawor sik aheisuok jei. ");
INSERT INTO kfw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ama'n leiya muchiru aheiwor pha, lekkhat in lamsirra achul, halli wa ngai inheiwa ah inruut li inbak. ");
INSERT INTO kfw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aru lekkhat in lung chungnga neipil toomna mun ngaikhan achul, neipil inthuukmak jarra aru kha innottheiya ahongkek. ");
INSERT INTO kfw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Takkha kani hongsa phakhan achiak teii ngaikha inwuoi jei; ajarchu arajung kha inthuuk ah leisimak, khale inruoiya achiak ngaikha innot ah acharjei. ");
INSERT INTO kfw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aru lekkhat in raling karra achul, ahongmoong takkha achiak kha raling in amakhujei. ");
INSERT INTO kfw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aru lekkhat in neipil hoina khan achul, halli lekkhat in rajakhat, lekkhat in soomruk, khat-um lekkhat in soomthum ahong inra.” ");
INSERT INTO kfw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Halli Jisu'n ahekna ah ati, “Akuor indou ama khan rangai rase!” ");
INSERT INTO kfw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Khawasuo khan siamruoi ngai'n Jisu diang inhongnga inleirakel. “Angsikme nang in mipui ngaidiang chongnaril pha chongminkhina nineiman?” ");
INSERT INTO kfw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Halli Jisu'n aleimasang, “Marwaan Rengram jarra inthup ngai jetnasik nangni diang innapejei, takkha inmani diang chu emak.” ");
INSERT INTO kfw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ajarchu mi kaneipa diang khan kheella inpedel sik eii; takkha iteii akaneimak mipa ama diangnga inphut inei lekteii kha um inkhaidel sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kei'n chongminkhina kaneimanna inmani diang karilna ajarchu inmani'n in-en, takkha mumu, inrangai, takkha jetmu emakli ngaidon matormu. ");
INSERT INTO kfw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Halli Isaiah chongril kha inmani diang pui ahongtung jei: Hiwa mi ngai'n rangai chu rangai inte, takkha jetnunu; inmani'n enchu en inte, takkha mununu, ");
INSERT INTO kfw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ajarchu inmani malungnga jetzootmu, inmani inkuor khan rangai zootmu halli inmit kha inkasiingdel. Kha emak inchu, inmani inmit in inmusik eii, inkuor khan inrangai sik eii, inmalung khan injetsik eii, Pathian in ati, inmani kei diang inhong inletsik eii, halli kei'n inmani kamindam sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Nangni sik ah chu, angtuk ningrawaan kathame! Ning mit in amu halli ning kuor in ajet. ");
INSERT INTO kfw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nangni diang inthiangnga kei'n karil khachu Pathian chongkachoi ngai li mi katuun ngai'n angme nangni imu kha inleimu zoot, takkha leimu matormu, halli angme nangni ijet ngaikha leijet matormu. ");
INSERT INTO kfw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Hanchu, muchi kaworpa chongminkhi in angme iti kha rangairu halli inchuru. ");
INSERT INTO kfw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tu ennum Rengram jarra chong kha ajetli akangaidon tungmak ngai kha hiwa lamkoolla kachul muchiru khale in ang. Akathamak kha aheiwa ah inmani malung suungnga inwor muchi kha aleikhaipi. ");
INSERT INTO kfw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lungkarra kachul muchi khachu tuka-ang in chong kha injetli innot ah karok ah kakeiluut ngaikha tina eii. ");
INSERT INTO kfw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Takkha inmani diang arajung kha inthuukmak jarra soot leidei matormu, Khawa chong jarra poongna emakli raalna aheiwa pha khan, inmani innot ah inmangjei. ");
INSERT INTO kfw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Halli raling karra kachul muchiru ngaikhan tuka-ang chong kha kajet; takkha hiwa ringkhuo jarra poongna le neile nung manuomna ngaikhan chong kha adiip ah, inmani kakara mak ngaikha atina eii. ");
INSERT INTO kfw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Halli neipil hoina munna inwor muchiru ngaikhan tuka-ang chong kha rangai li kajet: lekkhat in rajakhat, lekkhat in soomruk, halli lekkhat in soomthum kakara ngai tina eii.” ");
INSERT INTO kfw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisu'n chongminkhi inkhat arilla aleiti: “Marwaan Rengram khachu miring inkhat in muchiru katha kha aleiya iwor khale in-ang. ");
INSERT INTO kfw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Halli zaankhat, mi rakip inzaal pha, ama inhalpuipa kha aheiwa ah halli gehu karkhan leiharru aworra aleisijei. ");
INSERT INTO kfw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Achiak ngaikha ahonglok halli abuo ahongsuok pha khanchu leihar ngai kha um indangjei. ");
INSERT INTO kfw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Mipa suok ngaikhan ama diang inheiwa ah inti, ‘Ocha, nang in naleiya muchiru katha niwor emak abe? honname hiwa leihar ngai kaheiwa hi?’ ");
INSERT INTO kfw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Hichu naka enzootmak lekkhat itho eii,’ tia ama'n aleimasang. ‘Asuok ngaikhan amadiang inrakel, keini kinsili leihar ngai kinjuochuon sik hi namanuom be?’ ");
INSERT INTO kfw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ama'n aleimasang, ‘Chuonmaru,’ ‘ajarchu nangni'n leihar ningchuon kaalkhan gehu lekkhat um inphoidel acha. ");
INSERT INTO kfw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Gehu le leihar kha inniya inrakhool maklaiseng moongsuom tarasu. Kei'n leikarakhool ngai diangkhan tipitakte ma-insa ah leihar kha khoomchun inlang haal sik ah khitchunru, halli gehu kha khomchun inlang kei sapang khan juothunru.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisu'n inmani diang chongminkhina khat apenook ah ati: “Marwaan Rengram khachu miring inkhat in anchamru kha aleili ama leiya iwor hile in-ang. ");
INSERT INTO kfw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hiwahi muchiru rakip karra akasiin khet kha eii, takkha ahongmoong pha khanchu, thingchiak ngai karra akalok khet thingkuung ahong eii. Khawajarra lairalak ah wa ngai'n inheiwali abaak ngaikhan inrabu inhong phan.” ");
INSERT INTO kfw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisu'n inmani diang chongminkhina inkhat arilnook ah ati: “Marwaan Rengram khachu, numeisa inkhat in chol lekkhat aleiya waipooldi saida inthum khan minchella chol hongthei maklaiseng ida khale in-ang.” ");
INSERT INTO kfw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisu'n hiwa rakip ngaihi chongminkhina kha aneimanna mipui diang aleiril; ama'n chongminkhina neiman lekleiya iteii um inmani diang leirilmak. ");
INSERT INTO kfw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ama'n hiwa itho ngaihi Pathian chongkachoipa ileiril kha huui tungnasik eii, “Chongminkhina neimankata kei'n inmani diang chong karilsik eii; Nuoipilchung inbool makheiya inthup rakip ngaikha inmani diang kei'n karilsuok sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisu'n mipui ngai ada ah inn suungtiang aluut pha, ama siamruoi ngai inheiwa ah ama diang injuoti, “Leihar ruwa chongminkhina hin angme tina keini diang narilpiro.” ");
INSERT INTO kfw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisu'n aleimasang, “Muchiru katha kaworpa kha Miring Sapa kha eii; ");
INSERT INTO kfw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","lei khan nuoipilchung hi eii; muchiru katha ngaikhan Rengram mi ngaikha in eii; leihar ngaikhan Akathamakpa sangai kha in eii; ");
INSERT INTO kfw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Halli inhalpui leiharru kaworpa ama khan Seitan kha eii. Saangrakhool pha khan nuoipilchung hekni kha eii, halli saangkarakhool ngaikhan marwaan tirton ngaikha in eii. ");
INSERT INTO kfw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Leihar ngaikha inkhoomchunna meiya inhaalle in angrip ah, nuoipilchung hekni khannum hi angnga alasuoksik eii: ");
INSERT INTO kfw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Miring Sapa in ama marwaan tirton ngaikha juotirta mi ngai manu ah kamachul ngaile thomaksik katho ngai rakip ama Rengram makheiya alaminchunsik eii, ");
INSERT INTO kfw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","halli inmani kha meisuungnga indeengluutsik eii, khawamun khan inmani chap le hakarialna inlanei sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pa Rengram khan Pathian mi ngai'n kani angnga inlawar sik eii. akuor indou ama khan rangai rase! ");
INSERT INTO kfw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Marwaan Rengram hi, Miring inkhat in leiya inphuumma kaom amankatam neinaak inmu khale in-ang. Ama'n amakhudella karok ah asiya ineirakip ajuorra, halli akirra lei kha ajuo incho jei. ");
INSERT INTO kfw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Halli Marwaan Rengram hi, Mi inkhat in lungman katamkhet iratok khale in-ang, ");
INSERT INTO kfw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ama'n lungmankatam amu pha, ama asiya, inei rakip kha ajuorra halli khawa lungman katam kha ajuo incho jei. ");
INSERT INTO kfw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Woikhat um, marwaan Rengram hi, ngaphung rakip kasur ngakasurmi lekkhat in tuidiil suungnga inmani leen inwor khale in-ang. ");
INSERT INTO kfw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Leen kha asip pha, inmani'n tuikham tiang inkeisuo ah halli in-in ongnga nga katha seng kha paisuungnga inthun halli kathamak sengkha inkalekjuon jei. ");
INSERT INTO kfw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nuoipilchung hekni um hiwa laka ang sik eii: marwaan tirton ngaikhan lajuo inta mi katha ngai diangnga inphut mi kathamak ngai kha lathen inta ");
INSERT INTO kfw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","halli inmani ngaikha meisuungnga inlahiailuut sik eii, khawa munkhan inmani chap le hakarialna inneisik eii. ");
INSERT INTO kfw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Hiwa rakip hi nangni ningjet jeibo?” tia Jisu'n inmani diang aleirakel. “Kinjetjei” tia inleimasang. ");
INSERT INTO kfw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Halli khan ama'n aleimasang, “Hiwa tinachu, marwaan Rengramma siamruoi ka eii Sinadan ocha rakip ngai'n ama neinaak bukna makheiya inphut phur kathar li maruo heikakeisuo inn-pupa khale in-ang.” ");
INSERT INTO kfw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisu'n hiwa chongminkhina arilsuo pha, ama'n khawa munkha aleimathaan jei ");
INSERT INTO kfw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","halli ama'n akhuo tiang akirnook jei. Inmani Synagogue khan aleiminchu, halli ama minchuna kajet rakip in inleingak ah inti, “Huwa makheiya ama'n hinnakati singwar imume?” Inmani'n inleirakel. “Halli chuon inlak ngai hile imume? ");
INSERT INTO kfw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Amahi thingchuon kathopa sapa emak abe? Anu Mary, James, Joseph, Simon khat-um Judas anai ngai emuwabe? ");
INSERT INTO kfw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Asar ngai rakip um einile hin niomsuom emak abe? Hunname hiwa rakip ama'n imu hi?” ");
INSERT INTO kfw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Khan intia inmani'n ama kha leizootmu jei. Halli Jisu'n inmani diang aleimasang, “Pathian chongkachoi inkhat hi amun rakip ah khoya intho takkha akhuo li a innsuungkhur mi ngai inchu khoya thomu.” ");
INSERT INTO kfw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ajarchu inmani'n leingamnamu jarra, khawakhan ama'n chuon-inlak kha katamma leithomak. ");
INSERT INTO kfw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Khawapha takkhan Galilee ramkaroonpa Herod in Jisu jarra aleijet. ");
INSERT INTO kfw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“Ama hi inthiangnga John Baptist, athiya inphut akaringnook eii tia asuok ngaidiang aleirilpi. Khawa jarra ama'n hinna kati chuon-inlak thomatorna ranak inei eii.” ");
INSERT INTO kfw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ajarchu Herod in anaipa Philip numei Herodias jarra John hi asurra, halli akhit ah mikhumna khan aleida. ");
INSERT INTO kfw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ajarchu John in Herod diang aleiti, “Herodias naneisik hi nangsik ah dan katuun kha emak!” ");
INSERT INTO kfw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","John kha Herod in aleithat zoot, takkha ama'n Jihudi mipui ngai kha aleichi, ajarchu inmani'n John hi Pathian chongkachoi inkhat eii tia inleilei. ");
INSERT INTO kfw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod inneina nikhuo khan Herodias sanu in mipui rakip maikuungnga aleilaam. khawa jarra Herod in amalung atai heiya ");
INSERT INTO kfw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kei'n khomaak ka-insaam khachu, nang in napero nititak kha “Kei'n kanape sik eii tia, ama diang chong alei inkhit!” ");
INSERT INTO kfw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ama'n anu chongrilpi dungjuiya Herod diang aleini, “Hiwahin tuun kei diang John Baptist lukha bukheeng chungnga da-inlang napero!” ");
INSERT INTO kfw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Reng Herod kha amalung aleipoong, takkha ama'n ama mi ngai maikuungnga achong-inkhitna dungjuiya ama imanuom kha thopinasik ah chong aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Khawa jarra ama'n mikhumna ah kaom John lu kha ajomintan. ");
INSERT INTO kfw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Khawa lu kha bukheeng chungnga inheichoiya nungaaknu diang inleipeii halli ama'n anu diang aleichoi jei. ");
INSERT INTO kfw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John siamruoi ngai kha inheiwa ah, akaluong kha inleichoiya inleiphuum; halli inmani inkirra Jisu diang inleirilpi jei. ");
INSERT INTO kfw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisu'n John jarra chong ngai ajet pha, ama'n rakuong achuongnga khawa munkha amathaanna halli atheinuo ah mirasa neimakna muntiang aleisi. Khawa kha mipui'n inleijet, halli inmani'n inkhuopui inmathaanna kelamma anuk inleijui. ");
INSERT INTO kfw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisu'n rakuongnga inphut ajuochum, halli mipui katamtak ngaikha ajomu pha, ama malung suungnga minriang khan aleisip, khawa jarra kana ngaikha aleimindam. ");
INSERT INTO kfw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Khawani kholeitiang ama siamruoi ngai'n inheiwa ah inti, “Tuunchu khuo aboijei, halli hiwa munhi um mi ommakna ram eii, mi ngai hi minsi suotaro halli inmani'n inkhuo ngaikhan sisu-inlang inmani sik bak-in jo-incho tarasu.” ");
INSERT INTO kfw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisu'n aleimasang. “Inmani simarasu,” “Inmani diang nangni'n baksik lekkhat kha peru!” ");
INSERT INTO kfw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Inmani'n inleimasang, “Keini'n waipool ranga li nga inni kinnei.” ");
INSERT INTO kfw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisu'n ati, “Khawa kha e-inchu hin keidiang heichoiru.” ");
INSERT INTO kfw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ama'n mipui ngaikha leihar chungnga in-ong nasik chong aleipeii; halli ama'n waipool ranga le nga inni kha aleiya, marwaan tiang enna halli Pathian diang aleiminpaak, Ama'n waipool kha katherkhoiya asiamruoi ngaidiang aleipeii, halli asiamruoi ngai'n mipui ngaidiang inleisempi. ");
INSERT INTO kfw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Akabak rakip ngaikha inleikhop, halli akaliam ngaikha siamruoi ngai'n inkhomchunna kokwar soomleini aleisip. ");
INSERT INTO kfw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Khawa aleikabak mi ngaikha numeisa naipang teelleiya, pasal seng lising ranga inlei eii. ");
INSERT INTO kfw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Khawasuo ama'n mipui ngaikha aminsi pha Jisu'n asiamruoi ngai kha um rakuong minchuongnga tuidiil raalkhat tiang ama matiang aleiminsi jei. ");
INSERT INTO kfw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mipui ngaikha atir suoli, ama'n nina sik atheinuo ah chingtiang aleikal. Kholei hongtung pha, khawa munkhan Jisu atheinuo ah aleiom; ");
INSERT INTO kfw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","tuikham makheiya rakuong khan tuidiil lai aheitung pha thipuile inintongnga, rakuong kha tuiphuuksan in aseemma leisi matormak jei. ");
INSERT INTO kfw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ziingtiang phadan inthum li kuruk pheiwei khan, Jisu'n asiamruoi ngaidiang tuichungnga aheiwa. ");
INSERT INTO kfw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Inmani'n tuichungnga ama iheiwa kha inleimuwa inmani'n inleichi. “Hiwa hi ratha kathamak eii!” intia chile inruoiya inmani'n inleikheek. ");
INSERT INTO kfw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisu'n inmani diang khawalai takkhan aleiti, “Malung mindong maru!” “Chimaru Kei ka eii!” ");
INSERT INTO kfw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Halli Peter in aleimasang, “Pumi, inthiangnga nang na-e inchu, nakoolla kei'n tuichungnga heiwa nasik chong napepiro.” ");
INSERT INTO kfw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Heiwaro” Jisu'n aleimasang. Khawa jarra Peter in rakuong makheiya achumma Jisu diang tuichungnga kasi aphut jei. ");
INSERT INTO kfw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Takkha ama'n thipui kangar kha amu pha, ama'n aleichi halli tui suungtiang kaluut phutjei. “Pumi, Nasanro!” tia aleikheek. ");
INSERT INTO kfw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Khawalai takkhan Jisu'n akut sonna ama mahuumma ati, “E inngamna kasiin! angsikme ni-inngamsam?” ");
INSERT INTO kfw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Inmani inin-niya rakuong khan inluutli, thikaraang kha ajuodai jei. ");
INSERT INTO kfw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Halli rakuong suungnga kaom siamruoi ngai'n Jisu kha chubei inleitho. “Inthiangnga nangchu Pathian Sapa na eii!” tia inmani'n inti. ");
INSERT INTO kfw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Inmani'n tuidiil kha inrakanna Gennesaret ram khan inheiwa jei, ");
INSERT INTO kfw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","khawa munna kaom mipui ngai'n Jisu kha inleijet, khawa jarra inmani'n chong inpeya khawa ramkoolla kaom akana mi rakip Jisu diang inmani'n inhong ruoi. ");
INSERT INTO kfw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Inmani'n Jisu diang apuon morbit katook nasik ah nina inleinei; halli akakatook rakip ngaikha inleidam jei. ");
INSERT INTO kfw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Halli Jerusalem makheiya Pharisee lekkhat le sina Dan ocha ngai'n Jisu diang inhongnga inhongrakel, ");
INSERT INTO kfw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Angsikme nasiamruoi ngai'n upa ngai sinadan kha inmakoi? Inmani'n inbak maklai inkut kha rasumu!” ");
INSERT INTO kfw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisu'n aleimasang, “Hanchu angtiyame nangni'n Pathian chongpeii juimakchuwa nangni ngai sinadan kha ning ijui? ");
INSERT INTO kfw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ajarchu Pathian in aleiti, ‘Nanu li napa kha khoya thoro,’ halli ‘Nang in nanu li napa diang khomaak nasaam inchu, nang kha innathat sik eii.’ ");
INSERT INTO kfw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Takkha nangni'n ningti, khachu mi inkhat in anu emakli apa diang santhei lekkhat inei kha, ‘Hiwahi Pathianta ejei ti-inchu,’ ");
INSERT INTO kfw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ama'n anu emakli apa kaya sik hi arei suokmak. Nangni minchuna kha juinasik ah hiwa lam tiang nangni'n Pathian chongpe kha kaya makchu jei. ");
INSERT INTO kfw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nangni akatha omchan kathongai! Angtuk katuunme nangni jarra Pathian chongkachoipa Isaiah ileirilsuok kha! ");
INSERT INTO kfw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Pathian in ati, hiwa mi ngai'n, kei hi inmur beiya khoya innatho, takkha inmalung chu kei diangnga inphut kalaak ah in-om. ");
INSERT INTO kfw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kei chubei innathohi inmani sik anemna ommak ajarchu inmani'n miring sinadan ngaikha Kei sinadan ngai angnga inminchu!’ ” ");
INSERT INTO kfw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Halli Jisu'n mipui ngai kha akoiya inmani diang ati, “Rangairu halli jetru! ");
INSERT INTO kfw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ning bai suungnga kaluut khan nangni naminchok mak; khawa neek ah ahong kasuok khan nangni anaminchok.” ");
INSERT INTO kfw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Halli siamruoi ngai'n ama diang inheiwa ah inti, “Nang in tuuntak angme niril khan Pharisee ngai malung namintookpi nang nijetmak be?” ");
INSERT INTO kfw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisu'n aleimasang, “Marwaanna kaom kapa ilingmak thingkuung rakip inlaphuk sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Inmani sik ngaidon pimaru! Inmani chu mitkacho ngai lamkakei mitkacho kha in eii; mitkacho inkhat in mitkacho kha lam akei inchu inin nireella khurra inta sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter in Jisu diang aleiti, “Hiwa chongminkhina hi keini diang narilcheen piro.” ");
INSERT INTO kfw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisu'n inmani diang aleiti, “Nangni tuun katung aleiilak ngai neek ah lajetmak chu. ");
INSERT INTO kfw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nangni ningmurra kaluut phurrakip kha ningwon suungnga aluut halli ningpum makheiya asuok tihi nangni ninglajetmak be? ");
INSERT INTO kfw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Takkha murra hongkasuok kha malungnga inphut eii, halli hiwa ngaihin nangni anaminchok. ");
INSERT INTO kfw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ajarchu ningmalungnga inphut ah akathamak ngaidonna, mithatna, zool-inthaina, halli aleiilak thamakna katho; inrupmaret, maleisei halli aleiilak karilse ngaihi hongkasuok eii. ");
INSERT INTO kfw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hiwa ngai rakip in nangni naminthiangmak. Takkha inmani iti angnga kut rasuleiya inbak in nangni naminchok mak.” ");
INSERT INTO kfw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Khawa munkha Jisu'n aleimathaanna Tyre li Sidon ram koolla aleisi. ");
INSERT INTO kfw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Khawa ramma kaom Canaan numeisa inkhat ama diang hongnga, halli akheek ah ati, “David Sapa!” “Kei naminriangro, ocha! Kei kasanu kha raikhuo aluut ah poongtheiya omjei.” ");
INSERT INTO kfw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Takkha Jisu'n chongbai inkhat um ama diang leimasang mak. Asiamruoi ngai'n amakoolla inheiwa ah inti, “Ama minsitaro! Ama'n eini nuk anajuiya akheek ah om!” ");
INSERT INTO kfw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisu'n aleimasang, “Israel keelngam inmang ngai sikbit ah kei innajuo tir eii.” ");
INSERT INTO kfw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Halli numeisa inkhat aheiwa ah akekuungnga inbok li, “Ocha, kei nasanro!” ati. ");
INSERT INTO kfw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisu'n amasang, “Naipang ngai bu an kha leili ui ngai diang pesik hi akatuun emak.” ");
INSERT INTO kfw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Atuun khawa kha, ocha,” numeisanu khan aleimasang, “Takkha ui innum inmapupa bubakna makheiya juokata buramol ngai kha inbak.” ");
INSERT INTO kfw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Khawajarra Jisu'n amadiang aleimasang, “Nangchu ngamna kalok numeisa na-eii! angme nimanuom kha nang sik ah inthorase.” Halli khawa phatak khan asanu kha adamjei. ");
INSERT INTO kfw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisu'n khawamun amathaanna Galilee tuidiil tiang aleisi halli chingtiang akalla alei in-ong. ");
INSERT INTO kfw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mipui katamtak amadiang inleihong, kekakiak, mitkacho, ka-inkhooi, chongkasuokmak halli akana mi lekkhat, Jisu kekuungnga inhongruoi; halli inmani ngai kha ama'n aleimindam. ");
INSERT INTO kfw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Khawa khan chongkasuokmak ngai'n chong inril, akeii inkhooi ngai'n indam, kasi theimak ngai'n insi khat-um mitkacho ngai'n inmu hi mipui'n inmu pha; Israel Pathian kha inminpaak. ");
INSERT INTO kfw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisu'n asiamruoi ngai akoolla akoiya aleiti, “Kei'n hiwa mipui ngaihi kaminriang, ajarchu inmani keile inruoiya nithum kinhong omjei tuunchu inmani bak sik inkhat-um neimujei. Kei'n inmani ngai hi bak-inleiya minsizoot mong, ajarchu inmani'n inntiang insipha phai-inwai inte.” ");
INSERT INTO kfw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Siamruoi ngaikhan ama diang inheiti, “Hunmo hiwa neelram hin hiwa mipui ngai sik kahun bu le an joleimin?” ");
INSERT INTO kfw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Waipool angjet nangni ningnei me?” Jisu'n aleirakel. “Waipool sari,” “le nga kasiin lekkhat,” kinnei tia inmani'n inleimasang. ");
INSERT INTO kfw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Khawa jarra Jisu'n mipui ngai neipilla in-ong nasik chong aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Khawasuoli ama'n waipool sari le nga aleiya, Pathian aleiminpaak, halli kather khoiya asiamruoi ngaidiang aleipeii; woikhat um asiamruoi ngai'n mipui ngaidiang inleisempi. ");
INSERT INTO kfw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Inraya ah inbak halli inleikhop. Khawasuo ah siamruoi ngai'n akaliam seng inkhoomma kokwar sari aleisip. ");
INSERT INTO kfw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Numeisa khat-um naipang teelleiya khawa kabak pasal seng lisingmili daam inlei eii. ");
INSERT INTO kfw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Khawasuo khanchu Jisu'n mipui ngaikha aleiminsi jei, halli rakuong suungkhan aluut ah Magadan ramtiang aleisijei. ");
INSERT INTO kfw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharisee khat-um Sadducee lekkhat in Jisu diang inhongnga ama surnasik ah marwaanna chuon inlak inkhat nathopi inlang naminmuro inhongti. ");
INSERT INTO kfw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Halli Jisu'n inmani diang aleimasang, “Kani joluut pha, ‘Khuo thasik eii, ajarchu marwaanna kool-eng asuok ningti.’ ");
INSERT INTO kfw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Halli ziingtiang makhan nangni'n ningti, ‘Wini chu ruo asursik eii, ajarchu marwaan asen khat um aziing,’ nangni'n nikhuo omchan ning en li angme kasuok sik ningril mator, takkha hiwa apha jarra akasuok chuon inlak ngaichu nangni'n angme suoksik tia rilmator makchu! ");
INSERT INTO kfw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Hituk kathamak li Pathian kajetmak winiya mi ngai'n chuon inlak kha inratok! Takkha Jonah diangnga chuon inlak kha eleiya chuon inlak inkhat nangni diang napenunijei.” Halli ama'n inmani ada ah asijei. ");
INSERT INTO kfw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Halli siamruoi ngai'n tuidiil kham inkhattiang inheirakaan pha, inmani'n waipool kha hongchoisik inleimanil jei. ");
INSERT INTO kfw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisu'n inmani diang ati, “In ensuiru; Pharisee ngaili Sadducee ngai cholla inphut khan.” ");
INSERT INTO kfw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Inmani inkhat li inkhat karra ininbiak ah inti, “Ama'n hiwa atina ajarchu eini waipool heichoi makmi.” ");
INSERT INTO kfw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisu'n angme inmani itikha aleijet, khawa jarra inmani diang aleirakel, E ngamna kasiin ngai “Nangni inkhat li inkha waipool ningnei makna jarra angsik ah ning inbiak me? ");
INSERT INTO kfw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tuun katung nangni lajet makchu be? Kei'n miring lising ranga waipool ranga ah kiwai halli akaliam kokwar angjetme ningminsip nangni ngaidon makchube? ");
INSERT INTO kfw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Halli miring lising mili sik ah waipool sari ah kawaili kokwar angjetme nangni'n ningruut minsip? ");
INSERT INTO kfw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kei'n nangni diang waipool jarra rilmong angsik ame khawa ning ijetmak? Pharisee li Sadducee ngai cholla inphut nangni'n in-ensuiru!” ");
INSERT INTO kfw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Khawasuo khanchu ama'n inmani diang in-ensuiru tia irilhi waipool khanna inneiman chol kha emak takkha Pharisee li Sadducee ngai minchuna ngai khanna inphut eii ti asiamruoi ngai'n inleijet. ");
INSERT INTO kfw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisu'n Caesarea Philippi ram koolla kaom khuopui khan aheiwa pha, ama'n asiamruoi ngaidiang aleirakel, “Miring Sapa hi mi ngai'n tu eii intime?” ");
INSERT INTO kfw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Inmani'n inleimasang, “Mi lekkhat in John Baptist na-eii inti,” “Lekkhat in Elijah na-eii inti, halli lekkhat ngai'n Jeremiah emakli Pathian chongkachoi ngai karra inkhat na-eii inti.” ");
INSERT INTO kfw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Halli Jisu'n inmani diang aleirakel, “Nangni inle Keihi tu ka-eii ningtime?” ");
INSERT INTO kfw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter in aleimasang, “Nangchu Messiah, akaring Pathian Sapa kha na-eii.” ");
INSERT INTO kfw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Bar-Jonah sapa Simon, narawaan atha!” tia Jisu'n aleimasang. “Ajarchu hiwa akatuun hi miring taksa ah inphut nangdiang akajuo emak, takkha marwaanna kaom Kapa diangnga inphut akajuo eii. ");
INSERT INTO kfw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tuun khawa jarra Kei'n nangdiang kati, nang Peter na-eii (tinachu ‘lung’), hiwa lungpui chunghin Kei'n kakoisuok kasaksik eii, halli khawakha meikhur luutna kot innum matornuni. ");
INSERT INTO kfw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kei'n nangdiang marwaan Rengram sou kha kanapesik eii; nang in nuoipil chungnga nikhit kha marwaan khannum inkhitsik eii, halli nuoipil chungnga nimasuo kha marwaan khannum insuosik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Khawa suoli Jisu'n asiamruoi ngaidiang ama hi Messiah eii ti tu inkhat diang um rilpimaru tia chong aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Khawapha makheiya Jisu'n asiamruoi ngaidiang, “Kei Jerusalemma kasisik eii halli uparup ngai, thiampu kalian ngai halli sina Dan ocha ngai diangnga inphut kalapoong sik eii. Halli kei innalathat sik eii, takkha nithumni kalahong ringsik eii.” tia inthiangnga karilpi aphut jei. ");
INSERT INTO kfw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter in ama kha kaangkhat tiang aruoiya aheiran. “Pumi, khawa kha Pathian in kalaak ah nadapi rase!” ama'n aleiti. “Khawa kha angtikniteii nachungnga kasuok emarase!” ");
INSERT INTO kfw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisu'n ahei-inlet ah Peter diang ati, “Kei diangnga inphut siro, Seitan! Nang hi kei diang insuina inkhat na-ejei, ajarchu hiwa ngaidonna ngai hi Pathian diangnga inphut akajuo emak takkha miring omchanna inphut eii.” ");
INSERT INTO kfw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Khawa phakhan Jisu'n asiamruoi ngaidiang aleiti, “Nangni karra tuka-ang inkhat in kanuk najuizoot inchu, ama apumtak ah inzootmak se-inlang, ama cross indom rase, halli kanuk najuirase. ");
INSERT INTO kfw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ajarchu naringkhuo sanringsik namanuom inchu, amangsik eii; halli keisik naringkhuo naminmang inchu, khawa kha nalamusik eii. ");
INSERT INTO kfw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nuoipil pumpui namatorli naringkhuo naminmang inchu angme nanemna sik? Emakli mi inkhat in angleme aringkhuo aminthuul sik? ");
INSERT INTO kfw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ajarchu Miring Sapa in Apa lurna lianna khan ama marwaan tirton ngaile inruoiya ajuosik eii, halli khawa phakhan ama'n mi rakip ama chuonleitho dungjuiya atum apesik eii. ");
INSERT INTO kfw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kei'n nangni diang inthiangnga kiril eii, hiwa hinna tuun kangirra kaom lekkhat chu Miring Sapa in Reng eya ijuo inmu makma thinunu.” ");
INSERT INTO kfw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Halli niruk suoa Jisu'n Peter le anaipa James halli John, ama'n aruoiya inmani bit omnasik ching insaang inkhat khan aleisipui. ");
INSERT INTO kfw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Inmani'n khan inhei enlai, Jisu inmani maikuungnga ameelsuo hong inthuul jei: ama meel kha kani angnga aleiwar, halli ama puondiar ngaikha war angnga aleichek. ");
INSERT INTO kfw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Halli siamruoi inthum ngai'n Moses khat-um Elijah Jisu le inruoiya thurchi inril inleimu. ");
INSERT INTO kfw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Khawa jarra Peter in Jisu diang ati, “Pumi, eini'n hinna ni-om hichu angtuk kahoi me! nang in nazoot inchu, kei'n riakbuk inthum sakkate, nang sik inkhat, Moses sik inkhat, halli Elijah sik inkhat.” ");
INSERT INTO kfw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ama'n aril laichei khan, enru, akawar sumphai'n inmani aleimakhu, halli sumphaiya inphut rasa inkhat in ajuoti, “Hiwa hi kiminriang tak kasapa kha eii, ama chungnga kamalung atai; nangni ama iti rangairu!” ");
INSERT INTO kfw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Siamruoi ngaikhan rasa kha injetpha, inmani inleichithei, halli neipilchungnga inmani inmeel inkuunna inlei inbok. ");
INSERT INTO kfw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisu'n inkoolla aheiwa ah akatook ah ati, “Intheiru, chimaru!” ");
INSERT INTO kfw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Halli inmani'n inhong enpha Jisu eleiya tu inkhat bit um khawakhan leimumujei. ");
INSERT INTO kfw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Inmani'n khan chingnga inphut injuo chumpha, Jisu'n inmani diang, “Miring Sapa in thiya inphut ahongring maklaiseng, tu inkhat diang um nangni'n ning imu ngaikha rilsuok maru tia inmani diang chong aleipeii.” ");
INSERT INTO kfw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Halli siamruoi ngai'n Jisu diang inleirakel, “Angsikme sina Dan ocha ngai'n Elijah ajuo masasik eii inti?” ");
INSERT INTO kfw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisu'n aleimasang, “Inthiangnga Elijah juomasata,” “halli angrakip hi alaminsuuk wiaksik eii. ");
INSERT INTO kfw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Takkha kei'n nangni diang kati khachu Elijah kha ajuosuojei takkha mi ngai'n ama leijetmu, takkha inmani'n inmanuom kha ama chungnga inleitho. Khawale in-angrip ah Miring Sapa kha um inmani'n inminpoong nooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Khawa phakhan ama'n John Baptist jarra iril eii ti asiamruoi ngai'n inleijet. ");
INSERT INTO kfw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Inmani'n mipui ngaidiang injuokir pha, miring inkhat Jisu diang aheiwa, halli amaikuungnga chubei ajuotho, ");
INSERT INTO kfw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","halli ati, “Ocha, kasapa hi naminriang piro! Ama hi rikeiri araweiya apoongthei jei ajarchu ama tuisuung meisuungnga aluut kachak jei. ");
INSERT INTO kfw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kei'n nasiamruoi ngaidiang kaleiruoi, takkha inmani'n namindampi matormu.” ");
INSERT INTO kfw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisu'n aleimasang, “E ngamna kasiin le mi kathamak ngai! Angtuk kasootme kei nangni le kalaom suomsik hi? Kei'n nangni le angtuk kasoot kanaladeipui sikme? Naipangpa kha hin kakoolla heiruoi ro!” ");
INSERT INTO kfw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisu'n ratha kathamak diang khan chong aleipeii, halli ratha kathamak kha naipangpa diangnga inphut aleisuok, khawa phachei khan naipangpa kha adamjei. ");
INSERT INTO kfw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Halli siamruoi ngai'n ruuk ah Jisu diang inheiwa ah inleirakel, “Angjarra keini'n ratha kathamak kha kinpuutsuok matormakme?” ");
INSERT INTO kfw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Ajarchu ning inngamna kha asiin thei,” tia Jisu'n aleimasang. “Kei'n nangni diang inthiangnga kati khachu anchamru tiatbit kalok inngamna ningnei inchu, nangni'n hiwa ching diang tiningte, ‘hiwa hinna inphut soson inthonro!’ halli khawa khan inthonsik eii. Halli nangni thomatormak sik iteii omnuni!” ");
INSERT INTO kfw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Siamruoi rakip in Galilee khan injuo inchunwiak phakhan, Jisu'n inmani diang aleiti, “Miring Sapa kha mi ngai kutchungnga inlapesuok sik eii ");
INSERT INTO kfw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","halli inmani'n ama kha inlathatsik eii; takkha nithum huuini ama ahongringsik eii.” Hiwa injetpha siamruoi ngaikha inleipoong theijei. ");
INSERT INTO kfw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisu le asiamruoi ngai'n Capernaum inheitung pha, nina inna sialkakhompa in Peter diang aheiwa ah aleiti, “Nangni ning ochapa'n Biak-inna pesik kasuok sial kha pemak abe?” ");
INSERT INTO kfw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Oh apeii,” tia Peter in aleimasang. Peter khan innsuung aluutpha, Jisu'n ma-insa khet ah aril, “Simon, angme nangleii ningaidon? Hiwa nuoipilchung reng ngaidiang tu ngai inme rampar inpejol? Aram mi-ngai inbe emakli ramleiilak mi ngai inbe?” ");
INSERT INTO kfw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Mi leiilak ngai'n,” tia Peter in aleimasang. “Kha e-inchu athajei,” tia Jisu'n aleiti, “kha tina chu ami ngai inchu penunu. ");
INSERT INTO kfw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Takkha eini'n hiwa mi ngaihi minpoong zootmakmi, khawa jarra siro tuidiil khan ngakhuoi jokeiro, halli ma-insakhet ah nisur ngabai khan sial lei omte, Kha lei inlang kei sik le nang sik inmani diang pero” ati. ");
INSERT INTO kfw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Khawa phakhan siamruoi ngai'n Jisu diang inheiwa ah injuorakel, “Tume marwaan Rengramma akalok khetsik?” ");
INSERT INTO kfw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Khawa jarra Jisu'n naipang inkhat akoiya halli inmani maikuungnga aleiminngir, ");
INSERT INTO kfw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Halli ama'n ati, “Kei'n inthiangnga karil khachu nangni'n ningmanuwa inphut ninghei inlet ah naipang ngaihi ninghong angmak inchu, nangni angtikniteii marwaan Rengram kha luut theinutun.” ");
INSERT INTO kfw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Khawa jarra hiwa naipanghi angnga atheinuo ah anunchan inchuol ama khan marwaan Rengramma kalokkhet sikkha eii. ");
INSERT INTO kfw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hi angnga kei karamingnga hiwa ka-ang naipang inkhat akeiluut inchu, kei um anakeiluut jei. ");
INSERT INTO kfw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tuka-ang inkhat in kei kanangamna hiwa naipang ngai inkhat ama inngamna aminmangpi inchu, ama riingnga akalok lungchakari inkhit ah tuipui inthuuk suungnga indeengluut khan ama sik ah kheella atha.” ");
INSERT INTO kfw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mi ngai inngamna kaminmang in-om jarra manmasituolhi angtuk poong kaom sik me! hiwa rakip ngaihi alahongsuok sik eii, takkha hiwarakip kamasuok ama kha angtuk poongkaom sik me! ");
INSERT INTO kfw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ajarchu nakut emakli nakeii in manuwa namachulsik e-inchu, tan inlang hiaijuonro! nakut inni le nakeii inni inchella hektik kaboi meisuungnga in nadeengluut siknek achu kutkhat kekhat inchelleiya ringna kamukhan athadoom.” ");
INSERT INTO kfw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Halli namit in nang kha manuwa namachul sik e-inchu, kelsuok inlang hiaijuonro! namit innile inruoiya hektik kaboi meikhurra kaluut sik nek achu mit khat kaboiya ringnamun kaluut in kheella nangsik ah atha. ");
INSERT INTO kfw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Enru, nangni'n hiwa naipang ngai chungnga enseel-musit thomaru. Ajarchu kei'n nangnidiang kati, inmani marwaan tirton ngai'n marwaanna kaom kapa maikuungnga in-omchak.” ");
INSERT INTO kfw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ajarchu akamang ngai kasan sik ah miring Sapa ajuojei. ");
INSERT INTO kfw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nangni'n angme ning ngaidon? miring inkhat in keelngam rajakhat aneili khawa ngai karra inkhat amang inchu, ama'n soomkuo leikuo ngaikha chingnga data halli akamang kha karatok asisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kei'n nangni diang inthiangnga kati, khachu ama'n keelngam kha amupha, inmangmak soomkuo leikuo ngai neek ah kheella arokpui. ");
INSERT INTO kfw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hile in-angrip ah marwaanna kaom Kapa in hiwa naipang ngai karra inkhat kha um minmang zootmak. ");
INSERT INTO kfw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nachungnga na-u nanai inkhat in manu atho inchu, akoolla si inlang halli ama masialna kha amadiang ruuk ah jominmuro. Ama'n nang iril kha arangai inchu, nang in na-u nanai kha woikhat naboolthar jei. ");
INSERT INTO kfw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Takkha ama'n nachong kha arangai mak inchu, miring inkhat emakli inni ruoiro, ajarchu Pathian chong inthiang in iril angnga, Chongkasuok rakip sakhi inni emakli inthum baisuo ah chong intansik eii ati. ");
INSERT INTO kfw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Khawa katung ama'n inmani kha arangai mak inchu, koisuok ngaidiang mindikro. Ahekna ah koisuok ngai itikha arangai mak inchu, ama kha Pathian kajetmak emakli rampar kakhoompa kha eii tia leitaro.” ");
INSERT INTO kfw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Inthiangnga nangnidiang kei'n karil: nangni'n nuoipil chungnga ningkhit kha marwaanna inkhitsik eii, halli nangni'n nuoipil chungnga ningmasuo kha marwaanna inmasuosik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Woikhat um, kei'n nangnidiang karil: Nuoipilchungnga nangni inni'n angmekhat jarra ning inzootna inchu, marwaanna kaom Kapa in khawakha nangni sik ah inthiangnga anathopisik eii. ");
INSERT INTO kfw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ajarchu kei karamingnga inni emakli inthum ning inchunna munkhan, kei inmani le khawakhan kaom.” ");
INSERT INTO kfw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Khawa phakhan Peter in Jisu diang aheiwa ah aleirakel, “Pumi, ka-u kanai inkhat in kei chungnga manu athopha, woi angjetme kei'n ama kangaidam sik? woisari katung bitbe?” ");
INSERT INTO kfw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisu'n aleimasang, “Emak, woisari bit emak,” “takkha woisomsari hi sari chak, kei'n nangdiang kitikeeng, ");
INSERT INTO kfw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ajarchu marwaan Rengram chu, Reng inkhat in asuok ngai sial-sum ensuisik ingaidon khale in-ang. ");
INSERT INTO kfw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ama'n ka-ensui aphut pha, talent lisingsoom ka-intuol miring inkhat kha akoolla aheiruoi. ");
INSERT INTO kfw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Suokpa in asialpuuk thuulnasik kahun sial leineimak, Khawa jarra Rengpa in amadiang anumei, asa halli inei rakipkha intuol thuulnasik ah juojuorro tia chong aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Khawa jarra suokpa khan Rengpa maikuungnga kemurkhup thep ah, kei nangaak diro, kei'n ki-intuol rakip nathuul kate ama'n ati! ");
INSERT INTO kfw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Rengpa khan ama kha ahong minriangjei, halli intuol rakipkha arangaidam piya halli ama kha aleiminsijei.” ");
INSERT INTO kfw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Halli suokpa khan ahongsuok pha, asuok changpui inkhat ama sial talent lekkhat intuol alei-intongpui. Halli ama'n asurra ariing ma-ouwa, ‘ni-intuol kha nathuulro!’ ama'n aleiti. ");
INSERT INTO kfw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ama asuok changpuipa in inbok ah amadiang aleiti, ‘Kei nangaak diro, kei'n nathuul kate!’ ");
INSERT INTO kfw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Takkha ama'n leizootmak; khawa rathuulla, ama'n intuol athuulsuo maklaiseng mikhumna khan aleida. ");
INSERT INTO kfw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Asuok changpui lekkhat in angme akasuok ngaikha inmupha, inmani inmalung leihoi pimak jei halli inkirra inrengpa diang angme kasuok rakip injuomindik jei. ");
INSERT INTO kfw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Khawa jarra amapupa in suokpa kha akoiluut ah, ati. ‘Suok kathamak nang!’ Nang in kei diang nanani jarra, ‘nasialpuuk rakip kei'n kana ngaidampi jei.’ ");
INSERT INTO kfw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kei'n nang kinaminriang angnga, nang innum nasuok changpuipa diang naminriang sik suokmakbe? ");
INSERT INTO kfw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Rengpa kha araang theiya, asuokpa kha asialpuuk rakip athuulsuo maklaiseng mikhumna khan aleitirjei.” ");
INSERT INTO kfw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ahekna ah Jisu'n ati, “Nangni rakip in ning-u ningnai ngaikha ningmalungnga ning ngaidam mak inchu, marwaanna kaom kei Kapa innum kha angnga ningchungnga athosik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisu'n hiwa rakip ngaihi arilsuo pha, Galilee mathaanna halli Jordan tuidung raalkhat tiangnga kaom Judea ramtiang aleisi. ");
INSERT INTO kfw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mipui katamtak in ama inheijui, halli khawakhan inmani aleimindam. ");
INSERT INTO kfw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pharisee lekkhat in chong rakelli ama surnasik akoolla inheiwa, “Angmekhat jarra miring inkhat in anumei kha ama lungdouwa inthenpuisik hi eini sina Dan in azootbe?” ");
INSERT INTO kfw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisu'n aleimasang, “Inphutna makheiya Kanaboolpa in pasal khat-um numeisa abool tihi nangni'n Pathian chong inthiang khan lateel makchube? ");
INSERT INTO kfw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pathian in ati, ‘Hiwajarra pasal inkhat in anu li apa mathaanta halli anumeile inchunsik eii, halli inmani innikha pumkhat inhong esik eii,’ ");
INSERT INTO kfw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Khawa jarra inmani inni ekhaimujei, takkha inkhat bitkha in ejei. Pathian in iminchun jeikha, mi inkhat in khoithen marase.” ");
INSERT INTO kfw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pharisee ngai'n amadiang inleirakel, “Angtiyame, hanle, Moses in inthenpuina chongmajia kha pasalpa in anumei diang pe-inlang inthenpuiro tia chongpeii ileipe?” ");
INSERT INTO kfw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisu'n inmani diang aleiti, “Nangni ningmalung ningminngar jarra Moses in nangnidiang ningnumei ngai inthenpui acha tia inazootpi kha eii, Takkha inphutna achu kha lei-emak. ");
INSERT INTO kfw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kei'n nangnidiang kati, tuka-ang inkhat in anumei kha zool-inthai jarra eleiya inthenpuiya, halli numeisa khat aneirit inchu amakha zool-inthai athojei.” ");
INSERT INTO kfw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Asiamruoi ngai'n amadiang inleiti, “Hiwa omchanhi aruothar li anumei karra asuok inchu, inn kaneimak khan athadoom.” ");
INSERT INTO kfw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisu'n aleimasang, “Hiwa minchuna hi mirakip sik emak, takkha Pathian in ipe inmani ngaisik bit eii. ");
INSERT INTO kfw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ajarchu Mi ngai'n inn inneimakna jarra inteina om, lekkhat in anu wonsungnga atak inboolsa ah innei; lekkhat in miring ngai'n atak inbool; halli lekkhat in Marwaan Rengramsik ah inn kaneimak inom. Tuka-ang hiwa minchuna kazoot ngai'n hiwahi juirasu.” ");
INSERT INTO kfw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mi lekkhat in naipang ngai chungnga akut aduongnga anipi nasik Jisu diang inhongruoi, takkha siamruoi ngai'n inmani kha inleiran. ");
INSERT INTO kfw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Halli Jisu'n ati, “Naipang ngaikha kakoolla hongrasu nangni'n khapmaru, ajarchu marwaan Rengram hi hiwa ka-ang ngaita eii.” ");
INSERT INTO kfw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ama'n inmani chungnga akut aduongpi halli khawa munna inphut asijei. ");
INSERT INTO kfw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Enru, mi inkhat in Jisu diang ahongnga ati, “Ocha,” “Kei'n hektik kaneimak ringna kamunasik angkachang chuon katha khame kathosik?” ");
INSERT INTO kfw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisu'n aleimasang, “Angsikme nang in akatha chuon jarra ninarakel?” “Akatha mi inkhat bit aom, khachu hektik kaneimak ringna kha naluutzoot inchu chongpeii ngaikha juiro.” ");
INSERT INTO kfw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jisu diang ama'n aleirakel, “Ang chongpeii ngai khame?” Jisu'n aleimasang, “Mi thatmaro; zool-inthaimaro; inruup thomaro; kadikmak sakhi pemaro; ");
INSERT INTO kfw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nanu li napa kaya ro; halli ni-indiang ni-inwaipui ngaikha nang in napumtak ni-inriang angnga minriang ro.” ");
INSERT INTO kfw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Kei'n hiwa chongpeii rakip ngaihi kajuijei,” “Angme kei'n katho delsik?” tia ruotharpa in aleimasang. ");
INSERT INTO kfw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisu'n amadiang aleiti, “Nang in puikatung na-ezoot inchu, si inlang nineirakip jojuorro halli sial kha sara ngaidiang juopero, halli marwaanna karei naneisik eii; hallikhan heiwaro, kei najuiro.” ");
INSERT INTO kfw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ruotharpa in hiwa itihi ajetpha, ama'n malung poongtheiya asijei, ajarchu ama inchongthei alei eii. ");
INSERT INTO kfw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Khawa suoli Jisu'n asiamruoi ngaidiang ati, “Kei'n inthiangnga kiril eii: inchong mi in marwaan Rengram kaluutsik hi intak. ");
INSERT INTO kfw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Woikhat kei'n nangnidiang kati: mi inchong inkhat in Pathian Rengram kaluutsik neek achu salaileem inkhat in simphuoi kuorra iluut in abeidet.” ");
INSERT INTO kfw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Siamruoi ngai'n hiwa injetpha, inmani'n inthiangnga inleingak. halli, “Tume, ringna akamusik?” tia inmani'n inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisu'n inmani diang enna aleimasang, “Hiwa hi miring ngaisik achu thomator emak, takkha Pathian inchu hiwarakip hi amator.” ");
INSERT INTO kfw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Khawa phakhan Peter in aleimasang. “Enro,” “Keini'n hiwarakip kinda ah nanuk kinnajui. Keinisik ang omme?” ");
INSERT INTO kfw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisu'n inmani diang ati, “Kei'n nangnidiang inthiangnga kiti eii khachu Miring Sapa in ama apoinale inruoiya Manmasituol Kathar khan ama reng in-ongna khan in-ong pha, nangni anakajui soomleini ngai um reng in-ongna khan ningla in-ong sik eii, halli Israel zaat soomleini ngaikha chong katansik ni-eii.” ");
INSERT INTO kfw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kei sik jarra, a-inn alei, a-u anai, anu apa emakli asa ngai kada mi rakip in tum rajakhat kheella amusik eii halli hektik kaboi ringkhuo kha inmusik eii. ");
INSERT INTO kfw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Takkha makasa katamkhat in nuk inlatongsik eii, halli nukkatong ngai khan ma-inlasasik eii. ");
INSERT INTO kfw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Marwaan Rengram hi, miring inkhat in ziingtiang ma-ah intheiya ama theibombilla chuonkathosik loom lekkhat karatok kasi khale in-ang.” ");
INSERT INTO kfw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ama'n nisuokhat chuontho manhi, dangkapum inkhat ah inzootpuiya, halli inmani ngaikha ama theibombilla chuonkathosik aleitir. ");
INSERT INTO kfw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Halli ama'n phurjuorna munna asinook ah, i-kathomak kangirra kaom mi lekkhat kha phadan kuo khan aleimu, ");
INSERT INTO kfw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","halli ama'n inmanidiang ati, Kei'n pesik kasuok nisuokhat chuonthoman kha napekate, nangni um si inlang theibombilla chuon juothoru. ");
INSERT INTO kfw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Halli inmani insijei. Ama'n inlet ah asuoknook ah phadan soomleini khat-um phadan inthum chulphakhan khawale in-angrip ah aleitho. ");
INSERT INTO kfw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kholei phadan ranga juochul pha ama'n phurjuorna munna asi ah, halli miring lekkhat kangirra kaom ajuo munook, halli inmanidiang ati, Nangni'n suunsoot iteii tholeiya ningngirra ning-omhi angsik ame? ");
INSERT INTO kfw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Inmani'n inleimasang, tu inkhat innum loom naruoimu. Thajei, kha e-inchu, nangni si inlang theibombilla chuon juothoru, inmanidiang ama'n aleiti. ");
INSERT INTO kfw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kholei aheitung pha, theibombil mapupa in ama chuon ka-ensui ngaidiang ati, ‘Chuon katho ngaikha koi inlang halli inchuon thoman kha nuk intong khet ah inruoi makheiya phut inlang ma-insa khet ah inruoi katung kha joperu.’ ");
INSERT INTO kfw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Phadan ranga pheiweiya chuonkaphut ngai rakip diang dangkapum inkhat inkhat inleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Khawa jarra loom ma-insa ngai'n inheiwapha, inmani'n katamdet mukinte tia inlei ngaidon; takkha inmani rakip um dangkapum inkhat inkhat inleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Inmani'n insial kha inleiya halli leimapupa chungnga num kati inleiphut. ");
INSERT INTO kfw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nuk intongnga loom niruoi ngai'n phadan inkhatbit chuon intho,’ inmani'n inti, ‘Keini'n suunsoot kanisa kindeiya chuon kintho, takkha keini diangnga ninapele in-angrip ah inmani diang um napeii!’ ");
INSERT INTO kfw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Khawa khan ama'n inmani diang aleimasang, ‘Rangairu, kasap ngai,’ tia leimapupa in inmani karra inkhatpa diang ati, ‘Kei'n nangnidiang maleisei thomong, nangnile suunkhat ah chuonthoman dangkapum inkhat ah ni-inzoot suo emak abe? ");
INSERT INTO kfw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tuun naleisik kha lei inlang na-inna siro. Nang diangnga kinape angnga nuk intong khet ah kiruoipa diang um kei'n kapezoot. ");
INSERT INTO kfw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kei kasial kha kalungdouwa thonasik ranak neimongnga be? Emakli kei kamalung inthiang hi ninara-ot be?’ ” ");
INSERT INTO kfw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ahekna ah Jisu'n ati, “Khawa jarra tuka-ang nuk intong ngaikhan ma-insasik eii, halli tuka-ang ma-insa ngaikhan nuk intongsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisu'n Jerusalem tiang asilai, siamruoi soomleini ngai lamleii inkhattiang aleiruoi halli inmani'n khan insipha, ruuk ah inmani diang aleiril. ");
INSERT INTO kfw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Rangairu,” “Eini'n Jerusalem tiang nikalla nisi, khawamun khan Miring Sapa kha thiampu kalian ngai khat-um Dan ocha ngai kutchungnga inlapesik eii. Halli inmani'n amakha thatnasik ah akatuunmak eii tia inrilsesik eii, tia inmanidiang aleirilpi ");
INSERT INTO kfw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","halli khawa suo ah Zaatlop ngaidiang, ama innuipui nasik, wuoknasik halli Cross ah makaiya thatnasik inlapesik eii; takkha nithum nikhan ama alahongring nooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Khawasuoli Zebedee numei khan asangai innile inruoiya Jisu diang inhongnga, ama maikuungnga chubei inthoa, imanuom inkhat nathopiro tia amadiang aleini. ");
INSERT INTO kfw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Angme nimanuom?” Jisu'n amadiang aheirakel. Ama'n aheimasang, “Keidiang chong inkhitro, khawa khachu hiwa kasa inni ngaihi nang in Reng na-epha inkhat in nachangtiang halli inkhat in naweitiang in-ongrasu.” ");
INSERT INTO kfw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisu'n hin tia aleimasang, “Nangni'n ningni kha angme ti jetmakchu,” “Kei'n ka-insik poongna rabing hi nangni'n inmator tunnabe?” “Keini kinmator,” tia inmani'n inleimasang. ");
INSERT INTO kfw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Nangni'n inthiangnga kei karabing kha in ningte,” tia Jisu'n inmani diang ati, “Takkha keichu tume kei kachang kawei tiangnga in-ongsik kadang nasik ranak neimong. Takkha kapa in inmanisik eii tia iboolpingai sik kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Siamruoi soom ngai'n hiwa jar injet pha, unai inni ngai chungnga inmani inleiraang. ");
INSERT INTO kfw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Khawa jarra Jisu'n inmani raja ah akoichunna ati, “Pathian kajetmak zaatlop lamkakei ngai'n inmani chungnga wairoonna ranak innei, halli inmani lamkakei ngai'n puikatungnga thomatorna innei ti nangni'n ningjet. ");
INSERT INTO kfw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nangni karra chu khawakha emak. Tuka-ang inkhat in akalok ezoot inchu, ama'n nangni rakip suok kha e-sik eii; ");
INSERT INTO kfw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","halli nangni karra inkhat in ma-insa ezoot inchu, amakha nangni rakip ngai suok kha e-sik eii, ");
INSERT INTO kfw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","hile in-angrip ah Miring Sapa kha sepa inthosik ah akajuo kha emak, takkha sepa kathosik halli mi rakip ngai kasanring sik ah aringkhuo kape ijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisu li asiamruoi ngai'n Jericho inheimathaan pha, mipui katam tak in Jisu nuk inhongjui. ");
INSERT INTO kfw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lam sirra in-ong mitkacho miring inni'n Jisu aheiwa ti injet pha, inringnga inhongkheek, “David Sapa! Pumi, Keini naminriangro!” ");
INSERT INTO kfw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mipui in omchianru tia inmanikha inleiran. Takkha inmani'n kheella inringnga inhongkheek, “David Sapa! Pumi, Keini naminriangro!” ");
INSERT INTO kfw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisu'n angirra inmanikha aleikoi. “Angme kei nangnisik ningnamintho zoot?” tia ama'n inmani diang aleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Inmani'n inti “Pumi,” “Keini kinmit kinmuzoot!” ");
INSERT INTO kfw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisu'n inmani aleiminriangnga inmit ngai kha aleikatook pi; khawa phatak khan inmani inmujei halli inmani'n ama kha injuijei. ");
INSERT INTO kfw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisu khat-um asiamruoi ngai'n Jerusalem inheinaiya Olives Chingnga kaom Bethphage kha inheitung, halli Jisu'n asiamruoi inni ngaikha inmatiang aleitirjei. ");
INSERT INTO kfw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Ningma tiangnga kaom khuokhan siru, halli nangni'n salungdai apui koolla inkhit ateii inkhat jomuningte. Inmani kha suut inlang keidiang hongruoiru. ");
INSERT INTO kfw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Halli tuka-ang inkhat in anarakel inchu, ‘Pumi khan inmani hi inliingnasik aom’; ama diang tipiru, halli ama'n inmani kha khawapha takkhan aheimasuosik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hiwa kasuok rakip hi Pathian chongkachoipa ileiril kha huui ahongtung nasik eii: ");
INSERT INTO kfw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion sanu ngaidiang rilpiru, Enru, nangni rengpa kha nangnidiang ajuo jei! Amachu anunchan inchuol halli salungdai achuong halli salungdai khachu ateii eii.” ");
INSERT INTO kfw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Khawa jarra siamruoi ngai'n insi ah Jisu'n angme inmani diang thoru itikha injuothojei: ");
INSERT INTO kfw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","inmani'n salungdai apui li ateii inhongruoi, inchungnga inpuon indaaplikhan Jisu inleimin-ong. ");
INSERT INTO kfw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mipui katam khat in inpuondiar lamchungnga intha, lekkhat in thingbuo intukthaak ah lamchungnga inleitha. ");
INSERT INTO kfw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Halli Jisu matiangnga kasili anuk tiangnga kasi mipui ngai'n inhongkheek, “Hosanna David Sapa! Pumi ramingnga akajuo amakha arawaan atha! insaang khet ah Hosanna.” ");
INSERT INTO kfw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisu'n Jerusalem aluut phakhan, khuopui pumpui kha rasa in aleisip. “Ama hi tume?” tia mipui'n inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Ama hi Galileeya kaom Nazareth ah inphut Pathian chongkachoi Jisu kha eii,” tia mipui ngai'n inleimasang. ");
INSERT INTO kfw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisu'n Biak-inn aluutli khanna karacho li kajuor mi rakip ngaikha aleipuutsuok. Ama'n sialchuoi kamakoi ngai khamtuol halli pharbali kajuor ngai in-ongna lukham ngaikha aleimalet aleimakhup pijei, ");
INSERT INTO kfw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","halli inmani diang ati, “Kei ka-inn hi Pathian nina inn intia inkoisik eii.” Takkha nangni'n inruup katho ngai omna ningmin ejei! ");
INSERT INTO kfw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Khawa suoli mitkacho li kekakiak ngai'n Biak-inna ama koolla inleihong, halli ama'n aleimindam. ");
INSERT INTO kfw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Thiampu kalian li Dan ocha ngai'n Jisu itho chuon inlak ngai halli naipang ngai'n Biak-inna “Hosanna David Sapa!” intia inkheek kha inmupha inraangnga Jisu diang inheiti, ");
INSERT INTO kfw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Angme inmani'n inti nang najetbo?” “Inthiangnga kei'n kajet,” tia Jisu'n aleimasang. “Hiwa chong inthiang hi nangni'n lateel ngaimak chube? ‘Nangni'n akadoong naipang khat-um ranu laka-in ngai murra Pathian inminpaaksik eii tia ningminchu kha.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisu'n inmani amathaanna halli Bethany khuopui tiang asiya, khawa munkhan zaankhat ajuoriakjei. ");
INSERT INTO kfw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ziingkhuo ahongwar pha, khuopuitiang aheikirna lamma, ama awon aleichaampi. ");
INSERT INTO kfw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ama'n lamkoolla kamoong theichang kuungkhat aleimu halli aleisi, takkha abuo elekleiya akara khat-um khawakhan leimumak. Khawa jarra ama'n theichang kuung diang khan ati, “Nang angtikniteii inra khaimaro!” Khawapha takkhan theichang kuungkha ajuochar jei. ");
INSERT INTO kfw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hiwahi asiamruoi ngai'n inleimu halli inleingak. “Angtho thoa hituk innoot ah theichang kuung hi icharme?” tia inmani'n inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisu'n inmani diang aleimasang, “Kei'n nangnidiang inthiangnga kanati, khachu nangni'n inngamna ningneiya halli ning inngamsammak jei inchu, kei'n theichang kuungnga kitho angnga nangni innum kheella thomator ningte. Hiwa bit eleiya, nangni'n hiwa ching diang um, ‘Inphuk inlang natheinuo ah tuipui son juota-taro nati innum,’ khawakha inthosik eii. ");
INSERT INTO kfw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nangni'n ning inngamna inchu, Pathian diang angme ningnikha ningmusik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisu'n Biak-inn tiang ahongkirra; halli ama'n aleiminchu, thiampu kalian khat-um uparup ngai'n amadiang inhongnga inhongti, “Hiwa ngaihi ang thomatorna naneiya nithome? Tu-in hika-ang thomatorna anapeme?” ");
INSERT INTO kfw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisu'n aleimasang, “Kei'n chongkhat narakel kate, halli nangni'n ningna masang inchu, Kei innum hiwa rakip ngaihi ang thomatorna kaneiya kithome ti narilpi kate. ");
INSERT INTO kfw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John in baptize ileitho kha hu makheiyame: Pathian makheiyabe emakli miring makheiyabe?” Inmani inkhat li inkhat inlei inbiak, “Angme eini'n nitisik? ‘Marwaanna inphut eii,’ niti inchu, ama'n einidiang atisik eii, ‘Angsik ah me hanle nangni'n ama ningngamnamak?’ ");
INSERT INTO kfw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Halli ‘Miringnga inphut eii niti inchu,’ eini'n mipui ngaikha nichi, ajarchu inmani rakip in John hi Pathian chongkachoi inkhat eii tia inleilei.” ");
INSERT INTO kfw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Khawa jarra inmani'n Jisu diang inleimasang, “Keini'n jetmungjei.” Halli ama'n inmani diang ati, “Kha e-inchu, Kei innum nangni diang, angranak kaneiya hiwa ngaihi kithome ti narilpi nuning.” ");
INSERT INTO kfw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Tuun, nangni'n angme ningngaidon? Mi inkhat in sapa inni aleinei. Ama'n asapa upa padiang asiya ati, ‘Sapa, awini theibombilla si inlang chuon juothoro.’ ");
INSERT INTO kfw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Halli ama'n aleimasang, kei sinuning, takkha ama'n amalung thuulla aleisi. ");
INSERT INTO kfw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Khawa suoli apa in asapa naipangpa diang asiya khale in-angrip ah aleiti, ama'n aleimasang, Oh pa, takkha ama leisimak. ");
INSERT INTO kfw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hiwa inni ngai karra tu-inme apa lungdou leikatho?” “Upapa eii,” tia inmani'n inleimasang. Jisu'n inmani diang aleimasang, “Kei'n nangni diang inthiangnga kiti hi eii: rampar kakhoom ngaili zool-inthai ngai'n Pathian Rengram tiang ningma insa ah insisik eii. ");
INSERT INTO kfw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","John Baptist in akatuun lamkha kanaminmusik aheiwa, halli nangni'n ama kha ngamna makchu; takkha rampar kakhoom ngai li zool-inthai ngai'n amakha inleingamna, Hiwahi nangni'n ningmu innum, ningmalung thuul inlang ama ngamna makchu. ");
INSERT INTO kfw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Hiwa chongminkhi inkhat hi rangaingru,” Jisu'n ati. “Leimapupa inkhat in theibombil inkhat athoa aleiling, halli aleirakulla, theibomtui sumnasik khur inkhat aleichei, hiwa ngaaknasik ah berteii khat aleisak. Khawa suoli chuonkatho ngaidiang aminhuumma ramkalaak inkhattiang aleisijei. ");
INSERT INTO kfw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Theibom kara rakhoolpha ahongtung phakhan, ama changsik tum kha kaleisik asuok ngaikha chuonkatho ngaidiang aleitir. ");
INSERT INTO kfw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Chuonkatho ngaikhan asuok ngaikha insurra, inkhat kha inleiwuok, inkhat kha inleithat halli inkhat kha lungnga inleideeng. ");
INSERT INTO kfw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Woikhat inlet ah asuok katamdet aleitir, takkha chuonmi ngaikhan matiangnga intho khale in-angrip ah inmani diang inleithonook. ");
INSERT INTO kfw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ahekna khet-ah, inmani'n kasapa chu khoya nathopi inte, tia asapa kha inmani diang aleitirjei. ");
INSERT INTO kfw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Takkha chuonmi ngaikhan asapa inmu pha, inmani inkhatli inkhat-in inlei inti, Hiwahi leimapupa sapa kha eii, heiwaru, eini'n ama thatrui, halli ama changsik kasuok kha eini'n leirui! ");
INSERT INTO kfw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Halli inmani'n amakha inthat-ah, theibombil raalkhattiang, inlei kalekjuonjei.” ");
INSERT INTO kfw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Khawa jarra, “Theibombil mapupa in aheikirpha, khawa chuonkatho ngaidiang ama'n angme athosik?” tia Jisu'n aleirakel. ");
INSERT INTO kfw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Inmani'n inleimasang, “Ama'n mi kathamak ngaikha suoileiya athatsik eii.” “halli aphakacha ah amadiang atum theibomkara kapesik aleiilak chuonmi ngaidiang khan ama'n arahuon kha aminhuumsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisu'n inmani diang ati, “Chong inthiang in angme itikha nangni'n lateel ngai makchube? ‘Inn kasak ngai'n inhiai lungkha akil kasur lungkha ahong-inchang. Hiwahi Pumi itho eii; eini mit-en nachu inlakchuon eii!’ ” ");
INSERT INTO kfw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Khawa jarra kei'n nangni diang kati,” “Pathian Rengram hi nangni diangnga inphut inlakeisuosik eii halli khawa kara kaminra mi ngaidiang inpesik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Hiwa lungchungnga kajuota tuka-ang ngaikhan alek-alek ah inkoisik eii, halli hiwa lung-in ijuodel tuka-ang mikhan rahut angnga innooisik eii. ");
INSERT INTO kfw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Thiampu kalian ngaili Pharisee ngai'n Jisu chongminkhi kha injetpha, inmani jarra iril eii ti inleijet. ");
INSERT INTO kfw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Khawa jarra inmani'n ama surnasik inleitho. Takkha mipui ngaikha inleichi, ajarchu mipui ngai'n Jisu hi Pathian chongkachoi inkhat eii tia inleilei. ");
INSERT INTO kfw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Hiwasuo Jisu'n woikhat inlet ah chongminkhina kha aneimanna mi ngaidiang aleiril. ");
INSERT INTO kfw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Marwaan Rengramchu, tuka-ang reng inkhat in asapa moiruoina ah bubaknasik insuuk khale in-ang. ");
INSERT INTO kfw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Bukabak hongnasik ah koina cheii ipe ngaikha jokoiru tia ama suok ngai aleitir, takkha inmani leihong zootmu. ");
INSERT INTO kfw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Khawa jarra woikhat asuok lekkhat ngaidiang hiwa chonghi apeya koina cheii inpe ngaidiang khan: Enru, Kei'n bubaknasik kha tuun kaminsuuk suojei; kei kasaraat ngai halli akanool kasechal ngai kathat ah chuon rakip ngaihi kaminsuuk suojei. Moiruoi bubakna hin hongtaru! tia aleitir ");
INSERT INTO kfw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Takkha koina cheii kamu ngai'n sisik leingaidonmu halli inmani'n inchuon-inchuon tiangkhan: inkhat in aleiya, lekkhat in insiallou natiang inleisi, ");
INSERT INTO kfw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","khawa khanna kaom aleiilak ngai'n asuok ngaikha insurra, inleiwuok, halli inleithat. ");
INSERT INTO kfw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Rengpa kha araang theiya; raalmi ngai atirra mikathat ngaikha aminthat jei halli inkhuopui kha um mei aminhaaljei. ");
INSERT INTO kfw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Khawa phakhan ama'n asuok ngai akoiya inmani diang ati, Kei moiruoi bubakna sik hi kaminhekjei, takkha kikoi ngaihi kahong sik rahoi suok mujei. ");
INSERT INTO kfw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Khawa jarra tuun nangni'n lampui ngaikhan si-inlang ning imu miring rakip ngaikha moiruoi bubakna sik ah juokoi ru. ");
INSERT INTO kfw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Khawa jarra suok ngaikhan lamma insuok ah, katha khat-um kathamak rakip ngaikha inhong minchun; halli moiruoina munkha mipui akahong ngaikhan insipjei.” ");
INSERT INTO kfw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Rengpa khan ahong inchun ngai ka-en aheiluut pha, moiruoi puondiar kathomak miring inkhat aleimu. ");
INSERT INTO kfw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rengpa in amadiang ati, ‘Suopui, angtho-thoa moiruoi puondiar tholeiya hiwahin nihongluut me?’ takkha ama'n iteii um leirilmakjei. ");
INSERT INTO kfw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Halli rengpa in suok ngaidiang aleiti, ‘Akeii akut khit inlang aziingna tuolkhan amakha kalekjuonru. Khawa munkhan ama'n aha karial ta achapsik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ajarchu “Katamtak inkoi, takkha lekteiibit inkadang.” ");
INSERT INTO kfw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Khawa phakhan Pharisee ngai'n insuok ah Jisu chongrilla inphut surnasik chuon inleiminsuuk. ");
INSERT INTO kfw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Halli Herod mi ngaile inmani siamruoi ngai intirra injuo minti, “Ocha,” “Nang in akatuun naril, mi ngaidiang Pathian jarra akatuun lamkha naminchu, halli tu-inkhat um chimakche, ajarchu mimeel mimai enna chuonkatho emakche tihi keini'n kinjet. ");
INSERT INTO kfw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Khawa jarra keini diang narilpiro, angme ningaidon? Rome Rengpa Caesar diang rampar kapehi eini sina Dan akoibe emakli koimakbe?” ");
INSERT INTO kfw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisu'n inmani thamakna kha ajet ah aheiti, “Akatha omchan katho ngai! Angsik ame kei nasursik ningtho? ");
INSERT INTO kfw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Rampar pesik sialkha keidiang naminmuru!” Halli inmani'n amadiang dangkapum kha inheichoi, ");
INSERT INTO kfw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Halli ama'n inmani diang aleirakel, “Tu ramil li ramingme hiwa ngaihi?” ");
INSERT INTO kfw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Inmani'n inleimasang, “Reng Caesar ta eii.” Khawa phakhan Jisu'n inmani diang ati, “Athajei, kha e-inchu Reng Caesar ta kha Caesar diang peru, halli Pathian ta kha Pathian diang peru.” ");
INSERT INTO kfw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Khawa injet pha inmani'n inleingak; halli amakha inmathaanna insijei. ");
INSERT INTO kfw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ahongkaringnook tihi ommak kati Sadducee lekkhat khawani khan Jisu diang inhongnga inhongrakel. ");
INSERT INTO kfw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Inmani'n inti, “Ocha,” “Moses in, mi inkhat in saneileiya athi inchu, ama unai inkhat in chulmeinu kha neita sa aneisik eii, khawa sangai kha akathipa sangai eii tia inleisik eii aleiti. ");
INSERT INTO kfw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Keini karra unai sari kinleiom; upakhetpa khan numei aleinei halli saneileiya athijei, anumei kha anai ngaidiang aleidajei. ");
INSERT INTO kfw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Khale in-angrip ah inni huuina, inthum huuina, insuona khet ah sari huuina anaipa diang um aleisuokjei. ");
INSERT INTO kfw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ajuohekna khetkhan numeisanu kha um athijei. ");
INSERT INTO kfw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Khawa jarra tuunchu hongring nookna nikhuo nikhan, amahi tu numei esikme? ajarchu inmani rakip in amakha inleinei.” ");
INSERT INTO kfw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisu'n inmani diang aleimasang, Chong inthiang emakli Pathian ranak kha nangni'n jetmakchu jarra, “nangni lamleii tiang ningsijei! ");
INSERT INTO kfw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ajarchu kathi ngaikhan inhongring pha, inmani khachu marwaan tirton ngai ang-inta marwaanna in-omsik eii, inmanidiang inkanei moikaruoi ti omnuni. ");
INSERT INTO kfw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kathi ngai'n inhongringnook sik jarra: Pathian in nangni diangnga itikha lateel ngaimak chube? ati, ");
INSERT INTO kfw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kei Abraham Pathian, Isaac Pathian khat-um Jacob Pathian ka-eii,’ Amachu kathi ngai Pathian emak takkha akaring ngai Pathian eii.” ");
INSERT INTO kfw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mipui in hiwa injetpha, inmani'n ama minchuna khan inleingak. ");
INSERT INTO kfw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisu'n Sadducee ngaikha min-om chianjei tikha Pharisee ngai'n injet phakhan, inmani rakip in inchunna inleinei, ");
INSERT INTO kfw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Halli inmani ngai karra, sina Dan ocha inkhat in, chongrakel nale inruoiya ama surnasik lei-ensui. ");
INSERT INTO kfw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ocha,” “Sina Dan suungnga huwa chongpeii hume kalokkhet?” ");
INSERT INTO kfw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisu'n aleimasang, “ ‘Pumi na Pathian kha namalung, naratha, halli na-ngaidonna pumpuiya minriangro.’ ");
INSERT INTO kfw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hiwahi akalokkhet khat-um ma-insakhet chongpeii kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Halli hi angnga inni huuina kha um: ‘Nang in na-indiang na-inwaipui ngai kha napumtak angnga minriangro.’ ");
INSERT INTO kfw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses sina Dan khat-um Pathian chongkachoi ngai minchuna kha hiwa chongpeii inni hin araya ah ahuui wiakjei.” ");
INSERT INTO kfw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pharisee lekkhat in inlei intup pha, Jisu'n inmani diang aheirakel, ");
INSERT INTO kfw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Messiah jarra angme ningngaidon? Ama hi tu sapa me?” Inmani'n inleimasang, “Ama hi David sapa eii.” ");
INSERT INTO kfw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Jisu'n inmani diang ati, kha e-inle, David in Ratha ah amadiang angtho-thoa ‘Pumi’ tia ikoime? David in ati, ");
INSERT INTO kfw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Pumi in Kapumi diang ati: Kei kachangtiang in-ongro Kei'n ni-inhalpui ngaikha nakeii nuoiya kada maklaiseng.’ ");
INSERT INTO kfw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David in amakha ‘Pumi’ tia akoi inchu, angtho-thoa Messiah hi David sapa esikme?” ");
INSERT INTO kfw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tu inkhat in num Jisu diang chong inkhat um leimasang mator mujei, khawani makheiya inphut tu-inkhat innum amadiang chong inkhat um rakelmujei. ");
INSERT INTO kfw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Halli Jisu'n mipui ngai khat-um ama siamruoi ngaidiang aleiti. ");
INSERT INTO kfw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Sinadan ocha ngaili Pharisee ngai'n Moses in-ongna khan in in-ong. ");
INSERT INTO kfw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Khawa jarra inmani'n angme thoru inti rakip nangni'n thoru halli juiru; takkha inmani omchan khachu juimaru, ajarchu inmani'n angme inril kha inmani'n thomu. ");
INSERT INTO kfw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Inmani'n phurrik kha inkhit ah, mi ngai darkhoi chungnga inminpuut, takkha inmani inchu inkutramol inkhat innum kadompuimu. ");
INSERT INTO kfw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Takkha inmani chuontho rakipchu mi ngai munasik ah intho, enru inmani'n Chong inthiang ramol ngaikha inmachal khat-um inbaanna inmakhai, halli inmani puondiar inchuol inkahak mor ngaikhan inmakhai! ");
INSERT INTO kfw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Inmani'n bubakna mun kahoikhet li synagogue ah in-ongna kahoikhet kha inkadang; ");
INSERT INTO kfw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","inmani'n mipui inchunna munkhan mi ngai'n khoya intho halli Ocha tia inmani inkoikha inleimanuom. ");
INSERT INTO kfw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Takkha nangnichu Ocha intimaru; ajarchu nangni Ocha chu inkhat bit eii, halli nangni rakipchu unai ning-eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Halli nuoipilchungnga tu inkhat diang-um Pa ti inlang koimaru, ajarchu nangni marwaanna Pa inkhat bitkha ningnei. ");
INSERT INTO kfw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Emakli nangni chu Lamkakei intimaru, ajarchu nangni ngai lamkakei khachu Messiah bit kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nangni karra kalokkhet ama khan nangni suok ala esik eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ajarchu tuka-ang atheinuo ah indomsaang amakha alaminniamsik eii, halli tuka-ang atheinuo ah nunchan inchuol amakha lakadomsaang sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nangni nunchan katha inleem, dan ocha khat-um Pharisee ngai! Nangni diang poongna omrase, ajarchu nangni'n marwaan Rengram kha mi ngai chungnga ningkharjei, takkha nangni-um luutmakchu, halli luutsik katho inmani kha um zootpimakchu!” ");
INSERT INTO kfw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nangni nunchan katha inleemngai, Dan ocha khat-um Pharisee ngai! Nangni diang poongna omrase, ajarchu nangni'n Pathian diang kani omchan ningthoa kasoot ah ningni, halli chuulmei ngai innle-lei um ningkasut, khawa jarra nangni'n kheella kalok poongna ngaikha ningmusik eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nangni nunchan katha inleemngai, Dan karu khat-um Pharisee ngai! Nangni diang poongna omrase, ajarchu nangni'n tuipui khat-um ram rakip ah ningloonna mi inkhat omchan ninminthuul, halli nangni'n amakha nangni neek-ah chan inni chungtiang poongnakamu meikhur sapa kha ninmin eii!” ");
INSERT INTO kfw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nangni mitkacho lamkakei ngai, Ningchungnga poongna omrase, nangni'n ningti, ‘Tuka-ang inkhat in Biak-inn palla chong inkhit inchu ama chong-inkhitna khan inkhitmak; takkha ama'n Biak-inna kaom soonna rakook ah chong inkhit khachu, amakha chong inkhit eii.’ ");
INSERT INTO kfw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aka-am khat-um mitkacho ngai! Soonna emakli soonna kha kaminthiang biak-inn hi hume kheella kalok? ");
INSERT INTO kfw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Halli nangni'n ningminchu, Tuka-ang inkhat in Pathian maichaam rakook ah chong inkhit khachu ama chong inkhitna khan inkhit mak; takkha ama'n Pathian maichaam chungnga inda kutchoi kha rakook ah chong inkhit khachu amakha chong inkhit eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nangni mitkacho ngai, kutchoi emakli kutchoi kaminthiang Pathian maichaam kha hume kheella kalok? ");
INSERT INTO kfw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Khawa jarra Pathian maichaam rakook ah chong inkhit ama'n maichaam khat-um khawa chungnga kaom phur rakipkha rakook ah chong inkhit eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Halli Biak-inn rakook ah chong inkhit ama'n biak-inn khat-um khawa suungnga kaom Pathian rakook ah chong inkhit eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Halli tuka-ang inkhat in marwaan rakook ah chong inkhitpha, ama'n Pathian reng in-ongna khat-um khawa chungnga in-ong Pathian kha rakook ah chong inkhit eii.” ");
INSERT INTO kfw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nangni nunchan katha inleem! Dan ocha khat-um Pharisee ngai, nangni chungnga poongna omrase! ajarchu thikaraanglei, reihiing khat-um wonpuorlei ngaihi soom suungnga inkhat Pathian diang ningpeli, chongpe khaneek ah arei ka-eii minchuna ngai, akatuun, minriang khat-um ngamna hichu ningmathaan, takkha hiwarakip hi nangni'n ningthosik asuok halli aleiilak ngaihi um manilmaru.” ");
INSERT INTO kfw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Juchukchu kha radiikna ah ningradiikli, salaileem chu kamaduol nangni mitkacho lamkakei ngai! ");
INSERT INTO kfw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nangni nunchan katha inleem! Dan ocha khat-um Pharisee ngai! Ningchungnga poongna omrase, ajarchu nangni rabing li bukheeng kha apangtiang bit ningrasu, takkha asuungtiang chu maruupnasik khat-um atheinuo sik ah ngaidonna bitkhan pumsip asip.” ");
INSERT INTO kfw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mitkacho Pharisee! rabing suungnga kaom kachok kha ma-insa ah minthiang masaro halli apangnga kaom kachok kha-um ahong inthiangsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nangni nunchan katha inleem! Dan ocha khat-um Pharisee ngai! ningchungnga angtuk poong kaomme, ajarchu nangni tuollachu akatha angnga nimuli asuungnga chu akathi saru ngaili akachok-in kasip akabang inkanoot thaan ka-ang ning eii.” ");
INSERT INTO kfw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Khawa angnga nangni-um tuollachu mi ngaidiang akatha angnga ning inmu, takkha asuung ngachu nunchan katha inleemna li manu in asip. ");
INSERT INTO kfw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nangni nunchan katha inleem! Dan ocha khat-um Pharisee ngai angtuk poong kaomme! nangni'n Pathian chongkachoi ngai thaan kha katha ah ningbool, halli tuka-ang ringkhuo katha ah karing ngai thaanlung kha ningminliang; ");
INSERT INTO kfw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","halli nangni'n ningti, keini'n kinpi-kinpu ngai phakhan kinleiom inchu, Pathian chongkachoi ngai inthat nakhan inmani ngaile inruoiya chan kinleinei maksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Khawa jarra nangni'n inthiangnga Pathian chongkachoi ngai kathat inmani sa-ngai kin-eii ti nangni ningtheinuo ah sakhi ning-inpejei. ");
INSERT INTO kfw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kha e-inchu angme ningpi-ningpu ngai ileiphut kha nangni'n minsuoru! ");
INSERT INTO kfw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nangni maruulngai khat-um maruul sangai! angtho-thoa khawa meikhur sik ah chongtanna ah inphut suoksik tia ningngaidon me? ");
INSERT INTO kfw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Khawa jarra enru, kei'n nangnidiang karil khachu Pathian chongkachoi, mi kasing, halli ocha ngaikha kajuotirsik eii; inmani lekkhat kha nangni'n ningthatsik eii, lekkhat in cross ah, halli inmani lekkhat ngaikhan nangni Synagogue ngaikhan enmeel kase ah ningwuoksik eii, halli khuopui ngaikhan thatnasik inmani ningpuutsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hiwahi nangni'n Biak-inn li Pathian maichaam kongkarra ning-ithat mi kadik Abel la inphut Barachiah sapa Zechariah katung nuoipilla thi ningmasuokna rakip ngai poongna kha nangni chungnga achulsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kei'n nangni diang inthiangnga karil, hiwarakip ngai ningthatna rachaakna kha tuunna khang chungnga achulsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Pathian in ijuotir chongkachoi ngai lungnga kadeeng khat-um Pathian chongkachoi ngai kathat nang! Arpui in ateii ngai amurtha nuoiya ida angnga, kei'n nami ngaihi angtuk kiompui zootme, takkha nangni'n zootmak chu! ");
INSERT INTO kfw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Halli enru, nangni Biak-inn kha karuok ah kanadapi ejei. ");
INSERT INTO kfw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ajarchu kei'n nangni diang kati, ‘Pumi ramingnga akajuo ama kha rawaan katha kha eii ningtimak laiseng, tuunna inphut nangni'n keihi supmu namu khainutun jei.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisu'n Biak-inn mathaanna asi phakhan, asiamruoi ngai'n insak innjarra amadiang minmunasik ah akoolla inheiwa. ");
INSERT INTO kfw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","“Oh,”Jisu'n inmani diang aleiti, “Nangni'n hiwa rakip ngaihi mumak chube? Kei'n nangni diang inthiangnga kiti eii, lung khatbit um lung inkhat chungnga omnuni; inraja ah la-inlet wiaksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisu'n Olives Chingnga in-ongnga omlai, siamruoi ngai'n ruuk ah amadiang inheiwa ah inleiti. “Hiwa rakip ngaihi angtik asuoksik me,” “halli nang najuonasik li manmasituol hekna jetnasik, keinidiang natipiro.” ");
INSERT INTO kfw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Halli Jisu'n inmani diang aleimasang, “Insingtheiru, tu-inkhat innum nangni innaminweet maknasik. ");
INSERT INTO kfw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ajarchu mi katam khat in karamingnga, Kei Messiah ka-eii! ti-inta inheiwasik eii; halli mi katam khat kha aminweet sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nangni'n raal khat-um raalchong rasa akanai khat-um akalaak ah ninglajetsik eii, takkha chimaru; ajarchu hiwa rakip hi alasuoksik eii, takkha ahekna kha tuunkatung lahongmak. ");
INSERT INTO kfw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ajarchu ramkhat li ramkhat inla-insuolsik eii, halli rengram khat li rengram khat inla-inthatsik eii; halli amun rakip ah bukawaang li rinook alasuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hiwa rakip hi naiha kahong ma-insa kha ka-ang eii.” ");
INSERT INTO kfw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Halli nangni nasur inta minpoong nasik innalapesik eii, halli nangni innalathatsik eii, halli zaat rakip in kei jarra nangni innamatir sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Halli khawa phakhan akatamkhat in la-inngamna nunu, halli inmani inkhat li inkhat inla-inpesuoksik eii, halli inkhat li khat inla-intirsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Halli akatuunmak Pathian chongkachoi angjet lahongsuok inta mi akatamkhat alaminweetsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hiwa ka-ang akathamak ahongkheel jarra, minriang hi mi katamtak ngai chungnga ajuotoom sik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Takkha ahekna katungnga kadei ama kha aringsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Halli hiwa Rengram jarra Chong Kahoi hi phungle zaat rakip ah sakhi enasik ah manmasituol pumpuiya inlarilsik eii; halli ahekna kha ajotungsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Khawa jarra Pathian chongkachoi Daniel diangnga ileiminril, kaminmang mator ‘Chikaompa’ khan inthiang munna ingir nangni'n ningmusik eii.” (Akateel ama khan jetrase!) ");
INSERT INTO kfw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Khawa phakhan tuka-ang Judea ah kaom rakip in chingtiang taanrasu.” ");
INSERT INTO kfw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tuka-ang innchungnga kaom ama khan innsuungnga kaom phur ngaikha kakeisuosik juochum khaimarase; ");
INSERT INTO kfw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","halli tuka-ang leiya kaom ama khan apuonsil kaleisik heikir khaimarase. ");
INSERT INTO kfw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Halli nai kalawon numeisa ngaisik khat-um nainu ngai sik achu khawa phakha angtuk poongkaom sikme! ");
INSERT INTO kfw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Phanbi emakli Jihudi ngai sernikhuoni ningtaan maknasik Pathian diang niru! ");
INSERT INTO kfw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ajarchu khawa phakha manmasituol inphut makheiya awini katung lakasuokmak, halli angtikniteii um kasuok khaimaksik poongna kalok khetkha esik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Takkha Pathian'n nikhuo ngaikha amintoomjei; kha emak inchu manmasi tu inkhat um ringthei nunu; takkha ama ikadang mi-ngai sikbit ah khawa nikhuo ngaikha Pathian in aminbongsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Khawa pha takkhan, ‘Enru, hiwahin emakli khawakhan Messiah kha aom!’ tuka-ang inkhat in nangni diang ati inchu ngamnamaru.” ");
INSERT INTO kfw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ajarchu Christa inleem khat-um Pathian Chongkahoi inleem ngai inlahong suoksik eii, halli ethei-inchu, ikadang mi ngai katung matheemna machulnasik ah, chuon inlak li ngaksik kaom angjet ngaikha inlathosik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Rangairu! kei'n nangni diang apha matiang kinatipi ejei. ");
INSERT INTO kfw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Emakli, mi ngai'n nangni diang, ‘Enru, ama neelramma aom inti inchu!’ khawakhan juosi maru, halli ‘Enro, ama hin inthup ah om inti innum!’ ngamnamaru.” ");
INSERT INTO kfw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ajarchu Miring Sapa kha nisuotiangnga kool-inlek kha niluutna tiang katung inmu kha angnga alajuosik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Kathi kaluong omna munkhan laangkia ngai ininchunsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Poongraalna nikhuo ngai hekli hekmak innot ah kani'n ahongziing sik eii, tha in ama ra-ang penunijei, arsi ngai'n marwaanna inphut injuotasik eii, halli marwaanna ranak rakip um intuulsik eii; ");
INSERT INTO kfw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","halli khawa phakhan lairalak ah Miring Sapa madanna kha inlarsik eii; halli manmasituolla zaat rakip in inlachapsik eii, khat-um ranak le alur-alianna khale inruoiya Miring Sapa khan suumphai chungnga ijuo kha inmani'n inmusik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tampalooi rasa inringkha inlatumsik eii, halli ama'n ama marwaan tirton ngaikha neipilchung raki miliya atirsik eii, khat-um ama ikadang neipilchung pumpuiya kaom mingaikha inmani ngai'n inheikhoom chunsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Tuun nangni'n theichang kuungnga inphut chongminkhi inkhat hi inchuru; aziik kadoongkha ahongcherra abuo hongsuokjei inchu, nangni'n kholumpha ahongnaijei tia ningjet.” ");
INSERT INTO kfw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kha angnga nangni'n hiwarakip hi ningmu phakhan, apha anaijei, ama kotkuung juotungjei, ti nangni'n ningjetsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kei'n nangni diang inthiangnga kiti eii, hiwarakip hi asuok maklaiseng hiwa khang hi laheknuni. ");
INSERT INTO kfw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Marwaan li nuoipil chu lamangsik eii, takkha kei kachong ngaichu angtikniteii mangnuni. ");
INSERT INTO kfw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Khawa nikhuo li aphakha kapa eleiya, marwaan tirton ngai innum, Sapa innum, tu inkhat innum jetmu.” ");
INSERT INTO kfw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ajarchu Noah pha khanna angme kasuok angnga, Miring Sapa kajuo kha um khale in-angsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ajarchu khawa tuikalian matiang khan, Noah in rakuong aluut maklaiseng, mi ngaikhan inbak inin, moi inleiruoi khat-um moiruoi nasik inleitho; ");
INSERT INTO kfw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","tuikalian kha ajuo ah inmani rakip achoi maklaiseng angme kasuok inmani injetmak kha angnga, Miring Sapa kha ajuo pha khannum kha angnga asuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Khawa phakhan leiya miring inni chuon inthosik eii; inkhat kha aruoisik eii, halli inkhat kha adasik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Numeisa inni chakari intak ah in-omsik eii; inkhat in aruoisik eii, halli inkhat kha adasik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Khawa jarra insingtheiru, ajarchu nangni Pumi kha angtikni ajuosikme nangni'n jetmakchu. ");
INSERT INTO kfw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Halli hiwahi jetru, angtikni innruppa'n aheiwa sikme ti innmapupa'n ajet inchu, ama'n inringchakta, halli a-inn kha innruuppa khan leimakoi matornuni. ");
INSERT INTO kfw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hiwajarra nangni um inringchakru, ajarchu ningngaidon makna phatak khan Miring Sapa kha ajuosik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kha e-inchu, tume aphakacha ah innmapupa in inmani diang baksik kapesik ithun ngamna kaom khat-um akasing suok kha?” ");
INSERT INTO kfw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Amapupa'n inna aheikir pha hiwa ngai kathoa kaom jo-intongpui suok ama kha rawaan katha eii! ");
INSERT INTO kfw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kei'n nangni diang inthiangnga kati, ama'n ineirakip kha asuokpa diang aminhuumsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Takkha ama akathamak suok kha e-inchu, ama atheinuo ah intisik eii, kamapupa chu lahongwak nuni, ");
INSERT INTO kfw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","halli ama'n asuok changpui ngaikha kawuok khat-um ju inrui ngaile kabak khat-um ka-in aphutsik ejei. ");
INSERT INTO kfw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Halli suok mapupa kha suokpa khan angaidon makna phakhan ahongkirsik eii, halli ama'n aphakha jetnuni. ");
INSERT INTO kfw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Amapupa in ama kha abong bongnga atansik eii, halli nunchan katha inleem ngai rasi-enna tumkha ama'n amusik eii; khawakhan chapli hakarialna esik eii. ");
INSERT INTO kfw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Khawa pha marwaan Rengram khachu inmani meiser inchoiya moipa kadonsik ah heikasuok nungaak soom ka-angsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Halli inmani ranga khatchu akamo in eii, khat-um ranga khat ngaichu akasing inlei-eii. ");
INSERT INTO kfw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Akamo ngaikhan inmeiser kha inheichoi, takkha inmani'n sariaktui inliakchu heichoimu; ");
INSERT INTO kfw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","takkha akasing ngai khanchu inmani meiser le inruoiya sariaktui thunna inminteiya inheichoi. ");
INSERT INTO kfw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Moipa heikasuok insuum jarra, inmani rakip imu inlei-inchu halli inleizaaljei. ");
INSERT INTO kfw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Halli zaanchim khan rasa inkhat aheikheek ah, ‘Enro moipa kha aheiwajei, ama kadonsik heisuoktaru!’ ");
INSERT INTO kfw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Khawa phakhan nungaak soom ngai'n in-intheiya, inmeiser inhongminkai. ");
INSERT INTO kfw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Halli akamo ngai khan akasing ngaidiang inti, nangni sariaktui lekkhat naperu, ajarchu keini meiser ajothijei. ");
INSERT INTO kfw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Takkha akasing ngai'n inheimasang, keinisik um nangnisik um hunmak acha, nangni'n si-inlang akajuor ngaidiang, nangnisik lekkhat jorachoru. ");
INSERT INTO kfw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Halli inmani'n karachosik insipha, moipa kha ajuojei, halli insuukchak ah leikaom ranga ngai kha'n amale inruoiya moiruoi bubak natiang khan inluutjei; halli kotkha inkharjei.” ");
INSERT INTO kfw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Khawasuo aleiilak nungaak ngai um inhongtungjei. ‘Pumi, Pumi! keinisik kot namalongpiro!’ inhongti. ");
INSERT INTO kfw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Kei'n nangnidiang inthiangnga kiril eii, kei'n nangni najetmong,’ tia ama'n aleimasang.” ");
INSERT INTO kfw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Khawa jarra, “Nangni insingtheiru, ajarchu nangni'n nikhuo li phadan kha jetmakchu.” ");
INSERT INTO kfw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Marwaan rengram hi miring inkhat in khuol-injil asi siktiang asuok ngai akoili ineirakip inmani diang iminhuum khale in-angsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Halli inkhat diang talent ranga, inkhat diang talent inni, halli inkhatpa diang talent inkhat, ama itho matorna dungkajuiya inmani rakip diang apeli, ama khuol-injil asijei. ");
INSERT INTO kfw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Talent ranga inhuum mipa khan innoot ah asiya sialthuoi aminsiya talent ranga khat atuongjei. ");
INSERT INTO kfw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Khanthoa talent inni inhuumpa kha innum talent inni khat leiminliakjei. ");
INSERT INTO kfw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Takkha talent inkhat inhuum suokpa khan asiya neipil acheiya amapupa sial kha athupjei. ");
INSERT INTO kfw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Apha kasoottak suo ah suok ngai mapupa kha ahongnga inmani le inruoiya sial lei-inpapui jei. ");
INSERT INTO kfw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Halli talent ranga inhuumpa khan aheiwa ah, talent ranga khat ahongchoiya ati, ‘Ocha, nang in keidiang talent ranga nanaleipe,’ ‘Na-enpiro! kei'n talent ranga khat kaminliakjei.’ ");
INSERT INTO kfw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Amapupa khan amadiang ati, ‘Athajei, akatha khat-um ngamna kaom suok!’ ‘Nangchu phur lekteii chungnga ngamna nathajarra, kei'n phur rakip kanaminhuum sik eii; heiwaro namapupa rokna khan chan neiro!’ ");
INSERT INTO kfw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Talent inni ipe mipa khannum aheiwa ah, ati, ‘Ocha, nang in keidiang talent inni nanaleipeii; na-enpiro! kei'n talent inni kaminliakjei.’ ");
INSERT INTO kfw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ama mapupa khan amadiang ati, ‘Athajei, akatha khat-um ngamna kaom suok!’ ‘Nang chu phur lekkhat chungnga ngamna na-om jarra, kei'n nanghi phur rakip kanaminhuum sik eii; heiwaro namapupa rokna khan chan neiro!’ ");
INSERT INTO kfw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Halli talent inkhat kamahuum suokpa innum aheiwa ah ajoti, ‘Ocha, nangchu malung kangar na-eii; lingleiya narakhool, halli muchi worleiya nakhoom ti kei'n kaleijet; ");
INSERT INTO kfw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","khawa jarra kanachiya kei'n kasiya, talent kha neipil suungnga kaleithup jei. Enro! nata kha hi eii.’ ");
INSERT INTO kfw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amapupa khan amasangnga amadiang aheiti, ‘Kathamak khat-um huoikajoumak suok!’ kei'n kiwormak kha karakhool, halli muchi worleiya kakhoom ti ‘Nang in nijet emak abe? ");
INSERT INTO kfw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Khawakha alei e-inchu nang in kei kasial kha sialdana innkhan naleidali, kei'n kaheikir pha sialthuoi khale inruoiya kei'n kaleimusik eii. ");
INSERT INTO kfw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Khawa jarra ama diangnga talent kha lei-inlang talent soom kaneipa ama diangkhan peru. ");
INSERT INTO kfw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ajarchu akanei mi rakipdiang inpedelsik eii, halli ama'n kheella aneisik eii; takkha akaneimak mipa inei lekteii kha um ama diangnga inphut inleidelsik eii. ");
INSERT INTO kfw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Neiman kathamak suok kha tuolla kaom kaziing khan ama juokalekjuonru; khawamun khan ama chap li aha karialla kaom erase.’ ");
INSERT INTO kfw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Miring Sapa in Reng eya apoina khan marwaan tirton ngaile inruoiya ajuopha khan, ama reng in-ongna khan in-ongsik eii, ");
INSERT INTO kfw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","halli zaat rakip ah mi-ngai kha um ama maikuungnga aminchunsik eii; keelngam kakhaalpa khan keelli keelngam ikhoithen angnga, inmani inkhatli inkhat akhoithensik eii. ");
INSERT INTO kfw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Halli ama'n keelngam ngaikha achangtiang, khat-um keel ngaikha aweitiang adasik eii. ");
INSERT INTO kfw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Halli Reng khan achangtiangnga kaomngai diang atisik eii, ‘Heiwaru, Kapa rawaan kamu nangni ngai! Heiwa inlang neipilchung inboolla inphut nangnisik ah innaboolpi rengramkha joluotaru. ");
INSERT INTO kfw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ajarchu kei kawonchaam pha nangni'n baksik ningnape, kei'n katuiraal pha khannum tui ningnapeii, kei'n khomal inkhat ka-e pha khannum ningna-leiralaang; ");
INSERT INTO kfw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","puon choisik kaneimakpha puon ningnape, kei'n kana pha nangni'n ningna en, kei'n mikhumna ah kaom pha nangni'n ningnajuopha. ");
INSERT INTO kfw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Khawa phakhan mikatha ngai'n ama diang inheimasangsik eii, Pumi, nang nawonkachaam kinmuwa angtik kinaminbak ame, emakli natuiraal pha kinamin-in nabe? ");
INSERT INTO kfw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Angtik nang in khomal na-e pha kinnamuwa kin inna kinnaruoiluut ame, emakli puon ommak pha puon kinape ame? ");
INSERT INTO kfw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Emakli nang in nana ah khat-um mikhumna ah niom angtik kinnamuwa nakoolla kinhongnga me?’ ");
INSERT INTO kfw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Rengpa khan inmani diang heimasangta, ‘Kei'n nangnidiang inthiangnga kanatipi, kei ka-u kanai kasiinkhet chungnga nangni'n angrakip ningtho kha, keisik ah ningtho eii!’ ” ");
INSERT INTO kfw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Halli ama'n aweitiangnga kaom ngaidiang khan aheitisik eii, ‘E Pathian khomaak saamna kamungai! kei diangnga inphut si-inlang Seitan khat-um ama tirton ngaisik bit ah inbool hektik kaboi meikhur khan siru! ");
INSERT INTO kfw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ajarchu kei'n kawonchaam pha nangni'n baksik napemak chu, halli kei'n katuiraal pha nangni'n kei namin-in mak chu, ");
INSERT INTO kfw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","kei'n khomal inkhat ka-e pha, nangni'n kei naleiralaang makchu, puon ommak pha keidiang puon napemakchu, kana ah khat-um mikhumna ah kaom pha nangni'n naphamakchu.’ ");
INSERT INTO kfw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Halli inmani innum inhongmasang sik eii, ‘Pumi, nang nawonkachaam, natuikaraal, khomal inkhat ah nisi, puon nineimak, nina emakli mikhumna ah niom keini'n kinnamuwa, kinnasan makna ommabe?’ ");
INSERT INTO kfw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Khawapha Rengpa khan inmani diang heimasangta, ‘Kei'n inthiangnga nangni diang kitihi eii, nangni'n angme akasiinkhet ngai karra inkhat chungnga ningsan zootmak hi, kei ningnasan zootmak kha eii.’ ");
INSERT INTO kfw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Halli inmani kha hektik kaboi rachaakna munkhan atirsik eii, takkha mikatha ngaikhan hektik kaboi ringna khan insisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisu'n hiwarakip ngai aminchusuo pha, ama'n asiamruoi ngaidiang aleiti, ");
INSERT INTO kfw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nini thengnga Rakaanna Kahoi omsik eii, halli miring sapa kha cross ah thatnasik a inpesuoksik eii ti nangni'n ningjet.” ");
INSERT INTO kfw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Halli araming Caiaphas inti Thiampu kaliankhet inntuol khan thiampu kalianngai khat-um upa ngai inlei intuup, ");
INSERT INTO kfw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","halli Jisu ruuk ah surra ama thatnasik chuonkha inleiminsuuk. ");
INSERT INTO kfw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Mipui ngai'n inphu maknasik,” “kahoi suungngachu thomui,” inmani'n inti. ");
INSERT INTO kfw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bethany ah kaom apumkaphar Simon inna Jisu kha aleiom. ");
INSERT INTO kfw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Numeisa inkhat in aman katam sariak rimkahoi inthun alabaster lungbeel kasip inkhat aheichoiya Jisu koolla aheiwa, halli Jisu'n bu abak laitak khan aluchungnga aleibunpi. ");
INSERT INTO kfw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hiwahi siamruoi ngai'n inmu halli hoimaktheiya inheiti, “Angsik hiwarakip hi niminmangme?” ");
INSERT INTO kfw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Ajarchu hiwa sariak hi aman katamma juorlia, sara ngaidiang sial kha pekacha eii!” ");
INSERT INTO kfw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisu'n angme inmani inti ajet ah, inmani diang ati, “Angsikme numeisanu ningminpoong? ama'n keisik ah chuon kathatak athojei. ");
INSERT INTO kfw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ajarchu sara ngaichu nangnile inchatlekleiya ning omsuom, takkha keichu nangnile inchatlekleiya omsuom numin. ");
INSERT INTO kfw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ajarchu ama'n hiwa sariak rimkahoi hi kei kapum chungnga ibunthuon hin kei phuumnasik ama insuuksuo kha ejei. ");
INSERT INTO kfw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tuun kei'n inthiangnga nangni diang kitihi eii, manmasituol pumpui hiwa chongkahoi hi rilsuokna rakip khan, ama'n angme ileitho kha ama ngaidonna sikbit ah inrilsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Khawapha Judas Iscariot inti, siamruoi soomleini ngai karra inkhat in thiampu kalian ngaidiang asiya ati, ");
INSERT INTO kfw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Kei'n ama kha nangnidiang kanapeii inchu, nangni'n keidiang angme ningnapesik?” Halli inmani'n amadiang dangkapum soomthum inleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Halli khawapha makheiya Judas in Jisu pesuok nasik aphakacha kha alei-entok. ");
INSERT INTO kfw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chol inchelmak waipool bakna nikhuo ma-insakhetni siamruoi ngai'n Jisu diang inheiwa ah inti, “Rakaanna kahoi bubak nasik kha nangsik hunme keini'n kinminsuuksik nimanuom?” ");
INSERT INTO kfw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ama'n ati, “Khuopui khan luut inlang tuka-ang mi inkhat diang,” “Kei kapha juotungjei ‘Ochapa in ati, na-inna kei kasiamruoi ngaile kei Rakaanna kahoi kha thokinte juotiru.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jisu'n inmani diang itipi angnga, siamruoi ngai'n Rakaanna kahoi bu kha inleiminsuuk. ");
INSERT INTO kfw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kholei hei-epha khan, siamruoi soomleini le Jisu bubak nasik ah inlei in-ong. ");
INSERT INTO kfw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jisu'n bu inbaklai khan ati, “Adik nangni karra inkhat in kei anajuorsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Siamruoi ngaikha inmalung inleipoong theijei halli inmani rakip in amadiang inti, “Kei'n be Pumi?” ");
INSERT INTO kfw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Halli Jisu'n aleimasang, “Kheengnga keile inruoiya kut kanoom amatak in kei anapesuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Miring Sapa kha Chong inthiang in ileiril angnga alathisik eii, takkha Miring Sapa kha akapesuoksik miringpa sik achu angtuk ah poong kaom sikme! khawa mipa kha inleineimak in kheella amasik ah aleikatha sik eii!” ");
INSERT INTO kfw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kapesuok sik Judas khan hongmasang, “Kei'n be, Ocha?” Jisu'n ama diang ati, oh, “Nang in narilsuokjei.” ");
INSERT INTO kfw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Inmani'n inbaklaitak khan, Jisu'n waipool kha aleiya rawaan apeli, akatherkhoijei, halli asiamruoi ngaidiang peli ati, “Lei-inlang bakru,” “hiwahi kei kataksa eii.” ");
INSERT INTO kfw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Halli ama'n rabing aleiya, Pathian diang rawaan apeli, inmani diang apeya, “Nangni rakip hiwahi inru” ati; ");
INSERT INTO kfw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Ajarchu khawa chong-inkhitna, manu rakip ngaidamnasik ah akasar kei kathisen kha eii. ");
INSERT INTO kfw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kei'n nangni diang kitihi eii, kapa Rengramma nangnile inruoiya woikhat hiwa theibomju hi ni-insuom nasik nikhuo atungmak laiseng, kei'n tuunna inphut hiwa theibomju innuningjei.” ");
INSERT INTO kfw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Halli inmani'n laa insak ah Olives Chingtiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Khawa phakhan Jisu'n inmani diang ati, “Nangni rakip in awini zaantak hin keidiang insuina ningneisik eii, ajarchu hiwahi chong-inthiangnga injia kha ejei, ‘Pathian in keelngam kakhaalpa kha alathatsik eii, halli keelngam rahooi ngaikha inlachaangdar sik eii.’ ");
INSERT INTO kfw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Takkha woikhat kei'n kahongringli, kei'n nangni matiang Galileeya kasisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter in Jisu diang aleimasang, “Mi rakip in nangdiang insuina innei-innum, Kei'n chu angtikniteii insuina neinuning!” ");
INSERT INTO kfw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisu'n Peter diang heiti, “Kei'n nang diang inthiangnga kitihi eii, awini zaantak hin Arkhong khan akhuong makma, nang in keihi woithum nazoot nutin.” ");
INSERT INTO kfw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter'n leimasang, “Kei'n pumile thisuomsik asuok innum, kei'n chu nangkha zootmak suptho nathonuning!” Khawakhale in-angrip ah siamruoi rakip innum inleiti. ");
INSERT INTO kfw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Khawa phakhan Gethsemane intiya inkoi amun khan Jisu'n inmanile inruoiya inheiwapha, siamruoi ngaidiang ati, “Kei'n soson kasiya Pathian kani phakhan, nangni hiwahin lei-inongru.” ");
INSERT INTO kfw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pumi'n amale inruoiya Peter khat-um Zebedee sangai inni aleiruoi, halli pumi kha malung poongnale malung dongna khan aleisip. ");
INSERT INTO kfw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Khawa phakhan pumi'n inmani diang ati, “Kei karathahi thisik katungnga apoongjei; nangni hin om-inlang, keile inruoiya inringchak kha erui.” ");
INSERT INTO kfw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ama'n matiang lekkhat asidetli, ameel nuoitiang enna inbok ah aleini, “E kapa, hiwahi acha-inchu kei diangnga inphut poongna rabinghi nakhaipiro! kha e-innum kei kalungdou emarase, takkha nang nalungdou kha erase.” ");
INSERT INTO kfw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Halli ama'n siamruoi inthum ngaidiang heikirpha, inmani inleizaal kha ajuomu, halli Peter diang ati, nangni'n “Kei le angtiame phadan inkhat um ningna-inringchak puimatormak? ");
INSERT INTO kfw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nangni'n matheemna khan ningchulmak nasik, inringchak inlang niru; ratha inchu athozoot, takkha taksa inchu asuol.” ");
INSERT INTO kfw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Woikhat um Jisu'n inlet ah akirra nina ajuonei, “E kapa, hiwa rabinghi Kei'n ka-inmak innum khaikathamak sik ejei inchu, nalungdou kha inthorase,” ");
INSERT INTO kfw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ama'n woikhat heikirpha siamruoi ngai inleizaal kha ajuomunook; ajarchu inmani inmit leimakek matormu. ");
INSERT INTO kfw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jisu'n inmani woikhat amathaanna akirli, woithum huuina nina kha chongramol in-angrip ah aleini. ");
INSERT INTO kfw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Khawa phakhan Jisu'n siamruoi ngaidiang aheikirra ati, “Nangni tuunkatug ninglazaalla poong ninglamachum be? Enru! phadan kha ajuonaijei; Miring Sapa kha manu karoon ngai kutchungnga inpenasik. ");
INSERT INTO kfw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Intheitaru, eini situi; enru, kei kanapesuok sik mi kha hin omjei!” ");
INSERT INTO kfw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisu'n chong arilla omlaitak khan, enro, Judas, siamruoi soomleini ngai karra inkhat kha ahongjei, halli thiampu kalian ngaili katar ngai ihongtir, chemli ramol kachoi mipui katamtak amale inhong inruoi. ");
INSERT INTO kfw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Halli pumi kapesuokpa khan jetna inkhat apeya aleiti, “Kei'n kimazoop mi kha eii; amakha surru!” ");
INSERT INTO kfw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Khawa phatak khan Judas Jisu koolla ahongnga, “Ocha, chubei” tia, amakha hongmazoop. ");
INSERT INTO kfw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisu'n amadiang ati, “Suopui, nang in thosik ah nihong kha angme innot ah thoro!” Halli inmani inhongnga, Jisu kha insurli inkhitjei. ");
INSERT INTO kfw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Khat-um enru, Jisu le leikaom inmani ngai karra inkhat in achem keisuoa thiampu kaliankhet suokpa kuorkha aleitukthakpi. ");
INSERT INTO kfw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Khawa phakhan Jisu'n amadiang ati, “Nachem kha akok ah thunkirro,” “Ajarchu chem kachoi rakip chemma inthisik eii. ");
INSERT INTO kfw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Marwaan tirton legion soomleini kakhel tuuntak kakoolla juomasuo nasik kei'n kapadiang nimatornutin tia nang na-ngaidonbe? ");
INSERT INTO kfw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kha katho inchu, angtho thoa Chong inthiang kha hintia asuoksik eii itikha huui tungniame?” ");
INSERT INTO kfw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Khawa phadantak khan Jisu'n mipui ngaidiang ati, “Dan kamakoi inkhat kasur sik angnga nangni'n chem khat-um ramol ningchoiya kei kanasur ninghongbe? Nisuorakip ah kei'n Biak-inn khan ka-in-ongnga kaminchu, halli nangni'n kei nasurmak chu. ");
INSERT INTO kfw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Takkha hiwarakip ngaihi Pathian chongkachoi ngai imajia chong kha tungnasik ah kasuok eii.” Khawa phakhan siamruoi ngai'n ama inmathaanna intaanjei. ");
INSERT INTO kfw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Halli Jisu kasur ngai'n Dan ocha ngaili katarngai inlei-inchunna, Thiampu Kaliankhet Caiaphas inna Jisu kha inleiruoi. ");
INSERT INTO kfw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Takkha Thiampu Kaliankhet inntuol katung Peter in inlaakjenna anuk leijui, halli aluut ah angme hongkasuok sik ennasik raalpa ngai khale inlei in-ong. ");
INSERT INTO kfw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Thiampu kalian ngaile katarrup rakip in Jisu chungnga akatuunmak sakhi thatnasik ah inleiratok; ");
INSERT INTO kfw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","takkha ama jarra maleisei sakhi kape mi katamma inhong innum, inmani'n iteii um leimumu. Ahekna ah miring inni inhongnga inhongti, ");
INSERT INTO kfw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Hiwa mipa'n, ‘Kei'n hiwa Pathian Biak-inn hi kathiatli nithum suungnga kasak mator aleiti.’ ” ");
INSERT INTO kfw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Thiampu Kaliankhet khan intheiya Jisu diang ati, “Nang iteii um masang nutinbe? nachungnga mi ngai'n inpe sakhi hi angme?” ");
INSERT INTO kfw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Takkha Jisu lei-omchianjei. Halli Thiampu Kaliankhet khan amadiang ati, “Pathian Sapa Messiah kha nang na-e inchu, akaring Pathian raming rakook inlang keinidiang rilro” ");
INSERT INTO kfw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisu'n amadiang ati, “Nang in natijei. Takkha kei'n nangni rakip diang kati, hiwa suoa Miring Sapa khan Akaraat khetpa changtiang in-ongnga marwaan suumphai chungnga ijuo kha nangni'n ningmusik eii!” ");
INSERT INTO kfw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Khawa pha Thiampu Kaliankhet khan apuondiar katherra ati, “Pathian kha kase ah aril jei! hiwakheella eini'n sakhi leisik arei ommakjei? enru, Pathian kha kase ah irilkha nangni'n ningjetjei! ");
INSERT INTO kfw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nangni'n angme ninglangaidon?” Inmani'n inheimasang, “Ama kathisik rahoi asuok.” ");
INSERT INTO kfw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Khawa phakhan inmani'n amaiya inmachilthuon halli kuttumma inleisuk; lekkhat ngai'n angemtaang inkabenna inti, ");
INSERT INTO kfw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“E Messiah, tume nang kanawuok? keini diang heirilro!” ");
INSERT INTO kfw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter in tuolla in-ongnga omlai, Thiampu Kaliankhetpa suok numeisa inkhat aheiwa ah amadiang ati, “Nang um Galilee Jisu le ninglei-inruoi.” ");
INSERT INTO kfw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Takkha ama'n inmani rakip maikuungnga zootmak ah aheiti, “Nang itikha kei jetmong,” ");
INSERT INTO kfw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","halli ama'n tuolkot khan asuok pha, leiilak suok numeisa inkhat in amakha aleimuwa khanna kaom mi ngaidiang ati, “Ama Nazareth Jisu le inlei-inlop eii.” ");
INSERT INTO kfw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","“Kei'n mipa kha jettakmong tia khomaak lei-insaamma,” woikhat zootnook makjei. ");
INSERT INTO kfw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Phabongkhat suo khawa koolla kangirra kaom ngai'n inheiwa ah Peter diang injuoti, “Inthiangnga nang um inmani ngai karra inkhat na-eii,” “Ajarchu nachongril khan kinnajet!” ");
INSERT INTO kfw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Khawa phakhan, “Tume ma kha kei jetmong katakchungnga Pathian in poongna naperase tia khomaak insaam aphut jei!” Khawa phatak khan innot ah arkhong kha akhuongjei, ");
INSERT INTO kfw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","“Arkhong khan akhuongma, nang in kei kha woithum nazootnutin tia Jisu'n iti chongkha Peter in ahongngaidonjei.” Halli ama'n tuol asuok ah malung intook ah ajuochapjei. ");
INSERT INTO kfw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ziingtiang matak khan, thiampu kalian rakiple katar rakip in Jisu thatnasik chuon inlei-insuuk. ");
INSERT INTO kfw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Halli inmani'n ama kha inkhit ah Rome ramwaikaroon Pilate diang inruoiya injopejei. ");
INSERT INTO kfw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Khawa phakhan Jisu kajuorpa Judas khan Jisu diang noonkuung inpekha ahongjet phakhan, amalung athuulla, dangka sialpum soomthum kha thiampu kalian ngaili katar upa ngaidiang woikhat hongchoiya ahongti, ");
INSERT INTO kfw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Kei'n manu karoon mak mikha thatsik kipesuok khan kei manu karoonjei!” ama'n ahongti. Inmani'n inleimasang, “Keini ang kinthosik ommame?” “Khawakha nang nachuon eii!” ");
INSERT INTO kfw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas in Biak-inn khan dangkapum kha adeengjuonna suokjei; halli asiya ruiya kaiya atheinuo ah ajuothijei. ");
INSERT INTO kfw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Halli thiampu kalian ngaikhan dangkapum kha inleiya inti, “Hiwahi sialdana ah dasik hi eini Dan khan zootmak, ajarchu hiwahi thisenman kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Halli inmani'n in-inbiak ah, khomal ngai phuumnasik ah Beelkaboolpa Lei kha khawa sialla inrachojei. ");
INSERT INTO kfw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Khawa jarra khawa lei kha “Thisen Lei” intia winikatung inlakoi. ");
INSERT INTO kfw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Halli Pathian chongkachoipa Jeremiah ileiril kha huui tungjei: “Israel mi ngai'n inzootna aman dangkapum soomthum kha inmani'n inleijei. ");
INSERT INTO kfw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Halli Pumi'n keidiang chongpeii inape angnga, inmani'n beelkaboolpa lei kha khawa sial kha inneimanna inleirachojei.” ");
INSERT INTO kfw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisu Rome ramwaikaroonpa maikuungnga aleingir, halli ramwaikaroonpa'n amadiang aheirakel, “Nang Jihudi ngai rengpa na-ebe?” Jisu'n amadiang leimasang, “Nang in niti kha ejei.” ");
INSERT INTO kfw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","thiampu kalian ngaili katar ngai'n inrilsepha ama'n iteii khat-um leimasangmak. ");
INSERT INTO kfw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilate in amadiang ati, “Inmani'n nachungnga innarilse ngaihi nang nijet makbe?” ");
INSERT INTO kfw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jisu'n amadiang chongramol inkhat bit um masangmak pha, ramwaikaroonpa kha aleingak theijei. ");
INSERT INTO kfw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Rakaanna Kahoi rakip ah Rome ramwaikaroonpa'n mipui ikadang mikhumna ah inda miring inkhat inmani sik bit ah ileithojol angnga aleimasuopi kachak. ");
INSERT INTO kfw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Khawa phakhan mi rakip in injet mikhumna ah kaom araming Jisu Barabbas inti inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Khawa jarra mipui inintup pha, Pilate in inmani diang aleirakel, kei'n nangni sik ah “Tume ningnaminsuo zoot? Jisu Barabbas be, emakli Messiah inti Jisu khabe?” ");
INSERT INTO kfw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ajarchu Jihudi chuonkaroon ngai'n Jisu hi enzootmu ah amadiang inpe eii ti ama'n aleijet. ");
INSERT INTO kfw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilate in chongtanna munna in-onglai, anumei'n hiwa chong hongtirra ati, “Mikadikpa diang nang iteii khat um thomaro, ajarchu ama jarra kei'n wini zaan karamang khan kaleipoong thei.” ");
INSERT INTO kfw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Takkha thiampu kalian ngai khat-um katar ngai inchu Barabbas kha masuoro halli Jisu kha thatro tiru tia mipui ngaikha inleimasok. ");
INSERT INTO kfw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ramwaikaroon Pilate in amasangnga halli inmani diang ati, hiwa inni ngai karra tume nangnisik ah ningnaminsuo zoot inmani'n inti, “Barabbas!” ");
INSERT INTO kfw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilate in inmani diang ati “Kha e-inchu Messiah inti Jisu hi kei'n angme kathosik?” Inmani rakip in inti, “Ama kha Cross ah thatro!” ");
INSERT INTO kfw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Takkha pilate in ati, angsime, “Ama akathamak ang thomejei?” Takkha ama kha “Cross ah thatru” tia inmani'n kheella inringnga kakheek inhongphut. ");
INSERT INTO kfw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Khanthoa Pilate in iteii anemna ommak ti amuwa, khawa rathuulla mipui senasik eii ti amu pha, ama'n tui leiya mipui maikuungnga akut rasuwa aheiti, “Hiwa mikadikpa thisen jarra kei chu iteii jetmong! nangni lungdou erase!” ");
INSERT INTO kfw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mipui rakip in inhongmasang, “Ama thisen kha keini khat-um kinsa ngai chungnga chulrase!” ");
INSERT INTO kfw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Khawasuo khan ama'n Barabbas kha inmani sikbit ah amasuopi jei, halli Jisu kha ama'n minwuok ah, ama'n Cross ah thatnasik ama kha apejei. ");
INSERT INTO kfw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Khawa phakhan ramwaikaroonpa raalmi ngai khan Jisu kha mipui inchunna waikaroonpa innsuungnga inkeiluut ah raalmi rup rakip in ama koolla in-inchunjei. ");
INSERT INTO kfw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Inmani'n ama puondiar kha inkhaipiya, puonsen kha amadiang inminsiljei. ");
INSERT INTO kfw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Halli inmani'n ralinglukhu inkhat inboolli ama luchungnga inminkhu, achangtiang ramol inkhat inminhumma; halli inmani'n amaikuungnga in-inbok ah amakha in-innuipui, “E Jihudi ngai Reng, kasoot ah ringro!” inmani'n inti. ");
INSERT INTO kfw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Halli inmani'n inmachin thuonna, tuoitung kha inleiya alukhan inleiwuok. ");
INSERT INTO kfw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Halli inmani'n ama kha in-innuipui suopha, puonsen kha inkhaiya, ama puondiar kha inmintho kirra Cross ah thatnasik inruoijei. ");
INSERT INTO kfw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Halli inmani'n inheisuok pha, Simon tia inkoi Cyrene pasal inkhat inlei-intongpui, halli raalmi ngai'n ama kha Jisu cross kha azootmak pumma inleimindom. ");
INSERT INTO kfw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Inmani'n Golgotha inti mun tinachu “Lukiar mun” khan inheiwa pha, ");
INSERT INTO kfw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Inmani'n Jisu diang mathinnamit le inminchel akathur theibomtui insik inleipeii, takkha ama'n amintem pha lei-inpimak. ");
INSERT INTO kfw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Halli ama kha cross ah inmakhai suopha, inmani'n rawaan katha in-enli ama puondiarkha inlei-insem. ");
INSERT INTO kfw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Khawasuo inmani'n khawa munkhan inin-ongnga amakha inleingaak ");
INSERT INTO kfw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ama luchungkhan ama inrilsena inmajia kha inleitar, tichu, “Hiwa Jisu, Jihudi ngai Reng kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Khawa phakhan Jisu le inruoiya inruup inni um, inkhat in changtiang, inkhat in weitiang, cross ah inleimakhai. ");
INSERT INTO kfw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Khawa koolla kasi-kahong mipui ngai'n inlu inkalek ah, kase ah amakha jakna inpeya inti, ");
INSERT INTO kfw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Biak-inn thiatli nithum suungnga kasak nang, natheinuo ah insanro; nang Pathian Sapa na-e-inchu, cross ah inphut jochumro!” ");
INSERT INTO kfw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Khawale in-angrip ah thiampu kalian, Dan ocha khat-um katar ngai inchella in-innuipuiya inti, ");
INSERT INTO kfw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Mileiilak ngaichu ama'n asan; atheinuo achu insanring matormak! ama Israel ngai reng e-inchu; tuun ama'n cross ah inphut juochumrase, halli keini'n ama kha ngamnakinte! ");
INSERT INTO kfw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ama'n Pathian kha angamna ah; Pathian Sa ka-eii inti inchu, tuun Pathian in sanrase; ajarchu ama'n ati, keichu Pathian Sapa ka-eii!” ");
INSERT INTO kfw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jisu le cross ah inmakhaisuom inruup ngai innum khawa ka-ang jakna chongkhan inleirakook. ");
INSERT INTO kfw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Suunchim makheiya phadan inthum katung nuoipilchung pumpui aleiziingjei. ");
INSERT INTO kfw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Halli phadan inthum juochultiang Jisu'n inringtak rasa khan ahongkheek ah, “Eli, Eli, lema sabachthani?” tinachu, “Ka Pathian, Ka Pathian, angsikme nang in keidiangnga inphut khattiang nina inletdel?” ");
INSERT INTO kfw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Khanna kangirra kaom mi lekkhat khawakha injetpha inheiti, “Ama'n Elijah kha akoi!” ");
INSERT INTO kfw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Khawa phatak khan inmani karra inkhat ataanna tuipompuon aleiya, khawakha akathur theibom juchoong khan anoomli, ramol khan kathilla, amadiang insik ah aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Halli lekkhat in inti, ngaakdirui, “Elijah in ama kasansik ajuobe eini enrui!” ");
INSERT INTO kfw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Khawa suonuk Jisu'n woikhat rasa inringnga akheekli, arang chatjei. ");
INSERT INTO kfw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Enru, Biak-inn suungnga induong puonkha achung makheiya anuoi katung lekniya intherjei, nuoipil um innikjei, lungpui um akoijei, ");
INSERT INTO kfw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Thaan ngai um alei-inlongjei, halli Pathian kangamna katamtak aleikathi mi ngai um inhongringjei. ");
INSERT INTO kfw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Halli Jisu'n ahongringsuo nuk thaanna inphut inmani'n inhongsuokli Inthiang Khuopui tiang inluut ah mipui katamtak ngaidiang inlei-inlar. ");
INSERT INTO kfw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Raalmi rajakhat lamkakeipa le inruoiya, Jisu kangaak ngai'n rinook khat-um kasuok ngaikha inmu ah, inchitheiya inheiti, “Inthiangnga amahi Pathian Sapa kha eii!” ");
INSERT INTO kfw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Khawa munkhan numeisa katamkhat in kalaak ah inhei enna inleiom, inmani ngaikha ama sepa inthoa Galileeya inphut Jisu nuk heikajui ngaikha in-eii. ");
INSERT INTO kfw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Inmani ngai karra Mary Magdalene, James li Joseph nu Mary, halli Zebedee numei inlei-inchel. ");
INSERT INTO kfw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kholei aheitung pha, Arimathea makheiya Jisu siamruoi inkhat, araming Joseph intia inkoi, inchong inkhat ahongtung. ");
INSERT INTO kfw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ama'n Pilate koolla asiya Jisu kaluongkha aleini. Halli Pilate in khawakha Joseph diang penasik ah chong aleipejei. ");
INSERT INTO kfw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Khawa jarra Joseph in Jisu kaluong kha aleiya, akathar puonkanemma katuomma, ");
INSERT INTO kfw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","halli ama'n lungpuikha kawit ah amasik bit ah ibool thaan kathar khan aleiphuum; halli ama'n thaan kotkha lungkalok khat ah akharra aleisijei. ");
INSERT INTO kfw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary magdalene khat-um Mary inti khat in thaankha in-enna khawakhan inin-ongnga inleiom. ");
INSERT INTO kfw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ziingnga, tichu Jihudi ngai serni, thiampu kalian halli Pharisee ngai'n Pilate koolla inhong inchunna, ");
INSERT INTO kfw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","inti, “Ocha, maleisei karilpa khan aringlai ‘Kei nithumni kahongringsik eii tia ileiril kha keini'n kinngaidon.’ ");
INSERT INTO kfw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Khawa jarra nithum katungbit thaanhi katha ah ngaaknasik ah chong napepiro, kha emak inchu ama siamruoi ngai'n inhongli akaluong kha hongmaruup inta, amakha thiya inphut ahongringjei, tia mi ngaidiang hongrilcha; halli ma-insa maleisei khaneek ah nuk-intong maleisei khadoom kheella hongthamak acha.” ");
INSERT INTO kfw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Raalpa ruoiru,”Pilate in inmani diang ati, “Siru halli nangni imatortak khan thaankha ngaakru.” ");
INSERT INTO kfw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Khawa jarra inmani'n insiya raalpa ngai khale inruoiya lungkha madanna indeengnga, thaankha katha ah inminngaakjei. ");
INSERT INTO kfw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jihudi ngai sernikhuo ahekli, hakta ma-insa khoserni ziingtiang khuowarli, Mary Magdalene khat-um Mary khat khawakhan thaan ka-en inleisi. ");
INSERT INTO kfw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jetlei theileiya rinook kangartak aleihong; halli Pumi tirton kha marwaanna inphut ajuochumma, lungkha amalet ah, achung khan alei in-ong. ");
INSERT INTO kfw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ama meelsuo kha kool-inlek alei-ang, halli ama puondiar ngaikha kawur angnga aleichek; ");
INSERT INTO kfw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","akangaak raalpa ngaikha inleichi theiya inlei-intuul, halli akathi mi kha in-ang jei. ");
INSERT INTO kfw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Marwaan tirton khan numeisa ngai diang aleiti. “Nangni chimaru,” “Ajarchu cross ah inthat Jisu kha nangni'n ning-entok ti Kei'n kajet. ");
INSERT INTO kfw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ama hin ommakjei; ajarchu ama ileiril angnga ama aringjei. Hongru halli hong-enru, ama leizaalna munkha. ");
INSERT INTO kfw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Innoot ah si-inlang, halli ama siamruoi ngaidiang juomindikru, ‘Amachu thiya inphut aringjei; khat-um enru, nangni matiang ama Galileeya asijei, khawakhan nangni'n ama jomuningte!’ ngaidonru angme kei-inarilpi hi.” ");
INSERT INTO kfw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Halli inmani'n kachi khat-um karokle inruoiya thaan kha inmathaanna innot ah, asiamruoi ngaidiang kamindiksik intaanjei. ");
INSERT INTO kfw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Enru, jetleitheileiya Jisu'n inmani intongpuiya ati, “Rawaan katha eru.” Halli inmani'n inheinaiya akeii khan inma-ouwa amakha chubei inthojei. ");
INSERT INTO kfw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisu'n inmani diang ati, “Chimaru,” “Siru, kei ka-u kanai ngaikha Galileeya sinasik rilpiru, halli inmani'n khawakhan kei namu inte.” ");
INSERT INTO kfw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Numeisa ngaikhan inlamma insi lai, enru, thaan kangaak raalmi lekkhat in khuopui khan inkirra, akasuok rakip kha thiampu kalian ngaidiang inleirilpi jei. ");
INSERT INTO kfw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Halli katar ngai'n thiampu kalian ngaile inmuwa halli inmani chong inlei-insiamma, raalmi ngaidiang inmani'n sial katamma inleipe ah ");
INSERT INTO kfw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","manidiang inti, “Nangni'n tiru, keini'n zaanna kinzaal rathil ‘Ama siamruoi ngai'n inhongnga, akaluongkha inmaruupjei. ");
INSERT INTO kfw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Halli hiwahi ramkaroonpa kuor tung-inchu, keini'n ama matheem kinta, halli nangni iteii naminpoong nunung.” ");
INSERT INTO kfw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Khan inthoa akangaak raalmi ngai'n sial kha inlei li inmani diang inminchu angnga inthojei; halli hiwa thurchi hi winikatung Jihudi ngai karra inlaril. ");
INSERT INTO kfw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Siamruoi soomleikhat ngaikhan Galileeya Jisu'n ileirilpi chingkatung inleisijei. ");
INSERT INTO kfw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Halli inmani'n ama kha inmupha chubei inhongtho; takkha lekkhat inchu inlei-inngamsamna. ");
INSERT INTO kfw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Halli Jisu'n aheinaiya inmani diang ati, “Marwaan khat-um nuoipil chungnga kaom ranak rakip kei diang anapejei. ");
INSERT INTO kfw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Khawa jarra nangni'n si-inlang, zaat rakip ngaikha siamruoi juoboolru; inmani kha Apa, Asa khat-um Ratha Inthiang ramingnga baptize thoru, ");
INSERT INTO kfw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","halli kei'n kinape chongpeii rakip juinasik ah inmani kha minchuru; halli, enru, manmasituol ahekkatung kei'n nangni kana-inruoipui chaksik eii.”");
INSERT INTO kfw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Hiwahi Pathian Sapa Jisu Christa jarra chongkahoi ngaikha eii. ");
INSERT INTO kfw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pathian chongkachoipa Isaiah larik-ah imajia angnga: “Pathian aleiti ‘Kei'n nang ma-ah kachongkachoi inkhat kajuotirsik eii ama'n nang sik-ah lam aboolsik eii.’ ");
INSERT INTO kfw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Neelramma kheek rasa inkhat khachu, ‘Pumi sik-ah lamkha booltaru; Ama lamkha mintuunru.’ ” ");
INSERT INTO kfw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Khawa jarra John in neelramma aheisuok-ah, baptize ithole inruoiya Pathian chong aleiril. “Ningmanu-ah inphut heikir inlang baptize thoru” halli “Ningmanu rakip Pathian in anara-ngaidam pisik eii,” Ama'n mipuidiang aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","John chongril kara-ngai sik-ah Jerusalem khuopui khat-um Judea ramsuungnga kaom mipui katamtak inheisuok. Inmani'n inmanu ngai inrilsuok halli ama'n Jordan tuidung suungnga inmani ngaikha baptize aleimintho. ");
INSERT INTO kfw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John in salaileem mulla inbool puondiar aleitho, akhoongnga sawun koongkhit aleikhit, ama bak-inchu khai khat-um ramkhuoining alei eii. ");
INSERT INTO kfw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ama'n mipuidiang aleirilla ati, “Kei kanuk-ah akajuosik miringpa khachu kei neek-ah akaloksik eii. Keichu ama kekokrui kuunli kasuutsik kha-um rahoi suokmong ");
INSERT INTO kfw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kei'n tuiya baptize kanatho, takkha ama inchu Ratha Inthiangnga baptize anathosik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Khawasuoli sootlekleiya Jisu'n Galilee ramsuungnga kaom Nazareth khuopui makheiya inphut aheiwa halli John in Jordan tuidung suungnga baptize aleitho. ");
INSERT INTO kfw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisu'n tuiya inphut hongsuokli, Ama'n marwaan suongkot inlong khat-um Ratha in achungnga Wathu angnga ijuochum kha aleimu. ");
INSERT INTO kfw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Khat-um marwaanna inphut rasa inkhat ajuoa, “Nanghi kinaminriang tak kasapa kha na-eii. Nachungnga kamalung atai.” ");
INSERT INTO kfw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Khawasuoli Ratha'n ama kha neelramma aleiruoi. ");
INSERT INTO kfw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Khawa munkhan nisoommili, Seitan in aleimatheem. Ramsa ngaile khawa khan inleiom, takkha marwaan tirton ngai'n ama sanna inleinei. ");
INSERT INTO kfw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John mikhumna suungnga indasuonuk, Jisu'n Galileeya asiya halli Pathian diangnga kajuo chongkahoi ngaikha aleiril. ");
INSERT INTO kfw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Apha kha ajuotungjei,” “Khat-um Pathian Rengram kha anaijei! Ningmanu-ah inphut malung thuul inlang chongkahoihi ngamnaru,” ama'n aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisu'n Galilee tuidiilpang ajuiya aheisuokli, ama'n ngakasur miring inni, Simon khat-um anai Andrew, leenna nga insur aleimu. ");
INSERT INTO kfw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisu'n inmani diang aleiti, “Heiwaru kanuk najuiru, mi kasur namin-ekate.” ");
INSERT INTO kfw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Khawapha takkhan inleen inda-ah inmani ngaikha amale inruoiya inleisi. ");
INSERT INTO kfw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ama'n asidetli unai inni, Zebedee sangai, James li John aleimu. Inmani'n rakuongnga inleen ngaikha worthanasik inleibool. ");
INSERT INTO kfw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisu'n inmani amuli amumak, inmani aleikoi; khawa khan inmani'n inloom ruoingai khat-um inpa Zebedee kha rakuong suungnga inda-ah Jisu nukkha inleijui. ");
INSERT INTO kfw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisu le asiamruoi ngai'n Capernaum khuopuiya inheiwa, halli Jisu'n akahong Jihudi ngai sernikhuo khan Synagogue-ah asiya aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ama minchuna kha akajet mipui rakip in inleingak, ajarchu ama kha Dan Karu ngaile lei-in-angmak, khawa rathuulla, Ama'n thomatornale inruoiya aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Khawapha takkhan ratha kathamak kaluut miringkhat Synagogue-ah aheiluut halli rasa inringnga aleikheek. ");
INSERT INTO kfw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Angme keini diangnga nimanuom, Nazareth Jisu? Keini kanaminmangsik hin nijuobe? Kei'n nang kanajet, nangchu inthiang Pathian tirton kha na-eii!” ");
INSERT INTO kfw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisu'n ratha diang chong aleipeii, “Omchianro, halli mipa diangnga inphut heisuokro!” ");
INSERT INTO kfw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ratha kathamak khan mipa kha kanatak-ah aleikanik, halli inringnga akheek-ah mipa diangnga inphut aheisuokjei. ");
INSERT INTO kfw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mipui ngaikhan inleingak, khawakhan inmani inkhatli inkhat in inleiti, “Hiwahi angmejei? Chongminchu kathar khabe? Hiwa mipa'n ranak kanei tak-ah ratha kathamak diang chong apeii, halli inmani'n achong injui!” ");
INSERT INTO kfw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Hinthoa, Jisu chongngaihi innot tak-ah Galilee rampumpuiya alei-inthang. ");
INSERT INTO kfw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisu khat-um asiamruoi ngai'n James khat-um John le inruoiya, Synagogue inmathaanna Simon li Andrew ngai inntiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon tarpi kha ritun in athoa zaalmunna aleizaal, Jisu aheitungli, akananu jarra ama diang inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ama'n akananu diang asiya, akut-ah numeisanu kha aleikatook-ah aleikeithei. Ritun in ama kha amathaanjei, halli numeisanu khan inmani sepa aleitho. ");
INSERT INTO kfw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kani tasuo kholei phakhan, mipui ngai'n akana khat-um raikhuo kaluut rakip ngaikha Jisu diang inheiruoi. ");
INSERT INTO kfw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Khawa khuopuiya kaom mipui ngaikha khawa inn makhan inlei-inchun. ");
INSERT INTO kfw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisu'n rirai rakip-ah kana katamtak ngaikha aleimindam khat-um raikhuo katamtak aleipuutsuok. Raikhuo ngai'n ama kha tume ti inleijet, khawa jarra Ama'n inmani ngaikha iteii leiminrilmak. ");
INSERT INTO kfw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ziingtiang kani suokma-ah, Jisu'n intheiya inn kha amathaanjei. Khuopui kha amathaanna mirasa neimakna munkhattiang aleisi, khawa munkhan ama'n Pathian aleini. ");
INSERT INTO kfw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Takkha Simon khat-um asappui ngai'n insuok-ah ama kha inleiratok, ");
INSERT INTO kfw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","halli inmani'n ama injuomu phakhan, inti, “Mirakip in nangkha innaratok.” ");
INSERT INTO kfw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Takkha Jisu'n aleimasang, “Hiwa hinna inphut eini'n khuo inkhattiang nisisik eii. Inmani diang-um kei chong kalarilsik eii, ajarchu khawa sik-ah kei kijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Khawa jarra ama'n Galilee rampumpui suungnga aleisi, Synagogue-ah chong aleiril halli raikhuo ngai aleipuutsuok. ");
INSERT INTO kfw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Akaphar miring inkhat in Jisu diang ahongnga, kemurkhup thep-ah, halli nasanro tia nina aleinei. “Nang in nazoot inchu,” “Kei namindamro,” ama'n aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisu diang minriang kha aleisip, halli “Kei'n kanamindam zoot,” tia aleimasang, “Kadam kha etaro” tia akut aduongnga aleikatook! ");
INSERT INTO kfw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Khawapha takkhan akaphar kha ama diangnga inphut asuok-ah halli ama kanakha adamjei. ");
INSERT INTO kfw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Khawa makheiya Jisu'n chong ka-ngar kha ama diang arilla ama kha aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Rangairo, hiwa jarhi tu inkhat diang-um rilpimaro, takkha si-inlang Thiampu diang nang juo-inmuro; khawa khan mirakip in nangkha nadamjei ti innajet nasik-ah, Moses chongpeii dungjuiya inmani diang pesik kasuok phurpeii kha juo inpero,” tia ama kha aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Takkha ama'n asuok-ah amun rakip-ah akasuok chongngai kha aleirilsuok. Inthiangnga, Jisu jarra ama'n chongkatamtak aleiril jarra Jisu'n mipui omna khuopui khan leisuok matormakjei. Khawa rathuulla ama'n mirasa neimakna mun ngaikhan aleiom, khat-um amun rakip-ah kaom mipui ngai'n ama koolla inheiwa. ");
INSERT INTO kfw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nikhuo lekkhat suoa Jisu'n Capernaum tiang aleikirnook, khat-um innkhan ama omjei iti chong alei-inthang. ");
INSERT INTO kfw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Khawa jarra mipui katamtak ngaikha inheiwa-ah khawakhan tungnasik mun karuok leiommak, suongkotkuung kha-um leiruokmak, halli Jisu'n inmani diang Pathian chongkha aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Miring mili khat-in Jisu diang apang kathi mi inkhat inhongruoi pha, ");
INSERT INTO kfw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","mipui ngaikhan ajar-eya, miring pakha ama koolla heiluutpui matormu, khawa jarra inmani'n Jisu omnachei chungkhum inphongnga, mipakha azaalna pherle inruoiya injuomachum. ");
INSERT INTO kfw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Inmani ngamna amupha, Jisu'n apang kathi mipa diang aleiti, “Kasapa, namanu ngaikha kanarangaidam suojei.” ");
INSERT INTO kfw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dan Karu lekkhat in khawa khan inlei in-ongnga inmalungnga inleingaidon, ");
INSERT INTO kfw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ama'n angsik-ah hinna itime? Hiwa hichu Pathian chungnga irilse eii! Pathian amabit eii manu rakip kangaidam matorchu!” ");
INSERT INTO kfw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisu'n inmani malung ngaidon ajet-ah, inmani diang aleiti, “Angsikme khawa ka-angngai ningngaidon? ");
INSERT INTO kfw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Apang kathi mipa diang, ‘namanu ngai kanarangaidam pijei,’ ti emakli, inthei inlang, napher ruut inlang siro tihi hume kabei? ");
INSERT INTO kfw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kei'n nangni diang narilcheenpi kate, khachu, Miring Sapa'n nuoipil chungnga manu rakip ka-ngaidam sik ranak anei.” Khawa jarra apang kathipa diang ati, ");
INSERT INTO kfw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kei'n nangdiang kati, intheiro, napher ruut inlang, na-inna sitro!” ");
INSERT INTO kfw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Inmani'n in-enna inomlaitak, mipakha intheiya, apher kha aruut-ah innot-ah aleisuok, halli inmani rakip in inleingak-ah Pathian inminpaak-ah, “Hiwa ka-ang ngaihi suplamu lamumakmi inleiti!” ");
INSERT INTO kfw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisu'n woikhat Galilee tuidiil pangtiang ahongkir nookpha, mipui katamtak amadiang inheiwa, halli ama'n inmani kha aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ama'n asina lamma, rampar kakhoom, Alphaeus sapa Levi, ama rampar teelna munna in-ongkha aleimu. Jisu'n amadiang, “Kanuk najuiro,” aleiti. Halli Levi'n intheiya anuk aleijui. ");
INSERT INTO kfw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Khawasuoa Jisu'n Levi inna bu aleibak. Rampar kakhoom katamtak ngaile, manukaroon ngai'n Jisu nuk inleijui, hanna inmani katam khatchu Jisu li asiamruoi ngai bubakna khan inlei-inchel. ");
INSERT INTO kfw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pharisee um ka-eii Dan Karu lekkhat in, manukaroon khat-um rampar kakhoom ngaile Jisu'n ibak suomkha inleimu, khawa jarra ama siamruoi ngaidiang inmani'n inleirakel, “Angsikme ama'n hiwa mi ngaile ibak suomhi?” ");
INSERT INTO kfw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisu'n hiwa ajet-ah inmani diang aleimasang, “Tu ka-ang akadam ngaisikchu kathiam rangaimak, takkha akana mi sikchu arangai. Kei'n kijuo hichu akadik mi ngai kakoi kijuo emong, takkha manukaroon ngai kakoi kijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","John Baptist nukkajui ngaili pharisee ngai'n bu-ngei nikhuo khan bu inleingei. Mi lekkhat in Jisu diang inhongnga inhongrakel, “Angtia John Baptist siamruoi ngaili Pharisee siamruoi ngai'n bu inngeili, nasiamruoi ngaichu inngeimak?” ");
INSERT INTO kfw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisu'n aleimasang, “Moiruoina munna Moipa omlaiseng asap ngaikha bak-in inngeiya inomsik eii tia ningngaidonbe? khawakha emak! moipa inmanile omlaiseng chu, bak-in leiya omnunu. ");
INSERT INTO kfw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Takkha moipa kha inmani diangnga inphut inlaruoi nasik nikhuo alajuosik eii, khawa phakhan inmani bu inla-ngeisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tu inkhatbit innum puon katharkha neiman inlang puonmaruo chungnga phoudelmu, ajarchu akathar inphoukhan amaruokha kheella keiriinta achetna ahonglokpui detsik eii. ");
INSERT INTO kfw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tu innum theibomju kathar kha sawuntuong maruo ngaikhan thunngaimu, ajarchu amaruo sawuntuong khan theibomju kha aminmang, khat-um sawuntuongli theibomju inniya inmangsuomsik eii. Khawa rathuulla, theibomju kathar kha akathar sawuntuongnga inthunsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jihudi ngai Sernikhuo khan Jisu'n gehu billa aleisi. Asiamruoi ngai'n amale inheiwa phakhan, gehu wuuikha inleichin. ");
INSERT INTO kfw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Khawa jarra Pharisee ngai'n Jisu diang inleiti, “Enro, Sernikhuoni nasiamruoi ngai ithohi eini Sinadan izootmak ngaikha eii.” ");
INSERT INTO kfw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisu'n aleimasang, “David khat-um ama mi ngai'n inwon champha, ama'n baksik ommakpha angme ileitho nangni lateel makchube? ");
INSERT INTO kfw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ama'n Pathian inna aluut-ah halli Pathian diangnga inpe waipool kha aleibak. Hiwahi Abiathar in Thiampu Kaliankhet achanglai khan aleisuok. Eini Sinadan dungjuiya chu Thiampu ngai bit-in ibakngaikha David in aleibak, halli ama mi ngaidiang-um aleipeii.” ");
INSERT INTO kfw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Halli Jisu'n ahekna-ah ati, “Sernikhuo hichu miringngai thanasik-ah inbool eii; Sernikhuo sik-ah miring ngaihi inbool emak. ");
INSERT INTO kfw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Khawa jarra miring sapa hi Sernikhuo Pumi kha-um eii.” ");
INSERT INTO kfw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Khawasuo Jisu'n Synagogue-ah aleikirnook, khawakhan akut kathi miring inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jisu diang noonnasik ithosial ombe tia athang suonasik kamanuom mi lekkhat khawakhan in-enna inleiom; khawa jarra inmani'n Sernikhuo khan ama'n miring pakha amindambe tia katha-ah inlei-ensui. ");
INSERT INTO kfw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisu'n kanapa diang aleiti, “Matianghin hongkalro.” ");
INSERT INTO kfw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Halli Ama'n inmani diang aleirakel, “Sernikhuo khan eini Sinadan in ang thocha atime? sansik emakli minmang sikbe? Tu ka-ang khat ringkhuo sansik emakli minmangsik hibe?” Takkha inmani'n iteii leirilmu. ");
INSERT INTO kfw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisu'n amit kalek-ah inmani diang alei-enna aleiraang, inmani malung kangar khat-um inthamak jarra aleipoongpui. Khawasuoli ama'n mipa diangkhan aleiti, “Nakut keisuoro.” Ama'n akut aheikeisuo, halli akutkha aleidam. ");
INSERT INTO kfw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Khawasuo Pharisee ngai'n Synagogue inmathaanna inleisi; halli Herod mi ngaile innot-ah in-inmuwa, inmani'n Jisu thatnasik chuon inleiminsuuk. ");
INSERT INTO kfw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisu'n asiamruoi ngaile Galilee tuidiiltiang inleisi, Galileeya inphut mipui katamtak in anuk inleijui, ");
INSERT INTO kfw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judea ramma, Jerusalemma, Idumea ramma, Jordan raaltiangnga kaom ram, khat-um Tyre le Sidon rampumpuiya mi katamtak in Jisu itho ngaikha injet-ah amadiang inheiwa. ");
INSERT INTO kfw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mipui intamhei jarra ama in-uum maknasik Jisu'n asiamruoi ngaidiang rakuong inkhat amasik minteiru aleitipi. Jisu sik asiamruoi ngai'n rakuong inleimintei. ");
INSERT INTO kfw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ama'n mi katamtak aleimindam, khat-um akana rakip in ama katooknasik ama omnatiang inlei-inneng. ");
INSERT INTO kfw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ratha kathamak kanei mirakip in ama inmu phakhan, inmani'n amaikuungnga inleipur khat-um inringnga inleikheek, “Nangchu Pathian Sapa kha na-eii!” ");
INSERT INTO kfw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jisu'n ratha kathamak ipuutpi inmani ngaidiang ama tutakme tihi tu inkhatdiang tipimaru tia chong kanatak aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisu'n ching inkhat akalla halli ama'n imanuom mi ngaikha aleikoi. Inmani'n amadiang inheiwa, ");
INSERT INTO kfw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","han ama'n soomleini ngaikha amale inruoisik khat-um chongkaril sik-ah aleikadangnga “Tirton tia aleikoi, ");
INSERT INTO kfw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","khat-um raikhuo ngai puutsuok nasik ranak aleipeii.” ");
INSERT INTO kfw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hiwa senghi ikadang soomleini ngaikha in-eii: Simon (Peter tia Jisu'n araming aphuo); ");
INSERT INTO kfw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James li anai John, Zebedee sangai (Jisu'n Boanerges tia araming aleiphuo, hiwa tinachu “Ruokinri sapa ngai” tina eii); ");
INSERT INTO kfw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, Alphaeus sapa James, Thaddaeus, Simon Patriot, ");
INSERT INTO kfw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Halli Judas Iscariot, Jisu kajuorpa, hiwa ngaihi in-eii. ");
INSERT INTO kfw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Khawa suoli Jisu'n inntiang aleikir. Woikhat-um khawa ka-ang akatam mipui inchun nook-ah Jisu khat-um asiamruoi ngaikha bubaknasik pha leimumu. ");
INSERT INTO kfw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ama insuung mi ngai'n hiwachong injetpha, inmani'n amakha ruoinasik inleitho, ajarchu inmani'n inleiti, “Amahi inweetjei!” ");
INSERT INTO kfw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalem tiangnga kahong Dan Karu lekkhat ngai'n, “Ama suungnga Beelzebul om! raikhuo ngai lamkakeipa khan amadiang ranak apeya halli inmani iminpuutsuok eii,” inleiti. ");
INSERT INTO kfw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Khawa jarra Jisu'n inmani ngaikha akoolla koiya, inmani diang chongminkhi ngaikha aleirilpi: “Angtho thoa Seitan in Seitan apuutsuok sikme? ");
INSERT INTO kfw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Rengram inkhat in inthenkhoiya rupni insuok inchu inkhatli inkhat insuol inta, khawa rengram kha akoisik eii. ");
INSERT INTO kfw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Insuungkhur inkhat inthenkhoiya rupni insuok inchu inkhatli inkhat insuol inta, khawa insuungkhur kha akoisik eii. ");
INSERT INTO kfw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Khawa jarra Seitan rengram hi rupni suok ah inthenkhoi inchu, khawa kha sootnuni, takkha alek alek-ah koita amang wiaksik eii. ");
INSERT INTO kfw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tu inkhat innum aka-ngar mipa kha akhitmasa-ah adamak inchu, a-inn luut-ah aneinaak rakip kha leimator nuni. ");
INSERT INTO kfw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Inthiangnga kei'n nangni diang kitihi eii, khachu mi ngai manu rakip khat-um inrilse angjet leiom innum angaidam pisik eii. ");
INSERT INTO kfw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Takkha tu e-innum Ratha Inthiang chungnga karilse ngaikha angtikniteii ngaidam pinuni, ajarchu ama'n hektik kaboi manu kha athojei.” ");
INSERT INTO kfw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Ama suungnga ratha kathamak kha aom” mi lekkhat in inti jarra, Jisu'n hiwahi aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Khawa suoli Jisu anu le anai ngai inhongtung jei. Inmani'n inntuolla inngirra amadiang chong inminsiya ama inleikoi. ");
INSERT INTO kfw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jisu koolla mipui katamtak inlei in-ong, halli inmani'n ama diang inleiti, “Enro, nanu le na-u nanai, nasar ngai'n tuolla nang inna inmupuizoot-ah inom.” ");
INSERT INTO kfw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisu'n aleimasang, “Tume kei kanu? Tume kei ka-u kanai ngai?” ");
INSERT INTO kfw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ama koolla in-ong mipui ngaikha ahei-enna aleiti, “Enru! Hinna kaom ngaihi kei kanu khat-um kei ka-u kanai ngaikha in eii! ");
INSERT INTO kfw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tu e-innum Pathian lungdou katho ngaikha ka-u kanai, kanu khat-um kasar ngaikha in eii.” ");
INSERT INTO kfw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Inlet-ah Jisu'n Galilee tuidiil khamma minchuna aleiphut. Ama koolla hong-inchun mipui ngaikha inleitam, khawa jarra ama'n rakuong inkhat suungnga aluut-ah alei in-ong. Rakuong kha tuikhamma aleiom, khale inruoiya mipui ngai-um tuikham khan inleingir. ");
INSERT INTO kfw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ama'n chongminkhi katamtak aneimanna inmani ngaikha aleiminchu, halli inmani diang aleiti: ");
INSERT INTO kfw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Rangairu! miring inkhat in muchiru kaworsik aheisuokjei. ");
INSERT INTO kfw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ama'n leiya muchiru kha aheiwor pha, lekkhat in lamkoolla achul, halli wa ngai'n inheiwa-ah inruut. ");
INSERT INTO kfw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Muchiru lekkhat in neipil toomna lungbil khan inchul. Muchiru kha innot-ah ahongmoong, ajarchu neipil kha lei-inthuukmak. ");
INSERT INTO kfw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Halli kani ahongsuok pha, akadoong muchichiak ngaikha injuo charjei; ajarchu inrajung kha inthuuk-ah leisi matormak, muchichiak ngaikha innot-ah inleichar. ");
INSERT INTO kfw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Muchiru lekkhat in raling karra inchul, inhongmoong takkha raling in aleidiip, halli inmani leikaramu. ");
INSERT INTO kfw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Takkha muchiru lekkhatchu neipil hoina-ah inleichul, khat-um achiakngai khan inhongkek, inhong-insoon, khat-um inhongkara: lekkhat in soomthum, soomruk halli lekkhat in rajakhat inhongkara.” ");
INSERT INTO kfw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Halli Jisu'n ahekna-ah aleiti, “Akuor indou rakip in hiwahi rangairu!” ");
INSERT INTO kfw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jisu'n atheinuoa aompha, ama siamruoi soomleini ngaile inruoiya ama jarra kajet ngai'n akoolla inheiwa halli chongminkhi ngaikha incheenna rilcheen nasik amadiang inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“Nangni diangchu Pathian Rengram jarra inthup rakip jetnasik kha anapejei,” tia Jisu'n aleimasang. “Takkha tu ka-ang tuolla kaom lekkhat ngaisikchu, chongminkhi hinna hiwa rakip ngaihi injetsik eii, ");
INSERT INTO kfw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Khawa jarra, ‘Inmani'n enchu en-inte, Takkha mununu; inmani'n rangaichu rangai inte, Takkha jetnunu. Kha intho innum, inmani Pathian diang inkir nooksik eii, halli ama'n inmani ngaikha arangaidamsik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Halli Jisu'n inmani diang aleirakel, “Nangni'n hiwa chongminkhi hi jetmakchube? Kha e-inle, nangni'n chongminkhi rakip ngaihi angtho tholi ningjet sikme? ");
INSERT INTO kfw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Muchi kaworpa khan Pathian chongkha awor. ");
INSERT INTO kfw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Miring lekkhat khachu lamsirra kachul muchi ngaikhale in-ang; inmani'n khawa chongkha injetli injetmak, Seitan khan aheiwali achoideljei. ");
INSERT INTO kfw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Miring lekkhat ngai'n lungkarra akata muchi khale in-ang. Inmani'n khawa chongkha injetli injetmak, karok tak-ah inleikeiluut. ");
INSERT INTO kfw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Takkha inmani inrajung inthuuk-ah leisimu, khat-um inmani soot leideimatormu. Khawa chongkhan ajar-eya, poongraalna aheiwapha khanchu, inmani'n innot-ah mangna innei. ");
INSERT INTO kfw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Miring lekkhat ngaikhan raling karra kachul muchi khale in-ang. Inmani ngaihi chong kajetjei ngaikha in-eii, ");
INSERT INTO kfw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Takkha hiwa ringkhuo poongna ngai, inchong kamanuom, khat-um aleiilaak manuomna rakip ngaikhan, khawa chongkha inminmang, khawa jarra inmani karamu. ");
INSERT INTO kfw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Takkha miring lekkhat khachu neipil hoina munna inwor muchi khale in-ang. Inmani'n chongkha inrangai, inkeiluut, lekkhat in soomthum, soomruk, halli lekkhat in rajakhat inkara.” ");
INSERT INTO kfw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisu'n aminchudel nook-ah, “Tu inkhat innum meiser heichoiya halli kok nuoiya emakli zaalmun nuoiya inda ngaiyabe? meiser kechungnga inda-ngai emak abe? ");
INSERT INTO kfw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lei inthup ngaikha lahong inlarsik eii, halli lei inkhu rakip ngaikha ala inlongsik eii. ");
INSERT INTO kfw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Akuor indou rakip in hiwahi rangairu!” ");
INSERT INTO kfw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ama'n inmani diang aleiti, “Nangni'n ningjet ngaikhan insingtheiru. Nangni'n mi ngai chungnga chong ningtan angnga nangni diang-um Pathian in atansik eii, kheella atansik eii. ");
INSERT INTO kfw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ajarchu akanei amadiang kheella apesik eii, han kaneimak amadiang ama inei lekteii kha-um aleidelsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisu'n aleiril, “Pathian Rengram khachu, miring inkhat in aleiya muchiru iwor khale in-ang. ");
INSERT INTO kfw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ama'n zaanna azaal, suun eli inthei, halli khawa rathil muchiru ngaikhan inhongkek-ah inhongmoong. Hiwahi angtho tholi kasuokme iti ama'n leijetmak. ");
INSERT INTO kfw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Neipil khan muchi chiak ngaikha minmoong halli inhongkara; mansakhet-ah inziik inhongsuok, halli inbor, ahekna-ah sawuui katha kha inkara. ");
INSERT INTO kfw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sawuui kha aminpha, mipa khan kooiteiiya saang karakhool aleiphut, ajarchu leirakhool phakha aheitungjei. ");
INSERT INTO kfw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","“Pathian Rengram hi angleme in-ang nitisik?” Jisu'n aleirakel. “Angkachang chongminkhi nineimanli nirilcheen sikme? ");
INSERT INTO kfw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Khawa khachu, miring inkhat in manmasituolla, akasinkhet anchamru achoiya, neipilla iwor khale in-ang. ");
INSERT INTO kfw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Apha lekkhat eli ahongmoong khat-um thingkuung ngai karra akalokkhet ahong eii. Khat-um abaak kalok ngai ahongsuok ah khawa ralikhan wa ngai'n inrabu inleiphan.” ");
INSERT INTO kfw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisu'n ama chongkha mi ngaidiang aleiril, hiwa ka-ang chongminkhi katamtak ngaihi aneimanna; ama'n inmani diang injetmatorseng aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ama'n chongminkhi inchellekleiya inmani diang iteii inkhat-um leirilpimak, takkha ama asiamruoi ngaile inom phakhan, ama'n incheenna angrakip ngaikha inmani diang aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Khawa nitak kholeitiang khan Jisu'n asiamruoi ngaidiang aleiti, “Eini tuidiil raalkhattiang khan rakaan inlang sirui.” ");
INSERT INTO kfw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Khawa jarra inmani'n mipui ngaikha inda-ah; asiamruoi ngai'n Jisu alei in-ongna rakuong khan inluut-ah, inmani'n ama kha inleiruoi. Rakuong lekkhat-um khawa munkhan inleiom. ");
INSERT INTO kfw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jetlei theileiya thipui kangar inkhat ahongraangnga, tuiphuksaan khan rakuong pangkha hongzeemma tuikaluut aleiphut, rakuong kha tui'n hongsipsik aleitho. ");
INSERT INTO kfw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisu'n rakuong nuktiang khan, luthun aneiya aleizaal. Asiamruoi ngai'n ama inkeitheiya inleiti, “Karu, keini kathisik kin-ejei, keini sik-ah nang ngaidon makchebe?” ");
INSERT INTO kfw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisu'n angirra thipui diangkhan chong aleipeii, “Omchianro!” halli ama'n tuiphuksaan diangkhan aleiti, “Daitaro!” Thipui kha ajuodai, halli khawakhan thipuikha ajuodaijei. ");
INSERT INTO kfw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Halli Jisu'n asiamruoi ngaidiang aleiti, “Angsik-ah nangni'n ningchime? Tuunkatung nangni ngamna laneimak chube?” ");
INSERT INTO kfw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Takkha kachi khan inmani diang asip-ah inkhatli inkhat diang inlei-inti, “Hiwa miring hi tume? thipui khat-um tuiphuksaan innum achong injuihi!” ");
INSERT INTO kfw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisu le asiamruoi ngai'n Gerasene ramsuungnga kaom, Galilee tuidiilpang khattiang inhongtung phakhan, ");
INSERT INTO kfw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisu'n rakuongnga inphut ajuochumli chummak thaan billa inphut aheikasuok miring inkhat alei-intongpui. Hiwa miringpa suungnga ratha kathamak kha aleiom ");
INSERT INTO kfw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","khat-um thaanbilla aleiom. Tu inkhat innum amahi woini kahuuiya thirruiya khit-ah damatormu; ");
INSERT INTO kfw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Akutli akeii ngaihi inleikhit, takkha inleikhit racham thirrui kha aleimachat halli thirkha akeiiya aleitouthaak. Tu inkhat innum innuoiya leidamatormu ajarchu ama ranak ngar. ");
INSERT INTO kfw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ama'n suunli zaan boiya thaanbil kha akuoitong halli chingnga aleiloon, akheek-ah atheinuo-ah lungnga alei-insukchat. ");
INSERT INTO kfw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ama'n Jisu kha kalaak-ah aleimu; halli ama'n aheitanna, Jisu maikuungnga kemurkhup thep-ah chubei ajuotho, ");
INSERT INTO kfw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","halli rasa inringnga akheek-ah aleiti, “Jisu, Insaangkhet Pathian Sapa! Angme keidiang nimanuom? Kei'n Pathian ramingnga kanani, kei naminpoong maro!” ");
INSERT INTO kfw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ama'n hiwahi aleiti ajarchu Jisu'n aleiti, “Ratha kathamak, hiwa mipa diangnga inphut heisuokro!” ");
INSERT INTO kfw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Khawa jarra Jisu'n amadiang aleirakel, “Naraming ang intime?” Mipa khan aleimasang, “Kei karaming chu ‘akatam inti’ ajarchu keini kintam!” ");
INSERT INTO kfw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Halli ama'n Jisu diang ratha kathamak ngaihi khawa ramma inphut napuutpi maro tia inlet inlet-ah aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Khawakhan wok rahooi yam chingthut khan inbak-ah inleiom. ");
INSERT INTO kfw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Khawa jarra ratha ngaikhan Jisu diang inleiti, “Wok ngaidiang khan natirru, halli keini'n inmani suungnga luutkinte.” ");
INSERT INTO kfw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ama'n inmani ngaikha aleiminsi, halli mipa diangnga inphut ratha kathamak ngaikha insuok-ah wokngai suungnga inleiluut. Wok rahooi sengkha Wok lising inni in-eii, inraya-ah suktaaktiang sumpalingkhang intho-ah khat-um tuidiil khan inta-ah inleithi. ");
INSERT INTO kfw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wok kakhaal ngaikhan intaanna halli khuopuiya khat-um khuo khuo-ah kaom mi ngaidiang chong ngaihi injuorilpi. Mipui ngaikhan akasuok omchan kha ka-ensik inheiwa. ");
INSERT INTO kfw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Khat-um Jisu diang inmani'n inheiwa phakhan, inmani'n raikhuo katam kaluutpa kha, puondiar thoa malungron katha roonna; in-ongnga ileiom kha inleimu, halli inmani rakip in amakha inleichi. ");
INSERT INTO kfw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Raikhuo kaluutpa khat-um wok ngaidiang aleikasuok rakip kamu ngai'n mipui diangkhan inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Khawa suoli inmani'n Jisu diang inmani ramkha mathaan inlang sitro inleiti. ");
INSERT INTO kfw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisu'n rakuong suungnga aluut phakhan, raikhuo kaluut miringpa'n ama diang aleini, “Kei-um nangle sisuomkate!” ");
INSERT INTO kfw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Takkha Jisu'n leizootpimak. Khawa rathuulla, amadiang aleiti, “Nang inntiang kir-inlang na-innsuung mi ngaidiang angtuk-ah Pumi Pathian in nang sik-ah inathopi khat-um inaminriang kha rilpiro.” ");
INSERT INTO kfw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Khawa jarra ama'n khawa munkha amathaanna Khuopui Soom inti ram (Decapolis) arakaanna, Jisu'n ama sik-ah ileithopi ngaikha aleiril. Halli khawa kajet rakip ngai'n inleingak. ");
INSERT INTO kfw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisu'n tuidiilpang raaltiang arakaanna aleikir. Khawa tuidiil pangkhan mipui katamtak ama koolla inhei-inchun. ");
INSERT INTO kfw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairus, khawa ramma Synagogue karoon inkhat aheitung, halli ama'n Jisu kha amupha, Jisu kekuungnga ajuo-inbok ");
INSERT INTO kfw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","khat-um malung kaluut-ah amadiang aleini, “Alakadoong kasanu kha natheiya om, naheiwapi inlang aring adamnasik nakut-ah najuokatook piro aleiti!” ");
INSERT INTO kfw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Halli Jisu'n amale inruoiya kasi inleiphut. Khawa jarra mipui katamtak in Jisu nuk injuiya amakha inlei-uum. ");
INSERT INTO kfw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Khawakhan kumsoomleini thikasarra chikaom rirai karoon numeisa inkhat aleiom, ");
INSERT INTO kfw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kathiam angjet in akana numeisanu kha inlei-en. Ama sialsum rakip aleineiman suojei, takkha kadamsik rathuulla ina kha apha rakip-ah hongkheelsit. ");
INSERT INTO kfw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Khawa numeisanu in Jisu athang ala aleijet-ah, ama nukkha mipui karra aheijui, ");
INSERT INTO kfw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","khawa numeisanu khan atheinuo-ah inti, “Kei'n ama puonmor kakatook inchu, kei kadamsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ama'n Jisu puonmor aleikatook, akatookli katookmak ama thikasar kha aleikhak; khawakhan ama'n atheinuo-ah kinahi kadamjei tia alei-injet. ");
INSERT INTO kfw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Khawa phakhan Jisu'n ama diangnga aranak isuok kha ajet-ah, Ama'n mipui karra ahei-inlet-ah aleirakel, “Tume kei kapuon kakatook?” ");
INSERT INTO kfw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ama siamruoi ngai'n inleimasang, “Mipui'n nang inna-uumhi namu; angjarra nang in tume kei kanakatook nitime?” ");
INSERT INTO kfw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Takkha Jisu'n tu ithome jetsik tia asir apang alei-en. ");
INSERT INTO kfw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Numeisanu khan ama diangnga kasuok kha aleijet, khawa jarra kachi khat-um intuulle inruoiya aheiwa-ah Jisu kekuungnga ajuo-inbok, halli akadik rakip kha ama diang aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisu'n numeisanu diang aleiti, “Kasanu, nang ngamna khan nang nadamjei. Kahoi kadaiya sitro, halli napoongna makheiya kadam kha etro.” ");
INSERT INTO kfw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Hiwahi Jisu'n atilai takkhan, lamkakei Jairus inna inphut chongkachoi lekkhat inhongnga Jairus diang inhongti, “Nasanu kha athijei. Angsikme Karu kha nilakacher?” ");
INSERT INTO kfw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Angme inmani itikha Jisu'n leirangai pimak, takkha lamkakeipa diang aleiti, “Chimaro, ngamnabit ngamnaro.” ");
INSERT INTO kfw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Khanna inphutchu Peter, James halli anai John elekleiya tu inkhat-um anuk kajuisik-ah leizootpimakjei. ");
INSERT INTO kfw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Inmani'n synagogue lamkakei Jairus inna inleitung, khawakhan Jisu'n thodan jetmuwa inkheek-ah khat-um inwaiya kachap ngaikha aleimu. ");
INSERT INTO kfw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ama'n innsuung aluut-ah inmani diang aleiti, “Angtia thodan ningjet makme? Angsik ame ningchap? Naipangnu hi akathi emak, takkha akazaal keeng!” ");
INSERT INTO kfw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Inmani'n ama kha inlei innuipui, khawa jarra ama'n inmani rakip tuolla aleiminsuok, asiamruoi inthumle khat-um naipangnu nuli pa aruoiya, naipangnu zaalnatiang khan inleiluut. ");
INSERT INTO kfw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ama'n naipangnu kutkhan amahuumma aleiti, “Talitha, Koum,” tinachu, “Alakasiin naipangnu, kei'n kati nang intheitro!” ");
INSERT INTO kfw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Khawapha takkhan ama'n intheiya asi aleihong. (Numeisanu kha kum soomleini alei eii.) Hiwa inmupha khan, inmani'n inthiangnga inleingak. ");
INSERT INTO kfw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Takkha Jisu'n tu diang-um rilpimaru tia chong kangar kha inmani diang aleipeii, halli ama'n aleiti, “Numeisanu diang baksik lekkhat peru.” ");
INSERT INTO kfw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisu'n khawamun kha amathaanna ama khuopui tiang aleikirra ama siamruoi ngai'n inleijui. ");
INSERT INTO kfw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jihudi ngai Sernikhuoni Synagogue-ah ama'n kaminchu aleiphut, karangai mipui rakip in inleingak. “Inmani'n inleirakel, ama'n hingai rakip hi hunna ijetme?” angkachang lungsing lungwarme ama diang inpehi? Angtho thowa inlak choun ithotheime? ");
INSERT INTO kfw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ama hi emak abe thingchounna akut kathei, Mary sapa, halli James, Joseph, Judas, khat-um Simon u-pa kha? Ama nainu ngai kha-um hiwaram hin einile ommuwabe? Halli inmani ngai'n ama kha leizootmu. ");
INSERT INTO kfw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisu'n inmani diang aleiril, “Pathian chongkachoi ngaihi inmani insuungkhurra khat-um in-u innai ngai inchu khoya thona neimu takkha ruongraal achu khoya thona innei.” ");
INSERT INTO kfw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Khawa khan Jisu'n mikana lekkhat diang akut duongnga imindam eleiya inlakchoun inkhat-um leitho matormak. ");
INSERT INTO kfw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mipui'n ngamna leineimu jarra, Jisu'n aleingak. Khawa suoli Jisu'n asiya sirpangnga kaom khuo ngaidiang aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Halli ama siamruoi soomleini ngaikha akoolla akoichunna inni inniya aleitir. Jisu'n ratha kathamakngai mator nasik-ah ranak aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Khat-um ama'n chong aleiminchu, “Nangni'n chuon ningsipha khan kherol eleiya iteii choithei nutun, waipool, sial halli sialkok inkhat-um choimaru. ");
INSERT INTO kfw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Puondiar inliak choimaru takkha hureikhaang khabit chuongru.” ");
INSERT INTO kfw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ama'n inmani diang aleitipi, hun e-innum innadonna inn khan omru, amunkha ningmathaan maklaiseng. ");
INSERT INTO kfw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Hun e-innum ningsina khuopui khan mi ngai'n nangni kha innaleidonmak inchu, khat-um ningchongril kha inna rangaipimak inchu, nakeiiya kaom rahutkha kathing inlang leidaro, khawa tinachu inmanidiang chongmakhaina nileida kha eii. ");
INSERT INTO kfw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Khawa suoli inmani'n inleisuok-ah mipui malung thuulna sik-ah chong inleiril. ");
INSERT INTO kfw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Inmani'n raikhuo angjet puutsuokna inleinei, halli akana mi angjet olive sariak inleikanoot-ah inleimindam. ");
INSERT INTO kfw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Khawa phakhan Herod rengpa'n hiwarakip jarra aleijet, ajarchu Jisu raming kha amun rakip-ah inleirilthang. Mi lekkhat in inti, “John Baptist kha ahongringnookjei! khawa jarra ama'n hiwa inlakchuon ngaihi ithomator eii.” ");
INSERT INTO kfw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mi lekkhat in inleiti, “Amahi Elijah eii.” Mi lekkhat in intirit, amahi Pathian chongkachoi eii, emakli tiallaiya Pathian chongkachoi ngai karra inkhat ka-ang eii. ");
INSERT INTO kfw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herod in hiwahi ajet phakhan, ama'n aleiti, “Amahi John Baptist eii, kei'n ariing kitanpa kha eii, takkha kathi makheiya kahong ringnook ejei!” ");
INSERT INTO kfw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod, ama tak-in John Baptist surnasik-ah chongpena aleinei khat-um aminsurra John kha thirruiya inkhuop-ah mikhumna khan aleida. Herod in hiwa athona ajarchu anaipa Philip numei ineinu Herodias jarra eii, ");
INSERT INTO kfw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John Baptist in Herod diang leitipi kachak, “Nanaipa numeitak neisikkha Sinadan kha emak!” ");
INSERT INTO kfw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Han Herodias in John kha lei-enzootmak ama kha aleithatzoot, takkha Herod in ajar-eya Herodias in John kha leithat matormak, ");
INSERT INTO kfw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod in John kha aleichi, ajarchu ama'n John kha mikathali inthiang inkhat eii tihi aleijet, Herod in John chongril arangai phakhan amalung aleipoong kha e-innum ama chongril kha alei rangaizoot, khawa jarra ama kha katha tak-ah aleida. ");
INSERT INTO kfw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hekna-ah Herodias in aphakacha aleimu, khachu Herod inneina nikhuo bubakni khan, kalok Kalian, waikaroon ngai, raalmi kalok ngai, halli Galilee khuopui lamkakei ngai koolla, ");
INSERT INTO kfw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias sanu aheiluut-ah ajuolaam, halli Herod khat-um ama sappui ngaikha ajuominrok halli Rengpa'n numeisanu diang aleiti, “Angme nang in nimanuom? kei'n nang imanuomrei kanapesik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Halli ama'n chong inkhitna khomak insaamma aleiti, “Nang in ninani takkha kanapesik eii, karengram herkhat e-innum.” ");
INSERT INTO kfw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Khawa jarra ama'n asuok-ah anudiang ajuorakel, “Angtakme kei'n kanisik?” Anu'n aleimasang, “John Baptist lu.” ");
INSERT INTO kfw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Numeisanu khan innottheiya aheikir nook-ah Rengpa diang ajuoni, “Kei'n hiwamun cheihin khat-um atuuntak hin John Baptist lu kha sumkheengnga kamanuom!” ");
INSERT INTO kfw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hiwa chong in Rengpa malung kha aleiminpoongthei, takkha in-ongpui ngai maikuungnga achong inkhit nakhan ajar-eya, numeisanu chongkha leikheet matormak, ");
INSERT INTO kfw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","khawa jarra ama'n innot tak-ah kangaak raalmi inkhat diang John lu kha heichoinasik chong aleipeii, kangaakpa khan khawa mun amathaanna mikhumna tiang aleisiya John lu kha aleitanna, ");
INSERT INTO kfw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","sumkheeng chungnga ada-ah numeisanu diang aleipeii halli khawa numeisanu khan anudiang ajuopeii. ");
INSERT INTO kfw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Hiwa chonghi injet phakhan ama siamruoi ngai'n inheiwa-ah akaluong kha inleiya inleiphuum. ");
INSERT INTO kfw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tirton ngaikhan inheikirra Jisu le inlei-inmu, halli inmani ngai'n inchuontholi, minchuna ngaikha inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Khawa khan mi katamtak inluut insuok-ah inleiom, Jisu li ama siamruoi ngaikha bubaknapha leimumu, khawa jarra ama'n inmani diang aleitipi, “Hiwa hinna inphut suok-inlang adaina munna si-inlang soong jomachumrui.” ");
INSERT INTO kfw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Khawale inruoiya inmani'n khawamun makheiya suokna inleineiya rakuong inchuongnga adaina munkhan inleisi. ");
INSERT INTO kfw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mi katamtak in inmani kasikha inleimu, tu-ngaime itihi inleijet phakhan, inmani ngai'n khuopuisuung inmathaanna Jisu li ama siamruoi ngai tungnasik munkhan inmani'n inleitung masa. ");
INSERT INTO kfw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisu'n rakuong makheiya aheisuokli mi katamtak aleimu phakhan amalungnga inmani ngaikha aleiminriang, ajarchu inmani ngaikha kakhaal kaboi Keelngamle in-ang, khawa jarra Jisu'n minchuna katamtak aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kholei heiluut phakhan, ama siamruoi ngai'n inheiwa-ah amadiang injuoti, “Tuunhin inmotheijei hiwa munhi ramchik eii. ");
INSERT INTO kfw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mipui ngaihi minsi inlang, inmani'n anaina khuosuung emakli leiya sisuo inlang inbaksik juo-inchorasu.” ");
INSERT INTO kfw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisu'n aleimasang, “Nangni'n inmani diang baksik peru.” Amadiang inleirakel, “ Keini'n kinsili dangka pum rajani hin waipool kinrachopili inmani kinminbak sikhi nang in namanuombe?” ");
INSERT INTO kfw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisu'n inmani diang aheirakel, “Waipool angjet ningneime? si inlang juo-enru.” Asiamruoi ngai'n inleimu phakhan, ama diang inleiti, “Waipool ra-ngali nga inni om.” ");
INSERT INTO kfw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisu'n ama siamruoi ngaidiang aleitipi mi rakip ngaikha rup rup-ah khoithen inlang chinthou bilkhan min-ongru. ");
INSERT INTO kfw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Khale inruoiya mi rakip in inhei in-ong taangnga bukkhat-ah mi rajakhat, bukkhat-ah mi soomra-nga. ");
INSERT INTO kfw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Khawa suoli Jisu'n waipool ra-nga khali nga inni kha aleiya marwaan tiang enna Pathian minpaakna aleinei. Ama'n waipool kha akatherli asiamruoi ngaidiang mi rakipdiang sempisik-ah aleipeii. Khale inruoiya ama'n nga inni kha-um akatherra inmani ngaidiang aleisempi ");
INSERT INTO kfw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mipui'n bakna inneiya, inwon inleiminsip. ");
INSERT INTO kfw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ama siamruoi ngai'n akaliam waipool li nga kha kokwar soomleini inleikhoomtuup. ");
INSERT INTO kfw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Akabak mi ngaikha pasalseng lising ra-nga inlei eii. ");
INSERT INTO kfw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisu'n innottheiya ama siamruoi ngaikha rakuongnga aminluut-ah Bethsaida tiang ama neek-ah ma minsa-ah aleiminsi, khawa phakhan Jisu'n mipui kha-um aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Inmani rakip kha inthenpui suoli, ama'n chingmuolla Pathian kani aleisi. ");
INSERT INTO kfw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kholei ephakhan, rakuong kha tuipui laikhan aleiom, Jisu kha atheinuo-ah muongpangnga aleiom. ");
INSERT INTO kfw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ama'n siamruoi ngai poongna kha aleimu, ajarchu thikaraang kangar kha inlei intongpui; khat-um ziingtiang phadan inthum makheiya kuruk kongkarra Jisu'n tuichungnga inmanidiang aheiwa ah ama'n inmani kha aheikheel dengphakhan, ");
INSERT INTO kfw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ama'n tuipui chungnga akeiiya iheiwa inmupha khan, inmani'n akathamak raikhuo eii intia inleikheek. ");
INSERT INTO kfw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Inmani'n inleimu phakhan inraya-ah inlei-inlai. Takkha khawapha takkhan Jisu'n aleiti, “Malung minpoongmaru.” “Chimaru, Kei ka-eii!” ");
INSERT INTO kfw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Halli ama'n inmani rakuong suungnga aleiluut, khale inruoiya thikaraang kha aleidaijei. Halli asiamruoi ngai'n inthiangnga inleingak. ");
INSERT INTO kfw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ajarchu inmani malung ngarjarra, mi lising ra-nga awaina chuon inlak kha leijet matormu. ");
INSERT INTO kfw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Inmani'n tuipui inleirakaanna Gennesaret ramtiang inheiwa phakhan rakuong kha muongpangnga inleida. ");
INSERT INTO kfw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Inmani'n rakuong makheiya inheisuok phakhan Jisu kha mipui'n ameel inleijet. ");
INSERT INTO kfw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Halli mipui ngai'n inleijet phakhan khawa muntiang inheitaanna inheiwa, halli mi kana ngaikha inheiruoiya pherra inleiminzaal. ");
INSERT INTO kfw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Khawa suoli Jisu leengnamun rakip-ah, khuo ah, khuopuiya, leiya, phaisuungnga, mipui'n akana ngaikha mi inchunna tiang inheiruoiya akana rakip in apuonmorbit katook nasik inleini, halli akakatook mi rakip in inleidam. ");
INSERT INTO kfw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jerusalem makheiya kaheiwa Pharisee lekkhat khat-um Sinadan Karu ngaikha Jisu koolla inlei-intuup. ");
INSERT INTO kfw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ama siamruoi lekkhat in inkut rasuleiya bu inleibak kha inmani'n inleimu, hiwahi inmani Sinadanna inthiangmak eii, tichu inmani'n inkutkha Pharisee ngai'n mipuidiang inminchu angnga leirasumu. ");
INSERT INTO kfw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ajarchu Pharisee khat-um Jihudi rakip in inkutkha katha-ah inrasumak laiseng bu kha leibakmu hiwahi inmani Pi le Pu ngai leiminchu Sinadan eii. ");
INSERT INTO kfw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Inmani'n phai makheiya inheiracho phur rakip ngaikha rasuthiang masaleiya leibakmu. Khale inruoiya inmani'n aleiilaak sinasik Dan angjet inleijui, khat-um akatha tak-ah rabing, beel, sumkheeng, zaalmun ngaihi inlei rasuthiang. ");
INSERT INTO kfw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pharisee khat-um Dan Karu ngai'n inheirakel, “Angjarrame nang nasiamruoi ngai'n Pirui Purui ngai Sinadan injuimak, halli kut rasuleiya bu inbak?” ");
INSERT INTO kfw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisu'n inmanidiang aleimasang, “Isaiah ileiril kha angtuk kadikme nangni jarra! katha inleem nangni ning eii, tia hinthoa aleimajia: ‘Hiwa mipui ngai'n keihi inmur bit-ah innakaya, takkha inmalung ngachu kei kadiang kalaak-ah inom. ");
INSERT INTO kfw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Takkha inmani'n keihi innemna boiya chubei innatho, ajarchu inmani'n manmasi ngai lungdou nuoiya inminchu kha Pathian Dan angnga inmani'n inngaidon!’ ");
INSERT INTO kfw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nangni'n Pathian chongpe nakha zootmakchuwa miring ngai minchuna kha ningjuijei.” ");
INSERT INTO kfw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisu'n inmani diang aleiti, “Nangni minchuna juitheinasik beiya ningsing theiya Pathian chongpehi ninglooijei. ");
INSERT INTO kfw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses chongpe nakhan, ‘Nanu napa nakaya sik, halli nanu napa kathamak-ah narilse inchu, amakha thina inpesik eii.’ ");
INSERT INTO kfw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Takkha nangni'n ningti, mi inkhat in apa emakli anudiang sansik kasouk sanleiya, nang in hinnati, hiwa hichu corban (tinachu, Pathian ta eii), ");
INSERT INTO kfw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Inmani'n innu emakli inpa sansik kha minsan makchujei. ");
INSERT INTO kfw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hiwa ka-ang minchunahi ningjuiya Pathian chonghi ningmathaanjei, khale inruoiya hiwa ka-ang chuon angjet nangni'n ningtho.” ");
INSERT INTO kfw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Khale inruoiya Jisu'n mipui ngai rakip kha ama koolla akoinook-ah aleitipi, “Rangairu nangni ngai rakip khat-um jetru. ");
INSERT INTO kfw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tuol makheiya miring suungnga kaluut phur khan mi naminchokmak, takkha miring suungnga inphut hongkasuok khan mi aminchok.” ");
INSERT INTO kfw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kuor indou mi rakip in rangairu. ");
INSERT INTO kfw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisu'n mipui kha aleimathaanli inn inkhat-ah aleiluut, halli asiamruoi ngai'n minkhina thurchi jarra rilcheen nasik inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","“Nangni'n mi ngai neek-ah ning-am,” Jisu'n inmani diang aril, “Tuunkatung nangni lajetmakchube? putiangnga heikaluut phur ngaikhan mi minchok matormak itihi jetmakchube, ");
INSERT INTO kfw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ajarchu ningwonna kaluutkha ningmalungnga kaluut emak, halli ningpum makheiya suoknooksik eii.” (Jisu'n aleiti, phur rakip baksik-ah inthiang eii.) ");
INSERT INTO kfw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Halli Jisu'n aleitipi, “Miringnga inphut heikasuok khan mi minchok. ");
INSERT INTO kfw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nangni malungsuung makheiya kasuok kathamak in anakeiruoi, omchan kathamak, inruup, mi kathat, ");
INSERT INTO kfw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","zool-inthai, phamrai kase, kathamak rakip katho, maleisei karil, kara-ot, omchan kalurmak, mikathat, in-or, khat-um ka-am, ");
INSERT INTO kfw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","hingai rakip nangni suungnga kaheisuok eii halli nangni kanaminchok eii.” ");
INSERT INTO kfw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Khawa munkha Jisu'n aleimathaanna Tyre li Sidon ramsuungnga aleisi, tuteii diang lei-inlar zootmak jarra innsuungnga aleiom, takkha ama'n inthupchei leimatormak. ");
INSERT INTO kfw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Asanu ratha kathamak kaluut numeisa inkhat in Jisu jarra aleijet-ah, halli khawapha takkhan aheiwa-ah Jisu kekuungnga aleikinbok. ");
INSERT INTO kfw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Numeisanu kha Phoenicia Syria ramma innei Zaatlop inkhat alei eii, ama'n asanu diang kaom raikhuo kha puutsuok nasik-ah Jisu diang aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Takkha Jisu'n numeisanu diang aleiti, “Mansa khet-ah naipang ngaihi wonkasip ah bakdirasu, ajarchu naipang ngai baksik bu kha leili ui ngaidiang pesik hi dikmak!” ");
INSERT INTO kfw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Numeisanu in aleimasang, “Karu,” adik, “Ui innum naipang ngai bakbang buramol khamtuol nuoiya kata ngaikha inbak.” ");
INSERT INTO kfw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Halli aman'n numeisanu diang aleiti, “Nang in khawa nanaheimasang jarra, na-inntiang kirtaro raikhuo kha nasanu makheiya asuokjei!” ");
INSERT INTO kfw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Khawa numeisanu khan inntiang akirpha khan zaalmun chungnga kazaal naipangnu kha apumma kaom ratha kathamak kha aleisuokjei. ");
INSERT INTO kfw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Khawa suoli Jisu'n Tyre ramsuung kha aleimathaanna Sidon arakaanna Galilee tuidiil tiang aleisi, Khuopui soom inti (Decapolis) ramsuung khan aheiwa. ");
INSERT INTO kfw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mi lekkhat in akuorkaseet khat-um chong kasuokmak pasal inkhat inheiruoi, halli inmani'n Jisu diang ama chungnga akut duongpi nasik-ah inleiti. ");
INSERT INTO kfw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Khale inruoiya Jisu'n amakha mipui karra inphut atheinuo-ah aleiruoi, pasalpa kuor suungnga akutchal asulluut ah amachilli amalei kha aleikatookpi, ");
INSERT INTO kfw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","khale inruoiya Jisu'n marwaan tiang enna phuk inthuuk ah kasanna pasal padiang aleiti, “Ephphatha,” tinachu, “Inlong taro!” ");
INSERT INTO kfw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Khawa pha takkhan Pasalpa khan akuorkha aharwengjei halli in-ak omlekleiya chong aleiril. ");
INSERT INTO kfw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisu'n mipui diang hiwahi rilsuok maknasik aleitipi, takkha kheella rilmaru tipili mipui'n kheella inleirilsuok. ");
INSERT INTO kfw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Khat-um akarangai rakip in tidan omleiya inleingak. “Angtuk kathame ama chuontho rakip hi!” “Ama'n akuorkaseet kha aminharpi khat-um chong kasuokmak kha chong aminsuok!” ");
INSERT INTO kfw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Khawa suoa sootlekleiya mi katamtak inhei intuup. Inmani'n baksik leijetmu, Jisu'n asiamruoi ngaikha akoichunna aleitipi, ");
INSERT INTO kfw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kei'n mipui ngai sik-ah kapoongpi, ajarchu inmani ngaihi nithum keile inom jarra tuunchu baksik neimujei. ");
INSERT INTO kfw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kei'n inmani ngaihi minbakleiya inntiang kaminkir inchu inmani kha insina lamma poongna inneisik eii, ajarchu mi lekkhat ramkalaak makheiya kaheiwa in eii.” ");
INSERT INTO kfw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ama siamruoi ngai'n inleirakel, “Hiwa neelram hinna hiwa mipui minkhopnasik bakphur hi hun muminname?” ");
INSERT INTO kfw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Jisu'n aleirakel, waipool angjet ningneime?” “Waipool sari,” tia inleimasang. ");
INSERT INTO kfw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ama'n mipui diang nuoipilla in-ongnasik chongpena aleinei. Khale inruoiya waipool sari kha aleiya, Pathian aleini, akatherkhoiya ama siamruoi ngaidiang mipui ngaidiang sempinasik aleitipi, halli ama siamruoi ngai'n leisemna innei. ");
INSERT INTO kfw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Inmani'n ngateii lekkhat-um inleinei. Hiwa sik-um Jisu'n Pathian aniya halli ama siamruoi ngaidiang mipuidiang sempiru aleitipi. ");
INSERT INTO kfw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mi rakip in kakhop-ah inleibak, mi lising mili daam inlei eii, khale inruoiya ama siamruoi ngai'n kokwar sari kasip kaliamkha inleikhoomchun. Halli Jisu'n mipui ngaikha aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Halli innot tak-ah ama siamruoi ngaile rakuong suungkhan inleiluut-ah Dalmanutha ramtiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee lekkhat in Jisu diang inheiwa-ah amale murruolsiak inleitho. Inmani'n ama kha surthei nasik-ah ensuina inneiya Pathian in izoot eii tina choun inlak naminmuro tia inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Takkha Jisu'n phuk inthuuk ah kasanna aleiti, “Ang jarrame tuunlai khang mingai'n inlak chuon innarakel? Kei'n nangnidiang inthiangnga kanati! hi ka-ang inlak chuonhi tuunlai mi ngaidiang penuning!” ");
INSERT INTO kfw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Inmani ngaikha ama'n aleimathaanna, rakuong kha achuongnook-ah tuidiil raalkhattiang aleisi. ");
INSERT INTO kfw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Siamruoi ngai'n waipool heichoisik inmanilla rakuong suungnga waipool inkhatbit aleiom. ");
INSERT INTO kfw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Inringru, tia Jisu'n chongpena aleinei, “Halli nangni'n Pharisee ngaili Herod chol chungnga insingtheiru.” ");
INSERT INTO kfw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Inmani seng inbiakna inleineiya inleiti, “Eini'n waipool neipimakmi jarra ama'n hiwahi iti eii.” ");
INSERT INTO kfw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisu'n inmani ngai irilkha aleijet, khale inruoiya ama'n inmani diang aleirakel, “Angsiya waipool ommak jarra inbiakna ningneime? nangni'n lamumak chube khat-um lajetmak chube? nangni eteii ngaidon suokmak chube? ");
INSERT INTO kfw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ningmit khan mumakchube? ningkuor khan jetmakchube? nangni'n ngaidon theimakchube, ");
INSERT INTO kfw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kei'n waipool ra-nga kha mi lising ra-nga sik kikatheer? Kok angjetme nangni'n akaliam ningkhomtuup kha?” Inmani'n inleimasang “Soomleini.” ");
INSERT INTO kfw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Halli kei'n waipool sari kha mi lising mili sik kaleikatheer khoi,” “Kok angjetme nangni'n akaliam ningkhoom chunkha?” tia Jisu'n aleirakel. “Sari,” tia inmani'n inleimasang. ");
INSERT INTO kfw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Halli inmani diang aleiti, “Nangni atuunkatung lajetmakchube?” ");
INSERT INTO kfw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Inmani'n Bethsaida tiang inheiwa phakhan, mi lekkhat in Jisu diang amitkacho mi inkhat inheiruoiya amadiang nakatookpiro intia chong inleisor. ");
INSERT INTO kfw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisu'n mitkacho mi kha akeiruoiya khuosuung kha aleisuokpui, mipa mitkhan aleimachil suoli, Jisu'n ama takchungnga akut duongnga aleirakel, “Ang ang namume?” ");
INSERT INTO kfw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Khawa mipa khan chungtiang ahong enna aleiti, “Oh, mipui kha kei'n kamu, takkha inmani ngaikha thingkuung in-angnga insi inhong.” ");
INSERT INTO kfw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisu'n woikhat-um pasalpa mit-ah akut khan aleikatookpi. Khawapha khanchu mipa khan khawalai angnga amujei, halli ama'n angrakip inthiangnga amujei. ");
INSERT INTO kfw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisu'n “Khuosuung khan luutnook khaimaro,” iti chong apeya inntiang aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Khale inruoiya Jisu le ama siamruoi ngaikha Caesarea Philipi koolla kaom khuosuung tiang inleisi. Insina lamma asiamruoi ngaidiang aleirakel, “Keidiang heitiru mi ngai'n keihi tu eii innatime?” ");
INSERT INTO kfw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Mi lekkhat in nanghi John Baptist eii innati,” tia inmani'n inleimasang; “Mi lekkhat in innati nanghi Elijah, khale inruoiya mi lekkhat in innati nanghi Pathian chongkachoi inkhat na-eii.” ");
INSERT INTO kfw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ama'n inmani diang aleirakel “Nangni inleii keihi tu eii ningnatime?” Peter in aleimasang, “Nang Messiah na-eii.” ");
INSERT INTO kfw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Khawa suoa Jisu'n inmani ngaidiang chongpena aleinei, “Kei kajarra tudiang um rilpimaru.” ");
INSERT INTO kfw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Khale inruoiya Jisu'n asiamruoi ngaikha aleiminchu: “Miring Sapa kha akapoong angjet adeisik eii, khat-um upa ngai, Thiampu Kalian ngai, Sinadan Karu ngai'n zootnunu, halli ama kha inthatsik eii, takkha nithum huuini hongringnook sik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ama'n hiwahi inmani diang inthiangnga aleimalar, hiwa jarra Peter in ama kha asir khat-ah aruoiya ama kha aleiran. ");
INSERT INTO kfw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Takkha Jisu'n asir apangnga kaom siamruoi ngaidiang alei enna Peter diang aleiranna aleiti. “Seitan kei kadiang makheiya sitro, Nang i-ngaidon kha Pathian diang makheiya kajuo emak takkha manmasi omchan makheiya eii.” ");
INSERT INTO kfw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jisu'n ama koolla mipui khat-um asiamruoi ngaikha aleikoi. “Tu ka-ang keile kasizoot mi khan” ama'n inmanidiang aleiti “apumtak inzootmarase, halli ama cross kha kadom inlang kei najuirase. ");
INSERT INTO kfw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ajarchu tu ka-ang in aringkhuo insanzoot inchu aringkhuo mangsik eii, takkha keisik beiya khat-um chongkahoi sik beiya aringkhuo apesuok inchu ringna amusik eii. ");
INSERT INTO kfw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mi inkhat in manmasituol pumpui ata amin e-innum, aringkhuo aminmang inle amasik anemna angme? ");
INSERT INTO kfw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mi inkhat in aringkhuo kha angle inminthuul thei omme? ");
INSERT INTO kfw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mi inkhat in kei jarra khat-um kei minchuna hi hiwa Pathian kajetmak khat-um akachok khanghin injak inchu, Miring Sapa innum apa lurna khat-um inthiang marwaan tirton ngaile ajuoni khan ama innum khawa miring chungnga injaksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Halli Jisu'n inmani diang aleitipi, “Kei'n kadik-ah natipi kate, Pathian Rengram kha ranak le inruoiya akajuokha inmumakleiseng hiwahin mi lekkhat akathimaksik inom.” ");
INSERT INTO kfw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Niruk thengli, Jisu'n Peter, James khat-um John aruoiya inmani ngaikha muol insaangtiang inleisi, inmanibit inleiom, inmani'n inlei-en phakhan Jisu meelsuo alei-inthuul. ");
INSERT INTO kfw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Halli ama puondiar kachek kha manmasituol puonkasoop mi ngai'n minchek matormak sik katungnga aleichek. ");
INSERT INTO kfw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Khale inruoiya asiamruoi inthum ngai'n Moses li Elijah in Jisu le chong inleirilkha inleimu. ");
INSERT INTO kfw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter in akheek-ah Jisu diang aleiti, “Karu, angtuk kathame keini'n hiwa munna kinomhi! Keini'n hiwa munhin maichaam inn inthum kinsaksik eii, nang nasik inkhat, Moses sik inkhat, halli Elijah sik inkhat.” ");
INSERT INTO kfw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ama'n rilsik leijetmak jarra, Peter khat-um aleiilaak ngai'n inleingak. ");
INSERT INTO kfw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Khale inruoiya suumphai aheiwa-ah inmani ngaikha aleimakhu, halli suumphai makheiya rasa ajuonei, “Hiwahi kei iminriangkhet kasapa eii ama iti rangairu!” ");
INSERT INTO kfw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Inmani'n innot theiya insir inpangkha inlei-en phakhan inmani'n Jisu eleiya tuteii leimumu. ");
INSERT INTO kfw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Amuol makheiya injuochum phakhan, Jisu'n inmani diang chong aleipeii, “Ning imu ngaihi nangni'n tu miring diang-um rilpimaru, Miring Sapa kha kathi makheiya ahongringnook maklaiseng.” ");
INSERT INTO kfw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Inmani'n ama chongpe kha inleijui, inmani'n hiwa jarra khatli inkhat diang inlei-inkel, “Akathi makheiya ringnooksik tihi ang tiname?” ");
INSERT INTO kfw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Halli inmani'n Jisu diang inleirakel, “Angjarra Dan kamajia Karu ngai'n Elijah eii kajuo masasik intime?” ");
INSERT INTO kfw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Halli “Ama'n inmani diang aleimasang, Elijah kha eii angrakip kaminsuuk sik-ah akajuo masasik, halle angjarra Pathian chong inthiang khan Miring Sapa kha poongna angjet adeisik eii khat-um mi ngai'n zootnunu itime? ");
INSERT INTO kfw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kei'n nangni diang kanati, Elijah chu aleijuo suojei, khale inruoiya chong inthiang in ama jarra ileiti angnga, mi ngai'n ama chungnga inthozootkha inthosuojei.” ");
INSERT INTO kfw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Inmani'n asiamruoi leiilaak ngaidiang injuopha khan, inmani'n mipui katamtak inkoolla khat-um Dan Karu ngai'n inmanile murruolsiak inleitho kha injuomu. ");
INSERT INTO kfw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mipui'n Jisu kha inleimu phakhan inmani'n inleingak, halli inmani'n inheitaanna Jisu kha chubei inleitho. ");
INSERT INTO kfw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisu'n asiamruoi ngaidiang aleirakel, “Angjarra nangni'n inmanile murruolsiak ningthome?” ");
INSERT INTO kfw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mipui ngai karra miring inkhat in ahongmasang, “Karu, kasapa suungnga ratha kathamak om halli chong asuokmak jarra kei'n nangdiang kaheiruoi. ");
INSERT INTO kfw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ratha kathamak in ama kha asur racham, ama'n nepilla inluoiya abaiya achilphuon aleisuok, aha aleikarial, khat-um apum kha leikeichangkhang, khawa khan ajar eya kei'n nasiamruoi ngaidiang napuutsuok pinasik kaleiti, takkha inmani'n leimatormu.” ");
INSERT INTO kfw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisu'n inmani diang aleiti, “Eh ngamna kaneimak nangni ngai! Nangnile angtuk kasoot kei'n kalaom suomsikme? Kei'n nangni kha angtuk kasoot kanaladeipui sikme? naipangpa kha keidiang heiruoiru!” ");
INSERT INTO kfw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Inmani'n ama kha Jisu diang inheiruoi. Kathamak ratha'n Jisu kha aleimu phakhan, jetlei theileiya ratha kathamak in naipangpa kha keichang khangnga juodeengjuon, halli amurra achilphuon sip-ah neipilla inlet inkhup-ah lei-inluoi. ");
INSERT INTO kfw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Angtuk kasoot mejei hin tinahi?” Jisu'n apadiang aleirakel. “Naipang elaiya inphut eii tia,” ama'n aleimasang. ");
INSERT INTO kfw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Apha angjet akathamak ratha'n amahi thatnasik-ah mei khat-um tuiya ideengluut ejei. Nang in namator inchu, keihi naminriangro khat-um nasanro!” ");
INSERT INTO kfw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisu'n ama diang aleiti, “Ingamna kanei ama diangchu! ang rakip ethei eii.” ");
INSERT INTO kfw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Khawapha takkhan apa'n ahongkheek-ah aheiti, “Kei ngamna kanei, kei ngamna kasuolhi nasanro!” ");
INSERT INTO kfw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisu'n mipuikha inmani omnatiang inheinai amupha khan, ratha kathamak diang chong aleipeii, “Kuorseet khat-um chong kasoukmak ratha,” Jisu'n aleiti, “Naipangpa makheiya nang in heisuok inlang halli inlet-ah luutnook khaimaro.” ");
INSERT INTO kfw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ratha khan akheek-ah, naipangpa kha keichang khangnga natheiya juodeengjuonna halli aheisuokjei, naipangpa kha akathi alei-ang, halli mi rakip in inleiti, “ama hi athijei!” ");
INSERT INTO kfw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Takkha Jisu'n naipangpa kha akutkhan amahuumma aleikeithei, halli ama'n ahongngir. ");
INSERT INTO kfw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisu'n innsuung aleiluut phakhan, ama siamruoi ngai'n ruuk-ah inleirakel, “Angjarra keini'n ratha kathamak kha kinpuutsuok matormakme?” ");
INSERT INTO kfw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisu'n aleimasang, “Pathian kani elekleiya hiwa ngaihi puutsuok matornutun.” ");
INSERT INTO kfw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jisu khat-um ama siamruoi ngai'n khawa munkha inleimathaan, Galilee suungtiang inleisi phakhan, Jisu'n tudiang-um ama sina leiminjet zootmak, ");
INSERT INTO kfw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ajarchu ama siamruoi ngaikha aleiminchu: “Miring Sapa kha mi ngai kutchungnga pe-inta inthatsik eii halli nithum huuini khan ahongringnook sik.” ");
INSERT INTO kfw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Takkha inmani'n hiwa minchu nahi leijet matormu, khale inruoiya inmani'n amadiang karakel sik inleichi. ");
INSERT INTO kfw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Inmani'n Capernaum tiang inheiwa-ah, innsuung inluut phakhan Jisu'n asiamruoi ngaidiang aleirakel, “Angjarrame nangni'n lamma murruolsiak ningthokha?” ");
INSERT INTO kfw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Takkha inmani'n leimasangmu, ajarchu inmani'n lamma murruolsiak inleitho khachu tume akalokkhet tijarra eii. ");
INSERT INTO kfw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisu'n alei in-ongnga asiamruoi soomleini ngaikha aleikoi, halli inmani diang aleitipi, “Atu ka-ang in chung kanungkhet ezoot inchu ama kha nuoi kanungkhet esik eii, halli mirakip nuoiya kasiinkhet suok a-esik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ama'n naipang inkhat aheiruoiya inmani ngai maikuungnga aleiminngir, ama'n akakuoa inmani ngaidiang aleitipi, ");
INSERT INTO kfw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tu ka-ang mi inkhat in hiwa naipang ngai inkhattak kei karamingnga karalaang kha kei innaralaang eii halli kei kanaralaang mikha keibit kanaralaang emak takkha kei kanajuotirpa kha-um inralaang kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John in amadiang aleitipi, “Karu, keini'n mi inkhat nang naramingnga raikhuo ipuutsuok kinmu, halli keini'n ama kha kinleikhaap, ajarchu ama kha eini karra mi lei-emak.” ");
INSERT INTO kfw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisu'n inmanidiang aleitipi, “Ama kha khaapmaru,” “Ajarchu atu ka-ang in chuon inlak kei ramingnga kathomator mikhan innottheiya keihi kathamak-ah narilsenuni. ");
INSERT INTO kfw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Atu ka-ang in einile inhalmak mikha eini mi in-eii. ");
INSERT INTO kfw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ajarchu nangkha Christa mi na-eii tia, atu ka-ang in tuirabing inkhat kei karamingnga insik-ah anape inchu, kei'n inthiangnga nangni diang kanati, ama chountho mankha mangnuni.” ");
INSERT INTO kfw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Atu ka-ang in naipang ngai inkhat kei kadiang ingamna kaminmang ama khachu, ariingnga lungchakari inkhitli tuipui inthuup ah indeengluut kha athadoom. ");
INSERT INTO kfw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Khale inruoiya nang nakut in manu anamintho inchu nakut kha tanro! Kut inni huuiya hektik kaboi meikhurra kaluutsik neek-ah, kut khatbeiya hektik kaboi ringkhuo Pathian Rengram kaluutkha athadom. ");
INSERT INTO kfw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Inmani ka-ei ralung ngaikha supthi thinunu khat-um inmani kakaang mei kha supthi thinuni. ");
INSERT INTO kfw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Khale inruoiya nang nakeii-in ingamna aminmang inchu, tanro! keii inni huuiya meikhur kaluutsik nekchu keii inchelleiya ringna kaluutkha athadoom, ");
INSERT INTO kfw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Khawa khan inmani ka-ei ralung ngaikha supthi thinunu khat-um inmani kakaang mei kha supthi thinuni. ");
INSERT INTO kfw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Halli nang namit-in ingamna kha aminmang inchu, kelsuokro! mit inni eya meikhur kaluutsik neek achu mit inkhat bit-ah Pathian Rengram kaluutkha athadoom. ");
INSERT INTO kfw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Khawa khan inmani ka-ei ralung ngaikha supthi thinunu, khat-um inmani kakaang mei kha supthi thinuni. ");
INSERT INTO kfw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Dooiphur kha machiya inminthiang angnga mi rakip-um meiya aminthiangsik eii. ");
INSERT INTO kfw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Machi hi a-al; takkha i-alkha amang inchu, angtho tholia woikhat min-al mator minname? Nangni ningpum suungnga machi kha minomru, halli kahoi kadaiya omsuomru.” ");
INSERT INTO kfw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Halli Jisu'n khawa munkha amathaanna Judea ramsuung tiang aleisi, halli Jordan tuidung kha aleirakaanna ama'n mi katamtak kaheiwa ngaidiang matiangnga ileiminchu angnga aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisee lekkhat in ama koolla inheiwa-ah ama surna sik-ah ensuina inleinei. Inmani'n inleirakel, “Natipiro,” “Pasal inkhat in anumei inthenpui nasik ah Dan in zootbe?” ");
INSERT INTO kfw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisu'n inmanidiang aleimasang, “Moses in nangnidiang, angkachang Dan napame?” ");
INSERT INTO kfw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Inmani'n inleiti, “Moses in inthenna cheiikha pasalpa in amajia li anumei kha inthenpui sik-ah azoot.” ");
INSERT INTO kfw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisu'n inmani diang aleiti, “Nangni ningmalung ningminngar jarra Moses in hiwa Dan hi ileimajia eii. ");
INSERT INTO kfw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Takkha Pathian kutbool inphutna khan pasal khat-um numeisa aleibool. ");
INSERT INTO kfw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Khawa jarra pasal in anu apa mathaanta anumeile inchunsik eii. ");
INSERT INTO kfw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Halli inmani inni'n taksa inkhatbit in e-sik eii, khawa jarra inmani inni'n inni etheinunu, takkha taksa inkhat in-esik eii, ");
INSERT INTO kfw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pathian in iminchun kha manmasi miring inkhat innum minthenthei nunu.” ");
INSERT INTO kfw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ama siamruoi ngai'n inntiang inkir phakhan Jisu diang hiwa jarra inleirakel, ");
INSERT INTO kfw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ama'n inmani diang aleiril, “Tu ka-ang pasal in anumei inthenpui suoli numeisa inkhat anei inchu ama kha anumei takchungnga zool-inthai eii. ");
INSERT INTO kfw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hile in-angnga, atu ka-ang numeisa innum aruothar inthenpuili pasal inkhat anei inchu aruothar chungnga zool-inthai eii.” ");
INSERT INTO kfw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mi lekkhat in naipang ngai chungnga akut duongpi nasik-ah Jisu diang inheiruoi, takkha ama siamruoi ngai'n naipang kaheiruoi ngaikha inleiran. ");
INSERT INTO kfw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisu'n hiwa amu phakhan aleiraangnga inmani diang aleiti, “Naipang ngaikha kei kadiang heiwarasu inmani kha khaapmaru, ajarchu Pathian Rengram kha hiwa ka-ang naipang ngaita eii. ");
INSERT INTO kfw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kei'n nangni diang inthiangnga kanati, Pathian Rengram kha naipang inkhat in iralaang angnga ningralaangmak inchu, ama Rengram luutthei nutun.” ");
INSERT INTO kfw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Halli naipang ngaikha akakuo chunna, ama'n inmani chungnga akut duongnga rawaan aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Halli Jisu'n lamma kasi aheiphutnook phakhan pasal inkhat in aheitaanna ama diang inkunna aleiti. “Katha Karu, hektik kaboi ringkhuo munasik-ah angme kathosik?” ");
INSERT INTO kfw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Angjarra katha tia ninakoime?” Jisu'n ama diang aleiti, “Tuteii katha ommu, Pathian khabit eii katha. ");
INSERT INTO kfw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Chongpeii kha nang in najet: ‘Mi kathat emaro; zool-inthai emaro, inruup thomaro, mi ngaikha rilsemaro, maleisei rilmaro, nanu napa kayaro.’ ” ");
INSERT INTO kfw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mipa in aleiti, “Karu” “Hiwa Sinadan rakip ngaihi naipang ka-elaiya inphut kahongjui wiakjei.” ");
INSERT INTO kfw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisu'n amadiang minriang tak-ah ahei-enna aleiti, “Nang in nathosik Dan inkhat alaom. Si-inlang ninei rakip juor inlang sara ngaidiang sial ngaikha juopero, kha e-inchu marwaan ramma na-inchongsik eii, heikirnook inlang kanuk najuiro,” ");
INSERT INTO kfw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ama'n hiwa chong ajetpha khan, ama maisuokhan kahoimak in sip-ah akirjei, ajarchu ama kha inchongthei mi alei eii. ");
INSERT INTO kfw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisu'n amit-en minloonna asiamruoi ngaidiang ahei-enna aleiti, “Angtuk intakme inchong miring in Pathian Rengram kaluutsik!” ");
INSERT INTO kfw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Hiwa chong in asiamruoi ngaikha ngakna inleinei, takkha Jisu'n inlet-ah aleiril, “Kei kasangai, Pathian Rengram kaluut sik-hi angtuk intakme! ");
INSERT INTO kfw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Inchong khat in Pathian Rengram kaluutsik neek achu salaileem inkhat in simphuoi kuorra kaluutsik kha abeidet.” ");
INSERT INTO kfw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Hiwa chong hin asiamruoi ngai'n inthiangnga inleingak-ah inmani khatli inkhatdiang inlei-inkel, “Kha e-inchu tume ringna kamusik?” ");
INSERT INTO kfw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisu'n inmani diang encheiya aleimasang, “Miring ngaisik achu hiwahi etheinuni, takkha Pathian diangchu ethei, ang rakip Pathian diangchu ethei eii.” ");
INSERT INTO kfw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Halli Peter in ahongril, “Enro, angrakip kinmathaanna keini'n nang kinnajuijei.” ");
INSERT INTO kfw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisu'n aleimasang, “Inthiangnga kei'n nangni diang kanati, atu ka-ang in, in-u innai emakli innu inpa, insangai emakli in-inn inlei kei chongkahoi sik-ah inmathaan inchu, ");
INSERT INTO kfw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","atuunna ringkhuo hin saruk rajakhat khella inn, ulenai, nu, sa, lei, khat-um poongna ngaihi inmusik eii, halli akahongsik ringkhuo khanchu kumsoot ringna inmusik eii. ");
INSERT INTO kfw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Takkha atuunna mi katamtak ma-insa ngai'n nuk inlatongsik eii, halli tuunna mi katamtak nuk intong ngai'n ma inlasasik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Halli Jisu'n asiamruoi ngaile Jerusalem lamma insi phakhan, Jisu'n asiamruoi ngai neek-ah ma asa-ah aleisi, anuk kajui ngaikha akachi in aleisip. Jisu'n woikhat inlet-ah asiamruoi ngaikha inteina mun inkhat-ah aminchunna ama diangnga kasuoksik chuon ngaikha arilpinook. ");
INSERT INTO kfw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rangairu, “Ama'n aleiti, Miring Sapa kha Thiampu Kalian khat-um Dan Karu ngaidiang inpenasik mun Jerusalem tiang kasisik ni-eii. Inmani ngai'n Jisu kha kathi sik-ah rahoi suok tina noonkuung pe-inta Zaatlop ngaidiang inpesik eii, ");
INSERT INTO kfw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","inmani ngai'n ama kha innuipui inta, machilthuon inta, kase-ah wuok inta halli inthatsik eii, takkha nithum huuini ahongring nooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedee sa-ngai James li John in Jisu diang inheiwa-ah inleiti, “Karu,” “Keini'n angme inkhat nang nadiang keini sik-ah kinnaminthozoot inkhat om.” ");
INSERT INTO kfw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisu'n aheirakel, “Angme ningna minthozoot?” ");
INSERT INTO kfw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Inmani'n inheimasang, “Nang in-ongna Rengram poina khan, keini inni khat-in changtiang khat-in weitiang in-ongsik nazootpiro.” ");
INSERT INTO kfw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisu'n inmani diang aleiti, nangni'n ningna rakelna ajarkha jetmakchujei, kei ka-insik poongna rabing kha nangni inmator tunbo? Kei Baptize kathosik angnga nangnileii Baptize thomator tunbo? ");
INSERT INTO kfw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Inmani'n inleiti, “Kinthomator.” Jisu'n inmani diang aleiti, “Kei i-in rabingkha nangni'n inmator ningte, halli kei'n Baptize kitho angnga nangni innum thoningte. ");
INSERT INTO kfw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Takkha tume kei kakut changtiang khat-um kaweitiang in-ongsik khachu kei'n kadang matormong. Khachu Pathian in amun iboolpi khat-um ama ikadang mi ngaisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Hiwahi anuk kajui aleiilaak soom ngai'n inleijet phakhan, inmani'n James li John diang inleiraang, ");
INSERT INTO kfw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","halli Jisu'n asiamruoi rakip ngaikha akoolla akoichunna aleitipi, “Zaatlop tia nilei Reng ngai'n inmani roonna rammachu mi rakip chungnga wai inroon, halli inmani lamkakei ngai'n thomatorna rakip innei. ");
INSERT INTO kfw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ang e-innum hiwahi, nangni karrachu etheinuni, hanna nangni karra miring inkhat in akalok ezoot inchu, ama kha mirakip suok esik eii. ");
INSERT INTO kfw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Halli nangni karra miring inkhat in alukhet ezoot inchu, ama'n mi rakip suok erase, ");
INSERT INTO kfw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ajarchu Miring Sapa hi sepa inthosik-ah kajuo emak, sepa katho sik khat-um mipui kasanring sik-ah aringkhuo kapesik ijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Inmani'n Jericho ah inheiwa, halli Jisu'n asiamruoi ngai khat-um mi katamtak le inheiwa phakhan, bukani mitkacho araming Bartimaeus, Timaeus sapa kha lampui sirra in-ongnga aleiom. ");
INSERT INTO kfw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ama'n Nazareth Jisu eii ti aleijet phakhan, “Jisu! David sapa! kei naminriangro!” tia ama'n inringnga aleikheek. ");
INSERT INTO kfw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mi katamtak in, Omchianro intia ama kha inleiran. Takkha ama'n “David Sapa, kei naminriangro!” tia kheel kheella aleikheek. ");
INSERT INTO kfw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisu'n alei-ngirra aleiti, “Ama kha heikoiru.” Khale inruoiya inmani'n mitkacho pakha inheikoi. Inmani'n inleitipi, “Rok inlang!” “Intheitro, Jisu'n nangkha anaheikoi.” ");
INSERT INTO kfw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Khawa suoli apuon adiar ngaikha adeengjuonna, chungtiang inchoomma, halli Jisu diang aheiwa. ");
INSERT INTO kfw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisu'n aleirakel. “Angme nangsik ah kei ninaminthozoot?” “Karu,” kei kamit kamuzootnook tia amit kachopa khan aheimasang. ");
INSERT INTO kfw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisu'n ama diang aleiti, “Sitro,” “Nang ingamna khan anamindamjei.” Khawapha takkhan amit amuwa khawa lamkhan Jisu nuk aleijui. ");
INSERT INTO kfw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Inmani ngai'n Jerusalem inheinai phakhan, Bethphage khat-um Bethany khuopui koolla, Olive Chingbung khan inmanikha inheiwa. Jisu'n asiamruoi ngai karra miring inni inmatiang aleitir, ");
INSERT INTO kfw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Hin itipile inruoiya: “Ningma ah kaom khuokhan siru. Ningluutli ningluutmak, nangni'n inlachuongmak Salungdai teii inthungnga kaom muningte. Suut-inlang hin heiruoiru. ");
INSERT INTO kfw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tu ka-ang in angsikme inti inchu, hintiru, Karu'n ka-inliingnasik ajar om, halli innottheiya naheithaknook kinte tipiru.” ");
INSERT INTO kfw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Inmani'n insiya lamsirra kaom inn inkhat ma-ah inthungnga kaom Salungdai kha injuomu. Inmani'n insuutlai takkhan, ");
INSERT INTO kfw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mi lekkhat kangirra kaom ngai'n inleirakel, “Angkeme ningtho, angsiyame Salungdai kha ningsuut?” ");
INSERT INTO kfw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Inmani'n Jisu itijek kha inleimasang, khale inruoiya mipui ngai'n inmani kha inleiminsi. ");
INSERT INTO kfw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Inmani'n Salungdai teii kha Jisu diang inheichoi, inpuon ngaikha Salungdai chungnga indaap, halli Jisu'n Salungdai kha aleichuong. ");
INSERT INTO kfw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mi katam tak-in inpuondiar kha lamma inleitha, mi lekkhat in khawa weella kaom thingbuo intuk ah lamkhan inleitha. ");
INSERT INTO kfw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ama ah kasi mi ngai khat-um anuk-ah kahongjui ngai'n inringnga inleikheek, “Hosanna! Pumi ramingnga kajuo ama kha rawaan katha eii! ");
INSERT INTO kfw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Akahongsik nipa David Rengram kha rawaan katha eii, Hosanna insaang khet-ah!” ");
INSERT INTO kfw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisu'n Jerusalem aheitungnga, Biak-inn suungtiang aleiluut, halli angrakip kha takkachangnga alei-en. Takkha kholei jo-e jarra asiamruoi soomleini ngaikhale Bethany tiang inleikir. ");
INSERT INTO kfw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Khawa ziingkhuo warra, inmani'n Bethany makheiya inheikirnook phakhan, Jisu kha awon aleichaampi. ");
INSERT INTO kfw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ama'n raalkhat makheiya abuokatha theichang kuungkhat aleimu, leikarate tia aka-en aleisi. Takkha atungpha khanchu, ama'n abuobei ajuomu, ajarchu theichang karapha kha lei-emak. ");
INSERT INTO kfw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jisu'n theichang kuungdiang aleiti, “Tuteii inkhat innum nang nakuung makheiya nakara kabak ekhaimarasu!” Halli asiamruoi ngai'n ama itihi inleijet. ");
INSERT INTO kfw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Inmani'n Jerusalem inheitung phakhan, Jisu kha Biak-inn tiang aleisi halli phurkajuor khat-um karacho mirakip kha puutna aleiphut. Sialchuoi kamakoi ngai khamtuol khat-um Wathu kajuor ngai lukham rakipkha aleimalet aleimakhup, ");
INSERT INTO kfw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","halli ama'n tuteii-um phurpai heikachoiya kaheiwa ngaikha Biak-inn tuollaidung-um leiminluutmak. ");
INSERT INTO kfw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ama'n mipui ngaikha aleiminchu: “Pathian chong inthiang khan hintia lei-injia emak-abe? ‘Kei inn chu phungli zaat rakip ngai Pathian ninasik inn eii.’ Takkha nangni'n inruup kathongai inthupna ningmin ejei!” ");
INSERT INTO kfw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Thiampu Kalian khat-um Dan kaminchu Karu ngai'n khawakha inleijet, khawa khan ajar eya Jisu thatnasik-ah lam inlei-entok. Inmani ngai'n ama kha inleichi, ajarchu mipui rakip ngai'n ama chongrilkhan inleingak. ");
INSERT INTO kfw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kholei hei-epha khanchu, Jisu khat-um asiamruoi ngai'n khuopui kha inleimathaan. ");
INSERT INTO kfw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ziingtiang ma-ah, inmani'n lamma inheiwa phakhan, theichang kuungkha aler makheiya akuung katung akaleichar kha inleimu. ");
INSERT INTO kfw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter in aleikasuok kha i-ngaidon khale inruoiya Jisu diang aleiti, “Enro, Karu, theichangkuung khomaak nisaamkha athijei!” ");
INSERT INTO kfw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisu'n inmani diang aleimasang, “Pathian kha ngamnaru. ");
INSERT INTO kfw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kei'n nangni diang inthiangnga kanati, khachu tu ka-ang in amalungnga ingamsam omlekleiya hiwa chinghi inphuk inlang tuipuiya indeengluutro, halli ama'n itikha asuoksik eii tia ngamna inchu, ama diang asuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Khawa jarra kei'n nangni diang kati: Nangni'n Pathian diang angmekhat ningni kaalla, kinmujei tia ngamnaru, halli ningni rakip kha nangnidiang anapesik eii. ");
INSERT INTO kfw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nangni'n kanisik ningngir phakhan, miring khatdiang kahoimak kaomngai rakip kha ngaidamru, khale inruoiya marwaanna kaom ningpa Pathian innum ningmanu ngaikha narangaidamte. ");
INSERT INTO kfw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nangni'n mi ngai ningngaidammak inchu, marwaanna kaom ningpa Pathian innum ningmanu ngaikha ngaidamnuni.” ");
INSERT INTO kfw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Inmani'n Jerusalem khan woikhat inlet-ah inheiwa. Jisu'n Biak-inn suungnga khan asiya omlaikhan, Thiampu Kalian, Dan Karu ngai, khat-um upa ngai'n amadiang inheiwa. ");
INSERT INTO kfw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Halli amadiang injuorakel, “Ang ranak naneiya hiwa ngai rakip nithome? Nangdiang hika-ang thomatorna ranak tu napeme?” ");
INSERT INTO kfw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisu'n inmani diang aleimasang, “Kei'n nangni diang chong khatbit narakel kate, halli nangni'n keidiang ningna masang inchu, kei-um angranak-ah hi ngai rakip hi kithome tihi natipi kate. ");
INSERT INTO kfw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Keidiang naheimasangru, John in baptize minthona ranakkha humakheiya kajuome? Pathian diang makheiya kajuobe emakli miring makheiyabe?” ");
INSERT INTO kfw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Inmaniseng inbiakna inleinei: “Angme eini'n nitisik? ‘Pathian diang,’ makheiya niti innum, ama'n hin atisik, ‘Angjarra, halle, nangni'n John ningngamna makme?’ ");
INSERT INTO kfw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Takkha miring makheiya niti innum” (Inmani'n mipuikha inleichi, ajarchu mirakip in John hi Pathian chongkachoipa eii tia inleilei.) ");
INSERT INTO kfw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Inmani ngai'n Jisu diang inleimasang, “Keini jetkhai mungjei.” Jisu'n inmani diang aleiti, “Angranak kaneiya hi ngai rakip kithome, kei-um nangni diang tinuning.” ");
INSERT INTO kfw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Halli Jisu'n chongminkhina aneiya inmani ngaidiang aleiril: “Apha khat-ah theibombil katho miring inkhat aleiom, theibombil kha aleirakul, theibomju soomnasik ah khur kha-um aleikhuor, khat-um theibom ngaaknasik-ah berteii aleisak. Khawa khale inruoiya ama'n theibombil kha achuon katho mi ngaidiang aleiminhuum, halli inn mathaanna ram khattiang aleisi. ");
INSERT INTO kfw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Theibom rakhoolpha aheitung khanchu, ama'n suok inkhat changsik kasuok ramparman kalei achuon katho mi ngaidiang aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Achuon katho mi ngai'n suokpakha inleisurra inleiwuok, khat-um iteii minchoi lekleiya injuominkir. ");
INSERT INTO kfw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Amapupa khan suok leiilaak inkhat atirnook; achuon katho mi ngai'n ama kha alu inleiwuok hop-ah khat-um enseel musit-ah injuominkir. ");
INSERT INTO kfw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Amapupa kha'n suok leiilaak inkhat aleiminsinook, inmani ngai'n ama kha inleithat; khat-um inmani'n kasi ngai rakip diang khawa khale in-angrip inleitho, mi lekkhat inleiwuok khat-um mi lekkhatchu inleithat. ");
INSERT INTO kfw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mi inkhatbit tirsik-ah kalaom khachu iminriangkhet asapa kha eii. Ahekna ah, ama'n asapa kha achuon katho mi ngaidiang aleiminsi. ‘Kei'n ngamna kanei, suoilekleiya inmani ngai'n kasapa chu khoya leitho inte,’ ama'n aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Takkha achuon katho ngai'n khatli inkhat inlei inbiak, amahi inluokaluok sikpa eii, hongtru, eini'n amahi thattui, halli ama changsik kasuokkha einisik esikjei. ");
INSERT INTO kfw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Khale inruoiya inmani'n asapa kha insurra inleithat halli akaluong kha theibombil raaltiang inleideengjuon.” ");
INSERT INTO kfw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Angme, halle, theibombil mapupa'n athosik?” “Ama'n juota chuon katho ngaikha athatsik eii, halli theibombil kha mi leiilaak diang aminhuumsik eii. ");
INSERT INTO kfw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nangni'n hiwa Pathian chong inthianghi lateel makchube? ‘Inn kasak ngai'n nemna ommakjei tia indeengjuon lungkha akilla kaom nemna kaomkhet lungkha ahong eii ");
INSERT INTO kfw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hiwahi Pumi itho kha eii; mit enna angtuk ngak kaom me!’ ” ");
INSERT INTO kfw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jihudi lamkakei ngaikhan Jisu surnasik inleitho, ajarchu inmani'n hiwa chongminkhi hi inmani diang ama'n iminkhi eii tia inleijet. Takkha inmani'n mipui ngaikha inleichi, khale inruoiya inmani'n amakha inmathaanna inleisi. ");
INSERT INTO kfw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pharisee lekkhat li Herod mi lekkhat Jisu chong rilsial surnasik-ah chong karakel inleitir. ");
INSERT INTO kfw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inmani'n ama diang inheiwa-ah inleiti, “Karu, keini'n kinjet nang kadikbei naril, tuteii diang-um nichi ommak. Nang tuteii meel enleiya, takkha Pathian lam kadikkha naminchu. Keini diang rilro, eini Sinadan dungjuiya Rome Rengpa diang ramparhi nipesikbe penuminbe?” ");
INSERT INTO kfw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Takkha Jisu'n inmani palaak kha imule inruoiya aleimasang, “Angsik ame nangni'n kei nasurnasik ningtho? Dangkapum kha heichoiru, halli kei'n enkate.” ");
INSERT INTO kfw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inmani'n dangkapum inkhat inheichoi, halli ama'n aleirakel, “Tu ramil khat-um tu ramingme hiwahi?” “Caesar,” tia inmani'n inleimasang. ");
INSERT INTO kfw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jisu'n aleiti, “Thajei, hanchu, Caesar takha Caesar diang peru, halli Pathian takha Pathian diang peru.” Halli inmani'n Jisu chongkhan inleingak. ");
INSERT INTO kfw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Khawa phakhan hongkaring ommak kati Sadducee ngai'n Jisu diang inheiwa-ah injuorakel, ");
INSERT INTO kfw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Karu, Moses in hiwa Danhi einisik-ah aleimajia: ‘pasal inkhat athiya khat-um anumei kha sa neileiya ada inchu, khawa pasal u-nai inkhat in chuulmei kha aneisik eii ajarchu sa neinasik, halli in-inei sa kha akathipa sa esik eii.’ ");
INSERT INTO kfw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Apha khat-ah u-nai sari inleiom; upa khetpa kha, inn aleinei halli sa neilekleiya aleithi. ");
INSERT INTO kfw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Halli inni huuinapa khan anumei kha aleinei, ama kha-um sa neilekleiya aleithi. Khawa khale in-angrip-ah inthum huuinapa diang-um aleisuok, ");
INSERT INTO kfw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","U-nai sari katung in numeisanu kha inleinei halli inraya-ah sa neilekleiya inleithi. Hekna ah numeisanu kha-um athijei. ");
INSERT INTO kfw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tuunchu, kathi ngai inraya ah inhongring nookni nikhuokhan, ama kha tu numei esikme? ajarchu inmani sari ngai'n numeisanu kha inleineiwiak.” ");
INSERT INTO kfw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisu'n inmani diang aleimasang, “angtuk nangni ningdik makme, angjarrame ningjetbo? ajarchu nangni'n Pathian chong inthiang emakli Pathian ranakkha jetmakchuwa eii. ");
INSERT INTO kfw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kathi ngai inringnookni khanchu, inmani ngai khachu marwaanna tirton ngaikhale in-angsik eii, khat-um innkanei ti omnuni. ");
INSERT INTO kfw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tuunchu, akathi ngai hongring nookna, Moses imajia suulbuklai kaangna larik munkha teelmakchube? Khawakhan hintia injia, tichu Pathian'n Moses diang aleiti, ‘Kei Abraham Pathian ka eii, Isaac Pathian ka eii, khat-um Jacob Pathian ka eii.’ ");
INSERT INTO kfw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Amahi akaringngai Pathian eii, akathi ngai Pathian emak. Nangni inthiangnga dikmak chujei!” ");
INSERT INTO kfw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dan Karu inkhat ahongnga inmani inbiakkha aleirangai. Jisu'n Sadducee ngaidiang chongmasang katha ileimasang kha aleimu, khantia ama'n Jisu koolla aheiwa-ah aleirakel: “Huwa chongpeii hume araya karra kathakhet?” ");
INSERT INTO kfw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisu'n aleimasang, “Akathakhet khachu hi eii: ‘Rangairu, Israel! Pumi eini Pathian hi inkhatbit eii. ");
INSERT INTO kfw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pumi na Pathian kha namalung pumpuiya, naratha pumpuiya, na-ngaidonna rakip-ah, khat-um naranak pumpuiya minriangro.’ ");
INSERT INTO kfw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Inni huuina akathakhet chongpe kha hi eii: ‘Na-indiang na-inwaipui mi ngaikha napumtak niminriang angnga minriangro.’ Hiwa inni neek-ah aleiilaak akatha chongpeii ommak.” ");
INSERT INTO kfw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dan Karu'n Jisu diang aleiti, “Athajei, Karu! nang in kadik-ah nariljei, khachu Pumi khabit eii Pathian, ama elekleiya Pathian tuteii inkhat-um ommu. ");
INSERT INTO kfw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Halli nang na Pathian kha namalung, na-ngaidonna khat-um naranak pumpuiya minriangro; halli nang napumtak niminriang angnga na-indiang na-inwaipui mi ngaikha minriangro. Hiwa chongpeii inni kajuihi pena munna Pathian diang ran khat-um phurpai kapeneek-ah athawiai.” ");
INSERT INTO kfw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Dan Karu'n singtheiya iheimasang kha Jisu'n amupha khan, Jisu'n amadiang aleiti, “Nang Pathian Rengram khale inlaak makchejei.” Khawa thengnga tuteii inkhat-um Jisu diang chong inkelngam ommujei. ");
INSERT INTO kfw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisu'n Biak-inna aminchuwa leiomlai khan, Ama'n aleirakel, “Ang tilia Dan Karu ngai'n Messiah hi David sapa eii intime? ");
INSERT INTO kfw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ratha Inthiang in David mursuo tak-ah aminti: ‘Pumi khan kei Pumi diang aleiti, Kei'n nang inhalpui ngaikha nakeii nuoiya kadamak laiseng. Kei kachangtiang hin in-ongro.’ ");
INSERT INTO kfw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David apumtak innum ‘Pumi’ tia akoi; kha enchu angjarra Messiah hi David sapa esikme?” Mipui ngai'n Jisu chongkha karok-ah inleirangai. ");
INSERT INTO kfw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ama'n iminchule inruoiya aleiti, “Ensuiru Dan kaminchu ocha ngaikha, inret inruo inchuol kha inluk-ah kasi kahong kamanuom khat-um mi intuupna phaiya khoya inleitho kamanuom, ");
INSERT INTO kfw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Synagogue-ah in-ongna kahoikhet kakadang, khat-um baknamun kahoikhet kakadang, ");
INSERT INTO kfw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Inmani nemnasik-ah chuulmei ngai neinaak kakasut, halli mi ngai musik-ah Pathian diang kasoot-ah kani, inmani ngai rachaakna kha anakhetsik eii!” ");
INSERT INTO kfw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisu'n Biak-inn suungnga sial mintiingna koolla in-ongnga omlai khan, ama'n mi ngai sial machul kha alei-en. Mi inchong ngai'n sial katamtak inleimachul; ");
INSERT INTO kfw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Halli sara ka-ethei chuulmei inkhat hongnga anna inkhatle in-ang sumsenpum inni aleimachul, ");
INSERT INTO kfw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisu'n asiamruoi rakip akoichunna aleitipi, “Kei'n nangni diang inthiangnga kanati khachu hi chuulmei sara-nu khan sial mintiingna kokkhan mirakip neek-ah tamwiai amachul. ");
INSERT INTO kfw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mi leiilaak rakipchu in-inei makheiya inthenli inleipeii; takkha numeisanu khachu, sara ethei innum, inei rakip kha aleipeii, aringnasik rakip kha ama'n aleipewiak.” ");
INSERT INTO kfw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisu'n Biak-inn aleimathaan phakhan, asiamruoi inkhat in amadiang aleiti, “Enro, Karu! lungngai khat-um inhongsak inn-ngaihi angtuk-ah enzoot kaomme!” ");
INSERT INTO kfw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisu'n aleimasang, “Hituk-ah kalok inhongsak inn ngaihi nang namubo? Hinna kaom lungngaihi inkhat in inkhat chungnga inkamma kaom omnuni; lungngai rakip hi alachiam wiaksik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisu'n Biak-inn raalkhat tiang kaom Olive chingbungnga alei in-ongnga omlaikhan, Peter, James, John, khat-um Andrew in ruuk-ah inhongnga amadiang inhongrakel. ");
INSERT INTO kfw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Keini diang narilpiro hiwa ngaihi angtik ah akasuok sikme? Khat-um keini diang natipiro hiwa ngai rakip suoknasi phahi heiwajei ti jetnasik-ah ang alasuok sikme?” ");
INSERT INTO kfw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisu'n inmani diang aleiti, “Tuteii innum nangni kha lamleiitiang naruoimak nasik insingtheiru. ");
INSERT INTO kfw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mi katamtak in, kei ramingnga, heiwa inta intisik eii, ‘Kei ama kha ka eii!’ halli inmani'n mi katamtak lamleiitiang inlakeiruoi sik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nangni'n raalchong khat-um raalthang ningjet phakhan, chimaru. Khawa ngaikha alasuoksik eii, takkha khawa ngai'n aheknapha ejei tichu la-emak. ");
INSERT INTO kfw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Zaat khatli zaatkhat, rengram khatli rengram khat raal inla-inthosik eii; Ram angjet-ah rinok khat-um bukawaang aomsik eii. Hiwa ngai rakip hi nai neimadet naiha kahongmasa kanakha ka-ang eii.” ");
INSERT INTO kfw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Nangni inringtheiru. Nangni nahongsur inta khat-um katar ngaidiang innalaruoi sik eii. Synagogue-ah nangni innalawuok sik eii; Nangni'n Waikaroon ngai khat-um Rengngai maikuungnga kei jarra sakhi kapesik-ah ninglangir sik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Takkha aheknapha heitung ma-ah, hiwa chong kahoihi zaat rakip diang inlarilsik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Halli nangni innasurra khat-um katar ngai chongtanna inna innaruoi phakhan, angme ningrilsik tia ningmalung minpoong maru; apha heitung phakhan, nangni diangnga napeii chongkha rilru, chongngai kha nangnichong enuni takkha Ratha Inthiang diang makheiya akajuo kha eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","A-u anai inkhat in a-u anai inkhat chungnga thinasik-ah alapesuok sik eii, khat-um pa ngai'n insa ngaikha thinasik-ah inpesuok sik eii. Insa ngai innum innu inpa chungnga hong-om inta inlaminthat sik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mi rakip in kei jarra nangni innamatir sik eii. Takkha tu ka-ang in ahekna katung adeimator inchu ringna amusik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ ‘Matir Karuoi Chikaom Inkhat’ A-ngirmun ka-emak munna ngirra kaomkha nangni'n muningte.” (Akateel ngaikha'n ang tiname jetrasu!) “Khawa phakhan tu ka-ang Judea-ah kaom ngai'n chingtiang taanrasu. ");
INSERT INTO kfw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inn chungnga kaom mi khan insuungnga kaom aneinaak kaleisik beiya juchumkhai marase. ");
INSERT INTO kfw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tu ka-ang leiya kaom in puondiar kalum kalei sik-ah inntiang kirkhai marase. ");
INSERT INTO kfw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Khawa phakhan tu ka-ang naikawon khat-um nainu ngaisik-ah angtuk-ah poong kaomsik me! ");
INSERT INTO kfw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pathian diang niru tichu hiwa ngaihi phalbiya asuokmak nasik. ");
INSERT INTO kfw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ajarchu Pathian in manmasituol aboolla inphut atuun katungnga lakasuok ngaimak han angtik niteii-um kasuok maksik akalokkhet poongna nikhuo kha esik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Takkha Pumi'n khawa nikhuo ngaikha aminbongmak inchu, tuteii-um ringthei nunu. Ma ikadang mi ngai sikbitchu, nikhuo ngaikha aminbongpi.” ");
INSERT INTO kfw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Khawa phakhan, tu ka-ang-in nangni diang, ‘Enro, Messiah hin om!’ emakli, ‘Enro, Ama kha son om!’ inti innum ngamna maru. ");
INSERT INTO kfw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tichu Christa omchanna inleem khat-um kadikmak Pathian chongkachoi inhong inlarsik eii. Ethei inchu, Pathian ikadangjei mi ngai-um lamleiitiang minsina sik-ah inmani'n chuon inlak khat-um ngakkaom inthosik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Khawa jarra Inringtheiru! Kei'n apha heitungmaklai angrakip hi kinaleitipi ejei. ");
INSERT INTO kfw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Khawa poongnapha nikhuo thengngachu kani kha aziingsik eii, tha kha-um war nunijei, ");
INSERT INTO kfw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","arsi ngaikha marwaan makheiya injuotasik eii, khat-um lairalak-ah kaom ranak rakip intuulsik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Khawa phakhan Miring Sapa kha suumphai chungnga akul ara-aang khat-um araatnale inruoiya ijuokha ningmusik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ama'n marwaan ahekna makheiya nuoipil aheknakhat katung Pathian ikadang mi ngaikha kakhoomchun sik-ah marwaan tirton ngaikha nuopil rakil mili makheiya aheitir sik eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Theichangkuung diangnga inphut inchuru. Aziik kadoongkha hongcherra khat-um abuo hongsuokjei inchu, nangni'n kholum ahongnaijei tia ningjet. ");
INSERT INTO kfw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hiwa angnga, nangni'n akasuok chuon rakip ningmupha khan, Pumi kha inkharkuung juotungjei ti nangni'n jettaru. ");
INSERT INTO kfw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Inthiangnga kei'n nangni diang kinatipi eii, hiwangai rakip hi asuok maklaiseng hiwa khanghi heknuni. ");
INSERT INTO kfw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Marwaan khat-um nuoipilhi alamangsik eii, takkha kei kachong hichu supmangnga mangnuni. ");
INSERT INTO kfw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Khawa nikhuo li aphakha Apa elekleiya, marwaan tirton ngai innun, Asapa innum, tuteii innum jetmu. ");
INSERT INTO kfw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ensuichakru, Inringru, ajarchu nangni'n aphakha angtik esikme tihi jetmakchu. ");
INSERT INTO kfw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Miring inkhat in asuok ngaidiang inthosi chuon apeli, inn kangaakpa diang inringchak inlang omro iti chong apeya, halli inn mathaanna ram kalaaktak-ah khuol-injil kasi ka-ang eii. ");
INSERT INTO kfw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Inringtheiru, ajarchu inn mapupa kha kholei, zaanchim, arkhuong, emakli ziingtiang hongkir sikbe ti jetmakchu. ");
INSERT INTO kfw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ama'n jetlei theileiya hongduoi innum, ningzaalla ningleiom kha na-intongpui marase. ");
INSERT INTO kfw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Inringchakru, Kei'n nangni diang kitihi, mi rakip diang kiti eii!” ");
INSERT INTO kfw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Chol inchelmak waipool khat-um Rakaanna kahoi nini matiang, Thiampu Kalian khat-um Dan Karu ngai'n ruuk-ah Jisu surli thatnasik lam inlei-entok. ");
INSERT INTO kfw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Eini'n kahoi suungngachu thochamak ajarchu mipui inhaangsik eii, inmani'n inleiti.” ");
INSERT INTO kfw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bethany makheiya Simon inti apumma kaphar ri kaleiroon miring inkhat innna Jisu'n abak a-inna omlaikhan, numeisa inkhat lungngoi beel kasipchei inthiang nard makheiya insum amankatam sariak choiya aheiwa. Numeisanu khan sariak beelkha amakoiya arim kahoi sariak kha Jisu lu-ah aleibun. ");
INSERT INTO kfw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Khanna kaom mi lekkhat in zootmuwa khatli inkhatdiang inlei inti, “hituk-ah arim kahoi sariak hi angsik-ah lailamma iminmang me? ");
INSERT INTO kfw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dangkapum rajathum khella leijoursik kha eii halli sialkha sara ngaidiang leipesik eii!” tia inmani ngai'n numeisanu kha setheiya inleirilthai. ");
INSERT INTO kfw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Takkha Jisu'n aleiti, “numeisanu imanuomkha thorase; angsik ame ning-enrinchak? ama'n keisikbeiya akatha chuonkha athojei. ");
INSERT INTO kfw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sara ngai khachu nangnile amunle apha rakip-ah ningom suom, nangni'n ningsan zootlitak, inmanichu ningsanthei. Takkha nangnile keichu apha rakip-ah omsuom numin. ");
INSERT INTO kfw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ama'n ithomaneii kha itho ejei; sariak arim kahoi kapumma nakanoot hi kapum inreii nasik-ah apha matiang insuuk ejei. ");
INSERT INTO kfw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tuunchu, Kei'n inthiangnga nangni diang kati khachu manmasituol pumpuiya chongkahoi ningril phakhan, numeisanu ileitho rakip hi-um ma ngaidonnale inruoiya ningrilsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Halli Judas Iscariot, asiamruoi soomleini ngai karra kinchel, ama'n Jisu kapesik-ah Thiampu Kalian ngaidiang aleisi. ");
INSERT INTO kfw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Inmani'n inleijet phakhan inleirok, amadiang sial napekinte tia chong inlei-inkhit. Halli Judas in Jisu kha inmani diang aphakacha khat-ah pesik-ah aleiminsuuk. ");
INSERT INTO kfw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chol inchelmak waipool kahoi mansakhet nikhuo, rakaanna kahoi bubaknasik-ah Keelngamteii thatna nikhuoni, Asiamruoi ngai'n Jisu diang inleirakel, “Rakaanna kahoi bubak nasik-ah hun nangsik-ah kaminsuuk nanaminsi zootme?” ");
INSERT INTO kfw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jisu'n asiamruoi inni atirra aleitipi: “Khuopui suungnga siru, halli tuibeella tuikachoi miring inkhat in nantongpuite. Ama kha juiru ");
INSERT INTO kfw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","halli ama luutna inn mapupa diang tiru: ‘Karu'n ati, kasiamruoi ngaile Kei rakaanna kahoi bubaknasik innkha hume?’ ");
INSERT INTO kfw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Halli ama'n chungnga insak inn kaloktak nangni diang naminmute, ang rakip kha khawakhan einisik-ah minsuukru.” ");
INSERT INTO kfw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Asiamruoi ngai'n inmathaanna, khuopuitiang inleisi, halli Jisu itijek angnga inmani'n inlei intongpui; halli inmani'n Rakaanna kahoi bubakna kha inleiminsuuk. ");
INSERT INTO kfw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kholei hei-ephakhan, asiamruoi soomleini ngaikhale Jisu inheiwasuom. ");
INSERT INTO kfw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Inmani'n in-ongnga inbak laikhan, Jisu'n aleiti, “Kei'n nangni diang inthiangnga kanati, ningkarra keile kabaksuom miring inkhat in kei anajuorsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Asiamruoi ngai'n malung kadongle inruoiya inkhat suoli inkhat in, “kei ka-ebe?” intia amadiang inleirakel. ");
INSERT INTO kfw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisu'n aleimasang, “Soomleini ngai karra miring inkhat awaipool keile kheengnga kasunsuompa kha eii. ");
INSERT INTO kfw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pathian chong inthiang khan lei-injia angnga Miring Sapa kha athisik eii; takkha Miring Sapa kajuor amasik achu angtuk-ah rawaan kaseme! Khawa miringkha inleineimak inram akathawiai esik eii!” ");
INSERT INTO kfw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Inmani'n inbaklai takkhan, Jisu'n waipool lekkhat aleiya, aleiminthiang, akatherra, asiamruoi ngaidiang aleisemma aleiti. “Bakru” “Hiwahi kei kataksa kha eii.” ");
INSERT INTO kfw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Khawa suoli Jisu'n rabing kha aleiya Pathian diang aniya inmani diang aleipeii; halli inraya-ah inlei insuom. ");
INSERT INTO kfw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jisu'n aleiti, “Hiwahi mipui sik-ah kaluong Pathian le inzootna kathar kei thisen kha eii. ");
INSERT INTO kfw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kei'n nangni diang inthiangnga kiril eii, khawa nikhuo Pathian Rengramma akathar theibomju ka-inmaklaiseng Kei'n woikhat inlet-ah hiwa theibomju hi innuningjei.” ");
INSERT INTO kfw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Khawa suoli inmani'n Pathian minpaakna la kha insaksuoli Olive Chingbungtiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisu'n inmani ngaidiang aleiti, “Ningraya-ah kei namathaan ningta ninglataan wiaksik eii, ajarchu Pathian chong inthiang in ati, ‘Pathian in Keelngam kakhaalpa kha athatsik eii, halli Keelngam ngaikha inchaangdar sik eii.’ ");
INSERT INTO kfw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Takkha Kei'n kahongringsuo nuk-ah, Kei'n nangni matiang Galilee ah kasisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter in aleimasang, “Mi rakip in innamathaan ngai suok-innum, kei'n nang supmathaan namathaan nuning!” ");
INSERT INTO kfw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisu'n Peter diang aleiti, “Kei'n inthiangnga kati, wini zaantak arkhong in woini hongkhuong ma-ah, nang in kei woithum najetmong natisik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter in rasa inringdet-ah aleimasang, “Kei nangle thisuomsik suok-innum, kei'n nangkha zootmak thonuning!” Asiamruoi leiilaak ngai rakip innum khawa jekkha inleiti. ");
INSERT INTO kfw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Inmani'n Gethsemane inti munkhan inleisi, halli Jisu'n asiamruoi ngaidiang aleiti, “Pathian kanisuung seng hin lei-in-ongru.” ");
INSERT INTO kfw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ama'n Peter, James khat-um John aleiruoi, han rathamor kasiin khat-um malung poongna aleinei, ");
INSERT INTO kfw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","khawa phakhan ama'n inmani diang aleiti, “Thinasik katungnga kamalunghi apoongjei; inringchak inlang hin leiomru.” ");
INSERT INTO kfw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Matiang asidetli, neipilla inbok-ah achathei inchu aphakha madiangnga inphut nakhaipiro tia Pathian diang aleini. ");
INSERT INTO kfw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ama'n aleiti “Pa Pathian,” emak rakip nangdiangchu ethei eii, hiwa rabinghi keidiang makheiya nakhaipiro, kei lungdou emarase, takkha nang nalungdou kha erase. ");
INSERT INTO kfw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ama'n aheikir phakhan inmani'n inzaalla inleiomkha ajuomu, halli Peter diang aleiti, “Simon, nazaalbe? phadan inkhat bit-um nang harmaneii makchebe?” ");
INSERT INTO kfw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Matheemna khan ningchul maknasik “Inringchak inlang Pathian diang niru. Ratha inchu athozoot, takkha taksa khachu asuol.” ");
INSERT INTO kfw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Woikhat asirit-ah chinna khale in-angrip chongnga Pathian diang aleininook. ");
INSERT INTO kfw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Halli Jisu'n ahongnook-ah inmani'n inleizaalnook kha ahongmu ajarchu inmani inmit leimahar maneiimu, halli inmani ngai'n amadiang masangdan leijetmu. ");
INSERT INTO kfw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Woithum huuina ama'n aheiwa-ah inmani diang aleiti, “Tuunkatung ningzaalla soong ninglamachumbe? Ahunjei! Aphakha aheitungjei! Entaru, Miring Sapa hi manu karoonngai kutchungnga inpejei. ");
INSERT INTO kfw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Intheitru, eini'n situi, Kei kanajuor pakha ahongjei!” ");
INSERT INTO kfw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisu'n arilla omlaitak, Upa ngai, Dan Karu-ngai, khat-um Thiampu Kalian ngai hongtir, chem, thal, ramol naangkhuo kachoi mipui ngaile inruoiya, soomleini ngai karra Judas ahongtung. ");
INSERT INTO kfw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kajuorpa ama'n mipui ngaidiang injetna aleipeii: “Kei'n kimazoop ama kha eii, sur inlang kacheet-ah khit-inlang ruoiru.” ");
INSERT INTO kfw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas heitungli heitungmak Jisu diang asiya, “Karu!” tia aleimazoop. ");
INSERT INTO kfw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Inmani'n Jisu kha insurra kacheet-ah inleikhit. ");
INSERT INTO kfw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Khawa khanna ka-ngirra kaom miring inkhat in achem keisuo ah Thiampu Kalian khetpa suok inkhat akuor aleitukthaak. ");
INSERT INTO kfw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Halli Jisu'n inmani diang aleiti, “Inruup kasursik angnga chem, thal, ramol naangkhuo ningchoiya kei kanasursik ninghongbe? ");
INSERT INTO kfw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nisuo rakip kei'n Biak-inna kanaminchuwa nangnile kaleiom, khat-um nangni'n nasurmakchu. Takkha Pathian chong-inthiang khachu huui tungmak thamak.” ");
INSERT INTO kfw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Halli asiamruoi ngai rakip in ama inmathaanna inleitaanwiak. ");
INSERT INTO kfw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Khawa munkhan linen puonkaneem kasil ruothar inkhat Jisu nuk aleijui. Inmani'n ama kha sursik injuotho, ");
INSERT INTO kfw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Takkha apuonsil adeengjuonna aleitaan. ");
INSERT INTO kfw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Halli Jisu kha Thiampu Kaliankhet inna inleiruoi, Dan Karu-ngai, upa-ngai khat-um Thiampu Kalian ngai kha-um inlei-intuup. ");
INSERT INTO kfw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter in kalaak-ah Thiampu Kalian khetpa tuollaidung katung aleijui. Suokngai khale in-ong suomma mei alei-oot. ");
INSERT INTO kfw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Thiampu Kalian ngai khat-um intuup Uparup rakip ngai'n Jisu thatnasik katung chong kapemaneii inlei entok, takkha tuteii-um leimumu. ");
INSERT INTO kfw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mi katamtak in Jisu takchungnga maleisei inleiril, takkha inmani ngai chongkha inkhat-um lei-in-angmak. ");
INSERT INTO kfw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Hin intia miring lekkhat in inhongngirra Jisu chungnga maleisei inleiril: ");
INSERT INTO kfw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Keini'n ma itikha kinjet, ‘miring kut-ah insak Biak-inn hi kaminmangsik eii, halli nithum suungnga kut-ah insakmak inkhat kasaksik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Inmani ngai khannum, inchongpeii kha leiminruolmu. ");
INSERT INTO kfw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Thiampu Kalian khetpa in inmani ngai karra ahongngirra Jisu diang aleirakel, “Inmani ngai'n nang nachungnga chong inrilhi nang iteii-um masangnutinbe?” ");
INSERT INTO kfw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Takkha Jisu'n iteii-um leimasangmak. Inlet-ah Thiampu Kalian khetpa in aleirakelnook, “Rawaan katha Sapa Messiah kha na-ebe?” ");
INSERT INTO kfw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Ka eii,” tia Jisu'n aleimasang, “Halli nangni rakip in Miring sapa kha karaat khetpa akut changtiang in-ong khat-um marwaan suumchungnga ijuokha ningmusik eii!” ");
INSERT INTO kfw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Thiampu Kalian khetpa in apuon katherra aleiti, “Hanchu eini'n sakhi arei laommabe? ");
INSERT INTO kfw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ama'n Pathian irilsekha nangni'n ningjetjei. Angme nangni ningngaidon?” Inmani ngai rakip in amahi kathisik rahoi suok tia inleirilsuok. ");
INSERT INTO kfw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Miring lekkhatchu Jisu kamachilthuon inleiphut, khat-um inmani'n ama kha amit inkhumpiya inleiwuok. “Rilsuokro tume kanawuok kha!” inmani'n inleiti. Khat-um raalmi ngaikhan inleiruoiya ama kha inleikabeen. ");
INSERT INTO kfw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter kha tuolmur nuoiya tuollaidung khan aleiom phakhan Thiampu Kalian khetpa suokngai karra numeisa inkhat aheiwa; ");
INSERT INTO kfw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Numeisanu khan Peter mei oot-ah i-om amupha khan, amadiang enna aleiti, “Nang-um, na eii, Nazareth Jisu le kalei inruoi.” ");
INSERT INTO kfw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Takkha Peter in inlip phirra aleimasang “Angkeme niti kei jetmong,” halli ama'n suok-ah aleisi. Khawapha takkhan arkhong kha aleikhuong. ");
INSERT INTO kfw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Suok numeisanu in amuriit-ah kangirra kaom mi ngaidiang aleirilnook, “Amahi inmani karra inchel mi inkhat eii!” ");
INSERT INTO kfw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Takkha ama'n inlip phirnook. Apha chet tisuo nuk-ah akoolla kangir ngai'n Peter diang inleiti, “Inthiangnga nang inmani ngai karra inkhat na-eii, ajarchu nang-um Galilee makheiya na eii.” ");
INSERT INTO kfw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","“Ama'n chong inkhit-ah khat-um Khomaak insaamma aleiti, kei nangni iril mipahi jettakmong!” ");
INSERT INTO kfw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Khawapha takkhan arkhong kha'n woini huuina ahongkhuong, halli Jisu'n amadiang ileiril “Arkhong woini hongkhuong ma-ah, nang in woithum keikha najetmong natisik iti chongkha ahongngaidon.” Halli Peter in amalung intooktheiya aleichap. ");
INSERT INTO kfw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ziingtiang ma-ah Thiampu Kalian ngai'n innottheiya upa ngai, Dan Karu ngai, khat-um uparup ngai khale intuup-ah chong inleiminsuuk. Jisu kha inkhit-ah inleiruoi, halli Pilate diang inleipeii. ");
INSERT INTO kfw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate in Jisu diang aleirakel, “Nang Jihudi ngai Reng kha na-ebe?” Jisu'n aleimasang, “Nang itikha ejei.” ");
INSERT INTO kfw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Thiampu Kalian ngai'n Jisu kha kheella inleirilsiat, ");
INSERT INTO kfw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate in Jisu diang inlet-ah aleirakel, “Nang namasang nutinbe? Rangairo inmani ngai rakip in nachungnga innarilsehi!” ");
INSERT INTO kfw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Takkha Jisu'n chongbai inkhat-um leimasang nookmak, khawajarra Pilate in aleingak. ");
INSERT INTO kfw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Rakaanna kahoi inthoracham insurra indangai karra mipui imanuom miring inkhat kha Pilate in aleimasuo kachak. ");
INSERT INTO kfw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Barabbas inti raalruuk ngaile mikathat miring inkhat mikhumna ah aleiom. ");
INSERT INTO kfw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mipui'n inhei intuup-ah inleithojol angnga thoritnasik-ah Pilate diang inhongti, ");
INSERT INTO kfw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilate in mipui ngaidiang aleirakel, “Nangni sik-ah Jihudi Rengpa kimasuo ningmanuombe?” ");
INSERT INTO kfw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Thiampu Kalian ngai'n Jisu injuopena ajarchu inmani ngai'n inleira-ot jarra eii tia Pilate in aleijet. ");
INSERT INTO kfw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Takkha Jisu rathuulla Barabbas kha masuonasik Pilate diang tiru tia Thiampu Kalian ngai'n mipui ngaidiang inleimasok. ");
INSERT INTO kfw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Mipui ngaidiang inlet-ah Pilate in aleiril, “Halle, nangni'n Jihudi ngai Reng tia ningkoi padiang kei angme ningnamin-thozoot?” ");
INSERT INTO kfw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mipui ngai'n inlet-ah inleikheek, “Cross-ah makai inlang thatro!” ");
INSERT INTO kfw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Takkha Pilate in aleirakel, “Angjarra, ama'n angtak masialna aleithome?” “Cross-ah makai inlang thatro!” intia inmani'n inringsit-ah inleikheeknook. ");
INSERT INTO kfw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate in mipui malungkha aleimintaizoot jarra Barabbas kha inmani sik-ah aleimasuo, Halli Jisu kha natheiya aminwuok suoli cross-ah makaili thatnasik-ah aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Raalmi ngai'n Jisu kha Ramkaroonpa inn tuollaidung suungnga inkeiluut khat-um raalmi rahooi rakip inlei inkoichun. ");
INSERT INTO kfw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Inmani'n purple puon inchuol kha Jisu inleiminsooi, raling lukhu kha inboolla ama lu-khan inleiminkhu. ");
INSERT INTO kfw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Halli inmani ngai'n “Jihudi rengpa naringkhuo seirase!” tia chubei inleitho. ");
INSERT INTO kfw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Inmani ngai'n Jisu lukha tuoitung pumma inleiwuok, halli ama kha inleimachilthuon, inkinbok-ah chubei inleitho. ");
INSERT INTO kfw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Inmani'n in-innuipui suoli, purple puon inchuol kha inliikpiya ama puondiar kha inleiminluknook, halli inmani'n cross-ah makaili thatsik-ah inleiruoi. ");
INSERT INTO kfw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cyrene makheiya araming Simon inti Alexander li Rufus pa khuopuisuung kaluutsik-ah ram inkhat makheiya kaheiwa miring inkhat insina lamma inmani'n inkintongpui, halli raalmi ngai'n Simon kha Jisu cross kha azootmak pumma inleiminpuut. ");
INSERT INTO kfw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Inmani ngai'n Jisu kha Golgotha inti munkhan inleiruoi, khawa tinachu “Luruok reiina mun iti eii.” ");
INSERT INTO kfw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Khawa khan inmani'n theibomju li myrrh inminchunna ama diang inleipeii, takkha Jisu'n inpimak. ");
INSERT INTO kfw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Halli inmani'n cross-ah inmakaiya ama puondiar kha inmani'n inlei insem, tu-in angkachang puonlek kha achangsikme intia rasi inlei-en. ");
INSERT INTO kfw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ziingtiang phadan kuo chulpha khan Jisu kha cross-ah inleimakai. ");
INSERT INTO kfw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ama enzootmakna jarkha hintia injia: “JIHUDI NGAI RENGPA.” ");
INSERT INTO kfw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jisu le inruup inni-um changtiang inkhat weitiang inkhat cross-ah inlei makaisuom. ");
INSERT INTO kfw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Raalruuk ngaikhale inteelchun suomma, Pathianchong inthiangkha huui mintung. ");
INSERT INTO kfw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mi kasi kahong ngai'n inlu inkathuk-ah jakna kaom chongrilkha Jisu diang inleiril: “Oho! Biak-inn kaminmangsik, khat-um nithumma kasakrit sipa! ");
INSERT INTO kfw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tuun cross makheiya juochum inlang napumtak insanro!” ");
INSERT INTO kfw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Khawale in-angrip chongkha Thiampu Kalian khat-um Dan Karu ngai'n Jisu diang indeiiya inlei innuipui, khatli khat inlei-inti, “Ma'n mi ngai khachu akatan, takkha apumtakchu intan matormak! ");
INSERT INTO kfw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Christa Israel ngai Rengpa, cross-ah inphut tuun juochumro, halli nijuochum kha kinmuli keini'n na-ngamna kinte!” Halli Jisu le inmakaisuom miring inni ngai-innum amadiang indeiiya inlei innuipui. ");
INSERT INTO kfw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Suunchim hong-epha makheiya phadan inthum katung ram rakipkha aleiziing. ");
INSERT INTO kfw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Phadan inthum juochul phakhan Jisu'n “Eloi, Eloi, lema sabachthani?” tia inringnga akheek-ah aleiti, khachu “Kapathian, Kapathian, angjarra nangin keidiangnga inphut khattiang nina-inletdelme?” tina eii. ");
INSERT INTO kfw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akoolla kangirra kaom Jisu iti kajet mi lekkhat ngai'n inleiti, “Enru, Elijah eii ikoi!” ");
INSERT INTO kfw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Miring inkhat in ataanna tuipompuon kha theibomju kathur khan anoomma halli khuoichu ramol morra akathilla Jisu baiya ahongsoonna aleiti, “Ngaakdirui, Elijah ajuo ah cross-ah inphut akeithaakbe eini'n enrui!” ");
INSERT INTO kfw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Halli Jisu'n inringnga akheek-ah arang chatjei. ");
INSERT INTO kfw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Biak-inna induong puonkha, achung makheiya anuoikatung lekniya alei-inther. ");
INSERT INTO kfw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cross kuungnga ngirra kaleiom raalmi rajakhat ngai Lamkakeipa'n Jisu ithi omchan amupha khan. “Hi miring hi inthiangnga Pathian Sapa eii!” aleiti. ");
INSERT INTO kfw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kalaak-ah numeisa lekkhat in in-enna inleiom, inmani ngai karra Mary Magdalene, Joses li anaipa James nu Mary, halli Salome inlei eii. ");
INSERT INTO kfw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jisu'n Galilee ah aleiomlaiya inmani'n anuk inleijui khat-um sepa inleitho. Aleiilaak numeisa katamtak-um amale Jerusalemma inheiwa. ");
INSERT INTO kfw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jihudi ngai Sernikhuo madet insuukna nikhuo kholei ejarra, ");
INSERT INTO kfw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimathea makheiya Joseph, uparup ngai karra kaya kaom, khat-um Pathian Rengram kajuosik kangak, ama'n kachi omleiya Pilate diang asiya Jisu kaluong aleini. ");
INSERT INTO kfw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jisu kha thijei ti aleijet phakhan Pilate in aleingak. Raalmi rajakhat lamkakeipa kha akoiya Jisu athitakbeyei tia aleirakel. ");
INSERT INTO kfw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Raalmi rajakhat lamkakeipa chong arangaisuo nuk-ah, Pilate in Joseph diang akaluong kha aleipeii. ");
INSERT INTO kfw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph in akaluong kha cross makheiya ajuokeithak, linen puon kaneemma aleikatuomma lung makheiya inkawit thaanna aleireii. Halli lung kalok inkhat amalet-ah thaankha aleikhar. ");
INSERT INTO kfw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene khat-um Joseph nu Mary in Jisu kaluong inreiikha inleimu. ");
INSERT INTO kfw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jihudi ngai sernikhuo thengli Mary Magdalene, James nu Mary, khat-um Salome inmani ngai'n inhongnga Jisu kaluongkha kanootsik-ah sariak arim kahoi inleiracho. ");
INSERT INTO kfw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Khuoserni ziingtiang ma-ah, kani hongsuoklim phakhan, inmani'n thaankhan inleisi. ");
INSERT INTO kfw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Inmani'n insina lamma inkhatli inkhat inlei-inti, “Thaankhar lungkha tu-in einisik-ah namaletpi sikme? Takkha inmani'n inlei-en phakhan lungkha alei-inletsuo kha inleimu. ");
INSERT INTO kfw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ajarchu (kaloktak lung alei eii) inmani'n thaankha inleiluut, khawakhan inchuol puonkabang inluk khangdoong inkhat changtiang in-ongnga kaomkha inleimu, halli inmani'n inleingak khat-um inleichi.” ");
INSERT INTO kfw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“Inlai maru,” Ama'n aleiti. “Kei'n kajet cross-ah inthat Nazareth Jisu kha eii nangni'n ning-entok, ama hin ommakjei ama aleiringjei! Enru, ama inreiina munkha hin eii. ");
INSERT INTO kfw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tuun si-inlang hiwa chonghi Peter le inruoiya asiamruoi ngaidiang jominjetru, ‘nangni matiang ama'n Galilee ah asijei; halli ama'n ileiti angnga sowason mujei ningte.’ ” ");
INSERT INTO kfw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Khale inruoiya inmani'n ininlaiya khat-um kachi'n asip-ah thaan makheiya insuok-ah inleitaan. Ajarchu Inmani'n inleichi heijarra tudiang-um chong leirilmu. ");
INSERT INTO kfw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Khuoserni ziingtiang Jisu'n ahongring suoli, ama'n raikhuo sari ileipuut suokpi, Mary Magdalene diang mansakhet-ah alei-inlar. ");
INSERT INTO kfw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ama'n asiya Jisu'n inruoipui mi ngaidiang aleirilpi, inmani ngaikha inmalung inwaiya inchap-ah inleiom, ");
INSERT INTO kfw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","takkha Jisu ringjei khat-um Magdalene in kamujei itipikha, inmani'n lei-ngamnamu. ");
INSERT INTO kfw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Hiwa thengnga, Jisu'n miring innidiang khuo lamma insiya inleiom phakhan Meelsuo khat-ah inmani diang alei-inlar. ");
INSERT INTO kfw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Inmani'n inkirra aleiilaak mi-ngaidiang inleirilpi, takkha inmani'n lei-ngamnamu. ");
INSERT INTO kfw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Khawa thengnga asiamruoi soomleikhat ngai'n inbak ah inomlaitak khan Jisu'n inmani diang alei-inlar. Inmalung kangar khat-um inngamna insuol jarra inmani kha aleiran, ajarchu ama karing kamu-ngai chong kha-um leileimu. ");
INSERT INTO kfw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ama'n inmani diang aleiti, “Manmasituol pumpuiya si-inlang chong kahoihi miring rakipdiang juorilru. ");
INSERT INTO kfw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tu ka-ang in a-ngamna ah baptize katho mi kha ringna amusik eii; tu ka-ang ka-ngamnamak mi khan thina amusik eii. ");
INSERT INTO kfw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ka-ngamna mi ngaidiang inlak thomatorna ranak apesik eii: Inmani'n raikhuo ngaikha kei karamingnga inpuutsik eii; Inmani'n chong kathar inrilsik eii; ");
INSERT INTO kfw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Inmani'n maruul inmahuum emakli tur in-in innum, inmani diang iteii intook omnuni; inmani'n kana-ngai chungnga inkut induongsik eii, halli akana ngaikha indamsik eii.” ");
INSERT INTO kfw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pumi Jisu'n inmani diang arilsuoli, ama kha marwaan tiang inruoijei halli Pathian changtiang in-ongjei. ");
INSERT INTO kfw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Asiamruoi ngai'n insiya amun rakip-ah Pathian chong inril, halli Pumi'n inmani ngaikha inruoipuichak, khat-um in-itho chuon inlak ngaikhan inmani chongril ngaikha adik tia amalar Amen.");
INSERT INTO kfw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Minriang kaom Theophilus: Eini karra kaleisuok omchan rakip jarra mi katamtak in inmaneiseng majianasik inleingaidon. ");
INSERT INTO kfw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Inphutna makheiya inmit tak-ah kaleimu ngai'n einidiang naleiti khat um naleirilpi chongngaikha inmani'n inmajiajei. ");
INSERT INTO kfw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eh, intor Theophilus, hiwa thurchi jarra inphutna makheiya kei'n incheenna ki-entok rakipkha amason kaomma nangnadiang majia matorkate tia kei'n kangaidon. ");
INSERT INTO kfw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Khawajarra nangnadiang naleiminchu angrakip ngaikha nang in incheenna najetnasik-ah kei'n hiwahi kimajia eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herod Judea reng alei elai, Abijah phungrui makheiya Thiampu inkhat araming Zechariah inti aleiom, ama numeikha Aaron phungrui makheiya alei eii, araming kha Elizabeth inti. ");
INSERT INTO kfw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Inmani'n Pathian diang kadik ah inleiom, Pumi chong li Dan kha katha ah inleijui. ");
INSERT INTO kfw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Takkha inmani'n sa-chu leineimu, ajarchu Elizabeth hi wonkachoimak alei eii, halli inmani innireella upa-um inlei ejei. ");
INSERT INTO kfw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zechariah in biak-inna Thiampu inkhat-ah Pathian sepa aleitholai, ");
INSERT INTO kfw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Thiampu ngai sina Dan dungjuiya, rasi in-enna, ama kha Pumi biak-inna arimkahoi Berou kahaalsik-ah inleikadang. ");
INSERT INTO kfw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Arimkahoi berou inhaal phakhan mipui katamtak in toulla nina inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Halli Pumi Tirton kha arimkahoi haalna maichaam pena mun changtiang a-ngirra amadiang alei inlar. ");
INSERT INTO kfw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah in ama kha amuphakhan alei-inlai, halli ama'n china aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Takkha Marwaan Tirton in aleiti, “Chimaro, Zechariah! Pathian in nang inikha anara-ngaipijei, halli nang nanumei Elizabeth kha sapasal inkhat neita ama raming John natisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nang in angtuk hoinali rokna naneisikme ama innei phakhan, halli mipui kha-um rokna inneisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pumi mit-enna ama kha kalok esik eii, ama'n ju emakli jusak innuni, anu wonsuungnga inphut Ratha inthiang in asipsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Halli ama'n Israel mi katamtak Pumi Pathian diang ahei keikirnooksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","John in ajar eya innu inpa ngai'n insa ngaikha kheella ingaidon. Halli hiwa angnga, atuunna chongkajuimak mi ngai khaum Pathian minngaidon sik eii. Halli John in mipui ngaikha Pumi sikbeiya inringchak ah minom nasik ah ama'n Elijah ratha khat-um ranak angnga ama'n Pumi matiang asisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah in marwaan tirton diang aleiti, “Angtho thowa hiwahi kajetsikme? Kei um upa ka-ejei halli kanumei um upa ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“Kei Gabriel kaei” Marwaan tirton in ati, “Kei Pathian maikuungnga kangir Gabriel ka eii, nangnadiang hiwa chong kahoihi kanarilpisik ah najuotir eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Enro, nang in chongkha riltheinutin, ang rakiphi asuok maklaiseng, ajarchu apha dungjuiya kasuoksik kachong ngaihi nang in inngamna makchejei.” ");
INSERT INTO kfw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Halli mipu'n Zechariah kha inleingaak, khat-um biak-inn suungnga kasoot ah aleiom jarra ngakna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ama'n aheisuok phakhan, inmani diang chongkha leiril matormakjei, khale inruoiya imani'n inleijet, biak-inna mangtalar leimujeite, ajarchu chong leisuokmak jarra akut ah injetna omchan aleithopi. ");
INSERT INTO kfw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Achuon thonasik nikhuo ngaikha ahekli Zechariah in inntiang aleisijei. ");
INSERT INTO kfw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Apha sootlekleiya anumei Elizabeth kha nai leiwonna tha ra-nga tuol suoklekleiya innna aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Awinichu Pumi'n kei kadiang anasanjei,” “Halli ama'n aleiti, kei kadiang mipui'n rilse nakha ama'n nakhaipijei!” ");
INSERT INTO kfw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth naiwonna tharuk ahongtung phakhan Pathian in tirton Gabriel kha Galilee khopui suungnga kaom Nazareth khuo khan ajuotir. ");
INSERT INTO kfw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","David phungnga Joseph diang inbiakjei inthiang numeisa chungnga Pathian tirton aleijuo, halli inthiang numeisanu kha Mary inti, ");
INSERT INTO kfw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Halli marwaan tirton kha ajuoa ati, “Nang nadiang kadai omrase! Pumi kha nang nachungnga aom, Numeisa ngai karra nanghi rawaan kathakhet na eii!” ");
INSERT INTO kfw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Takkha ama'n marwaan tirton chongkha ajet phakhan amalung upleiminchaak, angkachang chongme tia amalungnga lei-inngaidon. ");
INSERT INTO kfw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Marwaan tirton in amadiang ati, Mary, “China neimaro, Pathian minriang nakha nangnadiang omjei. ");
INSERT INTO kfw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Enro, nang in napum inrikta pasal inkhat naneisik eii, halli ama raming Jisu tinata nakoisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ama kha kalian e-sik eii, halli insaangkhet Pathian sapa tia inkoisik eii, khat um Pumi Pathian in amadiang apa David reng in-ong nakha apesik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ama'n Jacob phungruiya hektik kaboiya reng achangsik eii, halli Ama Rengram kha haktik omnuni!” ");
INSERT INTO kfw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary in Pathian tirton diang aleiti, “Kei inthiang numeisa ka eii, angtho thoa hiwahi etheiniyame?” ");
INSERT INTO kfw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Marwaan tirton in khawa neinudiang amasang, “Ratha inthiang in nang nadiang ajuosik eii, halli Pathian ranakkha nang nadiang namakhusik eii, hiwajarra nang in nai neinata inthiang naiteii ramingkha Pathian sapa intisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Enro, nang naphung Elizabeth kha, upa e-innum pasal inkhat awonjei, halli wonkachoimak intinukha atuunchu tharuk ejei. ");
INSERT INTO kfw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tichu, Pathian diang angrakip ka e-matormak ommak.” ");
INSERT INTO kfw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary in ati; “Kei Pumi suoknu ka-eii,” “Nang iti chongkha kei kadiang isuok erase.” Halli Pathian tirton in aleimathaanjei. ");
INSERT INTO kfw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mary in innottheiya intheiya khawa chingram Judea khuopui khan aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ama'n Zechariah inn kha leiluut ah Elizabeth diang inpaakna chong aleipei. ");
INSERT INTO kfw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Halli Elizabeth in Mary inpaakna chong aleijet phakhan, awonsuung makheiya naiteikha siing hong-insa halli Elizabeth kha Ratha Inthiang in aleisip. ");
INSERT INTO kfw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ama'n inringnga ahongkheek, “Numeisa ngai karra nanghi rawaan katha na eii, khat um nawonsik naiteii kha-um rawaan katha esik eii! ");
INSERT INTO kfw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tichu Pumi nu'n keidiang i-najuophahi angjarra hiwa ka-ang kalok chuonhi keikadiang isuokme? ");
INSERT INTO kfw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Enro, nang minpaakna rasa kajet phakhan, kawon suungnga kaom naiteii khan arok-ah lei-inchoom. ");
INSERT INTO kfw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pumi'n angrakip kasuoksik amadiang chong irilpi ngaikha kangamnajei ama kha, rawaan katha eii!” ");
INSERT INTO kfw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary in aleiti, “Kamalungnga Pumi kha kaminpaak; ");
INSERT INTO kfw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Karatha'n kanakatanpa Pathian diang karokpui, ");
INSERT INTO kfw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ajarchu keihi ama suok kasiinkhet ka e-innum ama'n ana-ngaidon! ­­­­­­­­­ Atuun makheichu, mi rakip in keihi rawaan kathanu innatisikjei. ");
INSERT INTO kfw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ajarchu Karaat khet Pathian in kei kadiang kalian choun athojarra eii. Araming kha inthiang eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ama minriang nakha Ama khoya katho midiang khang rakip ah aminmu. ");
INSERT INTO kfw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ama ngarna abaankha aduong halli in-or miringngai i-ngaidon kha aminmangpi. ");
INSERT INTO kfw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pathian in rengkalian ngaikha in-ongna mun makheiya aminpur, halli inniam mikha kadomsaang. ");
INSERT INTO kfw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ama'n won kachaam karaal ngaikha katha ah leiwaisip, halli inchong rakipkha kutkaruok ah leiminsi, ");
INSERT INTO kfw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ama minriang nakha inngaidonna sik ah Asuok Israel ngaikha aleisan, ");
INSERT INTO kfw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ama'n nipi nipu ngaidiang ileiril angnga, Abraham khat-um ama tu-lesa rakip diang um hektik kaommak minriang nakha minmurase!” ");
INSERT INTO kfw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary in thathum Elizabeth le inleiom halli ama'n inntiang aleikirnook. ");
INSERT INTO kfw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth nainei nasik pha alei-eya, ama'n sapasal inkhat aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ama indiang inwaipui ngaili a-u-ngai'n Pumi minriangna loknakha amadiang om tihi inleijet ah amale roksuomna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Niriat huuini naiteii kha wuntannasik-ah inleisi, halli inmani'n apa raming kajuisik ah ama ramingkha Zechariah tia inleikoizoot. ");
INSERT INTO kfw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Takkha anu'n aleiti, “Chamak! ama raming John nitisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Inmani'n anudiang inleiti, “Atuteii nangni insuungkurra hiwa raming karoon ommu!” ");
INSERT INTO kfw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Khale inruoiya inmani'n apa diang angkachang raming natisikme tia jettheinasik-ah inleirakeel. ");
INSERT INTO kfw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah in majianasik lungpeek kha aleiniya aleimajia, “Ama ramingchu John.” Halli inmani rakip in ngakna inleinei! ");
INSERT INTO kfw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Khawapha takkhan Zechariah in chong hong riltheinook-ah Pathian minpaakna chong ahongriljei. ");
INSERT INTO kfw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ama sirpangnga kaom ngaikhan kachi'n aleisip, halli hiwa jarra Judea chingram suungnga kaom khuo rakipdiang inleirilthang. ");
INSERT INTO kfw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hiwajarra kajet mirakip in inmalungnga inlei-inkel, “Angme hiwa naipangpa'n hong e-sik?” Pumi chuontho kha amadiang om. ");
INSERT INTO kfw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John pa Zachariah kha Ratha Inthiang in asip ah Pathain chong aleiril: ");
INSERT INTO kfw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel Pumi Pathian kha minpaakru, Ama'n ami ngai kasansik aleijuo halli ami ngaikha akatanjei,” ");
INSERT INTO kfw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Asuok David phungrui makheiya, ama'n einisik ah akalian Nakatanpa Pumi anapejei. ");
INSERT INTO kfw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ama chongkhit nakha inthiang Pathian chongkachoi ngaidiang tialleiya inphut inleiril, ");
INSERT INTO kfw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tichu, ni inhalpui mi makheiya anasansik, ranak kanei ni-inhalpui rakip kutchungnga anasansik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ama riangwai chongkhit nakha nipi nipu ngaidiang minmunasik. Halli ama inthiang inzootnakha ngaidonnasik. ");
INSERT INTO kfw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nipa Abraham diang chongkhit nale inruoiya, ");
INSERT INTO kfw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ama'n eini ni-inhalpui mi ngai makheiya nasannasik eii tia chong inkhetna naleipei, halli ama kha kachi omlekleiya sepa thothei nasik anazootpi. ");
INSERT INTO kfw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Eini ringkho omlaiseng ama maikuungnga inthiangnga niomsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nang, kei kasa, Insaangkhet Pathian chong kachoipa innatisik eii. Nang in Pumi neek ah ma-sanata ama lamkha naboolsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","inmani manu ngaikha ngaidampita ama mi ngaikha kalakatansik eii tia tipinasik eii. ");
INSERT INTO kfw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ajarchu Pathian chu minriang kasip eii, Ama'n sanminring nakha ziingtiang khowar angnga einidiang aminwar ");
INSERT INTO kfw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kaziingnga kaom ngaili thina raliya kaom ngaidiang war inchangnasik, ama'n kadai lamtiang lam nakeiruoisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Naiteikha insoonna taksali Ratha ah ahong raatjei, halli ama'n Israel mirakip maikuungnga inlar maklaiseng ramruok khan aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Augustus rengpa'n Rome ramsuungseng milu teelnasik-ah chong aleipeii phakhan, ");
INSERT INTO kfw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Quirinius in Syria wairoon suungnga hiwahi ma-insakhet milukateel kha a-eii. ");
INSERT INTO kfw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mirakip in inmani inmani khuopui suungnga inraming kapeluut inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph um Galilee inti Nazareth khopui makheiya Bethlehem tia inkoi David khopui Judea ramsuungnga aleisi, ajarchu ama kha David phungrui e-jarra eii. ");
INSERT INTO kfw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ama numei ka-esik naikawon Mary khale raming kapeluut inleisi, ");
INSERT INTO kfw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","halli inmani'n Bethlehemma inleiom phakhan, nainei nasik pha alei ejei. ");
INSERT INTO kfw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mary in sapasal ma-insakhet aleinei, khale inruoiya puonna leikasuunna, sarakuong suungkhan aleiminzaal, ajarchu inmani'n omnasik innkha leiommak. ");
INSERT INTO kfw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Khawa phakhan keelngam kakhaalngai kha, keelngam khaalna munna keelngam kha zaalsoot inngaak ah inleiom. ");
INSERT INTO kfw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pumi marwaan tirton kha inmani diang aleiinlar, han Pumi poinakha inmani diang aleiminmu, halli inmani kha kachi'n aleisip. ");
INSERT INTO kfw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Marwaan tirton in inmani diang aleiti, “Chimaru! Kei'n mirakip roknasik chong kahoikha nangnidiang kajuochoi. ");
INSERT INTO kfw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Awini nikhuohin Kanasanpa Christa Pumi kha David khopuiya inneijei. ");
INSERT INTO kfw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hiwahi nangnisik-ah jetna eii; nangni'n naiteii kha puonna kasuun inta sarakuongnga inleiminzaal kha ningjuomusik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jetlei theileiya tirton khale marwaan raalmi tirton katamtak in Pathian minpaakna laa injuosak; ");
INSERT INTO kfw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Marwaan insaangnakhet khan Pathian lurlian nakha omrase, halli ama kaminriang mi rakipdiang manmasituolla kadaikha omrase!” ");
INSERT INTO kfw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tirton ngai'n marwaan tiang inleikir phakhan, keelngam kakhaal ngai'n khatli khatdiang inlei inti, “Pumi'n einidiang ileiti ngaihi, Bethlehemma juosi inlang angrakip kasuok ngaikha juoenrui.” ");
INSERT INTO kfw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Khale inruoiya inmani'n innottheiya insiya mary li Joseph kha injuomu halli naiteii kha-um sarakuongnga inminzaalla inleidakha injuomu. ");
INSERT INTO kfw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Inmani'n neiteii kha injuomu phakhan, Tirton kha'n naiteii jarra ileiril rakipkha inmani diang inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Keelngam kakhaal ngai'n inril chong kajet mi rakip in ngakna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary in inmani'n inleiril chong rakip ngaikha kathatak ah amalung suungnga aleingaidonrep. ");
INSERT INTO kfw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Keelngam kakhaal ngai'n inleikirra inmani diang Pathian tirton in ileirilpijek kha injuomu injuojet jarra Pathian kha inminlur inminlianna inleiminpaak. ");
INSERT INTO kfw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wuntan nasik niriat honghuui phakhan, marwaan tirton in ama kha inwonma ah araming inleiphuopi angnga, aramingkha Jisu inleitijei. ");
INSERT INTO kfw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moses Dan chongpei dungjuiya Joseph li Mary in naiteii kha minthiang nasikpha ahongtungjei. Khawale inruoiya naiteii kha Pumi diang peluutnasik-ah Jerusalemma inleichoi, ");
INSERT INTO kfw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pumi Dan khan hinthoa leiinjia angnga, “Pasan ma-insakhet ah innei rakipchu Pumi diang minthiangnasik-ah inpeluutsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Halli Pumi Dan khan areiom iti dungjuiya, “Wathu inni, emakli pharbaliteii inni kha penasik-ah inleichoi.” ");
INSERT INTO kfw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jerusalem ma miring inkhat araming Simeon inti aleiom, ama kha kadik khat um Pathian kachi mi alei eii, halli Israel ngai sanminringna kamusik-ah kangaak chak ah kaom mi kha-um aleieii. Ratha Inthiang khan amadiang alei-inruoipui ");
INSERT INTO kfw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","halli Pumi chong inkhitna ah ipei Messiah kha namumaklaiseng thinutin tia amadiang inngamna-um aleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeon kha Ratha in inruoipuiya biak-inna aleiluut. Dan dungjuiya anuli apa'n naiteii Jisu kha biak-inna inleiruoi phakhan, ");
INSERT INTO kfw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon in naiteii kha akut-ah pomma Pathian leiminpaak ah ati: ");
INSERT INTO kfw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Pumi atuun chu, nang chong inkhitnakha namintungjei, nasuok keihi kadaiya naminsitaro. ");
INSERT INTO kfw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nang Sanminringna kha kamit tak-ah kamujei. ");
INSERT INTO kfw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nang in mipui maikuungnga nileimisuukpikha. ");
INSERT INTO kfw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hiwa war in zaatlop ngaidiang nalungdou minmunasik, halli nang lurlian nakha nang nami Israel ngaidiang minmusik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon in naiteii jarra irilpi chong rakip kha anu li apa'n aleijet phakhan inleingak. ");
INSERT INTO kfw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Halli Simeon in inmani diang rawaan aleipeiya Mary diang aleiti, “ Hiwa naiteii hi Israel ngaidiang insuina khat um sanminringna angjet kapesik-ah Pathian in ikadang ejei. Ama'n Pathian injettheina eta miring angjet in enhal-inta inrilsesik eii, ");
INSERT INTO kfw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","halli inthup ah kaom inmani ngaidonna ngaikha malarsik eii. Halli malung kasekha chemlujumma innasun angnga namalungkha asunkhoisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pathian chong kachoi numeisa araming Anna inti Phanuel sanu Asher zaat makheiya inkhat aleiom, ama kha upa lei ejei halli inn aneiya aruotharle kumsari bit aleiom, ");
INSERT INTO kfw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","halli ama'n kumsoomriat leimili katung chuulmei inkhat eya aleiom, halli ama'n biak-inn kha leimathaan lekleiya suunli zaan Pathian chubei thoa bu ngeiya Pathian niya aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Khawapha takkhan numeisanu kha-um heitungnga Pathian leiminpaak ah Jerusalem katannasik-ah Pathian kangak mi ngaidiang naiteii jarra aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josheph li Mary in Pumi Dan dungjuiya angrakip thodan kasuok ngaikha inminhek ah Galilee ramsuungnga kaom inmani khopui Nazareth ah inleikirjei. ");
INSERT INTO kfw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Naiteii kha ahong in-soonna ahongngarjei; singnatheina'n leisip ah Pathian rawaan kha amadiang aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kumsuoa Jisu nuli apa kha Jerusalemma rakaanna kahoi inchelsik-ah inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisu kha kum soomleini ahong ephakhan a-ngai angnga inmani'n Jerusalemma rakaanna kahoi inchel inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kahoi kha hakli inmani'n inntiang inleikir phakhan, Jisu'n Jerusalemma aleiom, anuli apa inchu leijetmu. ");
INSERT INTO kfw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inmani karra inchel tia suunsoot lamkhan inleisi, halli inmani'n Jisu kha insuungkhur ngaili insappui ngai karra kaentok inleiphut, ");
INSERT INTO kfw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Inmani'n Jisu kha leimumu, khale inruoiya inmani'n Jerusalem tiang inkirra ama ka-entok inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nithum suoa ama kha biak-inna Jihudi karu ngaile in-ongnga inmani chongkha rangaiya halli inmani diang chong rakella ileiomkha injuomu. ");
INSERT INTO kfw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ama'n kasing kathei tak ah imasangli irakelngai kajet rakip in inleingak. ");
INSERT INTO kfw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Anuli apa'n injuomu phakhan ngakna inleinei halli anu'n amadiang ati, “Sapa, angsik ah nang in keinidiang hin ninathome? Napa li kei'n malung kapoong tak ah nangkha kinnaentok eii.” ");
INSERT INTO kfw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Halli Ama'n inmani diang heimasang, “Angsik-ah nangni'n kei ningna entokme? kei'n Kapa inna kaomsik tihi nangni'n jetmak chuwabe?” ");
INSERT INTO kfw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Halli ama irilpi kha inmani'n leijet matormu. ");
INSERT INTO kfw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Khale inruoiya Jisu'n chongjuina aleineiya inmanile Nazareth tiang inleikir, halli anu'n akasuok choun rakip kha amalung suungnga aleida. ");
INSERT INTO kfw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisu'n singna theinali taksa ah hong insoonna, Pathian khat-um mipui ngai minriang nakha alei inkheel. ");
INSERT INTO kfw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius in kum soomleira-nga reng hongroonna kum khan, Pontius Pilate kha-um Judea waikaroon alei eii, halli Herod kha um Galilee ramkaroon alei eii, halli ama naipa Philip kha Iturea khat-um Trachonitis ramsuung karoon alei eii, Lysaniah kha Abilene ramkaroon alei eii. ");
INSERT INTO kfw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas li Caiaphas hi thiampu kalian inlei eii, halli Pathian chongkha Zechariah sapa John diang neelramma aleijuo. ");
INSERT INTO kfw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Khale inruoiya John in Jordan tuidung ikakuol ramsuung rakip ah aleisiya, “Ningmalung thuul inlang baptized thoro, halli Pathian in ningmanu ngaikha nangaidam pisik ei iti chong kha aleiril.” ");
INSERT INTO kfw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Pathian chongkachoi Isaiah larik ah lei-injia angnga, “Mi inkhat in neelramma aleikheek: ‘Pumi lamkha minsuuk ru; halli ama sinasik lamkha mintuunru! ");
INSERT INTO kfw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Akuok rakip kha aminsipsik eii, chingmuol khat-um chingbung insaang rakip alaminzoolsik, Lam kakem rakip alamintuunsik, kathamak lam rakip aminthasik eii. ");
INSERT INTO kfw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Miring rakip in Pathian Sanminringna kha inlamusik eii!’ ” ");
INSERT INTO kfw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","John diang baptized kathosik kaheiwa Mipui rakipdiang ama'n inmani diang aleitipi, “E maruul sangai!” “Pathian rachaakna akajuosik makheiya ning inthup matornasik eii tihi atu'n natipiyame? ");
INSERT INTO kfw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ningmanu makheiya malung kinthuuljei tina chuon kha malarru, halli ningni karra Abraham kha kinpukaru eii tikhaimaru. Kei'n nangnidiang kanati, Pathian in hiwa lungpui ngaihi Abraham tuli sangai amin-eii mator. ");
INSERT INTO kfw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Han thingkuung kha arajungnga tukkhiak nasik-ah rei insuuk ah aomjei, Thingkuung rakip akara katha kakara makseng reiya tukkhiak inta meiya inhaalsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mipui'n amadiang inrakel, “Halle angme keini'n kinthosik?” ");
INSERT INTO kfw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ama'n inmani diang amasang, “Atu ka-ang in songkol inni anei inchu, kaneimak padiang inkhat perase, halli atu ka-ang baksik kanei ngai innum hiwa angnga thorusu.” ");
INSERT INTO kfw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Rampar kakhoom mi lekkhat baptize kathosik-ah inheiwa halli inmani'n amadiang inleirakel, “Karu, angme keini'n kithosik?” ");
INSERT INTO kfw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ama'n inmani diang aleitipi. Ningni'n ningleisik kasuok kheella leimaru, ");
INSERT INTO kfw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Raalmi lekkhat innum amadiang inleirakel, “Keini leii angme kinthosik?” Ama'n inmani diang ati, “Mi ngaikha kadikmak lamma sial leimaru emakli kadikmak noonkuung pemaru. Nangni'n ningthoman nape khan hunru.” ");
INSERT INTO kfw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","John Jarra Mipui'n inmalungnga inleingaidonle inruoiya inlei inkel, amahi Christa be e-makbe. ");
INSERT INTO kfw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John'n inmani diang aleimasang, “Kei'n nangni kha tuiya baptized kanatho, takkha kei neek ah kalok mi inkhat kha ajuosik eii, Kei'n ama kekokrui kha kashuut sik a-um rahoi emong, Ama'n nangni kha Ratha inthiang li meiya baptized nathosik eii. ");
INSERT INTO kfw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ama'n saangzaap nakha akut ah achoiya, saangseng zaapthiangta sapangnga adasik eii, halli sarasi sengkha hektik kaboi meikhan ahaalsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Khale inruoiya John in omchan intei angjet ah mipui diang chong kahoi kha aleiril halli inmani omchan ngaikha thuulnasik aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Takkha John in waikaroon Herod kha leiran, ajarchu Herodias anaipa Philip numei aneipiya halli ama'n kathamak choun angjet um aleitho. ");
INSERT INTO kfw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Khale inruoiya Herod in kheella kathamakthei chuon aleitho-ah John kha mikhumna ah aleida. ");
INSERT INTO kfw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mi rakipkha Baptized inleithosuo phakhan, Jisu kha-um baptized aleitho. Ama'n Pathian aleini phakhan marwaan alei inlong, ");
INSERT INTO kfw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Halli Ratha Inthiang kha taksa omchanna wathu angnga amadiang aleijuo. Halli marwaan makheiya rasa'n ajuoti, “Nanghi kei iminriang khet kasapa na eii, nangdiang kei kamalung atai.” ");
INSERT INTO kfw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisu'n achoun aleiphut phakhan, Ama kha kum soomthum alei eii. Halli amahi mipui'n Heli sapa Joseph sa eii tia inleingaidon, ");
INSERT INTO kfw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli hi Matthat sapa eii, Matthat hi Levi sapa eii, Levi hi Melchi sapa eii, Melchi hi Jannai sapa eii, Jannai hi Joseph sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph hi Mattathias sapa eii, Mattathias hi Amos sapa eii, Amos hi Nahum sapa eii, Nahum hi Esli sapa eii, Esli hi Naggai sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai hi Maath sapa eii, Maath hi Mattathias sapa eii, Mattathias hi Semein sapa eii, Semein hi Josech sapa eii, Josech hi Joda sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda hi Joanan sapa eii, Joanan hi Rhesa sapa eii, Rhesa hi Zerubbabel sapa eii, Zerubbabel hi Shealtiel sapa eii, Shealtiel hi Neri sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi hi Addi sapa eii, Addi hi Cosam sapa eii, Cosam hi Elmadam sapa eii, Elmadam hi Er sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er hi Joshua sapa eii, Joshua hi Eliezer sapa eii, Eliezer hi Jorim sapa eii, Jorim hi Matthat sapa eii, Matthat hi Levi sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi hi Simeon sapa eii, Simeon hi Judah sapa eii, Judah hi Joseph sapa eii, Joseph hi Jonam sapa eii, Jonam hi Eliakim sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim hi Melea sapa eii, Melea hi Menna sapa eii, Menna hi Mattatha sapa eii, Mattatha hi Nathan sapa eii, Nathan hi David sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David hi Jesse sapa eii, Jesse hi Obed sapa eii, Obed hi Boaz sapa eii, Boaz hi Salmon sapa eii, Salmon hi Nahshon sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon hi Amminadab sapa eii, Amminadab hi Admin sapa eii, Admin hi Arni sapa eii, Arni hi Hezron sapa eii, Hezron hi Perez sapa eii, Perez hi Judah sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah hi Jacob sapa eii, Jacob hi Isaac sapa eii, Isaac hi Abraham sapa eii, Abraham hi Tera sapa eii, Tera hi Nahor sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor hi Serug sapa eii, Serug hi Reu sapa eii, Reu hi Peleg sapa eii, Peleg hi Eber sapa eii, Eber hi Shilah sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shilah hi Cainan sapa eii, Cainan hi Arphaxad sapa eii, Arphaxad hi Shem sapa eii, Shem hi Noah sapa eii, Noah hi Lamech sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech hi Methuselah sapa eii, Methuselah hi Enoch sapa eii, Enoch hi Jared sapa eii, Jared hi Mahalaleel sapa eii, Mahalaleel hi Kenan sapa eii, ");
INSERT INTO kfw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan hi Enosh sapa eii, Enosh hi Seth sapa eii, Seth hi Adam sapa eii, Adam hi Pathian sapa eii. ");
INSERT INTO kfw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisu kha Ratha Inthiang in asip-ah Jordan makheiya ahongkirra ama kha Ratha'n neelramtiang aleiruoi, ");
INSERT INTO kfw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nisoommili seitan in aleimatheemma iteii leibakmak, khawa hekli awon aleichaampi. ");
INSERT INTO kfw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seitan'n amadiang aleiti, “Nang in Pathian sapa na-e-inchu, hiwa lunghi waipool uolro tipiro.” ");
INSERT INTO kfw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisu'n aleimasang, “Chong inthiang in ati, ‘Miring ngai'n waipool abit ringnunu.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Khale inruoiya seitan in ching insaangtiang aruoiya inoottheiya manmasituol rengram rakip aleiminmu. ");
INSERT INTO kfw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Kei'n hiwangai rakip ranak khat-um neinaak ngaihi kanapesik eii,” Seitan'n aleti, “Hiwa ngai rakiphi kei kadiang inape kha ejei, halli kei'n kipezoot miring diang kapesik eii. ");
INSERT INTO kfw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nang in chubei nanatho inchu hiwa-ngai rakip hi nang nata esik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisu'n aleimasang, “Chong Inthiang in ati, ‘Nang na Pumi Pathian khabit chubei nathosik khat-um ama sepabit nathosik eii!’ ” ");
INSERT INTO kfw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Khale inruoiya seitan in Jerusalem tiang aruoiya biak-inn chung insaangnakhet munna aminngirra amadiang aleiti, “Nanghi Pathian sapa na-e inchu hiwa makheiya inchoomro. ");
INSERT INTO kfw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Chong inthiang khan hin ati, nang kanasansik-ah ‘Pathian in ama tirton kha chong peta juotirsik eii.’ ");
INSERT INTO kfw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Halli inmani'n nang nakeii kha lungngai khan nasukmaknasik ah inmani'n inkut ngaikhan innaleipomsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Takkha Jisu'n aleimasang, “Chong inthiang in ati, ‘Nang in na Pumi Pathian kha madan in enmaro.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seitan in Jisu kha angrakip lamma matheemsuoli ama'n aphakhat sik-ah Jisu kha aleimathaan. ");
INSERT INTO kfw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisu kha Ratha ranak in sip-ah Galilee tiang aleikir, halli ama jarra khawa ramsuung rakip ah araming kha lei-inthang. ");
INSERT INTO kfw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ama'n Synagogues ah aleiminchu, halli mi rakip in inleiminpaak. ");
INSERT INTO kfw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Khale iruoiya Jisu'n ama honglok namun Nazareth ah aleisi, halli Sabbath nikhoni Synagogue ah a-ngai angnga aleisiya ama'n Pathian chong kateelsik ahongngir, ");
INSERT INTO kfw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","halli amadiang Pathian chongkachoipa Isaiah larik kha inleipeii. Ama'n larik kha aphongnga hinthoa inleimajia ajuomu, ");
INSERT INTO kfw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Pumi Ratha kha kei kachungnga aom, ajarchu ama'n keihi sara ngaidiang chongkahoi karil sik-ah anakadangjei, halli ama'n mikhumna-ah kaom ngaidiang katanna chong karilsik, khat um Mit kamumak ngaikha minmunasik, halli inkanengjuon mi ngaikha kakatansik, ");
INSERT INTO kfw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","halli Pumi in ami ngaikha sannasik ah aphakha juotung sikjei tia minjetnasik ah inajuotir eii.” ");
INSERT INTO kfw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisu'n larik kha akhumma, sepa kathopa diang aleipekirnook ah alei in-ong, Synagogue ah kaom mirakip in amadiang katha ah inlei-en. ");
INSERT INTO kfw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Halli ama'n inmani diang aleiti, “Awini nangni'n ningrangai jarra hiwa Pathian chonghi huui tungjei.” ");
INSERT INTO kfw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Halli mi rakip in ama jarra kathatak ah inleiril, ama murra inphut juokasuok rawaan chongngaikhan inleingak ah inmani'n inleiti, “Hiwa miring pahi Joseph sapa emak abe?” ");
INSERT INTO kfw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisu'n inmani diang aleiti, “Nangni'n suoilekleiya hiwa chongngil hi kei kadiang ningnatisik eii, ‘Kathiam, napumtak damna inpero.’ Keini'n kin ijet Capernaumma nang in chuon nitho rakip kha hiwa nang nakhopui hinnum thonookro. ");
INSERT INTO kfw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kei'n nangnidiang inthiangkha natipi kate,” “Pathian chong kachoi ngaihi angtikseng inkhuosuung achu kayanunu. ");
INSERT INTO kfw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Takkha Kei'n inthiangnga natipikate, Elijah phakhan Israel la chuulmei katamtak inleiom, halli kumthum le tharuk hi ruo leisurmak jarra khawa ramsuung rakip ah bukawaang aleisuok, ");
INSERT INTO kfw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Elijah kha tu diang um leiminsimak, takkha Zerephath inti Sidon ramsuungnga kaom chuulmei numeisanu diang aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Khale inruoiya Pathian chong kachoi Elisha phakhan, Israel karra mi angjet takbang ri karoon inleiom; tuteii kha kadam leiommu takkha Syrian makheiya Naaman khabit aleidam.” ");
INSERT INTO kfw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Synagogue ah kaom mipui'n inleijet phakhan, inmani'n inleiraang. ");
INSERT INTO kfw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inmani'n inhong intheiya Jisu kha inmani khopui makheiya inheiruoiya inkhuo luona chingbungnga inleirruoi. Halli ama kha karoolla matanasik ah inleingaidon, ");
INSERT INTO kfw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","takkha ama'n mipui karra aleiluut ah suokdeljei. ");
INSERT INTO kfw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisu'n Galilee khuopui Capernaum tiang aleisi, Sabbath nikhoni ama'n aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Halli ama minchu nakhan inmani'n inleingak, ajarchu ama'n ranak kaom tak-ah chong aleiril. ");
INSERT INTO kfw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Synagogue khan ratha kathamak kaluut miring inkhat aleiom; halli ama'n inringnga ahongkheek, ");
INSERT INTO kfw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“E! Nazareth Jisu, Angme keinidiang makheiya nimanuom? keini rakip kanamingmang sik-ah nijuobe? kei'n tu na-eme tihi kanajet, Pathian diang makheiya inthiangkha na eii!” ");
INSERT INTO kfw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisu'n ratha kathamak diang aleiran, “Omchian inlang amadiang makheiya heisuokro!” Raikhuo khan ama kha mipui maikuungnga juoworjuolla ama kha iteii minpop lekleiya asuokjei. ");
INSERT INTO kfw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mipui'n ngakna inleineiya khatli khatdiang inlei-inti, “Angkachang chongme hiwahi? ranak li thomatorna kanei hiwa mipa'n kathamak ratha ngaidiang chong apeili inmani'n inheisuok!” ");
INSERT INTO kfw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Halli Jisu jarra khawa ramsuungnga kaom mun rakip ah inleirilthangjei. ");
INSERT INTO kfw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisu'n intheiya Synagogue alei mathaanna Simon innkhan aleiluut, Simon tarpi kha ritun kangar in aleina-ah aleiom, halli inmani'n kananu jarra Jisu diang inleirilpi, ");
INSERT INTO kfw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisu'n kananu koolla ngirra ritundiang aleirakook, halli ritun khan alei mathaanjei, khawa suoa numeisanu khan intheiya inmani sepa aleitho. ");
INSERT INTO kfw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kani ajuota phakhan rirai karoon angjet inmani'n Jisu diang inheiruoi; ama'n inmani rakip takchungnga akut duongnga mindamna aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","“Nanghi Pathian sapa na eii tia raikhuo angjet in inkheek ah inleisuok.” Takkha Jisu'n raikhuo diang ranna aleinei, halli chongkha leiminrilmak, ajarchu inmani'n injet amahi Christa eii. ");
INSERT INTO kfw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Khuo ahongwar phakhan Jisu'n mi ommakna muna aleisi, Takkha mipui'n ama kha inhei entok, halli inmani'n injuomu phakhan Jisu kha inmanile inthenpuimak nasik inleitho. ");
INSERT INTO kfw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Takkha inmani diang aleiti, “Kei'n Pathian Rengram chong kahoihi aleiilaak khuopui diang um kajuorilsik eii, ajarchu hiwa sikbeiya keihi inajuotir eii.” ");
INSERT INTO kfw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Khale inruoiya khawa ramsuungnga kaom Synagogue ngaikhan Pathian chong aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jisu'n Gennesaret tuidiil pangnga aleingirra aleiom phakhan mipui'n Pathian chong karangaisik ama kooltiang innengtirra inheiwa. ");
INSERT INTO kfw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Halli ama'n tuipangnga rakuong inni aleimu, takkha ngakasur ngaichu rakuong makheiya insuok ah leen inrasuwa inleiom. ");
INSERT INTO kfw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisu'n rakuong inkhat ah aleiluut, khawakha Simon ta alei eii, halli ama'n aleitipi tuilaitiang lektei heinamru. Halli Jisu'n rakuongnga in-ongnga mipuidiang kaminchu aleiphut. ");
INSERT INTO kfw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ama'n arilsuoa, Simon diang aleiti, “Rakuong kha tui inthuup natiang namluutro, halli naleen kha nga surnasik worro.” ");
INSERT INTO kfw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon'n aleimasang “Karu,” “Keini'n Zaansoot leen kinworra iteii kinsurmak ejei. Takkha nang iti dungjungya kei'n leenhi wortakte.” ");
INSERT INTO kfw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Inmani'n leen ngaikha inwor phakhan nga katamtak lei-inkhit ah leen ngaikha leichetsik leithojei. ");
INSERT INTO kfw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Halli inmani'n rakuong khat ah kaom insap ngaikha inkut inzaap ah nasannasik inleikoi. Inmani'n inheiwa ah rakuong innikha nga inleiminsip wiak ah inmani rakuong kha tuiya luutsik aleitho. ");
INSERT INTO kfw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peter in kasuok rakip amu phakhan, Jisu kekuungnga inbok ah aleiti, “Ka Pumi” kei kadiang makheiya sitaro, ajarchu keihi manu karoon mi ka eii. ");
INSERT INTO kfw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon khat-um amale kaleiom mi rakip in inmani'n nga katamtak inleisur jarra ngakna inleinei, ");
INSERT INTO kfw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Khawa khanna kaleiom kha Simon le inlop Zebedee sapa Jame li John in eii, halli Jisu'n Simon diang aleiti, “Chimaro; atuun makheiya inphut nanghi mikasur na-esikjei.” ");
INSERT INTO kfw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Inmani rakuong kha muongtiang inleinuksuok, angrakip inmathaanna halli Jisu kha inleijui. ");
INSERT INTO kfw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisu'n khuopui inkhat ah aleiom phakhan, pasal inkhat takbang ri karoon inkhat aheiwa, ama'n Jisu aleimu phakhan, inbok ah Jisu diang aleini, “Pumi, nang nalungdou e-inchu keihi namindam mator nate!” ");
INSERT INTO kfw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisu'n akut duongnga ama kha aleikatook, “Kei'n kazoot,” “Damtaro!” khawapha takkhan takbang ri'n amathaanjei. ");
INSERT INTO kfw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisu'n amadiang chongpena aleinei, “Tudiang tipimaro, takkha nang in si inlang thiampu ngaidiang juoinmuro; khale inruoiya nang mindamna jarra Moses chongpeii dungjuiya mipui diang sakhi enasik doiphur juoinchangro.” ");
INSERT INTO kfw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Takkha Jisu jarra chongkha kheella rilthiangna inlainei, halli mipui'n amadiang chong karangaisik khat-um kana ngaikha indamnasik amadiang inheiwa. ");
INSERT INTO kfw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Takkha Jisu'n mi lengmakna mun ngaikhan aleisiya Pathian aleini. ");
INSERT INTO kfw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nisuo khatni Jisu'n aleiminchu phakhan, Galilee, Judea khat-um Jerusalem khuopui makheiya kaheiwa Pharisee li juina Dan karu ngai'n akoolla inlei in-ong, halli Pumi ranak mindam matornakha Jisu diang aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pasal lekkhat in apangkathi miring inkhat azaalnale inruoiya inheichoi, halli inmani'n mindamnasik beiya insuungtiang keiluutnasik khat-um Jisu koolla danasik ah inleitho. ");
INSERT INTO kfw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mipui katamtak in ajar eya leiluutpui matormu, inmani'n innchungnga inkaalla innchung inminwengnga ama zaalna khale inruoiya mipui karra Jisu maikuungnga injuomachum. ");
INSERT INTO kfw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisu'n inmani ngamna aleimupha khan ama'n ati, “Suopui, Nang namanu ngaikha kanangai dampijei.” ");
INSERT INTO kfw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dan karu ngaili Pharisee ngai'n inmalung suungnga inngaidonna inleiti, “Pathian karilsehi tume? Pathian eleiya, tu innum manu ngaidam matormu!” ");
INSERT INTO kfw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisu'n inmani i-ngaidonkha aleijet phakhan inmani diang aleitipi, “Angjarra hiwa ngaihi ning malungnga ning ngaidonme? ");
INSERT INTO kfw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘Nang namanu ngaikha kana ngaidamjei,’ emakli ‘Inthei inlang sitaro’ tihi hume kabei? ");
INSERT INTO kfw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nangni'n jetningte miring Sapa in manmasituolla manu ngaidamnasik ranak anei” Ama'n apang kathipa diang ati, “Kei'n nang nadiang kanati, inthei inlang nazaalna choi inlang na inntiang kirtaro.” ");
INSERT INTO kfw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Khawa phakhan pasalpa khan inmani maikuungnga intheiya ama azaalna kha achoiya inntiang Pathian minpaak ah aleikirjei. ");
INSERT INTO kfw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Inmani rakip in ngakna inleineiya Pathian inleiminpaak, halli kachi khan leisip ah inti, “Awini eini'n angtuk inlak chuonme nimujei!” ");
INSERT INTO kfw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hiwahi ahekli Jisu'n aleisuok ah rampar kakhom araming Levi kha ama chuon thona inna in-ongnga ileiomkha aleimu, Jisu'n amadiang atipi, “Kei najuiro.” ");
INSERT INTO kfw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Angrakip ama'n amathaanna khat-um intheiya Jisu nuk ajuijei. ");
INSERT INTO kfw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Halli Levi'n a-inna bubakna kalok inkhat Jisu sik-ah aleiminsuuk, khawakha rampar kakhoom khat-um aleiilaak mi katamtak inmani khale inlei-inong. ");
INSERT INTO kfw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pharisee li Dan karu lekkhat in asiamruoi ngaidiang inleitipi. “Ang jarrame nangni'n rampar kakhoom li manu karoon ngaile bak-in suomna ningnei?” ");
INSERT INTO kfw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisu'n inmani diang leimasang, “Kanamak ngaidiang kathiam arei ommak, takkha kana ngaisik achu areiom. ");
INSERT INTO kfw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kei'n Pathian kajetngai kakoi kijuo emak, takkha manukaroon ngai malung minthuulnasik kijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Inmani'n Jisu diang inleiti, “Ang jarrame John siamruoi ngai'n apha rakip bu ingeiya Pathian inni, halli Pharisee siamruoi ngai um khawa angnga inleitho; takkha nang nasiamruoi ngaichu inbak in-in.” ");
INSERT INTO kfw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisu'n aleimasang, “Moipa kha inmanile omsuom laikhan moikaruoi kajuo mi ngaikha bu minngei niyabe? ");
INSERT INTO kfw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Takkha moipa kha inmani diangnga inphut laruoidel nasik nikhuo kha alajuosik eii, khawapha khan inmani'n bu inngeisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jisu'n hiwa chong minkhina aleitipi: “Tuteii in puonkathar lek inkhat puonmaruo ah kathuidelmu, khawakha natho inchu akathar lek kha kamaruo le inhoinuni. ");
INSERT INTO kfw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tuteii in theibomju kathar kha jutuong maruo khan damu, khawakha ningtho inchu theibomju kathar in jutuong maruo kha minkoita aminmangsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Takkha theibomju kathar khachu akatha jutuongnga nidasik eii! ");
INSERT INTO kfw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","halli inkhat innum theibomju maruo innli thabomju kathar kha inzootnunu, ajarchu ama'n ati, theibomju maruo hi athadoom.” ");
INSERT INTO kfw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabbath nikhuoni Jisu'n gehubil laiya rakaanna aleisi, halli ama siamruoi ngai'n gehulor ngaikha inmani'n inchinna inkut ah inkanurra inleibak. ");
INSERT INTO kfw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharisee lekkhat in inleitipi, “Sabbath nikhuoni thosik ka-emak chuonkha angsia nithome?” ");
INSERT INTO kfw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisu'n aleimasang, “Nangni'n lasermak chube, David in awon chaampili ama inruoipui ngaile inthokha angme? ");
INSERT INTO kfw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ama'n angtho thoa Pathian inna aluutli Thiampu eleiya tuteii innum bakkachamak Pathian diang inpeii waipool kha aleiya abak halli ama inruoipui mi ngaidiang um aleipeii.” ");
INSERT INTO kfw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisu'n inmanidiang aleitipi, “Miring sapa hi Sabbath Pumi kha um eii.” ");
INSERT INTO kfw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabbath nikhatni Jisu'n synagogue ah aleisiya minchuna aleinei, Pasal inkhat akut changtiang kathi inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sabbath nikhuoni Jisu'n mi mindambe tia Dan karu li Pharisee lekkhat in ama kha injuichak ah noonkuung penasik ah ajar inleientok. ");
INSERT INTO kfw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Takkha Jisu'n inmani rakip ngaidonna kha aleijetpi, halli akut kathi pasal padiang aleitipi, “Inthei inlang matiang juongirro.” Pasalpa'n intheiya khawakhan ajuongir. ");
INSERT INTO kfw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Halli Jisu'n inmani diang aleitipi, “Kei'n nangnidiang kanarakel: Sabbath nikhuoni Dan in izoot thokacha kha katha khabe emakli kase khabe? tichu ringkhuo sansik emakli ringkhuo minmang sikbe?” ");
INSERT INTO kfw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ama'n amit en minloonna inmani diang ahei enna; pasal padiang ati “Nakutkha heisoonro.” Ama'n aheisoon, halli ama kutkha aleidam nookjei. ");
INSERT INTO kfw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Inmani'n inraangtheiya Jisu chungnga angme nithomatorsik tia khatli khatdiang inlei inbiak. ");
INSERT INTO kfw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Khawa phakhan Jisu'n amuoltiang aleikalla Pathian kani aleisi, halli zaansoot Pathian diang aleini. ");
INSERT INTO kfw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Khuokha ajuowarra, ama siamruoi ngaikha akoichunna inmani karra soomleini kadangnga inmanikha Tirton tia raming aleiphuo: ");
INSERT INTO kfw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon (amahi Peter tia inkoi) halli ama anai Andrew; James, John, Philip khat-um Bartholomew, ");
INSERT INTO kfw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew li Thomas, James Alphaeus sapa, Simon Zealot tia inkoi, ");
INSERT INTO kfw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, James sapa, halli Judas Iscariot Jisu kajuorpa eii. ");
INSERT INTO kfw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisu'n chingmuol makheiya atirton ngaile ajuochumma inzoolna munna asiamruoi angjetle injuongir. Halli mipui katamtak Judea ramsuung khat-um Jerusalem makheiya khat-um Tyre li Sidon tuipuikham makheiya; ");
INSERT INTO kfw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jisu koolla karangaisik khat-um inmani kana rakip mindamnasik ah inheiwa. Khale inruoiya ratha kathamak ngai'n minpoongna kaneingai um inheiwa ah inleidam. ");
INSERT INTO kfw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mipui'n ama kha katooknasik inleitho, halli ama ranak khan aheisuok ah mi rakip damna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisu'n asiamruoi ngaidiang ahei enna aleiti, “Sara ngaikha rawaan katha in-eii, ajarchu Pathian Rengram kha nangnita eii!” ");
INSERT INTO kfw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Tuunna won kachaam nangni ngaikha rawaan katha ning eii ajarchu; nangnikha nawai minkhopsik eii.” “Tuunna Kachap nangni kha rawaan katha ning eii ajarchu; ningla innuisik eii!” ");
INSERT INTO kfw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Miring sapa jarra mirakip in namatir, nazootmak, narilthai, halli nangkha kathamak na eii kanati nangni kha rawaan khatha ning ejei!” ");
INSERT INTO kfw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Rokru khawa phakhan, rok in laamru, ajarchu nang nachuon thomankha marwaan ramma alok, khawakha angnga inmani pile pu ngaikhannum Pathian chong kachoi ngaidiang inleitho. ");
INSERT INTO kfw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Takkha angtuk poongna khame inchong nangnidiang, nangni'n hoina ningmusuojei!” ");
INSERT INTO kfw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Tuunna won kasipngai nangni kha angtuk chikaome ajarchu; nangni'n inwai ningta kachaam in lasipsik eii! Tuunna ka-innui ngai nangnidiang angtuk chikaomme ajarchu; nangni'n in-ngui ningta ninglachapsik eii!” ");
INSERT INTO kfw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Mi rakip in innaminpaak nangnikha Poongna kha eii; ajarchu inpi inpu ngai innum kadikmak Pathian chong kachoi ngaidiang hiwa angnga inleitho.” ");
INSERT INTO kfw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Takkha kei kadiang kanarangai nangnidiang kei'n kanati, ning inhalpui ngaikha minriangru, kana enzootmak mi diang kathakha thoru, ");
INSERT INTO kfw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","nang nadiang khumak kanasaam ngaikha rawaan pero, halli nang nadiang kase kanatho ngaisik Pathian diang nipiro. ");
INSERT INTO kfw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mi ngai'n na-ngeem inkhattiang inkabeel inchu inkhattiang um doupi nookro; nang napuonsin kha mi inkhat in nakasut inchu nasongkol kha um pedelro. ");
INSERT INTO kfw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nang nadiang kanani mi rakipdiang pero, halli nang naneinaak kaleikha nikirkhai maro. ");
INSERT INTO kfw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nang in mi ngaidiang ni minthozoot angnga nang innum mi ngaidiang thoro.” ");
INSERT INTO kfw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nang kanaminriang mi ngaikhabit naminriang inle, angtho thoa rawaan mutinname? manukaroon ngai innum inmani kamiriang ngaikha inminriang! ");
INSERT INTO kfw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Halli nang in nang nadiang katha katho ngaidiangbit katha natho inchu, angtho thoa rawaan mutinname? manu karoon ngai innum khawachu intho! ");
INSERT INTO kfw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Khat-um nang in kanape matorsik ngaidiangbit sial naminwei inle, angmo nemna mutinna? Manu karoon ngai um manu karoon ngaidiang sial inminwei, in-ang rip ah munooknasik-ah. ");
INSERT INTO kfw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ning inhalpui ngaidiang mingriangru khat-um akatha kha thoru; minweiru halli nachangnook sik eii tia ngaidon khaimaru, Nang nathoman kha kalok ah nachangsik, halli nang in insaangkhet Pathian sangai na-esik eii, Ajarchu ama'n minriang kajetmak khat-um manukaroon ngaidiang aminriang. ");
INSERT INTO kfw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nipa Pathian hi minriang kajet angnga minriang kajet eru. ");
INSERT INTO kfw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Mi ngaidiang chong tanmaru, halli nangnidiang um Pathian in chong natannuni, mi ngai rilsemaru, halli Pathian innum nang narilsenuni, ngaidamru, nangkha um Pathian in nangaidam sik eii. ");
INSERT INTO kfw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mi ngaidiang pero, halli Pathian innum nangdiang napete. Katha minteiichu, namdeen inlang, kanik inlang khat-um minliamthaak inlang pero, halli nang iminteii angnga Pathian innum minteiita najuo penooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisu'n inmani diang hiwachong minkhinahi aleiti: Mit kacho inkhat in mit kacho inkhat lam keitheiniabe? akei inchu, inmani innikha khurra tamaknuwabe? ");
INSERT INTO kfw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Inchu mi rakip in ama karu neek ah kalok ommu, takkhat inchu mi rakip in kathatak ah inchusuo inchu inmani kha inkaru in-angsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Namit ah kaom thinglek kha mulekleiya, angjarra na-u nanai mit ah kaom madir kha nimume? ");
INSERT INTO kfw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Angtho thoa na-u nanai ngaidiang natisime, namit ah madir kha nakhaipi kate, tichu nang in namit ah thinglek kha mulekleiya? Nang mi katha omchanna inleem mi! mansakhet ah namit ah thinglek kha khaimasaro, kha e-inchu nang na-u nanai mit ah kaom madir kha inthiangnga munate.” ");
INSERT INTO kfw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Thingkuung katha'n akara kathamak karanuni khat-um thingkuung kathamak in akara katha karanuni. ");
INSERT INTO kfw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Thingkuung rakip akara khan nijetmator; ralingbil makheiya theichang kara khiaknunu, halli ralingkuung makheiya theibom kara khiaknunu. ");
INSERT INTO kfw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Akatha mi'n amalung suungnga akatha abuk ah idakhan akatha omchan aheikeisuo, halli akathamak mi'n amalung suungnga kathamak abuk ah idakhan akathamak omchan aheikeisuo. ");
INSERT INTO kfw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ang jarra ‘Pumi, Pumi,’ tia ningnakoime, halli kei iti khachu thomakchu? ");
INSERT INTO kfw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Halli atu ka-ang in kei kadiang heiwali kachong rakip karangai khat-um kajui amakha keihi nangdiang angkachang mi eme tikha kanaminmusik eii. ");
INSERT INTO kfw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ama kha khur inthuuk akhuorra lungpui chungnga inn kasak miring inkhatle in-ang eii. Halli tuikha ajuolianna inn kha ajuoshuk ah inn kha katuul matormak, ajarchu inn kha katha ah asak jarra eii. ");
INSERT INTO kfw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Takkha atu ka-ang in kachongchu karangai kajuichu kajuimak mi khachu, inn ngirna boolleiya neipil chungnga inn kasak ka-ang eii, halli tui ajuolianna inn kha woikhat ajuosuk phakhan inn kha aleichiam darjei!” ");
INSERT INTO kfw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisu'n mipui rakipdiang chong aleirilsuo phakhan, ama'n Capernaum tiang aleiluut. ");
INSERT INTO kfw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Halli Rome raalmi kalokpa'n iminriangkhet suok inkhat aleiom; khawa mipa kha ana-ah thisik aleitho, ");
INSERT INTO kfw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Roman kalokpa'n Jisu jarra aleijet phakhan, Jisu kha heiwa inlang suokpa kha juomindam nasik-ah, Jihudi upa lekkhatdiang juotipinasik aleitir. ");
INSERT INTO kfw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inmani'n Jisu koolla inheiwa ah katha tak-ah inleiti, “Hiwa mi'n nang sannakha inthiangnga amanuom. ");
INSERT INTO kfw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ama'n keini mi ngai aminriang khat-um ama'n keinisik-ah synagogue anasakpi.” ");
INSERT INTO kfw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Khale inruoiya Jisu'n inmanile aleisi, ama'n inn makkheiya inlaakjen phakhan, raalmi kalokpa'n ama asapngai aleitirra ajuominti, “Pumi natheinuo ah poongna inneimaro, nang in kei ka-inna heiwasik hi rahoi kasuok emong, ");
INSERT INTO kfw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","halli kei um nang nakoolla kaheiwasik rahoi kasuok emong, khawa jarra Chongnga natipiro halli kei kasuokpa kha adamsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ajarchu kei um ranak kanei nuoiya kaom ka eii, halli kei kanuoiya raalmi angjet inom, Kei'n chongpena kanei, ‘Siru!’ katili insi; halli aleiilaak diang, ‘Heiwaru!’ katili inheiwa; halli kei'n kasuok ngaidiang, ‘Hiwahi thoru!’ katili intho.” ");
INSERT INTO kfw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisu'n hiwa ajet phakhan amadiang ngakna aleinei; halli Jisu'n inlet-ah ama nukkajui mipuidiang aleitipi, “Kei'n nangnidiang kanati, hiwa ka-ang ingamna kalok hi kei'n Israel ngai kara-um lamumong!” ");
INSERT INTO kfw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Halli i-tir mi ngaikha inntiang inleikirra, inmani'n ama suokpa kha adamma ileiom kha injuomu. ");
INSERT INTO kfw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Khawa suoli Jisu'n Nain inti khopuikhan aleisi, halli asiamruoi khat-um mipui katamtak amale inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Khuopui luutna kotkuung aleinai phakhan, mikathi inkhat reii-nasik ah inheisuokpui, akathi mikha chuulmei sapa inkhatbit kha alei eii, halli mipui katamtak in khawa khuopui makheiya numeisanule inleisuok. ");
INSERT INTO kfw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pumi'n khawaneinu amu phakhan, Ama malungnga khawa nainusik-ah poongna aleinei, halli ama'n aleiti, “Chap maro,” ");
INSERT INTO kfw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","halli ama'n asiya u-pukha ajuo katookli akathipa karapuut ngaikha inleingir, halli Jisu'n ati, “Kadoong pasal! Kei'n kanati, intheiro!” ");
INSERT INTO kfw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Halli akathi miringpakha ahong intheiya chongkaril aleiphut, halli Jisu'n naipang pakha anudiang aleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Inmani rakipkha kachi'n leisip ah Pathian inleiminpaak ah inti, “Eini karra Pathian chongkachoi kalian inkhat inlarjei!” Halli inmani'n inti, “Pathian in ama mi ngai kasansik ajuojei.” ");
INSERT INTO kfw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Khawa ramsuung khat-um innaipui khuopuisuung rakip ah Jisu jarra inleirilthang. ");
INSERT INTO kfw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Halli John siamruoi ngai'n angrakip kasuok ngaikha amadiang inleirilpi phakhan, ama'n inmani inni kha aleikoi, ");
INSERT INTO kfw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","halli John in asiamruo inni kha Pumi diang hintho inlang juorakelru tia aleiminsi, “Nanghi John in ileiti akalajuosik ama kha na-ebe? emakli keini'n miring inkhat kinla-en sikbe?” ");
INSERT INTO kfw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Halli Inmani'n Jisu koolla inleitung phakhan inleitipi, “John Baptist in keinihi hintho inlang juorakelru tia nang nadiang naheitir eii, nanghi kalajuosik mi kha na-ebe, emakli keini'n aleiilaak inkhat kinla-en sikbe?” ");
INSERT INTO kfw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Khawapha takkhan Jisu'n kana angjet, rirai kathamak, khat-um ratha kathamak angjet aleimindam, halli mitkacho angjet-um aleiminmu. ");
INSERT INTO kfw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Halli Jisu'n inmani diang aleimasang, “Mitkacho khan muna innei, kasitheimak in insithei, takbangri karoonngai amindam, kuorkaseet in injet, kathi kha aminring, halli chongkahoi kha sara ngaidiang arilpi tia nangni'n ningmuli ning ijet ngaihi si inlang John diang juotipiru. ");
INSERT INTO kfw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kei jarra inngamsammak mi ngaikha rawaan katha in-eii!” ");
INSERT INTO kfw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John siamruoi ngai'n inleisisuoli, Jisu'n mipuidiang John jarra chongkaril aleiphut: “Nangni'n ang mukate tia neelramma ningsime? thikaraang in leihar ikatuul ka-en ningsibe? ");
INSERT INTO kfw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ang ka-enme ningni'n ningsuok ah ningsi? puondiar katha inluk ah kaom mi ka-en ningsibe? Enru, enzoot kaom puondiar inluk mi khachu reng inna nimusik eii. ");
INSERT INTO kfw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Angme ningsiya ningjuo en? Pathian chongkachoipa khabe? kei'n nangnidiang kanati, takkha nangni'n ningjuomu kha Pathian chong kachoipa neek-ah kakheel eii. ");
INSERT INTO kfw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ajarchu John hi eii chong inthiang in ileitikha. ‘Pathian in ati, kei'n nang nalam kaboolsik katirton kha nang matiang kajuotirsik eii.’ ");
INSERT INTO kfw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Khat-um Kei'n nangnidiang kanati,” “Tuteii innum John neek-ah kalok kaleiring laommu. Takkha Pathian Rengramma kasiinkhet kha John neek-ah alokwiai.” ");
INSERT INTO kfw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Khawajarra miring rakip in Jisu diang inlei rangai, khat-um aru ka-eya rampar kakhoomngai innum John diang makheiya baptized inthoa Pathian kha kadik eii tia inzoot. ");
INSERT INTO kfw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Takkha Pharisee ngaili dankaru ngai inchu Pathian lungdou kha inmanisik-ah leizootmu halli John in baptized inthosik kha-um leizootmu. ");
INSERT INTO kfw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Halli Jisui'n aleitinook, “Atuunlaiya mi ngaidiang kei'n angle kaminkhi sikme? halli angme inmani imanuom? ");
INSERT INTO kfw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Inmani ngaihi phaiya naipang in-ongnga khatli inkhat diang inkheek ah hin intia kaom ka-ang eii, ‘Keini'n inmanisik moiruoina dar kinminringpi phakhan, inmani'n laamnunu! keini'n mithina laa kinsakpi phakhan inmani'n chapnunu.’ ");
INSERT INTO kfw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Han John Baptist ajuolai bu a-ngei halli ju inmak halli nangni'n ningti, ‘Amadiang raikhuo om!’ ");
INSERT INTO kfw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pathian sapa kha abak a-inna aleijuo phakhan, ‘Enru, Ama hi! mahaam kalian khat-um jubuolrai eii, halli rampar kakhoom ngaili manukaroon ngai sappui eii tia nangni'n ningti!’ ");
INSERT INTO kfw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pathian singna theinakha, ama kangamna mi rakip in kadik eii tia inleiminmu.” ");
INSERT INTO kfw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Halli Pharisee inkhat in Jisu kha amale bubaknasik aleikoi, halli Jisu'n ama inna aleisiya bubaknasik ah alei in-ong. ");
INSERT INTO kfw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Halli khawa khuopui suungkhan manu karoon numeisa inkhat aleiom, Khawa numeisanu khan Jisu kha Pharisee ngai inna bu bak-ah om tihi inleijet phakhan, ama'n alabaster kok kasip arim kahoi sariak aheichoi, ");
INSERT INTO kfw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","halli Jisu kekuungnga aleingirra achap ah akeiikha amit rathi'n aleiminthupi, halli asamma akeiikha aleinuulpi, akeiikha aleimazoop, halli sariakrim kahoikha aleikanootpi. ");
INSERT INTO kfw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pharisee pa'n aleimu phakhan atheinuo ah alei in-ngaidon, “Hiwa miringpa hi inthiangnga Pathian chong kachoi e-inchu, ama'n ajetsik suok atume khat-um angkachang numeisame ama kakatook hi, ajarchu amahi manu karoon mi eii!” ");
INSERT INTO kfw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisu'n amadiang aleimasang, “Simon, Kei'n nang nadiang angkemekhat kanatisik aom.” “Ama'n leimasang, angme Karu?” ");
INSERT INTO kfw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Halli Jisu'n kamindik aleiphut, “Sepupa diang sialkapuuk miring inni inleiom,” “Miring inkhat in dangkaru rajara-nga aleipuuk halli miring inkhat pa'n dangka soomra-nga aleipuuk. ");
INSERT INTO kfw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Han Inmani inni'n leithuul matormujei, khale inruoiya ama'n inmani inni kha ngaidampi jei, atu khame ama'n iminriangdoom?” ");
INSERT INTO kfw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon in amasang, “Kei'n kangaidon” “Katamma intuol mipa diang. Halli Jisu'n aleiti,” “Nang in kadik ah nanamasang jei.” ");
INSERT INTO kfw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jisu'n numeisanu diang enna Simon diang aleitinook, “Hiwa numeisanu hi namubo? Kei'n nang na-inna kajuoluut phakhan kakeii rasunasik nang in tui napemakche, takkha enro hiwa numeisanu inchu amit rathiya kakeii minthu halli asamma nanuulpi. ");
INSERT INTO kfw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nang in namazoop inlang nadon makche, takkha kei kaheiluut ah inphut hiwa numeisanu inchu kakeii kamazoop ladamak. ");
INSERT INTO kfw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nang in kei kalu khan sariak nakanoot pimakche, takkha hiwa numeisanu inchu sariakrim kahoihi kakeiiya nakanootpi. ");
INSERT INTO kfw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kei'n kanati, ama manu katamtak kha ngaidampina kaneijei, ajarchu ama minriang nakha alok; halli tu ka-ang ngaidamna lekteii kamu khan lekteii minriang.” ");
INSERT INTO kfw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Khale inruoiya Jisu'n numeisanu diang aleitipi, “Nang namanu ngaikha kana-ngaidam pijei.” ");
INSERT INTO kfw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Khawa khamtuolla in-ongnga kaom leiilaak mi ngai'n inmani karra inkel, “Tume hiwahi, manu ngai kha-um ka-ngaidam?” ");
INSERT INTO kfw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Takkha Jisu'n numeisanu diang aleitipi, “Nang ngamna khan ringna naminmujei; kadaiya sitaro.” ");
INSERT INTO kfw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Khawahekli Jisu'n khuopui rakip khat-um khuo ah asiya Pathian Rengram jarra chongkahoi aleiril, halli siamruoi soomleini ngai kha-um amale inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Halli ama'n numeisa lekkhat-um kathamak ratha khat-um rirai kana ngai makheiya imindampi inmani ngaikha amale inleisi, Mary (Magdalene tia inkoi) ratha kathamak sari ipuutsuokpi numeisanu kha-um Jisu le aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chuza numei Joanna Herod inna chuon kaensui kalei eii, khat-um Susanna le katamtak aleiilaak numeisa ngai'n inmani neinaakngai inliingna-ah Jisu khat-um asiamruoi ngaikha sanna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Khuopui khatli khuopui khat makheiya mipui angjet inheisuok-ah Jisu koolla inlei-inchun halli Ama'n hiwa minkhinahi aleirilpi: ");
INSERT INTO kfw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Aru kaworpa'n asuok ah arukawor aleisi; halli ama'n aleiwor phakhan, lekkhat in lamma inleichulla mi ngaikhan inleitouwa halli wa ngai'n inleiruutjei. ");
INSERT INTO kfw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Lekkhat in lungbuk ah inchulla inhongmongnga innottheiya incharjei, ajarchu neipil kha leinommak. ");
INSERT INTO kfw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aru lekkhat in ralingbilla inchulla, ralingkhale inhongmoong suomma raling in adiipthatjei. ");
INSERT INTO kfw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aleiilaak aru'n akatha neipilla inchulla inhongmoongnga inwor makheiya tum rajakhat inliak inleikara” Jisu'n ahekna ah aleiril, “Rangairu kuor kanei rakip!” ");
INSERT INTO kfw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ama siamruoi ngai'n Jisu diang inleirakel hiwa minkhinahi ang tiname, ");
INSERT INTO kfw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","halli Jisu'n aleimasang, “Pathian Rengram jarra inthup chongkha nangnidiang innaminjet kha eii, takkha aleiilaak ngaidiangchu minkhina-ah aminmusik, khawajarra inmani ngai'n in-enpumma mununu, halli inrangai pumma jetnunu.” ");
INSERT INTO kfw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hiwahi minkhina aratha kha eii: arukha Pathian chongkha eii. ");
INSERT INTO kfw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lamma kachul aru tinachu Pathian chong chu karangai, takkha inmani ngaikha ngamna khat-um ringna minmumaknasik seitan aheiwa ah inmani malungnga inphut Pathian chongkha akeisuopi. ");
INSERT INTO kfw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lungkarra akachul aru ngai tinachu Pathian chong injetli karok ah kakeiluut, halli inmani'n malung inthuuk-ah kakeiluutmak in eii, inmani ngamna kha aphakhat sikbit eii, halli matheemna heiwa phakhan purna innei. ");
INSERT INTO kfw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Raling karra kachul aru tinachu, inmani ngaikha chongchu karangai, takkha malungkadong, kaneikanung halli ringkhuo hoinakhan inmanikha aminmang halli inmani kara kha minmatormak. ");
INSERT INTO kfw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nuoipil hoina ah kachul aru ngai tinachu, Pathian chong inrangaili katha khat-um chongkajui malungnga inda ah inra maklaiseng kadei mi ngaikha in eii. ");
INSERT INTO kfw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tuteii in sariakmei kawar kha kok nuoiya makhu inlang damakmi, khat-um zaalmun nuoiya damakmi, takkha meiserkeii khan nida inchu mipui kaheiwa rakip in awarkha muinte. ");
INSERT INTO kfw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Ang rakip ruukchuon ngaikha la-inlarsik, khat-um chonginthup ngai rakipkha inlajetsik.” ");
INSERT INTO kfw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Khawajarra nangni'n angtho thoa ningjetme, iringtheiru, ajarchu tu ka-ang kanei amadiang kheella apesik, takkha tu ka-ang kaneimak amadiang lekteii kanei tia i-ngaidon kha-um inleidelsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jisu anuli anai ngaikha Jisu diang inheiwa, takkha inmani'n mipuikhan ajar eya Jisu le lei-inmu matormu. ");
INSERT INTO kfw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tu ka-ang khat in Jisu diang inleitipi, “Nang nanuli nanai ngai'n tuolla inngirra nang kana inmupuisik-ah inom.” ");
INSERT INTO kfw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisu'n inmani diang aleiti, “Kei kanuli kanai ngai khachu Pathian chong karangaili kajuingai kha in eii.” ");
INSERT INTO kfw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jisu'n nisuokhat ama siamruoi ngaile rakuongnga inleiluut ah inmani diang aleiti, “Eini'n hiwa tuidiilpang khattiang rakaan inlang sirui.” Halli inmani'n kasi inleiphut. ");
INSERT INTO kfw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Inmani'n rakuong inleisep phakhan, Jisu kha aleizaaljei, jetlei theileiya thikaraang kangar inkhat khawa tuidiil khan alei-inthei halli rakuong kha tui ahongluut ah inmani rakipkha poongna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ama siamruoi ngai'n Jisu koolla insiya Jisu kha inlei keitheiya inleiti, “Karu, Karu! keini kathisik kin-ejei!” Jisu'n intheiya thiraang li tuithisiip diangkhan chong aleipei halli thiraang li tuithisiip kha ajuodaijei. ");
INSERT INTO kfw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Halli Jisu'n asiamruoi ngaidiang aleitipi, “Hume nangni ngamna kha?” Takkha inmani'n ngaknale china inleinei, halli inmani khatli khat inlei-inkel, “Amahi tume? Thiraang li tuithisiip innnum ama chongpe injui!” ");
INSERT INTO kfw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Khat-um inmani'n Galilee tuidiil raalkhattiang kaom Gerasene ramkha inleituung. ");
INSERT INTO kfw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jisu'n khawa tuidiilpang aleitung phakhan, ama'n khawa khuopui makheiya raikhuo kaluut pasal inkhat alei intongpui, apha kasoot tak-ah puondiar inlukmak khat-um inna kaommakjei, thaantaang reiya kaom mi alei eii. ");
INSERT INTO kfw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jisu kha aleimuli akheek ah ahongchap halli Jisu kekuungnga inbok ah rasa inringnga aleiti, “Jisu, Insaangkhet Pathian sapa! Angme nang in kei kadiang nimanuom? kei'n kanani, narachaak maro!” ");
INSERT INTO kfw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jisu'n mipa makheiya heisuok nasik raikhuo diang chong aleipeii, apha angjet ah ama kha surna anei, khat-um ama kha mikhumna khan inleida, ama kutli akeii thirruiya inleikhit takkha ama'n kapotchat ah raikhuo in ramrouk tiang aleiruoi. ");
INSERT INTO kfw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisu'n amadiang aleirakel, “Naraming angme inti?” “Kei karaming chu ‘Katam,’ ” tia aleimasang, ajarchu ama takchungnga raikhuo angjet inleiom jarra eii. ");
INSERT INTO kfw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Raikhuo ngai'n Jisu diang inleimatheem poongna meikhur khan keinihi naminsimaro. ");
INSERT INTO kfw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Khawa chingpang khan wok rahooi inleiom, khawa raikhuo ngaikhan wokngai suungnga luutnasik ah Jisu diang inleini halli ama'n aleizootpi, ");
INSERT INTO kfw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pasalpa makheiya insuok ah wok ngaidiang inleiluutjei halli wok rakip kha insuknatiang sumplingkhang inthoa tuidiilla inlei inraakthatjei. ");
INSERT INTO kfw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Khawa wok kakhaal mi ngai'n kasuok rakip inmuli intaanna insiya, kasuok omchan ngaikha khuopui khat-um khuosir khuopangnga kaom mipuidiang inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mipui'n angme kasuok tia kaen inleisi, halli Jisu koolla inheitung phakhan, raikhuo kaluut pasalpa kha Jisu kekuungnga in-ong kha inleimu, ama'n puondiar katha ilei-inluk le inruoiya herweengnga ileiom injuomu phakhan, inmani rakip in china inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Akamu rakip in angtho thoa raikhuo kaluut ama kha idamme tikha mipuidiang inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Khale inruoiya khawa ramma kaom mipui ngai'n Jisu kha sitro inleitipi, ajarchu inmani'n khatuk china inleinei, khale inruoiya Jisu'n rakuong achuongnga khawa munkha aleimathaan. ");
INSERT INTO kfw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Raikhuo ipuut suokpi pasalpa'n Jisu diang aleini, “Kei um nangle sikate.” Takkha Jisu'n hin tipiya aleiminsi, ");
INSERT INTO kfw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nang in na-inntiang kir-inlang, Pathian in nang nadiang itho chounkha juorilpiro.” Pasalpa khan khuopui suungnga aluut ah, Jisu'n ama diangnga itho rakip aleirilthang. ");
INSERT INTO kfw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisu'n tuidiil raalkhattiang aleikir phakhan mipui'n inleingaak chak ah ama kha karok ah donna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Synagogue karoon, Jairus intia inkoi miring inkhat aheiwa ah, ama'n Jisu kekuungnga inbok ah a-inna sirui tia biakna aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ajarchu kum soomleini ka-ejei asanu inkhatbit kha thisik leithojei. Jisu'n aleisi phakhan mipui'n inlei-uum. ");
INSERT INTO kfw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Inmani karra numeisa kum soomleini thikasar inkhat aleiom; ama'n inei rakip keisuoa kathiam ngaidiang in-en innum tuteii innum ama kha leimindam matormu. ");
INSERT INTO kfw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Khawa numeisanu khan nuuktiang makheiya Jisu nuk ah aheiwa ah apuonmor aleikatook halli khawapha takkhan athikasar kha aleidamjei. ");
INSERT INTO kfw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisu'n aleirakel, “Tume kei kanakatook?” Mipui'n leizootmu, halli Peter in aheiti, “Karu, mipui'n nang nakoolla na-uumma inom.” ");
INSERT INTO kfw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Takkha Jisu'n aleiti, Kei'n kajet miring inkhat anakatook, ajarchu kei karana kkha kei diang makheiya isuok kajet. ");
INSERT INTO kfw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Khawa numeisanu khan anajetjei tia amupha khan ama'n intuul pumma aheiwa ah Jisu kekuungnga ajuo inbok, khawa munkhan mi rakip maikuungnga ama'n Jisu diang angsik-ah ama kha ikatookme, han, ang omchanna innnoottheiya idamme tikha aleiril. ");
INSERT INTO kfw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisu'n numeisanu diang aleitipi, “Kasanu, nang ngamna khan nadamjei, kadaiya sitaro.” ");
INSERT INTO kfw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisu'n hiwa chong arillaitak, waikaroonpa inn makheiya taangwa inkhat aheiwa, ama'n Jairus diang ati, “Nasanu kha athijet” “Karu kha minpoong khaimaro.” ");
INSERT INTO kfw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Takkha Jisu'n hiwahi ajetli Jairus diang aheiti, “Nang in chimaro; ngamnabit ngamnaro, halli ama kha adamsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisu'n inn atung phakhan, Peter, John, Jame, halli naipangnu nuli pa eleiya tuteii amale kaluut sik leizootpimak. ");
INSERT INTO kfw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Khanna kaom mi rakip in numeisanu sikbeiya chapnali poongna inleinei, takkha Jisu'n aleiti, “Chapmaru, naipang nuhi kathi emak kalazaal keeng!” ");
INSERT INTO kfw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Numeisanu kha kathi eii tia injet jarra inmani rakip in Jisu kha innuipuina inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ama'n naipangnu kha akut ah mahuumma aleiti, “Naipangnu intheitaro!” ");
INSERT INTO kfw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Halli khawapha takkhan ama'n ahongringnga hong intheijei, halli Jisu'n inmani diang aleiti, bakphur inkhat peru. ");
INSERT INTO kfw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Halli anule apa'n ngakna inleinei, takkha Jisu'n inmani diang akasuok hi tuteii diang rilpimaknasik chong aleitipi. ");
INSERT INTO kfw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisu'n siamruoi soomleini ngaikha akoichunna kathamak raikhuo puutsook nasik khat-um kanangai rakip mindam matorna ranak khat-um thomatorna aleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Khale inruoiya ama'n Pathian Rengram rilthangnasik khat-um kana mindamnasik aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Halli inmani diang atipi, “Nangni'n ningsi phakhan iteii choimaru, kherol, khouchou, baksik, sial, songkool inliak kha-um choimaru. ");
INSERT INTO kfw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Khawa khuopui ningmathaan maklaiseng nangni innadonna innkhan omru. ");
INSERT INTO kfw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hun enum mi ngai'n nangnikha innadonmakna khuopui kha mathaanru, halli inmani diang chongmakhaina ningleida angnga ningkeiiya kaom rahutkha kathingthaak inlang leidaru.” ");
INSERT INTO kfw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Inmani'n khuosuung rakip inluut ah Pathian chong kahoi inrillarra khat-um mikana ngai kha-um amun rakip-ah inmindampi. ");
INSERT INTO kfw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galilee karoonpa Herod in angrakip kasuok choun ngaihi ajet phakhan ama malungkha inhaangna aleinei, ajarchu mipui lekhat in John Baptist kha ahongring nookjei tia inleiril. ");
INSERT INTO kfw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mi lekkhat in inti Elijah eii nimunook jeihi, halli mipui lekkhat in inti tiallaiya Pathian chongkachoingai karra inkhat eii hongkaring nookjeihi. ");
INSERT INTO kfw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod in aleiti, Kei'n John ariing kitan ejei, tuunna kei'n kijetnook amahi tume? halli ama'n Jisu kha munasik-ah alei entok. ");
INSERT INTO kfw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tirton ngaikha inheikirra, inmani chountho rakip Jisu diang inleirilpi, halli Ama'n inmani kha aleiruoiya Bethsaida inti khuopuitiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mipui'n inleijet phakhan ama nuk inleijui, khat-um Ama'n inmani kha aleidonna inmani diang Pathian Rengram chongkha aleirilpi, khat-um kadamzoot ngaikha inleimindam. ");
INSERT INTO kfw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kani ahongta phakhan siamruoi soomleini ngai'n inheiwa ah amadiang inleiril, “Hiwa munhi ramchik ejarra khuosir khuopangnga sisu-inlang baksik insik khat-um riakna zaalna injuo entok nasik mi ngaihi minsitaro.” ");
INSERT INTO kfw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Takkha Jisu'n inmani diang aleiti, “Nangni'n inmani baksik peru.” Inmani'n inleimasang, “Keini'n waipool ra-ngali nga inni kinnei, Nang in hiwa mipui ngaisik-ah baksak juorachasik namanuombe?” ");
INSERT INTO kfw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Khawa khan Pasal lising ra-nga inleiom.) Jisu'n ama siamruoi ngaidiang aleiti, “Mipui rakip kha buk khat ah mi soomra-nga soomra-nga daam heimin ongru.” ");
INSERT INTO kfw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ama siamruoi ngai'n khawakha inthosuoli, ");
INSERT INTO kfw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisu'n waipool ra-ngali nga inni aleiya marwaan tiang enna Pathian iminpaak le inruoiya akather khoiya ama siamruoi ngaidiang sempinasik aleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Inmani rakip in inbak ah inleikhopjei, halli asiamruoi ngai'n inbakbang kaliam kok soomleini inleikhoomchun. ");
INSERT INTO kfw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jisu'n atheinuo ah Pathian aleini phakhan asiamruoi ngaikha amadiang inheiwa, halli Jisu'n inmani diang aleirakel mipui'n keihi tu-eii innatime? ");
INSERT INTO kfw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“Mi lekkhat in innati nanghi John Baptist na eii,” inmani'n inleimasang. “Leiilaak in nanghi Elijah innati, khat-um mi lekkhat in innati tiallaiya Pathain chongkachoi ngai inkhat kahong kirnook ejei innati.” ");
INSERT INTO kfw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Inmani diang aleirakel, “Nangni inle keihi tu-eii ningnatime?” Peter in aleimasang, “Nanghi Pathian Messiah na eii.” ");
INSERT INTO kfw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Khawasuoa Jisu'n inmani diang hiwahi tudiang rilpimaknasik chongkacheet aleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ama innum inmandiang hin aleitipi, “Miring sapa kha poongna angjet aneisik khat-um katar ngai, thiampu kalian ngai halli Dan karu ngai'n zootnunu khat-um ama kha thina inpesik eii, takkha nithum huuini ahongring nooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Halli inmani rakipdiang aleitipi, “Tu ka-ang in keile kasi amanuom inchu, ama'n apumkha inzoot marase, cross kha nisuorakip kadomrase halli kei kha najuirase. ");
INSERT INTO kfw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ajarchu atu ka-ang in aringkhuo kaminringzoot mi khan amangsik eii, takkha tu ka-ang in kei kasikbeiya aringkhuo kaminmang mi khan ringna aneisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mi inkhat in nuoipilchung pumpui amata min e-innum ama ringkhuo kha aminmang inchu angme anemna kaom? ");
INSERT INTO kfw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nangni ngai'n kei kasikli kachongsik-ah ning injak inchu, miring sapa innum ama apoina khat-um Apa Pathian li tirton ngai poina kha achoiya ajuonikhan nangnidiang injaksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kei'n inthiangnga kanati, hiwahin mi lekkhat Pathian Rengram inmumak laiseng kathimaksik inom.” ");
INSERT INTO kfw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hiwa chongngai rakip atipina niriat athengli, Jisu'n Peter, John, khat-um James aruoiya chingmuoltiang Pathian kani inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jisu'n Pathian aleini phakhan ama meelsuo kha ahong inthuul, halli ama puondiar kachek in nalei-eel. ");
INSERT INTO kfw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jetlei theileiya, miring inni kha amale chong inleiril, inmani kha Moses li Elijah inlei eii. ");
INSERT INTO kfw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Inmani'n marwaan poina khan injuo inlarra Jisu'n Jerusalemma ang omchanna thisikme tijarra Pathian chuon minsuok sikkha innottheiya huui mintungnasik chong jarra inlei inbiak. ");
INSERT INTO kfw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter li ama sappui ngai'n inzaalbirra inleiom, takkha inmani'n inhong inthei phakhan Jisu apoinale miring inni amale inngir suomma inleiom kha inleimu. ");
INSERT INTO kfw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Khawa mi inni ngai'n Jisu kha inleimathaan siktiang, Peter in Jisu diang aleiti, “Karu, eini'n hin niomhi angtuk kathame! eini'n maichaam inn inthum, sakrui, nangsik inkhat, Moses sik inkhat, halli Elijah sik inkhat.” (Peter in angme itikha ama innum leijet matormak.) ");
INSERT INTO kfw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ama'n chong aleiril phakhan, suumphai khan aheiwa ah inmani ngai rakipkha aleimakhu; halli suumphai khan aleimakhu phakhan siamruoi ngai'n inleichi. ");
INSERT INTO kfw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Suumphai bukkhan rasa inkhat in aheiti, “Hiwahi kei ikadang kasapa eii, nangni'n ama iril chongkha rangairu!” ");
INSERT INTO kfw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Rasa khan aleirilsuoli Jisu kha atheinuo ah aleiom, halli khawa phakhan asiamruoi ngai'n inmu rakip ngaikha tudiang rillekleiya inleiomchian. ");
INSERT INTO kfw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ziingkhuo warli Jisule asiamruoi inthum ngai'n chingmuol makheiya injuochum phakhan, Mipui'n Jisu kha inlei inmupui. ");
INSERT INTO kfw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mipui karra pasal inkhat in ahongkheek, “Karu! Kei'n nangdiang kanani kasapa inkhatbit hi na-enpiro! ");
INSERT INTO kfw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Enro, ratha kathamak in amakha asurra jetlei theileiya akheek halli akeichang khangnga aleideengjuon halli inkei-orra amurra amachilphuonbit lei eii, halli angjet aleiminpoong kachak-ah asuokzoot makpumma aleisuok kachak. ");
INSERT INTO kfw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kei'n nang siamruoi ngaidiang puutsuok nasik ah kaleini, takkha inmani'n leimatormu.” ");
INSERT INTO kfw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisu'n aleimasang, “Angtuk ngamna kasuolli kathamak mi ning eme! nangnile angtuk soot kalaom sikme? angtuk kasoot nangnile kanaladeipui sikme?” khawasuoli khawa mipadiang atipi “Nang nasapa kha hin heiruoiro.” ");
INSERT INTO kfw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Neipangpa'n heiwa phakhan raikhuo khan ama kha nuoipilla juomapura inkei-orra omjei, halli Jisu'n ratha kathamak diang chong aleipeii, halli naipang pakha amindamma apadiang aleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pathian ranak kalokkha mipui rakip in ngakna inleinei. Takkha Mi rakip in Jisu itho rakip ah ngakna inleinei phakhan, asiamruoi ngaidiang aleitipi, ");
INSERT INTO kfw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Angme kei'n nangnidiang kanarilpisik hi manilmaru! Miring Sapahi ranak kanei manmasi kutchungnga inpesik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","(Takkha asiamruoi ngai'n hiwahi angtiname tihi leijetmu, hiwahi inmani'n injet mator maknasik inthup chongkha alei eii, hiwajarra inmani'n amadiang karakelsik um inleichi.) ");
INSERT INTO kfw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Khawa phakhan atume kalokkhet tia siamruoi karra muruolsiak inleitho. ");
INSERT INTO kfw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisu'n inmani i-ngaidon kha aleijet, khale inruoiya ama koolla kaom naipang inkhat aheiruoiya akoolla aleiminngir, ");
INSERT INTO kfw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","halli inmani diang aleti, “Tu e-innum hiwa naipang pahi kei karamingnga ningkeiluut inchu, keikha ningna keiluut ejei, halli atu ka-ang in kei ningna keiluut inchu kei kanajuotirpa kha-um ningkeiluut ejei, hanna nangni karra kasiinkhet mi kha kalokkhet esik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John in aleimasang, “Karu, keini'n miring inkhat nang naramingnga raikhuo ipuutsook kinmu, halli ama kha eini karra inchelmak jarra ama kha kinkhaap.” ");
INSERT INTO kfw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Takkha Jisu'n inmani diang aleiti, nangni'n ama kha khaapmaru,” “Tichu nangni kana inhalpuimak mi kha nangni mi eii.” ");
INSERT INTO kfw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisu kha marwaan tiang kalnasik aheinai phakhan, ama'n Jerusalem tiang sinasik aleingaidonna kasi aleiphut. ");
INSERT INTO kfw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Halli ama taangwa ngaikha ama neek ah ma minsa-ah aleiminsi, inmani'n ama sikbeiya angrakip insuuksik-ah Samaria khuo khan inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Takkha Jisu kha Jerusalem tiang kasisik ejarra mipui'n ama kha leidonzootmu. ");
INSERT INTO kfw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Asiamruoi James li John in hiwa injetpha khan, Inmani'n inti, “Pumi, marwaanna inphut keini'n mei koithak ah inmani minmangsik hi nang in namanoumbe?” ");
INSERT INTO kfw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisu'n inlet ah inmani kha ranna aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Khalle inruoiya Jisu li asiamruoi ngaikha aleiilaak khuotiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Inmani'n lamma inleisi phakhan, mi inkhat in Jisu diang aleiti, “Kei-um nang nasina rakip ah nanuk kanajuisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisu'n amadiang aheimasang, “Ram-ui ngaichu inkhur om, wa ngai-um inrabu innei, takkha miring sapa chu alu danasik um amun ommak.” ");
INSERT INTO kfw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisu'n miring inkhatpa diang ati, “Kanuk najuiro.” Takkha ama'n aheiti, “Karu, kei'n mansakhet ah kirkata kapa juophuumdirong.” ");
INSERT INTO kfw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisu'n aheimasang, “Akathi ngai'n akathi ngaikha leiphuumrasu, takkha nangchu si-inlang Pathian Rengram chongkha juorilthangro.” ");
INSERT INTO kfw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Miring inkhat innum ati, Karu; “Kei um nang kanajuisik eii, takkha mansakhet ah kei insuungkhur mi ngaidiang chong juomathaan masadirong.” ");
INSERT INTO kfw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisu'n amadiang atipi, “Atu ka-ang in akut ah laangkuol mahuumli anuktiang enna leikakhuoi miring kha Pathian Rengram sik-ah rahoi emak.” ");
INSERT INTO kfw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hiwahi hekli Pumi'n miring soomsari leini aleikadangnga halli ama amatiang miring inni inniya ama sinasik khuopui rakip ah aleitir. ");
INSERT INTO kfw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jisu'n inmani diang aleitipi, “Leirakhool sikchu atam, takkha karakhoolsik michu lekteii in eii, leimapupa diang niru leikarakhoolsik mi angjet ajuo minjuonasik. ");
INSERT INTO kfw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Siru! Kei'n nangni ngaihi malang karra keelngamtei angnga kinatir eii. ");
INSERT INTO kfw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nangni'n sialkhou, bunina khou khat-um kekok choimaru; halli lamma ning intongpui mi ngaikha rakooknasik ngirmaru. ");
INSERT INTO kfw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hun enum nangni'n ningluutna inna mansakhet ah ‘Inn khan Kadai omrase tiru.’ ");
INSERT INTO kfw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Khawa khan kadai kamanuom mi om-inchu, Nang diangnga kadaikha ama takchungnga omsik, kha emak inchu, ning ipeii kadai kha keikirnookru. ");
INSERT INTO kfw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Inmani'n naperei kha bak inlang innkhan omro, tichu chuon kathopa'n athoman amusik hi rahoi suok, innkhat makheiya innkhat ah leeng-inlang ommaru. ");
INSERT INTO kfw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nangni'n khuopui ningluutpha khan, inmani'n innaleidon inchu ningmaikuungnga innaperei kha bakru. ");
INSERT INTO kfw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Khawa khuopuiya mi kana ngaikha mindampiru, halli inmani diang tipiru Pathian Rengram kha ajuonaijei. ");
INSERT INTO kfw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Takkha ang ka-ang ningsina khuopuiya inmani'n innaleidonmak inchu, inmani lampui ngaikhan si-inlang tipiru, ");
INSERT INTO kfw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Tichu ning khuopui makheiya ningkeiiya kakop rahuut kikathingthaak hi nangni kinzootmakna eii, halli nangni'n ngaidonru Pathian Rengram kha nangnidiang ajuonaijei. ");
INSERT INTO kfw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kei'n nangnidiang kanati, hiwa khuopuihi Sodom poongna khaneek ah hiwahin poongna omsik eii! ");
INSERT INTO kfw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Angtuk poongna esikme Chorazin nangdiang! angtuk poongna esikme Bethsaida nangdiang um! nangni diangnga intho chuon inlak kha Tyre li Sidon diang inleitho inchu, buorasongkol kahak inta, khat-um inkilrahut inthekthuon inta inmani'n manu makheiya inmalung kha apha matiang leithuuljei inte. ");
INSERT INTO kfw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pathian chongtan Nikhuoni khan nangni neek ah Tyre li Sidon diang aminriang nakha omsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum! Nanghi, marwaan katung na-indomsaang zootbe? etheinuni, nangchu meikhur khan nadeengluutsik eii!” ");
INSERT INTO kfw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisu'n asiamruoi ngaidiang ati, tu-ennum ningchong karangai mikha kei kachong karangai kha in-eii; tu-ennum nangni kanazootmak ngaikha, kei kanazootmak in-eii; halli tu-ennum kei kanazootmak mi kha, kei kana juotirpa ama kha um izootmak kha eii. ");
INSERT INTO kfw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mi soomsari leini ngaikha ratha karok ah inheikirjei, inmani'n inleiti, “Pumi,” “Nang naramingnga chongpena kinnei phakhan raikhuo ngai innum kinchong injui!” ");
INSERT INTO kfw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisu'n inmani diang aleiti, “Kei'n marwaan makheiya seitan kha kool-inlek angnga ijuota kaleimu. ");
INSERT INTO kfw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Rangairu! kei'n maruul khat-um ailuweetngai chungnga simatornasik halli ningnile ning inhalpui ratha kanei rakip daimatornasik ranak kanapejei, han iteii in nangnikha nakatooknuni.” ");
INSERT INTO kfw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Takkha nangni'n ratha kathamak ngai'n ningchong injuijarra rokmaru, khawa neek ah marwaanna ningraming injia jarra rokru. ");
INSERT INTO kfw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Khawa phakhan Jisu kha Ratha Inthiang in aleisip jarra arok ah aleiti, marwaan le nuoipil Pumi E-Kapa! nangkha kei'n kanaminpaak ajarchu kasing kathei ngai'n injetmak khat-um inmu matormak kha, i-kajetmak diang namalarpijei. Oh, Kapa, hiwahi nang inmanuom li nalungduotak kasuok ejei. ");
INSERT INTO kfw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kapa'n angrakip kei kadiang napejei, halli asapa hi tume tikha apa elekleiya tuteii in jetmu, emakli atu khame apa tihi-um asapa eleiya tuteii in jetmu, khawa jarra asapa'n ikadang mi ngaidiang ama kha amalarsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Khale inruoiya Jisu'n inlet ah asiamruoi ngaidiang ruuk-ah aleitipi, “ Ningmit in musik ka eii phur rakip ningmu kha rawaan katha ning eii! ");
INSERT INTO kfw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Khawajarra nangnidiang kanati, Pathian chong kachoi ngaili rengngai innum, nangni imu rakipkha inmuzoot, takkha inmani'n mumatormu, halli nangni irangai kha inrangaizoot, takkha rangai phangnunu.” ");
INSERT INTO kfw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Dan kathei ocha inkhat in aheiwa-ah Jisu'n angme namasang tia, ama'n chong rakelna aleinei, “Karu” “Hektik kaboi ringkhuo munasik ah kei'n angme kathosik?” ");
INSERT INTO kfw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisu'n amadiang aleimasang, “Chong inthiang in angme iti? nangni'n angtho thoa ningmaletme?” ");
INSERT INTO kfw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Halli ama'n aleimasang, “ ‘Pumi na Pathian kha namalung pumpuiya naminriangsik, khat-um na ratha pumpuiya, naranak pumpuiya, halli na-ngaidonna rakip ah ama kha naminriangsik’ halli ‘Indiang inwai ngaikha napum ni inriang angnga naminriangsik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisu'n aheimasang “Nang in kadik ah natijei,” “Hiwahi thoro halli ringna namusik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Takkha Dan kathei ocha in atheinuomma kadik ezoot jarra Jisu diang aheirakel, “Tu khame kei indiang inwaipui?” ");
INSERT INTO kfw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisu'n aleimasang, “Miring inkhat Jerusalem makheiya Jericho tiang aleichumma aleisi, halli inruup ngai'n ama kha puondiar inliikpiya wuokna inleinei khat-um inwuokthat dengnga inleida. ");
INSERT INTO kfw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jetlei theileija thiampu inkhat in khawa lamkhan ajuochum, halli khawa miring pakha alei intongpui, takkha alooiya aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Khawa angnga Levite inkhat um khawakhan aheiwa ah miring pakha aleimu, ama innum alooiya aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Takkha Samaritan miring inkhat in khawa lamkhan aheiwa ah miring pakha aleimu phakhan, ama malungkhan minriang in aleisip. ");
INSERT INTO kfw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Amadiang asiya kapop rakipkha sariak li theibomtui abunpiya khuopina anei, halli ama salungdai chungnga minchongnga khomal tungna innkhat ah aleiruoiya ama kha sepa thona aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ziingkhuo warli khawa inn kangaak padiang dangkapum inni ama diang aleipe. Halli inn kangaak padiang aleiti. ‘Ama kha sepa leithoro,’ woikhat kahei kirnookli, ‘Kei'n ama diangnga niminluut rakip kanapesik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Hi ngai inthum karra tukhame nang in inruup ngai'n inleiwuok ah inleidapa diang indiang inwaipui eii tia ningaidon?” ");
INSERT INTO kfw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Dan kathei ocha in aleimasang, “Ama diang katha tak-ah sepa katho mipa kha eii.” Jisu'n aheimasang, “Nang in si-inlang hiwa angnga juothotaro.” ");
INSERT INTO kfw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisu li asiamruoi ngai'n lamma inleisi phakhan ama'n khou aleiluut, araming Martha inti numeisanu'n Jisu kha a-inna aleidon. ");
INSERT INTO kfw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Khawa numeisanu nainu inkhat aleiom araming mary inleiti, ama'n Pumi kenuoiya in-ongnga Pumi minchuna kha aleirangai. ");
INSERT INTO kfw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Takkha Martha'n ama chounthosik khan malungsena aleinei, ama'n aheiwa ah Jisu diang aleiti, “Pumi, nang in jetmakchebe kei kanainu'n katheinuobit chuon inaminthohi? Amadiang kei najuosan nasik tipiro!” ");
INSERT INTO kfw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pumi'n ama diang aleimasang, “Martha, Martha! Nang in ang rakip sik-ah namalung namindongnga naom, ");
INSERT INTO kfw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","takkha inkhatbit khakeeng arei kaom, Mary in akadik kha ikadang ejei, halli amadiang makheiya woikhat leikir nunujei.” ");
INSERT INTO kfw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nisuokhat Jisu'n amun inkhat ah Pathian aleini phakhan, khawa aminhek suoli asiamruoi inkhat in amadiang aleiti, “John in asiamruoi ngaidiang iminchu angnga, Pumi, Pathian kani naminchuro.” ");
INSERT INTO kfw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisu'n inmani diang ati, “Nangni'n ningni phakhan hintiru: ‘Kapa: naraming inthiangkha kayarasu narengram kha juotungrase. ");
INSERT INTO kfw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nisuo rakip ah kinbaksik napero. ");
INSERT INTO kfw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kin manu rakip nangaidampiro, keini innum keinidiang kathamak kanatho ngai kinngaidam angnga, intheemna khan naminchulmaro takkha kathamak ah inphut nasanro.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Halli Jisu'n asiamruoi ngaidiang aheiti, “Nangni karra tu ka-ang inkhat in suopui inkhat omtia ngaidonrui, han ama'n zaanchimma asiya amadiang ajuoti, ‘Suopui waipool inthumdam leipuuk kate. ");
INSERT INTO kfw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tichu kei kasappui inkhat khuol-injil eya ka-inna ahongtungnga omjei, halli kei'n ama kha iteii minbaksik neimong!’ ");
INSERT INTO kfw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Halli ama'n insuungnga inphut aheimasang, kahoimak nathokhai maro, kei'n kot kha-um kakharjei, halli kei kasa ngaile zaalmunna kinomjei, kei'n intheili phurkhat napesik hi matorkhai nuningjei. ");
INSERT INTO kfw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kei'n kanati, nanghi kasappuipa na-eii tia ama'n intheiya iteii nape matormak innum, nang in injak omleiya naninook naninook inchu ama'n intheita nang diang arei kaom rakip anapesik eii. ");
INSERT INTO kfw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Khawa jarra, kei'n nangnidiang kanati, Niro, halli nangnidiang anapesik, ratokru, nangni'n muningte, khat-um rakhoongru, nangnidiang namalongpite. ");
INSERT INTO kfw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tichu, Akani rakip in muinte, kaentok inmani in muinte, halli karakhoong rakipdiang malongpite. ");
INSERT INTO kfw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nangni karra tu ka-ang asapa'n apa diang nga anili maruul peniabe? ");
INSERT INTO kfw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Emakli ama'n artui anili, apa'n ailuweet peniabe? ");
INSERT INTO kfw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nangni kathamak mi ning e-innum, ningsa ngaidiangchu kutchoi katha angjet pesik ningjet inle, marwaanna kaom ningpa Pathian in angtuk kheella, kaniya kaom nangni ngaidiang Ratha inthiang napemak niame!” ");
INSERT INTO kfw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisu'n raikhuo kaluut chongkaril theimak khat aleiputsuokpi; raikhuo kha aleisuok phakhan chongkaril theimak mipa kha chongkaril aleiphut, halli mipui'n ngakna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Takkha mi lekkhat in inti “Raikhuo ngai karra kachingpa Beelzebul ama'n raikhuo puutsuok matornasik ama diang ranak ipekha eii.” ");
INSERT INTO kfw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mi lekkhat in Jisu diang surnasik-ah ensuina inleinei, khawa jarra inman'n amahi Pathian izoot inkhat eii tia jetnasik-ah choun inlak thonasik inleini. ");
INSERT INTO kfw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Takkha Jisu'n inmani i-ngaidon kha aleijetle inruoiya ama'n aleimasang, “Rengram inkhat in insuungnga inthenkhoina inneiya khatli khat raal intho inchu kasoot ah omnunijei, halli inmani karra inthenkhoi insuungkhur kha akoidarsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seitan rengram suungnga inthenkhoiya khatli khat raal intho inchu khawa rengram kha angtho thoa angir matorsikme? nangni'n ningti kei'n raikhuo kipuutsuok hi Beelzebul itho eii ningti. ");
INSERT INTO kfw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kei'n Beelzebul ranak ah raikhuo ipuutsuok ningnate inle, angtho thoa nangni nukkajui ngai'n inmani kha inpuutsuokme? Khawa jarra inmani ngai'n nangni chungnga chongkatan ngaikha in esik eii. ");
INSERT INTO kfw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pathian ranak ah kei'n raikhuo ngaihi kipuutsuok e-inchu, Pathian Rengram kha nangnidiang ijuo ejei. ");
INSERT INTO kfw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Mi kangar inkhat in, aomna innkhan chemli thalle inruoiya angaak inchu ama neinaak ngaikha mangtheinuni. ");
INSERT INTO kfw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Takkha mi kangar inkhat aheiwali ama kha insuol puiya amatorjei, halli ama'n inn kangaak pa'n inn ngaak theinasik ah ida chemli thal ngai achoidella halli inei rakip achoidelsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Keile kaommak mikha kei kanazootmak mi eii; keile inruoimak mi kha inchekchaisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ratha kathamak inkhat in mi inkhat diangnga inphut asuok phakhan, ama'n asi ahongnga poong machumnasik-ah ahuulnamun aleientok, ama'n amumak phakhan atheinuoa inti, ‘Kei'n kaheisuokna innkhan kirnook takte.’ ");
INSERT INTO kfw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Woikhat ama'n aheikirpha khan innkha inthiang hiaiya khat-um intiam week ah ileiomkha ajuomu. ");
INSERT INTO kfw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Halli ama'n ratha kathamak sari inliak ama neek ah kathamak heiruoi nook ah khawakhan injuo-om, halli khawa khan inmani'n inleiluut ah inleiom, halli ahekna khanchu mipa omchan kha matiangnga neek ah ahongse detjei.” ");
INSERT INTO kfw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hiwahi Jisu'n aleiti phakhan, “Numeisa inkhat in mipui kar makheiya ahongkheek ah amadiang ahongti, nang kanawon numeisa khat-um kanawailok ama kha rawaan katha eii!” ");
INSERT INTO kfw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Takkha Jisu'n aheimasang, “Khawa neek ah, Pathian chong karangaili kajui ngaikhan angtuk ah rawaan katha in-eme!” ");
INSERT INTO kfw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mipui katamtak in Jisu kha inhei-uum phakhan ama'n masonna chong ajuoril nook, “Hiwa khangnga mi ngaihi kathamak khang in-eii, inmani'n inlak chuon inentok, takkha Jonah diangnga inlakchuon aleiya etei inkhat um penunijei. ");
INSERT INTO kfw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tichu Jonah in Nineveh mi rakipdiang choun inlak ajuo inchang, khawa angnga Miring sapa innum hiwa khang sik-ah jetna inkhat esik eii. ");
INSERT INTO kfw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Chongtan Nikhuoni Simtiangnga rengnu'n hongngirta tuunna pha miring ngai chungnga rilsena aneisik eii, tichu hiwa rengnu khan aramtak makheiya Solomon singna chongminchu kha karangai aleihong, enru, Solomon neek ah kalian inkhat hin aomjeii. ");
INSERT INTO kfw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chongtan Nikhoni Nineveh ah kaom miring rakip in inthei inta hiwa khangnga mi ngaikha minsena inneisik eii, ajarchu inmani kha Jonah chongril inrangai phakhan inmalung inthuul halli enru, Jonah neek ah kalian miring inkhat hin omjei. ");
INSERT INTO kfw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Tuteii in sariakmei kha minkaili kok suungnga danuni; takkha akaheiluut mi ngai'n warkha inmunasik sariakmei kha meiserkeii chungnga inda. ");
INSERT INTO kfw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nang namit kha nataksa war eii, namit kha adam inchu, nataksa pumpui war in asipsik eii; takkha namit kha thamak inchu napum raja aziingsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Khawa jarra, nangni war kha ziingmak nasik inringtheiru, ");
INSERT INTO kfw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nang napum saram rakip kawar in asip inchu nang nadiang kaziing omnunijei, han sariakmei khan awar phakhan nangdiang na-eelwar angnga nang napum rakip awarsik ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisu'n chong aleirilsuoli, Pharisee pa'n amale bubak nasik aleikoi, halli ama'n asiya bubak nasik ah alei in-ong. ");
INSERT INTO kfw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jisu'n bubak ma-ah kut leirasumak jarra Pharisee pa'n ngakna aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Khale inruoiya Pumi'n ama diang aleitipi, “Atuunchu, Pharisee nangni'n putiangnga ningrabing li ningbukheeng ngai ningminthiang, takkha nangni malung suungnga chu kathamak li mikathazoot in asip. ");
INSERT INTO kfw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ka-am nangni! jetmak chube, Pathian in tuoltiang abool halli suungtiang kha-um ibool ema abe? ");
INSERT INTO kfw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Takkha nangni'n ning bukheeng li ning rabiingnga kaom ngaikha sara ngaidiang peru, halli angrakip nangni sinadan dungjuiya inthiang kha ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nangni Pharisee ngai angtuk chi kaomme! ninglei makheiya kamoong phurrakip, thikaraanglei (mint) rue, ngaikha tum soomma tumkhat ningpeii, takkha Pathian kadik khat-um minriang ngaikha ningmathaanjei, hiwa ngai rakip hi nangni'n mi ngaidiang manil lekleiya chuonna ningthosik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nangni Pharisee ngai angtuk chikaomme! nangni'n Synagogues in-ong na mun kahoi kakadang ningmanuom, halli phai suungnga khoya kaomma naleikoi kha ningmanuom. ");
INSERT INTO kfw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Angtuk poong kaomme nangnidiang! nangnihi musik kaommak thaankha ning eii, halli mi gai'n jetmuwa khawa thaan chungnga insiya inom.” ");
INSERT INTO kfw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Dan kathei ocha inkhat in Jisu diang aheiti, “Karu, hiwa natinachu, nang in keinidiang ninarilse eii!” ");
INSERT INTO kfw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisu'n aleimasang, “Chongkatan karu ngaidiang um poongna kha omrase! nangni'n mi ngai chungnga inroon matormaksik phurrik kha ningpeii, takkha nang inchu khawa phurrik roonpuinasik nakutmor kha-um heisoonmakche. ");
INSERT INTO kfw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Poongna kha omrase nangnidiang! ajarchu nangni'n ningpa ngai'n inleithat Pathian chong kachoingai thaankha ningboolla ning om. ");
INSERT INTO kfw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nangni'n ningpa ngai inleitho chuonkhan ning inpesuok ah sakhi ning inchangjei; inmani'n Pathian chong kachoi ngaikha inthat, halli nangni'n thaan ngaikha ningboolla ning omjei. ");
INSERT INTO kfw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Hiwa jarra Pathian singna theina khan ati, Kei'n Pathian chong kachoi khat-um Pathian tirton ngaikha kajuotirsik eii; Inmani'n lekkhat inthatsik eii khat-um inrachaaksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Khawa jarra manmasituol inbool makheiya inphut Pathian chongkachoi ngai thisen kasar kha atuunna khang ngai'n poongna kha ningmusik eii. ");
INSERT INTO kfw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kei'n nangnidiang kanati, Abel thisen makheiya Zechariah thisen katung khat-um maichaam inn makheiya Inthiang namun katung koongkarra kathi ngaikha atuunna khang mi ngai'n poongna inneisik eii! ” ");
INSERT INTO kfw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Angtuk poongna khame Dan karu ngaidiang! ajarchu nangni'n singna theina sou kha ningleijei, halli nangni inchu khawakhan luutmak chujei, halli nangni'n akaluut mi ngaidiang isuina ning ejei!” ");
INSERT INTO kfw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Khawa mun kha Jisu'n alei mathaanna aleisili, Dan karu ngaili Pharisee ngai'n Jisu kha setheiya inleirilthai, halli amadiang chong angjet rakelna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ama surtheinasik ah chong kase rilbe tia inngaak chak ah inleiom. ");
INSERT INTO kfw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mipui lising angjet intuothatsik inthoa inlei-intuup, halli Jisu'n mansakhet ah asiamruoi ngaidiang aleiti, “Katha inleem Pharisee ngai chol makheiya inngaaktheiru. ");
INSERT INTO kfw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Inkhu-ah kaleiom kha inlongsik eii khat-um ruukchong rakip inlajetsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Khawajarra angrakip aziingna muna ningril kha awarna ah inlajetsik eii, khale inruoiya insuungnga ning inbiakchian kha innchung makheiya inlaril thangsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kasapngai, kei'n nangnidiang kanati, taksa kathat mi ngaikha chimaru, khawasuoli inmani'n iteii nathomatorsik ommak. ");
INSERT INTO kfw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Takkha atu khame nangni'n ningchisik kei'n namindik kate, kei'n nangnidiang kanati, Pathian kha eii nichisik, anathat suoli woikhat meikhurra kanadeengluut mator ranak kanei Pathian kha chiru!” ");
INSERT INTO kfw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Wacharek ra-nga kha dangkapum innisik-ah jormak chuwabe? takkha Pathian inchu wacharek inkhat kha-um manilmak. ");
INSERT INTO kfw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ningluwa kaom ningsam ramol rakip khaum anateelpi, khawa jarra chimaru; nangni ngaihi wacharek katamtak neek ah aman katam ning eii!” ");
INSERT INTO kfw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kei'n nangni diang kanati, mipui maikuungnga kei kami kin eii intia inrilsuok inchu, Miring sapa innum Pathian tirtonngai maikuungnga anarilsuok pisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Takkha atu ka-ang in keihi mipui maikuungnga ningnazootmak inchu, Pathian innum tirtonngai maikuungnga nazootpinuni.” ");
INSERT INTO kfw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Atu ka-ang in Miring sapa zootmakna chong aril inchu ngaidamna apesik eii; takkha atu ka-ang in Ratha inthiang diang kathamak ah karilse khachu ngaidamna omnuni.” ");
INSERT INTO kfw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nangkha inmani'n synagogue li choun karool ngai, halli ranak kanei ngai koolla innaruoi phakhan, nang in angtho thoa kamasang sikme khat-um karilsikme tia malung dongna neimaru. ");
INSERT INTO kfw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Khawa phakhan Ratha inthiang in nangdiang angme narilsikkha naminchute.” ");
INSERT INTO kfw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mipui kara mi inkhat in Jisu diang aheiti, “Karu, kei ka-u diang Kapa inleida neinaak rakip insemnasik natipiro.” ");
INSERT INTO kfw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisu'n amadiang aleimasang, “Suopui, nangni inni kara neinaak nasempinasik atu'n kei kadiang khawa inzootna chongtannasik anapeyame?” ");
INSERT INTO kfw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Halli ama'n inmani diang aleiti, “Nangni rakip mahaam kalian makheiya in-entheiru khat-um insingtheiru; tichu miring ringkho hi neinaak kaneihut in arei emak.” ");
INSERT INTO kfw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Khale inruoiya Jisu'n hiwa minkhinahi aleirilpi: “Inchong inkhat saanglebaal katamtak kaminsuok ram inkhat aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ama'n atheinuoa aleingaidon, angme kei'n kathosik? ‘Kei saanglebaan ngai reiinasik amun neimongjei, ");
INSERT INTO kfw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","khawa jarra sasiar thiatkata’ halli ‘Sasiar kalok inkhat sakkata kasaangli kaneinaak rakip hiwahin kadasik eii tia ama'n hiwahi thonasik-ah atheinuoa alei inngaidong. ");
INSERT INTO kfw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Khale inruoiya rawaan katha mi! ka intisik tia atheinuoa alei inngaidon, nang in kum angjetsik-ah arei ka eii neinaak katha ngaikha nabuk ah nadajei, ringkhuo hi kahoithei ejei, kabak, ka-in thoinlang natheinuoa hoitaro!’ ");
INSERT INTO kfw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Takkha Pathian in amadiang ati, ‘Aka-am nang! Awini zaan makheiya nang naringkhuo kha aheksikjei; halli natheinuo sik-ah nabuk ah nida karei rakip ngaikha atu'n leiniame?’ ” ");
INSERT INTO kfw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Halli Jisu'n hinthoa minhek, “Atu ka-ang in neinaak rakip atheinuo sik-ah abuk ah ada-innum Pathian diang chu inchongna emak.” ");
INSERT INTO kfw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisu'n asiamruoi ngaidiang aheiti, “Hiwa jarra kei'n nangnidiang kanati, ningbaksik, niringnasik, khat-um taksa sik-ah areikaom puondiar sik-ah ningmalung mindongmaru. ");
INSERT INTO kfw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ringkhuo hi baksik neek ah arei kaom eii, khat-um taksa hi puondiar neek ah arei kaom eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wa-ak ngaidiang enru: inmani'n aru kha lingmu khat-um khoomma damu; inmani'n buknasik inn khat-um sasiar damu; Pathian in inmani kha awairing! nangni ngaihi wa ngai neek ah aman katam ning eii! ");
INSERT INTO kfw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ningmalung ningmindoongli atu'n ning ringkhuo kha ningminseidet matorme? ");
INSERT INTO kfw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nang in akasiin chounkhat sik ah iteii ningtho matormak inchu, angjarra aleiilaak sik-ah malung ning mindoogme? ");
INSERT INTO kfw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ngaidonru angtho thoa ramreibet in imoongme, inmani'n choun um thomu emakli puondiar um boolmu: takkha kei'n kanati Solomon rengpa'n ama inchong puondiar atho innum hiwa reibet inkhat katha angnga thamatormak. ");
INSERT INTO kfw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pathian in hiwa leiya chinthouhi aminmong, Takkha awini kamong chinthuohi ziingngachu mei-oot nasik-ah inhaalsik eii, nangni ngamna kasiin ngai! ama'n nangni kha kheella puondiar napemak niabe?” ");
INSERT INTO kfw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Nangni'n angme ningbak ning-in sik tia ningmalung minsemaru. ");
INSERT INTO kfw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Manmasituolla zaatlop ngai'n apha rakip ah hiwasik-ah ratokna innei.) Hiwa ngaihi nangnasik arei om tia napa Pathian in ajet. ");
INSERT INTO kfw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hineek achu Pathian Rengram kha ratokru, halli hiwa rakip ngaihi nangnidiang anapesik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nangni keelngam rahooi kadoong ngai, china neimaru, tichu Nipa'n Rengram napenasik-ah aratha arok. ");
INSERT INTO kfw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nangni'n ningnei neinaak rakip jour inlang sara ngaidiang peru, nangni'n kamaruo maksik sialkhou kha choiru, halli Marwaanna inchuongna kha mintuupru khawa khan inkei omnuni, ajarchu inruup luuttheinuni, khat-um inngeii innum minmang matornunujei. ");
INSERT INTO kfw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nangni karei omna rakip ah, ningmalung khaum aomsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Puondiar inluk inlang khat-um sariakmei minkai inlang angrakip indeipuisik-ah insuukchak inlang omru. ");
INSERT INTO kfw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Suok inkhat akaru kha moiruoina makheiya heikirli ama'n innkhar kha woikhat aheirakhoong li heirakhoongmak kamalongpi sik-ah kangaak ka-ang ngaikha in eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kei'n inthiangnga kanati, inringchak ah akaru kaheiwa ngaak ah kaom suok ngaikha angtuk rokna khame ama'n ajuomupha khan! ama'n asongkol inchuol kha liikta ama kha sepa inthosik-ah khamtuol khan juo in-ongsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Angtuk inroksikme Ama'n zaanchim khat-um khaneek ah inmoa aheiwa innum! inringchak ah kangaak ah kaomngai ajuomu phakhan. ");
INSERT INTO kfw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Takkha hiwahi jetru: inn mapupa'n inruup heiwanasik apha ajet inchu angtiseng innkha mangnasik-ah a-inn mathannuni. ");
INSERT INTO kfw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Khawajarra nangni innum inringchak inlang omru, ajarchu miring sapa kha ni-ngaidonmak phakhan ajuosik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter in ati, “Karu, Hiwa minkhinahi keinisik emakli mi rakip sik-ah nitibe?” ");
INSERT INTO kfw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pumi'n aheimasang, atu khame huoikajou khat-um akasing suok? ama kha karu'n a-inn kaensui sik khat-um aleiilaak suok rakip kha bu apha kacha-ah leiminbaknasik iminhuum suok khabe. ");
INSERT INTO kfw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ama karu'n aheikir phakhan angrakip katha tak ah aleithopi inchu, khawa suokpa kha angtuk rokna esikme. ");
INSERT INTO kfw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kei'n inthiangnga kanati, ama'n aneinaak rakip kaensui amin-esik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Takkha soukpa'n atheinuoa i-ngaidon ama karu kha inmo ah aheiwosik eii tia numeisali pasal asuok ngaikha aleiwuok ah khat-um ju ka-inli kabak thoa inruiya leiomma, ");
INSERT INTO kfw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ama karu kha a-ngaidon makna nikhuo khat-um ajetmakna phakhan aheiwasik halli ama kha abong abongnga tuktanta huoikajoumak tia aleisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Khat-um suok in akaru lungdou kha angme tia kajet, takkha insuuk leiya kaom, emakli ama lungdou nuoiyabit kasi ama kha kasetheiya awuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Halli suok in ama karu imanuom kajetmak, takkha sungmol kabaksik kasuok chuon lekkhat katho ama kha lekkhat wuoksik eii. Katamma inpeii midiang katamma ani; katamdoomma inpeii ama diang katamdoomma ani. ");
INSERT INTO kfw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Kei'n nuoipil chunghi meiya kaminkaang kijuo eii, halli kei'n kaleikangjei kha kamanuom! ");
INSERT INTO kfw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kei'n Baptism ka-inthosik om, halli kei kadiang angtuk malungsename khawakha ahekmaklaiseng! ");
INSERT INTO kfw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kei'n nuoipil chungnga kadai kanapesik kijuo eii tia nangni'n ningngai donbe? emak, kei'n natipikate, kanakhoithen sik-ah kijuo eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Atuun makhei achu innsuungkhurra mi ra-nga ningom nangkhan, mi ra-nga rakiple ning inhalsik eii, inthum ngai'n inni ngaidiang, inni ngai'n inthum ngaidiang. ");
INSERT INTO kfw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apali asapa inhalsik, asapali apa inhalsik, anuli asanu inhalsik, halli asanuli anu inhalsik, atarpi li amoinu inhalsik, halli amoinuli atarpi inhalsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisu'n mipui diang aleitipi, “Niluuttiang ziingkhum aheiwa phakhan, nangni'n ningti ruo juosursikjei, halli ajuosur. ");
INSERT INTO kfw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Halli simtiang thi aheiraang inchu, nangni'n ningti atuunchu ahong sasikjei halli hongsajei. ");
INSERT INTO kfw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Katha inleem ngai! nangni'n nuoipille lairalaak ning enna nikhuo ningmadan, halle angjarra atuunna phadan jarra ningmalet matormakme? ");
INSERT INTO kfw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Angjarra nangni'n akadik thonasik-ah ningtheinuoa chong ning-intan matormakme? ");
INSERT INTO kfw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nangni'n ning inhalpui khale chongtanna munna ningsi inchu, ningsina lam khan amale mintiamnasik thoru, emak inchu nangni kha chongkatanpa diang kadikmak namin eta, raalmi kalianpa diang napeluutsik ejei halli raalmi kalokpa'n nangnikha mikhumna ah innadasik eii. ");
INSERT INTO kfw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kei'n nangnidiang kanati, nangni'n dangkapum kha ningpemator maklaiseng namasuo nunujei.” ");
INSERT INTO kfw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pilate in Galilee mi ngaikha athatli inthisen ngaikha Pathian diang maichaam ileipeii jarra Jisu diang karilipi mi lekkhat khawa phakhan inleiom. ");
INSERT INTO kfw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisu'n inmani diang aleimasang, “Nangni'n hiwa Galileans inthat ngaihi aleiilaak Galileans ngai neek ah manu karoondet in eii tia ning ngaidonbe? ");
INSERT INTO kfw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Emak! Kei'n kanati, nangni um ningmalung ninthuulmak inchu inmani angnga ningthiwiak sikjei. ");
INSERT INTO kfw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Emakli Siloamma kaom inn insaang kha juopurra ideengthat mi soom leiriat ngaikha nangni'n Jerusalemma kaom mi ngai karra kheella manu karoon ngaikha in eii tia ningleibe? ");
INSERT INTO kfw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Emak, kei'n nangnidiang kanati, nangni innum ningmalung ningthuulmak inchu inmani angnga ningthisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Halli Jisu'n hiwa minkhina hi aleirilpi: “Miring inkhat in arahuonna theichang kuung inkhat aleiling, halli ama'n theichang kara ka-en aleisi, takkha iteii leimumak. ");
INSERT INTO kfw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Khale inruoiya rahuonna chuonkatho ngaidiang aleitipi, ‘Enru, kumthum ejei kei'n hiwa theichang kuungnga akara ka-en kaheiwana, halli iteii mumong: tukkhiaktru, angsik ah neipil luoa omsikme?’ ");
INSERT INTO kfw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Takkha rahuonna chuon kathopa'n aheimasang, ‘Karu atuunkum sik beichu moongdirase, kei'n asir apangnga cheikata neipilthai dapidirong. ");
INSERT INTO kfw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Halli nangkumtiang aleikara inchu athajei, takkha akaramak inchu nang in tukkhiak chajeite.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jisu'n Sabbath nikhuoni synagogue inkhat ah aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Numeisa inkhat kumsoom leiriat, ratha kathamak in minna ah aleiom, ama kha aruong inkunna minji kathamak alei eii. ");
INSERT INTO kfw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisu'n khawa numeisanu kha aleimu phakhan, numeisanu kha akoiya aleitipi, “Numeisa, nang nina makheiya nadamjei!” ");
INSERT INTO kfw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Halli khawapha takkhan ama kutkha khawa numeisanu diang aleiduongnga inkun kha-um aleimindam pijei, Khawapha takkhan numeisanu in Pathian kha aleiminpaak. ");
INSERT INTO kfw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Takkha Synagogue karoonpa'n Sabbath nikhuoni Jisu'n mi mindam tia mipuidiang hithoa aleirilpi, “Mi ngai'n niruk chuon inthonasik om, hiwa nikhuo ngaihin hong inlang hongmindamro takkha Sabbath nikhuo nichu chamak!” ");
INSERT INTO kfw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pumi'n amadiang aleimasang, “Nangni katha inleem ngai! nangni'n Sabbath nikhuoni sekuol makheiya inphut saraat li salungdai ngaikha ningkeiya tui kamin-in ruoimak chuwabe? ");
INSERT INTO kfw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Halli hiwa Abraham sa ka-eii numeisanu hi, seitan in kumsoom leiriat surra khat-um khit ah idahi, Sabbath nikhuoni inkhit makheiya masuosik suokmak abe?” ");
INSERT INTO kfw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jisu'n hiwa atipi phakhan, ama inhalpui ngaikha minjakna anei, halli mipui'n ama lurna chuontho rakip ngaikha rokpuina inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hiwasuoa Jisu'n aleiti, “Pathian Rengram hi angle in angme? halli hiwahi kei'n angle kaminkhi sikme? ");
INSERT INTO kfw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Itichu, miring inkhat in anchamru choiya leiya ijuowor ka-ang eii, halli ahongmoongnga thing ejei, han lairalaak ah wayam inheiwa ah thing-ool ngaikhan inrabu inphan najei.” ");
INSERT INTO kfw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Halli Jisu'n woikhat aleirakelnook, “Angleme kei'n Pathian Rengram kha kaminkhisik? ");
INSERT INTO kfw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Khawa khachu hiwa ka-ang eii, numeisa inkhat in chol lekkhat aleili waipooldi kokthum polla chol hongka uolwiak ka-ang eii.” ");
INSERT INTO kfw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisu'n Jerusalem tiang asina lamma khuopui angjet, khouteii angjet arakaanna aminchu tirra aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Khawa phakhan miring inkhat in aheirakel, “Pumi, mi lekkhabit ringna inmusikbe?” Jisu'n inmani diang aleimasang, ");
INSERT INTO kfw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nangni'n kot kasiin khan luutnasik-ah ranak songru; ajarchu mipui katamtak in luutnasik inentok, takkha luutmator nunu. ");
INSERT INTO kfw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Inn mapupa'n intheiya innkhar kha woikhat akharjei inchu, nangni'n tuolla kangir phutjei ningte halli inkhar kha rakhoong ningta ‘Pumi keini sik-ah inkhar namalongpidiro!’ halli ama'n nangnidiang naheimasang jeite, ‘Hu makheiya ning eme kei'n nangni kha najetmongjei!’ ");
INSERT INTO kfw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Khawa makheiya nangni'n hin kati ningphutsik eii, ‘Keini'n nangle kinleibak kinlei in, keini khuopui khan nang in nanaleiminchu!’ ");
INSERT INTO kfw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Takkha ama'n hin aheiti nooksik eii, ‘Kei'n nangni kha najetmong huwa makheiya kaheiwo ning eme, kei kadiang makheiya sitaru, nangni kathamak mi ngai!’ ");
INSERT INTO kfw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Khale inruoiya Pathian Rengramma Abraham, Isaac, Jacob halli Pathian chong kachoi ngai ningmu phakhan kachapli ha-kakarial in sipsik eii, halli nangni kha innahiaijuol sik ejei! ");
INSERT INTO kfw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pathian Rengramma phamwaina kalok khan mipui angjet in nisuo, niluut khat-um sim, mar, tiang makheiya heiwa inta injuo in-ongsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Enru, nuk intong ngaikha, ma insasik eii, halli ma-insa ngaikha nuk intong sik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Khawa phakhan Pharisee lekkhat in Jisu koolla inheiwa ah amadiang injuoti, “Nang in hiwa munhi innottheiya mathaan inlang amun khat ah sitaro, ajarchu Herod in nangkha nathatzootjei.” ");
INSERT INTO kfw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisu'n inmani diang aleimasang, “Si inlang ram-ui diang juorilpiru: ‘Enru, awini li ziingnga, ratha kachok ngaihi puutsuok kata mi mindam kata, nithum huuini khan kei kachuon kaminheksik ejei.’ ");
INSERT INTO kfw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Halli awini li ziingnga khat-um akahong nikhuo katung kei'n kachuon kathoa kalaomsik eii, ajarchu angtikseng Pathian chong kachoi ngaihi Jerusalem bitkhan inthat wiaksik tihi ommak.” ");
INSERT INTO kfw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Pathian chong kachoi ngai kaleikathat khat-um nangnidiang ijuotir ngaikha lungnga kaleideeng, Oh Jerusalem, Jerusalem! arpui khan amurtha nuoiya ateii ngai ida angnga, kei innum nasa ngaikha apha rakip ah kadazoot takkha nang in leizootmakche! ");
INSERT INTO kfw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Enru, nangni biak-inn kha, karuok ah nangnidiang kaleidajeii! halli kei'n nangnidiang kanati, Pumi ramingnga kajuo ama kha ‘Pathian in rawaan apesik eii tihi ningti maklaiseng keihi woikhat inlet-ah namunutunjeii!’ ” ");
INSERT INTO kfw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jisu'n Sabbath nikhuo khatni Pharisee chuon karoon ka-eii inkhat inna Jisu'n bukabak aleisi, halli inmani'n Jisu kha inleiensui. ");
INSERT INTO kfw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Enru, akei akut inthing pasal inkhat Jisu koolla aheiwa. ");
INSERT INTO kfw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Halli Jisu'n dan karu khat-um Pharisee ngaidiang aleirakel, “Sabbath nikhuoni kana mindamnsik hi eini sinadan in zootbe zootmakbe?” ");
INSERT INTO kfw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Takkha inmani'n inleiomchian, halli Jisu'n pasal pakha akatook ah amindamma aleiminsijei. ");
INSERT INTO kfw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Khawasuoa Jisu'n inmani diang aleiti, “Ningkarra atu ka-ang in asapa emakli asaraat kha Sabbath nikhuoni tuikhurra ata inle innottheiya keisuomak tunnabe?” ");
INSERT INTO kfw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Halli inmani'n hiwajarra leimasang matormu. ");
INSERT INTO kfw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisu'n in-ongnamun kathakhet kakadang khuolmi lekkhat alei intongpui, halli ama'n inmani diang hiwa minkhinahi aleirilpi, ");
INSERT INTO kfw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nangkha miring inkhat in moiruoina bubaknasik anakoi phakhan ongnamun hoina khetkhan in ongmaru, ajarchu nangneek ah kalok miring inkhat leikoicha. ");
INSERT INTO kfw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Khale inruoiya nang kanakoi sinpu khan heiwata nangdiang najuotite, ‘amahi hiwa munhin minongro.’ Khawa phakhan nang in nuoi innungkhet munna inongnasik ah injaknate, ");
INSERT INTO kfw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","khawa neek achu, nang innakoi phakhan, si inlang nuoi innungkhet munkhan in-ongro, kha e-inchu asinpu khan heiwata najuotite, ‘Heiwaro suopui mun hoinadet tiang sirui,’ khawa phakhan khuolmi ngai rakip in nangkha khoya thona innaneisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Halli atu ka-ang atheinuo ah inrilsaang amakha ajuominniamsik, khat-um atu ka-ang atheinuo ah inniam mikha aminsaangsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Khale inruoiya Jisu'n sinpu padiang aheiti, “Nang in ziingbu emakli kholeibu naminsuuk phakhan, nasappui ngai, na-u nanai ngai, naphung ngai, emakli inchongkaraang ngai, na-indiang inwaipui ngai kha koimaro, ajarchu inmani'n woikhat nang itho angnga nakoinook inta innamaleii nooksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Takkha nang in bubaknasik naminsuuk phakhan sara, ke inkhooi, siing insatheimak khat-um mit kacho ngaikha koiro, ");
INSERT INTO kfw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","kha e-inchu nang in rawaan namusik eii, ajarchu inmani'n nangdiang napekir matornunu, Pathian in nangkha kangamna ngai inhongring nikhuoni khan anape kirnooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Khamtuolla in-ong puisuom khuolmi inkhat in hiwahi aleijet ah Jisu diang aleiti, “Pathian Rengramma bu kalabaksik inmani kha rawaan katha in-eii!” ");
INSERT INTO kfw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Takkha Jisu'n amadiang aheiti, “Miring inkhat in phamwaina kahoi kalok amasouk ah mipui kha aleikoi. ");
INSERT INTO kfw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bubak nasik phakha aheitung phakhan, ‘Angrakip insuuk suojei heiwataru tia, ikoi mi ngaidiang juotinasik-ah ama'n asuok inkhat atirjei!’ ");
INSERT INTO kfw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Takkha inmani'n rakip in inruolrip ah inkeiduuk nasik inleirilwiak, mansakhet pa'n suokpa diang ati, ‘Kei'n ram inkhat karacho khawakha juoendirong, nangaidamro.’ ");
INSERT INTO kfw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Miring inkhat innum aheitinook, ‘Kei um saraatchal bop ra-nga karacho khawajarra kei'n juo encheen dirong, ngaidam napero.’ ");
INSERT INTO kfw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Miring inkhat innum aheitinook, ‘Kei um inn kalaneilim khawajarra heiwa matornuning.’ ");
INSERT INTO kfw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Suok khan aheikirra ang rakipkha karu diang ajuotipi, karu khan araangnga ama suokpa diang atipi, ‘Innottheiya khuopui lampui ngaikhan si-inlang, sara, kasitheimak, mitkacho khat-um inkhooi inmani ngaikha heiruoiro.’ ");
INSERT INTO kfw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Suokpa khan aheiti, ‘Karu, nang nachongpeii dungjuiya kathosikjei, halli tuunnum mun angjet alaruok.’ ");
INSERT INTO kfw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Halli karu khan asuokpa diang aheiti, si-inlang lampui li khuo ngaikhan ‘Mipui kha ka-inn sipnasik heiruoiro. ");
INSERT INTO kfw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kei'n nangdiang kinatihi eii, kei'n kikoimak inmani tuteii innum kei iminsuuk bu kha mintem theinunu!’ ” ");
INSERT INTO kfw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mipui katamtak Jisule inleisisuom phakhan, ama'n anuk malet ah inmani diang aleiti. ");
INSERT INTO kfw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Kei kadiang kaheiwa ngai'n anu apa, anumei, asa, a-u anai ngai khat-um apumtak intirmak inchu kei kasiamruoi etheinuni. ");
INSERT INTO kfw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Atu ka-ang in ama cross raput leiya kei kanuk kajui mikha kasiamruoi atheinuni. ");
INSERT INTO kfw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nangni karra mi inkhat in insaangtak inn inkhat saksik tia ngaidon inchu, ama'n in-ongta hiwa minheknasik, angjetme kaluutsik tia mansakhet ah minsuukmak niabe? ");
INSERT INTO kfw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Inn insaangtak kasak aphutli aminhek matormak inchu akamu mi rakip in ama kha innuipuisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Inmani'n ti-inte, ‘Hiwa mipa hi inn insaangtak kasak aphutli saksuo matormakjei.’ ");
INSERT INTO kfw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kha emakli reng inkhat in reng inkhat diang raal katho asi inchu, ama'n mi lisingsoom aruoiya inhalpui rengpa raalmi lising soomni ama chungnga raal katho kaheiwa ngaikha mator ningbo tia mansakhet ah ama'n in-ongta ngaidonmak niabe? ");
INSERT INTO kfw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ama'n amator maksik e-inchu, kalaak ah inomlai khan asuok inkhat tirta inhalpui rengpa diang inngei nasik chong ajuominrilsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hiwa angnga” “Atu ka-ang in inei rakip amathaan matormak inchu amakha kei kasiamruoi ematornuni. ");
INSERT INTO kfw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Machi hi ka-al eii, takkha i-al kha amang inchu, angtikteii min-al matornuminjei. ");
INSERT INTO kfw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Khawakha neipilthai sik-ah emakli neipil sik a-um nemna kaboi eii; khawa jarra indeengjuon. Kuor indou rakip in jetru!” ");
INSERT INTO kfw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nisuokhat rampar kakhoom ngaili manukaroon ngai'n Jisu chong inngaisik ah inheiwa. ");
INSERT INTO kfw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Halli Pharisee ngaili Dan karu ngai'n nemnum inleiti, “Hiwa mi in manu karoonngai idonle inruoiya inmanile aleibaksuom!” ");
INSERT INTO kfw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Khawajarra Jisu'n hiwa minkhinahi inmani diang aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Etichu miring inkhat in keelngam rajakhat aneiya inmani karra inkhat aminmang inchu, angme ama'n athosik? Ama'n soomkuo leikuo ngaikha sachik billa data keelngam kamangkha amumaklaiseng kaentok simakniabe? ");
INSERT INTO kfw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Halli ama'n khawa amu phakhan, roktheiya adarkhoiya ada, ");
INSERT INTO kfw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","halli inntiang achoiya akirphakhan, asappui ngaili indiang inwaipui ngaikha koita inmani diang atisik, kamang keelngam kha kei'n kamujei, keile roksuomrui! ");
INSERT INTO kfw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hiwa angnga, kei'n nangnidiang kanati, malung thuulsik arei kaommak mi kadik soomkuo leikuo ngai neek ah, manu karoon miring inkhat in malung athuul phakhan marwaanna kheella rokna omsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kha emakli numeisa inkhat in dangkapum soom neili ama'n inkhatkha aminmang inle, ama'n sariakmei kha minkaita khat-um inn kha phiatta amumaklaiseng takkachangnga amun rakip ah ratokmak niabe? ");
INSERT INTO kfw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Halli ama'n amu phakhan, asappui ngaili indiang inwaipui ngaikha akoichunna inmani diang aleiti, ‘Kiminmang dangkapum kha kamujei, keile roksuomrui!’ ");
INSERT INTO kfw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hiwa angnga kei'n nangnidiang kanati, manukaroon miring inkhat in amalung ahongthuul phakhan, Pathian tirton ngai'n inroksik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Halli Jisu'n aleitinook, “Miring inkhat sapa inni kanei aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Naipangpa'n apa diang aleiti, ‘Pa, kei kachansik kasuok neinaak ngaikha napetaro,’ halli ama'n aneinaak ngaikha inmani diang aleisempi. ");
INSERT INTO kfw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nikhuo sootlekleiya neipangpa'n ama achangsik kasouk ngaikha khoomchunna ram kalaak inkhattiang aleisi, khawakhan ama'n neinaak rakip kathamak lamma aminheksuojei. ");
INSERT INTO kfw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Khawasuoli ineirakip aminheksuo phakhan, khawa ramsuungnga bukawaang ahong suokjei, halli ama'n iteii leineimakjei. ");
INSERT INTO kfw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Khawajarra ama'n khawa ramsuungnga kaleiom miring inkhat diang juokabeiya, khawa naipa khan wokdoonna munna ama kha wok kakhaal sik-ah aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Halli tuteii innum amadiang baksik leipemuwa, ama'n wok ngai'n inbak bukhan awon aleiminsip zootjei. ");
INSERT INTO kfw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Takkha ama'n atheinuo beiya alei inmudong, ‘Kapa'n chuon kathosik-ah ida suok angjet ngaisik ah baksik inliak bu ada, takkha kei'n hiwahin wonchaamma kathisik ka-ejeii! ");
INSERT INTO kfw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kei'n intheikata kapa koolla sikata, halli kei'n amadiang katisik eii, “Kapa, kei'n Pathian khat-um nangdiang manu kathojei. ");
INSERT INTO kfw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Keihi nang nasapa tisik rahoi suokmongjei; keihi nangdiang sial kalousik suok inkhat angnga nadaro.” ’ ");
INSERT INTO kfw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Khawasuoli ama'n intheiya apa koolla aleisi. “Halli ama'n a-inn makheiya kalaakjenna iheiwa kha apa'n aheimu phakhan, apa'n ama kha aleiminriang, halli ataanna ama'n asapa kha ajuokakuoa aleimazoop. ");
INSERT INTO kfw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Asapa'n aleiti, ‘Kapa,’ ‘Kei'n Pathian li nangdiang manu kathojei, keihi nasapa tisik rahoi suokmongjei.’ ");
INSERT INTO kfw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Takkha apa'n suok ngaidiang aleitipi, ‘Innottheiya!’ ‘Retruo katha khetkha heichoi inlang ama kha minlukru, halli akutkhan kutsabi mintiangru, akeiya kekok milukru, ");
INSERT INTO kfw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","han sarat tuoiteii kanool khetkha heichoi inlang juothatru halli eini'n rokpuirui. ");
INSERT INTO kfw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tichu kei kasapa hi kathi makheiya kahongringnook ejei, ama hi kamangkha eii, halli nimunook ejei,’ khale inruoiya inmani'n karokpui inleiphut.” ");
INSERT INTO kfw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Khawa phakhan asapa upapa kha leiya aleiom, ama'n a-inn ahong naipha khan khuonglidar khat-um laamsiam rasa aleijet. ");
INSERT INTO kfw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Halli ama'n suok inkhat akoiya aleirakel, ‘Angme kasuokjei?’ ");
INSERT INTO kfw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Halli suokpa'n aleimasang, ‘Nang nanaipa kha ahongkirnook ah,’ ‘Napa'n kahoi kadamma amunook jarra saraat tuoiteii kanool inkha athatpijei.’ ");
INSERT INTO kfw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Halli ama'n araangtheiya inna luutsik leizootmakjei, apa'n aheisuok ah ama kha insuungnga heiluutro tia aleimatheem. ");
INSERT INTO kfw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Takkha ama'n apadiang aleimasang, ‘Enro, kum angjet nang nasuok ka-angnga sepa katho halli nang nachongkha rakaanmong, kha e-innum kei kasappui ngaile roknasik-ah nang in keeltei inkhat-um angtik niteii nalape ngaimakche. ");
INSERT INTO kfw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Takkha hiwa nasapa'n zool-inthai ngaile naneinaak rakip aminmangnga heikir lichu ama sik-ah saraat tuoiteii kanool inkhat nathatpi!’ ");
INSERT INTO kfw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Halli apa'n amadiang aheiti, ‘Sapa,’ ‘Nangchu keile apha rakip niomsuom, halli ang rakip kei i-nei ngaihi nang nata eii. ");
INSERT INTO kfw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Eini'n kahoi nithoa nirokpuisik adik, ajarchu nanai pahi leikathi ejei, halli ahong ringnookjei, amahi aleimangjei takkha nimunook ejei.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Halli Jisu'n asiamruoi ngaidiang aleiti, “Inchong mi inkhat aleiom khat-um aneinaak kaensui sik suok inkhat aleida, mi ngai'n aneinaak kaensuipa khan aneinaak rakip kadikmak ah minhekjei tia inchong padiang inleitipi. ");
INSERT INTO kfw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Khale inruoiya ama'n suokpa kha koiya aleitipi, ‘Kei'n nang najarra kijet rakiphi angkemejei? kaneinaak naensuina aluut asuokna ngaikha napero; ajarchu nanghi tuun makheiya kei kaneinaak kaensuipa etheinutinjei.’ ");
INSERT INTO kfw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Suokpa khan atheinuo ah alei-inti, ‘Kei karu'n kachoun makheiya nakhaisik ejei, tuun angme kei'n kathosik? kei'n khur kakhuorsik a-um karaat emongjei, bu kanisik um ka-injakjei, ");
INSERT INTO kfw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","kei'n kachuontho ahekni mi ngai'n inmani inna nakeiluutnasik kei'n angme kathosik kha kajetjei.’ ");
INSERT INTO kfw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Khale inruoiya karu sial kapuuk ngaikha, inkhat inkhat ah koina aleinei, ama'n mansakhet padiang aleiti, ‘Angjetme nang in karu diang nipuuk kha?’ ");
INSERT INTO kfw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Olive sariakkok rajakhat’ tia ama'n aleimasang, halli neikaensui pa'n amadiang aleitipi, ‘Napuukna cheihi’ lei inlang ‘Innottheiya in-ong inlang soom ra-nga majiaro.’ ");
INSERT INTO kfw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Khat-um aleiilaak mipa diang aheitipinook, ‘Nangleii angjet napuukme?’ Ama'n aleimasang, ‘Gehu saangphai lisingkhat,’ neikaensui pa'n amadiang ati, napuukna cheihi lei inlang rajariat majiaro. ");
INSERT INTO kfw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Khawajarra huoikajuomak neikaensui pa'n kasingnga atho jarra akaru in aminpaak, ajarchu manmasituol sa ngai'n inmani khangnga inmani inroonna chuonna war sangai neek ah kheella insing.” ");
INSERT INTO kfw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Halli Jisu'n inlet ah ati, “Nangni'n ningpumtak sik-ah manmasituolla ningnei sial le sum ngaikhan sap boolru, halli khawa kha ahekli nangni kha hektik kaboi innkhan innadonsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Atu ka-ang mi'n kasiinteii chounna ngamna katha mikha choun kalok khannum ngamna katha esik eii; atu ka-ang-in choun kasiinna ngamna kathamak mi khachu akalok chounna-um ngamna thanuni. ");
INSERT INTO kfw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nangni'n manmasituol neinaak ah ngamna katha ning emak inchu, tu-in nangnidiang inthiang neinaak ah ngamna nape niame? ");
INSERT INTO kfw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Halli nangni'n mi ngai neinaak ah ngamna kaom ning emak inle, tu-in ningta ka-eii neinaak kha nape niame?” ");
INSERT INTO kfw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Angtikseng suok inkhat in karu inni suok ethainuni; ama'n inkhat kha amatirsik eii, inkhat kha aminriangsik eii, emakle inkhatpa chong ajuisik eii, halli inkhatpa chong juinuni. Nangni'n Pathian li neilenung suok esuom theinutun.” ");
INSERT INTO kfw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sial kamanuom Pharisee ngai'n hiwa chong rakip injet phakhan ama kha inlei innuipui. ");
INSERT INTO kfw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Halli ama'n inmani diang aleiti, “Nangni ngaihi miring ngai mit-en sik ah katha inleem ning eii, takkha Pathian in ningmalung ngaikha ajet, tichu miring ngai'n inminlur kha Pathian diangchu kathamak khet eii.” ");
INSERT INTO kfw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses Dan li Pathian chongkachoi ngai'n inleimajia ngaikha John Baptist pha katung ileirilthang; khawapha makheiya Pathian Rengram jarra chong kahoi kha karil inleiphut, halli mi rakip in ranak soongnga inleinei, ");
INSERT INTO kfw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Takkha Dan chongramol inkhat kamangsik neek achu marwaan li nuoipil kamangsik kha abei.” ");
INSERT INTO kfw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Atu ka-ang pasal in anumei inthenpuili numeisa inkhat ajuonei inchu, zool-inthai eii; halli atu ka-ang pasal in aruothar le inthenjei numeisanu kha ajuonei inchu zool-inthai eii.” ");
INSERT INTO kfw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Apha inkhat inchong karaang mi inkhat aleiom ama'n aman katamkhet puonlidiar inluk ah nisuo rakip katui kathai abak ah kahoiya aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Halli sara pasal inkhat araming Lazarus inti apumparaang kapan inkhat aleiom, ama kha inchongpa innkhar kuungnga bu kanisik inleiruoi, ");
INSERT INTO kfw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Inchongpa bubakna khamtuol makheiya ajuokachul ngaikha kabak phangsik eii tia aleingaidon, ui ngai kha-um inheiwa ah ama kapan kha injuomaliak. ");
INSERT INTO kfw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hintia aleisuokjei, Sara pakha athiya Pathian tirton ngai'n Abraham omnamun khan inleiruoi, inchongpa kha-um athiya inleiphuum. ");
INSERT INTO kfw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Halli ama'n poongna mun meikhur makheiya chungtiang ahong enna Abraham koolla Lazarus in ileiom kha kalaaktak makheiya ahongmu. ");
INSERT INTO kfw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ama khan akheek ah ahongti, ‘Kapa Abraham! kei naminriangro halli Lazarus kha juotir inlang akutramolla tuiramol inkhat kamalei juomindainasik juomasarrase, ajarchu keihi meiya poongna kaneijei!’ ");
INSERT INTO kfw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Takkha Abraham in aleitipi, ‘Sapa ngaidonro, nang in naringlai katha rakip namujei, halli Lazarus chu kathamak ngaiseng aleimu, takkha atuunchu ama'n hiwahin hoina imu ejei, halli nang in poongna nimu ejei. ");
INSERT INTO kfw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hiwa rakip ngai chungnga, nangni kahongzoot ngai um hongthei maknasik, keini kajuosik ngai um kinjuo theimaknasik-ah keini li nangni kongkarra inphathei maknasik khurkalok inkhat in na-ook ah omjei.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Inchongpa in aleiti, “Hanchu Kapa Abraham kei'n kanani, Lazarus kha kapa inna natirpiro, ");
INSERT INTO kfw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kei ka-u ra-nga inom, hiwa poongnamun hin hongmak nasik ah ama'n sise inlang inmani ngaidiang chong juothakrase. ");
INSERT INTO kfw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham in ati, ‘Nang na-u nanai ngaidiang chong kapesik-ah Moses li Pathian chongkachoi ngai inom, na-u nanai ngai'n inmani chongkha rangai rasu.’ ");
INSERT INTO kfw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Inchongpa'n ahongmasang, ‘Kapa Abraham! Khawa ngaikhan hunmak, takkha kathi inkhat in aringnga inmani diang ajuoti inchu, inmani'n manu makhaiya malung thuulna nei-inte.’ ");
INSERT INTO kfw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Takkha Abraham in ati, ‘Inmani'n Moses khat-um Pathian chongkachoi ngai chong inrangaimak inchu, angtikniseng inmani'n miring inkhat kathi makheiya intheiya juominchu innum inmani'n malung thuulnunu.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Khale inruoiya Jisu'n asiamruoi ngaidiang aleiti, “ Manu thonasik-ah miringngai chungnga matheemna omgersik eii, takkha khawa ngai akamasuok amakha angtuk poongna kaomsikme. ");
INSERT INTO kfw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ama'n akasiin naipang ngaikha manu kamintho neek achu, ama riingnga lungchakari inkhit-ah tuipui suungnga indeengjuon kha athadet.” ");
INSERT INTO kfw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ningtheinuo ah insingtheiru! “Na-u nanai inkhat in manu intho inchu, ama kha ranro, halli ama'n amalung ahongthuul inchu rangaidamro. ");
INSERT INTO kfw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ama'n nisuokhat ah nangdiang woisari manu athoa, halli woisari nangdiang heikeirra ‘kei kamalung kathuuljei ati inchu,’ nang in ama kha rangaidamro.” ");
INSERT INTO kfw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tirton ngai in Pumi diang inleiti, “Keini ngamnahi naminlokpiro.” ");
INSERT INTO kfw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pumi'n aheimasang, “Anchamru tiatbit nang ngamna kha om-inchu, nang in hiwa mulberry thingkuung hi arajungnga inphuk inlang halli tuipuiya juomoongro nati innum! ama'n nang nachongkha ajuisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nangni karra miring inkhat keelngam kakhaal sik khat-um leikakhuoi sik suok inkhat aneiya halli ama'n lei makheiya ahongkir phakhan, amadiang innoottheiya heiwa inlang bu juobaktaro katipisik tu ning ommame? ");
INSERT INTO kfw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Khawa rathuulla nang in nakhoong khit inlaang ‘Kabak ka-insik minsuukro, kabak ka-insuo maklaiseng kasepa thoro, khawa suoli nang-um baktro nang in amadiang timak tinnabe.’ ");
INSERT INTO kfw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Suokpa'n ama chongpe ajui jarra minpaak sik rahoi suokmak, ama rahoi suok abe? ");
INSERT INTO kfw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Khawale in-ang rip-ah, nangnidiang thosik innapeii chounkha ningtho phakhan, ‘Keini chu rahoi kasuokmak suok ngaikha kin eii halli kinthosik kasuok chuonkha kintho eii” tiru. ");
INSERT INTO kfw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisu'n Jerusalem lamtiang aleisi phakhan Samaria li Galilee kongkarra aleitheng. ");
INSERT INTO kfw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ama'n khuosuung aheiluut phakhan kalaak-ah ka-ngirra kaleiom takbangri karool miring soom alei intongpui. ");
INSERT INTO kfw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Halli inkheek-ah inheiti, “Jisu, Karu, keini diang naminriangro.” ");
INSERT INTO kfw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Halli Jisu'n inmani kha aleimuwa aleiti, “Si inlang thiampu ngaidiang juoinmuru.” Halli inmani'n insina lamma in-iroon takbangri kha juodam tirjei. ");
INSERT INTO kfw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Inmani karra miring inkhat in ama idamkha amupha khan, aheikirnook ah rasa inringnga Pathian aleiminpaak. ");
INSERT INTO kfw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Halli Jisu kekuungnga inbok ah inpaakna aleimalar, halli ama kha Samaritan mi alei eii. ");
INSERT INTO kfw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisu'n aleiti, “Kadam kha miring soom emuwabe? Khawa ngai khale hun inom mejei? ");
INSERT INTO kfw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hiwa zaatlop mipahi elekleiya aleiilaak heikirra Pathian kaminpaaksik ommu bejei?” ");
INSERT INTO kfw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Halli Jisu'n amadiang aleiti, “Inthei inlang sitaro; nang ngamna khan nidam ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee ngai'n Pathian Rengram kha angtik ajuosikme tia Jisu diang inleirakel phakhan, ama'n inmani diang aleimasang, “Pathian Rengram chu eini mit-enna nimu angnnga juonuni. ");
INSERT INTO kfw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tuteii innum tinunu, ‘Enru, hin omjei!’ emakli, ‘Enru, sosun omjei!’ ajarchu Pathian Rengram kha nangni suungnga om.” ");
INSERT INTO kfw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Halli ama'n asiamruoi ngaidiang aleiti, “Nangni'n Miring sapa kha ningmuzootna nikhuo inkhat alahongsik eii takkha nangni'n munutun. ");
INSERT INTO kfw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Halli mi ngai'n nangnidiang innati sik eii, ‘Sosun enru, emakli hin enru!’ takkha nangni'n juimaru khat-um suokmaru. ");
INSERT INTO kfw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ajarchu lairalak mun inkhat makheiya kool juo-inlek phakhan, lairalaak mun inkhatiang ijuowar angnga miring sapa jouni khannum khawa ka-angsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama'n poongna angjet intongpui masasik eii halli hiwa khang mi ngai'n amakha zootnunu. ");
INSERT INTO kfw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Khat-um Noah khangnga kaleisuok angnga Miring sapa nikhuoni khannum alasuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noah in rakuong suungnga aluutmak laiseng, inmani'n inbak in-inna, inn inneiya, moi inruoiya inleiom, halli tuikalok tuikalian asuok ah inmani rakip aleiminmangjei. ");
INSERT INTO kfw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hiwale in angrip ah Lot nikhuoni khannum, inmani'n inbak in-in, inracho, injour, inling, halli inn insak ah inleiom. ");
INSERT INTO kfw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Takkha Lot in Sodom makheiya asuok nikhan marwaan makheiya mei khat-um kaatmei kha ruosur angnga ajuosurra inmani rakip ngaikha aleiminmang. ");
INSERT INTO kfw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Miring sapa juo-inlarna nikhuo nikhan num khawa angnga akasuok sik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Khawa nikhuoni khan innchungnga kaom in aneinaak kaleisik-ah innsuungnga juochumkhai marase, halli hiwa angnga leiya kaom atu ka-ang innum inntiang hongkirkhai marase. ");
INSERT INTO kfw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot numei kha ngaidonru! ");
INSERT INTO kfw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Atu ka-ang in ama ringkhuo kaminringsik ah ka-entok ama khan aminmangsik eii, atu ka-ang in ama ringkhuo kaminmang amakha'n ringna amusik eii. ");
INSERT INTO kfw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kei'n kanati, khawani zaanna zaalmun inkhat-ah mi inni inleizaalsik eii, miring inkhatkha aruoisik halli minring inkhat kha adasik eii. ");
INSERT INTO kfw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mi inni'n saang inleisuksik eii, miring inkhat aruoisik halli mi inkhat kha adasik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Leiya mi inni inleiomsik eii, miring inkhat kha aruoisik halli miring inkhat kha adasik eii. ");
INSERT INTO kfw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Halli inmani'n amadiang inheiti, “Hunme Pumi?” halli Jisu'n aleimasang, “Mikathi kaluong omna munkhan laangkia ngai'n intuupsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Halli Jisu'n asiamruoi ngaidiang Pathian diang inchat lekleiya nichaknasik khat-um malung juosiin maknasik-ah minkhina chong aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jisu'n aleiti, “Khuopui inkhat-ah Pathian kachimak khat-um mi ngai khoya kathomak chongkatan miring inkhat aleiom; ");
INSERT INTO kfw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Halli khawa khopui khan chuulmei inkhat-um aleiom, numeisanu khan chong katanpa diang aheiwazoolla ajuoti, ‘Kei inhalpui mi ngaikha phaphu naluokpiro aleiti. ");
INSERT INTO kfw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Takkha ama'n apha kasoottak leirangai pimak, halli ahekna ah ama'n atheinuoa inti, keihi Pathian kachimak emakli mi ngai kakayamak ka e-innum, ");
INSERT INTO kfw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","chuulmeinu khan keidiang heiwazoolla kanakacher sikneek achu, kei'n amadiang thopidan kasuok kha thopitakte. Halli kei'n kathopimak inchu ama'n heiwa zoolta keihi anaminpoongsik eii!’ ” ");
INSERT INTO kfw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Halli Pumi in aleiti, “Rangairu kathamak chongkatanpa'n i-tihi. ");
INSERT INTO kfw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Khat-um Pathian diang suun li zaan boiya Pathian diang niya kaom Pathian ikadang mi ngaikha Pathian in inmanisik-ah phaphu luokpimak niabe? Halli ama'n inmani kasansik hi insuumniabe? ");
INSERT INTO kfw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kei'n nangnidiang kanati, Pathian in inmani sikbit-ah innottheiya phu aluoksik eii. Miring sapa ajuonikhan nuoipilchung hin, kangamna lamunibo?” ");
INSERT INTO kfw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Atu ka-ang mi'n atheinuoa mikadik ka eii inti, halli mi ngaichu iteii emu tia kangaidon minkhi nahi Jisu'n aleiril. ");
INSERT INTO kfw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Miring inni'n biak-inna Pathian kani inleisi, inkhat khachu Pharisee eii, halli inkhat khachu rampar kakhoompa eii. ");
INSERT INTO kfw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee pa'n atheinuo ah a-ngirra aleini, ‘Pathian, kei'n nang kanaminpaak, tichu mi ngai angnga keihi kakheel innuomma mi ngai kakasuut, malung inthiangmak, emakli zool-inthai emong, hiwa rampar kakhoompa ka-ang um emong. ");
INSERT INTO kfw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kei'n haptakhat-ah sak woini kangei, halli kei'n kimasuok rakip tum soomma tumkhat nangdiang kanapeii.’ ");
INSERT INTO kfw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Takkha rampar kakhoompa khan kalaak-ah a-ngirra aroop kabeenna khat-um chuntiang-um hong-en matormak-ah, ‘Pathian, manu karoon keihi naminriangro tia aleini!’ ");
INSERT INTO kfw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kei'n kanati,” “Hiwa rampar khakhoompa'n Pathian mit enna aleiilaak mipa khaneek ah mikadik eya inntiang aleisi. Ajarchu apumtaak insaang mikha aminniamsik eii, halli apumtaak inniam mikha aminsaangsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Halli mi lekkhat in naipang ngaikha ama koolla rawaan penasik-ah inheiruoi, takkha asiamruoi ngai'n inmu phakhan ranna inleinei. ");
INSERT INTO kfw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Takkha Jisu'n naipang ngaikha ama koolla aleikoiya ati, “Naipang ngaihi kakoolla heiwarasu, inmani kha khaapmaru, Pathian Rengramhi inmani ka-ang ngaisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kei'n inthiangnga kanati, hiwa kadoong naipang ngai angnga Pathian Rengramkha ningkeiluutmak inchu angtik niteii Pathian Rengram luuttheinutun.” ");
INSERT INTO kfw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jihudi lamkakei inkhat in aheirakel, “Katha karu, hektik kaboi ringkhuo mutheinasik angme kei'n kathosik?” ");
INSERT INTO kfw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisu'n amadiang ati, “Angjarra katha ninatime?” “Tuteii katha ommu Pathian eleiya. ");
INSERT INTO kfw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pathian chongpekha najetbo: ‘Zool-inthai thomaro, mi thatmaro, inruup thomaro, mi ngaikha rilsemaro, nanu napa kayaro,’ ” ");
INSERT INTO kfw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ama'n aheimasang, “Hiwa chongpeii rakip ngaichu naipang ka-elai inphut kahongjuijeii.” ");
INSERT INTO kfw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisu'n hiwangai ajet phakhan ama diang aleitipi, “Nang in nathosik chuonkhat laom, naneinaak rakip juor inlang sara ngaidiang sempiro, nang in marwaan ramma na-inchongsik eii, halli heikirnook inlang kanuk najuiro.” ");
INSERT INTO kfw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Takkha ama'n hiwa ajet phakhan amalung leihoimak, ajarchu ama inchongthei mi eii. ");
INSERT INTO kfw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisu'n amadiang ahei enna ati, “Inchong mi ngai'n Pathian Rengram luutsik hi angtuk intakme. ");
INSERT INTO kfw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ajarchu inchong mi'n Pathian Rengram kaluutsik neek achu Salaileem in simphoi kuorra kaluutsik abeiwiai.” ");
INSERT INTO kfw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Khawa kajet mi ngai'n amadiang inti, “Hale atume ringna kamusik?” ");
INSERT INTO kfw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Takkha ama'n ati, “Miring ngaisik-ah ka-ethei makkha, Pathian diangchu ethei eii.” ");
INSERT INTO kfw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Khale inruoiya Peter in aheiti, “Enro, keini'n kin inn kinmathaanna nang nanuk kinnajuijei.” ");
INSERT INTO kfw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Oh,” Jisu'n inmani diang aheiti, “Kei'n nangnidiang inthiangnga kinnati, atu ka-ang in a-inn, anumei, a-u ngai emakli anu apa halli asa ngai Pathian Rengram sik-ah ning mathaan inchu ");
INSERT INTO kfw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","atuunna ringkhohin kataamma amusik khat-um kahongsik pha-ah hektik kaboi ringna inmusik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Khawa suoli Jisu'n asiamruoi soomleini ngaikha akoisuok ah inmani diang aleiti, “Enru! eini'n Jerusalem tiang nisisik eii, halli Pathian chong kachoi ngai'n Miring sapa chungnga inleimajia rakipkha kajuotungsik ejei. ");
INSERT INTO kfw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tichu ama kha zaatlop ngaidiang inpesik eii, halli ama kha innui puisik eii, injak inpesik eii, halli inmachinthuonsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Inmani'n ama kha inwuok ah inthatsik, halli ama kha nithum huuini ahongring nooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Takkha asiamruoi ngai'n chong ngaihi iteii leijetmu, khat-um hiwa irilsuok chong ngaihi inmani sikbeiya inthuuk ejarra, angtiname tikha inmani'n leijetmu. ");
INSERT INTO kfw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Halli Jisu'n Jericho aheinei phakhan, Bukani mitkacho inkhat lamsirra in-ongnga leiom. ");
INSERT INTO kfw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Halli ama'n mipui sirasa ajet phakhan, ama'n “angjarrame tia alei rakel?” ");
INSERT INTO kfw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Inmani'n amadiang inleiti, “Nazareth Jisu kha eii kasihi,” ");
INSERT INTO kfw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","halli ama'n ahongkheek, “Jisu! David sapa, kei naminriangro!” ");
INSERT INTO kfw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Halli amatiang kaom mi ngai'n omchianro tia ranna inleinei, takkha kheella ahongkhek nook, “David sapa! kei naminriangro!” ");
INSERT INTO kfw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Halli Jisu'n a-ngirra, mitkacho pakha amadiang heiruoinasik-ah chong aleipeii, halli ama'n ahong naiphakhan, amadiang aleirakel, ");
INSERT INTO kfw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Angme nang in keidiang ninna minthozoot?” ama'n aleiti, “Pumi,” “Kei kamit kamuzoot nookjei.” ");
INSERT INTO kfw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Halli Jisu amadiang aleiti, “Namit kha kamu etaro! nang inngamna khan inamidam ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Khawapha takkhan amitkha aleimuwa Pathian minpaak ah Jisu nuk aleijui, mi rakip in khawa inmupha khan Pathian kha inmani'n inleiminpaak. ");
INSERT INTO kfw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisu'n Jericho rakaanna aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Khawa khan araming Zacchaeus inti pasal inkhat aleiom, ama kha rampar kakhoom kalok khat-um inchong mi inkhat kha alei eii. ");
INSERT INTO kfw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ama'n Jisu kha tume tihi ajetzoot jarra alei enzoot, takkha amahi mi inniam alei eii, khat-um mipui katamtak in inlei-uum jarra Jisu kha leimu matormak. ");
INSERT INTO kfw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Khale inruoiya ama'n Jisu kha amuzoot jarra inmani matiang ataanna Jisu'n rakaannasik lamkhan theibajil kuung kha aleikalla aleiom. ");
INSERT INTO kfw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisu'n khawa muunkha hongtung phakhan, chungtiang ahong enna aleitipi, “Zacchaeus innoottheiya juochumro awini kei'n nangna innna kaomsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Khale inruoiya ama'n innoottheiya ajuochumma karok tak ah Jisu kha aleidonna, inntiang leiruoijei. ");
INSERT INTO kfw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Halli mi rakip in inmupha khan, inraya ah nemnum inleiti “Hiwa mihi manu karoonpa inna khuol mi ka-esik asijei!” ");
INSERT INTO kfw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchaeus in a-ngirra Pumi diang aheiti, “Rangairo karu! Kei kaneinaak herkhat hi sara ngaidiang kapejei, halli kei'n mi ngai neinaak maleisei kathoa kaleidel ngai leisuok inchu tum mili kheella kapekir nooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Halli Jisu'n amadiang aheiti, “Awini hiwa innsuung hin Sanminringna juotuungjei, tichu ama hium Abraham phungrui eii. ");
INSERT INTO kfw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ajarchu Miring sapa kajuohi akamangngai kaentok khat-um kasanringsik kajuo eii.” ");
INSERT INTO kfw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Halli inmani'n hingai rakip inrangai phakhan, Jisu'n Jerusalem aheinaiya hiwa minkhinahi aleirilpinook, halli Pathian Rengram hi atuuntak juosik angjei tia inmani'n inleingaidon. ");
INSERT INTO kfw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Khawa jarra Jisu'n ati, “Miring inkhat kalokthei choun karoon inkhat aleiom halli ama'n Reng inkhat inchangnasik ah ram kalaaktak inkhat ah aleisi, reng changsuoli inntiang hongkir nooksik tia aleingaidon. ");
INSERT INTO kfw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Halli ama'n asuok soom ngaikha akoiya Minas soomhi inmani diang aleipei, halli inmani diang ati, ‘Hiwa Minas hi kaheikir maklaiseng nangni'n hiwahi leiminweiru.’ ");
INSERT INTO kfw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Takkha amahi ami ngaitak in enzootmuwa ama nuk ah taangwa ngai inleiminsiya ‘Hiwa mipa hi keini reng ka-esik hi manuommung katisik ah inleiminsi.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Halli mipa kha reng eya aheikir jei, ama'n Minas hi angjetme inleiminwei ennasik-ah asuok ngaikha ama koolla heiwanasik-ah chong aleiminpeii. ");
INSERT INTO kfw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Halli mansakhet suokpa khan ama koolla aheiwa ah ati ‘Karu, nang i-napeii Mina inkhat in Mina soom kaleiminweijei.’ ");
INSERT INTO kfw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Halli ama'n ati, ‘Thajei’ ‘Akatha suokpa! Ajarchu nang in kasiinteii chuonna ngamna katha na-e jarra, khuopui soom karoon etaro.’ ");
INSERT INTO kfw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‘Inni huuina suokpa khan heiwa ah ati, Karu, nang mina inkhat in Mina ra-nga kaleiminweijei.’ ");
INSERT INTO kfw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Halli amadiang um ati, ‘Nang um khuopui ra-nga karoon etaro.’ ");
INSERT INTO kfw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‘Suok inkhat innum heiwa ah ati, Karu, puonna kakhit rep ah kida nang Mina kha hin omjei. ");
INSERT INTO kfw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kei'n nangkha kanachi ajarchu malung kathamak na-eii, nang nata ka-emak nang in nalei khat-um na i-wormak kha nang in narakhool.’ ");
INSERT INTO kfw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ama'n suokpa diang ati, ‘E suok kathamak! nang inrilsuok chong in chongtanna kananeisik! kata ka-emak kha kalei, khat-um ka i-wormak kha karakhool tia kei kamalung kathamak hi nang in nalei jetjei. ");
INSERT INTO kfw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kha e-inle angjarra nang in kei Mina hi nilei minwei makme? Naleiminwei inchu kei'n kaheikir phakhan Mina niminwei khale inruoiya juoleimak ningngabe?’ ");
INSERT INTO kfw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Halli khawa khanna kangir ngaidiang aleitipi, ama diangnga kaom ‘Mina hi kasut inlang, Mina soom kanei suokpa diang peru.’ ");
INSERT INTO kfw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Halli inmani'n ama diang inti ‘Karu, ama chu Mina soom aneijei!’ ");
INSERT INTO kfw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Kei'n nangnidiang kanati,’ ‘katamma kaneipa diang kheella inpesik eii, takkha i-teii kaneimakpa diang chu i-nei lekteii khaum inleidelsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Takkha keihi inmani chungnga in-reng kanamin ezootmak kei nanhalpui mi ngaikha heiruoi inlang kamaikuungnga thatru!’ ” ");
INSERT INTO kfw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hiwa arilsuoli Jerusalem tiang Jisu'n ma sa-ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Halli ama'n Olives chingbung koolla kaom Bethphage li Bethany ahongnai phakhan, asiamruoi inni diang hintipili ma minsa-ah aleitir, ");
INSERT INTO kfw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ningma ah kaom khuo khan siru khat-um ningluut phakhan, tuteii in inlachuongmak salungdai teii inthungnga kaomkha muningte, suut inlang hin juoruoiru. ");
INSERT INTO kfw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Halli tu ka-ang mi'n nangnidiang salungdai hi angsik-ah ningsuutme tia innarakel inchu, nangni'n hin tipiru, Karu sik ah arei om.” ");
INSERT INTO kfw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Khale inruoiya inmani'n insipha khan Jisu'n irilpi angnga injuomujei. ");
INSERT INTO kfw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Halli inmani'n salungdai teii kha insuutpha khan amapupa'n aleiti, “Angsik ah ningsuutme?” ");
INSERT INTO kfw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Inmani'n inleimasang, “Karu diang arei ompiya eii.” ");
INSERT INTO kfw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Inmani'n salungdai kha Jisu diang inheiruoi, Inpuondiar kha salungdai chungnga indaap ah Jisu kha inleiminchuong. ");
INSERT INTO kfw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jisu'n achuongnga aheiwa phakhan, inmanin gai'n inpuon ngaikha lamma inleithapi. ");
INSERT INTO kfw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ama'n Olives chingmuol makheiya juochumma Jerusalem ajuonai phakhan, anuk kajui mipui rakip in Pathian chountho kalokkha inleimu phakhan inkheek ah inleiminpaak ah inti, ");
INSERT INTO kfw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pumi ramingnga kajuo Renghi rawaan katha eii! marwaanna kadai erase halli lurna kha insaangkhet erase!” ");
INSERT INTO kfw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Halli mipui karra Pharisee lekkhat in inti, “Karu,” “Nasiamruoi ngaihi omchian nasik ranro!” ");
INSERT INTO kfw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ama'n aleimasang, “Kei'n nangnidiang kitihi eii, inmani'n inomchian inchu, hiwa lung ngai'n inhongkheek sik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisu'n Jerusalem khuopui aheinai phakhan, ama'n amuli aleichappuiya ati, ");
INSERT INTO kfw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Nang in awini nikhuo hin kadai munasik chuon nalajet limbe! takkha atuunchu nang in munutinjei! ");
INSERT INTO kfw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ajarchu nachungnga hiwa ka-ang nikhuo ngaihi asuoksik eii, khawakha e-inchu nang inhalpui ngai'n rakul bool-inta nangkha nakahin inta araki miliya nangkha innakhumsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Halli nang khat-um rakul sungnga kaom nang mi ngaikha innathasik eii, halli rakul suungnga kaom lung inkam ngaikha inmani'n minkamma danunujei, ajarchu Pathian in nangni kanasan ajuolai khan leijet makchujei!” ");
INSERT INTO kfw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Halli Jisu'n biak-inn aheiluut ah neinaak kajuorngai khat-um karachuo ngaikha kapuutsuok aleiphut ah, ");
INSERT INTO kfw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Inmani diang aleiti, “Hinthoa Pathian chongnga injiajei, ‘Kei biak-inn chu Pathian nina mun esik eii.’ Takkha nangni'n inruup ngai inthupna mun ningminchangjei.” ");
INSERT INTO kfw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Khat-um Jisu'n biak-inna nisuo rakip aleiminchu, thiampu kalian, Dan karu khat-um mipui lamkakei ngai'n ama kha thatnasik-ah inlei-ensui. ");
INSERT INTO kfw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Takkha inmani'n iteii thomator nasik lam leimumu, ajarchu mipui'n ama chongril kha katha tak ah inleirangai. ");
INSERT INTO kfw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nisuokhat Jisu'n biak-inna mipui diang iminchu khat-um chong kahoi arilla aleiom phakhan, thiampu kalian ngai, Dan karu ngai khat-um katar ngaikha inheiwa-ah ");
INSERT INTO kfw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jisu diang injuoti, “Keini diang heitiro, ang ranak naneiya hiwa ngaihi nithome? Emakli tume hiwa thonasik-ah ranak kanapeii?” ");
INSERT INTO kfw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisu'n inmani diang aleimasang, “Kei innum nangnidiang rakelna naneikate, keidiang heitiru, ");
INSERT INTO kfw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","John'n baptism imintho kha, Pathian diang makheiya kajuobe emakli manmasi makheiya kajuobe?” ");
INSERT INTO kfw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Halli inmani karra inbiakna inneiya inleiti, “Eini'n ‘Pathian diang makheiya’ niti inchu, ama'n natite halle ‘angjarra amakha ningngamna makme?’ ");
INSERT INTO kfw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Halli ‘Eini'n minring makheiya eii’ niti innum mipui'n eini kha lungnga innadeeng thatsik eii, ajarchu mipui'n John hi Pathian chongkachoi inkhat eii tia inlei.” ");
INSERT INTO kfw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Khawa jarra inmani'n “Humakheiya kajuome jetmung tia inleimasang.” ");
INSERT INTO kfw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Halli Jisu'n inmani diang aleimasang, “Ang ranak kaneiya hiwa ngairakip kithome kei innum nangnidiang tinuning.” ");
INSERT INTO kfw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Halli Ama'n hiwa chong minkhi nahi mipui diang karil aleiphut: “Apha inkhat-ah theibombil katho miring inkhat aleiom, rahuonkha chuon katho mi ngaidiang aminhuumma apha kasoot taksik-ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Theibom rakhoolpha ahongtungnga ama'n suok inkhat rahuon katho mi ngaidiang ramparman kalei aleiminsi takkha rahuon katho mi ngai'n suokpa kha inleiwuok-ah iteii minchoi lekleiya injuominkir. ");
INSERT INTO kfw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Halli ama'n suok inkhat aleiminsi nookjei, ama kha-um inwuok ah jakna kaomthei omchanna inrachaak ah kut karuok-ah inhongmin kirnookjei. ");
INSERT INTO kfw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Khawasuoli inthum changna suok kha-um aleitir, inmani'n ama kha kase-ah inwuok-ah inleidenjuon. ");
INSERT INTO kfw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Khawa khan rahuon mapu pa'n ati, ‘Angme kei'n kathosik? Kasapa kiminriang inkhat beihi kaminsi inchu inmani'n ama hi kaya inte!’ ");
INSERT INTO kfw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Takkha rahuon katho ngai'n amakha inmupha khan, inmani inkhatli inkhat inlei inti, ‘Hiwahi inluo kaluoksikpa kha eii, ama changsik kasuokkha einita enasik-ah eini'n amahi thattui!’ ");
INSERT INTO kfw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Inmani'n amakha inthat-ah halli akaluong kha rahuon raaltiang inleideengjuon.” “Jisu'n aleirakel, angme rahuon mapupa in inmani diang athosik?” ");
INSERT INTO kfw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Ama'n heiwata rahuon kangaak rakip ngaikha thatta, halli rahuon kha aleiilaak rahuon kangaak inkhat diang apesik eii,” Mi ngai'n hiwahi injet phakhan, inmani'n inleiti, “Acha inchu hiwahi kasuok emarase!” ");
INSERT INTO kfw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisu'n inmani diang ahei enna aleiti, “Angme, inthiang chong in iti? ‘Inn kasak ngai'n anemna ommakjei tia indeengjuon lungkha akilla kaom nemna kaomkhet lungkha ahong eii.’ ");
INSERT INTO kfw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Khawa lungchungnga kajuota miring rakip in alek alek ah inkoisik eii, halli khawa lung inn atu ka-ang diang ajuodeeng inchu ama kha rahut inchangsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Khawapha takkhan thiampu kalian ngaili dan karu ngai'n Jisu kha surnasik inleingaidon, ajarchu inmani'n hiwa minkhina rilsena chonghi inmani diang eii tia inleijet, takkha inmani'n mipu kha inleichi. ");
INSERT INTO kfw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Khale inruoiya inmani'n Jisu kha inmaruongnga chong rakel li surra, waikaroonpa li ranak kanei ngai kutchungnga peinasik inmani'n sialla inracho akatha inleem mi lekkhat Jisu kaensuisik inleiminsi. ");
INSERT INTO kfw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kaensui ngai'n Jisu diang inleiti, “Karu, nangchu kadik khat-um katuunna naminchu halli mi-um khoithen makche, takkha Pathian lungdou katuun kha naminchu tihi keini'n kijet. ");
INSERT INTO kfw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Keini'n Caesar diang rampar pesik hi Dan khan koibe koimakbe?” ");
INSERT INTO kfw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Takkha Jisu inmani ngaidon kathamak kha aleijet ah inmani diang aleiti, ");
INSERT INTO kfw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Dangkapum kha naminmuro, khawa khan atu ramil omme?” Inmani'n inti, “Caesar's.” ");
INSERT INTO kfw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jisu'n inmani diang ati, “Caesar takha Caesar's diang peru, halli Pathian takha Pathian diang peru.” ");
INSERT INTO kfw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Inmani'n mipui karra achongrilla Jisu kha leisur matormu, takkha ama masang nakhan inleingak ah inmani'n rilsik leijeitmuwa inomchianjei. ");
INSERT INTO kfw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Khawa khan kathi makheiya kahongring ommak kati Sadducees lekkhat Jisu diang inheiwa ah injuoti, ");
INSERT INTO kfw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","halli inmani'n Jisu diang inleirakel, “Karu, Moses Dan in keini sik-ah aleimajia, ‘Atu ka-ang a-u inkhat numei leineiya asa omleiya a-upa athi inchu anaipa'n anumei kha neita a-upa sik-ah sa aneipi sik eii. ");
INSERT INTO kfw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ulenai sari inleiom, upapa khan numei aneili sa neileiya athijei. ");
INSERT INTO kfw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Halli inni huuinapa'n aneinookjei, ");
INSERT INTO kfw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","khat-um inthum huuinapa innum aneinook jei, hiwa angnga sari ngai'n innei wiak ah sa neileiya inthiwiakjei. ");
INSERT INTO kfw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Khawa suoli numeisanu um athijei. ");
INSERT INTO kfw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kha e-inle kathi makheiya hongringni khan numeisanu kha atu numei esik me? Ajarchu numeisanu kha mi sari numei alei ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Halli Jisu'n inmani diang aleimasang, “Atuunnna khangnga sa ngachu inn innei khat-um inn neisik-ah azootpi. ");
INSERT INTO kfw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Takkha kahongsik khang khat-um kathiya inphut ringna kamusik rahoi ejei tia inlei mi ngai khachu inn neinunu khat-um inn kanei ti omnunijei. ");
INSERT INTO kfw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ajarchu inmani kha woikhat thinunujei, ajarchu inmani kha marwaan tirton ngaile in-angjei, halli thiya inphut karing sa ngaikha in-e jarra Pathian sangai inejei. ");
INSERT INTO kfw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Khawa jarra Moses innum, ‘Abraham Pathian, Isaac Pathian, khat-um Jacob Pathian tia’ akoilai khan kathi rakip inhongringjei tia Pumi jarra suulbuklai kaangna larik munkhan inthiangnga amalarjei. ");
INSERT INTO kfw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Khawa jarra amahi kathi Pathian emak takkha akaring Pathian eii, halli mi rakip in amadiang ringna inmusik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dan karu lekkhat ngai'n inhongmasang, “Karu, katha ah namasangjei.” ");
INSERT INTO kfw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Khawa makheiya inmani'n inngam hiaiya Jisu diang iteii leirakelzoot mujei. ");
INSERT INTO kfw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Takkha Jisu'n inmani diang aleiti, “Angtho thoa Christa hi nangni'n David phungrui eii ningtime? ");
INSERT INTO kfw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tichu David tak in ati Minpaakla larik ah, ‘Pumi in kei ka Pumi diang ati: kei kakut changtiang in-ongro, ");
INSERT INTO kfw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kei'n ninhalpui ngaikha naketouna kaminchang makleiseng.’ ");
INSERT INTO kfw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David innum ‘Pumi’; tia akoi inle, angtho thoa Messiah hi David's sapa eniame?” ");
INSERT INTO kfw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Khale inruoiya mipui'n inrangaiya inom phakhan Jisu'n asiamruoi ngaidiang aheiti. ");
INSERT INTO kfw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Dan karu ngai makheiya insingtheiru, songkol inchuol inlukzoot, halli phaisungnga chubei inthosik kamanuom, Synagogue ngaikhan in-ongna kathakhet kakadang, mipui bubakna karra in-ong mun kahoikhet kakadang ngaikha in eii. ");
INSERT INTO kfw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Inmani'n Chuulmei ngai innle-lei inkasut, halli aomchan kathoa kasoot ah Pathian kani, inmani ngai poongna kha kheella asedoomsik eii!” ");
INSERT INTO kfw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Khat-um Jisu'n ahei enphakhan inchong ngai'n biak-inn sialkok ah kutchoi inpe ngaikha aleimu. ");
INSERT INTO kfw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ama'n chuulmei saranu innum sumsenpum inni ileimachun kha aleimu. ");
INSERT INTO kfw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ama'n ati, “Kei'n inthiangnga natipikate, hiwa ngai chungnga sara chuulmeinu'n kheella apei. ");
INSERT INTO kfw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tichu Pathian kutchoi penamunna nang ningai rakipchu ning innei chungnga inliak ningpe eii, takkha hiwa chuulmeinu inchu sara e-innum ama ringnasik-ah inei rakipkha i-pe eii.” ");
INSERT INTO kfw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Halli hiwa lung katha ah insak biak-inn hi angtuk enzoot kaomme khat-um Pathian diang inpei kutchoihi angtuuk enzoot kaomme tia biak-inn jarra asiamruoi lekkhat in inleiril. Halli Jisu'n ati, ");
INSERT INTO kfw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nangni'n ning i-mu rakip ngaihi, lung inkhat chungnga inkhat inkamhi chiamleiya danuni; halli lung rakip minchiam leiya damaknasik apha kha laheiwasik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Halli inmani'n inleirakel, “Karu, hiwahi angtik ah kasuoksikme, khat-um hiwa hongsuoknasik angkachang jettheina omsikme?” ");
INSERT INTO kfw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisu'n inmani diang aleiti, “Tuteii mi'n nangnikha lamleiiya naruoi maknasik inringtheiru, ajarchu mi angjet in kei karamingnga hong inta intisik, kei Christa ka eii, halli aphakha juonaijei intisik eii. Takkha nangni'n inmani nuk juimaru. ");
INSERT INTO kfw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Halli nangni'n raal khat-um raalthang ningjet phakhan chimaru, hingai rakip hi ahongsuok masasik eii, takkha aheknachu la-enuni.” ");
INSERT INTO kfw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ama'n inmani diang aleiti, “Zaat inkhat chungnga zaat inkhat, han rengram inkhat chungnga rengram inkhat in raal inlathosik eii, ");
INSERT INTO kfw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","amun rakip ah rinook ka-ngar, bukawaang, khat-um nanasatna angjet ahongsuoksik, han chikaom omchan inlak marwaanna inphut alasuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Takkha hiwa ngaihi suokma ah inmani'n nangni kha nasur inta narachaaksik, halli nangni kha innalaminpoong sik, nangni kha synagogue ngaikhan naruoi inta halli mikhumna-ah nadasik, halli kei raming sikbeiya reng ngaili waikaroon ngai maikuungnga innarouisik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Hiwa phahin ejei nangni'n chong kahoi sik-ah sakhi ning inchangnasik. ");
INSERT INTO kfw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Apha kha hongtung maklai nangni'n angme kamasangsik tia ningmalung leimindongmaru. ");
INSERT INTO kfw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tichu nangni'n ning inhalpui ngai'n iteii nalouthei maknasik kei'n nangni diang lungsing lungwar kanapesik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nangni ngaihi ningnu ningpa, ning-u ningnai, ning indiang inwaipui, khat-um ningsappui rakip ngai'n inna-enhalsik eii, halli mi lekkhatchu inmani'n thina um inlapesik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kei kajara mi rakip in nangnikha naenzootnunu. ");
INSERT INTO kfw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Takkha naluwa samramol inkhat um mangtheinuni. ");
INSERT INTO kfw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nangni deiraat nakhan ringna ningmusik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Takkha nangni'n Jerusalem kha raalmi ngai'n inkahiin ningmu phakhan, jetru amangnasik apha anaijei. ");
INSERT INTO kfw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Khale inruoiya Judea suungnga kaom mi ngaikha ching ngaikhan taanrasu, khat-um khuopui suungnga kaom mi ngai kha-um suokrasu, halli asir apangnga kaom khuo ngai innum khawakhan heiluut khai marasu. ");
INSERT INTO kfw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ajarchu inthiang chongnga injia rakip ‘Huui tungnasik ah rachaakna nikhuo’ ngaikha ejei. ");
INSERT INTO kfw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Angtuk poongna khame khawa phakhan naikawon khat-um naidoong kanei numeisa ngaisik! Tichu hiwa ramhi poongna'n asipsik halli Pathian raangna kha hiwa mi ngaidiang omsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mi lekkhat kha chemma inthisik eii, mi lekkhat kha raal ringnga suur inta zaat rakip diang inruoi sik eii, halli zaatlop ngai phakha hekmak laiseng Jerusalem hi zaatlop ngai'n ketouna inminchangsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Khawasuoli kani, tha, arsi rakipdiang omchan inlak nimusik, halli manmasituol tuipui inruungrasa khan chinale inlaina suokta zaatle phungngai chungnga poongna raalna suoksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Manmasituolla kasuok rakip en-inta miring rakip malunghi kachi'n sipta injuopursik eii, han lairalaak ah ranak rakipkha minnik sik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Halli Miring sapa kha suumphai chungnga ama ranak ngarna khat-um lurna kajuokha ninmusik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hiwa rakip hongsuok phakhan, inthei inlang chungtiang enru, ajarchu nangni sanminringna nikhuo kha ajuonai jei.” ");
INSERT INTO kfw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Halli inmani diang chong minkhina aleirilpi: “Theichang kuungli thingkuung ngaidiang enru. ");
INSERT INTO kfw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Hiwa ngai'n adoon hongpha khan kholum hongnaijei tia nangni'n ningmuli ninjet. ");
INSERT INTO kfw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Khawa kha angnga, nangni'n hiwa chuon kasuok ngairakip ningmu phakhan Pathian Rengram juonaijei tihi jetru.” ");
INSERT INTO kfw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Kei'n inthiangnga kanarilpi, hiwa chuon rakip ngaihi huui tungmak laiseng atuunna mi ngaihi thinunu. ");
INSERT INTO kfw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Marwaan khat-um nuoipilchung hi lamang sik, takkha kei kachongngai hichu angtik niteii mangtheinuni. ");
INSERT INTO kfw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Kabak ka-in, ju-inrui, tuunlaiya omchan kathamak khan ningmalung peluut maknasik khat-um khawa nikhuo kha changkachim angnga ningchungnga jetlei theileiya chimmak nasik-ah nangni'n inringchakru. ");
INSERT INTO kfw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ajarchu khawa nikhuoni kha manmasituol pumpuiya kaom mi rakip diang kalasuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ajuo kasuoksik poongna rakip ah inkhitmak khat-um Miring sapa kekuungnga nangni'n ningngir matornasik apha rakip ah kadei karaat e-inlang nichakru.” ");
INSERT INTO kfw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nisuo rakip ah Jisu'n Biak-inna aleiminchu, takkha zaanpha khanchu Olives chingkhan asiya ajuoriak kachak. ");
INSERT INTO kfw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Halli ziingtiang rakip chu mipui in biak-inna ama chongril karangaisik-ah inheiwa. ");
INSERT INTO kfw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chol inchelmak waipool bakna kahoi tia inkoi Rakaanna kahoi phakha hongnaijei. ");
INSERT INTO kfw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","‘Khale inruoiya thiampu kalian khat-um Dan karu ngai'n Jisu kha angtho thoa thatsikme tia ruuk ah inleiensui, takkha inmani'n mipui kha um inleichi. ");
INSERT INTO kfw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Seitan in Judas Iscariot inti asiamruoi soomleini ngai karra inchel amadiang aleiluut. ");
INSERT INTO kfw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Khale inruoiya Judas in thiampu kalian ngai khat-um biak-inn kangaak kalok kalian ngaidiang asiya Jisu kha angtho thoa nangnidiang kanapesikme tia inlei inbiak. ");
INSERT INTO kfw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Inmani'n ama kha inleirokpui halli sial penasik ah inlei inzootna. ");
INSERT INTO kfw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas in aphakacha enna mipui ngai minjetleiya inmani diang Jisu penasik aleizootpi. ");
INSERT INTO kfw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Khawa makheiya chol inchelmak waipool bakna nikhuo, tichu rakaanna kahoi sik-ah keelngamteii inthatnasik nikhuo kha hongtungjei. ");
INSERT INTO kfw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Halli Jisu'n Peter li John diang hin tipiya aleitir, “Si inlang rakaanna kahoi bu kha eini baksik-ah juominsuuktaru.” ");
INSERT INTO kfw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Halli inmani'n Jisu diang inheirakel, hunme keini'n minsuuknasik nimanuom? ");
INSERT INTO kfw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ama'n aleimasang, “Nangni'n khuopui suungnga ningsi phakhan, miring inkhat beella tui choiya kaheiwa inkhat intongpui ningte, ama kha jui inlang aluutna innkhan juoluutru, ");
INSERT INTO kfw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","halli khawa inn mapupa diang tipiru, ‘Karu'n hongti, kei kasiamruoi ngaile Rakaanna kahoi bu kinbaknasik inn kha hunme?’ ");
INSERT INTO kfw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ama'n chung-inn khan inndunglai kaloktak angrakip indoon dimma kaomkha namingmute, khawa khan leiminsuukru.” ");
INSERT INTO kfw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Inmani'n ang rakip Jisu iti angnga inleimujei, halli inmani'n rakaanna kahoi bu kha inleiminsuuk. ");
INSERT INTO kfw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Khat-um apha juotung phakhan, Jisu'n khamtuolla ama tirton ngai khale inlei in-ong, ");
INSERT INTO kfw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ama'n inmani diang aleiti, “Kei'n kapoongnasik hongtung ma-ah hiwa Rakaanna kahoi bubaksik hi kamanuom theijei. ");
INSERT INTO kfw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ajarchu kei'n kanati, Pathian Rengram kha juotung maklaiseng kei'n bakkhai nuningjei.” ");
INSERT INTO kfw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Halli Jisu'n rabing kha aleiya Pathian diang minpaak ah ati, “Hiwahi lei-inlang nangni karra semru. ");
INSERT INTO kfw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ajarchu kei'n nangnidiang kanati, atuunna inphut Pathian Rengram kha juotung maklaiseng hiwa theibomju hi kei'n inkhai nuningjei.” ");
INSERT INTO kfw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Halli ama'n waipool kha aleiya Pathian minpaak ah halli akatherra inmani diang hin tipiya aleipeii, “Hiwahi nangni sik-ah kinpesuok kei kapumtak kha eii, hiwahi kei ningna ngaidonnasik ah thoru.” ");
INSERT INTO kfw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Khawale in-angnga waipool kha inbak suoli rabing kha aleiya aleiti, “Hiwa rabinghi nangni sikbeiya akasar kei thisen makheiya inzootna kathar kha eii.” ");
INSERT INTO kfw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Takkha, enru! kei kanajuorsik mipa kha keile khamtuolla kin omsuom! ");
INSERT INTO kfw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Miring sapachu Pathian izoot nuoiya athisik eii, takkha ama kajourpa khachu angtuk poongna kaesikme!” ");
INSERT INTO kfw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Halli inmani karra inlei inkel, atukhame hiwa kathosik. ");
INSERT INTO kfw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Halli inmani karra tume kalokkhet tijarra inmani'n murruolsiak inleitho. ");
INSERT INTO kfw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisu'n inmani diang aleiti, “Zaatlop reng ngaichu ami ngai chungnga ranak kanei khat-um waikaroon ngai in eii, ‘Mipui ngai sap kin eii inmani'n inleiti.’ ");
INSERT INTO kfw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Takkha nangnidiang chu etheinuni, khaneek achu, nangni karra kalokkhet pa'n naipang khet angrase, halli lamkakei pa'n suok ka-ang erase. ");
INSERT INTO kfw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tichu atukhame akalokkhet, kabaksik-ah in-ongpa khabe, emakli nangni sepa kanathopa khabe? Halle kabaksik-ah in-ongpa kha emak niabe, takkha keichu nangni sepa katho inkhat kha ka eii.” ");
INSERT INTO kfw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Nangni ngaihi ning eii kei poongna rakip ah kanahong deipui. ");
INSERT INTO kfw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Halli Kapa'n kei diang wairoonnasik ranak i-nape angnga, kei innum nangnidiang khawa angnga kanapesik eii. ");
INSERT INTO kfw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nangni'n kei Rengramma kei khamtuol khan kabak ka-in ning esik eii, halli nangni'n reng in-ongna munna in-ong ningta Israel zaat soomleini chungnga wai ningroonsik eii. ");
INSERT INTO kfw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon! rangairo! Seitan in nangni ngaihi leikanei pa'n gehu li gehu rasi ikhoithen angnga nangni ngai um nakhoithen nasik inzootpijei. ");
INSERT INTO kfw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Takkha, Simon, kei'n nang ngamna kha mangmak nasik ah Pathian kananipi, halli nang in namalung nathuulnook phakhan, na-u nanai ngamna kha mincheetro.” ");
INSERT INTO kfw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ama'n Jisu diang aheiti, “Pumi, Kei'n nangle mikhumna khat-um nangle kathisik-ah ka-inringchak ah kaomjei.” ");
INSERT INTO kfw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisu'n aleimasang, “Peter, kei'n kanati” “Awini zaan woithum kei nazootmong natimak laiseng arkhong kha khuongnuni.” ");
INSERT INTO kfw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Khale inruoiya Jisu'n ama siamruoi ngaidiang aheiti, “Kei'n sialkok, khouchou emakli kekok choileiya kanaminsi phakhan, ang ning-insam ame?” “Iteii insam mung” tia inmani'n inleimasang. ");
INSERT INTO kfw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisu'n ati, “Atuunchu” “Tu ka-ang in sialkok emakli khouchuo ningnei inchu choitaru, halli atu ka-ang in chem ningneimak inchu ningpuondiar juor inlang inkhat rachoru. ");
INSERT INTO kfw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ajarchu Kei'n nangnidiang kanati, ‘Ama kha manu karoon ngai Poongna kha adei’ tia kei kajarra iril Pathian chongkha inthiangnga huui latungsik eii, ajarchu kei kajarra lei-injia rakip kha huui hongtung sikjei.” ");
INSERT INTO kfw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Halli inmani'n inleiti, “Enro! Pumi hiwahin chem inni om!” Halli ama'n inmani diang aleiti, “hiwahin hunjei!” ");
INSERT INTO kfw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Halli Jisu'n aheisuok ah Olives chingtiang a-ngai angnga aleisi, halli asiamruoi ngai'n inleijui. ");
INSERT INTO kfw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ama'n khawamun khan atungli inmani diang aleiti, “Matheemna ah chulmak nasik nangni'n Pathian niru.” ");
INSERT INTO kfw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ama'n lungtum inkhat nideengjuon inkardanna inmani diang makheiya alei inlaak, halli kemurkhup thep ah Pathian aleini. ");
INSERT INTO kfw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ama'n aleiti “Kapa,” “Nang nalungduo e-inchu, Kei diangnga inphut poongna rabinghi nakhaipiro, takkha kei kalungduo emarase, nang nalungduo erase.” ");
INSERT INTO kfw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Marwaan makheiya Pathian tirton inkhat juominlarra amadiang ranak ngarna aleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Khat-um ama'n poongnakhan asipjarra kheella aleini, halli ama rathan kha neipilla thilom kasar angnga aleisar. ");
INSERT INTO kfw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Halli ama'n Pathian nina makheiya ahong intheili ama asiamruoi ngai koolla aheiwa ah inmanikha inmalung poonghei jarra inleizaalbirra inleiom kha ama'n ajuomu. ");
INSERT INTO kfw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jisu'n inmani diang aleiti, “Angsik ah ningla zaalme? Inthei inlang matheemna khan namator maknasik Pathian niru.” ");
INSERT INTO kfw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisu'n chong arilla omleitak phakhan, mi katamtak inheiwa ah asiamruoi soomleini karra inchel Judas inti ama'n lam heikeiya Jisu kha juonaiya mazoop sik aleitho. ");
INSERT INTO kfw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Takkha Jisu'n amadiang aleiti, “Judas, Miring sapa hi mazoop nata najuorsik bejei?” ");
INSERT INTO kfw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Amale kaom asiamruoi ngai'n angme kasuoksik tihi inleijet phakhan, inmani'n inleiti, “Pumi, keini'n chemma tukjeinungbo?” ");
INSERT INTO kfw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Halli inmani karra minring inkhat in Thiampu kaliankhet suok inkhatpa changtiang kuor aleitukthakpi. ");
INSERT INTO kfw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Takkha Jisu'n aleiti, “Hiwahin hunjei!” Ama'n akuor kha katook piya mindampi nookjei. ");
INSERT INTO kfw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Khawa suoa Jisu'n Thiampu kalian ngai, biak-inn kangaak, kalok kalian ngai, khat-um katar ngai'n ama kasur inheiwa phakhan inmani diang aleitipi, “Mi kathamak kasursik angnga chem khat-um ramol ningchoiya ningheiwame? ");
INSERT INTO kfw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kei'n nangnile biak-inna nisuo rakip kaomlai khan nangni'n nasursik thomakchu, takkha nangni'n hiwa thonasik apha ejei ajarchu kaziing in wai roonjei.” ");
INSERT INTO kfw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Inmani'n Jisu kha insurra Thiampu kaliankhetpa inna inleiruoi, halli Peter in inmanile inkar jenna aleijui. ");
INSERT INTO kfw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Halli inmani'n tuollaidung laiya mei inlathoa inraya ah inlei in-ong, Peter um inmani ngaile alei in-ong. ");
INSERT INTO kfw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Halli suok numeisa inkhat in Peter kha khawa meikoolla in-ong aheimu phakhan numeisanu'n Peter diang ahei enna aleiti, “Hiwa mipa hium Jisule kaomsuom ah eii!” ");
INSERT INTO kfw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Takkha Peter in leizootmak, halli “numeisanu diang aleiti, ama kha kei'n jetmong.” ");
INSERT INTO kfw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Halli apha lekkha athengsuo nuk miring inkhat in aheimunook ah aleiti, “Nang um inmani karra na inchelnu!” Takkha Peter in aleimasang, “Mipa, kei e-mong!” ");
INSERT INTO kfw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Phadan inkhat thengnookli miring inkhat innum natheiya aheitinook, “Kadik kha eii hiwa mipa hium Jisu le kaomsuom ajarchu ama hi Galilee mi eii.” ");
INSERT INTO kfw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Takkha Peter in aleiti, “Mipa, Kei'n inthiangnga nang etikha jetmong” halli chong arilla omlaitak khan arkhong kha ahongkhuongjei. ");
INSERT INTO kfw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pumi'n ahei inlet ah Peter diang ahei-en, halli Peter in Pumi ileiti chongkha ahongngaidon, “Wini arkhong kha hongkhuong ma-ah nang in kei kha woithum najetmong natisik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Halli ama'n asuok ah malung intooktheiya aleichapjei. ");
INSERT INTO kfw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Halli Jisu kangaak mi ngai'n ama kha inlei innuipui khat-um inleiwuok. ");
INSERT INTO kfw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Inmani'n ama kha amit inkhumpiya inleirakel, “Tunme nang kanawuok? heitiro!” ");
INSERT INTO kfw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Halli inmani'n amadiang rangaizoot kaommak chongkase angjet inleiril. ");
INSERT INTO kfw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Khawasuoli khuo ajuowarra, uparup ngai, thiampu kalian ngai, halli Dan karu ngai intuupna inleineiya Jisu kha chongtanna inna inleiruoiya inleiti, ");
INSERT INTO kfw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Keinidiang natipiro,” “nang Christa kha naebe?” Takkha ama'n aleiti, “Kei'n kanatipi innum, nangni'n ngamna nutun. ");
INSERT INTO kfw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Halli kei'n nangnidiang rakelna kananei innum nangni'n namasang nutun. ");
INSERT INTO kfw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Takkha atuun makhei achu Miring sapa hi ranak kanei Pathian ama kutchangtiang in-ongsik ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Halli inmani'n rakip in inleiti, halle, “Nang Pathian sapa na-ebe?” Ama'n inmani diang aleimasang, “Nangni'n kei ka-ei ningna tijei.” ");
INSERT INTO kfw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Halli inmani'n inleiti, “Eini'n iteii sakhi leisik arei ommakjei! ajarchu amur tak-in irilkha eini'n nijetjei!” ");
INSERT INTO kfw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mipui ngai'n inhong intheiya Jisu kha Pilate maikuungnga inleiruoi, ");
INSERT INTO kfw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Halli inmani'n ama kha noonkuung inpeiya iheiti, “Keini'n kinjet, ama'n Caesar diang rampar pechamak tia eini mi ngaihi kathamak tiang akeiruoijei halli atheinuo ah Reng Christa ka eii inti.” ");
INSERT INTO kfw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Halli Pilate in aheirakel, “Nang Jihudi ngai reng na-ebe?” Jisu'n aheimasang, “Nang eti kha ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate in Thiampu kalian ngaili mipui diang ati, “Kei'n amadiang athamakna iteii mumong.” ");
INSERT INTO kfw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Takkha inmani'n kheella inhongkhek ah inleiti, “Ama minchunna khan Judea ramsuungnga kaom mi rakip aminhaangjei. halli ama'n Galilee makheiya aphut ah atuunchu hiwahin aheitungjei.” ");
INSERT INTO kfw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Halli Pilate in hiwajarra ajetpha khan, ama'n aleirakel, “Hiwa mipa hi Galilee mibe?” ");
INSERT INTO kfw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Halli ama'n Herod roonna ramsuung makheiya eii tia aleijet, halli Herod kha-um khawapha takkhan Jerusalemma aleiompiya Pilate in Jisu kha Herod kooltiang aleiminsi. ");
INSERT INTO kfw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod in apha kasoottak ah intongpuisik tia ileingaidon Jisu kha amupha khan aleirokthei, ajarchu ama'n Jisu jarra aleijet, halli amadiang makheiya inlak chuon lekkhat ithokha aleimuzoot. ");
INSERT INTO kfw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Khale inruoiya Herod in Jisu diang chong katamtak aleirakel, takkha ama'n leimasangmak. ");
INSERT INTO kfw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Thiampu kalian ngaili Dan karu ngai'n Jisu diang kanathei noonkuung inleipeii. ");
INSERT INTO kfw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Khawa khan Herod khat-um ama raalmi ngai'n Jisu kha kase ah inrilse ah innuipui halli katha puondiar inminluk ah Pilate kooltiang inleiminkirnook. ");
INSERT INTO kfw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Inhaltheiya kaleiom Herod li Pilate kha khawa nikhuoni makheiya inhong inngeijei. ");
INSERT INTO kfw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate in thiampu kalian ngai, waikaroon ngai khat-um mipui kha aleikoi, ");
INSERT INTO kfw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Inmani diang aleiti, “Nangni'n Jisu hi mipui ngai kha lamleiitiang kakeiruoi mi eii tia kei kadiang ningheiruoi jei, enru nangni maikuungnga chong angjet karakella ensuina kaneijei, halli nangni'n ama chungnga noonkuung ningpena ngaikha amadiang iteii mumong. ");
INSERT INTO kfw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod innum noonkuung pesik mumak khawa jarra ama'n hiwa mipahi einidiang iheiminwa nook eii, enru ama'n thina penasik-ah rahoi kasuok chuon iteii thomak. ");
INSERT INTO kfw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Khawa jarra kei'n ama hi rachaak kata kamasuo sikjei.” ");
INSERT INTO kfw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Rakaanna kahoi inthopha khan Pilate in inmani sikbeiya mikhumna makheiya mi inkhat aleimasuo kachak. ");
INSERT INTO kfw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mipui rakip in inhongkheek, “Ama kha thatro! keini sik-ah Barabbas kha namasuopitaro!” ");
INSERT INTO kfw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas hi khuopuiya lamkathoi khat-um mikathat ejarra mikhumna ah inleida kha eii. ");
INSERT INTO kfw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jisu kha amasuozoot jarra Pilate in woikhat inlet-ah mipui diang hongtinook. ");
INSERT INTO kfw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Takkha inmani'n inhongkheek ah inleitinook, “Ama kha Cross ah thatro! Cross ah thatro!” ");
INSERT INTO kfw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Woithum huuina mipui diang Pilate in ahongrilnook, “Ama'n angkachang kathamak atho ame? Kei'n amahi thina katung penasik noonkuung mumong, kei'n rachaak kata kamasuosik ejei.” ");
INSERT INTO kfw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Takkha ama kha cross ah that nasik ah, kheella inhongkheek ah inmani kheekrasa kha aleirangai pijei. ");
INSERT INTO kfw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Khale inruoiya Pilate in inmani i-manuom kha aleizoot pijei. ");
INSERT INTO kfw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ama'n kathamak katho khat-um mikathatpa kha mikhumna makheiya masuopiya, inmani imanuom dungjuiya thonasik-ah Pilate in Jisu kha inmani diang aleipejei. ");
INSERT INTO kfw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Raalmi ngai'n Jisu kha inleiruoijei, Simon inti Cyrene ram makheiya kaheiwa kha insuira cross kha inleiminput ah Jisu nuk inleiminjui. ");
INSERT INTO kfw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mipui katamtak in ama nuk inleijui, khat-um inmani ngai karra numeisa leikhat in inroop inkabeenna inchappuiya Jisu nuk inleijui. ");
INSERT INTO kfw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Takkha Jisu'n nuk malet ah aleiti, “Jerusalem numeisa ngai! kei kasik beiya chapmaru, takkha ningpum sile ningsa ngaisik-ah chapru. ");
INSERT INTO kfw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ajarchu enru, nikhuo kha lahongtung sik mipui ngai'n inlatisik, ‘Numeisa wonkachoi mak ngai, sa iteii kalanei mak ngai, khat-um angtik niteii aranu kalawaimak numeisa ngaikha angtuk rawaan kathame!’ ");
INSERT INTO kfw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Halli khawa phakhan inmani'n chingbung diang inti, ‘Keni diang juochim inlang najuodeeng taro!’ ‘Halli chingteii diang namakhu taro’ ningti sik eii. ");
INSERT INTO kfw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tichu, mipui ngai'n thingkuung kha adumlai hiwa chuon ngai intho inle angme kachangsik thingkuung kha ahongcharni khan?” ");
INSERT INTO kfw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kathamak katho miring inni kha um Jisu le thatna sik-ah inleiruoi. ");
INSERT INTO kfw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Inmani'n “Lukiar” tia inkoinamun inleitung phakhan, khawakhan Jisu kha inmani'n cross ah makaina inleinei, halli kathamak katho inni kha-um khat-in changtiang khat-in weitiang cross ah inleimakai. ");
INSERT INTO kfw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisu'n ati, “Kapa, inmani kha ngaidampiro! ajarchu inmani'n angme inthohi jetmu.” Inmani'n rasi in-enna ama puondier inlei insem. ");
INSERT INTO kfw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mipui'n inngirra inlei enpha khan, waikaroon ngai'n amadiang inleiril seya inti, “Mi ngai khachu nasan, Pathian inakadang Christa kha na e-inchu natheinuo ah insanro.” ");
INSERT INTO kfw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Raalmi ngai innum, ama koolla inhongnga ju kathur kha inleipeya inlei innuipui, ");
INSERT INTO kfw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","halli “Nang in Jihudi ngai Reng na e-inchu natheinuo ah insanro!” ");
INSERT INTO kfw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ama luchungnga hiwa chong hi inleimajia. “Amahi Jihudi ngai rengpa eii.” ");
INSERT INTO kfw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Inmakaiya kaom kathamak katho miringkhat innum arilthaiya aleiti, “Nang Christa emak cheyabe? Napumtak insanro halli keini um nasanro!” ");
INSERT INTO kfw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Takkha minring khatpa in aheiranna ati, “Nang Pathian chimak chebe? Nang um ama le in-angrip ah poongna nimu ejei. ");
INSERT INTO kfw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eini chu eini nithoman nimu kha eii, takkha ama chu iteii imasial ommak.” ");
INSERT INTO kfw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Halli ama'n Jisu diang ati, “ Pumi nang na Rengram naluut phakhan keihi najuo ngaidonro!” ");
INSERT INTO kfw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisu'n ama diang aheiti, “ Kei'n inthiangnga kanati, awini nanghi keile inruoiya Paradise ah nihong-om suomsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Phadan soomleini chunsiktiang khawa ramsuung rakip ah kaziing in aleisip halli phadan inthumchen aleiziing. ");
INSERT INTO kfw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Halli kani ra-ang kha juoziingjei, biak-inn suungnga puonduong kha lekniya inkhoi therjei. ");
INSERT INTO kfw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Khale inruoiya Jisu'n inringnga hong kheek ah ati, “Kapa! nang nakut ah kei karatha hi kanapeluut jei!” Ama'n hiwa tisuoli arang chatjei. ");
INSERT INTO kfw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Raalmi kalokpa'n kasuok rakip amu phakhan hintia Pathian aleiminpaak, “Inthiangnga amahi mi kadik eii!” ");
INSERT INTO kfw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Khawa khanna ka inchun mipui ngai'n kasuok rakip inmu phakhan, inroop inkabeenna kahoimak theiya inntiang inleikir. ");
INSERT INTO kfw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisu kajet ngai khat-um Galilee makheiya kaheijui numeisa ngai kha-um kasuok rakipkha kalaak mun makheiya ingirra inhei-en. ");
INSERT INTO kfw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Khawa khan araming Joseph inti pasal inkhat aleiom, ama hi chongtanna munna chuon katho mi inkhat alei eii, khat-um katha li kadik katho mi eii. ");
INSERT INTO kfw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Chongkatan ngai chong khat-um chuon rakip ngaikha ama'n leizootmak, amahi Judea khuopui suungnga kaom Arimathea makheiya kaheiwa eii, halli amahi Pathian Rengram kajuosik ka-ngaakchak ah kaom mi alei eii. ");
INSERT INTO kfw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ama'n Pilate koolla asiya Jisu kaluong kha ajuoni. ");
INSERT INTO kfw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Khale inruoiya ama'n Pumi kaluong kha akeithaak ah ama'n ruipuon kachek ah katuomma tuteii inlareii makna lungkarong thaan khan ajuoreii jei. ");
INSERT INTO kfw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Khawa nikhuo kha tuibiak nikhuo elei eii, halli Sabbath nikhuo aheiwasik ejei. ");
INSERT INTO kfw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Amale Galilee makheiya kaheijui numeisa ngai'n insiya thaanmunna ama kaluong kha angtho thoa thaanna inreiime tikha inleimu, ");
INSERT INTO kfw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Khale inruoiya inmani'n inheikirra, apumma kanootsik arim kahoi sariak kha injuominsuuk. Chongpeii dungjuiya Sabbath nikhuoni soong inleimachum. ");
INSERT INTO kfw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hapta mansakhet nikhuoni ziingtiang ma-ah inmani'n sariak rim kahoi inminsuuk ngaikha inchoiya thaantiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Halli inmani'n thaankhar lung lei-inlong kha inleimu. ");
INSERT INTO kfw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Inmani'n thaansuungnga inluut phakhan Pumi Jisu kaluong kha leiommakjei. ");
INSERT INTO kfw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Inmani'n hiwa jarra rildan leijetmuwa inlei omlai, jetlei theileiya puonkachek kasil pasal miring inni inmani koolla inleingir. ");
INSERT INTO kfw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Halli inmani'n inchi heiya neipilla injuo inbok phakhan, pasal inni ngai'n inmani diang inheiti, “Kathi ngai kara karing kha nangni'n angsik ning entokme? ");
INSERT INTO kfw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ama chu kathi makheiya intheiya hin ommakjei, ama'n Galilee ah omlai nangnidiang angme i-nati kha ngaidonru. ");
INSERT INTO kfw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Miring sapa kha manu karoon ngaidiang inpesik eii, cross ah inthatsik eii, halli nithum huuini ahongring nooksik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Khawa khan numeisa ngai'n ama chong ngaikha inleingaidon. ");
INSERT INTO kfw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Thaan makheiya inheikirra asiamruoi soomleikhat ngaidiang khat-um aleiilaak rakipdiang kasuok hi injuorilpi. ");
INSERT INTO kfw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Khawa numeisa ngai khachu, Mary Magdalene, Joanna, James nu Mary halli inmanile kasi aleiilaak numeisa ngai'n tirton ngaidiang kasuok omchan ngaikha injuorilpi. ");
INSERT INTO kfw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Takkha tirton ngai'n numeisa ngai chongkha pangrilla inril keeng tia leileipimu. ");
INSERT INTO kfw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Halli Peter'n intheiya taanna thaan tiang aleisi, ama'n akuunna thaankhur suung enpha khan kathi katuomna puon khabit ajuomu ah rilsik jetmak-ah inntiang aheikir nookjei. ");
INSERT INTO kfw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Halli, khawa nikhuoni khan Jisu nuk kajui ngai karra miring inni Jerusalem makheiya mile inni inlaak Emmaus khuotiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Inmani inni'n kasuok omchan ngai jarra khatle khatdiang inrilla inleisi. ");
INSERT INTO kfw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Inmani inni'n inleisi phakhan, Jisu'n inmani koolla heinaiya inmanile aleisi suom. ");
INSERT INTO kfw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Inmani'n ama kha inleimu, takkha tume tihi leijet matormu. ");
INSERT INTO kfw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Halli ama'n inmani diang ati, “Ang kachang chongme nangni inni'n nisina ah ningril kha?” khawa khan kahoimathei maisuoa inmani'n inleingir chetjei. ");
INSERT INTO kfw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Halli araming Cleopas intipa'n Jisu diang aheimasang, “Tuunlaiya nikhuo lekkhat suungnga Jerusalemma kasuok omchan jetleiya khuolmi inkhat na eya natheinuoa niombe tia inleirakel?” ");
INSERT INTO kfw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Halli Jisu'n inmani diang ati, “Angkachang chong suok ah mejei?” Inmani'n inleimasang, “Nazareth Jisu jarra kasuok chuon eii” Ama hi Pathian li miring ngai maikuungnga achuontho nali arilna rakip ah ranak kanei Pathian chongkachoi mi eii tia inleingaidon. ");
INSERT INTO kfw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Halli eini thiampu kalian ngaili lamkakei ngai'n thinasik-ah kathamak inminchangga ama kha cross ah inthat. ");
INSERT INTO kfw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Takkha Israel kakatansik mikha ama eii tia keini'n kinleingaidon, hiwa rakip hi asuokna wini le nithum kha hong ejei. ");
INSERT INTO kfw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Keini karra numeisa lekkhat in ziingtiang ma-ah thaanna injuosiya keinihi kinmalung inmindong, ");
INSERT INTO kfw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","halli inmani'n akaluong kha injuomumak phakhan, Jisu kha aringjei tia marwaan tirton ngai'n keinidiang mangtalar angnga kinmu tia keinidiang injuoril. ");
INSERT INTO kfw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Keini le kaom miring lekkhat in thaanna injuosiya numeisa ngai'n inti angnga injuomu, takkha inmani innum ama kha juomumu. ");
INSERT INTO kfw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Halli Jisu'n inmani diang ati, “Nangni angtuk ning amme, Pathian chong kachoi ngai'n inleiti rakip ningmalungnga kangamna sik-ah ning insuumjei! ");
INSERT INTO kfw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Christa'n poongna rakip adeisuoli ama lurna khan luutmakniabe?” ");
INSERT INTO kfw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jisu'n angrakip ama jarra Moses khat-um Pathian chong kachoi ngai'n inleiril khat-um chong inthiang in ileiti ngaikha rilpina aleinei. ");
INSERT INTO kfw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Khale inruoiya inmani'n intungnasik khuo inheinai phakhan, Jisu'n kasicheisik omchan angnga inmani diang aleithopi. ");
INSERT INTO kfw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Takkha khuo ajuoboi jarra keinile onsuomtui tia inmani'n ama kha ranak-ah khaapna inleinei, halli ama'n inmanile asiya injuoriakjei. ");
INSERT INTO kfw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ama'n inmanile bubakna sik-ah inlei in-ongsuom phakhan, waipool aleiya Pathian aleiminpaak halli katherra inmani diang aleipei. ");
INSERT INTO kfw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Halli inmani mit hongwarra Jisu ejei tia inleijet, halli inmani maikuung makheiya Jisu'n aleimang deljei. ");
INSERT INTO kfw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Inmani'n khatli khatdiang inlei inti, “Jisu einile lamma thurchi nirillai khat-um ama'n einidiang chong inthiang katha ah niminchulai eini malung kha mei angnga kaang ma-abe?” ");
INSERT INTO kfw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Khawapha takkhan inmani'n Jerusalem tiang inkirnook ah amale kasi siamruoi soomleikhat ngaikha mi ngaile intuup ah inleiom kha injuomu. ");
INSERT INTO kfw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Inmani'n injuoti, “Pumi kha inthiangnga aringjei, halli Simon diang juo inlarjei!” ");
INSERT INTO kfw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Khat-um lamma kasuok chuon ngai jarra khat-um waipool katherkhoi laiya inmani'n ang omchanna ama kha inhongjetme tijarra inmani diang inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Inmani'n hithowa inrilla inomlai takkhan, jetlei theileiya Pumi'n apumtak inmani karra ajuo ngirra inmani diang aleitipi. “Nangni chungnga kadai omrase.” ");
INSERT INTO kfw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Inmani'n ratha kathamak inkhat kimujei tia inleichi theiya inlei-inlai. ");
INSERT INTO kfw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ama'n inmani diang aheiti, “Angjara ning poongme? Halli angjarra ning malungnga inngamsamna ningneime? ");
INSERT INTO kfw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Enru kakutli kakeii ngaihi, kei ka eii, nakatook inlang na-enru, kei ningnamu angnga ratha kathamak chu taksali saru omnuni.” ");
INSERT INTO kfw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ama'n inmani diang aleitisuoli inmani diang akutli akeii ngaikha aminmu. ");
INSERT INTO kfw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Khawa khan inmani'n inngamna leiom maklai, karokli kangak in asiplai, Nipumi'n inmani diang aleiti, hiwahin bakphur inkhat ningneibe? ");
INSERT INTO kfw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inmani'n ngarou alekkhat inleipeii, ");
INSERT INTO kfw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ama'n aleiya inmani maikuungnga alei-ei. ");
INSERT INTO kfw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Halli ama'n inmani diang ati, “Hiwahi kei kachong kha eii, kei'n nangni karra kaleiomlai kanati, angrakip Moses Danna, Pathian chongkachoi ngai'n khat-um Minpaakla ah inlei majia rakip huui latungsik eii.” ");
INSERT INTO kfw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Achong inthiang injetnasik-ah inmani malungkha aleimalongpi. ");
INSERT INTO kfw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Halli inmani diang ati, “Hinthoa lei-injia, Christa'n poongna aneisik halli nithum huuini akathi makheiya ahongring nooksik eii. ");
INSERT INTO kfw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jerusalemma inphut malung thuulnali manu ngaidampina chongngai kha zaat rakipdiang ningrilpi sik eii. ");
INSERT INTO kfw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nangni hi hiwangai rakip chungnga sakhi ning ejei. ");
INSERT INTO kfw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Enru, kei'n Kapa chongkhitna kha nangni chungnga kanapesik eii; takkha Pathian in nangni kha chungtiangnga ranak khan puon angnga naminsil maklaiseng nangni'n Jerusalemma leiomru.” ");
INSERT INTO kfw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Khawa phakhan inmani kha Bethany katung akeiruoiya halli akut duongpiya inmani kha rawaan aleipei. ");
INSERT INTO kfw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ama'n inmani kha rawaan aleipeli ama'n inmani kha inthenpui jei, halli ama kha marwaan tiang inruoijei. ");
INSERT INTO kfw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jisu kha chubei inthoa Jerusalem tiang karok ah inlei kirjei. ");
INSERT INTO kfw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Halli inmani'n Biak-inna apha rakip ah Pathian kha inleiminpaak ah inleiom.");
INSERT INTO kfw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Inphutna ah Chongkha aleiom; Chongkha Pathian le inleiom, halli Chongkha Pathian alei eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Inphutna makheiya Chongkha Pathian le inleiom. ");
INSERT INTO kfw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ang rakip-hi ama diangnga inphut Pathian in ibool eii; Ma inchel lekleiya phur inkhat-um injirra kaleiom ommak. ");
INSERT INTO kfw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Amadiang ringna kha aleiom, halli ringna kha miringngai war kha alei eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","War khan aziingna-ah awarjei, halli akaziing in warkha leimaneiimak. ");
INSERT INTO kfw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pathian diangnga inphut injuotir araming John inti miring inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Achongril kha miring rakip in injetnasikle ngamnasik-ah ama'n war jarra sakhi kapesik-ah ijuo eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ama warkha emak; takkha war jarra sakhi kapesik kajuokha eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Manmasituolla kajuo mirakip ka-eel minwar amahi war akadiktak kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ama kha manmasituolla aleiom, halli manmasituol kha ama diangnga inphut ibool eii, kha e-innum manmasituol in ama kha leijetmak. ");
INSERT INTO kfw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ama'n amitak ngaidiang aleijuo, halli amitak ngai'n ama kha leidonmu. ");
INSERT INTO kfw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Takkha, ama ramingnga inngamna-ah ama karalaang miring rakipdiang, Pathian sangai enasik ama'n ranak apeii. ");
INSERT INTO kfw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Inmani ngaikha thiya, taksa i-ngaidonna, khat-um miring i-ngaidonna injuonei kha emu takkha Pathian diangnga inphut in eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chongkha miring taksa-ah juo-injir, riangwai khat-um akadik in asip-ah einile aomsuom; Apa diangnga inphut Asa inkhatbit ena ama lurna kha eini'n nimujei. ");
INSERT INTO kfw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John in ama jarra sakhi eya aleikheek, “Hiwa miring pahi ejei kei'n ama jarra kileirilkha,” Kei nuk-ah kajuo ama'n kei neek-ah alokwiai, ajarchu kei matiang ama aleiomjei. ");
INSERT INTO kfw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ama riangwai sipna jarra eini rakip in rawaan inkhat chungnga rawaan kha nimujei. ");
INSERT INTO kfw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ajarchu Dan kha Moses diangnga inphut ajuopeii, takkha riangwai khat-um akadik khachu Jisu Christa diangnga inphut kajuo kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tuteii inkhat innum Pathian kha mumu; Asa inkhatbit, apa koolla kaom, Ama'n Pathian kha anaminjet. ");
INSERT INTO kfw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalemma inphut Jihudi ngai'n Thiampu ngai khat-um Levi ngai'n John diang “Tu na-eme?” tia karakel inheitir phakhan, ");
INSERT INTO kfw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ama'n thuplekleiya “Kei Messiah kha emong” tia aleirilsuok. ");
INSERT INTO kfw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Angme halle?” “Nang Elijah na ebe?” intia inmani'n inleirakel. “Kei emong” tia ama'n aleimasang. “Nang Pathian chongkachoipa na ebe?” tia inmani'n inleirakel. “Emong” tia ama'n aleimasang. ");
INSERT INTO kfw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Halle “Nang tu na-eme?” tia inmani'n inleiti. “Keini'n kanaheitir ngaidiang masangnasik nang tutak ka-eii na-intime?” ");
INSERT INTO kfw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Pathian chongkachoipa Isaiah ileitikha angnga John in aleiti: “Kei chu ‘ramruok-ah kakheek-ah kaom miring inkhat rasa kha ka eii: Pumi sina sik-ah lam kha mintuunru!’ ” ");
INSERT INTO kfw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Inmani ngaikha Pharisee ngai ihongtir kha in eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Halli inmani'n John diang inleirakel, “Nang Christa, Elijah, emakli Pathian chongkachoipa um na-emak inle, angjarra nang in baptize nileiminthome?” ");
INSERT INTO kfw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John in inmanidiang aleimasang, “Kei'n tuiya baptize kamintho, takkha nangni karra ning-ijetmak miring khat a-ngirra om. ");
INSERT INTO kfw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ama hi-eii, kei kanuk-ah kajuo, takkha ama kekok kaliiksik um rahoi emong.” ");
INSERT INTO kfw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hiwahi John in baptize aleiminthona Jordan tuidung raaltiang Bethany khuokhan aleisuok. ");
INSERT INTO kfw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Khawa ziingkhuo warra Jisu'n amadiang iheiwa kha John in aleimuwa, aleiti, “Enru, Pathian Keelngamteii, manmasituol pumpui manu karoonsuopa! ");
INSERT INTO kfw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ama hi ejei ‘Kei kanuk-ah kei neek-ah kalok miring inkhat ajuo tia kileirilkha, ajarchu kei kamatiang ama aleiomjei.’ ");
INSERT INTO kfw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kei kapumtak innum ama kha leijetmong; takkha ama kha Israel ngaidiang minlarnasik jarra kei'n tuiya baptize kaminthoa kajuo.” ");
INSERT INTO kfw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Halli John in sakhi apeya aleiril, “Kei'n Ratha kha marwaan makheiya Wathu angnga juochumma khat-um ama chungnga juochuong kha kaleimu. ");
INSERT INTO kfw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kei kapumtak innum ama kha leijetmong, takkha tuiya baptize minthoro tia kanajuotir ama'n keidiang ati, ‘Miring inkhatdiang Ratha khan juochumma halli ijuochuong nimu, Ama kha eii Ratha Inthiangnga baptize kamintho kha.’ ");
INSERT INTO kfw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kei'n kamujei halli ama hi Pathian Sapa eii tia sakhi kapeii.” ");
INSERT INTO kfw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Khawa nikhuo thengnga inlet-ah John in asiamruoi innile a-ngirra aleiom, ");
INSERT INTO kfw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ama'n Jisu ihongkha aleimuwa aleiti, “Enru, Pathian Keelngamteii!” ");
INSERT INTO kfw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Siamruoi inni ngai'n ama'n hiwa itihi inleijet, halli inmani'n Jisu nukkha injuijei. ");
INSERT INTO kfw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisu'n hei-inlet ah inmani'n anuk inheijui kha aleimuwa inmanidiang aleirakel, “Angkeme ning-entok?” Inmani'n amadiang inleiti, “Rabbi” (hiwa tinachu “Karu”), “Nang hunme niom?” ");
INSERT INTO kfw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Heiwa inlang juo-enru,” tia Ama'n aleimasang. Inmani'n inheiwali ama omna kha injuomu, halli phadan mili jochulpha kholei alei eii jarra inmani-um khawa nikhuo nichu Jisu le inleiom suomjei. ");
INSERT INTO kfw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Inni ngai karra miring inkhat John chongril jetli Jisu nuk kajuipa kha, Simon Peter naipa Andrew alei-eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ama'n a-upa Simon intongpui masa-ah aleiti, “Keini'n Messiah kha kinmujei.” (Hiwa tinachu “Christa”). ");
INSERT INTO kfw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Halli ama'n Simon kha Jisu diang aheikeiruoi. Jisu'n alei-enna amadiang aleiti, “Nang John sapa Simon na-eii takkha Cephas tia innakoisik eii.” (Peter tinale in-angrip “Lungpui” tina eii). ");
INSERT INTO kfw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Khawa nikhuo thengnga Jisu'n Galilee ah sisik alei-ngaidon. Ama'n Philip intongpuiya aleiti, “Kanuk najuiro.” ");
INSERT INTO kfw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip, Andrew li Peter omnakhuo Bethsaida khuopui makheiya eii. ");
INSERT INTO kfw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip in Nathanael intongpuiya amadiang aleiti, “Moses in Dan khan ileimajia khat-um Pathian chongkachoi ngai innum inleimajia, Joseph sapa Nazareth makheiya Jisu kha keini'n kinmujei.” ");
INSERT INTO kfw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael in amadiang aleiti, “Nazareth makheiya ang akatha hongsuok niyame?” Philip in amadiang aleiti, “Heiwa inlang juo-enro.” ");
INSERT INTO kfw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisu'n Nathanael khan amadiang iheiwa kha aleimu halli amadiang aleiti, “Enru, Inthiang Israel miring, amadiang kadikmak iteii ommak.” ");
INSERT INTO kfw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael in Jisu diang aleiti, “Angtho tholia nang in kei ninajetme?” Jisu'n amadiang aleimasang, “Philip in nakoimaklai nang in Theichangkuung nuoiya naomlai, Kei'n kanamusuojei.” ");
INSERT INTO kfw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael in aleimasang, “Rabbi,” “Nang Pathian Sapa na-eii! Israel ngai Reng kha na-eii!” ");
INSERT INTO kfw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisu'n amadiang aleimasang, “Kei'n nang Theichangkuung nuoiya kanamu kati jarra nang in nina-ngamnabe? Nang in hiwangai neek-ah kalok angjet nalamusik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisu'n amadiang aleiti, “Kei'n akadik kha nangdiang kinati eii, nang in marwaan inlong halli Pathian Tirton ngai'n Miring Sapa diang inchum inkal kha namusik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nithum huuini Galilee suungnga kaom Cana ah moiruoi aleiom, halli Jisu nu kha-um khawa khan alei-inchel; ");
INSERT INTO kfw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jisu um asiamruoi ngaile moiruoi khan inleikoi. ");
INSERT INTO kfw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Theibomju aleihek phakhan, Jisu nu khan amadiang aleiti, “Inmani theibomju neimujei.” ");
INSERT INTO kfw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisu'n amadiang aleiti, “Eh numeisa, keili nang in ang nithosik suok ame? Kei kapha kha laheitungmak.” ");
INSERT INTO kfw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Anu khan suok ngaidiang aleiti, “Ama iti itikha nangni'n thoru.” ");
INSERT INTO kfw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jihudi ngai sina dungjuiya insuthiang nasik lungtuibeel kuruk gallon soomni khat-um soomthum katung kakeng aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisu'n inmanidiang aleiti, “Beel ngaihi tui minsipru.” Halli inmani'n beel ngaikha tui inleiminsip. ");
INSERT INTO kfw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ama'n inmanidiang aleiti, “Tuunchu lekkhat luok inlang halli bak-in karoonpa diang choiru.” Khawa jarra inmani'n inleichoi, ");
INSERT INTO kfw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bak-in karoonpa khan tui makheiya theibomju imin-uol kha aleimintem phakhan, humakheiyame tikha leijetmak (takkha tui kaluokpa inchu aleijet), bak-in karoonpa khan moipa akoiya ");
INSERT INTO kfw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ama diang aleiti, “Mi rakip chu theibomju kathakhet kha mansakhet insem; halli mi ngai'n inkhopphet phakhan, theibom tuichoong kha insem, takkha nangchu theibomju katha khetkha tuunkatuung naladatit!” ");
INSERT INTO kfw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jisu'n mansakhet chuon inlak kha Cana Galilee ah athoa ama lurna kha amalar, halli asiamruoi ngai'n amadiang inlei-ngamnajei. ");
INSERT INTO kfw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hiwa thengnga Jisu'n anu, anai ngai, khat-um asiamruoi ngaile Capernaumma inleisi; halli khawakhan nikhuo lekkhat inleiom. ");
INSERT INTO kfw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jihudi ngai Rakaanna kahoi aheitung dengpha khan, Jisu'n Jerusalemma aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Biak-inn khan sa, keelngam, pharbali kajour ngai, khat-um sialchuoi kamakoi ngai'n sial inlouwa inleiom kha alei-intongpui. ");
INSERT INTO kfw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ama'n ruipuon ramol aboolla sa, keelngam, khat-um sangai rakip kha Biak-inn makheiya aleipuut, sialchuoi kamakoi ngai sialpum ngaikha aleiworjuon halli inmani khamtuol ngaikha aleimalet aleimakhup. ");
INSERT INTO kfw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Halli pharbali kajuor ngaidiang aleiti, “Hiwa ngaihi keisuotru! Kapa innhi nangni'n sialsum louna mun min-emaru!” ");
INSERT INTO kfw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","“Nang innsik bit-ah malung kaluut-in kei na-eijei” tia lei-injia kha ama siamruoi ngai'n inlei-ngaidon. ");
INSERT INTO kfw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jihudi ngai'n amadiang inmasangnga inleiti, “Hiwa thonasik ranak kanei tihi jetna sik-ah chuon inlak keinidiang nanaminmu mator abe?” ");
INSERT INTO kfw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisu'n inmanidiang aleimasang, “Biak-inn hi thiatru, halli nithum suungnga kei'n kaminngirsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jihudi ngai'n inleiti, “Hiwa Biak-inn insak hi kum soommili leiruk kaluut kha eii, halli nang in nithumma naminngirsik?” ");
INSERT INTO kfw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Takkha Jisu'n Biak-inn jarra ileiril khachu ama apum jarra eii. ");
INSERT INTO kfw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ama'n athi makheiya ahongring khanchu, ama siamruoi ngai'n hiwahi aleitijei tia inhongngaidon, halli inmani'n Pathian chong inthiang khat-um Jisu ileiti chong ngaikha inleingamna. ");
INSERT INTO kfw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ama'n Jerusalemma Rakaanna kahoi bubakna ah aleiom phakhan, Ama'n inlak chuon itho ngaikha inmuli mi katamtak in Jisu raming kha inleingamna. ");
INSERT INTO kfw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Takkha Jisu apumtak in inmani ngaikha leingamnamak, ajarchu mi rakip ama'n ajet, ");
INSERT INTO kfw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","halli mi inkhat jarra tu ka-ang inkhat in sakhi kapesik-ah ama diang arei ommak, ajarchu Jisu'n miring malung suungnga angme kaomkha aleijet. ");
INSERT INTO kfw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pharisee ka-eii Jihudi ngai lamkakei araming Nicodemus inti miring inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Hiwa miringpa in zaanna Jisu diang aheiwa-ah aleiti, “Rabbi, keini'n kinjet khachu Pathian diangnga inphut kajuo ocha kha na eii; Pathian in ama kha inruoipuimak inchu, tuteii inkhat innum nang itho inlak chuon ngaihi thomatornunu.” ");
INSERT INTO kfw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisu'n amadiang aleimasang, “Inthiangnga Kei'n nangdiang kitihi eii: tu ka-ang in woikhat inneitharmak inchu, ama'n Pathian Rengram kha mumaneii nuni.” ");
INSERT INTO kfw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus in amadiang aleiti, “Angtho tholi upa ka-ejei miring khan inneithar sikme?” “Anu wonsuungnga woikhat inlet-ah luutli juo-inneirit thaniabe?” ");
INSERT INTO kfw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisu'n aleimasang, “Kei'n inthiangnga nangdiang kitihi eii, tu ka-ang in tuiya khat-um Ratha-ah inneitharmak inchu, ama'n Pathian Rengram kha luuttheinuni. ");
INSERT INTO kfw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Taksa ah inneikha taksa eii, halli Ratha ah inneikha ratha eii. ");
INSERT INTO kfw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kei'n nangdiang kinatihi nang ngakmaro, nang woikhat na-inneitharsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Thiraang khan araangnazoot rei araang; halli nang in arasa kha najet, takkha humakheiya kaheiwame emakli huntiangme isi nang in jetmakche. Ratha ah innei miring rakip ngaikha khawa ka-ang eii.” ");
INSERT INTO kfw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus in amadiang aheimasang, “Hiwahi angtho tholia ethei sikme?” ");
INSERT INTO kfw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisu'n amadiang aleimasang, “Nang Israel ngai ocha na-epumma hiwa ngaihi nilajetmakbe? ");
INSERT INTO kfw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","kei'n inthiangnga nangnidiang kitihi eii, keini'n kin-ijetkha kinril khat-um kin imukhan sakhi eii; takkha keini sakhi kha nangni'n leimakchu. ");
INSERT INTO kfw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kei'n manmasituolla kitho chuon ngaikha nangnidiang kariljei halli nangni'n ngamnamakchu, Marwaanna kaom jarra karil inle angtho thoa ningngamnasik me? ");
INSERT INTO kfw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tuteii inkhat-um chungtiang kalla marwaanna kasi ommu takkha marwaan makheiya kajuochum Miring Sapa khabit eii.” ");
INSERT INTO kfw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses in neelramma sumsen maruul kha ikadomsaang angnga, Miring Sapa kha-um inkadom saangsik eii, ");
INSERT INTO kfw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","khachu Amadiang ka-ngamna rakip in hektik kaboi ringna inmunasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ajarchu Pathian in manmasituol kha hituk aminriang khachu Asapa inkhatbit kha ama'n anapeii, amadiang kangamnatak miring khan thina mununi takkha kumsoot ringna kha amusik eii. ");
INSERT INTO kfw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pathian in Asapa kha manmasituol chong katansik ijuotir emak, takkha manmasituol kakatansik ijuotir kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Amadiang ngamna kanei mi ngaichu chongtan omnuni; takkha amadiang ngamna keneimak mi ngaichu chong atansuojei, ajarchu Pathian Sapa inkhatbit ramingkha ngamnamu. ");
INSERT INTO kfw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chongtan kha hiwahi ejei, khachu War kha manmasituolla ajuojei, takkha mi ngai inchu akaziing kha war neek-ah inleimanuom, ajarchu inmani chuontho ngaikha leidikmak. ");
INSERT INTO kfw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chuon kadikmak katho ngai'n war kha inleimatir, ajarchu inmani kadikmak chuonkha inlarte intia wardiang heiwamu. ");
INSERT INTO kfw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Takkha akadik katho ngai'n inmani itho chuon ngaikha Pathian kinjuiya kintho eii tia malarnasik ah wardiang inheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hiwa thengnga, Jisu khat-um asiamruoi ngai'n Judea ramsuungnga inleisi, khawakhan ama'n apha bongkhat inmanile aleiomma khat-um baptize aleitho. ");
INSERT INTO kfw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John um Aenon inti Salim le innai munkhan baptize aleimintho, ajarchu khawa munkhan tui katamtak aleiom. Mipui ngai'n amadiang inheiwa halli ama'n baptize aleimintho. ");
INSERT INTO kfw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ajarchu khawa phakhan John mikhumna ah laleidamu. ");
INSERT INTO kfw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Khawa jarra John siamruoi ngaili Jihudi ngai'n biaklam dungjuiya insuthiangna jarra murruolsiak inlei-intho. ");
INSERT INTO kfw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Khantia inmani'n John diang inheiwa ah inleiti, “Rabbi, nang in ama jarra nileiril, Jordan raaltiang makheiya nangle inruoi miring pakha hin baptize aminthoa om, halli miring rakip amadiang insi.” ");
INSERT INTO kfw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John in aleimasang, “Marwaanna inphut injuopeii elekleiya tu inkhat innum iteii mutheinunu. ");
INSERT INTO kfw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Kei Christa kha emong, takkha keichu ama matiang najuotir kha ka-eii, kei'n kitihi’ nangni ningpumtak in kei sakhi ning ejei. ");
INSERT INTO kfw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Moinu kha moipa ta-eii; moipa sappui pa'n a-ngirra moipa rasa kha arangaiya ajetpha khan arok. Hinthoa kei rokna kha huui tungjei. ");
INSERT INTO kfw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ama chu kheella aloksik eii takkha keichu kajuosiinsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Chungtiang Makheiya kajuo ama'n mi rakip neek-ah alokwiai. Nuoipil chungnga kaom mikha nuoipilchung mi eii, khat-um nuoipilchung jarra ama'n aril, takkha marwaanna inphut kajuo ama'n mi rakip neek-ah alok. ");
INSERT INTO kfw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ama'n imujei khat-um ijet ngaikha aril, kha e-innum ama sakhi kha tuteii innum leikeiluutmu. ");
INSERT INTO kfw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Takkha ama sakhi kakeiluut miring khan Pathian hi adik tia jetnabi ada. ");
INSERT INTO kfw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pathian ijuotir miring khan Pathian chong ngaikha aril, ajarchu Pathian in Ratha kha akasip-ah apeii. ");
INSERT INTO kfw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Apa khan Asapa kha aminriang halli angrakip ngaikha ama kutchungnga ranak apejei. ");
INSERT INTO kfw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Asapa diang ngamna kanei miring khan hektik kaboi ringna kha amujei; Asapa kajuimak mi ngaikha ringna mununu, takkha Pathian raangna nuoiya inomsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jisu'n John neek-ah siamruoi tamwiai baptize amintho tikha Pharisee ngai'n inleijet, ");
INSERT INTO kfw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ka etakchu, baptize kamintho kha Jisu lei-emak takkha asiamruoi ngai in-eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Hiwa chonghi Jisu'n aleijet phakhan, Ama'n Judea mathaanna Galilee ah aleikirnook; ");
INSERT INTO kfw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","halli Samaria ram rakaanli sisik kha alei eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria ah Sychar inti khuopui, Jacob in asapa Joseph diang ileipeii leimun koolla aheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacob tuikhur kha khawakhan aleiom, Jisu'n akasikha aleipoongnga, tuikhur koolla alei in-ong. Kani indingdeng phakhan alei eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaritan numeisa inkhat tui kachoi aheiwa, khat-um Jisu'n numeisanu diang aleiti, “Keidiang insik-ah tui napero.” ");
INSERT INTO kfw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ajarchu asiamruoi ngaikha khopuiya baksik-ah bakphur karacho inleisi. ");
INSERT INTO kfw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaritan numeisanu khan aleimasang, “Angjarra Jihudi nang in, Samaritan numeisa keidiang tui insik-ah ninanime?” ajarchu Jihudi ngai chu Samaritan ngai'n inliingna rabing khat-um kheeng inliingnamu. ");
INSERT INTO kfw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisu'n aleimasang, “Nang in Pathian kutchoi kha naleijetngai suok-ah khat-um nangdiang tui insik-ah kanani amahi naleijet inchu, nang in amadiang naleinisik eii, halli ama'n nangdiang ringna tuikha analeipesik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Numeisanu khan aleiti, “Ocha” “Nangchu tuiluok nasik neimakche, tuikhur hi inthuuk. Hu makheiya khawa ringna tuikha naleisik me? ");
INSERT INTO kfw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Hiwa tuikhur kanaleipeii, ama sangai khat-um asadon rakip ngai'n in-in, keini kinpa Jacob neek-ah nalokwiaibe?” ");
INSERT INTO kfw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisu'n aleimasang, “ Hiwa tui ka-in miring rakip khachu woikhat araalpinook sik eii, ");
INSERT INTO kfw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Takkha kei'n kapesik tuikha ka-in ama khachu woikhat inlet-ah tuikaraal omnuni. Kei'n amadiang kapesik tui khan amadiang tuiring inchangta kumsoot ringna kha esik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Numeisanu khan amadiang aleiti “Karu, khawa tuikha keidiang napero! Tichu kei'n woikhat tuikaraal ommaknasik, khat-um woikhat tui kachoi kaheiwa maknasik.” ");
INSERT INTO kfw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisu'n numeisanu diang aleiti, “Si inlang naruothar juokoiro, halli heikirnook ro.” ");
INSERT INTO kfw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Numeisanu in aleimasang, “Kei karuothar ommak.” Jisu'n aleiti, “Nang in kei karuothar ommak inthiangnga nati. ");
INSERT INTO kfw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ajarchu nang pasal ra-ngadiang inn naneijei, halli tuun tuunna niompui pasal kha-um nang naruothar emak. Nang in inthiang kha nariljei.” ");
INSERT INTO kfw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Numeisanu khan aleimasang, Karu, “Kei'n kamujei nang Pathian chongkachoi na eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Keini kinpi kinpu ngai'n hiwa chingbung hin Pathian chubei inleitho, takkha nangni Jihudi ngai inchu Jerusalem khankeeng Pathian chubei nithonasik mun ningti.” ");
INSERT INTO kfw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisu'n numeisanu diang aleiti, “Numeisa, Keidiang ngamnaro, miring ngai'n Pa Pathian kha hiwa chingbung emakli Jerusalem ma chubei inthomaknasik aphakha aheiwasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nangni'n ning ijetmak kha chubei ningtho; takkha keini chu kin-ijetkha chubei kintho, ajarchu sanminringna kha Jihudi diangnga inphut kajuo eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Takkha aphakha ahongjei khat-um tuun aphakha ejei, inthiangnga chubei katho ngai'n Pa Pathian kha ratha khat-um akadik ah chubei inthosik eii, Pa Pathian khan inmani ka-ang ngai'n chubei inhongtho kha a-entok. ");
INSERT INTO kfw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pathian chu Ratha eii, khat-um amadiang chubei katho ngai'n ratha khat-um akadik ah chubei inthosik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Numeisanu khan amadiang aleiti, “Kei'n kajet Messiah (Christa tia inkoi) kha ajuosik eii, Ama'n ajuo phakhan, keini diang angrakip kha narilpisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisu'n numeisanu diang aleimasang, “Nangle inbiak-ah kaom keihi ama kha ka eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Khawapha takkhan asiamruoi ngaikha inheitung, khat-um ama'n numeisanu khale inlei-inbiak inmupha khan asiamruoi ngai'n inleingak, takkha tuteii innum, “Angme nimanuom?” emakli, “Angjarra numeisanu hile thurchi nithome?” tia leirakelmu. ");
INSERT INTO kfw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Numeisanu kha atuibeel da-ah, khuopui tiang aleisi, halli mipui ngaidiang aleirilpi, ");
INSERT INTO kfw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Heiwaru, kei ileitho rakip jarra karilwiak miring kha juo-enru. Ama hi Messiah lei-emak niabe?” ");
INSERT INTO kfw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Inmani ngai'n khuopui inmathaanna Jisu diang inheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Khawa phakhan, “Karu, bakphur lekkhat bakro!” tia asiamruoi ngai'n ama kha inleimatheem. ");
INSERT INTO kfw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Takkha ama'n inmani diang aleiti, “Nangni ijetmak bakphur kha kei kanei.” ");
INSERT INTO kfw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Khawa jarra asiamruoi ngai'n inkhatli khatdiang inlei inti, “Tu miring inkhat in amasik bakphur heikachoipi inombe?” ");
INSERT INTO kfw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisu'n inmani diang aleiti, “Kei kabu chu” “Kei kanajuotirpa imanuom katho khat-um ama chuon huui kamintung kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nangni'n ‘Tha mili esuoli lei rakhoolpha eii timak chuwabe?’ Takkha kei'n nangni diang kanati, khuo thir-inlang leirajei kha enru; lei ngaikha aminjei khat-um lei rakhoolpha ejei! ");
INSERT INTO kfw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lei karakhool mi kha arakhool man achang halli akara kha kumsoot ringna sik-ah akhomchun; ajarchu kawor pa-um karakhool pa-um inrok suomnasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chongngil ileiti kha adik, ‘Miring khat in aru awor halli miring inkhat in arakhool.’ ");
INSERT INTO kfw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kei'n nangni itho ka-emak chuon munkhan akara karakhool sik-ah kinatir ejei; aleiilaak mi ngai'n chuon inleithojei, halli inmani chuonleitho khan nangni'n ninghoi kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“Kei ileitho rakip ama'n atiwiak” iti numeisanu sakhi jarra khawa khopuiya kaom Samaritan mi katamtak in Jisu diang inlei-ngamna. ");
INSERT INTO kfw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaritan mi ngai'n amadiang inheiwa phakhan, inmanile omsuomrui tia amadiang inleimatheem, halli Jisu'n inmani ngaile khawa munkhan nini aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Halli ama chongril khan miring katamtak-um ngamna inleineinook. ");
INSERT INTO kfw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Halli inmani'n numeisanu diang inleiti, “Tuunchu keini'n kinngamnajei, nang in nati jarra emak, takkha keini kinpum tak-in amadiang kinrangaijei, khat-um keini'n kinjetjei khachu amahi inthiangnga manmasituol kakatanpa kha a-eii.” ");
INSERT INTO kfw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Khawa nini thengnga, Jisu'n Galilee ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ma apumtak in aleiti, “Pathian chongkachoi ngaikha inramtak inchu khoya thomu.” ");
INSERT INTO kfw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Khawa jarra ama'n Galilee aheitung phakhan, Galilee mi ngai'n ama kha katha-ah inleidon, ajarchu Jerusalemma rakaanna kahoi khan inmani ngaikha inleisi khat-um ama'n kahoi suungnga ileitho rakip ngaikha inleimu. ");
INSERT INTO kfw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Halli Jisu'n Galilee suungnga Cana inti, ama'n tuikha theibomju aleimin-uolna ramkhan inlet-ah aheiwa. Halli Capernaumma asapa kanapi kalok kalian miring inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ama'n Jisu kha Judea makheiya Galilee ah aheiwa tikha aleijet phakhan, ama'n Jisu diang asiya ajuoti, kasapa najomindam piro tia chubei aleitho, ajarchu ama kha thisik thoa omjei. ");
INSERT INTO kfw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisu'n amadiang aleiti, “Chuon inlak khat-um ngak kaom ningmu maklaiseng nangni'n ngamnanutun.” ");
INSERT INTO kfw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kalok kalianpa'n Jisu diang aleiti, “Karu, kasapa thima-ah keile inruoiya situi.” ");
INSERT INTO kfw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisu'n amadiang aleiti, “Sitro; nang nasapa aringsik eii!” Mipa khan Jisu'n amadiang iti chongkha ngamna ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Inn tiang asina lamma ama suok ngai'n intongpuiya, halli nasapa aringjei tia inleitipi. ");
INSERT INTO kfw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ama'n inmani diang aleirakel asapa ihongdam kha phadan angjet chulpha khan me, khat-um inmani'n inleimasang, “Miyanni suun phadan inkhat khan eii ritun khan ama imathaankha.” ");
INSERT INTO kfw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Apa khan aleijet khachu khawa phadan khan eii Jisu'n ama diang ileiti, “Nang nasapa aringsik eii.” Halli ma apumtak khat-um ama insuungkhur in inleingamna. ");
INSERT INTO kfw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea makheiya Galilee ah aheiwasuo thengnga hiwahi Jisu'n woini huuina ileitho chuon inlak kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Hiwa thengnga, Jisu'n Jerusalemma Jihudi ngai kahoi sik-ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalemma Keelngam Kot koolla pham ra-nga-ah inmakhu tuikuong inkhat aleiom; Hebrew ngai chongnga Bethzatha inti. ");
INSERT INTO kfw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Amit kacho, keii kakiak, apum kathi khat-um akana katam tak-in tuikuong luutna lamma inleizaal. ");
INSERT INTO kfw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Inmani'n tui innik kha inleingaak, ajarchu tui innikna racham Pumi tirton in tuikuong suungnga aluut-ah khat-um tui kha aleikachok. Tui hongkachoksuo nuk-ah tuikuong suungnga kaluut masa akana mi kha ileiroontak rirai makheiya aleidam. ");
INSERT INTO kfw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kum soomthum leiriat kanajei miring inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisu'n ama kha khawakhan azaalla ileiom kha aleimu, khat-um khawa miring pakha anana hongsoot theijei tihi ama'n aleijet phakhan Jisu'n “Nang nadam zootbo?” tia amadiang aleirakel. ");
INSERT INTO kfw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Akanapa khan Jisu diang aleimasang, “Karu, tui hong innik phakhan tuikuongnga kanaruoisik tuteii ommu; kei'n chumnasik kaheitho phakhan, miring khat-in naluutdel masa.” ");
INSERT INTO kfw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisu'n ama diang aleiti, “Intheiro, napher kha ruut-inlang, halli siro.” ");
INSERT INTO kfw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Khawapha takkhan mipa kha aleidam; apher kha aruut-ah aleisi. Hiwa aleisuokna nikhuo kha Jihudi ngai sernikhuo (Sabbath) alei eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jihudi lamkakei ngai'n akadamjei mipadiang inleiti, “Sabbath eii, eini Sinadan dungkajuiya nang in napher niraput kha dan akoi.” ");
INSERT INTO kfw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Takkha ama'n inmanidiang aleimasang, “Kei kanamindam mipa'n kapher ruut-inlang siro analeiti.” ");
INSERT INTO kfw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Inmani'n amadiang inleirakel, “Nangdiang napher ruut-inlang siro kanaleiti miring kha tume?” ");
INSERT INTO kfw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Takkha akadamjei mipa khan ama kha tume leijetmak, ajarchu Jisu'n aleisuok deljei, khat-um khawa munkhan mipui katamtak inleiom. ");
INSERT INTO kfw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Khawa thengnga, Jisu'n mipa kha Biak-inn khan intongpuiya ama diang aleiti, “Enro, tuun nang nadamjei; kheella nachungnga kathamak suokmaknasik, manu thokhaimaro, emak inchu katha makthei nangdiang suokthei eii.” ");
INSERT INTO kfw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Halli mipa khan asiya kei kanamindam pakha Jisu eii tia ma'n Jihudi chuonkaroon ngaidiang ajuorilsuok. ");
INSERT INTO kfw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisu'n Sabbath nikhuoni hiwa chuon atho jarra Jihudi ngai'n Jisu kha poong-raalna inleipeii. ");
INSERT INTO kfw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Takkha Jisu'n inmanidiang aleimasang, “Kapa khan tuunkatuung chuon thocheiya om, halli kei-um chuon kitho eii.” ");
INSERT INTO kfw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hiwa chong jarra Jihudi chuonkaroon ngai'n Jisu kha kheella thatna sik-ah inlei entok; ajarchu Sabbath imakoi khabit emak-ah, takkha Pathian kha apa eii tia ama'n aleiti, apum takkha Pathian le in-angpui. ");
INSERT INTO kfw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisu'n inmanidiang aleimasang, Kei'n nangnidiang inthiangnga kanati: Asapa khan iteii-um atheinuoa thomatormak, Apa itho imu ngaikhabit ama'n atho; Apa itho kha, Asapa innum itho eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ajarchu Apa khan Asapa kha aminriang halli apum tak-in itho ngai rakip kha Asapa diang aminmu, nangni'n ningngak domnasik hineek-ah kalok thonasik-ah amadiang alaminmusik eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Apa khan akathi ngai aminringnga ringkhuo ipenook angnga, Asapa innum ipezoot mi ngaidiang ringna apeii. ");
INSERT INTO kfw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apa khan tuteii diang-um chong tanmak, takkha Asapa diang chongtan nasik ranak rakip ama'n apejei, ");
INSERT INTO kfw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Apa diang khoya intho angnga mi rakip in Asapa kha khoya inthosik eii. Asapa khoya kathomak ama khan Asapa kajuotir Apa kha-um khoya kathomak eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kei'n inthiangnga nangnidiang kati: Kei kachong karangai khat-um kei kanajuotir amadiang inngamna mi khan kumsoot ringna anei, ama chungnga chongtan omnuni, takkha kathiya inphut ringna kha inrakaanjei. ");
INSERT INTO kfw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kei'n nangnidiang inthiangnga kati: akathi ngai'n Pathian Sapa rasa kha injet nasik, halli akajet ngai'n inhongring nasik-ah aphakha aheiwasik eii, halli tuun aphakha ejei. ");
INSERT INTO kfw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Apa'n ringna inei angnga, Ama'n Asapa diang-um apum tak-ah ringna aneinasik azootpi. ");
INSERT INTO kfw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Khat-um Ama'n Asapa diang chongtan nasik ranak apejei, ajarchu amahi Miring Sapa kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hiwa hin nangni ngakmaru; Akathi mi rakip in thaankhur makheiya ama rasa injet nasik apha kha ajuojei ");
INSERT INTO kfw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Halli akatha katho ngai'n inthaan makheiya hongsuok inta ringna inneisik eii, halli kathamak katho ngai'n chongtan nasik-ah inhongringsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kei karanak-ah iteii thomatormong; Pathian in chong tanro iti-ngai bitkha Kei'n chong katan, halli kei chongtanhi adik, ajarchu kei imanuom kha kei thosik ngaidonmong, takkha kei kanajuotir ama imanuom kha katho. ");
INSERT INTO kfw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kei kapum taksik sakhi kape inchu, Kei sakhi hi dikmak; ");
INSERT INTO kfw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Takkha mi inkhat kei sakhi ka-e om, halli kei'n kajet khachu ama'n kei jarra iril ngaikha adik. ");
INSERT INTO kfw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nangni'n John diang ningheitir, halli John in inmanidiang akadik kha aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kei'n mi ngai sakhi kilei emak, takkha Kei'n hiwa katina ajarchu nangni'n ringna ningmunasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John hi war kanapeii sariakmei kakai kha alei eii, halli nangni'n ama warkhan apha bongkhat hoinasik-ah ningkadang. ");
INSERT INTO kfw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Takkha kei ipeii sakhi hichu John ta neek-ah kalok eii; kei thosik-ah Kapa inapeii chuon ngai, khat-um kei itho chuon ngai khan keihi Apa inajuotir eii tia amalar.” ");
INSERT INTO kfw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Halli kei kanajuotir kapa in kei jarra sakhi apeii. Nangni'n ama rasa woikhat-um lajetmakchu khat-um ama meel lamumakchu, ");
INSERT INTO kfw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","halli nangni'n ama chongkha ningmalungnga reiimakchu, ajarchu ama ijuotir miringkha ngamnamakchu. ");
INSERT INTO kfw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nangni'n Chong inthiang kha ning-entok, ajarchu nangni'n khawa khan hektik kaboi ringna kinmu eii ningti; halli khawa Pathian chong kha eii, kei jarra sakhi ka-eii; ");
INSERT INTO kfw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","kha e-innum nangni'n ringna ningmunasik keidiang heiwazoot makchu. ");
INSERT INTO kfw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Manmasi ngai'n naminpaak kha kei manuommong, ");
INSERT INTO kfw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","takkha kei'n kajet, khachu nangni ningmalung suungnga Pathian minriang nakha neimakchu. ");
INSERT INTO kfw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kei'n Kapa ramingnga kajuo, halli nangni'n kei nazootmakchu; takkha miringkhat apumtak thomatorna ramingnga ajuo-inchu, nangni'n ama chu ningdonsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pathian diangnga kajuo minpaak nakha entoklekleiya inkhatli inkhat inpaak kha ningmanuom inle angtho tholi ngamna ningneisik me? ");
INSERT INTO kfw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kei'n Kapa maikuungnga nangni kanaril sesik eii tia ngaidonmaru. Nangni'n ngamna ningnei Moses kha-eii nangni kanaril sesik. ");
INSERT INTO kfw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nangni'n Moses kha inthiangnga ningleingamna inchu, nangni'n kei-um ningna ngamnasik eii, ajarchu Moses in kei jarra aleimajia. ");
INSERT INTO kfw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Takkha ama ileimajia kha ningngamnamak inchu, angtho tholi kei kachong ningngamnasik me?” ");
INSERT INTO kfw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hiwa thengnga, Jisu'n Tiberias tuipui, Galilee tuidiil raaltiang rakaanna aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Halli mipui'n ama nukkha inheijui, ajarchu inmani ngai'n chuon inlak tholi akana ngai imindam kha inleimu. ");
INSERT INTO kfw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisu'n chingbung aleikalla asiamruoi ngaile alei in-ong. ");
INSERT INTO kfw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Khawa phakhan Jihudi ngai Rakaanna kahoi kha aleinaijei. ");
INSERT INTO kfw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisu'n alei-enna mipui katamtak amadiang inheiwa kha aleimu, halli ma'n Philip diang aleiti, “Hiwa mipui bak kahunsik bakphur hi angtho tholi niracho sikme?” ");
INSERT INTO kfw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ma'n hiwa itihi Philip malung ensik tia iril eii; ama'n angme athosik inthiangnga aleijet. ");
INSERT INTO kfw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip in amadiang aleimasang, “Dangka pum rajani innum inmani rakip in lekteii baksik-ah rachosik hunnuni.” ");
INSERT INTO kfw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Asiamruoi inkhat Simon Peter naipa Andrew in amadiang aleiti, ");
INSERT INTO kfw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Pasal naipang inkhat satun waipool ra-nga li nga inni kachoi khat hin om, takkha hiwa mipui diangchu angsemma semminname?” ");
INSERT INTO kfw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisu'n aleiti “Mi rakip kha min-ongru.” halli khawa munkhan chinthou katamtak aleimoong; halli mipui'n inlei in-ong; pasal miring lising ra-nga inlei eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisu'n waipool kha aleiya Pathian aleiminpaak, halli khawa khanna in-ong mi rakipdiang inleisem. Khawa angnga nga kha-um khan thoa inleisem, halli mi rakip in inbak maneii laiseng inleibak. ");
INSERT INTO kfw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mi rakip in inleihun phakhan, Jisu'n asiamruoi ngaidiang aleiti, “Alek kaliam ngaikha khoomchunru; eini'n iteii minmangmui.” ");
INSERT INTO kfw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Khawa jarra siamruoi ngai'n mipui bakbang satun waipool ra-nga makheiya kaliam rakip kha inkhoom chunna thumluk soomleini inleiminsip. ");
INSERT INTO kfw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mipui ngai'n Jisu itho inlak chuon kha inleimu phakhan, Inmani'n inleiti, “Inthiangnga hiwahi Pathian chongkachoi manmasituolla kajuosik miring kha eii!” ");
INSERT INTO kfw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Inmani'n heiwa inta azootmak pumma naruoi inta reng innaminchangsik ejei tikha Jisu'n ajet-ah; Jisu'n alooiya chingbungtiang atheinuoa aleisijei. ");
INSERT INTO kfw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kholei ahei ephakhan, Jisu siamruoi ngaikha tuidiil khan inleichum, ");
INSERT INTO kfw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","rakuong suungnga inleiluut, khat-um tuidiil rakaanli Capernaum tiang inleisi, zaan aheiluut katung Jisu'n inmani diang laheiwa titmak. ");
INSERT INTO kfw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Thikaraang kangar aheiraangnga tuipui kha aleiminnik. ");
INSERT INTO kfw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Asiamruoi ngai'n miles inthum emakli mili katung rakuong inleisep phakhan inmani'n tuichungnga Jisu'n rakuong kooltiang iheiwa kha inleimu, halli inmani ngai'n inleichi. ");
INSERT INTO kfw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Takkha Jisu'n inmanidiang aleiti “Kei ka eii; chimaru.” ");
INSERT INTO kfw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Halli inmani'n ama kha karok-ah rakuong suungnga inleikeiluut, halli khawapha takkhan rakuong kha intungnasik muongkhan aleituungjei. ");
INSERT INTO kfw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ziingkhuo warra tuidiil raalkhat tiangnga kaom mipui ngai'n rakuong inkhatbit omjei tikha inleijet, halli Jisu kha asiamruoi ngaikhale inrouimak takkha siamruoi ngaichu insisuojei tikha-um inleijet. ");
INSERT INTO kfw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pumi'n Pathian aminpaak suoli inmani'n waipool inleibakna mun tuikham koolkhan Tiberias makheiya rakuong lekkhat inheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mipui ngai'n Jisu khat-um asiamruoi ngaikha khawakhan ommujei ti inleimu phakhan, inmani um rakuong ngaikhan inluut-ah Capernaumma Jisu ka-entok inleisi. ");
INSERT INTO kfw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mipui ngai'n ama kha tuidiil raalkhat tiang i-omkha inmu phakhan, inmani'n ama diang inleiti, “Karu, angtik pha-ah hiwahin niheiwame?” ");
INSERT INTO kfw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisu'n aleimasang, “Kei'n inthiangnga nangnidiang kati: inlak chuon ningmu jarra kei ningna entok emak takkha waipool kakhop-ah ningbak jarra kei ningna entok eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kamangthei bu sik-ah chuon thomaru; takkha Miring Sapa'n nangnidiang anapesik hektik kaboi ringna busik ah chuon thoru. Ajarchu Apa Pathian in izoot jetnabi kha ama chungnga adeengjei.” ");
INSERT INTO kfw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Halli inmani'n amadiang inleiti, “Pathian chuon thonasik-ah, keini'n angme kinthosik?” ");
INSERT INTO kfw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisu'n inmanidiang aleimasang, “Pathian chuonkha hiwahi eii, khachu Pathian in ijuotir amadiang ngamnaru.” ");
INSERT INTO kfw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Inmani'n amadiang inleiti, “Halle angkachang inlak chuonme nang in nathosik halli keini'n kinmuli nang kinna-ngamnasik hi? ");
INSERT INTO kfw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nipi nipu ngai'n neelramma manna inleibak; hintia lei-injia ‘Ama'n marwaan makheiya inmanidiang baksik ah waipool aleipeii.’ ” ");
INSERT INTO kfw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisu'n inmanidiang aleiti, “Kei'n inthiangnga nangni diang kanati, marwaan makheiya waipool kanaleipeii kha Moses emak, takkha marwaan makheiya inthiang waipool kanape kha kei Kapa eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pathian waipool khachu marwaan makheiya kajuo khat-um manmasituol diang ringna kapeii ama kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Inmani'n amadiang inleiti “Pumi, hiwa waipoolhi keinidiang apha rakip ah napero.” ");
INSERT INTO kfw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisu'n inmanidiang aleiti, “Kei ringna waipool kha ka eii, Kei kadiang kaheiwa miring kha wonkachaam ti omnuni; halli keidiang kangamna ama khan woikhat inlet-ah tuikaraal omnuni. ");
INSERT INTO kfw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Takkha kei'n nangnidiang kanati khachu nangni'n kei ningnamujei innum keidiang nangamna makchu. ");
INSERT INTO kfw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kapa'n keidiang inapeii rakip ngaikha keidiang inheiwasik eii, halli Kei'n tuteii inkhat-um keidiang kaheiwa ngaikha angtikteii puutnuning. ");
INSERT INTO kfw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ajarchu kei'n marwaan makheiya kalungdou kathosik ah kijuo kha emak takkha kei kanajuotir ama racham kathosik ah kijuo kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kei kanajuotir ama lungdou kha hiwahi eii, khachu keidiang inapejei ngaikha tuteii inkhat-um Kei'n minmang nuning, takkha ahekna nikhuoni inmani kha minringsik ti hi-eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Kapa imanuom khachu hiwahi eii, Asapa kamu khat-um ama diang ka-ngamna rakip in kumsoot ringna inmusik; Halli kei'n ama kha ahekna nikhuoni kaminringsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Kei marwaan makheiya kajuo waipool kha ka eii” atipi jarra Jihudi ngai'n ama chungnga leizootmu. ");
INSERT INTO kfw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Inmani'n inleiti, “Hiwahi eini'n anuli apa nijet Joseph sapa Jisu, emak abe? Angtho tholi, halle, tuuntak ‘Kei marwaan makheiya kijuo eii itime?’ ” ");
INSERT INTO kfw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisu'n inmanidiang aleimasang, “Nangni'n suungnga kei jarra num ningti kha daru. ");
INSERT INTO kfw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kei kanajuotir Kapa'n ama kha keidiang aheiruoimak inchu, tuteii innum keidiang heiwatheimu; halli kei'n ahekna nikhuoni khan ama kha kaminringsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pathian chongkachoi ngai larik khan injiajei, ‘Inmani rakip ngaikha Pathian in aminchusik eii.’ Apa Pathian diangnga karangai khat-um ka-inchu rakip ngai'n keidiang inheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pathian makheiya kajuo ama'n elekleiya tuteii miring inkhat innum Apa Pathian lamumu; ama khabit eii Pa Pathian kamu. ");
INSERT INTO kfw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kei'n inthiangnga nangnidiang kanati, kangamna mi khan kumsoot ringna kha anei. ");
INSERT INTO kfw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kei ringna waipool kha ka eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ningpi ningpu ngai'n neelramma manna inleibak halli inmani'n inleithijei. ");
INSERT INTO kfw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mi inkhat in abakli thimaknasik marwaan makheiya kajuo ringna waipool kha hi-eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kei marwaan makheiya kajuo akaring waipool kha ka eii, hiwa waipool kabaktak miring kha, kumsoot aringsik eii; halli Kei'n manmasituol ringna sik-ah kapesik waipool khachu kei kataksa kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jihudi ngai'n inmani suungnga murruolsiak inleithoa inleiti “Angtho tholi hiwa miring pa'n ataksa eini baksik-ah anape matorsikme?” ");
INSERT INTO kfw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisu'n inmanidiang aleiti, “Kei'n nangnidiang inthiangnga kanati, nangni'n Miring Sapa taksa kha ningbakmak khat-um ama thisen kha ning-inmak inchu, nangni ningpumma ringna ommak; ");
INSERT INTO kfw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kei kataksa kabak khat-um kei kathisen ka-in ngaikha kumsoot ringna kha innei, halli kei'n ahekna nikhuoni khan inmani kha kaminringsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kei kataksa hi inthiang bu kha eii; halli kei kathisen hi inthiang insik kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kei kataksa kabak khat-um kei kathisen ka-in ama khan keidiang inchat lekleiya aom, halli kei'n amadiang kaom. ");
INSERT INTO kfw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Akaringchak Kapa'n kei anajuotir, khat-um kei'n kapa jarra kiring angnga, Kei kataksa kabak miring khan kei jarra aringsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hiwahi eii, marwaan makheiya kajuo waipool kha; ningpi ningpu ngai'n inleibak suonuk inleithi ka-ang emak, hiwa waipool kabak miring khachu kumsoot ringna aneisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisu'n hiwa chongngaihi Capernaumma kaom Synagogue ah ileiminchu kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ama siamruoi katamtak ngai'n hiwahi inlei rangaiya inleiti, “Hiwahi kangarthei minchuna chong eii; tu juimatorsik me?” ");
INSERT INTO kfw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Takkha Jisu'n hiwa jarra asiamruoi ngai'n num intikha aleijet-ah, inmanidiang aleitipi, “Hiwa hi'n nangnidiang kesuina ebejei? ");
INSERT INTO kfw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Halle, nangni'n Miring Sapa kha mansa-ah aleiomna munkhan ikal ningmu inle angme ning-ngaidonsik? ");
INSERT INTO kfw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ringna kanape kha Ratha eii, taksa hichu iteii nemna ommak. Kei'n nangnidiang kileiril chong ngaikha ratha khat-um ringna kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Takkha nangni karra kangamnamak mi lekkhat ningom.” Jisu'n inphutna makheiya tu ngaime kangamna maksik khat-um tu inme ama kajuorsik kha aleijet. ");
INSERT INTO kfw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Halli ama'n aleiti, “Hiwa jarra eii kei'n nangni diang kileiti, khachu Apa Pathian in ama kha izootpi elekleiya tuteii-um keidiang heiwa matormu.” ");
INSERT INTO kfw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hiwa makheiya anukkajui katamtak in nuk inmalet-ah amale sisuom khaimujei. ");
INSERT INTO kfw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jisu'n soomleini ngaidiang aleiti, “Nangni-um nuk ningmalet-ah ningsizoot be?” ");
INSERT INTO kfw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter in amadiang aleimasang, “Pumi, tudiang keini'n sinung ngame? kumsoot ringna chongkha nangdiang om; ");
INSERT INTO kfw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Halli keini'n nanghi Pathian diang makheiya kajuo Inthiang kha na eii tihi kin-ngamnajei khat-um kinjetjei.” ");
INSERT INTO kfw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisu'n inmanidiang aleimasang, “Kei'n nangni soomleini kinakadang emak abe? halli ningkarra miring inkhatchu Seitan eii” ");
INSERT INTO kfw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Simon Iscariot sapa Judas jarra eii Jisu'n iril, ajarchu soomleini ngai karra Judas in Pumi ajuorsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hiwa thengnga, Jisu'n Galilee suungnga aleileeng; Ama'n Judea ramsuungnga leisizootmak, ajarchu khawa khanna kaom Jihudi ngai'n ama kha thatnasik inlei-entok. ");
INSERT INTO kfw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jihudi ngai Soongmachumna Kahoi kha aleinai, ");
INSERT INTO kfw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Khawa jarra ama unai ngai'n amadiang inleiti, nang itho chuon ngaikha nasiamruoi ngai'n inmunasik-ah “Hiwa munhi mathaan inlang Judea-ah sitro. ");
INSERT INTO kfw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tuteii miring innum araming aminsizoot inchu achuontho kha thupmak. Hiwa chuon ngaihi nithojei keengnga, manmasituol pumpui diang nang injettro.” ");
INSERT INTO kfw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ama a-u anai takngai innum amadiang leingamnamu. ");
INSERT INTO kfw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisu'n inmanidiang aleiti, “Kei kapha kha laheitungmak, takkha nangni sikchu aphakha omchei. ");
INSERT INTO kfw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Manmasituol in nangnichu namatir theinunu, takkha keichu innamatir, ajarchu Kei'n inchuontho ngaikha dikmak tia sakhi kapeii. ");
INSERT INTO kfw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nangni kahoi khan sitru; hiwa kahoi hin Kei sinuning, ajarchu kei kapha kha laheitungmak.” ");
INSERT INTO kfw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hiwahi atia ama'n Galilee ah aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Takkha anai ngai'n kahoi munkhan insisuo thengnga, Jisu um inlarleiya ruuk-ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jihudi ngai'n ama kha kahoi munkhan “Ma hun omme?” tia inlei-entok. ");
INSERT INTO kfw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mipui karra ama jarra tamthei num inleiti. Miring lekkhat in “Amahi mi katha eii” inleiti, lekkhat ngai'n “Emak,” “Ama'n mi katamtak lamleiitiang akeiruoi” inleiti. ");
INSERT INTO kfw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Takkha inmani'n Jihudi ngaikha inleichi jarra tuteii innum inlarra ama jarra leirilmu. ");
INSERT INTO kfw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kahoi alai ahongtungdeng phakhan Jisu'n Biak-inn tiang asiya khat-um kaminchu aleiphut. ");
INSERT INTO kfw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jihudi ngai'n inngak-ah inleiti, “Angtho tholi hiwa mi'n inchu lekleiya hituk ijetme?” ");
INSERT INTO kfw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisu'n inmanidiang aleimasang, “Kei iminchuhi kei kata emak, takkha kei kanajuotir ama ta kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tu ka-ang mi'n Pathian lungdou thosik-ah akadang inchu, ama'n kei minchunahi Pathian makheiya kajuobe emakli kei katheinuo ta kirilbe tikha ajetsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ama thomatorna ranak-ah karil ama khan apumtak inpaaknasik aril; takkha ama kajuotirpa minpaak sik-ah ka-entok miring khachu akadik kha eii, khat-um amadiang katuunmak iteii ommak. ");
INSERT INTO kfw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses in Sinadan inaleipeii emak abe? takkha nangni tuteii innum Sinadan kha juimakchu. Angjarra nangni'n kei nathatnasik ning-entokme?” ");
INSERT INTO kfw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mipui ngai'n inleimasang, “Nang nasuungnga raikhuo om! Tu in nang nathat sik-ah na-entok ame?” ");
INSERT INTO kfw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisu'n inmanidiang aleimasang, “Kei'n chuon inlak inkhat katho, halli nangni rakip ngai'n ningngak. ");
INSERT INTO kfw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses in nangnidiang wun tanru tia chong analeipeii (Moses diangnga inphut emak takkha nangni ningpi ningpu ngaidiang makheiya eii), halli nangni'n pasal naikha Sabbath nikhuoni wun ningtan. ");
INSERT INTO kfw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pasal nai khan Sabbath nikhuoni wun intan khat-um Moses Sinadan kha koimak inle, angjarra Kei'n miring inkhat Sabbath nikhuoni apum kamindamli nangni'n keidiang ningraangme? ");
INSERT INTO kfw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Meel en-inlang chongkatan kha emaru, takkha akadik khan chong tanru.” ");
INSERT INTO kfw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem makheiya miring lekkhat ngai'n inleiti, “Hiwa mipa hi emak abe inmani ngai'n thatsik-ah inlei-entok? ");
INSERT INTO kfw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Enru! Ama'n mipui karra arilla aom, khat-um inmani ngai'n amadiang iteii timu! thomatorna ranak kanei inmani ngai'n inthiangnga amahi Messiah eii tia leijetjeinubo? ");
INSERT INTO kfw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Hiwa mipa hichu humakheiya iheiwame eini'n nijet, takkha Messiah ajuokaal khanchu, tuteii innum humakheiya ijuome jetnunu.” ");
INSERT INTO kfw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisu'n Biak-inna iminchule inruoiya inringnga aleiti, “Nangni'n kei ningnajet abe, khat-um kei humakheiya kijuome ningnajet abe? Kei kapumtak thomatorna ranak-ah kijuo emak; Kei kanajuotir ama khachu akadik kha eii, halli nangni'n ama kha jetmakchu. ");
INSERT INTO kfw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Takkha kei'n ama kha kajet, ajarchu kei ama diangnga inphut kajuo, khat-um ama'n kei anajuotir.” ");
INSERT INTO kfw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Khawa jarra inmani'n ama kha sursik inleitho, takkha tuteii inkhat innum ama chungnga kut leimachulmu, ajarchu ama phakha laheitungmak. ");
INSERT INTO kfw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Takkha mipui katamtak in amadiang inlei-ngamna-ah inleiti, “Messiah ajuokaal khan, hiwa mipa itho neek-ah ama'n inlak chuon kheella athosikbe?” ");
INSERT INTO kfw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisee ngai'n Jisu jarra mipui'n chor inleitikha inleijet, khantia Thiampu kalianngai khat-um Pharisee ngai'n raalmi lekkhat ama kasursik-ah inleitir. ");
INSERT INTO kfw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisu'n aleiti, “Kei nangni le aphakhat kalaomsik eii, halli kei kanajuotir amadiang kei'n kasisik eii. ");
INSERT INTO kfw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nangni'n kei ningna-entoksik eii, takkha nangni'n kei namunatun; kei kaom nakhan nangni'n sitheinutun.” ");
INSERT INTO kfw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jihudi ngai'n inkhatli inkhatdiang inlei-inti, “Hunme ama'n sisik itho halli eini'n nimumaksik? Greek khuopui eini mi ngai omna khanbe ama'n asisik halli Greek mi-ngai diangbe ajuominchusik? ");
INSERT INTO kfw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Nangni'n kei ningna-entoksik eii, takkha nangni'n kei namunatun; kei kaom nakhan nangni'n sitheinutun’ tinahi ama'n ang atiname?” ");
INSERT INTO kfw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kahoi ahekna nikhuo, ahoinakhet nikhuoni, Jisu'n a-ngirra rasa inringnga aleiti, “Tu ka-ang mi khan atui raal inchu, keidiang heiwase inlang juo-inrase. ");
INSERT INTO kfw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Keidiang inngamna mi kha, Pathian chong inthiang khan ileiti angnga, ‘Ringna tuiring ngai'n ama wonsuungnga inluongsik eii.’ ” ");
INSERT INTO kfw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jisu'n hiwahi, amadiang ka-ngamna ngai'n inchangsik Ratha jarra iril eii; khawa phakhan Ratha kha laleipemak, ajarchu Jisu kha lalur lalianmak. ");
INSERT INTO kfw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Inmani'n hiwa chong ngaihi inleijet phakhan, miring lekkhat in inleiti, “Hiwa mipa hi inthiangnga Pathian Chongkachoi eii!” ");
INSERT INTO kfw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Leiilak ngai'n inleiti, “Amahi Messiah kha eii!” Takkha lekkhat ngai'n inleiti, “Messiah Galilee makheiya injir niabe? ");
INSERT INTO kfw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pathian chong inthiang khan Messiah kha David sapa esik eii khat-um David leiomna khuo Bethlehem makheiya heiwasik eii iti emak abe?” ");
INSERT INTO kfw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Khawa jarra mipui ngai karra ama jarra inlei-inkhoithen. ");
INSERT INTO kfw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mi lekkhat inchu ama kha inleisurzoot, takkha tuteii inkhat innum ama chungnga kut leimachulmu. ");
INSERT INTO kfw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Raalmi ngaikhan inheikir phakhan, Thiampu kalian khat-um Pharisee ngai'n “Angjarra nangni'n ama ning-iheiruoi makme?” tia inleirakel. ");
INSERT INTO kfw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Raalmi ngai'n inleimasang, “Hiwa mipa iril angnga tuteii-um hinthoa karil laommu!” ");
INSERT INTO kfw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pharisee ngai'n inmanidiang inleirakel, “Ama'n nangni-um lamleiitiang nakeiruoi bejei?” ");
INSERT INTO kfw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Waikaroon ngai emakli Pharisee ngai'n amadiang ka-ngamna in-ommabejei? ");
INSERT INTO kfw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Takkha Sinadan kajetmak mi ngai khachu khomaak inmukha ejei.” ");
INSERT INTO kfw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jisu diang matiangnga kaleiluutjei, inmani karra inkhat ka-eii Nicodemus in inmani diang aleiti, ");
INSERT INTO kfw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Eini sinadan dungjuiya miring khat chungnga ama'n angme ileitho emakli amadiang ra-ngailekleiya chong tan cha-abe?” ");
INSERT INTO kfw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Inmani'n inleimasang, “Nang-um Galilee makheiya na-ebe? Pathian chong inthiang kha entokro halli nang in jetnate khachu Galilee makheiya Pathian chongkachoi injirmu.” ");
INSERT INTO kfw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Khale inruoiya inmani'n in-inn in-inntiang inkirjei. ");
INSERT INTO kfw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Takkha Jisu chu Olive chingbung khan aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Halli ziingtiang ma-ah ama'n Biak-inn khan aheiwanook; mipui ngai'n amadiang inheiwa, halli ama'n alei in-ongnga inmani ngaikha aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dan Ocha ngai khat-um Pharisee ngai'n zool-inthai numeisa inkhat insurra inheiruoi, halli mipui karra inlei min-ngirra ");
INSERT INTO kfw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","inmani'n Jisu diang inleiti, “Karu, hiwa numeisanu hi zool-inthai chuon inleitho laitak inhongsur eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Dan dungjuiya Moses in chongpeii aleida khachu hiwa ka-ang numeisa khachu lungnga deengthat ru. Nangleii hiwa jarra ang natime?” ");
INSERT INTO kfw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Inmani'n hiwahi Jisu surna sik-ah inleiti eii, tichu inmani'n amadiang noonkung penasik eii. Takkha Jisu'n aleikuunna neipilla akut challa aleimajia. ");
INSERT INTO kfw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Halli Inmani'n amadiang inlet-ah inleirakel jarra, ama'n alu hongtangnga inmanidiang aleiti, “Nangni karra manu kalathomak miring khan numeisanu diang mansakhet-ah lungnga deengrase.” ");
INSERT INTO kfw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Halli ama'n woikhat akuun rit-ah neipilla aleimajiarit. ");
INSERT INTO kfw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Takkha inmani'n inlei rangai phakhan, upakhet makheiya inphut-ah, inmani rakip in inkhat inkhat-ah insiwiakjei, halli numeisanu khabit Jisu maikuungnga a-ngirra aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisu'n ahong-enna numeisanu diang aleiti, “Numeisa, inmani ngai huntiang insiwiak mejei? tuteii inkhat innum nangkha naminse mubejei?” ");
INSERT INTO kfw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Numeisanu'n aleiti, “Tuteii um ommujei, Pumi.” Halli Jisu'n aleiti, “Kei innum nang naminse mongjei; sitro, woikhat inlet-ah manu thoritkhai maro.” ");
INSERT INTO kfw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisu'n Pharisee ngaidiang inlet-ah aleirilrit-ah aleiti, “Kei manmasituol war kha ka-eii; kei kanajui miring khan akaziing khan sikhai nunijei, takkha ringna war kha amusik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pharisee ngai'n amadiang inleiti, “Nang napumtak jarra sakhi napeii; nang sakhi kha dikmak.” ");
INSERT INTO kfw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisu'n aleimasang, “Kei'n kapumtak jarra sakhi kape innum, kei sakhi hichu adik, ajarchu kei humakheiya kijuome halli kei'n hunme kisi kei'n kajet. Takkha nangni inchu kei humakheiya kijuome emakli hunme kisi jetmakchu. ");
INSERT INTO kfw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nangnichu taksa lamma chong ningtan; keichu tuteii diang-um chong tanmong. ");
INSERT INTO kfw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kei'n chong katan ngai suok-innum, kei chongtanchu adik, ajarchu kei katheinuo ah emong, takkha kei kanajuotir Kapa le kin eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nangni Sinadan khan injiajei khachu miring inni sakhi kha adik. ");
INSERT INTO kfw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kei kapumtak jarra sakhi kapeii, halli kei kanajuotir Kapa'n kei jarra sakhi eii.” ");
INSERT INTO kfw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Inmani'n amadiang inleiti “Nang napa hun omme?” Jisu'n aleimasang, “Nangni'n kei khat-um kei Kapa jetmakchu; nangni'n kei ningnaleijet inchu, nangni'n kei Kapa um ningleijetsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hiwa chong ngaihi Biak-inn suungnga sialsum mintiingna munkhan Jisu'n aminchu pumma aleiril; takkha tuteii inkhat innum ama kha leisurmu, ajarchu ama phakha laheitungmak. ");
INSERT INTO kfw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisu'n inlet-ah inmani diang aleiti, “Kei kalasisik eii; nangni'n kei ningna-entoksik eii, halli ningmanu roonkhan nangni ningthisik eii; kei kasinasik khan nangni'n sitheinutun.” ");
INSERT INTO kfw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Khawa jarra Jihudi ngai'n inleiti, “Kei kasinasik khan nangni'n sitheinutun itihi Ma atheinuo-ah thisik itibe?” ");
INSERT INTO kfw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisu'n inmani diang aleimasang, “Nangnichu nuoi makheiya ning eii, Keichu chungtiang makheiya ka eii; nangnichu hiwa manmasituol makheiya ning eii, takkha keichu hiwa manmasituol makheiya emong. ");
INSERT INTO kfw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kei'n nangnidiang katijei, khachu nangni ningmanu roonkhan ningthisik eii, nangni'n ‘KEIHI KEI KA-EII’ tia ningna-ngamnamak laiseng nangni ningmanu roonkhan ningthisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Inmani'n amadiang inleiti, “Nang tu na-eme?” Jisu'n aleimasang, “Kei'n inphutna makheiya kileiti kha ejei. ");
INSERT INTO kfw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kei'n nangni jarra tamthei karilsik khat-um tamthei chong katansik om; takkha Kei kanajuotir ama kha akadik kha eii, halli kei'n amadiang makheiya kijet kha kei'n manmasituol diang karilsouk.” ");
INSERT INTO kfw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jisu'n Apa jarra inmani diang iril eii tikha inmani ngai'n leijetmu. ");
INSERT INTO kfw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Khawa jarra Jisu'n aleiti, “Nangni'n Miring Sapa kha ningkadomsaang phakhan, nangni'n KEIHI KEI KA-EII tikha nangni'n jetningte, khachu kei kapumtak kamatorna ranak-ah iteii thomong takkha Kapa'n keidiang rilro iti ngaikhabit karil. ");
INSERT INTO kfw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Halli kei kanajuotir ama kha keile omsuom; ama'n katheinuo ah nadamak, ajarchu ama lungdou kha kei'n amun rakip-ah katho.” ");
INSERT INTO kfw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jisu'n arilla ompumma mikatam tak-in amadiang inlei-ngamna. ");
INSERT INTO kfw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisu'n amadiang inngamnajei Jihudi ngaidiang aleiti, “Kei kachong ngaikha ningjuichei inchu, nangni inthiangnga kei siamruoi ning eii, ");
INSERT INTO kfw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","halli nangni'n akadik kha jetningte, halli akadik khan nangni anamasuosik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Inmani'n amadiang inleimasang, “Keini Abraham tu-suonngai kin eii, halli keini'n tuteii diang-um suok lahong inchangmung. Angjarra nang in, ‘Nangni anamasuosik eii’ nitime?” ");
INSERT INTO kfw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisu'n inmani diang aleimasang, “Kei'n inthiangnga nangnidiang kati, manu katho mi rakip manu suok in-eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Suok khan kumsoot-ah insuungkhur mi emak; asapa kha kumsoot-ah insuungkhur mi eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Asapa khan nangni anamasuojei inchu, nangni inthiangnga inamasuo kha esijei. ");
INSERT INTO kfw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kei'n kajet nangni Abraham tu-suonngai ning eii; takkha nangni'n kei nathatnasik ningjong, ajarchu ningmalungnga kei kachong reiinasik ommak. ");
INSERT INTO kfw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kapa in naminmu kha kei'n karil, halli nangnichu ningpa ngai naleiti kha nangni'n ningtho.” ");
INSERT INTO kfw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Inmani'n amadiang inleimasang, “Abraham keini kinpa eii.” Jisu'n inmani diang aleimasang, “Nangni Abraham sangai ning-e inchu, Abraham ileitho ngaikha nangni'n ningthosik eii, ");
INSERT INTO kfw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pathian diangnga akadik kajet-ah akaril keihi nangni'n thatsik ningjong. Takkha Abraham chu hiwa ka-ang iteii leithomak! ");
INSERT INTO kfw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ningpa ngaitak ileitho ngaikha nangni'n ningtho eii.” Inmani'n amadiang inleiti, “Keini bojai sa emung; keini kinpa inkhat om, khachu Pathian eii.” ");
INSERT INTO kfw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisu'n inmani diang aleiti, “Pathian kha inthiangnga ningpa e-inchu, nangni'n kei ningnaminriang sik eii, ajarchu kei Pathian diang makheiya kijuo eii khat-um tuunhin kaom. Kei kalungdouwa kijuo emak; takkha ama'n innajuotir kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Angtia nangni'n kei itihi ningjetmak me? ajarchu nangni'n kei kachong ning ra-ngaimak jarra eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nangnichu ningpa Seitan makheiya ning eii, khat-um ningpa imanuom kha nangni-um ningthozoot. Inphutna makheiya ama chu mi kathat eii khat-um akadik khan supngir ngirmak, ajarchu amadiang akadik kha ommak. Ma'n maleisei aril kaalkhan, a-ngaiya ama diangnga kaomkha iril eii, ajarchu maleiseipa eii khat-um maleisei rakipngai pa eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Takkha, Kei'n akadik karil jarra, nangni'n keidiang na-ngamna makchu. ");
INSERT INTO kfw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tume nangni karra keihi manu karoon eii kanati mator? Kei'n kadik kha karil-inle, angjarra nangni'n keidiang ngamna ningneimakme? ");
INSERT INTO kfw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pathian diang makheiya kajuo ama'n Pathian chongkha arangai; nangni'n ningra-ngai makna ajarchu nangni Pathian diang makheiya emak chuwa eii.” ");
INSERT INTO kfw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jihudi ngai'n amadiang inleimasang, “Nangchu Samaritan na-eii khat-um nang raikhuo kachoi na-eii kintihi dikmungbe?” ");
INSERT INTO kfw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisu'n aleimasang, “Kei kapumma raikhuo ommak; kei'n Kapa khoya katho, takkha nangni'n kei khoya nathomakchu. ");
INSERT INTO kfw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kei kapumtak lurna lianna sik-ah entokmong; takkha aka-entok inkhat aom halli ama'n chongkatanpa esik eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kei'n inthiangnga nangnidiang kanati, tu miring inkhat in Kei kachong ajui inchu, ama kha angtikseng akathi mununi.” ");
INSERT INTO kfw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jihudi ngai'n amadiang inleiti, “Tuunchu keini'n inthiangnga kinjetjei khachu nang napumma raikhuo om! Abraham um Pathian chongkachoi ngai-um inthijei; halli nang in tu miring inkhat in Kei kachong ajui-inchu, akathi supmu mununi nati. ");
INSERT INTO kfw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Akathijei kinpa Abraham neek-ah nang nalokwiai abe? halli Pathian chongkachoi ngai-um inthijei! Nangleii tu ka-eii na-intime?” ");
INSERT INTO kfw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisu'n aleimasang, “Kei kapumtak kaminlur kaminlian inchu, kei lurna kha iteii emak; ning Pathian inchang Kapa tak-in naminlur naminlian eii. ");
INSERT INTO kfw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Takkha Nangni'n ama kha lajetmakchu; keichu ama kha kajet. Kei'n ama kha jetmong kati-inchu, kei-um nangni angnga maleisei karil kha ka eii; takkha kei'n ama kha kajet khat-um ama chongkha kei'n kajui. ");
INSERT INTO kfw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ningpa Abraham khan kei juonasik aphakha kamusik eii tia aleirok; halli ama'n aleimuwa aleirokjei.” ");
INSERT INTO kfw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jihudi ngai'n amadiang inleiti, “Nang kumsoom ra-nga latungleiya nang in Abraham namuwabejei?” ");
INSERT INTO kfw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisu'n inmani diang aleiti, “Kei'n inthiangnga nangnidiang kati, Abraham matiang Kei kalei-omjei.” ");
INSERT INTO kfw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Khawa jarra inmani'n amadiang deengna sik-ah lung inleiruut; takkha Jisu'n inthup-ah Biak-inn kha aleimathaan. ");
INSERT INTO kfw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisu'n asiya aleiloon phakhan, ama'n injuonei makheiya amit kacho miring inkhat aleimu. ");
INSERT INTO kfw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Asiamruoi ngai'n amadiang inleirakel, “Karu, tume manu katho, hiwa mipa hibe emakli anu apa ngai manu jarrabe ama'n amit cho-ah injuoneihi?” ");
INSERT INTO kfw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisu'n aleimasang, “Ama mit kachohi ama manu emakli anu apa manu jarra emak, takkha Pathian ranak kha ama chungnga chuon inlarnasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kani omlaiseng kei kanajuotir ama chuonkha eini'n nithosik eii; tuteii innum chuon thothamak nasik zaan kha aheiwajei. ");
INSERT INTO kfw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kei'n manmasituolla kaomlaiseng, kei manmasituol war kha ka eii.” ");
INSERT INTO kfw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hiwa atisuo nuk-ah, Jisu'n neipilla aleimachil khat-um amachil kha rahut khale aleikamet halli dialdook kha miringpa mit-ah aleikanoot ");
INSERT INTO kfw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","halli amadiang aleiti, “Siro, halli Siloam (Siloam tinachu itir tina eii) tuikuong khan namai juophero.” Miringpa khan asiya amai ajuophe, halli amit amuwa ahongkir. ");
INSERT INTO kfw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A-indiang inwaipui khat-um matiang ama'n baksik ileini kaleimu mi-ngai'n inleiti, “Hiwa mipahi in-ong jolla baksik kanani kachak pakha emak abe?” ");
INSERT INTO kfw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mi lekkhat in inleiti, “Ama hi eii,” leiilaak ngai'n “Emak takkha amale inpuokeeng” inleiti. Ama'n aleiti, “Kei khawa mipa kha ka eii.” ");
INSERT INTO kfw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Inmani'n amadiang inleiti, “Ang omchanna nang in namit nihongmume?” ");
INSERT INTO kfw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ama'n aleimasang, “Jisu inti miring inkhat in dialdook aboolla, kamit-ah akanoot-ah anati, Siloamma siro halli namai juophero; Khawa jarra kei'n kasiya kamai kajuophe li kei'n kamit kamujei.” ");
INSERT INTO kfw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Inmani'n inleirakel, “Ama hun ommejei?” “Kei jetmong,” ama'n aleimasang. ");
INSERT INTO kfw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Inmani ngai'n amit kaleicho miring pakha Pharisee ngaidiang inleiruoi. ");
INSERT INTO kfw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisu'n dialdook boolla khat-um amit kachopa aleimindamna kha Sabbath nikhuoni alei eii. ");
INSERT INTO kfw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pharisee ngai'n, woikhat inlet-ah mipadiang angtho tholia namit nihongmume tia inleirakelnook. Ama'n inmani diang aleiti, “Ama'n dialdook kamit-ah akanoot; kei'n kamai kajuophe, halli kei'n kamujei.” ");
INSERT INTO kfw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisee lekkhat ngai'n inleiti, “Hiwa katho miring kha Pathian diang makheiya emak, ajarchu ama'n Sabbath kha juimak.” Takkha leiilaak ngai'n inleiti, “Angtho tholia manu karoon miring inkhat in hiwa ka-ang inlak chuon thomator niyabe?” inmani ngaiseng karra inlei-inkhoithen. ");
INSERT INTO kfw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Khawa jarra Pharisee ngai'n mitkacho padiang woikhat inlet-ah inleirakelrit, “Nangleii amahi tu-eii natime? tichu ama'n nang namit naminmujei.” Ama'n aleiti, “Amahi Pathian chongkachoi inkhat eii.” ");
INSERT INTO kfw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jihudi ngai'n anu apa inleikoimak laisengchu ama kha amit leicho khat-um tuun ihongmu ejei tihi lei-ngamnamu, ");
INSERT INTO kfw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","khawa jarra inmani diang inleirakel, “Hiwahi nangni'n amit cho-ah kinjuonei eii ningti nangni sapa kha ebo? halle, angtho tholia ama'n tuunchu imume?” ");
INSERT INTO kfw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Anu li apa khan inleimasang, “Keini'n kinjet amahi keini sapa kha eii, khat-um amit cho-ah kinjuonei eii. ");
INSERT INTO kfw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Takkha ang omchanna ama'n tuunchu imume khachu keini'n jetmung, khale inruoiya ama mit-hi tu miring imindamme keini'n jetmung. Amadiang rakelru; amahi naipang emakjei, ama apum tak-in rilrase.” ");
INSERT INTO kfw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anu li apa'n Jihudi ngai inleichi jarra hiwahi inleiti, ajarchu Jihudi ngai inzootna aleiom, khachu Jisu hi Messiah eii kati miring kha Synagogue makheiya inpuutsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Khawa jarra anu li apa khan, “Amahi naipang emakjei, amadiang rakelru inleiti!” ");
INSERT INTO kfw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Khawa jarra inmani'n amit kaleichopa kha woikhat inlet-ah inkoirit-ah amadiang inleiti, “Pathian kha minpaakro; keini'n miring pakha manu karoon mi eii tikha kinjet.” ");
INSERT INTO kfw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ama'n aleimasang, “Ama kha manu karoon mibe emakbe, kei'n jetmong; kei'n inkhatchu kajet, Kei kamit aleicho, tuunchu kei kamujei.” ");
INSERT INTO kfw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Inmani'n amadiang inleirakel, “Ama'n nangdiang angme itho? angtho tholi ama'n namit kacho imindamme?” ");
INSERT INTO kfw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ama'n inmani diang aleimasang, “Kei'n nangnidiang katisuojei, halli nangni'n rangaimakchu. angjarra nangni'n inlet-ah ninglara-ngai zootme? Nangni-um ama siamruoi ngai ning-ezootbe?” ");
INSERT INTO kfw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Inmani'n amadiang inranna inleiti, “Nangchu ama siamruoi na eii, takkha keinichu Moses siamruoi kin eii. ");
INSERT INTO kfw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Pathian in Moses le ilei inbiak khachu keini'n kinjet, takkha hiwa miringpa jarrachu ama humakheiya kaheiwame eini'n iteii jetmakmi.” ");
INSERT INTO kfw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Miring pa'n aleimasang, “Hiwahi angtuk-ah ngak kaomme, angjarra nangni'n amahi humakheiya ijuome ningjetmak, takkha ama'n kei kamit kacho hichu imindam. ");
INSERT INTO kfw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eini'n nijet Pathian in manu karoon miring ngaidiang ra-ngaimak, takkha amadiang chubei katho khat-um ama lungdou katho mi ngai diangchu, Pathian in arangai. ");
INSERT INTO kfw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Manmasituol hong-injirra inphut tuteii miring inkhat innum amit cho-ah injuonei miring amit kaminmurit lajetmakmi. ");
INSERT INTO kfw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hiwa miring pahi Pathian diang makheiya kajuo emak inchu, ama'n iteii thomator nuni.” ");
INSERT INTO kfw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Inmani'n amadiang inleimasang, “Nang manule inruoiya innajuonei, halli nang in keinidiang nanaminchu sikbe?” halli inmani'n ama kha Synagogue makheiya inleipuutjei. ");
INSERT INTO kfw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisu'n ama kha inpuutjei tikha aleijet, halli Jisu'n ama kha alei-intongpuiya aleiti, “Nang Miring Sapa diang na-ngamnabo?” ");
INSERT INTO kfw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ama'n aleimasang, “Karu, kei'n ama diang ka-ngam nasik-ah, ama kha tume natipiro!” ");
INSERT INTO kfw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisu'n amadiang aleiti, “Nang in ama kha namujei, tuun nangdiang karilla kaom ama kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ama'n aleiti, “Pumi, Kei ka-ngamnajei!” halli ama'n Jisu diang chubei aleitho. ");
INSERT INTO kfw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisu'n aleiti, “Kamumak ngai'n inmunasik, halli akamu ngai'n inmit chonasik kei'n manmasituolla chongkatan kijuo kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pharisee lekkhat ama koolla kaom ngai'n hiwa chonghi injet-ah amadiang inleiti, “Keini ngai-um kinmit chobejei?” ");
INSERT INTO kfw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisu'n inmani diang aleimasang, “Nangni ningmit aleicho inchu, nangni'n manu karoon kha lei-enutun; takkha tuundet nangni'n keini kinmu ningti jarra, nangni manu karoon kha ningla-eii.” ");
INSERT INTO kfw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Kei'n inthiangnga nangnidiang kanati, keelngam omna innkot makheiya kaheiluutmak, takkha khattiang kalla kahongluut miring kha, inruup khat-um daku eii; ");
INSERT INTO kfw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","kot makheiya kaheiluut ama kha keelngamngai akakhaalpa kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kot ka-ngaak pa'n ama sik-ah kot amalongpi; keelngam ngai'n ama rasa kha injet, halli ama'n ama keelngam ngaikha inramingnga akoiya tuoltiang akeiruoi. ");
INSERT INTO kfw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ama'n ata-ngaiseng aheisuok puisuo phakhan, ama'n inmani ngai ma-ah asi, halli keelngam ngai'n ama nukkha injui, ajarchu inmani'n ama rasa kha injet. ");
INSERT INTO kfw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Inmani'n mi leiilaak nukkha juinunu, takkha inmani'n ama diangnga inphut intaandelsik eii, ajarchu inmani'n ama rasa kha jetmu.” ");
INSERT INTO kfw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisu'n inmani diang hiwa minkhinahi aleiti, takkha ama itikha inmani'n leijetmu. ");
INSERT INTO kfw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Khawa jarra Jisu'n woikhat inlet-ah inmani diang aleiti, “Kei'n inthiangnga nangnidiang kanati, Kei keelngam ngaisik kot kha ka eii. ");
INSERT INTO kfw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kei matiangnga kaheiwa rakip ngaikha inruup khat-um daku in-eii; takkha keelngam ngai'n inmani diang leira-ngaimu. ");
INSERT INTO kfw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kei kot kha ka eii. Kei kadiang kaheiluut miring khan ringna amusik eii; ama'n aheiluut khat-um asuoksik eii halli sachik-um amusik eii. ");
INSERT INTO kfw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Inruup khachu kamaruupsik, kathatsik, khat-um kaminmangsik bit-ah iheiwa kha eii; Keichu inmani'n ringna inmunasik khat-um insam omlekleiya ringna inmunasik-ah kijuo kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Kei akatha keelngam kakhaalpa kha ka eii. Akatha keelngam kakhaal pa'n keelngam ngaisik bit-ah aringkhuo apeii. ");
INSERT INTO kfw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","In-iniak mi, keelngam kakhaalpa ka-emak khat-um keelngam ata ka-emak ama khanchu, malang iheiwa amuli, ama'n keelngam ngaikha adaduoiya ataandel; khawa jarra malang khan keelngam ngaikha asur khat-um inmani ngaikha apuut choomdar. ");
INSERT INTO kfw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","In-iniak miring khan ataandel ajarchu keelngam ngaikha ama'n iteii minriangmak. ");
INSERT INTO kfw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Kei akatha keelngam kakhaalpa kha ka eii; kei keelngam ngaikha kei'n kajet khat-um kei keelngam ngai'n kei innajet. ");
INSERT INTO kfw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kapa khan kei inajet angnga kei innum Kapa kha kajet, halli kei keelngam ngaisik-ah kei'n karingkhuo kapeii. ");
INSERT INTO kfw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hiwa keelngam inn hinna kaommak kei keelngam lekkhat inlaom; Kei'n inmani ngai-um kalaheiruoisik eii, inmani'n kei kachong injuisik eii, halli miring inkhatbit-in ikhaal keelngam rahooi in-esik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Hiwa jarra Kapa'n kei anaminriang, ajarchu kei'n woikhat inlet-ah leirit nasik-ah karingkhuo kapeii. ");
INSERT INTO kfw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tuteii inkhat innum karingkhuo keidiang makheiya leimu, takkha Kei kapum tak-in kipesuok kha eii. Kei'n kapesuok sik-ah ranak kanei, khat-um leikirnook nasik-ah ranak kanei; Hiwa hi-eii Kapa in keidiang thoro inati chongpeii.” ");
INSERT INTO kfw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Woikhat inlet-ah hiwa chongngai jarra Jihudi ngai karra rupniya inkhoithenjei. ");
INSERT INTO kfw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Inmani katam tak-in inleiti, “Ama suungnga raikhuo om! amahi inweetjei; Ang sik-ah ama chongkha ningra-ngaime?” ");
INSERT INTO kfw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Leiilak ngai'n inleiti, “Raikhuo kaluut miring in hinthoa riltheinuni! raikhuo in amit kacho mi mindam mator-abe?” ");
INSERT INTO kfw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Phalbi ahei-ephakhan, Biak-inn Minthiangna kahoi kha Jerusalemma inleitho. ");
INSERT INTO kfw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisu'n Solomon Tuolngur inti Biak-inn khan asiya aleiom phakhan, ");
INSERT INTO kfw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jihudi ngai'n ama kha inlei-uumma inleirakel, “Angchen kasoot nang in keinidiang inngam-samna nanapesik me? keinidiang inthiangnga tiro, nang Messiah kha na-ebe?” ");
INSERT INTO kfw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisu'n aleimasang, “Kei'n nangnidiang katisuojei, takkha nangni'n keidiang na-ngamna makchu. Kapa ramingnga ka-itho chuon ngaikhan, kei rathuulla sakhi in-eii; ");
INSERT INTO kfw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Takkha nangni'n ngamnamakchu, ajarchu nangni kei keelngam emakchu. ");
INSERT INTO kfw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Kei keelngam ngai'n karasa injet; kei'n inmani ngaikha kajet, halli inmani'n kei kanuk innajui. ");
INSERT INTO kfw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kei'n hektik kaboi ringna kha inmani diang kapeii, halli inmani'n supthi thinanujei, halli tuteii inkhat innum kei kakut makheiya inmani ngaikha nakasut theinunu. ");
INSERT INTO kfw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Inmani ngai keidiang kanapeii kei Kapa kha angrakip neek-ah alokwiai, halli tuteii inkhat innum inmani ngaikha Kapa kut makheiya kasut theinunu. ");
INSERT INTO kfw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kapa li Kei inkhatbit kin eii.” ");
INSERT INTO kfw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jihudi ngai'n inlet-ah amadiang deengna sik-ah lung inleiruut. ");
INSERT INTO kfw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisu'n inmani diang aleiti, “Kei'n Kapa diangnga inphut chuon katha katamtak nangnidiang kanaminmujei; angkachang jarrame nangni'n keidiang lungnga ningna deengsik?” ");
INSERT INTO kfw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jihudi ngai'n inleimasang, “Keini'n chuon katha nathojarra lungnga kinnadeengsik emak, takkha Pathian narilthai jarra eii; ajarchu miring na-epumma Pathian ka-eii nati.” ");
INSERT INTO kfw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisu'n inmani diang aleimasang, “Nangni sinadan khan hintia injiajei ‘Nangni pathian ngai ning eii.’ ");
INSERT INTO kfw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pathian chong kajuotungjei inmani ngaidiang Pathian in pathian ngai tia akoi-inle (Pathian chong inthiang kha mangtheinuni), ");
INSERT INTO kfw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","‘Kei Pathian Sapa ka-eii kati jarra’ Apa'n aminthiangnga manmasituolla ijuotirjei amadiang nangni'n Pathian narilthai ninglatibe? ");
INSERT INTO kfw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kei'n Kapa chuon ngaikha kathomak inchu, nangni'n keidiang na-ngamnamaru. ");
INSERT INTO kfw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Takkha kei'n chuon ngaikha katho inchu, nangni'n keidiang ningna ngamnamak innum, Kapa khan keidiang om halli Kei'n Kapa diang kaom tihi ningjetnasik chuon ngaikha ngamnaru.” ");
INSERT INTO kfw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Woikhat inlet-ah inmani'n ama kha surnasik inleijong, takkha inmani ngai kutchung makheiya asuok-ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Halli Jisu'n inlet-ah Jordan tuidung arakaanna John in mansakhet-ah baptize aleiminthona munkhan aleisi, halli khawa khan ama'n aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mipui katamtak amadiang inheiwa-ah inleiti, “John chu inlak chuon iteii leithomak, takkha John in hiwa mipa jarra ileiril rakip ngaikha adik.” ");
INSERT INTO kfw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Halli khawa khan mipui katamtak-in amadiang inlei-ngamna. ");
INSERT INTO kfw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bethany makheiya araming Lazarus inti miring inkhat ana-ah aleiom, Bethany hi Mary li Martha ngai unai omna khuo kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hiwa Mary hi eii, Pumi keiiya sariak rimkahoi bunna asamma akeii kaleinuulpi nukha, akanapa Lazarus hi anaipa kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Khawa jarra a-unu ngai'n Jisu diang chong inleipeii, “Pumi, nang iminriang pakha anajei.” ");
INSERT INTO kfw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisu'n chongkha aleijet phakhan, ma'n aleiti, “Hiwa akanahi akathi sik emak; Pathian lurna heichoinasik eii, halli hiwa hi'n Pathian Sapa kha lurna amusik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisu'n Martha li anainu khat-um Lazarus kha aleiminriang. ");
INSERT INTO kfw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ama'n Lazarus kha anajei iti chongkha aleijet phakhan, Ama'n aleiomna munkhan nini alaleiom. ");
INSERT INTO kfw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Halli hiwa thengnga ama'n asiamruoi ngaidiang aleiti, “Judea-ah woikhat siritrui.” ");
INSERT INTO kfw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Asiamruoi ngai'n amadiang inleiti, “Rabbi, Jihudi ngai'n nangkha apha matiang lungnga nadeengnasik inna-entok, halli nang in khawa khan woikhat nalasiritsibe?” ");
INSERT INTO kfw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisu'n aleimasang, “Suun khat-ah phadan soomleini emak abe? suunna chuonkatho mi khan insuinuni, ajarchu ama'n hiwa manmasituol war kha amu. ");
INSERT INTO kfw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Takkha tu ka-ang inkhat in zaanna chuon atho inchu, ama'n insui, ajarchu war kha amadiang ommak.” ");
INSERT INTO kfw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisu'n hiwa itile inruoiya inmani diang aleiti, “Nisuopui Lazarus kha azaaljei, takkha kei ama kakeithei kasisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Asiamruoi ngai'n amadiang inleiti, “Pumi, ama'n azaaljei inchu damjeite.” ");
INSERT INTO kfw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisu inchu Lazarus kathi jarra aril, takkha inmani inchu azaalla soong imachum jarra inlei-ngaidon. ");
INSERT INTO kfw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Khawa jarra Jisu'n inmani diang inthiangnga aleirilpi, “Lazarus athijei; ");
INSERT INTO kfw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nangni ngamnasik jarra kei'n khawa munkhan kileiommak kha karatha arok. Eini'n amadiang situi.” ");
INSERT INTO kfw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Didymus Thomas in asappui siamruoi ngaidiang aleiti, “Amale juothi suomnasik eini rakip um situi.” ");
INSERT INTO kfw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisu'n aheitung phakhan, Lazarus kha thaanna inreiina nimili huuijei tikha aleijet. ");
INSERT INTO kfw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany hi Jerusalem makheiya miles innidaam inlaak, ");
INSERT INTO kfw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","halli Jihudi katamtak-um innaipa thipi jarra Mary li Martha kamatheemtai sik-ah inheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martha in Jisu kha aheiwajei ti aleijet phakhan, ama'n aheisuok-ah Jisu kha alei-inmupui, takkha Mary chu innsuungnga aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha in Jisu diang aleiti, “Pumi, nang in hin naleiomngai suok-inchu, kanaipa hi leithinuni! ");
INSERT INTO kfw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Takkha kei'n kajet khachu tuunnum nang in Pathian diang na-ini rakip kha Pathian in nangdiang napesik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisu'n Martha diang aleiti, “Nanaipa aringnook sik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha in aleimasang, “Ahekna nikhuoni khan ama kha hongringritte tikha kei'n kajet.” ");
INSERT INTO kfw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisu'n Martha diang aleiti, “Kei hongkaringnook khat-um ringna kha ka eii; Kei kadiang ka-ngamna miring khan inleithi innum inhongring sik eii, ");
INSERT INTO kfw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","halli karingnga kei kadiang ka-ngamna miring khan angtikseng thinunijei. Nang hiwahi na-ngamnabo?” ");
INSERT INTO kfw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ama'n Jisu diang aleiti, “Oh, Pumi; Kei'n nanghi Messiah, Pathian Sapa manmasituolla akajuo kha na-eii tia ka-ngamna.” ");
INSERT INTO kfw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hiwahi atisuoli Martha in asiya anainu Mary diang ruuk-ah ajuoti, “Karu kha hin omjei halli ama'n nangkha anakoi.” ");
INSERT INTO kfw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Hiwa chonghi ajet phakhan, Mary in innottheiya intheiya Jisu inmupui sik-ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisu kha khuosuung laheiluutmak, takkha Martha in intongpuina munkhan alaleiom. ");
INSERT INTO kfw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Innsuungnga kaom Mary kamatheemtai Jihudi ngai'n Mary in innottheiya intheiya tuol isuok inmu phakhan, inmani'n Mary kha thaanna akachapsik isirit ejei inngaidonna anukkha inleijui. ");
INSERT INTO kfw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary in Jisu omnakhan aheitungnga ama'n Jisu kha amuli amumak ama kekuungnga inbok-ah aleiti, “Pumi, nang in hin naleiomngai suok-inchu kanaipa hi leithinuni!” ");
INSERT INTO kfw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisu'n Mary khat-um Mary le kaheiwasuom Jihudi ngai'n inchap kha aleimu phakhan, amalungnga kahoimak khat-um poongna aleinei. ");
INSERT INTO kfw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jisu'n aleirakel, “Ama kha hun ningreiime?” Inmani'n inleimasang, “Pumi, heiwa-inlang juo-enro.” ");
INSERT INTO kfw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisu'n aleichap. ");
INSERT INTO kfw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jihudi ngai'n inleiti, “Enru ama'n angtuk iminriangme!” ");
INSERT INTO kfw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Takkha miring lekkhat ngai'n inleiti, “Amit kacho kaminmu hiwa mipa hi'n Lazarus thimaknasik thomatormak niabe?” ");
INSERT INTO kfw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Inlet-ah malung kahoimak in asip-ah, Jisu'n thaanna aleisi, thaankha lungkarong khurra alei-eii, khat-um thaankha lungnga inleikhar. ");
INSERT INTO kfw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisu'n aleiti, “Lung kha khairu!” Akathipa unu Martha in amadiang aleiti, “Pumi, tuuntak pha hinchu athurim aleisasik ejei, inreiina nimili hei-ejei!” ");
INSERT INTO kfw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisu'n Martha diang aleiti, “Na-ngamna inchu Pathian lurna lianna kha namusik eii natimongbe?” ");
INSERT INTO kfw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Khawa jarra Inmani'n lungkha inleikhai. Halli Jisu'n chungtiang enna aleiti, “Kapa Kei'n nangkha kanaminpaak, ajarchu nang in keidiang nanara-ngaipi. ");
INSERT INTO kfw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nang in amunle apha rakip-ah keidiang nanazootpi itihi kei'n kajet, keihi nang inajuotir eii tia hinna kaom inmani ngai'n ngamna inneinasik kei'n inmani sik-ah nangdiang kanahongni.” ");
INSERT INTO kfw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ama'n hiwahi atisuoli, “Lazarus, heisuokro” tia rasa inringnga aleikoi. ");
INSERT INTO kfw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazarus khan akeii akut khat-um ameel ngaikha kathi puonna intuomma aheisuok. Jisu'n inmanidiang aleiti, “Suutpi inlang ama kha minsiru.” ");
INSERT INTO kfw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mary le akaheiwa Jihudi mi katamtak ngai'n Jisu itho inmu phakhan, inmani'n amadiang inlei-ngamnajei. ");
INSERT INTO kfw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Takkha miring lekkhat chu Pharisee ngaidiang inkirra Jisu itho ngaikha inmani diang injuorilpi. ");
INSERT INTO kfw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Khawa jarra Thiampu kalian khat-um Pharisee ngai'n uparup ngaikha inkhoomchunna inleiti, “Angkeme eini'n nithosik? ajarchu hiwa miringpa'n inlak chuon tamthei athojei! ");
INSERT INTO kfw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Eini'n hin niminthotit inchu, mi rakip in amadiang ngamna inneisik ejei, halli Rome chuonkaroon ngai'n hong-inta eini inthiang Biak-inn khat-um niphung nizaat hi-um innakasutsik ejei!” ");
INSERT INTO kfw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Takkha inmani ngai karra, Caiaphas, khawa kumma Thiampu Kaliankhet ka-eii, ama'n inmani diang aleiti, “Nangni iteii jetmakchu! ");
INSERT INTO kfw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Phungli zaat rakip kamangsik neek-ah mipui sik-ah miring inkhat akathisik hi athawiai itihi nangni'n jetmak chube?” ");
INSERT INTO kfw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Hiwahi ama'n apumtak ranak-ah iti emak; takkha khawa kumma Thiampu Kaliankhet ejarra Jisu hi Jihudi phungli zaat sik-ah athisik eii tia ama'n ileirilsuok kha eii, ");
INSERT INTO kfw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","inmani sikbit emak, takkha inchekchaiya kaom Pathian mi ngaikha inkhat bit-ah aheikeichun nasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Khawa nikhuoni makheiya ranak kanei Jihudi ngai'n ama thatnasik-ah minsuukna inleinei. ");
INSERT INTO kfw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Khawa jarra Jisu'n Jihudi ngai karra inlarra leisimakjei, takkha khawa ramkha amathaanna neelram koolla kaom Ephraim inti khuokhan aleisi, halli khawakhan ama'n asiamruoi ngaikhale aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jihudi ngai Rakaanna Kahoi aheitungnasik aphakha aleinai, halli mipui katamtak in ram ram makheiya kahoi madet inmani sinadan dungjuiya inthiangnasik Jerusalemma inleisi. ");
INSERT INTO kfw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Inmani'n Jisu kha inlei-entok, halli Biak-inna inngirra inkhatli inkhat in, “Ama kha kahoiya ahongsikbe, hongnunibe, nangleii ang na-ngaidonme?” tia inlei-inbiak. ");
INSERT INTO kfw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Thiampu kalian ngai khat-um Pharisee ngai'n Jisu omna kajet mi rakip in inmani diang ningnamindiksik eii, halli inmani'n Jisu kha kinsursik eii tia chongkha inleipejei. ");
INSERT INTO kfw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Rakaanna Kahoi niruk matiang, Jisu'n akathi makheiya iminring Lazarus omna khuo Bethany ah aheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Khawa khan inmani'n ama sik-ah kholei bu inleiminsuuk, Martha in baksik kha aleiminsuuk halli Jisu le kabak sik-ah lei-in-ong karra Lazarus um alei-eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mary in aman katam inthiang Nard-ah insum sariak arim kahoi aheichoiya Jisu keiikha ajuokanoot halli Jisu keiikha asamma aleinuul, halli inn pumpui kha sariakrim kahoikhan aleisip. ");
INSERT INTO kfw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Takkha Judas Iscariot asiamruoi ngai karra Jisu kajuorsik pakhan aleiti, ");
INSERT INTO kfw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Angjarra hiwa sariak hi dangka pum rajathumma nijuor li sara ngaidiang nipemakme?” ");
INSERT INTO kfw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ama'n hiwa atina jarchu sara ngaikha aminriang khat-um asanzoot jarra emak takkha ama chu inruup ejarra eii. Ama'n sialkok kha achoi halli sialkok-ah inthun sialkha ama'n aleikeiduuk. ");
INSERT INTO kfw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisu'n aleiti, “Numeisanu in alungdou kha thorase, halli ama'n ineikha kei inreiina nikhuo sik-ah darase. ");
INSERT INTO kfw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sara ngai khachu amunle apha rakip-ah nangnile inomsuom, takkha keichu omsuom numin.” ");
INSERT INTO kfw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jihudi mikatam tak-in Jisu kha Bethany ah aom tihi inleijet pha khan, Jisu jarra bit emak-ah takkha ama'n akathi makheiya iminringjei Lazarus ka-ensik um inmani'n inheiwa. ");
INSERT INTO kfw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Halli Thiampu kalian ngai'n Lazarus um thatnasik-ah inlei-insuuk. ");
INSERT INTO kfw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ajarchu ama jarra Jihudi mi katamtak-in inmani makheiya insuok-ah halli Jisu diang inlei-ngamna. ");
INSERT INTO kfw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ziingkhuo warli Rakaanna Kahoi sik-ah akahongjei mipui katamtak ngai'n Jisu Jerusalemma aheiwasik eii tikha inleijet. ");
INSERT INTO kfw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Khawa jarra inmani'n kanoubuo inchoiya “Hosanna! Pumi ramingnga akajuo ama kha rawaan katha eii! Israel ngai Reng kha rawaan atha” intia inkheek-ah ama inmupui sik-ah inleisi. ");
INSERT INTO kfw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisu'n salungdai amuwa aleichuong; Chong-inthiang in iti angnga, ");
INSERT INTO kfw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Chimaru, Zion sa-ngai! Enru, nangni rengpa kha, salungdai teii achuongnga aheiwajei.” ");
INSERT INTO kfw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ama siamruoi ngai'n hiwahi leijetmu; takkha Jisu'n ahongringsuo thengngachu, inmani'n hiwa ngaihi ama jarra injia khat-um amadiang akasuok kha ejei tia inlei-ngaidon. ");
INSERT INTO kfw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazarus kha thaan makheiya akoisuok-ah akathi makheiya iminring kamu Jisu le inruoi mipui ngai'n mi leiilaak ngaidiang sakhi inleipeii. ");
INSERT INTO kfw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mipui ngai'n ama inmupui inheiwana ajarchu ama'n hiwa inlakchuon ileithohi inleijet jarra eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pharisee ngai'n inkhatli inkhat diang inlei-inti, “Ningmubo, nangni iteii thomator makchu! Enru, manmasituol pumpui'n ama nukkha injuijei!” ");
INSERT INTO kfw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kahoi suungnga Jerusalemma chubei kathosik-ah aleikasi ngai karra Greek Mi lekkhat inlei-inchel. ");
INSERT INTO kfw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inmani'n Galilee ah Bethsaida inti makheiya Philip diang inleisiya inleiti, “Ocha, keini'n Jisu kin-inmupuizoot.” ");
INSERT INTO kfw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip in asiya Andrew diang aleiti, halli inmani inni in insiya Jisu diang inleiti. ");
INSERT INTO kfw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisu'n inmani diang aleimasang, “Miring Sapa alurnasik tuun aphakha aheitungjei. ");
INSERT INTO kfw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kei'n inthiangnga nangnidiang kanati, sahuum khan neipilla achulla khat-um athimak inchu, inkhatbit eya aomchei, takkha sahuum khan athi inchu, akara katamtak ahongkara. ");
INSERT INTO kfw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ama ringkhuo kaminriang miring khan aringkhuo aminmangsik eii; halli hiwa manmasituolla aringkhuo kaminriangmak miring khan hektik kaboi ringna sik-ah aringkhuo kha areiiya ada. ");
INSERT INTO kfw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Kei sepa katho miring khan, kei kanuk anajuisik eii, halli kei kaomna khan, kei kasuok kha-um aomsik eii, Kei sepa katho miring kha Kapa in khoya athosik eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Tuun kei kamalung apoongjei, halli angme kei'n katisik? ‘Kapa, hiwa pha makheiya kei nasanro katisik be’? tinuning, hiwa sikbit jarra kei'n kijuo kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kapa, naraming kha lurrase!” Halli marwaanna inphut rasa khat ajuonei, “Kei'n kaminlurjei, halli kei'n inlet-ah kaminlurritsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Khawa khanna kangirra kaom mipui ngai'n rasa kha inleijet-ah inleiti, ro-inri rasa eii, aleiilaak ngai'n inleiti, “Marwaan Tirton inkhatle ama inbiak eii!” ");
INSERT INTO kfw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Takkha Jisu'n inmani diang aleiti, “Rasa kha Kei sik-ah kajuo emak, takkha nangni sik-ah eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tuun hiwa manmasituol sik-ah chongtan napha kha ejei; hiwa manmasituol karoonpa kha tuun inpuutsik ejei. ");
INSERT INTO kfw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kei nuoipil chungnga innakadom minsaangniya inphut, mi rakip keidiang kakeiruoisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hiwa atinachu ama'n ang omchanna athisikme ti inaminjet kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mipui ngai'n inleimasang, “Keini'n Sinadan makheiya kinjetjei tichu Messiah kha kumsoot aringsik eii. Angjarra, halle, nang in Miring Sapa kha inkadom saangsik eii nitime? Hiwa Miring Sapa hi tume?” ");
INSERT INTO kfw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisu'n aleimasang, “Apha lekkhat War kha nangnile omte. War kha omlai nangni'n chuon thoru, akaziing khan nangni anamator maklai; akaziingnga kaom miring khan hunme isi tikha jetmak. ");
INSERT INTO kfw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","War kha nangnidiang omlai, khat-um War sangai ning-eii nasik, War kha ngamnaru.” Jisu'n hiwa atisuo thengnga, Ama'n asuok-ah inmani diangnga inphut alei-inthup. ");
INSERT INTO kfw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ama'n inmani ngai maikuungnga inlak chuon tamthei athojei innum, inmani'n amadiang lei-ngamnamu ");
INSERT INTO kfw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ajarchu Pathian chongkachoipa Isaiah ileitikha huui tungnasik eii: “Pumi, eini chongkha tu-in ngamna mejei? halli Pumi ranak kha tudiang amalarmejei?” ");
INSERT INTO kfw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Khawa jarra inmani'n ngamnanunu, ajarchu Isaiah in inlet-ah aleiti, ");
INSERT INTO kfw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pathian in inmani ngai mitkha amincho khat-um inmalung kha amin-ngarpi tichu inmani'n inmumak nasik, halli inmalungnga injetmak nasik, khat-um keidiang inhei inletsik eii, halli kei'n inmani kamindamsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah in hiwahi aleiti ajarchu Jisu lurna kha aleimu khat-um ama jarra aleiril. ");
INSERT INTO kfw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Khale inruoiya, chuonkaroon Jihudi katamtak um Jisu diang inlei-ngamna; takkha Pharisee ngai'n Synagogue makheiya innapuutsik eii tia inleichi jarra inmani'n lei-inlarmu. ");
INSERT INTO kfw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ajarchu inmani'n Pathian in iminpaak neek-ah miring ngai'n inminpaak kha inleimanuom. ");
INSERT INTO kfw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisu'n inringnga aleiti, “Kei kadiang ka-ngamna miring khan kei ina-ngamna emak takkha kei kanajuotir ama kha i-ngamna eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Halli Kei kanamu miring khan kei kanajuotir ama kha imu ejei. ");
INSERT INTO kfw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kei kana-ngamna miring rakip in akaziing khan inom-maknasik kei'n manmasituolla War ka-inchangnga kajuojei. ");
INSERT INTO kfw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Kei iti chongngai kajet halli akajuimak mi ngaikha, Kei'n inmani diang chong tannuning, ajarchu Kei manmasituol diang chongkatan kijuo kha emak takkha kakatan sik-ah kijuo kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kei kanazootmak khat-um kei iti chongngai kaleimak mi ngai sik-ah chong katansik inkhat om. Kei ileirilsuok chongngai khan inmani chungnga ahekna nikhuoni khan chong atansik eii! ");
INSERT INTO kfw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ajarchu kei kapumtak thomatorna karanak-ah kiril kha emak, takkha kei kanajuotir Kapa'n katisik khat-um karilsik chongpeii ngaikha ama'n keidiang anatipi. ");
INSERT INTO kfw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kei'n kajet khachu ama chongpeii kha kumsoot ringna eii. Kei iril hi, Kapa'n keidiang tiro iti chong ngaikha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Rakaanna Kahoi aheitung madet, Jisu'n hiwa manmasituol amathaanna Apa koolla akirnasik ama phakha heitungjei ti aleijet phakhan, manmasituolla kaom ama mi takngaikha aleiminriang, halli ama'n inmani ngaikha ahekna katung aminriang. ");
INSERT INTO kfw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Halli kholeibu inbakpha khan, Seitan khan Simon sapa Judas Iscariot malung suungnga Jisu juornasik-ah aleipesuo phakhan, ");
INSERT INTO kfw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisu'n ama kutchungnga ranak rakip kha Apa'n apejei halli amahi Pathian diang makheiya ijuo eii khat-um Pathian diang akirnook sik eii tihi aleijet-ah, ");
INSERT INTO kfw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ama'n bubakna khamtuol makheiya intheiya, chungtiang ikahak asongkol kha aliik-ah, halli akhoongnga koongkhit kha aleikhit. ");
INSERT INTO kfw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Halli rasuna beella tui abunna asiamruoi ngai keii karasu aleiphut khat-um akoongkhit puon khan inmani ngaikha aleinuul. ");
INSERT INTO kfw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ama'n Simon Peter diang aheiwa, halli Peter in amadiang aleiti, “Pumi, nang in kei kakeii-um narasusibe?” ");
INSERT INTO kfw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisu'n amadiang aleimasang, “Kei'n angme kitho nang in tuun jetnutin, takkha nang in nuktiang nahongjetsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter in aleimasang, “Nang in kei kakeii angtikseng rasuthei nutin!” Jisu'n aleimasang, “Kei'n nang nakeii karasumak inchu, nangle kei inchunmakmi.” ");
INSERT INTO kfw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter in aleimasang, “Pumi, kakeiibit emak takkha kakut li kalu um narasu piro!” ");
INSERT INTO kfw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisu'n amadiang aleimasang, “Tuikabuol suojei miring khan akeiibit rasusik arei eii, apum raya-ah inthiangjei, halli nang-um nanthiangjei, takkha nangni ningraya achu ning-inthiang emak.” ");
INSERT INTO kfw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ajarchu Jisu'n tume ama kajuorsik tikha aleijet suojei, khawa jarra ama'n aleiti, “Nangni ningraya achu ning-inthiang emak.” ");
INSERT INTO kfw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisu'n inmani keii arasupi suoli, ama'n apuondiar inlukrit-ah halli khamtuolla in-ongnga ama'n inmani diang aleirakel, “Kei'n nangnidiang ka-itho kha nangni'n ningjetbo?” ");
INSERT INTO kfw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Nangni'n Karu khat-um Pumi tia ningnakoi, halli nangni itikha adik, ajarchu khawakha Kei ka eii. ");
INSERT INTO kfw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ning Karu khat-um ning Pumi Kei'n ningkeii karasujei keengnga, nangni-um inkhatli inkhat ningkeii ning insusik eii. ");
INSERT INTO kfw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kei'n nangnidiang kileitho angnga nangni innum ningthona sik-ah Kei'n ningjetnasik kinaleipe kha ejei. ");
INSERT INTO kfw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kei'n inthiangnga nangnidiang karil: suok khan ama karu neek-ah lokmak; emakli injuotir ama khan akajuotirpa neek-ah lokmak. ");
INSERT INTO kfw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hiwa ngaihi ningjetli, ningtho inchu rawaan katha kha ning eii.” ");
INSERT INTO kfw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kei'n nangni ningraya jarra kiril emak; Kei ikadang ngaikha kei'n kajet; takkha ‘Kei waipool kabak ama'n kei kachungnga akeii ada’ iti Pathian chongkha huui tungnasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kei'n hiwahi tuun asuokmaklai nangnidiang kinati kha eii, tichu ahongsuok kaalkhan nangni'n ‘KEIHI KEI KA-EII’ tikha ningngamna sik eii. ");
INSERT INTO kfw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kei'n inthiangnga nangnidiang kanati, Kei itir mi inkhattak karalaang miring khan Kei inaralaang eii; halli Kei kanaralaang miring khan kei kanajuotir ama kha aralaang.” ");
INSERT INTO kfw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisu'n hiwa atisuo thengnga, ama'n amalungnga apoongnga aleirilsuok, “Kei'n nangnidiang inthiangnga kanati; nangni karra miring inkhat in kei anajuorsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Asiamruoi ngai'n khatli inkhat inlei-in-en, takkha tu jarra irilme tikha leijetmu. ");
INSERT INTO kfw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Asiamruoi ngai karra miring inkhat Jisu'n iminriang pakha Jisu diang inngaiya alei-in-ong. ");
INSERT INTO kfw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter in ama diang abiak chianna aleiti, “Tu jarra ama'n irilme rakelro.” ");
INSERT INTO kfw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Khawa Siamruoi khan Jisu diang inngaiya halli “Pumi, tume?” tia aleirakel. ");
INSERT INTO kfw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisu'n aleimasang, “Kei'n waipool lekkhat ankheengnga kanoomli kipeii, ama kha eii.” Halli ama'n waipool lekkhat aleiya ankheengnga aleinoom, khat-um Simon Iscariot sapa Judas diang aleipeii. ");
INSERT INTO kfw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas in waipool kha aleili aleimak, Seitan khan amadiang aleiluut. Jisu'n amadiang aleiti, “Nathosik chuonkha innottheiya thotro!” ");
INSERT INTO kfw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bubakna khamtuol khan in-ongnga kaom tuteii inkhat innum angjarra Jisu'n hiwahi amadiang itime tikha leijetmu. ");
INSERT INTO kfw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Siamruoi lekkhat ngai'n Judas kha sialpu eyarra Jisu'n kahoi suungnga inbak sik-ah bakphur karacho emakli sara ngaidiang sial kapeii iminsi lei-ete tia inlei-ngaidon. ");
INSERT INTO kfw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas in waipool kha aleisuoli aleisuomak, ama'n innottheiya asuok-ah aleisi, khawa phakha zaanchim alei-eii. ");
INSERT INTO kfw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas in asisuo thengnga, Jisu'n aleiti, “Tuun Miring Sapa kha alurjei; halli ama diangnga inphut Pathian kha-um alurjei. ");
INSERT INTO kfw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pathian in ama diangnga inphut alur-inchu, Pathian innum ama kha apum tak-ah aminlursik eii, khat-um tuuntak aminlursik eii. ");
INSERT INTO kfw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Minriang kaom naipang ngai, apha bongkhat kei nangnile kaom suomsik eii. Nangni'n kei ningna-entoksik eii, Jihudi ngaidiang kileiril chongkha tuun nangnidiang kiril kha eii, ‘Kei kasinasik khan nangni hongthei nutun.’ ");
INSERT INTO kfw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Kei'n nangnidiang akathar chongpeii kanapeii, khachu inkhatli inkhat inriangru; Kei'n nangni kinaminriang angnga, nangni-um khatli inkhat ning-inriangsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nangni khatli inkhat ning-inriangjei inchu, khawakhan manmasituol pumpui'n nangni ngaihi kei kasiamruoi ning-eii tikha jet inte.” ");
INSERT INTO kfw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter in amadiang aleiti, “Pumi, hunme nasisik?” Jisu'n aleimasang, “Kei kasinasik khan nang in tuun najuithei nutin, takkha nuk-ah nang in nanahongjuisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter in aleimasang, “Pumi, angjarra kei'n tuun nang kanajui theimak sikme? Kei nangsik bit-ah karingkhuo pekate.” ");
INSERT INTO kfw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisu'n aleimasang, “Keisik bit-ah nang thimator tinnabe? Kei'n inthiangnga nangdiang kanati, nang in keikha woithum najetmong natimak laiseng, arkhong khan khuongnuni. ");
INSERT INTO kfw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nangni ningmalung kapoong emaru; Pathian ngamnaru, halli kei-um na-ngamnaru. ");
INSERT INTO kfw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kei Kapa inna omna mun katamtak aom; aleiom makngai suok-inchu, kei'n nangnidiang nangni omnasik mun kabool kisi eii timak ningngabe? ");
INSERT INTO kfw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Halli kei'n nangni omnasik mun kasiya kabool suoli, kei'n juorit kata nangni-um kakoolla kanaruoisik eii, ajarchu kei omnakhan nangni-um ningomsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Halli kei hunme kisi, nangni'n lamkha ningjet.” ");
INSERT INTO kfw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas in amadiang aleiti, “Pumi, hunme nisi keini'n jetmung; angtho tholi keini'n lam kha kinjetsikme?” ");
INSERT INTO kfw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisu'n amadiang aleimasang, “Kei lam kha ka-eii, akadik kha ka-eii, khat-um ringna kha ka-eii; kei diangnga inphut elekleiya tuteii miring innum Kapa diang tungnunu. ");
INSERT INTO kfw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nangni'n kei ningnaleijet inchu, nangni'n kei Kapa kha-um ningleijetsik kha eii; tuun makheiya chu nangni'n ama kha ningjetjei khat-um ningmujei.” ");
INSERT INTO kfw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip in amadiang aleiti, “Pumi, Pa Pathian kha keinidiang naminmuro, halli keini'n kinmalung ataisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisu'n aleimasang, “Kei'n apha kasoottak nangnile kaom; kha e-innum nangni'n kei nalajet makchube, Philip? Kei kanamu miring khan Apa Pathian kha-um imukha ejei. Angjarra, halle, nang in Pa Pathian nangnidiang naminmuro nitime? ");
INSERT INTO kfw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kei'n Kapa diang kaom halli Kapa in keidiang om tihi nang ngamna makchebe? Kei'n nangnidiang kiril chong ngaihi kei kapumtak thomatorna ranak-ah kiril kha emak; takkha kei kadiang kaom Pa Pathian in ama chuon ngaikha itho eii.” ");
INSERT INTO kfw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Keidiang na-ngamnaru khachu Kei'n Kapa diang kaom halli Kapa in keidiang om, kha emakli ka-itho chuon ngai'n ajar-eya ngamnaru. ");
INSERT INTO kfw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kei'n nangnidiang inthiangnga kanati, Kei kadiang kangamna mi khan kei itho chuon ngaikha athosik eii, hiwa chuonngai neek-ah kalokwiai ama'n alahongthosik eii, ajarchu kei'n Kapa diang kasisik eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pa Pathian in Asapa diangnga inphut lurna lianna amunasik-ah kei karamingnga ning-ini rakip, kei'n kathosik eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nangni'n kei karamingnga angmo khattak ningnani inchu, Kei'n kathosik eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nangni'n kei ningnaminriang inchu, nangni'n kei chongpeii ngaikha juiningte. ");
INSERT INTO kfw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kei'n Pa Pathian diang kanisik eii, halli ama'n kei ka-emak Akanasansik nangnile kumsoot kaomsik inkhat anapesik eii, ");
INSERT INTO kfw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","khawakha Ratha Inthiang kha eii. Manmasituol in ama kha ralaangnuni, ajarchu manmasituol in ama kha jetmak khat-um mumak; takkha nangni'n ama kha ningjet, ajarchu ama'n ningsuungnga om khat-um nangnile omsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Kei'n nangni kha nu le pa kaboi angnga nadanuning; Kei'n nangnidiang kajuoritsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Apha sootlekleiya, manmasituol in kei hi namununijei, takkha nangni inchu kei ningnamusik eii; kei karing jarra, nangni-um ningringsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Khawa nikhuo nikhan kei'n Kapa diang kaom, nangni'n kei kadiang ning-om, halli kei'n nangnidiang kaom tihi nangni'n ningjetsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Kei chongpeii ngai kakeiluut khat-um akajui mi ngaikha eii kei kanaminriang, kei kanaminriang mi ngaikha Kapa'n aminriangsik eii; Kei innum inmani ngaikha kaminriangsik eii halli kapumtak inmani diang ka-inlarsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (Judas Iscariot ka-emak) in amadiang aleiti, “Pumi, angjarra nang in manmasituol diang inlarlekleiya keinidiang na-inlarsik me?” ");
INSERT INTO kfw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisu'n amadiang aleimasang, “Miring inkhat in kei anaminriang inchu, ama'n kei kachong kha ajuisik eii, halli Kapa in ama kha aminriangsik eii, halli keini'n amadiang juokinta amale kin-omsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kei kanaminriangmak ama khan kei kachong ngaikha juimak, halli nangni'n ningrangai chongkha kei kachong emak takkha kei kanajuotir Kapa chong kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Hiwa ngaihi kei'n nangnile kaomlai nangnidiang kileiril kha ejei. ");
INSERT INTO kfw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Takkha Kanasanpa, Ratha Inthiang kha, Kapa'n kei karamingnga ajuotirsik eii, ama'n angrakip kha anaminchusik eii, halli kei'n nangnidiang kileiril rakip ngaikha ngaidon matorna anapesik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Akahoi akadai kha nangnidiang omrase; kei diangnga kaom akahoi akadai kha nangnidiang kanapeii, manmasituol inapeii angnga kei'n napemong. Ningmalungnga akapoong, khat-um akachi kha emarase. ");
INSERT INTO kfw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kei'n nangnidiang kiti kha nangni'n ningjet, ‘Kei'n kasisik eii, halli kei'n nangnidiang kajuoritsik eii.’ Nangni'n kei ningnaminriang inchu, nangni'n ningroksik eii, ajarchu kei Kapa diang kisi eii; ajarchu Kapa kha keineek-ah alok. ");
INSERT INTO kfw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ajarchu ahongsuokli nangni'n ningngamna sik-ah, tuun apha ahongtung maklai kei'n nangnidiang kileiti kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kei nangnile kasoot-ah inkook nuningjei, ajarchu hiwa manmasituol waikaroonpa kha aheiwajei. Ama'n kei kachungnga iteii wai roonmak, ");
INSERT INTO kfw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kei'n Kapa kha kaminriang tihi manmasituol in injetna sik-ah Kapa in thoro iti ngaikha kei'n katho. Intheitaru, hiwa mun makheiya eini'n situi.” ");
INSERT INTO kfw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Akadik Theibom kuungkha kei ka-eii, halli rahuon katho kha kei Kapa eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ama'n kei diangnga kaom akakaramak ayam rakip ngaikha atuktan, halli akakara ayam rakip ngaikha kheella akara nasik ama'n arathial. ");
INSERT INTO kfw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kei'n nangnidiang kileiriljei chongkhan nangni inaminthiang kha ejei. ");
INSERT INTO kfw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kei kadiang inchat lekleiya omru, halli kei'n nangnidiang inchat lekleiya omkate. Ayam bit-in akuung inchel lekleiya ikaramak angnga, nangni-um kei kadiang ningomchakmak inchu karanutun.” ");
INSERT INTO kfw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Kei Theibom kuungkha ka eii, halli nangni'n abaak ngaikha ning eii. Nangni'n keidiang inchat lekleiya ningom halli kei'n nangni diang inchat lekleiya kaom inchu, nangni katamma ningkarasik eii; ajarchu kei inchel lekleiya nangni iteii thomator makchu. ");
INSERT INTO kfw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kei kadiang inchat lekleiya kaommak miring khachu abaak kathamak indengjuonli akachar ka-ang kha eii; halli abaak ngaikha khoomchun inta halli meiya deengluut inta inhaalsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nangni'n keidiang inchat lekleiya ningom khat-um kei kachong ngaikha nangnidiang inchat lekleiya om inchu, nangni'n ningnizoot kha niru, khawa kha nangni'n nimusik eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nangni'n katamma kakara, khat-um kei kasiamruoi ning eii tikha minmuru. Khawakhan kei Kapa kha alur aliansik eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kapa in kei inaminriang angnga, kei innum nangni kanaminriang; kei minriang nakhan inchat lekleiya omru. ");
INSERT INTO kfw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kei'n Kapa chongpeii kijui khat-um ama minriang nakhan inchat lekleiya kiom angnga, nangni'n kei chongpeii ngaikha ningjui inchu, kei minriang nakhan inchat lekleiya ningomsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Kei rokna kha nangnidiang omnasik, halli nangni rokna kha huui tungnasik-ah hiwa ngaihi kei'n nangnidiang kileiril kha ejei. ");
INSERT INTO kfw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kei'n nangni kinaminriang angnga inkhatli inkhat inriangru kitihi kei chongpeii kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Miring inkhat in asappui ngaisik aringkhuo ipeii itihi khawa chungtiang akalok minriang kha ommakjei. ");
INSERT INTO kfw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kei chongpeii ningjui inchu nangni kei kasappui ngaikha ning eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kei'n nangni kha suok tia nakoi mongjei, ajarchu suok ngai'n inkaru khan angme itho tikha jetmu, khawa neek-ah, kei'n nangni kha kasappui tia kanakoi, ajarchu kei'n Kapa diang makheiya kijet rakip ngaikha nangnidiang kanarilpi suojei. ");
INSERT INTO kfw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nangni'n kei ningnakadang kha emak, takkha kei'n nangni kinakadang eii, nangni'n ningsiya katamma ningkara nasik khat-um inchat lekleiya ningkara omnasik, khat-um kei karamingnga Pa Pathian diang ning-ini rakip ngaikha nangnidiang anape nasik kei'n chuonmun kinapeii ejei. ");
INSERT INTO kfw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inkhatli inkhat inriangru, hiwahi kei chongpeii kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Manmasituol in nangni anamatir inchu, jetru nangni anamatir ma-ah kei inamatir kha ejei. ");
INSERT INTO kfw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nangni manmasituol mi ninglei e-inchu, manmasituol in ata iminriang angnga nangni anaminriangsik eii, takkha manmasituol makheiya inphut kei'n kinakadangjei khat-um manmasituol mi emakchujei jarra, manmasituol in nangni inamatir kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kei'n nangnidiang kileiti chongkha ngaidonru, ‘Suok in amapupa neek-ah lokmak.’ Mi ngai'n kei poongna raalna innapeii inchu, nangni-um inmani'n poongna raalna innapesik eii; inmani'n kei kachong kha injui inchu, inmani'n nangni chong kha-um injuisik eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Takkha kei kami ning eii jarra inmani'n hiwa rakip ngaihi nangnidiang innathosik eii; ajarchu kei kanajuotir ama kha inmani ngai'n jetmu. ");
INSERT INTO kfw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Kei'n kaleijuoli inmani ngaidiang kaleirilpi mak-inchu, inmani'n inmanu leiomnuni; takkha tuunchu inmani ileitho kha manu emak titheinunu. ");
INSERT INTO kfw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kei kanamatir miring khan kei Kapa kha-um amatir. ");
INSERT INTO kfw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kei'n inmani ngai karra tuteii itho maneiimak inlak chuon kathopimak inchu, inmani manu leiomnuni; takkha tuunchu inmani'n kei-um Kapa-um innamujei halli innamatirjei. ");
INSERT INTO kfw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘Inmani'n ajar omlekleiya kei innamatir’ iti inmani Sinadan dungjuiya lei-injia kha huui tungnasik hiwahi kasuok kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Takkha Kapa diang makheiya kei'n nangnidiang kajuotir sik, “Akanasanpa, Ratha Inthiang, Kapa diangnga inphut kasuok ama'n ajuopha khan, ama'n kei jarra sakhi esik eii. ");
INSERT INTO kfw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Halli nangni-um kei jarra sakhi kha ning esik eii, ajarchu inphutna makheiya nangni'n keile ningomjei.” ");
INSERT INTO kfw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nangni'n ning-insui maknasik kei'n nangnidiang hiwahi kinaleirilpi kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Synagogue makheiya nangni innapuutsik eii, halli nangni kanathat mi khan Pathian sik-ah chuon kitho eii tia a-ngaidon nasik aphakha aheiwajei. ");
INSERT INTO kfw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hiwa ngaihi inmani'n nangnidiang innathosik eii, ajarchu inmani'n Pa Pathian khat-um kei najetmu. ");
INSERT INTO kfw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Inmani pha ahongtung nikhan, kei'n inmani ngai jarra kileiril eii tia ningngaidon nasik hiwa ngaihi kei'n nangnidiang kileiril kha ejei.” “Kei'n nangnidiang inphutna-ah hiwa ngaihi rilmong, ajarchu kei nangnile kaleiom. ");
INSERT INTO kfw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Takkha tuunchu kei kanajuotir amadiang kasisik ejei; kha e-innum nangni tuteii inkhat innum, ‘Nang hunme nasisik?’ tia keidiang narakel makchu. ");
INSERT INTO kfw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Takkha kei'n hiwa ngaihi nangnidiang kati jarra, ningmalungnga akapoong khan asipjei. ");
INSERT INTO kfw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Takkha kei'n nangnidiang inthiangnga kanati: nangni thanasik eii, kei'n kisihi, kei'n kasimakngai suok-inchu, Akanasanpa kha nangnidiang juonuni; takkha kei'n kasi inchu, Kei'n ama kha nangnidiang kajuotirsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Halli ama'n ajuo phakhan, ama'n manu, nunchan kadik, khat-um chongtan jarra manmasituol diang aminjetsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Manu jarrachu inmani'n kei kadiang ngamna neimu; ");
INSERT INTO kfw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","akadik jarrachu, kei Kapa diang kasisik eii, halli nangni'n kei namunutunjei; ");
INSERT INTO kfw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","chongtan jarrachu hiwa manmasituol waikaroonpa kha chong intan suojei.” ");
INSERT INTO kfw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kei'n nangnidiang tamthei kalarilsik aom, takkha nangni'n tuunchu deimaneii natunjei. ");
INSERT INTO kfw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Akadik Ratha kha ajuo phakhan, ama'n nangni kha akadik rakip khan anakeiruoisik eii. Ama apumtak athomatorna ranak-ah irilkha emak, takkha ama'n ijet ngaikha arilsik eii halli akahongsuoksik ngaikha nangnidiang arillarsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ama'n kei lurna anapesik eii, ajarchu ama'n kei kata ka-ekha leita halli nangnidiang arillarsik eii. ");
INSERT INTO kfw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kapa inei rakip kha kei kata eii; khawa jarra eii ama'n kei kata leita halli nangnidiang arillarsik eii kiti kha. ");
INSERT INTO kfw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Apha sootleiya nangni'n kei namunutunjei, halli apha sootlekleiya nangni'n kei namunook ningte.” ");
INSERT INTO kfw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ama siamruoi lekkhat in inkhatli inkhatdiang inlei-inti, “Angkeme ama'n einidiang itihi? Aphakhat-ah nangni'n kei namunutunjei, halli aphakhat suoa nangni'n kei namunook ningte, ‘Ajarchu kei'n Kapa diang kasisik eii.’ ");
INSERT INTO kfw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Aphakhat-ah’ itihi ang tiname? Ama'n angjarra itime eini'n jetmakmi!” ");
INSERT INTO kfw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Inmani'n amadiang inrakelzoot tihi Jisu'n aleijet, khawa jarra ama'n inmani diang aleiti, “Kei ileiti, ‘Aphakhat-ah nangni'n kei namunutunjei, halli aphakhat suoa nangni'n kei ningnamu nooksik eii.’ Hiwahi emak abe nangni'n khatli inkhat diang ning-inkel? ");
INSERT INTO kfw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kei'n nangnidiang inthiangnga kanati: nangni'n chapningte khat-um inwai ningte, takkha manmasituol inchu aroksik eii; nangni ningmalung kapoong kha ning-esik eii, takkha nangni poongna kha hoina hong-esik eii. ");
INSERT INTO kfw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Numeisa khan nai aneisitiang apoong, ajarchu ama phakha aheitungjei; takkha nai aneisuopha khanchu, akapoong kha amaniljei, ajarchu manmasituolla naikha injuoneijei tia arok. ");
INSERT INTO kfw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Khawa angnga tuun nangnidiang akapoong kha aom, takkha nangni'n kei ningnamu nooksik eii halli nangni'n ningmalungnga ningroksik eii, halli tuteii inkhat innum nangni irokkha nakasut theinunu.” ");
INSERT INTO kfw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Khawa nikhuoni khan nangni'n kei kadiang iteii naninutun. Kei'n nangnidiang inthiangnga kanati: kei karamingnga Kapa diang ning-ini rakip kha, ama'n anapesik eii. ");
INSERT INTO kfw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tuun katungchu nangni'n kei karamingnga iteii nanimakchu; nangni ratharok sipnasik-ah, niru, nangni'n muningte. ");
INSERT INTO kfw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kei'n minkhina chongnga nangnidiang kaleiril; takkha kei'n nangnidiang minkhina chongnga elekleiya takkha Pa Pathian jarra nangnidiang inlarra karilnasik aphakha aheiwajei. ");
INSERT INTO kfw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Khawa nikhuoni khan nangni'n kei karamingnga nani ningte; takkha kei'n nangni rathuulla Kapadiang nikate timong, ");
INSERT INTO kfw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ajarchu Kapa apumtak in nangnikha anaminriang, ajarchu nangni'n keikha ningna minriang khat-um keihi Pathian makheiya kijuo eii tia ningna-ngamna. ");
INSERT INTO kfw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kei Kapa diangnga inphut manmasituolla kijuo kha eii; inlet-ah, kei manmasituol mathaankata khat-um Kapa diang kasiritsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Asiamruoi ngai'n amadiang inleiti, “Tuunchu nang in minkhina chongnga elekleiya inthiangnga narillar jei. ");
INSERT INTO kfw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tuunchu nang in angrakip najetwiak, khat-um tuteii innum nangdiang kanarakel sik-ah arei ommakjei tihi keini'n kinjetjei; hiwa hi'n ajar eya nang Pathian diang makheiya nijuo eii tia keini'n kin-ngamnajei.” ");
INSERT INTO kfw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisu'n inmanidiang aleimasang, “Tuunchu nangni'n ningngamna jeibo? ");
INSERT INTO kfw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Enru, apha kha aheiwajei, tuun aheiwajei, nangni'n inchekchai ningta, halli katheinuoa nada ningta nangni rakip in ning-inn ning-inn tiang ningsisik eii; takkha kei katheinuoa emong, ajarchu Kapa keile aom. ");
INSERT INTO kfw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kei diangnga inphut akahoi akadai ningmunasik, hiwahi kei'n nangnidiang kileiti kha ejei, manmasituol hinchu poongna raalna om; takkha chimaru, ajarchu kei'n manmasituol kha kamatorjei.” ");
INSERT INTO kfw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisu'n hiwa chong ngaihi arilsuo thengnga, ama'n marwaan tiang enna aleiti, “Pa Pathian, aphakha aheitungjei. Sapa'n nang kha anaminlur nasik, Nasapa diang lurna lianna kha petro. ");
INSERT INTO kfw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Miring rakip chungnga thomatorna ranak kha Pathian in Asapa diang apejei, halli amadiang ipejei mi rakip ngaidiang hektik kaboi ringna kha apeii. ");
INSERT INTO kfw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Inkhatbit ka eii akadik Pathian kha akajet, khat-um nang ijuotirpa Jisu Christa akajet kha eii hektik kaboi ringna. ");
INSERT INTO kfw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Manmasituolla nang lurna kha kei'n kamalarjei; nang in thosik chuon ninapekha kei'n kathosuojei. ");
INSERT INTO kfw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Manmasituol inboolmaklai kei'n nangle kineisuom lurna lianna kha, Pa Pathian tuun namaikuungnga keidiang napetro.” ");
INSERT INTO kfw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Manmasituol makheiya nang in keidiang ninapeii miring ngaidiang Kei'n naraming kha kamalarjei. Inmani nangta in ejei, halli nang in kei kadiang nanapeii. Inmani'n nang nachong kha injuijei. ");
INSERT INTO kfw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kei kadiang ninapeii rakip ngaikha nangdiang makheiya in-eii tihi tuunchu inmani'n injetjei; ");
INSERT INTO kfw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ajarchu kei kadiang ninapeii chong ngaikha kei'n inmani diang kapejei, halli inmani'n inkeiluut jei; inmani'n nangdiang makheiya kijuo eii tihi inthiangnga injetjei, halli keihi nang inajuotir eii tia inngamnajei.” ");
INSERT INTO kfw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Kei'n inmani sik-ah Pathian kanipi. Kei'n manmasituol sik-ah Pathian nipimong takkha nang in keidiang ninapeii ngaisik-ah Pathian kanipi, ajarchu inmani ngaihi nangta in eii. ");
INSERT INTO kfw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kei kata rakip nangta eii, khat-um nangta rakip kei kata eii, halli kei lurna lianna kha inmani diangnga inphut inlar. ");
INSERT INTO kfw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Halli tuunchu kei manmasituolla ommongjei, kei'n nangdiang kahongjei, takkha inmani chu manmasituolla inlaom. Inthiang Pa Pathian! eini inkhatbit ni-eii angnga inmani-um in-enasik keidiang ninaleipeii inmani ngaihi nang naramingnga daro. ");
INSERT INTO kfw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kei'n inmani le kaom suomlai, kei'n nang naramingnga inmani kha kada; Pathian chong inthiang kha huui tungnasik, nang in keidiang ninapeii ngaikha kei'n kakeiruoichak, khat-um tuteii-um mangmu takkha kamangsik sapa khabit eii. ");
INSERT INTO kfw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Takkha tuunchu kei nangdiang kahongjei; kei rokna kha inmani chungnga huui tungnasik kei'n hiwahi manmasituolla karil. ");
INSERT INTO kfw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kei'n nang nachong kha inmanidiang kapesuojei; halli manmasituol khan inmani kha amatir, ajarchu kei'n manmasituol mi ki-emak angnga inmani kha manmasituol mi emu. ");
INSERT INTO kfw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Inmani ngaikha nang in manmasituol makheiya keisuonasik kei'n nimong, takkha nang in inmani ngaikha Akathamakpa makheiya sannasik-ah kani. ");
INSERT INTO kfw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kei'n manmasituol mi ki-emak angnga, inmani-um manmasituol mi emu. ");
INSERT INTO kfw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Akadik khan inmani kha minthiangro; nang nachong chu akadik kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nang in kei manmasituolla ninajuotir angnga, kei'n inmani ngaikha manmasituolla katir. ");
INSERT INTO kfw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Inmani-um kadik-ah inpesuok nasik, Kei kapum takhi inmani sik-ah nang nadiang ka-inpesuok.” ");
INSERT INTO kfw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kei'n inmani ngai sikbit Pathian diang nimong, takkha inmani chongril makheiya keidiang kangamna inmani ngaisik-um Pathian diang kani. ");
INSERT INTO kfw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Pa Pathian! nang in keidiang niom, khat-um kei'n nangdiang kiom angnga, inmani'n inkhatbit in-enasik khat-um manmasituol khan keihi nang inajuotir eii tia inna-ngamnasik inmani ngai-um einidiang inomnasik tia kinani eii. ");
INSERT INTO kfw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eini inkhatbit ni-eii angnga inmani-um inkhatbit in-enasik-ah keidiang ninapeii lurna lianna kha kei'n inmanidiang kapejei. ");
INSERT INTO kfw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kei'n inmanidiang kaom halli nang in keidiang naom. Inmani-um inkhatbit etheinasik, khat-um manmasituolla keihi nang inajuotir eii, halli inmani ngai-um nang in kei ninaminriang angnga inmani kha naminriang tihi manmasituol in jetrasu.” ");
INSERT INTO kfw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Pa Pathian! nang in keidiang ninapeii ngaikha, kei omnakhan inmani-um keile kin-om suomzoot, ajarchu nang in keidiang ninapeii kei lurna lianna kha inmani innum murasu, ajarchu manmasituol injir ma-ah nang in kei kha nanaminriang. ");
INSERT INTO kfw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Akadik Pa Pathian, manmasituol in nangkha najetmak, takkha kei inchu nangkha kanajetjei; halli inmani ngai'n keihi nang inajuotir eii tia innajetjei. ");
INSERT INTO kfw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nang in keidiang ninaminriang kha inmani diang-um omnasik, halli kei-um inmanidiang kaom nasik, Kei'n naraming kha inmanidiang kaminjet, khat-um kei'n kalaminjetsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisu'n Pathian anisuo thengnga, ama'n asiamruoi ngai khale Kidron tuiwakuok inrakaanna inleisi. Khawakhan rahuon inkhat aleiom halli Jisu khat-um asiamruoi ngai'n rahuon khan inleiluut. ");
INSERT INTO kfw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jisu kajuorsipa Judas innum amunkha aleijet; ajarchu Jisu'n asiamruoi ngai khale khawa munkhan inlei inmujol. ");
INSERT INTO kfw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas in Rome raalmi rahooi khat-um Thiampu kalian ngaili Pharisee ngai iheitir Biak-inn kangaak mi ngai khale sariakmei, meiser khat-um chemli thal inchoiya rahuon khan inleisi. ");
INSERT INTO kfw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisu'n ama chungnga akasuoksik rakip kha ijet khale inruoiya, ama'n aheisuok-ah inmani ngaidiang aleiti, “Tume nangni'n ning-entok?” ");
INSERT INTO kfw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Nazareth Jisu,” Inmani'n ama diang inleimasang. Jisu'n inmanidiang aleiti, “Kei ama kha ka eii.” Ama kajuorpa Judas kha inmani ngaikhale khawakhan aleingir. ");
INSERT INTO kfw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisu'n inmanidiang “Kei ama kha ka eii,” aleitipi phakhan, inmani ngaikha nuktiang inkirra khat-um neipilla inleipur. ");
INSERT INTO kfw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jisu'n inlet-ah inmanidiang aleirakel, “Tume nangni'n ning-entok?” “Nazareth Jisu,” kha eii inmani'n inleiti. ");
INSERT INTO kfw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisu'n aleimasang, “Kei'n nangnidiang amakha kei ka-eii katijei.” “Nangni'n kei ningna entok e-inchu, hiwa leiilaak mi ngaihi sitarasu.” ");
INSERT INTO kfw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“Nang in kei kadiang ninapeii ngaihi kei'n tuteii inkhat-um minmangmong,” ileiti chongkha huui hongtungnasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Chem kachoi Simon Peter in achem kha akeisuoli Thiampu Kaliankhetpa suok inkhat achangtiang kuorkha atuktanpi. Suokpa ramingkha Malchus inti. ");
INSERT INTO kfw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisu'n Peter diang aleiti, “Nachem kha akok suungnga thunro; Pa Pathian in keidiang innapejei poongna rabingkha kei'n inmak ningngabe?” ");
INSERT INTO kfw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Rome raalmi le inmani raallu kakeipa khat-um Jihudi kalok kalian ngai'n Jisu kha insurra inleikhuop. ");
INSERT INTO kfw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mansakhet-ah Anna diang inleiruoi; ajarchu ama kha khawa kumma Thiampu Kaliankhet ka eii Caiaphas tarpu alei-eii. ");
INSERT INTO kfw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas kha eii Jihudi thomatorna ranak kanei ngaidiang miring inkhat in mi rakip sik-ah akathi sik hi athawiai tia akaleiminchu. ");
INSERT INTO kfw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter li siamruoi inkhat in Jisu kha inleijui. Hiwa siamruoipa hichu Thiampu kaliankhetpa le inlei-injet jarra ama khachu Thiampu kaliankhetpa omna inn tuollaidung katung Jisu le inruoiya aleiluut, ");
INSERT INTO kfw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","takkha Peter chu kot kuungnga aleingir. Siamruoi inkhatpa khan inlet-ah tuol aheisuok rit-ah khat-um kot kangaak numeisanu diang inrilpuiya Peter kha-um aleikeiluut. ");
INSERT INTO kfw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kot kangaaknu khan Peter diang aleiti, “Nang-um hiwa miringpa siamruoi inkhat emakchebe?” “Emong, kei emong,” tia Peter in aleimasang. ");
INSERT INTO kfw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Suokngai khat-um inn kangaak raalmi ngai'n aleidaipi jarra meiholmei inleitho, halli inmani ngai'n inngirra mei inleioot. Peter um inmani ngaile a-ngirra mei aleioot. ");
INSERT INTO kfw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Thiampu Kaliankhetpa khan Jisu diang ama siamruoi ngai khat-um ama iminchu jarra aleirakel. ");
INSERT INTO kfw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisu'n amadiang aleimasang, “Kei'n manmasituol diang inlarra kariljei; Jihudi ngai rakip honginchunna Synagogue-ah khat-um Biak-inna kei'n kaminchujol. Kei'n ruuk-ah iteii rilmong. ");
INSERT INTO kfw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Angsik-ah nang in keidiang ninarakelme? kei iril karangai inmani ngaidiang rakelro, kei'n angme inmanidiang kileiril; kei ileiril kha inmani ngai'n injet.” ");
INSERT INTO kfw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisu'n hiwa atisuo phakhan, Ngirra kaom raalmi inkhat in Jisu kha aleikabeella aleiti, “Thiampu Kaliankhet diang hintho-ah namasangsik suok-abe?” ");
INSERT INTO kfw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisu'n amadiang aleimasang, “Kei'n kadikmak kaleiril inchu, kadikmak nakha heitiro; takkha kei'n akadikkha kaleiril inchu, angjarra kei ninawuokme?” ");
INSERT INTO kfw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anna in Jisu kha inkhitpumma Thiampu Kaliankhet Caiaphas diang aleithak. ");
INSERT INTO kfw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Peter kha a-ngirra mei oot-ah alaleiom. Inmani ngai'n amadiang inleiti, “Nang-um ama siamruoi inkhat emakchebe?” Peter in zootmak-ah aleiti, “Kei emong.” ");
INSERT INTO kfw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Peter in akuor ituktanpipa unai kasuok Thiampu Kaliankhetpa suok inkhat in aleirakel, “Kei'n nang amale rahuon suungnga kinamu emak abe?” ");
INSERT INTO kfw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter in woikhat inlet-ah maleisei aleiril; halli khawapha takkhan arkhong kha ahongkhuong. ");
INSERT INTO kfw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Halli inmani'n Jisu kha ziingtiang ma-ah Caiaphas inn makheiya waikaroonpa omna munkhan inleiruoi. Inmani Sinadan dungjuiya inlei inthiangzoot jarra khat-um Rakaanna Kahoi bubak thanasik, inmani ngaichu waikaroonpa omna munkhan leiluutmu. ");
INSERT INTO kfw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Khantia Pilate in inmani diang aheisuok-ah aleirakel, “Nangni'n hiwa miringpa chungnga ang noonkuung omma ningheiruoime?” ");
INSERT INTO kfw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Inmani'n amadiang inleimasang, “Hiwa miringpa in akathamak aleithomak inchu, keini'n amahi nang nadiang heiruoinunung.” ");
INSERT INTO kfw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate in inmani diang aleiti, “Nangni'n amahi ruoitaru halli nangni Sinadan dungjuiya ama chungnga chong tanru.” Jihudi ngai'n amadiang inleiti, “Sinadan khan miring inkhattak thatsik itihi chamak.” ");
INSERT INTO kfw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Hiwahi Jisu'n ang omchanna athisikme tia ileirilsuok chongkha huui tungnasik eii. ");
INSERT INTO kfw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate in inlet-ah aomna munkhan aluut-ah Jisu kha akoiya, “Nang Jihudi ngai Reng kha na ebe?” tia aleirakel. ");
INSERT INTO kfw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisu'n aleimasang, “Nang napum tak-in hiwahi nitibe, emakli miring leiilaak in kei jarra nangdiang innatipibe?” ");
INSERT INTO kfw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate in aleimasang, “Kei Jihudi ka eyabe? Nang nami ngai tak-in khat-um Thiampu kalian ngai'n nanghi kei kadiang innajuopeii; nang in angme nithopijei?” ");
INSERT INTO kfw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisu'n aleimasang, “Kei rengramchu hiwa manmasituol ta emak; kei rengram hi hiwa manmasituol ta alei-engai suok inchu, Jihudi ngai kutchungnga kei innapemak nasik, kei kanuk kajui ngai'n raal indeisik eii; takkha kei rengramchu hiwa manmasituol hin emak.” ");
INSERT INTO kfw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate in amadiang aleiti, “Enchu nang reng na-ebe?” Jisu'n aleimasang, “Nang in nati khachu kei reng ka eii. Hiwa sik-ah kei innajuonei, halli hiwa akadik hi akarilsik jarra kei manmasituolla kajuo. Akadik miseng in kei kachong injui.” ");
INSERT INTO kfw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate in amadiang aleirakel, “Angkeme akadik?” Hiwa atisuo thengnga, ama'n Jihudi ngaidiang inlet-ah aheisuok-ah aleiti, “Kei'n ama dikmakna iteii mumong. ");
INSERT INTO kfw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Takkha nangni inroonna Dan ningnei khachu Rakaanna Kahoi racham kei'n miring inkhat nangni sik-ah kamasuosik eii; kei'n nangni sik-ah Jihudi ngai Rengpa hi kimasuo ningmanuombe?” ");
INSERT INTO kfw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Inmani ngai'n inkheek-ah inleiti “Hiwa miringpa emak, takkha Barabbas kinmanuom.” (Barabbas chu inruup alei eii.) ");
INSERT INTO kfw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Halli Pilate in Jisu kha aruoiya aleiminwuok. ");
INSERT INTO kfw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Halli raalmi ngai'n raling lukhu inphanna ama luwa inleiminkhu, halli purple puon inchuol inleiminsil; ");
INSERT INTO kfw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","inmani'n amadiang inhongnga “Jihudi ngai Rengpa kha ringkhuo kasei erase!” intia inmani'n ama kha inleikabeel. ");
INSERT INTO kfw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate in inlet-ah aheisuok-ah inmani diang aleiti, “Enru, Kei'n amahi nangnidiang kiheiruoisuok ejei, ajarchu kei'n ama chungnga adikmakna iteii mumong tihi nangni'n ningjetnasik.” ");
INSERT INTO kfw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Khawa jarra Jisu'n raling lukhu inkhu-ah khat-um purple puon inchuol kha inluk-ah aheisuok. Pilate in inmani diang aleiti, “Miring pahi hin omjei!” ");
INSERT INTO kfw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Thiampu kalian ngai khat-um Biak-inn kangaak mi ngai'n Jisu Inleimu phakhan, inmani'n, “Cross-ah makai inlang thattaru! cross-ah makai inlang thattaru!” intia inleikheek. Pilate in inmani diang aleiti, “Nangni'n amahi ruoi-inlang halli cross-ah hongthattaru, ajarchu kei'n ama adikmakna mumong.” ");
INSERT INTO kfw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jihudi ngai'n amadiang inleimasang, “Keini sinadan om, halli khawa sinadan dungjuiya amahi athisik suok, ajarchu apum tak-in Pathian Sapa in-eii.” ");
INSERT INTO kfw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilate in hiwa chonghi aleijet phakhan, ama'n kheella aleichi. ");
INSERT INTO kfw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pilate in inlet-ah aomna munkhan aluut-ah Jisu diang aleiti, “Nang humakheiya nijuome?” Takkha Jisu'n leimasangmak. ");
INSERT INTO kfw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate in amadiang aleiti, “Nang in keidiang rilnutinbe? Kei'n nang namasuo matorna khat-um cross-ah nathatnasik ranak kanei itihi nang jetmakchebe?” ");
INSERT INTO kfw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisu'n aleimasang, “Chungtiang makheiya nang nadiang najuopemak inchu nang in kei kachungnga iteii ranak neinutin. Nangdiang kei najuokapeii ama kha kheella amanu alok.” ");
INSERT INTO kfw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hiwahi Pilate in ajetpha khan, ama'n Jisu masuonasik lam alei-entok, takkha Jihudi ngai'n inkheek-ah inleiti, “Nang in hiwa miringpa hi namasuo inchu, nang Caesar sappui emakche; apumtak reng in-eii mi rakip kha Caesar kazootmak in-eii.” ");
INSERT INTO kfw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilate in hiwa chongngaihi ajet phakhan, ama'n Jisu kha aheikeisuo halli chongtanna mun Pavement inti Lung chungkhan alei in-ong, Hebrew chongnga, khawa munkha Gabbatha inti. ");
INSERT INTO kfw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Rakaanna kahoi sik-ah minsuukna nikhuo; kani inding phakhan, Pilate in Jihudi ngaidiang aleiti, “Enru nangni rengpa!” ");
INSERT INTO kfw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Inmani'n “Thattro! ama kha thattro! Cross-ah makai inlang thattaro!” intia inleikheek. Pilate in inmanidiang aleirakel, “Nangni rengpa hi kei'n cross-ah thatning ngabe?” Thiampu kalian ngai'n inleimasang, “Caesar elekleiya keini reng neimung.” ");
INSERT INTO kfw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Khawa jarra Pilate in Jisu kha cross-ah thatsik-ah inmani diang aleipeii. ");
INSERT INTO kfw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Khawa jarra inmani'n Jisu kha inleiruoi, halli Jisu'n ama cross araput-ah Hebrew chongnga Golgotha inti Lukiar reiina muntiang aleisi. ");
INSERT INTO kfw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Khawa khan inmani'n Jisu kha aleiilaak miring innile inruoiya aweitiang khat-um achangtiang inmakaiya inleithat. ");
INSERT INTO kfw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate in “Nazareth Jisu, Jihudi ngai Reng,” tia jetna inkhat aleimajia, halli cross chungnga aleitar. ");
INSERT INTO kfw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jihudi katamtak in hiwahi inleiteel, ajarchu Jisu cross-ah inmakaili inthatna munkha khuopui koolla alei eii; halli jetna kha Hebrew, Latin khat-um Greek chongnga lei-injia. ");
INSERT INTO kfw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jihudi Thiampu kalian ngai'n Pilate diang, “ ‘Jihudi ngai Reng, tia majia maro,’ takkha ‘Hiwa mipa in kei Jihudi ngai Reng ka eii aleiti tia namajiapiro inleiti.’ ” ");
INSERT INTO kfw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate in aleimasang, “Kei'n kileimajia kha kimajia ejei.” ");
INSERT INTO kfw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Raalmi ngai'n Jisu kha cross-ah inthatsuo phakhan inmani'n Jisu puondiar kha raalmi ngai'n inchang thanasik lekmili inleiminsuok, halli asongkool kha-um inleilei. Takkha asongkool kha kathuilam omleiya inkhoong alei-eii. ");
INSERT INTO kfw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Khawa jarra inmani'n inkhatli khatdiang inlei inti, “Eini'n kathermui, takkha tu changsikme tikha eini'n rawaan enrui.” Hiwahi Pathian chong huui tungnasik kha eii. “Kei puondiar kha inmani'n in-insem halli kei kasongkool sik-ah inmani'n rawaan in-en.” Hiwahi raalmi ngai'n inleitho. ");
INSERT INTO kfw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisu cross koolla, anu, anu nainu, Clopas numei Mary, halli Mary Magdalene ngai'n inngirra inleiom. ");
INSERT INTO kfw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisu'n anu khat-um iminriang asiamruoi khan akoolla inngirra inom amupha khan, Jisu'n anudiang aleiti, “Numeisa, ama hi nasapa eii.” ");
INSERT INTO kfw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Halli asiamruoi padiang aleiti, “Ama hi nanu eii.” Khawapha makheiya numeisanu kha siamruoi khan aruoiya inntiang sipuijei. ");
INSERT INTO kfw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hiwa thengnga Jisu'n chuon rakip hekjei ti ijetle inruoiya, Pathian chong huui tungnasik “Kei katuiraal” aleiti. ");
INSERT INTO kfw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Theibomju kathur kasipchei kheeng inkhat khawa khan aleiom; halli inmani'n kathur theibomju kha tuipompuon khan innoomma khuoichu ramol morra inkathilla ama murra inhongsoon. ");
INSERT INTO kfw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisu'n akathur theibomju kha insuoli “Ahekjei!” aleiti. Khawa suoli Jisu'n ariing thep-ah athijei. ");
INSERT INTO kfw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Insuukna nikhuo eyarra, sernikhuo (Sabbath) ni mikaluong ngaikha cross chungnga kaiya ommaknasik (Sabbath inthiang nikhuo eyarra), Jihudi ngai'n inkeii ngaikha zeemkhiakli, choinasik Pilate diang injuoni. ");
INSERT INTO kfw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Khawa jarra raalmi ngai'n inheiwali Jisu le inmakaisuom miring inni ngai keiikha inleizeemkhiak. ");
INSERT INTO kfw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Takkha inmani'n Jisu khachu aleithisuo inmupha khan, inmani'n akeii ngaikha leizeemkhiakmu. ");
INSERT INTO kfw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Takkha raalmi ngai karra miring inkhat in kaseiya Jisu diapnei kha aleisun, halli khawapha takkhan thisen khat-um tui ajuoluong. ");
INSERT INTO kfw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nangni innum ngamna ningneinasik, akamujei ama khan sakhi eya arilsuok. Ama'n kadikkha aril, halli irilkha adik tia ama'n ajet. ");
INSERT INTO kfw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“Ama ruzaang inkhat-um zeemkhiaknunu” iti Pathian chongkha huui tungnasik hiwa ngaihi aleisuok. ");
INSERT INTO kfw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Halli Pathian chong munkhat in ati, “Kaseiya insun ama kha inmani'n in-ensik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hiwa thengnga Arimathea makheiya Joseph, Jihudi ngai achijarra ruuk-ah Jisu siamruoi ka-eii ama'n Pilate diang Jisu kaluong kha napero tia aleini, halli Pilate in azootpiya aleipeii. Khawa jarra ama'n aheiwali Jisu kaluong kha aleilei. ");
INSERT INTO kfw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Matiang Jisu inmupui sik-ah zaanchimma aleikahong Nicodemus um Joseph le inruoiya arim kahoi Myrrh li Aloes inchun pound rajakhat dam karik achoiya aleihong. ");
INSERT INTO kfw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inmani inni'n Jisu kaluong kha inleiya halli Jihudi ngai inreiina dungjuiya arim kahoi sariak le inruoiya puon kaneemma inleikatuom. ");
INSERT INTO kfw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisu cross-ah inthatna munkhan rahuon inkhat aleiom, halli rahuon suungkhan tuteii-um inlareiinamak thaan katharkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jihudi ngai insuukna nikhuo ejarra, halli thaan kha leinaitek jarra, inmani'n Jisu kaluong kha khawa munkhan inleireii. ");
INSERT INTO kfw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Khuoserni ziingtiang ma-ah Mary Magdalene in khuo warmaklai thaanna aleisi, halli thaankhar lungkha thaan makheiya lei-inkhai kha aleimu. ");
INSERT INTO kfw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Khawa jarra ama'n ataanna Simon Peter khat-um Jisu'n iminriang siamruoi inkhat padiang asiya aleiti, “Inmani'n Pumi kha thaan makheiya inleijei, halli inmani'n Pumi kha hunme inreii eini'n jetmakmijei.” ");
INSERT INTO kfw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Khawa jarra Peter li siamruoi inkhatpa khan thaantiang inleisi. ");
INSERT INTO kfw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Inmani inni'n inleitaansuom, takkha siamruoi inkhatpa in Peter kheella thaankha aleituungmasa; ");
INSERT INTO kfw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","halli a-ngirra alei enpha khan, ama'n khawa munna linen puon kaneem intha-ah kaomkha aleimu, takkha ama'n suungnga leiluutmak. ");
INSERT INTO kfw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Peter in anuk juiya ahongnga khat-um thaan suungnga ahongluut; halli linen puon kaneem intha-ah kaomkha ahongmu, ");
INSERT INTO kfw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","halli alu inkatuomna puonkha akaneem linen puon khale leiom suommu takkha puon bitkha inthep-ah aleiom. ");
INSERT INTO kfw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Halli thaan katungmasa siamruoi inkhatpa innum aleiluut-ah, ama'n amujei khat-um ngamnajei. ");
INSERT INTO kfw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Khawa phakhan inmani'n ama kha akathi makheiya inphut aringsik eii iti Pathian chongkha laleijetmu. ");
INSERT INTO kfw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Halli siamruoi ngaikha in-inn in-inn tiang inleikir. ");
INSERT INTO kfw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Takkha Mary chu thaan kot-ah a-ngirra alaleichap, ama'n achap pumma thaan suungnga alei-en; ");
INSERT INTO kfw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","halli ama'n akabang retruo katho marwaan tirton inni'n Jisu kaluong inreiina munna, luthuntiang inkhat halli kethuontiang inkhat in-ongnga kaomkha aleimu. ");
INSERT INTO kfw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Inmani'n inleiti, “Numeisa, angtia nichapme?” Numeisanu in inmani diang aleiti, “Inmani'n kei Pumi kha innachoideljei, halli ama kha inmani'n hun in-nareiipime tikha kei'n jetmong.” ");
INSERT INTO kfw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hiwa atili, numeisanu khan ahei-inlet, halli Jisu'n ngirra kaomkha aleimu, takkha numeisanu in Jisu eii tia leijetmak. ");
INSERT INTO kfw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisu'n amadiang aleiti, “Numeisa, angtia nang nichapme? Nang tume ni-entok?” Rahuon ka-ngaakpa lei-ete tia, numeisanu in amadiang aleiti, “Ocha, nang in ama kha naleilei inchu, ama kha hunme nireii keidiang natipiro, halli kei in ama kha leikate.” ");
INSERT INTO kfw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisu'n numeisanu diang aleiti, “Mary.” Mary in amadiang ahei-inlet-ah Hebrew chongnga aleiti, “Rabboni!” (hiwa tinachu Ocha tina eii). ");
INSERT INTO kfw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisu'n numeisanu diang aleiti, “Kei nakatook maro, ajarchu kei Kapa diang lakalmong; takkha kei ka-u kanai ngaidiang si inlang inmani diang juorilpiro, Kei'n Kapa khat-um ningpa, kei Pathian khat-um nangni Pathian diang kalakalsik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene in asiya siamruoi ngaidiang ajuorilpi, “Kei'n Pumi kha kamujei” halli ama'n hiwa ngaihi amadiang aleiti tia inmanidiang aleirilpi. ");
INSERT INTO kfw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hapta mansakhet nikhuo kholeitiang khan, siamruoi ngaikha Jihudi thomatorna ranak kanei mi ngaikha inleichi jarra inn inkharra inlei-intuup, Jisu'n aheiluut-ah inmani karra a-ngirra inmani diang aleiti, “Akadai kha nangnidiang omrase.” ");
INSERT INTO kfw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hiwa atisuoli atisuomak, akut khat-um adiapnei inmani diang aleiminmu. Halli Pumi inleimu phakhan asiamruoi ngaikhan inleirok. ");
INSERT INTO kfw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisu'n inmanidiang inlet-ah aleiti, “Akadai kha nangnidiang omrase. Pa Pathian in kei inajuotir angnga, kei innum nangni kinatir kha ejei.” ");
INSERT INTO kfw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Halli ama'n hiwahi atisuoli tisuomak, inmani diang phuk aseemma aleiti, “Ratha Inthiang kha neitru. ");
INSERT INTO kfw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nangni'n mi ngai manu kha ningra-ngaidam inchu, inmani ngaidam kamu in-ejei; nangni'n inmani manu ngaikha ningra-ngaidammak inchu, inmani kha ngaidam kalamumak kha in-eii.” ");
INSERT INTO kfw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Asiamruoi soomleini ngai karra miring inkhat, inphir intia inkoi Thomas kha Jisu aheiluutlai khan inmanile leiommak. ");
INSERT INTO kfw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Khantia siamruoi leiilaak ngai'n amadiang inleitipi, “Keini'n Pumi kha kinmujei.” Takkha ama'n inmanidiang aleiti, “Kei'n ama kut-ah juotpi inheemnabi kamumaklaiseng halli, akut-ah juotpi inheemna khurra kakutramol kasunluut-ah kakatook maklaiseng halli kaseiya insunna adiapnei khan kakut-ah kakatook maklaiseng, kei'n ngamnanuning.” ");
INSERT INTO kfw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Niriat suo-ah, ama siamruoi ngaikha inlet-ah innsuungnga inleiomrit, halli Thomas um inmanile aleiom. Innkhar ngaikha inleikhar takkha Jisu'n aheiluut-ah khat-um inmani ngai karra a-ngirra aleiti, “Akadai kha nangnidiang omrase.” ");
INSERT INTO kfw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Halli ama'n Thomas diang aleiti, “Nang nakutramol kha hin heisoonro, halli kakut ngaihi enro; nakutkhan hongkabaan inlang kei kadiapnei hin hongdaro. Inngamnamak kha ekhaimaro takkha ngamnataro.” ");
INSERT INTO kfw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas in amadiang aleimasang, “Kei Pumi khat-um Kei Pathian!” ");
INSERT INTO kfw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisu'n amadiang aleiti, “Kei nanamu jarra nana-ngamnajei. Mulekleiya kangamna mi ngaikha rawaan katha in-eii.” ");
INSERT INTO kfw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hiwa larik hin injiamak, Jisu'n inlak chuon angjet ama siamruoi ngai maikuungnga aleitho; ");
INSERT INTO kfw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Takkha nangni'n Jisu hi Messiah eii, Pathian Sapa eii, tia ningngamna sik-ah hiwa ngaisenghi inmajia kha eii, halli amadiang kangamna khan nangni ringna ningmusik eii. ");
INSERT INTO kfw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hiwa thengnga Jisu apumtak in siamruoi ngaidiang Tiberias tuipuiya woikhat inlet-ah alei-inlar; halli apumtak in hintho-ah alei-inlar. ");
INSERT INTO kfw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, inphir intia inkoipa Thomas, Galilee ramsuungnga kaom Cana makheiya Nathanael, Zebedee sangai, khat-um asiamruoi leiilaak innile inleiomsuom. ");
INSERT INTO kfw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter in inmanidiang aleiti, “Kei ngakasur sikate.” Inmani'n amadiang inleiti, “Keini um nangle kinsisuomsik eii.” Inmani'n inheisuok-ah rakuong suungnga inleiluut; takkha khawani zaan kha inmani'n iteii-um surmu. ");
INSERT INTO kfw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Khuo hongwarpha khanchu, Jisu'n tuipui khamma a-ngirra aleiom; takkha siamruoi ngai'n Jisu eii tia leijetmu. ");
INSERT INTO kfw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisu'n inmani diang aleiti, “Sapngai, nga ningsurbo?” “Surmung” tia inmani'n inleimasang. ");
INSERT INTO kfw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ama'n inmani diang aleiti, “Leen kha rakuong changtiang worru, halli nangni'n lekkhat surningte.” khawa jarra inmani'n leen kha inleiwor, halli tuunchu inmani'n leinuk maneiimu, ajarchu leenkha nga in aleisip. ");
INSERT INTO kfw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jisu'n iminriang siamruoi khan Peter diang aleiti “Pumi eii!” Simon Peter in Pumi ejei tia aleijet phakhan, apuondiar kha alei-inluk ajarchu puondiar kha alei-liik-ah leithomak, halli tuisuungnga alei-inchoomluut. ");
INSERT INTO kfw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Takkha siamruoi leiilaak ngaichu nga kasipchei leenkha inkeiya rakuongnga inheiwa, ajarchu tuikham makheiya ki rajani dam bit inlei-inlaak. ");
INSERT INTO kfw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Inmani'n tuikhamma inheitung phakhan, waipool lekkhat le meira-al chungnga nga inrouwa kaomkha inmani'n inleimu. ");
INSERT INTO kfw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisu'n inmani diang aleiti, “Tuntak-ah ningsur nga lekkhat heichoiru.” ");
INSERT INTO kfw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Khawa jarra Simon Peter in asiya leenkha tuikhamma aheinuksuok, nga kalok rajakhat le soomra-nga leithum inlei eii; akatamtak nga alei e-innum leenkha leichetmak. ");
INSERT INTO kfw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisu'n inmani diang aleiti, “Heiwa inlang ziingbu juobaktru.” Siamruoi tuteii innum “Nang tu na eme?” tia leirakelmu, ajarchu Pumi ejei tia inleijet. ");
INSERT INTO kfw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisu'n aheiwali waipool kha aleiya inmani diang aleipeii halli khale in-angrip-ah nga kha-um aleiya inmani diang aleipeii. ");
INSERT INTO kfw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hiwahi woithum huuina Jisu'n asiamruoi ngaidiang athiya inphut ahongringsuo thengnga inlar kha eii. ");
INSERT INTO kfw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Inmani'n inbaksuo phakhan, Jisu'n Simon Peter diang aleiti, “John sapa Simon, nang in hiwangai neek-ah kei nanaminriangbo?” Simon in amadiang aleiti, “Oh Pumi,” “Kanaminriang tihi nang in najet.” Jisu'n amadiang aleiti, “Kei keelngamteii ngai wairo.” ");
INSERT INTO kfw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisu'n amadiang woini huuina aleiti, “John sapa Simon, kei nanaminriangbo?” Simon in amadiang aleiti, “Oh Pumi,” “Kei'n nang kanaminriang tihi nang in najet.” Jisu'n amadiang aleiti, “Kei keelngam ngai khaalro.” ");
INSERT INTO kfw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisu'n woithum huuina amadiang aleiti, “John sapa Simon, Kei nanaminriangbo?” Jisu'n woithum “Kei nanaminriangbo?” tia aleirakel jarra Peter in amalungnga aleipoong. Simon in amadiang aleiti, “Pumi, nang in angrakip najet; kei'n nang kanaminriang tihi nang in najet.” Jisu'n amadiang aleiti, “Kei keelngam ngai wairo. ");
INSERT INTO kfw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kei'n inthiangnga nangdiang kanati, naipang na-elai, natheinuoa nasinazoot lamma nasi; takkha upa nahong epha khan, nang in nakut nathaangsik eii halli miring inkhat in nakhoong nakhitpita nasizoot makna-ah anaruoisik eii.” ");
INSERT INTO kfw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ama'n Peter angthiya thili Pathian kul ra-ang aminlursikme tijarra hiwahi iril eii. Halli hiwa thengnga Jisu'n amadiang aleiti “Kei kanuk najuiro.” ");
INSERT INTO kfw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter in nuk hei-inlet phakhan, Jisu'n iminriang siamruoipa khan inmani nuk iheijuikha aleimu, zaanbu inbaklai Jisu roop-ah inngaiya, “Pumi, tume nang kanajuorsik akatipa kha eii.” ");
INSERT INTO kfw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter in ama kha amuwa Jisu diang aleiti, “Pumi, hiwa mipa hileii?” ");
INSERT INTO kfw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisu'n amadiang aleiti, “Kei'n kajuokir maklaiseng ama'n aringsik kei'n kamanuom ngai souk-inle, khawa khan nangdiang ang eyame? Nangchu kanukkha najuiro!” ");
INSERT INTO kfw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Khawa khan ajar eya siamruoipa kha thinunijei iti chonghi Jisu nukkajui ngaidiang aleitung; Jisu inchu nang thinutin tia amadiang leitimak, takkha, “Kei'n kajuokir maklaiseng ama'n aringsik kamanuom ngai suok-inle, khawa khan nangdiang ang eyame?” iti eii. ");
INSERT INTO kfw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hiwa siamruoi hi eii hiwa ngai jarra sakhi kapeii, khat-um hiwa ngai kamajia; halli eini'n ama sakhi hi adik tia nijet. ");
INSERT INTO kfw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hiwa ngai ka-emak aleiilaak akatamtak Jisu'n ileitho angjet om; ileitho rakip ngaikha inmajia inchu, manmasituol pumpui innum inmajiasik larik ngaikha kengnuni tia kei'n kangaidon. Amen.");
INSERT INTO kfw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","E, minriang kaom Theophilus: Kei'n kimajia ma-insa larik khan, Jisu'n achuon phut makheiya itho khat-um iminchu rakip jarra, ");
INSERT INTO kfw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","amakha marwaantiang ikal nikhuo katung matiangnga Ratha Inthiang ranak ah ama ikadang tirton ngaidiang iminchu ngaikha kamajia jei. ");
INSERT INTO kfw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ajarchu athisuo nuk, aringnookjei tihi inthiangtak ah jetnasik nisoom mili tirton ngaidiang pha katamtak inlaar kha inmani'n inleimu; halli ama'n inmanile inruoiya Pathian Rengram jarra alei-inbiakpui. ");
INSERT INTO kfw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Halli inmanile ininchun lai, inmani diang hiwa chongpehi aleipeii, “Jerusalem mathaan maru, takkha kapa'n chong-inkhit ah kanapese iti kutchoi kha, nangni diangnga kei'n kiril kha leingaakru; ");
INSERT INTO kfw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ajarchu John in tuiya baptize atho, takkha nangnichu nikhuo lekkhat suo ah Ratha Inthiangnga baptize anathosik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Khawa jarra tirton ngai'n Jisu le ininmupha, amadiang inheirakel, “Pumi, hiwa phahin Israel ngai Rengram kha nang in napekirnook sikbe?” ");
INSERT INTO kfw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jisu'n inmani diang ati, “Kapa amatak ranak ah ida apha emakli akum-atha kha angtik ka-esikme nangni jetsik emak. ");
INSERT INTO kfw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Takkha Ratha Inthiang in nangni chungnga ajuochum phakhan, nangni'n ranak ah sipningte; halli nangni'n Jerusalemma, Judea khat-um Samaria, halli manmasituol ahekna katuungnga keisik sakhi ning-esik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Hiwa rakip arilsuoli, inmani'n ama in-enna in-omlai, amakha marwaantiang akaljei, khawasuoa suumphai inkhat in amakha inmani mit-enna inphut amalia jei. ");
INSERT INTO kfw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Inmani'n Jisu marwaan laitiang ikal kha inmit ah in-enna in-omlai, puondiar kabang kasil mi inni jetlei-theileiya inmani koolla inleingir; ");
INSERT INTO kfw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","halli inmani'n inti, “Galilee mi-ngai, nangni angsikme marwaantiang ning-enna ningngir? Nangni diangnga inphut marwaanna kakal Jisu hi ningmu angnga ama lajuonooksik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Khawasuo tirton ngai'n khuopui makheiya mile herkhat kapuo kalaak Olive ching makheiya Jerusalem khan inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Halli inmani'n khopui inluutpha, Peter le John, James khat-um Andrew, Philip le Thomas, Bartholomew khat-um Matthew, Alphaeus sapa James, Zealot inti Simon halli James sapa Judas inmani leiomna chung inn khan inleikaljei. ");
INSERT INTO kfw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Inmani'n nupui ngaile Jisu anu Mary khat-um ama nai ngaile akanisik ah inlei-intuup jol. ");
INSERT INTO kfw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Halli nikhuo lekkhat thengsuoli ka-ngamna mi ngai inraja ah rajakhatle soomni daam inlei-intuup ah, chongkarilsik Peter aleingir. ");
INSERT INTO kfw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“E ka-u ka-nai ngai,” Jisu kasur inmani lamkakei Judas jarra David mursuoa Ratha Inthiang in matiang ileiminril “Pathian chongkha hongkatung sik-eii. ");
INSERT INTO kfw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas kha eini karra inkhat eii, ajarchu eini chuon suungnga ama'n chan inkhat amusik ah inkadangsa inkhat eii.” ");
INSERT INTO kfw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Judas ama'n achuontho kathamak khanna imu sial khan lei inkhat aracho, halli alu nuoitiang makaiya, awon cheiikhoiya asuung-aril rakip asuok suo ah athijei. ");
INSERT INTO kfw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalemma kaom mirakip in hiwa jarhi inleijetjei, hiwa jarra lei kha inmani chongnga Akeldama, tichu “Thisenlei” intia inleiphuo.) ");
INSERT INTO kfw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Ajarchu Minpakla larik suungkhan hiwahi injia, ‘Ama innkha akaruok erase; khawakhan tu-inkhat um ommarasu.’ Hiwa hi-um alei-injia, ‘Ama chuonmun kha tuka-ang mi inkhat in luorase.’ ” ");
INSERT INTO kfw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Khawa jarra John in baptize thona achong rilni makheiya inphut Pumi Jisu'n eini diangnga inphut marwaantiang ikal nikhuo katung, eini karra Pumi Jisu'n asi-ahongnga alei-omlai lei-inruoipui mi-ngai karra inkhat einile inruoiya Pumi Jisu hongringna sakhi ana-epuisik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Khawa jarra inmani'n mi inni, Joseph intia inkoi Barsabbas, aphung Justus inti khat-um Matthias kha inleikadang. ");
INSERT INTO kfw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Halli inmani'n Pathian inniya, mirakip malung kajetpi, nang in nikadang inni ngai karra inkhat kha keinidiang namalarpiro, “Kinpumi, ");
INSERT INTO kfw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","asinasik munna kasijei Judas rathuulla tirton inkhat ah nachuon kathosik inmani inni ngai karra tume nikadang kha keinidiang naminmuro.” ");
INSERT INTO kfw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Inmani'n rasi in-enna rasi kha Matthias chungnga chuljei; halli amakha tirton soomleikhat ngai karra inthundeljei. ");
INSERT INTO kfw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecost nikhuo aheitung pha, ka-ngamna ngai rakip in khawa munkhat ah inlei-inchun. ");
INSERT INTO kfw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Halli khawakhan jetlei-theileiya thikaraang kangartak karaang rasa ka-ang inkhat lairalak tiangnga inphut ajuo raangnga, inmani in-ongna innkha pumsip aleisipjei. ");
INSERT INTO kfw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Halli mei ka-ang malei ngaikhan inmani karra akhoithenna inmani diang aleiminmu. Halli khanna kaom mi rakip diang aleikatook. ");
INSERT INTO kfw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Halli inmani rakip Ratha Inthiang in asip ah, Ratha khan inmani iminril dungjuiya chongleiilak karil inphutjei. ");
INSERT INTO kfw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Khat-um nuoipilchung ram rakip ah kaheiwa Pathian ka-ngamna kacheet Jihudi mi-ngai Jerusalemma inleiom. ");
INSERT INTO kfw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Inmani'n hiwa rasa injetpha, mipui katamtak inhei-inchunna inleingak, ajarchu inmani'n inril chongkha inchong inchongnga inrilla inleijet. ");
INSERT INTO kfw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","In-ngakle inruoiya inmani'n inti, “Enru, hiwa mi ngaihi Galilee mi ngaikha emuwabe! ");
INSERT INTO kfw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Halli angtho-thoa inmani irilhi eini'n niramchongtak ah eini rakip in nijetme? ");
INSERT INTO kfw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Einichu Parthia, Media, Elam; Mesopotamia, Judea, Cappadocia; Pontus khat-um Asia makheiya, ");
INSERT INTO kfw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia Pamphylia, hanna Egypt khat-um Cyrene koolla kaom Libya; Rome makheiya inphut kahong ");
INSERT INTO kfw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jihudi khat-um Zaatlop Jihudi heika ethar ngai, Crete, Arabia, inmani ngai rakip in nichongtak ah Pathian jarra ngak kaom kha inril. ");
INSERT INTO kfw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Inmani rakip in-ngakle inruoiya thodan jetmuwa, inmani inkhatli inkhat in-inti,” “Hiwahi angmejei?” ");
INSERT INTO kfw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lekkhat in in-innuipuili inti, “Hiwa mi-ngaihi juran-inrui in-eii!” ");
INSERT INTO kfw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peter in tirton soomleikhatle inruoiya angirra, rasa inringnga mipui diang karil aleiphut: “E, Jihudi mi ngai khat-um Jerusalemma kaom mi rakip, hiwahi nangni'n jetru, kachong hi rangairu halli hiwahi angtiname kei'n nangnidiang narilpi kate.” ");
INSERT INTO kfw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ajarchu nangni ingaidon angnga inmani ju-inrui emu; ajarchu ziingtiang phadan kuo alachullim. ");
INSERT INTO kfw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Takkha hiwahi Pathian chongkachoi Joel ileiril kha eii, ");
INSERT INTO kfw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Pathian in ati, ahekna nikhuoni hiwa ngaihi kei'n kathosik eii: Kei'n mi rakip chungnga Karatha kajuobunsik eii. halli nangni sanu sapa ngai'n kachong inrilsuoksik eii; nangni khangdoong mi ngai'n mangtalar muna inneisik eii, halli nangni upa ngai'n ramang inramangsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Han kasuoknu khat-um kasuokpa ngai chungnga, Kei'n khawa nikhuo ngaikhan Karatha kajuobunsik eii, halli inmani'n kachong inrilsuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Halli kei'n lairalak chungnga chuon-inlak khat-um nuoipil chung nuoiya chuon-inlak jetnasik; tichu, thisen, mei, khat-um meikhulom kamasuoksik eii. ");
INSERT INTO kfw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Akalok khat-um akapoi Pumi Nikhuo ajuomaklai, kani kha alaziingsik eii, tha kha thisenna ala-uolsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Halli tu e-innum Pumi raming kakoi rakip ngaikha asan minringsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“E Israel mi ngai, hiwa chong ngaihi rangairu!” Pathian in Nazareth Jisu diang chuon-inlak khat-um ngaksik kaom ngaikha nangni karra imintho khan amahi Pathian izoot mi eii ti nangni ningpumtak innum ningjetjei. ");
INSERT INTO kfw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jisu kha Pathian malungnga ingaidon khat-um matiangnga ijet dungjuiya anapeli khan, nangni'n manukaroon mi ngai kut chungnga ama kha cross ah ningmakhaiya ningthatjei. ");
INSERT INTO kfw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Takkha Pathian in amakha kathiya inphut aminringjei, thina poongraalna ah inphut amasuojei; ajarchu ama thina khan akhum matorsik emak. ");
INSERT INTO kfw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ajarchu David in ama jarra hin ati, Kei'n Pumi kha apha rakip ah kama-ah kamuchak; Ama kha kachangtiang aom, khawa jarra kei iteii poongna neinuning. ");
INSERT INTO kfw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Khawajarra kei kamalung atai, kachongril karok in asip. Halli Kei, kathi inmangthei ka-e-innum, hiwakheella ka-inngamna khan kei soong kamachumsik eii, ");
INSERT INTO kfw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ajarchu keihi nang in thina nuoipilchung hin namasuonutin; nang in nasuok malungkaluutpa kha poongna minmunutin. ");
INSERT INTO kfw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nang in keidiang ringna lamkha nanaminmu jei, halli nana-ompuina jarra keihi karok in anaminsipsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Kasappui ngai, nipu Reng David jarra inthiang tak ah kirilzoot khachu, ama athiya inphuumjei, takkha ama thaankha wini katung eini karra alaom.” ");
INSERT INTO kfw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ama Pathian chongkachoi inkhat alei eii, David phung suungnga Reng David ka-ang inkhat Reng kaminchang sik eii tia Pathian in ama diangnga chong-inkhitna ipekha aleijet. ");
INSERT INTO kfw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David in hiwahi matiang aleimua Messiah hongringna jarra arilsuok jei, Amahi thina nuoipilchung hin kalekjuonmu; apumkha thaan suungnga inmangnuni. ");
INSERT INTO kfw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jisu hi Pathian in thiya inphut aminringjei, halli hiwa kasuok rakip jarra eini sakhi ni eii. ");
INSERT INTO kfw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Khawa jarra ama Pathian changtiang kadomsaangnga omjei, halli Apa chong-inkhitnasa Ratha Inthiang kha aralaangjei, nangni'n tuunna ningmu ningjet ngaihi eii ama kutchoipeii kinchungnga inape kha. ");
INSERT INTO kfw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ajarchu David marwaan kakal emak; takkha ama'n aleiti, Pumi khan Kapumi diang aleiti, kachangtiang hin in-ongro ");
INSERT INTO kfw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Kei'n ninhalpui ngaikha naketouna nuoiya kada maklaiseng. ");
INSERT INTO kfw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Khawa jarra Israel miring rakip in, cross ah ningthat Jisu hi Pathian in Pumi khat-um Christa anamin-epijei tihi inthiangnga jetrasu!” ");
INSERT INTO kfw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Mi-ngai khan hiwa chong injetpha, inmani malung kha kaseiya insun angjei, halli Peter khat-um aleiilak tirton ngaidiang, “Ule-nai ngai, angme keini'n kithosik?” inheiti. ");
INSERT INTO kfw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter in inmani diang aleiti, “Ningmanu ngaikha ngaidamnasik Jisu Christa ramingnga nangni rakip in ningmalung thuulru halli Baptize thoru. Halli nangni'n Ratha inthiang kutchoi kha ralaang ningte. ");
INSERT INTO kfw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ajarchu Pathian chong-inkhitna hi, nangni le ningsa ngaisik khat-um eini Pumi Pathian in alakoisik akalaak ah kaom rakipsik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter in chong katamtak arilla inmani diang amasok ah ati, “Hiwa tuunna kathamak khangnga inphut nangni ningtheinuo ah intanru!” ");
INSERT INTO kfw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Inmani katamtak in achongril kha inngamna ah baptize inthojei, halli khawani khan miring lising inthum daam inmani diang inleiluut. ");
INSERT INTO kfw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Inmani'n tirton ngai diangnga inphut ininchuna khan inpha inminluut ah, ininchunna, baknale nina khan chan inleinei suomjei. ");
INSERT INTO kfw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tirton ngaikhan chuon-inlak khat-um ngak kaom katamtak inleitho, halli mi rakip chungnga akachi khan aleisip. ");
INSERT INTO kfw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Halli kangamna rakip in ininchunna, inphur rakip mipuita inmin-eya inleineiman. ");
INSERT INTO kfw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Inmani inneinaak khat-um inphur ngaikha injuorra inraya ah sial kha ama-ama neimanna kahunsik dungjuiya inlei-insem. ");
INSERT INTO kfw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inmani'n nisuo rakip Biak-inn khan malung khatbit ah ininchunna, in-inn in-inna karokle malung inthiangnga bubakna inleineisuom, ");
INSERT INTO kfw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Inmani'n Pathian inminpaak, halli miring rakip diangnga rawaan kha inrokpui, halli Pumi'n ringna kamu ngaikha nisuo ah inmani karra aleiminchunjei. ");
INSERT INTO kfw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Peter le John in nisuokhat kholeitiang ninasik phadan inthum chulpha, Biak-inn khan inleisi. ");
INSERT INTO kfw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Halli inneiya inphut akekakiak mi inkhat inhongruoiya Suongkot katha, inti munkhan Biak-inn hongkaluut mi rakip diangnga inphut nisuo ah sial kanisik ah inleida. ");
INSERT INTO kfw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ama'n Peter li John Biak-inn khan inhongluut amupha, angmekhat naperu tia akut adouwa aleini. ");
INSERT INTO kfw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter li John in amadiang kathatak ah in-enli, Peter in aleiti, “Keinidiang na-enro!” ");
INSERT INTO kfw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Khawa jarra angmekhat inmani diang ralaang jeikate tia, malungkaluut ah alei-en. ");
INSERT INTO kfw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Halli Peter in amadiang aleiti, “Kei soonna li dangka iteii neimong, takkha kineihi nangdiang napekate, Nazareth Jisu Christa ramingnga inthei-inlang siro!” ");
INSERT INTO kfw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Halli ama'n akut changtiang ma-ouwa akeitheijei, khawapha takkhan mipa akeii li akeii-artui kha ahongngarjei, ");
INSERT INTO kfw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","halli ama'n inchoomma akeiiya ngirjei, kasi-kahong aphut jei, halli inmanile inruoiya Biak-inn khan inluut ah Pathian inminpaak ah insi-inhongjei. ");
INSERT INTO kfw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Halli ama'n asi-ahongnga Pathian inminpaak kha khanna kaom mipui ngai'n inleimu, ");
INSERT INTO kfw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","inmani'n amahi eii Suongkot Katha inti biak-inn khan in-ongnga bukanipa ti injetpha, ama diangnga kasuok kha angmejei tia inmani rakip inleingak jei. ");
INSERT INTO kfw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mipa khan Peter li John mahuumma omlaikhan, Solomon Tuolngur, inti munkhan mi rakip in inngak ah inmani diang inhongtaanjei. ");
INSERT INTO kfw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter in mipui kha amupha, inmani diang ati, “E Israel mi ngai, angsikme nangni'n hiwahi ningngak,” halli katha ah ningna-en? keini'n hiwa mipahi keini ranak khat-um Pathian kacheet tak-ah kin-inngamna khan kinminsi eii tia ningngaidon be? ");
INSERT INTO kfw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac, khat-um Jacob Pathian khan, tichu eini nipi-nipu ngai Pathian in alur-alianna kha Asuokpa Jisu diang apejei; takkha nangni'n amakha achongkasi ngai kutchungnga ningleipesuok, halli Pilate in masuosik atisuo katung nangni'n Pilate maikuungnga leizootmakchu. ");
INSERT INTO kfw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Takkha nangni inchu mi inthiang khat-um mi katuun ama kha zootmakchu, mi kathat ama kha nangnisik ah Pilate diang masuonasik ningnijei, ");
INSERT INTO kfw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","halli nangni'n ringna kanapepa kha ningthatjei, takkha Pathian in thiya inphut aminringjei, hiwa jarra keini sakhi kin-eii. ");
INSERT INTO kfw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ama ramingnga ngamna ranak khan hiwa kekakiak mipa chungnga ranak ngarna kha apejei. Ama ramingnga ngamna jarra chuon intho kha ningmu ningjetjei; hiwahi Jisu diangnga ngamna khan ningraja maikuungnga amahi imindam ejei. ");
INSERT INTO kfw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Halli tuunchu, ule-nai ngai, nangni le ninglamkakei ngai innum ningleijetmak jarra, Jisu diang ningleitho eii ti kei'n kajet. ");
INSERT INTO kfw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pathian in matiang pha kasoot tak-ah inphut Pathian-chongkachoi rakip diangnga ileiminrilsa Christa kha lapoong-laraalsik eii; tikha hinthoa huui itung ejei. ");
INSERT INTO kfw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Khawa jarra malung thuulru, Pathian diang heikirru, khawakha ningtho inchu ama'n ningmanu ngaikha narangaidam pisik eii. ");
INSERT INTO kfw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Nangni sik-ah ikadang suojei Messiah kha tichu Pumi diangnga inphut Jisu ratha ngarnasik ajuotirsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pathian in matiangnga Pathian chongkachoi ngai ileiminril angnga, angrakip inboolthar maklaiseng ama kha marwaan chungnga aom cheisik eii. ");
INSERT INTO kfw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ajarchu Moses in aleiti, ‘Pumi ning-Pathian khan nangni sik-ah kei inajuotir angnga Pathian chongkachoi ningmi tak inkhat ajuotirsik eii,’ ama'n nangni diangnga itho iril rakip kha juiru. ");
INSERT INTO kfw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tu e-innum Pathian chongkachoipa chongril kajuimak mikha, Pathian mi-ngai karra inphut thenkhoita aminmangsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pathian chongkachoi rakip, Samuel makheiya inphut anuk ah kajuo ngaiseng in angme tuunlai pha katungnga kasuoksik rakip kha inleirilsuok jei. ");
INSERT INTO kfw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pathian chongkachoi ngai diangnga Pathian chong-inkhitna kha nangnisik kha eii, halli ningpi-ningpu ngai diangnga inphut chong-inkhitna khan nangni'n tum ningnei eii. Tichu Pathian in Abraham diang ati, ‘Ningtusuon-ningtesuon makheiya kei'n nuoipilchung miring rakip chungnga rawaan kapesik eii. ");
INSERT INTO kfw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Khawa jarra nangni rakip in ningthamakna lamma inphut ningheikirra, ningrawaan thanasik, Pathian in nangni diang ma-insakhet ah Asuokpa kha ajuotirjei.” ");
INSERT INTO kfw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter li John in mi ngaidiang chong inrillai, thiampu lekkhat, biak-inn kangaak lamkakei khat-um Sadducee ngai inleihong. ");
INSERT INTO kfw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ajarchu tirton inni ngaikhan mi ngaidiang Jisu thiya inphut ahongringjei, hiwahin akathi ngai inlaring nooksik eii ti inmalarra inminchu jarra inmalung inleiminhaang jei. ");
INSERT INTO kfw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Khawa jarra inmani'n tirton inni ngaikha insurra khuojuowar maklaiseng mikhumna khan inleida, ajarchu aphakha kholeitiang ejei. ");
INSERT INTO kfw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Takkha chongkajet katamkhat in ngamna inneijei; halli Pasal seng mi lising ranga intungjei. ");
INSERT INTO kfw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ziingkhuo awarli, Jihudi lamkakei ngaile uparup ngai khat-um Dan karu ngai Jerusalemma inlei-inchun, ");
INSERT INTO kfw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","halli Thiampu Kaliankhet Annas le Caiaphas, John, Alexander, khat-um aleiilak Thiampu Kaliankhet innsuung mi ngai-um inlei-intuup. ");
INSERT INTO kfw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Inmani'n tirton ngaikha inmaikuungnga inminngirli inheirakel, angranak ah emakli tu ramingnga nangni'n hiwahi ningthome? ");
INSERT INTO kfw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Khawapha Peter kha Ratha Inthiang in asip ah inmani diang ati, “E hiwa mi-ngai lamkakei ngai khat-um uparup ngai, ");
INSERT INTO kfw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Nangni'n awini hiwa akekakiak mipa chungnga akatha chuon kinthoa idam jarra keinidiang chong ninarakel inchu, ");
INSERT INTO kfw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","nangni rakip khat-um Israel mi rakip chungnga hiwahi ningjetsik asuok, nangni'n cross ah ningthatjei, halli Pathian in thiya inphut iminring Nazareth Jisu Christa ramingnga, tichu ama jarra, hiwa mipa in nangni maikuungnga kadamsengnga angir jei. ");
INSERT INTO kfw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jisu ama kha eii chong-inthiang in iril kha, ‘Nangni inn kasak ngai'n ningneiman mak lungkha akil karoonkhet lung ahong-inchang.’ ");
INSERT INTO kfw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Sanminringna hi amadiang bit nimusik-eii; ajarchu eini nakasan inringsik Pathian in ipe ramingngai karra raming leiilak nuoipil chungnga inkhat-um ommak.” ");
INSERT INTO kfw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sanhedrin mi ngaikhan Peter li John thomatorna inmu pha, inmani inchuna khat-um jetna kaneimak micham in-eii ti injet ah, inmani inleingakjei, halli inmani Jisu le in-inruoi jei ti inmani'n injetjei. ");
INSERT INTO kfw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Takkha inmani'n khawakhan iteii tidan leijetmu, ajarchu inmindam mipa kha Peter khat-um John le in-ngir kha inmani'n inmu. ");
INSERT INTO kfw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Khawa jarra inmani'n Peter li John kha Sanhedrin inn makheiya suoknasik chong inpeli, inmaniseng in-inbiakjei. ");
INSERT INTO kfw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Hiwa mi ngaidiang eini'n angme nithosik?” ajarchu inmani'n mi itho matormak chuon-inlak intho jei tihi Jerusalemma kaom “Mi rakip in injet, halli eini innum hiwahi emak titheinumin. ");
INSERT INTO kfw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Takkha hiwa chonghi mi ngai karra kheella inthang maknasik ah, tuunna inphut Jisu raminghi tu-inkhat diang um inril maknasik minchitui inti.” ");
INSERT INTO kfw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Khawa jarra inmani'n inkoi luutnook ah, woikhat inlet ah chong supril inril maknasik emakli Jisu ramingnga inminchu maknasik inmani diang chong inleipeii. ");
INSERT INTO kfw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Takkha Peter li John in inmani diang inleimasang, “Pathian chongkajui neek ah Nangni chongkajui hin Pathian mitmu ah hume katuun nangni'n chongtanru. ");
INSERT INTO kfw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ajarchu keini'n angme kinmu kinjet ngaikha rilleiya omtheinunung.” ");
INSERT INTO kfw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ajarchu mi rakip in angme kasuok jarra Pathian inminpaak kha inmani'n inmu ah, rachaak nasik ajar jetmu ah Sanhedrin ngaikhan chongkanadet-ah inminchiya inmani inleimasuojei. ");
INSERT INTO kfw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Hiwa chuon-inlak inthowa akadam mipahi kum soommili kakhel upa inkhat alei eii. ");
INSERT INTO kfw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Inmani inmasuo pha, innot ah Peter li John insap ngaidiang inkirra thiampu kalianngai khat-um uparup ngai'n iril rakip ngaikha inmani diang inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Inmani'n khawa injetpha malung khatbit ah Pathian diang inniya, “Pumi, nangchu marwaan, nuoipil, tuipui khat-um khanna kaom rakip kabool Pathian na-eii! ");
INSERT INTO kfw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ratha Inthiang khan keini kinpa David nasuokpa mursuokhan hintia naleiminril suok, ‘Angsikme zaatlop ngai inmalung kahong; halli mipui ngai'n angsikme anemna kaboiya inngaidon? ");
INSERT INTO kfw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pumi khat-um ama Messiah kadeisik, Nuoipilchung reng ngai'n inin-siam, halli waikaroon ngaikhan in-inchun.’ ");
INSERT INTO kfw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ajarchu Nasuok inthiang Messiah nimin eii Jisu chungnga zootmakna kha Zaatlop ngai khat-um Israel mingaile inruoiya inthiang tak ah Herod li Pontius Pilate innum hiwa khuopuihin inlei-intuupjei. ");
INSERT INTO kfw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chuon minsuuksa kha asuok theinasik naranak khat-um nalungdou ngai rakip thonasik ah inmani'n inlei-intuup. ");
INSERT INTO kfw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Halli tuunchu Pumi, inmani naminchina hin nasuok keini'n kachi omleiya nachong kinrilnasik na-enro. ");
INSERT INTO kfw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nasuok inthiang Jisu ramingnga chuon-inlak kintho theinasik le kinmindam theinasik nazootpi-inlang nakut naduongpiro.” ");
INSERT INTO kfw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Halli inmani'n nina inneisuopha, inmani intuupna munkha innikjei, han inmani rakip Ratha Inthiang in asip ah, chilekleiya Pathian chongkha inleiril. ");
INSERT INTO kfw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Khawakhan kangamna rup rakip in malung khatli ratha khatbit ah inleiom. Inmani tu-inkhat innum inmani inei phur rakip ngaikha kintheinuota eii lei-intimu, takkha inmani'n phur rakip kha mipuita inmin-eya inleineiman. ");
INSERT INTO kfw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Halli inmani rakip chungnga Pathian in rawaan katamma aleibun pia, tirton ngaikhan Pumi Jisu hongringna chongkha ranak kaneitakle inruoiya sakhi inleipeii. ");
INSERT INTO kfw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Inmani ngai karra tu-inkhat um insam lei-ommu, ajarchu ram emakli inn innei rakip kha injuorra, injuor phur rakip man sial kha inhongchoiya, ");
INSERT INTO kfw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tirton ngaidiang inhongpeii; halli sial kha mi rakip in neimansik kahun dungjuiya inlei-insem. ");
INSERT INTO kfw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Halli Cyprus ah kaom Levi phungnga innei araming Joseph inti, tirton ngai inchu Barnabas tia inkoi (hiwa tinachu “Malung kamasok sapa”), ");
INSERT INTO kfw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ama'n alei ajuorra, khawa sial kha achoiya tirton ngaidiang ahongpejei. ");
INSERT INTO kfw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Takkha Ananias inti miring inkhat anumei Sapphira le inruoiya inmani ram lekkhat inleijuor. ");
INSERT INTO kfw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","takkha anumeile in-inzootna ah sial lekkhatchu inkhoithenli inda, halli lekkhat kha tirton ngaidiang ahongpeluut. ");
INSERT INTO kfw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter in amadiang aleiti, “Ananias, nang in Ratha Inthiang diang maleisei thonasik ah, khawa ram man kha lekkhat nakhoithenli danasik ah angsikme namalung Seitan nimintor? ");
INSERT INTO kfw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Khawa kha najuormaklai nata emak abe? halli khawa kha najuorsuoli aman kha-um nangta eii, kha e-inchu angsikme hinthonasik ah namalungnga ningaidon? nang in mi ngai diangnga maleisei nitho-emak takkha Pathian diang maleisei nitho eii.” ");
INSERT INTO kfw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias in hiwahi ajetli-jetmak, apurra athijei; hiwa kajet rakip um inleichi theijei. ");
INSERT INTO kfw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Halli ruothar ngai inheiluut ah, akaluong kha puonna inkatuomma, inkeisuo-ah inleiphuum jei. ");
INSERT INTO kfw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Phadan inthumdaam omli, anumei khan akasuok kha jetleiya ahongluut. ");
INSERT INTO kfw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter in ama diang arakella, “Naruothar le ram ningjuor kha aman hiseng bitbe keidiang rilro?” ama'n aleimasang, “Oh,” khaseng bit eii, ati. ");
INSERT INTO kfw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Khawa jarra Peter in amadiang ati, “Naruothar le nang in angsikme Pumi Ratha kha ensinnasik ning-inzootna? enro naruothar kaphuum mi ngaikha kotkuung inhongtungjei, inmani'n nang um innakadom suoksik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Khawa laitak khan ama kha Peter kekuungnga apurra athijei. Halli ruothar ngaikhan inheiluut pha ama kathi kha injuomujei, khat-um inmani'n ama kha inkadomma aruothar sirra inphuumjei. ");
INSERT INTO kfw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Koisuok pumpuile hiwa chongkajet rakip inraya ah inleichi theijei. ");
INSERT INTO kfw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Chuon-inlak ngai khat-um inthomatormak katamtak chuon tirton ngai'n mipui karra inleithojei, halli kangamna rakip in solomon tuolla malung inkhatbit ah in-intuup. ");
INSERT INTO kfw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Takkha tu-inkhat innum inmanile lei-inchunpuimu, takkha inmani kha mirakip in inleikaya. ");
INSERT INTO kfw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kha-ennum Pumi kangamna mipui katamtak pasal khat-um numeisa ngaikha inmani rup karra kheel kheella inhong-inchundel. ");
INSERT INTO kfw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tirton ngai chuontho inlak jarra, Peter in aheiwana khan ama raliimbit in tuka-ang lekkhat chungnga achulnasik akana mi ngaikha lamkhan inhongruoiya zaalmun khat-um saponpher chungnga inleiminzaal. ");
INSERT INTO kfw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Halli Jerusalem koolla kaom khuopui mi ngai inhongnga akana ngai emakli akathamak ratha insuungnga kaluut ngai inhongruoi, halli inmani rakip inleimindam jei. ");
INSERT INTO kfw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Khawasuo Thiampu Kaliankhet khat-um amale inruoipui rakip, tichu Sadducee rup ngaikhan tirton ngai chungnga ra-otna kha aleisip; khawa jarra inmani'n tirtonngai minpoong nasik inlei-inzootna jei. ");
INSERT INTO kfw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Inmani'n tirton ngaikha insurli, mikhumna khan indajei. ");
INSERT INTO kfw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Takkha khawani zaan Pumi tirton inkhat in mikhumna suongkot kha amalongnga, tirton ngaikha akeisuoli ati, ");
INSERT INTO kfw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Nangni siru Biak-inn suungnga juongir-inlang, hiwa ringkhuothar jarra mi rakip diang juorilru.” ");
INSERT INTO kfw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Inmani'n hiwa injetpha, Biak-inn khan ziingtiang khuo warli inluut ah inleiminchu jei. Takkha Thiampu Kaliankhet khat-um ama sap ngai inhongnga, Sanhedrin halli Jihudi uparup rakip inkoichunna, inmani hongkaruoisik ah mikhumnatiang inleitirjei. ");
INSERT INTO kfw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Takkha chuonkaroon ngaikhan mikhumna intungpha, tirton ngaikha inmani'n mikhumna khan jomumujei, halli inkirra chong injuopejei, ");
INSERT INTO kfw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Keini'n mikhumna kintungpha, mikhumna kha kacheet kathatak ah inkhar halli raalpa katho rakip ngai'n kotkuungnga inngaak kha kinjomu, takkha keini'n kot kha kinmalongpha, asuung khan mi tu-inkhat keini'n jomumung inti.” ");
INSERT INTO kfw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Biak-inn lamkakeipa le thiampu kalian ngaikhan hiwa chong injetpha, angme tirton ngai diangnga akasuok jei hi tia inmalung inleiminpoong. ");
INSERT INTO kfw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Halli mi inkhat ahongluut ah inmani diang ati, “Enru, nangni'n mikhumna-ah ningda mi ngaikhan Biak-inn khan inngirra mi ngaikha inminchuwa inom.” ");
INSERT INTO kfw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Khawa jarra lamkakeipa khan achuon thopui ngaikhale inruoiya insiya inmani kha wuok-ranleiya injuoruoijei, ajarchu inmanikha lungtumma nadeeng inte tia mi ngaikha inleichi. ");
INSERT INTO kfw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Inmani'n tirton ngaikha inheiruoi phakhan, Sanhedrin ngai maikuungnga inleiminngir, halli Thiampu Kaliankhet khan inmani diang chong aleirakel. ");
INSERT INTO kfw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hiwa mipa raminghin minchumaru tia keini'n nangnidiang chongkha kana ah kinape-emak abe?” “takkha enru, nangni minchuna kha Jerusalem pumpuiya inthangjei, nangni'n keini chungnga ama kathihi naseng nasik ningmanuom.” ");
INSERT INTO kfw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter le tirton ngaikhan inleimasang, “Keini'n mi ngai chong neek ah Pathian chong kha kinjuisik asuok. ");
INSERT INTO kfw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nangni'n Thing cross ah ningmakaiya ningthat Jisu kha keini kinpi-kinpu ngai Pathian khan anaminringpijei. ");
INSERT INTO kfw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israel ngai malungthuul nasikle manu ngaidamna kapesik, Pathian in amahi Lamkakei khat-um Kasanringpa enasik akut changtiang kaom sik-ah kadom minsaangjei. ");
INSERT INTO kfw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Halli achong kajui inmani ngaidiangnga Pathian akutchoipe Ratha Inthiangle keini ngaiseng um sakhi kin eii.” ");
INSERT INTO kfw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sanhedrin intuup ngaikhan hiwa chong injetpha inmalung anaheiya inmani kha inleithat zootjei. ");
INSERT INTO kfw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sanhedrin ngai karra araming Gamaliel inti Pharisee Dan karu inkhat, mi rakip in inkayapa khan angirra, tirton ngaikha phabongkhat tuoltiang ruoinasik chong aleipeii, ");
INSERT INTO kfw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","halli ama'n Sanhedrin ngaidiang aleiti, “E Israel mi ngai, hiwa mi-ngai chungnga angme ningthosik kha nangni ngaidonsiakru. ");
INSERT INTO kfw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ajarchu hiwa nikhuo matiang atheinuo ah mikalok ka-eii kati Theudas inti khat aleiom, amadiang mi rajamili daam inleijui, takkha ama inthatpha anuk kajui ngaikha inchek-chaidarra inmang suojei. ");
INSERT INTO kfw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Khawa suonuk milu inteel phakhan Galilee mi Judas ahongsuoknook ah eii, mi katamtak in anuk inleijui takkha ama um inthatjei, halli anuk kajui ngaikha inchek-chaidar suojei. ");
INSERT INTO kfw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hiwa jarra, kei'n nangnidiang kirilhi eii, hiwa mi ngai masuoru, iteii inchungnga thomaru, ajarchu inchuon minsuuk li intho chuonngaihi miringnga inphut e-inchu, alajomangsik eii, ");
INSERT INTO kfw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","takkha Pathian diangnga e-inchu, nangni'n inmanihi minmang matornutun, nangni Pathian chungnga indeipui ning esik eii.” Khawapha inmani'n Gamaliel chongkha inleijui, ");
INSERT INTO kfw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","halli inmani'n tirton ngaikha inkoiluut ah, inleiwuok, Jisu ramingnga chong inrilmak nasik chongkanatak inpeli, inmani kha inleimasuojei. ");
INSERT INTO kfw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Khawajarra tirton ngai'n Jisu ramingnga injak kakhaang in anem tia inrokle inruoiya uparup ngaikha inleimathaanjei. ");
INSERT INTO kfw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Halli nisuo ah Biak-inn khat-um inn inna Jisu hi Messiah eii ti chongkahoi kaminchu karilpi leidamu. ");
INSERT INTO kfw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Khawa phakhan, siamruoi milu inhongkheella, Greek chongkaril Jihudi khat-um khawa ramma kaom Jihudi ngai insuolna inhong-nei, ajarchu Greek chongkaril Jihudi chuulmei ngaikha nisuo ah insial semna khan leirawat mujei. ");
INSERT INTO kfw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Khawa jarra siamruoi soomleini ngaikhan Pathian ka-inngamna rakip ngaikha inkoi chunna inti, “Bak le in thonasik bit-ah keini'n Pathian chonghi rilmaksik akatuun emakjei. ");
INSERT INTO kfw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Khawa jarra, E ule-nai ngai, omchan katha mi, Ratha Inthiang le singwarna kasip pasal sari nangni karra nakadangpiru, halli keini'n hiwa chuon ka-ensui sik-ah kindasik eii. ");
INSERT INTO kfw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Takkha keinichu pui katungnga Pathian chongkachoisik khat-um kani sik-ah inpesuok takkinte.” ");
INSERT INTO kfw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Halli hiwa tirton ngai chonghin mipui rakip malung aleitaijei, inmani inngamnale Ratha Inthiang in kasip pasal, Stephen, Philip, Prochorus, Nicanor, Timon, Parmenas, halli Antioch mi Jihudi kaluut Nicolaus ngaihi inkadangjei. ");
INSERT INTO kfw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tirton ngai ma-ah inmani inminngirra, halli inchungnga inkut induongnga Pathian diang innipijei. ");
INSERT INTO kfw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Khawa jarra Pathian chongkha inthang tirra, Jerusalemma kaom siamruoi ngaikha kheella inhongtamjei, halli thiampu katamtak ngai-um inngamna khan inzootjei. ");
INSERT INTO kfw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Halli Stephen kha Pathian rawaan khat-um ranak in asip ah, mi ngai karra chuon inlak inlak ngaikha aleitho. ");
INSERT INTO kfw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Inlungdouwa kaleeng (tia inkoi) synagogue mi ama kazootmak lekkhat, halli Cyrenian, Alexandrian, khat-um aleiilak Jihudi Cilicia le Asia ah kaom inmani ngai'n inhongsuok ah Stephen le murruolsiak katho inleiphut. ");
INSERT INTO kfw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Takkha Ratha in Stephen kha singwar ape ah achongril kha inmani'n tuunmak leiti matormu. ");
INSERT INTO kfw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Khawa jarra inmani'n mi lekkhat ruuk-ah sial inpeya, hinthoa inminril jei, “Ama'n Moses le Pathian chungnga kasechong iril keini'n kinjet.” ");
INSERT INTO kfw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hinthoa inmani'n uparup ngai, Sinadan karu ngai halli mipui ngaikha inminhaangjei, halli inmani'n inhongli ama kha insurra, Sanhedrin ngai maikuungnga inhongruoijei. ");
INSERT INTO kfw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Khawapha inmani'n ama chungnga maleisei sakhi kapesik mi lekkhat inhongruoiya, inmani'n inti, “Hiwa mi hin,” “Inthiang Biak-inn khat-um Moses Sinadan chungnga chong ariljol, ");
INSERT INTO kfw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ajarchu Nazareth Jisu'n hiwa Biak-inn hi thiatta halli Moses in eini diangnga inape Sinadan hi athuulsik eii tia iril kha keini'n kinjet.” ");
INSERT INTO kfw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Khanna in-ong Sanhedrin rakip in Stephen diang mitmachim lekleiya in-enpha, ama meelkha marwaan tirton inkhat meelsuo angnga inleimu. ");
INSERT INTO kfw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Halli Thiampu Kaliankhet khan Stephen diang aleirakel, “Hiwahi atuunbe?” ");
INSERT INTO kfw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen in aleimasang “Kapa ngai khat-um ka-u kanai ngai, rangairu! Nipu Abraham in Haranna asimakma, Mesopotamia ah omlai khan akalur Pathian khan amadiang ajuo-inlar, ");
INSERT INTO kfw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","halli amadiang aleitipi, ‘Na-innsuung nami-ngaile naram mathaan inlang kei'n nangdiang kanaminmu sik ramtiang siro.’ ");
INSERT INTO kfw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Khawa jarra ama'n aram Chaldea amathaanna Haran khan kaomsik asijei. Halli apa kha thisuonuk, tuunna ni-omna ramhin Pathian in ama kha ahongmin-om. ");
INSERT INTO kfw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Halli Pathian in Abraham diang ramkha ama sik-ah leipemak, ketounasik munnum leipemak, halli Pathian in amadiang nuk ah atu-asa ngaidiang hiwa ramhi amapu kanamin-esik eii tia ama saneimaklai khan chong-inkhitna aleinei.” ");
INSERT INTO kfw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pathian in hiwahi amadiang ati, Natu-nasa ngaikhan miramma inlajuo-omsik eii, halli khawa ramma kaom mingaikhan inmani kha suok lamin-e inta kum rajamili katung kase ah inlathosik eii. ");
INSERT INTO kfw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Takkha Pathian in ati, inmani'n sepa inthosik phungngai kha kei'n chong kalatansik eii, halli inmani'n hongsuok-inta, hiwa munhin kei chubei innalathosik eii. ");
INSERT INTO kfw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Halli Pathian in Abraham diang wuntan chong-inkhitna kha apejei; khawa jarra Abraham in Isaac aneiya niriat huuini amakha wun atanjei; Isaac in asapa Jacob, halli Jacob in asa soomleini ngaikha wun aleitanpi. ");
INSERT INTO kfw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jacob sangai khan innaipa Joseph enzootmua ama kha suok-kachangsik Egypt ah injuorjei.” Takkha Pathian in amakha alei-inruoipuiya, ");
INSERT INTO kfw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ama poongraalna rakip asan li Egypt rengpa Pharaoh maikuungnga Joseph inlarra, Pathian in amadiang riangwai khat-um singwar apeya, halli Pathian in amadiang Egypt khat-um areng innsuungkhur chungnga wai-aleiminroon. ");
INSERT INTO kfw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Egypt khat-um Canaan rampumpuiya bukawangli kapoong-karaal aleisuok, halli nipi-nipu ngaikhan bubaksik leineimu. ");
INSERT INTO kfw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob in Egypt ramma baksik saang-bal aom ti ajetpha, ma-insakhet ah ama'n eini nipi-nipu ngai aleitir. ");
INSERT INTO kfw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Halli woini huuina ah Joseph in apumtak a-u anai ngaidiang inlarra, halli Pharaoh in Joseph innsuung mingaikha ajetjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Khawa jarra Joseph in apa Jacob diang chong aminroonna, innsuungmi inraya ah soomsari leira-nga kha Egypt ramma inhong nasik ajuokoi jei. ");
INSERT INTO kfw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Halli Egypt ramma Jacob aleisi, khawa munkhan ama le asa ngaikha inleithi. ");
INSERT INTO kfw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Halli inmani kaluong kha Shechem katung injuochoiya, Abraham in Hamor phung ngaidiangnga sial apeya ileiracho thaankhan injuophuumjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Pathian in Abraham diangnga achong-inkhitna phakha ajuonai pha, Egypt ramma kaom eini mi ngaihi kheella aminpungjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ahekna ah Joseph kajetmak reng inkhat Egypt ramma wai ahongroonjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ama'n eini nipi-nipu ngai chungnga akathamak angaidonna, insa akasiin ngaikha inringmak nasik aleiminlek juonna, nipi-nipu ngaikha kase ah aleitho. ");
INSERT INTO kfw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Khawa phakhan naipang katha tak Moses kha inneiya, amakha apa inna thathumchu inleiwai, ");
INSERT INTO kfw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","halli ama inkalekjuonna, Pharaoh sanu in amakha aruut ah asapatak sik-ah awaijei. ");
INSERT INTO kfw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Halli Moses kha Egypt ngai singna le theina rakip inchuwa, chuontho le chongrilnatiang mikalok khat ahong ejei.” ");
INSERT INTO kfw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses in kum sommili hongtungpha, a-u anai Israel sangai kha, jophanasik amalung suungnga leingaidon.” ");
INSERT INTO kfw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ama'n ajuosipha, Israel ngai karra mi inkhat kase ah inleitho kha ajuomua, akasansik asiya halli phaphu aluok ah Egypt mipa kha athatjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ajarchu Moses kut ah a-u anai ngaikha Pathian in alaminsan tihi inmani'n leijet-inte tia aleingaidon, takkha inmani'n leingaidonmu. ");
INSERT INTO kfw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Khawa ziingkhuo awarli ama'n Israel sangai inni inwuok kha aleimu, halli inmani kha inzoot-inngei nasik ah ama'n ati, Rangairu, mi ngai, Nangni ule-nai ning eii, angsikme hin ningthoa ning-insuol? ");
INSERT INTO kfw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Takkha amale indiang-inwaipuipa kase ah kathopa khan Moses kha anamjuonna, ati, Nang tu-in keini chungnga waikaroonsik li chongkatan sik-ah nakadangme? ");
INSERT INTO kfw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nang in miyanni Egypt mi nithat angnga, keihi nathatsik nitibe? ");
INSERT INTO kfw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses in hiwa chong ajetpha, Egypt ramma inphut ataanna Midian ramma ajuo-omma, khawakhan sapasal inni aleinei. ");
INSERT INTO kfw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Khanna inphut kum soommili huuipha, Sinai Ching koolla kaom neelram khan marwaan tirton inkhat in suulbuklai hongkakaang meimachuon angnga Moses diang alei-inlar.” ");
INSERT INTO kfw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Halli Moses in khawakha amupha khan ama'n alei-ngak, halli katha ah ennasik ajuonai pha, Pumi rasa kha ama'n aleijet: ");
INSERT INTO kfw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Keichu napi-napu ngai Pathian ka-eii, Abraham, Isaac, khat-um Jacob Pathian ka-eii, khawakhan Moses in intuulla katha ah lei-enmakjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pumi'n amadiang ati, Nakekok kha khairo, ajarchu nangirna munkha inthiang munkha eii. ");
INSERT INTO kfw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Egypt ramma kaom kei kami ngai kapoong-karaal kha kamuwiakjei, inmani chaprasa kha Kei'n kajetjei, tuun inmani kamasuo sik-ah Kei kajuochum, khawa jarra tuun heiwaro, Kei'n nanghi Egypt ramma kanatirsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ ‘Tu-in nanghi keini chungnga lamkakei khat-um chongkatan namin-eme?’ tia Israel mingai'n inzootmak Moses hi suulbuklaiya meimachuon angnga inlar marwaan tirton kut khan asanna lamkakeisik khat-um kanasanring sik-ah Pathian in amahi ajuotirjei.” ");
INSERT INTO kfw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ama'n Egypt ramma, Tuipui Kasen, (Red Sea) halli neelramma kum soommili inlak-inlak chuon khat-um jettheina ngaikha athoa inmani kha aheiruoisuok jei. ");
INSERT INTO kfw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses in Israel mi ngaidiang ati, Pathian in kei kapuo nangnisik bit-ah, Pathian chongkachoi inkhat ningmingai karra kajuotirsik eii ati. ");
INSERT INTO kfw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Amahi Israel mi ngai neelramma kamintuup, Sinai Chingnga marwaan tirtonle inbiakpui, nipi-nipu ngaile lei-inlop kha ama eii, halli Pathian ringna chonghi einidiang mason-masonna napenasik aralaangjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Takkha eini nipi-nipu ngaikhan achong juisik leijuizootmu, halli inmani'n Egypt ramma inkirzoot jarra amakha inkanengjuon jei.” ");
INSERT INTO kfw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Khawa jarra inmani'n Aaron diang inti, Keini lamkakeisik pathian lekkhat naboolpiro, Egypt ramma inphut naheikaruoi Moses kha ang-changmajei keini'n jetmungjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Khawa phakhan inmani'n saraatteii ramil inkhat inboolla, khawa ramil khan doiphur inhongchoili inmani inkut tak-ah inbool phurkha inrokpuijei. ");
INSERT INTO kfw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Khawa jarra Pathian in inletdella, inmani kha marwaanna kaom rakip chubei thonasik apejei, Pathian chongkachoi ngai larik ah inleimajia hi angnga: E Israel mi ngai, neelramma kum soommili sa ningthat, sariing ningtan kha keidiang ningtho emak abe? ");
INSERT INTO kfw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Khawa Molech pathian inn, halli ningpathian Rephan arsi ramil ningkadom; inmani ramil kha nangni'n chubei thosik ah ningbool. Khawa jarra kei'n nangni Babylon raaltiang kanatirsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Eini nipi-nipu ngai'n neelram khan Pathian inruoipuina sakhi Maichaam Inn kha inmani diang aleiom, khawa ramil kha Pathian in Moses diangnga boolro tia iminmu dungjuiya khawakha inbool eii.” ");
INSERT INTO kfw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Eini nipi-nipu ngai matiangnga inpi-inpu ngai diangnga inphut inralaang maichaam inn kha Joshua le inruoiya insipha inmani'n inleichoi halli Pathian in ileipuutsuok phung ngai ram kha inmator tirra inleisi, halli maichaam inn kha David pha katung aleiom. ");
INSERT INTO kfw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David in Pathian mit enna rawaan amu-ah Jacob Pathian sik-ah omnasik mun Pathian diang aleini. ");
INSERT INTO kfw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Takkha Solomon in Pumi sik-ah inn kha asakjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Takkha Chungnung Pathian kha kut-ah inbool inn ngaikhan ommak,” Pathian chongkachoipa'n iti-angnga, ");
INSERT INTO kfw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Marwaan chu kei reng in-ongna eii, halli nuoipilchung hi kei kaketouna eii. Pumi khan ati, keisik ang innme ningsaksik? emakli kei soongmachumna sik mun hunme? ");
INSERT INTO kfw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kei kakuttak in phur rakip hi kibool emak abe? ");
INSERT INTO kfw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Nangni ningkuor angar!” “Angtuk Pathian chongnga ningmalung inthiangmak halli ningkuor kaseetme! nangni'n apha rakip ah Ratha Inthiang kha ninghal: nangni ningpi ningpu ngai'n inleitho angnga, nangni innum ninglatho Stephen in ati. ");
INSERT INTO kfw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nangni ningpi ningpu ngai'n Pathian chongkachoi ngai karra inleiminpoong mak tu ommame? halli akadik Pumi ama ajuonasik jarra matiangnga kaleimindik ngaikha inmani'n inleithat, halli tuunchu nangni'n Pumi kha ningpesuok ah kathat ngaikha ning ejei. ");
INSERT INTO kfw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nangnichu marwaan tirton ngai diangnga Pathian in ipe dan karalaang ngaikha ning ejei, takkha nangni'n khawakha juimakchu!” ");
INSERT INTO kfw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Inmani'n hiwa chong ngaihi injetpha, inmalung hongnga, ama chungnga inraangnga inha inkarialjei. ");
INSERT INTO kfw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Takkha Stephen chu Ratha Inthiang khan asip ah, marwaantiang enpha, Pathian lurna-lianna khat-um Jisu'n Pathian changtiang i-ngir amu-ah, ");
INSERT INTO kfw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Enru, marwaan suongkot inlong khat-um Miring Sapa kha Pathian changtiang i-ngir kei'n kamu ati!” ");
INSERT INTO kfw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Inmani'n rasa inringnga inkheek ah inkuor inkut ah inkharra inmani rakip ama koolla inhongtaan, ");
INSERT INTO kfw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","halli khuopui tuoltiang ama inkeisuo ah amakha lungnga indeengjei, halli akadeeng ngaikhan sakhi sik-ah inpuon-indiar kha araming Saul inti ruotharpa kekuungnga inleida. ");
INSERT INTO kfw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Halli inmani'n amakha lungnga inleideenglai Stephen in Pumi diang akoiya, “Pumi Jisu, kei karatha hi naleipiro,” ati. ");
INSERT INTO kfw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Halli ama'n kemurkhup athep-ah, rasa inringnga akheek ah ati, “Pumi! hiwa manu hi inchungnga namachul pimaro!” hiwa arilsuoli ama kha athijei. ");
INSERT INTO kfw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Halli Saul in Stephen inthat kha amittak ah aleimu. Halli Jerusalemma kaom koisuok chungnga khawani makheiya poongna-raalna inphutjei, khawakhan tirton ngai eleiya, ka-inngamna rakip Judea khat-um Samaria ram rakip ah inchaangdar jei. ");
INSERT INTO kfw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Halli malung kahoimakle inruoiya inkheek ah, in-ngamna kacheet mi lekkhat in Stephen kha inphuumjei. ");
INSERT INTO kfw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Halli Saul in koisuok minmangna sik-ah angaidonna, inn-inna luut ah ka-inngamna pasal numeisa ngai akeisuo ah, mikhumna khan inmani ngaikha aleida. ");
INSERT INTO kfw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Khawa jarra ka-inngamna inchekchai ngaikhan amun rakip ah insiya chongkahoi kha inleiril. ");
INSERT INTO kfw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Halli Philip in Samaria khopuitiang achumma Christa chongkha inmani diang aleiril. ");
INSERT INTO kfw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mipui ngaikhan Philip chongril inrangaipha halli ama itho chuon inlak kha inmupha malungkhat bit-ah ama iril chongkha inleirangai. ");
INSERT INTO kfw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ajarchu inthiangmak ratha kaluut mi katamtak ngai diangnga inphut ratha ngaikhan rasa inringnga inkheek ah insuokjei, halli apumkathi khat-um akeii kakiak mi katamtak aleimindam jei. ");
INSERT INTO kfw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Khawa jarra khuopui khan karok in aleisip jei. ");
INSERT INTO kfw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Samaria khopui khan ngaksik kaom mitmalet dooikachoi, araming Simon inti Pasal inkhat aleiom, halli ama atheinuo ah akalok-akaraang mi inkhat ka-eii tia Samaria ngaikha aleiminngak. ");
INSERT INTO kfw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Khawa khopuiya kaom akasiin akalian rakip in inmalung-inpeya, “Hiwa miring hi akaraatkhet Pathian ‘Ranak kaneipa kha eii,’ ” inmani'n inti. ");
INSERT INTO kfw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Halli ama'n ngaksik kaom mitmalet dooikhan inmani diang apha kasoottak aleiminngak jarra inmani'n amakha inleijui. ");
INSERT INTO kfw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Takkha Philip in Pathian Rengram khat-um Jisu Christa raming jarra chongkahoi iril kha in-ngamna pha, inmani kha numeisa um pasal um baptize inleitho. ");
INSERT INTO kfw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon apumtak innum in-ngamna ah, baptize atholi Philip le inlei-inruoisuom halli Philip chuontho inlak ngaikha amu-ah aleingak jei. ");
INSERT INTO kfw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalemma kaom tirton ngaikhan, Samaria mi ngai'n Pathian chongkha inkeiluutjei ti injetpha, inmani'n Peter li John inmani diang inleitir. ");
INSERT INTO kfw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Inmani inni intungpha, inmani in-ngamna kaneingai Ratha Inthiang inmunasik nina inleineipi. ");
INSERT INTO kfw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ajarchu inmani'n Pumi Jisu raming bit-ah baptize inlatho, Ratha Inthiang in inmani chungnga lajuochummak. ");
INSERT INTO kfw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Khawa phakhan Peter li John in inchungnga inkut induongpiya inmani Ratha Inthiang kha inmujei. ");
INSERT INTO kfw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Halli tirton ngai'n inkut induongpiya, Ratha Inthiang inpejei ti Simon in amupha, ama'n inmani diang sial apeya, ");
INSERT INTO kfw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kei'n tuka-ang inkhat chungnga kakut kadali, ama'n Ratha Inthiang amunasik, khawa ranak kha keidiang um napero ati. ");
INSERT INTO kfw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peter in amasangnga amadiang ati, “Nasial le nang inmang suomru, ajarchu nang in Pathian kutchoihi sialla racho mator tia nangaidonjei! ");
INSERT INTO kfw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hiwa chuonhi nang natum iteii neimakche, ajarchu Pathian mitmukhan namalung inthiangmak. ");
INSERT INTO kfw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Khawa jarra nathamakna makheiya inphut namalung thuulro, halli namalung ngaidon rakip kha ana-ngaidam nasik Pumi diangkhan niro. ");
INSERT INTO kfw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ajarchu enzootmakna malung kakha kasip khat-um manu suok inkhat nachangna kei'n kanamu ati.” ");
INSERT INTO kfw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Khawakhan Simon in Peter li John diang amasangnga ati, “Naminriang inlang kei sik-ah Pumi diang nanipiru, ningril ngai inkhatbit um kachungnga asuokmak nasik.” ");
INSERT INTO kfw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Inmani'n Pumi chongkha inrilla sakhi inpesuoli, Samaria khuo katamkhat chungnga Pathian Chongkatha kha inriltirra Jerusalem tiang inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pumi tirton inkhat in Philip diangkhan arilla, “Intheiro, halli Jerusalemma inphut Gaza tiang kachum lamkhan simtiang siro.” Hiwahi neelram eii. (Tuunchu hiwa lamhi sinamujei.) ");
INSERT INTO kfw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Halli Philip intheiya asijei. Enru, Ethiopia mi inkhat atak-inboolpa, Candace Ethiopia Rengnu sial-sum kamahuum ranak kaneipa Pathian chubei katho Jerusalemma aleihong, ");
INSERT INTO kfw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","halli ama ajuokirpha asakor-kari chungnga in-ongnga Pathian chongkachoi Isaiah larik kha ateella ajuo. ");
INSERT INTO kfw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ratha Inthiang in Philip diangkhan ati, si-inlang ama Sakor-kari khan nang juonairo. ");
INSERT INTO kfw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Halli Philip in amadiang ataanna, ama'n Pathian chongkachoi Isaiah larik iteel kha arangaiya ati, angme nang in niteel kha najetbo? ");
INSERT INTO kfw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ethiopia mipa khan amasangnga, “Tuka-ang mi inkhat in anarilpi mak inchu, angtho-thoa kei'n kajetsik?” halli ama'n Philip kha akoolla hongkalla hong-in-ongsik aleikoi. ");
INSERT INTO kfw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ama ileiteel chong-inthiang munkha hi eii: “Keelngam inkhat thatsik inkei angnga amakha inkei, Keelngamteii in amul ka-ep ngai maikuungnga inraammak angnga. Ama chong inkhat-um leirilmak. ");
INSERT INTO kfw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ama kha enseel-musit ah inleitho, halli ama dikna kha leizootmu. tu-inkhat innum ama phungrui karilsuok mator omnunu, ajarchu nuoipilchung hin aringkhuo ahekjei.” ");
INSERT INTO kfw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Halli atak inboolpa khan Philip diang rakella, ati, “Keidiang natipiro, Pathian chongkachoipa in tu jarra irilme? Ama jarra irilbe emakli tuka-ang inkhat jarra irilbe?” ");
INSERT INTO kfw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Khawa phakhan Philip in chongkaril aphut ah, Jisu jarra chong inthiang munkha amadiang karilpi aleiphutjei. ");
INSERT INTO kfw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Halli inmani'n lamma insipha, tui-omna amun inkhat intungpha atak inboolpa khan ati, Enro, “Hin tui lekkhat omjei, angjarra kei baptize kalathomak sikme?” ");
INSERT INTO kfw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Philip in aleiti, “Nang in namalung pumpuiya na-ngamnajei inchu baptize thocha.” “Kei kangamna jei,” tia ama'n aleimasang, “Jisu Christa hi Pathian Sapa eii tihi kei'n kangamnajei.” ");
INSERT INTO kfw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Atak inboolpa khan Sakor-kari kha khaapnasik chong aleipeii, halli Philip le atak inboolpa in tui omna khan inchumma, ama kha Philip in baptize aleimintho. ");
INSERT INTO kfw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Inmani'n tuiya inphut inhongsuok pha, Pumi Ratha in Philip kha aruoijei. atak inboolpa khan amakha mumakjei, halli ama kha karok in asip ah asijei. ");
INSERT INTO kfw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Philip kha Azotus atungjei, halli Caesarea, atung maklaiseng asina khuopui rakip ah Pathian chongkahoi kha aleiril. ");
INSERT INTO kfw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saul in Pumi siamruoi ngai chungnga minchinasik khat-um thatnasik malungkha alaroon tit ah, Thiampu kaliankhet diang aleisi, ");
INSERT INTO kfw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","halli Pumi Lam kajui numeisa emakli pasal tuka-ang ka-intongpui inchu, inmani kha surra Jerusalemma hongruoinasik Damascus ah kaom synagogue mi ngai diang pesik cheii kha naperu tia aleini. ");
INSERT INTO kfw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Halli Saul in damascus khuopuitiang aheinaipha, hintia asuokjei, jetlei-theileiya marwaanna inphut ra-ang inkhat in ama asir-apangnga awarjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Khawakhan ama nuoipilchungnga atajei halli “Saul, saul! nang in angsikme kei ninaminpoong?” iti rasa inkhat ama'n aleijet. ");
INSERT INTO kfw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Halli ama'n ati, “Nang tu na-eme Pumi?” “Kei Jisu ka-eii, nang in ninaminpoong-ninaminraal,” tia rasa khan ati. ");
INSERT INTO kfw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Takkha inthei-inlang khuopuikhan siro, halli nang in angtakme nathosik namindik inte.” ");
INSERT INTO kfw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Halli amale inruoiya kasi mi ngai khan rasachu injetli mi inkhat-um inmumakpha, chongrilleiya in-ngirjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Halli Saul neipilla inphut hong-intheiya amit hongmakek pha, phur inkhat-um mumakjei, inmani'n amakha inkeiphiat ah Damascus inluutpui jei. ");
INSERT INTO kfw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ama nithum katung iteii leimumak, halli bak-inleiya aleiom. ");
INSERT INTO kfw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Halli Damascus ah siamruoi araming Ananias inti inkhat aleiom, Pumi'n mangtalarra amadiang arilla, “Ananias!” “Hin Kei kaom, Pumi,” ama'n aleimasang. ");
INSERT INTO kfw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Pumi'n amadiang ati, “Inthei-inlang, Akatuun inti Lam khan siro, Judas inn khan Tarsus ah inphut araming Saul inti pa-kha jo-entokro, ajarchu, enro, ama Pathian diang aniya om, ");
INSERT INTO kfw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","halli araming Ananias intia inkoi mi inkhat hongluut ah ama'n amunasik akut achungnga iduongpisik kha mangtalarra aleimu.” ");
INSERT INTO kfw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias in amasangnga, “Pumi, hiwa mipa jarra, ama'n Jerusalemma nami ngaidiang angtuk kathamak ithokha mi angjet in kei diang inril kei'n kajetjei, ");
INSERT INTO kfw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","halli Damascus ah naraming kakoi ngaiseng kasur-kamansik ah thiampu kalian ngai diangnga inphut thomatorna ranakle inruoiya kijuo eii.” ");
INSERT INTO kfw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pumi'n amadiang ati, “Siro, ajarchu kei'n amakha kei sepa kathosik Zaatlop le Reng ngaidiang khat-um Israel mi ngaidiang karaming kaminjetsik ah kikadang ejei. ");
INSERT INTO kfw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ajarchu ama'n keisibit ah angtuk kapoong adeisikme tikha kei'n amadiang minmukate.” ");
INSERT INTO kfw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Khawa jarra Ananias asiya inn khan aluut jei, halli akut kha achungnga aduongpiya ati, “Kasappui Saul,” nang in namu nasik khat-um Ratha Inthiang nasip nasik, “Pumi'n, tichu nang naheiwona lamma nangdiangnga inlar Jisu tak-in, keihi anaheitir.” ");
INSERT INTO kfw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Khawalai-takkhan ngalip ka-ang lekkhat amit ah inphut ajuotajei, halli ama amunookjei, ama intheiya baptize athojei. ");
INSERT INTO kfw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ama'n bu abaksuo pha aranak ahongngarjei. Saul in Damascus ah siamruoi ngaile inruoiya nikhuo lekkhat inleiom suom. ");
INSERT INTO kfw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Khanna inphut ama'n synagogue rakip asiya Jisu hi, tichu Pathian Sapa eii tia karil aleiphutjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Takkha akajet rakip in inngak ah inlei-inkel, Jerusalemma Jisu raming kakoi ngai kathat mi kha emak abe? halli ama'n hiwa mi ngai surliya thiampu kalian ngaidiang ruoinasik jartak ah hinna ijuo emak abe? ");
INSERT INTO kfw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Takkha Saul in ranak kaneiya chongkha arilla, hiwahi Christa Jisu kha eii ti aril mincheenpha, Damascus ah kaom Jihudi mi ngaikha masangdan leijetmujei. ");
INSERT INTO kfw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Khawa suonuk nikhuo angjet thengsuo pha, Jihudi ngai'n ininchunna Saul kha thatnasik inminsuukjei, ");
INSERT INTO kfw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","takkha inmani'n inminsuuk chuon kha Saul in aleijet, halli inmani'n ama thatnasik ah suun li zaan rakip khuopui suongkuung khannum inleimaruongjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Takkha ama siamruoi ngaikhan zaanna, inruoiya kok inkhat suungnga inthunli amakha rapal kaangkhattiang inleimachumjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul in Jerusalemma aheiwapha, siamruoi ngaile inchunnasik aleingaidon, takkha ama siamruoi ejei ti ngamnamu ah inmani rakip in amakha inleichi. ");
INSERT INTO kfw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Takkha Barnabas in amakha asanna tirton ngai koolla aruoiya, ama'n angtho-thoa lamma Pumi kha intongpui, Pumi le ama angtho-thoa in-inbiak, khat-um ama'n angtho-thoa Jisu ramingnga Damascus khan kangamtak ah chong iril, inmani diang inthiangnga arilpi jei. ");
INSERT INTO kfw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Halli Saul in inmanile inruoiya Pumi ramingnga kangamtak ah Jerusalem khan inluut insuok ah chongkha inleiril. ");
INSERT INTO kfw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Halli ama'n kangamtak ah Greek chongkaril Jihudi ngaikha alei-inbiakpui, takkha inmani'n amakha thatnasik inleitho. ");
INSERT INTO kfw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Akangamna ngaikhan hiwa jarhi injetpha, Saul kha Caesarea tiang inruoiya, halli amakha Tarsus tiang inleitirjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Khawa jarra Judea, Galilee, khat-um Samaria rampumpuiya koisuok rakip kahoi-kadai leiminmumu, halli Ratha Inthiang in asan jarra Pumi kayana ringkhuo khan inringnga, khella inhongpungjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter in ram rakip khan aleisi, halli Lydda ah Pathian mi kaom ngaidiang khannum aphakhat akapha aleisi. ");
INSERT INTO kfw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Halli khawa munkhan araming Aeneas inti, kum riat zaalmunna intheileiya kazaal, apum kaangkhat kathiya kana mi inkhat alei-intongpui. ");
INSERT INTO kfw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Halli Peter in amadiang ati, “Aeneas,” “Jisu Christa in nang anamindamjei, inthei-inlang nazaalmun inbooltaro.” Halli khawa phatak khan ama intheijei. ");
INSERT INTO kfw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lydda khat-um Sharonna kaom mi rakip in amakha inmujei, halli inmani Pumi diangkhan inhei-inlet jei. ");
INSERT INTO kfw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa ah araming Tabitha, nimaletli Greek chongnga Dorcas inti numeisa siamruoi inkhat aleiom; ama'n apha rakip chuonkatha atho khat-um sara ngai aleisan. ");
INSERT INTO kfw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Khawapha khan numeisanu kha ana ah athi jei, halli inmani'n amakha tui-inminbuolla chung inn khan inminzaal jei. ");
INSERT INTO kfw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Halli Joppa hi Lydda ah inphut kalaakthei emak jarra, Joppa ah kaom siamruoi ngai'n Peter kha Lydda ah om ti injetpha, keini diang innot ah naheiwapiro tia, miring inni inleitir. ");
INSERT INTO kfw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Khawakhan Peter intheiya inmanile inheiwa jei. Ama'n aheitung pha, amakha chung inn tiang khan inruoijei, khawakhan chuulmei rakip in inchap ah Dorcas in inmanile inlei-omlaiya songkol khat-um puondiar ileikathui ngaikha inmalarra akoolla inleingir. ");
INSERT INTO kfw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Takkha Peter in inmani rakip aminsuok ah, kemurkhup thep ah nina aleinei, halli apumtiang khan ahei-inlet ah ati, “Tabitha, intheiro!” khawa phakhan ama'n amit hongmakek jei, Peter kha amuwa intheiya ahong in-ongjei. ");
INSERT INTO kfw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Halli Peter in akut ama-ouwa amakha akeitheijei. Khawakhan ama'n Pathian kangamna ngaile chuulmei ngaikha akoiya amakha aminringnga apejei. ");
INSERT INTO kfw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Hiwa chonghi Joppa pumpui inthangnga, mi katamtak in Pumi kha in-inngamnajei. ");
INSERT INTO kfw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Joppa khan Peter in nikhuo kasoottak sawun kanotpa araming Simon intipale aleiom. ");
INSERT INTO kfw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Caesarea ah “Italian intiya injetna Rome raalmi rahooi” rajakhat ngai lamkakei araming Cornelius inti miring inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Amachu ama innsuung mi ngai rakiple inruoiya Pathian kangamna, Pathian kachi, mi ngaidiang kasan, khat-um apha rakip ah Pathian diang kani alei-eii. ");
INSERT INTO kfw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nisuokhat kholeitiang phadan inthum pheiwei khan mangtalar inkhat aleimu Pathian marwaan tirton inkhat ajuoa amadiang “Cornelius!” tia ajuokoi. ");
INSERT INTO kfw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ama'n marwaan tirton kha a-enpha, achiya ati, “Angme hi, Pumi?” Marwaan tirton khan amasangnga, “Pathian in nang nina khat-um napetheina rakip kha anajetpijei. ");
INSERT INTO kfw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Halli tuun mi inkhat araming Simon Peter inti kakoi sik ah, Joppa ah mi lekkhat tirro. ");
INSERT INTO kfw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Amakha Simon inti sawun kanotpa inn khan atungnga aom, ama innchu tuipui khamma a-eii.” ");
INSERT INTO kfw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Khawasuo marwan tirton kha asijei, halli Cornelius in a-inn khan suok inni khat li ama sepa thosik ah ka-ngaakchak ah kaom raalmi Pathian kangamna inkhat kha akoiya, ");
INSERT INTO kfw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","inmani diang angme kasuok rakip amindik ah, Joppa tiang khan inmani aleitirjei. ");
INSERT INTO kfw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ziingkhuo awarli, inmani'n Joppa khopui inheinaipha, phadan kuruk suunchim pheiwei khan Peter kani sik ah innchungnga aleikal, ");
INSERT INTO kfw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","halli ama awon chaamma, bu ahongbak zootjei, takkha inmani'n baksik inboollai khan ama'n mangtalar inkhat aleimu. ");
INSERT INTO kfw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ama'n marwaan inlong halli puon kaloktak ka-ang phur inkhat, khawa raki miliya inkhit ah, nuoipilchungnga injuomata ama'n aleimu. ");
INSERT INTO kfw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Khawa suung khan nuoipilchungnga akeii mili indou khouring ngai, nuoipilla intoot ah kasi khouring ngai, khat-um chungnga wa ngai alei-inchel. ");
INSERT INTO kfw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Amadiang rasa inkhat in, “Intheiro, Peter; that inlang eiro ati!” ");
INSERT INTO kfw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Takkha Peter in arilla, “Khawakha emarase, Pumi! Kei angtikniteii inthiangmak akachok phur bakngaimong.” ");
INSERT INTO kfw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Halli rasa khan inlet ah amadiang arilnok ah, “Pathian in inthiang jei itikha nang in kachok eii timaro.” ");
INSERT INTO kfw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hiwahi woithum katung asuokli, phurthunna kha marwaan tiang akeikir jei. ");
INSERT INTO kfw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter in imu mangtalar kha angme tia atheinuo ah angaidonlai, enru, Cornelius in iheitir mi ngai khan simon inn inratok ah inmani suongkot kuung khan inhongngir jei, ");
INSERT INTO kfw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","halli inmani'n inkoisuok ah, “Simon Peter intipa ombe tia inhongrakel?” ");
INSERT INTO kfw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter in imu mangtalar kha angaidonna aomlai khan, Ratha in ama diang ati, “Enro! miring inthum in nangkha inna-entok. ");
INSERT INTO kfw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Khawa jarra inthei-inlang suokro, iteii ngamsamna omleiya inmanile inruoiya siro, ajarchu Kei'n inmani kiheitir eii.” ");
INSERT INTO kfw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Khawa phakhan Peter in asuok ah inmani diang ati, “Nangni'n ningratok mi kha kei ka-eii, angjarrame nangni'n ninghong?” ");
INSERT INTO kfw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Inmani'n inleimasang, “Raalmi rajakhat lamkakei Cornelius naheitir kin eii,” “Ama mi kadiktak Jihudi mi ngaiseng in inkaya khet, Pathian chubei katho inkhat eii. Ama'n nang iril chong rangai nasik ah nang kanakoi sik, Pathian marwan tirton inkhat in arilpiya eii,” inti. ");
INSERT INTO kfw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter in inmani akoiluut ah khawani zaan inleiriakjei. Ziingkhuo awarli ama intheiya inmani nuk ajuijei, halli Joppa ah Pathian ka-ngamna lekkhat amale inlei-inruoi. ");
INSERT INTO kfw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ziingkhuo awar pha inmani Caesarea intung pha, Cornelius in asap-asuon ngai khat-um a-innsuung mi ngaiseng akoiya inmani kha aleingaak. ");
INSERT INTO kfw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter in hin aheiluut pha, Cornelius in aleidonna, amaikuungnga inbok ah halli amakha chubei aleitho. ");
INSERT INTO kfw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peter in amakha akeitheiya, “Ngirro,” “Kei-um miring inkhat ka-eii,” ati. ");
INSERT INTO kfw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Halli ama'n hin Cornelius le in-inbiak tirra innsuung inheiluut pha, mi katamtak inlei-intuup ajuomujei. ");
INSERT INTO kfw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Khawakhan ama'n inmani diang ati, “Jihudi inkhat in zaatlop inkhatle inchunsik emakli inluut sik hi angtuk chongpeii kakoime ti nangni ningjet; takkha kei'n tu-inkhat um akachok emakli inthiangmak eii timaknasik Pathian in kei kadiang anaminmujei. ");
INSERT INTO kfw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Hiwa jarra kanakoi mi naheitir pha zootmak omleiya kei'n kahong jei, Khawa jarra kei'n kinarakel eii, kanakoi angsikme ninghei tirhi?” ");
INSERT INTO kfw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius in arilla, “Nithum matiang kei'n ka-inn khan kholei phadan inthumma Pathian nina hiwa phadantak hin kaleinei, halli, enro, puon kachek kasil mi inkhat kamaikuungnga ahongirra ati, ");
INSERT INTO kfw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Cornelius, Pathian in nanina kha anajetpijei, khat-um napena kha Pathian in anajetpijei. ");
INSERT INTO kfw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Araming Simon Peter inti mi inkhat kakoisik ah Joppa ah mi tirro, ama tuipui khamma kaom sawun kanotpa Simon inn khan atungnga aom.’ ");
INSERT INTO kfw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Halli innot ah nang karatok kaheitirli, nang in nazoot ah nahong jei. Tuunchu keini rakip in nang diang Pumi'n keini diang rilro tia inapeii chong ngaikha karangai sik Pathian maikuungnga kinna ngaak ah kinom jei.” ");
INSERT INTO kfw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peter in chongkaril aphut ah, ati, “Pathian in mi rakip hi amin angrip ah a-en tihi atuun kei'n kajet.” ");
INSERT INTO kfw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Halli zaat rakip ah ama kachi khat-um akatuun katho mi rakip ngaikha ama'n aralaang. ");
INSERT INTO kfw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Jisu Christa jarra akadai akatha chongkha inrilla, Pathian ama'n Israel mi ngaidiang achong kha juotir jei (amachu angrakip Pumi eii). ");
INSERT INTO kfw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","John in baptize thona chong arilsuonuk Galileeya inphut Judea rampumpui phuonna inril chong kha nangni'n ningjet, ");
INSERT INTO kfw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pathian in angtho-thoa Nazareth Jisu chungnga Ratha Inthiang li ranak ah sariak ikanoot kha nangni'n ningjet, ama'n amun rakip ah asiya Pathian inruoipuina jarra seitan ranak nuoiya kaom ngai amindam halli chuon katha aleitho. ");
INSERT INTO kfw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Halli ama'n Judea ramma, Jerusalemma ileitho chuon rakip ngai sakhi kha keini kin-eii; halli inmani'n amakha cross chungnga inmakaiya inthatjei. ");
INSERT INTO kfw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Takkha Pathian in amakha nithumni ahongminringnga ahongmalar jei, ");
INSERT INTO kfw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","mi rakip chungnga chu emak, takkha Pathian in ileikadangsa sakhi kape ngaidiang eii, tichu, Pumi in thiya inphut ahongringsuo nuk ibakpui-i-inpuisuom ngai keini kin-eii. ");
INSERT INTO kfw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Halli mi ngai diangnga chong karilpi sik, khat-um akaring ngaili akathi ngaisik ah chongkatanpa imin-eii kha Pumi hi-eii ti sakhi kapesik ah, ama'n keini diang chongkha anapejei. ");
INSERT INTO kfw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pathian chongkachoi rakip in ama jarra sakhi inleipeya inti, tichu, “Tu e-innum ama kangamna mi rakip in inmanu ngaikha ama raming khan angaidam sik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter in arillaitak, ama chong karangai rakip chungnga Ratha Inthiang kha ajuochumjei. ");
INSERT INTO kfw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Halli Joppa ah inphut Peter le inruoiya heikawa in-ngamna kanei wunkatan mi ngaikhan inleingakjei, ajarchu zaatlop ngai chungnga um Ratha Inthiang kutchoi kha Pathian in apejei. ");
INSERT INTO kfw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ajarchu inmani'n aleiilak chongnga inril khat-um Pathian lianna inminpaak kha inmani'n inleijet. Peter in ahongti, ");
INSERT INTO kfw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Eini'n Ratha Inthiang nineijei angnga inmani um inneijei, khawa jarra inmanihi tuiya baptize minthomak nasik tu-inme asur matorsik?” ");
INSERT INTO kfw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Khawa jarra inmani kha Jisu Christa ramingnga baptize thopinasik ama'n chongpe apejei. Khawakhan inmani le nikhuo lekkhat omdirui intia ama diang inleiti. ");
INSERT INTO kfw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Zaatlop ngai innum Pathian chongkha inkeiluutjei tikha tirton ngai khat-um Judea ramma kaom ule-nai rakip in injetjei. ");
INSERT INTO kfw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peter in Jerusalemma ahongluutpha, wunkatan rahooi ngaikhan amale murruolsiak inthoa inti, ");
INSERT INTO kfw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Nang in wunkatanmak mi ngai innkhan naluutli inmanile nabaksuom!” ");
INSERT INTO kfw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Khawa jarra Peter in inmani diang inphutna makheiya akasuok omchan rakip jarra arilpiya ati: ");
INSERT INTO kfw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kei'n Joppa khuopuiya Pathian kaniya kaomlai, mangtalar inkhat tichu, Puon kaloktak ka-ang phurthunna inkhat, araki miliya inkhit ah marwaanna inphut juokata kha kei'n kaleimu, halli khawakha kakoolla ajuongir. ");
INSERT INTO kfw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Khawakha kei'n katha ah ka-enna, kangaidonna kaomlai, akeii mili indou innsa, ramsa, intoot ah kasi, khat-um chungnga wa ngai kei'n kaleimu. ");
INSERT INTO kfw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Khawakhan, ‘Intheiro, Peter; that inlang eiro,’ kati rasa inkhat kei'n kajet! ");
INSERT INTO kfw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Takkha kei'n kati, ‘Khawakha emarase, Pumi! Ajarchu kachok emakli inthiangmak phur kabaiya suplathun lathun ngaimong.’ ");
INSERT INTO kfw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Takkha rasa khan marwaanna inphut arilnook ah, ‘Pathian in iminthiang kha nang in akachok eii ti-inlang ngaidonmaro.’ ");
INSERT INTO kfw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hiwahi woithum chak aleisuok, halli khawa rakip kha marwaantiang akeikir jei. ");
INSERT INTO kfw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Khawapha takkhan Caesarea ah inphut iheitir miring inthum ngai'n kaomna inn kha inheitungjei. ");
INSERT INTO kfw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Halli Ratha khan keidiang in-ngamsam omleiya inmanile inruoiya siru ati. Khawale inruoiya Joppa ah ule-nai kuruk hi keile kin-inruoiya, keini'n Cornelius innkhan kinleiluut. ");
INSERT INTO kfw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Khawakhan ama'n angtho-thoa imume tikha keini diang anarilpi jei, tichu, marwaan tirton khan ama innsuungnga angirra ati, Joppa ah araming Peter inti Simon kha kakoisik mi tirro. ");
INSERT INTO kfw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ama'n nang nadiang chongkha narilpita, halli khawa chongkhan nangle na-innsuung mirakip in ringna ningmusik eii. ");
INSERT INTO kfw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Eini chungnga ma-insa ah Ratha inthiang ileijuo angnga, kei'n chongril kaphut pha, Ratha Inthiang kha inmani chungnga um ajuojei. ");
INSERT INTO kfw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Khawakhan, ‘John inchu tuiya baptize aleitho, takkha nangnichu Ratha Inthiang khan baptize kanathopisik eii tia Pumi'n ileiril chongkha kei'n ka-ngaidonjei.’ ");
INSERT INTO kfw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Khawa jarra eini'n Pumi Jisu Christa kha ni-inngamna pha, Pathian in eini diang-um inmani diang-um in-angrip khutchoi nape inchu, kei tu kalei eya Pathian hi kasurmator sikme?” ");
INSERT INTO kfw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Hiwahi inmani'n inrangai pha, inlei-omchian jei, Pathian kha inminpaak ah inti, “Pathian in zaatlop ngai-um malung thuulla ringna sik-ah azootpijei.” ");
INSERT INTO kfw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tuunchu Stephen chungnga akasuok poongna ngaikhan ajar eya inchek-chai kangamna lekkhat ngai'n Jihudi ngaidiang bit, (aleiilak ngaidiang ka-emak), chongkha inrilpiya Phoenicia, Cyprus, khat-um Antioch katungnga inleisijei. ");
INSERT INTO kfw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Takkha inmani karra lekkhatchu Cyprus khat-um Cyrene mi in-eii, inmani'n Antioch ah inheiwa ah, Greek ngaidiang um Pumi Jisu chong katha kha inleirilpijei. ");
INSERT INTO kfw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Pumi ranak khan inmani kha alei-inruoipui, halli mi katam khat in in-ngamna ah Pumi diang inhei-inletjei. ");
INSERT INTO kfw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Halli inmani jarra chongkha Jerusalemma kaom koisuok ngai'n injetpha, inmani'n Barnabas kha Antioch katung inleitir. ");
INSERT INTO kfw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ama'n atung pha, Pathian rawaan ipe ngaikha amuwa, aleirokpui, halli inmani rakip malung inthiangnga Pumi diang inchatleiya omnasik aleimasok. ");
INSERT INTO kfw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ajarchu Barnabas hi akatha, Ratha Inthiang kasip khat-um kangamna miring inkhat eii, halli mi katamtak Pumi diang aheiruoi. ");
INSERT INTO kfw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Khawasuo khan Barnabas in Saul kha ka-entok sik Tarsus katung aleisijei, ");
INSERT INTO kfw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","halli ama'n Saul kha amupha, Antioch ah aheiruoijei. Han inmani'n kumkhat katung koisuok ngaile inruoiya in-inchunna, mi katamtak ngaikha inleiminchujei, halli Antioch ah kaom siamruoi ngaikha ma-insakhet Christian tia inkoijei. ");
INSERT INTO kfw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Khawapha takkhan Jerusalemma inphut Pathian chongkachoi ngaikha Antioch ah inleisi. ");
INSERT INTO kfw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Halli inmani ngai karra araming Agabus inti inkhat intheiya, nuoipil pumpuiya bukawaang alasuoksik eii tia Ratha khan aleiminrilsuok, khawakha Claudius Caesar phakhan aleisuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Khawapha Judea ah kaom ule-nai mi rakip sannasik ama-ama imator dungjuiya tirnasik siamruoi ngai'n inlei-inzootnajei. ");
INSERT INTO kfw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Inmani'n khawakha inthoa, Barnabas khat-um saul kutchungnga sial kha inmathuonna koisuok upa ngaidiang inleimintungjei. ");
INSERT INTO kfw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Khawa phakhan Reng Herod in koisuok mi lekkhat minpoong-minraalna aleiphutjei. ");
INSERT INTO kfw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Halli ama'n John upa James kha chemma atukthat jei. ");
INSERT INTO kfw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ama'n khawa itho khan Jihudi ngai malung ataijei ti amu phakhan, Peter um ama'n aminsurjei. Khawa kha chol inchelmak waipool bakna kahoi phakhan aleisuok. ");
INSERT INTO kfw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Halli ama'n Peter kha asurpha, mikhumna khan ada-ah, raalmi mili mili in rupmili suok-ah amakha ngaaknasik aleipeii. Ajarchu Herod in Jihudi ngai rakaanna kahoi suoli amakha mi ngai maikuungnga keisuo sik-ah aleingaidon. ");
INSERT INTO kfw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Khawa jarra Peter mikhumna khan inleida, takkha amasik bit-ah koisuok mi ngai'n Pathian diang malung kaluut ah inleinipi. ");
INSERT INTO kfw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod in Peter kha mipui maikuungnga akeisuosik ni zaan takkhan, raalmi inni ngai kongkarra Peter kha thirrui inniya inkhit-ah aleizaal, halli raalpa ngaikhan mikhumna kotkhan inleingaak. ");
INSERT INTO kfw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Enro, Pumi tirton inkhat in akoolla angir jei, halli war inkhat in mikhumna innsuung kha awarjei, marwaan tirton khan Peter darkhoi kha kanik ah akeithei li ati, “Innot-ah intheiro!” khawapha takkhan akut-ah inkhit thirrui kha atajei. ");
INSERT INTO kfw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Marwaan tirton khan amadiang ati, “Nakoongkhit kha inkhittro, halli nakekok chuongro.” Peter in khawatak kha athojei, halli ama'n ati, “Napuon sil-inlang kei naheijuiro.” ");
INSERT INTO kfw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Halli ama'n aheisuok ah anuk aleijui jei, khat-um marwaan tirton ithokha inthiangtak eii ti jetleiya ama'n mangtalar inkhat kimu eii tia aleingaidon. ");
INSERT INTO kfw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Inmani'n ma-insa khat-um inni changna kot kangaak ngaikha inheikheella, khuopui inheiluutna thirkot kha inheitung, halli innkhar kha atheinuo ah alei-inlongjei, halli inmani inheisuok ah, lampui khan inheiwa, halli jetlei-theileiya marwaan tirton in Peter kha ada-ah asijei. ");
INSERT INTO kfw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter in apumtak ah akasuok kha ajet-ah ati, “Tuunchu kei'n inthiangnga kajetjei, tichu, Pumi'n ama tirton anajuotirpiya, keihi Herod kut-ah inphut khat-um Jihudi ngai ileingaidonna inphut anasanring jei.” ");
INSERT INTO kfw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ama'n hiwahi angaidon pha, araming Mark inti John nu Mary inna aheiwa; khawakhan mi katam khatchu in-inchunna Pathian inleini. ");
INSERT INTO kfw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Hanna Peter in tuoltiang innkhar khan arakhoongpha, Rhoda inti suok nungaak inkhat in kamalong aheiwa. ");
INSERT INTO kfw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ama'n Peter rasa eii ti ajetpha, arok-hiaiya innkharchu malongleiya, ama'n ataanna, Peter innkhar kuungnga angirra omjei tia ajuorilpi. ");
INSERT INTO kfw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Khawakhan inmani'n amadiang inti, “Nang na-inweetjei!” Takkha ama'n kheella hiwahi kadiktak eii tia aleiril. Khawakhan inmani'n inti, “Hiwahi ama tirton eii.” ");
INSERT INTO kfw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Takkha Peter in innkhar kha rakhoongnga aleiom, halli inmani'n innkhar kha inmalongpha, Peter kha inmuwa inleingakjei. ");
INSERT INTO kfw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Takkha ama'n inmani kha omchian nasik akut zaap ah, Pumi in ama kha angtho-thoa mikhumna ah inphut iheikeisuome itikha inmani diang aleirilpijei. Halli ama'n ati, “Hiwahi James khat-um a-u-anai ngaidiang juorilpiru,” Khawa suoli ama'n asuok ah munkhattiang asijei. ");
INSERT INTO kfw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Khuo hongwarpha Peter diang angme kasuokjei tia raalmingai karra inhaangna asuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Halli Herod in ama entoknasik chong aleipeii, takkha inmumak pha, akangaak ngaikha ama'n chong rakella, inmani kha thatnasik-ah chong aleipejei. Khawasuo, ama'n Judea amathaanna Caesarea ah phabongkhat ajuo-om jei. ");
INSERT INTO kfw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod in Tyre khat-um Sidon mi ngaidiang aleiraang thei, khawa jarra inmani'n ininchunna ama inmupui inleisi, ma-insakhet ah reng innsuung ka-ensuipa Blastus kha inmani kasansik ah amalung-inminthuulla, Herod diang inmani'n kadai kahoiya omnasik kani inleisi, ajarchu inmani rengpa ramma inphut bakle-in inleimuwa eii. ");
INSERT INTO kfw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herod in ikadang nikhuo inkhat khan areng puondiar athoa, chongtanna munkhan in-ongnga, inmani diang chong aleiril. ");
INSERT INTO kfw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Halli mi ngaikhan inhongkheek ah, “pathian rasa eii, mi rasa emak!” inti. ");
INSERT INTO kfw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herod in Pathian kha kayamak jarra khawa phatak khan Pumi tirton in amakha awuok purra, ralung ngai'n ama kha in-eiya halli athijei. ");
INSERT INTO kfw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Takkha Pathian chongchu insoonna khat-um loktirra asi. ");
INSERT INTO kfw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas khat-um Saul in inchuon inminhek ah, Mark inti John kha inmanile inruoiya Jerusalemma inphut inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioch koisuok ah kaom Pathian chongkachoi khat-um kaminchu lekkhat inleiom; Barnabas, akawom inti Simeon, Cyrene na inphut Lucius, halli Manaen Herod le hongkalok suom, khat-um Saul. ");
INSERT INTO kfw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Inmani'n bu in-ngeiya Pumi sepa intholai, Ratha Inthiang in ati, “Barnabas le Saul chu kei'n chuonsik kakoijei, khawa jarra inmani keisik bit-ah tuun nathenpiru.” ");
INSERT INTO kfw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Khawa phakhan inmani'n bu in-ngeiya inmani chungnga inkut induongnga, Pathian diang innipili, inmani kha inleitirjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas le Saul kha Ratha Inthiang in atirra, Celeucia tiang insiya; halli khawa makheiya Cyprus tuiram katung rakuong inhongchuong jei. ");
INSERT INTO kfw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Inmani Salamis inhongtungpha, Pathian chongkha Jihudi ngai Synagogue rakip ah inleiril, khawakhan John Mark um inmani kasansik ah inleiruoi. ");
INSERT INTO kfw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Khawasuo inmani'n tuiram rakip inrakaanna Paphos tiang insijei, khawa munkhan mitmalet dooikachoi, Pathian chongkachoi inleem araming Bar-Jisus inti Jihudi mi inkhat inmani'n inlei-intongpui. ");
INSERT INTO kfw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Amachu tuiram waikaroonpa Sergius Paulus inti akasing mipa sap eii, tuiram waikaroonpa khan Barnabas li Saul akoolla aleikoi, ajarchu ama'n Pathian chong alei rangaizoot. ");
INSERT INTO kfw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Takkha Greek chongnga Elymas inti mitmalet dooikachoipa khan, inmani kha insiakpuiya khawa waikaroonpa in-ngamna ah inphut heiminkir nasik alei-entokjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Takkha Paul tia inkoi Saul in Ratha Inthiang asip ah, amadiang katha ah enna ");
INSERT INTO kfw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aleiti, “Nangchu akathamak malungroon rakip kasip, Seitan sapa, akatha rakip kazootmak, akadik Pumi chongkha maleisei lam kamin eii ladanutin be? ");
INSERT INTO kfw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Halli tuun enro, Pumi kutkha nachungnga aom, namit chota apha lekkhat suunwar kha munutinjei.” Khawalai takkhan Elymas suumphai khat-um akaziing in amit leimakhujei, halli ama'n asiya akakeiphiat sik mi alei-entok. ");
INSERT INTO kfw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Waikaroonpa in angme akasuok amu phakhan ama'n angamnajei, ajarchu Pumi jarra minchuna khan alei-ngakjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul khat-um asapngai Paphos makheiya rakuong inhong chuongnga, Pamphylia khuopuiya kaom Perga inhongtungjei, halli John Mark in inmani inthenpuiya Jerusalemma hongkirjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Inmani'n Perga inhong rakaanna Pisidia ah kaom Antioch inhongtungjei; halli inmani'n Jehudi ngai serni khan Synagogue ah inluut ah inlei-in-ong. ");
INSERT INTO kfw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moses Dan khat-um Pathian chongkachoingai larik inteel suonuk Synagogue chuon-karoon ngai'n inmani inheitirra inti, “E ule-nai ngai, nangni'n mimasokna chong ningnei inchu, rilru.” ");
INSERT INTO kfw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Khawakhan Paul in angirra, akut kalek ah aril: “Kasap Israel ngai khat-um Zaatlop Pathian kachi ngai, rangairu.” ");
INSERT INTO kfw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel mi ngai Pathian in eini nipi nipu ngaikha anakadangpi, halli inmani Egypt ramma khomal angnga in-omlai, mi aleiminpung, khat-um inmani kha Pathian raatna kutkhan Egypt ramma inphut aheikeisuok, ");
INSERT INTO kfw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","halli kum soommili katung ama'n neelramma inmani kha aleikeiruoijei. ");
INSERT INTO kfw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Halli ama'n Canaan ramma kaom zaat sari aminmangli, inmani ramkha ama mi ngai ram min-enasik, ");
INSERT INTO kfw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","kum rajamili-le soomra-nga katung ama'n aleipeii. Khawasuo Pathian chongkachoi Samuel pha katung chongtan mapu ngaidiang apejei. ");
INSERT INTO kfw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Inmani'n reng inleini, halli Pathian in inmani diang Benjamin phungnga mi, Kish sapa Saul kha kum soommili sik-ah apejei. ");
INSERT INTO kfw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Khawasuoli ama kha akhaiya, Pathian in David kha inmani reng amin ejei; ama jarra Pathian in sakhi apeya ati, Kei'n Jesse sapa David, kamalungnga kimanuom pasal inkhat kamujei, ama'n kei lungdou rakip athosik eii. ");
INSERT INTO kfw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Hiwa mipa wonchoiya inphut Pathian in kanapesik eii tia chong inkhit angnga Israel ngai kasanringpa Jisu kha ajuojei. ");
INSERT INTO kfw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisu'n achuon aphut makma, John in Israel mi rakip inmalung inthuulla baptize inthosik hi aleirilpijei. ");
INSERT INTO kfw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Halli John in achuon aminhek siktiang ati, Keihi tu eii tia nangni'n ningngaidonme? Keichu ningngaak amakha emong, takkha rangairu, kei kanuk-ah akajuo ama kekok kakhaisik um keichu rahoi suokmong. ");
INSERT INTO kfw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ka-u kanai, Abraham innsuungkhur sangai, khat-um Pathian kachi nangni zaatlop ngai, hiwa sanminringna chonghi einidiang ajuotirjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ajarchu Jerusalemma kaom ngaile inlamkakei ngai'n amakha leijetmu khat-um Jihudi ngai sernikhuo rakip ah inteel Pathian chongkachoi ngai rasa kha injetmak jarra, Jisu kha amasialna innoonna chongkha huui-inmintungjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Halli inmani'n thatnasik ajar amadiang inmumak innum, amakha thatna sik-ah inmani'n Pilate diang inhongni. ");
INSERT INTO kfw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ama jarra chong-inthiang in ileiril rakip kha inmani'n inmintungpha, amakha Cross ah inphut inkeithaak ah, thaanna inreiijei. ");
INSERT INTO kfw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Takkha Pathian in amakha kathiya inphut aminringjei, ");
INSERT INTO kfw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","halli amale Galilee makheiya inphut Jerusalem katung amale hong-inruoi ngaidiang nikhuo angjet lei-inlarjei, tuunchu inmani'n Israel mi ngaidiang ama sakhi kha in-ejei. ");
INSERT INTO kfw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Halli nipi-nipu ngai diangnga chong-inkhitna akatha chongkha keini'n nangni sik-ah kinnahong choipi, ");
INSERT INTO kfw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Pathian in hiwahi einidiang pui mintungjei, tuunchu inmani sa ngaisik ah Jisu hi aminringjei. Hi-angnga inni changna minpaakla khan injia jei, ‘Nang kasapa na-eii; awini kei napa ka-ejei.’ ");
INSERT INTO kfw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Halli Pathian in ngamna kaom ama kha kathiya inphut aminringjei, halli angtikniteii thaanna thu-inlang omnunijei aleiti, ‘Kei'n David diangnga inthiang khat-um incheen rawaan kha nangnidiang kanapesik eii.’ ");
INSERT INTO kfw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Khawa jarra ama innum minpaakla munkhat ah ati, ‘Nang in nasuok Inthiangpa kha kachuoi-kamang minmunutin.’ ");
INSERT INTO kfw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ajarchu David in aringlai Pathian lungdou khan sepa aleitho, halli athijei, apu-apa ngaile inphuumma akaluong kha-um thaanna thuwa inmangjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Takkha Pathian in iminringjei ama diangchu hiwahi suokmak. ");
INSERT INTO kfw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Moses Dan in ingaidam matormak manu kha hiwa Jisu kangamna mi rakip diangchu inmanu rakipkha angaidamjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Khawa jarra kangamna ka-u kanai ngai, hiwahi nangni'n najetpiru, hiwa mipa diangnga inphut manu ngaidamna hi nangnidiang kinril eii. ");
INSERT INTO kfw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Khawa jarra angme Pathian chongkachoi ngai'n inleiti kha nangni chungnga asuokmak nasik insingtheiru, ");
INSERT INTO kfw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Enru, nangni mi-innuipui ngai, ngakru, halli thiru; ajarchu nangni phakhan kei'n chuon inkhat katho; tu ka-ang khat in nangnidiang khawakha anarilcheenpi innum, nangni'n supngam ngamna nutun!’ ” ");
INSERT INTO kfw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul li Barnabas in synagogue ah inheisuokpha, hiwa chongngaihi akahongsik Jihudi ngai sernikhuo khan narilpiru tia mipui ngai'n nina inleinei. ");
INSERT INTO kfw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mipui ngaikhan intuup kha ininthensuo phakhan, Jihudi katamtak khat-um zaatlop katamtak Judaism kaluut ngaikhan Paul li Barnabas inleijuijei. Tirton ngaikhan inmani diang inrilla Pathian riangwaiya ringnasik inmani malung inleimasok. ");
INSERT INTO kfw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Akahong Jihudi ngai sernikhuo khan khuopui suungnga mi katamkhat in Pumi chong karangai sik inhong-inchunjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Takkha Jihudi ngai'n mipui ngaikha inmupha, kara-ot in aleisip, Paul in angme iti chong kha jui-um leijuimu, halli ama kha inlei-minjak. ");
INSERT INTO kfw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Takkha Paul li Barnabas in kachi omleiya inrilla inti, “Nangnidiang mansakhet-ah Pathian chonghi leiril masasik kha eii. Takkha nangni'n zootmak chua hektik kaneimak ringna kamusik kha rahoi suokmung ningtia ningpumtak in ning-ngaidon jarra, enru, keinichu zaatlop ngaidiang kinsijei. ");
INSERT INTO kfw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ajarchu hiwahi Pumi khan keini diangnga inape chongpeii kha eii: ‘Khawa jarra nuoipil pumpui'n ringna munasik-ah, kei'n nangkha zaatlop ngai war ka-esik kanabooljei.’ ” ");
INSERT INTO kfw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Zaatlop ngaikhan hiwahi injetpha, inrok um inrokjei, Pumi chongkha um inleirokpui; halli hektik kaboi ringkhuo sik-ah inkadang rakip in ka-ngamna inhong ejei. ");
INSERT INTO kfw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Halli Pumi chongkha khawa ramtiangnga kaom ram rakip kha aleiphuonjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Khoya intho, Pathian ka-ngamna numeisa khat-um khopui khanna lamkakei pasal ngaikha Jihudi ngai'n Paul khat-um Barnabas chungnga minpoongnasik chong inmasok-ah, inmani ramma inphut inleipuut suokjei. ");
INSERT INTO kfw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tirton ngaikhan inmani chungnga inzootmakna kha inkeiiya rahut inkathingnga Iconium tiang insijei. ");
INSERT INTO kfw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Halli Antoich ah kaom siamruoi ngaikha Ratha Inthiang khat-um karok khan aleisipjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Halli Iconiumma khawale in-angrip ah asuokjei, Paul li Barnabas Jihudi ngai synagogue ah inluut suomma chong inleirilpha, Jihudi khat-um zaatlop mikatamtak in Pathian inleingamna jei. ");
INSERT INTO kfw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Takkha Jihudi ngamna kaneimak ngai'n zaatlop ngaikha inmasok ah kangamna ngai chungnga kathamak inleimasuok. ");
INSERT INTO kfw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Khawa jarra tirton ngai'n Pumi jarra kachi omleiya chong inrilla khawakhan apha kasoottak inleiom, inmani khan jetnasik khat-um inlak-inlak ngaikha aminthoa Pathian riangwai hi adik ti sakhi inleipeii. ");
INSERT INTO kfw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Khawa khuopuiya mi ngaikha inlei-inthenjei, lekkhat in Jihudi ngai khat-um lekkhat in tirton ngai injuijei. ");
INSERT INTO kfw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Halli zaatlop ngai khat-um Jihudi ngai'n inmani lamkakei ngai khale ininchunna, tirton ngaikha minjaknasik li lungnga deengnasik inngaidon kha, ");
INSERT INTO kfw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","inmani'n injet-ah, Lycaonia khuopui Lystra, Derbe khat-um asir-apangnga kaom ram ngaikhan inleitaanjei, ");
INSERT INTO kfw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","khawakhan inmani'n chongkatha kha inleiril. ");
INSERT INTO kfw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra ah akeii insial, anu'n neiya inphut akeii kakiak, kasitheimak pasal inkhat aleiom: ");
INSERT INTO kfw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","hiwa pasalpa'n in-ongnga Paul chongril kha aleirangai, namindam matorte tia inngamna kha Paul in amu jarra amadiang katha ah alei-en, ");
INSERT INTO kfw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","rasa inringnga ati, “Nakeii khan katuunna ngirro!” halli ama'n inchoomma asi-ahongjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Halli Paul in angme ithokha mipui'n inmupha, Lycaonia chongnga, “pathian ngai'n miring inhong angnga einidiang injuochum jei tia, rasa inringnga inhong-oong!” ");
INSERT INTO kfw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Halli inmani'n Barnabas kha Jupiter khat-um Paul in, chongkaril kalian ejarra, Hermes tia inkoi inphutjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jupiter pathian biak-inn kha khuopui raaltiang omjarra thiampu'n saraatchal khat-um reirui ngaikha, suongkuung khan inhongchoiya, amale mipui ngai'n tirton ngaikha chubei kathosik inleimanuomjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tirton, Barnabas khat-um Paul in khawa injetpha inpuon inkatherra mipui karra inluut-ah inhongkheek, ");
INSERT INTO kfw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Angsikme hiwahi nangni'n ningtho? keini-um nangni ka-ang miring kin-eii, marwaanle nuoipil halli tuipui asuungnga kaom rakip kabool akaring Pathian diang, hiwa anemna kaboi omchanna inphut heikirnasik, keini chongkahoi karilsik hin kinhong eii. ");
INSERT INTO kfw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Akatheng khang khan Pumi'n zaat rakipkha inlungdou lamma sinasik azootpijei. ");
INSERT INTO kfw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Takkha Pumi ama sakhi omleiya leidamak, Pumi ama'n akatha chuon athopiya marwaanna inphut ruo khat-um ansia-suulpa kara esik kumli tha apejei, halli bakphur le karok khan nangni malung amintaijei. ");
INSERT INTO kfw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Hiwa chong ngaihi tirton ngai'n inrilpiya khadengnga chubei thosik-ah inphut mipui ngaikha inleikhaapjei.” ");
INSERT INTO kfw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pisidia ah kaom Antioch khat-um Iconiumma kaom Jihudi ngai'n khawa munkhan inhongnga, halli inmani'n mipui ngaikha inmasok-ah, Paul kha lungnga indeengnga, ama athijei tia, khuopui raaltiang amakha inleikeisuo. ");
INSERT INTO kfw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Takkha asiamruoi ngaikhan asirra inngirlai, ama'n intheiya, khuopui khan aluut jei, halli ziingkhuo ahongwarli Barnabas le inruoiya Derbe tiang insijei. ");
INSERT INTO kfw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Halli inmani'n khuopui khan Chong Kahoi inrilla siamruoi katamtak inboolli, Lystra, Iconium, khat-um Antioch ah inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Kangamna ngaikha malung inminngar piya, in-inngamna khan katuunna inchatleiya in-omnasik inmani inmasok-ah, poongraalna angjetle inruoiya eini'n Pathian Rengram hi niluutsik ejei tia inleiminchu. ");
INSERT INTO kfw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Khat-um inmani'n koisuok rakip ah uparup inkadangnga, bu-ngei khat-um nipinale inruoiya inmani'n kangamna ngaikha Pumi diang inleipeluutjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Halli inmani'n Pisidia inrakaanna Pamphylia tiang inhongjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Inmani'n Perga khan Pathian chong inleirilli, Attalia tiangkhan inchumjei, ");
INSERT INTO kfw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","khawa makheiya inchuon kha inmatorra Pathian riangwaiya inmani inheitirna mun, Antioch tiang rakuong inchuongnga inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Halli inmani'n Antioch inheitungpha koisuok mi ngai inkoichunna, Pathian in inmanile inruoiya ileitho chuon rakip khat-um zaatlop ngaisik Pumi in ngamna kot malongpijei tia inmani diang inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Halli khawakhan siamruoi ngaile inruoiya apha kasoottak inleiom jei. ");
INSERT INTO kfw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Takkha mi lekkhat Judea ah inphut Antioch khan inheiwa, “Moses Dan dungjuiya wun-intanmak inchu, nangni'n ringna munutun, intia kangamna ngaidiang kaninchu inleiphut.” ");
INSERT INTO kfw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paul li Barnabas in inmanile murruolsiak kana ah inleithopha, hiwajarra chong inkelnasik Paul, Barnabas khat-um inmani karra tuka-ang lekkhat tirton ngaili uparup ngaidiang Jerusalemma sinasik inleikadangjei. ");
INSERT INTO kfw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Khawa jarra koisuok ngai'n inmani kha inlamtiang inheithak ah, zaatlop ngai'n Pathian diang angtho-thoa inhei-inletme ti inmani'n inriltirra Phoenicia khat-um Samaria inheirakaan, halli hiwa chonghin kangamna rakip ngaikha karok in aleiminsip. ");
INSERT INTO kfw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Inmani'n Jerusalem inheitungpha, koisuok, tirton ngai khat-um uparup ngai'n inmani kha inleiralaangjei, halli Pathian in inchungnga ithopi chuon rakip inmani diang inleirilpijei. ");
INSERT INTO kfw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Takkha kangamna Pharisee rup lekkhat inhong-ngirra, “Zaatlop ngai'n wun-intansik khat-um Moses Dan kha injuisik hi nitipisik eii,” inheiti. ");
INSERT INTO kfw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tirton ngai khat-um uparup ngai'n hiwa chongrakel jarra inbiak nasik inlei-inchunjei. ");
INSERT INTO kfw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kasoottak inlei-inseii suopha, Peter in angirra inmani diang ati, “E kasap ngai, zaatlop ngai'n kamursuo ah inphut akatha chong inrangaili inngamnasik, keihi matiang khan Pathian in nakadangjei tihi nangni'n ningjet. ");
INSERT INTO kfw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Halli malung-ngaidon kanajetpi Pathian in eini diangnga inaleithopi angnga zaatlop diang-um azootpina Ratha Inthiang kha ajuopejei. ");
INSERT INTO kfw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Halli ngamna jarra inmani malung aminthiangpiya, Ama'n einili inmani karra iteii um inteina min-ommakjei. ");
INSERT INTO kfw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Khawa jarra tuun eini nipi-nipu ngai innum inchoi matormak phurrik kha siamruoi ngai chungnga ningminchanna, angsik ah Pathian kha ensinna ningneime? ");
INSERT INTO kfw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Emak! Pumi Jisu riangwaiya eini um inmani um ningamna jarra niringsik eii,” ati. ");
INSERT INTO kfw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Halli mipui rakip in inlei-omchianna; inmani'n Barnabas khat-um Paul jarra zaatlop ngai karra Pathian in chuon inlak ileitho kha inmani inni'n inleirilsuok kha inleirangai. ");
INSERT INTO kfw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Inmani'n inrilsuo pha, James in aleimasang, kasap ngai, kachong nara-ngaipiru: ");
INSERT INTO kfw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pathian in ama ramingsik ah Zaatlop ngai diangnga mi lekkhat akeisuo ah ma-insakhet ah angtho-thoa ilei-enme tikha Simon in inthiangnga aleirilpijei. ");
INSERT INTO kfw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pathian chongkachoi ngai chong le hiwahi in-ang; tichu chong inthiang in hinthoa aril, ");
INSERT INTO kfw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Hiwasuoli kei kajuokirsik eii, Pumi'n ati, halli David rengram kha kakeitheisik eii. Kei'n akamang ngaikha kasak tharsik eii halli kaminngir tharnooksik eii. ");
INSERT INTO kfw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Khawa jarra leiilak miring rakip innum Pumi kha in-entoksik eii, zaatlop rakip ngaikha keisik ah kakoijei. ");
INSERT INTO kfw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Matiangnga inphut anakaminjet Pumi khan ati. ");
INSERT INTO kfw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Khawa jarra hiwahi kei ingaidon eii,” James in arilla, Zaatlop ngai karra Pathian diang heikaluut inmani kha eini'n minpoongmui; ");
INSERT INTO kfw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","takkha kutbool pathian diangnga inpe inthiangmak phur, zool-inthai, inkhitthat sa, emakli thisen ka-in kabak rakip makheiya inchelmaknasik eini'n inmani diang chemajia kha majiadirui. ");
INSERT INTO kfw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ajarchu tianlaiya inphut khuopui rakip ah Moses Dan karil ngai'n inleiril halli Jihudi ngai serni rakip synagogue ah inleiteel. ");
INSERT INTO kfw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Khawapha inmani ngai karra lamkakei ngaikhan, araming nitia, Barsabbas inti Judas khat-um Silas kha, inkadangnga Paul khat-um Barnabas le inruoiya Antioch katung tirnasik ah koisuok pumpuile tirton ngai khat-um uparup ngai'n thate tia inleingaidonjei; ");
INSERT INTO kfw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","halli inmani'n anuoiya chong ngaihi inmajia ah inleitirjei: “Keini ule-nai tirton ngai khat-um uparup ngai'n Antioch, Syria khat-um Cilicia ah kaom zaatlop ule-nai ngaidiang chubei thona kinheinei. ");
INSERT INTO kfw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Keini'n chongpeii kinpemak mi lekkhat in keini diangnga inphut insili, inmani chongril khan nangni kha chongnga insuina khat-um ningmalung poongna innaminneijei. ");
INSERT INTO kfw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","26","Keini'n malungkhat bit-ah inzootna kinneiya mi lekkhat ngaihi kinkadangli, eini Pumi Jisu Christa ramingsik ah apum inpesuok, minriang kaom Barnabas khat-um Paul le inruoiya inmani heitirsik thate tia kinngaidonjei. ");
INSERT INTO kfw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Khawa jarra keini'n, Judas khat-um Silas kinhongtirjei; inmani inpumtak innum nangni diang kimajia chongtak kha narilpi inte. ");
INSERT INTO kfw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Hiwa arei kaomkhet dan ngaihi eleiya aleiilak phurrik ninchungnga naminroon maknasik ah Ratha Inthiang khat-um keini'n kinmintha eii: ");
INSERT INTO kfw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","tichu, kutbool pathian diangnga ipe phur, thisen ka-in kabak, inraakthat sa, khat-um zool-inthai rakip ah inphut nangni'n ningthomak kha atha; nangni ningpumtak in hiwa rakip hi ningmathaan inchu, nangnisik ah akathasik eii. nangni rawaan katha eru.” ");
INSERT INTO kfw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Hinthoa inmani inheitirra, Antioch katung insijei, halli kangamna ngai inkhoomchunna, inmani diang chemajia kha inpejei. ");
INSERT INTO kfw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Inmani'n chemajia kha inteelpha, inmalung amasokpi jarra inrokjei. ");
INSERT INTO kfw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Inmani inpumtak Pathian chongkachoi Judas khat-um Silas in ule-nai ngai diangkhan chongkatamtak ah inmasok ah, inmani malung inleimasokpi jei. ");
INSERT INTO kfw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Inmani'n phabong khat inlei-omli, ule-nai ngai'n kahoi-kadaitak ah inmani aheikatir ngaidiang inheiminkirjei. ");
INSERT INTO kfw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Takkha Silas inchu khawakhan kaom thate tia aleingaidon. ");
INSERT INTO kfw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paul li Barnabas in Antioch ah phabong khat, aleiilak ngaile inruoiya Pumi chongkha inminchu khat-um inrilpiya inleiom. ");
INSERT INTO kfw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Phabong khat suo Paul in Barnabas diang ati, eini'n Pumi chong nileirilna khuopui rakip ah ule-nai ngai angtho-thoa inomme, tuun woikhat kir-inlang juo-enrui. ");
INSERT INTO kfw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas inchu Mark inti John kha-um inmanile inruoiya aleiruoizoot. ");
INSERT INTO kfw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Takkha inmani kha Pamphylia ah adali inchuon khan inmanile kasisuommak amahi ruoiya sisik akatha emak tia Paul in aleingaidon. ");
INSERT INTO kfw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Khawa khan kana ah inseiina inneiya, inmani inkhatli inkhat in-inthenjei, halli Barnabas in Mark aruoiya Cyprus tiang rakuong achuongjei; ");
INSERT INTO kfw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Halli Paul innun Silas kadangjei, halli ule-nai ngai'n inmani kha Pumi riangwai khan inpeluut ah insijei. ");
INSERT INTO kfw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ama'n koisuok ngaikha amasok ah, Syria khat-um Cilicia arakaanna asijei. ");
INSERT INTO kfw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Halli Paul in Derbe li Lystra um atungjei; khawakhan akangamna Jihudi numeisa inkhat sapa, Timothy inti siamruoi inkhat aleiom; apa chu Greek alei eii. ");
INSERT INTO kfw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystra khat-um Iconiumma kaom ule-nai ngai'n ama jarra katha tak-ah inleiril. ");
INSERT INTO kfw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paul in Timothy le inruoiya aleisizoot; khawa ramma kaom Jihudi ngai jarra Paul in amakha aruoiya wun atanpijei; ajarchu apa kha Greek eii ti inmani rakip in inleijet. ");
INSERT INTO kfw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Inmani'n khuopui rakip hin inheiwapha, Jerusalemma kaom tirton khat-um uparup ngai inzootna chongkha inmani diang juiru inleitipi. ");
INSERT INTO kfw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hinthoa koisuok ngaikha ngamnatiang kheella inhongngar, halli nisuo ah kangamna miring inhongkheeljei. ");
INSERT INTO kfw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Asia ramsuungnga insiya chongkha rilsik Ratha Inthiang in inmani diang apemak jarra, Phrygia khat-um Galatia ramma inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Halli inmani'n Mysia ramkooltiang inheiwapha, inmani'n Bithynia luutnasik inleitho; takkha Jisu Ratha khan leizootpi makjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Khawa jarra inmani'n Mysia inrakaanna Troas tiang inchumjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Halli Paul in khawani zaankhan mangtalar inkhat aleimu, khawa mangtalar khan Macedonia mi inkhat in angirra amadiang ileini kha aleimu, “Mecedonia ah heiwa inlang keini najuosanru!” ");
INSERT INTO kfw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul in hiwa mangtalar muli-mumak, Pathian in inmani diang Akatha Chong rilnasik anakoi jei ti kinjet ah, keini'n Macedonia tiang sinasik kinngirjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Khawa jarra keini'n Troas makheiya, Samothrace katung phitsik rakuong kinchuongnga, khat-um ziingkhuo warli Neapolis kinhongtung, ");
INSERT INTO kfw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","halli khawa makheiya keini'n Philippi katung kinhongjei, hiwa munhi Macedonia ramkarra akalok khet khuopui khat-um Rome ngai'n kut-inchal ram alei eii, khawakhan keini nikhuo katamtak kinleiom. ");
INSERT INTO kfw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jihudi ngai sernikhuo khan keini'n khuopui kinrakaanna tuidung raalkhattiang, ninasik mun lei-omte ti kinngaidonna, khawa katung kinleisi; halli keini'n kin-in-ongnga, inchun numeisa ngaidiang kinleiminchujei. ");
INSERT INTO kfw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Thyatira khuopuiya araming Lydia inti, puonkasenjun kajuor Pathian chubei katho numeisa inkhat in inminchu kha aleirangai; halli Paul in iril chongkha malungkaluut ah rangainasik Pumi'n ama malungkha amalongpijei. ");
INSERT INTO kfw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ama le a-innsuung mi ngai baptize inthosuopha, ama'n ati, kei Pumi kangamna eii tia nangni'n ningngaidonjei inchu, “Ka-inna hong-inlang hong-omru.” Ama'n keini diang anati. ");
INSERT INTO kfw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Halli nisuokhat keini'n nina munkhan kinsipha, ratha kathamak kachoi suoknumeisa inkhat keinile kinlei-intong, ama'n nuktiangnga kasuoksik arilsuok mator jarra ama suokchangna mapu ngaisik sial katamtak aleilou. ");
INSERT INTO kfw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Hiwa nungaaknu in Paul khat-um keini nuk anahongjuiya akheek ah ahongti, einidiang ringnasik jarra chong nakarilpi mi ngaihi Insaangkhet Pathian suok ngaikha in-eii. ");
INSERT INTO kfw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Halli ama'n hiwahi apha kasoottak aleitho, takkha Paul in ahalla inletli ratha diangkhan ati, ama diangnga inphut heisuoknasik “Jisu Christa ramingnga nangdiang chong kanapeii.” Khawapha takkhan ratha kha asuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Khawa suoknu mapu ngaikhan inmani nemna ngai rakip kha inmangsuo inmupha khan, inmani'n Paul li Silas kha insurra, phaipui suungnga inkei-karuolla lamkakei ngai maikuungnga inheiruoi; ");
INSERT INTO kfw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","halli inmani'n Paul li Silas kha chongkatan mapu ngai maikuungnga inhongruoiya inti, hiwa mingaihi Jihudi in-eii, inmani'n eini khuopuihi inminhaangjei; ");
INSERT INTO kfw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","halli eini dan le in-angmak omchan ngaikha innaminchu einichu Rome mi ni-ejarra inmani omchan dan kha juitheinumin, inleiti. ");
INSERT INTO kfw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Halli mipui inphuhut ah Paul li Silas chungnga inzootmakle inruoiya. chongkatan mapu ngai'n inmani puondiar inkatherpiya, inmani kha wuoknasik ah chong inleipeii. ");
INSERT INTO kfw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Inmani'n kase-ah inzeemli, mikhumna khan inda ah, kacheet ah ngaaknasik mikhumna ka-ngaakpa diang chong inpejei. ");
INSERT INTO kfw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ama'n hituk kana chong ajetli, inmani kha mikhumna suung-innungkhet tiang akeiluut ah, inkeii kha thingrakol aminsurpijei. ");
INSERT INTO kfw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Zaanchim pheiwei khan Paul li Silas nina innei halli Pathian minpaakna laa inleisak, halli mikhumna suungnga kaom ngaikhan inmani inleirangai; ");
INSERT INTO kfw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jetlei-theileiya ka-ngartak rinook hongnga mikhumna innkha innikjei, halli khawa phatak khan innkhar rakip-um inlongjei, inkhit ah kaom mi rakip-um insuutjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mikhumna kangaakpa'n ahong-intheili, mikhumna innkhar rakip inlong kha ahongmu pha, mikhumna suungnga kaom rakip intaan suojei ti angaidonna, achem akeisuo ah insunthatsik athojei. ");
INSERT INTO kfw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Takkha Paul in rasa inringnga aheikheek, natheinuo ah thinasik thomaro, ajarchu keini rakip hin kinlaom. ");
INSERT INTO kfw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Khawapha mikhumna ka-ngaakpa khan meiser anili innot-ah aluut jei, kachile inruoiya intuulla Paul li Silas maikuungnga inbokjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Halli ama'n inmani akeisuo ah ati, karu ngai ringnasik ah kei'n angme kathosik? ");
INSERT INTO kfw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Inmani'n inti, “Pumi Jisu Christa ngamnaro, halli nang-um na-innsuungkhur-um ringna ningmusik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Halli inmani'n ama diang-um innsuung mi rakip diang-um Pumi chongkha inleiminchujei. ");
INSERT INTO kfw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Khawani zaan takkhan ama'n inmani kha aruoiya inmani ramolbi ngaikha arasupijei, halli khawapha takkhan amale a-innsuung mi rakip um baptize inthojei. ");
INSERT INTO kfw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Halli ama'n inmani kha ama inna aruoili, inmani maikuungnga baksik aleiminsuukpi, halli Pathian diang inngamna inneiya, ama innsuung mi rakip karok in asipjei. ");
INSERT INTO kfw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ziingkhuo ahongwar pha, Rome chongkatan ngai'n raalmi kalok inheitirra inti, “Mi ngaikha masuoru.” ");
INSERT INTO kfw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Halli mikhumna ka-ngaakpa in Paul diang chongkha arilpi jei, chongkatan ngaikhan nangni inni kha masuonasik chong inheimintungjei; khawa jarra tuunchu heisuok inlang kahoiya nasipitaru. ");
INSERT INTO kfw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Takkha Paul in inmani diang ati, chongtan tholeiya Rome keinihi mipui maikuungnga inmani'n innawuokli, mikhumna ah innadajei, halli tuunchu inmani'n keinihi ruuk ah innapuutsik be? zootmung; inmani inpumtak heiwasu-inlang keini hi nakeisuorasu. ");
INSERT INTO kfw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Raalmi ngaikhan chongkatan ngaidiang chonghi injuomindik pha, Paul li Silas hi Rome mi in-eii ti injetli inmani ngaikhan inchijei; ");
INSERT INTO kfw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","halli inmani'n inheiwa ah nangaidamru injuoti, khat-um raalmi ngai'n inmani kha mikhumna makheiya katha ah inruoiya, khuopui makheiya nasuokpitaru inleitipi. ");
INSERT INTO kfw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Inmani'n mikhumna ah inphut inheisuokli, Lydia innkhan inluutjei, halli inmani'n ule-nai ngai khale in-inmuwa, inmani kha inleimasok ah inmathaanna insijei. ");
INSERT INTO kfw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul li Silas in Amphipolis khat-um Apollonia inrakaanna, Jihudi ngai synagogue omna Thessalonia katung inheiwajei. ");
INSERT INTO kfw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Halli Paul in ama ithojol angnga synagogue khan aleisi, Jihudi ngai sernikhuo woithum katung Pathian chongnga inmanile alei-inseiipui. ");
INSERT INTO kfw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Christa in apoong sik halli kathiya inphut ahongringsik eii iti chonghi inmani diang arilcheenpiya, hiwa Jisu hi eii kei'n nangnidiang kinarilpi Christa kha, aleitipi. ");
INSERT INTO kfw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Halli inmani karra lekkhat, Pathian chubei katho Greek mipui katam khat, khat-um numeisa ngai karra lamkakei katam khat in Pathian inngamna ah Paul li Silas diang inlei-inchunjei. ");
INSERT INTO kfw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Takkha Jihudi lekkhat in inleira-ot, halli chuon kaneimak ngai karra tu ka-ang kathamak mi ngaikha inkoituup ah, khuopuikha inleiminhaang; halli inmani'n Jason innkhan Paul li Silas kha inratok ah inmani kha mipui ngaidiang keisuonasik inlei-entok. ");
INSERT INTO kfw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Halli inmani'n inmani kha inmumak phakhan, Jason li ule-nai Pathian ka-ngamna lekkhat ngaikha khuopui karoon ngai maikuungnga inkei-karuolla, inkheek ah inheiti, manmasituol kamalet-kamakhup mi ngaikha hiwa eini khuopui hin inheiwa; ");
INSERT INTO kfw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","halli inmani kha Jason in a-inna aleikeiluut, halli Jisu inti reng inkhat aom intia inmani rakip in Caesar dan ngaikha inleimakoi. ");
INSERT INTO kfw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mipui ngaile khawa khuopui karoon ngai'n hiwa chonghi injet phakhan, inmalung minhaang pijei. ");
INSERT INTO kfw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Halli inmani'n Jason li aleiilak ngaikha masuonasik sial inminpeya inleimasuojei. ");
INSERT INTO kfw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ule-nai ngaikhan innot-ah Paul li Silas kha zaanna Berea ah intirjei. Inmani'n khawa mun intung phakhan, Jihudi ngai synagogue khan inluutjei. ");
INSERT INTO kfw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Khawa khanna mi ngaikha Thessalonia mi ngaineek-ah inmalung aleiluut, inmani'n Pathian chonghi malungkaluut ah Paul chongril ngaihi inthiangnga atuunbe intia nisuo rakip ah Pathian chongkhan katha ah inleiratok. ");
INSERT INTO kfw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Khawa jarra inmani karra akatamkhat halli khuo suungnga khoya thosik kaom Greek numeisa ngaile Greek mi katamkhat in Pathian inngamnajei. ");
INSERT INTO kfw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Takkha Thessalonia Jihudi ngai'n Berea khannum Paul in Pathian chong aril jei iti injetpha, inmani'n inheiwa-ah, khawa khannum mipui inmasok ah inminhaangjei. ");
INSERT INTO kfw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Khawapha takkhan ule-nai ngaikhan innot-ah Paul kha tuipui katung sina sik-ah inleitirjei. takkha Silas li Timothy chu Berea ah inomjei. ");
INSERT INTO kfw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul kathak ngaikhan Athen katung injuothakjei, halli Silas li Timothy kha innot-ah amadiang heiwanasik Paul chongpeii khale inruoiya Berea tiang inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul in Athenna Silas li Timothy ngaak-ah omlai khan, ama'n khuopui kha kutbool pathian khan isip amu pha amalung leihoipimak jei. ");
INSERT INTO kfw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Khawa jarra ama'n synagogue ah Jihudi khat-um zaatlop Pathian chubei katho, nisuo rakip ah intongpui mi ngaile inruoiya phaipui mi inchunna munkhan alei-inseiipui. ");
INSERT INTO kfw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","woikhat-um Apicurean khat-um Stoic karu ngai lekkhatle inlei-inseiinook, halli inmani lekkhat in inti, por tia irilhi ang itizoot omme? lekkhat in inheimasang, amachu ratha kathamak jarra chongkaril mi eii, ajarchu ama'n Jisu chong khat-um ahongringna jarra inmani diang aril. ");
INSERT INTO kfw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Khawa jarra ama kha inmani'n Areopagus koolla inhongruoiya inti, ama naminchu akathar chonghi ang tiname keini'n jet chanibo? ");
INSERT INTO kfw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ajarchu nang in keini kuorra chongleiilak niril keini'n kinjet; khawa jarra chong ngaihi ang tiname keini'n kinjetzoot. ");
INSERT INTO kfw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Ajarchu Athen mi ngai khat-um khawa munna leikaom khuol-injil mi ngai'n chongthar inril emakli inrangai eleiya iteii inkhat um tholeiya apha inleiminmang.) ");
INSERT INTO kfw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul in mi intuupna Areopagus laiya angirra ati: Athen mi ngai, nangni lamrakip ah pathian kangamnathei ning eii ti kei'n kajet. ");
INSERT INTO kfw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ajarchu kei'n hin khuopuiya kasipha, nangni ngai chubei thona mun ngaikha katha ah ka-enna, “Injetmak Pathian diang” tia maichaam inkhat chungnga injia kha-um kamujei. Khawa jarra nangni'n jetleiya ningbiak Pathian kha kei'n nangni diang kinarilpi eii. ");
INSERT INTO kfw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nuoipil pumpui khat-um khawa suungnga kaom phur rakip kabool Pathian khan, Marwaan li nuoipil Pumi ejarra, kut ah inbool biak-inn khan ommak. ");
INSERT INTO kfw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ama sik-ah insam om tia miring kut ah ama sepa thosik ommak, ajarchu amatak in mi rakip chungnga ringkhuo, phuksaan khat-um phur rakip apeii. ");
INSERT INTO kfw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ama'n miring inkhat ah inphut miring zaat rakip hi nuoipilchung pumpui kaphuonsik ah abooljei, ama'n inmani omnasik pha khat-um in-omnasik ramri matiang khan aboolpijei. ");
INSERT INTO kfw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tichu, inmani'n Pathian kha khan mukinte tia in-entok nasik eii; takkha eini rakip diangnga inphut amachu kalaak ah ommak. ");
INSERT INTO kfw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ajarchu amadiang eini niring, nisi-nihong halli eini'n niring, Tuka-ang in inti. Hiwahi nangni chongkamajia ngai'n inti, Ajarchu eini um ama sa-ngai ni-eii. ");
INSERT INTO kfw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Khawa jarra eini Pathian sangai ni-ejarra, miring ngai singna theina khanna inbool soonna, dangka emakli lungnga inhak Pathian kha eini'n biaktheinumin. ");
INSERT INTO kfw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mi ngai'n Pathian inleijetmaklai phakhan, Pathian in iteii teelpimak, takkha tuunchu amun rakip ah miring rakip malung-thonnasik ama'n chong apejei. ");
INSERT INTO kfw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ajarchu ama'n ikadang mi inkhat in manmasituol hi akatuuntak ah chongtan nasik nikhuo inkhat amadanna adajei. Ama'n miring thiya inphut aminringna khan miring rakip diang inngamnasik ka-eii kha ama'n apejei. ");
INSERT INTO kfw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Paul in thina ah inphut hongringna chong jarra irilhi inmani'n injetpha, lekkhat in in-innuipui, halli lekkhat inchu inti, hiwajarhi keini'n woikhat nadiangnga inphut kinrangaizoot inti. ");
INSERT INTO kfw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Paul in hinthoa inmani karra inphut asuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Takkha mi lekkhat in amakha inngamnajei, inmani uparup karra ka-inchel Areopagite Dionysius, halli mileiilak ngai karra Damaris inti numeisa inkhat um khawakhan alei-inchel. ");
INSERT INTO kfw_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hiwa suonuk Paul in Athen mathaanna, Corinthia ah aleisi. ");
INSERT INTO kfw_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Claudius Caesar in Jihudi rakip Rome mathaannasik chong ape jarra, anumei Priscilla le inruoiya ama'n Italy makheiya aheiwana akalanai, Pontus ah innei araming Aquila inti Jihudi inkhat alei-intongpui, halli Paul in inmani diang aleiluut. ");
INSERT INTO kfw_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Halli amale inchuon in-angrip jarra ama'n inmanile in-omsuomma chuon aleitho, ajarchu inmani khuoiliang puon inn kasak chuon katho mi ngai inlei eii. ");
INSERT INTO kfw_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Halli Jihudi ngai sernikhuo rakip synagogue ah chong inseiipui, Jihudi khat-um Greek innireella malung-thonnasik aleimatheem. ");
INSERT INTO kfw_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas li Timothy in Macedonia makheiya inhongtung pha, Paul in Jisu chu Christa eii tia Jihudi ngaidiang sakhi peli Pathian chong aleiril. ");
INSERT INTO kfw_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Inmani'n ama intheida ah kase ah inranpha, ama'n apuon kathingnga inmani diang ati, ningthi kha ninglu chungnga chulrase, keichu khawa jarra kajetmak ka-eii, tuun makheiya inphutchu kei zaatlop ngaidiang sitakte. ");
INSERT INTO kfw_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ama'n khawa makheiya inmani kha mathaanna, Titius Justus inti zaatlop Pathian chubei katho miring inkhat inna aluut jei, ama innkha synagogue le lei-innai. ");
INSERT INTO kfw_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Synagogue ah lamkakei Crispus in a-innsuung miring rakiple inruoiya Pumi inleingamnajei, halli corinthia mi katam khat in injet-ah inngamna-um inngamnajei, Baptize um inthojei. ");
INSERT INTO kfw_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Halli Pumi'n zaan khat khan Paul diang mangtalar minmu ah ati, chimaro, rilsuokro, omchianmaro, ");
INSERT INTO kfw_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ajarchu kei'n kana inruoipui, halli mi inkhat innum nangkha nakatook theinunu, ajarchu khuopui hin keikami katamma inom. ");
INSERT INTO kfw_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Khawakhan ama'n inmani karra Pathian chong aminchuwa kum khatle tharuk aleiom. ");
INSERT INTO kfw_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Takkha Gallio in Achaia ramkaroon epha khan, Jihudi ngai'n ininchunna Paul kha inleisur, halli ama kha chongkatan ngai maikuungnga inhongruoiya inti, ");
INSERT INTO kfw_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","hiwa mi hin danle inzootnamak lamtiang Pathian chubei thonasik mi ngai aleimatheem. ");
INSERT INTO kfw_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul in chong rilsik thopha khan Gallio in Jihudi ngaidiang ati, akatuunmak li akathamak chong aleiom inchu, E Jihudi ngai, khawa chongjar dungjuiya kei'n nangni le deisuom kate. ");
INSERT INTO kfw_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Takkha hiwahi chong li raming khat-um nangnitak sinadan jarra inseiina keengnga, khawakha nangni tak-in chong kha tanru. Hiwa ngai ka-ang jarra chongkatan kha kei enuning. ");
INSERT INTO kfw_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Halli ama'n inmani kha chongtanna mun makheiya apuutsuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Halli inmani rakip in synagogue lamkakeipa Sosthenes kha insurra, chongtanna mun ma-ah inleiwuok. Takkha Gallio in hiwa jarra iteii leingaidon pimakjei. ");
INSERT INTO kfw_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul in khawakhan nikhuo kasoottak aleiomli, ule-nai ngai inthenpuiya, Priscilla khat-um Aquila inruoipuiya syria katung rakuong inheichuongjei. Ama chong-inkhitna inkhat omjarra Cenchreae ah alu awoijei. ");
INSERT INTO kfw_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Inmani'n Ephesus inheitungnga, Paul in Priscilla li Aquila kha khawa munkhan adajei, takkha ama apumtakchu synagogue ah aluut-ah Jihudi ngaile inlei-inseii. ");
INSERT INTO kfw_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Inmani'n amakha apha kasoottak omnasik intipha, ama'n leizoot makjei. ");
INSERT INTO kfw_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Khawa rathuulla inmani kha mathaanna ati, Pathian lungdou e-inchu kei nangnidiang heikir kate tia ama'n Ephesus makheiya rakuong achuongjei. ");
INSERT INTO kfw_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Halli ama'n Caesarea atungpha, Jerusalem akalla koisuok ngai khoya ajuotholi, Antioch tiang aleichumjei. ");
INSERT INTO kfw_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ama'n apha lekkhat khawa munkhan aleiomli asuok ah, Galatia khat-um Phrygia rampumpui arakaanna, siamruoi rakip ngai malung aleiminngarpui. ");
INSERT INTO kfw_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jihudi mi inkhat araming Apollos inti Alexandria ah innei, ama kha Ephesus ah aleihong. Amachu chongkaril katheitak khat-um Chong-inthiang incheenna jetna kanei inkhat alei-eii. ");
INSERT INTO kfw_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ama'n John baptize thona bit ajet innum, Pumi Lamtiang kathatak ah inchuna kanei, malung kaluuttak le inruoiya Jisu jarra kasuok inthiangnga karil khat-um kaminchu inkhat eii. ");
INSERT INTO kfw_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ama'n synagogue suungnga kachi omleiya karil aphut jei. Halli Priscilla li Aquila in ama chongril injet pha, inmani'n ama kha in-inn khan inruoiya, Pathian Lam jarra katha ah ama diang inleirilcheenpijei. ");
INSERT INTO kfw_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Halli ama'n Achaia tiang asizoot pha, ule-nai ngai'n ama inmasok, halli amakha katha ah inleiralaang nasik siamruoi ngaidiang chong inleimajia. Hanna ama'n atungpha, Pathian riangwai jarra ngamna kanei ngaikha kalok ah asanjei. ");
INSERT INTO kfw_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ajarchu Jisu hi Christa eii tia ama'n Pathian chong khan aminmu ah, mipui maikuungnga Jihudi ngai kha murruolsiak inthopuiya amaneiijei. ");
INSERT INTO kfw_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos in Corinthia ah omlai, Paul in khawa ram chungtiang aheirakaanna, Ephesus aheitungpha, siamruoi lekkhat intongpuijei, ");
INSERT INTO kfw_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","halli ama'n inmani diang ati, “Nangni'n akangamna kha ninghong-epha Ratha Inthiang kha ningmujeibo?” Inmani'n ama diang inti, lamumung, Ratha Inthiang om ti-um keini'n jet-um jetmung. ");
INSERT INTO kfw_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","“Ama'n inmani diang ati, kha e-inchu, nangni angkachang baptize ningthome?” Inmani'n inti, John baptize thona khan eii. ");
INSERT INTO kfw_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul in aleiti, “John baptize thona khachu malung thuulnasik eii, halli ama nuk-ah akajuosikpa Jisu diang ngamnaru tia, Israel mi ngai diang aleirilpi.” ");
INSERT INTO kfw_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Inmani'n hiwahi injetpha, Pumi Jisu ramingnga baptize inthojei. ");
INSERT INTO kfw_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paul in inmani chungnga akut aduongpi, halli Ratha Inthiang kha inchungnga ajuo ah; inmani'n intei chongkatamtak inrilla Pathian chong inleirilsuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Inmani rakip kha mi soomleini daam inlei eii. ");
INSERT INTO kfw_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul in synagogue ah aluutli, Pathian Rengram jarra chong insiampui khat-um amatheemma thathum katung kachi omleiya aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Takkha inmani lekkhat in mipui ma-ah Pumi iminchu Lam jarra akathamak inrilla, kuor kangar li inti kajuimak inhong epha, ama'n inmani diangnga inphut aheisuokli, siamruoi ngaikha aruoiya, nisuo rakip Tyrannus chongrilna innkhan chong lei-insiampui. ");
INSERT INTO kfw_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Asia ramma kaom Jihudi ngaile Zaatlop rakip in, Pumi chong kha injetsuonasik ama'n khanthoa kumni katung aleiom. ");
INSERT INTO kfw_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pathian in Paul inliingna ah angaiya chuon inlak ka-emak ngaikha aleimintho. ");
INSERT INTO kfw_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ama koongsoi khat-um puonlek e-innum, akana ngaidiang inhongchoi pha, inmani rirai khan inleimathaan, halli akathamak ratha ngai kha-um inleisuok, hiwa katunghi aleimintho. ");
INSERT INTO kfw_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pangsi-panglon katho Jihudi ngai, ratha kathamak kapuutsuok lekkhat in, Paul in irilsuok Jisu kha inrilli nangni kha chong kinapeii intia, kathamak ratha kaluut mi ngai chungnga Pumi Jisu raming kasuo inphutjei. ");
INSERT INTO kfw_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Jihudi ngai Thiampu kalian araming Sceva inti ama sapa sari ngai'n hiwahi inleitho. ");
INSERT INTO kfw_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Takkha akathamak ratha khan inmani diang ati, kei'n Jisu kajet khat-um Paul jarra um kajet; takkha nangni tu-ngai ning eme najetmong? ");
INSERT INTO kfw_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Halli akathamak ratha kaluut mi khan inmani diang kut-heimalet ah, inmani kha amatorjei, khawa jarra inmani'n khawa inn makheiya puondiar inchelleiya khat-um intook-inkaple inruoiya intaanjei. ");
INSERT INTO kfw_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ephesus ah kaom Jihudi khat-um Greek rakip in hiwahi inhongjetjei; halli inmani rakip in inleichi, khat-um Pumi Jisu raming kha inleiminlok. ");
INSERT INTO kfw_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Inmani karra akangamna katamtak in inheiwa ah inchuon leitho kha inrilsuok ah inleimalar. ");
INSERT INTO kfw_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mitmalet dooi katho katam khat in inmani larik inhongkhoom tuup-ah mipui maikuungnga mei inleihaal; halli inmani'n khawa man inteelpha, dangkapum lising soomra-nga aleitung. ");
INSERT INTO kfw_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hiwa ranak hin Pumi chongkha hongphuon tirjei halli kheella ahong-insoonjei. ");
INSERT INTO kfw_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hiwa chuon ngaihi asuok suonuk, Paul in Macedonia khat-um Achaia arakaanli, Jerusalem katung sinasik angaidonna, “Kei'n khawa katungsuoli, Rome um kajuophasik eii ati.” ");
INSERT INTO kfw_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Halli ama kasan, Timothy li Erastus, inmani inni Macedonia ah atirli, amachu phabongkhat sik-ah Asia ah omjei. ");
INSERT INTO kfw_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Khawa phakhan Pumi minchuna Lam jarra Ephesus ah inhaang aphut jei. ");
INSERT INTO kfw_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ajarchu Demetrius inti tu ka-ang dangka-kasut inkhat in Artimis ramil kha dangka ah aboolla akut kathei ngaikha chuon katamma aleipeii. ");
INSERT INTO kfw_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ama'n inmani khat-um inmanile chuon in-ang ngai akoichunna ati, “E mi ngai, hiwa chuon jarra eini'n sial-sum nimu iti nangni'n ningjet. ");
INSERT INTO kfw_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Halli kut-ah inbool kha Pathian emak tia Paul in Ephesus bit eleiya Asia rampumpui mi ngaikha amatorra inmalung aminthuuljei iti nangni'n ningmu khat-um ningjetjei. ");
INSERT INTO kfw_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Eini hiwa chuon makheiya niraming juo-inmang elekleiya, Asia khat-um manmasituol mi rakip in inngamna akalok pathian Daina biak-inn hi-um anemna min-omnunujei, khat-um hiwa alur-alianna ngaihi juomangte tia chisik omjei.” ");
INSERT INTO kfw_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Inmani'n hiwahi injetpha, inraangtheiya inhongkheek, “Ephesus Artimis hi akalok khet eii.” ");
INSERT INTO kfw_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Khuopui kha alei-inhaang jei, Paul le ka-inruoi Macedonia mi, Gaius khat-um Aristarchus kha inmani'n insurra, malungkhat bit-ah kahoi muntiang inmani kha inleiluut puijei. ");
INSERT INTO kfw_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul in mipui ngai karra aleiluutzoot, takkha siamruoi ngaikhan leizootmujei. ");
INSERT INTO kfw_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Asia ah kaom asap lekkhat in amadiang chong inheitirra kahoi munna apumtak inlarmak nasik injuotijei. ");
INSERT INTO kfw_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mi lekkhat in chong khat, halli mi lekkhat in chong leiilak khat inrilla, angsik ah ininchunme mipui'n leijetmu, ajarchu mipui inchun kha inlei-inhaang. ");
INSERT INTO kfw_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jihudi ngai'n ama hi matiang inminsi jarra, mi lekkhat in Alexander in hiwa rakip hi aroonsik eii inti, khawapha Alexander in akut akalek ah apum inngaaknasik mi ngaidiang karil aleiphutjei. ");
INSERT INTO kfw_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Takkha ama Jihudi eii ti inmani'n injetpha, inmani rakip in phadan inni katung, “Ephesus Artimis in akalok eii,” tia malung inkhatbit ah inleikheek. ");
INSERT INTO kfw_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ajuohekna ah khuopui ka-ensuipa khan mipui ngaikha amatheemma. Ama'n ati, “E Ephesus mi ngai!” marwaanna inphut ajuokata lung inthiang ramil le Daina akalok ramil biak-inn ka-ngaakchu Ephesus khuopui eii tia kajetmak mi tu in-ommame? ");
INSERT INTO kfw_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hiwahi tuteii in dikmak timatornunu, khawa jarra tuunchu nangni kadaiya om-inlang chuon kha innot ah thodimaru. ");
INSERT INTO kfw_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ajarchu nangni'n biak-inn khan inruup kathomak khat-um eini pathian kha-um kase-ah karilmak mi ngai kha nangni'n ninghongruoi. ");
INSERT INTO kfw_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Khawa jarra Demetrius khat-um amale inruoiya akut kathei ngai'n tu ka-ang mi ngaile inzootmakna kha om-inchu, chongtanna kha inlong, ramkaroon ngai-um inlaom; inmani khat li khat inseiirasu. ");
INSERT INTO kfw_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nangni'n aleiilak-ah kheella ninglaratok inchu, mipui-inzootna dan khan inmachatsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ajarchu awiniya inhaangna kasuok hi chi om, halli hiwa jarra eini'n ajar katha ah pematornumin. ");
INSERT INTO kfw_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ama'n hiwa atisuopha, mipui inchun kha aleiminthenjei. ");
INSERT INTO kfw_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Inhaangna kha ajuodai suonuk, Paul in kangamna ngaikha akoiya khat-um akakuo ah aleimasokli, inmani kha inthenpuiya Macedonia tiang aleisijei. ");
INSERT INTO kfw_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Halli ama'n khawa ramtiang asipha, inmani kha chong katamtak ah amasokli, Achaia katung asijei, ");
INSERT INTO kfw_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","halli ama'n khawakhan thathum aleiomli, Syria katung rakuong chuongnga sinasik atholaitak Jihudi ngai'n thatnasik inthokha ajet-ah, ama'n Macedonia tiang kirnooktakte tia angaidon jei. ");
INSERT INTO kfw_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Halli Berea makheiya Pyrrhus sapa Sopater; Thessalonia makheiya Aristarchus li Secundus; Derbe makheiya Gaius; halli Asia makheiya Tychicus li Trophimus; halli Timothy inmani ngaihi amale inlei-inruoijei. ");
INSERT INTO kfw_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Inmani ngai'n ma inleisa-ah, Troas ah keini innaleingaak. ");
INSERT INTO kfw_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Chol-inchelmak waipool Kahoi suonuk keini'n Philippi makheiya rakuong kinchuongnga, nira-nga suo-ah Troas ah inmani koolla kintungjei; khawakhan keini nisari kinleiom. ");
INSERT INTO kfw_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Halli hakta inphutna nikhuo khan keini'n waipool baknasik kin-inchun phakhan, Paul in ziingkhuo awarli adasik ejarra, mi ngaidiang zaanchim katung chong aleiril. ");
INSERT INTO kfw_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Keini intuupna chungkanung innkha meiser katamma inleiminkai. ");
INSERT INTO kfw_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ruothar inkhat araming Eutychus intipa kha bangkot khan alei-in-ong, Paul in chong arilla aleiomlai khan imu inchu-inchuli, inbirra inthum huuina chung-inn makheiya nuoipilla ajuotajei, halli akathiya injuoruutjei. ");
INSERT INTO kfw_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paul in ama koolla ajuochumma, akakuo ah ati, “Ningmalung mindongmaru, ama alaring.” ");
INSERT INTO kfw_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Halli ama'n chungtiang akalla, waipool kha akatherra inbakli, inmanile apha kasoot-ah khuowar katung chong inrilli, ama asuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Inmani'n naipangpa kha karingnga in-inntiang inruoijei, halli inmani rokna kha lekteii emakjei. ");
INSERT INTO kfw_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Keini'n ma-insa ah Assos tiang rakuongnga kinleisi, khawa khan Paul minchuong sik tia kinleingaidon, ajarchu ama'n keiiya sikate tia keinidiang aleiti. ");
INSERT INTO kfw_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assos ah ama'n keini anamupha, keini'n amakha rakuong kinminchuongnga Mitylene tiang kinsijei. ");
INSERT INTO kfw_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Khamakheiya rakuong kinchuongnga, ziingkhuo warli Chios kintungjei, nikhat thengnga Samos tiang kinheiwa, halli ziingkhuo warli Miletus kintungjei. ");
INSERT INTO kfw_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul in Asia ramma phakasoot ommak nasik, Ephesus rakaanna rakuong sepnasik angaidon jei, achathei inchu ama'n Penticost nikhuoni khan Jerusalem tungnasik innot-ah aleisijei. ");
INSERT INTO kfw_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Miletus makheiya Ephesus ah Paul in mi atirra, koisuok uparup ngaikha ama inmupui nasik aleiminkoi. ");
INSERT INTO kfw_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Inmani'n amadiang inhongtungpha, ama'n inmani diang ati; “Kei'n Asia ram kahongtungni makheiya apha rakip nangnile inruoiya angtho-thoa kiomme tikha nangni'n ningpum tak-ah ningjet,” ");
INSERT INTO kfw_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","tichu, Jihudi ngai'n thatnasik innathona suungnga kei'n malung kadaile mitrathi suokpumma Pumi sepa katho, ");
INSERT INTO kfw_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","21","Pathian diang malungthuulna khat-um eini Pumi Jisu Christa diang kangamna Jihudi ngaidiang um Greek ngaidiang um sakhi kapeya, nangni inna khat-um mipui karra karilla kanaminchuna khan, nangni nemnasik iteii kithen ommakti nangni'n ningjet. ");
INSERT INTO kfw_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Tuunchu enru, Ratha khan anakhit ah kei Jerusalem katung kasi, khawa munkhan keidiang angme kasuoksik kei jetmong. ");
INSERT INTO kfw_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Hibitchu kajet, innasur-innakhuop khat-um kapoong-karaal in kei kha anangaak ah aom tihi Ratha Inthiang in Khuopui rakip ah keidiang sakhi anapeii. ");
INSERT INTO kfw_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Takkha Pumi Jisu nape chuon khat-um Pathian riangwai akatha chong sakhi rilthang nasik ah anatirna chuon kha muol-minsuo ah minheknasik kathomak inchu, karingkhuo hi keisik ah anemna iteii ommak tia ngaidonna kanei. ");
INSERT INTO kfw_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Tuunchu, enru, nangni karra kei'n Pathian Rengram chong karilla kaleisi, takkha nangni rakip in kei meelsuo inlet-ah namunutunjei ti kei kapumtak in ka-injetjei. ");
INSERT INTO kfw_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Khawa jarra kei'n awini inthiangtak ah kimalar eii; nangni karra mi inkhat inmang suok-inchu, kei'n inmani thisen jarra kei iteii jetmong. ");
INSERT INTO kfw_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ajarchu Pathian lungdou rakip nangnidiang kei'n rilleiya kida ommakjei. ");
INSERT INTO kfw_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ama thisen tak-ah inaracho Pathian koisuok ngaikha kawaisik; nangni chungnga khat-um keelngam rahooi rakip chungnga ka-ensuisik malung minluutru, ajarchu Ratha Inthiang in nangni kha aka-ensuisik anadajei. ");
INSERT INTO kfw_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Kei'n kanadasuo nuk keelngam rahooi ngaikha kahoimak chikaom malang ngai'n nangni karra inhongluut sik eii ti kei'n kajet. ");
INSERT INTO kfw_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ningkarra mi lekkhat in kangamna ngaikha in-nuk minjui sik-ah ka-emak chongkaril inhongsuok sik eii. ");
INSERT INTO kfw_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","khawasik bit-ah kumthum katung kei'n suunli zaan mitrathi sarra nangni rakip kinaminchu kha ngaidon inlang nangni kadei karaat eru. ");
INSERT INTO kfw_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Tuunchu kei'n nangni kha Pathian diang khat-um ama riangwai chongnga kanapejei, hiwa chongnga inabooljei khat-um inaminthiangjei nangni rakip chungnga Pathian rawaan kha nangnidiang kanapemator. ");
INSERT INTO kfw_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kei'n tu-inkhat diang soonna, dangka emakli puondiar ra-ot mong. ");
INSERT INTO kfw_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kakut tak-ah keisik khat-um ki-inruoipui ngai nemnasik bit-ah chuon katho tikha nangni ningpumtak in ningjet. ");
INSERT INTO kfw_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kei'n nangnidiang angrakip chungnga chuon ranak ah katho ah kanaminmujei, tichu, kha angnga tho-inlang nangni'n akasuol ngaikha kasan khat-um Pumi Jisu chong kha kangaidon ning-esik ejei, ajarchu Pumi'n ati, ‘Akalei neek achu akape in kheella rawaan atha.’ ” ");
INSERT INTO kfw_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Hiwahi ati suoli, ama'n akemurkhup thep-ah inmani rakiple inruoiya nina inneijei. ");
INSERT INTO kfw_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Halli inmani rakip malung intook-ah inchap khat-um Paul kha inkakuo ah inheimazoop jei, ");
INSERT INTO kfw_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ama meelsuo woikhat inmani'n mununujei tia ama'n iril chong jarra kheella inmani'n inleipoong. Khamakheiya inmani'n ama kha rakuong katung injuothak jei. ");
INSERT INTO kfw_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Halli keini'n inmani kin-inthenpuiya rakuong kinchuongli, Cos katung katuunna kinhongnga; ziingkhuo awarli Rhodes, halli khawa makheiya Patara khan kinhongtungjei. ");
INSERT INTO kfw_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Phoenicia tiang kasisik rakuong inkhat kinmu ah, keini'n khawa kinchuongnga kinsijei. ");
INSERT INTO kfw_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Keini'n Cyprus kinmu pha, khawakha martiang kindali, Syria tiang rakuong kinchuongnga Tyre kinhongtungjei, ajarchu khawakhan rakuong aphur amachum sik eii. ");
INSERT INTO kfw_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Khawakhan siamruoi ngai kin-intongpuiya inmanile nisari kin-omjei. Inmani'n Ratha ranak jarra Paul kha Jerusalem tiang simaknasik inleirilpi. ");
INSERT INTO kfw_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Halli nikhuo ajuohuuiya, keini'n kinheisuok pha, inmani innumei insa ngai rakiple inruoiya keini kha khuopui raalkhat katung innajuothakjei, khawa tuipui khamkhan kemurkhup kinthep ah nina kinnei. ");
INSERT INTO kfw_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Keini inkhatli inkhat inthenna chong kinrilla; halli keini'n rakuong kinchuongjei, inmanichu in-inntiang inleikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Keini'n tuipui chungnga khan kinsiya, Tyre makheiya inphut Ptolemais kha kintung, halli khawa munkhan ule-nai ngaikha chubei kinjuothoa inmanile inruoiya nisuokhat kin-omjei. ");
INSERT INTO kfw_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ziingkhuo awarli keini'n kinhongsuok ah, Caesarea kinjuotungjei, Jerusalemma miring sari inkadang ngai karra Pathian-chuonkatho Philip inna kinluut ah, amale kinjuo-omjei. ");
INSERT INTO kfw_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ama'n inlakaneimak sanu-ngaak mili aleinei; inmani ngai'n Pathian chong inleiril. ");
INSERT INTO kfw_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Khawa munkhan nikhuo lekkhat kin-omlai, Judea ramma araming Agabus inti Pathian chongkachoi inkhat ahongtung. ");
INSERT INTO kfw_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Halli ama'n keinidiang ahongli Paul koongkhit aleiya, akeii-akut inkhit ah ati, “Ratha Inthiang in ati, hiwa koongkhit mapupa kha Jihudi ngai'n Jerusalemma hile in-angrip ah khit-inta, zaatlop ngai kutchungnga amakha inlapesik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Keini'n hiwa chong kinjetpha, keini khat-um khanna kaom mi ngai'n ama kha Jerusalem tiang asimaknasi kinleitipi. ");
INSERT INTO kfw_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Khawa phakhan Paul in anamasangnga, “Nangni'n ningchap ah angsikme kamalung ningminna? ajarchu Pumi Jisu sik ah kei Jerusalemma innakhit bit eleiya thinasik um ka-insuuk suojei.” ");
INSERT INTO kfw_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ama matheem matormungnga, keini'n kinti, “Pumi lungdou kha etarase.” ");
INSERT INTO kfw_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nikhuo lekkhat kin-omsuonuk keini'n kinphur-kinpai kinminsuuk ah, Jerusalem tiang kinsijei. ");
INSERT INTO kfw_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Halli Caesarea ah siamruoi lekkhat-um keinile kinhei-inruoi, inmani'n keini tungnasik Cyprus ah kaom matiangnga Pathian nukkajuijei Mnason inna innaheiruoi. ");
INSERT INTO kfw_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Keini'n Jerusalem kintungpha, ule-nai ngai'n karok ah innaleidon. ");
INSERT INTO kfw_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ziingkhuo awarli Paul in keinile inruoiya James ajuo-inmupui; halli koisuok upa rakip-um khawakhan inleiom. ");
INSERT INTO kfw_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul in inmani chubei athosuoli, zaatlop ngai karra achuon thona suungnga Pathian chuontho rakip ngaikha ama'n aleirilsuok. ");
INSERT INTO kfw_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Inmani'n khawakha injetpha, Pathian kha inleirokpui, halli inmani'n ama diang inti, “Ule-nai Paul, Jihudi lising angjet in kangamna inhong eii kha nang in najetjei; halli inmani rakip in Sinadan sikbit ah inmalung kha inminluut, ");
INSERT INTO kfw_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","inmani diang nang in zaatlop ngai karra kaom Jihudi rakip ngaidiang Moses dan mathaanna sik-ah insa ngai kha wun tanmaru khat-um Jihudi ngai sinadan kha-um juimaru tia naminchujei tikha keinidiang innaleitisuo jei. ");
INSERT INTO kfw_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Hiwa jarra angme nithosik? ajarchu nang naheitungjei ti inmani'n suoilekleiya injetsik ejei. ");
INSERT INTO kfw_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Khawa jarra angme keini'n kintihi thoro; inmani inpumtak ah chong-inkhit miring mili kha keini'n kinnei. ");
INSERT INTO kfw_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Inmanile inruoiya napumtak inthiangro, inmani'n inlu inwoinasik, sial pero; halli inmani diang niminchu chongkha akadik emak, napumtak in Sinadan kha kajuiya kasi tikha inmani rakip in injetsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Takkha akangamna zaatlop ngaisik ah, kutbool pathian diangnga inpeii dooiphur, thisen, inraakthat sameii, khat-um zool-inthai, hiwa rakip chungnga inmani'n inpumtak in-ensuinasik cheii nimajia ah niminsijei.” ");
INSERT INTO kfw_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Paul in miring ngaikha aruoiya, ziingkhuo awarli inmanile inruoiya inpum inminthiangnga, halli inmani rakip insuthiangnasik nikhuo ngaikha angtikme aheksik khat-um inmani rakip sik dooiphur angtikme inpesik tikha jetna sik-ah Paul in Biak inna aluut jei. ");
INSERT INTO kfw_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nisari kha ajuohek siktiang, Asia ramma kaom Jihudi ngai'n amakha Biak-inn khan inmupha, inmani'n khan mipui kha inmaphuhut ah amakha insurjei. ");
INSERT INTO kfw_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Inmani'n inhongkheek ah, “Israel mi ngai, nasanru!” amun rakip ah eini Sinadan khat-um hiwa munna kaom mi rakip kaminchu kha hiwa mi hi eii; halli hiwakheella ama'n Greek ngai-um Biak-inn khan aheiruoiya inthiang munkha aminchokjei. ");
INSERT INTO kfw_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ajarchu tiallai inmani'n Ephesus ah Trophimus kha amale inruoiya khuopui khan inleimu, ama kha Paul in Biak-inn suungnga aheiruoi tia inmani'n inleingaidon. ");
INSERT INTO kfw_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Halli khuopui rakip kha alei-inhaang jei, mi rakip inhongtaanna, inmani'n Paul kha insurra, Biak-inn makheiya ama kha inruoijei, halli khawa pha takkhan innkhar rakip inkharjei. ");
INSERT INTO kfw_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Inmani'n ama kha thatsik intholai, Jerusalem pumpui alei-inhaang jei tia Rome raalmi rahoi lamkakeipa diang chong inhongpejei. ");
INSERT INTO kfw_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ama'n innot-ah raalmi ngai khat-um raalmi rajakhat lamkakei ngai aruoiya inmani katung intaan jei; inmani'n lamkakei ngai khat-um raalmi ngaikha inmupha, Paul inwuok kha indajei. ");
INSERT INTO kfw_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Khawa pha lamkakeipa in aheinaiya ama kha sur-inlang thirrui inniya khitnasik chong apejei; halli ama kha tume khat-um angme ithojei tia aleirakel. ");
INSERT INTO kfw_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mipui karra lekkhat in chongkhat halli aleiilak khat ngai'n chongleiilak khattiang inleiril; mirasa khan ajar eya akadik kha ajet matormak pha, ama kha raalmi ngai omna innkhan ruoitaru tia chong apejei. ");
INSERT INTO kfw_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Halli ama'n chungtiang akalpha, mipui ngaikhan inraang theiya inheijui jarra ama kha raalmi ngai'n inkadomma inruoijei. ");
INSERT INTO kfw_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ajarchu mipui katam ngaikhan, thattaru tia inkheektirra anuk inleijui. ");
INSERT INTO kfw_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paul raalmi ngai omna inntiang inruoi siktiang, ama'n raalmi kalokpa diang ati, “Kei nang nadiang chong lekkhat ril chanibo?” ama'n ati, “Nang Greek chong najetbo?” ");
INSERT INTO kfw_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kha-enchu phabong khat matiang neelramma raalkatho sik mi lisingmili karuoi Egypt mi kha nang emakchebe? ");
INSERT INTO kfw_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul in aleimasang, “Keichu Cilicia ramma Tarsus khuopuiya innanei Jihudi ka-eii; mipui diang kei chong rilsik nazootpiro tia nangdiang nina kaheinei.” ");
INSERT INTO kfw_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ama'n azootpi pha, Paul in kalna chungkhan angirra mipui ngaidiang akut kalek ah, inmani'n inomchian phakhan, ama'n Hebrew chongnga arilla inmani diang ati: ");
INSERT INTO kfw_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ule-nai khat-um pa ngai, kei'n tuun nangni diangnga ka-inngaakna chong kiril narangaipiru.” ");
INSERT INTO kfw_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ama'n inmani diang Hebrew chongnga irilkha injetpha, inmani'n injuo omchian; halli Paul in ati: ");
INSERT INTO kfw_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Kei Cilicia ram Tarsus ah innei Jihudi inkhat ka-eii, takkha hiwa khuopui Jerusalem hin Gamaliel diang ka-inchu ah hongkalok ka-eii, kei nipi nipu ngai Sinadan kacheet ah kajuiya kahong-inchu, nangni rakip in wini ningtho angnga, kei innum Pathian sik bitkhan ka-inpesuok.” ");
INSERT INTO kfw_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Halli pasal numeisa rakip kasurra mikhumna khan kada-ah, inmani thina katung kei'n hiwa Pathian minchuna Lam kajui mi ngaikha kaleiminpoong-kaleiminraal. ");
INSERT INTO kfw_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Hiwa jarra Thiampu Kalian khat-um sanhedrin rakip in kei sakhi in-eii. Inmani diangnga inphut kei'n ule-nai ngai diangnga pesik chemajia ngaikha kamu ah, Damascus ah kaom hiwa mi ngai kha um rachaaknasik, khat-um khit-ah Jerusalem tiang juoruoinasik kei'n khawakhan kaleisi. ");
INSERT INTO kfw_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Kei'n hinthoa kasiya Damascus kaheinai pha hintia asuokjei, kani hong-inding siktiang, jetlei-theileiya kasir kapangnga marwaanna inphut akawartak ra-ang inkhat in ajuowarjei. ");
INSERT INTO kfw_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Halli kei nuoipilla kapurjei, halli rasa inkhat in keidiang, Saul, Saul, nang in kei angsikme ninaminpoong? iti kei'n kaleijet. ");
INSERT INTO kfw_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Kei'n kamasang, nang tu na-eme Pumi? halli ama'n keidiang ati, keichu nang in ninaminpoong Nazareth Jisu kha ka-eii. ");
INSERT INTO kfw_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Keile hei-inruoi mi ngaikhan ra-ang khachu inmu, takkha kei diangnga iril ama rasa khachu inmani'n leijetmu. ");
INSERT INTO kfw_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Halli kei'n kati, kei'n angme kathosik, Pumi? halli ama'n keidiang ati, inthei-inlang Damascus ah luutro, khawa munkhan Pathian in ikadangsa nathosik chuon rakip jarra nangdiang namindik inte. ");
INSERT INTO kfw_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Khawa kawar ra-ang khan kamit leimumongnga, kihei-inruoipui ngaikhan kakut inma-ouwa, kei'n Damascus ah kaheiwajei. ");
INSERT INTO kfw_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Khawa munna kaom Jihudi rakip in khoya intho, eini Sinadan kajui Pathian kangamna araming Ananias Jihudi inkhat aleiom. ");
INSERT INTO kfw_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ama kakoolla aheiwali, kakoolla angirra keidiang ati, Kasuopui Saul, nang mutaro! khawapha takkhan kei'n woikhat muna kaneiya amadiang kahong-enjei. ");
INSERT INTO kfw_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Halli ama'n ati, nipi-nipu ngai Pathian khan nang in ama lungdou jetnasik ah, ama Asuok kadik kha munasik ah, khat-um arasatak kha jetnasik ah anakadangjei. ");
INSERT INTO kfw_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ajarchu nang in mirakip maikuungnga nimu nijet rakip karilpisik sakhi na-esik eii. ");
INSERT INTO kfw_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Tuun angsikme nilangaak? intheiro, ama raming koi-inlang baptize thoro halli namanu insuthiangtaro ati. ");
INSERT INTO kfw_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Kei'n Jerusalemma kaheikirli, Biak-inn khan Pathian kanilai, kei'n mangtalar inkhat kaleimu, ");
INSERT INTO kfw_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","innotro, Jerusalem makheiya innot ah suokro, ajarchu kei jarra nang sakhi inmani'n leinunujei, tia keidiang kati Pumi kha kaleimu. ");
INSERT INTO kfw_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Kei'n katia, Pumi, inmani rakip in injetwiak, kei'n synagogue rakip ah nang kanangamna ngaikha mikhumna ah kaleida halli kawuok um kaleiwuok. ");
INSERT INTO kfw_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Halli nang nasakhi ka-eii Stephen inthatlai, kei um khawakhan kaomma, inthat kha kaleizoot khat-um akathat ngai puondiar kha kareiipi kalei-eii. ");
INSERT INTO kfw_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Halli ama'n keidiang ati, suokro; ajarchu kei'n nanghi hiwahinna inphut kalaak ah zaatlop ngaidiang kanatirsik eii. ");
INSERT INTO kfw_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Inmani'n hiwa katung achonghi inrangaili; inmani rasa inringnga inkheek ah inti, hiwa ka-ang mi hi nuoipilchung makheiya thatru, ajarchu ama karing sik rahoi suokmak. ");
INSERT INTO kfw_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Inmani'n inkheek ah, inpuondiar inkalek ah marwaan tiang rahut inwor pha, ");
INSERT INTO kfw_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Rome raalmi lamkakeipa in ama chungnga hituk Jihudi ngai'n inkheekna jar kha jetna sik, ama kha wuokna sik chong apeya, amakha raalmi ngai omna innkhan ruoitaru tia chong apejei. ");
INSERT INTO kfw_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Inmani'n ama kha inkhit ah inwuok pha, Paul in akoolla kangir raalmi rajakhat lamkakeipa diang ati, “Rome mi ngaihi iteii amasialna muleiya ningwuok hi nangni chongtanbe?” ");
INSERT INTO kfw_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Rajakhat lamkakeipa khan khawa ajetpha, ama'n raalmi lamkakeipa diang asiya aleiti, “Nang angme natho sik? ajarchu hiwa mi hi Rome miring eii!” ");
INSERT INTO kfw_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Khawa jarra raalmi lamkakeipa khan asiya Paul diang aleirakel, keidiang tiro, nang Rome miring na-ebe? halli ama'n ati, “oh,” ka-eii. ");
INSERT INTO kfw_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Raalmi lamkakeipa khan ati, “Kei'n aman katamtak kapeya Rome miring inkhat kihongchang eii.” Takkha Paul in amasangnga, keichu Rome miring inkhat ah innanei ka-eii ati. ");
INSERT INTO kfw_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Khawa phatak ama diangnga chongkarakel sik ngaikha nuktiang inkirjei; halli raalmi lamkakeipa innum ama Rome mi eii ti ajetpha, ama um Paul aleikhit jarra achijei. ");
INSERT INTO kfw_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Takkha ziingkhuo ahongwarli Jihudi ngai'n angjarra amasialna inpeme ti inthiangnga ajetzoot ah, ama kha amasuojei, halli thiampu kalian ngaile uparup rakip intuupru tia chong apeli, Paul ajuoruoiya, inmani maikuungnga amin-ngirjei. ");
INSERT INTO kfw_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Halli Paul in uparup ngaidiang mit en thuulleiya enna ati, ule-nai ngai, “Kei'n awini katung Pathian maikuungnga malung inthiangnga kahong-om.” ");
INSERT INTO kfw_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Thiampu Kalian Ananias in akoolla kangir ngaidiang amurra kabeennasik chong apejei. ");
INSERT INTO kfw_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Khawa pha Paul in ama diang ati, e akabang inkanoot bang, nangkha Pathian in analawuoksik eii. Nangchu Sinadan dungjuiya kei chongkatan sik na-in-ongli Sinadan namakoiya kei kha wuokru tia chong nipeme? ");
INSERT INTO kfw_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Halli akoolla kangir ngaikhan Paul diang inti, Pathian Thiampu Kalian kha nang in nilaranbe? ");
INSERT INTO kfw_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul in amasangnga ati, “Ule-nai ngai, ama hi Thiampu Kalian eii ti kei'n leijetmongjei; ajarchu hiwahi injia om, ‘Nangni'n ningmi ngai waikaroonpa chungnga akathamak chong rilmaru.’ ” ");
INSERT INTO kfw_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Sadducee li Pharisee rupni insuok kha Paul in amupha, uparup ngaidiang khan ati, “Ule-nai ngai! Pharisee ngai sapa, Pharisee kha kei ka-eii. Akathi ngai'n inhongring iti kangaidon jarra kei chungnga chong innatan eii!” ");
INSERT INTO kfw_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ama'n hiwa atipha, Pharisee ngaili Sadducee ngai karra insuol inphut ah; mipui rupni insuokjei. ");
INSERT INTO kfw_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ajarchu hongkaring um, marwaan tirton khat-um ratha um ommak tia Sadducee ngai'n inti; takkha Pharisee ngai inchu inthum reella inngamna. ");
INSERT INTO kfw_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Khawakhan khella inhongkheek ah; halli Pharisee rup Sinadan karu ngai lekkhat in inngirra kana ah zootmung intia murruolsiak inleitho, “Eini'n hiwa mipa diang kathamak i-teii mumakmi. Takkha tu-inmo ajet, amadiang ratha inkhat in emakli marwaan tirton inkhat in ileiril lei-ete!” ");
INSERT INTO kfw_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Kanatak ah in-insuolpha, Paul kha alek-alek ah keithernu tia raalmi lamkakeipa in achipuiya, raalmi ngai machumli, Paul kha inmani diangnga inphut kasut inlang, raalmi ngai omna innkhan ruoiru tia chong apejei. ");
INSERT INTO kfw_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Khawani zaankhan Pumi'n ama koolla angirra ati, “Chimaro! ajarchu nang in Jerusalemma kei jarra sakhi nipe angnga, Rome khannum sakhi napesik eii.” ");
INSERT INTO kfw_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ziingkhuo awarli Jihudi ngai ruuk ah inzootna inkhat inneiya, inmani'n Paul hi nithat maklaiseng bak-um baknumin, innum innumin intia inmani inkhat li inkhat khomaak in-insaam jei. ");
INSERT INTO kfw_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Hiwa inzootna kanei miring pasal ngai kha soommili inleikheel. ");
INSERT INTO kfw_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Inmani'n thiampu kalian ngai khat-um uparup ngaidiang insiya inleiti, keini'n Paul hi kinthat maklaiseng i-um mintem nunung tia keini inkhat li inkhat in kana ah khomaak ki-insaam jei. ");
INSERT INTO kfw_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Khawa jarra tuun nangni'n ama jarra inthiangnga kajetzoot inleem inlang nangni diang ama kha injuoruoina sik uparup ngaili nangni khan Rome raalmi lamkakeipa diang chong minsiru; ama'n hiwa mun ahongtung maklai, keini'n ama kha thatnasik kin-insuuk suo jei. ");
INSERT INTO kfw_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Takkha Paul sarnu sapa in thatnasik intho hi ajet pha, ama'n raalmi ngai omna inn aluutli Paul diang ahongmidikjei. ");
INSERT INTO kfw_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Halli Paul in raalmi rajakhat lamkakei inkhat akoiya ati, ruotharpa hi raalmi lamkakeipa diang ruoiro; ama'n ama diang chong lekkhat aril sik om. ");
INSERT INTO kfw_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Khawa jarra ama'n ruotharpa kha aruoiya, raalmi lamkakeipa diang aruoili ati, mikhumna ah kaom Paul in kei anakoili, ruotharpa hi nakoolla chong lekkhat ril sik om, ama hi nang nadiang ruoiro ati. ");
INSERT INTO kfw_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Raalmi lamkakeipa in amakha kut ah ma-ouwa, kaangkhat tiang aruoili, ruuk ah amadiang arakel jei, “Nang in keidiang angme narilsik kaom?” ");
INSERT INTO kfw_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ama'n ati, “Jihudi ngai'n ama jarra kheella akatuun chong karakel sik ininleemma, Paul hi ziingnga nang in uparup ngai diang juoruoina sik-ah nina sik in-inzootna jei. ");
INSERT INTO kfw_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Khawa jarra nang in inmani chong kha juipimaro, ajarchu inmani karra pasal soommili kakheel rup inkhat in ama kha inthat maklaiseng bak-um baknunung, innum innunung tia khomaak in-insaamma ama kha inmaruongnga inom. tuunchu inmani in-insuuk suojei, nang izootpi beikha in-ngaak ejei.” ");
INSERT INTO kfw_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Raalmi lamkakeipa khan ati, “Tuteii inkhat diang um nang in kei diangnga niril chonghi rilpimaro tia.” chong apeli aminsijei. ");
INSERT INTO kfw_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Raalmi lamkakeipa in raalmi rajakhat ngai lamkakei inni akoiya aleiti, awini zaan kuo huuina phadan khan Caesarea katungsik raalmi rajani, sakor kachuong miring soomsari halli kasei kachoi mi rajani insuukru. ");
INSERT INTO kfw_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Halli Paul kha sakor minchuong inlang ramkaroon Felix diang insial-inkuoi omleiya atungnasik, sakor ngaikha insuuk taru. ");
INSERT INTO kfw_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Halli raalmi lamkakeipa in hiwa dungjuiya chemajia inkhat amajia jei; ");
INSERT INTO kfw_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Claudius Lysias, kalok-kalian ramkaroonpa Felix nang nadiang kei'n chubei kanaheitho. ");
INSERT INTO kfw_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hiwa mipahi Jihudi ngai'n insurra, inthatsik pha kei'n ama hi Rome miring eti kajet ah, raalmi ngaile inruoiya inmani diang aphakacha ah kinsiya, ama hi kinjuokatan eii. ");
INSERT INTO kfw_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Inmani'n amahi angsik ah noonkuung inpeme ti ajar kha kajetzoot ah, kei'n ama hi inmani uparup ngai katung karuoi jei. ");
INSERT INTO kfw_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Inmani Sinadan chongrakel jarra ama diang noonkuung inpejei, takkha thatsik emakli mikhumna ah dasik rahoi kasuok chong i-um ommak ti kei'n kamujei. ");
INSERT INTO kfw_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ama thatnasik ah Jihudi ngai'n ruuk ah in-insuukjei ti chong keidiang innamindik pha, kei ama noonkuung kape ngaidiang um namaikuungnga ama chungnga chong juo-inrilru tia chong kapeya, ama hi innot ah nakoolla kiheitir eii. ");
INSERT INTO kfw_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Khawa makheiya raalmi ngai'n chongpeii dungjuiya Paul kha inruoiya zaanna Antipatris katung inhong ruoijei. ");
INSERT INTO kfw_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ziingkhuo awarli inmani'n sakor kachuong mi ngaikha Paul le inruoiya sinasik indali, keraalmi ngai'n in-omna inntiang inheikirjei. ");
INSERT INTO kfw_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Inmani'n Caesarea intung pha, chemajia kha ramkaroonpa diang inpeli, Paul um amaikuungnga inheiruoijei. ");
INSERT INTO kfw_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Halli ama'n chemajia kha ateelli, ama angram miring na-eme tia arakel; halli ama Cilicia makheiya eii ti ajet pha, ");
INSERT INTO kfw_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ama'n ati, “Nang noonkuung kape ngai inheitung pha kei'n nachong karangaisik eii.” Halli ama kha Herod chongtanna innkhan raalpa thoa danasik chong apejei. ");
INSERT INTO kfw_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Nira-nga suonuk Thiampu Kalian Ananias in uparup ngai lekkhat khat-um chongkatanthei araming Tertullus le inruoiya injuochumma, Paul chungnga ramkaroonpa Felix ma-ah inmani'n chong inhongsorjei. ");
INSERT INTO kfw_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Halli Paul kha akoiluut ah Tertullus in amadiang noonkuung pena aphut jei: “E akaraat chungnung Felix! nang jarra keini'n kakheella kahoi-kadai kinmu khat-um keini'n kinram thanasik inbooltharna katamtak kinneijei.” ");
INSERT INTO kfw_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Keini'n amun rakip li apha rakip ah kheella rokpuinale inruoiya hiwahi Felix nachungnga donna kinnei. ");
INSERT INTO kfw_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Takkha kei'n napha kasoot ah naluut maknasik, nang in nazootpi inlang keini chong hi kabongnga narangai pinasik kanani. ");
INSERT INTO kfw_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ajarchu hiwa miring hi inseiinasik katho, nuoipilchung pumpuiya kaom Jihudi rakip ngai kaminhaang khat-um Nazarene rahooi ngai lamkakei mi inkhat eii ti keini'n kimujei. ");
INSERT INTO kfw_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ama'n Biak-inn kha-um minchoknasik athojei, halli keini'n ama kha kinsurjei. (Keini Sinadan dungjuiya ama kha chong kinleitan zoot, ");
INSERT INTO kfw_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","takkha lamkakei Lysias ahongnga keini kutchungnga inphut amakha anakasut jei. ");
INSERT INTO kfw_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Halli ama noonkuung kape ngaikha nakoolla siru tia chong anapejei.) Keini'n ama diangnga noonkuung kinpe rakip jarra nang in amadiang narakelli ama diangnga inphut najetpi nate. ");
INSERT INTO kfw_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jihudi ngai innum noonkuung penasik in-inchunna, khawa kha akatuun eii inti. ");
INSERT INTO kfw_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Halli ramkaroonpa in ama kha chong rilnasik aheiti pha, Paul in aheimasang, Nang in kum angjet hiwa zaat ngai chongkatan nahong eii ti kei'n kajet ah, namaikuungnga kei inngaakna chong rilsik hi karok. ");
INSERT INTO kfw_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kei'n Jerusalemma Pathian chubei thonasik kajuosina hi nisoomleini lakheelmak tihi nang in najet. ");
INSERT INTO kfw_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Halli tu ka-ang inkhatle kei kin-insuol, emakli mipui chungnga Biak-inn khan chong kimasuok, synagogue khat-um khuopui rakip khannum ommak inmani'n namumu. ");
INSERT INTO kfw_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Inmani'n tuun kei diangnga noonkuung innapeii chongkha nangdiang incheen tak ah napemator nunu. ");
INSERT INTO kfw_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kei'n nang nadiang hiwa ngaihi karilsuok: kei'n eini nipi-nipu ngai Pathian chubei kithohi inmani inrilna Pathian minchuna Lam khanna chubei kitho emak; takkha Pathian chongkachoi ngai larik le Moses Danna injia rakip ngaikha kei innum ka-inngamna. ");
INSERT INTO kfw_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mi katha le mi kase rakip in kathiya inphut inhongringnook sik eii tia inmani'n inngaidon kha angnga kei innum Pathian kha inthiangnga kajet ah ka-inngamna. ");
INSERT INTO kfw_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Hiwa jarra kei innum Pathian li mi ngai maikuungnga apha rakip ah akatha li akase thenthei nasik malung inthiang kanei. ");
INSERT INTO kfw_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Kum lekkhat matiang kei'n Jerusalem khan kami ngaidiang sial lekkhat kaleisik le Pathian diang phurpeii penasik kaleisi. ");
INSERT INTO kfw_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Khawa insuthiangna chuon kha kaminhekli Biak-inna kaomlai khan inmani'n innaleimu. mipuichu kei koolla leiommu halli insuol-inseii um lei-ommak. ");
INSERT INTO kfw_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Takkha Asia ramma Jihudi mi lekkhat inchu innamu, Inmani'n keidiang noonkuung innapesik om-inchu, hiwa munhin namaikuungnga hong-inta keidiang noonkuung innahongpesik eii. ");
INSERT INTO kfw_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Emakli uparup maikuungnga kangirlai kimasial om-innum angme hinna kaom ngai'n rilrasu. ");
INSERT INTO kfw_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Akathi ngai'n inhongring nooksik eii ti ngamna jarra hiwa nikhuoni nangni maikuungnga: ‘Kei hi chong-ningnatan eii ti rasa hibitchu kei'n inmani karra kangirlai kaleikheek.’ ” ");
INSERT INTO kfw_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Halli Felix in Pathian minchuna Lam jarra lekkhat inthiangnga ajet-ah, inmani diang ati, “Lysias raalmi ngai lamkakeipa ahongtungli,” “Kei'n nangni chungnga chong kanatanpisik eii aleitipi.” ");
INSERT INTO kfw_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Halli raalmi lamkakeipa diang Paul kha inngaak nasik chong apejei, takkha amadiang ningle-nuom penasik asap ngai'n sansik azootpijei. ");
INSERT INTO kfw_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Halli nikhuo lekkhat suo-ah, Felix in anumei Drusilla Jihudi nu khale inruoiya inheiwali, Paul kha ajuominkoiya, Christa Jisu diang ngamna jarra chong inleirangai. ");
INSERT INTO kfw_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Halli akatuun le apum-insur khat-um akahongsik chongtan nikhuo jarra Paul in ahongril pha, Felix in achiya ahongmasang, “Tuunchu nang sitaro; kei'n aphakacha kamu pha, nahongkoi kate,” ati. ");
INSERT INTO kfw_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Khawa pha Paul in amadiang sial napete tia ama'n aleingaidon; hiwa jarra ama kha innolla akoiya amale inlei-inbiak. ");
INSERT INTO kfw_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Halli kumni suo-ah Porcius Festus in Felix rathuulla waikaroon ejei; takkha Felix in Jihudi ngai izoot kha manuom jarra, Paul kha mikhumna ah aleidajei. ");
INSERT INTO kfw_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus in khawa ram ahongtung nithum suo-ah, Caesarea ah inphut Jerusalem tiang asijei. ");
INSERT INTO kfw_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Halli thiampu kalian ngai khat-um Jihudi lamkakei ngai'n Paul jarra amadiang chong inhongsorjei. ");
INSERT INTO kfw_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Inmani'n Paul kha lamma maruongnga thatnasik inlei-insuuk ah, Jerusalemma Paul hongruoi nasik Festus diang inmani'n riangwai inniya inleiti. ");
INSERT INTO kfw_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","“Paul kha Caesarea mikhumna khan aom, kei sowason sotlekleiya kasisik eii tia Festus in aleimasang. ");
INSERT INTO kfw_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Khawa jarra nangni karra lamkakei ngaile inruoiya Caesarea ah sisuomkinta, ama masialna om-inchu, inmani'n ama kha noonkuung perasu, aleiti.” ");
INSERT INTO kfw_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus in niriat emakli nisoom inmanile alei-omsuomli, Caesarea tiang asijei, ziingkhuo awarli ama'n chongtanna ah in-ongnga, Paul kha heiruoinasik chong apejei. ");
INSERT INTO kfw_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paul aheitung pha, Jerusalemma inphut aheikawa Jihudi ngai'n asir-apangnga inngirra, inmani innum inmu-injetmak jarra noonkuung katamtak ama chungnga inheichoi. ");
INSERT INTO kfw_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Takkha Paul in atheinuo-ah apum inngaaknasik aleimasang: “Jihudi ngai Sinadan chungnga, Biak-inn chungnga, emakli Rome Reng Caesar chungnga, kei'n insial iteii um lathomong.” ");
INSERT INTO kfw_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Takkha Jihudi ngai'n mi katha eii intizoot jarra, Festus in Paul diang aleirakel, “Nang in Jerusalemma siliya, hiwa chongjarra kamaikuungnga chongtansik namanuombe?” ");
INSERT INTO kfw_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul in ati, “Kei chong innatansik Reng Caesar chongtanna ma-ah kei kangirjei, Jihudi ngaidiang kei'n kimasial laom mak. khawa kha nang in inthiangnga nanajetpi. ");
INSERT INTO kfw_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kei kamasial mi ka-e inchu khat-um thinasik rahoikasuok kaleitho leiom inchu kei thinasik zootmak thonuning; takkha hiwa mi ngai'n kei diangnga inheipe noonkuung rakip suungnga akatuun inkhat bit ommak inchu, tu ka-ang inkhat in kei inmani diang napematornunu. Kei'n Reng Caesar maikuungnga rilkate.” ");
INSERT INTO kfw_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Halli Festus in ama chuonkaroon ngai khale in-inbiakli aheimasang, “Nang in Reng Caesar maikuungnga rilkate natijei kengnga, nang Reng Caesar diang nasisik ejei.” ");
INSERT INTO kfw_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nikhuo lekkhat suo-ah, Reng Agrippa khat-um Bernice in Caesarea ah inhongtung, halli Festus kha inhongdon. ");
INSERT INTO kfw_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Inmani'n khawakhan nikhuo lekkhat in-omlai, Festus in Rengpa diang Paul jarra chong aminjet ah ati, “Felix in mikhumna ah asurra ida mi inkhat aom. ");
INSERT INTO kfw_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kei'n Jerusalemma kaomlai hiwa pasalpa jarra thiampu kalian ngai khat-um Jihudi uparup ngai'n ama chungnga noonkuung inpeya kei diang thatru tia chong innahongpeii. ");
INSERT INTO kfw_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kei'n inmani diang kaleimasang, tichu, mi inkhat kha noonkuung inpe inchu noonkuung kape ngaile noonkuung inpepa meel li meel in-inmuwa ama'n apum inngaakna chong aril maklaiseng chongtansik hi eini Rome ngai sinadan emak kaleitipi. ");
INSERT INTO kfw_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Khawa jarra inmani rakip hiwa munhin inhongpha, kei'n minsootleiya, ziingkhuo awarli chongtanna munkhan ka-in-ongnga, mipa kha hongruoinasik chong kaleipejei. ");
INSERT INTO kfw_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Noonkuung kape ngaikhan inhongngirra, ama jarra kileingaidon angnga akathamak iteii um inmani'n heikeisuomu. ");
INSERT INTO kfw_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Takkha inmani noonkuung penakhet khachu inmani inngamna, halli akathijei Jisu inti mi inkhat Paul in aringjei ati jarra murruolsiak intho kha eii. ");
INSERT INTO kfw_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Hiwa ka-ang jarra hin kei'n chong entokdan jetmongnga, ama jerusalemma asiya, hiwa chongjarra chong namintan zootbe tia kirakel eii. ");
INSERT INTO kfw_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Takkha Paul in Caesar Rengpa in chongtanrase aleiti jarra, kei'n amakha Caesar Rengpa diang katir maklaiseng kacheet ah raalpa tho-inlang ngaakru katipijei.” ");
INSERT INTO kfw_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agrippa in Festus diang ati, “Keitak innum hiwa mipa diangnga inphut kajetzoot.” Festus in aleimasang, “Ziingnga ama diangnga inphut nang in rangainate.” ");
INSERT INTO kfw_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ziingkhuo awarli Agrippa li Bernice kha kalurtak ah kayana le inruoiya raalmi lamkakei ngai khat-um khuopui mikalok-mikalian ngaile inruoiya chongrangai nasik munkhan inheiluut. Festus in chong aleipeii halli Paul kha inheikeiluutjei. ");
INSERT INTO kfw_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Halli Festus in ati, “Reng Agrippa khat-um keini le inruoiya akaom suom mi rakip, nangni'n hiwa mipa hi enru, Jihudi mi rakip in Jerusalemma um hinnum amahi karingsik rahoi suokmak tia inkheek ah kei kadiang chong innahongsor. ");
INSERT INTO kfw_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Takkha ama thinasik rahoi kasuok thomak iti kei'n kamu, halli apumtak in Ceasar Rengpa diang chong mintannasik anani jarra kei'n amadiang tirnasik chong kangirjei. ");
INSERT INTO kfw_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Takkha ama jarra kei'n Ceasar Rengpa diang incheenna majiasik iteii jetmong. Hiwa jarra ama chungnga chong nirakel suoli, kei'n majiasik lekkhat jetkate ti ka-ngaidonna, nangni ma ah khat-um aru ka-e khet ah Reng Agrippa namaikuung tak ah ama hi kiheikeisuo eii. ");
INSERT INTO kfw_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ajarchu mikhumna ah kaom mi inkhat kha chongtanna ah, inthiang noonkuung kha jetlekleiya tirsik hi rahoi suokmak tia ka-ngaidon.” ");
INSERT INTO kfw_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Halli Agrippa in Paul diang ati, “Nang in nirilzoot chong rilnasik kanazootpijei.” Khawa pha Paul in akut akeisuo ah inngaakna chong karil aphut jei: ");
INSERT INTO kfw_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“E Reng Agrippa! kei diangnga Jihudi ngai'n noonkuung innape rakip jarra awini namaikuungnga kei'n chong karilsik hi keisik ah rawaan katha eii tia ka-inngaidon,” ");
INSERT INTO kfw_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ajarchu Jihudi ngai sinadan khat-um chongkasuok rakip nang in najet wiak; khawa jarra malung-kaluutle inruoiya kachong nana-rangaipisik hi nang nadiang kanani. ");
INSERT INTO kfw_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Kanaipang changlaiya inphut karam halli Jerusalemma karingkhuo ang-omchanna kihong omme itihi Jihudi rakip in injet.” ");
INSERT INTO kfw_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Inmani'n sakhi pekinte inti inchu, eini sinadan karra kacheet khet Pharisee rahooi inkhat ka-eya kaleiom itihi inmani'n apha matiangnga inphut innaleijetjei. ");
INSERT INTO kfw_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Halli tuunchu eini nipi-nipu ngai diang Pathian chong-inkhitna kha kangamna jarra kei hi tuun chongtansik ah kangirjei. ");
INSERT INTO kfw_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Khawa ngamna kha munasik ah eini phung soomleini ngai'n suunli zaan Pathian kha malung kaluut ah chubei inleitho. Khawa ngamna jarra eii, E reng, kei kadiang Jihudi ngai'n noonkuung innape hi. ");
INSERT INTO kfw_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Pathian in akathi kha minring mator tia nangni'n angsikme ningngamna mak? ");
INSERT INTO kfw_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Keitak innum Nazareth Jisu raming chungnga thokatha sengchu thonasik kaleingaidon.” ");
INSERT INTO kfw_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Khawa chuon kha kei'n Jerusalemma kaleitho; halli thiampu kalian ngai diangnga inphut ranak kamu ah, kei'n Pathian mi angjet mikhumna khan kaleida, halli inmani inthat pha kei um inmani inthat kha kaleizoot. ");
INSERT INTO kfw_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Kei'n synagogue rakip ah inmani kha innolla kaleirachaak, halli inmani inngamna kha minthaannasik um kaleitho, halli kei'n inweet ka-angnga inmani chungnga minpoongnasik ramleiilak khuopui rakip khan kaleisi. ");
INSERT INTO kfw_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Hiwa sik jarra kei'n thiampu kalian ngai diangnga inphut thomatorna ranak khat-um chongpeii kaleiya Damascus ah kaleisi.” ");
INSERT INTO kfw_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kani-inding phakhan, E reng, kani neek ah kawar marwaanna inphut ra-ang inkhat in kei khat-um keile ki-inruoipui ngai chungnga iwar kamu jei. ");
INSERT INTO kfw_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Keini rakip nuoipilchungnga kinpur phakhan, Saul, Saul! nang in angsikme kei ninaminpoong? thir raling nikaper nang sik ah intak, tia kei diang Hebrew chongnga iril rasa inkhat kei'n kajet. ");
INSERT INTO kfw_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Halli kei'n kati, nang tu na-eme Pumi? halli Pumi khan ati, Kei nang in ninaminpoong Jisu kha ka-eii. ");
INSERT INTO kfw_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Takkha inthei inlang ngirro; ajarchu nang kasuok naminchang sik katia, nangdiang ka-inlar ka-eii. Hanna winiya kei ninamu khat-um nuktiangnga kanaminmu sik ngai hi nang in mileiilak ngaidiang narilpisik eii. ");
INSERT INTO kfw_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Kei'n Israel mi ngaidiang khat-um kanatirna zaatlop ngai diangnga inphut kanasansik eii. ");
INSERT INTO kfw_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Inmani'n akaziingnga inphut awarnatiang khat-um Seitan ranak ah inphut Pathian diang hei-inletnasik, manu ngaidamna khat-um kei inna-ngamna jarra kiminthiang ngai karra amun inmuna sik, kei'n nang hi inmani war kaminmusik kinatir eii. ");
INSERT INTO kfw_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Khawa jarra, E reng Agrippa, kei'n marwaanna inphut mangtalar kimu kha kei'n juimak thomong.” ");
INSERT INTO kfw_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Takkha ma-insakhet ah Damascus li Jerusalem mi ngaidiang, halli Judea rampumpui khat-um zaatlop ngaidiang inmani'n inmanu ah inphut inmalung hongthuul nasik, Pathian diang inheikirna sik, khat-um malung thuulna rahoi kasuok chuon ningthosik eii tia kei'n kaleiril. ");
INSERT INTO kfw_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Hiwa jarra Jihudi ngai'n Biak-inn khan kei kaomlai innasurra, halli kei nathatnasik inleitho. ");
INSERT INTO kfw_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Takkha Pathian in awini katung anasanna, halli kei'n hiwahin ka-ngirra kei kasakhi mi rakip diang kasiin akalian diang in-angrip ah kape, hiwa chongtak hi Pathian chongkachoi ngai khat-um Moses in ahong kasuoksik inleiril chong kha eii; ");
INSERT INTO kfw_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","tichu Jihudi ngaile Zaatlop ngaidiang sanminringna war chong karilsuoksik Christa khan poongraal adeiya kathiya inphut mansakhet-ah akaring inkhatsik eii iti kha, eleiya kei'n iteii khat-um leirilmong. ");
INSERT INTO kfw_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paul in apumsik ah aril pha, Festus in rasa inringnga akheek-ah ati, “Paul, nang na-inweetjei; nang in katamma ni-inchu khan nang hi anaminweet jei!” ");
INSERT INTO kfw_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul in ati, E thomatorna kanei Festus, “Kei inweetmong, takkha inthiangnga akatuun kha kiril eii. ");
INSERT INTO kfw_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Reng Agrippa! nangdiang kei'n kachi omleiya karilmator, ajarchu nang in hiwa ngai jarra najetjei. Kei'n ka-inngamna jei khachu nang in inmani rakip kha najetjei, ajarchu hiwa chuon kasuok hi akil inkhat ah akasuok emak. ");
INSERT INTO kfw_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","E reng Agrippa, nang in Pathian chongkachoi ngaikha na-ngamnabe? Nang in na-ngamna iti kei'n kajet!” ");
INSERT INTO kfw_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa in Paul diang ati, “Nang in keihi hiwa phabong lekteii suunghin Christian namin-esik na-ngaidonbe?” ");
INSERT INTO kfw_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Halli Paul in aleimasang, “phabong khat emakli phakasei e-innum,” “Nang le aleiilak nangni awini kachong kajetseng hiwa thirruiya innakhit bit hichu elekleiya ningraja ah kei ning-ang nasik Pathian diang kini eii.” ");
INSERT INTO kfw_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Khawa khan Reng, ramkaroonpa, Bernice, khat-um inmanile in-ongsuom ngaiseng in-intheijei, ");
INSERT INTO kfw_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","halli inmani'n insuok-suo pha inkhatli inkhat in-inti, “Hiwa miring hi athina sik li mikhumna ah danasik rahoi kasuok amasialna ommak inti.” ");
INSERT INTO kfw_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Halli Agrippa in Festus diang ati, “Hiwa mipa in Reng Caesar diang karilsik eii aleitimak inchu, amahi masuo katha ejei.” ");
INSERT INTO kfw_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Keini'n Italy katung rakuong chuongnasik kin-inbiak suo pha, inmani'n Paul khat-um aleiilak mikhumna ah inda mi ngaikha “Ceasar Rengpa Raalmi Rahooi,” inti Rome raalmi rajakhat lamkakeipa Julius intipa diang inheipejei. ");
INSERT INTO kfw_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Halli Asia raaltiang kaom ram inkhattiang sisik katho Adramyttium rakuong inkhat kinchuongnga kinsijei, halli Thessalonica ah kaom Macedonia miring Aristarchus keinile kinlei-inruoi. ");
INSERT INTO kfw_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ziingkhuo awarli keini khan Sidon kinhongtung pha, Julius in Paul kha aminriangnga, ama asap-asuon ngaidiang asiya inmupuinasik khat-um amasik arei kaom inheipesik kha-um aleizootpi jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Khawa munna inphut keini rakuong kinhongsep pha, thikaraang in keini anakhan jarra, keini'n Cyprus tuiram ralitiang kinhongsepjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Halli Cilicia khat-um Pamphylia tuipui kinrakaanna, keini'n Lycia ram Myra kintungjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Khawa munkhan raalmi rajakhat lamkakeipa khan Italy katung insepsik Alexandria rakuong inkhat amuwa, keini kha khawa rakuong khan anaminchuong jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Halli nikhuo angjet keini'n rakuong kinsep zaamma, intaktheiya Cnidus khuopui kha kintungjei, thikaraang khan ajar eya keini matiang sepna minthamakjei, khawa jarra Salmone le in-enret Crete tuiram rali tiang kinhongsep jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Keini'n intaktheiya tuidiilkham tiangbit kinhongsep ah, Lasea khuopui koolla kaom Fair Heaven inti mun inkhat khan kintungjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Keini'n khawa khan rakuong sepsik chi omjarra apha kasoottak kinleiom, halli manu ra-ngaidamna kahoi nikhuo kha-um athengjei. khawa jarra Paul in inmanidiang hiwa chongpe hi aleipeii, ");
INSERT INTO kfw_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Ule-nai ngai, hiwa makheiya chu eini rakuong hi kakoisik, rakuong hinna nichoi phur emakli rakuong bit inmang eleiya niringkhuo katung inmangsik kei'n kamujei.” ");
INSERT INTO kfw_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Takkha raalmi rajakhat lamkakeipa khan rakuong mapupa khat-um rakuong kasep ngai khabit arangaiya, Paul in angme iril kha ra-ngaimakjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Rakuong tungmun khan phalbitha ah omnasik amun hoimak jarra, inmani katamkhat in phalbitha dei thanasik eini'n Phoenix nitung maklaiseng rakuongnga situi inleiti. Phoenix hi Crete ah kaom rakuong tungmun Sim li taitak khat-um Mar li taitak tiang ka-en eii. ");
INSERT INTO kfw_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Sim tiangnga thikaraang kaneem kha karaang ahongphutjei, inmani'n inleingaidon kha tungjei tia inngaidonna, rakuong kasurthir kha inmasuo ah Crete pangtiang innaitirra rakuong insepjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Takkha sootlekleiya Euroclydon inti akangar thipui khan kana ah tuiram makheiya inphut ahongraang jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Khawa thikaraang khan rakuong maikha aseemma amai sur matormungnga, keini thikaraang in anaseemjuon jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Halli sim tiangnga kaom Cauda inti akasiin tuiram inkhat ralitiang kinheisep ah, keini'n kapoongtak ah rakuongteii kha kinjuosurjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Khawa rakuong kha kinkadomma, rakuong kalok khan kinkhit mincheetjei. Libya neelbil tiang nataanpuini tia inchiya, inmani'n rakuong sepna puon kha inkeithaak ah rakuong kha inminsijei. ");
INSERT INTO kfw_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Thipui karaang khan keini kheella anaminpoong pha, ziingkhuo awarli inmani'n rakuongnga inphut phurpai kakalekjuon inphutjei; ");
INSERT INTO kfw_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","halli nithum huuini khan inmani inkut tak-in rakuong phurpai ngaikha inhiaijuon jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Apha kasoottak keini chungnga kani li arsi ngai'n injuowarmak pha, khat-um thipui-thikaraang in keini namakhu pha, keini tuun laringkinte tia ngaidon khaimungjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Inmani bak-inleiya in-omna ahongsoot pha, Paul in inmani karra angirra ati, “E ule-nai ngai, nangni'n kachong ningleijuiya, Crete makheiya rakuong nileisepmak inchu, neinaak inmang ngaile insial ngai rakip hi lei-omnuni. ");
INSERT INTO kfw_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Takkha tuunchu kei'n nangni malung minpoongmak nasik masokna kananei, ajarchu rakuong elekleiya, nangni karra tu-inkhat um ratha inmang omnunijei. ");
INSERT INTO kfw_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ajarchu Kapathian ka-eii halli asepa um kitho Pathian, ama tirton inkhat in miyanni zaankhan kakoolla angirra, ");
INSERT INTO kfw_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","halli anati, ‘Chimaro, Paul! Nang Caesar Rengpa maikuungnga nangirsik eii; halli enro, nangle inruoiya rakuong kachuong rakip-um Pathian in nang nadiang anapejei.’ ");
INSERT INTO kfw_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Khawa jarra ule-nai ngai malung mindong maru, ajarchu kei kadiangnga iti-angnga asuoksik eii tia kei'n Pathian diang kangamna jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Takkha eini tuiram inkhat pangtiang nichulsik ejei.” ");
INSERT INTO kfw_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Takkha nisoomleimili huuini zaankhan, Adria (Mediterranean) tuipuiya keini thipui'n nachoinarei nachoiya, anaruoilai, zaanchim pheiwei khan rakuong kasep ngaikhan tuikham inkhat anaijei tia inleingaidon jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Inmani'n tui inthuuk kha in-uol pha lamsoomni inthuuk iti injetjei; Phabong khatsuo in-uol nook-ah lamsoom leira-nga inthuuk inmujei. ");
INSERT INTO kfw_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Halli keini'n lungpui ngaikhan intheengni tia, kinchiya, rakuong nuktiang surna thir mili kha kinmatali, khuowar nasik nina kinneiya kinleiom. ");
INSERT INTO kfw_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Rakuong kasep ngaikhan rakuong matiang surna thir kakeisuo in-inleemma rakuongteii ngaikha inmachumli taannasik intholaikhan, ");
INSERT INTO kfw_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paul in raalmi rajakhat ngai lamkakeipa khat-um raalmi ngaidiang aleiti, “Inmani'n rakuong suunghin in-ommak inchu, nangni ringnutun.” ");
INSERT INTO kfw_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Khawa pha raalmi ngaikhan rakuongteii rui ngaikha intanna inmasuojei. ");
INSERT INTO kfw_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Halli khuowar siktiang Paul in inmani rakip bu lekkhat baknasik aleiti: “Nangni'n nisoomleimili hi ningaak-ah iteii khatbit bakleiya bu ningheingei jei. ");
INSERT INTO kfw_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Khawa jarra kei'n nangni bu lekkhat bakru kanati, hiwahi nangni ningringnasik eii, ajarchu ninglu ah ningsam inkhat bit-um inmangnuni.” ");
INSERT INTO kfw_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ama'n hiwahi arilli, waipool kha aleiya mi rakipsik Pathian diang anili, akather khoiya inbakjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Khawapha mi rakip inratha inminrok ah inmani tak-um inbakjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Khawa rakuong suungkhan keini miring rajanile soomsarileiruk kinleichuong. ");
INSERT INTO kfw_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Inmani'n inwon inminsip suopha, tuipui suungnga gehu kha inmata-ah rakuong kha inminzaangjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Halli ziingkhuo ahongwarpha, inmani'n ram kha jetmujei; takkha inmani'n lung indang natiang kaluut tuikil inkhat inmani'n inmujei; khawakhan rakuong hi sepluut-ah makoileiya damatorminbo tia inmani'n inlei-insiam. ");
INSERT INTO kfw_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Khawa jarra inmani'n rakuong minsurna thirrui kha intanna tuipui suungkhan inmatajei; khawa phatak khan rakuongrui kha insuutjei, halli rakuong kataanpui puon kha inkeikalla khawa tuikiltiang sinasik inmani'n inleitho. ");
INSERT INTO kfw_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Takkha rakuong kha tuipui inni inchunna siatbungnga asuk-ah rakuong kha akoijei halli rakuong lu kha asukdeenna siing-insamakjei, rakuonglel kha tuiphuuksaan khan azeemma aheikoijei. ");
INSERT INTO kfw_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Inheisur ngaikha tui-inhaiya suok acha intia, inmani kha thatrui tia raalmi ngaikhan chong inlei-insiamjei. ");
INSERT INTO kfw_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Takkha Paul kha thatzoot mak-ah, raalmi rajakhat lamkakeipa khan inmani chong-insiam kha aleikhaap jei; khawa rathuulla tui-kahai mator ngaikhan ma-insakhet ah inchoomthaak inlang, tuipui khamtiang tungrasu tia chongpeii aleipeii; ");
INSERT INTO kfw_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","halli alakaom ngaikhan, tu ka-ang ngai'n khumpeek mahuumso-inlang, khat-um lekkhat in rakuong kakoi lek chuongsunlang rakaanrasu tia chong apejei. khan kinthoa kinraja-ah kinringnga tuikhamtiang kintungjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Keini'n karingnga tuikham kintung pha, khawa tuiram kha Malta eii ti keini'n kinjetjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Halli khawa ramma mi ngaikhan keinidiang innaminriang hi lekteii emak, ajarchu ruo kasur khat-um adai jarra, inmani'n mei innathopiya, keini rakip kha innaleidon jei. ");
INSERT INTO kfw_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul in thing ajuokhoomma meiya atuoli, mei ahonglum pha maruul inkhat ahongsuok ah paul kutkhan kaherjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Khawa ramma mi ngaikhan Paul kut-ah atur kangar maruul khan ikaikha inmupha, inmani inkhatli inkhat in-inti, hiwa mi hi mikathat alei-echeise, ama'n tuipuiya inphut aring innum, arasi inchu ama karingsik zootmak. ");
INSERT INTO kfw_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Takkha ama'n maruul kha meisuungnga kathingthaak-ah, iteii tikhai makjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ama hong-inthingta emakli jetlei-theileiya purta athisik eii tia inmani'n inleingaidon; takkha inmani'n kasoot-ah in-enna, halli amadiang iteii-um timak inmupha, inmani malung ngaidonkha inthuulla inti, “Ama Pathian inkhat eii!” intijei. ");
INSERT INTO kfw_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Khawa mun koolla ram lekkhat kanei khawa tuiram karoonpa Publius inti inkhat aleiom; ama'n keini anaruoiya, nithum malung kalok-ah anadonjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publius pa kha ritun khat-um eeksen khan ana-ah aleizaal. Paul in amadiang aluut-ah, Pathian anili, achungnga akut aduongpiya ama kha amindampi jei. ");
INSERT INTO kfw_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Hiwa athopipha, khawa tuiramma kaom akana leiilak rakip ngai-um inhongnga akana amindampi jei. ");
INSERT INTO kfw_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Inmani'n karokle inruoiya keinidiang kutchoi phur katamma innapeya, rakuong suungnga kinsilaiseng keini sik-ah arei kaomseng inmani'n innathunpi, halli keini'n rakuong kinhongchuong jei. ");
INSERT INTO kfw_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Thathum suo, tuiram khanna phalbitha lei-inseng, “Inphir Pathian ramil,” inti Alexandria rakuong inkhat khan keini'n kinchuongjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Keini'n Syracuse khuopui kinhongtungnga, khawakhan keini'n nithum kinomjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Khawa khanna inphut kinkuoiya Rhegius khuopui kintungjei; ziingkhuo awarli sim tiangnga thi ahongraang, nini huuini khan keini'n Puteoli khuopui khan kinheiwajei. ");
INSERT INTO kfw_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Khawa munkhan Pathian kangamna ule-nai kin-inmupuiya, keini kha inmani'n nisari omsuomrui inheiti; halli keini Rome tiangkhan kinheiwajei. ");
INSERT INTO kfw_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Rome khanna kaom ule-nai ngaikhan keini chong injetpha, Appius Phaipui khat-um Inntun Inthum inti mun katung keini kanadonsik inleihong, Paul in inmani amupha, ama'n Pathian inminpaak halli aroktheijei. ");
INSERT INTO kfw_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Keini'n Rome kinluut pha, Paul raalpa kathosik raalmi ngai khale inruoiya atheinuo-ah omnasik inzootpi jei. ");
INSERT INTO kfw_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Khawasuo nithum omli ama'n Jihudi lamkakei ngai aleikoichun; inmani'n inlei-inchunpha, ama'n inmani diang ati, “E ule-nai ngai, kei'n kaphung emakli nipi-nipu ngai sina-danle inhal kaleithomak innum, kei Jerusalem mikhumna-ah innada halli Rome mi ngai kutchungnga innapejei. ");
INSERT INTO kfw_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rome mi ngai'n kei chong innarakella, keidiang nathatnasik chong iteii ommak jarra inmani'n kei innaleimasuo zoot. ");
INSERT INTO kfw_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Jihudi ngai'n khawakha leizootmu jarra, kei'n kaphung kami ngaidiang kamasialna iteii ommak innum, kei hi Caesar Rengpa diang karil simak chamakjei. ");
INSERT INTO kfw_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Khawa jarra hiwasik bit-ah kei'n nangni inmupuinasik khat-um inbiakpuina sik kinakoi eii, ajarchu Israel ngai'n inngaidonchak ama jarra kei hi thirruiya innakhit eii.” ");
INSERT INTO kfw_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Inmani'n amadiang inti, “Keini'n Judea ah inphut nang jarra chemajia inkhat um mumung, halli ule-nai inkhat innum hiwahin hong-inlang, najarra chong kathamak inhongril um ommak.” ");
INSERT INTO kfw_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Takkha nang-ingaidon kha angme iti keini'n kinrangaizoot, ajarchu hiwa rupngai chungnga amun rakip ah inril keini'n kinjet. ");
INSERT INTO kfw_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Halli inmani'n amadiang nikhuo khat inmadan puiya, inmani katamtak ama omna suungkhan inhongjei. Inmani diang ama'n Moses Sinadan khat-um Pathian chongkachoi ngai larik-ah inphut Pathian Rengram jarra sakhi apeya, Jisu kha inmani'n inngamnasik ziingtiangnga inphut zaan katung aleiminchu. ");
INSERT INTO kfw_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Lekkhat in iminchu chongkha inngamnajei, takkha lekkhat inchu leingamnamu. ");
INSERT INTO kfw_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Khawa jarra inmani inkhatli inkhat inzootmu-ah in-inthenjei. In-inthen maklai Paul in inmani diang chongkhat aleiril, “Ratha Inthiang in Pathian chongkachoipa Isaiah inliingna-ah eini nipi-nipu ngaidiang ileiminril kha-eii. ");
INSERT INTO kfw_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ajarchu ama'n aleiti, ‘Hiwa mi ngaidiang si-inlang warilro: Nangni'n rangaichu rangai ningte, takkha supjet jetnutun; nangni'n enchu enni