﻿USE sofia;
DROP TABLE IF EXISTS sofia.kff_vpl;
CREATE TABLE kff_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES kff_vpl WRITE;
INSERT INTO kff_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଇଦ୍ ଆଦୁତ୍‍ତେ ଜିସୁ କ୍ରିଷ୍ଟନ୍ ଆନିଦାଦିଡ଼୍‍ତେ ପେଦେର୍ । ଅଣ୍ଡ୍‌ ଦାଉଦ୍‍ତେ ବଂଶତଣ୍ଡ୍ ନୁ ଦାଉଦ୍ ଅବ୍ରାହାମ୍‍ତେ ବଂଶତଣ୍ଡ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍ରାହାମ୍‍ ତେ ମାର୍‍ ଇସ୍‍ହାକ୍; ଇସ୍‍ହାକ୍‍ତେ ମାର୍‍ ଯାକୁବ୍‍; ଯାକୁବ୍‍ତେ ମାର୍‍ ଯିହୁଦା ନୁ ତାନ୍ ତାମୁଣ୍ଡୁକିଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଯିହୁଦା ତାମର୍‍ତେ ଜେରହନ୍ ବାବାଲ୍ । ମେଣ୍ଡେ ତାମ୍ ମାର୍‍ ଅଡ଼୍‌ ୟାୟ୍‍ ମାତ୍‍ତେ; ମାଲ୍‍ତନ୍ ହେସ୍ରନତେ ବାବାଲ୍ ମାତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ହେସ୍ରନତେ ମାର୍‍ ଆରାମ୍; ଆରାମ୍‍ତେ ମାର୍‍ ଅମିନାଦାବ; ଅମିନାଦାବ୍‌ତେ ମାର୍‍ ନହଶୋନ; ନହଶୋନତେ ମାର୍‍ ସଲ୍‍ମନ୍; ");
INSERT INTO kff_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲ୍‍ମନ୍‍ତେ ମାର୍‍ ବୟଜ ମେଣ୍ଡେ ରାହାବ ତାମ୍ ୟାୟ୍‍ ମାତ୍‍ତେ; ବୟଜତେ ମାର୍‍ ଓବେଦ୍ ମେଣ୍ଡେ ଋତ୍‍ ତାମ୍ ୟାୟ୍‍ ମାତ୍‍ତେ; ଓବେଦ୍‍ତେ ମାର୍‍ ଯେଶୀ; ");
INSERT INTO kff_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଯେଶୀତେ ମାର୍‍ ଦାଉଦ୍ ରାଜା । ଦାଉଦ୍‍ତେ ମାର୍‍ ଶଲୋମନ୍; ଶଲୋମନ୍‍ତେ ୟାୟ୍‍ ମୁନେନ୍ ଉରିୟତେ ମୁତ୍‍ତେ ମାତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ଶଲୋମନ୍‍ତେ ମାର୍‍ ରହବୟାମ୍; ରହବୟାମ୍‍ତେ ମାର୍‍ ଅବିୟ; ");
INSERT INTO kff_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଅବିୟତେ ମାର୍‍ ଅସା; ଅସାନ୍ ମାର୍‍ ଜିହଶାପାଟ୍‍; ଜିହଶାପାଟ୍‍ତେ ମାର୍‍ ଜରାମ୍; ଜରାମ୍‍ତେ ମାର୍‍ ଉଜିୟ; ");
INSERT INTO kff_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜିୟତେ ମାର୍‍ ଜତାମ୍; ଜତାମ୍‍ତେ ମାର୍‍ ଅହାଜ; ଆହାଜତେ ମାର୍‍ ହିଜକିୟ; ");
INSERT INTO kff_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ହିଜକିୟତେ ମାର୍‍ ମନଶେହ; ମନଶେହତେ ମାର୍‍ ଆମନ୍; ");
INSERT INTO kff_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଆମନ୍‍ତେ ମାର୍‍ ଜଶିୟ; ଜଶିୟତେ ମାର୍‍ ଜିକନିୟ ନୁ ତାମ୍ ଦାଦାଲଡ଼୍‍; ଇଦ୍ ସମୟ୍‍ତେ ଇସ୍ରାଲୀୟଡ଼୍‍କିଂଙ୍କ୍ ବାବିଲନ୍ ଦେଶ୍‍ତାଗ୍ ତଅସ୍‍ମେଣ୍ଡେ ଆତ୍‍ତଡ଼୍ ଆଦ୍ ସମୟ୍‍ତେ ଜିକନିୟ ଜନମ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ବାବିଲନ୍‍ତାଗ୍ ତଅସ୍ ଆତ୍‍ତେ ପେର୍କେ ଜିକନିୟନ୍ ମାର୍‍ ଶଆଲ୍‍ତୀୟେଲ୍ ବାବିଲନ୍‍ତାଗ୍ ଜନମ୍ ଆତ୍‍ତଣ୍ଡ୍ । ଶଆଲ୍‍ତୀୟେଲ୍‍ତେ ମାର୍‍ ଜିରୁବାବେଲ୍; ");
INSERT INTO kff_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲ୍‍ତେ ମାର୍‍ ଅବୀହୁଦ୍; ଅବୀହୁଦ୍‍ତେ ମାର୍‍ ଏଲିୟାକମ; ଏଲିୟାକମତେ ମାର୍‍ ଅଜ୍‍ଜୁର; ");
INSERT INTO kff_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଅଜ୍‍ଜୁରତେ ମାର୍‍ ସାଦକ; ସାଦକତେ ମାର୍‍ ଜାକୀନ; ଜାକିନତେ ମାର୍‍ ଏଲୀହୁଦ୍; ଏଲୀହୁଦ୍‍ତେ ମାର୍‍ ଲାଜାର୍; ଲାଜାର୍‍ତେ ମାର୍‍ ମତ୍‍ତାନ୍; ");
INSERT INTO kff_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ମତ୍‍ତାନତେ ମାର୍‍ ଯାକୁବ୍; ଯାକୁବ୍‍ତେ ମାର୍‍ ଜସେପ୍ । ");
INSERT INTO kff_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ହି ଜସେପ୍ ମରିୟମ୍‍ତିଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ । ମରୀୟମ୍‍ ତେ ଡଙ୍କେତାଗାଙ୍କ୍ ଜିସୁ ଜନମ୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ । ଜିସୁ କ୍ରିଷ୍ଟ ମସିହ ପେଦେର୍‍ତେ ମିକା ପୁତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଇଦ୍‍ରକମ୍ ଅବ୍ରାହାମ୍‍ ତାଗାଙ୍କ୍ ଦାଉଦ୍‍ତାଗ୍ ହେୱୁନା ଚଉଦଟାନ୍ ପିଡ଼ି; ଦାଉଦତାଗାଙ୍କ୍ ବାବିଲନ୍ ବନ୍ଦି ହେୱୁନା ଚଉଦଟାନ୍ ପିଡ଼ି ନୁ ବାବିଲନ୍ ବନ୍ଦିତାଗାଙ୍କ୍ କ୍ରିଷ୍ଟନ୍ ଜନମ୍ ହେୱୁନା ଚଉଦଟାନ୍ ପିଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଇଦ୍ ଆଦୁତ୍‍ତେ ଜିସୁ କ୍ରିଷ୍ଟନ୍ ଜନମ୍ କବର୍ । ତାମ୍ ୟାୟ୍‍ ମରୀୟମ୍‍ ତାଦ୍ ଜସେପ୍ ତଡ଼୍ ନିର୍ବନ୍ଦ୍ ଆସ୍‍ମାତ୍‍ତେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼ାଦ୍‌ ପେଣ୍ଡୁଲ୍ ଆଦ୍‍ଦାନ୍ ମୁନେଙ୍କ୍ ମରୀୟମ୍ ପୁତ୍‍ତେ ଯେ ପବିତ୍ର ଆତ୍ମାତେ ଆଦ୍ ଡଙ୍କେତ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ଜସେପ୍ ସାରେଦାମ୍ ନେଲେତାଦ୍ ପାଡ଼୍‍ୟି ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ । ଆଦ୍‍ଦିଙ୍କ୍ ମରିୟମ୍‍ତିଙ୍କ୍ ନାରୁଡ଼ାଦ୍ ନିନ୍ଦ୍‍ତାଗାଙ୍କ୍ ରକ୍ଷା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ମିଞ୍ଜି ନିର୍ବନ୍ଦ୍‍ତିଙ୍କ୍ ମନାମାଡ଼ାଙ୍କ୍ ଚିନ୍ତେ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ଅଣ୍ଡ୍‌ ଇଦ୍‍ରକମ୍ ଆଲ୍‍ସାନ୍ ୱେଲେ ୱେରଣ୍ଡ୍ ଇଶ୍ୱର୍‌ତେ ଦୂତ ଅଂକିଙ୍କ୍‌ ସପ୍ନତେ ତନ୍ଦି କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଦାଉଦ୍‍ ବଂଶତନି ଜସେପ୍ ! ମରୀୟମ୍‍ ତିଙ୍କ୍ ମୁତ୍‍ତେ ଇଞ୍ଜ ଗ୍ରହନ୍ ମାଡ଼ାଙ୍କ୍ ୱେର୍‍ମା, ବାତେଙ୍କ୍ ଇତ୍‍କେ ପବିତ୍ର ଆତ୍ମା ତଡ଼୍ ଆଦ୍ ଡଙ୍କେତ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ତାଂକିଙ୍କ୍ ୱେରନ୍ ମାର୍‍ ଜନମ୍ ଆଦ୍‍ତଣ୍ଡ୍‍ । ନିମ୍‍ ଅନ୍‌ ପେଦେର୍ ‘ଜିସୁ’ ୱାଟିତି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ତାମ୍ ନାରୁଡ଼୍‍କ୍ ତାମାଦ୍ ପାପ୍‌ତାଗାଙ୍କ୍ ରକ୍ଷା ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ଇଶ୍ୱର୍ ୱେରଣ୍ଡ୍ ବାବବାଦିନ୍ ତଡ଼୍ ବେନ୍ ବବିଷ୍ୟବାଣି କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ସାରେ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଇଦ୍‍ସାରେ ଗଟେମ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ଆଦ୍ ବବିଷ୍ୟବାଣି ଆଦୁତ୍‍ତେ, “ଅଣ୍ଡୟ୍‌‍ ପିକିଡ଼୍ ଡଙ୍କେତ୍ ଆସ୍ ମାର୍‍ ଜନମ୍ ମାଡ଼୍‌ତେ । ଅଣ୍ଡ୍‌ ମାର୍‍ ‘ଇମାନୁୟେଲ୍’ ଇତ୍‍କେ ଇଶ୍ୱର୍ ମାନ୍‍ତଡ଼୍ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଜସେପ୍‍ତେ ଉସ୍‍କାଡ଼୍ ତେର୍‍ତେ ପାୟେ ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ଦୂତତେ ଗଟ୍‌ ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ମରିୟମ୍‍ତିଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦିନ୍ ଆଦ୍ ମାର୍‍ ଜନମ୍ ଆଦାନ୍ ଯାକ ତାନ୍ ତଡ଼୍ ଉଞ୍ଜଣ୍ଡ୍ । ଜସେପ୍ ଆ ମାର୍‍ରିଙ୍କ୍ ଜିସୁ ପେଦେର୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ହେରଦ୍ ଶାସନ୍‍ ମାଡ଼ାନ୍ ୱେଲେ ଯିହୁଦା ଦେଶ୍‍ତେ ବେତ୍‍ଲିହିମ୍ ଟାଉନ୍‍ତାଗ୍ ଜିସୁ ଜନମ୍ ଆତ୍‍ତଣ୍ଡ୍ । ଇଦିନ୍ ସୁଦୁଟ୍ ଦିନାମ୍ ପେର୍କେ ମୁନେଙ୍କ୍‍ତେ ଦେଶତଡ଼୍‍ ବେସ୍‍କ୍‍ତଡ଼୍‍ ଜ୍ଞାନିନାରୁଡ଼୍ ଜିରୁଶାଲମ୍‍ତାଗ୍ ୱାସ୍ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ବେନ୍ ବାବୁ ଯିହୁଦିଡ଼୍ ରାଜାଲ୍‍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଜନମ୍ ଆତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବେକେ ? ମୁନେତ୍ ମାବ୍‍ତାଗ୍ ଅନାଦ୍‌ ଉକାମ୍ ଉଡ଼ି ଅଂକିଙ୍କ୍‌ ପୂଜା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ମାମ୍‍ମେ ୱାତ୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ଅଡ଼ାଦ୍‌ ଇଦ୍ ଗଟ୍ କେଞ୍ଜି ରାଜାଲ୍‌ ହେରଦ୍ ନୁ ଜିରୁଶାଲମ୍‍ତେ ସାରେତଡ଼୍ ଗାଟି ଦାନ୍ଦେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ହେରଦ୍ ସାରେ ମୁକ୍ୟ ଜାଜକ୍ ନୁ ସାରେ ଦର୍ମଗୁରୁଡ଼୍‍କ୍ କାର୍‍ଙ୍ଗି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍‍, “ମସିହ ଇତ୍‍କେ କ୍ରିଷ୍ଟ ବେଗେ ଜନମ୍ ଆତ୍‌ତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ଯିହୁଦା ଦେଶ୍‍ତେ ବେତ୍‍ଲିହିମ୍‍ତାଗ୍ ।” ଇଦ୍ ବିଷୟ୍‍ତେ ୱେରଣ୍ଡ୍ ବାବବାଦୀ ଲେକିମିନ୍ଦେଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ଯିହୁଦା ଦେଶ୍‍ତେ ବେତ୍‍ଲିହିମ୍ ! ଯିହୁଦାତେ ମୁକ୍ୟ ସହର୍ ନାଗାଙ୍କ୍ ନିମ୍‍ ସୁଦୁର୍ ଆୟ୍‍ୱିନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ଇସ୍ରାୟେଲିୟ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପଡ଼୍‍ପାନ୍ ମାଇଦିଙ୍କ୍ ନିୟାଗ୍ କଞ୍ଜ୍ ୱେରଣ୍ଡ୍ ରାଜାଲ୍ ଜନମ୍‌ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଇଦ୍ କେଞ୍ଜି ହେରଦ୍ ମୁନେତ୍ ଦେଶ୍‍ତେ ଆଦ୍ ଜ୍ଞାନିଡ଼୍‍କିଙ୍କ୍ ଅଣ୍ଡୟ୍‌‍ ଗୁପ୍ତ ମିଟିଙ୍କ୍‍ତାଗ୍ କାର୍‍ଙ୍ଗି ଟିକ୍ ବେନ୍ ସମୟ୍‍ତେ ଆଦ୍ ଉକାମ୍ ପେୟିସ୍ ମାତ୍‍ତେ, ଅଡ଼୍‌ଆଗାଙ୍କ୍ ବୁଜେମ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ତାନ୍ ପେର୍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେତ୍‍ଲିହିମ୍ ଟାଉନ୍‍ତାଗ୍ ରଅସ୍ କେତ୍‍ତଣ୍ଡ୍, “ଆନୁଟ୍ ଆ ପେକାଙ୍କ୍ ସାୟେ ମାଡ଼ି ମେହେକାଟ୍ ନୁ ଅଂକିଙ୍କ୍‌ ଦର୍‍ସ୍‍କି ନାକିଂଙ୍କ୍ କେଲାଟ୍, ନାନ୍ ମିକା ଆଞ୍ଜ୍ ଅଂକିଙ୍କ୍‌ ପୂଜା ମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ଜ୍ଞାନିଡ଼୍ ଆଦ୍ ପଡ଼ିୟେ ୱିଡ଼୍‍ସି ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଅଡ଼୍‌ ହାର୍‍ଦାଗ୍ ଆଦାନ୍ ୱେଲେ, ମୁନେତ୍ ମାବ୍‍ତାଗ୍ ଉଡ଼ିମାତ୍‍ତାଦ୍ ଆଦ୍ ଉକାମ୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ତଅନ୍‌ଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ଆଦିଙ୍କ୍ ଉଡ଼ି ଅଡ଼ାଦ୍‌ ବେସର୍ ୱେଡ଼୍‍କା ଆୟ୍‍ୟ ! ଅଡ଼୍‌ ବେସର୍ ସାର୍ଦେ ଆଦ୍‍ତଡ଼୍ ! ଅଡ଼୍‌ ମୁନ୍‍ ଆଞ୍ଜ୍ ଉକାମ୍ ବାବୁ ମାନ୍ଦାନ୍ ଲୋତ୍‍ତେ ପର୍‍ର ନିତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ଅଡ଼୍‌ ଆଦ୍ ଲୋତ୍‍ତେ ଲପ୍ ହସ୍‍ତଡ଼୍ ନୁ ବାବୁଙ୍କ୍ ୟାୟ୍‍ ମରୀୟମ୍‍ ତେ ତଡ଼୍ ଉଡ଼ି ମର୍‍ମିଣ୍ଡାଇସ୍ ନମସ୍କାର୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ତାସ୍‍ମାନ୍ଦାନ୍ ସୁନା, କୁନ୍ଦୁରୁ ନୁ ସାଏତ୍ ଗାବ୍‍ତାଦ୍ ରସ୍ ପେସ୍‍ପିଇ ଅଂକିଙ୍କ୍‌ ଉପହାର୍ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଇଦିନ୍ ପେର୍କେ ଅଡ଼୍‌ ମେଣ୍ଡେଅନ୍‌ ହାର୍ ଇସ୍‌ ନିଜେତ୍ ଦେଶ୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆତ୍‌ତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ହେରଦନ୍ ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ଆନ୍‌‍ମାକିଡ଼୍ ଇଞ୍ଜ ଇଶ୍ୱର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାପ୍ନେତେ ଗଟ୍ ଇସ୍‌‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ଅଡ଼୍‌ ଆତ୍‍ତେ ପେର୍କେ ଇଶ୍ୱର୍‌ତେ ଦୂତ ଯୋସେପ୍‍ତିଙ୍କ୍ ସପ୍ନତେ ଦର୍ଶନ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହେରଦ୍ ପେକାଙ୍କ୍ ଆୱୁକାଙ୍କ୍ ମାଇଦିଙ୍କ୍ ମେହେକିତଣ୍ଡ୍ । ଆଦିଙ୍କ୍ ତେଦ୍‍ଦେ, ବାବୁଙ୍କ୍ ନୁ ତାମ୍ ୟାୟାଙ୍କ୍ ପଇସ୍ ମିସର୍ ଦେଶ୍‍ତାଗ୍ ମିର୍‍ରେ । ଆଦ୍ ପଡ଼୍‍ୟି ୱିଡ଼୍‍ସାଙ୍କ୍ କେଲ୍‍ୱେ ଯାକ ଆଗେ ମାନୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ଯୋସେପ୍ ତେଦି ପେକାଙ୍କ୍ ନୁ ତାମ୍ ୟାୟାଙ୍କ୍ ପଇସ୍ ଆଦ୍ ନାର୍‍କେତ୍ ମିସର୍ ଦେଶ୍‍ତା ଆତ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ହେରଦ୍‍ତେ ଡଲାନ୍ ଯାକ ଅଡ଼୍‌ ଆଗେ ମାତ୍‍ତଡ଼୍ । ଇଦ୍ ସାରେ ଗଟେମ୍ ଆତ୍‍ତାଙ୍କ୍ ବାବବାଦିଡ଼ାଦ୍ ବବିଷ୍ୟବାଣି ସାରେ ଆତ୍‍ତେ । ଅଣ୍ଡ୍‌ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, “ନା ମାର୍‍ରିଙ୍କ୍ ନାନ୍ ମିସର୍ ଦେଶ୍‍ତାଗ୍ କାର୍‍ଙ୍ଗି ତାତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ମୁନେତ୍ ଦେଶ୍‍ତାଗାଙ୍କ୍ ୱାସ୍ ମାନ୍ଦାନ୍ ଜ୍ଞାନିଡ଼୍ ଅଂକିଙ୍କ୍‌ ବୁସାମାଡ଼ି ଆତ୍‍ତଡ଼୍‍ ଇଞ୍ଜ ପୁଞ୍ଜ୍, ହେରଦ୍ ଗାଟି କପାମ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ବେତ୍‍ଲିହିମ୍ ନୁ ଆଦିନ୍ ଗାର୍‍ରେ ଗାର୍‍ରେତ୍ ପଡ଼ିୟେତାଗ୍ ମାନ୍ଦାନ୍ ରେଣ୍ଡ୍ ହେଣ୍ଡ୍‍କ୍ ନୁ ସୁଦୁଟ୍ ବୟସ୍‍ତେ ସାରେ ପିଲାଙ୍କ୍ ହାଉକାଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଉକାମ୍ ପେୟ୍‍ତାଦ୍ ଦିନାମ୍ ବିଷୟ୍‍ତେ ଜ୍ଞାନିଡ଼ାଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ବାତ୍ କେଞ୍ଜି ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଲେକାମ୍ ଅଣ୍ଡ୍‌ ପିଲାନାୱୁ ବୟସ୍‌ତାଦ୍ ସିମା ପୁଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ଇଦିନ୍ ତଡ଼୍ ବାବବାଦୀ ଜିରିମୀୟତେ ଅଣ୍ଡୟ୍‌ ବବିଷ୍ୟବାଣି ସାରେ ଆତ୍‍ତେ । ଅଣ୍ଡ୍‌ ଲେକିମାତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରାମା ସହର୍ କନ୍‍ସ୍ କିଡ଼୍‍କାନାଦ୍ ଲେଙ୍ଗ୍‌ ୱାଦୁତ୍ ଆଦ୍ ଦୁଃକାମ୍‍ତେ କେୟାନାଦ୍ ଲେଙ୍ଗ୍ ରାହେଲ୍ ତାନ୍ ପିଲାନ୍ ସେଙ୍ଗେ କେୟୁତ୍‍; ଅଂକିଙ୍କ୍‌ ବେନ୍ ଗଟ୍‍ତେମିକା ବୁଜାମାଡ଼ାନଙ୍କ୍ ଆୟ୍‍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ସାରେତଡ଼୍ ଡଲ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ହେରଦନ୍ ଡଲ୍‍ତେ ପେର୍କେ ପ୍ରବୁନ୍ ଦୂତ ମିସର୍‍ତାଗ୍ ଜସେପ୍‍ତିଙ୍କ୍ ଦର୍ଶନ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ତେଦ୍‍ଦେ, ପେକାଙ୍କ୍ ନୁ ତାମ୍ ୟାୟାଙ୍କ୍ ଅସ୍ ଇସ୍ରାୟେଲ୍ ଦେଶ୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆନ୍‌ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନଡ଼୍ ଅଂକିଙ୍କ୍‌ ଜିୱୁଣ୍ଡ୍‌ ମାଡ଼ାଙ୍କ୍ ଆଲ୍‍ସି ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଡଲ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ଆଦିଙ୍କ୍ ଜସେପ୍ ପେକାଙ୍କ୍ ନୁ ମରିୟମ୍‍ତିଙ୍କ୍ ଅସ୍ ଇସ୍ରାୟେଲ୍ ଦେଶ୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆତ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ବାତେଙ୍କ୍ ଇତ୍‍କେ ହେରଦନ୍ ପେର୍କେ ତାନ୍ ମାର୍‍ ଆରକିଲାୟ୍ ଯିହୁଦାତେ ରାଜାଲ୍ ଆତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ କେଞ୍ଜି ଅଣ୍ଡ୍‌ ଆଗେ ଆତ୍‍ତାଙ୍କ୍ ୱେର୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ମେଣ୍ଡେନ୍‍ଦାମ୍ ମେଣ୍ଡ୍‍ଅଣ୍ଡ୍‌‍ରକମ୍ ସପ୍ନତେ ଗଟ୍ ପାଏମ୍‍ଆସ୍ ଅଣ୍ଡ୍‌ ଗାଲିଲୀ ପ୍ରଦେଶ୍‍ତେ ନାଜରିତିୟ ସହର୍‍ତାଗ୍ ଲୋନ୍‌ ମାଡ଼ି ଆଗେ ମାତ୍‍ତଣ୍ଡ୍ । ଇଦିନ୍‍ତଡ଼୍ ବାବବାଦୀଡ଼ାଦ୍ ମଦଲ୍ କେତ୍‍ତାଦ୍ ଅଣ୍ଡୟ୍‌ ବାକ୍ୟ ସାରେ ଆତ୍‍ତେ, “ଅଣ୍ଡ୍‌ ନାଜରିତିୟ ଇଞ୍ଜ ପୁତ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ଆଦ୍ ସମୟ୍‍ତେ ବାପ୍ତିଜକ ଯୋହନ୍‌ ଯିହୁଦା ପ୍ରଦେଶ୍‍ତେ ଉଚ୍‍କନେଲ୍ ପଡ଼ିୟେତାଗ୍ ୱାସ୍ ପ୍ରଚାର୍‍ମାଡ଼ାଙ୍କ୍ ଆରାମ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ଅଣ୍ଡ୍‌ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, “ପାପ୍ ହାର୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ମୁଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‍ ରାଜ୍ୟ ମି ଗାର୍‍ରେ ୱାସ୍ ହେୱ୍‍ସ୍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ଯିଶାଇ ବାବବାଦୀ ବେନ୍ ନାରୁଡ଼୍ ବିଷୟ୍‍ତେ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଯୋହନ୍‌ ଆଦୁତନ୍ ଆଦ୍ ନାରୁଡ଼୍, “ଉଚ୍‍କନେଲ୍‍ତାଗ୍ ବେନ ୱେରଣ୍ଡ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତୁତଣ୍ଡ୍, ପ୍ରବୁନ୍ ମାଇଦିଙ୍କ୍ ହାର୍ ତିଆର୍ ମାଡ଼ାଟ୍; ଅଣ୍ଡ୍‌ ୱାଦାନ୍ ସେଙ୍ଗେ ତିନାଙ୍କ୍ ଆର୍ ତିଆର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଯୋହନ୍‌‌ତାଦ୍ ଚକା ଉଟ୍ କେଲ୍‍କିନ୍ ତିଆର୍ ଆସ୍‍ମାତ୍‍ତେ । ଅଣ୍ଡ୍‌ ତାନ୍ ଟିକିଡ଼୍‍ତାଗ୍ ଅଣ୍ଡୟ୍‌ ତଲ୍‌କେତଡ଼୍ ଗାଟ୍ ୱାଟ ମାତ୍‍ତଣ୍ଡ୍ । କାରାପ୍ ମାଡ଼େତ୍ କାୟା ନୁ ଗୁପ୍‍ତାଦ୍ ତେନେ ଅନାଦ୍‌ କାଦି ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ଯିରୁଶାଲେମ୍‌ ସହର୍‍କନ୍‍ସ୍, ଯିହୁଦା ପ୍ରଦେଶ୍ ନୁ ଯର୍ଦ୍ଦନ୍ ବେଡ଼େଡ଼୍‍ତେ ଗାର୍‍ରେ ସାରେ ପଡ଼ିୟେତାଗାଙ୍କ୍ ନାରୁଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ଅଡ଼୍‌ ତାମାଦ୍ ପାପ୍‌ ସୀକାର ମାଡ଼ି ଯୋହନ୍‌ ତଡ଼୍ ଯର୍ଦ୍ଦନ୍ ବେଡ଼େମ୍‍ତାଗ୍ ବାପ୍ତିସ୍ମ ଅସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ବେସୁଟ୍‌ ଯୋହନ୍‌ ଉଡ଼୍‍ତଣ୍ଡ୍ ନାର୍‍ଗେ ପାରୂଶୀଡ଼୍ ନୁ ସାଦୁକିଡ଼୍ ବାପ୍ତିସ୍ମ ଅଦାନ୍ ମାଇଦିଙ୍କ୍ ୱାଦୁତଡ଼୍; ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ରେ ୱିସାମ୍ ମାନ୍ଦାନ୍ ତାଡ଼ାମ୍‍ ବଂଶତଡ଼୍, ୱାଦାନ୍ ଦଣ୍ଡତେ ୱେଲେ ମିରାନଙ୍କ୍ ସେଙ୍ଗେ ବେନ ମିକିଂଙ୍କ୍ ଚେତନା ହିତ୍‍ତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ଯଦି ନିଜାମ୍ ପାପ୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତିଡ଼୍, ଇଦ୍ ମିଡ଼୍ ସାୟେତ୍ ପାଡ଼ିୟିଦାଗ୍ ତଅମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ଆଲ୍‍ସ୍‍ମାଟ୍ ଯେ ଅବ୍ରାହାମ୍‌ ମିଇ ମୁନେତ୍ ନାରୁଡ଼୍ ଇଞ୍ଜ କେତ୍‍ତାନ୍ ତଡ଼୍ ମିଡ଼୍ ଦଣ୍ଡତାଗାଙ୍କ୍ ରକ୍ଷା ଦର୍‍କିତ୍ । ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍ ଯେ ଇଶ୍ୱର୍ ଇୱୁ କାଲ୍‍କିଙ୍କ୍ ଅସ୍ ଅବ୍ରାହାମ୍‌ତେ ବଂଶତେ ତିଆର୍ ମାଡ଼େ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ମେଣ୍ଡେ, ଇଞ୍ଜେ ମିକା ମାଡ଼ାକିନ୍ ମଦଲ୍ ଗଡେଲ୍‍ ମିନ୍ଦେ । ବେନ୍ ମାଡ଼ାକିନାଗ୍ କାୟା ସାୟେ ଆଦକ୍, ଆୱିଙ୍କ୍ ନାଡ଼୍‍କି କିସ୍‍ତାଗ୍ ୱାଟିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ମିଡ଼୍ ପାପ୍‍ତାଗାଙ୍କ୍ ମାନ୍‍ତିଙ୍କ୍ ମାଲ୍‍ପାଟ୍‍, ଇଦ୍ କେଞ୍ଜ୍‍ପାନଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ଏର୍‍ଦାଗ୍ ବାପ୍ତିସ୍ମ ହିଦୁତାନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ଅଦିକ୍‍ ବେନ ୱାଦୁତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ନୁ କିସ୍‍ତାଗ୍ ବାପ୍ତିସ୍ମ ହିଦ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ନାୟାଗାଙ୍କ୍ ମହାନ୍ ଅନାୱୁ ହେର୍‍ପୁକ୍ କାଞ୍ଜାଙ୍କ୍ ମିକା ନାନ୍ ଯୋଗ୍ୟ ଆୟନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ଶସ୍ୟତାଗାଙ୍କ୍ ପଲେତିଙ୍କ୍ ତୁଉତାନ୍ ମାଇଦିଙ୍କ୍ ଅନ୍‌ କାଇଦେ ଏତ୍ ମିନ୍ଦେ । ଅଣ୍ଡ୍‌ ଶସ୍ୟକିଙ୍କ୍ ତାନ୍ କୁସ୍‍ତାଗ୍ ନେହେତିତଣ୍ଡ୍ ନୁ ପଲେତିଙ୍କ୍ ନିଡ଼୍‍ତାନାଦ୍ କିସ୍‍ତାଗ୍ ୱାଟି ପଡ଼୍‍ସ୍ପିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ଆସୁଟେ ଜିସୁ ଗାଲିଲୀ ପ୍ରଦେଶ୍‍ତେ ନାଜରିତିୟ ତାଗାଙ୍କ୍ ୱାସ୍ ବାପ୍ତିସ୍ମ ଗ୍ରହନ୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଯର୍ଦ୍ଦନ୍ ବେଡ଼େମ୍‍ତାଗ୍ ଆଞ୍ଚିନାଗ୍ ଯୋହନ୍‌‌ତେ ଗାର୍‍ରେ ୱାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ଯୋହନ୍‌ ଜିସୁଙ୍କ୍ ମନାମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ସିନା ନିୟାଗାଙ୍କ୍ ବାପ୍ତିସ୍ମ ଅଦାନ୍ ମାତ୍‍ତେ ମିକା ନିମ୍‍ ନା ଗାର୍‍ରେ ୱାତ୍‍ତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାୱାଦ୍ ଗଟ୍‍ତେ ରାଜି ଆୟିମ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଦିନ୍ ତଡ଼୍ ମାନାଡ଼୍ ଇଶ୍ୱର୍‌ତେ ଇଚ୍ଛା ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ପାର୍‍ଦ୍‍ତାଡ଼୍ ।” ଆଦିଙ୍କ୍ ଯୋହନ୍‌ ଅଂକିଙ୍କ୍‌ ବାପ୍ତିସ୍ମ ହିଦାଙ୍କ୍ ରାଜି ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜିସୁ ବାପ୍ତିସ୍ମ ହସ୍ ଏର୍‍ତାଗାଙ୍କ୍ ତେଦି ୱାତ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଣ୍ଡ୍‌ ଉଡ଼୍‍ତଣ୍ଡ୍ ସ୍ୱର୍ଗ କୁଲେମ୍ ଆତ୍‍ତେ ନୁ ପବିତ୍ର ଆତ୍ମା ପାର୍ୱା ରକମ୍ ହାସ୍ ଅନ୍‌ ପର୍‍ର ଡିଗ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ତାନ୍ ପେର୍କେ ସ୍ୱର୍ଗକନ୍‍ସ ଇଦ୍ ବାଣି ଆତ୍‍ତେ, “ନିମେ ମା ପ୍ରିୟ ମାର୍‍, ନିୟାଗେ ନାନେ ଗାଟି ସନ୍ତୁଷ୍ଟ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ଆସୁଟେ ପବିତ୍ର ଆତ୍ମା ଜିସୁଙ୍କ୍ ଉଚ୍‍କନେଲ୍‍ତାଗ୍ ଅଂକିଙ୍କ୍‌ ସିମ୍‍ସାମ୍ ପଡ଼ିୟେତାଗ୍ ଅତ୍‍ତେ । ଆଗେ ଅଣ୍ଡ୍‌ ଶୟ୍‍ତାନ୍‍ ତଡ଼୍ ପରିକ୍ଷିତ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ଚାଲିଶି ଦିନ୍ ନୁ ଚାଲିଶି ନାର୍‍କେତ୍ କାଦି ତିନକଟ୍ ମାତ୍‍ତାଙ୍କ୍ ପେର୍କେ ଜିସୁଙ୍କ୍ କାର୍‍ପୟିତେ । ");
INSERT INTO kff_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ଆସୁଟେ ଶୟ୍‍ତାନ୍‍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, “ନିମେ ଯଦି ଇଶ୍ୱର୍‌ ତେ ମାର୍‍, ଆଲାତ୍କେ ଇଦ୍ କାଲ୍‍ଦିଙ୍କ୍ ରୋଟି ଆଦାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ଇତ୍‍କେ ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ନାରୁଡ଼୍ ବେସୁଣ୍ଟ୍ ରୋଟି ତିଞ୍ଜ୍‌ ବାଦ୍‍କଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ ପାୟୁର୍‍ତାଗାଙ୍କ୍ ପେୟ୍‍ତେ ସାରେ ବାକ୍ୟ ତଡ଼୍ ବାଦ୍‍କିତଣ୍ଡ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ଇଦିନ୍ ପେର୍କେ ଶୟ୍‍ତାନ୍‍ ଜିସୁଙ୍କ୍ ପବିତ୍ର ନାର୍ ଜିରୁଶାଲମ୍‍ତାଗ୍ ଅତ୍‍ତେ । ଆଗେ ଅଂକିଙ୍କ୍‌ ମନ୍ଦିର୍‍ତେ ପର୍‍ର ଜୁଟିନାଗ୍ ଅସ୍‍ କେତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ନିମେ ଯଦି ଇଶ୍ୱରତେ ମାର୍‍, ଆଲାତ୍କେ ଇଗାଙ୍କ୍ ମଦଲ୍ ତୁଲ୍‍ଲେ । ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, “ନିକିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ ତାନ୍ ଦୂତକିଂଙ୍କ୍ ନି ବିଷୟ ତେ ଆଦେଶ୍‍ ହିଦ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ନିକିଂଙ୍କ୍ କାଇଦେ ପୟିଦ୍‍ତଡ଼୍ । ଆଦିଙ୍କ୍ ନିୟାୱୁ ଡେକାନାଗ୍ କାଲ୍‍କିନ୍ ଦେବ୍‍ ତାଲ୍‍ଗ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ମେଣ୍ଡେ, ଜିସୁ ଶୟ୍‍ତାନ୍‍ ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍‍, “ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ନିମେ ପ୍ରବୁ ନିଜର୍ ଇଶ୍ୱର୍‌ ତିଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼ାନାଦ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ତାନ୍ ପେର୍କେ ଶୟ୍‍ତାନ୍‍ ଅଣ୍ଡୟ୍‌‍ ବେଡ଼୍‍ୟାଦ୍‍ ମେଟେତ୍ ଜୁଟିନାଗ୍ ଅତ୍‍ତେ ନୁ ଅଂକିଙ୍କ୍‌ ଜଗତ୍‍ତାଦ୍ ସାରେ ରାଜ୍ୟତାଦ୍ ସମ୍ପତି ତଅସ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ଶୟ୍‍ତାନ୍‍ ଜିସୁଙ୍କ୍ କେତ୍‍ତେ, “ଯଦି ନିମ୍‍ ନାକିଂଙ୍କ୍ ମର୍‍ମିଣ୍ଡା ଇସ୍‌ ପୁଜା ମାଡ଼ିତିନ୍, ନାନ୍ ନିକିଂଙ୍କ୍ ଇଦ୍ ସାରେ ଅଦିକାର ନୁ ଇଦ୍ ସାରେ ସମ୍ପତ୍ତି ହିଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଜେକେ ଆନ୍‌ ଶୟ୍‍ତାନ୍‍ ! ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ମାତର୍ ନି ପ୍ରବୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଉପବାସ୍ ମାଡ଼େ ନୁ ଅନାଦ୍‌ ସେବା ମାଡ଼େ ।’” ");
INSERT INTO kff_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ତାନ୍‍ପେର୍କେ ଶୟ୍‍ତାନ୍‍ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ଆତ୍‍ତେ ନୁ ଦୂତ ୱାସ୍ ଜିସୁନାଦ୍ ଯତ୍ନ ଅତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ଯୋହନ୍‌‌ତିଙ୍କ୍ ବନ୍ଦି ମାଡ଼୍‍ତଡ଼୍ ଇଞ୍ଜ କେଞ୍ଜି ଜିସୁ ଗାଲିଲୀତାଗ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାଜରିତିୟ ତାଗ୍ ମାନକନ୍‍ସ୍ ସବୁଲୁନ୍‍ ନୁ ନପ୍‍ତାଲି ପଡ଼ିୟେତାଗ୍ ମାନ୍ଦାନ୍ ଗାଲିଲୀ ସାୱ୍‍ଡ଼େତ୍ ଆଞ୍ଚିନାଗ୍ ମାନ୍ଦାନ୍ କପର୍ନାହୁମ୍‍‍ତାଗ୍ ଅଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ଇଦିନ୍ ତଡ଼୍ ବାବବାଦୀ ଜିଶାଇୟତାଦ୍ ବାକ୍ୟ ସାରେ ଆତ୍‍ତେ । ଅଣ୍ଡ୍‌ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ଜର୍ଦନ୍ ବେଡ଼େତ୍ ମେଣ୍ଡେଅନ୍‌‍ପାକ୍ ସମୁଦ୍ରତା ଆଦାନ୍ ହାର୍‍ଦାଗ୍, ଜବୁଲନ୍ ନୁ ନପ୍‍ତାଲି ରେଣ୍ଡ୍ ଦେଶ୍‍କ୍ ମିନ୍ଦେ ମେଣ୍ଡେ ବିଜାତି ନାରୁଡ଼ାଦ୍ ଗାଲିଲୀ ! ");
INSERT INTO kff_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ଇକାଡ଼୍‌ତାଗ୍ ମାଞ୍ଜ୍ ମାଡ଼ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଅଣ୍ଡୟ୍‌‍ ସାଏତ୍ ୱେସ୍ ଉଡ଼ିତଡ଼୍, ଡଲ୍‍ନାଦ୍ ନିଡ଼୍‍କେତ୍ ସହର୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍ତେ ପର୍‍ର ଆଦ୍ ୱେସ୍ ସାର୍‍ରେ ପାକେ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ଆଦ୍ ସମୟ୍‍ତେ କନ୍‍ସ୍ ଜିସୁ ପ୍ରଚାର୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ପାପ୍ ହାର୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ମୁଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‍ ରାଜ୍ୟ ମି ଗାର୍‍ରେ ୱାସ୍ ହେୱ୍‍ସ୍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜିସୁ ଗାଲିଲୀ ସାୱ୍‍ଡ଼େତ୍ ଆଞ୍ଚ୍ଇସ୍‌ ଆଦାନ୍ ୱେଲେ ଶିମୋନ୍ ପିତର୍ ନୁ ଆନ୍ଦ୍ରିୟ ପେଦେର୍‍ତେ ଇର୍‍ୱୁଡ଼୍ କିକେ ପୟ୍‍ତାନଡ଼୍‍କ୍ କାଇଲ୍‍ତଣ୍ଡ୍ । ଇଡ଼୍ ତାମୁଣ୍ଡ୍‌ ଇର୍‍ୱୁଡ଼୍ ୱାଲେ ୱାଟି ସାୱ୍‍ଡ଼େତାଗ୍ କିକେ ପୟ୍‍ସମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, “ନା ତଡ଼୍ ୱାଡ଼ାଟ୍ । ନାନ୍ ମିକିଂଙ୍କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପଇତାନାଦ୍ ନାଡ଼୍‍ସ୍ପିତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ଅଡ଼୍‌ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଡ଼ାୱୁ ୱାଲା ୱିଡ଼୍‍ସି ଅନ୍‌ ତଡ଼୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଜିସୁ ସୁଦୁଟ୍ ମୁନେ ଆଞ୍ଜ୍ ଯାକୁବ୍ ନୁ ଯୋହନ୍‌ ପେଦେର୍‍ତେ ଜେବଦିତେ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କିଙ୍କ୍ କାଇଲ୍‍ତଣ୍ଡ୍ । ଇଡ଼୍ ତାମୁଣ୍ଡ୍‌ଇର୍‍ୱୁଡ଼୍ ନୁ ତାମ୍ ବାବାଲ୍ ଓଡ଼େତାଗ୍ କୁଦି ତାମାଦ୍ ୱାଲା ମଦ୍‍ଦା ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିକା କାର୍‍ଙ୍ଗ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ଅଡ଼୍‌ ସାଙ୍ଗେ ସାଙ୍ଗେ ଓଡେ ନୁ ତାମ୍‌ ବାବାଙ୍କ୍ ୱିଡ଼୍‍ସି ଜିସୁନ୍ ତଡ଼୍‍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ଜିସୁ ଗାଲିଲୀତେ ସାରେତାଗ୍ ଉଡିଉଡି ପ୍ରାର୍ତନା ଲୋକିନାଗ୍ ଶିକ୍ଷା ଇତ୍‌ତଣ୍ଡ୍‌ । ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଦ୍ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ନାର୍‍ଗେ ଲେକାମ୍ ରଗି ନୁ ରଗ୍‍ତେ ନାରୁଡ଼୍‍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ସିରିଆତେ ସାରେତାଗ୍ ଅନ୍‌‍ୱାଦ୍ କ୍ୟାତି ସାରେପାକ୍ ଆତ୍‍ତେ ମେଣ୍ଡେ ନାରୁଡ଼୍ ବୁତ୍ ପୟ୍‍ତେନଡ଼୍‍କ୍, ମୁର୍ଚ୍ଛା ରଗିଡ଼୍‍କ୍, ପକ୍ଷାଗାତ୍ ରଗିଡ଼୍‍କ୍ ସାରେ ଲେକାତ୍ ଦୁଃକି ନାରୁଡ଼୍‍କ୍ ଅନ୍‌ ଗାର୍‍ରେ ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଜିସୁ ଅଡ଼୍‌ ସାରେ ତଡ଼୍‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଗାଲିଲୀ, ଦେକାପଲୀ, ଯିରୁଶାଲେମ୍‌, ଯିହୂଦା ପ୍ରଦେଶ୍ ନୁ ଜର୍ଦନ୍ ବେଡ଼େତ୍ ଆପାକେ ମାନ୍ଦାନ୍ ପଡ଼ିୟେତାଗାଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଜିସୁନ୍‌ ପେର୍କେ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜିସୁ ନାର୍‍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଉଡ଼ି ଅଣ୍ଡୟ୍‌ ମେଟେତାଗ୍ ଆଞ୍ଜ୍ କୁଦ୍‍ତଣ୍ଡ୍ । ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ ଗେରାମାଡ଼ି ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶିକ୍ଷାଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ଆଦ୍ୟାତ୍ମିକ୍ ଜିୱୁନ୍‍ତାଗ୍ ଦୁର୍ବଲ୍ ଇଞ୍ଜ ଏର୍କା ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ଦନ୍ୟ,” ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ସ୍ୱର୍ଗରାଜ୍ୟତେ ଅଦିକାର ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଦୁଃକାମ୍ ନାରୁଡ଼୍ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାନ୍ତନା ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ନମ୍ର ନାରୁଡ଼୍ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ପୃତିବିତେ ଅଦିକାରି ଆଦେପାର୍‍ଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଇଶ୍ୱର୍‌ତେ ଇଚ୍ଛା ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାନଙ୍କ୍ ବେନଡ଼ାଦ୍ ଇଚ୍ଛା, ଅଡ଼୍‌ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶାନ୍ତି ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ବେନଡ଼୍ ବାଗାତ୍ ନାରୁଡ଼୍ ସେଙ୍ଗେ ଦୟାବାନ୍ ଆଦ୍‍ତଡ଼୍ ଅଡ଼୍‌ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦୟାମାଡ଼ିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ବେନଡ଼ାଦ୍ ହୃଦୟ୍ ନିର୍ମଲ୍ ଅଡ଼୍‌ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଇଶ୍ୱର୍‌ତେ ଦର୍ଶନ୍ ଉଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ବେନଡ଼୍ ଶାନ୍ତି ମାଡ଼ାନଙ୍କ୍ ଆଲ୍‍ସି ତଡ଼୍ ଅଡ଼୍‌ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ରକମ୍ ପୁନ୍ଦାଙ୍କ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ବେନଡ଼୍ ଇଶ୍ୱର୍‌ତେ ଇଚ୍ଛା ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ି ତାଡ଼ନା ପାହେମ୍‍ ଆଦ୍‍ତଡ଼୍‍, ଅଡ଼୍‌ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ସ୍ୱର୍ଗରାଜ୍ୟତେ ଅଦିକାରିଡ଼୍‍ ଆଦ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ନାରୁଡ଼୍ ବେସୁଣ୍ଟ୍ ନାକିଂଙ୍କ୍ ପେର୍କେ ମାଡ଼ି ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ନାରୁଡ଼୍ ଯଦି ମିକିଂଙ୍କ୍ ଅପ୍‍ମାନ୍ ମାଡ଼ିତଡ଼୍, ଗାଟିତିପାଲ୍ ହିଦ୍‍ତଡ଼୍ ନୁ ମିଇ ବିରୁଦ୍ଦ୍‌ତେ ବୁସା କେତିତଡ଼୍‍, ");
INSERT INTO kff_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ମିଡ଼୍ ୱେଡ଼୍‌କେ ମାଡ଼ି ହେନ୍ଦାଟ୍‌ ।” ବାତେଙ୍କ୍ ଇତ୍‍କେ ସ୍ୱର୍ଗତାଗ୍ ମିଇ ସେଙ୍ଗେ ବେଡ଼୍‍ୟାଦ୍‍ ପୁରସ୍କାର୍ ମିନ୍ଦେ । ହେର୍କା ମାଡ଼ାଟ୍ ମିଇ ମୁନେତ୍ ବାବବାଦୀଡ଼୍‍, ମିକା ଇଦ୍ ରକମ୍ ଗାଟିତିପାଲ୍ ହାସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ମିଡ଼୍ ସାରେତଡ଼ି ମାନେୟ୍‍ତେ ଜାତିଡ଼୍ ପୃତିବିତେ ଅୱଡ଼୍‌ ଲେକାମ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅୱଡ଼୍‌ ଯଦି ତାନାଦ୍ ମିଙ୍ଗାନାଦ୍ ଗୁଣ୍ ଆରାମାଡ଼ିତ୍, ଆସୁଙ୍କ୍ ମେଣ୍ଡେ ଅୱଡ଼୍‌ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱାଦ୍ । ତାନ୍ ପେର୍କେ ଆଦ୍ ପୁରାପୁରି ଦର୍‍କାର୍ ଆୟ୍‍ୟ ତାଙ୍କ୍ ବାଇଦେ ହେସ୍‍ସିଦ୍‍ତଡ଼୍ । ନାରୁଡ଼୍ ତାଙ୍କ୍ ୱିକି ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“ମିଡ଼୍ ସାରେ ଜଗତ୍‍ତେ ୱେସ୍ ଲେକାମ୍ ।” ବେନ୍ ନାର୍ ମେଟେତ୍ ପର୍‍ର ତିଆର୍ ଆତ୍‍ତେ, ଆଦ୍ ବେସୁଙ୍କ୍‍ ବା ମିଞ୍ଜିମେଣ୍ଡେ ମାନ୍ଦାଙ୍କ୍ ପାର୍‍ୱ । ");
INSERT INTO kff_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","କୁପିତିଙ୍କ୍ ନିଡ଼୍‍ସ୍‍ପି ବେନ ବଡ୍ ତଡ଼୍ ମୁସି ୱାଟଣ୍ଡ୍ । ଆଦିଙ୍କ୍ କୂପିୱାଟାନାଗ୍ ୱାଟିତଣ୍ଡ୍ ମେଣ୍ଡେ ଆଦ୍ ଲୋନ୍‌ ମାନ୍ଦାନ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ୱେସ୍ ହିଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ଆଦେପୁଟୁଙ୍କ୍ ମିୱାଦ୍ ୱେସ୍ ସାରେତଡ଼୍ ଗାର୍‍ରେ କେଲିନ୍ । ଆଲେକେ ମିୱାଦ୍ ସତ୍‍କାମ୍ ସାରେ ଉଡ଼ି ଅଡ଼୍‌ ମିଇ ସ୍ୱର୍ଗତଣ୍ଡ୍ ବାବାଲ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ହାଲ୍‍ସ୍‍ମାଟ୍ ଯେ ନାନ୍ ମଶାଲ୍‌ ହିତ୍‍ତାଦ୍ ନିୟମ୍ ନୁ ବାବବାଦୀଡ଼ାଦ୍ ଶିକ୍ଷା ସାରେ ଲପ୍ ମାଡ଼ାନଙ୍କ୍ ଆୟ୍‍ୟ ବେଲାନ୍ ସାରେ ମାଡ଼ାଙ୍କ୍ ନାନ୍ ୱାତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ନାନ୍‍ ନିଜାମ୍‍ କେତୁତାନ୍‍ ହେର୍କେମାଡ଼ାଟ୍, ସ୍ୱର୍ଗ ନୁ ପୃତିବି ତିଷ୍ଟି ମାନ୍ଦାନ୍ ଯାକ ଦର୍ମଶାସ୍ତ୍ର ନିୟମ୍‍ତାଦ୍ ଅଣ୍ଡୟ୍‌ ଚିହ୍ନେ ବା ବିସର୍ଗ ଲପ୍‍ପାଏମ୍ ଆୟ୍‍ୟ । ସାରେ ବିଷୟ୍ ଶେଷ୍ ଆଦାନ୍ ଯାକ ଇଦ୍ ଗଟେମ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ଆଦିଙ୍କ୍ ବେନ ଆୟି ନିୟମ୍‍ତାଦ୍ ସାରେତିଙ୍କ୍ ସୁଦୁରାଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ପାଲନ୍ ମାଡ଼ନ୍ ମେଣ୍ଡେ ଆଦେପୁଟୁଙ୍କ୍ ମାଡ଼ାନଙ୍କ୍ ବାଗାତଡ଼୍‍କ୍ ଶିକ୍ଷା ହିଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ସ୍ୱର୍ଗରାଜ୍ୟତାଗ୍ ସାରେତିଙ୍କ୍ ସୁଦୁନଣ୍ଡ୍ ଇଞ୍ଜ କ୍ୟାତି ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ଆଦିଙ୍କ୍ ନାନ୍ କେତୁତାନ୍, ଦର୍ମଗୁରୁ ନୁ ପାରୂଶୀ ଡ଼ାଗାଙ୍କ୍ ଗାଟି ବିଶ୍ୱାସ୍ ମାଡ଼ି ଇଶ୍ୱର୍‌ତେ ପାଡ଼୍‍ୟି ମାଡ଼୍‍କେ ଆଞ୍ଜ୍ ମିଡ଼୍ ସ୍ୱର୍ଗରାଜ୍ୟତାଗ୍ ହସାଙ୍କ୍ ପାର୍‍ଦ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ବେବିଚାର୍ ମାଡ଼୍‍ମାଟ୍, ହିଦ୍ ଗଟ୍ ମିଡ଼୍ ମୁନେତ୍ କନ୍‍ସ୍ କେଞ୍ଜି ୱାଦୁତିଡ଼୍ । ବେନ ଆଦ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବିଚାରିତ ଆସ୍ ଦଣ୍ଡ୍ ଜିୱେଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ କେତୁତାନ୍, ବେନ ବେନ୍‌ଆଇ ତାମୁଣ୍ଡ୍‌ତେ ପର୍‍ର କପାମ୍ ଆଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ମିକା ବିଚାରିତ ଆସ୍ ଦଣ୍ଡ୍ ଜିୱେଦର୍‍କିତ୍ । ବେନ ତାମୁଙ୍କ୍ ବାକ୍‍ୱା ଇଞ୍ଜ କେସ୍ ପରିହାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବେଡ଼୍‍ୟାଦ୍‍ ବିଚାରାଲୟତାଗ୍ ଦଣ୍ଡ୍ ଜିୱେଦର୍‍କିତ୍ । ମେଣ୍ଡେ ବେନ ତାମୁଙ୍କ୍ ମୁର୍କ ଇଞ୍ଜ କେତିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନର୍‍କତେ କିସ୍‍ତାଗ୍ ହେସାନାଦ୍ ଦଣ୍ଡ୍ ଜିୱେଦର୍‍କିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଆଦିଙ୍କ୍ ଇଶ୍ୱର୍ ଗଟ୍‍ତେ ବଲି ହିଦାଙ୍କ୍ ଆଦାନ୍ ୱେଲେ ଯଦି ନିକିଂଙ୍କ୍ ହେର୍କା ୱାଦ୍‍ତେ ଯେ ନି ସେଙ୍ଗେ ବେନ୍‌ଆଇ ତାମୁଣ୍ଡ୍‌ତେ ମନ୍‍ତାଗ୍ ବାତ୍‍ଆଇ ଲେକେତ୍‍ ଆୟ୍‍ୱେ ମିନ୍ଦେ, ");
INSERT INTO kff_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ବେଦିତ୍ ମୁନ୍‍ନେ ଆଦ୍ ବଲିତିଙ୍କ୍ ୱିଡ଼୍‍ସିମିକା ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଞ୍ଜ୍, ତାମୁଣ୍ଡ୍‌ତଡ଼୍ ମେଣ୍ଡେନ୍‍ଦାମ୍ କାଇଲେ, ମେଣ୍ଡେ ମାଲ୍‍ସ୍ ୱାସ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଆଦ୍ ବଲି ଉତ୍ସର୍ଗ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ଯଦି ବେନ ନି ବିରୁଦ୍ଦ୍‌ତେ ମକଦମା ମାଡ଼ି କୋଟ୍‍ତାଗ୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ଦିନାମ୍ ମାନ୍‍ନା ଅନ୍‌‍ତଡ଼୍ ନିଜେ ଆଞ୍ଜ୍ କାଇଲାଟ୍ । ଇଲୁକ୍ କୋଟ୍‍ତାଗ୍ ହେୱୁକ୍‍କେ, ଅଣ୍ଡ୍‌ ନିକିଂଙ୍କ୍ ବିଚାର୍‍ପତିନ୍‍ କାଇଦେ ହିଦ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ବିଚାର୍‍ପତି ନିକିଂଙ୍କ୍ ଟାଣ୍ଡେତାଗ୍ ଅଦାନ୍ ମାଇଦିଙ୍କ୍ ପୁଲିସିଡ଼୍ କାଇଦେ ପସ୍ପିଦ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ନାନ୍‍ ମିକିଂଙ୍କ୍‍ ନିଜାମ୍‍ କେତୁତାନ୍‍, “ନି ପର୍‍ର ୱାଟ୍‍ତେ ସାରେ କାମ୍‍ଦେନନ୍‍ ୱେରନ୍ ପାଇସା ମିକା ଇୱେଯାକ ନିମ୍‍ ଆଗାଙ୍କ୍ କଲାସ୍ ଆତ୍‍ତାଙ୍କ୍ ପାର୍‍ୱିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“‘ବେବିଚାର୍ ମାଡ଼୍‍ମାଟ୍,’ ହିଦ୍ ଗଟ୍ ମିଡ଼୍ ମୁନେତ୍ କନ୍‍ସ୍ କେଞ୍ଜି ୱାଦୁତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ କେତୁତାନ୍ ଯଦି ବେନ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମୁତେନ୍ ପର୍‍ର ନଜର୍ ୱାଟିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆଦିନ୍ ତଡ଼୍ ହେର୍କା ମାଡ଼ି ବେବିଚାର୍ ବା ଅପରାଦି ମାଡ଼ିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଯଦି ନିୱାଦ୍ ତିନ୍‍ନ୍ଦେ କଣ୍ଡେତ୍ ବେସୁଙ୍କୁ ବାଲାହାଇ ଆଦ୍‌ତେ, ଆଲେକ୍‌ ଆଦିଙ୍କ୍‌ ଟେଣ୍ଡି ହେସ୍‌ସିମୁଟ୍‌, ମିୱାଦ୍ ସାରେ ମେନ୍ଦୁଲ୍ ନର୍‍କତାଗ୍‍ ହେସାନାଗାଙ୍କ୍, ମେନ୍ଦୁଲ୍‍ତେ ଅଣ୍ଡୟ୍‌ ଦୁଡ଼େ ଆରା ମାଡ଼ାନାଗାଙ୍କ୍ ବେଲାନ୍ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଯଦି ନିୱାଦ୍ ତିନ୍ଦେକାୟି ପାପ୍ ମାଡ଼ାଙ୍କ୍ କେତୁତ୍, ଆଦିଙ୍କ୍ ମିକା ନାଡ଼୍‍କି ହେସିମୁଟ୍ । ନିୱାଦ୍ ସାରେ ମେନ୍ଦୁଲ୍ ନର୍‍କତାଗ୍‍ ହେସାନାଗାଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ଅଂକିଙ୍କ୍‌ ଆରା ମାଡ଼ାନାଦ୍ ବେଲାନ୍ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“‘ଯଦି ବେନ ନିଜେତ୍ ମୁତେଙ୍କ୍ ୱିଡ଼ସାନ୍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ଆଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ଲିକିତ୍‍ ଲେକାମ୍ ୱେରଡ଼୍ କାଇଦେ ଏର୍‍ ହିୱୀଣ୍ଡ୍’ ଇଦ୍ ଶିକ୍ଷା ମିଡ଼୍ ମୁନେତ୍ କନ୍‍ସ୍ ପାଏମ୍ଆତ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ କେତୁତାନ୍, ବେବିଚାର୍ ଅପରାଦି ବ୍ୟତିତ୍ ବାଗାତ୍ ବାତ୍‍ଆଇ ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାଇଦିଙ୍କ୍ ତାନ୍ ମୁତେଙ୍କ୍ ଚାଡ଼ପତ୍ର ହିତ୍‍କେ, ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ବେବିଚାର୍ ମାଡ଼ତଣ୍ଡ୍ ଇଞ୍ଜ କାରାପ୍‍ତେ ଦଷି ଆଦ୍‍ତନ୍ ମେଣ୍ଡେ ବେନ୍ ନାରୁଡ଼୍ ଆଦ୍ ନାଟାଡ଼୍‍ତିଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ମିକା ବ୍ୟବିଚାର୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ମୁନେତ୍ କନ୍‍ସ୍ ଇଦ୍ ଶିକ୍ଷା କେଞ୍ଜି ୱାଦୁତିଡ଼୍, ‘ଶପତ୍‍ ମାଡ଼ି ୱିଡ଼୍‍ସ୍‍ମାଟ୍ । ଇଶ୍ୱର୍‌ତେ ମୁନ୍‍ନେ ବେନ୍ ଶପତ୍ ମାଡ଼ିତିଡ଼୍, ଆଦିଙ୍କ୍ ସାରେ ମାଡ଼ାଟ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଶପତ୍‍ ମାଡ଼ାନ୍ ୱେଲେ ରାଣ ନିୟମ୍ ୱାଟ୍‍ମାଟ୍ । ସ୍ୱର୍ଗ ପେଦେର୍‍ତେ ରାଣ ୱାଟ୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଇଶ୍ୱର୍‌ତେ ସିଂହାସନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ପୃତିବି ପେଦେର୍‍ତେ ରାଣ ୱାଟ୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଇଶ୍ୱର୍‌ତେ ଡେକେତ୍‍ କୁତୁଲ୍ । ଯିରୁଶାଲେମ୍ ନାର୍ ପେଦେର୍‍ତେ ମିକା ରାଣ ୱାଟାନାଦ୍ ଆୟ୍‍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଆଦୁତ୍‍ତେ ମହାରାଜାନ୍ ନାର୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ମିଇ ତାଲେତ୍ ରାଣ ୱାଟ୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡୟ୍‌ କେଲ୍‍ଦିଙ୍କ୍ କାର୍‍ରି ବା ପାଣ୍ଡେ ମାଡ଼ାଙ୍କ୍ ଶକ୍ତି ମିୟାଦ୍ ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“ମିଡ଼୍ ରାଣ ନିୟମ୍ ୱାଟକଟ ମାତର୍ ‘ହଁ’ କି ‘ଇଲେ’ କେଲାଟ୍ । ଇଦିନାଗାଙ୍କ୍ ଗଟ୍ କେସ୍ ଶପତ୍‍ ମାଡ଼ାନାଦ୍ ଶୟ୍‍ତାନ୍‍ତାଗ୍ ପେୟିତାନ୍ ଗଟ୍ ରକମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“‘କଣ୍ଡା ବାଦୁଲ୍‍ତେ କଣ୍ଡା, ପାଲ୍‍କ୍ ବାଦୁଲ୍‍ତେ ପାଲ୍‍କ୍ ।’ ଇଦ୍ ଇଂସା ନିସ୍ ମିଡ଼୍ କେଞ୍ଜ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ କେତୁତାନ୍, ବେନ ମିୟାଦ୍ ଅନିଷ୍ଟ ମାଡ଼ିତନ୍ ଅନାଦ୍‌ ପ୍ରତିଶଦ ଅୟିମାଟ୍ । ଯଦି ମିୟାଦ୍ ତିନ୍‍ନ୍ଦେ ବୁକେତାଗ୍ ଚାପୁଡ଼ା ରେହେତିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡ ଅଙ୍କ୍‌ ବୁକା ତହସିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଯଦି ବେନ ମିୟାଦ୍ ଚକା ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ମିଇ ବିରୁଦ୍ଦ୍‌ତେ ବୁସାମାଡ଼ି ମିକିଂଙ୍କ୍ ବିଚାର୍ ଲତ୍‍ତାଗ୍ ଆଦ୍‍ତନ୍, ଅଂକିଙ୍କ୍‌ ମିୟାଦ୍ କୋଟ୍ ମିକା ଦାନ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଯଦି ଦେଶ୍ ଅଦିକାର୍‌ ମାଡ଼ିମାନ୍ଦାନ୍ ସୈନିକିଡ଼୍ ଲୋପେକ୍ ବେନ ମିକିଂଙ୍କ୍ ବଜ୍ କାଞ୍ଜି ଅନ୍‌‍ତଡ଼୍ ଅଣ୍ଡ୍‌ କିଲମିଟର୍ ଆଦ୍‍ଦାନଙ୍କ୍ ବାଦ୍ୟ ମାଡ଼ିତନ୍, ମିଡ଼୍ ଚିନ୍ତେ ମାଡ଼୍‍ୱେକଟ ଅନ୍‌‍ତଡ଼୍ ରେଣ୍ଡ୍ କିଲମିଟର୍ ଆନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ବେନ ଯଦି ଜିନିଷ୍ ତାଲ୍‍କିତଣ୍ଡ୍ ଅଂକିଙ୍କ୍‌ ହିମୁଟ୍ । ବେନ ବାତ୍ ତାଲ୍‍କେ ଅଂକିଙ୍କ୍‌ ଆଦ୍ ହିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“‘ସାଙ୍ଗଡ଼୍‍କ୍ ପ୍ରେମ ମାଡ଼ାଟ୍, ଶତ୍ରୁଡ଼୍‍କ୍ ପାସ୍‍କାଟ୍ ।’ ଇଦ୍ ଶିକ୍ଷା ମୁନେନ୍ କେଞ୍ଜ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ ଶତ୍ରୁଡ଼୍‍କ୍ ପ୍ରେମ ମାଡ଼ାଟ୍ । ବେନଡ଼୍ ମିକିଂଙ୍କ୍ ତାଡ଼ନା ମାଡ଼ିତଡ଼୍ ଅଡ଼ାଦ୍‌ ଲେକେତ୍‍ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଇଦ୍ ରକମ୍ ମାଡ଼୍‍କେ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ହିଞ୍ଜ ପୁନ୍‍ତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଲେକେତ୍‍ ନୁ କାରାପ୍ ରେଣ୍ଡ୍ ଲେକାତ୍ ନାରୁଡ଼୍‍କ୍ ପଡ଼୍‍ଦ୍ ୱେସ୍ ହିଦ୍‍ତଣ୍ଡ୍ ନୁ ସାୟେତ୍ ପାଡ଼ିୟିଦେ ନଡ଼୍‍କିଙ୍କ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ୱାର୍‍ସାମ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ମାତର୍ ମିକିଂଙ୍କ୍ ସାୟେ ଇଞ୍ଜ କେତାନଡ଼୍‍କିଙ୍କ୍ ପ୍ରେମ୍ ମାଡ଼ିତଡ଼୍, ଇଶ୍ୱର୍ ବାତେଙ୍କ୍ ମିକିଂଙ୍କ୍ ପୁରସ୍କାର୍ ହିଦ୍‍ତଣ୍ଡ୍ ? କର ଆଦାୟ୍ ମାଡ଼ାନଡ଼ି ମିକା ଆଦ୍‍ଲେକାମ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଯଦି ମିଡ଼୍ ତାମୁଣ୍ଡ୍‌ ତଡ଼୍ ତିର୍‍ୟିତିଡ଼୍‍, ଆଲେକେ ମିଡ଼୍ କି ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମାଡ଼ୁତିଡ଼୍ ? ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱେ ନାରୁଡ଼୍ ମିକା ଆଦ୍ ରକମ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ସ୍ୱର୍ଗତଣ୍ଡ୍ ମି ବାବାଲ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ପବିତ୍ର, ମିଡ଼୍ ଆନ୍‌‍ତେ ଆଦେପୁଟୁଙ୍କ୍ ପବିତ୍ର ଆଦାନ୍ ଦର୍‍କାର୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତଅତାନ୍ ମାଇଦିଙ୍କ୍ ସାରେତଡ଼୍ ମୁନ୍‍ନେ ଦର୍ମକାମ୍ ମାଡ଼୍‍ମାଟ୍ । ଆଲା ମାଡ଼୍‍କେ ବାବାଲ୍ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ମିଡ଼୍ ପୁରସ୍କାର୍ ପାଏମ୍ ଆୟ୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ୱେରଣ୍ଡ୍ ଅବାବ୍‍ତଣ୍ଡ୍ ନାରୁଙ୍କ୍ ବାତ୍‍ଆଇ ଦାନ ହିଦାନ୍ ୱେଲେ ଦୁଷ୍ଟ ନାରୁଡ଼୍ ଲେକାମ୍ ତଅମାଟ୍ । ଅଡ଼୍‌ ଉପାସନା ଲଅକିନାଗ୍ ନୁ ୱିଦିନ୍ ନାଡ଼୍‍ମେ ନିଜେତ୍ ଦାନଦର୍ମ୍ ତଅତିତଡ଼୍ । ନାରୁଡ଼ାଗାଙ୍କ୍ ପ୍ରସଂଶା ପାଏମ୍ଆଦାଙ୍କ୍ ଅଡ଼୍‌ ଇଦ୍ ରକମ୍ ମାଡ଼ିତଡ଼୍ । ନାରୁଡ଼ାଗାଙ୍କ୍ ପ୍ରସଂଶା ପାଏମ୍ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌ ଇଲା ମାଡ଼ିତଡ଼୍ । ନାନ୍ ନିଜାମ୍‍ତେ କେତୁତାନ୍ ଅଡ଼୍‌ ଇଦିନାଗାଙ୍କ୍ ଅଡ଼ାଦ୍‌ ଦର୍‍କାନାଦ୍ ପୁରାପୁରି ପାଏମ୍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ୱେରନ୍ ଅବାବ୍‍ ତଡ଼୍‍କିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାନ୍‍ୱେଲେ, ଇଦ୍ ରକମ୍ ମାଡ଼ାଟ୍, ବେଲାକି ମିୱଣ୍ଡ୍ ସାଏତ୍ ସାଙ୍ଗ ମିକା ଇଦ୍ ଗଟ୍ ପୁନ୍ଦାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ମିୟାଦ୍ ଇଦ୍ ମିଞ୍ଜିମାଞ୍ଜ୍ ଆତ୍‍କେ ମିକା ମିୱଣ୍ଡ୍ ସାରେତିଙ୍କ୍ ଉଡ଼ାନ୍ ବାବାଲ୍ ଇଶ୍ୱର୍ ଆଦ୍ ଉଡ଼ି ପୁରସ୍କାର୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ୱେଲେ ବୁସା ଦାର୍ମିକ୍ ନାରୁଡ଼୍ ଲେକାମ୍ ଆୟ୍‍ମାଟ୍ । ବେଲା ସାରେତଡ଼୍ ଉଡ଼ିତଡ଼୍, ଆଦିନ୍ ସେଙ୍ଗେ ଉପବାସ୍ ଲଅକିନାଗ୍ ନୁ ରଟ୍ ଚକ୍‍ତାଗ୍ ନିଶ୍‍ମିକା ଅଡ଼୍‌ ପ୍ରାର୍ତନା ମାଡ଼ାଙ୍କ୍ ସାୟେ ଇଞ୍ଜ କେତିତଡ଼୍‍ । ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ତେ କେତୁତାନ୍ ଯେ ଅଡ଼୍‌ ନିଜେତ୍ ପୁରସ୍କାର୍ ଦର୍‍କ୍ସି ମିନ୍ଦେଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ନିଜେତ୍ ବାକ୍‍ଡ଼େ ଲୋପେ ଆନୁଟ୍, କାପାଟ୍ କେଏମୁଟ୍ ନୁ ମିଇ ମିଞ୍ଜିମାନ୍ଦାନ୍ ବାବାଲ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ । ମିଡ଼୍ ମିଞ୍ଜିମାଞ୍ଜ୍ ବାତ୍ ମାଡ଼ିତିଡ଼୍, ସାରେତିଙ୍କ୍ ଉଡ଼ାନନ୍ ବାବାଲ୍ ଇଶ୍ୱର୍ ଆଦ୍ ଉଡ଼ି ମିକିଂଙ୍କ୍ ପୁରସ୍କାର୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ମିଡ଼୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍‍ୱେଲେ ବିଶ୍ୱାସ୍ ଇଲ୍‍ୱେ ଲେକାମ୍ ନାର୍‍ଗେ ଇତ୍‍କେ ହିଲ୍‍ୱାଦ୍ ଶଦ୍ଦ ବ୍ୟବହାର୍ ମାଡ଼୍‍ମାଟ୍ । ଅଡ଼୍‌ ହାଲ୍‍ସିତଡ଼୍, ଅଡ଼ାଦ୍‌ ପ୍ରାର୍ତନା ଲାଟି ଆତ୍‍କେ ଇଶ୍ୱର୍ କେଞ୍ଜିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ଅଡ଼୍‌ ଲେକାମ୍ ଆୟ୍‍ମାଟ୍ । ମିଡ଼୍ ତାଲ୍‍କାନ୍ ମୁନେଙ୍କ୍ ମିକିଂଙ୍କ୍ ବାତ୍ ଦର୍‍କାର୍, ମିଇ ବାବାଲ୍ ଇଶ୍ୱର୍ ଆଦ୍‍ ସାରେ ପୁତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ଆଦିଙ୍କ୍ ଇଦ୍ ରକମ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନାଦ୍ ଟିକ୍, “ହଁ ସ୍ୱର୍ଗତନି ବାବା, ନିୟାଦ୍ ପେଦେର୍ ପବିତ୍ର ହିଞ୍ଜ ମାନ୍ୟ ହାୟି । ");
INSERT INTO kff_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ନିୟାଦ୍ ରାଜ୍ୟ ୱାଡ଼ି । ନିୟାଦ୍ ଇଚ୍ଛା ବେଲା ସ୍ୱର୍ଗତାଗ୍ ଆଦେପୁଟୁଙ୍କ୍ ହି ପୃତିବିତାଗ୍ ମିକା ସାରେ ହାୟି । ");
INSERT INTO kff_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ସାରେଦିନା ମାକିଂଙ୍କ୍ ଦର୍‍କାର୍‍ ଆଦାନ୍ କାଦି ହିମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ମା ବିରୁଦ୍‍ତେ ଦଷ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମାମ୍‍ମେ ବେଲା କ୍ଷମା ମାଡ଼୍‍ତମ୍, ଆଦେପୁଟୁଙ୍କ୍ ମାୱାଦ୍ ଦଷ୍ ସାରେ କ୍ଷମା ମାଡ଼େ । ");
INSERT INTO kff_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ମାକିଂଙ୍କ୍ ତିପାଲ୍ ପରିକ୍ଷାତେ ମୁନ୍‍ନେ ଆଦାନଙ୍କ୍ ହିମା, ମାତର୍ କାରାପ୍ ତାଗାଙ୍କ୍ ମାକିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼େ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ରାଜ୍ୟ, ପରାକ୍ରମ୍, ଗୌରବ୍ ଯୁଗ୍‍ଯୁଗ୍ ନିୟାଦ୍, ଆମେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ମିଇ ବିରୁଦ୍‍ତେ ଦଷ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ବାଗାତ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଯଦି ମିଡ଼୍ କ୍ଷମା ମାଡ଼ିତିଡ଼୍, ସ୍ୱର୍ଗତଣ୍ଡ୍‌ ବାବାଲ୍ ଇଶ୍ୱର୍ ମିକା ମିକିଂଙ୍କ୍ କ୍ଷେମା ମାଡ଼ିତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଯଦି ବାଗାତ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କ୍ଷମା ମାଡ଼୍‍ୱିଡ଼୍, ବାବାଲ୍ ଇଶ୍ୱର୍ ମିକା ମିଡ଼୍ ମାଡ଼ିମାନ୍ଦାନ୍ ଅପରାଦି ସାରେ କ୍ଷମା ମାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ଉପବାସ୍ ମାଡ଼ାନ୍ ୱେଲେ ବୁସା ଦାର୍ମିକିଡ଼୍ ଲେକାମ୍ ମକମ୍‍ତିଙ୍କ୍ ମାଡ଼୍‍ମାଟ୍ । ଅଡ଼୍‌ ଉପବାସ୍ ମାଡ଼ୁତଡ଼୍ ଇଞ୍ଜ ବାଗାତ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତଅତାନ୍ ମାଇଦିଙ୍କ୍ ନିଜେତ୍ ମକମ୍‍ତିଙ୍କ୍ ଜତନ୍ ମାଡ଼ି ନେୱଡ଼୍ । ଇଦ୍ ନିଜାମ୍‍ ଯେ ଆଦ୍ ରକମ୍ ମାଡ଼ାନ୍ ତଡ଼୍ ଅଡ଼୍‌ ତାମାଙ୍କ୍ ଦର୍‍କାନାଦ୍ ପାଏମ୍ ଆସ୍‍ମିନ୍ଦେଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଉପବାସ୍ ମାଡ଼୍‍ତେ ୱେଲେ ମକମ୍ ନର୍‍ସ୍, ନିୟ୍‍ ଉସି, ତାଲ୍ ଇଡ଼୍‍ସି ଲେକେତ୍‌ ଆସ୍ ମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଉପବାସ୍ ମାଡ଼ୁତିଡ଼୍ ଇଞ୍ଜ ବାଗାତ୍ ନାରୁଡ଼୍ ପୁନ୍ଦାଙ୍କ୍ ପାର୍‍ୱଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିୱଣ୍ଡ୍ ତନ୍ଦୱେନଣ୍ଡ୍ ବାବାଲ୍ ଇଶ୍ୱର୍ ଆ ସାରେ ଗଟ୍ ପୁନ୍‍ତଣ୍ଡ୍ । ମିଡ଼୍ ମିଞ୍ଜିମାଞ୍ଜ୍ ବାତ୍ ମାଡ଼ୁତିଡ଼୍; ଆଦ୍ ଉଡ଼ି, ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ପୁରସ୍କାର୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ହି ପୃତିବିତାଗ୍ ନିଜେତ୍ ସେଙ୍ଗେ ଦନ୍ ଗୁଡ଼୍‌ପାଟ୍ । ଇଗେତ୍‍ ସେଙ୍ଗେ, କାର୍କେ ପଇସ୍ ଗୁଡ଼୍‍ପାନ୍ ଦନ୍‌ କାରାପ୍ ଆଦ୍‍ତେ, ବା ମାଡ଼୍‍ଡ଼ା ସିନ୍ଦିମାଡ଼ି ଡଙ୍ଗି ଆଦ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ମାତର୍‌ ବେଗେ ପୁଡ଼୍‍ୟୁ ନୁ କାର୍‍କେ ପୟ ମେଣ୍ଡେ ଡଙ୍ଗାଲଡ଼୍‍ ଡଙ୍ଗି ଅଦ୍‍ ପାର୍‍ୱଡ଼୍‍, ଇଦ୍‍ ରକମ୍‍ ସ୍ୱର୍ଗତାଗ୍‍ ନିଜର୍‍ ନିଜର୍‍ ସେଙ୍ଗେ ଦନ୍‍ ଗୁଡ଼୍‌ପାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ବାତେଙ୍କ୍ ଇତ୍କେ ବେଗେ ମିୱାଦ୍ ଦନ୍‍ସମ୍ପତ୍ତି, ଆଗେ ମିକା ମିୱାଦ୍ ମନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“କଣ୍ଡା ମେନ୍ଦୁଲ୍‍ତେ କୁପି ରକମ୍ । କଣ୍ଡା ୱେଇସ୍ ମାତ୍‍କେ, ମେନ୍ଦୁଲ୍ ୱେଇସ୍‍ତଡ଼୍ ବର୍ତ୍ତି ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ବାତେଙ୍କ୍ ଇତ୍‍କେ କଣ୍ଡା ଯଦି ଦୁର୍ବଲ୍ ଆଦ୍‍ତେ, ମେନ୍ଦୁଲ୍ ଇକାଡ଼୍‍ତେ ବର୍ତ୍ତି ଆଦ୍‍ତେ । ମିଇ ଜିୱୁତେ ୱେଇସ୍ ଯଦି ଇକାଡ଼୍‍ ତଡ଼୍ ମିଶିଆଦ୍‍ତେ, ଆସୁଟେ ଆଦ୍ ଇକାଡ଼୍ ବେସର୍ ବୟଙ୍କର୍ ହିକାଡ଼୍ ଆୟ୍‍ୟ ! ");
INSERT INTO kff_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ଇର୍‍ୱୁଡ଼୍ ମାଲିକ୍‍ତେ ସେବା ପାଡ଼ିୟିମାଡ଼େ ପାର୍‍ୱଡ଼୍ । ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼୍‍କେ ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାସ୍‍କି ମାଡ଼ିତନ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସମ୍ମାନ୍ ମାଡ଼ିତନ୍ ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସମ୍ମାନ୍ ମାଡ଼ଣ୍ଡ୍ । ଇଶ୍ୱର୍ ଇତ୍‌ତେ ଦନ୍ ସମ୍ପତି ଇର୍‍ୱୁଡ଼ାଦ୍ ଦାସ ଆତ୍‍ତାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ଆଦିଙ୍କ୍ ନାନ୍ କେତୁତାନ୍, ବାଦ୍‍କାନ୍ ସେଙ୍ଗେ ଦର୍‍କାର୍ ଆଦାନ୍ ଆର୍‍ ନୁ ଉନ୍ଦାନ୍‍ନାଦ୍ ନୁ କେର୍‍ତାନ୍ ମାଇଦିଙ୍କ୍ ଦର୍‍କାର୍ ଆଦାନ୍ ଚକାସିଲେ ସେଙ୍ଗେ ଦାନ୍ଦେ ଆୟ୍‍ମାଟ୍ । ତିନ୍ଦାନାୱ୍ ନାଗାଙ୍କ୍ ଜିୱୁନ୍‌ ବାତ୍ ଅଦିକ୍‌ ମୂଲ୍ୟବାନ୍ ଆୟ୍‍ୟ ? ସିଲେକିନାଗାଙ୍କ୍ ମେନ୍ଦୁଲ୍ ବାତ୍ ଅଦିକ୍‌ ମୂଲ୍ୟବାନ୍ ଆୟ୍‍ୟ ?” ");
INSERT INTO kff_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ପାର୍‍ତାନ୍ ପିଟେଙ୍କ୍ ଉଡ଼ାଟ୍ । ଆହ୍ ୱିତ କି କୟ୍‍ୟ । ପସଲ୍ ଅମଲ୍ ମାଡ଼ି କୁସ୍‍ତାଗ୍ ନେହେୱ । ଇତ୍‌କେ ସ୍ୱର୍ଗତଣ୍ଡ୍‌ ବାବାଲ୍ ଇଶ୍ୱର୍ ଆୱିଙ୍କ୍ ଜତନ୍ ମାଡ଼ି କାଦି ଇଦୁତଣ୍ଡ୍ । ମିଡ଼୍ ବାତେଏ ପିଟେନାଗାଙ୍କ୍ ଅଦିକ୍‌ ମୂଲ୍ୟବାନ୍ ଆୟୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ମି ଲୋପ୍ ବେନ ଚିନ୍ତେ ମାଡ଼ି ମାଡ଼ି ନିଜର୍ ଆୟୁସ୍‍ତିଙ୍କ୍ ମେଣ୍ଡେ ସୁଦୁର୍ ଦିନାମ୍‍ତିଙ୍କ୍ କାଲ୍‍ପିତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ଚକାସିଲେନ୍ ସେଙ୍ଗେ ବାତେଙ୍କ୍ ଦାନ୍ଦେ ଆଦୁତିଡ଼୍ ? ଉଡ଼ାଟ୍, ଗୁପ୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ପୁଙ୍ଗାର୍‍ ବେଲା ପେର୍‍ସୁତା । ଆୱୁ କଷ୍ଟ ମାଡ଼ କି ନିଜେତ୍ ସେଙ୍ଗେ ଚକାସିଲେ ତିଆର୍ ମାଡ଼; ");
INSERT INTO kff_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ ରାଜା ଶଲୋମନ୍‍ ଅନାଦ୍‌ ସାରେ ସମ୍ପତି ମାତ୍‍କେମିକା ଇୱୁ ପୁଙ୍ଗାନ୍ ଲେକେମ୍ ସୁନ୍ଦର୍ ସିଲେ ବେସୁଙ୍କ୍‍ କେର୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ନେଣ୍ଡ୍ ୱାୟାତାଗ୍ ମାନ୍ଦାନ୍ ଗାଡ଼୍ ଯଦି ନାଡ଼୍ ମାନ୍‍ନ, କଇସ୍‍ମିକା ଅୟ୍‌ଦାଲ୍‌ କିସ୍‍ତାଗ୍ କାର୍‍ୱିତା । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆୱିଙ୍କ୍ ମିକା ଇଶ୍ୱର୍ ବେସର୍ ସୁନ୍ଦର୍ ସିଲେନ୍ ସଜାମାଡ଼୍‍ତଣ୍ଡ୍ । ମିକିଂଙ୍କ୍ ଚକାସିଲେ ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ବାତ୍ ଗାଟି ଚିନ୍ତେ ମାଡ଼ଣ୍ଡ୍ ? ମିୱାଦ୍ ବିଶ୍ୱାସ୍ ନିଜାମ୍ ବେସର୍ ସୁଦୁର୍ !” ");
INSERT INTO kff_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ଆଦିଙ୍କ୍ “ବେଗାକନ୍‍ସ୍ ତିନ୍ଦାନାଦ୍, କେର୍‍ଦାନାୱୁ ଦର୍‍କିତ୍, ଇଦ୍ ବିଷୟ୍‍ତେ ଚିନ୍ତେ ମାଡ଼୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ବିଜାତିନାରୁଡ଼୍ ହିସତ୍ ବିଷୟ ତେ ମେହେକ ହୁଡିତଡ଼୍, ଇୱୁ ସାରେ ବିଷୟ୍ ମିକିଂଙ୍କ୍ ଦର୍‍କାର୍ ଇଞ୍ଜ ସ୍ୱର୍ଗତଣ୍ଡ୍‌ ମିଇ ବାବାଲ୍ ଇଶ୍ୱର୍ ପୁତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ମିଡ଼୍ ଅନ୍‌ ରାଜ୍ୟତ୍ ମାଇଦିଙ୍କ୍ ହେର୍କା ମାଡ଼ାଟ୍, ଆଲେକେ ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ଇଦ୍ ସାର୍‍ରେବିଷୟ୍ ହିଦ୍‍ତଣ୍ଡ୍ । ଆଲେକେ ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ବାଗାତ୍ ସାରେ ବିଷୟ୍ ନେହେସମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ଆଦିଙ୍କ୍ ୱାଦାନ୍ ଦିନାମ୍ ସେଙ୍ଗେ ଦାନ୍ଦେ ଆୟ୍‍ମାଟ୍ । ନାଡ଼୍‍ଦେ ଚିନ୍ତେ ମାଡ଼ି ନେଣ୍ଡ୍‍ତେ ଦାନ୍ଦେ ଗାଟି ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ବିଚାର୍ ମାଡ଼ମାଟ୍, ଆଲାତ୍କେ ଇଶ୍ୱର୍‌ ମିକିଂଙ୍କ୍ ବିଚାର୍ ମାଡ଼ଣ୍ଡ୍ । ଇଶ୍ୱର୍ ମିକା ନିୟାଦ୍ ଦଷ୍ ପୟଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ବାଗାତ୍ ନାରୁଡ଼ାଦ୍ ଦଷ୍ ବିଷୟ୍‍ତେ ମିଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ବିଚାର୍ ମାଡ଼ିତିଡ଼୍, ଇଶ୍ୱର୍ ଆଦେପୁଟୁଙ୍କ୍ ମିୟାଦ୍ ବିଚାର୍ ମାଡ଼ିତନ୍ । ମିଡ଼୍ ବାଗାତ୍ ନାରୁଡ଼୍ ସେଙ୍ଗେ ବେନ୍ ନିୟମ୍ ତିଆର୍ ମାଡ଼ୁତିଡ଼୍, ଆଦ୍ ନିୟମ୍ ଇଶ୍ୱର୍ ମିଇ ସେଙ୍ଗେ ମିକା ତିଆର୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ମେଣ୍ଡେ, ବାତେଙ୍କ୍ ନି ତାମୁଣ୍ଡ୍‌ ତେ କଣ୍ଡେତାଗ୍ ମାନ୍ଦାନ୍ ଇଡ଼୍‍ପେତିଙ୍କ୍ ଉଡ଼ୁତି, ବାତେଙ୍କ୍ ଇତ୍କେ ନି ନିଜେ କଣ୍ଡେତାଗ୍ ବେନେ ଜିଟ୍‍କେ ମିନ୍ଦେ, ଆଦ୍ ହାଲ୍‍ସି ଉଡ଼୍‍ୱିନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ନିଜେତ୍ କଣ୍ଡେତାଗ୍ ୱେର୍‍କ୍ ଇଡ଼୍‍ପେ ମାନ୍‍ନା ନିମ୍‍ ବେନ୍ ସାହାସ୍‍ତେ ନି ତାମୁଣ୍ଡ୍‌ତେ କଣ୍ଡେତାଗାଙ୍କ୍ ଇଡ଼୍‍ପେତିଙ୍କ୍ ପେସ୍ପିଦ୍‍ତାନ୍ ଇଞ୍ଜ କେତୁତିନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ରେ ଦୁଷ୍ଟ ନାରୁଡ଼୍ ! ମିଇ କଣ୍ଡେତାଗ୍ ମାନ୍ଦାନ୍ ୱେର୍‍କ୍ ଇଡ଼୍‍ପେ ମୁନେନ୍ ଟେଣ୍ଡାଟ୍ । ଆଲେକେ ମିଇ ତାମୁଣ୍ଡ୍‌ତେ କଣ୍ଡେତାଗ୍ ମାନ୍ଦାନ୍ ଇଡ଼୍‍ପେତିଙ୍କ୍ ସହଜ୍‍ତେ ଉଡ଼େ ପାର୍‍ଦ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ନେୟ୍‍ ଦିଙ୍କ୍ ପବିତ୍ର ଜିନିଷ୍ ହିମାଟ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ତିଡ଼ିଇମିକା ମିକିଂଙ୍କ୍ କାସ୍ ପାର୍ଦ୍‍ତେ । ପାଦ୍‍ତେ ମୁନ୍‍ନେ ମିକା ୱାଟ୍‍ମାଟ୍ । ଆଦିନ୍ ମୁଲ୍ୟ ପୁନ୍‍ୱେକନ୍‍ସ୍ ତାଙ୍କ୍ ଆଦ୍ ଡେକେତ୍ ୱିକିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ତାଲ୍‍କାଟ୍, ଆଲେକେ ମିକିଂଙ୍କ୍ ହିଦ୍‍ତଡ଼୍; ମେହେକାଟ୍, ନିଜାମ୍ ଦର୍‍କିତ୍; କାପାଟ୍‍ତାଗ୍ ତାଲ୍‍ସାଟ୍, କାପାଟ୍ ତେର୍‍ତିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ବେନ ଆୟି ତାଲ୍‍କିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ହିଦ୍‍ତଡ଼୍; ବେନ ମେହେକିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ପାଏମ୍ ଆଦ୍‍ତନ୍; ବେନ କାପାଟ୍‍ତାଗ୍ ତାଲ୍‍ସିତଣ୍ଡ୍, ଅନ୍‌ ସେଙ୍ଗେ କାପାଟ୍ ତେର୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ମିଇ ମାର୍‍ ରୂଟି ତାଲ୍‍କ୍‍କେ ଅଂକିଙ୍କ୍‌ ବାତ୍ କାଲ୍‍ବଦା ହିଦ୍‍ତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ବା ଅଣ୍ଡ୍‌ କିକେ ତାଲ୍‍କ୍‍କେ ଅଂକିଙ୍କ୍‌ ବାତ୍ ତାଡ଼ାମ୍ ହିଦ୍‍ତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ମିଡ଼୍ ନିଜେତ୍ ଦଷ୍ ଦୁର୍ବଲ୍‍ତେ ମାତ୍‍କେ ମିକା ପିଲାକିଙ୍କ୍ ସାୟେତ୍ ଜିନିଷ୍ ହିଦ୍‍ତିଡ଼୍ । ବେନଡ଼୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ତାଲ୍‍କିତଡ଼୍, ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡେ ବେସର୍ ସାୟେତ୍ ଜିନିଷ୍ ନାର୍‍ଗେ ହିୱଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ମିଇ ସେଙ୍ଗେ ବାଗାତ୍ ନାରୁଡ଼୍ ବାତ୍ ମାଡ଼ିଡ଼୍ ଇଞ୍ଜ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍, ମିଡ଼୍ ବାଗାତ୍ ନାରୁଡ଼୍ ସେଙ୍ଗେ ଆଦ୍ ମାଡ଼ାଟ୍ । ମଶାଲ୍ ଇସ୍‍ମାନ୍ଦାନ୍ ବ୍ୟବସ୍ଥା ନୁ ବାବବାଦୀଡ଼ାଦ୍ ଶିକ୍ଷାତାଦ୍ ଇଦ୍ ଆଦୁତ୍‍ତେ କେତାନାଦ୍ ଗଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ସୁଦୁରାଦ୍ ହାର୍‍ଇସ୍ ସ୍ୱର୍ଗତାଗ୍ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଆଲ୍‍ସାଟ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନର୍‍କତାଗ୍‍ ଆଦାନ୍ ହାର୍ ଅସାର୍ ନୁ ଆଦିନ୍ ମାର୍ ବେଡ଼୍‍ୟାଦ୍‍ । ନାର୍‍ଗେ ନାରୁଡ଼୍ ନର୍କ ହାର୍‍ ଇସ୍‌ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ବାତେଙ୍କ୍ ଇତ୍‍କେ ସାରେଦିନାତ୍ ଜିୱୁଣ୍ଡ୍‍ତାକ୍ ଆଦାନ୍ ହାର୍ ଗାଟି କଷ୍ଟ ନୁ ଆଦିନ୍ ମାର୍ ସପୁର୍ ମେଣ୍ଡେ ଗାଟି ସୁଦୁଟ୍ ନାରୁଡ଼୍ ଇଦ୍‍ହାର୍ ଇସ୍‌ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ବଣ୍ଡବାବବାଦିଡ଼୍ ସେଙ୍ଗେ ସାବ୍‍ଦାନ୍ ! ଅଡ଼୍‌ ବାୟିଦେ ମେଣ୍ଢା ଚକାସିଲେ କେର୍‍ତେ ଲେକାମ୍ ତଅନ୍‌ଦିତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମୁନେଙ୍କ୍‍ତେ ଅଡ଼୍‌ ଅଣ୍ଡୟ୍‌ କୁକାଲ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ଅଡ଼ାଦ୍‌ ପାଡ଼୍‍ୟି ଉଡ଼ି ମିଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହେଞ୍ଚାଙ୍କ୍ ପାର୍‍ଦ୍‍ତିଡ଼୍‍ । କୟେ ମାଡ଼େତାଗ୍ ଅଙ୍ଗୁର୍‌ କାୟା ଆଦ ବା ପାର୍‍ୱେଲି ମାଡ଼୍‍ତାଗ୍ ତୟା ଆଦ । ");
INSERT INTO kff_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ସାୟେତ୍ ମାଡ଼େତାଗ୍ ସାୟେତ୍ କାୟା ଆଦ୍‍ଦିତ୍‍ତା । କାରାପ୍ ମାଡ଼େତାଗ୍ କାରାପ୍ କାୟା ଆଦ୍‍ଦିତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ସାୟେତ୍ ମାଡ଼େତାଗ୍ କାରାପ୍ କାୟା ଆଦ ବା କାରାପ୍ ମାଡ଼େତାଗ୍ ସାୟେତ୍ କାୟା ଆଦ । ");
INSERT INTO kff_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ସାୟେତ୍ କାୟା ଆଦକ୍ ମାଡ଼େତିଙ୍କ୍ ନାଡ଼୍‍କି କିସ୍‍ତାଗ୍ ୱାଟିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ଆଦେ ପୁଟୁଙ୍କ୍ ବଣ୍ଡବାବବାଦି ନାରୁଡ଼ାଦ୍ ପାଡ଼ିୟି ତାଗାଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିଡ଼୍ ହେଞ୍ଚ୍ ପାର୍‍ଦ୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ବେନଡ଼୍ ନାକିଂଙ୍କ୍ ‘ପ୍ରବୁ, ପ୍ରବୁ’ ଇଞ୍ଜ କାର୍‍ଙ୍ଗୁତଡ଼୍, ଅଡ଼୍‌ ସାରେତଡ଼୍ ସ୍ୱର୍ଗରାଜ୍ୟତାଗ୍ ଆଦାନଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ବେନଡ଼୍ ବାବାଲ୍ ଇଶ୍ୱର୍ ଲେକାମ୍‍ତେ ପାଡ଼୍‍ୟି ମାଡ଼ିତଡ଼୍, ମାତର୍ ଅଡ଼୍‌ ସ୍ୱର୍ଗରାଜ୍ୟତାଗ୍ ଆଦ୍‍ଦେ ପାର୍‍ଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ବେଡ଼୍‍ୟାଦ୍‍ ବିଚାର୍ ଦିନ୍ ହେୱୁକ୍‍କେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ନାକିଂଙ୍କ୍ କେତିତଡ଼୍‍, “ପ୍ରବୁ, ନି ପେଦେର୍‍ତେ ମାମ୍‍ମେ ଇଶ୍ୱର୍‌ତେ ଲେକେତ୍‌ କବର୍ କେତୁତମ୍‌, ପ୍ରବୁ, ନି ପେଦେର୍‍ତେ ବୁତ୍ ୱିଡ଼୍‍ସ୍‍ପୁତମ୍ ମେଣ୍ଡେ ନାର୍‍ଗେ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ଆସୁଟେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନାନ୍ କେତିତାନ୍, “ମିକିଂଙ୍କ୍ ନାନ୍ ପୁନନ୍ । ଆଦାର୍ମି ନାରୁଡ଼ି, ନାୟାଗାକନ୍ସ୍ ଜେକେ ଆନୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ବେନ ନା ଗଟ୍ କେଞ୍ଜି ପାଲନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ କାଲ୍‍କିନ୍ ପର୍‍ର ଲୋନ୍‌ ତଅସ୍ ମାନ୍ଦାନ୍ ବୁଦ୍‍ତଣ୍ଡ୍ ନାରୁଡ଼୍ ଲେକେମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ଗାଟି ୱାର୍‍ସାମ୍ ୱାତ୍‍ତେ, ବେଡ଼େମ୍‍ତାଦ୍ ଏର୍‍ ପେଟ୍‍ ନିଣ୍ଡି ମାୟିସ୍ ଆତ୍‍ତେ ନୁ ଆଦ୍ ଲୋତ୍‍ତେ ପର୍‍ର ଗାଟି ଗାଲ୍ ୱାତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଲୋନ୍‌ ଉର୍‍ଙ୍ଗ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ କାଲ୍‍କିନ୍ ପର୍‍ର ତିଆର୍ ଆସ୍ ମାତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନଡ଼୍ ନା ଗଟି କେଞ୍ଜି ପାଲନ୍ ମାଡ଼ଡ଼୍‍, ଅଡ଼୍‌ ଉଚ୍‍କନେଲ୍ ପର୍‍ର ଲୋନ୍‌ ତିଆର୍ ମାଡ଼ିମାନ୍ଦାନ୍ ମୁର୍କ ଲେକେମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ଗାଟି ୱାର୍‍ସାମ୍ ୱାତ୍‍କେ, ବେଡ଼େତ୍ ଏର୍‍ ଆଞ୍ଚ୍‍ ପର୍‍ରକେ ଆତ୍‍ତେ । ଗାଟି ଗାଲ୍ ୱାତ୍‍ତେ ନୁ ଲୋନ୍‌ ଦସଂ ଆତ୍‍ତେ । ଅନାଦ୍‌ ଆଦାନାଦ୍ ଗାଟି ବୟଙ୍କାର୍ ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ଶେଷ୍ ଆୟିନା ଜିସୁନାଦ୍ ଇୱୁସାରେ ଶିକ୍ଷା କେଞ୍ଜି ନାରୁଡ଼୍ ଅନ୍‌ ଶିକ୍ଷାତାଗ୍ ବାକ୍‍ୱା ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ଅଣ୍ଡ୍‌ ବାଗାତ୍ ଦର୍ମଗୁରୁଡ଼୍ ଲେକେମ୍ ଶିକ୍ଷା ଇୱକଟ କ୍ୟମତାଶାଳୀ ନାରୁଡ଼୍ ଲେକେମ୍ ଶିକ୍ଷା ହିସମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜିସୁ ମେଟେତ୍ ପର୍‍ରକଞ୍ଚ୍ ଡିଗି ୱାତ୍‍ତେ ପେର୍କେ ପିନାକେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଲେକେତ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ଆସୁଟେ ୱେରଣ୍ଡ୍ କୁଷ୍ଠରଗୀ ଅନା ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ, ନିମେ ଯଦି ଇଚ୍ଛା ମାଡ଼ିତି, ଆଲାତ୍କେ ନାକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ଡ଼େ ପାର୍‍ଦ୍‍ତିନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ଜିସୁ କାୟ୍ ଆସ୍ ଅଂକିଙ୍କ୍‌ ଇଟି କେତ୍‍ତଣ୍ଡ୍‍, “ନାନ୍ ଇଚ୍ଛା ମାଡ଼ୁତାନ୍, ନିମ୍‍ ଲେକେତ୍‍ ହାଇମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‍, “କେଞ୍ଜା, ନିମ୍‍ ବେଲା ଆସ୍ ଲେକେତ୍‍ ଆଦ୍‍ତିନ୍‌, ବେନଙ୍କ୍ କେଲ୍‍ମା; ନିମ୍‍ ସିଦା ପୁରହିତ୍‍ତା ଗାର୍‍ରେ ହାଞ୍ଜ୍ ନିଜେତିଙ୍କ୍ ପରିକ୍ଷାମାଡ଼େ ମେଣ୍ଡେ ନିମ୍‍ ସୁସ୍ଥ ଆଦ୍‍ତିନ୍‍ ଇଞ୍ଜ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ କେଞ୍ଜ୍‍ପାଙ୍କ୍ ସେଙ୍ଗେ ମୋଶାନ୍‌ ତଡ଼୍ ତିଆର୍ ଆତ୍‍ତେ ଇଞ୍ଜ ଉସ୍ୱର୍ଗ ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜିସୁ କଫର୍ନାହୁମ୍ ସହର୍‍ତାଗ୍ ହେଉତ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ୱେରନ୍ ରୋମିୟ ସେନାପତି ଅଂକିଙ୍କ୍‌ କାଇଲି ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ପ୍ରବୁ, ନାୱଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଦାସ ରୋଗ୍‍ତେ ମିନ୍ଦେଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ମେଇଲାଙ୍କ୍ ପାର୍‍ୱନ୍, ଗାଟି କଷ୍ଟ ଆଦୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‍, “ନାନ୍ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ସୁସ୍ଥ ମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ସେନାପତି କେତ୍‍ତଣ୍ଡ୍‍, “ଇଲେ, ପ୍ରବୁ, ନିମ୍‍ ନା ଲନ୍ ୱାଦ୍‍ତିନ୍, ନାନ୍ ହିଦ୍‍ଲେକାମ୍ ଯୋଗ୍ୟ ନାରୁନ୍ ଆୟନ୍ । ନିମ୍‍ ମାତର୍ ୱେରଡ଼୍ ପଦ୍ କେସିମ୍, ନା ଦାସ ସୁସ୍ଥ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ନା ପର୍‍ରତ୍ ଦାସନ୍ ଗଟ୍‍ତେ ନାନ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍କେ ମିକା ନା ଗଟ୍‍ତେ ନାର୍‍ଗେ ସୈନିକିଡ଼୍ ମିନ୍ଦେଡ଼୍‍ । ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ଅର୍‍ତୁଙ୍କ୍ ଯଦି ନାନ୍ ‘ଆନ୍‌’ ଇଞ୍ଜ୍ କେତିତାନ୍, ଅଣ୍ଡ୍‌ ଆଦ୍‍ତନ୍ । ମେଣ୍ଡେ ଅର୍‍ତୁଙ୍କ୍ ‘ୱାଡ଼େ’ ଇଞ୍ଜ କେତ୍‍କେ, ଅଣ୍ଡ୍‌ ୱାଦ୍‍ତନ୍ । ନା ଦାସଙ୍କ୍ ‘ହିଦ୍‍ମାଡ଼େ ହିଞ୍ଜ’ କେତ୍‍କେ ଅଣ୍ଡ୍‌ ଆଦ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜିସୁ ଆଦେକେଞ୍ଜି ବାକ୍‍ୱା ଆତ୍‍ତନ୍ ନୁ ମେଣ୍ଡେ ଅନ୍‌ ପେର୍କେ ୱାଦାନଡ଼କ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ନାନ୍ ସତ୍ କେତୁତାନ୍, ଇଶ୍ରାୟେଲ୍‍ତେ ବେନ୍ ନାରୁନ୍‍ନାଗ୍ ଇଣ୍ଡ୍ ନାରୁନ୍ ଲେକାମ୍ ବିଶ୍ୱାସ୍ ନାନ୍ ଉଡ଼ନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ଏର୍କା ମାଡ଼ାଟ୍, ମୁନେତ୍ ଦେଶ୍‍ତାଗାଙ୍କ୍ ନୁ ପଡ଼ଦ୍ଆଦାନ୍ ଦେଶ୍‍ତାଗାଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ୱାସ୍ ସ୍ୱର୍ଗ ରାଜ୍ୟତାଗ୍ ଅବ୍ରାହାମ୍‌, ଇସ୍‍ହାକ୍ ନୁ ଯାକୁବ୍‍ ଅଣ୍ଡୟାଗେ କାର୍‍ଙ୍ଗି ତିନ୍ଦାନଙ୍କ୍ କୁଦିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନଡ଼୍ ଇ ରାଜ୍ୟତାଗ୍ ମାନ୍ଦାନ୍ ମାତ୍‍ତେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାଇଦେ ଇକାଡ଼୍‍ତାଗ୍ ୱାଟିଦ୍‍ତଡ଼୍ । ଆଗେ ଅଡ଼୍‌ କେଇକେଇ ପାଲ୍‍କ୍ କର୍‍କିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଜିସୁ ସେନାପତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ଲୋନ୍‌ ଆନ୍‌ । ନିମ୍‍ ବାତେଏ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତି, ଆଦେକେ ଆଦ୍‍ତେ ।” ଟିକ୍ ଆଦ୍ ସମୟ୍‍ତେ ସେନାପତିନ୍ ଦାସ ସୁସ୍ଥ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ଜିସୁ ପିତର୍‍ତେ ଲୋନ୍‌ ଆଞ୍ଜ୍ ଉଡ଼୍‍ତନ୍, ପିତର୍‍ତେ ପୟେଙ୍କ୍ ବୟଙ୍କାର୍ ହେଡ଼୍‍କ୍ ଆସ୍‍ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ଜିସୁ ତାନ୍ କାଇଦିଙ୍କ୍ ହିଟ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ହେଡ଼୍‍କ୍ ୱିଡ଼୍‍ସ୍‍ତେ ନୁ ଆଦ୍ ତେଦି ମିକା ଜିସୁନାଦ୍ ସେବା ମାଡ଼ାଙ୍କ୍ ପସ୍ପ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ମୁଲ୍‍ପୁଟ୍ ଆତ୍‍ତାଙ୍କ୍ ନାରୁଡ଼୍ ନାର୍‍ଗେ ବୁତ୍‌ପଇତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଜିସୁନ୍ ଗାର୍‍ରେ ତାତ୍‍ତଡ଼୍ । ପଦେନ୍ ଗଟ୍‍ତେ ଅଣ୍ଡ୍‌ ବୁତ୍‍ଆତ୍ମାକିଙ୍କ୍ ତଲ୍‍ତନ୍ ନୁ ରଗି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଆଦିନ୍ ସେଙ୍ଗେ ଆଦ୍ ବାବବାଦୀଡ଼୍ ଯିଶାୟିନ୍ ବବିଷ୍ୟତ୍‍ ବାଣିତିଙ୍କ୍ ସାରେ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଯିଶାୟ କେତ୍‍ତଣ୍ଡ୍‍, “ଅଣ୍ଡ୍‌ ମାୱାଦ୍ କଷ୍ଟତିଙ୍କ୍ ଦୁରାମ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ମାକିଂଙ୍କ୍ ରୋଗ୍‍ତାଗାଙ୍କ୍ ମୁକ୍ତି ମାଡ଼୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ଅନ୍‌ ତିଡ଼୍‍ପାକା ନାରୁଡ଼୍ ଗଅଲି ହାଦାନାଦ୍ ଉଡ଼ି, ଜିସୁ ଶିଷ୍ୟନଡ଼୍‍କ୍ ଇଲ୍‍କେତ୍‍ ଆପାକେ ଆଦାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ୱେରନ୍ ଦର୍ମଗୁରୁ ୱାସ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, ହୋ “ଗୁରୁ, ନିମ୍‍ ବେଗେ ଆଦ୍‍ତିନ୍‍, ଆଗେ ନାନ୍‍ନେ ମିକା ଆଦ୍‌ଦାଙ୍କ୍ ତିୟାର୍ ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‍, “କଙ୍ଗାନାକାନ୍ ଦୋର୍‌ରା ମିନ୍ଦେ, ପିଟେଙ୍କ୍ ତୁହୁକା ମିନ୍ଦେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ରମାନ୍ ସେଙ୍ଗେ ନାରୁଡ଼୍‍କ୍ ପଡ଼ିୟେ ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଜିସୁଙ୍କ୍ ମେଣ୍ଡ୍‍ଅର୍‍ତୁନ୍ ଶିଷ୍ୟ କେତ୍‍ତଣ୍ଡ୍‍, “ପ୍ରବୁ, ମୁନେନ୍ ଆଞ୍ଜ୍ ନା ବାବାଙ୍କ୍ ସମାଦି ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ଗଟ୍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତନ୍ ନା ପେର୍କେପେର୍କେ ୱାଡ଼େ, ଡଲ୍‍ତେନଡ଼୍‍କିଂଙ୍କ୍ ସମାଦି ହିଦାଙ୍କ୍ ଡୋଲ୍‍ତଡ଼୍‍କ୍ ୱିଡ଼୍‍ସିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ଅନ୍‌‍ଦିନେ ଜିସୁ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ଓଡେତେ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ହଟାତ୍ ସମୁଦ୍ରତାଗ୍ ଇଦ୍‍ଲେକାମ୍‍ ଗାଟି ଗାଲ୍‍ୱାର୍ସାମ୍ ୱାତ୍‍ତେ ନୁ ଓଡ୍‌ ହେର୍‍ଦାଗ୍ ମୁଡ଼୍‍ନ୍ଦାନ୍ ଲେକାମ୍ ଆତ୍‍ତେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଆସୁଟେ ଉଞ୍ଜି ମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ଶିଷ୍ୟନଡ଼୍ ଅଂକିଙ୍କ୍‌ ତେସ୍ କେତ୍‍ତଡ଼୍, “ପ୍ରବୁ, ମାକିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼େ । ହିଲୁକ୍ ମାମ୍‍ମେ ମୁଡ଼୍‍ନ୍ଦି ଡଲିତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜିସୁ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍‍, “ବାତ୍‍ତିଙ୍କ୍ ହିସର୍ ୱେର୍‍ଦୁତିଡ଼୍ ? ମିଡ଼୍ ସାରେତଡ଼ି ବାତେଏ ସୁଦୁଟ୍ ବିଶ୍ୱାସିଡ଼୍ ?” ତାନ୍ ପେର୍କେ ଅଣ୍ଡ୍‌ ତେଦି ଗାଲ୍‍ତିଙ୍କ୍ ନୁ ତଲ୍‍କଡ଼୍‍ତିଙ୍କ୍ କଟ ଆଦାଙ୍କ୍ ଆଦେଶ୍ ହିତ୍‍ତନ୍ । ସାଙ୍ଗେ ସାଙ୍ଗେ ସାରେ ଶାନ୍ତି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ଆଗାଙ୍କ୍ ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ନିଜେ ନିଜେ କେତାକେତି ଆତ୍‍ତଡ଼୍ “ହିଣ୍ଡ୍ ବେସତ୍ ନାରୁନ୍ ? ଗାଲ୍ ନୁ ତଲ୍‍କଡ଼୍ ମିକା ଅନ୍‌ ଗଟ୍ କେଞ୍ଜୁତା ।” ");
INSERT INTO kff_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ଜିସୁ ଇଲ୍‍କେତ୍‍ ମେଣ୍ଡନ୍ ପାକେ ଗଦରିୟ ଯାଗାତାଗ୍ ଆସ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ହିର୍‍ଉଡ଼୍ ନାରୁଡ଼୍‍କ୍ କାହିଲ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ସମାଦି ପାଡ଼୍‍କିନ୍ ଲୋପେ ମାଞ୍ଜମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ବୁତ୍‍ ପହିତେନଡ଼୍ ନୁ ଗାଟି ବୟଙ୍କାର୍ ମାତ୍‍ତଡ଼୍ ଆଦ୍ ଆର୍‍ ଇସ୍‌ ଆଦ୍‍ଦା ୱାଦା ମାଡ଼ାଙ୍କ୍ ବେନମିକା ସାହାସ୍ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ଉଡ଼୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଗାଟିଲେଙ୍କ୍‍ଦେ କେତ୍‍ତଡ଼୍, “ହୋ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ! ମାୟାଗ୍‌ କଞ୍ଜ୍ ନିମ୍‍ ବାତ୍‍ଇଚ୍ଛା ହାଦୁତିନ୍ ? ମାୱାଦ୍ ଦିନାମ୍ ହେଉୱାକେ ମାକିଂଙ୍କ୍ ବାତ୍ ଦଣ୍ଡ୍ ହିଦାଙ୍କ୍ ୱାତ୍‍ତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ଆଗାଙ୍କ୍ ସୁଦୁଟ୍ ଦୁରାମ୍ ପାଦ୍‍ ମାନ୍ଦେ ମେୟମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ଆ ନାରିଡ଼୍ ଲୋପେ ମାନ୍ଦାନ୍ ବୁତ୍‌କ୍ ଜିସୁଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ିକେତ୍‍ତା, “ମାକିଙ୍କ୍‍ ଯଦି ତଲାନଙ୍କ୍ ଇଚ୍ଛା ମାଡୁତିନ୍‍ ଆଲାଇତ୍କେ, ଆଉ ମାନ୍ଦେପାଦିନ୍ ଲୋପେ ରହସିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍ “ଆନୁଟ୍ । ବୁତ୍‌କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ନାରୁଙ୍କ୍ ୱିଡ଼୍‍ସି ମାନ୍ଦେପାଦିନ୍ ଲୋପେ ହସ୍‍ତା । ପାଦି ମିରିଆଞ୍ଜ୍ ନୁ ମେଟେତ୍‍ ଆଞ୍ଚ୍ ମଦଲ୍ ଡିଗି ଇଲ୍‍କେତାଗ୍ ରାଲି ଡଲ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ପାଦି କେପାନ୍ ନାରୁଡ଼୍ ଗାର୍‍ରେତ୍ ସହର୍‍ତାଗ୍ ମିରିଆଞ୍ଜ୍ ବୁତ୍‍ପଇତେ ନଣ୍ଡ୍ ସେଙ୍ଗେ ବାତ୍ ଗଟେମ୍ଆତ୍‍ତେ ନୁ ମେଣ୍ଡେ ବାଗାତ୍ ସାରେ ଗଟି ଆଗେ କେସଡ଼୍‍ ଉଡ଼୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ଆସୁଟେ ଆଦ୍ ସହର୍‍ତେ ସାରେତଡ଼୍ ଜିସୁଙ୍କ୍ କାଇଲାନ୍ ସେଙ୍ଗେ ପେଇତଡ଼୍ ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ କାହିଲି ଆଦ୍ ପଡ଼ିୟେ ୱିଡ଼୍‍ସି ଆଦାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଜିସୁ ଓଡେତାଗ୍ କୁଦି ଇଲ୍‍କେତ୍ ମେଣ୍ଡନ୍ ପାକ୍ ମାନ୍ଦାନ୍ ନିଜେତ୍ ସହର୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ଆଗେ ୱେରନ୍ ପକ୍ୟାଗାତ୍ ରୋଗିଙ୍କ୍ ନାରୁଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ତାତ୍‍ତଡ଼୍ । ରୋଗି ତାନ୍ କେତ୍‍ତାଗ୍ ପାଟ୍‍ଟିମାତ୍‍ତନ୍ । ଜିସୁ ଅଡ଼ାଦ୍‌ ନାର୍‍ଗେ ବିଶ୍ୱାସ୍ ଉଡ଼ି ପକ୍ୟାଗାତ୍ ରୋଗିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବାବୁ, ସାହାସ୍ ପୟିମ୍ । ନିୟାଦ୍ ପାପ୍‌ ସାରେ କ୍ଷମା ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଶାସ୍ତ୍ରୀନାରୁଡ଼୍ ଇଦ୍ ଗଟ୍ କେଞ୍ଜି ହେର୍କା ମାଡ଼୍‌ତଡ଼୍, “ହିଣ୍ଡ୍ ନାରୁନ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଲିନ୍ଦ୍ ମାଡ଼ୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ଅଡ଼ାଦ୍‌ ମନ୍‍ତାଦ୍ ଗଟ୍ ପୁଞ୍ଜ୍ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ମିଡ଼୍ ବାତେଙ୍କ୍ କାରାପ୍ ଶିନ୍ତେ ମାଡ଼ୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘ମିୟାଦ୍ ପାପ୍ କ୍ଷମା ଆତ୍‍ତେ ?’ ହିଦ୍ ଗଟ୍ କେତାନାଦ୍ ସହଜ୍ ନା ‘ତେଦି ଆନ୍‌’ କେତାନାଦ୍ ଅଦିକ୍‌ ସହଜ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପୃତିବିତେ ପାପ୍ କ୍ଷମା ମାଡ଼ାନାଦ୍ ଗାଲା ମନୁଷ୍ୟପୁତ୍ରନ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ, ଇଦ୍ ଗଟ୍ ମିଇ ମୁନେ ପ୍ରମାନ୍ ମାଡ଼ିତାନ୍ ।” ତାନ୍ ପେର୍କେ ଜିସୁ ପକ୍ୟାଗାତ୍ ରୋଗିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ତେଦା, କେତ୍‍ ତେଇସ୍, ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆନ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ଅନ୍‍ ମୁନେ ରୋଗି ତେଦିମେଣ୍ଡେ ଲୋନ୍‌ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ନାରୁଡ଼୍ ଆଦ୍ ଉଡ଼ି ବାକ୍‍ୱା ଆଦ୍‍ତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁନ୍‍ପିଲେତିଙ୍କ୍ ହିଦ୍‍ଲେକାମ୍ ଅଦିକାର୍‌ ହିତ୍‍ତାଙ୍କ୍ ଅଡ଼୍‌ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜିସୁ ଆଗାଙ୍କ୍‌ ଆଦାନ୍ ୱେଲେ ମାତିଉ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ କରହାଦାୟ୍‍ ମାଡ଼ାନକିଙ୍କ୍ ଅପିସ୍‍ତାଗ୍ କୁଦିମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତନ୍ ନୁ ଅଂକିଙ୍କ୍‌ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍‍, “ନା ପେର୍କେପେର୍କେ ୱାଡ଼େ ।” ମାତିଉ ତେଦି ଅଂକିଙ୍କ୍‌ ଲେକେତ୍‌ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଜିସୁ ମାତିଉନ୍ ଲୋନ୍‌ ତିନ୍ଦାନ୍ ୱେଲେ ନାର୍‍ଗେ କରଆଦାୟନଡ଼୍ ନୁ ଦୁଷ୍ଟ ନାରୁଡ଼୍ ନୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ତିନ୍ଦାଙ୍କ୍ କୁଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଦୁଷ୍ଟ ନାରୁଡ଼୍ ଉଡ଼ିମେଣ୍ଡେ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ପାଚ୍‍ରିଞ୍ଚ୍‍ତଡ଼୍, “ମିଇ ଗୁରୁ ହିଦ୍‍ରକମ୍ ନାରିଡ଼୍ ତଡ଼୍ ବାତ୍‍ତିଙ୍କ୍ ଅଣ୍ଡୟାଗେ କୁଦିତିନ୍ଦୁତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍‍, “ସୁସ୍ଥ ନାରୁଡ଼୍‍ତେ ସେଙ୍ଗେ ଡାକ୍ଟର୍ ଦର୍‍କାର୍ ଆୟ୍‍ୟ । ମାତର୍ ରୋଗି ନାରିଡ଼୍ ସେଙ୍ଗେ ଡାକ୍ଟର୍ ଦର୍‍କାର୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ଶାସ୍ତ୍ରତାଗ୍ ଲେକ୍‍ତାଦ୍ ମିନ୍ଦେ, ନାୱାଦ୍ ଇଚ୍ଛା ଦୟା, ବଲିଦାନ୍ ଆୟ୍‍ୟ, ଇ ଗଟ୍‍ତେ ଇତ୍‍କେ ବାତେଏ, ଆଞ୍ଜ୍ ମେଣ୍ଡେ ବୁଜେମ୍‍ଆଦାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼େ । ନାନ୍ ଦାର୍ମିକ୍ ନାରିଡ଼୍‍କ୍ କାର୍‍ଙ୍ଗାଙ୍କ୍ ୱାଡ଼ନ୍; ୱାତ୍‍ତାନ୍ ପାପିନାରିଡ଼୍‍ ସେଙ୍ଗେ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ତାନ୍ ପେର୍କେ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟନଡ଼୍ ଜିସୁନ୍ ପାକେ ୱାସ୍ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ମାମ୍‍ମେ ନୁ ପାରୂଶୀଡ଼୍ ହିସଦାମ୍ ଉପବାସ୍ ମାଡ଼ୁତମ୍, ନି ଶିଷ୍ୟଡ଼୍ ବାତ୍‍ତିଙ୍କ୍ ବେସୁଙ୍କ୍‍ ବା ଉପବାସ୍ ମାଡ଼ଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, ପେଣ୍ଡୁଲ୍ ଆଦାନାଗ୍ ବର ମାନ୍ଦାନ୍ ଯାକ କୁଟ୍‍ମାମ୍‍ ବାତେଏ ଦୁଃକାମ୍ ମାଡ଼ିତଡ଼୍ ? ବେସୁଙ୍କ୍‍ ବା ଆୟ୍‍ୟ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦିନାମ୍ ୱାଦ୍‍ତେ, ବେସୁଙ୍କ୍‍ ବର ଆଦ୍‍ତନ୍; ଆସୁଟେ ଅଡ଼୍‌ ଉପବାସ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ବେନ ପାଃନ୍ତେ ସିଲେନାଗ୍ ପୁନାଲାଉ କନାନ୍ ତାଲି ୱାଟଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ପୁନାଲାଉ କନା ତାଲି ମୁଦାନାଉ ଆସ୍ ଇଙ୍କ୍‍ତେ ପଡ଼ିୟେ ତାଗ୍ ଅଦିକ୍‌ ଇକିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ବେନ ପାଃନ୍ତେ ତଲ୍‍କେ ଗିନେତାଗ୍ ପୁନାଦ୍ ଦ୍ରାକ୍ଷାରସ୍ ବର୍ତ୍ତି ମାଡ଼ଡ଼୍‍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦିନ୍ ତଡ଼୍ ତଲ୍‍କେ ତାଲି ହିଙ୍ଗି ନଷ୍ଟ ଆଦ୍‍ତେ ନୁ ଦ୍ରାକ୍ଷାରସ୍ ୱାଙ୍ଗ୍‍ଗି ନେଲ୍ ରାଲ୍‍ତେ । ପୁନାଦ୍ ଦ୍ରାକ୍ଷାରସ୍‍ତିଙ୍କ୍ ପୁନେ ତଲ୍‍କେ ଗିନେତାଗ୍ ୱାଟ୍‍କେ, ରେଣ୍ଡ୍ ଦ୍ରାକ୍ଷାରସ୍ ନୁ ତାଲି ସାୟେ ମାନ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଜିସୁ ଇଉ ସାରେ ଶିକ୍ଷା ହିଦାନ୍ ୱେଲେ ୱେରନ୍ ଇହୁଦୀ ମୁକ୍ୟଦାସ ଅନ୍‌ ପାକେୱାସ୍ ମର୍‍ମିଣ୍ଡା ଉସ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ହିଞ୍ଜେନେ ନା ମାୟାଡ଼୍ ଡଲ୍‍ତେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିମ୍‍ ୱାସ୍ ତାନ୍ ପର୍‍ର କାୟ୍ ୱାଟ୍‍କେ, ଆଦ୍ ନିଜାମ୍ ଜିୱୁନ୍‍ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ସାଙ୍ଗେ ସାଙ୍ଗେ ଜିସୁ ତେଦ୍‍ତନ୍ ନୁ ଅଣ୍ଡ୍‌ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ଅନ୍‌ ଶିଷ୍ୟ ପେର୍କେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଜିସୁ ଆଦାନ୍ ୱେଲେ ୱେରଡ଼୍ ନାଟାଡ଼୍ ଅନ୍‌ ଗାରେ ୱାସ୍ ଅନ୍‌ ସିଲେତିଙ୍କ୍ ହିଟ୍‍ତେ । ଆଦ୍ ବାରହେଣ୍ଡ୍ ଯାକ ଗାଟି ନେତୁର୍ ପେଇତାନ୍ ରୋଗ୍‍ତେ କଷ୍ଟ ଆସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ଆଦ୍ ଏର୍କା ମାଡ଼୍‍ତେ, “ମାତର୍ ଅନ୍‌ ସିଲେତିଙ୍କ୍ ୱେରଡ଼୍‍ଦାମ୍ ହିଟ୍‍କେ, ନାନ୍ ସୁସ୍ଥ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ଜିସୁ ତାଙ୍କ୍ ମାଲ୍‍ସ୍ ଉଡ଼୍‍ତନ୍ ନୁ ମେଣ୍ଡନ୍ ପାକ୍ ଇସ୍‌ କେତ୍‍ତାନ୍, “ନନି, ସାହାସ୍ ପହିମ୍ । ନି ବିଶ୍ୱାସ୍ ନିକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତେ ।” ଆସୁଟେ ଆ ମୁତ୍‍ତେ ସୁସ୍ଥ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ତାନ୍ ପେର୍କେ ଜିସୁ ଇହୁଦୀ ଦାସନ୍ ଲୋନ୍‌ ହେଉତନ୍ । ଆଗେ କାର୍‍ଙ୍ଗି ମାନ୍ଦାନ୍ ବାଦ୍ୟକାର୍ ନୁ ମେଣ୍ଡ୍‍ବାଗାତ୍ ନାରୁଡ଼୍ ଗଲ୍‍କ୍ ମାଡ଼ାନାଦ୍ ଉଡ଼ି, ");
INSERT INTO kff_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ସାର୍‍ତଡ଼ି ହିଗାଙ୍କ୍ ପେଇସ୍ ଆନୁଟ୍ । ପିକିର୍‍ ଡଲ୍‍ଲ । ଆଦ୍ ଉଞ୍ଜିମିନ୍ଦେ ।” ଅନାୱୁ ଗଟି କେଞ୍ଜି ଅଡ଼୍‌ ପରିହାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ପେଇସ୍ ଆତ୍‍ତେ ପେର୍କେ ଜିସୁ ପିକ୍‍ତେ ବାକ୍‍ଡ଼େତାଗ୍ ଆଞ୍ଜ୍ ତାନ୍ କାଇଦିଙ୍କ୍ ପଇସ୍ ତେହେତ୍‍ତଣ୍ଡ୍ ନୁ ଆଦ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ତେଦି କୁଦ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଇଦ୍ ଗଟନାତାଦ୍ କବର୍ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ସାରେପାକ୍ ଗଟ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜିସୁ ଆଗାଙ୍କ୍ ୱାଦାନ୍ ୱେଲେ ଇର୍‍ୱୁଡ଼୍ କାନାଲଡ଼୍‍କ୍ ଅଣ୍ଡ୍‌ ସୁସ୍ଥ ମାଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଡ଼୍, “ହୋ ଦାଉଦ୍‍ ବଂଶତଣ୍ଡ୍, ମାକିଂଙ୍କ୍ ଦୟା ମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ଅଡ଼୍‌ ଜିସୁନ୍ ପେର୍କେପେର୍କେ ଆଞ୍ଜ୍ ଅଣ୍ଡୟ୍‌ ଲୋନ୍‌ ହସ୍‍ତଡ଼୍ । ଆଗେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼ତଣ୍ଡ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ିତାନ୍ ଇଞ୍ଜ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତିଡ଼୍ କି ?” ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ହୋ ପ୍ରବୁ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ଆସୁଟେ ଜିସୁ ଅଡ଼ାୱୁ କଣ୍ଡାଙ୍କ୍ ଇଟି ମିକା କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବେଲା ବିଶ୍ୱାସ୍ ମାଡ଼ୁତିନ୍ ଆଦେରକମ୍ ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଡ଼୍‌ କଣ୍ଡା ଉଡ଼୍‍ତଡ଼୍ । ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କଡ଼ା ଗଟ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ସାବ୍‍ଦାନ୍ ! ବେନମେଣ୍ଡ୍ ଇଦ୍ ଗଟ୍ ପୁନ୍‍ମାକି ।” ");
INSERT INTO kff_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଆଗାଙ୍କ୍ ଆଞ୍ଜ୍ ଜିସୁନ୍ ଗଟି ସାରେଏକାମ୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ଅଡ଼୍‌ ଆଦାନ୍ ୱେଲେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ୱେରଣ୍ଡ୍ କନ୍ଦାଙ୍କ୍ ଜିସୁନ୍ ଗାର୍‍ରେ ତାତ୍‍ତଡ଼୍ । ଅଂକିଙ୍କ୍‌ ବୁତ୍ ପଇସ୍ ମାତ୍‍ତାଙ୍କ୍ ଅଣ୍ଡ୍‌ କନ୍ଦାଲ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଜିସୁ ଅନ୍‌ ମେନ୍ଦୁଲ୍‍ତେ କନ୍‍ସ୍ ବୁତ୍‌ତିଙ୍କ୍ ପେସ୍ପ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଣ୍ଡ୍‌ ଗଟି ତିରିୟାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆସ୍ କେତ୍‍ତଡ଼୍, “ଇସ୍ରାଏଲ୍ ଦେଶ୍‍ତାଗ୍ ମାମ୍‍ମେ ଇଦ୍‍ରକମ୍ ପାଡ଼୍‍ୟି ବେସୁଙ୍କ୍‍ ଉଡ଼୍‍ୱେ ମାତ୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପାରୂଶୀଡ଼୍ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ନାରୁଡ଼୍ ବୁତ୍‌ପତି ଶକ୍ତିତଡ଼୍ ବୁତ୍‌କ୍ ୱିଡ଼୍‍ସ୍‍ପୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ଜିସୁ ଉଡିଉଡି ନାର୍‍ଗେ ସହର୍ ନୁ ନାର୍‍କିନାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ସାରେ ପଡ଼ିୟେତାଗ୍ ଅଣ୍ଡ୍‌ ପ୍ରାର୍ତନା ଲୋକିନାଗ୍ ଶିକ୍ଷା ହିତ୍‍ତଣ୍ଡ୍, ସ୍ୱର୍ଗରାଜ୍ୟତେ ସାଏତ୍ କବର୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ନାର୍‍ଗେ ରଗ୍‍ତେ ନୁ ରୋଗି ନାରୁଡ଼୍‍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଉଡ଼ି ଅଣ୍ଡ୍‌ ଦୟା ମାଡ଼୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମେୟିତାନଣ୍ଡ୍ ଇଲ୍‍ୱେ ମେଣ୍ଢାନ୍ ରକମ୍ ଅଡ଼୍‌ ଗାଟିଦାନ୍ଦେ ଆସ୍‍ସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଶିଷ୍ୟଡ଼କିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପସଲ୍ ନାର୍‍ଗେ ଆସ୍‍ମିନ୍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆୱିଙ୍କ୍ ଜତନ୍ ଅଦାନ୍ ସେଙ୍ଗେ କୁଲିକି ସୁକୁକ୍‍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ନାର୍‍ଗେ କୁଲି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରହସ୍ କେଡ଼୍ କଇସ୍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ୱାୟେ ମାଲିକ୍‍ତିଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ି କେଲ୍‍ମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଜିସୁ ତାନ୍ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ବୁତ୍ ୱିଡ଼୍‍ସ୍‍ପାନ୍ ସେଙ୍ଗେ ନୁ ସାରେ ଲେକାମ୍ ଦୁଃକାମ୍ କନ୍‍ସ୍ ସୁସ୍ଥ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଶକ୍ତିଇସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରହସିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ଅଡ଼୍‌‍ ବାରଜାନ୍ ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍ ପେଦେର୍ ଶିମୋନ୍ ନୁ ତାନ୍ ତାମୁଣ୍ଡ୍‌ ଆନ୍ଦ୍ରିୟ; ଯେବଦିନ୍ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କ୍ ଯାକୁବ୍ ନୁ ଯୋହନ୍‌; ");
INSERT INTO kff_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ପିଲିପ୍, ବର୍ତଲମି, ତୋମା ନୁ କରଆଦାୟକାରି ମାତିଉ; ତଦ୍ଦିୟ, ଆଲ୍‍ଫିତେ ମାର୍‍ ଯାକୁବ୍; ");
INSERT INTO kff_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ଦେଶ୍‍ପ୍ରେମି ଶିମୋନ୍ ନୁ ଜିସୁଙ୍କ୍ ବିଶ୍ୱାସଗାତକତା ମାଡ଼ିମାନ୍ଦାନ୍ ଇଷ୍କାରିୟୋତିୟ ଯିହୁଦା । ");
INSERT INTO kff_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଅଣ୍ଡ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରତ୍‍ତାନ୍ ୱେଲେ ଆଦେଶ୍ ଇସ୍ କେତ୍‍ତନ୍ ମିଡ଼୍, “ଅଣଇହୁଦୀଡ଼୍ ଦେଶ୍‍ତାଗ୍ ଆନ୍‌‍ମାଟ୍ । ବେନ୍ ଶମିରୋନିୟ ସହର୍ ତା ମିକା ଆନ୍‌‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ମାଇ ମାନ୍ଦାନ୍ ମେଣ୍ଢାନ୍‍ଲେକେ ଇଶ୍ରାଲୀୟଡ଼୍ ପାକେ ଆନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ଅଡ଼୍‌‍ଲୋପେ ଆଞ୍ଜ୍ ପ୍ରଚାର୍ ମାଡ଼ି କେଲ୍‍ମୁଟ୍, “ସ୍ୱର୍ଗରାଜ୍ୟ ଆଦାନାଦ୍‌ !” ");
INSERT INTO kff_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ରୋଗି ନାରୁଡ଼୍‍କ୍ ସୁସ୍ଥ ମାଡ଼ାଟ୍, ଡଲ୍‍ତେ ନାରିଡ଼୍‍କ୍ ମେଣ୍ଡେ ଜିୱେ ମାଡ଼ାଟ୍, କୁଷ୍ଠି ନଡ଼କ୍ ରୋଗ୍ ମୁକ୍ତ ମାଡ଼ାଟ୍, ବୁତ୍ ୱିର୍‍ସ୍‍ପାଟ୍ । ବାତ୍ ଆସମ୍ ଡାବ୍‍ତେ ଦର୍‍କ୍‍ତେ, ଆଦ୍ ବାଗାତ୍ ନାରୁଡ଼୍‍କ୍ ଆସାମ୍ ପାଇସାନେ ଦାନ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ଆର୍କେ ସୁନା, ରୁପା ନୁ ଡାବ୍‍କ୍ ଅୟ୍‍ମାଟ୍, ");
INSERT INTO kff_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ବିକ୍ ତାଲି ପଇସ୍ ଉଡ୍‍ମାଟ୍ । ଅଣ୍ଡୟ୍‌ ମିକା ସିଲେ ଅଦିକ୍‌ ଅୟ୍‍ମାଟ୍, ହେର୍‍ପୁକ୍ ନୁ ଟେଙ୍ଗା ମିକା ଅୟ୍‍ମାଟ୍ । ପାଡ଼ିୟିମାଡ଼ାନଡ଼୍ ତାମାଦ୍ ମଜୁରି ଦର୍‍କାନ୍ ସେଙ୍ଗେ ହକ୍‍ଦାର୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ଅଣ୍ଡୟ୍‌ ସହର୍ ବା ନାର୍‍ଦାଗ୍ ହେଉତେ ୱେଲେ ମିକିଂଙ୍କ୍ ଆଗେ ବେନ ସେବା ମାଡ଼ିତନ୍, ଆଦ୍ ଗଟ୍ ବୁଜେମ୍ ଆସ୍ ମେଣ୍ଡନ୍ ପାକେ ଆଦାନ୍ ଯାକ ଆଦେ ଲୋନ୍‌ ମାନୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ଅଣ୍ଡୟ୍‌ ଲୋନ୍‌ ଅସ୍‍ତେ ୱେଲେ ଆଗେମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନମସ୍କାର୍‌ ମାଡ଼ି କେଲାଟ୍, “ମିୟାଦ୍ ଶାନ୍ତି ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ଅଡ଼୍‌ ଯଦି ମିକିଂଙ୍କ୍ କାର୍ଙ୍ଗିତଡ଼୍‍, ଅଡ଼୍‌ ସେଙ୍ଗେ ମିୟାଦ୍ ଆଶିର୍ବାଦ୍‍ ସାରେ ଆଦ୍‍ତେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିକିଂଙ୍କ୍ ଯଦି କାର୍ଙ୍ଗଡ଼୍‍, ମିଡ଼୍ ମିଇ ଆଶିର୍ବାଦ୍‍ ମାଲ୍‍ପି ଅୟ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଯଦି ବେନ ମିକିଙ୍କ୍ ଗ୍ରହନ୍‍ ମାଡ଼ଣ୍ଡ୍‍ ବା ମିୟାଦ୍‍ ଗଟ୍‍ କେଞ୍ଜଣ୍ଡ୍‍, ଆଦ୍‍ ଲୋନ୍‌ ବା ନାର୍‍ତାଗାଙ୍କ୍‍ ପେୟ୍‍ସ୍‍ ଆଦାନ୍‍ ୱେଲେ ଡେକେତ୍ ମାଣ୍ଡୁଲ୍ କାହିସିସ୍ ଆଦ୍‍ପଡ଼ିୟେ ୱିଡ଼୍‍ସିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ନାନ୍ ନିକିଂଙ୍କ୍ ନିଜାମ୍‍ କେତୁତନ୍, ବିଚାର୍ ଦିନାତେ ହିଡ଼ାକଞ୍ଜ୍ ସଦୋମ୍‍ ନୁ ଗମୋରାତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଇଶ୍ୱର୍ ଅଦିକ୍‌ ଅନୁଗ୍ରହ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“କେଞ୍ଜାଟ୍, ମେଣ୍ଢାଙ୍କ୍ କୁକାଲ୍‍ ପାୟୁର୍‍ତାଦ୍ ତୁର୍‍ସିତ୍‍ତେ ଲେକାମ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ରତୁତାନ୍ । ଆଦିଙ୍କ୍ ମିଡ଼୍ ତାଡ଼ାମ୍ ଲେକାମ୍ ତିଆର୍‍ତେ ମାନୁଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ବଡେ ବେଲା ବେନଙ୍କ୍ ଇଂସା ମାଡ଼, ମିଡ଼୍ ଆଦ୍‍ଲେକାମ୍ ଆୟ୍‍ମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ତିଆର୍‍ତେ ମାନୁଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁଡ଼୍ ମିକିଂଙ୍କ୍ ଗିରାପ୍ ମାଡ଼ି ବିଚାର୍‍ଲତ୍‍ତାଗ୍ ଅଦ୍‍ତଡ଼୍ । ପ୍ରାର୍ତନା ଲୋକିନାଗ୍‍ ଅଡ଼୍‌ ମିକିଂଙ୍କ୍ ଚାବୁକ୍ ତଡ଼୍ ରେହେତିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“ନା ସେଙ୍ଗେ ମିଡ଼୍ ରାଜା ନୁ ଶାସନ୍‍ କର୍ତାଲଡ଼୍‍ ମୁନେ ଅସ୍ ବିଚାର୍ ମାଡ଼ିତଡ଼୍ । ଇଦିନ୍ ତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନୁ ବିଜାତିଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଚାୟେତ୍‍ କବର୍ ଇଦାନ୍ ମାଇଦିଙ୍କ୍ ସାକ୍ଷି ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ମିକିଂଙ୍କ୍ ବିଚାର୍ ମାଡ଼ାନ୍ ୱେଲେ ବାତ୍ କେତିତିଡ଼୍ ନୁ ବେଲାକେତିତିଡ଼୍, ହିଦ୍ ବିଷୟ୍‍ତେ‍ ଚିନ୍ତେ ମାଡ଼୍‍ମାଟ୍ । ଟିକ୍ ସମୟ୍‍ତେ ଆଦ୍ ମିକିଂଙ୍କ୍ କେସ୍‍ସିଦ୍‌ତଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିକିଂଙ୍କ୍ ନିଜେ ବାତ୍‍ମିକା କେତାଙ୍କ୍ ୱେୟ୍ । ବାବାଲ୍ ଇଶ୍ୱର୍‌ତାଦ୍ ପବିତ୍ର ଆତ୍ମା ମିଇ ପାୟୁର୍‍ତେ ଆଲାଇତ୍‍କେ ଗଟ୍‍କେତ୍‍ତିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ନାରୁଡ଼୍ ନିଜେତ୍ ତାମୁଣ୍ଡ୍‌କିଡ଼୍‍କ୍ ଡଲାନ୍‍ଦଣ୍ଡ୍ ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ପସ୍‍ପିଦ୍‍ତଡ଼୍‍ । ବାବାଲ୍ ମିକା ନିଜେତ୍ ପିଲାନ୍ ସେଙ୍ଗେ ଆଦ୍‍ଲେକାମ୍ ବେବ୍ୟହାର୍ ମାଡ଼ିତନ୍ । ପିଲା ତାମ୍ ୟାୟ୍‍ ବାବାନ୍ ବିରୁଦ୍‍ତେ ଆଞ୍ଜ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆୱକିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ନା ସେଙ୍ଗେ ସାରେତଡ଼୍ ମିକିଂଙ୍କ୍ ପାସ୍‍କି ତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନହାୟି ପେର୍କେଆଇନା ଶକ୍ତିତଡ଼୍ ପଇସ୍‌ ମାନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମୁକ୍ତି ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ୱେରଡ଼୍ ସହର୍ ତାଗ୍ ମିକିଂଙ୍କ୍ କଷ୍ଟ ଆତ୍‍କେ ମେଣ୍ଡ୍‍ନ୍ ସହର୍ ତାଗ୍ ମିରାଟ୍ । ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ ଗଟ୍ ଇସ୍‌ କେତୁତାନ୍, ମିଡ଼୍ ଇଶ୍ରାୟେଲ୍ ତେ ସାରେ ସହର୍‍ତାଗ୍ ପାଡ଼୍‍ୟି ତେର୍‍ସ୍ପାନ୍ ମୁନେଙ୍କ୍ ନାରୁନ୍‍ପିଲେ ମାଲ୍‍ସ୍ ୱାଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ଶିଷ୍ୟଡ଼୍ ଗୁରୁନାଗା କଞ୍ଜ୍ ବେଡ଼ିୟନ୍ ଆୟ୍‍ୟଣ୍ଡ୍‍ । ମାଲିକ୍ ତାଗାଙ୍କ୍ ଚାକର୍ ବେଡ଼ିୟନ୍ ଆୟ୍‍ୟଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ଆଦିଙ୍କ୍ ଶିଷ୍ୟ ଗୁରୁନ୍‍ଲେକେମ୍ ନୁ ଚାକର୍ ମାଲିକ୍ ଲେକାମ୍ ଆଦ୍‍ପାର୍କେ ଅଡ଼୍‌ ଆସର୍‍ତେ ଶାନ୍ତି ଆଦାନ୍ ଦର୍‍କାର୍ । ୱେରଡ଼୍ ଲୋତ୍‍ତେ ମୁକିୟାଙ୍କ୍ ନାରୁଡ଼୍ ଯଦି ବାଲ୍‍ଜିବୁଲ୍‍ ହିଞ୍ଜ କେତିତଡ଼୍‍, ଲୋତ୍‍ତେ ମେଣ୍ଡେ ବାଗାତଡ଼୍‍କିଙ୍କ୍ ବେସର୍ ଅଦିକ୍‌ କେଲଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ଆଦିନ୍ ସେଙ୍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ୱେର୍‍ମାଟ୍ । ବାତ୍ ଇଞ୍ଜେ ମୁସିଆତ୍‍ତେ, ଆଦ୍ ତେର୍‍ସ୍‍ଆଦ୍‍ତେ ମେଣ୍ଡେ ସାରେ ମିଞ୍ଜିମାନ୍ଦାନ୍ ଗଟି ପେଇତିତା ।” ");
INSERT INTO kff_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ନାନ୍ ମିକିଂଙ୍କ୍ ବାତ୍ ଇକାଡ଼୍‌ତାଗ୍ କେସମିନ୍ଦେନ୍, ଆଦ୍ ୱେଇସ୍‍ତାଗ୍ କେତ୍‍ୱେଇତିତ୍ ମେଣ୍ଡେ ବାତ୍ ମିଞ୍ଜିମାଞ୍ଜ୍ କେଞ୍ଜ୍‍ତିଡ଼୍, ଆଦ୍ ଲୋତ୍‍ତେ ମୁର୍ସିନାଗାଙ୍କ୍‍ କେଲ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ବେନଡ଼୍ ମାତର୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ନଷ୍ଟ ମାଡ଼ିତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆତ୍ମାତିଙ୍କ୍ ବାତ୍ କ୍ଷତି ମାଡ଼େ ପାର୍‍ୱଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେର୍‍ମାଟ୍ । ବେଲାନ୍ ବେନ୍ ଇଶ୍ୱର୍ ମିଇ ମେନ୍ଦୁଲ୍ ନୁ ଆତ୍ମାତିଙ୍କ୍ ରେଣ୍ଡିଙ୍କ୍ ନର୍‍କତାଗ୍‍ ଦସଂ ମାଡ଼୍‍ପାର୍‍ଦ୍‍ତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ୱେର୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ଅଣ୍ଡୟ୍‌ ପାଇସା ଇସ୍‌ ରେଣ୍ଡ୍ ଆନାପିଟେ ଆସ୍ ପାର୍‍ଦ୍‍ତିନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍ ଇଶ୍ୱର୍‌ତେ ବିନା ଅନୁମତିତେ ଅଣ୍ଡୟ୍‌ ଆନାପିଟେ ନେଲ୍‍ ରାୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ହେର୍କା ମାଡ଼ାଟ୍, ମିଇ ତାଲେତ୍ କେଲ୍‍କ୍ ମିକା ଲେକାଆସ୍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ୱେର୍‍ମାଟ୍, ପିନା ଆନାପିଟେ ନାଗାଙ୍କ୍ ମିୟାଦ୍ ମୁଲ୍ୟ ଗାଟିନାର୍ଗେ । ");
INSERT INTO kff_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ବେନଆଇ ଗଟ୍‍ତେ ନାକିଂଙ୍କ୍ ପ୍ରବୁ ଇଞ୍ଜ ସ୍ୱୀକାର୍ ମାଡ଼ିତନ୍, ନା ସ୍ୱର୍ଗତଣ୍ଡ୍ ବାବାନ୍ ମୁନ୍‍ନେ ନାନ୍ ଅଂକିଙ୍କ୍‌ ନା ଶିଷ୍ୟ ଇଞ୍ଜ ସ୍ୱୀକାର୍ ମାଡ଼ିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନଆଇ ଗଟ୍‍ତେ ନାକିଂଙ୍କ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ିତନ୍, ଅଂକିଙ୍କ୍‌ ନାନ୍ ମିକା ନା ବାବାନ୍ ମୁନ୍‍ନେ ଅସ୍ୱୀକାର୍ ମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ନାନ୍ ଜଗତ୍‍ତାଗ୍ ଶାନ୍ତି ମାଡ଼ାଙ୍କ୍ ୱାତ୍‍ତାନ୍ ଇଞ୍ଜ ଏର୍କା ମାଡ଼୍‍ମାଟ୍ । ଇଲେ, ନାନ୍ ଶାନ୍ତି ପଇସ୍ ୱାଡ଼ନ୍, ତାଲ୍‍ୱାର୍ ପଇସ୍ ୱାତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ନା ମାଇଦିଙ୍କ୍ ମାର୍‍ ବାବାନ୍ ବିରଦ୍ଦ୍‌ ମାଡ଼ିତନ୍, ମାୟାଡ଼୍ ୟାୟାନ୍ ବିରୁଦ୍ ମାଡ଼ିତ୍ ମେଣ୍ଡେ ପୟେନ୍ ବିରୁଦ୍‍ତେ କଡ଼୍‍ୟାଡ଼୍ ତେଦିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ନିଜେତ୍ ପରିବାର୍‍ତେ ନାରୁଡ଼୍ ୱେରଙ୍କ୍ ସାରେତିଙ୍କ୍ ବେଡ଼୍‍ୟେ ଶତ୍ରୁଡ଼୍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ବେନଆଇ ନିଜେତ୍ ବାବାଙ୍କ୍ ବା ୟାୟାଙ୍କ୍ ନାକିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ଅଦିକ୍‌ ପ୍ରେମ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନା ଶିଷ୍ୟ ଆଦାନଙ୍କ୍ ଯୋଗ୍ୟ ଆୟ୍‍ୟଣ୍ଡ୍ । ବେନଆଇ ନିଜେତ୍ ମାର୍‍ ବା ମାୟାଡ଼୍‍ତିଙ୍କ୍ ଅଦିକ୍‌ ପ୍ରେମ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନା ଶିଷ୍ୟ ଆଦାନଙ୍କ୍ ଯୋଗ୍ୟ ଆୟ୍‍ୟଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ବେନଆଇ ନିଜେତ୍ କ୍ରୁଶ କାଞ୍ଜି ନାକିଂଙ୍କ୍ ଲେକାମ୍ ମାଡ଼ଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନା ଶିଷ୍ୟ ଆଦାନଙ୍କ୍ ଯୋଗ୍ୟ ଆୟ୍‍ୟଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ବେନଆଇ ନିଜେତ୍ ଜିୱୁନ୍‍ ରକ୍ଷା ମାଡ଼ାନଙ୍କ୍ ଆଲ୍‍ସି ମାତ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ଆଦ୍ ଆରା ମାଡ଼ିତନ୍; ବେଲାନ୍ ବେନ ନା ମାଇଦିଙ୍କ୍ ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍ ହିଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମୁନେଙ୍କ୍‍ତେ ଆଦ୍ ରକ୍ଷା ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ବେନ ମିକିଂଙ୍କ୍ କାର୍ଙ୍ଗିତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ନା ସେଙ୍ଗେ ଆଦ୍ ମାଡ଼ିତନ୍ ମେଣ୍ଡେ ବେନ ନାକିଂଙ୍କ୍ କାର୍ଙ୍ଗିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନା ୱାଦାନଡ଼୍ ସେଙ୍ଗେ ଆଦ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ବେନଆଇ ୱେରଣ୍ଡ୍ ବାବବାଦିଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ଦୂତ୍ ଲେକାମ୍ କାର୍ଙ୍ଗିତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ଆଦ୍ ବାବବାଦୀନ୍ ପୁରସ୍କାର୍‍ତାଗ୍ ତଡ଼୍ ଆଦ୍‍ତନ୍; ମେଣ୍ଡେ ବେନଆଇ ୱେରଣ୍ଡ୍ ଦାର୍ମିକ୍ ନାରୁଙ୍କ୍ ଅନ୍‌‍ୱାଦ୍ ସାଦୁତା ସେଙ୍ଗେ ସମ୍ବଦନ୍ ମାଡ଼ିତନ୍, ଆଦ୍ ନାରୁନ୍ ପୁରସ୍କାର୍‍ତାଗ୍ ଅଣ୍ଡ୍‌ ବାଗିଦାର୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ବେନଆଇ ନାରୁଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ସାରେତିଙ୍କ୍ ସୁଦୁନଣ୍ଡ୍ ଶିଷ୍ୟଙ୍କ୍ ଗିନେନ୍ କିଡ଼୍‍ଙ୍ଗ୍‍ତେ ଏର୍‍ ହିଦ୍‍ତଣ୍ଡ୍, ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ଅଣ୍ଡ୍‌ ନିଜାମ୍ ପୁରସ୍କାର୍ ପାଏମ୍ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜିସୁ ତାନ୍ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ସାରେ ଆଦେଶ୍‍କେସ୍ ତେର୍‍ସ୍ପାନ୍ ଆଦ୍ ସପେତେ ସହର୍‍ତାଗ୍ ଆଞ୍ଜ୍ ଶିକ୍ଷା ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ଆସୁଙ୍କ୍ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ଜଇଲ୍‍ତାଗ୍ ମାତ୍‍ତନ୍ । କ୍ରିଷ୍ଟ ବେନ୍‍ସାରେ ମାଡ଼ମାତ୍‍ତନ୍, ଆଦିନାଦ୍ କବର୍ ପୁଞ୍ଜ୍ ଅଣ୍ଡ୍‌ ନିଜେତ୍ ଇର୍‍ୱୁଡ଼୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ଜିସୁନ୍ ଗାର୍‍ରେ ରହତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ଅଡ଼୍‌ ଆଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ପାଚ୍‍ରିଞ୍ଚ୍‍ତଡ଼୍, “ବେନ୍ ନାରୁଡ଼୍ ୱାଦ୍‍ତନ୍ ଇଞ୍ଜ୍ ଯୋହନ୍‌ କେସ୍‍ମାତ୍‍ତନ୍, ନିମ୍‍ ଅଣ୍ଡେ କି ? ନା, ମାମ୍‍ମେ ମେଣ୍ଡ୍ଅର୍‍ତିଙ୍କ୍ କେପିତମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ମାଲ୍‍ସ୍ ଆନୁଟ୍ ବାତ୍‍ସାରେ ଉଡ଼ୁତିଡ଼୍ ନୁ କେଞ୍ଜୁତିଡ଼୍, ଆଦ୍ ଯୋହନ୍‌ ତିଙ୍କ୍ କେଲାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କାନାଲଡ଼୍ କଣ୍ଡା ଉଡ଼୍‌ତଡ଼୍, କୁଟାଲଡ଼୍ ତାକୁତଡ଼୍, କୁଷ୍ଠିରଗିଡ଼୍ ସୁସ୍ଥଆଦୁତଡ଼୍, ବାଇରା ଲଡ଼୍ କେଞ୍ଜୁତଡ଼୍, ଡଲ୍‍ତେ ନଡ଼୍ ମେଣ୍ଡନ୍ ଦାମ୍ ଜିୱୁନ୍ ଆଦୁତଡ଼୍‍ ନୁ ଦରିଦ୍ର ନାରିଡ଼ାଗ୍ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼ୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ମେଣ୍ଡେ ବେନେ ନାରୁଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍‌ ବାଦା ଆୟଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌‍ ଦନ୍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟଡ଼୍ ମାଲ୍‍ସ୍ ଆଦାନ୍ ୱେଲେ ଜିସୁ ନାରିଡ଼୍‍କିଙ୍କ୍ ଯୋହନ୍‌ ବିଷୟ୍‍ତେ କେତ୍‍ତନ୍, “ମିଡ଼୍ ଯୋହନ୍‌‌ତିଙ୍କ୍ ଉଡ଼ାନଙ୍କ୍ ବେସୁଙ୍କ୍‍ ଉଚ୍‍କ ଲେକେଦାଗ୍ ଆଞ୍ଜ୍‍ମାତ୍‍ତିଡ଼୍, ବାତ୍ ଉଡାଙ୍କ୍ ଆଶେମାଡ଼ି ମାତ୍‍ତିଡ଼୍ ? ଗାଲ୍‍ତଡ଼୍ ଉଙ୍ଗାନ୍ ଗାଡ୍‍ତିଙ୍କ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ବେନଙ୍କ୍ ଉଡାଙ୍କ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତିଡ଼୍ ? ସୁନ୍ଦର୍‍ତାଉ ଚକାସିଲେ କେର୍‍ସ୍ ମାନ୍ଦାନ୍ ୱେରନ୍ ନାରୁଙ୍କ୍ ? ଆଦ୍‍ଲେକାମ୍ ଚକାସିଲେ କେର୍‍ସ୍ ମାନ୍ଦାନଡ଼୍ ରାଜ୍‍ ପ୍ରସାଦ୍‍ତାଗ୍‍ ମାନ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ନାକିଂଙ୍କ୍ କେଲାଟ୍, ବାତ୍ ଉଡାଙ୍କ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତିଡ଼୍ । ୱେରନ୍ ବାବବାଦୀଙ୍କ୍ କି ? ଆଦ୍‍ତ ନିଜାମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବବାଦି ନାଗାଙ୍କ୍ ୱେରନ୍ ଅଦିକ୍‌ ମହାନ୍ ନାରୁଙ୍କ୍ ଉଡ଼୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ବେନନ୍ ବିଷୟ୍‍ ଇଦ୍‍ ଶାସ୍ତ୍ରତାଗ୍‍ ଲେକାମିନ୍ଦେ, “ଇଶ୍ୱର୍ କେତ୍‍ତାନ୍ ମିଇ ସେଙ୍ଗେ ଆର୍ ତିଆର୍ ମାଡ଼ାଙ୍କ୍ ନାନ୍ ମୁନେନ୍ ନା ଦୂତକିଙ୍କ୍ ରହତିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ମୁନେନ୍ କଞ୍ଜ୍ ନେଣ୍ଡ୍ ଆଇନା ଇଦ୍ ଜଗତ୍ ତାଗ୍ ବେସ୍‍ତୁଡ଼୍ ଜନମ୍ ଆଦ୍‍ତଡ଼୍, ଅଡ଼୍‌ ସାର୍‍ତଡ଼ା କଞ୍ଜ୍ ଯୋହନ୍‌ ମହାନ୍ ବା ଲେକେତ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ସ୍ୱର୍ଗରାଜ୍ୟତାଗ୍ ବେନ ସାର୍‍ତିଙ୍କ୍ ସୁଦୁନନ୍, ଅଣ୍ଡ୍‌ ଯୋହନ୍‌ ତାଗାଙ୍କ୍ ମହାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଯୋହନ୍‌ ତାନ୍ ଗଟ୍ ପ୍ରଚାର୍ ମାଡ଼ାନ୍‍ ଦିନ୍ କଞ୍ଜ୍ ନେଣ୍ଡ୍ ଆଇନା ସ୍ୱର୍ଗରାଜ୍ୟତ୍‌ ପରୁ ନାର୍ଗେ ଆକ୍ରମଣ ମାଡ଼ି ୱାଦୁତଡ଼୍ । ଚିଟିରମନ୍ ମାଡ଼ାନଡ଼୍‍ ଆଗେ ଶକ୍ତି ମାଡ଼ି ଅସାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଯୋହନ୍‌ ୱାଦାନ୍ ଦିନାଯାକ ମୋଶାନ୍‌ ବେବସ୍ଥା ନୁ ବାବବାଦୀଡ଼ାଦ୍ ଗଟ୍ ଆଦ୍ ରାଜ୍ୟ ବିଷୟ୍‍ତେ କେସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଯଦି ଅଡ଼ାଦ୍‌ ଗଟ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତିଡ଼୍, ଆଲେକେ ଯୋହନ୍‌ ଆଦୁତନ୍ ଏଲିୟ, ବେନ ମୁନେ ୱାଦାନାଦ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ବେନନାଦ୍ କେୱୁ ମିନ୍ଦେ, ଅଣ୍ଡ୍‌‍ କେଞ୍ଜାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ହିଦ୍ ଯୁଗ୍‍ତେ ନାରୁଡ଼୍‍କ୍‍ ବେନନ୍ ତଡ଼୍‍ ସାମାନ୍‍ ମାଡ଼ିତାନ୍ ? ଅଡ଼୍‌ ହାଟିନ୍ ନାଡ଼୍‍ମେ କୁଦି କାର୍‍ସାନ୍ ପିଲାନ୍ ଲେକେ । ୱେରଡ଼୍ ମାନ୍ଦେତ୍ ପେକଡ଼୍ ମେଣ୍ଡ୍‍ନ୍ ଦଲ୍‍ଦିଙ୍କ୍ କେତିତଡ଼୍‍,” ");
INSERT INTO kff_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ମାମ୍‍ମେ ପେଣ୍ଡୁଲ୍ ଡଓଲା ପେଞ୍ଜ୍‍ତମ୍, ଇତ୍‍କେ ମିଡ଼୍ ହେନ୍ଦ୍‍ୱିଡ଼୍ । ମାମ୍‍ମେ ଦୁଃକାମ୍ ପାଟ୍‍ ପାର୍‍ତମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ କେୟ୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଯୋହନ୍‌ ୱାସ୍ ଉପବାସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଅଣ୍ଡ୍‌ କାଲ୍ଉନ୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍ । ସାରେତଡ଼୍ କେତ୍‍ତଡ଼୍, “ଅଂକିଙ୍କ୍‌ ବୁତ୍ ପୟିତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ବେସୁଟ୍‌ ନାରୁନ୍‍ପିଲେ ୱାସ୍ କାଦି ତିନ୍ଦାନଙ୍କ୍ ମନା ମାଡ଼ଣ୍ଡ୍, ସାରେତଡ଼୍ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ନାରୁଙ୍କ୍ ଉଡ଼ାଟ୍ । ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ପେଟୁ ନୁ ମାତ୍‍ୱାରୀ, କରଆଦାୟ୍‍ ନଡ଼୍ ନୁ ସମାଜଚ୍ୟୁତ ନାରୁଡ଼୍‍ତେ ସାଙ୍ଗ । ଅଣ୍ଡ୍‌ ବାତ୍‍ଆଇ, ଇଶ୍ୱର୍‌ତେ ବିଚାର୍ ମାଡ଼୍‍ତେୱେଲେ, ଆଦ୍ ପୁନ୍ଦାଙ୍କ୍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ବେନ୍ ସହର୍‍କିନାଗ୍ ଜିସୁ ଅନ୍‌‍ୱାଦ୍ ନାର୍‍ଗେ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମାଡ଼ି ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପଡ଼ିୟେତ୍ ନାରୁଡ଼୍ ଅଡ଼ାଦ୍‌ ପାପ୍ ସେଙ୍ଗେ ହେର୍କେ ମାଡ଼୍‍ୱାଦ୍ ଉଡ଼ି, ଜିସୁ ଆଦ୍ ଶହର୍‍କିଙ୍କ୍ ପରିହାସ୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ହୋ କୋରାଜିନ୍, ମିଡ଼୍ ଦସଂ ଆଦ୍‍ତିଡ଼୍ ! ବେତ୍‍ସାଇଦା ମିଡ଼୍ ମିକା ଦସଂ ଆଦ୍‍ତିଡ଼୍ । ମିଇ ଲୋପେ ବେନ୍ ସାରେ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଡ଼୍, ଆୱୁସାରେ ଯଦି ସିଦୋନ୍ ନୁ ସୋରତାଗ୍ ମାଡ଼ିମାନେଡ଼୍, ଆଗେତ୍ ନାରୁଡ଼୍ ମେନ୍ଦୁଲ୍‍ତାଗ୍ ନିର୍ ଆକି ବାସ୍ତା କେର୍‍ସ୍ ଅନୁତାପ୍ ମାଡ଼େଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“ନାନ୍ ନିଜାମ୍‍ତେ କେତୁତାନ୍, ଇଶ୍ୱର୍ ବିଚାର୍ ମାଡ଼ାନ୍ ଦିନାତେ ମିକିଂଙ୍କ୍ ଅନ୍‌ ସୋର ନୁ ସିଦନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଦିକ୍‌ ଅନୁଗ୍ରହ ତଅତିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“କପର୍ନାହୁମ୍ ! ନିୟାଦ୍ ବାତ୍ ଦଷ୍ ଆଦ୍‍ତେ ! ନିମ୍‍ ବାତ୍ ନିଜେତିଙ୍କ୍ ସ୍ୱର୍ଗତାଗ୍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ୁତି ? ନିମ୍‍ ନର୍କତାଗ୍‍ ରାଲିତି । ମିଇ ଲୋପେ ବେନ୍ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଡ଼୍, ଆଦ୍ ଯଦି ସଦୋମ୍‍ତାଗ୍ ମାଡ଼ିମାନେଡ଼୍, ଆଦ୍ ନାର୍ ନେଣ୍ଡ୍ ଅନ୍‌‍ପାକେ ସାୟେ ମାନ୍‍ନେଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, “ଇଶ୍ୱର୍ ବିଚାର୍ ମାଡ଼ାନ୍ ଦିନାତେ ମିୟାଗ୍ କନ୍‍ସ୍ ସଦୋମ୍‍ତିଙ୍କ୍ ଅଦିକ୍‌ ଦୟା ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ଆସୁଟେ ଜିସୁ ପ୍ରାର୍ତନା ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ହଁ ବାବା, ସ୍ୱର୍ଗ ନୁ ପୃତିବିତ୍ ପ୍ରବୁ, ଇଦ୍ ସାରେ ଗଟ୍ ବୁଦ୍ଦିମାନ୍ ନୁ ଶିକିତ୍ ନାରୁଡ଼୍ ମିଞ୍ଜ୍‍ସ୍ପିମାଞ୍ଜ୍ କାର୍‍ୱେ ନାରୁଡ଼ାଗ୍ କେସ୍‍ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ନିକିଂଙ୍କ୍ ଦନ୍ୟବାଦ୍ ଇଦୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ହଁ ବାବା, ନିୟାଦ୍ ଇଚ୍ଛା ଲେକାମ୍ ଇଦ୍ ସାରେ ଗଟେମ୍ ଆଦୁତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ମା ବାବାଲ୍ ନାକିଂଙ୍କ୍ ସାରେ ଇସ୍‌ ମିନ୍ଦେଣ୍ଡ୍ । ବାବାଙ୍କ୍ ୱିଡ଼୍‍ସ୍‍କେ ମାର୍‍ରିଙ୍କ୍ ମେଣ୍ଡେ ବେନ ପୁନଣ୍ଡ୍ ମେଣ୍ଡେ ମାର୍‍ରିଙ୍କ୍ ୱିଡ଼୍‍ସ୍‍କେ ବାବାଙ୍କ୍ ମେଣ୍ଡେ ବେନ ପୁନଣ୍ଡ୍ । ମାର୍‍ ବେନ ଗାର୍‍ରେ ବାବାନ୍ ଗଟି କେତିତଣ୍ଡ୍, ମାତର୍ ଅଡ଼୍‌ ବାବାଙ୍କ୍ ପୁନ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ଗୁରୁ ଦାୟିତ୍ୱ କାଞ୍ଜି ଆୟିତ୍‍ତେ ନାରୁଡ଼୍, ନା ଗାର୍‍ରେ ୱାଡ଼ାଟ୍, ନାନ୍ ମିକିଂଙ୍କ୍ ରମାଙ୍କ୍ ହିଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ନାୱାଦ୍ ଜୁୱାଡ଼୍ କାଞ୍ଜି ନାୟାଗାଙ୍କ୍ ଶିକ୍ଷା ଆୟମୁଟ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନିଜେ ନମ୍ର ନୁ ସରଲ୍ ଆସ୍‍ମାନ୍ଦାଙ୍କ୍ ମିଡ଼୍ ନା ଗାର୍‍ରେ ରମିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ନାନ୍ ମିକିଂଙ୍କ୍ ବେନ୍ ଜୁୱାଡ଼୍ ହିଦ୍‍ତାନ୍ ଆଦ୍ କାଞ୍ଜାନଙ୍କ୍ ସହଜ୍ । ମେଣ୍ଡେ ବେନ୍ ଦାୟିତ୍ୱ ହିଦ୍‍ତାନ୍ ଆଦ୍ ମିକା ଗାଟି ହାଲ୍‍କା ।” ");
INSERT INTO kff_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ଇଦିନ୍ ବେସ୍‌କ୍ ଦିନାତ୍ ପେର୍କେ ୱେରଡ଼୍ ବିଶ୍ରାମ୍‍ଦିନ୍ ଜିସୁ ୱିତି ମାନ୍ଦାନ୍ ୱାୟେତାଲାନ୍ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ । ତାନ୍ ଶିଷ୍ୟନଡ଼୍‍କ୍ କାର୍‍ପୟିତାଙ୍କ୍ ଅଡ଼୍‌ ୱିତ୍‍ତାଗାଙ୍କ୍ କେଡ଼୍ ଦେହେସ୍ ତିନ୍ଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ପାରୂଶୀନଡ଼୍ ଆଦ୍ ଉଡ଼ି ନାରୁଡ଼୍‍କ୍ କେତ୍‍ତଡ଼୍, “ଉଡ଼ାଟ୍, ବିଶ୍ରାମ୍ ଦିନ୍ ମିଇ ଶିଷ୍ୟନଡ଼୍ ବେଦ୍‍ଲେକାମ୍ ଶାସ୍ତ୍ର ବିରୁଦ୍ଦ୍‌ତେ ପାଡ଼୍‍ୟି ମାଡ଼ୁତଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ କେତ୍‍ତନ୍, “ଅନ୍‌ ଦିନ୍ ଦାଉଦ୍ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ କାର୍‍ୱିନ୍‍ ମାନ୍ଦାନ୍‍ ୱେଲେ ଦାଉଦ୍‍ ବାତ୍ ବାତ୍‍ ମାଡ଼ି ମାତ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ଶାସ୍ତ୍ରତାଗ୍ କାର୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ଅଡ଼୍‌ ବେଲାନ୍ ଇଶ୍ୱର୍‌ତେ ମନ୍ଦିର୍ ତେ ଲୋପେ ଆଞ୍ଜ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍‍ ଇତ୍‍ତେ ରୂଟି ତିତ୍‍ତଡ଼୍ । ଶାସ୍ତ୍ର ଲେକାମ୍ ପୁରହିତ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ଆଉ ରୋଟି ତିନ୍ଦାନ୍ ସେଙ୍ଗେ ବେନନାଦ୍ ମେଣ୍ଡେ ଅଦିକାର୍‌ ଇଲ୍‍ୱେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ମିଡ଼୍ ବାତେଏ କାର୍‍ୱିଡ଼୍ ? ମୋଶାନ୍‌ ବେବସ୍ଥା ଲେକାମ୍ ପୁରହିତ୍‍ନଡ଼୍ ବିଶ୍ରାମ୍ ବାର୍‍ତେ ମନ୍ଦିର୍ ଲୋପେ ପୁରୋହିତ ନଡ଼୍ ବିଶ୍ରାମ୍‍ଦିନ୍ ନିୟମ୍ ବିରୁଦ୍ ମାଡ଼ମାତ୍‍କେ ମିକା ଆଦିନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌ ଦଷ୍ ପୁନ୍ଦାଙ୍କ୍ ଆୟ୍‍ୟଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ମନ୍ଦିର୍‍ତାଦ୍ ମହତ୍‍ ବିଷୟ ନେଣ୍ଡ୍ ଇଗେମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ଶାସ୍ତ୍ର କେତିତ୍‍, ‘ନାନ୍ ଦୟା, ବଲିଦାନ୍ ଆୟ୍‍ୟ,’ ଇଦ୍ ଗଟ୍ ତେ ଇତ୍‍କେ ଯଦି ବୁଜେମ୍ ଆଦ୍‍ତିଡ଼୍, ଇଡ଼୍ ଆଦେଶ୍‍ତେ ନାରୁଡ଼୍‍କ୍ ମିଡ଼୍ ଦଷ୍ ମାଡ଼୍‍ୱିଡ଼୍ ଆୟେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ପୁଞ୍ଜ୍ ମାନୁଟ୍, ନାରୁନ୍ ପିଲେ ସ୍ୱୟଂ ବିଶ୍ରାମ୍ ବାର୍‍ତେ ପ୍ରଭୁ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜିସୁ ଆଦ୍ ପଡ଼ିୟେ ତାଗାଙ୍କ୍ ଆଞ୍ଜ୍ ପ୍ରାର୍ତନା ଲୋନ୍‌ ଅସ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ୱେରନ୍ ୱାସ୍‍ତେ କାଇତେନଣ୍ଡ୍ ଆଗେ ମାତ୍‍ତଣ୍ଡ୍ । ଜିସୁନ୍ ଦଷ୍ ପୟିତାନ୍ ସେଙ୍ଗେ ମାନ୍ଦେ ନାରୁଡ଼୍ ଆଗେ କେପିମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, ବିଶ୍ରାମ୍ ଦିନ୍ ସୁସ୍ଥ ମାଡ଼ାନାଦ୍ ଶାସ୍ତ୍ର ବିରୁଦ୍ ଆୟ୍‍ୟ କି ? ");
INSERT INTO kff_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ଜିସୁ ଉତ୍ତର୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍‍, “ବିଶ୍ରାମ୍‍ଦିନ୍ ଯଦି ମିୟାଦ୍ ମେଣ୍ଢା ୱେରଡ଼୍ ଗୁଇନ୍ଦେତାଗ୍ ରାଲିତ୍, ମିଡ଼୍ ଆଦିଙ୍କ୍ ତେସ୍ ତାଡ଼୍‍ୱିଡ଼୍‍କି ? ");
INSERT INTO kff_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ୱେରନ୍ ନାରୁନ୍ ମୁଲ୍ୟ ୱେରଡ଼୍ ମେଣ୍ଢେତ୍ ମୁଲ୍ୟତ୍ ୱିଡ଼୍‍ସି ଗାଟି ଅଦିକ୍‌ । ଆଲେକେ ବିଶ୍ରାମ୍‍ଦିନ୍ ମେଣ୍ଡ୍ଅର୍‍ତିଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାନାଦ୍ ମାୟାଦ୍‌ ଶାସ୍ତ୍ରତାଗ୍ ପାଡ଼୍‍ୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ଆଦ୍ କେସ୍ ଅଣ୍ଡ୍‌ କାୟ୍ ୱାତିମାନ୍ଦାନ୍ ନାରୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, “କାୟ୍ ତିନାଙ୍କ୍ ମାଡ଼େ ।” ନାରୁନ୍ କାୟ୍ ତିନାଙ୍କ୍ ମାଡ଼ାନ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଦ୍ କାୟ୍ ମେଣ୍ଡନ୍ କାୟ୍ ଇନା ସୁସ୍ଥ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ତାନ୍‍ପେର୍କେ ପାରୂଶୀଡ଼୍ ଆଦ୍ ପଡ଼ିୟେତାଗାଙ୍କ୍ ପେଇସ୍ ଆଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ଆୱୁକାନ୍ ସେଙ୍ଗେ ଷଡ଼ଯନ୍ତ୍ର ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ତାନ୍ ବିରୁଦ୍ଦ୍‌ତେ ଆସମାନ୍ଦାନ୍ ଷଡ଼ଯନ୍ତ୍ର ଗଟ୍ କେଞ୍ଜି ଜିସୁ ଆଦ୍ ଟାଉନ୍‍ ୱିଡ଼୍‍ସି ମେଣ୍ଡନ୍ ପାକେ ଆତ୍‍ତନ୍ । ଇତ୍‍କେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌ ପେର୍କେ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ଜିସୁ ରୋଗି ନାରୁଡ଼୍‍କ୍ ସୁସ୍ଥ ମାଡ଼ମାତ୍‍ତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ତାନ୍ ବିଷୟ୍‍ତେ ବାଗାତଡ଼୍‍କିଙ୍କ୍ ବାତେଏ କେଲ୍‍ମାଟ୍ ଇଞ୍ଜ ଗଟ୍ ହିସମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ହିଦିନ୍ ତଡ଼୍ ବାବବାଦୀ ଯିଶାୟତେ ତଡ଼୍ ଇଶ୍ୱର୍ ବେନ୍‍ଗଟ୍ କେଞ୍ଜ୍‍ପିମାତ୍‍ତନ୍, ଆଦ୍ ସାରେ ଆତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ହିଣ୍ଡ୍ ନା ପ୍ରିୟ ଦାସ, ଅଂକିଙ୍କ୍‌ ନାନ୍ ପ୍ରେମ ମାଡ଼ୁତାନ୍, ଅନ୍‌ ସେଙ୍ଗେ ନାନ୍ ଶାନ୍ତି । ନାୱାଦ୍ ଆତ୍ମା ଅନ୍‌ ପରୁ ଡିଗିତ୍‍ତେ; ସାରେ ବିଜାତିନ୍ ଗାର୍‍ରେ ଅନ୍‌ ନା ନ୍ୟାୟ ବିଚାର୍ ଗଷନା ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ଅଣ୍ଡ୍‌ ରାମ୍‍କ୍ ଆୟନ୍ କି ମର୍‍ରେ ଆୟନ୍, ରୋଟ୍ ନାଡ଼୍‍ମେ ନିସ୍ ଗାଟିଲେଙ୍କ୍‍ଦେ ଗଟି କେଲ୍‍ଲନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ଦୁର୍ବଲ୍‍ମାନ୍ଦାନଡ଼୍‍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ କମଲ୍ ବ୍ୟବହାର୍ ମାଡ଼ିତନ୍ ନୁ ରୋଗ୍‍ତେ ମାନ୍ଦାନଡ଼୍‍କ୍ ଦୟା ମାଡ଼ିତନ୍ । ନ୍ୟାୟ ଶାନ୍ତି ଆଦାନ୍ ଯାକ ଅଣ୍ଡ୍‌ ଅନ୍‌ ସାଦନାକଞ୍ଚ୍ ତଡ଼୍‍ ଆୟନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ଅନ୍‌ ପର୍‍ର ସାରେ ଜାତିନ୍ ନାରୁଡ଼୍ ଆଶେ ୱାଟିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ତାନ୍ ପେର୍କେ ଅନ୍‌ ଦିନ୍ ନାରିଡ଼୍ ୱେରଙ୍କ୍ କାନାଙ୍କ୍ ନୁ କନ୍ଦାଙ୍କ୍ ତାତ୍‍ତଡ଼୍ । ଅଙ୍କ୍‍ ବୁତ୍‌ ପୟ୍‍ତାଙ୍କ୍ ଗଟି ତିର୍‍ୟାନଙ୍କ୍‍ ପାର୍ୱେମାତ୍‍ତନ୍ । ଜିସୁ ଅଂକିଙ୍କ୍‌ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଉଡ଼େପାର୍ତନ୍ ନୁ ତିର୍‍ୟାଙ୍କ୍‍ ପାର୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଜିସୁନ୍ ଆଦ୍ ପାଡ଼୍‍ୟି ଉଡ଼ି ନାରୁଡ଼୍ ବାକ୍‍ୱା ଆସ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ବାତେଏ ଆ ଦାଉଦ୍‍ ତେ ବଂଶତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ପାରୂଶୀଡ଼୍ ଆଦେକେଞ୍ଜି କେତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ପ୍ରେତପତି ବାଆଲ୍‍ଜିବୁଲ୍ ତାଗାଙ୍କ୍ ଶକ୍ତି ଦର୍‍ସ୍‍କି ବୁତ୍ ୱିର୍‍ସ୍‍ପୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ଅଡ଼୍‌ ବାତେଚିନ୍ତା ମାଡ଼ୁତଡ଼୍ ଜିସୁ ପୁଞ୍ଜ୍ କେତ୍‍ତନ୍, “ୱେରଡ଼୍ ଦେଶ୍‍ତେ ନାରୁଡ଼୍ ୱେରେ ମାନ୍ଦେତାଗ୍ ୱିରି ତାମ୍‍ତାମ୍ ଲୋପେ ଲଡ଼େମ୍ ଆତ୍‍କେ, ଆଦ୍ ଦେଶ୍ ଗାଟି ଦିନ୍ ସାୟେ ମାନ୍ଦେପାର୍‍ୱ । ବେନ୍‌ଆଇ ଟାଉନ୍‍ତାଗ୍‍ ବା ପରିବାର୍ ଲୋପେ ୱେରେ ମାନ୍ଦେ ଆସ୍ ରାମ୍‍କ୍ ଆତ୍‍କେ, ଅଡ଼୍‌ ଯାପେ ଦଂସ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଆଲେକେ, ଶୟ୍‍ତାନ୍‍ ରାଜ୍ୟତାଗ୍ ଯଦି ୱେରଡ଼୍ ମାନ୍ଦେ ମେଣ୍ଡ୍‍ନ୍ ମାନ୍ଦେତ୍ ବିରୁଦ୍ଦ୍‌ତେ ଲଡ଼େମ୍ ଆଦ୍‍ତେ, ପୁନ୍ଦାଙ୍କ୍ ଆଦ୍‍ତେ ଯେ ଆଦ୍ ଦୁଡ଼ା ବିକଣ୍ଡ ଆସ୍ ସାରେଦିନାମ୍ ସେଙ୍ଗେ ଦଂସ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ମିଡ଼୍ କେତୁତିଡ଼୍, ନାନ୍ ବାଆଲ୍‍ଜିବୁଲ୍ ଶକ୍ତିତେ ପ୍ରେତାତ୍ମାକିଂଙ୍କ୍ ୱିର୍‍ସ୍‍ପୁତାନ୍ । ଆଲେକେ ଆୱିଙ୍କ୍ ତଲାନ୍ ସେଙ୍ଗେ ମିଇ ଶିଷ୍ୟନଡ଼୍ ଇଦ୍ ପାଡ଼ିୟ୍‍ଦେନଡ଼୍ ମିଇ ଅବିଯଗ୍ ବୁସାଇଞ୍ଜ ପ୍ରମାନ୍ ଆଦୁତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ବୁତ୍ ୱିର୍‍ସ୍‍ପାନ୍ ଶକ୍ତି ନାନ୍ ବାଆଲ୍‍ଜିବୁଲ୍ ତାଗାଙ୍ଗ୍ ଦର୍‍ସ୍‌କନ୍‍ । ଇଶ୍ୱର୍‌ତେ ଆତ୍ମା ତାଗାଙ୍କ୍ ଆଦ୍ ନାନ୍ ଦର୍‍କ୍ସ୍‍ତାନ୍ । ହିଦିନ୍ ତଡ଼୍ ମେଣ୍ଡେ ୱେରଡ଼୍ ପ୍ରମାନ୍ ଆଦୁତ୍‍, ସ୍ୱର୍ଗରାଜ୍ୟ ମିଇ ପାକେ ୱାସ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ୱେରନ୍ ଶକ୍ତିମାନ୍ଦାନ୍ ନାରିଙ୍କ୍ ମୁନେଙ୍କ୍ ତୱେମାତ୍‍କେ, ବେନ ତାନ୍ ଲୋତାଗାଙ୍କ୍ ଜବର୍‍ଦସ୍ତ ନେଙ୍ଗି ତାନ୍ ସମ୍ପତି ୱିର୍‍ସ୍‍ପି ଅଦେପାର୍‍ୱନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ବେନ ନା ତଡ଼୍ ଇଲାଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ସାରେତିଙ୍କ୍ ନା ବିରୁଦ୍ଦ୍‌ତେ ମିନ୍ଦେନ୍ । ବେନ ନା ତଡ଼୍ କାହିଲି ଗୁଡ଼୍‍ପନ୍, ଅଣ୍ଡ୍‌ ବାସ୍ତବିକ ନା ବିରୁଦ୍ ମାଡ଼ୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ଆଲେକେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ନାରୁଡ଼୍ ଯେ ବାତ୍‍ଆଇ ପାପ୍ ମାଡ଼ିତନ୍ ବା ସାରେ ଗଟି କେଲିନ୍ ଆଦିନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ କ୍ଷମା ଇଦାଙ୍କ୍ ଆଦ୍‍ତେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯଦି ବେନ୍ ପବିତ୍ରଆତ୍ମା ବିରୁଦ୍ଦ୍‌ତେ ବାତେଏ କେତିତନ୍, ଅନାଦ୍‌ କ୍ଷମା ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ବେନ୍ ନାରୁନ୍‍ପିଲେ ବିରୁଦ୍ଦ୍‌ତେ ବାତେଏ ପାପ୍ ମାଡ଼୍‍କେ ବା କେତ୍‍କେ, ଅଂକିଙ୍କ୍‌ କ୍ଷମା ଦର୍‍କିତ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯେ ବେନ ପବିତ୍ରଆତ୍ମା ବିରୁଦ୍ଦ୍‌ତେ ବାତ୍ କେତିତନ୍, ଅଂକିଙ୍କ୍‌ ଇଞ୍ଜେ ବା ବବିଷ୍ୟତ୍‍ତେ ବେସୁଙ୍କ୍‍ ବା କ୍ଷମା ଦର୍‍କ । ");
INSERT INTO kff_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ଲେକେତ୍‍ କାୟା ଆଦାନ୍ ସେଙ୍ଗେ ମାଡ଼େ ଲେକାମ୍ ଆଦାନ୍ ଦର୍‍କାର୍ । ପିନ୍ଦଲାଉ ମାଡ଼େତାଗ୍ ପିନ୍ଦଲାଉ କାୟା ଆଦ୍‍ଦିତ୍‍ତା । ମାଡ଼େ ବେଦ୍‍ଲେକାମ୍, ତାନ୍ କାୟାନ୍ ତଡ଼୍ ପୁନ୍ଦାଙ୍କ୍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ଆରେ ତାଡ଼ାମ୍ ବଂଶତ୍‍ କପାତ୍‍ ନାରୁଡ଼ି ! ନିଜେ କପାମ୍ ଆସ୍ ମିଡ଼୍ ବାତେଏ ସାୟେ ଗଟ୍ କେତ୍‍ପାର୍‍ତିଡ଼୍ ? ହୃଦୟ୍‍ତେ ହେର୍କା ମକମ୍ ଇସ୍‌ ପେହିତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ୱେରନ୍ ଲେକେତ୍‍ ନାରୁନ୍ ଲେକାମ୍ ବର୍ତ୍ତି ଆସ୍‍ମାନ୍ଦାନ୍ ତାନ୍ ସାୟେତ୍ ବଣ୍ଡାର୍ ତାଗାଙ୍କ୍ ସାୟେତ୍ ଜିନିଷ୍ ପେସ୍‍ପିତଣ୍ଡ୍ । ୱେରନ୍ କାରାପ୍ ନାରୁନ୍ ତାନାଦ୍ କାରାପ୍ ଜିନିଷ୍‍ତେ ବର୍ତ୍ତି ଆସ୍‍ମାନ୍ଦାନ୍ କାରାପ୍ ବଣ୍ଡାର୍‍ତାଗାଙ୍କ୍ କାରାପ୍ ଜିନିଷ୍ ପେସ୍ପିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ମିଡ଼୍ କେସ୍‍ମାନ୍ଦାନ୍ ସାରେ ମୁଲ୍ୟ ଇଲ୍‍ୱେ ଗଟ୍ ସେଙ୍ଗେ ବିଚାର୍ ଦିନେତେ ମିକିଂଙ୍କ୍ ସାକ୍ଷି ହିଦାଙ୍କ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ମିଇ ଗଟ୍‍ତେ ସେଙ୍ଗେ ମିଡ଼୍ ବିଚାରିତ ଆସ୍ ନିର୍ଦୋଷ୍ ବା ଦଷି ଶାବ୍ୟସ୍ତ ଆଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ଅନ୍‌‍ଦିନେ ବେସ୍‍ତୁଡ଼୍ ପାରୂଶୀଡ଼୍ ନୁ ଦର୍ମଗୁରୁଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ଗୁରୁ, ନିୟାଦ୍ ୱେରଡ଼୍ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ଉଡ଼ାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ଜିସୁ ଆଶର୍ଯ୍ୟ ଲେକାମ୍ ମାଡ଼ି କେତ୍‍ତନ୍, ଇ ଯୁଗ୍‍ତେ ନାରୁଡ଼୍ ବେସର୍ ଦୁଷ୍ଟ ନୁ ଇଶ୍ୱର୍ ବିଶ୍ୱାସ୍ ଆୟନ୍ । ମିଡ଼୍ ନାକିଂଙ୍କ୍ ୱେରଡ଼୍ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ତୱାଙ୍କ୍ କେତୁତିଡ଼୍ ? ମାତର୍ ବାବବାଦୀ ଯୁନସ୍‍ତେ ଜିୱୁନ୍‍ତେ ଗଟେମ୍ ଆସ୍‍ମାନ୍ଦାନ୍ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି କେ ମିକିଂଙ୍କ୍ ତହସିଦ୍ ୱେହିତିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଯୂନସ୍ ବେଦ୍ ଲେକାମ୍ କିକେତ୍‍ ଡଙ୍କେତାଗ୍ ମୁଣ୍ଡ୍‍ଦିନା ନୁ ମୁଣ୍ଡ୍‍ନାର୍‍କା ମାତ୍‍ତନ୍, ଆଦେ ଲେକାମ୍ ନାରୁନ୍ ପିଲେ ମିକା ବୂମ୍‌ତେ ଲୋପେ ମୁଣ୍ଡ୍‍ଦିନା ନୁ ମୁଣ୍ଡ୍‍ନାର୍‍କା ମାନ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ବିଚାର୍ ଦିନ୍‍ ନିନିବୀତେ ନାରୁଡ଼୍ ମିଇ ବିରୁଦ୍ଦ୍‌ତେ ଅବିଯଗ୍ ମାଡ଼ାଙ୍କ୍ ନିଲ୍‍ଦ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯୁନସ୍‍ତେ ପ୍ରଚାର୍ କେଞ୍ଜି ଅଡ଼୍‌ ପାପ୍ ଆର୍ଦାଗା ମାଲ୍‍ସ୍ ୱାତ୍‍ତଡ଼୍ । ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଯୁନସ୍‍ତାଗାଙ୍କ୍ ବେଡ଼୍‍ୟଣ୍ଡ୍‍ ୱେରନ୍ ହିଗେ ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ବିଚାର୍ ଦିନେତେ ଶିବାର ନାଟାଡ଼୍ ମିୟାଦ୍ ଦଷ୍ ତଅତାନ୍‍ ସେଙ୍ଗେ ନିତିତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁଡ଼୍ ବୁଦ୍‍ତେ ଗଟ୍ କେଞ୍ଜାନ୍ ସେଙ୍ଗେ ପୃତିବିତେ ସାରେଏକାମ୍‍ତେ ୱାତ୍‍ତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍ ତେ କେତୁତାନ୍, ଶଲୋମନ୍‍ ତାଗାଙ୍କ୍ ମହୀୟାନ୍ ୱେରନ୍ ଇଗେ ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ନାରୁନ୍ ମେନ୍ଦୁଲ୍ ତାଗାଙ୍କ୍ ପେଇସ୍‌ ଆତ୍‍ତେ ପେର୍କେ ୱେରଡ଼୍ ପ୍ରେତ୍‍ ଆତ୍ମା ଉସ୍କ ନାର୍‍ତାଗେ ବିଚରନ୍ ମାଡ଼ି ମେଣ୍ଡନ୍ ପଡ଼ିୟେ ନେଲ୍ ମେହେକିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ଆଦ୍ ଦର୍‍କ୍‍ୱେ ମାତ୍‍କେ, ତାନ୍ ମୁନେତ୍ ଲୋତ୍‍ତା ମାଲ୍‍ସ୍ ଆଦାଙ୍କ୍ ଇଚ୍ଛାମାଡ଼ିତ୍ । ଯଦି ମାଲ୍‍ସ୍ ଆଞ୍ଜ୍ ଉଡ଼ିତ୍, ଆଦ୍ ଲୋନ୍‌ ଲେକେତ୍‍ ସପାସୁତରା ଆସ୍ ଆସାମେ ମିନ୍ଦେ, ");
INSERT INTO kff_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ଅନାଗ୍, ମେଣ୍ଡେ ଦୁଷ୍ଟ ସାତ୍‍ଟାନ୍ ପ୍ରେତତିଙ୍କ୍ ନିମନ୍ତ୍ରନ ମାଡ଼ିତାତିତ୍ ନୁ ଆୱ୍ ସାରେ ଆଦ୍ ଲୋନ୍‌ ମାନ୍‍ତା । ଇଦିନ୍‍ତଡ଼୍, ଆଦ୍ ବୁତ୍ ପୟିତ୍‍ତେ ନାରୁନ୍ ଶେଷ୍ ଦଷ୍ ମୁନେତ୍ ଦଷ୍‌ତାଗାଙ୍କ୍ ଗାଟି ଗଡ଼୍‍ବଡ଼୍‍ ଆଦ୍‍ତେ । ହିଦ୍ ଯୁଗ୍‍ତେ ଦୁଷ୍ଟ ନାରୁଡ଼୍ ହିଦ୍‍ଲେକାମ୍ ଗାଟି ତିପାଲ୍‍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜିସୁ ନାରୁଡ଼୍ ତଡ଼୍ ଗଟିଆଦାନ୍ ୱେଲେ ତାନ୍ ୟାୟ୍‍ ନୁ ଦାଦାଲଡ଼୍‍ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ହେଉସ୍ ଅଂକିଙ୍କ୍‌ କେତାନଙ୍କ୍ ବାଇଦେ କେପି ଅଂକିଙ୍କ୍‌ କାର୍‍ଙ୍ଗ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ୱେରନ୍ ନାରୁନ୍ ୱାସ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ଉଡ଼େ, ନି ୟାୟ୍‍ ନୁ ଦାଦାଲଡ଼୍‍ ନି ସେଙ୍ଗେ ବାଇଦେ କେପ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ଜିସୁ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍‍, “ବେନ ନା ୟାୟ୍‍ ନୁ ବେନ ନା ଦାଦାଲ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ଶିଷ୍ୟନଡ଼୍ ପାକେ କାୟ୍ ତଅସ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ହିଡ଼୍ ଆଦୁତଡ଼୍‍ ନା ୟାୟ୍‍ ନୁ ନା ଦାଦାଲଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ବେନ ଆୟି ନା ସ୍ୱର୍ଗତେ ବାବାନ୍ ଇଚ୍ଛା ଲେକାମ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନା ଦାଦାଲ୍, ନା ଏଲାଡ଼୍‍ ନୁ ନା ୟାୟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଆଦ୍ ଦିନ୍ ଜିସୁ ପେଇସ୍‌ ହିଲ୍‍କେ ଆଞ୍ଚିନା ଆତ୍‍ତନ୍ । ଆଗେ ଅଣ୍ଡ୍‌ ଶିକ୍ଷା ହିଦାନ୍ ସେଙ୍ଗେ କୁଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ଅନ୍‌ ତିଡ଼୍‍ପାକେ ହିସର୍ ନାରୁଡ଼୍ କୁଦ୍‍ତଡ଼୍ ଯେ ଅଣ୍ଡ୍‌ ୱେରଡ଼୍ ଓଡେତାଗ୍ ଆଞ୍ଜ୍ କୁଦ୍‍ତନ୍ । ନାରୁଡ଼୍ ହିଲ୍‍କେ ଆଞ୍ଚିନା ନିସ୍‍ମିକା ଅନ୍‌ ଗଟି କେଞ୍ଜ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ଅଣ୍ଡ୍‌ ୱେଷଡ଼୍ ହିନା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନାର୍‍ଗେ ଗଟି ଶିକ୍ଷା ହିତ୍‍ତନ୍ । ଅଣ୍ଡ୍‌ କେତ୍‍ତାନ୍, “ଅନ୍‌‍ଦାମ୍ ୱେରନ୍ ନାରୁନ୍ ୱିଜ୍ ୱିତାନଙ୍କ୍ ପେହିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ଅଣ୍ଡ୍‌ ୱାୟେତାଗ୍ ୱିଜ୍ ୱିତାନ୍ ୱେଲେ ବେସ୍‌କ୍ ପେଡ଼େକ୍ ଆର୍‍ଦାଗ୍ ଲାହିନ୍ ରାଲ୍‍ତାଙ୍କ୍ ପିଟେ ୱାସ୍ ଆୱିଙ୍କ୍ ତିଞ୍ଜ୍‍ଜିତା । ");
INSERT INTO kff_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ମେଣ୍ଡେ ବେସ୍‌କ୍ ପେଡ଼େକ୍ ଗାଟି ସୁଦୁଟ୍ ମାଣ୍ଡୁଲ୍ ମାନ୍ଦାନାଗ୍ ରାଲ୍‍ତା ସୁଦୁଟ୍ ପନ୍ଦି ମାନ୍‍ନାଙ୍କ୍ ୱାଞ୍ଜ୍‍ଜି ଯାପେ ମଡ଼୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆୱୁ ମାଡ଼ା ଲୋପେ ଆନ୍‌‍ୱାଙ୍କ୍ ପଡ଼ଦ୍ ହେଦ୍‍ତ୍‍ତେ ଆଉ ୱାସିଆତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ବେସ୍‌କ୍ ୱିଜ୍ କୟେନାଗ୍ ରାଲ୍‍ତା । ଆଉ କୟେମାଡ଼ାକ୍ ସାରେ ପେଡ଼େକିଙ୍କ୍ ଆଦ୍‍ପ୍ତା ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମେଣ୍ଡେ ବେଷ୍‍କ୍ ୱିଜ୍ ଲେକେତ୍‍ ବୁମ୍‌ତାଗା ରାଲି ମାଡ଼େ ଆସ୍ କାୟା ଆଦ୍‍ତେ । ବେସ୍‌କ୍ ଶହେଗୁନ୍, ବେସ୍‌କ୍ ଷାଟିଏ ଗୁନ୍ ନୁ ବେସ୍‌କ୍ ତିରିଶ୍ ଗୁନ୍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଜିସୁ ୱେଷଡ଼୍ ତେର୍‍ସ୍‍ପି କେତ୍‍ତାନ୍, “କେଞ୍ଜାନଙ୍କ୍ କେଉ ମାତ୍‍କେ କେଞ୍ଜାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ତାନ୍ ପେର୍କେ ଶିଷ୍ୟନଡ଼୍ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଡ଼୍, ନାରୁଡ଼୍‍କ୍ ଶିକ୍ଷା ହିଦାନ୍ ୱେଲେ ନିମ୍‍ ବାତ୍‍ତିଙ୍କ୍ ୱେଷଡ଼୍ ହିନା କେତୁତିନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜିସୁ ଉତ୍ତର୍ ଇତ୍‍ତନ୍, “ସ୍ୱର୍ଗରାଜ୍ୟତେ ରହସ୍ୟ ବୁଜେମ୍ ଆତ୍‍ତାଙ୍କ୍ ମିଡ଼୍ ବୁଦ୍‍ତେ ଦର୍‍ସ୍‍କି ମିନ୍ଦେଡ଼ି, ଅଡ଼୍‌ ଦର୍‍ସ୍କ୍‍କଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ବେନନାଦ୍ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ଅଦିକ୍‌ ହିଦ୍‍ତଡ଼୍ ନୁ ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ନାର୍‍ଗେ ଲାବ୍ ମାଡ଼ିତନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନନାଦ୍ ଇଲେ, ହୋ ନାଦ୍ ବାତ୍‍ମିନ୍ଦେ, ଆଦ୍‍ମିକା ଟେଣ୍ଡି ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ଆଦିନ୍‌ ସେଙ୍ଗେ, ଅଡ଼୍‌ ଉଡ଼ଡ଼୍ ମାନ୍‍ତଡ଼୍ ଇତ୍‍କେ ବାତେଏ ଉଡ଼େ ପାର୍‍ୱଡ଼୍ । ସାରେ ଗଟି କେଞ୍ଜିମାନ୍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାତେଏ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍; ଅଡ଼୍‌ ଯଦି ପ୍ରକୃତ୍‍ତେ ଉଡ଼େଡ଼୍‍ ନୁ ବୁଜେମ୍ ଆୟେଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ବାବବାଦି ଯିଶାଇୟନ୍ ବବିଷ୍ୟଦ୍ ବାଣି ଅଡ଼୍‌ ସେଙ୍ଗେ ପ୍ରଯୁଦ୍‌ୟ । ହି ନାରୁଡ଼୍ କେଞ୍ଜିକେଞ୍ଜି ବାତେଏ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍ । ଉଡ଼ି ମାନ୍‍ତଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ଉଡାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","କିନ୍ତୁ ଅଡ଼୍‌ ସ୍ଥୁଲ ବୁଦିଡ଼୍ । ଅଡ଼୍‌ କେୱୁକ୍‍ ବନ୍ଦ୍ ମାଡ଼ିତ୍‍ତଡ଼୍ ନୁ କୋଣ୍ଡା ପିଇସ୍ ମିନ୍ଦେ । ଆଲା ଆୟ୍‍ୱେ ମାତ୍‍କେ ଅଡ଼୍‌ ଉଡାଙ୍କ୍ ପାର୍‍ୱେଡ଼୍, ଅଡ଼ାୱୁ କେୱୁକ୍‍ କେଞ୍ଜାଙ୍କ୍‍ ପାର୍‍ୱେଡ଼୍‍, ନୁ ଅଡ଼୍‌‍ ବୁଜେମ୍‍ ଆଦାଙ୍କ୍‍ ପାର୍‍ୱେଡ଼୍‍, ଅଡ଼୍‌ ନା ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ଆନେଡ଼୍ ନୁ ଅଡ଼୍‌‍କ୍ ନାନ୍ ସୁସ୍ଥ ମାଡ଼ିୱେନ୍ ହିଦ୍ ଗଟ୍ ଇଶ୍ୱର୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ମିଡ଼୍ ବେସର୍ ବାଗ୍ୟବାନ୍ ! ମିଡ଼୍ ଉଡ଼େ ପାର୍‍ଦୁତିଡ଼୍ ନୁ କେଞ୍ଜ୍‍ ପାର୍‍ଦୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ହିଦ୍ ଗଟ୍ ନିଜାମ୍‍ତେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ନାର୍‍ଗେ ବାବବାଦୀ ନୁ ଦାର୍ମିକ୍ ନାରୁଡ଼୍, ମିଡ଼୍ ବାତେଏ ଉଡ଼ୁତିଡ଼୍; ଆଦ୍ ଉଡ଼ାନଙ୍କ୍; ନୁ ବାତ୍ କେଞ୍ଜୁତିଡ଼୍ ଆଦ୍ କେଞ୍ଜାନ୍ ସେଙ୍ଗେ ଇଚ୍ଛା ମାଡ଼ ମାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ପାର୍‍ୱଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ଆଲେକେ ୱିଜେୱିତାନ୍ ୱେଷଡ଼୍‍ କେଞ୍ଜାଟ୍ କେତୁତାନ୍, ବୁଜେମ୍ ଆତ୍‍ତାଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ବେନଡ଼୍ ସ୍ୱର୍ଗରାଜ୍ୟତେ ଗଟ୍ କେଞ୍ଜିତଡ଼୍, ଅଡ଼୍‌ ହୃଦୟତାଗାଙ୍କ୍ ଶୟ୍‍ତାନ୍‍ ଆଦ୍ ଟେଣ୍ଡି ଆଦ୍‍ତେ । ଆର୍‍ଦାଗ୍ ରାଲିମାନ୍ଦାନ୍ ୱିଜ୍ ଆତ୍‍ତେ ଇଦିନ୍ ତାତ୍ପର୍ଯ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ବେନଡ଼୍ ଗଟ୍ କେଞ୍ଜାନ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଗ୍ରହତେ ଗ୍ରହନ୍ ମାଡ଼ିତଡ଼୍, ଆଦ୍‌ ପତୁରିଆ ପଡ଼ିୟେତାଗ୍ ରାଲିମାନ୍ଦାନ୍ ୱିଜେଲେକାମ୍, ");
INSERT INTO kff_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ଅଡ଼୍‌ ମାନ୍‍ଦେ ଲୋପେ ଆଞ୍ଜ୍ ମାନ୍‍ୱାଙ୍କ୍ ଅଡ଼୍‌ ଆଦିଙ୍କ୍ ନାର୍ଗେସମୟ୍‍ ପଇସ୍‌ ନେହେତେ ପାର୍‍ୱଡ଼୍ । ହିଦ୍ ଗଟ୍ ସେଙ୍ଗେ ବେସୁଙ୍କ୍‍ କଷ୍ଟ ନୁ ତାଡ଼ନା ୱାଦ୍‍ତେ, ଅଡ଼୍‌ ଆଦିଙ୍କ୍ ଯାପେ ୱିଡ଼୍‍ସିତ୍‍ ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","କୟେ ମାଡ଼ାକ୍ ବେଦ୍‍ଲେକାମ୍ ବେସ୍‍କିଙ୍କ୍ ୱିଜେତିଙ୍କ୍ ଆଦ୍‍ପ୍ତା ମାଡ଼ିଦ୍‍ତେ, ଆଦେଲେକାମ୍ ହିଦ୍ ଜଗତ୍‍ତେ ଜଞ୍ଜାଲ ନୁ ଦନ୍ ସମ୍ପତିତ୍‍ତେ ଆଶେ ବେସ୍‌କ୍ ନାରୁଡ଼ାଗ୍ ହେଉସ୍ ମାନ୍ଦାନ୍ ଗଟ୍‍ତିଙ୍କ୍ ନଷ୍ଟ ମାଡ଼ିଦ୍‍ତେ ନୁ ଅଡ଼୍‌ ବାତେଏ ସୁପଲ୍ ଦର୍‍ସ୍‍କେ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ବେନଡ଼୍ ଗଟ୍ କେଞ୍ଜି ବୁଜେମ୍ ଆଦ୍‍ତଡ଼୍, ଲେକେତ୍‍ ୱାୟେତାଗ୍ ରାଲିମାନ୍ଦାନ୍ ୱିଜ୍ ଲେକାମ୍ ଆଦିନ୍ ଲେକାମ୍ ସୁପଲ୍ ଲାବ୍ ମାଡ଼ିତଡ଼୍ । ବେନଙ୍କ୍ ଦର୍‍କିତ୍ ଶହେ ଗୁନ୍, ବେନ ଷାଟିଏ ଗୁନ୍ ନୁ ବେନ୍ ତିରିଶ୍ ଗୁନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଜିସୁ ମେଣ୍ଡନ୍ ୱେଷଡ଼୍ ଗଟ୍ କେତ୍‍ତାନ୍, “ସ୍ୱର୍ଗରାଜ୍ୟ ହିଦ୍‍ଲେକାମ୍, ୱେରନ୍ ନାରୁନ୍ ଅନ୍‌ ୱାୟେତାଗ୍ ଲେକାମ୍ ଗହମ୍ ୱିଜ୍ ୱିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ଅନ୍‌‍ଦିନେ ହିକାଡ଼୍‍ତେ ଅଡ଼୍‌ ଉଞ୍ଜି ମାନ୍ଦାନ୍ ୱେଲେ ୱେରନ୍ ଶତ୍ରୁଡ଼୍ ୱାସ୍ ଆଦ୍ ୱାୟେତାଗ୍ ନାର୍‍ଗେ ବାଲୁଙ୍ଗା ପେଡ଼େକ୍ ୱିତ୍‍ତିସ୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ବେସୁଙ୍କ୍‍ ମାଡ଼ାକ୍‍ସାରେ ପେର୍‍ସି କେଡ଼୍ ପେହିତା, ନାଡ଼୍‍ମେ ନାଡ଼୍‍ମେ ବାଲୁଙ୍ଗା ତଅନ୍‌ଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ଆଦ୍ ନାରିନ୍ ଚାକରିଡ଼୍ ୱାସ୍ କେତ୍‍ତଡ଼୍, ଗଟ୍, ନିମ୍‍ ତ ୱାୟାନାଗ୍ ସାୟେତ୍ ପେଡ଼େକ୍ ୱିତିମାତ୍‍ତିନ୍, ବାଲୁଙ୍ଗା ସାରେ ବେକାଙ୍କ୍ ୱାତ୍‍ତା ? ");
INSERT INTO kff_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ୱାୟେତ୍‍ ମାଲିକ୍ କେତ୍‍ତାନ୍, ‘ୱେରନ୍ ଶତ୍ରୁଡ଼୍ ଇଲାମାଡ଼୍‍ତନ୍ ।’ ମେଣ୍ଡେ ଦାସଡ଼୍‍ କେତ୍‍ତଡ଼୍, ‘ଆଲେକେ ମାମ୍‍ମେ ଆଞ୍ଜ୍ ଆୱିଙ୍କ୍ ତାହାକିଦ୍‍ତମ୍ ?’ ");
INSERT INTO kff_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ମାଲିକ୍ କେତ୍‍ତାନ୍, ‘ଇଲା, ବାଲୁଙ୍ଗା ତାହାକାନ୍ ୱେଲେ ଆଲେତ ଗହମ୍ ପଦ୍‍ଲେ ହେଲିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ବେଡ଼ିଇ ହାଇନା ଗହମ୍ ନୁ ବାଲୁଙ୍ଗା ୱେରଡ଼୍ ତାଗ୍ ପେର୍‍ସି । ଆସୁଙ୍କ୍ କଇଦାନଡ଼୍ କେତିକା, ଅଡ଼୍‌ ମୁନେ ବାଲୁଙ୍ଗା କଇସ୍, ମୁଟା ତହସ୍ ପୋଡ଼୍‍ସିଦ୍‍ତଡ଼୍ । ତାନ୍ ପେର୍କେ ଗହମ୍ ପାଣ୍ଡ୍‌ସ୍ପି ମିକା ଆଟୁତାଗ୍ ୱାଟିତଡ଼୍ ।’” ");
INSERT INTO kff_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜିସୁ ୱେରଡ଼୍ ୱେଷଡ଼୍ ଇସ୍‌ କେତ୍‍ତାନ୍, “ୱେରନ୍ ନାରୁନ୍ ଅନ୍‌ ୱାୟେତାଗ୍ ସୋରିଷ ପେଡ଼େମ୍ ଲେକାମ୍ ୱେରଡ଼୍ ପେଡ଼େମ୍ ମିଚ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ଆଦ୍ ପେଡ଼େମ୍ ସାର୍‍ରେ ତାଗାଙ୍କ୍ ଇସୁର୍ ଆତ୍‍ତେ ମିକା ଆଗାଙ୍କ୍ ବେନ୍ ମାଡ଼େ ଆତ୍‍ତେ, ୱାୟେତାଗ୍ ବାଗାତାଉ ସାରେ ମାଡ଼ାକ୍ ୱିଡ଼୍‍ସି ଗାଟି ଡେଙ୍ଗ୍ ନୁ ମାନ୍ଦେଆତ୍‍ ନୁ ତାନ୍ ପର୍‍ର ପିଟେ ତୁଉକା ତାର୍ତ୍‍ତା । ସ୍ୱର୍ଗରାଜ୍ୟତେ ପେର୍‍ସାନାଦ୍ ଇଦ୍‍ଲେକାମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ମେଣ୍ଡ୍‍ନ୍ ଦାମ୍ ଜିସୁ ଉଦାରନ୍ ଇସ୍‌ କେତ୍‍ତାନ୍, “ୱେରଡ଼୍ ନାଟାଡ଼୍ ସୁଦୁଟ୍ କମିର୍ ଆସ୍ ଦୁଡ଼୍‍ବାସ୍ତା ନିଇସ୍‌ ମହିଦାତାଗ୍ କାଲ୍‍ପ୍‍ତନ୍ । ଟିକ୍ ସମୟ୍‍ତେ ସାରେ ମହିଦା ତାଲିତାଗ୍ କାହିଲି ତୟ୍‍ତେ । ସ୍ୱର୍ଗରାଜ୍ୟ ହିଦ୍‍ଲେକାମ୍ ନାର୍ଗେ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଜିସୁ ଇଦ୍‍ଲେକାମ୍ ୱେଷଡ଼୍ ଇସ୍‌ ଶିକ୍ଷା ହିସମାତ୍‍ତନ୍ । ୱେଷଡ଼୍ ହିୱକଟ୍ ଅଣ୍ଡ୍‌ ବେନେମିକା ଶିକ୍ଷା ହିୱେମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଇଦିନ୍ ତଡ଼୍ ବାବବାଦୀନଡ଼୍ ହିଦ୍ ବବିଷ୍ୟତ୍‍ବାଣି ସାରେ ଆତ୍‍ତେ । “ନାନ୍ ୱେଷଡ଼୍ ଲେକାମ୍ ଅଡ଼୍‌‍ତଡ଼୍ ଗଟି ତିର୍ରିତାନ୍ । ତିଆର୍ ମୁନେଙ୍କ୍ ପୁନ୍‍ୱେମାନ୍ଦାନ୍ ସାରେ ଗଟି ହିଦ୍‍ଲେକାମ୍ ନାନ୍ ଅଡ଼୍‌‍କ୍ ବୁଜାମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ନାରୁଡ଼୍ ଗଓଲିତାଗାଙ୍କ୍ ପେଇସ୍‌ ୱାସ୍ ଜିସୁ ବେସୁଙ୍କ୍‍ ଲୋନ୍‌ ଲୋପେ ଆତ୍‍ତନ୍, ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ୱାସ୍ ପଚାର୍‍ମାଡ଼୍‍ତଡ଼୍, “ବାଲୁଙ୍ଗା ୱେଷଡ଼୍ ଇତ୍‍କେ ମାକିଂଙ୍କ୍ ବୁଜାମାଡ଼ିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତନ୍, “ବେନ୍ ନାରୁନ୍ ଲେକେତ୍‍ ୱିଜ୍ ୱିତ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ନାରୁନ୍ ପିଲେ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ହିଦ୍ ଜଗତ୍ ଆଦୁତ୍‍ତେ ୱାୟେ । ବେନଡ଼୍ ସ୍ୱର୍ଗରାଜ୍ୟ ଆଦିବାସିଡ଼୍, ଅଡ଼୍‌ ଲେକେତ୍‍ ୱିଜ୍ । ବାଲୁଙ୍ଗା ଆଦ୍‍ତେ ଶୟତାନ୍‍ତାଦ୍ ଉଡ଼ାନାଦ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ବେନ୍ ଶତ୍ରୁଡ଼୍ ବାଲୁଙ୍ଗା ୱିତ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ଶୟ୍‍ତାନ୍‍ । ପାଣ୍ଡାନ୍‌ ଦିନାମ୍ ଆଦୁତ୍‍ତେ ତେରାନ୍‌ ଦିନ୍‌ । ଶସ୍ୟକହିଦାନଡ଼୍ ଆଦୁତ୍‍ତେ ଦୂତ । ");
INSERT INTO kff_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ବାଲୁଙ୍ଗା ବେଦ୍‍ଲେକାମ୍ କଇସ୍ କାର୍‍ୱିମାନ୍ତା, ଯୁଗାନ୍ତ କାଲ୍ ଆଦେଲେକାମ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ନାରୁନ୍ ପିଲେ ତାନ୍ ରାଜ୍ୟତାଗାଙ୍କ୍ ସାରେ ଅପରାଦ୍‌ ପାଡ଼ିୟିଦେ ନଡ଼୍‍କ୍ ନୁ ବେନଡ଼୍ ବାଗାତଡ଼୍‍କ୍ ପାପ୍ ମାଡ଼ାଙ୍କ୍ କେତିତଡ଼୍‍, ଅଡ଼୍‌‍କ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଦୂତକିଙ୍କ୍ ରହତିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ଅଡ଼୍‌ ହି ସାରେତଡ଼୍‍କ୍ ନିଡ଼୍‍ତାନାଦ୍ କିସ୍‍ତାଗ୍ ହେସିତଡ଼୍ । ଆଗେ ଇ ନାରୁଡ଼୍ କେଇତଡ଼୍ ନୁ ତିପାଲ୍‍ତେ ଆଗେ ପାଲ୍‍କ୍ କିଟ୍ରୁମ୍ କାଟ୍ରୁମ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ଆଦ୍ ସମୟ୍‍ତେ ଦାର୍ମିକ୍ ନାରୁଡ଼୍‍ ସ୍ୱର୍ଗରାଜ୍ୟତାଗ୍ ପଡ଼ଦ୍‍ଲେକାମ୍ ୱେଇସ୍ ଆଦ୍‍ତଡ଼୍ । କେଞ୍ଜାନଙ୍କ୍ ଇଚ୍ଛା ମାତ୍‍କେ କେୱୁଇସ୍ କେଞ୍ଜାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ଅନ୍‌ ଦିନ୍ ୱେରନ୍ ନାରୁନ୍ ୱାୟେତାଗ୍ ଡେୱ ଡେୱ ମିଶିମାନ୍ଦାନ୍ ଦନ୍ ଦର୍‍କ୍‍ତେ । ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ମୁଚିୱାଟ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ୱେଡ଼୍‍କେତେ ନିଜେତ୍ ସାରେ ସମ୍ପତି ୱାମି ମିକା ଆଦ୍ ୱାୟେତିଙ୍କ୍ ଆଶ୍‍ତନ୍ । ସ୍ୱର୍ଗରାଜ୍ୟ ହିଦ୍ ମିଶିତାଦ୍ ଦନ୍ ଲେକାମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ୱେରନ୍ ବେପାରି ସାୟେତ୍ ମୁକ୍ତାତିଙ୍କ୍ ମେହେକ ମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ୱେରଡ଼୍ ଗାଟି ମୁଲ୍ୟତାଦ୍ ମୁକ୍ତାତାଦ୍ ସନ୍ଦାନ୍ ଦର୍‍ସ୍‍କି ଅଣ୍ଡ୍‌ ହୋନାଉ ସାରେ ସମ୍ପତି ୱାମିମିକା ଆଦିଙ୍କ୍ ଆଶ୍‍ତନ୍ । ସ୍ୱର୍ଗରାଜ୍ୟ ଆଦ୍ ମୁକ୍ତା ଲେକାମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ସ୍ୱର୍ଗରାଜ୍ୟ ୱେରଡ଼୍ କିକେପହିତାନ୍ ତଲ୍‌କେ ଲେକାମ୍ । କିକେ ପୟ୍‍ତାନଡ଼୍ ଇଲ୍‍କେତାଗ୍ ୱାଲାୱାଟି ବାତ୍ ବାତ୍ କିକେ ପହିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ୱାଲେ ନିଣ୍ଡ୍‍କେ ଆଞ୍ଚିନା ଲାଗିତାସ୍ ଲେକେ ଲେକାମ୍ କିକେ ହେଞ୍ଚି ଜୁଡ଼ିନାଗ୍ ୱାଟିତଡ଼୍ ନୁ ଅଜାତିଆ କିକେ ହେସ୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଯୁଗାନ୍ତ ସମୟ୍‍ତେ ହିଦ୍‍ଲେକାମ୍ ଆଦ୍‍ତେ । ଦୂତକି ଦାର୍ମିକ୍ ନାରୁଡ଼ାଗାଙ୍କ୍ ପାପିନଡ଼୍‍କ୍ ୱେରେ ମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନିଡ଼୍‍ତାନାଦ୍ କିସ୍‍ତାଗ୍ ହେସ୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ଆଗେ ଅଡ଼୍‌ କେୟାନ୍ ଲେକାମ୍ ଆସ୍ ତିପାଲ୍‍ତେ ପାଲ୍‍କ୍ କିଟ୍ରୁମ୍ କାଟ୍ରୁମ୍ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜିସୁ ଶିଷ୍ୟନଡ଼୍‍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ହିଉସାରେ ବିଷୟ ବୁଜେମ୍ ଆଦୁତିଡ଼୍ ?” ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ହୋ ପ୍ରବୁ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତାନ୍, “ବେଦ୍‍ଲେକାମ୍ ୱେରନ୍ ଲନ୍‍ମାଲିକ୍ ତାନାଦ୍ ବଣ୍ଡାର୍ ଲୋନ୍‌‍ତାଗାଙ୍କ୍ ବାତ୍‍ତେ ଇଲ୍‍ୱେ ଲେକାମ୍ ପୁନେଲାୱ୍ ନୁ ପାହାନ୍ତାଲାୱ୍ ନିୟ୍ ପେସ୍‍ପିତଣ୍ଡ୍, ସ୍ୱର୍ଗରାଜ୍ୟ ସେଙ୍ଗେ ତାଲିମ୍ ଆସ୍‍ମାନ୍ଦାନ୍ ୱେରନ୍ ଦର୍ମଗୁରୁ ଟିକ୍ ଆଦେଲେକାମ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ହିଉସାରେ ୱେଷଡ଼୍ କେସ୍ ତେର୍‍ସ୍ପାନ୍ ପେର୍‍କେ ଜିସୁ ନିଜେ ମାନ୍ଦାନ୍ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଆଗେତ୍ ପ୍ରାର୍ତନାଲୋନ୍‌ ଅନ୍‌ ଶିକ୍ଷା କେଞ୍ଜି ନାରୁଡ଼୍ ବାକ୍‍ୱା ଆସ୍ କେତ୍‍ତଡ଼୍, “ହିସର୍ ବୁଦ୍‍ତେ ଅଣ୍ଡ୍‌ ବେଗେ ଦର୍‍ସ୍କ୍‍ତନ୍ ? ହିଉସାରେ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମାଡ଼ାନଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ବେନ ଶକ୍ତି ହିତ୍‍ତନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ହିଦ୍ ବାତେଏ ଅଣ୍ଡ୍‌ ବଡ଼େଇ ତେ ମାର୍‍ ଆୟନ୍ ? ମରୀୟମ୍‍ ବାତ୍ ତାମ୍ ୟାୟ୍‍ ଆୟ୍‍ୟ ? ଯାକୁବ୍, ଯୋସେପ୍, ଶିମୋନ୍ ନୁ ଯିହୁଦା ବାତେଏ ତାନ୍ ତାମୁଣ୍ଡ୍‌ ଆୟନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ତାନ୍ ଏଲାଡ଼୍‍ ବାତେଏ ଇଗେ ଇଲା ? ହିଉସାରେ ଶକ୍ତି ଅଂକିଙ୍କ୍‌ ବେଗେ ଦର୍‍କ୍‍ତେ ?” ");
INSERT INTO kff_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ହିଦ୍ କେସ୍ ଜିସୁଙ୍କ୍ କେପ୍‍ତଡ଼୍ । ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତାନ୍, “ୱେରନ୍ ବାବବାଦୀ ନିଜେତ୍ ପରିବାର୍ ନୁ ନାର୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ସାରେତାଗ୍ ତନ୍ଦିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଅବିଶ୍ୱାସୀ ଆଇନାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଆଗେ ଅନାହୁ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମେଣ୍ଡେ ଅଦିକ୍‌ ମାଡ଼ନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ଆଦ୍ ସମୟ୍‍ତେ ଗାଲିଲୀତେ ଶାସକ ହେରଦ୍ ଜିସୁନ୍ ବିଷୟ୍‍ତେ କେଞ୍ଜ୍‍ତନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ଅଣ୍ଡ୍‌ ତାନ୍ ଚାକରିଡ଼୍‍କ୍ କେତ୍‍ତାନ୍, “ହିଣ୍ଡ୍ ନିଜାମ୍ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌, ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଜନମ୍ ଆସ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତନ୍ । ଅଦିନ୍‌ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମାଡ଼ାନଙ୍କ୍ ଶକ୍ତି ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ଇଦିନ୍ ମୁନେଙ୍କ୍ ହେରଦ୍ ଯୋହନ୍‌‌ତିଙ୍କ୍ ଗିରାପ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ କେସ୍‍ମାତ୍‍ତନ୍ ନୁ ଅଂକିଙ୍କ୍‌ ହିକ୍‍ଲେତଡ଼୍ ତହସ୍ ତାନାତାଗ୍ ନେହେସ୍ ମାତ୍‍ତନ୍ । ତାନ୍ ତାମୁଣ୍ଡ୍‌ ପିଲିପ୍ ତେ ମୁତ୍‍ତେ ହେରଦିଆତ୍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ହିଦ୍‍ଲେକାମ୍ ମାଡ଼ିମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ବାପ୍ତିଜିକ ଯୋହନ୍‌ ଅଂକିଙ୍କ୍‌ କେସ୍‍ମାତ୍‍ତନ୍, “ହେରଦିଆତିଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ମାଡ଼୍‍ତାଦ୍ ନିୟାଦ୍ ଟିକ୍ ନିୟମ୍‍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଆଦିନ୍ ସେଙ୍ଗେ ହେରଦ୍ ଯୋହନ୍‌‌ତିଙ୍କ୍ ହାଉକାନ୍ ସେଙ୍ଗେ ଆଲ୍‍ସି ମାତ୍‍ତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇହୁଦୀ ନାରୁଡ଼୍‍କ୍ ଅଣ୍ଡ୍‌ ୱେର୍‍ସ ମାତ୍‍ତନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଯୋହନ୍‌ ୱେରନ୍ ବାବବାଦୀ ଇଞ୍ଜ୍ ହେର୍କ ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ହେରୋଦ୍‍ତେ ଜନମ୍‍ଦିନେ ହେରୋଦିଆତେ ମାୟାଡ଼୍ ଅତିତିଡ଼୍‍ ମୁନେ ଏକ୍‍ସନ୍ ମାଡ଼ିମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ଆଦିନ୍ ପର୍‍ର ପ୍ରୀତ ଆସ୍ ହେରୋଦ୍ ପ୍ରତିଜ୍ଞା ମାଡ଼ି କେତ୍‍ତାନ୍, “ନାନ୍ ଶପତ୍ ମାଡ଼ିକେତୁତାନ୍, ନିମ୍‍ ବାତ୍ ତାଲ୍‍କିତିନ୍, ନାନେନିକ୍ ଇଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ତାନ୍ ୟାୟାନ୍ ମନ୍ତ୍ରନା ଲେକାମ୍ ପିକିଡ଼୍ କେତ୍‍ତେ, “ବାପ୍ତିଜିକ ଯୋହନ୍‌ ତେ ତାଲ୍‍ଲେ ହିଞ୍ଜେ ୱେରଡ଼୍ ତାଲିତାଗ୍ ୱାଟି ନାକିଂଙ୍କ୍ ଇମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଆଦେକେଞ୍ଜି ରାଜାଲ୍ ଦୁଃକାମ୍ ଆତ୍‍ତନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ସାରେତଡ଼୍ ମୁନେ ପ୍ରତିଜ୍ଞା ମାଡ଼ିମାନ୍‍ନାଙ୍କ୍ ପିକ୍‍ତେ ଗଟ୍ ସାରେ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ଆଦିଙ୍କ୍ ତାନାତାଗ୍ ଯୋହନ୍‌ ତେ ତାଲେତିଙ୍କ୍ କୟିତଡ଼୍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ତାଲିତାଗ୍ ଅନ୍‌ ତାଲ୍‍ଲେ ୱାଟି ଆଦ୍ ପିକ୍‍ତିଙ୍କ୍ ଇତ୍‍ତଡ଼୍ । ଆଦ୍ ଆସ୍ ତାନ୍ ୟାୟାଙ୍କ୍ ଇତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ତାନ୍ ପେର୍କେ ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟନଡ଼୍ ୱାସ୍ କବର୍ ହିଦାଙ୍କ୍ ଅନାଦ୍‌ ଡଲ୍‍ତେ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଆତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଆଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ଇଦୁଃକାମ୍ କାବୁର୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଯୋହନ୍‌‌ତେ କବର୍ କେଞ୍ଜ୍‍ତେ ୱେଲେ ଓଡତାରି ୱେରଡ଼୍ ସିମ୍‍ସାମ୍ ପଡ଼ିୟେତାଗ୍ ଆତ୍‍ତନ୍ । ଜିସୁ ଆଗେ ଆଦାନାଦ୍ ପୁଞ୍ଜ୍‍ମିକା ଗାର୍‍ରେମାନ୍ଦାନ୍ ସହର୍‍ନାଗାଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଆଞ୍ଚ୍ ଆଞ୍ଚ୍ ଆଞ୍ଜ୍ ଜିସୁନ୍ ପେର୍କେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଜିସୁ ବେସୁଙ୍କ୍‍ ଓଡ୍‍ତାଗାଙ୍କ୍ ଡିଗ୍‍ତନ୍ ହିଦ୍ ବେଡ଼ିୟାଦ୍ ମାନ୍ଦେ ଉଡ଼୍‍ତନ୍, ଅନ୍‌ ହୃଦୟ୍ ଦୟାତେ ବିଗଲିତ ଆତ୍‍ତେ । ନାର୍‍ଗେ ରୋଗିଡ଼୍‍କ୍ ଅଣ୍ଡ୍‌ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ଆଦ୍ ଦିନ୍ ମୁଲ୍‍ପୁଟ୍ ଶିଷ୍ୟନଡ଼୍ ୱାସ୍ କେତ୍‍ତଡ଼୍, “ଗାଟି ଡେରିଆଦୁତ୍, ମେଣ୍ଡେ ହିଦ୍ ପଡ଼ିୟେ ନିଚାଟିଆ, ନାରୁଡ଼୍‍କ୍ ଆତ୍‍ତାଙ୍କ୍ କେଲେମ୍ । ଅଡ଼୍‌ ନାକିନାଗ୍ ଆଞ୍ଜ୍ କାଦି ଜାଗାଡ଼୍‍ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତନ୍, “ଅଡ଼୍‌ ହିଗାଙ୍କ୍ ଆଦାନ୍ ଦର୍‍କାଡ଼୍ ଆୟ୍‍ୟ । ମିଡ଼୍ ଅଡ଼୍‌‍କ୍ ବାତ୍ ସୁଦୁଟ୍ ତିନ୍ଦାଙ୍କ୍ ହିମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ଶିଷ୍ୟନଡ଼୍ ଉତ୍ତର୍ କେତ୍‍ତଡ଼୍, “ହିଗେ ମାହାପାକେ ମାତର୍ ହେଇଙ୍କ୍ ରୂଟି ନୁ ରେଣ୍ଡ୍ କିକେ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜିସୁ କେତ୍‍ତାନ୍, “ଆସ୍‍କ୍ ନା ପାକେ ତାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ନାରୁଡ଼୍‍କ୍ ଗାଡ଼୍ ପର୍‍ର କୁଦାଙ୍କ୍ କେସ୍ ଜିସୁ ଆଉ ହେଇଙ୍କ୍ ରୂଟି ନୁ ରେଣ୍ଡେ କିକେଙ୍କ୍ ଆତ୍‍ତନ୍ ନୁ ସ୍ୱର୍ଗତ୍‍ ପାକେ ଉଡ଼ି ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍ ହିତ୍‍ତନ୍ । ମେଣ୍ଡେ ଆଉ ରୂଟିଙ୍କ୍ ଦୁଡ଼ା ଦୁଡ଼ା ମାଡ଼ି ଶିଷ୍ୟଡ଼୍ କାଇଦାଗ୍ ହିତ୍‍ତନ୍ । ଶିଷ୍ୟଡ଼୍ ଆଉହାସ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତୁଉସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ସାରେତଡ଼୍ ତିଞ୍ଜ୍ ପଟ୍‍ ନିଇତ୍‍ତଡ଼୍ । ତାନ୍ ପେର୍କେ ଶିଷ୍ୟଡ଼୍ ମିଗ୍ଲୀମାନ୍ଦାନ୍ ରୂଟି ନୁ କିକେ ଦୁଡ଼ାକିଂଙ୍କ୍ ପେହେକି ୱାଟ୍‍ଟାନ୍ ଜୁଡ଼ିନାଗ୍ ନିହିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ନାଟାଙ୍କ୍ ନୁ ପିଲାଙ୍କ୍ ୱିଡ଼୍‍ସି ଏଇଙ୍କ୍ ହଜାର୍‌ ନାରୁଡ଼୍ ଆଦ୍ କାଦି ତିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ତାନ୍ ପେର୍‍କେ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ଓଡେତେ ସମୁଦ୍ର ଆପାକେ ଆତ୍‍ତାଙ୍କ୍ କେତ୍‍ତାନ୍ । ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ନିଜେ ପେର୍କେ ମାଞ୍ଜ୍ ନାରୁଡ଼୍‍କ୍ ଆତ୍‍ତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ଅଣ୍ଡ୍‌ ୱେରନ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍‍ସେଙ୍ଗେ ମେଟେତ୍‍ ପର୍‍ର ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ମୁଲ୍‍ପୁଟ୍ ଆଦାନ୍ ୱେଲେ ଜିସୁ ଆଗେ ୱେରଣ୍ଡ୍ ମାତ୍‍ତନ୍ । ଆଦ୍ ଦିନାମ୍ ତେ ଜିସୁ ଉଡ଼୍‍ତନ୍ ଯେ ଅଡ଼୍‌ ବୂମ୍‌ତାଗାଙ୍କ୍ ପିନା ଜେକାଆଞ୍ଜ୍ ମାତ୍‍ତେ ନୁ ଗାଟି ଗାଲ୍ ୱାସମାନାଙ୍କ୍ ଗାଙ୍କ୍‍କୁଡ଼୍‍ତେ ଓଡ୍‌ ଉଙ୍ଗମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ନାର୍‍କେତ୍ ୱିୟ୍‍ଦାନ୍ ୱେଲେ ଜିସୁ ହେର୍‍ଦେ ପର୍‍ର ତାଆକି ଶିଷ୍ୟଡ଼୍ ଗାର୍‍ରେ ୱାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ଶିଷ୍ୟ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ୱେର୍‍ସ୍‍ ମାତ୍‍ତଡ଼୍, “ବୁତ୍ ବୁତ୍” ଇଞ୍ଜ ମର୍‍ପହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ସାଙ୍ଗେ ସାଙ୍ଗେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାହାସ୍ ଇସ୍‌ କେତ୍‍ତାନ୍, “ନାନ୍ ବାନେ ! ୱେର୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ଆଦ୍ କେଞ୍ଜି ପିତର୍ କେତ୍‍ତାନ୍, “ପ୍ରବୁ, ଯଦି ନିମ୍‍ ସତ୍ ଆସ୍ ମାନ୍‍ତିଡ଼୍, ହେର୍‍ଦେ ପର୍‍ର ତାଆକି ନିୟ୍ ଗାର୍‍ରେ ଆଦାନଙ୍କ୍ ଗଟ୍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜିସୁ କେତ୍‍ତାନ୍, “ତାଆକି ୱାଡ଼ା ।” ପିତର୍ ଓଡେତାଗଙ୍ଗା ଡିଗି ଜିସୁନ୍ ପାକେ ଏର୍‍ଦେ ପର୍‍ର ତାକାନଙ୍କ୍ ପସ୍ପ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଗାଲ୍‍ପିନା ୱାଦାନାଦ୍ ଉଡ଼ି ୱେର୍‍ତନ୍ ନୁ ହେର୍‍ଦାଗ୍ ମୁଡ଼୍‍ନ୍ଦାନଙ୍କ୍ ପସ୍ପ୍‍ତନ୍ । ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ମର୍‍ରେତେ କାର୍‍ଙ୍ଗ୍‍ତନ୍, “ପ୍ରବୁ ନାକିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ହଟାତ୍ ଜିସୁ କାୟ୍ ଆସ୍ ପିତର୍‍ତିଙ୍କ୍ ପଇସ୍‌ କେତ୍‍ତାନ୍, “ବେସତ୍ ବିଶ୍ୱାସ୍ ଇଲ୍‍ୱେନନୀ ନିମ୍‍ ! ଏର୍କା ମାଡ଼୍‍ତିନ୍ ବାତ୍‍ତିଙ୍କ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍‍କ୍ ଓଡେତ୍ ପର୍‍ର ତାର୍‍ତଡ଼୍ ନୁ ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଗାଲ୍ ମାଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ଶିଷ୍ୟଡ଼୍ ଜିସୁଙ୍କ୍ ଆରାଦାନା ମାଡ଼ି କେତ୍‍ତଡ଼୍ “ନିମ୍‍ ନିଜାମ୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ଅଡ଼୍‌ ସମୁଦ୍ରତିଙ୍କ୍ ୱେଇସ୍ ଗିନେସର୍‍ ବୁମ୍‌ତାଗା ହେୱ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଆଗେ ନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ ପୁଞ୍ଜ୍‍ମେଣ୍ଡେ ଗାର୍ରେ ନାର୍‍ଦେ ମାନ୍ଦାନ୍ ରୋଗିଡ଼୍‍କିଙ୍କ୍ ଜିସୁନ୍ ଗାର୍‍ରେ କାର୍‍ଙ୍ଗି ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ପିଡ଼ିତ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ସୁଦୁଟ୍ ଅନାଦ୍‌ ସିଲେତ୍ କଙ୍ଗିଙ୍କ୍‌ ଇଟାନଙ୍କ୍ ଗଟ୍ ହିୱୀଣ୍ଡ୍ ଇଞ୍ଜ, ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍ । ବେନଡ଼୍ ଆଦ୍ ମାଡ଼୍‍ତଡ଼୍, ଅଡ଼୍‌ ସୁସ୍ଥ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ଆଦ୍ ସମୟ୍‍ତେ ଯିରୁଶାଲେମ୍ ତାଗାଙ୍କ୍ ପାରୂଶୀଡ଼୍ ନୁ ଶାସ୍ତ୍ରିନଡ଼୍ ଜିସୁନ୍ ପାକେ ୱାସ୍ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ମାମ୍‍ମେ ମୁନେତ୍‍ନାରୁମ୍ ବେନ୍‍ସାରେ ଶିକ୍ଷା ଇସ୍ ଆତ୍‍ତମ୍, ନି ଶିଷ୍ୟନଡ଼୍ ବାତ୍‍ତିଙ୍କ୍ ପାଲନ୍ ମାଡ଼୍‍ଡ଼ ? ତିନ୍ଦାନ୍ ମୁନେଙ୍କ୍ ଅଡ଼୍‌ ବାତ୍‍ତିଙ୍କ୍ କାୟ୍ ନର୍‍ୱଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ଇତ୍‍ତନ୍, “ମିଡ଼୍ ଆନ୍‌‍ତେ ମିଇ ଇଶ୍ୱର୍‌ତେ ପାଡ଼୍‍ୟି ପାଲନ୍ ମାଡ଼କଟ୍ ନିଜେତ୍ ଶିକ୍ଷା ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ଇଶ୍ୱର୍ କେତ୍‍ତନ୍, “ୟାୟ୍‍ ବାବାଙ୍କ୍ ସନ୍‍ମାନ୍ ମାଡ଼ାଟ୍,” ମେଣ୍ଡେ ବେନଆଇ ବାବାଙ୍କ୍ କି ୟାୟାଙ୍କ୍ ଅବିଶାପ୍‌ ଇଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ନିଜାମ୍ ଡଲାନ୍ଦଣ୍ଡ୍ ତିପାଲ୍‍ଆଦାଙ୍କ୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଶିକ୍ଷା ଇଦୁତିଡ଼୍ ବେନ୍ ୱେରନ୍ ନାରୁଙ୍କ୍ ବେନ୍ ସେଙ୍ଗେତ୍‍ ମାଇଦିଙ୍କ୍ ନିଜେତ୍ ୟାୟ୍‍ ବାବାଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱେଣ୍ଡ୍, ଅନ୍‌ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦାନ ମାଡ଼ିତନ୍ ଇଞ୍ଜ କେତ୍‍ତାନ୍, ");
INSERT INTO kff_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ତାନ୍ ୟାୟ୍‍ ବାବାଙ୍କ୍ ଉଡ଼ାନଙ୍କ୍ ଅନାଦ୍‌ ଆଶେ ଇଲ୍‍ଲେ । ମିଡ଼୍ ଆଦ୍‍ଲେକାମ୍ ଇଶ୍ୱର୍‌ତେ ଗଟି କେଞ୍ଜକଟ୍ ନିଜେତ୍ ଶିକ୍ଷା ଲେକାମ୍ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ରେ ଦୁଷ୍ଟଡ଼ି, ଯିଶାଇୟ ମିଇ ବିଷୟ୍‍ତେ ସାୟେତ୍ ବାବବାନି କେସ୍‍ମିନ୍ଦେନ୍, ");
INSERT INTO kff_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ଇଶ୍ୱର୍ କେତିତ୍‍, ଇ ନାରୁଡ଼୍ ମାତର୍ ଗଟ୍‍ତେ ନାକିଂଙ୍କ୍ ସନ୍‍ମାନ୍ ଇଦ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ହୃଦୟ୍ ନାୟାଗାଙ୍କ୍ ନାର୍‍ଗେ ଦୁରାମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ନାକିଂଙ୍କ୍ ଅଡ଼୍‌ ଆରାଦାନା ମାଡ଼ାଙ୍କ୍ ଦର୍‍କାର୍ ଇଲେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ମାନେଇ ମାଡ଼୍‍ତାଦ୍ ନିୟମ୍‍ତିଙ୍କ୍ ନାୟାଦ୍ ଗଟ୍ ଇଞ୍ଜ କେତୁତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ତାନ୍‍ପେର୍କେ ଜିସୁ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଗାର୍‍ରେ କାର୍‍ଙ୍ଗି ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତାନ୍, “କେଞ୍ଜାଟ୍ ନୁ ବୁଜେମ୍ଆଦାଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ନାରୁନ୍ ପାୟୁର୍ ତାଲାନ୍ ବାତେଏ ଆଦ୍‍ତେ ଆଦ୍ ଲୋପେ ଆଦ୍‍ତେ, ଆଦ୍ ଅଂକିଙ୍କ୍‌ ଅପବିତ୍ର ମାଡ଼; ମେଣ୍ଡେ ବାତେଏ ଅନ୍‌ ପାୟୁର୍‍ତାଲାନ୍ ପେଇତିତ୍‍, ଆଦ୍ ଅଂକିଙ୍କ୍‌ ଅପବିତ୍ର ମାଡ଼ିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ଆସୁଙ୍କ୍ ଶିଷ୍ୟନଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ଆଞ୍ଜ୍ କେତ୍‍ତଡ଼୍, “ପାରୂଶୀଡ଼୍ ଆଦ୍ ଗଟ୍ କେଞ୍ଜି ବିରକ୍ତ ଆସ୍ ମିନ୍ଦେ, ନିମେବାତେ ଇଦ୍ ପୁତ୍‍ତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଉତ୍ତର୍ କେତ୍‍ତାନ୍, “ନା ସ୍ୱର୍ଗ ବାବାଲ୍ ବେନ୍ ସାରେ ମାଡ଼ାକ୍ ଉର୍‍ସ୍କନ୍, ହାଉସାରେ ଗାଜ୍‍ଜେ ଆଦ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","“ଅଡ଼୍‌ ବିଷୟ୍‍ତେ ଦାନ୍ଦେ ଆୟ୍‍ମାଟ୍‍ । ଅଡ଼୍‌ କାନାଙ୍କ୍ ଆର୍ ତତାନଣ୍ଡ୍ । ୱେରଣ୍ଡ୍ କାନାଲ୍ ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ କାନାଙ୍କ୍ ଆର୍ ତତ୍‍କେ ଇର୍‍ୱୁଡ଼୍ ଆସ୍‍ସ ଗୁଇନ୍ଦେତାଗ୍ ରାଲିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ଆଗାଙ୍କ୍ ପିତର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତାନ୍, “ଆଦ୍ ଗଟ୍ ମାକିଂଙ୍କ୍ ବୁଜା ମାଡ଼ିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜିସୁ କେତ୍‍ତାନ୍, “ମିଡ଼୍‍ ଆନ୍‌‍ନ୍ତେ ବାତ୍ ଇଞ୍ଜେ କଞ୍ଜ୍ ବୁଜେମ୍ ଆୟୱିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ବାତ୍‍ଆଇ ପାୟୁର୍ ତାଲାନ୍ ନେଙ୍କ୍‍ତେ, ଆଦ୍ ଲୋପେ ଆଞ୍ଜ୍ ମେଣ୍ଡେ ମେନ୍ଦୁଲ୍ ତାଲାନ୍ ପେଇସ୍ ଆଦ୍‍ତେ । ଇଦ୍ ବାତେଏ ବୁଜେମ୍ ଆୟ୍‍ୱିଡ଼୍‍ ? ");
INSERT INTO kff_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପାୟୁର୍‍ତାଲାନ୍ ବାତେଏ ପେୟ୍‍ତିତ୍, ଆଦ୍ ହୃଦୟତାଗାଙ୍କ୍ ପେୟ୍‍ତିତ୍ ନୁ ଆଦ୍ ଇ ନାରୁଙ୍କ୍ ଅପବିତ୍ର ମାଡ଼ିତେ । ");
INSERT INTO kff_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ବାତେଙ୍କ୍ ଇତ୍‍କେ ହୃଦୟ୍‍ତାଗ୍ କାରାପ୍ ଚିନ୍ତେ, ଆୱୁକାନାଦ୍, ବ୍ୟାବିଚାର୍, ଲାଞ୍ଜେକାମ୍‌, ଚୋର୍ଯ୍, ମିଚ୍‌ କେତାନାଦ୍‌ ନୁ ନିନ୍ଦ୍ ପେଇତିତ୍‍; ");
INSERT INTO kff_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ଇୱୁ ସାରେ ପାଡ଼୍‍ୟି ନାରୁଙ୍କ୍ ଅପବିତ୍ର ମାଡ଼ିତ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ କେତ୍‍ତାନ୍ ଲେକାମ୍ କାୟ୍ ନର୍‍ୱକଟ୍ ତିତ୍‍କେ ବେନ ଅପବିତ୍ର ଆୟନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜିସୁ ଆଦ୍ ପଡ଼ିୟେ ୱିଡ଼୍‍ସି ସୋର୍ ନୁ ସୀଦନ୍ ନାର୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆଗେ ମାନ୍ଦାନ୍ ୱେର୍‍ଡ଼୍ କିନାନିୟ ନାଟାଡ଼୍ ୱାସ୍ ଗାଟିଲେଙ୍କ୍ ଦେ କେତାଙ୍କ୍ ପସ୍ପ୍‍ତେ, “ହୋ ପ୍ରବୁ, ଦାଉଦ୍‍ତେ ମାର୍‍, ନାକିଂଙ୍କ୍ ଦୟାମାଡ଼େ, ନା ପିକ୍‍ତିଙ୍କ୍ ବୟଙ୍କାର୍ ବୁତ୍‍ ପଇତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ପଦ୍‍ମିକା ଉତ୍ତର୍ ହିୱଣ୍ଡ୍ । ଶିଷ୍ୟନଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍, “ଆଦିଙ୍କ୍ ଯାପେ ଆତ୍‍ତାଙ୍କ୍ କେଲ୍‍ମୁଟ୍ । ଉଡ଼ାଟ୍ ଆଦ୍ ବେଦ୍‍ଲେକାମ୍ ମର୍‍ପଇସ୍ ମାନ୍‍ ପେର୍କେ ୱାଦୁତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତନ୍, ନାନ୍‍ନେ ଇସ୍ରାଏଲ୍ ବଂଶତେ “ମାହିମାନ୍ଦାନ୍ ମେଣ୍ଢାନ୍ ସେଙ୍ଗେ ମେଣ୍ଡେ ବେନ ପାକେ ୱାଡ଼ନେ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ନାଟାଡ଼୍ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ମଡ଼୍‍କ୍‍ କି କେତାଙ୍କ୍ ପସ୍ପ୍‍ତେ, “ହୋ ପ୍ରବୁ, ନାକିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ମାତର୍ ଜିସୁ କେତ୍‍ତାନ୍, “ପିଲାନ୍ ଚାକୁର୍ ଅସ୍ ନେୟ୍‍କିନାଗ୍ ୱାଟାନାଦ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ନାଟାଡ଼୍ କେତ୍‍ତେ, “ଆଦ୍ ସତ୍ ପ୍ରବୁ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନେୟ୍‍କ୍‍ ମିକା ମେଜତ୍‍ମଦଲ୍ ମୁନିବର୍ ହେଙ୍ଗୁଲ୍ ତିନ୍ଦାଙ୍କ୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ କେତ୍‍ତାନ୍, “ହୋ ନାଟାତନି, ନିୟାଦ୍ ବେଡ଼ିଇ ବିଶ୍ୱାସ୍,” ନି ଇଚ୍ଛାତେ ନି ଲେକାମ୍ ଆୟି । ଆଦ୍ ଦଣ୍ଡତାଗାଙ୍କ୍ ତାନ୍ ମାୟାଡ଼୍ ସୁସ୍ଥ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଆଗାଙ୍କ୍ ପେଇସ୍ ଜିସୁ ଗାଲିଲୀ ସମୁଦ୍ର ଆଞ୍ଚ୍‍ ଆଞ୍ଚ୍ ଆଞ୍ଜ୍ ୱେରଡ଼୍ ମେଟେତ୍‍ ପର୍‍ର କୁଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌‍ଗାରେ ୱାସ୍ ନିତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ କୁଟାଲଡ଼୍, କାନାଲଡ଼୍‍କ୍, କନ୍ଦାଲଡ଼୍, ନୁ ବାତ୍ ବାତା ନାର୍‍ଗେ ରୋଗିଡ଼୍‍କ୍ ଅନ୍‌ ମୁନେ ନିଲ୍‍ସ୍ପିତ୍‍ ତଡ଼୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅନ୍‌ ଡେକାନ୍ ମୋଦଲ୍ ୱାଟିତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଆଦେଲେକା‍ମ୍ କନ୍ଦାଲଡ଼୍ ଗଟି କେତ୍‍ତଡ଼୍, କୁଟାଲଡ଼୍ ତାକୁତଡ଼୍, ନୁ କାନାଲଡ଼୍, ଉଡ଼ୁତଡ୍, ଇସ୍ରାଏଲ୍‍ତେ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରସଂଶା କିର୍ତ୍ତନ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଜିସୁ ଶିଷ୍ୟନଡ଼କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତାନ୍, “ଇ ନାରୁଡ଼୍ ସେଙ୍ଗେ ନାକିଂଙ୍କ୍ ଦୁଃକାମ୍ ପଇତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ହି ନାରୁଡ଼୍ ନା ତଡ଼୍ ମୁଣ୍ଡ୍ ଦିନା ମିନ୍ଦେ ନୁ ଇଞ୍ଜେ ଅଡ଼ାଗ୍ ବାତେଇଲେ । ଅଡ଼୍‌ ତିନକଟ୍ ଆନ୍‌‍ମାକି, ଇ ଗଟ୍ କେତୁତାନ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦାନ୍ ୱେଲେ ଆର୍‍ଦାଗ୍ ଆଇଦ୍ ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ଶିଷ୍ୟନଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, ଇସର୍ ନାରୁଡ଼୍‍କ୍ ପଟ୍‍ ନିଇତାଙ୍କ୍ ମାନାଡ଼୍ “ଇ ଉଚ୍‍କ ଲେକେଦାଗ୍ ଆସର୍ କାଦି ବେଗେ ଦର୍‍କିତ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜିସୁ କେତ୍‍ତନ୍, “ମିୟାଗ୍ ବେସ୍‌କ୍ ରୂଟି ମିନ୍ଦେ ?” ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ସାତ୍‍ଟାନ୍ ରୋଟି ନୁ ସୁକୁକ୍ ସୁଦୁ କିକେ ।” ");
INSERT INTO kff_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନେଲ୍ କୁଦାଙ୍କ୍ କେତ୍‍ତାନ୍, ");
INSERT INTO kff_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଆଉ ସାତ୍‍ଟାନ୍ ରୂଟି ନୁ କିକେଙ୍କ୍ ଅସ୍ ଦନ୍ୟବାଦ୍ ଇସ୍ ଆଉସାରେ ଶିଷ୍ୟଡ଼୍‍କ୍ ଇତ୍‍ତନ୍, ଅଡ଼୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ମେଣ୍ଡେ, ସାରେତଡ଼୍ ତିଞ୍ଜ୍ ପଟ୍‍ନିତଡ଼୍ ନୁ ଉର୍‍ଙ୍ଗ୍‍ତେ ରୂଟି ନାଗାଙ୍କ୍ ବେସ୍‌କ୍ ମିଗିଲ୍‍ ତାଉ, ଆଉ ଅଡ଼୍‌ ପେହେକି ସାତ୍‍ଟାନ୍ ଜୁଡ଼ିନାଗ୍ ନିହିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ତିତ୍‍ତେ ନାରୁଡ଼୍, ନାଟାଙ୍କ୍ ନୁ ପିଲାଙ୍କ୍ ୱିଡ଼୍‍ସି ନାଲୁ ହଜାର୍‌ ନାରୁଡ଼୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ତାନ୍ ପେର୍କେ ଜିସୁ ନାରୁଡ଼୍‍କ୍ ଆତ୍‍ତାଙ୍କ୍ କେସ୍ ଓଡ଼େତାରି ମଗଦାଲାନ୍ ନାର୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ପାରୂଶୀଡ଼୍ ନୁ ସାଦ୍ଦୂକିଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ପରିକ୍ଷା ମାଡ଼ାନ୍ ଅବିଯଗ୍‍ତେ ଅଂକିଙ୍କ୍‌ ମାବ୍‍ତାଗ୍ ୱେରଡ଼୍ ଚିହ୍ନେ ତତାଙ୍କ୍ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ଇତ୍‍ତଣ୍ଡ୍, “ମୁଲ୍‍ପୁଟ୍ ମିଡ଼୍ କେସ୍‍ମାନୁଟ୍, ଲେକେତ୍‍ ପାଗ୍ ଆଦ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାବ୍‍ଏର୍ ଆସ୍‍ମିନ୍ଦେ, ");
INSERT INTO kff_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ସାରେଦିନା କେସମାନୁଟ୍, ନେଣ୍ଡ୍ ୱାର୍‍ସାମ୍ ଆଦ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାବ୍‍ଏର୍ ଆସ୍‌ ମିନ୍ଦେ ମାବ୍‍ପଇସ୍ ମିନ୍ଦେ । ମିଡ଼୍ ମାବ୍ ଉଡ଼ିକେ କେତା କେତି ଆସ୍ ପୁନ୍ଦୁତିଡ଼୍, ବାତେଙ୍କ୍ଇତ୍କେ ଦିନାକିଙ୍କ୍ ଉଡ଼ାନାଦ୍ ସାରେ ବୁଜେମ୍ ଆୟୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ଇ ଯୁଗ୍‍ତେ ନାରୁଡ଼୍ ବେସର୍ ଦୁଷ୍ଟ ନୁ ଇଶ୍ୱର୍‌ତେ ଅବିଶ୍ୱାସ୍ । ମିଡ଼୍ ୱେରଡ଼୍ ଆଶର୍ଯ୍ୟ କାମ୍ ମାଡ଼ାଙ୍କ୍ କେତୁତିଡ଼୍ ? ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯୁନସ୍‍ତେ ଜିୱୁନ୍‍ତେ ଗଟେମ୍ ଆସ୍‍ମାନ୍ଦାନ୍ ବାକ୍‍ୱାକାମ୍ ୱିଡ଼୍‍ସି ବାତେମିକା ବାକ୍‍ୱାକାମ୍ ମିଡ଼୍ ନାୟାଗେ ଉଡ଼୍‍ୱିଡ଼୍ ।” ଆଦ୍ କେସ୍ ଜିସୁ ଅଡ଼୍‌‍କ୍ ୱିଡ଼୍‍ସି ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ଶିଷ୍ୟନଡ଼୍ ସମୁଦ୍ର ମେଣ୍ଡେନ୍ ପାକେ ହେଉସ୍ ଉଡ଼୍‌ତଡ଼୍ ଯେ, ଅଡ଼୍‌ ରୂଟି ଅଦାଙ୍କ୍ ମାର୍‍ଙ୍କ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତନ୍, “ସର୍ତକ ଆୟ୍‍ମୁଟ୍, ପାରୂଶୀଡ଼୍ ନୁ ସାଦ୍ଦୂକିଡ଼୍ କମୀର୍‍ତାଗାଙ୍କ୍ ସାବ୍‍ଦାନ୍ ଆସ୍‍ମାନୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ତାମ୍‍ତାମ୍ କେତାକେତି ଆଦ୍‍ତଡ଼୍, “ମାନାଡ଼୍ ରୂଟି ତାଡ଼୍‍ୱାଡ଼୍ ଇଞ୍ଜ ଅଣ୍ଡ୍‌ ଆଦ୍ କେତୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁଆଦ୍ ପୁଞ୍ଜ୍ କେତ୍‍ତାନ୍, ହୋ ସୁଦୁଟ୍ ବିଶ୍ୱାସିନଡ଼ି, “ମିଇ ୟାଗ୍‍ ରୂଟି ଇଲାଇଞ୍ଜ୍ ବାତ୍‍ତିଙ୍କ୍ ନିଜେ ନିଜେ ରାମ୍‍କ୍ ଆଦୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ମିଡ଼୍‍ବାତେ ଇଞ୍ଜ ବା ବୁଜେମ୍ ଆୟ୍‍ୱିଡ଼୍‍ ? ଏଇଙ୍କ୍ ହଜାର୍‌ ନାରୁଡ଼୍ ଆଗାଙ୍କ୍ ରୋଟି ମେଣ୍ଡେ ବେସ୍‌କ୍ ଜୁଡ଼ିନାଗ୍ ପେହେକ୍‍ତିଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଆଦ୍ ନାଲୁହଜାର୍‌ ନାରୁଡ଼୍ ସାତ୍‍ଟାନ୍ ରୂଟି ମେଣ୍ଡେ ବେସ୍‌କ୍ ଜୁଡ଼ିନାଗ୍ ପେହେକ୍‍ତିଡ଼୍, ଆଉସାରେ ମିକିଂଙ୍କ୍ ଏର୍କା ଇଲେ ?” ");
INSERT INTO kff_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“ନାନ୍ ମିକିଂଙ୍କ୍ ରୋଟି ବିଷୟ୍‍ତେ କେଲନ୍, ଇଦ୍ ବେଲା ବୁଜେମ୍ ଆୟୱିଡ଼୍ ? ବାତେଙ୍କ୍ ଇତ୍‍କେ ପାରୂଶୀଡ଼୍ ନୁ ସାଦ୍ଦୂକିଡ଼୍ କମୀର ବିଷୟ୍‍ତେ ସାବ୍‍ଦାନ୍ ଆସ୍‍ମାନୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ଜିସୁ ଯେ ରୋଟିତେ କମୀର୍‍ତାଗାଙ୍କ୍ ସାବ୍‍ଦାନ୍ ଆଶେ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ କେଲକଟ ଫାରୁଶି ନୁ ସାଦୁକିଡ଼୍ ଶିକ୍ଷାତେ ସାବ୍‍ଦାନ୍‍ ଆଶେ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ଅଡ଼୍‌ ଆସୁଟେ ବୁଜେମ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ତାନ୍ ପେର୍କେ ଜିସୁ କାଇସରୀୟା ପିଲିପ୍ ନାର୍‍ଦେ ପାକେ ୱାସ୍ ତାନ୍ ଶିଷ୍ୟନଡ଼୍‍କ୍ କେତାଙ୍କ୍ ପସ୍ପତନ୍, “ନାରୁନ୍‍ପିଲେ ବେନ୍ ଇଞ୍ଜ ନାରୁଡ଼୍ କେତୁତଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ବେନ କେତିତଡ଼୍‍, ବାପ୍ତିସ୍ମ ଯୋହନ୍‌, ବେନ ଏଲିୟ, ମେଣ୍ଡେ ବେନ ଜିରିମୀୟ ବା ବାବବାଦୀନଡ଼୍ ଆଗାଙ୍କ୍ ୱେରନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ “ନାନ୍ ବେନ ଇଞ୍ଜ ମିଡ଼୍ କେତୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ଶିମୋନ୍ ନୁ ପିତର୍ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ କ୍ରିଷ୍ଟ, ଜିୱୁତେ ଇଶ୍ୱର୍ ତେ ମାର୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତାନ୍, “ହୋ ଯୁନସ୍‍ତେ ମାର୍‍ ଶିମୋନ୍, ନିମ୍‍ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁଡ଼୍ ପାକେ ଆୱୁଙ୍ଗ୍‍ ନୁ ନେତୁର୍‍ କେଲନ୍, ବେଲାନ୍ ନା ସ୍ୱର୍ଗତେ ବାବାଲ୍ କେସ୍‍ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“ମେଣ୍ଡେ, ନାନ୍ ମିକା ନିକିଂଙ୍କ୍ କେତୁତାନ୍, ନିମ୍‍ ପିତର୍, ମେଣ୍ଡେ ଇ କାଲ୍‍ଦେ ପର୍‍ର ନାନ୍ ନିଜେତ୍ ମୋଣ୍ଡଲି ମାଡ଼ିତାନ୍, ମେଣ୍ଡେ ନର୍କତେ ଶକ୍ତି ଆଦିଙ୍କ୍ ଆରେମ୍‍ ମାଡ଼ । ");
INSERT INTO kff_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ନାନ୍ ନିକିଂଙ୍କ୍ ସ୍ୱର୍ଗରାଜ୍ୟତେ କୁଚ୍‍କାଇ ଇଦ୍‍ତାନ୍, ମେଣ୍ଡେ ନିମ୍‍ ପୃତିବି ତାଗ୍ ବାତେଏ ସାରେ ବନ୍ଦ୍‍ମାଡ଼ିତିନ୍, ସ୍ୱର୍ଗତାଗ୍ ଆଦ୍ ବନ୍ଦ୍‍ମାନ୍‍ତେ, ମେଣ୍ଡେ ପୃତିବିତାଗ୍ ବାତ୍‍ଆଇ ମୁକ୍ତ ମାଡ଼ିତିନ୍, ସ୍ୱର୍ଗତାଗ୍ ଆଦ୍ ମୁକ୍ତ ମାନ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ଯେ କ୍ରିଷ୍ଟ ଆଦ୍‍ତନ୍, ଇଦ୍ ବେନଙ୍କ୍ ବା କେଲ୍‍ମାଟ୍ ହିଞ୍ଜ ଅଣ୍ଡ୍‌ ଶିଷ୍ୟଡ଼୍‍କ୍ ଦୃଡ଼ ଗଟ୍ ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ଆଦ୍ ସମୟ୍‍ତାଗାଙ୍କ୍ ଜିସୁ କ୍ରିଷ୍ଟ ତାନ୍ ଶିଷ୍ୟନଡ଼କ୍ ବୁଜାମାଡ଼ାଙ୍କ୍ ପସ୍ପତନ୍ ଯେ, “ନାନ୍, ଯିରୁଶାଲେମ୍‍ତା ଆଞ୍ଜ୍ ଦର୍ମଯାଜକ୍, ଦର୍ମଗୁରୁ ନୁ ଦର୍ମନେତାନଡ଼୍‍ ତଡ଼୍ ନିର୍ଯ୍ୟାତିତ ଆସ୍ ଗାଟି କଷ୍ଟ ଆଦ୍‍ତଣ୍ଡ୍‌ । ଅଦିକ୍‍ ଡଲିତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମୁଣ୍ଡ୍‍ଦିନା ପେର୍କେ ମେଣ୍ଡେଜିୱେ ଆସ୍ ତେଦିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ପିତର୍ ଜିସୁଙ୍କ୍ ୱେରଙ୍କ୍ କାର୍‍ଙ୍କି ଅସ୍ ମଜା ମାଡ଼ି କେତ୍‍ତାନ୍, “ଇଶ୍ୱର୍ ମାଡ଼୍‍ମାକିଣ୍ଡ୍, ପ୍ରବୁ, ନି ସେଙ୍ଗେ ଇଲା ବେସୁଙ୍କ୍‍ ଆୟ୍‍ମାକି ।” ");
INSERT INTO kff_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ଜିସୁ ମେଣ୍ଡେ ମାଲ୍‍ସ୍ କେତ୍‍ତନ୍, “ନା ମୁନେଙ୍କ୍ ଜେକ୍ ଅନ୍‌ ଶୟ୍‍ତାନ୍‍, ନା ସେଙ୍ଗେ ପ୍ରତିବନ୍ଦକ ଆୟ୍‍ମା । ବାତେଙ୍କ୍ ଇତ୍କେ ନିୟାଦ୍ ଇ ଚିନ୍ତେ ମାତର୍ ମାନବିକ, ସମ୍ପତି ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ତାନ୍‍ପେର୍କେ ଜିସୁ ତାନ୍ ଶିଷ୍ୟଡ଼କ୍ କେତ୍‍ତନ୍, “ବେନ ବେସୁଙ୍କ୍‍ ନା ପେର୍କେ ୱାଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍, ଆଲେକେ ଅଣ୍ଡ୍‌ ନିଜେତିଙ୍କ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ିଣ୍ଡ୍, ମେଣ୍ଡେ ନିଜେ କ୍ରୁଶକାଞ୍ଜି ନା ପେର୍କେ ତାକିଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ଆୟି ନିଜେତ୍ ଜିୱୁନ୍‍ ରକ୍ଷା ମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିତନ୍, ଆଦ୍ ଅଣ୍ଡ୍‌ ଆରାମ୍ ମାଡ଼ିତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍‍ତିଙ୍କ୍ ଉତ୍ସର୍ଗ ମାଡ଼ିତନ୍ ଅଣ୍ଡ୍‌ ଆଦ୍ ପ୍ରାପ୍ତ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ନାରୁନ୍ ବେସୁଙ୍କ୍‍ ସାରେ ଜଗତ୍ ଲାବ୍ ମାଡ଼ି ନିଜେତ୍ ଜିୱୁନ୍‍ ହିଦ୍‍ତନ୍, ଆଲେକେ ଅନାଦ୍‌ ବାତ୍ ଲାବ୍ ଆଦ୍‍ତେ ? ");
INSERT INTO kff_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ମେଣ୍ଡେ ନାରୁଡ଼୍ ପିଲେ ନିଜେତ୍ ବାବଙ୍କ୍ ମାଇମାତେ ଗୌରବ୍ ପାଏମ୍ ଆସ୍ ନିଜେ ଦୂତତଡ଼୍‍ ୱାଦ୍‍ତଣ୍ଡ୍ ନୁ ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ସାରେନାରୁଡ଼୍ ଅନ୍‌ ପାଡ଼୍‍ୟି ଲେକାମ୍ କାୟେ ହିଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ନାରୁନ୍ ପିଲେ ନିଜେତ୍ ରାଜ୍ୟତାଗ୍ ୱାଦାନାଦ୍ ଉଡ଼୍‍ୱେ ଯାକ ଇଗେ ନିସ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଡ଼ାଗାଙ୍କ୍ ବେସ୍‌କ୍ ବେଦ୍‍ଲେକାମ୍ ଡଲ୍‍ତାଗାଙ୍କ୍ ଆସ୍ୱାଦ ପାଏମ୍ ଆୟନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ଜିସୁ ହିଦିନ୍ ଆରୁଦିନା ପେର୍କେ ପିତର୍ ନୁ ଯାକୁବ୍ ଯୋହନ୍‌ ତେ ଇର୍‍ୱୁଡ଼୍ ତାମୁଣ୍ଡ୍‌କିଡ଼୍‍କ୍ ଆସ୍ ୱେରଡ଼୍ ଡେଙ୍ଗ୍ ମେଟେତାଗ୍ ଆଦ୍‍ତଡ଼୍ ଆଗେ ବେନ ହିଲ୍‍ୱେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ଶିଷ୍ୟଡ଼୍ ଉଡ଼୍‍ନା ଜିସୁନ୍ ମୁନେତ୍ ଲେକାମ୍ ମିଡ଼୍‍ନ୍‍ତଣ୍ଡ୍ । ଅନ୍‌ ମକମ୍ ପଡ଼ଦ୍ ଲେକାମ୍ ୱେସ୍ ଆତ୍‍ତେ ନୁ ଅନ୍‌ ଚକା ୱେସ୍‍ଇନା ସାୟେ ତନ୍ତତେ । ");
INSERT INTO kff_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ମଶାଲ୍‌ ନୁ ଏଲିୟ ଜିସୁନ୍ ତଡ଼୍ ଗଟି ତିର୍‍ୟାନାଦ୍ ଶିଷ୍ୟଡ଼୍ ଉଡ଼୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ପିତର୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତାନ୍, “ବେସର୍ ସୁକାମ୍‍ତେ ଗଟ୍, ନେଣ୍ଡ୍ ମାମ୍‍ମେ ଇଗେ ମିନ୍ଦେମ୍ । ନିମ୍‍ ଯଦି ଇଚ୍ଛା ମାଡ଼ୁତିନ୍, ଇଗେ ନାନ୍ ମୁଣ୍ଡ୍ ଗୁଡ଼ୁସା ମାଡ଼ିତାନ୍ । ୱେରଡ଼୍ ନି ମାଇଦିଙ୍କ୍, ମେଣ୍ଡେ ରେଣ୍ଡ୍ ମଶାଲ୍‌ ନୁ ଏଲିୟନ୍ ମାଇଦିଙ୍କ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ପିତର୍ ଆଦ୍ କେତ୍‍ତାନ୍ ୱେଲେ ୱେରଡ଼୍ ୱେସ୍‍ତେ ମାବ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ତାଲେତ୍ ପର୍‍ର ୱାତ୍‍ତେ ନୁ ଆଗାଙ୍କ୍ କେଞ୍ଜ୍‍ତଡ଼୍, “ହୋ ନା ପ୍ରିୟ ମାର୍‍, ଇନାଗେ ନାନ୍ ପେର୍କେ ସାର୍‍ଦେ । ଅନ୍‌ ଗଟ୍ ମନ୍ଇସ୍ କେଞ୍ଜାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ଶିଷ୍ୟନଡ଼୍ ଆଦ୍‍ଲେଙ୍ଗ୍ କେଞ୍ଜି ଦାଦ୍‍ରେଲି ନେଲ୍ କାପ୍‍ମୁଡ଼୍‍ନ୍ଦି ରାଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ଜିସୁ ଅଡ଼୍‌ ଗାର୍‍ରେ ୱାସ୍ ଅଡ଼୍‌‍କ୍ ହିଟିମିକା କେତ୍‍ତାନ୍ “ତେଦାଟ୍ ୱେର୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ଆସୁଟ୍‍ ଶିଷ୍ୟଡ଼୍ ସାରେ ପାକା ସିଟ୍‍ପାଟ୍‍ ଉଡ଼ି ମାତର୍‍ ଜିସୁନ୍‍ ୱିଡ଼୍‍ସି ଆଗେ ୱେର୍‍ ବେନଙ୍କ୍ ଉଡ଼ଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ଅଡ଼୍‌ ମେଟେତାଗାଙ୍କ୍ ଡିଗି ୱାଦାନ୍ ୱେଲେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦେଶ୍ ଇସ୍‌ କେତ୍‍ତାନ୍, “ନାରୁନ୍‍ପିଲେ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଦ୍‍ନା ଯାକ ଇଦ୍ ଉଡ଼୍‍ତାଦ୍‍ ଗଟ୍ ମିଡ଼୍ ବେନଙ୍କ୍ କେଲ୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ଶିଷ୍ୟଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ଏଲିୟ ମୁନେ ୱାଦ୍‍ତନ୍ ଇଞ୍ଜ୍ ମା ଦର୍ମଗୁରୁଡ଼୍‍କ୍ ବାତ୍‍ତିଙ୍କ୍ କେତ୍‍ତମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଜିସୁ କେତ୍‍ତାନ୍ “ହୋ ଏଲିୟ ମୁନେ ୱାସ୍ ସାରେ ବିଷୟ ତିଆର୍ ମାଡ଼ି ନେହେତାନ୍ ଗଟ୍;” ");
INSERT INTO kff_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, “ଏଲିୟ ୱାସ୍ ତେରୁତନ୍ ନୁ ଅଂକିଙ୍କ୍‌ ହେଞ୍ଚକଟ୍ ନାରୁଡ଼୍ ଅନ୍‌‍ସାଙ୍ଗେ ବାତ୍‍ଇଚ୍ଛା, ଆଦ୍ ମାଡ଼୍‍ତଡ଼୍ । ନାରୁନ୍ ପିଲେତ୍‍ ସେଙ୍ଗେ ମିକା ଅଡ଼୍‌ ଆଦେଲେକାମ୍ କାରାପ୍ କାମ୍ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ଆସୁଙ୍କ୍ ଶିଷ୍ୟନଡ଼୍ ବୁଜେମ୍ ଆଦ୍‍ତଡ଼୍ ଯେ, ଜିସୁ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ତେ ବିଷୟ୍‍ତେ କେତୁତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ନାରୁଡ଼୍ ଗଓଲି ଲୋପେଙ୍କ୍ ମାଲ୍‍ସ୍ ୱାଦାନ୍ ୱେଲେ ୱେରନ୍ ନାରୁଡ଼୍ ଗାର୍‍ରେୱାସ୍ ମର୍‍ମିଣ୍ଡା ଉସ୍‍ କେତ୍‍ତାନ୍, ");
INSERT INTO kff_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ପ୍ରବୁ, ନା ମାରିଙ୍କ୍ ଦୟା ମାଡ଼େ । କୁନ୍ଦେଲ୍ ରଗ୍ ଲେକାମ୍ ଅଣ୍ଡ୍‌ ନାର୍‍ଗେ ଦାମ୍ କିସ୍ ବା ଏର୍‍ଦାଗ୍ ରାଲ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ଅଂକିଙ୍କ୍‌ ନାନ୍ ନି ଶିଷ୍ୟଡ଼ା ତାସ୍‍ମାତ୍‍ତାନ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ସୁସ୍ଥମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜିସୁ କେତ୍‍ତାନ୍ “ମିଡ଼୍ ବିଶ୍ୱାସ୍ ଆୟ୍‍ୱିଡ଼୍ ନୁ ନଷ୍ଟ; ମିଇ ତଡ଼୍ ନାନ୍ ବେସ୍‌କ୍ ଦିନାମାନ୍‍ନ୍ଦାନ୍ ? ମେଣ୍ଡେ ବେସ୍‌କ୍ ୱାଡ଼୍‍ଷା ମିୟାଦ୍ ବ୍ୟବହାର୍ ସାରେ ମାଡ଼ିତାନ୍ ? ଆଦ୍ ପେକାଙ୍କ୍ ନା ପାକେ ତାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ପେକାନ୍ ଲୋପେ ବୁତ୍‌ତିଙ୍କ୍ ଜିସୁ ଦମକ୍ ଇତ୍‍ତନ୍ । ବୁତ୍ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ଆତ୍‍ତେ ନୁ ଆସୁଙ୍କ୍ ପେକାଲ୍ ସୁସ୍ଥ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ତାନ୍‍ପେର୍କେ ଶିଷ୍ୟଡ଼୍ ଜିସୁଙ୍କ୍ ସାରେତଡ଼୍ କାଇଲି କେତ୍‍ତଡ଼୍, “ମାମ୍‍ମେ ବାତ୍‍ତିଙ୍କ୍ ଆଦ୍ ବୁତ୍‌ତିଙ୍କ୍ ୱିର୍‍ସ୍‍ପେ ପାର୍‍ୱମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଜିସୁ କେତ୍‍ତାନ୍ “ମିୟାଦ୍ ବିଶ୍ୱାସ୍ ଗାଟି ଦୁର୍ବଲ୍ । ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ଯଦି ୱେରଡ଼୍ ସୋରିଷ ପେଡ଼େମ୍ ଲେକାମ୍ ମିୟାଦ୍ ବିଶ୍ୱାସ୍ ମାନ୍‍ତେ, ଇଦ୍ ମେଟେତିଙ୍କ୍ ଇଗାଙ୍କ୍ ଆଗେ ଗୁସ୍‍ପାଙ୍କ୍ କେତ୍‍କେ, ଆଦ୍ ଗୁସିଆଦ୍‍ତେ । ବିଶ୍ୱାସ୍ ଶକ୍ତିତେ ସାରେ ମାଡ଼୍ ପାର୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପ୍ରାର୍ତନା ନୁ ଉପବାସ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନ୍ ଉପାୟ୍‍ତେ ଇଦ୍‍ଲେକାମ୍ ବୁତ୍ ପେଇସ୍ ଅନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ଶିଷ୍ୟନଡ଼୍ ସାରେତଡ଼୍ ଗାଲିଲୀତାଗ୍ ୱେରଡ଼୍ ତାଗ୍ ଆଦାନ୍ ପେର୍କେ ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତାନ୍, ");
INSERT INTO kff_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","“ବେନ୍ ନାରୁଡ଼୍ ମାନେଇ ପିଲେତିଙ୍କ୍ ହାଉକିତଡ଼୍, ଅଡ଼୍‌ କାଇଦେ ସମର୍‍ପିତ ଆତ୍‍ତାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଞ୍ଜେ ଆଦୁତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମୁଣ୍ଡୁଦିନା ପେର୍କେ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ତେଦିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ଜିସୁ ନୁ ଶିଷ୍ୟନଡ଼୍ କପର୍ନାହୁମତା ୱାଦାନ୍ ପେର୍କେ ମନ୍ଦିର୍‍ତେ ସିସ୍ତୁ ଆଦାୟକାରୀଡ଼୍ ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ମିଇ ଗୁରୁ ମନ୍ଦିର୍‍ତେ ସିସ୍ତୁ ଇଦ୍‍ତନ୍ କି ?” ");
INSERT INTO kff_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପିତର୍ କେତ୍‍ତାନ୍ “ନିଜାମ୍ ।” ପିତର୍ ଲୋନ୍‌ ଲୋପେ ନେଙ୍ଗାନ୍ ୱେଲେ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତାନ୍, “ଶିମୋନ୍, ନିମ୍‍ ବାତେଏ ଆଲ୍‍ସୁତିନ୍ ? ଇ ଜଗତ୍‍ତେ ରାଜାନଡ଼୍‍କ୍ ବେନ୍ ସିସ୍ତୁ ଇଦ୍‍ତନ୍ ଅଡ଼୍‌ ରାଜ୍ୟତେ ଶନ୍ୟନଡ଼୍‍ ନା ବିଦେଶୀ ନଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପିତର୍ କେତ୍‍ତାନ୍ “ବିଦେଶୀଡ଼୍‍ ।” ଜିସୁ କେତ୍‍ତାନ୍, “ଆଲେକେ ରାଜ୍ୟତେ ନାରୁଡ଼୍ କର ହିଦାନାଗାଙ୍କ୍ ଗେଲ୍‍ସିତ୍‍ତେ ? ");
INSERT INTO kff_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାମ୍‍ମେ ଇଞ୍ଜେ ଅଡ଼୍‌‍କ୍ ଅପ୍‍ମାନ୍ ମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛା ଆୟମ୍ । ମିଡ଼୍ ସମୁଦ୍ର ଆଞ୍ଚିନା ଆଞ୍ଜ୍ ଗାଲାକ୍ ୱାଟାଟ୍ । ମୁନେଙ୍କ୍ ବେନ୍ କିକେ ଆର୍‍ଦ୍‍ତେ, ତାନ୍ ପାୟୁର୍‍ତାଗାଙ୍କ୍ ୱେରଡ଼୍ ମୁଦ୍ରା ଦର୍‍କିତ୍ । ଆଦ୍ ଆସ୍ ନା ସେଙ୍ଗେ ନୁ ମିଇ ସେଙ୍ଗେ ମନ୍ଦିର୍ ସିସ୍ତୁ ଇମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ଅନ୍‌‍ଦିନେ ଶିଷ୍ୟନଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ସ୍ୱର୍ଗ ରାଜ୍ୟତାଗ୍ ସାରେତିଙ୍କ୍ ବେଡ଼ିୟନ୍ ବେନ ?” ");
INSERT INTO kff_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଜିସୁ ୱେରଡ଼୍ ପିଲେତିଙ୍କ୍ ଅଡ଼୍‌ ମୁନେ ନିଲ୍‍ପି କେତ୍‍ତନ୍, ");
INSERT INTO kff_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ ହେର୍କେତେ କେତୁତାନ୍, “ମିୱାଦ୍ ମନ୍ ପିରିବର୍ତ୍ତିତ ଆସ୍ ପିଲେ ଲେକାମ୍ ଆୟ୍‍ୟ କଟମାତ୍‍କେ ସ୍ୱର୍ଗ ରାଜ୍ୟତାଗ୍ ବେସୁଙ୍କ୍‌ବା ଆଦେ ପାର୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ବେନ ନିଜେତିଙ୍କ୍ ନମ୍ର ମାଡ଼ି ଇ ପିଲେ ଲେକାମ୍ ଆଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ସ୍ୱର୍ଗ ରାଜ୍ୟତାଗ୍ ସାରେତିଙ୍କ୍ ବେଡ଼୍‍ୟନ୍, ");
INSERT INTO kff_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ବେନଆଇ ନା ପେଦେର୍‍ତେ ଇଦ୍‍ଲେକାମ୍ ୱେରଡ଼୍ ସୁଦୁ ପିଲେତିଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ମିକା ଗ୍ରହନ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ନାର୍‍ଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ଇ ପିଲାନାଗାଙ୍କ୍ ୱେରନ୍ ବିଶ୍ୱାସ୍‍ତେ ବେନ ବା ବେଡ଼ିୟ୍ ମାଡ଼ିତନ୍, ଅନ୍‌ ଗୁଡ଼ୁଙ୍ଗାତାଗ୍ ୱେରଡ଼୍ ଜାତ୍‍ତେକାଲ୍ ତଅସ୍ ଅଂକିଙ୍କ୍‌ ସମୁଦ୍ର ତାଗ୍ ହେସାନାଦ୍ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ନାରୁଡ଼ାଦ୍ ବିଶ୍ୱାସ୍‍ତାଗ୍ କଷ୍ଟ ହିଦାନ୍ ସେଙ୍ଗେ ନାର୍‍ଗେ ବିଷୟ ମିନ୍ଦେ । ଆଦିନ୍ ସେଙ୍ଗେ ଇ ଜଗତ୍‍ତେ ଅବସ୍ଥାତେ ଇସର୍ ବୟଙ୍କାର୍ । ସାରେଦାମ୍ ଇଲ୍‍ଲେ ବେଡ଼ିୟ୍ ଆଦ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ୍ ବେଡ଼ିୟ୍ ମାଡ଼ିତନ୍, ଅନ୍‌ ପରିନତି ବେସର୍ ଶଚନିୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ଯଦି ମିୟାଦ୍ କାୟ୍ ବା ଡେକେତ୍ ସେଙ଼୍ଗେ ନିମ୍‍ ବିଶ୍ୱାସ୍ ଆରାମ୍ ମାଡ଼ିତନ୍ ଆଲେକେ ଆଦିଙ୍କ୍ କଇସ୍ ହେସ୍‍ସିମୁଟ୍ । ରେଣ୍ଡେ କାଇକ୍ ନୁ ରେଣ୍ଡ୍ ଡେକା ମାଞ୍ଜ୍ ଗାଟି ନିଡ଼୍‍ତାନାଦ୍ କିସ୍‍ତାଗ୍ ଆଦାନ୍ ବେଲାନ୍ ସଟାନ୍ ଲେକାମ୍ ଆସ୍ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ତେ ଆଦାନାଦ୍ ସାୟେ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“ନି କଣ୍ଡାତ୍ ସେଙ୍ଗେ ଯଦି ମିୟାଦ୍ ବିପଦ୍‍ତେ ବାତେଙ୍କ୍ ଇତ୍କେ ଆୟେଡ଼୍‍; ଆଦିଙ୍କ୍ ଟେଣ୍ଡି ହେସିତିନ୍ । ରେଣ୍ଡ୍ କଣ୍ଡାମାଞ୍ଜ୍ ନର୍‍କତା ଆଦାନ୍ ୱିଡ଼୍‍ସି ୱେରଡ଼୍ କଣ୍ଡା ଆସ୍ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ତେ ଆଦାନାଦ୍ ସାୟେ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ଇ ନଗନ୍ୟଡ଼୍‍ଗାଙ୍କ୍ ୱେରଙ୍କ୍ ଆଲେ ତୁଚ୍ଛ ମନେମାଡ଼୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଇଡ଼ାଦ୍ ଯନ୍ ଆସମାନ୍ଦାନ୍ ସ୍ୱର୍ଗଦୂତକି ସାରେଦିନା ବାବାଲ୍ ଇଶ୍ୱର୍‌ତେ ପାକେ ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“ବାତେଙ୍କ୍ ଇତ୍କେ ହାର୍‍ପୁନ୍‍ୱେ ନାରୁଙ୍କ୍ ରକ୍ଷା ମାଡ଼ାଙ୍କ୍ ନାରୁନ୍ ପିଲେ ୱାସ୍‍ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ନିମ୍‍ ବାତେଏ ଏର୍କା ମାଡ଼ୁତିନ୍, ଯଦି ୱେରନ୍ ନାରୁନ୍ ଶହେ ମେଣ୍ଢାନାଗାଙ୍କ୍ ନୁ ୱେରଡ଼୍ ମେଣ୍ଢା ମାଇତେ, ଆଲେକେ ଅଣ୍ଡ୍‌ ବାତେଏ ମାଡ଼ିତନ୍ ? ନବେ ନଟାନ୍ ମେଣ୍ଢାଙ୍କ୍ ମେଟେତାଗ୍ ୱିଡ଼୍‍ସି ଆଦ୍ ମାଇମାନ୍ଦାନ୍ ମେଣ୍ଢାତିଙ୍କ୍ ମେହେକାଂଙ୍କ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ବେସୁଙ୍କ୍‍ ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ଦର୍ସ୍କିତନ୍, ମାଇୱେ ମାନ୍ଦାନ୍ ନବ୍‍ବେ ନହଟାନ୍ ମେଣ୍ଢାନ୍ ସେଙ୍ଗେ ନିଜାମ୍‍ ଅନ୍‌ ବେସର୍ ୱେଡ଼୍‍କିତନ୍, ଇ ୱେଡ଼୍‍କ୍‍ ମେଣ୍ଢେତ୍ ସେଙ୍ଗେ ତାନ୍ ସେଙ୍ଗେ ଅଦିକ୍‌ ୱେଡ଼୍‍କିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ଟିକ୍ ଆଦେଲେକାମ୍, ଇ ନଗନ୍ୟ ନାରୁଡ଼ାଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ମିକା ହାର୍‍ବୁଲ୍‍କା ଆଇନା ଇଦ୍ ମିଇ ସ୍ୱର୍ଗସ୍ଥ ବାବାଲ୍ ଇଶ୍ୱର୍ ଇଚ୍ଛା ଆତ୍‍କେ ଆୟନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ୱେରଣ୍ଡ୍ ତାମୁଣ୍ଡ୍‌ ଯଦି ନି ବିରୁଦ୍‍ତେ ବାତେଏ ଦଷମାଡ଼ିତନ୍, ଅନ୍‌ ଗାର୍‍ରେ ଆଞ୍ଜକେ ଦଷ ଅଂକିଙ୍କ୍‌ ତଶ୍‍ସିମୁଟ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିମ୍‍ ଇର୍‍ୱୁଡ଼୍ ୱେରଡ଼୍ ତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ ଇଦ୍ ମିଞ୍ଜିପାଟ୍ । ଯଦି ଅଣ୍ଡ୍‌ ନି ଗଟ୍ କେଞ୍ଜିତଣ୍ଡ୍, ନି ତାମୁଙ୍କ୍ ମେଣ୍ଡେ ଦର୍‍ସ୍‍କେ ପାର୍‍ଦ୍‍ତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ଯଦି ଅଣ୍ଡ୍‌ କେଞ୍ଜଣ୍ଡ୍, “ୱେରଙ୍କ୍ ବା ଇର୍‍ୱୁଡ଼୍ ନାରୁଙ୍କ୍ ଆସ୍ ଅନ୍‌ ଗାର୍‍ରେ ଆନୁଟ୍ । ମାନ୍‍ ଶାସ୍ତ୍ରତେ ବ୍ୟବସ୍ତାତେ ୱେରଣ୍ଡ୍ ବା ଇର୍‍ୱୁଡ଼୍ ସାକ୍ଷିନ୍‍ ମକତାଗ୍ ନି ଅବିଯଗ୍ ସତ୍ ଇଞ୍ଜ ପ୍ରମାନିତ୍ ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ଆଲେକେ ମିକା ଯଦି ଅଣ୍ଡ୍‌ ନି ଗଟିଙ୍କ୍ କେଞ୍ଜଣ୍ଡ୍, ଇ ବିଷୟ ଉପବାସ୍‍ତେ ମଣ୍ଡଲିତିଙ୍କ୍ କେଞ୍ଜ୍‍ପିତମ୍, ଆଗେକ୍ ବା ଅଣ୍ଡ୍‌ ଯଦି ମଣ୍ଡଲିତ୍ ଗଟ୍ କେଞ୍ଜଣ୍ଡ୍, ଆଲେକେ ଅଂକିଙ୍କ୍‌ ୱେରନ୍ କରଆଦାୟକାରି ବା ବିଜାତିୟ ଇଞ୍ଜ ଅନ୍‌ ତଡ଼୍ ସମ୍ପର୍କ ୱିଡ଼୍‍ସିମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ମିକ୍ ଇଦ୍‍ଗଟ୍ କେସ୍ ନେହେତୁତାନ୍, ମିଡ଼୍ ଇ ପୃତିବିତାଗ୍ ବାତ୍ ନିଶେଦ ମାଡ଼୍‍ତିଡ଼୍ ସ୍ୱର୍ଗତାଗ୍ ମିକା ଆଦ୍ ନିଜାମ୍‍ ଆଦ୍‍ତେ ନୁ ବେନ୍ ସେଙ୍ଗେ ନିମ୍‍ ପୃତିବିତାଗ୍ ଗଟ୍ ଇଦ୍‍ତି, ସ୍ୱର୍ଗତାଗ୍ ମିକା ଆଦ୍ ଆନୁମଦିତ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ମାତର୍ ଆସ୍‍ର ଆୟ୍‍ୟ, ପୃତିବିତାଗାଙ୍କ୍ ବେସୁଙ୍କ୍‍ ମିୟାଗାଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍ ଯେ ବାତେଆଇ ବିଷୟ୍‍ତେ ୱେରଡ଼୍ ମାନ୍‍ ଆସ୍ ଆଦିନ୍ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼ିତିଡ଼୍, ନା ସ୍ୱର୍ଗତେ ବାବାଲ୍ ନିୟାଦ୍ ଆଦେ ଇଚ୍ଛା ସାରେ ସତ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେଗେ ଇର୍‍ୱୁଡ଼୍ ବା ନାର୍‍ଗେ ନାରୁଡ଼୍ ନା ପେଦେର୍‍ତେ ଅଣ୍ଡୟ୍‌‍ତାଗ୍ ଆଦ୍‍ତଡ଼୍, ନାନ୍ ଆଗେ ମାନ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ଅନ୍‌ ଦିନ୍ ପିତର୍ ୱାସ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତାନ୍, “ପ୍ରବୁ ୱେରଣ୍ଡ୍ ନା ତାମୁଣ୍ଡ୍‌ ନା ବିରୁଦ୍‍ତେ ସେନେମାନ୍ ଦଷ୍ ମାଡ଼ମାତ୍‍କେ, ଅଂକିଙ୍କ୍‌ ନାନ୍ ବେସ୍‍ଦାମ୍ କ୍ଷମା ମାଡ଼ିତାନ୍ ? ବାତେଏ ସାତ୍‍ଦାମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ଜିସୁ କେତ୍‍ତାନ୍, “ଇଲ୍‍ଲେ ସାତ୍‍ଦାମ୍ ଆୟ୍‍ୟ । ସାତ୍‍ଦାମ୍ ସତୁରି ଗୁଣ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ସ୍ୱର୍ଗରାଜ୍ୟତେ ମେଣ୍ଡେ ୱେରଡ଼୍ ଗଟ୍ କେଞ୍ଜା । ଅଣ୍ଡ୍‌ ଦିନ୍ ରାଜାଲ୍ ଦାସଡ଼୍‍କିଙ୍କ୍ ହିସାବ୍‍ତେ ଇସାପ୍ ମାଡ଼ାଙ୍କ୍ ଏର୍କା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ଅଣ୍ଡ୍‌ ଇ ପାଡ଼୍‍ୟି ଆରାମ୍ ମାଡ଼୍‍ତେ ୱେଲେ ୱେରଙ୍କ୍ ସାକର୍‍ତିଙ୍କ୍ ପୟ୍‍ସ୍ ଅନ୍‌‍ପାକେ ତାତ୍‍ତଡ଼୍ । ଅଣ୍ଡ୍‌ ତାନାଗାଙ୍କ୍ ଲକ୍ଷ ଲକ୍ଷ ଡାବ୍‍କ୍ ଉଦାର୍ ଆସ୍ ମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ଉଦାର୍ ଦେହେତାଙ୍କ୍ ସେଙ୍ଗେ ଆ ନାରୁନାୱୁ ଆସର୍ ସମ୍ପତି ଇଲ୍‍ୱେ ମାତ୍‍ତେ । ଆଦିଙ୍କ୍ ଅନ୍‌ ମୁତେଙ୍କ୍ ନୁ ପିଲାଙ୍କ୍ ୱାମି ମିକା ଇଦାଙ୍କ୍ ରାଜାଲ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ଆଦ୍ ଚାକର୍ ରାଜାନ୍ ଡେକାନ୍ ମଦଲ୍ ରାଲି ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତ୍‍ତାନ୍, “ମେଣ୍ଡେ ସୁଦୁଟ୍ ଶକ୍ତିତେ ମାନ୍‍ ମଣିମା ନାନ୍ ନିୟାଦ୍ ସାରେ ଉଦାର୍ ଦେହେସିଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ରାଜାନ୍ ମନ୍‍ଦାଗ୍ ଦୟା ଆତ୍‍ତେ, ଆଦିଙ୍କ୍ ଉଦାର୍‍ତାଗାଙ୍କ୍ କ୍ଷମା ଇସ୍ ଅଣ୍ଡ୍‌ ଦାସଙ୍କ୍ ୱିଡ଼୍‍ସିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ଆ ନାରୁଡ଼୍ ଆଦାନ୍ ୱେଲେ ଅନାଗାଙ୍କ୍ ସୁଦୁଟ୍ ଉଦାର୍ ଆସ୍‍ମାନ୍ଦାନ୍ ମେଣ୍ଡେ ୱେରନ୍ ସେବକ୍‍ ତଡ଼୍ କାଇଲ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଅନ୍‌ ବଣ୍ଡ୍‍କ୍‍ତିଙ୍କ୍ ପଇସ୍ କେତ୍‍ତାନ୍, ‘ନାୟାଗ୍ କଞ୍ଜ୍ ଆସ୍‍ମାନ୍ଦାନ୍ ଉଦାର୍ ଡାବ୍‍କ୍ ଇମ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ଦ୍ୱିତିୟ ସେବକ୍‍ ଅନ୍‌ ଡେକାଙ୍କ୍ ପଇସ୍ କେତ୍‍ତାନ୍, “ବେସ୍‌କ୍ ଦିନା ମାନ୍‍, ନିୟାଉ ସାରେ ଡାବ୍‍କ୍ ହିଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“ବାତେଙ୍କ୍ ଇତ୍‍କେ ମୁନ୍‍ତନାଦ୍ ପ୍ରାର୍ତନା କେଞ୍ଜଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଉଦାର୍ ଦେହେନା ଯାକ ଅଂକିଙ୍କ୍‌ ଜେଲ୍‍ତାଗ୍ ୱାଟିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ଇଦ୍ ଗଟ୍‍ନା ଉଡ଼ି ବାଗାତଡ଼୍ ସେବକିଡ଼୍ ଗାଟି ଦାନ୍ଦେଆସ୍ ଆଞ୍ଜ୍ ବାତ୍ ଗଟେମ୍ ଆତ୍‍ତେ ଆଦ୍ ରାଜାଙ୍କ୍ କେସ୍‍ସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ରାଜାଲ୍ ମୁନେଙ୍କ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତେନଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତାନ୍, ଆର୍ ଅଯୋଗ୍ୟ ଦାସନି, ନିମ୍‍ ପ୍ରାର୍ତନା ମାଡ଼୍‍ନାଙ୍କ୍ ନାନ୍ ନିୟାଉ ସାରେ ଉଦାର୍ ୱିଡ଼୍‍ସିତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ନାନ୍ ବାଲାନ୍ ନି ସେଙ୍ଗେ ଦୟା ତଅତାନ୍, ନି ସେବକିଙ୍କ୍ ମିକା ଆଦେଲେକାମ୍ ଦୟା ମାଡ଼ାନାଦ୍ ନିୟାଦ୍ ମାତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“ରାଜାଲ୍ ଗାଟି କପାମ୍ ଆସ୍ ସାରେ ଉଦାର୍ ଦେହ୍‍ୱେ ଯାକ ଦଣ୍ଡ୍ ଆତ୍‍ତାଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ବନ୍ଦିଲନ୍ ରହସିତ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ଜିସୁ କେତାନାଦ୍ ତେର୍‍ସ୍ପାନ୍ କେତ୍‍ତାନ୍, “ମିଇ ବିରୁଦ୍‍ତେ ଦଷ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ତାମୁଣ୍ଡ୍‌ତିଙ୍କ୍‌ ଜିୱୁତେ କ୍ଷମା ହିମୁଟ୍, ଆଲେକେ ନା ସ୍ୱର୍ଗତେ ବାବାଲ୍ ମିକା ମିଇ ସେଙ୍ଗେ ଇଦ୍‍ଲେକାମ୍ ବ୍ୟବହାର୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜିସୁ ଆୱୁସାରେ ଗଟି କେସ୍ ତେର୍‍ତେ ପେର୍କେ ଗାଲିଲୀ ୱିଡ଼୍‍ସି ଯର୍ଦ୍ଦନ୍ ଚାଉଡ଼େତ୍‍ ମେଣ୍ଡନ୍ ପାକେ ଯିହୁଦା ନାର୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌ ପେର୍କେ ୱାତ୍‍ତଡ଼୍ ନୁ ଅନ୍‌ ନାର୍‍ଗେ ରଗିଡ଼୍‍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ପାରୂଶୀଡ଼୍ ଅନ୍‌ଗାରେ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ୀଇଦାଗ୍ ୱାଟାଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ମା ଦର୍ମତେ ନିୟମ୍‍ ଲେକାମ୍‌ ୱେରନ୍ ଯେ ବାତ୍‍ଆଇ କାରନ୍‍ ସେଙ୍ଗେ ତାନ୍ ମୁତେଙ୍କ୍ ୱିଡ଼୍‍ସିଦ୍‍ତନ୍ କି ?” ");
INSERT INTO kff_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଜିସୁ କେତ୍‍ତନ୍, “ଶାସ୍ତ୍ରତାଗ୍ କାର୍‍ୱିଡ଼୍ କି, ମୁନେଙ୍କ୍ ସୃଷ୍ଟି କର୍ତ୍ତାଲ୍ ମାନେଇ ନୁ ନାଟାଡ଼୍‍ତିଙ୍କ୍ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ଆସୁଙ୍କ୍ ଜିସୁ କେତ୍‍ତନ୍, ‘ଇଦିନ୍ ସେଙ୍ଗେ ମାନେଇ ତାନ୍’ ୟାୟ୍‍ ବାବାଙ୍କ୍ ୱିଡ଼୍‍ସି ତାନ୍ ମୁଦ୍‍ପାନ୍ ତଡ଼୍ କାଇଲିମାନ୍ତେ ନୁ ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍ ୱେରନ୍ ଇନା ମାନ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଅଡ଼୍‌ ମେଣ୍ଡେ ଇର୍‍ୱୁଡ଼୍ ଆୟ୍‍ୟଡ଼୍, ଅଡ଼୍‌ ମେଣ୍ଡେ ୱେରନ୍ ଇନା ମାନ୍‍ତଡ଼୍ । ବେନଡ଼୍‍କ୍ ଇଶ୍ୱର୍ କାଲ୍‍ପି ମିନ୍ଦେଣ୍ଡ୍, ନାରୁଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେରେ ୱେରେ ମାଡ଼ାନାଦ୍ ଟିକ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ପାରୂଶୀଡ଼୍ ମେଣ୍ଡେ କେତ୍‍ତଡ଼୍, “ଆଲେକେ ନାଟାଡ଼୍ ତିଙ୍କ୍ ୱିଡ଼୍‍ସିଦାଙ୍କ୍ ସେଙ୍ଗେ ମଶାଲ୍‌ ବାତ୍‍ତିଙ୍କ୍ କାଇଦେ ଏର୍‍ ବ୍ୟବସ୍ତା ମାଡ଼୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜିସୁ କେତ୍‍ତନ୍, “ମିଇ ହୃଦୟ୍‍ତେ କଷ୍ଟ ସେଙ୍ଗେ ମଶାଲ୍‌ ଆଦ୍ ଲେକାମ୍ ମାଡ଼ି ମାତ୍‍ତନ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ମୁନେଙ୍କ୍ ତିଆର୍ ୱେଲେ ଇଦ୍‍ଲେକାମ୍ ବ୍ୟବସ୍ଥା ଇଲ୍‍ୱେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ମାତର୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ ଯେ, ବେନ ଅନ୍‌ ମୁତେଙ୍କ୍ ବ୍ୟବିଚାର୍ କାରାପ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବାତ୍‍ତାୟି ଆଂକାର୍ ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେଅନ୍‌ ମୁତେଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆତ୍‍କେ, ଅଣ୍ଡ୍‌ ନିଜେ ବ୍ୟବିଚାର୍ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ଜିସୁନ୍ ଶିଷ୍ୟନଡ଼୍ କେତ୍‍ତଡ଼୍, “ମୁତେନ୍ ତଡ଼୍ ମାନେଇତାଦ୍ ଇଦ୍ ଲେକାମ୍ ସମ୍ପର୍କ ମାତ୍‍କେ, ଆଲେକେ ପେଣ୍ଡୁଲ୍ ଆଦାନାଦ୍ ସାୟେ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ଜିସୁ କେତ୍‍ତାନ୍, “ଇ ଶିକ୍ଷା ସାରେତଡ଼୍ ସେଙ୍ଗେ ଉଦ୍ଦିଷ୍ଟ ଆୟ୍‍ୟ । ଇଶ୍ୱର୍‌ତେ ତଡ଼୍ ବେନଡ଼୍‍କ୍ ଇଦ୍ କେସ୍‍ମିନ୍ଦେନ୍ ଆସ୍‍ମିନ୍ଦେ, ମାତର୍ ଅଡ଼୍‌ ଇଦ୍ ଗ୍ରହନ୍ ମାଡ଼େ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ନାର୍‍ଗେ ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାଇଦିଙ୍କ୍ ନାରୁଡ଼୍ ପେଣ୍ଡୁଲ୍ ଆସ୍ ମାନ୍‍ତଡ଼୍ । ବେସ୍‌କ୍ ତଡ଼୍ ଜନମ୍‍ତାଗାଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ସେଙ୍ଗେ ଅନୁପଯୁକ୍ତ, ବେସ୍‍କ୍‍ତଡ଼୍‍କିଙ୍କ୍ ନାରୁଡ଼୍ ଆଦେଲେକାମ୍ ମାଡ଼୍‍ତଡ଼୍, ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ସ୍ୱର୍ଗରାଜ୍ୟ ସେଙ୍ଗେ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆୟ୍‍ୟକଟ ମାତ୍‍ତନ୍ । ବେନଆଇ ଶିକ୍ଷାତେ ଅର୍ତ ବୁଜେମ୍ ଆଦୁତ୍‍ତେ, ଅଡ଼୍‌ ଆଦ୍ ଗ୍ରହନ୍ ମାଡ଼ିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ପିଲାନ୍ ପର୍‍ର କାୟ୍ ୱାଟି ପ୍ରାର୍ତନା ମାଡ଼ାଙ୍କ୍ ସେଙ୍ଗେ ବେସ୍‌କ୍ ତଡ଼୍ ନାରୁଡ଼୍ ପିଲାଙ୍କ୍ ଜିସୁନ୍ ପାକେ ତାତାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ଆଦ୍ ନାରୁଡ଼୍‍କ୍ ଶିଷ୍ୟନଡ଼୍ ଦମକ୍ ଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ କେତ୍‍ତାନ୍, “ପିଲାଙ୍କ୍ ନାୟା ୱାଦାଙ୍କ୍ ଇମୁଟ୍ । ଅଡ଼୍‌‍କ୍ ମନା ମାଡ଼୍‍ମାଟ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଡ଼୍ ସ୍ୱର୍ଗରାଜ୍ୟ ତେ ଅଦିକାରିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଅଡ଼୍‌‍ପରୁ କାଇୱାଟି ଆର୍ଶିବାଦ୍ ମାଡ଼୍‍ତେ ପେର୍କେ ଅଡ଼୍‌ ଆଗାଙ୍କ୍ ଆତ୍‍ତଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଅଣ୍ଡ୍‌ ଦିନ୍ ୱେରଣ୍ଡ୍ ପେକାଲ୍ ଜିସୁନ୍ ପାକେ ୱାସ୍ କେତ୍‍ତନ୍, “ଗୁରୁ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଲାବ୍ ମାଡ଼ାଙ୍କ୍ ସେଙ୍ଗେ ବାତ୍ ଲେକେତ୍‍ ମାଡ଼େ ୱେଇତିତ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ଜିସୁ ଅକିଂଙ୍କ୍‌ କେତ୍‍ତନ୍, “ସତ୍‍କାମ୍ ବିଷୟ୍‍ତେ ନାକିଂଙ୍କ୍ ବାତ୍‍ତିଙ୍କ୍ କେତୁତିନ୍ ? ଇଶ୍ୱର୍ କେ ସତ୍ । ଅନ୍‌ ଗଟ୍ ପାଲନ୍ ମାଡ଼୍‍କେ, ସାରେ ଦିନା ଲେକେତ୍‍ମାନ୍ଦ୍ ପାର୍‍ତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ଅଣ୍ଡ୍‌ କେତ୍‍ତାନ୍, “ବେନ୍ ସାରେ ଗଟ୍ ?” ଜିସୁ କେତ୍‍ତାନ୍, “ଆୱୁକାନାଦ୍ ମାଡ଼୍‍ମାଟ୍, ବ୍ୟବିଚାର୍ ମାଡ଼୍‍ମାଟ୍ । ଡଙ୍ଗ୍‍ମାଟ୍, ବେନନ୍ ବିରୁଦ୍‍ତେ ଅବିଯଗ୍ ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ୟାୟ୍‍ ବାବାଙ୍କ୍ ସନ୍‍ମାନ୍ ମାଡ଼ାଟ୍ ନୁ ମିଇ ଗାର୍‍ରେତଡ଼୍‍କ୍ ଆତ୍ମାତେ ପ୍ରେମ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ପେକାଲ୍ କେତ୍‍ତନ୍, “ଇଉସାରେ ଗଟି ପାଲନ୍ ମାଡ଼୍‍ତାନ୍ । ନାକିଂଙ୍କ୍ ମେଣ୍ଡେ ବାତେଏ ମାଡ଼ାନାଦ୍ ଦର୍‍କାର୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ଜିସୁଅଙ୍କ୍‌ ଉତ୍ତର୍ କେତ୍‍ତାନ୍, “ଯଦି ନିମ୍‍ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଦର୍‍କାନଙ୍କ୍ ଇଚ୍ଛା, ଅନ୍‌ ମିୟାଦ୍ ସାରେ ସମ୍ପତି ୱାମିମିକା ଡାବ୍‍କ୍ ଗରିବ୍‍ ନାରୁଡ଼୍‍କ୍ ଦାନ ମାଡ଼େ । ଆଲା ମାଡ଼୍‍କେ ନିମ୍‍ ସ୍ୱର୍ଗତାଗ୍ ସମ୍ପତି ଦର୍‍କିତ୍ ହାଉସାରେ ମାଡ଼ିମେଣ୍ଡେ ନା ପେର୍କେ ପେର୍କେ ୱାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ଆଦ୍ ପେକାଲ୍ କେଞ୍ଜି ମୁର୍‍ମୁରା ଆସ୍ ଆତ୍‍ତନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ବେଡ଼ିଇ ସାଉକାର୍ ମାତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କ୍ କେତ୍‍ତନ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ସାଉକାର୍ ନାରୁଡ଼୍ ସେଙ୍ଗେ ସ୍ୱର୍ଗତାଗ୍ ଆଦ୍‌ଦାଙ୍କ୍ ଗାଟି ତିପାଲ୍‍ତେ ବିଷୟ । ");
INSERT INTO kff_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ମେଣ୍ଡନ୍‍ଦାମ୍ କେସ୍‍ମିନ୍ଦେନ୍, ସୁଜ୍‌ବସ୍‍ ଇସ୍ ଉଟ୍ ଆଦାନ୍ ୱିଡ଼୍‍ସି ସାଉକାର୍ ନାରୁଡ଼୍ ସ୍ୱର୍ଗରାଜ୍ୟତା ଆତ୍‍ତାଙ୍କ୍ ଅଦିକ୍‌ କଷ୍ଟ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ଶିଷ୍ୟଡ଼୍ ଇଦ୍ କେଞ୍ଜି ବାକ୍‍ୱା ଆସ୍ କେତ୍‍ତଡ଼୍, “ବେନ୍ ଆଲେକେ ମୁକ୍ତି ପାଏମ୍ ଆଦ୍‍ତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜିସୁ ଅଡ଼୍‌‍ପାକେ ଉଡ଼ି କେତ୍‍ତନ୍, “ନାରୁଡ଼୍ ମୁନେ ଇଦ୍ ସତ୍ ଆଦେପାର୍‍ୱ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ ମୁନେ ସାରେ ମିକା ସତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ଆଦ୍ କେଞ୍ଜି ପିତର୍ କେତ୍‍ତନ୍, “ଉଡ଼େ, ମାମ୍‍ମେ ସାରେ ୱିଡ଼୍‍ସି ନି ପେର୍କେ ୱାଦ୍‍ତମ୍ । ମାକିଂଙ୍କ୍ ବାତେଏ ଦର୍‍କିତ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜିସୁ ଉତ୍ତର୍ କେତ୍‍ତନ୍, “ଇଦ୍ ଗଟ୍ ସତ୍ ଇଞ୍ଜ୍ ଆଲ୍‍ସି ତିଡ଼୍, ପୁଃନେ ଯୁଗ୍‍ତେ ବେସୁଙ୍କ୍‍ ନାରୁଡ଼୍‍ପିଲେ ଅନ୍‌ ଗୌରବ୍ ସିଂହାସନ୍‍ତାଗ୍ କୁଦିତିତନ୍, ଆସୁଙ୍କ୍ ନାୟାଦ୍ ଇ ବାରଜାନ୍ ଶିଷ୍ୟମିକା ବାର୍‍ଟାନ୍ ସିଂହାସନ୍‍ତାଗ୍ କୁଦି ଇଶ୍ରାଏଲ୍‍ତେ ବାର୍‍ଟାନ୍ ନାର୍‍କିନ୍ ପର୍‍ର ରାଜତ୍ୱ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ବେନଡ଼୍ ନା ସେଙ୍ଗେ ନିଜେତ୍ ଲୋନ୍‌, ତାମୁଣ୍ଡ୍‌ ଏଲାସ୍କ୍‌, ୟାୟବାବାଲ୍, ପିଲାଜିଲା ନୁ ବୁମ୍‍ନେଲ୍ ୱିଡ଼୍‍ସିତଡ଼୍, ଅଡ଼୍‌ ଆୱୁ ଶହେଗୁନ୍ ଦର୍‍କିତ୍; ମେଣ୍ଡେ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ମିକା ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“ଇଞ୍ଜେ ବେନଡ଼୍ ମୁନେ ମିନ୍ଦେ, ଅଡ଼୍‌‍ଆଗାଙ୍ଗ୍ ନାର୍‍ଗେ ପେର୍କେ ୱାଦ୍‍ତଣ୍ଡ୍ ନୁ ବେନଡ଼୍ ମୁନେ ମିନ୍ଦେ, ଅଡ଼୍‌ ତାଗାଙ୍କ୍ ନାର୍‍ଗେ ମୁନେ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ସ୍ୱର୍ଗରାଜ୍ୟ ବେଲାନ୍, ହିଦିନାଦ୍ ୱେରଡ଼୍ ୱେଷଡ଼୍ କେଞ୍ଜାଟ୍ । ୱେରଣ୍ଡ୍ ନାରୁନ୍ ଅନ୍‌‍ଦିନେ ନାର୍‍କୁକ୍ ତାନ୍ ଅଙ୍ଗୁର୍ ୱାୟେତା ପାଡ଼୍‍ୟି ମାଡ଼ାନ୍ ସେଙ୍ଗେ କୁଲିକିଙ୍କ୍ ତାତାଙ୍କ୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ବେନଡ଼୍‍କ୍ ଦର୍ସକ୍‍ତନ୍, ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଦୈନିକ ୱେରଲାକା ରୁପାଡାବ୍‍କ୍ ହିଦାଙ୍କ୍ ଚୁକ୍ତି ମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅନ୍‌ ୱାୟେତା ରହସିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ତାନ୍ ମେଣ୍ଡନ୍ ଦିନ୍ ନଅଟାତିଙ୍କ୍ ହାଟିନା ଆଞ୍ଜ୍ ଉଡ଼୍‍ତନ୍, ମାନ୍ଦେନାରୁଡ଼୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ୱେ କନ୍‍ସ୍ ନିସ୍‍ମିନ୍ଦେଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ଅଡ଼୍‌‍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତାନ୍, ମିଡ଼୍‍ଆନ୍‌ନ୍ତେ ନା ୱାୟେତା ଆଞ୍ଜ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାଟ୍, ମିକିଂଙ୍କ୍ ଟିକ୍ ମଜୁରି ହିଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ଅଡ଼୍‌ ଆଞ୍ଜ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ଅଣ୍ଡ୍‌ ଦିନ୍ ବାର୍‍ଟା ନୁ ତିନ୍‍ଟାତିଙ୍କ୍ ଟିକ୍ ଆଦେଲେକାମ୍ ମେଣ୍ଡେ ବେସ୍‌କ୍ କୁଲିଙ୍କ୍ ତାସ୍ ପାଡ଼ିୟିଦାଗ୍ କାଲ୍‍ପ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ପାୟାଲ୍ ଅଲ୍ ପାଞ୍ଚଟା ତିଙ୍କ୍ ମେଣ୍ଡନ୍ ଦାମ୍ ହାଟିନା ଆଞ୍ଜ୍ ଉଡ଼୍‍ତନ୍, ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନିସ୍‍ମିନ୍ଦେଡ଼୍ । ଅଡ଼୍‌‍କ୍ କେତ୍‍ତାନ୍, ପାୟାଲ୍ ପଡ଼୍‍ଗିନ୍ ପାଡ଼୍‍ୟି ମାଡ଼କଟ୍ ବାତ୍‍ତିଙ୍କ୍ ଇଗେ ଦିନାମ୍ ନଷ୍ଟ ମାଡ଼ୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, ବେନ ତ ମାକିଂଙ୍କ୍ ପାଡ଼୍‍ୟିଦିଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ଗଡ଼୍ । ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତାନ୍, “ଆଲେକେ, ମିଡ଼୍ ସାରେତଡ଼ି ନା ୱାୟେତାଗ୍ ଆଞ୍ଜ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ଆଦ୍‍ଦିନେ ମୁଲ୍‍ପୁଟ୍ ୱାୟେତାଗ୍ ମାଲିକ୍ ଗୁମାସ୍ତାଲ୍ କେତ୍‍ତାନ୍, ‘କୁଲିକିଙ୍କ୍ କାର୍‍ଙ୍ଗାଟ୍ । ବେନଡ଼୍ ସାରେତାଗାଙ୍କ୍ ପେର୍କେ ପାଡ଼୍‍ୟି ଦାଗ୍ ୱାତ୍‍ତଡ଼୍, ମୁନେ ଅଡ଼ାୱୁ ଡାବ୍‍କ୍ ଇମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ବେନଡ଼୍ ସାରେତିଙ୍କ୍ ମୁନେ ପାଡ଼ିୟିମାଡ଼ାଙ୍କ୍ ୱାୟେତାଗ୍ ୱାତ୍‍ତଡ଼୍, ଅଡ଼ାୱୁ ଡାବ୍‍କ୍ ପେର୍କେ ଇମୁଟ୍ । ପର୍‍ରତ୍ ଅଲ୍ ପାଞ୍ଚଟା ତିଙ୍କ୍ ବେନଡ଼୍ ପାଡ଼୍‍ୟି ତାଗ୍ କାଇଲ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାରେତଡ଼୍ ୱେର୍‍ର ଲାକା ରୁପା ମୁଦ୍ରା ହିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ବେନଡ଼୍ ମୁନେଙ୍କ୍ କଞ୍ଜ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାନଡ଼୍‍କ୍, ଅଡ଼୍‌ ଆଲ୍‍ସ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଦିକ୍‌ ଡାବ୍‍କ୍ ଦର୍‍କିତ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌‍କ୍ ଆନ୍‌‍ତେ ୱେରକେ ରୁପାଡ଼ାବ୍‍କ୍ ଦର୍‍କ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ସାରେତଡ଼୍ ଆଞ୍ଜ୍ ମାଲିକ୍ ବିରୁଦ୍ଦ୍‌ତେ ଗଟି କେତାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ପରତ୍‍ଅଲ୍ ପାଞ୍ଚଟା ତିଙ୍କ୍ ପାଡ଼୍‍ୟି ଆରାମ୍ ମାଡ଼ିମାନ୍ଦାନ୍ କୁଲିକିଙ୍କ୍ ମାତର୍ ୱେରଡ଼୍ ଗାଣ୍ଟା ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଡ଼୍ । ମାମ୍‍ମେ ବେସର୍ ଏଦ୍‍ତେ ଦିନ୍‍ଯାକ କଷ୍ଟ ଆତ୍‍ତମ୍, ମଜୁରି ହିଦାନ୍ ୱେଲେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମା ସାମାନ୍ ହିତ୍‍ତିନ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ମାଲିକ୍ ଅଡ଼୍‌ ତାଗାଙ୍କ୍ ୱେରଙ୍କ୍ କେତ୍‍ତାନ୍, ନାନ୍ ମିକିଂଙ୍କ୍ ବୁସାମାଡ଼ନ୍ । ଅଣ୍ଡ୍‌ ଦିନ୍ ଯାକ ପାଡ଼୍‍ୟି ମାଡ଼୍‍କେ ୱେରଡ଼୍ ଡାବ୍ ଆସ୍ ପାଡ଼ିୟିମାଡ଼ାଙ୍କ୍ ମିଡ଼୍ ସାରେତଡ଼ି ତ ରାଜି ଆସ୍ ୱାତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ମିଡ଼୍ ଆଉ ଡାବ୍‍କ୍ ଆସ୍ ଲନ୍ଆନୁଟ୍ । ମିକିଂଙ୍କ୍ ବାତ୍ ହିତ୍‍ତାନ୍, ଅନ୍‌ ଗାଣ୍ଟା ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତେ ନାରିଙ୍କ୍ ଆସର୍ ହିଦାଙ୍କ୍ ନାୟାଦ୍ ଇଚ୍ଛା । ");
INSERT INTO kff_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ନିଜେତ୍ ସମ୍ପତିତିଙ୍କ୍ ନିଜେତ୍ ଇଚ୍ଛାତେ ଲେକେତ୍‍ ମାଡ଼ାଙ୍କ୍ ବାତେଏ ନାୟାଦ୍ ଅଦିକାର୍‌ ଇଲ୍‍ଲେ ? ଇଲା ନାନ୍ ସୁଦୁଟ୍ ଦୟା ମାଡ଼ୁତାନ୍ ଇଞ୍ଜ୍ ମିଡ଼୍ ଆଂକାର୍ ଆଦୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ଆଦ୍ ୱେଷଡ଼୍ ତେର୍‍ସ୍‍ପି ଜିସୁ କେତ୍‍ତାନ୍, “ବେନଡ଼୍ ଇଞ୍ଜେ ପେର୍କେ ମିନ୍ଦେ ଅଡ଼୍‌ ମୁନେ ୱାଦ୍‍ତଣ୍ଡ୍ ନୁ ବେନଡ଼୍ ମୁନେ ମିନ୍ଦେ, ଅଡ଼୍‌ ପେର୍କେ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜିସୁ ଜିରୁଶାଲମ୍‍ତା ଆଦାନ୍ ଆର୍‍ଦାଗ୍ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍‍କ୍ ଅଣ୍ଡୟାଗେ କାର୍‍ଙ୍ଗି ଅସ୍ ୱେରଡ଼୍ ଦାମ୍ କେତ୍‍ତନ୍, ");
INSERT INTO kff_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“କେଞ୍ଜାଟ୍ ମାନାଡ଼୍ ଯିରୁଶାଲେମ୍ ତା ଆଦୁତାଡ଼୍ । ଆଗେ ମୁକ୍ୟ ଯାଜକ୍ ନୁ ଦର୍ମଗୁରୁନଡ଼୍ ଅଂକିଙ୍କ୍‌ ଡଲାନ୍ ଦଣ୍ଡ୍ ହିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ଅଡ଼୍‌ ନାକିଂଙ୍କ୍ ଡଲାନ୍ ଦଣ୍ଡ୍ ହିଦ୍‍ତଡ଼୍ ନୁ ବିଜାତିୟ ଅଣଯିହୁଦିଡ଼୍ କାଇଦେ ୱିଡ଼୍‍ସିଦ୍‍ତଡ଼୍ । ବିଜାତିଡ଼୍ ଅଂକିଙ୍କ୍‌ ପରିହାସ୍ ମାଡ଼ିତଡ଼୍, କରଡ଼ାତଡ଼୍ ରେହେତିତଡ଼୍ ନୁ କ୍ରୁଶତାଗ୍ ତାର୍ପିତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ମୁଣ୍ଡ୍‍ଦିନାନ୍ ପେର୍କେ ପେର୍କେ ମେଣ୍ଡେ ଜିୱେ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ଆଦ୍ ସମୟ୍‍ତେ ଜେବଦିନ୍ ମୁତ୍‍ତେ ତାନ୍ ରେଣ୍ଡେ ପିଲାନ୍ ତଡ଼୍ ଜିସୁନ୍ ପାକେ ୱାତ୍‍ତେ । ଜିସୁଙ୍କ୍ ପ୍ରଣାମ୍ ମାଡ଼ି ଅଂକିଙ୍କ୍‌ ଅନୁଗ୍ରହ ତାଲ୍‍କ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଜିସୁ ତାଙ୍କ୍ କେତ୍‍ତାନ୍, “ବାତେଏ ଇଚ୍ଛା ମାଡ଼ୁତିନ୍ ?” ଆଦ୍ କେଲ୍‌ଲା, “ନିମ୍‍ ବେସୁଙ୍କ୍‍ ରାଜାନି ଆଦ୍‍ତିଡ଼୍, ନା ଇ ରେଣ୍ଡ୍ ପିଲାଙ୍କ୍ ନି ଡେବେ ପାକେ ନୁ ତିନ୍ଦେ ପାକେ କୁସ୍‍ପାଙ୍କ୍ ନିମ୍‍ ନାକ୍ ଗଟ୍‍ଇମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ଜିସୁ ଜେବଦିନ୍ ପିଲାଙ୍କ୍ ଉତ୍ତର୍ ଇସ୍ ତାଙ୍କ୍ କେତ୍‍ତାନ୍, “ନିମ୍‍ ବାତେଏ ତାଲ୍‍କୁତିନ୍, ନାନ୍ ବୁଜେମ୍ ଆୟନ୍ । ନାନ୍ ବେନ୍ ଦୁଃକାମ୍ ତେ ପାନପାତ୍ର ଉନ୍ଦାଙ୍କ୍ ଆଦୁତାନ୍, ମିଡ଼୍ ବାତେଏ ଆଦିଙ୍କ୍ ଉନ୍ଦେ ପାର୍‍ତିଡ଼୍ ?” ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ହୋ ପାର୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତାନ୍, “ବାସ୍ତବିକ ମିଡ଼୍ ନାୟାଦ୍ ଆଦ୍ ପାନପାତ୍ର ତାଗାଙ୍କ୍ ଉନ୍ଦ୍‍ତିଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ତିନ୍ଦେପାକେ ବା ଡେବେପାକେ କୁଦାନ୍ ସେଙ୍ଗେ ବେନଙ୍କ୍ ହେଞ୍ଚି ମାଡ଼ମାନ୍ଦାନ୍‌ ଅଦିକାର୍‌ ନାୟାଦ୍ ଇଲ୍‍ଲେ । ବେନଡ଼୍ ସେଙ୍ଗେ ନା ବାବାଲ୍ ଆଦ୍ ପଡ଼ିୟେ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ଆଦ୍ ମାତର୍ ଅଡ଼୍‌ ସେଙ୍ଗେ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ବେସୁଙ୍କ୍‍ ବାଗାତଡ଼୍ ଶିଷ୍ୟଡ଼୍ ଇଦ୍ ଗଟ୍ କେଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌ ତାମୁଣ୍ଡ୍‌ ଇର୍‍ୱୁଡ଼୍ ପର୍‍ର କପାମ୍ ଆତ୍‌ତଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ି କେତ୍‍ତନ୍, “ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍, ଇ ଜଗତ୍‍ତେ ରାଜାନଡ଼୍ ବିଜାତିଡ଼୍ ପର୍‍ର ପ୍ରବୁନ୍‍ଲେକାମ୍ ବିଚାର୍ ମାଡ଼ମାନ୍‍ତଡ଼୍ ନୁ ବେଡ଼ିଇ ନେତ୍‍ତାନଡ଼୍ ମିକା ବାଗାତଡ଼୍ ପର୍‍ର ଶାସନ୍‍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ମିଇ ଲୋପେ ଆଦ୍‍ଲେକାମ୍ ଆୟ୍‍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଇ ଲୋପେ ବେନ ବେଡ଼ିୟନ୍ ଆତ୍‍ତାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିଇ ଦାସ ଲେକାମ୍ ଆୟିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ମିୟାଗାଙ୍କ୍ ୱେରନ୍ ବେଡ଼୍‍ୟନ୍ ଆତ୍‍ତାଙ୍କ୍ ଆଲ୍‍ସ୍‍କେ, ଅଣ୍ଡ୍‌ ବାଗାତଡ଼୍ ଦାସ ଆଦ୍‍ତନ୍ । ମିୟାଗାଙ୍କ୍ ବେନ ମହାନ୍ ଆତ୍‍ତାଙ୍କ୍ ଆଲ୍‍ସିତନ୍, ଅଣ୍ଡ୍‌ ମିଇ ଦାସ ଆୟ୍‍ୟଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ବେଦ୍‍ଲେକାମ୍ ନାରିନ୍ ପିଲେ ସେବା ଆଦାନ୍ ସେଙ୍ଗେ ୱାଡ଼ଣ୍ଡ୍ ସେବାମାଡ଼ି ବାଗାତଡ଼ାଉ ମୁକ୍ତି ସେଙ୍ଗେ ନିଜେତ୍ ଜିୱୁନ୍‍ ହିଦାଙ୍କ୍ ୱାତ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ଅନ୍‌ ଦିନ୍ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍ତଡ଼୍ ଯିରୀୟ ସହର୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ଆଦାନ୍ ୱେଲେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌ ପର୍କେ ପେର୍କେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ରଟ୍ ଆଞ୍ଚିନା କୁଦିମାନ୍ଦାନ୍ ଇର୍‍ୱୁଡ଼୍ କାନାଲଡ଼୍, ଜିସୁ ଆଦ୍‍ଆର୍ ୱାଦୁତନ୍ ଇଞ୍ଜ କାନାଲଡ଼୍ କେଞ୍ଜି ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କାର୍‍ଙ୍ଗୁତଡ଼୍ “ହୋ ପ୍ରବୁ, ଦାଉଦ୍‍ ତେ ମାର୍‍; ମାକିଂଙ୍କ୍ ଦୟା ମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ନାରୁଡ଼୍ ଅଡ଼୍‌‍କ୍ ଦମକ୍ ଇସ୍ କଟ ଆତ୍‍ତାଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ମେଣ୍ଡେ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କାର୍‍ଙ୍କ୍ ତଡ଼୍, “ଦାଉଦ୍‍ତେ ମାର୍‍; ମାକିଂଙ୍କ୍ ଦୟାମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ଜିସୁ ଆଗେନିସ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତାନ୍, “ନାନ୍ ମିଇ ସେଙ୍ଗେ ବାତେଏ ମାଡ଼ିତାନ୍ ଇଞ୍ଜ ଆଲ୍‍ସୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ପ୍ରବୁ ମାକିଂଙ୍କ୍ ଉଡ଼ାନ୍ ଶକ୍ତି ଇମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ଜିସୁ ଦୟାତେ ବିଗଲିତ ଆସ୍ ଅଡ଼୍‌ କଣ୍ଡାଙ୍କ୍ ଇଟ୍‍ତଣ୍ଡ୍ । ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଡ଼୍‌ ଉଡ଼୍‌ତଡ଼୍ ନୁ ଜିସୁନ୍ ପେର୍କେ ପେର୍କେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଯିରୁଶାଲେମ୍ ତେ ଗାର୍‍ରେହେଉସ୍ ବେତ୍‍ପାଗୀ ସହର୍ ସୁଦୁଟ୍ ଯେକା ମାନ୍ଦାନ୍ ଜୀତ ମେଟେତାଗ୍ ହେଉତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ଇର୍‍ୱୁଡ଼୍ ଶିଷ୍ୟଡ଼୍‍କ୍ ଆଦେଶ୍ ଇସ୍ ଜିସୁ କେତ୍‍ତାନ୍, “ମୁନେ ମାନ୍ଦାନ୍ ଆଦ୍ ନାର୍ ଆନୁଟ୍ । ଆଗେ ହେଉଦାନ୍ ୱେଲେ ଉଡ଼ିତିଡ଼୍, ୱେରଡ଼୍ ଗଦ ତହସ୍ ମାନ୍‍ତଡ଼୍ ନୁ ତାନ୍ ଗାର୍‍ରେ ତାନ୍ ପିଲେ ମିନ୍ଦେ । ଆଦିଙ୍କ୍ ଲେସ୍ ନା ପାକେ ତାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ବେନ ବାତେଏ କେତ୍‍କେ, କେତିତିଡ଼୍ ଇଦ୍ ଗୁରୁଙ୍କ୍ ଦର୍‍କାର୍ ମିନ୍ଦେ । ଆସୁଙ୍କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରସିତ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ହି ଗଟ୍‍ନା ତଡ଼୍ ବାବବାଦୀଡ଼୍ ମଦଲ୍ କେତ୍‍ତାଦ୍ ବାଣି ସାରେ ହାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିୟନ୍‍ତେ କନ୍ୟାୟାତିଙ୍କ୍ କେଲ୍‍ମୁଟ୍ । ଉଡ଼ାଟ୍, ମିଇ ରାଜାଲ୍ ମିଇ ପାକେ ୱାଦୁତନ୍, ଅଣ୍ଡ୍‌ ବେସର୍ ନମ୍ର ଗଦପିଲେତ୍‍ ପରୁକୁଦି ୱାଦୁତନ୍; ଉଡ଼ାଟ୍, ଅଣ୍ଡ୍‌ ଗଦପରୁ କୁଦି ୱାଦୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ଶିଷ୍ୟଡ଼୍ ଆଞ୍ଜ୍ ଜିସୁ କେତ୍‍ତେ ଲେକାମ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଗଦ ନୁ ତାନ୍ ପିଲେତିଙ୍କ୍ ତାସ୍ ନିଜେ ନିଜେତାଉ ସିଲେ ଗଦତ୍‍ ପରୁ ୱାଟି ଜିସୁଙ୍କ୍ କୁସ୍‍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ଆଗେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଜିସୁ ଆଦାନ୍ ଆର୍‍ଦାଗ୍ ନିଜେ ନିଜେତ୍‍ତାଉ ସିଲେ ତାର୍‍ତଡ଼୍ ନୁ ବେସ୍‌କ୍ ତଡ଼୍ ହେତେଲ୍ ମାଡ଼େତ୍‍ ମେଟା ନାଡ଼୍‍କି ତାସ୍ ଆଦାନ୍ ଆର୍‍ଦାଗ୍ ୱାଟ୍‍ଟଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଜିସୁନ୍ ମୁନେ ନୁ ପେର୍କେ ଆଞ୍ଜମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଡ଼୍, “ଦାଉଦ୍‍ତେ ମାରିଙ୍କ୍ ପ୍ରସଂଶା ହାଇ, ବେନ ପ୍ରବୁନ୍ ପେଦେର୍‍ତେ ୱାଦୁତନ୍, ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଆର୍ଶିବାଦ୍ ମାଡ଼ିଣ୍ଡ୍ । ଇଶ୍ୱର୍‌ତେ ପ୍ରସଂଶା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଜିସୁ ଯିରୁଶାଲେମ୍ ହେଉଦାନ୍ ୱେଲେ ଆଗେ ଅଂକିଙ୍କ୍‌ ଉଡାଙ୍କ୍ ନାରୁଡ଼୍ ଗୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ନାରୁଡ଼୍ କେତ୍‍ତଡ଼୍, ଅଣ୍ଡ୍‌ ବେନ ? ବାଗାତଡ଼୍ କେତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ଆଦୁତନ୍, ଗାଲିଲୀତେ ନାଜରିତିୟ ବାବବାଦୀ ଜିସୁ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ଜିସୁ ମନ୍ଦିର୍ ଲୋପେ ଆଞ୍ଜ୍ ଆଗେ ଆସାନ୍ ୱାମାନ୍ ମାଡ଼ମାନ୍ଦାନ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ବାଇଦେ ପେସ୍ପିତନ୍ । ଡାବ୍‍କ୍ ବ୍ୟବସାହୀଡ଼୍‍ ବେଦି ନୁ ବଡେ ୱାମାନଡ଼୍ ମେଜତିଙ୍କ୍ ଉଲ୍‍ଟା ମାଡ଼ିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଅଡ଼୍‌‍କ୍ ଅନ୍‌ କେତ୍‍ତାନ୍, “ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ନା ମନ୍ଦିର୍ ପ୍ରାର୍ତନା ଲୋନ୍‌ ଇଞ୍ଜ୍ କ୍ୟାତ ଆଦ୍‍ତେ,’ ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଆଦିଙ୍କ୍ ଦସ୍ୟୁଡ଼୍ ଲୋନ୍‌ ଲେକାମ୍ ମାଡ଼୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ଜିସୁ ମନ୍ଦିର୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ କାନାଲଡ଼୍ ନୁ କୁଟାଲଡ଼୍‍କ୍ ଅନ୍‌ ପାକେ ୱାତ୍‍ତଡ଼୍ ନୁ ଜିସୁ ଅଡ଼୍‌‍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ବେଡ଼ିଇ ଯାଜକ୍ ନୁ ଦର୍ମଗୁରୁଡ଼୍ ଅନ୍‌ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ସାରେ ଉଡ଼ି ନୁ ପିଲାକି ଦାଉଦ୍‍ତେ ମାରିଙ୍କ୍‍ ପ୍ରସଂଶା ଇଞ୍ଜ୍ କେସମାନ୍ଦାନ୍ କେଞ୍ଜି କପାମ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ଇଡ଼୍ ବାତେଏ କେସମିନ୍ଦେଡ଼୍, ନିମ୍‍ କେଞ୍ଜୁତିନ୍ ?” ଜିସୁ କେତ୍‍ତାନ୍, “ନିଜାମ୍ କେଞ୍ଜୁତାନ୍ । ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଇଦ୍ ଗଟ୍ ବାତେଏ କାର୍‍ୱିଡ଼୍ ? ନିମ୍‍ ପିଲା ନୁ ସୁଦୁ ପିଲାଙ୍କ୍ ସାୟେଲେକାମ୍ ପ୍ରସଂଶା ମାଡ଼ାନ୍ ଶିକ୍ଷା ହିତ୍‍ତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଇଦ୍ କେସ୍ ଜିସୁ ଅଡ଼୍‌‍କ୍ ୱିଡ଼୍‍ସି ଯିରୁଶାଲେମ୍ ତାଗାଙ୍କ୍ ବେତନିୟାତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ଆଗେ ଅଣ୍ଡ୍‌ ନାର୍‍କା ତିଙ୍କ୍ ମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ତାନ୍ ମେଣ୍ଡନ୍ ଦିନ୍ ନାର୍‍କୁକ୍ ଜିସୁ ଯିରୁଶାଲେମ୍ ତା ଆଦାନ୍ ୱେଲେ ଗାଟି କାର୍‍ପୟିତେ । ");
INSERT INTO kff_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ଆର୍ ଗାର୍‍ରେ ୱେରଡ଼୍ ତୟାମାଡ଼ା ମାତ୍‍ତେ । ଜିସୁ ମାଡ଼େତ୍‍ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଆଗେ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବାତେଏ ଉଡ଼ନ୍ । ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ମାଡ଼େତିଙ୍କ୍ କେତ୍‍ତାନ୍, “ନିମ୍‍ ମେଣ୍ଡେ ବେସୁଙ୍କ୍‌ବା କାୟା ଆଦ୍‍ୱିନ୍ ।” ଆସୁଙ୍କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ତୟା ମାଡ଼ା ୱାସିଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ଶିଷ୍ୟଡ଼୍ ଆଦ୍‍ଉଡ଼ି ବାକ୍‍ୱା ଆସ୍ କେତ୍‍ତଡ଼୍, “ତୟା ମାଡ଼େ ହିସର୍ ଯାପେ ବେଲା ୱାସ୍‍ତେ ?” ");
INSERT INTO kff_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜିସୁ ଉତ୍ତର୍ କେତ୍‍ତାନ୍ “ନାନ୍ ନିକିଂଙ୍କ୍ ନିଜାମ୍‍ କେତୁତାନ୍, ମନ୍‍ତାଗ୍ ଇସୁର୍‍ମିକା ଏର୍କା ମାଡ଼କଟ୍ ସାରେ ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍, ନାନ୍ ଇ ତୟା ମାଡ଼େତ୍‍ ସେଙ୍ଗେ ବାତ୍‍ମାଡ଼୍‍ତାନ୍, ମିଡ଼୍ ମିକା ଆଲା ମାଡ଼େ ପାର୍‍ଦ୍‍ତିଡ଼୍ । ମାତର୍ ଆସର ଆୟ୍‍ୟ, ଇ ମେଟେ ତେଦିମିକା ସମୁଦ୍ର ତାଗ୍ ରାଲ୍ ଇଞ୍ଜ କେତ୍‍କେ, ଆଦ୍‍ମିକା ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ବିଶ୍ୱାସ୍‌ତେ ପ୍ରାର୍ତନାତାଗ୍ ବାତ୍ ତାଲ୍‍କିତିଡ଼୍ ଆଦ୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ଜିସୁ ମନ୍ଦିର୍ ତା ମାଲ୍‍ସ୍ ୱାସ୍ ଆଗେ ଶିକ୍ଷା ହିଦାନ୍ ୱେଲେ ବେଡ଼ିଇ ଯାଜକ୍ ନୁ ଯିହୁଦିନେତାନଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ବେନ୍ ଅଦିକାର୍‌‍ତେ ନିମ୍‍ ହିଉସାରେ ପାଡ଼୍‍ୟି ମାଡ଼ୁତିନ୍ ? ନିକିଂଙ୍କ୍ ଇ ଅଦିକାର୍‌ ବେନ ହିତ୍‍ତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜିସୁ କେତ୍‍ତାନ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ ମାତର୍ ୱେରଡ଼୍ ପ୍ରଶ୍ନ କେତିତାନ୍ । ତାନ୍ ଉତ୍ତର୍ ଇତ୍‍କେ, ନାନ୍ ବେନ୍ ଅଦିକାର୍‌‍ତେ ହିଉସାରେ ପାଡ଼୍‍ୟି ମାଡ଼ୁତାନ୍, ମିକିଂଙ୍କ୍ କେତିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ବାପ୍ତିସ୍ମ ଇଦାନ୍ ଯୋହନ୍‌ ବେନନାଗାଙ୍କ୍ ଶକ୍ତି ପାଏମ୍ଆତ୍‍ତନ୍ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ନା ନାରୁଡ଼ାଗାଙ୍କ୍ ?” ଅଡ଼୍‌ ତାମ୍ ତାମ୍ ଲୋପେ ହେର୍କା ମାଡ଼୍‍ତଡ଼୍, “ଇ ବିଷୟ୍‍ତେ ବାତେଏ କେତିକାଡ଼୍ ? ଯଦି କେତିକା ଇଶ୍ୱର୍ ତାଗାଙ୍କ୍, ଆଲେକେ ଯୋହନ୍‌ ତିଙ୍କ୍ ବାତ୍‍ତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ ଇଞ୍ଜ୍ ଅଣ୍ଡ୍‌ ମାନ୍‍ କେତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ନାରୁନାଗାଙ୍କ୍ ଇଞ୍ଜ୍ ଯଦି କେତିତାଡ଼୍‍, ଆଲେକେ ନାରୁଡ଼୍‍କ୍ ମାନାଙ୍କ୍‌ କାଲ୍‍କିନ୍ ତଡ଼୍ ରେହେତିତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯୋହନ୍‌ ୱେରନ୍ ବାବବାଦୀ ଇଞ୍ଜ୍ ଅଡ଼୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ଆଦ୍ ଏର୍କା ମାଡ଼ି ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, ମାମ୍‍ମେ ପୁନମ୍ । ଜିସୁ ଅଡ଼୍‌ କେତ୍‍ତାନ୍, “ବେନ୍ ଅଦିକାର୍‌‍ତେ ହିୱୁସାରେ ମାଡ଼ୁତାନ୍, ନାନ୍ ମିକା ମିକିଂଙ୍କ୍ କେଲନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ଆଲେକେ ଇ ବିଷୟ୍‍ତେ ମିଡ଼୍ ବାତେଏ ଆଲ୍‍ସୁତିଡ଼୍, କେଲ୍‍ମୁଟ୍ । ୱେରନ୍ ନାରୁନ୍, ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କ୍ ମାତ୍‍ତଡ଼୍ । ଅନ୍‌‍ଦିନେ ବେଡ଼୍‍ଇ ପେକାଙ୍କ୍ କେତ୍‍ତାନ୍, ବାବୁ ନେଣ୍ଡ୍ ମାନ୍‍ ଅଙ୍ଗୁର୍ ୱାୟେତାଗ୍ ଆଞ୍ଜ୍ ପାଡ଼୍‍ୟି ମାଡ଼େ । ");
INSERT INTO kff_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ଇଲା ନାନ୍ ମାଡ଼ନ୍, ଇଞ୍ଜ୍ ବେଡ଼ିଇ ପେକାଲ୍ କେତ୍‍ତାନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ତାନ୍ ପେର୍କେ ମନ୍‍ଦାଗ୍ ଏର୍କା ମାଡ଼ି ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ଆଦ୍ ନାରୁନ୍ ସୁଦୁନ୍ ପେକାଙ୍କ୍ ଆଦ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ କେତ୍‍ତାନ୍ । ଆଲେ ବାବା, ଆଦ୍‍ତନ୍ ଇଞ୍ଜ୍ ସୁଦୁନ୍ ପେକାଲ୍ କେତ୍‍ତାନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ପାଡ଼ିୟିଦାଗ୍ ମିକା ଆନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","କେଲ୍‍ମୁଟ୍ ଇର୍‍ୱୁଡ଼୍ ପେକଡ଼ାଗାଙ୍କ୍ ବେନ ତାମ୍ ବାବାନ୍ ଗଟ୍ କେଞ୍ଜ୍‍ତନ୍‍ । ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍‌ ବେଡ଼ିଇ ପେକାଲ୍ । ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତାନ୍, “ନାନ୍ କେତୁତାନ୍ କର ଆଦାୟ୍‍ ମାଡ଼ାନଡ଼ି ନୁ କଜାନଡ଼୍ ମିୟାଗାଙ୍କ୍ ମୁନେଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗ୍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ବାପ୍ତିଜିକ ଯୋହନ୍‌ ମିଇ ପାକେ ୱାସ୍ ସାୟେତ୍ ଆର୍ ତଅସିସ୍‍ ମାତ୍‍ତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ । ଆଗେକ୍ ବା କର ଆଦାୟ୍‍ ମାଡ଼ାନଡ଼ି ନୁ କଜାନଡ଼୍ ଅନ୍‌ ଗଟ୍‍ତେ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍, ଆଦ୍ ଉଡ଼ିମିକା ମିଡ଼୍ ମନ୍ ବାଦ୍‍ଲାମାଡ଼ି ଅଂକିଙ୍କ୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ଜିସୁ କେତ୍‍ତାନ୍, “ମେଣ୍ଡନ୍ ୱେଷଡ଼୍ କେଞ୍ଜାଟ୍ ।” ୱେରନ୍ ୱାୟେତ୍‍ ମାଲିକ୍ ତାନ୍ ୱାୟାନାଗ୍ ଅଙ୍ଗୁର୍ ଚାଷ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ୱେଲୁମ୍ କୁର୍‍ତନ୍ ନୁ ମାନ୍ଦାନ୍ ସେଙ୍ଗେ ୱେରଡ଼୍ ଗୁଡ଼ୁସା ମିକା ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ତାନ୍ ପେର୍କେ ୱାୟାନାଗାଙ୍କ୍ ଚାଷିନଡ଼୍‍କିଙ୍କ୍ ଦୁଡ଼େ ୱିଡ଼୍‍ଷିସ୍ ଅଣ୍ଡ୍‌ ବିଦେଶ୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ୱାୟେତାଗ୍ ପସଲ୍ ମାଡ଼ାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ଚାଷୀଡ଼୍ ଆଗାଙ୍କ୍ ନିଜେତ୍ ଦୁଡ଼େ ଆଦାୟ୍‍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ନିଜେତ୍ ଦାସଡ଼୍‍କ୍ ରହତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ଚାଷୀଡ଼୍ ଆଦ୍ ଦାସଙ୍କ୍ ୱେରଙ୍କ୍ ପିଞ୍ଜ୍‍ପ୍‍ତଡ଼୍, ୱେରଙ୍କ୍ ହାଉକିତାଡ଼୍‍ ନୁ ହେସିତ୍‍ତଡ଼୍, ମେଣ୍ଡ୍ଆର୍‍ତୁଙ୍କ୍ ପର୍‍ର କାଲ୍‍କ୍ ହେସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ଆଦିଙ୍କ୍ ୱାୟେତ୍‍ ମାଲିକ୍ ନାର୍‍ଗେ ମାନ୍ଦେ ବାଗାତ୍ ଚାକରିଡ଼୍‍କ୍ ମେଣ୍ଡ୍‍ନ୍ ଦାମ୍ ରହତନ୍ । ଅଡ଼୍‌‍କ୍ ମିକା ଚାଷୀନଡ଼୍‍କ୍ ଆଦେଲେକାମ୍ କାରାପ୍ ବ୍ୟବହାର୍‌ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ମାରିଙ୍କ୍ ଅଡ଼୍‌ ମାନେମ୍‍ ଆଦ୍‍ତଡ଼୍, ଆଦ୍ ଆଲ୍‍ସି ଅଣ୍ଡ୍‌ ତାନ୍ ମାରିଙ୍କ୍ ଅଡ଼୍‌‍ପାକେ ରହତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ମାତର୍ ଆଦ୍ ଚାଷୀଡ଼୍ ପେକାଙ୍କ୍ ଉଡ଼ି ତାମ୍ ତାମ୍ କେତ୍‍ତଡ଼୍, ଇଣ୍ଡ୍ ତ ମାଲିକ୍‍ତେ ମାର୍‍; ୱାଡ଼ାଟ୍ ଇଙ୍କ୍ ହାଉକିକାଡ଼୍‍ ମିକା ଇଣ୍ଡ୍ ଅଦିକାର୍‌ ମାନ୍‍ କାଇଦେ ମାଡ଼ିକାଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ଆଦ୍ କେସ୍ ଅଂକିଙ୍କ୍‌ ୱାୟେତାଗାଙ୍କ୍ ପେସ୍‍ପି ମିକା ବାଇଦେ ହାୱୁକିତାଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“କେଲ୍‍ମୁଟ୍ ତ, ୱାୟେତ୍‍ ମାଲିକ୍ ବେସୁଙ୍କ୍‍ ୱାଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ଚାଷୀନଡ଼୍‍କ୍ ବାତେଏ ମାଡ଼ିତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ଆଦ୍ ଦୁଷ୍ଟନଡ଼କ୍ ଅଣ୍ଡ୍‌ ନିଜାମ୍ ରେହେତିତନ୍ ନୁ ବେନ୍ ଚାଷୀନଡ଼୍ ଟିକ୍ ସମୟ୍‍ତେ ଅନ୍‌ ବାଗ୍ ଇଦ୍‍ତଡ଼୍, ୱାୟାଙ୍କ୍ ଅଡ଼୍‌ କାଇଦେ ୱିଡ଼୍‍ସିଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତାନ୍, “ଇଦ୍ ଶାସ୍ତ୍ରତେ ଗଟି ବାତେଏ କାର୍‍ୱିଡ଼୍ ? ଲକ୍ ମାଡ଼ାନଡ଼ି ବେନ୍ କାଲ୍‍ଦିଙ୍କ୍ ପାସ୍‍କି ମାତ୍‍ତଡ଼୍, ଆଦ୍ ମୁଲେ ବେଡ଼୍‍ୟାଦ୍‍ ପ୍ରସ୍ତର୍ ଆତ୍‍ତେ; ପ୍ରବୁନାଗଙ୍କ୍ ଇଦ୍ ଆତ୍‍ତେ, ମେଣ୍ଡେ ଆଦ୍ ମାନ୍‍ କଣ୍ଡେତେ ବେସର୍ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ?” ");
INSERT INTO kff_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ଜିସୁ ମେଣ୍ଡେ କେତ୍‍ତାନ୍, “ଆଦିଙ୍କ୍ କେତୁତାନ୍, ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତା ଆତ୍‍ତାଙ୍କ୍ ଅଦିକାର୍‌ ମିୟାଗାଙ୍କ୍ ଟେଣ୍ଡି ଆଦ୍‍ତଡ଼୍ ନୁ ବେନ୍ ନାର୍ ଇ ରାଜ୍ୟତେ ସାରେ ତଅତ୍‍ତେ ପାର୍‍ଦ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କ୍ ଆଦ୍ ହିଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ମେଣ୍ଡେ ବେନ ଇ କାଲ୍‍ଦାଗ୍ ପର୍‍ର ରାଲିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଦୁଡ଼ା ଦୁଡ଼ା ଆଦ୍‍ତନ୍, ମେଣ୍ଡେ ଇଦ୍ କାଲ୍ ବେନ ପର୍‍ର ରାଲିତ୍, ଅଂକିଙ୍କ୍‌ ଆଦ୍ ଗୁଣ୍ଡାଲ୍ ମାଡ଼ିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ବେଡ଼ିଇ ପୁରହିତ୍ ନୁ ପାରୂଶୀଡ଼୍ ଆଦ୍ ୱେଷଡ଼୍ ଗଟ୍ କେଞ୍ଜି ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଡ଼୍‍ତନ୍ ଇଞ୍ଜ୍ ପୁତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପଇଦାନ୍ ସେଙ୍ଗେ ଆଲ୍‍ସି ମାଡ଼୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁଡ଼୍‍କ୍ ୱେର୍‍ଙ୍ଗିଙ୍କ୍ ଅଡ଼୍‌ ଆଦ୍ ମାଡ଼୍ ପାର୍‍ୱଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ ୱେରଣ୍ଡ୍ ବାବବାଦୀ ଇଞ୍ଜ ଏର୍କା ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଜିସୁ ମେଣ୍ଡନ୍‍ଦାମ୍ ୱେଷଡ଼୍ ତଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶିକ୍ଷା ଇତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ବେଦ୍‍ପୁଟୁଙ୍କ୍, ତାନାଦ୍ ମେଣ୍ଡେ ୱେରଡ଼୍ ୱେଷଡ଼୍ କେଞ୍ଜାଟ୍ । ୱେରଡ଼୍ ଦିନ୍ ୱେରନ୍ ରାଜାଲ୍ ରାଜ୍‍କୁମାର୍‍ତେ ପେଣ୍ଡୁଲ୍‍ତେ ବଜି ମିଟିଙ୍କ୍ ମାଡ଼୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","କାର୍‍ଙ୍ଗି ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବଜିତାଗେ କାର୍‍ଙ୍ଗି ତାତାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଚାକରିଡ଼୍‍କ୍ ରହ୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ନାରୁଡ଼୍ ୱାଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ରାଜାଲ୍ ମେଣ୍ଡନ୍‍ଦାମ୍ ୱେରେ ଚାକରିଡ଼୍ ତଡ଼୍ ହି କବର୍ ରହ୍‍ତଣ୍ଡ୍, ପେଣ୍ଡୁଲ୍ ବଜି ତିଆର୍ ଆତ୍‍ତେ, ଲେକେତ୍‍ ମେନ୍ଦୁଲ୍‍ତେ କଅନ୍‌ଦା ନୁ ପେୟ୍‍ତିଙ୍କ୍ ହେଣ୍ଡି ସାରେ ମିଟିଙ୍କ୍ ଆସ୍‍ମିନ୍ଦେ, ବଜିତାଗେ ସିଟ୍‍ପାଟ୍ ୱାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ବାତେଙ୍କ୍ ଇତ୍କେ କାର୍‍ଙ୍ଗିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ହି ଗଟ୍ ତିଙ୍କ୍ ମନ୍ ହିୱକଟ୍ ନିଜେତ୍ ନିଜେତ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ୱେରଣ୍ଡ୍ ତାନ୍ ୱାୟାନା ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ଦୁକାନ୍‍ତା ଆତ୍‍ତଣ୍ଡ୍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ମେଣ୍ଡେ ବାଗାତଡ଼୍ ରାଜାନ୍ ଚାକରିଡ଼୍‍କ୍ ପୟ୍‍ସ୍ ରେହେସ୍ ଆୱ୍‍କିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ରାଜାଲ୍ କପାମ୍ ଆଶେ ସୌନ୍ୟଡ଼୍‍କିଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ଆଦ୍ ନରହନ୍ତାଲଡ଼୍‍କ୍‍ ହାୱ୍‍କି ଅଡ଼୍‌ ଶହର୍‍ତିଙ୍କ୍ କିସ୍ ପସ୍ପିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ତାନ୍ ପେର୍କେ ରାଜାଲ୍ ଚାକରିଡ଼୍‍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, “ପେଣ୍ଡୁଲ୍‍ତେ ବଜି ତିଆର୍ ଆତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ କାର୍ଙ୍ଗିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ୱାଡ଼ଡ଼୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ଇଞ୍ଜ୍ ବେଡ଼୍‍ୟା ସାହିକିନାଗ୍‍ ଆଞ୍ଜ୍ ବେସର୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଦର୍‍ସ୍କିତିଡ଼୍, ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ମାନ୍‍ ବଜିତାଗେ କାର୍‍ଙ୍ଗି ତାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ଆଦିଙ୍କ୍ ଚାକରିଡ଼୍ ସାହି ସାହିକିଙ୍କ୍ ଉଡ଼ି ଲେକେତ୍‍ଆଇ କି, କାରାପ୍ ଆୟି, ବେସର୍ ନାରୁଡ଼୍‍କ୍ ଦର୍‍ସ୍କ୍‍ତଡ଼୍, ସାରେତଡ଼୍‍କ୍ କାର୍ଙ୍ଗି ତାତ୍‍ତଡ଼୍ ନୁ ପେଣ୍ଡୁଲ୍‍ ଲନ୍‍ ବର୍ତ୍ତି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ରାଜାଲ୍ କୁଟ୍‍ମାମ୍‍ ଉଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ୱାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଉଡ଼୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ପେଣ୍ଡୁଲ୍‍ତେ ଚକାସିଲେ କେର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ରାଜାଲ୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍‍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ‘ସାଙ୍ଗ, ପେଣ୍ଡୁଲ୍ ଚକାସିଲେ କେର୍‍ୱକଟ ହିଗେ ବେଲା ୱାତ୍‍ତିନ୍ ?’ ନାରୁଡ଼୍ ଉତ୍ତର୍ ହିୱକଟ୍ କଟ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ରାଜାଲ୍ ଚାକରିଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, ‘ଅନ୍‌ କାୟ୍‍କ୍ ଡେକା ତହସ୍ ବାୟିଦେ ୱାଟିମୁଟ୍‍ । ଆଗେ ଅଣ୍ଡ୍‌ କେୟି ପାଲ୍‍କ୍ କର୍‍କିତଣ୍ଡ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ୱେଷଡ଼୍‍ ତେର୍‍ସ୍‍ପି ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ନାର୍ଗେମାନ୍ଦେ ୱାଦୁତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ସୁକୁକ୍‍ ମାନ୍ଦ୍ ବେସ୍‌କ୍ ତଡ଼୍ ହେଞ୍ଜ୍‍ତେନଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ପାରୂଶୀଡ଼୍ ଜିସୁଙ୍କ୍ ପ୍ରଶ୍ନ ପାଚ୍ରାମାଡ଼ି ଅଂକିଙ୍କ୍‌ ଉଡ଼୍‍ୟ୍‍ଦାଗ୍‍ ଆର୍‍ସ୍ପାନ୍‍ ମାଇଦିଙ୍କ୍ ଉପାୟ୍‍ ଆଲ୍‍ସ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ଅଡ଼୍‌ ନିଜେତ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ନୁ ହେରଦ୍ ପାକେ ବେସ୍କ୍‍ତଡ଼୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଜିସୁନ୍ ଗାର୍‍ରେ ରହ୍‍ତଡ଼୍ । ଇଡ଼୍ ୱାସ୍ ଜିସୁଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ଗୁରୁ, ମାମ୍ ପୁତ୍‍ତମ୍, ନିମ୍‍ ସତ୍ ଶିକ୍ଷା ହିଦୁତିନ୍‍ । ନିମ୍‍ ନାରୁନ୍ ପଦ ମର୍ଯ୍ୟାଦାତିଙ୍କ୍ କାତିର୍‍ ମାଡ଼୍‍ୱାଙ୍କ୍ ନାରୁଡ଼୍ ବାତେଏ ଆଲ୍‍ସିତିଡ଼୍, ଚିନ୍ତେ ମାଡ଼କଟ୍ ନାରୁଡ଼୍ ମାଇଦିଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ସଂକଳ୍ପ ନାର୍‍ଗେ ବୁଜାମାଡ଼୍‍ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ଆଲାଇତ୍‍କେ କେଲ୍‍ମ୍, ଇ ବିଷୟ୍‍ତେ ନିୟାଦ୍ ମତ ବାତେଏ ? ରୋମ୍‍ ସମ୍ରାଟ୍‍ତିଙ୍କ୍ କର ଇଦାନ୍ ମାଇଦିଙ୍କ୍ ଦର୍ମଶାସ୍ତ୍ର ନିୟମ୍‍ ଲେକାମ୍‌ତେ ଟିକ୍‍ କି ଇଲ୍‍ଲେ ?” ");
INSERT INTO kff_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଅଡ଼ାଦ୍‌ କୁଟ୍‍ ଲେକାମ୍ ପୁଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍ । ପେର୍କେ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଆୟେ ମୁର୍କଡ଼୍, ନାକିଂଙ୍କ୍ ଉଡ଼୍‍ୟ୍‍ଦାଗ୍‍ ଆର୍‍ସ୍ପାଙ୍କ୍ ବାତେଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ବେନ ମୁଦ୍ରାତେ କର ହିଦୁତିଡ଼୍, ଆଗାଙ୍କ୍ ୱେରଡ଼୍ ମୁଦ୍ରା ତାସ୍ ନାକିଂଙ୍କ୍ ତମୁଟ୍‍ । ଅଡ଼୍‌ ୱେରଡ଼୍ ମୁଦ୍ରା ତାସ୍ ଅଂକିଙ୍କ୍‌ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍‍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ହି ମୁଦ୍ରେତେ ପର୍‍ର ବେନନାଦ୍ ପେଦେର୍ ନୁ ଆଦ୍‍ରକମ୍ ଲେକ୍‍ତାଦ୍ ଆସ୍‍ମିନ୍ଦେ ?” ");
INSERT INTO kff_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ସମ୍ରାଟ୍‍ତାଦ୍‍ ।” ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଆଲାଇତ୍‍କେ ବେଦ୍ ସମ୍ରାଟ୍‍ତାଦ୍‍, ଆଦ୍ ସମ୍ରାଟ୍‍ତିଙ୍କ୍ ହିମୁଟ୍ ନୁ ବେଦ୍ ଇଶ୍ୱର୍‌ତାଦ୍‍, ଆଦ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ହିମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ହାଦ୍‍ କେଞ୍ଜି ଅଡ଼୍‌ ସୁୟ୍‍ମୁୟ୍‍ ଆଶେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ଆଦିନ୍ ସାଦୁକିଡ଼୍ ମାନ୍ଦେତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାତ୍‍ତଡ଼୍ । ସାଦୁକିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍ ଯେ, ମେଣ୍ଡେ ପୁନରୁତ୍‍ତାନ୍ ଇଲା । ");
INSERT INTO kff_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ଗୁରୁ, ମଶାଲ୍ ବ୍ୟବସ୍ଥା ମାଡ଼ିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ଯେ, ଯଦି ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ପିଲାଜିଲା ଆୟ୍‍ୟକଟ ଡଲିଆଦ୍‍ତଣ୍ଡ୍, ଆଲାଇତ୍‍କେ ଅନ୍‌ ତାମୁଣ୍ଡ୍‌ ଅନ୍‌ ରାଣ୍ଡି ମୁତେଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆଦ୍‍ତନ୍ ନୁ ଅଡ଼୍‌ ପିଲାକି ଆଦ୍ ଡଲିମାନ୍ଦାନ୍ ନାରୁନ୍ ପିଲାନ୍ ଲେକାମ୍ ଆଲେ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ୱେରଡ଼୍ ଗଟ୍ କେଞ୍ଜାଟ୍ । ଇଗେ ମା ସାତ୍‍ଟାନ୍ ଦାଦାଲଡ଼୍ ମାତ୍‍ତଡ଼୍ । ବେଡ଼୍‍ୟ୍ ଦାଦାଲ୍ ପିଲାଜିଲା ଇଲକଟ୍ ଡଲ୍‍ତାଙ୍କ୍ ଅନ୍‌ ଦ୍ୱିତିୟ ତାମୁଣ୍ଡ୍ ତାନ୍ ଦାଦାନ୍‍ ମୁତେଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇ ଦ୍ୱିତିୟ, ତୃତୀୟ ନୁ ସାରେ ଶେଷତେ ସାତ୍‍ଜାନ୍ ଦାଦାନାଦ୍‍ ମିକା ଆଦେରକମ୍ ଗଟେମ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ଶେଷତେ ଆଦ୍ ମୁତ୍‍ତେ ଆନ୍‌‍ତେ ଡଲିଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ବେନ୍ ଦିନ୍ ଡଲିମନ୍ଦାନ୍ ନାରୁଡ଼ାଦ୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଆଦ୍‍ତେ, ହି ମୁତ୍‍ତେ ବେନନ୍ ମୁତ୍‍ତେ ଇଞ୍ଜ ପୁନ୍ଦାଙ୍କ୍ ଆଦ୍‍ତେ ? ସାରେତଡ଼୍ ତ ତାଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆସ୍ ମାତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବେସର୍ ନଷ୍ଟ ! ଶାସ୍ତ୍ର ବା ଇଶ୍ୱର୍‌ତେ ଶକ୍ତି ବିଷୟ୍‍ତେ ମିକିଂଙ୍କ୍ ଟିକ୍ ଏର୍କା ହିଲ୍‍ୱାଙ୍କ୍ ହି ଗଟ୍ ପାଚ୍‍ରାମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ପୁନରୁତ୍‍ତାନ୍ ପେର୍କେ ଡଲ୍‍ତେ ନାରୁଡ଼୍ ଦୂତତେ ଲେକାମ୍ ଆଦ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ପେଣ୍ଡୁଲ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ଡଲ୍‍ତେ ନାରୁଡ଼୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଆଦ୍‍ଦାନ୍ ବିଷୟ୍‍ତେ ଇଶ୍ୱର୍ ବାତେଏ କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ମିଡ଼୍ ବାତେଏ ଶାସ୍ତ୍ରତାଗ୍ ବେସୁଙ୍କ୍‍ କାର୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ଇଶ୍ୱର୍ କେତ୍‍ତଣ୍ଡ୍, ମାମ୍‍ମେ ଅବ୍ରାହାମ୍‌, ଇସ୍‍ହାକ୍ ନୁ ଯାକୁବ୍‍ତେ ଇଶ୍ୱର୍ । ଇଶ୍ୱର୍ ତ ଜିୱୁନ୍ ମାନ୍ଦାନଡ଼୍ ଇଶ୍ୱର୍ ଡଲି ମାନ୍ଦାନ୍‍ନଡ଼୍‍ତେ ଇଶ୍ୱର୍ ଆୟ୍‍ୟକଟ ମାନ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ନାରୁଡ଼୍ ଜିସୁନ୍ ଶିକ୍ଷା କେଞ୍ଜି ବକୁୱା ଆତ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ବେସୁଙ୍କ୍‍ ପାରୂଶୀଡ଼୍ କେଞ୍ଜ୍‍ତଡ଼୍ ଯେ, ଜିସୁ ସାଦୁକିଡ଼୍‍କ୍‍ ଉତ୍ତର୍ ହିୱ୍‍ଲେକାମ୍‍ ମାଡ଼ିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍, ଅଡ଼୍‌ ଅଣ୍ଡୟ୍‌‍ ଆଶ୍ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାତ୍‍ତଡ଼୍ ");
INSERT INTO kff_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ଜିସୁଙ୍କ୍ ଉଡ଼୍‍ୟ୍‍ଦାଗ୍‍ ରାପାନ୍‍ ମାଇଦିଙ୍କ୍ ୱେରଡ଼୍ ପ୍ରଶ୍ନ ପାଚ୍‍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ଗୁରୁ, ମାନ୍‍ ଦର୍ମଶାସ୍ତ୍ରତେ ବ୍ୟବସ୍ଥାତାଗ୍‍ ବେନ୍ ଗଟ୍ ସାରେତିଙ୍କ୍ ବେଡ଼୍‍ୟାଦ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ମିଇ ପ୍ରବୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ସାରେ ହୃଦୟ୍, ସାରେ ଆତ୍ମା ନୁ ସାରେ ମନ୍‍ ଇସ୍‌ ପ୍ରେମ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ହିଦ୍ ଆଦୁତ୍‍ ସାର୍‍ରେ ବେଡ଼୍‍ୟାଦ୍‍ ନୁ ଲେକେତ୍ ଗଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ଦ୍ୱିତିୟ ଲେକେତ୍ ଗଟ୍ ଆଦୁତ୍‍, ମିଇ ଗାର୍‍ରେତଡ଼୍‍କିଂଙ୍କ୍ ଆତ୍ମାତଡ଼୍ ପ୍ରେମ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ହି ରେଣ୍ଡ୍ ଗଟ୍ ମୋଶାନ୍‌ ସାରେ ବ୍ୟବସ୍ଥାତେ ନୁ ବାବବାଦୀଡ଼୍ ଶିକ୍ଷାତେ ଗଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ବେସ୍‌କ୍ ତଡ଼୍ ପାରୂଶୀଡ଼୍ ଜିସୁନ୍ ଗାର୍‍ରେ ମାନ୍ଦାନ୍‍ୱେୟ୍‍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍‍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ମସିହନ୍‍ ବିଷୟ୍‍ତେ ମିଡ଼୍ ବାତ୍ ଆଲ୍‍ସୁତିଡ଼୍‍ ? ଅଣ୍ଡ୍‌ ବେନନ୍ ବଂଶତଣ୍ଡ୍ ?” ଅଡ଼୍‌ ଉତ୍ତର୍ ଇତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ଦାଉଦ୍‍ତେ ବଂଶତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜିସୁ ପାଚ୍‍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ଆଲାଇତ୍‍କେ ଦାଉଦ୍‍ ମସିହଙ୍କ୍ ‘ନା ପ୍ରବୁ’ ଇଞ୍ଜ ବାତେଙ୍କ୍ କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ? ପରମାଆତ୍ମାତେ ପ୍ରେରନାତେ ଅଣ୍ଡ୍‌ ଲେକିମିନ୍ଦେଣ୍ଡ୍,” ");
INSERT INTO kff_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ଇଶ୍ୱର୍ ନା ପ୍ରବୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ମାମ୍ ନି ଶତ୍ରୁଡ଼୍‍କ୍ ନି ଡେକେତ୍ ମଦଲ୍ ମାଡ଼୍‍ନା ଯାକ ନିମ୍‍ ମା ତିନ୍ଦେ ପାକେ କୁଦା ।” ");
INSERT INTO kff_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“ଯଦି ଦାଉଦ୍‍ ମସିହଙ୍କ୍ ପ୍ରବୁ ଇଞ୍ଜ ସମ୍ୱଦନ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ଆଲାଇତ୍‍କେ ମସିହ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ତାମ୍ ବଂଶତଣ୍ଡ୍ ଆଦ୍ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ଜିସୁଙ୍କ୍ ବେନ ହିଦିନ୍ ଉତ୍ତର୍ ହିଦ୍‍ପାର୍‍ୱଡ଼୍‍ । ଆଦ୍ ଦିନ୍‍କଞ୍ଚ୍‍ ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡେ ବାତେମେଣ୍ଡେ ପ୍ରଶ୍ନ ପାଚ୍ରାମାଡ଼ାଙ୍କ୍ ବେନ ବା ସାହାସ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ନୁ ଗୁଡ଼ିମାନ୍ଦାନ୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ଦର୍ମଗୁରୁ ନୁ ପାରୂଶୀଡ଼୍ ମୋଶାନ୍‌ ବ୍ୟବସ୍ଥାତାଗ୍‍ କ୍ୟମତା ପାହେମ୍‍ଆତ୍‍ତେ ବାକ୍ୟାକାରିଡ଼୍,” ");
INSERT INTO kff_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ବାତେଏ ମାଡ଼ାଙ୍କ୍ କେତୁତଡ଼୍, ଆଦ୍ ମାଡ଼ାଟ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ପାଡ଼ିୟିଦିଙ୍କ୍ ଏର୍କା ମାଡ଼୍‍ମାଟ୍ । ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ନିଜେ ହିସମାନ୍ଦାନ୍ ଶିକ୍ଷା ଲେକାମ୍‍ତେ ପାଡ଼୍‍ୟି ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ଅଡ଼୍‌ ନାରୁଡ଼୍ ମେନ୍ଦୁଲ୍‍ତେ ପର୍‍ର ଦୁର୍ବହ ବଜ୍ କାଞ୍ଜାନ୍ ମାଇଦିଙ୍କ୍ ନିଜେତ୍ ୱାଡ଼୍‍ଞ୍ଜ୍‍କିନ୍‍ତଡ଼୍‍ ସୁଦୁର୍ ଆନ୍‌‍ତେ ସାହାଯ୍ୟ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ଅଡ଼୍‌ ନାରୁଡ଼୍‍କ୍ ତଅତାନ୍ ମାଇଦିଙ୍କ୍ ନିଜେତ୍ ନିଜେତାଦ୍ ସାରେ ପାଡ଼୍‍ୟି ମାଡ଼ିତଡ଼୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ନିଜେତ୍ ନିଜେତ୍ କବଚ ଆସର୍ ମାଡ଼ିତଡ଼୍ ନୁ ଚକେତାଦ୍‍ ଜୁମୁକା ବେଡ଼୍‍ୟ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ମେଣ୍ଡେ ବଜିତାଗେ ବେଡ଼୍‍ୟ୍ ପଡ଼୍‍ୟି ନୁ ପ୍ରାର୍ତନା ଲତ୍‍ତାଗେ ବେଡ଼୍‍ୟାଦ୍‍ ମିଟିଙ୍କ୍‍ତାଗେ, ");
INSERT INTO kff_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ମେଣ୍ଡେ ହାଟିନାଗେ ନମସ୍କାର୍ ପାହେମ୍‍ଆଦାଙ୍କ୍ ନୁ ନାରୁଡ଼୍‍ତଡ଼୍ ଗୁରୁ ଇଞ୍ଜ ସମ୍ୱୋଦିତ ଆତ୍‍ତାଙ୍କ୍ ଅଡ଼୍‌ ଇଚ୍ଛା ଆଦ୍‍ତଡ଼୍ ଆଦୁତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଗୁରୁ ଇଞ୍ଜ ସମ୍ୱଦିତ ଆୟ୍‍ମାଟ୍‍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ମିଇ “ଗୁରୁ,” ୱେରଣ୍ଡେ ମେଣ୍ଡେ ମିଡ଼୍ ସାରେ ତାମୁଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ମେଣ୍ଡେ, ପୃତିବିତାଗେ ବେନଙ୍କ୍ ମେଣ୍ଡେ ବାବା ଇଞ୍ଜ ସମ୍ୱଦନ ମାଡ଼୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଇ ବାବାଲ୍ ୱେରଣ୍ଡେ, ସ୍ୱର୍ଗତାଗ୍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ମେଣ୍ଡେ, ମିଡ଼୍ ନେତା ଇଞ୍ଜ ସମ୍ୱଦିତ ଆୟ୍‍ମାଟ୍‍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଇ ନେତାଲ୍‍ ୱେରଣ୍ଡେ, ଅଣ୍ଡ୍‌ ମସୀହ । ");
INSERT INTO kff_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ମିଇ ଲୋପେ ଯେ ସାରେତଡ଼୍‍କ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିଇ ସେବା ମାଡ଼ିଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ମେଣ୍ଡେ, ବେନ ନିଜ୍‍ତିଙ୍କ୍ ଉନ୍ନତ ଇଞ୍ଜ ତହ୍‍ତିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ଆୱେକେ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍‍, ମେଣ୍ଡେ ବେନ ନିଜ୍‍ତିଙ୍କ୍ ମାଡ଼ିତନ୍, ଅଂକିଙ୍କ୍‌ ଉନ୍ନତ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ଆୟେ ଦର୍ମଗୁରୁ ନୁ ପାରୂଶୀଡ଼୍, ମିୟାଦ୍ ଶେଷ ଦଶା ବେସର୍ ବୟଙ୍କାର୍, ଆର୍ ଚଲ ଦାର୍ମିକ୍‍ମାନ୍ଦେ, ସର୍ଗରାଜ୍ୟତେ ଆସାନ୍ ଆର୍‍ଦିଙ୍କ୍ ବନ୍ଦ୍‍ ମାଡ଼ି ନେହେସ୍ ମିନ୍ଦେଡ଼ି । ନିଜେ ଆଦିନାଗେ ନେଙ୍ଗ୍‍ୱିଡ଼୍‍ ନୁ ବେନଡ଼୍ ନେଙ୍ଗାଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ୁତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆର୍ ୱିଡ଼୍‍ସିୱିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ହାୟ, ଦଣ୍ଡତେ ନାରୁଡ଼୍ ମୁର୍କ ଦର୍ମଗୁରୁ ନୁ ପାରୂଶୀଡ଼୍ ଦଣ୍ଡ୍ ସଶନିୟ, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଚଲତେ ନାର୍ଗେଜେଲ୍‍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ରାଣ୍ଡିକିନ୍‍ ଲକ୍‍ସାରେ ନଷ୍ଟ ମାଡ଼ୁତିଡ଼୍; ଆଦିଙ୍କ୍ ମିଡ଼୍ ଗୁରୁଦତେ ଦଣ୍ଡ୍ ଦର୍‍କିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ଆୟ୍‍ୟ, ଦଣ୍ଡତେ ନାରୁଡ଼୍ ମୁର୍କ ଦର୍ମଗୁରୁ ନୁ ପାରୂଶୀଡ଼୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଅର୍‍ତୁଙ୍କ୍ ମିଇ ଦର୍ମଲେଟ୍‍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଏର୍‍ଦେ ଗାର୍‍ରେ ଉଡ଼ ମାନ୍‍ତିଡ୍, ମେଣ୍ଡେ ବେସୁଙ୍କ୍‍ ଅଣ୍ଡ୍‌ ଆଦ୍‍ତନ୍, ଆସୁଟେ ଅଂକିଙ୍କ୍‌ ମିଇ ୱିଡ଼୍‍ସି ରେଣ୍ଡ୍ ଗୁଣ୍ ନର୍‍କ ପଡ଼ିୟେ ମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ଆର୍ କାନାଙ୍କ୍ ଆର୍‍ ତଅତାନଡ଼ି, ମିୟାଦ୍ ଦଶା ବେସର୍ ବୟଙ୍କାର୍ ଆଦ୍‍ତେ । ମିଡ଼୍ କେସମାନୁଟ୍ ଶିକ୍ଷା ହିସମାନ୍ତ୍‍ତିଡ଼୍‍, ବେନ ମନ୍ଦିର୍‍ତାଗ୍ ମାନ୍ଦାନାଦ୍ ସୁବର୍ଣ୍ଣ ପେଦେର୍‍ତେ ବେନ ପ୍ରତିଜ୍ଞା ମାଡ଼ିତନ୍, ଅଂକିଙ୍କ୍‌ ଆଦ୍ ପାଲନ୍ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଆର୍ କାନାଲ୍‌ ମଣ୍ଡିଡ଼ି, ଆଶେ ବେଡ଼୍‍ୟାଦ୍‍ ନା ଆଶେତିଙ୍କ୍ ପବିତ୍ର ମାଡ଼ମାନ୍ଦାନ୍ ମନ୍ଦିର୍ ବେଡ଼୍‍ୟାଦ୍‍ ? ");
INSERT INTO kff_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ମିଡ଼୍ ଶିକ୍ଷା ଇସ୍‌‍ମାନ୍ତ୍‍ତିଡ଼୍‍ ଯେ, ମିଡ଼୍‍ଆନ୍‌ନ୍ତେ ୱେରନ୍ ନାରୁଡ଼୍ ବେଦି ପେଦେର୍‍ତେ ଶପତ୍ ମାଡ଼୍‍କେ, ଅଣ୍ଡ୍‌ ଆଦ୍ ପାଲନ୍ ମାଡ଼ାଙ୍କ୍ ବାଦ୍ୟ ଆୟ୍‍ୟଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେଦିତେ ପର୍‍ର ନେହ୍‍ସ୍‍ମାନ୍ଦାନ୍‍ ନୈବେଦ୍ୟ ପେଦେର୍‍ତେ ପ୍ରତିଜ୍ଞା ମାଡ଼୍‍କେ, ଆଦ୍ ଆଲଙ୍ଗନୀୟ । ");
INSERT INTO kff_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ବେସର୍ କାନାନି ନିମ୍‍ । ବେଗେ ବେଡ଼୍‍ୟାଦ୍‍ ନୈବେଦ୍ୟ ନା ନୈବେଦ୍ୟତିଙ୍କ୍ ପବିତ୍ର ମାଡ଼ାନାଦ୍ ବେଦି ? ");
INSERT INTO kff_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ଇତ୍‍କେ ବେନ ବେଦି ପେଦେର୍‍ତେ ଶପତ୍ ମାଡ଼୍‍କେ, ଅଣ୍ଡ୍‌ ବେଦି ନୁ ଆଦିନ୍ ପର୍‍ର ମାନ୍ଦାନ୍ ସୁଦୁଟ୍ ନୈବେଦ୍ୟ ସାମଗ୍ରି ପେଦେର୍‍ତେ ଶପତ୍ ମାଡ଼େଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ବେନ ମନ୍ଦିର୍ ପେଦେର୍‍ତେ ଶପତ୍‍ମାଡ଼୍‍କେ ଅଣ୍ଡ୍‌ ମନ୍ଦିର୍‍ତାଗ୍ ମାନ୍‍ତାନ୍ ଇଶ୍ୱର୍‌ତେ ପେଦେର୍‍ତେ ଶପତ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ବେନ ସ୍ୱର୍ଗ ପେଦେର୍‍ତେ ଶପତ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍ ସିଂହାସନ ନୁ କୁଦିମାନ୍ତାନ୍ ଇଶ୍ୱର୍‌ତେ ପେଦେର୍‍ତେ ଶପତ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ଆର୍, ମୁର୍କ ଦର୍ମଗୁରୁ ନୁ ଫାରୂଶୀଡ଼୍, ମିୟାଦ୍ ପରିଣତି ବେସର୍ ଶଚନିୟ, ମିଡ଼୍ ଇଶ୍ୱର୍‌ତେ ଗଟ୍‍ତେ ପଦିନା, ପାନ ମହୁରୀ ନୁ ଜିରାର ଆନ୍‌‍ତେ ଦଶମାଂଶ ଦାନ ହିସମିନ୍ଦେଡ଼ି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନ୍ୟାୟ ଦୟା ସାଦୁତା ସାରେ ବ୍ୟବସ୍ଥାତାଉ ଲେକେତ୍‍ ବିଷୟ୍‍ଆନ୍‌ତେ ୱିଡ଼୍‍ସି ମିନ୍ଦେଡ଼ି । ବ୍ୟବସ୍ଥାତା ହି ବିଷୟ୍‍ତାଉ ମୁନେଙ୍କ୍ ପୁଞ୍ଜ୍‍ମାନ୍ଦାନାଦ୍ ଲେକାମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ଆର୍ କାନାଙ୍କ୍ ଆର୍ ତଅତାନଡ଼ି, ମିଡ଼୍ ବାତେଏ ତିନ୍ଦାନ୍ ୱେଲେ ଆଗେ ପୁଡ଼ିୟି ରାଲିମାନ୍‍ତେ ହିଞ୍ଜ ଆଦିଙ୍କ୍ ଚାନାମାଡ଼ିତିଡ଼୍‍, ଇତ୍‍କେ ମିଡ଼୍ ୱେର୍‍ର ଉଟ୍‍ତିଙ୍କ୍ ଲୋପିତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ହାୟ, ଦଣ୍ଡତେ ନାରୁଡ଼୍ ମୁର୍କ ଶାସ୍ତ୍ରୀ ନୁ ପାରୂଶୀଡ଼୍, ମିଡ଼୍ ଗିନା ନୁ ତାଲିତେ ବାୟିଦେ ନର୍‌ଦ୍‌ତିଡ଼୍‌, ମାତର୍ ଲୋପେ ଆଦ୍ ସାରେ ବୁସା ପାଡ଼୍‍ୟି ନୁ ଇନ୍ଦ୍ରିୟ କାମ୍‌ଦେ ବର୍ତ୍ତି ଆସ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ହୋ କାନାଲ୍‌ ଫାରୁଶି, ମୁନେଙ୍କ୍ ଗିନେତ୍‍ ଲପ୍ ନର୍‌ମୁଟ୍‌, ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଆଦିନାଗେ ବାୟିଦେ ଆନ୍‌‍ତେ ନର୍‌ସ୍‌ ଆଦ୍‌ତେ । ");
INSERT INTO kff_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ଆୟ୍‌, ଦଣ୍ଡତେ ନାରୁଡ଼୍ କପଟି ଶାସ୍ତ୍ରୀ ନୁ ପାରୂଶୀଡ଼୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଚୂନ୍ ଆକ୍‍ତେ ସମାଦିତ୍‍ ଲେକାମ୍ ଆଦ୍ ବାଇଦେ ସୁନ୍ଦର୍ ଇତ୍‍କେ ଲୋପେ ଡଲ୍‍ତେ ମେନ୍ଦୁଲ୍ ନୁ ଡଲ୍‍ତେ ବୁଲା । ");
INSERT INTO kff_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ରକମ୍ ମିଡ଼୍‍ଆନ୍‌ନ୍ତେ ବାୟ୍‍ଦେତ୍‍ ନାରୁଡ଼୍ କଣ୍ଡେତେ ଦାର୍ମିକ୍ ତନ୍ଦିତିଡ଼୍‍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଇ ଲୋପେ ଅପରାଦ୍‌ ନୁ ପାପ୍‍ତେ ବର୍ତ୍ତି ଆଶେ ମାନ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ହାୟ, ଦଣ୍ଡତେ ନାରୁଡ଼୍ ମୁର୍କ ଶାସ୍ତ୍ରୀ ନୁ ପାରୂଶୀଡ଼୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ବାବବାଦୀଲଡ଼ାଦ୍‍ ସମାଦି ତିଆର୍ ମାଡ଼ି ନୁ ଦାର୍ମିକ୍ଡ଼ାଦ୍ ସମାଦିସ୍ତମ୍ଭ ସୁଶବିତ ମାଡ଼ି ମାନ୍‍ତିଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ମାମ୍ ବେସୁଙ୍କ୍‍ ମା ଆନିଦାଦିଡ଼୍ ସମୟ୍‍ତେ ମାନେମ୍‍ ଆତ୍‍କେ, ଆଲେକ୍ ବାବବାଦୀଡ଼୍ ନେତୁର୍‍ତେ ଅଡ଼୍‌ ତୋଡ଼୍ ଅୟମ୍‍ ଆୟେମ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଆଦ୍‍ଦିଙ୍କ୍ ମିଡ଼୍ ଯେ ଆୱ୍‍କାନ୍‍ ବାବବାଦୀ ବଂଶତଡ଼ି, ଆଦ୍ ସମ୍ୱନ୍ଦତେ ମିଡ଼୍ ହି ନିଜେତ୍ ନିଜେତ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ଇସମିନ୍ଦେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ଆଲାଇତ୍‍କେ ମୁନେ ଦାଟ୍‍, ମିଇ ମୁନେତ୍ ଆନିଦାଦିଡ଼ାଦ୍‍ ସାରେ ଆୟ୍‍ୱେ ପାଡ଼ିୟିତିଙ୍କ୍ ସାରେ ମାଡ଼ିମୁଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ଆର୍ ତାଡ଼ାକିନଡ଼ି, କାଲସର୍ପର ବଂଶତଡ଼ି ! ନର୍‍କ ଦଣ୍ଡକଞ୍ଜ୍ ରକ୍ଷା ପାହେମ୍‍ ଆଦ୍‍ତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ଆଦିଙ୍କ୍ ଉଡ଼େ, ନାନ୍‍ନେ ମିଇ ଗାର୍‍ରେ ବାବବାଦୀ, ଜ୍ଞାନି ନୁ ଶାସ୍ତ୍ରିଡ଼ିକ୍‍ ରୟ୍‍ସ୍ ମିନ୍ଦେନ୍; ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେନ ବେନଙ୍କ୍ ମିଡ଼୍ ଆୱ୍‍କିତିଡ଼୍‍ ନୁ କ୍ରୁଶତାଗେ ଆୱୁକିତିଡ଼୍, ମେଣ୍ଡେ ବେନ ବେନଙ୍କ୍ ମିଇ ଉପାସନା ଲତ୍‍ତାଗେ କରଡ଼ା ରେହ୍‍ତିତିଡ଼୍‍ ନୁ ନାର୍‍ଦେ ନାର୍ ତାଡ଼ନା ମାଡ଼ିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ସାରେଲେକେତ୍ ହେବଲ୍‍ତାଗାଙ୍କ୍ ଆରାମ୍ ମାଡ଼ି ମନ୍ଦିର୍ ନୁ ବେଦି ମଦ୍ୟସ୍ଥଳତାଗେ କାୟି ମାନ୍ଦାନ୍ ଜିକରିୟ ବରକିଅନ୍‌‍ତେ ମାର୍‍ ଦେ କଞ୍ଜ୍ ପୃତିବିତେ ସାରେତଡ଼୍ ଦାର୍ମିକ୍ ନାରୁଡ଼ାଦ୍ ଆୱୁକାନ୍‍ ମାଇଦିଙ୍କ୍ ମିଡ଼୍ ଦଣ୍ଡିତ୍ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ କେତୁତାନ୍, ହି ସାରେ ନାରିଡ଼୍ ଆୱୁକାନ୍ ମାଇଦିଙ୍କ୍ ହି ଯୁଗ୍‍ତେ ନାରୁଡ଼୍ ଦଣ୍ଡତ୍‍ ତିପାଲ୍ ଆଦ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ହୋ ଯିରୁଶାଲେମ୍, ହୋ ଯିରୁଶାଲେମ୍ । ମିଡ଼୍ ବାବବାଦୀଡ଼୍‍କ୍‍ ଆୱୁକୁତିଡ଼୍ ନୁ ଇଶ୍ୱର୍ ରୟ୍‍ସ୍‍ମାନ୍ଦାନ୍ ଗଟିକେ ଅଡ଼୍‌କିଂଙ୍କ୍ କାଲ୍‍କ୍ ହେସି ରେହ୍‍ତୁତିଡ଼୍‍ । କର୍‍ ତାନ୍ ରେକାନ୍‍ ମଦଲ୍ ପିଲାଙ୍କ୍ ପୟ୍‍ସ୍ ନେହେତାନ୍ ଲେକାମ୍, ମିଇ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନା ବାହୁତ୍‍ ମଦଲ୍ ରକ୍ଷା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ବେସଦାମ୍‍ ଆଲ୍‍ସି ମାଡ଼୍‍ତାନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଆଦ୍ ମାଡ଼ାନଙ୍କ୍ ଇୱିଡ଼ି ।” ");
INSERT INTO kff_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ଉଡ଼େ, ମିଇ ମନ୍ଦିର୍ ମିୟିକାଇଦେ ୱିଡ଼୍‍ସିଦୁତମ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ପ୍ରବୁନ୍ ପେଦେର୍‍ତେ ବେନ ୱାଦୁତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଦନ୍ୟ, ମିଡ଼୍ ହି ଗଟ୍ କେଲକଟ ମାନ୍‍ନା ଯାକ ନାକିଂଙ୍କ୍ ମେଣ୍ଡେ ଉଡ଼େ ପାର୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜିସୁ ମନ୍ଦିର୍‍ତାଗାଙ୍କ୍ ପେୟିସ୍ ଆଦ୍‍ଦାନ୍ ୱେୟ୍ ଶିଷ୍ୟଡ଼୍ ମନ୍ଦିର୍ ବେଡ଼େତାଗେ ମାନ୍ଦାନ୍ ବେଡ଼୍‍ୟା ସୌଦତ୍‍ ପାକେ ଜିସୁନ୍ ଦୃଷ୍ଟି ତିଆର୍ ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ସତ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଞ୍ଜେ ସିନା ଇସାର୍‍ରେ ଉଡ଼୍‍ତିଡ଼୍ । ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ହି ମନ୍ଦିର୍‍ତାଗ୍ ୱେରଡ଼୍ ଆନ୍‌‍ତେ କାଲ୍ ଅନ୍‌‍ ପଡ଼ିୟେତାଗ୍ ମାନ୍‍ନ । ସାରେ ବୂମିସାତ୍‍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ଜିସୁ ଜିତ ମେଟେତ୍‍ ପର୍‍ର କୁଦି ମାନ୍ଦାନ୍‍ୱେଲେ ଶିଷ୍ୟଡ଼୍ ଅଣ୍ଡୟ୍‌‍ଦାମ୍ ୱାସ୍ ପାଚ୍ରା ମାଡ଼୍‍ତଡ଼୍, “ଇସାର୍‍ରେ ବେସୁଟ୍‌ ଗଟେମ୍‌ ଆଦ୍‍ତେ, ମାକିଂଙ୍କ୍ କେଲ୍‍ମ୍ । ବାତେଏ ଗଟେମ୍ ଆତ୍‍କେ ମାମ୍‍ମେ ପୁନ୍ତମ୍‍ ଯେ ନିୟାଦ୍ ୱାଦାନ୍ ଦିନାମ୍ ଆଦୁତ୍‍ ନୁ ଇ ଯୁଗାନ୍ତ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ସତର୍କ ମାନୁଟ୍ ।” ବେନ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ମିକିଂଙ୍କ୍ ବୁଲ୍‍କା ମାଡ଼୍‍ମାକିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ନା ପେଦେର୍ ଆସ୍ ନାର୍‍ଗେ ୱାସ୍ କେତିତଡ଼୍‍, “ନାନ୍‍ନେ ବାନେ ମସୀହ ।” ଇଲା କେସ୍ ଅଡ଼୍‌ ସାର୍‍ତଡ଼୍‍କିଙ୍କ୍ ବୁଲ୍‍କା ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ମିଡ଼୍ ଗାର୍‍ରେ ଯୁଦ୍ଦ୍‌ତେ ଆସମାନ୍ଦାନ୍ ମର୍‍ରେ କେଞ୍ଜିତିଡ଼୍‍ ନୁ ଜୁୟ୍‍ ଚାଲେମ୍‍ ଆସ୍‍ମାନ୍ଦାନ୍ ଯୁଦ୍‌ତେ କବର୍ କେଞ୍ଜ୍‍ତିଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦାନ୍ଦେ ଆୟ୍‍ମାଟ୍‍ । ହିଦ୍‍ପୁଟୁଙ୍କ୍ ସାରେ ନିଜାମ୍ ଗଟେମ୍ ଆଦ୍‍ତେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ, ହିଦିନ୍ ଇତ୍‍କେ ଆୟଜେ ଯୁଗାନ୍ତ ଦିନାମ୍ ହେୱ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଦେଶ୍‍ ଦେଶ୍‍ ଲୋପେ ଯୁଦ୍‌ ଆଦ୍‍ତେ, ୱେରଡ଼୍ ରାଜ୍ୟ ମେଣ୍ଡନ୍ ରାଜ୍ୟତ୍‍ପରୁ ଚିଟିରମନ୍ ମାଡ଼ିତେ । ପଡ଼ିୟେ ପଡ଼ିୟାନାଗ୍ ଦୁର୍‍ବିକ୍ଷା ନୁ ବୁମିକମ୍ପ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାଟାଡ଼୍ ଇଚ୍ଛାତେ ପ୍ରସବ୍‍ ବେଦନାତେ ଆରାମ୍ ଲେକାମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ମିଡ଼୍ ଦରାପଡ଼େମ୍‍ ଆଶେ ଉତ୍‍ପିଡ଼ିତ ନୁ ଡଲିତିଡ଼୍‍ ନୁ ମେଣ୍ଡେ ନାୟାଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ମିଡ଼୍ ସାରେ ଜାତିତଡ଼୍ ତ ଗୃନାତେ ପାତ୍ରଡ଼ି ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ଆସୁଟେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଅଡ଼୍‌ ବିଶ୍ୱାସ୍‍ତିଙ୍କ୍ ଆରାମାଡ଼ିତଡ଼୍‍, ନିଜେ ନିଜେତିଙ୍କ୍ ପାସ୍‍କି ମାଡ଼ି ନିଜେତ୍ ବିଶ୍ୱାସ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ଆସୁଟେ ବେସ୍‌କ୍ ତଡ଼୍ ବଣ୍ଡବାବବାଦିଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବୁଲ୍‍କା ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ହିଦ୍‍ପୁଟୁଙ୍କ୍ ଅପରାଦ୍‌ ନାର୍ଗେ ଆଦ୍‍ତେ ନୁ ନାର୍‍ଗେ ନାରୁଡ଼୍‍ତେ ପ୍ରେମ ଇଶ୍ୱର୍‌ତେ ସେଙ୍ଗେ ଶିନ୍ତେ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ବାତେଙ୍କ୍ ଇତ୍କେ ବେନଆଇ ତେର୍‍ନା ଯାକ ଶକ୍ତିତଡ଼୍ ପୟ୍‍ସ୍ ମାନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ପରିତ୍ରାଣ୍ ପାହେମ୍‍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ବିଷୟ୍ ସାୟେତ୍ ଗଟ୍ ସାରେ ନାରୁଡ଼୍ ଜାତିଡ଼୍ ମାଇଦିଙ୍କ୍ ସତ୍ କାଇଲ୍‍ତେ ଲେକାମ୍ ସାରା ଜଗତ୍‍ତାଗେ ପ୍ରଚାର୍ ଆଦ୍‍ତେ । ତାନ୍‍ପେର୍କେ ଯୁଗ୍ ଶେଷ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ବାବବାଦୀଡ଼୍ ଦାନିୟେଲ୍‍ ତିଆର୍ ମାଡ଼ିମାନ୍ଦାନ୍ ୱିଡ଼୍‍ସି ମାଡ଼ାନ୍ ପାସ୍‍କି ଜିନିଷ୍‍ । ପବିତ୍ର ଜାଗାତିଙ୍କ୍ ଆଦ୍ କଳୁଷିତ ମାଡ଼ିତେ । ଇଦିନ୍ ଇତ୍‍କେ ବାତେଏ, କାପାଟ୍ ବନ୍ଦ୍‍ ମାଡ଼ାନାଦ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ଆସୁଟେ ବେନଡ଼୍ ଯିହୁଦା ଦେଶ୍‌ତାଗେ ମାନ୍‍ତଡ଼୍, ଅଡ଼୍‌ ମେଟେତାଗେ ମିରିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ବେନଡ଼୍ ଲୋତ୍‍ତେ ମୁର୍ସିନାଗ୍‍ ମାନ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଲୋତ୍‍ତେ ମଦଲ୍ ୱାସ୍ ଦିନାମ୍ ନଷ୍ଟ ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ବେନଡ଼୍ ୱାୟାନା ଆଞ୍ଜ୍‍ମାନ୍‍ତନ୍, ନିଜେତ୍ ଚକା ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ହାନ୍‍ମାକି । ");
INSERT INTO kff_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ଆସୁଟେ ଡଙ୍କେତ୍‌ ମୁତେକି ନୁ ଡେକାନାଗ୍‌ ବାବୁଙ୍କ୍ ପୟ୍‍ସ୍‍ମାନ୍ଦାନ୍ ଅବସ୍ଥାତେ ବେସର୍ ଶୋଚନୀୟ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ଇଶ୍ୱରତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ମାନୁଟ୍‍, ସାଲ୍‍ଦେ ଦିନାତେ ବା ବିଶ୍ରାମ୍‍ବାର୍‍ଦେ ମିକିଂଙ୍କ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ମିରାଙ୍କ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ଆସୁଟେ ବେନ ଦୁଃକାମ୍ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍‍, ଜଗତ୍‍ତେ ତିଆର୍‍ତାଗାଙ୍କ୍ ନେଣ୍ଡ୍‍ଜାକ ଗଟେମ୍ ଆସ୍‍ମାନ୍ଦାନ୍ ସାରେ କଷ୍ଟତିଙ୍କ୍ ଆଦ୍ ବଲି ଆଦ୍‍ତେ । ରକମ୍ ଦୁଃକାମ୍ ପାୟେ ବେସୁଙ୍କ୍‍ ୱାଡ଼ । ");
INSERT INTO kff_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ବାତେଙ୍କ୍ ଇତ୍‍କେ ହି ଦୁଃକତ୍‍ ଦିନାମ୍‍ତିଙ୍କ୍ ଇଶ୍ୱର୍ କମ୍‍ ମାଡ଼ିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ଆଲା ଆୟ୍‍ୟକଟ ମାନ୍ଦାନ୍‍ଇତ୍କେ, ମେଣ୍ଡେ ବେନ ବାଦ୍‍କ୍‍ ପାର୍‍ୱଣ୍ଡ୍ ଆୟେଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ତାନ୍ ହେଞ୍ଚିମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଗେଲ୍‍ସ୍ପାନ୍ ମାଇଦିଙ୍କ୍ ଇଶ୍ୱର୍ ଆଦ୍ ସମୟ୍‍ତିଙ୍କ୍ ସୁଦୁଟ୍ ମାଡ଼ିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ଆସୁଟେ ଯଦି ବେନ ମିକିଂଙ୍କ୍ କେତିତଣ୍ଡ୍, ‘ଇଗେ କ୍ରିଷ୍ଟ ମିନ୍ଦେଣ୍ଡ୍ ବା ଆଗେ ଅଣ୍ଡ୍‌ ମିନ୍ଦେଣ୍ଡ୍,’ ତାଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ବାତେଙ୍କ୍ ଇତ୍କେ ନିଜ୍‍ତିଙ୍କ୍ ବଣ୍ଡକ୍ରିଷ୍ଟ କେସମାନ୍ତ୍‍ତଡ଼୍‍ ବୁସାମାଡ଼ାନଡ଼୍‍ ଆସୁଟେ ତନ୍ଦିତଡ଼୍‍ । ଅଡ଼୍‌ ବାକ୍‍ୱା ନୁ ବାକ୍‍ୱାତାଉ ପାଡ଼୍‍ୟି ତୟ୍‍ସ୍‍ ଇଶ୍ୱର୍‌ତେ ହେଞ୍ଚିମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କ୍ ବୁଲ୍‍କା ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","କେଞ୍ଜାଟ୍, ଆଦ୍ ଦିନାମ୍ ୱାଦାନ୍ ମୁନେଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ହିସରେ ଗଟ୍ କେଞ୍ଜ୍‍ପିଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ଉଡ଼ାଟ୍, ଅଣ୍ଡ୍‌ ଉସ୍କ ନାର୍‍ତାଗ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜେ ଯଦି ନାରୁଡ଼୍ କେତିତଡ଼୍‍, ଆଗେ ଆନ୍‌‍ମାଟ୍, ଯଦି ଅଡ଼୍‌ କେତିତଡ଼୍‍, ‘ଉଡ଼େ, ହିଗେ ଅଣ୍ଡ୍‌ ମିଞ୍ଜିମିନ୍ଦେଣ୍ଡ୍’ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ପିଡ଼୍‍ଗ୍‍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ପଡ଼ଦ୍‍ ପେଇତାନାଗାଙ୍କ୍ ପଡ଼ଦ୍‍ ଆଦାନ୍ ଯାକ ମାବ୍‍ତିଙ୍କ୍‍ ୱେସ୍‍ମାଡ଼ିତ୍‍, ନାରୁନ୍‍ପିଲେ ଆନ୍‌‍ତେ ରକମ୍ ୱାଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ବେଗେ ଡଲ୍‍ତାଦ୍ ବାତେଏ ମାନ୍‍ତେ, ଆଗେ ଡାମର୍‍ପିଟେ ଗୁଡ଼୍‍ଡି ମାନ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ଆଦ୍ ଦୁଃକାମ୍‍ତେ ଦିନାମ୍ ଶେଷ ଆଦ୍‍ଦାନ୍ ୱେୟ୍ ପଡ଼୍‍ଦ୍ ଇକାଡ଼୍ ଆଦ୍‍ତେ, ନେଲ୍‍ଞ୍ଜ୍‍ ମେଣ୍ଡେ ୱେସ୍ ହିଦ୍‍ପାର୍‍ୱ, ନୁ ମହାଶୂନ୍ୟତେ ନାର୍‍ଗେ ହୁକାକ୍‍ ଇକେ ଆକେ ଆଦ୍‌ତା । ");
INSERT INTO kff_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ତାନ୍ ପେର୍କେ ମନୁଷ୍ୟପୁତ୍ରତିଙ୍କ୍ ମାବ୍‍ତାଗ୍ ୱାଦାନାଦ୍ ଉଡ଼ିତିଡ଼୍ ନୁ ମାବ୍‍ତେ ଲୋପେଙ୍କ୍ ନାର୍‍ଗେ ଶକ୍ତି ନୁ ଗୌରବ୍ ତେ ୱାଦାନାଦ୍ ଉଡ଼ି ପୃତିବିତେ ସାରେ ବାଷାତ୍‍ ନାରୁଡ଼୍ ଉଡ଼ି କେଇତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ମହିର୍‍ତେ ଶଦ୍ଦ ନୁ ପୃତିବିତାଗ୍ ୱେରଡ଼୍ ପଡ଼ିୟେ ତାଗାଙ୍କ୍ ମେଣ୍ଡନ୍ ପଡ଼ିୟେ ହେୱ୍‍ନା ଅନ୍‌ ହେଞ୍ଚଣ୍ଡ୍ ନାରୁଡ଼୍‍କ୍ ମଦ୍‍ମାଡ଼ି ତାତାନ୍ ମାଇଦିଙ୍କ୍ ନାରୁନ୍‍ପିଲେ ତାନ୍ ଦୂତକିଙ୍କ୍ ରହ୍‍ତିତନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ତୟାମାଡ଼େତ୍ ଆଗାଙ୍କ୍ ଶିକ୍ଷା ଗ୍ରହନ୍ ମାଡ଼ାଟ୍ ବେସୁଙ୍କ୍‍ ତାନାଦ୍ ଚିଟି‍ ରଙ୍ଗ୍‍ଦେ ଲେକ୍‍ତ୍‍ତେ କମେ ସୁଦୁକମା ନାଗାଙ୍କ୍ ପୁନେ ଆକି ପେୟ୍‍ତିତା, ହେଦ୍‍କାଲାମ୍‍ ଆଦ୍‍ତେ ଇଞ୍ଜ ମିଡ଼୍ ପୁନ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ଟିକ୍ ରକମ୍ ହିସାର୍‍ରେ ଗଟନା ଉଡ଼୍‍କେ, ମୁନେତ୍ ଦିନାକଞ୍ଜ୍ ଆରାମ୍ ଆତ୍‍ତେ ଇଞ୍ଜ ମିଡ଼୍ ପୁନ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ମନେମାଡ଼ାଟ୍‍, ଇଞ୍ଜେ ହି ଯୁଗ୍‍ତେ ନାରୁଡ଼୍‍ତେ ଲୋପେଙ୍କ୍ ସାରେତଡ଼୍ ଡଲାନ୍ ମୁନେଙ୍କ୍ ଇୱୁ ସାରେ ବିଷୟ୍ ନିଜାମ୍‍ ଗଟେମ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ମାବ୍ ନୁ ପୃତିବି ନଷ୍ଟ ଆଦ୍‍ତେ ସିନା; ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ଗଟ୍ ବେସୁଙ୍କ୍‍ ଲୋପ୍ ପାହେମ୍‍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ଆଦିନ୍, ଆଦ୍ ସମୟତେ ବେସୁଙ୍କ୍‍ ୱାଦ୍‍ତେ, ବେନ କେତ୍‍ ପାର୍‍ୱଡ଼୍ । ସ୍ୱୟଂ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ନୁ ସ୍ୱର୍ଗଦୂତ ଆନ୍‌ତେ ଆଦ୍ ଗଟ୍ ପୁନ୍‍ନ, ମାତର୍ ବାବାଲ୍ ଇଶ୍ୱର୍ ପୁନ୍‌ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ନହତେ ଦିନାମ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଗଟେମ୍ ଆସ୍‍ମାତ୍‍ତେ, ମନୁଷ୍ୟପୁତ୍ରନ୍ ୱାଦାନାଦ୍ ସମୟ୍‍ତେ ରକମ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ଏର୍‍ତୁପାନ୍‌ ଆଦ୍‍ଦାନ୍ ମୁନେଙ୍କ୍ ନହ ଜାହାଜ୍‍ତାଗେ ଅସ୍‍ନା ଯାକ ନାରୁଡ଼୍ ତିନ୍ଦାନ୍ ଉନ୍ଦାନ୍ ନୁ ପେଣ୍ଡୁଲ୍ ଆଦାନାଦ୍ ଆସତ୍‍ ପାଡ଼ିୟିଦାଗ୍‌ ଦାନ୍ଦେ ମାନ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ଏର୍‍ ଗାଲ୍‍ଦେ ଅଡ଼୍‌ ବୁଡ଼େଲ୍‍ ଅୟ୍‍ନା ଯାକ ବାତେଏ ଗଟେମ୍ ଆଦୁତ୍‍ତେ, ବେନ ପୁନକଟ୍ ମାତ୍‍ତଡ଼୍ । ନାରୁନ୍‍ପିଲେ ୱାଦାନ୍ ଦିନ୍ ଟିକ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ଆଦ୍ ସମୟ୍‍ତେ ୱାୟାନାଗେ ପାଡ଼୍‍ୟି ମାଡ଼ାନଡ଼ି ଇର୍‍ୱୁଡ଼୍ ମାନ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡେ ହେଞ୍ଚିମାନ୍ଦାନ୍ ଆଶେ ଆଦ୍‍ତନ୍ । ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ହେଞ୍ଚିମାନ୍ଦାନ୍ ଆୟ୍‍ୟକଟ ପେର୍କେ ମାନ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ରେଣ୍ଡ୍ ଜାତ୍‍ତେ ତିହିତାନ୍ ନାଟାକିନ୍‍ ଲୋପେଙ୍କ୍ ୱେରଡ଼୍ ଆଦ୍‍ତେ ନୁ ମେଣ୍ଡନ୍ ଆଗେ ମାନ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ମିଡ଼୍ ସତର୍କ ମାନୁଟ୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ମିଇ ପ୍ରବୁ ବେସୁଙ୍କ୍‍ ୱାଦ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ପୁନ୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ବେସୁଙ୍କ୍‍ ଡଙ୍ଗାଲ୍ ନେଙ୍ଗିତଣ୍ଡ୍ ଇଞ୍ଜ ପୁଞ୍ଜ୍‍ମାତ୍‍ତ୍କେ, ଲୋତ୍‍ତେ ମାଲିକ୍ ତିଆର୍‍ତେ ମାଞ୍ଜ୍ ଡଙ୍ଗାଲ୍‍ତିଙ୍କ୍ ଲୋପେ ନେୱଣ୍ଡ୍ ଆୟେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ମିଡ଼୍‍ଆନ୍‌ନ୍ତେ ସାରେଦାମ୍ ତିଆର୍ ଆସ୍‍ମାନୁଟ୍‍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ମାଡ଼୍‍ୱେ ସମୟ୍‍ତେ ଅଣ୍ଡ୍‌ ୱାସ୍ ହେୱ୍‍ଦେ ପାର୍ଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ବେନ ଆଲାଇତ୍‍କେ ବିଶ୍ୱାସ୍ତ ନୁ ବୁଦିମାନ୍‍ ଚାକର୍ ? ବେନନ୍ ପର୍‍ର ମାଲିକ୍ ବାଗାତ୍ ଚାକରିଡ଼୍‍କ୍ ଟିକ୍ ସମୟ୍‍ତେ କାଦି ଇଦାନ୍ ବାର ନ୍ୟସ୍ତ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ମାଲିକ୍ ମାଲ୍‍ସ୍ ୱାଦାନ୍ ୱେଲେ ଆଦ୍ ଚାକର୍ ଯଦି ବିଶ୍ୱାସ୍‍ତେ ଅନାଦ୍‌ ପାଡ଼୍‍ୟି ପାଲନ୍ ମାଡ଼ମାନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବେସର୍ ସାର୍‍ଦ୍‍ ଆଦ୍‍ତନ୍ ! ");
INSERT INTO kff_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ନାନ୍‍ନେ ନିଜାମ୍‍ କେସମିନ୍ଦେନ୍, ଆସତ୍‍ ଚାକର୍‍ତିଙ୍କ୍ ମାଲିକ୍ ଦିନ୍ ଅନାଦ୍‌ ସାରେ ସମ୍ପତିତ୍‍ତେ ଦାୟିତ୍ୱତେ ନେହ୍‍ତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଚାକର୍ ଯଦି ବିଶ୍ୱାସ୍ ଆୟ୍‍ୟକଟ ମାଲିକ୍ ସିଟ୍‍ପାଟ୍ ୱାଡ଼ଣ୍ଡ୍ ଇଞ୍ଜ ଆଲ୍‍ସିତିଡ଼୍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ବାଗାତେ ସେବକ୍‍ ନଡ଼୍‍କିଙ୍କ୍ ରେହେତା ରେହେତି ମାଡ଼ି କାଲ୍‍ଉନ୍ଦାନଡ଼୍‍ତ କାଇଲି ତିନ୍ଦାନ୍ ଉନ୍ଦାନାଗ୍‍ କାୟ୍‍ଲିତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ଅଣ୍ଡ୍‌ ୱିଡ଼୍‍ସି ମାଡ଼କଟ୍ ମାନ୍ଦାନ୍, ବେଦ୍‍ଦିନେ ଅଣ୍ଡ୍‌ ପୁନ୍‍ୱେ ମାନ୍‍ତନ୍ ଆଦ୍ ସମୟ୍‍ତେ ଅନ୍‌‍ଦିନେ ଦାସନ୍‍ ମାଲିକ୍ ମାଲ୍‍ସ୍ ୱାଦ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ଅଂକିଙ୍କ୍‌ ଅଣ୍ଡ୍‌ ତିପାଲ୍‍ତେ ଦଣ୍ଡ୍ ହିଦ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ମୁର୍କନାରୁଡ଼୍ ତ ବେଗେକି ନାରୁଡ଼୍ କେଇତଡ଼୍ ନୁ ଯନ୍ତ୍ରନାତାଗ୍‍ ପାଲ୍‍କ୍ କିଟ୍ରୁମ୍ କାର୍ଟ୍ରୁମ୍ ମାଡ଼ିତଡ଼୍ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ରୟ୍‍ସିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ଆଦ୍ ସମୟ୍‍ତେ ସର୍ଗରାଜ୍ୟତେ ୱାଦାନାଦ୍ ହିଦ୍ ଲେକାମ୍ ଆଦ୍‍ତେ ।” ଦଶ୍‍ଟାନ୍‍ ପିକି ସାର୍‍ତାୱ୍‍ ୱେରଡ଼୍ ୱେରଡ଼୍ କୁପି ଆସ୍ ବରଙ୍କ୍ କାଇଲାନ୍ ମାଡ଼ାଙ୍କ୍ ଆଞ୍ଜ୍‍ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ଆୱିନ୍ ଲୋପେ ଏଇଙ୍ଗ୍ ବୁଦ୍‍ ହିଲ୍‍ୱାୱ୍‍ ନୁ ଏଇଙ୍ଗ୍ ବୁଦ୍‍ ମାନ୍ଦାନାୱ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ବୁଦ୍‍ ହିଲ୍‍ୱେ ପିକି କୁପି ଆତ୍‍ତା ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆର୍କେ ନାର୍‍ଗେ ନିୟ୍ ଆୟକଟ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ବୁଦି ମାନ୍ଦାନାୱ୍‍ ପିକି ଆର୍କେ କୁପି ଆତ୍‍ତା ନୁ ବତଲ୍‍ତାଗେ ନାର୍‍ଗେ ନିୟ୍ ଆସ୍ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ବର ୱାଦାନାଦ୍ ଲେଟ୍ ଆତ୍‍ତାଙ୍କ୍ ପିକି କୁଡ଼୍‍କି କୁଡ଼୍‍କି ହୁଞ୍ଜ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ନାଡ୍‍ନାର୍କା ମର୍‍ରେ କେଞ୍ଜ୍‍ତା, “ହିକ୍‍ ଉଡ଼ାଟ୍ ବର ୱାଦୁତଣ୍ଡ୍, ୱାଡ଼ାଟ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ତାତିତାଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ପିକି ତେଦିମେଣ୍ଡେ ନିଜେତ୍ ନିଜେତ୍ କୁପି ତିଆର୍ ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ଆସୁଟେ ବୁଦ୍‍ହିଲ୍‍ୱେ ପିକି ବୁଦ୍‍ ମାନ୍ଦାନାୱିଙ୍କ୍ କେତ୍‍ତା, “ମାକିଂଙ୍କ୍ ସୁଦୁର୍ ନିୟ୍ ହିମୁଟ୍ । ମାୟାୱ୍‍ କୁପି ପିୟ୍‍ଦୁତା ।” ");
INSERT INTO kff_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ବୁଦ୍‍ମାନ୍ଦାନାୱ୍‍ କେତ୍‍ତା, “ଇଲେ, ମି ସେଙ୍ଗେ ନୁ ମା ମାଇଦିଙ୍କ୍ ନିୟ୍ ଆଲକଟ୍ ଆଦ୍‍ତେ । ମିଡ଼୍ ଦୁକାନ୍‍ତାଗେ ଆଞ୍ଜ୍ ନିଜେତ୍ ନିଜେତ୍ ମାଇଦିଙ୍କ୍ ବେସର୍ ନିୟ୍ ଆସି ତାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ଆଦିଙ୍କ୍ ବୁଦ୍‍ହିଲ୍‍ୱେ ପିକି ନିୟ୍ ଆସାଙ୍କ୍ ପେୟ୍‍ତା । ଆୱ୍ ଆତ୍‍ତେ ପେର୍କେ ବର ୱାସ୍ ହେୱ୍‍ତଣ୍ଡ୍ । ତିଆର୍ ଆଶେ ମାନ୍ଦାନ୍ ଏଇଙ୍ଗ୍ ପିକି ଅନ୍‌‍ତଡ଼୍ ପେଣ୍ଡୁଲ୍ ବଜିତାଗେ ଆଦ୍ କାପାଟ୍ ବନ୍ଦ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ପେର୍କେ ବାଗାତେ ପିକି ଆଗେ ୱାତ୍‍ତା । ପ୍ରବୁ, କାପାଟ୍ ତେର୍‍ମ୍‍; ମାମ୍‍ମେ ଲୋପ୍ ଆଦ୍‍ତମ୍‍ ଇଞ୍ଜ ଆୱ୍ ମର୍‍ପୟ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ବର ଉତ୍ତର୍ ଇତ୍‍ତଣ୍ଡ୍, ‘ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ମିଡ଼୍ ବେନଡ଼ି, ନାନ୍ ମିକିଂଙ୍କ୍ ପୁନନ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ଗଟ୍ କେତାନାଦ୍ ତେର୍‍ସ୍‍ପି ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ସତର୍କ ମାନୁଟ୍ । ଆଦ୍ ଦିନ୍ ବା ଆଦ୍ ଦିନାମ୍ ବେନ ବା ପୁନଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ସ୍ୱର୍ଗ ରାଜ୍ୟ ଇଦ୍‍ପୁଟୁଙ୍କ୍,” ଆଦିନ୍ ମେଣ୍ଡ୍‍ଅଣ୍ଡୟ ୱେଷଡ଼୍ କେଞ୍ଜାଟ୍ । ଅନ୍‌‍ଦାମ୍ ୱେରଣ୍ଡ୍ ନାରୁନ୍ ଚାକର୍‍କିଡ଼୍‍ କାୟ୍‍ଦେ ଅନାଦ୍‌ ସମ୍ପତ୍ତି ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବିଦେଶ୍‍ତା ଆଦ୍‌ଦାଙ୍କ୍ ପେୟ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ଅଡ଼ାଦ୍‌ ଶକ୍ତି ଲେକାମ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେସର୍ ବେସର୍ ଇତ୍‍କେ ଗୁଡ଼୍‍ପି ମାଡ଼ିତନ୍, ଅର୍‍ତୁଙ୍କ୍ ହିତ୍‍ତଣ୍ଡ୍ ଏଇଙ୍ଗ୍ ହଜାର୍‌ ରୁପା ମୁଦ୍ରା, ମେଣ୍ଡେ ଅର୍‍ତୁଙ୍କ୍ ରେଣ୍ଡ୍ ହଜାର୍‌ ନୁ ମେଣ୍ଡେ ଅର୍‍ତୁଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ହଜାର୍‌ ଇସ୍‌ ବିଦେଶ୍ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ଏଇଙ୍ଗ୍ ହଜାର୍‌ ରୁପା ମୁଦ୍ରା ପାହେମ୍‍ ଆତ୍‍ତେନଣ୍ଡ୍ ଚାକର୍ ଆଦ୍ ଦନ୍‍ଦିଙ୍କ୍ ବେପାର୍ ମାଡ଼ି ମେଣ୍ଡେ ଏଇଙ୍ଗ୍ ହଜାର୍‌ ରୁପା ମୁଦ୍ରା ଲାବ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ରକମ୍ ରେଣ୍ଡ୍ ହଜାର୍‌ ମୁଦ୍ରା ପାହେମ୍‍ ଆଦ୍ ଚାକର୍ ମେଣ୍ଡେ ରେଣ୍ଡ୍ ହଜାର୍‌ ମୁଦ୍ରା ଲାବ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ୍ ଚାକର୍ ହଜାର୍‌ ପାହେମ୍‍ ଆଶେ ମାତ୍‍ତେନଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ନେଲ୍ ୱେରଡ଼୍ ଦର୍‍ ଡେୱି ମାଲିକ୍‍ତେ ଆଦ୍ ମୁଦ୍ରାକିଂଙ୍କ୍ ମିଞ୍ଜ୍‍ପି ନେହ୍‍ସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","ନାର୍‍ଗେ ଦିନ୍‍ତେ ପେର୍କେ ମାଲିକ୍ ମାଲ୍‍ତଣ୍ଡ୍ ନୁ ଚାକରିଡ଼୍ ତଡ଼୍ ହିସାପ୍ କିତାବ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ଏଇଙ୍ଗ୍ ହଜର୍‍ ଅସ୍ ମାନ୍ଦାନ୍ ଚାକର୍ ମାଲିକ୍‍ତିଙ୍କ୍ ମେଣ୍ଡେ ଏଇଙ୍ଗ୍ ହଜାର୍‌ ହିତ୍‍ତଣ୍ଡ୍, “ଗଟ୍, ନିମ୍‍ ନାକିଂଙ୍କ୍ ଏଇଙ୍ଗ୍ ହଜାର୍‌ ରୁପା ମୁଦ୍ରା ଇସ୍‌‍ମାତ୍‍ତିନ୍‍, ହିୱ୍‍ଉଡ଼ା, ନାନ୍ ମେଣ୍ଡେ ଏଇଙ୍ଗ୍ ହଜାର୍‌ ଲାବ୍ ପାହେମ୍‍ ଆତ୍‍ତାନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ମାଲିକ୍ ସାର୍‍ଦେ ଆଶେ କେତ୍‍ତଣ୍ଡ୍, ଟିକ୍ ମାଡ଼୍‍ତିନ୍, ନିମ୍‍ ଲେକେତ୍‍ ନୁ ବିଶ୍ୱାସ୍ତ ଦାସନି । ନିମ୍‍ ବିଶ୍ୱାସ୍ତେ ଲେକାମ୍ ସୁଦୁର୍ ଦନ୍‍ତିଙ୍କ୍ କାର୍‍ବାର୍‍ ମାଡ଼ି ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ନି କାୟିଦେ ନାର୍‍ଗେ ଦନ୍ ୱିଡ଼୍‍ସିଦ୍‍ତାନ୍‍ । ୱାଡ଼ା, ନା ତଡ଼୍ ୱେଡ଼୍‍କା ମାଡ଼ା । ");
INSERT INTO kff_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ରେଣ୍ଡ୍ ହଜାର୍‌ ରୁପା ମୁଦ୍ରା ଆସ୍‍ମାନ୍ଦାନ୍ ଚାକର୍ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, ଗଟ୍, ନିମ୍‍ ନାକିଂଙ୍କ୍ ରେଣ୍ଡ୍ ହଜାର୍‌ ଇସ୍‌‍ମାତ୍‍ତିନ୍‍, ନାନ୍‍ନେ ମେଣ୍ଡେ ରେଣ୍ଡ୍ ହଜାର୍‌ ଲାବ୍ ମାଡ଼୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ମାଲିକ୍ କେତ୍‍ତଣ୍ଡ୍, “ଲେକେତ୍‌ ମାଡ଼୍‍ତି । ନିମ୍‍ଆନ୍ତେ ଲେକେତ୍‍ ଚାକର୍ ତନି । ସୁଦୁର୍ ଦନ୍‍ତାଗେ ବିଶ୍ୱାସ୍ ତତ୍‍ତିନ୍‍ । ନାର୍‍ଗେ ଦନ୍ ନାନ୍ ନି ମାଇଦିଙ୍କ୍ ଗୁଡ଼୍‍ପି ମାଡ଼ିଦ୍‍ତାନ୍‍ । ୱାଡ଼ା ନା ସାର୍‍ଦେ ତାଗ୍ ବାଗି ଆୟ୍‍ମ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ଶେଷତ ୱେରଡ଼୍ ହଜାର୍‌ ମୁଦ୍ରା ଆସ୍‍ମାନ୍ଦାନ୍ ଚାକର୍ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ, ନାନ୍ ପୁତ୍‍ତାନ୍, ନିମ୍‍ ୱେରେତନି କଟରି ନାରୁନୀ ୱିତ୍‍ୱେ ୱାୟେତାଗାଙ୍କ୍ ନିମ୍‍ ପାଣ୍ଡ୍‌ସ୍ପା ନନି । ୱିଜ୍‍ ୱିତକଟ୍ ପସଲ୍‍ତିଙ୍କ୍ ଗୁଡ଼୍‍ପାନନି । ");
INSERT INTO kff_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍‍ନେ ନିକିଂଙ୍କ୍ ୱେର୍‍ସ୍‍ ମେଣ୍ଡେ ନି ଡାବ୍‍ତିଙ୍କ୍ ଅସ୍ ବୂମ୍‌ତାଗ୍‍ ମିସି ମାତ୍‍ତାନ୍ । ଉଡ଼େ, ନିୟାଦ୍ ଆଦ୍ ଡାବ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ମାଲିକ୍ କେତ୍‍ତଣ୍ଡ୍, “ଆରେ ଅଯୋଗ୍ୟ, ମଣ୍ଡି ଦାସ ! ନିମ୍‍ବାନେ ପୁଞ୍ଜ୍‍ମାତ୍‍ତିନ୍‍ ନାନ୍‍ନେ ବେଗେ ୱିତନ୍‍, ଆଗେ ପାଣ୍ଡ୍‌ସ୍ପାନଙ୍କ୍‌, ଆଦ୍‍ନିମେ ପୁତ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ଆଲାଇତ୍‍କେ ନା ଡାବ୍‍କ୍ ଆସ୍ ନିମ୍‍ ବ୍ୟାଙ୍କ୍‍ତାଗ୍ ଗୁଡ଼୍‍ପି ମାଡ଼େନି । ଆସୁଙ୍କ୍ ନାନ୍ ଆୱିଙ୍କ୍ ସୁଦତଡ଼୍ ମାଲ୍‍ପିୱେନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଆଲାକେସ୍‍ ମାଲିକ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍, ହି ଚାକର୍‍ତେ କାୟ୍‍ଦେକଞ୍ଚ୍ ହି ଡାବ୍‍କ୍ ଟେଣ୍ଡିଅସ୍‍ ବେନ କାୟ୍‍ଦେ ଦଶ ହଜାର୍‌ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ଆଉ ହିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନନାଗ୍‍ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ଅଦିକ୍‌ ହିଦ୍‍ୱେୟ୍‍ତିତ୍‍ ନୁ ଅଣ୍ଡ୍‌ ନାର୍‍ଗେ ଲାବ୍ ମାଡ଼ିତନ୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନନାଗ୍‍ ଇଲେ, ଅନାୱୁ ବାତା ମିନ୍ଦେ, ଆଉ ଆନ୍ତେ ଟେଣ୍ଡି ଆଦ୍‍ଦେ ୱେୟିତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ହି ବେସତ୍ ଚାକର୍‍ତିଙ୍କ୍ ବାୟିଦେ ଇକାଡ଼୍‌ତାଗ୍ ଆୟ୍‍ମୁଟ୍ । ଆଗେ ଅଣ୍ଡ୍‌ କେୟ୍‍ତନ୍ ନୁ ପାଲ୍‍କ୍ କିଟ୍ରୁମ୍‍ କାଟ୍ରୁମ୍ ମାଡ଼ମାନିଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ବେସୁଙ୍କ୍‍ ନାରୁନ୍‍ପିଲେ ରାଜାଲ୍ ଆଶେ ତାନ୍ ଦୂତକି ତ ୱାଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଗୌରବମୟତେ ସିଂହାସନ୍‍ତାଗ୍ କୁଦିତଣ୍ଡ୍,” ");
INSERT INTO kff_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ଜଗତ୍‍ତେ ସାରେ ଜାତିତ୍ ନାରୁଡ଼୍ ଅନ୍‌ ମୁନେ ଅଣ୍ଡୟ୍‌‍ ଆଦ୍‍ତଡ଼୍ । ଆସୁଟେ ମେକ୍‍ଗଲାଲ୍‍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ମେକା ନୁ ମେଣ୍ଢାକିଂଙ୍କ୍ ୱେରେ ମାଡ଼ିତନ୍, ନାରୁନ୍‍ପିଲେ ରକମ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରେଣ୍ଡ୍ ମାନ୍ଦେତେ ୱେରେ ମାଡ଼ିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ଦାର୍ମିକ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ ତିନ୍ଦେପାକ୍ ନୁ ୱେର୍‍ତଡ଼୍‍କିଙ୍କ୍ ଅନ୍‌ ଡେବ୍‍ପାକେ ନେହ୍‍ତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ତାନ୍‍ପେର୍କେ ଅନ୍‌ ତିନ୍ଦେପାକ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରାଜାଲ୍ କେତିତଣ୍ଡ୍, ୱାଡ଼ାଟ୍, ମିକିଂଙ୍କ୍ ନା ବାବାଲ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍ । ତିଆର୍‍ତେ ମୁନେଙ୍କ୍ ବେନ୍ ରାଜ୍ୟ ମିଇ ମାଇଦିଙ୍କ୍ ତିଆର୍ ଆସ୍‍ମିନ୍ଦେ, ୱାଡ଼ାଟ୍, ଆଗେ ନେଙ୍ଗାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ନାନ୍‍ନେ କାର୍‍ୱିନ୍ ମାତ୍‍ତାନ୍, ମିଡ଼୍ ନାକିଂଙ୍କ୍ ତିନ୍ଦାଙ୍କ୍ ହିତ୍‍ତିଡ଼୍‍; ନାକ୍ ଉନ୍ଦ୍‍ୱାହ୍‍ସ୍‍ ମାତ୍‍ତେ, ମିଡ଼୍‍ନାକିଙ୍କ୍ ହୁନ୍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ହିତ୍‍ତିଡ଼୍‍ । ନାନ୍‍ନେ ପୁନ୍‍ୱେ ମାତ୍‍ତାନ୍, ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଲୋନ୍‌ କାର୍‍ଙ୍ଗିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ନାନ୍‍ନେ ବାଣ୍ଡା ମାତ୍‍ତାନ୍, ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଚକାସେଡ଼ି କେର୍‍ସ୍ପିତିଡ଼୍ । ନାନ୍‍ନେ ରଗ୍‍ତେ ମାତ୍‍ତାନ୍, ନା ଯତନ୍ ଆତ୍‍ତିଡ଼୍‍ । ନାନ୍‍ନେ ବନ୍ଦିଲତ୍‍ତାଗେ ମାତ୍‍ତାନ୍, ନାକିଂଙ୍କ୍ ଉଡାଙ୍କ୍ ୱାତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ଦାର୍ମିକ୍ ନାରୁଡ଼୍‍ ଉତ୍ତର୍ ହିଦ୍‍ତଡ଼୍, “ପ୍ରବୁ ! ବେସୁଙ୍କ୍‍ ନିକିଂଙ୍କ୍ କାର୍‍ୱିନ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ତିନ୍ଦାଙ୍କ୍ ହିତ୍‍ତମ୍‍ ? ବେସୁଙ୍କ୍‍ ନିକିଂଙ୍କ୍ ଉନ୍ଦେ ୱାତ୍‍ତାଦ୍ ଉଡ଼ି ହୁନ୍ଦାଙ୍କ୍ ହିତ୍‍ତମ୍‍ ? ");
INSERT INTO kff_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ବେସୁଙ୍କ୍‍ ନିମ୍‍ ପୁନ୍‍ୱେ ଆୟ୍‍ୟକଟ ମାତ୍‍ୱେୟ୍‍ ନିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗିତିଡ଼୍ ମାଡ଼୍‍ତମ୍ ? ବେସୁଙ୍କ୍‍ ବାଣ୍ଡା ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ଚକା କେର୍ସ୍ପତମ ? ");
INSERT INTO kff_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ବେସୁଙ୍କ୍‍ ନିକିଂଙ୍କ୍ ରଗ୍‍ତେ ବା ବନ୍ଦି ଅବସ୍ଥାତେ ଉଡ଼ି ନିକିଂଙ୍କ୍ ସେବା ମାଡ଼୍‍ତମ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ରାଜାଲ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, ନାନ୍‍ନେ ସତ୍ କେତୁତାନ୍, ହି ଦାଦାଲଡ଼୍ ଲୋପେ ସାର୍‍ରେତଡ଼୍‍ ଡ଼ାଗାଙ୍କ୍ ସୁଦୁର୍ ମାଇଦିଙ୍କ୍ ବାତେଏ ମାଡ଼୍‍ତିଡ଼୍ ଆଦ୍ ନା ମାଇଦିଙ୍କ୍ ମାଡ଼ିତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ତାନ୍‍ପେର୍କେ ଡେବ୍‍ପାକେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତିତଣ୍ଡ୍, “ଆର୍ ଅବିଶାପ୍‌‍ତେ ମାନ୍ଦେ ! ନା ମୁନେକଙ୍କ୍ ଦୁରାମ୍ ଆୟ୍‍ମୁଟ୍‍ ।” ଶୟ୍‍ତାନ୍‍ ନୁ ତାନ୍ ଦୂତତେ ପେର୍କେ ଆଦାନଡ଼୍‍ ମାଇଦିଙ୍କ୍ ବେଗେ ସାରେଦିନା ନିଡ଼୍‍ତାନାଦ୍ କିସ୍ ତିଆର୍ ଆସ୍‍ମିନ୍ଦେ, ଆଗେ ଆନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ନାନ୍‍ନେ କାର୍‍ୱିନ୍ ମାତ୍‍ତାନ୍, ମିଡ଼୍ ନାକିଂଙ୍କ୍ ତିନ୍ଦାଙ୍କ୍ ହିୱିଡ଼୍‍ । ନାକ୍ ଉନ୍ଦେୱାହ୍‍ତେ ୱେୟ୍ ଏର୍‍ ହୁନ୍ଦାଙ୍କ୍ ହିୱିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ନାନ୍‍ନେ ପୁନ୍‍ୱେ ମାନ୍ଦାନ୍ ୱେୟ୍ ନାକ୍ ମିଇ ଲୋନ୍‌ କାର୍‍ଙ୍ଗିତିଡ଼୍ ମାଡ଼୍‍ୱିଡ଼୍ । ନାନ୍‍ନେ ବାତ୍‍କେର୍‍ୱେ ୱେୟ୍ ଚକାସେଡ଼ି କେର୍‍ସ୍ପିୱିଡ଼୍‍ । ରଗ୍‍ତେ ନୁ ବନ୍ଦି ଅବସ୍ଥାତେ ମାନ୍ଦାନ୍‍ୱେୟ୍‍ ନାକିଂଙ୍କ୍ ଉଡାଙ୍କ୍ ୱାଡ଼୍‍ୱିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ଆସୁଟେ ଅଡ଼୍‌ ଉତ୍ତର୍ ହିଦ୍‍ତଡ଼୍, “ପ୍ରବୁ, ବେସୁଙ୍କ୍‍ ନିକିଂଙ୍କ୍ କାର୍‍ପୟିତେ, ଉନ୍ଦେୱାହ୍‍ତେ, ପୁନ୍‍ୱେ, ବାତେଏ କେର୍‍ୱେ ୱେୟ୍, ରଗ୍‍ତେ ବା ବନ୍ଦି ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ମାମ୍‍ମେ ନିକିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“ରାଜାଲ୍ ଉତ୍ତର୍ ହିଦ୍‍ତଣ୍ଡ୍, ‘ନାନ୍ ସତ୍ କେତୁତାନ୍, ହି ସୁଦୁର୍ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ଅର୍‍ତୁଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାଙ୍କ୍ ମନା ମାଡ଼ାନ୍‍ୱେୟ୍‍, ନିମ୍‍ ନାକିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼୍‍ୱିଡ଼୍ ।’ ");
INSERT INTO kff_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ହି ନାରୁଡ଼୍ ସାରେ ଦିନାତ୍ ମାଇଦିଙ୍କ୍ ଦଣ୍ଡ୍ ଆଦ୍‍ତଡ଼୍ ନୁ ଦାର୍ମିକିଡ଼୍‍ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଲାବ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ହି ସାରେ ଶିକ୍ଷାଇସ୍‌ ତେର୍‍ସ୍ପ୍‍ତେ ପେର୍କେ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍, ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ମେଣ୍ଡ୍‍ରେଣ୍ଡ୍ ଦିନା ମିନ୍ଦେ ଇଦ୍ ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ । ଆସୁଟେ ନାରୁନ୍‍ପିଲେ କ୍ରୁଶତାଗ୍ ତାର୍‍ପ୍ସାନ୍ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ସମର୍‍ପିତ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ହି ସମୟ୍‍ତେ ମୁକ୍ୟ ଦାଇତ୍ୟତେ ମାନ୍ଦାନ୍ ନୁ ବାଗାତଡ଼୍‍ ଯିହୁଦିନେତାଲଡ଼୍ ବେଡ଼ିୟ୍‍ଯାଜକ୍ କୟାପାନ୍‍ ଲୋତେ ଦୁୱାଡ଼୍‍ତାଗେ ଅଣ୍ଡୟ୍‌‍ୟାଗେ ଗୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ଜିସୁଙ୍କ୍ ବେନ ଚଲନାମାଡ଼ି ପୟ୍‍ସ୍ ରେହ୍‍ତାନ୍‍ ମାଇଦିଙ୍କ୍ ଚକ୍ରାନ୍ତ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍ “ହି ପାଡ଼୍‍ୟି ମାମ୍ ମାଡ଼ାନାଦ୍ ଲେକାମ୍ ହିଲକଟ୍ ମାତ୍‍କେ । ଆସୁଟେ ନାରୁଡ଼୍ ଅଶାନ୍ତି ମାଡ଼୍‍ପାର୍‍ୱେଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ଅନ୍‌‍ଦିନେ ଜିସୁ ବେତନିତାଗେ ମୁନେଙ୍କ୍ କୁଷ୍ଟରଗ ଆସ୍‍ମାନ୍ଦାନ୍ ଶିମୋନ୍ ଲୋନ୍‌ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ଶିମୋନ୍‍ତେ ଲୋନ୍‌ ଜିସୁ ତିନ୍ଦାଙ୍କ୍ କୁଦାନ୍‍ୱେଲେ ୱେରଡ଼୍ ମୁତ୍‍ତେ ଅଣ୍ଡୟ୍‌ କାଲ୍‍ଦେ ତିଆର୍ ଆତ୍‍ତେ ଗିନେତାଗେ ମୁଲ୍ୟତାଦ୍ ସାୟ୍‍ତ୍‌ ଗାବ୍‍ତେ ନିୟ୍ ବର୍ତ୍ତି ମାଡ଼ି ଜିସୁନ୍ ତାଲେତ୍ ପର୍‍ର ତଶ୍‍ସିତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ଶିଷ୍ୟଡ଼୍ ଇଦ୍ ଉଡ଼ି କପାମ୍ ଆଦ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ତାଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ହିସର୍ ନଷ୍ଟ ମାଡ଼୍‍ତି ବାତେଙ୍କ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ହି ଗାବ୍‍ ମାନ୍ଦାନ୍ ନିୟ୍‍ଦିଙ୍କ୍ ନାର୍‍ଗେ ଡାବ୍‍ତେ ୱାମାଙ୍କ୍ ପାର୍‍ୱେନି ନୁ ଆଦ୍ ଦନ୍‍ତିଙ୍କ୍ ଗରିବ୍‍ନଡ଼୍‍କ୍ ଦାନ ମାଡ଼ିଦ୍‍ ପାର୍‍ୱେନି ।” ");
INSERT INTO kff_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ଅଡ଼୍‌ ବାତ୍‍ କେତୁତଡ଼୍, ଜିସୁ ପୁଞ୍ଜ୍‍ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍, “ଆଦ୍ ମୁତେଙ୍କ୍ ବାତେଙ୍କ୍ ଅଇରାନ୍ ମାଡ଼ୁତିଡ଼୍ ? ନା ମାଇଦିଙ୍କ୍ ଆଦ୍ ଅଣ୍ଡୟ୍‌ ସାୟେତ୍ ନୁ ସୁନ୍ଦର୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ଗରିବ୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମିଡ଼୍ ସାରେଦାମ୍ ପାହେମ୍‍ ଆଦ୍‍ତିଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାକିଂଙ୍କ୍ ସାରେଦାମ୍ ପାହେମ୍‍ ଆୟ୍‍ୱିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ନା ତାଲ୍‍ତାଗ୍‍ ଗାବ୍‍ ମାନ୍ଦାନ୍ ନିୟ୍ ତଶ୍‍ସି ଆଦ୍ ନାକିଂଙ୍କ୍ ସମାଦି ଇଦାନଙ୍କ୍ ତିଆର୍ ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ କେତୁତାନ୍, ସାରେ ଜଗତ୍‍ତାଗେ ଯେ ବେନ୍‌ଆଇ ପଡ଼ିୟେତାଗ୍, ଇ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ଆଦ୍‍ତେ, ଇ ମୁତ୍‍ତେ ବାତେଏ ମାଡ଼ିତେ, ତାଙ୍କ୍ ହେର୍କା ମାଡ଼ି ଆଦିଙ୍କ୍ ଆନ୍‌‍ତେ ଲେକେ ୱେୟିତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ଜିସୁନ୍ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍ ଲପ୍ ଇଷ୍କାରିୟ ଯିହୁଦା ପେଦେର୍ ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଶିଷ୍ୟ ମୁକ୍ୟ ଯାଜକିଡ଼୍‍ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ଜିସୁଙ୍କ୍ ପସ୍ପିତ୍‍କେ ନାକିଂଙ୍କ୍ ବାତେଏ ଇଦ୍‍ତିଡ଼୍ ?” ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ତିରିଶ୍‍ଟାନ୍ ରୁପାମୁଦ୍ରାଲେକି ଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ଆଦ୍ ଦିନ୍ କଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ଅଡ଼୍‌ କାୟ୍‍ଦେ ପସ୍ପିଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଯିହୁଦାଲ୍‍ ସୁଯଗ୍‍ ମେହ୍‍କ୍‍ ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ତାଡ଼ି ଶୁନ୍ୟ ରୂଟି ପାଣ୍ଡୁମ୍‍ତେ ମୁନେତ୍ ଦିନେତେ ଶିଷ୍ୟଡ଼୍ ୱାସ୍ ଜିସୁଙ୍କ୍ ପାଚ୍ରା ମାଡ଼୍‍ତଡ଼୍, “ମାମ୍ ବେଗାକଞ୍ଚ୍ ନି ମଇଦିଙ୍କ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ବଜ ତିଆର୍ ମାଡ଼ିତମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ସହର୍‍ତାଗ୍ ଆଞ୍ଜ୍ ଆଦ୍ ବେନ୍‌ଆଇ ନାରୁଙ୍କ୍ କେତିତିଡ଼୍, ‘ଗୁରୁ କେତୁତଣ୍ଡ୍ ନାୟାଦ୍ ଦିନାମ୍ ଗାର୍‍ରେ ହେୱ୍‍ସ୍‍ ୱାସମିନ୍ଦେ । ତାନ୍ ଶିଷ୍ୟଡ଼୍ ତ ମିଇ ଲୋନ୍‌ ଅଣ୍ଡ୍‌ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ପାଲନ୍ ମାଡ଼ିତନ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ଜିସୁ କେତ୍‍ତାନ୍ ଲେକାମ୍ ଶିଷ୍ୟଡ଼୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ବଜ୍ ମିଟିଙ୍କ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ମୁଲ୍‍ପୁଟ୍ ଆତ୍‍ତାଙ୍କ୍ ଜିସୁ ନୁ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍ ତିନ୍ଦାଙ୍କ୍ କୁଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ତିନ୍ଦାନ୍ ୱେୟ୍ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ମିଇ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ନାକିଂଙ୍କ୍ ଶତ୍ରୁଡ଼୍ କାଇଦେ ସମର୍‍ପନ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ଶିଷ୍ୟଡ଼୍ ଗାଟି ଦାନ୍ଦେ ଆଶେ ୱେରନ୍ ପେର୍କେ ୱେରନ୍ ଜିସୁଙ୍କ୍ ପାଚ୍ରା ମାଡ଼୍‍ତଡ଼୍, ନିମ୍‍ ନିଜାମ୍ ନାକିଂଙ୍କ୍ ଉଡ଼ି କେଲ୍‍ୱିନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ବେନ ନା ତଡ଼୍ ୱେରଡ଼୍ ପାତ୍ରତାଗେ ରୂଟି ଲିହ୍‍ତିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ଶତ୍ରୁଡ଼୍ କାଇଦେ ସମର୍‍ପନ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ଶାସ୍ତ୍ରତାଗ୍ ଲେକ୍‍ତାଦ୍ ଲେକାମ୍‍ତେ ନାରୁନ୍‍ପିଲେ ଡଲିତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁନ୍‍ପିଲେତିଙ୍କ୍ ବେନ ପସ୍ପିଦ୍‍ତଣ୍ଡ୍, ଅନାଦ୍‌ ଦଶା ବେସର୍ ବୟଙ୍କର୍ ଆଦ୍‍ତେ ! ବେସୁଙ୍କ୍‍ ଜନମ୍ ଆୟ୍‍ୟକଟ ମାତ୍‍କେ ଅନ୍‌ ମାଇଦିଙ୍କ୍ ସାୟ୍‍ ଆୟେଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ଶତ୍ରୁଡ଼୍ କାଇଦେ ସମର୍‍ପନ୍ ମାଡ଼ାନ୍ ଯିହୁଦାଲ୍‍ ତେଦି ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, “ଗୁରୁ, ନିମ୍‍ ନାକିଂଙ୍କ୍ ଉଡ଼ି କେଲ୍‍ୱିନ୍‍ ତ !” ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ଆଦ୍ କେତୁତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ଅଡ଼୍‌ ତନ୍ଦାନ୍‍ ସମୟ୍‍ତେ ଜିସୁ ୱେରଡ଼୍ ରୂଟି ଅସ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍ ହିତ୍‍ତଣ୍ଡ୍ ନୁ ଆଦିଙ୍କ୍ ଉସ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଆୟ୍‍ମୁଟ୍, ତିନୁଟ୍‍, ହିଦ୍ ନାୟାଦ୍ ମେନ୍ଦୁଲ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଦେବ୍‍ତିଙ୍କ୍ ଆସ୍ ଇଶ୍ୱରତିଙ୍କ୍‍ ଦନ୍ୟବାଦ୍ ଇତ୍‍ତଣ୍ଡ୍ ନୁ ଆଦ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ସାରେ ଇଗାଙ୍କ୍ ଉନୁଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ଇଦ୍ ନାୟାଦ୍ ନେତୁର୍ । ନାରୁଡ଼ାଦ୍ ପାପ୍ କ୍ଷମାତେ ମାଇଦିଙ୍କ୍ ନାନ୍‍ନେ ନା ବେନ୍ ନେତୁର୍‍ ତଶ୍‍ସିଦାଙ୍କ୍ ଆଦୁତାନ୍, ବେଦ୍ ଇଶ୍ୱର୍‌ତେ ପୁନାଦ୍ ନିୟମ୍‍ତିଙ୍କ୍ ମୁଦ୍ରାଙ୍କିତ ମାଡ଼ିତ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ନାନ୍‍ନେ କେସ୍ ନେହ୍‍ତୁତାନ୍‍, ନା ବାବାନ୍ ରାଜ୍ୟତାଗେ ମିଇ ତ ପୁନାଦ୍ ଦ୍ରାକ୍ଷାରସ୍ ଉନ୍‍ନା ଯାକ ନାନ୍ ମେଣ୍ଡେ ବେସୁଙ୍କ୍‍ ଅଙ୍ଗୁର୍‌ରସ୍ ଉନ୍‍ନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ଆଦିନ୍ ପେର୍କେ ଅଡ଼୍‌ ଦନ୍ୟବାଦ୍ ପାଟା ପାର୍‍ରି ମେଟେତାଗେ ଆତ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ଆଦ୍ ସମୟ୍‍ତେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନେଣ୍ଡ୍ ନାର୍‍କେତ୍ ମିଡ଼୍ ସାରେ ନାକିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ଆଦ୍‍ତିଡ଼୍ । ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ନାନ୍ ମେଣ୍ଢା ପଡ଼୍‍ପାନଙ୍କ୍ ଆୱ୍‍କିତାନ୍‍ ନୁ ମେଣ୍ଢା ୱେରେ ୱେରେ ଆଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍‍ନେ ମେଣ୍ଡେ ଆଦ୍ ଅଦିକ୍‌ ମିଇ ମୁନେଙ୍କ୍ ଗାଲିଲୀତାଗ୍ ଆଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ପିତର୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ସାର୍‍ତଡ଼୍ ନିକିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ଆତ୍‍କେ ବା ନାନ୍‍ନେ ବେସୁଙ୍କ୍‍ ବା ଆନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜିସୁ ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନାନ୍‍ନେ ନିଜାମ୍‍ କେତୁତାନ୍, ନେଣ୍ଡ୍ ନାର୍‍କେତ୍ କର୍କ୍‍କୁସାନ୍ ମୁନେଙ୍କ୍ ନିମ୍‍ ନାକିଂଙ୍କ୍ ପୁନନ୍ ଇଞ୍ଜ ମୁଣ୍ଡ୍‍ଦାମ୍ କେତିତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତର୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନି ତ ଡଲାଙ୍କ୍ ଇତ୍‍ତ୍କେ ବା ନାନ୍‍ନେ ବେସୁଙ୍କ୍‍ ନିକିଂଙ୍କ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ନ୍ ।” ବାଗାତ୍ ଶିଷ୍ୟଡ଼୍ ଆନ୍‌‍ତେ ସାରେ ରକମ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ତାନ୍ ପେର୍କେ ଜିସୁ ଶିଷ୍ୟଡ଼୍ ତ ଗେତ୍‍ସମନି ପେଦେର୍‍ତେ ୱେରଡ଼୍ ପଡ଼ିୟେତାଗ୍ ଆଞ୍ଜ୍ କେତ୍‍ତଡ଼୍, “ମିଡ଼୍ ହିଗ୍ ସେନେକ୍‍ କୁଦାଟ୍‍ । ନାନ୍‍ନେ ଆଗେ ଆଞ୍ଜ୍ ମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ଆଦ୍ ପିତର୍ ନୁ ଜେବଦିନ୍ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କିଙ୍କ୍ ଅନ୍‌‍ତଡ଼୍ ଆତ୍‍ତେ । ଆସୁଟେ ଜିସୁ ଗାଟି ଦୁଃକ ଯନ୍ତ୍ରତାଗେ ବ୍ୟାକୁଲ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଦୁଃକତେ ନା ହୃଦୟ୍ ୱାଡ଼୍‍କୁତ୍‍ । ହିଗେ ନାକିଙ୍କ୍‌ କେପି ମାନୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଜିସୁ ସୁଦୁର୍ ଦୁରାମ୍ ଆଞ୍ଜ୍ ବୁମ୍‍ତାଗେ ମକମ୍ ମଦଲ୍ ମାଡ଼ି ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଣ୍ଡ୍, “ବାବାଲ୍ ! ଯଦି ନିଜାମ୍ ଆତ୍‍କେ, ଇ ଦୁଃକାମ୍‍ତାଦ୍ ଦାୟାକ୍ ନାୟାଗାଙ୍କ୍ ଦୁର୍‍ ମାଡ଼ା, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ଇଚ୍ଛା ଆୟ୍‍ୟ, ନିୟାଦ୍ ଇଚ୍ଛା ସାରେ ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ତାନ୍ ପେର୍କେ ଅଣ୍ଡ୍‌ ମୁୱୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍ ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ୱାସ୍ ଉଡ଼୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌ ପୁଞ୍ଜ୍ ମିନ୍ଦେଡ଼୍‍ । ଜିସୁ ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ମୁୱୁଡ଼୍‍ ଯାକ ନା ତଡ଼୍ ୱେରଡ଼୍ ଗାଣ୍ଟା ଯାକ କେପ୍‍ପେ ପାର୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ପରିକ୍ଷାତେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଆଗ୍ ଆୟ୍‍ୱିଡ଼୍‍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ କେପିମେଣ୍ଡେ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ । ମିୟାଦ୍ ଆତ୍ମା ଉଦ୍‍ଯଗ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମେନ୍ଦୁଲ୍ ଦୁର୍ବଲ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଜିସୁ ମେଣ୍ଡନ୍ ଦାମ୍ ଆଞ୍ଜ୍ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଣ୍ଡ୍, “ବାବାଲ୍ ! ଯଦି ହି ଦୁଃକାମ୍‍ତେ ପାନପାତ୍ରତିଙ୍କ୍ ନାୟାଗାଙ୍କ୍ ଯେକା ମାଡ଼ାଙ୍କ୍ ଆୟ୍‍ୟ ନୁ ନାକିଂଙ୍କ୍ ଆଦ୍ ଉନ୍ଦ୍‍ୱେୟ୍‍ତିତ୍‍, ନିୟାଦ୍ ଇଚ୍ଛା ସାରେ ସଫଲ ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ଅଣ୍ଡ୍‌ ମେଣ୍ଡନ୍ ଦାମ୍ ୱାସ୍ ଶିଷ୍ୟଡ଼୍ ଉଞ୍ଜିମାନ୍ଦାନାଦ୍‍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ କଣ୍ଡା ତେର୍‍ସ୍‍ ଉଡ଼ି ମାନ୍ଦ୍ ପାର୍‍ୱ କଟ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ସୁଦୁର୍ ଦୁରାମ୍ ଆଞ୍ଜ୍ ମୁଣ୍ଡ୍‍ଦାମ୍‍ତେ ଆଦେପଟୁଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତାନ୍ ପେର୍କେ ଶିଷ୍ୟଡ଼୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଇଞ୍ଜେକ୍ ଆଇନା ଉଞ୍ଜି ରମୁତିଡ଼୍‍ ? ଉଡ଼ାଟ୍, ନାରୁନ୍‍ପିଲେ ଦୁଷ୍ଟ ନାରୁଡ଼୍ କାୟ୍‍ଦେ ସମର୍‍ପିତ ଆଦ୍‍ଦାନ୍ ଦିନାମ୍ ହେୱ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ତେଦାଟ୍ ମାନାଡ଼୍‌ ଅଦିକା, ଉଡ଼ାଟ୍, ବରନ ନାକିଂଙ୍କ୍ ଶତ୍ରୁଡ଼୍‌ କାଇଦେ ପସ୍ପିତେ ନାରୁଡ଼୍ ୱାସ୍ ହେୱ୍‍ସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଜିସୁ ହି ଗଟ୍ କେତ୍‍ତାନ୍ ୱେୟ୍, ଅନ୍‌ ବାରଶିଷ୍ୟଡ଼୍‍ ଲପ୍ ଯିହୁଦା ପେଦେର୍‍ତେ ଶିଷ୍ୟ ୱାସ୍ ହେୱ୍‍ତଣ୍ଡ୍ । ଅନ୍‌ ତଡ଼୍ ସୁରି ନୁ ଟେଙ୍ଗା ପୟ୍‍ସ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଆଗେ ଗୁଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମୁକ୍ୟ ପୁଜାରି ନୁ ଦର୍ମନେତାଲଡ଼୍‍ ରୟ୍‍ସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ବିଶ୍ୱାସ୍ ଆୟ୍‍ୱିଡ଼୍ ଯିହୁଦାଲ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେରଡ଼୍ ସଙ୍କେତ ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ଟିକ୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବେନ୍ ନାରୁଙ୍କ୍ ନାନ୍‍ନେ ସୁମା ହିଦ୍‍ତାନ୍, ଅଂକିଙ୍କ୍‌ ମିଡ଼୍ ମେହେକୁତିଡ଼୍ । ଅଂକିଙ୍କ୍‌ ପୟ୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଯିହୁଦାଲ୍‍ ଆଞ୍ଜଡ଼େ ଜିସୁନ୍ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଅଂକିଙ୍କ୍‌ ନମସ୍କାର୍ ମାଡ଼ି ସୁମା ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ସାଙ୍ଗ, ନିୟାଦ୍ ପାଡ଼୍‍ୟି ସିଟ୍‍ପାଟ୍ ତେର୍‍ସ୍ପାନ୍ ।” ତାନ୍ ପେର୍କେ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ପୟ୍‍ସ୍ ବନ୍ଦି ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଜିସୁନ୍ ପାକାଙ୍କ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ନିଜେତ୍ ସାକୁ ପେସ୍‍ପି ମୁକ୍ୟ ପୁଜାରିନ୍ ଚାକର୍‍ତିଙ୍କ୍ ରେହ୍‍ତଣ୍ଡ୍ । ଆଦ୍ ନାରୁନ୍ କେୱୁ ତେଗ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ଜିସୁ ପିତର୍‌ତିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନି ସାକୁତିଙ୍କ୍ ତାନ୍ ପଡ଼ିୟେତାଗ୍ ନେହେମ୍ । ବେନଡ଼୍ ସାକୁତେ ଲାଗେମ୍‍ ଆଦ୍‍ତଡ଼୍, ଅଡ଼୍‌ ସାକୁତେକେ ଡଲିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ମିଡ଼୍ ବାତେଏ ପୁନ୍‍ୱିଡ଼୍, ନାନ୍‍ନେ ନା ବାବାଙ୍କ୍ ସାହାଯ୍ୟ ତାଲ୍‍କାନ୍ ହିତ୍‍କେ, ଅଣ୍ଡ୍‌ ନା ମାଇଦିଙ୍କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ବାର୍‍ଟାନ୍ ବାହିନିକିନ୍‍ ୱିଡ଼୍‍ସି ନାର୍‍ଗେ ଦୂତକିଙ୍କ୍ ରହତ୍‍ ପାର୍‍ତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଲାଇତ୍‍କେ ହିସାର୍‍ରେ ଗଟେମ୍ ଆଦ୍‍ତେ ଇଞ୍ଜ ଶାସ୍ତ୍ରତାଗ୍ ବାତ୍ ଲେକାମିନ୍ଦେ, ଆଦ୍ ସାରେ ଆଦ୍‍ତେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ଜିସୁ ତାନ୍‍ପେର୍କେ ଗୁଡ଼୍‍ଡି ମାନ୍ଦାନ୍ ଆଦ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନାନ୍ ବାତେଏ ୱେରଣ୍ଡ୍ ଡଙ୍ଗାଲ୍, ସାକୁ ଟେଙ୍ଗା ପୟ୍‍ସ୍ ନାକିଂଙ୍କ୍ ପୟ୍‍ଦାଙ୍କ୍ ୱାତ୍‍ତିଡ଼୍ ? ସାରେ ଦିନା “ନାନ୍‍ନେ ମନ୍ଦିର୍ ତାଗ୍ କୁଦି ଶିକ୍ଷା ଇସମାତ୍‍ତାନ୍‍, ଆସୁଙ୍କ୍ ତ ନାକିଂଙ୍କ୍ ପୟ୍‍ୱିଡ଼୍‍ ! ");
INSERT INTO kff_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ଅଣ୍ଡ୍‌ ବାତ୍‍ଆଇ, ବାବବାଦୀଡ଼୍ ଶାସ୍ତ୍ରତାଗ୍ ବାତା ଲେକିମିନ୍ଦେଡ଼୍, ଆଦ୍ ସାରେ ସପଲ୍‍ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ହିଦ୍ ଗଟେମ୍ ଆଦୁତ୍‍ ।” ଆଦ୍ ସମୟ୍‍ତେ ଶିଷ୍ୟଡ଼୍ ସାରେତଡ଼୍ ଜିସୁଙ୍କ୍ ୱିଡ଼୍‍ସି ମିର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଜିସୁଙ୍କ୍ ପସ୍ପିତ୍‍ନଣ୍ଡ୍ ଅଂକିଙ୍କ୍‌ ବେଡ଼ିଇ ଯାଜକ୍‍ତାଗେ କୟାପାନ୍‍ ଲୋନ୍‌ ଆତ୍‍ତଡ଼୍ । ଆଗେ ଦର୍ମଗୁରୁ ନୁ ଦର୍ମନେତାଲଡ଼୍‍ ସମବେତ ଆଶେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ପିତର୍ ସୁଦୁର୍ ଦୁରାମ୍ ମାଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ପେର୍କେ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ ନୁ ଅଣ୍ଡ୍‌ କୟାପାନ୍‍ ଲୋନ୍‌ ଗେଟ୍‍ ଯାକ ଆତ୍‍ତଣ୍ଡ୍ । ହି ସାରେ ଗଟ୍‍ନାତେ ପରିନତ ବାତେଏ ଆଦ୍‍ତେ, ଉଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ପିତର୍ ଆଗେ ପ୍ରହରିନାରୁଡ଼୍‍ ତ କୁଦ୍‍ତଣ୍ଡ୍ ! ");
INSERT INTO kff_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ମୁକ୍ୟ ଯାଜକ୍‍କିଡ଼୍‍ ନୁ ବେଡ଼ିୟ୍‍ମିଟିଙ୍କ୍‍ତେ ସଦସିଡ଼୍‍ ଜିସୁଙ୍କ୍ ଡଲାନ୍‍ଦଣ୍ଡ ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ଅନ୍‌ ବିରୁଦ୍‍ତେ ବଲାନ୍‍ ପ୍ରମାନ୍ ଗୁଡ଼୍‍ପାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ନାର୍‍ଗେ ନାରୁଡ଼୍ ଜିସୁନ୍ ବିରୁଦ୍‍ତେ ବୁସା କେତ୍‍ତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ରକମ୍ ବାତେମେଣ୍ଡେ ସତ୍ ପାହେମ୍‍ ଆୟ୍‍ୟଡ଼୍ । ଶେଷତେ ଇର୍‍ୱୁଡ଼୍ ତେଦ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ଇ ନାରୁଡ଼୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ନାନ୍ ଇଶ୍ୱର୍‌ତେ ମନ୍ଦିର୍‍ତିଙ୍କ୍ ଲିକି ମୁଣ୍ଡ୍‍ଦିନାତେ ଲପ୍ ଆଦିଙ୍କ୍ ମେଣ୍ଡେ ତିଆର୍ ମାଡ଼ିଦ୍‍ ପାର୍‍ଦ୍‍ତାନ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ବେଡ଼ିୟେ ପୁରହିତ୍‌ ନିସ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନିମ୍‍ ବାତ୍‍ତିଙ୍କ୍ ବାତେଏ କେଲ୍‍ୱି ? ନି ବିରୁଦ୍‍ତେ ହି ଅବିଯଗ୍ କଣ୍ଡନ୍‍ ମାଡ଼ାନଙ୍କ୍ ନିୟାଦ୍ ବାତେଏ କେତାନାଦ୍ ଇଲ୍‍ଲେ ? ");
INSERT INTO kff_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ କଟ ମାତ୍‍ତଣ୍ଡ୍ । ବେଡ଼୍‍ୟାଦ୍‍ ଜାଜକ୍ କେତ୍ତଣ୍ଡ୍, ଜିୱୁନ୍‍ମାନ୍ଦାନ୍‍ ଇଶ୍ୱର୍‌ତେ ପେଦେର୍ ତେ ନାନ୍‍ନେ ନିକିଂଙ୍କ୍ ପାଚ୍ରା ମାଡ଼ୁତାନ୍, ସତ୍‍ତେ କେଲ୍‍ମ୍, ନିମ୍‍ ବାତେଏ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ କ୍ରିଷ୍ଟ ନି ? ");
INSERT INTO kff_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜିସୁ ଉତ୍ତର୍ ଇତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ଟିକ୍ କେତୁତିନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍‍ନେ ମିଇ ସାର୍‍ତଡ଼୍‍କ୍‍ କେତୁତାନ୍, ସିଟ୍‍ପାଟ୍ ନାରୁନ୍‍ପିଲେ ସାରେତିଙ୍ଗ୍ ଶକ୍ତିନଡ଼୍ ତିନ୍ଦେପାକ୍ କୁଦାଙ୍କ୍ ଆଦୁତନ୍, ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ସର୍ଗତାଗେ ମାବ୍‍ମୟଲ୍‍ତେ ତ ଡିଗି ୱାଦାନାଦ୍ ମିଡ଼୍ ଉଡ଼ିତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ଇଲା କେଞ୍ଜି ବେଡ଼୍‍ୟାଦ୍‍ ଯାଜକ୍ ନିଜେତ୍ ତାଦ୍‍ ଚକା ତିଙ୍କ୍ ହିକି ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍, “ଇଦ୍ ତ ଇଶ୍ୱରତାଦ୍‍ ନିନ୍ଦ୍ । ମେଣ୍ଡେ ୱେରେ ସାକ୍ଷି ଦର୍‍କାର୍ ଇଲେ । ଇଞ୍ଜେକେ ହିନାଦ୍‍ ଇଶ୍ୱର୍‌ତେ ନିନ୍ଦ୍ ତ ନିମ୍‍ କେଞ୍ଜ୍‍ତିନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଇ ବିଷୟ୍‍ତେ ମିୟାଦ୍ ମତ ବାତେଏ ?” ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ କାରାପ୍ ନାରୁନ୍, ଅଣ୍ଡ୍‌ ଡଲାନ୍ ମାଇଦିଙ୍କ୍ ଯଗ୍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଜିସୁନ୍ ମକତାଗ୍‍ ଉସି ଅଂକିଙ୍କ୍‌ ରେହ୍‍ତଡ଼୍‍ । ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଚାପୁଡ଼ା ରେହେସ୍ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ଏୟ୍‍ଇ କ୍ରିଷ୍ଟ ! ନିମ୍‍ ବାବବାଦି ବାବବାନି ସୁଦୁଟ୍ କେଲ୍‍ଲା । ବେନ ନିକିଂଙ୍କ୍ ରେହ୍‍ତଣ୍ଡ୍, କେଲ୍‍ମ୍ ତ !” ");
INSERT INTO kff_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ମୁକ୍ୟ ଜାଜକ୍ ବାୟ୍‍ଦେତ୍‍ ଦୁଆତାଗେ ପିତର୍ କୁଦିମାନ୍ଦାନ୍ ୱେଲେ ୱେରଣ୍ଡ୍ ଚାକର୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, ନିମ୍‍ ଆନ୍‌‍ତେ ଗାଲିଲୀୟ ଜିସୁନ୍ ତଡ଼୍ ମାତ୍‍ତିନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ବାତେଙ୍କ୍ ଇତ୍କେ ପିତର୍ ସାର୍‍ତଡ଼୍ ମୁନ୍‍ ଇଦ୍‌ଗଟ୍‍ ଅସ୍ୱୀକାର୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତେଏ କେତୁତିନ୍, ନାନ୍‍ନେ ବୁଜେମ୍ ଆୟନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଇଲା କେସ୍ ଅଣ୍ଡ୍‌ ଦୁୱାଡ଼୍‌‍ତେ ଆର୍‍ଦେ ଗାର୍‍ରେ ଆତ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ଦାସ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଆଗେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହିଣ୍ଡ୍ ନାଜରିତିୟ ଜିସୁନ୍ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ପିତର୍ ମେଣ୍ଡନ୍ ଦାମ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ରାଣୱାଟି କେତୁତାନ୍, ଇଲ୍‍ଲେ ଆଦ୍ ନାରୁଙ୍କ୍ ନାନ୍‍ନେ ପୁନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ସୁଦୁଟ୍ ପେର୍କେ ଆଗେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ପିତର୍‍ତେ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଡ଼୍ “ନିମ୍‍ ନିଜାମ୍ ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ୱେରେତନି । ନି ଗଟ୍ ତିର୍‍ୟାନାଗ୍ ଗଟ୍ ପୁନ୍ଦାଙ୍କ୍ ଆଦୁତ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ଆସୁଟେ ପିତର୍ କେତ୍‍ତଣ୍ଡ୍, “ରାଣ ଇସ୍‌ କେତୁତାନ୍, ନା ଗଟ୍ ସତ୍ । ସତ୍ ଆୟ୍‍ୟକଟ ମାତ୍‍କେ ଇଶ୍ୱର୍ ନାକିଂଙ୍କ୍ ଦଣ୍ଡ୍ ଇୱୀଣ୍ଡ୍ ।” ଆଦ୍ ନାରୁଙ୍କ୍ ନାନ୍‍ନେ ପୁନନ୍ । ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ କର୍କ୍ କୁସ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଜିସୁ ବାତେଏ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ପିତର୍‍ତିଙ୍କ୍ ହେର୍କା ୱାତ୍‍ତେ, “କର୍କ୍ କୁସାନ୍‍ ମୁନେଙ୍କ୍ ନାକିଂଙ୍କ୍ ପୁନନ୍ ଇଞ୍ଜ ନିମ୍‍ ମୁଣ୍ଡ୍‍ଦାମ୍ କେତିତିନ୍ ।” ଅଣ୍ଡ୍‌ ବାୟିଦେ ଆଞ୍ଜ୍ ବ୍ୟାକୁଲ ଆଶେ କେୟ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ତାନ୍ ମେଣ୍ଡନ୍ ଦିନ୍ ନାର୍‍କା ଜିସୁଙ୍କ୍ ରେହ୍‍ତାନ୍‍ ମାଇଦିଙ୍କ୍ ମୁକ୍ୟ ଯାଜକ୍ ନୁ ଦର୍ମନେତାଲଡ଼୍‍ ରାଜି ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଇକ୍‍ଲେତେ ତହସ୍ ରମିୟ ସାର୍‍ରେ ରାଜ୍ୟତେ ରାଜ୍ୟପାଳ ପିଲାତନ୍‍ ଗାର୍‍ରେ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ଶତ୍ରୁଡ଼୍ କାଇଦେ ହିଦାନ୍ ଯିହୁଦାଲ୍‍ କେଞ୍ଜ୍‍ତଣ୍ଡ୍ ଯେ, ଜିସୁଙ୍କ୍ ଦଣ୍ଡାଦେଶ ଆତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଅନୁତାପ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ ତିରିଶ୍‍ଟାନ୍‍ ରୁପାଡ଼ାବ୍‍କ୍ ମାଲ୍‍ପିସ୍‍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ୱେରନ୍ ନିର୍ଦଷ୍ ନାରୁନ୍ ନେତୁର୍‍ ସେଙ୍ଗେ ବିଶ୍ୱାସ୍ ଗାତକତା ମାଡ଼ି ନାନ୍‍ନେ ବେଡ଼୍‍ୟାଦ୍‍ ପାପ୍ ମାଡ଼୍‍ତାନ୍ । ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ମାୟାଦ୍‌ ଆଦିନାଗେ ବାତେଏ ମିନ୍ଦେ ? ଆଦ୍ ନିୟାଦ୍ ନିଜେତ୍ ଗଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ଯିହୁଦାଲ୍‍ ମୁଦ୍ରାକିଙ୍କ୍ ମନ୍ଦିର୍‍ତେ ଲୋପେ ହେସିସ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ତାନ୍ ପେର୍କେ ଆଞ୍ଜ୍ ଗୁଡ଼ୁଙ୍ଗାତାଗ୍ ନଡ଼ମ୍‍ ତହସ୍ ଗୁସ୍‍କ୍‍ ୱିଡ଼ି ଡଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ମୁକ୍ୟ ଯାଜକ୍ ମୁଦ୍ରାକିଙ୍କ୍ ପେହ୍‍କି କେତ୍‍ତନ୍‌, “ଇ ନେତୁର୍‍ତେ ମୁଲ୍ୟ । ହିୱ୍ ମନ୍ଦିର୍‌ତେ ବଣ୍ଡାର୍‌ତାଗେ ନେହ୍‍ତାନ୍‌ ନିୟମ୍‍ ବିରୁଦ୍‍ତେ ପାଡ଼୍‍ୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ଆଦ୍ ଦନ୍‍ତିଙ୍କ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ କର୍ସ ମାଡ଼ିତଡ଼୍, ହି ସମ୍ପର୍କତେ ୱେରଡ଼୍ ଆଲ୍‍ସି ମିକା ମାଡ଼ି “କୁମ୍ଭାର୍‍ତେ ୱାୟା,” ପେଦେର୍‍ତେ ସୁକୁକ୍ ୱାୟା ଆସ୍‍ତଡ଼୍‍ । ହିଦ୍ ବିଦେସିଡ଼୍‍ କବର୍ ହିଦାନ୍ ପଡ଼ିୟେ ଲେକାମ୍ ବ୍ୟବହୃତ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ନେଣ୍ଡ୍‍ଜାକ ଆଦ୍ ୱାୟାଙ୍କ୍ ନେତୁର୍‍ ୱାୟା ଇଞ୍ଜ କେତୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ହିଦ୍‍ଲେକାମ୍ ଜିରିମୀୟ ବାବବାଦୀ କେସ୍‍ମାନ୍ଦାନ୍ ବାବବାନି ସାରେ ଆତ୍‍ତେ, “ବାତେଏ ତିରିଶ୍‍ପାଇସାତେ ୱାମାନ୍ ସେଙ୍ଗେ ଇସ୍ରାୟେଲିୟ ପେକଡ଼୍ ସମତ ମାଡ଼ିମାତ୍‍ତଡ଼୍ ଆଦ୍ ଆତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ତିରିଶ୍‍ଟାନ୍‍ ମୁଦ୍ରାନେ ଅଡ଼୍‌ କୁମ୍ଭାର ୱାୟାଙ୍କ୍ ଆସ୍‍ତଡ଼୍‍ ହିଦ୍ ମାଡ଼ାନ୍ ଇଶ୍ୱର୍ ନାକିଂଙ୍କ୍ ଗଟ୍ ଇସ୍‌‍ମାତ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଜିସୁଙ୍କ୍ ମୁନ୍‍ ଉଡ଼ି ରମିୟ ରାଜ୍ୟପାଲ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତେଏ ଯିହୁଦିଡ଼୍ ରାଜାନି ?” ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତାନ୍, ହୋ ନିମ୍‍ ଆଦ୍ କେତୁତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେଡ଼ିୟ୍‍ ଯାଜକ୍ ନୁ ଦର୍ମନେତାଲଡ଼୍‍ ଅନ୍‌ ବିରୁଦ୍ଦ୍‌ତେ ତାସ୍‍ମାନ୍ଦାନ୍ ଅବିଯଗ୍, ଅଣ୍ଡ୍‌ ବାତେଏ କେଲଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ଆଦିଙ୍କ୍ ପିଲାତ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ନି ବିରୁଦ୍‍ତେ ଅଡ଼ାଦ୍‌ ଅବିଯଗ୍ ସାରେ ନିମ୍‍ ବାତେଏ କେଞ୍ଜ୍‍ୱିନି ? ");
INSERT INTO kff_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଉତ୍ତର୍‍ତେ ୱେରଡ଼୍ ବା ଗଟ୍ କେଲ୍‍ୱାଙ୍କ୍ ପିଲାତ ଗାଟି ବାକ୍‍ୱା ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ୱିଜା ପାଣ୍ଡୁମ୍ ୱେଲେ ନାରୁଡ଼୍ ଇଚ୍ଛା ଲେକାମ୍ ରମିୟ ଶାସନ୍‍କର୍ତାଲ୍ ଯେ ବେନ୍‌ଆଇ ଅର୍‍ତୁଙ୍କ୍ ବନ୍ଦି ନାରୁଙ୍କ୍ ମୁକ୍ତି ହିଦାନ୍ ନିତିମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ଆସୁଟେ “ବାରବ୍‍ବା,” ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ କାରାପ୍ ପାଡ଼ିୟିଦେ ବନ୍ଦି ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ଆଗେ ୱାସ୍‍ମନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପିଲାତ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, “ନାନ୍‍ନେ ବେନଙ୍କ୍ ମୁକ୍ତିଇତାନ୍ ଇଞ୍ଜ ମିୟାଦ୍ ଇଚ୍ଛା ? ବାରବ୍‍ବାତିଙ୍କ୍ ନା ଜିସୁଙ୍କ୍ ବେନଙ୍କ୍ କ୍ରିଷ୍ଟ ହିଞ୍ଜ କେତାନଙ୍କ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ପିଲାତ ସାୟ୍‍ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍ ଯେ ଯିହୁଦି ନେତାନଡ଼୍ କର୍ତ୍ତୁପକ୍ଷଡ଼ିଡ଼୍ ଇର୍ଷାତେ ସମର୍‍ପନ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ପିଲାତ ବିଚାର୍‍ପଡ଼ିୟେତାଗେ କୁଦିମାନ୍ଦାନ୍ ୱେୟ୍ ଅନ୍‌ ମୁତ୍‍ତେ ୱେରଡ଼୍ ଗଟ୍ ରହ୍‍ତେ ଆ ଦାର୍ମିକ୍ ନାରୁଙ୍କ୍ ବାତେଏ ମାଡ଼୍‍ମାଟ୍ । ନିନେତ୍‍ ନାର୍‍କେତ୍ ୱେରଡ଼୍ ସାପ୍‍ନେତେ ଅନ୍‌ ମାଇଦିଙ୍କ୍ ନାନ୍‍ନେ ନାର୍‍ଗେ ଦୁଃକାମ୍ ମାଡ଼୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ବେଡ଼୍‍ୟାଦ୍‍ ଯାଜକ୍ ନୁ ଦର୍ମନେତାଲଡ଼୍‍ ବାର୍‍ବ୍‍ବାଙ୍କ୍ ପେସ୍‍ପି, ଜିସୁଙ୍କ୍ ଡଲାନ୍ ଦଣ୍ଡ୍ ଇଦାନ୍ ମାଇଦିଙ୍କ୍ ପିଲାତଙ୍କ୍‍ ଦାବୀ ମାଡ଼ାନଙ୍କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅସ୍ପିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ପିଲାତ ମେଣ୍ଡେ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, “ଇ ଇର୍‍ୱୁଡ଼୍ ଲପ୍ ନାନ୍‍ନେ ବେନଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ିଦ୍‍ତାନ୍‍ ଇଞ୍ଜ ମିୟାଦ୍ ଇଚ୍ଛା ?” ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ବାରବ୍‍ବାଙ୍କ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, ଆଲାଇତ୍‍କେ କ୍ରିଷ୍ଟ ଇଞ୍ଜ ପୁଞ୍ଜ୍‍ମାନ୍ଦାନଙ୍କ୍ ବାତେଏ ମାଡ଼ିତାନ୍ ? “ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗେ ତାର୍‍ସ୍ପାଟ୍‍” ଇଞ୍ଜ ଅଡ଼୍‌ ସାରେତଡ଼୍ ମର୍‍ପୟ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ପିଲାତ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, “ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବାତେଏ ବୁଲ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ ?” ଅଡ଼୍‌ ମେଣ୍ଡେ ମର୍‍ପୟ୍‍ସ୍‍ କେତ୍‍ତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗେ ତାର୍‍ସ୍ପାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ବେସୁଙ୍କ୍‍ ପିଲାତ ଉଡ଼୍‍ତଣ୍ଡ୍ ଯେ, ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେସ୍‍ମେଣ୍ଡେ ବାତ୍‍ଲାବ୍‍ ଇଲେ, ବେଲାନ୍ ଶାନ୍ତି ବଙ୍ଗର୍‍ ଆଶଙ୍କା ମିନ୍ଦେ, ଅଣ୍ଡ୍‌ ସୁଦୁର୍ ଏର୍‍ ଆସ୍, ନାରୁଡ଼୍ ମୁନେ କାୟ୍ ନର୍‍ତଣ୍ଡ୍, “ହି ନାରୁନ୍ ଡଲାନ୍ ସେଙ୍ଗେ ନାନ୍‍ନେ ଦାୟି ଆୟନ୍‍ । ହିଦ୍ ମିୟାଦ୍ ପାଡ଼୍‍ୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ନାରୁଡ଼୍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ଅନାଦ୍‌ ଡଲାନ୍ ଦଷ୍, ମାକିଂଙ୍କ୍ ବା ମା ପିଲାନ୍ ପର୍‍ର ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ଶେଷତେ ପିଲାତ ବାରବ୍‍ବାଙ୍କ୍ ପେସ୍ପିସ୍‍ ଜିସୁଙ୍କ୍ କରଡାତେ ରେହ୍‍ତାଙ୍କ୍ ଆଦେଶ୍ ହିତ୍‍ତଣ୍ଡ୍, ତାନ୍, ପେର୍କେ କ୍ରୁଶତାଗ୍ ତାର୍‍ପାନ୍ ମାଇଦିଙ୍କ୍ ସନ୍ୟଡ଼୍ କାଇଦେ ୱିଡ଼୍‍ସିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ପିଲାତନ୍ ସୈନ୍ୟହିଡ଼୍‍ ଜିସୁଙ୍କ୍ ରମିୟ ଶାସକ୍‍ତିଙ୍କ୍ ପ୍ରାସାଦତାଗ୍‍ ଆତ୍‍ତଡ଼୍ ନୁ ସାରେତଡ଼୍ ସୈନ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ ତିଡ଼୍‍ୟି ଆସ୍ ନିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ଅନାଦ୍‌ ଚକା କୁସ୍‍ପି ଆସ୍ ଅଂକିଙ୍କ୍‌ ଅଣ୍ଡୟ୍‌ ଆପେ ରଙ୍ଗ୍‍ଦେ ଚକେ କେର୍‍ସ୍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","କୟେ ମାଡ଼୍‍ତେ ସୁଦୁଟ୍‍ତେ ୱେରଡ଼୍ ସହଜ୍‌ ତିଆର୍ ମାଡ଼ି ଅନ୍‌ ତାଲେତ୍ ପର୍‍ର କେର୍‍ସ୍ପିତ୍‍ ତଡ଼୍ ନୁ ଅନ୍‌ ତିନ୍ଦେକାୟିଦା ୱେରଡ଼୍ ଡୁଡ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ମୁନେ ବଟ୍‍ମିଣ୍ଡା ହୁହ୍‍ସି ଅଂକିଙ୍କ୍‌ ପରିଆସ ମାଡ଼ି କେତ୍‍ତଡ଼୍, ଯିହୁଦିଡ଼୍ ରାଜା ଚିରଜିବି ଆୟ୍‍ମ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ଅଡ଼୍‌ ଅନ୍‌‍ପରୁ ଉସ୍‍ତଡ଼୍‍, ଆଦ୍ ଡୁଡ୍‍ ତଡ଼୍ ଅନ୍‌ ତାଲ୍‍ତାଗ୍‍ ରେହ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ହିଦ୍‍ପୁଟୁଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ପରିହାସ୍‌ ମାଡ଼୍‍ତେ ପେର୍କେ ରାଜକିୟ ଚକା ପେସ୍‍ପି ଅନାଦ୍‌ ନିଜେତ୍ ଚକା କେର୍‍ସ୍ପି ତଡ଼୍ ନୁ କ୍ରୁଶତାଗେ ତାର୍‍ସ୍ପାନ୍‍ ମାଇଦିଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଆଗାଙ୍କ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ଅଡ଼୍‌ ଆଦ୍‍ଦାନ୍ ୱେଲେ ଆର୍‍ଦାଗ୍ କୁରୁନିୟ ସହର୍‍ତେ ଶିମୋନ୍ ପେଦେର୍‍ତେ ୱେରନ୍ ନାରୁଙ୍କ୍ କାୟ୍‍ଲ୍‍ତଡ଼୍ ନୁ ସୈନକିଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଜିସୁନ୍ କ୍ରୁଶ କାଞ୍ଜାନ୍ ମାଇଦିଙ୍କ୍ ବାଦ୍ୟ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ଅଡ଼୍‌ ଗଲ୍‍ଗତା ପେଦେର୍‍ତେ ୱେରଡ଼୍ ପଡ଼ିୟେତାଗ୍ ହେୱୁଦ୍‍ତଡ଼୍ । ଗଲ୍‍ଗତାତେ ଇତ୍‍କେ କପୁରି ଲେକେତାଦ୍ ପଡ଼ିୟେ । ");
INSERT INTO kff_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ଆଗେ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ କାଇତାଦ୍ କାୟ୍‍ଲି ମାନ୍ଦାନ୍ ଦ୍ରାକ୍ଷାରସ୍ ଉନ୍ଦାଙ୍କ୍ ହିତ୍‍ତଡ଼୍ । ଜିସୁ ଆଦିଙ୍କ୍ ସୁଦୁର୍ ନାକି ମେଣ୍ଡେ ଉନଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ କ୍ରୁଶତାଗେ ତାର୍‍ସ୍ପି ଗୁଲିବାଣ୍ଟ ତଡ଼୍ ଅନ୍‌ ଚକାତିଙ୍କ୍ ନିଜେତ୍ ଲୋପେ ତୁସି ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଆଗେ କୁଦି କ୍ରୁଶତାଗେ ତାର୍‍ସ୍ପ୍‍ତେ ଜିସୁଙ୍କ୍ କେପି ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ଅନ୍‌ ବିରୁଦ୍ଦ୍‌ତେ ଆସ୍‍ମାନ୍ଦାନ୍ ଅବିଯଗତେ ୱେରଡ଼୍ ଲେକିମାନ୍ଦାନ୍‍ ବାଲା ଅନ୍‌ ତାଲେତ୍ ପର୍‍ର କ୍ରୁଶତାଗ୍ ୱେଇସ୍‍ ମାତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ଆଦୁତନ୍ ଜିସୁ ଯିହୁଦିନାରୁଡ଼୍‍ ରାଜାଲ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍ ଡଙ୍ଗାଲଡ଼୍‍କିଙ୍କ୍ ଆଗେ କ୍ରୁଶତାଗେ ତାର୍‍ସ୍ପ୍‍ତଡ଼୍‍, ଅର୍‍ତୁଙ୍କ୍ ଜିସୁନ୍ ତିନ୍ଦେକାୟିଦେ ପାକେ ନୁ ମେଣ୍ଡେ ଅର୍‍ତୁଙ୍କ୍ ଡେବ୍‍କାୟ୍‍ଦେ ପାକ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଆଦ୍ ଆର୍ ଆଦ୍‍ଦାନ୍ ନାରୁଡ଼୍ ତାଲ୍‍ତିଙ୍କ୍ ଉଷ୍‍ ଜିସୁଙ୍କ୍ ଅପ୍‍ମାନ୍ ଇସ୍‌ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ନିମ୍‍ ବାନେ ମନ୍ଦିର୍‍ତିଙ୍କ୍ ଉସ୍ ମୁଣ୍ଡ୍‍ଦିନାନେ ମେଣ୍ଡେ ଆଦିଙ୍କ୍ ତିଆର୍ ମାଡ଼ିସ୍‍ ମାତ୍‍ତିନ୍‍ । ନିମ୍‍ ଯଦି ଇଶ୍ୱର୍‌ତେ ମାର୍‍, ନିଜ୍‍ତିଙ୍କ୍ ଗେଲ୍‍ସ୍ପା । କ୍ରୁଶତାଗାଙ୍କ୍ ଡିଗିୱାଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ବେଡ଼ିଇଯାଜକ, ଦର୍ମଗୁରୁ ନୁ ସଂପ୍ରଦାୟତେ ମୁୟୁତେ ନେତାଲଡ଼୍ ଆନ୍‌‍ତେ ଜିସୁଙ୍କ୍ ପରିଆସ ମାଡ଼ି କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ଅଣ୍ଡ୍‌ ବାଗାତଡ଼୍‍କ୍ ଗେଲ୍‍ସ୍ପ ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିଜ୍‍ତିଙ୍କ୍ ଗେଲ୍‍ସ୍ପ ପାର୍‍ୱଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ବାନେ ଇସ୍ରାୟେଲ୍‍ତେ ରାଜାଲ୍ । ଇଞ୍ଜ୍ ଯଦି ଅଣ୍ଡ୍‌ କ୍ରୁଶତାଗାଙ୍କ୍ ଡିଗି ୱାଦ୍ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍, ଆଲାଇତ୍‍କେ ମାମ୍ ଅଂକିଙ୍କ୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼ିତମ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ଅଣ୍ଡ୍‌ ନିଜ୍‍ତିଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ଇଞ୍ଜ କେସ୍ ଇଶ୍ୱର୍‌ତେ ପର୍‍ର ଆସ୍ ନେହେସ୍ ମିନ୍ଦେଣ୍ଡ୍ । ହାଲେକ୍ ଉଡାଙ୍କ୍ ଆଦ୍‍ତେ, ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଗେଲ୍‍ସ୍ପାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍ କି ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଅନ୍‌ ତଡ଼୍ କ୍ରୁଶତାଗ୍ ମାନ୍ଦାନଣ୍ଡ୍ ଡଙ୍ଗାଲ୍ ଆନ୍ତେ ଅଂକିଙ୍କ୍‌ ଆଦେ ରକମ୍ ପରିହାସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ଆଦ୍‍ଦିନେ ପାୟାଲ୍ ତାଲେତ୍ ପଡ଼୍‍ଦିନ୍‍ ସାରେ ଦେଶ୍‍ଜାକ ହିକାଡ଼୍ ଆତ୍‍ତେ ନୁ ମୁଣ୍ଡ୍ ଗାଣ୍ଟା ଯାକ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ପାୟାଲ୍‌ ଅଲ ତିନ୍‍ଟାୱେଲେ ଜିସୁ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଣ୍ଡ୍, ଏଲି, ଏଲି, ଲାମା ସବକ୍‍ତାନି । ଇତ୍‍କେ “ହୋ ଇଶ୍ୱର୍‌ତନି, ହୋ ଇଶ୍ୱର୍‌ତନି, ନାକିଂଙ୍କ୍ ବାତେଙ୍କ୍ ୱିଡ଼୍‍ସ୍‍ତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଗାର୍‍ରେ ନିସ୍ ମାନ୍ଦାନ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଇଦ୍ କେଞ୍ଜି କେତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ଏଲିୟଙ୍କ୍ କାର୍‍ଙ୍ଗୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ମିରି ଆଞ୍ଜ୍ କାଇତାଦ୍ ଦ୍ରକ୍ଷାରସ୍‍ତେ ୱେରଡ଼୍ ପସ୍କେ ମୁହ୍‍ସ୍‍ ଅଂକିଙ୍କ୍‌ କାରେତ୍ ମୁନ୍‍ ତହସ୍ ଉନ୍ଦାନଙ୍କ୍ ଜିସୁନ୍ ପାକେ ଆସିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ବାଗାତଡ଼୍ କେତ୍‍ତଡ଼୍, କେପାଟ୍, ଉଡାଙ୍କ୍ ଆଦ୍‍ତେ, ଅଂକିଙ୍କ୍‌ ଗେଲ୍‍ସ୍ପାଙ୍କ୍ ଏଲିୟ ୱାଦ୍‍ତଣ୍ଡ୍ କି ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ଜିସୁ ମେଣ୍ଡନ୍ ଦାମ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେସ୍ ଶେଷ ନିଶ୍ୱାସ୍‍ ୱିଡ଼୍‍ସ୍‍ତଣ୍ଡ୍ ବା ନିଜେତ୍ ଜିୱୁନ୍ ୱିଡ଼୍‍ସିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ଆଦ୍ ସମୟ୍‍ତେ ମନ୍ଦିର୍‍ତାଗ୍ ଉଙ୍ଗମାନ୍ଦାନ୍‍ ପର୍ଦା ପର୍‍ରକଞ୍ଚ୍ ମଦଲ୍ ହେଉନା ରେଣ୍ଡ୍ ଗାନା ଆସ୍‌ ହିଙ୍ଗ୍‍ତେ । ବୂମିକମ୍ପ ଆତ୍‍ତେ, ମେଟେଆନ୍‌‍ତେ ପକ୍‍ତ୍‍ତା ");
INSERT INTO kff_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ନୁ କବର୍ କୁଲାଆସ୍‍ ନାର୍‍ଗେ ଇଶ୍ୱର୍ ଆଶେ ଡଲିମନ୍ଦାନ୍ ନାରୁଡ଼୍ ମେଣ୍ଡେ ଜିୱୁନ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ହିଡ଼୍ କବର୍ ତାଗାଙ୍କ୍ ତେଦି ୱାତ୍‍ତଡ଼୍ ନୁ ଜିସୁନ୍ ପୁନରୁତ୍‍ତାନ୍ ପେର୍କେ ହିଡ଼୍‍କିଙ୍କ୍ ପବିତ୍ର ନାର୍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଆଦାନାଦ୍ ବେସ୍‌କ୍ ତଡ଼୍ ଉଡ଼୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ଜିସୁଙ୍କ୍ କେପି ମାନ୍ଦାନ୍ ସେନାପତି ନୁ ସୈନ୍ୟହିଡ଼୍‍ ବୁମିକମ୍ପ ନୁ ବାଗାତାଉ ଗଟ୍‍ନା ଉଡ଼ି ୱେର୍‍ସ୍‍ ଆଦ୍‍ତଡ଼୍ । ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ନିଜାମ୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଗାଲିଲୀ ତାଗାଙ୍କ୍ ଜିସୁଙ୍କ୍ ଲେକେତ୍‌ ମାଡ଼ି ଅଂକିଙ୍କ୍‌ ସାହାଯ୍ୟ ମାଡ଼ିମାନ୍ଦାନ୍ ବେସ୍‌କ୍ ମୁତ୍‍ତେ ଦୁରାମ୍ ମାଞ୍ଜ୍ ସାରେ ଉଡ଼ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ହାୱିନ୍‍ ଲୋପେ ମାତ୍‍ତେ ମଗ୍‍ଦଲୀନି ମରୀୟମ୍, ଯାକୁବ୍ ନୁ ଯସେପ୍‍ତେ ୟାୟ୍‍ ମରୀୟମ୍ ନୁ ଜେବଦିନ୍ ମୁତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ମୁଲ୍‍ପୁଟ୍ ଆରମାତିଆତେ ସହର୍ ଯସେପ୍‍ ପେଦେର୍‍ତେ ୱେରଣ୍ଡ୍ ସାଉକାର୍ ନାରୁଡ଼୍ ୱାସ୍ ହେୱ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଜିସୁନ୍ ୱେରଣ୍ଡ୍ ଶିଷ୍ୟ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ଅଣ୍ଡ୍‌ ପିଲାତଙ୍କ୍ କାୟ୍‍ଲି ଜିସୁନ୍ ଡଲ୍‍ତେ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଗଟ୍ ତାଲ୍‍କ୍‍ତଣ୍ଡ୍ ପିଲାତ ଗଟ୍ ହିତ୍‍ତାଙ୍କ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ଯସେପ୍‍ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଅସ୍‍ମେଣ୍ଡେ ୱେରଡ଼୍ ପାଲ୍‍ସାଲାଦ୍ ସିଲେ ଇତ୍‌ତଣ୍ଡ୍‌ ନୁ ");
INSERT INTO kff_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ଅନ୍‌ ନିଜେତ୍ ମାଇଦିଙ୍କ୍ କାଲ୍‍ଦାଗ୍ ଡେୱିମାନ୍ଦାନ୍‍ ୱେରଡ଼୍ ପୁନାଦ୍ ସମାଦିତାଗେ ଅଂକିଙ୍କ୍‌ ୱାଟ୍‍ତଡ଼୍‍ ନୁ ସମାଦିତେ ମୁନେ ୱେରଡ଼୍ ବେଡ଼୍‍ୟାଦ୍‍ କାଲ୍ କୁହୁସି ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‍ଦଲୀନି ମରୀୟମ୍ ନୁ ମେଣ୍ଡନ୍ ମରୀୟମ୍ ଆଦ୍ ସମାଦିତା ମୁନ୍‍ମାଡ଼ି କୁଦିମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ତାନ୍ ମେଣ୍ଡନ୍‍ଦିନେ ବିଶ୍ରାମଦିନେତେ ବେଡ଼ିଇଯାଜକ ନୁ ପାରୂଶୀଡ଼୍ ପିଲାତ୍‍ତଙ୍କ୍ କାୟ୍‍ଲି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ଗଟ୍, ମାକ୍‍ ହେର୍କା ମିନ୍ଦେ, ଅଣ୍ଡ୍‌ ମିତ୍ୟାବାଦି ଗେଲ୍‍ସି ମାନ୍ଦାନ୍‍ୱେୟ୍‍ କେସମାତ୍‍ତନ୍, ମୁଣ୍ଡ୍‍ଦିନାନ୍ ପେର୍କେ ନାନ୍‍ନେ ପୁନରୁତ୍‍ତାନ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ଆଦିଙ୍କ୍ ମୁଣ୍ଡ୍‍ଦିନା ଯାକ ଆଦ୍ ସମାଦିତିଙ୍କ୍ କେପି ମାନ୍ଦାଙ୍କ୍ ସୈନ୍ୟଡ଼୍‍କ୍ ଆତ୍‍ତାଙ୍କ୍ ନିମ୍‍ ଗଟ୍ ହିମ୍, ଆଲାଇତ୍‍କେ ଅନ୍‌ ଶିଷ୍ୟଡ଼୍ ଅନ୍‌ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଡଙ୍ଗି ଆସ୍, ଅଣ୍ଡ୍‌ ଗେଲ୍‍ସି ତେଦ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ କେତ୍‍ ପାର୍‍ୱଡ଼୍ । ଅଡ଼ାଦ୍‌ ହି ମିଚ୍ ପ୍ରଚାର୍ ସାର୍‍ରେ ଅଦିକ୍‌ ଅନିଷ୍ଟ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଅଣ୍ଡ୍‌‍ମାନ୍ଦେ କେପାନଡ଼୍‍କ୍ ଆୟ୍‍ମୁଟ୍ ଆଦ୍ ସମାଦିତିଙ୍କ୍ ଲେକେତ୍‍ କେପିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ଅଡ଼୍‌ ଆଞ୍ଜ୍ ସମାଦିତିଙ୍କ୍ କେପାନ୍ ମାଇଦିଙ୍କ୍ ଲେକେତ୍‍ ତିଆର୍‍ମାଡ଼୍‍ତଡ଼୍ । ଅନ୍‌ ମାଇଦିଙ୍କ୍ ମୁସିମାନ୍ଦାନ୍‍ କାଲ୍‍ଦେ ପର୍‍ର କୁଦି ଅଂକିଙ୍କ୍‌ କେପାନ୍ ମାଇଦିଙ୍କ୍ ନୁ ସୈନ୍ୟଡ଼୍‍କ୍ ଆଗେ ମାନ୍ଦାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ବିଶ୍ରାମ୍‍ଦିନେ ମେଣ୍ଡ୍‍ନ୍ଆତ୍‍ତେ ଦିନ୍ ରବିବାର୍‍ ଦିନ୍ ନାର୍‍କେତ୍ ମଗ୍‍ଦଲୀନି ମରୀୟମ୍ ନୁ ମେଣ୍ଡନ୍ ମରୀୟମ୍ ସମାଦି ଉଡାଙ୍କ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ଆସୁଟେ ହଟାତ୍ ୱେରଡ଼୍ ବୁମିକମ୍ପ ଆତ୍‍ତେ । ପ୍ରବୁନ୍ ୱେରଡ଼୍ ଦୂତ ପର୍‍ରକଞ୍ଚ୍ ଡିଗି ୱାସ୍, ସମାଦି ୱାଟିମାନ୍ଦାନ୍ କାଲ୍‍ଦିଙ୍କ୍ ଗୁସ୍‍ପି ଆଦ୍ କାଲ୍‍ଦେ ପର୍‍ର କୁଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ତାନାଦ୍ ମକମ୍ ପିଡ଼୍‍ଗ୍‍ହିନା ୱେସ୍‍ମାତ୍‍ତେ ନୁ ତାନାଦ୍ ଚକା ଇମ୍ ଲେକାମ୍ ପାଣ୍ଡେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ସୈନ୍ୟଡ଼୍ ୱେର୍‍ସ୍‍ ୱାଡ଼୍‍କ୍‍ତଡ଼୍‍ ନୁ ଡଲ୍‍ତେ ଲେକାମ୍ ଆସ୍‌ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ଦୂତ ଆଦ୍ ନାଟାଙ୍କ୍ କେତ୍‍ତେ, “ୱେର୍‍ମାଟ୍ ।” ନାନ୍ ୱେରନ୍, ମିଡ଼୍ କ୍ରୁଶତାଗ୍ ତାର୍ପିମ୍‍ନ୍ଦାନ୍ ଜିସୁଙ୍କ୍ ଉଡାଙ୍କ୍ ୱାତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ଅଣ୍ଡ୍‌ ହିଗେ ଇଲେଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ କେତ୍‍ତେ ଲେକାମ୍ ଅଣ୍ଡ୍‌ ପୁନରୁତ୍‍ତାନ୍ ଆଶେ ମିନ୍ଦେଣ୍ଡ୍ । ହିଗ୍ ୱାସ୍ ଉଡ଼ାଟ୍, ହିଗେ ଅଂକିଙ୍କ୍‌ ୱାଟିସ୍‍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ଶିଟ୍‍ପାଟ୍‍ ଆଞ୍ଜ୍ ନା ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେଲ୍‍ମୁଟ୍, “ଅଣ୍ଡ୍‌ ମେଣ୍ଡନ୍ ଦାମ୍ ଜିୱୁନ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ମିଇ ମୁନେ ମୁନେ ଅଣ୍ଡ୍‌ ଗାଲିଲୀତା ଆଦୁତନ୍ । ଆଗେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ିତିଡ଼୍ । ନାନ୍‍ନେ ବାତ୍ କେତ୍‍ତାନ୍, ହେର୍କା ନେହେମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ଇଦ୍ କେଞ୍ଜି ଆୱ୍ ସିଟ୍‍ପାଟ୍ କବର୍ ୱିଡ଼୍‍ସି ଶିଷ୍ୟଡ଼୍ ଗାର୍‍ରେ ମିର୍‍ତା । ୱେର୍‍ସ୍‍ ମାତ୍‍କେ ବା ଆୱିନ୍ ମନ୍‍ଦାଗ୍ ଗାଟି ସାର୍‍ଦେ ନୁ ୱେଡ଼୍‍କେତେ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଜିସୁ ଆୱିଙ୍କ୍ କାୟ୍‍ଲି କେତ୍‍ତଣ୍ଡ୍ “ମିୟାଦ୍ ଶାନ୍ତି ଆୟି !” ଆୱ୍ ଅନ୍‌‍ଗାରେ ଆଞ୍ଜ୍ ଅନ୍‌ ଡେକାଙ୍କ୍ ପୟ୍‍ସ୍ ମଡ଼୍‍କ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଜିସୁ ଆୱିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ୱେର୍‍ମାଟ୍ ନା, ଦାଦାଲଡ଼୍‍କିଙ୍କ୍ କେଲ୍‍ମୁଟ୍, ଅଡ଼୍‌ ଗାଲିଲୀତାଗ୍ ଆଦ୍‍ତଡ଼୍ । ଆଗେ ଅଡ଼୍‌ ୱାସ୍ ନାକିଂଙ୍କ୍ ଉଡ଼ିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ନାଟାଙ୍କ୍ ଆଗାଙ୍କ୍ ଆଦାନ୍‍ ୱେଲେ ସମାଦିତିଙ୍କ୍ କେପିମାତ୍‍ତେ ସୈନିକିଡ଼୍ ସହର୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆଞ୍ଜ୍ ବେଡ଼୍‍ୟାଦ୍‍ ଯାଜକ୍‍ନଡ଼୍ ହି ସାରେ ଗଟ୍‍ନା କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ମୁକ୍ୟ ବେଡ଼ିୟ୍ ଯାଜକ୍‍ନଡ଼୍ ଦର୍ମନେତାଲଡ଼୍‍ ତ ମନ୍ତ୍ରନା ମାଡ଼ି, ଆଦ୍ ସୈନ୍ୟକିଡ଼୍‍କ୍‍ ନାର୍‍ଗେ ଡାବ୍‍ଲାଞ୍ଚ୍‍ ଇସ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ");
INSERT INTO kff_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","କେତ୍‍ତଡ଼୍, “ମିଡ଼୍ କେଲ୍‍ମୁଟ୍ ଯେ ନାର୍‍କେତ୍ ମାମ୍ ହୁଞ୍ଜିମାତ୍‍ ୱେୟ୍ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ୱାସ୍ ଅନ୍‌ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଡଙ୍ଗିମେଣ୍ଡେ ଆତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଯଦି ଶାସକ ହି ଗଟ୍ କେଞ୍ଜ୍‍କେ ମାମ୍ ଅଂକିଙ୍କ୍‌ ବୁଜାମାଡ଼ିଦ୍‍ ତମ୍‍ ଯେ ମିଡ଼୍ ଦଷି । ହି ବିଷୟ୍‍ତେ ମିଡ଼୍ ଦାନ୍ଦେ ଆୟ୍‍ମାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ସୈନିନଡ଼୍ ଡାବ୍ ଆସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେସ୍ ମାନ୍ଦାନ୍ ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଆସୁଙ୍କ୍ ବାତ୍ କେତ୍‍ତଡ଼୍, ଯିହୁଦିଡ଼୍ ନେଣ୍ଡ୍ ଯାକ ଆଦ୍ ଗଟ୍ ପ୍ରଚାର୍ ମାଡ଼ୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଜିସୁ କେସ୍‍ମାତ୍‍ତେ ଲେକାମ୍ ତାନ୍ ଏଗାର୍‍ଜାନ୍ ଶିଷ୍ୟଡ଼୍ ଗାଲିଲୀତେ ୱେରଡ଼୍ ମେଟେତ୍‍ ପର୍‍ର ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଆଗେ ଜିସୁଙ୍କ୍ ଉଡ଼ି ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ମଡ଼୍‍କ୍‍ତଡ଼୍ ନୁ ବେନଡ଼୍‍ ଡାଉଟ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଜିସୁ ଅଡ଼୍‌ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, “ସ୍ୱର୍ଗ ନୁ ପୃତିବି ସାରେ ଅଦିକାର୍‌ ନାକିଂଙ୍କ୍ ଇସ୍‌‍ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ମେଣ୍ଡେ ମିଡ଼୍‍ଆଞ୍ଜ୍ ସାରେ ଜାତିତ୍‍ ନାରୁଡ଼୍ ଆଞ୍ଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନା ଶିଷ୍ୟ ମାଡ଼ାଟ୍ । ବାବାଲ୍, ମାର୍‍ ନୁ ପବିତ୍ର ଆତ୍ମା ପେଦେର୍‍ତେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାପ୍ତିସ୍ମ ହିମୁଟ୍ ");
INSERT INTO kff_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ମେଣ୍ଡେ ନାନ୍‍ନେ ବେନ୍‍ସାରେ ଶିକ୍ଷା ଇସ୍‌‍ମିନ୍ଦେନ୍, ଆଦ୍ ପାଲନ୍ ମାଡ଼ାଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶିକ୍ଷା ହିମୁଟ୍ । ମେଣ୍ଡେ ହେର୍କା ନେହେମୁଟ୍, ତେରାନ୍‌ ଯାକ ନାନ୍ ସାରେ ଦିନା ମିଇ ତଡ଼୍ ମାନ୍‍ତାନ୍ ।”");
INSERT INTO kff_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ଜିସୁ କ୍ରିଷ୍ଟନ୍ ସୁସମାଚାର୍ ଇଦ୍‍ଲେକାମ୍ ଆରାମ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ଯିଶାଇୟ ବାବବାଦୀ ଶାସ୍ତ୍ରତାଗ୍ ବେଦ୍‍ଲେକାମ୍ ଲେକାମିନ୍ଦେ, ଉଡ଼େ, ମାମ୍‍ମେ ମା ଦୂତକିଙ୍କ୍ ମିଇ ମୁନେ ରହସ୍ ମିନ୍ଦେମ୍, ଅଣ୍ଡ୍‌ ମିୟାଦ୍ ଆର୍ ତିଆର୍‍ ମାଡ଼ିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“ଉଚ୍‍କ ନେଏଲ୍‍ଦାଗ୍ ଯିଶାଇ ବେନ ଗାଟି ଲେଙ୍କ୍‍ଦେ କେସମିନ୍ଦେନ୍, ପ୍ରବୁନ୍ ସେଙ୍ଗେ ଆର୍ ତିଆର୍ ମାଡ଼ାଟ୍; ଅନାଦ୍‌ ୱାଦାନ୍ ସେଙ୍ଗେ ଆର୍ ତିଆର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ଆଦ୍ ଲେକାମ୍ ବାପ୍ତିଜକ ଯୋହନ୍‌ ଉସ୍କ ନେଲ୍‍ଦା ୱାସ୍ ପ୍ରଚାର୍ ମାଡ଼ାତନ୍ ନୁ ବାପ୍ତିସ୍ମ ଇଦାନଙ୍କ୍ ପସ୍‍ପତନ୍ । ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେସ୍‍ମାତ୍‍ତନ୍ “ନିଜେ ନିଜେତ୍ ପାପ୍ ସେଙ୍ଗେ ୱିଡ଼୍‍ସାଟ୍ ନୁ ବାପ୍ତିସ୍ମ ଗ୍ରହନ୍ ମାଡ଼ାଟ୍ । ଆଲାଇତ୍‍କେ ଇଶ୍ୱର୍ ମିୟାଦ୍ ପାପ୍ କ୍ଷମା ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ଯିହୁଦା ପ୍ରଦେଶ୍‍ ନୁ ଯିରୁଶାଲେମ୍ ସହର୍‍ତାଗାଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଯୋହନ୍‌‌ତେ ପ୍ରଚାର୍ କେଞ୍ଜାନ୍ ସେଙ୍ଗେ ୱାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ନିଜେ ନିଜେ ପାପ୍ ସ୍ୱୀକାର୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ଯୋହନ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଯର୍ଦ୍ଦନ୍ ବେଡ଼େମ୍‍ତାଗ୍ ବାପ୍ତିସ୍ମ ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଯୋହନ୍‌‌ତାଦ୍‍ ଚକା ଉଟ୍‍ କେଲ୍‍କିନ୍ ତିଆର୍‍ ଆସ୍‍ମାତ୍‍ତେ ନୁ ଅନ୍‌ ଟିକିଡ଼୍‍ତାଗ୍ ତଲ୍‌କେ ତହସ୍ ମାତ୍‍ତନ୍ । କାରାପ୍ ମାଡ଼େତ୍ କାୟା ନୁ ଗୁପ୍‍ତାଦ୍ ତେନେ ଅନାଦ୍ କାଦି ମାତ୍‍ତେ, ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍ ପାକେ କେସ୍‍ ମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","“ବେନ୍ ନାରୁଡ଼୍ ନା ପେର୍କେ ୱାଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ନାୟାଗାଙ୍କ୍ ମହାନ୍ । ନାନେ ଆଦ୍‍ଲେକାମ୍ ଅନ୍‌ ଡେକାନ୍ ବନ୍ଦନ୍ କୁସ୍‍ପାନଙ୍କ୍ ମିକା ନାନ୍‍ନେ ଅଯୋଗ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ନାନେ ମିକିଂଙ୍କ୍ ଏର୍‍ଦାଗ୍ ବାପ୍ତିସ୍ମ ଇଦୁତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ପବିତ୍ର ଆତ୍ମାତେ ବାପ୍ତିସ୍ମ ଇଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ଆଦ୍ ସମୟ୍‍ତେ ଜିସୁ ଗାଲିଲୀ ପ୍ରଦେଶ୍‍ତେ ନାଜରିତିୟ ତାଗାଙ୍କ୍ ୱାସ୍ ଯୋହନ୍‌ ତଡ଼୍ ଯର୍ଦ୍ଦନ୍ ବେଡ଼େମ୍‍ତାଗ୍ ବାପ୍ତିସ୍ମ ଅତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଜିସୁ ଏର୍‍ଦାଗାଙ୍କ୍ ତେଦି ୱାଦାନ୍ ୱେଲେ ଉଡ଼୍‍ତନ୍, ସ୍ୱର୍ଗ କୁଲାଆସ୍‍ ନୁ ପରମାଆତ୍ମା ପାର୍ୱା ରକମ୍ ଅନ୍‌ ପରୁ ଡ଼ିଗ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ମେଣ୍ଡେ ସ୍ୱର୍ଗତାଗାଙ୍କ୍‍ ଇଦ୍ ଗଟ୍‍ ୱାତ୍‍ତେ, “ନିମେ ମା ପ୍ରିୟ ମାର୍‍, ନିୟାଗେ ନାନେ ଗାଟି ସନ୍ତୁଷ୍ଟ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ଆସୁଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ଅଂକିଙ୍କ୍‌ ସିମ୍‍ସାମ୍ ପଡ଼ିୟେତାଗ୍ ଅତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଆଗେ ଅଣ୍ଡ୍‌ ଚାଳିଶ୍‍ ଦିନ୍ ମାତ୍‍ତନ୍ । ଆଦ୍ ସମୟ୍‍ତେ ଶୟ୍‍ତାନ୍‍ ବେସ୍‍ ବେସ ତାଉ ପରିକ୍ଷା ପ୍ରଲୋଭନ୍‍ତେ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ଆତ୍‍ତେ । ଆଗେ ଅଣ୍ଡ୍‌ ମେଟେତ୍ ଜିୱାକିନ୍ ତଡ଼୍ ମାତ୍‍ତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦୂତ ୱାସ୍ ଜିସୁନାଦ୍ ଯତ୍ନ ଅତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଯୋହନ୍‌‌ତିଙ୍କ୍ ବନ୍ଦି ଆତ୍‍ତେ ପେର୍‍କେ ଜିସୁ ଗାଲିଲୀତାଗ୍ ଆଞ୍ଜ୍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତେ ଲେକାମ୍ ଗଟ୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ଅଣ୍ଡ୍‌ କେତ୍‍ତାନ୍, “ଲେକାମ୍ ଦିନାମ୍ ୱାସ୍‍ମିନ୍ଦେ, ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ମି ଗାର୍‍ରେ ୱାସ୍ ହେୱ୍‍ସ୍ ମିନ୍ଦେ ! ପାପ୍ ସେଙ୍ଗେ ମାଲ୍ସ୍‍ୱାସ୍ ଇଦ୍ ଲେକେତ୍ ଗଟ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜିସୁ ଗାଲିଲୀ ସାୱ୍‍ଡ଼େତ୍ ଆଞ୍ଚ୍‍ଇସ୍ ଆଦାନ୍ ୱେଲେ ଶିମୋନ୍ ନୁ ଆନ୍ଦ୍ରିୟ, ଇଡ଼୍ ତାମୁଣ୍ଡ୍‌ଇର୍‍ୱୁଡ଼୍ ୱାଲେ ୱାଟି ସାୱ୍‍ଡ଼େତାଗ୍ କିକେ ପୟ୍‍ସମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, “ନା ତଡ଼୍ ୱାଡ଼ାଟ୍ । ନାନ୍ ମିକିଂଙ୍କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପଇତାନାଦ୍ ନାଡ଼୍‍ସ୍ପିତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ଆସୁଙ୍କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଡ଼ାୱୁ ୱାଲା ୱିଡ଼୍‍ସି ଅନ୍‌ ତଡ଼୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ଜିସୁ ମେଣ୍ଡେ ସୁଦୁଟ୍ ମୁନେ ଆଞ୍ଜ୍ ଜେବଦିନ୍ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କିଡ଼୍ ଯାକୁବ୍ ନୁ ତାନ୍‌ ତାମୁଣ୍ଡ୍‌ ଯୋହନ୍‌ ତିଙ୍କ୍ ଉଡ଼୍‍ତନ୍ । ଅଡ଼୍‌ ଜାରି ୱାଟାନଙ୍କ୍ ନିଜେତ୍ ଓଡେତାଗ୍ ତିଆର୍ ଆସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଡ଼ିମିକା ଗାର୍‍ରେ କାର୍‍ଙ୍କ୍‍ତନ୍ । ଓଡେତାଗ୍ ଚାକର୍‍ନଡ଼୍ ତଡ଼୍ ଅଡ଼୍‌ ବାବାଲ୍ ଜେବଦୀଙ୍କ୍ ୱିଡ଼୍‍ସି ଅଡ଼୍‌ ଜିସୁନ୍ ପାକେ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ କପର୍ନାହୁମ୍‍‍ତାଗ୍ ଆତ୍‌ତଡ଼୍, ମେଣ୍ଡନ୍‍ଦିନେ ଜିସୁ ଯିହୁଦିଡ଼୍ ମିଟିଙ୍କ୍‍ ଲୋନ୍‌ ଆଞ୍ଜ୍ ଶିକ୍ଷା ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ଅନାଦ୍‌ ଶିକ୍ଷା କେଞ୍ଜି ନାରୁଡ଼୍ ବକୁୱା ଆଦ୍‍ତଡ଼୍; ବାତେଙ୍କ୍‍ଇତ୍କେ ଅଡ଼୍‌ ଶାସ୍ତ୍ରିନଡ଼୍ ଲେକାମ୍ ଶିକ୍ଷା ଇୱକଟ୍ ୱେରନ୍ କ୍ଷମତାପନ୍‍ ନାରୁନ୍ ଲେକାମ୍ ଶିକ୍ଷା ଇସମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ଆସୁଙ୍କ୍ ୱେରନ୍ ବୁତ୍‌ପଇତେ ନାରୁଡ଼୍ ପ୍ରାର୍ତନା ଲୋନ୍‌ ନେହେଙ୍ଗି ମିକା କିଡ଼୍‍କ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ହୋ ନାଜରିତିୟ ଜିସୁ, ମା ତଡ଼୍ ନିୟାଦ୍ ବାତ୍ ସମ୍ପର୍କ ? ନିମେ ବାତେଏ ମାକିଂଙ୍କ୍ ଦ୍ୱଂସ ମାଡ଼ାନଙ୍କ୍ ଇଗେ ୱାତ୍‍ତିନ୍; ନିମ୍‍ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାସ୍‍ମାନ୍ଦାନ୍ ଆ ପବିତ୍ର ନାରୁନୀ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ଜିସୁ ଆସୁଙ୍କ୍ ଦମକ୍ ଇସ୍ କେତ୍‍ତନ୍; “ଶାନ୍ତି ଆୟମ୍ ! ଇ ନାରୁନ୍ ଲୋପେଙ୍କ୍ ପେଇସ୍ ଆନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ଆ ବୁତ୍, ଆ ନାରିଙ୍କ୍ ଗାଟି ୱାଡ଼୍‍ସ୍‍କି, ଗାଟି ଲେଙ୍ଗ୍ ମାଡ଼ି ଅନ୍‌ ମେନ୍ଦୁଲ୍‍ତାଗାଙ୍କ୍ ପେଇସ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ଇଗେ ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆସ୍ ନିଜେ ନିଜେ କେତାକେତି ଆତ୍‍ତଡ଼୍, ଇଦ୍ ବେସତ୍ ଗଟ୍ ? ଅଣ୍ଡ୍‌ ଅଦିକାର୍‌ ନୁ ଶକ୍ତି ତଡ଼୍ ଅଶୁଚି ଆତ୍ମାକିଂଙ୍କ୍ ଗଟ୍ ହିଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆୱ୍ ପେୟିସ୍ ଆଦ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ଆଗେ ଅନ୍‌‍ୱାଦ୍ ବିଷୟତେ ସୁସମାଚାର୍ ସାରେ ପାକା ସାରେ ପଡ଼ିୟେତାଗ୍ ପ୍ରଚାର୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ଯାକୁବ୍, ଯୋହନ୍‌ ନୁ ବାଗାତ୍ ଶିଷ୍ୟନଡ଼୍ ତଡ଼୍ ଜିସୁ ପ୍ରାର୍ତନା ଲୋନ୍‌ ୱିଡ଼୍‍ସି ଶିମୋନ୍ ନୁ ଆନ୍ଦ୍ରିୟନ୍ ଲୋନ୍‌ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ଆଗେ ହେଉଦାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ କେଞ୍ଜ୍‍ତଣ୍ଡ୍ ଯେ ଶିମୋନ୍‍ତେ ପୋୟେ ଏଡ଼୍‍କିନେ ପାଟିମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ଅଣ୍ଡ୍‌ ତାନ୍ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ତାନାଦ୍ କାଇ ପଇସ୍ କେତ୍‍ତାନ୍, ତାନାଦ୍ ଏଡ଼୍‍କ୍‍ ୱିଡ଼୍‍ସିଆତ୍‍ତେ ନୁ ଆଦ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସେବା ମାଡ଼ାଙ୍କ୍‍ ଦାନ୍ଦେଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ପଡ଼୍‍ଦ୍‍ ପେଇତାନ୍ ୱେଲେ ନାରୁଡ଼୍ ଜିସୁନ୍‍ପାକେ ରୋଗ୍ ନୁ ବୁତ୍‌ପଇତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ସାରେ ସହର୍‍ତେ ନାରୁଡ଼୍ ୱାସ୍ ଦ୍ୱାର୍‍ମୁନେ ଗୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ବାତ୍‍ବାତ୍ ରୋଗୀଡ଼୍ ମାତ୍‍ତଡ଼୍ ବା ନାର୍‍ଗେ ରୋଗିଡ଼୍‍କ୍‌ ଜିସୁ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ନାର୍ଗେନାରୁଡ଼୍‍ଗାଙ୍କ୍ ବୁତ୍‌କ୍‍ ୱିର୍‍ପ୍‍ତନ୍ ଆ ବୁତ୍‌କିଂଙ୍କ୍ ଗଟି କେତାନଙ୍କ୍ ଇୱେ ମାତ୍‍ତନ୍, ବାତେଙ୍କ୍‍ଇତ୍କେ ଆୱୁ ଅଂକିଙ୍କ୍‌ ପୁଞ୍ଜ୍‍ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ତାନ୍ ମେଣ୍ଡନ୍ ଦିନ୍ ପଡଦ୍ ପେଇୱେ ମୁନେଙ୍କ୍ ଜିସୁ ତେଦି ଲୋତ୍‍ତାଗାଙ୍କ୍ ପେଇସ୍‍ଆତ୍‍ତନ୍ । ଅଣ୍ଡ୍‌ ନାର୍ ୱିଡ଼୍‍ସି ୱେରଡ଼୍ ସିମ୍‍ସାମ୍ ପଡ଼ିୟେତାଗ୍ ଆଞ୍ଜ୍ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ଶିମୋନ୍ ନୁ ତାନ୍ ସାଙ୍ଗନଡ଼୍ ଜିସୁଙ୍କ୍ ମେହେକାନଙ୍କ୍ ପସ୍‍ପ୍‍ ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ଅଂକିଙ୍କ୍‌ ଦର୍ସିକି ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, ମାମ୍‍ମେ ସାରେତମ୍ ନିକିଂଙ୍କ୍ ମେହେକୁତମ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତନ୍, “ଗାର୍‍ରେମାନ୍ଦାନ୍ ବେନା ବେନା ନାକିନାଗ୍ ମାନା ଆଦାଙ୍କ୍ ଆଦ୍‍ତେ । ନାନ୍‍ନେ ଆଗେ ମିକା ପ୍ରଚାର୍ ମାଡ଼ିତାନ୍, ବାତେଙ୍କ୍‍ଇତ୍କେ ଆଦ୍ ଉଦ୍ଦେଶ୍ୟତେ ନାନ୍‍ନେ ଆଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଗାଲିଲୀତେ ସାରେ ନାକିନାଗ୍ ଉଡି ପ୍ରାର୍ତନା ଲୋକିନାଗ୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ବୁତ୍‌କ୍ ୱିର୍‍ସ୍ପତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ୱେରଣ୍ଡ୍ କୃଷ୍ଠରୋଗି ଜିସୁନ୍ ପାକେ ୱାତ୍‍ତନ୍ । ମର୍‍ମିଣ୍ଡା ଇସ୍ ବିନତି ମାଡ଼ି କେତ୍‍ତାନ୍, “ପ୍ରବୁ, ନିମେ ଯଦି ଇଚ୍ଛା ମାଡ଼ିତି, ଆଲାତ୍କେ ନାକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ଡ଼େ ପାର୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ଜିସୁ ଦୟାତେ କାଇ ଆସ୍ ଅଂକିଙ୍କ୍‌ ଇଟ୍‍ତନ୍ ନୁ କେତ୍‍ତାନ୍, “ନାନ୍‍ନେ ଆଦେକେ ଇଚ୍ଛା ମାଡ଼ୁତାନ୍, ନିମ୍‍ ଶୁଚି ଆୟାମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଦ୍ ରୋଗ୍ ଅନାଗାଙ୍କ୍ ଦୁର୍ ଆତ୍‍ତେ ନୁ ଅଣ୍ଡ୍‌ ଶୁଚି ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ତାନ୍‍ପେର୍କେ ଜିସୁ ଅଙ୍କ୍‌ ସତର୍କ ମାଡ଼ି କେତ୍‍ତାନ୍, ");
INSERT INTO kff_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“କେଞ୍ଜା ଇଦ୍‍ଗୋଟ୍ ବେନଙ୍କ୍ ବା କେଲ୍‍ମା ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦର୍ମ ଯାଜଗ୍‍ନଡ଼୍ ପାକେ ଆନ୍‌ । ଅଣ୍ଡ୍‌ ନିକିଂଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼ି ଉଡ଼ିତନ୍ । ତାନ୍‍ପେର୍କେ ନିମ୍‍ ସାରେ ଶୁଚିଆତ୍‍ତିନ୍ ଇଞ୍ଜ ବାଗାତଡ଼୍ ପାକେ ପ୍ରମାନ୍‍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ମୋଶାନ୍‌ ନିର୍ଦ୍ଦେଶ୍‍ ଲେକାମ୍ ପାଲନ୍‍ ମାଡ଼େ ।” ଇଦ୍ କେସ୍ ଜିସୁ ଅଂକିଙ୍କ୍‌ ସାଙ୍ଗେ ସାଙ୍ଗେ ରହସିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁଡ଼୍ ଆଗାଙ୍କ୍ ଆଞ୍ଜ ଇଦ୍‍ଗୋଟ୍ ସାରେପାକ୍ କେତ୍‍ତଡ଼୍ । ଆଦ୍ ଇ ବିଷୟ୍‍ତେ ଇସର୍ କେସ୍ ଉଡ଼୍‍ତଣ୍ତ ଯେ, ଜିସୁ କେତାନଙ୍କ୍ ବେନ୍ ସହର୍ ଲୋପେ ଆଦେ ପାର୍‍ୱନ୍ । ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ସିମ୍‍ ସାମ୍ ପଡ଼ିୟେତାଗ୍ ମାତ୍‍ତନ୍, ଆଗେକ୍‍ ବା ସାରେ ପାକେତ୍ ନାରୁଡ଼୍ ଅନ୍‌‍ପାକେ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ବେସ୍‌କ୍ ଦିନାତ୍ ପେର୍‍କେ ଜିସୁ କପର୍ନାହୁମ୍ ମାଲ୍‍ସ୍ ଆତ୍‍ତନ୍ । ଅଣ୍ଡ୍‌ ଲୋନ୍‌ ମିନ୍ଦେନ୍ ଇଞ୍ଜ କବର୍ ସାରେ ପାକେ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ଆଗେ ଇସର୍ ନାରୁଡ଼୍ ୱାସ୍ ଗୁଡ଼୍‍ତଡ଼୍ ଯେ ଦ୍ୱାର୍‍ପାକ୍ ମିକା ସୁଦୁଟ୍ ବା ପଡ଼ିୟେ ଇଲ୍‍ୱେ ମାତ୍‍ତେ । ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ ପାକେ ବାକ୍ୟ ପ୍ରଚାର୍ ମାଡ଼ାନଙ୍କ୍ ପସ୍ପ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ଜିସୁ ଅଡ଼୍‌‍ପାକେ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼ାନ୍ ୱେଲେ, ନାଲ୍‍ୱୁଡ଼୍ ନାରୁଡ଼୍ ୱେରଙ୍କ୍ ପକ୍ଷାଗାତ୍ ରୋଗିଙ୍କ୍ କାଞ୍ଜି ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁଡ଼୍ ମାନ୍ଦେ ସେଙ୍ଗେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଜିସୁନ୍ ଗାର୍‍ରେ ତାତାଙ୍କ୍ ଆୟେୱେ ମାତ୍‍ତେ । ଆଦିଙ୍କ୍ ଜିସୁ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ମାତ୍‍ତନ୍, ଟିକ୍ ଆଦେ ପଡ଼ିୟେତାଗ୍ ମୁର୍ସ୍‌ତିଙ୍କ୍ ଟେଣ୍ଡ୍‍ତଡ଼୍ ନୁ ଆଦ୍‍ ଆଲାନ୍ ରୋଗିଙ୍କ୍ କେତିତାଗ୍ ପାଡ଼୍‍ସ୍ପି ମଦଲ୍ ଡିପିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଆ ନାରୁଡ଼୍ ବିଶ୍ୱାସ୍ ଉଡ଼ି ଜିସୁ ପକ୍ଷାଗାତ ରୋଗିଙ୍କ୍ କେତ୍‍ତନ୍, “ପେକା ! ନିୟାଦ୍ ପାପ୍ ସାରେକ୍ଷମା ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ଆଗେ କୁଦିମାନ୍ଦାନ୍ ବେସ୍‍ତୁଡ଼୍ ଶାସ୍ତ୍ରୀନାରୁଡ଼୍ ଆଦ୍‍ କେଞ୍ଜି ମାନ୍‍ଦାଗ୍ ଆଲ୍‍ସତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ଅଣ୍ଡ୍‌ ଇଦ୍‍ଗୋଟ୍ କେତାନଙ୍କ୍ ସାହାସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ବେଲାନ୍ ? ଇଦ୍ ଇଶ୍ୱର୍‌ତେ ନିନ୍ଦ୍ । ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ବେନ ପାପ୍‍କ୍ଷମା ମାଡ଼୍‍ଡ଼େ ପାର୍‍ୱଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ଅଡ଼୍‌ ମାନ୍‍ଦେ ହେର୍କା ପୁଞ୍ଜ୍ ଜିସୁ ପଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍, “ବାତ୍‍ତିଙ୍କ୍ ଇଦ୍‍ଲେକାମ୍ କାରାପ୍‍ ଗଟି ସାରେ ଆଲ୍‍ସୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ଆ ପକ୍ଷାଗାତ ରୋଗିଙ୍କ୍ ‘ନିୟାଦ୍ ପାପ୍ କ୍ଷମା ଆତ୍‍ତେ,’ ଇଞ୍ଜ କେତାନାଦ୍ ସହଜ୍ ନା ‘ତେଦା, କେତ୍ ପଇସ୍ ଅନ୍‌’ ଇଞ୍ଜ କେତାନାଦ୍ ସହଜ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","“ପୃତିବିତାଗ୍ ପାପ୍ କ୍ଷମା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ନାରୁନ୍‍ପିଲେତିଙ୍କ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ, ଇଦ୍ ମିଡ଼୍ ଇଞ୍ଜେ ପୁନ୍ଦେପାର୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","ଇଦିନ୍‍ପେର୍କେ ଜିସୁ ଆ ରୋଗିଙ୍କ୍ କେତ୍‍ତନ୍, “ନାନ୍‍ନେ ନିକିଂଙ୍କ୍ କେତୁତାନ୍, ତେଦ୍‍ଦେ, ନିୟାଦ୍ କେତ୍ ପଇସ୍ ଲୋନ୍‌ଆନ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ସାରେତଡ଼୍ ଉଡ଼ି ମାନ୍ଦାନ୍ ୱେଲେ, ରୋଗି ତେଦିମିକା କେତ୍‍ ପଇସ୍ ଆତ୍‍ତନ୍ । ଆଗାଙ୍କ୍ ସାରେତଡ଼୍ ବାକୁୱା ଆସ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍ ଇସ୍ କେତ୍‍ତଡ଼୍, “ମାମ୍‍ମେ ଇଦ୍‍ଲେକାତ୍ କାମ୍ ବେସୁଙ୍କ୍‍ ଉଡ଼୍‍ୱେ ମାତ୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ଜିସୁ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଇଲ୍‍କେ ଗୁୟ୍‍ନ୍ଦେ ଆଞ୍ଚିନା ଆତ୍‍ତନ୍ । ଆଗେ ନାରୁଡ଼୍ ଗୁଡ଼୍‍ନାଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶିକ୍ଷା ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଅଣ୍ଡ୍‌ ଆଗାଙ୍କ୍ ଆଦ୍‍ଦାନ୍ ଆର୍‍ଦାଗ୍ ଆଲପିନ୍‍ ମାର୍‍ ସିସ୍ତୁ ଆଦାୟ୍‍ ମାଡ଼ାନଣ୍ଡ୍ ଲେବୀଙ୍କ୍ ତାନ୍ କାମ୍‍ମାଡ଼ାନଙ୍କ୍ ଲୋତ୍‍ତାଗ୍ କୁଦିମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତନ୍ । ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତାନ୍, “ନା ପେର୍‍କେ ପେର୍‍କେ ୱାଡ଼ା ।” ଲେବିୟତେଦି ଅନ୍‌ ପେର୍‍କେ ଆତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ତାନ୍‍ପେର୍କେ ଜିସୁ ଲେବିନ୍‍ ଲୋନ୍‌ ତିନ୍ଦାନାଗ୍ କୁଦ୍‍ତନ୍ । ଜିସୁନ୍ ପେର୍‍କେ ଆଞ୍ଜ୍ ମାନ୍ଦାନ୍ ନାର୍ଗେନାରୁଡ଼୍ ସିସ୍ତୁ ଆଦାୟ୍‍ ମାଡ଼ାନଣ୍ଡ୍ ନୁ ସମାଜ ଲୋତ୍‍ତେ ନାରୁଡ଼୍ ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍‍ ତଡ଼୍ ଅଣ୍ଡୟାଗେ ତିନ୍ଦାନାଗ୍ କୁଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଆଦ୍ ଉଡ଼ି ପାରୂଶୀଡ଼୍ ମାନ୍ଦେତାଗ୍ ବେସ୍‍ତୁଡ଼୍‍ ଶାସ୍ତ୍ରୀଡ଼୍ ଜିସୁନ୍ ଶିଷ୍ୟଡ଼୍‍କ୍ ପଚାର୍‍ମାଡ଼୍‍ତନ୍, “ଇଦ୍‍ଲେକାମ୍ ନାରୁଡ଼୍‍ତଡ଼୍ ଅଣ୍ଡ୍‌ ବାତ୍‍ତିଙ୍କ୍ ତିଞ୍ଚମିନ୍ଦେନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ଆଦ୍‍ଗଟ୍ କେଞ୍ଜି ଜିସୁ ଉତ୍ତର୍ ଇତ୍‍ତନ୍, “ସୁସ୍ଥନାରୁଣ୍ଡ୍ ସେଙ୍ଗେ ଚିକିତ୍ସା ମାଡ଼ାନାଦ୍ ଦର୍‍କାଡ଼୍ ଇଲ୍‍ଲେ । ଦର୍‍କାର୍‍ ମିନ୍ଦେ ମାତର୍ ଅସୁସ୍ଥ ନାରୁଡ଼୍‍ ସେଙ୍ଗେ । ନାନ୍‍ ଦାର୍ମିକ୍ ନଡ଼୍ ସେଙ୍ଗେ ୱାଡ଼ନ୍, ୱାତ୍‍ତାନ୍ ପାପୀନଡ଼୍ ସେଙ୍ଗେ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଅଣ୍ଡ୍‌ ଦାମ୍ ବାପ୍ତିସ୍ମଇଦାନ୍ ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟନଡ଼୍ ନୁ ପାରୂଶୀଡ଼୍ ଉପବାସ୍ ମାଡ଼ାନ୍‍ୱେଲେ, ବେସ୍‌କ୍ ତଡ଼୍ ଜିସୁନ୍‍ପାକେ ୱାସ୍ ପଚାର୍‍ମାଡ଼୍‍ତଡ଼୍, “ଯୋହନ୍‌ ନୁ ଫାରୁଶୀନଡ଼୍ ଶିଷ୍ୟନଡ଼୍ ଉପବାସ୍ ମାଡ଼ିତଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ନି ଶିଷ୍ୟନଡ଼୍ ବାତ୍‍ତିଙ୍କ୍ ଉପବାସ୍ ମାଡ଼ଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‍ତନ୍, “ସାଙ୍ଗେତେ ମାନ୍ଦା‍ନ୍ ଯାକ ପେଣ୍ଡୁଲ୍‍ ପେକାନ୍‍ତଡ଼୍‍ ମାନ୍ଦାନ୍‍ ନାରୁଡ଼୍‍ ବାତେଏ ଉପବାସ୍ ମାନ୍ଦେ ପାର୍‍ୱଡ଼୍ ? ବେସୁଙ୍କ୍‍ ଆୟ୍‍ୟ । ଅଡ଼୍‌‍ତଡ଼୍ ବର ମାନ୍ଦନ୍ ଯାକ ଅଡ଼୍‌‍ଆଦ୍ ମାଡ଼ଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦିନାମ୍ ୱାତ୍‍ତେ, ବେସୁଙ୍କ୍‍ ବର ଆ ନାରୁଡ଼୍‍ଡ଼ାଗାଙ୍କ୍ ଯେକା ଆଦ୍‍ତଡ଼୍ । ଆସୁଙ୍କ୍‍ ଅଡ଼୍‌ ଉପବାସ୍ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ବେନ ପାଃନ୍ତେ ଚକାନେ ପୁନେ କନାତେ ତାଲି ୱାଟନ୍ । ବାତେଙ୍କ୍‍ଇତ୍କେ ପୁନେ କନାତେ ତାଲି କୁଙ୍କ୍‍ସି ମିକା ସିଲେ ଅଦିକ୍‌ ଇକି ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ମେଣ୍ଡେ, ବେନ ପାଃନ୍ତେ ତଲ୍‍‍କେତ୍‍ କୁଣ୍ଡେତାଗ୍ ପୁନାଦ୍‍ ଦ୍ରାକ୍ଷାରସ୍‍ ୱାଟଡ଼୍; ଇତ୍କେ ପୁନାଲାଦ୍‍ ଦ୍ରାକ୍ଷାରସ୍‍ ୱାଟ୍‍କେ ଆଦ୍ କୁଣ୍ଡେ ପାର୍‍କ୍ ମାଡ଼ିଦ୍‍ତେ, ନୁ ମେଣ୍ଡେ ଦ୍ରାକ୍ଷାରସ୍‍ ନୁ କୁଣ୍ଡେ ରେଣ୍ଡ୍‍ଆସ ନଷ୍ଟ ଆଦ୍‍ତେ । ଆସୁଙ୍କ୍‍ ପୁଃନେ ଦ୍ରାକ୍ଷାରସ୍‍ ପୁଃନେ ତଲ୍‍କେ କୁଣ୍ଡେତାଗ୍ ୱାଟାନଙ୍କ୍‍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ଅନ୍‌‍ଦିନ୍‌ ବିଶ୍ରାମ୍‍ଦିନେତେ ଜିସୁ ୱେରଡ଼୍ କେଡ଼୍ ୱାୟେତାଲାନ୍ ନାଡ଼୍‍ମେଙ୍କ୍ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ । ଅନ୍‌‍ତଡ଼୍ ଶିଷ୍ୟନଡ଼୍ ଆଦ୍‍ଆର୍ ଆଦାନ୍‍ୱେଲେ ଶସ୍ୟକେଡ଼୍ ଦେହେତାନଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ଫାରୁଶୀନଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ଉଡ଼ାଟ୍, ବିଶ୍ରାମ୍‍ଦିନେତେ ମିଇ ଶିଷ୍ୟନଡ଼୍ ମା ଶାସ୍ତ୍ରବିରୁଦ୍ଦ୍‌ତେ ପାଡ଼୍‍ୟି ମାଡ଼ୁତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜିସୁ ଅଡ଼୍‌କିଂଙ୍କ୍‌ ଉତ୍ତର୍‍ ଇତ୍‍ତନ୍, “ବେସୁଙ୍କ୍‍ ଦାଉଦ୍‍ତେ ତିନ୍ଦାନାଦ୍ ନାର୍‍ଗେ ଆତ୍‍ତେ, ଅଣ୍ଡ୍‌ ବାତ୍‍ତେ ମାଡ଼ିତନ୍, ଆଦ୍ ଗୋଟ୍‍ମିଡ଼୍ ବେସୁଙ୍କ୍‍ କାର୍‍ୱିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","“ଅଣ୍ଡ୍‌ ନୁ ତାନ୍ ସାଙ୍ଗନଡ଼୍ କାର୍‍ୱିଙ୍କ୍ ଆଇନାଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ମନ୍ଦିର୍‍ତାଗ୍ ଲୋପେ ଆଞ୍ଜ୍ ଇଶ୍ୱର୍‌ତେ ଉଦ୍ଦେଶ୍ୟତେ ଉତ୍ସର୍ଗିତ ରୂଟି ତିଞ୍ଜ୍ ମାତ୍‍ତଡ଼୍ । ଆବିଆଥାତେ ବେଡ଼ିଇ ପୁରହିତ ମାନ୍ଦାନ୍‍ୱେଲେ ଇଦ୍ ଗଟନା ଗଟେମ୍ ଆସ୍‍ମାତ୍‍ତେ । ମାୟାଦ୍‌ ଶାସ୍ତ୍ରଲେକାମ୍ ମାତର୍ ପୁରହୀତନଡ଼୍ ଇଦ୍ ରୂଟି ତିନ୍ଦାନ୍ ଦର୍‍କାର୍‍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦାଉଦ୍ ନିଜେ ଇଦ୍‍ତିଞ୍ଜ୍ ତାନ୍ ସାଙ୍ଗନଡ଼୍‍କ୍‍ ମିକା ଇସ୍‍ମାତ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ତାନ୍‍ପେର୍କେ ଜିସୁ କେତ୍‍ତନ୍, “ନାରୁଡ଼୍ ସେଙ୍ଗେ ବିଶ୍ରାମ୍‍ଦିନେ ଆସ୍‍ମିନ୍ଦେ, ନାରୁଡ଼୍ ବିଶ୍ରାମ୍‍ଦିନେ ସେଙ୍ଗେ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ଆଦିଙ୍କ୍‍ ନାରୁନ୍‍ ପିଲେ ବିଶ୍ରାମ୍‍ଦିନେତେ ମିକା ପ୍ରବୁ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ଜିସୁ ପ୍ରାର୍ତନା ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆତ୍‍ତନ୍ । ଆଗେ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ମାତ୍‍ତନ୍‍ । ଅନାଦ୍‌ କାଇ ୱାସି ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଜିସୁ ବିଶ୍ରାମ୍ ଦିନେତେ ଆ ନାରୁଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ିତ୍‍ତନ୍ କି ଇଲ୍‍ଲେ, ଇଦ୍ ବିଷୟ୍‍ତେ ଅନାଦ୍‌ ଦଷ୍ ପଇସ୍ କାରାପ୍ ଗଟି ତତାନ୍‍ସେଙ୍ଗେ ବେସ୍‍ତୁଡ଼୍ ନାରୁଡ଼୍ ଅନ୍‌‍ପରୁ ଲେକେତ୍‍ କଣ୍ଡେ ୱାଟ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ଜିସୁ ଆ ନାରୁଙ୍କ୍ କେତ୍‍ତନ୍, “ନା ମୁନେ ତେଦିୱାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପଚାର୍‍ମାଡ଼୍‍ତନ୍, “ବିଶ୍ରାମ୍‍ଦିନେତେ ବାଆତେ ମାଡ଼ାନାଦ୍‍ ଟିକ୍‍ ନିୟମ୍‍ ? ବେନ୍ ଦିନ୍ ୱେରନାଦ୍ ଲେକେତ୍‍ ମାଡ଼ିକାଡ଼୍ ନା କାରାପ୍‍ ମାଡ଼ିକା ? ୱେରନାଦ୍‍ ତ ଜିୱୁନ୍‍ତିଙ୍କ୍‌ ରକ୍ଷା ମାଡ଼ାନାଦ୍ ନା ବିନାସ ମାଡ଼ାନାଦ୍ ? ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ କଟମାତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ଜିସୁ ଅଡ଼୍‌‍ପାକେଙ୍କ୍ କପାମ୍‍ ଆସ୍ ଉଡ଼୍‍ତନ୍‍ ନୁ ଅଡ଼ାଦ୍‌ ତିପାଲ୍‌ ହୃଦୟତିଙ୍କ୍‍ ଉଡ଼ି ଦୁଃକାମ୍ ଆତ୍‍ତନ୍ । ତାନ୍‍ପେର୍କେ ଆ ନାରୁଙ୍କ୍ କେତ୍‍ତନ୍, “କାଇ ଆମ୍‍ ।” ଅଣ୍ଡ୍‌ କାଇ ଆତାନ୍‍ ୱେଲେ ସୁସ୍ଥ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ଆସୁଙ୍କ୍ ଫାରଶୀଡ଼୍‍ ପ୍ରାର୍ତନା ଲୋତ୍‍ତାଗାଙ୍କ୍ ପେଇସ୍ ଆଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ଆୱୁକାନ୍ ସେଙ୍ଗେ “ହେରଦୀନ୍‍” ମାନ୍ଦେତ୍ ନାରୁଡ଼୍‍ତଡ଼୍ ତିର୍‍ୟ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ଗାଲିଲୀ ଇଲ୍‍କେତ୍ ଆଞ୍ଚିନାଗ୍ ଆଦ୍‍ତଡ଼୍ ନୁ ନାରୁଡ଼୍ ନାର୍ଗେମାନ୍ଦେ ଅନ୍‌‍ପେର୍କେ ତାକ୍‍ତଡ଼୍ ମେଣ୍ଡେ, ଯିହୂଦା ପ୍ରଦେଶ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଅଡ଼୍‌ ଗାଲିଲୀ, ଯିହୁଦା, ଯିରୁଶାଲେମ୍, ଏଦୋମ, ଯର୍ଦ୍ଦନ ବେଡ଼୍‍ମ୍‍ତେ ମୁନେମାନ୍ଦାନ୍ ସହର୍ ନୁ ସୋର୍‍ ନୁ ସିଦୋନ୍‍ ସହର୍‍ତେ ଗାର୍‍ରେମାନ୍ଦାନ୍ ନାର୍‍ଦାଗାଙ୍କ୍ ୱାସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ଆଗେ ଇସର୍ ନାରୁଡ଼୍‍ଗହଲି ଆଦ୍‍ତଡ଼୍ ଯେ, ମାନ୍ଦେତାଗାଙ୍କ୍ ରକ୍ଷା ଆଦାନ୍‍ ସେଙ୍ଗେ ଜିସୁ ୱେରଡ଼୍ ଓଡେ ଯୋଗାଡ଼୍ ମାଡ଼ାନଙ୍କ୍ ଶିଷ୍ୟନଡ଼୍‍କ୍‍ କେତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଅଣ୍ଡ୍‌ ନାର୍‍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ନପିନ୍‍ନେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଅଙ୍କ୍‌ ଇଟାନ୍‍ ସେଙ୍ଗେ ମୁନେ ଆଞ୍ଜମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ମେଣ୍ଡେ ବୁତ୍‍ପଇତେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ାନ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅନ୍‌‍ମୁନେ ନେଲ୍‍ରାଲି ଗାଟିଲେଙ୍କ୍‍ଦେ କେସମାତ୍‍ତଡ଼୍ “ନିମେକେ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ଅଣ୍ଡ୍‌ ବେନ, ଇଦ୍‍ଗଟ୍ ବେନଙ୍କ୍ ବା କେଲ୍‍ମାଟ୍ ଇଞ୍ଜ ଜିସୁ ବୁତ୍‌କିଂଙ୍କ୍ ଦମକ୍‍ ଇସ୍ କେସମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ତାନ୍‍ପେର୍କେ ଜିସୁ ମେଟେତ୍‍ପରୁ ଆଞ୍ଜ୍ ବେନଡ଼୍‍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗାର୍‍ରେ କାର୍‍ଙ୍କ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ଅଣ୍ଡ୍‌ ବାରଜାନ୍‍ତିଙ୍କ୍ ହେଞ୍ଚିମିକା ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍ ପେଦେର୍ ଇତ୍‍ତନ୍ । ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତାନ୍, “ନା ତୋଡ଼୍ ମାନ୍ଦାନଙ୍କ୍ ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ ହେଞ୍ଚି ମିନ୍ଦେନ୍ ନୁ ପ୍ରଚାର୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ ରତିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ମିଡ଼୍ ବୁତ୍‌ୱିର୍‍ସ୍ପାନଙ୍କ୍ ଆନ୍‌‍ତେ ଅଦିକାର୍‌ ପାହେମ୍‍ ଆଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ଅଡ଼୍‌‍ ବାରଜାନ୍‍ତିଙ୍କ୍ ହେଞ୍ଚ୍‍ତନ୍ ଶିମୋନ୍ ଜିସୁ ଅଂକିଙ୍କ୍‌ ପିତର୍ ଇଞ୍ଜ ପେଦେର୍ ଇତ୍‍ତନ୍; ");
INSERT INTO kff_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦୀଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କ୍ ଯାକୁବ୍ ନୁ ତାନ୍‌ ତାମୁଣ୍ଡ୍‌ ଯୋହନ୍‌ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବିନେରିଗୋଷ ଇତ୍‍କେ “ମାବ୍‍ତାଗାଙ୍କ୍ ୱାତ୍‍ତେ ମାର୍‍କ୍,” ପେଦେର୍‍ ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିୟ, ଫିଲିପ୍, ବର୍ତଲମି, ମାତିଉ, ତୋମା, ଆଲ୍‍ଫିନ୍ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କ୍‍ ଯାକୁବ୍ ନୁ ତଦ୍ଦିୟ, ଦେଶ୍‍ତିଙ୍କ୍ ପ୍ରେମ୍‍ ମାଡ଼ାନ୍ ଶିମୋନ୍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ଇଷକାରିୟତେ ଯିହୁଦାଲ୍‍ ପେର୍‍କେ ଯେ ଜିସୁନ୍ ତଡ଼୍ ବିଶ୍ୱାସଗାତକତା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ତାନ୍‍ପେର୍କେ ଜିସୁ ବେସୁଙ୍କ୍‍ ଲୋନ୍‌ ମାଲ୍‍ତନ୍, ଆଗେମିକା ଇସର୍ ନାରୁଡ଼୍ ଗୁଡ଼୍‍ତଡ଼୍ ଯେ ଜିସୁ ନୁ ତାନ୍‍ଶିଷ୍ୟନଡ଼୍ ତିନ୍ଦାଙ୍କ୍‍ମିକା ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ଜିସୁ ବାୟ୍‍ ଆତ୍‍ତନ୍ ଇଞ୍ଜ ନାରୁଡ଼୍‍ କେତାନାଦ୍ କେଞ୍ଜି, ଜିସୁନ୍ ଆତ୍ମୀୟନଡ଼୍ ଅଙ୍କ୍‌ପଇସ୍‍ ଆଦାନଙ୍କ୍ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଯିରୁଶାଲେମ୍ ତାଗାଙ୍କ୍ ୱାସ୍‍ମାନ୍ଦାନ୍ ବେସ୍‍ତୁଡ଼୍ ଦର୍ମଗୁରୁଡ଼୍ କେତ୍‍ତଡ଼୍, “ବାଆଲ୍‍ଜିବୁଲ୍ ଅଂକିଙ୍କ୍‌ ଅଦିକାର୍‌ ମାଡ଼୍‍ତେ । ମେଣ୍ଡେ ବୁତ୍‌କିନ୍ ଅଦିପତି ବୁତ୍‌କ୍ ୱିର୍‍ସ୍ପାନଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଶକ୍ତି ଇତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ୱେଷଡ଼୍‍ଲେକାମ୍ ବୁଜାମାଡ଼ି କେତ୍‍ତାନ୍, “ଶୟ୍‍ତାନ୍‍ ବେଲାନ୍ ଶୟ୍‍ତାନ୍‍ତିଙ୍କ୍ ତୋଲାନଙ୍କ୍ ପାର୍‍ତେ ? ");
INSERT INTO kff_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ରାଜ୍ୟତେ ନାରୁଡ଼୍ ଯଦି ମାନ୍ଦା ମାନ୍ଦାଆସ୍ ନିଜେତ୍ ବିରୁଦ୍ଦ୍‌ତେ ଯୁଦ୍‌ ମାଡ଼ିତଡ଼୍, ଆଦ୍ ରାଜ୍ୟ ଦୁଡ଼ା ଦୁଡ଼ା ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ୱେରଡ଼୍ ପରିବାର୍‍ତେ ନାରୁଡ଼୍ ଯଦି ବେନ୍‍ବେନ୍ ମାନ୍ଦେତାଗାଙ୍କ୍ ୱିରିମିକା ନିଜେ ନିଜେ ବିରୁଦ୍ଦ୍‌ ମାଡ଼ିତଡ଼୍, ଆଦ୍ ପରିବାର୍ ଉର୍‍ଙ୍ଗି ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ଆଲେକେ ଯଦି ଶୟତାନ୍‍ତେ ରାଜ୍ୟ ୱେରେ ଆଦ୍‍ତେ, ଆଲେକେ ଆଦ୍ ରାଜ୍ୟ ମାନ୍ଦେପାର୍ୱ, ଦୁଡ଼ା ଦୁଡ଼ା ଆସ୍ ଦ୍ୱଂସ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ଶକ୍ତିନାରୁନ୍ ଲୋନ୍‌ ବେନଆୟି ନେଙ୍କି ମୁନେ ଅଂକିଙ୍କ୍‌ ତୱେମାତ୍‍କେ, ଅନାଦ୍‌ ଜିନିଷ୍‍ ଡ଼ଙ୍ଗି ଅଦେ ପାରେୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ତେ କେତୁତାନ୍ ଯେ, ସାରେ ପାପ୍ ନୁ ଇଶ୍ୱର୍ ଲିନ୍ଦ୍ ସେଙ୍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କ୍ଷମା ଇଦ୍‍ପାର୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନାୟି ପବିତ୍ରଆତ୍ମାତିଙ୍କ୍ ଲିନ୍ଦ୍ ମାଡ଼୍‍କେ, ଅନାଦ୍‌ ବେସୁଙ୍କ୍‌ବା କ୍ଷମାଇଲେ । ବାତେଙ୍କ୍‍ଇତ୍କେ ଅନାଦ୍‌ ପାପ୍ ସାରେ ଦିନାମ୍‍ ମାନ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ଜିସୁଙ୍କୁ ବୁତ୍‌ପଇତେ ଇଞ୍ଜ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେଲ୍‍ନାଙ୍କ୍ ଜିସୁ ଇଦ୍‍ଗଟ୍ କେତ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ଆସୁଙ୍କ୍ ଜିସୁନ୍ ୟାୟ୍‍ ନୁ ଦାଦାଲଡ଼୍ ୱାସ୍ ୱେଉତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ବାଇଦେ ନିସ୍ ଜିସୁଙ୍କ୍‍କାର୍ଗି ତାତାନ୍‍ସେଙ୍ଗେ କବର୍ ରତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ଜିସୁଙ୍କ୍ ନାର୍ଗେ ନାରୁଡ଼୍ ତିଡ଼ିଇ କୁଦିମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଅଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ନି ୟାୟ୍‍ ନୁ ଦାଦାଲଡ଼୍ ନୁ ଏଲାସ୍କ୍‌ ନିୟ୍ ସେଙ୍ଗେ ବାଇଦେ କେପ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ଜିସୁ ଉତ୍ତର୍ ଇତ୍‍ତନ୍, “ବେନ ନା ୟାୟ୍‍, ବେନ୍ ନା ଦାଦାଲଡ଼୍‍ ବେନ ନା ହେଲାଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ତାନ୍ ସାରେପାକ୍ କୁଦିମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଉଡ଼ି ଅଣ୍ଡ୍‌ କେତ୍‍ତାନ୍, “ଉଡ଼େ ଇଡ଼୍‍ ନା ୟାୟ୍‍, ନୁ ଇଡ଼୍ ନା ଦାଦାଲଡ଼୍ ! ");
INSERT INTO kff_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ବେନଆଇ ଇଶ୍ୱର୍‌ତେ ଇଚ୍ଛା ପାଲନ୍ ମାଡ଼ିତଡ଼୍‍, ଅନ୍‌ ନା ଦାଦାଲ୍, ଏଲାସ୍କ୍‌ ନୁ ୟାୟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ସମୁଦ୍ର ଆଞ୍ଚିନା ଜିସୁ ମେଣ୍ଡନ୍ ଦାମ୍ ଶିକ୍ଷାଇଦାନଙ୍କ୍ ଆରାମ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଜିସୁନ୍ ସାରେପାକା ଇସର୍ ନାରୁଡ଼୍ ଯେ ଅଣ୍ଡ୍‌ ୱେରଡ଼୍ ଓଡ଼େତାଗ୍ ଆଞ୍ଜ୍ କୁଦ୍‍ତନ୍ । ଓଡ଼େତାଗ୍ ଏର୍‍ଦେ ଲୋପେ ସୁଦୁଟ୍ ଯେକା ମାତ୍‍ତେ ନୁ ନାରୁଡ଼୍ ଆଞ୍ଚିନ୍‍ ବୂମ୍‌ତାଗ୍‍ ନିସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ଜିସୁ ୱେଷଡ଼୍‍ ଇନା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନାର୍‍ଗେ ଶିକ୍ଷା ଇତ୍‍ତନ୍, ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","ଅନ୍‌ କେତ୍‍ତନ୍, “କେଞ୍ଜାଟ୍ ! ଅନ୍‌‍ଦାମ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ୱାୟେତାଗ୍ ୱିତାନଙ୍କ୍ ପେଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ଅନ୍‌ ୱିଜ୍ ୱିତାନ୍‍ୱେଲେ ଆର୍‍ଦେ ପରୁ ବେସ୍‌କ୍ ରାଲ୍‍ତା ନୁ ପିଟେ ଆୱିଙ୍କ୍ ତିତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ମେଣ୍ଡେ ବେସ୍‌କ୍ ୱିଜ୍ କାଲ୍‍କିନ୍‍ ୱାୟେତାଗ୍ ରାଲ୍‍ତା, ଆଗେ ଅଦିକ୍‌ ଇଶୁର୍ ମାଣ୍ଡୁଲ୍‍ମାତ୍‍ତେ । ଆଗେ ମାଣ୍ଡୁଲ୍‍ତେ ଲୋପେ ଇଲ୍‍ୱାଙ୍କ୍ ଜାପେ ୱିଜ୍ ଗାଜ୍‍ ଆତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାଡା ଲୋପେ ଆଦ୍‍ଦେ ପାର୍‍ୱ । ");
INSERT INTO kff_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ପେର୍‍କେ ପଡ଼ଦ୍‍ତେ ଗାଟିକାମ୍‍କେତେ ଆୱୁ ଗାଜେ ସାରେ ୱାସିଆତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ମେଣ୍ଡେ ବେସ୍‌କ୍ ୱିଜ୍ କୟେ ଦୀବାନାଗ୍ ରାଲ୍‍ତା । ଆୱୁ କୟେମାଡ଼ାକ୍ ପେର୍‍ସି ଇସୁ ଇସୁ ଗାଜେନ୍ ପରୁ ମାନ୍‍ନାଙ୍କ୍ ଆଗେମେଣ୍ଡେ ପେଡ଼େକ୍ ଆୟ । ");
INSERT INTO kff_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ମେଣ୍ଡେ ବେସ୍‌କ୍ ୱିଜ୍ ଲେକେତ୍‍ ୱାୟେତାଗ୍ ରାଲ୍‍ତା, ହାଉସାରେ ଗାଯେଆସ୍ ପେର୍‍ସ୍ତା ନୁ ସାୟେ ଆଦ୍‍ତା; ବେସ୍‌କ୍ ତିରିଶି ଗୁଣ୍, ବେସ୍‌କ୍ ଷାଟିଏ ଗୁଣ୍ ନୁ ବେସ୍‌କ୍ ଶହେ ଗୁଣ୍‍ ଆଦ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଜିସୁଆଦ୍‍ ୱେଷଡ଼୍ ତେର୍‍ପ୍ତି କେତ୍‍ତନ୍, “ବେନନାୱୁ କେଞ୍ଜାନଙ୍କ୍ କେୱୁକ୍‍ ମିନ୍ଦେ, ଅଣ୍ଡ୍‌ ମନ୍‍ଇସ୍ କେଞ୍ଜିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ଜିସୁ ୱେରଣ୍ଡ୍ ମାନ୍ଦାନ୍‍ୱେଲେ କେଞ୍ଜାନଡ଼୍‍ ଆଗାଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ବାର ଶିଷ୍ୟନଡ଼୍‍ ନୁ ଅନ୍‌‍ ପାକେ ବେସ୍‍ତୁଡ଼୍ ମାତ୍‍ତେନଡ଼୍ ଅଣ୍ଡ୍‌ କେସ୍‍ମାନ୍ଦାନ୍ ୱେଷଡ଼୍‍ତେ ଇତ୍‍କେ ବୁଜାମାଡ଼ାଙ୍କ୍ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ଜିସୁ ଉତ୍ତର୍ ଇତ୍‍ତନ୍, “ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ବିଶ୍ୱାସ୍‍ତେ ମିଇପାକେ କେସ୍‍ମିନ୍ଦେନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାଗାତଡ଼୍‍କିଙ୍କ୍ ଇୱୁ ସୁଦୁଟ୍ ୱେଷଡ଼୍‍ତେ ଲେକାମ୍‍ କେତୁତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଆଦିନ୍‌ ସେଙ୍ଗେ, ଅଡ଼୍‌ ଉଡ଼ଡ଼୍ ମାନ୍‍ତଡ଼୍ ଇତ୍‍କେ ବାତେଏ ଉଡ଼େ ପାର୍‍ୱଡ଼୍ । ସାରେ ଗଟି କେଞ୍ଜିମାନ୍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାତେଏ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍; ଅଡ଼୍‌ ଯଦି ପ୍ରକୃତ୍‍ତେ ଉଡ଼େଡ଼୍‍ ନୁ ବୁଜେମ୍ ଆୟେଡ଼୍, ଅଡ଼୍‌ ଇଶ୍ୱର୍‌ତେ ପାକେ ମାଲ୍‍ସ୍ ୱାଡେଡ଼୍ ନୁ ଇଶ୍ୱର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କ୍ଷମା ଇୱେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପଚାର୍‍ମାଡ଼୍‍ତନ୍, “ଇଦ୍ ୱେଷଡ଼୍‍ତେ ଇତ୍‍କେ ବାତେଏ ବୁଜେମ୍ ଆୟ୍‍ୱିଡ଼୍ ? ଆଲେକେ ମେଣ୍ଡନ୍ ୱେଷଡ଼୍ ସାରେତିଙ୍କ୍ ବୁଜେମ୍ ଆଦ୍‍ତିଡ଼୍ ବେଲାନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ଇଶ୍ୱର୍‌ତେ ଗଟ୍ ପଚାର୍‌ମାଡ଼ାନ୍‌ଡ଼୍‍, ୱିଜ୍ ୱିତାନନ୍ ଲେକାମ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଆର୍‍ଦାଗ୍ ରାଲିମାନ୍ଦାନ୍ ୱିଜେଲେକାମ୍ ଆଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ଗ୍ରହନ୍ ମାଡ଼ିତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ କେଞ୍ଜାନ୍‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଶୟ୍‍ତାନ୍‍ ଅନାଦ୍‌ ଡଙ୍ଗିଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","କାଲ୍‍କିନ୍‍ ୱାୟେତାଗ୍ ରାଲିମାନ୍ଦାନ୍ ୱିଜେଲେକାମ୍ ଆଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ କେଞ୍ଜ୍‍ତେ ୱେଲେ ୱେଡ଼୍‍କେତେ ଗଟ୍‍ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବିଶ୍ୱାସ୍‍ତେ ଆଦ୍ ହୃଦୟଙ୍ଗମ ମାଡ଼୍‍ୱାଙ୍କ୍ ଅଡ଼୍‌ ଆଗାଙ୍କ୍ ତିଆର୍‍ତେ ମାନ୍‍ନ୍ଦେ ପାର୍‍ୱଡ଼୍ ନୁ ଆଦ୍ ଗଟ୍ ସେଙ୍ଗେ ବେସୁଙ୍କ୍‍ ଦୁଃକାମ୍ କଷ୍ଟ ନୁ ଉତ୍‍ପିଡ଼ିତ ୱାସ୍‍ହେଉତେ, ଅଡ଼ାଦ୍‌ ଦଂସ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","କୟେ ଦିବାନାଗ୍ ରାଲିମାନ୍ଦାନାୱୁ ୱିଜେଲେକାମ୍ ଆଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ କେଞ୍ଜିତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ବାତେଙ୍କ୍ ଇତ୍‍କେ ସଂସାର୍‍ତେ ଚିନ୍ତେ, ଡାବ୍‍କିନ୍‍ ଆସେ ନୁ ଲେକେତାୱୁ ବେଶତାୱ୍‍ ଲାଲସା ତାମ୍‍ ମାନ୍‍ତାଗ୍ ମାନ୍‍ନାଙ୍କ୍ ମାଡ଼ାନଙ୍କ୍ ଆଦ୍ ଗଟ୍ ବେସୁଙ୍କ୍‌ବା କାୟେ ଆଦ । ");
INSERT INTO kff_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ଲେକେତ୍‍ ୱାୟେତାଗ୍ ରାଲିମାନ୍ଦାନ୍ ୱିଜେଲେକାମ୍, ଆଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେଞ୍ଜି ଗ୍ରହନ୍ ମାଡ଼ିତଡ଼୍ ନୁ ଜିୱେତାଗ୍ ବେନ ତିରିଶ୍ ଗୁଣ୍, ବେନ ଷାଟିଏ ଗୁଣ୍ ନୁ ବେନ ଶହେ ଗୁଣ୍ କାୟା ଆଦ୍‍ଦିତ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଜିସୁ ମେଣ୍ଡେ କେତ୍‍ତଣ୍ତ୍, ବେନ ବାତ୍‍ତେ କୁପିତିଙ୍କ୍ ନିଡ଼୍‍ସ୍‍ପି ବଡ଼୍‍ ମଦଲ୍ ମୁସ୍‍ସି ୱାଟିତନ୍ ବା କାଟୁଲ୍‍ ମଦଲ୍ ୱାଟିତନ୍ ? ଆଦ୍ ବାତ୍‍ତେ ୱେସ୍‍ୱାଟାନ୍ ପରୁ ୱାଟାନଙ୍କ୍‍ ଆୟ୍‍ୟ ? ");
INSERT INTO kff_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ବାତେଏ ମିଞ୍ଜି ମିନ୍ଦେ, ଆଦ୍ ପ୍ରକାଶ୍‍ ଆଦ୍‍ତେ; ବାତେଏ ତନ୍ଦମିନ୍ଦେ, ଆଦ୍ ବେସୁଙ୍କ୍‍ ବା ତନ୍ଦ । ");
INSERT INTO kff_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ବେନଙ୍କ୍ କେଞ୍ଜାନଙ୍କ୍ କେୱୁ ମିନ୍ଦେ, ଅନ୍‌ କେଞ୍ଜିନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତାନ୍, “ବାତ୍‍ତେ କେଞ୍ଜିତିଡ଼୍, ଆଦିନ୍ ସେଙ୍ଗେ ମାନ୍‍ଇସ୍ କେଞ୍ଜାନଙ୍କ୍ ମାନୁଟ୍ । ବେନ୍‍ବାଡ଼୍‍ତେ ମିଡ଼୍ ବାଗାତଡ଼୍ ବିଚାର୍ ମାଡ଼ାଟ୍, ଆଦ୍ ବାଡ଼୍‍ତେ ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଦିକ୍‌ କଷ୍ଟତେ ଇଶ୍ୱର୍ ମିୟାଦ୍ ବିଚାର୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ବେନନାଉ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ଅଦିକ୍‌ ଇଦ୍‍ତନ୍ । ବେନନାଉ ଇଲା, ଅନାହୁ ବାତେସାରେ ମିନ୍ଦେ, ଆଦ୍ ମିକା ଟେଣ୍ଡିଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଜିସୁ କେତାନଙ୍କ୍ ପସ୍ପ୍‍ତନ୍; ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତେ ଆସର୍ ଇଦ୍‍ଲେକାମ୍ । ୱେରନ୍ ନାରୁନ୍ ୱାୟେତାଗ୍ ୱିତିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ନାର୍‍କେତ୍ ଉଞ୍ଜାଙ୍କ୍ ଆଦ୍‍ତନ୍ ନୁ ପାୟାଲ୍ କେପିତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ୱିଜ୍ ଗାଜେଆସ୍ ବେଲାନ୍ ନାର୍‍ଗେ ଆଦ୍‍ତେ, ଆଦ୍‍ ଅଣ୍ଡ୍‌ ପୁନଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ମାଡ଼େ ପେର୍‍ସି କାୟାଆଦାନ୍ ସେଙ୍ଗେ ମାଣ୍ଡୁଲ୍ଏ‍କେ ସାରେ ମାଡ଼ିତେ, ମୁନେଙ୍କ୍ ମାଡ଼େତେ ଚିଟି, ତାନ୍‍ପେର୍କେ କଡ଼୍‍ସିତ୍‍ ନୁ ପେର୍‍କେ କେଡ଼୍‍ତାଗ୍ ପେଡ଼େକ୍‍ ଆଦ୍‍ଦିତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ପେଡ଼େକ୍ ପାଣ୍ଡି କଇଦାନ୍ ଦିନାମ୍ ହେଉକେ; ଅଣ୍ଡ୍‌ ଏଟାକେସେର୍ ପଇସ୍ କଇଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ଜିସୁ କେତ୍‍ତଣ୍ତ ; ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତଡ଼୍ ବେନଙ୍କ୍ ସାମାନ୍ ମାଡ଼ାନଙ୍କ୍ ଆଦ୍‍ତେ ? ଅଂକିଙ୍କ୍‌ ବୁଜାମାଡ଼ାନ୍‍ ସେଙ୍ଗେ ବାତେଏ ୱେଷଡ଼୍ କେତିତାନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ଇଦ୍ ୱେଷଡ଼୍ ଗର୍ର୍ ପେଡ଼େମ୍‍ ଲେକାମ୍ । ଗର୍ର୍‌ ପେଡ଼େମ୍ ଗାଟି ସୁଦୁରାଦ୍ ଆତ୍କେ ମିକା, ");
INSERT INTO kff_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ମାଣ୍ଡୁଲ୍‍ତାଗ୍ ରାଲ୍‍କେ ଆଦ୍ ବେଡ଼ିୟାଦ୍ ମାଡ଼େ ଆସ୍ କମା ଆଦ୍‍ତେ ନୁ ବେଡ଼ିୟାଦ୍ ମାଡେ ଲେକାମ୍ ତିଆର୍‍ଆଦ୍‍ତେ ନୁ ପିଟେ ତାନ୍ ତୁଉକାନାଗ୍ ବାସେ ମାନ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଇଦ୍‍ଲେକାମ୍ ନାର୍‍ଗେ ୱେଷଡ଼୍‍ତେ ଗଟି କେସ୍‍ ଜିସୁ ଅନାୱୁ ଗଟି ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍; ଅଡ଼୍‌ ବେସର୍ ବୁଜେମ୍ ଆତ୍‍ତଡ଼୍, ଅଣ୍ଡ୍‌ ଆସର୍ କେସ୍‍ମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ୱେଷଡ଼୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ଅନ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତାନାଦ୍ ଇୱେମାତ୍‍ତନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାତର୍ ଶିଷ୍ୟନଡ଼୍‍ତଡ଼୍ ମାନ୍ଦାନ୍ ୱେଲେ ଅନ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାରେ ଗଟି କେସ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ଆଦ୍ ଦିନ୍ ମୁଲ୍‍ପୁଟ୍ ଜିସୁ ଶିଷ୍ୟନଡ଼୍‍କ୍ କେତ୍‍ତନ୍, “ଦାଟିଟ୍‍, ମାନାଡ଼୍ ବେଡ଼େମ୍ ଆପାକ୍‍କେ ଆଦିକାଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ଅନ୍‌ଦିନେ ଅଡ଼୍‌ ନାରୁଡ଼୍‍କ୍‍ ୱିଡ଼୍‍ସି ଓଡେତାଗ୍ ଆଞ୍ଜ୍ କୁଦ୍‍ତଡ଼୍ । ଆଗାଙ୍କ୍ ଜିସୁ ମୁନେକେ କୁଦିମାତ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ଓଡେତିଙ୍କ୍ କଅତାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ ତଡ଼୍ । ବେଡ଼େମ୍‍ତାଗ୍ ମେଣ୍ଡେ ନାର୍‍ଗେ ଓଡା ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ହଟାତ୍ ଗାଟି ଗାଲ୍‍ ୱାତ୍‍ତେ ନୁ ଓଡେତ୍ ଲୋପେ ତଲ୍‍କଡ଼୍‍ତେ ଏର୍‍ ଓଡ଼େତାଗ୍ ନିଣ୍ଡାନଙ୍କ୍ ପସ୍ପତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ଜିସୁ ଓଡେତ୍ ପେର୍କେତ୍‍ ପାକେ ବାଲିସ୍‍ତେ ପରୁ ତାଲେୱାଟି ଉଞ୍ଜିମାତ୍‍ତନ୍ । ଶିଷ୍ୟନଡ଼୍ ଅଙ୍କ୍‌ ତେସ୍‍ କେତ୍‍ତଡ଼୍, “ଗୁରୁ, ମାମ୍‍ମେ ମୁଡ଼ୁନ୍ଦି ଡଲିତମ୍, ନିୟାଦ୍ ବାତେଏ ଚିନ୍ତାଇଲେ ?” ");
INSERT INTO kff_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ଜିସୁ ନିସ୍‍ମିକା ଗାଲ୍‍ଦିଙ୍କ୍ ଦମକ୍‍ଇସ୍ କେତ୍‍ତନ୍, “ଶାନ୍ତି ଆୟିମ୍,” ନୁ ତଲ୍‍କଡ଼୍‍ତିଙ୍କ୍ କେତ୍‍ତନ୍, “ସୁସ୍ଥିର ଆୟିମ୍ ।” ହଟାତ୍ ଗାଲ୍ ମାଦ୍‍ତେ ନୁ ସାରେ ଶାନ୍ତି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ତାନ୍‍ପେର୍କେ ଜିସୁ ଶିଷ୍ୟନଡ଼୍‍କ୍ ପଚାର୍‍ମାଡ଼୍‍ତନ୍, “ବାତ୍‍ତିଙ୍କ୍ ଆସର୍ ୱେର୍‍ଦୁତିଡ଼୍ ? ଇଞ୍ଜେକ୍ ଆଇନା ବାତେଏ ମିୟାଦ୍ ବିଶ୍ୱାସ୍ ଇଲେ ?” ");
INSERT INTO kff_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","କିନ୍ତୁ ଅଡ଼୍‌ ଗାଟି ୱେର୍‍ସ୍‍ ମିକା ତାମେ ତାମେ କେତ୍‍ତଡ଼୍, ଇ ନାରୁଣ୍ଡ୍ ବେନ ? ଏର୍‍ ନୁ ଗାଲ୍ ଅନ୍‌‍ ଗଟି ମାନେମ୍‍ ଆଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ଗାଲିଲୀ ବେଡ଼େମ୍ ମେଣ୍ଡନ୍‍ ପାକେ ଗରାଶୀୟନଡ଼୍ ନାର୍ଦାଗ୍ ହେଉତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଜିସୁ ଓଡେତାଗାଙ୍କ୍ ଡ଼ିଗାନ୍‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଗେ ମାନ୍ଦାନ୍ କବର୍ ବା ପାଡ଼୍‍କିନ୍ ଲୋପେଙ୍କ୍ ୱେରନ୍ ବୁତ୍‌ପଇତେ ନାରୁନ୍ ୱାସ୍ ଅଙ୍କ୍‌ କାଇଲ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ଅଣ୍ଡ୍‌ ୱିସ୍‍କିନାଗ୍ ମାନ୍‍ନୁନ୍ । ବେନ ଅଙ୍କ୍‌ ଇକ୍‍ଲେମ୍‍ତ ମିକା ତଅତ୍‍ତେ ପାର୍‍ୱେ ମାନ୍‍ମାନ । ");
INSERT INTO kff_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ଅଣ୍ଡ୍‌ କାଇକିନାଉ ଇକ୍‍ଲେମ୍‍ ଦେହେସ୍‍ ମାତ୍‍ତନ୍ ନୁ ଡେକାନ୍ ବେଡ଼ି ଉୱୁସ୍ ମାନ୍‍ନୁନ୍ । ଅନାହୁ କାଇକ୍ ଡ଼େକା ଇକ୍‍ଲେକ୍ ତହସ୍ ମାତ୍‍ତଡ଼୍ । କିନ୍ତୁ ଅଙ୍କ୍‌ ପଇତାନ୍ ସେଙ୍ଗେ ବେନନାଦ୍ ଶକ୍ତି ଇଲ୍‍ଲେ । ");
INSERT INTO kff_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ଅଣ୍ଡ୍‌ ନାର୍କା ପାୟାଲ୍ ମେଟାନାଗ୍ ନୁ ୱିଷ୍‍କିନାଗ୍ ଉଡମାନ୍‍ନୁନ୍, କିଡ଼୍‍କି ମିକା କାଲ୍‍କିନାଗ୍ ନିଜେତ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଚିହ୍ନା ମାଡ଼ମାତ୍‍ତଣ୍ତ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ସୁଦୁଟ୍ ଯେକା ଜିସୁଙ୍କ୍ ଉଡ଼ି ଅଣ୍ଡ୍‌ ମିରିୱାସ୍ ଅନ୍‌ ମୁନେ ମର୍‍ମିଣ୍ଡା ଇସ୍, ");
INSERT INTO kff_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଗାଟିଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତାନ୍, “ହୋ ସର୍ବୋପରିସ୍ଥ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ଜିସୁ ! ନା ପାକେ ନିୟାଦ୍‍ ବାତେ ପାଡ଼୍‍ୟି ? ଇଶ୍ୱର୍‌ତେ ପେଦେର୍‍ତେ କେତୁତାନ୍, ନାକିଙ୍କ୍ ଯନ୍ତ୍ରଣା ଇମା ।” ");
INSERT INTO kff_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଅଣ୍ଡ୍‌ ଇଦ୍‍ଗଟ୍ କେତ୍‍ତନ୍, ବାତେଙ୍କ୍‍ ଇତ୍‍କେ ଆସୁଙ୍କ୍ ଅନାଗେ ମାନ୍ଦା‍ନ୍ ବୁତ୍‌କିଂଙ୍କ୍ ପେଇସ୍‍ ଆଦାନ୍ ସେଙ୍ଗେ କେସମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଜିସୁଅଙ୍କ୍‌ କେତ୍‍ତନ୍, “ନି ପେଦେର୍‍ ବାତ୍‍ତେ ?” ଅଣ୍ଡ୍‌ ଉତ୍ତର୍‍ ହିତ୍‍ତନ୍, “ନା ପେଦେର୍ ବାହିନୀ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","“ମାମେ ନାର୍ଗେ ।” ଆୱିକିଂଙ୍କ୍ ଆଦ୍ ନାର୍‍ଦାଗାଙ୍କ୍ ଯେକା ତଲ୍‍ମାଟ୍ ଇଞ୍ଜ ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ କେତାନଙ୍କ୍ ପସ୍ପ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ଗାର୍‍ରେ ମାନ୍ଦାନ୍ ମେଟେତାଗ୍ ମାନ୍ଦେ ପାଦି ମେୟ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ବୁତ୍‌କ୍ ଜିସୁଙ୍କ୍ ଅନୁରଦ୍‌ ମାଡ଼ି କେତ୍‍ତା, “ଆୱୁ ପାଦି ମାନ୍ଦେ ଲୋପେ ନେଙ୍ଗାନ୍ ସେଙ୍ଗେ ମାକିଙ୍କ୍ ଇମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଜିସୁ କେସ୍‍ ଇତ୍‍ତ‍ନ୍ ନୁ ବୁତ୍‌କ୍ ଆ ନାରୁନାଗାଙ୍କ୍ ପେଇସ୍‍ ୱାସ୍ ପାଦି ମାନ୍ଦେ ଲୋପେ ନେଙ୍ଗ୍‍ତା ନୁ ସାରେ ରେଣ୍ଡ୍‍ହଜାର୍‌ ପାଦି ଗାଟି ଉର୍‍ଗିଙ୍କ୍ ମିରି ମେଟେତ୍‍ ଜୁଟିନାଗାଙ୍କ୍ ରାଲ୍‍ଲି ମୁଡ଼୍‍ନ୍ଦି ଡଲ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ପାଦିଙ୍କ୍ କେପାନଡ଼୍ ମିରିଆଞ୍ଜ୍ ଇଦ୍ କବର୍ ସହର୍ ନୁ ଗାରେମାନ୍ଦାନ୍ ନାକିନାଗ୍ କେସ୍‍ସିତ୍‍ତଡ଼୍ । ବାତେ ଗଟେମ୍ ଆତ୍‍ତେ, ଉଡ଼ାନଙ୍କ୍ ନାର୍ଗେ ନାରୁଡ଼୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଅଡ଼୍‌ ଉଡ଼୍‌ତଡ଼୍ ଯେ ବୁତ୍‌ପଇତେ ନାରୁନ୍ ଚକା କେର୍‍ସ୍ ଲେକେତ୍‍ ତିଆର୍ ଆସ୍ ଜିସୁନ୍ ଗାରେ କୁଦ୍‍ତନ୍ । ଆଦ୍ ଉଡ଼ି ଅଡ଼୍‌ ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ବୁତ୍‌ପଇତେ ନାରୁନ୍ ବେଲାନ୍ ସୁସ୍ଥ ଆତ୍‍ତନ୍ ନୁ ପାଦି ବେଲାନ୍ ନଷ୍ଟ ଆସ୍ ମାତ୍‍ତା, ଇୱୁସାରେ ଗଟ୍‍ନା ଉଡ଼ିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ଆଦ୍ କେଞ୍ଜି ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ଆଦ୍ ନାର୍ ୱିଡ଼୍‍ସି ଆଦାଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ଜିସୁ ଓଡେତାଗ୍ ତାରେନଙ୍କ୍ ଆଦାନ୍ ୱେଲେ ବୁତ୍‌ତାଗାଙ୍କ୍ ରକ୍ଷା ଆସ୍‍ମାନ୍ଦାନ୍ ନାରୁଣ୍ଡ୍ ଅନ୍‌‍ତଡ଼୍ ଆଦାନ୍ ସେଙ୍ଗେ କେତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ଜିସୁ ଅଙ୍କ୍‌ ତାନ୍‌ଡ଼୍‌ ଆଦାଙ୍କ୍‌ ଇୱକଟ୍ କେତ୍‍ତନ୍, “ଲେକେତ୍ ମିଇ ଲୋନ୍‌‍ ମୀଇ ନାରୁଡ଼୍‍ ପାକେ ମାଲ୍‍ସ୍ ଆନ୍‌ । ପ୍ରବୁ ନିଇ ସେଙ୍ଗେ ବାତ୍‍ତେ ସାରେ ମାଡ଼୍‍ତନ୍ ନୁ ନିଇ ମାଇଦିଙ୍କ୍ ବେନ୍ ଦୟା ତତ୍‍ତନ୍, ଇଦ୍ ଗଟ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେଲ୍‍ମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ନାରୁଣ୍ଡ୍ ଦେକାପଲୀ ଅଞ୍ଚଲ୍‍ତା ଆଞ୍ଜ୍ ଜିସୁ ଅନ୍‌‍ସେଙ୍ଗେ ବାତେ ମାଡ଼ିମାତ୍‍ତନ୍, ସାରେପାକେ କେତ୍‍ତନ୍ । ବେନଡ଼୍ ଅନ୍‌ ଗଟି କେଞ୍ଜ୍‍ତଡ଼୍, ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜିସୁ ବେଡ଼େମ୍‍ତେ ମେଣ୍ଡ୍‍ନ୍ ପାକେ ମାଲ୍‍ସ୍‍ ଆତ୍‍ତନ୍ । ଆ ସମୁଦ୍ର ଆଞ୍ଚିନାଗ୍ ନାର୍ଗେ ନାରୁଡ଼୍ ଅଙ୍କ୍‌ ତିଡ଼ିୟି ନିସ୍‍ ଗୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ଆଗେମାନ୍ଦାନ୍ ଲୋତ୍‍ତେ ଯାଇରସ୍ ପେଦେର୍‍ତନ୍ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍ ଆଗେ ହେଉତ୍‍ତନ୍, ");
INSERT INTO kff_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ନୁ ଜିସୁଙ୍କ୍ ଉଡ଼ି ଅନ୍‌ ଡେକାନ୍ ମଦଲ୍ ରାଲି ହୃଦୟତେ ନିବେଦନ୍ ମାଡ଼୍‍ତନ୍, “ନା ମାୟାଡ଼୍ ନାର୍ଗେ ରୋଗ୍‍ତେ ମିନ୍ଦେ । ନିମେ ୱାସ୍ ତାନ୍ ପରୁ କାଇ ୱାଟ୍‍କେ, ଆଦ୍ ସାୟେ ଆସ୍ ଗେଲ୍‍ସିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଜିସୁ ଅନ୍‌‍ତୋଡ଼୍ ଆଦାନଙ୍କ୍ ପେଇତ୍‍ତନ୍ । ନାର୍ଗେ ମୁଲ୍‍ ନାରୁଡ଼୍‍ ଅନ୍‌‍ତଡ଼୍ ଆଞ୍ଜମାତ୍‍ତଡ଼୍ ଯେ ଅନ୍‌ ପରୁ ଅଡ଼୍‌ ସାରେପାକେଙ୍କ୍ ତାଲ୍‍ଗି ରାୟମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ୱେରଡ଼୍ ମୁତ୍‍ତେ ପ୍ରାୟ ବାର ହେଣ୍ଡେକ୍ ପୟିସ୍ ନେତୁର୍‍ ପେଇତାନ୍ ରୋଗ୍‍ତେ ଗାଟି ତିପାଲ୍ ଆସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ନାର୍ଗେଦାମ୍‍ ସାୟେ ମାଡ଼୍‍କେ ମିକା ସାୟେ ଆୱେ ମାତ୍‍ତେ, ତାନାଉ ସାରେ ଡାବ୍‍କ୍‍ ତେରମାତ୍‍ତେ ମିକା, ରୋଗ୍ ଲେକେତ୍‍ ଆୟ୍‍ୱେ ମାତ୍‍ତେ ନୁ ନାର୍ଗେ ଆସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ଆଦ୍ ଜିସୁନ୍ ବିଷୟ୍‍ତେ କେଞ୍ଜିମାତ୍‍ତେ ନୁ ନାରୁଡ଼୍ ଗହଲି ଲୋପେଙ୍କ୍ ଜିସୁନ୍‍, ସିଲେତିଙ୍କ୍‍ ହିଟ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ପେର୍କେଙ୍କ୍ ୱାସ୍‍ ଆଲ୍‍ସମାତ୍‍ତେ, “ନାନେ ଯଦି ଅନାଦ୍‌ ସିଲେତିଙ୍କ୍, ହିଟ୍‌କେ ନାନେ ସାୟେ ଆଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ଆଦ୍ ଜିସୁନ୍ ସିଲେତିଙ୍କ୍ ଇଟ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ତାନାଦ୍ ନେତୁର୍ ପେଇତାନାଦ୍ ବନ୍ଦ ଆତ୍‍ତେ ନୁ ଆଦ୍ ରୋଗ୍‍ତାଗାଙ୍କ୍ ସାୟେ ଆତ୍‍ତେ ଇଞ୍ଜ ଏର୍କେ ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ଆସୁଙ୍ଗେ ଜିସୁ ଅନାଗାଙ୍କ୍ ଶକ୍ତି ପେୟିସ୍ ଆଦାନାଦ୍ ପୁତ୍‍ତନ୍ ନାରୁଡ଼୍‍ ପାର୍କେ ମିଡ଼୍‍ନ୍ଦି ମିକା କେତ୍‍ତନ୍, “ବେନ ନା ସିଲେତିଙ୍କ୍‍ ଇଟ୍‍ତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ତାନ୍‍ ଶିଷ୍ୟନଡ଼୍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ନିମେ ତ ଉଡ଼ମିନ୍ଦେନି, ବେଲାନ୍ ନି ସାରେ ପାକା ନାରୁଡ଼୍ ମାନ୍ଦେ ଆସ୍‍ମିନ୍ଦେଡ଼୍ । ନିକିଙ୍କ୍ ବେନ ଇଟ୍‍ତନ୍ ଇଞ୍ଜ କେସମିନ୍ଦେନି ବାତ୍‍ତିଙ୍କ୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","କିନ୍ତୁ ବେନ ଅଙ୍କ୍‌ ଇଟ୍‍ତନ୍, ପୁନ୍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଜିସୁ ସାରେ ପାକ୍‍କେ ଉଡ଼୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ସାରେ ଗଟି ପୁନ୍ଦେପାର୍‍ସ୍ ଆ ନାଟାଡ଼୍ ୱେର୍‍ଗିଙ୍କ୍ ଜିସୁନ୍ ଡେକାନ୍ ମଦଲ୍ ମର୍‍ମିଣ୍ଡା ଇସ୍ ସାରେ ସତ୍‍ ଗଟି କେତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ଜିସୁ ଆଦିଙ୍କ୍‍ କେତ୍‍ତନ୍, “ପିକି ! ନିୟାଦ୍ ବିଶ୍ୱାସ୍ ନିକିଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତେ । ସାରେତାଗାଙ୍କ୍ ସାୟେ ଆସ୍ ଶାନ୍ତିତେ ମାଲ୍‍ସ୍ ଅନ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ଜିସୁ ଇଦ୍‍ଗଟ୍ କେତାନ୍‍ ୱେଲେ, ଯାଇରସ୍‍ତେ ଲୋତ୍‍ତେ କଞ୍ଜ୍ କବର୍‍ ତାସ୍‍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଅଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ନି ମାୟାଡ଼୍ ଡଲିଆତ୍‍ତେ, ମେଣ୍ଡେ ବାତ୍‍ତିଙ୍କ୍ ଗୁରୁଙ୍କ୍ ତିପାଲ୍ ମାଡ଼ୁତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ଜିସୁ ଅଡ଼ାୱୁ ଗଟିଙ୍କ୍ କେଞ୍ଜିମିକା ଯାଇରସ୍‍ତିଙ୍କ୍ କେତ୍‍ତନ୍, “ୱେର୍‍ମା; ମାତର୍ ବିଶ୍ୱାସ୍‍ ମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ତାନ୍‍ ପେର୍କେ ଯାକୁବ୍, ତାନ୍ ତାମୁଣ୍ଡ୍‌ ଯୋହନ୍‌‌ ନୁ ପିତର୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ସାଙ୍ଗେତେ ମେଣ୍ଡେ ବେନଙ୍କ୍ ଆୟକଟ୍ ଜିସୁ ଯାଇରସ୍‍ତେ ଲୋନ୍‌‍ ଆତ୍‍ତଣ୍ତ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ଆଗେ ହେଉସ୍ ଅଣ୍ଡ୍‌ ଉଡ଼୍‍ତନ୍, ନାଟା ଗାଟିଲେଙ୍ଗ୍‍ଦେ କେୟ ମାତ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଆଦ୍ ମାନ୍ଦେତିଙ୍କ୍ ଆଞ୍ଜ୍ ଆୱିଙ୍କ୍ କେତ୍‍ତନ୍, “ବାତ୍‍ତିଙ୍କ୍ ମର୍‍ ଆଦୁତିଡ଼୍ ? ବାତ୍‍ତିଙ୍କ୍ କେୟୁତିଡ଼୍ ? ପିକିଡ଼୍ ଡଲ୍‍ଲ, ଉଞ୍ଜ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ଅଡ଼୍‌‍ ଅଙ୍କ୍‌ ବାକ୍‍ୱାଲ୍ ଆଲ୍‍ସି କାୱୁତ୍‍ତଡ଼୍ । ଜିସୁ ସାରେତଡ଼୍‍କ୍ ପେସ୍‍ପିତ୍‍ତନ୍ ନୁ ମାତର୍ ନିଜେତ୍ ମୁୱୁଡ଼୍ ଶିଷ୍ୟ ନୁ ପିଲେତ୍ ୟାୟ ବାବାଙ୍କ୍ ଆସ୍ ଆଦ୍ ଉଞ୍ଜିମାନ୍ଦାନ୍ ବାକ୍‍ଡ଼େତାଗ୍ ଆତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ପିଲେତ୍ କାଇଦିଙ୍କ୍ ପଇସ୍‍ ଜିସୁ କେତ୍‍ତନ୍, “ତାଲିତା କୁମ୍,” ଇତ୍‍କେ “ପିକି, ନାନ୍ କେତୁତାନ୍ ତେଦା ।” ");
INSERT INTO kff_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ପିକିଡ଼୍ ଆସୁଙ୍ଗେ ତେଦ୍‍ଦି ତାଆକ ଉଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତେ । ଆସୁଙ୍ଗ୍ ତାନ୍ ବୟସ୍ ମାତର୍ ବାର ହେଣ୍ଡେକ୍ । ଇଦ୍ ଗଟ୍‍ନାତାଗ୍ ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","କିନ୍ତୁ ଇଦ୍ ବିଷୟ୍‍ତେ ବେନଙ୍କ୍ ବାତ୍‍ତେ କେତାନଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେଲ୍‍ମାଟ୍ ଇଞ୍ଜ କେତ୍‍ତନ୍ । ତାନ୍‍ପେର୍କେ ପିକ୍‍ତିଙ୍କ୍ ବାତ୍‍ତେ ତିନ୍ଦାଙ୍କ୍ ଇଦାନ୍‍ ସେଙ୍ଗେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଜିସୁ ଆଦ୍‍ ସହର୍ ୱିଡ଼୍‍ସି ଶିଷ୍ୟନଡ଼୍‍ତଡ଼୍ ନିଜେତ୍ ନାର୍ ନାଜରିତତା ମାଲ୍‍ସ୍ ଆତ୍‍ତଣ୍ତ । ");
INSERT INTO kff_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ଆଗେ ରମାନ୍‍ ଦିନେ ପ୍ରାର୍ତନା ଲୋତ୍‍ତାଆଗ୍ ଅଣ୍ଡ୍‌ ଉପଦେଶ୍‍ ହିଦାନ୍‍ ୱେଲେ ନାର୍ଗେ ନାରୁଡ଼୍ ମାତ୍‍ତଡ଼୍ । ଜିସୁନ୍ ଗଟି କେଞ୍ଜି ଅଡ଼୍‌ ବାକୁୱାଆସ୍ କେତ୍‍ତଡ଼୍, “ଇସର୍ ଗଟି ଅଣ୍ଡ୍‌ ବେଗାଙ୍କ୍ ପୁତ୍‍ତନ୍ ? ଇସର୍ ଜ୍ଞାନ୍ ଅଣ୍ଡ୍‌ ବେଗାଙ୍କ୍ ପୁତ୍‍ତନ୍ ? ଇୱୁସାରେ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ଅଣ୍ଡ୍‌ ବେଲାନ୍ ମାଡ଼ୁତନ୍ ? ");
INSERT INTO kff_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଇଣ୍ଡ୍‌ ବାତ୍‍ତେ ମରୀୟମ୍‍ ତେ ମାର୍‍, ଅଣ୍ଡ୍‌ କୁମାଲ୍ ଆୟନ୍ ? ଇଣ୍ଡ୍ ବାତ୍‍ତେ ଯାକୁବ୍, ଯୋସେପ୍, ଯିହୁଦାଲ୍ ନୁ ଶିମୋନ୍‍ତେ ଦାଦାଲ୍ ଆୟଣ୍ଡ୍ ? ତାନ୍ ଏଲାସ୍କ୍‌ ବାତ୍‍ତେ ମାନ୍‍ତଡ଼୍ ଇଗେ ମାନ୍‍ନ ?” ଇଦ୍ କେସ୍ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ଉଡ଼ି କାୱୁତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ତ, “ବାବବାଦୀ ନିଜେତ୍ ନାର୍‍, ପରିବାର୍ ନୁ ଆତ୍ମାତେ ସାରେତଡ଼୍‍କ୍ ୱିଡ଼୍‍ସି ବାଗାତ୍ ସାରେତଡ଼୍ ତ ସମ୍ମାନିତ ଆୟଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ଆଦିଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ରୋଗ୍‍ତେ ନାରୁଡ଼୍‍ ପରୁ କାଇ ୱାଟି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ାନାଦ୍ ୱିଡ଼୍‍ସି ଜିସୁ ଆଗେ ମେଣ୍ଡନ୍‍ ବାତ୍‍ତେ ବାକ୍‍ୱା କାମ୍ ମାଡ଼୍‍ଡ଼େ ପାର୍‍ୱଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଅଡ଼ାଦ୍‌ ଅବିଶ୍ୱାସୀ ଉଡ଼ି ଜିସୁ କାବା ଆତ୍‍ତଣ୍ତ୍‌ । ତାନ୍‍ପେର୍କେ ଜିସୁ ଗାର୍‍ରେ ମାନ୍ଦାନ୍ ନାର୍‍କିନାଗ୍ ଆଞ୍ଜ୍ ନାରୁଡ଼୍‍କ୍ ଶିକ୍ଷା ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ଅଣ୍ଡ୍‌ ବାର ଜାନ୍ ଶିଷ୍ୟଡ଼୍‌କ୍‌ କାର୍‍ଙ୍ଗି ଇର୍‍ୱୁ ଇର୍‍ୱୁଡ଼୍ ମାଡ଼ି ରତ୍‍ତନ୍ । ଅଶୁଚି ଆତ୍ମାଙ୍କ୍ ତଲାନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଦିକାର୍‌ ଇସ୍‍ କେତ୍‍ତଣ୍ତ୍‌, ");
INSERT INTO kff_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“ମିୟାଦ୍ ଆଦାନ୍‍ ସେଙ୍ଗେ ସୁଦୁର୍ ଡୁଡ୍‍ ଅଦେପାର୍‍ତିଡ଼୍‍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ରୂଟି ମାନ୍ଦାନ୍‍ ମୁନା କି ପାନ୍‌ଡ଼ତାଗ୍‍ ଡାବକ୍‍ ଅୟ୍‍ମାଟ୍‍ ଇଞ୍ଜ କେତ୍‍ତଡ଼୍‍ । ଇତ୍‍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଏର୍‍ପୁକ୍‍ କେର୍‍ଦାନଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‌ । ମେଣ୍ଡେ ରେଣ୍ଡ୍‍ ଚକା କେର୍‍ଦାନଙ୍କ୍ ମନା ମାଡ଼୍‍ତଣ୍ଡ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ତ୍‌, “ବେନ୍ ଲୋତ୍‍ତାଗ୍ ମିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗିତଡ଼୍, ଆଦ୍ ପଡ଼ିୟେତାଗାଙ୍କ୍ ପେଇସ୍‌ ଆନ୍‌ୱେ ଯାକ ଆଗେ ମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ଯଦି ବାତ୍‍ତେବା ପଡ଼ିୟେତାଗ୍ ନାରୁଙ୍କ୍ ମିକିଙ୍କ୍ କାର୍‍ଙ୍କ୍‍ଗଡ଼୍ ବା ମିଇ ଗଟି କେଞ୍ଜଡ଼୍, ମୀଇ ଡେକେତ୍ ଦୂମ୍ କାଇସ୍ ଆଦ୍ ପଡ଼ିୟେ ୱିଡ଼୍‍ସି ଆନୁଟ୍ । ଇଦ୍ ମିୟାଦ୍ ବିରୁଦ୍ଦ୍‌ତେ ସାକ୍ଷି ଲେକାମ୍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ତାନ୍‍ପେର୍କେ ଶିଷ୍ୟନଡ଼୍ ଆଞ୍ଜ୍ ପାପ୍ ଆର୍‍ଦାଗାଙ୍କ୍ ମାଲ୍‍ନ୍ଦାନ୍ ସେଙ୍ଗେ ନାରୁଡ଼୍‍କିଙ୍କ୍ ଉପଦେଶ୍ ଇତ୍‍ତଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ଅଡ଼୍‌ ନାର୍ଗେ ବୁତ୍‌କ୍ ୱିର୍‍ସ୍ପ୍‍ତଡ଼୍ ନୁ ରୋଗ୍‍ତେ ନାରୁଡ଼୍‍କ୍ ନିୟ୍‍ ତମି ସୁସ୍ଥ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଇଦ୍‍ ସାରେ ବିଷୟ୍‍ତେ ରାଜାଲ୍ ହେରଦ୍ କେଞ୍ଜ୍‍ତଣ୍ତ୍‌, ବାତେଙ୍କ୍‍ଇତ୍କେ ଜିସୁନାଦ୍ ସୁକାମ୍‍ ଦୁଃକାମ୍ ସାରେପାକ୍ ଆତ୍‍ତେ । ବେସ୍‍ତୁଡ଼୍ କେସମାତ୍‍ତଡ଼୍, “ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ମେଣ୍ଡେଜିୱେ ଆତ୍‍ତନ୍ । ଆଦିନ୍‌ସେଙ୍ଗେ ଇଦ୍‍ ସାରେ ବାକ୍‌ୱାକାମ୍ ମାଡ଼ାନଙ୍କ୍ ଅଣ୍ଡ୍‌ ଶକ୍ତି ଦର୍‍ସ୍‍ତଣ୍ଡ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ବାଗାତଡ଼୍ କେସ୍‍ମାତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ଏଲିୟ, ମେଣ୍ଡେ ବେସ୍‍ତୁଡ଼୍ କେତ୍‍ତଡ଼୍, ମୁନେତ୍‍ କାଲାମ୍‍ତେ ବାବବାଦୀ ନଡ଼୍‍ ଲେକାମ୍ ଅଣ୍ଡ୍‌ ମିକା ୱେରଣ୍ଡ୍ ବାବବାଦୀ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ହେରୋଦ ଜିସୁନ୍‍ ବିଷୟ୍‍ତେ କେଞ୍ଜି କେତ୍‍ତଣ୍ତ୍‌, “ଅଣ୍ଡ୍‌ ନିଜାମ୍ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ । ନାନେ ଅନାଦ୍‌ ତାଲେତିଙ୍କ୍ କଇସ୍‍ ମାତ୍‍ତାନ୍, କିନ୍ତୁ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ଗେଲ୍‍ସି ତେଦ୍‍ତଣ୍ଡ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ହେରଦ ନିଜେ ଯୋହନ୍‌‌ତିଙ୍କ୍ ଗିରପ୍‍ ମାଡ଼ାନଙ୍କ୍ ଆଦେଶ୍ ଇସ୍‍ମାତ୍‍ତନ୍ ନୁ ଯୋହନ୍‌ ବନ୍ଦି ଆସ୍ ଜଇଲ୍‍ତାଗ୍ ମାତ୍‍ତଣ୍ତ୍‌ । ହେରଦ୍ ନିଜେତ୍ ଦାଦାନ୍‌ ମୁତେଙ୍କ୍ ହେରଦ୍‍ତିଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ମାଡ଼ି ମାନ୍‍ନାଙ୍କ୍ ଯୋହନ୍‌ ");
INSERT INTO kff_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ଅଙ୍କ୍‌ ମେଣ୍ଡେ ପ୍ରମାନ୍ ମାଡ଼ି କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍‌, “ତାମୁଣ୍ଡ୍‌ ମୁତେଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ମାଡ଼ି ନିମେସାୟେତ୍‍ କାମ୍ ମାଡ଼୍‌ୱିନ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ଆଦିନ୍ ସେଙ୍ଗେ ହେରଦିଆ ଯୋହନ୍‌‌ତେ ସେଙ୍ଗେ କପାମ୍ ନେହେସ୍ ଅଙ୍କ୍‌ ଆୱୁକାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ମାତ୍‍ତନ୍, କିନ୍ତୁ ହେରଦ୍‍ତେ ସେଙ୍ଗେ ଇଦ୍ ମାଡ଼୍‍ଡ଼େ ପାର୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ବାତେଙ୍କ୍‍ଇତ୍କେ ଯୋହନ୍‌ ୱେରନ୍ ଦାର୍ମିକ୍ ନୁ ପବିତ୍ର ନାରୁନ୍ ଇଞ୍ଜ ପୁଞ୍ଜ୍ ହେରଦ୍ ଅଙ୍କ୍‌ ୱେର୍‍ସ ମାତ୍‍ତଣ୍ତ୍‌ ଅଂକିଙ୍କ୍‌ ଲେକେତ୍ ପଡ଼ିୟେ ତାଗ୍ ୱାଟିମାତ୍‍ତଣ୍ଡ୍‌ । ଯୋହନ୍‌‌ତେ ଶିକ୍ଷା କେଞ୍ଜି ସାରେଦିନା ଅଣ୍ଡ୍‌ କପାମ୍ ଆସ ମାତ୍‍କେ ମିକା ଅନ୍‌ ଗୋଟି କେଞ୍ଜାନଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଚ୍ଛା ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ଅଣ୍ଡ୍‌‍ଦାମ୍ ହେରୋଦିଆଙ୍କ୍‌ ୱେରଡ଼୍ ସୁଯୋଗ୍ ଦର୍‍କ୍‍ତେ । ହେରୋଦ୍‍ତ୍‍ତେ ଜନମ୍‍ଦିନେ ୱାତ୍‍ତେ, ତିଆର୍‍ଆତ୍‍ତେ ବୋଜିତିଙ୍କ୍ ବେଡ଼ିୟେ କର୍ମଚାରିଡ଼୍, ସେନାଦ୍ୟକ୍ଷ ନୁ ଗାଲିଲୀତେ ମାନ୍ଦାନ୍‍ ନାରୁଡ଼୍ କାର୍‍ଙ୍ଗ୍‍ତାଙ୍କ୍ ୱାସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ହେରୋଦ୍‍ତେ ପିକିଡ଼୍ ଇଦ୍ ଉତ୍ସବତାଗ୍ ହେନ୍ଦି ମିକା ହେରୋଦତେ କୁଟ୍‍ମାମ୍‍ ତିଙ୍କ୍ ୱେଡ଼୍‌କେ ମାଡ଼ିମାତ୍‍ତେ । ଆଦିଙ୍କ୍ ହେରୋଦ୍‍ ପିକ୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‌, “ନିମେ ବାତ୍‍ତେ ଇଚ୍ଛା ମାଡ଼ୁତିନ୍, ବାତ୍‍ତେ ତାଲ୍‍କିତିନ୍ ଆଦ୍ ନାନେ ଇଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ରାଜାଲ୍ ଗଟ୍‍ଇସ୍ କେତ୍‍ତଣ୍ଡ୍‌, “ନାନେ ପ୍ରାମାନ୍ ମାଡ଼ି କେତୁତାନ୍, ନିମେ ବାତ୍‍ତେ ତାଲ୍‍କିତିନ୍, ଇଦ୍‍ତାନ୍ ଇଦ୍‍ଲେକା‍ମ୍ ରାଜ୍ୟତାଗାଙ୍କ୍ ଦୁଡ଼େ ତାଲ୍‍କେ ମିକା ଇଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ପିକିଡ଼୍ ୟାୟନ୍ ପାକେ ଆଞ୍ଜ୍ କେତ୍‍ତେ, “ବାତ୍‍ତେ ତାଲ୍‍କିତାନ୍ ?” ସାଙ୍ଗେ ସାଙ୍ଗେ ହେରୋଦ୍‍ତେ ମୁତେ କେତ୍‍ତେ, “ବାପ୍ତିସ୍ମ ଯୋହନ୍‌‌ତେ ତାଲେ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ପିକିଡ଼୍ ମିରିୱାସ୍ ରାଜାଙ୍କ୍ କେତ୍‍ତେ, “ଇଞ୍ଜେକେ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌‌ତେ ତାଲ୍ ତାଲିତାଗ୍ ୱାଟି ନାକ୍‍ ଇମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ଇଦ୍ କେଞ୍ଜି ରାଜାଙ୍କ୍‍ ଗାଟି ଦୁଃକାମ୍‍ ଆତ୍‍ତେ, କିନ୍ତୁ କୁଟ୍‍ମାମ୍‍ତେ ମୁନେ ପ୍ରାମାନ୍ ମାଡ଼ିମାନ୍‍ନାଙ୍କ୍ ଇଲ୍‍ଲେ ଇଞ୍ଜ କେତ୍‍ତେ ପାର୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ଆଦିଙ୍କ୍ ଯୋହନ୍‌‌ତେ ତାଲେ କୟିସ୍‍ ତାତାନଙ୍କ୍ ରାଜାଲ୍‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଚାକର୍‍ନଡ଼୍‍କ୍ ରହତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଚାକର୍‍ନଡ଼୍ ଜଇଲ୍‍ତାଗ୍ ଆଞ୍ଜ୍ ଯୋହନ୍‌‌ତେ ତାଲ୍‍ଲେ କୟିତ୍‍ତଡ଼୍ ନୁ ତାଲ୍‍ଲେ ତିଙ୍କ୍ ତାଲିତାଗ୍ ୱାଟି ଆ ପିକ୍‍ତିଙ୍କ୍ ଇ‍ତ୍‍ତଡ଼୍ । ଆଦ୍ ଅସ୍ ୟାୟଙ୍କ୍ ଇତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟନଡ଼୍ କବର୍‍ କେଞ୍ଜି ଅନାଦ୍‌ ଡଲ୍‍ତେ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଅସ୍ ସମାଦି ଇସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍ ମାଲ୍‍ସ୍‍ ୱାସ୍ ବାତ୍ ବାତ୍ ଅଡ଼୍‌ ମାଡ଼ିମାତ୍‍ତଡ଼୍ ନୁ ଶିକ୍ଷା ଇସ୍‍ମାତ୍‍ତଡ଼୍, ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ଇସର୍ ନାରୁଡ଼୍‍ ମାନ୍ଦେତ୍‍ ଲୋପେ ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ତିନ୍ଦାନଙ୍କ୍ ଦିନାମ୍ ଦର୍‍କ୍‍ୱେ ମାତ୍‍ତେ । ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତନ୍, “ଦାଟିଟ୍, ମାନାଡ଼୍ ୱେରଡ଼୍ ବେନ ଇଲ୍‍ୱେ ଜାଗେତାଗ୍ ଆଦିକାଡ଼୍‍ । ଆଗେ ମିଡ଼୍ ସୁଦୁଟ୍ ଜେଲ୍ ରମେ ପାର୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ତାନ୍‍ପେର୍କେ ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ଓଡା ତାରି ୱେରଡ଼୍ ଚିମ୍ ଚାମ୍ ଜାଗେତାଗ୍ ଆଦାନଙ୍କ୍ ପେଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ଅଡ଼୍‌ ଆଦାନ୍‍ୱେଲେ ନାର୍ଗେ ନାରୁଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଡ଼େ ପାର୍‍ୱଡ଼୍‍ ଆତ୍‍ତଡ଼୍ । ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ବେନ୍‍ ବେନା ପଡ଼ିୟାନାଗାଙ୍କ୍ ପେଇସ୍ ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ବେନ୍‍ ଜାଗେତାଗ୍ ଆଞ୍ଜମାତ୍‍ତଡ଼୍, ମିରି ମିରି ଆଗେ ମୁନେ ଆଞ୍ଜ୍ ହେଉତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ଜିସୁ ଓଡେ ତାଗାଙ୍କ୍ ଡିଗି ଆଦ୍ ବେଡ଼୍‍ୟାଦ୍ ନାରୁଡ଼୍‍ ମାନ୍ଦେ ଉଡ଼ି ଅନାଦ୍‌ ହୃଦୟ ଦୟାତେ ନତ୍‍ତେ । ବାତେଙ୍କ୍‍ଇତ୍କେ ଅଡ଼୍‌‍ ମେୟ୍‍ତାନଣ୍ଡ୍‍ ଇଲ୍‍ୱେ ମେଣ୍ଢା ମାନ୍ଦେ ଲେକାମ୍ ମାତ୍‍ତଡ଼୍‌ । ଆଗେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନାର୍ଗେ ବିଷୟ୍‍ତେ ଶିକ୍ଷା ଇଦାଙ୍କ୍ ପସ୍ପତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ପଡ଼ଦ୍‍ ଆଦାନାଦ୍ ଉଡ଼ି, ଶିଷ୍ୟନଡ଼୍ ଜିସୁଙ୍କ୍ ୱାସ୍ କେତ୍‍ତଡ଼୍, “ନାର୍ଗେ ଗମାଡ଼୍ ଆସମିନ୍ଦେ ନୁ ଇଦ୍ ପଡ଼ିୟେ ଗାଟି ଚିମ୍‍ଚାମ୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ନାରୁଡ଼୍‍ ବେଲାନ୍ ଚାରେପାକା ଗୁଡ଼୍‍ଏକ୍‍ ବା ନାକିନାଗ୍ ଆଞ୍ଜ୍ ନିଜେ ନିଜେତ୍‌ ସେଙ୍ଗେ ତିନ୍ଦାନଙ୍କ୍ ବାତ୍‍ତେ ଆସିତଡ଼୍, ଆଦିନ୍‍ ସେଙ୍ଗେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରହସିମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‌, “ମିଡ଼୍‍ ନିଜେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାତ୍‍ତେ ତିନ୍ଦାନଙ୍କ୍ ଇମୁଟ୍ ।” ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍, “ନିମେ ବାତ୍‍ତେ ଇଚ୍ଛା ମାଡ଼ୁତିନ୍, ମାମେ ରେଣ୍ଡ୍‍ୱାନ୍ଦା ରୁପା ଡାଉକ୍‍ଙ୍କିନ୍‍ ତଡ଼୍ ରୋଟି ଆସି ତାସ୍ ଇଡ଼୍‍କିଙ୍କ୍ ଇଦିକାଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଜିସୁ ପଚାର୍‍ମାଡ଼୍‍ତଣ୍ଡ୍‌, “ମିଇପାକେ ବେସ୍‌କ୍ ରୋଟି ମିନ୍ଦେ, ଉଡ଼ି ୱାଡ଼ାଟ୍ ।” ଅଡ଼୍‌‍ ଉଡ଼ି ୱାସ୍ ମାତର୍‌ ଏଇଙ୍କ୍ ରୋଟି ନୁ ରେଣ୍ଡ୍ କିକେ ମିନ୍ଦେ ଇଞ୍ଜ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ନାରୁଡ଼୍‍କିଙ୍କ୍ ମାନ୍ଦା ମାନ୍ଦା ମାଡ଼ି ଗାଡ୍‍ତେ ପରୁ କୁସ୍ପାନଙ୍କ୍ ଜିସୁ ଶିଷ୍ୟନଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ଅନ୍‌‍ ଗଟ୍‍ତେ ଲେକାମ୍ ନାରୁଡ଼୍‍କିଙ୍କ୍ ଲାଇନ୍‍ତେ ଶହେ ବା ପଚାଶ୍ ଲାକା କୁସ୍ପ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ତାନ୍‍ପେର୍କେ ଜିସୁ ଆୱୁ ଏଇଙ୍କ୍ ରୋଟି ନୁ ରେଣ୍ଡ୍‍ କିକେ ଅସ୍ ସ୍ୱର୍ଗପାକେ ପରୁଉଡ଼ି ମିକା ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍ ଇତ୍‍ତଣ୍ଡ୍‌ । ମେଣ୍ଡେ ଆୱୁ ରୋଟିକିଙ୍କ୍ ଉସ୍‍ ନାରୁଡ଼୍ ପାକେ ସାରେତଡ଼୍‍କ୍ ତୁଉସିଦ୍‍ନଙ୍କ୍ ଶିଷ୍ୟନଡ଼୍‍କ୍ ଇତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ସାରେତଡ଼୍ ତିଞ୍ଜ୍ ଡଙ୍କ୍‍ ନିହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ତାନ୍‍ପେର୍କେ ଶିଷ୍ୟନଡ଼୍ ମିଗ୍ଲିମାନ୍ଦାନ୍ ରୋଟି ନୁ କିକେ ଦୁଡ଼ାକି ପେହେକି ବାରଟାନ୍ ଜୁଡ଼ିନାଗ୍ ନିହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ବେନଡ଼୍ ଆଦ୍ କାଦ୍ୟ ତିଞ୍ଜ୍‍ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ଆଗାଙ୍କ୍ ଆସାମ୍ ମାନେଇତେ ମାନ୍ଦେ ମାତ୍‍ତେ ଏଇଙ୍କ୍ ହଜାର୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ତାନ୍‍ପେର୍କେ ଜିସୁ ଶିଷ୍ୟନଡ଼୍‍କିଙ୍କ୍‌ ସମୁଦ୍ର ମେଣ୍ଡନ୍‍ ପାକେ ବେତ୍‌ସାଇଦାତା ଆଦାନ୍‍ ସେଙ୍ଗେ ମୁନେଙ୍କେ ଓଡେତାଗ୍ ରହସିତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ନାରୁଡ଼୍‍କିଙ୍କ୍ ରଅସିସ୍ ମିକା ଅଣ୍ଡ୍‌ ନିଜେ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍‍ ସେଙ୍ଗେ ୱେରଡ଼୍‍ ମେଟେତ୍‍ ପରୁ ଆତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ମୁଲ୍‍ପୁଟ୍ ଆସ ମାନ୍ଦାନ୍‍ ୱେଲେ ଜିସୁ ୱେରଣ୍ଡେ ଆଞ୍ଚିନା ବୂମ୍‌ତାଗ୍‍ ମାତ୍‍ତଣ୍ତ୍‌ ନୁ ଓଡେ ସାଉଡ଼େ ନାଡ଼୍‍ମେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ଅଡ଼୍‌‍ ମୁନେଙ୍କ୍ ଗାଲ୍‍ ୱାସମାନ୍‍ନାଙ୍କ୍ ଶିଷ୍ୟନଡ଼୍ ଗାଟି ତିପାଲ୍‍ତେ ଓଡେ କହସ ମାନ୍ଦାନାଦ୍ ଅଣ୍ଡ୍‌ ଉଡ଼୍‍ତଣ୍ଡ୍‌ । ଆଙ୍କାଡ଼୍‍ତେ ନାର୍କା ୩ ଟା ତାଗାଙ୍କ୍ ୬ ଟା ଆଇନା ");
INSERT INTO kff_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ଜିସୁ ଏର୍‍ଦେ ପରୁ ତାକିତାକି ଅଡ଼୍‌‍ପାକେ ଗାର୍ରେ ହେଉତ୍‍ତଣ୍ଡ୍‌ । ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହେରି ମିକା ଅଣ୍ଡ୍‌ ଆନେନ୍ । କିନ୍ତୁ ଅଙ୍କ୍‌ ଏର୍‍ଦେ ପରୁ ତାକାନାଦ୍ ଉଡ଼ି ଶିଷ୍ୟନଡ଼୍ ବୁତ୍‍ ଆଲ୍‍ସି ମର୍‍ପଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ଅଙ୍କ୍‌ ଉଡ଼ି ଅଡ଼୍‌ ୱେର୍‍ସ୍‍ ମାତ୍‍ତଡ଼୍ । ତାନ୍‍ ପେର୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‌, “ସାହାସ୍ ପୟିମ୍ ଇଣ୍ଡ୍ ନାନେ, ୱେର୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଆଦ୍ କେସ୍ ଓଡେତାଗ୍ ତାର୍‍ତନ୍ ନୁ ଆସୁଙ୍ଗେ ଗାଲ୍‍ ମାଦ୍‍ତେ । ଶିଷ୍ୟନଡ଼୍ ଆଦ୍‍ଉଡ଼ି ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ବେଦିନ୍ ଏଇଙ୍କ୍ ରୋଟି ଗଟ୍‍ଣାତେ କାମ୍ ଅଡ଼୍‌ ପୁନ୍‍ୱେ ମାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍‍ଇତ୍କେ ଅଡ଼ାଦ୍‌‍ ଜ୍ଞାନ୍ ଶକ୍ତି ଇଲ୍‍ୱେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ସମୁଦ୍ରତିଙ୍କ୍ ହେରି ମିକା ଅଡ଼୍‌ ଗିନେସର୍‍ତାଗ୍ ହେୱୁସ୍ ଆଞ୍ଚିନ୍‍ ବୂମ୍‌ତାଗ୍‍ ଓଡେତିଙ୍କ୍ ତହସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ଅଡ଼୍‌‍ ଓଡେତାଗାଙ୍କ୍ ଡିଗାନ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ନାରୁଡ଼୍‍ ଜିସୁଙ୍କ୍ ହେଞ୍ଚତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ଆଦିଙ୍କ୍ ମିରିଆଞ୍ଜ୍ ଆଦ୍ ଗାର୍ରେ ନାର୍‍କିନାଗ୍ ମାନ୍ଦାନ୍ ନାର୍ଗେ ହେଣ୍ଡ୍‍କିନ୍ ରୋଗିନଡ଼୍‍କ୍ ଅନ୍‌‍ ପାକେ କାଞ୍ଜି ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଜିସୁ ବେନ୍ ନାର୍, ସହର୍ ନୁ ସୁଦୁଗୁଡ଼ିୟେ ନାକିନାଗ୍ ହେଉତ୍‍ତନ୍, ଆଗେ ଆଟ୍ ବାଜାର୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଲେକାମ୍‍ ରୋଗ୍‍ତେ ନଡ଼୍‍କିଙ୍କ୍ ୱାଟ୍‍ତଡ଼୍‍ ଅନ୍‌ ଚକାତିଙ୍କ୍ ଇଟାନଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଗଟ୍ ତାଲ୍‍କ୍‍ତଡ଼୍ ନୁ ଅନ୍‌ ସିଲେତ୍ କଙ୍ଗିଙ୍କ୍ ଇଟାନ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ରୋଗିନଡ଼୍ ସୁସ୍ଥ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ଯିରୁଶାଲାମ୍‍ ତାଗାଙ୍କ୍ ୱାସ୍‍ମାନ୍ଦାନ୍‍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ପାରୂଶୀଡ଼୍ ନୁ ଶାସ୍ତ୍ରିଡ଼୍‍ ଜିସୁନ୍ ଗାର୍‍ରେ ଗୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ଅଡ଼୍‌‍ ଉଡ଼୍‌ତଡ଼୍‍ ଯେ, ଜିସୁନ୍‍ ବେସ୍‍କ୍‍ତଡ଼୍ ଶିଷ୍ୟଡ଼୍ ନିୟମ୍ ଲେକାମ୍‌ କାଇକ୍‍ ନର୍ସ୍ ତିନଡ଼୍‍ । ଫାରୁଶିଡ଼୍‍ ତିନ୍ଦାନ୍‍ ମୁନେ କାଇ ନର୍‍ଦାନ୍‍ ମାଇଦିଙ୍କ୍‍ ବେନ୍‍ ନିୟମ୍‍ ସାରେ ମାଡ଼ିମାତ୍‍ତଡ଼୍‍, ଶିଷ୍ୟଡ଼୍ ଆଦିଙ୍କ୍‍ ପାଲନ୍‍ ମାଡ଼କଟ ମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ଫାରୁଶିଡ଼୍‍ ନୁ ବାଗାତ୍ ଯିହୁଦିଡ଼୍‍ ଅଡ଼୍‌‍ ମୁନେଙ୍କ୍‍ ତେ ଆନିଦାଦିଡ଼୍‍ ନିତିନିୟମ୍‍ ପାଲନ୍‍ ମାଡ଼ାନଡ଼୍‍, ନିୟମ୍‍ ତେ କାଇ ନର୍‍ୱକଟ ଅଡ଼୍‌‍ ତିନ୍‍ନଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ଆଟି ନାଗାଙ୍କ୍‍ ମାଲ୍‍ତେ ୱେୟେ ମୁନେଙ୍କେତେ ନିୟମ୍‍ ଲେକାମ୍ ଡେକା କାଇକ୍‍ ନର୍‍ୱକଟ ବାତ୍‍ ବା ତିନ୍‍ଅଡ଼୍‌‍ । ୱେଡ଼୍‍ତ୍‍ତେ, ଗିନେ, କୁଣ୍ଡା ନୁ ତାରାନାୱ୍‍ ଆକି ନର୍‍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ବେସ୍‍ ବେସତ୍ ତିଆର୍‍ ଆତ୍‍ତେ ନିୟମ୍‍ ଅଡ଼୍‌‍ ପାଲନ୍‍ ମାଡ଼ିତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ପାରୁଶୀଡ଼୍‍ ନୁ ଶାସ୍ତ୍ରୀଡ଼୍‍ ଜିସୁଙ୍କ୍ ପାଚାରା ମାଡ଼୍‍ତଡ଼୍‍, “ମାନ୍‍ ମୁନେଙ୍କ୍‍ତେ ଆନିଦାଦିଡ଼୍‍ ବେନ୍‍ସାରେ ନିତିନିୟମ୍‍ ତିଆର୍‍ ମାଡ଼ିସ୍‍ ଆଞ୍ଜ୍‍ମିନ୍ଦେଡ଼୍‍, ନି ଶିଷ୍ୟଡ଼୍ ଆଦିଙ୍କ୍ ପାଲନ୍‍ ମାଡ଼ଡ଼୍‍ ବାତେଙ୍କ୍‍ ? ନିୟମ୍‍ ଲେକାମ୍ ତିନ୍ଦାନ୍‍ ମୁନେଙ୍କ୍ କାଇକ୍‍ ନର୍‍ୱଡ଼୍‍ ବାତେଙ୍କ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‍ତଣ୍ଡ୍, “ମି ବିଷୟ୍‍ତେ ବାବବାଦି ଯିଶାଇୟ ବାତେ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍‍ ନିଜାମ୍ । ଅନ୍‌‍ ଲେକ୍‌ତେ ଲେକାମ୍‌ ମିଡ଼୍‍ ସାରେ ବୁଚା ମାଡ଼ାନ୍ ଦାର୍ମିକ୍‍ନଡ଼ି । ଇଶ୍ୱର କେତ୍‍ତଣ୍ଡ୍, ‘ଇ ନାରୁଡ଼୍‍, ମାତର୍‍ ମକମ୍‍ତାଗ୍‍ ନାକିଙ୍କ୍ ସମ୍ମାନ୍‍ ଇଦ୍‍ତଡ଼୍‍, କିନ୍ତୁ ହୃଦୟ୍‍ ତାୟାଗାଙ୍କ୍ ନାର୍ଗେ ଦୁରାମ୍‍ ।’ ");
INSERT INTO kff_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ନାକିଙ୍କ୍ ଆରାଦନା ମାଡ଼ାନାଦ୍‍ ଅଡ଼ାଦ୍‌‍ ଇଲେ । ବାତେଙ୍କ୍‍ଇତ୍କେ ଅଡ଼୍‌‍ ନାରୁଡ଼୍‍ ମାଡ଼ିମାନ୍ଦାନ୍‍ ନିୟମ୍‍ତିଙ୍କ୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ମିଡ଼୍ ଇଶ୍ୱର୍‌ତେ ନିୟମ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି, ନାରୁଡ଼ାଦ୍ ନିୟମ୍‍ତିଙ୍କ୍ ପାଲନ୍ ମାଡ଼ିତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଜିସୁ ମେଣ୍ଡନ୍‍ଦାମ୍‍ କେତ୍‍ତଣ୍ଡ୍, ଇଶ୍ୱର୍‌ତେ ନିୟମ୍‍ତିଙ୍କ୍ କେପି ନିଜର୍‍ ଶିକ୍ଷାତିଙ୍କ୍‍ ପୟ୍‍ସ୍‍ ନେହ୍‍ତାନ୍‍ ମାଇଦିଙ୍କ୍ ମିଡ଼୍‍ ଲେକେତ୍‍ ଉପାୟ୍‍ ମାଡ଼ିମିନ୍ଦେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ମୋଶାଲ୍‌‍ ଆଜ୍ଞା ଇସ୍‌‍ମାତ୍‍ତଣ୍ଡ୍, ୟାୟ୍‍ବାବାଙ୍କ୍‍ ସମାଦର୍‍ ମାଡ଼ାଟ୍‍; ମେଣ୍ଡେ ବେନ ନିଜର୍‍ ୟାୟବାବାଙ୍କ୍‍ ଅବିସାପ୍‍ ଇତ୍‍ତଣ୍ଡ୍, ଅଙ୍କ୍‌ ଡଲାନ୍‍ ଦଣ୍ଡ୍‍ ଦର୍‍କିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମି ପାକେ ବାତ୍‍ତେ ମିନ୍ଦେ ଆଦ୍ ୟାୟବାବାଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାନାଦ୍‍, ଇଦ୍‍ରକମ୍ ଶିକ୍ଷା ଇଦ୍‍ତଣ୍ଡ୍, କିନ୍ତୁ ମିଡ଼୍ ବାତ୍‍ କେତୁତିଡ଼୍ ଆଦ୍‍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ “କୁର୍ବାନ୍,” ମାଡ଼ାଟ୍, ଇଦିନ୍‍ ଅର୍ତ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଇମୁଟ୍‍, ");
INSERT INTO kff_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ୟାୟ୍‍ବାବାଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାନ୍‍ ଦାୟିତ୍ୟତାଗାଙ୍କ୍ ମୁକ୍ତ ଆଦ୍‍ତିଡ଼୍‍, ");
INSERT INTO kff_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଇଦ୍‍ଲେକାମ୍‍ ୱେର୍‍ ଅର୍‌ତୁଙ୍କ୍‌ ଇଦାନାଦ୍‌ ମିୟାଦ୍‍ ଶିକ୍ଷା ଇଶ୍ୱର୍‌ତେ ଆଜ୍ଞାତିଙ୍କ୍ ଫାଲନ୍‌ ମାଡ଼ୁତ୍‍ । ହିଦ୍‍ଲେକାମ୍‍ ମେଣ୍ଡେ ନାର୍ଗେ ପାଡ଼୍‍ୟି ମିଡ଼୍‍ ମାଡ଼ୁତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଜିସୁ ମେଣ୍ଡନ୍‍ଦାମ୍‍ ନାରୁଡ଼୍‍କିଙ୍କ୍‍ କାର୍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, “ନା ଗଟ୍‍ ମନ୍‍ଇସ୍‌‍ କେଞ୍ଜାଟ୍‍ ନୁ ବୁଜେମ୍‍ ଆଦାଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼ାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ବାୟ୍‍ଦେତ୍‍ ବାତ୍‍ ବିଷୟ୍‍ ନେଙ୍ଗି ଅଂକିଙ୍କ୍‌ ଅପବିତ୍ର ମାଡ଼୍‍ପାର୍‍ୱ । ବରଂ ବେନ୍‍ ବିଷୟ୍‍ ନାରୁତେ ଲୋପେଙ୍କ୍ ବାୟ୍‍ଦେ ପେୟ୍‍ତିତ୍‍, ଆଦେ କେ ଅଂକିଙ୍କ୍‌ ଅପବିତ୍ର ମାଡ଼ିତ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ଯଦି ବେନନାଦ୍ କେଞ୍ଜାନଙ୍କ୍ କେଉ ମିନ୍ଦେ ଅଣ୍ଡ୍‌ କେଞ୍ଜିଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଜିସୁ ମୁଲ୍‍ଦେ ଲୋପେଙ୍କ୍ ୱାସ୍‍ ଲୋନ୍‌‍ ନେଙ୍ଗ୍‍ତେ ପେର୍କେ, ଅନାଦ୍‌‍ ଇ ଶିକ୍ଷାତିଙ୍କ୍‍ ବୁଜାମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ଶିଷ୍ୟଡ଼୍ ଜିସୁଙ୍କ୍‍ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ୱେର୍‍ତଡ଼୍‍ ଲେକାମ୍‍ ମିଡ଼୍‍ ଆନ୍‌ତେ ବୁଜେମ୍‍ ଆଦାନ୍‍ ଶକ୍ତି ବାତେ ଇଚୁର୍‌ ? ଇସର୍‍ତିଙ୍କ୍ ବୁଜେମ୍‍ ଆଦାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍‍ ? ବାତା ସାରେ ନାରୁନ୍‍ ମେନ୍ଦୁଲ୍‍ତେ ବାୟ୍‍ଦେକଞ୍ଚ୍‍ ଲୋପ୍‍ ନେଙ୍ଗିତା, ଆୱ୍‍ ଅଂକିଙ୍କ୍‌ ଅପବିତ୍ର ମାଡ଼୍‍ପାର୍‍ୱ ");
INSERT INTO kff_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ବାତେଙ୍କ୍‍ଇତ୍କେ ଆଦ୍‍ ହୃଦୟ୍‍ତାଗ୍‍ ନେଙ୍ଗକଟ ଲୋପେ ଆଦ୍‍ତେ ନୁ ତାନ୍‍ପେର୍କେ ମେନ୍ଦୁଲ୍‍ ତାଗାଙ୍କ୍ ପେଇସ୍‍ ଆଦ୍‍ତେ । ଇଦ୍‍ କେତାନ୍‍ ଲେକାମ୍‍ ସାରେ କାଦି ସୁଚ୍ଛି ଇଞ୍ଜ ଜିସୁ କେସିସ୍‍ ମାତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଅଣ୍ଡ୍‌ ମେଣ୍ଡ୍ କେତ୍‍ତଣ୍ଡ୍, ବାତା ସାରେ ନାରୁନ୍‍ ଲୋପେତାଗାଙ୍କ୍‍ ପେୟ୍‍ତିତା, ଆଦେ କେ ଅଂକିଙ୍କ୍‌ ଅପବିତ୍ର ମାଡ଼ିତେ, ");
INSERT INTO kff_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ବାତେଙ୍କ୍‍ଇତ୍କେ ଅନାଦ୍‌‍ ହୃଦୟ୍‍ତାଗାଙ୍କ୍ ପେୟ୍‍ତିତ୍‍ କାରାପ୍‍ ଚିନ୍ତେତ୍‍ ତଡ଼୍‍ ଅଣ୍ଡ୍‌ ବେସ୍‍ ବେସତ୍‍ ନିୟମ୍‍ତାଗ୍‍ ଇଲ୍‍ୱେ ଲେକେତ୍‍ ପାଡ଼୍‍ୟି ମାଡ଼ିତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ଇତ୍କେ ଡଙ୍ଗାନାଦ୍‍, ନାରିଙ୍କ୍ ଆୱ୍‍କାନାଦ୍‍, ଆର୍‍ଲା ମାଡ଼ାନାଦ୍, ଆଶେ ନୁ ବେସ୍‍ ବେସତ୍‍ କାରାପ୍‍ କାମ୍‍, କାରାପ୍‍ ବ୍ୟବହାର୍‍, କପାମ୍‍, ଆଙ୍କାର୍‍ ନୁ ମୁର୍କ । ");
INSERT INTO kff_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଇୱୁ ସାରେ କାରାପ୍‍ ବିଷୟ୍‍ ନାରୁନ୍‍ତେ ହୃଦୟ୍‍ତାଗାଙ୍କ୍‍ ଜନମ୍‌ ଆସ୍ ଅଂକିଙ୍କ୍‌ କାରାପ୍ ମାଡ଼ିତେ । ");
INSERT INTO kff_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ତାନ୍‍ପେର୍କେ ଜିସୁ ଆଦ୍‍ ପଡ଼୍‍ୟି ୱିଡ଼୍‍ସି ଶହର୍‍ ଗାରେମାନ୍ଦାନ୍ ଅଞ୍ଚଲତାଗ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ଆଗେ ଅଣ୍ଡ୍‌ ୱେରଡ଼୍‍ ଲୋନ୍‌‍ ନେଙ୍ଗି ପୁନ୍‍ୱେକଟ ମାନ୍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଣ୍ଡ୍, କିନ୍ତୁ ଅଣ୍ଡ୍‌ ଲୋପେ ମାନ୍ଦ୍‍ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ୱେର୍‌ଡ଼୍‌ ନାଟାଡ଼୍‍ତେ ମାୟାଡ଼୍‍ତିଙ୍କ୍ ବୁତ୍‌ ପୟିସ୍‍ ମାତ୍‍ତେ । ଜିସୁନ୍‍ ୱାଦାନ୍‍ ଗଟ୍‍ କେଞ୍ଜି ଆଦ୍‍ ଅନ୍‌‍ଗାରେ ୱାସ୍‍ ଅନ୍‌‍ ଡେକେତ୍‍ ମଦଲ୍‍ ରାଲ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ଆଦ୍‍ ମାତ୍‍ତେ ସୁରପୈନିକି ଅଞ୍ଚଲ୍‍ତେ ଗ୍ରୀକ୍ ଅଣଇହୁଦିଲ୍‌ । ତାନ୍‍ ମାୟାଡ଼୍‍ ତାଗାଙ୍କ୍‍ ବୁତ୍‌ ୱିଡ଼୍‍ସ୍‍ପାନ୍‍ ମାଇଦିଙ୍କ୍ ଆଦ୍‍ ଜିସୁଙ୍କ୍ କେତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","କିନ୍ତୁ ଜିସୁ ଉତ୍ତର୍‍ ହିତ୍‍ତଣ୍ଡ୍, ନିଜର୍‍ ପିଲାଙ୍କ୍ ମୁନେଙ୍କ୍ ତିହିତ୍‍ ୱେୟ୍‍ତିତ୍‍ । ପିଲାନ୍‍ କାଦି ଅସ୍‍ ନେୟ୍‍କିନ୍‍ ମୁନେ ୱାଟିଦାନାଦ୍‍ ସାୟେ ଆୟ । ");
INSERT INTO kff_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ନାଟାଡ଼୍‍ କେତ୍‍ତେ, ଆଜ୍ଞା, ନେୟ୍‍କ୍‍ ଟେବୁଲ୍‍ତେ ମଦଲ୍‍ ମାଞ୍ଜ୍ ପିଲାନ୍‍ ଏଙ୍ଗୁଲ୍‍ତିଙ୍କ୍ ତିନ୍ତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ଜିସୁ ତାଙ୍କ୍‍କିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନିଜାମ୍‍ ଗଟ୍‍, ଇଞ୍ଜେକେ ଲୋନ୍‌‍ ମାଲ୍‍ସ୍‍ ଆଞ୍ଜ୍‍ ଉଡ଼େ, ନି ମାୟାଡ଼୍‍ ତାଗାଙ୍କ୍‍ ବୁତ୍‌ ୱିଡ଼୍‍ସି ଆଞ୍ଜ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ନାଟାଡ଼୍‍ ଲୋନ୍‌‍ ମାଲ୍‍ସ୍‍ ଆଞ୍ଜ୍ ଉଡ଼୍‍ତେ ଯେ, ତାନ୍‍ ମାୟାଡ଼୍‍ କେତିତାଗ୍‍ ପାଟିମିନ୍ଦେ ନୁ ନିଜାମ୍‍ ବୁତ୍‌ ତାଙ୍କ୍‍କିଙ୍କ୍ ୱିଡ଼୍‍ସି ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ତାନ୍‍ ପେର୍କେ ଜିସୁ ସୋର ଅଞ୍ଚଲତାଗାଙ୍କ୍ ସିଦନ୍‍ତାଗ୍‍ ଆଞ୍ଜ୍‍ ଆଗାକଞ୍ଚ୍‍ ଦେକାପଲୀ ପ୍ରଦେଶ ଲୋପେଙ୍କ୍‍ ଇସ୍‌‍ ଗାଲିଲୀ ଆଞ୍ଚିନାଗ୍‍ ୱାସ୍‍ ହେୱ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଆଗାକଞ୍ଚ୍‍ ବେସ୍‍କ୍‍ତଡ଼୍ ନାରୁଡ଼୍‍ ୱେରଙ୍କ୍‌ ବୟ୍‍ରାଙ୍କ୍ ଜିସୁନ୍‍ ଗାରେ ତାତ୍‍ତଡ଼୍‍ । ଅଣ୍ଡ୍‌ ଲେକେତ୍‍ ଗଟି ତିର୍‍ୟେ ପାର୍‍ୱକଟ ମାତ୍‍ତଣ୍ଡ୍ । ଅନ୍‌‍ ପର କାଇ ୱାଟାନ୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌‍ ଜିସୁ ଅନୁରଦ୍‌‌ ମାଡ଼୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜିସୁ ଅଂକିଙ୍କ୍‌ ୱେର୍‌ଙ୍କେ ନାରୁଡ଼୍‍ ଲୋପେଙ୍କ୍‍ ସୁଦୁର୍‍ ଦୁରାମ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ କେୱ୍‍ଦାଗ୍‍ ୱାଡ଼୍‍ଞ୍ଜ୍‍ ଆଦ୍‍ପି, ଉଚି ଅନ୍‌‍ ୱାଞ୍ଜେର୍‍ତିଙ୍କ୍ ହିଟ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ତାନ୍‍ପେର୍କେ ସ୍ୱର୍ଗତ୍‍ପାକେ ପର୍‍ଉଡ଼ି, ଗାଟିନେସ୍‍କି କେତ୍‍ତଣ୍ଡ୍ “ଇପ୍‍ପତଃ !” ଅର୍ତ ଲେଙ୍ଗା । ");
INSERT INTO kff_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ସାଙ୍ଗେ ସାଙ୍ଗେ ନାରୁଣ୍ଡ୍ କେଞ୍ଜାନ୍‍ ଶକ୍ତି ପାଏମ୍‍ ଆତ୍‍ତଣ୍ଡ୍, ଅନାଦ୍‌‍ କନ୍ଦାଲ୍‍ ବନ୍ଦନ୍‍ ଦୁର୍‍ ଆତ୍‍ତେ ନୁ ଅଣ୍ଡ୍‌ ଇଞ୍ଜ୍‍ ଲେକେତ୍‍ ଗଟି ତିର୍‍ୟେ ପାର୍‍ଦୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଇ ଗଟନା ବିଷୟ୍‍ତେ ୱେର୍‍ତଡ଼୍‍କିଙ୍କ୍‍ ବାତେ ବା କେଲ୍‍ମାଟ୍‍ ଇଞ୍ଜ ଜିସୁ ନାରୁଡ଼୍‍କ୍‍ ଆଦେଶ୍‍ ହିତ୍‍ତଣ୍ଡ୍ । କିନ୍ତୁ ଜିସୁ ବେସର୍‍ ମନା ମାଡ଼୍‍ତଣ୍ଡ୍‍, ନାରୁଡ଼୍‍ ଆସର୍‍ କେସ ଉଡ଼୍‌ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ବେନଡ଼୍‍ ଇ ସାରେ ଗଟି କେଞ୍ଜ୍‍ତଡ଼୍‍, ଅଡ଼୍‌‍ କାବା ଆସ୍‍ କେତ୍‍ତଡ଼୍‍, ଅଣ୍ଡ୍‌ ବେସର୍‍ ଚମତ୍କାର୍‍ତେ ପାଡ଼୍‍ୟି ମାଡ଼ୁତଣ୍ଡ୍, ବୟ୍‍ରାଙ୍କ୍‍ କେଞ୍ଜାନ୍‍ ଶକ୍ତି, କନ୍ଦାଙ୍କ୍‍ ତିର୍‍ୟାନ୍‍ ଶକ୍ତି ଇସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ଆ ବେସ୍‌କ୍ ଦିନାତେ ପେର୍କେ ଅଣ୍ଡ୍‌‍ଦାମ୍‍ ନାର୍ଗେ ନାରୁଡ଼୍‍ ଜିସୁନ୍‍ ଗାରେ ଗୁଡ଼ିମାତ୍‍ତଡ଼୍‍ । ବେସୁଙ୍କ୍‍ ଅଡ଼ାଦ୍‌‍ କାଦି ତେର୍‍ତେ, ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","ଇ ନାରୁଡ଼୍‍ ମୁଣ୍ଡ୍‍ଦିନା ଆତ୍‍ତେ ନା ଗାରେ ମିନ୍ଦେଡ଼୍‍ ଇଞ୍ଜେ । ଅଡ଼୍‌‍ କାୟ୍‍ଦେ ତିନ୍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ବାତା ଇଲ୍‍ୱାଙ୍କ୍‍ ନାକିଙ୍କ୍‍ ଦୁଃକାମ୍‌ ୱେସୁତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ତିୱ୍‌କଟ ୱିଡ଼୍‍ସିତ୍‍କେ, ମାଲ୍‍ସ୍‍ ଆଦାନ୍‍ ୱେଲେ ଅଡ଼୍‌‍ ଆଇଦ୍‌ତଡ଼୍‍ । ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତଡ଼୍ ନାର୍ଗେ ଦୁରାକଞ୍ଚ୍‍ ୱାସ୍‍ମିନ୍ଦେଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ଶିଷ୍ୟଡ଼୍ ପାଚ୍ରାରା ମାଡ଼୍‍ତଡ଼୍‍, ଇଗ୍‍ ବାତ୍‍ଇଲ୍‍ୱେ ଜାଗାତାଗ୍‍ ଇସର୍‍ ନାରୁଡ଼୍‍କିଙ୍କ୍ ତିନ୍ଦାନ୍‌ ମାଇଦିଙ୍କ୍ ମାମ୍‍ ବେଗାକଞ୍ଚ୍ କାଦି ଯୋଗାଡ଼୍‍ ମାଡ଼୍‍ପାର୍‍ଦ୍‍ ତମ୍‍ ? ");
INSERT INTO kff_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ଜିସୁ ପାଚ୍ରାରା ମାଡ଼୍‍ତଣ୍ଡ୍, ମି ଗାରେ ବେସ୍‌କ୍ ରୂଟି ମିନ୍ଦେ ? ");
INSERT INTO kff_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ମାତର୍‍ ସାତ୍‍ଟାନେ ଇଞ୍ଜ ଅଡ଼୍‌‍ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌ । ଜିସୁ ନାରୁଡ଼୍‍କିଙ୍କ୍‍ ନେଲ୍‍ କୁଦାନ୍‍ ମାଇଦିଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍ । ତାନ୍‍ପେର୍କେ ଆ ସାତ୍‍ଟାନ୍‍ ରୂଟିଙ୍କ୍ ଅସ୍‍ ଜିସୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍‍ ଇତ୍‌ତଣ୍ଡ୍‌ ନୁ ଆୱିଙ୍କ୍ ଉୱୁସ୍‍ ନାରୁଡ଼୍‍ ଲୋପେ ତୁସାନ୍‍ ମାଇଦିଙ୍କ୍ ଶିଷ୍ୟଡ଼୍ କାଇଦେ ଇତ୍‌ତଣ୍ଡ୍‌‍ । ଶିଷ୍ୟଡ଼୍ ଆୱିଙ୍କ୍ ତୁସ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ଅଡ଼୍‌‍ ଗାରେ ବେସ୍‌କ୍ ସୁଦୁରାୱ୍‍ କିକେ ଆନ୍‌ତେ ମାତ୍‍ତା । ଆଦିନ୍‍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତିଙ୍କ୍‍ ଅଣ୍ଡ୍‌‍ ମେଣ୍ଡ୍‍ନ୍‍ ଦାମ୍‍ ଦନ୍ୟବାଦ୍‌ ଇସ୍ ଆୱିଙ୍କ୍‍ ତୁଉସାନ୍‌‍ ମାଇଦିଙ୍କ୍‍ ଶିଷ୍ୟଡ଼୍‍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ସାରେ ତଡ଼୍‍ ନାର୍ଗେ ତିଞ୍ଜ୍ ପାଞ୍ଚ୍‍ତଡ଼୍‍ । ମିଗିଲ୍‍ତାୱୁ ରୂଟି ସାତ୍‍ଟାନ୍‍ ଜୁଡ଼ିନାଗ୍‍ ପେଏକି ନେଏତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ନାଲୁ ହଜାର୍‍ ନାରୁଡ଼୍‍ ଇ କାଦି ତିଞ୍ଜ୍‍ମାତ୍‍ତଡ଼୍‍ ନୁ ମିଗ୍‍ଲି ରାଲି ମାନ୍ଦାନ୍‍ ଉର୍‍ଙ୍ଗ୍‍ତାଉ ରୂଟିକିଙ୍କ୍ ଶିଷ୍ୟଡ଼୍ ପେହେକି ସାତ୍‍ଟାନ୍‍ ଜୁଡ଼ି ନିଃହ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ତାନ୍‍ପେର୍କେ ଜିସୁ ନାରୁଡ଼୍‍କିଙ୍କ୍ ରହ୍‍ସିସ୍‌ ଶିଷ୍ୟଡ଼୍ ତ ଓଡ୍‍ତାଗେ ତାରି ଦଲ୍‍ମନୁତା ନାର୍‍ଦା ଆତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ଅଣ୍ଡ୍‌ ଦିନେ ବେସ୍‍କ୍‍ତଡ଼୍ ଫାରୁଶିଡ଼୍‍ ଜିସୁନ୍‍ ଗାରେୱାସ୍‍ ଅନ୍‌‍ ତଡ଼୍‍ ରାମ୍‍କ୍ ମାଡ଼ାଙ୍କ୍‍ ପସ୍‍ପ୍‍ତଡ଼୍‍ । ଜିସୁନ୍‍ ଦୋଷତିଙ୍କ୍ ପୟ୍‍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଉଡ଼୍‍ୟ୍‍ ୱାଟି ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍‍ ଅଣ୍ଡୟ୍‌ ଆଶର୍ଯ୍ୟ ପାଡ଼ିୟ୍‍ ମାଡ଼ି ଅଣ୍ଡ୍‌ ପ୍ରମାଣ୍ ମାଡ଼ିଣ୍ଡ୍ ଯେ, ଅନ୍‌‍ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତେ ଶକ୍ତି ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ଜିସୁ ଗାଟି ନେସ୍‍କି କେତ୍‍ତଣ୍ଡ୍, “ଇ ଯୁଗ୍‍ତେ ନାରୁଡ଼୍‍, ବାକ୍‍ୱା ପାଡ଼ିୟ୍‍ ଉଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ବାତେଙ୍କ୍‍ ଇସର୍‍ ଦାନ୍ଦେ ? ନାନ୍‍ ମିକିଂଙ୍କ୍‍ ସତ୍‍ କେସ୍‍ ନେହ୍‍ତୁତାନ୍‍, ଇ ଲେକେତ୍‍ ପ୍ରମାଣ୍ ଇ ନାରୁଡ଼୍‍କ୍‍ ଇଦାନାଦ୍‍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ଇଲା କେସ୍‍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ୱିଡ଼୍‍ସି ଓଡ୍‍ତାଗ୍‍ ମାଲ୍‍ସ୍‍ ୱାତ୍‍ତଣ୍ଡ୍ ନୁ ମାଡ଼୍‍ଗିନ୍‍ ଆପ୍‍ପାକା ଆତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ଅଣ୍ଡ୍‌‍ଦିନେ ଶିଷ୍ୟଡ଼୍ ରୂଟି ଅଦାନଙ୍କ୍‍ ମାର୍ଙ୍ଗି ମାତ୍‍ତଡ଼୍‍ । ଅଡ଼୍‌‍ ଗାରେ ମାତର୍‍ ଅଣ୍ଡୟ୍‌‍ ରୂଟି ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସତର୍କ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, “ସାବଦାନ୍‍, ଫାରୁଶିଡ଼୍‍ ନୁ ହେରଦ୍‍ତେ ପାଣ୍ଡୁମ୍‍ତାଗାଙ୍କ୍‍ ସତର୍କ ମାନୁଟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ଶିଷ୍ୟଡ଼୍ ଇ ବିଷୟ୍‍ତେ ନିଜର୍‍ ନିଜର୍‍ ଲୋପେ ଆଲ୍‍ସି ମିକା କେତ୍‍ତଡ଼୍‍, “ମାମ୍‍ ସାଙ୍ଗ୍‍ତେ ରୂଟି ତାଡ଼୍‍ୱାଙ୍କ୍‍ ଅଣ୍ଡ୍‌‍ ଇଗଟି କେତୁତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ଅଡ଼୍‌‍ ବାତେ ଆଲ୍‍ସି ମିନ୍ଦେଡ଼୍‍, ପୁଞ୍ଜ୍‍ମେଣ୍ଡେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ଗାରେ ରୂଟି ଇଲେ ଇଞ୍ଜ ଇସର୍‍ ଆଲ୍‍ସୁତିଡ଼୍‍ ବାତେଙ୍କ୍‍ ? ମିଡ଼୍‍ ବାତେ ଇଞ୍ଜ୍‍ଜେକ୍‍ ଆଇନା ପୁନ୍ଦ୍‍ପାର୍‍ୱିଡ଼୍‍ କି ବୁଜେମ୍‍ ଆଦ୍‍ପାର୍‍ୱିଡ଼୍‍ ? ଇସର୍ ବାକ୍‍ୱା ନଡ଼ି ! ");
INSERT INTO kff_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","କଣ୍ଡା ମାଞ୍ଜ୍‍ ବାତେ ଉଡ଼୍‍ପାର୍‍ୱିଡ଼୍‍, କେୱ୍‍କ୍‍ ମାଞ୍ଜ୍‍ କେଞ୍ଜ୍‍ ପାର୍‍ୱିଡ଼୍‍ ଏର୍କେ ମାଡ଼ିୱିଡ଼୍‌ ? ");
INSERT INTO kff_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ଏଇଙ୍ଗ୍‍ ରୂଟି ଉୱୁସ୍‍ ବେଲା ଏଇଙ୍ଗ୍‍ ହଜାର୍‍ ନାରୁଡ଼୍‍କିଙ୍କ୍‍ ତିହ୍‍ସ୍‍ମାତ୍‍ତିଡ଼୍‍, ମିକ୍‍ ବାତେ ହେର୍କେ ଇଲେ ? ଆ ଦିନେତ୍‍ ଲେକାମ୍‍ ରାଲି ମାନ୍ଦାନ୍‍ ରୂଟି ଦୁଙ୍କା ସାରେ ପେହ୍‍କି ବେସ୍‌କ୍ ଜୁଡ଼ି ନିହ୍‍ସ୍‍ ମାତ୍‍ତିଡ଼୍‍, ହେର୍କେ ମିନ୍ଦେ ?” “ବାର୍‍ଟାନ୍‍” ଇଞ୍ଜ ଶିଷ୍ୟଡ଼୍ ଉତ୍ତର ହିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ଜିସୁ ମେଣ୍ଡେ ପାଚ୍ରାରା ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ମେଣ୍ଡେ ବେସୁଙ୍କ୍‍ ନାଲୁ ହଜାର୍‍ ନାରୁଡ଼୍‍ ମାଇଦିଙ୍କ୍‍ ସାତ୍‍ଟାନ୍‍ ରୂଟି ଉୱୁସ୍‍ ମାତ୍‍ତାନ୍‍, ମିଗିଲି ମାତ୍‍ତେ ରୂଟି ଦୁଙ୍କା ପେହ୍‍କି ବେସ୍‌କ୍ ଜୁଡ଼ି ନୀଇସ୍‍ ମାତ୍‍ତିଡ଼୍‍ ?” ଅଡ଼୍‌‍ ଉତ୍ତର୍ ଇତ୍‍ତଡ଼୍‍, “ସାତ୍‍ଟାନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ଜିସୁ ପ୍ରଶ୍ନ ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ଆଗେକ୍‍ ବା ବାତେ ମିଡ଼୍‍ ବୁଜେମ୍‍ ଆୟ୍‍ୱିଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ଅଡ଼୍‌‍ ବେସୁଙ୍କ୍‍ ବେତ୍‍ସାଇଦା ନାର୍‍ ଏୱ୍‍ତଡ଼୍‍, ନାରୁଡ଼୍‍ ୱେରଙ୍କ୍‍ କାନାଙ୍କ୍‍ ଜିସୁନ୍ ଗାରେ ତାସ୍‍ ଅଂକିଙ୍କ୍‌ ଇଟାନ୍‍ ମାଇଦିଙ୍କ୍‍ ଅନୁରୋଦ ମାଡ଼୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ଜିସୁ କାନାନ୍‍ କାଇ ପୟ୍‍ସ୍‍ ଅଂକିଙ୍କ୍‌ ନାର୍‍ଦେ ବାୟ୍‍ଦ୍‌ ଅତ୍‍ତଣ୍ଡ୍‍ । ଆଗେ ଅଂକିଙ୍କ୍‌ କଣ୍ଡାନାଗ୍‍ ଉସୁଲ୍‍ ମେହେସିସ୍‍ ଅନ୍‌‍ ମେନ୍ଦୁଲ୍‍ ତାଗେ କାୟ୍‍ୱାଟି ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାରା ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ବାତା ଉଡ଼୍‍ ପାର୍‍ଦୁତି ?” ");
INSERT INTO kff_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ନାରୁଡ଼୍‌କ୍‌ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, “ହ, ନାରୁଡ଼୍‍କିଙ୍କ୍‍ ଉଡ଼୍‍ ପାର୍‍ଦୁତାନ୍‍ । ଅଡ଼୍‌‍ ବୁଚା ମାଡ଼ାନ୍‍ଡ଼୍‌ ଲେକାମ୍‍ ତନ୍ଦମିନ୍ଦେଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ଜିସୁ ନାରୁନ୍‍ତେ କଣ୍ଡେତ୍‍ ପର ନିଜର୍‍ କାଇୱାଟି ନୁ ନାରୁଣ୍ଡ୍‍ ସାୟେ ହେର୍କେ ମାଡ଼୍‍ତଣ୍ଡ୍‍ । ହଟାତ୍‍ ଅନାଦ୍‌‍ ଉଡ଼ାନ୍‍ ଶକ୍ତି ମାଲ୍‍ସ୍‍ ୱାତ୍‍ତେ ନୁ ଅଣ୍ଡ୍‌‍ ଲେକେତ୍‍ ଉଡ଼୍‍ପାର୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଆ ନାର୍‍ ମାଲ୍‍ସ୍‍ ଆନ୍‌‍ମା ଇଞ୍ଜ ଗଟ୍ ଇସ୍‍ ଅନ୍‌‍ ଲୋନ୍‌‍ ରୟ୍‍ସିତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ତାନ୍‍ ପେର୍କେ ଜିସୁ ନୁ ତାନ୍‍ ଶିଷ୍ୟଡ଼୍ କାଇସରିୟା ଫିଲିପ୍‍ପୀ ନାର୍‍ଦେ ଗାରେ ନାର୍‍କି ନା ଆଦାନ୍‍ୱେଲେ ଆର୍‍ଦାଗ୍‍ ଜିସୁ ପାଚ୍ରାରା ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ନାନ୍‍ ବେନନ୍, ଇ ବିଷୟ୍‍ତେ ନାରୁଡ଼୍‍ ବାତେ କେତୁତଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ଅଡ଼୍‌‍ ଉତ୍ତର୍‍ ହିତ୍‍ତଡ଼୍‍, “ବେସ୍‌କ୍ ତଡ଼୍‍ କେତୁତଡ଼୍‍, ନିମେ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌‌,” ମେଣ୍ଡେ ବେସ୍‌କ୍ ତଡ଼୍ ‍କେତୁତଡ଼୍‍, ନିମେ ଏଲିୟ । ମେଣ୍ଡେ ୱେର୍‍ତଡ଼୍‍ ମନେ ମାଡ଼ୁତଡ଼୍‍, ନିମେ ବାବବାଦୀଡ଼୍‍ ଲୋପେଙ୍କ୍‍ ୱେରନି । ");
INSERT INTO kff_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ପାଚ୍ରାରା ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ମେଣ୍ଡେ ମିଡ଼୍‍ ବାତେ ଆଲ୍‍ସୁତିଡ଼୍‍ ? ନାନ୍‍ ବେନନ୍, ଇ ବିଷୟ୍‍ତେ ମିଡ଼୍‍ ବାତେ କେତୁତିଡ଼୍‍ ।” ପିତର୍‍ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ନିମେ ଇଶ୍ୱର୍‌ତେ ହେଞ୍ଚିମାନ୍ଦାନ୍ ତ୍ରାଣକର୍ତ୍ତାନ୍‍ ମସୀହନି ।” ");
INSERT INTO kff_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗଟ୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ନା” ବିଷୟ୍‍ତେ ଇ ଗଟ୍‍ ବେନଙ୍କ୍ କେଲ୍‍ମାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ବୁଜାମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ନାରୁନ୍‌ ପିଲେତିଙ୍କ୍‍ ନାର୍ଗେ କଷ୍ଟ ଆଦ୍‍ ୱେୟ୍‍ତିତ୍‍ । ଦର୍ମନେତା, ମୁକ୍ୟ ପୁରହିତ ନୁ ଦର୍ମଗୁରୁଡ଼୍‍ ନଡ଼୍‍ତ ତିପାଲ୍‍ ଆସ୍‍ ଅଣ୍ଡ୍‌ ଡଲିତଣ୍ଡ୍‍ । କିନ୍ତୁ ମୁଣ୍ଡ୍‍ଦିନାତେ ପେର୍କେ ଅଣ୍ଡ୍‌‍ ମେଣ୍ଡନ୍‍ଦାମ୍‍ ତେଦିତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଇ ସାରେ ଗଟି ଜିସୁ ଗାଟି ଲେକେତ୍‍ତେ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍ ବୁଜାମାଡ଼ିତ୍‍ତଣ୍ଡ୍‍ । ଆଦିଙ୍କ୍‍ ପିତର୍‍ ଅଂକିଙ୍କ୍‌ ଲୋପେ କାର୍ଙ୍ଗି ଅସ୍‍ ଅନ୍‌‍ତଡ଼୍‍ କାଇଲି କେତ୍‌ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","କିନ୍ତୁ ଜିସୁ ମାଲ୍‍ସ୍‍ ଶିଷ୍ୟଡ଼ା ଉଡ଼୍‍ତଣ୍ଡ୍ ନୁ ପିତର୍‍ତିଙ୍କ୍‍ ଲେକେତ୍‍ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, “ନାୟାଗାଙ୍କ୍‍ ଦୁର୍‍ ଆୟ୍‍ମ୍‍ ଶୟ୍‍ତାନ୍‍, ନିୟାଦ୍‍ ଚିନ୍ତା ମାତର୍‍ ନାରୁଡ଼ାଦ୍, ଇଶ୍ୱର୍‌ତେ ଶକ୍ତି ଆୟ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ତାନ୍‍ ପେର୍କେ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ନୁ ସାରେ ତଡ଼କ୍‌ କାର୍‍ଙ୍ଗି ମିକା କେତ୍‍ତଣ୍ଡ୍‍, “ବେନ କି ନା ସାଙ୍ଗେ ୱାଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ଆଦ୍‍ତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ସାରେ ୱିଡ଼୍‍ସିଣ୍ଡ୍ ନୁ ନିଜର୍‍ କ୍ରୁଶ କାଞ୍ଜି ନା ପେର୍କେପେର୍କେ ୱାଡ଼ିଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ବେନ ଆୟି ନିଜର୍‍ ଜିୱୁନ୍‌ ଗେଲ୍‍ସ୍ପାଙ୍କ୍‍ ଇଚ୍ଛା ମାଡ଼ିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆଦ୍‍ ହରା ମାଡ଼ିତଣ୍ଡ୍‍; କିନ୍ତୁ ବେନ ଆୟି ନା ମାଇଦିଙ୍କ୍‍ ନୁ ଇ ଲେକେତ୍ ଗଟ୍‍ ମାଇଦିଙ୍କ୍ ନିଜର୍‍ ଜିୱୁନ୍‍ତିଙ୍କ୍ ଇସ୍‍ମିକା, ଅଣ୍ଡ୍‌‍ ଆଦ୍‍ଲେକାମ୍ ଆଦ୍‍ ନେହେତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଅର୍‍ତୁଣ୍ଡ୍‍ ନାରୁଣ୍ଡ୍‍ ସାରେ ଜଗତ୍‍ତିଙ୍କ୍ ଲାବ୍ ମାଡ଼ି ନିଜର୍‍ ଜିୱୁନ୍‍ତିଙ୍କ୍‍ ହରାମାଡ଼୍‍କେ, ଅନାଦ୍‌‍ ବାତେ ଲାବ୍ ଆଦ୍‍ତେ ? ନିଜାମ୍ ଲେକାମ୍‍ ଆୟ । ");
INSERT INTO kff_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ବେନ୍‍ ବିଷୟ୍‍ତେ ବିନିମୟ୍‍ତେ ଅଣ୍ଡ୍‌‍ ଅନାଦ୍‌‍ ଜିୱୁନ୍‍ତିଙ୍କ୍‍ ଦର୍ସ୍କେ ପାର୍‍ୱଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ଇଶ୍ୱର୍‍ ୱାଦାନ୍ ଦିନାମ୍‍ତେ ଯଦି ବେନ ନା ମାଇଦିଙ୍କ୍‍ ନୁ ନା ଶିକ୍ଷାତେ ମାଇଦିଙ୍କ୍ ସିଗ୍‍ ଆଦ୍‍ତ, ଆଲାଇତ୍କେ ଇଶ୍ୱରତେ ଗୌରବତେ ନିଣ୍ଡି ଆସ୍‍ ନାରୁନ୍‌ ପିଲେ ବେସୁଙ୍କ୍‍ ପବିତ୍ର ସ୍ୱର୍ଗତେ ଦୂତକିନ୍‍ ତ ମେଣ୍ଡନ୍‍ ଦାମ୍‍ ୱାଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌‍ ଆନ୍ତେ ଅଡ଼୍‌‍ସେଙ୍ଗେ ସିଗ୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ମେଣ୍ଡ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ନାନ୍‍ ମିକିଙ୍କ୍ ସତ୍‍ କେସ୍‍ ନେଏତୁତାନ୍‍, ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ଶକ୍ତିତଡ଼୍‍ ୱାଦାନାଦ୍‍ ନୁ ଆଦାନାଦ୍‍ ଉଡ଼ାନ୍‍ ଯାକ ଇଗ୍‍ ମାନ୍ଦାନ୍‍ ବେସ୍‍କ୍‍ତଡ଼୍ ନାରୁଡ଼୍‍ ଡଲଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ଆଦିନ୍‌ ଆରୁ ଦିନାତେ ପେର୍କେ ପିତର, ଯାକୁବ୍‍ ନୁ ଯୋହନ୍‌‌ତିଙ୍କ୍ ସାଙ୍ଗେ ଅସ୍‍ ଜିସୁ ଅଣ୍ଡୟ୍‌ ଡେଙ୍ଗ୍‍ମାନ୍ଦାନ୍‍ ମେଟେତାଗ୍‍ ଆତ୍‍ତଡ଼୍‍ । ଆଗେ ବେନଡ଼୍‍ବା ଇଲକଟ ମାତ୍‍ତଡ଼୍‍ । ଶିଷ୍ୟଡ଼୍ ଉଡ଼ଉଡ଼ ଜିସୁନାଦ୍‍ ଅଣ୍ଡୟ୍‌‍ ବେସୁଙ୍କ୍‍ ଉଡ଼୍‍ୱେ ଲେକାମ୍ ତନ୍ଦତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ଅନାଦ୍‌‍ ସିଲା ପାଣ୍ଡ୍ରି ଆସ୍‍ ଗାଟି ୱେୟ୍‍ସ୍‍ ଆତ୍‍ତେ ଜଗତ୍‍ତେ ବେନ ଆଦିଙ୍କ୍‍ ନର୍‍ସ୍‍ ଆସର୍‍ ପାଣ୍ଡ୍ରି ମାଡ଼୍‍ପାର୍‍ୱଡ଼୍‍ ଆୟେଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ତାନ୍‍ ପେର୍କେ ମୁୱୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍ ଉଡ଼୍‌ତଡ଼୍‍, ଏଲିୟ ନୁ ମୋଶାଲ୍‌‍ ପେଇସ୍‍ ମିକା ଜିସୁନ୍‍ତଡ଼୍‍ ତିର୍‍ୟା ତିର୍‍ୟି ଆଦୁତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ପିତର୍‍ ଜିସୁଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଗୁରୁ, ଇଦ୍‍ ବେସର୍‍ ସାର୍‍ଦେତେ ଗଟ୍‍ ଯେ ନେଣ୍ଡ୍‍ ମାନାଡ଼୍‍ ଇଗେ ମିନ୍ଦେଡ଼୍‍ । ଇଗ୍‍ ମୁଣ୍ଡ୍ ଗୁଡ଼୍‍ସା ତିଆର୍‍ ମାଡ଼ିକା । ଅଣ୍ଡୟ୍‌‍ ନି ମାଇଦିଙ୍କ୍ ଅଣ୍ଡୟ୍‌‍ ମୋଶାନ୍‌‌ ମାଇଦିଙ୍କ୍ ନୁ ମେଣ୍ଡ୍‍ ଅଣ୍ଡୟ୍‌ ଏଲିୟନ୍‍ ମାଇଦିଙ୍କ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ପିତର୍‍ ବାତେ କେତିତଣ୍ଡ୍‍, ଇଞ୍ଜ୍‍ ଆଲ୍‍ସକଟ ଇ ଗଟ୍‍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍‍ । ଇତ୍କେ ଶିଷ୍ୟଡ଼୍ ପିନା ୱେର୍‍ସ୍‍ ମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଅଟାତ୍‍ ମୟଲ୍‍ ତାଗାଙ୍କ୍‍ ଅଣ୍ଡୟ୍‌‍ ମାବ୍‍ ତନ୍ଦ୍‍ତେ ନୁ ଆଦିନ୍‌ ନିଡ଼୍‍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିସ୍‍ତେ । ମେଣ୍ଡେ ଆ ମାବ୍‍ତେ ଲୋପେଙ୍କ୍ ଅଣ୍ଡୟ୍‌‍ ଗଟ୍‍ କେଞ୍ଜାଙ୍କ୍ ଆତ୍‍ତେ, “ହୋ ନା ପ୍ରିୟ ମାର୍‍, ଇନାଦ୍‍ ଲେଙ୍ଗ୍ ମାନ୍‍ ଇସ୍‍ କେଞ୍ଜାଟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଆସୁଟ୍‍ ଶିଷ୍ୟଡ଼୍ ସାରେ ପାକା ସିଟ୍‍ପାଟ୍‍ ଉଡ଼ି ମାତଡ଼୍‌ ଜିସୁନ୍‍ ୱିଡ଼୍‍ସି ଆଗେ ୱେର୍‍ ବେନଙ୍କ୍ ଉଡ଼ଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ଅଡ଼୍‌‍ ମେଟେତାଗାଙ୍କ୍‍ ଡିଗାନ୍‍ ୱେଲେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଗଟ୍‍ ଇସ୍‍ ତେତ୍‍ତଣ୍ଡ୍‍, “ନେଣ୍ଡ୍‍ ବାତେ ଉଡ଼ି ମିନ୍ଦେଡ଼ି, ନାରୁନ୍‌ପିଲେ ଡଲ୍‍ତାଙ୍କ୍‍ ତେଦ୍‍ନା ଜାକ ଆ ଗଟ୍‍ ବେନଡ଼୍‍କ୍‌ କେଲ୍‍ମାଟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ଜିସୁନ୍‍ ଆଦେଶ୍‍ ଅଡ଼୍‌‍ ପାଲନ୍‍ ମାଡ଼୍‍ତଡ଼୍‍, କିନ୍ତୁ ଇ ବିଷୟ୍‍ତେ ଅଡ଼୍‌‍ ଅଡ଼୍‌ ଲୋପେ ଆଲଚନା ମାଡ଼୍‍ତଡ଼୍‍, “ଡଲି ତେଦାନାଦ୍‍” ଇତ୍‍କେ ବାତେ ? ");
INSERT INTO kff_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ଅଣ୍ଡ୍‌‍ ଜିସୁଙ୍କ୍ ପାଚାରା ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ଏଲିୟ ମୁନେଙ୍କ୍‍ ୱାଦ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ମାନ୍‍ ଦର୍ମଶାସ୍ତ୍ର ତେ ଗୁରୁଡ଼୍‍ ବାତେଙ୍କ୍‍ କେତୁତଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍ “ମୁନେତ୍‍ ଲେକାମ୍ ସାରେ ବିଷୟ୍‍ତେ ତିଆର୍‍ ମାଡ଼ନ୍‍ ମାଇଦିଙ୍କ୍‍ ଏଲିୟ ମୁନେ ୱାଦାନ୍‍ ଗଟ୍‍ । ମେଣ୍ଡେ ନାରୁନ୍‌ଫିଲେ ନାର୍ଗେ ଦୁଃକାମ୍‍ ତିପାଲ୍‍ ଆତ୍‍ତଡ଼୍‍ ଇଞ୍ଜ ଶାସ୍ତ୍ରତାଗ୍‍ ବାତେଙ୍କ୍‍ ଲେକା ମିନ୍ଦେ ? ");
INSERT INTO kff_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ଅଣ୍ଡ୍‌ ବେଲା ଆଇନ୍‍, ନାନ୍‍ ମିକିଂଙ୍କ୍‍ କେସିଦୁତାନ୍, ଏଲିୟ ୱାସ୍‍ ହେୱ୍‍ସ୍‍ ମିନ୍ଦେଣ୍ଡ୍‍ ନୁ ନାରୁଡ଼୍‍ ଅନ୍‌‍ ପରୁ ମନ୍‍ ଇଚ୍ଛା ବ୍ୟବହାର୍‌ ମାଡ଼ିମିନ୍ଦେଡ଼୍‍ । ଇଦିନ୍‍ ମାଇଦିଙ୍କ୍‍ ଅନ୍‌‍ ବିଷୟ୍‍ତେ ଶାସ୍ତ୍ରତାଗ୍‍ ବାତେ କେସ୍‍ମିନ୍ଦେଡ଼୍‍, ଆୱ୍‍ସାରେ ଗଟେମ୍‍ ଆଦ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ଅଡ଼୍‌‍ ୱେର୍‍ ଶିଷ୍ୟଡ଼୍ ଗାରେ ହେୱ୍‍ସ୍‍ ମାନ୍ଦାନ୍‍ୱେୟ୍‍, ଆଗେ ନାର୍ଗେ ନାରୁଡ଼୍‍ ଗୁଡ଼ି ମାତ୍‍ତଡ଼୍‍ ନୁ ଆ ଶିଷ୍ୟଡ଼୍‍ତ ବେସ୍‍କ୍‍ତଡ଼୍ ଦର୍ମଗୁରୁଡ଼୍‍ ରାମ୍‍କ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ନାରୁଡ଼୍‍ ଜାପେ ଜିସୁଙ୍କ୍ ଉଡ଼ି ଦାଦ୍‍ରେଲ୍‍ତଡ଼୍‍ ନୁ ମିରି ଆଞ୍ଜ୍ ଅଂକିଙ୍କ୍‌ ମଡ଼୍‍କ୍‍ ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଅଡ଼୍‌‍ ତ ବେନ୍‍ ବିଷୟ୍‍ତେ ରାମ୍‍କ୍ ମାଡ଼ମାତ୍‍ତିଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ନାରୁଡ଼୍‍ ଲୋପେଙ୍କ୍ ଅର୍‍ତୁଣ୍ଡ୍‍ ଉତ୍ତର୍‍ ଇସ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, ଗୁରୁ, ନା ମାରିଙ୍କ୍ ବୁତ୍‌ ‍ପୟ୍‍ତେ ନୁ ଅଣ୍ଡ୍‌ ଗଟି ତିର୍ୟାଙ୍କ୍‍ ପାର୍‍ୱଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ବୁତ୍‌ ଅଂକିଙ୍କ୍‌ ବେସୁଙ୍କ୍‍ ବେସୁଙ୍କ୍‍ ନେଲ୍‍ ରାପିଦୁତ୍‌ । ଆସୁଟ୍‍ ଅନ୍‌‍ ପାୟୁର୍‍ତାଗାଙ୍କ୍‍ ବୟୁଲ୍‍ ପେୟ୍‍ତିତ୍‍, ଅଣ୍ଡ୍‌ ଅନ୍‌‍ ପାଲ୍‍କିଙ୍କ୍‍ କର୍‍କୁତଣ୍ଡ୍‍ ନୁ ଅନ୍‌‍ ମେନ୍ଦୁଲ୍‍ ମେୟ୍‍ଲ । ବୁତ୍‌ ୱିର୍‍ସ୍ପାନ୍‍ ମାଇଦିଙ୍କ୍‍ ନି ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ କେତ୍‍ତାନ୍‍, କିନ୍ତୁ ଅଡ଼୍‌‍ ବାତ୍ ବା ମାଡ଼୍‍ପାର୍‍ୱଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ମିଡ଼୍ ବେସର୍‍ କମ୍‍ ବିଶ୍ୱାସିଡ଼୍ । ମି ତଡ଼୍‍ ନାନ୍‍ ମେଣ୍ଡେ ବେସ୍‌କ୍ ଦିନା ମାନ୍ତ୍‍ତାନ୍‍ ? ପେକାଙ୍କ୍‍ ନା ଗାରେ ପୟ୍‍ସ୍‍ ତାଡ଼ାଟ୍‍ !” ଅଡ଼୍‌‍ ଅକିଂଙ୍କ୍‍ ଜିସୁନ୍ ଗାରେ ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ପ୍ରେତାତ୍ମା ଜିସୁଙ୍କ୍‍ ଉଡ଼ ୱାନାକେ ପେକାଙ୍କ୍‍ ଚେତ୍‍ ଇଲ୍‍ୱେ ମାଡ଼ି ନେଲ୍‍ ରାପି ପେକାନ୍‍ ପାୟୁର୍‍ତାଗାଙ୍କ୍‍ ବୟୁଲ୍‍ ପେସ୍‍ପି ନେଲ୍‍ ପର୍‍ଲାଙ୍କ୍‍ ପସ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ଜିସୁ ତାମ୍‍ ବାବାଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ବେସ୍‌କ୍ ଦିନା ପୟ୍‍ସ୍‍ ଅଣ୍ଡ୍‌‍ ଇଲା ଆତ୍‍ତଣ୍ଡ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ଅଣ୍ଡ୍‌‍ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍ “ପିଲେକଂସ୍‍ । ବୁତ୍‌ ଅଂକିଙ୍କ୍‌ କିସ୍‍ତାଗ୍‍ ବା ଏର୍‍ଦାଗ୍‍ ରାପି ଆୱ୍‍କାନ୍‍ ମାଇଦିଙ୍କ୍‍ ନାର୍ଗେଦାମ୍‍ ଚେଷ୍ଟା ମାଡ଼୍‍ତେ । ଗୁରୁ ! ନିଜାମ୍‍ ଆତ୍କେ, ଦୟାମାଡ଼ି ମାକିଙ୍କ୍‍ ଇଗାଙ୍କ୍‍ ସାହାଯ୍ୟ ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ହଁ !” ବେନ ବିଶ୍ୱାସ ମାଡ଼ିତଣ୍ଡ୍‍, ଅନ୍‌‍ ଗାରେ ସାରେ ନିଜାମ୍ । ");
INSERT INTO kff_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ପେକାଲଡ଼୍‍ ବାବାଲ୍‍ ଗାଟି ଲେଙ୍ଗ୍‍ତେ କେତ୍‍ତଣ୍ଡ୍‍, “ନା ବିଶ୍ୱାସ୍‍ ମିନ୍ଦେ, କିନ୍ତୁ ଅବିଶ୍ୱାସି । ନା ବିଶ୍ୱାସ୍‍ ଅଦିକ୍‌ ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ନାକିଙ୍କ୍‍ ସାହାଯ୍ୟ ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ଜିସୁ ଉଡ଼୍‍ତଣ୍ଡ୍ ସାରେ ପାକାଙ୍କ୍‍ ନାରୁଡ଼୍‍ ଅନ୍‌‍ଗାରେ ୱାସ୍‍ମାତ୍‍ତଡ଼୍‍ । ଆଦିଙ୍କ୍‍ ଆ ପ୍ରେତାତ୍ମାତିଙ୍କ୍‍ ଗଟ୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ତିର୍‍ୟେ ପାର୍‍ୱେ ନନ୍ ନୁ କେଞ୍ଜାଙ୍କ୍ ପାର୍‍ୱେ ଆତ୍ମା ନାନ୍‍ ନିକିଙ୍କ୍ କେତୁତାନ୍‍, ଇ ପେକାନ୍‍ ଲୋପେଙ୍କ୍‍ ପେୟ୍‍ସ୍‍ ଅନ୍‌‍ ମେଣ୍ଡେ ବେସୁଙ୍କ୍‍ ବା ଅନ୍‌‍ ଲୋପେ ନେଙ୍ଗ୍‍ମା ।” ");
INSERT INTO kff_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ପ୍ରେତାତ୍ମା ଲେଙ୍ଗ୍‌ଦେ କିଡ଼୍‍କି ମିକା ପେକାଙ୍କ୍‍ ନେଲ୍‍ ରାପି ଅନ୍‌‍ଲୋପେଙ୍କ୍‍ ପେୟ୍‍ସ୍‍ ଆତ୍‍ତେ । ଚେତ୍‍ଇଲ୍‍ୱେ ମାଡ଼ି ପେକାଙ୍କ୍ ମଡ଼୍‍ଦେ ଲେକାମ୍‍ ତନ୍ଦ୍‍ତଣ୍ଡ୍‍ ନୁ ସାରେତଡ଼୍‍ କେତ୍‍ତଡ଼୍‍, “ଅନ୍‌‍ ଡଲ୍‍ତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","କିନ୍ତୁ ଜିସୁ ଅନ୍‌‍ କାଇ ପୟ୍‍ସ୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‍ ନୁ ଅଣ୍ଡ୍‌‍ ତେଦି ନିତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଜିସୁ ଲନ୍‍ ଲୋପେ ଆତ୍‍ତେ ପେର୍କେ ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ ୱେର୍‍କଟ୍‌ ପାଚାରା ମାଡ଼୍‍ତଡ଼୍‍, “ମାମ୍‍ ବାତେଙ୍କ୍‍ ଆ ପ୍ରେତାତ୍ମାତିଙ୍କ୍‍ ତଲିଦ୍‍ ପାର୍‍ୱମ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ଇଦ୍‍ଲେକାମ୍ ପ୍ରେତାତ୍ମାକିଙ୍କ୍‍ ମାତର୍ ପ୍ରାର୍ତନାତେ ଶକ୍ତି ତଡ଼୍ ତଲାଙ୍କ୍ ଆଦ୍‍ତେ-ୱେର୍‍ ଉପାୟ୍‍ ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଜିସୁ ନୁ ତାନ୍‍ ଶିଷ୍ୟଡ଼୍ ଆ ପଡ଼୍‍ୟ୍‍ ୱିଡ଼୍‍ସି ଗାଲିଲୀ ଅଞ୍ଚଲ ଲୋପେଇସ୍‍ ଆତ୍‍ତଡ଼୍‍ । ଅଣ୍ଡ୍‌‍ ବେଗ୍‍ମିନ୍ଦେଣ୍ଡ୍‍, ବେନଡ଼୍‍ ପୁନ୍‍ମାକିଡ଼୍‍ ଇଞ୍ଜ ଜିସୁ ଇଚ୍ଛା ମାଡ଼ ମାତ୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","କିନ୍ତୁ ଇଦ୍‍ ସମୟତେ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ବୁଜାମାଡ଼ି କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍‍, ବେଦ୍‍ପୁଟୁଙ୍କ୍, “ମନୁଷ୍ୟପୁତ୍ର,” ନାରୁଡ଼୍‍ କାଇଦେ ଦର୍ସ୍କି ଅସ୍‍ ମାୟି ଆଦ୍‍ତଡ଼୍‍, କିନ୍ତୁ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଅଣ୍ତ୍‌ ଡଲାନ୍‍ ମୁଣ୍ଡ୍‍ଦିନାତେ ପେର୍କେ ଅଣ୍ଡ୍‌ ଜିୱେ ଆଦ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ଶିଷ୍ୟଡ଼୍ ଇ ଗଟ୍‍ତେ ଅର୍ତ ପୁନ୍ଦାଙ୍କ୍‍ ପାର୍‍ୱଡ଼୍‍ । କିନ୍ତୁ ଆ ବିଷୟ୍‍ତେ ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡେ ପ୍ରଶ୍ନ ମାଡ଼ାଙ୍କ୍‍ ୱେର୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ଅଡ଼୍‌‍ କପର୍ନାହୁମ୍‍ ତାଗ୍‍ ଏୱ୍‍ତଡ଼୍‍ ଲୋନ୍‌‍ ନେଙ୍ଗ୍‍ତେ ପେର୍କେ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ପାଚାରାମାଡ଼୍‍ତଣ୍ଡ୍, “ଆର୍‍ଦାଗ୍‍ ୱାଦାନ୍‍ୱେୟ୍‍ ମିଡ଼୍‍ ବେନ୍‍ ବିଷୟ୍‍ତେ ରାମ୍‍କ୍‍ ମାଡ଼ମାତ୍‍ତିଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ଅଡ଼୍‌‍ ଉତ୍ତର୍‍ ଇୱକଟ ମାତ୍‍ତଡ଼୍‍, ବାତେଙ୍କ୍‌ଇତ୍କେ ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍‍ ସାରେତିଙ୍କ୍ ବେନଣ୍ଡ୍ ବେଡ଼୍‍ୟଣ୍ଡ୍‍, ଇ ବିଷୟତେ ଅଡ଼୍‌‍ ଆର୍‍ଦାଗ୍‍ ଆଲ୍‍ସ ମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ଜିସୁ କୁଦି ଅନ୍‌‍ ବାରଜାନ୍‍ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ଗାରେ କାର୍ଙ୍ଗି ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ବେନ ମୁନେ ଜାଗା ଇଚ୍ଛା ମାଡ଼ିତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ପେର୍କେ ମାନିଣ୍ଡ୍‍ ନୁ ସାରେତଡ଼୍‍ଦେ ସେବକ ଆଇନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଅର୍‍ତୁଙ୍କ୍‍ ବାବୁଙ୍କ୍‍ ତାସ୍‍ ସାରେତଡ଼୍‍ ମୁନେ ନିଲ୍‍ସ୍ପ୍‍ତଣ୍ଡ୍‍, ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ବର୍‍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ବେନଆଇ ନା ପେଦେର୍‍ତେ ଇଦ୍‍ଲେକାମ୍‍ ଅର୍‌ତୁଙ୍କ୍‌ ବାବୁଙ୍କ୍‍ ସ୍ୱାଗତ୍‍ ମାଡ଼ିତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ନାକିଙ୍କ୍‍ ସ୍ୱାଗତ୍‍ ମାଡ଼ିତଣ୍ଡ୍‍ ନୁ ବେନ ନାକିଙ୍କ୍‍ ଗ୍ରହଣ ମାଡ଼ିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌‍ ମାତର୍‍ ନାକିଙ୍କ୍‍ ଆୟ, ନା ତ୍ରାନକର୍ତ୍ତାଙ୍କ୍‍ ଆନ୍ତେ ଗ୍ରହଣ ମାଡ଼ିତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଯୋହନ୍‍ ଜିସୁଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଗୁରୁ ନି ପେଦେର୍‍ ଆସ୍‍ ୱେରଣ୍ଡ୍‍ ନାରୁଣ୍ଡ୍‍ ବୁତ୍‌ ୱୁଡ଼୍‍ସ୍ପାନାଦ୍‍ ମାମ୍‍ ଉଡ଼୍‍ତମ୍‍ ଅଣ୍ଡ୍‌‍ ମା ଦଲତଣ୍ଡ୍‍ ଆୟ୍‍ୱାଙ୍କ୍‍ ମାମ୍‍ ଅଂକିଙ୍କ୍‌ କାର୍‍ଙ୍ଗ୍ ତାଡ଼୍‍ମ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ଇ କାମ୍‍ଦାଗ୍‍ ଅଂକିଙ୍କ୍‌ ତିପାଲ୍ ଇମାଟ୍‍ ।” ବେନ ନା ପେଦେର୍‍ ଆସ୍‍ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‌ୟି ମାଡ଼ିତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ନା ବିରୁଦ୍ଦ୍‌ତେ ବାତେ କେତ୍‍ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ବେନ ମାନ୍‍ ବିରୁଦ୍ଦ୍‌ ଆୟଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌‍ ମାନ୍‍ ପାକ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ନାନ୍‍ ନିଜାମ୍‌ କେତୁତାନ୍‍, ନା ପେର୍‌କ୍‌ତଣ୍ତ୍‌ ଇଞ୍ଜ ମିକିଂଙ୍କ୍‍ ବେନ ଯଦି ଉନ୍ଦାନ୍‍ ମାଇଦିଙ୍କ୍‍ ଗିଲାସ୍‍ତାଗ୍‍ ଏର୍‍ ଇଦ୍‍ତ, ଅଣ୍ଡ୍‌ ନିଜାମ୍‍ ଅଣ୍ଡ୍‌‍ ମସୀହ ନାଗାଙ୍କ୍‍ ପୁରସ୍କାର୍ ପାହେମ୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ବେନଆଇ ନା ଇ ବିଶ୍ୱାସିଡ଼୍ ଲୋପେଙ୍କ୍‍ ସାରେତାଗାଙ୍କ୍‍ ସୁଜୁର୍ ମିକା ବିଶ୍ୱାସ୍‍ ଇଲ୍‍ୱେନନ୍ ଗଟାମାଡ଼ିତଣ୍ଡ୍‍, ଅନ୍‌‍ ବଣ୍ଡ୍‍କ୍‍ତାଗ୍‍ ଅଣ୍ଡୟ୍‌‍ ଜାତେକାଲ୍‍ ତହ୍‍ସିସ୍‍ ଅଂକିଙ୍କ୍‌ ସମୁଦ୍ରତାଗ୍‌ ଏସିଦାଙ୍କ୍‍ ଅନ୍‌‍ ମାଇଦିଙ୍କ୍‍ ସାୟ୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଯଦି ନି ଅଣ୍ଡୟ୍‌ କାଇଦେ ସେଙ୍ଗେ ବିଶ୍ୱାସ୍‍ ୱିଡ଼୍‍ସିତ୍‍କେ, ଆ କାଇଦିଙ୍କ୍‍ ନାଡ଼୍‍କି ହେସିମୁଟ୍ । ରେଣ୍ଡ୍ କାଇକ୍‍ ଗାଟି ନିଡ଼୍‍ସ ମାନ୍ଦାନ୍‍ ନର୍‍କତାଗେ ରାଲାନାଗାଙ୍କ୍‍ ଅଣ୍ଡୟ୍‌‍ କାଇ ଇଲକଟ ଅନନ୍ତ ଜିୱୁନ୍‍ତାଗ୍‍ ଆଦାନାଦ୍‌ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନର୍କତାଗ୍ ପୁଡ଼ିୟ୍‍କ୍ ଡଲ୍‍ଅ, କିସ୍‍ ବେସୁଙ୍କ୍‍ ପିୟ । ");
INSERT INTO kff_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଯଦି ମି ୱେରଟ୍‍ ଡେକେତ୍‍ ସେଙ୍ଗେ ବିଶ୍ୱାସ୍‍ ମାଡ଼ିମାନ୍ତ୍‍ତାଡ଼୍‍, ଆ ଡେକେତିଙ୍କ୍‍ ନାଡ଼୍‍କିମୁଟ୍‍ । ରେଣ୍ଡ୍‍ ଡେକାମାଞ୍ଜ୍‍ ନର୍‍କତାଗ୍‍ ରାଲାନ୍ ୱିଡ଼୍‌ସି ୱେରଡ଼୍‍ ଡେକ୍‍ ଇଲକଟ ଅନନ୍ତ ଜିୱୁନ୍‍ ଲାବ୍ ମାଡ଼ାନ୍‍ ନାଦ୍‍ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନର୍କତାଗ୍ ପୁଡ଼ିୟ୍‍କ୍ ଡଲ୍‍ଅ, କିସ୍‍ ବେସୁଙ୍କ୍‍ ପିୟ । ");
INSERT INTO kff_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଯଦି ମି ୱେର୍‌ଡ୍‍ କଣ୍ଡେତ୍‍ ସେଙ୍ଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିମାନ୍ତାଡ଼୍, ଆଦିଙ୍କ୍‍ ଏଲ୍‍ସ୍ପିମୁଟ୍‍ । ରେଣ୍ଡ୍ କଣ୍ଡା ମାଞ୍ଜ୍‍ ନର୍‍କତାଗ୍‍ ରାଲାନାଦ୍‌ ୱିଡ଼୍‌ସି ୱେରଡ଼୍‍ କଣ୍ଡା ମାଞ୍ଜ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗ୍‍ ନେଙ୍ଗାଙ୍କ୍‍ ନାଦ୍‍ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ମନେ ନେହ୍‍ମୁଟ୍‍, ନର୍‍କତ୍‍ ପୁଡ଼୍‍ୟି ବେସୁଙ୍କେ ବା ଡଲ, ଆଗେ ନିଡ଼୍‍ସ ମାନ୍ଦାନ୍‍ କିସ୍‍ ବେସୁଙ୍କ୍‍ ବା ପିୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ଅୱଡ଼୍‍ ତଡ଼୍‍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ପୁଜାନାଦିନ୍‍ ତଡ଼୍‍ ସାୟେ ଆଦ୍‍ତେ, ଆଦେପୁଟୁଙ୍କ୍ କିସ୍‌ ତଡ଼୍‌ ସାରେତଡ଼୍‌ ପବିତ୍ର ଆଦ୍‌ତଡ଼୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ଅୱଡ଼୍‍ ଅଣ୍ଡ୍‌ ସାୟେତ୍‍ ଜିନିଷ୍; କିନ୍ତୁ ଅୱଡ଼୍‍ ଯଦି ତାନ୍‍ ଅୱଡ଼୍‍ତେ ମିଙ୍କ୍‍ସ୍ପାନାଦ୍‍ ହରାମାଡ଼ିତେ, ଆଦିଙ୍କ୍‍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ମିଙ୍କ୍‍ସ୍ପାଙ୍କ୍‍ ଆଦ୍‍ତେ ?” “ମି ହୃଦୟତାଗ୍‍ ସାଙ୍ଗନ୍‍ ଲୋପେ ଅୱଡ଼୍‌ଇନା କାଇଲି ମାନୁଟ୍, ଆଲାଇତ୍କେ ମିଡ଼୍‍ଆନ୍‌ତେ ମାନ୍ଦ୍‍ପାର୍‍ଦ୍‍ତିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ତାନ୍‍ପେର୍କେ ଜିସୁ ଯର୍ଦ୍ଦନ ବେଡ଼େମ୍ ୱେୟ୍‍ସ୍‍ ଇହୁଦିୟା ନାର୍‍ତାଗ୍‍ ହେୱ୍‍ତଡ଼୍‍ । ଆଗେ ଆନ୍‌ତେ ନାରୁଡ଼୍‍ ନାର୍ଗେ ସଂକ୍ୟାତେ ୱାସ୍‍ ଅନ୍‌‍ ଗାରେ ଗୁଡ଼୍‍ତେ ନୁ ଅଣ୍ଡ୍‌‍ ମୁନେତ୍‍ ଲେକାମ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଶିକ୍ଷା ଇଦାଙ୍କ୍‍ ପସ୍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ବେସ୍‍କ୍‍ତଡ଼୍ ଫାରୂଶୀଡ଼୍‍ ଅନ୍‌‍ ଗାରେ ୱାସ୍‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼୍‍ୟିଦାଗ୍‍ ରାପାଙ୍କ୍‍ ଚେଷ୍ଟା ମାଡ଼୍‍ତଡ଼୍‍ । ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍‍, “ମା ଶାସ୍ତ୍ରତେ ନିୟମ୍‍ ଅନୁସାରେ ଅର୍‍ତୁଣ୍ଡ୍ ଅନ୍‌‍ ମୁତେଙ୍କ୍‍ କାଇଦେ ଏର୍‍ ଇଦ୍‍ପାର୍‍ଦ୍‍ତଣ୍ଡ୍‍ କି ?” ");
INSERT INTO kff_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ଇ ବିଷୟ୍‍ତେ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ବାତେ କେତୁତେ ?” ");
INSERT INTO kff_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ଅଡ଼୍‌‍ ଉତ୍ତର୍‍ ଇତ୍‍ତଡ଼୍‍, “କାଇଦେ ଏର୍‍ ଇସ୍‍ ମୁତେଙ୍କ୍‍ ୱିଡ଼୍‍ସାନ୍‍ ମାଇଦିଙ୍କ୍‍ ମୋଶାଲ୍‌‍ ଅନୁମତି ଇତ୍‌ତଣ୍ଡ୍‌‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ମି ହୃଦୟ୍‍ତେ ଡୁଟାଙ୍କ୍‍ତେ ମାଇଦିଙ୍କ୍‍ ମୋଶାଲ୍‍ ଇ ଲେକାମ୍‍ ନିୟମ୍‍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ଇତ୍କେ ସୃଷ୍ଟି ସମୟତେ ଇଶ୍ୱର୍‍ ନାରୁଡ଼୍‍କ୍‍ ମାନେଇ ନୁ ନାଟାଡ଼୍ ଲେକାମ୍‍ ତିଆର୍‍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ ନୁ ଶାସ୍ତ୍ରତାଗ୍‍ କେତ୍‍ତାଦ୍‍ ମିନ୍ଦେ ଯେ, ");
INSERT INTO kff_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ଆଦିନ୍‌ ମାଇଦିଙ୍କ୍‍ ନାରୁଣ୍ଡ୍‍‍ ୟାୟ୍‍ ବାବାଲଡ଼୍‍କ୍‍ ୱିଡ଼୍‍ସି ତାନ୍‍ ମୁତେନ୍‍ ତ କାହିଲିତଣ୍ଡ୍‍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ଅଡ଼୍‌ ଇର୍‌ୱୁଡ଼୍‌ କାଇଲି ଅଣ୍ଡୟ୍‌‍ ଆଦ୍‍ତଡ଼୍‍ । ଅଡ଼୍‌‍ ମେଣ୍ଡେ ଇର୍‍ୱୁଡ଼୍ ଆସ୍‍ ମାନଡ଼୍‍, କିନ୍ତୁ ଅଣ୍ଡୟ୍‌‍ ଆଦ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ଇଶ୍ୱର୍‍ ବେନଡ଼କ୍ କାଲ୍‌ପି ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍‍, ନାରୁଡ଼୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ୱେର୍‍ୱେର୍‍ ମାଡ଼୍‍ମାକିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ଅଡ଼୍‌‍ ଲୋନ୍‌‍ ମାଲ୍‍ତେ ପେର୍କେ ଶିଷ୍ୟଡ଼୍ ଜିସୁଙ୍କ୍ ଇ ବିଷୟତେ ମେଣ୍ଡନ୍‍ଦାମ୍‍ ପାଚାରା ମାଡ଼୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ବେନ୍‍ ନାରୁଣ୍ଡ୍‍ କି ମୁତେଙ୍କ୍‍ କାଇଦେ ଏର୍‍ ଇସ୍‍ ମେଣ୍ଡନ୍‍ ମୁତେଙ୍କ୍‍ ତାତ୍‍କେ, ଅଣ୍ଡ୍‌‍ ନିଜେ ବ୍ୟବିଚାରି ଆଦ୍‍ତଣ୍ଡ୍‍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ବେନ୍‍ ମୁତେ ମୁଦ୍‍ପାଙ୍କ୍‍ କାଇଦେ ଏର୍‍ ଇସ୍‍ ମେଣ୍ଡ୍‍ ଅର୍‌ତୁଙ୍କ୍‌ ପେଣ୍ଡୁଲ୍‍ ଆତ୍‍କେ, ଆଦ୍‍ଆନ୍‌ତେ ବ୍ୟବିଚାର୍‍ ଆଦ୍‌ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଅଡ଼୍‌‍ ପର କାଇୱାଟି ଆର୍ଶିବାଦ୍‌ ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ବେସ୍‌କ୍ ତଡ଼୍‍ ଶିଷ୍ୟଡ଼୍ କେତ୍‍ତଡ଼୍ ପିଲାକିଙ୍କ୍‍ ଜିସୁନ୍‍ ଗାରେ ତାଡ଼୍‍ମାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଆ ନାରୁଡ଼୍‍କ୍‍ ଶିଷ୍ୟଡ଼୍ ତିରସ୍କାର୍ ମାଡ଼ମାନ୍ଦାନାଦ୍‍ ଉଡ଼ି, ଜିସୁ ଶିଷ୍ୟଡ଼୍ ପର୍‌ କପାମ୍‍ ଆସ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ପିଲାକିଙ୍କ୍‍ ନା ଗାରେ ୱାଦାଙ୍କ୍ ଇମୁଟ୍; ଅଡ଼୍‌‍କ୍‍ ଦମକ୍‍ ଇମାଟ୍‍, ବାତେଙ୍କ୍‍ଇତ୍କେ ସୁଦୁପିଲାନ୍‍ ଲେକାମ୍‍ ନାରୁଡ଼୍‍ ସ୍ୱର୍ଗରାଜ୍ୟ ଅଦିକାର୍‌‍ ମାଡ଼ିତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ଇ ଗଟ୍‍ ନାନ୍‍ ମିକିଂଙ୍କ୍‌ ନିଜାମ୍‍ କେତୁତାନ୍‍ ଯେ, ସୁଦୁପିଲାନ୍‍ ଲେକାମ୍‍ ଅର୍‍ତୁଣ୍ଡ୍‍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ଗ୍ରହଣ ମାଡ଼ାଙ୍କ୍‍ ତିଆର୍‍ ଆୟକଟ ମାତ୍କେ, ଅଣ୍ଡ୍‌‍ ଆଦିନାଗ୍‍ ନେଙ୍ଗାନଙ୍କ୍‌ ପାର୍‍ୱଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ତାନ୍‍ପେର୍କେ ଜିସୁ ପିଲାଙ୍କ୍‍ ବର୍‍ତାଗ୍ ୱାଟି ଅଡ଼୍‌‍ ପର୍‌ କାଇୱାଟି ଆର୍ଶିବାଦ୍‌ ମାଡ଼୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜିସୁ ମେଣ୍ଡନ୍‍ଦାମ୍‍ ଅନାଦ୍‌‍ ଆଦାନାଦ୍‍ ଆରାମ୍‌ ମାଡ଼୍‍ତେ ୱେଲେ ଅର୍‍ତୁଣ୍ଡ୍‍ ନାରୁଣ୍ଡ୍‍ ମିରିୱାସ୍‍ ଅନ୍‌‍ ମୁନେ ମର୍‍ମିଣ୍ଡା ଉୱୁସି ପାଚାରାମାଡ଼୍‍ତଣ୍ଡ୍‍, “ଗୁରୁ, ସାରେଦିନାତ୍‌ ଜିୱୁନ୍‍ ଲାବ୍‍ ମାଡ଼ାଙ୍କ୍‍ ନାକିଙ୍କ୍‍ ଲେକେତ୍‍ ବାତେ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ନାକିଙ୍କ୍‍ ବାତେଙ୍କ୍‍ ସାୟ୍‍ ଇଞ୍ଜ କେତୁତିନ୍‍ ? ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ୱେର୍‍ଅର୍‍ତୁଣ୍ଡ୍‍ ବେନ ଲେକେତ୍‍ ଇଲେଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ନିମେ ଶାସ୍ତ୍ରତେ ଆଜ୍ଞା ସାରେ ପୁତ୍‍ତି ନାରୁଡ଼୍‍କ୍‍ ଆୱ୍‍କ୍‌ମା, ଆର୍‍ଲା ମାଡ଼୍‍ମାଟ୍‍, ଡଙ୍ଗ୍‍ ମା, ବେନନ୍ ବିରୁଦ୍‍ତେ ମିଚ୍‌ ଗଟି ତାଡ଼୍‍ମାଟ୍‍, ତିପାଲ୍‍ ମାଡ଼୍‍ମାଟ୍‍, ୟାୟ୍‍ବାବାଙ୍କ୍‍ ସାୟେ ଉଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ନାରୁଣ୍ଡ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଗୁରୁ,” ନା ମୁନେକଞ୍ଜ୍‍ ଇ ସାରେ ଗଟି ମାନେମ୍‍ ଆସ ୱାସ୍‍ମିନ୍ଦେନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜିସୁ ଅନ୍‌‍ପାକେ ପ୍ରେମତେ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, “ଅଣ୍ଡୟ୍‌ ବିଷୟ୍‍ ମାତର୍ ନିୟାଦ୍‍ ଅବାବ୍‍ ମିନ୍ଦେ । ଆନ୍‌‍ ନିୟାଦ୍‍ ସାରେ ସମ୍ପତ୍ତି ୱାମ୍ମି ଆ ଦନ୍‍ତିଙ୍କ୍‍, ଗରିବିଡ଼୍‍କ୍‍ ଇମ୍‍, ଆଲାଇତ୍କେ ମିଡ଼୍‍ ସ୍ୱର୍ଗତେ ଦନ୍‍ ପାହେମ୍‍ ଆଦ୍‍ତିନ୍‍ । ତାନ୍‍ପେର୍କେ ୱାସ୍‍ ନା ପେର୍କେ ୱାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ଇ ଗଟ୍‍ କେଞ୍ଜୱାନାକେ ଆ ନାରୁନ୍‍ ମକମ୍‍ତାଗ୍‍ ମୁର୍‍ମୁର୍‍ ଆସ୍‍ ଆତ୍‍ତନ୍‍ ନୁ ଅଣ୍ଡ୍‌ ଦଃକମ୍‍ତେ ଆତ୍‍ତଣ୍ଡ୍‍, ବାତେଙ୍କ୍‌ ଇତ୍କେ ଅଣ୍ଡ୍‌ ବେଡ଼୍‍ୟ୍‍ ଦନି ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ଜିସୁ ଶିଷ୍ୟଡ଼ା ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ଡାବ୍‌ କିନ୍‌ ସାଉକାରିଡ଼୍‌ ସର୍ଗରାଜ୍ୟତାଗ୍‍ ଆଦାଙ୍କ୍‍ ବେସର୍‍ ତିପପାଲ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଇଦ୍‍ କେଞ୍ଜି ଶିଷ୍ୟଡ଼୍ ବିସ୍ମିତ ଆତ୍‍ତଡ଼୍‍ । କିନ୍ତୁ ଜିସୁ ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍, “ଶିଷ୍ୟନଡ଼ି, ବାସ୍ତବିକ୍‍ ସର୍ଗରାଜ୍ୟତାଗ୍‍ ଆଦାଙ୍କ୍‍ ବେସର୍‍ ତିପ୍‍ପାଲ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ଦନି ନାରୁଣ୍ଡ୍‍ ସର୍ଗରାଜ୍ୟତାଗ୍‍ ଆଦାନ୍‍ ୱିଡ଼୍‌ସି ଉଟ୍‍ ସୁଜ୍‍ତେ ବସ୍‌ଇଷ୍‌ ଆଦାଙ୍କ୍‍ ଗାଟି ସହଜ୍‍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ଇ ଗଟ୍‍ତେ ଶିଷ୍ୟଡ଼୍ ଗାଟି ବକୁୱା ଆସ୍‍ ନିଜ୍‍ ନିଜ୍‍ତିଙ୍କ୍‍ ପାଚାରା ମାଡ଼୍‍ତଡ଼୍‍, “ଆଲାଇତ୍କେ ବେନ ପରିତ୍ରାଣ ପହେମ୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ସିଦା ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ନାରୁନ୍‍ ପାକେ ଇଦ୍‍ ଆଦ୍‍ପାର୍‍ୱ; ଇଶ୍ୱର ସାରେ ମାଡ଼୍‍ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ଇ ଗଟ୍‍ କେଞ୍ଜି ପିତର୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଉଡ଼ା, ମାମ୍‍ ସାରେ ୱିଡ଼୍‍ସି ନି ପେର୍କେ ୱାତ୍‍ତମ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ନାନ୍‍ ମିକିଂଙ୍କ୍‍ ସତ୍‍ କେସ୍‍ ନେହ୍‍ତୁତାନ୍‍, ନା ମାଇଦିଙ୍କ୍‍ ନୁ ‘ସୁସମାଚାର୍‍’ ମାଇଦିଙ୍କ୍ ବେନଆଇ ଲୋନ୍‌‍, ତାମୁଣ୍ଡ୍‌, ଏଲାଡ଼୍‍, ବାବାଲ୍‍, ୟାୟ, ପିଲା ବା ଅନାଦ୍‌‍ ୱାୟା ସାରେ ୱିଡ଼୍‍ସିତଣ୍ଡ୍‍, ଇ ଜିୱୁନ୍‍ତେ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ନାର୍‍ଗେ ପାହେମ୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ଇସତ୍‍ ଲୋନ୍‌‍, ତାମୁଣ୍ଡ୍‌ ଏଲାଡ଼୍‍, ୟାୟ, ପିଲା, ୱାୟାନ୍‍ ଶହେ ଗୁଣ ପାହେମ୍‍ ଆଦାନ୍‍ ତଡ଼୍‍ ତିପାଲ୍‍ ଆନ୍‌ତେ ବଗେମ୍‍ଆଦ୍‍ତଣ୍ଡ୍‍; କିନ୍ତୁ ଅଣ୍ଡ୍‌‍ ଆକାଲାତେ ଅନନ୍ତ ଜିୱୁନ୍‍ ଲାବ୍‍ ମାଡ଼ିତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ବେନଡ଼୍‍ ଇଞ୍ଜେ ମୁନ୍‍ ମିନ୍ଦେଡ଼୍‍, ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍‍ ନାର୍ଗେ ପଡ଼େମ୍‍ ଆଦ୍‍ତଡ଼୍‍ ନୁ ବେନଡ଼୍‍ ଇଞ୍ଜ୍‍ ପେର୍କେ ମିନ୍ଦେଡ଼୍‍; ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍‍ ନାର୍ଗେ ମୁନ୍‍ ଆଦ୍‍ତଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ତାନ୍‍ପେର୍କେ ଜିସୁ ନୁ ତାନ୍‍ ଶିଷ୍ୟଡ଼୍ ଜିରୁଶାଲାମ୍‍ ଆର୍‍ଦାଲା ଆତ୍‍ତଡ଼୍‍ ଜିସୁ ଶିଷ୍ୟଡ଼୍ ମୁନ୍‍ମୁନ୍‍ ଆଞ୍ଜ ମାତ୍‍ତଣ୍ଡ୍‍, ଶିଷ୍ୟଡ଼୍ ୱେର୍‍ସ୍‍ ଆସ୍‍ ମାତ୍‍ତଡ଼୍‍ ନୁ ପେର୍କେ ତାକାନ୍‍ ୱେରେ ନାରୁଡ଼୍‍ ଆନ୍‌ତେ ୱେର୍‍ସ୍‍ ମାତ୍‍ତଡ଼୍‍ । ଜିସୁ ମେଣ୍ଡନ୍‍ ଦାମ୍ ତାନ୍‍ ବାରଜାନ୍‍ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ଅଣ୍ଡୟ୍‌‍ ଆଗେ କାର୍ଙ୍ଗି ବବିଷ୍ୟତ୍‍ତେ ଅଡ଼୍‌‍ ପ୍ରତି ବାତେ ସାୟ୍‍ ଗଟେମ୍‍ ଆଦ୍‍ତେ, ଆ ବିଷୟ୍‍ତେ ଅଣ୍ଡ୍‌‍ କେତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“କେଞ୍ଜାଟ୍‍, ମାମ୍‍ ଜିରୁଶାଲାମ୍‍ତା ଆଦୁତମ୍ । ଆଗେ ମନୁଷ୍ୟପୁତ୍ର ବେଡ଼ିୟି ଦର୍ମପୁରହିତ ନୁ ଦର୍ମଗୁରୁଡ଼୍‍ କାଇଦେ ସମର୍ପିତ ଆଦ୍‍ତଣ୍ଡ୍‍ । ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଡଲାନ୍‍ ଦଣ୍ଡ ଇସ୍‍ ଅଣଇହୁଦୀଡ଼୍‍ କାଇଦେ ୱିଡ଼୍‍ସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ପରିହାସ୍‍ ମାଡ଼ିତଡ଼୍‍, ଅନ୍‌‍ପର୍ ଉସିତଡ଼୍‍, ଅଂକିଙ୍କ୍‌ କୋରଡାତେ ରେହ୍‍ତିତଡ଼୍‍ ନୁ ଆୱ୍‍କିତଡ଼୍‍, କିନ୍ତୁ ମୁଣ୍ଡ୍‍ଦିନା ପେର୍କେ ଅଣ୍ଡ୍‌‍ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଦିତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ଅଣ୍ଡ୍‌‍ଦିନେ ଜେବତିନ୍‍ ଇର୍‍ୱୁଡ଼୍‍ ମାର୍କ୍ ଯାକୁବ ନୁ ଯୋହନ୍‌‌ ଜିସୁଙ୍କ୍‍ କେତ୍‍ତଡ଼୍‍, “ଗୁରୁ, ନିମେ ମା ମାଇଦିଙ୍କ୍‍ ବାତ୍‍ ମାଡ଼ା, ଇଦ୍‍ ମାମ୍‍ ଇଚ୍ଛା ମାଡ଼ୁତମ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ଜିସୁ ପଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ବାତ୍‍ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ଅଡ଼୍‌‍ ଉତ୍ତର୍‍ ଇତ୍‍ତଡ଼୍‍, “ଗୌରବମୟ ରାଜ ସିଂହାସନତାଗ୍‍ ନିମେ ବେସୁଙ୍କ୍‍ କୁଦିତି, ମା ଲୋପେଙ୍କ୍‍ ଅର୍‌ତୁଙ୍କ୍‌ ନି ତିନ୍ଦେପାକେ ନୁ ମେଣ୍ଡ୍‍ଅର୍‌ତୁଙ୍କ୍‌ ଡେବ୍‍ବେ ପାକା କୁଦାଙ୍କ୍‍ ଇମ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ କେତ୍‍ତଣ୍ଡ୍‍, “‍ମିଡ଼୍‍ ବାତା ତାଲ୍‍କୁତିଡ଼୍‍, ପୁନ୍‍ୱିଡ଼୍‍ । ନାନ୍‍ ବେନ୍‍ ଦୁଃକ ବଗତେ ପାନପାତ୍ରତାଗାଙ୍କ୍‍ ଉନ୍ଦାଙ୍କ୍‍ ଆଞ୍ଜମିନ୍ଦେନ୍‍, ଆଗାକଞ୍ଚ୍‍ ମିଡ଼୍‍ ଉନ୍ଦ୍‍ପାର୍‍ଦ୍‍ତିଡ଼୍‍ ? ନାନ୍‍ ବେଲା ତିପାଲ୍‌ ଆଦାଙ୍କ୍‍ ଆଞ୍ଜମିନ୍ଦେନ୍, ଆ ଦିକ୍ଷା ମିଡ଼୍‍ ବାତ୍‍ ଅଦେ ପାର୍‍ଦ୍‍ତିଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ନାନେ ବେନ୍‍ ପାନପାତ୍ର ଉନ୍ଦାଙ୍କ୍‌ ଆସ ମିନ୍ଦେମ୍‌ ମିଡ଼୍‌ ବାତେ ଅଦ୍‍ ଉନ୍ଦାଙ୍କ୍‌ ପାର୍‌ତିଡ଼୍, ଅଡ଼୍‌‍ ପାର୍‌ତମ୍‌ ଇଞ୍ଜ କେତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ବାସ୍ତବିକ ମିଡ଼୍‍ ନା ପାନପାତ୍ରତାଗାଙ୍କ୍‍ ଉନ୍ଦ୍‍ତିଡ଼୍‍ ନୁ ନା ଲେକାମ୍‍ ତିପାଲ୍‌ ଆଦ୍‍ତିଡ଼୍‍, କିନ୍ତୁ ନା ତିନ୍ଦେପାକେ ବା ଡେବ୍‍ବେ ପାକା ବେନ କୁଦିତିତଡ଼୍‍, ଇଦ୍‍ ସ୍ଥିର୍‌ ମାଡ଼ାଙ୍କ୍‍ ନା ଅଦିକାର୍‌‍ ଇଲେ । ବେନଡ଼୍‍ ମାଇଦିଙ୍କ୍‍ ଇଶ୍ୱର ଆ ଜାଗା ତିଆର୍‍ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍‍, ଆଦ୍‍ ଅଣ୍ଡ୍‌‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଇଦ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ଇ ସାରେ ଗଟ୍‍ କେଞ୍ଜି ଦଶ୍‍ଜାନ୍‍ ଶିଷ୍ୟଡ଼୍ ଯାକୁବ୍ ନୁ ଯୋହନ୍‌‌ତେ ପର୍‌ କପାମ୍‍ ଆତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଅଣ୍ଡୟାଗେ କାର୍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍‍, “ମିଡ଼୍ ପୁନୁଟ୍‍, ଇ ଜଗତ୍‍ତାଗ୍‍ ଶାସକିଡ଼୍‍ ନାରୁଡ଼୍‍ ଲୋପେ ମାପୃଇନା ମାଡ଼ିତଡ଼୍‍ ନୁ ନେତାଲଡ଼୍‍ ବିଜାତିଡ଼୍‍ ପର ଶାସନ୍‍ ମାଡ଼ିତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","କିନ୍ତୁ ମିଡ଼୍‍ ଇ ନିତିତେ ଚାଲେମ୍‍ ଆୟ୍‍ୱିଡ଼୍‍ । ମି ଲୋପେଙ୍କ୍‍ ଅର୍‍ତୁଣ୍ଡ୍‍ ଯଦି ବେଡ଼୍‍ୟଣ୍ଡ୍‍ ଆଦାଙ୍କ୍‍ ଚାହେମ୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌‍ ୱେର୍‍ଅର୍‍ତୁଣ୍ଡ୍‍ ସେବକ ଆଇଣ୍ଡ୍‍ ");
INSERT INTO kff_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ମେଣ୍ଡେ ମି ଲୋପେଙ୍କ୍‍ ଯଦି ଅର୍‍ତୁଣ୍ଡ୍‍ ମୁନେତ୍‌ ଜାଗା ଅଦିକାର୍ ମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍କେ, ଅଣ୍ଡ୍‌‍ ଅଡ଼୍‌‍ ଦାସତ୍‍ ଲେକାମ୍‍ ଆଇଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ନାରୁଡ଼୍‌ ପିଲେଆନ୍ତେ ସେବା ପାହେମ୍‍ ଆଦାଙ୍କ୍‍ ୱାଡ଼ଣ୍ଡ୍, କିନ୍ତୁ ସେବା ମାଡ଼ାଙ୍କ୍‍ ନୁ ସାରେତଡ଼୍‍ ମୁକ୍ତିତେ ମୁଲ୍ୟ ଲେକାମ୍‍ ନିଜର୍‍ ଜିୱୁନ୍‍ ଉସର୍ଗ ମାଡ଼ଙ୍କ୍‍ ୱାସ୍‍ମିନ୍ଦ୍‍ଦେଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ଜିସୁ ନୁ ତାନ୍‍ ଶିଷ୍ୟଡ଼୍ ଯିରୀୟତାଗ୍‍ ୱାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌‍ ଆ ଟାଉନ୍‍ତିଙ୍କ୍‍ ୱିଡ଼୍‍ସି ଆଦାନ୍‍ ୱେଲେ ନାର୍ଗେ ନାରୁଡ଼୍‍ ଅନ୍‌‍ ପେର୍କେ ଆତ୍‍ତଡ଼୍‍ । ଟିମୟର୍‍ତେ ମାର୍‍ ବାର୍ଟିମୟ ପେଦେର୍‍ତେ ଅର୍‍ତୁଣ୍ଡ୍‍ କାନାଲ୍‌ ବିକାରି ଆର୍‍ଦାଗ୍‍ କୁଦିମାତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ନାଜରିତିୟ ଜିସୁ ଆ ଆର୍‍ ଆଦୁତଣ୍ଡ୍‍ ଇଞ୍ଜ କେଞ୍ଜି ଅଣ୍ଡ୍‌‍ ଗାଟି ଲେଙ୍ଗ୍‌ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, “ହୋ ଦାଉଦ୍‍ତେ ମାର୍‍ ଜିସୁ ନାକିଙ୍କ୍‍ ଦୟା ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ନାରୁଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଦମକା ମାଡ଼ି କଟ ମାନ୍ଦାଙ୍କ୍‍ କେତ୍‍ତଡ଼୍‍, କିନ୍ତୁ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ଗାଟିଲେଙ୍ଗ୍‍ କାର୍ଙ୍ଗ୍‍ତଣ୍ଡ୍; “ହୋ ଦାଉଦ୍‍ତେ ମାରିନ୍‍ ଜିସୁ, ନାକିଙ୍କ୍‍ ଦୟା ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ଜିସୁ ନିସ୍‌ ମିକା କେତ୍‍ତଣ୍ଡ୍‍, “ଅଂକିଙ୍କ୍‌ କାର୍ଙ୍ଗ୍‍ଗାଟ୍‍ ।” ନାରୁଡ଼୍‍ କାନାଙ୍କ୍‍ କାର୍ଙ୍ଗି କେତ୍‍ତଡ଼୍‍, “ଦାନ୍ଦ୍‍ ଆୟ୍‍ମା, ତେଦିୱାଡ଼ା, ଅଣ୍ଡ୍‌‍ ନିକିଙ୍କ୍‍ କାର୍ଙ୍ଗ ମିନ୍ଦେଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","କାନାଲ୍‌ ତାନ୍‍ ଚାଦର୍‍ ହେସି ୱେଡ଼୍‌କେତେ ତୁଲ୍ଲି ଜିସୁନ୍‍ ଗାରେ ଏୱ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜିସୁ ଅଂକିଙ୍କ୍‌ ପାଚାରା ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ନି ମାଇଦିଙ୍କ୍‍ ନାନେ ବାତେ ମାଡ଼ିତାନ୍‍ ଇଞ୍ଜ ଇଚ୍ଛା ମାଡ଼ୁତି ?” କାନାଲ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଗୁରୁ ! ନାନ୍‍ ଉଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ଇଚ୍ଛା ମାଡ଼ୁତାନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‍, “ଅନ୍‌‍, ନି ବିଶ୍ୱାସ୍‍ ନିକିଙ୍କ୍‍ ସାୟ୍‍ ମାଡ଼୍‍ତେ ।” ସାଙ୍ଗେ ସାଙ୍ଗେ କାନାଲ୍‌ ତାନ୍‍ ଉଡ଼ାନ୍‍ ଶକ୍ତି ପାହେମ୍‍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ଅଣ୍ଡ୍‌‍ ଆନ୍ତେ ଜିସୁନ୍‍ ପେର୍କେ ପେର୍କେ ତାକ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଅଡ଼୍‌‍ ଯିରୁଶାଲାମ୍‍ତେ ଗାରେ ଏୱ୍‍ସ୍‍ ବେତ୍‍ପାଗୀ ନୁ ବେତାନି ନାର୍‍ଦେ ପରୁତ୍‌ ପାକେ ମାନ୍ଦାନ୍‍ ଜିତମେଟେତ୍‍ ଗାରେ ଏୱ୍‍ତଡ଼୍‍ । ଜିସୁ ତାନ୍‍ ଇର୍‍ୱୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ନିର୍ଦେଶ୍‍ ଇସ୍‍ ମୁନେଙ୍କ୍‍ ରୟ୍‍ସ୍‍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ମୁନ୍‍ ମାନ୍ଦାନ୍‍ ନାର୍‍ କି ନାଗ୍‍ ଆନୁଟ୍‍, ଆଗେ ଏୱ୍‍କେ ବେନ ବେସୁଙ୍କ୍‍ ତାରକଟ ମାନ୍ଦାନ୍‍ ଅଣ୍ଡୟ୍‌‍ ଗଦ ପିଲ୍‍ତିଙ୍କ୍‍ ତହ୍‍ସ୍‍ ମାନ୍ଦାନାଦ୍‍ ଉଡ଼ିତିଡ଼୍, ତାଙ୍କ୍‍ ଲେୟ୍‍ସ୍‍ ନା ଗାରେ ପୟ୍‍ସ୍‍ ତାଡ଼ାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","‘ବାତେଙ୍କ୍‍ ଇଦ୍‍ ମାଡ଼ୁତିଡ଼୍‍’ ଇଞ୍ଜ ବେନ ଯଦି ପାଚାରା ମାଡ଼୍‍ କ; ଅଂକିଙ୍କ୍‌ କେତିତିଡ଼୍‍, ‘ଗୁରୁଙ୍କ୍‍ ଦର୍‍କାର୍‍ ମିନ୍ଦେ ନୁ ସିଟ୍‍ପାଟ୍‍ ଆଦିଙ୍କ୍‍ ମାଲ୍‍ପିଦ୍‍ତଡ଼୍‍ ।’” ");
INSERT INTO kff_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ଅଡ଼୍‌‍ କେତ୍‍ତେ ନାର୍‍ ଆଞ୍ଜ୍‍ ଉଡ଼୍‌ତଡ଼୍‍ ଅଣ୍ଡୟ୍‌‍ ଗଦ ପିଲ୍‍ ନାର୍‍ଦେ ଦୁୱାଡ଼୍‍ତାଗ୍‍ ଅଣ୍ଡୟ୍‌‍ ଆର୍‍ଦାଗ୍‍ ତହ୍‍ସ୍‍ ମିନ୍ଦେଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ଆଦିଙ୍କ୍‍ ଲେତାନ୍‍ୱେଲେ ଗାରେ ନିସ୍‍ ମାନ୍ଦାନ୍‍ ବେସ୍‌କ୍ ତଡ଼୍‍ କେତ୍‍ତଡ଼୍‍, “ବାତ୍‍ ମାଡ଼ୁତିଡ଼୍‍, ଗଦ ପିଲ୍‍ତିଙ୍କ୍‍ ଲେତୁତିଡ଼୍‍ ବାତେଙ୍କ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ଜିସୁ କେସ୍‍ମାନ୍ଦାନ୍‍ ଲେକାମ୍‌ ଶିଷ୍ୟଡ଼୍ ଉତ୍ତର୍ ଇତ୍‍ତଡ଼୍‍ ନୁ ନାର୍‍ଦେନଡ଼୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ୱିଡ଼୍‍ସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ଶିଷ୍ୟଡ଼୍ ଗଦ ପିଲ୍‍ତିଙ୍କ୍‍ ତାସ୍‍ ମେନ୍ଦୁଲ୍‍ତାଗ୍‍ ନିଜର୍‍ ସିଲେ ତାରିତ୍‍ତଡ଼୍‍ ନୁ ଜିସୁ ତାନ୍‍ ପର କୁଦ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ବେସ୍‍କ୍‍ତଡ଼୍ ଆର୍‍ଦେ ପର ଆନ୍ତେ ନିଜର୍‍ ସିଲେ ତାରିତ୍‍ତଡ଼୍‍ । ବାଗାତଡ଼୍‍ ମାଡ଼େତ୍‍ କମା ସାରେ ନାଡ଼୍‍କି ଆର୍‍ଦେ ପର ୱାଟ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଜିସୁନ୍‍ ମୁନେ ନୁ ପେର୍କେ ଆଦାନ୍‍ ନାରୁଡ଼୍‍ ବେଡ଼୍‍ୟ୍‍ ଲେଙ୍ଗ୍‍ଦେ କେତାଙ୍କ୍‍ ପସ୍ପ୍‍ତଡ଼୍‍, ପ୍ରସଂଶା ");
INSERT INTO kff_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“ପ୍ରବୁନ୍‍ ପେଦେର୍‍ତେ ବେନ ୱାଦୁତଣ୍ତ୍‌, ଅନାଦ୍‌‍ ପ୍ରସଂଶା ଆୟି । ମେଣ୍ଡେ ତିଆର୍‍ ଆଦାଙ୍କ୍‍ ଆଞ୍ଜମାନ୍ଦାନ୍‍ ମା ବାବାଲ୍‍ ଦାଉଦ୍‍ ରାଜାନ୍‍ ରାଜ୍ୟତିଙ୍କ୍‍ ଇଶ୍ୱର ଆର୍ଶିବାଦ୍‌ ମାଡ଼ିଣ୍ଡ୍‍ । ଇଶ୍ୱର୍‌ତେ ଗୌରବ୍ ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ଜିସୁ ଯିରୁଶାଲାତାଗ୍‍ ନେଙ୍ଗ୍‍ତଣ୍ଡ୍‍ ନୁ ମନ୍ଦିର୍‍ତାଗ୍‍ ଆଞ୍ଜ୍‍ ସାରେପାକା ଉଡ଼୍‍ତଣ୍ଡ୍‍ । କିନ୍ତୁ ଆସୁଟ୍‍ ମୂଲ୍‍ପୁଟ୍‍ ଆସ ମାନ୍ଦାନ୍‍ ମାଇଦିଙ୍କ୍‍ ବାରଜାନ୍‍ ଶିଷ୍ୟଡ଼୍ ତ ଜିସୁ ବେତାନି ନାର୍‍ଦା ଆତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ତାନ୍‍ ମେଣ୍ଡନ୍‍ ଦିନେ ଅଡ଼୍‌‍ ବେତାନିତାଗାଙ୍କ୍‍ ମାଲ୍‍ଦାନ୍‍ ୱେଲେ ଜିସୁ କାର୍‍ୱିଙ୍କ୍ ଆତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ଅଣ୍ଡୟ୍‌‍ ତୟ୍‍ ମାଡ଼୍‍ତାଗ୍‍ ନାର୍ଗେ ଆକି ମାନ୍ଦାନାଦ୍ ଅଣ୍ଡ୍‌ ଜୁୟ୍‍କଙ୍କ୍‍ ଉଡ଼୍‍ତଣ୍ଡ୍‍ । ଆଗେ କାୟା ମିନ୍ଦେ କି ଇଲ୍‌ଲେ, ଉଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ଜିସୁ ତାନ୍‍ ଗାର୍‍ରେ ଆତ୍‍ତଣ୍ଡ୍‍ । ଆଗେ ଆକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ବାତ୍‍ ମେଣ୍ଡେ ଉଡ଼ଣ୍ଡ୍‍, କାରନ୍‍ ଆସୁଟ୍‍ ତୟା ଆଦାନାଦ୍‍ ସମୟ୍‍ ଏୱକଟ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ଜିସୁ ଆ ମାଡ଼୍‍ତିଙ୍କ୍‍ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, “ନିୟାଗାଙ୍କ୍‍ ବେନ ମେଣ୍ଡେ ବେସୁଙ୍କ୍‌ବା କାୟା ତିନ୍ଦାନଙ୍କ୍‍ ପାହେମ୍‍ ଆୟଡ଼୍‍ ।” ଶିଷ୍ୟଡ଼୍ ଇଦ୍‍ କେଞ୍ଜ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ଅଡ଼୍‌‍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଏୱ୍‍ସ୍‍ ମନ୍ଦିର୍‍ତେ ଲୋପେ ଆତ୍‍ତଡ଼୍‍ ନୁ ଆଗେ ଆସାନ୍ ୱାମାନ୍ ମାଡ଼ାନ୍‍ ନାରୁଡ଼୍‍କିଙ୍କ୍‍ ଜିସୁ ବାୟ୍‍ଦେ ପେସ୍ପିତ୍‍ତଣ୍ଡ୍‍ । ମୁଦ୍ରା ବ୍ୟବସାୟି ମାଡ଼ମାନ୍ଦାନ୍‍ ନାରୁଡ଼୍‍ତେ ବେଞ୍ଚ୍‍ ନୁ ପାର୍‍ୱା ୱାମନ୍‍ନାରୁଡ଼ାଦ୍‍ ଟେଙ୍ଗା ସାରେ ମିଇସିତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ମନ୍ଦିର୍‍ତେ ଦୁୱାଡ଼୍ ଇସ୍‍ ଜିନିଷପତ୍ର ଅଦା ତାତ୍‍ତା ମାଡ଼ାଙ୍କ୍‍ ବେନଙ୍କ୍ ବା ୱିଡ଼୍‍ସଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ତାନ୍‍ ପେର୍କେ ଜିସୁ ନାରୁଡ଼୍‍କିଙ୍କ୍‍ ଶିକ୍ଷାଇସ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ଦର୍ମଶାସ୍ତ୍ରତାଗ୍‍ ଲେକା ମିନ୍ଦେ, ‘ନା ମନ୍ଦିର୍‍ ସାରେ ଦେଶ୍‍ ନାରୁଡ଼୍‍ ମାଇଦିଙ୍କ୍‍ ପ୍ରାର୍ତନା ଲୋନ୍‌‍ ଇଞ୍ଜ ପେଦେର୍‍ ଆଦ୍‍ତେ,’ କିନ୍ତୁ ମିଡ଼୍‍ ଆଦିଙ୍କ୍‍ ଡ଼ଙ୍ଗାନ୍‍ ଲୋନ୍‌‍ ମାଡ଼୍‍ତିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ବେଡ଼େଇ ଯାଜକ୍‌ ନୁ ଶାସ୍ତ୍ରୀଡ଼୍‍ ଇଦ୍‌ ଗଟନା ବିଷୟ୍‍ତେ କେଞ୍ଜି ଜିସୁଙ୍କ୍‍ ଆୱୁକାଙ୍କ୍‍ ଉପାୟ୍‍ ମେହେକାଙ୍କ୍‍ ପସ୍ପ୍‍ତଡ଼୍‍ । ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍‍ ୱେର୍‍ସ ମାତ୍‍ତଡ଼୍‍ । କାରନ୍‍ ନାରୁଡ଼୍ ଅନ୍‌‍ ଶିକ୍ଷାତେ ଆଶର୍ଯ୍ୟ ଆତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ଆ ଦିନ୍‍ ମୂଲ୍‍ପୁଟ୍‍ ୱେଲେ ଜିସୁ ନୁ ତାନ୍‍ ଶିଷ୍ୟଡ଼୍ ଟାଉନ୍‍ତିଙ୍କ୍‍ ୱିଡ଼୍‍ସି ଆତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ତାନ୍‍ମେଣ୍ଡ ଦିନ୍‍ ନାର୍‌କୁକେ ଅଡ଼୍‌‍ ଆର୍‍ଦାଲା ଆଦାନ୍‍ୱେଲେ ଉଡ଼୍‌ତଡ଼୍‍ ଆ ତୟା ମାଡ଼୍‍ ମଦଲ୍‍ କଞ୍ଚ୍‍ ୱାସିମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ମୁନେତ୍‍ ଦିନାତ୍‍ ଗଟ୍‍ ହେର୍କେ ମାଡ଼ି ପିତର୍‍ ଜିସୁଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଗୁରୁ ଉଡ଼େ ନି ତଡ଼୍‍ ଅବିଶାପ୍‍ ଆସ୍‍ମାନ୍ଦାନ୍‍ ତୟା ମାଡ଼୍‍ ଡଲିମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ଇଶ୍ୱର୍‍ ତିଙ୍କ୍‍ ବିଶ୍ୱାସ୍‍ ମାଡ଼ାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ନାନ୍‍ ନିଜାମ୍‍ ମିକିଂଙ୍କ୍‍ କେତୁତାନ୍‍, ଯଦି ବେନ ଇ ମେଟେତିଙ୍କ୍‍ ତେଦିଆଞ୍ଜ୍‍ ସନ୍ଦୁର୍‍ତାଗ୍‍ ରାଲାନ୍‍ ମାଇଦିଙ୍କ୍‍ କେତିତଣ୍ଡ୍ ନୁ ମନ୍‍ଦାଗ୍‍ ସନ୍ଦେହ ନେହ୍‍ୱକଟ, ଅଣ୍ଡ୍‌‍ ବାତେ କେତ୍‍ତଣ୍ଡ୍‍, ଆଦ୍‍ ଆଦ୍‍ତେ ଇଞ୍ଜ ବିଶ୍ୱାସ୍‍ ମାଡ଼ିତଣ୍ଡ୍‍, ଆଲାଇତ୍କେ ଆଦ୍‍ ନିଜାମ୍‍ ଗଟେମ୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଅଦିନ୍‌ ମାଇଦିଙ୍କ୍‍ ନାନ୍‍ କେତୁତାନ୍‍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍‍ ୱେଲେ ବାତ୍‍ ତାଲ୍‍କୁତିଡ଼୍‍, ଆୱ୍‍ ଦର୍‍କ୍‍ତା ଇଞ୍ଜ ବିଶ୍ୱାସ୍‍ ମାଡ଼ାଟ୍‍, ଆଲାଇତ୍କେ ଆୱ୍‍ ମିଡ଼୍‍ ନିଜାମ୍‍ ପାହେମ୍‍ ଆଦ୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ପ୍ରାର୍ତନା ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ନିତ୍‍ତେ ୱେଲେ, ଯଦି ବେନନ୍ ବିରୁଦ୍‍ତେ ମିୟାଦ୍‍ ବାତେ କେତାନାଦ୍‍ ମାନ୍ତ୍‍ତେ, ଆଦିଙ୍କ୍‍ କ୍ଷେମା ମାଡ଼ିମୁଟ୍‍ । ଆଲାଇତ୍କେ ମି ସ୍ୱର୍ଗତେ ବାବାଲ୍ ଇଶ୍ୱର୍ ମିୟାଦ୍‍ ସାରେ ଦଷ୍ କ୍ଷେମା ମାଡ଼ିତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","କିନ୍ତୁ ମିଡ଼୍‍ ଯଦି ୱେର୍‍ତଡ଼୍‍କିଙ୍କ୍ କ୍ଷେମା ମାଡ଼୍‍ୱିଡ଼୍‍, ମି ସ୍ୱର୍ଗତେ ବାବାଲ୍‍ ଆନ୍‌ତେ ମି ପାପ ଆନ୍ତେ କ୍ଷେମା ମାଡ଼ଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ଅଡ଼୍‌‍ ମେଣ୍ଡନ୍‍ ଦାମ୍‍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ୱାତ୍‍ତଡ଼୍ । ଜିସୁ ମନ୍ଦିର୍‍ତେ ଲୋପେ ଉଡମାନ୍ଦାନ୍‍ ସମୟ୍‍ତେ ମୁକ୍ୟ ପୁରହିତ, ଦର୍ମଗୁରୁ ନୁ ଇହୁଦି ଦର୍ମନେତାଲଡ଼୍‍ ଅନ୍‌‍ ଗାରେ ୱାସ୍‍ ପାଚାରାମାଡ଼୍‍ତଡ଼୍‍, ");
INSERT INTO kff_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ଇ ସାରେ ପାଡ଼୍‌ୟି ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ନିୟାଦ୍‍ ବାତେ ଅଦିକାର୍‌‍ ମିନ୍ଦେ ? ନିକିଙ୍କ୍‍ ଇ ଅଦିକାର୍‌‍ ବେନ ଇତ୍‌ତଣ୍ଡ୍‌‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ମିକିଂଙ୍କ୍‍ ଅଣ୍ଡୟ୍‌‍ ପ୍ରଶ୍ନ ପାଚାରାମାଡ଼ିତାନ୍‍ । ଯଦି ତାନ୍‍ ଉତ୍ତର୍‍ ଇଦ୍‍ପାର୍‍ଦ୍‍ତିଡ଼୍‍, ଇ ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ନାୟାଦ୍‍ ବାତ୍‍ ଅଦିକାର୍‌‍ ମିନ୍ଦେ, ଆଦ୍‍ ମିକିଂଙ୍କ୍‍ କେତିତାନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ବାପ୍ତିସ୍ମ ଇଦାନ୍‍ ଯୋହନ୍‌‌ ବେନନାଗାଙ୍କ୍ ଅଦିକାର୍‌ ପାହେମ୍ ‍ଆସ୍‍ମାତ୍‍ତଣ୍ଡ୍‍, ଇଶ୍ୱର୍‍ତାଗାଙ୍କ୍‍ ନା ନାରୁଡ଼୍‍ ଡ଼ାଗାଙ୍କ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ଅଡ଼୍‌‍ ନିଜର୍‍ ନିଜର୍‍ ଲୋପେ ରାମ୍‍କ୍ ମାଡ଼ାଙ୍କ୍‍ ପସ୍ପ୍‍ତଡ଼୍‍, “ଇ ଗଟ୍‍ତେ ବାତ୍‍ ଉତ୍ତର୍‍ ଇଦ୍‍ତାଡ଼୍‍ ?” ଯଦି କେତିତାଡ଼୍‍, “ଇଶ୍ୱର୍‍ତାଗାଙ୍କ୍‍,” ଯୋହନ୍‌‍ତିଙ୍କ୍‍ ମାଡ଼୍ ବାତେଙ୍କ୍‍ ବିଶ୍ୱାସ୍‍ ମାଡ଼୍‍ୱାଡ଼୍‍ ଇଞ୍ଜ ଅଣ୍ଡ୍‌‍ ପାଚାରାମାଡ଼ିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ଯଦି କେତିତାଡ଼୍‍, “ନାରୁଡ଼୍‍ଡ଼ାଗାଙ୍କ୍‍” ଅଡ଼୍‌‍ ନାରୁଡ଼୍‍କ୍‍ ୱେର୍‍ସ ମାତ୍‍ତଡ଼୍‍, କାରନ୍‍ ସାରେତଡ଼୍ ପୁଞ୍ଜ୍‍ ମାତ୍‍ତେ ଯେ, ଯୋହନ୍‌‌ ଇଶ୍ୱର୍‌ତେ ଅର୍‍ତୁଣ୍ଡ୍‍ ବାବବାଦୀ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍‍ ଉତ୍ତର୍‍ ଇତ୍‍ତଡ଼୍‍, “ମାମ୍‍ ପୁନମ୍‍ ।” ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ବେନ୍‍ ଅଦିକାର୍‌‍ତେ ହିୱୁସାରେ ମାଡ଼ୁତାନ୍‍, ନାନ୍‍ ମିକା ମିକିଙ୍କ୍ କେଲନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ତାନ୍‍ପେର୍କେ ଜିସୁ ୱେଷଡ଼୍‍ ଇସ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଅଣ୍ଡୟ୍‌‍ୟାଗ୍‍ ଅର୍‍ତୁଣ୍ଡ୍‍ ନାରୁଣ୍ଡ୍ ୱେରଡ୍‍ ଅଙ୍ଗୁର୍‌ୱାୟେ ଆରାମ୍‍ ମାଡ଼ି ତାନ୍‍ ତିଡ଼ିୟିପାକା ୱେଲୁମ୍‍ କୁର୍‍ଦୁତଣ୍ଡ୍‍ । ଅଙ୍ଗୁର୍‍କିନ୍‍ ମାଇଦିଙ୍କ୍‍ ଅଣ୍ଡୟ୍‌‍ ଗୁୟ୍‍ନ୍ଦେ ଡେୱ୍‍ତଡ଼୍ ନୁ କେପାନଡ଼୍‍ ମାଇଦିଙ୍କ୍ ଡଡ୍‍ ତହ୍‍ତଡ଼୍‍ । ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ କ୍ଷେତତିଙ୍କ୍‍ ବାଗ୍‍ ଚାଷିଡ଼୍‍ କାଇଦେ ୱିଡ଼୍‍ସିସ୍‍ ଦୁରାମ୍‍ ପଡ଼୍‍ୟ୍‍ତାଗ୍‍ ଆତ୍‍ତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ଆସୁଟ୍‍ ଅଙ୍ଗୁର୍‌ ଆଦାୟ୍‍ ମାଡ଼ାନ୍‍ ସମୟ୍‍ ୱାତ୍‍ତେ, ନିଜର୍ ବାଗ୍‍ ଆଦାୟ୍‍ ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍ ୱେରଣ୍ଡ୍‍ ଦାସ୍‍ତିଙ୍କ୍‍ ଅଡ଼୍‌‍ ଗାରେ ରହ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ଚାଷିଡ଼୍‍ ଆ ଦାସ୍‍ତିଙ୍କ୍‍ ପୟ୍‍ସ୍‍ ରେହ୍‍ସ୍‍ ଆସାମ୍‍ କାଇଦେ ରୟ୍‍ସିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ୱାୟେତ୍‍ ମାଲିକ୍‍ ମେଣ୍ଡ୍‍ଅର୍‍ତୁନ୍‍ ଦାସତିଙ୍କ୍‍ ରହ୍‍ତଣ୍ଡ୍‍ । ଚାଷିଡ଼୍‍ ଅଙ୍କ୍‌ ଆନ୍‌ତେ କାରାପ୍‍ ବ୍ୟବହାର୍‌ ମାଡ଼୍‍ତଡ଼୍‍ ନୁ ରେହ୍‍ସ୍ ଅନ୍‌‍ ତାଲ୍‍ତିଙ୍କ୍‍ ପାଃସିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ତାନ୍‍ପେର୍କେ ମାଲିକ୍‍ ବେନ୍‍ ଦାସଙ୍କ୍‍ ରହ୍‍ତଣ୍ଡ୍‍, ଅଂକିଙ୍କ୍‌ ଚାଷିଡ଼୍ ଡ଼ଲ୍‍ନା ରେହ୍‍ସିତ୍‍ତଡ଼୍‍ । ମାଲିକ୍‍ତେ ପାକେତ୍‍ ୱେର୍‍ବାଗାତଡ଼୍‍ ୱାତ୍‍ତଡ଼୍, ଚାଷିଡ଼୍‍ ଅଡ଼୍‌‍କ୍‍ ଆନ୍ତେ ଆଲେକେ ମାଡ଼୍‍ତଡ଼୍‍ । ବେସ୍‍କ୍‍ତଡ଼୍‍କିଙ୍କ୍ ରେହ୍‍ତଡ଼୍‍ ନୁ ୱେର୍‍ତଡ଼୍‍କିଙ୍କ୍‍ ଆୱ୍‍କ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ଇଞ୍ଜେ ମାଲିକ୍‍ତେ ଗାରେ ମାତର୍‍ ୱେରଣ୍ଡେ ମାତର୍‌ ବାକି ମିନ୍ଦେଣ୍ଡ୍ ତାନ୍ ପ୍ରିୟ ମାର୍‍ । ମାଲିକ୍‍ ଆଲ୍‍ସ୍‍ତଣ୍ଡ୍‍, “ଅଡ଼୍‌‍ ନା ମାରିଙ୍କ୍‍ ନିଜାମ୍‍ ମାନେମ୍‍ ଆଦ୍‍ତଡ଼୍‍ ।” ଇଲା ଆଲ୍‍ସି ମାଡ଼େଙ୍କ୍‌ତେ ଚାଷିଡ଼୍‍ ଗାରେ ନିଜର୍‍ ମାରିଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","କିନ୍ତୁ ଆ ଚାଷିଡ଼୍‍ ନିଜେନିଜ୍‍ତିଙ୍କ୍‍ କେତ୍‍ତଡ଼୍‍, “ଇଣ୍ଡ୍‍ ମାଲିକ୍‍ତେ ମାର୍‌ । ୱାଡ଼ାଟ୍‍ ଅଂକିଙ୍କ୍‌ ରେହ୍‍ସିନ୍‍ନା ଆଲାଇତ୍କେ ମାଲିକ୍‍ତେ ସମ୍ପତି ମାନ୍‍ କାଇଦେ ୱାଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ଇଲା କେସ୍‍ ଅଡ଼୍‌‍ ମାଲିକ୍‍ତେ ମାରିଙ୍କ୍‍ ପୟ୍‍ସ୍‍ ଆୱ୍‍କ୍‌ତଡ଼୍‍ ନୁ ମଡ଼୍‍ତିଙ୍କ୍‍ ୱାୟେତ୍‍ ବାୟ୍‍ଦେ ଏସିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ଜିସୁ ପାଚାରାମାଡ଼୍‍ତଣ୍ଡ୍‍, “କେସୁଡ଼ାଟ୍‍, ତାନ୍‍ ପେର୍କେ ଆ ଅଙ୍ଗୁର୍‌ ୱାୟେତ୍‍ ମାଲିକ୍‍ ବାତ୍ ‍ମାଡ଼ିମାନ୍ତ୍‍ତଣ୍ଡ୍‍ ? ଅଣ୍ଡ୍‌ ୱାସ୍‍ ନିଜାମ୍‍ ଆ ଚାଷିଡ଼୍‍କ୍‍ ଡ଼ଲ୍‌ନା ରେହ୍‍ସିସ୍‍ ୱାୟେତିଙ୍କ୍ ୱେର୍ ‍ଚାଷିଡ଼୍‍କ୍‍ ଇସ୍‍ମାନ୍ତ୍‍ତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ଶାସ୍ତ୍ରତାଗ୍‍ ଇ ଗଟ୍‍ ମିଡ଼୍‍ ନିଜାମ୍‍ କାର୍‍ତିଡ଼୍‍ । “ଲୋନ୍‌‍ ତିଆର୍‍ ମାଡ଼ାନଡ଼୍‍ ବେନ୍‍ କାଲ୍‍ଦିଙ୍କ୍ ଦର୍‍କାର୍‍ ଆୟ ଇଞ୍ଜ ଆଲ୍‍ସି ୱିଡ଼୍‍ସିସ୍‍ ମାତ୍‍ତଡ଼୍‍, ଆଦ୍‍ ଲୋତ୍‍ତେ ମୁକ୍ୟ ମୂଲ୍‍ତେ କାଲ୍‍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ନିଜେ ପ୍ରବୁ ଇଦ୍‍ କେତ୍‍ତଣ୍ଡ୍, ବେସର୍‍ ଚମତ୍କାର୍‍ ଇ ପାଡ଼୍‍ୟି !” ");
INSERT INTO kff_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ଇହୁଦିଡ଼୍‍ ନେତାଙ୍କ୍‍ ଗିରପ୍‍ ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ଚେଷ୍ଟା ମାଡ଼୍‍ତଡ଼୍‍, କାରନ୍‍ ଅଡ଼୍‌‍ ପୁତ୍‍ତଡ଼୍‍, ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଉଡ଼ି ମିକା ଜିସୁ ଇ ୱେଷଡ଼୍‍ କେତୁତଣ୍ଡ୍ । କିନ୍ତୁ ନାରୁଡ଼୍‍ ୱେର୍‍ଙ୍ଗିଙ୍କ୍‍ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍‍ ୱିଡ଼୍‍ସି ଆତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ପାରୁସିଡ଼୍‍ ନୁ ହେରୋଦ୍‍ତେ ମାନ୍ଦେତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଜିସୁଙ୍କ୍‍ ପ୍ରଶ୍ନ ପାଚାରାମାଡ଼ି ଉଡ଼୍‍ୟିଦାଗ୍‍ ରାପାନ୍‍ ମାଇଦିଙ୍କ୍‍ ୱାସ୍‍ମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍‍ ପାଚାରାମାଡ଼୍‍ତଡ଼୍‍, “ଗୁରୁ, ମାମ୍‍ ପୁତ୍‍ତମ୍‍ ନାରୁଡ଼୍‍କିଙ୍କ୍‍ ୱେର୍‍ୱକଟ ନିମେ ସତ୍‍ ଗଟି କେତିତିନ୍‍ । ବେନନ୍ ସିଗ୍‍ ମାର୍‍ଜାଦ୍ ସେଙ୍ଗ୍ ଉଡ଼କଟ ନିମେ ଇଶ୍ୱର୍‌ତେ ଇଚ୍ଛା ବିଷୟ୍‍ତେ ଶିକ୍ଷା ଇଦ୍‍ତିନ୍‍ । କେଲ୍‍ମ୍‍, ରୋମ୍‍ ସମ୍ରାଟ୍‍ତିଙ୍କ୍‍ ଶିସ୍ତୁ ଇଦାଙ୍କ୍‍ ମା ଦର୍ମ ନିୟମ୍‍ତେ ବିରୁଦ୍‍ କି ଆୟ ? ମାମ୍‍ ଶିସ୍ତୁ ଇଦ୍‍ତମ୍‍ କି ଇଲେ ?” ");
INSERT INTO kff_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ଜିସୁ ଅଡ଼୍‌‍ ଚାଲାକ୍‌ତିଙ୍କ୍‌ ବୁଜେମ୍‍ ଆସ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ନାକିଙ୍କ୍‍ ବାତେଙ୍କ୍‍ ଉଡ଼୍‍ୟିଦାଗ୍‍ ରାପାଙ୍କ୍‍ ଚେଷ୍ଟା ମାଡ଼ୁତିଡ଼୍‍ ? ୱେରଟ୍‍ ରୁପାମୁଦ୍ରା ତାଡ଼ାଟ୍‍, ନାନ୍‍ ଉଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ଅଡ଼୍‌‍ ଡାବ୍‌ ତାତ୍‍ତାଙ୍କ୍‍ ଜିସୁ ପାଚାରାମାଡ଼୍‍ତଣ୍ଡ୍, “ଇଦିନ୍‍ ପର ବେନନ୍ ମୁର୍ତ୍ତି ନୁ ପେଦେର୍‍ ମିନ୍ଦେ ?” “ସମ୍ରାଟ୍‍ତାଦ୍‍” ଇଞ୍ଜ ଅଡ଼୍‌‍ ଉତ୍ତର୍‍ ଇତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ଆଲାଇତ୍କେ, ବେନ୍‍ ସମ୍ରାଟ୍‍ତଦ୍‍, ଆଦ୍‍ ସମ୍ରାଟ୍‍ତିଙ୍କ୍‍ ଇମୁଟ୍‍; ବେନ୍‍ ଇଶ୍ୱର୍‌ତାଦ୍‍, ଆଦ୍‍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍‍ ଇମୁଟ୍‍ ।” ଜିସୁନ୍‍ ଇ ଗଟ୍‍ ଅଡ଼୍‌‍ କେଞ୍ଜି ବାକ୍‌ୱା ଆତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ଡଲ୍‍ତେ ନାରୁଡ଼୍‍ତେ ପୁନରୁତ୍‍ତାନ୍‍ ବିଶ୍ୱାସ୍‍ ମାଡ଼୍‍ୱେ ସାଦୁକିଡ଼୍‍ ମାନ୍ଦେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ୱାସ୍‍ ଜିସୁଙ୍କ୍‍ ପାଚାରା ମାଡ଼୍‍ତଡ଼୍‍, ");
INSERT INTO kff_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଆ ଗୁରୁ, ମୋଶାଲ୍‌‍ ମା ମାଇଦିଙ୍କ୍‍ ଇ ବ୍ୟବସ୍ଥା ଲେକ୍‍ତଣ୍ଡ୍‍, ୱେରଣ୍ଡ୍‍ ପିଲାଜିଲା ଇଲକଟ ଆସ୍‍ ଡଲ୍‍କେ ଆ ନାରୁନ୍‍ତେ ରାଣ୍ଡିମୁତେଙ୍କ୍‍ ତାନ୍‍ ତାମୁଣ୍ଡ୍‌ ପେଣ୍ଡୁଲ୍‍ ଆଦ୍‍ ୱେୟ୍‍ତିତ୍‍ ନୁ ଅଡ଼ାୱ୍‍ ବେନ୍‍ ପିଲା ଜନମ୍‌ ଆଦ୍‍ତା, ଆୱ୍‍ ଡଲ୍‍ତେ ନାରୁନ୍‍ତେ ପିଲା ଇଞ୍ଜ ପେଦେର୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ଆଲେକେ ସାତ୍‍ ଜାନ୍‍ ତାମୁସ୍‍କ୍‍ ମାତ୍‍ତଡ଼୍‍ । ବେଡ଼୍‍ୟ୍‍ ଦାଦାଲ୍‍ ପେଣ୍ଡୁଲ୍‍ ଆସ୍‍ ପିଲାଜିଲା ଆୟକଟ ଡଲ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ଡଲିମାନ୍ଦାନନ୍‍ ରାଣ୍ଡି ନାଟାଡ଼୍‍ତିଙ୍କ୍‍ ଦ୍ୱିତିୟ ତାମୁଣ୍ଡ୍ ପେଣ୍ଡୁଲ୍‍ ଆସ୍‍ ଅଣ୍ଡ୍‌‍ ଆନ୍ତେ ପିଲାଜିଲା ଆୟକଟ ଡଲ୍‍ତଣ୍ଡ୍‍ । ତୃତିୟ ତାମୁଣ୍ଡ୍‍ବା ଆଲେ ଆତ୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ମେଣ୍ଡେ ୱେର୍‍ବାଗାତ୍‍ ସାତ୍‍ ଜାନ୍‍ ତାମୁସ୍‍କିଡ଼୍‍ ଆ ୱେରଡ୍‍ ନାଟାଡ଼୍‍ ପେଣ୍ଡୁଲ୍‍ ଆସ୍‍ ସାରେତଡ଼୍‍ ପିଲାଜିଲା ଆୟକଟ ଡଲ୍‍ତଡ଼୍‍ । ମାଡ଼େଙ୍ଗ୍‍ ନାଟାଡ଼୍‍ ଆନ୍‌ତେ ଡଲ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ଇଞ୍ଜେ କେଲ୍‍ମୁଟ୍‍, ପୁନରୁତ୍‍ତାନ୍‍ ଦିନ୍‍ତେ, ବେସୁଙ୍କ୍‍ ଡଲ୍‍ତେନଡ଼୍‍ ପୁନର୍ଜିବିତ୍‍ ଆସ୍‍ ତେଦିତଡ଼୍‍, ଆ ନାଟାଡ଼୍‍ ବେନନ୍ ମୁତେ ଆଦ୍‍ତେ ? ସାତ୍‍ଜାନ୍‍ ଯାକ ତ ତାଙ୍କିକ୍‍ ପେଣ୍ଡୁଲ୍‍ ଆସ୍‍ ମାତ୍‍ତଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ମିକିଙ୍କ୍‌ ବେସର୍‍ ବୁସା ଚିନ୍ତେ ମିନ୍ଦେ । ଦର୍ମଶାସ୍ତ୍ର ନୁ ଇଶ୍ୱର୍‌ତେ ଶକ୍ତି ବିଷୟ୍‍ତେ ମିଡ଼୍‍ ବାତେ ପୁନ୍‍ୱିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","କାରନ୍‍ ଡଲ୍‍ତେନାରୁଡ଼୍‍ ପୁନରୁତ୍‍ତିତ୍ ଆତ୍‍ତଡ଼୍‍, ଅଡ଼୍‌‍ ସ୍ୱର୍ଗତେ ଦୂତକିନ୍‍ ଲେକାମ୍‍ ଆଦ୍‍ତଡ଼୍‍ ଅଡ଼୍‌‍ ପେଣ୍ଡୁଲ୍‍ ଆୟ୍‍ୟଡ଼୍‍ କି ପେଣ୍ଡୁଲ୍‍ ଇୱଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ଡଲ୍‍ତେନାରୁଡ଼୍‍ ପୁନରୁତ୍‍ତାନ୍‍ ଗଟ୍‍ ପାଚାର୍‌ମାଡ଼ୁତିଡ଼୍‌ ? ମୋଶାନ୍‌‌ ବଇତାଗ୍‍ ନିଡ଼୍‍ତାନ୍‍ ପଦ୍‍ଲେ ବିଷୟ୍‍ତେ କାର୍‍ୱିଡ଼୍‍ କି ? ଆଗେ ଲେକା ମିନ୍ଦେ, ଇଶ୍ୱର୍‍ ମୋଶାଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ନାନ୍‍ ଅବ୍ରାହାମ୍‌ତେ ଇଶ୍ୱର୍, ଇସାହାକତେ ଇଶ୍ୱର୍‍ ନୁ ଯାକୁବ୍‍ତେ ଇଶ୍ୱର୍ ! ");
INSERT INTO kff_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ଅଣ୍ଡ୍‌‍ ଡଲ୍‍ତ୍‍ନାରୁଡ଼୍‍ତେ ଇଶ୍ୱର୍‍ ଆୟଣ୍ଡ୍, ଅଣ୍ଡ୍‌‍ ଜିୱୁମାନ୍ଦାନଡ଼୍‍ ଇଶ୍ୱର । ମିଡ଼୍‍ ପୁରାପୁରି ବୁଲ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ଅର୍‍ତୁଣ୍ଡ୍‍ ଦର୍ମଗୁରୁ ଆଗେ ମାଞ୍ଜ୍‍ ଇ ସାରେ ରାମ୍‍କ୍ ଲେକାମ୍ ଆଦାନାଦ୍ କେଞ୍ଜମାତ୍‍ତଣ୍ଡ୍‍ । ସାଦୁକିଡ଼୍‍କ୍‍ ଜିସୁ ଟିକ୍‍ ଜବାବ୍‍ ଇତ୍‌ତଣ୍ଡ୍‌ ଇଞ୍ଜ ପୁଞ୍ଜ୍‍ ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍‍ ମେଣ୍ଡ୍‍ ଅଣ୍ଡୟ୍‌‍ ପ୍ରଶ୍ନ ପାଚାର୍‌ମାଡ଼୍‍ତଣ୍ଡ୍‍, “ମା ଦର୍ମଶାସ୍ତ୍ରତାଗ୍‍ ବେନ୍‍ ଆଜ୍ଞା ସାରେକେ ବେଡ଼୍‍ୟାଦ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜିସୁ ଉତ୍ତର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, “ଇଶ୍ରାଏଲିୟ ନାରୁଡ଼୍‍ କେଞ୍ଜାଟ୍‍ ସାରେକେ ବେଡ଼୍‍ୟାଦ୍‍ ଆଜ୍ଞା ଆଦୁତେ, ‘ମାନ୍‍ ପ୍ରବୁ ଇଶ୍ୱର ୱେରଣ୍ଡେ ପ୍ରବୁ । ");
INSERT INTO kff_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ପ୍ରବୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍‍ ପୁରା ହୃଦୟ୍‍, ପୁରା ଆତ୍ମା, ପୁରା ମନ୍‍, ଶକ୍ତି ସାମର୍ତ୍ୟ ଇସ୍‍ ପ୍ରେମ ମାଡ଼ାଟ୍‌ ବା ବକ୍ତି ମାଡ଼ାଟ୍‍ ।’ ");
INSERT INTO kff_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଦ୍ୱିତିୟ ବେଡ଼୍‍ୟାଦ୍‍ ଆଜ୍ଞା ଆଦୁତେ, ‘ମି ଗାରେତଡ଼୍‍କ୍‍ ଆତ୍ମାତେଲେକାମ୍‍ ପ୍ରେମ ମାଡ଼ାଟ୍ ।’ ଇ ରେଣ୍ଡିନ୍‍ ୱିଡ଼୍‌ସି ବେଡ଼୍‍ୟ୍‍ ଆଜ୍ଞା ମେଣ୍ଡ୍‍ ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ଦର୍ମଗୁରୁ କେତ୍‍ତଣ୍ଡ୍‍, “ଗୁରୁ, ନିମେ ସତ୍‍ କେତ୍‍ତିନ୍‍ ! ବାସ୍ତବିକ୍‍ ନିମ୍‍ କେତାନ୍‍ ଲେକାମ୍‌, ମାତର୍‍ ମାନ୍‍ ପ୍ରବୁ ଆଦୁତଣ୍ଡ୍‍ ୱେରଣ୍ଡେ ଇଶ୍ୱର ଅଙ୍କ୍‌ ୱିଡ଼୍‌ସି ୱେର୍‍ ଇଶ୍ୱର୍‍ ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ନାରୁଡ଼୍‍ ତାନ୍‍ ପୁରାହୃଦୟ୍, ପୁରାମନ୍, ପୁରାଶକ୍ତି ଇସ୍‍ ଅଂକିଙ୍କ୍‌ ପ୍ରେମ ନୁ ବକ୍ତି ମାଡ଼ାନ୍‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ତାନ୍‍ ପଡ଼ଶିଡ଼୍‍କ୍‍ ଆତ୍ମାତେ ଲେକାମ୍‍ ପ୍ରେମ ମାଡ଼ାଟ୍ । ଇଶ୍ୱର୍‌ତେ ଲେକେତ୍‍ ପଶୁ ନୁ ୱେର୍‍ ବଲି ଉସର୍ଗ ମାଡ଼ାନ୍‍ ୱିଡ଼୍‌ସି, ଇ ରେଣ୍ଡ୍‍ ଆଜ୍ଞା ପାଲନ୍‌ ମାଡ଼ାଙ୍କ୍‍ ପେର୍କେ ଦର୍‍କାର୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ତାମ୍‍ ଜ୍ଞାନବାନ୍ ଉତ୍ତର୍‍ କେଞ୍ଜି ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ମିଡ଼୍‍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗାଙ୍କ୍‍ ନାର୍ଗେଦୁରାମ୍‍ ଇଲେଡ଼ି ।” ତାନ୍‍ ପେର୍କେ ଜିସୁଙ୍କ୍‍ ମେଣ୍ଡେ ପ୍ରଶ୍ନ ପାଚାରାମାଡ଼ାଙ୍କ୍‍ ବେନବା ସାହାସ୍‍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ଦାଉଦ୍‍ତେ ମନ୍ଦିର୍‍ତାଗ୍‍ ଅଣ୍ଡ୍‌‍ଦିନେ ଶିକ୍ଷା ଇଦାନ୍‍ୱେଲେ କ୍ରିଷ୍ଟ ୱେରଡ୍‍ ପ୍ରଶ୍ନ ପାଚାର୍‌ମାଡ଼୍‍ତଣ୍ଡ୍, ଦର୍ମଗୁରୁଡ଼୍‍ ବାତେଙ୍କ୍‍ କେତୁତଡ଼୍‍, ମସିହ ଦାଉଦ୍‍ତେ ମାର୍‍ ଇଞ୍ଜ ? ");
INSERT INTO kff_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ପବିତ୍ର ଆତ୍ମାତାଗାଙ୍କ୍‍ ପ୍ରେରଣା ପାହେମ୍‍ଆସ୍‍ ଦାଉଦ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ପ୍ରବୁ ନା ପ୍ରବୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍,” ମାମ୍‍ ମି ସାରେ ଶତ୍ରୁଡ଼୍‍କିଙ୍କ୍‍ ମି ଡେକେତ୍‍ ମଦଲ୍‍ ମାଡ଼୍‍ନା ଯାକ, ନିମେ ମା ତିନ୍ଦେ ପାକେ କୁଦିମାନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ଇଗାଙ୍କ୍‍ ପୁନ୍ଦାଙ୍କ୍‍ ଆଦୁତ୍‍ତେ ଯେ, ମସିହଙ୍କ୍ ଦାଉଦ୍‍ ପ୍ରବୁ ଇଞ୍ଜ ଲେକା ଆତ୍‍ତେ । ଆଲାଇତ୍କେ ମସିହ ଦାଉଦ୍‍ତେ ମାର୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍ ବେଲା ? ଅନ୍‌‍ଦାମ୍‍ ୱେରଡ୍‍ ବେଡ଼ିୟା ମାନ୍ଦେ ନାରୁଡ଼୍‍ ଜିସୁନ୍‍ ଗଟ୍‍ ଇଚ୍ଛାତେ କେଞ୍ଜମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଶିକ୍ଷା ଇଦାନ୍‍ୱେଲେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, “ଲାଟି ଚକା କେର୍‍ସ୍‍ ଆଟ୍‍ ବଜାର୍‍ତା ନାରୁଡ଼୍‍ଡ଼ାଗାଙ୍କ୍‍ ସମ୍ମାନ ପାହେମ୍‍ ଆଦ୍‌ ଦର୍ମଗୁରୁଡ଼୍‍ ସେଙ୍ଗେ ସତର୍କ ମାନୁଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ଉପାସନା ଲୋନ୍‌‍ ନୁ ବଜିକିନାଗ୍‍ ଜାଗା ଅଦିକାର୍‌‍ ମାଡ଼ମାନ୍ଦାନ୍‍ ! ");
INSERT INTO kff_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ଅଡ଼୍‌‍ ରାଣ୍ଡିମୁତେକିନ୍‍ ଇଲ୍‍ୱେ ସୁଯଗ୍‍ ଅସ୍‍ ଆୱିନ୍‍ ସମ୍ପତି ଅଦ୍‍ତଡ଼୍‍ । କିନ୍ତୁ ଚାଲାକ୍‍ ମାଡ଼ି ଲେକେତ୍‍ ପ୍ରାର୍ତନା ମାଡ଼ିତଡ଼୍‍ । ଆଦିନ୍‌ ମାଇଦିଙ୍କ୍‍ ଅଡ଼୍‌‍ ନାର୍ଗେ କଷ୍ଟ ଦଣ୍ଡପାହେମ୍‌ ଆଦ୍‍ତଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ଅନ୍‌‍ଦାମ୍‍ ଜିସୁ ମନ୍ଦିର୍‌ତାଗ୍‍ ଦାନ ଇଦାନ୍‍ ଜାଗେତ୍‍ ଗାରେ କୁଦିମାତ୍‍ତଣ୍ଡ୍ । ନାରୁଡ଼୍‍ ୱାସ୍‍ ଆଗେ ନେହ୍‍ସ୍‍ ମାନ୍ଦାନ୍ ବାକ୍‍ସତାଗ୍‍ ଦାନ ୱାଟାନାଦ୍ ଅଣ୍ଡ୍‌‍ ଉଡ଼ ମାତ୍‍ତଣ୍ଡ୍‍ । ଦନିଡ଼୍‍ ଆଗେ ନାର୍ଗେ ଡାବ୍‍କ୍‍ ୱାଟମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ଆସୁଟ୍‍ ଅଣ୍ଡୟ୍‌‍ ଗରିବ୍‍ ରାଣ୍ଡିଲ୍‍ ଆଗେ ୱାସ୍‍ ମାତର୍‍ ରେଣ୍ଡ୍‍ ସୁଦୁରାୱ୍‍ ତମ୍ୱା ମୁଦ୍ରା ଆ ବାକ୍‍ସତାଗ୍‍ ୱାଟ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ସତ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ଇ ଗରିବ୍‍ ରାଣ୍ଡିନ୍‍ ଦାନ ୱେର୍‍ବାଗାତଡ଼୍‍ ଇସ୍‍ମାନ୍ଦାନ୍‍ ଦନ୍‍ତାଗାଙ୍କ୍‍ ନାର୍ଗେ । ");
INSERT INTO kff_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ସାୱ୍‌କାରିଡ଼୍‌ ତାମ୍‍ ମିଗ୍‍ଲ୍‍ତେ ଦନ୍‍ତାଗାଙ୍କ୍‍ ଇସ୍‍ମିନ୍ଦେଡ଼୍‍, କିନ୍ତୁ ଇ ନାଟାଡ଼୍‍ ତାନ୍‍ ଦରିଦ୍ର୍ୟ ତଡ଼୍‍ ତାନ୍‍ ଗାରେ ସମ୍ପତି ବାତ୍‍ ମାତ୍‍ତେ, ସାରେ ଇତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଅଣ୍ଡ୍‌ ଦିନେ ଜିସୁ ମନ୍ଦିର୍‍କଞ୍ଚ୍‍ ପେଇସ୍‍ ଆଦାନ୍‍ ୱେଲେ ତାନ୍ ଶିଷ୍ୟ ଅର୍ତୁଣ୍ଡ୍ କେତଣ୍ଡ୍, “ଗୁରୁ ! ଉଡ଼େ, ବେସର୍‍ ସୁନ୍ଦର୍‍ କାଲ୍‍କ୍‍ ନୁ ବେସର୍‍ ସୁନ୍ଦର୍‍ ଲୋକ୍‍ !” ");
INSERT INTO kff_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ଜିସୁ ଉତ୍ତର ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନେଣ୍ଡ୍ ଇଦ୍‍ ବାଡ଼ିୟା ଲୋନତିଙ୍କ୍ ଉଡ଼ୁତିଡ଼୍ ? ଆଦ୍ ୱେରଟ୍‍ବା କାଲ୍‍ ନିଜର୍‍ ପଡ଼ିୟେତାଗ୍‍ ମାନ୍‌ । ଆଦ୍ ସାର୍ରେ ବୂମ୍‌ଦାଗ୍‍ କାଇଲିତେ ।” ");
INSERT INTO kff_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ଅଣ୍ଡ୍‌ ଦିନେ ଜିସୁ ମନ୍ଦିର୍ ମୁନେତ୍‍ ଜିତ ମେଟେତେ ପର କୁଦିମାତ୍‍ତଣ୍ଡ୍ । ପିତର୍, ଯାକୁବ, ଯୋହନ ନୁ ଆନ୍ଦ୍ରିୟ କାଇଲି ତାନ୍ ଗାରେ ୱାସ୍ ପାସ୍‍ରିଞ୍ଚ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ଇୱୁସାରେ ବେସୁଙ୍କୁ ଗଟେମ୍ ଆଦ୍‍ତେ ମାକିଙ୍କ୍ କେଲ୍‌ମ୍ । ବାତେଏ ଉଡ଼ି ଇୱୁ ସାର୍ରେ ବକେତେ ଏୱୁତା ଇଞ୍ଜ୍ ମାମେ ପୁନ୍‍ତମ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍‍, “ସାବଦାନ୍, ବେନ ବେଲା ମିକିଂଙ୍କ୍‍ ବୁସା ମାଡ଼୍‍ମାକିଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ନାର୍ଗେ ନା ପେଦେର୍‍ତିଙ୍କ୍‍, ଅସ୍‌ କେତିତଡ଼୍‍, ନୁ ନାନେ ଅଣ୍ଡେ ଇଦିନ୍‍ତଡ଼୍ ଅଡ଼୍‌ ପିନା ନାରୁଙ୍କୁ ବୁସା ମାଡ଼ିତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ଗାର୍ରେତେ ଯୁଦ୍ଦ୍‌ ବା ଜେକେତେ ଯୁଦ୍‌ ମରେ କେଞ୍ଜି ମିଡ଼୍ ୱେର୍ରେମାଟ୍‍ । ଇଦିନ୍ ଲେକେ ପିନା ଗଟେମ୍‍ ଆଦ୍‍ତା । କିନ୍ତୁ ଇଦିନ୍ ଅର୍ତ ଆୟ ଯେ ତେରାନ୍‍ ଦିନାମ୍‍ ଏୱୁତେ । ");
INSERT INTO kff_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ଦେଶ୍‌ ଦେଶ୍‌ ଲୋପେ ଯୁଦ୍‌ ଆଦ୍‍ତେ । ଅଣ୍ଡ୍‌‍ ରାଜ୍ୟ ମେଣ୍ଡନ୍ ରାଜ୍ୟତିଙ୍କି ଯୁଦ୍‌ ମାଡ଼ିତେ । ସାର୍ରେ ହେକାମ୍‍ ବୂମ୍‌ ମେୟିଦ୍‍ତେ ନୁ ମୁଡ଼ୁନ୍ଦି ଆଦ୍‍ତେ । କିନ୍ତୁ ଇୱୁସାରେ ଡଙ୍କେତ୍‍ ମାନ୍ଦାନ୍‍ ମୁତେନ୍‍ ଡଙ୍କେନପ୍‍ ଆରାମ୍‍ ଆଦାନ୍‍ ମୁନେତେ ଗଟି । ");
INSERT INTO kff_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“ମିକିଙ୍କ୍ ସାବଦାନ୍ ମାନ୍ଦେ ୱେୟ୍‍ତିତ୍ ।” ମିଡ଼୍ ତହଃସ୍‍ ଜେଲ୍ ଦାଗ୍ ଆତ୍‍ତିଡ଼ି । ମିଡ଼୍‍ ଉପାସନା ଲତ୍‍ତାଗ୍‍ ଦେବ୍‍ ତିନ୍ତ୍‍ତିଡ଼୍‍ । ନା ମାଇଦିଙ୍କ୍‍ ମିଡ଼୍‍ ସାସନ୍‍କର୍ତାଲଡ଼୍‍ ନୁ ରାଜାଲଡ଼୍‍ ମୁନେ ନିସ୍‍ ସୁସମାଚାର୍‍ ଗଟ୍‍ କେଞ୍ଚ୍‍ସ୍ପ ୱେୟ୍‍ତିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","କିନ୍ତୁ ଅଣ୍ଡ୍‌‍ ବାତ୍‍ ଆୟଣ୍ଡ୍‍ବା, ତେରାନ୍‍ ଦିନାମ୍‍ ୱାଦାନ୍‍ ମୁନେକେ ସାରେ ଜାତି ନୁ ସାରେ ନାରୁଡ଼୍‍ ଗାରେ ଇଦ୍‍ ସୁସମାଚାର୍‍ ନିଜାମ୍‍ତେ ପ୍ରଚାର୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ମିକିଂଙ୍କ୍‍ ତହ୍‍ସ୍‍ ଜେଲ୍ ଦାଗ୍‍ ଅଦାନ୍‍ ୱେଲେ, ଆଗ୍‍ ବାତେକେତାଙ୍କ୍‍ ଆଦ୍‍ତେ, ଇଦ୍‍ ବିଷୟ୍‍ତିଙ୍କ୍‍ ଦାନ୍ଦ୍‍ ଆଇମାଟ୍‍ । ଆ ସମୟତେ ବାତ୍‍ କେତାଙ୍କ୍‍ ଆଦ୍‍ତେ, ଆଦ୍‍ ମିକିଙ୍କ୍ କେଞ୍ଜ୍‌ପିଦ୍‍ତଡ଼୍‍ । ଆସୁଟ୍‍ ମିକିଂଙ୍କ୍‍ ନିଜର୍‍ ମନ୍‍ଦେ ବାତ୍‍ କେତ୍‍ୱେୟ । ମିଡ଼୍‍ ବାତ୍‍ ତେତିତିଡ଼୍‍, ଆଦ୍‍ ପବିତ୍ର ଆତ୍ମା ପୁଞ୍ଜ୍‍ପିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ଆ ସମୟ୍‍ତେ ନାରୁଡ଼୍‍ ନିଜର୍‍ ଦାଦାଲଡ଼୍‍କିଙ୍କ୍‍ ଆୱ୍‍କାନଙ୍କ୍‍ ପସ୍ପିଦ୍‍ତଡ଼୍‍, ବାବାଲଡ଼୍ ନିଜର୍‍ ମାର୍‍କିନ୍‍ ପର ଆଲେ ମାଡ଼ିତଡ଼୍‍ । ପିଲାକି ନିଜର୍ ୟାୟବାବାନ୍‍ ପର ବିରଦ୍‍ତେ ତେଦିତଡ଼୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଆୱ୍‍କ୍‌ନା ମାଡ଼ିତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ନା ସେଙ୍ଗେ ସାରେତଡ଼୍‍ ମିକିଙ୍କ୍ ଗୃନା ମାଡ଼ିତଡ଼୍‍, କିନ୍ତୁ ବେନଡ଼୍‍ ମାଡ଼େଙ୍ଗ୍‍ ଆୟ୍‍ନା ନିସ୍‍ମାନ୍ତ୍‍ତଡ଼୍‍, ଅଡ଼୍‌‍ ପରିତ୍ରାଣ ପାଏମ୍‍ ଆଦ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ମିଡ଼୍‍ ଆ ‘ଦ୍ୱଂସ କାରିଡ଼ି’ ପିନ୍ଦଲାଦିଙ୍କ୍‍ ଉଡ଼ିତିଡ଼୍‍, ବେନ୍‍ କି ମାଡ଼ାନାଦ୍‍ ଆୟ, ଆଗେ ଆଦିଙ୍କ୍ ଉଡ଼ିତିଡ଼୍‍,” କାର୍‍ୟାନଡ଼ି ଇଦିଙ୍କ୍ ବୁଜେମ୍‍ ଆଦାଙ୍କ୍‍ ଚେଷ୍ଟା ମାଡ଼ାଟ୍‍, “ଆସୁଟ୍‌ ଯିହୁଦାବାସିଡ଼୍‍ ମେଟେତ୍‍ ପର ମିରିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ବେନ୍‌ଅ ଲୋତ୍‍ତେ ମୁର୍ସିନାଗ୍‍ ଆଞ୍ଜ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ଲନ୍‍ ଲୋପେତ୍‍ ବେନ୍‍ ଜିନିଷ୍‍ ଅଦାନଙ୍କ୍ ଅଣ୍ଡ୍‌‍ ଡିଗିୱାସ୍‍ ସମୟ୍‍ ନଷ୍ଟ ମାଡ଼୍‍ମାକିଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ବେନ୍‌ଅ ୱାୟ୍‍ତା ଆଞ୍ଜ୍‍ ମିନ୍ଦେଣ୍ଡ୍‍, ଚକାସିଲେ ଆଦାନଙ୍କ୍ ଅଣ୍ଡ୍‌‍ ଲନ୍‍‍ ୱାଡ଼୍‍ମାକିଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ଆସୁଟ୍‍ ଡଙ୍କେତ୍‍ ମାନ୍ଦାନ୍‍ ନାଟା ନୁ କାୟ୍‍ଦାଗ୍‍ଗେ ପିଲ୍‍ଲେ ପୟ୍‍ସ୍‍ ମାନ୍ଦାନ୍‍ ୟାୟକି ବେସର୍‍ କଷ୍ଟ ଆୟ । ");
INSERT INTO kff_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍‍, ଇ ଗଟନା ବେଲା ସାଲ୍‍ଦେ ୱେଲେ ଆୟ୍‍ମାକି । ");
INSERT INTO kff_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ଆ ଦୁର୍ଦିନତେ ଦୁଃକ୍‍କଷ୍ଟ ସାରେ ସୃଷ୍ଟି ଆରାମ୍‍ତେ ନେଣ୍ଡ୍‍ ଆୟ୍‍ନା ଗଟେମ୍‍ ଆସ୍‍ ମାନ୍ଦାନ୍‍ ସାରେ ତିପାଲ୍‍ ପେର୍କେ ବୟଙ୍କର୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","କିନ୍ତୁ ପ୍ରବୁ ଆ ଦୁର୍ଦିନ୍‍ତେ ସମୟ୍‍ତିଙ୍କ୍ କମ୍‍ ମାଡ଼ିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍‍ । ଆଲା ଆୟ୍‍ୱେ ମାତ୍କେ, ଆଗାଙ୍କ୍ ବେନ ରକ୍ଷା ପାୟେମ୍‍ ଆଦାଙ୍କ୍‍ ପାର୍‍ୱଣ୍ଡ୍‍ । ତାନ୍‍ ଏଞ୍ଚିମାନ୍ଦାନ୍‍ ନାରୁଡ଼୍‍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌‍ ସମୟ୍‍ ନେହ୍‍ସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ଆସୁଟ୍‍ ବେନ୍‌ଅ କେତିତଣ୍ଡ୍, “ଉଡ଼େ, ମସିହ ଇଗେ ମିନ୍ଦେଣ୍ଡ୍,” ଆଗେ ଉଡ଼େ ମସିହ ଆଗେମିନ୍ଦେଣ୍ଡ୍, ଆଦିଙ୍କ୍‍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ମାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ବୁସା ମାଡ଼ାନ୍ ମସିହ ନୁ ବୁସା ମାଡ଼ାନ୍ ବଣ୍ଡକ୍ରିଷ୍ଟଡ଼୍‍ ତନ୍ଦିତଡ଼୍ । ଅଦିକ୍‌ ଆକେ ଇଶ୍ୱର ଏଞ୍ଚ୍‍ତେ ନାରୁଡ଼ୁକ୍‍ ବା ଟକା ମାଡ଼ାନ୍‍ ଅଡ଼୍‌ ବେପଡ଼୍‍ ମାଡ଼୍‍ୱେ ପାଡ଼ିୟି ମାଡ଼ିତଡ଼୍‍ ନୁ ବେସୁଙ୍କ୍‍ ଉଡ଼୍‍ୱେ ଆସୁଙ୍କ୍‌ତାୱୁ ତଅତିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ମିଡ଼୍‍ ସାବଦାନ୍‍ ମାନୁଟୁ । ହିୱୁ ସାରେ ଗଟେମ୍ ଆଦାନ୍‍ ମୁନେ ନାନେ ମିକିଂଙ୍କ୍‍ କେଞ୍ଜ୍‌ପିତାନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ଆ ଦୁକାମ୍‍ଦିନେ ୱାତ୍‍ତେ ପେର୍କେ ପଡ଼୍‍ଦ୍‍ତିଙ୍କ୍‍ ଇକାଡ଼୍‍ ଆଦ୍‍ତେ, ନେଞ୍ଜ୍‍ତିଙ୍କ୍‍ ୱେସ୍‍ ଆଦ୍‍ତେ,” ");
INSERT INTO kff_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ଉକାକ୍‍ ମୟଲତାଗାଙ୍କ୍‍ ରାଇତା ମହାଶୂନ୍ୟତେ ଶକ୍ତିସାରେ ୱାଡ଼୍‍କି ଆଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ଆସୁଟ୍ ନାରୁନ୍‍ପିଲେ ଗୌରବ୍ ନୁ ମହା ପରାକ୍ରମତେ ମାବ୍‍ତାଗାଙ୍କ୍‍ ୱାଦାନାଦ୍‌ ଉଡ଼ିତିଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ତାନ୍‍ ଏଞ୍ଚ୍‍ସି ମାନ୍ଦା ନାରୁଡ଼୍‍କ୍ ଜଗତ୍‍ତେ ଅଣ୍ଡ୍‌‍ ପଡ଼୍‍ୟେତାଗାଙ୍କ୍‍ ମେଣ୍ଡନ୍ ପଡ଼ିୟେତାଗ୍‍ ମେକି ଆଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌‍ ତାନ୍‍ ଦୂତକିଙ୍କ୍‍ ସାର୍‍ଏକାମ୍‍ ବା ପୃତିବିତେ ଶେଷ୍‍ସିମା ଏୱୁନା ରଅତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ତୟେ ମାଡ଼୍‍ତାଗ୍‍ଙ୍କ୍ ଶିକ୍ଷା ନାଡ଼୍‍ସାଟ୍‍ । ବେସୁଟ୍‌ ଲେତାୱୁ ଆକି କଡ଼୍‍ସିତା, ଆସୁଟ୍‍ ଏଦ୍‍ କାଲାମ୍‍ ଏୱୁତେ ଇଞ୍ଜ୍‍ ମିଡ଼୍ ପୁନ୍ଦ୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ଟିକ୍‍ ଆଲେନେ ହିୱୁସାରେ ଗଟନା ଉଡ଼୍‍କେ, ତେରାନ୍‍ ଦିନାମ୍‍ ଏୱୁତେ ଇଞ୍ଜ ପୁନ୍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ନାନ୍‍ ମିକିଂଙ୍କ୍‍ ନିଜାମ୍‍ କେତୁତାନ୍‍, ବେନଡ଼୍‍ ଜିୱ୍‍ ମିନ୍ଦେଡ଼୍‍, ଅଡ଼୍‌‍ ଡଲାନ୍‍ ମୁନେଙ୍କ୍ ଇୱୁ ସାରେ ଗଟେମ୍‍ ଆଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ମୟଲ୍‍ ନୁ ପୃତିବି ଦଂସ ଆଦ୍‍ତେ, କିନ୍ତୁ ନା ଗଟ୍‍ ବେସୁଙ୍କ୍‍ ଦଂସ ଆୟ ।” ");
INSERT INTO kff_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ଆଦିନ୍, ବେସୁଟ୍‌ ୱାଦ୍‍ତଣ୍ଡ୍, ବେନ ପୁନଡ଼୍‍ । ସ୍ୱୟଂ ଇଶ୍ୱର୍‍ ତେ ମାର୍‍ କିମ୍ୱା ସ୍ୱର୍ଗତେ ଦୂତ ବା ଇଗଟି ପୁନ ଇତ୍କେ ବାବାଲ୍‍ ଇଶ୍ୱର୍ ଇ ଗଟି ପୁତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ସାବ୍‍ଦାନ୍‍ ଆସ୍‍ କେପିମାନୁଟ୍‍, ଆଦ୍‍ ସମୟ୍‍ ବେସୁଟ୍‌ ୱାଦ୍‍ତେ ଆଦ୍‍ ମିଡ଼୍‍ ପୁନ୍‍ୱିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ଅର୍‍ତୁଣ୍ଡ୍‍ ନାରୁଣ୍ଡ୍ ଉଡାଙ୍କ୍ ଆଦାଙ୍କ୍‍ ପେୟ୍‍ତ୍‍ ୱେଲେ, ତାନ୍‍ ଲୋନ୍‌‍ ଚାକରିଡ଼୍‍ ଦାଇତ୍ୟ ୱିଡ଼୍‍ସିସ୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍ । ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍ ବେନ ବାତ୍‍ ମାଡ଼ିତଣ୍ଡ୍‍, ବୁଜାମାଡ଼ିସ୍‍, କେପାନଡ଼୍‍କିଙ୍କ୍‍ ତିଆର୍ ଆସ୍‍ ମାନ୍ଦାଙ୍କ୍‍ କେସ୍‍ ଆଦ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ଆଲେ ନେ ନାନେ ମିକିଂଙ୍କ୍‍ ସାବ୍‍ଦାନ୍‍ କେସମିନ୍ଦେନ୍‍, ବାତାଙ୍କ୍‍ ଇତ୍କେ ଲୋତ୍‍ତେ ମୁଦ୍‍ପାଲ୍‍ ବେସୁଙ୍କ୍‍ ୱାଦ୍‍ତଣ୍ଡ୍, ମିଡ଼୍‍ ପୁନ୍‍ୱିଡ଼୍‍ ମୂଲ୍‍ପୁଟ୍‍ ବା ନାଡ୍‍ନାର୍କା, ୱିୟ୍‍ଦାନ୍‍ ଗାରେ ବା ପଡ଼୍‍ଦ୍‍ ପେୟ୍‍ତାନ୍‍ ୱେଲେ ଅଣ୍ଡ୍‌‍ ୱାଦ୍‍ ପାର୍ଦ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ଅଣ୍ଡ୍‌‍ ଯଦି ଅଟାତ୍‍ ୱାସ୍‍ ଏୱ୍‍ଦ୍‍ତଣ୍ଡ୍‍, ମିକିଂଙ୍କ୍‍ ଉଞ୍ଜ୍‍ତେ ପଡ଼୍‍ୟ୍‍ତାଗେ ଅଣ୍ଡ୍‌‍ ଉଡ଼୍‍ମାକିଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ନାନ୍‍ ମିକିଂଙ୍କ୍‍ ବାତେ କେତୁତାନ୍‍, ୱେର୍‍ତଡ଼୍‍କିଙ୍କ୍‍ ବା ଆଦେ କେତୁତାନ୍‍ ଜାଗ୍ରତ୍‍ ଆସ୍‍ ମାନୁଟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ନିସ୍ତାର୍‌ ପାଣ୍ଡୁମ୍ ନୁ କମିରଶୂନ୍ୟ ରୂଟି ପାଣ୍ଡୁମ୍‍ତେ ରେଣ୍ଡ୍‌ ଦିନା ମୁନେ ଜିସୁଙ୍କ୍‍ ମିଞ୍ଜ୍‍ପି ତଅସ୍ ଅସ୍‌ ଆୱୁକାନଙ୍କ୍ ମୁକ୍ୟ ପୁରୋଇତ ନୁ ଦର୍ମଗୁରୁଡ଼୍ ଉପାୟ ମେହେକୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ପାଣ୍ଡୁମ୍‍ତେ ୱେଲେ ଇଦ୍‍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ମାଟ୍‍, ବାତେଙ୍କ୍‍ଇତ୍କେ ଆସୁଟ ନାରୁଡ଼୍ ରାମକ୍‌ କଟ ମାଡ଼ିତଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଜିସୁ ବେନିତାଗେତେ କୁଷ୍ଠି ଶିମୋନ ପେଦେର୍‍ତେ ଅର୍ତୁଣ୍ଡ୍‍ ନାରୁନ୍ତେ ଲୋନ୍‌‍ କୁଟ୍‍ମାମ୍ ଆସ୍‍ମାତଣ୍ଡ୍‍ । ଜିସୁ ଆଗେ ତିନ୍ଦାଙ୍କ୍‍ କୁଦି ମାତ୍‍ତେ ୱେଲେ ଅଣ୍ଡ୍‌ ନାଟାଡ଼୍ ୱାସ୍ ନାର୍ଗେ ଦାମିନ୍ ପାଇସାନାଦ୍ ଜଟାମାଂସି ଗାବ୍‍ମାନ୍ଦାନ୍‍ ନିୟ୍ ବର୍‍ତିମାନ୍ଦାନ୍ ଅଣ୍ଡ୍‌ ପାଣ୍ଡିରିଲାଦ୍‍ ଗିନେ ପୟସ୍ ୱାତ୍‍ତେ । ଆଦ୍ ଗିନେତିଙ୍କ୍ ଉସ୍ ଜିସୁନ୍ ମୁଞ୍ଜିନ୍‌ ପର୍ ସାରେ ନିୟ୍ ତସ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ଆଗେ ମାନ୍ଦା ବେସ୍‍କେ ନାରୁଡ଼୍ ଅଦିନ୍‌ ଆ ପାଡ଼୍‍ୟି ଉଡ଼ି କପାମ୍‍ ଆତ୍‍ତଡ଼୍ ନୁ ତାମ୍‍ତାମ୍ ଲୋପେ କେତାକେତି ଆତ୍‍ତଡ଼୍, “ଇଦ୍ ଗାବ୍‍ମାନ୍ଦାନ୍‍ ନିୟ୍ ଇଲା ନଷ୍ଟ ମାଡ଼ାନାଦ୍‍ ସାୟ୍ ଆତ୍‍ତେ କି ? ");
INSERT INTO kff_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ତାଂକିଙ୍କ୍‍ ୱାମିକେ, ତିନିଶହ ପିନା ରୌପ୍ୟ ମୁଦ୍ରା ଦର୍‍କେ ନୁ ଆ ଡ଼ାବ୍‍କ୍‍ ଗରିବ୍‍ ନାରୁଡ଼୍‍କ୍ ଇଦାଙ୍କ୍‍ ଆୟେଡ଼୍,” ଆ ନାଟାଡ଼୍‍ତିଙ୍କି ନାର୍ଗେ ଗଟି କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","କିନ୍ତୁ ଜିସୁ କେତ୍‍ତଡ଼୍, “ତାଙ୍କି ଆସର ଅଇରାନ୍‍ ମାଡ଼ୁତି ବାତାଙ୍କ୍‍ ? ଆଦ୍ ନାମା ଇଦିଙ୍କ୍‍ ଅଣ୍ଡ୍‌ ସୁନ୍ଦର୍ ପାଡ଼ିୟ୍‌ ମାଡ଼ିମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ଗରିବ୍ ନାରୁଡ଼୍‍ ମିକିଂଙ୍କ୍ ସାରେ ୱେଲେ ଦକିତଡ଼୍ । କିନ୍ତୁ ମିଡ଼୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ସାହାଯ୍ୟ ମାଡ଼ାଙ୍କ୍‍ ଇଚ୍ଛା ମାଡ଼ିତିଡ଼୍‍ ଆସୁଟ୍‍ ସାହାଯ୍ୟ ମାଡ଼େ ପାର୍‍ଦ୍‍ତିଡ଼୍‍, ନାନେ ମିକିଂଙ୍କ୍ ସାରେ ୱେଲେ ଦରକ୍‍ନ । ");
INSERT INTO kff_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ଆଦ୍ ତାନ୍‍ ସାମର୍ତ୍ୟ ଅନୁସାର୍‍ତେ ଇଦି ନା ମାୟିଦିଙ୍କ୍‍ ମାଡ଼୍‍ତେ ନାନେ ସମାଦି ଆଦାନ୍ ମୁନେନେ ଆଦ୍ ନାପର ଗାବ୍‍ ମାନ୍ଦାନ୍ ନିୟ୍ ତସ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ନାନ୍ ସତ୍ କେତୁତାନ୍‍, ସାରା ଜଗତ୍‍ତାଗେ ନା ସୁସମାଚାର୍ ବେଗେ ପ୍ରଚାର୍ ଆଦ୍‍ତେ, ଆଗେ ଇ ନାଟାଡ଼୍ ବାତେ ମାଡ଼୍‍ତେ, ଆଦ୍ ସାରେ ଏର୍କେ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ କେସ୍‍ମାନ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ଜିସୁନ୍ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍ ଆଗାଙ୍କ୍‍ ଇଷ୍କରିୟୋ ଯିହୁଦା ପେଦେର୍‍ତଣ୍ଡ୍ ଅର୍ତୁଣ୍ଡ୍‍ ଶିଷ୍ୟ ଜିସୁଙ୍କୁ ପସ୍କ୍‍ପିଦାଙ୍କ୍ ମୁକ୍ୟ ପୁରହିତ୍‌ତେ ଗାରେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ଅଡ଼୍‌ ଅନ୍‌ ଗଟିନେ କେଞ୍ଜି ୱେଡ଼୍‍ତଡ଼୍ ନୁ ଅଂକିଙ୍କ୍‌ ଆଦିନ୍‌ ମାଇଦିଙ୍କ୍‍ ବେସର୍‍ ଡ଼ାବ୍‍କ୍‍ ଅଦ୍‍ତି ଇଞ୍ଜ୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍ । ଆ ସମୟତେ ଜିସୁଙ୍କ୍‍ ଅଡ଼୍‌ କାଇଦା ପସ୍ପିଦାଙ୍କ୍‍ ଯିହୁଦାଲ୍ ସୁଯୋଗ ମେହେକ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","କମିରଶୂନ୍ୟ ରୋଟି, ପାଣ୍ଡୁ ଦିନାତେ ୱେଲେ ନିସ୍ତାର୍ ପାଣ୍ଡୁ ତିନ୍ଦାନ୍‍ ୱେଲେ ମେଣ୍ଢେପିଲେ ପୁଜ୍‍ଜେ ଇଦ୍‍ତଡ଼୍, ଶିଷ୍ୟଡ଼୍ ଜିସୁଙ୍କ୍ ପାଚ୍‍ରାମାଡ଼୍‍ତଡ଼୍, ମାମେ ବେନ୍‍ଏଡ଼୍ ନି ସେଙ୍ଗେ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ତିୟାର୍‍ ମାଡ଼ିତମ୍‍ ? ");
INSERT INTO kff_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ଜିସୁ ଇଡ଼୍‍ୱୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ ଇଦି ପାଡ଼୍‍ୟି ମାଡ଼ାନ୍‍ଙ୍କ୍‍ ରଅତଣ୍ଡ୍, “ମିଡ଼୍ ଟାଉନ୍‍ ଲୋପେ ଆନୁଟ୍ ।” ଆଗେ କୁଣ୍ଡେତାଗ୍‍ ଏର୍ ଅସ୍ ମାନ୍ଦାନ୍‍ ଅର୍ତୁଣ୍ଡ୍ ନାରୁଣ୍ଡ୍ କାଇଲିତଣ୍ଡ୍ । ଅନ୍‌ ପେର୍କେ ଆନୁଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ଅଣ୍ଡ୍‌ ବେନ୍‍ ଲୋନ୍‌‍ ନେଙ୍ଗିତଣ୍ଡ୍, ଆ ଲୋତ୍‍ତେ ମାଲିକିତିଙ୍କ୍ କେଲ୍‍ମୁଟ୍‍, “ଗୁରୁ କେତ୍‍ତଣ୍ଡ୍, ବେନ୍‍ ବାକ୍‍ଡ଼େତାଗେ ଅଣ୍ଡ୍‌ ତାମ୍‍ ଶିଷ୍ୟଡ଼୍‍ତଡ଼୍ ନିସ୍ତାର ପାଣ୍ଡୁମ୍‍ ମାଡ଼ିତଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍‍ ପରତାଦ୍‍ ଅଣ୍ଡୟ୍‌ ଲେକେତ୍ ସଜାମାଡ଼୍‍ତେ ବାକେଡ଼େ ତଅତିତଣ୍ଡ୍ । ଆଗେ ମିଡ଼୍ ମା ମାୟ୍‍ଦିଙ୍କ୍‍ ସାର୍ ବିଷୟ ତିଆର୍ ମାଡ଼ିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ଅଡ଼୍‌ ଇଡ଼୍‍ୱୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍ ଟାଉନ୍‍ତାଗ୍‍ ଆତ୍‍ତଡ଼୍ ନୁ ଜିସୁ କେତ୍‍ତେ ଲେକେ ସାର୍ ଗଟି ଉଡ଼୍‌ତଡ଼୍ । ଆଗେ ଅଡ଼୍‌ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍‍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ମୁଲୁପୁଟ୍‍ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍ତଡ଼୍‍ ଆ ବାକ୍‍ଡ଼େତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ତିନ୍ଦାଙ୍କ୍‍ କୁଦ୍‍ତେ ୱେଲେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‍, ନାନେ ନିଜାମ୍‍ କେତୁତାନ୍ ମି ଲୋପେଙ୍କ୍‍ ଅର୍ତୁଣ୍ଡ୍ ନା ବିରୋଦ୍ଦି ଆଦ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ନା ତଡ଼୍ ତିନ୍ଦାଙ୍କ୍‍ କୁଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ଶିଷ୍ୟଡ଼୍ ଇ ଗଟି କେଞ୍ଜି ୱେର୍‌ ୱେର୍‌ ପାଚାର୍‌ମାଡ଼୍‍ତଡ଼୍, “ନିମେ ନାକିଙ୍କ୍‍ ଉଡ଼ି ଇ ଗଟି କେଲ୍‍ୱିଡ଼୍‍ ତ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଜିସୁ ଉତ୍ତର ଇତ୍‌ତଣ୍ଡ୍‌, ମି ବାର ଜାନ୍‍ ଲୋପେଙ୍କ୍‍ ଅର୍ତୁଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ନା ତଡ଼୍ ଅଣ୍ଡୟ୍‌ ତାଲିତାଗ୍‍ ରୋଟି ମୁଉସ୍ ତିନ୍ଦୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ଶାସ୍ତ୍ରତାଗ୍‍ ଲେକ୍‌ତେ ଲେକାମ୍‌ ନାରୁଣ୍ଡ୍‍ ପିଲେ ଡ଼ଲିତେ । କିନ୍ତୁ ବେନ୍‍ ନାରୁଣ୍ଡ୍ ଅନ୍‌‍ ପର ବିରୋଦ୍‍ ମାଡ଼ିତଣ୍ଡ୍, ଅନ୍‌ ଦଶା ବେସର୍‍ ବୟଙ୍କ୍‍କର୍‍ ଆଦ୍‍ତେ । ଅଣ୍ଡ୍‌ ଜନମ୍‌ ଆୟିୱେ ମାତ୍‍କେ ଅନ୍‌‍ ପାକେ ଆୟ୍ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ଅଡ଼୍‌ ତିନ୍ଦା ସମୟ୍‍ତେ ଜିସୁ ଅଣ୍ଡୟ୍‌ ରୂଟି ଅସ୍ ଇଶ୍ୱରତିଙ୍କ୍‍ ଦନ୍ୟବାଦ୍‍ ଇତଣ୍ଡ୍ ନୁ ତାଙ୍କି ଉୱୁସ୍ ଶିଷ୍ୟଡ଼୍‍ଙ୍କି ଇସ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ଅୟମୁଟୁ, ତିନୁଟ୍‍ ଇଦି ନା ମେନ୍ଦୁଲୁ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ତାନ୍‍ ପେର୍କେ ଦ୍ରାକ୍ଷାରସ୍ ବର୍ତି ମାନ୍ଦାନ୍ ସଲ୍‍ତିଙ୍କ୍‍ ଅସ୍ ଇଶ୍ୱରତିଙ୍କ୍‍ ଦନ୍ୟବାଦ୍‍ ଇତଣ୍ଡ୍ ନୁ ଆଦ୍‍ ଶିଷ୍ୟଡ଼୍‍ଙ୍କି ଇତଣ୍ଡ୍ । ଅଡ଼୍‌ ଆଗାକଞ୍ଚ୍‌ ଉତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଜିସୁ କେତଣ୍ଡ୍, “ଇଦ୍‍ ନା ନେତୁର୍‍, ନାରୁନ୍‍ ପାପ୍‍ କ୍ଷମାତେ ମାଇଦିଙ୍କ୍‍ ନାନ୍‍ ନା ବେନ୍‍ ନେତୁରୁ ତସିଦାଙ୍କ୍‍ ଆଦୁତାନ୍‍, ଆଦ୍‍ ଇଶ୍ୱରତେ ପୁଃନେ ନିୟମ୍‍ ମାଡ଼ିତେ । ");
INSERT INTO kff_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ମିକିଂଙ୍କି କେସ୍ ନେଏତୁତାନ୍‍, ଇଶ୍ୱରତେ ରାଜ୍ୟ ପୁଃନେ ଅଙ୍ଗୁର୍‌ରସ୍ ଉନ୍ଦାନାଗାଙ୍କ୍‍, ନିଜାମ୍‍ ନାନେ ମେଣ୍ଡେ ବେସୁଙ୍କ୍‍ ଦ୍ରାକ୍ଷାରସ୍ ଉନନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ତାନ୍‍ ପେର୍କେ ଜିସୁ ନୁ ତାମ୍‍ ଶିଷ୍ୟଡ଼୍ ପାଟା ପାରଡ଼୍‍ ଜିତ ମେଟେତାଗ୍‍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍ଙ୍କି କେତଣ୍ଡ୍, ମିଡ଼୍‍ ନାକିଙ୍କ୍‍ ୱିଡ଼୍‍ସି ମିରିତିଡ଼ି । ଇ ବିଷୟତେ ଶାସ୍ତ୍ରତାଗେ ଲେକାଆସ୍ ମିନ୍ଦେ, ନାନେ ମେଣ୍ଢା ମେଇତାନଙ୍କ୍ ଆୱୁକିତାନ୍‍ ନୁ ମେଣ୍ଢା ଏକାମ୍‍ ଆଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","କିନ୍ତୁ ନାନେ ଡଲ୍‍ତାଗାଙ୍କ୍‍ ତେଏଦ୍‍ତେ ପେର୍କେ ମିଡ଼୍ ଆଦାନ୍‍ ମୁନେନ୍‍ନେ ଗାଲିଲୀତାଗ୍‍ ଆଦ୍‍ତାନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ପିତର କେତଣ୍ଡ୍, ସାରେତଡ଼୍ ୱିଡ଼୍‍ସି ଆତ୍‍କେ ବା ନାନେ ୱିଡ଼୍‍ସି ଆନନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜିସୁ ପିତରତିଙ୍କ୍‍ କେତଣ୍ଡ୍, ନାନ୍‍ ନିକିଙ୍କ୍‍ ସତ୍‍ କେତୁତାନ୍, ନେଣ୍ଡେ ନାର୍କା ରେଣ୍ଡେଦାମ୍‍ କର୍କ୍ କୁସାନ୍‍ ମୁନେ ନିମେ ନାକିଙ୍କି ମୁଣ୍ଡ୍‍ଦାମ୍‍ ପୁନନ୍‍ ଇଞ୍ଜ କେତିତିନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ପିତର ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍‍, “ନିତଡ଼୍ ଡଲାନ୍‍ଙ୍କ୍‍ ଆତ୍‌କେମିକା ବେସୁଙ୍କ୍‍ ବା ନିକିଙ୍କ୍‍ ପୁନନ୍‍ ଇଞ୍ଜ କେଲନ୍‍ ।” ବାଗାତ୍‌‍ ଶିଷ୍ୟଡ଼୍‌ ମିକା ଆଲେ କେତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ତାନ୍‍ ପେର୍କେ ଅଡ଼୍‌‍ ଗେତ୍‍ସମନି ପେଦେର୍‍ତେ ପଡ଼୍‍ୟତାଗ୍‍ ୱାତ୍‍ତଡ଼୍ ନୁ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ କେତ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ଇଗେ ସେନେକ୍‍ କୁଦାଟ୍‍ । ନାନେ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍‍ଙ୍କ୍‍ ଆଦୁତାନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ପିତର, ଯାକୁବ୍‍ ନୁ ଯୋହନ୍‌ତିଙ୍କ୍‌ ତଡ଼େକ୍‍ ଅସ୍ ଅଣ୍ଡ୍‌ ମୁନେ ଆତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ନାର୍ଗେ ଦୁଃକାମ୍‍ତେ ତିପାଲ୍ ଆତ୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ଆଗାଙ୍କ୍‌ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କ୍‍ କେତଣ୍ଡ୍, ଦୁଃକାମ୍‍ ନା ହୃଦୟତିଙ୍କ୍‍ ଦୁସ୍‌ତେ, ମିଡ଼୍ ଇଗେ କେପି ମାନୁଟୁ । ");
INSERT INTO kff_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ଜିସୁ ଇସୁର୍ ଆବାଡ଼୍‍ ଆଞ୍ଜ୍‍ କାପ୍‍ମୁଡ଼୍‍ନ୍ଦି ନେଲ୍‍ ରାଲତଣ୍ଡ୍ ନୁ ଯଦି ସମ୍ଵବ ଆୟେଡ଼୍, ଦୁକାମ୍‍ ଇୱକନ୍‍ ଆଦାଙ୍କ୍‍ ପ୍ରାର୍ତନା ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“ହୋ ନା ବାବାନି ! ନିଗାରେ ସାରେ ସମ୍ୱବ । ଇଦି ଉନ୍ଦାନ୍ ସଲେତ୍‍ ଏର୍‍ ନାୟାଗ୍‍କନ୍‍ ଜେକେ ଆୟମ୍ । ଆଦ୍ ଇଞ୍ଜେବା ନାୟାଦ୍‍ ଇଚ୍ଛା ଆୟ୍‌ୟ ନି ଇଚ୍ଛା ସଫଲ ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ତା ପେର୍କେ ମାଲସ୍ ଉଡ଼୍‍ତଣ୍ଡ୍, ମୁୱୁଡ଼୍ ଆସ୍‍ ଶିଷ୍ୟଡ଼୍ ଉଞ୍ଜି ମିନ୍ଦେଡ଼୍ । ଜିସୁ ପିତରତିଙ୍କ୍‍ କେତଣ୍ଡ୍, “ଶିମୋନ, ଉଞ୍ଜିତି ? ଅଣ୍ଡୟ୍‌‍ ଗଣ୍ଟେ କେପି ମାନ୍ଦାନଙ୍କ୍‍ ପାରିୱିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ମେଣ୍ଡେ କେତଣ୍ଡ୍, “କେପି ମାନୁଟୁ ବେଲା ପରିକ୍ଷାତାଗେ ପଡ଼େମ୍‍ ଆୱିଡ଼୍, ଆଦି ମାଇଦିଙ୍କ୍‍ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ । ଆତ୍ମା ଇଚ୍ଛା, କିନ୍ତୁ ମେନ୍ଦୁଲ୍‍ ଦୁର୍ବଲ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଅଣ୍ଡ୍‌ ଆଗାକନ୍‍ ମେଣ୍ଡେ ସୁଦୁର୍‌ ଜେକେ ଆଞ୍ଜ୍‍ ମୁନେ ଲେକେ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ");
INSERT INTO kff_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ମେଣ୍ଡେଦାମ୍‍ ମାଲ୍ସ୍‍ ୱାସ୍‍ ଉଡ଼ୁତଣ୍ଡ୍, ଶିଷ୍ୟଡ଼୍ ଉସ୍କାଡ଼୍‍ତେ ଅଡ଼୍‌ କଣ୍ଡା ତେର୍ତାଙ୍କ୍‍ ପାର୍ରୱଡ଼୍‌ ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌‍ ଅଙ୍କ୍‌ ବାତେ ଉତ୍ତର ଇତଣ୍ଡ୍, ପୁନ୍ଦେ ପାରୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ମୁଣ୍ଡ୍ ଦାମ୍‍ ମାଲ୍‌ତେ ୱେଲେ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍ଙ୍କି କେତଣ୍ଡ୍, ମିଡ଼୍ ଇଞ୍ଜେ ଆଇନା ଉଞ୍ଜି ମିନ୍ଦେଡ଼୍ ? ପିନା ଆଦୁତ୍‍ । ଉଡ଼ାଟ୍‍ ! ନାରୁଣ୍ଡ୍‍ ପିଲେତିଙ୍କି ନାରୁଡ଼୍ କାଇଦେ ପସ୍କିଦାନ୍‍ ସମୟ୍‍ ଏୱୁତେ । ");
INSERT INTO kff_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ତେଦାଟ୍‍, ଆନାଟି, ଉଡ଼ାଟ୍‍ ନାକିଙ୍କି ପସ୍ପିଦାନଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ ୱାସ୍ ହେୱୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ଜିସୁ ଇ ଗଟି କେତାନ୍‍ ୱେଲେ ତାନ୍‍ ବାର୍‍ଜାନ୍‍ ଶିଷ୍ୟଡ଼୍ ଲୋପେଙ୍କେ ଯିହୁଦା ପେର୍ଦେତେ ଶିଷ୍ୟୟ୍ ୱାସ୍ ଏୱୁତଣ୍ଡ୍ । ଅନ୍‌‍ ତଡ଼୍‍, ସୁରି ଟେଙ୍ଗା, ଡ଼ୁଡ଼ି ପଇସ୍ ପିନା ନାରୁଡ଼୍ ୱାସ୍‍ମାତଡ଼୍‍ । ମୁକ୍ୟ ପୁରହିତ୍‍ତଡ଼୍, ଦର୍ମଗୁରୁଡ଼୍ ନୁ ଦର୍ମନେତାଲଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ରସ୍‍ମାତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ବିରଦ୍‍ତେ ଯିହୁଦାଲ୍‍ ଜିସୁଙ୍କୁ ପସ୍ପିଦାଙ୍କ୍‍ ୱାଦାନ୍‍ ନାରୁକିଙ୍କି ଅଣ୍ଡୟ୍‌ ଚିନ୍ନେ ଇଦାନଙ୍କ୍‍ ଇଞ୍ଜ୍‍ ଟିକ୍‍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍‍ । ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍‍, ବେନଙ୍କ୍‍ ନମସ୍କାର୍‍ ମାଡ଼ିତାନ୍‍, ଅଙ୍କେ ମିଡ଼୍ ମେହେକ ମାନ୍ଦାନଣ୍ଡ୍‍ । ଅଂକିଙ୍କ୍‌ ଗିର୍‍ପ୍‍ ମାଡ଼ି ତସ୍କ୍‍ ଅୟ୍‍ମୁଟୁ । ");
INSERT INTO kff_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଯିହୁଦାଲ୍‍ ୱାସ୍‍ୱାନାଙ୍କ୍‍ ଜିସୁନ୍‍ ଗାରେ ଆଞ୍ଜ ଅଂକିଙ୍କ୍‌ “ଗୁରୁ,” ଇଞ୍ଜ୍‍ କେସଡ଼୍ କେସଡ଼୍‍ ନମସ୍କାର୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ଆସୁଟ୍‍ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍‍ ଗିରପ୍‍ ମାଡ଼ି ତଃତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","କିନ୍ତୁ ଗାରେ ନିସ୍ ମାନ୍ଦାନ୍‍ ଅର୍ତୁଣ୍ଡ୍ ନାରୁନ୍‌ ସୁରୁ ପେସ୍ପି ବାଡ଼ିୟେ ଯାଜକତେ ଦାସଙ୍କ୍‍ ତୁର୍ସି ଅନ୍‌‍ କେୱ୍‍ ନାଡ଼୍‍କ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜିସୁ ନାରୁଡ଼କିଙ୍କି କେତ୍‍ତଣ୍ଡ୍‍, “ନାନେ ବାତେ ବେଏ ମିରୁତାନ୍‍ ଯେ, ଟେଙ୍ଗା, ଡ଼ୁଡ଼ି ପୟିସ୍‍ ନାକିଙ୍କ୍ ପଇତାନଙ୍କ୍‍ ୱାତିଡ଼ି ? ");
INSERT INTO kff_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ଦିନା ଦିନା ପଇସ୍ ନାନେ ମନ୍ଦିର୍‍ତାଗେ ଶିକ୍ଷା ଇସମାତ୍‍ତାନ୍‍; ଆସୁଟ୍ ତ ନାକିଙ୍କି ଗିରାପ୍‍ ମାଡ଼ିୱିଡ଼୍ । କିନ୍ତୁ ଶାସ୍ତ୍ରତେ ଗଟି ସାରେ ଆଦ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ଆସୁଟ୍ ଶିଷ୍ୟଡ଼୍ ସାରେତଡ଼୍ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ମିରିତଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ଅର୍ତୁଣ୍ଡ୍‍ ଲେୟଣ୍ଡ୍ ଅଣ୍ଡୟ୍‌‍ ଚାଦର୍‍ ମୁସି ଜିସୁନ୍‍ ପେର୍କେ ଆଞ୍ଜ୍‍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପଇତାଙ୍କ୍‍ ଆଦାନ୍‍ ୱେଲେ, ");
INSERT INTO kff_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ଅଣ୍ଡ୍‌ ତାନ୍‍ ଚକାସିଲେ ଏସି ଡ଼ୁନ୍‍ଟାଲ୍‍ ଆସ୍‍ ମିର୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ତାନ୍‍ ପେର୍କେ ଅଡ଼୍‌ ଜିସୁଙ୍କୁ ବାଡ଼ିୟ୍‍ ପୁରହିତ୍‌ତନ୍ ଲନ୍ ଅତ୍‍ତଡ଼୍ । ଆଗେ ମୁକ୍ୟ ପୁରହିତଡ଼୍‌, ର୍ଦମ ନେତାଲଡ଼୍ ନୁ ର୍ଦମ ଗୁରୁଡ଼୍ ଗୁଡ଼ିମାତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତର ଇସୁର୍ ଯେକେ ମାଞ୍ଜ୍‍ ଅଡ଼୍‌ ପେର୍କେ ଆତଣ୍ଡ୍ ନୁ ବାଡ଼ିୟେ ପୁରହିତଡ଼୍‌ ଲନ୍‍ କୁଦି ମାନ୍ଦ୍‍ନାଗ୍‍ ନେଙ୍ଗ୍‌ତଣ୍ଡ୍ । ଆଗେ କେପାନଡ଼୍‍ ତଡ଼୍ ନିଜେତିଙ୍କ୍‍ କାପାନଙ୍କ୍‍ ଆଗେ କିସ୍‍ ଗାରେ କୁଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ମୁକ୍ୟ ପୁରହିତିଡ଼୍ ନୁ ମହାସବାତେ ସଦସ୍ୟନଡ଼୍ ଜିସୁଙ୍କୁ ଡଲାନ୍‌ଦଣ୍ଡ୍ ଇଦାଙ୍କ ଅନ୍‌‍ ବିରୁଦ୍ଦ୍‌ତେ ଦଷ୍‌ ମେକାନଙ୍କ୍ ପସ୍ପ୍‍ତଡ଼୍, କିନ୍ତୁ ବାତେବା ଦର୍ସ୍‍କଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼ୁ ଜିସୁନ୍‍ ବିରୁଦ୍ଦ୍‌ତେ ମିଚ୍‍ ସାକ୍ଷି ଇତଡ଼୍, କିନ୍ତୁ ଅଡ଼୍‌ ସାକ୍ଷି ତାମ୍‍ତାମ୍ ଲୋପେ କାଇଲ୍‍ ଆତା । ");
INSERT INTO kff_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ତାନ୍‍ ପେର୍କେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼ୁ ନିସ୍ ଜିସୁନ୍‍ ବିରୁଦ୍ଦ୍‌ତେ ମେଣ୍ଡ୍‍ ମିଚ୍‍ ଗଟ୍‍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, ମାମ୍‍ କେଞ୍ଚ୍‍ତମ୍‍ ଅଣ୍ଡ୍‌ କେଲ୍‍ନୁଣ୍ଡ୍, “ନୁରୁଡ଼ୁ କାଇଦେ ତିଆର୍‍ ମାଡ଼୍‍ତେ ମନ୍ଦିର୍‌ତିଙ୍କ୍ ନାନେ ମାଣ୍ଡୁଲ୍‍ ତାଗେ କାଲ୍‍ପିତାନ୍‍, ମୁଣ୍ଡ୍ ଦିନା ଲୋପେ ନାରୁଡ଼ୁ ତିଆର୍ ମାଡ଼୍‍ୱାଦ୍‍ ମେଣ୍ଡନ୍‌ ମନ୍ଦିର୍‍ ତିଆର୍‍ ମାଡ଼ିତାନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ଇଡ଼୍ ଗଟିବା ବେନ ବେନନାଗେ କାଇଲ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ବାଡ଼ିୟେ ପୁରହିତ୍ ସାରେତଡ଼୍ ମୁନେ ନିସ୍‍ ଜିସୁଙ୍କୁ ପ୍ରଶ୍ନ ମାଡ଼୍‍ତଣ୍ଡ୍, ନି ବିରୁଦ୍ଦ୍‌ତେ ଅଡ଼୍‌ ତାସ୍ ମାନ୍ଦାନ୍‍ ଇଗଟି ବିରୁଦ୍ଦ୍‌ତେ ନିମେ ବାତେ କେତାନାଦ୍‍ ଇଲେ ? ");
INSERT INTO kff_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","କିନ୍ତୁ ଜିସୁ ବାତେ କେଲକଟ କଟମାତ୍‍ତଣ୍ଡ୍ । ବାଡ଼ିୟେ ପୁରହିତ୍ ମେଣ୍ଡ୍‍ଦାମ୍‍ ଅଂକିଙ୍କ୍‌ ପାସ୍‍ରିଞ୍ଚତଣ୍ଡ୍, ନିମେ ବାତେ ମସୀହ ମହାମହିମ୍‍ତେ ଇଶ୍ୱରତେ ମାରିନି ? ");
INSERT INTO kff_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜିସୁ ଉତ୍ତର ଇତଣ୍ଡ୍, “ହଁ ନାନେ ଅଣ୍ତେ । ନିମେ ନାରୁଡ଼ୁ ପିଲେତିଙ୍କ୍‍ ସର୍ବ ଶକ୍ତିମାନ୍‍ତେ ତିନ୍ଦେ ପାକେ କୁଦି ମାନ୍ଦ୍‍ନାଦ୍‍ ଉଡ଼ିତିଡ଼୍ ନୁ ଅଣ୍ଡ୍‌ ସ୍ୱର୍ଗତେ ମୟଲତାଗାଙ୍କ୍‍ ୱାଦାନାଦ୍‍ ଉଡ଼ିତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ବାଡ଼ିୟେ ପୁରହିତ୍ ନିଜ୍‍ ସିଲେ ଇକି କେତଣ୍ଡ୍, ମେଣ୍ଡ୍ ବାତେ ସାକ୍ଷି ଦରକାର୍‍ ଇଲେ, ");
INSERT INTO kff_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ଅଣ୍ଡ୍‌ ଇଶ୍ୱରତିଙ୍କି ଲିନ୍ଦେ ମାଡ଼ୁତଣ୍ଡ୍, ମିଡ଼୍ କେଞ୍ଜୁତିଡ଼୍ । ମିୟାଦ୍‌ ବାତେ ଇଚ୍ଛା ? ଅଡ଼୍‌ ତାନ୍‍ ବିରୁଦ୍ଦ୍‌ କେତ୍‍ତଡ଼୍‍ ଅଙ୍କ୍‌ ଦଷି ନୁ ଡଲାନ୍‌ଦଣ୍ଡ୍ ଇଦାନାଦ୍‍ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ବେସ୍‍କେ ନାରୁଡ଼ୁ ଜିସୁନ୍‍ ପର୍ ଉସ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଅନ୍‌ କଣ୍ଡାଙ୍କ୍ ସିଲେ ତଃସ୍ ଅଂକିଙ୍କ୍‌ ରେହେସ୍‌ ପାସ୍‍ରିଞ୍ଚ୍ ତଡ଼୍, “ବେନ୍ ନିକିଙ୍କି ରେହେତଡ଼୍‍, କେଲ୍‌ମ୍‍ ।” କେପାନଡ଼୍ ଅଂକିଙ୍କ୍‌ ତହସ୍ ସାପୁଡ଼ା ରେହେତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ପିତର ବାଡ଼୍‍ୟେ ପୁରହିତ୍‌ତନ୍‍ ଲନ୍‍ତେ ଲୋପେ ମାନ୍ଦାନ୍ ୱେଲେ ବାଡ଼୍‍ୟେ ପୁରହିତ୍‌ତେ ଆ ଦାସି ଆଦେ ଆର୍ର୍ ଇସ୍ ଆତ୍‍ତେ ");
INSERT INTO kff_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ନୁ ପିତର କିସ୍‍ ଆରାନାଦ୍‍ ଉଡ଼ି ଅକିଂଙ୍କ୍‌ ଲେକେତ୍‍ ଉଡ଼ି କେତ୍‌ତନ୍‌, ନିମେବା ନାଜରିତେ ଜିସୁନ୍‌ତଡ଼୍ ମାତ୍‍ତିନି । ");
INSERT INTO kff_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ପିତର ପୁନ୍‍ୱେ ଲେକେ କେତଣ୍ଡ୍, ନାନେ ଅଂକିଙ୍କ୍‌ ପୁନନ୍‍ । ନିମେ ବାତେ କେତୁତି ନାନେ ବୁଜେମ୍‍ ଆୟନ୍‌ । ଆଲା କେସ୍ ଅଣ୍ଡ୍‌ ଲୋତ୍‍ତେ ଲୋପେତେ ଆର୍ର୍‍ଦେ ପାକେ ପେଇସ୍‍ ଆତଣ୍ଡ୍ । ଆସୁଟେ କର୍କ୍ କୁସ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଆ ଦାସିଲି ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡ୍ ଦାମ୍‍ ଉଡ଼ି ଆଗେ ନିସ୍ ମାନ୍ଦାନ୍‍ ନାରୁଡ଼ୁକିଙ୍କି କେତ୍‍ତେ, ଇ ନାରୁଣ୍ଡୁ ଅଡ଼୍‌ ଲୋପେଙ୍କେ ଅର୍ତୁଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ପିତର ମେଣ୍ଡ୍‍ଦାମ୍‍ ପୁନ୍‍ୱେ ଲେକେ ମାତ୍‍ତଣ୍ଡ୍ । ସେନେକ୍‍ ମାଞ୍ଜ୍‍ ଆଗେ ନିସ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼ୁ ପିତରତିଙ୍କ୍‍ କେତ୍‍ତଡ଼୍, ନିଜାମ୍‍ ନିମେ ଅଡ଼୍‌ ମାନ୍ଦେତନି ଆୟ ଇଞ୍ଜ କେତାନଙ୍କ୍‍ ପାରିୱି । ବାତେଙ୍କ୍‌ଇତ୍କେ ନିମା ଗାଲିଲୀତେ ନାରୁନି । ");
INSERT INTO kff_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ପିତର ଉତ୍ତର ଇତଣ୍ଡ୍, ନାନେ ପ୍ରମାଣ୍ ମାଡ଼ି କେତୁତାନ୍‍, ନା ଗଟ ସତ୍‍ । ଇଲୁକ୍‍ ଇଶ୍ୱର ନାକିଙ୍କି ଦଣ୍ଡ୍ ଇୱିଣ୍ଡ୍ । ବେନନ୍‍ ଗଟି କେତୁତିଡ଼୍, ଅଂକିଙ୍କ୍‌ ନାନେ ପୁନନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ଆସୁଟେ ମୁଣ୍ଡ୍‍ଦାମ୍‍ କର୍କ୍ କୁସ୍‍ତା ନୁ ପିତରତିଙ୍କ୍‍ ଏର୍କେଆତ୍‍ତେ; ଜିସୁ କେସ୍ ମାତ୍‍ତଣ୍ଡ୍, କର୍କ୍ ରେଣ୍ଡ୍‍ଦାମ୍‍ କୁସାନ୍‍ ମୁନେ ନିମେ ନାକିଙ୍କି ମୁଣ୍ଡ୍‍ଦାମ୍‍ ପୁନନ୍‍ ଇଞ୍ଜ କେତିତି । ଅଣ୍ଡ୍‌ ଦୁଃକାତେ ମୁର୍‍ମୁରା ଆସ୍‍ କେୟ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ବାଡ଼ିୟେ ପୁରହିତଡ଼୍‌ ୱିୟ୍‍ତେ ୱିୟ୍‍ୱାକେ ଦର୍ମନେତାଲଡ଼୍, ଦର୍ମଗୁରୁଡ଼୍ ନୁ ବାଡ଼ିୟେ ମିଟିଙ୍ଗ୍‍ତେ ସଦ୍ୟନଡ଼୍ ତଡ଼୍ କେସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ପାଡ଼୍‌ୟି ମାତ୍‍ତଡ଼୍‍ । ଜିସୁଙ୍କୁ ଇକ୍‍ଲେମ୍‍ତାଗେ ତସ୍କ୍‍ ଆସ୍‍ ପିଲାତନ୍‌ କାଇଦେ ଇତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତ୍ ଜିସୁଙ୍କୁ ପାର୍ରିଞ୍ଚ୍‍ତଣ୍ଡ୍, ନିମେ ବେନ୍‍ ଇହୁଦିଡ଼୍‍ ରାଜାନି ? ଜିସୁ ଉତ୍ତର ଇତଣ୍ଡ୍, ନିମେ ତ ଆଦ୍‍ କେତୁତି । ");
INSERT INTO kff_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ମୁକ୍ୟ ପୁରହିତିଡ଼୍ ଜିସୁନ୍‍ ବିରୁଦ୍ଦ୍‌ତେ ବେସର୍‍ ଗଟି କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ଆସୁଟ୍‍ ପିଲାତ୍‍ ମେଣ୍ଡ୍‍ଦାମ୍‍ ଜିସୁଙ୍କୁ ପାର୍ରିଞ୍ଚ୍‍ତଣ୍ଡ୍, ନିମେ ବାତେ ଉତ୍ତର ଇୱିନ୍‍ ? ନି ବିରୁଦ୍ଦ୍‌ତେ ଇ ସାରେ ଗଟି କେତାନାଦ୍‍ କେଞ୍ଜୁତିନ୍‍ ତ ! ");
INSERT INTO kff_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ଜିସୁ ପଦେଣ୍ଡେ ବା ଗଟ କେଲ୍‍ୱାଙ୍କ୍‍ ପିଲାତ୍‍ କଟ ଆତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ସାରେ ଏଣ୍ଟକ୍‍ ନିସ୍ତାର ପାଣ୍ଡୁମ୍‍ ସମୟତେ ନାରୁଡ଼୍‍ ଦାବି ଲେକାମ୍‌ ପିଲାତ୍‍ ୱେରଙ୍ଗ୍‍ ବନ୍ଦି ନାରୁଙ୍କ୍‌ ମୁକ୍ତି ମାଡ଼ିସମାତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଆସୁଟ୍‍ ଗଲ୍‍କିନଡ଼୍ ନୁ ନାରୁଙ୍ଗ୍‍ ଆୱୁକ୍‍ତେ ନାରୁଡ଼୍‍କୁ ବେସ୍କ୍‍ତୁଡ଼୍‍ ବିଦ୍ରୋହିଡ଼୍ ତଡ଼୍ ବାରବ୍‍ବା ପେଦେର୍‌ତଣ୍ଡ୍ ନାରୁଣ୍ଡୁ ଜେଲ୍‍ ଦଣ୍ଡ୍ ବଗେମ୍‍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ଆସୁଟ୍‍ ସାରେ ଗୁଡ଼ି ମାନ୍ଦାନ୍‍ ନାରୁଡ଼୍ ମୁନେତ୍‍ ରିତି ଲେକାମ୍‌ ଅର୍‌ତୁଙ୍କୁ ୱିଡ଼୍‍ସିଦାଙ୍କ୍‍ ଦାବି ମାଡ଼ି କେତ୍‍ତଡ଼୍‍, ");
INSERT INTO kff_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ପିଲାତ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ପାର୍ରିଞ୍ଚ୍‍ତଣ୍ଡ୍‍, ଇହୁଦିଡ଼୍ ରାଜାଙ୍କ୍ ନାନେ ମୁକ୍ତି ମାଡ଼ିତାନ୍‍ ଇଞ୍ଜ୍ ମିଡ଼୍ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ପିଲାତ୍‍ ପୁଞ୍ଜ୍‍ ମାତ୍‍ତଣ୍ଡ୍ ଯେ ମୁକ୍ୟ ପୁରହିତ୍‌ତଡ଼୍‌ ଇଂସା ଆସ୍‍ ଜିସୁଙ୍କୁ ଅନ୍‌‍ କାଇଦେ ପସ୍କ୍‍ପିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","କିନ୍ତୁ ବାରବ୍‍ବାଙ୍କ୍‍ ମୁକ୍ତି ମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍‍ ପିଲାତ୍ ଗାରେ ଦାବି ଜଣାମାଡ଼୍‍ଙ୍କ୍‍ ମୁକ୍ୟ ପୁରହିତ୍‌ତଡ଼୍‌ ନାରୁଡ଼୍‍କ୍‍ କେତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ପିଲାତ୍‍ ନାରୁଡ଼୍‍କ୍ ମେଣ୍ଡ୍‍ଦାମ୍‍ ପାର୍ରିଞ୍ଚ୍‍ତଣ୍ଡ୍, ଆଲେକେ ମିଡ଼୍ ବେନଙ୍କ୍ ଇହୁଦିଡ଼୍ ରାଜାଲ୍‍ ଇଞ୍ଜ୍‍ କେତୁତିଡ଼୍, ଅଂକିଙ୍କ୍‌ ନାନେ ବାତେ ମାଡ଼ିତାନ୍‍ ? ");
INSERT INTO kff_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ନାରୁଡ଼୍ କିଡ଼୍‍କି କେତ୍‍ତଡ଼୍, ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗେ ତାରସ୍କ୍‍ପାଟ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ପିଲାତ୍‍ ପାର୍ରିଞ୍ଚ୍‍ତଣ୍ଡ୍, କିନ୍ତୁ ଅଣ୍ଡ୍‌ ବାତେ ଦୋଷ ମାଡ଼୍‍ତଣ୍ଡ୍ ? ଅଡ଼୍‌ ମେଣ୍ଡ୍ ମର୍‍ଆସ୍ କେତ୍‍ତଡ଼୍, “ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗ୍‍ ତାରସ୍କ୍‍ପାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ପିଲାତ୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍‍ ଶାନ୍ତି ମାଡ଼ାନଙ୍କ୍‍ ପାର୍ୱେ ମାତ୍‍ତଣ୍ଡ୍, ଆଦିଙ୍କ୍‍ ଅଣ୍ଡ୍‌ ବାରବ୍‍ବାଙ୍କ୍‍ ମୁକ୍ତି ମାଡ଼ିତଣ୍ଡ୍ ନୁ ଜିସୁଙ୍କୁ କଡ଼ାନ୍‍ତଡ଼୍ ରେହେସ୍ କ୍ରୁଶତାଗେ ତାର୍‌ସ୍ପାନଙ୍କ୍‍ ଅଡ଼୍‌ କାଇଦେ ୱିଡ଼୍‍ସିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ସୈନିକିଡ଼୍ ଜିସୁଙ୍କୁ ପିଲାତନ୍‌ ପ୍ରାସାଦ୍‍ତେ ଲୋପେ ଆତ୍‍ତଡ଼୍ । ଆଗେ ସୈନିକିଡ଼୍ ସାରେତଡ଼୍ ଅଣ୍ଡୟ୍‌‍ତାଗେ ଗୁଡ଼୍‌ତଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ଅଡ଼୍‌ ଜିସୁଙ୍କୁ ଅଣ୍ଡୟ୍‌ ଆପେ ରଙ୍ଗ୍‌ତାଦ୍‌ ସିଲେ କେର୍ସ୍ପତଡ଼୍ ନୁ କୟେ ମାଡ଼େତେ କମେତେ ଅଣ୍ଡ୍‌ ସହଜ୍‌ ତିଆର୍‍ ମାଡ଼ି ଅନ୍‌‍ ତାଲେତାଗେ କେର୍‍ସ୍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ତାନ୍‍ପେର୍ରକେ ଜିସୁଙ୍କୁ ନମସ୍କାର ମାଡ଼ି କେତ୍‍ତଡ଼୍, ଇହୁଦିଡ଼୍ ରାଜାଲ୍ ଚିରଞ୍ଜିବି ଆଇଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ଅଡ଼୍‌ ଅନ୍‌‍ ତାଲ୍‍ତିଙ୍କ୍‍ ଡୁତେ ରେହେତଡ଼୍, ଅନ୍‌‍ ପର୍‍ ଉସ୍‍ତଡ଼୍ ନୁ ମରମିଣ୍ଡା ଉୱୁସ୍ ପ୍ରଣାମ୍‍ ମାଡ଼ାନ୍‍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ଇଲାନେ ଅଂକିଙ୍କ୍‌ ପରିହାସ୍‍ ମାଡ଼ି ତେରେତେ ପେର୍କେ ଆପେ କଲର୍‍ତେ ସିଲେ ଟେଣ୍ଡି ଅନ୍‌‍ ନିଜର ସିଲେ କେର୍‍ସ୍ପିତଡ଼୍ । ତାନ୍‍ ପେର୍କେ ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍ପାନଙ୍କ୍‍ ଅତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ଆର୍ରଦାଗ୍‍ ଅଡ଼୍‌ ଶିମୋନ ପେର୍ଦେତେ ଅର୍‌ତୁଙ୍କ୍‌ ନାରୁଙ୍କୁ କାୟ୍‍ଲ୍‍ତଡ଼୍ । ଅଣ୍ଡ୍‌ ନାର୍‍କନ୍‍ ଟାଉନ୍‍ତା ୱାସମାତଣ୍ଡ୍ । ଜିସୁଙ୍କୁ କ୍ରୁଶ କାଞ୍ଚ୍‍ପାନଙ୍କ୍‍ ସୈନ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ ବାଦ୍ୟ ମାଡ଼୍‍ତଡ଼୍ ଇ ଶିମୋନ କୁରୁନିୟତେ ନାରୁଣ୍ଡୁ ମାତ୍‍ତଣ୍ଡ୍ । ଅଙ୍କ୍‌ ଇଉଡ଼୍ ମାର୍କ୍ ମାତ୍‍ତଡ଼୍ ଆଲେକ୍‍ଜାଣ୍ଡାର ନୁ ରୁଫସ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ଅଡ଼୍‌ ଜିସୁଙ୍କୁ ଗଲ୍‍ଗତା ପେର୍ଦେତେ ପଡ଼ିୟତାଗ୍‍ ଅତ୍‍ତଡ଼୍ । ଗଲଗତାତେ ଅର୍ତ ଆଦୁତ୍‍ ତାଲେତ୍‍ ମୁଞ୍ଜ୍‍, ");
INSERT INTO kff_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ଆଗ୍‍ ଅଡ଼୍‌ ଜିସୁଙ୍କୁ ଗାବ୍‍ମାନ୍ଦାନ୍‌ କାଲ୍‍ କାଲିପି ଉନ୍ଦାନଙ୍କ୍‍ ଇତଡ଼୍ । କିନ୍ତୁ ଜିସୁ ଆଦିଙ୍କ୍‍ ଉନଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ତାନ୍‍ ପେର୍ରକେ ଅଡ଼୍‌ ଜିସୁଙ୍କୁ କ୍ରୁଶବିଦ୍ଦ୍‌ ମାତ୍‍ତଡ଼୍ ନୁ ଲଟ୍ରି ମାଡ଼ି ଅନ୍‌‍ ସିଲେ ସାର୍‍ ନିଜନିଜ ଲୋପେ ବାଗ୍‍ମାଡ଼ି ଅତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ନାର୍କୁକ୍‍ ନଟାତେ ଜିସୁ କ୍ରୁଶବିଦ୍ଦ୍‌ ଆତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଅନ୍‌‍ ସମ୍ପର୍କତେ ଅବିଯୋଗ୍‍ ଚିଟି‍ ଇଲା ଲେକେ ଆସ୍ ମାତ୍‍ତେ, “ଇହୁଦିଡ଼୍ ରାଜାଲ୍‍ ଇଞ୍ଜ୍‍ ଲେକା ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ଅଡ଼୍‌ ଆଦ୍‍ନାଣ୍ଡ୍ ଇରିଉଡ଼୍ ଦସିଡ଼୍‍କ୍‍ ବା କ୍ରୁଶତାଗ୍‍ ତାସ୍ପ୍‍ତଡ଼୍ ଅର୍‌ତୁଙ୍କ୍‌ ଜିସୁନ୍‍ ଡ଼େବ୍‍ ପାକେ ନୁ ମେଣ୍ଡ୍ ଅର୍ତୁଣ୍ଡ୍ ଅନ୍‌‍ ତିନ୍‍ପାକେ କ୍ରୁଶବିଦ୍ଦ୍‌ ମାଡ଼୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ଅଣ୍ଡ୍‌ ଅପରାଦିତଡ଼୍ ଦଶା ଆତ୍‍ତେ ।” ଶାସ୍ତ୍ରତେ ଇ ବବିଷ୍ୟତ୍‍ବାଣି ଇଲାନେ ସଫଲ୍‍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ଆଲା ଆଞ୍ଜମାନ୍ଦାନ୍‌ ନାରୁଡ଼୍ ତାଲେ ତେସ୍ ଜିସୁଙ୍କୁ ଅପମାନ୍‍ ଇସ୍ କେତ୍‍ତଡ଼୍, ହୋ ନିମ୍‍ତ ମନ୍ଦିର୍‌ ଉୱୁସ୍ ମୁଣ୍ଡୁ ଦିନାଲୋପେ ତିଆର୍‍ ମାଡ଼ିଦାନ୍‍ନି । ");
INSERT INTO kff_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ଇଞ୍ଜେ କ୍ରୁଶକନ୍‍ ଡ଼ିଗି ୱାସ୍ ନିଜେତିଙ୍କି ରକ୍ଷା ମାଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ମୁକ୍ୟ ପୁରହିତ୍‌ତଡ଼୍‌ ନୁ ଦର୍ମଗୁରୁଡ଼୍ ଆଲେନେ ଅଂକିଙ୍କ୍‌ କେଞ୍ଜ୍‍ତେ ଲେକେ ତାମ୍‍ତାମ୍‍ କେତା କେତି ଆତଡ଼୍, ଅଣ୍ଡ୍‌ ୱେରେ ତଡ଼୍‍କିଙ୍କି ରକ୍ଷା ମାଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, କିନ୍ତୁ ଇଞ୍ଜେ ନିଜେତିଙ୍କ୍‍ ରକ୍ଷା ମାଡ଼୍‍ପାର୍‍ୱ୍‍ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ଇଶ୍ରାୟେଲ୍‍ତେ ରାଜାଲ୍‍ ମସୀହ ଇଞ୍ଜେ କ୍ରୁଶକନ୍‍ ଡ଼ିଗି ୱାଡ଼୍‍ଣ୍ଡି, ଆଲେକେ ମାମ୍‍ ଅଙ୍କ୍‌ ବିଶ୍ୱାସ ମାଡ଼ିତମ୍‍ ତାନ୍‍ ତଡ଼୍ ମାନ୍ଦାନ୍‍ ଇର୍‌ୱୁଡ଼୍ ସାଙ୍ଗଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କାୱୁସ୍ କାୱୁସ୍‍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ଆଦ୍‍ନାଣ୍ଡ୍ ପାୟ୍‍ଲ୍‍ତେ ହଲ୍‍ ମୁଣ୍ଡୁ ଗଣ୍ଟା ସାରେ ଦେଶ୍‍ ଇକାଡ଼୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ପାୟାଲ୍‍ତେ ଅଲ୍‍ ତିନିଟାୱେଲେ ଜିସୁ ଲେଙ୍ଗ୍‍ଟେଣ୍ଡି କେତ୍‍ତଣ୍ଡ୍, ଏଲୋହି, ଏଲୋହି, ଲାମା ଶବକ୍‍ତାନି । ହୋ ନାଆ ଇଶ୍ୱର ତନି, ହୋ ନାଆ ଇଶ୍ୱର ତନି, ନାକିଙ୍କି ବାତେଙ୍କ୍‍ ୱିଡ଼୍‍ସି ମିନ୍ଦେନି ? ");
INSERT INTO kff_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ଅନ୍‌‍ ହି ଗଟି କେଞ୍ଜି ବେସ୍‍କ୍‍ତୁ କେତ୍‍ତଡ଼୍, ଅଣ୍ଡ୍‌ ଏଲିୟ୍‍ଙ୍କ୍‍ କାର୍‍ଙ୍ଗୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ଅଡ଼୍‌ ଲୋପେଙ୍କେ ଅର୍ତୁଣ୍ଡ୍‍ ମିରି ଆଞ୍ଜ୍‍ ପସ୍କେତିଙ୍କି ପୁଲ୍ଲେ ଅଙ୍ଗୁର୍‌ ଏର୍‌ ମୁହୁସ୍ ଅଣ୍ଡୟ୍‌‍ ଡ଼ୁଡ଼୍‍ତେ ମୁନେ ତସ୍କ୍‍ ନୁ ଆଦ୍‍ ଜିସୁ ପାୟୁର୍‍‍ତେ ଗାର୍‌ରେ ପଇସ୍‌‍ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼ିତାନ୍‍, ଅଂକିଙ୍କ୍‌ କ୍ରୁଶକନ୍‍ ଡ଼ିପାନଙ୍କ୍‍ ଏଲିୟ ୱାଦୁତ୍‍ଣ୍ଡ୍ ଇଲେ ?” ");
INSERT INTO kff_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ଜିସୁ ଆସୁଟେ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେସ୍ ଡଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ମନ୍ଦିର୍‍ ତାଗେ ଉଙ୍ଗମାତେ ପରଦା ପର୍‍କନ୍‍ ମଦଲ୍ ହେୱୁନା ରେଣ୍ଡେ ଦୁଡ଼୍ ଇଙ୍ଗିଆତେ । ");
INSERT INTO kff_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ଅର୍ତୁଣ୍ଡ୍ ସେନାପତି ଜିସୁନ୍‍ କ୍ରୁଶତେ ମୁନେ ନିସ୍‍ ଅଣ୍ଡ୍‌ ବେଲା ଡ଼ଲ୍‍ତଣ୍ଡ୍, ଆଦ୍‍ ଲେକେତ୍‍ ଉଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ କେତଣ୍ଡ୍, ଇ ନାରୁଣ୍ଡୁ ନିଜାମ୍‍ ଇଶ୍ୱରତେ ମାର୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ବେସ୍‍କେ ନାଟା ଜେକେ ମାଞ୍ଜ୍‍ ଇ ସାରେ ଉଡ଼୍ ମାତ୍‍ତା । ଆୱିନ୍‍ ଲୋପେ ମାତ୍‍ତେ ମଗ୍‍ଦଲୀନି ମରୀୟମ୍, ସୁଜୁରୁ ଯାକୁବ ନୁ ଯୋଶିନ୍‍ତେ ୟାୟ୍‍ ମରୀୟମ୍ ନୁ ଶଲୋମି । ");
INSERT INTO kff_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଜିସୁ ଗାଲିଲୀତାଗ୍‍ ମାନ୍ଦାନ୍‍ ୱେଲେ ଆୱୁ ଅଙ୍କ୍‌ ଅନ୍‌ପେର୍କେ ଆଞ୍ଜ ସାହାଯ୍ୟ ମାଡ଼ ମାତ୍‍ତା । ତାନ୍‍ ତଡ଼୍ ଯିରୁଶାଲମତେ କନ୍‍ ୱାସ୍‍ ମାତ୍‍ତେ ପିନା ନାଟା ଆଗେ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ଆଦ୍‍ ନାଣ୍ଡ୍ ମୁଲୁପୁଟ୍‍ ଆରମାତିଆତେ ଯୋସେପ୍‌ ୱାସ୍ ହେୱୁତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ବାଡ଼ିୟେ ମିଟିଙ୍ଗିତେ ସମ୍ମାନତେ ସଦସ୍ୟ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଇଶ୍ୱରତେ ରାଜ୍ୟ ୱାଦାନାଦିଙ୍କି କେପମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ଆଦ୍ ନାଣ୍ଡ୍ ମାତ୍‍ତେ ତିଆର୍‍ ମାଡ଼ନ୍‍ ଦିନାମ୍ ବା ରମାନ୍‌ଦିମ୍‍ତେ ମୁନେତ୍‌ ଦିନାମ୍‍ । ଆରମାତିଆତେ ଯୋସେଫ ୱେର୍ରୱ କନ୍ ପିଲାତେ ଗାରେ ଆଞ୍ଜ୍ ଜିସୁନ୍‍ ଡ଼ଲତେ ମଡ଼୍ ଆଦାନଙ୍କ୍‍ ତାଲ୍‍ ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ଜିସୁ ଆସୁଟ୍ ଡ଼ଲତଣ୍ଡ୍ ଇଞ୍ଜ୍‍ କେଞ୍ଜି ପିଲାତ ଦାଦ୍‌ରେଲ୍‌ତଣ୍ଡ୍ । ଆଗେ ମାନ୍ଦ୍ ସେନାପତିଙ୍କି କାଙ୍ଗି ଜିସୁ ଡ଼ଲି ପିନାଜେଲ୍‍ ଆଦୁତ୍‍ କି ଇଞ୍ଜ୍‍ ପାର୍ରିଞ୍ଚ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ଆଦ୍‍ ଅନାଗାଙ୍କ୍‍ ଇଦି ବିଷୟ ସାରେ କେଞ୍ଜି ପିଲାତ ଜିସୁନ୍‍ ଡ଼ଲତେ ମଡ଼୍ ଆଦାନଙ୍କ୍‍ ଯୋସେଫତିଙ୍କି ଇତ୍‍ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ଯୋସେଫ ଜିସୁନ୍‍ ମେନ୍ଦୁଲୁତିଙ୍କି କ୍ରୁଶ କନ୍‍ ଡ଼ିପି ତାସ୍‍ ଅଣ୍ଡ୍‌ ସିଲେ ତାସ୍ ଜିସୁନ୍‍ ମେନ୍ଦୁଲୁତିଙ୍କି ଅଣ୍ଡ୍‌ ମୁସ୍‍ପିତଣ୍ଡ୍ ନୁ ମେଟେତାଗ୍‍ ଡ଼େୱି ଆସମାନ୍ଦାନ୍ ଅଣ୍ଡ୍‌ ଦର୍ରତାଗ୍‍ ଅସ୍‍ ଆଦ୍‍ ୱାଟ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ବାଡ଼ିୟାଦ୍‍ କାଲ୍ ଦର୍ରତିଙ୍କି ମୁସିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ମଗ୍‍ଦଲୀନି ମରୀୟମ୍ ନୁ ଯୋଶିତେ ୟାୟ୍‍ ମରୀୟମ୍ ଆଗେ ମାଞ୍ଜ୍ ଜିସୁନ୍‍ ମେନ୍ଦୁଲୁ ବେଗେ ୱାଟିତଡ଼୍, ଉଡ଼୍ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ରମାନ୍‍ ଦିନାମ୍‍ ତେର୍ରତେ ପେର୍ରକେ ମଗ୍‍ଦଲୀନି ମରୀୟମ୍; ଯାକୁବତେ ୟାୟ୍‍ ମରିୟମ୍‍ ନୁ ଶଲୋମି ଜିସୁନ୍‍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କି ଉସାନଙ୍କ୍ ବେସ୍‌କ୍ ଲେକେତ୍‍ ଗାବ୍‍ ମାନ୍ଦାନ୍‍ ନିୟ୍‍ ଜିନିଷ୍‌ ଆସି ତାତ୍‍ଆ । ");
INSERT INTO kff_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ରବାର୍‌ନାଣ୍ଡ୍ ୱିୟ୍‍ଦାନ୍‍ ୱେଲେ ପଡ଼୍‍ଦ୍ ପେସ୍‍ମାତେ ୱେଲେ ଆୱୁ ସମାଦିତାଗ୍ ଆତ୍‍ତା ");
INSERT INTO kff_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ଆର୍ରଦାଗ୍‍ ଆୱୁ ତାମ୍‍ତାମ୍‍ ଲୋପେ କେତା, “ସମାଦିତାଗେ ଆ କାଲ୍‍ଦିଙ୍କି ମାନ୍‍ ମାଇଦିଙ୍କ୍ ବେନ ତୁର୍ସିଦ୍‍ତଣ୍ଡ୍ ?” ଆଦ୍‍ କାରଣ ବାଡ଼ାତାଦ୍‍ କାଲ୍ ମାତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","କିନ୍ତୁ ଆୱୁ ମାଡ଼ିକି ଉଡ଼୍‍ତା, କାଲ୍‍ଦିଙ୍କି ତୁର୍ସିଇସ୍ ମିନ୍ଦେଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ସମାଦିତେ ଦର୍ରରେ ଲୋପେ ଆଞ୍ଜ୍‍ ଉଡ଼୍‍ତା ଯେ ଆଗ୍‍ଗେ ଲାଟି ପାଣ୍ଡ୍ରି ଚକା କେର୍‍ତେନଣ୍ଡ୍ ଅର୍ତୁଣ୍ଡ୍‍ ଲେୟଣ୍ଡ୍ ସମାଦି ତିନ୍‍ କାଇଦେ ପାକେ କୁଦ୍‍ତଣ୍ଡ୍ । ଇୱୁସାରେ ଉଡ଼ି ଆୱୁ ୱେର୍ରତା । ");
INSERT INTO kff_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ଲେୟଣ୍ଡ୍ କେତଣ୍ଡ୍, ୱେର୍ରମାଟ୍ । ନାନେ ପୁତାନ୍‍, ମିଡ଼୍ କ୍ରୁଶତାଗ୍‌ ଡଲିମାନ୍ଦାନ୍‌ ନାଜରିତିୟ ଜିସୁଙ୍କୁ ମେକୁତିଡ଼୍ । ଅଣ୍ଡ୍‌ ଇଗେ ଇଲାଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ଜିୱେ ଆସ୍‍ମିନ୍ଦେଣ୍ଡ୍ । ଉଡ଼ାଟ୍‍, ଅଡ଼୍‌ ଇପଡ଼ିୟେ ତାଗେ ଅଂକିଙ୍କ୍‌ ୱାଟିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ଇଞ୍ଜେ ଆଞ୍ଜ୍ ପିତର ନୁ ଜିସୁନ୍‍ ବାଗାତ୍‍ ଶିଷ୍ୟଡ଼୍‍କିଙ୍କି ଇ କବର୍‍ ଇମୁଟୁ । ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ କେଲ୍‍ମୁଟ୍, ଜିସୁ ମିଇ ମୁନେ ଗାଲିଲୀତାଗ୍‍ ଆଦୁତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ କେତାନ୍‍ ଲେକାମ୍‌ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ଆଗ୍‍ ଉଡ଼୍ ପାର୍ରତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ନାଟାକି ସମାଦିକନ୍‍ ପେଇସ୍ ୱେର୍ରସ୍‍ ମିରି ମିରି ଆତ୍‍ତା । ଆୱୁ ପିନା ଦାଦ୍‍ରେଲ୍‍ତା ଆନ୍ତେ ଆଶର୍ଯ୍ୟ ଆତ୍‍ତା, ଆସୁଟ୍ ବେନଙ୍କ୍ ବା ତିରିୟାଙ୍କ୍ ପାର୍‍ୱମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ଜିସୁ ରବାର୍‍ନାଣ୍ଡ୍ ପୁନରୁତ୍‍ତି ଆସ୍‍ ମଗ୍‍ଦଲୀନି ମରୀୟମତିଙ୍କ୍‍ ମୁନେନ୍‍ ଦର୍ଶନ ଇସ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ଇ ମରୀୟମ୍ ତଡ଼୍ ଅଣ୍ଡ୍‌ ସାତ୍‍ଟାନ୍‍ ବୁତ୍‌କ୍ ୱିସ୍ପିମାତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ମରୀୟମ୍ ଆଞ୍ଜ୍ ଜିସୁନ୍‍ ସାଙ୍ଗନଡ଼୍‍କ୍‍ ଇଦି ବିଷୟ କେଞ୍ଜ୍‌ପ୍‍ତେ । ଅଡ଼୍‌ ଦୁକାତେ କେୟମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ଜିସୁ ଜିୱି ଆତଣ୍ଡ୍ ନୁ ଆଦ୍‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼୍‍ତାନ୍‍, ଇଞ୍ଜ୍‍ ଇ ଗଟି ମରୀୟମ୍ କେତାଙ୍କ୍ ଅଡ଼୍‌ ତାନ୍‍ ଗଟିଙ୍କି ବିଶ୍ୱାସ୍‌ ମାଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ତାନ୍‍ ପର୍ରକେ ଜିସୁନ୍‍ ଇଉଡ଼୍ ଶିଷ୍ୟଡ଼୍ ଅଣ୍ଡ୍‌ ନାର୍ର ଦାଗ୍‍ ଆଦାନ୍‍ ୱେଲେ ଆର୍ର ଦାଗ୍‍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ମେଣ୍ଡେ ଅଣ୍ଡ୍‌‍ ରକମ୍‍ ତନ୍ଦତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ଅଡ଼୍‌ ମାଲସ୍‍ ୱାସ୍ ବାଗାତଡ଼୍‍କିଙ୍କି ଇ ଗଟି କେତ୍‍ତଡ଼୍, କିନ୍ତୁ ଅଡ଼୍ ଗଟିଙ୍କି ବେନ୍‍ ବିଶ୍ୱାସ୍‌ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ତାନ୍‍ପେର୍ରକେ ତାନ୍‍ ଏଗାର୍ ଜାନ୍ ଶିଷ୍ୟଡ଼୍ ତିନ୍ଦାନଙ୍କ୍‍ କୁଦି ମାତ୍‍ତଡ଼୍ ଆସୁଟ୍‍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ଦର୍ଶନ ଇତଣ୍ଡ୍ । ଅଡ଼୍‌‍ୱାଦ୍‍ ଅବିଶ୍ୱାସୀ ମାଇଦିଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଜିୱୁତେ ଉଡ଼ି ମାନ୍ଦାନ୍‍ ନାରୁଡ଼୍ ଗଟି ବେଲା ବୁସା ଆଇମାକି ଇଞ୍ଜ୍‍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ କାଇଲ୍‌ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ସମଗ୍ର ଜଗତ୍‍ତାଗ୍‍ ଆଞ୍ଜ୍‍ ନାୟାଦ୍‍ ଇଦ୍‍ ସାଏତ୍‍ କାବୁର୍‍ ସାରେତଡ଼୍ ଗାରେ ଆଞ୍ଜ୍‍ କେଲ୍‍ମୁଟୁ । ");
INSERT INTO kff_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ବେନ୍‍ ଇଦିଙ୍କି ବିଶ୍ୱାସ ମାଡ଼ି ବାପ୍ତିସ୍ମ ଅଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ପରିତ୍ରାଣ ପାୟେମ୍‍ ଆଦ୍‍ତଡ଼୍ । ବେନ୍‍ ବିଶ୍ୱାସ ମାଡ଼ଣ୍ଡ୍, ଅଡ଼୍‌ ଦୋଷି ଆଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ବିଶ୍ୱାସିଡ଼୍ ବାକ୍‌ୱା ପାଡ଼୍‍ୟି ମାଡ଼ାନଙ୍କ୍‍ ଶକ୍ତି ପାୟେମ୍‍ ଆଦ୍‍ତଡ଼୍ । ନା ପେଦେର୍‍ତେ ଅଡ଼୍‌ ବୁତ୍‌ ୱିସ୍ପିତଡ଼୍, ପୁଃନେ ଗଟ୍‍ତେ ଗଟିତିର୍ରିତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ଅଡ଼୍‌ ତାଡ଼୍‍ତିଙ୍କି କାଇଦେ ପୟ୍‍କେ କିମ୍ୱା ୱିସାତିଙ୍କି ଉତ୍‍କେ, ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ବାତେ ଆୟ୍‍ । ଅଡ଼୍‌ ରୋଗ୍‍ତେ ମାନ୍ଦା ନାରୁଡ଼୍‍ତେ ପର୍‍ କାଇ ୱାଟ୍‍କେ, ଅଡ଼୍‌ ସୁସ୍ଥ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ଇ ସାରେ ଗଟି କେସ୍ ତେରି ପ୍ରବୁ ଜିସୁ ସ୍ୱର୍ଗ ଇଶ୍ୱରତେ ତିନ୍ଦେ କାଇଦେ ପାକେ କୁଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ଶିଷ୍ୟଡ଼୍ ଆଞ୍ଜ୍‍ ସାର୍ର ଏକାମ୍‍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍‍ । ଅଡ଼୍‌ କେତାନାଦ୍‍ ସତ୍‍ ପ୍ରମାଣ ମାଡ଼ାନଙ୍କ୍‍ ପ୍ରବୁ ଅଡ଼୍‌ ତଡ଼୍ ମାଞ୍ଜ୍‍ ବାକ୍‌ୱା ପାଡ଼୍‍ୟି ମାଡ଼ାନଙ୍କ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‌ ଶକ୍ତି ଇତ୍‌ତନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ଅ ତିୟପିଲ୍, ମାୟାଗ୍‌ ବାତ୍ ବାତ୍ ଆଦ୍‍ତେ, ଆଦିନାଦ୍ ଚିଟି ଲେକାନ୍ ସେଙ୍ଗେ ନାର୍ଗେ ନାରୁଡ଼୍ ପାର୍‍ତେ ଆସର୍ କିସୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ମୁନ୍‍ନେ କଞ୍ଚ୍‍ ଇଦ୍ ସାରେତିଙ୍କ୍ ଉଡ଼ିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ବେଲା ନେଲା କାବୁର୍‍ କେସ୍‍ମାତ୍‍ତଡ଼୍, ଆଦ୍ ଇସାବ୍‍ତେ ଇଦ୍ ଚିଟି ଲେକାଆସ୍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ହୋ ବେଡ଼୍‍ୟନ୍ ତିୟପିଲ୍, ନାନ୍ ଆର୍‍କୁଲ୍‍ତେ ମୁନ୍‍ନେ କନ୍‍ସ୍ ଇଦ୍‍ସାରେ ଗଟ୍ ଏର୍କେ ମାଡ଼୍‍ତାନ୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ମି ସେଙ୍ଗେ ଇଦିନାଦ୍ ୱେରନ୍ ପୁନ୍ଦାନାଦ୍ ବିବରନୀ ଲେକାଙ୍କ୍ ଲେକେତ୍ ହେର୍କେ ମାଡ଼୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଇଦ୍ ବିଷୟତେ ମିଡ଼୍ ବେନ୍ ସାରେ ବିଷୟ୍ ପୁତ୍‍ତିଡ଼୍, ଆଦିନାଦ୍ ସାରେ ସତ୍ ବେଲା ପୁଞ୍ଜ୍ ପାର୍‍ଦ୍‍ତିଡ଼୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ଇଦ୍ ଲେକୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଯିହୁଦା ଦେଶ୍‍ତେ ରାଜାଲ୍ ହେରୋଦତେ ସମୟ୍‍ତେ ଅବିୟତେ ମାନ୍ଦେତେ ନାନେ ଜିକରୀୟ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେର୍‍ଣ୍ଡ୍ ଯାଜକ୍ ମାତ୍‍ତଣ୍ଡ୍; ଅନ୍‌ ମୁତ୍‍ତେ ହାରୋଣ ବଂଶତେ ପିକିଡ଼୍, ଆଦିନ୍ ପେଦେର୍ ଏଲୀଶାବେତ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ଅଡ଼୍‌‍ ଇର୍‍ୱୁଡ୍ ଆସ୍‍ସ ପ୍ରବୁନାଦ୍ ଗଟ୍ ନୁ ପାଲନ୍ ଲେକାମ୍ ନିର୍ଦୋଷ୍‍ ଲେକାମ୍ କାମ୍ ମାଡ଼ି ପରମେଶ୍ୱର୍ ମୁନ୍‍ ଦାର୍ମିକ୍ ମାତ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମାର୍‍ ମାୟାଡ଼୍ ଇଲ୍‍ୱେ ମାତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍କେ ଏଲୀଶାବେତ୍‌ ୱାଞ୍ଜଲ୍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ଇର୍‍ୱିଡ଼ାଦ୍ ବିଷୟ୍‍ ନାର୍ଗେଆସ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ଜିକରୀୟ ତାମ୍ ମାନ୍ଦେତେ ପାଲି ହିସାପ୍ ତେ ପରମେଶ୍ୱର୍‍ତେ ମୁନ୍‍ନେ ଯାଜକ୍ ପାଡ଼ିୟି ମାଡ଼ମାନ୍ଦାନ୍ ଦିନାମ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ଯାଜକ୍ ପାଡ଼ିୟିଦେ ଲେକେତ୍ ଲେକାମ୍‍ତେ ଗୁଲିବାଣ୍ଟ ମାଡ଼୍‍ତାଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ପ୍ରବୁନ୍ ମନ୍ଦିର୍‍ତେ ଲୋପେ ହସି ଦୂପାମ୍ ଇଦାଙ୍କ୍ ୱେୟ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ମେଣ୍ଡେ ଦୂପାମ୍ ଇଦାନ୍ ୱେଲେ ସାର୍‍ରେ ତୋଡ୍ ନାରୁଡ଼୍ ବାଇଦେ ପ୍ରାର୍ତନା ମାଡ଼ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ଆସୁଣ୍ଟ୍ ପ୍ରବୁନାଦ୍ ୱେର୍‍ଣ୍ଡ୍ ଦୂତ ଦୂପାମ୍ ଇଦାନ୍ ବାକ୍‍ଡ଼େତେ ତିନ୍ଦେ କାଇଦେ ପାକ୍ ନିଶ୍‍ମିକା ଅଂକିଙ୍କ୍‌ ତନ୍ଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିକରୀୟ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଦାଦ୍‍ରେଲି ମିକା ୱେର୍‍ତଣ୍ଡ । ");
INSERT INTO kff_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ବାତେଙ୍କ୍ ଇତ୍କେ ଦୂତ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, ଜିକରୀୟ, “ୱେର୍‍ମା ବାତେଙ୍କ୍ ଇତ୍କେ ନିୟାଦ୍ ପ୍ରାର୍ତନା ସଦାପ୍ରବୁ କେଞ୍ଜ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ନି ମୁତ୍‍ତେ ଏଲୀଶାବେତ୍‌ ନି ମାଇଦିଙ୍କ୍ ୱେର୍‍ଣ୍ଡ୍ ମାର୍‍ ଜନମ୍ ମାଡ଼ିତା, ମେଣ୍ଡେ ନିମେ ଅନ୍‌ ପେଦେର୍ ଯୋହନ୍‌ ଇଦ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ଅଣ୍ଡ୍‌ ନିୱାଦ୍ କୁସି ନୁ ସାର୍‍ଦେତେ ବିଷୟ ଆଦ୍ ତଣ୍ଡ୍, ମେଣ୍ଡେ ନାର୍ଗେ ନାରୁଡ଼୍ ଅନ୍‌ ଜନମ୍‍ତେ ୱେଡ଼୍‍କିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ଅଣ୍ଡ୍‌ ପ୍ରବୁନ୍ ମୁନ୍‍ନେ ମହାନ୍ ଆଦ୍‍ତୋଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଦ୍ରାକ୍ଷାରସ୍ କି ସୁରା ବେସୁଟ୍‌ ବା ହୁନଣ୍ଡ୍ ମେଣ୍ଡେ ୟାୟନ୍ ଡଙ୍କେତାଗ୍ ମିକା ପବିତ୍ର ଆତ୍ମାତେ ସାରେ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଆସୁଣ୍ଟ୍ ଅଣ୍ଡ୍‌ ଇସ୍ରାଏଲ ନାରୁଡ଼୍ ଲୋପ୍ ନାର୍ଗେ ନାରୁଡ଼୍‍କିଙ୍କ୍ ପ୍ରବୁ ଅଡ଼୍‌‍ୱାଦ୍ ଇଶ୍ୱର୍‌ତେ ସେଙ୍ଗେ ମାଲ୍‍ପି ମାଡ଼ି ତାତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ୟାୟବାବାନ୍ ହୃଦୟ୍ ପିଲାନ୍ ସେଙ୍ଗେ ନୁ ପୁନ୍‍ୱେ ନାରୁଡ଼୍ ଦାର୍ମିକ୍ ନାରୁଡ଼୍‍ତେ ବୁଦ୍‍ତେ କାମ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ମାଲ୍‍ପାନଙ୍କ୍ ମେଣ୍ଡେ ପ୍ରବୁନ୍ ସେଙ୍ଗେ ସାଏତ୍‍ ଦଣ୍ଡଆତ୍‍ତେ ୱେରନ୍ ନାରୁଡ଼୍‌ମଣ୍ଡଲି ତିଆର୍ ମାଡ଼ାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଏଲିୟତେ ଆତ୍ମା ନୁ ଶକ୍ତିତେ ଅନ୍‌ ମୁନ୍‍ନେ ତାକି ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ଇଗେ ଜିକରୀୟ ଦୂତ ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ବେନ୍ ଚିହ୍ନେତେ ଇଦ୍ ପୁନ୍‍ତାନ୍ ? ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ତ ମୁଇତାନ୍, ମେଣ୍ଡେ ନା ମୁତେନ୍ ବୟଷ୍ ଗାଟି ଆଦୁତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ଦୂତ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ନାନ୍ ଗାବ୍ରିଏଲ୍‌, ନାନ୍ ପରମେଶ୍ୱର୍ ତେ ମୁନ୍‍ନେ ନିଶ୍‍ମାନ୍ଦାନ୍, ମେଣ୍ଡେ ନିକିଂଙ୍କ୍ କେତାଙ୍କ୍ ନୁ ଇଦ୍ ସୁସମାଚାର୍ କେଞ୍ଜ୍‍ପାଙ୍କ୍ ନାନ୍ ୱାସମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ଉଡ଼ାଟ୍, ଇଦ୍ ସାରେ ଗଟେମ୍ ହାଇୱା ଦିନ୍ ଯାକ ନିମେ କନ୍ଦାହାସ୍‍ ଗଟ୍‍ତ୍ରିୟ୍ ପାର୍‍ୱିନ୍, ନାୱାଦ୍ ବେନ୍ ସାରେ ବାକ୍ୟ କେତ୍‍ତାନ୍ ଆଦ୍ ଟିକ୍ ଦିନାମ୍‍ତେ ସାରେ ଆଦ୍‍ତେ, ଆଦ୍ ସାରେତିଙ୍କ୍ ନିମେ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଆଦ୍ ଦିନାମ୍‍ତେ ନାରୁଡ଼୍ ଜିକରୀୟଙ୍କ୍ କେପି ମାତ୍‍ତଡ଼୍, ମନ୍ଦିର୍ ତାଗ୍ ଅନ୍‌‍ୱାଦ୍ ଡେରି ଆତ୍‍ତାଙ୍କ୍ ଅଡ଼୍‌‍ ଦାଦ୍‍ରେଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ବାଇଦେୱାସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗଟ୍ କେତାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍; ଇଗେ ଅଣ୍ଡ୍‌ ମନ୍ଦିର୍‍ତାଗ୍ ତନ୍ଦ୍‍ତଣ୍ଡ୍‍ ଇଞ୍ଜ ଆତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଅଡ଼୍‌‍ ପୁତ୍‍ତଡ଼୍ । ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଚିନ୍ନେ ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ ନୁ କନ୍ଦାଲ୍ ହାସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ପେର୍‍କେ ଅନ୍‌‍ୱାଦ୍ ସେବାମାଡ଼ାନ୍ ଦିନାକ୍ ତେର୍‍ତାଙ୍କ୍, ଅଣ୍ଡ୍‌ ତାମ୍ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ତାନ୍ ମୁତ୍‍ତେ ଏଲୀଶାବେତ୍‌ ଡଙ୍କେତ୍ ଆତ୍‍ତେ, ମେଣ୍ଡେ ଏଇଙ୍ଗ୍ ନେଲ୍‍ଞ୍ଜ୍ ହେଉନା ଇଦ୍ ବିଷୟ ବେନଙ୍କେ କେଲକଟ ମିଞ୍ଜିମାଞ୍ଜ୍ ମାତ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ମେଣ୍ଡେ ଏଲୀଶାବେତ୍ କେତ୍‍ତା, “ନାରୁଡ଼୍‍ତେ ଲୋପେ ନା ଅପ୍‍ମାନ୍ ଦୁରାମ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ପ୍ରବୁ ଦାୟାମାଡ଼ି ନା ମାଇଦିଙ୍କ୍ ଇଲା ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଏଲୀଶାବେତ୍ ଡଙ୍କେତ୍ ଆଦ୍‍ତେ ଆରୁ ନେଲ୍ଞ୍ଜ୍‍ତେ ପେର୍‍କେ ଇଶ୍ୱରତାଦ୍ ଗାବ୍ରିଏଲ୍‌ ଦୂତ ଗାଲିଲୀତେ ନାଜରିତିୟ ପେଦେର୍‍ତେ ନଗର୍‍ତାଗ୍ ଅରଟ୍ ପିକିଡ଼୍ ଗାର୍‍ରେ ପ୍ରେରିତ୍ ଆତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଦାଉଦ୍‍ ବଂଶତେ ଯୋଷେପ୍ ପେଦେର୍ ତଣ୍ଡ୍ ୱେର୍‍ଣ୍ଡ୍ ନାରୁଡ଼୍ ତଡ଼୍ ଆଦିନାଦ୍ ବେନ୍‍ଆସ୍ ମାତ୍‍ତେ; ଆଦ୍ ପିକିଡ଼୍ ତେ ପେଦେର୍ ମରୀୟମ୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ଗାବ୍ରିଏଲ୍ ଦୂତ୍ ଆଦିନ୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍ତଣ୍ଡ୍, “ଆଗୋ ଅନୁଗ୍ରହପାତ୍ରୀ, ନିୟାଦ୍ ଲେକେତ୍ ହାୟି, ପ୍ରବୁ ନି ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ଇଦ୍ ବାକ୍ୟତେ ଗାଟି ଦାନ୍ଦେ ଆତ୍‍ତେ ନୁ ଇଦ୍ ବେସତ୍ କବର୍ ହିଞ୍ଜ ମାନ୍‍ ଦେ ହାଲ୍‍ସାନଙ୍କ୍ ପସ୍‍ପିତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ଆସୁଣ୍ଟ୍ ଦୂତ ତାକିଂଙ୍କ୍ କେତ୍‍ତେ, “ଆଗୋ ମରୀୟମ୍‍, ‘ୱେର୍‍ମା,’ ବାତେଙ୍କ୍ ଇତ୍କେ ନିମେ ଇଶ୍ୱର୍‌ତାଦ୍ ଆର୍ଶିବାଦ୍ ହାସମିନ୍ଦେନି । ");
INSERT INTO kff_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ମେଣ୍ଡେ ଉଡ଼େ, ନିମେ ଡଙ୍କେତ୍ ଆସ୍‍ସ ୱେର୍‍ଣ୍ଡ୍ ମାର୍‍ ଜନମ୍ ମାଡ଼ିତି ନୁ ଅନ୍‌ ପେଦେର୍ ଜିସୁ ଇଦ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ଅଣ୍ଡ୍‌ ମହାନ୍ ଆଦ୍‍ତନ୍ ନୁ ସତ୍‍ଇଶ୍ୱର୍‍ତେ ମାର୍‍ ହିଞ୍ଜ ପୁନ୍‍ତଡ଼୍; ପ୍ରବୁ ଇଶ୍ୱର୍‌ ଅଂକିଙ୍କ୍‌ ତାମ୍ ଆନୀଦାଦିଡ଼୍ ଦାଉଦ୍‍ ତେ ରକମ୍ ରାଜାଲ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ଅଣ୍ଡ୍‌ ଯାକୁବ୍ ବଂଶତାଗ୍ ଯୁଗ୍‍ଯୁଗ୍ ତିଙ୍କ୍ ଶାସନ୍‍ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ଅନ୍‌ ରାଜ୍ୟ ଶେଷ୍ ଆୟ୍‍ୟ !” ");
INSERT INTO kff_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ବାତେଙ୍କ୍ ଇତ୍କେ ମରୀୟମ୍‍ ଦୂତ ତିଙ୍କ୍ କେତ୍‍ତେ, “ଇଦ୍ ବେଲା ଆଦ୍ ତେ ? ନାନ୍ ତ ବେନ୍ ମାନେଇ ତଡ଼୍ ଉଞ୍ଜନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ଦୂତ ଆଦିଙ୍କ୍ କେତ୍‍ତେ, “ପବିତ୍ର ଆତ୍ମା ନି ପରୁ ଡିଗିତେ ନୁ ସତ୍‍ଇଶ୍ୱର୍‍ତେ ଶକ୍ତିତେ ନିକିଂଙ୍କ୍ ମିସିତେ, ନୁ ବେନ ଜନମ୍ ଆଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ପବିତ୍ର ନୁ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ହିଞ୍ଜ ନାରୁଡ଼୍ ପୁନ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ମେଣ୍ଡେ ଉଡେ, ମି ଆତ୍ମୀୟ ଏଲୀଶାବେତ୍‌ ମିକା ଡକ୍ରି ବୟଷ୍ ତେ ୱେର୍‍ଣ୍ଡ୍ ମାର୍‍ ଡଙ୍କେତ୍ ଆସ୍‍ସ ମିନ୍ଦେ । ବାଦିଙ୍କ୍ ୱାଞ୍ଜଲ୍ ହିଞ୍ଜ କେସ ମାତ୍‍ତଡ଼୍, ତାମ୍‍ୱାଦ୍ ଇଞ୍ଜେ ଆରୁ ନେଲଞ୍ଜ୍ ଆଦୁତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ବାତେଙ୍କ୍ ଇତ୍କେ ଇଶ୍ୱର୍‌ତେ ପାୟୁର୍ କଞ୍ଜ୍ ପେଇତାନ୍ ବେନ୍ ବାକ୍ୟ ମିକା ଶକ୍ତିହୀନ ଆୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ଇଗେତିଞ୍ଚ ମରୀୟମ୍‍ କେତ୍‍ତେ, “ଉଡେ ନାନ୍ ପ୍ରବୁନ୍ ଦାସୀ; ନିୱାଦ୍ ବାକ୍ୟ ଲେକାମ୍ ନାୟାଗେ ହାୟି ।” ତାନ୍ ପେର୍କେ ଦୂତ ଆଦିନାଗାଙ୍କ୍ ମାଲ୍‍ସ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ଇଦ୍ ସମୟ୍ ତେ ମରୀୟମ୍‍ ତେଦି ଯିହୁଦା ଦେଶ୍‍ତେ ମେଟେତାଗ୍ ମାନ୍ଦାନ୍ ୱେରନ୍ ନଗର୍‍ତାଗ୍ ଆତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ମେଣ୍ଡେ ଆଦ୍ ଜିକରୀୟତେ ଲୋନ୍‌ ହସି ଏଲୀଶାବେତ୍‌ ତିଙ୍କ୍ ନମସ୍କାର୍ ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ମେଣ୍ଡେ ଆଦ୍ ମରୀୟମ୍‍ ତେ ନମସ୍କାର୍ କେଞ୍ଜ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ବାବୁ ଏଲୀଶାବେତ୍‌ ଡଙ୍କେତ୍ ଲୋପେମାଞ୍ଜ୍ ହେନ୍ଦଣ୍ଡ୍, ମେଣ୍ଡେ ଏଲୀଶାବେତ୍‌ ପବିତ୍ର ଆତ୍ମାତେ ପୁରା ହାସ୍ ");
INSERT INTO kff_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତେ, “ନାଟାନ୍ ଲୋପ୍ ନିମେ ଦନ୍ୟ, ମେଣ୍ଡେ ଦନ୍ୟ ନି ଡଙ୍କେତ୍ କାୟେ ତିଙ୍କ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ମେଣ୍ଡେ, ନା ପ୍ରବୁନ୍ ୟାୟ ଯେ ନା ଗାର୍‍ରେ ୱାଦ୍‍ତେ, ନାୱାଦ୍ ଇଦ୍ ସାଏତ୍ ବିଷୟ ବେଗେତିନ୍‍ସ୍ ଆତ୍‍ତେ ? ");
INSERT INTO kff_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ଇଦିନ୍ ସେଙ୍ଗେ ଉଡ଼େ, ନି ନମସ୍କାର୍ କେଞ୍ଜ୍ ତେ ପେର୍‍କେ ନା ଡଙ୍କେତ୍ ଲୋପେ ବାବୁ ସାର୍‍ଦେ ଆସ୍ ହେନ୍ଦ୍ ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ପ୍ରବୁ ବାତେଏ କେତ୍‍ତଣ୍ଡ୍ ହାଉସାରେ ଅଣ୍ଡ୍‌ ସାରେ ମାଡ଼ିତନ୍ ଇଞ୍ଜ ନିମେ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତାଙ୍କ୍ ନିମେ ଆର୍ଶିବାଦ୍ ହାତ୍‍ତି ।” ");
INSERT INTO kff_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ତାନ୍ ପେର୍‍କେ ମରୀୟମ୍‍ କେତ୍‍ତେ, “ନା ଜିୱେ ପ୍ରବୁନ୍ ପ୍ରସଂଶା ମାଡୁତେ, ");
INSERT INTO kff_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ମେଣ୍ଡେ ନାୱାଦ୍ ଆତ୍ମା ନା ତ୍ରାଣକର୍ତ୍ତାଲ୍ ଇଶ୍ୱର୍‌ତାଗ୍ ସାର୍‍ଦେ ମାଡ଼ମିନ୍ଦେ; ");
INSERT INTO kff_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ଆଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ୱେରନ୍ ସୁଦୁର୍ ଦାସୀ ହାତ୍କେମିକା ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ହେର୍କା ମାଡ଼୍‍ତଣ୍ଡ୍, ଇଞ୍ଜେ ସାରେତଡ଼୍ ନାକିଂଙ୍କ୍ ୱେଡ଼୍‍କେ ନାରୁଡ଼୍ ଇଞ୍ଜ କେତିତଡ଼୍ । ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଯୁଗ୍‍ଯୁଗ୍ ମାନେଇ ସାର୍‍ରେତଡ୍ ନାକିଂଙ୍କ୍ ଦନ୍ୟ ହିଞ୍ଜ କେତିତଡ଼୍‍, ");
INSERT INTO kff_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ବାତେଙ୍କ୍ ଇତ୍କେ ସାରେତିଙ୍କ୍‍ ଶକ୍ତିନଣ୍ଡ୍‌ ଇଶ୍ୱର, ଅଣ୍ଡ୍‌ ନା ସେଙ୍ଗେ ମହାନ୍‍ କାମ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍; ଅନ୍‌‍ୱାଦ୍ ପେଦେର୍ ପବିତ୍ର, ");
INSERT INTO kff_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ୱେର୍‍ତାନ୍ ନାରୁଡ଼୍‍ତେ ସେଙ୍ଗେ ଅନ୍‌‍ୱାଦ୍ ଦୟା ଯୁଗ୍‍ଯୁଗ୍ ମାନ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ଅଣ୍ଡ୍‌ ତାନ୍‍ୱାଦ୍ କାଇତାଦ୍ ଶକ୍ତିତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଆଂକାର ମାଡ଼ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କ୍ ତାମ୍ ହୃଦୟ୍‍ତେ ଆଲ୍‍ସାନାଦ୍‍ ୱେରେୱେରେ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ଅଣ୍ଡ୍‌ ଶକ୍ତିତଡ଼୍ ରାଜାଲଡ଼୍‍କ୍ ତାମ୍ ସିଂହାସନ୍ ତେ କଞ୍ଚ୍‌ ମଦଲ୍ ତାତ୍‍ତଣ୍ଡ୍ ନୁ ଗରିବ୍ ନାରୁଡ଼୍‍କ୍ ପରୁ ତେହେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ଅଣ୍ଡ୍‌ କାର୍ୱିନ୍ ନାରୁଡ଼୍‍କ୍ ସାଏତ୍ ଜିନିଷ୍ ତେ ନିଇତ୍‌ତଣ୍ଡ୍‌, ସାଉକାର୍ ନାରୁଡ଼୍‍କ୍ ଆସାମ୍ କାଇଦେ ରହସ୍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ମା ପିତୃପୁରୁଷତେ ସେଙ୍ଗେ କେତ୍‍ତାଦ୍ ଅନ୍‌‍ୱାଦ୍ ବାକ୍ୟଲେକାମ୍ ତେ ଅଣ୍ଡ୍‌ ଆବ୍ରାହାମ୍ ନୁ ତାନ୍ ମାର୍‍କିଡ୍ ସେଙ୍ଗେ, ");
INSERT INTO kff_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ଯୁଗ୍‍ଯୁଗ୍ ଦୟା ହେର୍କା ମାଡ଼ାନ୍ ସେଙ୍ଗ୍ ଅବ୍ରାହାମ୍‌ ନୁ ତାନ୍‍ ଦାସ୍ ଇସ୍ରାଏଲ ତେ ଉପକାର୍ ମାଡ଼ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ମେଣ୍ଡେ, ମରୀୟମ୍‍ ତାନ୍ ତଡ଼୍ ମୁଣ୍ଡ୍ ନେଲଞ୍ଜ୍ ମାଞ୍ଜ୍ ତାମ୍ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ପେର୍‍କେ ଏଲୀଶାବେତ୍‌ ତେ ସାୟେ ମାଡ଼ାନ୍ ଅଦାନ୍‌ଦିନାମ୍‌ ଦିନାମ୍ ହେୱତାଙ୍କ୍, ଆଦ୍ ୱେର୍‍ଣ୍ଡ୍ ମାର୍‍ ଜନମ୍ ମାଡ଼୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ମେଣ୍ଡେ ପ୍ରବୁ ଯେ ତାନ୍ ମାଇଦିଙ୍କ୍ ଗାଟି ଦୟା ମାଡ଼୍‍ତଣ୍ଡ୍, ଇଦ୍ କେଞ୍ଜି ତାମ୍ ଗାରେତଡ଼୍ ନୁ ଲୋତେନଡ୍ ତାନ୍ ତୋଡ୍ କାଇଲି ସାର୍‍ଦେ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ଆଟ୍‌ ଦିନାତିଙ୍କ୍ ଅଡ଼୍‌‍ ବାବୁଙ୍କ୍ ହେକ୍ ମାଡ଼ାଙ୍କ୍ ୱାତତୋଡ୍ ନୁ ତାମ୍ ବାବାନ୍ ପେଦେର୍ ଲେକାମ୍ ଅନ୍‌ ପେଦେର୍ ଜିକରୀୟ ହିଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ବାତେଙ୍କ୍ ଇତ୍କେ ତାମ୍ ୟାୟ କେତ୍‍ତେ, “ଇଲ୍‍ଲେ, ଅନ୍‌ ପେଦେର୍ ଯୋହନ୍‌ ଆଦ୍ ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ଅଡ଼୍‌‍ ତାକିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍‍, “ମି ଆତ୍ମାତେ ନାରୁଡ଼୍ ଲୋପ୍ ତ ବେନନାଦ୍ ଇସତ୍ ପେଦେର୍ ଇଲ୍‍ଲେ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ଇଗେ ଅଂକିଙ୍କ୍‌ ବାତ୍ ପେଦେର୍ ହିଦାନାଦ୍ ହିଞ୍ଜ ତାମ୍ ବାବାଲ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍, ଆଦ୍ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଚିନ୍ନେ ମାଡ଼ି ପଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ଆଗେ ଆଦ୍ ୱେରନ୍ ଲେକ୍‍ତଦ୍ ଇଦ୍ ଲେକାମ୍ ଲେକ୍‍ତଣ୍ଡ୍, “ଅନ୍‌ ପେଦେର୍ ଯୋହନ୍‌ ।” ଇଗେ ସାର୍‍ରେ ତୋଡ୍ ଦାଦ୍‍ରେଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ମେଣ୍ଡେ, ସେନେକ୍ ତିଙ୍କ୍ ତାନ୍ ପାୟୁର୍ ନୁ ୱାଞ୍ଜେର୍ ଟେଣ୍ଡି ଆତ୍‍ତେ ନୁ ମେଣ୍ଡନ୍ଦାମ୍ ଅଣ୍ଡ୍‌ ଗଟ୍‍ତିର୍‍ୟି ପରମେଶ୍ୱର୍‍ ତେ ପ୍ରସଂଶା ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ଇଗେ ତାମ୍ ଗାର୍‍ରେତଡ଼୍ ସାରେ ୱେର୍‍ତଡ୍, ମେଣ୍ଡେ ଇଦ୍ ସାରେ ଗଟ୍ ଯିହୁଦା ଦେଶ୍ ତେ ମେଣ୍ଡନ୍ ଅଞ୍ଚଲତ୍ ସାରେ ପାକେତ୍ ନାରୁଡ଼୍ ତିରିୟା ତିରିୟି ଆତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ମେଣ୍ଡେ କେଞ୍ଜାନ୍ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଆଦ୍ ସାରେ ନିଜ୍‍ନିଜ୍ ହୃଦୟ୍‍ତାଗ୍ ନେଏସ୍ କେତ୍‍ତଡ଼୍‍, “ଇ ବାବୁ ଆଲାତ୍କେ ବାତ୍ ଆଦ୍‌ତଣ୍ଡ୍ ? ବାତେଙ୍କ୍ ଇତ୍କେ ପ୍ରବୁନ୍ କାୟ୍ ଅନ୍‌‍ତଡ଼୍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ମେଣ୍ଡେ, ତାମ୍ ବାବାଲ୍ ଜିକରୀୟ ପବିତ୍ର ଆତ୍ମାତେ ପୁରା ଆସ୍ ଇଦ୍ ବାବବାନି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ଇସ୍ରାଏଲ୍ ତେ ଇଶ୍ୱର୍‌ତାଦ୍ ପ୍ରସଂଶା ଆୟି, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଦାୟାମାଡ଼ି ତାମ୍ ନାରୁଡ଼୍‍କ୍ ତେ ସେଙ୍ଗ୍ ମୁକ୍ତି ତିଆର୍ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ଅଣ୍ଡ୍‌ ତାମ୍ ଦାସ୍ ଦାଉଦ୍‍ ତେ ବଂଶତ୍ ୱେର୍‍ଣ୍ଡ୍ ଶକ୍ତିନଡ଼୍ ପରିତ୍ରାଣ୍‍କର୍ତ୍ତାଙ୍କ୍ ମା ସେଙ୍ଗ୍ ରହ୍‍ତଣ୍ଡ୍ ");
INSERT INTO kff_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ପୁରାକାଲ୍‌ଦେ କଞ୍ଜ୍ ତାମ୍ ପବିତ୍ର ବାବବାଦୀ ନାରୁଡ଼୍ ତେ ପାୟୁର୍ ତଡ଼୍ ବେଦ୍ ପୁଟୁଙ୍କ୍ କେସ୍ ମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ଆଦ୍ ରକମ୍ ମାନ୍‍ ଶତ୍ରୁଡ଼ାଗାଙ୍କ୍ ନୁ ମାନ୍‍ ସାରେ ପାସ୍‍କାନ୍ ନାରୁଡ଼୍ ତେ କାଇଦେକଞ୍ଜ୍ ପରିତ୍ରାଣ ତିଆର୍ ମାଡ଼ି ମିନ୍ଦେଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ବେଲା କି ଅଣ୍ଡ୍‌ ମା ଆନିଦାଦିଡ଼୍ ସେଙ୍ଗେ ଦୟା ବ୍ୟବହାର୍ ମାଡ଼ିତନ୍, ନୁ ଅଡ଼୍‌‍ ସେଙ୍ଗେ ମାଡ଼ିମାନ୍ଦାନ୍ ନିଜର୍ ପବିତ୍ର ନିୟମ୍ ହେର୍କା ମାଡ଼ିତନ୍, ");
INSERT INTO kff_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ମାନ୍‍ ବାବାଲ୍ ଅବ୍ରାହାମ୍‌ତେ ଗାର୍‍ରେ ବେନେ ଶପତ୍‍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ତାମ୍ଆଦ୍ ଆଦ୍ ପବିତ୍ର ନିୟମ୍ ହେର୍କା ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ମାନାଡ଼୍ ମାନ୍‍ ଶତ୍ରୁଡ଼ାଗାଙ୍କ୍ ଉଦ୍ଦାର୍‍ ଆତ୍‍ତାଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ବେଲା କି ମାନାଡ଼୍ ମାୟାଦ୍‌ ସାରେଜିୱୁଣ୍ଡ୍ ଅନ୍‌ ମୁନ୍‍ନେ ପବିତ୍ର ନୁ ଦାର୍ମିକ୍ ଆଦ୍ ପାର୍‍ଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ହୋ ନା ମାର୍‍ ନିମେ ସାରେତିଙ୍କ୍ ପର ଇଶ୍ୱର୍‌ତେ ୱେର୍‍ଣ୍ଡ୍ ବାବବାଦୀ ଲେକାମ୍ ତିଆର୍ ଆଦ୍‍ତିଡ଼୍ । ନିମେ ପ୍ରବୁନ୍ ୱେର୍‍ଣ୍ଡ୍ ଅଗ୍ରଦୂତ ଲେକାମ୍ ଅନାଦ୍‌ ହାର୍ ତିଆର୍ ମାଡ଼ିତି । ");
INSERT INTO kff_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ପାପ୍ କ୍ଷମା ଆଦାନ୍ ତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଯେ ପରିତ୍ରାଣ ଦର୍‍କିତେ, ତାମ୍ ନାରୁଡ଼୍‍କ୍ ଇଦ୍ ଗଟ୍ କେତାଙ୍କ୍ ଆତ୍‌ତେ । ");
INSERT INTO kff_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ମାନ୍‍ ଇଶ୍ୱର୍‌ କୃପା ନୁ କୋମଲ ହୃଦୟ୍ ଅଣ୍ଡ୍‌ ମାନ୍‍ ସେଙ୍ଗେ ପରିତ୍ରାଣତେ ପଡ଼ଦ୍ ପେସ୍‍ପିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ବେନଡ଼୍ ଡଲାନ୍ ଲେକାମ୍ ଇକାଡ଼୍ ନିଡ଼୍‍କେତାଗ୍ ବାଦ୍‍କିତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶାନ୍ତି ହାର୍ ତେ ଆଦାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ସାରେତଡ଼୍ ପରୁ ସ୍ୱର୍ଗତେ ୱେସ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ମେଣ୍ଡେ, ବାବୁ ପେର୍‍ସି ଆତ୍ମାତେ ଶକ୍ତିତଣ୍ଡ୍‌ ଆଦାଙ୍କ୍ ପସ୍ପ୍‍ତଣ୍ଡ୍ ନୁ ଇସ୍ରାଏଲତେ ଗାର୍‍ରେ କେଲ୍‍ୱାଙ୍କ୍ ହାଇୱା ଯାକ୍ ଆଞ୍ଚିନା ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ଆଦ୍ ଦିନାମ୍‍ତେ ରୋମ୍‍ ରାଜ୍ୟ ସମ୍ରାଟ୍ ଅଗଷ୍ଟ କାଇସର୍‍ତେ ତଡ଼୍ ଦେଶ୍‍ତେ ସାରେ ନାରୁଡ଼୍ ପେଦେର୍ ଲେକାନ୍‍ ସେଙ୍ଗେ ଗଟ୍ କେତାନଙ୍କ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ସିରିଆତେ ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ କ୍ୱିରୀଣିୟତେ ୱେଲେ ମୁନେ ଦାମ୍ଇଦ୍ ପେଦେର୍ ଲେକାନାଲ୍‌ଦ୍ ଆସ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ଆଦିନ୍ ସେଙ୍ଗେ ସାରେତଡ଼୍ ପେଦେର୍ ଲେକାମାଡ଼ାନ୍ ସେଙ୍ଗେ ନିଜେ ନିଜେ ନଗର୍‍ତାଗ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ମେଣ୍ଡ, ଯୋଷେପ୍ ମିକା ପେଦେର୍ ଲେକାମାଡ଼ାନ୍ ସେଙ୍ଗେ ମରୀୟମ୍‍‍ତଡ୍ ଗାଲିଲୀତେ ନାଜରିତିୟ ନଗର୍‍ ତାଗାଙ୍କ୍ ଯିହୁଦା ନାର୍‍ଦେ ବେତ୍‌ଲିହିମ୍‌ ପେଦେର୍ ଡ଼ାଦ୍ ଦାଉଦ୍‍ ତେ ନଗର୍‍ତାଗ୍ ଆତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଦାଉଦ୍ ତେ ବଂଶ ନୁ ନାର୍‍ଦେ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ଅନ୍‌ ତଡ଼୍ ମରୀୟମ୍‍ ତେ ଯୱ ଆସ୍ ମାତ୍‍ତେ ନୁ ଆଦ୍ ଡଙ୍କେତ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ଅଡ଼୍‌‍ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ ତାନ୍‍ୱାଦ୍ ପିଲେ ଜନମ୍ ମାଡ଼ାନ୍ ଦିନାମ୍ ୱାସ୍ ହେୱେତେ, ");
INSERT INTO kff_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ମେଣ୍ଡେ ଆଦ୍ ତାନ୍ ମୁନେ ଜନମ୍‍ତେ ମାର୍‍ ଜନମ୍ ମାଡ଼୍‍ତେ ନୁ ଅଂକିଙ୍କ୍‌ ସିଲେତଡ୍ ଉତ୍‍ତି ଗୋଡ୍ କଟାମ୍ ତାଗ୍ ପଡ଼୍‍ପ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବାଡ଼ା ଲୋନ୍‌‍ତାଗ୍ ଅଡ଼୍‌‍ ସେଙ୍ଗେ ପଡ଼ିୟ୍ ଇଲ୍ୱେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ମେଣ୍ଢା ମେଇତାନଡ୍ ବାଇଦେ ମାଞ୍ଜ୍ ଇକାଡ଼୍ ତେ ତାମ୍ ମେଣ୍ଢାଙ୍କ୍ କେପ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ପ୍ରବୁନାଦ୍ ୱେର୍‍ଣ୍ଡ୍ ଦୂତ ଅଡ଼୍‌‍ ଗାର୍‍ରେ ତଅନ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ପ୍ରବୁନାଦ୍ ଗୌରବ୍ ୱେସ୍ ଅଡ଼୍‌‍ ସାର୍‍ରେପାକେ ତନ୍ଦ୍‍ତେ, ମେଣ୍ଡେ ଅଡ଼୍‌‍ ୱେର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ଆଗେତିନ୍‍ସ୍ ଦୂତ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତେ, “ୱେର୍‍ମାଟ୍, ଉଡାଟ୍, ନାନ୍ ସାରେତଡ଼୍ ନାରୁଡ଼୍ ଡ଼ାଦ୍ ଗାଟି ୱେଡ଼୍‍କେ ତେ ସୁସମାଚାର୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ");
INSERT INTO kff_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ବାତେଙ୍କ୍ ଇତ୍କେ ନେଣ୍ଡ୍ ଦାଉଦ୍‍ ତେ ନାର୍ ତାଗ୍ ମି ସେଙ୍ଗେ ତ୍ରାଣକର୍ତ୍ତାଲ୍ ଜନମ୍ ଆତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ କ୍ରିଷ୍ଟ ପ୍ରବୁ । ");
INSERT INTO kff_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ମେଣ୍ଡେ, ମି ସେଙ୍ଗେ ଇଦ୍ ଚିହ୍ନେ ଲେକାମ୍ ଆଦ୍‍ତ୍‍ତେ, ମିଡ଼୍ ୱେର୍‍ଣ୍ଡ୍ ବାବୁଙ୍କ୍ ସିଲ୍‍ଲେ ତାଗ୍ ଉତ୍‍ତି ମିକା ଗୋଡ୍ କଟାମ୍ କୁଣ୍ଡତାଗ୍ ଉଞ୍ଜି ମାନ୍ଦାନାଦ୍ ଉଡ଼ିତିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ମେଣ୍ଡେ, ତାନ୍ ପେର୍‍କେ ଆଦ୍ ଦୂତକିନ୍ ତଡ଼୍ ସ୍ୱର୍ଗକନ୍‍ସ୍ ଦୂତକିନ୍ ୱେରନ୍ ବେଡ଼୍‍ୟାଦ୍‍ ମାନ୍ଦେ ତହନ୍ଦି ଇଶ୍ୱର୍‌ତେ ପ୍ରସଂଶା ମାଡ଼ି କେତ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ସ୍ୱର୍ଗତାଗ୍ ଇଶ୍ୱର୍‌ତେ ମହିମା, ମେଣ୍ଡେ ପୃତିବିତାଗ୍ ଅନ୍‌ ଶାନ୍ତି ନାରୁଡ଼୍ ତେ ସେଙ୍ଗେ ଶାନ୍ତି ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୂତକି ତାମାଗା କଞ୍ଜ୍ ସ୍ୱର୍ଗତାଗ୍ ମାଲ୍‍ସ୍ ଆତ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ “ମେଣ୍ଢା ପଡ଼୍‍ପାନଡ଼୍ ତାମ୍‍ତାମ୍ ଲୋପେ କେତାକେତି ଆତ୍‍ତଡ଼୍, ୱାଡ଼ାଟ୍, ମାନାଡ଼୍ ବେତ୍‌ଲିହିମ୍‌ ହେଉନା ଆଞ୍ଜ୍, ପ୍ରବୁ ମାନ୍‍ ଇଦ୍ ବେନେ ଗଟନା କେତ୍‍ତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ଉଡ଼ିକାଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ଇଗେ ଅଡ଼୍‌‍ ସିଟ୍‍ପାଟ୍ ଆଞ୍ଜ୍ ମେଦ୍‍କି ମିକା ମରୀୟମ୍‍ ନୁ ଯୋଷେପ୍ ତିଙ୍କ୍, ମେଣ୍ଡେ କଟାମ୍ କୁଣ୍ଡତାଗ୍ ବାବୁ ଉଞ୍ଜି ମାନ୍ଦାନାଦ୍ ଉଡ଼୍‌ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଆଦ୍ ବାବୁନ୍ ବିଷୟତେ ଦୂତ୍‍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେନ୍ ଗଟ୍ କେସ୍ ମାତ୍‍ତଡ଼୍, ଆଦ୍ ପ୍ରକାଶ୍ ମାଡ଼୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ମେଣ୍ଢା ପଡ଼୍‍ପାନଡ଼୍ ଦେ କଞ୍ଜ୍ ଆଦ୍ ସାରେ ଗଟ୍ କେଞ୍ଜ୍ ତଡ଼୍, ଅଡ଼୍‌‍ ସାରେତଡ଼୍ ଆଗେ ଦାଦ୍‍ରେଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ବାତେଙ୍କ୍ ଇତ୍କେ ମରୀୟମ୍‍ ଇଦ୍ ସାରେ ଗଟ୍ ହୃଦୟ୍ ତାଗ୍ ନେସ୍‍ଗାଟି ଚିନ୍ତେ ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ମେଣ୍ଡେ, ମେଣ୍ଢା ପଡ଼୍‍ପାନଡ଼୍‍କିଙ୍କ୍ ଦୂତ୍ ବେଲା କେସ୍ ମାତ୍‍ତଡ଼୍, ଆଦ୍ ଲେକାମ୍ ଅଡ଼୍‌‍ ବାତେଏ କେଞ୍ଜ୍‍ତଡ଼୍‍ ନୁ ଉଡ଼୍‌ତଡ୍, ଆଦ୍ ସାରେତାୱିନ୍ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତେ ଗୌରବ୍ ନୁ ପ୍ରସଂଶା ମାଡ଼ି ମାଲ୍‍ସ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଆଟ ଦିନାତେ ଜିସୁଙ୍କ୍ ହେକ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ମନ୍ଦିର୍‌ତାଗ୍ ଆତ୍‍ତଡ଼୍, ଅନ୍‌ ପେଦେର୍ ଜିସୁ ହିତ୍‍ତଡ଼୍; ଇ ପେଦେର୍ ଅଣ୍ଡ୍‌ ଡଙ୍କେତ୍ ମାତ୍‍ତେ ମୁନେଙ୍କ୍ ଦୂତ ଇସ୍‌ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ପେର୍‍କେ ବେସୁଣ୍ଟ୍ ମଶାନାଦ୍ ବ୍ୟବସ୍ଥା ଲେକାମ୍ ତେ ତାମ୍‍ୱାଦ୍ ସୁସ୍ଥ ଆଦାନ୍ ଦିନାମ୍ ସାରେ ଆତ୍‍ତେ, ତ ଅଡ଼୍‌‍ ବାବୁଙ୍କ୍ ପ୍ରବୁନ୍ ଗାର୍‍ରେ ଉତ୍ସର୍ଗ ମାଡ଼ାଙ୍କ୍ ସେଙ୍ଗେ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ମନ୍ଦିର୍‌ତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ବେଲା ପ୍ରବୁନ୍ ବ୍ୟବସ୍ଥା ଶାସ୍ତ୍ରତାଗ୍ ଲେକ୍‍ତାଦ୍ ଲେକାମ୍ ଆସୁଣ୍ଟ୍ ସାର୍‍ରେତଡ୍ ମୁନେ ଜନମ୍ ଆତ୍‍ତେ ପିଲାଙ୍କ୍ ମାର୍‍କିଡ଼୍ ପ୍ରବୁନ୍ ଉଦ୍ଦେଶ୍ୟତେ ପବିତ୍ର ହିଞ୍ଜ ଗଣିତ ଆଦ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ମେଣ୍ଡେ ମିକା ଇଦ୍ ଗଟ୍ ଲେକାମ୍ ତେ ତାମ୍ ପ୍ରବୁନ୍ ଉଦ୍ଦେଶ୍ୟତେ ଉତ୍ସର୍ଗ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ନୁ ପ୍ରବୁନ୍ ବ୍ୟବସ୍ଥା ଶାସ୍ତ୍ରତାଗ୍ ଲେକାଆତ୍‍ତେ ବିଷୟ ଲେକାମ୍ ତେ ରେଣ୍ଡ୍ ବଡେ ବା ରେଣ୍ଡ୍ ପାର୍‍ୱେ ପିଟେ ପିଲା ବଲିଦାନ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ଯିରୁଶାଲେମ୍ ତାଗ୍ ହତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ମେଣ୍ଡେ ଉଡାଟ୍, ଯିରୁଶାଲେମ୍ ତାଗ୍ ଶିମୀୟୋନ ପେଦେର୍ ତଣ୍ଡ୍ ୱେର୍‍ଣ୍ଡ୍ ଦାର୍ମିକ୍ ନୁ ଲେକେତ୍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଇସ୍ରାଏଲ ତେ ଉଦ୍ଦାର୍‍ କର୍ତ୍ତାନ୍ କେପି ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ପବିତ୍ର ଆତ୍ମା ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","କ୍ରିଷ୍ଟନ୍ ଉଦ୍ଦାର୍ କର୍ତ୍ତାଲ୍ ତନ୍ଦ୍‍ୱେ କଟ ଅନ୍‌‍ୱାଦ୍ ଯେ ଡଲାନାଦ୍ ଆୟ୍‍ୟ, ପବିତ୍ର ଆତ୍ମା ତଡ଼୍ ଅଂକିଙ୍କ୍‌ ଇଦ୍ ଗଟ୍ କେସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ଅଣ୍ଡ୍‌ ଆତ୍ମାତେ ତଡ଼୍ ଚାଲେମ୍ ଆସ୍ ମନ୍ଦିର୍‌ ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ସୁଦୁନ୍ ଜିସୁନ୍ ୟାୟବାବ ବେସୁଣ୍ଟ୍ ତାନ୍ ବିଷୟତେ ବ୍ୟବସ୍ଥାତେ ପାଲନ୍ ଲେକାମ୍ ପାଡ଼ିୟି ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ମନ୍ଦିର୍‌ ଲୋପେ ତାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ଆସୁଣ୍ଟ୍ ଶିମୀୟୋନ ସୁଦୁନ୍ ବାବୁଙ୍କ୍ ଏତି ଇଶ୍ୱର୍‌ ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ହୋ ପ୍ରବୁ, ଇଞ୍ଜେ ନିମେ ନି ବାକ୍ୟ ଲେକାମ୍ ତେ ନିଜ୍ ଦାସଙ୍କ୍ ଶାନ୍ତିତେ ଆଦାଙ୍କ୍ ଗଟ୍ ହିସମିନ୍ଦେନି; ");
INSERT INTO kff_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ବାତେଙ୍କ୍ ଇତ୍କେ ନା କଣ୍ଡେ ନିୱାଦ୍ ପରିତ୍ରାଣ ଉଡିମିନ୍ଦେ, ");
INSERT INTO kff_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ବାତେଏ ମିଡ଼୍ ସାରେତଡ଼୍ ନାରୁଡ଼୍ ତେ ମୁନ୍‍ନେ ତିଆର୍ ମାଡ଼ିମିନ୍ଦେଡ଼ି, ");
INSERT INTO kff_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ମେଣ୍ଡେ ବିଜାତିନାରୁଡ଼୍‍କ୍ ସତ୍ ତଅତାନ୍ ୱେସ୍, ମେଣ୍ଡେ ମି ନାରୁଡ଼୍ ଇସ୍ରାଏଲତଡ଼୍‍କ୍ ଗୌରବ୍ ମାଡ଼୍‍ତି ।” ");
INSERT INTO kff_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ପିଲେତ୍ ବିଷୟତେ ଶିମୀୟନ୍ ବାତେଏ କେତ୍‍ତଣ୍ଡ୍ ଆଦ୍ କେଞ୍ଜି ତାମ୍ ୟାୟବାବ ବାକ୍‍ୱା ଆସମାତ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ମେଣ୍ଡେ, ଶିମୀୟୋନ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ି ତାମ୍ ୟାୟ ମରୀୟମ୍‍ ତିଙ୍କ୍ କେତ୍‍ତେ, “ଉଡ଼େ ଇଣ୍ଡ୍ ପିଲେତ୍ ମାଇଦିଙ୍କ୍ ଇସ୍ରାଏଲତେ ଲୋପେକେ ନାର୍ଗେ ନାରୁଡ଼୍ ଦଷି ଆଦ୍‍ତଡ଼୍ ନୁ ନାର୍ଗେ ନାରୁଡ଼୍ ଉଦ୍ଦାର୍ ଆଦ୍‍ତଡ଼୍, ଇଦିନ୍ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତେ ତଡ଼୍ ହେଞ୍ଜ୍‍ତାଦ୍ । ବେନନ୍ ବିରୁଦ୍‍ତେ ନାର୍ଗେ ନାରୁଡ଼୍ ଗଟ୍ କେତିତଡ଼୍ ଇଦ୍ ରକମ୍ ଚିହେହ୍ନେ ଲେକାମ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ନାର୍ଗେ ଅଂକିଙ୍କ୍‌ ବିରୁଦ୍ ମାଡ଼ି ନିଜର୍ ହୃଦୟ୍‍ତାଗ୍ ମିସ୍‍ତାଦ କେତ୍‍ତଡ଼୍ । ଦୁଃକାମ୍ ରକମ୍ ୱେରନ୍ ୱାୟେମାନ୍ଦାନ୍ ଚୁର୍‌ତଡ଼୍ ହୃଦୟ୍ ତିଙ୍କ୍ ଦର୍‍ରେ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ମେଣ୍ଡେ, ହାନ୍ନା ପେଦେର୍ ତେ ୱେର୍‍ଡ୍ ଡକ୍‍ରିଲ୍ ବାବବାଦୀନି ମାତ୍‍ତେ; ଆଦ୍ ଆଶେର୍ ବଂଶତାଦ୍ ପିନୂୟେଲ ତେ ପିକିଡ଼୍ । ଆଦିନାଦ୍ ଗାଟି ବୟଷ୍ ଆସ୍ ମାତ୍‍ତେ; ଆଦ୍ କୁମାରୀ ଅବସ୍ଥାତେ ପେର୍‍କେ ସାତ୍‍ହେଣ୍ଡ୍ ମୁଦ୍‍ପାନ୍‍ ତଡ଼୍ ମାତ୍‍ତେ ନୁ ଚୁଉରାଅଶୀ ୱାଡ଼୍‍ଷା ହେଉନା ରାଣ୍ଡିଲ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ଆଦ୍ ମନ୍ଦିର୍‌ତିଙ୍କ୍ ୱିଡ଼୍‍ସ୍‍ୱେ କଞ୍ଜ୍ ବାୟିଦେ ଆନ୍‌‍ୱମାତ୍‍ତେ, ଉପବାସ୍ ନୁ ପ୍ରାର୍ତନା ତଡ଼୍ ନାର୍କେପାୟାଲ ଉପବାସ୍ ମାଡ଼ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ଆଦ୍ ଦିନାମ୍‍ତେ ଆଦ୍ ଉପସ୍ଥିତ୍ ଆସ୍ ଇଶ୍ୱର୍‌ତେ ପ୍ରସଂଶା ମାଡ଼ମାଡ଼ ଯିରୁଶାଲେମ୍‍ତେ ମୁକ୍ତି କେପି ମାନ୍ଦାନ୍ ସାରେତଡ଼୍‍କିଙ୍କ୍ ଜିସୁନ୍ ବିଷୟ କେସମାତ୍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ପେର୍‍କେ ଅଡ଼୍‌‍ ପ୍ରବୁନ୍ ବ୍ୟବସ୍ଥାଲେକାମ୍ ସାରେ ପାଡ଼ିୟି ତେର୍‍ସ୍‍ପି ମିକା ଗାଲିଲୀତେ, ନିଜ୍ ନଗର୍‍ ନାଜରିତିୟ ତାଗ୍ ମାଲ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ମେଣ୍ଡେ, ସୁଦୁନଣ୍ଡ୍ ବେଡ଼େୟନ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ବୁଦ୍‍ତେ ସାରେ ଆସ୍‍ସ ଆସ୍‍ସ ଶକ୍ତିନଡ଼୍ ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଇଶ୍ୱର୍‌ତାଦ୍ ଅନୁଗ୍ରହ ଅନ୍‌ ପରୁ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ଜିସୁନ୍ ୟାୟବାବ ସାରେ ହେଣ୍ଡ୍ ନିସ୍ତାର୍ ପାଣ୍ତୁତେ ୱେଲେ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଆଞ୍ଜମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ଜିସୁନ୍ ବାର ହେଣ୍ଡ୍ ତେ ୱେଲେ ଅଡ଼୍‌‍ ରୀତି ଲେକାମ୍ ତେ ଯିରୁଶାଲେମ୍ ପାଣ୍ଡୁମ୍‍ତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ପାଣ୍ଡୁତେ ସମୟ୍ ତେର୍‍ସ୍‍ପି ମିକା ବେସୁଣ୍ଟ୍ ଅଡ଼୍‌‍ ମାଲ୍‍ସ୍ ୱାସମାତ୍‍ତଡ୍, ଆସୁଣ୍ଟ୍ ଇସୁନ୍ ଜିସୁ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ତାନ୍ ୟାୟବାବାଲ୍ ଆଦ୍ ପୁନୱେକଟ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ମାନ୍ଦେତାଗ୍ ମିନ୍ଦେଣ୍ଡ୍ ହିଞ୍ଜ ହେର୍କେ ମାଡ଼ି ଅଡ଼୍‌‍ ୱେରନ୍ ଦିନ୍ ତେ ହାର୍ ତାକିଆତ୍‍ତଡ୍, ମେଣ୍ଡେ ଆତ୍ମାତେ ନୁ ପୁତ୍‍ତେ ନାରୁଡ଼୍ ତେ ଲୋପେ ଅଂକିଙ୍କ୍‌ ମେହେକ ମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ଦର୍‍ସ୍‍କ କଟ ମେହେକ ଯିରୁଶାଲେମ୍‍ତା ମାଲ୍‍ସ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ମୁଣ୍ଡ୍ ଦିନାତେ ପେର୍‍କେ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ମନ୍ଦିର୍‌ ତାଗ୍ ଦର୍‍ସ୍‍କ୍‍ତଡ଼୍; ଅଣ୍ଡ୍‌ ପଣ୍ଡିତ୍‍ନାରୁଡ୍ ଲୋପେ କୁଦି ଅଡ଼ାଦ୍‌ ଗଟ୍ କେଞ୍ଜ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପଶ୍ନ କେସ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ମେଣ୍ଡେ, ବେସର୍ ନାରୁଡ଼୍ ଅନାଦ୍‌ ଗଟ୍ କେଞ୍ଜ ମାତ୍‍ତଡ଼୍, ସାରେତଡ଼୍ ଅନାଦ୍‌ ବୁଦ୍‍ ନୁ ଉତ୍ତର୍ ତେ ବାକ୍‍ୱା ଆସ୍‍ସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ତାମ୍ ୟାୟ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ପେକାଲ୍ ମା ସେଙ୍ଗେ ବାତେଙ୍କ୍ ଇଦ୍ ରକମ୍ ବ୍ୟବହାର୍ ମାଡ଼୍‍ତି ? ଉଡ଼େ, ମି ବାବାଲ୍ ନୁ ନାନ୍ ଗାଟି ଦାନ୍ଦେ ଆସ୍ ମିକା ନିକିଂଙ୍କ୍ ମେହେକ୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ଇଗେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେହେକ ମାତ୍‍ତିଡ୍ ? ନା ବାବାନ୍ ଲୋନ୍‌ ମାନ୍ଦାନାଦ୍ ଯେ ନାୱାଦ୍ ପାଡ଼ିୟି, ଇଦ୍ ପୁନ୍‍ୱେକଟ୍ ମାତ୍‍ତିଡ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେନେ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ଅଡ଼୍‌‍ ବୁଜେମ୍ ଆଦାଙ୍କ୍ ପାର୍‍ୱଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ପେର୍‍କେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ ତଡ଼୍ ମାଲ୍‍ସ୍ ନାଜରିତିୟ ତାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍ ନୁ ଅଡ଼ାଦ୍‌ ଗଟ୍ କେଞ୍ଜି ମାତ୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ, ତାମ୍ ୟାୟ ଇଦ୍ ସାରେ ଗଟ୍ ସାବ୍‍ଦାନ୍ ତଡ଼୍ ତାନ୍ ହୃଦୟ୍ ତାଗ୍ ନେହେତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ମେଣ୍ଡେ, ଜିସୁ ବୁଦ୍‍ ତେ ନୁ ମେନ୍ଦୁଲ୍ ତେ, ମେଣ୍ଡେ ଇଶ୍ୱର୍‌ ନୁ ନାରୁଡ଼୍ ତେ ଅନୁଗ୍ରହ ତେ ପେର୍‍ସାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ସମ୍ରାଟ୍ ତିବିରିଆ କାଇସର୍‍ତେ ଶାସନ୍‍ ତେ ପନ୍ଦ୍ର ୱାଡ଼୍‍ଷା ତେ, ବେସୁଣ୍ଟ୍ ପନ୍ତୀୟ ପିଲାତ ଯିହୂଦା ନାର୍‍ଦେ ଶାସନ୍‍କର୍ତ୍ତାଲ୍ ନୁ ହେରୋଦ୍ ଗାଲିଲୀତା ସାମନ୍ତରାଜାଲ୍ ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ତାନ୍ ତାମୁଣ୍ଡ୍‌ ପିଲିପ୍‍ପ ଇତୂରୀୟା ନୁ ତ୍ରାକୋନୀତି ନାର୍‍ଦେ ସାମନ୍ତରାଜାଲ୍, ମେଣ୍ଡେ ଲୂସାନୀୟା ଅବିଲୀନୀ ନଗର୍‍ତେ ସାମନ୍ତରାଜାଲ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ମେଣ୍ଡେ ହାନାନ ନୁ କୟାପା ବେଡ଼ିୟିଯାଜକ ମାତ୍‍ତଡ଼୍, ଆସୁଣ୍ଟ୍ ପରମେଶ୍ୱର୍‍ ତେ ବାକ୍ୟ ଉସ୍କ ନେଲ୍‍ଦାଗ୍ ମାନ୍ଦାନ୍ ଜିକରୀୟ ତେ ମାର୍‍ ଯୋହନ୍‌ ଗାର୍‍ରେ ଉପସ୍ଥିତ୍ ହାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ଆଗେ ବାପ୍ତିଜକ ଯୋହନ୍‌ ଯର୍ଦ୍ଦନ ବେଡ଼େମ୍ ତେ ଗାର୍‍ରେ ସାରେ ଜାଗେତାଗ୍ ଆଞ୍ଜ୍ “ପାପ୍‍କ୍ଷମା ସେଙ୍ଗେ ମନପରିବର୍ତ୍ତନ୍ ତେ ବାପ୍ତିସ୍ମ କେତାନଙ୍କ ପସ୍‍ପ୍‍ତଣ୍ଡ୍,” ");
INSERT INTO kff_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ବେଦ୍‍ଲେକାମ୍ ଯିଶାଇୟ ବାବବାଦୀ ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, “ବେନ ୱେରଣ୍ଡ୍ ଉସ୍କନେଲ୍‍ କଞ୍ଜ୍ ଗାଟି ଲେଙ୍ଗ୍‍ତେ କେସମିନ୍ଦେଣ୍ଡ୍, ପ୍ରବୁନ୍ ସେଙ୍ଗେ ହାର୍ ତିଆର୍ ମାଡ଼ାଟ୍; ଅନାଦ୍‌ ଆଦାନାଦ୍ ସେଙ୍ଗେ ତିନାଙ୍କ୍ ହାର୍ ତିଆର୍ ମାଡ଼ାଟ୍; ");
INSERT INTO kff_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ସାର୍‍ରେ ଉପତ୍ୟକା ସାରେ ମାଡ଼ାଙ୍କ୍ ଆଦ୍‍ତେ, ମେଣ୍ଡେ ସାର୍‍ରେ ମେଟା ନୁ ସୁଦୁ ମେଟା ସାମାନ୍ ମାଡ଼ାଙ୍କ୍ ଆଦ୍‍ତେ, ୱାଙ୍କ୍‍ଙ୍ଗ ହାର୍ ସାରେ ତିନାଙ୍କ୍ ଆଦ୍‍ତେ, ମେଣ୍ଡେ ଗୁଇନ୍ଦା ଗପ୍ ବୁମ୍ ସାମାନ୍ ହାର୍ ତେ ସାୟେ ଆଦ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ମେଣ୍ଡେ, ସାରେତଡ଼୍ ନାରୁଡ଼୍ ଇଶ୍ୱର୍ ତେ ପରିତ୍ରାଣ ଉଡ଼ିତଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ଆସୁଣ୍ଟ୍ ଅଣ୍ଡ୍‌ ତାନ୍ ତଡ଼୍ ବାପ୍ତିସ୍ମ ଆଦାନ୍ ସେଙ୍ଗେ ପେଇସ୍ ୱାଦାନ୍ ନାରୁଡ଼୍‍କ୍ ଯୋହନ୍‌ କେତ୍ତଣ୍ଡ୍, “ରେ ୱିସାମ୍ ମାନ୍ଦାନ୍ ତାଡ଼ାମ୍‍ ବଂଶତଡ଼୍, ୱାଦାନ୍ ଦଣ୍ଡତେ ୱେଲେ ମିରାନଙ୍କ୍ ସେଙ୍ଗେ ବେନ ମିକିଂଙ୍କ୍ ଚେତନା ହିତ୍‍ତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ଯଦି ନିଜାମ୍ ପାପ୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତିଡ଼୍, ଇଦ୍ ମିଡ଼୍ ସାୟେତ୍ ପାଡ଼ିୟିଦାଗ୍ ତଅମୁଟ୍; ମେଣ୍ଡେ, ଅବ୍ରାହାମ୍‌ ମା ବାବାଲ୍ ଇଞ୍ଜ, ମନ୍ ତେ ମନ୍ ତେ ମିକା ଇଦ୍ ଲେକାମ୍ କେଲମାଟ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ତ ମିକିଂଙ୍କ୍ କେତୁତାନ, ପରମେଶ୍ୱର୍‍ ଇଦ୍ କାଲ୍‍କିନ୍ ତଡ଼୍ ଆବ୍ରାହାମ୍ ତେ ସେଙ୍ଗ୍ ମାର୍‍ ତିଆର୍‍ମାଡ଼୍‍ଡ଼େ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ମେଣ୍ଡେ, ଇଞ୍ଜେ ମିକା ମାଡ଼ାକିନ୍ ମଦଲ୍ ଗଡେଲ୍‍ ମିନ୍ଦେ; ବେନ୍ ମାଡ଼ାକିନାଗ୍ କାୟା ସାୟେ ଆଦକ୍, ଆୱିଙ୍କ୍ ନାଡ଼୍‍କି କିସ୍‍ତାଗ୍ ୱାଟିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ଇଗେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ଆଲାତ୍କେ ମାନାଡ଼୍ ବାତେଏ ମାଡ଼ିକାଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଯୋହନ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ବେନନାଗ୍‍ ରେଣ୍ଡ୍ ଚକା ମିନ୍ଦେ, ଅଣ୍ଡ୍‌ ବେନନାଗ୍‍ ଇଲ୍‍ଲେ, ଅଂକିଙ୍କ୍‌ ୱେରନ୍ ହିୱୀଣ୍ଡ୍; ମେଣ୍ଡେ ବେନଙ୍କ୍ ତିନ୍ଦାନାଦ୍ ମିନ୍ଦେ, ଅଣ୍ଡ୍‌ ଆଦ୍ ଲେକାମ୍ ମାଡ଼ିଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","କର ଆଦାୟ୍ ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ମିକା ବାପ୍ତିସ୍ମ ଆଦାଙ୍କ୍ ୱାସ୍ ଯୋହନ୍‌‌ତିଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ହୋ ଗୁରୁ, ମାନାଡ଼୍ ବାତେଏ ମାଡ଼ିକାଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ମି ସେଙ୍ଗେ ବେସର୍ ନିୟମ୍ ମିନ୍ଦେ, ତାନାଗାକସ୍‍ ଗାଟି ଆଦାୟ ମାଡ଼ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ସୈନିକ୍ ମିକା ଯୋହନ୍‌‌ତିଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ମାନାଡ଼୍ ବାତେଏ ମାଡ଼ିକାଡ଼୍ ?” ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଶକ୍ତି ତେ କି ଚଲଣା ତେ ବେନନ୍ ଦନ୍ ହଇମାଟ୍, ମେଣ୍ଡେ, ମି ଦରମାତେ ଶାନ୍ତି ଆଇମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ନାରୁଡ଼୍ ୱିଡ଼୍‍ସି ମାଡ଼ିମାତାଙ୍କ୍ ଯୋହନ୍‌ ମାନ୍‌ କ୍ରିଷ୍ଟ ଆଦ୍‍ତଣ୍ଡ୍, ଇଦ୍‍ ତାନ୍ ବିଷୟ ତେ ସାରେତଡ଼୍ ତାମ୍‍ତାମ୍ ଲୋପେ ହାଲ୍‍ସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ଆଦିନ୍ ସେଙ୍ଗେ ଯୋହନ୍‌ ସାରେତଡ଼୍‍କିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ସିନା ମିକିଂଙ୍କ୍ ଏର୍‍ ଦାଗ୍ ବାପ୍ତିସ୍ମ ହିଦୁତାନ୍, ମାତର୍ ନାୟାଗ୍ କଞ୍ଜ୍ ବେନ ଗାଟି ମହାନ୍, ଅଣ୍ଡ୍‌ ୱାସ ମିନ୍ଦେଣ୍ଡ୍, ଅନ୍‌‍ୱାଦ୍ ହେର୍‍ପୁକ୍ ତେ ନୁଲ୍ କୁସ୍ପାନଙ୍କ୍ ମିକା ନାନ୍ ଯୋଗ୍ୟ ଆୟନ୍; ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ନୁ କିସ୍ ତାଗ୍ ବାପ୍ତିସ୍ମ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ଅନ୍‌ କାଇଦେ ଏତ୍ ମିନ୍ଦେ, ତ ଅଣ୍ଡ୍‌ ପଲେ ମାନ୍ଦାନ୍ ଶସ୍ୟ ପରିଷ୍କାର୍ ମାଡ଼ି ତାନ୍ କୁସ୍‍ତାଗ୍ ନେହେତିତଣ୍ଡ୍ ନୁ ପଲେତିଙ୍କ୍ ଅଣ୍ଡ୍‌ ସାରେ ଦିନ୍ ନିଡ଼୍‍ତାନ୍ କିସ୍‍ତାଗ୍ ପଡ଼୍‍ସ୍ପିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ଅଣ୍ଡ୍‌ ଇଦ୍ ରକମ୍ ଗାଟି କେତାନାଦ୍ ଇସ୍, ମେଣ୍ଡେ ନାର୍ଗେ ଲେକାମ୍ ଉତ୍ସାହ ରକମ୍ ବାକ୍ୟ କେସ୍ ନାରୁଡ଼୍ ତେ ଗାର୍‍ରେ ଗଟ୍ ପ୍ରଚାର୍ ମାଡ଼ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ମାନ୍‍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ କେତାନାଦ୍ ହିତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ବାତେଙ୍କ୍ ଇତ୍କେ ସାମନ୍ତରାଜାଲ୍ ହେରୋଦ୍ ନିଜେ ତାମୁଣ୍ଡ୍‌ ତେ ମୁତ୍‍ତେ ହେରୋଦ୍ ବିଷୟ ତେ ନୁ ତାନ୍ ମାଡ଼୍‍ତେ କାରାବ୍ ବିଷୟ ତେ ଯୋହନ୍‌ ତାକିଂଙ୍କ୍ ବିରୋଦ୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ଜେଲ୍ ତାଗ୍ ତୁର୍‍ୱି ନିଜର୍ ବାଗାତ୍ କାରାବ୍ ତଡ଼୍ ଇଦ୍ କାରାବ୍ ମିକା କାଲ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ସାରେତଡ଼୍ ନାରୁଡ଼୍ ବାପ୍ତିସ୍ମ ଆତ୍‍ତା ପେର୍‍କେ ଜିସୁ ମିକା ବାପ୍ତିସ୍ମ ହତ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ୱେଲେ ସ୍ୱର୍ଗ ତେର୍‍ସ୍‍ଆତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ମେଣ୍ଡେ ପବିତ୍ର ଆତ୍ମା ଡିଗିୱାସ୍ ଜିସୁନ୍ ପରୁ ପାର୍ୱା ରକମ୍ ମେନ୍ଦୁଲ୍‍ ପୟ୍‍ସ୍‍ କୁଦ୍‍ତେ; ମେଣ୍ଡେ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଇଦ୍ ଗଟ୍‍ନା ଆତ୍‍ତେ, “ନିମେ ମା ପ୍ରିୟ ମାର୍‍, ନିୟାଗେ ନାନେ ଗାଟି ସନ୍ତୁଷ୍ଟ ।” ");
INSERT INTO kff_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜିସୁ ପାଡ଼ିୟି ଆରାମ୍ ମାଡ଼ାନ୍ ୱେଲେ ଅଂକିଙ୍କ୍‌ ମାତର୍ ତିରିଶ୍ ହେଣ୍ଡ୍ ବୟଷ୍ ଆସ୍ ମାତ୍‍ତେ; ନାରୁଡ଼୍ ତେ ହାଲ୍‍ସାନ୍ ଲେକାମ୍ ତେ ଜିସୁ ଯୋଷେପ୍ ତେ ମାର୍‍; ଯୋଷେପ୍ ଏଲୀ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲୀ ମତ୍‍ତାତେ ତେ ମାର୍‍; ମତ୍‍ତାତେ ଲେବୀ ତେ ମାର୍‍, ଲେବୀ ମଲାକୀ ତେ ମାର୍‍, ମଲାକୀ ଯନ୍ନୟ ତେ ମାର୍‍, ଯନ୍ନୟ ଯୋଷେପ୍ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଯୋଷେପ୍ ମତ୍‍ତିତ୍ୟା ତେ ମାର୍‍, ମତ୍‍ତିତ୍ୟା ଆମୋସ ତେ ମାର୍‍, ଆମୋସ ନାହୂମ୍ ତେ ମାର୍‍, ନାହୂମ୍ ହେସ୍ଲୀ ତେ ମାର୍‍, ହେସ୍ଲୀ ନଗୟ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗୟ ମହତ ତେ ମାର୍‍, ମହତ ମତ୍‍ତିତ୍ୟା ତେ ମାର୍‍, ମତ୍‍ତିତ୍ୟା ଶିମୟୀ ତେ ମାର୍‍, ଶିମୟୀ ଯୋସେକ ତେ ମାର୍‍, ଯୋସେକ ଯୋଦା ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଯୋଦା ଯୋହନ୍‌ ତେ ମାର୍‍, ଯୋହନ୍‌ ରେଷା ତେ ମାର୍‍, ରେଷା ଜିରୁବବାବେଲ୍‍ ତେ ମାର୍‍, ଜିରୁବବାବେଲ୍‍ ଶଆଲ୍‌ତୀୟେ ତେ ମାର୍‍, ଶଆଲ୍‌ତୀୟେ ନେରୀ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରୀ ମଲାକୀ ତେ ମାର୍‍, ମଲାକୀ ଆଦ୍ଦି ତେ ମାର୍‍, ଅଦ୍ଦି କୋସାମ ତେ ମାର୍‍, କୋସାମ ଏଲ୍ମଦାନ ତେ ମାର୍‍, ଏଲ୍ମଦାନ ଏର ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର ଯିହୋଶୂୟ ତେ ମାର୍‍, ଯିହୋଶୂୟ ଏଲୀୟେଜର ତେ ମାର୍‍, ଏଲୀୟେଜର ଯୋରୀମ ତେ ମାର୍‍, ଯୋରୀମ ମତ୍‍ତାତେ ମାର୍‍, ମେତୁଶେଲାତେ ଲେବୀ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବୀ ଶିମୀୟୋନ ତେ ମାର୍‍, ଶିମୀୟୋନ ଯିହୂଦା ତେ ମାର୍‍, ଯିହୂଦା ଯୋଷେପ୍ ତେ ମାର୍‍, ଯୋଷେପ୍ ଯୋନାମ ତେ ମାର୍‍, ଯୋନାମ ଏଲୀୟାକୀମ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲୀୟାକୀମ ମଲାହ ତେ ମାର୍‍, ମଲାହ ମନ୍ନା ତେ ମାର୍‍, ମନ୍ନା ମତ୍ତଥାତେ ତେ ମାର୍‍, ମତ୍ତଥାତେ ନାତ୍‍ନ ତେ ମାର୍‍, ନାତ୍‍ନ ଦାଉଦ୍‍ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦ୍ ଯେଶୀତେ ମାର୍‍, ଯିଶାୟ ଓବେଦ ତେ ମାର୍‍, ଓବେଦ ବୋୟଜ ତେ ମାର୍‍, ବୋୟଜ ଶେଲହ ତେ ମାର୍‍, ଶେଲହ ନହଶୋନ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହଶୋନ ଅମିନାଦାବ୍‌ ତେ ମାର୍‍, ଅମିନାଦାବ ଆଦ୍ମୀନ ତେ ମାର୍‍, ଆଦ୍ମୀନ ଆର୍ଣ୍ଣୀ ତେ ମାର୍‍, ଆର୍ଣ୍ଣୀ ହେସ୍ରୋଣ ତେ ମାର୍‍, ହେସ୍ରୋଣ; ମାଲ୍‍ପିତେ ମାର୍‍, ମାଲ୍‍ତେ ଯିହୁଦା ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଯିହୁଦା ଯାକୁବ୍ ତେ ମାର୍‍, ଯାକୁବ୍ ଇସ୍‍ହାକ ତେ ମାର୍‍, ଇସ୍‍ହାକ ଅବ୍ରାହାମ୍ ତେ ମାର୍‍, ଅବ୍ରାହାମ୍‌ ତେରହ ତେ ମାର୍‍, ତେରହ ନାହୋର୍ ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନହୋର୍ ସେରଗ୍‍ତେ ମାର୍‍, ସେରଗ୍‍ତେ ମାର୍‍, ରେଉ ପେଲେଗ୍‍ତେ ମାର୍‍, ପେଲେଗ୍‍ ଏବର୍‍ତେ ମାର୍‍, ଏବର୍‍ ଶେଲାଙ୍କତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ଶେଲା କେଇନାନ୍‍ତେ ମାର୍‍, କେଇନାନ୍‍ ଆର୍‍ପାକ୍‍ସଡ଼ତେ ମାର୍‍, ଆର୍‍ପାକ୍‍ସଡ଼ ଶେମ୍‍ତେ ମାର୍‍, ଶେମ୍‍ ନୋହତେ ମାର୍‍, ନୋହ ଲାମେକ୍‍ତେ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲାମେକ୍‍ ମେତୁଶେଲାତେ ମାର୍‍, ମେତୁଶେଲା ଅନୋକତେ ମାର୍‍, ହନୋକ୍‍ ଯାରେଦନ୍‍ତେ ମାର୍‍, ଯାରେଦ ମହାଲାଲୀଲ୍‍ତେ ମାର୍‍, ମହାଲାଲୀଲ୍‍ କେନାନ୍‍ତେ ମାର୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନାନ୍‍ ଏନୋଶତେ ମାର୍‍, ଏନୋଶ ଶେତ୍‍ତେ ମାର୍‍, ଶେତ୍‍ ଆଦମ୍‍ତେ ମାର୍‍, ଆଦମ୍‍ ଇଶ୍ୱରତେ ମାର୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜିସୁ ପବିତ୍ର ଆତ୍ମାତେ ପୁରା ଆସ୍ ଯର୍ଦ୍ଦନ ବେଡ଼େମ୍ କଞ୍ଜ୍ ମାଲ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ପବିତ୍ର ଆତ୍ମାତେ ତଡ଼୍ ଚାଲେମ୍ ଆସ୍ ଅଂକିଙ୍କ୍‌ ସିମ୍‍ସାମ୍ ପଡ଼ିୟେତାଗ୍ ଆତ୍‍ତେ । ଆଗେ ଅଣ୍ଡ୍‌ ଚାଳିଶ୍ ଦିନ୍ ହେଉନା ଶୟ୍‍ତାନ୍‍ ତଡ଼୍ ପରୀକ୍ଷିତ ଆସମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ଆୱ୍ ସାରେ ଦିନାକ୍ ତେ ଅଣ୍ଡ୍‌ ବାଆତେ ତିନ୍‍ୱେକଟ ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆୱ୍ ସାରେ ଦିନାକ୍ ଶେଷ୍ ଆତ୍‍ତେ ୱେଲେ, ଅଂକିଙ୍କ୍‌ ଗାଟି କାର୍‍ପଇତେ । ");
INSERT INTO kff_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ଆଗେ ଶୟ୍‍ତାନ୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ନିମେ ଯଦି ଇଶ୍ୱର୍‌ ତେ ମାର୍‍, ଆଲାତ୍କେ ଇଦ୍ କାଲ୍‍ଦିଙ୍କ୍ ରୋଟି ଆଦାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ଇତ୍‍କେ ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ନାରୁଡ଼୍ ବେସୁଣ୍ଟ୍ ରୋଟି ତଡ଼୍ ବାଦ୍‍କଡ଼୍ ।’” ");
INSERT INTO kff_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ତାନ୍ ପେର୍କେ ଶୟ୍‍ତାନ୍‍ ଅଣ୍ଡୟ୍‌‍ ବେଡ଼୍‍ୟାଦ୍‍ ମେଟେତ୍ ଜୁଟିନାଗ୍ ଆତ୍‍ତେ ନୁ ଅଂକିଙ୍କ୍‌ ଜଗତ୍‍ତାଦ୍ ସାରେ ରାଜ୍ୟତାଦ୍ ସମ୍ପତି ତଅସ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ମେଣ୍ଡେ, ଶୟ୍‍ତାନ୍‍ ଜିସୁଙ୍କ୍ କେତ୍‍ତେ, “ନାନ୍ ନିକିଂଙ୍କ୍ ଇଦ୍ ସାରେ ଅଦିକାର୍ ନୁ ଇଦ୍ ସାରେ ସମ୍ପତ୍ତି ହିଦ୍‍ତାନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାକିଂଙ୍କ୍ ଆଦ୍ ସମର୍ପିତ୍ ଆସ୍ ମିନ୍ଦେ, ମେଣ୍ଡେ ନାନ୍ ବେନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିତାନ୍, ଅଂକିଙ୍କ୍‌ ଆଦ୍ ହିଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ମେଣ୍ଡେ, ନିମେ ଯଦି ନାକିଂଙ୍କ୍ ମଡ଼୍‍କିତି, ଆସୁଟ, ସାରେ ନିୟାୱୁ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଜେକେ ଅନ୍‌ ଶୟ୍‍ତାନ୍‍ ! ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ମାତର୍ ନି ପ୍ରବୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଉପବାସ୍ ମାଡ଼େ ନୁ ଅନାଦ୍‌ ସେବା ମାଡ଼େ ।’” ");
INSERT INTO kff_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ ଯିରୁଶାଲେମ୍ ତାଗ୍ ଆସ୍ ମନ୍ଦିର୍‌ ତେ ଜୁଟିନାଗ୍‌ ନିଲ୍‍ପି ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନିମେ ଯଦି ଇଶ୍ୱରତେ ମାର୍‍, ଆଲାତ୍କେ ଇଗାଙ୍କ୍ ମଦଲ୍ ତୁଲ୍‍ଲେ;” ");
INSERT INTO kff_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ବାତେଙ୍କ୍ ଇତ୍କେ ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, “ନିକିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ ତାନ୍ ଦୂତକିଂଙ୍କ୍ ନି ବିଷୟ ତେ ଆଦେଶ୍‍ ହିଦ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଇଦ୍ ମିକା ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ଇତ୍‍କେ ନି ଡେକେ କାଲ୍‍ଦାଗ୍ ତାଲ୍‍ଗିତେ, ଇଦ୍ ସେଙ୍ଗେ ଦୂତୁକ୍ ନିକିଂଙ୍କ୍ କାଇଦେ ତେଇସ୍ ପଇତିତା ।’” ");
INSERT INTO kff_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ମେଣ୍ଡେ, ଜିସୁ ଶୟ୍‍ତାନ୍‍ ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍‍, “ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ନିମେ ପ୍ରବୁ ନିଜର୍ ଇଶ୍ୱର୍‌ ତିଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼ାନାଦ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ଜିସୁଙ୍କ୍, ଶୟ୍‍ତାନ୍‍ ସାରେ ଲେକାମ୍ ପରିକ୍ଷା ମାଡ଼ି ତେର୍‍ସ୍ପ୍‍ତେ ପେର୍‍କେ ବେସ୍‌କ୍ ଦିନାତ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ଇଦିନ୍ ପେର୍‍କେ ଜିସୁ ଆତ୍ମାନ୍‌ ଶକ୍ତିତେ ଗାଲିଲୀତାଗ୍ ମାଲ୍‍ତଣ୍ଡ୍‍, ମେଣ୍ଡେ ସାରେ ପଡ଼ିୟେତାଗ୍ ତାନ୍ ବିଷୟତେ ଗଟି ପ୍ରଚାର୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ମେଣ୍ଡେ, ଜିସୁ ଯିହୁଦୀଡ଼୍ ପ୍ରାର୍ତନା ଲୋକିନାଗ୍ ଶିକ୍ଷା ଇସ୍‌ ଗୌରବ୍‍ ପାଏମ୍‍ ଆତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ତାନ୍ ପେର୍‍କେ ଜିସୁ ବେନେ ନାଜରିତିୟ ତାଗ୍ ପେର୍ସି ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ଅଣ୍ଡ୍‌ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ତାମ୍ ରୀତି ଲେକାମ୍ ବିଶ୍ରାମବାରତେ ଉପାସନା ଲତ୍‍ତାଗ୍ ଅସ୍‍ତଣ୍ଡ୍‍, ମେଣ୍ଡେ ଦର୍ମଶାସ୍ତ୍ର କାର୍‍ତାନ୍ ସେଙ୍ଗେ ନିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ଆସୁଣ୍ଟ୍ ଯିଶାଇୟ ବାବବାଦୀ ବଇ ଅଂକିଙ୍କ୍‌ ହିତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଜିସୁ ଆଦିଙ୍କ୍ ଟେଣ୍ଡିମିକା, ବେଗେ ଇଦ୍ ବାକ୍ୟ ଲେକା ଆସ୍‍ମାତ୍‍ତେ, ଆଦ୍ ଦରସ୍‍କ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ପ୍ରବୁନାଦ୍ ଆତ୍ମା ନା ପରୁ ମିନ୍ଦେ, ଆଦିନ୍ ସେଙ୍ଗେ ଦୁଃକାମ୍ ନାରୁଡ଼୍‍ତେ ଗାର୍‍ରେ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ହେଞ୍ଚିମିନ୍ଦେଣ୍ଡ୍, ବନ୍ଦୀ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମୁକ୍ତି ନୁ କାନାଲଡ଼୍‍କ୍ କଣ୍ଡେତ୍ ୱେସ୍ ବିଷୟ କେତାନଙ୍କ୍, ମେଣ୍ଡେ ଅତ୍ୟାଚାରି ନାରୁଡ଼୍‍କ୍ ମୁକ୍ତି ମାଡ଼ାଙ୍କ୍, ");
INSERT INTO kff_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ପ୍ରବୁ ତାନ୍ ନାରୁଡ଼୍‍କ୍ ରକ୍ଷା ମାଡ଼ାନ୍ ସମୟ୍ ଯେ ଉପସ୍ଥିତ ଇଦ୍‍ କେତାନଙ୍କ୍ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ରହସ୍ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ପେର୍‍କେ ଅଣ୍ଡ୍‌ ବଇତିଙ୍କ୍ ବନ୍ଦ୍ ମାଡ଼ି ଦାସନଡ଼୍ ଆଦ୍ ଇସ୍‌ ମିକା କୁଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ସମାଜ୍ ଲୋତ୍‍ତାଗ୍ ସାରେତଡ଼ାୱ୍ କଣ୍ଡା ଅନ୍‌ ପରୁ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ମେଣ୍ଡେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନେଣ୍ଡ୍ ଦର୍ମଶାସ୍ତ୍ରତାଦ୍ ଇଦ୍ ବାକ୍ୟ ମିଡ଼୍ ବାଆତେ କେଞ୍ଜ୍‍ତିଡ଼୍ ଆଦ୍ ସାରେ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ମେଣ୍ଡେ, ସାରେତଡ଼୍ ଅନ୍‌ ବିଷୟ ତେ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଡ଼୍ ନୁ ଅନ୍‌‍ୱେ ପାୟୁର୍ କଞ୍ଜ୍ ପେୟିତେ ଆକର୍ଷନ୍ ବାକ୍ୟତେ ବାକ୍‍ୱା ଆଦ୍‍ତଡ଼୍; ମେଣ୍ଡେ ଅଡ଼୍‌‍ କେତୁତଡ଼୍‍, “ଇଣ୍ଡ୍ ଯଷେପ୍ ତେ ମାର୍‍ ଆୟ୍‍ୟଣ୍ଡ୍ କି ?” ");
INSERT INTO kff_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ମିଡ଼୍ ନିଜାମ୍ ନାକିଂଙ୍କ୍ ମୁନେତ୍ ମାତ୍‍ତା ବାକ୍ୟ କେତିତିଡ଼୍‍, ହୋ ଚିକିତ୍ସା ମାଡ଼ାନଡ଼ି, ମୁନେନ୍ ମିକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ାଟ୍; ମେଣ୍ଡେ ମିକା କେତିତିଡ଼୍ କପର୍‍ନାହୂମ୍‍ତାଗ୍ ବାତେଏ ଗଟେମ୍ ଆତ୍‍ତେ ଇଞ୍ଜ ମାନାଡ଼୍ କେଞ୍ଜ୍‍ତାଡ଼୍, ଆଦ୍ ସାରେ ଇଦ୍ ପଡ଼ିୟେତାଗ୍ ନିଜର୍ ଜନମ୍ ନେଲ୍‍ତାଗ୍ ମିକା ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ମେଣ୍ଡେ, ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ କେତୁତାନ୍, ବେନେ ବାବବାଦୀ ମିକା ନିଜର୍ ଜନମ୍ ନଗର୍‍ତାଗ୍ ସମ୍ମାନ୍ ଆୟଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍ କେତୁତାନ୍, “ଏଲୀୟ ତେ ୱେଲେ ବେସୁଣ୍ଟ୍ ଇସ୍ରାଏଲ୍‍ତାଗ୍ ମୁଣ୍ଡ୍ ହେଣ୍ଡ୍ ଆରୁ ନେଲଞ୍ଜ୍ ହେଉନା ୱାର୍‍ସାମ୍ ୱାଡ଼ୱାଙ୍କ୍ ଦେଶ୍ ଏକାମ୍ ଏର୍‍ ମୁଉସ୍‍ ଆତ୍‍ତେ, ଆସୁଣ୍ଟ୍ ଇସ୍ରାଏଲ ତାଗ୍ ଗାଟି ରାଣ୍ଡିଲ୍ ମାତ୍‍ତା; ");
INSERT INTO kff_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ମିକା ଇଶ୍ୱର୍ ଏଲୀୟଙ୍କ୍ ଆୱିନାଗେ ଗାର୍‍ରେ ବେନଡାଗେ ରଉୱକଟ ସୀଦୋନ୍ ଦେଶ୍‍ତେ ସାରିପତ୍‍ତେ ୱେରଡ଼୍ ରାଣ୍ଡିନାଗ୍ ରହତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ମେଣ୍ଡେ, ବାବବାଦୀ ଇଲୀଶାୟତେ ୱେଲେ ଇସ୍ରାଏଲତାଗେ ଗାଟି କୁଷ୍ଠୀରୋଗି ମାତ୍‍ତଡ଼୍; ମିକା ଅଡ଼୍‌‍ ଲୋପେ ବେନଙ୍କେ ସୁସ୍ଥ ମାଡ଼୍‍ୱେ ମାତ୍‍ତଡ଼୍, ମାତର୍ ସୁରିଆ ଦେଶ୍‍ତେ ନାମାନ୍ ସୁସ୍ଥ ମାଡ଼ିମାତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ସମାଜ୍ ଲୋତ୍‍ତାଗେ ଇଦ୍ ସାରେ ଗଟ୍ କେଞ୍ଜ ସାରେତଡ଼୍ କପାମ୍‍ତେ ସାରେ ଆତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ମେଣ୍ଡେ, ଅଡ଼୍‌‍ ତେଦି ଅଂକିଙ୍କ୍‌ ନଗର୍‍ କଞ୍ଜ୍ ପେସ୍‍ପିତ୍‍ତଡ଼୍ ନୁ ଅଡ଼ାଦ୍‌ ନଗର୍‍ ବେନେ ମେଟେତ୍ ପରୁ ତିଆର୍ ଆସ୍‍ମାତ୍‍ତେ, ଆଦିନାଦ୍ ଜୁଟିନାଗା କନ୍‍ସ୍ ମଦଲ୍ ହେସାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ଆଗେ ହତ୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍ ଲୋପେତ୍ କେ ପେଇସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ଅଣ୍ଡ୍‌ କପର୍ନାହୁମ୍‍‍କଞ୍ଜ୍‌ ଗାଲିଲୀତେ ୱେରଡ଼୍‌ ନଗର୍‍ତାଗେ ୱାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ବିଶ୍ରାମବାରତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶିକ୍ଷା ହିଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଅନ୍‌‍ୱାଦ୍ ଶିକ୍ଷା କେଞ୍ଜି ଆଶର୍ଯ୍ୟ ଆତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅନ୍‌‍ୱାଦ୍ ବାକ୍ୟ ଅଦିକାର୍‌ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ଅଣ୍ଡ୍‌ ଦିନେ ସମାଜ୍ ଲତ୍‍ତାଗ୍ ୱେର୍‍ଣ୍ଡ୍ ଅଶୁଚି ବୁତ୍‌ପଇତେ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ହୋ, ନାଜରିତ ଜିସୁ, ମା ତଡ଼୍ ନିୱାଦ୍ ବାତେଏ ମିନ୍ଦେ ? ନିମେ ମାକିଂଙ୍କ୍ ଆୱକାଙ୍କ୍ ୱାତିକି ? ନିମେ ବେନନି, ଆଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍; ନିମ୍‍ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାସ୍‍ମାନ୍ଦାନ୍ ଆଦ୍ ପବିତ୍ର ନାରୁନୀ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","“ଜିସୁ ଆସୁଙ୍କ୍ ଦମକ୍ ଇସ୍ କେତ୍‍ତନ୍, କଟ ଆୟମ୍, ଇନାଗା କଞ୍ଜ୍ ପେୟିସ୍ ଅନ୍‌ । ଆଗେ ଆଦ୍ ବୁତ୍ ଅଡ଼୍‌‍ ମୁନ୍‍ନେ ୱାଟି ଅଂକିଙ୍କ୍‌ ବାତେଏ କ୍ଷତି ମାଡ଼କଟ୍ ପେୟିସ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ଇଗେ ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆସ୍ ନିଜେନିଜେ କେତାକେତି ଆତ୍‍ତଡ଼୍, ଇଦ୍ ବେସତ୍ ଗଟ୍ ? ଅଣ୍ଡ୍‌ ଅଦିକାର୍‌ ନୁ ଶକ୍ତି ତଡ଼୍ ଅଶୁଚି ଆତ୍ମାକିଂଙ୍କ୍ ଗଟ୍ ହିଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆୱ୍ ପେୟିସ୍ ଆତ୍‌ତେ । ");
INSERT INTO kff_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ଆଗେ ଅନ୍‌‍ୱାଦ୍ ବିଷୟତେ ସୁସମାଚାର୍ ସାରେ ପାକା ସାରେ ପଡ଼ିୟେତାଗ୍ ପ୍ରଚାର୍ ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ପେର୍‍କେ ଜିସୁ ସମାଜ୍‍ଲନ୍ ତାଗାଙ୍କ୍ ତେଦି ଶିମୋନ୍‍ତେ ଲୋନ୍‌ ଆତ୍‍ତଣ୍ଡ୍ । ଶିମୋନ୍ ତେ ପୟେଙ୍କ୍ ଗାଟି ହେଡ଼େକ୍ ଆସ୍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଶାସନ୍‍ ବିଷୟତେ ତାଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ାଙ୍କ୍ ଜିସୁଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ଆଗେ ଅଣ୍ଡ୍‌ ତାମ୍ ଗାର୍‍ରେ ନିଶ୍‍ମିକା ହେଡ଼େକ୍ ତିଙ୍କ୍ ଦମକ୍ ହିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆଦିଙ୍କ୍ ହେଡ଼େକ୍ ୱିଡ଼୍‍ସ୍ତା, ମେଣ୍ଡେ ଆଦ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ତେଦି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସେବା ମାଡ଼ାଙ୍କ୍ ପସ୍ପିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ପଡ଼ଦ୍ ଆଦାନ୍ ୱେଲେ, ବେନଡ଼ାଗ୍ ନାଆ ଲେକାମ୍ ରଗ୍‍ତେ ନାରୁଡ଼୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ସାରେତଡ଼୍‍କିଙ୍କ୍ ଅନ୍‌ ଗାର୍‍ରେ ତାତ୍‍ତଡ଼୍ ନୁ ଅଣ୍ଡ୍‌ ସାରେ ନାରୁଡ଼୍ ତେ ପରୁ କାୟ୍ ୱାଟି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ମେଣ୍ଡେ, ବୁତ୍‌କ୍‍ ମିକା କିଡ଼୍‍କ କିଡ଼୍‍‍କ ନିମେ ଇଶ୍ୱର୍‌ ତେ ମାର୍‍ ଇଞ୍ଜ କେସ୍ ନାର୍ଗେ ନାରୁଡ଼୍ ତେ କଞ୍ଜ୍ ପେୟିସ୍ ଆତ୍‍ତା । ମେଣ୍ଡେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦମକ୍ ଇସ୍‌ ଗଟ୍ କେତାଙ୍କ୍ ହିୱଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଯେ କ୍ରିଷ୍ଟ, ଇଦ୍ ଅଡ଼୍‌‍ ପୁଞ୍ଜ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ନାର୍‍କୁକ୍ ଆତ୍‍ତେୱେଲେ, ଅଣ୍ଡ୍‌ ନଗର୍‍କଞ୍ଜ୍ ପେଇସ୍ ୱେରଡ଼୍ ବେନଇଲ୍‍ୱେ ପଡ଼ିୟେତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ, ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଅଂକିଙ୍କ୍‌ ମେଦ୍‍କି ମେଦ୍‍କି ଅନ୍‌ ଗାର୍‍ରେ ୱାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ବେଲା ଅଡ଼୍‌‍ ଗାର୍‍ରେ କନ୍‍ସ୍ ଆତ୍ମାକିନ୍ ଆଦ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ନିଲ୍‍ସ୍ପାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ବେନ୍‍ବେନା ନଗର୍‍ତାଗେ ମିକା ନାକିଂଙ୍କ୍ ଆଦ୍‍ଲେକାମ୍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ଡ଼ାଦ୍ “ସୁସମାଚାର୍ ପ୍ରଚାର ମାଡ଼ାଙ୍କ୍ ଆଦ୍ ତେ, ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦିନ୍ ସେଙ୍ଗେ ଇଶ୍ୱର୍ ନାକିଂଙ୍କ୍ ରହସ୍ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଯିହୁଦା ଦେଶ୍ ତେ ପ୍ରାର୍ତନା ଲୋକିନାଗ୍ ପ୍ରଚାର ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ଅଣ୍ଡ୍‌ ଦିନେ ଜିସୁ ଗିନେସର୍‍ତ ସାୱୁଡ଼େ ଆଞ୍ଚିନାଗ୍‌ ନିଶ୍ ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ନାରୁଡ଼୍ ଅନ୍‌ ବାକ୍ୟ କେଞ୍ଜାନଙ୍କ୍ ତୁର୍ସାତୁର୍ସି ଆସମାତ୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ସାୱୁଡ଼େ ଆଞ୍ଚିନାଗ୍‌ ରେଣ୍ଡ୍ ଓଡା ମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତ୍ତଣ୍ଡ୍; କିକେ ପଇତାନଡ଼୍ ଆଗାକନ୍‍ସ୍ ଡିଗି ଜାରି ନର୍‍ସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ଆୱ ଅଡ଼୍‌ ଲୋପେ ବେଦ୍ ଶିମୋନ୍ ଡ଼ାଦ୍ ମାତ୍‍ତେ, ଆଗେଅଣ୍ଡ୍‌ ତାରି ବୂମ୍‌କନ୍‍ସ୍‍ ସୁଦୁର୍ ଜେକେ ଆଦାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌‍ ମାଡ଼୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଓଡ଼େତାଗ୍ କୁଦି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶିକ୍ଷା ହିଦାଙ୍କ୍ ପସ୍‍ପିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଅଣ୍ଡ୍‌ ଗଟି ତେର୍‍ସ୍‍ପି “ଶିମୋନ୍ ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, କୁଇଙ୍ଗ୍ ଏର୍‍ ଦାଗେ ଆଞ୍ଜ୍ କିକେ ପଇତାନ୍ ସେଙ୍ଗେ ମିୱାଦ୍ ଜାରି ୱାଟାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ଇଗେତିସ୍‍ନ୍‍ ଶିମୋନ୍ କେତ୍ତଣ୍ଡ୍, ହୋ ଗୁରୁ, ମାମ୍ ନିଟେ ନାର୍କେ ତିପାଲ୍ ମାଡ଼ି ବାତେଏ ପୟ୍‍ମ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ନି ଗଟ୍ ତେ ନାନ୍ ଜାରି ୱାଟିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ମେଣ୍ଡେ, ଅଡ଼୍‌‍ ଆଦ୍ ୱାଟି ଗାଟି କିକେ ପୟିତ୍‍ତଡ୍, ମେଣ୍ଡେ ଅଡ଼୍‌‍ୱାଦ୍ ଜାରି ଦେଗାଙ୍କ୍ ଲେକାମ୍ ହାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ଆଗେ ତାମ୍ ବେନ୍ ଉଦାର୍‍ ଆତ୍‍ତେନଡ଼୍ ବାଗାତ୍ ଓଡେ ତାଗ୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ବେଲା ୱାସ୍ ସାହାଯ୍ୟ ମାଡ଼ିତ୍‍ତଡ଼୍, ଇଦିନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାଇଦେ କାରଙ୍ଗ୍‍ତଡ଼୍‍ । ଇଗେ ଅଡ଼୍‌‍ ୱାସ୍ ରେଣ୍ଡ୍ ଓଡାକିଂଙ୍କ୍ ଇଦ୍ ରକମ୍ ସାରେ ମାଡ଼ିତଡ୍ ଯେ ଆୱ ମୁଡୁନ୍ଦାନ୍ ରକମ୍ ଆତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","“ବାତେଙ୍କ୍ ଇତ୍କେ ଶିମୋନ୍ ପିତର୍ ଇଦ୍ ଉଡ଼ି ଜିସୁନ୍ ଡେକାନ୍ ମଦଲ୍ ମଡ଼୍‍କି କେତ୍‍ତଣ୍ଡ୍, ହୋ ପ୍ରବୁ, ନାୟାଗ୍ କଞ୍ଜ୍ ଆଦାନଙ୍କ୍ ଆଇମ୍, ବାତେଙ୍କ୍ ନାନ୍ ୱେରଣ୍ଡ୍ ପାପି ନାରୁନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଆଗେ ୱିଡ଼୍‍ସଡ଼୍ କିକେ ପଡ଼ିୟିହିତ୍‍ତଡ଼୍ ଯେ, ଆଦ୍ ଉଡ଼ି ଶିମୋନ୍ ନୁ ତାମ୍ ସାଙ୍ଗଡ଼୍ ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ମେଣ୍ଡେ, ଜେବଦିତେ ଇଡ଼ିୱୁଡ଼୍‍ ମାର୍‍କ୍ ଯାକୁବ୍ ନୁ ଯୋହନ୍‌, ବେନଡ଼୍ ଶିମୋନ୍‍ତେ ସାଙ୍ଗଡ଼୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ମିକା ଆଦ୍ ରକମ୍ ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍ । ମେଣ୍ଡେ, ଜିସୁ ଶିମୋନ୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନା ତଡ଼୍ ୱାଡ଼ାଟ୍ । ନାନ୍ ମିକିଂଙ୍କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପଇତାନାଦ୍ ନାଡ଼୍‍ସ୍ପିତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ଆଗେଙ୍କ୍ ଅଡ଼୍‌‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଡ଼ାୱୁ ୱାଲା ୱିଡ଼୍‍ସି ଅନ୍‌ ତଡ଼୍ ପେର୍‍କେ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ଅନ୍‌‍ଦାମ୍ ଜିସୁ ୱେରନ୍ ନଗର୍‍ ତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ, ଉଡାଟ୍, ୱେର୍‍ଣ୍ଡ୍ କୁଷ୍ଠୀରୋଗି ନାରୁଡ଼୍ ଆଦ୍ ଜାଗେତାଗେ ମାତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ ଉଡ଼ି କାପ୍‍ମୁଡୁନ୍ଦି ଅଂକିଙ୍କ୍‌ ଦନ୍ୟବାଦ୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ହୋ ପ୍ରବୁ, ନିମେ ଯଦି ଇଚ୍ଛା ମାଡ଼ିତି, ଆଲାତ୍କେ ନାକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ଡ଼େ ପାର୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ଆଗେଙ୍କ୍ ଅଣ୍ଡ୍‌ କାୟ୍ ଆଇସ୍ ଅଂକିଙ୍କ୍‌ ଇଟି କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ଇଚ୍ଛା ମାଡ଼ୁତାନ୍, ସୁସ୍ଥ ଆଇମ୍ ।” ସାଙ୍ଗେ ସାଙ୍ଗେ କୃଷ୍ଟ ରୋଗ୍ ଅନାଗ୍‍କଞ୍ଚ୍‍ ମାୟିଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ମେଣ୍ଡେ, ଜିସୁ ଅଂକିଙ୍କ୍‌ ଗଟ୍ ଇସ୍‌ କେତ୍ତଣ୍ଡ୍, “ବେନଙ୍କେ କେଲ୍‍ମା, ବାତେଙ୍କ୍ ଇତ୍କେ ସିଦା ଯାଜକତେ ଗାର୍‍ରେ ଅନ୍‌ ନୁ ଅଣ୍ଡ୍‌ ନିକିଂଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼ିଣ୍ଡ୍, ତାନ୍ ପେର୍‍କେ ନିମେ ସୁସ୍ଥ ଆତ୍‍ତିନ୍ ଇଞ୍ଜ ବାଗାତ୍ ନାରୁଡ଼୍‍ତେ ଗାର୍‍ରେ ପ୍ରମାନ୍ ହିଦାନ୍ ସେଙ୍ଗେ ମୋଶାନ୍‌ ଆଦେଶ୍‍ ଲେକାମ୍ ବଲି ଉତ୍ସର୍ଗ ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁନ୍ ବିଷୟ ତେ ଗଟ୍ ମେଣ୍ଡେ ଅଦିକ୍‌ ସାରେପାକ୍ ଆତ୍‍ତେ, ମେଣ୍ଡେ ଗାଟି ନାରୁଡ଼୍ କେଞ୍ଜାନ୍ ସେଙ୍ଗେ ନୁ ନିଜ୍ ରୋଗ୍ କନ୍‍ସ୍ ସୁସ୍ଥ ଆଦାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡୟାଗେ ଗୁଡୁତଡ଼୍‍; ");
INSERT INTO kff_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ମାତର୍ ୱେରଡ଼୍ ସିମ୍‍ସାମ୍ ଜାଗେତାଗେ ମାଞ୍ଜ୍ ପ୍ରାର୍ତନା ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ଅନ୍‌ ଦିନେ ଜିସୁ ଶିକ୍ଷା ଇସ୍‌‍ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଗାଲିଲୀତେ ସାରେ ନାର୍, ମେଣ୍ଡେ ଯିହୁଦା ପ୍ରଦେଶ୍ ନୁ ଯିରୁଶାଲେମ୍ କନ୍‍ସ୍ ୱାସ୍ ମାନ୍ଦାନ୍ ପାରୂଶୀ ନୁ ଶାସ୍ତ୍ରୀଡ଼୍ ଗାର୍‍ରେ କୁଦିମାତ୍‍ତଡ଼୍ । ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ବେଦ୍ ରକମ୍ ରୋଗିଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ିତନ୍, ଇଦ୍ ସେଙ୍ଗେ ପ୍ରବୁନାଦ୍ ଶକ୍ତି ଉପସ୍ଥିତ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ମେଣ୍ଡେ, ଉଡାଟ୍, ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ଅରଟ୍ ପକ୍ଷାଘାତ ରୋଗି ନାରୁଙ୍କ୍ କାଟୁଲ୍ ତାଗ୍ କାଞ୍ଜି ତାସ୍ ଅଂକିଙ୍କ୍‌ ଲୋପେ ଆଦାନ୍ ସେଙ୍ଗେ ନୁ ଜିସୁନ୍ ମୁନ୍‍ନେ ରେହେତାନ୍ ସେଙ୍ଗେ ଆଲ୍‍ସି ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ଆତ୍‍ତାଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଲୋପେ ଆଦାନ୍ ସେଙ୍ଗେ ହାର୍ ଦରସ୍‍କାଙ୍କ୍ ଅଡ଼୍‌‍ ଲୋତ୍‍ତେ ପରୁ ଆଞ୍ଜ୍ ମୁର୍ସିଙ୍କ୍ ଟେଣ୍ଡି ଲୋପେକେ କାଟୁଲ୍ ତଡ଼୍ ଅଂକିଙ୍କ୍‌ ନାଡ଼ମେ ଜିସୁନ୍ ମୁନ୍‍ନେ ୱେହେସିତ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ୱାଦ୍ ବିଶ୍ୱାସ୍ ଉଡ଼ି କେତ୍ତଣ୍ଡ୍, “ହୋ ବାବୁ, ନିୟାଦ୍ ପାପ୍ ସାରେ କ୍ଷମା ମାଡ଼ିତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ଆଗେ ଶାସ୍ତ୍ରୀନାରୁଡ଼୍‌ ନୁ ପାରୂଶୀଡ଼୍ ତିରିୟା ତିରିୟି ହାସ୍ ଇଲା କେତାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍, ଇଣ୍ଡ୍ ଯେ ଇଶ୍ୱର୍‌ତିଙ୍କ୍‌ ଅପ୍‌ମାନ୍‌ ମାଡ଼ୁତଣ୍ଡ୍, “ଇଣ୍ଡ୍ ବେନ ? ମାତର୍‍ ଇଶ୍ୱର୍‌ ତେ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନ ପାପ୍ କ୍ଷମାମାଡ଼୍ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍ୱାଦ୍ ଗଟ୍ ତିରିୟାନାଦ୍ ପୁଞ୍ଜ୍ ମିକା ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ମିଡ଼୍ ନିଜ୍‍ନିଜ୍ ମାନ୍‍ଦାଗ୍ ବାତେଙ୍କ୍ ଆଦ୍ ରକମ୍ କାରାପ୍‍ ଗଟି ତିରିୟୁତିଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ବେନ୍ କେତାନାଦ୍ ସହଜ୍ ? ନି ପାପ୍ ସାରେ କ୍ଷମା ମାଡ଼୍‍ତଡ଼୍ ଇଞ୍ଜ କେତାନାଦ୍, ନା, ତେଏଦେ, ଅନ୍‌ ଇଞ୍ଜ କେତାନାଦ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ବାତେଙ୍କ୍ ଇତ୍କେ ପୃତିବିତେ ପାପ୍ କ୍ଷମା ମାଡ଼ାଙ୍କ୍ ନାରୁନ୍‍ପିଲେ ତିଙ୍କ୍‌ ଅଦିକାର୍‌ ମିନ୍ଦେ, ଇଦ୍ ବେଲା ମିଡ଼୍ ପୁଞ୍ଜ୍ ପାର୍‍ଦ୍‍ତିଡ଼୍-ଇଦ୍ ସେଙ୍ଗେ ଜିସୁ ପକ୍ଷାଘାତ ରୋଗ୍‍ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ନାନ୍ କେତୁତାନ୍ ତେଦ୍‍ଦେ,” ନି କାଟୁଲ୍ ପୟିସ୍ ନି ଲୋନ୍‌ ହାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ଆଗେତିନ୍‍ସ୍ ଅଣ୍ଡ୍‌ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଡ଼୍‌‍ ମୁନେତ୍‍କେ ତେଏଦି, ବେନେ କାଟୁଲ୍‍ତେ ପରୁ ଅଣ୍ଡ୍‌ ପାଟିମାତ୍‍ତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ପୟିସ୍ ଇଶ୍ୱର୍‌ ତେ ମହିମା କୀର୍ତ୍ତନ୍ ମାଡ଼ମାଡ଼ ନିଜେ ଲୋନ୍‌ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ଆସୁଣ୍ଟ୍ “ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆସ୍ ଇଶ୍ୱର୍‌ତେ ମହିମା କୀର୍ତ୍ତନ୍ ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ ନୁ ଗାଟି ୱେର୍‍ସ୍ କେତ୍ତଡ଼୍, ନେଣ୍ଡ୍ ମାମ୍ ଗାଟି ଆଦ୍‍ବୁତ୍ ଗଟନା ଉଡ଼୍‍ତମ୍ ! ");
INSERT INTO kff_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ଇଦିନ୍ ପେର୍‍କେ ଜିସୁ ପେୟିସ୍ ଆଞ୍ଜ୍ ଲେବୀ ପେଦେର୍ ତେ ୱେର୍‍ଣ୍ଡ୍ କର ଆଦାୟ ମାଡ଼ାନକିଂଙ୍କ୍ କର ଆଦାୟ ପଡ଼ିୟେତାଗ୍ କୁଦିମାନ୍ଦାନାଦ୍ ଉଡ଼ି ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, ନା ପେର୍‍କେ ୱାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ଆଗେଙ୍କ୍ ଲେବୀ ସାରେତାୱିଙ୍କ୍ ୱିଡ଼୍‍ସି ମିକା ତେଦି ଅନ୍‌ ପେର୍କେ ତାକାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ମେଣ୍ଡେ, ଲେବୀ ନିଜେ ଲୋନ୍‌ ଅନ୍‌ ସେଙ୍ଗେ ୱେରନ୍ ବେଡ଼େୟାଦ୍ ବଜି ମାଡ଼ତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଗାଟି ନାର୍ଗେମାନ୍ଦେ କରଗ୍ରାହୀ ନୁ ତାନ୍‌ ନାରୁଡ଼୍ ଅଡ଼୍‌‍ ତଡ଼୍ ତିନ୍ଦାନଙ୍କ୍ କୁଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ଆଗେ ପାରୂଶୀଡ଼୍ ନୁ ଅଡ଼୍‌‍ ମାନ୍ଦେତେ ଶାସ୍ତ୍ରୀଡ଼୍ ଅନ୍‌ ଶିଷ୍ୟନ୍ ବିରୁଦ୍ ତେ ଅବିଯୋଗ୍ ମାଡ଼ି କେତୁତଡ଼୍, “ମିଡ଼୍ ବାତେଙ୍କ୍ କରଗ୍ରାହୀ ନୁ ପାପି ନାରୁଡ଼୍ ତଡ଼୍ ତଡ଼େକ୍ ତିନ୍ଦାନ୍ ଉନ୍ଦାନ୍ ମାଡ଼ୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ସୁସ୍ଥ ନାରୁଡ଼୍‍କ୍ ଡାକ୍ଟର୍‍ତେ ଦର୍‍କାର୍ ଇଲ୍‍ଲେ, ମାତର୍ ରଗ୍‍ତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଦର୍‍କାର୍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ନାନ୍ ଦାର୍ମିକ୍ ନାରୁଡ଼୍‍କ୍ କାରଙ୍ଗାନ୍ ସେଙ୍ଗେ ୱାଡ଼ନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମନପରିବର୍ତ୍ତନ୍ ସେଙ୍ଗେ ପାପି ନାରୁଡ଼୍‍କ୍ କାରଙ୍ଗାନ୍ ସେଙ୍ଗେ ୱାସ୍‍ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍ତଡ଼୍, “ଯୋହନ୍‌ ତେ ଶିଷ୍ୟଡ଼୍ ନାର୍ଗେ ଦିନାମ୍‍ତେ ଉପବାସ୍ ନୁ ପ୍ରାର୍ତନା ମାଡ଼ିତଡ଼୍, ପାରୂଶୀଡ଼୍ ତେ ଶିଷ୍ୟଡ଼୍ ମିକା ଆଦ୍ ରକମ୍ ମାଡ଼ିତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଇ ଶିଷ୍ୟଡ଼୍ ତିନ୍ଦାନ୍ ଉନ୍ଦାନ୍ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ଆଗେତିନ୍‍ସ୍ “ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ପେଣ୍ଡୁଲ୍ ନାରୁଡ଼୍‍ତଡ଼୍ ବର ମାନ୍ଦାନ୍ ୱେଲେ ମିଡ଼୍ କି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉପବାସ୍ ମାଡ଼େ ପାର୍‍ଦ୍‍ତିଡ଼୍ ? ବେସୁଟ୍‌ ମିକା ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ବାତେଙ୍କ୍ ଇତ୍କେ ସମୟ୍ ୱାଦ୍‍ତା; ମେଣ୍ଡେ, ବେସୁଣ୍ଟ୍ ଅଡ଼ାଗାକନ୍‍ସ୍ ବରତିଙ୍କ୍ ୱିରସ୍‍ପି ହଦ୍‍ତଡ଼୍, ଆସୁଣ୍ଟ୍ ଆଦ୍ ଦିନାମ୍‍ତେ ଅଡ଼୍‌‍ ଉପବାସ୍ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ମେଣ୍ଡେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେରଡ୍‍ ୱେଷଡ଼୍ କେତ୍ତଣ୍ଡ୍, “ବେନ ପୁଃନେ ସିଲେତ୍ କନ୍‍ସ୍ ତାଲି ଦେହେସ୍ ପାଃନ୍ତେ ସିଲେତାଗ୍ ୱାଟଣ୍ଡ୍; ୱାଟକେ ଅଣ୍ଡ୍‌ ପୁଉନାଦିଙ୍କ୍ ଇକିତଣ୍ଡ୍, ମେଣ୍ଡେ ପୁଃନେ ସିଲେତ୍ ତାଲି ପାଃନ୍‌ତାଦ୍‌ ତଡ଼୍ କାୟିଲ ।” ");
INSERT INTO kff_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ମେଣ୍ଡେ, ବେନ ପୁଃନେ ଦ୍ରାକ୍ଷାରସ୍ ପାଃନ୍ତେ କୁଣ୍ଡେତାଗ୍ ୱାଟଣ୍ଡ୍; ୱାଟକେ ପୁଃନେ ଦ୍ରାକ୍ଷାରସ୍ କୁଣ୍ଡେତିଙ୍କ୍ ହୁଃତିତେ, ମେଣ୍ଡେ କୁଣ୍ଡେ ନୁ ଅଙ୍ଗୁର୍ ରସ୍ ନଷ୍ଟ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ବାତେଙ୍କ୍ ଇତ୍କେ ପୁଃନେ ଦ୍ରାକ୍ଷାରସ୍ ପୁଃନେ କୁଣ୍ଡେତାଗେ ନେହେତାନ୍ ଲେକେତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ମେଣ୍ଡେ, ବେନ ପାଃନ୍ତେ ଦ୍ରାକ୍ଷାରସ୍ ଉଞ୍ଜ୍ ମିକା ପୁଃନେ ଦ୍ରାକ୍ଷାରସ୍ ଉନ୍ଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ କେତିତଣ୍ଡ୍, ପାଃନ୍‌ତାଦ୍‌ ତ ସାଏ । ");
INSERT INTO kff_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ଅଣ୍ଡ୍‌‍ଦିନ୍ ଜିସୁ ବିଶ୍ରାମଦିନେ ତାଗ୍ ଶସ୍ୟୱାୟେ ତାଲାନ୍ ଆଞ୍ଜ ମାନ୍ଦାନ୍ ୱେଲେ ଅନ୍‌ ଶିଷ୍ୟଡ଼୍ କେଡ଼୍ ଦେହେସ୍ କାଇଦେ ନଅକି ତିଞ୍ଜ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ଇତ୍କେ ପାରୂଶୀଡ଼୍ ଲୋପେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେତ୍‍ତଡ଼୍‍, “ବିଶ୍ରାମଦିନେ ଦାଗେ ବାତେଏ ମାଡ଼ାନାଦ୍ ନିୟମ୍‍ ଆୟ୍‍ୟ, ଆଦ୍ ମିଡ଼୍ ବାତେଙ୍କ୍ ମାଡ଼ୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, ଦାଉଦ୍‍ ନୁ ତାମ୍ ସାଙ୍ଗଡ଼୍ କାରୱିନ୍ ମାନ୍ଦାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ବାତେଏ ମାଡ଼ତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ମିଡ଼୍ କାର୍‍ୱିଡ଼୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଅଣ୍ଡ୍‌ ବେଲା ଇଶ୍ୱର୍ ତେ ଲୋନ୍‌ ଆସି, ବେନେ ଦର୍ଶନୀରୂଟି ମାତର୍ ଯାଜକିଡ଼୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନଙ୍କେ ତିନ୍ଦାନଙ୍କ୍ ନିୟମ୍‍ ଆୟ୍‍ୟ, ଆଦ୍ ତାସ୍ ତିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ତାନ୍ ସାଙ୍ଗଡ଼କ୍ ମିକା ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ମେଣ୍ଡେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନାରୁନ୍‍ପିଲେ ବିଶ୍ରାମଦିନେତେ ପ୍ରବୁ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଜିସୁ ମେଣ୍ଡେଅଣ୍ଡ୍‌ ବିଶ୍ରାମଦିନେ ତେ ସମାଜ୍ ଲତ୍‍ତାଗେ ନେଙ୍ଗିମିକା ଶିକ୍ଷା ହିସ ମାତ୍‍ତଣ୍ଡ୍; ଆଗେ ୱେରନ୍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ଅନ୍‌‍ୱାଦ୍ ତିନ୍ଦେକାଇ ୱାତିମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଉମ୍ଭ ବିଶ୍ରାମଦିନେ ଦାଗେ ସୁସ୍ଥ ମାଡ଼ିତନ୍, ଇଦ୍ ଉଡ଼ାନ୍ ସେଙ୍ଗେ ଶାସ୍ତ୍ରୀ ନୁ ପାରୂଶୀଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ ମାତ୍‍ତଡ଼୍, ବେଲାକି ଅଡ଼୍‌‍ ଅନ୍‌ ବିରୁଦ୍ ତେ ଦଷ୍ ପଇତାଙ୍କ୍ ପାର୍‍ଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍ୱାଦ୍ ମନ୍‍ତାଦ୍ ହେର୍କା ପୁଞ୍ଜ୍, ବେନ୍ ନାରୁଡ଼୍ ତେ କାୟ୍ ୱାତିମାତ୍‍ତେ, ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, ତେଦ୍‍ଦା ନାଡ଼ମେ ନିଲ୍‍ମ୍ । ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ତେଦି ନିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ଆଗେଙ୍କ୍ “ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ନାନ୍ ମିକିଂଙ୍କ୍ ପାଚ୍ରାମାଡୁତାନ୍, ବିଶ୍ରାମଦିନେ ତେ ବାତେଏ ମାଡ଼ାନାଦ୍ ନିୟମ୍‍ ? ସାୟେ ମାଡ଼ାନାଦ୍ ନା କାରାପ୍ ମାଡ଼ାନାଦ୍ ? ଜିୱୁଣ୍ଡ୍ ରକ୍ଷା ମାଡ଼ାନାଦ୍ ନା ଆୱକାନାଦ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ମେଣ୍ଡେ, “ଅଣ୍ଡ୍‌ ସାର୍‍ରେପାକେ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଉଡ଼ି ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, ନି କାଇଆମ୍ । ଆସୁଣ୍ଟ୍ ଅଣ୍ଡ୍‌ ଆଲା ମାଡ଼ତ୍‍ତଣ୍ଡ୍, ଆସୁଟେ ଅନ୍‌‍ୱାଦ୍ କାୟ୍ ସୁସ୍ଥ ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ କପାମ୍ ଆଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଜିସୁନ୍ ସେଙ୍ଗେ ବାତେମାଡ଼୍ ପାର୍‍ଦ୍‍ତଡ଼୍, ଆଦ୍ ବିଷୟତେ ନିଜେ ନିଜେ ଗଟି ତିରିୟା ତିରିୟି ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ଆସୁଣ୍ଟ୍ ଜିସୁ ଅନ୍‌‍ଦିନେ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ମେଟେତାଗ୍ ଆଞ୍ଜ୍ ପରମେଶ୍ୱରତେ ଗାର୍‍ରେ ପ୍ରାର୍ତନା ମାଡ଼ମାଡ଼ ନିଟ୍‍ଟା ନାର୍କେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ନାର୍‍କୁକ୍, ଜିସୁ ତାନ୍ ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍ ଗାର୍‍ରେ କାର୍‍ଙ୍ଗି ଅଡ଼୍‌‍ ଲୋପେ ବାରଜାନ୍‍ତିଙ୍କ୍ ଏଞ୍ଚତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିକା ପ୍ରେରିତ୍ ପେଦେର୍ ହିତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ଅଡ଼୍‌‍ ଆତ୍‍ତଡ଼୍ ଶିମୋନ୍, ବେନଙ୍କ୍ ଅଣ୍ଡ୍‌ ମିକା ପିତର୍ ପେଦେର୍ ହିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ତାମ୍ ଦାଦାଲ୍‌ ଆନ୍ଦ୍ରିୟ, ଯାକୁବ୍ ନୁ ଯୋହନ୍‌, ପିଲିପ୍‍ପ ନୁ ବର୍ତଲମି, ");
INSERT INTO kff_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିଉ ନୁ ତୋମା, ଆଲ୍‍ଫିତେ ମାର୍‍ ଯାକୁବ୍ ନୁ ଶିମୋନ୍, ବେନଙ୍କ୍ ଉଦଯୋଗୀ ଇଞ୍ଜ କେତିତଡ଼୍‍, ");
INSERT INTO kff_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଯାକୁବ୍ ତେ ମାର୍‍ ଯିହୂଦା ନୁ ଇଷ୍କାରିୟୋତୀୟ ଯିହୂଦା, ବେନ ଜିସୁଙ୍କ୍ ଶତ୍ରୁଡ଼୍ କାଇଦେ ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ମେଣ୍ଡେ, ଜିସୁ ପ୍ରେରିତ୍ ତଡ଼୍ ମେଟେତାଗାଙ୍କ୍ ମଦଲ୍ ୱାତ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ତାନ୍ ଗାଟି ନାର୍ଗେ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ୱେରନ୍ ସାମ୍‍ନ୍ ବୁମ୍‍ତାଗେ ନିତ୍‍ତଡ଼୍ । ମେଣ୍ଡେ ସାରେ ଯିହୂଦା ପ୍ରଦେଶ୍, ଯିରୁଶାଲେମ୍, ମେଣ୍ଡେ ସୋର ନୁ ସୀଦୋନ୍‍ତେ ଆଞ୍ଚିନାଗା କଞ୍ଜ୍ ଗାଟି ନାରୁଡ଼୍ ଉପସ୍ଥିତ୍ ଆତ୍‍ତଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ଅଡ଼୍‌‍ ଅନ୍‌ ବାକ୍ୟ କେଞ୍ଜାନଙ୍କ୍ ନୁ ନିଜ୍‍ନିଜ୍ ରୋଗତେ କନ୍‍ସ୍ ସୁସ୍ଥ ଆଦାନ୍ ସେଙ୍ଗେ ୱାସ୍ ମାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ବେନ ଅଶୁଚି ଆତ୍ମା ତଡ଼୍ କଷ୍ଟ ଆସ୍‍ସ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ସାରେତଡ଼୍‍କ୍ ଜିସୁ ସୁସ୍ଥ ମାଡ଼ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ମେଣ୍ଡେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଇଟାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ମାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅନାଗା କଞ୍ଜ୍ ଶକ୍ତି ପେୟିସ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ଆସୁଣ୍ଟ୍ ଜିସୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ପାକ୍‍କେ ଉଡ଼ି କେତ୍ତଣ୍ଡ୍, “ଅଦାତ୍ମିକ୍ ଜିୱୁନ୍‍ତାଗ୍ ଦୁର୍ବଲ୍ ଇଞ୍ଜ ଏର୍କା ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ଦନ୍ୟ,” ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ସ୍ୱର୍ଗରାଜ୍ୟତେ ଅଦିକାର୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ଇଞ୍ଜେ କାର୍‍ୱିନ୍ ଯେ ମିଡ଼୍, ମିଡ଼୍ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ତିଞ୍ଜ୍‌ ପାଞ୍ଜିତିଡ଼୍‌ । ଇଞ୍ଜେ କେୟୁତିଡ଼୍‍ ଯେ ମିଡ଼୍, ମିଡ଼୍ ଦନ୍ୟ, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ କାୱଦିତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ନାରୁଡ଼୍ ବେସୁଣ୍ଟ୍ ନାରୁନ୍‍ପିଲେ ସେଙ୍ଗେ ମିକିଂଙ୍କ୍ ୱେଏରେ ମାଡ଼ିତଡ଼୍, ପାସ୍‍କିତଣ୍ଡ୍, ମେଣ୍ଡେ ନିନ୍ଦା ମାଡ଼ିତଡ଼୍ ନୁ ମି ପେଦେର୍‍ତିଙ୍କ୍ କାରାବ୍‍ ଇଞ୍ଜ ପୟଡ୍, ଆସୁଣ୍ଟ୍ ମିଡ଼୍ ଦନ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ଆଦ୍‍ଦିନେ ୱେଡ଼୍‍କା ମାଡ଼ି ହେନ୍ଦାଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଉଡ଼ାଟ୍, ସ୍ୱର୍ଗତାଗେ ମିୱାଦ୍ ପୁରସ୍କାର୍ ମିନ୍ଦେ; ମେଣ୍ଡେ, ଆଦ୍ ରକମ୍ ତ ଅଡ଼୍‌‍ୱାଦ୍‌ ପିତୃପୁରୁଷନଡ଼୍ ବାବବାଦୀଡ଼୍ ସେଙ୍ଗେ ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ବାତେଙ୍କ୍ ଇତ୍କେ ହାୟେ, ଦଣ୍ଡତେ ନାରୁଡ଼ି ସାଉକାର୍ ଯେ ମିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ନିଜେ ନିଜେ ସୁକାମ୍‍ତେ ମିନ୍ଦେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ହାୟେ, ଦଣ୍ଡତେ ନାରୁନ୍ ନାର୍ଗେମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଯେ ମିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ କାରୱିନ୍ ଆଦ୍‍ତିଡ଼୍ । ହାୟେ, ଦଣ୍ଡତେ ପାତ୍ର ଇଞ୍ଜେ କାୱଦୁତିଡ଼୍‍ ଯେ ମିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ଦୁଃକାମ୍ ନୁ କେୟିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ବେସୁଣ୍ଟ୍ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ମିକିଂଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼ି କେତିତଡ଼୍, ଆସୁଣ୍ଟ୍ ହାୟେ, ମିଡ଼୍ ଦଣ୍ଡତେ ପାତ୍ର; ଆଦ୍ ରକମ୍ ତ ଅଡ଼୍‌‍ୱାଦ୍‌ ପିତୃପୁରୁଷନଡ଼୍ ବଣ୍ଡବାବବାଦିଡ଼୍‍ ସେଙ୍ଗେ ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","ବାତେଙ୍କ୍ ଇତ୍କେ କେଞ୍ଜୁତିଡ଼୍‍ ଯେ ମିଡ଼୍, ମିକିଂଙ୍କ୍ ନାନ୍ କେତୁତାନ୍, ମି ଶତ୍ରୁନଡ଼୍‍କ୍ ପ୍ରେମ୍ ମାଡ଼ାଟ୍; ବେନଡ଼୍ ମିକିଂଙ୍କ୍ ପାସ୍‍କିତଡ଼୍, ଅଡ଼ାଦ୍‌ ଲେକେତ୍ ମାଡ଼ାଟ୍; ");
INSERT INTO kff_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ବେନଡ଼୍ ମିକିଂଙ୍କ୍ ଅବିଶାପ୍‌ ହିଦ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ାଟ୍; ବେନଡ଼୍ ମିକିଂଙ୍କ୍ ଅପ୍‍ମାନ୍ ମାଡ଼ିତଡ଼୍, ଅଡ଼୍‌‍ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ବେନ ମିକିଂଙ୍କ୍ ୱେରନ୍ ବୁକେତାଗ୍ ଚାପୁଡ଼ା ରେହେତିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡ ଅଙ୍କ୍‌ ବୁକା ତହସିମୁଟ୍; ମେଣ୍ଡେ, ବେନ ମିଇ ଡୁପଟ୍ ହଦ୍‍ତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ମିଇ ଚକା ମିକା ଆଦାଙ୍କ୍ ମନା ମାଡ଼ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ବେନ ମିକିଂଙ୍କ୍ ତାଆଲ୍‍କିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ହିମୁଟ୍; ମେଣ୍ଡେ ବେନ ମିଇ ସମ୍ପତ୍ତି ଆଦ୍‍ତଣ୍ଡ୍, ଅନାଗା କଞ୍ଜ୍ ଆଦ୍ ମେଣ୍ଡେ ତାଲ୍‍କ୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ନାରୁଡ଼୍ ମି ସେଙ୍ଗେ ବେଦ୍ ଲେକାମ୍ ବ୍ୟବହାର୍ ମାଡ଼ିଡ୍ ଇଞ୍ଜ ମିଡ଼୍ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍, ମିଡ଼୍ ଅଡ଼୍‌‍ ସେଙ୍ଗେ ଆଦ୍ ଲେକାମ୍ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ମେଣ୍ଡେ, ବେନଡ଼୍ ମିକିଂଙ୍କ୍ ପ୍ରେମ୍ ମାଡ଼ିତଡ଼୍, ମିଡ଼୍ ଯଦି ମାତର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପ୍ରେମ୍ ମାଡ଼କେ ମିଡ଼୍ କି ଅନୁଗ୍ରହ ପାଏମ୍‍ ଆଦ୍‍ତିଡ୍ ? ବାତେଙ୍କ୍ ଇତ୍କେ ପାପିଡ୍ ମିକା ନିଜେ ନିଜେ ପ୍ରେମ୍‍କାରୀନଡ଼କ୍ ପ୍ରେମ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ମେଣ୍ଡେ, ବେଏନଡ୍ ମିକିଂଙ୍କ୍ ଲେକେତ୍ ମାଡ଼ିତଡ଼୍, ଯଦି ମିଡ଼୍ ମାତର୍‍ ଅଡ଼୍‌‍ୱାଦ୍ ଲେକେତ୍ ମାଡ଼ିତିଡ଼୍, ଆସୁଣ୍ଟ୍ ମିଡ଼୍ କି ଅନୁଗ୍ରହ ପାଏମ୍‍ ଆଦ୍‍ତିଡ୍ ? ବାତେଙ୍କ୍ ଇତ୍କେ ପାପିଡ୍ ମିକା ଆଲାମାଡ଼ୁତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ମେଣ୍ଡେ, ବେନଡ଼ାଗା କନ୍‍ସ୍ ମିଡ଼୍ ଆଦାନ୍ ଆଶେ ମାନ୍‍ତେ, ମାତର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଋଣ୍‍ ଇତ୍‍କେ ମିଡ଼୍ କି ଅନୁଗ୍ରହ ପାଏମ୍‍ ଆଦ୍‍ତିଡ଼୍ ? ପାପିଡ୍ ମିକା ସମାନ୍ କାମ୍‍ ମାଡ଼୍‍ତେ କାୟେତେ ଆଦାନ୍ ସେଙ୍ଗେ ପାପିନଡ଼କ୍ ଉଦାର୍ ହିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ମାତର୍ ମିଇ ଶତ୍ରୁନଡ଼୍‍କ୍ ପ୍ରେମ୍ ମାଡ଼ାଟ୍ ନୁ ଅଡ଼ାଦ୍‌ ଲେକେତ୍ ମାଡ଼ାଟ୍, ମେଣ୍ଡେ ପରିଶୋଦତେ ଆଶେ ୱାଟକଟ ଋଣ୍‍ ହିମୁଟ୍; ଆଲାତ୍କେ ମି ପୁରସ୍କାର୍ ବେଡ଼୍‍ୟାଦ୍‍ ଆଦ୍‍ତେ ନୁ ମିଡ଼୍ ସତ୍‍ଇଶ୍ୱର୍‍ ତେ ମାର୍‍ ଆଦ୍‍ତିଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବେନ ଦର୍‍କ୍‍ତା ପେର୍‍କେ ମିକା ଉପକାର୍ ପୁନଣ୍ଡ୍ ଆଦ୍ ରକମ୍ ନାରୁଡ଼୍ ନୁ ଦୁଷ୍ଟ ନାରୁଡ଼୍‍ତେ ସେଙ୍ଗେ ମିକା କୃପାବାନ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ମି ବାବାଲ୍ ବେଦ୍ ରକମ୍ ଦୟାତନ୍, ମିଡ଼୍ ଆଦ୍ ପୁଟୁଙ୍କ୍ ଦୟାତନ୍ ଆୟ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ମେଣ୍ଡେ, ବିଚାର୍ ମାଡ଼ମାଟ୍, ଆଲାତ୍କେ ଇଶ୍ୱର୍‌ ମିକିଂଙ୍କ୍ ବିଚାର୍ ମାଡ଼ଣ୍ଡ୍; ଦଷ୍ ହିମାଟ୍, ଆଲାତ୍କେ ଇଶ୍ୱର୍‌ ମିକିଂଙ୍କ୍ ଦଷି ମାଡ଼ଣ୍ଡ୍ । କ୍ଷମା ମାଡ଼ାଟ୍, ଆଲାତ୍କେ ଇଶ୍ୱର୍‌ ମିକିଂଙ୍କ୍ କ୍ଷମା ମାଡ଼ିତନ୍; ");
INSERT INTO kff_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ଦାନ ମାଡ଼ାଟ୍, ଆଲାତ୍କେ ଇଶ୍ୱର୍ ମିକିଂଙ୍କ୍ ଦାନ ହିଦ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ବଡ୍‍ତିଙ୍କ୍ ସାରେ ମାଡ଼ି ତାଙ୍କ୍ ଆଦ୍‍ମି ମାୟିନା ମିକିଂଙ୍କ୍ ହିଦ୍‍ତଣ୍ଡ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ବେନେ କଲ୍‍ସାନାଦିନ୍ ତଡ଼୍‌ କଲସିତିଡ୍, ଆଦ୍ କଲ୍‍ସାନାଦିନ୍ ତଡ଼୍‌ ଇଶ୍ୱର୍‌ ମିକିଂଙ୍କ୍ ମେଣ୍ଡେ କଲ୍‍ସି ହିଦ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେରନ୍ ୱେଷଡ଼୍ ମିକା କେତ୍ତଣ୍ଡ୍, “କାନାଲ୍ କି କାନାଙ୍କ୍ ହାର୍ ତଅତ୍‍ତେ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ ? ଯଦି ଅଣ୍ଡ୍‌ ଆଲାମାଡ଼ିତଣ୍ଡ୍ ଅଡ଼୍‌‍ କି ଇଡ଼୍‍ୱୁଡ଼୍‍ ଗୁଇନ୍ଦେ ତାଗ୍ ରାୟଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୁ ତାଗାଙ୍କ୍‌ ଶିଷ୍ୟ ଯଗ୍ୟ ଆୟ୍‍ୟଣ୍ଡ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ସାରେ ଶିଷ୍ୟ ଶିକ୍ଷା ଶେଷ୍ ମାଡ଼କେ ଗୁରୁନ୍‍ ଲେକାମ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ମେଣ୍ଡେ, ବାତେଙ୍କ୍ ନି ତାମୁଣ୍ଡ୍‌ ତେ କଣ୍ଡେତାଗ୍ ମାନ୍ଦାନ୍ ଇଡ଼୍‍ପେତିଙ୍କ୍ ଉଡ଼ୁତି, ବାତେଙ୍କ୍ ଇତ୍କେ ନି ନିଜେ କଣ୍ଡେତାଗ୍ ବେନେ ଜିଟ୍‍କେ ମିନ୍ଦେ, ଆଦ୍ ହାଲ୍‍ସି ଉଡ଼୍‍ୱିନ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ନିମେ ନିଜେ କଣ୍ଡେତାଗ୍ ମାନ୍ଦାନ୍ ଜିର୍‍କେତିଙ୍କ୍ ଉଡ଼କଟ ବେଲା ନିଜେ ତାମୁଣ୍ଡ୍‌ତିଙ୍କ୍ କେତ୍‍ତେ ପାର୍‍ଦ୍‍ତି, ତାମୁନ୍, ୱାଡେ, ନି କଣ୍ଡେତାଗ୍ ମାନ୍ଦାନ୍ ଇଡ଼୍‍ପେତିଙ୍କ୍ ପେସ୍‍ପି ହିଦ୍‍ତାନ୍ ? ହୋ ଟେମ୍‌ପରି, ମୁନେନ୍ ନିଜେ କଣ୍ଡେତାଦ୍ ଜିଟ୍‍କେ ପେସ୍‍ପେ ପାର୍‍ୱନ୍, ତାନ୍ ପେର୍‍କେ ନିଜେ ତାମୁସ୍ ତେ କଣ୍ଡେତାଗ୍ ମାନ୍ଦାନ୍ ଇଡ଼୍‍ପେତିଙ୍କ୍ ପେସ୍‍ପାନ୍ ସେଙ୍ଗେ ସହଜ୍‍ତେ ଉଡ଼େପାର୍‍ଦ୍‍ତି । ");
INSERT INTO kff_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ସାଏତ୍ ମାଡ଼େତାଗ୍ କାରାପ୍ କାୟା ଆଦ କାରାପ୍ ମାଡ଼େତାଗ୍ ସାଏତ୍ କାୟା ଆଦ ।” ");
INSERT INTO kff_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ବାତେଙ୍କ୍ ଇତ୍କେ ସାରେ ମାଡ଼ାକ୍ ନିଜେ କାୟାନ୍ ତଡ଼୍ ପୁନ୍ଦାଙ୍କ୍ ଆଦ୍‍ତେ; କୟେ ମାଡ଼ାକିନାଗେ କଞ୍ଜ୍ ତ ନାରୁଡ଼୍ ତୋୟା କୟୋଡ୍, ବା କୟେ ଟଣ୍ଡେତ୍ କଞ୍ଜ୍ ଅଙ୍ଗୁର୍‌ କୟୋଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ସାୟେତ୍ ନାରୁଡ଼୍ ତାନ୍ ହୃଦୟ୍ ଲେକେତ୍‍ ସାଏତ୍ ଗୁଦାମ୍‌ତେ କଞ୍ଜ୍ ସାଏତ୍ ଜିନିଷ୍ ପେସ୍‍ପିତଣ୍ଡ୍, ମେଣ୍ଡେ, କାରାପ୍ ନାରୁଡ଼୍ କାରାପ୍ ଗୁଦାମ୍‌ତେ କଞ୍ଜ୍ କାରାପ୍ ଜିନିଷ୍ ପେସ୍‍ପିତଣ୍ଡ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ହୃଦୟ୍ ତେ ସାରେତେ କଞ୍ଜ୍ ପାୟୁର୍ ତିରିୟିତେ । ");
INSERT INTO kff_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ମେଣ୍ଡେ, “ମିଡ଼୍ ବାତେଙ୍କ୍ ନାକିଂଙ୍କ୍ ପ୍ରବୁ ଇଞ୍ଜ କେତୁତିଡ଼୍‍, ମାତର୍ ନାୱାଦ୍ ବାକ୍ୟ ପାଲନ୍ ମାଡ଼୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ବେନ ନା ଗାର୍‍ରେ ୱାସ୍ ନାୱାଦ୍ ଗଟ୍ କେଞ୍ଜି ଆୱୁସାରେ ପାଲନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବେନନ୍ ରକମ୍ ଆଦ୍‍ତନ୍, ଆଦ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ଅଣ୍ଡ୍‌ ଇଦ୍ ରକମ୍ ୱେର୍‍ଣ୍ଡ୍ ଲୋନ୍‌ ତିଆର୍ ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ତେ ରକମ୍, ବେନ କୁଇଙ୍ଗ୍ ଡେୱି ଗନ୍ଦ କାଲ୍‍କିନ୍ ପରୁ ୱାଟ୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ, ବନ୍ୟା ଆତ୍‍କେ, ଏର୍‍ ଆଦ୍ ଲତ୍‍ତିଙ୍କ୍ ଗାଟି ଜର୍‍ଦେ ଦକ୍‍କା ରେହେତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ହୁଉତାନଙ୍କ୍ ପାର୍‍ୱ, ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ସାଏ ଲେକାମ୍ ତିଆର୍ ମାଡ଼ିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ବାତେଙ୍କ୍ ଇତ୍କେ ବେନ କେଞ୍ଜି ପାଲନ୍ ମାଡ଼ଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଗନ୍ଦ ୱାଟକଟ ମାଣ୍ଡୁଲ୍‍ତେ ପରୁ ଲୋନ୍‌ ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ତେ ରକମ୍; ଏର୍‍ ଆଦ୍ ଲନ୍‍ତିଙ୍କ୍ ଗାଟି ଜର୍‍ତେ ଦକ୍‍କା ରେହେତ୍‍କେ, ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଦ୍ ଉରୁଙ୍ଗିତେ ନୁ ଆଦିନାଦ୍ ଦଂସ ବୟଙ୍କାର୍ ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜିସୁ ନାରୁଡ଼୍‍କ୍ ତାନ୍‍ୱାଦ୍ ସାରେ ଗଟ୍ କେତାନାଦ୍ ତେର୍‍ସ୍‍ପି କଫର୍ନାହୁମ୍‍ ଟାୱୁନ୍‍ତାଗେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ଆଦ୍ ଦିନାମ୍‍ତେ ୱେର୍‍ଣ୍ଡ୍ ଶତସେନାପତିତେ ଦାସ୍ ରଗାମ୍ ଆସ୍ ଡଲାନ୍ ରକମ୍ ଆସ୍‍ମାତ୍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ତାନୱେ ପ୍ରିୟଦାସ, ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ଅଣ୍ଡ୍‌ ଜିସୁନ୍ ବିଷୟତେ କାବୁର୍ ଆସ୍, ଅଣ୍ଡ୍‌ ବେଲା ୱାସ୍ ତାନ୍ ଦାସତେ ଜିୱେ ରକ୍ଷା ମାଡ଼ତଣ୍ଡ୍, ଇଦିନ୍ ସେଙ୍ଗେ ଅନ୍‌ ଗାର୍‍ରେ ଯିହୁଦୀଡ଼୍ ଲୋପେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ମୁକ୍ୟା ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରହସ୍ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌‍ ମାଡ଼ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ଅଡ଼୍‌‍ ଜିସୁନ୍ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଅଂକିଙ୍କ୍‌ ନିଜାମ୍ ବିନତି ମାଡ଼ି କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ନିୱାଦ୍ ସାହାଯ୍ୟ ଆଦାନ୍ ସେଙ୍ଗେ ଯୋଗ୍ୟ ଆଦ୍‍ତନ୍; ");
INSERT INTO kff_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ମାନ୍‍ ଜାତିତିଙ୍କ୍ ପ୍ରେମ୍ ମାଡ଼ୁତଣ୍ଡ୍ ନୁ ଅଣ୍ଡ୍‌ ନିଜେ ମାନ୍‍ ସେଙ୍ଗେ ସମାଜ୍‍ଲନ୍ ତିଆର୍ ମାଡ଼ିସ୍ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ଆଗେଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍ ତଡ଼୍ ଆତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଲୋତ୍‍ତେ ସୁଦୁର୍ ଦୁରାମ୍ ହେୱତାୱେୟେ, ଶତସେନାପତି ସାଙ୍ଗଡ଼କ୍ ରହସ୍ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ପ୍ରବୁ କଷ୍ଟ ମାଡ଼୍‍ମାଟ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ନିମ୍‍ ଯେ ନା ଲନ୍ ଡେକେ ୱାଟିତି, ନାନ୍ ଇଦ୍ ରକମ୍ ଯୋଗ୍ୟ ଆୟ୍‍ୟ; ");
INSERT INTO kff_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ତ ନାନ୍ ନି ଗାର୍‍ରେ ଆଦାଙ୍କ୍ ନିଜେତିଙ୍କ୍ ଯୋଗ୍ୟ ହେର୍କେ ମାଡ଼ନ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ୱେରନ୍ ପଦ୍ ଗଟ୍ ମାଡ଼ା, ନା ଦାସ ସୁସ୍ଥ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ୱେରନ୍ ଅଦିନତେ ମାତ୍‍କେ ମିକା ନା ଆଦିନ୍ ତେ ସୈନିଡ଼୍ ମିନ୍ଦେଡ଼୍; ମେଣ୍ଡେ, ନାନ୍ ଅର୍‌ତୁଙ୍କ୍ ଆନ୍‌ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଆଦ୍‍ତନ୍; ଅର୍‌ତୁଙ୍କ୍ ୱାଡ଼ା ଇତ୍କେ ଅଣ୍ଡ୍‌ ୱାଦ୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ ନା ଦାସଙ୍କ୍ ଇଦ୍ ମାଡ଼ା ଇତ୍କେ ଅଣ୍ଡ୍‌ ଆଦ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜିସୁ ଇଦ୍ ସାରେ ଗଟ୍ କେଞ୍ଜି ବାକ୍‍ୱା ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ତିଡ଼ିୟି ମିକା ପେର୍‍କେ ୱାସ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଇସ୍ରାଏଲ୍ ଲୋପେ ଇସ ବାଡ଼ିୟାଦ୍ ବିଶ୍ୱାସ୍ ଦର୍‍ସ୍‍କନ୍ !” ");
INSERT INTO kff_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ମେଣ୍ଡେ, ରହତେ ନାରୁଡ଼୍ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ୱାସ୍ ଦାସଙ୍କ୍ ସୁସ୍ଥ ଉଡ଼୍‌ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ଇଗେଙ୍କ୍ ଜିସୁ ନାଇନ ପେଦେର୍‍ତେ ନଗର୍‍ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଅନ୍‌‍ୱେ ଶିଷ୍ୟଡ଼୍ ନୁ ନାର୍ଗେ ନାରୁଡ଼୍ ଅନ୍‌ ତଡ଼୍ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ଅଣ୍ଡ୍‌ ନଗର୍‍ତେ ହାର୍ ତାଗ୍ ହେୱତେ ୱେଲେ, ଉଡାଟ୍, ନାରୁଡ଼୍ ୱେର୍‍ଣ୍ଡ୍ ଡୋଲତେ ନାରୁଙ୍କ୍ ବାଇଦେ କାଞ୍ଜି ତାସ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ତାମ୍ ୟାୟଙ୍କ୍ ୱେରନ୍ ମାର୍‍, ମେଣ୍ଡେ ଆଦ୍ ନାଟାଡ଼୍ ରାଣ୍ଡିଲ୍; ମେଣ୍ଡେ ନାର୍ ତେ ନାର୍ଗେ ନାରୁଡ଼୍ ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ଆଦିଙ୍କ୍ ଉଡ଼ି ପ୍ରବୁ ତାନ୍ ସେଙ୍ଗେ ଦୟାତେ ଦାନ୍ଦେ ଆସ୍ ଆଦିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “କେୟିମା ।” ");
INSERT INTO kff_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଡଲୋତିଙ୍କ୍ ହିଟ୍‍ତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ, କାଞ୍ଜ୍‍ତେନଡ଼୍ ନିତ୍‍ତଡ଼୍, ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ପେକାଲ୍, ନାନ୍ ନିକିଂଙ୍କ୍ କେତୁତାନ୍, ତେଦ୍‍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ଆଗେତିନ୍‍ସ୍ ଡୋଲତେ ନାରୁଡ଼୍ ତେଦି କୁଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଗଟ୍ ତିରିୟାଙ୍କ୍ ପସ୍‍ପିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଜିସୁ ଅଂକିଙ୍କ୍‌ ତାମ୍ ୟାୟଙ୍କ୍ କାଇଦେ ପସ୍‍ପିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ଇଗେତିସ୍‍ନ୍‍ ସାରେତଡ଼୍ ୱେର୍‍ତଡ଼୍, ମେଣ୍ଡେ ଇଶ୍ୱର୍‌ତେ ମହିମା କୀର୍ତ୍ତନ୍ ମାଡ଼ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, “ମାନ୍‍ ଲୋପେ ୱେର୍‍ଣ୍ଡ୍ ବାଡ଼ିୟଣ୍ଡ୍ ବାବବାଦୀ ୱାସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ନୁ ଇଶ୍ୱର୍ ତାମ୍ ନାରୁଡ଼୍‍କ୍ ଉଦାର୍ ମାଡ଼ାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ମେଣ୍ଡେ, ଜିସୁନ୍ ବିଷୟତେ ଇଦ୍ ଗଟ୍ ଯିହୁଦା ଦେଶ୍ ଏକାମ୍ ନୁ ସାରେ ପାକା ସାରେ ପଡ଼ିୟେତାଗ୍ ପ୍ରଚାର୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ପେର୍‍କେ ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟଡ଼୍ ଇଦ୍ ସାରେ ବିଷୟ୍ ଯୋହନ୍‌‌ତିଙ୍କ୍ କେତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ଆଗେ ଯୋହନ୍‌ ତାମ୍ ଶିଷ୍ୟଡ଼ତେ ଲୋପେ ଇର୍‌ୱୁଡ଼୍‌କିଙ୍କ୍ ଗାର୍‍ରେ କାର୍‍ଙ୍ଗି ପ୍ରବୁନ୍ ଗାର୍‍ରେ ଇଲା କେସ୍ ରହତଣ୍ଡ୍, “ବେନନାଦ୍ ଆଗମନ୍ ଆଦ୍‍ତେ, ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍ କି ନିମେ, କି ମାମ୍ ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେପି ମାନ୍‍ତମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ଆଦ୍ ନାରୁଡ଼୍ ଜିସୁ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଡ଼୍‍, “ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ମାକିଂଙ୍କ୍ ନି ଗାର୍‍ରେ ଇଲା କେସ୍ ରହତଣ୍ଡ୍, ବେନନାଦ୍ ୱାଦାନାଦ୍ ଆଦ୍‍ତେ, ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍ କି ନିମେ, କି ମାମ୍ ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେପିତମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ଆସୁଣ୍ଟ୍ ଜିସୁ ନାର୍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରୋଗ୍, ତିପାଲ୍‍ ନୁ ଦୁଷ୍ଟ ଆତ୍ମା କଞ୍ଜ୍ ସାଏ ମାଡ଼ତଣ୍ଡ୍, ମେଣ୍ଡେ ନାର୍ଗେ କାନାଲଡ଼କ୍ ଉଡ଼ାନାଦ୍ ଶକ୍ତି ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ଆଞ୍ଜ୍ ବାତା ଉଡ଼୍‍ତିଡ଼୍‍ ନୁ କେଞ୍ଜ୍‍ତିଡ଼୍‍, ଆଦ୍ ସାରେ ଯୋହନ୍‌ତିଙ୍କ୍ କେଲାଟ୍; କାନାଲଡ୍ ଉଡ଼ାଙ୍କ୍ ପାର୍‍ଦ୍‍ତଡ଼୍, କୁଟାଲଡ଼୍‍ ତାଆକାଂଙ୍କ୍ ପାର୍‍ଦ୍‍ତଡ଼୍, କୁଷ୍ଠୀ ନାରୁଡ଼୍ ସୁସ୍ଥ ଅଦୁତଡ୍, ବାୟିରାଲଡ୍ କେଞ୍ଜାଙ୍କ୍ ପାର୍‍ଦ୍‍ତଡ଼୍, ଡୋଲତେ ନଡ୍ ଜିୱେ ଆଦ୍‍ତଡ଼୍, ଦରିଦ୍ରଡ଼୍‍ ଗାର୍‍ରେ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼ୁତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ମେଣ୍ଡେ, ବେନେ ନାରୁଣ୍ଡ୍‍ ନାକିଂଙ୍କ୍ ବାଦା ଇୱଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ଦନ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟଡ଼୍ ଆତ୍‍ତେ ପେର୍‍କେ ଜିସୁ ଯୋହନ୍‌‌ତେ ବିଷୟ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ବାତେଏ ଉଡ଼ାନ୍ ସେଙ୍ଗେ ଉସ୍କ ନେଲ୍‍ଦା ପେଇସ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତିଡ୍ ? ବାଆତେ ଗାଲ୍‍ଦେ ଉଙ୍ଗାନାଦ୍ ୱେରଟ୍ ୱେଦୁର୍ ? ");
INSERT INTO kff_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ଆଦ୍ ଆୟୋକ୍ ମିଡ଼୍ ବାତେଏ ଉଡ଼ାନ୍ ସେଙ୍ଗେ ପେଇସ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତିଡ୍ ? ବେନଙ୍କ୍ ଦାମ୍‍ଦେ ସିଲେ କେର୍ ତେ ଅର୍‌ତୁଣ୍ଡ୍ ନାରୁଙ୍କ୍ ? ଉଡ଼ାଟ୍, ବେନଡ଼୍ ଦାମ୍‍ଦାଉ ସିଲେ କେର୍‍ତିତଡ଼୍, ଅଡ଼୍‌‍ ରାଜ ପ୍ରସାଦତାଗ୍ ମାନ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ନାକିଂଙ୍କ୍ କେଲ୍‍ମ୍, ଆଦ୍ ଆୟୋକ୍ ବାତେଏ ଉଡ଼ାନ୍ ସେଙ୍ଗେ ପେଇସ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତିଡ୍ ? ବେନଙ୍କ୍ ଅର୍‌ତୁଣ୍ଡ୍ ବାବବାଦୀଙ୍କ୍ ? ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍ କେତୁତାନ୍, ବାବବାଦୀନ୍ କଞ୍ଜ୍ ଗାଟି ବାଡ଼ିୟଣ୍ଡ୍ ନାରୁଙ୍କ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଯୋହନ୍‌‌ତେ ବିଷୟତେ ଇଦ୍ ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ଇଶ୍ୱର୍‌ କେତ୍‍ତଣ୍ଡ୍, ଉଡ଼ାଟ୍, ମାମ୍ ମା ଦୂତ୍‍ତିଙ୍କ୍ ମି ମୁନେ ରହତୁତମ୍, ଅଣ୍ଡ୍‌ ମି ମୁନେ ମିୱାଦ୍ ହାର୍ ତିଆର୍ ମାଡ଼ିତନ୍, ଇଣ୍ଡ୍ ଆଦ୍ ନାରୁଡ଼୍ ଯୋହନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, “ନାଟାଡ଼୍ ତାଗାଙ୍କ୍‍ ଜନମ୍ ସାରେତଡ଼୍ ଲୋପେ ଯୋହନ୍‌‌ତେ କଞ୍ଜ୍ ମହାନ୍ ବେନ ଇଲାଣ୍ଡ୍; ମିକା ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗ୍ ଯେ ସୁଦୁନଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଯୋହନ୍‌ କନ୍‍ସ୍ ମିକା ମହାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ବେନଡ଼୍ ଇଦ୍ ସାରେ ଗଟ୍ କେଞ୍ଜ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍, ବିସ୍ୱାଶ୍‍ତଡ଼୍‍ କର ଆଦାୟ ମାଡ଼ାନଡ଼ି, ଇଶ୍ୱର୍‌ତେ ନିଜାମ୍ ଦାବୀ ସାରେ ମାଡ଼ି ଯୋହନ୍‌‌ତେ ତଡ଼୍ ବାତିସ୍ମ ଇସ୍‌‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ବାତେଙ୍କ୍ ଇତ୍କେ ପାରୂଶୀଡ଼୍ ନୁ ଦର୍ମଗୁରୁଡ୍ ତାମ୍ ଜିୱୁଣ୍ଡ୍ ତେ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତେ ଉଦ୍ଦେଶ୍ୟ ଗ୍ରହନ୍ ମାଡ଼କଟ୍ ଯୋହନ୍‌‌ତେ କନ୍‍ସ୍ ବାତିସ୍ମ ଆ‍ୟୱେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଜିସୁ ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍, “ଇ ଯୁଗ୍‍ତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନାନ୍ ବେନନ୍ ତଡ଼୍ ସାମାନ୍ ମାଡ଼ିତାନ୍, ମେଣ୍ଡେ ଅଡ଼୍‌‍ ବେନନ୍ ରକମ୍ ଆଦ୍‍ତଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ବେନେ ପିଲା ହାଟ୍ ବାଜାର୍‍ତାଗ୍ କୁଦି କାର୍‍ଙ୍ଗା କାର୍‍ଙ୍ଗି ହାସ୍ କେତିତଡ଼୍‍, ମାମ୍ ମି ବକେତ୍ ଅଷଡ଼୍‍ ଉଦ୍‍ତନ୍, ମିଡ଼୍ ହେନ୍ଦୱିଡ୍; ମାମ୍ ଡୋଲତେ ପାଟେ ପାର୍‍ତମ୍, ମିଡ଼୍ କେୟିୱିଡ଼୍‍, ଅଡ଼୍‌‍ ଆଦ୍ ପିଲାନ୍ ଲେକାମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ବାତେଙ୍କ୍ ଇତ୍କେ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ୱାସ୍ ରୋଟି ତିନଣ୍ଡ୍ ନୁ ଦ୍ରାକ୍ଷାରସ୍ ଉନଣ୍ଡ୍, ମେଣ୍ଡେ ମିଡ଼୍ ଯୋହନ୍‌‌ତେ ବିଷୟତେ କେତ୍‍ତିଡ଼୍, ଅଂକିଙ୍କ୍‌ ବୁତ୍ ପୟିତେ । ");
INSERT INTO kff_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ନାରୁନ୍‍ପିଲେ ୱାସ୍ ତିନ୍ତେ, ମେଣ୍ଡେ, ମିଡ଼୍ କେତୁତିଡ଼୍‍, ଉଡ଼ାଟ୍, ଇଣ୍ଡ୍ ଅରତୁଣ୍ଡ୍ ପେଟୁ ନୁ ମାତ୍‍ୱାରି, କରଗ୍ରାହୀ ନୁ ପାପି ନାରୁଡ଼୍‍ତେ ସାଙ୍ଗ । ");
INSERT INTO kff_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ବେନଡ଼୍ ଇଶ୍ୱର୍‌ତେ ଜ୍ଞାନତିଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତଡ଼୍, ଅଡ଼୍‌‍ ଜିୱୁଣ୍ଡ୍ ତାଗ୍ ଅନାଦ୍‌ ସତ୍‍ତେ ତନ୍ଦିତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ମେଣ୍ଡେ, ପାରୂଶୀଡ଼୍ ଲୋପେ ୱେର୍‍ଣ୍ଡ୍ ଜିସୁଙ୍କ୍ ତାନ୍ ତଡ଼୍ ତିନ୍ଦାନଙ୍କ୍ କାରଙ୍ଗ୍‍ତଣ୍ଡ୍ । ଆଗେ ଅଣ୍ଡ୍‌ ପାରୂଶୀନଡ଼୍ ଲୋନ୍‌ ଆସି ତିନ୍ଦାନଙ୍କ୍ କୁଦ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଆଦ୍ ନାର୍ ତାଗ୍ ଅରଟ୍ ପାପି ନାଟାଡ଼୍ ମାତ୍‍ତେ; ଜିସୁ ଆଦ୍ ପାରୂଶୀନ୍ ଲୋନ୍‌ ତିନ୍ଦାନଙ୍କ୍ କୁଦିମିନ୍ଦେଣ୍ଡ୍, ଇଦ୍ ପୁଞ୍ଜ୍ ଆଦ୍ ୱେରନ୍ ଦାମ୍‍ତାଦ୍ ବତଲ୍‍ତାଗ୍ ଲେକେତ୍ ଗାବ୍‍ତେ ନିୟି ତାସ୍, ");
INSERT INTO kff_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ପେର୍‍କେ ଜିସୁନ୍ ଲାବ୍ ଡେକେତ୍ ଗାର୍‍ରେ ନିଶ୍‍ମିକା କେୟକେୟ କାଣ୍ଡେଡି ଏର୍‍ଦେ ଅନାଦ୍‌ ଲାବ୍ ଡେକେତିଙ୍କ୍ ନାଆସ୍‍ପି ନିଜର୍ ତାଲେତ୍ କେଲ୍‍କିନ୍ ତଡ଼୍ ଆଦ୍ ଉମ୍‍ସାନଙ୍କ୍ ପସ୍‍ପିତ୍‍ତେ, ମେଣ୍ଡେ ଅନ୍‌‍ୱେ ଲାବ୍ ଡେକେତିଙ୍କ୍ ଚୁମା ମାଡ଼ି ସାୟେ ଗାବ୍‍ତେ ନିୟ୍‍ ଅକାନଙ୍କ୍ ପସ୍ପ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ଆଦ୍ ଉଡ଼ି, ବେନେ ଫାରୂଶୀ ଅଂକିଙ୍କ୍‌ ନିମନ୍ତ୍ରଣ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ହେର୍କେତ୍‍ କେତ୍ତଣ୍ଡ୍, “ଇଣ୍ଡ୍ ଯଦି ବାବବାଦୀ ଆସ୍ ମାନେଣ୍ଡ୍, ଆଲାତ୍କେ ହିକିଂଙ୍କ୍ ହିଟୁତ୍, ଆଦ୍ ବାତେଏ ନୁ ବେସତ୍ ନାଟାଡ଼୍, ଇତ୍‍କେ, ଆଦ୍ ଯେ ପାପି, ଇଦ୍ ପୁଞ୍ଜ୍ ମାନେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଶିମୋନ୍, ନିକିଂଙ୍କ୍ ନାନ୍ ଅଣ୍ଡ୍‌ ଗଟ୍ କେତ୍‍ତାନ୍ ମିନ୍ଦେ ।” ଅଣ୍ଡ୍‌ କେତ୍ତଣ୍ଡ୍, “ଗୁରୁ କେଲ୍‍ମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“ୱେର୍‍ଣ୍ଡ୍ ସାଉକାର୍‍ତେ କନ୍‍ସ୍ ଇଡ଼ିୱୁଡ଼୍‍ ଋଣ୍‍ ହସ୍‍ମାତ୍‍ତଡ୍; ଅର୍‌ତୁଣ୍ଡ୍ ପାଞ୍ଚଶହ ଦିନାରୀ ନୁ ମେଣ୍ଡେ ଅର୍‌ତୁଣ୍ଡ୍ ପାଚାଶ୍ ଦିନାରୀ ଋଣ୍‍ ମାଡ଼ିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ମାଲ୍‍ପିଦାଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାତେଏ ଇଲ୍‍ୱାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଡ଼୍‍ୱୁଡ଼ାଦ୍ ଉଦାର୍ ୱିଡ଼୍‍ସିଦ୍‍ତନ୍ । ତ ଅଡ଼୍‌‍ ଲୋପେ ବେନ ଅଂକିଙ୍କ୍‌ ଗାଟି ପ୍ରେମ୍ ମାଡ଼ିତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ଶିମୋନ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ହାଲ୍‍ସୁତାନ୍, ଅଣ୍ଡ୍‌ ବେନନାଦ୍ ଗାଟି ଉଦାର୍ ୱିଡ଼୍‍ସ୍‍ଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ।” ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ନିମେ ଟିକ୍ କେତ୍‍ତି ।” ");
INSERT INTO kff_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ମେଣ୍ଡେ, ଜିସୁ ଆଦ୍ ନାଟାଡ଼୍ ସେଙ୍ଗେ ତିଡ଼ିୟି ଶିମୋନ୍‍ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଇଦ୍ ନାଟାଡ଼୍‍ତିଙ୍କ୍ ଉଡ଼ୁତି ? ନାନ୍ ମି ଲୋନ୍‌ ୱାତ୍‍ତାନ୍, ନିମେ ନା ଡେକେତ୍ ସେଙ୍ଗେ ଏର୍‍ ଇୱିନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦ୍ କାଣ୍ଡେଡ୍ ଏର୍‍ ତଡ଼୍ ନା ଡେକେ ନାଆସ୍ ମିକା ତାନ୍ କେଲ୍‍କିନ୍ ତଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉମ୍‍ସିତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ନିମେ ନାକିଂଙ୍କ୍ ଚୁମା ଇସ୍‌ କାରଙ୍ଗ୍‍ୱିନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ଲୋପେ ୱାଦାନ୍ ସମୟ୍ ତେ କନ୍‍ସ୍ ଇଦ୍ ନା ଡେକେତିଙ୍କ୍ ଚୁମା ହିଦୁତେ । ");
INSERT INTO kff_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ନିମେ ନା ତାଲେତାଗ୍ ନିୟ୍‍ ଉସିୱିନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦ୍ ନା ଡେକେତାଗ୍ ସାୟେ ଗାବ୍‍ତେ ନିୟି ଉସିତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ତ ନାନ୍ ନିକିଂଙ୍କ୍ କେତୁତାନ୍, ଇଦିନାଦ୍ ନାର୍ଗେ ପାପ୍ କ୍ଷମା ହାସ୍ ମିନ୍ଦେ, କାରନ୍‍ ଆଦ୍ ଗାଟି ପ୍ରେମ୍ ମାଡ଼ତ୍‍ତେ; ବାତେଙ୍କ୍ ଇତ୍କେ ବେନଙ୍କ୍ ସୁଦୁଟ୍ କ୍ଷମା ହିଦ୍‍ତଡ଼୍, ଅଣ୍ଡ୍‌ ସୁଦୁଟ୍ ପ୍ରେମ୍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ମେଣ୍ଡେ, ଜିସୁ ଆଦ୍ ନାଟାଡ଼୍ ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନିୱାଦ୍ ପାପ୍ ସାରେ କ୍ଷମା ହାସ୍‍ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ଆଗେ ଅନ୍‌ ତଡ଼୍ ତିନ୍ଦାନଙ୍କ୍ କୁଦିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ହେର୍କେତ୍‍ କେତାନଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ନାରୁଡ଼୍ ବେନ ଯେ ପାପ୍ ମିକା କ୍ଷମା ମାଡ଼ୁତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଆଦ୍ ନାଟାଡ଼୍‍ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନିୱାଦ୍ ବିଶ୍ୱାସ୍ ନିକିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼ିତେ; ଶାନ୍ତି ତେ ହାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ତାନ୍ ପେର୍‍କେ ଜିସୁ ନାର୍‍ନାର୍ ନୁ ସହର୍‍ତାଗ୍‍ କେସ୍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତେ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼ି ଉଡାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ବାର ଜାନ୍ ଶିଷ୍ୟଡ଼୍ ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ବେନେ ନାଟାଙ୍କ୍ ଜିସୁ ଦୁଷ୍ଟ ଆତ୍ମା ନୁ ରୋଗ୍ କଞ୍ଜ୍ ସୁସ୍ଥ ମାଡ଼ିମାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ବେସ୍‌କ୍ ନାଟା ଅନ୍‌ ତଡ଼୍ ଆଞ୍ଜମାତ୍‍ତା, ଇଦ୍ ରକମ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାଟା, ଇତ୍‍କେ, ମଗ୍‍ଦଲୀନି ପେଦେର୍ ତେ ମରୀୟମ୍, ବେନ ନାଗାଙ୍କ୍ ସାତ୍‍ଟାନ୍ ବୁତ୍‌କ୍ ପେଇସ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ହେରୋଦତେ ବେବର୍ତ୍ତା କୁଜାନ୍ ମୁତ୍‍ତେ ଯୋହନ୍‌, ଶୋଶନ୍‍ନା, ମେଣ୍ଡେ ନାର୍ଗେ ନାଟା ଅନ୍‌ ତଡ଼୍ ମାଞ୍ଜ୍ ନିଜର୍ ସମ୍ପତ୍ତି ଇସ୍‌ ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟଡ଼କ୍ ସେବା ମାଡ଼ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ନାର୍ଗେ ନାରୁଡ଼୍ ୱାସ୍ ଗୁଡ଼୍‍ତଡ୍ ନୁ ନାର୍ କଞ୍ଜ୍ ନାରୁଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାତ୍‍ତାଙ୍କ୍, ଜିସୁ ଇଦ୍ ୱେଷଡ଼୍ କେତ୍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ୱେର୍‍ଣ୍ଡ୍ ୱିତାନଣ୍ଡ୍ ତାନ୍ ୱିଜ୍ ୱିତାନଙ୍କ୍ ପେଇତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ୱିତ ୱିତ ବେସ୍‌କ୍ ୱିଜ୍ ହାର୍‍ଦାକ୍ ରାୟତା ନୁ ଡେକେତ୍ ମଦଲ୍ ମିସିଆତ୍‍ତେ, ମେଣ୍ଡେ ମାବ୍‍ତାଗ୍ ପାର୍‍ତାନ୍‍ ପିଟେ ଆୱିଙ୍କ୍ ତିତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ମେଣ୍ଡେ ବେସ୍‌କ୍ କାଲକ୍ ମାନ୍ଦାନ୍ ନେଲ୍‍ତାଗ୍ ରାୟତା, ମେଣ୍ଡେ ଗାଜ୍‍ଜେ ଆସ୍ ଏର୍‍ ଇଲ୍‍ୱାଙ୍କ୍ ୱାସିଆତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ମେଣ୍ଡେ ବେସ୍‌କ୍ କୟେ ମାଡ଼ାକ୍ ଲୋପେ ରାୟତା, ମେଣ୍ଡେ କୟେ ମାଡ଼ାକ୍ ଆୱୁ ତଡ଼୍ ଗାଟି ପେର୍‍ସି ଆୱିଙ୍କ୍ ଆଦ୍‍ମିତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ମେଣ୍ଡେ ବେସ୍‌କ୍ ସାୟେତ୍ ନେଲ୍ ତାଗ୍ ରାୟତା, ମେଣ୍ଡେ ପେର୍‍ସି ଶହେ ଗୁଣ୍ କାୟା ଆଦ୍‍ତା ।” ଅଣ୍ଡ୍‌ ଇଲା କେସ୍ କେସ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍ତଣ୍ଡ୍, “ବେନଙ୍କ୍ କେଞ୍ଜାନଙ୍କ୍ କେୱ୍ ମିନ୍ଦେ, ଅଣ୍ଡ୍‌ କେଞ୍ଜାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ଜିସୁନ୍ ଶିଷ୍ୟଡ଼୍ ଇଦ୍ ୱେଷଡ଼୍‍ତେ ଇତ୍‍କେ ବାତେଏ ଇଞ୍ଜ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ଆଗେଙ୍କ୍ ଜିସୁ ଇତ୍‌ତନ୍‌, “ଇଶ୍ୱର୍ ତେ ମିଞ୍ଜି ମାନ୍ଦାନ୍‌ ବିଷୟ୍ ପୁନ୍ଦାନ୍ ସେଙ୍ଗେ ମିକିଂଙ୍କ୍ ବୁଦ୍‍ ଇସ୍‌‍ମିନ୍ଦେଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବାଗାତ୍ ନାରୁଡ଼୍‍କ୍ ୱେଷଡ଼୍ ତେ କେତିତଡ଼୍‍, ବେଦ୍ ରକମ୍ ଅଡ଼୍‌‍ ଉଡ଼ଉଡ଼ ନୁ କେଞ୍ଜ କେଞ୍ଜ କେଞ୍ଜଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ୱେଷଡ଼୍‍ତେ ଇତ୍‍କେ ଇଦ୍, ୱିଜ୍ ଇଶ୍ୱର୍ ତେ ବାକ୍ୟ, ");
INSERT INTO kff_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ମେଣ୍ଡେ ହାର୍ ଦେ ଗାରେତ୍ ୱିଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବୁଜାମାଡ଼ିତେ, ବେନଡ଼କ୍ ବାକ୍ୟ କେଞ୍ଜାନ୍ ପେର୍‍କେ ଶୟ୍‍ତାନ୍‍ ୱାସ୍, ବେଲା କି ଅଡ଼୍‌‍ ବିଶ୍ୱାସ୍ ମାଡ଼ି ପରିତ୍ରାଣ ଆୟୋଡ୍, ଇଦ୍ ସେଙ୍ଗେ ଅଡ଼ାଦ୍‌ ହୃଦୟ୍ କଞ୍ଜ୍ ବାକ୍ୟ ଡଙ୍ଗି ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ମେଣ୍ଡେ, କାଲ୍‍କିନ୍ ବୁମ୍‍ତେ ୱିଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବୁଜାମାଡ଼ିତେ, ବେନଡ଼୍, ବାକ୍ୟ କେଞ୍ଜି ୱେଡ଼୍‍କେତେ ଗ୍ରହନ୍ ମାଡ଼ିତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ୱାଦ୍ ମାଡ଼୍ ଲୋପେ ଇଲ୍‍ୱାଙ୍କ୍ ଅଡ଼୍‌‍ ସୁଦୁଟ୍ ସମୟ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍ ନୁ ପରିକ୍ଷାତ୍ ୱେଲେ ରାୟିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ମେଣ୍ଡେ, କୟେ ମାଡ଼ାକିନ୍ ଲୋପେ ରାୟିତା ୱିଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବୁଜାମାଡ଼ିତେ, ବେନଡ଼୍ ବାକ୍ୟ କେଞ୍ଜିତଡ଼୍ ମାତର୍ ସସାର୍‍ତେ ଚିନ୍ତେ, ଦନ୍ ନୁ ସୁକାମ୍‍ତେ ମୁଡ଼ୁନ୍ଦି ମିକା ବାଦ୍‍କଡ଼୍ ମୁଡ଼ୁନ୍ଦି ଆଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ସାୟେତ୍ କାୟା ତିୟାର୍‍ ମାଡ଼େ ପାର୍‍ୱଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ମେଣ୍ଡେ, ସାୟେତ୍ ନେଲ୍ ଦାଗ୍ ରାୟିତା ୱିଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବୁଜାମାଡ଼ିତେ, ବେନଡ଼୍ ଲେକେତ୍ ହୃଦୟ୍‍ତେ ବାକ୍ୟ କେଞ୍ଜି ଆଦ୍ ପଇସ୍ ନେହେତିତଡ଼୍ ନୁ ଶକ୍ତି ତଡ଼୍ ସାୟେତ୍ କାୟା ଆଦ୍‍ପିସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ବେନ କୁପିତିଙ୍କ୍ ନିଡ଼୍‍ସ୍‍ପି ବଡ୍ ଆଡ଼୍‌ଗି ମୁଶି ୱାଟଣ୍ଡ୍, ବା କାଟୁଲ୍ ତେ ମଦଲ୍ ୱାଟଣ୍ଡ୍, ମାତର୍ କୂପି ପରୁ ୱାଟିତଣ୍ଡ୍, ବେଲାକି ଆସାନଡ଼୍‍ ନାରୁଡ଼୍ ୱେସ୍ ତିଙ୍କ୍ ଉଡ଼େ ପାର୍‍ଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ବାତେଙ୍କ୍ ଇତ୍କେ ବାତେଏ ପ୍ରକାଶିତ୍ ଆୟ୍‍ୟ, ଇଦ୍ ରକମ୍ ମିଞ୍ଜି ମାନ୍ଦାନ୍‌ ବିଷୟ ବାତେଏ ଇଲ୍‍ଲେ, ବା ବାତେଏ କେସ୍ ମିକା ପ୍ରକାଶ୍ ଆୟ୍‍ୟ, ଇଦ୍ ରକମ୍ ମିଞ୍ଜିମାନ୍ଦାନାଦ୍ ବିଷୟ୍ ବାତେଏ ଇଲ୍‍ଲେ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ମେଣ୍ଡେ, “ବେଲା କେଞ୍ଜୁତିଡ଼୍‍, ଆଦ୍ ବିଷୟତେ ସେଙ୍ଗେ ସାବ୍‍ଦାନ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ବେନନାଗେ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ଗାଟି ହିଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ବେନନାଗେ ଇଲା, ଅଣ୍ଡ୍‌ ବାତେଏ ନିଜର୍ ଡ଼ାଦ୍ ମିନ୍ଦେ ଇଞ୍ଜ ହେର୍କେ ମାଡ଼ିତନ୍, ଆଦ୍ ମିକା ଅନାଗ୍‍କଞ୍ଚ୍‍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜିସୁନ୍ ୟାୟ ନୁ ତାମୁଣ୍ଡ୍‌କିଡ଼୍‍ ଅନ୍‌ ଗାର୍‍ରେ ୱାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଗାଟି ନାରୁଡ଼୍‍ତେ ସେଙ୍ଗେ ଅନ୍‌‍ତଡ଼୍ କାଲ୍‍ପେ ପାର୍‍ୱେମାତ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ଆଗେ ଅଂକିଙ୍କ୍‌ ୱେରଣ୍ଡ୍ ଇଦ୍ କବର୍ ହିତ୍‍ତଡ଼୍, “ମି ୟାୟ ନୁ ତାମୁଣ୍ଡ୍‌କିଡ଼୍‍ ନିକିଂଙ୍କ୍ ଉଡ଼ାନ୍ ସେଙ୍ଗେ ବାଇଦେ କେପ୍‌ତଡ଼୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବେନଡ଼୍ ଇଶ୍ୱର୍ ତେ ବାକ୍ୟ କେଞ୍ଜିତଡ଼୍‍ ନୁ ପାଲନ୍ ମାଡ଼ିତଡ଼୍, ଅଡ଼୍‌‍ ନା ୟାୟ ନୁ ତାମୁଣ୍ଡ୍‌କିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ଅନ୍‌‍ଦିନେ ଜିସୁ ନୁ ତାମ୍ ଶିଷ୍ୟଡ଼ତେ ୱେରଡ଼୍‌ ଓଡ଼େତାଗ୍ ତାର୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ୱାଡ଼ାଟ୍, ସାୱୁଡ଼େତେ ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ପାକେ ଆଦିକାଡ଼୍‍ ।” ଆସୁଣ୍ଟ୍ ଅଡ଼୍‌‍ ଓଡେତିଙ୍କ୍ କୁସ୍‍ପିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ଇତ୍କେ ଅଟାତ୍ ଅଡ଼୍‌‍ ଓଡେତିଙ୍କ୍ ଚାଲାମାଡ଼ି ଆଦାନ୍ ୱେଲେ ଜିସୁ ଉଞ୍ଜିମାତ୍‍ତଣ୍ଡ୍ । ଆସୁଣ୍ଟ୍ ଷାୱୁଡ଼େତାଗ୍ ତୁପାନ୍ ଆତ୍‍ତେ, ମେଣ୍ଡେ ଅଡ଼ାଦ୍‌ ଓଡ଼େତାଗ୍ ଏର୍‍ ନିଣ୍ଡାନଙ୍କ୍ ପସ୍‍ପିତ୍‍ତେ ନୁ ଅଡ଼୍‌‍ ବିପଦ୍ ତାଗ୍ ରାୟତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ଆସୁଣ୍ଟ୍ ଶିଷ୍ୟଡ଼୍ ଗାର୍‍ରେ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ତେଇସ୍ କେତ୍‍ତଡ଼୍‍, “ହୋ ଗୁରୁ, ହୋ ଗୁରୁ, ମାନାଡ଼୍ ଡଲ୍‌ତାଡ୍ ।” ଇଗେତିସ୍‍ନ୍‍ ଅଣ୍ଡ୍‌ ତେଦି ଗାଲ୍ ନୁ ବେଡ଼େୟାଦ୍ ତଲ୍‍କଡ଼୍‍ ତିଙ୍କ୍ ଦମକ୍ ହିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆୱ ସାରେ କଟଆସ୍ ଶାନ୍ତି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ମେଣ୍ଡେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ମିୱାଦ୍ ବିଶ୍ୱାସ୍ ବେଗେ ?” ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ୱେର୍‍ସ୍ ନୁ ବାକ୍‍ୱା ଆସ୍ ନିଜେନିଜେ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ଆଲାତ୍କେ ବେନ ଯେ, ଅଣ୍ଡ୍‌ ଗାଲ୍ ନୁ ଏର୍‍ଦିଙ୍କ୍ ମିକା ଗଟ୍ ହିତ୍‍କେ, ଆୱ ଅନ୍‌‍ୱାଦ୍ ଗଟ୍ କେଞ୍ଜିତା ।” ");
INSERT INTO kff_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ପେର୍‍କେ ଜିସୁ ନୁ ଶିଷ୍ୟଡ଼୍ ଗାଲିଲୀତେ ମୁନେତ୍ ପାକେ ଆପାକେ ଗରାଶୀୟନଡ଼୍‍ତେ ପଡ଼ିୟେତାଗ୍ ହେୱତ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ଅଣ୍ଡ୍‌ ଓଡେତ୍ କନ୍‍ସ୍ ପେଇସ୍ ଆଞ୍ଚିନାଗ୍‌ ଡିଗଡ଼େ, ଆଦ୍ ନାର୍‌ଦେ ୱେର୍‍ଣ୍ଡ୍ ବୁତ୍ ପଇତ୍‍ତେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ କାଇଲ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଗାଟି ଜେଲ୍ ହେଉନା ସିଲେ କେରୱକଟ ନୁ ଲୋନ୍‌ ମାନ୍‍ୱକଟ ୱିସ୍‍କିନାଗେ ମାଞ୍ଜ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ ଉଡ଼ି ଗାଟି କିଡ଼୍‍କି ଅନ୍‌‍ୱାଦ୍ ଡେକେତ୍ ମଦଲ୍ ରାଲି ଗାଟି ଲେଙ୍ଗେତେ କେତ୍ତଣ୍ଡ୍, “ହୋ ଇଶ୍ୱର୍ ତେ ମାର୍‍ ଜିସୁ, ନି ତଡ଼୍ ନାୱାଦ୍ ବାତେଏ ମିନ୍ଦେ ? ନାନ୍ ନିକିଂଙ୍କ୍ ଦନ୍ୟବାଦ୍ ମାଡ଼ୁତାନ୍, ନାକିଂଙ୍କ୍ କଷ୍ଟ ହିମା ।” ");
INSERT INTO kff_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଶୁଚି ଆତ୍ମାତିଙ୍କ୍ ଆଦ୍ ନାରୁଡ଼୍ ତେ କନ୍‍ସ୍ ପେଇସ୍ ଆଦାନ୍ ସେଙ୍ଗେ ଗଟ୍ ଇସ୍‌‍ମାତ୍‍ତଣ୍ଡ୍ । ଆଦ୍ ଆତ୍ମା ଗାଟିଦାମ୍ ଅଂକିଙ୍କ୍‌ ପଇସ୍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ କାଇତାଗ୍ ଇକ୍‌ଲେମ୍‍ ନୁ ଡେକେତାଗ୍ ବେଡ଼ି ତହସ୍ ନେହେସ୍ ମାତ୍‍ତଡ଼୍, ମାତର୍ ଅନ୍‌‍ୱାଦ୍ ବନ୍ଦନ୍ ସାରେ ଦେହେସ୍ ବୁତ୍ ଅଂକିଙ୍କ୍‌ ବେନ ଇଲ୍‌ୱେ ପଡ଼ିୟେତାଗ୍ ପଇସ୍ ହସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜିସୁ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନି ପେଦେର୍ ବାତେଏ ?” ଅଣ୍ଡ୍‌ କେତ୍ତଣ୍ଡ୍, ବାହିନୀ; “ନାର୍ଗେ ବୁତ୍‌କ୍;” ବାତେଙ୍କ୍ ଇତ୍କେ ଗାଟି ବୁତ୍‌କ୍‍ ଅନାଗେ ଅସିମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ବେଲା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାତାଲ୍‍ତାଗେ ଆଦାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିମାକିଣ୍ଡ୍, ଇଦ୍ ସେଙ୍ଗେ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ବିନତି ମାଡ଼ାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ଆଗେ ମେଟେତାଗ୍ ୱେରନ୍ ବାଡ଼ିୟାଦ୍ ମାନ୍ଦାପାଦି ମେୟମାତ୍‍ତା, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ବେଦ୍ ଲେକାମ୍ ଆୱିଙ୍କ୍ ଆୱେ ପାଦିନ୍ ଲୋପେ ଆସାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ସେଙ୍ଗେ ଆୱ ଅଂକିଙ୍କ୍‌ ବିନତି ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଜିସୁ ଆୱିଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତାଙ୍କ୍, ବୁତ୍‌କ୍‍ ଆଦ୍ ନାରୁଡ଼୍ ତେ କନ୍‍ସ୍ ପେଇସ୍ ପାଦିନ୍ ଲୋପେ ଅସ୍‍ତା; ଆସୁଣ୍ଟ୍ ଆଦ୍ ମାନ୍ଦାପାଦି ଗାଟି ଉର୍‍ଗିନ୍‍ ମିରି ଆଞ୍ଜ୍ ମେଟେତ୍ ପରୁ କନ୍‍ସ୍ ସାୱୁଡ଼େ ତାଗ୍ ରାଲି ମୁଡ଼ୁନ୍ଦି ଡୋଲ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ମେୟେତାନ୍ ନାରୁଡ଼୍ ଆଦ୍ ଗଟନା ଉଡ଼ି ମିରି ଆଞ୍ଜ୍ ନାର୍ ନୁ ନାଟେନାଗ୍ ଆଦ୍ ବିଷୟ୍ କେଞ୍ଜ୍‍ସ୍ପ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ଆସୁଣ୍ଟ୍ ନାରୁଡ଼୍ ଆଦ୍ ଗଟନା ଉଡ଼ାଙ୍କ୍ ପେଇସ୍ ୱାତ୍‍ତଡ଼୍; ମେଣ୍ଡେ, ଅଡ଼୍‌‍ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍, ବେନେ ନାରୁଡ଼୍ କନ୍‍ସ୍ ବୁତ୍‌କ୍ ପଇସ୍ ମାତ୍‍ତା; ଅଣ୍ଡ୍‌ ସିଲେ କେର୍‍ସ୍ ସାୟେତ୍ ମାନ୍‍ ତେ ଜିସୁନ୍ ଡେକେତ୍ ମଦଲ୍ କୁଦିମାନ୍ଦାନ୍ ଉଡ଼ି ୱେର୍‍ତ୍‍ତଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ମେଣ୍ଡେ, ବେନଡ଼୍ ଉଡ଼ିମାତ୍‍ତଡ଼୍‍, ଅଡ଼୍‌‍ ଆଦ୍ ବୁତ୍‌ପଇତ୍‍ତେ ନାରୁଡ଼୍ ବେଲା ସୁସ୍ଥ ଆତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ଆଗେତିନ୍‍ସ୍ ଗରାଶୀୟ ନାରୁଡ଼୍ ତେ ପଡ଼ିୟେତାଗ୍ ସାରେପାକା ସାରେତଡ଼୍ ନାରୁଡ଼୍ ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ ଆଦାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌‍ ମାଡ଼୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଗାଟି ୱେର୍‍ସ୍ ମାତ୍‍ତଡ଼୍; ମେଣ୍ଡେ ଜିସୁ ୱେରନ୍ ଓଡ଼େତାଗ୍ ତାରି ମାଲ୍‍ସ୍ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ବାତେଙ୍କ୍ ଇତ୍କେ ବେନେ ନାରୁଡ଼୍ କନ୍‍ସ୍ ବୁତ୍‌କ୍ ପେଇସ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତା, “ଅଣ୍ଡ୍‌ ତାନ୍ ତଡ଼୍ ମାନ୍ଦାନ୍ ସେଙ୍ଗେ ଦନ୍ୟବାଦ୍ ମାଡ଼୍‍ତଣ୍ଡ୍;” ");
INSERT INTO kff_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ମାତର୍ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ରହସ୍‍ ମେଣ୍ଡେ କେତ୍ତଣ୍ଡ୍, “ନିମେ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆନ୍‌, ମେଣ୍ଡେ ଇଶ୍ୱର୍ ନି ସେଙ୍ଗେ ବାତେଏ ପାଡ଼ିୟି ମାଡ଼ି ମିନ୍ଦେଣ୍ଡ୍, ଆୱ୍ ସାରେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେଲେ । ଆଗେତିନ୍‍ସ୍ ଅଣ୍ଡ୍‌ ଆଞ୍ଜ୍ ମିକା, ଜିସୁ ଅନ୍‌ ସେଙ୍ଗେ ବାତେଏ ପାଡ଼ିୟି ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଆୱ୍ ସାରେ ନାର୍ ଏକାମ୍ କେତାନଙ୍କ୍ ପସ୍‍ପିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ମେଣ୍ଡେ ଜିସୁ ମେଣ୍ଡେଅଣ୍ଡ୍‌‍ ପାକେ ମାଲ୍‍ସ୍ ୱାତ୍‍ତାଙ୍କ୍, ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ୱେଡ଼୍‍କା ତେ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ସାର୍‍ରେତଡ୍ ଅଙ୍କ୍‌ କେପି ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ମେଣ୍ଡେ, ଉଡ଼ାଟ୍ ଯାଇରସ୍ ପେଦେର୍ ତଣ୍ଡ୍ ୱେର୍‍ଣ୍ଡ୍ ନାରୁଡ଼୍ ୱାତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ସମାଜ୍‍ଲନ୍ ତେ ବାଡ଼୍ୟ୍‍ଣ୍ଡ ମାତ୍‍ତଣ୍ଡ୍ । ଅନ୍‌ ଜିସୁନ୍ ଡେକେତ୍ ମଦଲ୍ ରାଲି ତାମ୍ ଲୋନ୍‌ ୱାଦାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ବିନତି ମାଡ଼ତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ବାତେଙ୍କ୍ ଇତ୍କେ ଅନ୍‌‍ୱାଦ୍ ବାର ହେଣ୍ଡେତ୍ ୱେର୍‍ଟେ ମାତର୍ ପିକିଡ଼୍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ଆଦ୍ ଡଲାନ୍ ରକମ୍ ଆସ୍ ମାତ୍‍ତେ । ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଆଦାନ୍ ୱେଲେ ନାରୁଡ଼୍ ଅନ୍‌ ପରୁ ରାୟ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ଆସୁଣ୍ଟ୍ ବାର ହେଣ୍ଡ୍ ଯାକ ନେତୁର୍‍ ରୋଗ୍ ତେ ଅରଟ୍ ନାଟାଡ଼୍ ମାତ୍‍ତେ, ବେନ କି ତାନ୍‍ୱାଦ୍ ସାରେ ଡାବ୍‍କ୍ କର୍ଚ୍ଚ ମାଡ଼କେ ମିକା ବେନନ୍ ତଡ଼୍ ସୁସ୍ଥ ଆୟ୍‍ୟ ମାତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ଆଦ୍ ପେର୍‍କେ କନ୍‍ସ୍ ୱାସ୍ ଜିସୁନ୍ ସିଲେତିଙ୍କ୍ ଇଟ୍‍ତା, ମେଣ୍ଡେ, ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଦିନାଦ୍ ନେତୁର୍‍ ପେଇତାନାଦ୍ ବନ୍ଦ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ଆସୁଣ୍ଟ୍ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ବେନ ନାକିଂଙ୍କ୍ ହିଟ୍‍ତଣ୍ଡ୍ ?” ମାତର୍ ସାରେତଡ଼୍ ଅସ୍ୱୀକାର୍ ମାଡ଼୍‍ତଡ଼୍, ପିତର୍ କେତ୍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ନାରୁଡ଼୍ ସାରେତଡ଼୍ ତୁର୍ସାତୁର୍ସି ଆସ୍ ନି ପରୁ ରାୟୁତଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ବେନ ୱେର୍‍ଣ୍ଡ୍ ନାକିଂଙ୍କ୍ ହିଟ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାୟାଗେ କନ୍‍ସ୍ ଶକ୍ତି ପେଇତ୍‍ତେ ନାନ୍ ପୁତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ଆସୁଣ୍ଟ୍ ନାଟାଡ଼୍ ଉଡ୍ ତେ ଯେ, ଆଦ୍ ମିଞ୍ଜି ମାନ୍ଦାଙ୍କ୍ ପାର୍‍ୱ, ଆସୁଟେ ଆଦ୍ ୱାଡ଼୍‍‍କ ୱାଡ଼୍‍‍କ ୱାସ୍ ଅନ୍‌ ଡେକେତ୍ ମଦଲ୍ ରାଲି, ବାତେଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ହିଟ୍ ତେ, ମେଣ୍ଡେ ବେଲା ସାଙ୍ଗେ ସାଙ୍ଗେ ସୁସ୍ଥ ଆତ୍‍ତେ, ଆଦ୍ ସାରେତଡ଼୍ ନାରୁଡ଼୍ ମୁନ୍‍ନେ କେତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ଆଗେତିନ୍‍ସ୍ ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ହୋ ପିକି, ନି ବିଶ୍ୱାସ୍ ନିକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ିତେ, ଶାନ୍ତି ତେ ଆନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ଅଣ୍ଡ୍‌ ଇଦ୍ ଗଟ୍ କେତ୍‍ତାନ୍ ୱେଲେ ସମାଜ୍‍ଲନ୍ ତେ ମୁକ୍ୟାନ୍ ଲୋତ୍‍ତେ କନ୍‍ସ୍ ୱେର୍‍ଣ୍ଡ୍ ୱାସ୍ କେତ୍ତଣ୍ଡ୍, “ନି ମାୟାଡ଼୍ ଡୋଲିଆତ୍‌ତେ, ଗୁରୁଙ୍କ୍ ମେଣ୍ଡେ କଷ୍ଟ ହିମା ।” ");
INSERT INTO kff_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଇଦ୍ କେଞ୍ଜି ଯାଇରସ୍‍ତିଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ୱେର୍‍ମାଟ୍, ମାତର୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍, ମେଣ୍ଡେ ଆଦ୍ ଗେଲ୍‌ସିତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ମେଣ୍ଡେ, ଜିସୁ ଯାଇରସ୍‍ତେ ଲୋନ୍‌ ୱାସ୍ ପିତର୍, ଯୋହନ୍‌ ନୁ ଯାକୁବ୍, ମେଣ୍ଡେ ପିକିଡ଼୍ ତେ ୟାୟବାବଡ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନଙ୍କେ ଅନ୍‌‍ତଡ଼୍ ଲୋପେ ଆଦାଙ୍କ୍ ହିୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ମାତର୍ ସାରେତଡ଼୍ ଆଦିନ୍ ସେଙ୍ଗେ କେୟକେୟ ଗୁଣ୍ଡେତାଗ୍ ରେହେସ ମାତ୍‍ତଡ଼୍ । ଆଗେତିନ୍‍ସ୍ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “କେୟ୍‍ମାଟ୍; ଆଦ୍‍ଡୋଲ, ମାତର୍ ଉଞ୍ଜିମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ଡୋଲିଆତ୍‌ତେ ଇଞ୍ଜ ପୁଞ୍ଜ୍ ମାତ୍‍ତାଙ୍କ୍ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ପରିହାସ୍ ମାଡ଼ାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ମାତର୍ ଜିସୁ ଆଦିନାଦ୍ କାଇଦିଙ୍କ୍ ପଇସ୍ କାର୍‍ଙ୍ଗି କେତ୍ତଣ୍ଡ୍, “ହୋ ପିକି, ତେଦ୍‍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ଆଗେତିନ୍‍ସ୍ ତାନାଦ୍ ଜିୱୁଣ୍ଡ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତେ, ମେଣ୍ଡେ ଆଦ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ତେଦ୍‍ଦେ, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ସୁଦୁର୍ ତିନ୍ଦାନଙ୍କ୍ ହିଦାନ୍ ସେଙ୍ଗେ କେସିତ୍‍ଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ଇଗେତିସ୍‍ନ୍‍ ତାମ୍ ୟାୟବାବ ବାକ୍‍ୱା ଆତ୍‍ତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ଜାଗେତାଦ୍ ଗଟନା ତେ ଗଟ୍ ବେନଙ୍କେ କେତାନାଦ୍ ଆୟ୍‍ୟ ଇଞ୍ଜ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଜିସୁ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍‍କ୍ କାର୍‍ଙ୍ଗି ଅଣ୍ଡୟାଗେ ଗୁଡ଼୍‍ପି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାର୍‍ରେ ବୁତ୍‌କିଂଙ୍କ୍ ୱିର୍‍ସ୍‍ପି, ମେଣ୍ଡେ, ରୋଗ୍ ୱିର୍‍ସ୍‍ପାନ୍ ମାଇଦିଙ୍କ୍ ଶକ୍ତି ନୁ ଅଦିକାର୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଶ୍ୱର୍‌ତାଦ୍ ରାଜ୍ୟ କେତାନଙ୍କ୍ ନୁ ରୋଗି ନାରୁଡ଼୍‍କ୍ ସାୟେ ମାଡ଼ାଙ୍କ୍ ରହତ୍‍ତଣ୍ଡ । ");
INSERT INTO kff_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଆଦ୍‍ଦାନ୍ ୱେୟେ ଟେଙ୍ଗା, କି ମୁନା କି ରୂଟି କି ଡାବ୍, ବାତାମେଣ୍ଡେ ଆୟ୍‍ମାଟ୍, ରେଣ୍ଡ୍ ଚକା ସାଙ୍ଗେତେ ଆୟ୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ମେଣ୍ଡେ, ମିଡ଼୍ ବେନ୍‌ଆଇ ଲୋତ୍‍ତାଗ୍ ନେଙ୍ଗିତିଡ଼ି, ଆଦ୍ ଜାଗାତାଗାଙ୍କ୍ ଆନ୍‌‍ୱକଟ ଆଦେ ପଡ଼ିୟେତାଗ୍ ମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଆସୁଟେ ବେଗେ ନାରୁଡ଼୍ ମିକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼କ୍, ଆଦ୍ ନାର୍ କନ୍‍ସ୍ ଆଦାନ୍ ୱେୟେ ଅଡ଼୍‌‍ ବିରୁଦ୍‍ତେ ସାକ୍ଷ୍ୟ ଇଦାନ୍‍ମାଇଦିଙ୍ଗ୍ ମି ଡେକେତ୍ ଦୁମ୍‌ କାୟ୍‍ସିମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ଆଗେତିନ୍‍ସ୍ ଅଡ଼୍‌‍ ଆଞ୍ଜ୍ ମିକା ସୁସମାଚାର୍ ପ୍ରଚାର ମାଡ଼ି ନୁ ରୋଗିଡ଼୍‍କ୍ ସୁସ୍ଥମାଡ଼ି ନାର୍ ଉଡାଙ୍କ୍ ପେୟ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଇଗ୍‍ତିନ୍‍ସ୍‍ ସାମନ୍ତରାଜାଲ୍ ହେରୋଦ୍ ଇଦ୍‍ସାର୍ ଗଟ୍ କେଞ୍ଜି ଉନ୍‍କେମାନ୍‍କେ ଆତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ଡଲ୍‍ତେ ନାରୁଡ଼୍ ଆଗାଙ୍କ୍ ତେଦି ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ ବେନ୍‍ ବେନଡ଼୍ କେସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ମେଣ୍ଡେ, ବେନ୍‍ ବେନଡ଼୍ ଏଲିୟ ତନ୍ଦତଣ୍ଡ୍ ହିଞ୍ଜ କେସମାତ୍ତଡ଼୍, ମେଣ୍ଡେ ବାଗାତଡ଼୍ ମୁନେତ୍ ବାବବାଦୀ ଡ଼ାଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ତେଦ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ କେସମାତ୍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ବାତେଙ୍କ୍ ଇତ୍କେ ହେରଦ୍ ରାଜାଲ୍ କେତ୍‍ତଣ୍ଡ୍, “ଯୋହନ୍‌‌ତାଦ୍ ତାଲ୍‍ତିଙ୍ଗ୍ ନାନ୍ ତ ନାଡ଼‍କ୍‍ତମ୍, ମାତର୍ ଅନ୍‌ ବିଷୟ୍‍ତେ ମାମ୍ ଇଦ୍‍ପୁଟୁଙ୍କ୍ ଗଟି କେଞ୍ଜୁତମ୍, ଇଣ୍ଡ୍ ବେନ ?” ମେଣ୍ଡେ, ଜିସୁଙ୍କ୍ ଉଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଆଲ୍‍ସି ମାଡ଼ମାତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ପେର୍‍କେ ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍ ମାଲ୍‍ସ୍‍ୱାସ୍, ବାତ୍‍ ବାତା ମାଡ଼ିମାତ୍‍ତଡ଼୍, ଆୱ୍‍ସାରେ ଅନ୍‌ ଗାର୍‍ରେ ତିଆର୍ ମାଡ଼୍‍ତଡ଼୍ । ମେଣ୍ଡେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାଙ୍ଗେତେଅସ୍ ବେତ୍‍ସାଇଦା ପେଦେର୍ ତେ ନାର୍‍ତାଗ୍ ହାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ କେଞ୍ଜି ଅନ୍‌ ପେର୍‍କେ ତାସିତ୍‌ତଡ୍; ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ଗ୍ରହନ୍ ମାଡ଼ି ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ବିଷୟତେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ, ବେନଡ଼୍ ସୁସ୍ଥ ଆଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ହା ଦିନାମ୍‍ତେ ଦିନାମ୍ ମୁଲ୍‍ପୁଟ୍ ଆଦାଙ୍କ୍ ଆଞ୍ଜମାତ୍‍ତେ; ମେଣ୍ଡେ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଡ଼୍, “ନାରୁଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଗାର୍‍ରେ ନାକିନାଗ୍ ଆଞ୍ଜ୍ ନୁ ନଗର୍‍ତାଗ୍ ଆଞ୍ଜ୍ କାଦି ତିନ୍‌ତଡ଼୍‌, ଅଦିନ୍‌ ମାଇଦିଙ୍କ୍ ରଅସିମ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମାନାଡ଼୍ ଇଗେ ବାତେଏ ଇଲ୍‍ୱେ ପଡ଼ିୟେତାଗ୍ ମିନ୍ଦେଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼େ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ତିନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ହିମୁଟ୍ ।” ଅଡ଼୍‌‍ କେତ୍ତଡ଼୍, “ମା ଗାର୍‍ରେ ଏଇଙ୍ଗ୍ ରୂଟି ନୁ ରେଣ୍ଡ୍ କିକେ ମିନ୍ଦେ ଆୱିଙ୍କ୍‍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ମାୟାଗ୍‌ ବାତା ଇଲେ । ଆଲାତ୍କେ ମାନାଡ଼୍ ଆଞ୍ଜ୍ ବାତା ଇଡ଼୍‍ସାର୍ ନାରୁଡ଼୍ ମାଇଦିଙ୍କ୍ କାଦି ଆସିତାଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ଅଡ଼୍‌‍ ସାର୍‍ରେତଡ଼୍ ଏଇଙ୍ଗ୍ ହଜାର୍‌ ନାରୁଡ଼୍ ମାତ୍‍ତଡ଼୍ । ମେଣ୍ଡେ, ଜିସୁ ତାମ୍ ଶିଷ୍ୟଡ଼କ୍ କେତ୍ତଣ୍ଡ୍, “ପାଚାଶ୍ ପାଚାଶ୍ ନାରୁଡ଼୍‍କ୍ ମାନ୍ଦେ ମାନ୍ଦେ ମାଡ଼ି କୁସ୍‍ପାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ଆସୁଟେ ଅଡ଼୍‌‍ ରକମ୍ ସାର୍‍ରେ ତଡ଼୍‍କିଂଙ୍କ୍ କୁସ୍‍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଜିସୁ ଆୱ୍ ଏଇଙ୍ଗ୍ ରୂଟି ନୁ ରେଣ୍ଡ୍ କିକେ ଆସ୍ ସ୍ୱର୍ଗତ୍ ପାକ୍ ମୁନ୍‍ମାଡ଼ି ଆୱ୍‍ଚାରେ ଆର୍ଶିବାଦ୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ନାରୁଡ଼୍ ମୁନେ ଉଉସ୍ ମେଣ୍ଡେ, ଅଡ଼୍‌‍ ନାରୁଡ଼୍‍କ୍ ହିଦ୍‍ନ୍ ମାଇଦିଙ୍କ୍ ଶିଷ୍ୟଡ଼କ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ମେଣ୍ଡେ ସାରେତଡ଼୍, ତିଞ୍ଜ୍ ପାଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ମେଣ୍ଡେ ଅଡ଼ାୱୁ ମିଗ୍‍ଲିମାନ୍ଦାନ୍ ଉରୁଙ୍ଗ୍‍ତେ ରୂଟି ସାରେ ବାର୍‍ଟାନ୍ ଜୁଡ଼ୀନାଗ୍ ପେହେକି ନିହ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ଜିସୁ ଦିନେ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ୱେୟ୍ ଶିଷ୍ୟଡ଼୍ ଅନ୍‌‍ଗାରେ ୱାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନାନେ ବେନନ୍ ଇଞ୍ଜ ନାରୁଡ଼୍ କେତୁ‍ତଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ଆସୁଟେ ଅଡ଼୍‌‍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ଇଞ୍ଜ,” ମେଣ୍ଡେ, “ବେନ୍‍ ବେନଡ଼୍ କେତୁତଡ଼୍, ଏଲିୟ ଇଞ୍ଜ, ବାଗାତଡ଼୍ କେତୁତଡ଼୍ ମୁନେତଣ୍ଡ୍ ବାବବାଦୀ ଡ଼ାଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ପୁନରୁତ୍‍ତିତ୍ ଆସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ନାନେ ବେନନ୍ ଇଞ୍ଜ ମିଡ଼୍ କେତୁତିଡ଼୍ ?” ପିତର୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍ “ନିମେ ଇଶ୍ୱରତେ କ୍ରିଷ୍ଟନି ।” ");
INSERT INTO kff_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ଜିସୁ ଆସୁଟେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ ଇଦ୍ ବେନଙ୍କ୍ କେଲ୍‍ମାଟ୍ ଇଦ୍ ବେନଙ୍କେ କେଲ୍‍ମାଟ୍ ଇଞ୍ଜ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦୃଡ଼ ଗଟ୍ ଇସ୍ କେତ୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାରୁନ୍‍ପିଲେତିଙ୍କ୍ ଗାଟି ଦୁଃକାମ୍ ମାଡ଼ିତନ୍ ଆସୁଟେ ଅଂକିଙ୍କ୍‌ ଯିହୁଦୀ ନେତା, ମୁକ୍ୟଯାଜକ୍ ନୁ ଶାସ୍ତ୍ରୀଡ଼୍ ଜିସୁଙ୍କ୍ ରେହେତିତଡ଼୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ମୁଣ୍ଡ୍ ଦିନାତିଙ୍କ୍ ଜିୱେ ଆସ୍ ତେଦିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ଆସୁଟେ ଜିସୁ ସାର୍‍ରେତଡ୍‍କିଙ୍ଗ୍ କେତ୍‍ତଣ୍ଡ୍‍, “ବେନ ନା ପେର୍‍କେ ତାକାଙ୍କ୍ ଇଚ୍ଛାମାଡ଼ୁତଣ୍ଡ୍, ଆଲାଇତ୍କେ ଅଣ୍ଡ୍‌ ନିଜେ ଅସ୍ୱୀକାର୍ ମାଡ଼ିଣ୍ଡ୍, ସାର୍‍ଦିନା ଅଂକିଙ୍କ୍‌ ଇସ୍ ମାନ୍ଦାନାଦ୍ କ୍ରୁଶତିଙ୍କ୍ କାଞ୍ଜି, ନା ପେର୍‍କେ ୱାଡ଼ିଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ମାତର୍ ବେନ ନିଜର୍ ଜିୱୁନ୍‍ତିଙ୍କ୍ ରକ୍ଷା ମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆଉ ୱିଡ଼୍‍ସାନ୍ ମିନ୍ଦେ; ବେନ ନା ମାଇଦିଙ୍କ୍ ଅନ୍‌ ଜିୱୁନ୍ ୱିଡ଼୍‍ସିଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ରକ୍ଷା ମାଡ଼ିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ମାତର୍ ନାରୁନ୍ ବେସୁଟ୍‌ ସାର୍‍ରେ ଜଗତ୍‍ତିଙ୍କ୍ ଲାବ୍ ମାଡ଼ି, ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍ ନଷ୍ଟ ମାଡ଼ିତନ୍, ଆଲାତ୍କେ ଅଂକିଙ୍କ୍‌ ବାତ୍ ଲାବ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ବେନଆଇ ନାକିଂଙ୍କ୍ ନୁ ନାୟାଦ୍ ବାକ୍ୟବିଷୟତେ ସିଗ୍ ଆଦ୍‍ତଣ୍ଡ୍, ନାରୁନ୍‍ପିଲେ ଆସୁଟେ ଅନ୍‌ ମାଇମାତେ, ପରମେଶ୍ୱର୍‍ତେ ମାଇମାତେ ନୁ ପବିତ୍ର ଦୂତକିନ୍ ମହିମା ତେ ୱାଦାନାଦ୍ ମାଡ଼ିତନ୍, ଆସୁଟେ ଅଣ୍ଡ୍‌ ଆ ବିଷୟ୍ ତେ ସିଗ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ମାତର୍, ନାନେ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, “ମିଇ ନାରୁଡ଼୍ ଲୋପ୍ ନିଶ୍‍ମାନ୍ଦାନ୍ ବେସ୍‍ତୁଡ଼୍ ନାରୁଡ଼୍ ଡଲାନ୍ ମୁନେଙ୍କ୍ ପରମେଶ୍ୱରତାଦ୍ ରାଜ୍ୟତିଙ୍କ୍ ଉଡ଼ିତଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ହି ସାର୍‍ରେ ଗଟ୍‍ନା ଆସ୍ ମାତର୍ ଆଟ୍‍ ଦିନ୍ ପେର୍‍କେ ଜିସୁ, ପିତର୍, ଯୋହନ୍‌ ନୁ ଯାକୁବଙ୍କ୍ ସାଙ୍ଗେତେଆସ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ମେଟେତ୍ ପରୁ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଜିସୁ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ଦିନାମ୍‍ତେ ଅନ୍‌‍ୱାଦ୍ ମକମ୍ ତନ୍ଦାନାଦ୍ ମେଣ୍ଡନ୍ ଲେକାମ୍ ଆତ୍‍ତା ଅନାୱୁ କେର୍ସ୍ ମାନ୍ଦାନ୍ ଚକା ପାଣ୍ଡେ ଆସ୍ ୱେସ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ମେଣ୍ଡେ, ଉଡ଼ାଟ୍, ହଟାତ୍ ମଶାଲ୍‌ ନୁ ଏଲିୟ, ଇର୍‍ୱୁଡ଼୍ ଜିସୁନ୍ ତଡ଼୍ ତିର୍‍ୟୁତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ଅଡ଼୍‌‍ ସ୍ୱର୍ଗୀୟ ଗୌରବ୍‍ତେ ତଅନ୍‌ଦମାତ୍ତଡ଼୍, ଜିସୁ ଡଲାନାଦ୍ ବିଷୟ ତେ ଯୀରୁଶାଲାମ୍ ଗଟେମ୍ ଆଦାଙ୍କ୍ ଆଦୁତ୍‍ତେ ଆଦ୍ ବିଷୟ ତେ ଅଡ଼୍‌‍ ଅଣ୍ଡ୍‌ ତଡ଼୍ ତିର୍‍ୟୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ଆସୁଟେ, ପିତର୍ ନୁ ଅନ୍‌ ସାଙ୍ଗଡ଼୍ ଉଞ୍ଜିମାତ୍‍ତଡ଼୍; ବେସୁଙ୍କ୍‍ ଅଡ଼୍‌‍ ତେଦି ଉଡ଼ୁ‍ତଡ଼୍, ଜିସୁନାଦ୍ ମହିମା, ମେଣ୍ଡେ ଅନ୍‌‍ତଡ଼୍ ଇର୍‍ୱୁଡ଼୍ ନିସ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ମେଣ୍ଡେ ମଶାଲ୍‌ ନୁ ଏଲିୟ ଜିସୁନାଗାଙ୍କ୍ ଆଦ୍‍ଦାନ୍ ୱେୟ୍ ପିତର୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ସାୟେ ଆତ୍‍ତେ ମାନାଡ଼୍ ଇଗ୍ ମିନ୍ଦେଡ଼୍; ମାନାଡ଼୍ ଇଗେ ମୁଣ୍ଡ୍ ଗୁଡ୍‍ସା ତିଆର୍ ମାଡ଼ିକାଡ଼୍, ନି ମାଇଦିଙ୍କ୍ ଅଣ୍ଡୟ୍‌, ମୋଶାନ୍‌ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡୟ୍‌, ଏଲିୟନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ।” ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ବାତ୍ କେତ୍ତଣ୍ଡ୍, ଆଦ୍ ଅଣ୍ଡ୍‌ ପୁନଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ପିତର୍ ଆଦ୍ ଗଟି କେସମାନ୍ଦାନ୍‌ ୱେୟ୍ ମାବ୍‍ୱାସ୍ ଇଡ଼୍‍କ୍ ମିସ୍‍ତା, ମେଣ୍ଡେ, ଅଡ଼୍‌‍ ମାବ୍‍ତାଗ୍ ନେଙ୍ଗାନ୍ ୱେୟ୍ ପିତର୍, ଯାକୁବ୍ ନୁ ଯୋହନ୍‌ ୱେର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ଆସୁଟେ ଆଦ୍ ମାବ୍‍ତାଗାଙ୍କ୍ ଇଦ୍‍ପୁଟୁଙ୍କ୍ ଲେଙ୍ଗ୍ ଆତ୍‍ତେ, “ହୋ ମା ପ୍ରିୟ ମାର୍‍, ଇକିଂଙ୍କ୍ ମାମ୍ ହେଞ୍ଚି ମିନ୍ଦେମ୍, ଇନ୍‍ ବାକ୍ୟତିଙ୍କ୍ କେଞ୍ଜାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ମେଣ୍ଡେ ଆଦ୍ ଲେଙ୍ଗ୍ଆସ୍ ତେର୍‍ତ୍ ୱେୟ୍ ଜିସୁ ୱେରଣ୍ଡେ ଆଗେ ତଅନ୍‌ତତଣ୍ଡ୍ । ପିତର୍, ଯାକୁବ୍ ନୁ ଯୋହନ୍‌ କଟ ଆସ୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ବାତ୍‍ ବାତା ଉଡ଼ିମାତ୍‍ତଡ଼୍, ଆଗେତାୱୁ ବେନେ ବା ଗଟ୍‌ ଆଦ୍‌ ସମୟତେ ବେନଙ୍କ୍‌ ମିକା କେଲଡ଼୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ମେଣ୍ଡେନ୍‍ଦିନ୍ ଜିସୁ ନୁ ଅଡ଼୍‌‍ୱାଦ୍‌ ମୁୱୁଡ଼୍ ଶିଷ୍ୟଡ଼୍ ମେଟେତାଗାଙ୍କ୍ ଡିଗି ୱାତ୍‍ତେ ୱେୟ୍, ନାର୍ଗେ ନାରୁଡ଼୍ ୱାସ୍ ଜିସୁନ୍ ତଡ଼୍ କାୟ୍‍ଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ମେଣ୍ଡେ ଉଡ଼ାଟ୍; ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ଗାଟି ଲେଙ୍ଗଦେ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ନାନେ ନିକିଂଙ୍କ୍ ଦନ୍ୟବାଦ୍ ମାଡ଼ୁତାନ୍, ଦୟାମାଡ଼ି ନା ମାର୍‍ଦିଙ୍କ୍ ୱାସ୍ ଉଡ଼େ ବାତେଙ୍କ୍ ଇତ୍କେ ନାକିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡେ ଇଞ୍ଜ ମାର୍‍; ");
INSERT INTO kff_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ଉଡ଼େ, ଅଂକିଙ୍କ୍‌ ବୁତ୍ ପୟିନୁଡ଼୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଟାତ୍‍ ତେ ମର୍‍ପୟ୍‍ତୁତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ବୁତ୍ ଇଦ୍‍ପୁଟୁଙ୍କ୍ ମାଡ଼୍‍ତେ ଯେ, ଅନ୍‌ ପାୟୁର୍‍ତାଗାଙ୍କ୍ ବୟୁଲ୍ ପେୟିନୁଡ଼୍‌, ବୁତ୍ ଅଂକିଙ୍କ୍‌ ଉକେୱେକ୍ ମାଡ଼ି ଅନ୍‌ଆଗାଙ୍କ୍ ତିପାଲ୍‍ତେ ପେୟିସ୍ ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ବୁତ୍‌ତିଙ୍କ୍ ୱିର୍‍ସ୍‍ପାନ୍ ମାଇଦିଙ୍କ୍ ନାନେ ନି ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ମାତ୍‍ତାନ୍, ମାତର୍ ଅଡ଼୍‌‍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଆର୍ ଅବିଶ୍ୱାସ୍‌ଡ଼ି ନୁ ପେର୍‍କେ ୱାଦାନ୍ ବଂଶତଡ଼ି, ମେଣ୍ଡେ ବେସ୍‌କ୍‌ଦିନା ନାନେ ମି ତଡ଼୍ ମାନ୍‍ତା, ବେସର୍‍ଦିନା ନାନେ ମିୟାଦ୍ ମାଡ଼ାନ୍ କାମ୍‍ତିଙ୍କ୍ ‍କେଞ୍ଜ୍‍ତାନ୍, ତାନ୍ ପେର୍‍କେ ଜିସୁ ଆଦ୍ ନାରୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନି ମାର୍‍ଦିଙ୍କ୍ ଇଗ୍ ପୟ୍‍ସ୍ ତାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ପେକାଲ୍ ୱାଦାନ୍ ୱେୟ୍ ବୁତ୍ ଅଂକିଙ୍କ୍‌ ନେଏଲ୍ ‍ରାପି ବୟଙ୍କାର୍ ତେ ପଇସ୍‍ଉକିତ୍ତେ, ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଶୁଚି ଆତ୍ମାତିଙ୍କ୍ ଦମକ୍ ହିତ୍‍ତଣ୍ଡ୍ ନୁ ପେକାଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ି ଅଂକିଙ୍କ୍‌ ତାମ୍ ବାବାନ୍ କାଇଦେ ଇତ୍‍ତନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ଆଗେତିନ୍‍ସ୍ ଅଡ଼୍‌‍ ସାର୍‍ତଡ଼୍ ଇଶ୍ୱର୍ ତେ ନାର୍ଗେଶକ୍ତି ତେ ବାକ୍‍ୱା ଆଦ୍‍ତଡ଼୍ । ମାତର୍ ତାନ୍ ମାଡ଼୍‍ତେ ସାରେ ପାଡ଼ିୟି ସେଙ୍ଗେ ସାରେତଡ଼୍ ବାକ୍‍ୱା ଆଦାନ୍ ୱେଲେ ଜିସୁ ତାମ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ଜିସୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନାନ୍ ବାତେଏ କତ୍‍ତାନ୍ ଆଦ୍ ମାର୍‍ଙ୍ଗ୍‌ମାଟ୍ ଆଦ୍ ସାର୍‍ରେଗଟି ମି କେୱକିନାଗ୍ ନେହେମୁଟ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁନ୍ ମାର୍‍ ଶତୃଡ଼୍ କାଇଦେ ସମର୍ପିତ୍ ହାଦାଙ୍କ୍ ଆଦୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ବାତେଙ୍କ୍ ଇତ୍କେ ଶିଷ୍ୟଡ଼୍ ଆଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍, ଆଦ୍ ଗଟ୍ ତେ ଇତ୍‍କେ ଅଡ଼୍‌‍ ମାଇଦିଙ୍କ୍ ପୁନ୍ଦାନ୍ ସେଙ୍ଗେ ମିଞ୍ଜିମାତ୍‍ତେ, ଆସୁଟେ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ଆଦ୍ ଗଟ୍ ବିଷୟ୍ ତେ କେତ୍‍ତାନ୍ ମାଇଦିଙ୍କ୍ ୱେର୍‍ସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ଅଡ଼୍ ଲପେଙ୍କ୍‌ ବେନଣ୍ଡ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ଆଦ୍‌ ବିଷୟତେ ଅଡ଼୍‌ ଲପେ ରାମ୍‌କ୍‌ ରଦ୍‌ଦେ ଆତ୍‌ତେ । ");
INSERT INTO kff_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍ ଆଲ୍‍ସାନାଦ୍ ପୁଞ୍ଜ୍, ଅର୍‍ତୁଙ୍କ୍ ସୁଦୁନ୍ ପେକାଙ୍କ୍ ଅନ୍‌ ଗାର୍‍ରେ ତାସ୍ ନିଲ୍‍ସ୍ପି ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“ବେନଆଇ ନା ପେଦେର୍‍ତେ ହି ସୁଦୁଣ୍ଡ୍ ପେକାଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍, ବେନଆଇ ନାକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନା ତ୍ରାଣକର୍ତ୍ତାଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ମି ସାର୍‍ରେତଡ଼୍ ଲୋପ୍ ବେନ ସୁଦୁନଣ୍ଡ୍, ଅଣ୍ଡେ ବାଡ଼୍‍ୟଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ଆସୁଙ୍କ୍ ଯୋହନ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ମାମ୍ ଅର୍‍ତୁଙ୍କ୍ ନି ପେଦେର୍ ତେ ବୁତ୍ ୱିଡ଼୍‍ସ୍‍ପାନାଦ୍ ଉଡ଼୍‍ତମ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ମା ମାନ୍ଦେ ତାଗ୍ ଇଲ୍‍ୱାଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ମାମ୍ ମନା ମାଡ଼୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମନା ମାଡ଼୍‍ମାଟ୍, ବେନ୍ ମିଇ ତୋଡ଼୍ ଆୟ୍‍ୟଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ତୋଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ଜିସୁ ଜଗତ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ସ୍ୱର୍ଗତା ମାଲ୍‍ସ୍‍ଆଦାନ୍ ଦିନାମ୍ ଗାର୍‍ରେ ହେୱ୍‍ସ୍ ମାତ୍‍ତେ, ଆସୁଟେ ଅଣ୍ଡ୍‌ ଯିରୁଶାଲେମ୍‍ତା ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ତିୟାର୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ଜିସୁ ଅନ୍‌ ମୁନେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରହତଣ୍ଡ୍, ଅଡ଼୍‌‍ ଆଞ୍ଜ୍ ଜିସୁନ୍ ମାଇଦିଙ୍କ୍ ଆୟୋଜନ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଶମିରୋଣୀୟ ନାର୍‍ଦାଗ୍ ଅସ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଯୀରୁଶାଲାମ୍ ଆଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ପୁଞ୍ଜ୍ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଆଦ୍ ଉଡ଼ି, ଯାକୁବ୍ ନୁ ଯୋହନ୍‌, ହି ଇର୍‍ୱୁଡ଼୍ ଶିଷ୍ୟ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ପ୍ରବୁ ଏଲିୟ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍‍ପୁଟୁଙ୍କ୍ ମାବ୍‍ତାଗାଙ୍କ୍ କିସ୍ ରାଲି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନଷ୍ଟ ବା ୱିଡ଼୍‍ସି ମାଡ଼ି, ଆଦ୍ ମାମ୍ କେତିତମ୍ ଇଞ୍ଜ ବାତ୍ ମିୱାଦ୍ ଇଚ୍ଛା ?” ");
INSERT INTO kff_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ତିଡ଼୍‍ୟିମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆନୁଯୋଗ୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ବେନ୍ ଲେକାମ୍ ଆତ୍ମାତ୍ ନାରୁଡ଼ି, ଇଦ୍ ନାନ୍ ପୁନନ୍ । ନାରୁନ୍ ମାର୍‍ ନାରୁଡ଼୍‍ତେ ଜିୱୁନ୍‍ତିଙ୍କ୍ ହାଉକାଙ୍କ୍ ୱାଡ଼ଣ୍ଡ୍ ବା ଗେଲ୍‍ସ୍‍ପାଙ୍କ୍ ୱାସ୍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ଆସୁଟେ ଅଡ଼୍‌‍ ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ନାର୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ଅଡ଼୍‌‍ ଆର୍‍ଦାଲାନ୍ ଆଦାନ୍ ଦିନାମ୍ ତେ ୱେରନ୍ ନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନିମେ ବେନେ ଜାଗେତାଗ୍ ଆଦ୍‍ତିଡ଼୍, ନାନେ ନି ପେର୍‍କେ ୱାଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “କଙ୍ଗାନାକାଙ୍କ୍ ଦୋର୍‌ରା ମିନ୍ଦେ, ମାବ୍ ତେ ପରୁ ଉଡାନ୍ ପିଟେଙ୍କ୍ ତୁହ୍‍କା ମିନ୍ଦେ, ମାତର୍ ନାରୁନ୍‍ପିଲେତାଦ୍‍ ତାଲାଙ୍କ୍‌ ଗୁଞ୍ଚାମାଡ଼ାଙ୍କ୍ ପଡ଼ିୟେ ଇଲା ।” ");
INSERT INTO kff_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ମେଣ୍ଡେ, ଅର୍‍ତୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନା ପେର୍‍କେ ୱାଡ଼ା ।” ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ମୁନେ ଆଞ୍ଜ୍ ନା ବାବାଙ୍କ୍ ସମାଦି ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ନାକିଂଙ୍କ୍ ଗଟ୍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ମାତର୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଡଲ୍‍ତେନଡ଼୍‍କିଂଙ୍କ୍ ସମାଦି ହିଦାଙ୍କ୍ ଡୋଲ୍‍ତଡ଼୍‍କ୍ ୱିଡ଼୍‍ସିମୁଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ଆଞ୍ଜ ଇଶ୍ୱର୍‌ତ୍ ରାଜ୍ୟତେ ପ୍ରଚାର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ଆନ୍‌‍ତେ କେତ୍‍ତଣ୍ଡ୍, “ନାନେ ନି ପେର୍‍କେ ତାକିତାନ୍, ମାତର୍ ମୁନେ ନା ଲୋନ୍‌ ମାନ୍ଦାନ୍ ନାରୁଡ଼ାଗାଙ୍କ୍ ୱିଡ଼୍‍ସିଦାନ୍ ମାଇଦିଙ୍କ୍ ନାକିଂଙ୍କ୍ ଗଟ୍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବେନ ନାଙ୍ଗେଲ୍‍ତାଗ୍ କାୟ୍‍ପୟ୍‍ସ୍ ପେର୍‍କେ ଉଡ଼ିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱରତେ ରାଜ୍ୟ ସେଙ୍ଗେ ବାତ୍ ପାଡ଼ିୟିଦିଙ୍କ୍ ମିକା ଯୋଗ୍ୟ ଆୟ୍‍ୟଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ତାନ୍ ପେର୍‍କେ ଜିସୁ ପ୍ରବୁ ସତୁରି ଇର୍‍ୱୁଡ଼କ୍ ଜାନ୍ ନାରୁଡ଼୍‍କ୍ ଏଞ୍ଚତଣ୍ଡ୍ । ବେନ୍ ନଗର୍‍ ନୁ ପଡ଼ିୟେତାଗ୍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମିନ୍ଦେ, ଆଦ୍ ଜାଗାକିନାଗ୍ ଇର୍‍ୱୁଡ଼୍ ମାଡ଼ି ଜିସୁ ଆଦାନ୍ ମୁନେଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ମେଣ୍ଡେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଶସ୍ୟ ସିନା ନାର୍ଗେ, ମାତର୍ ପାଡ଼ିୟିମାଡ଼ାନ୍ ନାରୁଡ଼୍ ସୁକୁକେ; ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ପସଲ୍‍ମାଡ଼୍‍ତେ ମାଲିକ୍‍ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ ଯେ, ମାଲିକ୍ ବେଲାକି କୟ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ନାର୍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରହ୍‍ତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ମିଡ଼୍ ଆନୁଟ୍, ଉଡ଼ାଟ୍, ନାନେ ମିକିଂଙ୍କ୍ କୁକାଲ୍‍କିନ୍ ଲୋପ୍ ମେଣ୍ଢାପିଲାନ୍ ଲେକାମ୍ ମାଡ଼ି ରହ୍‍ତୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଆଦାନ୍‌ ୱେଲେ ସାଙ୍ଗେ ଡାବ୍, ମୁନେ, ହେର୍‍ପୁକ୍ କି ବାତାମେଣ୍ଡେ ଆୟ୍‍ମାଟ୍, ମେଣ୍ଡେ, ଆର୍‍ଦାଗ୍ ବେନଙ୍କ୍ ନମସ୍କାର୍ ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଆସୁଟେ, ବେନେଆୟି ଲୋନ୍‌ ନେଙ୍ଗାନ୍ ମୁନେନ୍‍ କେଲ୍‍ମୁଟ୍, “ଇ ଲୋତ୍‍ତେ ସେଙ୍ଗେ ଶାନ୍ତି ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ଯଦି ଆଗେ ବେନ ଶାନ୍ତିତ୍ ନାରୁଡ଼୍ ମାତ୍‍କେ, ଆଲାତ୍କେ ମିୱାଦ୍ ଆର୍ଶିବାଦ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦର୍‍କିତ୍ । ଯଦି ଆଗେ ବେନ ଶାନ୍ତିତ୍ ନାରୁଡ଼୍ ହିଲକଟ୍ ମାନ୍‍ତଣ୍ଡ୍, ଆଲାତ୍କେ ମିୱାଦ୍ ଆର୍ଶିବାଦ୍ ମିୟାଗ୍ ମାଲ୍‍ସ୍ ୱାଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଆ ନାରୁଡ଼୍ ବାତାଆଇ ତିନ୍ଦାଙ୍କ୍ ହିଦ୍‍ତଡ଼୍ ଆୱୁ ତିନୁଟ୍ । ପାଡ଼ିୟେ ମାଡ଼ାନ୍ ନାରୁଡ଼୍‍କ୍ ମଜୁରି ଦର୍‍କାନାଦ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ । ଲୋତ୍‍ତେ କନ୍‍ସ୍ ମେଣ୍ଡେଅଣ୍ଡ୍‌ ଲୋନ୍‌ ଆନ୍‌‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଯଦି ମିଡ଼୍ ବେନ୍‌ଆଇ ନାର୍ ଆଦ୍‍ତିଡ଼୍, ଯଦି ମିକିଂଙ୍କ୍ ଆଗେତ୍ ନାରୁଡ଼୍ କାର୍‍ଙ୍ଗିତଡ଼୍, ଆଲାତ୍କେ ଅଡ଼୍‌‍ ମିକିଂଙ୍କ୍ ବାତ୍ କାଦି ହିଦ୍‍ତଡ଼୍ ଆଦ୍ ତିନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ଆଦ୍ ଜାଗାକିନାଗ୍ ମାନ୍ଦାନ୍ ରୋଗିନାରୁଡ଼୍ ସୁସ୍ଥ ମାଡ଼ାଟ୍, ଆସୁଟେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେଲ୍‍ମୁଟ୍, ପରମେଶ୍ୱରତେ ରାଜ୍ୟ ମି ଗାର୍‍ରେ ୱାସ୍ ହେୱ୍‍ସ୍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ଯଦି ବେନ୍‌ଆଇ ନାର୍ ଆଦ୍‍ତିଡ଼୍ ଯଦି ଆଗେତ୍ ନାରୁଡ଼୍ ମିକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ଡ଼୍‍, ଆଲାତ୍କେ ଆଦ୍ ନାର୍‍ଦେ ବାଇଦେ ଆଞ୍ଜ କେଲ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ମି ନାର୍‍ଦେ ଦୂମ୍ ମା ଡେକାନାଗ୍ ଟୁଣ୍ଡିମିନ୍ଦେ ଆଦ୍ ମିକା ମିୟାଗେ କାୟ୍‍ସିଦୁତମ୍ । ବେଲାହିତ୍‍କେ ମେଣ୍ଡେ ପରମେଶ୍ୱର୍‍ତାଦ୍ ରାଜ୍ୟ ମି ଗାର୍‍ରେ ୱାସ୍ ହେୱ୍‍ସ୍ ମିନ୍ଦେ, ଇଦ୍ ପୁଞ୍ଜ୍ ମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ନାନେ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍ ଯେ, ବିଚାର୍ ଆଦାନ୍‍ଦିନାତେ ଆଦ୍ ନାର୍ ଦେ ନାରୁଡ଼୍ ତେ ଦଣ୍ଡ୍ ୱିଡ଼୍‍ସି ସଦୋମ୍‍ ନଗର୍‍ତେ ଦଣ୍ଡ୍ ସହ୍ୟ ମାଡ଼ାଙ୍କ୍ ଆଦ୍ ତେ । ");
INSERT INTO kff_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ହୋ, “କୋରାଜିନ୍ ନିୟାଦ୍ ଦଣ୍ଡ୍ କି ବୟଙ୍କାର୍ ଆଦ୍ ତେ, ହୋ, ବେତ୍‍ସାଇଦା ନିୟାଦ୍ ମିକା ଦଣ୍ଡ୍ କି ବୟଙ୍କାର୍ ଆଦ୍ ତେ, ମି ମାଇଦିଙ୍କ୍ ନାନେ ନାର୍ଗେ ଆଶର୍ଯ୍ୟ ପାଡ଼ିୟେ ତଅତାନ୍ । ଯଦି ହିସତାଦ୍ ସୋର ନୁ ସିଦୋନ୍‍ତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମାଡ଼ି ମାନ୍ଦାନ୍ ହିତ୍‍କେ, ହାଲାଇତ୍କେ ଅଡ଼୍‌‍ ନାର୍ଗେଦିନାତେ ମୁନେଙ୍କ୍ ବାସ୍ତା କେର୍ସ୍ ନିର୍‍ତାଗ୍ କୁଦି ମନପରିବର୍ତ୍ତନ୍ ମାଡ଼ି ମାନେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ହାଲାଇତ୍କେ ବିଚାର୍ ଦିନାତେ ମିୟାଦ୍ ଦଣ୍ଡ୍ ୱିଡ଼୍‍ସି ସୋର୍ ନୁ ସୀଦୋନ୍‍ତେ ନାରୁଡ଼୍ ତେ ଦଣ୍ଡ୍ ସହ୍ୟ ମାଡ଼ାଙ୍କ୍ ଆଦ୍‌ତେ । ");
INSERT INTO kff_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ହୋ କପର୍ନାହୂମ୍ ନିମ୍‍ ବାତ୍ ସ୍ୱର୍ଗ ହେଉନା ଡେଙ୍ଗ୍ ଆଦ୍‍ତିଡ଼୍ ? ପାତାଲ୍‍ ହେଉନା ନିମେ ରାୟିତି ।” ");
INSERT INTO kff_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜିସୁ ତାମ୍ ଶିଷ୍ୟଡ଼କିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବେନମେଣ୍ଡ୍ଆଇ ମିୱାଦ୍ ଗଟି କେଞ୍ଜିତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ନା ଗଟି କେଞ୍ଜିତଣ୍ଡ୍, ମେଣ୍ଡେ ବେନ ମିକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ଣ୍ଡ୍, ମେଣ୍ଡେ ବେନ ନାକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ନା ତ୍ରାଣକର୍ତ୍ତାଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଆସୁଟେ ଅଡ଼୍‌‍ ସତୁରି ଇର୍‍ୱୁଡ଼୍ ଜାନ୍ ନାରୁଡ଼୍ ମାଲ୍‍ସ୍‍ୱାସ୍ ସାର୍‍ଦେତେ କେତ୍‍ତଡ଼୍, “ପ୍ରବୁ, ମାମ୍ ବେସୁଟ୍‌ ନିୟାଦ୍ ପେଦେର୍ ପୟ୍‍ସ୍ କେତ୍‍ତମ୍, ଆସୁଟେ ବୁତ୍‌କ୍ ଆନ୍‌‍ତେ ମା ଗଟିଙ୍କ୍ କେଞ୍ଜ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ପିଡ଼୍‍ଗ୍ ହିନା ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଶୟ୍‍ତାନ୍‍ ରାଲାନାଦ୍ ନାନ୍ ଉଡ଼ିମା‍ତ୍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ଉଡ଼ାଟ୍, ନାନ୍ ମିକିଂଙ୍କ୍ ତାଡ଼ାକିନାଗ୍ ନୁ ଏଟ୍‍ଗଡେଲ୍‍କିନ୍ ପରୁ ତାଆକାନ୍ ମାଇଦିଙ୍କ୍ ଶକ୍ତି ନୁ ଅଦିକାର୍‌ ହିତ୍‍ତାନ୍, ମେଣ୍ଡେ ଶତ୍ରୁଡ଼୍ ଶକ୍ତିତ୍ ପରୁ ଆନ୍‌‍ତେ ଅଦିକାର୍‌ ହିତ୍‍ତାନ୍, ମିକିଂଙ୍କ୍ ବେନଡ଼୍ ମେଣ୍ଡେ ବାତ୍ କ୍ଷତି ମାଡ଼୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ମିକା, କାରାପ୍ ଆତ୍ମା ଆନ୍‌‍ତେ ମିଆୱ୍ ଗଟି କେଞ୍ଜୁତ୍ ଇଞ୍ଜ ମିଡ଼୍ ସାର୍‍ଦ୍‍ ଆୟ୍‍ମାଟ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ମିୱାଦ୍ ପେଦେର୍ ଯେ ସ୍ୱର୍ଗତାଗ୍ ଲେକାମିନ୍ଦେ, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ସାର୍‍ଦେ ଆୟିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ତାନ୍ ପେର୍‍କେ ଜିସୁ ପବିତ୍ରଆତ୍ମାତେ ତଡ଼୍ ସାର୍‍ଦେତେ ସାରେଆସ୍ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ବାବା, ହୋ ସ୍ୱର୍ଗ ନୁ ପୃତିବିତେ ପ୍ରବୁ ନାନ୍ ନି ପ୍ରସଂଶା ମାଡ଼ୁତାନ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ନିମେ ଜ୍ଞାନି ନୁ ବୁଦ୍‍ ନାରୁଡ଼ାଗାଙ୍କ୍ ମିଞ୍ଜିପି ନେହେସ୍ ମାତ୍‍ତିନ୍, ପିଲାନ୍ ଲେକାମ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତଅତିନ୍ । ଆଦିନ୍‌ମାଇଦିଙ୍କ୍ ନିୱାଦ୍ ସ୍ତୁତି ମାଡ଼ୁତାନ୍; ଇଦ୍ ହିଁ ଆଦାଙ୍କ୍ ନିମେ ଇଚ୍ଛା ମାଡ଼୍‍ତି ।” ");
INSERT INTO kff_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ନା ବାବାଲ୍ ଅନାଦ୍‌ ସାରେ ବିଷୟ୍ ନାକିଂଙ୍କ୍ ହିତ୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ, ମାର୍‍ ବେନ, ଇଦ୍ ବାବାନ୍ ୱିଡ଼୍‍ସି ବେନମେଣ୍ଡେ ପୁନଡ଼୍, ମେଣ୍ଡେ ବାବାଲ୍ ବେନ, ଅନ୍‌‍ମାର୍‍ ୱିଡ଼୍‍ସି ବେନମେଣ୍ଡେ ପୁନଡ଼୍, ଆସୁଟେ ମାର୍‍ ବେନଣ୍ଡ୍ ମୁନ୍‍ନେ ଅଂକିଙ୍କ୍‌ ତଅତାନ୍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛାମାଡ଼ିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ପୁନ୍‍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ମେଣ୍ଡେ, ଜିସୁ ତାମ୍ ଶିଷ୍ୟଡ଼ା ମୁନ୍‍ମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଇୱେ ସାରେ ବିଷୟ ଉଡ଼୍‍ତାଙ୍କ୍ ମିଡ଼୍ ଦନ୍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ମିଡ଼୍ ବାତାବାତା ଉଡ଼୍‍ତିଡ଼୍, ଆୱ୍ ସାରେ ବାବବାଦୀଡ଼୍ ନୁ ରାଜାଲଡ଼୍ ଉଡ଼ାନ୍‍ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ମାତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଉଡ଼ାଙ୍କ୍ ପାର୍‍ୱଡ଼୍; ମେଣ୍ଡେ, ମିଡ଼୍ ବାତା କେଞ୍ଜ୍‍ତିଡ଼୍, ହାଉସାରେ ଅଡ଼୍‌‍ କେଞ୍ଜାନ୍ ଇଚ୍ଛା ମାଡ଼ମାତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ କେଞ୍ଜେ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ଆସୁଟେ ଉଡ଼େ, ୱେରନ୍ ବ୍ୟବସ୍ଥାଶାସ୍ତ୍ରଜ୍ଞ ତେଦୀ ଅଂକିଙ୍କ୍‌ ପରିକ୍ଷା ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ସାରେଦିନାତ୍ ଜିୱୁଣ୍ଡ୍ ଆଦାନ୍ ସେଙ୍ଗେ ନାନ୍ ବାତା ମାଡ଼ିତାନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ଆସୁଟେ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ବ୍ୟବସ୍ଥାତାଗ୍ ବାତ୍ ଲେକାମିନ୍ଦେ ? ନିମେ ବେଲା କାର୍‍ତୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ଅଣ୍ଡ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନିମେ ନିୱାଦ୍ ସାର୍‍ରେ ହୃଦୟ୍, ସାରେ ଜିୱେ, ସାରେ ଶକ୍ତି ନୁ ସାର୍‍ରେ ମାନ୍‍ ଇସ୍‌ ପ୍ରବୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରେମ୍ ମାଡ଼ାଟ୍; ମେଣ୍ଡେ, ନି ଗାର୍‍ରେତଡ଼୍‍କିଂଙ୍କ୍ ନିଜେଲାକାମ୍ ପ୍ରେମ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ଆସୁଟେ ଅଂକିଙ୍କ୍‌ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ନିମେ ଟିକ୍ ଉତ୍ତର୍ ହିତ୍‍ତି, ଇଲା ମାଡ଼ାଟ୍ ହାଲାଇତ୍କେ ନିମେ ଜିୱୁଣ୍ଡ୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଶାସ୍ତ୍ରଜ୍ଞ ନିଜ୍‍ତିଙ୍କ୍ ଦାର୍ମିକ୍ ଇଞ୍ଜ ତଅତାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ି ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହାଲାଇତ୍କେ ନା ଗାରେତଡ଼୍ ବେନ ?” ");
INSERT INTO kff_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜିସୁ ଆଦ୍ ପ୍ରଶ୍ନତେ ଉତ୍ତର୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ଯୀରୁଶାଲାମ୍ ତାଗାଙ୍କ୍ ଯିରୀୟ ନାର୍ ଆଞ୍ଜ ମାତ୍‍ତଣ୍ଡ୍, ଆଞ୍ଜ ଆଞ୍ଜ ଡଙ୍ଗାଲଡ଼୍ କାୟ୍‍ଦେ ଆତ୍‍ତଡ଼୍ । ଅଡ଼୍‌‍ ଅନାୱୁ ଚକାସିଲେଙ୍କ୍ ୱିର୍‍ସ୍‍ପି, ଅଂକିଙ୍କ୍‌ ରେହେସ୍ ଡଲାନ୍ ଲେକାମ୍ ଆଦାନ୍ ଅବସ୍ଥାତେ ୱିଡ଼୍‍ସି ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ଗଟନା ଆଶେ ତେର୍‍ତ୍ ୱେୟ୍ ୱେରଣ୍ଡ୍ ଯାଜକ ଆଦେ ହାର୍ ଇସ୍‌ ଆଞ୍ଜମାତଣ୍ଡ୍, ଆସୁଟେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଆର୍‍ଦାଲା ଏରି ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ଲେବୀୟ ନାରୁଡ଼୍ ଆଦେ ପଡ଼ିୟେତାଗ୍ ହେଉସ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଆର୍‍ଦିଙ୍କ୍ ହେରି ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ବାତେଙ୍କ୍ ଇତ୍କେ ୱେରଣ୍ଡ୍ ଶମିରୋଣୀୟ ପତିକ ନାରୁଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଦୟାତେ ଦାନ୍ଦେ ଆତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ଆସୁଟେ ଅଣ୍ଡ୍‌ ଅନ୍‌ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଦେବ୍‍ ତାଲ୍‍ଗ୍‍ତାଗ୍ ନିୟ୍‍ ନୁ ଦ୍ରାକ୍ଷାରସ୍ ତଶ୍‍ସି ତହସିତ୍‍ତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ଆସୁଟେ ନିଜର୍ ଗଦତାଗ୍ କୁସ୍‍ପି ଅଂକିଙ୍କ୍‌ ୱେରଡ଼୍ ବେନିଲ୍‍ୱେ ଲତ୍‍ତାଗ୍ ଅସ୍ ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ସେବା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ମେଣ୍ଡନ୍‍ଦିନେ ଶମିରୋଣୀୟ ନାରୁଡ଼୍ ରେଣ୍ଡ୍ ଦିନାରୀ ପେସ୍‍ପି ବେନିଲ୍‍ୱେ ଲତ୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ମୁକ୍ୟାଙ୍କ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, ହିନ୍‍ୱାଦ୍‍ ଯତନ୍ ମାଡ଼େ, ନିମେ ଅନ୍‌‍ମାଇଦିଙ୍କ୍ ବାତ୍ ‘ମେଣ୍ଡେ କର୍ଚ୍ଚମାଡ଼ିମାନ୍ତି, ନାନ୍ ଆକାଙ୍କ୍ ମାଲ୍‍ସ୍‍ୱାସ୍ ବେସର୍ କର୍ଚ୍ଚ ମାଡ଼ିମାନ୍‍ତିନ୍ ଆସର୍ ଡାବ୍ ନିକିଂଙ୍କ୍ ହିଦ୍‍ତାନ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“ଇଡ଼୍ ମୁୱୁଡ଼୍ ଲୋପ୍ ବେନ ଡଙ୍ଗାନ୍ କାଇଦେ ହାର୍‍ସ୍‍ ମାତ୍‍ତଣ୍ଡ୍ ଅନ୍‌ ଗାରେ‍ତଣ୍ଡ୍ ବେନ ଇଞ୍ଜ ମିଡ଼୍ ହାଲ୍‍ସୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ବ୍ୟବସ୍ଥା ଶାସ୍ତ୍ରଜ୍ଞ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ବେନ ଅଂକିଙ୍କ୍‌ ଦୟାମାଡ଼୍‍ତଣ୍ଡ୍ ଅଣ୍ଡ୍‌ । ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ନିମେ ମିକା ରକମ୍ ମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଜିସୁ ତାମ୍ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ଆଞ୍ଜମାନ୍ଦାନ୍ ୱେଲେ ୱେରଡ଼୍ ନାର୍ ଆସ୍‍ତଣ୍ଡ୍ । ମାର୍ତା ପେଦେର୍ ତେ ୱେରଡ଼୍ ନାଟାଡ଼୍ ତାମ୍ ଲୋନ୍‌ ଜିସୁଙ୍କ୍ କାର୍‍ଙ୍ଗି ସ୍ୱାଗତ୍ ମାଡ଼ିତେ । ");
INSERT INTO kff_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ମରୀୟମ୍ ପେଦେର୍‍ତାଦ୍ ୱେରନ୍ ତାନ୍ ଏଲାଡ଼୍‍ ମାତ୍‍ତେ, ଆଦ୍ ପ୍ରବୁନ୍ ଡେକେତ୍ ମଦଲ୍ କୁଦି ଅନାଦ୍‌ ବାକ୍ୟ କେଞ୍ଜମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ବାତେଙ୍କ୍ ଇତ୍କେ ମାର୍ତା ସେବା ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ଗାଟି ଦାନ୍ଦେ ଆସମାତ୍‍ତେ; ଆସୁଟେ ଆଦ୍ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତେ, ହୋ ପ୍ରବୁ, ନା ଏଲାଡ଼୍‍ ଯେ ୱେରଡେ ନା ପରୁ ସାର୍‍ରେ ସେବା ମାଡ଼ାଙ୍କ୍ ୱିଡ଼୍‍ସିତ୍‍ତେ, ଆଦ୍ ବିଷୟ ନିକିଂଙ୍କ୍ ହେର୍କା ଇଲେ କି ? ନାକିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାଙ୍କ୍ ମାଇଦିଙ୍କ୍ ତାଙ୍କ୍ କେସିମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ବାତେଙ୍କ୍ ଇତ୍କେ ପ୍ରବୁ ତାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମାର୍ତା, ମାର୍ତା ନିମେ ଗାଟି ବିଷୟ୍‍ତିଙ୍କ୍ ଚିନ୍ତେ ନୁ ଦାନ୍ଦେ ଅଦୁତିନ୍, ");
INSERT INTO kff_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ବାତେଙ୍କ୍ ଇତ୍କେ ୱେରଡ଼୍ ବିଷୟ ଗାଟି ଦର୍‍କାଡ଼୍ । ମରୀୟମ୍ ନିଜେତ୍ ମାଇଦିଙ୍କ୍ ଆଦ୍ ଲେକେତ୍‍ ବିଷୟତିଙ୍କ୍ ପସନ୍ଦ ମାଡ଼୍‍ତେ, ଆଦ୍ ତାନ୍‍ଆଗାଙ୍କ୍ ୱିର୍‍ସ୍‍ପି ଆଦାଙ୍କ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ଅନ୍‌‍ଦାମ୍ ଜିସୁ ୱେରଡ଼୍ ପଡ଼ିୟେତାଗ୍ ପ୍ରାର୍ତନା ମାଡ଼ ମାତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ପ୍ରାର୍ତନା ତେରପ୍‍ସ୍‍ତେ ୱେୟ୍, ତାମ୍ ଶିଷ୍ୟଡ଼୍ ଲୋପେକେ ୱେରଣ୍ଡ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ହୋ ପ୍ରବୁ, ବାପ୍ତିସ୍ମ ଯୋହନ୍‌ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଅନ୍‌ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଙ୍କ୍ ନାଡ଼ସ୍ପତଣ୍ଡ୍, ନିମେ ‍ଆଦେ ରକମ୍ ମାକିଂଙ୍କ୍ ପ୍ରାର୍ତନା ନାଡ଼ସ୍ପେ । ");
INSERT INTO kff_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ଜିସୁ ଆସୁଟେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବେସୁଟ୍‌ ମିଡ଼୍ ପ୍ରାର୍ତନା ମାଡ଼ିତିଡ଼୍, ଆସୁଟେ କେଲ୍‍ମୁଟ୍, ‘ହଁ ସ୍ୱର୍ଗତନି ବାବା, ନିୟାଦ୍ ପେଦେର୍ ପବିତ୍ର ହିଞ୍ଜ ମାନ୍ୟ ହାୟି । ନିୟାଦ୍ ରାଜ୍ୟ ୱାଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ସାରେଦିନା ମାକିଂଙ୍କ୍ ଦର୍‍କାର୍‍ ଆଦାନ୍ କାଦି ହିମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ମାକିଂଙ୍କ୍ ତିପାଲ୍ ପରିକ୍ଷାତେ ମୁନ୍‍ନେ ଆଦାନଙ୍କ୍ ହିମା, ମାତର୍ ପାପ୍‌ ତାଗାଙ୍କ୍ ମାକିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼େ ।’” ");
INSERT INTO kff_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ଆସୁଟେ, ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ କି, ମିଲୋପ୍ ବେନଣ୍ଡ୍ ଇସତ୍ ସାଙ୍ଗ ମିନ୍ଦେଣ୍ଡ୍ କି, ବେନନାଗ୍‍ଆଇ ନାର୍କା ଆଞ୍ଜ୍ କେତିତଣ୍ଡ୍, ହୋ ସାଙ୍ଗ, ନାକିଂଙ୍କ୍ ମୁଣ୍ଡ୍ ରୂଟି ଉଦାର୍ ହିମ୍, ");
INSERT INTO kff_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ବାତେଙ୍କ୍ ଇତ୍କେ ନା ୱେରଣ୍ଡ୍ ପତିକ ସାଙ୍ଗ ନା ଲୋନ୍‌ ‍ୱାସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ତିନ୍ଦାଙ୍କ୍ ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ନାୟାଗେ ବାତେଏ ମିକା ଇଲେ, ");
INSERT INTO kff_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଆସୁଟେ ଅଣ୍ଡ୍‌ ଲୋପ୍‍ମାଞ୍ଜ୍ ଇଲା କେତି‍ତଣ୍ଡ୍, ନାକିଂଙ୍କ୍ କଷ୍ଟ ଇମା; ମାଆର୍‍ ବନ୍ଦ୍ଆଦୁତ୍, ନା ପିଲା ନା ତଡ଼୍ ଉଞ୍ଜିମିନ୍ଦେ; ନାନେ ତେଦୀ ନିକିଂଙ୍କ୍ ହିଦ୍‍ପାର୍‍ୱନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଅଣ୍ଡ୍‌ ତାମ୍ ସାଙ୍ଗ ଆସ୍ ମିକା ତେଦି ହିୱକଟ ମାନ୍‍ତଣ୍ଡ୍, ହାଲାଇତ୍କେ ଅଣ୍ଡ୍‌ ସିଗ୍ ଆୟ୍‍ୟକଟ ସେନେକ୍‍ ସେନେକ୍ ତାଲ୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ତେଦି, ଅଂକିଙ୍କ୍‌ ବେସର୍ ଦର୍‍କାର୍, ଆସର୍ ଅଂକିଙ୍କ୍‌ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ତାଲ୍‍କାଟ୍, ହାଲାଇତ୍କେ ମିକିଂଙ୍କ୍ ହିଦ୍‍ତଡ଼୍; ମେହେକାଟ୍, ହାଲାଇତ୍କେ ମିଡ଼୍ ଦର୍‍ସ୍‍କ୍‍ତିଡ଼୍; ମାଆର୍‍ଦିଙ୍କ୍ ତାଲ୍‍ସା, ହାଲାଇତ୍କେ ମି ମାଇଦିଙ୍କ୍ ତେର୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ବେନ ଆୟି ତାଲ୍‍କିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ହିଦ୍‍ତଡ଼୍; ବେନ ମେହେକିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଦର୍‍ସ୍‍କିତଣ୍ଡ୍, ବେନ ମାଆର୍‍ଦିଙ୍କ୍ ତାଲ୍‍ସିତଣ୍ଡ୍, ଅନ୍‌ ମାଇଦିଙ୍କ୍ ତେର୍‍ସିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ଇଦ୍‌ରକମ୍‌ ବେନ ମିଇ ବାବାଲ୍‌ ମିନ୍ଦେଣ୍ଡ୍,ତାନ୍‌ ମାର୍‌ ରୂଟି ତାଲ୍‍କ୍‍କେ ଅଂକିଙ୍କ୍‌ ବାତ୍ କାଲ୍‍ବଦା ହିଦ୍‍ତିଡ଼୍ ? ବା ଅଣ୍ଡ୍‌ କିକେ ତାଲ୍‍କ୍‍କେ ଅଂକିଙ୍କ୍‌ ବାତ୍ ତାଡ଼ାମ୍ ହିଦ୍‍ତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ମେଣ୍ଡେ ଗାଡ଼୍‍ବାମ୍ ତାଲ୍‍କେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ଏଟ୍‍ଗଡେଲ୍‍ ହିଦ୍‍ତଣ୍ଡ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ମିଡ଼୍ ଦୁଷ୍ଟ ଆତ୍‍କେ ମେଣ୍ଡେ, ମି ପିଲାଙ୍କ୍ ସାୟ୍‍ ସାୟ୍‍ତାୱ ହିଦାଙ୍କ୍ ପୁତ୍‍ତିଡ଼୍, ବେନ ବାବାଲ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ହିଦ୍‍ତଣ୍ଡ୍ ଅନ୍‌ ଗାର୍‍ରେ ତାଲ୍‍କାନ୍ ନାରୁଡ଼୍‍କ୍ ନାର୍ଗେ ପବିତ୍ର ଆତ୍ମା ହିଦ୍‍ତଣ୍ଡ୍ ! ");
INSERT INTO kff_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ୱେରଟ୍‍ଦିନ୍ ଜିସୁ ଗଟି ତିର୍‍ୟାଙ୍କ୍ ପାର୍‍ୱେ ନାରୁନ୍ ମେନ୍ଦୁଲ୍ ତାଗାଙ୍କ୍ ବୁତ୍‌ତିଙ୍କ୍ ତଲ ମାତ୍‍ତଣ୍ଡ୍ । ବୁତ୍‌ତିର୍‍ୟାଙ୍କ୍ ପାର୍‍ୱେ ନାରୁନ୍ ମେନ୍ଦୁଲ୍‍ତାଗାଙ୍କ୍ ପେୟିସ୍ ଆତ୍‍ତେୱେୟ୍, ଗୁଡ଼୍‍ତେ ନାରୁଡ଼୍ ଉଡ଼ି ବାକ୍‍ୱା ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଆଗାଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେତ୍‍ତଡ଼୍, “ବୁତ୍‌ପତି ବାଲ୍‌ଜିବୁଲ୍‌ ଶକ୍ତିତେ ଜିସୁ ବୁତ୍ ୱିର୍‍ସ୍‍ପୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ବାଗାତ୍ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ିୟିତାଗ୍ ୱାଟାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ମାତଡ଼୍ ତ ଇଶ୍ୱର ଯେ ତାମ୍ କାଇଲାନ୍‍ନଡ଼୍ ଇଦିନ୍ ଚିହ୍ନେ ଲେକାମ୍ ମାବ୍‍ତାଗାଙ୍କ୍ ୱେରଡ଼୍ ଚିଏହ୍ନେ ତଅତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼ାଦ୍‌ ମନ୍‍ତେ ହେର୍‍କାତିଙ୍କ୍ ପୁଞ୍ଜ୍, ହଡ଼୍‍କିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବେନ୍ ଆୟି ରାଜ୍ୟ ୱେରେଆସ୍ ନିଜର୍ ବିରୁଦତେ ତେଦିତ୍, ହାଲାଇତ୍କେ ଦ୍ୱଂସ ଆଦ୍ ତେ, ମେଣ୍ଡେ ବେନେଆଇ ଲୋନ୍‌ ୱେରେ ଆତ୍‍କେ ଆଦ୍ ଆର୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଆଲେକେ, ଶୟ୍‍ତାନ୍‍ ମେଣ୍ଡେ ୱେରେ ଆସ୍ ନିଜର୍ ବିରୁଦ୍ଦ୍‌ ତେ ନିଜେ ତେଦିତ୍, ହାଲାଇତ୍କେ ତାନାଦ୍ ରାଜ୍ୟ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ତିଆର୍ ଆସ୍ ମାନ୍‍ତେ ? ନାନ୍ ବାଲ୍‌ଜିବୁଲ୍‌ ଶକ୍ତିତେ ବୁତ୍‌କିଂଙ୍କ୍ ୱିର୍‍ସ୍‍ପୁତାନ୍ ଇଞ୍ଜ ମିଡ଼୍ ତ କେତୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ବେସୁଙ୍କ୍‍ ବାଆଲ୍‍ଜିବୁଲ୍‍ତ୍ ଶକ୍ତିତେ ବୁତ୍‌କିଂଙ୍କ୍ ୱିର୍‍ସ୍‍ପୁତାନ୍, ଆଲାଇତ୍କେ ମି ମାର୍‍କ୍ ବେନନ୍ ଶକ୍ତିତେ ଆୱିଙ୍କ୍ ୱିର୍‍ସ୍‍ପୁତଡ଼୍ ? ମି ମାର୍‍କ୍ ପ୍ରମାନ୍ ମାଡ଼ିତା ଯେ ମିଡ଼୍ ବୁଲ୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ନାନ୍ ଯଦି ପରମେଶ୍ୱର୍‍ତେ ଶକ୍ତିତେ ବୁତ୍‌ତିକିଂଙ୍କ୍‍ ୱିର୍‍ସ୍‍ପୁତାନ୍, ଆଲାଇତ୍କେ ଇଦ୍ ପ୍ରମାନ୍ ମାଡ଼ିତ୍ ଯେ ପରମେଶ୍ୱରତାଦ୍ ରାଜ୍ୟ ମି ଗାର୍‍ରେ ହେୱ୍‍ଦୁତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ୱେରଣ୍ଡ୍ ଶକ୍ତିତେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ କାଡ଼ିୱିଲ୍‍କ୍ ପୟ୍‍ସ୍ ନିଜର୍ ଲୋତ୍‍ତିଙ୍କ୍ କେପିମାନ୍ତତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ଅନ୍‌ ସମ୍ପତ୍ତି ଯତନ୍‍ତେ ଆସ୍ ମାନ୍‍ତା; ");
INSERT INTO kff_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ବାତେଙ୍କ୍ ଇତ୍କେ ବେସୁଟ୍‌ ଅଂକିଙ୍କ୍‌ ଅନ୍‌ ଗାଟି ଶକ୍ତିତ୍ ନାରୁଡ଼୍ ୱାସ୍, ଅନନ୍ତ ଯୁଦ୍‌ ଆସ୍ ଅଂକିଙ୍କ୍‌ ଜିଡ଼୍‍ତଣ୍ଡ୍, ଆସୁଟେ ଅନ୍‌ କାଡ଼ିୱିଲ୍‍କ୍ ପୟ୍‍ସ୍ ମାନ୍ଦାନ୍ ସାରେ ଅଣ୍ଡ୍‌ ଲାଗି ଆତ୍‍ତେ, ଅନାୱୁ ଲାଗ୍‍ ତେ ଜିନିଷ୍‍ତିଙ୍କ୍ ତୁଉସି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ବେନ ନା ତୋଡ଼୍ ଆୟ୍‍ୟଣ୍ଡ୍, ଅନ୍‌ ନା ତୋଡ଼୍‍ଦେନଣ୍ଡ୍, ମେଣ୍ଡେ ବେନ ନା ତଡ଼୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ୱେରେ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ଅଶୁଚି ଆତ୍ମା ୱେରନ୍ ନାରୁନାଗାଙ୍କ୍ ପେୟିସ୍ଆତ୍‍ତେ ୱେୟ୍ ଏର୍‍ ‍ହିଲ୍‍ୱା ଜାଗାକିନାଗ୍ ଆଞ୍ଜ୍ ଉଡ଼ିମେଣ୍ଡେ ରମାଙ୍କ୍ ମେହ୍‍କିତ୍, ଆସୁଟେ ମେହ୍‍କି ଦର୍‍ସ୍‍କକଟ୍ କେତିତ୍‍, ନାନେ ବେନ୍ ଲୋତ୍‍କଂଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେନ୍ ନାନେ ଆଦ୍ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆଦ୍‍ତନ୍; ");
INSERT INTO kff_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଆସୁଙ୍କ୍ ବୁତ୍ ଆଦ୍ ନାରୁନାଗ୍ ମାଲ୍‍ସ୍ ଆଞ୍ଜ୍ ଉଡ଼ିତ୍, ହି ଲୋନ୍‌ ସାକ୍‍ସାକା ନୁ ଟିକ୍‍ଟାକ୍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ତାନ୍ ପେର୍‍କେ ଆଦ୍ ବୁତ୍ ଆଞ୍ଜ୍ ତାକିଂଙ୍କ୍ ଅନ୍‌ ପେର୍କେ ଦୁଷ୍ଟ ବୁତ୍‌କିଂଙ୍କ୍ ସାତ୍‍ଟାନ୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ତାତ୍‍ତା, ଆୱ୍‍ଚାରେ ବୁତ୍‌କ୍ ଆଦ୍ ନାରୁନ୍ ଲୋପ୍ ନେଙ୍ଗି ଅଣ୍ଡୟାଗ୍ ମାନ୍‍ତା । ଆସୁଟେ ଆଦ୍ ନାରୁଡ଼୍ ମୁନେଙ୍କ୍‍ତେ କେପି ପେର୍‍କେ ଗାଟି କାରାପ୍‍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ଜିସୁ ଆଦ୍ ସାରେ ଗଟି କେତ୍‍ତାନ୍ ଦିନାମ୍‍ତେ ମାନ୍ଦେ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ଅଣ୍ଡ୍‌ ନାଟାଡ଼୍ ଗାଟିବେଡ଼୍‍ୟ୍ ଲେଙ୍ଗ୍‍ତେ କେତ୍‍ତା, “ଦନ୍ୟ ମି ୟାୟ୍‍ । ଆଦ୍ ନିକିଂଙ୍କ୍ ଜନମ୍‍ଇତ୍ ନୁ ପାୟାଲ୍‍ ହୁସ୍‍ପ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ମାତର୍ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ଇଲା, ବେନଡ଼୍ ପରମେଶ୍ୱର୍‍ତେ ବାକ୍ୟ କେଞ୍ଜିତଡ଼୍, ମେଣ୍ଡେ ପାଲନ୍ ମାଡ଼ିତଡ଼୍, ପ୍ରକୃତ୍ ତେ ଆସତ୍ ନାରୁଡ଼୍ ଦନ୍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ନାର୍ଗେ ନାରୁଡ଼୍ ଜିସୁନାଗେ ଅଣ୍ଡୟ୍‌‍ ଆଦାଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ୱେରଡ଼୍ ଅଦାର୍ମିକିଡ଼୍ ବଂଶ । ଇଡ଼୍ ଅଣ୍ଡୟ୍‌ ବାକ୍‍ୱା ଚିହ୍ନତିଙ୍କ୍ ଉଡ଼ାନ୍‍ମାଇଦିଙ୍କ୍ ତାଲ୍‍କୁତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ଯୂନସ୍‍ତେ ଚିହ୍ନେ ୱିଡ଼୍‍ସି ୱେରେ ‍ଅଣ୍ଡୟ୍‌‍ ଚିହ୍ନେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହିଦାନାଦ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ଇତ୍କେ ଯୂନସ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ନୀନିବି ନାରୁଡ଼୍ ସେଙ୍ଗେ ଚିହ୍ନେତ୍‍ ଲେକାମ୍ ଆତ୍‍ତଣ୍ଡ୍, ଆଦେ ରକମ୍‍ ନାରୁନ୍‍ପିଲେ ଇଞ୍ଜେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ବଂଶତ୍ ମୁନେ ଚିହ୍ନେତ୍‍ ଲେକାମ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ଦକ୍ଷିଣ୍ ପାକା ଦେଶ୍‍ତାଦ୍ ଶିବା ରାଣିଲ୍ ବିଚାର୍ ଦିନାତେ ହି ବଂଶତ୍ ନାରୁଡ଼୍ ବିରୁଦ୍ ତେ ତେଦି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦଷି ମାଡ଼ିତ୍; କାରନ୍‍ ଆଦ୍ ଶଲୋମନ୍‍ତେ ବୁଦ୍‍ତେ ଗଟ୍ କେଞ୍ଜାଙ୍କ୍ ପୃତିବିତେ ପ୍ରନ୍ତତାଗାଙ୍କ୍ ୱାସ୍‍ମାତ୍‍ତା; ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଲୋମନ୍‍ତିଙ୍କ୍ ଅନ୍‌ ବେଡ଼୍‍ୟନ୍ ୱେରଣ୍ଡ୍ ହିଗ୍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ବିଚାର୍ ଦିନ୍‍ ନିନିବୀତେ ନାରୁଡ଼୍ ମିଇ ବିରୁଦ୍ଦ୍‌ତେ ଅବିଯଗ୍ ମାଡ଼ାଙ୍କ୍ ନିଲ୍‍ଦ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯୁନସ୍‍ତେ ପ୍ରଚାର୍ କେଞ୍ଜି ଅଡ଼୍‌ ପାପ୍ ଆର୍ଦାଗା ମାଲ୍‍ସ୍ ୱାତ୍‍ତଡ଼୍ । ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଯୁନସ୍‍ତାଗାଙ୍କ୍ ମହାନ୍ ୱେରନ୍ ହିଗେ ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ବେନ କୁପିତିଙ୍କ୍ ନିଡ଼୍‍ସ୍‍ପି ତାକିଂଙ୍କ୍ ଉଡ଼୍‍ପାର୍‍ୱା ପଡ଼୍‍ୟ୍‍ତାଗ୍, ମେଣ୍ଡେ, ବଡ୍ ମଦଲ୍ ମୁସି ୱାଟଡ଼୍, ମାତର୍ କୁପିତିଙ୍କ୍ ଦୀପରୂକା ପରକେ ୱାଟିତଡ଼୍, ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଲୋପ୍ ନେଙ୍ଗାନ୍ ନାରୁଡ଼୍ ୱେୟ୍‍ସିଇଙ୍କ୍ ଉଡ଼୍‍ ପାର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","କଣ୍ଡା ମେନ୍ଦୁଲ୍‍ତେ କୁପି ରକମ୍ । ବେସୁଙ୍କ୍‍ ମି କଣ୍ଡା‌ ସାୟ୍‍ ମାନ୍‍ତା, ଆସୁଙ୍କ୍ ମି ସାରେ ମେନ୍ଦୁଲ୍ କୁପି ଲେକାମ୍‍ ୱେୟ୍‍ସ୍ ଆଦ୍‍ତେ; ବାତେଙ୍କ୍ ଇତ୍କେ ବେସୁଙ୍କ୍‍ ମି କଣ୍ଡା କାରାପ୍ ଆଦ୍‍ତେ, ଆସୁଙ୍କ୍ ମି ମେନ୍ଦୁଲ୍ ଆନ୍‌‍ତେ ହିକାଡ଼୍‍ ଆଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ମିଡ଼୍ ସାବ୍‍ଦାନ୍, ବେଲା କି ମିୟାଦ୍ ହୃଦୟ୍‍ତେ ୱେୟ୍‍ସ୍ ଇକାଡ଼୍ ଆୟ୍‍ମାକି । ");
INSERT INTO kff_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଯଦି ମିୟାଦ୍ ମେନ୍ଦୁଲ୍ ସାରେ ୱେୟ୍‍ସ୍ ଆଦ୍ ତେ, ଆଗେତ୍ ବେନେ ଲେକାତ୍ ହିକାଡ଼୍ ମାନ୍‍, ହାଲାଇତ୍କେ କୁପି ମିକିଂଙ୍କ୍ ୱେୟ୍‍ସ୍ ମାଡ଼୍‍ତେ ଲେକାମ୍, ଆଦ୍‍ପୁଟୁଙ୍କ୍ ମି ମେନ୍ଦୁଲ୍‍ତେ ସାରେ ୱେୟ୍‍ସ୍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜିସୁ ଗଟି କେତ୍‍ତାନ୍ ତେର୍‍ସ୍‍ପି ୱେରଣ୍ଡ୍ ପାରୂଶୀ ଜିସୁଙ୍କ୍ ତାନ୍ ଲୋନ୍‌ ତିନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ କାର୍‍ଙ୍ଗତଣ୍ଡ୍ । ଆସୁଟେ ଜିସୁ ଆଦ୍ ଲୋନ୍‌ ନେଙ୍ଗି ତିନ୍‍ନ୍ଦାଙ୍କ୍ କୁଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ବାତେଙ୍କ୍ ଇତ୍କେ ତିନ୍ଦାନ୍ ମୁନେଙ୍କ୍ ଜିସୁ ଯିହୁଦୀ ରୀତି ଲେକାମ୍ କାୟ୍‍କ୍ ଡେକା ନର୍‍ୱାଙ୍କ୍ ଇଦ୍ ପାରୂଶୀ ଉଡ଼ି ବାକ୍‍ୱା ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ଆସୁଙ୍କ୍ ପ୍ରବୁଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ତ ଫାରୂଶୀନାରୁଡ଼ି ତାଲିଗିନାଙ୍କ୍ ବାୟ୍‍ଦେତ୍ ପାକେ ପରିଷ୍କାର୍ ମାଡ଼ୁତିଡ଼୍, ମାତର୍ ମି ଲୋପେ ବୁସାମାଡ଼୍‍ ତେ ପାଡ଼ିୟେ ନୁ କାରାପ୍ ନିଣ୍ଡିମିନ୍ଦେ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ହୋ ମଣ୍ଡି ନାରୁଡ଼ି, ବେନ ବାୟିଦେ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବାତ୍ ଲୋପ୍‍ଆନ୍‌‍ତେ ତିଆର୍ ମାଡ଼ଣ୍ଡ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ମିୟାଗ୍ ବାତା ମିନ୍ଦେ ଆୱ୍ ସାରେ ଗରିବ୍ ନାରୁଡ଼୍‍କ୍ ଦାନ ମାଡ଼ାଟ୍ ଆସୁଟେ ନିଜାତେ ସାରେ ପୁରା ପରିଷ୍କାର୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ହୋ ଫାରୂଶୀ ନାରୁଡ଼୍ ମିଡ଼୍ ଦଣ୍ଡତେ ପାତ୍ର ! ମିଡ଼୍ ସାରେ ବିଷୟ୍ ତେ ଦଶମାଂଶ ପରମେଶ୍ୱରତିଙ୍କ୍ ଇସ୍‌‍ମାନୁଟ୍ । ପୋଦିନା, ଆରୁଦ ନୁ ନ୍ୟାୟ ବିଚାର୍ ନୁ ପରମେଶ୍ୱର୍‍ତେ ପ୍ରେମତିଙ୍କ୍ ଗମାଡ଼୍ ମାଡ଼୍‍ମାଟ୍; ହିଦ୍ ସାରେ ପାଲନ୍ ମାଡ଼ିକାଡ଼୍ ବାଗାତ୍ ସାର୍‍ତିଙ୍କ୍ ଗମାଡ଼୍ ମାଡ଼ାନାଦ୍ ଲେକେତ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ହୋ ପାରୂଶୀନାରୁଡ଼ି, ମିଡ଼୍ ଦଣ୍ଡତେ ପାତ୍ର, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ସମାଜ୍ ଲୋତ୍‍ତାଗ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ଆଦାଙ୍କ୍ ନୁ ହାଟ୍ ବାଜାର୍‍ତାଗ୍ ନମସ୍କାର୍ ଦର୍‍କାଙ୍କ୍ ସାୟେ ପ୍ରେମ ଇଞ୍ଜ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ହୋ, ମିଡ଼୍ ଦଣ୍ଡତେ ନାରୁଡ଼୍‌ ଆଦ୍‍ତିଡ଼୍, କାରନ୍‍ ମିଡ଼୍ ମିଞ୍ଜି ମାନ୍ଦାନ୍ ସମାଦି ଲେକାମ୍; ଆଦିନ୍ ପରୁ ନାରୁଡ଼୍ ପୁନକଟ ତାକିଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ଆସୁଟେ, ୱେରଣ୍ଡ୍ ଶାସ୍ତ୍ରୀ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ଇଦ୍ କେସ୍ ନିମେ ମାକିଂଙ୍କ୍ ଆନ୍‌‍ତେ ଅପ୍‍ମାନ୍ ମାଡ଼ୁତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ଆଦ୍ ‍କେଞ୍ଜି ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, ହୋ ଦର୍ମଶାସ୍ତ୍ରନାରୁଡ଼ି ହାୟ, ମିଡ଼୍ ନାରୁଡ଼୍ ପରୁ କଷ୍ଟତ୍ ନିୟମ୍‍ତେ ବୋଜ୍ କାଞ୍ଜ୍‍ପିସ୍ ମିନ୍ଦେଡ଼ି ଯେ, ଆଦିଙ୍କ୍ କଞ୍ଜାନଙ୍କ୍ କଷ୍ଟ ଆଦୁତ୍‍ତେ । ହି ନିୟମ୍‍ତିଙ୍କ୍ କେଞ୍ଜାନଙ୍କ୍ ମିଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତିଆର୍ ମାଡ଼ୁତିଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ନିଜେ ବେସୁଟ୍‌ ଆନ୍‌‍ତେ ହିଗାଙ୍କ୍ ୱେରଡ଼୍ ମେଣ୍ଡେ ନିୟମ୍ ପାଲନ୍ ମାଡ଼ାଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ମିଡ଼୍ ଦଣ୍ଡ ଆଦ୍‍ତିଡ଼୍ ! ମିଡ଼୍ ବାବବାଦୀଡ଼ାଦ୍‍ ସମାଦି ସୁନ୍ଦର୍ ତିଆର୍ ମାଡ଼ୁତିଡ଼୍, ବେନଡ଼କ୍ ମି ମୁନେତ୍ ନାରୁଡ଼୍ ଆୱ୍‍କି ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ମିଡ଼୍ କେଞ୍ଜୁତିଡ଼୍ ଯେ ମି ଆନିଦାଦିଡ଼୍ ବାତେଏ ମାଡ଼୍‍ତଡ଼୍ ଆଦିଙ୍କ୍ ମିଡ଼୍ ତଡ଼େକ୍ ମାଡ଼ୁତିଡ଼୍, ଅଡ଼୍‌‍ ବାବବାଦୀଡ଼୍‍କ୍ ହାୱ୍‍କ୍‍ତଡ଼୍ ମେଣ୍ଡେ ମିଡ଼୍ ଅଡ଼ାୱୁ ସମାଦି ତିଆର୍ ମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ପରମେଶ୍ୱର୍ ଆନ୍‌‍ତେ ନିଜର୍ ବୁଦ୍‍ତେ କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ନାନେ ଅଡ଼୍‌‍ ଗାର୍‍ରେ ବାବବାଦୀନଡ଼କ୍ ନୁ ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍‍କ୍ ରହ୍‍ତିତାନ୍, ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍କିଂଙ୍କ୍ ଅଡ଼୍‌‍ ଆୱ୍‍କିତଡ଼୍ ନୁ ମେଣ୍ଡେ ବାଗାତଡ଼୍‍କିଙ୍କ୍ ତାଡ଼ନା ମାଡ଼ିତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଇଦ୍ ଯୁଗ୍‍ତେ ନାରୁଡ଼୍ ପୃତିବିତେ ତିଆର୍ ମୁନେଙ୍କ୍ ସାରେତଡ଼୍ ବାବବାଦୀଡ଼୍ ହାୱୁକ୍‍ତେ ସେଙ୍ଗେ ଦଣ୍ଡ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ହେବଲ୍‍ତେ ହାୱୁକ୍‍ତେ ଆରାମ୍ ମାଡ଼ି ଯିକରୀୟନ୍ ହେଉନା ବେନଡ଼୍‍କ୍ ବେଦୀ ନୁ ପବିତ୍ର ପଡ଼ିୟେତାଗ୍ ହାୱୁକ୍‍ତେ ମାଡ଼ିମାତ୍‍ତଡ଼୍ । ହଁ, ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ ଇଦ୍ ଯୁଗ୍‍ତେ ନାରୁଡ଼୍ ଦଣ୍ଡ ଆଦ୍‍ତଡ଼୍ । ତିଆର୍ ଆତ୍‍ତାଗାଙ୍କ୍ ବେସ୍‍କ୍‍ତଡ଼୍ ବବିଷ୍ୟଦ୍ ବକ୍ତାଲଡ଼୍ ନେତୁର୍‍ ଇସ୍‍ମିନ୍ଦେ, ଆଦିନ୍‌ମାଇଦିଙ୍କ୍ ହି ଦିନାମ୍‍ତେ ଜିୱୁନ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଦଣ୍ଡ ଆଦ୍‍ଦେ ୱେୟ୍‍ତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ହୋ ଦର୍ମଶାସ୍ତ୍ରୀଡ଼୍ ! ମିଡ଼୍ ଦଣ୍ଡ ଆଦ୍‍ତିଡ଼୍, ମିଡ଼୍ ପରମେଶ୍ୱର୍‍ତେ ଜ୍ଞାନତାଦ୍ କୁଚ୍‍କାଇତିଙ୍କ୍ ମିଞ୍ଜ୍‍ପିତିଡ଼୍, ବେଦ୍ ଜ୍ଞାନତାଦ୍ ହାର୍‍ଦିଙ୍କ୍ ଟେଣ୍ଡି । ମିଡ଼୍ ନିଜେ ଐଶ୍ୱରିକ୍ ବୁଦ୍‍ ନାଡ଼ସ୍‍ୱିଡ଼୍ କି, ବେନଡ଼୍ ନାଡ଼୍‍ସାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆନ୍‌‍ତେ ନାଡ଼୍‍ସାଙ୍କ୍ ହିୱୀଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଆସୁଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍ ଆଗାଙ୍କ୍ ପେୟିସ୍ ଆଦ୍‍ଦାନ୍ ୱେୟେ ଶାସ୍ତ୍ରୀଡ଼୍ ନୁ ପାରୂଶୀଡ଼୍ ଗାଟି ଇର୍ଷା ବା କପାମ୍ ଆସ୍, ");
INSERT INTO kff_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ବେସ୍‌କ୍ ବୁଲ୍ ଗଟ୍ କେସ୍ ଉଡ଼ୁଇତାଗ୍ ରାପାନଙ୍କ୍ ହାର୍ ମେହେକ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ହଜାର୍‌ ହଜାର୍‌ ନାରୁଡ଼୍ ୱାସ୍ ଅଣ୍ଡୟାଗ୍ ଗୁଡ଼୍‍ପି ଆଦ୍‍ତଡ଼୍ । ନାରୁଡ଼୍ ୱେରନ୍ ପରୁ ୱେରନ୍ ତାଲ୍‍ଗା ତାଲ୍‍ଗି ଆସମାତ୍‍ତଡ଼୍ । ଜିସୁ ମୁନେ ତାମ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ପାରୂଶୀନାରୁଡ଼୍ କପଟ‍ତାଗାଙ୍କ୍ ଜେଏକେ ମାନୁଟ୍ । ନାନ୍ କେତାନାଦ୍ ଲେକାମ୍‌ ଆଦୁତ୍‍ତେ ଯେ, ଅଡ଼୍‌‍ ଦୁଷ୍ଟ ନାରୁଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ବାତେଏ ତଅନ୍‌ଦ, ଇଦ୍‍ରକତାଦ୍ ବାତେ ମୁସ୍‍ତାଦ୍ ଇଲେ, ବାତେ ପୁନ୍ଦାନଙ୍କ୍ ଆୟ, ଇସତାଦ୍‍ ମିଞ୍ଜ୍‍ତାଦ୍ ବାତେ ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ମିଡ଼୍ ବାତା ହିକାଡ଼୍ ତାଗ୍ କେସମିନ୍ଦେଡ଼ି, ଆୱ୍‍ଚାରେ ପାୟାଲ୍ କେଞ୍ଜ୍‍ପାଙ୍କ୍ ୱେୟ୍‍ତିତ୍, ମେଣ୍ଡେ, ବାତେଏ ତନ୍ଦ୍‍ୱେ ଲୋତ୍‍ତାଗ୍ ମିଞ୍ଜିମିକା କେସ୍ ମିନ୍ଦେଡ଼ି, ଆଦିଙ୍କ୍ ଲୋତ୍‍ତେ ମୁର୍ସିନାଗ୍‍ ଆଞ୍ଜ୍ କେସିଦ୍‍ ୱେୟ୍‍ତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ବାତେଙ୍କ୍ ଇତ୍କେ ନା ସାଙ୍ଗଡ଼ି ଯେ, ମିଡ଼୍, ମିକିଂଙ୍କ୍ ନାନେ କେତୁତାନ୍, “ବେନଡ଼୍ ମି ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ରେହେତିତଡ଼୍, ମାତର୍ ତାନ୍ ପେର୍‍କେ ମେଣ୍ଡେ ଅଡ଼୍‌‍ ବାତା ମାଡ଼ା ପାର୍‍ୱଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେର୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ବେନଙ୍କ୍ ୱେର୍‍ଦ୍‍ତିଡ଼୍, ଆଦ୍ ନାନେ ମିକିଂଙ୍କ୍ କେତିତାନ୍; ଡୋଲ୍‍ତେ ପେର୍‍କେ ନର୍‍କତାଗ୍‍ ହେସାଙ୍କ୍ ବେନେ ଇଶ୍ୱର୍ କାଇଦେ ଅଦିକାର୍‌ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ୱେର୍‍ମୁଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍ କେତୁତାନ୍, ଅଂକିଙ୍କ୍‌ ୱେର୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ଏଇଙ୍ଗ୍ ଆନାପିଟେ ବାତେଏ ସୁଦୁଟ୍ ଡାବ୍ ତେ ୱାମାଙ୍କ୍ ଆୟ୍‍ୟ କି ? ମିକା ପରମେଶ୍ୱର୍‍ ହାୱିନାଗାଙ୍କ୍ ୱେରଡିଙ୍କ୍ ମେଣ୍ଡେ ମାର୍‍ଙ୍ଗେ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ବାତେଙ୍କ୍ ଇତ୍କେ ମି ତାଲେତ୍ କେଲ୍‍କିଙ୍କ୍ ସାରେ ଲେକିମିନ୍ଦେଣ୍ଡ୍ । ୱେର୍‍ମାଟ୍; ମିଡ଼୍ ଆନାପିଟେ ନାଗାଙ୍କ୍ ଗାଟି ମୁଲ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ମେଣ୍ଡେ ନାନେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ବେନନ୍ ନାରୁଡ଼୍‍ତେ ମୁନ୍‍ ନାକିଂଙ୍କ୍ ସ୍ୱୀକାର୍‍ ମାଡ଼ିତନ୍, ନାରୁନ୍‍ପିଲେ ଆନ୍‌‍ତେ ପରମେଶ୍ୱର୍‍ତେ ଦୂତକିନ୍ ମୁନ୍‍ କେତିତଣ୍ଡ୍ ଯେ, ଆଦ୍ ନାରୁଡ଼୍ ନା ନିଜର୍ ନାରୁଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ବେନ ନାରୁଡ଼୍ ମୁନ୍‍ ନାକିଂଙ୍କ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ିତନ୍, ନାରୁଡ଼୍ ପିଲେ ପରମେଶ୍ୱର୍‍ତେ ଦୂତକିନ୍ ମୁନ୍‍ କେତିତଣ୍ଡ୍ ଯେ, ଆଦ୍ ନାରୁଡ଼୍ ନା ନିଜର୍ ନାରୁଡ଼୍ ଆୟ୍‍ୟଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ବେନ ନାରୁନ୍‍ପିଲେତ୍‍ ବିରୁଦ୍ଦ୍‌ତେ ଗଟି କେତିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ କ୍ଷମା ଇଦାଙ୍କ୍ ଆଦ୍‍ତେ; ମାତର୍ ବେନ ପବିତ୍ର ଆତ୍ମାତ୍ ବିରୁଦ୍ଦ୍‌ତେ ନିନ୍ଦା ଗଟି କେତିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ କ୍ଷମା ଇଦାଙ୍କ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ଅଡ଼୍‌‍ ବେସୁଙ୍କ୍‍ ମିକିଂଙ୍କ୍ ସମାଜ୍‍ଲନ୍, ରାଜ୍ୟପାଳ, ବିଚାର୍ ମାଡ଼ାନଣ୍ଡ୍ ମୁନ୍‍ନେ ବିଚାର୍ ମାଡ଼ାଙ୍କ୍ ଆଦ୍‍ତଡ଼୍, ଆସୁଙ୍କ୍ ମିଡ଼୍ ବେଲା ଉତ୍ତର୍ ହିଦ୍‍ତିଡ଼୍ ମେଣ୍ଡ୍ ବାତ୍ କେତିତିଡ଼୍ ଆଦ୍ ବିଷୟତେ ସୁଦୁର୍ ମେଣ୍ଡେ ଚିନ୍ତା ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ବାତେଙ୍କ୍ ଇତ୍କେ ବାତେଏ କେତାଙ୍କ୍ ଆଦ୍‍ତେ ଆଦ୍ ସମୟ୍ ତେ ପବିତ୍ର ଆତ୍ମା ମିକିଂଙ୍କ୍ ନାଡ଼୍‍ସ୍‍ପିଦ୍‍ ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ନା ଦାଦାଲ୍‌ ନା ତଡ଼୍ ବାବାନ୍ ସମ୍ପତ୍ତିତିଙ୍କ୍ ୱିର୍‍ସ୍‍ପାନ୍ ମାଇଦିଙ୍କ୍ କେସିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ସାଙ୍ଗ, ବେନ ନାକିଂଙ୍କ୍ ମି ପରୁ ବିଚାର୍ ମାଡ଼ାଙ୍କ୍ ବା ସମ୍ପତ୍ତି ୱିର୍‍ପାଙ୍କ୍ ବେନ ନାକିଂଙ୍କ୍ ଅଦିକାର୍ ହିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତୁତଣ୍ଡ୍, “ସାବ୍‍ଦାନ୍, ସାରେ ଲେକାମ୍ ଆଶେତାଗାଙ୍କ୍ ନିଜ୍‍ତିଙ୍କ୍ ଜେକେ ନେହେମ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ୱେରନ୍ ନାରୁନାଦ୍ ଜିୱୁନ୍ ଅନ୍‌‍ୱାଦ୍ ସମ୍ପତ୍ତି ସାରେତେ ପରୁ ଆଶେ ମାଡ଼ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଆସୁଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦ୍ ୱେଷଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, ୱେରଣ୍ଡ୍ ସାଉକାର୍ ନାରୁନ୍ ୱାୟେତାଗ୍ ଗାଟି ପସଲ୍ ଆତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ଆସୁଟେ ଆଦ୍ ନାରୁଡ଼୍ ହେର୍କେ ଆଲ୍‍ସି କେତ୍‍ତଣ୍ଡ୍, ବାତା ମାଡ଼ିତାନ୍ ? ବାତେଙ୍କ୍ ଇତ୍କେ ନାୟାଦ୍ ସାରେ ଗୁଡ଼୍‍ପି ନେହେତାନ୍ ମାଇଦିଙ୍କ୍ ପଡ଼୍‍ୟ୍ ଇଲା । ");
INSERT INTO kff_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ମେଣ୍ଡେ, ଆଦ୍ ନାରୁନ୍ କେତ୍‍ତଣ୍ଡ୍, ଇଦ୍‍ପୁଟୁଙ୍କ୍ ମାଡ଼ିତାନ୍; ନାୟାଦ୍ ଅମାର ସାରେ ହୁଉସୁ ବେଡ଼୍‍ୟା ତିଆର୍ ମାଡ଼ିତାନ୍ ନୁ, ଆୱ୍ ‍ଚାରେତାୱିନାଗ୍ ନାୟାୱୁ ଶସ୍ୟ ନୁ ନିୟ୍ ଗୁଡ଼୍‍ପି ମାଡ଼ି ନେହ୍‍ତିତାନ୍, ");
INSERT INTO kff_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଆସୁଟେ, ନାନେ ନାୟାଦ୍ ଜିୱୁନ୍‍ତିଙ୍କ୍ କେତିତାନ୍, ହୋ ଜିୱୁନ୍, ନାର୍ଗେ ୱାଡ଼୍‍ଷାତ୍ ମାଇଦିଙ୍କ୍ ନିୟାଦ୍ ନିୟ୍ ତିଆର୍‍ତେମିନ୍ଦେ, ରମାଟ୍, ତିନ୍ଦାନାଦ୍ ମାଡ଼ାଟ୍, ପାନ ମାଡ଼ାଟ୍ ନୁ ସାର୍‍ଦା ମାଡ଼ାଟ୍; ");
INSERT INTO kff_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ବାତେଙ୍କ୍ ଇତ୍କେ ପରମେଶ୍ୱର୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ରେ ମଣ୍ଡି, ନେଣ୍ଡ୍ ନାର୍କା ନି ଜିୱୁନ୍‍ତିଙ୍କ୍ ନିୟାଗାଙ୍କ୍ ଆଦ୍‍ତାନ୍; ଆସୁଟେ ନିମେ ବାତା ନିଜର୍ ସେଙ୍ଗେ ହକ୍‍ରିଞ୍ଚିମିନ୍ଦେନୀ, ହାଉସାରେ ବେନନାୱୁ ଆଦ୍‍ତେ ? ");
INSERT INTO kff_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ବେନ ନିଜର୍ ମାଇଦିଙ୍କ୍ ଦନ୍ ଗୁଡ଼୍‍ପି ମାଡ଼ିତନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଇଶ୍ୱର୍ ତେ ମୁନେ ସାଉକାର୍ ଆୟ୍‍ୟଣ୍ଡ୍, ଅନ୍‌ ସେଙ୍ଗେ ଇଦ୍‍ପୁଟୁଙ୍କ୍ ଗଟେମ୍ ଆଦ୍ ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଇ ବିଷୟ୍ ତେ ନାନେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ବାତା ତିନ୍‍ତିଡ଼୍ ଇଦ୍‍ପୁଟୁଙ୍କ୍ ଆଲ୍‍ସି ମି ଜିୱୁନ୍‍ ତେ ମାଇଦିଙ୍କ୍, ମେଣ୍ଡେ, ବାତା କେର୍‍ଦ୍‍ତିଡ଼୍, ଇଦ୍‍ପୁଟୁଙ୍କ୍ ଆଲ୍‍ସି ମି ମେନ୍ଦୁଲ୍‍ତେ ମାଇଦିଙ୍କ୍ ଆନ୍‌‍ତେ ଚିନ୍ତେ ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ବାତେଙ୍କ୍ ଇତ୍କେ ତିନ୍ଦାନାଦ୍ କନ୍‍ସ୍ ଜିୱୁଣ୍ଡ୍ ନୁ ଚକାସିଲେ କନ୍‍ସ୍ ମେନ୍ଦୁଲ୍‍ତେ ବେଡ଼୍‍ୟା । ");
INSERT INTO kff_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ପାର୍‍ତାନ୍ ପିଟେଙ୍କ୍ ଉଡ଼ାଟ୍, ଆହ୍ ୱିତ କି କୟ୍‍ୟ, ମେଣ୍ଡେ, ଆୱିନ୍ ତିନ୍ଦାନ୍ ଲୋନ୍‌ ଇଲେକି ନେହ୍‍ତାନାଦ୍‍ ଅମାର ଇଲା, ବାତେଙ୍କ୍ ଇତ୍କେ ପରମେଶ୍ୱର୍‍ ଆୱିଙ୍କ୍ ତିନ୍ଦାଙ୍କ୍ ହିଦ୍‍ତଣ୍ଡ୍; ମିଡ଼୍ ତ ପିଟେଙ୍କ୍ ଆନ୍‌‍ତେ ବେସତ୍ ଗାଟି ଯଗ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ମି ଲୋପ୍ ବେନ ଚିନ୍ତେ ମାଡ଼ି ମାଡ଼ି ନିଜର୍ ଆୟୁସ୍‍ତିଙ୍କ୍ ମେଣ୍ଡେ ସୁଦୁର୍ ଦିନାମ୍‍ତିଙ୍କ୍ କାଲ୍‍ପିତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ଆଲାତ୍କେ ମିଡ଼୍ ଯଦି ସୁଦୁରାୱ୍ ପାଡ଼ିୟିମାଡ଼୍ ପାର୍‍ୱିଡ଼୍, ହାଲାଇତ୍କେ ମେଣ୍ଡେବାଗାତ୍ ବେଡ଼୍‍ୟା ପାଡ଼ିୟ୍‍ତେ ମାଇଦିଙ୍କ୍ ବାତେଙ୍କ୍ ଦାନ୍ଦେ ଆଦୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ପୁଙ୍ଗାନ୍ ବିଷୟତେ ହେର୍କା ମାଡ଼ାଟ୍, ଆୱ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ପେର୍‍ସ୍‍ତା ? ମେଣ୍ଡେ ଆୱ୍ ପାଡ଼ିୟି ମାଡ଼ କି ନୁଲ୍ ଆଲ୍‍ସ; ବାତେଙ୍କ୍ ଇତ୍କେ ନାନେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ବେନ ସାର୍‍ତିଙ୍କ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍, ନୁ ସାଉକାର୍ ରାଜାଲ୍ ଶଲୋମନ୍‍ ଆନ୍‌‍ତେ ଅନାଦ୍‌ ସାରେ ସମ୍ପତିତିଙ୍କ୍ ଆୱ୍ ପୁଙ୍ଗାନ୍ ଲୋପେଙ୍କ୍ ବେନେଆଇ ୱେରଡ଼୍ ତେ ଲେକାମ୍ ମିକା ସୁନ୍ଦର୍ ଚକା କେର୍‍ଦାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ୱାୟାନାଗା ବେନ ପୁଙ୍ଗା ନେଣ୍ଡ୍ ମିନ୍ଦେ, ଆୱିଙ୍କ୍ ନାଡ଼୍ ଅୟ୍‌ଦାଲ୍‌ କିସ୍‍ତାଗ୍ ୱାଟାନାଦ୍, ଆୱିଙ୍କ୍ ଯଦି ପରମେଶ୍ୱର୍‍ ଇସତ୍ ଲେକ୍‍ତାଦ୍ ହିଦ୍‍ତଣ୍ଡ୍, ଆଲାତ୍କେ; ହାୟ ସୁଦୁର୍ ବିଶ୍ୱାସୀନାରୁଡ଼ି, ଅନ୍‌ ମିକିଂଙ୍କ୍ ବେଚର୍ ନାର୍ଗେ ହିୱ୍‍ଣ୍ଡ୍ ଆଦ୍‍ତନ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ମିଡ଼୍ ବାତା ତିନ୍‍ତିଡ଼୍, ମେଣ୍ଡେ ବାତା ଉନ୍ତିଡ଼୍, ଆୱିଙ୍କ୍ ମିଡ଼୍ ମେହେକ୍‍ମାଟ୍ ବା ଚିନ୍ତେ ମାଡ଼୍‍ମାଟ୍ ");
INSERT INTO kff_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ବାତେଙ୍କ୍ ଇତ୍କେ ଜଗତ୍ ତେ ବିଜାତିନାରୁଡ଼୍ ହିସତ୍ ବିଷୟ ତେ ମେହେକ ହୁଡିତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍କେ ଆୱ୍‍ଚାର୍ ବିଷୟ ମିକିଂଙ୍କ୍ ଆନ୍‌‍ତେ ଦର୍‍କାର, ଆଦ୍ ମି ପରମେଶ୍ୱର୍‍ ପୁତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ମିଡ଼୍ ଅନ୍‌ ରାଜ୍ୟତ୍ ମାଇଦିଙ୍କ୍ ହେର୍କା ମାଡ଼ାଟ୍, ଆଲେକେ ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ଇଦ୍ ସାର୍‍ରେବିଷୟ୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ହୋ ସୁଦୁର୍ ମାନ୍ଦେମେଣ୍ଡା, ୱେର୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମିକିଂଙ୍କ୍ ଆ ରାଜ୍ୟ ହିଦାନ୍‍ମାଇଦିଙ୍କ୍ ମି ପରମେଶ୍ୱର୍‍ ଇଚ୍ଛାମାଡ଼ୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ମିୟାୱୁ ବାତା ମିନ୍ଦେ, ଆୱିଙ୍କ୍ ୱାମି ଗରିବ୍ ନାରୁଡ଼୍‍କ୍ ଦାନ ମାଡ଼ାଟ୍; ବାତେଏ ନଷ୍ଟ ଆୟ୍‍ୟ, ଆସତ୍ ପଡ଼ିୟ୍‍ତାଗ୍ ନିଜର୍ ମାଇଦିଙ୍କ୍ ୱିଜ୍‍ ନେହ୍‍ମୁଟ୍; ବେଗେ ଡଙ୍ଗାଲଡ଼୍ ଗାର୍‍ୱାଡ଼ଡ଼୍ ବା ପୁଡ଼୍‍ୟି ନଷ୍ଟ ମାଡ଼, ଆସତ୍ ସ୍ୱର୍ଗତାଗ୍ ତେର୍‍ୱେ ଦନ୍‍ସମ୍ପତ୍ତି ଅସ୍‍ରିଞ୍ଚାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ବାତେଙ୍କ୍ ଇତ୍କେ ବେଗେ ମିୱାଦ୍ ଦନ୍‍ସମ୍ପତ୍ତି, ଆଗେ ମିକା ମିୱାଦ୍ ମନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ପାଡ଼ିୟିତେ ମାଇଦିଙ୍କ୍ ସାରେଦାମ୍ ତିଆର୍ ଆଶେ ମାନୁଟ୍ । ମି କୁପିତିଙ୍କ୍ ନିଡ଼୍‍ସ୍‍ପିମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ପ୍ରବୁ ପେଣ୍ଡୁଲ୍‍ତାଗ୍ ମାଞ୍ଜ୍ ମାଲ୍‍ସ୍ ୱାସ୍ ହାର୍‍ଦାଗ୍ ତାଲ୍‍ସାନ୍ ୱେଇ ବେନ୍ ନାରୁଡ଼୍ ଅନ୍‌ ମାଇଦିଙ୍କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ କାପାଟ୍ ତେର୍‍ସିଦାଙ୍କ୍ କେପି ମାନ୍‍ତଡ଼୍, ମିଡ଼୍‍ଆନ୍‌‍ତେ ଅଡ଼୍‌‍ ଲେକାମ୍ ଆସ୍ ମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ପ୍ରବୁ ୱାସ୍ ବେନ୍ ଚାକରିଡ଼୍ ତିଆର୍‍ତେ ମାନ୍‍ତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଡ଼ିତଣ୍ଡ୍, ଅଡ଼୍‌‍ ଦନ୍ୟ; ନାନେ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ମାଲିକ୍ ଆନ୍‌‍ତେ ଅଡ଼୍‌‍ ସେବା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ନିଜେ ତିଆର୍ ଆଦ୍‍ତନ୍ । ଅନ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କୁଦାନ୍ ମାଇଦିଙ୍କ୍ କେତିତଣ୍ଡ୍, ନୁ ନିଜେ ଅଣ୍ଡ୍‌ ତିନ୍ଦାଙ୍କ୍ ଇଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଆସୁଟେ, ଅନ୍‌ ଯଦି ରେଣ୍ଡ୍ କି ମୁଣ୍ଡ୍ ନାଡ୍‍ନାର୍କା ୱାସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରକମ୍ ଉଡ଼ିତଣ୍ଡ୍, ଆଲାତ୍କେ ଆଦ୍ ଚାକରିଡ଼୍ ଦନ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦ୍ ପୁଞ୍ଜ୍ ମାନୁଟ୍, ବେସୁଟ୍‌ ଡଙ୍ଗାଲ୍ ୱାଦ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଯଦି ଲତ୍‌ତେ ମାଲିକ୍ ପୁନେଣ୍ଡ୍, ଆଲାତ୍କେ ତାମ୍ ଲୋନ୍‌ ଡଙ୍ଗାଙ୍କ୍ ନେଙ୍ଗାଙ୍କ୍ ହିୱଣ୍ଡ୍ ଆୟେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ମିଡ଼୍ ଆନ୍‌‍ତେ ତିଆର୍ ଆଶେ ମାନୁଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁନ୍‍ପିଲେ ଜିସୁ ଇସତ୍ ଦିନାମ୍‍ତେ ୱାଦ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଦିନାମ୍‍ତେ ମିଡ଼୍ ହେର୍କା ମାଡ଼କଟ୍ ମାନ୍‍ତିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ଆସୁଟେ ପିତର୍ କେତ୍‍ତଣ୍ଡ୍, “ହୋ, ପ୍ରବୁ, ନିମେ ବାତ୍ ମାକିଂଙ୍କ୍ କେତୁତିନ୍ ନା ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଇଦ୍ ୱେଷଡ଼୍ କେତୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ପ୍ରବୁ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍, ଆଲେକ୍ ବିଶ୍ୱାସ୍‌ତେ ନୁ ଜ୍ଞାନି ଦାସ ବେନ ? ବେନଙ୍କ୍ ମାଲିକ୍‍ତେ ଲୋନ୍‌ ତୁୱୁସାନ୍ ମାଇଦିଙ୍କ୍ ନେହିତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଲେକେତ୍ ନାରୁଡ଼୍ ମେଣ୍ଡେ ଦାସଡ଼୍‍କିଂଙ୍କ୍ ତିନ୍ଦାଙ୍କ୍ ଇତ୍‍ତନ୍ । ଅଣ୍ଡ୍‌ ଲେକେତ୍ ଦିନାମ୍‍ତେ ନାରୁଡ଼୍‍କ୍ ତିନ୍ଦାଙ୍କ୍ ଇଦ୍‍ତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ପ୍ରବୁ ୱାସ୍ ବେନ୍ ଦାସ ଆଦ୍ ରକମ୍ ମାଡ଼ାନାଦ୍ ଉଡ଼ିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଦନ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ନାନେ ମିକିଂଙ୍କ୍ ନିଜାମ୍ କେତୁତାନ୍, ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ନିଜର୍ ସାରେ ସମ୍ପତି ପରୁ ଦାୟିତ୍ୱ ଇଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ବାତେଙ୍କ୍ ଇତ୍କେ ହେର୍କେ ମାଡ଼ାଟ୍, ଆଦ୍ ଦାସ୍ ଲୋପ୍ ଲୋପ୍ କେତିତଣ୍ଡ୍, ନା ପ୍ରବୁ ୱାଦାନାଦ୍ ଗାଟି ଲେଟ୍ଆଦ୍‍ତେ, ଆସୁଟେ ଅନ୍‌ ଯଦି ଦାସ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରେହେତା ରେହେତି ମାଡ଼ିତନ୍ ମେଣ୍ଡେ, ତିଞ୍ଜ୍ ଉଞ୍ଜ୍ ମାତ୍‍ୱାରି ଆଦାଙ୍କ୍ ଆରାମ୍ ମାଡ଼ିତନ୍, ");
INSERT INTO kff_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ଆଲାତ୍କେ ବେନ୍ ‍ଦିନ୍ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ମାଡ଼କଟ୍ ମାନ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ, ବେନ୍ ଦିନାମ୍ ତେ ଅନ୍‌ ପୁନକଟ ମାନ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଦିନାତେ ନୁ ଆଦ୍ ଦିନାମ୍ ତେ ଆଦ୍ ଦାସ୍ ତେ ମାଲିକ୍ ୱାସ୍ ହେୱ୍‍ଦ୍‍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ଗାଟି ଦଣ୍ଡ୍ ହିଦ୍‍ତଡ଼୍ ନୁ ଅବିଶ୍ୱାସ୍ ଆୟ୍‍ୱିଡ଼୍ ନାରୁଡ଼୍ ତଡ଼୍ ପାଲ୍‍କ୍ ତୁଉସିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ଆସୁଟେ, ବେନ୍ ଦାସ୍ ନିଜର୍ ପ୍ରବୁନ୍ ଇଚ୍ଛାତିଙ୍କ୍ ପୁଞ୍ଜ୍ ବା ତିୟାର୍ ଆୟ୍‍ୟକଟ ମାନ୍‍ତଣ୍ଡ୍, ଆଲାତ୍କେ ଅନ୍‌ ଇସଲେକାତେ ପାଡ଼ିୟି ମାଡ଼କଟ୍ ମାନ୍‍ତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ଗାଟି ଦେବେତେ ପରୁ ଦେବ୍‍ ଦର୍‍କିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ବାତେଙ୍କ୍ ଇତ୍କେ ବେନ ପୁନକଟ ଦେବ୍‍ ତିନ୍ଦାଙ୍କ୍ ପାଡ଼ିୟ୍‍ ମାଡ଼ିମାନ୍‍ତଣ୍ଡ୍; ଅନ୍‌ ସୁଦୁର୍ ଦେବ୍‍ ତିନ୍‍ତଣ୍ଡ୍ । ବେନଙ୍କ୍ ଗାଟି ଦେବ୍‍ ଦର୍‍କି ମିନ୍ଦେ, ଅନ୍‌ ଆଗାଙ୍କ୍ ଗାଟି ଦାବୀ ମାଡ଼୍ ୱେୟ୍‍ତିତ୍; ମେଣ୍ଡେ, ନାରୁଡ଼୍ ବେନନାଗେ ଗାଟି ଇତ୍‍ତନ୍ ମାଡ଼ି ମିନ୍ଦେଡ଼୍, ଅନାଗାଙ୍କ୍ ଗାଟି ଦାବୀମାଡ଼୍ ୱେୟ୍‍ତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ନାନ୍ ପୃତିବିତାଗ୍ କିସ୍‍ ରାପାନ୍ ମାଇଦିଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେନ୍, ମେଣ୍ଡେ, ଆଦ୍ କିସ୍‍ ନିଡ଼୍‍ୱି ଇଦ୍ ନାୱାଦ୍ ବାତେଏ ଇଚ୍ଛା ! ");
INSERT INTO kff_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ବାତେଙ୍କ୍ ଇତ୍କେ ନାକିଂଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ବାପ୍ତିସ୍ମ ଇସ୍‌ ଆଦ୍ ୱେୟ୍‍ତିତ୍ ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ତେରୱେ ଯାକ ନାନେ ଯେ, ବେସର୍ ଦାନ୍ଦେ ଆଦୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ନାନେ ପୃତିବିତାଗ୍ ଶାନ୍ତି ଇଦାଙ୍କ୍ ୱାସ୍ ମିନ୍ଦେନ୍ ଇଞ୍ଜ ବାତ୍ ମିଡ଼୍ ଆଲ୍‍ସ ମିନ୍ଦେଡ଼ି ? ନାନେ ମିକିଂଙ୍କ୍, କେତୁତାନ୍, ଇଲା, ନାନେ, ପୃତିବୀତିଙ୍କ୍ ୱେରେ ମାଡ଼ାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେନ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ଅଣ୍ଡୟ୍‌ ଲୋନ୍‌ ଯଦି ଏୟ୍‍ୱୁଡ଼୍ ଡ଼ାଗାଙ୍କ୍‌ ରାମ୍‌କ୍‌ ସୃଷ୍ଟି ଆଦ୍‌ତେ, ଆଲାତ୍କେ ଇର୍‍ୱୁଡ଼୍ ବିରୁଦ୍ ତେ ମୁୱୁଡ଼୍ ନୁ ମୁୱୁଡ଼୍ ବିରୁଦ୍ ତେ ଇର୍‍ୱୁଡ଼୍ ତେଦିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ବାବାନ୍ ବିରୁଦ୍ ତେ ମାର୍‍, ମାର୍‍ ବିରୁଦ୍‍ତେ ବାବାଲ୍, ମାୟାଡ଼୍ ବିରୁଦ୍ ତେ ୟାୟ, ୟାୟନ୍ ବିରୁଦ୍ ତେ ମାୟ୍‍ୟାଡ଼୍, କଡ଼୍‍ୟାଡ଼୍‍ ବିରୁଦ୍ ତେ ପୟେ, ନୁ ପୟେନ୍ ବିରୁଦ୍ ତେ କଡ଼୍‍ୟାଡ଼୍ ତେଦିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଜିସୁ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତେତ୍‍ତଣ୍ଡ୍ ପଶ୍ଚିମ୍‍ତେ ପାକେ ମାବ୍ ତେଦାନାଦ୍ ଉଡ଼୍ କେ ମିଡ଼୍ ସାଙ୍ଗେ ସାଙ୍ଗେ କେଲ୍‍ମୁଟ୍, ୱାର୍‍ସାମ୍ ୱାଦୁତ୍, ଆଦ୍‍ଲେକାମ୍ ଗଟେମ୍ ଆଦ୍ ତେ । ");
INSERT INTO kff_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ମେଣ୍ଡେ, ଦକ୍ଷିଣ୍ ପାକେତ୍ ଗାଲ୍ ୱାଦୁତ୍ ଇତ୍‍କେ, ମିଡ଼୍ କେଲ୍‍ମୁଟ୍, ଏଦ୍ ତାର୍‍ଦିତେ, କେତ୍‍କେ ଆଲେ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ରେ ମଣ୍ଡିଡ଼ି, ମିଡ଼୍ ପୃତିବି ନୁ ମାବ୍‍ତିଙ୍କ୍ ଉଡ଼ି ୱାର୍‍ସାମ୍ ପାଗ୍ ବିଷୟତେ କେତେ ପାର୍‌ଦ୍‌ତିଡ଼୍; ଆଗେକ୍‍ବା ଇଞ୍ଜେତ୍ ଯୁଗ୍‍ତାଦ୍ ପରିକ୍ଷାସାରେ ପୁନ୍ଦାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ମେଣ୍ଡେ, ନିଜେ ନିଜେ ବାତେଙ୍କ୍ ସାୟେତାଦ୍ ବିଚାର୍ ମାଡ଼୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଯଦି ବେନ ମିକିଂଙ୍କ୍ ମକଦମା ମାଡ଼ି ବିଚାର୍ ଲୋତ୍‍ତାଗ୍ ଆଦ୍‍ତନ୍, ଆସୁଟେ ଅନ୍‌ ତଡ଼୍ ନିଜର୍ ବିଷୟତେ ନିଲ୍‍ପ୍‍ତେ ମାଡ଼ାଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ିତି । ଯଦି ଆଲା ମାଡ଼କ୍ ଅଣ୍ଡ୍‌ ନିକିଂଙ୍କ୍ ବିଚାର୍ କର୍ତ୍ତାନ୍ ଗାର୍‍ରେ ଆଦ୍‍ତନ୍ ନୁ ଅଣ୍ଡ୍‌ ନିକିଂଙ୍କ୍ ପୁଲିସିଡ଼୍ କାଇଦେ ପସ୍‍ପିଦ୍‍ତଣ୍ଡ୍ ନୁ ପୁଲିସିଡ଼୍ ନିକିଂଙ୍କ୍ କାରାଗାର୍‍ ତାଗ୍ ୱାଟିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ନାନେ ନିକିଂଙ୍କ୍ କେତୁତାନ୍, ନି ପର୍‍ର ୱାଟ୍‍ତେ ସାରେ କାମ୍‍ଦେନନ୍‍ ୱେରନ୍ ପାଇସା ମିକା ଇୱେଯାକ ନିମ୍‍ ଆଗାଙ୍କ୍ କଲାସ୍ ଆଦାଙ୍କ୍ ପାର୍‍ୱିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ଆଦ୍ ଦିନାମ୍ ତେ ଆଗେ ମାନ୍ଦାନ୍ ବେସ୍‍ତୁଡ଼୍ ନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍ ଯେ, ଗାଲିଲୀୟ ନାରୁଡ଼୍ ଇଶ୍ୱର୍‌ ତେ ଗାର୍‍ରେ ବଲି ଉତ୍ସର୍ଗ ମାଡ଼ାନ୍ ୱେଲେ ପିଲାତ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହାୱ୍‍କି ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ଆସୁଟେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ବାତ୍ ଆଲ୍‍ସୁତିଡ଼୍ ଯେ, ହି ନାରୁଡ଼୍ ଗାଲିଲୀୟ ନାର୍‍ଦେ ଲୋପେଙ୍କ୍ ଗାଟି ପାପି ମାତ୍‍ତଡ଼୍ ଇଞ୍ଜ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦ୍ ହାୱୁକ୍‍ତେ ଆଦ୍ ୱେୟ୍‍ତା କି ? ");
INSERT INTO kff_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ନାନେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଇଲା, ବାତେଙ୍କ୍ ଇତ୍କେ ପାପତାଗାଙ୍କ୍ ମନ୍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼କଟ୍ ମାତ୍‍କେ ମିଡ଼୍‍ଆନ୍‌‍ତେ ସାରେ ରକମ୍ ନଷ୍ଟ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ଶିଲୋହତାଗ୍ ବେଲା ୱେରନ୍ ନାରୁଡ଼୍ ପରୁ ବେଡ଼୍‍ୟାଦ୍‍ ଲୋନ୍‌‍ ଉର୍‍ଙ୍ଗି ରାଲ୍‍ତେ, ମିଡ଼୍ ବାତ୍ ଆଲ୍‍ସୁତିଡ଼୍ ? ଅଡ଼୍‌‍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ୱିଡ଼୍‍ସି ଅଦିକ୍‌ ପାପି ମାତ୍‍ତଡ଼୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ନାନେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଇଲା, ବାତେଙ୍କ୍ ଇତ୍କେ ପାପତାଗାଙ୍କ୍ ମନ୍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼କଟ୍ ମାତ୍‍କେ ମିଡ଼୍‍ଆନ୍‌‍ତେ ସାରେ ରକମ୍ ନଷ୍ଟ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଆସୁଟେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦ୍ ୱେଷଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, “ୱେରନ୍ ଅଙ୍ଗୁର୍ ଗୁଡ଼େତାଗ୍ ୱେରଡ଼୍ ତୟେମାଡ଼ା ମାତ୍‍ତା, ଅଣ୍ଡ୍‌ କାୟାନ୍ ସେଙ୍ଗେ ମାଡ଼େତ୍ ଗାର୍‍ରେ ଆତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବାତେମିକା ଦର୍‍କ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ଆସୁଟେ ଅଣ୍ଡ୍‌ ଆଦ୍ ବଗିଚାତେ ମାଲିକ୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଉଡ଼େ, ମୁଣ୍ଡ୍ ଏଣ୍ଡ୍ ଆଦୁତ୍‍ ନାନେ ୱାସ୍ ହି ତୟେମାଡ଼୍‍ତାଗ୍‍ କାୟା ମେହ୍‍କୁତାନ୍, ଇତ୍କେ ଦର୍‍ସ୍‍କାନଙ୍କ୍ ପାର୍‍ୱନ୍‍; ଇଦିଙ୍କ୍‍ ନାଡ଼୍‍କି ଏସାଟ୍‍ ବାତେଙ୍କ୍‍ଇତ୍‍କେ ଇଦ୍‍ ବୂମ୍‌ଦିଙ୍କ୍‍ ମିକା ନଷ୍ଟ ମାଡ଼ୁତେ । ");
INSERT INTO kff_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ବାତେଙ୍କ୍ ଇତ୍କେ ଚାକର୍ ମାଲିକ୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ୱେରଡ଼୍ ଏଣ୍ଡେତ୍ ମାଇଦିଙ୍କ୍ ଇଦିଙ୍କ୍ ୱିଡ଼୍‍ସିମ୍, ନାନେ ଇଦିଙ୍କ୍ ଚାର୍‍ପାକା ଡେୱିମେଣ୍ଡେ କାତାମ୍ ହିଦ୍‍ତାନ୍, ");
INSERT INTO kff_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ୱାଦାନ୍ ଏଣ୍ଡ୍ ଯଦି ହି ମାଡ଼େତାଗ୍ କାୟା ଆଦିତ୍‍ ହିତ୍‍କେ ତ ସାୟ୍ । ଇଲୁକ୍‍ ଆଦକଟ ମାତ୍‍କେ ଆସୁଟେ ହି ମାଡ଼େତିଙ୍କ୍ ନାଡ଼୍‍କିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ଅଣ୍ଡ୍‌‍ଦାମ୍‍ ଜିସୁ ବିଶ୍ରାମ୍‍ଦିନାତେ ୱେରଡ଼୍ ଯିହୁଦୀ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ଲୋନ୍‌ ଶିକ୍ଷା ହିସମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ଆଗେ ୱେରଡ଼୍ ନାଟାଡ଼୍ ମାତ୍‍ତେ ବେଲା କି ଅଟ୍ର ଏଣ୍ଡ୍ ଯାକ ଅଣ୍ଡୟ୍‌ ବୁତ୍ ଆତ୍ମା ତେ ମୁର୍ଗ ଆଶେ ମାତ୍‍ତେ । ନିଜ୍‍ତିଙ୍କ୍ ବେଲାମେଣ୍ଡେ ମାଡ଼ି ତିନାଙ୍କ୍ ଆଦାଙ୍କ୍ ପାର୍‍ୱକଟ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜିସୁ ତାକିଂଙ୍କ୍ ଉଡ଼ି ଗାର୍‍ରେ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, ହୋ ନାଟାଡ଼୍‍ତି, ନି ଦୁର୍ବଲ୍‍ତାଗାଙ୍କ୍ ମୁକ୍ତ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଆସୁଟେ, ଜିସୁ ତାନ୍ ପରୁ କାୟ୍ ୱାଟ୍‍ତଣ୍ଡ୍, ଆସୁଟେ, ଆଦ୍ ନାଟାଡ଼୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ତିନାଙ୍କ୍ ଆସ୍ ନିସ୍ ପର୍‍ମେଶ୍ୱରତ୍ ମହିମା ବା ସ୍ତୁତି ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ବିଶ୍ରାମ୍‍ଦିନାତେ ସୁସ୍ଥ ମାଡ଼୍ ତାଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ‍ଲୋତ୍‍ତେ ମୁକ୍ୟାଲ୍ କପାମ୍ ଆସ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପାଡ଼ିୟ୍‍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଆରୁଦିନା ଦିନାମ୍ ମିନ୍ଦେ । ଆଦ୍ ଦିନାତେ ୱାସ୍ ସୁସ୍ଥ ଆୟ୍‍ମୁଟ୍, ବିଶ୍ରାମଦିନା ତେ ୱାଡ଼୍‍ମାଟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ବାତେଙ୍କ୍ ଇତ୍କେ ପ୍ରବୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ମଣ୍ଡିଡ଼ି ମିଡ଼୍ ବାତ୍ ବିଶ୍ରାମ୍‍ଦିନାତେ ମି ଗଡ୍‌କିଂଙ୍କ୍ କି ଗଦତିଙ୍କ୍ କଟାତାଗାଙ୍କ୍ ୱିଡ଼୍‍ସି ହେର୍‍ ହୁସ୍‍ପାଙ୍କ୍ ବାୟିଦେ ଆୟ୍‍ୱିଡ଼୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ଆଦ୍ ଅଣ୍ଡୟ୍‌ ଅବ୍ରାହାମ୍‌ତେ ବଂଶତେ ପିକିଡ଼୍ । ଶୟ୍‍ତାନ୍‍ ତାକିଂଙ୍କ୍ ଅଟ୍ର ଏଣ୍ଡ୍ ଆଇନା ତହ୍‍ସ୍‍ମାତ୍, ବିଶ୍ରାମ୍‍ଦିନାତେ ଆଦ୍ ମୁକ୍ତ ବା ସୁସ୍ଥ ଆଦ୍‍ଦାନ୍ ଲେକେତ୍ ଇଲେ କି ?” ");
INSERT INTO kff_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଇଦ୍ ଗଟ୍ ତାମ୍ ଶିଷ୍ୟଡ଼କ୍ ସିଗ୍ ମାଡ଼୍‍ତେ, ଆଗେକ୍‍ବା ତାମାଦ୍ ବାକ୍‍ୱା ପାଡ଼ିୟିତ୍ ମାଇଦିଙ୍କ୍ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ସାର୍‍ଦା ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ଆସୁଟେ ଜିସୁ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ପରମେଶ୍ୱର୍‍ତେ ରାଜ୍ୟ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ? ମେଣ୍ଡେ, ନାନେ ହିଦିଙ୍କ୍ ବେନନ୍ ତ ସାମାନ୍‍ ମାଡ଼୍‍ପାର୍‍ଦ୍‍ ତାନ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ପରମେଶ୍ୱର୍‍ତେ ରାଜ୍ୟ ଅଣ୍ଡୟ୍‌ ସୋରିଷ ପେଡ଼େମ୍‍ତେ ଲେକାମ୍ । ୱେରନ୍ ନାରୁଡ଼୍ ଆଦ୍ ସୋରିଷ ପେଡ଼େମ୍‍ତିଙ୍କ୍ ଅଣ୍ଡ୍‌ ବଗିଚାତାଗ୍ ୱିତିତଣ୍ଡ୍ । ପେଡ଼େମ୍‍ତାଗାଙ୍କ୍ ଗାଜ୍‍ଜେ ପେୟ୍‍ସ୍‍ ମାଡ଼ା ଆଦ୍ ତେ ଆଦ୍ ମାଡ଼୍‍ତେ କମ୍‍ତାଗ୍ ପିଟେ ତୁଉକା ତାରିତା ।” ");
INSERT INTO kff_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜିସୁ ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ପରମେଶ୍ୱର୍‍ତେ ରାଜ୍ୟତିଙ୍କ୍ ବେନନ୍ ତ ସାମାନ୍‍ ମାଡ଼୍‍ପାର୍‍ଦ୍‍ ତାନ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ଇଦ୍ ଅଣ୍ଡ୍‌ କମୀରତେ ଲେକାମ୍ । ୱେରଡ଼୍ ନାଟାଡ଼୍ ରୂଟି ତିଆର୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ବେଡ଼୍‍ୟାଦ୍‍ ଗିନେତାଗ୍ ମାନ୍ଦାନ୍ ଅଟା ତଡ଼୍ ହି କମୀରତିଙ୍କ୍ କାଲ୍‍ପିତ୍ । କମୀର ଅଟାତିଙ୍କ୍ ତୟ୍‍ପିତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ଜିସୁ ସାରେ ନାର୍ ନୁ ନାର୍ ଆଞ୍ଜ୍ ଶିକ୍ଷା ହିସମାତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ତାକି ଯିରୁଶାଲେମ୍‍ତ୍‍ ପାକେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ଆସୁଟେ, ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ ବେସ୍‍ତୁଡ଼୍ ନାରୁଡ଼୍ ପରିତ୍ରାଣ ଆଦ୍ ପାର୍‍ଦ୍‍ତଡ଼୍ ? ବାତେଏ ସୁକୁକେ ନାରୁଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ସୁଦୁରାଦ୍ ହାର୍‍ଇସ୍ ସ୍ୱର୍ଗତାଗ୍ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ାଟ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ନାନେ କେତୁତାନ୍, ନାର୍ଗେମାନ୍ଦେ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ିତଡ଼୍ ? ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଲୋତ୍‍ତେ ମାଲିକ୍ ତେଦି କାପାଟ୍‍ତିଙ୍କ୍ ବନ୍ଦ୍ ମାଡ଼୍‍ତେ ପେର୍‍କେ, ମିଡ଼୍ ବାୟିଦେ ନିସ୍ ମେଣ୍ଡେ କାପାଟ୍‍ତିଙ୍କ୍ ତାଲ୍‍ସିତିଡ଼୍, ବା ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତିତିଡ଼୍, ମାଲିକ୍, ମା ମାଇଦିଙ୍କ୍ କାପାଟ୍‍ ତେର୍‍ସିମ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ କେତିତଣ୍ଡ୍, ମିଡ଼୍ ବେନେ ଜାଗେତେ ନାରୁଡ଼ି, ବା ବେଗାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେଡ଼ି, ନାନେ ଆଦ୍ ପୁନନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ତାନ୍ ପେର୍‍କେ ମିଡ଼୍ କେତିତିଡ଼୍, ନିମ୍‍ ନୁ ମାମ୍ ଅଣ୍ଡୟାଗେ ମାଞ୍ଜ କାୟ୍‍ଲି ତିତ୍‍ତାଡ଼୍ । ନିମେ ମା ନାର୍ ଶିକ୍ଷା ଇସ୍‌‍ମାତିନ୍ ");
INSERT INTO kff_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ଆସୁଟେ, ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ବେନେ ପାଡ଼୍‍ଗେତେ ନାରୁଡ଼ି, ବା ବେଗାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେଡ଼ି, ନାନେ ଆଦ୍ ପୁନନ୍ । ମିଡ଼୍ କାରାପ୍‍ ପାଡ଼୍‌ୟି ମାଡ଼ାନ୍ ନାରୁଡ଼ି, ନାୟାଗାଙ୍କ୍ ଜେକା ଆୟ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ବେସୁଙ୍କ୍‍ ମିଡ଼୍ ଅବ୍ରାହାମ୍‌, ଇସ୍‍ହାକ୍ ନୁ ଯାକୁବ୍ ନୁ ସାରେ ବାବବାଦୀଡ଼୍ ପରମେଶ୍ୱର୍‍ତେ ରାଜ୍ୟତାଗ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼ିତଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍କେ ନିଜେ ବାୟିଦେ ରାଲିମାନ୍ଦାନାଦ୍ ଉଡ଼ିତଡ଼୍, ଆସୁଙ୍କ୍ ଆଗେ ନିଜେ କେୟାନାଦ୍ ନୁ ପାଲ୍‍କ୍ କିଟ୍‍ରୁମ୍ କାଟ୍‍ରୁମ୍ ଆଦାନାଦ୍ କେଞ୍ଜିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ପୂର୍ବ ନୁ ପଶ୍ଚିମ୍, ଉତ୍ତର୍ ନୁ ଦକ୍ଷିଣ୍‍ପାକେତ୍ ନାରୁଡ଼୍ ୱାସ୍ ପରମେଶ୍ୱର୍‍ତେ ରାଜ୍ୟତାଗ୍ ତିନ୍ଦାଙ୍କ୍ କୁଦିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଆସୁଟେ ଉଡ଼ାଟ୍, ବେନଡ଼୍ ଇଞ୍ଜେ ପେର୍‍କେ ମାନ୍ଦାନଡ଼୍ ବେସ୍‍ତୁଡ଼୍ ମୁନ୍‍ ଆଦ୍‍ତଡ଼୍ ମେଣ୍ଡେ, ମୁନ୍‍ ମାନ୍ଦାନଡ଼୍ ବେସ୍‍ତୁଡ଼୍ ପେର୍‍କେ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ଆଦ୍ ଦିନାମ୍ ତେ ବେସ୍‍ତୁଡ଼୍ ପାରୂଶୀ ନାରୁଡ଼୍ ୱାସ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ହି ପଡ଼ିୟ୍ ୱିଡ଼୍‍ସି ବେଗ୍‍ଆୟି ଅନ୍‌ । ବାତେଙ୍କ୍ ଇତ୍କେ ହେରଦ୍ ରାଜାଲ୍ ନିକିଂଙ୍କ୍ ଆୱ୍‍କାଂଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଆନୁଟ୍, ଆଦ୍ କଙ୍ଗାନାକାତିଙ୍କ୍ କେଲ୍‍ମୁଟ୍, ନାନେ ନେଣ୍ଡ୍ ନୁ ନାଡ଼୍ ବୁତ୍‌କିଂଙ୍କ୍ ତଲିତାନ୍ ମେଣ୍ଡେ ନୁ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ିତାନ୍, ମୁଣ୍ଡ୍ ଦିନାତେ ନା ପାଡ଼ିୟ୍‍ ତେରିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ବେଲାମେଣ୍ଡେ ଆୟି, ନାକିଂଙ୍କ୍ ନେଣ୍ଡ୍, ନାଡ଼୍ ନୁ ମାନେଟି ଯାକ ଆଦ୍‍ ୱେୟ୍‍ତିତ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଯିରୁଶାଲେମ୍‍ତେ ବାୟିଦେ ବାବବାଦୀଡ଼୍ ଡୋଲାନାଦ୍ ଲେକେତ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ହୋ ଯିରୁଶାଲେମ୍ ହୋ ଯିରୁଶାଲେମ୍ ନିମେ ତ ବାବବାଦୀ ଲଡ଼୍‍କିଙ୍କ୍ ଆୱ୍‍କ୍‌ତି । ବେନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପରମେଶ୍ୱର୍‍ ନି ଗାର୍‍ରେ ରୟ୍‍ସ୍‍ ମାତ୍‍ତେ, ନିମେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାଲ୍‍କ୍ ହେସି ରେହେତିଡ଼୍‍ । ୱେରଡ଼୍ କୋର୍‍ ତାନ୍ ରେକାନ୍ ମଦଲ୍ କୋର୍‍ପିଲାଙ୍କ୍ ଅଣ୍ଡୟ୍‌‍ୟାଗ୍ ଗୁଡ଼୍‍ପାନ୍ ଲେକାମ୍, ନାନେ ମି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଣ୍ଡୟ୍‌‍ୟାଗ୍ ଗୁଡ଼୍‍ପାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିମାତ୍‍ତାନ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଆଦ୍ ଲେକାମ୍ ମାଡ଼ାଙ୍କ୍ ହିୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ଉଡ଼େ, ନିୟାଦ୍ ମନ୍ଦିର୍‍ତିଙ୍କ୍ ମି ନାରୁଡ଼୍ ୱିଡ଼୍‍ସିତ୍‍ତଡ଼୍ । ନାନେ ନିକିଂଙ୍କ୍ କେତୁତାନ୍, “ପ୍ରବୁନ୍ ପେଦେର୍ ତେ ବେନ ୱାଦୁତଣ୍ଡ୍, ଅନ୍‌ ଦନ୍ୟ, ଇଦ୍ କେଲ୍‍ୱେ ଯାକ ନିମ୍‍ ନାକିଂଙ୍କ୍ ମେଣ୍ଡେ ଉଡ଼୍ ପାର୍‍ୱିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ଅନ୍‌‍ଦାମ୍ ବିଶ୍ରାମ୍‍ଦିନାତେ ଜିସୁ ୱେରଣ୍ଡ୍ ପାରୂଶୀ ନାରୁଡ଼୍ ନେତାନ୍ ଲୋନ୍‌ ତିନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଆଗେ ଜିସୁଙ୍କ୍ ସାୟ୍ ଲକ୍ଷ ମାଡ଼ି ଉଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ଆସୁଟେ ଉଡ଼େ, ଜିସୁନ୍ ମୁନେ ୱେରଣ୍ଡ୍ ଜଲଦର ରୋଗ୍‍ତେ ନାରୁନ୍‌ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ଜିସୁ ପାରୂଶୀନଡ଼କ୍ ନୁ ଦର୍ମଶାସ୍ତ୍ରୀନଡ଼କ୍ କେତ୍‍ତଣ୍ଡ୍, ବିଶ୍ରାମ୍‍ଦିନାତେ ସୁସ୍ଥ ମାଡ଼ାନାଦ୍ ଟିକ୍ ନିୟମ୍‍ ନା ଆୟ ? ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ କଟ ଆଶେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ଆସୁଟେ, ଜିସୁ ଆଦ୍ ନାରୁଙ୍କ୍ ପୟିସ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ରୟ୍‍ସିତ୍‍ ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ଆସୁଟେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍‌ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ମି ଲୋପେଙ୍କ୍ ବେନନ୍ ମାର୍‍ କି ଗଡ୍‌କନ୍ଦ୍‌ ବିଶ୍ରାମ୍‍ଦିନ୍‍ ତେ ନୂୟ୍‍ଦାଗ୍‍ ରାଲ୍‍କେ, ମିଡ଼୍ ବାତେଏ ତାକିଂଙ୍କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ତେୟ୍‍ସ୍ ତାଡ଼୍‍ୱିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଆଦ୍ ବିଷୟ ତେ ବାତ୍ ଉତ୍ତର୍ ଇଦ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ଜିସୁ ଉଡ଼୍‍ତଣ୍ଡ୍ ଯେ, ବେସ୍‍ତୁଡ଼୍ କୁଟ୍‍ମାମ୍‍ ତଡ଼୍ କୁଦାନ୍‍ ମାଇଦିଙ୍କ୍ ସାୟେତ୍ କେତ୍‌ ମେହ୍‍କ ମାତ୍‍ତଡ଼୍ । ଆସୁଟେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହି ୱେଷଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ଯଦି ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ନିକିଂଙ୍କ୍ ପେଣ୍ଡୁଲ୍‍ତାଗ୍ କାର୍‍ଙ୍ଗୁତଣ୍ଡ୍, ଆଲାତ୍କେ ସାର୍‍ତିଙ୍କ୍ ମୁକ୍ୟ କୁର୍‍ସ୍‍ତାଗ୍‍ କୁଦ୍‍ମା । ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ନାରୁଡ଼୍ ନିକିଂଙ୍କ୍‌ ଆନ୍ତେ ଅଦିକ୍‌ ବେଡ଼୍‍ୟ୍ ନାରୁଡ଼୍ କାର୍‍ଙ୍ଗି ମାନ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ନିମ୍‍ ଯଦି ସାର୍‍ତିଙ୍କ‍ ଅନ୍‌ ମୁକ୍ୟ ଆସନ୍ ତାଗ୍ କୁଦି ମାନ୍‍ତି, ଆଲାତ୍କେ ନିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ୱାସ୍ କେତିତଣ୍ଡ୍, ହି ନାରୁଙ୍କ୍ ନିୟାଦ୍ ଆସନ୍ ହିମ୍ । ଆସୁଙ୍କ୍ ନିକିଂଙ୍କ୍ ଗାଟି ଅପ୍‍ମାନ୍ ଆଦ୍ ତେ । ");
INSERT INTO kff_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ବେସୁଙ୍କ୍‍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ନିକିଂଙ୍କ୍ ବଜିତାଗ୍ କାର୍‍ଙ୍ଗୁତଣ୍ଡ୍ ଆସୁଟେ, ନିମେ ୱେରଡ଼୍ ସୁଦୁରାଦ୍ ଆସନ୍ ତାଗ୍ କୁଦ୍ । ଆସୁଙ୍କ୍ ନିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତେ ନାରୁଡ଼୍ ୱାସ୍ ନିକିଂଙ୍କ୍ କେତିତଣ୍ଡ୍, ହୋ ସାଙ୍ଗ, ନିମେ, ହିଗେ କୁଦକଟ ସୁଦୁର୍ ମୁନ୍‍ୱାସ୍ ହି ସାୟେତ୍ ଆସନ୍ ତାଗ୍ କୁଦ୍‍ । ଆସୁଙ୍କ୍ ବାଗାତଡ଼୍ ୱାସ୍‍ମାନ୍ଦାନ୍ କୁଟ୍‍ମାମ୍‍ ଆନ୍‌‍ତେ ନିକିଂଙ୍କ୍ ସମ୍ମାନ୍ ଇଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ବେନ୍ ନାରୁଡ଼୍ ନିଜ୍‍ତିଙ୍କ୍ ମହାନ୍ ଇଞ୍ଜ ଆଲ୍‍ସିତିଡ଼୍, ଅଂକିଙ୍କ୍‌ ହୀନ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍ । ବେନ୍ ନାରୁଡ଼୍ ନିଜ୍‍ତିଙ୍କ୍ ହୀନ ଇଞ୍ଜ ଆଲ୍‍ସିତିଡ଼୍, ଅଂକିଙ୍କ୍‌ ମହାନ୍ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ଜିସୁ ଅଂକିଙ୍କ୍‌ କାର୍‍ଙ୍ଗି ମାନ୍ଦାନ୍ ପାରୂଶୀ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନିମେ ବେନଙ୍କ୍ ଆୟି ପାୟାଲ୍ ବା ନାର୍କାତେ ତିନ୍ଦାଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତେ ୱେୟ୍ ମାତର୍ ନି ଦାଦାଲ୍‌, ସାଙ୍ଗଙ୍କ୍, କୁଟୁମାମ୍‍ ସାଉକାର୍‍ରିଡ଼୍ ନୁ ଗାରେତଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମେଣ୍ଡନ୍‍ଦାମ୍ ଦାମ୍ ଅଡ଼୍‌‍ ଆନ୍‌‍ତେ ନିକିଂଙ୍କ୍ ଅଡ଼୍‌‍ ତ ତିନ୍ଦାଙ୍କ୍ କାର୍‍ଙ୍ଗି ତଡ଼୍ । ଆସୁଙ୍କ୍ ନିମେ ନିୟାଦ୍ ସାରେଦାନ୍ ଦର୍‍ସ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ବାତେଙ୍କ୍ ଇତ୍କେ ବୋଜି ହିଦାନ୍ ଦିନାମ୍ ତେ ଗୋରିବ୍, ପଙ୍ଗୁ, କୁଟାଲଡ଼୍‍କ୍ ନୁ କାନାଲଡ଼୍‍କିଙ୍କ୍ କାର୍‍ଙ୍ଗାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ହି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବାତା ହିଲ୍‍ୱାଙ୍କ୍ ସାରେବଦଲ୍‍ ତେ ବାତା ଇଦ୍ ପାର୍‍ୱଡ଼୍ । ଆଲାତ୍କେ ମି ମାଇଦିଙ୍କ୍ ଆର୍ଶିବାଦ୍ ଆଦ୍ ତେ । ବାତେଙ୍କ୍ ଇତ୍କେ ବେସୁଙ୍କ୍‍ ଦାର୍ମିକ୍ ନାରୁଡ଼୍ ଡଲ୍‍ତେ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ତେଦିତଡ଼୍, ଆଦ୍ ଦିନାମ୍ ତେ ମିଡ଼୍ ମିୟାଦ୍ ପୁରସ୍କାର୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ଜିସୁନ୍ ତ ତିନ୍ଦାଙ୍କ୍ କୁଦି ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ୱେରନ୍ ନାରୁଡ଼୍ ହି ସାରେ ଗଟି କେଞ୍ଜି ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପରମେଶ୍ୱର୍‍ତେ ରାଜ୍ୟତାଗ୍ ତିନ୍ଦାନ୍ ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ଗାଟି କୁସି ବା ସାର୍‍ଦା ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ୱେରଡ଼୍ ବେଡ଼୍‍ୟାଦ୍‍ ବଜି ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ନାର୍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍ ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ତିନ୍ଦାନ୍ ଦିନାମ୍ ଆଦାଙ୍କ୍ ଅଣ୍ଡ୍‌ କୁଟ୍‍ମାମ୍ କାର୍‍ଙ୍ଗାନ୍ ମାଇଦିଙ୍କ୍ ନିଜର୍ ଚାକର୍‍ତିଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍, ୱାଡ଼ାଟ୍, ତିନ୍ଦାନାଦ୍ ସାରେ ତିଆର୍‍ତେ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ବାତେଙ୍କ୍ ଇତ୍କେ କାର୍‍ଙ୍ଗ୍‍ତେ ନାରୁଡ଼୍ କେତ୍‍ତଡ଼୍ ଯେ, ଅଡ଼୍‌‍ ଆଦେ ପାର୍‍ୱଡ଼୍ । ମୁନେ ନାରୁଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, ନାନେ ଇଞ୍ଜେ ୱେରନ୍ ୱାୟା ଆସ୍‍ତାନ୍ । ଆଦ୍ ୱାୟାଙ୍କ୍ ଉଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ନାକିଂଙ୍କ୍ ଇଞ୍ଜ୍ ଆଦ୍ ୱେୟ୍‍ତିତ୍ । ଦୟା ମାଡ଼ି ନାକିଂଙ୍କ୍ କ୍ଷମା ହିମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ କେତ୍‍ତଣ୍ଡ୍, ନାନେ ଏଇଙ୍ଗ୍ ହେଣ୍ଡ୍‍କ୍ ଗଡ୍‌କନ୍ଦା ଆସିମିନ୍ଦେନ୍ । ନାନେ ଆୱିଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଆଦ୍‍ଦାନ୍ ମିନ୍ଦେ । ଦୟା ମାଡ଼ି ନାକିଂଙ୍କ୍ କ୍ଷମା ମାଡ଼ା । ");
INSERT INTO kff_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ତୃତୀୟ ନାରୁଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, ନାନେ ପୁଃନେ ପୁଃନେ ପେଣ୍ଡୁଲ୍ ଆତ୍‍ତାନ୍‍, ନାନ୍ ଆଦ୍‍ପାର୍‍ୱନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ଆସୁଟେ, “ଚାକର୍ ମାଲ୍‍ସ୍ ୱାସ୍, ମାଲିକ୍‍ତିଙ୍କ୍ ସାର୍‍ରେଗଟି କେସିତ୍‍ତଣ୍ଡ୍, ମାଲିକ୍ ଆଦ୍ ଗଟି କେଞ୍ଜି ଗାଟି କପାମ୍ ଆତ୍‍ତଣ୍ଡ୍ ବା, କେତ୍‍ତଣ୍ଡ୍, ସିଟ୍‍ପାଟ୍ ନାର୍ ଗଲିକିନାଗ୍ ଆଞ୍ଜ୍ ଦରିଦ୍ର, ପଙ୍ଗୁ, କାନାଲଡ଼କ୍ ନୁ କୁଟା ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ତାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ପେର୍‍କେ ଚାକର୍ ମାଲ୍‍ସ୍ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, ମାଲିକ୍ ନିମେ ବାତ୍ କେତ୍‍ତିନ୍, ଆଦ୍ ନାନେ ମାଡ଼୍‍ତାନ୍ । ମେଣ୍ଡେ, ପେର୍କେ ନାରୁଡ଼୍ ମାଇଦିଙ୍କ୍ ପଡ଼ିୟେ ମାୟ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ମାଲିକ୍ ଚାକର୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ରାଜଆର୍‍ତା ନୁ ନାର୍‍ଦେ ଆର୍‍ଦା ଆଞ୍ଜ୍ । ଆଗେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ୱାଦାନ୍ ମାଇଦିଙ୍କ୍ କେଲ୍‍ମ୍ । ନାନେ ଆଲ୍‍ସୁତାନ୍, ନା ଲୋନ୍‌‍ ପୁରାପୁରି ନିଣ୍ଡି ଇଞ୍ଜ । ");
INSERT INTO kff_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ନାନ୍ ମି ସାରେତଡ଼୍‌କିଂଙ୍କ୍ କେତୁତାନ୍, ବଜିତାଗ୍ କାର୍‍ଙ୍ଗ୍ ତେ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ବେନ ନାୱାଦ୍ ବଜି ତିନ୍ଦାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ଅନ୍‌‍ଦାମ୍ ନାର୍ଗେ ନାରୁଡ଼୍ ଜିସୁନ୍ ତ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍ । ଜିସୁ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ଯଦି ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ନା ଗାର୍‍ରେ ୱାଦ୍‍ତଣ୍ଡ୍, ଯଦି ନାକିଂଙ୍କ୍‍ ୱିଡ଼୍‍ସି ତେ ୟାୟ୍‍ବାବାଙ୍କ୍, ମୁତ୍‍ତେ, ପିଲାଙ୍କ୍, ଏଲାଡ଼୍‍ ତାମୁଣ୍ଡ୍‌ତିଙ୍କ୍‌ ଜିୱୁଣ୍ଡ୍‍ତେ ପ୍ରେମ୍ ମାଡ଼ମାନ୍‍ତଣ୍ଡ୍, ଆସତ୍‍ ନାରୁଡ଼୍ ହିତ୍‍କେ ନା ଶିଷ୍ୟ ଆଦ୍ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ନିଜର୍ କ୍ରୁଶତିଙ୍କ୍ କାଞ୍ଜି ନା ପେର୍‍କେ ତାକକଟ୍‍ ମାତ୍‍କେ, ଆସତ୍‍ ନାରୁଡ଼୍ ନା ଶିଷ୍ୟ ଆଦ୍ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ମିଡ଼୍ ଯଦି କେପାନ୍ ଲୋନ୍‌ ମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍, ଆଲାତ୍କେ ମିଡ଼୍ କୁଦି ମୁନେ ଚିହ୍ନେ ମାଡ଼ାନ୍ ମିନ୍ଦେ ଯେ, ଇଦିନ୍‍ ମାଇଦିଙ୍କ୍ ବେସର୍ କର୍ଚ୍ଚ ଆଦ୍‍ତେ । ମିଡ଼୍ ହିସାପ୍ ମାଡ଼ି ଉଡ଼ାନ୍ ମିନ୍ଦ୍ ଯେ, ପାଡ଼ିୟି ମାଡ଼ାନାଦ୍ ତେର୍‍ନା ଯାକ ମିୟାଗ୍ ଡାବ୍ ମିନ୍ଦେ କି ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଯଦି ମୁର୍ସ ମାଡ଼ି ଲୋନ୍‌‍ ତେର୍‍ସ୍‍ପେ ପାର୍‍ୱଣ୍ଡ୍, ସାର୍‍ତଡ଼୍ ଆଦିଙ୍କ୍ ଉଡ଼ାନ୍ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ପରିହାସ୍ ମାଡ଼ିତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ଅଡ଼୍‌‍ କେତିତଡ଼୍, ହି ନାରୁଣ୍ଡ୍ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ବାତେଙ୍କ୍ ଇତ୍କେ ତେର୍‍ସ୍‍ପାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ୱେରଣ୍ଡ୍ ରାଜାଲ୍‍ ମେଣ୍ଡେଅର୍‍ତୁନ୍‍ ରାଜାନ୍ ବିରୁଦ୍ ତେ ଯୁଦ୍‌ ମାଡ଼ାଙ୍କ୍ ତିଆର୍ ଆଦ୍‍ତନ୍ । ତାମ୍ ବିରୁଦ୍ ତେ ନିଜର୍ କୁଡ଼ିଏ ହଜାର୍‍ ସୌନ୍ୟଡ଼୍‍କ୍ ପୟ୍‍ସ୍ ୱାଦାନ୍ ରାଜାନ୍ ତ ନିଜର୍ ୱେରନ୍ ରାଜା ଦଶ୍‍ହଜାର୍‍ ସୌନ୍ୟଡ଼୍ ଆସ୍ କୁଡ଼ିଏ ହଜାର୍‌ ସୈନିଡ଼୍ ପୟିସ୍ ୱାଦାନ୍ ରାଜାନ୍ ତଡ଼୍ ଯୁଦ୍‌ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ଦ୍‍ତଡ଼୍ କି ଇଲେ, ଆଦ୍ ବାତେଏ ଅଣ୍ଡ୍‌ ମୁନେ କୁଦି ଆଦ୍ ବିଷୟତିଙ୍କ୍ ହେର୍କା ମାଡ଼ଣ୍ଡ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଯଦି ପାର୍‍ୱଡ଼୍, ଆଲାତ୍କେ ବିରଦି ରାଜାଲ୍‍ ଗାଟି ଯେକା ମାନ୍ଦାନ୍ ୱେୟେ କେ ଅନ୍‌‍ଗାରେ ବେସ୍‍ତୁଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରୟ୍‍ସ୍‍ ପାର୍‍ୱମ୍‍ ଇଞ୍ଜ କେସିଦ୍‍ ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ଆଦ୍ ପୁଟୁଙ୍କ୍ ମି ଲୋପେଙ୍କ୍ ବେନ ଯଦି ନିଜର୍ ବାତ୍‍ତେବା ୱିଡ଼୍‍ସଣ୍ଡ୍, ଆଲାତ୍କେ ଅଣ୍ଡ୍‌ ନା ଶିଷ୍ୟ ଆଦ୍ ପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ଅୱଡ଼୍‌ ତ ସାୟେ; ବାତେଙ୍କ୍ ଇତ୍କେ ଅୱଡ଼୍‌ ଯଦି ତାନ୍ କାର୍‌ଅ ହାରାମାଡ଼ିତ୍‍, ଆଲାତ୍କେ ତାକିଂଙ୍କ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଅୱଡ଼୍‌ ମାଡ଼୍ ପାର୍‍ଦ୍‍ତାଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ଆଦ୍ ବୁମ୍ ବା ମାଣ୍ଡୁଲ୍ ଦିବେତ୍‍ ମାଇଦିଙ୍କ୍ ଆନ୍‌‍ତେ ଲେକେତ୍ ଆୟ୍‍ୟ, ତାକିଂଙ୍କ୍ ବାୟିଦେ ହେସିଦ୍‍ତଡ଼୍ । ବେନଙ୍କ୍ କେଞ୍ଜାଙ୍କ୍ କେୱୁ ମିନ୍ଦେ, ଅଣ୍ଡ୍‌ କେଞ୍ଜିଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ଅନ୍‌‍ଦିନେ କରଆଦାୟ୍ ମାଡ଼ାନଡ଼ି ନୁ ସମାଜ୍ କଞ୍ଜ୍ ପେସ୍‍ପି ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଜିସୁନ୍ ବାକ୍ୟ କେଞ୍ଜାନ୍ ମାଇଦିଙ୍କ୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ବାତେଙ୍କ୍ ଇତ୍କେ ପାରୂଶୀଡ଼୍ ନୁ ଦର୍ମଶାସ୍ତ୍ରୀଡ଼୍ ଅବିଯଗ୍ ମାଡ଼ି କେସମାତ୍‍ତଡ଼୍, ହି ନାରୁଡ଼୍ ସମାଜ୍ କଞ୍ଜ୍ ପେସ୍‍ପି ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ଅଡ଼୍‌‍ ତ କାଇଲି ତିନ୍ଦୁ‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ଆଦିଙ୍କ୍, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହି ୱେଷଡ଼୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ହେର୍କେ ମାଡ଼ାଟ୍ ୱେରନ୍ ନାରୁନାୱୁ ଶହେଟାନ୍ ମେଣ୍ଢା ମାନ୍‍ତା, ମେଣ୍ଡେ ଆୱିନାଗାଙ୍କ୍ ୱେରଡ଼୍ ମେଣ୍ଢା ମାଇହାତ୍କେ, ଆଲାତ୍କେ ଅଣ୍ଡ୍‌ ବାତେଏ ନବ୍‍ବେ ନଅଟାନ୍ ମେଣ୍ଢାଙ୍କ୍ ଡୁକ୍‍ତାଗ୍‍ ୱିଡ଼୍‍ସି, ମାଇ ମାନ୍ଦାନ୍ ମେଣ୍ଢାତିଙ୍କ୍ ଦର୍‍ସ୍‍କ୍‍ ନା ଯାକ ତାକିଂଙ୍କ୍ ମେହ୍‍କାଙ୍କ୍ ଆନଣ୍ଡ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ଅଣ୍ଡ୍‌ ମେହ୍‍କି ଦର୍‍ସ୍‍କି ଗାଟି ସାର୍‍ଦେ ଆଦ୍‍ତନ୍ ମେଣ୍ଡେ ମେଣ୍ଢାତିଙ୍କ୍ ଆଟେତାଗ୍ କାଞ୍ଜି ଲୋନ୍‌‍ ତାତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ଅଣ୍ଡ୍‌ ଲୋନ୍‌ ଆଞ୍ଜ୍ ତାନ୍ ସାଙ୍ଗନଡ଼୍ ନୁ ଗାରେତଡ଼୍‍କ୍ ଅଣ୍ଡୟ୍‌ ଆଗେ କାର୍‍ଙ୍ଗି କେତିତଣ୍ଡ୍, ନା ତଡ଼୍ ସାର୍‍ଦେ ମାଡ଼ାଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାନେ ନାୟାଦ୍ ମାଇ ମାନ୍ଦାନ୍ ମେଣ୍ଢାତିଙ୍କ୍ ଦର୍‍ସ୍‍କ୍‍ ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ଆଦେପୁଟୁଙ୍କ୍ ନାନେ ଆନ୍‌‍ତେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ବେନ୍ ନାରୁଡ଼୍ ମନ୍ ପରିବର୍ତ୍ତନ୍ ଆଦ୍‍ଦାନ୍ ଦର୍‍କାର୍ ଇଲେ, ଇସତଡ଼୍ ନବ୍‍ବେ ନଅଜାନ୍ ଦାର୍ମିକ୍ ନାରୁଡ଼୍ ୱିଡ଼୍‍ସି ୱେରଣ୍ଡ୍ ପାପିନାରୁନ୍ ହୃଦୟ୍ ପରିବର୍ତ୍ତନ୍ ଆତ୍‍କେ ସ୍ୱର୍ଗତାଗ୍ ଗାଟି ସାର୍‍ଦ୍‍ ଆଦ୍‌ତେ । ");
INSERT INTO kff_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ହେର୍କେ ମାଡ଼ାଟ୍ ଅଣ୍ଡୟ୍‌ ନାଟାଡ଼୍‍ତାଗ୍ ଦଶ୍‍ଟାନ୍‍ ରୂପାଡାବ୍‌ ମାତ୍‍ତା, ବାତେଙ୍କ୍ ଇତ୍କେ ଆୱିନ୍‍ ଲୋପେଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ମାଇ ଆଦ୍‍ତେ । ଆଲେକେ ଆଦ୍ ବାତ୍ ମାଡ଼ିତ୍ ? ଆଲାତ୍କେ ଆଦ୍ ନାଟାଡ଼୍ କୁପି ନିଡ଼୍‍ସ୍‍ପି ଲୋନ୍‌‍ସାରେ ସାୟ୍‍ ମାଡ଼ି କାୟ୍‍ତିତ୍, ମେଣ୍ଡେ, ରୂପାଡାବ୍‌ ଦର୍‍ସ୍‍କ୍‍ ନା ଯାକ ଯତନ୍ ତେ ମେହ୍‍କ କି ? ");
INSERT INTO kff_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ମେହ୍‍କି ଦର୍‍ସ୍‍କି ଆଦ୍ ତାନ୍ ସାଙ୍ଗକିଂଙ୍କ୍ ନୁ ଗାରେତଡ଼୍‍କ୍ କାର୍‍ଙ୍ଗି କେତିତ୍‍, ନାନେ ଗାଟି ସାର୍‍ଦା । ବାତେଙ୍କ୍ ଇତ୍କେ ନାୟାଦ୍ ମାଇ ମାନ୍ଦାନାଦ୍ ରୂପାଡାବ୍‌ ଦରସ୍‍କ୍‍ତାନ୍ । ୱାଡ଼ାଟ୍ ନା ତଡ଼୍ ସାର୍‍ଦେ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ଆଦେପୁଟୁଙ୍କ୍ ୱେରଣ୍ଡ୍ ପାପିନାରୁଣ୍ଡ୍ ତାନ୍ ହୃଦୟ୍‍ତିଙ୍କ୍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼କେ, ପରମେଶ୍ୱରତେ ଦୂତକିନ୍ ମୁନ୍‍ନେ ଗାଟି ସାର୍‍ଦ୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଜିସୁ ମେଣ୍ଡନ୍‍ଦାମ୍ କେତ୍‍ତଣ୍ଡ୍, ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ସୁଦୁର୍‍ ମାର୍‍ ତାମ୍ ବାବାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବାବା, ନା ଦୁଡ଼େ ସମ୍ପତ୍ତି ନାକିଂଙ୍କ୍ ହିମ୍ । ଆସୁଟେ ତାମ୍‍ବାବାଲ୍ ତାନ୍ ସମ୍ପତ୍ତିତିଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍‍କ୍‍ ତୁସିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ବେସ୍‍କ୍‍ଦିନାତ୍‍ ପେର୍‍କେ ସୁଦୁର୍‍ ମାର୍‍ ଅନ୍‌ ଦୁଡ଼େ ସମ୍ପତ୍ତି ପୟ୍‍ସ୍ ଯେକା ଦେଶ୍ ଆଦ୍‍ତନ୍ । ଅଣ୍ଡ୍‌ ଆଗେ ମଣ୍ଡି ହିନା ଗେଲ୍‍ସି ସାରେ ଦନ୍‍ସମ୍ପତ୍ତି ଉଡ଼ାମାଡ଼୍‍ ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ଅଣ୍ଡ୍‌ ସାର୍‍ରେ ଡାବ୍ କର୍ଚ୍ଚମାଡ଼ି ତେର୍‍ତେ ୱେୟ୍, ଆଦ୍ ଦେଶ୍‍ତାଗ୍ ବୟ୍‍ଙ୍କାର୍‍ ତୁପାନ୍‌ ଆଦ୍‍ତା । ଅଂକିଙ୍କ୍‌ ଆଗେ ବାତେମେଣ୍ଡେ ଦର୍‍କ୍‍ୱାଙ୍କ୍ କାର୍‍ୱିନ୍ ମାନ୍ଦେୱେୟ୍‍ତେ । ଅଂକିଙ୍କ୍‌ ଅବାବ୍ ଆଦ୍ ୱେୟ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ଆସୁଟେ ଅଣ୍ଡ୍‌ ଆଦ୍ ଦେଶ୍‍ତେ ଅରତୁଣ୍ଡ୍ ନାରୁନାଗ୍ ଆଞ୍ଜ୍ ଗତିତ୍‍ ଲେକାମ୍ ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଅନ୍‌ ୱାୟାନା ପାଦି ମେଇତାଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ପାଦି ତିନ୍ଦାନ୍ କାଦି, ତିଞ୍ଜ୍ ଅଣ୍ଡ୍‌ ପଟ୍‍ଟେ ନିହ୍‍ତାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବେନମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ବାତା ହିୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ଆସୁଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ହେର୍କା ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ନା ବାବାନ୍ ଲୋନ୍‌ ଚାକରିଡ଼୍ ଚାକୁର୍‍ତିନ୍ଦାନ୍‍ ୱେୟ୍ ଚାକର୍ ମାଇସ୍ ଆଦୁତ୍‍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାନେ ଇଗ୍ କାର୍‍ୱିନ୍ ଡଲୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ନାନେ ତେଦୀ ନା ବାବାନ୍ ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ଆଦ୍‍ତନ୍ ବା ଅଂକିଙ୍କ୍‌ କେତିତାନ୍, ବାବା, ଇଶ୍ୱରତେ ବିରୁଦି ତେ ନୁ ନି ବିରୁଦି ତେ ନାନେ ପାପ୍‌ ମାଡ଼୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ନି ମାର୍‍ ଇଞ୍ଜ କାର୍‍ଙ୍ଗାନଙ୍କ୍ ନାନେ ଯୋଗ୍ୟ ଇଲେନ୍ । ନାକିଂଙ୍କ୍ ନି ଚାକର୍ ହିନା ନେହେମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ଆସୁଟେ ଅଣ୍ଡ୍‌ ତେଦି ତାମ୍ ବାବାନ୍ ଗାର୍‍ରେ ଆତ୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଯେକା ମାନ୍ଦାନାଦ୍ ତାମ୍ ବାବାଲ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଦୟାତେ ବିଗଲିତ ଆତ୍‍ତଣ୍ଡ୍, ବା ମିରିଆଞ୍ଜ୍ ଅଂକିଙ୍କ୍‌ ଉର୍‍ଙ୍ଗି ନମସ୍କାର୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ମାର୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ବାବା, ଇଶ୍ୱର୍‌ତେ ବିରୁଦି ତେ ନୁ ନି ବିରୁଦି ତେ ନାନେ ପାପାମ୍ ମାଡ଼୍‍ତାନ୍, ମାର୍‍ ଇଞ୍ଜ କାର୍‍ଙ୍ଗାନାଦ୍‍ ନାନେ ଯୋଗ୍ୟ ଇଲେନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ବାତେଙ୍କ୍ ଇତ୍କେ ବାବାଲ୍ ତାମ୍ ଚାକରିଡ଼ିକ୍ କେତ୍‍ତଣ୍ଡ୍, ସିଟ୍‍ପାଟ୍ ଆଞ୍ଜ୍ ସାର୍‍ରେ ଲେକେତାଉ ଚକାସିଲେ ତାସ୍ ଇକିଂଙ୍କ୍ କେର୍‍ସ୍ପିମୁଟ୍ । ଇନ୍‍ କାୟ୍‍ଦାଗ୍‍ ମୁଦ୍‍ ନୁ ଡେକାନାଗ୍‍ ହେର୍‍ପୁକ୍ କେର୍‍ସ୍ପିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ମେନ୍ଦୁଲ୍ ମାନ୍ଦାନ୍ ପେୟେତିଙ୍କ୍ ତାସ୍ ଆୱୁକାଟ୍, ୱାଡ଼ାଟ୍, ମାନାଡ଼୍ ବୋଜିତାଗ୍ ସାର୍‍ଦେ ମାଡ଼୍‍ନା । ");
INSERT INTO kff_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ବାତେଙ୍କ୍ ଇତ୍କେ ନା ହି ମାର୍‍ ଡଲି ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡନ୍‍ଦାମ୍ ଗେଲ୍‍ସ୍‍ତଣ୍ଡ୍; ମାଇମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଦରକ୍‍ତଣ୍ଡ୍ । ଆସୁଟେ ଅଡ଼୍‌‍ ଗାଟି ସାର୍‍ଦ୍‍ ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ଆଦ୍ ଦିନାମ୍ ତେ ବେଡ଼୍‍ୟ୍ ମାର୍‍ ୱାୟାନା ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ବେସୁଙ୍କ୍‍ ଲୋତ୍ ଗାର୍‍ରେ ୱାସ୍ ହେଉତଣ୍ଡ୍, ଆସୁଟେ, ଅଣ୍ଡ୍‌ ଡୋଲା ନୁ ହେନ୍ଦାନାଦ୍ ମର୍‍ରେ କେଞ୍ଜ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ଆସୁଟେ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଚାକର୍‍ତିଙ୍କ୍ କାର୍‍ଙ୍ଗି ଇଗ୍ ବାତ୍ ଆଦୁତ୍‍ ଇଞ୍ଜ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ଚାକର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ନି ତାମୁଣ୍ଡ୍‌ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ୱାସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ସାଏତ୍ ମେନ୍ଦୁଲ୍ ତେ ମାଲ୍‍ସ୍ ୱାସ୍ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ମେନ୍ଦୁଲ୍‍ମାନ୍ଦାନ୍ ଗଡ୍‍ତିଙ୍କ୍ ଆୱୁକି ବଜି ମାଡ଼ୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“ବେଡ଼୍‍ୟ୍ ଦାଦାଲ୍ କପାମ୍ ଆଶେ ଲୋପ୍ ଆଦାଙ୍କ୍ ରାଜି ଆୟ୍‍ୟଣ୍ଡ୍ । ଆସୁଟେ ତାମ୍ ବାବାଲ୍ ବାୟିଦେ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ଗାଟି ବୁଜାମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ବେଡ଼୍‍ୟ୍ ମାର୍‍ ତାମ୍ ବାବାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଉଡ଼େ, ହିସ ଏଣ୍ଡ୍ ଆଦୁତ୍‍ତେ ନାନେ ନି ଦାସ ଲେକାମ୍ ତାକ ୱାଦୁତାନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବେସୁଙ୍କ୍‍ ବା ନି ଗଟ୍ ଅମାନ୍ୟ ମାଡ଼ାନ୍, ବେସୁଙ୍କ୍‍ ବା ନାକିଂଙ୍କ୍ ନା ସାଙ୍ଗଡ଼୍ ତ ବଜି ମାଡ଼ାଙ୍କ୍ ନିମ୍‍ ନାକିଂଙ୍କ୍ ମେକ୍‍ପିଲ୍ ବା ହିୱିନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ବାତେଙ୍କ୍ ଇତ୍କେ ହିଣ୍ଡ୍ ନି ମାର୍‍ ନି ସମ୍ପତ୍ତିତିଙ୍କ୍ କଜାନଡ଼୍ ତ ଉଡ଼ାମାଡ଼ିସ୍‍ ଇଞ୍ଜ୍ ବେସୁଟ୍‌ ଅଣ୍ଡ୍‌ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ୱାସ୍ ମିନ୍ଦେଣ୍ଡ୍ ନିମ୍‍ ଅନ୍‌ ମାଇଦିଙ୍କ୍ ମେନ୍ଦୁଲ୍ ମାନ୍ଦାନ୍ ପେୟେତିଙ୍କ୍ ରେହେସ୍ ବୋଜି ମାଡ଼୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ଆସୁଟେ ତାମ୍ ବାବାଲ୍ କେତ୍‍ତଣ୍ଡ୍, ପେକାଲ୍, ନିମ୍‍ ତ ସାର୍‍ଦାମ୍‍ ନା ତ ମାନ୍ଦୁତି, ବାତାମେଣ୍ଡେ ସାରେ ନାୟାୱୁ, ହାଉସାରେ ନିୟାୱୁ; ");
INSERT INTO kff_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ବାତେଙ୍କ୍ ଇତ୍କେ ହିଣ୍ଡ୍ ଯେ, ନି ତାମୁଣ୍ଡ୍‌ ଡଲି ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡନ୍‍ଦାମ୍ ଗେଲ୍‍ସ୍‍ତଣ୍ଡ୍; ମାଇମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଦରକ୍‍ତଣ୍ଡ୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ମାନାଡ଼୍ ଗାଟିସାର୍ଦା ମାଡ଼ାନ୍ ମାତ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜିସୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍‍କ୍ ଆନ୍‌‍ତେ କେତ୍‍ତଣ୍ଡ୍‍, ୱେରଣ୍ଡ୍, ସାଉକାର୍‍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍; ସାଉକାର୍‍ ତାନ୍ ସମ୍ପତ୍ତିତିଙ୍କ୍ ବୁଜାସୁଜା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଗୁମାସ୍ତାଙ୍କ୍ ନେହେସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ସାଉକାର୍‍ ଅର୍‍ତୁନ୍‍ ନାଗାଙ୍କ୍ କେଞ୍ଜ୍‍ତଣ୍ଡ୍ ଯେ, ଗୁମାସ୍ତାଲ୍ ଅଂକିଙ୍କ୍‌ ବୁସାମାଡ଼ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ଆଦାନଡ଼୍‌କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, ନାନେ ନି ବିଷୟତେ ଇଲା ବାତେଙ୍କ୍ କେଞ୍ଜୁତାନ୍ ? ନିୟାୱ୍‍ ଆୟବ୍ୟୟତ୍ ହିସାପ୍ ହିମ୍, କାରନ୍‍ ନିମେ ମେଣ୍ଡେ ଗୁମାସ୍ତା ଆସ୍ ମାନ୍ଦେପାର୍‍ୱିନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ଗୁମାସ୍ତାଲ୍ ହେର୍କେ କେତ୍‍ତଣ୍ଡ୍, ନାନେ ଇଞ୍ଜ୍ ବାତ୍ ମାଡ଼ିତାନ୍ ? ନା ମାଲିକ୍ ତ ପାଡ଼ିୟିତାଗାଙ୍କ୍ ନାକିଂଙ୍କ୍ ପେସ୍ପିଦୁତଣ୍ଡ୍ । ମାଣ୍ଡୁଲ୍‍ ଡେୱାଙ୍କ୍ ତ ନାକିଂଙ୍କ୍ ଶକ୍ତି ଇଲେ, ବିକ୍‍ ତାଲ୍‍କାଙ୍କ୍ ନାକିଂଙ୍କ୍ ସିଗ୍ ୱେସିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ଇଗାଙ୍କ୍ ନା ଚାକିରି ଆଦ୍ କେ ନାରୁଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ନାକିଂଙ୍କ୍ ନିଜେ ନିଜେ ଲୋନ୍‌ ୱେଡ଼୍‍କେତେ ଗ୍ରହନ୍ ମାଡ଼ିତଡ଼୍, ଆଦ୍ ନାନେ ପୁନ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ଆସୁଟେ ଗୁମାସ୍ତାଲ୍ ମାଲିକ୍‍ତାଗାଙ୍କ୍ ଉଦାର୍ ଆସ୍‍ମାନ୍ଦାନ୍‍ ସାରେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍ ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ମୁନ୍ ନାରୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନା ମାଲିକ୍‍ତିଙ୍କ୍ ନିମେ ବେଚର୍ ହିଦାନ୍ ମିନ୍ଦେ ? ଅଣ୍ଡ୍‌ କେତୁତଣ୍ଡ୍, ଶହେ କୁଣ୍ଡାନାଗ୍ ନିୟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ଗୁମାସ୍ତାଲ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ନିୟାଦ୍ ନିୟ୍‍ ରସିଦ୍‍ ଆୟ୍‍ମ୍‍ । ସିଟ୍‍ପାଟ୍ କୁଦି ପଚାଶ୍ ଇଞ୍ଜ ଲେକିମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଦ୍ୱିତିୟ ନାରୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନାୟାଦ୍ ବେସର୍ ଋଣ୍ ମାଲ୍‍ପିଦାନାଦ୍ ମିନ୍ଦେ ? ନାରୁଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, ଶହେ ବାସ୍ତା ଗହମ୍, ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ଆୟ୍‍ମ୍ ନିୟାଦ୍ ରସିଦ୍‍ । ଅଶୀ ବାସ୍ତା ଇଞ୍ଜ ଲେକିମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ଆସୁଟେ ମାଲିକ୍ ଆଦ୍ ଅସାଦୁ ଗୁମାସ୍ତାଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ଗୁମାସ୍ତାଲ୍ ଚାଲାକ୍ ତେ ପାଡ଼୍‌ୟି ମାଡ଼୍‍ତଣ୍ଡ୍ । ଅନ୍‌ ଲେକାମ୍, ବାଗାତ୍‍ନାରୁଡ଼୍‍ ତ ବ୍ୟବସାୟ୍‍ ମାଡ଼ାଙ୍କ୍, ହି ସସାର୍‍ତେ ନାରୁଡ଼୍ ଆଦ୍ୟାତ୍ମିକ ନାରୁଡ଼୍ ୱିଡ଼୍‍ସି ଗାଟି ଚାଲାକ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ନାନେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ମିଡ଼୍ ମିକା ଜଗତ୍ ତେ ଦନ୍ ତଡ଼୍ ନିଜେ ନିଜେ ସାଙ୍ଗଡ଼୍ ଦର୍‍ସ୍‍କାଟ୍ । ବେସୁଙ୍କ୍‍ ହି ଜଗତ୍ ଦନ୍ ତେରିଆଦ୍‍ତା, ଆସୁଙ୍କ୍ ସାରେଦିନାତେ ବାଦ୍‍କାନ୍ ନାରୁଡ଼୍ ମିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ବେନ ସୁଦୁର୍‍ ବିଷୟ ତେ ଆନ୍‌‍ତେ ବିଶ୍ୱାସ୍‍ତଣ୍ଡ୍‍, ଅଣ୍ଡ୍‌ ନାର୍ଗେ ବିଷୟ ତେ ଆନ୍‌‍ତେ ବିଶ୍ୱାସ୍‍ତଣ୍ଡ୍‍, ବେନ ସୁଦୁର୍‍ ବିଷୟ ତେ ଆନ୍‌‍ତେ ବିଶ୍ୱାସ୍‍ଇଲ୍‍ୱେ, ଅଣ୍ଡ୍‌ ନାର୍ଗେ ବିଷୟ ତେ ଆନ୍‌‍ତେ ବିଶ୍ୱାସ୍‍ଇଲ୍‍ଲେ । ");
INSERT INTO kff_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ଇତ୍କେ ମିଡ଼୍ ଯଦି ଜାଗତିକ ଦନସମ୍ପତ୍ତିତାଗ୍ ବିଶ୍ୱାସ୍‍ତଣ୍ଡ୍‍ ଆୟ୍‍ୱିନ୍‍ ? ଆଲାତ୍କେ ବେନ ମିକିଂଙ୍କ୍ ପ୍ରକୃତ ଦନ୍‍ସମ୍ପତ୍ତି କାଇଦେ ଇଦାଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ମେଣ୍ଡେ ମିଡ଼୍ ଯଦି ଅର୍‍ତୁନାଦ୍‍ ଦନ୍‍ସମ୍ପତ୍ତିତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍, ଆଲାତ୍କେ ବେନ ମିକିଂଙ୍କ୍ ମି ନିଜେତ୍ ମାଇଦିଙ୍କ୍ ଦନ୍‍ସମ୍ପତ୍ତିତିଙ୍କ୍ ଇଦ୍‍ତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ୱେରଣ୍ଡ୍ ଦାସ ଇର୍‍ୱୁଡ଼୍ ମାଲିକ୍‍ତେ ସେବା ମାଡ଼େପାର୍‍ୱଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଅର୍‍ତୁଙ୍କ୍ ପାସ୍‍କିତନ୍ ନୁ ମେଣ୍ଡେ ଅର୍‍ତୁଙ୍କ୍ ପ୍ରେମ୍ ମାଡ଼ିତନ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ପରୁ ବିଶ୍ୱାସ୍ ତେ ମାନ୍‍ତଣ୍ଡ୍ ବା ଅର୍‍ତୁଙ୍କ୍ ମୁର୍କ ମାଡ଼ିତନ୍ । ମିଡ଼୍ ଅଣ୍ଡୟ୍‌‍ଦାମ୍ ପରମେଶ୍ୱର୍‍ ନୁ ଦନ୍‍ସମ୍ପତ୍ତି ରେଣ୍ଡିଙ୍କ୍ ସେବା ମାଡ଼୍‍ପେ ପାର୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ଇଦ୍ ସାରେ ଗଟ୍ କେଞ୍ଜି ଜିସୁନ୍ ପରୁ କପାମ୍ ଆଦ୍‍ତଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଡାବ୍‍କିଂକ୍ ପ୍ରେମ୍ ମାଡ଼ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ଆସୁଟେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବେନ୍‍ନାରୁଡ଼୍‍ ମୁନେଙ୍କ୍ ନିଜ୍‍ତିଙ୍କ୍ ଦାର୍ମିକ୍ ଇଞ୍ଜ ତଅତିତଡ଼୍, ମିଡ଼୍ ଆଦେପୁଟୁଙ୍କତ୍ ନାରୁଡ଼ି । ବାତେଙ୍କ୍ ଇତ୍କେ ପରମେଶ୍ୱର୍‍ ମି ହୃଦୟ୍‍ତିଙ୍କ୍ ପୁତ୍‍ତଣ୍ଡ୍ । ବେନେସାରେ ବିଷୟତିଙ୍କ୍ ନାରୁଡ଼୍ ଗାଟି ମୂଲ୍ୟବାନ୍ ଇଞ୍ଜ ତନ୍ଦିତଡ଼୍, ଆଦ୍ ପରମେଶ୍ୱର୍‍ତେ ମୁନ୍‍ କାରାପ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ମୋଶାନ୍‌ ନିୟମ୍ ନୁ ବାବବାଦୀ ବକ୍ତାଲଡ଼୍ ଲେକ୍‍ତ୍‍ତେ ଲେକାମ୍ ନାରୁଡ଼୍ ବାଦ୍‍କମାନ୍‍ତଡ଼୍‍ ଇଞ୍ଜ ପରମେଶ୍ୱର୍‍ ଇଚ୍ଛା ମାଡ଼୍‍ତଣ୍ଡ୍ । ଆଦ୍ ଦିନାମ୍‍ତେ କଞ୍ଜ୍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଦ୍ ସୁସମାଚାର୍ ପ୍ରଚାର ଆଦୁତ୍‍ତେ । ମେଣ୍ଡେ ସାରେ ଜାନ୍ ଶକ୍ତିତଡ଼୍ ଆଗେ ହସୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ବାତେଙ୍କ୍ ଇତ୍କେ ବ୍ୟବସ୍ଥାତାଦ୍‍ ୱେରଡ଼୍ ଚିହ୍ନେ ନଷ୍ଟ ଆଦ୍‍ଦାନ୍ ୱିଡ଼୍‍ସି ସ୍ୱର୍ଗ ନୁ ପୃତିବି ନଷ୍ଟ ଆଦାନାଦ୍ ସହଜ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ବେନଆଇ ନିଜର୍ ମୁତେଙ୍କ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡନ୍ ମୁତେଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ବ୍ୟବିଚାର୍ ମାଡ଼ୁତଣ୍ଡ୍ ମେଣ୍ଡେ, ବେନ ଆଦ୍ ୱିଡ଼୍‍ସିତ୍‍ତେ ମୁତେଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ବ୍ୟବିଚାର୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ୱେରନ୍ ନାରୁନ୍ ସାଉକାର୍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଗାଟିଦାମ୍ ଆଉ ଚକାସିଲେ କେର୍ସ୍, ନିତ୍‍ତେଦିନାଲ୍‍ ଗାଟି ଆମଦ୍‍ ପ୍ରମୋଦ୍ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ବାତେଙ୍କ୍ ଇତ୍କେ ଅନ୍‌ ମାର୍ ଦେ ଗାର୍‍ରେ ଲାଜାର୍ ପେଦେର୍‍ତେ ବିକାରି ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ମେନ୍ଦୁଲ୍‍ସାରେ ପୁଣ୍ଡୁକ୍ ଆସ୍ ମାତ୍‍ତା; ");
INSERT INTO kff_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ଅଣ୍ଡ୍‌ ସାଉକାର୍‍ ନାରୁଡ଼୍ ତେ ଚାକର୍ ତିଞ୍ଜ୍ ହେସାନ୍ ହେଙ୍ଗୁଲ୍‍ତିଙ୍କ୍ ତିଞ୍ଜ୍ ପଟ୍‍ଟେ ନିହ୍‍ତାଙ୍କ୍ ଆଶେ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ଇଦ୍‍ପୁଟୁଙ୍କ୍ ଯେ, ନେୟ୍‍ ମିକା ୱାସ୍ ଅନ୍‌ ପୁଣ୍ଡୁକିଂଙ୍କ୍ ନାକମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ବେସ୍‌କ୍ ଦିନାତେ ପେର୍‍କେ ଲାଜାର୍ ଡଲିଆତ୍‍ତଣ୍ଡ୍, ଆସୁଟେ ଦୂତକିନ୍ ତଡ଼୍ ଅଂକିଙ୍କ୍‌ ଅବ୍ରାହାମ୍‌ତେ ଗୁଦ୍‍ତାଗ୍‍ ଆତ୍‍ତା; ବେସ୍‍କ୍‍ଦିନାତ୍‍ ପେର୍‍କେ ଆଦ୍ ସାଉକାର୍‍ ନାରୁଡ଼୍ ଆନ୍‌‍ତେ ଡଲ୍‍ତ୍‍ତଣ୍ଡ୍ ଅଂକିଙ୍କ୍‌ ସମାଦି ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଆସୁଟେ, ଅଣ୍ଡ୍‌ ନର୍କ ତିପାଲ୍‍ତାଗେ କଲବଲ ଆସ୍‍ ପରୁ ଯେକା ଉଡ଼୍‍ତଣ୍ଡ୍ ଅବ୍ରାହାମ୍‌ତେ ଗୁଦ୍‍ତାଗ୍‍ ଲାଜାର୍‍ତିଙ୍କ୍ କୁଦିମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ଆସୁଟେ ଅଣ୍ଡ୍‌ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍‍, ହୋ, ବାବା ଅବ୍ରାହାମ୍‌, ନା ସେଙ୍ଗେ ଦୟାମାଡ଼ି ଲାଜାର୍‍ତିଙ୍କ୍ ରୟ୍‍ସିମ୍, ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ଏର୍‍ଦାଗ୍‍ ଅନ୍‌‍ଆଦ୍‍ ୱାଡ଼୍‍ଞ୍ଜ୍ ଟିପ ମୁହୁସ୍ ନା ୱାଞ୍ଜେର୍‍ତିଙ୍କ୍ ତଣ୍ଡା ମାଡ଼ିତ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାନେ ହି କିସ୍ ତାଗ୍ କଲବଲ ଆଦୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ବାତେଙ୍କ୍ ଇତ୍କେ ଅବ୍ରାହାମ୍‌ କେତ୍‍ତଣ୍ଡ୍, ହୋ ମାର୍‍, ନିମ୍‍ ଯେ ଜିୱୁନ୍‍ମାନ୍ଦାନ୍‍ ଦିନାମ୍ ତେ ଚାୟେତ୍‍ ବିଷୟ୍‍ଚାରେ ପୁଞ୍ଜ୍‍ମାତ୍ତିନ୍, ଆସୁଟେ, ଲାଜାର୍ ଆଦେପୁଟୁଙ୍କ୍ କାରାପ୍‍ ବିଷୟ୍‍ଚାରେ ଦର୍‍ସ୍‍କ୍‍ତନ୍, ଆଦ୍ ହେର୍କା ମାଡ଼ାଟ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ଇଞ୍ଜ୍ ଅଣ୍ଡ୍‌ ଶାନ୍ତିତେ ପଡ଼୍‍ତାଗ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ବାତେଙ୍କ୍ ଇତ୍କେ ଇଞ୍ଜ୍ ନିମ୍‍ କଲବଲ ଆଦ୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ତାନ୍ ୱିଡ଼୍‍ସି ନିୟାଗ୍ ନୁ ମାୟାଗ୍‌ ୱେରଡ଼୍ ବେଡ଼୍‍ୟ୍‍ୟାଦ୍‍ ଗୁୟ୍‍ନ୍ଦ୍‍ମିନ୍ଦେ । ନିକିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଆଦ୍ ଗୁୟ୍‍ନ୍ଦ୍‍ତିଙ୍କ୍ ବେନ ବା ୱେୟସ୍ ଆଦ୍ ପାର୍‍ୱଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ପଡ଼୍‍ୟ୍‍ୱିଡ଼୍‍ସି ବେନ ବା ଇଗ୍ ୱାଦ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ଆସୁଟେ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, ହୋ ବାବା ଆବ୍ରାହାମ୍, ଆଲାତ୍କେ ନିକିଂଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ୁତାନ୍, ଅଂକିଙ୍କ୍‌ ନା ବାବାନ୍ ଲୋନ୍‌‍ ରୟ୍‍ସିମ୍, ");
INSERT INTO kff_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ବାତେଙ୍କ୍ ଇତ୍କେ ଆଗେ ନା ଏୟିୱୁଡ଼୍‍ ଦାଦାଲଡ଼୍ ମିନ୍ଦେଡ଼୍; ଅଡ଼୍‌‍ ଆନ୍‌‍ତେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ହିସତ୍ ତିପାଲ୍ ପଡ଼ିୟେତାଗ୍ ୱାଡ଼୍‍ମାକିଡ଼୍‍; ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଆଞ୍ଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସତର୍କ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଅବ୍ରାହାମ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଅଡ଼୍‌‍ ଗାର୍‍ରେ ମୋଶାନ୍‌ ନିୟମ୍ ନୁ ବାବବାଦୀ ବକ୍ତାଲଡ଼୍ ଦର୍ମଶାସ୍ତ୍ର ମିନ୍ଦେ, ଅଡ଼୍‌‍ ଅଡ଼୍‌‍ଗଟିଙ୍କ୍ କେଞ୍ଜାନ୍ ଲେକେତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ଆସୁଟେ ସାଉକାର୍‍ ନାରୁଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, ହୋ, ବାବା ଅବ୍ରାହାମ୍‌, ଆଦ୍ ଆସର୍ ଆୟ୍‍ୟ, ଯଦି ଡଲିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ବେନଆଇ ଆଡ଼୍ ଗାର୍‍ରେ ଆଦ୍‍ତନ୍, ଆଲାତ୍କେ ଅଡ଼୍‌‍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍, ନୁ ମନ୍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ବାତେଙ୍କ୍ ଇତ୍କେ ଆବ୍ରାହାମ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ଇଲେ, ଯଦି ମି ଦାଦାଲଡ଼୍ ମଶାନାଦ୍ ନୁ ବାବବାଦୀ ବକ୍ତାଲଡ଼୍ ଗଟି କେଞ୍ଜଡ଼୍ ଆଲାତ୍କେ ଅଡ଼୍‌‍ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଦିମାନ୍ଦାନ୍ ବେନ୍ ନାରୁଡ଼୍ ଗଟି ଆନ୍‌‍ତେ କେଞ୍ଜଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଜିସୁ ତାମ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବେନେ ସାରେ ହେର୍କା ତଡ଼୍ ନାରୁଡ଼୍ ପାପତାଗ୍ ରାଇତଣ୍ଡ୍ ନୁ ବେନ୍ ଅଙ୍କ୍‌ ଇଦ୍ ପାପତାଗ୍ ରାପିତଣ୍ଡ୍ ଅନ୍‌‍ୱାଦ୍ ଦଣ୍ଡ୍ ଯେ ବେସର୍ ବୟଙ୍କାର୍ ଆଦ୍‍ତେ ! ");
INSERT INTO kff_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ହିଡ଼୍ ଲେକେତ୍‌ ନାରୁଡ଼୍‍କ୍ ପାପତାଗ୍ ରାପାନ୍ ୱିଡ଼୍‍ସି ଅନ୍‌ ପାପତାଗ୍ ଅଣ୍ଡୟ୍‌ ବାଡ଼େୟାଦ୍ ଜାତ୍‍ତେକାଲ୍ ୱେହେସ୍ ଅଂକିଙ୍କ୍‌ ସମୁଦ୍ରତାଗ୍ ହେସିତ୍କେ ମିକା ଲେକେତ୍ ଆୟେଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ତ ମିଡ଼୍ ନିଜ୍, ବିଷୟତେ ସାବ୍‍ଦାନ୍ ଆସ୍ ମାନୁଟ୍ । ଯଦି ନି ତାମୁଣ୍ଡ୍‌ ପାପ୍‌ ମାଡ଼ିତନ୍, ଅଂକିଙ୍କ୍‌ ମନ୍‍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼ାଙ୍କ୍ କେଲାଟ୍; ମେଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ଯଦି ମନ୍ ପରିବର୍‍ତନ୍ ମାଡ଼ିତନ୍, ଆଲାତ୍କେ ଅଂକିଙ୍କ୍‌ କ୍ଷମା ହିମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ମେଣ୍ଡେ, ଯଦି ଅଣ୍ଡ୍‌ ଅଣ୍ଡୟ୍‌‍ଦିନ୍ ତେ ଲୋପେ ସାତ୍‍ଦାମ୍, ନି ବିରୁଦ୍‍ତେ ପାପ୍‌ ମାଡ଼ିତନ୍ ନୁ ସାତ୍‍ଦାମ୍ ନି ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ୱାସ୍ କେତିତଣ୍ଡ୍ ନାନ୍ ମନ୍‍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼୍‍ତାନ୍ ଇଞ୍ଜ କେତିତଣ୍ଡ୍, ଆଲେକେ ଅଂକିଙ୍କ୍‌ ଆଦ୍‍ଲେକାମ୍ କ୍ଷମା ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ଆଗାଙ୍କ୍ ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍ ପ୍ରବୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, ମାୟାଦ୍‌ ବିଶ୍ୱାସ୍ ଅଦିକ୍‌ ମାଡ଼ିମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ପ୍ରବୁ କେତ୍‍ତଣ୍ଡ୍, ଯଦି ୱେରଡ଼୍ ସୋରିଷପେଡ଼େମ୍ ଲେକେମ୍ ମିୱାଦ୍ ବିଶ୍ୱାସ୍ ମିନ୍ଦେ, ଆଲେକେ ଇଦ୍ ତୁତକଳି ମାଡ଼େତିଙ୍କ୍ ମଦଲ୍ କଞ୍ଚ୍ ତାହାକି ସମୁଦ୍ରତାଗ୍ ଉର୍ସ୍କିଆୟି ଇଞ୍ଜ କେତ୍‌କେ ବାତେ ଆଦ୍‌ ମିୟାଦ୍‌ ଗଟ୍‌ କେଞ୍ଜିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ବାତେଙ୍କ୍ ଇତ୍କେ ମି ଲୋପେ ଇଦ୍ ଲେକେମ୍ ନାରୁଡ଼୍ ବେନ ମିନ୍ଦେଣ୍ଡ୍, ବେନନ୍ ଦାସ ହୁଡ଼୍‍ସ୍ ୱାସ୍ ବା ଗଡ଼କ୍‍ ମେୟେସ୍ ୱାୟାନାକାଙ୍କ୍ ୱାତ୍‍କେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ କେତିତଣ୍ଡ୍, ଇଞ୍ଜେ ୱାସ୍ ତିନ୍ଦାଙ୍କ୍ କୁଦା ? ");
INSERT INTO kff_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ତାନ୍ ଚାକର୍ ତିଙ୍କ୍ କେତିତଣ୍ଡ୍, ନାୟାଦ୍ ତିନ୍ଦାନାଦ୍ ଟିକ୍ ମାଡ଼ା, ମେଣ୍ଡେ ନାନ୍ ତିନ୍ଦାନାଦ୍ ଉନ୍ଦାନାଦ୍ ତେର୍‍ସ୍ପାସ୍‍ନା ଯାକ ନାକିଂଙ୍କ୍ ସେବା ମାଡ଼େ, ତାନ୍ ପେର୍‍କେ ନିମେ ତିନ୍ଦାନ୍ ଉନ୍ଦାନ୍ ମାଡ଼ିତି । ");
INSERT INTO kff_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ଦାସ ଆଦେଶ୍‍ ଲେକାମ୍ ପାଡ଼ିୟି ମାଡ଼କେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ଦନ୍ୟବାଦ୍ ଇଦ୍‍ତଣ୍ଡ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ଆଦ୍ ଲେକେମ୍ ମିଡ଼୍ ଆନ୍‌‍ତେ ଆଦେଶ୍‍ ଲେକାମ୍ ସାର୍‍ରେ ପାଡ଼ିୟି ମାଡ଼୍‍ତେ ପେର୍‍କେ କେଲ୍‍ମୁଟ୍, ମାନାଡ଼୍ ଅଯୋଗ୍ୟ ଦାସଡ଼୍, ବାତ୍ ପାଡ଼ିୟି, ମାତର୍ ଆଦିଙ୍କ୍ ମାଡ଼ିତମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜିସୁ ଯିରୁଶାଲେମ୍‍ତା ଆଞ୍ଜ ମାନ୍ଦାନ୍ ୱେଲେ ଶମିରୋଣ ନୁ ଗାଲିଲୀ ତାଲାନ୍ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ବେନେ ୱେରନ୍ ନାର୍ ଆସାନ୍ ୱେଲେ, ଦଶ୍‍ଜାନ୍ କୁଷ୍ଟିନାରୁଡ଼୍ ଜିସୁନ୍ ତଡ଼୍ କାୟିଲ୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ଅଡ଼୍‌‍ ଯେକା ନିସ୍ ଗାଟି ଲେହେଙ୍ଗ୍ ତେ କେତ୍ତଡ଼୍, “ହୋ ଜିସୁ, ଗୁରୁ, ମାକିଂଙ୍କ୍ ଦୟା ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଡ଼ି କେତ୍ତଣ୍ଡ୍, “ମିଡ଼୍ ଆଞ୍ଜ୍ ନିଜେ ନିଜେ ଯାଜକିଡ଼କ୍ ତଅମୁଟ୍ । ମେଣ୍ଡେ ଅଡ଼୍‌ ଆଞ୍ଜ ଆଞ୍ଜ ସୁସ୍ଥ ଆତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ଆଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ତାନ୍ ସୁସ୍ଥ ଆତ୍‍ତାଦ୍ ଉଡ଼ି ଗାଟି ଲେଙ୍ଗଦେ ପ୍ରବୁଙ୍କ୍ ମହିମା କୀର୍ତ୍ତନ୍ ମାଡ଼ମାଡ଼ ମାଲ୍‍ସ୍ ୱାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ମେଣ୍ଡେ ଜିସୁନ୍ ଡେକାନ୍ ମଦଲ୍ ଆଡ଼୍‌‍କି ଅଂକିଙ୍କ୍‌ ଦନ୍ୟବାଦ୍ ମାଡ଼ାଙ୍କ୍ ପାସ୍‍କ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଶମିରୋଣୀୟ ନାରୁଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ଆଗାଙ୍କ୍ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ଦଶ୍‍ଜାନ୍ ବାତ୍ ସୁସ୍ଥ ଆୟ୍‍ୟଡ଼୍ ?” ଆଲାତ୍କେ ନଅଜାନ୍ ବେଏକେ ଆଦ୍‍ତଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଇଶ୍ୱରତାଦ୍ ଗୌରବ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଇଣ୍ଡ୍ ବିଜାତି ନାରୁଡ଼୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନ ମାଲ୍‍ସ୍ ୱାଡ଼ଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ମେଣ୍ଡେ, ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ତେଦ୍‍ଦେ, ହାନ୍, ନିୱାଦ୍ ବିଶ୍ୱାସ୍ ନିକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ିତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ଇଶ୍ୱର୍‌ତାଦ୍ ରାଜ୍ୟ ବେସୁଙ୍କ୍‍ ୱାସମିନ୍ଦେନ୍, ହିଦ୍ ବିଷୟତେ ପାରୂଶୀନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ ନୁ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଇଶ୍ୱର୍‌ତାଦ୍ ରାଜ୍ୟ ତଅନ୍‌ଦାନ୍ ରକମ୍ ୱାଡ଼; ");
INSERT INTO kff_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ଇଗେ ବା ଆଗେ ମିନ୍ଦେ ଇଞ୍ଜ ନାରୁଡ଼୍ କେଲଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍କେ ଉଡ଼ାଟ୍, ଇଶ୍ୱର୍‌ତାଦ୍ ରାଜ୍ୟ ମି ଲୋପେ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଶିଷ୍ୟକିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ଇଦ୍ ଲେକାମ୍ ସମୟ୍ ୱାଦୁତେ, ବେସୁଙ୍କ୍‍ ମିଡ଼୍ ନାରୁଡ଼୍ ପିଲେତ୍ ଦିନାମ୍ ଲୋପେକ୍ ୱେରନ୍ ଦିନ୍ ଉଡ଼ାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିତିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଉଡ଼ାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ଉଡ଼ାଟ୍, ଆଗେ, ଉଡ଼ାଟ୍, ଇଗେ ଇଞ୍ଜ ନାରୁଡ଼୍ ମିକିଂଙ୍କ୍ କେତିତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ଅଡ଼୍‌‍ ପେର୍‍କେ ହାନ୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ବାତ୍‍ତେଙ୍କ୍ ଇତ୍କେ ମାବ୍‍ତାଗ୍ ୱାର୍ରସୁତ୍‍ ୱେରଡାଗାଙ୍କ୍ ମେଣ୍ଡନ୍ ପାକ୍ ୱେସ୍ ଇଦ୍‍ତା, ନାରୁଡ଼୍ ପିଲେ ତାମ୍ ଦିନାତେ ଆଦ୍‍ଲେକାମ୍ ତଅନ୍‌ଦିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ବାତେଙ୍କ୍ ଇତ୍କେ ମୁନେ ଅଂକିଙ୍କ୍‌ ନାର୍ଗେ ଦୁଃକାମ୍ କଷ୍ଟ ମାଡ଼୍ ୱେଇତିତ୍ ନୁ ଇଦ୍ ଇଞ୍ଜେତ୍ ମାନେଇ ଦ୍ୱାର୍‍ ଆଗ୍ରାହ୍ୟ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ମେଣ୍ଡେ, ନୋହତେ ୱେଲେ ବେଦ୍ ଲେକାମ୍ ଗଟେମ୍ଆସ୍ ମାତ୍‍ତେ, ନାରୁଡ଼୍ ପିଲେତ୍ ୱେଲେ ମିକା ଆଦ୍ ଲେକେମ୍ ଗଟେମ୍ ଆଦ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ନୋହ ଜାହାଜତାଗ୍ ଅସାନ୍ ଦିନାମ୍ ଯାକ ନାରୁଡ଼୍ ତିନ୍ଦାନଙ୍କ୍ ନୁ ପେଣ୍ଡୁଲ୍ ଆଦାନଙ୍କ୍ ନୁ ପେଣ୍ଡୁଲ୍ ମାଡ଼ାନଙ୍କ୍ ଦାନ୍ଦେ ମାନ୍‌ତଡ଼୍, ମେଣ୍ଡେ ଏର୍‍ ତୁପାନ୍ ୱାସ୍ ସାର୍‍ରେ ତଡ଼୍‍କିଂଙ୍କ୍ ଆୱୁକ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲୋଟତେ ୱେଲେ ମିକା ଆଦ୍‍ଲେକାମ୍ ଗଟେମ୍ ଆସ୍ ମାତ୍‍ତା, ନାରୁଡ଼୍ ତିନ୍ଦାନଙ୍କ୍, ହାସାନ୍‍ ୱାମାନ୍, ମାଡ଼ାକ୍ ଉର୍ସ୍‍କାଙ୍କ୍ ନୁ ଲୋକ୍ ମାଡ଼ାଙ୍କ୍ ଦାନ୍ଦ୍ ଆସମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଲୋଟ ସଦୋମ୍‍ କନ୍‍ସ୍ ପେଇସ୍ ଆଦ୍‍ଦାନ୍ ଦିନେ ମାବ୍ ତାଗାଙ୍କ୍ କିସ୍ ନୁ ଗନ୍ଦକ ୱାର୍‍ସାମ୍ ୱାସ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ନାରୁଡ଼୍ ପିଲା ମାଲ୍‍ସ୍ ୱାଦାନ୍ ଦିନେ ଆଦ୍‍ଲେକାମ୍ ଗଟେମ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ଆଦ୍ ଦିନେ ବେନ ଲୋତ୍‍ତେ ମୁର୍ସିନାଗ୍‍ ମାନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଲୋତ୍ ତେ ଲୋପେ ମାନ୍ଦାନ୍ ତାମ୍ ଜିନିଷ୍‍ତିଙ୍କ୍ ଆଦାନଙ୍କ୍ ଡିଗି ୱାଡ଼୍‍ମାକିନ୍; ଆଦ୍‍ଲେକାମ୍ ବେନ ୱାୟାନାକ୍‍ ମାନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମାଲ୍‍ସ୍ ଲୋନ୍‌ ଆନ୍‌‍ମାକିନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲୋଟନ୍ ମୁତେନ୍ ଗଟି ହେର୍କା ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ବେନ୍ ନାରୁଡ଼୍ ନିଜ୍ ଜିୱୁଣ୍ଡ୍ ରକ୍ଷା ମାଡ଼ାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ିତନ୍, ଅନ୍‌ ଆଦ୍ ହାରାମାଡ଼ିତଣ୍ଡ୍, ମେଣ୍ଡେ ବେନ ତାନ୍ ଜିୱୁଣ୍ଡ୍ ହରା ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ଗେଲ୍‍ସ୍‍ପିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ଆଦ୍ ନାର୍କେ ଇର୍‍ୱୁଡ଼୍ ୱେରନ୍ ପଡ଼ିୟେତାଗ୍ ମାନ୍‍ତଡ଼୍, ୱେରଙ୍କ୍ ଅଣ୍ଡ୍‌ତଡ଼୍ ନୁ ମେଣ୍ଡେଅର୍‍ତୁଙ୍କ୍ ୱିଡ଼୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ରେଣ୍ଡ୍ ମୁତ୍‍ତେ ଅଣ୍ଡୟ୍‌ ତାଗ୍ ଯାତେତିଙ୍କ୍ ଉଡ଼୍‍ସ୍ପମାନ୍‍ତା, ୱେରଡିଙ୍କ୍ ଅଦ୍‌ତା ନୁ ମେଣ୍ଡେଅଣ୍ଡିଙ୍କ୍ ୱିଡ଼୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ଇର୍‍ୱୁଡ଼୍ ୱାୟେତାଗ୍ ମାନ୍‍ତଡ଼୍, ଅର୍‍ତୁଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତଡ଼୍ ନୁ ମେଣ୍ଡେଅର୍‍ତୁଙ୍କ୍ ୱିଡ଼୍‍ସିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ଆଗାଙ୍କ୍ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ହୋ ପ୍ରବୁ, ବେଗେ ?” ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ବେଗ୍ ମଡ଼୍, ଆଗେ ଡାମରାପିଟେ ମିକା ଅଣ୍ଡୟ୍‌‍ତାଗ୍‍ ଗୁଡ଼ିତା ।” ");
INSERT INTO kff_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ହତାସ୍ ଆୟ୍‍ୟକଟ ସାରେଦାମ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନାଦ୍ ସାୟେ, ଇ ବିଷୟତେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦ୍ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ଅଣ୍ଡୟ୍‌ ନାର୍‍ଦାଗ୍ ୱେରଣ୍ଡ୍ ବିଚାର୍‍କର୍‍ତାଲ୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ୱେର୍‍ୟକଟ ମାତ୍‍ତଣ୍ଡ୍ କି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଉଡ଼୍‍ପୁନ୍ୱେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ଆଦ୍ ନାର୍‍ଦାଗ୍ ୱେରଡ଼୍ ରାଣ୍ଡିଲ୍ ମାତ୍‍ତେ, ଆଦ୍ ଅଣ୍ଡ୍‌ ଅଣ୍ଡ୍‌‍ଦାମ୍‍ ଆନା ଆଞ୍ଜ୍ କେସ ମାତ୍‍ତେ, ୱେର୍‍ଣ୍ଡ୍ ନା ବିରୁଦ୍ ତେ ଅନ୍‌ୟାୟ୍ ମାଡ଼ୁତଣ୍ଡ୍ ଆଦିନାଦ୍ ବିଚାର୍ ମାଡ଼େ । ");
INSERT INTO kff_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ନାର୍ଗେ ଦିନାମ୍ ଯାକ ବିଚାର୍ କର୍ତ୍ତାଲ୍ ରାଜି ଆୟ୍‍ୟକଟ ମାତ୍‍ତଣ୍ଡ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ପେର୍‍କେ ଅଣ୍ଡ୍‌ ହେର୍କା ମାଡ଼୍‍ତଣ୍ଡ୍, ଯଦି ନାନ୍ ଇଶ୍ୱତିଙ୍କ୍ ୱେର୍‍ୱନ୍ କି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେଞ୍ଜନ୍, ");
INSERT INTO kff_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ଆଗେକ୍ ବାଡ଼େ ଆଦ୍ ରାଣ୍ଡିଲ୍ ନାକିଂଙ୍କ୍ କଷ୍ଟ ଇସମିନ୍ଦେ ନାନ୍ ତାନ୍ ସେଙ୍ଗେ ଆତ୍‍ତେ ଅନ୍‌ୟାୟତାଦ୍ ବିଚାର୍ ମାଡ଼ିତାନ୍, ଇଲୁକ୍ ଆଦ୍ ସାରେଦାମ୍ ୱାସ୍ ନାକିଂଙ୍କ୍ ଦାନ୍ଦେ ଆସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ଆଗାଙ୍କ୍ ପ୍ରବୁ କେତ୍ତଣ୍ଡ୍, “ଇଣ୍ଡ୍ ଅଦାର୍ମିକିଡ଼୍ ବିଚାର୍‍କର୍‍ତାଲ୍ ବାତ୍ କେତୁତନ୍, ଆଦ୍ କେଞ୍ଜାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ଇଶ୍ୱର୍‌ ହେଞ୍ଚତେ ନାରୁଡ଼୍ ନାର୍କାପାୟାଲ୍ ଅଂକିଙ୍କ୍ କାର୍‍ଙ୍ଗମାନ୍ତଡ଼୍, ଅଣ୍ଡ୍‌ କି ଅଡ଼୍‌‍ ସେଙ୍ଗେ ଆତ୍‍ତେ ଅନ୍‌ୟାୟତେ ବିଚାର୍ ମାଡ଼ଣ୍ଡ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଲେଟ୍ ମାଡ଼ିତନ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ଅଣ୍ଡ୍‌ ଯାପେ ଅଡ଼୍‌‍ ସେଙ୍ଗେ ଆତ୍‍ତେ ଅନ୍‌ୟାୟତାଦ୍ ବିଚାର୍ ମାଡ଼ିତନ୍ । ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁଡ଼୍ ପିଲେ ୱାସ୍ ପୃତିବିତାଗ୍ ବାତ୍ ବିଶ୍ୱାସ୍ ଉଡ଼ିତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ନିଜେ ନିଜେ ଦାର୍ମିକ୍ ଇଞ୍ଜ ହାଲ୍‍ସି ମେଣ୍ଡେ ବାଗାତଡ଼କିଂଙ୍କ୍ ବାଗାତ୍ ନାରୁଡ଼୍‍କ୍ ତୁଚ୍ଛ ହେର୍କେ ମାଡ଼ମାନ୍ଦାନ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଆତ୍ମା ଆଶେତ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଜିସୁ ଇଦ୍ ୱେଷଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ୱେର୍‍ଡ୍ ଦିନେ ଇର୍‍ୱୁଡ଼୍ ନାରୁଡ଼୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ମନ୍ଦିର୍‍ତାଗ୍ ଆତ୍‍ତଡ଼୍, ୱେରଣ୍ଡ୍ ପାରୂଶୀ ନୁ ମେଣ୍ଡ୍ଅର୍ତୁଣ୍ଡ୍ କରଗ୍ରାହୀ । ");
INSERT INTO kff_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ପାରୂଶୀ ନିଶ୍‍ମିକା ତାନ୍ ସେଙ୍ଗେ ଇଦ୍ ଲେକାମ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ହୋ ଇଶ୍ୱର୍‌ ନାନ୍ ନିକିଂଙ୍କ୍ ଦନ୍ୟବାଦ୍ ଇଦୁତାନ୍ ଯେ, ନାନ୍ ବାଗାତ୍ ସାରେତଡ଼୍ ନାରୁଡ଼୍ ଲେକାମ୍ ହାୱୁକାନଡ଼୍, ଆଦାର୍ମିକ୍, ବ୍ୟବିଚାରୀଡ଼୍‍ ବା ଇଣ୍ଡ୍ କରଗ୍ରାହୀ ଲେକେମ୍ ମିକା ଆୟନ୍; ");
INSERT INTO kff_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ନାନ୍ ସପ୍‍ତାତିଙ୍କ୍ ରେଣ୍ଡ୍ ଦାମ୍ ଉପବାସ୍ ମାଡ଼ୁତାନ୍ ନୁ ନାୱାଦ୍ ସାରେ କାମ୍‍ମାଡ଼ି ଗୁଡ଼୍‍ପ୍‍ତାଦ୍ ଦଶ୍‍ବାଗ୍ କନ୍‍ସ୍ ୱେରନ୍ ପାଲ୍‍କ୍ ଦାନ ମାଡ଼ୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ବାତେଙ୍କ୍ ଇତ୍କେ କରଗ୍ରାହୀ ଜେକେ ନିସ୍ ମିକା ସ୍ୱର୍ଗତା ପରୁ ଉଡ଼ାନଙ୍କ୍ ସେଙ୍ଗେ ମେଣ୍ଡେ ସାହାସ୍ ମାଡ଼ଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ତାନ୍ ଗୁଣ୍ଡେତାଗ୍ ରେହେସ୍ କେତାନଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ହୋ ଇଶ୍ୱର୍‌, ନାନ୍ ପାପି, ନାକିଂଙ୍କ୍ ଦୟା ମାଡ଼ା । ");
INSERT INTO kff_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଅଣ୍ଡ୍‌ ପାରୂଶୀ ଆୟ୍‍ୟଣ୍ଡ୍, ବା ଇଣ୍ଡ୍ କରଗ୍ରାହୀ ଦାର୍ମାମ୍ ଆସ୍ ତାମ୍ ଲୋନ୍‌ ଆତ୍‍ତଣ୍ଡ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ବେନଆଇ ନିଜେତିଙ୍କ୍ ଉନ୍ନତ ଇଞ୍ଜ ତଅତିତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ଆୱେକେ ମାଡ଼ିତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ବେନ ନିଜେତିଙ୍କ୍ ଆୱେକେ ମାଡ଼ିତନ୍, ଅଂକିଙ୍କ୍‌ ଉନ୍ନତ ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଜିସୁ ବେଦ୍ ଲେକାମ୍ ପିଲାଙ୍କ୍ ହିଟିତଣ୍ଡ୍, ଇଦ୍ ସେଙ୍ଗ୍ ନାରୁଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିକା ଅନ୍‌ ଗାର୍‍ରେ ତାତାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍; ମାତର୍ ଶିଷ୍ୟଡ଼୍ ଆଦ୍ ଉଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗୋଲକ୍ ହିଦାନଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅନ୍‌ ଗାର୍‍ରେ କାର୍‍ଙ୍ଗି କେତ୍ତଣ୍ଡ୍, “ପିଲାଙ୍କ୍ ନା ଗାର୍‍ରେ ୱାଦାଙ୍କ୍ ଇମୁଟ୍, ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମନା ମାଡ଼ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଇଶ୍ୱରତାଦ୍ ରାଜ୍ୟ ଇଦ୍ ଲେକେମ୍ ପିଲାନାଦ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ନାନ୍ ମିକିଂଙ୍କ୍ ନିଜାମ୍‍ କେସମିନ୍ଦେନ୍, ବେନବା ପିଲାନ୍ ଲେକେମ୍ ଇଶ୍ୱରତାଦ୍ ରାଜ୍ୟ ଗ୍ରହନ୍ ମାଡ଼ଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବେସୁଟ୍‌ ମିକା ଆଗେ ଆସ୍ ପାର୍‍ୱଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ୱେରଣ୍ଡ୍ ଯିହୁଦୀ ମୁକ୍ୟାଲ୍ ଜିସୁଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ହୋ ସତ୍‍ ଗୁରୁ, ସାରେଦିନାତ୍ ଜିୱୁଣ୍ଡ୍ ଲେକେତ୍‍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ବାତ୍ ମାଡ଼ିତାନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ଆଗାଙ୍କ୍ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ନାକିଂଙ୍କ୍ ସତ୍‌ଗୁରୁ ହିଞ୍ଜ ବାତେଙ୍କ୍ କେତୁତି ? ୱେରଣ୍ଡ୍ ୱିଡ଼୍‍ସି, ଇତ୍‍କେ, ଇଶ୍ୱତିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନ ମିକା ସାୟେ ଇଲାଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ଇଶ୍ୱର୍‌ତେ ଆଦେଶ୍‍ତିଙ୍କ୍ ତ ନିମେ ପୁତ୍‍ତିନ୍, ବ୍ୟବିଚାର୍ ମାଡ଼୍‍ମାଟ୍, ନାରୁଙ୍କ୍ ଆୱୁକ୍‍ମାଟ୍, ଡଙ୍ଗ‍ମା, ୱିଶାମ୍ ଗଟି କେଲ୍‍ମା, ନିଜେ ୟାୟବାବାଙ୍କ୍‍ ସମ୍ମାନ୍ ଇମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ଅଣ୍ଡ୍‌ କେତ୍ତଣ୍ଡ୍, “ଇୱୁ ସାରେ ନାନ୍ ପିଲେତ୍ ଦିନାକ୍ କନ୍‍ସ୍ ପାଲନ୍ ମାଡ଼ି ୱାଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜିସୁ ଇଦ୍ କେଞ୍ଜି ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ମିୱାଦ୍ ମେଣ୍ଡେ ୱେରଟ୍ ବିଷୟ ସୁଦୁଟ୍ ମିନ୍ଦେ; ନିମେ ନିୟାଦ୍ ସାରେ ଜିନିଷ୍ ୱାମି ଦରିଦ୍ର ନାରୁଡ଼୍‍କ୍ ତୁଉସିମ୍, ମେଣ୍ଡେ ନିକିଂଙ୍କ୍ ସ୍ୱର୍ଗତାଗ୍ ଦନ୍ ଦର୍‍କିତ୍; ମେଣ୍ଡେ ୱାସ୍ ନା ପେର୍କେ ୱାଡ଼ାଟ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଇଦ୍ ସାରେ ଗଟି କେଞ୍ଜି ଗାଟି ଦୁଃକାମ୍ ଆତ୍‍ତଣ୍ଡ୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଗାଟି ବାଡ଼୍‍ୟଣ୍ଡ୍ ସାଉକାର୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଦୁଃକାମ୍ ଆଦାନାଦ୍ ଉଡ଼ି ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ବେନନାଗ୍‍ ଦନ୍ ମିନ୍ଦେ, ଅଡ଼୍‌‍ ବେସର୍ ତିପାଲ୍‍ତେ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତ୍ ଲୋପେ ଅସ୍‍ ପାର୍‍ଦ୍‍ତଡ଼୍ ! ");
INSERT INTO kff_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ବାତ୍‍ତେଙ୍କ୍ ଇତ୍କେ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗ୍ ସାଉକାର୍ ନାରୁଣ୍ଡ୍ ନେଙ୍ଗାନ୍ ୱିଡ଼୍‍ସି, ଚୁଜ୍‍ ବସେତ୍‍ ଆଲା ଉଟ୍ ନେଙ୍ଗାନାଦ୍ ସହଜ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ବେନେ ନାରୁଡ଼୍ ଇଉଗୋଟି କେଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ କେତ୍ତଡ଼୍, “ଇଲୁକ୍‍ ବେନ ପରିତ୍ରାଣ ଆଦ୍‍ତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ବେନ୍‌ ନାରୁଡ଼୍ ତଡ଼୍ ଆୟ୍‍ୟ ଆଦ୍ ଇଶ୍ୱରତେ ତଡ଼୍ ଆଦ୍ ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ଆଗେତିନ୍‍ସ୍ ପିତର୍ କେତ୍ତଣ୍ଡ୍, “ଉଡ଼େ, ମାମେ ନିଜେ ନିଜର୍ ସାରେତିଙ୍କ୍ ୱିଡ଼୍‍ସି ନି ପେର୍କେ ୱାସ୍‍ମିନ୍ଦେମ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍; ବେନ୍ ନାରୁଡ଼୍ ଇଶ୍ୱରତାଦ୍ ରାଜ୍ୟ ସେଙ୍ଗେ ଲୋନ୍‌‍ କି ମୁତ୍‍ତେ କି ତାମୁଣ୍ଡ୍‌ କି ୟାୟବାବ କି ନିଜର୍ ପିଲାଙ୍କ୍ ୱିଡ଼୍‍ସ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ଇଞ୍ଜେତ୍ ଦିନାତେ ଗାଟି ଗୁଣାମ୍ ଦର୍‍କିତେ ମେଣ୍ଡ୍ ପେର୍‍କେତ୍‍ ଦିନାତେ ସାରେଦିନାତ୍ ଜିୱୁଣ୍ଡ୍ ଦର୍‍କିତ୍, ଇଦ୍ ଲେକେମ୍ ନାରୁଡ଼୍ ବେନ ଇଲାଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ପେର୍‍କେ ଜିସୁ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼କ୍ ୱେରେ ମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଉଡ଼ାଟ୍, ମାନାଡ଼୍ ଯିରୁଶାଲେମ୍‍ତା ଆଞ୍ଜ ମିନ୍ଦେମ୍, ମେଣ୍ଡେ ନାରୁଡ଼୍ ପିଲେତ୍ ବିଷୟତେ ବାବବାଦୀଡ଼୍ ବାତା ଲେକ୍‍ତଡ଼୍ ଆଉ ସାରେ ସଫଲ୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ଅଣ୍ଡ୍‌ ବିଜାତି ନାରୁଡ଼୍‍ତେ କାଇଦେ ସମର୍ପିତ୍ ଆଦ୍‍ତନ୍, ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ପରିହାସ୍ ମାଡ଼ିତଡ଼୍, ଅନ୍‌ ସେଙ୍ଗେ ଆୱୁକିତ୍‍ତଡ଼୍‍ ନୁ ଅନ୍‌ ପରୁ ଉଚିତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ଅଂକିଙ୍କ୍‌ ଚାବୁକତଡ଼୍ ରେହେସ୍ ହାୱକିତଡ଼୍, ମେଣ୍ଡେ ମୁଣ୍ଡ୍ ଦିନାମ୍‌ତେ ପେର୍କେ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ଜିୱୁଣ୍ଡ୍ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଇଦ୍‍ସାରେ ବିଷୟତେ ବାତେମିକା ପୁନଡ଼୍; ଇଦ୍ ବାକ୍ୟ ଅଡ଼୍‌‍ ଆଗାଙ୍କ୍ ମିଞ୍ଜି ମାତ୍‍ତେ, ମେଣ୍ଡେ ଜିସୁ ବାତ୍ ବାତ୍ କେସ‍ମାତ୍‍ତଡ଼୍, ଆଉ ସାରେ ଅଡ଼୍‌ ବୁଜେମ୍ ଆୟ୍‍ୟ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଅଣ୍ଡ୍‌ ଯିରୀୟ ନଗର୍‍ତେ ଗାର୍‍ରେ ହେଉଦାନ୍‍ ୱେଲେ, ୱେରଣ୍ଡ୍ କାନାଲ୍ ହାର୍‍ଦେ ଗାର୍‍ରେ କୁଦି ତାଆଲ୍‍କ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଆଦାନାଦ୍ ଲେଙ୍ଗ୍ କେଞ୍ଜି ଗଟ୍ ବାତେଏ ଇଞ୍ଜ ପାଚ୍ରାମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ଅଡ଼୍‌‍ କାନାଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ନାଜରିତିୟ ଜିସୁ ଇଦ୍ ଆର୍‍ଇସ୍ ଆଦୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ କାନାଲ୍ ଗାଟି ଲେଙ୍ଗଦେ କାର୍‍ଙ୍ଗତଣ୍ଡ୍, “ହୋ ଜିସୁ, ଦାଉଦ୍‍ତେ ମାର୍‍, ନାକିଂଙ୍କ୍ ଦୟା ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ମାତର୍ ମୁନେ ଆଦାନଡ଼୍ ନାରୁଡ଼୍ କାନାଙ୍କ୍ ଦମକ୍ ଇସ୍‌ ଅଂକିଙ୍କ୍‌ କଟ ଆଦାଙ୍କ୍ କେତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ମେଣ୍ଡ୍ ଗାଟି ଲେଙ୍ଗତେ କାର୍‍ତଣ୍ଡ୍, “ହୋ ଦାଉଦ୍‍ ତେ ମାର୍‍, ନାକିଂଙ୍କ୍ ଦୟା ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ଜିସୁ ଆଗାଙ୍କ୍ ନିସ୍ ମିକା କାନାଙ୍କ୍ ଗାର୍‍ରେ ତାତାନଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ମେଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ଗାର୍‍ରେ ୱାତ୍‌ତେ ୱେଲେ, ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ନାନ୍ ନି ମାଇଦିଙ୍କ୍ ବାତ୍ ମାଡ଼ିତାନ୍ ଇଞ୍ଜ ନିମେ ଇଚ୍ଛା ମାଡ଼ୁତିନ୍ ? କାନାଲ୍ କେତ୍ତଣ୍ଡ୍, “ହୋ ପ୍ରବୁ, ନାନ୍ ବେଲାକି ମେଣ୍ଡେ ଉଡ଼୍‍ପାର୍ଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ଜିସୁ କାନାଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ତ ନିମେ କଣ୍ଡା ଉଡ଼େ; ନିୱାଦ୍ ବିଶ୍ୱାସ୍ ନିକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଣ୍ଡ୍‌ କଣ୍ଡାଉଡ଼ି, ଇଶ୍ୱରତେ ମହିମା କୀର୍ତ୍ତନ୍‍ ମାଡ଼ମାଡ଼ ଅନ୍‌ ପେର୍କେ ପେର୍କେ ତାଆକାନଙ୍କ୍ ପସ୍ପ୍‍ତଣ୍ଡ୍ ନୁ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଆଦ୍ ଉଡ଼ି ଇଶ୍ୱର୍‌ ତେ ପ୍ରସଂଶା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ପେର୍‍କେ ଜିସୁ ଯିରୀୟତାଗ୍ ଆସି ମିକା ଆଦ୍ ଆଲା ଇସ୍‌ ଆଞ୍ଜ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଜକୀୟ ପେଦେର୍ ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ମୁକ୍ୟକରଗ୍ରାହୀ ନୁ ସାଉକାର୍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜିସୁ ବେନଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ଉଡ଼ାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଚ୍ଛା ଆସମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁଡ଼୍ ମାନ୍ଦେ ମାଇଦିଙ୍କ୍ ଉଡ଼୍‍ ପାର୍‍ୱ ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ବୁଟି ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍‍ତେ ମୁନେ ମିରିଆଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ଉଡ଼ାନ୍ ସେଙ୍ଗ୍ ୱେରଡ଼୍ ତୟା ମାଡ଼େତାଗ୍ ତାର୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ହାର୍ ଇସ୍‌ ଜିସୁ ଆଦାନ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜିସୁ ଆଦ୍ ପଡ଼ିୟେତାଗ୍‍ ୱାସ୍ ପରୁ ଉଡ଼ି ଜକୀୟଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଜକୀୟ ସିଟ୍‍ପାଟ୍ ଡିଗି ୱାଡ଼ା, ବାତେଙ୍କ୍ ଇତ୍କେ ନେଣ୍ଡ୍ ନାକିଂଙ୍କ୍ ବେଲାମେଣ୍ଡେ ନି ଲୋନ୍‌‍ ମାନ୍ଦେୱେଇତିତ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ସିଟ୍‍ପାଟେ ଡିଗି ୱାସ୍ ୱେଡ଼୍‍କେତେ ଜିସୁଙ୍କ୍ ତାନ୍ ଲୋନ୍‌‍ କାର୍‍ଙ୍ଗି ହତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ଆଦ୍ ଉଡ଼ି ସାରେତଡ଼୍ ତାମ୍‍ତାମ୍ ଲୋପେ ତିରିୟି କେତାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ପାପି ମାନେୟ୍‍ତେ ଲୋନ୍‌‍ ମାନ୍ଦାଙ୍କ୍ ଆଦୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ଜକୀୟ ନିସ୍ ମିକା ପ୍ରବୁଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ହୋ ପ୍ରବୁ ଉଡ଼େ, ନାୟାଦ୍ ସମ୍ପତ୍ତି କନ୍‍ସ୍ ଆଦ୍‍ ଦାନ ନାନେ ଗରିବ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଇଦୁତାନ୍‍, ମେଣ୍ଡେ ଯଦି ଅନ୍‌ୟାୟତେ, ବେନନାଗାଙ୍କ୍ ବାତ୍‍ତେ ଅସ୍‍ମାତ୍କେ, ମେଣ୍ଡେ ନାଲୁ ଗୁଣତେ ଆଦ୍ ମାଲ୍‌ପିଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ଆଦିଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍ ବିଷୟତେ କେତ୍ତଣ୍ଡ୍, “ନେଣ୍ଡ୍ ଇଦ୍ ଲୋନ୍‌‍ ପରିତ୍ରାଣ ୱାତ୍‍ତେ, ତ ଇଣ୍ଡ୍ ମିକା ୱେର୍‍ଣ୍ଡ୍ ଅବ୍ରାହାମ୍‌ତେ ମାର୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ବାତ୍ ମାୟିମିନ୍ଦେ, ଆଦ୍ ମେହେକି ଗେଲ୍‍ସ୍‍ପାନ୍ ସେଙ୍ଗେ ନାରୁଡ଼୍ ପିଲେ ୱାସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ନାରୁଡ଼୍ ଇଦ୍ ଗଟିସାରେ କେଞ୍ଜାନ୍ ୱେଲେ ଜିସୁ ମେଣ୍ଡେ ୱେରଡ଼୍ ୱେଷଡ଼୍‍ କେତ୍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଯୀରୁଶାଲମ୍ ଗାର୍‍ରେ ଆଶେ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଇଶ୍ୱରତେ ରାଜ୍ୟ ଗାଟି ଯାପେ ତିଆର୍ ଆଦ୍‍ତେ ଇଞ୍ଜ ଅଡ଼୍‌ ହେର୍କା ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ଆଦିଙ୍କ୍ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ୱେରଣ୍ଡ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ମାନେଇ ତାନ୍ ସେଙ୍ଗେ ରାଜପଦ ଦର୍‍ସ୍‍କି ମାଲ୍‍ସ୍ ୱାଦାନ୍ ମାତ୍‍ତେ ଅଣ୍ଡ୍‌ ଜେଏକେ ଦେଶ୍ ଆତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ଅଣ୍ଡ୍‌ ତାମ୍ ଦଶ୍‌ଜାନ୍ ଦାସଡ଼୍‍କ୍‍ କାର୍‍ଙ୍ଗି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେରନ୍ ସୁନା ରୂପାଡାବ୍‌ ଇସ୍‌ କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ୱାଦାନ୍ ଯାକ ବେପାର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ବାତେଙ୍କ୍ ଇତ୍କେ ତାନ୍ ଦେଶ୍ ତେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ପାସ୍‍କ ମାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଅନ୍‌ ପେର୍‍କେ ଦୂତ୍‍କିଂଙ୍କ୍ ରହସ୍ କେତ୍‍ତଡ଼୍‍, “ଇ ନାରୁଡ଼୍ ଯେ ମା ପରୁ ରାଜତ୍ୱ ମାଡ଼ିତନ୍, ଇଦ୍ ମାନ୍‍ ଇଚ୍ଛା ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ପେର୍‍କେ ଅଣ୍ଡ୍‌ ରାଜପଦ ଦର୍‍ସ୍‍କି ଆଗାଙ୍କ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତଣ୍ଡ୍ । ବେନ୍ ଦାସଡ଼୍‍କ୍‍ ରୂପାଡାବ୍‌ ଇସ୍‌ ମାତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌‍ ଲୋପେ ବେପାର୍ ମାଡ଼ି ବେନ ବେସର୍ ଲାବ୍ ମାଡ଼୍‍ତଡ଼୍, ଆଦ୍ ପୁନ୍ଦାଙ୍କ୍ ସେଙ୍ଗେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ତାନ୍ ଗାର୍‍ରେ କାର୍‍ଙ୍ଗି ତାତାନଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ଆଗାଙ୍କ୍ ମୁନେଙ୍କ୍ ୱେରଣ୍ଡ୍ ୱାସ୍ କେତ୍ତଣ୍ଡ୍, “ପ୍ରବୁ, ନିୟାୱୁ ସୁନା ରୂପାଡାବ୍‌ତେ ମେଣ୍ଡେ ନାନ୍ ଦଶ୍‍ଟାନ୍ ସୁନା ରୂପାଡାବ୍‌ ଲାବ୍ ମାଡ଼୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ଲେକେତ୍‍, ସାୟେ ଦାସ, ନିମେ ଗାଟି ସୁଦୁର୍‍ ବିଷୟତେ ବିଶ୍ୱାସ୍ତ ଆଦାଙ୍କ୍ ଦଶ୍‍ଟାନ୍ ନଗର୍‍ ତେ ପରୁ ଅଦିକାର୍‌ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ମେଣ୍ଡେ ଦ୍ୱିତିୟ ନାରୁଣ୍ଡ୍‌ ୱାସ୍ କେତ୍ତଣ୍ଡ୍, “ପ୍ରବୁ, ନିୟାୱ୍‍ ରୂପାଡାବ୍‌ନ୍‍ ଏଇଙ୍ଗ୍ ରୁପେୟ୍ ଲାବ୍ ମାଡ଼୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ମିକା କେତ୍ତଣ୍ଡ୍, “ନିମେ ଆନ୍‌‍ତେ ଏଇଙ୍ଗ୍ ନଗର୍‍ତେ ପରୁ ଅଦିକାର୍‌ ଦର୍‍କ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ୱାସ୍ କେତ୍ତଣ୍ଡ୍, “ପ୍ରବୁ, ଉଡ଼େ, ଇଦ୍ ନିୱାଦ୍ ସୁନା ରୁପେୟ୍, ନାନ୍ ଇଦିଙ୍କ୍ ତୁୱାଲ୍ ତାଗ୍ ତହସ୍ ନେହେସ୍ ମାତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ନିକିଂଙ୍କ୍ ୱେର୍‍ତାନ୍, ବେଲାକି ନିମେ ୱେରନ୍ ଗାଡ଼୍‍ସିନ୍ ମାନେଇ, ବାତେଏ ନେହେସ୍ ମାନଡ଼୍‍, ଆଦିଙ୍କ୍ ପେହେକି ଆଦ୍‍ତିନ୍, ମେଣ୍ଡେ ବାତେଏ ୱିତୱେ ମାନ୍‍ତଡ଼୍, ଆଦିଙ୍କ୍ କଇଦ୍‍ତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ରେ ଦୁଷ୍ଟ ଦାସ, ନି ମକମ୍‍ତେ ଗଟିନେ ନିୱାଦ୍ ବିଚାର୍ ମାଡ଼ିତାନ୍ । ନାନ୍ ୱେରନ୍ ଗାଡ଼୍‍ସିନ୍ ମାନେଇ, ବାତେଏ ନେୱକଟ ମାନ୍‍ତାନ୍, ଆଦିଙ୍କ୍ ପେହେକି ଆଦ୍‍ତାନ୍, ମେଣ୍ଡେ ବେଗେୱିତି ମାନନ୍, ଆଦିଙ୍କ୍ କୟଦ୍‍ତାନ୍, ଆଦ୍ ନିମେ ପୁଞ୍ଜ୍ ମାତ୍‍ତି । ");
INSERT INTO kff_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ଆଲାତ୍କେ, ବ୍ୟାଙ୍କ୍ ତାଗ୍ ବାତେଙ୍କ୍ ନାୟାୱ୍ ରୁପେୟ୍ ନେହେୱିନ୍ ? ଆଲାତ୍କେ ନାନ୍ ୱାସ୍ ଉଦାର୍ ତଡ଼୍ ଆଦିଙ୍କ୍ ଆଦାୟ ମାଡ଼େନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ମେଣ୍ଡ୍, ଆଦ୍ ବକେତ୍ ନିସ୍ ମାନ୍ଦାନ୍ ମାନେଇନଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇନାଗାଞ୍ଚ୍ ଇଦ୍ ରୁପେୟ୍ ହସ୍‍ମିକା, ବେନନାଦ୍ ଦଶ୍‍ଟାନ୍ ରୁପେୟ୍ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ହିମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ଆଗାସ୍‍ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ କେତ୍ତଡ଼୍, “ପ୍ରବୁ, ଅନାଦ୍‌ ତ ଦଶ୍‍ଟାନ୍ ରୂପାଡାବ୍‌ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, “ବେନ୍ ମାନେଇତିଙ୍କ୍ ମିନ୍ଦେ, ଅଂକିଙ୍କ୍‌ ହିଦ୍‍ତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍କେ ବେନନାଦ୍ ଇଲ୍‍ଲେ, ଅନାଗ୍ ବାତ୍ ମିନ୍ଦେ, ଆଦେ ମିକା ଅନାଗାଙ୍କ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ବାତେଙ୍କ୍ ଇତ୍କେ, ନାୟାୱୁ ଇ ବେନ୍ ଶତ୍ରୁଡ଼୍ ନାନ୍ଅଡ଼୍‌‍ ପରୁ ରାଜତ୍ୱ ମାଡ଼ିତାନ୍ ଇଞ୍ଜ ଇଚ୍ଛା ମାଡ଼୍‍ୱେ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଗେ ତାସ୍ ନା ମୁନ୍‍ନେ ହାୱ୍‍କାଟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଜିସୁ ଇଦ୍‍ସାରେ ଗଟିକେସ୍ ତେର୍‍ସ୍ପ୍‍ତେ ପେର୍‍କେ ଶିଷ୍ୟଡ଼୍ ମୁନେ ଯିରୁଶାଲେମ୍‍ତା ଆଦାନଙ୍କ୍ ପସ୍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ମେଣ୍ଡ୍, ବେସୁଟ୍‌ ଅଣ୍ଡ୍‌ ଜୀତ ମେଟେତ୍ ଗାର୍‍ରେ ବେତ୍‍ପାଗୀ ନୁ ବେତନିୟା ଗାର୍‍ରେ ହେଉତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ତାନ୍ ଶିଷ୍ୟନଡ଼୍ ଲୋପେଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍‍କିଙ୍କ୍ ଇଦ୍ ଗଟ୍ କେସ୍ ରହତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ମି ମୁନେ ଆଦ୍ ନାର୍‍ଦାଗ୍ ଆନୁଟ୍; ଆଗେ ଅସାନ୍ ୱେଲେ, ବେନେ ତାନ୍‌ପରୁ କୁଦ୍‍ୱେ ମାନ୍‍ତଣ୍ଡ୍, ଇଦ୍ ରକମ୍ ଅଣ୍ଡ‍ୟ୍ ଗଦପିଲ୍ ତହସ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼ିତିଡ଼୍; ଆଦିଙ୍କ୍ ଲେହେସ୍ ତାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ମେଣ୍ଡେ, ଆସୁଙ୍କ୍ ବେନ ମିକିଂଙ୍କ୍ ବାତେଙ୍କ୍ ଲେତୁତିଡ଼୍ ଇଞ୍ଜ ପାଚ୍ରା ମାଡ଼ିତଡ଼୍, ଆସୁଙ୍କ୍ ଇଲା କେତିତିଡ଼୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍କେ ହିଦ୍ ପ୍ରବୁଙ୍କ୍ ଦର୍‍କାଡ଼୍‍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ଆ ରହତ୍‌ତେ ଶିଷ୍ୟଡ଼୍‌ ଆଞ୍ଜ୍, ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେଲାକେସ୍‍ ମାତ୍‍ତଣ୍ଡ୍, ଆଦେପୁଟୁଙ୍କ୍ ଉଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ମେଣ୍ଡେ, ଅଡ଼୍‌‍ ଗଦପିଲେତିଙ୍କ୍ ଲେତାନ୍‍ ୱେଲ୍‍ ଆଦିନ୍ ମାଲିକ୍ ହଡ଼୍‍କିଙ୍କ୍ ପଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ବାତେଙ୍କ୍ ଗଦ ପିଲେତିଙ୍କ୍ ଲେତୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍, “ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦିନାଗ୍‍ ପ୍ରବୁନାଦ୍ ଦର୍‍କାର୍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ମେଣ୍ଡେ, ଆଦିଙ୍କ୍ ଜିସୁନ୍ ଗାରେତାସ୍‍ ତାନ୍‍ପରୁ ନିଜେ ନିଜେତ୍ ସିଲେ ୱାଟି ଜିସୁଙ୍କ୍ କୁସ୍‍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ମେଣ୍ଡେ, ଅନ୍‌ ଆଦାନ୍ ୱେଲେ ନାରୁଡ଼୍‌ ରୋଟିନାଗ୍‍ ସିଲେ ତାରାନଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ବେସୁଙ୍କ୍‍ ଜୀତ ମେଟେତାଗ୍ ଡିଗୁଡ଼୍ ପଡ଼ିୱେତ୍ ଗାର୍‍ରେ ଏୱୁତଡ଼୍‍, ଆସୁଙ୍କ୍ ସାର୍‍ରେତଡ଼୍ ଶିଷ୍ୟଡ଼୍ ଉଡ଼ିମାନ୍ଦାନ୍‍ ସାରେ ଶକ୍ତିତାଦ୍‍ ପାଡ଼ିୟି ମାଇଦିଙ୍କ୍ ୱେଡ଼୍‍କେତେ ଗାଟିଲେଙ୍ଗ୍‍ଦେ ଇଶ୍ୱରତିଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼ଡ଼୍‍ ମାଡ଼ଡ଼୍‍ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ପ୍ରବୁନ୍ ପେଦେର୍‍ତେ ବେନ୍ ରାଜାଲଡ଼୍ ୱାସ ମିନ୍ଦେଡ଼୍, ଅଣ୍ଡ୍‌ ଦନ୍ୟ । ସ୍ୱର୍ଗତାଗ୍ ଶାନ୍ତି ନୁ ପ୍ରବୁନାଦ୍ ମହିମା ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ଆଗାଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ପାରୂଶୀଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ହୋ ଗୁରୁ, ନି ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କଟ ଆଦାଙ୍କ୍ କେଲମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ଜିସୁ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍ ଇଡ଼୍ ଯଦି କଟ ମାତ୍‍କେ, କାଲ୍ ଆନ୍‌‍ତେ ଗଟି କେତିତା ।” ");
INSERT INTO kff_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ମେଣ୍ଡେ, ବେସୁଙ୍କ୍‍ ଜିସୁ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ନାର୍‍ତିଙ୍କ୍ ଉଡ଼ି ଆଦିନ୍ ସେଙ୍ଗେ କେୟି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ନିମ୍‍, ହଁ, ନିମ୍‍ ଯଦି ନେଣ୍ଡ୍ ଶାନ୍ତିତେ ବିଷୟତିଙ୍କ୍ ପୁଞ୍ଜ୍‍ମାନେନି, ମାତର୍ ଇଞ୍ଜେ ଆଉ ତ ତୋନ୍ଦକଟ ମିଞ୍ଜି ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ତ ନି ପରୁ ମାନ୍ଦାନ୍ ଦୟାତାଦ୍ ସମୟ୍ ପୁନ୍‍ୱାଙ୍କ୍, ଶତ୍ରୁଡ଼୍ ନି ସାରେ ପାକେ ପେଟି ତହସ୍ ନିକିଂଙ୍କ୍ ବନ୍ଦି ମାଡ଼ିତଡ଼୍ ମେଣ୍ଡେ ନିୟାୱୁ ସାରେ ହାର୍ ବନ୍ଦ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ମେଣ୍ଡେ ଅଡ଼୍‌‍ ନିକିଂଙ୍କ୍ ନୁ ନି ପାକେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କ୍ ପୁରା ଦସଂ ମାଡ଼ିତଡ଼୍, ଅଣ୍ଡୟ୍‌ କାଲ୍ ବଦେ ମିକା ଅଡ଼୍‌‍ ପଡ଼୍‍ୟେତାଗ୍‍ ୱିଡ଼୍‍ସଡ଼୍‍, ବାତେଙ୍କ୍ ଇତ୍କେ ବେସୁଟ୍‌ ଇଶ୍ୱର୍‌ ରକ୍ଷା ମାଡ଼ାଙ୍କ୍ ୱାତ୍‍ତଣ୍ଡ୍ ନିମେ ଅଂକିଙ୍କ୍‌ ହେଞ୍ଚାଙ୍କ୍ ପାର୍‍ୱି ।” ");
INSERT INTO kff_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ମେଣ୍ଡେ, ଜିସୁ ମନ୍ଦିର୍‍ତେ ଲୋପେ ଆସ୍‍ତଣ୍ଡ୍, ୱାମ ମାନ୍ଦାନ୍ ମାନେଇକିଂଙ୍କ୍ ଇଲା କେସ୍ ପେସ୍‍ପାନଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ଇଶ୍ୱର୍ କେତ୍‍ତଣ୍ଡ୍, ମାୱାଦ୍‍ ଲୋନ୍‌ ପ୍ରାର୍ତନାଲୋନ୍‌ ଆଦ୍ ତେ, ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ଆଦିଙ୍କ୍ ଡଙ୍ଗାଲଡ଼୍ ଲୋନ୍‌ ଲେକାମ୍ ମାଡ଼ିମିନ୍ଦେଡ଼ି ।” ");
INSERT INTO kff_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ସାରେଦିନାମ୍ ଯିରୁଶାଲେମ୍ ମନ୍ଦିର୍‍ତାଗ୍ ଶିକ୍ଷା ହିସମାତ୍‍ତଣ୍ଡ୍, ମାତର୍ ବେଡ଼ିୟି ଯାଜକ୍‌ ନୁ ଶାସ୍ତ୍ରୀନଡ଼୍ ନାରୁଡ଼୍‌ତେ ନେତାଲଡ଼୍ ତଡ଼୍ ଅଂକିଙ୍କ୍‌ ଆୱୁକାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ବାତେଙ୍କ୍ ଇତ୍କେ ମାନେଇ ସାରେତଡ଼୍ ଅଣ୍ଡୟ୍‌‍ମନ୍ ଆସ୍‍ ଜିସୁନ୍ ଶିକ୍ଷା କେଞ୍ଜମାତ୍‍ତଡ଼୍ ଆଦିଙ୍କ୍ ଅଡ଼୍‌‍ ବାତେଏ ମାଡ଼ିତଡ଼୍ ଆଦିନାଦ୍ ଉପାୟ୍ ଦର୍‍ସ୍‍କାଙ୍କ୍ ପାର୍ୱେମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ଆଗ୍‍ତିନ୍‍ସ୍ ଆଦ୍ ଦିନାମ୍ ବେସୁଙ୍କ୍‍ ଜିସୁ ମନ୍ଦିର୍‍ତାଗ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶିକ୍ଷା କେସମାତ୍‍ତଣ୍ଡ୍ ନୁ ସୁସମାଚାର୍ କେସମାତ୍‍ତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ମୁକ୍ୟାଲଡ଼୍ ମାନେଇ ନୁ ଶାସ୍ତ୍ରୀଡ଼୍ ବାଡ଼ିୟା ନାରୁଡ଼୍ ତଡ଼୍ ୱାସ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“ନିମେ ବେନ୍ ଅଦିକାର୍‌‍ତେ ଇଦ୍‍ସାରେ ମାଡ଼ୁତିନ୍, ନିକିଂଙ୍କ୍ ଇଦ୍ ଅଦିକାର୍‌ ବେନ ଇତ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ବେନନ୍, ମାକିଂଙ୍କ୍ କେଲେ ।” ");
INSERT INTO kff_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ଇତ୍‌ତଣ୍ଡ୍‌, “ନାନ୍ ମିକା ମିକିଂଙ୍କ୍ ୱେରଡ଼୍ ଗଟ୍ ପାଚ୍ରାମାଡ଼ିତାନ୍, ନାକିଂଙ୍କ୍ କେଲ୍‍ମୁଟ୍, ");
INSERT INTO kff_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ବାପ୍ତିସ୍ମ ଯୋହନ୍‌‌ତାଦ୍ ବାପ୍ତିସ୍ମ ହିଦାନାଦ୍ ଅଦିକାର୍‌ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ନା ନାରୁଡ଼ାଗାଙ୍କ୍ ଦର୍ସିମାତ୍‌ତନ୍‌ ?” ");
INSERT INTO kff_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ନିଜେ ନିଜେ ଯୁକ୍ତିତର୍କ ମାଡ଼ି କେତାକେତି ଆତ୍‍ତଡ଼୍, “ଯଦି ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଇଞ୍ଜ କେତିତାଡ଼୍‍, ଆଲାତ୍କେ ଅଣ୍ଡ୍‌ କେତିତଣ୍ଡ୍, ମିଡ଼୍ ବାତେଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ଯଦି ମାନେଇ କନ୍‍ସ୍ ଇଞ୍ଜ କେତିତାଡ଼୍‍, ଆଲେକେ ମାନେଇ ସାରେତଡ଼୍ ମାନାଙ୍କ୍‍ କାଲ୍‍କିନ୍ ତଡ଼୍ ପିଞ୍ଜ୍‍ପ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଯୋହନ୍‌ ଯେ ୱେରଣ୍ଡ୍ ବାବବାଦୀ ଇଦ୍ ଅଡ଼୍‌‍ୱାଦ୍ ଗାଟି ବିଶ୍ୱାସ୍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଆଦିଙ୍କ୍ ଆଦ୍ ବେଗାଙ୍କ୍ ଆତ୍‍ତେ, ଇଦ୍ ପୁନମ୍ ଇଞ୍ଜ ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଆଲେକ୍‍ ନାନ୍ ବେନ୍ ଅଦିକାର୍‌‍ତେ ଇଦ୍‍ସାରେ ମାଡ଼ୁତାନ୍, ଆଦ୍ ନାନ୍ ମିକା ମିକିଂଙ୍କ୍ କେଲନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ଜିସୁ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଇଦ୍‍ ୱେଷଡ଼୍‍ କେତାନଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ଅଙ୍ଗୁର୍‌ୱାୟେ ମାଡ଼ି ଆଦିନ୍ ଅଣ୍ଡୟ୍‌‍ ଦୁଡ଼େ ଚାଷିନାରୁଡ଼୍‍କ୍ ଇସ୍‌ ନାର୍ଗେ ଦିନାତ୍ ସେଙ୍ଗେ ବିଦେଶ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ମେଣ୍ଡେ, ଚାଷିନାରୁଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଅଙ୍ଗୁର୍ ୱାୟେତ୍‍କନ୍‍ସ କାୟାନେ ପାଲ୍‍କ୍ ହିଦ୍‍ତଡ଼୍, ଇଦିନ୍‍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଦାସଙ୍କ୍ ଟିକ୍ ଦିନାମ୍ ତେ ଅଡ଼୍‌‍ ଗାର୍‍ରେ ରଅତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ଚାଷିନାରୁଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ରେହେସ୍ ଆସାମ୍ କାଇଦେ ରଅତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ଅଣ୍ଡ୍‌ ମେଣ୍ଡେଅର୍‍ତୁନ୍‍ ଦାସଙ୍କ୍ ରଅତଣ୍ଡ୍; ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ମିକା ଅପ୍‍ମାନ୍ ମାଡ଼ି ବାତେଏ ହିୱକଟ ଆସାମ୍ କାଇଦେ ରହସିତ୍ ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ପେର୍‍କେ ଅଣ୍ଡ୍‌ ତୃତୀୟ ନାରୁଙ୍କ୍ ମିକା ଆଦ୍‍ଲେକାମ୍ ରଅତଣ୍ଡ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ମିକା ଚିହ୍ନେନେ ମାଡ଼ି ରେହେସ୍ ବାଇଦେ ହେସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ଆଗାଙ୍କ୍ ଅଙ୍ଗୁର୍ ୱାୟେତେ ମାଲିକ୍ କେତ୍‍ତଣ୍ଡ୍, ନାନ୍ ବାତ୍ ମାଡ଼ିତାନ୍ ? ନା ପ୍ରିୟ ମାର୍‍ଦିଙ୍କ୍ ରହତିତାନ୍, ଅଡ଼୍‌‍ ନିଜାମ୍ ଅନ୍‌ ଗଟି କେଞ୍ଜିତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ମାତର୍ ଚାଷିନାରୁଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ତାମ୍‍ତାମ୍ ଲୋପେ କେତାକେତି ଆସ୍‍ କେତ୍‍ତଡ଼୍, ଇଣ୍ଡ୍ ତ ଉତ୍ତରାଦିକାରି, ଇକିଂଙ୍କ୍ ଆୱକିକାଡ଼୍‍, ବେଲାକି ସାରେ ସମ୍ପତି ମାନାଦ୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ମେଣ୍ଡେ, ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଅଙ୍ଗୁର୍ ୱାୟେତେ ବାଇଦେ ତାସ୍‌ ଆଉକ୍‍ତ୍‍ତଡ଼୍ । ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ଇଞ୍ଜେ ଅଙ୍ଗୁର୍ ୱାୟତେ ମାଲିକ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାତ୍ ମାଡ଼ିତନ୍ ? ");
INSERT INTO kff_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ଅଣ୍ଡ୍‌ ୱାସ୍ ଚାଷିନାରୁଡ଼୍‍କ୍ ଆୱକିତଣ୍ଡ୍ ନୁ ମେଣ୍ଡେ ବାଗାତଡ଼୍‍କ୍‍ ଅଙ୍ଗୁର୍ ୱାୟା ହିଦ୍‍ତଣ୍ଡ୍ । ଆଦ୍ କେଞ୍ଜି ଅଡ଼୍‌ କେତ୍ତଡ଼୍‍ ଆଲା ଆଇମା କି । ");
INSERT INTO kff_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ନଜର୍‍ ଉଡ଼ି କେତ୍ତଣ୍ଡ୍, “ଇଦ୍ ବେନ୍ ବାକ୍ୟ ଲେକାମିନ୍ଦେ, ଆଦିନ୍ ଅର୍ତ ବାତେଏ,” ଲୋନ୍‌‍ ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ବେନେ କାଲ୍‍କିଙ୍କ୍ ପାହାସ୍କ୍‍ତଡ଼୍‍, ଆଦ୍ ମୁନେତ୍ ମୁକ୍ୟ କାଲ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ବେନବାଡ଼େ ଆଦ୍ କାଲ୍ ଦେ ପରୁ ରାଲିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଦୁଡ଼ାଦୁଡ଼ା ଆଦ୍‍ତନ୍, ମେଣ୍ଡେ ଆଦ୍ କାଲ୍ ବେନନ୍ ପରୁ ରାଲିତେ, ଅଂକିଙ୍କ୍‌ ଆଦ୍ ଇଦି‍ଲ୍‍ସ୍ପିତ୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ଆଗାଙ୍କ୍ ଶାସ୍ତ୍ରୀ ନୁ ବେଡ଼ିଇ ଯାଜକିଡ଼୍ ଆଦ୍ ଦଣ୍ଡ୍ ତାଗ୍ ଅଙ୍କ୍‌ ପଇଦାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌ ନାରୁଡ଼୍‍କ୍ ୱେର୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଆଦ୍ ୱେଷଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଡ଼ି ମିକା କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଅଡ଼୍‌‍ ପୁତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ଆଗାଙ୍କ୍ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଅନ୍‌ ପରତ୍ ଅଦିକାର୍‌ କାଇଦେ ନୁ ଶାସନ୍‍ ମୁକ୍ୟାନ୍ ଅଦିନତାଗ୍ ଇତ୍‍ତନ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ସୁଯୋଗ୍ ମେହେକି ଅନାଦ୍‌ ଗଟିନେ ସୁଦୁଟ୍ ବୁଲ୍ ପଇତାନଙ୍କ୍ ଦାର୍ମିକ୍ ଇଞ୍ଜ ତଅତାନ୍ ଡଙ୍ଗାଲଡ଼କ୍‍ ଜିସୁନ୍ ଗାର୍‍ରେ ରହତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ହୋ ଗୁରୁ, ମାମେପୁତ୍‍ତମ୍, ନିମେ ବାତେଏ କେତୁତିନ୍ ନୁ ଶିକ୍ଷା ହିଦୁତିନ୍‍, ମେଣ୍ଡେ ନିମେ ବେନନ୍ ମକମ୍‍ତିଙ୍କ୍ ଉଡ଼ି ମାଡ଼୍‍ୱିନ୍, ମାତର୍ ନାରୁଡ଼୍‍ତେ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତାଦ୍ ଇଚ୍ଛା ବିଷୟତେ ସତ୍‍ ଶିକ୍ଷା ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ମାକିଂଙ୍କ୍ କେଲେ, ରୋମୀୟ ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ କାଇସର୍‍ତିଙ୍କ୍ କର ଇଦାନ୍ ମାନାଦ୍‍ ନିୟମ୍‍ ମିନ୍ଦେ କି ଇଲ୍‍ଲେ ?” ");
INSERT INTO kff_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","କିନ୍ତୁ ଜିସୁ ଅଡ଼ାଦ୍‌ ଚାଲାକି ପୁଞ୍ଜ୍ ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ନାକିଂଙ୍କ୍ ୱେରନ୍ ରୁପାଡ଼ାବ୍‍କ୍ ତଅମୁଟ୍ । ଇଗେ ବେନନାଦ୍ ମୂର୍ତ୍ତି ନୁ ପେଦେର୍ ମିନ୍ଦେ ? ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍ କାଇସର୍‌ତାଦ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ଆଗାଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଆଲେକେ କାଇସର୍‌ତାଦ୍ ବାତେଏ, ଆଦ୍ କାଇସର୍‍ତିଙ୍କ୍ ହିମୁଟ୍; ମେଣ୍ଡେ, ଇଶ୍ୱର୍‌ତାଦ୍‍ ବାତେଏ, ଆଦ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଇମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଆଗ୍‍ତିନ୍‍ସ୍ ଅଡ଼୍‌‍ ଜିସୁନ୍ ବୁଲ୍‍ ପଇତାଙ୍କ୍ ପାର୍‍ୱଡ଼୍, ମେଣ୍ଡେ, ଅନ୍‌ ଗଟି କେଞ୍ଜି ବାକ୍‍ୱା ଆସ୍ କୋଟ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ତାନ୍ ପେର୍‍କେ ନାରୁଡ଼ାଦ୍ ପୁନରୁତ୍‍ତାନ୍ ମିନ୍ଦେ ଇଞ୍ଜ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ସାଦ୍ଦୂକିଡ଼୍‍ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ହୋ ଗୁରୁ, ମଶାଲ୍‌ ମା ସେଙ୍ଗେ ଲେକିମିନ୍ଦେଣ୍ଡ୍ ଯେ, ଯୋଦି ବେନ ନାରୁଡ଼୍ ତେ ପେଣ୍ଡୁଲ୍ ଆସ୍ ପିଲା ଇଲକଟ ଡଲ୍‍କେ, ଆଲାତ୍କେ ତାନ୍ ତାମୁଣ୍ଡ୍‌ ତାମ୍ ଦାଦାନ୍ ମୁତେଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆସ୍, ତାମ୍ ଦାଦାନ୍ ସେଙ୍ଗେ ପିଲାଜିଲା ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ମେଣ୍ଡେ ସାତ୍‍ଜାନ୍ ତାମୁସ୍‍କ୍‍ ମାତ୍‍ତଡ଼୍; ମୁନେଙ୍କ୍ ତଣ୍ଡ ବେଡ଼ିଇ ଦାଦାଲ୍ ପେଣ୍ଡୁଲ୍ ଆଶେ ନିଃସନ୍ତାନ ଆଶେ ଡଲ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ତାନ୍ ପେର୍‍କେ ଦ୍ୱିତିୟ ତଣ୍ଡ ତାଙ୍କ୍ ପେଣ୍ଡୁଲ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ମେଣ୍ଡେ ତୃତୀୟ ତଣ୍ଡ୍‌ ଅଣ୍ଡ୍‌ ମିକା ତିପାଲ୍ ଆସ୍ ଡଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ଆଦିନ୍ ଲେକେମ୍ ସାତ୍‍ଜାନ୍‍ଯାକ ଆଲେ ତିପାଲ୍ ଆସ୍ ଡଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ତାନ୍ ପେର୍କେ ମୁତ୍‍ତେ ମିକା ଡଲ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ତ, ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ପୁନରୁତ୍‍ତାନ୍ ଆତ୍‍ତେୱେଲେ ଅଡ଼୍‌‍ ଆଗାଙ୍କ୍ ଆଦ୍ ବେନନ୍ ମୁତ୍‍ତେ ଆଦ୍ ତେ ? ସାତ୍‍ଜାନ୍ ଯାକ ତ ଆଦିଙ୍କ୍ ପେନ୍‍ଣ୍ଡୁଲ୍ ଆସ୍‍ମାତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଇଦ୍ ଜଗତ୍ ତାଗ୍ ନାରୁଡ଼୍ ପେଣ୍ଡୁଲ୍ ଆଦ୍‍ତଡ଼୍ ନୁ ପେଣ୍ଡୁଲ୍ ହିଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ବାତେଙ୍କ୍ ଇତ୍କେ ବେନଡ଼୍ ପୁନରୁତ୍‍ତିତ୍ ହାସ୍ ସ୍ୱର୍ଗତାଗ୍ ବାଦ୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ଯୋଗ୍ୟ, ଅଡ଼୍‌‍ ମେଣ୍ଡେ ପେଣ୍ଡୁଲ୍ ଆୟ୍‍ୟଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ଅଡ଼୍‌ ମେଣ୍ଡେ ଡଲ୍‍ଲେ ପାର୍‍ୱଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌ ଦୂତକିନ୍ ଲେକେମ୍ ମାନ୍‍ତଡ଼୍, ନୁ ମେଣ୍ଡେ ଅନ୍‌‍ଦାମ୍ ଜିୱେ ଆତ୍‍ତାଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ମାୟାଡ଼୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ମାତର୍ ଡଲତେନଡ଼୍‍ ଯେ ତେଦିତଡ଼୍, ଇଦ୍ ମଶାଲ୍‌ ମିକା ନିଡ଼୍‍ତାନ୍ ପଦ୍ଲାତେ ୱେଷଡ଼୍ ତଡ଼୍ ପ୍ରବୁଙ୍କ୍ ଅବ୍ରାହାମ୍‌ ତେ ଇଶ୍ୱର୍‌, ଇସ୍‍ହାକ୍ ତେ ଇଶ୍ୱର୍‌ ନୁ ଯାକୁବ୍ ତେ ଇଶ୍ୱର୍‌ ଇଞ୍ଜ କେସ୍ ନିୟମ୍ ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ଅଣ୍ଡ୍‌ ତ ଡଲ୍‍ତେ ନଡ଼ାଦ୍ ଇଶ୍ୱର୍‌ ଆୟଣ୍ଡ୍, ମାତର୍ ଜିୱୁଣ୍ଡ୍ ମାନ୍ଦାନଡ଼ାଦ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ସାରେତଡ଼୍ ଅଣ୍ଡ୍‌ ମୁନେ ଜିୱୁଣ୍ଡ୍ ନାରୁଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ଆଗାଙ୍କ୍ ଶାସ୍ତ୍ରୀଡ଼୍ ବେସ୍‌କ୍ ତୁଡ଼୍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ହୋ ଗୁରୁ, ନିମେ ଟିକ୍ କେତ୍‍ତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ବାତେଏ ମିକା ପ୍ରଶ୍ନ କେତାନଙ୍କ୍ ମେଣ୍ଡେ ଅନ୍‌ ଦାମ୍ ସାହାସ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍‍, “କ୍ରିଷ୍ଟ ଯେ ଦାଉଦ୍‍ଉତ୍ ମାର୍‍, ଇଦ୍ ନାରୁଡ଼୍ ବେଲା କେତିତଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ବାତେଙ୍କ୍ ଇତ୍କେ ନିଜେ ଦାଉଦ୍‍ ଗୀତସଂହିତାତାଗ୍ କେତ୍ତଣ୍ଡ୍, ପ୍ରବୁ ନା ପ୍ରବୁଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ମାମେ ବେସୁଟ୍‌ ଯାକ ମି ଶତ୍ରୁଡ଼୍‍କ୍ ମିୱାଦ୍ ଡେକେତ୍ ମଦଲ୍‍କଞ୍ଜ୍ ତାଡ଼ାମ୍, ଆସୁଙ୍କ୍ ହେଉନା ମା ତିନ୍ଦେକାଇଦେ ପାକେ କୁଦିମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ଦାଉଦ୍‍ ଜିସୁଙ୍କ୍ ପ୍ରବୁ ଇଞ୍ଜ କେତିତଣ୍ଡ୍; ଆଲାତ୍କେ ଅଣ୍ଡ୍‌ ବେଲା ଅନ୍‌ ମାର୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ପେର୍‍କେ ଜିସୁ ସାରେତଡ଼୍ ନାରୁଡ଼୍ ମୁନ୍‍ନେ ଶିଷ୍ୟକିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ଶାସ୍ତ୍ରୀନଡ଼୍‍ ଆଗାଙ୍କ୍ ସାବ୍‍ଦାନ୍ ! ଅଡ଼୍‌‍ ଲାଟି ଚକା କେର୍‍ଦିତଡ଼୍ । ମେଣ୍ଡେ ହାଟ୍ ବାଜାର୍‍ତାଗ୍ ନମସ୍କାର୍, ସମାଜ୍ ଲତ୍‍ତାଗ୍ ମୁକ୍ୟ ଆସନ୍ ନୁ ବଜିତାଗ୍ ସାଏତ୍ ପଡ଼ିୟିତାଗ୍ କୁଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ଅଡ଼୍‌‍ ରାଣ୍ଡିମୁତେନ୍ ଲୋକିଙ୍କ୍ ଆଦ୍‍ତଡ଼୍ ନୁ ବୁସାମାଡ଼ି ଲାଟି ପ୍ରାର୍ତନା ମାଡ଼ିତଡ଼୍; ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗାଟି ଦଣ୍ଡ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ଜିସୁ ସାରେପାକେ ଉଡ଼ି ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ସାଉକାର୍ ନାରୁଡ଼୍ ମନ୍ଦିର୍‍ତାଗ୍ ଦାନପେଟ୍‌ତାଗ୍ ଦାନ ୱାଟାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ମେଣ୍ଡେ ଆଦ୍ ୱେରଡ଼୍ ଗରିବ୍ ରାଣ୍ଡିଲ୍ ଆଗେ ରେଣ୍ଡ୍ ରୁପି ୱାଟାନାଦ୍ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, “ଇଦ୍ ଗୋରିବ୍ ରାଣ୍ଡି ମୁତ୍‍ତେ ସାର୍‍ରେ ତାଗାଙ୍କ୍ ନାର୍ଗେ ଦାନ ୱାଟ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ବାତେଙ୍କ୍ ଇତ୍କେ ଇଡ଼୍‍ ସାର୍‍ରେ ତୁଡ଼୍ ପେଟ୍‍ତାଗ୍ ତାମ୍‍ତାମ୍ ନାର୍ଗେ ଦନ୍ ତାଗାଙ୍କ୍ ସୁକୁ ସୁକୁ ୱାଟ୍‍ଟଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ତାନ୍ ମାନ୍ଦାନାଦ୍ ଅବସ୍ଥାତେ ବା ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍ ଗେଲସ୍‍ପାନ୍ ମାଇଦିଙ୍କ୍ ତାନାଗ୍‍ ବେସର୍ ମାତ୍‍ତା ହାୱୁସାରେ ୱାଟ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ମେଣ୍ଡେ, ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍ ମନ୍ଦିର୍ ବିଷୟତେ ମିଟିଙ୍କ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌‍ କେସ ମାତ୍‍ତଡ଼୍, “ଆଗେ ୱାଟ୍‍ତାଉ ସୁନ୍ଦର୍ କାଲ୍‍କ୍ ନୁ ଇଶ୍ୱର୍‌ତେ ସେଙ୍ଗେ ଇସ୍‌ ମାନ୍ଦାନ୍ ଉପହାର୍ ତଡ଼୍ ମନ୍ଦିର୍ ଗାଟି ସୁନ୍ଦର୍ ତଅନ୍‌ଦୁତେ !” ");
INSERT INTO kff_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ମିଡ଼୍ ଇଦ୍ ବାତେସାରେ ଉଡ଼ୁତିଡ଼୍, ଦିନାମ୍‌ ୱାଦ୍‍ତା, ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ କାଲ୍ ମେଣ୍ଡନ୍ କାଲ୍ ଦେ ପଡ଼ିୟେତାଗ୍ ମାନ୍‍, ସାରେତଡ଼୍ ବୂମ୍‌ତାଗ୍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ଆଗାଙ୍କ୍ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ କେତ୍ତଡ଼୍, “ହୋ, ଗୁରୁ, ଇଦ୍‍ସାରେ ବେସୁଙ୍କ୍‍ ଗଟେମ୍ ଆଦ୍ ତେ ? ମେଣ୍ଡେ, ବେନ୍ ଦିନାମ୍‍ତେ ଇଦ୍‍ସାରେ ଗଟନା ଦିନାମ୍ ତେରିତେ, ଆଦ୍ ଦିନାମ୍‍ତେ ବେଲା ତଅନ୍‌ଦିତେ ?” ");
INSERT INTO kff_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ଆଗାଙ୍କ୍ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ସାବ୍‍ଦାନ୍, ମିଡ଼୍ ବେଲା ବୁଲ୍‍କା ଆୟମାଟ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ନାର୍ଗେ ନାରୁଡ଼୍ ନା ପେଦେର୍‍ତେ ୱାସ୍, ନାନ୍ କ୍ରିଷ୍ଟ ନୁ ଟିକ୍ ସମୟ୍ ୱାସ୍ ହେୱୁତେ ଇଞ୍ଜ କେତିତଡ଼୍; ଅଡ଼୍‌‍ ପେର୍‍କେ ଆନ୍‌‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ମାତର୍ ମିଡ଼୍ ବେସୁଙ୍କ୍‍ ଯୁଦ୍ଦ୍‌ ବା ଗୋଲକ୍ ବିଷୟତେ କେଞ୍ଜ୍‍କେ, ଆସୁଙ୍କ୍ ୱେର୍‍ମାଟ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦ୍‍ସାରେ ଗଟନା ପ୍ରତମ୍‌ ଦାମ୍ ତେ ଗଟେମ୍ ଆଦ୍‍ତା, ବାତେଙ୍କ୍ ଇତ୍କେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଯୁଗାନ୍ତ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ତାନ୍‍ପେର୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡେ କେତ୍ତଣ୍ଡ୍, ଜାତି ବିରୁଦ୍‍ତେ ଜାତି ନୁ ରାଜ୍ୟ ବିରୁଦ୍‍ତେ ରାଜ୍ୟ ତେଦିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ମେଣ୍ଡେ ସାର୍‍ରେପାକ୍‍ ଏର୍‍ତୁପାନ୍, ଦୁର୍ବିକ୍ଷ ନୁ ମହାମାରୀ ଆଦ୍‍ତେ, ମାବ୍‍ତାଗ୍ ଅଦ୍‍ବୁତ୍ ନୁ ବୟଙ୍କାର୍ କାମ୍‍ସାରେ ତଅନ୍‌ଦିତା । ");
INSERT INTO kff_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦ୍ ସାରେ ବିଷୟ ଗଟେମ୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ମିକିଂଙ୍କ୍ ବନ୍ଦୀ ମାଡ଼ିତଡ଼୍ । ସମାଜ୍ ଲୋନ୍‌‍ତାଗ୍ ବିଚାରିତ ଆଦାନ୍ ସେଙ୍ଗେ ମିକିଂଙ୍କ୍ ପୟ୍‍ସ୍‍ ବନ୍ଦି ମାଡ଼ିତଡ଼୍ ନୁ ଜଇଲ୍‌ତାଗ୍‍ ନେହେତିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ଇଦ୍ ମିକିଂଙ୍କ୍ ସାକ୍ଷ୍ୟ ଇଦାଙ୍କ୍ ସୁଯୋଗ୍ ହିଦ୍ ତେ । ");
INSERT INTO kff_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ଆଲାତ୍କେ, ନିଜର୍ ପାକେଙ୍କ୍ ବେଲା ଉତ୍ତର୍ ଇଦ୍‍ତିଡ଼୍, ଆଦ୍ ବିଷୟତେ ମୁନେଙ୍କ୍ ଚିନ୍ତେ ମାଡ଼୍‍ୱାଙ୍କ୍ ନିଜ୍ ମନ୍‍ତାଗ୍ ହେର୍କା ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ ଇଦ୍‌ଲେକାମ୍ ଗଟ୍ ନୁ ବୁଦ୍‍ ଇଦ୍‍ତାନ୍ ଯେ, ମିକିଂଙ୍କ୍ ସାରେତଡ଼୍ ବିରଦ୍‍ତେ ନାରୁଡ଼୍ ଆଦିନାଦ୍ ଉତ୍ତର୍ ହିଦାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ୟାୟବାବ, ତାମୁଣ୍ଡ୍‌କିଡ଼୍‍, ଲୋତ୍‍ନଡ଼୍‍ ନୁ କୁଟ୍‍ମାମ୍‍ତାଗ୍ ସମର୍ପିତ୍ ଆଦ୍‍ତିଡ଼୍, ମେଣ୍ଡେ ମି ଲୋପେଙ୍କ୍ ନାରୁଡ଼୍ ବେସ୍‍କ୍‍ତୁଡ଼କ୍ ହାୱ୍‍କିତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ମେଣ୍ଡେ ନା ପେଦେର୍ ସେଙ୍ଗେ ମିଡ଼୍ ସାରେତଡ଼୍ ସାରେତଡ଼୍ ତଡ଼୍ ଗୃଣିତ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ବାତେଙ୍କ୍ ଇତ୍କେ ମି ତାଲେତ୍ ଅଣ୍ଡୟ୍‌‍ମିକା କେଲେମ୍ କାରାବ୍‍ ଆୟ୍‍ୟ; ");
INSERT INTO kff_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ମିଡ଼୍ ଶକ୍ତିତଡ଼୍ ନିଜ୍ ଜିୱୁଣ୍ଡ୍ ଦର୍‍କିତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ମିଡ଼୍ ଯିରୁଶାଲେମ୍ ଚାରେପାକେ ସୈନିନଡ଼୍ ଗେରାମାଡ଼ି ମାନ୍ଦାନାଦ୍ ଉଡ଼ିତିଡ଼୍ । ଆସୁଟେ ମିଡ଼୍ ପୁଞ୍ଜ୍ ପାର୍‍ଦ୍‍ତିଡ଼୍ ଯେ ଯିରୁଶାଲେମ୍ ଦ୍ୱଂସ ଆଦ୍‍ଦାନ୍ ସମୟ୍ ୱାସ୍ ହେଉତେ । ");
INSERT INTO kff_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ଆସୁଙ୍କ୍ ବେନଡ଼୍ ଯିଉଦା ଦେଶ୍‍ତାଗ୍ ମାନ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ଆଦ୍‍ଲେକାମ୍ ମେଟାତାଗ୍ ମିରାଟ୍; ମେଣ୍ଡେ ବେନଡ଼ ନଗର୍‍ତାଗ୍ ମାନ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ଆଦ୍‍ଲେକାମ୍ ଆଦ୍ ପଡ଼ିୟେ ୱିଡ଼୍‍ସିଡ଼୍; ମେଣ୍ଡେ, ବେନଡ଼୍ ନାର୍‍କିନାଗ୍‍ ମାନ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ଆଦ୍‍ଲେକାମ୍ ନଗର୍‍ତାଗ୍ ଆନ୍‌‍ମାଟ୍; ");
INSERT INTO kff_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ବାତେଙ୍କ୍ ଇତ୍କେ ଲେକ୍‍ତାଦ୍‍ ବିଷସାରେ ସତ୍ଆଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଆଦ୍ ନିଜାମ୍ ଦଣ୍ଡ୍ ହିଦ୍‍ନ୍ ଦିନାମ୍ ଆଦ୍ ତେ । ");
INSERT INTO kff_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ଆଦ୍ ଦିନାମ୍‍ତେ ବେନ୍ ନାଟା ଡଙ୍କେତ୍ ନୁ ସୁଦୁପିଲା ମାନ୍ଦାନାୱ୍‍ ୟାୟ, ଆୱ୍ ତିପାଲ୍ ଆଦ୍‍ତି ! ବାତେଙ୍କ୍ ଇତ୍କେ ଦେଶ୍‍ତାଗ୍ ଗାଟି ବେଡ଼ିୟାଦ୍ ବିପଦ୍ ନୁ ଇଦ୍ ଜାତି ସେଙ୍ଗେ ଇଶ୍ୱର୍ ତେ ଦଣ୍ଡ୍ ୱାଦ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ମେଣ୍ଡେ ଅଡ଼୍‌‍ ତାଲ୍‍ୱାର୍ ତଡ଼୍ ଡଲିତଡ଼୍ ନୁ ବନ୍ଦି ଆସ୍ ସାରେତଡ଼୍ ବିଜାତିନଡ଼କ୍ ମେଣ୍ଡେଅଣ୍ଡ୍‌ ଦେଶ୍ ରହସିଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ବିଜାତିଡ଼ାଦ୍ ଯୁଗ୍ ତେର୍‍ୱାଯାକ ଯିରୁଶାଲେମ୍ ଅଡ଼ାଦ୍‌ ଡେକେତ୍ ମଦଲ୍ ଆଦ୍‍ମି ମାନ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ମେଣ୍ଡେ ପଡ଼ଦ୍, ନେଲ୍‍ଞ୍ଜ୍ ନୁ ଉକାକ୍‍କିନାଗ୍ କାମ୍‍ସାରେ ତଅନ୍‌ଦିତେ, ମେଣ୍ଡେ ପୃତିବିତାଗ୍ ଜାତିନଡ଼୍ ଦୁଃକାମ୍ ଆଦ୍‍ତଡ଼୍, ସମୁଦ୍ର ନୁ ଗାଙ୍କ୍‍କୁଡ଼୍‍ ଗାଟି ନେକ୍‌ନାଙ୍କ୍ ଅଡ଼୍‌‍ ଇଲା ବାତେଙ୍କ୍ ଆଦୁତ୍‍ ଇଞ୍ଜ ପୁନଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ମେଣ୍ଡେ ଜଗତ୍ ତେ ପରୁ ୱାସ ମାନ୍ଦାନାଦ୍ ଗଟ୍‍ନା ସାରେତିଙ୍କ୍ କେପି ମାଞ୍ଜ୍ ନାରୁଡ଼୍ ଆନ୍‌‍ତେ ସିମ୍‍କ୍ ଆତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମୟଲ୍‍ତାଗ୍ ସାରେ ବିଷୟ ବଦଲେମ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ଆସୁଙ୍କ୍ ନାରୁଡ଼୍ ପିଲେ ଗାଟି ଶକ୍ତିତଡ଼୍ ନୁ ମହିମାତଡ଼୍ ମାବ୍ ତେ କନ୍‍ସ୍ ୱାଦାନାଦ୍ ଉଡ଼ିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦ୍‍ସାରେ ଗଟ୍‍ନା ଆଦ୍‍ଦାନ୍ ୱେଲେ ମିଡ଼୍ ତେଦି ନିଲ୍‍ମୁଟ୍ ନୁ ପରୁ ଉଡ଼ାଟ୍ ନୁ ତାଲେତିଙ୍କ୍‍ ପରୁ ତେହେମୁଟ୍, ଆସୁଟେ ମିୱାଦ୍ ମୁକ୍ତି ଗାର୍‍ରେ ୱାସ୍ ହେଉଦୁତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେରଡ଼୍ ୱେଷଡ଼୍‍ କେତ୍ତଣ୍ଡ୍, ତୟା ମାଡ଼େ, ମେଣ୍ଡେ ସାରେତାୱ୍‍ ମାଡ଼ାକିଂଙ୍କ୍ ବିଷୟତେ ଚିନ୍ତେ ମାଡ଼ାଟ୍; ");
INSERT INTO kff_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ବେସୁଟ୍‌ ମାଡ଼ାକିନାଗେ ଲେଏତା ଆକି ପେଇତିତା, ଆସୁଙ୍କ୍ ମିଡ଼୍ ଆଦ୍ ଉଡ଼ି ଏଦିକାଲାମ୍ ବକେତ୍ ହେଉଦୁତ୍ ଇଞ୍ଜଡ୍ ନିଜେ ନିଜେ ପୁନ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ଆଦେଲେକାମ୍ ମିଡ଼୍‍ଆନ୍ତେ ଆଦ୍‍ ସାର୍‍ରେ ଗଟନା ଉଡ଼୍‍କେ ଇଶ୍ୱର୍‌ତାଦ୍ ରାଜ୍ୟ ଯେ ବକେତ୍ ହେୱୁତେ, ଇଦ୍ ପୁନ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେସମିନ୍ଦେନ୍, ଡଲାନ୍ ମୁନେଙ୍କ୍ ଇୱୁ ସାରେ ଗଟେମ୍ ଆଦ୍‍ତେ । ଇଦ୍ ଇଞ୍ଜେତ୍ ଯୁଗ୍‍ତେ ମାନେଇ ବେସୁଟ୍‌ ଲୋପ୍ ଆୟ୍‍ୟଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ମାବ୍ ନୁ ପୃତିବି ଦଂସ ଆଦ୍‌ତେ, ମାତର୍ ନାୱାଦ୍ ବାକ୍ୟ ବେସୁଙ୍କ୍‍ ଲୋପ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ନିଜେ ନିଜେ ବିଷୟତେ ସତର୍କ ଆସ୍ ମାନୁଟ୍, ବେସୁଟ୍‌ ବା ମିୱାଦ୍ ହୃଦୟ୍‍ତାଗ୍ ଗାଟି ୱେଡ଼୍‍କା ନୁ କାଲ୍ ନିଜାତାଦ୍, ମେଣ୍ଡେ ବାଦ୍‍କାନ୍ ଚିନ୍ତାତେ ମୁଡ଼ୁନ୍ଦିମାଞ୍ଜ୍ ଦୁଃକାମ୍ ଆଦ୍‍ତିଡ଼୍, ମେଣ୍ଡେ ଆଦ୍‍ଦିନ୍ ହଟାତ୍ ୱାସ୍ ମିପର; ");
INSERT INTO kff_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ଉଡ଼ୁଇ ଲେକେମ୍ ୱାସ୍ ପୃତିବି ନାରୁଡ଼୍ ସାରେତଡ଼୍ ପରୁ ରାଲିତେ । ");
INSERT INTO kff_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ତିଆର୍‍ତେ ମାନୁଟ୍ ନୁ ତିପାଲ୍‍ତେ ଆଦାନଙ୍କ୍ ଶକ୍ତି ଆଦାନ୍ ସେଙ୍ଗେ ନୁ ନାରୁଡ଼୍ ପିଲାତନ୍ ମୁନେ ନିତାନ୍ ମାଇଦିଙ୍କ୍ ସାରେଦାମ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଜିସୁ ସାରେଦିନାମ୍ ମନ୍ଦିର୍ ତାଗ୍ ଶିକ୍ଷା ଇସମାତ୍ତଣ୍ଡ୍, ମେଣ୍ଡେ ସାରେ ନାର୍କା ପେଇସ୍ ମିକା ଜୀତ ମେଟାତାଗ୍ ମାନ୍‍ନୁଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ମେଣ୍ଡେ, ସାରେତଡ଼୍ ନାରୁଡ଼୍ ମନ୍ଦିର୍‍ତାଗ୍ ଜିସୁନାଦ୍ ଶିକ୍ଷା କେଞ୍ଜାନ୍ ମାଇଦିଙ୍କ୍ ନାର୍‍କୁକ୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ପେଦେର୍ ତେ କମୀରଶୂନ୍ୟ ରୂଟି ପାଣ୍ଡୁମ୍ ବକେତ୍ ଆସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ମେଣ୍ଡେ ମୁକ୍ୟ ଯାଜକ ନୁ ଶାସ୍ତ୍ରୀଡ଼୍ ନାରୁଡ଼୍‍କ୍ ୱେର୍ସମାତ୍‍ତାଙ୍କ୍, ମିଞ୍ଜିମାଞ୍ଜ୍ ଜିସୁଙ୍କ୍ ହାୱ୍‍କାଙ୍କ୍ ଉପାୟ ମେହେକ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ଆସୁଙ୍କ୍ ଜିସୁନ୍ ବାରଜାନ୍ ଶିଷ୍ୟନାଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ଇଷ୍କାରିୟୋତ୍ ପେଦେର୍ ତଣ୍ଡ୍ ଯିହୂଦାନାଗେ ଶୟ୍‍ତାନ୍‍ ନେଙ୍ଗ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ଇଷ୍କାରିୟୋ ଆଞ୍ଜ୍, ବେନ୍ ଉପାୟ୍‍ତେ ଜିସୁଙ୍କ୍ ମୁକ୍ୟଯାଜକ୍ ନୁ ସେନାପତିନଡ଼୍ କାଇଦେ ପସ୍‍ପିଦାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ତଡ଼୍ ତିର୍‍ୟି‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ୱେଡ଼୍‍କିତଡ଼୍ ନୁ ଅଂକିଙ୍କ୍‌ ଡାବ୍‍କ୍ ଇଦାନଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ମେଣ୍ଡେ ଅଡ଼୍‌‍ ସାରେତଡ଼୍ କାଇଲି ନାରୁଡ଼୍ ଉଡ଼ୁୱେ ୱେଲେ ଜିସୁଙ୍କ୍ ଅଡ଼୍‌‍ କାଇଦେ ପସ୍‍ପିଦାନ୍ ମାଇଦିଙ୍କ୍ ସୁଯୋଗ୍ ମେହେକାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ପେର୍‍କେ ବେନେ ଦିନେ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ୱେଲେ ମେଣ୍ଢାକିଙ୍କ୍ ବଲିଦାନ୍ ମାଡ଼ାନାଦ୍, କମୀର୍‍ଶୂନ୍ୟ ରୂଟି ପାଣ୍ଡୁମ୍‍ତାଗ୍‍ ଆଦ୍ ଦିନାମ୍ ହେୱୁତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଜିସୁ, ପିତର୍ ନୁ ଯୋହନ୍‌‌ତିଙ୍କ୍ ଇଦ୍ କେସ୍ ରଅତଣ୍ଡ୍, ମାନାଡ଼୍ ବେଲାକି ନିସ୍ତାର୍ ପାଣ୍ଡୁତେ ବୋଜି ତିନ୍ଦେ ପାର୍‍ତାଡ଼୍, “ଆଦିଙ୍କ୍ ମିଡ଼୍ ଆଞ୍ଜ୍ ମା ମାଇଦିଙ୍କ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍‍ତାଦ୍ ବୋଜି ତିଆର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ଆଗାଙ୍କ୍ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ କେତ୍ତଡ଼୍, “ମାମେ ବେନ୍ ପଡ଼ିୟାତାଗ୍ ତିୟାର୍ ମାଡ଼ିତମ୍ ଇଞ୍ଜ ନିମେ ଇଚ୍ଛା ମାଡ଼ୁତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଉଡ଼ାଟ୍, ମିଡ଼୍ ନଗର୍‍ତାଗ୍ ଆଦାନ୍ ୱେଲେ, ପେଣ୍ଡୁଲ୍ କୁଣ୍ଡା ଆଦାନଣ୍ଡ୍ ୱେରଣ୍ଡ ମିକିଂଙ୍କ୍ କାଇଲିତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ବେନ୍ ପାକେ ଆଦ୍‍ତନ୍, ଅନ୍‌ ପେର୍କେ ଆଦ୍ ହାର୍ ଆଞ୍ଜ୍ ଲୋତ୍‌ତେ ମୁକିୟାଙ୍କ୍ କେତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ଗୁରୁ ନିକିଂଙ୍କ୍ କେସ୍‍ମିନ୍ଦେମ୍, ନାନ୍ ନାୟାୱୁ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ବେଗେ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ବଜି ମାଡ଼ିତମ୍ ଆଦ୍ ଲୋନ୍‌ ମାକିଂଙ୍କ୍ ତସିମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ସାଏ ରସ୍‍ତେ ୱେରନ୍ ପରତାଦ୍‍ ବାକ୍‍ଡ଼େ ତଅସିଦ୍‍ତଣ୍ଡ୍; ଆଦ୍ ପଡ଼ିୟିତାଗ୍ ତିଆର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ଅଡ଼୍‌‍ ଆଞ୍ଜ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେଲାକେତ୍‍ତଣ୍ଡ୍, ଆଦ୍‍ଲେକାମ୍ ଉଡ଼ି ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ବଜି ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ମେଣ୍ଡେ, ସମୟ୍ ହେଉତାଙ୍କ୍, ଜିସୁ ନୁ ଅନ୍‌‍ତଡ଼୍ ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍ ତିନ୍ଦାଙ୍କ୍ କୁଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନାକିଂଙ୍କ୍ କଷ୍ଟ ଦର୍‍କାନ୍ ମୁନେ ନାନ୍ ମିତଡ଼୍ କାଇଲି ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ବଜି ତିନ୍ଦାଙ୍କ୍ ଗାଟି ଇଚ୍ଛା ମାଡ଼ତାନ୍ ! ");
INSERT INTO kff_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦନ୍, ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗ୍ ଇଦିନାଦ୍ ପୁରାଅର୍ତ ପ୍ରକାଶିତ୍‍ ଆୟିୱେ ଯାକ ନାନ୍ ଆଦ୍ ବେସୁଟ୍‌ ମିକା ତିନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ମେଣ୍ଡେ ଜିସୁ ଆଦ୍ ବୋଜି ତିଞ୍ଜ୍ ଦନ୍ୟବାଦ୍ ଇସ୍ କେତ୍ତଣ୍ଡ୍, “ଇଦ୍ ଆସ୍ ମିଡ଼୍ ମିଲୋପେ ତୁସାଟ୍, ");
INSERT INTO kff_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ଇଶ୍ୱର୍‌ତାଦ୍ ରାଜ୍ୟ ୱାଡ଼ୱେ ଯାକ ନାନ୍ ନେଟ୍‍ତେ କଞ୍ଚ୍ ଅଙ୍ଗୁର୍‌ କାୟାନ୍ ରସ୍ ଉନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଆଦ୍ ରୂଟି ଅସ୍ ଦନ୍ୟବାଦ୍ ଇତ୍‍ତନ୍ ନୁ ଆଦିଙ୍କ୍ ଉହୁସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇସ୍ କେତ୍ତଣ୍ଡ୍, “ମି ସେଙ୍ଗେ ହିତ୍‍ତାଦ୍ ତିନ୍ଦାନାଦ୍ ରୂଟି ନାୱାଦ୍ ମେନ୍ଦୁଲ୍ ନାକିଂଙ୍କ୍ ଏର୍କାମାଡ଼ଙ୍କ୍ ମାଇଦିଙ୍କ୍ ଇଲା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ତିତ୍‍ତା ପେର୍‍କେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦ୍ରାକ୍ଷାରସ୍ ମାନ୍ଦେତାଗ୍ ତାସ୍ କେତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ଉନ୍ଦାନାଦ୍ ମି ମାଇଦିଙ୍କ୍ ନାୟାଗ୍‍ କନ୍‍ସ୍ ପେଇତାନ୍ ନେତୁର୍ ଇଦ୍ ନେତୁର୍‍ତାଗାଙ୍କ୍ ପୁଃନେ ନିୟମ୍ ଆରାମ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ବାତେଙ୍କ୍ ଇତ୍କେ ଉଡ଼ାଟ୍, ବେନ ନାକିଂଙ୍କ୍ ଶତ୍ରୁଡ଼୍ କାଇଦେ ଇତ୍‍ତନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ଅନାଦ୍‌ କାୟ୍ ନା କାଇତଡ଼୍ ଟେବୁଲ୍ ପରୁ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ବାତେଙ୍କ୍ ଇତ୍କେ ପରମେଶ୍ୱର୍ ବେଲା କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ନାରୁଡ଼୍ ପିଲେ ଆଦେପୁଟୁଙ୍କ୍ ମାଡ଼ମିନ୍ଦେଣ୍ଡ୍ ନିଜାମ୍, ମିକା ବେନେ ମାନେଇ ତଡ଼୍ ଅଣ୍ଡ୍‌ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପିଦାଙ୍କ୍ ଆଦୁତନ୍, ହାୟ ଅଂକିଙ୍କ୍‌ ଦଣ୍ଡ ଦର୍‍କିତେ !” ");
INSERT INTO kff_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ତ ଅଡ଼୍‌‍ ଲୋପେକେ ବେନ ଇଦ୍ ମାଡ଼ାନଙ୍କ୍ ଆଦୁତନ୍, ଆଦ୍ ବିଷୟତେ ଅଡ଼୍‌‍ ତାମ୍ ତାମ୍‍ଲୋପେ କେତାକେତି ଆଦାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ମେଣ୍ଡେ ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ ବେନ ମହାନ୍ ଆଦ୍‍ତନ୍, ଆଦ୍ ବିଷୟତେ ଅଡ଼୍‌‍ ଜାଗ୍‍ଡ଼ା ବା ରାମ୍‍କ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ଆଗାଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବିଜାତିଡ଼୍ ରାଜାଲଡ଼୍ ନିଜର୍ ନାରୁଡ଼୍ ପରୁ ଶାସନ୍‍ ମାଡ଼ିତନ୍ । ମେଣ୍ଡେ ଅଡ଼ାୱୁ ଶାସନ୍‍ କର୍ତ୍ତାଲଡ଼୍ ଦେଶ୍ ସାଙ୍ଗଡ଼୍‍ ଇଞ୍ଜ ଦାବୀ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ଆଲା ଆୟମାଟ୍, ମାତର୍ ମିୟାଗାଙ୍କ୍ ବେନ ବାଡ଼୍‍ୟଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ସୁଦୁନଣ୍ଡ୍ ଲେକେମ୍ ଆୱିଣ୍ଡ୍, ମେଣ୍ଡେ ବେନ ନେତାଲ୍, ଅଣ୍ଡ୍‌ ସେବା ମାଡ଼ାନଣ୍ଡ୍‍ ଲେକେମ୍ ଆଇଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ବେନ ଯଗ୍ୟ ? ବେନ ତିନ୍ଦାନଙ୍କ୍ କୁଦ୍‍ତଣ୍ଡ୍, ନା ସେବା ମାଡ଼ାନଣ୍ଡ୍ ? ବେନ ତିନ୍ଦାନଙ୍କ୍ କୁଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଯଗ୍ୟ । ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିୟାଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ସେବକ ଲେକେମ୍ ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ମାତର୍ ମିଡ଼୍ ନାୱାଦ୍ ସାରେ ପରିକ୍ଷାତାଗ୍ ନା ତଡ଼୍ ମାଞ୍ଜ୍ ୱାଦୁତିଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ମେଣ୍ଡେ ନା ବାବାଲ୍ ବେଲା ନାକିଂଙ୍କ୍ ଶାସନ୍‍ ମାଡ଼ାନ୍ ଅଦିକାର୍‌ ଇସ୍‌‍ମିନ୍ଦେଣ୍ଡ୍ । ଆଦ୍‍ଲେକାମ୍ ନାନ୍ ଆନ୍‌‍ତେ ମିକିଂଙ୍କ୍ ଶାସନ୍‍ ମାଡ଼ାନ୍ ଅଦିକାର୍‌ ହିତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ବେଲାକି ମିଡ଼୍ ନାୱାଦ୍ ରାଜ୍ୟତାଗ୍ ନା ଟେବୁଲ୍ ତାଗ୍ ତିନ୍ଦାନ୍ ଉନ୍ଦାନ୍ ପାର୍‍ତିଡ଼୍, ମେଣ୍ଡେ ସିଂହାସନତାଗ୍ କୁଦି ଇସ୍ରାଏଲତାଦ୍ ବାର୍‍ଟାନ୍ ସହର୍‍ତିଙ୍କ୍ ଶାସନ୍‍ ମାଡ଼ିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ଶିମୋନ୍, ଶିମୋନ୍, ଉଡ଼ାଟ୍, ଚାଷୀ ଗୋହମତିଙ୍କ୍ ଏର୍‍ତଡ଼୍ ତଡ଼୍ ନେମି ତଗ୍ ୱେରେ ମାଡ଼ାନ୍ ଲେକାମ୍, ଶୟ୍‍ତାନ୍‍ ମିକା ମିକିଂଙ୍କ୍ ମୁର୍‍ମୁରା ମାଡ଼ାନଙ୍କ୍ ଆଦେଶ୍‌ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ବାତେଙ୍କ୍ ଇତ୍କେ ମିୱାଦ୍ ବିଶ୍ୱାସ୍ ବେଲାକି ଲପ୍ ଆୟ୍‍ୟ, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ମି ମାଇଦିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍; ମେଣ୍ଡେ, ମିଡ଼୍ ୱାଦାନ୍ ୱେଲେ ମି ତାମୁଣ୍ଡ୍‌କିଡ଼୍‍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାଙ୍କ୍ କେଲମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ମାତର୍ ପିତର୍ ଜିସୁଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ପ୍ରବୁ ନାନ୍ ନିତଡ଼୍ ଜଇଲ୍‌ତା ଆଦାଙ୍କ୍ ନୁ ଡଲାଙ୍କ୍ ବାଡ଼େ ତିଆର୍ ଆସ୍ ମିନ୍ଦେନ୍ !” ");
INSERT INTO kff_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ହୋ ପିତର୍,” ନାନ୍ ନିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, “ନେଣ୍ଡ୍ କର୍କ୍ କୁସାନ୍ ମୁନେଙ୍କ୍ ନିମେ ନାକିଂଙ୍କ୍ ପୁନ୍‍ନନ୍ ଇଞ୍ଜ, ମୁଣ୍ଡ୍ ଦାମ୍ କେତିତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ତାନ୍ ପେର୍‍କେ ଜିସୁ ତାନ୍ ଶିଷ୍ୟଡ଼କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନାନ୍ ବେସୁଙ୍କ୍‍ ମିକିଂଙ୍କ୍ ଆଦ୍ ଦିନାମ୍‍ତେ ହେତି, ମୁନା ନୁ ହେର୍‍ପୁକ୍ ଆୟ୍‍ମାଟ୍ ଇଞ୍ଜ କେସ୍ ରହସ୍‍ମାତ୍‍ତାନ୍, ମିୱାଦ୍ ବାତ୍ ଅବାବ୍ ଆସ୍‍ମାତ୍‍ତେ କି ?” ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍, “ଇଲେ, ବାତ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମାତର୍ ଇଞ୍ଜେ, ବେନନାଦ୍ ୱାଦାନାଦ୍ ମିନ୍ଦେ, ଆଦ୍‍ଅଣ୍ଡ୍‌ ଆୟିଣ୍ଡ୍, ଆଦ୍‍ଲେକାମ୍ ମୁନା ଆନ୍‌‍ତେ ଆୟିଣ୍ଡ୍, ମେଣ୍ଡେ ବେନନାଦ୍ ତାଲ୍‍ୱାର୍ ଇଲ୍‍ଲେ, ଅଣ୍ଡ୍‌ ତାନାଦ୍ ଡୁପଟ୍‍‍ତିଙ୍କ୍ ୱାମି ତାଲ୍‍ୱାର୍ ଆସିଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ଶାସ୍ତ୍ର କେତୁତ୍ ଯେ ଅଣ୍ଡ୍‌ ଅପ୍‍ରାଦି ତଡ଼୍ ଦଣ୍ଡ ଆତ୍‍କେ ନା ବିଷୟତେ ଲେକ୍‍ତାଦ୍ ସାର୍‍ରେବିଷୟ୍ ‍ଅନ୍‌ୟାୟ୍‍ ଆଦାନ୍ ସେଙ୍ଗେ ଇଦ୍ ଗଟ୍ ନାୟାଗ୍ ସାରେ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ଆଗାଙ୍କ୍ ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍‍, “ପ୍ରବୁ ଉଡ଼େ, ଇଗେ ରେଣ୍ଡ୍ ଚୁରୀ ମିନ୍ଦେ ।” ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ରେଣ୍ଡ୍ ଚୁରୀ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଜିସୁ ପେଇସ୍ ତାନାଦ୍ ନିଜର୍ ରୀତି ଲେକାମ୍ ଜୀତ ମେଟେତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ ଶିଷ୍ୟଡ଼୍ ମିକା ଅନ୍‌ ପେର୍‍କେ ପେର୍କେ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ଆଦ୍ ପଡ଼ିୟିତାଗ୍ ହେୱୁସ୍ ମିକା ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ପରିକ୍ଷାତାଗ୍ ବେଲାକି ରାୟ୍‍ୱିଡ଼୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ଜିସୁ ଅଡ଼ାଗାକନ୍‍ସ୍ ସୁଦୁର୍ ଜେକେ ଆଞ୍ଜ୍ ମର୍‍ମିଣ୍ଡା ଇସ୍‌ ଇସତ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ହୋ ବାବା ଯଦି ନିୱାଦ୍ ଇଚ୍ଛା ମାନ୍‍ତା, ଆଲାତ୍କେ ଇଦ୍ ଦୁଃକାତାଦ୍ ପାତ୍ର ନା କନ୍‍ସ୍ ଦୂରାମ୍‍ମାଡ଼ା; ମିକା ନାୱାଦ୍ ଇଚ୍ଛା ଇଲା, ମାତର୍ ନିୱାଦ୍ ଇଚ୍ଛା ସାରେ ଆୟି । ");
INSERT INTO kff_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ମେଣ୍ଡେ, ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ଦୂତ୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ଶକ୍ତି ଇସ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ଅଣ୍ଡ୍‌ ମନ୍‍ତାଗ୍ ଦୁଃକାମ୍ ଆସ୍ ଅଣ୍ଡୟ୍‌ ହେର୍କେତେ ପ୍ରାର୍ତନା ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ ନୁ ଅନାଦ୍‌ ଉବାମ୍ ନାର୍ଗେ ଆସ୍ ନେତୁର୍ ହିନା ନେଲ୍ ରାୟିତା । ");
INSERT INTO kff_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଜିସୁ ପ୍ରାର୍ତନା କଞ୍ଚ୍ ତେଦି ଶିଷ୍ୟଡ଼ାଗେ ଗାର୍‍ରେ ୱାସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦୁଃକାମ୍ ମାଇଦିଙ୍କ୍ ଉସ୍କାଡ଼୍ ତେ ଉଞ୍ଜି ମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ବାତ୍‍ତିଙ୍କ୍ ଉଞ୍ଜୁତିଡ଼୍ ? ପରିକ୍ଷାତାଗ୍ ବେଲାକି ପଡ଼େମ୍ ‍ଆୟିୱିଡ଼୍, ଇଦିନ୍ ସେଙ୍ଗେ ତେଦି ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଅଣ୍ଡ୍‌ ଗଟି କେତ୍‍ତାନ୍ ୱେଲେ, ଉଡ଼ାଟ୍, ନାରୁଡ଼୍ ୱାସ୍ ହେଉତଡ଼୍, ମେଣ୍ଡେ, ବାରଜାନ୍ ତାଗାଙ୍କ୍ ଯିହୂଦା ପେଦେର୍ ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଅଡ଼୍‌‍ ମୁନେ ୱାସ୍ ଜିସୁଙ୍କ୍ ବୁରାନଙ୍କ୍ ଅନ୍‌ ଗାର୍‍ରେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, “ହୋ ଯିହୂଦା, ବୁରି ମିକା ନାରୁଡ଼୍ ପିଲେତିଙ୍କ୍ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପିଦୁତି ?” ");
INSERT INTO kff_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ଆଗାଙ୍କ୍ ବାତ୍ ଗଟେମ୍ ଆଦ୍‍ତେ, ଆଦ୍ଉଡ଼ି ତାମ୍ ସାଙ୍ଗଡ଼୍ କେତ୍ତଡ଼୍, “ପ୍ରବୁ, ମାମେ ବାତେଏ ଚୁର୍‌ଦେ ରେଏତିତମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ମେଣ୍ଡେ ଶିଷ୍ୟଡ଼୍ ଆଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ଚୁର୍ ପେସ୍‍ପି ମୁକ୍ୟ ଯାଜକତେ ଚାକର୍‍ତିଙ୍କ୍ ଅନାଦ୍‌ ତିନ୍ଦେକାଇଦେ ପାକେତ୍ କେଉଦିଙ୍କ୍ ନାଡ଼୍‌କିତ୍‌ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ଇସରେ ମାନୀ;” ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅନାଦ୍‌ କେଉଦିଙ୍କ୍ ଇଟି ସୁସ୍ଥ ମାଡ଼ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ମେଣ୍ଡେ ଜିସୁ ତାନ୍ ବିରୁଦ୍ ତେ ୱାସ୍‍ମାନ୍ଦାନ୍ ମୁକ୍ୟ ଯାଜକ, ମନ୍ଦିର୍‍ତେ ସେନାପତି ନୁ ବେଡ଼ିୟି ନାରୁଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବାତେଏ ଡଙ୍ଗାଲଡ଼୍ ବିରୁଦ୍ଦ୍‌ତେ ପେଇତାନ୍ ଲେକେମ୍ ଚୁରୀ ନୁ ଟେଙ୍ଗା ପଇସ୍ ନାକିଂଙ୍କ୍ ପଇଦାଙ୍କ୍ ପେଇସ୍ ୱାତ୍‍ତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ନାନ୍ ସାର୍‍ରେ ଦିନାମ୍ ମିତଡ଼୍ ମନ୍ଦିର୍ ତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ ମିଡ଼୍ ନା ବିରୁଦ୍‍ତେ କାୟ୍ ଆୱିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଇଦ୍ ମିୱାଦ୍ ସମୟ୍ ନୁ ଇକାଡ଼୍ ତେ ଶାସନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ପେର୍‍କେ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ପଇସ୍ ଆସ୍ ବେଡ଼ୀଇ ଯାଜକିନ୍ ଲୋନ୍‌ ତାତ୍‍ତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍କେ ପିତର୍ ଜେକେ ମାଞ୍ଜ୍ ପେର୍କେ ପେର୍କେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଦୁୱାଡ଼୍‌ ତାଗ୍ କିସ୍ ନିଡ଼୍‍ସ୍‍ପି ଅଣ୍ଡୟ୍‌ ତାଗ୍ କୁଦ୍‍ତଡ଼୍, ପିତର୍ ଆନ୍‌‍ତେ ଅଡ଼୍‌‍ତଡ଼୍ କୁଦିମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ୱେରଣ୍ଡ୍ ଦାସୀ ପିତର୍‍ତିଙ୍କ୍ କିସ୍‍ତେ ଗାର୍‍ରେ କୁଦିମାନ୍ଦାନ୍ ଉଡ଼ି ଅଂକିଙ୍କ୍‌ ଅନାକେ ଉଡ଼ି କେତ୍‍ତେ, “ଇ ନାରୁଡ଼୍ ମିକା ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ବାତେଙ୍କ୍ ଇତ୍କେ ପିତର୍ କେତ୍ତଣ୍ଡ୍, “ଇଲେ, ନାନ୍ ଅକିଂଙ୍କ୍‌ ପୁନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ସୁଦୁଟ୍ ସମୟତେ ପେର୍କେ ମେଣ୍ଡ୍ ୱେରନ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି କେତ୍ତଣ୍ଡ୍, “ନିମ୍‍ ମିକା ଅଡ଼୍‌‍ଆଗାଙ୍କ୍ ୱେର୍‍ନି ।” ବାତେଙ୍କ୍ ଇତ୍କେ ପିତର୍ କେତ୍ତଣ୍ଡ୍, “ଇଲା, ନାନ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ମାତର୍ ଅଣ୍ଡ୍‌ ଗଣ୍ଟାତ୍ ପେର୍‍କେ ମେଣ୍ଡେ ୱେରନ୍ ସତ୍ଇଞ୍ଜ କେତାନଙ୍କ୍ ପସ୍ପ୍‍ତଣ୍ଡ୍, “ଇ ନାରୁଡ଼୍ ମିକା ନିଜାମ୍ ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ତ ଗାଲିଲୀୟ ନାରୁଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ବାତେଙ୍କ୍ ଇତ୍କେ ପିତର୍ କେତ୍ତଣ୍ଡ୍, “ନିମେ ବାତେଏ କେତୁତିନ୍ ନାନେ ଆଦ୍ ପୁନନ୍ ।” ଆସୁଙ୍କେ ଅଣ୍ଡ୍‌ ଗଟି କେସ କର୍କ୍ କୁସ୍ତା । ");
INSERT INTO kff_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ପ୍ରବୁ ତିଡ଼ିୟିମିକା ପିତର୍‍ତିଙ୍କ୍ ୱେରନ୍ ଲେକାମ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ ନୁ ପ୍ରବୁ ଅଂକିଙ୍କ୍‌ ବାତ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଅଂକିଙ୍କ୍‌ ହେର୍କା ୱାତ୍‍ତା “ନେଣ୍ଡ୍ ନାର୍କେ କର୍କ୍ କୁସାନ୍ ମୁନେଙ୍କ୍ ନିମେ ନାକିଂଙ୍କ୍ ମୁଣ୍ଡ୍ ଦାମ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ିତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ତାନ୍ ପେର୍‍କେ ପିତର୍ ବାଇଦେ ଆଞ୍ଜ୍ ଦୁଃକାମ୍‍ତେ ଗାଟି କେୟ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ବେନେ ନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ ପଇସ୍ ନେହେସ୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ରେହେସ୍‍ ପରିହାସ୍ ମାଡ଼ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ଜିସୁନ୍ ମକମ୍‍ତିଙ୍କ୍ ମୁସି ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ନିମେ ୱେରନ୍ ବାବବାଦୀବାନେ ! କେଲମ୍ ତ ନିକିଂଙ୍କ୍ ବେନ ପିଞ୍ଜ୍‍ପ୍‍ତଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ମେଣ୍ଡେ ଅଡ଼୍‌‍ ନାର୍ଗେ ଗଟି ଅନ୍‌ ବିରୁଦ୍ ତେ କେସ୍ ଅଂକିଙ୍କ୍‌ ଲିନ୍ଦ୍ ମାଡ଼ାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଆତ୍‍ତେ ୱେଲେ ଯିହୁଦୀ ମୁକ୍ୟନାରୁଡ଼୍, ମେଣ୍ଡେ ମୁକ୍ୟ ଯାଜକ ନୁ ଶାସ୍ତ୍ରୀଡ଼୍ ଅଣ୍ଡୟାଗେ ଆସ୍ ତାମ୍ ବେଡ଼ିୟାଦ୍ ମାନ୍ଦେତାଗ୍‍ ଅସ୍ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ ଯଦି କ୍ରିଷ୍ଟ, ଇଞ୍ଜେ ମାକିଂଙ୍କ୍ କେଲେମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ବାତେଙ୍କ୍ ଇତ୍କେ କ୍ରିଷ୍ଟ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ଯଦି ମିକିଂଙ୍କ୍ କେତିତାନ୍, ମିଡ଼୍ ତ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍;” ");
INSERT INTO kff_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ମେଣ୍ଡେ ନାନ୍ ଯଦି ପ୍ରଶ୍ନ କେତିତାନ୍, ମିଡ଼୍ ଉତ୍ତର୍ ଇୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ବାତେଙ୍କ୍ ଇତ୍କେ ଇଞ୍ଜେକଞ୍ଚ୍ ନାରୁଡ଼୍ ପିଲେ ସାରେତିଙ୍କ୍‍ ଶକ୍ତିନଡ଼୍ ଇଶ୍ୱର୍‌ତାଦ୍ ତିନ୍ଦେକାଇଦେ ପାକେ କୁଦିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ଆଗାଙ୍କ୍ ସାରେତଡ଼୍ କେତ୍ତଡ଼୍, “ତ ନିମେ ବାତେଏ ଇଶ୍ୱର୍ ମାର୍‍ ?” ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନାନ୍ ଅଣ୍ଡେ ଇଞ୍ଜ୍ ମିଡ଼୍ କେତୁତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ଆସୁଟେ ଅଡ଼୍‌‍ କେତ୍ତଡ଼୍, “ମାମ୍ ତ ନିଜେ ନିଜେ ଅନ୍‌ ନିଜ୍ ମକତାଗାଙ୍କ୍ ଇଦ୍ ଗଟି କେଞ୍ଜ୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ପେର୍‍କେ ସବାତାଗାଙ୍କ୍ ସାରେତଡ଼୍ ତେଦି ପିଲାତନ୍ ଗାର୍‍ରେ ଜିସୁଙ୍କ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ଅଡ଼୍‌‍ ସାରେତଡ଼୍ କ୍ରିଷ୍ଟଙ୍କ୍ ପିଲାତନ୍ ଗାର୍‍ରେ ପଇସ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ଆଗାଙ୍କ୍ ପିଲାତ ଜିସୁଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ନିମେ କି ଯିହୁଦାନଡ଼୍ ରାଜାନି ?” ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନିମେ ଆଦ୍‌ କେତୁତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ଆଗାଙ୍କ୍ ପିଲାତ ମୁକ୍ୟଯାଜକ୍ ନୁ ନାରୁଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମାମେ ଇ ନାରୁନାଗାଙ୍କ୍ ବାତ୍ ମିକା ଦଷ୍ ଦର୍‍ସ୍‍କମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ସେନେକ୍‍ ସେନେକ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍ତଡ଼୍, “ଅନାଦ୍‌ ଶିକ୍ଷାତଡ଼୍ ଅଣ୍ଡ୍‌ ସାରେଯିହୂଦା ଦେଶ୍‍ତା ନାରୁଡ଼୍ ଲୋପେ ରାମ୍‌କ୍‌ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଆଦ୍ ଗାଲିଲୀତାଗାଙ୍କ୍ ଆରାମ୍ ମାଡ଼ି ଇଞ୍ଜେ ଇଦ୍ ପଡ଼ିୟିତାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ବାତେଙ୍କ୍ ଇତ୍କେ ପିଲାତ ଆଦ୍ କେଞ୍ଜି କେତ୍ତଣ୍ଡ୍, “ଇ ନାରୁଡ଼୍ ବାତ୍ ୱେରଣ୍ଡ୍ ଗାଲିଲୀୟତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ଜିସୁ ଯେ ହେରଦ୍ ରାଜ୍ୟତ୍ ନାରୁଡ଼୍, ଇଦ୍ ପୁଞ୍ଜ୍ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ହେରୋଦ୍‍ତା ରୋସିତ୍‍ତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ମିକା ଯୀରୁଶାଲମ୍‍ତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ହେରଦ୍ ଜିସୁଙ୍କ୍ ଉଡ଼ି, ଗାଟି ୱେଡ଼୍‍କିତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଅନାଦ୍‌ ବିଷୟ କେଞ୍ଜି ମାତ୍‍ତାଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଗାଟି ଦିନାମ୍ କଞ୍ଜ୍ ଉଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଆଶେ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଅନ୍‌ ଆଗାଙ୍କ୍ ବାତେମିକା ବାକ୍‍ୱା ପାଡ଼ିୟି ଅଣ୍ଡ୍‌ ଉଡ଼ାଙ୍କ୍ ଆଶ୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ଆଦିଙ୍କ୍ ହେରୋଦ୍ ଅଂକିଙ୍କ୍‌ ବାତ୍ ବାତ୍ ଗଟି କେତାନଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଂକିଙ୍କ୍‌ ବାତେମିକା ଉତ୍ତର୍ ଇୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ମେଣ୍ଡେ ବେଡ଼ିୟି ଯାଜକ ନୁ ଶାସ୍ତ୍ରୀନଡ଼୍‍ ନିସ୍‍ମିକା ଜିସୁନ୍ ବିରୁଦ୍ ତେ ଗାଡ଼୍‍ସ୍ ଗଟି କେସ୍ ଅବିଯଗ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ହେରୋଦ୍ ତାନ୍ ସୌନ୍ୟକିନ୍ ତଡ଼୍ ଅଂକିଙ୍କ୍‌ ତୁଚ୍ଛ ମାଡ଼ି ଇଙ୍ଗ୍‍ତାୱ୍ ଚକା କେର୍‍ସ୍‍ପି ପିଲାତନ୍ ଗାର୍‍ରେ ମେଣ୍ଡନ୍‍ଦାମ୍ ରହତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ଆଦ୍ ଦିନାମ୍ ହେରୋଦ୍ ନୁ ପିଲାତ ଇର୍ୱୁଡ଼୍ ସାଙ୍ଗ ଆତ୍‍ତଡ଼୍; ଆଦିନ୍ ମୁନେଙ୍କ୍ ଅଡ଼୍‌‍ ଇର୍ୱୁଡ଼୍ ଶତ୍ରୁ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ପିଲାତ, ବେଡ଼ିୟି ଯାଜକ, ଅଦକ୍ଷ ନୁ ସାର୍‍ରେତଡ଼୍ ନାରୁଡ଼୍‍କ୍ କାର୍‍ଙ୍ଗି ଅଣ୍ଡୟାଗେ ମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍ ଗୋଲକ୍ ମାଡ଼ୁତଣ୍ଡ୍ ଇଞ୍ଜ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ନାୟାଗ୍ ତାତ୍‍ତିଡ଼୍ । ନାନ୍ ଅଂକିଙ୍କ୍‌ ପରିକ୍ଷା ମାଡ଼୍‍ତାନ୍; ବାତେଙ୍କ୍ ଇତ୍କେ ମିଡ଼୍ ଅବିଯଗ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ବାତ୍‍ମିକା ଦଷ୍ ଅନାଗେ ଦର୍‍ସ୍‍କନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ହେରୋଦ୍ ମିକା ଦର୍‍ସ୍‍କାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ମା ଗାର୍‍ରେ ମେଣ୍ଡେ ରସିତ୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଇଣ୍ଡ୍ ଡଲାନାଦ୍ ଦଣ୍ଡ୍ ରକମ୍ ବାତେମିକା ପାଡ଼ିୟି ମାଡ଼ଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ମେଣ୍ଡେ ମାମେ ଇଙ୍କ୍ ଦଣ୍ଡ ଇସ୍ ୱିଡ଼ସିଦ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ପାଣ୍ଡୁମ୍‍ତେ ୱେଲେ ଅଡ଼୍‌‍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ୱେରଣ୍ଡ୍ ବନ୍ଦି ନାରୁଙ୍କ୍ ମୁକ୍ତ ମାଡ଼ାଙ୍କ୍ ଆସମାତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ସାରେତଡ଼୍ ନାରୁଡ଼୍ କିଡ଼୍‍କି କେତ୍‍ତଡ଼୍, “ଅଂକିଙ୍କ୍‌ ଆଉକାଟ୍ । ମା ସେଙ୍ଗେ ବାରବାଙ୍କ୍ ମୁକ୍ତ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ଅଣ୍ଡ୍‌ ବାରବା ନାର୍‍ଦାଗ୍ ଗଟେମ୍ ଆତ୍‍ତାଦ୍ ବେନମିକା ରାମ୍‍କ୍ ମାଇଦିଙ୍କ୍ ନୁ ନାରୁଙ୍କ୍ ଆଉକ୍‍ତେ ସେଙ୍ଗେ କାରାଗାର୍ ତାଗ୍ ୱାଟିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ମାତର୍ ପିଲାତ ଜିସୁଙ୍କ୍ ୱିଡ୍‌ସିଦାନଙ୍କ୍ ଇଚ୍ଛାମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡନ୍ଦାମ୍ ବୁଜା ମାଡ଼ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପାଟ୍, କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ମେଣ୍ଡେ ପିଲାତ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ତୃତୀୟ ଦାମ୍ କେତ୍ତଣ୍ଡ୍, “ବାତେଙ୍କ୍, ଅଣ୍ଡ୍‌ ବାତ୍ ଦଷ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ? ମାମେ ଅନାଗାଙ୍କ୍ ଡଲାନାଦ୍ ବାତେମିକା ଦଷ୍ ଦର୍‍ସ୍‍କମ୍‍; ମେଣ୍ଡେ, ମାନାଡ଼୍ ଅଂକିଙ୍କ୍‌ ଦଣ୍ଡ ଇସ୍ ୱିଡ଼ସିଦ୍‍‍ତାଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ମାତର୍ ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପାଟ୍, ଇଞ୍ଜ୍ ଦାବୀ ମାଡ଼ି ଅଡ଼୍‌‍ ଗାଟିଲେଙ୍ଗ୍‍ଦେ ଜିଦ୍ ମାଡ଼ାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଡ଼ାଦ୍‌ ମର୍‍ରେ ହିଁ ଜିଡ଼୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ମେଣ୍ଡେ ଅଡ଼ାଦ୍‌ ଦାବୀ ଲେକାମ୍ ମାଡ଼ାଟ୍ ଇଞ୍ଜ୍ ପିଲାତ ଆଦେଶ୍ ଇତ୍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ବାତେଙ୍କ୍ ଇତ୍କେ ଗୋଲକ୍ ନୁ ଆଉକ୍‍ତେ ମାଇଦିଙ୍କ୍ କାରାଗାର୍ ତାଗ୍ ୱାଟିମାତ୍‍ତେ ନାରୁଡ଼୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌‍ ଦାବୀ ମାଡ଼ ମାତ୍‍ତଡ଼୍, ଅଂକିଙ୍କ୍‌ ଅଣ୍ଡ୍‌ ୱିଡ଼୍‍ସିତ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ଜିସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼ାଦ୍‌ ଇଚ୍ଛାତେ ମାଡ଼ାନଙ୍କ୍ ଇତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ଆଦାନ୍ ୱେଲେ ମେଣ୍ଡ ଅଙ୍କ୍‌ ନାର୍ କନ୍‍ସ୍ ୱାସମିନ୍ଦେନ୍ ଶିମୋନ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ କୁରୁନିୟ ନାରୁଙ୍କ୍ ପଇସ୍ ଜିସୁନ୍ ପେର୍‍କେ ପେର୍‍କେ କ୍ରୁଶକାଞ୍ଜାନ୍ ମାଇଦିଙ୍କ୍ ଅନ୍‌ ଆଟ୍‍ତାଗ୍ ଆଦ୍ ୱାଟିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ମେଣ୍ଡେ ନାର୍ଗେ ନାରୁଡ଼୍ ନୁ ଅନ୍‌‍ମାଇଦିଙ୍କ୍ ଗୁଣ୍ଡେତାଗ୍ ରେହେସ୍ କେୟମାନ୍ଦାନ୍ ମୁତ୍‍ତେନ୍ ୱେରନ୍ ବେଡ଼େୟାଦ୍ ମାନ୍ଦେ ଅନ୍‌ ପେର୍‍କେ ୱାସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ଜିସୁ ଅଡ଼ାକ୍ ମାଲ୍‍ସ୍ ଉଡ଼ି କେତ୍ତଣ୍ଡ୍, “ଯିରୁଶାଲେମ୍‍ତେ ନାଟାନଡ଼ି ନା ମାଇଦିଙ୍କ୍ କେୟ୍‍ମାଟ୍ ବା ମି ମାଇଦିଙ୍କ୍ ନୁ ମି ପିଲାନ୍ ମାଇଦିଙ୍କ୍ କେୟାଟ୍; ");
INSERT INTO kff_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଉଡ଼ାଟ୍, ବେନଡ଼୍ ୱାଞ୍ଜଲ୍, ମେଣ୍ଡେ ବେନଡ଼୍ ବେସୁଙ୍କେ ବା ଡଙ୍କେତ୍ ଆୟ୍‍ୟ ମାନ୍‍ତା ନୁ ପାୟାଲ୍ ଉସ୍ୱେ ମାନ୍‍ତା ହାୱିଙ୍କ୍ ନାରୁଡ଼୍, ବେସୁଙ୍କ୍‍ ଦନ୍ୟ ଦନ୍ୟ ଇଞ୍ଜ କେତିତଡ଼୍, ଇଦଲେକାମ୍ ସମୟ୍ ୱାଦୁତ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ଆସୁଙ୍କ୍ ନାରୁଡ଼୍ ମେଟାକିଂଙ୍କ୍ କେତାନଙ୍କ ପସ୍‍ପିତ୍‍ତଡ଼୍, ମା ପରୁ ମେଇସ୍ ରାଲାଟ୍, ମେଣ୍ଡେ ସୁଦୁମେଟାକିଙ୍କ୍ କେତାଙ୍କ୍ ପସ୍‍ପିତ୍‍ତଡ଼୍, ମାକିଂଙ୍କ୍ ମିସିଇମୁଟ୍ ! ");
INSERT INTO kff_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ବାତେଙ୍କ୍ ଇତ୍କେ ନାରୁଡ଼୍ ଯଦି ଜିୱେତ୍ ମାଡ଼େତିଙ୍କ୍ ଇଦ୍ ଲେକେମ୍ ମାଡ଼ିତଡ଼୍, ଆଲେକେ ୱାସ୍‌ତେ ମାଡ଼େ ସେଙ୍ଗେ ବାତେଏ ଗଟେମ୍ ଆୟ୍‍ୟ ?” ");
INSERT INTO kff_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ବାଗାତ୍ ଇର୍‌ୱୁଡ଼୍ ଅପ୍‍ରାଦିଡ଼୍‍କ୍ ମିକା ଜିସୁନ୍ ତଡ଼୍ ଡଲାନାଦ୍ ଦଣ୍ଡ ହିଦାନ୍ ସେଙ୍ଗେ ଆସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଅଡ଼୍‌‍କିଂଙ୍କ୍ କପାଲ ପେଦେର୍ ପଡ଼ିୟିତାଗ୍ ଏୱୁସ୍ ମିକା ଜିସୁଙ୍କ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅପ୍‍ରାଦିଡ଼୍‍କ୍ ୱେରଙ୍କ୍ ଡେବେ କାଇଦେପାକେ ନୁ ଅର୍‍ତୁଙ୍କ୍ ତିନ୍ଦେ କାଇଦେପାକେ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ଆସୁଙ୍କ୍ ଜିସୁ କେତ୍ତଣ୍ଡ୍, “ବାବା ଇଡ଼କିଙ୍କ୍ କ୍ଷମା ମାଡ଼ା, ବାତେଙ୍କ୍ ଇତ୍କେ ଇଡ଼୍ ବାତ୍ ମାଡ଼ୁତଡ଼୍ ଆଦ୍ ପୁନଡ଼୍ ।” ମେଣ୍ଡେ ଅଡ଼୍‌‍ ଜିସୁନ୍ ଚକାତିଙ୍କ୍ ତୁସାନ୍ ମାଇଦିଙ୍କ୍ ଗୁଲିବାଣ୍ଟ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ନାରୁଡ଼୍ ନିସ୍‍ମିକା ଉଡ଼ମାତ୍ତଡ଼୍, ମେଣ୍ଡେ ଯିହୂଦି ନେତାଲଡ଼୍ ମିକା ଅଂକିଙ୍କ୍‌ ତୁଚ୍ଛ ମାଡ଼ି କେତୁତଡ଼୍, “ଅଣ୍ଡ୍‌ ଆର୍‍ତିଡ଼କ୍ ରକ୍ଷା ମାଡ଼ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଯଦି ଇଶ୍ୱର୍‌ତେ ହେଞ୍ଚିମାନ୍ଦାନ୍ କ୍ରିଷ୍ଟ, ଆଲେକେ ନିଜ୍ ତିଙ୍କ୍ ରକ୍ଷା ମାଡ଼ିଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ସୌନ୍ୟନାରୁଡ଼୍ ମିକା ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ ପୁଲସ୍ତାଉ କାଲ୍ ଇସ୍ ଅଂକିଙ୍କ୍‌ ପରିହାସ୍ ମାଡ଼ି କେତ୍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ନିମ୍‍ ଯଦି ଯିହୂଦୀଡ଼୍ ରାଜାନନି, ଆଲେକେ ନିଜେତିଙ୍କ୍ ରକ୍ଷା ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଜିସୁନ୍ ତାଲେତ୍ ପରୁ ଇଦ୍ ଲେକ୍‍ତାଦ୍ ମାତ୍‍ତା, “ଇଣ୍ଡ୍ ଯିହୂଦୀଡ଼୍ ରାଜାଲ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପ୍‍ତା ଅପ୍‍ରାଦିଡ଼୍ ଲୋପେକେ ୱେରଣ୍ଡ୍ ଅଂକିଙ୍କ୍‌ ଲିନ୍ଦେ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତ୍ କ୍ରିଷ୍ଟ ଆୱୟି କି ? ନିଜେତିଙ୍କ୍ ନୁ ମାକିଂଙ୍କ୍ ଆନ୍‌‍ତେ ରକ୍ଷାମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ମେଣ୍ଡେ ୱେରନ୍ ଅଂକିଙ୍କ୍‌ ଦମକ୍ ଇସ୍‌ କେତ୍ତଣ୍ଡ୍, ନିମ୍‍ ଆନ୍‌‍ତେ ସାମାନ୍ ଦଣ୍ଡ ଅଦୁତିନ୍, “ନିମ୍‍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ବାତ୍ ୱେର୍‍ୟକଟ ମିନ୍ଦେନି । ");
INSERT INTO kff_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ମାମେ ସିନା ନ୍ୟାୟ ମାଇଦିଙ୍କ୍ ଦଣ୍ଡ ଅଦୁତମ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ମାମେ ନିଜ୍ ପାଡ଼ିୟିତାଗ୍ ଦଣ୍ଡ ଦର୍‍କ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍କେ ଇ ନାରୁଡ଼୍ ବାତେମିକା ଦଷ୍ ମାଡ଼ଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ କେତ୍ତଣ୍ଡ୍, ହଁ ଜିସୁ, “ନିମେ ରାଜାନ୍ ଲେକାମ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍କେ ନାକିଂଙ୍କ୍ ଆନ୍‌‍ତେ ହେର୍କା ମାଡ଼ିତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ଆଗାଙ୍କ୍ ଜିସୁ ଅଙ୍କ୍‌ କେତ୍ତଣ୍ଡ୍, ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, “ନେଣ୍ଡ୍ ନିମେ ନାତଡ଼୍ ସ୍ୱର୍ଗ ଦେଶ୍‍ତାଗ୍ ଆଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ଆସୁଙ୍କ୍ ମାତର୍ ବାର ଗାଣ୍ଟା ଦିନାମ୍ ଆସ୍‍ମାତ୍‍ତା, ପଡ଼ଦ୍ ୱେସ୍ ଇଦେ ପାର୍‍ୱେ ମାତ୍‍ତା ମୁଣ୍ଡ୍ ଗାଣ୍ଟା ହେଉନା ଦେଶ୍‍ଯାକ ଇକାଡ଼୍ ଆତ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ମେଣ୍ଡେ ମନ୍ଦିର୍ ଡ଼ାଦ୍ ପାର୍ଦାସିଲା ପରତ୍ କଞ୍ଜ୍ ମଦଲ୍ ହେଉନା ହିଙ୍ଗି ରେଣ୍ଡ୍ ଦୁଡ଼ା ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ଆସୁଙ୍କ୍ ଜିସୁ ଗାଟି ଲେଙ୍ଗ୍‍ତେ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, ହଁ ବାବା, ନି କାଇଦେ ନାନ୍ ନାୱାଦ୍ ଆତ୍ମା ଇସମିନ୍ଦେନ୍ । ଇଦ୍ କେସ୍ ଅଣ୍ଡ୍‌ ଡଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ଶତସେନାପତି ଇଦ୍ ଗଟନା ଉଡ଼ି ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଗୌରବ୍‍ ମାଡ଼ି କେତ୍ତଣ୍ଡ୍, “ନିଜାମ୍ ଇ ନାରୁଡ଼୍ ଦାର୍ମିକ୍ ମାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ମେଣ୍ଡେ ବେନ୍ ନାରୁଡ଼୍ ଉଡ଼ାନଙ୍କ୍ ଅଣ୍ଡୟାଗେ ଆସ୍‍ମାତଡ଼୍, ଅଡ଼୍‌‍ ସାରେତଡ଼୍ ଆଦ୍ ଗଟନା ଉଡ଼ି ଗୁଣ୍ଡେତିଙ୍କ୍ ରେହେସ୍ ମାଲ୍‍ସ୍ ଆଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଙ୍କ୍‌ ପୁତ୍‍ତେନଡ଼୍ ସାରେତଡ଼୍ ନୁ ଗାଲିଲୀତାଗାଙ୍କ୍ ଅଣ୍ଡୟ୍‌‍ତାଗ୍ ଆସ୍ ଅନ୍‌ ପେର୍କେ ପେର୍କେ ୱାସ୍‍ମାନ୍ଦାନ୍ ମୁତ୍‍ତେ ଯେକା ନିସ୍ ଇଦ୍ ସାରେ ଉଡ଼ମାତ୍ତା । ");
INSERT INTO kff_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଯିହୁଦିନଡ଼୍ ହାରାମାତିୟା ନାର୍ ତେ ଯୋଷେପ୍ ପେଦେର୍ ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ବେଡ଼ିୟେ ମିଟିଙ୍କ୍‍ତାଗ୍ ସବ୍ୟ ମାତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଲେକେତ୍‍ ନୁ ଦାର୍ମିକ୍ ନାରୁଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ମେଣ୍ଡେ ଅଡ଼ାଦ୍‌ ମନ୍ତ୍ରନା ନୁ କାମ୍‌ଦାଗ୍‌ ଇଲ୍‌ୱେ ମାତ୍‌ତନ୍‌, ମେଣ୍ଡେ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତିଙ୍କ୍‌ କେପିମାତ୍‌ତନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ଅଣ୍ଡ୍‌ ପିଲାତନ୍ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଜିସୁନାଦ୍ ମେନ୍ଦୁଲ୍ ତିଙ୍କ୍ ତାଲ୍‍କ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ଅଣ୍ଡ୍‌ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍ ଡିପିତାସ୍ ପାଲ୍‍ସାଲାଦ୍ ସିଲେତ୍ ମୁସି, ବେଗେ ବେନବା ବେସୁଙ୍କ୍‍ ୱାଟ୍‍ୱେମାତ୍‍ତଡ଼୍, ମେଟେତ୍ କାଲ୍‍ତାଗ୍ ଡେୱି ମାନ୍ଦାନ୍ ଇସତାଦ୍ ୱେରନ୍ ସମାଦିତାଗ୍ ଅଂକିଙ୍କ୍‌ ୱାଟ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ଆଦ୍ ଦିନ୍ ତିଆର୍ ମାଡ଼୍‍ତେ ଦିନ୍ ଶୁକୁର୍‍ବାର୍ ମାତ୍‍ତା, ମେଣ୍ଡେ ବିଶ୍ରାମ୍ ଦିନାତ୍ ଆସ୍ ୱାସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ମେଣ୍ଡେ ଗାଲିଲୀତାଗାଙ୍କ୍ ଅଡ଼୍‌‍ତଡ଼୍‍ ୱାସ୍‌ମାନ୍ଦାନ୍ ମୁତେକି ଯୋଷେପ୍‍ତେ ପେର୍କେ ପେର୍କେ ଆଞ୍ଜ୍ ଦିମ୍‍ତିଙ୍କ୍ ନୁ ଅନାଦ୍‌ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ବେଲା ୱାଟ୍‍ତଡ଼୍, ଆଦ୍ ଉଡ଼୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ମେଣ୍ଡେ ଆୱ୍ ମାଲ୍‍ସ୍ ଆଞ୍ଜ୍ ସାଏତ୍ ଗାବ୍‍ତାଦ୍ ଜିନିଷ୍ ନୁ ନିୟି ତିଆର୍ ମାଡ଼୍‍ତେ । ମେଣ୍ଡେ ଆୱ୍ ବ୍ୟବସ୍ଥା ଲେକାମ୍ ରମାନ୍‍ ଦିନାତେ ରମ୍‌ତା, ବାତେଙ୍କ୍ ଇତ୍କେ ଆଦ୍ ନିୟମ୍‍ତାଗ୍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ସପ୍‍ତାତିଙ୍କ୍ ମୁନେତ୍‍ଦିନେ ଆୱ୍ ନାଟା ନାର୍କୁକ୍ ତାମ୍ ତିଆର୍ ମାଡ଼ିତେ ସାଏତ୍ ଗାବ୍‍ତାୱ୍ ଜିନିଷ୍ ପଇସ୍ ସମାଦିତା ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ମେଣ୍ଡେ ଆୱ୍ ନାଟା ସମାଦିତାଗ୍ କାଲ୍‍ବଦ୍‍ତିଙ୍କ୍ ଗୁସ୍‍ପ୍‍ତାଦ୍ ଉଡ଼୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ଆଦିଙ୍କ୍ ଆୱ୍ ଲୋପେ ଆଞ୍ଜ୍‌ ଉଡ଼୍‌ତା ପ୍ରବୁ ଜିସୁନାଦ୍ ମେନ୍ଦୁଲ୍ ଆଗେ ଇଲ୍‌ୱେ ମାତ୍‌ତେ, ");
INSERT INTO kff_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ଆୱ୍ ନାଟା ଆସୁଙ୍କ୍ ବୁଦ୍‍ତେନନ୍ ହାସ୍ ନିସ୍‍ମାତ୍‍ତା, ଆଦ୍ ଦିନାମ୍‍ତେ ଉଡ଼ାଟ୍, ୱେସ୍‍ତେ ଚକା କେର୍ସ୍ ଇର୍ଉଡ଼୍ ନାରୁଡ଼୍ ଆୱୁ ଗାର୍‍ରେ ୱାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ଆଗାଙ୍କ୍ ଆୱ୍ ନାଟା ଗାଟି ୱେର୍‍ତା ନୁ ତାମାଉ ତାଲାନ୍ ଆଡ଼୍‌‍ଗି ମାଡ଼ିମାତ୍‌ତା । ଆୱ୍ ଦୂତ୍‍କ୍ ଆଦ୍ ନାଟାଙ୍କ୍ କେତ୍‍ତା, “ଡୋଲ୍‌ ତାଗ୍ ଜିୱୁଣ୍ଡ୍ ମାନ୍ଦାନ୍ ନାରୁଙ୍କ୍ ବାତେଙ୍କ୍ ମେହେକୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ଅଣ୍ଡ୍‌ ଇଗେ ଇଲାଣ୍ଡ୍, ମାତର୍ ଡଲ୍‍ତାକଞ୍ଜ୍‍ ତେଦିମିନ୍ଦେଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ବେନେ ବାକ୍ୟ ଗାଲିଲୀତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ ମିକିଂଙ୍କ୍ କେସ୍ ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ହେର୍କା ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ନାରୁଡ଼୍ ପିଲେ ଯେ ଆଦ୍‍ଲେକାମ୍ ପାପିନଡ଼କ୍ କାଇଦେ ପସ୍‍ପିସ୍ ମିକା କ୍ରୁଶତାଗ୍ ଡଲିତଣ୍ଡ୍‌ ନୁ ମୁଣ୍ଡ୍ ଦିନାମାଞ୍ଜ୍ ମେଣ୍ଡେ ତେଦିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ଆସୁଟେ ଆୱ୍ ଅନାଦ୍‌ ବାକ୍ୟତିଙ୍କ୍ ହେର୍କା ମାଡ଼୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ମେଣ୍ଡେ ସମାଦି କଞ୍ଜ୍ ମାଲ୍‍ସ୍ ଆଞ୍ଜ୍ ଆୱ୍ ଏଗାର୍ ଜାନ୍ ଶିଷ୍ୟଡ଼କ୍ କେତ୍‍ତା ନୁ ବାଗାତ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଇଦ୍ କାବୁର୍ କେତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ଆୱ୍ ନାଟା ମଗ୍‍ଦଲୀନି ମରୀୟମ୍, ଯୋହନ୍‌, ଯାକୁବତେ ୟାୟ ମରୀୟମ୍ ନୁ ଇୱିନ୍ ତଡ଼୍ ମାନ୍ଦାନ୍ ମେଣ୍ଡେ ବାଗାତେ ନାଟା, ପ୍ରେରିତ୍‍ ଶିଷ୍ୟଡ଼୍‍କ୍ ଇଦ୍ ସାରେ ବିଷୟ୍ କେତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ମାତର୍ ହାଉସାରେ ଗଟି ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ବାୟେଦେ ନାରୁଡ଼୍ ତେ ଗଟି ଇନା କେଞ୍ଜ୍‍ତାନ୍, ମେଣ୍ଡେ ଶିଷ୍ୟଡ଼କ୍ ଆୱିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ବାତେଙ୍କ୍ ଇତ୍କେ ପିତର୍ ତେଦି ସମାଦିତା ମିର୍‍ତଣ୍ଡ୍, ଆଡ଼୍‌‍କି ମିକା ମାତର୍ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ମିସମାତ୍‍ତେ ସିଲେତିଙ୍କ୍ ଉଡ଼୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆୱୁ ଆଦ୍ ଗଟନା ବିଷୟତେ ୱେର୍‌ସ୍‌ ମିକା ତାମ୍ ଲୋନ୍‌ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ମେଣ୍ଡେ ଉଡ଼େ, ଆଦ୍ ଦିନେ ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍ ଯୀରୁଶାଲାମ୍ କନ୍‍ସ୍ ମାତର୍ ଏଗାର୍ କିଲମିଟର୍ ଜେକେତ୍ ଇମ୍ମାୟୁ ନାର୍ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଆଦ୍ ଦିନାମ୍‍ତେ ସାର୍‍ରେତଡ଼୍ ବେନେ ଗଟନା ଗଟେମ୍ ଆସ୍ ମାତ୍‍ତା ଆଦିନ୍ ବିଷୟତେ ତାମ୍ ଲୋପେ କେସମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ଅଡ଼୍‌‍ ଗଟି ତିର୍‍ୟାନ୍ ୱେଲେ ନୁ ମିଟିଙ୍କ୍ ମାଡ଼ମାନ୍ଦାନ୍ ୱେଲେ ଜିସୁ ନିଜେ ଅଡ଼୍‌‍ ଗାର୍‍ରେ ୱାସ୍ ଅଡ଼୍‌‍ତଡ଼୍ ଆଦାନଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼୍‍ତଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ଉଡ଼ି ଏଞ୍ଚାନଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ତାକ ତାକ ବେନ୍ ସାରେ ବିଷୟତେ ମିଡ଼୍ ତିର୍‍ୟୁତିଡ଼୍, ଆୱ୍ ସାରେ ବାତା ?” ଆଗାଙ୍କ୍ ଅଡ଼୍‌‍ ଦୁଃକାମ୍ ମକମ୍ ତେ ନିସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ କ୍ଲେୟପା ପେଦେର୍‍ତଣ୍ଡ୍ ଜିସୁଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଯିରୁଶାଲେମ୍ ତାଗ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଲୋପେକେ ନିମ୍‍ ୱେର୍‍ନି ଆଦ୍ ଜାଗେତାଦ୍ ଇଦ୍ ବେସର୍ ଦିନାତେ ଗଟନା ପୁନ୍‍ୱିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଇଦ୍ ବେସତ୍ ଗଟନା ?” ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ କେତ୍ତଡ଼୍, “ନାଜରିତିୟ ଜିସୁନ୍ ବିଷୟ; ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ ନୁ ସାରେତଡ଼୍ କନ୍‍ସ୍ ପାଡ଼ିୟି ନୁ ବାକ୍ୟତେ ୱେରଣ୍ଡ୍ ଶକ୍ତିନଡ଼୍ ବାବବାଦି ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ମେଣ୍ଡେ ମା ମୁକ୍ୟ ଯାଜକ ନୁ ଶାସନ୍‍ କର୍ତ୍ତାଲଡ଼୍ ଅଙ୍କ୍‌ ଜିୱେ ଇସ୍‌ କ୍ରୁଶବିଦ୍ଦ ମାଡ଼୍‍ତଡ଼୍ ନୁ ଅଣ୍ଡ୍‌ ଡୋଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ବାତେଙ୍କ୍ ଇତ୍କେ ବେନ ଇସ୍ରାଏଲ୍ ତିଙ୍କ୍ ମୁକ୍ତ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଯେ ଇ ନାରୁଡ଼୍, ଆଦ୍ ମାମେ ଆଶେ ମାଡ଼ିମାତମ୍; ମାତର୍ ଆଉ ସାରେ ୱିଡ଼୍‍ସିକ୍‍କେ ଇଦ୍ ସାରେ ଗଟେମ୍ ଆତ୍‍ତାଦ୍ ନେଟ୍‍ତେ କଞ୍ଜ୍ ମୁଣ୍ଡ୍ ଦିନା ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ମେଣ୍ଡେ ମିକା, ମା ଲୋପେକେ ବେସ୍‌କ୍ ନାଟା ମାକିଂଙ୍କ୍ ବାକ୍‍ୱା ଗଟି କେତ୍‍ତା; ଆୱ୍ ନାର୍‍କୁକେ ସମାଦିତା ଆଞ୍ଜ୍ ମାତ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ଆୱ୍ ନାଟା ଜିସୁନ୍ ମେନ୍ଦୁଲ୍ ଦର୍ସ୍‍କ୍‍ୱେକଟ ୱାସ୍ କେତ୍‍ତା ଯେ, ଆୱ୍ ନାଟା ଦୂତକିନାୱ୍ ଦର୍ଶନ୍ ମିକା ଆସ୍ ମିନ୍ଦେ ନୁ ଆୱ୍ ଦୂତ୍‍କ୍ କେତ୍‍ତା ଯେ, ଅଣ୍ଡ୍‌ ଜିୱେ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ମେଣ୍ଡେ, ମା ସାଙ୍ଗନ୍ ଲୋପେକେ ବେନ ସମାଦି ଗାର୍‍ରେ ଆଞ୍ଜ୍, ନାଟା ବେଲା କେସ୍‍ମାତ୍‍ତା, ଆଦେପୁଟୁଙ୍କ୍ ଉଡ଼୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଂକିଙ୍କ୍‌ ଉଡ଼ଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ଆଗାଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବେସର୍ ବାକ୍‍ୱା, ବବିଷ୍ୟଦ୍ ବକ୍ତାଲଡ଼୍ ବାତେଏ ସାରେ କେସ୍‍ମାତ୍‍ତଡ଼୍ ଆଦ୍ ସତ୍‍ତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାଙ୍କ୍ ମିଡ଼୍ ବେସର୍ ଲେଟ୍ ମାଡ଼୍‍ତିଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଇଦ୍ ସାରେ ଦୁଃକାମ୍ ତେ କଷ୍ଟ ଆସ୍ ତାନ୍ ମଇମାତାଗ୍ ଆସାନଙ୍କ୍ ବାତେଏ କ୍ରିଷ୍ଟନାଦ୍ ଦର୍‍କାର୍ ଇଲ୍‍ୱେମାତ୍‍ତେ ?” ");
INSERT INTO kff_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ମଶାଲ୍‌ ନୁ ସାରେତଡ଼୍ ବାବବାଦୀନି ଡ଼ାଗାଙ୍କ୍ ଆରାମ୍ ମାଡ଼ି ସାରେ ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ତାନ୍ ବିଷୟତେ ଗଟି ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବୁଜାମାଡ଼ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଅଡ଼୍‌‍ ବେନ୍ ନାର୍ ଆଞ୍ଜମାତ୍‍ତଡ଼୍, ଆଦ୍ ନାର୍ ଗାର୍‍ରେ ହେଉତାଙ୍କ୍, ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ମୁନେ କେନେ ଆଦାନଙ୍କ୍ ଆଦାନ୍ ରକମ୍ ମାଡ଼ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଡ଼୍‌‍ ଜିସୁଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତ୍‍ତଡ଼୍‍, “ମା ତଡ଼୍ ମାନ୍‍, ବାତେଙ୍କ୍ ଇତ୍କେ ମୁଲ୍‍ପୁଟ୍ ଆସମିନ୍ଦେ ନୁ ପଡ଼ଦ୍ ଆଞ୍ଜମିନ୍ଦେ ।” ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ତଡ଼୍ ମାନ୍ଦାନଙ୍କ୍ ଲୋତ୍‍ତେ ଲୋପେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଅଡ଼୍‌‍ତଡ଼୍ ତିନ୍ଦାନଙ୍କ୍ କୁଦ୍‍ତେୱେଲେ ଅଣ୍ଡ୍‌ ରୂଟି ଆସ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆଦ୍ ରୂଟି ଉହୁସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦାନଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ କଣ୍ଡା କୁଲେମ୍ ଆତ୍‍ତା ନୁ ଅଡ଼୍‌ ଆସୁଙ୍କ୍ ଜିସୁଙ୍କ୍ ଉଡ଼୍‍ତଡ଼୍; ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ ଉଡ଼ାନାଗାଙ୍କ୍ ମାୟିଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ଆଗାଙ୍କ୍ ଅଡ଼୍‌‍ ତାମ୍‍ତାମ୍ କେତ୍‍ତଡ଼୍, “ବେସୁଙ୍କ୍‍ ଆର୍‍ଦାଗ୍ ଅଣ୍ଡ୍‌ ମା ସାଙ୍ଗେ ଗଟି ତିର୍‍ୟମାତ୍ତଣ୍ଡ୍ ନୁ ମାକିଂଙ୍କ୍ ଦର୍ମଶାସ୍ତ୍ର ବୁଜାମାଡ଼ ମାତ୍‍ତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ବାତେଏ ମା ହୃଦୟ୍ କାମ୍‍କେ ଆୟିୱେ ମାତ୍‍ତେ ?” ");
INSERT INTO kff_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ତାନ୍ ପେର୍‍କେ ଅଡ଼୍‌‍ ଜାପେ ଆଗାଙ୍କ୍ ତେଦି ଯିରୁଶାଲେମ୍‍ତା ମାଲ୍‍ସ୍ଆଞ୍ଜ୍ ଗୁଡ଼୍‍ଡି ମାନ୍ଦାନ୍ ଏଗାର୍ ଜାନ୍ ଶିଷ୍ୟ ନୁ ତାମ୍ ସାଙ୍ଗଡ଼କ୍ ଉଡ଼୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ଅଡ଼୍‌‍ କେସମାତ୍‍ତଡ଼୍, “ପ୍ରବୁ ନିଜାମ୍ ତେଦ୍‍ତଣ୍ଡ୍ ନୁ ଶିମୋନ୍‍ତିଙ୍କ୍ ତଅନ୍‌ଦି ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ତାନ୍ ପେର୍‍କେ ଅଡ଼୍‌‍ ଇର୍‍ୱୁଡ଼୍ ହାର୍‍ଦାଗ୍ ବାତେସାରେ ଗଟେମ୍ ଆସ୍‍ମାତ୍‍ତେ, ମେଣ୍ଡେ ଅଡ଼୍‌‍ କେତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍ ବେଲା ଜିସୁଙ୍କ୍ ରୂଟି ଉହୁତାନ୍ ୱେଲେ ହେଞ୍ଚ୍ ପାର୍‍ତଡ଼୍ । ଆଦ୍ ସାରେ ଗଟନା ଅଡ଼୍‌‍ ମୁନେ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ଅଡ଼୍‌‍ ଇର୍‍ୱୁଡ଼୍ ସାରେ ଗଟି କେସମାନ୍ଦାନ୍ ୱେଲେ ଜିସୁ ନିଜେ ଅଡ଼ାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମି ସେଙ୍ଗେ ଶାନ୍ତି ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ମାତର୍ ଅଡ଼୍‌‍ ଦାଦ୍‍ରେଲ୍‍ତଡ଼୍ ନୁ ୱେର୍‍ସ୍ ୱେରନ୍ ବୁତ୍ ଉଡ଼୍‍ତଡ଼୍ ଇଞ୍ଜ ଏର୍କା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ତାନ୍ ପେର୍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବାତ୍‍ତିଙ୍କ୍ ଦାନ୍ଦେ ଆଦୁତିଡ଼୍, ମେଣ୍ଡେ ମି ମନ୍‍ତାଗ୍ ବାତ୍‍ତିଙ୍କ୍ ଇଦ୍ ରକମ୍ ନାକିଂଙ୍କ୍ ହେର୍କା ମାଡ଼ୁତିଡ଼୍‌ ? ");
INSERT INTO kff_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ନାନ୍ ତ ନିଜେ, ନାୱାଉ କାଇକ୍ ନୁ ଡେକା ଉଡ଼ାଟ୍, ନାକିଂଙ୍କ୍ ଇଟ୍‍ଟାଟ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାୱାଉ ବେଲା ଆଉଙ୍ଗ୍ ନୁ ବୁଲା ମାନ୍ଦାନାଉ ଉଡ଼ୁତିଡ଼୍, ବୁତ୍‌ତାଉ ଆଦ୍ ଲେକାମ୍ ଇଲା ।” ");
INSERT INTO kff_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ମେଣ୍ଡେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦ୍ କେସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅନାହୁ କାଇକ୍ ଡେକା ତଅତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ଆଲେକେ ମିକା ଅଡ଼୍‌ ୱେଡ଼୍‍କେତେ ମାଇଦିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼କଟ‍ ବାକ୍‍ୱା ଆଦାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଗେ ମି ଗାର୍‍ରେ ବାତେଏ ସୁଦୁଟ୍ ତିନ୍ଦାନାଦ୍ ମିନ୍ଦେ ?” ");
INSERT INTO kff_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ତାନ୍ ପେର୍‍କେ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ଆଟ୍‍ତାଦ୍ କିକେ ୱେରଡ଼୍‌ ଦୁଡ଼େ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ଜିସୁ ଆଦ୍ କିକେ ଅଡ଼୍‌ ମୁନ୍‍ନେ ତିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମୋଶାନ୍‌ ନିୟମ୍‍ତାଗ୍ ନୁ ବାବବାଦିଡ଼ାଦ୍ ନୁ ଗୀତସହିଂତା ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ନା ବିଷୟତେ ବାତ୍ ବାତ୍ ଲେକା ମିନ୍ଦେ, ଆୱ୍ ସାରେ ଆଦାନ୍ ମିନ୍ଦେ, ନାନ୍ ମିଇତଡ଼୍ ମାନ୍ଦାନ୍ ୱେଲେ ମିକିଂଙ୍କ୍ ଇଉସାରେ ଗଟି କେସ୍‍ମାତ୍‍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ଆସୁଙ୍କ୍ ଅଡ଼୍‌ ବେଲା ଦର୍ମଶାସ୍ତ୍ର ବୁଜେମ୍ ଆଦ୍‍ତଡ଼୍, ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାରେ ଗଟି ବୁଜା ମାଡ଼ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍ତଣ୍ଡ୍, “ଇଦ୍ ଲେକେମ୍ ଲେକାମିନ୍ଦା, କ୍ରିଷ୍ଟ କଷ୍ଟ ଆଦ୍‍ତନ୍ ନୁ ମୁଣ୍ଡ୍ ଦିନାତେ ଡଲ୍‍ତଡ଼ାଗାଙ୍କ୍ ଜିୱୁଅସ୍ ତେଦିତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଆରାମ୍ ମାଡ଼ି ସାରେ ଜାତିନଡ଼କ୍ ଅନ୍‌ ପେଦେର୍‍ତେ ପାପ୍‍କ୍ଷମା ମାଇଦିଙ୍କ୍ ମନ୍ ପରିବର୍‍ତନ୍ ମାଡ଼ାଙ୍କ୍ ପ୍ରଚାର ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ମିଡ଼୍ ଇଦ୍ ସାରେ ବିଷୟତାଦ୍ ସାକ୍ଷୀ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ମେଣ୍ଡେ ଉଡ଼ାଟ୍ ନା ବାବାଲ୍ ବାତ୍ ପ୍ରତିଜ୍ଞା ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ଆଦ୍ ନାନ୍ ମି ଗାର୍‍ରେ ରଅତିତାନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଶକ୍ତି ଦର୍‍କ୍‍ୱେଯାକ ମିଡ଼୍ ଯିରୁଶାଲେମ୍ ତାଗ୍ ମାନୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ତାନ୍ ପେର୍‍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେତନିୟା ଆଦାନ୍ ହାର୍‍ଦାଗ୍ ହେଉନା କାର୍‍ଙ୍ଗି ଆତ୍‍ତେ ନୁ ତାନ୍ କାୟ୍ ତେହେସ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ତାନ୍ ପେର୍‍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ି ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ଆଗାଙ୍କ୍ ମାୟିମିକା ସ୍ୱର୍ଗତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ମଡ଼୍‍କିମିକା ଗାଟି ୱେଡ଼୍‍କାତେ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆଦ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ମେଣ୍ଡେ ସାରେଦିନାମ୍ ଯୀରୁଶାଲାମ୍ ମନ୍ଦିର୍‍ତାଗ୍ ମାଞ୍ଜ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ସ୍ତୁତି ପ୍ରସଂଶା ମାଡ଼ାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ ।");
INSERT INTO kff_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ମୁନେଙ୍କ୍ ବାକ୍ୟ ମାତ୍‍ତେ, ବାକ୍ୟ ଇଶ୍ୱରତଡ଼୍ ମାତ୍‍ତେ, ବାକ୍ୟ ନୁ ଇଶ୍ୱର୍ ୱେରନ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ବାକ୍ୟ ମୁନେଙ୍କ୍ ଇଶ୍ୱରତଡ଼୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ଅଣ୍ଡ୍‌ ତଡ଼୍ ଇଶ୍ୱର୍ ସାରେ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍; ମେଣ୍ଡେ ବେନ୍‍ସାରେ ତିଆର୍ ଆସ୍‍ମିନ୍ଦେ, ଆୱିନାଗାଙ୍କ୍ ୱେରଡ଼୍ ମେଣ୍ଡେ ଅଙ୍କ୍‌‍ୱିଡ଼୍‍ସି ତିଆର୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ଅନ୍‌‍ଆଗେ ଜିୱୁନ୍ ମାତ୍‍ତେ ନୁ ଆଦ୍ ଜିୱୁନ୍ ନାରୁଡ଼୍‍ତେ ୱେସ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ଆଦ୍ ୱେସ୍ ହିକାଡ଼୍‍ତାଗ୍ ନିଡ଼୍‍ସ ୱାସମିନ୍ଦେ, ମେଣ୍ଡେ ହିକାଡ଼୍ ତାକିଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ । ");
INSERT INTO kff_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ଇଶ୍ୱରତେ ଗାରେକନ୍‍ ୱେରଣ୍ଡ୍ କବର୍ ଆଦାନଣ୍ଡ୍ ନାରୁଡ଼୍ ଆତ୍‍ତଣ୍ଡ୍; ଅନ୍‌ ପେଦେର୍ ଯୋହନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ଅଣ୍ଡ୍‌ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ୱେସ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆଦ୍ କେଞ୍ଜି ସାରେତଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ୱାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ଯୋହନ୍‌ ନିଜେ ଆଦ୍ ୱେସ୍ ହିଲକଟ୍ ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ୱେସ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ୱାତ୍‍ତଣ୍ଡ୍ ");
INSERT INTO kff_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ବେନ୍ ସତ୍ ୱେସ୍ ଜଗତ୍‍ତାଗ୍ ୱାସ୍ ସାରେତଡ଼୍ ନାରୁଡ଼୍‍କ୍ ୱେସ୍ ମାଡ଼ିତେ, ଆଦେ ନିଜାତାଦ୍ ୱେସ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ଅଣ୍ଡ୍‌ ଜଗତ୍‍ତାଗେ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଜଗତ୍ ଅନ୍‌ ତଡ଼୍ ତିଆର୍ ଆତ୍‍କେ, ମିକା ଜଗତ୍ ଅଂକିଙ୍କ୍‌ ହେଞ୍ଚ୍‍ ପାର୍‍ୱ । ");
INSERT INTO kff_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ଅଣ୍ଡ୍‌ ନିଜେତ୍ ରାଜ୍ୟତାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍, ମିକା ଅନ୍‌ ନିଜେତ୍ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ମାତର୍ ବେସର୍ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍, ଇତ୍‍କେ ବେନଡ଼୍ ଅନ୍‌ ପେଦେର୍‍ତେ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍, ଆ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଶ୍ୱରତେ ମାର୍‍ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଦିକାର୍‌ ହିତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ଅଡ଼୍‌ ନେତୁର୍‍ତାଗାଙ୍କ୍, ମେନ୍ଦୁଲ୍‍ତେ ଇଚ୍ଛାତେ ବା ନାରୁଡ଼୍ ଇଚ୍ଛାତେ ଜନମ୍ ଆୟ୍‍ୟଡ଼୍, ବେଲାନ୍ ଇଶ୍ୱରତାଗାଙ୍କ୍ ଜନମ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ମେଣ୍ଡେ, ଆଦ୍ ବାକ୍ୟ ମେନ୍ଦୁଲ୍ ପଇତେ, ମେଣ୍ଡେ ଅନୁଗ୍ରହ ନୁ ସତ୍‍ତେ ନିଣ୍ଡି ମାନ୍‍ ଲୋପେ ବାସେ ମାଡ଼୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ବାବାନାଗାଙ୍କ୍ ୱାତ୍ ୱେରଡ଼୍ ଇଞ୍ଜ ମାର୍‍ଦେ ମହିମା ଲେକାମ୍ ମାମ୍‍ମେ ଅନ୍‌ ମହିମାତିଙ୍କ୍ ଉଡ଼୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଯୋହନ୍‌ ତାନ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ଇସ୍‌ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଣ୍ଡ୍, “ବେନ ନା ପେର୍‍କେ ୱାଦୁତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନାକିଙ୍କ୍ଅନ୍‌ ବାଡ଼୍‍ୟଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ‘ଅଣ୍ଡ୍‌ ନା ଜନମ୍‍ତେ ମୁନେକ୍ କନ୍‍ସ୍ ମାତ୍‍ତଣ୍ଡ୍, ବେନ ବିଷୟ୍‍ତେ ନାନେ ଇଲା କେସ୍‍ମାତ୍‍ତାନ୍ ଅଣ୍ଡ୍‌ ହିଣ୍ଡେ ।’” ");
INSERT INTO kff_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ତ ଅଣ୍ଡ୍‌ ସାରେତାଗାଙ୍କ୍ ମାମ୍‍ମେ ସାରେତମ୍ ପାଏମ୍ ଆସ୍‍ମିନ୍ଦେମ୍, ଅନୁଗ୍ରହତେ ପର୍‍ ଅନୁଗ୍ରହ ପାଏମ୍ ଆସ୍‍ମିନ୍ଦେମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ଇଶ୍ୱର୍‌ତେ ବ୍ୟବସ୍ଥା ମୋଶାନ୍‌ ତଡ଼୍ ଦର୍‍କି ମିନ୍ଦେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅନୁଗ୍ରହ ନୁ ସତ୍ ଜିସୁକ୍ରିଷ୍ଟନ୍ ତଡ଼୍ ଉପସ୍ଥିତ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ବେନ ବେସୁଙ୍କ୍‍ ଇଶ୍ୱରତିଙ୍କ୍ ଉଡ଼ଣ୍ଡ୍, ଅନ୍‌ ଡ଼େକାନାଗ୍ ମାନ୍ଦାନ୍ ୱେରଣ୍ଡେ ମାର୍‍ ଅଂକିଙ୍କ୍‌ କେସ୍ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ଯିରୁଶାଲେମ୍‍ତେ ଯିହୁଦୀ ନେତାଲଡ଼୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଦର୍ମ ଯାଜକ୍ ନୁ ଲେବୀୟ ନାରୁଡ଼୍‍କ୍ ଯୋହନ୍‌‌ତେ ଗାର୍‍ରେ “ନିମ୍‍ ବେନ,” ଇଞ୍ଜ ପାଚ୍ରାମାଡ଼ାନ୍‍ ମାଇଦିଙ୍କ୍ ରହ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ଅଣ୍ଡ୍‌ ଅସ୍ୱୀକାର୍ ମାଡ଼କଟ୍ ସାଏମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ମସିହ ଆୟନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ଆସୁଟେ ଅଡ଼୍‌‍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ଆଲାଇତ୍‍କେ ନିମ୍‍ ବାତେଏ ଏଲୀୟନି ?” ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାନେ ଆୟନ୍ । ନିମ୍‍ ବାତେଏ ଆ ବାବବାଦୀନୀ ?” ଅଣ୍ଡ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍ “ଇଲା ।” ");
INSERT INTO kff_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ଆସୁଟେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ମାକିଂଙ୍କ୍ ରୟ୍‍ସ୍‍ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଉତ୍ତର୍ ହିଦ୍‍ପାର୍‍ଦ୍‍ତମ୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ନିମ୍‍ ବେନନି ? ନିମ୍‍ ନିଜ୍ ବିଷୟ୍‍ତେ ବାତେଏ କେତୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଯିଶାଇୟ ବାବବାଦୀ ବେଦ୍‍ପୁଟୁଙ୍କ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଯୋହନ୍‌ ଆଦେପୁଟୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଉସ୍କ ନେଲ୍‍ଦାଗ୍ କିଡ଼୍‍କମାନ୍ଦାନ୍‍ ୱେରନ୍ ନାରୁନ୍ ଲେଙ୍ଗ୍, ପ୍ରବୁନ୍ ଆର୍ ତିଆର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ପାରୂଶୀନାରୁଡ଼୍ ରହସ୍ ମାନ୍ଦାନ୍ କବର୍ କେତାନଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ନିମ୍‍ ଯଦି କ୍ରିଷ୍ଟ କି ଏଲୀୟ କି ଆ ବାବବାଦୀ ଆୟ୍‍ୱିନ୍, ଆଲାଇତ୍‍କେ ବାତେଙ୍କ୍ ବାପ୍ତିସ୍ମ ହିଦୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଯୋହନ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଏର୍‍ଦାଗ୍ ବାପ୍ତିସ୍ମ ଇଦୁତାନ୍; ବେନଙ୍କ୍ ମିଡ଼୍ ପୁନ୍‍ୱିଡ଼୍, ଅଣ୍ଡ୍‌ ମିଇ ଲୋପେ ମିନ୍ଦେଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ଅଣ୍ଡ୍‌ ନା ପେର୍‍କେ ୱାସମିନ୍ଦେଣ୍ଡ୍, ଅନ୍‌ ଡେକେତ୍ ବନ୍ଦନ୍ ଲେଏତାଙ୍କ୍ ନାନ୍ ଯୋଗ୍ୟ ଆୟନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ହି ସାରେ ଗଟନା ଯର୍ଦ୍ଦନ୍ ବେଡ଼େମ୍‍ତେ ମେଣ୍ଡନ୍ ପାକେ ମାନ୍ଦାନ୍ ବେତାନି ନାର୍ ଗଟେମ୍ ଆସ୍‍ମାତେ । ହି ପଡ଼ିୟେତାଗ୍ ଯୋହନ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବାପ୍ତିସ୍ମ ଇସ୍‌‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ଆସୁଟେ ମେଣ୍ଡନ୍ ଦିନ୍ ଯୋହନ୍‌ ଜିସୁଙ୍କ୍ ନିଜେତ୍ ଗାର୍‍ରେ ୱାଦାନାଦ୍ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ହି ଉଡ଼ାଟ୍, ଇଶ୍ୱର୍‌ତେ ମେଣ୍ଢାମେଇତାନଣ୍ଡ୍, ବେନ ଜଗତ୍‍ତେ ପାପ୍ କାଞ୍ଜିଆଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ନା ପେର୍‍କେ ବେନ ୱାସ ମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନା କନ୍‍ସ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ୱାସମିନ୍ଦେଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ନା ଜନମ୍‍ତେ ମୁନେକନ୍‍ସ୍ ମାତ୍‍ତଣ୍ଡ୍, ବେନ ବିଷୟ୍‍ତେ ନାନ୍ ଇଦ୍ କେସ୍‍ମିନ୍ଦେନ୍ ଅଣ୍ଡ୍‌ ହିଣ୍ଡେ । ");
INSERT INTO kff_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ନାନ୍ ଆନ୍‌‍ତେ ଅଂକିଙ୍କ୍‌ ହେଞ୍ଚକଟ୍ ମାତ୍‍ତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଇସ୍ରାଏଲ୍‍ ନାରୁଡ଼୍‍ତେ ଗାର୍‍ରେ ତିଆର୍ ଆଦ୍‍ତନ୍, ଆଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ଏର୍‍ଦାଗ୍ ବାପ୍ତିସ୍ମ ହିଦାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ମେଣ୍ଡେ, ଯୋହନ୍‌ ସାକ୍ଷ୍ୟ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଆତ୍ମାତିଙ୍କ୍ ପାର୍ୱା ରକମ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଡିଗାନାଦ୍, ମେଣ୍ଡେ ଆଦ୍ ଅନ୍‌ ପର୍‍ର କୁଦାନାଦ୍‍ ଉଡ଼୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ନାନେ ଆନ୍‌‍ତେ ଅଂକିଙ୍କ୍‌ ହେଞ୍ଚକଟ୍ ମାତ୍‍ତାନ୍, ମାତର୍ ବେନ ନାକିଂଙ୍କ୍ ଏର୍‍ଦାଗ୍ ବାପ୍ତିସ୍ମ ହିଦାଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବେନଡ଼୍‍ ପର୍‍ ଆତ୍ମାତିଙ୍କ୍ ଡିଗାନାଦ୍ ଉଡ଼ିତିନ୍, ଅଣ୍ଡ୍‌ ଆ ନାରୁଡ଼୍‌ଣ୍ଡ୍‌, ବେନ ପବିତ୍ର ଆତ୍ମାତେ ବାପ୍ତିସ୍ମ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ମେଣ୍ଡେ ନାନ୍ ଆଦ୍ ଉଡ଼ିମିନ୍ଦେନ୍ ନୁ ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ଇଞ୍ଜ ସାକ୍ଷ୍ୟ ଇସ୍‌‍ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ମେଣ୍ଡନ୍‍ଦିନେ ମେଣ୍ଡନ୍‍ଦାମ୍ ଯୋହନ୍‌ ନୁ ତାମ୍ ଶିଷ୍ୟଡ଼୍ ଲୋପେଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍ ତଡ଼୍ ନିସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ ଆଦ୍ ଆର୍ ଇସ୍‌ ଆଦାନାଦ୍ ଉଡ଼ି ଅଂକିଙ୍କ୍‌ ଅଣ୍ଡୟ୍‌‍ ଦୃଷ୍ଟିତେ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ହିକ୍ ଉଡ଼ାଟ୍ ଇଶ୍ୱର୍‌ତେ ମେଣ୍ଢାମେଇତାନଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ଆଦ୍ ଇର୍‍ୱୁଡ଼୍ ଶିଷ୍ୟଡ଼୍ ଯୋହନ୍‌‌ତେ ଗଟି କେଞ୍ଜି ଜିସୁନ୍ ପେର୍‍କେ ପେର୍‍କେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜିସୁ ମାଲ୍‍ସ୍ ଅଡ଼୍‌‍ ପେର୍‍କେ ପେର୍‍କେ ୱାଦାନାଦ୍ ଉଡ଼ି ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବାତେଏ ମେହ୍‍କୁତିଡ଼୍ ?” ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ରାବ୍‍ବି, ହିଦିନ୍ ଅର୍ତ ଗୁରୁ ନିମ୍‍ ବେଗେ ମାନ୍ଦୁତି ?” ");
INSERT INTO kff_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ଜିୱୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ୱାଡ଼ାଟ୍, ଉଡ଼ିତିଡ଼୍ ।” ଆସୁଟେ ଅଡ଼୍‌ ଆଞ୍ଜ୍ ଅନ୍‌ ପଡ଼୍‍ୟ୍ ଉଡ଼୍‍ତଡ଼୍, ମେଣ୍ଡେ ଆଦ୍ ଦିନ୍ ଅନ୍‌‍ତଡ଼୍ ମାତ୍‍ତଡ଼୍; ଆସୁଟେ ପାୟାଲ୍ ନାଲୁ ଗାଣ୍ଟା ଆସ୍‍ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ବେନଡ଼୍ ଇର୍‍ୱୁଡ଼୍ ଯୋହନ୍‌‌ତେ ଗଟି କେଞ୍ଜି ଜିସୁନ୍ ପେର୍‍କେ ପେର୍‍କେ ଆଞ୍ଜ୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ଶିମୋନ୍ ପିତର୍‍ତେ ଦାଦାଲ୍ ଆନ୍ଦ୍ରିୟ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ଆନ୍‌ଦ୍ରିୟ ପ୍ରତମ୍ ନିଜର୍ ତାମୁଣ୍ଡ୍‌ ଶିମୋନ୍‍ତିଙ୍କ୍ ଉଡ଼ିମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ମାମ୍‍ମେ ମସିହଙ୍କ୍ ଉଡ଼ିମିନ୍ଦେମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ଆନ୍‌ଦ୍ରିୟ ଅଂକିଙ୍କ୍‌ ଜିସୁନ୍ ଗାର୍‍ରେ ତାତ୍‍ତଣ୍ଡ୍ । ଜିସୁ ଅଂକିଙ୍କ୍‌ ଅଣ୍ଡୟ୍‌‍ ଦୃଷ୍ଟିତେ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ଶିମୋନ୍, ଯୋହନ୍‌‌ତେ ମାର୍‍ । ନିମ୍‍ କେଫା ପେଦେର୍ ତେ କ୍ୟାତ୍‌ ଆଦ୍‍ତିନ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ମେଣ୍ଡନ୍‍ଦିନେ ଜିସୁ ଗାଲିଲୀତାଗ୍ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ପିଲିପ୍‍ତିଙ୍କ୍ ଉଡ଼ିମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନା ପେର୍‍କେ ୱାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ପିଲିପ୍ ବେତ୍‍ସାଇଦାତେ ନାରୁଣ୍ଡ୍‍ ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଆନ୍ଦ୍ରିୟ ନୁ ପିତର୍‍ତେ ନାର୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପ୍ ନିତନିୟେଲ୍‍ତିଙ୍କ୍ ଉଡ଼ିମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ବେନ ବିଷୟ୍‍ତେ ମୋଶାଲ୍‌ ବ୍ୟବସ୍ଥା ବଇତାଗ୍ ଲେକିମିନ୍ଦେଣ୍ଡ୍, ମେଣ୍ଡେ ବାବବାଦିଡ଼୍ ଆନ୍‌‍ତେ ଲେକିମିନ୍ଦେଡ଼୍, ମାମ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ମିନ୍ଦେମ୍; ଅଣ୍ଡ୍‌ ଯଷେପ୍‍ତେ ମାର୍‍ ନାଜରିତିୟ ଜିସୁ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିତନିୟେଲ୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନାଜରିତ ତାଗାଙ୍କ୍ ବାତ୍ ସାୟେତ୍ ବିଷୟ୍ ପେଇତେ ପାର୍‍ଦ୍‍ତେ ?” ପିଲିପ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ୱାସ୍ ଉଡ଼ୁ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଜିସୁ ନିତନିୟେଲ୍‍ତିଙ୍କ୍ ତାନ୍ ଗାର୍‍ରେ ୱାଦାନାଦ୍ ଉଡ଼ି ଅନ୍‌ ବିଷୟ୍‍ତେ କେତ୍‍ତଣ୍ଡ୍, “ହି ଉଡ଼ାଟ୍, ହିଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନିଜାମ୍ ଇସ୍ରାଏଲ୍‍ତେ ନାରୁଡ଼୍, ହିନାଗ୍ ଚାଲାକି ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିତନିୟେଲ୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେଲା ହେଞ୍ଚ୍‍ତିନ୍ ?” ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ପିଲିପ୍ ନିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗାନ୍‍ ମୁନେ ନିମ୍‍ ବେସୁଙ୍କ୍‍ ତୟେମାଡ଼େତ୍ ମଦଲ୍ ମାତ୍‍ତି, ଆସୁଟେ ନାନ୍‍ନେ ନିକିଂଙ୍କ୍ ଉଡ଼ିମାତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିତନିୟେଲ୍ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ନିମ୍‍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍, ନିମ୍‍ ଇସ୍ରାଏଲ୍‍ତେ ରାଜାନି ।” ");
INSERT INTO kff_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ନିକିଂଙ୍କ୍ ତୟେମାଡ଼େତ୍ ମଦଲ୍ ଉଡ଼ିମାତ୍‍ତାନ୍ ଇଞ୍ଜ କେତ୍‍ତାଙ୍କେ ନିମ୍‍ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତି ? ନିମ୍‍ ଇଦିଙ୍କ୍‌ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ବେଡ଼୍‍ୟା ବେଡ଼୍‍ୟାଦ୍‍ ବିଷୟ ଉଡ଼ିତି ।” ");
INSERT INTO kff_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ମେଣ୍ଡେ, ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ମିଡ଼୍ ସ୍ୱର୍ଗତିଙ୍କ୍ କୁଲା ନୁ ଇଶ୍ୱର୍‌ତେ ଦୂତକିଂଙ୍କ୍ ନାରୁଡ଼୍ ପିଲେତ୍ ପର୍‍ର ତାରାନାଦ୍ ନୁ ଡିଗାନାଦ୍ ଉଡ଼ିତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ରେଣ୍ଡ୍ ଦିନା ପେର୍‍କେ ଗାଲିଲୀ ନାର୍ ୱେରଡ଼୍ ପେଣ୍ଡୁଲ୍ ଆତ୍‍ତେ, ମେଣ୍ଡେ ଜିସୁନ୍ ୟାୟ୍‍ ଆଗେ ମାତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜିସୁ ଆନ୍‌‍ତେ ନିଜେତ୍ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ଆଦ୍ ପେଣ୍ଡୁଲ୍‍ତାଗେ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ପେର୍‍କେ ଦ୍ରାକ୍ଷାରସ୍ ତେରି ଆତ୍‍ତାଙ୍କ୍ ଜିସୁନ୍ ୟାୟ୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ଅଡ଼ାଦ୍‌ ଦ୍ରାକ୍ଷାରସ୍ ତେରିଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ଆସୁଟେ ଜିସୁ ତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନି ତଡ଼୍ ନାୱାଦ୍ ବାତ୍ ଇଲେ, ନାକିଂଙ୍କ୍ ବାତେଙ୍କ୍ ଆଦିନାଗ୍ କାସ୍‍ପମାତ୍‍ତି ? ନାୟାଦ୍ ଦିନାମ୍ ଇଞ୍ଜେକ୍ ଆୟ୍‍ନା ହେୱକେ ।” ");
INSERT INTO kff_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ତାମ୍ ୟାୟ୍‍ ତୁସାନଡ଼୍‍କିଙ୍କ୍‍ କେତ୍‍ତେ, “ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ବାତେମେଣ୍ଡେ କେତିତଣ୍ଡ୍, ଆଦ୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ମେଣ୍ଡେ, ଆଗେ ଯିହୁଦୀନାରୁଡ଼ାଦ୍ ଶୁଚିଆଦାନ୍ ନିୟମ୍ ଲେକାମ୍‍ତେ ରେଣ୍ଡ୍ ବା ମୁଣ୍ଡ୍ ମହଣିଆ ଆରୁଟାନ୍ କାଲ୍‍କିନ୍ କୁଣ୍ଡା ନେହେସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜିସୁ ଦାସଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “କୁଣ୍ଡାନାଗ୍ ଏର୍‍ ବର୍ତ୍ତି ମାଡ଼ାଟ୍ ।” ଆସୁଟେ ଅଡ଼୍‌ ହାଉସାରେ ନିଣ୍ଡ୍‍ନା ଯାକ ବର୍ତ୍ତି ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ମେଣ୍ଡେ, ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଞ୍ଜେ ଟେଣ୍ଡି ଅସ୍ ବଜିତ୍ ମୁକ୍ୟାନ୍ ଗାର୍‍ରେ ଆୟ୍‍ମୁଟ୍,” ଆସୁଟେ ଅଡ଼୍‌ ଅତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ବଜିତେ ମୁକ୍ୟାଲ୍ ଦ୍ରାକ୍ଷାରସ୍ ଆସ୍‍ମାନ୍ଦାନ୍ ଆଦ୍ ଏର୍‍ଦିଙ୍କ୍ ନାକି ଆଦ୍ ବେଗାଙ୍କ୍ ୱାତ୍‍ତେ ଇଦ୍ ପୁନକଟ୍ ମାତ୍‍ତଣ୍ଡ୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଦ୍ ବେଗାଙ୍କ୍ ୱାତ୍‍ତେ ଆଦ୍ ଦାସଡ଼୍ ପୁଞ୍ଜ୍ ମାତ୍‍ତଡ଼୍, ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ବରତିଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ସାରେତଡ଼୍ ମୁନେଙ୍କ୍‍ତେ ସାୟେତ୍ ଦ୍ରାକ୍ଷାରସ୍ ହିଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ନାରୁଡ଼୍ ଆସ୍‍ତେ ୱେୟ୍, ପିନ୍ଦ୍‍ୱାଦ୍ ହିଦ୍‍ତଡ଼୍; ମିଡ଼୍ ହି ଯାକ ସାୟେତାଦ୍‍ ଦ୍ରାକ୍ଷାରସ୍ ନେହେସ୍ ମିନ୍ଦେଡ଼ି ।” ");
INSERT INTO kff_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଜିସୁ ହିଦ୍‍ଲେକାମ୍ ଗାଲିଲି ନାର୍‍ତେ ମୁନେଙ୍କ୍‍ତେ ବାକ୍‍ୱାକାମ୍ ଆରମ୍ଭମାଡ଼ି ନିଜେତ୍ ମହିମା ମାଡ଼୍‍ଡ଼ିତ୍‍ତନ୍, ମେଣ୍ଡେ ଅନ୍‌ ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ନିଜେତ୍ ୟାୟ୍‍, ଦାଦାଲ୍‍ତାମୁଣ୍ଡ୍‍ ନୁ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ କପର୍ନାହୁମ୍‍‍ତାଗ୍ ଆଦ୍‍ତଡ଼୍; ମେଣ୍ଡେ ଅଡ଼୍‌ ଆଗେ ନାର୍ଗେଦିନା ମାନଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ଆସୁଟେ ଯିହୁଦି ନାରୁଡ଼ାଦ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ଗାର୍‍ରେ ହେୱସ୍‍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ଜିସୁ ଯିରୁଶାଲେମ୍‌‍ତା ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ମେଣ୍ଡେ, ଜିସୁ ମନ୍ଦିର୍‍ତାଗ୍ ଗଡ୍‍କ୍, ମେଣ୍ଢା ନୁ ବଡେ ୱାମାନ୍‍ନାରୁଡ଼୍‍କ୍ ମେଣ୍ଡେ ଡାବ୍ ବ୍ୟବସାୟିନାରୁଡ଼୍‍କ୍ କୁଦିମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ନଡ଼େତେ ୱେରଡ଼୍ ଇକ୍‍ଲେମ୍ ତିଆର୍ ମାଡ଼ି ମେଣ୍ଢା ନୁ ଗଡ୍‍କିଂଙ୍କ୍ ତଅସ୍ ସାରେତାୱିଙ୍କ୍ ମନ୍ଦିର୍‍ତାଗାଙ୍କ୍ ବାୟିଦେ ପେସ୍‍ପିତ୍‍ତଣ୍ଡ୍; ଡାବ୍ ବ୍ୟବସାୟି ନାରୁଡ଼୍‍ଡାୱ୍‍ ଡାବ୍‌କ୍‌ସାରେ ଲେକିସ୍ ଅଡ଼ାୱୁ ଟେବୁଲ୍‍କିଙ୍କ୍ ଉଲ୍‍ଟା ମାଡ଼ିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ମେଣ୍ଡେ ଜିସୁ ବଡେ ୱାମାନଡ଼୍‍କିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହିୱିଙ୍କ୍ ଇଗାଙ୍କ୍ ଆୟ୍‍ମୁଟ୍, ନା ବାବାନ୍ ଲୋତ୍‍ତିଙ୍କ୍ ଆସାନ୍ ୱାମାନ୍ ଲୋନ୍‌ ମାଡ଼୍‍ମାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ଇଦ୍ ଉଡ଼ି ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଶାସ୍ତ୍ରତାଗ୍ କେତ୍‍ତାଦ୍ ୱେରନ୍ ବାକ୍ୟ ହେର୍କା ମାଡ଼୍‍ତଡ଼୍; “ମିଇ ଲୋତ୍‍ତେ ସେଙ୍ଗେ ନାୟାଦ୍ ଉକ୍ତି ନା ଲୋପେ କିସ୍ ଲେକାମ୍ ନିଡ଼୍‍ସମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ଆସୁଟେ ଯିହୁଦୀ ଅଦକ୍ଷଲଡ଼୍ ଜିସୁନ୍ ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ୱାସ୍ ଇଦ୍ ପ୍ରଶ୍ନ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ନିମ୍‍ ହି ସାରେ ପାଡ଼୍‍ୟି ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଅଦିକାର୍‌ ଦର୍‍କାନ୍ ମାତ୍‍ତେ ଇଞ୍ଜ ମାମ୍‍ମେ ବେଲା ପୁନ୍‍ତମ୍ ? ମେଣ୍ଡେ ବେନ୍ ଚିହିହ୍ନେ ତଡ଼୍ ମାକିଂଙ୍କ୍ ତୟ୍‍ସ ମିନ୍ଦେନି ?” ");
INSERT INTO kff_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ହି ମନ୍ଦିର୍‍ତିଙ୍କ୍ ଉହୁସିମୁଟ୍, ମେଣ୍ଡେ ମୁଣ୍ଡ୍ ଦିନାତେ ଲୋପ୍ ନାନେ ଆଦିଙ୍କ୍ ତିଆର୍ ମାଡ଼ିଦ୍‍ତାନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ଆସୁଟେ ଯିହୁଦୀଡ଼୍‍ କେତ୍‍ତଡ଼୍, “ହି ମନ୍ଦିର୍ ତିଆର୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଚୟାଳିଶ ହେଣ୍ଡ୍‍କ୍ ଲାଗେମ୍‍ ଆତ୍‍ତେ; ମେଣ୍ଡେ ନିମ୍‍ ବାତେଏ ତାଙ୍କ୍ ମୁଣ୍ଡ୍ ଦିନାତେ ତିଆର୍ ମାଡ଼ିଦ୍‍ତି ?” ");
INSERT INTO kff_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନିଜର୍ ମେନ୍ଦୁଲ୍‍ତେ ଲେକାମ୍ ମନ୍ଦିର୍‍ତିଙ୍କ୍ ରକ୍ଷାମାଡ଼ି ଇଦ୍ ବିଷୟ୍ କେସମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଡଲିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ତେଦ୍‍ତା ପେର୍‍କେ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଅଣ୍ଡ୍‌ ଇଲା କେସମାତ୍‍ତନ୍ ଇଞ୍ଜ ହେର୍କା ମାଡ଼୍‍ତଡ଼୍; ଅଡ଼୍‌ ଦର୍ମଶାସ୍ତ୍ର ନୁ ଜିସୁନ୍ କେସ୍‍ମାନ୍ଦାନ୍ ବାକ୍ୟତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ହେଉତେ ସମୟ୍‍ତେ ଜିସୁ ଯିରୁଶାଲେମ୍‌‍ତାଗ୍ ମାନ୍ଦାନ୍‍ୱେଲେ ନାର୍‍ଗେ ଅନାଦ୍‌ ମାଡ଼୍‍ତାଦ୍ ଆଶର୍ଯ୍ୟ କାମ୍ ଉଡ଼ି ଅନ୍‌ ପେଦେର୍‍ତେ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଅଡ଼୍‌ ପର୍‍ର ଆଶେ ୱାଟେ ପାର୍‍ୱଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ସାୟେ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ମେଣ୍ଡେ, ବେନ ଯେ ନାରୁନ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷହିଦ୍‍ତ, ଇଦ୍ ଅନ୍‌‍ୱାଦ୍ ଦର୍‍କାର୍ ହିଲକଟ୍ ମାତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁନ୍ ହୃଦୟ୍‍ତାଗ୍ ବାତା ମିନ୍ଦେ, ଆୱ୍ ଅଣ୍ଡ୍‌ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୂଶୀଡ଼୍ ଲୋପେ ନିକଦୀମ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଯିହୁଦିଡ଼୍ ୱେରଣ୍ଡ୍ ନେତାଲ୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ଅଣ୍ଡ୍‌ ନାର୍‍କା ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ନିମ୍‍ ଯେ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାସ୍ ମିନ୍ଦେନି, ହିଦ୍ ମାମ୍ ପୁତ୍‍ତମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିମ୍‍ ହିୱ୍ ବେନ୍‍ସାରେ ବାକ୍‌ୱାକାମ୍ ମାଡ଼ମିନ୍ଦେନି, ଇଶ୍ୱର୍ ତଡ଼୍ ହିଲକଟ୍ ମାତ୍‍କେ ହାଉସାରେ ବେନ ମାଡ଼୍‍ପାର୍‍ୱଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନେ ନିକିଂଙ୍କ୍ କେତୁତାନ୍, ମେଣ୍ଡନ୍‍ଦାମ୍ ଜନମ୍ ଆୟ୍‍ୟକଟ ମାତ୍‍କେ ବେନମେଣ୍ଡେ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ଉଡ଼୍‍ ପାର୍‍ୱଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦୀମ୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ମୁୟ୍‍କେ ନାରୁଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଜନମ୍ ଆଦ୍‍ପାର୍ଦତଣ୍ଡ୍ ? ଅଣ୍ଡ୍‌ ବାତେଏ ଦ୍ୱିତୀୟଦାମ୍‍ ନିଜେତ୍ ୟାୟାନ୍ ଡଙ୍କେତ୍‍ତାଗାଙ୍କ୍ ନେଙ୍ଗି ଜନମ୍ ଆଦ୍‍ପାର୍ଦତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନ୍ ନିକିଂଙ୍କ୍ କେତୁତାନ୍, ଏର୍‍ ନୁ ଆତ୍ମାତେ ଜନମ୍ ଆୟ୍‍ୟକଟ ମାତ୍‍କେ ବେନମେଣ୍ଡେ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗ୍ ନେଙ୍ଗାଙ୍କ୍‍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ମେନ୍ଦୁଲ୍‍ତାଗାଙ୍କ୍‍ ବାତେଏ ତିଆର୍ ଆତ୍‍ତେ, ଆଦ୍ ମେନ୍ଦୁଲ୍; ମେଣ୍ଡେ ଆତ୍ମାତାଗାଙ୍କ୍‍ ବାତେଏ ଆତ୍‍ତେ, ଆଦ୍ ଆତ୍ମା । ");
INSERT INTO kff_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ମିକିଂଙ୍କ୍ ନିଜାମ୍ ମେଣ୍ଡଣ୍ଡ୍‍ଦାମ୍ ଜନମ୍ ଆଦ୍‍ ୱେୟ୍‍ତିତ୍ ଇଞ୍ଜ ନାନ୍ ଯେ ନିକିଂଙ୍କ୍ କେତ୍‍ତାନ୍, ଆଦିଙ୍କ୍ ଦାଦ୍‍ ରେଲ୍‍ମା । ");
INSERT INTO kff_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ଗାଲ୍ ବେନ୍ ପାକେ ଇଚ୍ଛା ମାଡ଼ିତେ, ଆଦ୍ ପାକେ ଆଦ୍‍ତେ, ମେଣ୍ଡେ ନିମ୍‍ ତାନ୍‍ୱାଦ୍ ମର୍‍ରେ କେଞ୍ଜିତିନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ବେଗାକନ୍‍ସ୍ ୱାଦ୍‍ତେ ମେଣ୍ଡେ ବେକେ ଆଦ୍‍ତେ, ଆଦ୍‍ପୁନ୍‍ୱିନ୍; ଆତ୍ମାତାଗାଙ୍କ୍‍ ପୁଟ୍‍ତେନଡ଼୍‍ ସାରେ ନାରୁଡ଼୍ ଆଦ୍‌ ରକମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦୀମ୍ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ହି ସାରେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଆଦ୍ ପାର୍‍ଦ୍‍ତା ?” ");
INSERT INTO kff_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ଇସ୍ରାଏଲ୍‍ତେ ୱେରଣ୍ଡ୍ ଗୁରୁ ଆଶେ ମିକା ବାତେଏ ହି ସାରେ ବୁଜେମ୍ ଆଦ୍‍ପାର୍‍ୱିନି ? ");
INSERT INTO kff_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ନାନ୍ ନିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ମାନାଡ଼୍ ବାତେଏ ପୁତ୍‍ତାଡ଼୍‍, ଆଦ୍ କେତିତାଡ଼୍‍, ମେଣ୍ଡେ ବାତେଏ ଉଡ଼ିମାନ୍ତ୍‍ତାଡ଼୍‍, ଆଦିନ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିଦ୍‍ତାଡ଼୍‍, ମେଣ୍ଡେ ମିଡ଼୍ ମାୱାଦ୍ ସାକ୍ଷ୍ୟ ଗ୍ରହନ୍ ମାଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ନାନେ ମିକିଂଙ୍କ୍ ସଂସାର୍ ବିଷୟ୍‍ତେ କେତ୍‍କେ ଯଦି ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍, ଆଲାଇତ୍‍କେ ମିକିଂଙ୍କ୍ ସ୍ୱର୍ଗତ୍‍ ବିଷୟ୍‍ତେ କେତ୍‍କେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ବେନ ନାରୁନ୍‍ପିଲେ ସ୍ୱର୍ଗକଞ୍ଜ୍ ଡିଗିୱାତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନ ସ୍ୱର୍ଗତାଗ୍ ଆନଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ମୋଶାଲ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଉସ୍କ ନେଲ୍‍ଦାଗ୍ ବାବାଲ୍ ତାଡ଼ାତିଙ୍କ୍ ଗୁଞ୍ଜେତ୍ ପର୍‍ର ତେୟ୍‍ସ୍‍ ମାତ୍‍ତଣ୍ଡ୍, ନାରୁନ୍‍ପିଲେ ଆନ୍‌‍ତେ ଆଦ୍‌ ରକମ୍ ପର୍‍ର ତେଦିତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ବେଦ୍‍ପୁଟୁଙ୍କ୍ ବେନଆଇ ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ ଦର୍ସିକିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଜଗତ୍‍ତିଙ୍କ୍ ଇସର୍ ପ୍ରେମ ମାଡ଼୍‍ତଣ୍ଡ୍ ଯେ, ଅଣ୍ଡ୍‌ ନିଜେତ୍ ଅଦ୍ୱିତିୟ ମାର୍‍ଦିଙ୍କ୍ ଦାନ ହିତ୍‍ତଣ୍ଡ୍, ବେଦ୍‍ପୁଟୁଙ୍କ୍ ବେନଆଇ ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବିନଷ୍ଟ ଆୟ୍‍ୟକଟ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଦର୍ସିକିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ଇଶ୍ୱର୍ ତାନ୍ ମାର୍‍ଦିଙ୍କ୍ ଜଗତ୍‍ତାଗ୍ ବିଚାର୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ରୱଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ଜଗତ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଅନ୍‌‍ତଡ଼୍ ପରିତ୍ରାଣ୍ ଦର୍‍କିତ୍‍ତେ, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ରହ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ବେନ ମାରିନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବିଚାରିତ ଆୟ୍‍ୟଣ୍ଡ୍; ବେନ ବିଶ୍ୱାସ୍ ମାଡ଼ଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବିଚାରିତ ଆଶେ ତେର୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ଅଦ୍ୱିତିୟ ମାର୍‍ଦେ ପେଦେର୍ ତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ମେଣ୍ଡେ, ଆଦ୍ ବିଚାର୍ ଇଦ୍, ଜଗତ୍‍ତାଗ୍ ୱେସ୍ ତିଆର୍ ଆସ୍‍ମିନ୍ଦେ, ମେଣ୍ଡେ ନାରୁଡ଼୍ ପ୍ରେମ ତାଦ୍‌ ସାୟେ ୱେସ୍ ୱିଡ଼୍‍ସି ହିକାଡ଼୍‍ତିଙ୍କ୍ ପସନ୍ଦ୍ ମାଡ଼୍‍ତଡ଼୍, ଆଦିଙ୍କ୍ ଅଡ଼୍‌‍ୱାଦ୍‍ ପାଡ଼ିୟି ସାରେ କାରାପ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନଆଇ କାରାପ୍ ପାଡ଼ିୟି ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ୱେସ୍‍ତିଙ୍କ୍‍ ପାସ୍‍କିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ବେସୁଙ୍କ୍‍ଆଇ ଅନ୍‌‍ୱାଦ୍ ପାଡ଼୍‌ୟିଦେ ଦଷ୍ ତନ୍ଦିତେ, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ୱେସିନ୍‍ ଗାର୍‍ରେ ୱାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନଆଇ ନିଜାମ୍‍ ପାଡ଼୍‍ୟି ମାଡ଼ିତନ୍, ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଅନ୍‌‍ୱାଦ୍ ପାଡ଼ିୟି ସାରେ ଇଶ୍ୱର୍‌ତାଦ୍, ଇଶ୍ୱର୍‌ତେ ଇଚ୍ଛା ଲେକାମ୍‍ତେ ମାଡ଼୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ତନ୍ଦିତେ, ଅଣ୍ଡ୍‌ ୱେୟ୍‍ସିନ୍ ଗାର୍‍ରେ ୱାଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ଆସୁଟେ ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଯିହୁଦା ପ୍ରଦେଶ୍‍ତାଗ୍ ଆଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ଅଡ଼୍‌ ତ ମାଞ୍ଜ୍ ବାପ୍ତିସ୍ମ ହିଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଯୋହନ୍‌ ଆନ୍‌‍ତେ ଶାଲମତ୍ ଗାର୍‍ରେ ଏନୋନ୍‍ତାଗ୍ ବାପ୍ତିସ୍ମ ହିସମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଗେ ଗାଟି ଏର୍‍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ନାରୁଡ଼୍ ୱାସ୍ ବାପ୍ତିସ୍ମ ହସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ଆସୁଙ୍କ୍ ହେଉନା ଯୋହନ୍‌ ଜେଲ୍‌ତାଗ୍ ଆନ୍‌‍ୱେକଟ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ଆଗାକଞ୍ଜ୍ ଶୁଚି ପାଡ଼୍‍ୟି ବିଷୟ୍‍ତେ ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟଡ଼୍ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ଯିହୁଦୀନ୍‍ ତୋ ତିର୍‍ୟାତିର୍‍ୟି ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ମେଣ୍ଡେ, ଯୋହନ୍‌‌ତେ ଶିଷ୍ୟଡ଼୍ ଯୋହନ୍‌‌ତେ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ହୋ ଗୁରୁ, ବେନ ଯର୍ଦ୍ଦନ୍ ବେଡ଼େମ୍‍ତେ ମୁନେତ୍ ପାକ୍ ନିତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ବେନ ବିଷୟ୍‍ତେ ନିମ୍‍ ସାକ୍ଷ୍ୟ ଇସ୍‌‍ମିନ୍ଦେନି, ଉଡ଼େ, ଅଣ୍ଡ୍‌ ବାପ୍ତିସ୍ମ ଇଦୁତଣ୍ଡ୍ ନୁ ସାରେତଡ଼୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାଦୁତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଯୋହନ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ହିୱକଟ୍ ମାତ୍‍କେ ନାରୁଡ଼୍ ବାତେଏ ପାଏମ୍ ଆଦାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ନାନ୍ ଯେ ମସିହ ଆୟନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅନ୍‌ ମୁନେଙ୍କ୍ ପ୍ରେରିତ୍ ଆସ୍‍ମିନ୍ଦେନ୍, ହିଦ୍ ନାନ୍ କେସ୍‍ମାତ୍‍ତାନ୍ ଇଞ୍ଜ ମିଡ଼୍ ନିଜେ ନିଜେ ନା ସାକ୍ଷି । ");
INSERT INTO kff_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ବେନ ମୁତେଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବର, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବରତ୍‍ ବେନ୍ ସାଙ୍ଗ ଗାର୍‍ରେ ନିସ୍ ଅନ୍‌ ଗଟି କେଞ୍ଜିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବରତ୍‍ ଲେଙ୍ଗ୍‍ଦେ ସେଙ୍ଗେ ଗାଟି ସାର୍‍ଦେ ଆଦ୍‍ତନ୍ । ହିଦ୍‍ରକମ୍ ନାୟାଦ୍ ସାର୍‍ଦେ ସାରେ ଆସ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ଅଂକିଙ୍କ୍‌ ନିଜାମ୍ ନାର୍ଗେ ଆଦ୍ ୱେୟ୍‍ତିତ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାକିଂଙ୍କ୍ ସୁଦୁର୍ ଆଦ୍ ୱେୟ୍‍ତିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ବେନ ପର୍‍ରକଞ୍ଚ୍ ୱାଦାନାଦ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ସାରେତଡ଼୍ ଆଗାଙ୍କ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍; ବେନ ପୃତିବି ତାଗାଙ୍କ୍ ତିଆର୍‍ଆତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ପୃତିବିତଣ୍ଡ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ପୃତିବିତେ ଗଟି କେତିତଣ୍ଡ୍; ବେନ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ୱାଦାନାଦ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ଅଣ୍ଡ୍‌ ବାତେଏ ଉଡ଼ିମିନ୍ଦେଣ୍ଡ୍ ନୁ କେଞ୍ଜିମିନ୍ଦେଣ୍ଡ୍ ଆଦ୍ ବିଷୟ୍‍ତେ ଅଣ୍ଡ୍‌ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅନ୍‌‍ୱାଦ୍ ସାକ୍ଷ୍ୟ ବେନ ଗ୍ରହନ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ବେନ ଅନ୍‌‍ୱାଦ୍ ସାକ୍ଷ୍ୟ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଯେ ସତ୍ୟତାଦ୍ ପୁଟୁଙ୍କ୍ ଇଞ୍ଜ ସ୍ୱୀକାର୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ବେନଙ୍କ୍ ରୟ୍‍ସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ କେତିତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ପୁରାପୁରି ଲେକାମ୍ ଆତ୍ମାତିଙ୍କ୍ ବେଡ଼୍‍ୟାଦ୍‍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ବାବାଲ୍ ମାର୍‍ଦିଙ୍କ୍ ପ୍ରେମ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ସାରେ ବିଷୟ ଅନ୍‌ କାଇଦାଗ୍ ଅର୍ପଣ ମାଡ଼ିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ବେନ ମାର୍‍ଦିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଦର୍ସିକି ଆସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ମାତର୍ ବେନ ମାର୍‍ଦିଙ୍କ୍ ଉର୍‍ଗାଡ଼୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଜିୱୁନ୍‍ତିଙ୍କ୍ ଉଡ଼୍‍ଅଣ୍ଡ୍‌, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ କପାମ୍ ନାରୁଡ଼୍ ଆଶ୍ ମାନ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ପାରୂଶୀଡ଼୍ କେଞ୍ଜ୍‍ତଡ଼୍ ଯେ ଜିସୁ ବାପ୍ତିସ୍ମ ଯୋହନ୍‌‌ତେ କନ୍‍ସ୍ ନାର୍‍ଗେ ଶିଷ୍ୟ ମାଡ଼ୁତଣ୍ଡ୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାପ୍ତିସ୍ମ ଇଦୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ପ୍ରକୃତ୍‍ରେ ଜିସୁ ନିଜେ ବେନଙ୍କ୍‍ବା ବାପ୍ତିସ୍ମ ହିୱକଟ୍ ମାତ୍‍ତଣ୍ଡ୍, ମାତର୍ ଆଦ୍ ତାମ୍ ଶିଷ୍ୟଡ଼୍ ହିସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ହିଦ୍ ପାରୂଶୀଡ଼୍ କେତୁତଡ଼୍ ଇଞ୍ଜ ଜିସୁ ବେସୁଟ୍‌ କେଞ୍ଜ୍‍ତଣ୍ଡ୍, ଆସୁଟେ ଅଣ୍ଡ୍‌ ଯିହୁଦା ପ୍ରଦେଶ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଗାଲିଲୀତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ଆଦାନ୍ ହାର୍‍ଦାଗ୍ ଶମିରୋଣ ଲୋପେଙ୍କ୍ ଇସ୍‌ ଅଂକିଙ୍କ୍‌ ଆଦ୍‍ୱେୟ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ଆଦିଙ୍କ୍ ଜିସୁ ଆଞ୍ଜ୍ ଯାକୁବ୍ ନିଜେତ୍ ମାର୍‍ ଯଷେପ୍‍ତିଙ୍କ୍ ବେନ୍ ୱାୟାଙ୍କ୍ ତୁସି ମାତ୍‍ତଡ଼୍, ଆଦିନ୍ ଗାର୍‍ରେ ଶମିରଣତେ ସୁକାର୍‍ ପେଦେର୍‍ତେ ୱେରଡ଼୍ ନାର୍‍ଦାଗ୍ ହେୱ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ଯାକୁବନ୍ ନୂୟ୍ ମାତ୍‍ତେ । ଜିସୁ ଆୟ୍‍ୱି ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଆଦ୍ ନୂୟ୍‍ଦ୍‍ ଗାର୍‍ରେ କୁଦିମାତ୍‍ତଣ୍ଡ୍ । ଆସୁଟେ ପାୟାଲ୍ ଆସ୍‍ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଅଣ୍ଡୟ୍‌ ଶମିରୋଣୀୟ ମୁତ୍‍ତେ ଏର୍‍ ତରାନ୍‍ ମାଇଦିଙ୍କ୍ ୱାତ୍‍ତେ । ଜିସୁ ତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାକିଂଙ୍କ୍ ଉନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଏର୍‍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ଆସୁଟେ ତାନ୍ ଶିଷ୍ୟଡ଼୍ କାଦି ଆସାନ୍ ମାଇଦିଙ୍କ୍ ନାର୍‍ଦାଗ୍ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ଆସୁଟେ ଶମିରୋଣୀୟ ମୁତ୍‍ତେ ଜିସୁଙ୍କ୍ କେତ୍‍ତେ, “ନିମ୍‍ ୱେରନ୍ ଯିହୁଦିନି ମେଣ୍ଡେ ନାନ୍ ୱେରନ୍ ଶମିରୋଣୀୟ ମୁତେନ୍‍, ବେଲା ନା କାୟ୍‍ଦେ ଉନ୍ଦାଙ୍କ୍ ତାଲ୍‍କୁତିନ୍‍ ?” ବାତେଙ୍କ୍ ଇତ୍‍କେ ଶମିରୋଣୀୟଡ଼୍ ତଡ଼୍ ଯିହୁଦୀ ନାରୁଡ଼ାଦ୍ ବ୍ୟବହାର୍ ଇଲା । ");
INSERT INTO kff_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜିସୁ ତାଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଇଶ୍ୱର୍ ବାତେଏ ହିଦ୍‍ପାର୍‍ତଣ୍ଡ୍ ନିମ୍‍ ଯଦି ପୁଞ୍ଜ୍ ମାନେନି ମେଣ୍ଡେ ବେନ ନି କାଇଦେ କନ୍‍ସ୍ ଉନ୍ଦାନଙ୍କ୍ ତାଲ୍‍କୁତଣ୍ଡ୍ ଆଦ୍ ଯଦି ପୁଞ୍ଜ୍ ମାନେନି ନିମ୍‍ ଅଂକିଙ୍କ୍‌ ତାଲ୍‍କେନି, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ନିକିଂଙ୍କ୍ ଜିୱୁନ୍‍ତେ ଏର୍‍ ହିୱେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ଆଦ୍ ମୁତ୍‍ତେ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ଗୁରୁ, ଏର୍‍ ତରାନ୍‍ ମାଇଦିଙ୍କ୍ ନି ଗାର୍‍ରେ ବାତେଏ ଜିନିଷ୍ ଇଲା, ମେଣ୍ଡେ ନୂୟ୍ ତ କୁୟ୍‍ଙ୍ଗ୍; ଆଲାଇତ୍‍କେ ନିମ୍‍ ବେଗାକନ୍‍ସ୍ ଆଦ୍ ଜିୱୁନ୍‍ ଏର୍‍ ଦର୍ସିକି ଆସ୍‌ମିନ୍ଦେନୀ ? ");
INSERT INTO kff_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ମା ଆନିଦାଦି ଯାକୁବ୍ ହି ନୂୟ୍ ମାକିଂଙ୍କ୍ ଇସ୍‌‍ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ନିଜେ, ମେଣ୍ଡେ ତାନ୍ ମାର୍‍କ୍ ନୁ ଜିୱାକିନ୍‍ ଲନ୍ ହିଗାଙ୍କ୍ ହୁଞ୍ଜ ମାତ୍‍ତା, ଅନ୍‌ ଆଗାଙ୍କ୍ କି ନିମ୍‍ ବେଡ଼୍‍ୟନି ?” ");
INSERT INTO kff_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜିସୁ ତାଙ୍କ୍ ଉତ୍ତର୍ ହିତତଣ୍ଡ୍, “ବେନ୍‌ଆଇ ହି ଏର୍‍ ଉନ୍‍ତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡନ୍ ଦାମ୍ ଉନ୍ଦ୍ ୱାହାତିତ୍‍; ");
INSERT INTO kff_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ବେନ୍ ଏର୍‍ ହିଦ୍‍ତାନ୍, ଆଦ୍ ବେନମେଣ୍ଡେ ଉନ୍‍ତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ବେସୁଙ୍କ୍‍ମେଣ୍ଡେ ଉନ୍ଦେୱାୱ, ବେଲାନ୍ ନାନ୍ ହିସମାନ୍ଦାନ୍ ଏର୍‍ ଅନ୍‌ ହୃଦୟ୍‍ତାଗ୍ ୱେରନ୍ ଜିୱୁନ୍ ହିଦାନଣ୍ଡ୍ ନିର୍ଜତେ ପରିନତ ଆଦ୍‍ତେ, ଆଗାଙ୍କ୍ ଉତ୍‍କେ ଅଣ୍ଡ୍‌ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ ଜିୱେଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ନାଟାଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ଗୁରୁ, ନାକିଂଙ୍କ୍ ଆଦ୍ ଏର୍‍ ହିମ୍, ମେଣ୍ଡେ ବେସୁଙ୍କ୍‌ବା ଉନ୍ଦେୱାୱ, ଇସ ଜେକେ ୱାଦାଙ୍କ୍ ମେଣ୍ଡେ ଦର୍‍କାର୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ଜିସୁ ତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଅନ୍‌, ନି ମୁଦ୍‍ପାଙ୍କ୍ କାର୍‍ଙ୍ଗି ଇଗେ ତାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ନାଟାଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତେ, ନା ମୁଦ୍‍ପାଲ୍‍ ଇଲେଣ୍ଡ୍ । ଜିସୁ ତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନା ମୁଦ୍‍ପାଲ୍‍ ଇଲେଣ୍ଡ୍ ଇଞ୍ଜ କେତାନାଦ୍ ଟିକ୍ କେତ୍‍ତିନ୍; ");
INSERT INTO kff_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିକିଂଙ୍କ୍ ଏୟ୍‍ୱୁଡ଼୍‍ ମୁଦ୍‍ପାଲଡ଼୍‍ ମାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଇଞ୍ଜେ ନିମ୍‍ ବେନନ୍‌ ତଡ଼୍ ମିନ୍ଦେନି, ଅଣ୍ଡ୍‌ ନି ମୁଦ୍‍ପାଲ୍‍ ଆୟ୍‍ୟଣ୍ଡ୍; ଇଦ୍ ସତ୍ କେସ୍‍ମିନ୍ଦେନି ।” ");
INSERT INTO kff_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ନାଟାଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ଗୁରୁ, ନିମ୍‍ ଯେ ୱେରେତନି ବାବବାଦୀ, ଇଦ୍ ନାନ୍ ଉଡ଼ୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ମା ଆନିଦାଦିଡ଼୍ ହି ମେଟେତାଗ୍ ଉପବାସ୍ ମାଡ଼୍‍ତଡ଼୍; ମେଣ୍ଡେ, ମିଡ଼୍ ଯିହୁଦିଡ଼୍ କେସମିନ୍ଦେଡ଼ି, ବେନ୍ ପଡ଼୍‍ୟ୍‍ତାଗ୍ ଉପବାସ୍ ମାଡ଼ାନାଦ୍ ଲେକାମ୍, ଆଦ୍ ଜିରୂଶାଲାମ୍‍ତାଗ୍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜିସୁ ତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଆଗୋ ନାଟାଡ଼୍‍ତନୀ, ନା ଗଟ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ା, ଇଦ୍‍ରକମ୍ ଦିନାମ୍ ୱାଦୁତେ, ବେନ୍ ସମୟ୍‍ତେ ମିଡ଼୍ ହି ମେଟେତାଗ୍ ବା ଯିରୁଶାଲେମ୍ ତାଗ୍ ବାବାନାଦ୍ ଉପବାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ମିଡ଼୍ ଶମିରନିୟଡ଼ି ପ୍ରକୃତ୍‍ତେ ବେନଙ୍କ୍ ପୁନ୍‍ୱିଡ଼୍, ଅନାଦ୍‌ ଉପବାସ୍ ମାଡ଼ିତିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାମ୍‍ମେ ଯିହୂଦୀମ୍ ବେନଙ୍କ୍ ପୁତ୍‍ତମ୍, ଅଂକିଙ୍କ୍‌ ଉପବାସ୍ ମାଡ଼ିତମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ପରିତ୍ରାଣ୍ ଯିହୂଦିଡ଼ାଗାଙ୍କ୍ ୱାଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ୍ ସମୟ୍‍ତେ ସତ୍ ଉପବାସ୍ ମାଡ଼ାନଡ଼ି ଆତ୍ମାତେ ନୁ ସତ୍ୟତେ ବାବାନାଦ୍ ଉପବାସ୍ ମାଡ଼ିତଡ଼୍, ଆସତ୍‍ ଦିନାମ୍ ୱାସମିନ୍ଦେ; ମେଣ୍ଡେ ଇଞ୍ଜେକ୍ ମିକା ମିନ୍ଦେ; ବାତେଙ୍କ୍‍ଇତ୍କେ ବାବାଲ୍ ହିସତ୍ ଉପବାସ୍ ଇଚ୍ଛାମାଡ଼ୁତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ଇଶ୍ୱର୍ ୱେରନ୍ ଆତ୍ମା, ମେଣ୍ଡେ ବେନଡ଼୍ ଅନ୍‌‍ଆଦ୍‍ ଉପବାସ୍ ମାଡ଼ିତଡ଼୍, ଆତ୍ମାତେ ନୁ ସତ୍ୟତେ ଉପବାସ୍ ମାଡ଼ାନାଦ୍ ଅଡ଼୍‌କିଂଙ୍କ୍‍ ଦର୍‌କାର୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ନାଟାଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ମସିହ, ବେନଙ୍କ୍ କ୍ରିଷ୍ଟ କେତିତଡ଼୍‍, ଅଣ୍ଡ୍‌ ୱାସମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ ନାନ୍ ପୁତ୍‍ତାନ୍; ବେସୁଙ୍କ୍‍ ଅଣ୍ଡ୍‌ ୱାଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମାନ୍‍ ସାରେ ବିଷୟ୍‍ତିଙ୍କ୍ କେତିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜିସୁ ତାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନି ତଡ଼୍ ତିର୍‍ୟୁତାନ୍ ଯେ ନାନ୍, ଅଣ୍ଡେ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ଆଦ୍ ସମୟ୍‍ତେ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ୱାସ୍ ଅଂକିଙ୍କ୍‌ ୱେରଡ଼୍ ନାଟାଡ଼୍ ତ ତିର୍‍ୟ ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ବାକ୍‍ୱା ଆଦ୍‍ତଡ଼୍, “ମିକା ନିମ୍‍ ବାତେଏ ଇଚ୍ଛାମାଡ଼ୁତିନ୍‌, ବା ବାତେଙ୍କ୍ ତାନ୍ ତଡ଼୍ ଗଟି କେସମିନ୍ଦେନି, ହିଦ୍ ବେନମେଣ୍ଡେ ପାଚ୍ରାମାଡ଼ାଙ୍କ୍ ସାହାସ୍ ମାଡ଼ଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ଆସୁଟେ ଆଦ୍ ନାଟାଡ଼୍ ତାନାଦ୍ ଏର୍‍ କୁଣ୍ଡ୍ ନେଲ୍ ୱାଟି ନାର୍‍ଦାଗ୍ ଆଞ୍ଜ୍ ନାରୁଡ୍‍କ୍‍ କେତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ୱାଡ଼ାଟ୍, ଅର୍‍ତୁଙ୍କ୍ ଉଡ଼ିତିଡ଼୍, “ନାନ୍ ବାତା ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ହାଉସାରେ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ଉମ୍ଭ ମସିହ ଆଦ୍‍ତନ୍ ୱେୟ୍‍ୟ ?” ");
INSERT INTO kff_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ଆସୁଟେ ନାରୁଡ଼୍ ନାର୍‍ତାଗାଙ୍କ୍ ପେୟିସ୍ ଅନ୍‌‍ଗାରେ ଆଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ଆଗାକଞ୍ଜ୍ ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌ ମାଡ଼ି କେତ୍‍ତଡ଼୍, ହୋ ଗୁରୁ, ସୁଦୁଟ୍ ତିନ୍ଦାନଙ୍କ୍ ୱାଡ଼ା । ");
INSERT INTO kff_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ତିନ୍ଦାନଙ୍କ୍ ବେନ୍ କାଦି ନାୟାଗ୍ ମିନ୍ଦେ ତାନ୍ ବିଷୟ୍‍ତେ ମିଡ଼୍ ବାତେମିକା ପୁନ୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ଆସୁଟେ ଶିଷ୍ୟଡ଼୍ ନିଜେ ନିଜେ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ବେନ ଅଂକିଙ୍କ୍‌ କାଦି ତାସିସ୍‍ ମିନ୍ଦେଡ଼୍‍ ବାନେ ?” ");
INSERT INTO kff_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନା ପ୍ରେରଣାକର୍ତ୍ତାନ୍ ଇଚ୍ଛା ପାଲନ୍ ମାଡ଼ାନାଦ୍ ନୁ ଅନ୍‌ ତଡ଼୍ ଇସ୍‌ ମାନ୍ଦାନ୍ ପାଡ଼ିୟି ତେର୍‍ସ୍ପାନାଦ୍‍ ଇଦ୍‍ଏକେ ନାୟାଦ୍ କାଦି । ");
INSERT INTO kff_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ମିଡ଼୍ କେତୁତିଡ଼୍ କେଡ଼୍ କୟ୍‍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ମଣ୍ଡେ ନାଲୁ ନେଲ୍‍ଞ୍ଜ୍‍ ମିନ୍ଦେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ କେଡ଼୍ ୱାୟାଙ୍କ୍ ଉଡ଼ାଟ୍, ଆୱ୍ ସାରେ କଇଦାନଙ୍କ୍ ଆସ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ଇଞ୍ଜ୍ ଆନ୍‌‍ତେ କୟ୍‍ତେନଣ୍ଡ୍ ମଜୁରି ଦର୍‍କିତ୍‍ତା ନୁ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ତେ ମାଇଦିଙ୍କ୍ କାୟା ଗୁଡ଼୍‍ପି ମାଡ଼ମିନ୍ଦେନ୍, ବେଦ୍‍ପୁଟୁଙ୍କ୍ ୱିତାନଣ୍ଡ୍ ନୁ କୟ୍‍ଦାନଣ୍ଡ୍ ହିର୍‍ୱୁଡ଼୍‍ କାୟ୍‍ଲି ୱେଡ଼୍‍କା ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ବାତେଙ୍କ୍ ଇତ୍‍କେ ୱେରଣ୍ଡ୍ ୱିତିତଣ୍ଡ୍ ନୁ ମେଣ୍ଡେଆର୍‍ତୁଣ୍ଡ୍ କୟ୍‍ଦ୍‍ତଣ୍ଡ୍, ହିଦ୍ ଗଟ୍ ସତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ମିଡ଼୍ ବାତେତ୍‍ ମାଇଦିଙ୍କ୍ କଷ୍ଟ ମାଡ଼୍‍ୱିଡ଼୍, ଆୱ୍ କୟ୍‍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ରହ୍‍ତାନ୍; ମେଣ୍ଡେ ବାଗାତଡ଼୍ ତିପାଲ୍ ମାଡ଼ିମିନ୍ଦେଡ଼୍, ମେଣ୍ଡେ ମିଡ଼୍ ଅଡ଼୍‌‍ୱାଦ୍‍ ତିପାଲ୍‍ତେ କାୟା ଦର୍ସକୁତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“ନାନ୍ ବାତା ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ହାଉସାରେ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଇଞ୍ଜ ବେନ୍ ନାଟାଡ଼୍ ସାକ୍ଷ୍ୟ ଇସ୍‌‍ମାତେ, ତାନାଦ୍ ଗଟ୍‍ତେ ମାଇଦିଙ୍କ୍ ଆଦ୍ ନଗର୍‍ ଶମିରୋଣୀୟ ଡ଼ାଗାଙ୍କ୍ ଲୋପେଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ଆଦ୍ ଶମିରୋଣିୟଡ଼୍ ଆନ୍‌‍ତେ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍ ଅଡ଼୍‌ ତ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍ । ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ରେଣ୍ଡ୍ ଦିନା ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ମେଣ୍ଡେ, ଜିସୁନ୍ ଗଟ୍ କେଞ୍ଜି ମେଣ୍ଡେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ମେଣ୍ଡେ, ଅଡ଼୍‌ ଆଦ୍ ନାଟାଡ଼୍‍ତିଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ଇଞ୍ଜେ ନି ଗଟ୍‍ତେ ସେଙ୍ଗେ ମାତର୍ ମାମ୍‍ମେ ବିଶ୍ୱାସ୍ ମାଡ଼ମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାମ୍‍ମେ ନିଜେ ନିଜେ କେଞ୍ଜିମିନ୍ଦେମ୍, ମେଣ୍ଡେ ଇଣ୍ଡ୍ ଯେ ନିଜାମ୍ ଜଗତ୍‍ତେ ତ୍ରାଣକର୍ତ୍ତାଲ୍, ହିଦ୍ ମାମ୍‍ମେ ପୁଞ୍ଜ୍‍ମିନ୍ଦେମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ରେଣ୍ଡ୍‍ଦିନାତେ ପେର୍‍କେ ଜିସୁ ଆଗାଙ୍କ୍ ପେୟିସ୍ ଗାଲିଲୀତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବବାଦୀ ସ୍ୱଦେଶ୍‍ତେ ଆଦର୍‍ ଦର୍‍କିତ୍‍ତେ ଆୟ୍‍ୟଡ଼୍ ଇଞ୍ଜ୍ ଜିସୁ ନିଜେ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଗାଲିଲୀତାଗ୍ ୱାତ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ, ପାଣ୍ଡୁମ୍ ଦିନାମ୍ ତେ ଅଣ୍ଡ୍‌ ଯିରୁଶାଲେମ୍‌‍ତାଗ୍ ବାତା ମାଡ଼ି ମାତ୍‍ତଣ୍ଡ୍, ହାଉସାରେ ଉଡ଼ିମାନ୍ଦାନ୍ ଗାଲିଲୀୟଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍, ବେଲାକି ଅଡ଼୍‌‍ ଆନ୍‌‍ତେ ପାଣ୍ଡୁମ୍‍ତାଗ୍ ଆଞ୍ଜ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ଇଗାକଞ୍ଜ୍ ଗାଲିଲୀତାଗ୍ ବେନ୍ କାନାଲ୍‌ ନାର୍‍ଦାଗ୍ ଜିସୁ ଏର୍‍ଦିଙ୍କ୍ ଦ୍ରାକ୍ଷାରସ୍ ମାଡ଼ି ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ଅଣ୍ଡ୍‌ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଆଦ୍‍ତନ୍ । ମେଣ୍ଡେ ଆଗେ ୱେରଣ୍ଡ୍ ରାଜକର୍ମଚାରୀ ମାତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ମାର୍‍ କଫର୍ନାହୁମ୍‍ତାଗ୍‍ ପିଡ଼ିତ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଜିସୁ ଯିହୁଦା ପ୍ରଦେଶ୍‍ତାଗାଙ୍କ୍ ଗାଲିଲୀତାଗ୍ ପେୟିସ୍ ୱାସ୍ ମିନ୍ଦେଣ୍ଡ୍, ଇଦ୍ କେଞ୍ଜି ଅଣ୍ଡ୍‌ ଅନ୍‌ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଅଣ୍ଡ୍‌ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଆଞ୍ଜ୍ ତାନ୍ ମାର୍‍ଦିଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ିଦ୍‍ତଣ୍ଡ୍, ଆଦିନ୍‌ମାଇଦିଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଅନୁରଦ୍‌ ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଡଲାନ୍ ରକମ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ଆସୁଟେ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଚିହ୍ନେ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ହୁଡ଼କଟମାତ୍କେ ମିଡ଼୍ ବେସୁଟ୍‌ ବା ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ରାଜାନ୍‍ଦାସ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଗୁରୁ, ନା ମାର୍‍ ଡଲାନ୍ ମୁନେଙ୍କ୍ ୱାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଅନ୍‌ ନି ମାର୍‍ ଗେଲ୍‍ସି ଆତ୍‍ତଣ୍ଡ୍ । ଆଦ୍ ନାରୁନ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତେ ଗଟ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ି ମାଲ୍‍ସ୍ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଆଞ୍ଜ ଆଞ୍ଜ ଅନ୍‌ ଦାସଡ଼୍ ଅଂକିଙ୍କ୍‌ କାୟ୍‍ଲି ନି ମାର୍‍ ଗେଲ୍‍ସି ଆତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ଆଦିଙ୍କ୍ ବେନ୍ ସମୟ୍‍ତେ ଅଣ୍ଡ୍‌ ସୁସ୍ଥ ଆତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍ । ଆସୁଟେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ନିନେ ପାୟାଲ୍ ଗାଣ୍ଟେ ସମୟ୍‍ତେ ଅଂକିଙ୍କ୍‌ ହେଡ଼୍‍କ୍ ୱିଡ଼୍‍ସ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଆସୁଟେ ବାବାଲ୍ ବୁଜେମ୍ ଆତ୍‍ତଣ୍ଡ୍ ଯେ, “ଜିସୁ ବେନ୍ ସମୟ୍‍ତେ ନିମାର୍‍ ଗେଲ୍‍ସ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଅଂକିଙ୍କ୍‌ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଟିକ୍ ଆଦ୍ ସମୟ୍‍ତେକେ ହିଦ୍ ଗଟେମ୍‍ଆସ୍‍ ମାତ୍‍ତେ । ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ନିଜେ ନୁ ତାନ୍ ପରିବାର୍‍ତେ ସାର୍‍ତଡ଼୍ ଜିସୁଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଯିହୁଦାତାଗାଙ୍କ୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଗାଲିଲୀତାଗ୍ ୱାତ୍‍ତେ ପେର୍‍କେ ହିଦ୍ ଜିସୁନ୍ ଦ୍ୱିତୀୟ ବାକ୍‌ୱାକାମ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ତାନ୍‍ପେର୍କେ ଯିହୂଦୀଡ଼ାଦ୍‍ ୱେରଡ଼୍ ପାଣ୍ଡୁମ୍ ଦିନ୍ ଆତ୍‍ତେ, ମେଣ୍ଡେ ଜିସୁ ଯିରୁଶାଲେମ୍‌‍ତା ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଯିରୁଶାଲେମ୍‍ତେ ମେଣ୍ଢାନ୍ ଆର୍‍ଦେ ଗାର୍‍ରେ ୱେରଡ଼୍ ହେର୍‍ୱ୍‍ ମିନ୍ଦେ; ଏବ୍ରି ଗଟ୍‍ତେ ତାଆକିଂଙ୍କ୍‍ ବେତେସ୍‍ଦା ଇଞ୍ଜ କେତିତଡ଼୍‍, ତାନାଦ୍ ଏଇଙ୍ଗ୍ ମଣ୍ଡପ୍‍ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ଗୁଡ଼୍‍ସାତେ ପର୍‍ର ନାର୍ଗେ ନାର୍ଗେ ରଗିନାରୁଡ଼୍‍, କାନାଲଡ଼୍, କୁଟାଲଡ଼୍ ନୁ ଶୁଷ୍କାଙ୍ଗ ନାରୁଡ଼୍ ଆଗେ ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଏର୍‍ ଉଙ୍ଗାନାଦିନ୍‍ କେପି ମାତ୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ୍ ସମୟ୍‍ତେ ପ୍ରବୁନାଦ୍ ୱେରଡ଼୍ ଦୂତ୍ ଏର୍‍ୱିନାଗ୍ ଡିଗି ଏର୍‍ଦିଙ୍କ୍ ହୁୟ୍‍ସ ମାତ୍‍ତେ, ମେଣ୍ଡେ ଏର୍‍ ଉଙ୍ଗାନ୍‍ ପେର୍‍କେ ବେନଆଇ ମୁନେଙ୍କ୍ ଆଦିନାଗେ ମୁଡ଼୍‍ନ୍ଦ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବେନେମେଣ୍ଡେ ରଗ୍‍ତେ ଆସ୍ ମାତ୍‍କେ ବାଡ଼େ ସୁସ୍ଥ ଆସ୍‍ସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ଆଗେ ଅଟ୍‍ତିରିଶ୍‍ ହେଣ୍ଡ୍‍ ରୋଗତେ ପିଡ଼ିତ୍ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‌ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଜିସୁ ଅଂକିଙ୍କ୍‌ ପାଟି ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ନାର୍‍ଗେ ହେଣ୍ଡେତ୍ ରୋଗି ଇଞ୍ଜ ପୁଞ୍ଜ୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତେଏ ସୁସ୍ଥ ଆଦାଙ୍କ୍ ଇଚ୍ଛା ଅଦୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ରଗି ନାରୁଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ପାୟ୍‍କା ଏର୍‍ ଉଙ୍ଗାନ୍‍ ୱେୟ୍ ନାକିଂଙ୍କ୍ ଏର୍‍ୱିନ୍‍ ଲୋପେ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ନାକିଂଙ୍କ୍ ବେନ ହିଲ୍‍ଲେଡ଼୍; ମେଣ୍ଡେ, ନାନ୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ନା ମୁନ୍‍ଆଞ୍ଜ୍ ନେଙ୍ଗି ଆଦୁତଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ତେଦ୍‍ଦେ, ନିୟାଦ୍ କେତ୍ ପୟ୍‍ସ୍ ତାକା ।” ");
INSERT INTO kff_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ଆସୁଙ୍କେ ଆ ନାରୁଣ୍ଡ୍‌ ସୁସ୍ଥ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ନିଜେତ୍ କେତ୍ ପୟ୍‍ସ୍ ତାକାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ଆଦ୍ ଦିନ୍ ବିଶ୍ରାମ୍‍ଦିନେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଯିହୂଦିଡ଼୍ ସୁସ୍ଥ ଆଶେ ମାନ୍ଦାନ୍ ନାରୁଙ୍କ୍ କେତ୍‍ତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ନେଣ୍ଡ୍ ବିଶ୍ରାମ୍‍ଦିନ୍, କେତ୍ କାଞ୍ଜି ଆଦାନାଦ୍ ନିୟାଦ୍ ମା ନିୟମ୍‍ ବିରୁଦ୍‍ତେ ପାଡ଼୍‍ୟି ।” ");
INSERT INTO kff_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ବାତେଙ୍କ୍ ଇତ୍‍କେ, ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ବେନ ନାକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ନି କେତ୍ ପୟ୍‍ସ୍ ତାକା ।” ");
INSERT INTO kff_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ନି କେତ୍ ପୟ୍‍ସ୍ ତାକା ଇଞ୍ଜ ବେନ ନିକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଆ ନାରୁଣ୍ଡ୍‌ ବେନ ?” ");
INSERT INTO kff_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବେନ, ଆଦ୍ ସୁସ୍ଥ ଆଶେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ପୁନକଟ୍ ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍‍ଇତ୍କେ ଆ ପଡ଼ିୟେତାଗ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଜିସୁ ତନ୍ଦକଟ ଆଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ଆଦିନ୍ ପେର୍‍କେ ଜିସୁ ମନ୍ଦିର୍‍ତାଗ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼େ ନିମ୍‍ ସୁସ୍ଥ ଆଶେ ମିନ୍ଦେନି, ମେଣ୍ଡେ ପାପ୍ ମାଡ଼୍‍ମା, ଇଲୁକ୍ ନି ସେଙ୍ଗେ ଗାଟି ଅନିଷ୍ଟ ଗଟେମ୍‍ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ଆ ନାରୁଡ଼୍ ମାଲ୍‍ସ୍ ଆଞ୍ଜ୍, ବେନ ଅଂକିଙ୍କ୍‌ ସୁସ୍ଥ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଜିସୁ ଇଞ୍ଜ ଯିହୁଦୀ ନେତାଲଡ଼୍‍କିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ଆଦିଙ୍କ୍ ଜିସୁ ବିଶ୍ରାମ୍‍ଦିନେତାଗ୍ ଇଲା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଯିହୁଦୀଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ତାଡ଼ନା ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ମାତର୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନା ବାବାଲ୍ ସାରେଦାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ମିନ୍ଦେନ୍, ମେଣ୍ଡେ ନାନ୍ ଆନ୍‌‍ତେ ମାଡ଼ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ହିଦିନ୍ ସେଙ୍ଗେ ଯିହୁଦୀଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଆୱ୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ମେଣ୍ଡେ ଅଦିକ୍‌ ଚେଷ୍ଟା ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଯେ ବିଶ୍ରାମ୍‍ଦିନେତେ ନିୟମ୍ ମାନେମ୍‍ ଆୟ୍‍ୟକଟ ମାତ୍‍ତଣ୍ଡ୍, ମାତର୍ ଆଦ୍ ଆୟ୍‍ୟ, ମାତର୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ନିଜେତ୍ ବାବାଲ୍ ଇଞ୍ଜ କେସ୍ ନିଜ୍‍ତିଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ତଡ଼୍ ସମାନ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନେ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ମାର୍‍ ନିଜେ ବାତେମିକା ମାଡ଼େ ପାର୍‍ୱଣ୍ଡ୍ । ମାର୍‍ ବାବଙ୍କ୍ ବାତେଏ ମାଡ଼ାନାଦ୍ ଉଡ଼ିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆନ୍‌‍ତେ ଆଦେ ମାଡ଼ିତନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍ ବାତେଏ ମାଡ଼ିତନ୍ ମାର୍‍ ଆନ୍‌‍ତେ ଆଦେ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍ ମାର୍‍ଦିଙ୍କ୍ ପ୍ରେମ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ନିଜେ ବାତା ମାଡ଼ିତନ୍, ହାଉସାରେ ଅଂକିଙ୍କ୍‌ ତଅତିତଣ୍ଡ୍, ମେଣ୍ଡେ ମିଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ବାକ୍‍ୱା ଆଦ୍‍ତିଡ଼୍, ଅଦିନ୍‌ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ହିଗାଙ୍କ୍ ମେଣ୍ଡେ ବେଡ଼୍‍ୟା ପାଡ଼ିୟ୍‍ ତତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ବାବାଲ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଡଲି ମାନ୍ଦାନଡ଼୍‍କିଙ୍କ୍ ତେୟ୍‍ସ୍‍ମେଣ୍ଡେ ଜିୱୁ ମାଡ଼ିତନ୍, ଆଦେ ରକମ୍ ମାର୍‍ଆନ୍‌ତେ ବେନ୍ ବେନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିତନ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଜିୱୁ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ମେଣ୍ଡେ, ବାବାଲ୍ ଆନ୍‌‍ତେ ବେନନାଦ୍ ବିଚାର୍ ମାଡ଼ଣ୍ଡ୍, ବିଚାର୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ମାର୍‍ଦିଙ୍କ୍ ସାରେ ଅଦିକାର୍‌ ହିଦ୍‍ତଣ୍ଡ୍, ବେଲା ମାର୍‍ଦିଙ୍କ୍ ସନ୍‍ମାନ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ବେନ ମାର୍‍ଦିଙ୍କ୍ ସମ୍ମାନ୍ ମାଡ଼ଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଅନ୍‌‍ୱାଦ୍ ମାଲ୍‍ସ୍‍ୱାଦାନ୍ ବାବାଙ୍କ୍ ଆନ୍‌‍ତେ ସମ୍ମାନ୍ ମାଡ଼ଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ବେନ ନା ବାକ୍ୟ କେଞ୍ଜି ନା ପ୍ରେରଣାକର୍ତ୍ତାଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ ଦର୍ସିକି ମିନ୍ଦେଣ୍ଡ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ବିଚାରିତ ଆୟ୍‍ୟକଟ ବେଲାନ୍ ଡଲାନାଦିଙ୍କ୍ ମେଣ୍ଡନ୍‍ରକମ୍‌ ଆସ୍‌ ଜିୱୁନ୍‍ତାଗ୍‍ ନେଙ୍ଗି ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ହିସତ୍ ଦିନାମ୍ ୱାସମିନ୍ଦେ, ମେଣ୍ଡେ ଇଞ୍ଜେକ୍ ମିକା ହେୱ୍‍ସ୍‍ ମିନ୍ଦେ, ବେନ୍ ଦିନାମ୍ ତେ ଡଲ୍‍ତେନଡ଼୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ଦେ ଲେଙ୍ଗ୍ କେଞ୍ଜିତଡ଼୍ ନୁ ବେନଡ଼୍ କେଞ୍ଜିତଡ଼୍, ଅଡ଼୍‌ ଜିୱୁନ୍‍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଜିୱୁଣ୍ଡ୍‍ତାଦ୍ ୱେଡ଼୍‍କେ, ଆଦେପୁଟୁଙ୍କ୍ ମାର୍‍ଦିଙ୍କ୍ ଆନ୍‌‍ତେ ଜିୱୁଣ୍ଡ୍‍ତାଦ୍ ୱେଡ଼୍‍କେ ଆତ୍‍ତାଙ୍କ୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ନାରୁନ୍‍ପିଲେ ଆତ୍‍ତାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ବିଚାର୍ ମାଡ଼ାନ୍ ଅଦିକାର୍‌‍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ହିସର୍‍ତେ ଦାଦ୍‍ରେଲ୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦିନାମ୍ ୱାଦୁତେ ବେସୁଟ୍‌ ଡଲ୍‍ତେନଡ଼୍‍ ସାରେତଡ଼୍ ଅନ୍‌‍ୱାଦ୍ ଲେଙ୍ଗ୍ କେଞ୍ଜିତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ମେଣ୍ଡେ ଅଡ଼୍‌ ସମାଦିକନ୍‍ସ୍ ତେଦିତଡ଼୍, ବେନଡ଼୍ ଲେକେତ୍‍ ପାଡ଼୍‍ୟି ମାଡ଼ିମିନ୍ଦେଡ଼୍ ଅଡ଼୍‌ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ତେଦି ଜିୱୁଣ୍ଡ୍ ଆଦ୍‍ତଡ଼୍ । କାରାପ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତେନଡ଼୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ତେଦିତଡ଼୍ ନୁ ଦଣ୍ଡ୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ନାନ୍ ନିଜେ କ୍ଷମତାତାଗାଙ୍କ୍‍ ବାତେଏ ମାଡ଼େପାର୍‍ୱଣ୍ଡ୍; ମାତର୍ ଇଶ୍ୱର୍‌ତେ ଗଟ୍ ଲେକାମ୍‍ତେ ନାନ୍ ବିଚାର୍ ମାଡ଼ିତାନ୍, ମେଣ୍ଡେ ନାୟାଦ୍ ବିଚାର୍ ଟିକ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନିଜ୍‍ତେ ଇଚ୍ଛା ସାଦନ୍ ମାଡ଼ାଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼କଟ୍ ନା ପ୍ରେରଣାକର୍ତ୍ତାନ୍ ଇଚ୍ଛା ସାଦନ୍ ମାଡ଼ାଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ଯଦି ନାନ୍ ନିଜର୍ ବିଷୟ୍‍ତେ ନିଜେ ସାକ୍ଷ୍ୟ ହିଦ୍‍ତାନ୍, ଆଲାଇତ୍‍କେ ନା ସାକ୍ଷ୍ୟ ସତ୍ ପ୍ରମାନିତ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ନା ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ, ନା ବିଷୟ୍‍ତେ ଅନ୍‌‍ୱାଦ୍ ସାକ୍ଷ୍ୟ ସତ୍, ଆଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ମିଡ଼୍ ଯୋହନ୍‌‌ତେ ଗାର୍‍ରେ କବର୍ ଆଦାନ୍ ନାରୁଙ୍କ୍ ରୟ୍‍ସ୍ ମିନ୍ଦେନି ନୁ ଅଣ୍ଡ୍‌ ସତ୍ ପାକେଙ୍କ୍ ସାକ୍ଷ୍ୟ ହିସମିନ୍ଦେଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନାରୁଡ଼ାଗାଙ୍କ୍ ସାକ୍ଷ୍ୟ ଗ୍ରହନ୍ ମାଡ଼ନ୍, ମିକ୍‍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ପରିତ୍ରାଣ୍ ଦର୍‍କିତ୍‍ତେ, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ହିଦ୍ ସାରେ କେସମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଯୋହନ୍‌ ୱେରଣ୍ଡ୍ ନିଡ଼୍‍ତାନାଦ୍ ନୁ ଗାଟି ୱେୟ୍‍ସ୍‍ତେ କୁପି ରକମ୍ ମାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ମିଡ଼୍ ସୁଦୁଟ୍ ସମୟ୍‍ତେ ଅନ୍‌ ୱେୟ୍‍ସିନେ ସାର୍‍ଦେ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯୋହନ୍‌‌ତେ ସାକ୍ଷ୍ୟ ୱିଡ଼୍‍ସି ନାୟାଦ୍ ଇସରେ ସାକ୍ଷ୍ୟ ମିନ୍ଦେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍ ନାକିଂଙ୍କ୍ ବେନ୍ ପାଡ଼ିୟି ତେର୍‍ସ୍‍ପାଙ୍କ୍ ହିସମିନ୍ଦେଣ୍ଡ୍, ବେନ୍‍ସାରେ ପାଡ଼ିୟି ନାନ୍ ମାଡ଼ମିନ୍ଦେନ୍, ବାବାଲ୍ ନାକିଂଙ୍କ୍ ରୟ୍‍ସ୍ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ ହାଉସାରେ ନା ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିସମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ମେଣ୍ଡେ, ବେନ ବାବାଲ୍ ନାକିଂଙ୍କ୍ ରୟ୍‍ସ୍ ମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନା ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ଇସ୍‌‍ମିନ୍ଦେନ୍ । ମିଡ଼୍ ବେସୁଙ୍କ୍‍କେ ବା ଅନ୍‌‍ୱାଦ୍ ଲେଙ୍ଗ୍ କେଞ୍ଜ୍‍ୱିଡ଼୍ ବା ଅନ୍‌‍ୱାଦ୍ ମକମ୍ ଉଡ଼୍‍ୱିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ମେଣ୍ଡେ ଅନ୍‌‍ୱାଦ୍ ବାକ୍ୟତିଙ୍କ୍‌ ମିଇ ହୃଦୟ୍‍ତାଗ୍ ପଡ଼ିୟ୍ ହିୱିଡ଼୍‍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବେନଙ୍କ୍ ରହତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ମିଡ଼୍ ଦର୍ମଶାସ୍ତ୍ରତିଙ୍କ୍ ମେହେକ ମିନ୍ଦେଡ଼ି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଗାଙ୍କ୍ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ ଦର୍‍କିତ୍‍ତେ ଇଞ୍ଜ ହେର୍କା ମାଡ଼ମିନ୍ଦେଡ଼ି, ମେଣ୍ଡେ, ଆଦ୍ ଦର୍ମଶାସ୍ତ୍ର ନା ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିସମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଜିୱୁନ୍‍ ଦର୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ନା ଗାର୍‍ରେ ୱାଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ନାନ୍ ନାରୁଡ଼ାଗାଙ୍କ୍ ଗୌରବ୍ ଆଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ନ୍‌, ");
INSERT INTO kff_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ମାତର୍ ନାନ୍ ମିକିଂଙ୍କ୍ ପୁଞ୍ଜ୍ ମିନ୍ଦେନ୍, ମିଡ଼୍ ବେଦ୍ ରକମ୍ ନାରୁଡ଼ି, ମିଇ ଜିୱୁତେ ଲୋପେ ଇଶ୍ୱର୍‌ତେ ସେଙ୍ଗେ ପ୍ରେମ ଇଲା । ");
INSERT INTO kff_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ନାନ୍ ନା ବାବାନ୍ ପେଦେର୍‍ତେ ୱାସ୍‍ମିନ୍ଦେନ୍‍, ମେଣ୍ଡେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼୍‍ୱିଡ଼୍; ମେଣ୍ଡେଅର୍‍ତୁନ୍ ଯଦି ନିଜେତ୍ ପେଦେର୍‍ତେ ୱାଦ୍‍ତଣ୍ଡ୍, ଆଲାଇତ୍‍କେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ମିଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ପାର୍‍ଦ୍‍ତିଡ଼୍‍ ? ମିଡ଼୍ ନିଜେ ନିଜେତାଗାଙ୍କ୍ ଗୌରବ୍ ଗ୍ରହନ୍ ମାଡ଼ମିନ୍ଦେଡ଼ି, ମେଣ୍ଡେ ୱେରଡ଼୍ ମାତର୍ ଇଶ୍ୱର୍‍ତାଗାଙ୍କ୍‍ ବେନ୍ ଗୌରବ୍, ଆଦ୍ ଦର୍‍ସ୍କାଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ନାନ୍ ଯେ ବାବାନ୍ ମୁନେ ମିଇ ବିରୁଦ୍‍ତେ ଅବିଯଗ୍‍ ମାଡ଼ିତାନ୍, ଇଦ୍ ହେର୍କା ମାଡ଼୍‍ମାଟ୍; ବେନ୍ ମୋଶାନାଗ୍‍ ମିଡ଼୍ ଆଶେ ନେହେସ୍ ମିନ୍ଦେଡ଼ି, ଅଣ୍ଡ୍‌ ମିଇ ବିରୁଦ୍ଦ୍‌ତେ ଅବିଯଗ୍ ମାଡ଼ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ମିଡ଼୍ ଯଦି ମୋଶାଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼େଡ଼ି, ଆଲାଇତ୍‍କେ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼େଡ଼ି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନା ବିଷୟ୍‍ତେ ଲେକିମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଯଦି ମୋଶାଲ୍ ଲେକ୍‍ତାଦ୍‍ ବାକ୍ୟତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍, ଆଲାଇତ୍‍କେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ନାୟାଦ୍ ବାକ୍ୟ ବିଶ୍ୱାସ୍ ମାଡ଼ିତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ତାନ୍‍ପେର୍କେ ଜିସୁ ଗାଲିଲି ବେଡ଼େଡ଼୍‍ତେ, ଇତ୍‍କେ ତିବିରିୟା ବେଡ଼୍‍ମ୍‍ତିଙ୍କ୍ ୱେୟସ୍ ଆପାକ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ମେଣ୍ଡେ, ଅଣ୍ଡ୍‌ ରଗିନାରୁନ୍‍ତେ ସେଙ୍ଗେ ବେନ୍ ଆଶର୍ଯ୍ୟ ପାଡ଼ିୟି ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍, ଆଉସାରେ ଉଡ଼ି ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌‍ପେର୍କେ ତାକାନଙ୍କ୍‍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ଆସୁଟେ ଜିସୁ ମେଟେତ୍‍ ପର୍‍ର ଆଞ୍ଜ୍ ନିଜେତ୍ ଶିଷ୍ୟଡ଼୍ ତ ଆଗେ କୁଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ଆସୁଟେ ଯିହୁଦିଡ଼ାଦ୍‍ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ଗାର୍‍ରେ ଏୱୁସ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ମେଣ୍ଡେ, ଜିସୁ ନାର୍‍ଗେ ନାରୁଡ଼୍ ତାନ୍ ଗାର୍‍ରେ ୱାଦାନାଦ୍ ଉଡ଼ି ପିଲିପ୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଡ଼୍ ତିନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ମାନାଡ଼୍ ବେଗାଙ୍କ୍ ନାର୍‍ଗେ ରୁଟି ଆସିତାଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ପିଲିପ୍‍ତିଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼୍‍ତେ ଲେକାମ୍ ଇଲା କେତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବାତେଏ ମାଡ଼ାଙ୍କ୍ ଆଞ୍ଜମିନ୍ଦେଣ୍ଡ୍, ଆଦ୍ ଅଣ୍ଡ୍‌ ନିଜେ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପ୍ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ସାରେତଡ଼୍ ସୁଦୁର୍ ପାହେମ୍‍ଆଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଇଡ଼୍ ସେଙ୍ଗେ ରେଣ୍ଡ୍ ୱାନ୍ଦା ଦିନାରୀତେ ରୂଟି ଆସର୍‍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ଶିମୋନ୍ ପିତର୍‍ତେ ଦାଦାଲ୍ ଆନ୍ଦ୍ରିୟ ପେଦେର୍‍ତଣ୍ଡ୍ ଅଡ଼୍‌ ଶିଷ୍ୟଡ଼୍ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ଇଗ୍ ୱେରଣ୍ଡ୍ ପେକାଲ୍‍ ମିନ୍ଦେଣ୍ଡ୍, ଅନ୍‌‍ଆଗେ ଏଇଙ୍ଗ୍ ରୂଟି ନୁ ରେଣ୍ଡ୍ ୱାୱ୍‍ତାଉ କିକେ ମିନ୍ଦେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇସର୍ ନାରୁଡ଼୍ ମାଇଦିଙ୍କ୍ ଆୱ୍ ଆସର୍‌ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କୁସ୍‍ପାଟ୍‍ ।” ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ଗାଟି ଗାଡ଼୍ ମାତ୍‍ତେ, ଆଦ୍ ଗାଡ଼୍ ପର୍‍ର ସାରେତଡ଼୍ କୁଦ୍‍ତଡ଼୍ । ସାରେ ଏଇଙ୍ଗ୍ ହଜାର୍‌ ନାରୁଡ଼୍ ଆଗେ କୁଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ଆସୁଟେ ଜିସୁ ଆ ରୂଟିଙ୍କ୍ ଅସ୍ ଦନ୍ୟବାଦ୍ ଇସ୍ କୁଦିମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଆୱ୍ ତୁଉସିତ୍‍ତଣ୍ଡ୍‌, ଆଦେ ପୁଟୁଙ୍କ୍ କିକେ ଆନ୍‌‍ତେ ତୁଉସିତ୍‍ତଣ୍ଡ୍‌, ଅଡ଼୍‌ ବେସର୍ ଇଚ୍ଛା ମାଡ଼୍‌ତଡ଼୍‌ ଆସର୍ ଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ମେଣ୍ଡେ, ଅଡ଼୍‌ ତିଞ୍ଜ୍ ପାଞ୍ଜ୍‍ତେ ପେର୍‍କେ, ଜିସୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଗ୍‍ଲି ମାନ୍ଦାନ୍ ଉର୍‍ଙ୍ଗ୍‍ତେ ଦୁଡ଼ାକିଂଙ୍କ୍ ୱେରଡ଼୍ ଆଗେ ଗୁଡ଼୍‍ପାଟ୍‍ ।” ବେଦ୍‍ପୁଟୁଙ୍କ୍ ବାତେବା ନଷ୍ଟ ଆୟ୍‍ମାକି, ");
INSERT INTO kff_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ଆସୁଟେ ଅଡ଼୍‌ ହାୱୁସାରେ ୱେରଡ଼୍ ଆଗେ ଗୁଡ଼୍‍ପ୍‍ତଡ଼୍, ମେଣ୍ଡେ ନାରୁଡ଼୍‍ତିତ୍‍ ପେର୍‍କେ ଏଇଙ୍ଗ୍ ରୂଟିନାଗାଙ୍କ୍ ବେନା ଉର୍‍ଙ୍ଗ୍‍ତେ ଦୁଙ୍କ୍‍କାକିଂଙ୍କ୍ ମିଗ୍‍ଲି ମାତ୍‍ତା, ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ବାର୍‍ଟାନ୍ ଜୁଡ଼ିନାଗ୍‍ ବର୍ତ୍ତି ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଆଗେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଜିସୁ ମାଡ଼୍‍ତେ ବାକ୍‍ୱା ପାଡ଼ିୟି ଉଡ଼ି କେତ୍‍ତାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍, “ଜଗତ୍‍ତାଗେ ବେନ୍ ବାବବାଦିଡ଼୍ ୱାଦାନାଦ୍ ମାତ୍‍ତେ, ଇଣ୍ଡ୍ ନିଜାମ୍ ଅଣ୍ଡେ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ଆଦିଙ୍କ୍ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଶକ୍ତିତେ ପୟ୍‍ସ୍ ରାଜା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଡ଼୍, ଇଦ୍ ପୁଞ୍ଜ୍ ଜିସୁ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ୱେରଣ୍ଡେ ମେଟେତାଗ୍ ପେୟିସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ଆଦ୍‍ଦିନେ ମୁଲ୍‍ପୁଟ୍ ଆତ୍‍ତାଙ୍କ୍ ଜିସୁନ୍ ଶିଷ୍ୟଡ଼୍ ସମୁଦ୍ରତାଗ୍‍ ଆତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ମେଣ୍ଡେ ଓଡ୍‍ତାଗ୍‍ କୁଦି ସମୁଦ୍ରତେ ଆପ୍‍ପାକେ କପର୍ନାହୁମ୍ ପାକେ ଆଦାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ଇକାଡ଼୍ ଆତ୍‍ତେ, ମେଣ୍ଡେ ଜିସୁ ଆସୁଙ୍କ୍‍ ଯାକ ଅଡ଼୍‌ ଗାର୍‍ରେ ୱାଡ଼କଟ ମାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ମେଣ୍ଡେ ଗାଟି ଗାଲ୍‍ୱାଦାନ୍‍ ମାଇଦିଙ୍କ୍ ବେଡ଼େମ୍‍ତାଗ୍ ଗାହାଙ୍କ୍‍କୁଡ଼୍ ତେଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଶିଷ୍ୟଡ଼୍ ଇଲ୍‍କେତାଗ୍ ଏଇଙ୍ଗ୍ ବା ଆରୁ କିଲମିଟର୍ ଜେକେ ଓଡା ଆତ୍‍ତେୱେୟ୍, ଜିସୁ ଏର୍‍ଦା ପର୍‍ର ତାକି ଓଡେତ୍ ଗାର୍‍ରେ ୱାସମାନ୍ଦାନାଦ୍‍ ଉଡ଼ି ୱେର୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଣ୍ଡ୍ ତ ନାନ୍, ୱେରେ ମାଟ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଓଡେତେ ଆଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଡ଼୍‌ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ଆଞ୍ଜମାତ୍‍ତଡ଼୍, ଓଡ୍‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଦ୍ ଆଞ୍ଚିନାଗ୍‌ ହେୱ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ମାତର୍ ୱେରଡ଼୍ ଓଡା ମାତ୍‍ତା, ମେଣ୍ଡେ ଆଗେ ଯେ ଜିସୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ଅନ୍‌‍ୱେ ମାତ୍‍ତଣ୍ଡ୍, ମାତର୍ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଆଞ୍ଜ୍ ମାତ୍‍ତଡ଼୍, ଇଦ୍ ବେନ୍ ନାରୁଡ଼୍ ମେଣ୍ଡନ୍‍ଦିନେ ବେଡ଼େମ୍‍ତେ ମେଣ୍ଡନ୍ ପାକେ ନିସ୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଉଡ଼ିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ବେଗେ ଜିସୁ ପ୍ରାର୍ତନା ମାଡ଼ି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ରୂଟି ତିନ୍ଦାନଙ୍କ୍ ଇସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପଡ଼୍‍ୟିତାଗ୍ ତିବିରୀୟାତେ ବେସ୍‌କ୍ ଓଡା ୱାସ୍ ହେୱୁତା; ");
INSERT INTO kff_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ଜିସୁ ନୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଆଗେ ଇଲ୍‍ଲେଡ଼୍, ଇଦ୍ ବେସୁଙ୍କ୍‍ ନାରୁଡ଼୍ ଉଡ଼୍‍ତଡ଼୍, ଆସୁଟେ ଅଡ଼୍‌ ହାଉସାରେ ଓଡ୍‍ତାଗ୍‍ ତାରି ଜିସୁଙ୍କ୍ ମେହ୍‍କ କପର୍ନାହୁମ୍ ତାଗ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ମେଣ୍ଡେ, ଅଡ଼୍‌ ବେଡ଼େମ୍‍ତେ ଆପାକ୍ ଜିସୁଙ୍କ୍ ଉଡ଼ି ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ହୋ ଗୁରୁ ନିମ୍‍ ବେସୁଙ୍କ୍‍ ହିଗ୍ ୱାତ୍‍ତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ଇତ୍‌ତଣ୍ଡ୍‌, “ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ଉଡ଼୍‍ତାଙ୍କ୍ ଯେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେହ୍‍କୁତିଡ଼୍, ଆଦ୍ ଆୟ୍‍ୟ, ମାତର୍ ରୋଟି ତିଞ୍ଜ୍ ପଟ୍‍ଟେ ନିଣ୍ଡ୍‍ତାଙ୍କ୍ ନାକିଂଙ୍କ୍ ମେହେକୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ବେନ୍ କାଦି ତେରିତେ, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ କଷ୍ଟ ମାଡ଼୍‍ମାଟ୍ । ବେଲାନ୍ ବେନ୍ କାଦି ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଇଦ୍‍ତଣ୍ଡ୍‌, ଆଦିନ୍ ସେଙ୍ଗେ କଷ୍ଟ ମାଡ଼ାଟ୍ । ଆଦ୍ କାଦି ନାରୁନ୍‍ପିଲେ ମିକିଂଙ୍କ୍ ହିଦ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଂକିଙ୍କ୍‌ ବାବାଲ୍ ଇଶ୍ୱର୍ ଇଦ୍ ଅଦିକାର୍‌ ହିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ଆସୁଟେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ଇଶ୍ୱର୍ ବାତ୍ ଇଚ୍ଛା ମାଡ଼ୁତଣ୍ଡ୍, ଆଦ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ମାକିଂଙ୍କ୍ ବାତ୍ ମାଡ଼୍ ୱେୟ୍‍ତିତ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ବେନଙ୍କ୍ ଇଶ୍ୱର୍ ରୟ୍‍ସ୍ ମିନ୍ଦେଣ୍ଡ୍, ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ାନ୍ ତଡ଼୍ ମିଡ଼୍ ଆଦ୍ ମାଡ଼୍ ପାର୍ଦିତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ଆସୁଟେ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ଆଲେକେ ନିମ୍‍ ଚିହିହ୍ନେ ରକମ୍ ବାତେଏ ମାଡ଼ମିନ୍ଦେନି ଯେ, ଆଦ୍ ଉଡ଼ି ମାମ୍ ନିକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍ ପାର୍‍ଦ୍‍ତମ୍‍ ? କେଲାଟ୍ ବାତେଏ ମାଡ଼୍ ପାର୍‍ଦ୍‍ତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ମାନ୍‍ ଆନିଦାଦିଡ଼୍ ଉସ୍କ ନେଲ୍‍ଦାଗ୍ ମାନ୍‍ନା ତିଞ୍ଜମାତ୍‍ତଡ୍‍, ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ତିନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଇଦ୍ କାଦି ହିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ଆସୁଟେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସ୍ ମିନ୍ଦେନ୍, ବାତ୍ ମୋଶାଲ୍ ମିକିଂଙ୍କ୍ ହିତ୍‍ତଣ୍ଡ୍ ଆଦ୍ ସ୍ୱର୍ଗତାଦ୍ କାଦି ଆୟ୍‍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ବାବାଲ୍ ମିକିଂଙ୍କ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଆଦ୍‍ରକତ୍ କାଦି ହିଦ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ବେନ କାଦି ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଡିଗି ଜଗତ୍‍ତିଙ୍କ୍ ଜିୱୁନ୍‍ ବେଡ଼୍‍ୟାଦ୍‍ ମାଡ଼ିତେ, ଆଦ୍ ଇଶ୍ୱର୍‌ତେ କାଦି ।” ");
INSERT INTO kff_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ପ୍ରବୁ, ସାର୍‍ଦାମ୍‍ ମାକିଂଙ୍କ୍ ହିସତେ କାଦି ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ଆସୁଟେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନେ ଆଦ୍ ଜିୱେମାନ୍ଦାନ୍ କାଦି; ବେନ ନା ଗାର୍‍ରେ ୱାଦ୍‍ତଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ବେସୁଙ୍କେ କାର୍‍ୱିନ୍ ଆୟ୍‍ୟଣ୍ଡ୍, ମେଣ୍ଡେ ବେନ ନାୟାଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଂକିଙ୍କ୍‌ ବେସୁଙ୍କେ ବା ଏର୍‍ ହୁନ୍ଦ୍‍ୱାହ୍‍ଓ । ");
INSERT INTO kff_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଉଡ଼୍‍କେ ମିକା ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍, ଇଦ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ବାବାଲ୍ ବେନଡ଼୍‍କିଂଙ୍କ୍ ନାକିଂଙ୍କ୍ ଦାନ ମାଡ଼ିତନ୍, ଅଡ଼୍‌ ନା ଗାର୍‍ରେ ୱାଦ୍‍ତଡ଼୍‍; ମେଣ୍ଡେ, ବେନ ନା ଗାର୍‍ରେ ୱାଦ୍‍ତଣ୍ଡ୍, ଅଂକିଙ୍କ୍‌ ନାନ୍ ବେଦ୍‍ଲେକାମ୍ ବାୟିଦେ ପେସ୍‍ପିୱନ୍‍; ");
INSERT INTO kff_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନିଜେତ୍ ଇଚ୍ଛାତିଙ୍କ୍ ସାଦନ୍‍ ମାଡ଼ାଙ୍କ୍ ୱାଡ଼ନ୍‍ ବେଲାନ୍ ନା ପ୍ରେରଣାକର୍ତ୍ତାନ୍ ଇଚ୍ଛା ସାଦନ୍‍ ମାଡ଼ାଙ୍କ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ମେଣ୍ଡେ, ନା ପ୍ରେରଣାକର୍ତ୍ତାଲ୍‍ ବେନ୍ ସାର୍‍ତଡ଼୍‍କିଙ୍କ୍ ନାକିଂଙ୍କ୍ ଦାନ ମାଡିସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେନଙ୍କ୍ ମେଣ୍ଡେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ନାନ୍ ହରାମାଡ଼କଟ୍‍ ବେଲାନ୍ ଶେଷ ଦିନ୍‍ତେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡେନ୍‍ଦାମ୍ ବାଦ୍‍କିତାନ୍, ଇଦ୍ ଅନାଦ୍‌ ଇଚ୍ଛା । ");
INSERT INTO kff_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍ ଇଚ୍ଛା ମାଡ଼ିତନ୍ ବେନଆଇ ମାର୍‍ଦିଙ୍କ୍ ଦର୍ଶନ୍ ମାଡ଼ି ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଡ଼୍‌ ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ ଦର୍‍କିତ୍‍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଶେଷ ଦିନ୍‍ତେ ନାନ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ଜିୱୁଣ୍ଡ୍ ମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ଜିସୁ ନାନ୍ ସ୍ୱର୍ଗକଞ୍ଜ୍ ୱାସ୍‍ମାନ୍ଦାନ୍ କାଦି ଇଞ୍ଜ କେତ୍‍ତାଙ୍କ୍, ଯିହୁଦିଡ଼୍ ଅନ୍‌ ବିରୁଦ୍ଦ୍‌ତେ ନିନ୍ଦ୍ ମାଡ଼ି କେତ୍‍ତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ବାତେଏ ଯୋଷେପ୍‍ତେ ମାର୍‍ ଜିସୁ ଆୟ୍‍ୟଣ୍ଡ୍ କି ? ମେଣ୍ଡେ ମାମ୍‍ମେ ତାମ୍ ୟାୟ୍‍ବାବାଙ୍କ୍ ପୁତ୍‍ତମ୍, ଆଲେକ୍ ନାନ୍ ସ୍ୱର୍ଗକଞ୍ଜ୍ ୱାସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ ଅଣ୍ଡ୍‌ ଇଞ୍ଜେ ବେଦ୍ ପୁଟୁଙ୍କ୍ କେସମିନ୍ଦେଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନିଜେତ୍ ନିଜେତ୍ ଲୋପ୍ ନିନ୍ଦ୍ ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ନା ମାଲ୍‍ସ୍ ୱାଦାନ୍ ବାବାଲ୍ ବେନଙ୍କ୍ ତିଆର୍ ମାଡ଼ିତନ୍, ମାତର୍ ଅଣ୍ଡ୍‌ ନା ଗାର୍‍ରେ ୱାଦ୍‍ପାର୍‍ଦ୍‍ ତଣ୍ଡ୍, ମେଣ୍ଡେ ନାନ୍ ଶେଷ ଦିନ୍‍ତେ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ଅଂକିଙ୍କ୍‌ ଜିୱୁଣ୍ଡ୍ ମାଡ଼ିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ବାବବାଦିଡ଼୍ ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଲେକିମିନ୍ଦେଡ଼୍, ସାରେତଡ଼୍ ମାତର୍ ଇଶ୍ୱର୍‌ତେ କନ୍‍ସ୍ ଶିକ୍ଷା ଦର୍ସିକି ଆଦ୍‍ତଡ଼୍ । ବେନଆଇ ବାବାନାଗାଙ୍କ୍ କେଞ୍ଜି ଶିକ୍ଷା ଲାବ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନା ଗାର୍‍ରେ ୱାଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଇଦିନ୍ ଇତ୍‍କେ ଆୟ୍‍ୟ ଯେ ବେନ ବାବାଙ୍କ୍ ଉଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ବେନ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମାତର୍ ବାବାଙ୍କ୍ ଉଡ଼ିମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ବେନ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଦର୍ସିକି ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ନାନ୍ ଜିୱୁମାନ୍ଦାନ୍ କାଦି । ");
INSERT INTO kff_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ମିଇ ଆନିଦାଦିଡ଼୍ ଉସ୍କ ନେଲ୍‍ଦାଗ୍ ମାନ୍‍ନା ତିତ୍‍ତଡ଼୍ ମିକା ଅଡ଼୍‌ ଡଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ୍ କାଦି ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ୱାଦ୍‍ତେ ଆଦିଙ୍କ୍ ବେନ ତିନ୍‍ତଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ସାରେଦିନାତ୍ ଜିୱୁଣ୍ଡ୍ ଜିୱେଦର୍‍କିତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ନାନ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ୱାସ୍‍ମାନ୍ଦାନ୍ ଆଦ୍ ଜିୱେମାନ୍ଦାନ୍ କାଦି; ବେନ ହିଦ୍ କାଦି ତିନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଅନନ୍ତକାଲ୍ ଯାକ ଜିୱୁ ମାନ୍‍ତଣ୍ଡ୍; ନାନ୍ ବେନ୍ କାଦି ହିଦ୍‍ତାନ୍, ଆଦ୍ ନାୟାଦ୍ ଆଉଙ୍ଗ୍, ନାନ୍ ଆଦ୍ ଜଗତ୍‍ତିଙ୍କ୍ ବାଦ୍‍ସ୍କ୍‌କାନ୍ ମାଇଦିଙ୍କ୍ ହିଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ଆସୁଟେ ଯିହୁଦୀଡ଼୍‍ ନିଜେ ନିଜେ ରାମ୍‍କ୍ ଆସ୍ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ବେଲା ମାନାଙ୍କ୍‌ ନିଜେତ୍ ଆଉଙ୍ଗ୍ ତିନ୍ଦାଙ୍କ୍ ହିଦ୍ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ଆସୁଟେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ମନୁଷ୍ୟପୁତ୍ରନ୍ ଆଉଙ୍ଗ୍ ତିନକଟ୍ ମାତ୍‍କେ ନୁ ଅନାଦ୍‌ ନେତୁର୍‍ତିଙ୍କ୍ ଉନକଟ ମାତ୍‍କେ, ମିଡ଼୍ ଜିୱୁନ୍‍ ପାଏମ୍ ଆଦ୍‍ପାର୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ବେନ ନା ଆଉଙ୍ଗ୍ ତିନ୍‍ତଣ୍ଡ୍ ନୁ ନା ନେତୁର୍ ଉନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ଦର୍ସିକିତଣ୍ଡ୍, ମେଣ୍ଡେ ନାନ୍ ଶେଷ ଦିନାତେ ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ବାଦ୍‍କିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ଆଉଙ୍ଗ୍ ଆଦ୍‍ରକତ୍ କାଦି ନୁ ନା ନେତୁର୍ ଆଦ୍‍ରକତ୍ ଉନ୍ଦାନାଦ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ବେନ ନା ଆଉଙ୍ଗ୍ ତିନ୍‍ତଣ୍ଡ୍ ନୁ ନା ନେତୁର୍ ଉନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନାୟାଗେ ମାନ୍‍ତଣ୍ଡ୍ ନୁ ନାନ୍ ଅନ୍‌‍ଆଗେ ମାନ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଜିୱୁତେ ବାବାଲ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ନାକିଂଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍ ନୁ ନାନ୍ ବାବାନ୍ ସେଙ୍ଗେ ଜିୱୁ ମିନ୍ଦେନ୍, ଆଦିନ୍‌ ରକମ୍ ବେନ ନାକିଂଙ୍କ୍ ତିନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆନ୍‌‍ତେ ନା ମାଇଦିଙ୍କ୍ ଜିୱୁନ୍ ମାନ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ବେନ କାଦି ସ୍ୱର୍ଗକଞ୍ଜ୍ ୱାସ୍‌ ମିନ୍ଦେ, ଆଦ୍ ହିଦ୍; ଆନିଦାଦିଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ତିଞ୍ଜ୍ ଡଲିମିନ୍ଦେଡ଼୍, ଆଦ୍‍ଲେକାମ୍ ଆୟ୍‍ୟ; ବେନ ହିଦ୍ କାଦି ତିନ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଅନନ୍ତକାଲ୍ ଯାକ ଜିୱୁ ମାନ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଜିସୁ କଫର୍ନାହୁମ୍‍ତେ ୱେରଡ଼୍ ସମାଜ୍ ଲତ୍‍ତାଗେ ଶିକ୍ଷା ହିସମାନ୍ଦାନ୍ ସମୟ୍‍ତେ ହି ସାରେ ଗଟି କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ତାମ୍ ଶିଷ୍ୟଡ଼୍ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ହିଦ୍ କେଞ୍ଜି କେତ୍‍ତଡ଼୍, “ହିଦ୍ ଶିକ୍ଷା ବୁଜେମ୍ ଆଦାନାଦ୍ ଗାଟି କଷ୍ଟ, ବେନ ହିଦ୍ ସାରେ କେଞ୍ଜିତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ହିଦ୍ ବିଷୟ୍‍ତେ ଜିସୁଙ୍କ୍ ବେନ ବାତେଏ କେଲକଟ ମାତ୍‍କେ ମିକା ତାନ୍ ଶିଷ୍ୟଡ଼୍ ନିନ୍ଦ୍ ମାଡ଼ୁତଡ଼୍ ଇଞ୍ଜ ପୁଞ୍ଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହିଦ୍ ଗଟ୍‍ତେ ମିଡ଼୍ ଚିନ୍ତେ ଆଦୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ଆଲାଇତ୍‍କେ ନାରୁନ୍‍ପିଲେ ମୁନେଙ୍କ୍ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ମାଲ୍‍ସ୍ ଆଦାନାଦ୍ ଉଡ଼୍‍କେ ଆସୁଟେ ବାତ୍ ମାଡ଼ିତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ମାତର୍ ଇଶ୍ୱର୍‌ତେ ଆତ୍ମା ଜିୱୁନ୍‍ ହିଦ୍‍ପାର୍‍ଦ୍‍ତେ; ନାରୁଡ଼୍‍ତେ ଶକ୍ତି ବାତେମିକା ମାଡ଼୍ ପାର୍‍ୱ; ଇଶ୍ୱର୍‌ତେ ଆଦ୍ ଜିୱୁନ୍ ହିଦାନ୍ ଆତ୍ମା, ଆତ୍ମାତିଙ୍କ୍ ମିଡ଼୍ ବେଲା ଏର୍କା ମାଡ଼୍ ପାର୍ଦିତିଡ଼୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ହିଦ୍ ସାରେ ଗଟି କେତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ଆତ୍‍କେମିକା ମିଇ ଲୋପେଙ୍କ୍ ବେନଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ଡ଼୍‍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼କଟ୍ ମାତ୍‍ତଡ଼୍ ନୁ ବେନ ଅଂକିଙ୍କ୍‌ ଶତ୍ରୁଡ଼୍‍କାଇଦେ ସମର୍‍ପନ୍ ମାଡ଼ିତନ୍, ଆଦ୍ ଜିସୁ ମୁନେଙ୍କ୍ ପୁଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ମେଣ୍ଡେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ବାବାନାଗାଙ୍କ୍ ମାଲ୍‍ୱେ କଟମାତ୍‍କେ ବେନ ନା ଗାର୍‍ରେ ୱାଦ୍ ପାର୍‍ୱଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ଆ ସମୟ୍‍ତାଗାଙ୍କ୍ ଅନ୍‌ ଶିଷ୍ୟଡ଼୍ ଲୋପେଙ୍କ୍ ନାର୍‍ଗେ ଅଂକିଙ୍କ୍‌ ପେର୍‍କେ ମାଡ଼କଟ୍ ପେୟିସ୍ ଆଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅନ୍‌ ତଡ଼୍ ମେଣ୍ଡେ ତାକଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ଆସୁଟେ ଜିସୁ ବାରଜାନ୍‍ତିଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଆନ୍‌‍ତେ ବାତେଏ ନାକିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ମାଲ୍‍ସ୍ଆଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ଶିମୋନ୍ ପିତର୍ ଜିସୁଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ପ୍ରବୁ, ମେଣ୍ଡେ ବେନନ୍ ଗାର୍‍ରେ ଆଦ୍‍ତମ୍ ? ସାରେଦିନାତ୍ ଜିୱୁନ୍‍ତାଦ୍ ବାକ୍ୟ ତ ନିୟାଗ୍ ମିନ୍ଦେ; ");
INSERT INTO kff_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ମେଣ୍ଡେ ନିମ୍‍ ଯେ ଇଶ୍ୱର୍‌ତେ ଆଦ୍ ପବିତ୍ର ନାରୁନି, ହିଦ୍ ମାମ୍‍ମେ ବିଶ୍ୱାସ୍ ମାଡ଼ିମିନ୍ଦେମ୍ ନୁ ପୁଞ୍ଜ୍‍ମିନ୍ଦେମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ମିଡ଼୍ ବାରଜାନ୍‍ତିଙ୍କ୍ ହେଞ୍ଚି ମାନନ୍ କି ?” ମିକା, ମିଇ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ଶୟ୍‍ତାନ୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଜିସୁ ଇଷ୍କାରୀୟତିୟ ଶିମନତେ ମାର୍‍ ଯିହୁଦାଙ୍କ୍ ଉଡ଼ିମିକା ଇଦ୍ କେତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବାରଜାନ୍ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡେ, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ଶତ୍ରୁଡ଼୍‍କାୟ୍‍ଦେ ସମର୍‍ପନ୍ ମାଡ଼ାଙ୍କ୍ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ତାନ୍‍ପେର୍କେ ଜିସୁ ଗାଲିଲୀତାଗ୍ ଉଡାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ଯିହୁଦୀଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଆୱ୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼୍‍ନାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଯିହୁଦା ପ୍ରଦେଶ୍‍ତାଗ୍ ଉଡାନ୍‌ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼କଟ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ଯିହୁଦୀଡ଼ାଦ୍‍ କୁଟୀର ବାସ ପାଣ୍ଡୁମ୍‍ତେ ଦିନାମ୍ ଗାର୍‍ରେ ହେୱ୍‍ସ୍‍ମାତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ତାନ୍ ତାମୁଣ୍ଡ୍‌କିଡ଼୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ ବେନ୍ ପାଡ଼ିୟି ମାଡ଼ମିନ୍ଦେନି, ହାଉସାରେ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ମିଇ ଶିଷ୍ୟଡ଼୍ ଆନ୍‌‍ତେ ଉଡ଼ିତିଡ଼୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ହିଗାଙ୍କ୍ ପେୟ୍‍ସ୍‍ଆଞ୍ଜ୍ ଯିହୁଦା ପ୍ରଦେଶ୍‍ତାଗ୍ ଅନ୍‌, ");
INSERT INTO kff_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ତିଆର୍ ଆତ୍‍ତାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍କେ ମିଞ୍ଜିମିକା ବାତେଏ ମାଡ଼ଣ୍ଡ୍ । ମିଡ଼୍ ଯଦି ହିସାର୍‍ରେ ମାଡ଼ୁତିଡ଼୍, ଆଲାଇତ୍‍କେ ନିଜେତିଙ୍କ୍ ଜଗତ୍‍ତେ ଗାର୍‍ରେ ତିଆର୍ ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ତାନ୍ ତାମୁଣ୍ଡ୍‌କିଡ୍‍ ମିକା ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼କଟ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ଆସୁଟେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାୟାଦ୍ ଦିନାମ୍ ହି ଯାକ ଉପସ୍ଥିତ ଆୟକେ, ମାତର୍ ମିକିଂଙ୍କ୍ ସାରେ ଦିନାମ୍ ଲେକାମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ଜଗତ୍ ମିକିଂଙ୍କ୍ ପାସ୍‍କ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାକିଂଙ୍କ୍ ପାସ୍‍କିତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ତାନାଦ୍ ପାଡ଼୍‍ୟି କାରାପ୍, ନାନ୍ ତାନ୍ ବିଷୟ୍‍ତେ ହି ସାକ୍ଷ୍ୟ ଇସ୍‌ ୱାଦୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ମିଡ଼୍ ହି ପାଣ୍ଡୁମ୍‍ତାଗେ ଆନୁଟ୍, ନାନ୍ ଇଞ୍ଜେ ହି ପାଣ୍ଡୁମ୍‍ତାଗ୍ ଆନନ୍‍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ନାୟାଦ୍ ଦିନାମ୍ ହି ଯାକ ଉପସ୍ଥିତ ଆୟକେ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହିୱ୍ ସାରେ ଗଟି କେସ୍ ଗାଲିଲୀତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ବାତେଙ୍କ୍ ଇତ୍‍କେ ତାନ୍ ତାମୁଣ୍ଡ୍‌କିଡ଼୍ ପାଣ୍ଡୁମ୍‍ତାଗେ ଆଦ୍‌ ୱେୟେ ଅଣ୍ଡ୍‌ ଆନ୍‌‍ତେ ଆତ୍‍ତଣ୍ଡ୍, ଉଡ଼୍‍ତେଲେକେ ଆୟ୍‍ୟ, ମାତର୍ ଅଣ୍ଡୟ୍‌ ଲେକାତ୍ ଉଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ଆଦିଙ୍କ୍ ଯିହୁଦୀ ନେତାଲଡ଼୍ ପାଣ୍ଡୁମ୍‍ତାଗେ ମେହ୍‍କ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, ଅଣ୍ଡ୍‌ ବେକେ ? ");
INSERT INTO kff_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ମେଣ୍ଡେ, ଅନ୍‌ ବିଷୟ୍‍ତେ ନାରୁଡ଼୍ ତାମ୍‍ତାମ୍ ଲୋପ୍ ତିରିୟାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍; ମେଣ୍ଡେ ବେନ୍‍ ବେନ କେତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ଅର୍‍ତୁଣ୍ଡ୍ ସାୟେତ୍ ନାରୁଡ଼୍;” ମେଣ୍ଡେ ବେନ କେତ୍‍ତଡ଼୍, “ଇଲେ, ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବୁସା ମାଡ଼ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ମିକା ଯିହୁଦୀ ନେତାଲଡ଼୍ ୱେର୍‍ଙ୍ଗିଙ୍କ୍ ଅନ୍‌ ବିଷୟ୍‍ତେ ପୁତ୍‍ତେଲେକେ ବେନ ବାତେଏ କେଲକଟ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପାଣ୍ଡୁମ୍‍ତେ ଆଦା ଦିନାମ୍ ତେର୍‍ତେପେୟ୍, ଜିସୁ ମନ୍ଦିର୍‍ତାଗ୍ ଆଞ୍ଜ୍ ଶିକ୍ଷା ହିଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ଆସୁଟେ ଯିହୁଦୀ ନେତାଲଡ଼୍ ଦାଦ୍‍ରେଲି କେତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ପାଟ୍ କାର୍‍ୱକଟ୍ ବେଲା ହିସର୍ ବିଷୟ୍ ପୁତ୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ଆସୁଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାୟାଦ୍ ଶିକ୍ଷା ନାୟାଦ୍ ନିଜ୍‍ତାଦ୍‍ ଆୟ୍‍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାକିଂଙ୍କ୍ ରହତେନଣ୍ଡ୍ ଇଶ୍ୱର୍‌ତେ କନ୍‍ସ୍ ୱାସ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ବେନଆଇ ଯଦି ଇଶ୍ୱର୍‌ତେ ଇଚ୍ଛା ସାଦନ୍‍ ମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛାମାଡ଼ୁତନ୍, ଆଲାଇତ୍‍କେ ହି ଶିକ୍ଷା ଇଶ୍ୱରତାଗାଙ୍କ୍ ତିଆର୍, ନା ନାନ୍ ନା ନିଜର୍‍ତାଗାଙ୍କ୍ କେତୁତାନ୍, ଆଦ୍ ଅଣ୍ଡ୍‌ ପୁନ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ବେନ ନିଜେତ୍ ତାଗାଙ୍କ୍ କେତିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନିଜେତ୍ ଗୌରବତିଙ୍କ୍ ମେହ୍‍କିତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ନିଜେତ୍ ପ୍ରେରଣାକର୍ତ୍ତାନ୍ ଗୌରବ୍ ମେହ୍‍କିତନ୍, ଅଣ୍ଡ୍‌ ସତ୍, ମେଣ୍ଡେ ଅନାଗେ ବାତେମେଣ୍ଡେ ବିଶ୍ୱାସ୍ ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମୋଶାଲ୍ ବାତେଏ ମିକିଂଙ୍କ୍ ବ୍ୟବସ୍ଥା ହିୱଣ୍ଡ୍ ? ମିକା ମିଇ ଲୋପେଙ୍କ୍ ବେନମିକା ବ୍ୟବସ୍ଥା ପାଲନ୍ ମାଡ଼୍‍ୱିଡ଼୍ । ମିଡ଼୍ ବାତେଙ୍କ୍ ନାକିଂଙ୍କ୍ ଆୱ୍‍କାଂଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼ମିନ୍ଦେଡ଼ି ?” ");
INSERT INTO kff_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ନାରୁଡ଼୍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ନିକିଂଙ୍କ୍ ବୁତ୍ ପୟ୍‍ସ୍ ମିନ୍ଦେ, ବେନ ନିକିଂଙ୍କ୍ ଆୱ୍‍କାଂଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼ୁତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ୱେରଡ଼୍ ମହାନ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତାନ୍, ମେଣ୍ଡେ ମିଡ଼୍ ସାରେତଡ଼ି ଦାଦ୍‍ରେଲି ମିନ୍ଦେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ମୋଶାଲ୍ ମିକିଂଙ୍କ୍ ସୁନ୍ନତ୍ ପାଲନ୍ ଇସ୍‌‍ମିନ୍ଦେନ୍, ହିଦ୍ ଯେ ମୋଶାନାଗାଙ୍କ୍ ଆଶେ ମିନ୍ଦେ, ଆଦ୍ ଆୟ୍‍ୟ, ମାତର୍ ଆନିଦାଦିଡ଼୍ ଡ଼ାଗାଙ୍କ୍, ମେଣ୍ଡେ ମିଡ଼୍ ବିଶ୍ରାମ୍‍ଦିନେତାଗ୍ ପେକାଲଡ଼ାଦ୍ ସୁନ୍ନତ୍ ମାଡ଼ମିନ୍ଦେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ଯଦି ବିଶ୍ରାମ୍‍ଦିନେ ଦିନାତେ ପେକାଙ୍କ୍ ସୁନ୍ନତ୍ ମାଡ଼୍‍କେ ମୋଶାନାଦ୍‍ ବ୍ୟବସ୍ଥା ଉର୍‍ଗାଡ଼୍ ଆୟ୍‍ୟ, ଆଲାଇତ୍‍କେ ନାନ୍ ବିଶ୍ରାମ୍‍ଦିନେ ଦିନାତେ ୱେରନ୍ ନାରୁଙ୍କ୍ ସାରେ ସୁସ୍ଥ ମାଡ଼୍‍କେ ମିଡ଼୍ ବାତେଙ୍କ୍ ନା ପର୍‍ର କପାମ୍ ଆଦୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ବାୟ୍‍ଦେତ୍‍ ବିଷୟ୍ ଉଡ଼ି ବିଚାର୍ ମାଡ଼୍‍ମାଟ୍, ଲେକାମ୍ ନ୍ୟାୟତେ ବିଚାର୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଆସୁଟେ ଜିରୂଶାଲାମ୍‍ତେ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ବେନଡ଼୍ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ଯିହୁଦୀ ନେତାଲଡ଼୍ ବେନଙ୍କ୍ ଆୱ୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼ୁତଡ଼୍, ହିଣ୍ଡ୍ ବାତେଏ ଅଣ୍ଡ୍‌ ଆୟ୍‍ୟ ? ");
INSERT INTO kff_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ମେଣ୍ଡେ ଉଡ଼ାଟ୍, ଅଣ୍ଡ୍‌ ସାରେତଡ଼୍ କେଞ୍ଜ୍‍ତେ ଲେକେମ୍ ଗଟି କେସମିନ୍ଦେନ୍, ମେଣ୍ଡେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ବାତେଏ ମାଡ଼ଡ଼୍‍ । ହିଣ୍ଡ୍ ଯେ ମସିହ, ହିଦ୍ ବାତେଏ ନେତାଲଡ଼୍ ନିଜାମ୍ ପୁତ୍‍ତଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ବେଲା ଆୟି, ହିଣ୍ଡ୍ ବେଗାକନ୍‍ସ୍ ୱାସ୍ ମିନ୍ଦେଣ୍ଡ୍ ମାନାଡ଼୍ ପୁତ୍‍ତାଡ଼୍‍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମସିହ ବେସୁଙ୍କ୍‍ ୱାଦ୍‍ତଣ୍ଡ୍, ଆସୁଟେ ଅଣ୍ଡ୍‌ ୱାଦାନାଦ୍ ବେନ ପୁନ୍‍ଅଡ଼୍‌‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ଆସୁଟେ ଜିସୁ ମନ୍ଦିର୍‍ତାଗ୍ ଶିକ୍ଷା ହିସ ବେଡ଼୍‍ୟ୍ ଲେଙ୍ଗ୍‍ତେ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ନାକିଂଙ୍କ୍ ନୁ ନାୟାଦ୍ ଉତ୍ପତ୍ତିଙ୍କ୍ ପୁତ୍‍ତିଡ଼୍ କି ? ନାନ୍ ନିଜର୍‍ତାଗାଙ୍କ୍ ୱାଡ଼ନ୍‍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ପ୍ରେରଣାକର୍ତ୍ତାଲ୍‍ ସତ୍, ଅଂକିଙ୍କ୍‌ ମିଡ଼୍ ପୁନ୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଅଂକିଙ୍କ୍‌ ପୁତ୍‍ତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଅନ୍‌‍ଆଗାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେନ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ରହ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ଆସୁଟେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପୟ୍‍ତାଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼୍‍ତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନମେଣ୍ଡେ ଅନ୍‌ ପର୍‍ର କାୟ୍‍ ୱାଟଡ଼୍‍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ଅନାଦ୍‌ ଦିନାମ୍ ଆଦ୍ ଯାକ ହେୱକଟ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ନାର୍‍ଗେ ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ି କେତ୍‍ତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ବେନ୍‍ସାରେ ବାକ୍‍ୱା ପାଡ଼ିୟି ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍ ମସିହ ୱାସ୍ ଆୱିଙ୍କ୍‍ଅନ୍‌‍ ବାତେଏ ନାର୍‍ଗେ ମାଡ଼ିତନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ଜିସୁନ୍ ବିଷୟ୍‍ତେ ନାରୁଡ଼୍ ନିଜେ ନିଜେ ତିରିୟାନାଦ୍ ପାରୂଶୀଡ଼୍ କେଞ୍ଜ୍‍ତଡ଼୍, ଆସୁଟେ ମୁକ୍ୟଯାଜକ୍ ନୁ ପାରୂଶୀଡ଼୍ ଅଂକିଙ୍କ୍‌ ପୟ୍‍ଦାନ୍‍ ମାଇଦିଙ୍କ୍ ପ୍ରହରୀଡ଼୍‍କ୍ ରହ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ଆସୁଟେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ମେଣ୍ଡେ ସୁଦୁର୍ ସମୟ୍‍ଜାକ ମିଇ ତଡ଼୍ ମାନ୍‍ତାନ୍, ତାନ୍‍ପେର୍କେ ନାକିଂଙ୍କ୍ ରୟ୍‍ସ୍‍ମାନ୍ଦାନନ୍‍ ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେହ୍‍କିତିଡ଼୍‍, ମାତର୍ ଦର୍‍ସ୍‍କ୍‍ ପାର୍‍ୱିଡ଼୍, ମେଣ୍ଡେ, ନାନ୍ ବେଗେ ମାନ୍‍ତାନ୍, ଆଗେ ମିଡ଼୍ ଆତ୍‍ତାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ଆସୁଟେ ଯିହୁଦୀଡ଼୍‍ ନିଜେ ନିଜେତିଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ବେଗେ ଆଦ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ପେୟିସ୍ ମିନ୍ଦେନ୍ ଯେ, ମାନ୍‍ଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ଦର୍‍ସ୍କାଙ୍କ୍ ପାର୍‍ୱାଡ଼୍‍ ? ହିଣ୍ଡ୍ ବାତେଏ ଗ୍ରୀକ୍‍ନାରୁଡ଼୍‍ ଲୋପେଙ୍କ୍ ଦୁଡ଼ାଦୁଡ଼ା ଯିହୁଦୀଡ଼୍‍ ଗାର୍‍ରେ ଆଞ୍ଜ୍ ଗ୍ରୀକ୍‍ ନାରୁଡ଼୍‍କିଙ୍କ୍ ଶିକ୍ଷା ହିଦାଙ୍କ୍ ପେୟିସ୍ ମିନ୍ଦେନ୍ ? ");
INSERT INTO kff_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେହ୍‍କିତିଡ଼୍‍, ମାତର୍ ଦର୍‍ସ୍‍ୱିଡ଼୍, ମେଣ୍ଡେ ନାନ୍ ବେଗେ ମାନ୍‍ତାନ୍, ମିଡ଼୍ ଆଦ୍ ପାର୍‍ୱିଡ଼୍, ଅଣ୍ଡ୍‌ ହି ବେନ ଗଟି କେତ୍‍ତଣ୍ଡ୍, ଇଦିନ୍ ଇତ୍‍କେ ବାତେଏ ?” ");
INSERT INTO kff_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ପାଣ୍ଡୁମ୍‍ତେ ଶେଷଦିନେ, ଇତ୍‍କେ, ମୁକ୍ୟଦିନେ, ଜିସୁ ନିସ୍‍ମେଣ୍ଡେ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଣ୍ଡ୍, “ବେନଙ୍କ୍ ଯଦି ଉନ୍ଦେୱାହ୍‍ତେ, ଅଣ୍ଡ୍‌ ନା ଗାର୍‍ରେ ୱାଡ଼ିଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ବେନ ନାୟାଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଉନିଣ୍ଡ୍, ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ବେନ ନାୟାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍ ଅନାଦ୍‌ ଜିୱୁତାଦ୍ ସ୍ରୋତ ପ୍ରବାହିତ ଆସମାନ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଜିସୁ ପବିତ୍ର ଆତ୍ମା ବିଷୟ୍‍ତେ ହିଦ୍‍ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍, ବେନ ଜିସୁନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ପେର୍‍କେ ପବିତ୍ର ଆତ୍ମା ପାଏମ୍ ଆଦ୍‍ତଡ଼୍, ବାତ୍‍ତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଆଦ୍ ଯାକ ମହିମା ପାଏମ୍ ଆୟ୍‍ୱାଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ହିୱକଟ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ବେସୁଟ୍‌ ନାରୁଡ଼୍ ଜିସୁନ୍ ହିଦ୍ ଗଟ୍ କେଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେନଡ଼୍ କେତ୍‍ତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ନିଜାମ୍ ତେ ଆ ବାବବାଦୀ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ମେଣ୍ଡେ ବାଗାତଡ଼୍ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ହିଣ୍ଡ୍ ମସିହ;” ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାଗାତଡ଼୍ କେତ୍‍ତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ମସିହ ଗାଲିଲୀତାଗାଙ୍କ୍ ୱାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ମସିହ ଯେ ଦାଉଦ୍‍ତେ ବଂଶତାଗାଙ୍କ୍ ନୁ ଦାଉଦ୍ ବେଗ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ବେତ୍‍ଲିହିମ୍‍ ନାର୍‍ତାଗାଙ୍କ୍ ୱାଦ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ଆଦିଙ୍କ୍ ନାରୁଡ଼୍ ଲୋପେ ଜିସୁନ୍ ମାଇଦିଙ୍କ୍ ମତବେଦ ଗଟେମ୍‍ଆତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ମେଣ୍ଡେ, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଜିସୁ ବନ୍ଦି ଆୟିଣ୍ଡ୍ ଇଞ୍ଜ ଇଚ୍ଛା ମାଡ଼ମାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ଅନ୍‌ ପର୍‍ର କାୟ୍‍ ୱାଟ୍‍ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ହିଦିନ୍ ଲୋପେ ପ୍ରହରୀଡ଼୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତାଙ୍କ୍, ମୁକ୍ୟ ଯାଜକ୍ ନୁ ପାରୂଶୀଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ମିଡ଼୍ ବାତେଙ୍କ୍ ଜିସୁଙ୍କ୍ ତାଡ଼୍‍ୱିଡ଼୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ପ୍ରହରୀଡ଼୍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ହି ନାରୁଡ଼୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ଗଟି କେତୁତଣ୍ଡ୍, ବେନ୍ ନାରୁଡ଼୍ ବେସୁଙ୍କ୍‌ବା ଆଦ୍‍ପୁଟୁଙ୍କ୍ କେଲଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ଆଗାକଞ୍ଜ୍ ପାରୂଶୀଡ଼୍ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଡ଼୍, “ମିକିଂଙ୍କ୍ ମିକା ବାତେଏ ଅଣ୍ଡ୍‌ ବକ୍‍ୱା ମାଡ଼ିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍‌ ? ");
INSERT INTO kff_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ନେତାଲଡ଼୍ ଲୋପେଙ୍କ୍ ବା ପାରୂଶୀଡ଼୍ ଲୋପେଙ୍କ୍ ବାତେଏ ବେନ ୱେରଣ୍ଡ୍‍ମିକା ଅନ୍‌‍ଆଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିମିନ୍ଦେଡ଼୍ ଇଞ୍ଜ ହିଦ୍ ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ କି ? ");
INSERT INTO kff_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ବାତେଙ୍କ୍ ଇତ୍‍କେ ହି ନାରୁଡ଼୍ ମୋଶାନ୍‌ ବ୍ୟବସ୍ଥାତିଙ୍କ୍ ପୁନଡ଼୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଇଡ଼୍‌କ୍ ଅବିଶାପ୍‌ ଦର୍‍କ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ବେନ୍ ନିକଦୀମ୍ ହିଦିନ୍ ମୁନେଙ୍କ୍ ଅନ୍‌ ଗାର୍‍ରେ ୱାସ୍‍ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଯେ ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡେ, ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ୱେରଣ୍ଡ୍ ନାରୁନାଗାଙ୍କ୍ ମୁନେଙ୍କ୍‍କଞ୍ଜ୍ କେଞ୍ଜକଟ ନୁ ଅନାଦ୍‌ ଆଚରଣ ବିଷୟ୍ ପୁନକଟ୍ ମାନାଦ୍‍ ବ୍ୟବସ୍ଥା ବାତେଏ ଅଂକିଙ୍କ୍‌ ଦୋଷି ମାଡ଼ିତେ ?” ");
INSERT INTO kff_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ନିମ୍‍ ମିକା ବାତେଏ ୱେର୍‍ନି ଗାଲିଲୀ ନାରୁନୀ ? ଗାଲିଲୀତାଗ୍ ବେନ୍‌ଆଇ ବାବବାଦୀ ତିଆର୍ ଆୟଡ଼େ, ହିଦ୍ ମେହ୍‍କିମେଣ୍ଡେ ଉଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ମେଣ୍ଡେ ଅଡ଼୍‌ ସାର୍‍ତଡ଼୍ ନିଜେତ୍ ନିଜେତ୍ ଲୋକିନାଗ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ଜିସୁ ଜୀତ ମେଟେତା ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ମେଣ୍ଡନ୍‍ଦିନେ ଅଣ୍ଡ୍‌ ମନ୍ଦିର୍‍ତାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ସାରେତଡ଼୍ ନାରୁଡ଼୍ ଗୁଡ଼୍‍ପି ଆତ୍‍ତାଙ୍କ୍, ଜିସୁ କୁଦିମାଞ୍ଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶିକ୍ଷା ଇଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ମେଣ୍ଡେ, ଶାସ୍ତ୍ରୀଡ଼୍ ନୁ ପାରୂଶୀନଡ଼୍ ବ୍ୟବିଚାରିନି ନାଟାଡ଼୍‍ତିଙ୍କ୍ ପୟ୍‍ସ୍ ତାସ୍ ସାର୍‍ତଡ଼୍ ମୁନେ ନିଲ୍‍ସ୍‍ପି ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ହୋ ଗୁରୁ, ଇଦ୍ ନାଟାଡ଼୍ ବ୍ୟବିଚାର୍ ପାଡ଼୍‍ୟି ମାଡ଼ମାନ୍ଦାନ୍ ୱେଲେ ଦର୍‍କ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଇସତ୍‍ ନାଟାକିଙ୍କ୍ କାଲ୍‍କିନ୍ ତ ରେହେତାଙ୍କ୍ ମୋଶାନ୍‌ ନିୟମ୍‍ତାଗ୍ ମାକିଂଙ୍କ୍ ଗଟ୍ ଇସ୍‌‍ମିନ୍ଦେଣ୍ଡ୍‍, ଇଞ୍ଜେ ଆଲେକେ ନିମ୍‍ ବାତେଏ କେତୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ଅଡ଼୍‌ ବେଲା ଅନ୍‌ ବିରୁଦ୍‍ତେ ଅବିଯଗ୍‍ତେ ବାତେଙ୍କ୍ ଇତ୍‍କେ ପାଏମ୍ ଆତ୍‍ତାଙ୍କ୍, ଆଦିନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପରିକ୍ଷା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଆଦ୍ କେତ୍‍ତଡ଼୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ଆଡ଼୍‌‍କିମେଣ୍ଡେ ୱାଡ଼୍‍ଞ୍ଜ୍ ତ ବୂମ୍‌ତାଗ୍‍ ଲେକାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ଅଡ଼୍‌ ଆଗେ ନିସ୍ ମେଣ୍ଡେ ପ୍ରଶ୍ନ କେଲ୍‍ନାଙ୍କ୍, ଜିସୁ ତାଲେ ତେସ୍ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତାନ୍, “ମିୟାଗାଙ୍କ୍ ବେନ୍ ବା ବାତେବା ପାପ୍ ମାଡ଼ନ୍, ଅଣ୍ଡ୍‌ ମୁନେ ଆଦିଙ୍କ୍ କାଲ୍ ହେସିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ମେଣ୍ଡନ୍‍ଦାମ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ମିକା ନେଲ୍ ଲେକାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ଆଦ୍ କେଞ୍ଜି ଅଡ଼୍‌ ବେଡ଼ିୟନାଗାଙ୍କ୍ ଆରାମ୍ ମାଡ଼ି ୱେରଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ପେଇସ୍ ସାରେତଡ଼୍ ଆଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ମେଣ୍ଡେ, ଜିସୁ ତାଲେତେସ୍ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଅଡ଼୍‌ ବେକେ ? ନିକିଂଙ୍କ୍ ଦଣ୍ଡ୍ ହିଦାଙ୍କ୍ ୱେରଣ୍ଡ୍‍ବା ହିଲ୍‍ଲେଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ଆଦ୍ କେତ୍‍ତେ, “ବେନ ଇଲାଡ଼୍, ପ୍ରବୁ ।” ତାନ୍‍ପେର୍କେ ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ବା ନିକିଂଙ୍କ୍ ଦଷି ମାଡ଼ନ୍; ଅନ୍‌, ନେଣ୍ଡ୍‍କଞ୍ଜ୍ ମେଣ୍ଡେ ପାପ୍ ମାଡ଼୍‍ମା ।” ");
INSERT INTO kff_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜିସୁ ମେଣ୍ଡ୍‍ନ୍ ଦାମ୍ ନାରୁଡ଼୍‍କ୍ ଶିକ୍ଷା ଇସ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଜଗତ୍‍ତେ ୱେସ୍; ବେନ ନା ପେର୍‍କେ ୱାଦ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବେସୁଙ୍କ୍‍ ବା ଇକାଡ଼୍‍ତା ଆଦାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍, ବେଲାନ୍ ଜିୱୁତେ ୱେସ୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ଆଗାଙ୍କ୍ ପାରୂଶୀନଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ ନିଜେ ନିଜେତ୍ ବିଷୟ୍ ସାକ୍ଷ୍ୟ ଇଦୁତିନ୍, ନିୱାଦ୍ ସାକ୍ଷ୍ୟ ସତ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜିସୁ ଅଡ଼୍‌‍କ୍ ଉତ୍ତର୍ ଇତ୍‍ତନ୍, “ଇଲେ, ନାନ୍ ଯଦି ନିଜେତ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ଇଦୁତାନ୍ ଆଲେକେ ମିକା ନାୱାଦ୍ ସାକ୍ଷ୍ୟ ସତ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ବେନ୍ ପଡ଼ିୟେ ତାଗାଙ୍କ୍ ୱାସ୍ ମିନ୍ଦେନ୍ ନୁ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ଆଦ୍‍ତନ୍, ଆଦ୍ ପୁତ୍‍ତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ବେନ୍ ପଡ଼ିୟେତାଗାଙ୍କ୍ ୱାଦ୍‍ତାନ୍ ନୁ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ଆଦ୍‍ତନ୍, ଆଦ୍ ମିଡ଼୍ ପୁନ୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ମିଡ଼୍ ନାରୁଡ଼୍ ଲେକାମ୍ ବିଚାର୍ ମାଡ଼ ମାନୁଟ୍, ନାନ୍ ବେନନାଦ୍ ବିଚାର୍ ମାଡ଼ନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଯଦି ବିଚାର୍ ମାଡ଼ିତାନ୍, ଆଲେକେ ମିକା ନାୱାଦ୍ ବିଚାର୍ ସତ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ୱେରନ୍ ଆୟନ୍, ମାତର୍ ନାୱାଦ୍ ୱାଦାନ୍‍କର୍ତ୍ତାଲ୍ ନା ସାଙ୍ଗେ ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ମେଣ୍ଡେ, ଇର୍‍ଉଡ଼ାଦ୍ ସାକ୍ଷ୍ୟ ସମାନ ଆତ୍‍କେ, ଅଡ଼୍‌ କେତାନାଦ୍ ସତ୍, ଇଦ୍ ମିଇ ନିୟମ୍‍ତାଗ୍ ଲେକ୍‍ତାଦ୍ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ନାନ୍ ନିଜେ ନିଜେତାଦ୍ ସାକ୍ଷି, ମେଣ୍ଡେ ନା ୱାଦାନ୍ କର୍ତ୍ତାଲ୍ ବାବାଲ୍ ନା ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ଇସମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ମିଇ ବାବାଲ୍ ବେକେ ?” ଜିସୁ ଉତ୍ତର୍ ଇତ୍‍ତନ୍, “ମିଡ଼୍ ନାକିଂଙ୍କ୍ ପୁନ୍‍ୱିଡ଼୍ ବା ନା ବାବାଙ୍କ୍ ମିକା ପୁନ୍‍ୱିଡ଼୍ ଯଦି ନାକିଂଙ୍କ୍ ପୁନେଡ଼ି, ଆଲେକେ ନା ବାବାଙ୍କ୍ ଆନ୍‌‍ତେ ପୁନେଡ଼ି ।” ");
INSERT INTO kff_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ଅଣ୍ଡ୍‌ ମନ୍ଦିର୍‍ତାଗ୍ ଶିକ୍ଷା ଇସମାନ୍ଦାନ୍ ୱେଲେ ଦାନବାକ୍ସ ମାନ୍ଦାନ୍ ବାକ୍‍ଡ଼ାତାଗ୍ ଆନ୍‌‍ତେ ଇଦ୍‍ସାରେ ଶିକ୍ଷା କେତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ଅଂକିଙ୍କ୍‌ ପଇୟଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅନାଦ୍‌ ଦିନାମ୍ ଆସୁଙ୍କ୍‍ଯାକ ଉପସ୍ଥିତ ଆୟିୱେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଜିସୁ ମେଣ୍ଡନ୍‍ଦାମ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଆଞ୍ଜମିନ୍ଦେନ୍, ମେଣ୍ଡେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେହେକିତିଡ଼୍ ନୁ ମିଡ଼୍ ପାପ୍‍ତାଗ୍ ଡଲିତିଡ଼୍, ନାନ୍ ବେଗେ ଆଦୁତାନ୍, ମିଡ଼୍ ଆଗେ ଆଦ୍‍ପାର୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ତାନ୍ ପେର୍‍କେ ଯିହୁଦୀନଡ଼୍ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ କେସମିନ୍ଦେନ୍, ଅଣ୍ଡ୍‌ ବେଗେ ଆଦ୍‍ତନ୍, ମାନାଡ଼୍‍ ଆଗେ ଆଦେପାର୍‌ୱାଡ଼୍ । ଅଣ୍ଡ୍‌ ଆଉକାନଙ୍କ୍ ମାଡ଼ାଙ୍କ୍ ଆଦୁତନ୍ କି ?” ");
INSERT INTO kff_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଇଦ୍ ଜଗତ୍‍କଞ୍ଜ୍‍ ଜନମ୍, ନାନ୍ ସ୍ୱର୍ଗକଞ୍ଜ୍ ଜନମ୍, ମିଡ଼୍ ଇ ଜଗତ୍‍ତଡ଼ି, ନାନ୍ ଇ ଜଗତ୍‍ତଣ୍ଡ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ମିଡ଼୍ ଯେ ନିଜେ ନିଜେ ପାପ୍‍ତାଗ୍ ଡଲିତିଡ଼୍, ନାନ୍ ମିକିଂଙ୍କ୍ ଇଦ୍ କେତୁତାନ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ‘ନାନ୍ ଯେ ନିଜେ ଅଣ୍ଡ୍‌, ଇଦ୍ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼କଟ୍ ମାତ୍‍କେ ନିଜେ ନିଜେ ପାପ୍‍ତାଗ୍ ଡଲିତିଡ଼୍ ।’” ");
INSERT INTO kff_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ ବେନ ?” ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଆଦ୍‍ଗଟ୍‍ ମୁନେନ୍ କେସ୍‍ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ମିଇ ବିଷୟ କେତାଙ୍କ୍ ନୁ ବିଚାର୍ ମାଡ଼ାଙ୍କ୍ ନାୱାଦ୍ ନାର୍‍ଗେ ଗଟି ମିନ୍ତେ; ବାତେଙ୍କ୍ ଇତ୍‍କେ, ନା ୱାଦାନ୍ କର୍ତ୍ତାଲ୍ ସତ୍, ମେଣ୍ଡେ ନାନ୍ ଅନାଗାଙ୍କ୍ ବାତେଏ କେଞ୍ଜ୍‍ତାନ୍, ଆଦ୍‍ ସାରେ ଜଗତ୍‍ତାଗ୍ କେସମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ଜିସୁ ତାନ୍ ବାବାନ୍ ବିଷୟ କେସମାତ୍‍ତନ୍ ଆଦ୍ ଅଡ଼୍‌ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ବେସୁଙ୍କ୍‍ ମିଡ଼୍ ନାରୁନ୍ ପିଲେତିଙ୍କ୍ ପର୍‍ର ତେସ୍‍ମାତ୍‍ତିଡ଼୍, ଆସୁଙ୍କ୍ ନାନ୍ ଯେ ଆଦ୍ ନାରୁନ୍ ନୁ ନାନ୍ ନିଜ୍‍ତାଗାଙ୍କ୍ ବାତେଏ ମାଡ଼୍‍ୱେ ବେଲାନ୍ ବାବାଲ୍ ନାକିଂଙ୍କ୍ ବେଦ୍‍ଲେକାମ୍ ଶିକ୍ଷା ଇତ୍‍ତନ୍, ଆଦେଲେକାମ୍ ଇଦ୍ ସାରେ ଗଟି କେସମିନ୍ଦେନ୍, ଇଦ୍ ମିଡ଼୍ ପୁନ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ନା ବାବାଲ୍ ନା ସାଙ୍ଗେ ମିନ୍ଦେନ୍; ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ୱେରଙ୍କ୍ ରହତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ସାରେଦାମ୍ ଅନାଦ୍‌ ସାୟେତ୍ ପାଡ଼୍‍ୟି ମାଡ଼ୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜିସୁ ଇଦ୍ ସାରେ ଗଟି କେତ୍‍ତାଙ୍କ୍, ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌‍ଆଗାଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ତାନ୍‍ପେର୍କେ ଜିସୁ ଅନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ମାନ୍ଦାନ୍ ଯିହୁଦିନଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍; “ଯଦି ନାୱାଦ୍ ବାକ୍ୟ ନିଜାମ୍‍ ପାଲନ୍ ମାଡ଼ିତିଡ଼୍, ଆଲେକେ ମିଡ଼୍ ସାରେଦାମ୍ ନା ଶିଷ୍ୟଡ଼ି, ");
INSERT INTO kff_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ମେଣ୍ଡେ ମିଡ଼୍ ସତ୍ ପେଇତିତିଡ଼୍ ନୁ ଆଦ୍ ସତ୍ ମିକିଂଙ୍କ୍ ମୁକ୍ତମାଡ଼ିତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ମାମ୍‍ମେ ଅବ୍ରାହାମ୍‌ ବଂଶତେ ନାରୁମ୍‌, ମେଣ୍ଡେ ବେସୁଙ୍କ୍‍ ମିକା ବେନନ୍‌ ଦାସ ଆୟୱାଡ଼୍, ଆଲେକେ ମିଡ଼୍ ମୁକ୍ତ ଆଦ୍‍ତିଡ଼୍ ଇଞ୍ଜ ମିଡ଼୍ ବେଲାକେତୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜିସୁ ଅଡ଼୍‌‍କ୍ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ବେନବା ପାପ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ପାପ୍ ତେ ଦାସ । ");
INSERT INTO kff_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ଦାସ ସାରେ ଦିନାତାତ୍‍ ସେଙ୍ଗେ ପରିବାର୍‍ତେ ୱେରନ୍ ଆସ୍‍ମାନନ୍ । ବାତେଙ୍କ୍‍ଇତ୍କେ ପରିବାର୍‍ତେ ମାର୍‍ଦେ ପଡ଼ିୟେ ସାରେଦିନା ମାନ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ମାର୍‍ ଯଦି ମିକିଂଙ୍କ୍ ମୁକ୍ତ ମାଡ଼ିତନ୍, ଆଲେକେ ମିଡ଼୍ ପ୍ରକୃତ୍‍ରେ ମୁକ୍ତ ଆସ୍‍ମାନ୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ମିଡ଼୍ ଯେ ଅବ୍ରାହାମ୍‌ ତେ ପିଲା, ଆଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାୱାଦ୍ ବାକ୍ୟ ମିଇ ଜିୱେତାଗ୍ ଇଲ୍‍ୱାଙ୍କ୍ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଆଉକାନଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ନାନ୍ ବାବାନ୍ ପାକେ ବାତ୍ ବାତ୍ ଉଡ଼ିମିନ୍ଦେନ୍, ଆଦ୍ ସାରେ କେସ ମିନ୍ଦେନ୍; ମିଡ଼୍ ମିକା ମିଇ ବାବାନ୍ ନାଗାଙ୍କ୍ ବାତ୍ ବାତ୍ କେସମିନ୍ଦେନ୍ ଆଦ୍‍ ସାରେ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ କେତ୍‍ତଡ଼୍, “ଅବ୍ରାହାମ୍ ମାନ୍‍ ବାବାଲ୍,” ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଯଦି ମିଡ଼୍ ଅବ୍ରାହାମ୍‌ତେ ପିଲାନଡ଼ି, ଆଲେକେ ଆବ୍ରାହାମ୍ ତେ ପାଡ଼୍‍ୟି ମାଡ଼ାଟ୍; ");
INSERT INTO kff_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯେ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ କେଞ୍ଜିମାନ୍ଦାନ୍‍ ସତ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ଇଦ୍‍ଲେକାମ୍ ନାରୁନ୍ ଯେ ନାନ୍, ନାକିଂଙ୍କ୍ ମିଡ଼୍ ଇଞ୍ଜେ ଆଉକାନଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼ୁତିଡ଼୍; ଅବ୍ରାହାମ୍‌ ଇଦ୍‍ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ମିଡ଼୍ ମିଇ ବାବାନ୍ କାମ୍‍ସାରେ ମାଡ଼ମିନ୍ଦେଡ଼ି,” ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ମାମ୍‍ମେ ବ୍ୟବିଚାର୍ ଲେକାମ୍ ଇଲେମ୍ ମାୟାଗାଙ୍କ୍ ମାତର୍ ୱେରନ୍ ବାବାଲ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଶ୍ୱର୍ ଯଦି ମିଇ ବାବାଲ୍ ଆୟେଣ୍ଡ୍, ଆଲେକେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼େଡ଼ି; ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାସ୍ ଇଞ୍ଜେ ହିଗେ ମିନ୍ଦେନ୍; ନାନ୍ ନିଜେ ତାଗାଙ୍କ୍ ୱାଡ଼ନ୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ରହସ୍‍ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ନାନ୍ ବାତେଏ କେତୁତାନ୍ ମିଡ଼୍ ବାତ୍‍ତିଙ୍କ୍ ନା ଗଟି ବୁଜେମ୍ ଆୟ୍‍ୱିଡ଼୍ ? ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ନାୱାଦ୍ ବାକ୍ୟ କେଞ୍ଜି ସାରେ ମାଡ଼୍‍ପେ ପାର୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ମିଡ଼୍ ମିଇ ବାବାଲ୍ ଶୟତାନ୍‍ତେ ମାର୍‍; ଅନ୍‌ ଇଚ୍ଛାତେ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିତିଡ଼୍ । ସୃଷ୍ଟିଆତେ ମୁନେଙ୍କ୍ କଞ୍ଜ୍ ମାତ୍‍ତନ୍ ଆୱୁକାନାଦ୍ । ଅଣ୍ଡ୍‌ ବେସୁଙ୍କ୍‌ବା ସତ୍‍ତେ ବାବାଲ୍ ଆୟନ୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅନାଗେ ସୁଦୁଟ୍ ମିକା ସତ୍ ଇଲ୍‍ଲେ । ମିଚ୍ କେତାନାଦ୍ ଅନାଗ୍ ସ୍ୱାବାବିକ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନିଜେ ମିତ୍ୟାବାଦି ନୁ ସୁଦୁଟ୍ ମିତ୍ୟାତେ ବାବାଲ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ସତ୍ କେଲ୍‍ନାଙ୍କ୍ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ନାୟାଗ୍ ପାପ୍ ମିନ୍ଦେଇଞ୍ଜ ମିୟାଗାଙ୍କ୍ ବେନ ପ୍ରମାନ୍ ଇତ୍‍ତଡ଼୍ ? ନାନ୍ ବେସୁଙ୍କ୍‍ ସତ୍ କେତିତାନ୍, ଆଲେକେ ମିଡ଼୍ ବାତ୍‍ତିଙ୍କ୍ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ବେନ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ଜନମ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ କେଞ୍ଜିତଣ୍ଡ୍; ଇଦିନ୍ ମାଇଦିଙ୍କ୍ ମିଡ଼୍ କେଞ୍ଜ୍‍ୱିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ଜନମ୍ ଆୟୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଯିହୁଦୀନଡ଼୍ ଜିସୁଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ନିମ୍‍ ଯେ ୱେରନ୍ ଶୋମିରଣିୟ ନୁ ନିକିଂଙ୍କ୍ ଯେ ବୁତ୍ ପଇସ୍‍ମିନ୍ଦେ, ଇଦ୍ ବାତେଏ ମାମ୍‍ମେ ଟିକ୍ କେଲମ୍ କି ?” ");
INSERT INTO kff_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାକିଂଙ୍କ୍ ବୁତ୍ ପୟ୍‍ୟ, ନାନ୍ ନା ବାବାଙ୍କ୍ ସମାଦର୍‍ ମାଡ଼ୁତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଅନାଦର୍ ମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନିଜେ ନିଜେତ୍ ଗୌରବ୍‍ତେ ପେର୍‍କେ ଆନୁଟ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଦ୍ ଗଟ୍ ନା ସେଙ୍ଗେ ମେଣ୍ଡେଅର୍‍ତୁନ୍ ନୁ ନା ପାକେଙ୍କ୍ ବିଚାର୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ବେନ ନାୱାଦ୍ କେତାନାଦ୍ ପାଲନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବେସୁଙ୍କ୍‌ବା ଡଲନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଯିହୁଦୀନଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ଇଞ୍ଜେ ମାମ୍‍ମେ ପୁତ୍‍ତମ୍ ଯେ, ନିକିଂଙ୍କ୍ ବୁତ୍‌ପଇସ୍ ମିନ୍ଦେ, ଅବ୍ରାହାମ୍‌ ନୁ ବାବବାଦିଡ଼ି ଡଲିମିନ୍ଦେଡ଼୍, ମେଣ୍ଡେ ନିମ୍‍ କେତୁତିନ୍, ଯଦି ବେନ ନାୱାଦ୍ କେତାନାଦ୍ ପାଲନ୍ ମାଡ଼ିତନ୍, ଆଲାଇତ୍‍କେ ଅନାଗେ ବେସୁଙ୍କ୍‌ବା ଡଲ୍‍ନାଦ୍ ମାନ୍‍ନ । ");
INSERT INTO kff_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ମା ଆନିଦାଦିଡ଼୍ ଡଲିମିନ୍ଦେଡ଼୍ ନୁ ବାବବାଦିଡ଼୍ ମିକା ଡଲ୍‍ତଡ଼୍ ବାବାନି ଅବ୍ରାହାମ୍‌ ଲେକାମ୍ ନିମ୍‍ ସାୟେ ? ଅଣ୍ଡ୍‌ ତ ଡଲିମିନ୍ଦେନ୍, ନିମ୍‍ ନିଜ୍‍ତିଙ୍କ୍ ବେନ ଇଞ୍ଜ୍ କେତୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଯଦି ନିଜ୍‍ତିଙ୍ଗ୍ ଗୌରବ୍‍ ବାନ୍ୱିତ ମାଡ଼ାଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼େନ୍ ଇଦିନାଦ୍ ବାତେବା ମୁଲ୍ୟ ମାନ୍‍ନ ଆୟେଡ଼୍‍ । ବେନ ନାକିଂଙ୍କ୍ ଗୌରବ୍ ବାନ୍ୱିତ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନା ବାବାଲ୍, ବେନଙ୍କ୍ ମିଡ଼୍ ନିଜେତ୍ ଇଶ୍ୱର୍ ଇଞ୍ଜ କେତୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ବେସୁଙ୍କ୍‍ ପୁନ୍‍ୱିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଅଂକିଙ୍କ୍‌ ପୁତ୍‍ତାନ୍ । ନାନ୍ ଅଂକିଙ୍କ୍‌ ପୁନନ୍ ଇଞ୍ଜ ଯଦି କେତିତାନ୍, ଆଲେକେ ନାନ୍ ମିକା ମିଇ ଲେକାମ୍ ମିତ୍ୟାବାଦି ଆଦ୍‍ତନ୍, ନାନ୍ ଅଂକିଙ୍କ୍‌ ପୁତ୍‍ତାନ୍ ନୁ ଅନାଦ୍‌ ବାକ୍ୟ ପାଲନ୍ ମାଡ଼ୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ମିଇ ବାବାଲ୍ ଅବ୍ରାହାମ୍‌ ନାୱାଦ୍ ୱାଦାନାଦ୍ ଦିନ୍ ଉଡାଙ୍କ୍ ଆଶେତେ ୱେଡ଼୍‍କିତନ୍, ମେଣ୍ଡେ ଆଦ୍ ଅଣ୍ଡ୍‌ ଉଡ଼ି ୱେଡ଼୍‍କା ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ଅବ୍ରାହାମ୍‌ ତାଗାଙ୍କ୍ ଯିହୁଦିନଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ନିକିଂଙ୍କ୍ ତ ଇଞ୍ଜେ ପଚାଶ୍‍ବର୍ଷ ବୟଷ୍ ମିକା ଆୟକେ, ନିମ୍‍ ବାତେଏ ଅବ୍ରାହାମ୍‌ ତିଙ୍କ୍ ଉଡ଼୍‍ତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଅବ୍ରାହାମ୍‌ ତେ ଜନମ୍ ମୁନେଙ୍କ୍ କନ୍‍ସ୍ ନାନ୍ ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଅନ୍‌ ପର୍‍ର ହେସାନ୍ ମାଇଦିଙ୍କ୍ କାଲ୍‍କ୍ ପେହେକ୍ ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ମୀଞ୍ଜି ମନ୍ଦିର୍‍ତାଗାଙ୍କ୍ ପେଇସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ଜିସୁ ହାର୍‍ଦାଗ୍ ଆଦାନ୍ ୱେଲେ ୱେରଣ୍ଡ୍ ଜନମ୍ କାନାଙ୍କ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ମେଣ୍ଡେ, ଅନ୍‌ ଶିଷ୍ୟନଡ଼୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ହୋ ଗୁରୁ, ବେନ ପାପ୍ ମାଡ଼୍‍ତାଙ୍କ୍ ଇଣ୍ଡ୍ କାନାଲ୍ ଆସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ? ତାନ୍ ନିଜେତାଦ୍ ନା ତାମ୍ ୟାୟ୍‍ ବାବାଲଡ଼ାଦ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଅନ୍‌‍ୱାଦ୍ ବା ଅନ୍‌ ୟାୟ୍‍ ବାବାଲ୍ ପାପ୍ ମାଡ଼ଡ଼୍‍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ ଶକ୍ତିତାଦ୍‍ ପାଡ଼୍‍ୟି ବେଲାନ୍ ଇନାଗେ ତିଆର୍ ଆଦ୍‍ତେ, ଆଦିନ୍ ସେଙ୍ଗେ ଇଦ୍ ଗଟେମ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ଦିନାମ୍ ମାଞ୍ଜ୍ ମାଞ୍ଜ୍ ନା ୱାଦାନ୍‍କର୍ତ୍ତାଲ୍ ଇଶ୍ୱର୍‌ତେ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ମାନାଦ୍‍ ପାଡ଼୍‍ୟି; ବେନ୍ ସମୟ୍‍ତେ ବେନ୍ ପାଡ଼୍‍ୟି ମାଡ଼େପାର୍‍ୱଣ୍ଡ୍, ଇଦ୍‍ଲେକାମ୍ ଇକାଡ଼୍ ୱାସମିନ୍ଦେ ବେସୁଟ୍‌ ବେନ ବାତେଏ ପାଡ଼୍‍ୟି ମାଡ଼େପାର୍‍ୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ନାନ୍ ବେସୁଙ୍କ୍‍ଯାକ ଜଗତ୍‍ତାଗ୍ ମିନ୍ଦେନ୍, ଆସୁଟେ ଯାକ ନାନ୍ ଜଗତ୍‍ତେ ୱେସ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଇଦ୍ କେତ୍‍ତେ ପେର୍‍କେ ଜିସୁ ନେଲ୍ ଉସି ଅଣ୍ଡ୍‌ ଉସ୍‍ତାଦିନ୍‍ ତଡ଼୍ ବୁରୁଦା ମାଡ଼୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଅନାଦ୍‌ ରେଣ୍ଡେ କଣ୍ଡାନାଗ୍ ବୁରୁଦା ତମି ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ଅନ୍‌, “ଶିଲୋହ ଏର୍‍ୱିନାଗ୍ ମକମ୍ ନର୍‍ମ୍ ।” ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌, ପେଇସ୍ ଆଞ୍ଜ୍ ନର୍‍ତଣ୍ଡ୍ ନୁ ଅଂକିଙ୍କ୍‌ କଣ୍ଡା ତନ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ଅନ୍‌ ଗାରେତଡ଼୍‍ ନାରୁଡ଼୍ ନୁ ବେନଡ଼୍ ଅଂକିଙ୍କ୍‌ ମୁନେଙ୍କ୍ ତାଲ୍‍କାନାଦ୍ ଉଡ଼ିମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍ “ଇ ନାରୁନ୍ ବାତେଏ କୁଦି ତାଲ୍‍କମାନନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ବେନ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ତ ଅଣ୍ଡେ;” ମେଣ୍ଡେ ବେନ୍ ବେନ କେତ୍‍ତଡ଼୍, “ଇଲା, ଇଣ୍ଡ୍, ଅନ୍‌ ଲେକାମ୍ ।” ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଆ ନାରୁନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ଆଲାଇତ୍‍କେ ନିୟାଉ କୋଣ୍ଡା ବେଲା ତନ୍ଦ୍‍ତା ?” ");
INSERT INTO kff_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ଅଣ୍ଡ୍‌ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍, “ବେନଙ୍କ୍ ଜିସୁ ଇଞ୍ଜ କେତିତଡ଼୍‍, ଆ ନାରୁଣ୍ଡ୍‌ ବୁରୁଦା ମାଡ଼ି ନାୱାଉ ରେଣ୍ଡ୍ କୋଣ୍ଡାନାଗ୍ ବୁରୁଦା ତମିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ନାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଶିଲହ ତାଗ୍ ଆଞ୍ଜ୍ ମକମ୍ ନର୍‍ମ୍, ଆଦିଙ୍କ୍ ନାନ୍ ପେଇସ୍ ଆଞ୍ଜ୍ ନର୍‍ତାନ୍ ନୁ ମେଣ୍ଡେ ନାୱାଉ କଣ୍ଡା ତନ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ବେକେ ?” ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ପୁନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ବେନ ମୁନେଙ୍କ୍ କାନାଲ୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌ କାନାଙ୍କ୍ ପାରୂଶୀନଡ଼୍ ପାକେ ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜିସୁ ବେନ୍ ଦିନ୍ ବୁରୁଦା ମାଡ଼ି ଅନ୍‌ କୋଣ୍ଡାଙ୍କ୍ ୱେସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ଆଦ୍ ଦିନ୍ ବିଶ୍ରାମ୍‍ଦିନେ ଦିନ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ଅଣ୍ଡ୍‌ ବେଲା କଣ୍ଡା ଉଡ଼୍‍ତଣ୍ଡ୍, ଆଦ୍ ପାରୂଶୀଡ଼୍ ମିକା ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ କେତାନଙ୍କ୍ କେତ୍‍ତଡ଼୍, ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଅଣ୍ଡ୍‌ ନା କଣ୍ଡାନାଗ୍ ବୁରୁଦା ତମିତ୍‍ତଣ୍ଡ୍, ତାନ୍‍ପେର୍କେ ନାନ୍ ଶିଲହ ତାଗ୍ ଆଞ୍ଜ୍ ନର୍‍ତାନ୍ ନୁ ଉଡ଼୍‍ପାର୍‍ତାନ୍,” ଇଞ୍ଜେ ନାନ୍ ଉଡ଼୍‍ ପାର୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ପାରୂଶୀଡ଼୍ ଡ଼ାଗାଙ୍କ୍ ବେନ କେତ୍‍ତଡ଼୍, “ବେନ ଇ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାଡ଼ନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବିଶ୍ରାମ୍‍ଦିନେ ପାଲନ୍ ମାଡ଼ନ୍ ।” ବାଗାତଡ଼୍ କେତ୍‍ତଡ଼୍, “ୱେରନ୍ ପାପି ଆସ୍ ଇଦ୍ ଲେକାମ୍ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼େପାର୍‍ତନ୍ ?” ଇ ବିଷୟ ତେ ଅଡ଼୍‌‍ଲୋପେ ମତବେଦ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଆଦ୍ କାନାଙ୍କ୍ ପଚ୍ରାରା ମାଡ଼୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ଯେ ନି କଣ୍ଡାଙ୍କ୍ ସାୟେ ମାଡ଼୍‍ତେନଣ୍ଡ୍, ଆଗାଙ୍କ୍ ନିମ୍‍ ଅନ୍‌ ବିଷୟ୍‍ତେ ବାତେଏ କତୁତିନ୍ ?” ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ବାବବାଦି ।” ");
INSERT INTO kff_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ଅଣ୍ଡ୍‌ ଯେ କାନାଲ୍ ମାତ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ କଣ୍ଡା ତନ୍ଦିତା, ଆ କାନାନ୍ ୟାୟ୍‍ ବାବାଲ୍ କେଲ୍‍ୱେ ଯାକ ଯିହୁଦୀ ନେତାନଡ଼୍ ଆଦ୍ ଅନ୍‌ ମୁନେ ବିଶ୍ୱାସ୍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ଅଡ଼୍‌ ୟାୟ୍‍ ବାବାଙ୍କ୍ କେତ୍‍ତଡ଼୍, ମିଇ ବେନ୍ ମାର୍‍ କାନାଲ୍ ଆସ୍ ଜନମ୍ ଆସ୍‍ମାତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ କେସମିନ୍ଦେଡ଼ି, “ଇଣ୍ଡ୍ ବାତେଏ ମିଇ ମାର୍‍ ? ଆଲାଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବେଲା ଇଞ୍ଜେ ଉଡ଼ୁତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ଆଗାଙ୍କ୍ ଅନ୍‌ ୟାୟବାବାଡ଼୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ଯେ ମାନ୍‍ ମାର୍‍ ନୁ ଇଣ୍ଡ୍ ତ କାନାଲ୍ ଆସ୍ ଜନମ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ ଇଦ୍ ଯେ ମାମ୍‍ମେ ପୁତ୍‍ତମ୍; ");
INSERT INTO kff_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଣ୍ଡ୍ ବେଲା ଇଞ୍ଜେ ଉଡ଼ୁତଣ୍ଡ୍, ଆଦ୍ ପୁନମ୍, ବେନ ଅନାହୁ କଣ୍ଡା ସାୟେମାଡ଼ିତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ବାଡ଼େ ମାମ୍‍ମେ ପୁନମ୍, ଅଂକିଙ୍କ୍‌ କେଲ୍‍ମୁଟ୍, ଅଣ୍ଡ୍‌ ତ ବୟସ୍‍ତେ ମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିଇ ଗଟି ଜାମେ କେତିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ତାମ୍ ୟାୟ୍‍ ବାବାଲଡ଼୍ ଯିହୁଦୀ ନେତାନଡ଼୍ ୱେର୍‍ସ୍‍ମାନାଙ୍କ୍ ଇଦ୍ ସାରେ ଗଟି କେତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯଦି ବେନ ଆଦିଙ୍କ୍ ମସିହ ଇଞ୍ଜ ସ୍ୱୀକାର୍ ମାଡ଼୍‍କେ, ଆଲେକେ ଅଣ୍ଡ୍‌ ସମାଜ୍ ବାଇଦେ ମାଡ଼ାନଙ୍କ୍ ଇଞ୍ଜ ମୁନେଙ୍କ୍ ଯିହୁଦୀନଡ଼୍ ୱେରଡ଼୍ ମାନ୍‍ ଆସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅନ୍‌ ୟାୟ୍‍ ବାବାଲ୍ କେତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ବୟସ୍‍ତେ ମିନ୍ଦେଣ୍ଡ୍ ଅଂକିଙ୍କ୍‌ କେଲ୍‍ମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ଆଗାଙ୍କ୍ ମୁନେଙ୍କ୍ କଞ୍ଜ୍ କାନାଲ୍ ଆସ୍ ମାନ୍ଦାନ୍ ନାରୁଙ୍କ୍ ଅଡ଼୍‌ ଦ୍ୱିତିୟ ଦାମ୍ କେତ୍‍ତଡ଼୍, “ଇଶ୍ୱତିଙ୍କ୍ ସମ୍ମାନ୍ ଇସ୍ କେତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଯେ ପାପି, ଇଦ୍‍ମାମେ ପୁତ୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଅଣ୍ଡ୍‌ ପାପି କି ଇଲ୍‍ଲେ, ନାନ୍ ଆଦ୍ ପୁନନ୍; ନାନ୍ ଅଣ୍ଡୟ୍‌ ବିଷୟ ପୁତାନ୍, ନାନ୍ କାନାଲ୍ ଆସ୍ ମାତାନ୍, ଇଞ୍ଜେ ଉଡ଼େ ପାର୍‍ଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ଆସୁଙ୍କ୍ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ନିକିଂଙ୍କ୍ ବାତେଏ ମାଡ଼ିତନ୍ ? ଅଣ୍ଡ୍‌ ବେଲା ନିୟାଉ କଣ୍ଡାଙ୍କ୍ ସାୟେମାଡ଼୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ କେସ୍ ତେର୍‍ତାନ୍, ମେଣ୍ଡେ ମିଡ଼୍ କେଞ୍ଜ୍‍ତିଡ଼୍; ବାତେଙ୍କ୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ କେଞ୍ଜାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍ ?” ବାତେଙ୍କ୍‍ଇତ୍କେ ମିଡ଼୍ ଆନ୍‌‍ତେ ଅନ୍‌ ଶିଷ୍ୟ ଆତ୍‍ତାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଅବିଶାପ୍‌ ଇସ୍‌ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ ଆଗେତ୍ ଶିଷ୍ୟ, ମାମ୍‍ମେ ମୋଶାନ୍‌ ଶିଷ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ମାମ୍‍ମେ ପୁତ୍‍ତମ୍ ଯେ, ଇଶ୍ୱର୍ ମୋଶାଙ୍କ୍ ଗଟ୍ କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇ ନାରୁଣ୍ଡ୍‌ ବେଗାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ଆଦ୍ ମିକା ମାମ୍‍ମେ ପୁନମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ଆ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନା କଣ୍ଡାଙ୍କ୍ ସାୟେମାଡ଼ି ମିନ୍ଦେଣ୍ଡ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ବେଗାକନ୍‍ସ୍ ୱାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ମିଡ଼୍ ପୁନ୍‍ୱିଡ଼୍, “ଇଦ୍ ତ ଆଶର୍ଯ୍ୟ ଗଟ୍ । ଅଂକିଙ୍କ୍‌ ମିଡ଼୍ ପୁନ୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ଇଶ୍ୱର୍ ଯେ ପାପୀଡ଼୍ ଗଟି କେଞ୍ଜଣ୍ଡ୍, ଇଦ୍ ମାମ୍‍ମେ ପୁତ୍‍ତମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯଦି ବେନ ଇଶ୍ୱର୍‌ତେ ବକ୍ତ ଆସ୍ ଅନାଦ୍‌ ଇଚ୍ଛା ସାଦନା ମାଡ଼ିତନ୍, ଆଲେକେ ଆଦ୍ ଅନ୍‌ ଗଟ୍ କେଞ୍ଜିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ତିଆର୍‍ତେ ଆରାମ୍ ଆତ୍‍ତାଗାଙ୍କ୍ ବେନ କାନାଙ୍କ୍ କଣ୍ଡାଙ୍କ୍ ସାୟେମାଡ଼୍‍ତଣ୍ଡ୍, ଇଦ୍ ତ ବେସୁଙ୍କ୍‍ କେଞ୍ଜ୍‍ୱେ ମାତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଇ ନାରୁଡ଼୍ ଇଶ୍ୱର୍ ତାଗାଙ୍କ୍ ୱାଡ଼୍‍ୱେକଟ ମାତ୍‍କେ ଅଣ୍ଡ୍‌ ବେସୁଟ୍‌ ହିଦ୍ ପାଡ଼୍‍ୟି ମାଡ଼େପାର୍‍ୱଣ୍ଡ୍ ଆୟେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ନିମ୍‍ ତ ସାରେ ପାପ୍ ତାଗାଙ୍କ୍ ଜନମ୍ ଆଦ୍‍ତିଡ଼୍ ନୁ ପାପ୍‍ତାଗ୍ ପେର୍‍ସ୍ତି, ମେଣ୍ଡେ ନିମ୍‍ ମାକିଂଙ୍କ୍ ଶିକ୍ଷା ଇଦୁତିନ୍ ?” ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ବାଇଦେ ପେସ୍‍ପିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ସମାଜ୍ ଲତ୍‍ତାଗାଙ୍କ୍ ବାଇଦେ ପେସ୍‍ପିତ୍‍ତଡ଼୍, ଜିସୁ ଇଦ୍ କେଞ୍ଜି ଅଂକିଙ୍କ୍‌ କାଇଲି କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତେଏ ନାରୁନ୍ ପିଲ୍‌ତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ଅଣ୍ଡ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ହୋ ଗଟ୍, ଅଣ୍ଡ୍‌ ବେନ କେଲ୍‍ମ୍, ବେଲାକି ନାନ୍ ଅନାଗ୍ ବେଲା ବିଶ୍ୱାସ୍ ମାଡ଼ିତାନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ିମିନ୍ଦେନି, ମେଣ୍ଡେ ବେନ ନି ତଡ଼୍ ଗଟି କେସମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡେ ଆଦ୍ ନାରୁଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ, ନାନ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତାନ୍ !” ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ମୋର୍‍ମିଣ୍ଡାଇସ୍ ପ୍ରନାମ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ମେଣ୍ଡେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ନାରୁଡ଼ାଦ୍ ବିଚାର୍ ମାଡ଼ାଙ୍କ୍ ନାନ୍ ଜଗତ୍‍ତାଗ୍ ୱାସ୍‍ମିନ୍ଦେନ୍, ଉଡ଼୍‍ୱେ ମାନ୍ଦାନ୍ ନାରୁନ୍ ବେଲା ଉଡ଼ିତଣ୍ଡ୍ ନୁ ଉଡ଼ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ବେଲାକି କାନାଲ୍ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ପାରୂଶୀଡ଼୍ ଡ଼ାଗାଙ୍କ୍ ବେନଡ଼୍ ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଆଦ୍ କେଞ୍ଜି ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ମାମ୍‍ମେ ବାତ୍‍ତେ କାନାମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “କାନାଲ୍ ଆସ୍ ମାତ୍‍କେ ମିଡ଼୍ ଦସି ଆୟ୍‍ୟ ଆୟେଡ଼ି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାମ୍‍ମେ ଉଡ଼ୁତମ୍, ଇଦ୍ ଇଞ୍ଜେ କେତୁତିଡ଼୍, ମିୱାଦ୍ ପାପ୍ ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ବେନ ହାର୍‍ଇସ୍ ମେଣ୍ଢା ଗୁଡ଼ୁସା ତାଗ୍ ନେଙ୍ଗଣ୍ଡ୍, ମାତର୍ ଗୁଡ଼୍‍ସାତିଙ୍କ୍ ତୁଲି ନେଙ୍ଗୀତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଡଙ୍ଗାଲ୍ ବା ଡକାଇତ୍; ");
INSERT INTO kff_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ହାର୍‍ଇସ୍ ଆଦ୍‍ତଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ମେଣ୍ଢା ମେଇତାନଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ମାର୍‍ ତେର୍‍ତାନଣ୍ଡ୍ ଆୱିନ୍‌ ମାଇଦିଙ୍କ୍ ମାର୍‍ ଟେଣ୍ଡିଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ମେଣ୍ଢା ଅନାଦ୍‌ ଲେଙ୍ଗ୍ କେଞ୍ଜିତା, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ନିଜ୍‍ତାଉ ମେଣ୍ଢାକିଂଙ୍କ୍ ପେଦେର୍ ପଇସ୍ କାର୍‍ଙ୍ଗି ବାଇଦେ ପେସ୍‍ପି ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ଅଣ୍ଡ୍‌ ନିଜ୍‍ତାଉ ମେଣ୍ଢାଙ୍କ୍ ବାଇଦେ ପେସ୍‍ପ୍‍ତେ ପେର୍‍କେ ଆୱିନ୍‌ ମୁନ୍‍ ଆଦ୍‍ତନ୍ ନୁ ମେଣ୍ଢା ଅନ୍‌ ପେର୍‍କେ ଆଦ୍‍ତା, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଉ ଅନାଦ୍‌ ଲେଙ୍ଗ୍‍ଦିଙ୍କ୍ ପୁନ୍‍ତାଆ; ");
INSERT INTO kff_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଉ ପୁନ୍‍ୱେ ନାରିନ୍ ପେର୍‍କେ ବେସୁଙ୍କ୍‍ ବା ଅନ୍‌, ମାତର୍ ଆଉ ଅନାଗାଙ୍କ୍ ମିରିତା, ଆଉ ପୁନ୍‍ୱେ ନାରୁନ୍ ଲେଙ୍ଗ୍ ହେନ୍‍ସ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହିଦ୍ ଗଟି କେତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାତ୍ ବାତ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍‍ ସାରେ ବାତେଏ ଅଡ଼୍‌ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ଆଗାଙ୍କ୍ ଜିସୁ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ କେତ୍‍ତଣ୍ଡ୍, “ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ନାନ୍ ନିଜେ ମେଣ୍ଢାକିନ୍ ହାର୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ବେସ୍‌କ୍ ତଡ଼୍ ନା ମୁନେ ୱାସ୍‍ମିନ୍ଦେଡ଼ି, ଅଡ଼୍‌ ସାରେତଡ଼୍ ଡଙ୍ଗା ବା ଡକାଇତ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ସାରେ ମେଣ୍ଢା ଅଡ଼୍‌ ଗଟି କେଞ୍ଜ । ");
INSERT INTO kff_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ନାୟାଦ୍ ମାର୍‍ ଇସ୍, ଯଦି ବେନ ନା ଆଲାଇସ୍ ଆଦ୍‍ତନ୍, ଆଲେକେ ଅଣ୍ଡ୍‌ ରକ୍ଷା ଜିୱେଦର୍‍କିତ୍ ନୁ ଲୋପେୱାସ୍ ନୁ ବାଇଦେଆଞ୍ଜ୍ ତିନ୍ଦାନାହୁ ଦର୍‍କିତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ଡଙ୍ଗାଲ୍ ୱାଦ୍‍ତଣ୍ଡ୍ ଡଙ୍ଗାଙ୍କ୍, ଆୱୁକାନଙ୍କ୍‌ ନୁ ଦଂସ ମାଡ଼ାଙ୍କ୍, ନାନ୍ ୱାତ୍‍ତାନ୍ ମିକିଂଙ୍କ୍ ଜିୱୁଣ୍ଡ୍ ହିଦାନ୍ ସେଙ୍ଗେ, ମିଡ଼୍ ବେଲାକି ଜିୱୁଣ୍ଡ୍‍ତେ ଗାଟି ତିପାଲ୍‍ମାଡ଼େ ପାର୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ନାନ୍ ସାୟେତ୍‍ମେଣ୍ଢା ମେଇତାନନ୍; ସାୟେତ୍‍ମେଣ୍ଢା ମେଇତାନନ୍ ମେଣ୍ଢାନ୍ ମାଇଦିଙ୍କ୍ ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍ ହିଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ବେନ ମୁଲ୍ୟ ଆସ୍ ମେଣ୍ଢା ମେଇତିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମେଇତାନଣ୍ଡ୍ ଆୟ୍‍ୟ, ଅଣ୍ଡ୍‌ କୁକାଲ୍‍ ୱାଦାନାଦ୍ ଉଡ଼ି ମେଣ୍ଢାଙ୍କ୍ ୱିଡ଼୍‍ସି ମିର୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ବେନ ମୁଲ୍ୟ ଆସ୍ ମେଇତିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିର୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଗଲାଲ୍ ମେଣ୍ଢାନ୍ ମାଇଦିଙ୍କ୍ ଚିନ୍ତେ ମାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ନାନ୍ ସାୟେତ୍ ମେଣ୍ଢା ମେଇତାନନ୍ । ବାବାଲ୍ ବେଲା ନାକିଂଙ୍କ୍ ପୁତ୍‍ତଣ୍ଡ୍ ନୁ ନାନ୍ ବାବଙ୍କ୍ ପୁତ୍‍ତାନ୍, ");
INSERT INTO kff_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ଆଦ୍‍ଲେକାମ୍ ନାନ୍ ନା ନିଜେତ୍ ମେଣ୍ଢାଙ୍କ୍ ପୁତ୍‍ତାନ୍, ମେଣ୍ଡେ ନାୟାୱୁ ନିଜେତ୍ ମେଣ୍ଢା ନାକିଂଙ୍କ୍ ପୁତ୍‍ତା, ମେଣ୍ଡେ ମେଣ୍ଢାନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ନାୟାଦ୍ ଜିୱୁଣ୍ଡ୍ ଇଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ନାୟାଉ ମେଣ୍ଡେ ବାଗାତାଉ ମେଣ୍ଢା ମିନ୍ଦେ, ବେନା ଇ ଗୁଡ଼ୁସେତ୍ ଲୋପେ ଇଲା । ଆୱିଙ୍କ୍ ମିକା ନାନ୍ ତାତେୱେଇତିତ୍‍ । ଆଉ ନାୟାଦ୍ କାର୍‍ଙ୍ଗା ନାଦ୍ କେଞ୍ଜିତା ନୁ ସାରେ ୱେରଡ଼୍ ଗଲାନ୍ ୱେରଡ଼୍ ଗୁଡ଼୍‍ସା ଆଶେ ମାନ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ନାନ୍ ନାୟାଦ୍ ଜିୱୁନ୍‍ ଇଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତାଙ୍କ୍ ବାବାଲ୍ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ିତନ୍, ନାନ୍ ନାୟାଦ୍ ଜିୱୁତିଙ୍କ୍ ହିତ୍‍କେ, ମେଣ୍ଡ୍‍ନ୍ ଦାମ୍ ନାକିଂଙ୍କ୍ ଜିୱୁଣ୍ଡ୍ ଦର୍‍କିତ୍ ନାୟାଦ୍ ହିଦ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ । ନାନ୍ ନାୟାଦ୍ ବାବାନାଗାଙ୍କ୍ ଇଦ୍ ବୁଦ୍‍ତେ ଇସ୍‍ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ବେନ ନାଗେ ଆଦ୍ ଆୟନ୍, ମାତର୍ ନାନ୍ ନିଜେତ୍ ଇଚ୍ଛାତେ ଆଦ୍ ଦାନ ୱାଟିତାନ୍ । ଆଦ୍ ୱାଟାନଙ୍କ୍ ନାୟାଦ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ ନୁ ନା ବାବାନାଗାଙ୍କ୍ ଇଦ୍ ଗଟ୍ ଇସ୍‍ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଜିସୁନ୍ ଇୱୁସାରେ ଗଟିନ୍‌ ମାଇଦିଙ୍କ୍ ନାରୁଡ଼୍ ଲୋପେ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ମତବେଦ ଗଟେମ୍‍ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ଅଂକିଙ୍କ୍‌ ବୁତ୍ ପଇତେ, ଅଣ୍ଡ୍‌ ବାୟାଲ୍, ବାତ୍‍ତିଙ୍କ୍ ଅନ୍‌ ଗଟି କେଞ୍ଜୁତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ବାଗାତଡ଼୍ କେତ୍‍ତଡ଼୍, “ଇଦ୍‍ସାରେ ଗଟି ତ ବୁତ୍ ପଇତେ ନାରୁନାଦ୍ ଆୟ୍‍ୟ; ବୁତ୍ ବାତେଏ କାନାଲ୍‌ ନାୟାୱୁ କଣ୍ଡାଙ୍କ୍ ସାୟେ ମାଡ଼୍ ପାର୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ଆସୁଙ୍କ୍ ଜିରୂଶାଲମ୍ ମନ୍ଦିର୍ ତିଆର୍ ପାଣ୍ଡୁମ୍ ଆସମାତ୍‍ତେ; ଆଦ୍ ଦିନାମ୍ ଶାଲ୍ କାଲାମ୍ ମାତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ମେଣ୍ଡେ ଜିସୁ ମନ୍ଦିର୍‍ତାଗ୍ “ଶଲୋମନ୍‍” ମଣ୍ଡପ୍‍ତାଗ୍ ଉଡମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ଆଗାଙ୍କ୍ ଯିହୁଦୀନଡ଼୍ ଅଂକିଙ୍କ୍‌ ତିଡ଼ିଇ ପାକେ ଉଡ଼ି କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ମେଣ୍ଡେ ବେସ୍‌କ୍ ଦିନା ମାକିଂଙ୍କ୍ ଏର୍କା ତାଗ୍ ନେହେତିଡ଼୍ ? ଯଦି ନିମ୍‍ ମସିହ, ଆଲେକେ ମାକିଂଙ୍କ୍ ଇଟି ମିକା କେଲ୍‍ମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ମିକିଂଙ୍କ୍ କେସ୍‍ମିନ୍ଦେନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍; ନା ବାବାନ୍ ପେଦେର୍ ତେ ନାନ୍ ବେନ୍ ପାଡ଼୍‍ୟି ମାଡ଼ୁତାନ୍, ଆଦ୍‍ ସାରେ ନା ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ଇଦୁତାନ୍; ");
INSERT INTO kff_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ନା ଗୁଡ଼ୁସେତ୍ ମେଣ୍ଢାନଡ଼ି ଆୟୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ନା ମେଣ୍ଢା ସାରେ ନାୱାଦ୍ ଲେଙ୍ଗ୍ କେଞ୍ଜିତା ନୁ ନାନ୍ ଆୱିଙ୍କ୍ ପୁତ୍‍ତାନ୍, ମେଣ୍ଡେ ଆଉ ନା ପେର୍‍କେ ପେର୍‍କେ ୱାଦ୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ମେଣ୍ଡେ ନାନ୍ ଆୱିଙ୍କ୍ ସାରେଦିନାତ୍ ଜିୱୁ ଇଦ୍‍ତାନ୍, ମେଣ୍ଡେ ବେସୁଙ୍କ୍‌ବା ଆଉ ବିନଷ୍ଟ ଆୟ୍‍ୟ, ମେଣ୍ଡେ ବେନ ନା କାଇଦାଗାଙ୍କ୍ ଆୱିଙ୍କ୍ ଆଦ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ନା ବାବାଲ୍ ନାକିଂଙ୍କ୍ ବାତେଏ ଇସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ଆଦ୍ ସାରେତାଗଙ୍କ୍ ଗାଟି ମୁଲ୍ୟ, ମେଣ୍ଡେ ବାବାନ୍ କାଇଦେ କନ୍‍ସ୍ ବେନବା ଆଦାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ବାବାଲ୍ ନୁ ନାନ୍ ୱେରଣ୍ଡ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ଇଦ୍ ଗଟ୍ କେଞ୍ଜି ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ରେହେତାଙ୍କ୍ ମାଇଦିଙ୍କ୍ ମେଣ୍ଡନ୍ ଦାମ୍ କାଲ୍‍କ୍ ତାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ବାବାନାଗାଙ୍କ୍ ଗାଟି ସାୟେତ୍ ପାଡ଼୍‍ୟି ମିକିଂଙ୍କ୍ ତଅସ୍ ମିନ୍ଦେନ୍; ଆଦ୍ ସାରେ ପାଡ଼ିୟିତାଗାଙ୍କ୍ ନାକିଂଙ୍କ୍ କାଲ୍‍କିନ୍ ରେହେତାଙ୍କ୍ ଆଦୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ସାୟେତ୍ ପାଡ଼୍‍ୟି ମାଇଦିଙ୍କ୍ ମାମ୍‍ମେ ନିକିଂଙ୍କ୍ କାଲ୍‍କିନ୍ ରେହମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ ନିନ୍ଦେତ୍‍ ମାଇଦିଙ୍କ୍, ମେଣ୍ଡେ ନାରୁଡ଼୍ ଆସ୍ ନିଜେତିଙ୍କ୍ ଇଶ୍ୱର୍ ଇଞ୍ଜ୍ କେସମାନାଙ୍କ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜିସୁ ଅଡ଼୍‌‍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ମିୱାଦ୍ ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ, ଇଶ୍ୱର୍ କେତିତଣ୍ଡ୍, ‘ମିଡ଼୍ ଆଦ୍‍ତିଡ଼୍ ଇଶ୍ୱର୍ ।’ ");
INSERT INTO kff_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ବେନଡ଼୍ ପାକେ ଇଶ୍ୱର୍‌ତାଦ୍ ବାକ୍ୟ ମିନ୍ଦେ ଇତ୍‍କେ, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଯଦି ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍ ଇଞ୍ଜ କେତ୍‍କେ ମେଣ୍ଡେ, ଦର୍ମଶାସ୍ତ୍ର କଣ୍ଡନ୍ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ଆଲେକେ ବେନଙ୍କ୍ ଇଶ୍ୱର୍ ପବିତ୍ର ମାଡ଼ି ଜଗତ୍‍ତାଗ୍ ରହସିତ୍‍ତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ବାତେଏ ମିଡ଼୍, ନାନ୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍, ଇଦ୍ ନାନ୍ କେଲ୍‍ନାଙ୍କ୍, ନିମ୍‍ ଇଶ୍ୱର୍‌ତିଙ୍ଗ୍ ନିନ୍ଦ୍ ମାଡ଼ୁତିନ୍ ଇଞ୍ଜ କେସମିନ୍ଦେନି ? ");
INSERT INTO kff_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଯଦି ନାନ୍ ନା ବାବାନ୍ କାମ୍‍ସାରେ ମାଡ଼ନ୍ ଆଲାଇତ୍‍କେ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ମାଟ୍; ");
INSERT INTO kff_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯଦି ନାନ୍ ମାଡ଼ିତାନ୍, ଆଲାଇତ୍‍କେ ଆଗେଙ୍କ୍ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ମାଟ୍, ଆଗେକ୍ ବାବାଲ୍ ଯେ ନାୟାଗେ ମିନ୍ଦେଣ୍ଡ୍ ନୁ ନାନ୍ ବାବାନାଗ୍ ମିନ୍ଦେନ୍, ଇଦ୍ ବେଲାକି ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ ନୁ ପୁନୁଟ୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ କାମ୍‍ସାରେ ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପଇତାନ୍ ମାଇଦିଙ୍କ୍ ମେଣ୍ଡନ୍ ଦାମ୍ ଚେଷ୍ଟା ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌ କାଇଦେ ଦର୍‍କ୍‍ୱେ ପେଇସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଯର୍ଦ୍ଦନ୍‍ତେ ମେଣ୍ଡନ୍ ପାକେ ଆଞ୍ଜ୍, ଯୋହନ୍‌ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ମୁନେଙ୍କ୍ ବାପ୍ତିସ୍ମ ଇସମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପଡ଼ିୟେ ତାଗ୍ ୱାସ୍ ଆଗେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ମେଣ୍ଡେ, ନାର୍‍ଗେ ଅନାଗ୍ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, “ଯୋହନ୍‌ ବାତେବା ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମାଡ଼ନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇ ନାରୁଡ଼୍ ବିଷୟ୍‍ତେ ଯୋହନ୍‌ ବେନ୍ ସାରେ ଗଟି କେତ୍‍ତଣ୍ଡ୍, ଆଦ୍‍ ସାରେ ସତ୍;” ");
INSERT INTO kff_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ମେଣ୍ଡେ, ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଜିସୁଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେତନିୟା ମାନ୍ଦାନ୍ ଲାଜାର୍ ପେଦେର୍ ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‌ ରୋଗ୍‍ତେ ମାତ୍‍ତଣ୍ଡ୍; ମରୀୟମ୍ ନୁ ତାନ୍ ଏଲାଡ଼୍‍ ମାର୍ତା ଆଦ୍ ନାର୍ ମାଞ୍ଜମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ବେନ୍ ନାଟାଡ଼୍ ପ୍ରର୍‍ବୁଙ୍କ୍ ସାଏତ୍ ଗାବ୍‍ତାଦ୍ ନିୟ୍‍ ଲେକେତ୍‍ ମାଡ଼ି ତାନ୍ କେଲ୍‍କିନେ ଅନ୍‌ ଡେକାଙ୍କ୍ ଉଞ୍ଜ୍‍ପିତେ, ଇଦ୍ ଆ ମରୀୟମ୍; ତାମ୍ ଦାଦାଲ୍ ଲାଜାର୍ ରୋଗ୍‍ତେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ଆଉ ଏଲାସ୍କ୍‌ ଜିସୁନ୍ ପାକେ କେସ୍ ରହତାଆ, “ପ୍ରବୁ, ଉଡ଼େ, ବେନଙ୍କ୍ ନିମ୍‍ ସ୍ନେହ ମାଡ଼୍‍ନିନ୍, ଅଣ୍ଡ୍‌ ରୋଗ୍‍ତେ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ଇଦ୍ କବର୍ କେଞ୍ଜି ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ଇ ରୋଗ୍‍ତେ ଲାଜାର୍ ଡଲନ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଦିନ୍ ତଡ଼୍ ଇଶ୍ୱର୍ ମହିମାନିତ ଆଦ୍‍ତନ୍ ନୁ ଆଦିନ୍ ତଡ଼୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ମିକା ଗୌରବ୍‍ ପାଏମ୍ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜିସୁ ମାର୍ତା ନୁ ତାନ୍‌ ଏଲାଡ଼୍‍ ନୁ ଲାଜାର୍‍ତିଙ୍କ୍ ପ୍ରେମତେ ସ୍ନେହ ମାଡ଼ମାତ୍‍ତନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ଆତ୍‍କେମିକା ଲାଜାର୍ ରୋଗ୍‍ତେ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ ବେସୁଙ୍କ୍‍ ଜିସୁ କେଞ୍ଜ୍‍ତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍, ଆଦେପଡ଼ିଇ ତାଗ୍ ମେଣ୍ଡେ ରେଣ୍ଡ୍ ଦିନା ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ତାନ୍‍ପେର୍କେ ଜିସୁ ଶିଷ୍ୟକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଦାଟ୍‍ଟି, ମାନାଡ଼୍ ମେଣ୍ଡ୍‍ନ୍ ଦାମ୍ ମାଲ୍‍ସ୍ ଯିହୁଦାତାଗ୍ ଆଦିକାଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ହୋ ଗୁରୁ, ବେସ୍‌କ୍ ଦିନାତେ ମୁନେନ୍ ନାରୁଡ଼୍ ମେଣ୍ଡେ ନିକିଂଙ୍କ୍ କାଲ୍‍କ୍ ହେସାଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼ମାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ନିମ୍‍ ମେଣ୍ଡନ୍ ଦାମ୍ ଆଦାଙ୍କ୍ କେତୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ପାୟାଲ୍ ବାତେଏ ବାର ଗାଣ୍ଟା ଇଲା ? ବେନ ବେସୁଙ୍କ୍‍ ୱେସ୍‍ତେ ତାକାନ୍‍ୱେଲେ ରାଲଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଇ ଜଗତ୍‍ତାଗ୍ ୱେସ୍ ଉଡ଼ିତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇକାଡ଼୍ ତେ ତାକ୍‍କେ ଅଣ୍ଡ୍‌ ରାଲିତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଅଣ୍ଡ୍‌ ଆଦାନ୍ ୱେଲେ ୱେସ୍‍ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଜିସୁ ଆହୁସାରେ ଗଟି କେତ୍‍ତଣ୍ଡ୍ ଅଡ଼୍‌‍କ୍ ମେଣ୍ଡେ ଅଦିକ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ମାନ୍‍ ସାଙ୍ଗ ଲାଜାର୍ ଉସ୍‍କାଡ଼୍‍ତେ ମିନ୍ଦେଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଂକିଙ୍କ୍‌ ଉସ୍‍କାଡ଼୍ ତାଗାଙ୍କ୍‍ ତେତାନ୍ ମାଇଦିଙ୍କ୍ ନାନ୍ ଆଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ତାନ୍ ପେର୍‍କେ ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ପ୍ରବୁ ଯଦି ଅଣ୍ଡ୍‌ ଉସ୍‍କାଡ଼୍‍ତେ ମିନ୍ଦେଣ୍ଡ୍, ଆଲେକେ ଅଣ୍ଡ୍‌ ସୁସ୍ଥ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଜିସୁ ଅନାଦ୍‌ ଡଲାନ୍ ବିଷୟ୍‍ତେ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଉଞ୍ଜିମାନ୍ଦାନ୍ ବିଷୟ୍‍ତେ କେତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଅଡ଼୍‌ ଏର୍କା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ଜିସୁ ଆସୁଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସତ୍ କେତ୍‍ତଣ୍ଡ୍, “ଲାଜାର୍ ଡଲ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ନାନ୍ ଯେ ଆଦ୍‍ପଡ଼ିୟେ ତାଗ୍ ଇଲ୍‍ୱେ ମାତ୍‍ତାନ୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ମିତଡ଼୍ ନାନ୍ ୱେଡ଼୍‍କା ମାଡ଼ୁତାନ୍, ବେଦ୍‍ଲେକାମ୍ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତିଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦାଟ୍‍ଟି, ମାନାଡ଼୍ ଅଂକିଙ୍କ୍‌ ଉଡାଙ୍କ୍ ଆଦିକାଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ତୋମା ବେନଙ୍କ୍ ଦିଦୁମ୍ ଇଞ୍ଜ କେତିତଡ଼୍‍, ଅଣ୍ଡ୍‌ ମାନ୍‍ ସାଙ୍ଗ ଶିଷ୍ୟଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଦାଟ୍‍ଟି ମାନାଡ଼୍ ଆନ୍‌‍ତେ ଗୁରୁନ୍‍ ତଡ଼୍ ଆଞ୍ଜ୍ ଅନ୍‌‍ତଡ଼୍ ଡଲିକାଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜିସୁ ହେଉସ୍ କେଞ୍ଜ୍‍ତଣ୍ଡ୍ ଯେ, ଅଣ୍ଡ୍‌ ନାଲୁଦିନା ଆତ୍‍ତେ ଅଂକିଙ୍କ୍‌ ସମାଦି ତାଗ୍ ୱାଟ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେତନିଆ ଯିରୁଶାଲେମ୍ ତା ଗାର୍‍ରେ ମାତ୍‍ତେ, ମାତର୍ ମୁଣ୍ଡ୍ କିଲମିଟର୍ ଦୁରାମ୍; ");
INSERT INTO kff_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ଯିହୁଦୀ ଡ଼ାଗାଙ୍କ୍ ନାର୍‍ଗେ ମାର୍ତା ନୁ ମରୀୟମ୍ ତିଙ୍କ୍ ତାମ୍ ଦାଦାଲ୍‌ ବିଷୟ୍‍ତେ ସାନ୍ତନା ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ଆୱିନା ୱାସ୍‍ମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ଆଗାଙ୍କ୍ ଜିସୁ ୱାତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ବେସୁଙ୍କ୍‍ ମାର୍ତାଲ୍ କେଞ୍ଜ୍‍ତେ, ଆସୁଙ୍କ୍ ଆଦ୍ ଜିସୁଙ୍କ୍ କାଇଲାନ୍ ମାଇଦିଙ୍କ୍ ଆତ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମରୀୟମ୍ ଲୋନ୍‌ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍ତା ଜିସୁଙ୍କ୍ କେତ୍‍ତେ, “ପ୍ରବୁ, ନିମ୍‍ ଯଦି ଇଗେ ମାନେନି ଆଲେକେ ମା ଦାଦାଲ୍ ଡଲନ୍ ଆୟେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ପୁତ୍‍ତାନ୍ ନିମ୍‍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ବାତେଏ ମେଣ୍ଡେ ତାଲ୍‍କେ, ଇଶ୍ୱର୍ ଯେ ଆଦ୍ ଇଦ୍‍ତଣ୍ଡ୍, ହିଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଇ ଦାଦାଲ୍ ମେଣ୍ଡେ ଜିୱୁ ଆସ୍ ତେଦିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍ତା ଜିସୁଙ୍କ୍ କେତ୍‍ତେ, “ଅଣ୍ଡ୍‌ ଯେ ଶେଷ୍ ଦିନାତେ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ତେଦିତଣ୍ଡ୍ ଇଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ପୁନର୍‍ରୁତାନ୍ ନୁ ଜିୱୁନ୍; ବେନ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ବେସୁଙ୍କ୍‌ବା ଡଲ୍‍କେ, ମିକା ଅଣ୍ଡ୍‌ ଜିୱୁଅଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ମେଣ୍ଡେ ବେନ ଗେଲ୍‍ସ୍‍କେ ନୁ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅନ୍‌ ବେସୁଙ୍କ୍‌ବା ଡଲନ୍; ଇଦ୍ ବାତେଏ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ହୋ, ପ୍ରବୁ, ବେନ ଜଗତ୍‍ତାଗ୍ ଆଗମନ୍ ମାଡ଼ାନ୍ ମାତ୍‍ତେ, ନିମ୍‍ ଯେ ଇଶ୍ୱତେ ମାର୍‍ ଆଦ୍ ମସିହ, ଇଦ୍ ନାୱାଦ୍ ବିଶ୍ୱାସ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ମରୀୟମ୍ କେତ୍‍ତେ ପେର୍‍କେ ମାର୍ତା ଆଞ୍ଜ୍ ତାନ୍ ଏଲାଡ଼୍‍ ମରୀୟମ୍ ତିଙ୍କ୍ ଜାମେ କାର୍‍ଙ୍ଗି କେତ୍‍ତେ, “ଗୁରୁ ୱାତ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ନିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ଆଦ୍ ଇଦ୍ କେଞ୍ଜି ଜାପେତେଦି ଅନ୍‌ ଗାର୍‍ରେ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଜିସୁ ଆସୁଙ୍କ୍ ନାର୍ ଲୋପେ ୱାଡ଼୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାର୍ତା ଅଂକିଙ୍କ୍‌ ବେନ୍ ପଡ଼ିୟେତାଗ୍ କାଇଲିମାତ୍‍ତେ, ଆସୁଙ୍କ୍ ଯାକ ଜିସୁ ଆଗେମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ବେନ୍ ଯିହୁଦୀନଡ଼୍ ଅଦିନ୍‌ତଡ଼୍ ଲୋନ୍‌ ମାଞ୍ଜ୍ ତାଙ୍କ୍ ସାନ୍ତନା ଇସମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ମରୀୟମ୍ ଜାପେ ତେଦି ପେଇସ୍ ଆଦାନାଦ୍ ଉଡ଼ି, ଆଦ୍ ସମାଦି ପାକେ କେୟାନ୍ ସେଙ୍ଗେ ଆଦୁତ୍‍ତେ, ଆଦ୍ ଏର୍କା ମାଡ଼ି ଆଦିନ୍ ପେର୍‍କେ ପେର୍‍କେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଆଗାଙ୍କ୍ ଜିସୁ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍, ମରୀୟମ୍ ଆଦ୍ ପଡ଼ୟେ ତାଗ୍ ହେଉସ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଅନ୍‌ ଡେକାନ୍ ମଦଲ୍ ରାଲୀ କେତ୍‍ତେ, “ପ୍ରବୁ, ଯଦି ନିମ୍‍ ଇଗେ ମାନେନି, ଆଲେକେ ମା ଦାଦାଲ୍ ଡଲ୍‍ଲାନଙ୍କ୍ ଆୟେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ଜିସୁ ମରିୟମ୍‍ତିଙ୍କ୍ କେୟାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଯିହୁଦୀନଡ଼୍‍କ୍ ଆଦିନ୍ ତଡ଼୍ ୱାତ୍‍ତାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ମିକା କେୟମାତ୍‍ତଡ଼୍, ଆଦ୍ ଉଡ଼ି ଜିସୁ ଗାଟି ଦୁଃକ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଗାଟି ଦାନ୍ଦେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“ଅଂକିଙ୍କ୍‌ ବେଗା ୱାଟ୍‍ତିଡ଼୍ ?” ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ପ୍ରବୁ ୱାସ୍ ଉଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜିସୁ କେୟ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ତାନ୍ ପେର୍‍କେ ଯିହୁଦୀନଡ଼୍ କେତ୍‍ତଡ଼୍, “ଉଡ଼ାଟ୍, ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ବେସର୍ ସ୍ନେହ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଆଗାଙ୍କ୍ ବେନ ବେନ୍ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ବେନ୍ ନାରୁଣ୍ଡ୍‌ ଆ କାନାନ୍ କଣ୍ଡାଙ୍କ୍ ବେନ ସାୟେ ମାଡ଼୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବାତେଏ ଇନାଦ୍ ଡ଼ଲ୍‍ତାଦ୍ ମିକା ଗେଲ୍‍ସ୍‍ପେ ପାର୍‍ୱଣ୍ଡ୍ ଆୟେଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ଆଗାଙ୍କ୍ ଜିସୁ ମେଣ୍ଡ୍‍ନ୍ ଦାମ୍ ମନ୍‍ତାଗ୍ ବ୍ୟାକୁଲ୍ ଆସ୍ ସମାଦି ପାକେ ଆତ୍‍ତଣ୍ଡ୍; ଆଦ୍ ୱେରଡ଼୍ ପାଡ଼୍‍କିନାଗ୍ ମେଣ୍ଡେ ଅନ୍‌ ମୋକତାଗ୍ ୱେରଡ଼୍ କାଲ୍ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜିସୁ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍, “ଇଦ୍ କାଲ୍ ଗୁସ୍‍ପିମୁଟ୍,” ଡଲ୍‍ତେ ନାରୁନ୍ ଏଲାଡ଼୍‍ ମାର୍ତା ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, “ପ୍ରବୁ, ଅଣ୍ଡ୍‌ ଗାଟି ଗାବ୍ ପୋଇତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଡଲି ନାଲୁ ଦିନା ଆଦୁତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଯଦି ନିମ୍‍ ବିଶ୍ୱାସ୍ ମାଡ଼କେ, ଆଲେକେ ଇଶ୍ୱର୍ ତେ ମହିମା ଉଡ଼ିତିନ୍, ଇଦ୍ ବାତେଏ ନାନ୍ ମିକିଂଙ୍କ୍ କେଲନ୍ ? ");
INSERT INTO kff_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ କାଲ୍ ଟେଣ୍ଡ୍‍ଡ଼ିତ୍‍ତଡ଼୍ ।” ମେଣ୍ଡେ ଜିସୁ ପରୁ ଉଡ଼ିମିକା କେତ୍‍ତଣ୍ଡ୍, “ହୋ ବାବା ନିମ୍‍ ନାୟାଦ୍ ପ୍ରାର୍ତନା କେଞ୍ଜତିନ୍ ଇଞ୍ଜେ ନାନ୍ ନିକିଂଙ୍କ୍ ଦନ୍ୟବାଦ୍ ଇଦୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ନିମ୍‍ ଯେ ନାୱାଦ୍ ପ୍ରାର୍ତନା କେଞ୍ଜୁତିନ୍ ଇଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ୍ ନାରୁଡ଼୍ ସାରେପାକା ନିସ୍‍ମିନ୍ଦେଡ଼୍, ନିମ୍‍ ନାକିଂଙ୍କ୍ ରସ୍ ମିନ୍ଦେନି ଇଞ୍ଜ ଅଡ଼୍‌ ବେଲା ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌ ସେଙ୍ଗେ ନାନ୍ ଇଦ୍ କେତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଅଣ୍ଡ୍‌ ଆଦ୍ କେସ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କାର୍‍ଙ୍କ୍ ତୋଣ୍ଡ୍, “ଲାଜାର୍ ପେଇସ୍ ୱାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ଅଣ୍ଡ୍‌ ପେଇସ୍ ୱାତ୍‍ତଣ୍ଡ୍; ଅନ୍‌ କାୟ୍ ନୁ ଡେକା ସମାଦି ସିଲେତ୍ ତୋହସ୍ ମାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅନ୍‌ ମକତାଗ୍ ସୁଦୁଟ୍ ତୁୱାଲ୍ ଉତ୍‍ତାଦ୍ ମାତ୍‍ତେ । ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇନାଦ୍ ବନ୍ଦନ୍ ଲେହେସିଶ୍ ଆଦାଙ୍କ୍ ହିମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ଯିହୁଦୀନଡ଼୍ ଆଗାଙ୍କ୍ ନାର୍‍ଗେ, ବେନଡ଼୍ ମରୀୟମ୍ ତେ ଗାର୍‍ରେ ୱାସ୍‍ମାତ୍‍ତଡ଼୍ ନୁ ଜିସୁନ୍ ପାଡ଼୍‍ୟି ଉଡ଼୍‍ତଡ଼୍, ଅଡ଼୍‌ ଅନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ମେଣ୍ଡେ, ଅଡ଼୍‌ ତାଗାଙ୍କ୍ ବେନ ପାରୂଶୀଡ଼୍ ପାକେ ଆଞ୍ଜ୍, ଜିସୁ ବାତ୍ ବାତେଏ ପାଡ଼୍‍ୟି ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ସାରେ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ଆଗାଙ୍କ୍ ବେଡ଼ିଇ ଯାଜକ୍ ନୁ ପାରୂଶୀଡ଼୍ ବେଡ଼ିଇ ଶବାତାଗ୍ ଆଞ୍ଜ୍ କେତ୍‍ତଡ଼୍, “ମାନାଡ଼୍ ବାତେଏ ମାଡ଼ିକାଡ଼୍ ? ଇ ନାରୁନ୍ ତ ନାର୍‍ଗେ ବାକ୍‍ୱାକାମ୍ ମାଡ଼ୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଯଦି ମାମ୍‍ମେ ଅଂକିଙ୍କ୍‌ ଆଲେନ୍ ୱିଡ଼୍‍ସିଦ୍‍ତମ୍, ଆଲେକେ ସାରେତଡ଼୍ ଅନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍, ମେଣ୍ଡେ ରୋମିୟ ନାରୁଡ଼୍ ୱାସ୍ ମାନ୍‍ନାଦ୍ ମନ୍ଦିର୍‍ତିଙ୍କ୍ ନୁ ଜାତିତିଙ୍କ୍ ଦଂସ ମାଡ଼ିଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ଅଡ଼୍‌ ଆଗାଙ୍କ୍ ଆ ହେଣ୍ଡେତ୍ ବେଡ଼୍‍ୟାଦ୍‍ ଯାଜକ୍ କୋୟାପାଲ୍‍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବାତେଏ ପୁନ୍‍ୱିଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ସାରେ ଜାତି ବିନଷ୍ଟ ଆଦାନ୍ ୱିଡ଼୍‍ସି ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ଡଲ୍‍ନାଦ୍ ସାଏ ହିଦ୍‍ବାତ୍ ମିଡ଼୍ ବୁଜେମ୍ ଆୟୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କୟାପା ନିଜେତ୍ ମାନ୍‍ ତାଗାଙ୍କ୍ ହିଦ୍ କେଲଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଆଦ୍ ୱାଡ଼୍‍ସେତେ ବେଡ଼ିଇ ଯାଜକ୍ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ହିଦ୍ ଗଟ୍ ଅନ୍‌ ମକତାଗାଙ୍କ୍ ପେଇସ୍ ମାତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଚିହ୍ନେ ୱେରେ ଆସ୍‍ମାନ୍ଦାନ୍ ଇଶ୍ୱର୍‌ତେ ନାରୁଡ଼୍, ୱେରଡ଼୍ ଗଷ୍ଟିତାଗ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ାଙ୍କ୍ ଜିସୁଙ୍କ୍ ଡଲେ ୱେଇତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ଆଦିଙ୍କ୍ ଆଦ୍ ଦିନ୍‍କଞ୍ଜ୍ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ହାଉକାଙ୍କ୍ ମାଇଦିଙ୍କ୍ ଚକ୍ରାନ୍ତ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ଜିସୁ ଯିହୁଦୀନଡ଼୍ ଆଗାଙ୍କ୍ ମେଣ୍ଡେ ଆଦ୍‍ଦା ୱାଦା ଆୟ୍‍ୟଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ପଡ଼ୟେ ତାଗାଙ୍କ୍ ପେଇସ୍‍ଆଞ୍ଜ୍ ଜିରୂଶାଲମ୍ ୱିଡ଼୍‍ସି ଉଚ୍‍କ ମାନ୍ଦାନ୍ ଏପ୍ରୟିମ୍ ପେଦେର୍‍ତେ ୱେରଡ଼୍ ସହର୍ ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆ ଶିଷ୍ୟନଡ଼୍‍ତଡ଼୍ ଆଗେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଯିହୁଦୀନଡ଼୍ “ନିସ୍ତାର୍,” ପାଣ୍ଡୁମ୍ ଗାର୍‍ରେ ଏୱୁସ୍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ରାଜ୍ୟକିନାଗାଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ସୁସ୍ଥ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ତାଗ୍ ଜିରୂଶାଲମ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ଆଗେ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ମେହେକ ମନ୍ଦିର୍ ତାଗ୍ ନିସ୍‍ମାନ୍ଦାନ୍ ୱେଲେ ତାମ୍‍ତାମ୍ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ମିଡ଼୍ ବାତେଏ ଏର୍କା ମାଡ଼ୁତିଡ଼୍ ? ଅଣ୍ଡ୍‌ ବାତ୍ ପାଣ୍ଡୁମ୍ ତାଗ୍ ୱାଦ୍‍ତଣ୍ଡ୍ ନା ଇଲେ ?” ");
INSERT INTO kff_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ମୁକ୍ୟ ଯାଜକିଡ଼୍ ନୁ ପାରୂଶୀଡ଼୍ ଜିସୁଙ୍କ୍ ପଇତାନ୍ ସେଙ୍ଗେ, ଅଣ୍ଡ୍‌ ବେଗା ମିନ୍ଦେଣ୍ଡ୍, ଇଦ୍ ଯଦି ବେନ ପୁନ୍‍ତଣ୍ଡ୍, ଆଦ୍ କେତାନଙ୍କ୍ ଗଟ୍ ଇସ୍‍ମାତ୍‍ଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ଜିସୁ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍‍ତ ଆରୁଦିନା ମୁନେଙ୍କ୍ ବେତନିୟାତାଗ୍ ୱାତ୍‍ତନ୍; ବେନ୍ ଲାଜାର୍‍ତିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଡଲ୍‍ତେ ଆଗାଙ୍କ୍ ତେସ୍ ମାତ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ଆଦ୍ ପଡ଼ିୟେ ତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ଜିସୁନ୍ ମାଇଦିଙ୍କ୍ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ଅଣ୍ଡୟ୍‌ ନାର୍କା ବଜି ମାଡ଼୍‍ତଡ଼୍; ମାର୍ତାଲ୍ ସେବା ମାଡ଼ମାତ୍‍ତେ, ମେଣ୍ଡେ ବେନଡ଼୍ ଅନ୍‌ ତଡ଼୍ ତିନ୍ଦାଙ୍କ୍ କୁଦ୍‍ତଡ଼୍, ଲାଜାର୍ ଅଡ଼୍‌ ଆଗାଙ୍କ୍ ୱେରଣ୍ଡ୍ ମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ଆସୁଙ୍କ୍ ମରୀୟମ୍ ଅଦ୍‍ଦା ଲିଟର୍ ଗାଟି ଦାମ୍ ତେ ନିୟ୍‍ ଲେକେତ୍‍ ଗାବ୍‍ତାଦା ନିୟ୍ ଅସ୍ ଜିସୁନ୍ ଡ଼େକାନାଗ୍ ଆଦ୍ ତୋମି ତାନ୍ କେଲ୍‍କିନେ ଅନ୍‌ ଡେକାଙ୍କ୍ ଉଞ୍ଜ୍‍ପିତେ, ମେଣ୍ଡେ ନିୟ୍‍ଦେ ଗାବ୍ ଦେ ଲୋନ୍‌ ଆନ୍‌‍ତେ ମହକେମ୍ ଆତ୍‍ତେ ");
INSERT INTO kff_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁନ୍ ଶିଷ୍ୟନଡ଼୍ ଆଗାଙ୍କ୍ ଇଷ୍କାରୀୟତିୟ ଯିହୁଦା ପେଦେର୍ ତନ୍ ବେନ୍ ଶିଷ୍ୟ ଅଂକିଙ୍କ୍‌ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପିଦାଙ୍କ୍ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍‌, ");
INSERT INTO kff_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ଆଦ୍ ନିୟ୍ ମୁଣ୍ଡ୍‍ୱାନ୍ଦା ରୁପାଡାବ୍‍କିନ୍ ବାତେଙ୍କ୍ ୱାମ୍‍ତା ? ବାତ୍‍ତିଙ୍କ୍ ଦରିଦ୍ର ନାରୁଡ଼୍‍କ୍ ଇୱ ଆତ୍‍ତେ ?” ");
INSERT INTO kff_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ଅଣ୍ଡ୍‌ ଯେ ଦରିଦ୍ର ନାରୁଡ଼୍ ସେଙ୍ଗେ ଚିନ୍ତେ ମାଡ଼ମାତ୍‍ତନ୍ ଇଞ୍ଜ ଇଦ୍ କେତ୍‍ତେ, ଆଦ୍ ଆୟ୍‍ୟ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଡଙ୍ଗାଲ୍, ମେଣ୍ଡେ ଅନାଗାଙ୍କ୍ ଡାବ୍‍ ମୁନେ ମାନ୍‍ନାଙ୍କ୍, ଆଗେ ବାତା ୱାଟି ମାତ୍‍ତଡ଼୍, ହାଉସାରେ ଡଙ୍ଗି ମିକା ଆସମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‌, “ଇଦିଙ୍କ୍ ୱିଡ଼୍‍ସିମୁଟ୍, ବେଲା ନା ସମାଦି ଦିନାତ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ଇଦ୍ ନେହେତେ ପାର୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ଦରିଦ୍ର ନାରୁଡ଼୍ ତ ସାରେଦିନା ମିଇ ପାକେ ମିନ୍ଦେଡ଼୍‍, ମାତର୍ ନାନ୍ ସାରେଦାମ୍ ମିଇ ପାକେ ମାନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଆଗାଙ୍କ୍ ଗାଟି ଯିହୁଦି ନାରୁଡ଼୍ ଜିସୁ ବେତନିୟାତାଗ୍ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ୍ ପୁଞ୍ଜ୍ ମିକା ମାତର୍ ଜିସୁନ୍ ମାଇଦିଙ୍କ୍ ଆୟ୍‍ୟ, ମାତର୍ ବେନ୍ ଲାଜାର୍‍ତିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେହେସ୍‍ମାତ୍‍ତନ୍, ଅଂକିଙ୍କ୍‌ ଉଡାଙ୍କ୍ ମାଇଦିଙ୍କ୍ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ଆଗେ ଲାଜାର୍ ତିଙ୍କ୍ ମିକା ହାଉକାଙ୍କ୍ ସେଙ୍ଗେ ବେଡ଼ିଇ ଯାଜକ୍‍ନଡ଼୍ ମନ୍ତ୍ରନା ମାଡ଼୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅନ୍‌ ସେଙ୍ଗେ ଯିହୁଦିନଡ଼୍ ଆଗାଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଆଞ୍ଜ୍ ଅଡ଼୍‌‍କ୍ ଅବିଶ୍ୱାସ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍ ନୁ ଜିସୁ ନାଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ମେଣ୍ଡେଅନ୍‌ ଦିନ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍‍ତାଗ୍ ୱାସ୍ ମାନ୍ଦାନ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଜିସୁ ଜିରୂଶାଲମ୍ ତା ୱାଦୁତନ୍ ଇଞ୍ଜ କେଞ୍ଜ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ଆଦିଙ୍କ୍ ହେତେଲ୍ ମାଟା ଆସ୍ ଅଂକିଙ୍କ୍‌ କାଇଲାନ୍ ସେଙ୍ଗେ ପେଇସ୍ ଆଦ୍‍ତଡ଼୍ ନୁ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, “ପ୍ରସଂଶା । ପ୍ରବୁନ୍ ପେଦେର୍‍ତେ ବେନ ୱାଦୁତନ୍, ଅଣ୍ଡ୍‌ ଦନ୍ୟ; ଦନ୍ୟ ଇସ୍ରାଏଲ୍‍ତେ ରାଜା ।” ");
INSERT INTO kff_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଜିସୁ ୱେରଡ଼୍ ଗଦ ପର୍‍ର କୁଦି ୱାସମାତ୍‍ତନ୍ । ହିଦିନ୍ ତଡ଼୍ ଶାସ୍ତ୍ରତାଗ୍ ୱେର୍‍ଡ଼୍ ବାବବାନି ସାରେ ଆତ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ହୋ ସିୟନ୍‍ତେ ପିକିଡ଼୍, ୱେର୍‍ମା; ଉଡ଼େ ମିୱନ୍‌ ରାଜାଲ୍ ୱାଦୁତନ୍, ଅଣ୍ଡ୍‌ ଗଦତ୍ ପର୍‍ର କୁଦି ୱାଦୁତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ଅନ୍‌ ଶିଷ୍ୟନଡ଼୍ ମୁନେଙ୍କ୍ ଇଦ୍ ସାରେ ବିଷୟ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ମହିମାନିତ ଆତ୍‍ତେ ୱେଲେ ଇଦ୍ ସାରେ ବିଷୟ ଯେ ଅନ୍‌ ମୁନେ ଲେକାମାତ୍‍ତେ, ମେଣ୍ଡେ ଅନ୍‌ ସେଙ୍ଗେ ଅଡ଼୍‌ ଯେ ଇଦ୍‍ସାରେ ମାଡ଼ିମାତ୍‍ତଡ଼୍, ଆଦ୍ ଅଡ଼୍‌ ମାନ୍‍ ଦାଗ୍ ୱାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ମେଣ୍ଡେ, ଜିସୁ ଲାଜାର୍ ତିଙ୍କ୍ ସମାଦି ତାଗାଙ୍କ୍ ଡଲ୍‍ତେ ଆଗାଙ୍କ୍ ତେତାନ୍ ୱେଲେ ବେନ୍ ନାରୁଡ଼୍ ମୁନେ ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଆଦ୍ ଗଟ୍‍ନା ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ହିଦିନ୍ ସେଙ୍ଗେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ କାହିଲାନଙ୍କ୍‌ ଆଞ୍ଜ୍ ମାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଦ୍ ବାକ୍‌ୱାକାମ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଅଡ଼୍‌ କେଞ୍ଜିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ଆଗାଙ୍କ୍ ପାରୂଶୀଡ଼୍ ତାମ୍‍ତାମ୍ କେତା କେତି ଆଦ୍‍ତଡ଼୍, “ଉଡ଼ୁତିଡ଼୍ ତ, ମାୱାଦ୍ ସାରେତଡ଼ାଦ୍ ଆଲ୍‍ସି ଲେକେତ୍ ଆଦୁତେ; ଉଡ଼ାଟ୍, ଜଗତ୍‍ଯାକ ସାରେତଡ଼୍ ଅନ୍‌ ପେର୍‍କେ ଅଦୁତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ପାଣ୍ଡୁମ୍ ସମୟ୍‍ତେ ଉପବାସ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ୱାସ୍‍ମାନ୍ଦାନ୍ ନାରୁଡ଼ାଗାଙ୍କ୍ ବେସ୍‌କ୍ ତୁଡ଼୍ ଗ୍ରୀକ୍‍ ନାରୁଡ଼୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ଅଡ଼୍‌ ଗାଲିଲୀତେ ବେତ୍‍ସାଇଦା ନାରୁଡ଼୍ । ଅଡ଼୍‌ ପିଲିପ୍‍ତେ ଗାର୍‍ରେ ଆଞ୍ଜ୍ କେତ୍‍ତଡ଼୍, “ପାୟ୍‍କା ମାମ୍‍ମେ ଜିସୁଙ୍କ୍ କାଇଲାନ୍‌ ସେଙ୍ଗେ ମାୟାଦ୍‌ ଇଚ୍ଛା ।” ");
INSERT INTO kff_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପ୍ ଆଞ୍ଜ୍ ଆନ୍‌ଦ୍ରିୟଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, ମେଣ୍ଡେ ଆନ୍ଦ୍ରିୟ ନୁ ପିଲିପ୍ ଆଞ୍ଜ୍ ଜିସୁଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜିସୁ ଅଡ଼୍‌‍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତନ୍, “ନାରୁନ୍ ପିଲେ ମହିମାନିତ ଆଦାନ୍ ସେଙ୍ଗେ ଦିନାମ୍ ହେୱୁତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେସମିନ୍ଦେନ୍, ଗଅମ୍ ପେଡ଼େମ୍ ଯଦି ବୂମ୍‌ଦାଗେ ରାଲୀ ଡ଼ଲ୍‍ୱେ ମାନ୍‍ତେ, ଆଲେକେ ଆଦ୍ ଅଣ୍ଡୟ୍‌ ମାନ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଡଲିତ୍, ଆଲେକେ ନାର୍‍ଗେ କାୟା ଆଦିତେ । ");
INSERT INTO kff_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ବେନ ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍‍ତିଙ୍କ୍ ପ୍ରେମ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଆଦ୍ ଆରା ମାଡ଼ିତନ୍; ମେଣ୍ଡେ ବେନ ନିଜେତ୍ ଜିୱେତିଙ୍କ୍ ପ୍ରେମ ମାଡ଼ଣ୍ଡ୍ ନୁ ଜଗତ୍ ଅଙ୍କ୍‌ ପାସ୍‍କିତ୍, ଅଣ୍ଡ୍‌ ଆଦ୍ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ସେଙ୍ଗେ ରକ୍ଷା ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ବେନ ନା ଦାସ ଆତ୍‍ଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିତନ୍, ଆଲେକେ ଅଣ୍ଡ୍‌ ନା ପେର୍‍କେ ୱାଡ଼ିଣ୍ଡ୍; ମେଣ୍ଡେ, ନାନ୍ ବେଗା ମାନ୍‍ତାନ୍, ଆଗେ ଅଣ୍ଡ୍‌ ଆନ୍‌‍ତେ ମାନ୍‍ତନ୍; ବେନ ନା ସେବା ମାଡ଼ିତନ୍, ଆଲେକେ ବାବାଲ୍ ଅଂକିଙ୍କ୍‌ ସମ୍ମାନ୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ଇଞ୍ଜେ ନାନ୍ ଗାଟି ଦୁଃକାମ୍, ନାନ୍ ବାତେଏ ମାଡ଼ିତାନ୍ ? ‘ବାବା, ଇଦ୍ ଦୁଃକ ସମୟ୍‍ତାଗାଙ୍କ୍ ନାକିଂଙ୍କ୍ ଉଦାର୍ ମାଡ଼େ, ଆଦିନ୍ ସେଙ୍ଗେ ତ ନାନ୍ ଇ ସମୟ୍‍ତାଗ୍ ୱାସ୍ ମିନ୍ଦେନ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ବାବା, ନିୱାଦ୍ ପେଦେର୍ ମହିମାନିତ ମାଡ଼େ ।” ଆଗାଙ୍କ୍ ମାବ୍ ତାଗାଙ୍କ୍ ଇଦ୍ ବାଣି ଆତ୍‍ତେ, “ମାମ୍‍ମେ ଆଦ୍ ମହିମାନିତ ମାଡ଼ିମିନ୍ଦେମ୍, ମେଣ୍ଡନ୍ ଦାମ୍ ମହିମାନିତ ମାଡ଼ିତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ଆସୁଙ୍କ୍ ଗାର୍‍ରେ ନିସ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଇଦ୍ କେଞ୍ଜି ମାବ୍ ନେକ୍‍ତେ ଇଞ୍ଜ୍ କେତ୍‍ତଡ଼୍; ମେଣ୍ଡେ ବାଗାତଡ଼୍ କେତ୍‍ତଡ଼୍, “ୱେରନ୍ ଦୂତ ଅଂକିଙ୍କ୍‌ ଗଟ୍ କେସ୍‍ମିନ୍ଦେ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ଜିସୁ ଅଡ଼୍‌‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନା ମାଇଦିଙ୍କ୍ ଇଦ୍ ବାଣି ଆୟ୍‍ୟ, ମାତର୍ ମିଇ ମାଇଦିଙ୍କ୍ ଆସ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ଇଞ୍ଜେ ଇ ଜଗତ୍‍ତାଦ୍ ବିଚାର୍ ହେୱୁତେ; ଇଞ୍ଜେ ଇ ଜଗତ୍‍ତଣ୍ଡ୍ ଅଦିପତିଙ୍କ୍ ବାଇଦେ ଏସ୍ ୱେଇତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଯଦି ନାନ୍ ପୃତିବିତେ ପର୍‍ର ଆଦ୍‍ତନ୍, ଆଲେକେ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ନା ଗାର୍‍ରେ ଅଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ଅଣ୍ଡ୍‌ ବେଦ୍‍ଲେକାମ୍ ଡଲାନଙ୍କ୍ ଆଦୁତନ୍, ଆଗେତ୍ ଗଟ୍ ଇସ୍ ଇଦ୍ କେତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ଆଗାଙ୍କ୍ ନାରୁଡ଼୍ କେତ୍‍ତଡ଼୍, “ମସିହ ସାରେଦିନାମ୍ ମାନ୍ଦାନାଦ୍ ମାମ୍‍ମେ ବ୍ୟବସ୍ଥାତାଗ୍ ସାରେ କେଞ୍ଜିମିନ୍ଦେମ୍, ଆଲେକେ ନାରୁନ୍ ପିଲା ପର୍‍ର ଆଦ୍‍ତନ୍ ଇଞ୍ଜ୍ ନିମ୍‍ ବେଲା କେତୁତି ? ଇ ନାରୁନ୍ ପିଲା ବେନ ?” ");
INSERT INTO kff_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ଆଗାଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‌, “ମେଣ୍ଡେ ସୁଦୁଟ୍ ଦିନାମ୍ ମାତର୍ ୱେସ୍ ମିୟାଗ୍ ମିନ୍ଦେ । ଇକାଡ଼୍ ବେଲା ମିକିଂଙ୍କ୍ ଆଦ୍‍ପାପ୍ ମାଡ଼, ଆଦିନ୍ ସେଙ୍ଗେ ମିଡ଼୍ ୱେସ୍ ମାନ୍‍ନା ଆଦାନଙ୍କ୍ ତିଆର୍ ଆୟ୍‍ମୁଟ୍, ବେନ ଇକାଡ଼୍‌ତାଗ୍ ତାକିତନ୍, ଅନ୍‌ ବେକେ ଆଦୁତନ୍, ଆଦ୍ ପୁନନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ମିଡ଼୍ ବେଲା ୱେସ୍‍ତେ ପିଲା ଆଦ୍‍ତିଡ଼୍, ଆଦିନ୍ ସେଙ୍ଗେ ୱେସ୍ ମିୟାଗେ ମାନ୍‍ନା ୱେସ୍‍ତିଙ୍କ୍‍ ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍ ।” ଜିସୁ ଇଦ୍‍ସାରେ ଗଟି କେସ୍ ପେଇସ୍‍ଆଞ୍ଜ୍ ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ ମାୟି ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ଯଦି ଜିସୁ ଅଡ଼୍‌ ମୁନେ ଆସର୍ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼ିମାତନ୍, ଆଗେକ୍ ବା ଅଡ଼୍‌ ଅନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱେ ମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ବେଦ୍‍ଲେକାମ୍ ଜିଶାଇୟ ବାବବାଦିଡ଼୍ ବାକ୍ୟ ସାରେ ଆଦ୍‍ତେ, “ହଁ ପ୍ରବୁ, ବେନ ମା ସମ୍ୱାଦ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ? ମେଣ୍ଡେ ବେନ ଗାର୍‍ରେ ପ୍ରବୁ ଅନାଦ୍‌ ଶକ୍ତି ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ଇଦିନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼୍ ପାର୍‍ୱେ ମାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିଶାଇୟ ମେଣ୍ଡନ୍‌ଦାମ୍‌ କେସ୍‍ମିନ୍ଦେନ୍, ");
INSERT INTO kff_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ଇଶ୍ୱର୍ ଅଡ଼ାୱୁ କଣ୍ଡାଙ୍କ୍ କାନାଲ୍‌ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ମେଣ୍ଡେ ଅଡ଼ାଦ୍‌ ଜିୱୁନ୍ ଡୁଟ୍‍ଟାଙ୍କ୍ ମାଡ଼ିମିନ୍ଦେଡ଼୍, ବେଦ୍‍ଲେକାମ୍ ଅଡ଼୍‌ କଣ୍ଡାନେ ଉଡ଼େ ପାର୍‍ୱାଦ୍, ମେଣ୍ଡେ ଜିୱେତାଗ୍ ବୁଜେମ୍ ଆଦ୍‍ପାର୍‍ୱଡ଼୍, ମେଣ୍ଡେ ମାଲ୍‍ଦେ ପାର୍‍ୱଡ଼୍, ମାମ୍‍ମେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼ମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଜିଶାଇୟ ଇଦ୍‍ସାରେ କେତ୍‍ତାଙ୍କ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଜିସୁନାଦ୍ ମହିମା ଉଡ଼୍‍ତନ୍ ନୁ ଅନ୍‌ ବିଷୟ୍‍ତେ ଗଟିକେତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଆଗେକ୍ ବା ନେତ୍‍ତାନଡ଼୍ ଲୋପେଙ୍କ୍ ନାର୍‍ଗେ ଜିସୁନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେସୁଙ୍କ୍‍ ଅଡ଼୍‌ ସମାଜଚ୍ୟୁତ ଆଦ୍‍ତଡ଼୍, ଆଦିନ୍ ସେଙ୍ଗେ ପାରୂଶୀନଡ଼୍ ମାଇଦିଙ୍କ୍ ଆଦ୍ ସ୍ୱୀକାର୍ ମାଡ଼୍‍ୱେ ମାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଇଶ୍ୱର୍‌ତେ ପ୍ରଶଂସା ୱିଡ଼୍‍ସି ବେଲାନ୍ ନାରୁଡ଼ାଦ୍ ଅନୁମତିତିଙ୍କ୍ ଗାଟି ପ୍ରେମ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜିସୁ ଗାଟିଲେଙ୍କ୍‍ଦେ କେତ୍‍ତଣ୍ଡ୍‌, “ବେନ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ମାତର୍ ନାୟାଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ନ୍, ମାତର୍ ନା ପ୍ରେରଣାକର୍ତ୍ତାନ୍ ନାଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍; ");
INSERT INTO kff_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ବେନ ନାକିଂଙ୍କ୍ ଉଡ଼୍‍ତନ୍, ଅଣ୍ଡ୍‌ ନା ୱାଦାନ୍‍କର୍ତାଙ୍କ୍ ମିକା ଉଡ଼୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଆଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ଜଗତ୍‍ତେ ୱେସ୍ ଆସ୍ ୱାସ୍‍ମିନ୍ଦେନ୍, ବେନ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ଇକାଡ଼୍‌ତାଗ୍ ମାନନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ବେନ ନା ଗଟି କେଞ୍ଜି ପାଲନ୍ ମାଡ଼ନ୍, ନାନ୍ ଅନାଦ୍‌ ବିଚାର୍ ମାଡ଼ନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଜଗତ୍‍ତାଗ୍ ବିଚାର୍ ମାଡ଼ାଙ୍କ୍ ୱାଡ଼ନ୍, ନାନ୍ ଜଗତ୍‍ତିଙ୍କ୍ ରକ୍ଷା ମାଡ଼ାଙ୍କ୍ ୱାତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ବେନ ନାକିଂଙ୍କ୍ ଆଗ୍ରାହ୍ୟ ମାଡ଼ିତନ୍ ନୁ ନାୟାଦ୍ ବାକ୍ୟ ଗ୍ରହନ୍ ମାଡ଼ନ୍, ନାୟାଦ୍ ମକମ୍‍ତେ ଗଟ୍ ଶେଷ ଦିନେତେ ଅନାଦ୍‌ ବିଚାର୍ ମାଡ଼ିତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ଇଦ୍ ସତ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନିଜେତାଗାଙ୍କ୍ କେଲନ୍, ମାତର୍ ନାନ୍ ବାତେଏ କେତିତାନ୍ ନୁ ବାତେଏ କେଞ୍ଜ୍‍ପିତାନ୍, ଆଦ୍ ନା ମାଲ୍‍ସ୍‍ୱାଦାନ୍ ବାବାଲ୍ ନାକିଂଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତନ୍; ");
INSERT INTO kff_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ମେଣ୍ଡେ ନାନ୍ ପୁତ୍‍ତାନ୍ ଅନ୍‌ ଗଟ୍ ସାରେଦିନାତ୍ ଜିୱୁନ୍ ହିଦ୍‍ତେ, ନା ବାବାଲ୍ ନାକିଂଙ୍କ୍ ବାତେଏ କେତାଙ୍କ୍ କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍, ଆଦେ ଲେକାମ୍ କେତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ଜିସୁ ଇଦ୍ ଜଗତ୍‍ତାଗାଙ୍କ୍ ବାବାନ୍ ଗାର୍‍ରେ ଆଦାନଙ୍କ୍ ଅନାଦ୍‌ ଦିନାମ୍ ଉପସ୍ଥିତ୍ ଆତ୍‍ତାଦ୍ ପୁଞ୍ଜ୍, ଜଗତ୍ ତାଗ୍ ମାନ୍ଦାନ୍ ନିଜେତ୍ ବେନ୍ ନାରୁଡ଼୍‍କ୍ ଅଣ୍ଡ୍‌ ପ୍ରେମ ମାଡ଼ି ୱାସମାତ୍‍ତନ୍, ଅଡ଼୍‌ ସାରେ ନାରୁଡ଼୍‍କ୍ ପ୍ରେମ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ମେଣ୍ଡେ ଜିସୁ ନାର୍‍କେତ୍ ବଜିତ୍ ୱେଲେ, ବେସୁଙ୍କ୍‍ ଶୟ୍‍ତାନ୍‍ ଶିମୋନ୍‍ତେ ମାର୍‍ ଇଷ୍କାରୀୟତିୟ ଯିହୁଦାନ୍ ଜିୱୁତେ ଜିସୁଙ୍କ୍ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପିଦାନ୍ ସେଙ୍ଗେ ସଂକଳ୍ପ ତିଆର୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ଆସୁଙ୍କ୍, ବାବାଲ୍ ଯେ ଅନ୍‌ କାଇଦେ ସାରେ କ୍ଷମତା ସମର୍‍ପନ୍ ମାଡ଼ି ମିନ୍ଦେନ୍ ନୁ ଅଣ୍ଡ୍‌ ଯେ ଇଶ୍ୱର୍‌ତେ କଞ୍ଜ୍ ୱାସ୍‍ମିନ୍ଦେନ୍, ମେଣ୍ଡେ ଇଶ୍ୱର୍‌ତାକେ ଆଞ୍ଜମିନ୍ଦେନ୍, ଆଦ୍ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ଆଦିଙ୍କ୍ ଜିସୁ ତିନ୍ଦାନ୍ ପଡ଼ିୟେ ତାଗାଙ୍କ୍ ତେଦି ତାନ୍ ସିଲାଟେଣ୍ଡି ୱେରଡ଼୍ ତୁୱାଲ୍ ଅସ୍ ଅଡ଼ାଦ୍‌ କଟି ବନ୍ଦନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ଆସୁଙ୍କ୍ ଜିସୁ କୁଣ୍ଡାନାଗ୍ ଏର୍‍ ତସ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଶିଷ୍ୟଡ଼ାଉ ଡେକା ନର୍‍ସିସ୍ ଅନ୍‌ କଟି ବନ୍ଦନ୍ ମାଡ଼୍‍ତେ ତୁୱାଲ୍‍ତାଗ୍ ଉଞ୍ଜ୍‍ପାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଆସୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ଶିମୋନ୍ ପିତର୍‍ତେ ପାକେ ୱାତ୍‍ତନ୍; ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ କେତ୍‍ତାନ୍, ପ୍ରବୁ ନିମ୍‍ ନା ଡେକାଙ୍କ୍ ନର୍‍ସିତ୍‍ତିନ୍ ? ");
INSERT INTO kff_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, ନାନ୍ ବାତେଏ ମାଡ଼ୁତାନ୍, ଆଦ୍ ଇଞ୍ଜେ ମିଡ଼୍ ପୁନ୍‍ୱିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ପେର୍‍କେ ପୁନ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ନିମ୍‍ ତ ବେସୁଙ୍କ୍‌ବା ନା ଡେକା ନର୍‍ସିୱିନ୍ । ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତନ୍, ଯଦି ନାନ୍ ନିକିଂଙ୍କ୍ ନର୍‍ୱନ୍, ଆଲେକେ ନାତଡ଼୍ ନିୱାଦ୍ ବାତେବା କାଇଲେ ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ଶିମୋନ୍ ପିତର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ପ୍ରବୁ, ମାତର୍ ନାୱାଦ୍ ଡେକା ଆୟ୍‍ୟ ନାୟାଉ କାଇକ୍ ନୁ ତାଲ୍ ମିକା ନର୍‍ସିମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‌, ବେନ ଏର୍‍ ମିଚ୍‍ ମିନ୍ଦେନ୍, ଅନାହୁ ଡେକା ନର୍‍ଦାନାଦ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବାତେଏ ଦର୍‍କାର୍ ଆୟ୍‍ୟ । ମିଡ଼୍ ସାରେତଡ଼୍ ଶୁଚି ବାତେଙ୍କ୍ ଇତ୍‍କେ ୱେରଣ୍ଡ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ ଅଂକିଙ୍କ୍‌ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପିତନ୍, ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ପୁଞ୍ଜ୍ ମାତ୍‍ତନ୍, ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍‌, ଅର୍‍ତୁଙ୍କ୍ ୱିଡ଼୍‍ସିତ୍‍କେ, ମିଡ଼୍ ସାରେତଡ଼ି ଶୁଚି । ");
INSERT INTO kff_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ତାନ୍‍ପେର୍କେ ଜିସୁ ଅଡ଼ାୱୁ ଡେକା ନର୍‍ସି ଅନ୍‌ ସିଲେ କେର୍‍ସ୍ ମେଣ୍ଡନ୍ ଦାମ୍ କୁଦ୍‍ତେୱେଲେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ନାନ୍ ମିଇ ମାଇଦିଙ୍କ୍ ବାତେଏ ମାଡ଼୍‍ତାନ୍, ଆଦ୍ ବାତେଏ ମିଡ଼୍ ବୁଜେମ୍ ଆତ୍‍ତିଡ଼୍‍ ? ");
INSERT INTO kff_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ମିଡ଼୍ ନାକ୍ ଗୁରୁ ନୁ ପ୍ରବୁ ଇଞ୍ଜ କାର୍‍ଙ୍ଗୁତିଡ଼୍, ଆଦ୍ ଲେକେତ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡେ ତ ନାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ମିଇ ଗୁରୁ ନୁ ପ୍ରବୁ ଆସ୍ ନାନ୍ ଯଦି ମିୟାୱୁ ଡେକା ନର୍‍ତାନ୍, ଆଲେକେ ମିଡ଼୍ ଆନ୍‌‍ତେ ନିଜେ ନିଜେ ଡେକା ନର୍‍ଦାନାଦ୍ ସାୟେ । ");
INSERT INTO kff_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଏର୍କାମାଡ଼ାଙ୍କ୍ ଇଞ୍ଜ ନାନ୍ ଇଦ୍‍ଲେକାମ୍ ମାଡ଼୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ନାନ୍ ସତ୍ କେତୁତାନ୍, ବେନବା ଦାସ ଅନ୍‌ ମାଲିକ୍ ତାଗାଙ୍କ୍ ବେଡ଼୍‍ୟନ୍ ଆୟନ୍; ପ୍ରେରିତନଡ଼୍ ତାନ୍ ପ୍ରେରନାକର୍ତା ନାଗାଙ୍କ୍ ବେନ ବେଡ଼୍‍ୟନ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ଯଦି ମିଡ଼୍ ଆଦ୍‍ ସାରେ ପୁଞ୍ଜ୍, ଆଲେକେ ଆଦେଲେକାମ୍ ମାତ୍‍କେ ମିଡ଼୍ ଦନ୍ୟ । ");
INSERT INTO kff_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ନାନ୍ ମିଇ ସାରେତଡ଼୍‍କ୍ ଇଦ୍ ଗଟ୍ କେଲନ୍; ବେନ୍ ଲେକାମ୍ ନାରୁଡ଼୍‌କ୍‍ ନାନ୍ ହେଞ୍ଚି ମିନ୍ଦେନ୍‍, ଆଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଇଦ୍ ବାକ୍ୟ ବେଦ୍‍ଲେକାମ୍ ସାରେ ଆଦ୍‍ତେ, ଆଦିଙ୍କ୍ ଇଦ୍‍ଲେକାମ୍ ଗଟେମ୍ ଆଦୁତ୍‍, ବେନ ନାୟାଦ୍ ଅନ୍‌ନ ତିନ୍ଦ୍‍ତନ୍, ଅଣ୍ଡ୍‌ ନା ବିରୁଦ୍‍ତେ ଲାତ୍ ତେହେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ଆଦ୍ ଗଟେମ୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ । ବେସୁଙ୍କ୍‍ ଆଦ୍ ଗଟେମ୍ ଆଦ୍‍ତେ, ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତିଡ଼୍ ଯେ, ନାନ୍ ବେନ ଅଣ୍ଡେ ନାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଯେ ନା ପ୍ରେରିତ୍ ନାରୁଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍ ନୁ ବେନ ନାକିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନା ତ୍ରାଣକର୍ତ୍ତାଙ୍କ୍‍ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଜିସୁ ଇଦ୍‍ସାରେ ଗଟିକେତ୍‍ତେ ପେର୍‍କେ ଆତ୍ମାତାଗ୍ ଉଦ୍‍ବିଗ୍ନ ଆତ୍‍ତନ୍ ନୁ ବେନ୍‍ଲେକାମ୍ ସାକ୍ଷ୍ୟ ଇସ୍ କେତ୍‍ତନ୍, ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ମିୟାଗାଙ୍କ୍ ୱେରନ୍ ନାକିଂଙ୍କ୍ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପିଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ଜିସୁ ବେନଙ୍କ୍ ଲକ୍ଷ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍‌, ଆଦ୍ ବିଷୟ୍‍ତେ ଅତବୁଦି ଆସ୍ ଶିଷ୍ୟନଡ଼୍ ତାମ୍‍ତାମ୍ ଉଡାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଅଡ଼୍‌ ଆଗାଙ୍କ୍‌ ବେନ୍ ଶିଷ୍ୟଙ୍କ୍ ଜିସୁ ଗାଟି ପ୍ରେମ ମାଡ଼ମାତ୍‍ତନ୍, ଅନ୍‌ ଜିସୁନ୍ ଗାର୍‍ରେ କୁଦିମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ଶିମୋନ୍ ପିତର୍ ଅଂକିଙ୍କ୍‌ ଶଙ୍କେତ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବେନ ବିଷୟ୍‍ତେ କେତୁତନ୍, ଆଦ୍ କେଲ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ଅଣ୍ଡ୍‌ ଆଦେଲେକାମ୍ କୁଦିମାଞ୍ଜ୍ ଜିସୁନ୍ ଗାର୍‍ରେୱାସ୍ ଆଡ଼୍‌‍ଗି ମାଡ଼୍‍କି କେତ୍‍ନ୍, ଅଣ୍ଡ୍‌ ବେନ ପ୍ରବୁ ? ");
INSERT INTO kff_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ଆସୁଙ୍କ୍ ଜିସୁ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍‌, ବେନ ସେଙ୍ଗେ ନାନ୍ ଇଦ୍‍ରୁଟିତିଙ୍କ୍ ମୁହୁସ୍ ନୁ ବେନଙ୍କ୍ ଆଦ୍ ଇଦ୍‍ତାନ୍, ଅଣ୍ଡ୍‌ । ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ରଟିତିଙ୍କ୍ ମୁହୁସ୍ ଆଦ୍‍ଅସ୍ ଇଷ୍କାରୀୟତିୟ ଶିମୋନ୍‍ତେ ମାର୍‍ ଯିହୁଦାଙ୍କ୍ ହିତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ଅଣ୍ଡ୍‌ ରୂଟି ଇତ୍‍ତେ ୱେଲେ ଶୟ୍‍ତାନ୍‍ ଅନାଗ୍ ନେଙ୍ଗ୍‍ତେ । ଆଗାଙ୍କ୍ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‌, ବାତେଏ ମାଡ଼ୁତିନ୍, ଆଦ୍ ଜାପେ ମାଡ଼େ । ");
INSERT INTO kff_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବେନ୍ ଗଟ୍‍ତେ ଅଂକିଙ୍କ୍‌ ଇଦ୍ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍‌, ଆଗେ ବଜିତାଗ୍ କୁଦିମାନ୍ଦାନ୍ ନାରୁଡ଼ାଗାଙ୍କ୍ ବେନ ପୁନଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯିହୁଦାତାଗ୍ ଡାବ୍‍ ମୁନେ ମାନ୍‍ନାଙ୍କ୍, ପାଣ୍ଡୁମ୍ ସେଙ୍ଗେ ବାତେଏ ଆଦାନାଦ୍, ଆଦ୍ ଆସାନଙ୍କ୍ ବା ଦରିଦ୍ର ନାରୁଡ଼୍‍କ୍ ବାତେଏ ଦାନ ମାଡ଼ାଙ୍କ୍ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‌ ଇଞ୍ଜ ବେନ ଏର୍କା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ରୂଟିସୁଦୁଟ୍ ଆସ୍‍ମିକା ଅଣ୍ଡ୍‌ ଆସୁଙ୍କ୍ ଯାପେ ପେଇସ୍ ଆତ୍‍ତଣ୍ଡ୍, ଆସୁଙ୍କ୍ ଇକାଡ଼୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଅଣ୍ଡ୍‌ ପେଇସ୍ ଆତ୍‍ତେ ୱେଲେ ଜିସୁ କେତ୍‍ତଣ୍ଡ୍‌, ଇଞ୍ଜେ ନାରୁନ୍ ପିଲା ମହିମାନିତ ପ୍ରକାଶ୍ ଆତ୍‍ତେ ନୁ ଅନ୍‌ ତଡ଼୍ ଇଶ୍ୱର୍ ମାହିମାନିତ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଯଦି ଇଶ୍ୱର୍ ଅନାଗେ ମହିମାନିତ ଆତ୍‍ତଣ୍ଡ୍, ଆଲେକେ ଇଶ୍ୱର୍ ମିକା ନାରୁନ୍‍ପିଲ୍ ଅନାଗ୍ ମହିମାନିତ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ଯାପେ ଅଂକିଙ୍କ୍‌ ମହିମାନିତ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍ ପିଲାନଡ଼ି ନାନ୍ ମିତଡ଼୍ ମେଣ୍ଡେ ନାର୍‍ଗେ ଦିନାମ୍ ମାନନ୍ । ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେହେକିତିଡ଼୍, ମେଣ୍ଡେ ନାନ୍ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ଆଦୁତାନ୍, ମିଡ଼୍ ଆଦ୍‍ପଡ଼ିୟେତାଗ୍ ଆଦ୍ ପାର୍‍ୱିଡ଼୍, ଇଦ୍ ନାନ୍ ବେଲା ଇହୁଦିନଡ଼କ୍ କେତ୍‍ତାନ୍, ଆଦେଲେକାମ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ମିଡ଼୍ ସାରେ ତଡ଼କିଙ୍କ୍ ପ୍ରେମ ମାଡ଼ାଟ୍, ଇଦ୍ ପୁଃନେ ଗଟ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ଇସମିନ୍ଦେନ୍; ନାନ୍ ବେଦ୍‍ଲେକାମ୍ ମିକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼୍‍ତାନ୍, ମିଡ଼୍‍ଆନ୍‌ନ୍ତେ ଆଦେଲେକାମ୍ ନିଜେ ନିଜେ ପ୍ରେମ ମାଡ଼ାନ୍ ଲେକାମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ଯଦି ମିୱାଦ୍ ମିଇ ମିଇ ଲୋପେ ପ୍ରେମ ମାତ୍‍କେ, ଆଲେକେ ମିଡ଼୍ ଯେ ନା ଶିଷ୍ୟ, ଇଦ୍ ସାରେତଡ଼୍ ଇଦିନ୍ ତଡ଼୍ ଗ୍ୟାତ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ଶିମୋନ୍ ପିତର୍ ଜିସୁଙ୍କ୍ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, ପ୍ରବୁ, ନିମ୍‍ ବେଗା ଅଦୁତିନ୍ ? ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତନ୍, ନାନ୍ ବେଗା ଆଦୁତାନ୍, ମିଡ଼୍ ଇଞ୍ଜେ ନା ପେର୍‍କେ ପେର୍‍କେ ଆଗେ ଆଦ୍ ପାର୍‍ୱିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ପାୟେ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପିତର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‌, ପ୍ରବୁ, ନାନ୍ ଇଞ୍ଜେ ବାତ୍‍ତିଙ୍କ୍ ନି ପେର୍‍କେ ଆତ୍‍ତାଙ୍କ୍ ପାର୍‍ୱନ୍ ? ନାନ୍ ନି ସେଙ୍ଗେ ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍ ହିଦାଙ୍କ୍ ତିଆର୍ ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, ନିମ୍‍ ବାତେଏ ନା ସେଙ୍ଗେ ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍ ହିଦ୍‍ତିନ୍ ? ସତ୍ ନାନ୍ ନିକିଂଙ୍କ୍ କେସ୍‍ମିନ୍ଦେନ୍, କର୍କ୍ କୁସ୍‍ୱେ ମୁନେଙ୍କ୍ ନିମ୍‍ ନାକିଂଙ୍କ୍ ମୁଣ୍ଡୁ ଦାମ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ିତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, ମିୟାଦ୍ ହୃଦୟ୍ ଉଦ୍‍ବିଗ୍ନ ଆୟ୍‍ମା; ମିଡ଼୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍, ନାକିଂଙ୍କ୍ ମିକା ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ନା ବାବାନ୍ ଲୋନ୍‌ ନାର୍‍ଗେ ପଡ଼ିୟେମିନ୍ଦେ; ଯଦି ଇଲକଟ୍ ମାନେଡ଼୍‍, ଆଲେକେ ନାନ୍ ମିକିଂଙ୍କ୍ କେଲନ୍ ଆୟେନ୍, ନାନ୍ ମିଇ ସେଙ୍ଗେ ପଡ଼ିୟେ ମାଡ଼ାଙ୍କ୍ ଆଦୁତାନ୍; ");
INSERT INTO kff_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ମେଣ୍ଡେ ନାନ୍ ଆଞ୍ଜ୍ ମିଇ ମାଇଦିଙ୍କ୍ ପଡ଼ିୟେ ମାଡ଼ି ମେଣ୍ଡନ୍ ଦାମ୍ ୱାଦ୍‍ତାନ୍, ମେଣ୍ଡେ ନାନ୍ ବେନ୍ ପଡ଼ିୟେ ତାଗ୍ ମାନ୍‍ତାନ୍, ମିଡ଼୍‍ଆନ୍‌ନ୍ତେ ଆଗେ ମାନ୍‍ତିଡ଼୍, ଆଦିନ୍ ସେଙ୍ଗେ ମିଇ ପାକେ ୱାଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ନାନ୍ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ଆଦୁତାନ୍, ଆଦ୍ ଆର୍ ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତୋମାଲ୍‌ ଅଂକିଙ୍କ୍‌ ପଚ୍ରାରା ମାଡ଼୍‍ତଣ୍ଡ୍‌, ପ୍ରବୁ, ନିମ୍‍ ବେନ୍ ପଡ଼ିୟେ ତାଗ୍ ଅଦୁତିନ୍, ଆଦ୍‍ମାମେ ପୁନ୍‍ନମ୍; ଆର୍ ବା ବେଲା ପୁତ୍‍ତମ୍ ? ");
INSERT INTO kff_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‌, ନାନ୍ ଆର୍, ସତ୍ ନୁ ଜିୱୁନ୍; ନାଆଲାନ୍ ଅନ୍‌‍ୱେ ବେନବା ବାବାନ୍ ଗାର୍‍ରେ ଆଦ୍‍ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ଯଦି ମିଡ଼୍ ନାକିଂଙ୍କ୍ ପୁଞ୍ଜ୍ ମାନେଡ଼ି, ଆଲେକେ ନା ବାବାଙ୍କ୍ ମିକା ପୁନେଡ଼ି; ଇଞ୍ଜେ ଅଂକିଙ୍କ୍‌ ପୁତ୍‍ତିଡ଼୍ ନୁ ଅଂକିଙ୍କ୍‌ ଉଡ଼ୁତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତେ, ପ୍ରବୁ, ମାକିଂଙ୍କ୍ ବାବାନ୍ ତ ଦର୍ଶନ୍ ମାଡ଼ିମ୍, ଆଦ୍ ମା ସେଙ୍ଗେ ଯତେଷ୍ଟ । ");
INSERT INTO kff_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ପିଲିପ୍, ଇସର୍ ଯାକ ନାନ୍ ନି ସାଙ୍ଗେତେ ମିନ୍ଦେନ୍, ମେଣ୍ଡେ ନିମ୍‍ ବାତେଏ ନାକିଂଙ୍କ୍ ପୁନ୍‍ୱିନ୍ ? ବେନ ନାକିଂଙ୍କ୍ ଦର୍ଶନ୍ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବାବାଙ୍କ୍ ଦର୍ଶନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍; ମାକିଂଙ୍କ୍ ବାବାନ୍ ଦର୍ଶନ୍ ମାଡ଼ିମ୍ ଇଞ୍ଜ ନିମ୍‍ ବେଲା କେତୁତିନ୍ ? ");
INSERT INTO kff_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ନାନ୍ ଯେ ବାବାନାଗେ ମିନ୍ଦେନ୍ ନୁ ବାବାଲ୍ ନାୟାଗ୍ ମିନ୍ଦେନ୍, ଇ ଗଟ୍ ବାତେଏ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ୱିନ୍ ? ନାନ୍ ମିକିଂଙ୍କ୍ ବେନ୍ ସାରେ ବାକ୍ୟ କେତ୍‍ତାନ୍, ଆଦ୍‍ ସାରେ ନା ନିଜେତ୍ ତାଗାଙ୍କ୍ କେଲନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାନାଗେ ମାଞ୍ଜ୍ ନିଜେତ୍ ପାଡ଼୍‍ୟି ମାଡ଼ୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ନାନେଜେ ବାବାନାଗେ ମିନ୍ଦେନ୍ ନୁ ବାବା ନାଗେ ମିନ୍ଦେନ୍, ନାୟାଉ ଇଉସାରେ ଗଟି ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍, ଇଲୁକ୍ ନାୟାଦ୍ ପାଡ଼୍‍ୟି ଉଡ଼ି ବିଶ୍ୱାସ୍ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ନାୟାଗେ ବେନ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ନାନ୍ ବେନ୍ ପାଡ଼୍‍ୟି ମାଡ଼ୁତାନ୍, ଅଣ୍ଡ୍‌ ମିକା ଆଦେ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ଆଦ୍‍ ସାରେ ୱିଡ଼୍‍ସି ଗାଟି ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ିତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ବାବାନ୍ ଗାର୍‍ରେ ଆଦୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ମେଣ୍ଡେ ନା ପେଦେର୍ ତେ ବାତେଏ ତାଲ୍‍କିତିଡ଼୍, ଆଦ୍ ନାନ୍ ମାଡ଼ିତାନ୍ । ବେଲାକି ପିଲାନ୍ ତଡ଼୍ ବାବାନାଦ୍ ମହିମା ପ୍ରକାଶ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ଯଦି ମିଡ଼୍ ନା ପେଦେର୍ ତେ ବାତେଏ ବିଷୟ ନାକିଂଙ୍କ୍ ତାଲ୍‍କିତିଡ଼୍, ନାନ୍ ଆଦ୍ ମାଡ଼ିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ଯଦି ମିଡ଼୍ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତିଡ଼୍, ଆଲେକେ ନାଉ ଗଟ୍ ସାରେ ପାଲନ୍ ମାଡ଼ିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ମେଣ୍ଡେ, ନାନ୍ ବାବାଙ୍କ୍ ଅନୁରଦ୍‌ ମାଡ଼ିତାନ୍, ମେଣ୍ଡେ ମିଇ ସାଙ୍ଗେତେ ସାରେଦିନା ମାନ୍ଦାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ମେଣ୍ଡେ ୱେରନ୍ ସାହାଜ୍ୟ କାର୍‍ଙ୍ଗି ହିଦ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ଅଣ୍ଡ୍‌ ସତ୍ୟମୟ ଆତ୍ମାଙ୍କ୍ ହିଦ୍‍ତନ୍ । ଜଗତ୍ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼େ ପାର୍‍ୱ, ବାତ୍‍ତିଙ୍କ୍ ଜଗତ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ କି ପୁନ୍‍ନ; ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ପୁତ୍‍ତିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ମିଇ ତଡ଼୍ ମାନ୍‍ତନ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ମିଇ ଜିୱେତାଗ୍ ମାନ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","ନାନ୍ ୱିଡ଼୍‍ସି ଆତ୍‍ତେ ପେର୍‍କେ, ମିକିଂଙ୍କ୍ ଅନାତ୍ ମାଡ଼ି ୱିଡ଼୍‍ସି ଆନନ୍, ନାନ୍ ମିଇ ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ୱାଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ସୁଦୁଟ୍ ମାତର୍ ଦିନାମ୍ ମିନ୍ଦେ, ଜଗତ୍ ନାକିଂଙ୍କ୍ ମେଣ୍ଡେ ଉଡ଼; ମାତର୍ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଉଡ଼ିତିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଜିୱେ, ମେଣ୍ଡେ ମିଡ଼୍ ଆନ୍‌‍ତେ ଜିୱେ ମାନ୍ଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ନାନ୍ ବାବାନାଗ୍ ମେଣ୍ଡେ ମିଡ଼୍ ନାୟାଗ୍ ମିନ୍ଦେଡ଼ି, ଇଦ୍ ଆଦ୍ ଦିନ୍ ୱାତ୍‍କେ ପୁନ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ବେନ ନା ଗଟିସାରେ ଗ୍ରହନ୍ ମାଡ଼ି ପାଲନ୍ ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ବେନ୍ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ିତନ୍, ନା ବାବାଲ୍ ଅଂକିଙ୍କ୍‌ ପ୍ରେମ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ନାନେମିକା ଅଂକିଙ୍କ୍‌ ପ୍ରେମ ମାଡ଼ିତାନ୍ ନୁ ଅଂକିଙ୍କ୍‌ ପ୍ରକାଶ୍ ମାଡ଼ିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଯିହୁଦା, ବେନ ଇଷ୍କାରୀୟତିୟ ଆୟନ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍‌, ହଁ ପ୍ରବୁ, ଇଦ୍ ବେଲା ଆଦ୍‍ତେ, ନିଜେତିଙ୍କ୍ ଜଗତ୍‍ତାଗ୍ ତିଆର୍ ମାଡ଼କଟ୍ ମା ପାକେ ବେଲା ତିଆର୍ ମାଡ଼ିତି ? ");
INSERT INTO kff_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ କେତ୍‍ତଣ୍ଡ୍‌, ଯଦି ବେନ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼୍‍କେ ଆଲେକେ ଅଣ୍ଡ୍‌ ନା ବାକ୍ୟ ପାଲନ୍ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ନା ବାବାଲ୍ ଅଂକିଙ୍କ୍‌ ପ୍ରେମ ମାଡ଼ିତନ୍, ମେଣ୍ଡେ ମାମ୍‍ମେ ଅନ୍‌ ପାକେ ୱାସ୍ ଅନ୍‌ ତଡ଼୍ ମାନ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ବେନ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ନ୍, ଅଣ୍ଡ୍‌ ନା ବାକ୍ୟ ପାଲନ୍ ମାଡ଼ନ୍ । ନାନ୍ ଇସ୍‍ମାନ୍ଦାନ୍ ଶିକ୍ଷା ନାୱାଦ୍ ଆୟ୍‍ୟ ଆଦ୍ ନା ପ୍ରେରଣାକର୍ତ୍ତାନ୍ ଇଶ୍ୱର୍‌ତାଦ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ନାନ୍ ମିଇ ପାକେ ମାନ୍ଦାନ୍‍ୱେଲେ ଇଦ୍ ସାରେ ଗଟ୍ କେସ୍‍ସିତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ଆଦ୍ ସାହାଯ୍ୟୟକାରି ବେନ୍ ପବିତ୍ର ଆତ୍ମାତିଙ୍କ୍ ବାବାଲ୍ ନା ପେଦେର୍ ତେ ମାଲ୍‍ପିତନ୍, ଅଣ୍ଡ୍‌ ସାରେ ବିଷୟ୍‍ତେ ମିକିଂଙ୍କ୍ ବାତେଏ କେସ୍‍ମିନ୍ଦେନି, ଆଦ୍‍ ସାରେ ମିକିଂଙ୍କ୍ ଏର୍କା ମାଡ଼ିଦ୍‍ତଣ୍ଡ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","ନାନ୍ ମିକିଂଙ୍କ୍ ଶାନ୍ତି ଦାନ ମାଡ଼ି ଆଦୁତାନ୍, ନାୱାଦ୍ ନିଜେତ୍ ଶାନ୍ତି ମିକିଂଙ୍କ୍ ଇଦୁତାନ୍; ଜଗତ୍ ବେଲା ଦାନ ମାଡ଼ିତେ, ନାନ୍ ମିକିଂଙ୍କ୍ ଆଦେଲେକାମ୍ ଦାନ ମାଡ଼ନ୍ । ମିୱାଦ୍ ହୃଦୟ୍ ଉଦ୍‍ବିଗ୍ନ କି ୱେର୍‍ମାକି । ");
INSERT INTO kff_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ନାନ୍ ଆଦୁତାନ୍ ନୁ ମେଣ୍ଡେ ମିଇ ପାକେ ୱାଦ୍‍ତାନ୍, ନାୱାଦ୍ ଇଦ୍ ଗଟ୍ ତ କେଞ୍ଜି ମିନ୍ଦେଡ଼ି । ଯଦି ମିଡ଼୍ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼େଡ଼ି, ଆଲେକେ ନାନ୍ ନା ବାବାନ୍ ପାକେ ଆଦୁତାନ୍ ଇଞ୍ଜ କେଞ୍ଜି ୱେଡ଼୍‍କେ ମାଡ଼େଡ଼ି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍ ନାୟାଗ୍‍କଞ୍ଜ୍ ମହାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ମେଣ୍ଡେ, ଇଦ୍ ଗଟେମ୍ ଆଦାନ୍ ୱେଲେ ମିଡ଼୍ ବେଲାକି ବିଶ୍ୱାସ୍ ମାଡ଼ିତିଡ଼୍, ଆଦିନ୍ ସେଙ୍ଗେ ଆଦ୍ ଗଟେମ୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ନାନ୍ ମିତଡ଼୍ ନାର୍‍ଗେ ଜେଲ୍ ଗଟି ମାନନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇ ଜଗତ୍‍ତେ ଅଦିପତି ୱାଦୁତଣ୍ଡ୍ । ନା ପର୍‍ର ଅନାଦ୍‌ ବାତେମିକା ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାଲ୍‌ ନାକିଂଙ୍କ୍ ବେଲା ଗଟ୍ ଇତ୍‍ତନ୍, ଆଦେ ଲେକାମ୍ ନାନ୍ ପାଡ଼୍‍ୟି ମାଡ଼ିତାନ୍ । ଆଲେକେ, ନାନ୍ ନା ବାବାଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତାନ୍ ଇଞ୍ଜ ଜଗତ୍ ପୁନ୍‍ତେ, “ୱାଡ଼ାଟ୍ ମାନାଡ଼୍ ଇଗାଙ୍କ୍ ଆଦିକାଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ନାନ୍ ନିଜାତାଦ୍ ଅଙ୍ଗୁର୍‌ ଟଣ୍ଡ୍, ମେଣ୍ଡେ ନା ବାବାଲ୍ ଚାଷୀ ନାରୁଣ୍ଡ୍‌ । ");
INSERT INTO kff_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ନାୟାଗେ ମାନ୍ଦାନ୍ ବେନ୍ ଆୟି କମ୍‍ମା କାୟା ଆଦକ୍, ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ନାଡ଼୍‍କିତଣ୍ଡ୍; ମେଣ୍ଡେ କାୟା ଆଦ୍‍କେ, ଗାଟି କାୟା ଆଦାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ସାଏ ଜତନ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ନାନ୍ ମିକିଂଙ୍କ୍ ବେନ୍ ବାକ୍ୟ କେସ୍‍ମିନ୍ଦେନ୍ ଆଦିନ୍ ସେଙ୍ଗେ ମିଡ଼୍ ସାଏ ଆସ୍ ମିନ୍ଦେଡ଼ି । ");
INSERT INTO kff_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ନାୟାଗେ ମାନୁଟ୍, ଆଲେକେ ନାନ୍ ମିୟାଗ୍ ମାନ୍‍ତାନ୍ । କମ୍‍ମା ବେଲା ଅଙ୍ଗୁର୍‌ ଟଣ୍ଡେତାଗ୍ ମାନୋକ୍ କାୟା ଆଦେ ପାର୍‍ୱେ, ଆଦେପୁଟୁଙ୍କ୍ ମିଡ଼୍ ମିକା ନାୟାଗେ ମାନୋକ୍ କାୟା ଆଦେ ପାର୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ନାନ୍ ଅଙ୍ଗୁର୍‌ ଟଣ୍ଡ୍ ମିଡ଼୍ ଆଦୁତିଡ଼୍ କମ୍‍ମା; ବେନ ନାୟାଗ୍ ମାନ୍‍ତଣ୍ଡ୍ ନୁ ନାନ୍ ବେନନାଗ୍‍ ମାନ୍‍ତାନ୍, ଅଣ୍ଡ୍‌ ଗାଟି କାୟା ଆଦିତଣ୍ଡ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଇଲ୍‍ଉକ୍ ମିଡ଼୍ ବାଆତେ ମିକା ମାଡ଼୍ ପାର୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ବେନ ବେସୁଟେ ନାୟାଗ୍ ମାନନ୍, ଆଲାଇତ୍‍କେ ଅଙ୍କ୍‌ ନାଡ଼୍‌କ୍‍ତାଦ୍ କମ୍‍ମା ଲେକାମ୍ ବାଇଦେ ହେସିଦ୍‍ତଡ଼୍ ନୁ ୱାସ୍‍ପିତ୍‍ଡ଼୍, ମେଣ୍ଡେ ନାରୁଡ଼୍ ଆୱିଙ୍କ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ି କିସ୍‍ତାଗ୍ ୱାଟିଦ୍‍ତଡ଼୍ ନୁ ଆୱ୍‍ଚାରେ କାଡ଼୍‍ୱିତା । ");
INSERT INTO kff_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ଯଦି ମିଡ଼୍ ନାୟାଗେ ମାନ୍‍ତିଡ଼୍, ମେଣ୍ଡେ ନାୟାୱ୍ ବାକ୍ୟ ମିୟାଗ୍ ମାନ୍‍ତା, ଆଲେକେ ବେନେଆୟି ବିଷୟ୍ ଇଚ୍ଛା ମାଡ଼ିତିଡ଼୍, ଆଦ୍ ତାଲ୍‍କାଟ୍, ମେଣ୍ଡେ ମିଇ ମାଇଦିଙ୍କ୍ ଆଦ୍ ଦର୍‍କିତେ । ");
INSERT INTO kff_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ମିଡ଼୍ ନାର୍‍ଗେ କାୟା ଆଦ୍‍କେ ନା ବାବାଲ୍ ମହିମାନିତ ଆଦ୍‍ତନ୍, ମେଣ୍ଡେ ମିଡ଼୍ ନା ସାଏତ୍ ଶିଷ୍ୟଡ଼୍ ଆଦ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ବାବାଲ୍ ବେଲା ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼୍‍ତଣ୍ଡ୍, ନାନ୍ ମିକା ଆଲେକେ ମିକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼୍‍ତାନ୍; ନା ପ୍ରେମାତାଗ୍ ତିଆର୍ ଆସ୍ ମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ନାନ୍ ବେଲା ନା ବାବାନ୍ ଗଟ୍ ପାଲନ୍ ମାଡ଼ି ଅନାଦ୍‌ ପ୍ରେମାତାଗ୍ ତିଆର୍ ଆତ୍‍ତାନ୍, ଆଦେପୁଟୁଙ୍କ୍ ମିଡ଼୍ ମିକା ନା ଗଟ୍ ପାଲନ୍ ମାଡ଼ିତିଡ଼୍, ନା ପ୍ରେମାତାଗ୍ ତିଆର୍ ଆଦେ ପାର୍‍ଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ନାୱାଦ୍ ୱେଡ଼୍‍କ୍ ବେଲାକି ମିୟାଗ୍ ମାନ୍‍ତେ, ମେଣ୍ଡେ ମିୱାଦ୍ ୱେଡ଼୍‍କା ବେଲା ସାରେ ଆଦ୍‍ତେ, ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ଇୱୁସାରେ ମିକିଂଙ୍କ୍ କେତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ନାନ୍ ବେଲା ମିକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼୍‍ତାନ୍, ମିଡ଼୍ ମିକା ଆଲେକେ ମିଇ ମିଲୋପେ ପ୍ରେମ ମାଡ଼ାଟ୍, ଇଦ୍ ନାୱାଦ୍ ଗଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ନିଜେତ୍ ସାଙ୍ଗନ୍ ସେଙ୍ଗେ ଜିୱୁନ୍‍ ଇଦାନ୍ କନ୍‍ସ୍ ବେନନାଦ୍ ମେଣ୍ଡେ ଗାଟି ପ୍ରେମ ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ନାନ୍ ମିକିଂଙ୍କ୍ ବେନ୍ ଗଟ୍ ହିସମିନ୍ଦେନ୍, ଆଦ୍ ଯଦି ପାଲନ୍ ମାଡ଼ିତିଡ଼୍, ଆଲେକେ ମିଡ଼୍ ନା ସାଙ୍ଗ । ");
INSERT INTO kff_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ନାନ୍ ମିକିଂଙ୍କ୍ ଚାକର୍ ଇଞ୍ଜ ମେଣ୍ଡେ କେଲନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାଲିକ୍ ବାତେଏ ମାଡ଼ିତନ୍, ଚାକର୍ ଆଦ୍ ପୁନଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ ସାଙ୍ଗ ଇଞ୍ଜ କେସ୍‍ମିନ୍ଦେନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନା ବାବାନ୍ କନ୍‍ସ୍ ବାତେଏ କେଞ୍ଜିମିନ୍ଦେନ୍, ଆୱ୍‍ଚାରେ ମିକିଂଙ୍କ୍ କେତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ମିଡ଼୍ ନାକିଂଙ୍କ୍ ହେଞ୍ଚୱିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ ହଞ୍ଚିମିନ୍ଦେନ୍, ମେଣ୍ଡେ ବେଲା ଆଞ୍ଜ୍ କାୟା ଆଦ୍‍ସ୍‍ପିତିଡ଼୍ ନୁ ମିୟାୱୁ କାୟା ସାରେଦିନା ଆଦଡ଼େ ମାନ୍‍ତା, ଇଦିନ୍ ସେଙ୍ଗେ ମିକିଂଙ୍କ୍ ହେଞ୍ଚିମିନ୍ଦେନ୍ । ଆଗାଙ୍କ୍ ମିଡ଼୍ ନା ପେଦେର୍ ତେ ବାବାଙ୍କ୍ ବାତେମିକା ତାଲ୍‍କିତିଡ଼୍, ଅଣ୍ଡ୍‌ ଆଦ୍ ମିକିଂଙ୍କ୍ ହିଦ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ମିଡ଼୍ ବେଲା ମିଇ ମିଲୋପେ ପ୍ରେମ ମାଡ଼ିତିଡ଼୍, ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ମିକିଂଙ୍କ୍ ଇଦ୍‍ସାରେ ଗଟ୍ ଇସମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ଯଦି ଜଗତ୍ ମିକିଂଙ୍କ୍ ପାସ୍‍କି ତେ, ଆଲେକେ ମିକିଂଙ୍କ୍ ପାସ୍‍କାନ୍‌ ମୁନେଙ୍କ୍ ଆଦ୍ ନାକିଂଙ୍କ୍ ପାସ୍‍କି ତେ, ଇଦ୍ ପୁଞ୍ଜ୍ ମାନୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ମିଡ଼୍ ଯଦି ଜଗତ୍‍ତାଗ୍ ମାନେଡ଼ି, ଜଗତ୍ ମିକିଂଙ୍କ୍ ନିଜେତ୍ ନାରୁଡ଼୍ ଇଞ୍ଜ ସ୍ନେହ ମାଡ଼େଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜଗତ୍‍ତାଗାଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ଜଗତ୍ ଲୋପେଙ୍କ୍ ହେଞ୍ଚିମିନ୍ଦେନ୍, ମେଣ୍ଡେ ମିଡ଼୍ ଜଗତ୍‍ତଡ଼ି ଆୟୱିଡ଼୍, ଇଦିନ୍ ସେଙ୍ଗେ ଜଗତ୍ ମିକିଂଙ୍କ୍ ପାସ୍‍କି ତେ । ");
INSERT INTO kff_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‘ଚାକର୍ ତାନ୍ ମାଲିକ୍ ତାଗାଙ୍କ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ଆୟ୍‍ୟଣ୍ଡ୍,’ ନାନ୍ ମିକିଂଙ୍କ୍ ଇଦ୍ ବେନ୍ ବାକ୍ୟ କେସ୍‍ମିନ୍ଦେନ୍, ଆଦିଙ୍କ୍ ହେର୍କା ମାଡ଼ାଟ୍ । ଯଦି ଅଡ଼୍‌ ନାକିଂଙ୍କ୍ ତାଡ଼ନା ମାଡ଼ିମିନ୍ଦେଡ଼୍, ଆଲାଇତ୍‍କେ ମିକିଂଙ୍କ୍ ମିକା ତାଡ଼ନା ମାଡ଼ିତଡ଼୍; ଯଦି ଅଡ଼୍‌ ନାୱାଦ୍ ବାକ୍ୟ ପାଲନ୍ ମାଡ଼ିମିନ୍ଦେଡ଼୍, ଆଲାଇତ୍‍କେ ମିୱାଦ୍ ବାକ୍ୟ ମିକା ପାଲନ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ନାକିଂଙ୍କ୍ ରଅତେନଙ୍କ୍ ପୁନ୍‍ୱା ମାଇଦିଙ୍କ୍ ନାୱାଦ୍ ପେଦେର୍ ସେଙ୍ଗେ ମିକିଂଙ୍କ୍ ଇଦ୍‍ସାରେ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଯଦି ନାନ୍ ୱାସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେଲ୍‍ୱକଟ୍ ମାନେନ୍, ଆଲାଇତ୍‍କେ ଅଡ଼୍‌‍ୱାଦ୍ ପାପ୍ ଆୟ୍‍ ଆୟେଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଞ୍ଜେ ଅଡ଼୍‌ ଅଡ଼ାଦ୍‌ ପାପ୍ ବିଷୟ୍ ତେ ବାତେମିକା ବାହାନା ମାଡ଼େ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ବେନ ନାକିଂଙ୍କ୍ ପାସ୍‍କିତନ୍, ଅଣ୍ଡ୍‌ ନା ବାବାଙ୍କ୍ ମିକା ପାସ୍‍କିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ବେନ୍ ପାଡ଼୍‍ୟି ସାରେ ମେଣ୍ଡେ ବେନମିକା ମାଡ଼ଣ୍ଡ୍, ନାନ୍ ଯଦି ଆୱୁସାରେ ଅଡ଼୍‌ ଲୋପେ ମାଡ଼୍‍ୱକଟ ମାନେନ୍, ଆଲାଇତ୍‍କେ ଅଡ଼ାଦ୍‌ ପାପ୍ ଆୟ୍‍ୟ ଆୟେଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଞ୍ଜେ ଅଡ଼୍‌ ଉଡ଼ିମିନ୍ଦେଡ଼୍, ମେଣ୍ଡେ ନାକିଂଙ୍କ୍ ନୁ ନା ବାବାଙ୍କ୍ ଇର୍‍ୱୁଡ଼୍‍କ୍ ପାସ୍‍କି ମିନ୍ଦେଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","‘ମାତର୍ ଅଡ଼୍‌ ନାକିଂଙ୍କ୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଲ୍‍ୱାକଟ ପାସ୍‍କି ମାଡ଼୍‍ତଡ଼୍,’ ଅଡ଼ାଦ୍‌ ଶାସ୍ତ୍ରତାଗ୍ କେତ୍‍ତାଦ୍ ଇଦ୍ ବାକ୍ୟ ବେଲା ସାରେ ଆଦ୍‍ତେ, ଇଦିନ୍ ସେଙ୍ଗେ ଇଲା ଆଦୁତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ବାବା ନାୟାଗ୍‍କଞ୍ଜ୍ ନାନ୍ ମିଇ ଗାର୍‍ରେ ବେନ ସାହାଜ୍ୟ ମାଡ଼ାନଙ୍କ୍ ରଅତିତାନ୍, ବାବା ନାୟାଗ୍‍କଞ୍ଜ୍ ପେଇତାଦ୍ ଆଦ୍ ସତ୍ ଆତ୍ମା ୱାତ୍‍କେ ନା ବିଷୟ୍‍ତେ ସାକ୍ଷି ହିଦ୍‍ତା; ");
INSERT INTO kff_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ମେଣ୍ଡେ ମିଡ଼୍ ମିକା ସାକ୍ଷି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ଆରାମ୍ କନ୍‍ସ୍ ନା ତଡ଼୍ ମିନ୍ଦେଡ଼ି ।” ");
INSERT INTO kff_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ମିଡ଼୍ ବେଲା ବିଶ୍ୱାସ୍ ଆରା ମାଡ଼୍‍ୱିଡ଼୍ ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ମିକିଂଙ୍କ୍ ଇଦ୍‍ସାରେ ଗଟ୍ କେସ୍‍ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ଅଡ଼୍‌ ମିକିଂଙ୍କ୍ ପ୍ରାର୍ତନା କନ୍‍ସ୍ ପେସ୍ପିତଡ଼୍, ଇଦ୍ ଲେକାମ୍ ଦିନାମ୍ ୱାଦୁତେ, ବେସୁଟ୍‌ ବେନ ମିକିଂଙ୍କ୍ ହାୱ୍‍କିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ସେଙ୍ଗେ ବଲି ଇଦୁତାନ୍ ଇଞ୍ଜ ହେର୍କା ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ନାରୁଡ଼୍ ଇୱୁସାରେ ମାଡ଼ିତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ବାବାଙ୍କ୍ ନୁ ନାକିଂଙ୍କ୍ ପୁନଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ମାତର୍ ଇଦ୍‍ସାରେ ଗଟେମ୍‍ଆଦାନ୍ ଦିନାମ୍ ୱାତ୍‍କେ, ନାନ୍ ବାତେଏ ମିକିଂଙ୍କ୍ କେସ୍‍ମାତ୍‍ତାନ୍, ଇଦ୍ ମିଡ଼୍ ହେର୍କା ମାଡ଼ାଟ୍, ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ଇଦ୍‍ସାରେ ଗଟ୍ ମିକିଂଙ୍କ୍ କେତ୍‍ତାନ୍ । ନାନ୍ ମିଇ ତଡ଼୍ ମାତ୍‍ତାଙ୍କ୍ ଆରାମ୍ କନ୍‍ସ୍ ଇଦ୍‍ସାରେ ଗଟ୍ ମିକିଂଙ୍କ୍ କେତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଞ୍ଜେ ନାନ୍ ନା ପ୍ରେରଣାକର୍ତ୍ତାନ୍ ଗାର୍‍ରେ ଆଦୁତାନ୍, ମେଣ୍ଡେ ମିଡ଼୍ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ଅଦୁତି ଇଞ୍ଜ ମିଇ ଲୋପେକେ ବେନମିକା ପାଚ୍ରାମାଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ମାତର୍ ନାନ୍ ମିକିଂଙ୍କ୍ ଇଦ୍‍ସାରେ ଗଟ୍ କେତ୍‍ତାଙ୍କ୍ ମିଇ ହୃଦୟ୍ ଦୁଃକାମ୍‍ତେ ବର୍ତ୍ତି ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମିକିଂଙ୍କ୍ ସତ୍ କେତୁତାନ୍, ନାନ୍ ଆତ୍‍କେନେ ମିୟାଦ୍ ଲେକେତ୍ ଆଦ୍‍ତେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଆନୋକ୍ ଅଣ୍ଡ୍‌ ସାହାଜ୍ୟ ମାଡ଼ାନଣ୍ଡ୍ ନାରୁଡ଼୍ ମିଇ ଗାର୍‍ରେ ୱାଡ଼ଣ୍ଡ୍, ମାତର୍ ନାନ୍ ଆତ୍‍କେ ଅଙ୍କ୍‌ ମିଇ ଗାର୍‍ରେ ରହସିଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ଅଣ୍ଡ୍‌ ୱାସ୍ ପାପ୍, ଦାର୍ମିକତା ନୁ ନ୍ୟାୟ ବିଚାର୍ ବିଷୟ୍‍ତେ ଜଗତ୍‍ତିଙ୍କ୍ ସତ୍ ହିଦ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ପାପ୍ ବିଷୟ୍‍ତେ-ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ନାକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ଡ଼୍‍; ");
INSERT INTO kff_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଦାର୍ମିକତା ବିଷୟ୍‍ତେ-ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ବାବାନ୍ ଗାର୍‍ରେ ଆଦୁତାନ୍ ନୁ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେଣ୍ଡେ ଉଡାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ବିଚାର୍ ବିଷୟ୍‍ତେ-ଅଡ଼୍‌ ବୁଲ୍‍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଦ୍ ଜଗତ୍‍ତିଙ୍କ୍ ଶାସନ୍‍ ଅଦିପତି ଦସି ଆତ୍‍ତଣ୍ଡ୍ । ଇଗାଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ନ୍ୟାୟ ବିଚାର୍ ତିଆର୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ନାୱାଦ୍ ମିକିଂଙ୍କ୍ ମେଣ୍ଡେ ଗାଟି ଗଟି କେତ୍‍ତାନ୍ ମିନ୍ଦେ, ମାତର୍ ମିଡ଼୍ ଇଞ୍ଜେ ଆୱ୍‍ଚାରେ ସୟ୍ୟ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌, ଇତ୍‍କେ, ସତ୍ କେତାନାଦ୍ ଆତ୍ମା ୱାତ୍‍କେ, ଅଣ୍ଡ୍‌ ହାର୍ ତଅସ୍ ମିକିଂଙ୍କ୍ ସାରେ ସତ୍ ବିଷୟ୍ କେତିତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନିଜେତାଦ୍ ଗଟ୍ କେଲଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବାତେଏ କେଞ୍ଜିତଣ୍ଡ୍, ଆଦେ ଆ ମିକିଂଙ୍କ୍ କେତିତଣ୍ଡ୍, ମେଣ୍ଡେ ୱାଦାନ୍ ଦିନାକ୍ ବିଷୟତାଦ୍ ଗଟ୍ ମିକିଂଙ୍କ୍ କେତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ଗୌରବ୍‍ ମାଡ଼ିତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନାୱାଦ୍ ବିଷୟ୍ ଆସ୍ ମିକିଂଙ୍କ୍ କେତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ବାତା ବାବାନାଦ୍, ଆୱୁସାରେ ନାୟାୱୁ; ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ କେତ୍‍ତାନ୍, ଅଣ୍ଡ୍‌ ନାୱାଦ୍ ସାରେ ବିଷୟ୍ ଆସ୍ ମିକିଂଙ୍କ୍ କେତିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ସୁଦୁଟ୍ ଦିନାମ୍ ମିନ୍ଦେ, ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେଣ୍ଡେ ଉଡାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍, ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ସୁଦୁଟ୍ ସମୟ୍‍ତେ ଲୋପେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଉଡାଙ୍କ୍ ପାର୍ଦିତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ଆଗାଙ୍କ୍ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେତ୍‍ତଡ଼୍, ସୁଦୁଟ୍ ଦିନାମ୍ ମିନ୍ଦେ, ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଉଡାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍, ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ସୁଦୁଟ୍ ସମୟ୍‍ତେ ଲୋପେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଉଡ଼ିତିଡ଼୍ ନୁ ନାନ୍ ବାବାନ୍ ଗାର୍‍ରେ ଆଦୁତାନ୍, ଇଦ୍ ବେନ୍ ଗଟି ଅଣ୍ଡ୍‌ ମାକିଂଙ୍କ୍ କେତୁତଣ୍ଡ୍, “ଇଦିନ୍ ଅର୍ତ ବାତେଏ ? ");
INSERT INTO kff_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, ଆଦ୍ ‘ସୁଦୁଟ୍ ସମୟ୍‍ତାଦ୍’ ଇତ୍‍କେ ବାତେଏ ? ଅଣ୍ଡ୍‌ ବାତେଏ କେତୁତଣ୍ଡ୍, ମାମ୍‍ମେ ବୁଜେମ୍ ଆଦାଙ୍କ୍ ପାର୍‍ୱମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼ାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତଡ଼୍ ଇଞ୍ଜ ପୁଞ୍ଜ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ କେତ୍‍ତାନ୍, ‘ସୁଦୁଟ୍ ଦିନାମ୍ ମିନ୍ଦେ, ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଉଡାଙ୍କ୍ ପାର୍‍ୱିଡ଼୍, ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ସୁଦୁଟ୍ ସମୟ୍‍ତେ ଲୋପେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ଉଡ଼ିତିଡ଼୍,’ ନାନ୍ ଇଦ୍ ବେନ୍ ଗଟ୍ କେତ୍‍ତାନ୍, ଆଦ୍ ବିଷୟ୍ ଆସ୍ ମିଡ଼୍ ବାତେଏ ମିଲୋପେ କେତାକେତି ଆଦୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ସତ୍, ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ମିଡ଼୍ କେୟିତିଡ଼୍ ନୁ ଦୁଃକାମ୍ ଆଦ୍‍ତିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜଗତ୍ ୱେଡ଼୍‍କିତ୍; ମିଡ଼୍ ଦୁଃକାମ୍ ଆଦ୍‍ତିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିୱାଦ୍ ଦୁଃକାମ୍ ୱେଡ଼୍‍କେତେ ସାୟେ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ଜନମ୍ ମାଡ଼ାନ୍ ଦିନାମ୍ ୱାସ୍ ହେୱ୍‍କେ ନାଟାଙ୍କ୍ କଷ୍ଟ ଦର୍‍କିତ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଜନମ୍ ମାଡ଼୍‍ତେ ପାୟେ ଜଗତ୍‍ତାଗ୍ ପୁନଣ୍ଡ୍ ନାରୁଡ଼୍ ଜନମ୍ ମାଡ଼୍‍ତେ, ଇଦ୍ ୱେଡ଼୍‍କାତ୍ ସେଙ୍ଗେ ମେଣ୍ଡେ କଷ୍ଟ ହେର୍କା ମାଡ଼ । ");
INSERT INTO kff_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ଆଦ୍ ଲେକାମ୍ ମିଡ଼୍ ଇଞ୍ଜେ କଷ୍ଟ ଆଦ୍‍ତିଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ମିକିଂଙ୍କ୍ ତଅନ୍‌ଦିତାନ୍, ମେଣ୍ଡେ ମିଇ ହୃଦୟ୍ ୱେଡ଼୍‍କିତେ ନୁ ବେନ ମିୟାଗ୍ କନ୍‍ସ୍ ମିୟାଦ୍ ୱେଡ଼୍‍କା ଡଙ୍ଗି ଆୟଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ଆଦ୍ ଦିନ୍ ୱାଦ୍‍ତେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ବାତେଏ ତାଲ୍‍କାଙ୍କ୍ ୱେୟ୍ । ସତ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ଯଦି ମିଡ଼୍ ବାବାଙ୍କ୍ ବାତ୍ ତାଆଲ୍‍କିତିଡ଼୍, ଆସୁଟେ ନା ପେଦେର୍ ତେ ଅଣ୍ଡ୍‌ ମିକିଂଙ୍କ୍ ଆଦ୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ଇଞ୍ଜେକ୍‍ଆନା ମିଡ଼୍ ନା ପେଦେର୍ ତେ ବାତ୍ ତାଆଲ୍‍କ୍‍ୱିଡ଼୍; ତାଲ୍‍କାଟ୍, ମିଡ଼୍ ଆଦ୍ ଦର୍ସିକିତିଡ଼୍, ମେଣ୍ଡେ ମିୱାଦ୍ ୱେଡ଼୍‍କା ବର୍ତ୍ତି ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ନାନ୍ ମିକିଂଙ୍କ୍ ଆଲଙ୍କାରିକ ଶଦ୍ଦ ତଡ଼୍ ଇଦ୍‍ସାରେ ଗଟ୍ କେତ୍‍ତାନ୍; ଦିନାମ୍ ୱାଦୁତେ ନାନ୍ ମେଣ୍ଡେ ଚିନ୍ନେ ତଡ଼୍ କେଲନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାବାନ୍ ବିଷୟ୍‍ତେ ସାୟେ କେତିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ଆଦ୍ ଦିନ୍ ମିଡ଼୍ ନା ପେଦେର୍‍ତେ ଅଂକିଙ୍କ୍‌ ତାଲ୍‍କିତିଡ଼୍; ନାନ୍ ମିୱାଦ୍ ବିଷୟ୍‍ତେ ବାବାଙ୍କ୍ ଅନୁରଦ୍‌ ମାଡ଼ିତାନ୍, ଇଦ୍ ନାନ୍ ମିକିଂଙ୍କ୍ କେଲନ୍; ");
INSERT INTO kff_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ବାବାଲ୍ ନିଜେ ମିକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ିତନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼୍‍ତିଡ଼୍ ନୁ ନାନ୍ ଯେ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାସ୍‍ମିନ୍ଦେନ୍, ଆଦ୍ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ସତ୍ ନାନ୍ ବାବାନାଗାଙ୍କ୍ ଜଗତ୍‍ତାଗ୍ ୱାସ୍‍ମିନ୍ଦେନ୍; ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ଜଗତ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି ବାବାନ୍ ଗାର୍‍ରେ ଆଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଇଦ୍ ଗଟ୍ କେଞ୍ଜି ଶିଷ୍ୟଡ଼୍ କେତ୍‍ତଡ଼୍, “ଉଡ଼େ ଇଞ୍ଜେ ନିମ୍‍ ସାୟେ କେତୁତିନ୍ ନୁ ଆଲଙ୍କାରି ଶଦ୍ଦ ତଡ଼୍ ମେଣ୍ଡେ କେଲ୍‍ୱିନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ଇଞ୍ଜେ ନିମ୍‍ ଯେ ସାରେ ବିଷୟ୍ ପୁତ୍‍ତିନ୍, ମେଣ୍ଡେ ନିମ୍‍ ବେନଙ୍କ୍ ପ୍ରଶ୍ନ ମାଡ଼ାଙ୍କ୍ ଦର୍‍କାର୍ ଇଲେ, ଆଦ୍ ଇଞ୍ଜେ ମାମ୍‍ମେ ପୁତ୍‍ତମ୍; ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ୱାତ୍‍ତିନ୍ ଇଞ୍ଜ ମାମ୍‍ମେ ଇଦ୍ ମାମ୍‍ମେ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବାତ୍ ଇଞ୍ଜେ ବିଶ୍ୱାସ୍ ମାଡ଼ୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ଉଡ଼ାଟ୍, ଦିନାମ୍ ୱାଦୁତ୍, ହୋ ୱାତ୍‍ତା, ବେସୁଟ୍‌ ମିଡ଼୍ ୱେରେୱେରେ ଆସ୍ ନିଜେ ନିଜେତ୍ ଲୋନ୍‌ ଆଦ୍‍ତିଡ଼୍, ମେଣ୍ଡେ ନାକିଂଙ୍କ୍ ୱେରଙ୍କେ ୱିଡ଼୍‍ସି ଆଦ୍‍ତିଡ଼୍; ନାନ୍ ୱେରନ୍ ଆୟନ୍, ନା ତଡ଼୍ ବାବାଲ୍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ମିଡ଼୍ ବେଲା ନାୟାଗ୍ କାଇଲି ଶାନ୍ତି ଦର୍ସିକିତିଡ଼୍, ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ମିକିଂଙ୍କ୍ ଇଦ୍‍ସାରେ ବିଷୟ୍ କେତୁତାନ୍ । ଜଗତ୍‍ତାଗ୍ ମିଇ ସେଙ୍ଗେ କଷ୍ଟ ମିନ୍ଦେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ସାହାସ୍ ପୟିମୁଟ୍; ନାନ୍ ଜଗତ୍‍ତିଙ୍କ୍ ଜିଡ଼୍‌ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଜିସୁ ଇଦ୍‍ସାରେ ଗଟି କେସ୍ ତେର୍‍ତେପେୟ୍ ସ୍ୱର୍ଗତା ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ବାବା, ଦିନାମ୍ ଆଦ୍‍ତେ; ନି ମାର୍‍ରିଙ୍କ୍ ମହିମାନିତ ମାଡ଼ା, ବେଲା ମାର୍‍ ନିୱାଦ୍ ମହିମା ମାଡ଼ିତନ୍, ");
INSERT INTO kff_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ନିମ୍‍ ଅଂକିଙ୍କ୍‌ ସାରେ ନାରୁଡ଼୍ ପର୍‍ର ଅଦିକାର୍‌ ହିତ୍‍ତି, ବେଦ୍‍ରକମ୍‍ ନିମ୍‍ ଅଂକିଙ୍କ୍‌ ବେନ୍ ନାରୁଡ଼୍‍କ୍ ହିତ୍‍ତିନ୍, ଅଡ଼୍‌‍କ୍ ସାରେଦିନାତ୍ ଜିୱୁଣ୍ଡ୍ ହିଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ନିମ୍‍ ୱେର୍‍ନି ସତ୍ ଇଶ୍ୱର୍, ନିକିଂଙ୍କ୍ ନୁ ନିମ୍‍ ରଅତେନଣ୍ଡ୍ ଜିସୁ କ୍ରିଷ୍ଟଙ୍କ୍ ପୁନ୍ଦାନାଦ୍ ଆଦୁତ୍‍ତେ ସାରେଦିନାତ୍ ଜିୱୁଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେନ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାନଙ୍କ୍ ହିତ୍‍ତିନ୍, ଆଦ୍ ନାନ୍ ତେର୍‍ସ୍‍ପି ପୃତିବିତାଗ୍ ନିକିଂଙ୍କ୍ ମହିମାନିତ ମାଡ଼୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଇଞ୍ଜେ, ହୋ ବାବା, ଜଗତ୍‍ତାଦ୍ ତିଆର୍ ମୁନେଙ୍କ୍ ନି ତଡ଼୍ ନାୱାଦ୍ ବେନ୍ ମହିମା ମାତ୍‍ତା, ଇଞ୍ଜେ ନିମ୍‍ ନାକିଂଙ୍କ୍ ଆଦ୍ ମହିମା ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ନିମ୍‍ ନାକିଂଙ୍କ୍ ଜଗତ୍‍ତାଗ୍ ବେନ୍ ନାରୁଡ଼୍‍କ୍ ଦାନ ମାଡ଼୍‍ତି, ନାନ୍ ଅଡ଼୍‌ ଗାର୍‍ରେ ନି ପେଦେର୍ ପ୍ରକାଶ୍ ମାଡ଼୍‍ତାନ୍; ଅଡ଼୍‌‍ ନି ମାନେଇ ନୁ ନିମ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନାକିଂଙ୍କ୍ ଦାନ ମାଡ଼୍‍ତି, ମେଣ୍ଡେ ଅଡ଼୍‌ ନିୱାଦ୍ ବାକ୍ୟ ପାଲନ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ନିମ୍‍ ବାତା ଦାନ ମାଡ଼୍‍ତି ଆୱୁସାରେ ନିୟାଗ୍ କନ୍‍ସ୍ ତିଆର୍ ଆଦ୍‍ତେ, ଇଦ୍ ଅଡ଼୍‌ ଇଞ୍ଜେ ବୁଜେମ୍ ଆଦ୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେନ୍ ସାରେ ବାକ୍ୟ ଦାନ ମାଡ଼୍‍ତି, ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆୱ୍ ସାରେ ଦାନ ମାଡ଼୍‍ତାନ୍, ମେଣ୍ଡେ ଅଡ଼୍‌ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍, ମେଣ୍ଡେ ନାନ୍ ଯେ ନିୟାଗ୍ କନ୍‍ସ୍ ୱାସ୍‍ମିନ୍ଦେନ୍, ଆଦ୍ ସତ୍ ଇଞ୍ଜ ପୁଞ୍ଜ୍ ମିନ୍ଦେଡ଼୍‌ ନୁ ନିମ୍‍ ନାକିଂଙ୍କ୍ ରଅତି ଇଞ୍ଜ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ନାନ୍ ଅଡ଼୍‌ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼ୁତାନ୍; ଜଗତ୍ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼ନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେନ୍ ନାରୁଡ଼୍‍କ୍ ହିତ୍‍ତିନ୍, ଅଡ଼୍‌ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼ୁତାନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ନି ମାନେଇ; ");
INSERT INTO kff_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ବାତା ନାୟାୱୁ, ଆୱୁସାରେ ନିୟାୱ୍‌, ମେଣ୍ଡେ ବାତା ନିୟାୱ୍‌, ଆୱୁସାରେ ନାୟାୱୁ; ମେଣ୍ଡେ ନାନ୍ ଅଡ଼୍‌ ତଡ଼୍ ମହିମାନିତ ଆସ୍ ମିନ୍ଦେନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ନାନ୍ ମେଣ୍ଡେ ଇଦ୍ ଜଗତ୍‍ତାଗ୍ ମାନନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଡ଼୍ ଇଦ୍ ଜଗତ୍‍ତାଗ୍ ମାନ୍‍ତଡ଼୍; ମେଣ୍ଡେ ନାନ୍ ନି ଗାର୍‍ରେ ଆଦୁତାନ୍ । ପବିତ୍ର ବାବା, ନିମ୍‍ ନାକିଂଙ୍କ୍ ହିତ୍‍ତେ ପେଦେର୍‍ତେ ଶକ୍ତି ତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରକ୍ଷା ମାଡ଼ା ବେନ୍ ପେଦେର୍ ନାକିଂଙ୍କ୍ ହିତ୍‍ତି, ବେଦ୍‍ରକମ୍‍ ମାନାଡ଼୍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତାଡ଼୍, ଅଡ଼୍‌ ଆଦେରକମ୍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ଅଡ଼୍‌ ତଡ଼୍ ମାନ୍ଦାନ୍ ୱେଲେ ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନିୱାଦ୍ ପେଦେର୍‍ତେ ଶକ୍ତିତଡ଼୍ ରକ୍ଷା ମାଡ଼ି ୱାସମିନ୍ଦେନ୍ ବେନ୍ ପେଦେର୍ ନିମ୍‍ ନାକିଂଙ୍କ୍ ହିତ୍‍ତି, ମେଣ୍ଡେ ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାବଦାନ୍‍ତେ ରକ୍ଷା ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍ ନୁ ଦର୍ମଶାସ୍ତ୍ରତାଦ୍ ବାକ୍ୟ ବେଲା ସାରେ ଆଦ୍‍ତେ, ଇଦିନ୍ ସେଙ୍ଗେ ଡଲାନ୍ ମାଆର୍‍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ବେନମିକା ନର୍କତା ଆନ୍‌‍ନଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଇଞ୍ଜେ ନି ଗାର୍‍ରେ ଆଦୁତାନ୍, ମେଣ୍ଡେ ଅଡ଼୍‌ ଲୋପେ ନାୱାଦ୍ ୱେଡ଼୍‍କା ବର୍ତ୍ତି ଆୟି, ଆଦିନ୍ ସେଙ୍ଗେ ଜଗତ୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ ନାନ୍ ଇୱୁସାରେ କେତୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନିୟାୱୁ ବାକ୍ୟ କେଞ୍ଜ୍‍ପ୍‍ତାନ୍, ମେଣ୍ଡେ ଜଗତ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାସ୍‍କି ମିନ୍ଦେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ବେଦ୍‍ଲେକାମ୍ ଇଦ୍ ଜଗତ୍‍ତଣ୍ଡ୍ ଆୟନ୍, ଅଡ଼୍‌ ଆଦେରକମ୍ ଇଦ୍ ଜଗତ୍‍ତଡ଼୍ ଆୟ୍‍ୟଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ନିମ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଜଗତ୍‍ତାଗାଙ୍କ୍ ଆୟମ୍ ଇଞ୍ଜ ନାନ୍ ପ୍ରାର୍ତନା ମାଡ଼ନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସୟ୍‍ତାନ୍‍ତାଗାଙ୍କ୍ ରକ୍ଷା ମାଡ଼େ ଇଞ୍ଜ ପ୍ରାର୍ତନା ମାଡ଼ୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ନାନ୍ ବେଲା ଜଗତ୍‍ତଣ୍ଡ୍ ଆୟନ୍, ଅଡ଼୍‌ ଆଦେପୁଟୁଙ୍କ୍ ଜଗତ୍‍ତଡ଼୍‍ ଆୟ୍‍ୟଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ସତ୍ ତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପବିତ୍ର ମାଡ଼େ; ନିୱାଦ୍ ବାକ୍ୟ ଆ ସତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେଲା ଜଗତ୍‍ତାଗ୍ ରହତ୍‍ତିନ୍, ନାନ୍ ମିକା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦେପୁଟୁଙ୍କ୍ ଜଗତ୍‍ତାଗ୍ ରହତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ଅଡ଼୍‌ ବେଲା ଆଦ୍ ସତ୍ ତଡ଼୍ ପବିତ୍ର ଆଦ୍‍ତଡ଼୍, ଇଦିନ୍‍ମାଇଦିଙ୍କ୍ ନାନ୍ ଅଡ଼୍‌ ସେଙ୍ଗେ ନିଜ୍‍ତିଙ୍କ୍ ପବିତ୍ର ମାଡ଼ୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ନାନ୍ ମାତର୍ ଅଡ଼୍‌ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼ନ୍, ମାତର୍ ଇଡ଼ାଦ୍ ବାକ୍ୟ ତଡ଼୍ ବେନଡ଼୍ ନାୟାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିକା ପ୍ରାର୍ତନା ମାଡ଼ୁତାନ୍, ");
INSERT INTO kff_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ବେଲା ଅଡ଼୍‌ ସାରେତଡ଼୍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତଡ଼୍; ହଁ ବାବା ନିମ୍‍ ବେଲା ନାୟାଗେ ମିନ୍ଦେନି ନୁ ନାନ୍ ନିୟାଗ୍ ମିନ୍ଦେନ୍, ଅଡ଼୍‌ ମିକା ଆଲେକେ ମାୟାଗ୍‌ ମାନିଡ଼୍, ବେଦ୍‍ଲେକାମ୍ ନିମ୍‍ ନାକିଂଙ୍କ୍ ରହତ୍‍ତି ଇଞ୍ଜ ଜଗତ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତ୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ମେଣ୍ଡେ ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେନ୍ ମହିମା ହିତ୍‍ତିନ୍, ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦ୍ ହିତ୍‍ତାନ୍, ବେଲା ମାନାଡ଼୍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତାଡ଼୍, ଅଡ଼୍‌ ଆଦେଲେକାମ୍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ନାନ୍ ଅଡ଼ାଗ୍ ନୁ ନିମ୍‍ ନାୟାଗ୍ ବେଦ୍‍ଲେକାମ୍ ଅଡ଼୍‌ ପବିତ୍ର ଆସ୍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତଡ଼୍, ଆଲେକେ ଜଗତ୍ ପୁନ୍‍ତେ ଯେ ନିମ୍‍ ନାକିଂଙ୍କ୍ ରଅତିନ୍, ମେଣ୍ଡେ ନାକିଂଙ୍କ୍ ବେନ୍ ଲେକାତ୍ ପ୍ରେମ ମାଡ଼୍‍ତି, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିକା ଆଦେ ଲେକାତ୍ ପ୍ରେମ ମାଡ଼୍‍ତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ହଁ ବାବା ! ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେନଡ଼କ୍ ହିତ୍‍ତିନ୍, ନାନ୍ ବେଗେ ମାନ୍‍ତାନ୍, ଅଡ଼୍‌ ଆନ୍‌‍ତେ ଆଦେପୁଟୁଙ୍କ୍ ଆଗେ ନା ତଡ଼୍ ମାନ୍‍ତଡ଼୍ ନୁ ଜଗତ୍ ତିଆର୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ନିମ୍‍ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ି ବେନ୍ ଗୌରବ୍ ହିତ୍‍ତିନ୍, ନାୱାଦ୍ ଆଦ୍ ଗୌରବ୍ ଅଡ଼୍‌ ବେଲା ଉଡ଼ିତଡ଼୍, ଇଦ୍ ନାୱାଦ୍ ଇଚ୍ଛା । ");
INSERT INTO kff_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ହୋ ଦାର୍ମିକ୍ ବାବା ! ଜଗତ୍ ନିକିଂଙ୍କ୍ ପୁନନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ନିକିଂଙ୍କ୍ ପୁତ୍‍ତାନ୍; ମେଣ୍ଡେ ନିମ୍‍ ଯେ ନାକିଂଙ୍କ୍ ରହତି, ଆଦ୍ ଇଡ଼୍ ପୁତ୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ମେଣ୍ଡେ, ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେଦ୍‍ଲେକାମ୍ ପ୍ରେମ ମାଡ଼୍‍ତିନ୍, ଆଦ୍ ବେଲା ଅଡ଼ାଗ୍ ମାନ୍‍ତା ନୁ ନାନ୍ ଅଡ଼ାଗ୍ ମାନ୍‍ତାନ୍, ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନି ପେଦେର୍ କେତ୍‍ତାନ୍ ନୁ କେତିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ଜିସୁ ଇଦ୍‍ସାରେ ଗଟି କେସ୍ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ କିଦ୍ରୋଣ ଉପତ୍ୟକାତ୍ ମେଣ୍ଡେଅନ୍‌‍ପାକେ ଆଦ୍‍ତଡ଼୍ । ଆଗେ ଅଣ୍ଡ୍‌ ବଗିଚା ମାତ୍‍ତା, ଅଣ୍ଡ୍‌ ନୁ ତାମ୍ ଶିଷ୍ୟଡ଼୍ ଆଗେ ଅସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ବେନ୍ ଯିହୁଦାଲ୍ ଅଂକିଙ୍କ୍‌ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିକା ଆଦ୍ ପଡ଼ିୟେତିଙ୍କ୍ ପୁଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ନାର୍ଗେଦାମ୍ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ଆଞ୍ଜମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ଯିହୁଦା ରମୀୟ ସୈନ୍ୟମାନ୍ଦେ, ମୁକ୍ୟ ଯାଜକ୍ ନୁ ଫାରୂଶୀଡ଼୍ ଲୋପେକେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ମନ୍ଦିର୍‍ତିଙ୍କ୍ କେପାନଡ଼୍ ଲଣ୍ଠନ୍, ମୋଶାଲ୍ ନୁ ସୁରୀଟେଙ୍ଗା ପଇସ୍ ଆଗେ ୱାତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ଆଗାଙ୍କ୍ ଜିସୁ, ଅଡ଼୍‌ ସେଙ୍ଗେ ବାତା ଗଟେମ୍‍ଆଦାଙ୍କ୍ ଆଦୁତେ, ଆଦ୍ ପୁଞ୍ଜ୍ ମୁନ୍‍ନେ ଆଞ୍ଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବେନଙ୍କ୍ ମେହେକୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ନାଜରିତିୟତଣ୍ଡ୍ ଜିସୁଙ୍କ୍ ।” ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଅଣ୍ଡେ ।” ବେନ୍ ଯିହୁଦା ଅଂକିଙ୍କ୍‌ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିକା ଅଡ଼୍‌ ତଡ଼୍ ନିସ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ଜିସୁ ଆସୁଟେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଅଣ୍ଡେ,” ଆସୁଟେ ଅଡ଼୍‌ ପେର୍‍କେ ଆଞ୍ଜ୍ ନେଲ୍ ରାୟ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ଆଗାଙ୍କ୍ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବେନଙ୍କ୍ ମେହେକୁତିଡ଼୍ ?” ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ନାଜରିତିୟତଣ୍ଡ୍ ଜିସୁଙ୍କ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଯେ ଅଣ୍ଡ୍‌, ଇଦ୍ ତ ନାନ୍ ମିକିଂଙ୍କ୍ କେତ୍‍ତାନ୍ ।” ଯଦି ମିଡ଼୍ ନାକିଂଙ୍କ୍ ମେହେକୁତିଡ଼୍, ଆଲେକେ ଇଡ଼୍‍କିଂଙ୍କ୍ ଆଦାଙ୍କ୍ ଇମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, ବେଲା ଅନ୍‌‍ୱାଦ୍ ଇଦ୍ ବାକ୍ୟ ସାରେ ଆଦ୍‍ତେ, “ବାବା ନିମ୍‍ ନାକିଂଙ୍କ୍ ବେନଡ଼କ୍ ହିତ୍‍ତିନ୍, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ନାନ୍ ୱେରଙ୍କ୍ ମିକା ମାପନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ଶିମୋନ୍ ପିତର୍‍ତାଗ୍ ଚୁର୍ ମାତ୍‍ତାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ପେସ୍ପିମିକା ମହାଯାଜକିନ୍ ଦାସଙ୍କ୍ ରେହେତଣ୍ଡ୍ ନୁ ଅନାଦ୍‌ ତିନ୍ଦେକାଇ କେୱ୍‍ଦିଙ୍କ୍ ନାଡ଼୍‍କ୍‍ତଣ୍ଡ୍; ଆ ଦାସତେ ପେଦେର୍ ମାଲ୍‍କ । ");
INSERT INTO kff_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ଆଗାଙ୍କ୍ ଜିସୁ ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଚୁର୍ ଗାର୍‍ରେ ନେହେମ୍; ବାବାଲ୍ ଇଶ୍ୱର୍‍ ନାକିଂଙ୍କ୍ ଇସ୍‍ମାନ୍ଦାନ୍ ଇଦ୍ ଦୁଃକାମ୍ ଆଦାନ୍ କଷ୍ଟତାଗାଙ୍କ୍ ନାନ୍‍ନେ ତିନନ୍‍ କି ?” ");
INSERT INTO kff_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ତିନ୍ ପେର୍‍କେ ରମୀୟ ସୈନ୍ୟମାନ୍ଦେ, ବେଡ଼୍‍ୟାଦ୍‍ ସେନାପତି ନୁ ଯିହୁଦୀଡ଼୍‍କ୍ କେପାନଡ଼୍ ଜିସୁଙ୍କ୍ ପୟ୍‍ସ୍ ବନ୍ଦି ମାଡ଼୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ଅଂକିଙ୍କ୍‌ ତଅସ୍ ମୁନେନ୍ କୟାପାନ୍ ମାମାଲ୍ ହାନାନତେ ଗାର୍‍ରେ ଆତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଆଦ୍ ହେଣ୍ଡେତ୍ ବେଡ଼ିୟ୍‍ ଯାଜକ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ସାରେତଡ଼୍ ନାରୁଡ଼୍ ସେଙ୍ଗେ ୱେରଣ୍ଡ୍ ଡଲ୍‍ନାଦ୍ ସାଏ ଇଞ୍ଜ ଯିହୁଦୀଡ଼୍‍କ୍ ବେନ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଇଣ୍ଡ୍ ଅଣ୍ଡ୍‌ କାୟାପା । ");
INSERT INTO kff_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ଶିମୋନ୍ ପିତର୍ ନୁ ମେଣ୍ଡେଅର୍‍ତୁଣ୍ଡ୍ ଶିଷ୍ୟ ଜିସୁନ୍ ପେର୍‍କେ ପେର୍‍କେ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍‌ । ଆ ଶିଷ୍ୟ ମହାଯାଜକତିଙ୍କ୍ ପୁଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଜିସୁନ୍ ତଡ଼୍ ବେଡ଼୍‍ୟାଦ୍‍ ଯାଜକତାଦ୍ ଲୋତ୍‍ତେ ଦୁୱାଡ଼୍‌ ହେୱୁନା ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପିତର୍ ବାଇଦେ ମାର୍‍ ଗାର୍‍ରେ ନିସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ବାଇଦେ ଆଞ୍ଜ୍ ମାର୍‍ତାଗ୍ କେପିମାନ୍ଦାନ୍ ଦାସିଙ୍କ୍ କେସ୍ ପିତର୍‍ତିଙ୍କ୍ ଲୋପେ ତାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଦାସି ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତା, “ନିମ୍‍ ମିକା ବାତେଏ ଇ ନାରୁଡ଼୍ ଶିଷ୍ୟଡ଼୍ ଲୋପେକେ ୱେରନ୍ ଆୟିୱିନ୍ ?” ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଆୟନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ଶାଲ୍‍ଦେ ସେଙ୍ଗେ ଦାସ ନୁ କେପାନଡ଼୍ ଇର୍କି ନିଡ଼୍‍ସ୍‍ପି ଆଗେ ନିସ୍ କିସ୍ ହାର ମାତ୍‍ତଡ଼୍; ପିତର୍ ମିକା ଅଡ଼୍‌ ତଡ଼୍ କାଇଲି କିସ୍ ହାର ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ତିନ୍ ଲୋପେ ବେଡ଼ିୟ୍‍ଯାଜକ୍ ଜିସୁଙ୍କ୍ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ବିଷୟ୍‍ତେ ନୁ ତାନ୍ ଶିକ୍ଷା ବିଷୟ୍‍ତେ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ନାରୁଡ଼୍ ଗାର୍‍ରେ ସାରେ ଗଟ୍ କେସ୍‍ମିନ୍ଦେନ୍; ବେଗେ ସାରେ ଯିହୁଦିଡ଼୍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତଡ଼୍, ଇଦ୍ ଲେକାମ୍ ସମାଜ୍ ଲୋନ୍‌ ନୁ ମନ୍ଦିର୍‍ତାଗ୍ ନାନ୍ ସାରେଦାମ୍ ଶିକ୍ଷା ଇସ୍‌‍ମିନ୍ଦେନ୍; ନାନ୍ ମିଞ୍ଜୀ ମିକା ବାତେଏ କେଲନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ନାକିଂଙ୍କ୍ ବାତେଙ୍କ୍ ପାଚ୍ରାମାଡ଼ୁତିନ୍ ? ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାତେଏ କେତ୍‍ତାନ୍, ବେନଡ଼୍ କେଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼ା; ଉଡ଼େ, ନାନ୍ ବାତା କେତ୍‍ତାନ୍, ଅଡ଼୍‌ ଆୱ୍‍ଚାରେ ପୁତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜିସୁ ଇଲା କେତ୍‍ତାଙ୍କ୍ ପ୍ରହରୀଡ଼୍ ଲୋପେକେ ଗାରେ ନିସ୍ ମାନ୍ଦାନ୍ ୱେରଣ୍ଡ୍ ଜିସୁଙ୍କ୍ ଚାପୁଡ଼ା ରେହେସ୍ କେତ୍‍ତଣ୍ଡ୍, ନିମ୍‍ ମହାଯାଜକତିଙ୍କ୍ ଇଲା କେତୁତି ? ");
INSERT INTO kff_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଯଦି ନାନ୍ କାରାପ୍ କେତ୍‍ତାନ୍, ଆଲେକେ କାରାବ୍‍ତାଦ୍ ସାରେତଡ଼୍ ମୁନେ ସତ୍ ହିମ୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯଦି ସାଏ କେତ୍‍ତାନ୍, ଆଲେକେ ବାତେଙ୍କ୍ ନାକିଂଙ୍କ୍ ରେହେତୁତିନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ଆଗାଙ୍କ୍ ହାନାନ ଅଂକିଙ୍କ୍‌ ତହଃସ୍‍ ମାନ୍ଦାନ୍ ଅବସ୍ଥାତେ ବେଡ଼ିୟ୍‍ଯାଜକ୍ କାୟାପାନ୍ ଗାର୍‍ରେ ରହତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ଆଗାଙ୍କ୍ ଶିମୋନ୍ ପିତର୍ ନିସ୍‍ମିକା କିସ୍ ହାର ମାତ୍‍ତଣ୍ଡ୍ । ଆଗେ ଗୁଡ଼୍‍ତା ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ନିମ୍‍ମିକା ବାତେଏ ଶିଷ୍ୟଡ଼୍ ଲୋପେକେ ୱେରଣ୍ଡ୍ ଆୟିୱିନ୍ ?” ଶିମୋନ୍ ପିତର୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ଇଲେ, ନାନ୍ ଆୟନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ବେଡ଼ିୟ୍‍ଯାଜକ୍ ଦାସଡ଼୍ ଲୋପେକେ ୱେରଣ୍ଡ୍, ଇତ୍‍କେ ପିତର୍ ବେନ କେୱ୍ କଇସ୍ ମାତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ନିଜର୍ ନାରୁଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ବାତେଏ ନିକିଂଙ୍କ୍ ଜିସୁନ୍ ତଡ଼୍ ବଗିଚାତାଗ୍ ଉଡ଼ି ମାନନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ଆଗେ ପିତର୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ଇଲେ ।” ଆସୁଟେ, ସାଙ୍ଗେ ସାଙ୍ଗେ କର୍କ୍ କୁସ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ପେର୍‍କେ ଯିହୁଦି ନେତାନଡ଼୍ ଜିସୁଙ୍କ୍ କୟାପାନ୍ ଗାର୍‍ରେ ରମୀୟ ରାଜ୍ୟପାଲ୍‍ତେ ପ୍ରାସାଦ୍‍ତାଗ୍ ହତ୍‍ତଡ଼୍; ଆସୁଟ୍‌ ୱିଇସ ମାତ୍‍ତା; ମେଣ୍ଡେ ଅଡ଼୍‌ ଅପବିତ୍ର ଆୟ୍‍ୟକଟ ନିସ୍ତାର୍ ପାଣ୍ଡୁତାଦ୍ ବଜି ତିନ୍ଦାନ୍ ସେଙ୍ଗେ, ଅଡ଼୍‌‍ ପ୍ରାସାଦ୍‍ତେ ଲୋପେ ହସଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ପିଲାତ ଅଡ଼୍‌‍ ଗାର୍‍ରେ ପେଇସ୍ ୱାସ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଣ୍ଡ୍ ନାରୁଡ଼୍ ବିରୁଦ୍‍ତେ ମିଡ଼୍ ବାତେଏ ଅବିଯଗ୍ ତାତୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ୱେରନ୍ ଅପରାଦି ନାରୁଣ୍ଡ୍‌, ଆଦିନ୍ ସେଙ୍ଗେ ମାମ୍‍ମେ ଅଂକିଙ୍କ୍‌ ନି ଗାର୍‍ରେ ତାତ୍‍ତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ପିଲାତ ଯିହୁଦୀଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ହିକିଂଙ୍କ୍ ହସ୍ ମିୟାଦ୍ ନିୟମ୍‍ ଲେକାମ୍ ବିଚାର୍ ମାଡ଼ାଟ୍ ।” ଯିହୁଦୀଡ଼୍ ପୀଲାତଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ଜିସୁଙ୍କ୍ ଡଲାନ୍‍ଦଣ୍ଡ୍ ହିଦାନଙ୍କ୍ ମାୱାଦ୍ ଅଦିକାର୍‌ ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଜିସୁ ବେନ୍ ରକମ୍ ଡଲିତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ପୁଞ୍ଜ୍ ଅଣ୍ଡ୍‌ ବେନ୍ ବାକ୍ୟ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ବେଲା ସତ୍ ଆଦ୍‍ତେ, ଇଦିନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌ ଇଲା କେସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ପିଲାତ ମେଣ୍ଡେ ଅନ୍‌‍ଦାମ୍ ପ୍ରାସାଦ୍‍ତେ ଲୋପେ ଆସି ଜିସୁଙ୍କ୍ କାର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତେଏ ଯିହୁଦୀଡ଼୍ ରାଜା ?” ");
INSERT INTO kff_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତେଏ ଇଦ୍ ନିଜେ କେତୁତିନ୍, ନା ବାଗାତ୍‍ନାରୁଡ଼୍ ନା ବିଷୟ୍‍ତେ ନିକିଂଙ୍କ୍ ଇଦ୍ କେତ୍‍ତଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଯିହୁଦି ଆୟନ୍ । ନି ନିଜେତ୍ ନାରୁଡ଼୍ ନୁ ମୁକ୍ୟ ଯାଜକିଡ଼୍ ନିକିଂଙ୍କ୍ ନା ଗାର୍‍ରେ ତାତ୍‍ତଡ଼୍; ନିମ୍‍ ବାତେଏ ଦଷ୍ ମାଡ଼୍‍ତି ?” ");
INSERT INTO kff_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜିସୁ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନାୱାଦ୍ ରାଜ୍ୟ ଇଦ୍ ଜଗତ୍ ତେ ସେଙ୍ଗେ ଆୟ୍‍ୟ; ଯଦି ନାୱାଦ୍ ରାଜ୍ୟ ଇଦ୍ ଜଗତ୍ ତେ ସେଙ୍ଗେ ଆୟେଡ଼୍, ଆଲେକେ ନାନ୍ ଯିହୁଦି ନେତାନଡ଼୍ କାଇଦେ ସମର୍‍ପିତ ଆୟନ୍ ଆୟେନ୍, ଆଦିନ୍ ସେଙ୍ଗେ ନା ଦାସଡ଼୍ ଯୁଦ୍‌ ମାଡ଼େଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ନା ରାଜ୍ୟ ଇଗେ ଆୟ୍‍ୟ ମେଣ୍ଡେଅଣ୍ଡାଗ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ଆଗାଙ୍କ୍ ପିଲାତ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଆଲେକେ ନିମ୍‍ ୱେରନ୍ ରାଜା ?” ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ତ କେତୁତିନ୍ ନାନ୍ ୱେରନ୍ ରାଜା । ନାନ୍ ସତ୍ ବିଷୟ କେତାନଙ୍କ୍ ଜନମ୍ ଆତ୍‍ତାନ୍ ନୁ ଜଗତ୍‍ତାଗ୍ ୱାସ୍‍ମିନ୍ଦେନ୍ । ବେନ ସତ୍ୟତିଙ୍କ୍ ସାଏ କେତିତଡ଼୍‍ ଅଣ୍ଡ୍‌ ନା ଗଟି କେଞ୍ଜିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବାତେଏ ନିଜାମ୍ ?” ଇଦ୍ କେସ୍ ପିଲାତ ଯିହୁଦୀଡ଼୍ ଗାର୍‍ରେ ବାଇଦେ ଆଞ୍ଜ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ଇନାଗେ ବାତେମିକା ଦଷ୍ ପାଏମ୍ ଆୟନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ବାତେଙ୍କ୍ ଇତ୍‍କେ ସାରେ ହେଣ୍ଡକ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁତେ ୱେଲେ ମିଇ ସେଙ୍ଗେ ଅର୍‍ତୁଙ୍କ୍ ବନ୍ଦି ନାରୁଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ୁତାନ୍, ଇଦ୍ ମିୟାଦ୍ ଉଦାର୍ ମିନ୍ଦେ; ତ ଯଦି ମିଡ଼୍ ଇଚ୍ଛା ମାଡ଼ିତିଡ଼୍, ନାନ୍ ଇଣ୍ଡ୍ ଯିହୁଦୀଡ଼୍ ରାଜାଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଗାଟି ଲେଙ୍ଗ୍ ଦେ କେତ୍‍ତଡ଼୍, “ଇଲେ, ଇ ମାନେଇତିଙ୍କ୍ ଆୟ୍‍ୟ । ବାରବ୍‍ବାଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ିମ୍ ।” ଇଣ୍ଡ୍ ବାରବ୍‍ବାଲ୍ ୱେରନ୍ ଡଙ୍ଗାଲ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ତାନ୍ ପେର୍‍କେ ପିଲାତ ଜିସୁଙ୍କ୍ ହସ୍‍ମିକା କରଡ଼ା ତଡ଼୍ ରେହେତାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ସୈନିକିଡ଼୍ କୟେ ମାଡ଼େତ୍ ସହଜ୍‍ ତିଆର୍ ମାଡ଼ି ଜିସୁନ୍ ତାଲେତାଗ୍ କେର୍‍ସ୍ପତଡ଼୍ ନୁ ଅଂକିଙ୍କ୍‌ ଆପ୍ ରଙ୍ଗତାଦ୍ ଚକା କେର୍‍ସ୍ପତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ଅଡ଼୍‌ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍ କେତ୍‍ତଡ଼୍, “ହଁ ଯିହୁଦୀଡ଼୍ ରାଜା, ନିମ୍‍ ନାର୍‍ଗେ ଜେଲ୍ ବାଦ୍‍କା;” ମେଣ୍ଡେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଚାପୁଡ଼ା ରେହେତାଙ୍କ୍ ପସ୍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତ ମେଣ୍ଡେ ଅନ୍‌‍ଦାମ୍ ବାଇଦେ ଆଞ୍ଜ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼ାଟ୍, ନାନ୍ ଅନାଗେ ବାତେଏ ମିକା ଦଷ୍ ଦର୍‍ସ୍‍କନ୍, ଇଦ୍ ବେଲା ମିଡ଼୍ ପୁନ୍‍ତିଡ଼୍, ଇଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ଅଂକିଙ୍କ୍‌ ମିଇ ଗାର୍‍ରେ ବାଇଦେ ତାତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ଆଗାଙ୍କ୍ ଜିସୁ ଆ କୟେନାଦ୍ ସହଜ୍‍ ନୁ ଆପ୍ କାୟାନ୍ ରଙ୍ଗତାଦ୍ ଚକା କେର୍‍ସ୍ ବାଇଦେ ୱାତ୍‍ତଣ୍ଡ୍ । ପିଲାତ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼ାଟ୍, ଇଣ୍ଡ୍ ଆ ନାରୁଣ୍ଡ୍‌ !” ");
INSERT INTO kff_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ଆଗାଙ୍କ୍ ମୁକ୍ୟ ଯାଜକ୍ ନୁ ମନ୍ଦିର୍‍ତିଙ୍କ୍ ସୁରକ୍ଷାହିଦାନଡ଼୍ ଉଡ଼ି ଗାଟି ଲେଙ୍ଗ୍ ଦେ କେତ୍‍ତଡ଼୍, “କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପାଟ୍, କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପାଟ୍,” ପିଲାତ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ଅସ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପାଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଅନାଗେ ବାତେଏ ମିକା ଦଷ୍ ଦର୍‍ସ୍‍କନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଯିହୁଦୀଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ମାୟାଗ୍‌ ୱେରନ୍ ନିୟମ୍ ମିନ୍ଦେ ନୁ ଆଦ୍ ନିୟମ୍ ଲେକାମ୍ ଅଣ୍ଡ୍‌ ଡଲାନ୍‍ଦଣ୍ଡ୍ ଜିୱେଦର୍‍କିତ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନିଜେତିଙ୍କ୍ ‘ଇଶ୍ୱର୍‌ତେ ମାର୍‍’ ଇଞ୍ଜ କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ଆଗାଙ୍କ୍ ପିଲାତ ଇଦ୍ ଗଟ୍ କେଞ୍ଜି ଗାଟି ୱେର୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ପ୍ରାସାଦ୍‍ତେ ଲୋପେ ଆସି ଜିସୁଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବେଗାଙ୍କ୍ ୱାତ୍‍ତିନ୍ ?” ବାତେଙ୍କ୍ ଇତ୍କେ ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ଆଗାଙ୍କ୍ ପିଲାତ ମେଣ୍ଡେ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ନାକିଂଙ୍କ୍ ବାତେଙ୍କ୍ ଗଟି ତିରିୟ୍‍ୱି ? ନିକିଂଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ାନଙ୍କ୍ ନାୟାଗ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ ନୁ ନିକିଂଙ୍କ୍ କ୍ରୁଶତାଗ୍ ତାର୍ସ୍‍ପାନଙ୍କ୍ ମିକା ନାୟାଦ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ, ଇଦ୍ ନିମ୍‍ ପୁନ୍‍ୱିନ୍ କି ?” ");
INSERT INTO kff_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜିସୁ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ନା ପର୍‍ର ନିୱାଦ୍ ବେନ୍ ଅଦିକାର୍‌ ମିନ୍ଦେ, ଆଦ୍ ଅଦିକାର୍‌ ନିକିଂଙ୍କ୍ ପରମେଶ୍ୱର୍ ହିତ୍‍ତଣ୍ଡ୍ । ତ ବେନ ନାକିଂଙ୍କ୍ ନି ଗାର୍‍ରେ ତାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଗାଟି ପାପ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ଆଗାଙ୍କ୍ ପିଲାତ ଜିସୁଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ାଙ୍କ୍ ଆଲ୍‍ସି ମାତ୍‌ଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଯିହୁଦୀଡ଼୍ ଗାଟି ଲେଙ୍ଗ୍ ଦେ କେତ୍‍ତଡ଼୍, “ଯଦି ନିମ୍‍ ଇ ନାରୁଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ିତିନ୍, ଆଲେକେ ନିମ୍‍ ସମ୍ରାଟ୍‍ତେ ସାଙ୍ଗ ଆୟିୱିନ୍; ବେନଆଇ ନିଜେତିଙ୍କ୍ ରାଜା ଇଞ୍ଜ କେତିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ କାଇସର୍‍ତେ ବିରଦ୍ଦ୍‌ତାଦ୍ ଗଟ୍ କେତିତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ପିଲାତ ଇଦ୍ ସାରେ ଗଟ୍ କେଞ୍ଜି ଜିସୁଙ୍କ୍ ପେସ୍ପିତାସ୍ “କାଲ୍‍ମଣ୍ଡପ୍,” ବେଦିଙ୍କ୍ ଏବ୍ରି ଗଟ୍‍ ତେ “ଗବ୍‍ବତା,” ଇଞ୍ଜ କେତିତଡ଼୍‍, ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ବିଚାର୍ ମାଡ଼ାନାଦ୍ କେତିତାଗ୍ କୁଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ଆଦ୍ ଦିନ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁତାଦ୍ ମିଟିଙ୍କ୍ ଦିନାମ୍ ମାତ୍‍ତା, ମେଣ୍ଡେ ଆସୁଟେ ଦିନାମ୍ ବାର ଗାଣ୍ଟା ଆସ୍‍ମାତ୍‍ତା । ପିଲାତ ଯିହୁଦୀଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼ାଟ୍, ମିୱଣ୍ଡ୍ ରାଜାଲ୍ !” ");
INSERT INTO kff_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଗାଟି ଲେଙ୍ଗ୍ ଦେ କେତ୍‍ତଡ଼୍, “ଅଂକିଙ୍କ୍‌ ହାୱ୍‍କାଟ୍, ହାୱ୍‍କାଟ୍, କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍‍ପାଟ୍ ।” ପିଲାତ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବାତେଏ ଇଚ୍ଛା ମାଡ଼ୁତିଡ଼୍ ନାନ୍ ମିଇ ରାଜାଙ୍କ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍ପି ହାୱ୍‍କିତାନ୍ ?” ମୁକ୍ୟ ଯାଜକିଡ଼୍ କେତ୍‍ତଡ଼୍, “ସମ୍ରାଟ୍‍ତେ ୱିଡ଼୍‍ସି ମାକିଂଙ୍କ୍ ମେଣ୍ଡେ ରାଜାଲ୍ ଇଲାଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ଆସୁଣ୍ଟ୍ ପିଲାତ ଜିସୁଙ୍କ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ପାନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌ କାଇଦେ ସମର୍‍ପନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଆସୁଣ୍ଟ୍ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ହତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ମେଣ୍ଡେ ଜିସୁ ନିଜେ କ୍ରୁଶତିଙ୍କ୍ କାଞ୍ଜି “କାପାଲସ୍ଥଲ,” ପେଦେର୍‍ତେ ପଡ଼ିୟେତାଗ୍, ବେଦିଙ୍କ୍ ଏବ୍ରି ଗଟ୍‍ ତେ “ଗଲ୍‍ଗତା,” ଇଞ୍ଜ କେତିତଡ଼୍‍, ଆଗେ ପେଇସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ଆଗେ ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍ପତଡ଼୍ ନୁ ଅନ୍‌ ତଡ଼୍ ମେଣ୍ଡେ ଇର୍‍ୱୁଡ଼୍‍କ୍ ତାର୍‍ସ୍ପତଡ଼୍, ରେଣ୍ଡ୍ ପାକେ ଇର୍‍ୱୁଡ଼୍‍କ୍ ନୁ ନାଡ଼୍‍ମେ ଜିସୁଙ୍କ୍ ୱାଟ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ପିଲାତ ୱେରନ୍ ଚିଟି ଲେକି କ୍ରୁଶତେ ପର୍‍ର ୱାଟିତ୍‍ତଣ୍ଡ୍ । ଆଗେ ଲେକ୍‍ତାଦ୍ ମାତ୍‍ତା, “ନାଜରିତିୟ ଜିସୁ, ଯିହୁଦୀଡ଼୍ ରାଜାଲ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଯିହୁଦୀଡ଼୍ ଲୋପେକେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଇଦ୍ ଚିଟି କାର୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ବେନ୍ ପଡ଼୍‍ୟ୍‍ତାଗ୍ ଜିସୁଙ୍କ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍ପିମାତ୍‍ତଡ଼୍, ଆଦ୍ ନାର୍ ଗାର୍‍ରେ ମାତ୍‍ତା; ମେଣ୍ଡେ ଆଦ୍ ଚିଟି ଲାଟିନ୍, ଗ୍ରୀକ୍ ନୁ ଏବ୍ରି ଗଟ୍‍ ତେ ଲେକ୍‍ତାଦ୍ ଆସ୍‍ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ଆଦିଙ୍କ୍ ଯିହୁଦୀଡ଼୍ ମୁକ୍ୟ ଯାଜକିଡ଼୍ ପୀଲାତଙ୍କ୍ କେତ୍‍ତଡ଼୍, “‘ଅଣ୍ଡ୍‌ ଯିହୁଦୀଡ଼୍ ରାଜା ଇଞ୍ଜ ଲେକାମ୍ ବେଲାନ୍ ନାନ୍ ଯିହୁଦୀଡ଼୍ ରାଜାନ୍ ଇଞ୍ଜ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍,’ ଇଲା ଲେକିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ପିଲାତ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ବାତ୍ ଲେକ୍‍ତାନ୍, ଆଦ୍ ଆଦ୍‍ଲେକାମ୍ ଲେକ୍‍ତାଦ୍ ମାନ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ନାଲୁୱୁଡ଼୍ ସୈନିକ୍ ଜିସୁଙ୍କ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍ପ୍‌ତେ ପେର୍‍କେ ଅନ୍‌‍ୱାଦ୍ ଚକାତିଙ୍କ୍ ଅସ୍ ନାଲୁ ଦୁଡ଼ା ମାଡ଼୍‍ତଡ଼୍, ସାରେତଡ଼୍ ସୈନ୍ୟଡ଼କ୍ ସେଙ୍ଗେ ଅଣ୍ଡୟ୍‌ ଦୁଡ଼ା, ମେଣ୍ଡେ ଅଡ଼୍‌ ଜିସୁନ୍ ଉତରୀୟ ସିଲେତିଙ୍କ୍ ମିକା ଆତ୍‍ତଡ଼୍ । ଆଦ୍ ପରକନ୍‍ସ ମଦଲ୍ ହେୱୁନା ୱିଡ଼୍‍ସି ସିଲେଇତେ ଅଣ୍ଡୟ୍‌ ସିଲେ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ଆଦିଙ୍କ୍ ସୈନ୍ୟଡ଼୍ ତାମ୍‍ତାମ୍ ତିରିୟ୍‍ତଡ଼୍, “ଇଦିଙ୍କ୍ ହିକ୍‍ମାଟ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଦ୍ ବେନନାଦ୍ ଆଦ୍‍ତେ ଆଦିନ୍ ସେଙ୍ଗେ ଗୁଲିବାଣ୍ଟ ମାଡ଼ିକାଡ଼୍,” ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଇଦ୍ ଗଟ୍ ସତ୍ ଆଦ୍‍ତେ, “ଅଡ଼୍‌ ତାମ୍‍ତାମ୍ ଲୋପେ ନାୟାଦ୍ ଚକାତିଙ୍କ୍ ତୁହୁସ୍‍ତଡ଼୍, ମେଣ୍ଡେ ନାୟାଦ୍ ଉତରୀୟ ସିଲେତ୍ ସେଙ୍ଗେ ଗୁଲିବାଣ୍ଟ ମାଡ଼୍‍ତଡ଼୍ ।” ଇଦିନ୍ ସେଙ୍ଗେ ସୈନ୍ୟଡ଼୍ ଇଲା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁନ୍ କ୍ରୁଶତେ ଗାର୍‍ରେ ତାମ୍ ୟାୟ୍‍, ତାମ୍ ୟାୟାନ୍ ଏଲାଡ଼୍‍, କ୍ଲପାନ୍ ମୁତ୍‍ତେ ମରୀୟମ୍ ନୁ ମଗ୍‍ଦଲୀନି ମରୀୟମ୍ ନିସ୍ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜିସୁ ତାମ୍ ୟାୟ୍‍ ନୁ ବେନ୍ ଶିଷ୍ୟଙ୍କ୍ ପ୍ରେମ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗାର୍‍ରେ ନିସ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ୟାୟାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼େ, ନି ମାର୍‍ରିଙ୍କ୍ !” ");
INSERT INTO kff_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ତାନ୍‍ପେର୍କେ ଆ ଶିଷ୍ୟଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼େ, ମିଇ ୟାୟାଙ୍କ୍ !” ଆ ଶିଷ୍ୟ ଆସୁଣ୍ଟ୍ ଜିସୁନ୍ ୟାୟାଙ୍କ୍ ତାମ୍ ଲୋନ୍‌ ଅତ୍‌ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ଇଞ୍ଜେ ସାରେ ବିଷୟ୍ ଶେଷ୍ ଆଦ୍‍ତେ, ଜିସୁ ଇଦ୍ ପୁତ୍‍ତଣ୍ଡ୍ । ଦର୍ମଶାସ୍ତ୍ରତାଦ୍ ବାକ୍ୟ ସତ୍ ଆତ୍‍ତାଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାକିଂଙ୍କ୍ ଉନ୍ଦେୱାତୁତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ଆଗେ ଗିନେତାଗ୍ ବର୍ତ୍ତି ପୁଲ୍‍ସ୍‍ତାଦ୍ ରସ୍ ମାତ୍‍ତା । ଅଡ଼୍‌‍ ସପ୍‍ଆଞ୍ଜ୍ ପସ୍କେତିଙ୍କ୍ ରସ୍‍ତାଗ୍ ମୁହୁସ୍ ଏଜୋପ ଟିକ୍‍କାତାଗ୍ ୱାଟି ଜିସୁନ୍ ପାୟୁର୍ ବକେତ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ଜିସୁ ଆଦିଙ୍କ୍ ଉଞ୍ଜ୍ କେତ୍‍ତଣ୍ଡ୍, “ଶେଷ୍ ଆଦ୍‍ତେ ।” ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ତାଲେତିଙ୍କ୍ ମଦଲ୍ ମାଡ଼ି ଡଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ଆଦ୍ ଦିନ୍ ନିସ୍ତାର୍ ପାଣ୍ଡୁତେ ତିଆର୍ ଦିନାମ୍ ମାତ୍‍ତା । ଅନାଦ୍‌ ମେନ୍ଦୁଲ୍ ବେଲା କ୍ରୁଶତାଗ୍ ମାନ୍‍ନ, ତାନ୍ ମେଣ୍ଡେଅନ୍‌ ଦିନ୍ ବିଶ୍ରାମବାରତାଦ୍ ବେଡ଼େୟାଦ୍ ଦିନାମ୍ ମାତ୍‍ତା । ଆଦିନ୍ ସେଙ୍ଗେ ବିଶ୍ରାମ୍‍ଦିନେତାଗ୍ କ୍ରୁଶତାଗ୍ ପର୍‍ର ମାନ୍ଦାନାୱ୍ ମେନ୍ଦୁଲ୍‍କିନ୍ ଡେକା ଉହୁସ୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡେଅନ୍‌ ପଡ଼ିୟେତାଗ୍ ଆଦାନଙ୍କ୍ ଯିହୁଦୀଡ଼୍ ପୀଲାତଙ୍କ୍ ଅନୁରଦ୍‌ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ତାନ୍‍ପେର୍କେ ସୈନିକିଡ଼୍ ୱାସ୍ ପ୍ରତମ୍ ଅର୍‍ତୁନାଦ୍ ଡେକେ ନୁ ଅନ୍‌ ତଡ଼୍ ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍ପି ମାତ୍‍ତଡ଼୍, ଅନାଦ୍‌ ଡେକେ ଉହୁତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ମାତର୍ ଅଡ଼୍‌ ଜିସୁନ୍ ଗାର୍‍ରେ ୱାସ୍ ଅଣ୍ଡ୍‌ ଡଲ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଉଡ଼ି ଅନାଦ୍‌ ଡେକେତିଙ୍କ୍ ଉହୁୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ବାତେଙ୍କ୍ ଇତ୍‍କେ ସୈନିକିଡ଼୍ ଲୋପେକେ ୱେରଣ୍ଡ୍ ଜିସୁନ୍ ଗୁଣ୍ଡେତାଗ୍ ବର୍ଚ୍ଛାତଡ଼୍ କଟ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ସାଙ୍ଗେ ସାଙ୍ଗେ ନେତୁର୍ ନୁ ଏର୍‍ ପେଇତା । ");
INSERT INTO kff_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ବେନ ଉଡ଼୍‍ତଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଣ୍ଡ୍, ବେଲାକି ମିଡ଼୍ ଆନ୍‌‍ତେ ବିଶ୍ଵାସ୍ ମାଡ଼ାଟ୍; ମେଣ୍ଡେ ଅନାଦ୍‌ ଗଟ୍ ନିଜାମ୍, ଅଣ୍ଡ୍‌ ନିଜାମ୍ କେତୁତଣ୍ଡ୍ ଇଦ୍ ଅଣ୍ଡ୍‌ ପୁତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ହିଦ୍ ଗଟ୍ ସତ୍ ଆଦାନ୍ ସେଙ୍ଗେ ଇଦ୍ ସାରେ ଗଟେମ୍ଆତ୍‍ତା, “ଅନାଦ୍‌ ୱେରନ୍ ମିକା ବୁଲା ଉହୁତାନାଦ୍ ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ବାକ୍ୟ ଲେକ୍‍ତାଦ୍ ମିନ୍ଦେ, “ଅଡ଼୍‌ ବେନଙ୍କ୍ ବର୍ଚ୍ଛାତଡ଼୍ କଟ୍‍ତଣ୍ଡ୍, ଅନ୍‌ପରୁ କଣ୍ଡେ ୱାଟାନାଦ୍‌ ।” ");
INSERT INTO kff_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ତାନ୍‍ପେର୍କେ ଆରମାତିଆତଣ୍ଡ୍ ଜଷେପ୍‍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ପୀଲାତଙ୍କ୍ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍ ତାଲ୍‍କ୍‍ତଣ୍ଡ୍ । ଜଷେପ୍‍ ଜିସୁନ୍ ୱେରନ୍ ଶିଷ୍ୟ ମାତ୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍‍କ୍ ଜିସୁନ୍ ଶିଷ୍ୟ ଇଞ୍ଜ କେଲଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଯିହୁଦି ନେତାନଡ଼୍‍କ୍ ୱେର୍‍ସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ପିଲାତ ଜଷେପ୍‍ତିଙ୍କ୍ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍ ଆଦାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଆଦିଙ୍କ୍ ଜଷେପ୍‍ ୱାସ୍ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ହତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ନିକଦୀମ ମିକା ଜଷେପ୍‍ତଡ଼୍ ଆତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ମୁନେନ୍ ଜିସୁଙ୍କ୍ ଉଡାଙ୍କ୍ ନାର୍‍କେତ୍ ୱାସ୍ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଅନ୍‌ ତଡ଼୍ ତିରିଇ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍‍ତାଗ୍ ଅକାନ୍ ସେଙ୍ଗେ ତିରିଶ୍ କେଜି ସାଏତ୍ ଗାବ୍ କାଇଲ୍‍ତାଦ୍ ଅଗୁର୍ ତାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ଯିହୁଦୀଡ଼୍ ସମାଦି ଇଦାନ୍ ନିୟମ୍ ଲେକାମ୍ ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍ ଜିସୁନ୍ ମୋଡ଼୍‍ତିଙ୍କ୍ ସାଏତ୍ ଗାବ୍‍ତାଦ୍ ଜିନିଷ୍‍ତଡ଼୍ ପାଲ୍‍ସା ସିଲେତ୍ ମୁସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଜିସୁଙ୍କ୍ ବେଗେ କ୍ରୁଶବିଦ୍ଦ ମାଡ଼ିମାତ୍‍ତଡ଼୍, ଆଦ୍ ପଡ଼ିୟେତ୍ ଗାର୍‍ରେ ୱେରନ୍ ବଗିଚା ମାତ୍‍ତା । ଆଦ୍ ବଗିଚାତାଗ୍ ୱେରନ୍ ପୁନାଦ୍ କବର୍ ମାତ୍‍ତା, ଆଗେ ମୁନେନ୍ ବେନଙ୍କେ ମିକା ସମାଦି ହିୱକଟ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ମେଣ୍ଡେ ଯିହୁଦୀଡ଼ାଦ୍‍ ଆୟୋଜନ ଦିନ୍‍ତେ, ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ଆଦ୍ ପଡ଼ିୟେତାଗ୍ ସମାଦି ଇତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ସମାଦି ଗାର୍‍ରେ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ସାପ୍ତାତେ ପ୍ରତମ୍ ଦିନ୍ ନାର୍‍କା ଇକାଡ଼୍ ମାନ୍ଦାନ୍ ୱେଲେ ମଗ୍‍ଦଲୀନି ମରୀୟମ୍ ଜିସୁନ୍ ସମାଦି ଗାର୍‍ରେ ୱାସ୍ ଆଗେ କାଲ୍‍ଦିଙ୍କ୍ ଟେଣ୍ଡିମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ଆଦିଙ୍କ୍ ଆଦ୍ ମିରିଆଞ୍ଜ୍ ଶିମୋନ୍ ପିତର୍ ନୁ ଜିସୁ ବେନଙ୍କ୍ ଗାଟି ପ୍ରେମ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍, ଆ ଶିଷ୍ୟନ୍ ଗାର୍‍ରେ ୱାତ୍‍ତା ନୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତା, “ଅଡ଼୍‌ ସମାଦି କନ୍‍ସ୍ ପ୍ରବୁଙ୍କ୍ ଆତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ବେଗେ ୱାଟ୍‍ତଡ଼୍ ମାମ୍‍ମେ ପୁନମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ଆଗାଙ୍କ୍ ପିତର୍ ନୁ ବାଗାତ୍ ଶିଷ୍ୟ ସମାଦିତା ଆଦାନଙ୍କ୍ ପେଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍ ଅଣ୍ଡୟ୍‌‍ତଡ଼୍ ମିରାନଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ବାଗାତ୍ ଶିଷ୍ୟ ପିତର୍‍ତିଙ୍କ୍ ପେର୍‍କେ ୱାଟି ମୁନେନ୍ ସମାଦିତ୍ ଗାର୍‍ରେ ହେୱୁତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ଅଣ୍ଡ୍‌ ହାଡ଼୍‍କିମିକା ଲୋପେ ଉଡ଼୍‍ତଣ୍ଡ୍ ବେନ୍ ସରୁ ସିଲେସାରେ ଜିସୁନ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ମୁସିସ୍ ମାତ୍‍ତଡ଼୍ ଆଦ୍ ରାୟିମାତ୍‍ତା, ମିକା ଅଣ୍ଡ୍‌ ଲୋପେ ହସଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ଆସୁଟେ ଶିମୋନ୍ ପିତର୍ ମିକା ଅନ୍‌ ପେର୍‍କେ ପେର୍‍କେ ୱାସ୍ ହେୱୁତ୍‍ତଣ୍ଡ୍ ନୁ ସମାଦି ଲୋପେ ହସି ଉଡ଼୍‍ତଣ୍ଡ୍ ଯେ, ସରୁ ସିଲେ ରାୟିମିନ୍ଦେ, ");
INSERT INTO kff_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଜିସୁନ୍ ତାଲେତାଗ୍ ବେନ୍ ତୁୱାଲ୍ ତଅସ୍ ମାତ୍‍ତଡ଼୍, ଆଦ୍ ସରୁ ସିଲେତଡ଼୍ ମାନକଟ୍ ମେଣ୍ଡେଅନ୍‌ ପଡ଼ିୟେତାଗ୍ ଉତ୍‍ତି ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ଆସୁଣ୍ଟ୍ ବେନ ବାଗାତ୍ ଶିଷ୍ୟ ଆଗେ ବେନ ସମାଦି ଗାର୍‍ରେ ୱାସ୍ ମୁନେନ୍ ହେଉସ୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିକା ଲୋପେ ହସି ଉଡ଼୍‍ତଣ୍ଡ୍ ନୁ ବିଶ୍ଵାସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ଦର୍ମଶାସ୍ତ୍ର ଲେକାମ୍, “ଜିସୁ ଡଲ୍‍ନାଦ୍ କନ୍‍ସ୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ତେଦିତଣ୍ଡ୍,” ଇଦିନାଦ୍ ଇତ୍‍କେ ଆଦ୍ ଶିଷ୍ୟଡ଼୍ ଆସୁଙ୍କ୍ ହେୱୁନା ପୁନ୍‍ୱକଟ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ତାନ୍‍ପେର୍କେ ଶିଷ୍ୟଡ଼୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ତାମ୍ ଲୋକ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମରୀୟମ୍ କେୟକେୟ ସମାଦି ବାଇଦେ ନିସ୍‍ମାତ୍‍ତା; ମେଣ୍ଡେ ଆଦ୍ କେୟକେୟ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସମାଦି ଲୋପେ ଉଡ଼୍‍ତା, ");
INSERT INTO kff_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଜିସୁନ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ୱାଟିମାତ୍‍ତଡ଼୍‍, ଆଗେ ତାଲେତ୍ ପାକ୍ ୱେରଣ୍ଡ୍ ନୁ ଡେକେତ୍ ପାକ୍ ୱେରଣ୍ଡ୍, ପାଣ୍ଡେ ସିଲେ କେର୍‍ସ୍ ଇର୍‍ୱୁଡ଼୍ ଦୂତ କୁଦିମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ଆଦ୍ ଦୂତଡ଼୍ ଆଦିଙ୍କ୍ କେତ୍‍ତା, “ହଁ ୟାୟ୍‍, ବାତେଙ୍କ୍ କେୟୁତିନ୍ ?” ଆଦ୍ ନାଟାଡ଼୍ କେତ୍‍ତେ, “ବେନଡ଼୍ ନା ପ୍ରବୁଙ୍କ୍ ହତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ବେନ୍ ପଡ଼ିୟେତାଗ୍ ୱାଟ୍‍ତଡ଼୍, ଆଦ୍ ନାନ୍ ପୁନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ଆଦ୍ ଇଲା କେସ୍ ପେର୍‍କେ ତିଡ଼ିଇପାକା ଜିସୁଙ୍କ୍ ନିସ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତା, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଜିସୁ ଇଞ୍ଜ ଆଦ୍ ପୁନ୍ଦାଙ୍କ୍ ପାର୍‍ୱ । ");
INSERT INTO kff_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହଁ ୟାୟ୍‍, ବାତେଙ୍କ୍ କେୟୁତିନ୍ ? ବେନଙ୍କ୍ ମେହେକୁତିନ୍ ?” ଆଦ୍ ଅଂକିଙ୍କ୍‌ ବଗିଚାତଣ୍ଡ୍ ଗତିଆଲ୍ ଇଞ୍ଜ ହେର୍କା ମାଡ଼ି କେତ୍‍ତା, “ଗଟ୍ ନିମ୍‍ ଯଦି ଜିସୁଙ୍କ୍ ହତ୍‍ତି, ଆଲେକେ ଅଂକିଙ୍କ୍‌ ବେଗେ ୱାଟ୍‍ତି ନାକିଂଙ୍କ୍ କେଲ୍‍ମ୍, ନାନ୍ ଅଂକିଙ୍କ୍‌ ଆଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମରୀୟମ୍ !” ଆଦ୍ ତିଡ଼ିଇମିକା ଏବ୍ରି ଗଟ୍‍ତେ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତା, “ରାବ୍‍ବୂନୀ,” ଇତ୍‍କେ, “ହଁ ଗୁର ।” ");
INSERT INTO kff_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜିସୁ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାକିଂଙ୍କ୍ ପଇସ୍ ନେହେମା, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଇଞ୍ଜେକ୍ ଅନ୍‌‍ପାକେ ବାବାନାଗ୍ ଆନନେ; ନା ତାମୁଣ୍ଡ୍‌କିଡ଼୍ କେଲ୍‍ଲା, ନାନ୍ ନା ବାବାଲ୍ ନୁ ଅଡ଼୍‌ ବାବାଲ୍, ନା ଇଶ୍ୱର୍ ନୁ ଅଡ଼୍‌ ଇଶ୍ୱର୍‌ତେ ଗାର୍‍ରେ ଆଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ମଗ୍‍ଦଲୀନି ମରୀୟମ୍ ଆଞ୍ଜ୍, ନାନ୍ ପ୍ରବୁଙ୍କ୍ ଉଡ଼୍‍ତାନ୍, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ଇୱୁସାରେ କେତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଶିଷ୍ୟଡ଼କ୍ କବର୍ ଇତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ଆଦ୍ ଦିନ୍ ଇତ୍‍କେ ସାପ୍ତାହତେ ପ୍ରତମ୍ ଦିନ୍ ମୁଲ୍‍ପୁଟ୍ ଶିଷ୍ୟଡ଼୍ ବେନ୍ ଲୋନ୍‌ ମାତ୍‍ତଡ଼୍, ଆଦ୍ ଲୋତ୍‍ତା କାପାଟ୍ ସାରେ ଯିହୁଦୀଡ଼୍ ୱେରେତେ ସେଙ୍ଗେ ବନ୍ଦ୍ ମାତ୍‍ତା, ଆସୁଟେ ଜିସୁ ୱାସ୍ ନାଡ଼୍‍ମେ ନିସ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିୟାଦ୍ ଶାନ୍ତି ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଇଦ୍ କେସ୍ ଜିସୁ ଶିଷ୍ୟଡ଼କ୍ ତାନ୍ କାଇକ୍ ନୁ ଗୁଣ୍ଡେତିଙ୍କ୍ ତଅତ୍‍ତଣ୍ଡ୍ । ଆଗାଙ୍କ୍ ଶିଷ୍ୟଡ଼୍ ପ୍ରବୁଙ୍କ୍ ଉଡ଼ି ୱେଡ଼୍‍କ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡେ ଅନ୍‌‍ଦାମ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିୟାଦ୍ ଶାନ୍ତି ଆୟି; ବାବାଲ୍ ନିକିଂଙ୍କ୍ ବେଦ୍ ରକମ୍ ରହତଣ୍ଡ୍, ଆଦେ ପୁଟୁଙ୍କ୍ ନାନ୍ ମିକା ମିକିଂଙ୍କ୍ ରହତୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ଜିସୁ ଇଲା କେସ୍ ଅଡ଼୍‌ ପର୍‍ର ନେହେସ୍‍କି କେତ୍‍ତଣ୍ଡ୍, “ପବିତ୍ର ଆତ୍ମାତିଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ମିଡ଼୍ ଯଦି ବେନନାଦ୍ ପାପ୍ କ୍ଷମା ମାଡ଼ିତିଡ଼୍, ଅନାଦ୍‌ ପାପ୍ କ୍ଷମା ଆଦ୍‍ତେ; ମେଣ୍ଡେ ବେନନାଦ୍ ପାପ୍ କ୍ଷମା ମାଡ଼କ୍, ଅନାଦ୍‌ ପାପ୍ କ୍ଷମା ଆୟ୍‍ୟ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ଜିସୁ ବେସୁଟ୍‌ ୱାସ୍ ମାତ୍‍ତଣ୍ଡ୍, ଆସୁଟେ ବାରଜାନ୍ ଶିଷ୍ୟଡ଼୍ ଲୋପେ ତୋମା ପେଦେର୍‍ତଣ୍ଡ୍ ବେନଙ୍କ୍ “ଦିଦୁମ୍,” ଇଞ୍ଜ କେତିତଡ଼୍‍, ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍ତଡ଼୍ ହିଲ୍‍ୱାମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ବାଗାତ୍ ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ମାମ୍‍ମେ ପ୍ରବୁଙ୍କ୍ ଉଡ଼୍‍ତମ୍ ।” ବାତେଙ୍କ୍ ଇତ୍‍କେ ତୋମା ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଅନାଦ୍‌ କାଇକିନାଗ୍ କୋୟେତ୍ ଚିହିହ୍ନେ ଉଡ଼କ୍ ନୁ ଆଗେ ନା ୱାଡ଼ଞ୍ଜ୍ ହିଟ୍‍ହକ୍ ନୁ ଅନାଦ୍‌ ଗୁଣ୍ଡେତାଗ୍ ନା କାୟ୍ ହିଟ୍‍ହକ୍ ନାନ୍ ବେସୁଟେ ବିଶ୍ୱାସ୍ ମାଡ଼ନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଆଟ୍‍ ଦିନାତ୍ ପେର୍‍କେ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ଲୋପେ ମାତ୍‍ତଡ଼୍ ନୁ ତୋମାଲ୍‌ ଅଡ଼୍‌‍ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ । ହାର୍ ବନ୍ଦ୍ ମାତ୍‍ତା ୱେଲେ ଜିସୁ ୱାସ୍ ନାଡ଼୍‍ମେ ନିସ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିୟାଦ୍ ଶାନ୍ତି ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ପେର୍‍କେ ଜିସୁ ତୋମାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଗେ ୱାଡ଼୍‍ଞ୍ଜ୍ ତାସ୍ ନା କାଇକିଂଙ୍କ୍ ଉଡ଼େ ନୁ କାୟ୍ ହାହାସ୍ ନା ଗୁଣ୍ଡେତାଗ୍ ହିଟ୍‍ତା; ଅବିଶ୍ୱାସୀ ଆୟିୱେକନ୍‍ସ୍ ବିଶ୍ୱାସୀ ଆୟିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତୋମା ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନା ପ୍ରବୁ ନା ଇଶ୍ୱର୍ !” ");
INSERT INTO kff_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜିସୁ ତୋମାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ନାକିଂଙ୍କ୍ ଉଡ଼୍‍ତାଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତି, ବେନଡ଼୍ ଉଡ଼୍‍ୱାକନ୍‍ସ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିମିନ୍ଦେଡ଼୍, ଅଡ଼୍‌ ଦନ୍ୟ !” ");
INSERT INTO kff_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଜିସୁ ଶିଷ୍ୟଡ଼କ୍ ଉପସ୍ଥିତ୍‍ତେ ନାର୍‍ଗେ ବାକ୍‍ୱା ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍, ଆୱୁସାରେ ଇଦ୍ ବଇତାଗ୍ ଲେକ୍‍ତାଦ୍ ଇଲେ; ");
INSERT INTO kff_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତିଡ଼୍ ଯେ, ଜିସୁ ଆଦୁତନ୍ ଇଶ୍ୱର୍‌ତେ ମାର୍‍ ମସିହ, ମେଣ୍ଡେ ଅନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ି ମିଡ଼୍ ବେଲା ଜିୱୁଣ୍ଡ୍ ଦର୍‍କିତ୍, ଇଦିନ୍ ସେଙ୍ଗେ ଇୱୁସାରେ ଲେକ୍‍ତାଦ୍ ଆସ୍‍ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ପେର୍‍କେ ଜିସୁ ତିବିରୀୟା ସମୁଦ୍ର ଆଞ୍ଚିନାଗ୍ ଶିଷ୍ୟଡ଼୍‍କ୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ଦର୍ଶନ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଇଦ୍ ରକମ୍ ଦର୍ଶନ୍ ହିତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ଶିମୋନ୍ ପିତର୍, ତୋମା, ବେନଙ୍କ୍ ଦିଦୁମ୍ କେତିତଡ଼୍‍, ଗାଲିଲୀତେ କାନାନଡ଼୍‍ ନିତନିୟେଲ୍, ଜେବଦିତେ ମାର୍‍କିଡ଼୍ ନୁ ତାନ୍ ଶିଷ୍ୟଡ଼୍ ଲୋପେକେ ମେଣ୍ଡେ ଇର୍‍ୱୁଡ଼୍ ଅଣ୍ଡୟାଗେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ଶିମୋନ୍ ପିତର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ କିକେ ପଇଦାନଙ୍କ୍ ଆଦୁତାନ୍ ।” ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଡ଼୍, “ମାମ୍‍ମେ ମିକା ନି ତଡ଼୍ ଆଦ୍‍ତମ୍ ।” ଅଡ଼୍‌ ପେଇସ୍ ଆଞ୍ଜ୍ ଓଡାତାଗ୍ ତାର୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦ୍ ନାର୍‍କା ୱାଲା ୱାଟ୍‍ତଡ଼୍ ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାତେମିକା ଦର୍‍କ । ");
INSERT INTO kff_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ବାତେଙ୍କ୍ ଇତ୍‍କେ ୱିଇଦାନ୍ ୱେଲେ ଜିସୁ ଆଞ୍ଚିନାଗ୍ ନିତ୍‍ତଣ୍ଡ୍; ମିକା ଅଣ୍ଡ୍‌ ଜିସୁ ହିଞ୍ଜ ଶିଷ୍ୟଡ଼୍ ପୁନଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପିଲାନଡ଼ି ମିୟାଗେ ବାତେଏ ତିନ୍ଦାନାଦ୍ ମିନ୍ଦେ ?” ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ଇଲେ ।” ");
INSERT INTO kff_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଓଡେତ୍ ତିନ୍ଦେକାଇଦା ପାକ୍ ୱାଲା ୱାଟାଟ୍‌ ତ, ଆସୁଟେ ମିକିଂଙ୍କ୍ ଦର୍‍କିତା ।” ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ୱାଲା ୱାଟ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଗାଟି କିକେ ୱାଲାତାଗ୍ ହାର୍‍ତା ଅଡ଼୍‌‍ ୱାଲେତିଙ୍କ୍ ପିଡ଼ିଙ୍ଗାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ଜିସୁ ବେନ୍ ଶିଷ୍ୟଙ୍କ୍ ପ୍ରେମ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଣ୍ଡ୍ ତ ପ୍ରବୁ ।” ଶିମୋନ୍ ପିତର୍ ଇଣ୍ଡ୍ ତ ପ୍ରବୁ ଇଞ୍ଜ କେତାନାଦ୍ କେଞ୍ଜି ତାନ୍ ଚକା କେର୍‍ସ୍ ସମୁଦ୍ରତାଗ୍ ତୁଲ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ବାତେଙ୍କ୍ ଇତ୍‍କେ ବାଗାତ୍ ଶିଷ୍ୟଡ଼୍ କିକେ ମାନ୍ଦାନ୍ ୱାଲେତିଙ୍କ୍ ପିଡ଼ିଙ୍ଗି ସୁଦୁର୍ ଓଡାତାଗ୍ ୱାତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ କୂଳତ୍‍ ଗାର୍‍ରେ ଦୁଇଶହ କାୟ୍ ଜେକେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ଅଡ଼୍‌ ଆଞ୍ଚିନାଗ୍‌ ଡିଗି ଆଗେ ଇର୍କିନାଗ୍ କିସ୍, ମେଣ୍ଡେ ତାନ୍ ପରୁ ୱାଟ୍‍ତାଉ ସୁକୁକ୍ କିକେ ନୁ ରୂଟି ୱାଟି ମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଇଞ୍ଜେ ବେନା କିକେ ପୟିତ୍‍ତିଡ଼୍, ଆଗାଙ୍କ୍ ସୁକୁକ୍ ତାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ଶିମୋନ୍ ପିତର୍ ଆଞ୍ଜ୍ ଶହେ ପାଚାଶ୍‍ମୁଣ୍ଡ୍ ବେଡ଼୍‍ୟା କିକେ ନିଣ୍ଡିମାନ୍ଦାନ୍ ୱାଲେତିଙ୍କ୍ ଆଞ୍ଚିନାଗ୍‌ ପିଡ଼ିଙ୍ଗି ତାତ୍‍ତଡ଼୍; ଆସର୍ କିକେଙ୍କ୍ ମିକା ୱାଲା ଦେଗ । ");
INSERT INTO kff_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ୱାସ୍ ମିକା ତିନୁଟ୍ ।” ଶିଷ୍ୟଡ଼୍ ଲୋପେ ବେନମିକା “ଅଂକିଙ୍କ୍‌ ବେନ,” ଇଞ୍ଜ ପାଚ୍ରାମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଯେ ପ୍ରବୁ, ଇଦ୍ ଅଡ଼୍‌ ପୁତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜିସୁ ୱାସ୍ ରୂଟି ତାସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଆଦେପୁଟୁଙ୍କ୍ କିକେ ମିକା ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ଡଲ୍‍ତଡ଼୍ ଲୋପେଙ୍କ୍ ତେଦ୍‍ତା ପେର୍‍କେ ଜିସୁ ଶିଷ୍ୟଡ଼୍‍କ୍ ଇଦ୍ ମୁଣ୍ଡ୍‍ଦାମ୍ ଦର୍ଶନ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ଶିଷ୍ୟଡ଼୍ ତିତ୍‍ତା ପେର୍‍କେ ଜିସୁ ଶିମୋନ୍ ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହଁ ଯୋହନ୍‌‌ତେ ମାର୍‍ ଶିମୋନ୍, ନିମ୍‍ ବାତେଏ ନାକିଂଙ୍କ୍ ଇଡ଼୍ ଲୋପେଙ୍କ୍ ଗାଟି ପ୍ରେମ ମାଡ଼ୁତି ?” ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହଁ, ପ୍ରବୁ, ନାନ୍ ଯେ ନିକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତାନ୍, ଆଦ୍ ନିମ୍‍ ପୁତ୍‍ତି ।” ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାୟାଦ୍ ମେଣ୍ଢାପିଲାଙ୍କ୍ ମେଇମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ଜିସୁ ଦ୍ୱିତୀୟଦାମ୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହଁ ଯୋହନ୍‌‌ ମାର୍‍ ଶିମୋନ୍, ନିମ୍‍ ବାତେଏ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତିନ୍ ?” ଅଣ୍ଡ୍‌ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ହଁ, ପ୍ରବୁ, ନାନ୍ ଯେ ନିକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତାନ୍, ଆଦ୍ ନିମ୍‍ ପୁତ୍‍ତି ।” ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନା ମେଣ୍ଢାକିଂଙ୍କ୍ ପୋଡ଼୍‍ପା ।” ");
INSERT INTO kff_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜିସୁ ମୁଣ୍ଡ୍‍ଦାମ୍ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ହଁ ଯୋହନ୍‌‌ତେ ମାର୍‍ ଶିମୋନ୍, ନିମ୍‍ ବାତେଏ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତି ?” ଇଗେ ପିତର୍ ମାନ୍‍ଦୁଃକାମ୍ ଆତ୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଜିସୁ ମୁଣ୍ଡ୍‍ଦାମ୍ ପିତର୍‍ତିଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ନିମ୍‍ ବାତେଏ ନାକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତି ? ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ, ନିମ୍‍ ସାରେ ବିଷୟ ପୁତ୍‍ତି; ନାନ୍ ଯେ ନିକିଂଙ୍କ୍ ପ୍ରେମ ମାଡ଼ୁତାନ୍, ଆଦ୍ ନିମ୍‍ ପୁତ୍‍ତିନ୍ ।” ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନାୟାୱୁ ମେଣ୍ଢାକିଂଙ୍କ୍ ମେଇମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ନାନ୍ ନିଜାମ୍‍ କେତୁତାନ୍, ଲେୟ୍‍ ମାନ୍ଦାନ୍ ୱେଲେ ନିମ୍‍ ନିଜେତ୍ ସିଲେତିଙ୍କ୍ ଗାଟ୍ ୱାଟି ବେକେ ଇଚ୍ଛା, ଚିଟି ଆଞ୍ଜ ମାତ୍‍ତିନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମୁଇତା ୱେଲେ ନିମ୍‍ ନିୟାୱୁ କାଇକ୍ ହାଆତିତି ନୁ ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ନିକିଂଙ୍କ୍ ଗାଟ୍ ୱାଟି, ବେକେ ନିୟାଦ୍ ଇଚ୍ଛା ଇଲେ, ଚିଟି ନିକିଂଙ୍କ୍ ଆଦ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ପରମେଶ୍ୱର୍‍ତେ ଗୌରବ୍‍ ସେଙ୍ଗେ ପିତର୍ ବେଦ୍‍ରକମ୍‍ ଡଲିତଣ୍ଡ୍, ଇଦ୍ ବୁଜାମାଡ଼ାନଙ୍କ୍ ଜିସୁ ଆଦ୍ ରକମ୍ କେସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ତିନ୍‍ପେର୍କେ ଜିସୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନା ପେର୍‍କେ ୱାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ଜିସୁ ବେନ୍ ଶିଷ୍ୟଙ୍କ୍ ପ୍ରେମ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ ନୁ ବେନ ନାର୍‍କେତ୍ ବଜିତାଗ୍ ଜିସୁନ୍ ପର୍‍ର ରହି, “ପ୍ରବୁ, ନିକିଂଙ୍କ୍ ବେନ ଶତ୍ରୁଡ଼୍ କାଇଦେ ପସ୍‍ପିତଣ୍ଡ୍ ଇଞ୍ଜ କେସ୍ ମାତ୍‍ତଣ୍ଡ୍,” ଆ ଶିଷ୍ୟଙ୍କ୍ ପିତର୍ ତିଡ଼ିଇ ପେର୍‍କେ ୱାଦାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତର୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ, ଇଡ଼୍‍ୱାଦ୍ ବିଷୟ୍ ବେଲା ଆଦ୍‍ତେ ?” ");
INSERT INTO kff_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜିସୁ ପିତର୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାୟାଦ୍ ମେଣ୍ଡଅନ୍‌‍ଦାମ୍ ୱାଦାନାଦ୍ ଆଦାନ୍ ଯାକ ଅଣ୍ଡ୍‌ ବାଦ୍‍କିନ୍ ଇଞ୍ଜ ଯଦି ଇଚ୍ଛା ମାଡ଼ିତାନ୍, ଆଲାଇତ୍‍କେ ଆଗେ ନିୟାଦ୍ ବାତେଏ ମିନ୍ଦେ ? ନିମ୍‍ ନାକିଂଙ୍କ୍ ପେର୍‍କେ ମାଡ଼ା ।” ");
INSERT INTO kff_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ଆଗାଙ୍କ୍ ଆ ଶିଷ୍ୟ ବେସୁଟ୍‌ ମିକା ଡଲନ୍, ତାମୁଣ୍ଡ୍‌କିଡ଼୍ ଲୋପେ ଇଦ୍ ଗଟ୍ ପ୍ରଚାର୍ ଆଦ୍‍ତେ, ମାତର୍ ଅଣ୍ଡ୍‌ ଡଲନ୍ ଇଞ୍ଜ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେଲଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ମାତର୍, “ନାୟାଦ୍ ୱାଦାନାଦ୍ ଯାକ ଅଣ୍ଡ୍‌ ମାନିଣ୍ଡ୍ ଇଞ୍ଜ ଯଦି ନାନ୍ ଇଚ୍ଛା ମାଡ଼ିତାନ୍, ଆଲେକେ ଆଗେ ନିୟାଦ୍ ବାତେଏ ମିନ୍ଦେ,” ଇଞ୍ଜ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ବେନ ଇ ସାରେ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଣ୍ଡ୍ ନୁ ଇୱୁସାରେ ଲେକିମିନ୍ଦେଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆ ଶିଷ୍ୟ; ମେଣ୍ଡେ ଅନାଦ୍‌ ସାକ୍ଷ୍ୟ ନିଜାମ୍, ଆଦ୍‌ ମାମ୍‍ମେ ପୁତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଜିସୁ ମେଣ୍ଡେ ନାର୍‍ଗେ ପାଡ଼୍‍ୟି ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍; ଆଉ ସାରେ ଯଦି ୱେରୱେର ମାଡ଼ି ଲେକି ମାନ୍ଦାନ୍‌ ଇତ୍କେ, ଆଲେକେ ଇସର୍‌ ବଇ ଲେକା ଆୟେଡ଼୍ ଯେ, ନାୟାଦ୍ ବିଚାର୍‍ତେ ଇଦ୍ ଜଗତ୍‍ତାଗ୍ ମିକା ଆୱୁ ସାରେ ନେହେତାନ୍ ସେଙ୍ଗେ ପଡ଼ିୟେ ଆୟ୍‍ୟ ଆୟେଡ଼୍ ।");
INSERT INTO kff_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ପ୍ରିୟ ତିୟଫୀଲସ୍‍, ନାୱାଦ୍ ମୁନେନ୍ ତିଆର୍ ଆତ୍‍ତେ ଲୁକ ବଇତାଗ୍ ଜିସୁ ତାନ୍ ପାଡ଼୍‍ୟି ଆରାମ୍ ମାଡ଼୍‍ତାଗାକନ୍ସ୍‍, ");
INSERT INTO kff_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ସ୍ୱର୍ଗତାଗ୍ ଆଦାନ୍ ଯାକ ବେନାସାର୍ରେ ପାଡ଼୍‍ୟି ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ ନୁ ଶିକ୍ଷା ଇସ୍‌ ମାତ୍‍ତଣ୍ଡ୍, ଆୱ୍‍ଚାରେ ବିଷୟ୍ ଲେକିମାତ୍‍ତାନ୍ । ସ୍ୱର୍ଗତାଗ୍ ଆଦାନ୍ ମୁନେଙ୍କ୍ ବେନଡ଼୍‍କ୍ ଅଣ୍ଡ୍‌ ନିଜେତ୍ ପ୍ରେରିତ ଶିଷ୍ୟ ଇଞ୍ଜ ଏଞ୍ଚି ମାତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ ପବିତ୍ର ଆତ୍ମାତେ ଶକ୍ତିତେ ଆଦେଶ୍‍ ଇସ୍‌‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ଆସୁଟେ ଅଣ୍ଡ୍‌ ଜିୱୁନ୍‍ ମାତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ପ୍ରମାନ୍ ମାଡ଼ାଙ୍କ୍ ନୁ ଶିଷ୍ୟଡ଼ାଦ୍ ଏର୍କା ଦୁର୍‍ ମାଡ଼ାଙ୍କ୍ ଅଣ୍ଡ୍‌ ତାନାଦ୍ ଡଲ୍‍ତେ ପେର୍‍କେ ଚାଲିଶ୍ ଦିନ୍ ଏୱୁନା ନାର୍ଗେଦାମ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦର୍ଶନ୍ ଇସ୍‌ ମାତ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ଜିସୁଙ୍କ୍ ଉଡ଼ିମାତ୍‍ତଡ଼୍ ନୁ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଶ୍ୱର୍‌ତାଦ୍ ରାଜ୍ୟ ବିଷୟ୍‍ତେ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ଯିରୁଶାଲେମ୍‍ ଅଡ଼୍‌ ଅଣ୍ଡୟାଗେ ତିନ୍ଦାଙ୍କ୍‍ ଗୁଡ଼୍‍ତେ ୱେଲେ ଜିସୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍, “ଜିରୂଶାଲମ୍ ୱିଡ଼୍‍ସ୍‍ମାଟ୍ । ସ୍ୱର୍ଗତେ ବାବାଲ୍ ମିକିଂଙ୍କ୍ ବାଆତେ ହିଦ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ପ୍ରତିଜ୍ଞା ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ବେନ୍ ଦାନ ବିଷୟ୍‍ତେ ନାନ୍ ମିକିଂଙ୍କ୍ କେସ୍‍ମାତ୍‍ତାନ୍, ଆଦ୍ ପାଏମ୍ ଆଦାନ୍ ଯାକ କେପାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଯୋହନ୍‌ ହେର୍‍ତାଗ୍ ବାପ୍ତିସ୍ମ ହିତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ସୁଦୁଟ୍ ଦିନାତ୍ ଲୋପେ ମିଡ଼୍ ପବିତ୍ର ଆତ୍ମାତଡ଼୍ ବାପ୍ତିସ୍ମ ଆଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ଅନ୍‌‍ଦିନେ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଅଣ୍ଡୟାଗେ ମାନ୍ଦାନ୍‍ୱେଲେ ଜିସୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ, ନିମ୍‍ ଇଞ୍ଜେ ଇସ୍ରାଏଲ୍‍ଡ଼୍‍କିଙ୍କ୍ ଅଡ଼ାଦ୍‌ ରାଜ୍ୟ ମାଲ୍‍ପି ଇଦ୍‍ତିନ୍‍ ?” ");
INSERT INTO kff_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ଜିସୁ କେତ୍‍ତଣ୍ଡ୍, “ତାରିକ୍ ନୁ ସମୟ୍‍ତିଙ୍କ୍ ନା ବାବାଲ୍ ତାନ୍ ଅଦିକାର୍‌‍ ଗଟ୍‍ତେ ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍ । ଇୱୁସାରେ ବେସୁଟ୍‌ ଗଟେମ୍ ଆଦ୍‍ତେ, ମିଡ଼୍ ପୁନ୍ଦାଙ୍କ୍ ଦର୍‍କାର୍ ଇଲେ । ");
INSERT INTO kff_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଇ ପର୍‍ର ପବିତ୍ର ଆତ୍ମା ଡିଗ୍‍କେ, ମିଡ଼୍ ଶକ୍ତିଶାଲୀ ଆଦ୍‍ତିଡ଼୍ ନୁ ଜିସୁ, ପୁରା ଯିରୁଶାଲେମ୍‍ ଯିହୁଦା ନୁ ଶମିରୋମ୍ ନୁ ପୃତିବିତାଗ୍ ଶେଷସୀମା ଏୱୁନା ନା ସେଙ୍ଗେ ମିଡ଼୍ ସାକ୍ଷି ଆଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଇଦ୍ କେତ୍‍ତେ ପେର୍‍କେ ଜିସୁଙ୍କ୍ ସ୍ୱର୍ଗତାଗ୍ ମାୟିଆତ୍‍ତାଦ୍ ଅଡ଼୍‌ ଉଡ଼୍‍ତଡ଼୍ ନୁ ୱେରଡ଼୍ ମାବ୍ ଲୋପେ ଅଣ୍ଡ୍‌ ଅଡ଼ାୱୁ କଣ୍ଡାନ୍ ମୁନେକନ୍ସ୍ ମାୟିଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ଅଣ୍ଡ୍‌ ପର୍‍ର ଆତ୍‍ତେ ପେର୍‍କେ ମିକା ଅଡ଼୍‌ ଅଣ୍ଡୟ୍‌ କଣ୍ଡେତେ ସ୍ୱର୍ଗତାଗ୍ ଉଡ଼ିମାତ୍‍ତଡ଼୍‍ । ପାଣ୍ଡ୍ରି ଚକାସିଲେ କେର୍‍ତେ ଇର୍‍ୱୁଡ଼୍ ନାରୁଡ଼୍ ହଟାତ୍ ଅଡ଼୍‌ ଗାର୍‍ରେ ୱାସ୍ ନିତ୍‍ତଡ଼୍ ");
INSERT INTO kff_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ନୁ କେତ୍‍ତଡ଼୍, “ହୋ ଗାଲିଲୀୟଡ଼ି, ବାତେଙ୍କ୍ ଇଗେ ନିସ୍ ମୟଲ୍‍ତାଗ୍ ଉଡ଼ିମିନ୍ଦେଡ଼ି ? ହି ଜିସୁ ମିୟାଗାଙ୍କ୍ ସ୍ୱର୍ଗତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବେଦ୍‍ରକମ୍‍ ସ୍ୱର୍ଗତା ଆଦାନାଦ୍ ଉଡ଼୍‍ତିଡ଼୍, ଟିକ୍ ଆଦେରକମ୍ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ମାଲ୍‍ସ୍ ୱାଦ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ଯିରୁଶାଲେମ୍‍ତେ ପେର୍କେ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଜୀତ ମେଟେତାଗାଙ୍କ୍ ଜିରୂଶାଲମ୍ ମାଲ୍‍ସ୍ ଆଦ୍‍ତଡ଼୍ । ଜୀତ ମେଟେ ସହର୍‍କନ୍‍ସ୍ ଅଣ୍ଡୟ୍‌‍ କିଲମିଟର୍ ଦୁରାମ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ଯାକୁବ୍ ଆଞ୍ଜ୍ ଅଡ଼୍‌ ବେଗେ ମାତ୍‍ତଡ଼୍‍ ତାନ୍ ପରତ୍‍ ବାକ୍‍ଡ଼େତାଗ୍ ଅସ୍‍ତଡ଼୍ । ଆଦ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଆଦୁତଡ଼୍‍ ପିତର୍, ଯୋହନ୍‌, ରଙ୍ଗ୍‍ବୁମ୍‍, ଆନ୍ଦ୍ରିୟ, ଫିଲିପ୍‍ପ, ତୋମା, ବର୍ତଲମି, ମାତିଉ, ଆଲ୍‍ଫିନ୍ ମାର୍‍ ଜାକୁବ୍‍ତେ ଦେଶ୍‍ତିଙ୍କ୍‍ପ୍ରେମ ମାଡ଼ାନ୍ ଶିମୋନ୍ ନୁ ରଙ୍ଗ୍‍ବୁମ୍‍ନ୍ ମାର୍‍ ଯିହୁଦା । ");
INSERT INTO kff_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ଅଡ଼୍‌ ନାର୍ଗେଦାମ୍ ୱେରଡ଼୍ ମାନ୍ଦେ ଆସ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡୟାଗେ ଆସମାତ୍‍ତଡ଼୍ ନୁ ଅଡ଼୍‌‍ତଡ଼୍ ଜିସୁନ୍‍ ୟାୟ୍‍ ମରୀୟମ୍ ନୁ ବାଗାତ୍ ନାଟାଙ୍କ୍ ନୁ ଜିସୁନ୍ ବିଶ୍ୱାସୀ ତାମୁଣ୍ଡ୍‌କିଡ଼୍ ମିକା କାୟ୍‍ଲମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ଆଦେ ବେସ୍‍କେ ଦିନାନ୍‍ ଲୋପେ ସାରେ ଶହେ କୁଡ଼ିଏ ଜାନ୍‍ ବିଶ୍ୱାସୀ ତାମୁଣ୍ଡ୍‌ ଅଣ୍ଡୟ୍‌ ମିଟିଙ୍ଗ୍‌ତାଗ୍‌ ପିତର୍ ପେଦେର୍‍ତଣ୍ଡ୍‍ ନିସ୍‍ମିକା କେତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ଦାଦାଲଡ଼୍‍ ନୁ ଏଲାସ୍କ୍‍, ବେନ୍ ଇସ୍କରିୟ ଯିହୁଦା ଜିସୁଙ୍କ୍ ପସ୍‍ପିଦାନ୍ ମାଇଦିଙ୍କ୍ ଶତ୍ରୁଡ଼୍ ସେଙ୍ଗେ ହାର୍ ତଅସ୍ ମାତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ବିଷୟ୍‍ତେ ଦାଉଦ୍ ପବିତ୍ର ଆତ୍ମାତଡ଼୍‍ ଚାଲେମ୍ ଆସ୍ ବବିଷ୍ୟତ୍‍ ଗଟ୍ କେଞ୍ଜ୍‍ସ୍ପି ମାତ୍‍ତଣ୍ଡ୍ । ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ କେତ୍‍ତାଦ୍ ଆଦ୍ ଗଟ୍ ସାରେ ଆଦାନାଦ୍ ନିଜାମ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ବାତେଙ୍କ୍‍ଇତ୍‍କେ ଯିହୁଦାଲ୍ ମା ଦଲ୍‍ତାଗ୍ ମେମ୍ବର୍‍ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ମା ତଡ଼୍ ପାଡ଼୍‍ୟିଦାଗ୍‍ କାଇଲାନ୍ ସେଙ୍ଗେ ହେଞ୍ଚିମାନ୍ଦାନ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ଅନାଦ୍‌ କାରାପ୍ ପାଡ଼୍‍ୟି ତଡ଼୍ ଯିହୁଦା ଦର୍‍ସ୍କିମାନ୍ଦାନ୍ ଡାବ୍‍କିନେ ୱେରଡ଼୍ ବୁମ୍ ଆସିମାତ୍‍ତଣ୍ଡ୍ ନୁ ଆଦ୍ ବୁମ୍‍ତାଗ୍ ରାଲି ଅଣ୍ଡ୍‌ ଡଲ୍‍ତଣ୍ଡ୍ । ଅନାଦ୍‌ ଡଙ୍କେ ପାର୍କ୍ ଆସ୍ ପଅକ୍ ପେୟ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଯିରୁଶାଲେମ୍‍ତାଗ୍‍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍ ଇଦ୍‍ସାରେ ପୁଞ୍ଜ୍‍ମିକା ଅଡ଼ାଦ୍‌ ଗଟ୍‍ତେ ଆଦ୍ ବୁମ୍‍ତେ ପେଦେର୍ “ଆକେଲ୍‍ଦାମା,” ଇତ୍‍କେ “ନେତୁର୍‍ ବୁମ୍,” ଇଞ୍ଜ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“ଇଦ୍ ବିଷୟ୍ ଗୀତ ସଂହିତାତାଗ୍ ଲେକା ଆସ୍‍ମିନ୍ଦେ, ଅନାଦ୍‌ ଲନ୍ ଜନଶୁନ୍ୟ ଆୟି ଆଗେ ବେନ ମାନ୍‍ମାକିଣ୍ଡ୍ ମେଣ୍ଡେ ଲେକ୍‍ତାଦ୍ ମିନ୍ଦେ ମେଣ୍ଡେଅର୍‍ତୁଣ୍ଡ୍ ଅନ୍‌ ପଡ଼୍‍ୟେତାଗ୍ ମାନିଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ଆଦିଙ୍କ୍ ପ୍ରବୁ ଜିସୁନ୍‍ ପୁନରୁତ୍‍ତାନ୍‍ତେ ସାକ୍ଷି ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ମେଣ୍ଡେଅର୍‍ତୁଣ୍ଡ୍ ମା ତଡ଼୍ କାୟ୍‍ଲାନ୍ ଦର୍‍କାର୍ । ");
INSERT INTO kff_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ଜିସୁ ଯୋହନ୍‌ ତାଗାଙ୍କ୍ ଏର୍‍ଦିକ୍ୟା ଗ୍ରହନ୍‍ ମାଡ଼୍‍ତେ ସମୟ୍‍ତାଗାଙ୍କ୍ ସ୍ୱର୍ଗତାଗ୍ ପୁନରୁତାନ୍ ଆଦାନ୍ ଯାକ ସାରେଦାମ୍ ପ୍ରବୁ ଜିସୁ ମା ତଡ଼୍ ଆଦାୱାଦା ମାଡ଼ାନ୍ ୱେଲେ, ବେନ୍ ନାରୁଡ଼୍ ମାନ୍‍ ଦଲ୍‍ତାଗ୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ଅର୍‍ତୁଙ୍କ୍ ସାକ୍ଷି ମାଡ଼ାଙ୍କ୍ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼ାଦ୍ ପେଦେର୍ ହେଞ୍ଚ୍‍ତଡ଼୍; ଯୋଷେଫ୍ ବେନଙ୍କ୍ ବର୍ଶବା ବା ଯୁସ୍ତସ ଇଞ୍ଜ କେତିତଡ଼୍‍ ନୁ ମଥୀୟସ୍; ");
INSERT INTO kff_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ମେଣ୍ଡେ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଡ଼୍, “ପ୍ରବୁ ନିମ୍‍ ସାରେତଡ଼ାଦ୍ ହୃଦୟ୍‍ ପୁତ୍‍ତି । ଇଡ଼୍‍ ଇର୍‍ୱୁଡ଼୍‍ ଲୋପେଙ୍କ୍‍ ନି ତଡ଼୍ ବେନ ମନନିତ ମାକିଙ୍କ୍ କେଲ୍ ।‍ ଅନ୍‌ ପାଡ଼ିୟିତାଗ୍ ନି ତଡ଼୍ ଏଞ୍ଚିମାନ୍ଦାନ୍ ଇଡ଼୍‍ ଇର୍‍ୱୁଡ଼୍ ଲୋପେକ୍ ବେନ ");
INSERT INTO kff_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଇଣ୍ଡ୍‍ ନାରୁଣ୍ଡ୍‍ ଯିହୁଦାନ୍‍ ପଡ଼୍‍ୟେତାଗ୍ ପ୍ରେରତ ଶିଷ୍ୟନ୍ ପାଡ଼୍‍ୟି ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ତାନ୍‍ପେର୍କେ ଇର୍‍ୱୁଡ଼୍ ଲୋପେକ୍ ଅର୍‍ତୁଙ୍କ୍ ହେଞ୍ଚାନ୍ ସେଙ୍ଗେ ଗୁଲିବାଣ୍ଟ ଆତ୍‍ତେ । ଗୁଲିବାଣ୍ଟତାଗ୍ ମଥୀୟସ୍ ମନନିତ ଆସ୍ ଏଗାର୍ ଜାନ୍‍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଦଲ୍‍ତାଗ୍ କାୟ୍‍ଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ପେଣ୍ଟିକଷ୍ଟ୍ ପାଣ୍ଡୁମ୍‍ ଦିନ୍ ସାରେ କ୍ରିଷ୍ଟ ବିଶ୍ୱାସୀଡ଼୍ ୱେରଡ଼୍ ପଡ଼୍‍ୟେତାଗ୍ ଗୁଡ଼ିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ହଟାତ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଗାଟି ୱାଦାନ୍ ବେଡ଼୍‍ୟାଦ୍‍ ଗାଲ୍ ଲେଙ୍ଗ୍‍ ଲେକାମ୍ ୱେରଡ଼୍ ଲେଙ୍ଗ୍‍ ୱାତ୍‍ତେ ନୁ ଅଡ଼୍‌ ବେନ୍ ଲୋନ୍‌ କୁଦିମାତ୍‍ତଡ଼୍, ଆଦ୍ ଲୋନ୍‌ ସାରେ ଆଦ୍ ଲେଙ୍ଗ୍‍ତେ ବର୍ତ୍ତି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଉଡ଼୍‍ତଡ଼୍, ବେସ୍‌କ୍ କିସ୍ ୱାଞ୍ଜେର୍ ଲାଟିଆସ୍ ଆଗେ ମାନ୍ଦାନ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଇଟ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ସାରେତଡ଼୍ ପବିତ୍ର ଆତ୍ମାତେ ବର୍ତ୍ତି ଆଦ୍‍ତଡ଼୍ ନୁ ଆତ୍‍ମା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେଦ୍‍ପୁଟୁଙ୍କ୍ କେତାଙ୍କ୍ ଶକ୍ତି ହିତ୍‍ତେ, ଆଦ୍ ରକମ୍ ଅଡ଼୍‌ ବେନ୍‍ବେନା ଗଟ୍‍ତଡ଼୍ ତିରିୟାଙ୍କ୍ ପସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ପୃତିବିତେ ୱେର୍‍ୱେର୍‍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ୱାସ୍‍ମାନ୍ଦାନ୍ ଇହୁଦୀ ବକ୍ତାଲଡ଼୍‍ ଆସୁଟେ ଯିରୁଶାଲେମ୍‍ ଦେଶ୍‍ତାଗ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ବେସୁଟ୍‌ ଅଡ଼୍‌ ଇଦ୍ ଲେଙ୍ଗ୍‍ କେଞ୍ଜ୍‍ତଡ଼୍, ନାର୍‍ଗେ ନାରୁଡ଼୍ ଆଗେ ଗୁଡ଼୍‍ତଡ଼୍ । ବିଶ୍ୱାସୀ ନାରୁଡ଼୍ ଆଗେ ମାନ୍ଦାନ୍ ସାରେତଡ଼୍‍ୱାଦ୍ ବାଷାତ୍‍ ଗଟ୍ କେତାନାଦ୍ କେଞ୍ଜି ଅଡ଼୍‌ ସାରେତଡ଼୍ କାବା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","କାବା ଆସ୍ ନୁ ଦାଦ୍‍ରେଲି ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ଇଦ୍ ରକମ୍ ଗଟ୍ ତିରିୟାନଡ଼୍ ଇଡ଼୍ ବାତେଏ ଗାଲିଲୀୟ ଆୟ୍‍ୟଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ଆଲେକେ ମାମ୍‍ମେ ସାରେତମ୍ ବେଲା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମା ନିଜର୍‍ ନିଜର୍‍ ଜନମ୍‍ ଆତ୍‍ତେ ଗଟ୍ କେତାନାଦ୍ କେଞ୍ଜୁତମ୍ ? ");
INSERT INTO kff_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ମାନାଡ଼୍ ପାର୍ତୀୟ, ମାଦୀୟ ନୁ ଏଲାମୀୟ, ମେଣ୍ଡେ ମେସପଟାମିୟା, ଯିହୁଦା ଦେଶ୍ ନୁ କାପ୍‍ପାକିଆ, ପନ୍ତ ନୁ ଏସିୟା, ");
INSERT INTO kff_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ଫ୍ରୁଗିୟା ନୁ ପଂଫୁଲିୟା, ମିସର୍ ନୁ କୁରିନୀ ଗାରେତ୍ ଲିବିୟା ଜାଗେତ୍‍ ନାରୁଡ଼୍ ମେଣ୍ଡେ ରୋମ୍‍ତାଗାଙ୍କ୍ ୱାତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଇହୁଦୀ ନୁ ଇହୁଦୀ ଦର୍ମ ଗ୍ରହନ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ଅବିଶ୍ୱାସୀ ନାରୁଡ଼୍, ମେଣ୍ଡେ ମା ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କ୍ରୀତୀୟ ନୁ ଆରବୀୟ ନାରୁଡ଼୍ । ମିକା ଇଶ୍ୱର୍ ବେନ୍ ମହତ୍‍ ବିଷୟ୍ ସାରେ ମାଡ଼୍‍ତଣ୍ଡ୍, ଆୱୁସାରେ ମାମ୍‍ମେ ସାରେତମ୍ ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ ମା ନିଜେତ୍ ନିଜେତ୍ ଗଟ୍‍ତେ କେଞ୍ଜୁତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","କାବା ନୁ ଦାନ୍ଦେ ଆସ୍ ଅଡ଼୍‌ ତାମ୍‍ତାମ୍ ଲୋପେ ପାଚ୍ରା ମାଡ଼୍‍ତଡ଼୍, “ଇଦିନ୍ ଅର୍ତ ବାଆତେ ?” ");
INSERT INTO kff_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ଇତ୍‍କେ ବାଗାତ୍ ନାରୁଡ଼୍ ବିଶ୍ୱାସିଡ଼୍‍କ୍ ପରିହାସ୍ ମାଡ଼ି କେତ୍‍ତଡ଼୍, “ଇହି ନାରୁଡ଼୍ ମାତ୍‍ୱାରିଡ଼୍‍ ଆତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ତାନ୍‍ପେର୍କେ ବାଗାତ୍ ଏଗାର୍ ଜାନ୍‍ ପ୍ରେରତ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ପିତର୍ ନିଶ୍‍ମିକା ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଣ୍ଡ୍, ହୋ ଇହୁଦୀ ଦାଦାଲଡ଼ି ନୁ ଏଲାସ୍କିନଡ଼ି ମେଣ୍ଡେ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ବାଦ୍‍କାନ୍ ନାରୁଡ଼୍, ନା ଗଟି କେଞ୍ଜାଟ୍, ନାନ୍ ଇଦିନ୍ ଅର୍ତ ବୁଜାମାଡ଼ି କେତିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ମିଡ଼୍ ବେଲା ହେର୍କା ମାଡ଼ୁତିଡ଼୍, ଇଡ଼୍‍ ଆଦ୍‍ରକମ୍‍ ମାତାଲ୍‍ ଆୟ୍‍ୟଡ଼୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଦିନାମ୍ ଇଞ୍ଜେ ନାର୍କକ୍‍ ନଅ ଗାଣ୍ଟା ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ଇତ୍‍କେ ଯୋୟେଲ୍ ବାବବାଦୀ ବେନ୍ ଗଟ୍‍ନା ବିଷୟ୍ କେତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ଆଦ୍ ଗଟ୍‍ନା, ");
INSERT INTO kff_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ଇଶ୍ୱର୍ କେତିତଣ୍ଡ୍, ‘ତେରାନ୍‍ ଦିନାତେ ଇୱୁ ସାରେ ଗଟେମ୍ ଆଦ୍‍ତେ, ନାନ୍‍ନେ ସାରେତଡ଼ାଗ୍ ନାୱାଦ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍‍ ଆତ୍ମା ବର୍ତ୍ତି ମାଡ଼ିତାନ୍ । ମିଇ ମାର୍‍କ୍ ନୁ ମାୟାସ୍କ୍ ନାୱାଦ୍‍ ସୁସମାଚାର୍‍ କେତିତା । ମିୱଡ଼୍ ଲେୟଡ଼୍ ଦିବ୍ୟ ଦର୍ଶନ୍ ଦର୍‍କିତ୍ ନୁ ବୟସ୍କା ନାରୁଡ଼୍ ସାପ୍ନା ଉଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ଆ, ନା’ ଦାସ ନୁ ଦାସୀଡ଼୍ ଲୋପେ ନାନ୍ ନାୱାଦ୍ ଆତ୍ମା ହସ୍ପିତାନ୍, ଅଡ଼୍‌ ନାୱାଦ୍ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ନାନ୍ ସ୍ୱର୍ଗତାଗ୍ ନାର୍‍ଗେ ଆଦ୍‍ବୁତ୍‌ ପାଡ଼୍‍ୟି; ମେଣ୍ଡେ ପୃତିବିତାଗ୍ ନାର୍‍ଗେ ଚିଏନ୍ନେ ତଅତିତାନ୍ । ଆଗେ ନେତୁର୍‍, କିସ୍ ନୁ ଗାଟି ଉମ୍‍ମେ ବର୍ତ୍ତି ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ପ୍ରବୁନାଦ୍ ମହାନ୍ ନୁ ଗୌରବ୍ ଦିନାମ୍ ଏୱୁଦାନ୍ ମୁନେଙ୍କ୍ ପଡ଼୍‍ଦ୍ ଇକାଡ଼୍‍ ତଅନ୍‌ଦିତ୍‍ ନୁ ନେଲ୍‍ଞ୍ଜ୍ ନେତୁର୍‍ ଲେକାମ୍ ଏର୍‍ରେ ରଙ୍ଗ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଆସୁଟେ ବେନଆଇ ପ୍ରବୁନ୍ ପେଦେର୍‍ତେ ପ୍ରାର୍ତନା ମାଡ଼ିତନ୍, ଅଣ୍ଡ୍‌ ପରିତ୍ରାଣ୍ ପାଏମ୍‍ ଆଦ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ହୋ ଇସ୍ରାଏଲୀୟ ନାରୁଡ଼ି, ଇୱୁ ସାରେ ଗଟି କେଞ୍ଜାଟ୍, ନାଜରିତିୟ ଜିସୁ ନାର୍‍ଗେ ଶକ୍ତିତ୍‍ ପାଡ଼୍‍ୟି, ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ନୁ ଚିଏନ୍ନେ ତଡ଼୍ ମିଇ ଗାର୍‍ରେ ଇଶ୍ୱର୍ ରଅତେ ନାରୁଣ୍ଡ୍‍ ଇଞ୍ଜ ପ୍ରମାନିତ୍ ଆତ୍‍ତଣ୍ଡ୍, ଅନ୍‌ ତଡ଼୍ ଇଶ୍ୱର୍ ଜେ ମିଇ ଲୋପେ ଇୱୁସାରେ ପାଡ଼୍‍ୟି ମାଡ଼ିମିନ୍ଦେଣ୍ଡ୍, ଇଦ୍ ମିଡ଼୍ ନିଜେ ନିଜେ ପୁତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ଇଶ୍ୱର୍ ଅନାଦ୍‌ ଜୋଜନା ଲେକାମ୍‌ ଜିସୁଙ୍କ୍ ମିଇ କାୟ୍‍ତାଗ୍ ପସ୍‍ପିଦାନଙ୍କ୍ ଟିକ୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ପାପି ନାରୁଡ଼୍‍ ତଡ଼୍‍ କ୍ରୁଶତାଗ୍ ତାର୍‍ସ୍ପି ହାୱ୍‍କି ମାତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତାଗାଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ି ପୁନର୍‍ଜିବିତ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଜେ ଡଲିମାତ୍‍ତଣ୍ଡ୍ ଆଦ୍ ସମ୍ଭବ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଦାଉଦ୍ ଅନ୍‌ ବିଷୟ୍‍ତେ କେତୁତଣ୍ଡ୍, ‘ନାନ୍ ସାରେଦାମ୍ ପ୍ରବୁଙ୍କ୍ ନା’ ମୁନ୍‍ନେ ଉଡ଼୍‍ତାନ୍, ବାତେଙ୍କ୍ ଇତ୍କେ ନାନ୍‍ନେ ବେଲା ଦାନ୍ଦେ ଆୟନ୍, ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ନା ତିନ୍ଦେପାକ୍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ଆଦିଙ୍କ୍ ନା ହୃଦୟ୍ କୁସ୍ ଆତ୍‍ତେ ନୁ ନା ମକତାଗାଙ୍କ୍ ୱେଡ଼୍‍କେତ୍‍ ଗଟି ପେୟ୍‍ତା । ମେଣ୍ଡେ ନାୱାଦ୍ ମେନ୍ଦୁଲ୍‍ ଡଲାନାଦ୍‍ ଆତ୍‍କେ ମିକା ନିଜାମ୍‍ ଆଶେ ମାଡ଼ି ବଞ୍ଚେମ୍‍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ବାତେଙ୍କ୍ ଇତ୍‍କେ ନିମ୍‍ ନାକିଂଙ୍କ୍ ଡଲ୍‍ତଡ଼ାଦ୍‍ ଜଗତ୍‍ ୱିଡ଼୍‍ସ୍‍ୱିନ୍‍, ନିମ୍‍ ନି ବିଶ୍ୱସ୍ତ ସେବକିଙ୍କ୍ ପାତାଲ୍‍ ଲୋପେ ନଷ୍ଟ ଆଦାଙ୍କ୍ ହିୱିନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ନିମ୍‍ ନାକିଂଙ୍କ୍ ଜିୱୁଣ୍ଡ୍ ଆର୍ ତହଃସ୍‍ ମିନ୍ଦେନି ନୁ ନିୱାଦ୍‍ ଉପସ୍ଥିତି ନାକିଂଙ୍କ୍ ୱେଡ଼୍‍କ୍‍ ମାଡ଼ିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ଆ ଇସ୍ରାଏଲୀୟ ଦାଦାଲଡ଼୍‍ ନୁ ଏଲାସ୍କିଡ଼୍‍, ବୁଜାମାଡ଼ି ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ ମା ଆନିଦାଦିଡ଼୍ ବଂଶତଣ୍ଡ୍ ଦାଉଦ୍ ରାଜାନ୍ ବିଷୟ୍‍ତେ ସୁଦୁଟ୍ କେତ୍‍ତେ ପାର୍‍ଦ୍‍ତାନ୍ କି । ଅଣ୍ଡ୍‌ ଡଲ୍‍ତଣ୍ଡ୍ ନୁ ସମାଦି ପାଏମ୍‍ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ତାମାଦ୍ ସମାଦି ନେଣ୍ଡ୍ ଯାକ ଇଗେ ମାନ୍‍ଲୋପେ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ବାବବାଦୀ ମାତ୍‍ତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ପ୍ରାମାଣ୍‍ ମାଡ଼୍‍ତାଦ୍ ଅଣ୍ଡ୍‌ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ଦାଉଦ୍ ବଂଶତଡ଼୍‍ ଲୋପେଙ୍କ୍ ଅର୍‍ତୁଙ୍କ୍ ରାଜାଲ୍ ସିଂହାସନ୍‍ ମାଡ଼ିତନ୍ ଇଞ୍ଜ ଇଶ୍ୱର୍ ପ୍ରାମାଣ୍‍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ଇଶ୍ୱର୍ ବବିଷ୍ୟତ୍‍ତେ ବାଆତେ ମାଡ଼ାଙ୍କ୍ ଆଦୁତନ୍, ଦାଉଦ୍ ଆଦ୍ ପୁଞ୍ଜ୍, ମସୀହନ୍ ପୁନରୁତାନ୍ ବିଷୟ୍‍ତେ କେତ୍‍ତଣ୍ଡ୍; ‘ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତଡ଼ାଦ୍ ଜଗତ୍‍ତାଗ୍ ୱିଡ଼୍‍ସିୱଡ଼୍‍ । ଅନାଦ୍‌ ମେନ୍ଦୁଲ୍‍ ପାତାଲ୍‍ ଲୋପେ ନଷ୍ଟ ଆୟ୍‍ୟ ।’ ");
INSERT INTO kff_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ଇଶ୍ୱର୍ ଜିସୁଙ୍କ୍ ଡଲ୍‌ତାଗାଙ୍କ୍ ପୁନରୁତ୍‍ତାନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ମାନାଡ଼୍ ସାରେତଡ଼୍ ଇଦିନାଦ୍ ସାକ୍ଷି ଆତ୍‍ତାଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ଜିସୁ ତାମ୍ ବାବାନ୍ ତିନ୍ଦେପାକ୍ ତେଦିମିନ୍ଦେଣ୍ଡ୍ ନୁ ବାବାନ୍ ପ୍ରତିଜ୍ଞା ଲେକାମ୍ ଅନାଗାଙ୍କ୍ ପବିତ୍ର ଆତ୍‍ମା ପାଏମ୍‍ଆତ୍‍ତଣ୍ଡ୍ । ଇଞ୍ଜେ ମିଡ଼୍ ବାଆତେ ଉଡ଼ୁତିଡ଼୍ ନୁ କେଞ୍ଜୁତିଡ଼୍, ଆଦ୍ ଇଶ୍ୱର୍‌ତାଦ୍‍ ଦାନ । ଆଦ୍ ଅଣ୍ଡ୍‌ ମା ପର୍‍ର ତସିସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଦାଉଦ୍ ନିଜେ ସ୍ୱର୍ଗତାଗ୍ ଆନଣ୍ଡ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ‘ପ୍ରବୁ ନା ପ୍ରବୁଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ନାନ୍ ନି ଶତ୍ରୁଡ଼୍‍କ୍ ନିୱାଦ୍ କୁତୁଲ୍‍ ଡେକେତ୍ ମଦଲ୍‍ ମାଡ଼୍‍ୱେ ଯାକ, ନା ତିନ୍ଦେପାକ୍ କୁଦିମାନ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ହଁ ଇସ୍ରାଏଲ୍‍ଡ଼ି, ସାରେତଡ଼୍ ନିଶ୍ଚୟ୍‍ ପୁନୁଟ୍ ଯେ, ବେନ୍ ଜିସୁଙ୍କ୍ ମିଡ଼୍ କ୍ରୁଶତାଗ୍ ଆୱକ୍‍ତିଡ଼୍‍, ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ପ୍ରବୁ ନୁ ମସୀହ ରେଣ୍ଡ୍ ପେଦେର୍‍ ଇତ୍‌ତଣ୍ଡ୍‌ !” ");
INSERT INTO kff_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ବେସୁଟ୍‌ ନାରୁଡ଼୍ ଇଦ୍ କେଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଗାଟି ହୃଦୟତେ ଦାନ୍ଦେ ଆତ୍‍ତଡ଼୍ ନୁ ପିତର୍ ନୁ ବାଗାତ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ କେତ୍‍ତଡ଼୍, “ଦାଦାଲଡ଼୍‍ ମାନାଡ଼୍ ବାଆତେ ମାଡ଼ିକାଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ପିତର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ହେର୍କା ମାଡ଼ି ସାରେତଡ଼ି ପାପ୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ମୁଟ୍ ନୁ ପାପ୍ କେମା ସେଙ୍ଗେ ଜିସୁ କ୍ରିଷ୍ଟନ୍ ପେଦେର୍‍ତେ ଏର୍‍ଦିକ୍ଷା ଆୟ୍‍ମୁଟ୍; ଆଲେକେ ମିଡ଼୍ ଇଶ୍ୱର୍‌ତେ ଉପହାର୍, ପବିତ୍ର ଆତ୍ମା ପାଏମ୍‍ଆଦ୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ବାତେଙ୍କ୍ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ ପ୍ରତିଜ୍ଞା ମିଇ ସେଙ୍ଗେ, ମିଇ ପିଲାନ୍ ସେଙ୍ଗେ ନୁ ଜେକେ ମାନ୍ଦାନଡ଼୍ ବେନଡ଼୍‍କ୍ ପ୍ରବୁ ଇଶ୍ୱର୍ କାର୍‍ଙ୍ଗ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌ ସାରେତଡ଼୍ ସେଙ୍ଗେ ମାଡ଼୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ପିତର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ାନାଦ୍‍ ନୁ ନାର୍‍ଗେ ଲେକାତ୍ ସାକ୍ଷ୍ୟ ଇସ୍‌ କେତ୍‍ତାନ୍, “ଇ କାରାପ୍ ନାରୁଡ଼୍ ସେଙ୍ଗେ ୱାସମିନ୍ଦେନ୍ ଶାସ୍ତିତାଗାଙ୍କ୍ ନିଜେ ନିଜେତିଙ୍କ୍ ରକ୍ଷା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅନ୍‌ ଗଟ୍‍ତେ ବିଶ୍ୱାସ୍ ମାଡ଼ି ଏର୍‍ଦିକ୍ଷା ହତ୍‍ତଡ଼୍ । ଆଦ୍‍ନାଣ୍ଡ୍ ମାତର୍ ମୁଣ୍ଡ୍ ହଜାର୍‌ ନାରୁଡ଼୍ ଶିଷ୍ୟଡ଼୍ ଦଲ୍‍ତାଗ୍ କାୟ୍‍ଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ଅଡ଼୍‌ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼ାଦ୍ ଶିକ୍ଷାତାଗ୍, ସହବାଗିତାଗ୍, ରୂଟି ଉହୁତାନାଗ୍ ନୁ ପ୍ରାର୍ତନା ମାଡ଼ାନାଗ୍ ଅଣ୍ଡୟ୍‌‍ମନ୍‍ ଆସ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ନାର୍‍ଗେ ଆଦ୍‍ବୁତ୍‌ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼ିୟି ମାଡ଼୍‍ତଡ଼୍ ନୁ ସାରେତଡ଼୍ ଆଗାଙ୍କ୍ କାବା ଆସ୍ ୱେର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ବିଶ୍ୱାସୀଡ଼୍‍ ସାରେତଡ଼୍ ତଡ଼୍ ସାଙ୍ଗ ଆତ୍‍ତଡ଼୍ ନୁ ଅଣ୍ଡୟାଗେ କାୟ୍‍ଲି ଅଡ଼ାଦ୍‌ ସାରେ ସମ୍ପତିତିଙ୍କ୍ ତୁହୁସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ଅଡ଼୍‌ ନିଜେ ନିଜେତ୍ ସମ୍ପତିତିଙ୍କ୍ ୱାମି, ପାଏମ୍‍ଆତ୍‍ତେ ଡାବ୍‍କିଙ୍କ୍ ସାରେତଡ଼ାଦ୍ ଦର୍‍କାଡ଼୍ ଲେକାମ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ତୁହୁସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ଅଡ଼୍‌ ସାରେଦିନେ ଉପବାସ୍ ମନ୍ଦିର୍‍ତାଗ୍ ୱେରଡ଼୍ ଦଲ୍‍ ଆସ୍ ଗୁଡ଼ମାତ୍‍ତଡ଼୍ ନୁ ୱେଡ଼୍‍କେତେ ନୁ ସରଲ୍‍ ହୃଦୟତେ, ");
INSERT INTO kff_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ଅନୁଗ୍ରହ ପାଏମ୍‍ଆତ୍‍ତେ ନାରୁଡ଼୍‍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼ି ଲକ୍ ଲକ୍ ରୂଟି ଉହୁସ୍ ତିଞ୍ଜମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ସାରେତଡ଼୍ ବିଶ୍ୱାସୀ ଆଦ୍‍ତଡ଼୍ ନୁ ନିତ୍‍ଦିନ୍ ପରିତ୍ରାଣ୍ ପାଏମ୍‍ଆତ୍‍ତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପ୍ରବୁ ଅଡ଼ାଦ୍‌ ଦଲ୍‍ତାଗ୍ କାଲ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ଅଣ୍ଡୟ୍‌‍ଦିନ୍ ପିତର୍ ନୁ ଯୋହନ୍‌ ପ୍ରାର୍ତନା ସମୟ୍‍ତେ ପାୟାଲ୍ ମୁଣ୍ଡ୍ ଗାଣ୍ଟାତ୍‍ ୱେଲେ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ମନ୍ଦିର୍‍ତାଗ୍ ଆଞ୍ଜମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ଆସୁଟେ ଆଗେ “ସୁନ୍ଦର୍,” ପେଦେର୍‍ତାଦ୍ ମାର୍‍ତାଗ୍ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଜନମ୍ କନ୍‍ସ୍ କୁଟାଲ୍ । ମନ୍ଦିର୍‍ତାଗ୍ ଆଞ୍ଜମାନ୍ଦାନ୍ ନାରୁଡ଼ାଗାଙ୍କ୍ ବିକ୍ୟା ତାଲ୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ସାରେଦିନ୍ ଅଣ୍ଡ୍‌ ମାର୍ ଗାର୍‍ରେ କାଞ୍ଜୀ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ପିତର୍ ନୁ ଯୋହନ୍‌‌ତିଙ୍କ୍ ମନ୍ଦିର୍‍ ଲୋପେ ଆଦାନାଦ୍ ଉଡ଼ି, ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ଅଡ଼୍‌ ଯୋହନ୍‌‌ତିଙ୍କ୍ ଅଣ୍ଡୟ୍‌‍ କଣ୍ଡେତେ ଉଡ଼୍‍ତଡ଼୍ ନୁ ପିତର୍ କେତ୍‍ତଣ୍ଡ୍, “ମାୟାକ୍ ଉଡ଼େ !” ");
INSERT INTO kff_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ଆସୁଟେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ ବାତେଆୟି ପାହେମ୍ ଆତ୍‍ତାଙ୍କ୍ ଆଶେମାଡ଼ି ଅଡ଼ାକ୍ ଉଡ଼ି ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ଇତ୍‍କେ ପିତର୍ କେତ୍‍ତଣ୍ଡ୍, “ନାୟାଗ୍ ସୁନା ଡାବ୍‍କ୍ ଇଲା, ମାତ୍ରମ୍‍ ବାଆତେ ମିନ୍ଦେ, ନାନ୍ ନିକିଂଙ୍କ୍ ଇଦୁତାନ୍; ନାଜରିତିୟ ଜିସୁ କ୍ରିଷ୍ଟନ୍‍ ପେଦେର୍‍ତେ ନାନ୍ ନିକିଂଙ୍କ୍ ଗଟ୍ ଇଦୁତାନ୍ ତେଦ୍‍ଦେ ନୁ ତାଆକେ !” ");
INSERT INTO kff_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଅନାଦ୍‌ ତିନ୍ଦେ କାଇଦିଙ୍କ୍ ପଇସ୍‍ ତେହେତ୍‍ତଣ୍ଡ୍ । ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅନ୍‌ ଡେକା ନୁ ଡେକ୍‍ଗାଟି ଶକ୍ତି ଆତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ତୁଲି ତେଦ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ତାଆକାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ତାଆକି ତାଆକି, ତୁଲି ତୁଲି ମେଣ୍ଡେ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼ି ମାଡ଼ି ଅଡ଼୍‌ ତଡ଼୍ ମନ୍ଦିର୍‍ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ଆଗେତ୍‍ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଅଂକିଙ୍କ୍‌ ତାଆକାନାଦ୍ ନୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼ାନାଦ୍ ଉଡ଼୍‍ତଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ଅଂକିଙ୍କ୍‌ ମନ୍ଦିର୍‍ତେ ସୁନ୍ଦର୍ ମାର୍‍ ଗାର୍‍ରେ କୁଦିମାନ୍ଦାନ୍ ବିକାରୀ ଇଞ୍ଜ ପୁତ୍‍ତଡ଼୍ ନୁ ଅନ୍‌ ସେଙ୍ଗେ ବାଆତେ ଗଟେମ୍ ଆତ୍‍ତେ, ସାରେ ଉଡ଼ି ଅଡ଼୍‌ ବାକ୍‍ୱା ନୁ କାବା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ଆ ନାରୁଣ୍ଡ୍‍ ପିତର୍ ନୁ ଯୋହନ୍‌‌ତିଙ୍କ୍ ପୟିସ୍‍ମାନ୍ଦାନ୍ ୱେଲେ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଶଲୋମନ୍‍ତେ ମଣ୍ଡପ୍‍ତାଗ୍ ଉଡ଼ି କାବା ଆସ୍‍ ଅଡ଼୍‌ ଗାର୍‍ରେ ମିରି ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତର୍ ଆଦ୍ ଉଡ଼ି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, ହୋ ଇସ୍ରାଏଲୀୟ ନାରୁଡ଼ି, ବାତେଙ୍କ୍ ମିଡ଼୍ କାବା ଆଦୁତିଡ଼୍ ନୁ ମାକିଂଙ୍କ୍ ୱେରଡ଼୍ କଣ୍ଡେତେ ଉଡ଼ୁତିଡ଼୍ ? ମିଡ଼୍‍ ବାତ୍‍ ଆଲ୍‍ସୁତିଡ଼୍‍ ମାମ୍‍ ମାୱାଦ୍‍ ନିଜର୍‍ ବକ୍ତି ନୁ ଶକ୍ତି ତଡ଼୍ ଇଣ୍ଡ୍‍ ନାରୁଙ୍କ୍‍ ତାଆକାନ୍‍ ଶକ୍ତି ଇତ୍‍ତମ୍‍ ? ");
INSERT INTO kff_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଅବ୍ରାହାମ୍, ଇସ୍‍ହାକ୍ ନୁ ଯାକୁବ୍‍ତେ ଇଶ୍ୱର୍, ମାନ୍‍ ଆନିଦାଦିଡ଼୍‍ତେ ଇଶ୍ୱର୍, ତାମ୍ ଦାସ ଜିସୁଙ୍କ୍ ସ୍ୱର୍ଗୀୟ ଗୌରବ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଇତ୍‍କେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ପେଦାନ୍ କାଇଦେ ସମର୍‍ପନ୍ ମାଡ଼୍‍ତିଡ଼୍ । ଇଦ୍ ଲେକାମ୍ ପିଲାତ ଅଂକିଙ୍କ୍‌ ମୁକ୍ତି ମାଡ଼ାଙ୍କ୍ ବିଚାର୍ ମାଡ଼ିମାତ୍‍କେ ମିକା, ଅଂକିଙ୍କ୍‌ ପିଲାତନ୍ ମୁନେ ମନା ମାଡ଼୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ପବିତ୍ର ନୁ ଦାର୍ମିକ୍ ନାରୁଣ୍ଡ୍‍, ଇତ୍‍କେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ମନା ମାଡ଼୍‍ତିଡ଼୍ ନୁ ଅନ୍‌ ବଦଲ୍‍ତେ ମିଡ଼୍ ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍‌ ଆୱ୍‌କାନଙ୍କ୍‍ ମୁକ୍ତ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ପୀଲାତଙ୍କ୍ କେତ୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ବେନ ଜିୱୁଣ୍ଡ୍ ହାର୍ ତଅତିତଣ୍ଡ୍, ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ଆୱ୍‍କ୍‌ତିଡ଼୍‍, ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତାଗାଙ୍କ୍ ମେଣ୍ଡେଜିୱେ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ମାମ୍‍ମେ ଅଦୁତମ୍ ଇଦିନାଦ୍ ସାକ୍ଷି । ");
INSERT INTO kff_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଅନ୍‌ ପେଦେର୍‍ତେ ଶକ୍ତି କେ ଇଣ୍ଡ୍ କୁଟାଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତେ । ଆଦ୍ ମିଡ଼୍ ନିଜେ ଉଡ଼ି ନିଜାମ୍ ଇଞ୍ଜ ପୁତ୍‍ତିଡ଼୍, ଆଦ୍ ମାତ୍ରମ୍‍ ଅନ୍‌ ପେଦେର୍‍ତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତାଙ୍କ୍ ସମ୍ଭବ୍ ଆତ୍‍ତେ । ଜିସୁନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଜେ ସୁସ୍ଥ ଆତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ମିଡ଼୍ ଉଡ଼୍‍ତିଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ଆଦିଙ୍କ୍ ଏୟ୍‍ ଇସ୍ରାଏଲୀୟ ଦାଦାଲଡ଼୍‍ ନୁ ଏଲାସ୍କ୍‍, ମିଡ଼୍ ନୁ ମିଇ ନେତାଲଡ଼୍ ଜିସୁନ୍‍ ସେଙ୍ଗେ ବାଆତେ ମାଡ଼୍‍ତିଡ଼୍, ଆଦ୍ ପୁନ୍‍ୱେକଟ ମାତ୍‍ତିଡ଼୍‍, ଇଦ୍ ନାନ୍ ପୁତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ନାର୍‍ଗେ ଦିନାତ୍ ମୁନେଙ୍କ୍ ସାରେ ବାବବାଦୀଡ଼୍‍ ପାୟୁର୍‍ତାଗାଙ୍କ୍ ଇଶ୍ୱର୍ ଗୋଷ୍‍ନା ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍ ଯେ, କ୍ରିଷ୍ଟଙ୍କ୍ ଦୁଃକାମ୍ କଷ୍ଟ ମାଡ଼୍‍ୱେୟ୍‍ତିତ୍‍ । ଇଦ୍ ରକମ୍ ଅଣ୍ଡ୍‌ ଆଦିଙ୍କ୍ ସାରେ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ହେର୍କା ମାଡ଼ି ଇଶ୍ୱର୍‌ତେ ଗାର୍‍ରେ ମାଲ୍‍ସ୍ ୱାଡ଼ାଟ୍ । ଆସୁଟେ ଅଣ୍ଡ୍‌ ମିୟାଦ୍ ପାପ୍ କ୍ଷମା ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ଆଦିଙ୍କ୍ ପ୍ରବୁନାଗାଙ୍କ୍ ମିଡ଼୍ ପବିତ୍ର ଆତ୍ମାନ୍‍ ଶକ୍ତି ପାଏମ୍ ଆଦ୍‍ତିଡ଼୍, ଇଶ୍ୱର୍ ମିଇ ମାୟ୍‍ଦିଙ୍କ୍ ମୁନେନ୍ ଏଞ୍ଚ୍‍ତେ ମସୀହ ଜିସୁଙ୍କ୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ରହତିତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ମୁନେତ୍ କାଲାମ୍‍ତେ ପବିତ୍ର ବାବବାଦୀଡ଼୍‍ ତଡ଼୍ ଇଶ୍ୱର୍‌ତେ ଗଷନା ଲେକାମ୍ ସାରେ ବିଷୟ୍ ପୁନେ ଆଦ୍‍ଦାନ୍ ଯାକ ଅଣ୍ଡ୍‌ ସ୍ୱର୍ଗତାଗ୍‍ ମାନ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ଇଦ୍ ବିଷୟ୍‍ତେ ମଶାଲ୍‌‍ କେତ୍‍ତଣ୍ଡ୍, ‘ପ୍ରବୁ ଇଶ୍ୱର୍ ମିଇ ବକେତ୍ ନା ରକମ୍‍ ୱେରଣ୍ଡ୍ ବାବବାଦୀଙ୍କ୍ ରହତିତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ମିଇ ନିଜେତ୍ ବିଶ୍ୱାସୀ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ । ଦାଦାଲ୍‌ ମିକିଂଙ୍କ୍ ବାତ୍ କେତିତଣ୍ଡ୍, ଆଦ୍ ସାରେ ବିଷୟ୍ ମିଡ଼୍ ପାଲନ୍ ମାଡ଼୍ ୱେୟ୍‍ତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ବେନଆଇ ଆ ବାବବାଦୀନ୍ ବାକ୍ୟ ପାଲନ୍ ମାଡ଼ନ୍, ଅଂକିଙ୍କ୍‌’ ଇଶ୍ୱର୍‌ତେ ନାରୁଡ଼ାଗାଙ୍କ୍ ୱେରେ ମାଡ଼ି ଦଂସ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ଇଞ୍ଜେ ବାତ୍‍ ଗଟେମ୍‍ ଆଦୁତ୍‍ ଆଦ୍‍ ବିଷୟ୍‍ତେ ଶାମୁୟେଲ୍‍ ନୁ ଅଣ୍ଡ୍‌ ପେର୍‍କେ ବେସର୍ ବାବବାଦୀଡ଼୍‍ ଗଟ୍ କେତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ସାରେତଡ଼୍ ମିକା ଇଦ୍ ଜୁଗ୍‍ ବିଷୟ୍‍ତେ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ବାବବାଦୀଡ଼୍‍ ପାୟୁର୍‍ତାଗାଙ୍କ୍ ଇଶ୍ୱର୍ ବେନ୍‍ସାରେ ପ୍ରତିଜ୍ଞା ମାଡ଼୍‍ତଣ୍ଡ୍, ଆଦ୍ ମିଇ ସେଙ୍ଗେ ଟିକ୍, ମେଣ୍ଡେ ଇଶ୍ୱର୍ ମିଇ ଆନିଦାଦିଡ଼୍ ତଡ଼୍ ବେନ୍ ଚୁକ୍ତି ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ମିଡ଼୍ ଆଗେତ୍ ବାଗୀଦାର୍ । ଇଶ୍ୱର୍ ଅବ୍ରାହାମ୍‌ତିଙ୍କ୍‍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ‘ମିଇ ବଂଶତଡ଼୍‍ ତଡ଼୍ ନାନ୍‍ନେ ପୃତିବିତାଗ୍ ସାରେ ନାରୁଡ଼୍‍କିଙ୍କ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ିତାନ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ଆଦିଙ୍କ୍ ଇଶ୍ୱର୍ ପ୍ରତମେ ମିଇ ସେଙ୍ଗେ ତାନ୍ ଦାସଡ଼୍‍କ୍‍ ଡଲ୍‍ତାଗାଙ୍କ୍‍ ତେଏସ୍‍ ରହତଣ୍ଡ୍, ବେଲାକି ଅଣ୍ଡ୍‌ ମିୟାଦ୍ ସାରେ ନାରୁଙ୍କ୍ ନିଜେତ୍ ନିଜେତ୍ କାରାପ୍ ହାର୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ପି ଆର୍ଶିବାଦ୍‍ ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପିତର୍ ନୁ ଯୋହନ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଇଦ୍‍ରକମ୍ ଶିକ୍ଷା ଇଦାନ୍‍ୱେଲେ ମନ୍ଦିର୍‍ତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଜାଜକୀଡ଼୍, ମନ୍ଦିର୍ ପ୍ରହରିଡ଼୍‍ତେ ସେନାପତି ନୁ ସାଦୁକୀଡ଼୍‍ ୱାସ୍ ହେୱୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ଅଡ଼୍‌ ବିଜାର୍‍ ଆତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଜିସୁ ଡଲ୍‍ତାଗାଙ୍କ୍ ପୁନରୁତାନ୍ ଆତ୍‍ତନ୍ ଇଞ୍ଜ ଇର୍‍ୱୁଡ଼୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‌ ଶିକ୍ଷା ହିସମାତ୍‍ତଡ଼୍ ନୁ ଡଲ୍‍ତେନଡ଼୍‍ ମେଣ୍ଡେଅନ୍‌‍ଦାମ୍‍ ଜିୱେ ଆଦ୍‍ତଡ଼୍‍ ଇଞ୍ଜ ପ୍ରାମାନ୍‍ ମାଡ଼ମାତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ ଗିରାପ୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ମେଣ୍ଡନ୍‍ଦିନ୍‍ ଯାକ ଅଡ଼୍‌‍କ୍ ଜେଲ୍‍ତାଗ୍ ନେହେତଡ଼୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଆସୁଟେ ମୁଲ୍‍ପୁଟ୍ ଆସ୍‍ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ଇତ୍‍କେ ଅଡ଼୍‌‍ୱାଦ୍‍ ଶିକ୍ଷା କେଞ୍ଜିମାନ୍ଦାନ୍‍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ଅଡ଼୍‌‍ୱାଦ୍‍ ସଂକ୍ୟା ନାର୍ଗେ ଅସ୍‍ ମାତ୍ରମ୍‍ ପାଞ୍ଚ୍‍ ହଜାର୍‌ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ମେଣ୍ଡନ୍‍ଦିନେ ଯିହୁଦି ନେତାଲଡ଼୍, ବୟସ୍କା ନାରୁଡ଼୍ ନୁ ଦର୍ମଗୁରୁଡ଼୍‍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଅଣ୍ଡୟାଗେ ଗୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ଆଗେ ଅଡ଼୍‌ ବେଡ଼୍‍ୟେ ଜାଜକ୍ ହାନାନ, କାୟାପା, ଯୋହନ୍‌, ଆଲେକ୍‍ଜାଣ୍ଡାର୍ ନୁ ବେଡ଼୍‍ୟେ ଜାଜକ୍‍ ପରିବାର୍‍ତେ ମେଣ୍ଡେବାଗାତଡ଼୍‍କିଙ୍କ୍ କାଇଲ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ଅଡ଼୍‌ ପ୍ରେରତ ଶିଷ୍ୟଡ଼୍‍କ୍ ମୁନେ ତାସ୍ ପ୍ରଶ୍ନ ମାଡ଼୍‍ତଡ଼୍, “ମିଡ଼୍ ଇଦ୍ ସାରେ ବେଲା ମାଡ଼ୁତିଡ଼୍ ? ବେନନ୍ ଶକ୍ତିତେ ନୁ ବେନନ୍ ପେଦେର୍‍ତେ ଇଦ୍ ମାଡ଼ୁତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ଆସୁଟେ ପିତର୍ ପବିତ୍ର ଆତ୍‍ମାତେ ପୁର୍ଣ୍ଣ ଆସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଏୟ୍‍ ନାରୁଡ଼୍‍ତେ ନେତାଲଡ଼୍ ନୁ ବୟସ୍କା ନାରୁଡ଼ି; ");
INSERT INTO kff_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ନେଣ୍ଡ୍ ଯଦି ମାକିଂଙ୍କ୍ ଇ କୁଟାନ୍ ଲେକେତ୍ ଆତ୍‍ତେ ପାଡ଼ିୟି ବିଷୟ୍‍ତେ ପାଚ୍ରାମାଡ଼ିତଡ଼୍‍ ଜେ, ଇଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‌ ବେଲା ଅସ୍ ସୁସ୍ଥ ଆତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ଆଦିଙ୍କ୍ ମିଡ଼୍ ନୁ ଇସ୍ରାଏଲ୍‍ତେ ସାରେତଡ଼୍ ପୁନ୍ଦ୍‍ ୱେୟ୍‍ତିତ୍ ଜେ, ମିଇ ମୁନେ ନିସ୍ ମାନ୍ଦାନ୍ ଇ ନାରୁଣ୍ଡ୍ ମାତ୍ରମ୍‍ ନାଜରିତିୟ ଜିସୁ କ୍ରିଷ୍ଟନ୍ ପେଦେର୍‍ତେ ଶକ୍ତିତଡ଼୍ ସାରେ ସୁସ୍ଥ ଆତ୍‍ତଣ୍ଡ୍ । ବେନଙ୍କ୍ ମିଡ଼୍ କ୍ରୁଶତାଗ୍ ଆୱକ୍‍ତିଡ଼୍‍ ମେଣ୍ଡେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତାଗାଙ୍କ୍ ମେଣ୍ଡନ୍‍ଦାମ୍ ଜିୱୁନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଜିସୁ ଆଦୁତନ୍ ୱେରଣ୍ଡ୍ ବେନଙ୍କ୍ ଦର୍ମଶାସ୍ତ୍ର କେତିତ୍‍, ‘ବେନ୍ କାଲ୍‍ଦିଙ୍କ୍ ଲକ୍ ତିଆର୍‍ମାଡ଼ାନଡ଼୍‍ ପାସ୍କ୍‍ତଡ଼୍‍, ଆଦ୍ କାଲ୍ ସାରେତିଙ୍କ୍ ଲେକେତ୍ ଆତ୍‍ତେ ।’ ");
INSERT INTO kff_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ମାତ୍ରମ୍‍ ଅନ୍‌ ତଡ଼୍ ପରିତ୍ରାନ୍‍ ସମ୍ଭବ୍‍ ଆଦ୍‍ତେ, ବାତେଙ୍କ୍ଇତ୍‍କେ ଇଦ୍ ସ୍ୱର୍ଗତାଗ୍ ମାନ୍ଦାନ୍ ମେଣ୍ଡେଅନ୍‌ ପେଦେର୍‍ତଡ଼୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମୁକ୍ତି ଦର୍‍କ ।” ");
INSERT INTO kff_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ପିତର୍ ନୁ ଯୋହନ୍‌ ଅଶିକିତ୍‍ ନୁ ସାଦାରନ୍‍ ନାରୁଡ଼୍ ମାତ୍‍ତଡ଼୍ ଇଞ୍ଜ ବେଡ଼ିୟ୍‍ମିଟିଙ୍କ୍‍ତେ ସଦସ୍ୟଡ଼୍ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଡ଼୍ । ଆଦିଙ୍କ୍ ଇର୍‍ୱୁଡ଼ାଦ୍ ସାହାସ୍ ଉଡ଼ି ଅଡ଼୍‌ କାବା ଆତ୍‍ତଡ଼୍ ମେଣ୍ଡେ ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍ ଜିସୁନ୍‍ ସାଙ୍ଗ ମାତ୍‍ତଡ଼୍ ଇଞ୍ଜ ଅଡ଼୍‌ ପୁତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ଇତ୍‍କେ ଅଡ଼୍‌ ବିରଦ୍‍ ମାଡ଼ି ବାଆତେ କେତାଙ୍କ୍ ପାର୍‍ୱଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ସୁସ୍ଥ ଆସ୍‍ମାନ୍ଦାନ୍ ନାରୁଙ୍କ୍ ପିତର୍ ନୁ ଯୋହନ୍‌‌ ତଡ଼୍ ନିଶ୍‍ ମାନ୍ଦାନାଦ୍ ଅଡ଼୍‌ ଉଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ଆଦିଙ୍କ୍ ନେତାଲଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମିଟିଙ୍ଗ୍‍ତାଗାଙ୍କ୍ ବାୟିଦେ ପେସ୍‍ପିସ୍‍ ଅଡ଼୍‌ ବିଷୟ୍‍ତେ ତାମ୍‍ତାମ୍‍ ଲୋପେ ତିର୍‍ୟାତିର୍‍ୟି ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ମାମ୍ ଇଡ଼୍‍ ସେଙ୍ଗେ ବାଆତେ ମାଡ଼ିତାଡ଼୍ ? ଯିରୁଶାଲେମ୍‍ତାଗ୍ ସାରେତଡ଼୍ ଇଡ଼୍ ମାଡ଼୍‍ତେ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ବିଷୟ୍‍ତେ ପୁତ୍‍ତଡ଼୍ । ମାମ୍ ଇଦ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ାନଙ୍କ୍ ପାର୍‍ୱମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଦ୍ ଗଟ୍ ବେଲା ନାରୁଡ଼୍ ଲୋପେ ମେଣ୍ଡେ ଅଦିକ୍‌ ପ୍ରଚାର୍ ଆୟ୍‍ମାକି, ଇଦିନ୍‍ ସେଙ୍ଗେ ଜିସୁନ୍‍ ପେଦେର୍‍ତେ ମେଣ୍ଡେ ବେନଡ଼୍‍କିଂଙ୍କ୍ ବାଆତେ କେଲ୍‍ମାକିଡ଼୍ ଇଞ୍ଜ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସତର୍କ ମାଡ଼ିକାଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାର୍‍ଙ୍ଗି ଜିସୁନ୍‍ ପେଦେର୍‍ତେ ମେଣ୍ଡେ ବାଆତେ କେଲ୍‍ମାକିଡ଼୍ ବା ଶିକ୍ଷା ହିମାକିଡ଼୍‍ ଇଞ୍ଜ ଗଟ୍ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ବାତେଙ୍କ୍ଇତ୍‍କେ ପିତର୍ ନୁ ଯୋହନ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉତର୍‍ ହିତ୍‍ତଡ଼୍, “ମିୟାଦ୍ ଗଟ୍ କେଞ୍ଜୀତମ୍ ନା ଇଶ୍ୱର୍‌ତେ ଗଟ୍ କେଞ୍ଜିତମ୍, ବେନ୍ ବିଷୟ୍ ଇଶ୍ୱର୍‌ତେ କଣ୍ଡେତେ ସାୟେ, ଆଦ୍ ମିଡ଼୍ ନିଜେ ନିଜେ ଲୋପେ ବିଚାର୍ ମାଡ଼ାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ବାତେଙ୍କ୍ଇତ୍‍କେ ମାମ୍‍ମେ ବାଆତେ ଉଡ଼୍‍ତମ୍ ନୁ କେଞ୍ଜ୍‍ତମ୍, ଆଦ୍ ବିଷୟ୍ କେଲ୍‍ୱେ ମାନ୍ଦାଙ୍କ୍ ପାର୍‍ୱମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ଇତ୍‍କେ ମହାସବା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡେ ଅଦିକ୍‌ ସତର୍କ ମାଡ଼ି ୱିଡ଼୍‍ସିତ୍‍ତେ । ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦଣ୍ଡ୍ ହିଦାନାଦ୍ ଦର୍‌କାର୍‌ ଆୟ୍‍ୟ ଇଞ୍ଜ ଅଡ଼୍‌ ପୁତ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ବାଆତେ ଗଟେମ୍ ଆତ୍‍ତେ ଆଦିନ୍ ସେଙ୍ଗେ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଦନ୍ୟବାଦ୍ ହିଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ବେନ୍ ନାରୁଣ୍ଡ୍‌ ଇଦ୍ ଆଶର୍ଯ୍ୟ ପାଡ଼ିୟି ତଡ଼୍ ସୁସ୍ଥ ଆତ୍‍ତଣ୍ଡ୍, ଅନାଦ୍‌ ବୟସ୍‍ ଚାଲିଶ୍‍ ହେଣ୍ଡ୍‍କ୍ ପର୍‍ର ଆସ୍‍ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପିତର୍ ନୁ ଜହନ୍‍ ମୁକ୍ତି ଆତ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ତାମ୍ ଦଲ୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆଦ୍‍ତଡ଼୍ ମେଣ୍ଡେ ମୁକ୍ୟ ଜାଜକ୍ ନୁ ବୟସ୍କା ନାରୁଡ଼୍ ବାତେଏ କେସ୍‍ମାତ୍‍ତଡ଼୍, ଆଦ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ବିଶ୍ୱାସିଡ଼୍‍ ସାରେଗଟ୍‍ କେଞ୍ଜ୍‍ତେ ପେର୍‍କେ ସାରେତଡ଼୍ ଅଣ୍ଡୟାଗେ ଆସ୍ ଇଶ୍ୱର୍‌ତେ ଗାର୍‍ରେ ଇଦ୍‍ରକମ୍‍ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଡ଼୍, “ହଁ ପ୍ରବୁ, ନିମ୍‍ ସ୍ୱର୍ଗ, ପୃତିବିତାଗ୍, ସମୁଦ୍ର ନୁ ଆୱୁ ସାରେ ଲୋପେ ମାନ୍ଦାନ୍ ସାରେବିଷୟ୍‍ ତିଆର୍ ମାଡ଼୍‍ତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ପବିତ୍ର ଆତ୍ମା ତଡ଼୍ ନିମ୍‍ ଆନିଦାଦୀ ଦାଉଦ୍, ନିୱଣ୍ଡ୍ ଦାସନ୍‍, ପାୟୁର୍ ଇସ୍‌ ଇଦ୍ ଗଟ୍ କେସ୍‍ମାତ୍‍ତି; ‘ଅଣଇହୁଦୀ ନାରୁଡ଼୍ ବାତେଙ୍କ୍ କାଡ଼ାମ୍ ଆଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ନାରୁଡ଼୍ ବାତେଙ୍କ୍ କାରାପ୍ ଚିନ୍ତେ ମାଡ଼ୁତଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ପ୍ରବୁନ୍ ବିରୁଦ୍‍ତେ ନୁ ତାନ୍ ମସୀହାନ୍‍ ବିରୁଦ୍‍ତେ ପୃତିବିତାଗ୍ ରାଜାଲଡ଼୍‍ ନିଜେତିଙ୍କ୍ ତିଆର୍ ମାଡ଼୍‍ତଡ଼୍ ମେଣ୍ଡେ ଶାସନ୍‍ମାଡ଼ାନଡ଼୍‍ ଅଣ୍ଡୟାଗେ ଆଦ୍‍ତଡ଼୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ନିଜାମ୍ ହେରଦ୍ ନୁ ପନ୍ତୀୟ ପିଲାତ ଇଦ୍ ନାର୍‍ତାଗ୍ ଅଣଇହୁଦୀ ନୁ ଇସ୍ରାଏଲ୍‍ ନାରୁଡ଼୍ ତଡ଼୍ କାଇଲି ମିୱଣ୍ଡ୍ ପବିତ୍ର ଦାସ, ବେନଙ୍କ୍ ମିଡ଼୍ ମସୀହା ଇଞ୍ଜ ଏଞ୍ଚିମିନ୍ଦେଡ଼ି, ଅଣ୍ଡ୍‌‍ ଜିସୁନ୍‍ ବିରୁଦ୍‍ତେ ଷଡ଼ଜନ୍ତ୍ର ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ମିୟାଦ୍ ଶକ୍ତି ନୁ ଇଚ୍ଛା ଲେକାମ୍ ବାଆତେ ଗଟେମ୍ ଆତ୍‍ତେ ଇଞ୍ଜ ମିଡ଼୍ ତିଆର୍ ମାଡ଼ିମାତ୍‍ତିଡ଼୍, ଅଡ଼୍‌ ଅଣ୍ଡୟାଗେ ଆସ୍ ଆୱୁସାରେ ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ପ୍ରବୁ, ଅଡ଼୍‌ ମାକିଂଙ୍କ୍ ବେନ୍ ଦମକ୍ ହିତ୍‍ତଡ଼୍, ନିମ୍ମେ ଆଦ୍ ବିଷୟ୍ ସେଙ୍ଗେ ମନଯୋଗ୍ ମାଡ଼େ ନୁ ସାହାସ୍ ମାଡ଼ି ନିୟାଦ୍ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼ାଙ୍କ୍, ମିୱଡ଼୍‍ ଇ ଦାସଡ଼୍‍କିଂଙ୍କ୍ ସାହାସ୍‍ ହିମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ନିୱଣ୍ଡ୍ ପବିତ୍ର ଦାସ ଜିସୁନ୍‍ ପେଦେର୍‍ତେ ସୁସ୍ଥ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ନୁ ଆଦ୍‍ବୁତ୍‌ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ସାଦନା ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ନିୟାଦ୍ କାୟି ହାଆମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ଅଡ଼୍‌ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ୱେଲେ ବେନ୍ ପଡ଼୍‍ୟେତାଗ୍ ଅଣ୍ଡୟାଗେ ଆସ୍‍ମାତ୍‍ତଡ଼୍, ଆଦ୍ ପଡ଼୍‍ୟି ଲେଙ୍ଗ୍‍ଦେ ବର୍ତ୍ତି ଆତ୍‍ତେ । ମେଣ୍ଡେ ସାରେତଡ଼୍ ପବିତ୍ର ଆତ୍‍ମା ତଡ଼୍ ପୁରା ଆସ୍ ସାହାସ୍ ତଡ଼୍ ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ କେତାଙ୍କ୍ ପସ୍‍ସ୍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ବିଶ୍ୱାସୀଡ଼୍ ୱେରଡ଼୍ ମାନ୍‍ ନୁ ୱେରଡ୍‌ ହୃଦୟ ତେ ମାତ୍‌ତଡ଼୍ । ବେନଡ଼୍ ତାମ୍ ସମ୍ପତିତିଙ୍କ୍ ନିଜେତ୍ ସମ୍ପତି ଇଞ୍ଜ ଦାବୀ ମାଡ଼ଡ଼୍‍, ସାରେତଡ଼୍‍ୱାଦ୍ ସମ୍ପତିତିଙ୍କ୍ ଅଡ଼୍‌ ସାମାନ୍ ତୁହୁସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ବେଡ଼୍‍ୟାଦ୍‍ ଶକ୍ତି ତଡ଼୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ପ୍ରବୁ ଜିସୁନ୍ ପୁନରୁତାନ୍ ବିଷୟ୍‍ତେ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଡ଼୍ ନୁ ଇଶ୍ୱର୍ ଅଡ଼୍‌ ପର୍‍ର ନାର୍‍ଗେ ଅନୁଗ୍ରହ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ଅଡ଼ାଦ୍‌ ମାନ୍ଦେତାଗ୍ ବେନ୍ ନାରୁଣ୍ଡ୍‍ ଅବାବ୍ ଇଲ୍‍ୱେମାତ୍‍ତଣ୍ଡ୍ । ବେନଡ଼ାୱୁ ୱାୟା ନୁ ଲନ୍‍ ମାତ୍‍ତା, ଅଣ୍ଡ୍‌ ଆୱୁସାରେ ୱାମି ଡାବ୍‍କ୍ ତାସ୍, ");
INSERT INTO kff_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ଅଡ଼୍‌ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ ହିସମାତ୍‍ତଡ଼୍ ମେଣ୍ଡେ ଆୱୁ ଡାବ୍‍କ୍ ଅଡ଼୍‌ ଲୋପେ ସାରେତଡ଼୍‍ୱାଦ୍ ଦର୍‍କାର୍ ଲେକାମ୍ ତୁହୁସିସମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ସାଇପ୍ରସ୍‍ ଜାଗେତାଗ୍ ଜନମ୍ ଆସ୍‍ମାନ୍ଦାନ୍ ଲେବୀୟ ବଂଶତଣ୍ଡ୍ ଯୋଷେଫ୍, ବେନଙ୍କ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ବର୍ଣ୍ଣବା ଇଞ୍ଜ ପେଦେର୍ ଇସ୍‌‍ମାତ୍‍ତଡ଼୍, ବର୍ଣ୍ଣବା ଇତ୍‍କେ ସାର୍‍ଦେତ୍‍ ମାର୍‍, ");
INSERT INTO kff_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ଅନାଦ୍‌ ଅଣ୍ଡୟ୍‌ ୱାୟେ ମାତ୍‍ତେ, ଅଣ୍ଡ୍‌ ଆଦ୍ ୱାମିମିକା ଡାବ୍‍କ୍ ତାସ୍ ପ୍ରେରିତଶିଷ୍ୟଡ଼୍‍କ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ହନନୀୟ ପେଦେର୍‍ତେ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ ନୁ ତାନ୍ ମୁତ୍‍ତେ ଶଫୀରା ତାମ୍‍ୱାଦ୍ ବେସ୍‍କେ ୱାୟା ୱାମ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ଇତ୍‍କେ ମୁତେନ୍‍ ରାଜି ଲେକାମ୍ ଅଣ୍ଡ୍‌ ବେସର୍ ଡାବ୍‍କ୍ ତାମ୍‍ ନିଜେତ୍ ସେଙ୍ଗେ ନେହେତଣ୍ଡ୍ ନୁ ମେଣ୍ଡେ ବାଗାତ୍ ସାରେ ଡାବ୍‍କ୍ ତାସ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ପିତର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହନନୀୟ, ନିମ୍‍ ବାତେଙ୍କ୍ ଶୟ୍‍ତାନ୍‍ ହୃଦୟତେ ୱାମିମିକା ଦର୍‍କି ମାନ୍ଦାନ୍ ଡାବ୍‍କ୍ ନିଜେତ୍ ମାଇଦିଙ୍କ୍ ବେସର୍ ନେହେସ୍ ପବିତ୍ର ଆତ୍‍ମାନ୍ ଗାର୍‍ରେ ମିଚ୍‍ କେତ୍‍ତିନ୍ ? ");
INSERT INTO kff_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ୱାମାନ୍‍ ମୁନେଙ୍କ୍ ଆଦ୍ ନିୟାଦ୍ ମାତ୍‍ତେ, ୱାମ୍‍ତେ ପେର୍‍କେ ମିକା ଆଦ୍ ଅଦିକାର୍‌‍ ନିୟାଦ୍ ମାତ୍‍ତେ । ବାତେଙ୍କ୍ ନିମ୍‍ ଇଦ୍ ରକମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ାଙ୍କ୍ ହୃଦୟତାଗ୍‍ ଚିନ୍ତେ ମାଡ଼୍‍ତି ? ନିମ୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମିଚ୍‍ କେଲ୍‍ୱିନ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ନିମ୍‍ ମିଚ୍‍ କେତ୍‍ତିନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ହନନୀୟ ଇଦ୍ ଗଟ୍ କେଞ୍ଜାନ୍‍ ସାଙ୍ଗେ ସାଙ୍ଗେ ନେଲ୍ ଗୁବ୍‍ରାଲି ଡଲ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ବେନଡ଼୍ ଇଦ୍ ଗଟ୍ କେଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌ ସାରେ ଗାଟି ୱେର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ଲେୟଡ଼୍‍ ତେଦିୱାସ୍‍ ଅଂକିଙ୍କ୍‌ ସିଲେତଡ଼୍ ଉତ୍‍ତଡ଼୍ ନୁ ବାୟିଦେ ଆସ୍ ସମାଦି ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ପ୍ରାୟ୍‍ ମୁଣ୍ଡ୍ ଗାଣ୍ଟା ପେର୍‍କେ ତାନ୍ ମୁତ୍‍ତେ ୱାତ୍‍ତେ, ଇତ୍‍କେ ବାଆତେ ଗଟେମ୍ ଆତ୍‍ତେ, ଆଦ୍ ବିଷୟ୍ ପୁନ୍‍ୱେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପିତର୍ ଆଦିଙ୍କ୍ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, “ନାକିଙ୍କ୍‍ କେଲ୍‍ମ୍‍, ନିମ୍‍ ନୁ ନିଇ ମୁଦ୍‍ପାଲ୍ ବେନ୍‍ ୱାୟା ୱାମ୍‍ତିଡ଼୍, ଇଦ୍ ବାଆତେ ଆଦିନାଦ୍ ସାରେ ମୁଲ୍ୟ ?” ଆଦ୍ କେତ୍‍ତେ, “ହଁ, ଆସରେ ।” ");
INSERT INTO kff_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ପିତର୍ ଆଦିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁନ୍ ଆତ୍ମାଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼ାଙ୍କ୍ ନିମ୍‍ ନୁ ନି ମୁଦ୍‍ପାଲ୍‍ ବାତେଙ୍କ୍ ଆଲ୍‍ସ୍‍ତିଡ଼୍ ? ବେନଡ଼୍ ନି ମୁଦ୍‍ପାଙ୍କ୍ ସମାଦି ହିତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଇଞ୍ଜେ ମାର୍‍ ବକେତ୍ ହେୱୁତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ନିକିଂଙ୍କ୍ ମିକା କାଞ୍ଜୀ ବାୟିଦେ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","କେତ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଆଦ୍ ଅନ୍‌ ଡେକେତ୍ ମଦଲ୍ ରାଲି ଡଲ୍‍ତେ । ଲେୟଡ଼୍‍ ଲୋପେ ୱାସ୍ ଆଦିଙ୍କ୍ ଡଲିମାନ୍ଦାନାଦ୍ ଉଡ଼ି କାଞ୍ଜୀ ବାୟିଦେ ଆତ୍‍ତଡ଼୍ । ନୁ ତାନ୍ ମୁଦ୍‍ପାନ୍ ସମାଦି ଗାର୍‍ରେ ତାଙ୍କ୍ ସମାଦି ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ଆଗାଙ୍କ୍ ମଣ୍ଡଲିତେ ସାରେତଡ଼୍ ନାରୁଡ଼୍ ନୁ ବେନଡ଼୍ ଇୱୁ ଗଟି କେଞ୍ଜ୍‍ତଡ଼୍, ସାରେତଡ଼୍ ଗାଟି ୱେର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ନାରୁଡ଼୍ ଲୋପେ ନାର୍‍ଗେ ଆଦ୍‍ବୁତ୍‌ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ଆସମାତ୍‍ତେ । ସାରେତଡ଼୍ ବିଶ୍ୱାସୀଡ଼୍ ଶଲୋମନ୍‍ତେ ମଣ୍ଡପ୍‍ତାଗ୍ ଅଣ୍ଡୟାଗେ ଆସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ଦଲ୍‍ଦେ ବାୟିଦେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିନ୍ ଲୋପେକ୍ ବେନ ଅଡ଼୍‌‍ତଡ଼୍ କାଇଲାନଙ୍କ୍‍ ସାହାସ୍ ମାଡ଼୍‍ୱେମାତ୍‍ତଡ଼୍, ମିକା ନାରୁଡ଼୍ ଅଡ଼ାଦ୍‌ ପ୍ରସଂଶା ମାଡ଼ି କେସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ମେଣ୍ଡେ ନାର୍‍ଗେ ମାନେୟ୍‍ ନୁ ନାଟା ବିଶ୍ୱାସ୍ ମାଡ଼ି ପ୍ରବୁନ୍ ତଡ଼୍ କାଇଲାନ୍‍ ମାଇଦିଙ୍କ୍ ମାନ୍ଦେତାଗ୍ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ପ୍ରେରିତ ଶିଷ୍ୟଡ଼ାଦ୍‍ ପାଡ଼୍‍ୟି ନିତ୍‍ଦିନ୍‍ ନର୍ଗେ ଆତ୍‍ତେ, ପିତର୍ ୱାଦାନ୍‍ୱେଲେ ଅନାଦ୍‌ ନିଡ଼୍‍କେ ବେଲାକି ରୋଗୀଡ଼୍ ଲୋପେଙ୍କ୍ ବେନଡ଼୍‍ ବେନଡ଼୍‍ ପର୍‍ର ରାଲିତ୍‍, ଇଦିନ୍‍ ସେଙ୍ଗେ ନାରୁଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦୁଆତାଗ୍ କାଞ୍ଜୀ ଆସ୍, କେତିନାଗ୍ ନୁ କାଟୁଲ୍‍କିନାଗ୍ ୱାଟିସ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଯିରୁଶାଲେମ୍‍ତେ ସାରେପାକ୍ ଟାୱୁନ୍‍କିନାଗାଙ୍କ୍ ନାରୁଡ଼୍ ମିକା ରୋଗିଡ଼୍‍କ୍ ନୁ ବୁତ୍ ପୟ୍‍ତେନଡ଼୍‍କ୍ ତାସମାତ୍‍ତଡ଼୍‍, ମେଣ୍ଡେ ଅଡ଼୍‌ ସାରେତଡ଼୍ ସୁସ୍ଥ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ତାନ୍‍ପେର୍କେ ମହାଜାଜକ୍ ନୁ ତାମ୍ ସାଙ୍ଗଡ଼୍ ସାରେତଡ଼୍, ମେଣ୍ଡେ ସାଦୁକୀଡ଼୍ ମାନ୍ଦେ, ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ ଗାଟି ଇର୍ଷା ମାଡ଼୍‍ତଡ଼୍, ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ଦଣ୍ଡ୍ ହିଦାନ୍ ମାଇଦିଙ୍କ୍ ତିଆର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ଅଡ଼୍‌ ପ୍ରେରିତଡ଼୍‍କ୍‍ ଗିରାପ୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ଜଇଲ୍‍ଦାଗ୍ ତୁର୍ର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ଇତ୍‍କେ ପ୍ରବୁନାଦ୍ ଅଣ୍ଡୟ୍‌ ଦୂତ୍, ନାର୍‍କେତ୍ ୱେଲେ ଜଇଲ୍‍ତେ ମାର୍‍ ସାରେ ତେର୍‍ସିତ୍‍ତେ ନୁ ପ୍ରେରିତଡ଼୍‍କ୍ ପେସ୍‍ପିଇ ତାସ୍, କେତ୍‍ତେ, ");
INSERT INTO kff_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ଆନୁଟ୍, ମନ୍ଦିର୍‍ତାଗ୍ ନିଶ୍‍ ଇଦ୍ ପୁନାଦ୍ ଜିୱୁଣ୍ଡ୍ ବିଷୟ୍‍ତେ ଗଟି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେଲାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ଇଦ୍ କେଞ୍ଜି ପ୍ରେରିତଡ଼୍ ନାର୍‍କା ମନ୍ଦିର୍‍ତାଗ୍ ହସି ଶିକ୍ଷା ହିଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ଆଗେ ବେଡ଼୍‍ୟେ ଜାଜକ୍ ନୁ ତାମ୍ ସାଙ୍ଗଡ଼୍ ବୟସ୍କା ଇହୁଦୀଡ଼୍‍ ବାଡ଼୍‍ୟେମିଟିଙ୍ଗ୍ ଅର୍ତ ଇସ୍ରାଏଲ୍‍ତେ ସାର୍ରେ ବୟସ୍କା ନାରିଡ଼୍‍ ଗୁଡ଼ି ମିଟିଙ୍ଗ୍‍ ମାଡ଼ାନଙ୍କ୍ କାର୍‍ଙ୍ଗୁତଡ଼୍, ତାନ୍‍ପେର୍କେ ପ୍ରେରିତଡ଼୍‍କିଙ୍କ୍‍ ତାତାନ୍ ସେଙ୍ଗେ ଜଇଲ୍‍ତାଗ୍ କାବୁର୍‍ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ଇତ୍‍କେ କର୍ମଚାରୀଡ଼୍‍ ଆଞ୍ଜ୍ ଜଇଲ୍‍ତାଗ୍ ଅଡ଼୍‌ ଦର୍କୱାଙ୍କ୍ ମାଲ୍‍ସ୍ ୱାସ୍ ବେଡ଼୍‍ୟେସବାତିଙ୍କ୍‍ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ମାମ୍‍ମେ ଜଇଲ୍‍ତାଗ୍ ଏୱୁସ୍‍ ଉଡ଼୍‍ତମ୍, ଜଇଲ୍‍ ସାରେ ବନ୍ଦ୍‍ ମାତ୍‍ତେ, ମେଣ୍ଡେ ମାର୍‍ତାଗ୍ କେପାନଡ଼୍ ନିଶ୍‍ମାତ୍‍ତଡ଼୍, ଇତ୍‍କେ ମାର୍‍ ଟେଣ୍ଡି ଉଡ଼୍‍ତାଙ୍କ୍ ଲୋପେ ବେନ ଇଲାଡ଼୍ !” ");
INSERT INTO kff_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଇୱୁସାରେ ଗଟି କେଞ୍ଜି ମୁକ୍ୟ ଜାଜକ୍ ନୁ ମନ୍ଦିର୍‍ତେ ସେନାପତି, ପ୍ରେରିତଡ଼୍‍ ସେଙ୍ଗେ ବାତେଏ ଗଟେମ୍ ଆଦ୍‍ତେ ଇଞ୍ଜ ହାଲ୍‍ସି କାବା ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ଆସୁଟେ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ ୱାସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍‍, “କେଞ୍ଜାଟ୍ ! ବେନଡ଼୍‍କିଂଙ୍କ୍ ମିଡ଼୍ ଜଇଲ୍‍ତାଗ୍ ୱାଟିମାତ୍‍ତିଡ଼୍ ଅଡ଼୍‌ ମନ୍ଦିର୍‍ତାଗ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶିକ୍ଷା ଇଦୁତଡ଼୍ !” ");
INSERT INTO kff_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ଆସୁଟେ ସେନାପତି କାମ୍‍ମାଡ଼ାନଡ଼୍ ତଡ଼୍ ଆଞ୍ଜ୍ ଅଡ଼୍‌‍କ୍ ମେଣ୍ଡେଅନ୍‌‍ଦାମ୍‍ ମାଲ୍‍ପି ତାତ୍‍ତଣ୍ଡ୍‍, ଅଡ଼୍‌‍ ବାତ୍‍ବା ଶାତ୍‍ୱାମ୍‍ତଡ଼୍‍ ମାଡ଼ଡ଼୍‍, ବାତେଙ୍କ୍ଇତ୍‍କେ କାଳେ ନାରୁଡ଼୍ ତାମ୍ ପର୍‍ର କାଲ୍‍କ୍ ଏସିତଡ଼୍ ଇଦ୍ ୱେର୍‍ ଅଡ଼୍‌‍କ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ଅଡ଼୍‌ ପ୍ରେରିତଡ଼୍‍କ୍ ତାସ୍ ମହାସବାତ୍‍ ମୁନ୍‍ନେ ନିସ୍ପ୍‍ତଡ଼୍ । ଆଗାଙ୍କ୍ ବେଡ଼୍‍ୟଣ୍ଡ୍‍ ଜାଜକ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପ୍ରଶ୍ନ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, ମାମ୍‍ମେ ମିକିଂଙ୍କ୍ ଇଦ୍ ପେଦେର୍‍ତେ ଶିକ୍ଷା ହିଦାଙ୍କ୍ ସାରେ ମନା ମାଡ଼ିମାତ୍‍ତମ୍, ଇତ୍‍କେ ଉଡ଼ାଟ୍ ମିଡ଼୍ ବାତେ ମାଡ଼୍‍ତିଡ଼୍ ! ମିଡ଼୍ ମିୟାଦ୍ ଶିକ୍ଷା ଯିରୁଶାଲେମ୍‍ ସାରେଏକାମ୍ ପ୍ରଚାର୍ ମାଡ଼ି ଆଦ୍ ନାରୁଣ୍ଡ୍‍ତେ ଦଂସ ଆଦାନାଦ୍ ମା ପର୍‍ର ଦାୟୀ ମାଡ଼ାଙ୍କ୍ ଚାଏମ୍ ଆଦୁତିଡ଼୍ !” ");
INSERT INTO kff_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ପିତର୍ ନୁ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ମାମ୍ ଇଶ୍ୱର୍‌ତେ ଗଟ୍ କେଞ୍ଜୀତମ୍ ମାତ୍ରମ୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ବେନ୍ ଜିସୁଙ୍କ୍ ମିଡ଼୍ କ୍ରୁଶତାଗ୍ ୱେଃସ୍ ଆୱ୍‍କି ମାତ୍‍ତିଡ଼୍, ମାନ୍‍ ଆନିଦାଦୀଡ଼୍‍ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଏସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଇସ୍ରାଏଲ୍‍ତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅନୁତାପ୍ ମାଡ଼ି ପାପ୍ କେମା ଇଦାନ୍ ସୁଯୋଗ୍ ଇଦାଙ୍କ୍ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ତିନ୍ଦେପାକେତ୍‍ ନେତା ନୁ ତ୍ରାଣକର୍ତ୍ତାଲ୍ ଲେକାମ୍ ତେଇସ୍‍ ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ମାନାଡ଼୍ ଇଦ୍ ସାରେ ବିଷୟ୍‍ତାଦ୍‍ ସାକ୍ଷି, ମେଣ୍ଡେ ବେନ୍ ପବିତ୍ର ଆତ୍ମାଙ୍କ୍ ଇଶ୍ୱର୍ ତାନ୍ ଗଟି ପାଲନ୍ ମାଡ଼ାନଡ଼୍‍କ୍‍ ହିତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିକା ସାକ୍ଷି ।” ");
INSERT INTO kff_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ବେଡ଼ିୟ୍‍ମିଟିଙ୍କ୍‍ତେ ସଦସ୍ୟଡ଼୍ ଇଦ୍ ଗଟ୍ କେଞ୍ଜି ଗାଟି କାଡ଼ାମ୍ ଆଦ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଡ଼୍‌ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ଆୱ୍‍କାଂଙ୍କ୍ ଚାଏମ୍‍ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଗମଲୀୟେଲ୍‍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ପାରୂଶୀ, ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ନିୟମ୍‍ ଗୁରୁ ନୁ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ସାୟେତ୍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ବେଡ଼ିୟେ ମିଟିଙ୍କ୍‍ତାଗ୍ ନିଶ୍‍ ପ୍ରେରିତଡ଼୍‍କିଙ୍କ୍ ବେସ୍‍କେ ଦିନାମ୍‍ତେ ସେଙ୍ଗେ ବାଇଦେ ଆତ୍‍ତାଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ବେଡ଼୍‍ୟେମିଟିଙ୍ଗ୍‍ତେ ବାଡ଼୍‍ୟେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଏୟ୍‍ ଇସ୍ରାଏଲୀୟ ନାରୁଡ଼ି, ମିଡ଼୍ ଇଡ଼୍‍କିଙ୍କ୍ ବାଆତେ ମାଡ଼ାଙ୍କ୍ ଆଦୁତିଡ଼୍, ଆଦ୍ ବିଷୟ୍‍ତେ ସାବ୍‍ଦାନ୍ ଆୟ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ମିଡ଼୍ ଏର୍କା ମାଡ଼ାଟ୍, ବେସ୍‍କେ ଦିନାମ୍ ମୁନେଙ୍କ୍ ଯିଉଦା ନିଜେ ୱେରଣ୍ଡ୍ ବେଡ଼୍‍ୟଣ୍ଡ୍‍ ଯାଜକ୍‌ ଇଞ୍ଜ କେତ୍‍ତଣ୍ଡ୍ ନୁ ମାତ୍ରମ୍‍ ଚାର୍‍ଶହ୍ ନାରୁଡ଼୍ ଅନ୍‌‍ତଡ଼୍ ବିଶ୍ୱାସ୍‍ତେ କାଇଲ୍‍ତଡ଼୍; ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଡଲ୍‍ତଣ୍ଡ୍, ଅନ୍‌‍ ପେର୍‍କେ ମାନ୍ଦାନଡ଼୍‍ ଚିନ୍‍ବିନ୍‍ ଆଦ୍‍ତଡ଼୍ ନୁ ଅନାଦ୍‌ ଦଲ୍‍ ଦଂସ ପାଏମ୍‍ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ତାନ୍‍ପେର୍କେ ଜନଗନନା ସମୟ୍‍ତେ ଗାଲିଲୀୟ ଯିହୁଦା ପେଦେର୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ୱାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିକା ନାର୍‍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଆକର୍ଷନ ମାଡ଼୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ମିକା ଡଲ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ଅନ୍‌ ବିଶ୍ୱାସ୍‍ ମାଡ଼ି ପେର୍କେମାନ୍ଦାନଡ଼୍ ଚିନ୍‍ବିନ୍‍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଆଦିଙ୍କ୍ ନାନ୍‍ନେ ମିକିଂଙ୍କ୍ କେତୁତାନ୍, ମିଡ଼୍ ଇହି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବାଆତେ ମାଡ଼କଟ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱିଡ଼୍‍ସିମୁଟ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଇଦ୍ ଜୋଜନା ବା ଇଦ୍ ପାଡ଼୍‍ୟି ଯଦି ନାରୁଡ଼ାଗାଙ୍କ୍ ଆତ୍‍ତେ, ଆଲେକେ ଆଦ୍ ଦଂସ ପାଏମ୍ ଆଦ୍‍ତେ; ");
INSERT INTO kff_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ଇତ୍‍କେ ଆଦ୍ ଯଦି ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ଆସ୍‍ମାନ୍‍ତେ ଇଞ୍ଜ ବିଶ୍ୱାସ୍‍, ଆଲେକେ ମିଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଦଂସ ମାଡ଼ାନଙ୍କ୍ କଷ୍ଟ ଆଦ୍‍ତେ, କାଳେ ମିଡ଼୍ ଇଶ୍ୱର୍‌ତେ ବିରୁଦତେ ଯୁଦ୍‍ ମାଡ଼ୁତିଡ଼୍ ଇଞ୍ଜ ତଅନ୍‌ଦିତ୍‍ ।” ବେଡ଼୍‍ୟେମିଟିଙ୍ଗ୍‍ ଗମଲିଏତ୍ ପରାମର୍ଶ ଗ୍ରହନ୍‍ ମାଡ଼୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ଅଡ଼୍‌ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ ଲୋପେ କାର୍‍ଙ୍ଗି, ଅଡ଼୍‌‍କିଂଙ୍କ୍ କଡ଼ାତେ ରେହେତଡ଼୍ ନୁ ଜିସୁନ୍‍ ପେଦେର୍‍ତେ ବାଆତେ ଗଟି କେଲ୍‍ମା ଇଞ୍ଜ ଗଟ୍ ଇସ୍‌ ୱିଡ଼୍‍ସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ପେଦେର୍‍ତେ ବେଡ଼୍‍ୟେମିଟିଙ୍ଗ୍‍ତାଗାଙ୍କ୍ ପେଇସ୍ ଆଦ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ କଣ୍ଡେତେ ଅଡ଼୍‌ ଜିସୁନ୍‍ ସେଙ୍ଗେ ଅପମାନିତ ଆଦାନଙ୍କ୍ ଯୋଗ୍ୟ ଆସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ମେଣ୍ଡେ ଅଡ଼୍‌ ସାରେଦିନେ ମନ୍ଦିର୍‍ତାଗ୍ ନୁ ନାରୁଡ଼୍‍ତେ ଲଅକିନାଗ୍ ଶିକ୍ଷା ହିତ୍‍ତଡ଼୍ ନୁ ମସୀହ ଜିସୁନ୍ ବିଷୟ୍‍ତେ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ବେସ୍‍କେ ଦିନାମ୍ ପେର୍‍କେ ଶିଷ୍ୟଡ଼ାଦ୍ ସଂକ୍ୟା ନାର୍ଗେ ଆଦାନ୍‍ୱେଲେ ଗ୍ରୀକ୍‍ ଗଟ୍ କେତ୍‍ତାନ୍ ଇହୁଦୀଡ଼୍‍ ନୁ ଏବ୍ରିୟ ନାରୁଡ଼୍ କପାମ୍ ଆଦ୍‍ତଡ଼୍ । ନିତିଦିନେତ୍‍ ପାଡ଼୍‍ୟି ଡାବ୍‍କ୍ ତୁସାନ୍‍ୱେଲେ ତାମ୍ ରାଣ୍ଡିକିଙ୍କ୍ ଗମାଡ଼୍ ମାଡ଼ୁତଡ଼୍ ଇଞ୍ଜ ଗ୍ରୀକ୍‍ ଗଟ୍ କେତ୍‍ତାନ୍ ଇହୁଦୀଡ଼୍‍ ଆପତି ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ଆଦିଙ୍କ୍ ବାରଜାନ୍ ପ୍ରେରିତ ଶିଷ୍ୟ ସାରେ ବିଶ୍ୱାସୀ ମାନ୍ଦେତିଙ୍କ୍ ଅଣ୍ଡୟାଗେ କାର୍‍ଙ୍ଗି କେତ୍‍ତଡ଼୍, “ନିତ୍‍ଦିନ୍‍ ଦର୍‍କାର୍‍ ଜିନିଷ୍‍ କାର୍‍ବାର୍‍ତେ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ ପ୍ରଚାର୍ ସେବା ମାଡ଼ାନାଗ୍‍ ଗମାଡ଼୍ ମାଡ଼ାନାଦ୍ ମାନ୍‍ ମାଇଦିଙ୍କ୍ ଟିକ୍ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ଆଦିଙ୍କ୍ ହୋ ଦାଦାଲଡ଼୍‍ ନୁ ଏଲାସ୍କ୍‍, ମିଇ ଲୋପେଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ନୁ ବୁଦ୍‍ତେ ବର୍ତ୍ତି ଆସ୍‍ମାନ୍ଦାନ୍ ସାତ୍‍ ଜାନ୍‍ତିଙ୍କ୍ ଏଞ୍ଚାଟ୍‍ । ମାନାଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦ୍ ସାରେ ବିଷୟ୍‍ତେ ଦାୟିତ ହିଦ୍‍ତାଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ଆଲେଇତ୍କେ ପ୍ରାର୍ତନା ନୁ ପ୍ରଚାର୍ ପାଡ଼୍‍ୟି ମାନାଡ଼୍ ସାରେ ଦିନାମ୍ ଇଦେପାର୍‍ଦ୍‍ତାଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ସାରେ ଗଷ୍ଠିତଡ଼୍‍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ପ୍ରସ୍ତାବ୍‍ତାଗ୍ ରାଜି ଆଦ୍‍ତଡ଼୍ ମେଣ୍ଡେ ଇଦ୍ ପାଡ଼୍‍ୟି ସେଙ୍ଗେ ଅଡ଼୍‌ ବିଶ୍ୱାସ୍‍ ନୁ ପବିତ୍ର ଆତ୍ମାତେ ପୁର୍ନ ଆସ୍‍ମାନ୍ଦାନ୍ ସ୍ତିଫାନ୍‍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍, ମେଣ୍ଡେ ଫିଲିପ୍‍ପ, ପ୍ରକର୍, ନୀକୋନର୍, ତୀମୋନ୍‍, ପାର୍ମନା ନୁ ମୁନେ ଆଣ୍ଟିୟୋକତେ ଇହୁଦି ଦର୍ମ ଗ୍ରହନ୍ ମାଡ଼୍‍ତେ ଅବିଶ୍ୱାସୀ ନିକୋଲାୟଙ୍କ୍ ଏଞ୍ଚିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପ୍ରେରିତଡ଼୍ ମୁନ୍‍ନେ ତାତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଡ଼୍‌ ପର କାଇୱାଟି ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଇଦ୍ ରକମ୍ ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ ପ୍ରଚାର୍ ଆତ୍‍ତେ । ଯିରୁଶାଲେମ୍‍ତାଗ୍‍ ଶିଷ୍ୟଡ଼ାଦ୍‍ ସଂକ୍ୟା ଅଦିକ୍‌‌ ଆତ୍‍ତେ; ନାର୍‍ଗେ ଜାଜକୀଡ଼୍‍ ମିକା କ୍ରିଷ୍ଟଙ୍କ୍‍ ବିଶ୍ୱାସ୍‍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ନାର୍‍ଗେ ଅନୁଗ୍ରହ ନୁ ଶକ୍ତି ପାଏମ୍‍ଆତ୍‍ତେ ସ୍ତିଫାନ୍‍, ନାରୁଡ଼୍ ଲୋପେ ନାର୍‍ଗେ ଆଦ୍‍ବୁତ୍‌ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","କିନ୍ତୁ କୁରିନୀୟ ନୁ ଆଲେକ୍‍ଜାଣ୍ଡ୍ରିୟାଲ୍‍ କାଇଦି ଜଇଲ୍‍ ତାଗାଙ୍କ୍‍ ମୁକ୍ତି ଆସ୍‍ମାନ୍ଦାନ୍‍ ଇହୁଦିଡ଼୍‍କ୍‍ ଆସ୍‍ ତିଆର୍‍ ଆସ୍‍ ମାନ୍ଦାନ୍‍ ଉପାସନା ଲୋକ୍‍ ବେସ୍କ୍‍ତୁଡ଼୍‍ ସ୍ତିଫାନ୍‍ତିଙ୍କ୍‍ ବିରୁଦ୍‍ ମାଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌ ନୁ ସିଲିଷୀଆ ଏସିଆ ଦେଶ୍‍ତେ ବାଗାତ୍‍ ଇହୁଦୀଡ଼୍‍ ସ୍ତିପାନ୍‍ ତଡ଼୍‍ ଯୁକ୍ତି ମାଡ଼ାନଙ୍କ୍‍ ପସ୍ପ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପବିତ୍ର ଆତ୍ମା ସ୍ତିପାନ୍‍ତିଙ୍କ୍ ଇଦ୍ ରକମ୍ ମାଡ଼ାନାଦ୍‍ ଶକ୍ତି ବୁଦ୍‍ ହିତ୍‍ତେ ଯେ, ବେନବା ଅନ୍‌ ଗଟ୍‍ତିଙ୍କ୍ ବିରଦ୍ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ଆସୁଟ୍‍, “ଅଣ୍ଡ୍‌‍ ମୋଶାଲ୍‌‍ ବିରୁଦ୍‍ତେ ଇଶ୍ୱର୍‌ତେ ବିରୁଦ୍‍ତେ ଗଟି କେତାନାଦ୍‍ ମାମ୍‍ କେଞ୍ଜ୍‍ତମ୍‍,” ଇଦ୍‍ ମିଚ୍‍ ସାକ୍ଷି ଇଦାନ୍‍ ମାଇଦିଙ୍କ୍‍ ବେସ୍କ୍‍ତଡ଼୍‍କିଙ୍କ୍‍ ଲାଞ୍ଚ୍‍ ଇସ୍‍ ମିଚ୍‌କେତାଙ୍କ୍‍ କେତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଇଦ୍ ରକମ୍ ଅଡ଼୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍, ଦର୍ମ ନେତାଲଡ଼୍‍କ୍ ନୁ ଦର୍ମଗୁରୁଡ଼୍‍କ୍ କପାମ୍ ମାଡ଼ି ଅଂକିଙ୍କ୍‌ ଚିଟିରମନ୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ସ୍ତିଫାନ୍‍ତିଙ୍କ୍‍ ବେଡ଼୍‍ୟେ ମିଟିଙ୍କ୍‍ତାଗ୍ ପୟ୍‍ସ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଅନ୍‌ ବିରୁଦ୍‍ତେ ମିଚ୍‍ ସାକ୍ଷି ହିଦାନ୍ ସେଙ୍ଗେ ବେସ୍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଲୋପେ ତାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ନାରୁଡ଼୍ ସାରେଦାମ୍ ମାନ୍‍ ପବିତ୍ର ମନ୍ଦିର୍ ନୁ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ବିରୁଦ୍‍ତେ ଗଟି କେତୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ନାଜରିତିୟ ଜିସୁ ମନ୍ଦିର୍‍ତିଙ୍କ୍ ଉହୁତିତଣ୍ଡ୍ ନୁ ମୋଶାଲ୍‌‍ ପାଏମ୍‍ଆତ୍‍ତେ ସାରେ ନିତିନିୟମ୍‍ ବଦ୍‍ଲା ମାଡ଼ିତନ୍ ଇଞ୍ଜ ଇଣ୍ଡ୍ ନାରୁଡ଼୍ କେସମାନ୍ଦାନାଦ୍ ମାମ୍ କେଞ୍ଜ୍‍ତମ୍ !” ");
INSERT INTO kff_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ଆସୁଟେ ବେଡ଼ିୟେ ମିଟିଙ୍କ୍‍ତାଗ୍ କୁଦିମାନ୍ଦାନ୍ ସାରେତଡ଼୍ ଅନାକ୍ ଅଣ୍ଡୟ୍‌ କଣ୍ଡେତେ ଉଡ଼୍‍ତଡ଼୍ ଯେ ଅନ୍‌ ମକମ୍ ସ୍ୱର୍ଗ ଦୂତତେ ମକମ୍ ଇନା ତଅନ୍‌ଦମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ବେଡ଼୍‍ୟି ଜାଜକ୍ ସ୍ତିପାନ୍‍ତିଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ଇଦ୍ ବାତ୍ ନିଜାମ୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ସ୍ତିପାନ୍ ଉତର୍‍ ହିତ୍‍ତଣ୍ଡ୍, “ହଁ ଦାଦାଲଡ଼୍‍ ନୁ ବାବାଲଡ଼୍, କେଞ୍ଜାଟ୍ ! ମାନ୍‍ ଆନିଦାଦି ଅବ୍ରାହାମ୍ ହାରାନତାଗ୍ ମାନ୍ଦାନ୍‍ ମୁନେଙ୍କ୍ ଗୌରବମୟ ଇଶ୍ୱର୍ ମେସପଟାମିୟାତାଗ୍ ଦର୍ଶନ୍ ଇସ୍, ");
INSERT INTO kff_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ମେଣ୍ଡ୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, ନି ପରିବାର୍ ନୁ ଦେଶ୍‍ ୱିଡ଼୍‍ସି ନାନ୍ ବେନ୍ ଦେଶ୍ ହିଦ୍‍ତାନ୍, ଆଗେ ଅନ୍‌ । ");
INSERT INTO kff_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ତାନ୍ ଦେଶ୍ କ୍ଲିଡିଅନ୍‌‍ ୱିଡ଼୍‍ସି ହାରାନତାଗ୍ ମାନ୍ଦାନଙ୍କ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ଅବ୍ରାହାମ୍‌ତେ ବାବାଲ୍ ଡଲ୍‍ତେ ପେର୍‍କେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଆଦ୍ ଦେଶ୍‍ତାଗ୍ ତାତ୍‍ତଣ୍ଡ୍, ବେନ୍ ଦେଶ୍‍ତାଗ୍ ମିଡ଼୍ ଇଞ୍ଜେ ମାନ୍ଦୁ ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ଇଶ୍ୱର୍ ଆସୁଟେ ଅବ୍ରାହାମ୍‌ତିଙ୍କ୍ ଇଦ୍ ଦେଶ୍‍ତେ ବାତେମିକା ଇୱଣ୍ଡ୍, ଇଦ୍ ରକମ୍ କି ଅଣ୍ଡୟ୍‌ ପାଦାମ୍‍ ବୁମ୍ ମିକା ଇୱଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ପ୍ରତିଜ୍ଞା ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଅବ୍ରାହାମ୍‌ତିଙ୍କ୍ ଇଦ୍ ଦେଶ୍ ହିଦ୍‍ତଣ୍ଡ୍ ନୁ ଇଦ୍ ଅନ୍‌‍ୱାଦ୍ ନୁ ତାନ୍ ବଂଶଦର୍‍ତେ ନିଜେତାଦ୍ ଆଦ୍‍ତେ । ଇଶ୍ୱର୍ ଆଦ୍ ପ୍ରତିଜ୍ଞା ମାଡ଼ାନ୍‍ୱେଲେ ଅବ୍ରାହାମ୍‌ତିଙ୍କ୍ ପିଲା ଇଲ୍‍ୱେକଟ ମାତ୍‍ତ । ");
INSERT INTO kff_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ଆସୁଟେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଇଦ୍ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍; “ନି ବଂଶଦର୍ କ୍ରୀତଦାସ ଲେକାମ୍ ବେନ୍‍ ଦେଶ୍‍ତାଗ୍ ମାନ୍ତ୍‍ତଡ଼୍ ନୁ ଚାରିଶହ୍ ହେଣ୍ଡ୍‍କ୍ ଯାକ ଗାଟିତିପାଲ୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ମେଣ୍ଡେ ଇଶ୍ୱର୍ କେତ୍‍ତଣ୍ଡ୍, “ଅଡ଼୍‌ ବେନ୍ ଜାତିତେ ଦାସ ଆଦ୍‍ତଡ଼୍, ମାମ୍‍ମେ ଅଡ଼ାଦ୍‌ ବିଚାର୍ ମାଡ଼ିତମ୍; ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଦେଶ୍‍ତାଗାଙ୍କ୍‍ ପେଇସ୍ ୱାସ୍ ଇଦ୍ ପଡ଼୍‍ୟେତାଗ୍ ମାୱାଦ୍ ଉପାସନା ମାଡ଼ିତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ତାନ୍‍ପେର୍କେ ଇଶ୍ୱର୍ ଅବ୍ରାହାମ୍‌ତିଙ୍କ୍ ସୁନ୍ନତବିଦି ହିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଅବ୍ରାହାମ୍ ଆଦ୍ ଲେକାମ୍ ଇସ୍‍ହାକ୍‍ତିଙ୍କ୍ ଜନମ୍ ମାଡ଼ି ଆଟ୍‌ ଦିନେତେ ଅଂକିଙ୍କ୍‌ ସୁନ୍ନତ୍ ମାଡ଼୍‍ତଣ୍ଡ୍; ଇସ୍‍ହାକ୍ ଯାକୁବ୍‍, ମେଣ୍ଡେ ଯାକୁବ ବାରଜାନ୍ ମୁନେତ୍‍ ଆନିଦାଦିଡ଼୍‍କ୍ ଜନମ୍ ଇସ୍‌ ଆଦ୍ ରକମ୍ ନିୟମ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଜାକୁବ୍‍ତେ ମାର୍‍କ୍ ଅଡ଼୍‌ ତାମୁଣ୍ଡ୍ ଯୋଷେଫ୍‍ତିଙ୍କ୍ ଇର୍ଷାମାଡ଼ି କ୍ରୀତଦାସ ଲେକାମ୍ ମିସର୍‍ ଦେଶ୍ ଆଦାନ୍ ସେଙ୍ଗେ ଅଂକିଙ୍କ୍‌ ୱାମ୍‍ତଡ଼୍; ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ଅନାଦ୍‌ ସାରେ କଷ୍ଟତାଗାଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ଉଦ୍ଦାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ମିସର୍‍ତେ ରାଜାଲ୍ ଫାରୋନ୍‍ ମୁନ୍‍ନେ ଅଂକିଙ୍କ୍‌ ଅନୁଗ୍ରହ ମାଡ଼ି ସାୟେତ୍ ବୁଦ୍ ନୁ ଜ୍ଞାନ୍‍ ହିତ୍‍ତଣ୍ଡ୍; ଆଗାଙ୍କ୍ ଫାରୋ ଅଂକିଙ୍କ୍‌ ମିସର୍ ନୁ ତାନାଦ୍ ସାରେ ଲୋକିନ୍ ଶାସନ୍‍ କର୍ତାଲ୍‍ ଲେକାମ୍ ନିଯୁକ୍ତ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ତାନ୍‍ପେର୍କେ ମିସର୍‍ ଦେଶ୍ ଏକାମ୍ ନୁ କିନାନ୍‍ତାଗ୍ ଦୁର୍ବିକ୍ୟ ଆତ୍‍ତାଙ୍କ୍ ନାରୁଡ଼୍ ଗାଟି କଷ୍ଟ ଦର୍‍କ୍‍ତେ । ମେଣ୍ଡେ ମାନ୍‍ ଆନିଦାଦିଡ଼୍‍କ୍ କାଦି ଦର୍‍କ । ");
INSERT INTO kff_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିସର୍‍ତାଗ୍ କାଦି ମିନ୍ଦେ ଇଞ୍ଜ କେଞ୍ଜି, ଯାକୁବ୍‍ ତାନ୍ ମାର୍‍କିଡ଼୍‍କ୍ ନୁ ମାନ୍‍ ଆନିଦାଦିଡ଼୍‍କ୍ ମୁନ୍‍ନେନ୍ ଦାମ୍‍ ରହତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ରେଣ୍ଡ୍‍ଦାମ୍ ଆତ୍‍ତେ ୱେଲେ ଯୋଷେଫ୍‍ ତାମ୍ ଦାଦାଲଡ଼୍‍ ପରିଚୟ ହିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ଫାରୋ ଜସେଫ୍‍ତେ ପରିବାର୍‍ ବିଷୟ୍‍ତେ ପୁତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ତାନ୍‍ପେର୍କେ ଯୋଷେଫ୍‍ ତାମ୍ ବାବାଲ୍ ଯାକୁବ୍‍ ନୁ ତାମ୍ ପରିବାର୍‍ତେ ସାରେ ସତୁରିଏଇଙ୍ଗ୍‍ ଜାନ୍‍ତିଙ୍କ୍ ମିସର୍ ୱାଦାନଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ଯାକୁବ୍‍ ମିସର୍ ଦେଶ୍‍ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍, ଆଗେ ଅଣ୍ଡ୍‌ ନୁ ତାମ୍ ମାର୍‍କିଡ଼ାଦ୍ ଡଲ୍‍ନାଦ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ଅଡ଼ାଦ୍‌ ମଡ଼୍‍ତିଙ୍କ୍ ଶିକିମ୍‍ତାଗ୍ ଆତ୍‍ତଡ଼୍ ନୁ ଅବ୍ରାହାମ୍ ହାମୋର୍‍ ନାରୁନାଗାଙ୍କ୍ ରୁପା ଡାବ୍‍କ୍ ଇସ୍‌ ଆସିମାନ୍ଦାନ୍ କବର୍‍ତାଗ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସମାଦି ହିତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅବ୍ରାହାମ୍‌ତେ ଗାର୍‍ରେ ବେନ୍ ପ୍ରତିଜ୍ଞା ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପ୍ରତିଜ୍ଞା ସାରେ ପୁରା ଆଦାନ୍ ଦିନାମ୍ ହେୱୁତାଙ୍କ୍, ମା ନାରୁଡ଼୍ ନାର୍‍ଗେ ମିସର୍‍ ଆଦାଙ୍କ୍ ପସ୍‍ପ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ପେର୍କେ ଯୋଷେଫ୍‍ତେ ବିଷୟ୍ ପୁନ୍‍ୱେନଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ରାଜାଲ୍ ମିସର୍‍ ଦେଶ୍‍ତିଙ୍କ୍ ଶାସନ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ଅଣ୍ଡ୍‌ ମାନ୍‍ ଆନିଦାଦିଡ଼୍ ସେଙ୍ଗେ ନିଷ୍ଟୁର୍ ନୁ ଗଲକ୍ ବ୍ୟବହାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ଅଡ଼ାୱୁ ପୁନେ ଜନମ୍ ଆତ୍‍ତେ ପିଲାକିଙ୍କ୍ ହାୱ୍‍କାନ୍ ସେଙ୍ଗେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାୟିଦେ ନେହେତାନଙ୍କ୍ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ଆଦ୍ ସମୟ୍‍ତେ ମୋଶାଲ୍‌‍ ଜନମ୍ ଆତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଗାଟି ସୁନ୍ଦର୍ ମାତ୍‍ତଣ୍ଡ୍ । ଇଶ୍ୱର୍ ମୁଣ୍ଡ୍ ନେଲ୍‍ଞ୍ଜ୍‍କ୍ ତାମ୍‍ ଲୋନ୍‌ ବାଦ୍‍କ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ମେଣ୍ଡେ ବେସୁଟ୍‌ ଅଂକିଙ୍କ୍‌ ବାୟିଦେ ରହ୍‍ସିତ୍‍ତ୍‍ତଡ଼୍, ଫାରୋନ୍ ମାୟାଡ଼୍ ଅଂକିଙ୍କ୍‌ ନିଜେତ୍ ମାର୍‍ ଲେକାମ୍ ପଡ଼୍‍ପ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ମୋଶାଲ୍‌‍ ମିଶର୍‍ତେ ସାରେ ବିଦ୍ୟାତାଗ୍ ଶିକିତ୍ ଆସ୍, ଅନ୍‌‍ୱାଦ୍ ଗଟ୍‍ ନୁ ପାଡ଼ିୟିଦାଗ୍ ମହାନ୍ ବ୍ୟକ୍ତି ଲେକାମ୍ ପରିଚିତ ଆତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ବେସୁଟ୍‌ ମୋଶାନ୍‌ ବୟସ୍‍ ଚାଲିଶ୍ ହେଣ୍ଡ୍‍କ୍ ଆତ୍‍ତେ, ଅଣ୍ଡ୍‌ ତାନ୍ ଇସ୍ରାଏଲ୍‍ ବିଶ୍ୱାସୀଡ଼୍‍ ଦାଦାଲ୍‌ଡ଼୍‌ ବେଦ୍‍ପୁଟୁଙ୍କ୍ ବ୍ୟବହାର୍ ମାଡ଼ୁତଡ଼୍, ଆଦ୍ ପୁନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ଅର୍‍ତୁଙ୍କ୍, ୱେରଣ୍ଡ୍ ମିଶର୍‍ତେ କାରାପ୍ ବ୍ୟବହାର୍ ମାଡ଼ାନାଦ୍ ଉଡ଼ି, ମୋଶଲ୍ ଅଂକିଙ୍କ୍‌ ରକ୍ଷା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ମିସରୀୟ ନାରୁଙ୍କ୍ ପ୍ରତିଶଦ୍‍ ଆସ୍ ଅଂକିଙ୍କ୍‌ ହାୱ୍‍କ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ଅନ୍‌ ତଡ଼୍ ଇଶ୍ୱର୍ ଜେ ତାମ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ୁତଣ୍ଡ୍, ଇଦ୍ ଆ ବିଶ୍ୱାସୀଡ଼୍‍ ଦାଦାଲଡ଼୍‌ ବୁଜେମ୍‍ଆତ୍‍ତଡ଼୍ ଇଞ୍ଜ ଅଣ୍ଡ୍‌ ହାଲ୍‍ସି ମାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ବୁଜେମ୍ ଆୟ୍‍ୟଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ମେଣ୍ଡନ୍‍ଦିନେ ଅଣ୍ଡ୍‌ ଇର୍‍ୱୁଡ଼୍ ଇସ୍ରାଏଲୀୟ ଦାଦାଲଡ଼୍‍ ଗଲ୍‍କ୍ ଆଦାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶାନ୍ତି ମାଡ଼ାନଙ୍କ୍ କେତ୍‍ତନ୍ । ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, ‘କେଞ୍ଜାଟ୍, ମିଡ଼୍ ଇର୍‍ୱୁଡ଼୍ ତ ଇସ୍ରାଏଲୀୟ ନାରୁଡ଼ି । ବାତେଙ୍କ୍ ଇଦ୍ ରକମ୍ ପ୍ରତିଶଦ୍‍ ମାଡ଼ୁତିଡ଼୍ ?’ ");
INSERT INTO kff_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ବାତେଙ୍କ୍ ଇତ୍କେ ବେନ୍ ନାରୁଡ଼୍ ମେଣ୍ଡ୍‍ଅଡ଼୍‌‍ତିଙ୍କ୍ କାରାପ୍ ବ୍ୟବହାର୍ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମୋଶାଙ୍କ୍ ତୁର୍ସି କେତ୍‍ତଣ୍ଡ୍, ‘ମା ପର୍‍ର ନିକିଂଙ୍କ୍ ବେନ ଶାସନ୍‍ କର୍ତାଲ୍ ନୁ ବିଚାର୍‍ପତି ମାଡ଼୍‍ତଣ୍ଡ୍ ? ");
INSERT INTO kff_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ନିନେ ବେଲା ମିଶର୍‍ତେ ନାରୁଙ୍କ୍ ହାୱ୍‍କ୍‍ତି, ନାକିଂଙ୍କ୍ ବାତେ ଆଦେରକମ୍ ହାୱ୍‍କାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତି ?’ ");
INSERT INTO kff_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ମୋଶାଲ୍‌‍ ଇଦ୍ କେଞ୍ଜି ମିସର୍‍ ଦେଶ୍ ମିର୍‍ତଣ୍ଡ୍ ନୁ ମିଦିୟୋନ୍ ଦେଶ୍‍ତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍ । ଆଗେ ଅନାୱୁ ଇର୍‍ୱୁଡ଼୍ ମାର୍‍କ୍ ଜନମ୍ ଆତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“ଚାଲିଶ୍ ହେଣ୍ଡ୍‍କ୍ ଆତ୍‍ତେ ପେର୍‍କେ ସୀନୟ ମେଟେତ୍ ଗାରେ ଉସ୍କ ନେଲ୍‌ତାଗ୍ ନିଡ଼୍‍ତାନ୍‌ ପଦ୍‍ଲେତ୍‌ ତାଗ୍‌ ନିଡ଼୍‍ତାନାଦ୍ କିସ୍ ଲୋପେ ଇଶ୍ୱର୍‌ତେ ୱେରଡ୍‍ ଦୂତ୍ ମୋଶାଙ୍କ୍ ଦର୍ଶନ୍ ଇତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମୋଶାଲ୍‌‍ ଆଦ୍ ଦୃଶ୍ୟ ଉଡ଼ି କାବା ଆତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେକେନ୍ ସାୟେ ଉଡ଼ାନଙ୍କ୍ ବକେତ୍ ଆଦାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ପ୍ରବୁନାଦ୍ ବାକ୍ୟ କେଞ୍ଜ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ନାନ୍ ମିଇ ଆନିଦାଦି ଅବ୍ରାହାମ୍, ଇସ୍‍ହାକ୍ ନୁ ଯାକୁବ୍‍ତେ ଇଶ୍ୱର୍ ।’ ମୋଶାଲ୍‌‍ ୱେର୍ରେସ୍‍ ୱାଡ଼୍‍କ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ଉଡ଼ାନଙ୍କ୍ ସାହାସ୍ ମାଡ଼ଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ତାନ୍‍ପେର୍କେ ପ୍ରବୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନିୟାୱୁ ହେର୍‍ପୁକ୍ ଟେଣ୍ଡେ, ବାତେଙ୍କ୍ ଇତ୍କେ ନିମ୍‍ ବେଗେ ନିତ୍‍ତିନ୍, ଆଦ୍ ବୂମ୍‌ ପବିତ୍ର ପଡ଼୍‍ୟେ । ");
INSERT INTO kff_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ମିସର୍‍ତାଗ୍ ନାନ୍ ନାୱଡ଼୍ ନାରୁଡ଼୍‍କ୍ କଷ୍ଟ ପାଏମ୍‍ଆଦାନାଦ୍ ଉଡ଼୍‍ତାନ୍ । ନାନ୍ ଅଡ଼ାଦ୍‌ କେୟାନାଦ୍ କେଞ୍ଜ୍‍ତାନ୍ ମେଣ୍ଡେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଦ୍ଦାର୍ ମାଡ଼ାନଙ୍କ୍ ମଦଲ୍ ୱାତ୍‍ତାନ୍ । ଇଞ୍ଜେ ୱାଡ଼େ, ନାନ୍ ନିକିଂଙ୍କ୍ ମିସର୍‍ ଦେଶ୍ ରହତିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ବେନ୍ ମୋଶାଲ୍‌‍ ଇସ୍ରାଏଲୀୟଡ଼୍ ପରିହାସ୍ ମାଡ଼ିମାତ୍‍ତଡ଼୍ ଅଂକିଙ୍କ୍‌ ଅଡ଼୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, ‘ମା ପର୍‍ର ନିକିଂଙ୍କ୍ ବେନ ଶାସନ୍‍ କର୍ତାଲ୍‍ ନୁ ବିଚାର୍‍ପତି ମାଡ଼୍‍ତଣ୍ଡ୍ ?’ ବାତେଙ୍କ୍ ଇତ୍କେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ନିଡ଼୍‍ତାନାଦ୍ ପଦ୍‍ଲେତ୍‍ ବକେତ୍ ଦର୍ଶନ୍ ଇସ୍‌‍ମାନ୍ଦାନ୍ ଦୂତନ୍ ସାହାଯ୍ୟତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶାସନ୍‍ ମାଡ଼ାନଙ୍କ୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଉଦ୍ଦାର୍ ମାଡ଼ାନଙ୍କ୍ ରହତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ଅଣ୍ଡ୍‌ ମିସର୍‍ ଦେଶ୍‍ତାଗ୍ ନୁ ଏର୍ରେରଙ୍ଗ୍ ସାୱ୍‍ଡ଼େତାଗ୍ ନାର୍‍ଗେ ଅଦ୍‍ବୁତ୍‌ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ତଅସ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମିସର୍‍ତାଗାଙ୍କ୍ ବାୟିଦେ ପେସ୍‍ପି ତାତ୍‍ତଣ୍ଡ୍, ଚାଲିଶ୍ ହେଣ୍ଡ୍‍କ୍ ଯାକ ମରୁବୁମ୍‍ତାଗ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ହାର୍ ତଅତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ମୋଶାଲ୍‌‍ ନିଜେ ଇସ୍ରାଏଲ୍‍ତେ ବାବବାଦୀ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, “ଇଶ୍ୱର୍ ନାକିଂଙ୍କ୍ ବେଲା ରହତଣ୍ଡ୍, ଆଦେ ରକମ୍ ମିଇ ବକେତ୍ ୱେରଣ୍ଡ୍ ଦାଦାଲଡ଼୍‍ ରହତିତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମିଇ ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ୱେରଣ୍ଡ୍ ତାମୁସ୍‍ ଆଦ୍‍ତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ଆଦ୍‍ନାଣ୍ଡ୍‍ ଆ ମୋଶାଲ୍ ଉସ୍କ ନେଲ୍‌ତାଗ୍ ଗୁଡ଼ିମାନ୍ଦାନ୍ ଇସ୍ରାଏଲୀୟ ନାରୁଡ଼୍ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ସୀନୟ୍ ମେଟେତାଗ୍ ମାନ୍‍ ଆନିଦାଦିଡ଼୍ ତଡ଼୍ ନୁ ଅନ୍‌‍ତଡ଼୍ ଗଟ୍ ତିର୍‍ୟମାନ୍ଦାନ୍ ଦୂତ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ମା ଗାର୍‍ରେ ତୁହୁସାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତାଗାଙ୍କ୍ ଜିୱେତ୍ ବାକ୍ୟ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ବାତେଙ୍କ୍ ଇତ୍‍କେ ମାୱଡ଼୍ ଆନିଦାଦିଡ଼୍ ଅନ୍‌ ଗଟି କେଞ୍ଜଡ଼୍, ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ପାସ୍କି ମିସର୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ହାରୋଣତିଙ୍କ୍ କେତ୍‍ତଡ଼୍‍, ‘ବେସ୍‌କ୍ ଦେୟାକ୍ ପୁତ୍‍ଲାମ୍ ତିଆର୍ ମାଡ଼ିମ୍ । ମାକିଂଙ୍କ୍ ମିସର୍‍ ଦେଶ୍‍ତାଗାଙ୍କ୍ ପେସ୍‍ପି ତାତ୍‍ତେ ମୋଶାଲ୍‌‍ ବେକେ ଆତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ମାମ୍‍ମେ ପୁନମ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ଆସୁଟେ ଆଗେ ଅଡ଼୍‌ ଅଣ୍ଡୟ୍‌ ଗଡ୍‍ପିଲେ ପୁତ୍‍ଲାମ୍ ତିଆର୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ତାନ୍‍ ଲେକାମ୍‌ତେ ପୁଜେ ମାଡ଼୍‌ତଡ଼୍‍ । ମେଣ୍ଡେ ନିଜେ ତିଆର୍ ମାଡ଼୍‍ତେ ପୁତ୍‍ଲାମ୍‍ତେ ସମ୍ମାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡୟ୍‌ ବଜି ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ଆଦିଙ୍କ୍ ଇଶ୍ୱର୍ ଅଡ଼୍‌ ସେଙ୍ଗେ କପାମ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସ୍ୱର୍ଗତାଗ୍ ମାନ୍ଦାନ୍ ଉକାକିଙ୍କ୍ ଉପାସନା ମାଡ଼ାନଙ୍କ୍ ୱିଡ଼୍‍ସିତ୍‍ତଣ୍ଡ୍ । ଇଦ୍ ବିଷୟ୍‍ତେ ବାବବାଦୀଡ଼ାଦ୍ ବଇତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ହୋ ଇସ୍ରାଏଲ୍‍ ବଂଶତଡ଼୍ ! ଉସ୍କ ନେଲ୍‌ତାଗ୍ ଚାଲିଶ୍‍ ହେଣ୍ଡ୍‍କ୍ ଯାକ ମିଡ଼୍ ନା’ ସେଙ୍ଗେ ପଶୁ ବଲି ନୁ ହୋମବଲି ହିୱକଟ୍ ମାତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ବାତେଙ୍କ୍ ଇତ୍‍କେ ମିଡ଼୍ ପୁଜା ମାଡ଼ାନଙ୍କ୍ ବେନ୍ ପୁତ୍‍ଲାକିଙ୍କ୍ ତିଆର୍ ମାଡ଼ିମାତ୍‍ତିଡ଼୍, ଆଦ୍ ମାଲିକ୍‌ତେ ତମ୍ବୁ ନୁ ଉକାମ୍ ଦେୟାମ୍ ରମ୍ପା ପୁତ୍‍ଲାତିଙ୍କ୍ କାଞ୍ଜୀ ହତ୍‍ତିଡ଼୍ । ଆଦିଙ୍କ୍ ନାନ୍ ମିକିଂଙ୍କ୍ ବାବିଲୋନ୍‌ ଦେଶ୍‍ତେ ମେଣ୍ଡନ୍‍ପାକ୍ ରହତିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ଉସ୍କ ନେଲ୍‌ତାଗ୍ ମାନ୍‍ ଆନିଦାଦିଡ଼୍ ତଡ଼୍ ଇଶ୍ୱର୍‌ତେ ପବିତ୍ର ତମ୍ବୁ ସାକ୍ଷ୍ୟ । ଇଶ୍ୱର୍ ମୋଶାଲ୍‌‍ ବେଲା ତିଆର୍ ମାଡ଼ାଙ୍କ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍ ନୁ ମୋଶାଙ୍କ୍ ବେଦ୍ ନକ୍‍ସା ତଅସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ଆଦେରକମ୍ ତିଆର୍ ଆସ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ପେର୍‍କେ ମାନ୍‍ ଆନିଦାଦିଡ଼୍ ଅଡ଼୍‌ ବାବାଲଡ଼ାଗାଙ୍କ୍ ଦର୍‍କି ମାନ୍ଦାନ୍ ଆଦ୍ ତମ୍ବୁତିଙ୍କ୍ ଜିହୋଶୁୟନ୍ ତଡ଼୍ କାଞ୍ଜୀ ମୁନ୍‍ନେ ଆଦ୍‍ତଡ଼୍ ନୁ ଇଶ୍ୱର୍ ତଲିମାନ୍ଦାନ୍ ବାଗାତ୍ ଅଣଯିହୁଦିଡ଼୍‍ଡ଼ାଦ୍ ଦେଶ୍‍ ଅଦିକାର୍‌ ମାଡ଼୍‍ତଡ଼୍ । ଦାଉଦନ୍ ଦିନାମ୍ ଯାକ ଆଦ୍ ଆଗେ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ଅନୁଗ୍ରହ ନାରୁଣ୍ଡ୍‍ ହାସ୍ ମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ପରମେଶ୍ୱର୍‍ତିଙ୍କ୍ ଯାକୁବ୍‍ ଇଶ୍ୱର୍‌ତେ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ମନ୍ଦିର୍ ତିଆର୍ ମାଡ଼ାନଙ୍କ୍ ଗଟ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ଇତ୍‍କେ ପେର୍‍କେ ଆ ମନ୍ଦିର୍ ଶଲୋମନ୍‍ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ଆଗେକ୍‍ବା ସାରେତିଙ୍କ୍ ବେଡ଼୍‍ୟେ ଇଶ୍ୱର୍ ନାରୁଡ଼୍ ମାଡ଼୍‍ତେ ଲୋକିନାଗ୍ ମାନଣ୍ଡ୍ । ଇଦ୍ ବିଷୟ୍ ବାବବାଦୀଡ଼୍‍ ଲେକିମିନ୍ଦେଡ଼୍; ");
INSERT INTO kff_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ପ୍ରବୁ କେତ୍‍ତଣ୍ଡ୍, ସ୍ୱର୍ଗ ନା’ ସିଂହାସନ୍‍ ନୁ ପୃତିବି ନାୱାଦ୍ ଡେକେତ୍ କୁତୁଲ୍‍ । ମିଡ଼୍ ନା ମାଇଦିଙ୍କ୍ ବେସତ୍ ଲୋନ୍‌ ତିଆର୍ ମାଡ଼ିତିଡ଼୍ ? ନାନ୍ ରହମାନ୍ ସେଙ୍ଗେ ପଡ଼୍‍ୟେ ବେଗେ ? ");
INSERT INTO kff_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ଇୱୁ ସାରେ ବିଷୟ୍ ବାତ୍ ନାନ୍ ନିଜେ ତିଆର୍ ମାଡ଼ନ୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ସ୍ତିଫାନ୍ ମେଣ୍ଡେ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବେସର୍ ଜିଦ୍‍ତଡ଼ି ! ମିୱାଦ୍ ହୃଦୟ୍ ବେସର୍ ଅସୁନ୍ନତ, ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ ସେଙ୍ଗେ ମିଡ଼୍ ବେସର୍ ବାୟିରାଲଡ଼ି ! ମିଡ଼୍ ଟିକ୍ ମିୱଡ଼୍ ଆନିଦାଦିଡ଼୍ ଲେକାମ୍, ମିଡ଼୍ ସାରେଦାମ୍ ପବିତ୍ର ଆତ୍ମାତିଙ୍କ୍ ବିରୋଦ୍ ମାଡ଼ିତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ବାବବାଦୀଡ଼୍ ଲୋପେଙ୍କ୍ ବେନଙ୍କ୍ ମିୱଡ଼୍ ଆନିଦାଦିଡ଼୍ ତାଡ଼ନା ମାଡ଼୍‍ୱେ ମାତ୍‍ତଡ଼୍ କି ? ବେନଡ଼୍ ଆଦ୍ ଦାର୍ମିକ୍ ନାରୁଣ୍ଡ୍‍ ୱାଦାନ୍ ବିଷୟ୍ ମୁନେଙ୍କ୍ କେସ୍‍ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଡ଼୍‌ ହାୱ୍‍କ୍‍ତଡ଼୍; ଇଞ୍ଜେ ମିଡ଼୍ ଅଂକିଙ୍କ୍‌ ଶତ୍ରୁଡ଼୍ କାୟିଦେ ସମର୍‍ପନ୍ ମାଡ଼ି ହାୱ୍‍କ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ମିଡ଼୍ ଦୂତଡ଼୍ ହିତ୍‍ତାଦ୍ ଇଶ୍ୱର୍‌ତେ ନିତିନିୟମ୍ ସାରେ ପାଏମ୍‍ଆତ୍‍ତିଡ଼୍, ଆଗେକ୍‍ବା ଆଦିଙ୍କ୍ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ପାଲନ୍ ମାଡ଼୍‍ୱିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ବେଡ଼ିୟ୍‍ମିଟିଙ୍କ୍‍ତେ ସଦସ୍ୟଡ଼୍ ସ୍ତିଫାନ୍‍ତେ ବାଷନ୍ କେଞ୍ଜି ଗାଟି କପାମ୍ ଆତ୍‍ତଡ଼୍, ମେଣ୍ଡେ ଅଡ଼୍‌ ଅନ୍‌ ସେଙ୍ଗେ ପାଲ୍‍କ୍ କର୍‍କ୍‌ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ବାତେଙ୍କ୍ ଇତ୍‍କେ ସ୍ତିଫାନ୍ ପବିତ୍ର ଆତ୍ମାତେ ଗୌରବମୟ ଆସ୍ ସ୍ୱର୍ଗତା ଉଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଇଶ୍ୱର୍‌ତେ ମହିମା ନୁ ଜିସୁଙ୍କ୍ ତିନ୍ଦେପାକ୍ ନିଶ୍‍ମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଉଡ଼ାଟ୍, ନାନ୍ ସ୍ୱର୍ଗତିଙ୍କ୍ କୁଲା ଆତ୍‍ତାଦ୍ ନୁ ନାରୁଣ୍ଡ୍‍ ପିଲେ ଇଶ୍ୱର୍‌ତେ ତିନ୍ଦେପାକ୍ ନିଶ୍‍ମାନ୍ଦାନାଦ୍ ଉଡ଼ୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ଗାଟି ଲେଙ୍ଗ୍‍ଦେ ମିଟିଙ୍ଗ୍‍ତେ ବେଡ଼୍‍ୟେ ନାରୁଡ଼୍ ଇଦ୍ ଗଟ୍ କେଞ୍ଜମ୍ ଇଞ୍ଜ କେୱ୍‍କିଙ୍କ୍ କାୟିକିନ୍‍ତଡ଼୍ ବନ୍ଦ୍ ମାଡ଼୍‍ତଡ଼୍ । ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଅଣ୍ଡୟ୍‌‍ତଡ଼୍ ଅନ୍‌ ବକେତ୍ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ସହରତେ ବାୟିଦେ ଅଂକିଙ୍କ୍‌ ଲାଗି ଅସ୍, ଅନ୍‌ ପର୍‍ କାଲ୍‍କ୍ ହେସି ହାୱକ୍‍ତଡ଼୍ । ମିଚ୍‍ ସାକ୍ଷୀଡ଼୍ ଶାଉଲ୍‍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଲେୟଣ୍ଡ୍‍ତେ ଡେକେତ୍ ବକେତ୍ ଅଡ଼ାୱୁ ସାରେ ଚକା ୱିଡ଼୍‍ସି ଆଞ୍ଜ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ଅଡ଼୍‌ ସ୍ତିଫାନ୍‍ତେ ପର୍‍ କାଲ୍‍କ୍ ହେସାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ପ୍ରବୁଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ ଜିସୁ, ନାୱାଦ୍ ଆତ୍ମାତିଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ଅଣ୍ଡ୍‌ ମର୍‍ମିଣ୍ଡା ଉୱୁସ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ ! ଇଡ଼୍ ବିରୁଦ୍‍ତେ ଇଦ୍ ପାପ୍ ଏର୍କା ମାଡ଼୍‍ମାଟ୍ ।” ଇଦ୍ କେସ୍ ଅଣ୍ଡ୍‌ ଡଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ଶାଉଲ୍‍ ସ୍ତିଫାନ୍‍ତେ ଡଲାନାଦିଙ୍କ୍ ସମର୍ତନ୍ ମାଡ଼୍‍ତନ୍ । ଆଦ୍ ଦିନେକନ୍ସ୍ ଯିରୁଶାଲେମ୍‍ତେ ମଣ୍ଡଲି ସେଙ୍ଗେ ତାଡ଼ନା ଆରାମ୍ ଆତ୍‍ତେ । ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ ୱିଡ଼୍‍ସି ମେଣ୍ଡେ ସାରେତଡ଼୍ ବିଶ୍ୱାସୀଡ଼୍ ଯିହୁଦା ନୁ ଶମିରୋମ୍ ଦେଶ୍‍ତେ ପଡ଼ିୟେତାଗ୍ ୱେକ୍‍ୱେକ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଇଶ୍ୱର୍‌ତେ ବକ୍ତନଡ଼୍‌ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେୟିମିକା ସ୍ତିଫାନ୍‍ତେ ମଡ଼୍‍ତିଙ୍କ୍ ସମାଦି ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ବାତେଙ୍କ୍ ଇତ୍କେ ଶାଉଲ୍‍ ମଣ୍ଡଲିତିଙ୍କ୍ ଦଂସ ମାଡ଼ାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼୍‍ତଣ୍ଡ୍, ଲକ୍ ଲକ୍ ଆଞ୍ଜ୍ କ୍ରିଷ୍ଟ ବିଶ୍ୱାସୀ ମାନେୟ୍‍ ନାଟାଙ୍କ୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଲାଗିତାସ୍ ଜଇଲ୍‍ତାଗ୍ ତୁର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ୱେକ୍ ୱେକ୍ ଆତ୍‍ତେ ବିଶ୍ୱାସିଡ଼୍ ସାରେଏକାମ୍ ଆଞ୍ଜ୍ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ଶମିରୋମ୍ ମୁକ୍ୟ ନାର୍‍ତାଗ୍ ଆଞ୍ଜ୍ ଫିଲିପ୍‍ପ, ଆଗେତ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ମସୀହାନାଦ୍ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ଫିଲିପ୍‍ପନ୍‍ ଗଟି କେଞ୍ଜି ନୁ ଅନ୍‌‍ୱାଦ୍ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ଉଡ଼ି ନାରୁଡ଼୍ ମେଣ୍ଡେ ଅଦିକ୍‌ ଗଟି କେଞ୍ଜାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ନାର୍‍ଗେ ନାରୁଡ଼ାଗାଙ୍କ୍ ବୁତ୍‌କ୍ କିଡ଼୍‍କି କିଡ଼୍‍କି ପେଇସ୍ ଆତ୍‍ତା, ନାର୍‍ଗେ ପକ୍ୟାଗାତ୍ ରଗି ନୁ କୁଟାଲଡ଼୍ ସୁସ୍ଥ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ଇଦିନ୍ ସେଙ୍ଗେ ଆଦ୍ ନଗର୍‍ତେ ନାରୁଡ଼୍ ଗାଟି ୱେଡ଼୍‍କ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ଶିମୋନ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ଅନ୍‌‍ୱାଦ୍ ମନ୍ତ୍ର ବିଦ୍ୟାତଡ଼୍ ଆଦ୍ ଦେଶ୍‍ତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଆଶର୍ଯ୍ୟ ମାଡ଼ି ନେହେସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ନିଜେତିଙ୍କ୍ ୱେରଣ୍ଡ୍ ବେଡ଼୍‍ୟେ ନାରୁଡ଼୍ ଇଞ୍ଜ କେସ୍ ସମରୀୟାତେ ସାରେ ନାରୁଡ଼୍‍କିନ୍ ଲୋପେଙ୍କ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ଅଣ୍ଡ୍‌‍ ନିଜ୍‍ତିଙ୍କ୍‍ ଅର୍‍ତୁଣ୍ଡ୍‍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ଇଞ୍ଜ୍‍ କେସ୍‍ ସମାଜ୍‍ତେ ସାରେ ନାରୁଡ଼୍‍ ଲୋପେଙ୍କ୍‍ ବାଡ଼୍‍ୟଣ୍ଡ୍‍ ଆସ୍‍ମାତ୍‍ତଣ୍ଡ୍‍ । ଅଡ଼୍‌ କେସ୍‍ମାତ୍‍ତଡ଼୍, “ଅଣ୍ଡ୍‌ ‘ମହାଶକ୍ତି’ ପେଦେର୍‍ତଣ୍ଡ୍ ଇଶ୍ୱର୍‌ତେ ଅଣ୍ଡୟ୍‌ ଶକ୍ତି ।” ");
INSERT INTO kff_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ଆଦ୍ ମନ୍ତ୍ର ବିଦ୍ୟାତଡ଼୍ ନାର୍‍ଗେ ଦିନ୍ ଯାକ ଶମିରୋଣ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ତାନ୍ ଶିଷ୍ୟ ମାଡ଼ି ନେହେସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଫିଲିପ୍‍ପ ପେଦେର୍‍ ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ନୁ ଜିସୁ କ୍ରିଷ୍ଟନ୍ ବିଷୟ୍‍ତେ ସୁସମାଚାର୍‍ କେଞ୍ଜି, ଅନ୍‌ ସେଙ୍ଗେ ନାରୁଡ଼ାଦ୍ ବିଶ୍ୱାସ୍ ଜନମ୍ ଆତ୍‍ତେ ନୁ ଆଦ୍ ଜାଗେତ୍‍ ସାରେ ନାଟା ନୁ ମାନେୟ୍‍ ଏର୍‍ଦିକ୍ୟା ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଶିମୋନ୍ ନିଜେ ଆଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଫିଲିପ୍‍ପ ତଡ଼୍ ମାଡ଼ିମାନ୍ଦାନ୍ ଆଦ୍‍ବୁତ୍‌ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ଉଡ଼ି ଅଣ୍ଡ୍‌ ଏର୍‍ଦିକ୍ଷା ଗ୍ରହନ୍‍ ମାଡ଼ି ଫିଲିପ୍‍ପ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମରୀୟାତେ ନାରୁଡ଼୍ ଇଶ୍ୱର୍‌ତେ ଗଟ୍ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍ ଇଞ୍ଜ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ କେଞ୍ଜି, ପିତର୍ ନୁ ଯୋହନ୍‌‌ତିଙ୍କ୍ ଅଡ଼୍‌ ଗାର୍‍ରେ ରହତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ଅଡ଼୍‌ ଆଗେ ଏୱୁତ୍‍ତେ ପେର୍‍କେ ଶମିରୋନୀୟ ବିଶ୍ୱାସୀଡ଼୍ ବେଲା ପବିତ୍ର ଆତ୍ମା ଦର୍‍କିତ୍, ଆଦିନ୍ ସେଙ୍ଗେ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆସୁଟ୍‍ ଯାକ ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେନ ପର୍‍ର ପବିତ୍ର ଆତ୍ମା ଡିଗ୍‍ୱେ ମାତ୍‍ତେ । ଅଡ଼୍‌ ମାତର୍ ଜିସୁ ପ୍ରବୁନ୍‌ ପେଦେର୍‍ତେ ଏର୍‍ଦିକ୍ଷା ଗ୍ରହନ୍ ମାଡ଼ି ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ପିତର୍ ନୁ ଯୋହନ୍‌ ଅଡ଼୍‌ ପର୍‍ର କାୟି ୱାଟ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଅଡ଼୍‌ ପବିତ୍ର ଆତ୍ମା ପାଏମ୍‍ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ଶିମୋନ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ ଯେ, ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ବିଶ୍ୱାସୀଡ଼୍ ପର୍‍ର କାୟ୍‍ ୱାଟ୍‍ତାଙ୍କ୍ ଅଡ଼୍‌ ପବିତ୍ର ଆତ୍ମା ପାଏମ୍‍ଆତ୍‍ତଡ଼୍ । ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ପିତର୍ ନୁ ଯୋହନ୍‌‌ତିଙ୍କ୍ ଡାବ୍‍କ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ନାନ୍ ବାଗାତ୍ ନାରୁଡ଼୍ ପର୍‍ର କାୟ୍‍ ୱାଟ୍‍କେ, ଅଡ଼୍‌ ବେଲାକି ପବିତ୍ର ଆତ୍ମା ଦର୍‍କିତ୍, ଆଦିଙ୍କ୍ ନାକିଂଙ୍କ୍ ଇଦ୍ ଅଦିକାର୍‌‍ ହିମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପିତର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ନି ତଡ଼୍ ନିୟାୱୁ ଡାବ୍‍କ୍ ଗାଲା ଦସଂ ହାୟି, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଡାବ୍‍କ୍ ତଡ଼୍ ନିମ୍‍ ଇଶ୍ୱର୍‌ତେ ଦାନ ହାସାନଙ୍କ୍ ହାଲ୍‍ସୁତି ! ");
INSERT INTO kff_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ମାୱାଦ୍ ପଡ଼୍‍ୟେତାଗ୍ ନିୱାଦ୍ ବାତ୍‍ମିକା ବାଗ୍‍ ଇଲ୍‍ଲେ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ କଣ୍ଡେତେ ନିୱାଦ୍ ହୃଦୟ୍ ସାୟେ ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ଆଦିଙ୍କ୍ ନିୱାଦ୍ ହୃଦୟ୍ ତାଦ୍‍ ଇଦ୍ କାରାପ୍ ଚିନ୍ତେ ସେଙ୍ଗେ ହେର୍କେ ମାଡ଼ାଟ୍‍, ଇଦ୍ ରକମ୍ ଚିନ୍ତେ ମାଡ଼ିମାନ୍ଦାନଙ୍କ୍ ପ୍ରବୁ ବେଲା କ୍ଷମା ମାଡ଼ିତନ୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ପ୍ରବୁଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼େ । ");
INSERT INTO kff_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଉଡ଼ୁତାନ୍ ଯେ ନିୱାଦ୍ ହୃଦୟ୍ ଇର୍ଷାତଡ଼୍ ବର୍ତ୍ତି ଆତ୍‍ତେ, ନିମ୍‍ କାରାପ୍ ପାଡ଼୍‍ୟି ତଡ଼୍‍ ବନ୍ଦନ୍‍ତାଗ୍ ବନ୍ଦି ହାସ୍‍ମିନ୍ଦେନି ।” ");
INSERT INTO kff_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ଶିମୋନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବାତ୍ କେତୁତିଡ଼୍, ଆଦ୍ ବେଲାକି ନା ପର୍‍ର ୱାଡ଼୍‍ମାକି, ଇଦିନ୍ ସେଙ୍ଗେ ଦୟାମାଡ଼ି ପ୍ରବୁଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ସାକ୍ଷ୍ୟ ଇସ୍‌ ନୁ ପ୍ରବୁନ୍ ସୁସମାଚାର୍‍ କେତ୍‍ତାନ୍ ପିତର୍ ନୁ ଯୋହନ୍‌ ଯିରୁଶାଲେମ୍‍ତାକ୍ ମାଲ୍‍ସ୍ ଆଦ୍‍ତଡ଼୍ । ମାଲ୍‍ସ୍ ୱାଦାନ୍ ୱେଲେ ହାର୍‍ଦାଗ୍ ଅଡ଼୍‌ ଶମିରୋଣ ଦେଶ୍‍ତେ ନାର୍‍ଗେ ନାଆକି ନାଗ୍‍ ସୁସମାଚାର୍ କେତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ପ୍ରବୁନ୍‍ ୱେରଣ୍ଡ୍ ଦୂତ୍ ଫିଲିପ୍‍ପତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ତିଆର୍ ଆସ୍ ମାନୁଟ୍, ତିନ୍ଦେପାକ୍ ଯିରୁଶାଲେମ୍‍ କନ୍‍ସ୍ ଗାଜାତାକ୍ ଆତ୍‍ତେ ଆଦ୍‍ ହାର୍‍ ଆନୁଟ୍ ।” ଇଞ୍ଜେ ଆଦ୍ ହାର୍‍ଦାଗ୍ ବେନଗାଲା ଆଦ୍‍ଦା ୱାଦା ମାଡ଼ଣ୍ଡ୍ । ଆଦ୍‍ ପଡ଼୍‍ୟେତାଗ୍‍ ବେନ ଇଲ୍‍ୱେମାତ୍‍ତଣ୍ଡ୍‍ । ଇଞ୍ଜେ ଆ ଆର୍‍ ବେନ ଅନ୍‌‍ନଡ଼୍ ବା ବ୍ୟବହାର୍‍ ମାଡ଼ଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ଫିଲିପ୍‍ପ ତିଆର୍ ଆତ୍‍ତଣ୍ଡ୍ । ଆସୁଟେ ଇଥିଓପିଆତ୍ ରାଜ୍ୟତେ କାଣ୍ଡକି ରାଣୀନ୍ ରାଜତିଙ୍କ୍ ଶାସନ୍‍ ମାଡ଼ନଣ୍ଡ୍ ମାନ୍ଦାନ୍ ଇଥିଓପିଆତେ ୱେରଣ୍ଡ୍ ୱାଞ୍ଜାଲ୍ କର୍ମଚାରୀ ତାନ୍ ଲୋନ୍‌ ମାଲ୍‍ସ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପୁଜା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଯିରୁଶାଲେମ୍‍ ଆଞ୍ଜ୍‍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ଅଣ୍ଡ୍‌‍ ଆଦ୍ ରତ୍‌ତାଗ୍ କୁଦି ଲୋନ୍‌ ମାଲ୍‍ସ ମାତ୍‍ତଣ୍ଡ୍ । ଆଦ୍ ରତ୍‌ତାଗ୍ ମାଲ୍‍ଦାନ୍ ୱେଲେ ଯିଶାଇୟ ବାବବାଦୀ ବଇ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କାର୍‍ସ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ପବିତ୍ର ଆତ୍ମା ଫିଲିପ୍‍ପଙ୍କ କେତ୍‍ତେ, “ଆଦ୍ ରତ୍‍ତେ ବକେତ୍ ଅନ୍‌ ନୁ ଆଦିନ୍ ଗାର୍‍ରେ ମାନ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ଫିଲିପ୍‍ପ ମିରି ମିରି ଆତ୍‍ତଣ୍ଡ୍ ନୁ ଆ କର୍ମଚାରୀ ଯିଶାଇୟ ବାବବାଦୀନ୍ ବଇ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କାର୍‍ସ ମାନ୍ଦାନାଦ୍ କେଞ୍ଜ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବାତ୍ କାର୍‍ତୁତି, ଆଦ୍ ବୁଜେମ୍ ଆଦୁତି କି ?” ");
INSERT INTO kff_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","କର୍ମଚାରୀ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ବେନ ଅନୁରଦ୍‌‍ ମାଡ଼ାନାଦ୍‍ ୱେରଣ୍ଡ୍ ବୁଜାମାଡ଼ିୱ କଟ ମାତ୍କେ, ନାନ୍ ବେଲା ବୁଜେମ୍ ଆଦ୍‍ତାନ୍ ?” ତାନ୍‍ତଡ଼୍ ରତ୍‌ତାଗ୍ କୁଦାନ୍‍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଫିଲିପ୍‍ପତିଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ଅଣ୍ଡ୍‌ ଦର୍ମଶାସ୍ତ୍ରତାଦ୍ ଇଦ୍ ବିଷୟ୍ କାର୍‍ସ୍ ମାତ୍‍ତଣ୍ଡ୍; “ହାୱ୍‍କାନ୍ ମାଇଦିଙ୍କ୍ ଆଦାନ୍ ମେଣ୍ଢା ଲେକାମ୍, କେଲ୍‍କ୍ କୟ୍‍ଦାନ୍‍ ୱେଲେ କଟମାନ୍ଦାନ୍ ମେଏଣ୍ଡେ ଲେକାମ୍, ଅଣ୍ଡ୍‌ ଅଣ୍ଡୟ୍‌ ପଦ୍‍ବା ଗଟ୍‍ ତିର୍‍ୟଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ଅଣ୍ଡ୍‌ ଅପମାନିତ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ନ୍ୟାୟତାଗାଙ୍କ୍ ବଞ୍ଚେମ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ତାମ୍ ବଂଶତଡ଼୍‍ ବିଷୟ୍‍ତେ ବେନ ବାଆତେ କେତାଙ୍କ୍ ପାର୍‍ୱଡ଼୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ପୃତିବିତାଗ୍ ଅଡ଼ାଦ୍‌ ଜିୱୁଣ୍ଡ୍ ତେରି ଆତ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ୱାଞ୍ଜାଲ୍‍ କର୍ମଚାରୀ ଫିଲିପ୍‍ପତିଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ବାବବାଦୀ ବେନ ବିଷୟ୍‍ତେ ପ୍ରାର୍ତନା ମାଡ଼ୁତଣ୍ଡ୍, ନାକିଂଙ୍କ୍ କେଲାଟ୍ । ତାନ୍ ନିଜେତ୍ ବିଷୟ୍‍ତେ ନା ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ବିଷୟ୍‍ତେ ?” ");
INSERT INTO kff_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ଫିଲିପ୍‍ପ ଦର୍ମଶାସ୍ତ୍ରତେ ଇଦ୍ ବାକ୍ୟତାଗାଙ୍କ୍ ଆରାମ୍ ମାଡ଼ି ଜିସୁନ୍ ବିଷୟ୍‍ତେ କେତ୍‍ତାଦ୍ ସାରେ ସୁସମାଚାର୍‍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ଅଡ଼୍‌ ହାର୍‍ଦାଗ୍ ଆଦାନ୍ ୱେଲେ ଅଣ୍ଡୟ୍‌ ଏର୍‍ୱେତାଗ୍ ଏୱୁତ୍‍ତଡ଼୍ । ୱାଞ୍ଜାଲ୍‍ କର୍ମଚାରୀ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“ଇଗେ ଏର୍‍ ମିନ୍ଦା, ଇଞ୍ଜେ ନାକିଂଙ୍କ୍ ଏର୍‍ଦିକ୍ଷା ଆଦାନଙ୍କ୍ ବାତ୍ ଅସୁବିଦା ମିନ୍ଦ୍‍ କି ?” ");
INSERT INTO kff_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ୱାଞ୍ଜାଲ୍‍ କର୍ମଚାରୀ ରତ୍‌ତିଙ୍କ୍ ନିଲ୍‍ସ୍ପାନଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଫିଲିପ୍‍ପ ନୁ କର୍ମଚାରୀ ଏର୍‍ଦେ ଲୋପେ ଆତ୍‍ତଡ଼୍ ନୁ ଫିଲିପ୍‍ପ ଅଂକିଙ୍କ୍‌ ଏର୍‍ଦିକ୍ଷା ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ଅଡ଼୍‌ ଏର୍‍ତାଗାଙ୍କ୍ ତେଦି ୱାତ୍‍ତେ ପେର୍‍କେ ପ୍ରବୁନ୍‍ ପବିତ୍ର ଆତ୍ମା ଫିଲିପ୍‍ପଙ୍କ୍ ମାପିତ୍‍ତେ । କର୍ମଚାରୀ ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ଉଡ଼ାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ କୁସି ଆସ୍ ତାନ୍ ହାର୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ବେସ୍‍କେ ଦିନାତ୍‍ ପେର୍‍କେ ଫିଲିପ୍‍ପ ଉଡ଼୍‍ତଣ୍ଡ୍ ଜେ ଅଣ୍ଡ୍‌ ଅସଦୋଦତାଗ୍ ଏୱୁତ୍‍ତଣ୍ଡ୍ । ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ କାଇସରିଆତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ହାର୍‍ଦାଗ୍ ମାନ୍ଦାନ୍ ଟାଉନ୍‍କିନାଗ୍ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ଇଦ୍ ସମୟ୍‍ତେ ଶାଉଲ୍‍ ପ୍ରବୁନ୍ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ ଆୱ୍‍କିତାନ୍ ଇଞ୍ଜ ଦମକ୍ ଇସମାତ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ମହା ଯାଜକ୍‍ତେ ଗାର୍ରେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଦାମାସ୍‍କସ୍‍ତେ ଉପାସନା ଲଅକିନାଗ୍ ପ୍ରବୁନ୍‍ ଆର୍‍ଦିଙ୍କ୍ ୱାସମାନ୍ଦାନ୍‌ ନାରୁଡ଼୍‌ ବନ୍ଦିମାଡ଼ି ଯିରୁଶାଲେମ୍‍ତାଗ୍ ତାତାନ୍ ମାଇଦିଙ୍କ୍ ବେଡ଼ିୟି ଯାଜକ୍‍କନ୍ସ୍ ଆନୁମତି ଚିଟି ତାଲ୍‍କ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ଶାଉଲ୍ ଦାମାସ୍‍କସ୍‍ ଟାୱୁନ୍ ଗାର୍‍ରେ ଏୱୁଦାନ୍‍ ୱେଲେ ହଟାତ୍ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ୱେସ୍ ଅନ୍‌ ସାରେପାକ୍ ୱେସ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ଅଣ୍ଡ୍‌ ବୂମ୍‌ଦାଗ୍‍ ରାୟ୍‍ତଣ୍ଡ୍ ନୁ ଅଣ୍ଡୟ୍‌‍ଗଟ୍ କେଞ୍ଜ୍‍ତଣ୍ଡ୍, “ଶାଉଲ୍ ! ନିମ୍‍ ବାତେଙ୍କ୍ ନାକିଂଙ୍କ୍ ଗାଟିତିପାଲ୍ ମାଡ଼ୁତି ?” ");
INSERT INTO kff_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ ନିମ୍‍ ବେନ ?” ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଆଦେ ଗଟ୍ କେଞ୍ଜ୍‍ତଣ୍ଡ୍, “ନିମ୍‍ ବେନଙ୍କ୍ ଗାଟିତିପାଲ୍ ମାଡ଼ୁତିନ୍, ନାନ୍ ଅଣ୍ଡେ ଜିସୁ । ");
INSERT INTO kff_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ତେଦ୍‍ଦେ ଟାୱୁନ୍‍ତାଗ୍ ଅନ୍‌, ବାତ୍ ମାଡ଼ାନଙ୍କ୍ ଆଦ୍‍ତେ, ଆଗେ ନିକିଂଙ୍କ୍ କେସିଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ବେନଡ଼୍‍ କି ଶାଉଲ୍‍ତେ ତଡ଼୍‍ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍‍ ଅନ୍‌‍ ସାଙ୍ଗଡ଼୍ ଉଡ଼ି ବାକୁୱାହାସ୍ ନିତ୍‍ତଡ଼୍; ଅଡ଼୍‌ ଆଦେ ଗଟ୍ କେଞ୍ଜ୍‍ତଡ଼୍, ଇତ୍‍କେ ବେନଙ୍କ୍ ଉଡ଼ାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ଶାଉଲ୍‍ ବୂମ୍‌ ତାଗାଙ୍କ୍‍ ତେଦି ଉଡ଼୍‍ତଣ୍ଡ୍, ଇତ୍‍କେ ଅଂକିଙ୍କ୍‌ ବାଆତେ ତଅନ୍‌ଦ । ଆଦିଙ୍କ୍ ଅଡ଼୍‌ କାୟ୍‍ଦିଙ୍କ୍ ପୟ୍‍ସ୍ ଦାମାସ୍‍କସ୍‍ ଏୱୁନା ଆର୍ ତଅସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ମୁଣ୍ଡ୍ ଦିନା ଯାକ ଅଣ୍ଡ୍‌ ଉଡ଼ାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ ନୁ ଆଦ୍ ଦିନାମ୍ ତିନ୍ଦାନ୍ ଉନ୍ଦାନ୍ ମାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦାମାସ୍‍କସ୍‍ ହନନୀୟ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ କ୍ରିଷ୍ଟ ବିସ୍ୱାଶି ଶିଷ୍ୟ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ୱେରଡ଼୍ ଦର୍ଶନ୍ ଉଡ଼୍‍ତଣ୍ଡ୍, ପ୍ରବୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ହନନୀୟ !” ଅଣ୍ଡ୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ହୋ ପ୍ରବୁ କେଲ୍‍ମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ପ୍ରବୁ କେତ୍‍ତଣ୍ଡ୍, “ସାୟେ ଆୟ୍‍ମୁଟ୍ । ‘ତିନାଙ୍କ୍’ ପେଦେର୍‍ତେ ରଟ୍ ପୟ୍‍ସ୍ ଯିହୁଦାନ୍ ଲନ୍‍ ଆନୁଟ୍ । ଆଗେ ତାର୍ଷିସ୍‍ କନ୍‍ସ୍ ୱାତ୍‍ତେ ୱେରଣ୍ଡ୍ ଶାଉଲ୍‍ ପେଦେର୍‍ତଣ୍ଡ୍ ନାରୁଙ୍କ୍ ମେହେକାଟ୍ । ଅଣ୍ଡ୍‌ ପ୍ରାର୍ତନା ମାଡ଼ୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ହନନୀୟ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ ୱାସ୍ ଅନ୍‌ ପର୍‍ର କାୟ୍‍ ୱାଟ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ବେଲା ଉଡ଼୍‍ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍‍ ଇଞ୍ଜ ଦର୍ଶନ୍ ଉଡ଼୍‍ତଣ୍ଡ୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ହନନୀୟ କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ, ଇଣ୍ଡ୍ ପବିତ୍ର ନାରୁଣ୍ଡ୍‍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ନି ନାରୁଡ଼୍ ସେଙ୍ଗେ ବେନ୍‍ସାରେ କାରାପ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍, ଆଦ୍ ବିଷୟ୍‍ତେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ନାକିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ମୁକ୍ୟ ଯାଜକ୍‍ତାଗାଙ୍କ୍ ଅଦିକାର୍‌‍ ଚିଟି ଆସ୍, ଦାମାସ୍‍କସ୍‍ ପେଦେର୍‍ତାଗ୍ ନିକିଂଙ୍କ୍ ଉପବାସ୍ ମାଡ଼ାନଡ଼୍‍କିଙ୍କ୍ ପୟ୍‍ସ୍ ଆଦାନ୍ ସେଙ୍ଗେ ୱାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ପ୍ରବୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଅନ୍‌, ଇସ୍ରାଏଲ୍‍ ନାରୁଡ଼୍ ନୁ ଅଣଇହୁଦୀ ନୁ ରାଜାଲଡ଼୍ ମୁନ୍‍ନେ, ନା ପେଦେର୍ କେତାନଙ୍କ୍ ନୁ ନାୱାଦ୍ ସେବା ମାଡ଼ାନଙ୍କ୍ ନାନ୍ ଅଂକିଙ୍କ୍‌ ହେଞ୍ଚ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ନା ପେଦେର୍‍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ବେନ୍ ସାରେ କଷ୍ଟ ପାଏମ୍ ଆଦ୍‍ତନ୍, ନାନ୍ ନିଜେ ଅଂକିଙ୍କ୍‌ କେତିତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ହନନୀୟ ଆତ୍‍ତଣ୍ଡ୍, ଶାଉଲ୍ ମାନ୍ଦାନ୍ ଲନ୍‍ ହସିମିକା ଅନ୍‌ ପର୍‍ର କାୟ୍‍ ୱାଟ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ବିଶ୍ୱାସୀ ଦାଦାଲ୍‌ ଶାଉଲ୍, ଇଗେ ୱାଦାନ୍ ମୁନେଙ୍କ୍‌ ନାକିଙ୍କ୍‌ ପ୍ରବୁ ଜିସୁ ନାକିଂଙ୍କ୍ ଦର୍ଶନ୍ ହିତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନାକିଂଙ୍କ୍ ରହତ୍‍ତଣ୍ଡ୍, ବେଲାକି ନିମ୍‍ ମେଣ୍ଡେ ଦୃଷ୍ଟି ପାଏମ୍‍ଆଦ୍‍ତି ନୁ ପବିତ୍ର ଆତ୍ମାତଡ଼୍ ବର୍ତ୍ତି ଆଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଶାଉଲ୍‍ତେ କଣ୍ଡ୍‍ତାଗାଙ୍କ୍ କିକେ ଉୟ୍‍କା ଲେକାମ୍ ବାତ୍ ରାୟ୍‍ତେ ନୁ ଅଣ୍ଡ୍‌ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଉଡ଼ାନଙ୍କ୍ ପାର୍‍ତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ତେଦି ଏର୍‍ଦିକ୍ଷା ଗ୍ରହନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ନୁ ଦାମାସ୍‍କସ୍‍ତିଙ୍କ୍ ତିନ୍ଦାନ୍ ଉନ୍ଦାନ୍ ମାଡ଼୍‍ନାଦ୍‍ ଶକ୍ତି ଦର୍‍କ୍‍ତେ । ଶାଉଲ୍‍ କ୍ରିଷ୍ଟ ବିଶ୍ୱାସି ଶିଷ୍ୟଡ଼୍ ତ ବେସ୍‌କ୍ ଦିନା ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ଅଣ୍ଡ୍‌ ସିଦା ଉପାସନା ଲୋକିନାଗ୍ ଆଞ୍ଜ୍ ଜିସୁ ଇଶ୍ୱର୍‌ତେ ମାର୍‍, ଇଦ୍ ଗଟ୍ ପ୍ରଚାର୍ ମାଡ଼ାଙ୍କ୍ ପସ୍‍ପ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ବେନଡ଼୍ ଅନ୍‌ ଗଟି କେଞ୍ଜ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଦାଦ୍‍ରିଲି ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, “ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଜିସୁନ୍‍ ପେଦେର୍‍ତେ ଉପବାସ୍ ମାଡ଼ାନଡ଼୍‍କିଙ୍କ୍ ବେନ ହାୱ୍‍କ ମାତ୍‍ତଣ୍ଡ୍, ଇଣ୍ଡ୍ ଅଣ୍ଡ୍‌ ଆୟନ୍ କି ? ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମୁକ୍ୟ ଯାଜକ୍‍ତେ ବକେତ୍ ପୟ୍‍ସ୍ ଆଦାନଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଗେ ଦାମାସ୍‍କତା ୱାସ୍ ମାନଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଶାଉଲ୍‍ତେ ପ୍ରଚାର୍ ଗାଟି ଶକ୍ତି ମାତ୍‍ତେ, ଜିସୁ ହୋ ମସୀହା, ଇଦ୍ ବିଷୟ୍‍ତେ ଅନାଦ୍‌ ପ୍ରମାନ୍‍ ଗାଟି ଯୁକ୍ତି ମାତ୍‍ତେ ଜେ ଦାମାସ୍‍କସ୍‍ତାଗ୍ ବାସେ ମାଡ଼ାନଡ଼ି ଇହୁଦୀଡ଼୍, ଅନାଦ୍‌ ବେନ୍ ଗଟ୍‍ତେ ମିକା ଉତ୍ତର୍ ହିଦାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ନାର୍‍ଗେ ଦିନ୍ ଆତ୍‍ତେ ପେର୍‍କେ ଇହୁଦୀଡ଼୍ ଅଣ୍ଡୟାଗେ ଆସ୍ ଶାଉଲ୍‍ତିଙ୍କ୍ ହାୱ୍‍କାଙ୍କ୍ ସେଙ୍ଗେ ହାଲ୍‍ସ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ଶାଉଲ୍‍ତିଙ୍କ୍ ଆୱୁକାନଙ୍କ୍ ନାର୍‍କେତ୍ ପାୟାଲ୍ । ଅଡ଼୍‌ ନାର୍ ମାର୍ ସାରେତାଗ୍ କେପିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ବାତେଙ୍କ୍ ଇତ୍କେ ଅଣ୍ଡ୍‌ ଦିନ୍ ନାର୍କେତ୍‍ ୱେଲେ ଶାଉଲ୍‍ତେ ଶିଷ୍ୟଡ଼୍ ଅଂକିଙ୍କ୍‌ ୱେରଡ଼୍ ଜୁଡ଼ିତାଗ୍ ୱାଟି ପାଚେରିତ୍‍ କୁଲାମାନ୍ଦାନ୍‍ ଜର୍‌କାତାଲାନ୍‌ ମଦଲ୍ ରାପିତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ଶାଉଲ୍‍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଆଞ୍ଜ୍ ତାମ୍ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ କାଇଲାନଙ୍କ୍‍ ଆଲ୍‍ସି ମାଡ଼୍‍ତଣ୍ଡ୍ । ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଶିଷ୍ୟ ଇଞ୍ଜ ଅଡ଼୍‌ ବିଲ୍‍କୁଲ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ଡ଼୍‍ । ସାରେତଡ଼୍ ଅଂକିଙ୍କ୍‌ ୱେର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପେର୍‍କେ ବର୍ଣ୍ଣବା ଅଂକିଙ୍କ୍‌ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼ାଗ୍ ଆସ୍ ଦାମାସ୍‍କସ୍‍ ହାର୍‍ଦାଗ୍ ଶାଉଲ୍‍ ବେଲା ପ୍ରବୁନ୍ ଦର୍ଶନ୍ ପାଏମ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ପ୍ରବୁ ବେଲା ଅଂକିଙ୍କ୍‌ ଗଟି ତିରିୟି ମାତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ସାରେ ବିଷୟ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବୁଜା ମାଡ଼୍‍ତଣ୍ଡ୍ । ଦାମାସ୍‍କସ୍‍ତାଗ୍ ଜିସୁନ୍ ପେଦେର୍‍ତେ ଶାଉଲ୍‍ ବେଲା ୱେର୍‍ୱେକନ୍ସ୍ ପ୍ରଚାର୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାୟେ ତିଆର୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ଇଦିନ୍ ପେର୍‍କେ ଶାଉଲ୍‍ ପ୍ରେରତ ଶିଷ୍ୟଡ଼୍ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ସାରେ ଏକାମ୍ ଆଞ୍ଜ୍ ସାହାସ୍ ତଡ଼୍ ପ୍ରବୁନ୍ ପେଦେର୍‍ତେ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ଇଦ୍ ସାରେ ବିଷୟ୍‍ତେ ଅଣ୍ଡ୍‌ ଗ୍ରୀକ୍‍ ଗଟ୍‍ତଡ଼୍‍ ଇହୁଦୀଡ଼୍ ତଡ଼୍ ମିକା ତର୍କବିତର୍କ ମାଡ଼୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଆୱୁକାନଙ୍କ୍ ଆଲ୍‍ସି ମାତ୍‍ଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ବିଶ୍ୱାସୀଡ଼୍ ଦାଦାଲ ଇଦ୍ ଗଟ୍ ପୁଞ୍ଜ୍ ମିକା, ଶାଉଲ୍‍ତିଙ୍କ୍ କାଇସରିଆତାଗ୍ ଆତ୍‍ତଡ଼୍ ନୁ ଆଗାଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ତାର୍ଷିସ୍‍ତାଗ୍ ରହସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଯିହୁଦା, ଗାଲିଲୀ ନୁ ଶମିରୋତାଗ୍ ମାନ୍ଦାନ୍ କ୍ରିଷ୍ଟୀୟ ମଣ୍ଡଲି ଆଦ୍ ସମୟ୍‍ତେ ଶାନ୍ତି ମାତ୍‍ତେ ନୁ ପବିତ୍ର ଆତ୍ମାତ୍‍ ସାର୍‍ଦେତଡ଼୍ ଅଡ଼ାଦ୍‌ ନାରୁଡ଼୍ ସଂଖ୍ୟା ନାର୍ଗେ ଆତ୍‍ତେ ନୁ ଅଡ଼୍‌ ଶକ୍ତିନଡ଼୍ ଆତ୍‍ତଡ଼୍ । କ୍ରିଷ୍ଟ ବିଶ୍ୱାସୀଡ଼୍ ପ୍ରବୁଙ୍କ୍ ୱେର୍‍ସ୍ ମିକା ବାଦ୍‍କ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ପିତର୍ ପିନା ପଡ଼ିୟେ ଉଡ ଉଡ ଅନ୍‌‍ଦାମ୍ ଲୁଦାତାଗ୍ ବାସେ ମାଡ଼ମାନ୍ଦାନ୍ ପ୍ରବୁନ୍ ନାରୁଡ଼୍‍କ୍ ପବିତ୍ର ମାଡ଼ାଙ୍କ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ଆଗେ ଏନିୟ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍ କାଇଲ୍‍ତଣ୍ଡ୍ । ଅଂକିଙ୍କ୍‌ ପକ୍ୟାଗାତ୍ ରୋଗ୍ ହାସ୍ ଆଟ୍‌ ହେଣ୍ଡ୍‍କ୍ କାଟୁଲ୍‍ତାଗାଙ୍କ୍ ତେଦାଙ୍କ୍ ପାର୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତର୍ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଏନିୟ, ଜିସୁ କ୍ରିଷ୍ଟ ନିକିଂଙ୍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍ । ତେଏଦେ ନିୟାଦ୍ କେତ୍‍ ତେଏମ୍ ।” ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଏନିୟ ତେଦି ନିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଇଦ୍‍ ଉଡ଼ି ଲୁଦା ନୁ ଶମିରୋଣତାଗ୍ ବାସେ ମାଡ଼ାନ୍ ନାରୁଡ଼୍ ସାରେତଡ଼୍ ପ୍ରବୁନାକ୍ ମନ୍ ମାଲ୍‍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଯୋପାତାଗ୍ ଟାବିଥା ପେଦେର୍‍ତେ ୱେରଡ଼୍ ବିଶ୍ୱାସୀ ନାଟାଡ଼୍ ବାସେ ମାଡ଼ମାତ୍‍ତେ । ଆଦିନାଦ୍ ଗ୍ରୀକ୍ ପେଦେର୍ ଦର୍କାସ୍ ଇତ୍‍କେ ଇଦ୍‍ ଅର୍ତ “ହରିଣୀ,” ମାତ୍‍ତେ । ଆଦ୍ ତାନାଦ୍ ସାରେ ଦିନାମ୍ ସାୟେକାମ୍ ଦାଗ୍ ନୁ ଗରିବ୍ ନାରୁଡ଼୍‍କ୍ ସେବା ମାଡ଼ାନାଗ୍ ହିସମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ଆସୁଟେ ରୋଗ୍ ଆସ୍ ଆଦ୍ ଡଲ୍‍ତେ । ସାଙ୍ଗଡ଼୍ ତାନ୍ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଏର୍‍ ମିସ୍‍ସ୍ପି ପରତ୍‍ ବାକ୍‍ଡ଼େତାଗ୍ ପାଟ୍‍ପିସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଯୋପ୍‍ପା ଲୁଦାତ୍‍ ବକେତ୍ ମାତ୍‍ତେ । ପିତର୍ ଲୁଦାତାଗ୍ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ କେଞ୍ଜି, ଯୋପାତାଗ୍ ମାନ୍ଦାନ୍ ବିଶ୍ୱାସୀ ଶିଷ୍ୟ ଇର୍‍ୱୁଡ଼୍ ନାରୁଡ଼୍‍କ୍ ରହତଡ଼୍, “ଅନୁରଦ୍‌‍ ମାଡ଼ୁତମ୍‍ ସିଟ୍‍ପାଟ୍ ମା ବକେତ୍ ୱାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ପିତର୍ ତିଆର୍ ଆସ୍ ଅଡ଼୍‌‍ତଡ଼୍ ଆତ୍‍ତଣ୍ଡ୍ । ଆଗେ ଏୱୁତ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ପରତ୍‍ ବାକ୍‍ଡ଼େତାଗ୍ ଆତ୍‍ତଡ଼୍ । ଆଗେ ରାଣ୍ଡିକି କେୟି କେୟି ଦର୍କାସ୍ ମାତ୍‍ତେ ସମୟ୍‍ତେ ସିଲେୟ୍ ମାଡ଼୍‍ତେ ଚକା ନୁ ସିଲେ ତଅତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ପିତର୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ବାୟିଦେ ପେସ୍‍ସ୍ପିତଣ୍ଡ୍ ନୁ ମର୍‍ମିଣ୍ଡା ଇସ୍‌ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଣ୍ଡ୍ । ତାନ୍ ପେର୍‍କେ ଅଣ୍ଡ୍‌ ଦର୍କାସ୍‍ତେ ଡଲ୍‍ତେ ମେନ୍ଦୁଲ୍‍ତିଙ୍କ୍ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ଟାବିଥା, ତେଏଦେ !” ଦର୍କାସ୍ କଣ୍ଡା ତେର୍‍ତଣ୍ଡ୍ ନୁ ପିତର୍‍ତିଙ୍କ୍ ଉଡ଼ି ତେଦି କୁଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ପିତର୍ କାୟ୍‍ ହାଆସ୍‍ ଆଦିଙ୍କ୍ ତେହେତ୍‍ତଣ୍ଡ୍ । ତାନ୍ ପେର୍‍କେ ଗୁଡ଼ିମାନ୍ଦାନ୍ ସାରେ ବିଶ୍ୱାସୀ ନୁ ରାଣ୍ଡି ନାଟାକିଙ୍କ୍ କାର୍‍ଙ୍ଗି ଜିୱୁନ୍‍ ପବିତ୍ରଆତ୍ମାତିଙ୍କ୍ ଅଡ଼୍‌ କାୟ୍‍ଦେ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଇଦ୍ ଗଟ୍ ଯୋପାତେ ସାରେ ପାକ୍ ପୁତ୍‍ତଡ଼୍ ନୁ ନାର୍‍ଗେ ନାରୁଡ଼୍ ପ୍ରବୁଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ପିତର୍ ନାର୍‍ଗେ ଦିନା ଯୋପାତେ ଶିମୋନ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ତଲ୍‍କା ବେପାରିନ୍ ଲୋନ୍‌ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିଆତଣ୍ଡ୍ କର୍ଣ୍ଣୀଲିୟ “ଇଟାଲୀୟ ବାହିନୀ,” ପେଦେର୍‍ତେ ରୋମୀୟ ସୈନ୍ୟବାହିନୀତେ ଶତସେନାପତି ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଦାର୍ମିକ୍ ନାରୁଣ୍ଡ୍‍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ନୁ ତାମ୍ ପରିବାର୍‍ତେ ସାରେତଡ଼୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଉପାସନା ମାଡ଼ମାତ୍‍ତଡ଼୍ । ଅଣ୍ଡ୍‌ ଯିହୁଦି ଗରିବ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନାର୍‍ଗେ ସାହାଯ୍ୟ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ ନୁ ସାରେଦାମ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ଅଣ୍ଡ୍‌‍ଦିନ୍ ପାୟାଲ୍ ମୁଣ୍ଡ୍ ଗାଣ୍ଟା ସମୟ୍‍ତେ ଅଣ୍ଡ୍‌ ସାୟ୍‍ ଅଣ୍ଡୟ୍‌ ଦର୍ଶନ୍‍ ଉଡ଼୍‍ତଣ୍ଡ୍ ଯେ ଇଶ୍ୱର୍‌ତେ ଦୂତ୍ ୱାସ୍ ଅଂକିଙ୍କ୍‌ କାର୍‍ଙ୍ଗୁତଣ୍ଡ୍, “କର୍ଣ୍ଣୀଲିୟ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ଅଣ୍ଡ୍‌ ୱେର୍‍ ସ୍ୱର୍ଗ ଦୂତତାକ୍ ଉଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ପ୍ରବୁ ବାତ୍ କେତୁତିନ୍ ?” ଦୂତ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ଇଶ୍ୱର୍ ନିୟାଦ୍ ପ୍ରାର୍ତନା ନୁ ଦାନ ଉଡ଼ି ସାର୍‍ଦେ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ଆଦିଙ୍କ୍ ନିକିଂଙ୍କ୍ ଉପହାର୍ ହିଦାଙ୍କ୍ ତିଆର୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ଇଞ୍ଜେ ଶିମୋନ୍ ପିତର୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍ କାର୍‍ଙ୍ଗି ତାତାନ୍ ମାଇଦିଙ୍କ୍ ଯୋପାତାଗ୍ ନାରୁଡ଼୍‍କ୍ ରହମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ଅଣ୍ଡ୍‌ ଗଦାଡ଼୍ ହାଞ୍ଚିନାଗ୍ ବାସେ ମାଡ଼ମାନ୍ଦାନ୍ ଶିମୋନ୍ ପେଦେର୍‍ତଣ୍ଡ ୱେରଣ୍ଡ୍ ତଲ୍‍କା ବେପାରିନ୍ ଲନ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ଇଦ୍ କେସ୍ ଦୂତ୍ ଆତ୍‍ତଣ୍ଡ୍ । କର୍ଣ୍ଣୀଲିୟ ତାମ୍ ଲୋତ୍‍ତେ ଇର୍‍ୱୁଡ଼୍ ଦାସ ନୁ ୱେରଣ୍ଡ୍ ସୈନିକ୍‍ତିଙ୍କ୍ ପେର୍ରକେ ଆଦାନଙ୍କ୍‌ କାର୍‍ଙ୍ଗ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାରେ ବିଷୟ୍ କେସ୍ ଯୋପାତାଗ୍ ରହତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ମେଣ୍ଡେଅନ୍‌‍ଦିନ୍ ପାୟାଲ୍ ଅଡ଼୍‌ ଯୋପ୍‍ପାତ୍ ଗାର୍‍ରେ ଏୱୁଦାନ୍ ୱେଲେ, ପିତର୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ମୁର୍ସିନାଗ୍‍ ଆଞ୍ଜ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ଅଣ୍ଡ୍‌ କାର୍‍ପୟ୍‍ତ୍‍ତାଙ୍କ୍ ସୁଦୁଟ୍ ତିନ୍ଦାନଙ୍କ୍ ହାଲ୍‍ସ୍‍ତଣ୍ଡ୍ ନୁ କାଦି ତିଆର୍ ଆତ୍‍ତେ ସମୟ୍‍ତେ ଅଣ୍ଡ୍‌ ଅଣ୍ଡୟ୍‌ ଦର୍ଶନ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ଅଣ୍ଡ୍‌ ଉଡ଼୍‍ତଣ୍ଡ୍, ସ୍ୱର୍ଗ କୁଲେମ୍ ଆତ୍‍ତେ ନୁ ଅଣ୍ଡୟ୍‌ ବେଡ଼୍‍ୟାଦ୍‍ ଡୁପଟ୍ ନାଲୁ ମୁଲାନାଗ୍ ଉଙ୍ଗିମିକା ପୃତିବିତାଗ୍ ପର୍‍ର ଡିଗୁତ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ସ୍ୱର୍ଗ ନାର୍‍ଗେ ରକମ୍‍ତାୱ୍ ଜୀୱାକ୍, ପୃତିବିତାଗ୍ ବେନ୍‍ ଜିୱାକ୍ ନେଲ୍‍ ମେନ୍ଦୁଲ୍‍ ମସ୍‍ସ୍ପି ତାଆକାନାୱୁ ଜିୱାକ୍‍ ନୁ ଗୁପେତ୍ ପିଟ୍‍ଟେ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଅଣ୍ଡୟ୍‌ ଗଟ୍ କେଞ୍ଜ୍‍ତଣ୍ଡ୍, “ପିତର୍ ! ତେଏଦେ, ହାୱ୍‍କି ମିକା ତିନ୍ !” ");
INSERT INTO kff_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ବାତେଙ୍କ୍ ଇତ୍‍କେ ପିତର୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଲ୍‍ଲେ ପ୍ରବୁ, ନାନ୍ ପାର୍‍ୱନ୍ ! ନାନ୍‍ନେ ବେସୁଟ୍‌ ଅଶୁଚି ନୁ କାରାପ୍ ମାନ୍ଦାନ୍ ଜିନିଷ୍ ତିନନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ କେଞ୍ଜ୍‍ତଣ୍ଡ୍; “ଇଶ୍ୱର୍ ବେନଙ୍କ୍ ଶୁଚି ମାଡ଼୍‍ତଣ୍ଡ୍, ନିମ୍‍ ଅଂକିଙ୍କ୍‌ କାରାପ୍ ଇଞ୍ଜ ହାଲ୍‍ସ୍‍ମା ।” ");
INSERT INTO kff_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ମୁଣ୍ଡ୍‍ଦାମ୍ ଇଦ୍ ରକମ୍ ଆତ୍‍ତେ ପେର୍‍କେ, ଡୁପଟ୍‍ତିଙ୍କ୍ ସ୍ୱର୍ଗତାକ୍ ତେଇସ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତର୍ ତାନ୍ ଦର୍ଶନ୍ ଉଡ଼୍‍ତେ ଇତ୍‍କେ ଆଲ୍‍ସି କାବା ଆତ୍‍ତଣ୍ଡ୍ । ଆସୁଟେ କର୍ଣ୍ଣୀଲିୟ ବେନଡ଼୍‍କ୍ ରହସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌ ଶିମୋନ୍‍ତେ ଲନ୍‍ ତିଙ୍କ୍ ଦର୍‍ସ୍‍କି ମାର୍ ବକେତ୍ ନିଶ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ଅଡ଼୍‌ କାର୍ଙ୍ଗି ପାଚ୍ରାମାଡ଼୍‍ତଡ଼୍, ଶିମୋନ୍ ପିତର୍ ପେଦେର୍‍ତେ ଇଗେ ୱେରଣ୍ଡ୍ କୁଟ୍‍ମାମ୍‍ ନାରୁଡ଼୍ ମିନ୍ଦେଣ୍ଡ୍ କି ? ");
INSERT INTO kff_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତର୍ ଆସୁଟ୍‍ ଯାକ ଦର୍ଶନ୍‍ତାଦ୍ ଅର୍ତ ବୁଜେମ୍ ଆଦାଙ୍କ୍ ଆଲ୍‍ସମାତ୍‍ତଣ୍ଡ୍, ଆସୁଟେ ପବିତ୍ର ଆତ୍ମା କେତ୍‍ତେ, “ଉଡ଼େ, ଇଗେ ମୁୱୁଡ଼୍ ନାରୁଡ଼୍ ନିକିଂଙ୍କ୍ ମେହେକୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ତିଆର୍ ଆସ୍ ମଦଲ୍ ଅନ୍‌ ନୁ ଅଡ଼୍‌ ତଡ଼୍ ଆଦାନଙ୍କ୍ ଆଲ୍‍ସାନାଦ୍‍ ଇଲେ, ବାତେଙ୍କ୍ ଇତ୍‍କେ ନାନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରହତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ପିତର୍ ମଦଲ୍ ଆଞ୍ଜ୍ ଆ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ବେନଙ୍କ୍ ମେହେକୁତିଡ଼୍, ନାନ୍ ଅଣ୍ଡେ । ମିଡ଼୍ ବାତେଙ୍କ୍ ୱାତ୍‍ତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ସେନାପତି କର୍ଣ୍ଣୀଲିୟ ମାକିଂଙ୍କ୍ ରହତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ସାୟେତ୍ ନାରୁଣ୍ଡ୍‍ । ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନଣ୍ଡ୍‍ ନୁ ଇହୁଦୀ ନାରୁଡ଼୍‍ ସାରେତଡ଼୍ ଅଂକିଙ୍କ୍‌ ସନ୍‍ମ୍ମାନ୍ ହିଦ୍‍ତଡ଼୍ । ନିକିଂଙ୍କ୍ ତାମ୍ ନାର୍ କାର୍‍ଙ୍ଗି ମିକା ନିୟାଦ୍ ଗଟି କେଞ୍ଜାନ୍ ମାଇଦିଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ୱେରଣ୍ଡ୍ ପବିତ୍ର ଦୂତ୍ ଅଂକିଙ୍କ୍‌ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ପିତର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଲୋପେ କାର୍‍ଙ୍ଗି ଆସ୍ ଆଦ୍ ନାର୍‍କେତ୍ ଆଗେ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡନ୍‍ଦିନେ ତିଆର୍ ଆସ୍ ଅଡ଼୍‌ ତଡ଼୍ ଆତ୍‍ତଡ଼୍ । ଯୋପାତାଗ୍ ବେସ୍‍ତୁଡ଼୍ ବିଶ୍ୱାସିଡ଼୍ ଦାଦାଲଡ଼୍‍ ମିକା ଅଡ଼୍‌ ତଡ଼୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ପେର୍‍ନେଟି ଅଡ଼୍‌ କାଇସରିଆତାଗ୍ ଏୱୁତ୍‍ତଡ଼୍ । ଆଗେ କର୍ଣ୍ଣୀଲିୟ ତାନ୍ ସାଙ୍ଗ ନୁ ଲୋତ୍‍ତେନଡ଼୍ ତଡ଼୍ ପିତର୍‍ତିଙ୍କ୍ କେପିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତର୍ ଲୋପେ ଆଦ୍‍ଦାନ୍ ୱେଲେ କର୍ଣ୍ଣୀଲିୟ ଅଂକିଙ୍କ୍‌ କାଇଲିମିକା ଡେକେତ୍ ମଦଲ୍ ରାଲି ପ୍ରଣାମ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ଇତ୍‍କେ ପିତର୍ ଅଂକିଙ୍କ୍‌ ତେଇସ୍‍ କେତ୍‍ତଣ୍ଡ୍, “ତେଏଦେ, ନାନ୍ ନିଜେ ୱେରଣ୍ଡ୍ ନାରୁନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ପିତର୍ କର୍ଣ୍ଣୀଲିୟ ତଡ଼୍ ତିର୍‍ୟ ତିର୍‍ୟ ଲୋତ୍‍ତେ ଲୋପେ ହସ୍‍ତଣ୍ଡ୍ ନୁ ଆଗେ ନାର୍‍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଣ୍ଡୟାଗେ ଗୁଡ଼ିମାନ୍ଦାନାଦ୍ ଉଡ଼୍‍ତଣ୍ଡ୍‍, ");
INSERT INTO kff_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ସାୟେ ପୁଞ୍ଜ୍ ମାନୁଟ୍, ୱେରଣ୍ଡ୍ ଇହୁଦୀ ନାରୁଡ଼୍ ତାନ୍ ବିଶ୍ୱାସ୍ ଲେକାମ୍ ଅବିଶ୍ୱାସୀ ନାରୁଡ଼୍ ତଡ଼୍ କାଇଲାନଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ । ଇତ୍‍କେ ଇଶ୍ୱର୍ ନାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ବେନଙ୍କ୍ ବା କାରାପ୍ ବା ଅପବିତ୍ର ହେର୍କା ମାଡ଼ାନାଦ୍ ଅଶୁଚି ଆୟ୍‍ୟ । ");
INSERT INTO kff_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ଆଦିଙ୍କ୍ ମିଡ଼୍ ବେସୁଟ୍‌ ନାକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତିଡ଼୍, ନାନ୍ ବାତେମିକା ଆପତ୍ତି ମାଡ଼୍‍ୱେ କନ୍‍ସ୍ ୱାତ୍‍ତାନ୍ । ନାନ୍ ପୁନ୍ଦାଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତାନ୍, ମିଡ଼୍ ବାତେଙ୍କ୍ ନାକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତିଡ଼୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ଣ୍ଣୀଲିୟ କେତ୍‍ତଣ୍ଡ୍, “ନାଲୁ ଦିନା ମୁନେଙ୍କ୍‍ ଇଦ୍ ସମୟ୍‍ତେ ପାୟାଲ୍ ମୁଣ୍ଡ୍ ଗାଣ୍ଟାତ୍‍ ୱେଲେ ନାନ୍ ନା ଲୋନ୍‌ ପ୍ରାର୍ତନା ମାଡ଼ମାତ୍‍ତାନ୍ । ହଟାତ୍ ପାଣ୍ଡ୍ରି ଚକାସିଲେ କେର୍‍ତେନଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ନା ମୁନ୍‍ନେ ନିତ୍‍ତଣ୍ଡ୍‍; ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍ ");
INSERT INTO kff_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘କର୍ଣ୍ଣୀଲିୟ ! ଇଶ୍ୱର୍ ନିୟାଦ୍ ପ୍ରାର୍ତନା କେଞ୍ଜ୍‍ତଣ୍ଡ୍ ନୁ ଗରିବିଡ଼୍‍କ୍ ଦାନ୍‍ ମାଡ଼ାନ୍‍ ସେବାକାମ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ଶିମୋନ୍ ପିତର୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍ ତାତାନ୍ ସେଙ୍ଗେ ଯୋପାତାଗ୍ ନାରୁଡ଼୍‍କ୍ ରହମୁଟ୍ । ଅଣ୍ଡ୍‌ ଗଦାଡ଼୍‍ତେ ବକେତ୍ ମାନ୍ଦାନ୍ ତଲ୍‍କା ବେପାରିନ୍ ଲନ୍‍ କୁଟ୍‍ମାମ୍‍ ଆସ୍ ମିନ୍ଦେଣ୍ଡ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ଆଦିଙ୍କ୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ନାନ୍ ନିକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତାନ୍ ନୁ ନିମେ ଦୟା ମାଡ଼ି ୱାତ୍‍ତିନ୍‍ । ପ୍ରବୁ ନିକିଂଙ୍କ୍ ବାତ୍ କେତାନଙ୍କ୍ ବୁଦ୍ଦ୍‌ ହିତ୍‍ତଣ୍ଡ୍, ଆଦ୍ କେଞ୍ଜାନଙ୍କ୍ ମାମ୍‍ମେ ସାରେତମ୍ ଇଞ୍ଜେ ଇଶ୍ୱର୍‌ତେ ବକେତ୍ ମିନ୍ଦେମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ପିତର୍ ଶିକ୍ଷା ହିଦାନଙ୍କ୍ ଆରାମ୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ଇଞ୍ଜେ ନାନ୍ ନିଜାମ୍ ବୁଜେମ୍ ଆତ୍‍ତାନ୍ ଯେ ପ୍ରକୃତ୍‍ତେ ଇଶ୍ୱର୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ସାମାନ୍ ଉଡ଼ୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ବେନ୍ ନାର୍‍ଦେନଣ୍ଡ୍‍ ଆୟି ନାରୁଣ୍ଡ୍ ପ୍ରବୁଙ୍କ୍‍ ପ୍ରାର୍ତନା ମାଡ଼୍‍କେ ନୁ ଅନ୍‌ କଣ୍ଡେତେ ସତ୍‍ କର୍ମ ମାଡ଼୍‍କେ ପ୍ରବୁ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼ିତନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ ଯେ ଇଶ୍ୱର୍ ଇସ୍ରାଏଲ୍‍ ନାରୁଡ଼୍‍କ୍ ଗାରେ ବେନ୍ କାବୁର୍ ରହସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ଆଦେ ଜିସୁ ଦ୍ୱାରା ଗଷଣା ମାଡ଼୍‍ତାଦ୍ ଶାନ୍ତି ସୁସମାଚାର୍‍ । ହି ଜିସୁ କ୍ରିଷ୍ଟ ସାରେ ତଡ଼୍‍ ପ୍ରବୁ । ");
INSERT INTO kff_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଯୋହନ୍‌ ମନ୍ ପରିବର୍ତ୍ତନ୍ ନୁ ଏର୍‍ ଦୀକ୍ଷା କାବୁର୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତେ ପେର୍‍କେ, ଗାଲିଲୀତାଗାଙ୍କ୍ ଆରାମ୍ ମାଡ଼ି ସାରେ ଯିହୁଦା ଦେଶ୍‍ତାଗ୍ ବେନ୍ ଗଟନା ଗଟେମ୍ ଆତ୍‍ତେ, ଆଦ୍ ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ମିଡ଼୍ ନାଜରିତ ଜିସୁନ୍ ବିଷୟ୍‍ତେ ନୁ ଇଶ୍ୱର୍ ବେଲା ଅଙ୍କ୍‌ ଏଞ୍ଚି ଅନ୍‌ ପର୍‍ର ପବିତ୍ର ଆତ୍ମା ନୁ ଶକ୍ତି ହିତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପୁତ୍‍ତିଡ଼୍ । ଅଣ୍ଡ୍‌ ସାରେ ପାକ୍ ଆଞ୍ଜ୍ ସାୟେତ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍ । ଶୟ୍‍ତାନ୍‍ ଅଦିନ୍‌ତେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କ୍ ସୁସ୍ଥ ମାଡ଼୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅନ୍‌ ତଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଯିହୁଦା ଦେଶ୍‍ତାଗ୍ ନୁ ଯିରୁଶାଲେମ୍‍ ଦେଶ୍‍ତାଗ୍ ଅଣ୍ଡ୍‌ ବେନ୍ ସାରେ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍, ମାମ୍‍ମେ ଆୱ୍ ସାରେତ୍ ସାକ୍ଷି । ତାନ୍‍ପେର୍କେ ଅଂକିଙ୍କ୍‌ ଅଡ଼୍‌ କ୍ରୁଶବିଦ୍ଦ ମାଡ଼ି ହାୱ୍‍କ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ଇତ୍‍କେ ଇଶ୍ୱର୍ ମୁଣ୍ଡ୍ ଦିନା ଲୋପେ ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତାଗାଙ୍କ୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ ଜିୱେ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍ ବକେତ୍‍ ପ୍ରକାଶଆସ୍ ତଅନ୍‌ଦ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ଅଣ୍ଡ୍‌ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ତନ୍ଦଣ୍ଡ୍, ଇଶ୍ୱର୍ ବେନଙ୍କ୍ ସାକ୍ଷି ଲେକାମ୍ ହେଞ୍ଚ୍‍ତଣ୍ଡ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ତନ୍ଦ୍‍ତଣ୍ଡ୍ । ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡେଜିୱେ ମାଡ଼୍‍ତେ ପେର୍‍କେ ମାମ୍‍ମେ ଅନ୍‌‍ତଡ଼୍ ତିନ୍ଦାନ୍‍ଉନ୍ଦାନ୍‍ ମାଡ଼୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ନାରୁଡ଼୍ ଗାର୍‍ରେ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଇଦିଙ୍କ୍ ନୁ ଇଶ୍ୱର୍ ଯେ ଅଂକିଙ୍କ୍‌ ଜିୱେ ମାନ୍ଦାନଡ଼୍‍କିଙ୍କ୍ ନୁ ଡଲ୍‍ତେ ନାରିଡ଼୍‍ ବିଚାର୍ କର୍ତ୍ତାଲ୍ ଲେକାମ୍ ନିଯୁକ୍ତି ମାଡ଼୍‍ତଣ୍ଡ୍, ଇଦ୍ ଗଟ୍‍ତାଦ୍ ସାକ୍ଷ୍ୟ କେତାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ମାକିଂଙ୍କ୍ ଆଜ୍ଞା ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ସାରେ ବାବବାଦୀଡ଼୍ ଅନ୍‌ ବିଷୟ୍‍ତେ ପ୍ରଚାର୍ ମାଡ଼ି ଇଦ୍ ଗଟ୍ କେସ୍ ମାତ୍‍ତଡ଼୍, ଯେ ବେନ ଅଂକିଙ୍କ୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼ିତନ୍, ଅନ୍‌ ପେଦେର୍‍ତେ ଶକ୍ତିତଡ଼୍ ଅନାଦ୍‌ ପାପ୍ କ୍ଷମା ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତର୍ ଶିକ୍ଷା ହିଦାନ୍ ୱେଲେ ବେନଡ଼୍ ଅନାଦ୍‌ ଶିକ୍ଷା କେଞ୍ଜ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ସାରେତଡ଼୍ ପର୍‍ର ପବିତ୍ର ଆତ୍ମା ହସ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ଅଣଇହୁଦୀଡ଼୍ ପର୍‍ର ଗାଲା ଇଶ୍ୱର୍ ଅନାଦ୍‌ ପବିତ୍ର ଆତ୍ମା ଇସ୍‌ ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ପିତର୍ ତଡ଼୍ ୱାସ୍ ମାନ୍ଦାନ୍ ଯୋପ୍‍ପାତେ ସୁନ୍ନତଇହୁଦୀ ବିଶ୍ୱାସୀଡ଼୍ କାବା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଇହୁଦୀ ବିଶ୍ୱାସୀଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ ପ୍ରସଂଶା ମାଡ଼ମାନ୍ଦାନାଦ୍ ନୁ ୱେରେ ଗଟ୍‍ତେ ତ୍ରିୟାନାଦ୍ କେଞ୍ଜ୍‍ତଡ଼୍ । ପିତର୍ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ମା ଲେକାମ୍ ଇଡ଼୍‍ ନାରୁଡ଼୍ ଗାଲା ପବିତ୍ର ଆତ୍ମା ପାଏମ୍ ଆତ୍‍ତଡ଼୍ । ଏର୍‍ ଦୀକ୍ଷା ଆଦାନ୍ ସେଙ୍ଗେ ବାତ୍ ବେନ ବାଦା ଇଦେ ପାର୍‍ଦ୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଜିସୁ କ୍ରିଷ୍ଟ ପେଦେର୍‍ତେ ଏର୍‍ ଦୀକ୍ଷା ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍ । ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡେ ବେସ୍‌କ୍ ଦିନା ଅଡ଼୍‌ ତଡ଼୍ ମାନ୍ଦାନଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଅଣଇହୁଦୀଡ଼୍ ଗାଲା ଇଶ୍ୱର୍‌ତେ ଗଟ୍ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍ ଇଞ୍ଜ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ନୁ ଯିହୁଦା ଦେଶ୍‍ତଡ଼୍ ବାଗାତ୍ ବିଶ୍ୱାସୀଡ଼୍ ଦାଦାଲ କେଞ୍ଜ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ପିତର୍ ବେସୁଟ୍‌ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍, ଅଣଇହୁଦୀଡ଼୍‍ ପାକେଙ୍କ୍ ମାନ୍ଦାନ୍ ସୁନ୍ନତ ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ହାଲ୍‍ସାନାଦ୍‍ ନୁ କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ନିମ୍‍ ଅସୁନ୍ନତ ଅଣଇହୁଦୀଡ଼୍ ଲୋନ୍‌ କୁଟ୍‍ମାମ୍ ଆତ୍‍ତି, ମେଣ୍ଡେ ଅଡ଼୍‌ ତଡ଼୍ ତିତ୍‍ତିଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆରାମ୍‍ତାଗାଙ୍କ୍ ବାତ୍ ବାତ୍ ଗଟେମ୍ ଆତ୍‍ତେ, ପିତର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦିନାଦ୍ ସାରେ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ନାନ୍ ଯୋପା ନାର୍‍ତାଗ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ୱେଲେ ଅଣ୍ଡୟ୍‌ ଦର୍ଶନ୍ ଉଡ଼୍‍ତାନ୍ । ଅଣ୍ଡୟ୍‌ ବେଡ଼୍‍ୟାଦ୍‍ ଡୁପଟ୍ ନାଲୁ ମୁଲାନାଗ୍ ଉଙ୍ଗି ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ମଦଲ୍ ଡିଗାନାଦ୍ ଉଡ଼୍‍ତାନ୍, ଆଦ୍ ନା ବକେତ୍ ନିତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ନାନ୍ ସାୟେ ମାଡ଼ି ଲୋପେ ଉଡ଼୍‍ତାନ୍ ଆଦିନ୍ ସ୍ୱର୍ଗ ନାଲୁ ଡେକାନ୍ ଲୋନ୍‌ ପଡ଼୍‍ପାନ୍ ପିଟ୍‍ଟେ ନୁ ଗୁପେତ୍ ପଶୁ, ପୃତିବିତାଗ୍ ବେନ୍‍ ନେଲ୍‍ ମେନ୍ଦୁଲ୍‍ ମସ୍‍ସ୍ପି ତାଆକାନାୱୁ ଜିୱାକ୍‍ ନୁ ଗୁପେତ୍‍ ପିଟେ ମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ତାନ୍‍ପେର୍କେ ନାନ୍ ଇଦ୍ ଗଟ୍ କେଞ୍ଜ୍‍ତାନ୍, ‘ପିତର୍ ! ତେଏଦେ, ହାୱ୍‍କି ତିନ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ଇତ୍‍କେ ନାନ୍ ଉତ୍ତର୍ ହିତ୍‍ତାନ୍, ‘ଇଲ୍‍ଲେ ପ୍ରବୁ ! ନାନ୍ ପାର୍‍ୱନ୍ । ଇଞ୍ଜେକ୍ଆନା ବାତେଏ କାରାପ୍ ବା ଅଶୁଚି କାଦି ତିନନେ ।’” ");
INSERT INTO kff_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ମେଣ୍ଡେ ଇଦ୍ ଗଟ୍ ୱାତ୍‍ତେ, “ଇଶ୍ୱର୍ ବେନଙ୍କ୍ ଶୁଚି ମାଡ଼୍‍ତଣ୍ଡ୍, ନିମ୍‍ ଆଦିଙ୍କ୍ ଅଶୁଚି ହେର୍କା ମାଡ଼୍‍ମା ।” ");
INSERT INTO kff_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ମୁଣ୍ଡ୍‍ଦାମ୍ ଇଦ୍‍ରକମ୍ ଆତ୍‍ତେ, ମାଡ଼େଙ୍କ୍‌ତେ ଆୱୁ ସାରେତାୱିଙ୍କ୍ ସ୍ୱର୍ଗତାଗ୍ ତେଇସ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଟିକ୍ ଆସୁଟେ ସିସେରିଆ ତାଗାଙ୍କ୍‌ ନାୟାକ୍ ରହତେନଡ଼୍ ମୁୱୁଡ଼୍ ନାରୁଡ଼୍ ନାନ୍ ବେନ୍‍ ଲନ୍‍ ମାତ୍‍ତାନ୍ ଆଗେ ଏୱୁତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ବାତ୍‍ମିକା ଆଲ୍‍ସାନାଦ୍‍ ଅଡ଼୍‌ ତଡ଼୍ ଆଦାନଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ନାକିଂଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଯୋପ୍‍ପାତାଗାଙ୍କ୍ ଆରୁ ଜାନ୍‍ ବିଶ୍ୱାସୀ ନା ତଡ଼୍ ସିସେରିଆତାଗ୍ ଆତ୍‍ତଡ଼୍ ନୁ ମାମ୍‍ମେ ସାରେତମ୍ କର୍ଣ୍ଣୀଲିୟତେ ଦାଦାଲ ଲୋନ୍‌ ଏୱୁତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ତାମ୍ ଲୋନ୍‌ ବେଲା ସ୍ୱର୍ଗ ଦୂତ ଦର୍ଶନ୍ ପାଏମ୍‍ଆତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ବିଷୟ୍ ମାକିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ । ସ୍ୱର୍ଗ ଦୂତ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଯୋପାତାଗ୍ ମାନ୍ଦାନ୍ ଶିମୋନ୍ ପିତର୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍ ତାତାନଙ୍କ୍ ନାରୁଡ଼୍‍କ୍ ରହମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ଅଣ୍ଡ୍‌ ୱାସ୍ ମିକିଂଙ୍କ୍ ଶିକ୍ଷା ହିଦ୍‍ତଣ୍ଡ୍ ମେଣ୍ଡେ ମିଡ଼୍ ନୁ ମିଇ ପରିବାର୍ ପରିତ୍ରାଣ୍ ପାଏମ୍‍ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ମେଣ୍ଡେ ନାନ୍ ବେସୁଟ୍‌ ଶିକ୍ଷା ହିଦାନଙ୍କ୍ ପସ୍‍ସ୍ପ୍‍ତାନ୍, ମୁନ୍‍ନେନ୍ ପବିତ୍ର ଆତ୍ମା ମା ପର୍‍ର ବେଲା ୱାସ୍‍ମାତ୍‍ତେ, ଆଦେ ରକମ୍ ଅଡ଼୍‌ ପର୍‍ର ୱାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ତାନ୍‍ପେର୍କେ ନାନ୍ ପ୍ରବୁନାଦ୍ ଇଦ୍ ଶିକ୍ଷା ହେର୍କା ମାଡ଼୍‍ତାନ୍; ‘ଯୋହନ୍‌ ଏର୍‍ଦାଗ୍ ଦୀକ୍ଷା ହିତ୍‍ତଣ୍ଡ୍, ଇତ୍‍କେ ମିଡ଼୍ ପବିତ୍ର ଆତ୍ମାତଡ଼୍ ବାପ୍ତିସ୍ମ ଆଦ୍‍ତିଡ଼୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ଇଦ୍ ସ୍ପଷ୍ଟ ଯେ ମାମ୍‍ମେ ପ୍ରବୁ ଜିସୁ କ୍ରିଷ୍ଟନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାନ୍ ତଡ଼୍ ଇଶ୍ୱର୍ ମାକିଂଙ୍କ୍ ବେନ୍ ଦାନ୍‍ ହିତ୍‍ତଣ୍ଡ୍, ଅଣଇହୁଦୀଡ଼୍‍କ୍‍ ମିକା ଆଦେ ଦାନ୍‍ ହିତ୍‍ତଣ୍ଡ୍; ନାନ୍ ବେନ ଯେ ଇଶ୍ୱର୍‌ତେ ଇଦ୍ ପାଡ଼ିୟିତିଙ୍କ୍ ବିରୋଦ୍ ମାଡ଼ିତାନ୍ !” ");
INSERT INTO kff_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ଅଡ଼୍‌ ଇଦ୍ କେଞ୍ଜ୍‍ତେ ପେର୍‍କେ ମେଣ୍ଡେ ସମାଲୋଚନା ମାଡ଼କଟ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଗୌରବ୍‍ ମାଡ଼ି କେତ୍‍ତଡ଼୍, “ଆଲେକେ ଇଶ୍ୱର୍ ଅଣଇହୁଦୀଡ଼୍‍କ୍ ମିକା ଅନୁତାପ୍ ମାଡ଼ାନଙ୍କ୍ ନୁ ଜିୱୁଣ୍ଡ୍ ବାଦ୍‍କାନ୍ ସେଙ୍ଗେ ସୁଯୋଗ୍ ହିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ସ୍ତିଫାନ୍‍ତେ ଡଲ୍‍ତେ ପେର୍‍କେ ବେନ୍ ତାଡ଼ନା ଆତ୍‍ତେ, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ବଶ୍ୱାସୀଡ଼୍‍ ସାରେଏକାମ୍ ଚିନ୍‍ବିନ୍‍ ଆଦାନ୍‍ ୱେଲେ ଅଡ଼୍‌‍ ଲୋପେଙ୍କ୍‍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ମାତର୍‍ ଇହୁଦୀଡ଼୍ ଗାର୍ରେ ସମ୍ବାଦ ପ୍ରଚାର୍‍ ମାଡ଼୍‍ତଡ଼୍‍ । ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେସ୍‍ତୁଡ଼୍ ଫିନିସିଆ, ସାଇପ୍ରସ୍ ନୁ ଆନ୍ତିୟକିଆ ହେୱୁନା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ଇତ୍‍କେ ସାଇପ୍ରସ୍‍ ନୁ କୁରିନୀୟତେ ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ବିଶ୍ୱାସୀଡ଼୍ ଆନ୍ତିୟକିଆ ତାଗ୍ ଆଞ୍ଜ୍ ଅଣଇହୁଦୀଡ଼୍ ଗାର୍‍ରେ ପ୍ରବୁ ଜିସୁନ୍ ସୁସମାଚାର୍‍ ଗ୍ରୀକ୍‍ ଗଟ୍‍ତେ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ପ୍ରବୁନ୍‌ ଶକ୍ତି ଅଡ଼୍‌‍ତଡ଼୍ ମାତ୍‍ତେ ନୁ ନାର୍‍ଗେ ନାରୁଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼ି ପ୍ରବୁନାକ୍ ମନ୍ ମାଲ୍‍ପ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ବେସୁଟ୍‌ ଇଦ୍ ସମ୍ୱାଦ୍ ଯିରୁଶାଲେମ୍‍ ମଣ୍ଡଲିତାଗ୍ ହେୱୁତ୍‍ତେ, ଅଡ଼୍‌ ବର୍ଣ୍ଣବାଙ୍କ୍ ଆନ୍ତିୟକିଆ ରହତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ଅଣ୍ଡ୍‌ ଆଗେ ହେୱୁସ୍‍ ଇଶ୍ୱର୍ ଆ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବେଲା ଅନୁଗ୍ରହ ମାଡ଼୍‍ତଣ୍ଡ୍ ଆଦ୍‍ ଉଡ଼ି ୱେଡ଼୍‍କେ ଆତ୍‍ତଣ୍ଡ୍‍ ନୁ ସାରେତଡ଼୍‍ତେ ହୃଦୟ୍‍ତାଗ୍ ପ୍ରବୁନ୍ ସେଙ୍ଗେ ବିଶ୍ୱାସ୍ ମାଡ଼ି ଅନୁରଦ୍‌‍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାର୍‍ଦେ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ବର୍ଣ୍ଣବା ପବିତ୍ର ଆତ୍ମା ନୁ ବିଶ୍ୱାସ୍‍ତାଗ୍‍ ୱେରଣ୍ଡ୍‍ ସାୟେକାମ୍‍ଦେ ନାରୁଣ୍ଡ୍‍ ମାତ୍‍ତଣ୍ଡ୍ । ଅନାଦ୍‌ ପ୍ରଚାର୍ ତଡ଼୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ପ୍ରବୁନ୍ ଗାର୍‍ରେ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ତାନ୍‍ପେର୍କେ ବର୍ଣ୍ଣବା ଶାଉଲ୍‍ତିଙ୍କ୍ ମେହେକାନଙ୍କ୍ ତାର୍ଷିସ୍‍ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଆଗେ ଅଣ୍ଡ୍‌ ଅଂକିଙ୍କ୍‌ ଦର୍‍ସ୍‍କି ଆନ୍ତିୟକିଆତାଗ୍ ତାତ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେ ସାରେ ଅଣ୍ଡୟ୍‌‍ ହେଣ୍ଡ୍‍କ୍ ଯାକ ଇଡ଼୍ ଇର୍‍ୱୁଡ଼୍ ଗାର୍‍ରେତ୍ ମଣ୍ଡଲିତାଗ୍ ବିଶ୍ୱାସୀ ଶିଷ୍ୟଡ଼୍‍ ତଡ଼୍ କାଇଲି ନାର୍‍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶିକ୍ଷା ହିତ୍‍ତଡ଼୍ । ଆଣ୍ଟିୟୋକ୍‌ତେ ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ନାରୁଡ଼୍ ମୁନ୍‍ନେନ୍ କ୍ରିଷ୍ଟିୟାନ୍ ଇଞ୍ଜ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ଆସୁଟେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ବାବବାଦୀଡ଼୍‍ ଯିରୁଶାଲେମ୍‍ କନ୍‍ସ୍ ଆନ୍ତିୟକିଆ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ଆଗାବ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଡ଼୍ ଆତ୍ମାନ୍‍ ଶକ୍ତିତଡ଼୍ ଜଗତ୍‍ ଏକାମ୍‍ ଅଣ୍ଡୟ୍‌ ବେଡ଼୍‍ୟାଦ୍‍ ଦୁର୍ଭିକ୍ଷ ଆଦ୍‍ତେ ଇଞ୍ଜ ବବିଷ୍ୟ ଗଟ୍‍ କେତ୍‍ତଣ୍ଡ୍ । ସମ୍ରାଟ୍ କ୍ଲଡିୟସ୍‍ତେ ୱେଲେ ଇଦ୍ ଆସ୍‍ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ଶିଷ୍ୟଡ଼୍ ଯିହୁଦାତାଗ୍ ବାସେ ମାଡ଼ମାନ୍ଦାନ୍ ବିଶ୍ୱାସିଡ଼୍ ଦାଦାଲଡ଼୍‍ ଗାର୍‍ରେ ଅଡ଼୍‌ ପାର୍‍ଦାନ୍ ପାଡ଼୍‍ୟି ଇସ ସାହାଯ୍ୟ ରହତିତଡ଼୍ ଇଞ୍ଜ ଟିକ୍‍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ଅଡ଼୍‌ ଡାବ୍‍କ୍ ଗୁଡ଼୍‍ପି ମିକା ବର୍ଣ୍ଣବା ନୁ ଶାଉଲ୍‍ତେ କାୟ୍‍ଦେ ମଣ୍ଡଲିତେ ବୟସ୍କା ନାରୁଡ଼୍‍ ଗାର୍‍ରେ ଆୱ୍ ରହତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ଇଦ୍ ସମୟ୍‍ତେ ରାଜାଲ୍‌ ହେରଦ୍ ମଣ୍ଡଲିତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ସବ୍ୟଡ଼୍‍କ୍ ଅତ୍ୟାଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ଅଣ୍ଡ୍‌ ବିଶ୍ୱାସୀ ଯୋହନ୍‌‌ତେ ତାମୁଣ୍ଡ୍‌ ଜାକୁବଙ୍କ୍ ଚୁର୍‌ତଡ଼୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେସ୍ ଆୱୁକ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଇହୁଦୀ ନାରୁଡ଼୍ ଇଦ୍ ଉଡ଼ି କୁସି ଆତ୍‍ତଡ଼୍ ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ପିତର୍‍ତିଙ୍କ୍ ମିକା ବନ୍ଦି ମାଡ଼୍‍ତଣ୍ଡ୍ । ଇଦ୍ ଗଟନା ସୋଡ଼ା ୱାଟ୍‍ୱାଦ୍‍ ରୋଟି ପାଣ୍ଡୁମ୍ ସମୟ୍‍ତେ ଆସ୍‍ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ପିତର୍ ବନ୍ଦି ଆସ୍ ଜଇଲ୍‍ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ନାଲୁ ଜାନ୍‍ତିଙ୍କ୍ ଆସ୍ ତିଆର୍ ଆତ୍‍ତେ ନାଲୁ ମାନ୍ଦେ ସୈନିକ୍ ଅଂକିଙ୍କ୍‌ କେପିମାତ୍‍ତଡ଼୍ । ନିସ୍ତାର୍ ପାଣ୍ଡୁମ୍‍ତେ ପେର୍‍କେ ସାରେତଡ଼୍ ମୁନ୍‍ନେ ଅନାଦ୍‌ ବିଚାର୍ ମାଡ଼ାନଙ୍କ୍ ହେରଦନ୍ ଇଚ୍ଛା ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ପିତର୍ ଜଇଲ୍‍ତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ ମଣ୍ଡଲିତ୍ ନାରୁଡ଼୍ ଅଣ୍ଡୟ୍‌ ମନ୍‍ତେ ଅନ୍‌ ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ହେରଦ୍ ବେନ୍ ଦିନ୍ ପିତର୍‍ତିଙ୍କ୍ ବିଚାର୍ ମାଡ଼ାନଙ୍କ୍ ବାୟିଦେ ତାତାନଙ୍କ୍ ହାଲ୍‍ସି ମାତ୍‍ତଣ୍ଡ୍, ତାନ୍ ମୁନେତ୍ ନାର୍‍କେତ୍ ପିତର୍ ରେଣ୍ଡ୍ ଇକ୍‍ଲେମ୍‍ତେ ତଅସ୍ ଇର୍‍ୱୁଡ଼୍ ସୈନିକିନ୍ ନାଡ଼୍‍ମେ ପାଟିମାତ୍‍ତଣ୍ଡ୍ । ନାର୍‍ଗେ କେପାନଡ଼୍ ମାର୍‍ତାଗ୍ ମାଞ୍ଜ୍ ଜଇଲ୍‍ତିଙ୍କ୍ କେପି ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ହଟାତ୍ ପ୍ରବୁନାଦ୍ ୱେରଣ୍ଡ୍ ଦୂତ୍ ୱାସ୍ ନିତ୍‍ତଣ୍ଡ୍ ନୁ ଆଦ୍ ବାକ୍‍ଡ଼େ ୱେସ୍ ଆତ୍‍ତେ । ଦୂତ୍ ପିତର୍‍ତିଙ୍କ୍ ହାଟ୍‍ଜାବ୍‍ତିଙ୍କ୍ ଉହୁସ୍ ତେଏସ୍ କେତ୍‍ତଣ୍ଡ୍, “ସିଟ୍‍ପାଟ୍ ତେଏଦେ !” ସାଙ୍ଗେ ସାଙ୍ଗେ ପିତର୍‍ତିଙ୍କ୍ ତଅସ୍‍ମାତ୍‍ତେ ଇକ୍‍ଲେମ୍ କୁସି ରାୟ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ତାନ୍‍ପେର୍କେ ଦୂତ୍ କେତ୍‍ତଣ୍ଡ୍, “ଟିକିଡ଼୍ ତୁୱାଲ୍‍ ଉତ୍‍ତେ, ପିତା ହେର୍‍ପୁକ୍ କେର୍‍ମ୍ ।” ପିତର୍ ଆଲା ମାଡ଼୍‍ତଣ୍ଡ୍‍ ପେର୍‍କେ ଦୂତ୍ କେତ୍‍ତଣ୍ଡ୍, “ମେନ୍ଦୁଲ୍‍ତାଗ୍ ଡୁପଟ୍ ମୁସି ନା ତଡ଼୍ ୱାଡ଼େ ।” ");
INSERT INTO kff_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ଦୂତ୍ ବାତ୍‍ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ ଆଦ୍ ନିଜାତାଦ୍ କି ଆୟ୍‍ୟ, ପିତର୍ ପୁନ୍ଦାନଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ସାପ୍ନା ଉଡ଼୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ହାଲ୍‍ସ୍‍ତଣ୍ଡ୍ । ମିକା ପିତର୍ ଜେଲ୍‍ତାଗାଙ୍କ୍ ପେଇସ୍ ଦୂତନ୍‍ ପେର୍କେପେର୍କେ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଅଡ଼୍‌ କେପାନଡ଼ାଦ୍ ରେଣ୍ଡ୍ ପଡ଼ିୟେ ପାର୍ ଆତ୍‍ତେ ପେର୍‍କେ ନାର୍‍ତାଗ୍ ହସାନାଗ୍ ମାନ୍ଦାନ୍ ଲୁହା ମାର୍ ବକେତ୍ ଆତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ସେଙ୍ଗେ ମାର୍ ତାନ୍ ମାନ୍‍ତେ କୁଲେମ୍ ଆତ୍‍ତେ ନୁ ଅଡ଼୍‌ ପେଇସ୍ ଆତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ହାର୍‍ଦାଗ୍ ଆଦାନ୍ ୱେଲେ ହଟାତ୍ ସ୍ୱର୍ଗ ଦୂତ ଅଂକିଙ୍କ୍‌ ୱିଡ଼୍‍ସି ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ତାନ୍‍ପେର୍କେ ବାତ୍ ଗଟେମ୍ ଆତ୍‍ତେ, ପିତର୍ ଆଦ୍ ପୁଞ୍ଜ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଦ୍ ନିଜାମ୍ ଇଞ୍ଜ ନାନ୍ ପୁନ୍ଦ୍‍ତାନ୍ । ହେରଦ୍‍ତାଗାଙ୍କ୍ ନୁ ଇହୁଦୀଡ଼ାଗାଙ୍କ୍ ବାତ୍ ଗଟେମ୍ ଆଦ୍‍ତେ ଇଞ୍ଜ ଆଶେ ମାଡ଼ିମାତ୍‍ତଡ଼୍, ଆଗାଙ୍କ୍ ନାକିଂଙ୍କ୍ ଉଦ୍ଦାର୍ ମାଡ଼ାନଙ୍କ୍ ପ୍ରବୁ ସ୍ୱର୍ଗ ଦୂତତିଙ୍କ୍ ରହତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ନିଜେତ୍ ପରିସ୍ଥିତି ବିଷୟ୍‍ତେ ହେର୍କେମାଡ଼ି ଅଣ୍ଡ୍‌ ଯୋହନ୍‌ ନୁ ମାର୍କନ୍ ୟାୟ୍‍ ମରୀୟମ୍‍ତେ ଲନ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ଆଗେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅଣ୍ଡୟାଗେ ଗୁଡ଼ି ପ୍ରାର୍ତନା ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତର୍ ବାୟିଦେ ମାର୍‍ତାଗ୍ ତାଲ୍‍ସ୍କ୍‍ତଣ୍ଡ୍, ରୋଦା ପେଦେର୍‍ତେ ଅଣ୍ଡୟ୍‌ କ୍ରୀତଦାସୀ କାପାଟ୍ ତେର୍‍ତାନଙ୍କ୍ ୱାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ପିତର୍‍ତେ ଲେଙ୍ଗ୍ ପୁଞ୍ଜ୍ ମିକା ଆଦ୍ ଇସର୍ ୱେଡ଼୍‌କେତେ ଆତ୍‍ତେ ଯେ ମାର୍ ତେର୍‍ୱକଟ ପିତର୍ ବାୟିଦେ ନିସ୍ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ କେତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ଅଡ଼୍‌ ଆଦିଙ୍କ୍ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ ବାୟେ ଆତ୍‍ତି ।” ଇତ୍‍କେ “ଇଦ୍ ନିଜାମ୍,” ଇଞ୍ଜ ଆଦ୍ କେତ୍‍ତାଙ୍କ୍, ଅଡ଼୍‌ ହାଲ୍‍ସ୍‍ତଡ଼୍, “ଆଲେକେ ଇଦ୍ ଅନାଦ୍‌ ଦୂତ ।” ");
INSERT INTO kff_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ପିତର୍ ସେନେମାନ୍ କାପାଟ୍‍ତିଙ୍କ୍ ତାଲ୍‍ସ୍କମାତ୍‍ତଣ୍ଡ୍ । ପେର୍‍କେ ଅଡ଼୍‌ କାପାଟ୍ ତେର୍‍ସ୍‍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ି ଦାଦ୍‍ରେଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ଅଣ୍ଡ୍‌ କାୟ୍ ଉହୁସ୍ କଟମାନ୍ଦାନଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍ ନୁ ପ୍ରବୁ ବେଲା ଅଂକିଙ୍କ୍‌ ଜଇଲ୍‍ତାଗାଙ୍କ୍ ପେସ୍‍ପି ତାତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ବିଷୟ୍ ଅଡ଼୍‌ ମୁନ୍‍ନେ କେତ୍‍ତଣ୍ଡ୍ । ତାନ୍‍ପେର୍କେ ଇୱୁସାରେ ଗଟି “ଯାକୁବ୍‍ ନୁ ବାଗାତ୍ ସାରେତଡ଼୍ ବିଶ୍ୱାସୀ ଦାଦାଲଡ଼୍‍ କେତାନଙ୍କ୍ ଗଟ୍ ଇସ୍‌,” ଅଣ୍ଡ୍‌ ଆଗାଙ୍କ୍ ମେଣ୍ଡେଅଣ୍ଡା ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ନାର୍‍କା ଆତ୍‍ତେ ୱେଲେ ପିତର୍ ବେକେ ଆତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ କେପାନଡ଼୍ ଗାବ୍‍ରା ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ହେରଦ୍ ଅଂକିଙ୍କ୍‌ ମେହେକାନଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଦର୍‍ସ୍କାଙ୍କ୍ ପାର୍‍ୱଡ଼୍ । ପେର୍‍କେ କେପାନଡ଼୍‍କିଙ୍କ୍ ପାଚ୍ରାମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଡଲାନ୍‍ଦଣ୍ଡ୍ ହିଦାନ୍ ସେଙ୍ଗେ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ତାନ୍‍ପେର୍କେ ହେରଦ୍ ଯିହୁଦା ପ୍ରଦେଶ୍‍ତାଗାଙ୍କ୍ ଆଞ୍ଜ୍ କାଇସରିଆତାଗ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ଆସୁଟେ ହେରଦ୍ ସୋର ନୁ ସିଦନ୍‍ତେ ନାରୁଡ଼୍‍ତେ ପର୍‍ର କପାମ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ । ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ୱେରଡ଼୍ ମାନ୍ଦେ ଅଂକିଙ୍କ୍‌ ଉଡ଼ାନଙ୍କ୍ ଆତ୍‍ତଡ଼୍ । ମୁନେନ୍ ଅଡ଼୍‌ ରାଜ୍‍ପ୍ରାସାଦ୍ ଦାୟିତ୍ୱତେ ମାନ୍ଦାନ୍ ବ୍ଲାଷ୍ଟସ୍‍ତିଙ୍କ୍ ବୁଜାମାଡ଼ି ଅନାଗାଙ୍କ୍ ସାହାଯ୍ୟ ପାଏମ୍‍ଆତ୍‍ତଡ଼୍ । ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ହେରଦ୍‍ତେ ବକେତ୍ ଆଞ୍ଜ୍ ଶାନ୍ତି ତାଲ୍‍କ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ହେରଦ୍‍ତେ ରାଜ୍ୟତାଗାଙ୍କ୍ ଅଡ଼୍‌ ଦେଶ୍ କାଦି ଆଞ୍ଜମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ଟିକ୍‌‍ମାଡ଼୍‍ତେ ଦିନେ ହେରଦ୍ ରାଜାଲଡ଼୍ ଚକାସିଲେ କେର୍‍ତଣ୍ଡ୍ ନୁ ବିଚାର୍ ଲୋତ୍‍ତାଗ୍ କୁଦି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ୱେରଡ଼୍ ବାଷଣ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ଅଡ଼୍‌ କିଡ଼୍‍କି କେତ୍‍ତଡ଼୍, “ଇଦ୍ ବେନ୍ ନାରୁନାଦ୍ ଆୟ୍‍ୟ, ମାତ୍ରମ୍‍ ୱେରଣ୍ଡ୍ ଇଶ୍ୱର୍‌ତେ ଲେଙ୍ଗ୍ !” ");
INSERT INTO kff_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ପ୍ରବୁନାଦ୍ ଦୂତ୍ ହେରୋଦତିଙ୍କ୍ ରେହେତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ବେନ୍ ଗୌରବ୍ ହିଦାନ୍‍ମାତ୍‍ତେ ଅଣ୍ଡ୍‌ ଆଦ୍ ଇୱେମାତ୍‍ତଣ୍ଡ୍ । ପୁଡ଼୍‍ୟି ଡଲ୍‍ତେ ପୁଟୁଙ୍କ୍ ଅଣ୍ଡ୍‌ ଡଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ଇଦ୍ ସମୟ୍‍ତେ ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ ନାର୍ଗେ ଆସ୍ ଗାଟି ପ୍ରଚାର୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ବର୍ଣ୍ଣବା ନୁ ଶାଉଲ୍‍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ସେବା ପାଡ଼୍‍ୟି ଶେଷ୍‍ମାଡ଼ି ଯୋହନ୍‌ ଇତ୍‍କେ ଓରଫ ମାର୍କଙ୍କ୍ ସାଙ୍ଗେ ଆସ୍ ଯିରୁଶାଲମ୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ଆନ୍ତିୟକିଆ ମଣ୍ଡଲିତାଗ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ବାବବାଦୀ ନୁ ଶିକ୍ଷାଗୁରୁଡ଼୍ ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବର୍ଣ୍ଣବା, ଶିମୋନ୍ ବେନଙ୍କ୍ ଗୁଡି ନାରୁଣ୍ଡ୍‍ ଇଞ୍ଜ କେତିତଡ଼୍‍, ଲୁସିଆତେ କୁରିନୀୟ ନାର୍‍ଦେନଣ୍ଡ୍, ମନହେମ୍ ଶାଉଲ୍‍ ରାଜ୍ୟପାଳ ହେରଦ୍‍ତେ ପରିବାର୍‍ତାଗ୍ ପେର୍‍ସ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ଅଡ଼୍‌ ପ୍ରବୁନାଦ୍ ସେବା ନୁ ଉପାସନା ମାଡ଼ାନ୍ ୱେଲେ, ପବିତ୍ର ଆତ୍ମା ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ନାନ୍ ବେନ୍ ପାଡ଼୍‍ୟି ସେଙ୍ଗେ ବର୍ଣ୍ଣବା ନୁ ଶାଉଲ୍‍ତିଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତାନ୍, ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନା ସେଙ୍ଗେ ୱେରେ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ଆଗାଙ୍କ୍‍ ଅଡ଼୍‌‍ ଉପାସନା ନୁ ପ୍ରାର୍ତନା ମାଡ଼ି ଅଡ଼୍‌ ଇର୍‍ୱୁଡ଼୍‍କିଙ୍କ୍ ପର କାୟ୍‍ ୱାଟି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପ୍ରଚାର୍ ମାଡ଼ାନଙ୍କ୍ ରହତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ଇଦ୍‍ ରକମ୍‍ ପବିତ୍ର ଆତ୍ମା ତଡ଼୍ ପ୍ରେରିତ ଆସ୍ ବର୍ଣ୍ଣବା ନୁ ଶାଉଲ୍ ସେଲ୍ୟୁକିଆତାଗ୍ ଆତ୍‍ତଡ଼୍ ନୁ ଆଗାକନ୍‍ସ୍ ସାଇପ୍ରସ୍ ଏର୍‍ଜାହାଜ୍‍ ତଡ଼୍ କୁପ୍ର ଗପ୍‍ତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ଅଡ଼୍‌‍ ସାଲାମି ସହର୍‍ତାଗ୍ ହେଉସ୍ ଇହୁଦୀ ଉପାସନା ଲକିନାଗ୍ ଇଶ୍ୱର୍‌ତେ ଗଟ୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ଦାସ ଯୋହନ୍‌ ମାର୍କ ଅଡ଼୍‌ ତଡ଼୍ ମାଞ୍ଜ୍ ସାହାଯ୍ୟ ମାଡ଼୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ଅଡ଼୍‌ ସାଇପ୍ରସ୍‍ ଗପ୍ ୱେଇସ୍‍ ପାଫୋସ୍‍ତାଗ୍ ଆଦ୍‍ତଡ଼୍ । ଆଗେ ଅଡ଼୍‌ ବାର ଜିସୁ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଇହୁଦୀ ୱାଡେଙ୍କ୍ କାଇଲ୍‍ତଡ଼୍ । ଅଣ୍ଡ୍‌ ନିଜେତିଙ୍କ୍ ବାବବାଦୀ ଇଞ୍ଜ କେସମାତ୍‍ତନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ଅଣ୍ଡ୍‌ ଆଦ୍ ଗପ୍‍ତେ ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ ସର୍ଗିୟସ୍ ପାଉଲ୍‍ସନ୍‍ତେ ସାଙ୍ଗ ମାତ୍‍ତଣ୍ଡ୍ । ସର୍ଗିୟସ୍ ୱେରଣ୍ଡ୍ ବୁଦ୍ଦିମାନ୍ ନାରୁଡ଼୍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଇଶ୍ୱର୍‌ତେ ଗଟ୍ କେଞ୍ଜାନଙ୍କ୍ ବର୍ଣ୍ଣବା ନୁ ଶାଉଲ୍‍ତିଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ଇତ୍‍କେ ୱାଡେ ଏଲୀମାସ୍ ଇଦ୍ ଅନ୍‌‍ୱାଦ୍ ଗ୍ରୀକ୍ ପେଦେର୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାଦା ଇତ୍‍ତେ, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଶାସନ୍‍ କର୍ତ୍ତାଙ୍କ୍ କ୍ରିଷ୍ଟନାଗ୍‍ ବିଶ୍ୱାସ୍ ମାଡ଼ାନଙ୍କ୍ ହାଲ୍‍ସ୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ଇତ୍‍କେ ଶାଉଲ୍‍ ବେନନ୍ ମେଣ୍ଡେଅନ୍‌ ପେଦେର୍ ପାଉଲ୍ ପବିତ୍ର ଆତ୍ମାତେ ବର୍ତ୍ତି ଆସ୍ ୱାଡ଼େନାକ୍ କପାମ୍‍ତେ ଉଡ଼୍‍ତଣ୍ଡ୍ ନୁ କେତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ହୋ ଶୟ୍‍ତାନ୍‍ତେ ମାର୍‍ ! ନିମ୍‍ ସାରେ ସାୟେତ୍ ବିଷୟ୍‍ତାଦ୍ ଶତ୍ରୁଡ଼୍ । ନିମ୍‍ ସାରେ ଲେକାତ୍ କାରାପ୍ ବିଦ୍ୟା ପୁତ୍‍ତି ନୁ ସାରେଦାମ୍ ପ୍ରବୁନ୍ ସତ୍‍ତିଙ୍କ୍ ମିଚ୍‍ ଇଞ୍ଜ ପ୍ରମାଣ୍ ମାଡ଼ାନଙ୍କ୍ ହାଲ୍‍ସୁତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଇଞ୍ଜେ ନିମ୍‍ ପ୍ରବୁନ୍ କାୟ୍‍ଦେ ଦଣ୍ଡିତ୍ ଆଦ୍‍ତିନ୍‍ । ନିମ୍‍ କାନାଲ୍ ଆସ୍ ସୁଦୁଟ୍‍ ସମୟ୍‍ ଏୱୁନା ଦିନାମ୍‍ତେ ୱେସ୍ ଉଡ଼ାନଙ୍କ୍ ପାର୍‍ୱିନ୍ ।” ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଏଲୀମାସ୍‍ତେ କଣ୍ଡା ଗାଟି ଗୁମାମ୍‍ତେ ମିଶାନ୍ ଲେକାମ୍ ଏର୍କା ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଅଣ୍ଡ୍‌ ତାନ୍ କାୟ୍ ପୟ୍‍ସ୍ ହାର୍ ତଅତାନ୍ ମାଇଦିଙ୍କ୍ ଅର୍‍ତୁଙ୍କ୍ ମେହେକ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ଇଦ୍ ଗଟ୍‍ନା ଉଡ଼ି ଶାସନ୍‍ କର୍ତ୍ତାଲ୍‍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଣ୍ଡ୍‍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ପ୍ରବୁନାଦ୍ ଶିକ୍ଷା କେଞ୍ଜି କାବା ଆସ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ପାଉଲ୍ ନୁ ତାମ୍ ତଡ଼୍‍ଦେନଡ଼୍ ପାଫୋସ୍‍ ପେଦେର୍‍ତେ ଜାଗେତାଗାଙ୍କ୍ ଏର୍‍ଦାଗ୍ ଆଞ୍ଜ୍ ପଂଫୁଲିୟାତେ ପର୍ଗା ପେଦେର୍‍ତେ ଅଣ୍ଡୟ୍‌ ନାର୍‍ତାଗ୍ ହେୱୁତ୍‍ତଡ଼୍ । ଯୋହନ୍‌ ମାର୍କ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଗେ ୱିଡ଼୍‍ସି ଯିରୁଶାଲେମ୍‍ ମାଲ୍‍ସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ଅଡ଼୍‌ ପର୍ଗାତାଗାଙ୍କ୍ ଆଞ୍ଜ୍ ପିସିଦିଆତେ ଅନ୍‌ଥିୟୋକ୍‍ତାଗ୍ ହେୱୁତ୍‍ତଡ଼୍ ନୁ ବିଶ୍ରାମ୍‍ଦିନେ ଦିନ୍ ଉପାସନା ଲତ୍‍ତାଗ୍ ଆଞ୍ଜ୍ କୁଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ମୋଶାନ୍‌‌ ନିୟମ୍‍ ନୁ ବାବବାଦୀଡ଼ାଦ୍ ଲେକ୍‍ତାଦ୍ କାର୍‍ତେ ପେର୍‍କେ, ଉପାସନା ଲୋତ୍‍ତେ କର୍ତ୍ତାଲଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଇଦ୍ ଗଟ୍ କେସ୍ ରହତ୍‍ତଡ଼୍, “ଦାଦାଲଡ଼୍‍, ଯଦି ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ସାର୍‍ଦେ ମାଡ଼୍‍ତେ ଲେକାମ୍ ମିୟାଦ୍ ବାତ୍ ଗଟ୍ ମିନ୍ଦେ, ଆଲେକେ କେଲାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ପାଉଲ୍ ନିସ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କଟମାନ୍ଦାନଙ୍କ୍ କାୟ୍‍ ଉହୁସ୍ କେତ୍‍ତଣ୍ଡ୍, “ଇଗେ ମାନ୍ଦାନଡ଼୍ ଇସ୍ରାଏଲୀୟ ଦାଦାଲଡ଼ି ନୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ମାନ୍ଦାନ୍ ଅଣଇହୁଦୀଡ଼୍, ନା ଗଟ୍ କେଞ୍ଜାଟ୍ ! ");
INSERT INTO kff_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଇସ୍ରାଏଲ୍‍ ଜାତିତ୍ ଇଶ୍ୱର୍ ମାନ୍‍ ଆନିଦାଦିଡ଼୍‍କ୍ ଏଞ୍ଚିତଣ୍ଡ୍ ନୁ ମିସର୍‍ତାଗ୍ ଅଡ଼୍‌ ବେନ୍‍ ଦେଶ୍‍ ଲେକାମ୍ ବାସେମାଡ଼ାନ୍ ୱେଲେ ଅଣ୍ଡୟ୍‌ ବେଡ଼୍‍ୟାଦ୍‍ ଜାତି ମାଡ଼୍‍ତଣ୍ଡ୍ । ଇଶ୍ୱର୍ ତାନ୍ ଶକ୍ତିତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମିସର୍‍ତାଗାଙ୍କ୍ ପେସ୍‍ପିଇ ତାତ୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ଚାଳିଶ୍ ହେଣ୍ଡ୍‍କ୍ ଯାକ ଉଚ୍‍କନେଲ୍‍ତାଗ୍ ଅଡ଼ାଦ୍‌ ଅତ୍ୟାଚାର୍ ସାରେ ସହ୍ୟ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ଅଣ୍ଡ୍‌ କିନାନ୍‍ତାଗ୍ ସାତ୍‍ଟାନ୍ ଗଷ୍ଟିତିଙ୍କ୍ ଦସଂ ମାଡ଼ି ତାନ୍ ହେଞ୍ଚ୍‍ତେ ଗଷ୍ଟିତିଙ୍କ୍ ଆଦ୍ ଦେଶ୍‍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ସାରେ ନାଲୁୱାନ୍ଦା ପାଚାଶ୍ ହେଣ୍ଡ୍‍କ୍ ଲୋପେ ଇୱୁସାରେ ଗଟନା ଗଟେମ୍ ଆତ୍‍ତେ । ଇଦିନ୍ ପେର୍‍କେ ଶାମୁୟେଲ୍‍ ବାବବାଦୀନ୍ ଦିନାମ୍ ଏୱୁନା ଇଶ୍ୱର୍ ଅଡ଼୍‌ ପର୍‍ର ବିଚାର୍ କର୍ତ୍ତାଲ୍ଡ଼୍‍କ୍ ହେଞ୍ଚ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ବେସୁଟ୍‌ ଅଡ଼୍‌ ୱେରଣ୍ଡ୍ ରାଜାଙ୍କ୍ ମେହେକ୍‍ତଡ଼୍, ଇଶ୍ୱର୍ ଅଡ଼୍‌ ପର୍‍ର ଚାଳିଶ୍ ହେଣ୍ଡ୍‍କ୍ ଯାକ ଶାସନ୍‍ ମାଡ଼ାନଙ୍କ୍ ବେଞ୍ଜାମିନ୍ ବଂଶତଣ୍ଡ୍ କୀଶତେ ମାର୍‍ ଶାଉଲ୍‍ତିଙ୍କ୍ ନିଯୁକ୍ତି ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ତାନ୍‍ପେର୍କେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ପଦ ୱିଡ଼୍‍ସ୍ପି ଦାଉଦଙ୍କ୍ ତାମ୍‍ ରାଜାଲ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଇଶ୍ୱର୍ ଅନ୍‌ ବିଷୟ୍ ସାକ୍ଷ୍ୟ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ‘ନାନ୍ ବେସତ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ବଲ୍‍ପାଏମ୍‍ ଆଦ୍‍ତାନ୍, ଯେଶୀତେ ମାର୍‍ ଦାଉଦ୍ ଆଦେପୁଟୁଙ୍କ୍ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍; ଅଣ୍ଡ୍‌ ନା ଇଚ୍ଛା ଲେକାମ୍ ପାଡ଼୍‍ୟି ମାଡ଼ିତନ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ଇଣ୍ଡ୍ ଦାଉଦ୍‍ତେ ବଂଶତଣ୍ଡ୍ ଜିସୁଙ୍କ୍ ଇଶ୍ୱର୍ ତାନ୍ ପ୍ରତିଜ୍ଞା ଲେକାମ୍ ଇସ୍ରାଏଲ୍‍ ଜାତିଡ଼୍ ତ୍ରାଣକର୍ତ୍ତାଲ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜିସୁ ତାନ୍ ପାଡ଼୍‍ୟି ଆରାମ୍ ମାଡ଼ାନ୍ ମୁନେଙ୍କ୍ ଯୋହନ୍‌ ଇସ୍ରାଏଲ୍‍ତେ ସାରେ ନାରୁଡ଼୍‍ତେ ଗାର୍‍ରେ ପ୍ରଚାର୍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌ ପାପ୍‍ତାଗାଙ୍କ୍ ଅନୁତାପ୍‍ ମାଡ଼ି ଏର୍‍ଦିକ୍ଷା ଆଦାନଙ୍କ୍ ୱେୟ୍‍ତିତ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ମେଣ୍ଡେ ଯୋହନ୍‌ ଅନାଦ୍‌ ସେବା ପାଡ଼୍‍ୟି ତେର୍‍ସ୍ପାନ୍ ମୁନେଙ୍କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ‘ନା ବିଷୟ୍‍ତେ ମିଡ଼୍ ବାତ୍ ହାଲ୍‍ସୁତିଡ଼୍ ? ମିଡ଼୍ ବେନଙ୍କ୍ କେପ୍‍ତିଡ଼୍, ନାନ୍ ଅଣ୍ଡ୍‌ ଆୟନ୍ । ବାତେଙ୍କ୍ଇତ୍‍କେ କେଞ୍ଜାଟ୍ ! ନା ପେର୍‍କେ ବେନ ୱାଦୁତଣ୍ଡ୍, ନାନ୍ ଅନାଦ୍‌ ଡେକେତ୍ ହେର୍‍ପୁକ୍ ଲେଏତାନଙ୍କ୍ ମିକା ଯୋଗ୍ୟ ଆୟନ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ଅବ୍ରାହାମ୍ ବଂଶତଡ଼୍ ହୋ ଇଶ୍ରାଏଲୀୟ ଦାଦାଲଡ଼୍‍ ନୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରାର୍ତନା ମାଡ଼ାନଡ଼ି ଅଣଇହୁଦୀ ନାରୁଡ଼ି, ମାକିଂକେ ଇଦ୍ ମୁକ୍ତିତେ କାବୁର୍ ଇସ୍‌ ମିନ୍ଦେଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଯେ ବିଚାର୍ କର୍ତ୍ତାଲ୍, ଯିରୁଶାଲେମ୍‍ ଆଦିବାସୀ ନୁ ଅଡ଼୍‌ ନେତାଲଡ଼୍ ଆଦ୍ ପୁନ୍‍ୱେ ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ସାରେ ବିଶ୍ରାମ୍‍ବାର୍‍ଦାଗ୍ କାର୍‍ତାନ୍ ବାବବାଦୀଡ଼ାଦ୍ ଗଟ୍‍ତେ ଅର୍ତ ବୁଜେମ୍ ଆୟ୍‍ୱେ ମାତ୍‍ତଡ଼୍ । ଇତ୍‍କେ ଜିସୁଙ୍କ୍ ଦଷି ମାଡ଼ି ଅଡ଼୍‌ ବାବବାଦିଡ଼ାଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ସଫଳ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ଡଲାନ୍‌ଦଣ୍ଡ୍‍ତାଦ୍ ବାଆତେ କାରନ୍‍ ଦର୍‍କ୍‍ୱେ ମାତ୍‍କେ ଗାଲା ଅଂକିଙ୍କ୍‌ ଡଲାନ୍‍ଦଣ୍ଡ୍ ହିଦାନ୍ ସେଙ୍ଗେ ପିଲାତଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ଅନ୍‌ ବିଷୟ୍‍ତେ ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ବେନ୍‍ସାରେ ବିଷୟ୍ ଲେକାମିନ୍ଦେ, ଆଦ୍ ଲେକାମ୍ ସାରେ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତେ ପେର୍‍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ କ୍ରୁଶତାଗାଙ୍କ୍ ଡିପିତାସ୍ ଅଣ୍ଡୟ୍‌ ସମାଦିତାଗ୍ ୱାଟ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ଇତ୍‍କେ ଇଶ୍ୱର୍ ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଏତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ନାର୍‍ଗେ ଦିନା ଯାକ ଅନ୍‌‍ତଡ଼୍ ଗାଲିଲୀତାଗାଙ୍କ୍ ଯିରୁଶାଲେମ୍‍ ଆଦାୱାଦା ମାଡ଼ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଣ୍ଡ୍‌ ତଅନ୍‌ଦ୍‍ତଣ୍ଡ୍ । ଇଞ୍ଜେ ଅଡ଼୍‌ ଇଶ୍ରାଏଲ୍‍ ନାରୁଡ଼୍ ଗାର୍‍ରେ ସାକ୍ଷି ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ମାମ୍‍ମେ ଇଗେ ମିକିଂଙ୍କ୍ ଇଦ୍ ସୁସମାଚାର୍‍ କେତାଙ୍କ୍ ୱାତ୍‍ତମ୍ । ଇଶ୍ୱର୍ ମାନ୍‍ ଆନିଦାଦୀଡ଼୍‍କ୍ ବେନ୍ ପ୍ରତିଜ୍ଞା ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ଆଦ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ଅଡ଼ାଦ୍‌ ବଂଶ ମାନ୍‍ ସେଙ୍ଗେ ଜିସୁଙ୍କ୍ ପୁନର୍ଜିବିତ୍‍ ମାଡ଼ାନ୍ ତଡ଼୍ ଅଣ୍ଡ୍‌ ଆଦ୍ ସାରେ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଗୀତସଂହିତାତେ ଦ୍ୱିତିୟ ଗୀତତାଗ୍ ଇଦ୍ ଗଟ୍‍ତିଙ୍କ୍ ଉଡ଼ି ଲେକାମିନ୍ଦେ; ‘ନିମ୍‍ ନା ମାର୍‍, ନେଣ୍ଡ୍ ନାନ୍ ନି ବାବାଲ୍ ଆତ୍‍ତାନ୍,’ ");
INSERT INTO kff_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ଅଂକିଙ୍କ୍‌ ସମାଦିତାଗ୍ କାଡ଼୍‍ୟାନଙ୍କ୍ ୱିଡ଼୍‍ସଣ୍ଡ୍, ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଏତାନ୍ ସେଙ୍ଗେ ଇଶ୍ୱର୍ ଇଦ୍ ଗଟ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍; ‘ଦାଉଦଙ୍କ୍ ଇସ୍‌‍ମାନ୍ଦାନ୍ ପ୍ରତିଜ୍ଞା ଲେକେମ୍‍ ନାନ୍ ବିଶ୍ୱାସୀଡ଼୍‍କିଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ନୁ ନିଜାମ୍ ଆର୍ଶିବାଦ୍ ମାଡ଼ିତାନ୍ ।’ ");
INSERT INTO kff_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ଶାସ୍ତ୍ରତାଗ୍ ମେଣ୍ଡେଅନ୍‌ ପଡ଼୍‍ୟିତାଗ୍ ଲେକାମିନ୍ଦେ, ‘ନିମ୍‍ ନି ବିଶ୍ୱସ୍ତ ସେବକ୍‍ତିଙ୍କ୍ ସମାଦିତାଗ୍ କାଡ଼୍‍ୟି ଆଦାନଙ୍କ୍ ୱିଡ଼୍‍ସ୍‍ମା ।’ ");
INSERT INTO kff_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦ୍ ତାନ୍ ଶାସନ୍‍ ମାଡ଼ାନ୍ ୱେଲେ ଇଶ୍ୱର୍‌ତେ ଉଦେଶ୍ୟ ପୁରା ମାଡ଼୍‍ତେ ପେର୍‍କେ ଡଲ୍‍ତଣ୍ଡ୍ ନୁ ଆନିଦାଦିଡ଼୍ ତଡ଼୍ ସମାଦି ପାଏମ୍ ଆତ୍‍ତଣ୍ଡ୍ । ଅନ୍‌ ମେନ୍ଦୁଲ୍ ସମାଦିତାଗ୍ କାଡ଼୍‍ୟି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ଇତ୍‍କେ ଇଶ୍ୱର୍ ବେନଙ୍କ୍ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଏତଣ୍ଡ୍, ଅଣ୍ଡ୍‌ ନଷ୍ଟ ଆୟ୍‍ୟଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ମୋଶାଲ୍‌ ହୋ ଦାଦାଲଡ଼୍‍ କେଞ୍ଜାଟ୍‍, ମାତର୍‍ ପ୍ରବୁ ଜିସୁନ୍ ତଡ଼୍ ମି ବକେତ୍‍ ପାପ୍‍ କ୍ଷମା ଗଟ୍‍ ପ୍ରଚାର୍‍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ମୋଶାନ୍‌‌ ନିୟମ୍‍ତଡ଼୍ ପାପ୍‍ କ୍ଷମା ପାଏମ୍ ଆୟ୍‍ୱେନଡ଼୍ ସାରେତଡ଼୍ ଆ ଜିସୁଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍କେନେ ପରିତ୍ରାଣ୍ ଦର୍‍କିତ୍, ଇଦ୍ ମିଡ଼୍‍ ବୁଜେମ୍ ଆଦାନ୍ ଦର୍‍କାର୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ଆଦିଙ୍କ୍ ସାବ୍‍ଦାନ୍ ଆସ୍ ମାନୁଟ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ବାବବାଦୀଡ଼ାଦ୍ ଶାସ୍ତ୍ରତାଗ୍ ବାତ୍ କେତ୍‍ତଡ଼୍, ଆଦ୍ ମିଇ ପର୍‍ର ବେଲା ୱାଡ଼୍‍ମାକି, ");
INSERT INTO kff_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ହୋ ବଲୁଡ଼୍‍ ନାରୁଡ଼ି ! ମିଡ଼୍ କଲ୍‍ବଲ୍‍ ଆସ୍ ଡଲାଟ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ନାନ୍ ନେଣ୍ଡ୍ ବେନ୍ ପାଡ଼୍‍ୟି ମାଡ଼ୁତାନ୍, ବେନ ମିକିଂଙ୍କ୍ ବୁଜାମାଡ଼ି କେତ୍‍କେ ମିକା ମିଡ଼୍ ବିଶ୍ୱାସୀ ଆୟ୍‍ୱିଡ଼୍ ।’” ");
INSERT INTO kff_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଉଲ୍‍ ନୁ ବର୍ଣ୍ଣବା ଉପାସନା ଲତ୍‍ତାଗାଙ୍କ୍ ପେଇସ୍‍ ୱାତ୍‍ତେ ୱେଲେ, ମେଣ୍ଡେଅନ୍‌ ବିଶ୍ରାମ୍‍ଦିନ୍ ଦିନ୍ ମାଲ୍‍ସ୍ ୱାସ୍ ଇୱୁ ସାରେ ଶିକ୍ଷା ବିଷୟ୍ ମେଣ୍ଡେ ଅଦିକ୍‌ ବୁଜାମାଡ଼ାନଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ନାରୁଡ଼୍ ଉପାସନା ଲନ୍‍ ମିଟିଙ୍ଗ୍‍ ୱିଡ଼୍‍ସି ଆତ୍‍ତେ ପେର୍‍କେ ନାର୍‍ଗେ ଇହୁଦୀ ନୁ ଅବିଶ୍ୱାସୀଡ଼୍ ଶାଉଲ୍‍ ନୁ ବର୍ଣ୍ଣବାନ୍‍ ପେର୍କେପେର୍କେ ଆତ୍‍ତଡ଼୍, ପ୍ରେରିତ୍‍ଶିଷ୍ୟଡ଼୍ ଅଡ଼୍‌‍ତଡ଼୍ ତିର୍‍ୟି ଇଶ୍ୱର୍‌ତେ ଅନୁଗ୍ରହତଡ଼୍ ବାଦ୍‍କାନଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେଡ଼୍‌କେ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ମେଣ୍ଡେଅନ୍‌ ବିଶ୍ରାମ୍‍ଦିନ୍ ଦିନ୍ ଟାୱୁନ୍‍ତେ ସାରେତଡ଼୍ ପ୍ରବୁନାଦ୍ ଗଟ୍ କେଞ୍ଜାନ୍ ମାଇଦିଙ୍କ୍ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ନାରୁଡ଼୍ ଗହଲିତିଙ୍କ୍ ଉଡ଼ି ଇହୁଦୀଡ଼୍ ଇର୍ଷା ମାଡ଼୍‍ତଡ଼୍ ନୁ ପାଉଲ୍‍ତେ ଗଟ୍‍ତିଙ୍କ୍ ଅତ୍ୟାଚାର୍ ମାଡ଼ି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅପମାନିତ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ଇତ୍‍କେ ପାଉଲ୍‍ ନୁ ବର୍ଣ୍ଣବା ସାହାସ୍ ତଡ଼୍ କେତ୍‍ତଡ଼୍, ମିଇ ବକେତ୍ ମୁନେନ୍ ଇଶ୍ୱର୍‌ତେ ଗଟ୍ ପ୍ରଚାର୍ ଆଦାନ୍ ମାତ୍‍ତେ । ବାତେଙ୍କ୍ଇତ୍‍କେ ମିଡ଼୍ ଅନନ୍ତ ଜିୱୁଣ୍ଡ୍ ପାଏମ୍ ଆଦାନଙ୍କ୍ ନିଜେତିଙ୍କ୍ ଅଯୋଗ୍ୟ ବିଚାର୍‍ ଇଦିଙ୍କ୍ ମନା ମାଡ଼୍‍ତାଙ୍କ୍, ମାମ୍‍ମେ ମିକିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ଅଣଇହୁଦୀଡ଼୍ ବକେତ୍ ଆଦ୍‍ତାଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ବାତେଙ୍କ୍ଇତ୍‍କେ ପ୍ରବୁ ମାକିଂଙ୍କ୍ ଇଦ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍; “ନାନ୍ ମିକିଂଙ୍କ୍ ଅଣଇହୁଦୀଡ଼୍ ସେଙ୍ଗେ ୱେସ୍ ଲେକେମ୍ ମାଡ଼୍‍ତାନ୍, ବେଲାକି ପୁରା ପୃତିବିତାଗ୍ ପରିତ୍ରାଣ୍ ପାଏମ୍ ଆଦ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ଅଣଇହୁଦୀଡ଼୍ ଇଦ୍ କେଞ୍ଜି ୱେଡ଼୍‍କେ ଆତ୍‍ତଡ଼୍ ନୁ ପ୍ରବୁନ୍ ବାକ୍ୟ ସେଙ୍ଗେ ଦନ୍ୟବାଦ୍ ହିତ୍‍ତଡ଼୍ । ବେନଡ଼୍ ଅନନ୍ତ ଜିୱୁଣ୍ଡ୍ ମାଇଦିଙ୍କ୍ ହେଞ୍ଚିମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଆଦ୍ ଗଟ୍‍ତାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ଆଦ୍ ପଡ଼୍‍ୟିତାଗ୍ ସାରେତାଗ୍ ପ୍ରବୁନ୍ ଗଟ୍ ଏକାମ୍‍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ଇତ୍‍କେ ଇହୁଦୀଡ଼୍ ନଗର୍‍ତେ ଉପାସନା ମାଡ଼ାନ୍‍ ନେତାଲଡ଼୍‍କ୍ ନୁ ନାଟାକିଂଙ୍କ୍‍ ପୁସ୍‍କାମାଡ଼ି ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବାନ୍ ପର୍‍ର ତାଡ଼ନା ମାଡ଼୍‍ତଡ଼୍ ନୁ ଆଦ୍ ପଡ଼ିୟେତାଗାଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପେସ୍‍ସ୍ପିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ଆଗାଙ୍କ୍‍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଆ ନାରୁଡ଼୍‍କ୍ ବିରୁଦ୍ ମାଡ଼ି ତାମ୍ ଡେକେତ୍ ଦୁମ୍ କାୟ୍‍ସ୍ ଇକନିୟାତାଗ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଅନ୍‌ଥିୟୋକ୍‌ତେ ବିଶ୍ୱାସୀ ଶିଷ୍ୟ ପବିତ୍ର ଆତ୍ମାତଡ଼୍ ପୁରାହାସ୍ ୱେଡ଼୍‍କେ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଇକନିୟାତାଗ୍ ଆଦ୍ ଗଟନା ମେଣ୍ଡେଅଣ୍ଡ୍‌‍ଦାମ୍ କେତ୍‍ତଡ଼୍; ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବା ପ୍ରାର୍ତନା ଲତ୍‍ତାଗ୍ ଆଞ୍ଜ୍ ଇଦ୍‍ରକମ୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ ଯେ ନାର୍‍ଗେ ଇହୁଦୀ ନୁ ଗ୍ରୀକ୍‍ ଅଣଇହୁଦୀଡ଼୍ କ୍ରିଷ୍ଟଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ଇତ୍‍କେ ବେନ୍‍ ଇହୁଦୀ ଅବିଶ୍ୱାସୀଡ଼୍ ଦାଦାଲଡ଼୍‍ ନୁ ଅଣଇହୁଦୀଡ଼୍‍କ୍ କାରାପ୍ ଗଟ୍ କେସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବିଶ୍ୱାସୀଡ଼୍‍ ବିରୁଦ୍‍ତେ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ମିକା ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ପ୍ରବୁନ୍ ବିଷୟ୍ ସାହାସ୍‍ତଡ଼୍ ପ୍ରଚାର୍ ମାଡ଼ି ନାର୍‍ଗେ ଦିନା ଆଗେ ମାତ୍‍ତଡ଼୍ । ଆଦ୍‍ବୁତ୍‌ ପାଡ଼୍‍ୟି ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼ାନ୍ ତଡ଼୍ ପାଉଲ୍‍ ନୁ ବର୍ଣ୍ଣବା ପ୍ରମାଣ୍ ମାଡ଼୍‍ତଡ଼୍ ଯେ, ଇଶ୍ୱର୍‌ତେ ଅନୁଗ୍ରହ ବିଷୟ୍‍ତେ ପ୍ରଚାର୍ ମାଡ଼୍‍ତେ ଗଟ୍ ନିଜାମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ନଗର୍‍ତେ ନାରୁଡ଼୍ ରେଣ୍ଡ୍ ମାନ୍ଦେ ଆତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଇହୁଦୀ ନାରୁଡ଼୍‍କ୍ ନୁ ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କ୍ ସପଟ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ତାନ୍‍ପେର୍କେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଅଣଇହୁଦୀ ନୁ ଇହୁଦୀ ନାରୁଡ଼୍ ତାମ୍ ନେତାଲଡ଼୍ ତଡ଼୍ କାଇଲି ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍‍କିଂଙ୍କ୍ କାରାପ୍ ବ୍ୟବହାର୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାଲ୍‍କିନ୍ ତଡ଼୍ ରେହେସ୍ ଆୱ୍‍କାଂଙ୍କ୍ ଟିକ୍‍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଇଦ୍ ବିଷୟ୍ ପୁଞ୍ଜ୍ ଲୁକାନିଆତେ ଲୁସ୍ତ୍ରା ନୁ ଦର୍ବୀ ନାର୍ ନୁ ତାମ୍‌ ସାରେପାକ୍ ମାନ୍ଦାନ୍ ପଡ଼ିୟେତାଗ୍ ଆତ୍‌ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ଆଗେ ଅଡ଼୍‌ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍ତ୍ରାତାଗ୍ ୱେରଣ୍ଡ୍ ଜନମ୍‍ତାଗାଙ୍କ୍ କୁଟାଲ୍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ବିଲ୍‍କୁଲ୍ ତାକାଙ୍କ୍ ପାର୍‍ୱେମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ଆଗେ କୁଦି ଅଣ୍ଡ୍‌ ପାଉଲ୍‍ତେ ଶିକ୍ଷା କେଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ । ଅନ୍‌ ମନ୍‍ତାଗ୍ ବିଶ୍ୱାସ୍ ୱାତ୍‍ତେ ନୁ ଅଣ୍ଡ୍‌ ସୁସ୍ଥ ଆଦ୍‍ତନ୍ ଇଞ୍ଜ ପାଉଲ୍ ପୁତ୍‍ତଣ୍ଡ୍ । ଆଦିଙ୍କ୍ ଅନାକ୍ ଅଣ୍ଡୟ୍‌ କଣ୍ଡେତେ ଉଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ପାଉଲ୍ ଗାଟି ଲେଙ୍ଗ୍‍ତଡ଼୍ କେତ୍‍ତଣ୍ଡ୍, “ଡେକେତିଙ୍କ୍ ଗାଡ଼୍‍ସ୍ ମାଡ଼ି ତିନାଙ୍କ୍ ନିଲ୍‍ମ୍ !” ଆଗାଙ୍କ୍‍ ଆ ନାରୁଣ୍ଡ୍‍ ତୁଲିମିକା ସାରେପାକ୍ ତାକାନଙ୍କ୍ ପସ୍‍ସ୍ପତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ଲୁକାନିଆ ତାଗ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ପାଉଲ୍‍ତାଦ୍ ଇଦ୍ ପାଡ଼୍‍ୟି ଉଡ଼ି କିଡ଼୍‍କି କିଡ଼୍‍କି କେତାନଙ୍କ୍ ପସ୍‍ସ୍ପତଡ଼୍, “ଦେୟାକ୍‍ ନାରୁଡ଼୍ ରକମ୍ ଆସ୍ ମାୟାଗ୍‌ ୱାତ୍‍ତା ।” ");
INSERT INTO kff_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ଅଡ଼୍‌ ବର୍ଣ୍ଣବାଙ୍କ୍ ଜିଆସ୍ ବା ବାଡ଼୍‍ୟେ ଦେୟାମ୍‍ ବା ବୃହସ୍ପତି ନୁ ପାଉଲ୍‍ ବେଡ଼ିୟି ବକ୍ତାଲ୍ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ହେରମିସ୍ ବା ଗାଟି ତିର୍‍ୟାନଣ୍ଡ୍‍ ଦେୟାମ୍‍ ବା ବୁଦ୍‌ ଇଞ୍ଜ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଟାୱୁନ୍‍ତେ ବାୟିଦେ ମାନ୍ଦାନ୍ ଜିଆସ୍ ମନ୍ଦିର୍‍ତେ ଜାଜକୀଡ଼୍‍, ମାର୍ ବକେତ୍ ବେସ୍‌କ୍ କନ୍ଦା ନୁ ପୁଙ୍ଗାର୍ ତାତ୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ନୁ ଆଗେ ମାନ୍ଦାନ୍ ଗୁଡ଼ିମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଉଦ୍ଦେଶ୍ୟତେ ପୂଜାନ୍‌ ସେଙ୍ଗେ ଇଚ୍ଛା ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ଅଡ଼୍‌ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ପାଡ଼୍‍ୟି ମାଡ଼ାନଙ୍କ୍ ଆଞ୍ଜ ମାତ୍‍ତଡ଼୍, ବର୍ଣ୍ଣବା ନୁ ପାଉଲ୍ ଆଦ୍ କେଞ୍ଜ୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ନିଜେତ୍ ଚକା କୁସ୍ପ୍‍ତଡ଼୍, ନାରୁଡ଼୍ ଲପେ ମିରିଆଞ୍ଜ୍ କିଡ଼୍‍କି ମିକା କେତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ମିଡ଼୍ ବାତେଙ୍କ୍ ଇଦ୍ ମାଡ଼ୁତିଡ଼୍ ? ମାମ୍‍ମେ ମିଇ ଲେକାମ୍ ନାରୁମ୍ । ମିଇ ବକେତ୍ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼ାନଙ୍କ୍ ନୁ ଇୱୁ ଦର୍‍କାର୍ ହିଲ୍‍ୱାଦ୍ ବିଷୟ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସି, ସ୍ୱର୍ଗ, ପୃତିବି ନୁ ତାନ୍ ଲୋପେ ମାନ୍ଦାନ୍ ସାରେ ଜିନିଷ୍‍ତିଙ୍କ୍ ସୃଷ୍ଟିମାଡ଼୍‍ତେ ଜିୱେତଣ୍ଡ୍ ଇଶ୍ୱର୍‌ତେ ପାକେ ମିକିଂଙ୍କ୍ ଆଦାନ୍ ସେଙ୍ଗେ ମାମ୍‍ମେ ଇଗେ ୱାତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ମୁନେନ୍ ନିଜର୍‍ ଇଚ୍ଛାତେ ନିଜର୍‍ ହାର୍‍ଦାଗ୍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ଇଶ୍ୱର୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଦେଶ୍‍ ତାଗ୍‍ ୱିଡ଼୍‍ସି ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ଇତ୍‍କେ ଅନାଦ୍‌ ସାରେ ସତ୍‍କାମ୍‍ ତଡ଼୍ ଅଣ୍ଡ୍‌ ସାରେଦାମ୍ ତାନ୍ ବିଷୟ୍‍ତେ ନିୟମ୍ ହିତ୍‍ତଣ୍ଡ୍; ଅଣ୍ଡ୍‌ ସ୍ୱର୍ଗତାଗାଙ୍କ୍ ୱାର୍‍ସାମ୍ ନୁ ଟିକ୍ ସମୟ୍‍ତେ ଫସଲ୍ ହିଦ୍‍ତଣ୍ଡ୍, କାଦି ଯୋଗାମାଡ଼ିତଣ୍ଡ୍ ନୁ ୱେଡ଼୍‍କେତେ ମିୟାଦ୍ ହୃଦୟ୍ ପୁରା ମାଡ଼ିତନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ଇୱୁସାରେ ଗଟି କେସ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ଗାଟି ତିପାଲ୍‍ତେ ବେଲାମେଣ୍ଡେ ବଲି ଇଦାନାଦ୍ ବନ୍ଦ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ପିସିଦିଆତେ ଅନ୍‌ଥିୟୋକ୍‍ ନୁ ଇକନିୟାତାଗାଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଇହୁଦୀ ୱାସ୍‍ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଉସ୍କା ମାଡ଼ି ପାଉଲ୍‍ତିଙ୍କ୍ କାଲ୍‍କିନ୍ ତଡ଼୍ ରେହେତ୍‍ତଡ଼୍ ନୁ ଅଂକିଙ୍କ୍‌ ଡଲ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ହାଲ୍‍ସି ଟାୱୁନ୍‍ତେ ବାୟିଦେ ଇଡ଼୍‍ସି ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ଇତ୍‍କେ ଶିଷ୍ୟଡ଼୍ ୱାସ୍ ତାନ୍ ତିଡ଼୍‍ୟିପାକ୍ ଗେରାମାଡ଼ି ନିତ୍‍ତେ ପେର୍‍କେ ଅଣ୍ଡ୍‌ ତେଦି ଟାୱୁନ୍‍ତାଗ୍ ମାଲ୍‍ସ୍ ଆତ୍‍ତଣ୍ଡ୍ । ମେଣ୍ଡେଅନ୍‌ ଦିନ୍ ଅଣ୍ଡ୍‌ ନୁ ବର୍ଣ୍ଣବା ଦର୍ବୀତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବା ଦର୍ବୀତାଗ୍ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼ି ନାର୍‍ଗେ ଶିଷ୍ୟଡ଼୍‍କ୍ ଦର୍‍ସ୍କ୍‍ତଡ଼୍ । ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଲୁସ୍ତ୍ରା, ଇକନିୟା ନୁ ପିସିଦିଆତେ ଅନ୍‌ଥିୟୋକ୍‍ତାଗ୍ ମାଲ୍‍ସ୍‍ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ଅଡ଼୍‌ ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ଶିଷ୍ୟ ନିଜେତ୍ ବିଶ୍ୱାସ୍‍ତାଗ୍ ଲେକେତ୍‌ ମାନ୍ଦାନଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଶିକ୍ଷା ଇସ୍‌ କେତ୍‍ତଡ଼୍, “ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟତାଗ୍ ହସାନ୍ ମାଇଦିଙ୍କ୍ ମାକିଂଙ୍କ୍ ଗାଟି ଦୁଃକକଷ୍ଟ ଇସ୍‌ ଆଦାଙ୍କ୍ ୱେୟ୍‍ତିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ସାରେ ମଣ୍ଡଲିନାଗ୍ ଅଡ଼୍‌ ଦାୟିତ୍ୱ ଇସ୍‌ ମଣ୍ଡଲିତେ ବୟସ୍କା ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନିଯୁକ୍ତି ମାଡ଼୍‍ତଡ଼୍ ନୁ ବେନ୍ ପ୍ରଭୁନାଗ୍ ଅଡ଼୍‌ ବିଶ୍ୱାସ୍ ମାଡ଼ିମାତ୍‍ତଡ଼୍, ପ୍ରାର୍ତନା ନୁ ଉପବାସ୍ ତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦ୍ ପ୍ରବୁନ୍ ଗାର୍‍ରେ ସର୍ପା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ପିସିଦିଆ ଜାଗେ ଇସ୍‌ ଅଡ଼୍‌ ପଂଫୁଲିୟାତାଗ୍ ୱାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଆଗେ ପର୍ଗାତାଗ୍ ପ୍ରଚାର୍ ମାଡ଼ି ଆତ୍ତେଲିଆତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ଏର୍‍ ହାର୍‍ଦେଆଲା ଆନ୍ତିୟକିଆତାଗ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତଡ଼୍ । ଇଦ୍ ଅନ୍‌ଥିୟୋକ୍‌ତାଗ୍ ଆସ୍ ମାନ୍ଦାନ୍ ପାଡ଼୍‍ୟି ସେଙ୍ଗେ ଇଶ୍ୱର୍‌ତେ ଅନୁଗ୍ରହତଡ଼୍ ଅଡ଼୍‌ ସର୍ପା ଆସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ଅଡ଼୍‌ ଅନ୍‌ଥିୟୋକ୍‌ତାଗ୍ ଏୱୁସ୍ ମଣ୍ଡଲିତେ ନାରୁଡ଼୍‍କ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼୍‍ତଡ଼୍ । ଇଶ୍ୱର୍ ସେଙ୍ଗେ ଅଡ଼୍‌ ବାତ୍ ମାଡ଼ିମାତ୍‍ତଡ଼୍ ନୁ ଅଣଇହୁଦୀଡ଼୍ ବିଶ୍ୱାସ୍ ସେଙ୍ଗେ ବେଲା ହାର୍ ତଅସ୍‍ମାତ୍‍ତଡ଼୍‍, ଆୱ୍‍ଚାରେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଆଗେ ବିଶ୍ୱାସୀ ଶିଷ୍ୟ ତଡ଼୍ ଅଡ଼୍‌ ନାର୍‍ଗେ ଦିନା ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଯିହୁଦାତାଗାଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଦାଦାଲଡ଼୍‍ ଅନ୍‌ଥିୟୋକ୍‌ତାଗ୍ ୱାସ୍, ମୋଶାନ୍‌‌ ନିୟମ୍ ଲେକାମ୍ ଅଡ଼୍‌ ସୁନ୍ନତ୍ ଆୟିୱକ୍ ପରିତ୍ରାଣ୍ ପାଏମ୍ ଆୟଡ଼୍ ଇଞ୍ଜ ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ଶିକ୍ଷା ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ଇଦ୍ ବିଷୟ୍‍ତିଙ୍କ୍ ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବା ଅଡ଼୍‌ ତଡ଼୍ ଗାଟି ଯୁକ୍ତିତର୍କ ମାଡ଼୍‍ତାଙ୍କ୍ ଇଦ୍ ତିଆର୍ ମାଡ଼୍‍ତଡ଼୍ ଯେ, ପାଉଲ୍, ବର୍ଣ୍ଣବା ନୁ ଅନ୍‌ଥିୟୋକ୍‌ତେ ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଆଞ୍ଜ୍ ପ୍ରେରିତ ଶିଷ୍ୟ ନୁ ମଣ୍ଡଲିତେ ବୟସ୍କା ନେତାଲଡ଼୍ ତଡ଼୍ ଇଦ୍ ବିଷୟ୍‍ତେ ପରାମର୍ଶ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ମଣ୍ଡଲି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆଦାନାଦ୍ ସୁବିଦା ମାଡ଼ି ରହତ୍‍ତେ ନୁ ଅଡ଼୍‌ ଫିନିସିଆ ନୁ ଶମିରୋ ଇସ୍‌ ଆଦାନ୍ ୱେଲେ ଅଣଇହୁଦୀଡ଼୍ ବେଲା ମନ୍ ପରିବର୍ତ୍ତନ୍ ମାଡ଼ି ଇଶ୍ୱର୍‌ତେ ପାକେ ଆଦ୍‍ତଡ଼୍, ଆଦ୍ ବିଷୟ୍ କେତ୍‍ତଡ଼୍; ଇଦ୍ ଗଟ୍ କେଞ୍ଜି ବିଶ୍ୱାସୀଡ଼୍ ଦାଦାଲଡ଼୍‍ ଗାଟି ୱେଡ଼୍‍କେ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ଅଡ଼୍‌ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ହେୱୁତ୍‍ତେ ୱେଲେ ମଣ୍ଡଲି, ପ୍ରେରିତ ଶିଷ୍ୟ ନୁ ମଣ୍ଡଲିତେ ନେତାଲଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସ୍ୱାଗତ୍ ମାଡ଼୍‍ତଡ଼୍ । ଇଶ୍ୱର୍ ଅଡ଼୍‌ ତଡ଼୍ ମାଡ଼ିମାନ୍ଦାନ୍ ପାଡ଼୍‍ୟି ବିଷୟ୍‍ତେ ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବା ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ଇତ୍‍କେ ପାରୂଶୀଡ଼୍ ପାକେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ବିଶ୍ୱାସୀଡ଼୍ ନିଶ୍‍ମିକା କେତ୍‍ତଡ଼୍, “ଅଣଇହୁଦୀଡ଼୍ ସୁନ୍ନତ୍ ଆଦାନାଦ୍ ତିଆର୍ ନୁ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ପାଲନ୍ ମାଡ଼ାନଙ୍କ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତାନ୍ ଦର୍‍କାର୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ଇଦ୍ ବିଷୟ୍‍ତିଙ୍କ୍ ମିଟିଙ୍କ୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ନୁ ମଣ୍ଡଲିତେ ବୟସ୍କା ନାରୁଡ଼୍ ଅଣ୍ଡୟ୍‌‍ତାଗ୍ ଗୁଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ନାର୍ଗେଜେଲ୍ ଆଲୋଚାନା ମାଡ଼୍‍ତେ ପେର୍‍କେ ପିତର୍ ନିଶ୍‍ମିକା କେତ୍‍ତଣ୍ଡ୍, “ଦାଦାଲଡ଼୍‍ ନୁ ଏଲାସ୍କ୍‍କି, ମିଡ଼୍ ପୁଞ୍ଜ୍‍ମାନୁଟ୍ ଯେ ନାର୍‍ଗେ ଦିନା ମୁନେଙ୍କ୍ ଇଶ୍ୱର୍ ଅଣଇହୁଦୀଡ଼୍ ଗାର୍‍ରେ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼ି ଆଦିନାଗ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାନଙ୍କ୍ ମିଇ ଲୋପେଙ୍କ୍ ନାକିଂଙ୍କ୍ ଏଞ୍ଚିମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ମେଣ୍ଡେ ସାରେତଡ଼୍‍ତେ ହୃଦୟ୍‍ ପୁନ୍ଦାନ୍ ଇଶ୍ୱର୍ ମାକିଂଙ୍କ୍ ବେଲା ପବିତ୍ର ଆତ୍ମାତଡ଼୍‍ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଣ୍ଡ୍, ଅଣଇହୁଦୀଡ଼୍‍କ୍ ମିକା ଟିକ୍ ଆଦେ ରକମ୍ ଇସ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ଅଡ଼୍‌ ନୁ ମା ଲୋପେ ବାତ୍‍ମିକା ହାଲ୍‍ସାନାଦ୍‍ ଇଲେ, ଅଡ଼୍‌‍ ତାମ୍‍ ହୃଦୟ୍ ଶୁଚି ମାଡ଼୍‍ତଡ଼୍‍ । ଅଡ଼ାଦ୍‌ ବିଶ୍ୱାସ୍‍ତେ ସେଙ୍ଗେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପାପ୍ କ୍ଷମା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ଆଲେକେ ବେନ୍ ବୋଜ୍ କାଞ୍ଜାନାଦ୍ ଜୁଆଡ଼୍‌ ମାନ୍‍ ଆନିଦାଦିଡ଼୍ ନୁ ମାମ୍‍ମେ ପାର୍‍ୱମ୍, ମିଡ଼୍ ଇଞ୍ଜେ ଶକ୍ତି ବିଶ୍ୱାସୀ ଶିଷ୍ୟ ଆଟେତାଗ୍ ଆଦ୍ କାଞ୍ଜ୍‍ସ୍ପିମିକା ବାତେଙ୍କ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପରିକ୍ଷା ମାଡ଼ାନଙ୍କ୍ ହାଲ୍‍ସୁତିଡ଼୍ ? ");
INSERT INTO kff_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ହିଲ୍‍ଲେ, ଇଦ୍ ଟିକ୍ ଆୟ୍‍ୟ । ଅଡ଼୍‌ ବେନ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ି ପରିତ୍ରାଣ୍ ପାଏମ୍‍ଆତ୍‍ତଡ଼୍, ମାମ୍‍ମେ ଗାଲା ଟିକ୍ ଆଦେପୁଟୁଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ି ପ୍ରବୁ ଜିସୁନ୍ ଅନୁଗ୍ରହତେ ପରିତ୍ରାଣ୍ ପାଏମ୍‍ଆତ୍‍ତାଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବାନ୍ ତଡ଼୍ ଅଣଇହୁଦୀଡ଼୍ ଲୋପେ ଇଶ୍ୱର୍ ବେନ୍‍ସାରେ ଆଦ୍‍ବୁତ୍‌ ନୁ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍, ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ ଆଦିନାଦ୍ ଗଟ୍‍ କେଞ୍ଜି ମାନ୍ଦେତେ ସାରେତଡ଼୍ କଟ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ଅଡ଼୍‌ କେସ୍ ତେର୍‍ତେ ପେର୍‍କେ ଯାକୁବ୍‍ କେତ୍‍ତଣ୍ଡ୍, “ହୋ ଦାଦାଲଡ଼୍‍ ନୁ ଏଲାସ୍କ୍‍କି ନା ଗଟି କେଞ୍ଜାଟ୍ ! ");
INSERT INTO kff_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ଇଶ୍ୱର୍ ବେଲା ଅନୁଗ୍ରହ ମାଡ଼ି ଅଣଇହୁଦୀଡ଼୍ ଲୋପେଙ୍କ୍ ବେସ୍କ୍‍ତୁଡ଼୍‍କ୍ ତାନ୍ ସେଙ୍ଗେ ପେଦେର୍‍ ହେଞ୍ଚ୍‍ତଣ୍ଡ୍, ଶିମୋନ୍ ଆଦ୍ ଗଟ୍ ବୁଜା ମାଡ଼ିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ବାବବାଦୀଡ଼ାଦ୍ ଗଟ୍ ଇଦିଙ୍କ୍ ପୁରାପୁରି ସମର୍ତନ୍ ମାଡ଼ୁତ୍‍ । ଶାସ୍ତ୍ରତାଗ୍ ଲେକାମିନ୍ଦେ; ");
INSERT INTO kff_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ପ୍ରବୁ କେତୁତଣ୍ଡ୍, ଇଦିନ୍‍ ପେର୍‍କେ ନାନ୍ ମାଲ୍‍ସ୍ ୱାଦ୍‍ତାନ୍ ନୁ ଦାଉଦନ୍ ରାଜ୍ୟତିଙ୍କ୍ ମେଣ୍ଡେଅଣ୍ଡ୍‌‍ଦାମ୍ ଉଦାର୍ ମାଡ଼ିତାନ୍ । ନାନ୍ ଆଦିନ୍ ଦଂସଆତ୍‌ତାଦ୍ ବିଷୟ୍ ମେଣ୍ଡେଅଣ୍ଡ୍‌‍ଦାମ୍ ତିଆର୍ ମାଡ଼ି ଆଦିଙ୍କ୍ ମେଣ୍ଡେଅଣ୍ଡ୍‌‍ଦାମ୍ ଡୁଟାଙ୍ଗ୍‍ ମାଡ଼ିତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ଜିସୁନାରୁନ୍ ଜାତି ନା ବକେତ୍ ୱାଦ୍‍ତଡ଼୍‍, ବେନ୍ ଅଣଇହୁଦୀଡ଼୍‍କ୍ ନାନ୍ ନା ନିଜର୍‍ ପ୍ରାର୍ତନାତାଗ୍ କାର୍‍ଙ୍ଗ୍‍ତାନ୍, ଅଡ଼୍‌ ସାରେତଡ଼୍ ନା ପେଦେର୍‍ ନିଜର୍‍ତଡ଼୍‍ ପ୍ରବୁ ଇଞ୍ଜ ସ୍ୱୀକାର୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ପ୍ରବୁ ଇଦ୍ ଗଟ୍ କେତ୍‍ତଣ୍ଡ୍, ନାର୍‍ଗେ ଦିନା ମୁନେତ୍ କାଲାମ୍‍ତେ ଇଦ୍ ଗଟ୍ ଅଣ୍ଡ୍‌ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍ ।’” ");
INSERT INTO kff_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ଯାକୁବ୍ ମେଣ୍ଡେ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍, ନା ବିଚାର୍‍ତେ, ବେନ୍ ଅଣଇହୁଦୀଡ଼୍ ଇଶ୍ୱର୍‌ତେ ପାକେ ମାଲ୍‍ତ୍‍ତଡ଼୍, ମାମ୍‍ମେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ମେଣ୍ଡେ ହଇରାଣ୍ ମାଡ଼ମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ଅଡ଼୍‌ ବେଲାକି ପୁତ୍‍ଲାମ୍‍ତିଙ୍କ୍ ଇଟ୍‌କେ କାଦି ତିନ୍‍ମାକିଡ଼୍, ଯୌନ ପାପ୍‍ତାଗାଙ୍କ୍ ପେଇସ୍ ୱାଡ଼ିଡ଼୍, ପାପେତିଙ୍କ୍ ପଇସ୍ ଦଂସମାଡ଼୍‍ତେ ଜୀୱାକ୍‍ତେ ହାୱୁଙ୍ଗ୍ ତିନ୍‍ମାକିଡ଼୍; ଇଦ୍ ସାରେ ବିଷୟ୍ କେସ୍‍ଇସ୍‌ ଅଡ଼୍‌ ବକେତ୍ ଅଣ୍ଡୟ୍‌ ଚିଟି ଲେକିକାଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ବାତେଙ୍କ୍ଇତ୍‍କେ ନାର୍‍ଗେ ଦିନାକନ୍ସ୍ ବିଶ୍ରାମ୍‍ଦିନେ ଉପାସନା ଲଅକିନାଗ୍ ମୋଶାନ୍‌‌ ନିୟମ୍ କାର୍‍ତୁତଡ଼୍ ନୁ ସାରେ ଟାୱୁନ୍‍କିନାଗ୍ ଅନାଦ୍‌ ଗଟ୍ ପ୍ରଚାର୍ ଆଦୁତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ପେର୍‍କେ ଦାଦାଲ୍‌ ପ୍ରେରିତ ଶିଷ୍ୟ ନୁ ମଣ୍ଡଲିତେ ବେଡ଼୍‍ୟେ ନେତାଲଡ଼୍, ମେଣ୍ଡେ ମଣ୍ଡଲିତେ ସାରେତଡ଼୍, ମାନ୍ଦେତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଏଞ୍ଚି ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବାନ୍ ତଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍‍ ଆନ୍ତିୟକିଆତାଗ୍ ରହତ୍‍ତାନଙ୍କ୍ ତିଆର୍ ମାଡ଼୍‍ତଡ଼୍ । ବର୍ଶବା ପେଦେର୍‍ତେ ପରିଚିତ ଯିହୁଦା ନୁ ଶୀଲା ବିଶ୍ୱାସୀଡ଼୍ ଲୋପେଙ୍କ୍ ଗାଟି ସମ୍ମାନିତ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ବିଶ୍ୱାସୀଡ଼୍ ମଦଲ୍ ଲେକ୍‍ତାଦ୍ ଚିଟି‍ତିଙ୍କ୍ ଇଡ଼୍ ଇର୍‍ୱୁଡ଼୍ କାୟ୍‍ଦେ ରହତ୍‍ତଡ଼୍, “ଆଣ୍ଟିୟୋକ୍‍, ସିରିଆ ନୁ ସିଲିସିଆତେ ଅଣଇହୁଦୀଡ଼୍ ଲୋପେଙ୍କ୍ ୱାସ୍‍ମାନ୍ଦାନ୍ ଦାଦାଲଡ଼୍‍କିଙ୍କ୍ ପ୍ରେରିତ ଶିଷ୍ୟଡ଼୍ ନୁ ମଣ୍ଡଲିତେ ବୟସ୍କା ନେତାଲଡ଼୍ ନମସ୍କାର୍ ମାଡ଼ୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ମାମ୍‍ମେ କେଞ୍ଜୁତମ୍ ଯେ, ମା ମାନ୍ଦେତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ମିଇ ବକେତ୍ ଆଞ୍ଜ୍ ବାତ୍ କେତ୍‍ତଡ଼୍, ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ମିକିଂଙ୍କ୍ ଗାଟିଦାନ୍ଦେ ମାଡ଼୍‍ତଡ଼୍ । ଇତ୍‍କେ ଇଦ୍ ବିଷୟ୍‍ତେ ମାମ୍‍ମେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାତ୍‍ମିକା ନିର୍ଦ୍ଦେଶ୍ ଇୱମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ଆଦିଙ୍କ୍ ମାମ୍‍ମେ ସାରେତମ୍ ଅଣ୍ଡୟ୍‌ ମନ୍ ହାସ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ସମ୍ୱାଦ୍‍କାରୀଡ଼୍‍କ୍ ଏଞ୍ଚି ମିଇ ବକେତ୍ ରହତାନଙ୍କ୍ ତିଆର୍ ମାଡ଼୍‍ତମ୍ । ଅଡ଼୍‌ ମାନ୍‍ ସତ୍‍ସାହସୀ ପ୍ରିୟ ସାଙ୍ଗ ବର୍ଣ୍ଣବା ନୁ ପାଉଲ୍ ତଡ଼୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଇ ପେଦେର୍‍ତେ ସାଙ୍ଗଡ଼୍ ପ୍ରବୁ ଜିସୁ କ୍ରିଷ୍ଟନ୍ ସେବା ମାଡ଼ାନଙ୍କ୍ ନିଜେତ୍ ଜିୱୁଣ୍ଡ୍‍ତିଙ୍କ୍ ଉତ୍ସର୍ଗ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ମାମ୍‍ମେ ଯିହୁଦା ନୁ ଶୀଲାଙ୍କ୍ ମିଇ ବକେତ୍ ରହତୁତମ୍ । ମାମ୍‍ମେ ବାତ୍ ଲେକୁତମ୍, ଅଡ଼୍‌ ବ୍ୟକ୍ତିଗତଭାବେ ଆଦ୍ ମିକିଂଙ୍କ୍ କେତିତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ବେସ୍‌କ୍ ଦର୍‍କାର୍ ଆଦାନ୍ ନିୟମ୍ ୱିଡ଼୍‍ସି ମିଇ ପର୍‍ର ମେଣ୍ଡେ ବଜ୍ ୱାଟମ୍ ମାକିଂଙ୍କ୍ ପବିତ୍ର ଆତ୍ମା ଇଦ୍ ନିର୍ଦ୍ଦେଶ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ଆୱୁ ନିୟମ୍ ଆତ୍‍ତା, ପୁତ୍‍ଲାମ୍‍ତିଙ୍କ୍ ଇଟ୍‌ତେ କାଦି ତିନ୍‍ମାଟ୍, ନେତୁର୍‍ ଉନ୍‍ମାଟ୍, ପାପେତିଙ୍କ୍ ପଇସ୍ ହାୱ୍‍କ୍‍ତେ ଜୀୱାକ୍‍ତେ ହାୱ୍‍ଙ୍ଗ୍ ତିନ୍‍ମାଟ୍ ନୁ ଯୌନ ପାପାମ୍‍ତିଙ୍କ୍ ୱିଡ଼୍‍ସାଟ୍ । ଇୱୁ ସାରେ ପାଡ଼୍‍ୟି ୱିଡ଼୍‍ସ୍‍କେ ମିୟାଦ୍ ଲେକେତ୍ ଆଦ୍‍ତେ । ମାୟାଦ୍‌ ଇଦ୍ ନମସ୍କାର୍‍ ଗ୍ରହନ୍ ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ବେନ୍ ସମ୍ୱାଦ୍‍କାରୀଡ଼୍‍କ୍ ରହସ୍‍ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଅନ୍‌ଥିୟୋକ୍‍ତାଗ୍ ଆଞ୍ଜ୍ ବିଶ୍ୱାସୀଡ଼୍ ସାରେ ମାନ୍ଦେତିଙ୍କ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ି ଇଦ୍ ଚିଟି ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ଆଗେ ବିଶ୍ୱାସୀଡ଼୍ ଚିଠିତାଦ୍ ସାର୍‍ଦେ ସମ୍ୱାଦ୍ କାର୍‍ସ୍ ୱେଡ଼୍‌କେ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଯିହୁଦା ନୁ ଶୀଲା ନିଜେ ବାବବାଦୀ ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଆଣ୍ଟିୟୋକ୍‌ତେ ବିଶ୍ୱାସୀ ଦାଦାଲଡ଼୍‍କ୍ ନାର୍‍ଗେ ଦିନାମ୍ ୱେଡ଼୍‍କା ମାଡ଼ି ଅଡ଼ାଦ୍‌ ବିଶ୍ୱାସ୍‍ତିଙ୍କ୍ ଦୃଡ଼ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଆଗେ ବେସ୍‍କେ ଦିନାମ୍ ମାତ୍‍ତେ ପେର୍‍କେ ବେନଡ଼୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରହସ୍‍ମାତ୍‍ଡ଼୍, ଅଡ଼୍‌ ବକେତ୍ ମାଲ୍‍ସ୍ ଆଦାନ୍ ମାଇଦିଙ୍କ୍ ବିଶ୍ୱାସୀଡ଼୍ ଦାଦାଲଡ଼୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଶାନ୍ତିତେ ବିଦାୟ୍ ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ଇତ୍‍କେ ଶିଲା ଆଗେ ମାନ୍ଦାନଙ୍କ୍ ସାୟେ ହେର୍କା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ପାଉଲ୍ ନୁ ବର୍ଣ୍ଣବା ଅନ୍‌ଥିୟୋକ୍‍ତାଗ୍ ବେସ୍‍କେ ଦିନାମ୍ ମାଞ୍ଜ୍‍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ତଡ଼୍ କାଇଲି ପ୍ରବୁନ୍ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ଶିକ୍ଷା ହିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ବେସ୍‍କେ ଦିନା ପେର୍‍କେ ପାଉଲ୍ ବର୍ଣ୍ଣବାଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଦା, ମାନାଡ଼୍ ମାଲ୍‍ସ୍ ଆଦିକାଡ଼୍, ସାରେ ଟାୱୁନ୍‍କିନାଗ୍ ବିଶ୍ୱାସୀଡ଼୍‍କ୍‍ ବେନଡ଼୍‍କ୍ ପ୍ରବୁନ୍ ବାକ୍ୟ କେତ୍‍ତାଡ଼୍, ଅଡ଼୍‌‍କିଂଙ୍କ୍ କାଇଲିକାଡ଼୍ ନୁ ଅଡ଼୍‌ ବେଲା ମିନ୍ଦେଡ଼୍‍ ଉଡ଼ିକାଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ବର୍ଣ୍ଣବା ଅଡ଼୍‌ ତଡ଼୍ ଯୋହନ୍‌ ମାର୍କଙ୍କ୍‍ ମିକା ତାନ୍‍ତଡ଼୍‍ ଆଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍; ");
INSERT INTO kff_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ଇତ୍‍କେ ପାଉଲ୍ ଅଂକିଙ୍କ୍‌ ଆଦାନଙ୍କ୍ ଲେକାମ୍ ହେର୍କା ମାଡ଼ଣ୍ଡ୍; ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ମୁନେଙ୍କ୍‍ଦାମ୍ ପାଡ଼୍‍ୟିତାଗ୍ ଆଦାନ୍‍ୱେଲେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ପଂଫୁଲିୟାତାଗ୍ ୱିଡ଼୍‍ସି ଆଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ଇଦ୍ ବିଷୟ୍‍ତେ ଗାଟି ଯୁକ୍ତିତର୍କ ଆତ୍‍ତଡ଼୍ ନୁ ସାଇପ୍ରସ୍ ଅଡ଼୍‌ ୱେର୍‍ଆତ୍‍ତଡ଼୍ । ବର୍ଣ୍ଣବା ମାର୍କଙ୍କ୍ ପଇସ୍ କୁପ୍ରତାଗ୍ ଏର୍‍ଦାଲା ୱାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ଇତ୍‍କେ ପାଉଲ୍ ଶୀଲାଙ୍କ୍ ହେଞ୍ଚ୍‍ତଣ୍ଡ୍ ନୁ ବିଶ୍ୱାସୀଡ଼୍ ତଡ଼୍ ପ୍ରବୁନାଗ୍ ଅନୁଗ୍ରହ ହାସ୍ ଦବ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ଅଣ୍ଡ୍‌ ମଣ୍ଡଲିକିଙ୍କ୍ ଡୁଟାଙ୍ଗ୍‍ ମାଡ଼ି ସିରିଆ ନୁ ସିଲିଷୀଆ ନାଡ଼୍‍ମେଙ୍କ୍ ଆତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ପାଉଲ୍‍ ଦର୍ବୀ ନୁ ଲୁସ୍ତ୍ରାତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ଆଗେ ତୀମତି ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ କ୍ରିଷ୍ଟିୟାନ୍ ବାସେ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ କ୍ରିଷ୍ଟ ବିଶ୍ୱାସୀ ଶିଷ୍ୟ ଇହୁଦୀ ନାଟାଡ଼୍‍ତେ ମାର୍‍ । ଇତ୍‍କେ ତାମ୍ ବାବାଲ୍ ୱେରଣ୍ଡ୍ ଗ୍ରୀକ୍‍ ନାରୁଣ୍ଡ୍‍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍ତ୍ରା ନୁ ଇକନିୟାତାଗ୍ ମାନ୍ଦାନ୍ ବିଶ୍ୱାସୀଡ଼୍ ଲୋପେଙ୍କ୍ ତୀମତିଙ୍କ୍‍ ଗାଟି ସାୟେତଣ୍ଡ୍‍ ଇଞ୍ଜ ପୁଞ୍ଜ୍‍ ମାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ପାଉଲ୍ ତାନ୍ ତଡ଼୍ ତୀମତିଙ୍କ୍ ଆଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼୍‍ତଣ୍ଡ୍, ଆଦିଙ୍କ୍ ଅଂକିଙ୍କ୍‌ ସୁନ୍ନତ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଇଲା ମାଡ଼ାନାଦ୍ କାରନ୍‍ ଆତ୍‍ତେ, ତୀମତିନ୍ ବାବାଲ୍ ଗ୍ରୀକ୍‍ ନାରୁଣ୍ଡ୍‍ ମାତ୍‍ତଣ୍ଡ୍ ଇଞ୍ଜ ଆଗେ ମାନ୍ଦାନଡ଼୍ ଇହୁଦୀଡ଼୍ ପୁଞ୍ଜ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ନାର୍‍ଗେ ଟାୱୁନ୍‍କିନ୍ ଲୋପେଙ୍କ୍ ଇସ୍‌ ଆଦାନ୍ ୱେଲେ ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ଯିରୁଶାଲେମ୍‍ତେ ପ୍ରେରିତ ଶିଷ୍ୟ ନୁ ବାଡ଼୍‍ୟେ ନେତାଲଡ଼୍ ହିତ୍‍ତେ ନିତିନିୟମ୍ ସାରେ ବୁଜାମାଡ଼ି, ଆୱିଙ୍କ୍ ପାଲନ୍ ମାଡ଼ାନଙ୍କ୍ କେସମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ଆଗାଙ୍କ୍ ମଣ୍ଡଲିକି ବିଶ୍ୱାସ୍‍ତେ‍ ଶକ୍ତ ଆତ୍‍ତା ନୁ ନିତ୍‍ଦିନ୍ ଆୱିନ୍‍ ସଂଖ୍ୟା ନାର୍ଗେ ଆତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ପବିତ୍ର ଆତ୍ମା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଏସିଆ ପ୍ରଦେଶ୍‍ତାଗ୍ ପ୍ରଚାର୍ ମାଡ଼ାନଙ୍କ୍ ଗଟ୍ ହିୱାଙ୍କ୍ ଅଡ଼୍‌ ଫ୍ରୁଗିୟା ନୁ ଗାଲାତୀୟ ଜାଗେତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ମିଷୀଆତେ ସୀମାତାଗ୍ ହେୱୁସ୍ ବିଥିନିଆ ପ୍ରଦେଶ୍‍ତାଗ୍ ଆଦାଙ୍କ୍ ପେୟ୍‍ତେ ୱେଲେ ଜିସୁନାଦ୍ ଆତ୍ମା ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆନୁମତି ହିୱ । ");
INSERT INTO kff_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ମିଷୀଆତେ ନାଡ଼୍‍ମେଙ୍କ୍ ଆଞ୍ଜ୍ ତ୍ରୋୟାତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ଆଦେନାଣ୍ଡ୍ ନାର୍‍କେ ପାଉଲ୍ ଅଣ୍ଡୟ୍‌ ଦର୍ଶନ୍ ଉଡ଼୍‍ତଣ୍ଡ୍ ଯେ, ମାସିଦୋନିଆତେ ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତୁତଣ୍ଡ୍, “ମାସିଦୋନିଆତାଗ୍ ୱାସ୍ ମାକିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼େ !” ");
INSERT INTO kff_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ପାଉଲ୍ ଇଦ୍ ଦର୍ଶନ୍ ଉଡ଼୍‍ତେ ସାଙ୍ଗେ ସାଙ୍ଗେ ମାସିଦୋନିଆତାଗ୍ ଆଦାନଙ୍କ୍ ମାମ୍‍ମେ ତିଆର୍ ଆତ୍‍ତମ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ମାମ୍‍ମେ ନିଜାମ୍ ପୁତ୍‍ତମ୍ ଯେ, ଇଶ୍ୱର୍ ଆଗେତ୍ ନାରୁଡ଼୍ ଲୋପେ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼ାନଙ୍କ୍ ମାକିଂଙ୍କ୍ କାର୍‍ଙ୍ଗ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ମାମ୍‍ମେ ଏର୍‍ଜାହାଜ୍‍ ତଡ଼୍ ତ୍ରୋୟାତିଙ୍କ୍ ୱିଡ଼୍‍ସି ସାମତ୍ରାକିତାଗ୍ ଆତ୍‍ତମ୍ ନୁ ମେଣ୍ଡେଅଣ୍ଡ୍‌ ଦିନ୍ ନିଆପଲ୍ଲିତାଗ୍ ହେୱୁତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ଆଗାଙ୍କ୍ ମାମ୍‍ମେ ମାସିଦୋନିଆ ଜିଲ୍ଲାତେ ମୁକ୍ୟ ନଗରୀ ଫିଲିପ୍‍ପୀତାଗ୍ ଆତ୍‍ତମ୍ । ଇଦ୍ ନଗରୀ ଅଣ୍ଡୟ୍‌ ରୋମୀୟ କଲ୍‍ନୀ ମାତ୍‍ତେ । ମାମ୍‍ମେ ନାର୍‍ଗେ ଦିନା ଆଗେ ମାତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ବିଶ୍ରାମ୍‍ଦିନେ ନଗର୍‍ତେ ବାୟିଦେ ମାନ୍ଦାନ୍ ବେଡ଼େମ୍ ହାଞ୍ଚିନାଗ୍ ଆତ୍‍ତମ୍ । ମାମ୍‍ମେ ହାଲ୍‍ସି ମାତ୍‍ତମ୍, ଆଗେ ଇହୁଦୀଡ଼୍ ପ୍ରାର୍ତନା ମାଡ଼ାନ୍ ସେଙ୍ଗେ ଅଣ୍ଡୟ୍‌ ପଡ଼୍‍ୟି ମାନ୍‍ତେ । ମାମ୍‍ମେ ମଦଲ୍ କୁଦ୍‍ତମ୍ ନୁ ଆଗେ ଗୁଡ଼ିମାନ୍ଦାନ୍ ନାଟାକିନ୍ ତଡ଼୍ ଗଟି ତ୍ରିୟ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ଆୱିନ୍‍ ଲୋପେଙ୍କ୍ ତୁୟଟୀରା ଟାୱୁନ୍‍ତେ ଆପାକଲର୍ ତାୱ୍ ସିଲେ ୱାମ ମାନ୍ଦାନ୍ ଲୁଦିଆ ପେଦେର୍‍ତେ ଅଣ୍ଡୟ୍‌ ନାଟାଡ଼୍ ମାତ୍‍ତେ । ଆଦ୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଉପାସନା ମାଡ଼ମାତ୍‍ତେ ନୁ ପାଉଲ୍ ବାତ୍ କେସମାତ୍‍ତନ୍, ଆଦ୍ ମନ୍‍ଇସ୍‌‍ କେଞ୍ଜି ଗ୍ରହନ୍ ମାଡ଼ାନ୍ ସେଙ୍ଗେ ପ୍ରବୁ ଆଦିଙ୍କ୍ ହୃଦୟ୍‍ତାଗ୍‍ ସୁଯୋଗ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ଆଦ୍ ନୁ ତାମ୍ ପରିବାର୍‍ତେ ସାରେତଡ଼୍ ଏର୍‍ଦିକ୍ଷା ଆତ୍‍ତେ ପେର୍‍କେ ମାକିଂଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତ୍‍ତଡ଼୍, “ପ୍ରବୁନାଗ୍ ନିଜାମ୍ ବିଶ୍ୱାସ୍ ମିନ୍ଦେ ଇଞ୍ଜ ଯଦି ଆଲ୍‍ସୁତି, ଆଲେକେ ମା ଲୋନ୍‌ ୱାସ୍ ମାନୁଟ୍ ।” ଆଦ୍ ଇଦ୍‍ରକମ୍ ମାକିଂଙ୍କ୍ ତାମ୍ ଲୋନ୍‌ ଆଦାନଙ୍କ୍ କେତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ଅଣ୍ଡ୍‌‍ଦିନ୍ ମାମ୍‍ମେ ପ୍ରାର୍ତନା ପଡ଼୍‍ୟେତାଗ୍ ଆଦାନ୍ ୱେଲେ ଅଣ୍ଡୟ୍‌ କ୍ରୀତଦାସୀ ପିକିଡ଼୍‍ତିଙ୍କ୍ କାଇଲ୍‍ତମ୍ । ତାନ୍ ଲୋପେ ମାନ୍ଦାନ୍ ଦେୟାମ୍‍ତଡ଼୍ ଆଦ୍ ମୁନେଙ୍କ୍‌ତାୱୁ ଗଟି କେସମାତ୍‍ତେ । ଆଦ୍ ନାରୁଡ଼ାୱ୍ ବାଗ୍ୟ କେସ୍, ପ୍ରବୁନ୍‍ ସେଙ୍ଗେ ନାର୍‍ଗେ ଡାବ୍‍କ୍ ଗାଡ଼୍‍ସ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ଆଦ୍ ପାଉଲ୍ ନୁ ମା ପେର୍‍କେ ପେର୍‍କେ ୱାସ୍ କିଡ଼୍‍କି କେତ୍‍ତେ, “ଇ ନାରୁଡ଼୍ ସାରେତିଙ୍କ୍ ବାଡ଼୍‍ୟଣ୍ଡ୍ ଇଶ୍ୱର୍‌ତେ ଦାସକୀନଡ଼୍‍ । ମିଡ଼୍ ବେଲା ପରିତ୍ରାଣ୍ ପାଏମ୍ ଆଦ୍‍ତିଡ଼୍, ଆଦ୍ ଗଟ୍ ଅଡ଼୍‌ କେତୁତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ପିକିଡ଼୍ ନାର୍‍ଗେ ଦିନାଯାକ ଇଦ୍‍ରକମ୍ ମାଡ଼୍‍ତେ । ପେର୍‍କେ ପାଉଲ୍ କାଡ଼ାମ୍‍ହାସ୍ ପେର୍‍କେ ମାଲ୍‍ସ୍ ଦେୟାମ୍‍ତିଙ୍କ୍ ଦମକ୍ ଇସ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଜିସୁ କ୍ରିଷ୍ଟନ୍ ପେଦେର୍‍ତେ ନାନ୍‍ ଆଦେଶ୍‍ ଇଦୁତାନ୍, ତାନାଗାଙ୍କ୍ ପେଇସ୍ ଅନ୍‌,” ଆସୁଟେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଦାୟାମ୍ ଆଦିନାଗାଙ୍କ୍ ପେଇସ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ବେସୁଟ୍‌ ତାନ୍ ପ୍ରବୁନ୍‍ ନିଜେତ୍ ଡାବ୍‍କ୍ ଗାଡ଼୍‍ସାନ୍ ଆଶେ ହରାମାଡ଼୍‍ତଡ଼୍ ଇଞ୍ଜ ପୁତ୍‍ତଡ଼୍, ପାଉଲ୍ ନୁ ଶୀଲାଙ୍କ୍ ପଇସ୍ ଟାୱୁନ୍‍ତେ ନାଡ଼୍‍ମେ ମାନ୍ଦାନ୍ ଶାସନ୍‍ କର୍ତ୍ତାନ୍‍ ମୁନ୍‍ନେ ତାତ୍‍ତଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","“ଅଡ଼୍‌‍ ରୋମୀୟ ଶାସନ୍‍ କର୍ତ୍ତାନ୍ ମୁନ୍‍ନେ ତାସ୍ କେତ୍‍ତଡ଼୍, ଇ ନାରୁଡ଼୍ ଇହୁଦୀ, ଅଡ଼୍‌ ମାନ୍‍ ଟାୱୁନ୍‍ତାଗ୍ ଗୋଲ୍‍କ୍ ମାଡ଼ୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ଅଡ଼୍‌ ମାନ୍‍ ନିୟମ୍‍ ବିରୁଦ୍ ରୀତିନୀତି ନାଡ଼୍‍ସ୍‍ପୁତଡ଼୍ । ମାମ୍‍ମେ ରୋମ୍‍ ନାଗରିକ, ଆଦିଙ୍କ୍ ଇଦ୍ ରୀତିନୀତି ଗ୍ରହନ୍ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱମ୍ ଆୱିଙ୍କ୍ ମାମ୍‍ମେ ପାଲନ୍ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ମାଲିକିଡ଼୍ ଗଟ୍‍ତାଗ୍ କାଇଲି ଆଗେ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ପାଉଲ୍ ନୁ ଶିଲାନ୍ ବିରୁଦ୍‍ତେ ତେଦ୍‍ତଡ଼୍ । ପାଉଲ୍ ନୁ ଶିଲାନ୍ ଚକା କୁସ୍‍ସ୍ପି ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବେତଡୁଡ୍ ତଡ଼୍ ରେଏତାଙ୍କ୍ ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ନାର୍‍ଗେ ଦେବ୍‍ ତିତ୍‍ତେ ପେର୍‍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଜଇଲ୍‍ତାଗ୍ ୱାଟ୍‍ତଡ଼୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କୁସ୍‍ ୱାଟି ଉଡ଼ାନ୍ ସେଙ୍ଗେ ଜଇଲ୍‍ରକ୍ଷା ମାଡ଼ାନଙ୍କ୍ ନିର୍ଦ୍ଦେଶ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ଇଦ୍ ଗଟ୍ ପାଏମ୍ ଆସ୍ ଜଇଲ୍‍ରକ୍ଷକ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଅଣ୍ଡୟ୍‌ ଲୋପେତ୍ ବାକ୍‍ଡ଼େତାଗ୍ ୱାଟ୍‍ତଣ୍ଡ୍, ପୁଃଉତେ ମଟଲ୍‍ତାଗ୍ ଅଡ଼ାୱୁ ଡେକାକିଙ୍କ୍ ତଅସିତ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ନାଟ୍‍ନାର୍କେ ପାଉଲ୍ ନୁ ଶୀଲା ପ୍ରାର୍ତନା ମାଡ଼ମାତ୍‍ତଡ଼୍, ଇଶ୍ୱର୍ ଉଦ୍ଦେଶ୍ୟତେ ପାଟା ପାରମାତ୍‍ତଡ଼୍ ନୁ ବାଗାତ୍ ବନ୍ଦିଡ଼୍ ଇଦ୍ କେଞ୍ଜ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ହଟାତ୍ ବୁମିକମ୍ପ ଆତ୍‍ତେ ନୁ ଜଇଲ୍‍ତେ ମୂଲଦୁଆତିଙ୍କ୍ ଉଃହୁତେ । ସାଙ୍ଗେ ସାଙ୍ଗେ ସାରେ ମାର୍‍ କୁଲେମ୍ ଆତ୍‍ତେ ନୁ ସାରେ ବନ୍ଦି ଆଦ୍‍ତନ୍ ଅଡ଼ାଦ୍‌‍ ଇକ୍‌ଲେମ୍‍ କୁସି ରାୟ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ତାନେରକ୍ଷା ମାଡ଼ାନଣ୍ଡ୍ ଉଞ୍ଜି ତେଏଦ୍‍ତଣ୍ଡ୍ ନୁ ଜଇଲ୍‍ତେ ମାର୍‍ କୁଲେମ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ହାଲ୍‍ସ୍‍ତଣ୍ଡ୍ ଯେ ବନ୍ଦିଡ଼୍ ମିର୍‍ତ୍‍ତଡ଼୍; ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ତାନ୍ ସାକୁ ପେସ୍‍ପିଇ ଆୱ୍‍କାନଙ୍କ୍‌ ତିଆର୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ଇତ୍‍କେ ପାଉଲ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଣ୍ଡ୍, “ନିଜେ ବାତ୍ କ୍ଷତି ମାଡ଼୍‍ମା । ମାମ୍ ସାରେତମ୍ ଇଗେ ମିନ୍ଦେମ୍ !” ");
INSERT INTO kff_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ତାନେରକ୍ଷା ମାଡ଼ାନଣ୍ଡ୍ ଡୁବିତାସ୍‍ ଉଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଲୋପେ ମିରିୱାସ୍ ୱାଡ଼୍‍କି ୱାଡ଼୍‍କି ପାଉଲ୍ ନୁ ଶୀଲାନ୍ ଡେକେତ୍ ମଦଲ୍ ରାୟ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ତାନ୍ ପେର୍‍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବାୟିଦେ ଆସ୍ ପାଚ୍ରା ମାଡ଼୍‍ତଣ୍ଡ୍, “ଆଜ୍ଞାଲଡ଼ି ! ପରିତ୍ରାଣ୍ ପାଏମ୍ ଆଦାନଙ୍କ୍ ନାକିଂଙ୍କ୍ ବାତ୍ ମାଡ଼େ ୱେୟ୍‍ତିତ୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ପ୍ରବୁ ଜିସୁନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍କେ ମିଇ ପରିବାର୍‍ତେ ସାରେ ତଡ଼୍‌କିଙ୍କ୍‌ ପରିତ୍ରାଣ୍ ଦର୍‍କିତ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ନୁ ତାମ୍‍ ଲନ୍‍ ତେତାନଡ଼୍‍କିଙ୍କ୍ ସାରେତଡ଼୍‍କ୍ ପ୍ରବୁନ୍ ଗଟ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ନାର୍‍କେତ୍ ଆଦେ ସାଙ୍ଗେ ସାଙ୍ଗେ ତାନେରକ୍ଷା ମାଡ଼ାନଣ୍ଡ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଆସ୍ ଅଡ଼ାୱୁ ପୁଣ୍ଡ୍‍କ୍ ସାରେ ନର୍‍ସିତ୍‍ତଣ୍ଡ୍, ମେଣ୍ଡେ ପରିବାରତେ ସାରେତଡ଼୍ ସାଙ୍ଗେ ସାଙ୍ଗେ ଏର୍‍ଦିକ୍ଷା ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ପାଉଲ୍ ନୁ ଶିଲାଙ୍କ୍ ତାନ୍ ନିଜେତ୍ ଲୋନ୍‌ ଆସ୍ ତିନ୍ଦାନଙ୍କ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଇଶ୍ୱର୍‌ତାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ନୁ ତାନ୍ ପରିବାର୍‍ତେ ସାରେତଡ଼୍ ୱେଡ଼୍‍କ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ମେଣ୍ଡେଅନ୍‌ ଦିନ୍ ନାର୍‍କକ୍ ରୋମୀୟ ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ ସିପାହିଡ଼୍‍କ୍‍ ଇଦ୍ ଗଟ୍ ଇସ୍‌ ରହତ୍‍ତଣ୍ଡ୍, “ଆ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ୱିଡ଼୍‍ସିମୁଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ଆଦିଙ୍କ୍ ଜଇଲ୍‍ରକ୍ଷକ୍ ପାଉଲ୍‍ତିଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ ନିକିଂଙ୍କ୍ ନୁ ଶିଲାଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ାନଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଇଞ୍ଜେ ମିଡ଼୍ ଇଗାଙ୍କ୍ ଶାନ୍ତିତେ ଆଦ୍‍ପାର୍‍ଦ୍‍ତିଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ଇତ୍‍କେ ପାଉଲ୍ ସିପାହିଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ବାତ୍ ଅପରାଦି‍ତାଗ୍ ଦଷି ଆୟ୍‍ୱେ ମାତ୍‍କେ ଗାଲା ଅଡ଼୍‌ ମାକିଂଙ୍କ୍ ରେହେତ୍‍ତଡ଼୍ । ମାମ୍‍ମେ ରୋମୀୟ ନାଗରିକ, ଇତ୍‍କେବା ଅଡ଼୍‌ ମାକିଂଙ୍କ୍ ବନ୍ଦି ମାଡ଼୍‍ତଡ଼୍ । ଇଞ୍ଜେ ମାକିଂଙ୍କ୍ ମିଞ୍ଜ୍‍ସ୍ପି ୱିଡ଼୍‍ସିଦାଙ୍କ୍ ହାଲ୍‍ସୁତଡ଼୍ । ମାମ୍‍ମେ ଇଦ୍ ମାଡ଼ାନଙ୍କ୍ ଇୱମ୍ । ରୋମୀୟ ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ ନିଜେ ଇଗେ ୱାସ୍ ମାକିଂଙ୍କ୍ ମୁକ୍ତ ମାଡ଼ିୱିଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ସିପାହୀଡ଼୍ ରୋମୀୟ ଶାସନ୍‍ କର୍ତ୍ତାଙ୍କ୍ ଇଦ୍ ଗଟି କେତ୍‍ତଡ଼୍ । ପାଉଲ୍ ନୁ ଶିଲା ରୋମିୟ ନାଗରିକ ଇଞ୍ଜ କେଞ୍ଜି ଅଡ଼୍‌ ୱେର୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ଗାର୍‍ରେ କ୍ଷମା ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଡ଼୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଜଇଲ୍‍ତାଗାଙ୍କ୍ ମୁକ୍ତି ମାଡ଼ି ଟାୱୁନ୍‍ ୱିଡ଼୍‍ସି ଆଦାନଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ପାଉଲ୍ ନୁ ଶିଲା କାରାଗାର ୱିଡ଼୍‍ସି ଲୁଦିଆନ୍‌ ଲୋନ୍‌ ଆତ୍‍ତଡ଼୍ । ଆଗେ ଅଡ଼୍‌ ବିଶ୍ୱାସୀଡ଼୍‍କ୍‍ କାଇଲ୍‍ତଡ଼୍ ନୁ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱେଡ଼୍‍କା ମାଡ଼ି ଆଦ୍ ପଡ଼୍‍ୟେ ୱିଡ଼୍‍ସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ପାଉଲ୍ ନୁ ଶୀଲା ଆମ୍ପିପଲି ନୁ ଆପଲ୍ଲୋନିଆ ଇସ୍‌ ଥେସଲନିକୀତାଗ୍ ୱାତ୍‍ତଡ଼୍ । ଆଗେ ଅଣ୍ଡୟ୍‌ ଇହୁଦୀ ଉପାସନା ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ପାଉଲ୍ ତାନ୍ ଦର୍ମଶାସ୍ତ୍ର ଲେକାମ୍ ଗୁଡ଼୍‍ୟିତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ଆଗେ ମୁଣ୍ଡ୍ ବିଶ୍ରାମ୍‍ବାର୍‍ତେ ନାରୁଡ଼୍ ତଡ଼୍ ଅଣ୍ଡ୍‌ ଆଲୋଚନା ମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଦର୍ମଶାସ୍ତ୍ର ଉଲ୍ଲେଖ ନୁ ବାକ୍ୟା ମାଡ଼ି ପ୍ରମାଣ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ଯେ, ମସୀହ ଦୁକାମ୍‍ ବୋଗ୍ ଆଦାନାଦ୍ ନୁ ଡଲ୍‍ତାଗାଙ୍କ୍ ତେଏଦାନାଦ୍ ଦର୍‍କାର୍ ମାତ୍‍ତେ । ପାଉଲ୍ କେତ୍‍ତଣ୍ଡ୍, “ବେନ୍ ଜିସୁନ୍ ବିଷୟ୍ ନାନ୍‍ନେ ଗଷନା ମାଡ଼୍‍ତାନ୍, ଅଣ୍ଡ୍‌ ଆ ମସିହ ।” ");
INSERT INTO kff_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଇଦ୍ ବିଶ୍ୱାସ୍‍ ପାଉଲ୍ ନୁ ଶୀଲା ତଡ଼୍ କାଇଲ୍‍ତଡ଼୍; ଆଦେପୁଟୁଙ୍କ୍ ନାର୍‍ଗେ ବାଡ଼୍‍ୟେ ନାଟାଙ୍କ୍ ନୁ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଉପାସନା ମାଡ଼ାନ୍‍ ଗ୍ରୀକ୍‍ନାରୁଡ଼ାଦ୍‍ ଅଣ୍ଡୟ୍‌ ବେଡ଼୍‍ୟାଦ୍‍ ମାନ୍ଦେ ମିକା ଅଡ଼୍‌ ତଡ଼୍ କାଇଲ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ଇତ୍‍କେ ଇହୁଦୀଡ଼୍ ଇର୍ଷା ମାଡ଼୍‍ତଡ଼୍ ନୁ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କାରାପ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ି ସାରେ ଟାୱୁନ୍‍ତାଗ୍ ଗୋଲ୍‍କ୍ ମାଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌ ପାଉଲ୍ ନୁ ଶୀଲାଙ୍କ୍ ମେହେକି ନାରୁଡ଼୍ ମୁନ୍‍ନେ ତାତାନ୍ ମାଇଦିଙ୍କ୍ ଯେସନ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁନ୍ ଲନ୍‍ ତିଙ୍କ୍ ଆଞ୍ଜ୍ ଚିଟିରମନ୍‍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ଇତ୍‍କେ ଆଗେ ପାଉଲ୍ ନୁ ଶୀଲା ଦର୍‍କ୍‍ୱାଙ୍କ୍, ଅଡ଼୍‌ ଯେସନ୍ ନୁ ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ନଗର୍‍ତେ ଶାସନ୍‍ କର୍ତ୍ତାନ୍ ବକେତ୍ ପିଡ଼୍‍ଙ୍ଗି ଆସ୍ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଡ଼୍, “ଇଡ଼୍ ନାରୁଡ଼୍ ଜଗତ୍‍ ସାରେଏକାମ୍ ଗୋଲ୍‍କ୍ ମାଡ଼ୁତଡ଼୍ ! ଇଞ୍ଜେ ଅଡ଼୍‌ ମାନ୍‍ ଟାୱୁନ୍‍ତାଗ୍ ୱାତ୍‍ତଡ଼୍, ");
INSERT INTO kff_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ମେଣ୍ଡେ ଯେସନ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ତାମ୍ ଲୋନ୍‌ ନେଃଏତଣ୍ଡ୍ । ଜିସୁ ପେଦେର୍‍ତେ ମେଣ୍ଡେ ୱେରଣ୍ଡ୍ ରାଜାଲ୍ ମିନ୍ଦେଣ୍ଡ୍ ଇଞ୍ଜ କେସ୍ ଅଡ଼୍‌ କାଇସର୍‍ ମହାରାଜା ତେ ସାରେ ନିୟମ୍‍ତିଙ୍କ୍ ବିରୁଦ୍‍ ମାଡ଼ୁତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ଇଦ୍ ଗଟ୍ କେସ୍ ଅଡ଼୍‌ ନାରୁଡ଼୍ ନୁ ଶାସନ୍‍ କର୍ତ୍ତାଲ୍ଡ଼୍‍ ଲୋପେ ଗାଟି କପାମ୍ ନୁ ଗଲ୍‍କ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ଶାସନ୍‍ କର୍ତ୍ତାଲଡ଼୍ ଯେସନ୍ ନୁ ବିଶ୍ୱସୀଡ଼ାଗାଙ୍କ୍ ଡାବ୍‍କ୍ ଆସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଜାମିନ୍ ମାଡ଼ି ୱିଡ଼୍‍ସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ନାର୍କା ଆତ୍‍ତାଙ୍କ୍ ବିଶ୍ୱାସୀଡ଼୍ ପାଉଲ୍ ନୁ ଶୀଲାଙ୍କ୍ ବେରିଆତାଗ୍ ରହସିତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଆଗେ ହେୱୁସ୍ ଇହୁଦୀଡ଼୍‍ ପ୍ରାର୍ତନାତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ଥେସଲନିକୀତେ ନାରୁଡ଼ାଗାଙ୍କ୍ ଆଗେତ୍ ନାରୁଡ଼୍ ଅଦିକ୍‌ ଦୟାବାନ୍ ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଗାଟି ଆଗ୍ରହତଡ଼୍ ଶିଷ୍ୟଡ଼ାଦ୍ ଶିକ୍ଷା କେଞ୍ଜ୍‍ତଡ଼୍ ନୁ ପାଉଲ୍‍ତାଦ୍ ପାଚ୍ରାମାଡ଼ି ଗଟ୍‍ତେ ସତ୍ ପୁନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଅଡ଼୍‌ ନିତାଲ୍ ଦର୍ମଶାସ୍ତ୍ର କାର୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ । ନାର୍‍ଗେ ଗ୍ରୀକ୍ ନାଟାଙ୍କ୍ ନୁ ଗ୍ରୀକ୍ ନାରୁଡ଼୍ ବିଶ୍ୱାସ୍‍ତଡ଼୍ କାଇଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ଇତ୍‍କେ ବେସୁଟ୍‌ ଥେସଲନିକୀ ଇହୁଦୀଡ଼୍ କେଞ୍ଜ୍‍ତଡ଼୍ ଯେ ବେରିଆତାଗ୍ ମିକା ପାଉଲ୍ ଇଶ୍ୱର୍‌ତେ ଗଟ୍ ପ୍ରଚାର୍ ମାଡ଼ୁତଣ୍ଡ୍, ଅଡ଼୍‌ ଆଗେ ୱାସ୍ ଗଲ୍‍କ୍ ମାଡ଼ାନଙ୍କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ସାଙ୍ଗେ ସାଙ୍ଗେ ବିଶ୍ୱାସୀଡ଼୍ ପାଉଲ୍‍ତିଙ୍କ୍ ଗଦାଡ଼୍‍ତେ ହାଞ୍ଚିନାଗ୍ ରହସିତ୍‍ତଡ଼୍; ଇତ୍‍କେ ଶୀଲା ନୁ ତୀମତି ଇର୍‍ୱୁଡ଼୍ ବେରିଆତାଗ୍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ପାଉଲ୍‍ତିଙ୍କ୍ ଅସିସ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଅନ୍‌ ତଡ଼୍ ଆଥେନ୍‍ସ୍ ହେୱୁନା ଆତ୍‍ତଡ଼୍ । ଆଗାଙ୍କ୍ ଅଡ଼୍‌ ବରିଆତାଗ୍ ମାଲ୍‍ସ୍ ଶୀଲା ନୁ ତୀମତିଙ୍କ୍ କେତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ସିଟ୍‍ପାଟ୍ ପାଉଲ୍‍ତଡ଼୍ କାଇଲିଡ଼୍ ଇଞ୍ଜ ପାଉଲ୍ ନିର୍ଦ୍ଦେଶ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ଆଥେନ୍‍ସ୍‍ତାଗ୍ ଶୀଲା ନୁ ତୀମତିଙ୍କ୍ କେପିମାନ୍ଦାନ୍ ୱେଲେ ନଗରୀ ପୁତ୍‍ଲାମ୍‍ ଦେୟାକ୍ ଆତ୍ମାତେ ବର୍ତ୍ତି ଆସ୍ ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ପାଉଲ୍ ଗାଟି କପାମ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ସମାଜ୍ ଲୋତ୍‍ତାଗ୍ ଇହୁଦୀଡ଼୍ ତଡ଼୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଉପାସନା ମାଡ଼ାନ୍ ଅଣଇହୁଦିଡ଼୍ ତଡ଼୍ ଇଦ୍ ବିଷୟ୍‍ତେ ନିତାଲ୍ ଆଲୋଚନା ମାଡ଼ାନଙ୍କ୍ ପସ୍ପ୍‍ତଣ୍ଡ୍ । ସହର୍‍ତେ ଚକକିନାଗ୍ ଆଦାୱାଦା ମାଡ଼ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ତଡ଼୍ ଆଦେ ବିଷୟ୍ ଆଲୋଚନା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ “ଏପିକ୍ୟୁରିଅନ୍‌ ନୁ ଷ୍ଟୋଇକ୍,” ଶିକ୍ଷା ଗୁରୁଡ଼୍‍ତଡ଼୍ ଅନାଦ୍‌ ଯୁକ୍ତିତର୍କ ଆତ୍‍ତେ । ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେତ୍‍ତଡ଼୍, “ଇଣ୍ଡ୍ ମୁର୍କ ବାତ୍ କେତାନଙ୍କ୍ ଆଲ୍‍ସୁତଣ୍ଡ୍ ?” ବାଗାତ୍ ନାରୁଡ଼୍ କେତ୍‍ତଡ଼୍, “ବିଦେଶୀ ଦେୟାକିଙ୍କ୍ ପ୍ରଚାର୍ ମାଡ଼ାନ୍ ଲେକାମ୍ ହେର୍କା ଆଦୁତ୍‍ତେ ।” ଜିସୁ ନୁ ମେଣ୍ଡନ୍‍ଦାମ୍ ପୁନରୁତାନ୍ ଆଦାନ୍‍ ବିଷୟ୍ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼ମାନ୍ଦାନାଦ୍ କେଞ୍ଜି ଅଡ଼୍‌ ଇଦ୍ କେତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ଆଦିଙ୍କ୍ ଅଡ଼୍‌ ପାଉଲ୍‍ତିଙ୍କ୍ ପଇସ୍ ଆତ୍‍ତଡ଼୍ ନୁ ଅଂକିଙ୍କ୍‌ ଏରୀୟପାଗସ୍‍ ମିଟିଙ୍କ୍‍ତାଗ୍ ତାସ୍ କେତ୍‍ତଡ଼୍, “ନିମ୍‍ ବେନ୍ ପୁନାଦ୍ ଶିକ୍ଷା ବିଷୟ୍‍ତେ କେତୁତିନ୍, ଆଦ୍ ବିଷୟ୍ ମାମ୍‍ମେ ପୁନ୍ଦାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ନିମ୍‍ କେସମାନ୍ଦାନ୍ ବେସ୍‍କେ ଗଟି ମାକିଂଙ୍କ୍ ଆଦ୍‍ବୁତ୍‌ ମାଡ଼ୁତ୍ । ମାମ୍‍ମେ ଆଦିନ୍ ଇତ୍‍କେ ପୁନ୍ଦାନଙ୍କ୍ ଚାଏମ୍‍ ଅଦୁତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ଆଥେନୀୟତେ ନାରୁଡ଼୍ ନୁ ଆଗେ ବାସେ ମାଡ଼ମାନ୍ଦାନ୍ ବିଦେଶୀଡ଼୍ ପୁନାଦ୍ ବିଷୟ୍ କେଞ୍ଜାନଙ୍କ୍ ନୁ କେତାନଙ୍କ୍ ଗାଟି ପସନ୍ଦ୍ ମାଡ଼୍‍ତଡ଼୍ । ଇଗେ ଅଡ଼୍‌ ନାର୍‍ଗେ ଜେଲ୍‍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ପାଉଲ୍ ମିଟିଙ୍ଗ୍‍ତେ ମୁନ୍‍ନେ ନିସ୍ କେତ୍‍ତଣ୍ଡ୍, “ଆଥେନୀୟ ନାରୁଡ଼୍, ମିଡ଼୍ ସାରେତଡ଼୍ ଗାଟି ଦାର୍ମିକ୍ ଇଞ୍ଜ ହାଲ୍‍ସୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ନାନ୍ ମିୟାଦ୍ ନଗର୍‍ତାଗ୍ ଉଡାନ୍‍ୱେଲେ ମିୱାଦ୍ ପୂଜା ମାଡ଼ାନ୍ ଜାଗେତିଙ୍କ୍ ଉଡ଼୍‍ତାନ୍ । ଅଣ୍ଡୟ୍‌ ଜଜ୍ଞବେଦିତ୍ ପର୍‍ର ‘ଅଣ୍ଡୟ୍‌ ପୁନ୍‍ୱାଦ୍ ଇଶ୍ୱର୍‌ତେ ଉଦ୍ଦେଶ୍ୟତେ,’ ଲେକିମାନ୍ଦାନାଦ୍ ଗାଲା ଉଡ଼୍‍ତାନ୍ । ମିଡ଼୍ ପୁନ୍‍ୱେକନ୍‍ସ୍ ବେନଙ୍କ୍ ପୂଜା ମାଡ଼ୁତିଡ଼୍, ଇଞ୍ଜେ ଅନାଦ୍‌ ଗଟ୍ ମିକିଂଙ୍କ୍‍ କେତୁତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ଇଶ୍ୱର୍ ଜଗତ୍ ନୁ ଆଗେ ମାନ୍ଦାନ୍ ସାରେ ଜିନିଷ୍ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ସ୍ୱର୍ଗ ନୁ ପୃତିବିତେ ପ୍ରବୁ । ନାରୁଡ଼୍ କାୟ୍‍ଦେ ତିଆର୍ ମାଡ଼୍‍ତେ ମନ୍ଦିର୍‍ତାଗ୍ ଅଣ୍ଡ୍‌ ବାସେ ମାଡ଼ଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ମାନାଡ଼୍ ପାଡ଼୍‍ୟି ମାଡ଼ି ଅଂକିଙ୍କ୍‌ ହିଦାନ୍ ଲେକାମ୍ ବାତ୍ ସୁସ୍ଥ ଆଦାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଇଚ୍ଛା ମାଡ଼ଣ୍ଡ୍; ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଜିୱୁଣ୍ଡ୍, ନେସ୍କାନାଲ୍‌ଦ୍ ନୁ ସାରେ ଦର୍‍କାର୍ ଜିନିଷ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ୱେରଣ୍ଡ୍ ନାରୁଣ୍ଡ୍‍ତାଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ସାରେ ନାରୁଡ଼୍ ଜାତ୍‍ତିଙ୍କ୍ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଅନାଦ୍‌ ନିର୍ଦ୍ଦେଶ୍‍ତେ ଅଡ଼୍‌ ପୃତିବିତାଗ୍ ୱେକ୍ ୱେକ୍ ନାର୍‍କିନାଗ୍ ବାସେ ମାଡ଼ୁତଡ଼୍ । ବେନ୍ ସମୟ୍‍ତେ, ବେନ ବେଗେ ବାସେ ମାଡ଼ିତନ୍, ମୁନେତ୍‍କେ ଇଶ୍ୱର୍ ଆଦ୍ ତିଆର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ଅନ୍‌‍ୱାଦ୍ ଉଦେଶ୍ୟ ମାତ୍‍ତେ, ସାରେତଡ଼୍ ବେଲା ଅଂକିଙ୍କ୍‌ ମେହେକି ଅଂକିଙ୍କ୍‌ ଦର୍‍ସ୍କିତଡ଼୍‍ । ଇତ୍‍କେବା ଇଶ୍ୱର୍ ବେନନାଗାଙ୍କ୍ ଜେକେ ଇଲାଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ଇଦ୍ ବିଷୟ୍‍ତେ ବେନ ୱେରଣ୍ଡ୍ କେତୁତଣ୍ଡ୍, “ଅନାଗେ ମାୱାଦ୍ ଜିୱୁନ୍‍ତାଦ୍ ବାଦ୍‍କାନାଦ୍‍, ଉଡାନାଦ୍‍ ନୁ ମାନ୍ଦାନାଦ୍‍ ମିନ୍ଦେ ।” ମିଇ କବିଡ଼ାଗାଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେତୁତଡ଼୍, “ମାମ୍‍ମେ ଗାଲା ଅନ୍‌ ମାର୍‍କ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ମାମ୍‍ମେ ଇଶ୍ୱର୍‌ତେ ମାର୍‍କ୍ ଆସ୍ ମାନ୍ଦାନ୍ ମାଇଦିଙ୍କ୍ ନାରୁଡ଼୍ ତିଆର୍ ମାଡ଼୍‍ତେ ସୁନା, ରୁପା ବା କାଲ୍‍ତଡ଼୍ ତିଆର୍ ଆତ୍‍ତେ ପୁତ୍‍ଲାମ୍‍ ଲେକେମ୍ ଇଶ୍ୱର୍‌ତେ ପୁଟୁଙ୍କ୍ ହାଲ୍‍ସାଙ୍କ୍‍ ପାର୍‍ୱାଡ଼୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ନାରୁଡ଼୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପୁନ୍‍ୱେ ୱେଲେ ଅଣ୍ଡ୍‌ ଦଷ୍ ପୟ୍‍ୱେ ମାତ୍‍ତଣ୍ଡ୍, ଇତ୍‍କେ ଇଞ୍ଜେ ସାରେତଡ଼୍‍ ଅନୁତାପ ମାଡ଼ି ଅଡ଼ାଦ୍‌ ପାପାମ୍‍ ହାର୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ଦାନ୍ ମାଇଦିଙ୍କ୍ ଗଟ୍ ଇଦୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ଅଣ୍ଡ୍‌ ଅଣ୍ଡୟ୍‌ ଦିନ୍ ହେଞ୍ଚ୍‍ତଣ୍ଡ୍ । ଆଦ୍ ଦିନ୍ ଅଣ୍ଡ୍‌ ତାନ୍ ହେଞ୍ଚ୍‍ତେ ନାରୁନ୍ ତଡ଼୍ ସାରେ ଜଗତ୍‍ ତାଦ୍ ନ୍ୟାୟ ବିଚାର୍ ମାଡ଼ିତନ୍ । ଆ ନାରୁଙ୍କ୍ ପୁନର୍ଜିବୀତ୍ ମାଡ଼ାନ୍ ତଡ଼୍ ଅଣ୍ଡ୍‌ ଇଦ୍ ଗଟ୍‍ତାଦ୍ ସତ୍‍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ କେସ୍‍ମିନ୍ଦେଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ପାଉଲ୍‍ତାଗାଙ୍କ୍ ପୁନରୁତାନ୍ ବିଷୟ୍ କେଞ୍ଜି ଅଡ଼୍‌ ଲୋପେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଅଂକିଙ୍କ୍‌ ପାସ୍କ୍‍ତଡ଼୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ବାଗାତ୍ ନାରୁଡ଼୍ କେତ୍‍ତଡ଼୍, “ନିୟାଗାଙ୍କ୍ ମାମ୍‍ମେ ଇଦ୍ ବିଷୟ୍ ମେଣ୍ଡନ୍‍ନ୍ଦାମ୍ କେଞ୍ଜାନଙ୍କ୍ ଇଚ୍ଛା ମାଡ଼ୁତମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ଆଦ୍‍ନାଣ୍ଡ୍ ମିଟିଙ୍ଗ୍ ତେର୍‍ସ୍‍ପି ପାଉଲ୍ ଦବ୍‍ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ଡାୟୋନିସିଆସ୍ ପେଦେର୍‍ତେ ମିଟିଙ୍ଗ୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ନାରୁଙ୍କ୍, ଦାମାରୀ ପେଦେର୍‍ତେ ଅଣ୍ଡୟ୍‌ ନାଟାଡ଼୍ ନୁ ମେଣ୍ଡେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ନାରୁଡ଼୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ଅନ୍‌ ତଡ଼୍ କାଇଲ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ଇଦିନ୍‍ପେର୍କେ ପାଉଲ୍ ଆଥେନ୍‍ସ୍ ୱିଡ଼୍‍ସି କରିନ୍ଥୀୟତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ଆଗେ ଅଣ୍ଡ୍‌ ପନ୍ତସ୍‍ତାଗ୍ ଜନମ୍ ମାଡ଼ିମାନ୍ଦାନ୍ ଆକ୍ୱିଲା ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଇହୁଦୀଙ୍କ୍ କାଇଲ୍‍ତଣ୍ଡ୍ । ସମ୍ରାଟ୍ କ୍ଲଡିୟସ୍‍ ସାରେତଡ଼୍ ଇହୁଦୀଡ଼୍‍କ୍ ରୋମ୍ ୱିଡ଼୍‍ସାନଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତାଙ୍କ୍, ଅଣ୍ଡ୍‌ ବେସ୍କ୍‍ଦିନା ମୁନେନ୍ ତାନ୍ ମୁତ୍‍ତେ ପ୍ରିସ୍କିଲାନ୍‍ ତଡ଼୍ ଇତାଲିଆକନ୍‌ସ୍‍ ୱାସ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ପାଉଲ୍ ଅଂକିଙ୍କ୍‌ ଉଡ଼ାନଙ୍କ୍ ଆଞ୍ଜ୍ ଅଡ଼୍‌ ତଡ଼୍ ବାସେ ମାଡ଼୍‍ତଣ୍ଡ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ଗାଲା ଅଡ଼୍‌ ଲେକାମ୍ ତମ୍ବୁ ତିଆର୍ ମାଡ଼ି ବାଦ୍‍କମାତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଇହୁଦୀ ଇତ୍କେ ଗ୍ରୀକ୍‍ ନାରୁଡ଼୍‍ତେ ମନ୍‍ତାଗ୍ ପ୍ରବୁଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ସାରେ ବିଶ୍ରାମ୍‍ଦିନ୍ ଅଣ୍ଡ୍‌ ପ୍ରାର୍ତନା ଲୋତ୍‍ତାଗ୍ ଆଲୋଚନା ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ଶୀଲା ନୁ ତୀମତି ମାସିଦୋନିଆତାଗାଙ୍କ୍ ମାଲ୍‍ସ୍ ୱାତ୍‍ତେ ପେର୍‍କେ ପାଉଲ୍ ଇହୁଦୀଡ଼୍ ଗାର୍‍ରେ ଜିସୁନ୍ ସୁସମାଚାର୍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ନୁ ଜିସୁଙ୍କ୍ ମସୀହ ଇଞ୍ଜ କେତ୍‍ତାନ୍ ସେଙ୍ଗେ ସାକ୍ଷ୍ୟ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ଇତ୍‍କେ ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଅତ୍ୟାଚାର୍ ମାଡ଼ି ଅଂକିଙ୍କ୍‌ ନିନ୍ଦେ ମାଡ଼୍‍ତାଙ୍କ୍, ଇଦିନାଦ୍ ପ୍ରତିବାଦ୍ ମାଡ଼ି ଅଣ୍ଡ୍‌ ନିଜେତ୍ ସକେତାଦ୍ ଦୁମ୍ କାଇସ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଯଦି ମିଡ଼୍ ଦଂସଆଦ୍‌ତିଡ଼୍, ଆଲେକେ ମିଡ଼୍ ନିଜେ ଦାୟି ଆଦ୍‍ତିଡ଼୍ । ନାନ୍ ଇଦିନ୍ ମାଇଦିଙ୍କ୍ ଦାୟି ଆୟନ୍ । ଇଞ୍ଜେ ନାନ୍ ଅଣଇହୁଦୀଡ଼୍ ଗାର୍‍ରେ ଆଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ଉପାସନା ମାଡ଼ମାନ୍ଦାନ୍ ତିତସ୍ ଯୁସ୍ତ ପେଦେର୍‍ତେ ୱେରଣ୍ଡ୍ ଅଣଇହୁଦୀନ୍ ଲୋନ୍‌ ଆତ୍‍ତଣ୍ଡ୍ । ଯୁସ୍ତନ୍ ଲନ୍‍ ଗୁଡ଼୍‍ୟିତେ ବକେତ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ଗୁଡ଼୍‍ୟିତେ ବାଡ଼୍‍ୟଣ୍ଡ୍ କ୍ରିଷ୍ଟପସ୍ ନୁ ତାମ୍ ପରିବାର୍‍ତେ ସାରେତଡ଼୍ ପ୍ରବୁନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ କରନ୍ଥିୟତେ ମେଣ୍ଡେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ପାଉଲ୍‍ତେ ଶିକ୍ଷା କେଞ୍ଜି ବିଶ୍ୱାସ୍ ମାଡ଼୍‍ତଡ଼୍ ନୁ ବାତିସ୍ମ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ଅଣ୍ଡୟ୍‌ ନାର୍‍କେ ପାଉଲ୍ ଅଣ୍ଡୟ୍‌ ଦର୍ଶନ୍ ଉଡ଼୍‍ତଣ୍ଡ୍, ଦର୍ଶନ୍‌ତାଗ୍ ପ୍ରବୁ ଅଂକିଙ୍କ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ୱେର୍‍ମା, ପ୍ରଚାର୍ ମାଡ଼ମାନ୍, ଆଦିଙ୍କ୍ ୱିଡ଼୍‍ସ୍‍ମା, ");
INSERT INTO kff_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ବାତେଙ୍କ୍ଇତ୍‍କେ ନାନ୍ ନି ତଡ଼୍ ତଡ଼୍ ମିନ୍ଦେନ୍ । ବେନ ନିୟାଦ୍ କ୍ଷତି ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍, ବାତେଙ୍କ୍ଇତ୍‍କେ ଇଦ୍ ନଗର୍‍ତାଗ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍ ନାୟାଗ୍ ମିନ୍ଦେଡ଼୍‍ ।” ");
INSERT INTO kff_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ଆଦିଙ୍କ୍ ପାଉଲ୍ ଆଗେ ଇଶ୍ୱର୍‌ତେ ବାକ୍ୟ ବିଷୟ୍‍ତେ ଶିକ୍ଷା ଇସ୍‌ ଅଣ୍ଡୟ୍‌‍ ହେଣ୍ଡ୍‍ ଆରୁ ନେଲ୍‍ଞ୍ଜ୍‍କ୍‍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ଗାଲିୟୋ ଆକାୟାତେ ରୋମୀୟ ଶାସନ୍‍ ମାଡ଼ାନଣ୍ଡ୍‍ ମାନ୍ଦାନ୍ ୱେଲେ, ଇହୁଦୀଡ଼୍ ଅଣ୍ଡୟାଗେ ହାସ୍ ପାଉଲ୍‍ତିଙ୍କ୍ ପଇସ୍ ବିଚାର୍ ଲୋତ୍‍ତାଗ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ଇ ନାରୁଣ୍ଡ୍‍ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ବିରୁଦ୍ ରୀତିତେ ଇଶ୍ୱର୍‌ତେ ଉପାସନା ମାଡ଼ାନଙ୍କ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେତୁତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ପାଉଲ୍ ଉତ୍ତର୍ ହିଦାଙ୍କ୍ ତିଆର୍ ଆତ୍‍ତେ ୱେଲେ, ଗାଲିୟୋ ଇହୁଦୀଡ଼୍‍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଯଦି ଇଗେ ବାତ୍ ଦଷ୍ ବା ଅପରାଦ୍‌ ମାନ୍‍ତେ, ଆଲେକେ ମିକିଂଙ୍କ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ି ମିଇ ଗଟି କେଞ୍ଜାନାଦ୍ ନାକିଂଙ୍କ୍ ଯୁକ୍ତିତର୍କ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ଇତ୍‍କେ ଇଦ୍ ମାମଲା ମାତର୍‍ ମିୟାଦ୍ ନିଜେତ୍ ନିତିନିୟମ୍‌, ବାକ୍ୟ ନୁ ପେଦେର୍‍ତେ ମାଇଦିଙ୍କ୍ ଆସ୍ ମାନ୍ଦାନ୍ ସେଙ୍ଗେ ମିଡ଼୍ ନିଜେ ଇଦିନାଦ୍ ବିଚାର୍ କର୍ତ୍ତାଲ୍ । ନାନ୍ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ବିଷୟ୍, ବିଚାର୍ ମାଡ଼ନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ଇଦ୍ କେସ୍ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ବିଚାର୍ ଲୋତ୍‍ତାଗାଙ୍କ୍ ତଲ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ଅଡ଼୍‌ ଉସୁଲ୍‍ତେ ବାଡ଼୍‍ୟଣ୍ଡ୍ ସସ୍ଥନସ୍‍ତିଙ୍କ୍ ପଇସ୍ ବିଚାର୍ ଲୋତ୍‍ତେ ମୁନ୍‍ନେ ଦେବ୍‍ ରେହେତ୍‍ତଡ଼୍ । ଇତ୍‍କେ ଗାଲିୟୋ ଆଦ୍ ବିଷୟ୍‍ତିଙ୍କ୍ ଦ୍ୟାନ୍ ହିୱଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପାଉଲ୍ କରିନ୍ଥତାଗ୍ ବିଶ୍ୱାସୀଡ଼୍ ତଡ଼୍ ନାର୍‍ଗେ ଦିନା ବାସେ ମାଡ଼୍‍ତଣ୍ଡ୍ । ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ପ୍ରିସ୍କିଲା ନୁ ଆକ୍ୱିଲାନ୍ ତଡ଼୍ ସିରିଆତାକ୍ ଏର୍‍ଦାଗ୍ ଆତ୍‍ତଡ଼୍ । ସେଂକ୍ରିୟାତାଗାଙ୍କ୍ ଏର୍‍ଦାଲା ୱେୟିଦାନ୍ ମୁନେଙ୍କ୍ ଅନାଦ୍‌ ଅଣ୍ଡୟ୍‌ ବ୍ରତ ମାତ୍‍ତାଙ୍କ୍‍ ଅଣ୍ଡ୍‌ ତାନ୍ ତାଲ୍‍ତିଙ୍କ୍ ଟାଙ୍ଗ୍‍ରା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ଅଡ଼୍‌ ଏଫିସସ୍‌ତାଗ୍ ହେୱୁତ୍‍ତେ ପେର୍‍କେ ପାଉଲ୍ ପ୍ରିସ୍କିଲା ନୁ ଆକ୍ୱିଲାତିଙ୍କ୍ ବିଦାୟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଆଗେ ପ୍ରାର୍ତନା ସବାତାଗ୍‍ ଆଞ୍ଜ୍ ଇହୁଦୀଡ଼୍‌ତଡ଼୍ ଆଲୋଚନା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ନାରୁଡ଼୍ ଅଂକିଙ୍କ୍‌ ମେଣ୍ଡେ ନାର୍‍ଗେ ଦିନା ମାନ୍ଦାନଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ରାଜି ଆୟଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ଆଦ୍‍ଦାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଯଦି ଇଶ୍ୱର୍‌ତାଦ୍ ଇଚ୍ଛା ମାନ୍‍ତେ, ନାନ୍ ମିଇ ବକେତ୍ ମାଲ୍‍ସ୍ ୱାଦ୍‍ତାନ୍ ।” ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଏର୍‍ଜାହାଜ୍ ତଡ଼୍ ଏଫିସସ୍‌ ୱିଡ଼୍‍ସି ଦବ୍‍ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","କାଇସରିଆ ହେୱୁସ୍ ଆଗାଙ୍କ୍ ଅଣ୍ଡ୍‌ ଯିରୁଶାଲେମ୍ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ମଣ୍ଡଲିତିଙ୍କ୍ ନମସ୍କାର୍‍ ମାଡ଼ି ଆଗାଙ୍କ୍ ଅନ୍‌ଥିୟୋକ୍‍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ଆଗେ ବେସ୍କ୍‍ଦିନା ମାତ୍‍ତେ ପେର୍‍କେ ମେଣ୍ଡେ ତାଆକି ଆଞ୍ଜ୍‍ ଗାଲାତୀୟ ନୁ ଫ୍ରୁଗିୟା ପଡ଼ିୟେତ୍ ନାଡ଼୍‍ମେ ଇସ୍‌ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ହାର୍‍ଦାଗ୍ ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ଅଡ଼ାଦ୍‌ ବିଶ୍ୱାସ୍‍ ଶିଷ୍ୟ ଗାଡ଼୍‍ସ୍ ମାନ୍ଦାଙ୍କ୍ ଉତ୍ସାହ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ଆଦ୍ ସମୟ୍‍ତେ ଆଲେକ୍‍ଜାଣ୍ଡ୍ରିୟାଲ୍‍ତାଗ୍ ଜନମ୍ ଆତ୍‍ତେ ଆପୋଲ୍ଲୋ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଇହୁଦୀ ଏପିସସ୍‍ତାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ସାୟେତ୍ ନାରୁଣ୍ଡ୍‍ ନୁ ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଅନାଦ୍‌ ନାର୍‍ଗେ ବୁଦ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ଅଣ୍ଡ୍‌ ପ୍ରବୁନ୍ ବିଦ୍ୟା ନୁ ଆତ୍ମା ବିଷୟ୍‍ତେ ଶିକ୍ଷା ପାଏମ୍ ଆସ୍ ମାତ୍‍ତଣ୍ଡ୍ ନୁ ଗାଟି ୱେଡ଼୍‌କେତଡ଼୍ ଜିସୁନ୍ ବିଷୟ୍ ଶିକ୍ଷା ହିସ ମାତ୍‍ତଣ୍ଡ୍ । ଇତ୍‍କେ ଇଦ୍ ବିଷୟ୍‍ତେ ଅଣ୍ଡ୍‌ ମାତର୍‍ ଯୋହନ୍‌‌ତେ ଏର୍‍ଦିକ୍ଷା ବିଷୟ୍ ପୁଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ପ୍ରାର୍ତନାତାଗ୍ ଅଣ୍ଡ୍‌ ସାହାସ୍ ତଡ଼୍ ଶିକ୍ଷା ହିଦାଙ୍କ୍ ପସ୍‍ସ୍ପ୍‍ତଣ୍ଡ୍ । ଅନାଦ୍‌ ଶିକ୍ଷା କେଞ୍ଜି ପ୍ରିସ୍କିଲା ନୁ ଆକ୍ୱିଲା ତାମ୍ ଲୋନ୍‌ ଆତ୍‍ତଡ଼୍ ନୁ ଆଗେ ଅଂକିଙ୍କ୍‌ ଇଶ୍ୱର୍‌ତେ ବିଦ୍ୟା ବିଷୟ୍ ସାୟେ ବୁଜାମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ତାନ୍‍ପେର୍କେ ଆପୋଲ୍ଲୋ ଆକାୟା ପ୍ରଦେଶ୍‍ତାଗ୍ ଆଦାନଙ୍କ୍ ତିଆର୍ ଆତ୍‍ତାଙ୍କ୍, ଏପିସସ୍‍ତେ ବିଶ୍ୱାସୀ ଶିଷ୍ୟ ଅଂକିଙ୍କ୍‌ ସାହାଯ୍ୟ ମାଡ଼୍‍ତଡ଼୍ ନୁ ଅଂକିଙ୍କ୍‌ ଗ୍ରହନ୍ ମାଡ଼ାନ୍ ମାଇଦିଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ି ଆକାୟାତେ ବିଶ୍ୱାସୀଡ଼୍‍କିଙ୍କ୍ ଚିଟି ଲେକ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ଆଗେ ଏୱୁସ୍ ଇଶ୍ୱର୍‌ତେ ଅନୁଗ୍ରହତଡ଼୍ ବିଶ୍ୱାସୀ ଆସ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନାର୍‍ଗେ ସାହାଯ୍ୟ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ଜିସୁ ଯେ ମସୀହ, ଅଣ୍ଡ୍‌ ସାହାସ୍‍ତଡ଼୍ ଯୁକ୍ତି ମାଡ଼ି ଦର୍ମଶାସ୍ତ୍ରତାଗ୍ ଇଦ୍ ପ୍ରମାନ୍‍ ମାଡ଼ି ବାଷନ୍‍ ହିଦାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ଇହୁଦୀଡ଼୍‍କ୍ ହାରାମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପୋଲ୍ଲୋ କରିନ୍ଥୀୟତାଗ୍ ମାନ୍ଦାନ୍ ୱେଲେ, ପାଉଲ୍ ଆଦ୍ ଦେଶ୍‍ତେ ନାଡ଼୍‍ମେଙ୍କ୍ ଆଞ୍ଜ୍‍ ଏପିସସ୍‍ତାଗ୍ ହେୱୁତ୍‍ତଣ୍ଡ୍ । ଆଗେ ଅଣ୍ଡ୍‌ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍ କାଇଲି ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, ");
INSERT INTO kff_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","“ମିଡ଼୍ ବିଶ୍ୱାସୀ ଆତ୍‍ତେ ୱେଲେ ବାତ୍ ପବିତ୍ର ଆତ୍ମା ପାଏମ୍ ଆସ୍‍ମାତ୍‍ତିଡ଼୍ ?” ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍, “ପବିତ୍ର ଆତ୍ମା ଇଞ୍ଜ ବେନ ମିନ୍ଦେଣ୍ଡ୍, ଇଦ୍ ଗଟ୍ ମାମ୍‍ମେ ବେସୁଟ୍‌ କେଞ୍ଜମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ପାଉଲ୍ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ଆଲେକେ ମିଡ଼୍ ବେଦ୍‍ରକମ୍‍ ବାତିସ୍ମ ଗ୍ରହନ୍ ମାଡ଼୍‍ତିଡ଼୍ ?” ଅଡ଼୍‌ ଉତ୍ତର୍ ହିତ୍‍ତଡ଼୍; “ଯୋହନ୍‌‌ତେ ବାତିସ୍ମ ।” ");
INSERT INTO kff_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ପାଉଲ୍ କେତ୍‍ତଣ୍ଡ୍, “ବେନଡ଼୍ ଅନୁତାପ୍‍ ମାଡ଼ି ପାପ୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ତଡ଼୍ ଯୋହନ୍‌‌ତେ ବାତିସ୍ମ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ସାୟେ ମାତ୍‍ତେ । ଇତ୍‍କେ ଅନ୍‌ ପେର୍‍କେ ବେନ ୱାଦାନାଦ୍ ମାତ୍‍ତେ, ଅନାଗ୍‍ ଅର୍ତାତ୍‍ ଜିସୁନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାନଙ୍କ୍ ଯୋହନ୍‌ ଇଶ୍ରାଏଲତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ଇଦ୍ କେଞ୍ଜି ଅଡ଼୍‌ ପ୍ରବୁ ଜିସୁନ୍ ପେଦେର୍‍ତେ ବାତିସ୍ମ ଗ୍ରହନ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ପାଉଲ୍ ଅଡ଼୍‌ ପର୍‍ର କାୟ୍ ୱାଟ୍‍ତଣ୍ଡ୍ ନୁ ପବିତ୍ର ଆତ୍ମା ଅଡ଼୍‌ ପର୍‍ର ଡିଗ୍‍ତେ । ଅଡ଼୍‌ ସାରେ ବାଷାତଡ଼୍ ଗଟ୍ ତିର୍‍ୟ୍‍ତଡ଼୍ ନୁ ଇଶ୍ୱର୍‌ତେ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ଅଡ଼୍‌ ବାରଜାନ୍ ମାନେୟ୍‍ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ତାନ୍‍ପେର୍କେ ମୁଣ୍ଡ୍ ନେଲ୍‍ଞ୍ଜ୍ ଯାକ ଯିହୁଦୀଡ଼ାଦ୍‍ ପ୍ରାର୍ତନା ଲନ୍‍ତାଗ୍ ସାହାସ୍ ତଡ଼୍ ଆଲୋଚାନା ମାଡ଼ି ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ବିଷୟ୍‍ତେ ଅଡ଼ାଦ୍‌ ମନ୍‍ତାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ାନଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ଇତ୍‍କେ ଅଡ଼୍‌ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଗାଡ଼୍‍ସ୍‍ ମନ୍‍ତଡ଼୍ ମାତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ବିଶ୍ୱାସ୍ ଶିଷ୍ୟ ମାଡ଼ଡ଼୍‍ । ଅଡ଼୍‌ ମାନ୍ଦେତାଗ୍ ସାରେତଡ଼୍ ମୁନ୍‍ନେ ପ୍ରବୁନାଦ୍ ଆର୍‍ ବିଷୟ୍‍ତେ ବିବାଦ୍ ଗଟ୍ କେତ୍‍ତଡ଼୍ । ଆଦିଙ୍କ୍ ପାଉଲ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ଆସ୍ ସାରେଦିନେ ଟିରାନସ୍ ବବନତାଗ୍ ମିଟିଙ୍କ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ରେଣ୍ଡ୍ ହେଣ୍ଡ୍‍କ୍ ଇଦ୍ ଚାଲେମ୍‍ ଆତ୍‍ତେ । ରୋମ୍‍ତେ ଏସିଆ ଦେଶ୍‍ତାଗ୍ ବାସେ ମାଡ଼ମାନ୍ଦାନ୍ ନାର୍‍ଗେ ଇହୁଦୀ ନୁ ଅଣଇହୁଦୀ ପ୍ରବୁନ୍ ବାକ୍ୟ କେଞ୍ଜ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ଇଶ୍ୱର୍ ପାଉଲ୍ ତଡ଼୍ ବେପଡ଼୍‍ ମାଡ଼୍‍ୱାଦ୍ ଆଶର୍ଯ୍ୟ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଇଦ୍ ରକମ୍ କି ପାଉଲ୍ ବେବାହାର୍ ମାଡ଼ମାନ୍ଦାନ୍ ରୁମାଲ୍ ନୁ ଚକା ରୋଗୀଡ଼୍ ବକେତ୍ ଆତ୍‍କେ ଅଡ଼୍‌ ସୁସ୍ଥ ଆସମାତ୍‍ତଡ଼୍ ନୁ ତାମ୍ ମେନ୍ଦୁଲ୍‍ତାଗାଙ୍କ୍ ଦେୟାକ୍ ପେଇସ୍ ଆଞ୍ଜମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଉଡାନଡ଼୍ ଇହୁଦୀ ୱାଡେଡ଼୍ ମିକା ପ୍ରବୁ ଜିସୁନ୍‍ ପେଦେର୍ ପଇସ୍ ଦେୟାକ୍ ୱିର୍‍ସ୍ପାନଙ୍କ୍ ଆଲ୍‍ସି ମାତ୍‌ତଡ଼୍ । ଅଡ଼୍‌ ଦେୟାକିଙ୍କ୍ କେସମାତ୍‍ତଡ଼୍, “ପାଉଲ୍ ପ୍ରଚାର୍ ମାଡ଼ାନ୍ ଜିସୁନ୍ ପେଦେର୍‍ତେ ନାନ୍ ନିକିଂଙ୍କ୍ ଗଟ୍ ଇଦୁତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ସ୍କେବା ପେଦେର୍‍ତେ ଇହୁଦୀ ବେଡ଼ିୟି ଯାଜକ୍‍ତେ ସାତ୍‍ଜାନ୍‍ ମାର୍‍କ୍ ଇଦ୍‍ରକମ୍ ମାଡ଼ାନଙ୍କ୍ ଆଲ୍‍ସି ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ଇତ୍‍କେ ଦେୟାକ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ କେତ୍‍ତା, “ନାନ୍ ଜିସୁଙ୍କ୍ ପୁତ୍‍ତାନ୍ ନୁ ପାଉଲ୍‍ତିଙ୍କ୍ ମିକା ପୁତ୍‍ତାନ୍; ଇତ୍‍କେ ମିଡ଼୍ ସାରେ ବେନଡ଼ି ?” ");
INSERT INTO kff_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ଦେୟାକ୍ ପୟ୍‍ତେ ନାରୁଣ୍ଡ୍‍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ଗାଟି ଶକ୍ତି ଚିଟିରମଣ ମାଡ଼ି କାବା ମାଡ଼୍‍ତଣ୍ଡ୍‍ । ଅଡ଼ାୱୁ ଚକାସିଲେ ଇଙ୍ଗ୍‍ତା, ଅଡ଼୍‌ ବାଣ୍ଡାବାଣ୍ଡା ପୁଣ୍ଡ୍‍କ୍ ଆସ୍ ଅନ୍‌ ଲତ୍‍ତାଗାଙ୍କ୍ ମିର୍‍ତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଏପିସସ୍‍ ନିବାସୀ ଇହୁଦୀ ନୁ ଅଣଇହୁଦୀଡ଼୍ ଇଦ୍ ବିଷୟ୍ କେଞ୍ଜି ୱେର୍‍ତଡ଼୍ ନୁ ଆଗେ ପ୍ରବୁ ଜିସୁନ୍ ପେଦେର୍ ମେଣ୍ଡେ ଅଦିକ୍‌ ସମ୍ମାନ୍ ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ବିଶ୍ୱାସୀଡ଼ାଗାଙ୍କ୍ ନାର୍‍ଗେ ମୁଲ୍ ନିଜେତ୍ ସାରେ କାରାପ୍ ପାଡ଼୍‍ୟି ସ୍ୱୀକାର୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ୱାଡେ ବିଦ୍ୟା ନାଡ଼୍‍ସାନଡ଼୍ ନାର୍ଗେମୁଲ୍ ତାମ୍‍ୱା ବଇକିଂଙ୍କ୍ ତାସ୍ ନାରୁଡ଼୍ ମୁନ୍‍ନେ ଗୁଡ଼୍‍ପି ପଡ଼୍‍ସ୍‍ତଡ଼୍ । ଅଡ଼ାୱୁ ଆୱ୍ ବଇକିନ୍ ପୁରା ଦାମ୍‍ ମାତ୍‍ତେ ପାଚାଶ୍‍ ହଜାର୍‌ ରୁପା ଡାବ୍‍କ୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଇଦ୍‍ରକମ୍ ପ୍ରବୁନ୍‍ ବାକ୍ୟ ସାରେଏକାମ୍ ଆତ୍‍ତେ ନୁ ଗାଟି ଶକ୍ତି ଆତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ଇୱୁସାରେ ଗଟନା ଆତ୍‍ତେ ପେର୍‍କେ ପାଉଲ୍ ଆତ୍ମାତଡ଼୍‍ ମାସିଦୋନିଆ ନୁ ଆକାୟା ନାଡ଼୍‍ମେଙ୍କ୍ ଇସ୍‌ ଯିରୁଶାଲେମ୍‍ ଆଦାନଙ୍କ୍ ତିଆର୍ ଆତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ କେତ୍‍ତଣ୍ଡ୍, “ଆଗେ ଆତ୍‍ତେ ପେର୍‍କେ ନାନ୍ ନିଜାମ୍ ରୋମ୍‍ତାଗ୍ ମିକା ଆଦ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ତାନ୍ ଇର୍‍ୱୁଡ଼୍ ସେବା ମାଡ଼ାନଡ଼୍‍କ୍ ତୀମତି ନୁ ଏରାଷ୍ଟତିଙ୍କ୍ ମାସିଦୋନିଆତାଗ୍ ରହତ୍‍ତଣ୍ଡ୍, ଇତ୍‍କେ ନିଜେ ରୋମ୍‍ତେ ଏସିଆ ଦେଶ୍‍ତାଗ୍ ମେଣ୍ଡେ ବେସ୍‍କେ ଦିନାମ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ଇଦିନ୍‍ ଲୋପେ ପ୍ରବୁ ତଅସ୍ ମାତ୍‍ତେ ଆର୍‍ ବିଷୟ୍ ଆସ୍ ଏପିସସ୍‍ତାଗ୍ ଗାଟି ଗଲ୍‍କ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ଦୀମିତ୍ରିୟ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ରୁପାମାଡ଼ାନଣ୍ଡ୍ ଆର୍ତ୍ତେମୀ ଦେବୀନ୍ ମନ୍ଦିର୍‍ତାଗ୍ ରୁପା ମୂର୍ତ୍ତି ତିଆର୍ ମାଡ଼ମାତ୍‍ତଣ୍ଡ୍, ଇଦ୍ ବ୍ୟବସାୟତାଗାଙ୍କ୍ ଶିଳ୍ପ କାରିଗରିଡ଼୍ ନାର୍‍ଗେ ଲାବ୍ ମାଡ଼ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ଆଦିଙ୍କ୍ ଅଣ୍ଡ୍‌ ସାରେ ବ୍ୟବସାୟୀଡ଼୍‍କ୍ ଅଣ୍ଡୟାଗେ ମାଡ଼ି କେତ୍‍ତଣ୍ଡ୍, “ଆଜ୍ଞାଲଡ଼ି, ଇଦ୍ ବ୍ୟବସାୟ ମାକିଂଙ୍କ୍ ସାଉକାର୍ ମାଡ଼୍‍ତେ ଇଞ୍ଜ ସାରେତଡ଼୍ ପୁତ୍‍ତାଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ଇଞ୍ଜେ ଇଣ୍ଡ୍ ପାଉଲ୍ ବାତ୍ ମାଡ଼ୁତଣ୍ଡ୍; ଆଦ୍ ମିଡ଼୍ ନିଜେ ଉଡ଼ୁତିଡ଼୍ ନୁ କେଞ୍ଜୁତିଡ଼୍‍ । ଅଣ୍ଡ୍‌ କେତୁତଣ୍ଡ୍, ନାରୁଡ଼୍ ତିଆର୍ ମାଡ଼୍‍ତେ ଦେୟାକ୍ ସାରେ ବେପଡ଼୍ ଦେୟାକ୍ ଆୟ୍‍ୟ, ମେଣ୍ଡେ ଅଣ୍ଡ୍‌ ଇଗେ ଏପିସସ୍‍ ନୁ ମାତ୍ରମ୍‍ ସାରେ ଏସିଆ ଦେଶ୍‍ତାଗ୍ ନାର୍‍ଗେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଇଦ୍ ବିଷୟ୍ ବୁସା ମାଡ଼ି କେତୁତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ଆଦିଙ୍କ୍ ମାନ୍‍ ବ୍ୟବସାୟ୍ ବଦ୍‍ନାମ୍ ଆଦାନ୍ ଆଶଙ୍କା ମିନ୍ଦେ । ମାତର୍‍ ଆସର୍ ଆୟ୍‍ୟ, ବେନ୍ ଦେବୀ ଏସିଆତାଗ୍ ନୁ ସାରେ ଜଗତ୍‍ ତାଗ୍ ପୂଜା ପାଏମ୍ ଆଦୁତ୍‍ତେ, ଆଦ୍ ବିକ୍ୟାତ୍ ଆର୍ତ୍ତେମୀ ଦେବୀତ୍ ମନ୍ଦିର୍‍ତେ ପେଦେର୍ ମେଣ୍ଡେ ମାନ୍‍ନ ନୁ ଆର୍ତ୍ତେମୀ ଦେବୀତ୍ ସମ୍ମାନ୍ ନଷ୍ଟ ଆଦ୍‍ତେ ।” ");
INSERT INTO kff_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ନାରୁଡ଼୍ ଇଦ୍ ଗଟ୍ କେଞ୍ଜି କପାମ୍ ଆତ୍‍ତଡ଼୍ ନୁ ଗାଟି ଲେଙ୍ଗ୍‍ଦେ କେତ୍‍ତଡ଼୍, “ଏଫିସିୟତେ ଆର୍ତ୍ତେମୀ ମହାଦେବୀ ଜୟ୍ !” ");
INSERT INTO kff_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ଇଦ୍ ଗଲ୍‍କ୍ ନଗର୍ ଏକାମ୍ ଆତ୍‍ତେ । କପାମ୍ ଆତ୍‍ତେ ନାରୁଡ଼୍ ପାଉଲ୍‍ତେ ତଡ଼୍ ୱାତ୍‍ତେନଡ଼୍‍ ମାସିଦୋନିଆତେ ଗାୟସ୍ ନୁ ଆରିଷ୍ଟାର୍କସ୍‍ତିଙ୍କ୍ ପଇସ୍ ତାମାଦ୍ ରଙ୍ଗ୍‍ବୁମ୍‌ତାଗ୍ ଲାଗି ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ପାଉଲ୍ ନିଜେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ସାମ୍‍ନା ମାଡ଼ାନଙ୍କ୍ ତିଆର୍ ଆତ୍‍ତଣ୍ଡ୍, ଇତ୍‍କେ ବିଶ୍ୱାସୀଡ଼୍ ଶିଷ୍ୟ ଇଦ୍ ମାଡ଼ାନଙ୍କ୍ ଇୱଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କର୍ମଚାରୀ ସାଙ୍ଗଡ଼୍ ପାଉଲ୍‍ତିଙ୍କ୍ ରଙ୍ଗ୍‍ବୁମ୍‌ ଲୋପେ ଆନ୍‌‍ମାକିନ୍ ଇଞ୍ଜ ଅନୁରଦ୍‌‍ ମାଡ଼ି ଅଣ୍ଡୟ୍‌‍ କାବୁର୍‍ ରଅତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ଇଦ୍ ସମୟ୍‍ ଲୋପେ ପୁରାମାନ୍ଦେ ସାରେତଡ଼୍ କପାମ୍ ଆତ୍‍ତଡ଼୍ । ନାରୁଡ଼୍ ମାନ୍ଦାମାନ୍ଦା ଆସ୍ ନାର୍‍ଗେ କିଡ଼୍‍କ ମାତ୍‍ତଡ଼୍, ଇତ୍‍କେ ଅଡ଼୍‌ ଲୋପେ ନାର୍‍ଗେ ନାରୁଡ଼୍ ଅଡ଼୍‌ ଅଣ୍ଡୟାଗେ ଆତ୍‍ତେ କାରନ୍‍ ମିକା ପୁନ୍‍ୱେ ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ନାରୁଡ଼୍ ଲୋପେଙ୍କ୍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ କେତ୍‍ତଡ଼୍ ଯେ, ଆଲେକ୍‍ଜାଣ୍ଡର୍ ଇଦିନ୍ ସେଙ୍ଗେ ଦାୟୀ, ବାତେଙ୍କ୍ଇତ୍‍କେ ଇହୁଦୀଡ଼୍ ଅଂକିଙ୍କ୍‌ ମୁନ୍‍ନେ ନିସ୍ପି ମାତ୍‍ତଡ଼୍ । ଆଲେକ୍‍ଜାଣ୍ଡର୍ କାୟ୍‍ ତେଇସ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ କଟ ମାନ୍ଦାନଙ୍କ୍ ଚିନ୍ନେ ହିତ୍‍ତଣ୍ଡ୍ ନୁ ବିଶ୍ୱାସୀଡ଼୍ ଗାର୍ରେ ବାଷଣ ଇସ୍‌ ବୁଜାମାଡ଼ାଙ୍କ୍ ଚେଷ୍ଟା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ଏଫିସିୟ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ଇହୁଦୀ, ଇଦ୍ ପୁଞ୍ଜ୍ ଅଡ଼୍‌ ସାରେତଡ଼୍ ଅଣ୍ଡୟ୍‌‍ଦାମ୍ କିଡ଼୍‍କ୍‌ତଡ଼୍, “ଆର୍ତ୍ତେମୀ ମହାଦେବୀନ୍ ଜୟ୍ !” ରେଣ୍ଡ୍ ଗାଣ୍ଟା ଇଦ୍‍ରକମ୍ ମର୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ପେର୍‍କେ ନଗର୍‍ପାଳ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶାନ୍ତି ମାଡ଼ାନଙ୍କ୍ କେତ୍‍ତଣ୍ଡ୍, “ଏଫିସିୟତେ ଦାଦାଲଡ଼୍ ସାରେତଡ଼୍ ପୁତ୍‍ତଡ଼୍ ଯେ, ଏପିସସ୍‍ ନଗରୀତାଗ୍ ବେଡ଼୍‍ୟାଦ୍‍ ଦେବୀ ଆର୍ତ୍ତେମୀ ମନ୍ଦିର୍ ନୁ ମୟଲ୍‍ତାଗାଙ୍କ୍ ଦେଗି ୱାସ୍‍ମାନ୍ଦାନ୍ ପବିତ୍ର ମୂର୍ତ୍ତିତିଙ୍କ୍ ସୁରକ୍ଷା ହାସମିନ୍ଦେ । ");
INSERT INTO kff_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ବେନ ଇଦ୍ ଅସ୍ୱୀକାର୍ ମାଡ଼ାଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ । ଆଦିଙ୍କ୍ ମିଡ଼୍ ସାରେତଡ଼୍ ଶାନ୍ତି ଆୟ୍‍ମୁଟ୍ । ବାତ୍‍ମିକା ବୁଲ୍‍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ମାଟ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ଇ ନାରୁଡ଼୍ ମନ୍ଦିର୍‍ତାଗାଙ୍କ୍ ବାତେଏ ଡଙ୍ଗଡ଼୍, କି ମାନ୍‍ ଦେବୀନ୍ ଅତ୍ୟାଚାର୍ ବାତ୍ କାରାପ୍ କେଲଡ଼୍, ଆଗେକ୍‍ବା ମିଡ଼୍ ଇଡ଼୍‍କିଙ୍କ୍ ପଇସ୍ ତାତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଯଦି ଦୀମିତ୍ରିୟ ନୁ ଅନ୍‌ କାରିଗରୀଡ଼ାଦ୍ ବିରୁଦ୍‍ତେ ବେନନାଦ୍ ବାତ୍ ଅବିଯଗ୍ ମିନ୍ଦେ, ଆଦ୍ ବିଚାର୍ ମାଡ଼ାନଙ୍କ୍ ମାନ୍‍ କର୍ମଚାରୀଡ଼୍ ମିନ୍ଦେ ନୁ ବିଚାର୍‍ଳୟତାଗ୍ ନିର୍ଦ୍ଦିଷ୍ଟ ଦିନାମ୍ ମିନ୍ଦେ । ଆଗେ ଆଦ୍ ଅବିଯଗ୍ ତାସ୍ କେଲ୍‍ମୁଟ୍ । ");
INSERT INTO kff_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ଯଦି ଇଦିନାଗାଙ୍କ୍ ମେଣ୍ଡେ ଅଦିକ୍‌ ହାଲ୍‍ସୁତିଡ଼୍, ଆଲେକେ ନାଗରିକୀଡ଼୍ ତଡ଼୍ ଆଇନ୍‍ ମାଡ଼୍‍ତେ ମିଟିଙ୍କ୍‍ତାଗ୍ ଅନାଦ୍‌ ନିଷ୍ପତ୍ତି ଆୟି । ");
INSERT INTO kff_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ନେଣ୍ଡ୍ ବାତ୍ ଗଟେମ୍ ଆତ୍‍ତେ, ଆଗେ ମାନ୍‍ ବିରୁଦ୍‍ତେ ଇଂସାକାଣ୍ଡ ଆଦାନାଦ୍ ଆଶଙ୍କା ମିନ୍ଦେ; ମାମ୍‍ମେ ଇୱୁସାରେ ଗଲ୍‍କିନାଦ୍ ବାତ୍‍ବା ଟିକ୍ କାରନ୍‍ ତଅତାଙ୍କ୍ ପାର୍‍ୱମ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଇୱୁସାରେ ଗଟି କେସ୍ ଅଣ୍ଡ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଶାନ୍ତି ମାଡ଼ି ମିଟିଙ୍ଗ୍‍ ବନ୍ଦ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ଗଲ୍‍କ୍ ତେର୍‍ତେ ପେର୍‍କେ ପାଉଲ୍ ବିଶ୍ୱାସୀଡ଼୍‍ ଶିଷ୍ୟ ଅଣ୍ଡୟାଗେ ମାଡ଼ି ୱେଡ଼୍‍କାତାୱ୍ ଗଟି କେତ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ଆଗାଙ୍କ୍‌ ବିଦାୟ୍ ଅସ୍ ଅଣ୍ଡ୍‌ ମାସିଦୋନିଆତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ଅଣ୍ଡ୍‌ ସାରେ ପଡ଼୍‍ୟେ ଇସ୍‌ ଆତ୍‍ତଣ୍ଡ୍ ନୁ ନାର୍‍ଗେ ଉପଦେଶ୍‍ ଇସ୍‌ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ୱେଡ଼୍‍କା ମାଡ଼୍‍ତଣ୍ଡ୍ । ପେର୍କେ ଅଣ୍ଡ୍‌‍ ଗ୍ରୀସ୍‍ ଦେଶ୍‍ତାଗ୍‍ ଏୱୁତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ଆଗେ ମୁଣ୍ଡ୍ ନେଲ୍‍ଞ୍ଜ୍ ମାତ୍‍ତଣ୍ଡ୍ । ଅଣ୍ଡ୍‌ ସିରିଆତାଗ୍ ଆଦାନଙ୍କ୍ ତିଆର୍ ଆତ୍‍ତେ ୱେଲେ ଇହୁଦୀଡ଼୍ ଅନ୍‌ ପର୍‍ର କପାମ୍ ଆତ୍‍ତଡ଼୍ ଇଞ୍ଜ କେଞ୍ଜି ମାସିଦୋନିଆତାଲା ମାଲ୍‍ସ୍ ଆଦାନଙ୍କ୍ ତିଆର୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ବେରିଆ ନିବାସୀ ପୁରନ୍ ମାର୍‍ ସୋପାତ୍ର, ଥେସଲନିକୀତେ ଆରିଷ୍ଟାରର୍କସ୍ ନୁ ସେକୁନ୍ଦ, ଦର୍ବୀତେ ଗାୟ, ଏସିଆ ଦେଶ୍‍ତେ ତୁକିକ ନୁ ତ୍ରଫିମ୍, ମେଣ୍ଡେ ତୀମତି ଅନ୍‌ ତଡ଼୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ଅଡ଼୍‌ ମୁନେନ୍ ଆଞ୍ଜ୍ ତ୍ରୋୟାତାଗ୍ ମାକିଂଙ୍କ୍ କେପିମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","କମୀରଶୂନ୍ୟ ରୋଟି ପାଣ୍ଡୁମ୍‍ତେ ପେର୍‍କେ ମାମ୍‍ମେ ଫିଲିପ୍‍ପୀ ଟାୱୁନ୍‍ତାଗାଙ୍କ୍ ଏର୍‍ଦାଲା ୱେଇସ୍‍ ମିକା ଏଇଙ୍ଗ୍ ଦିନା ପେର୍‍କେ ତ୍ରୋୟାତାଗ୍ ଅଡ଼୍‌ ତଡ଼୍ କାଇଲ୍‍ତମ୍ ନୁ ଆଗେ ଅଣ୍ଡୟ୍‌ ଆଟ୍‌ ମାତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ଅଣ୍ଡୟ୍‌‍ ସପ୍ତାତେ ମୁନେତ୍‍ ଦିନେ ମୁଲ୍‍ପୁଟ୍ ମାମ୍‍ମେ ସାରେତମ୍ କାଇଲି ତିନ୍ଦାନଙ୍କ୍ ଅଣ୍ଡୟାଗେ ଗୁଡ଼୍‍ତମ୍ । ପାଉଲ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ନାଟ୍‍ନାର୍‍କେ ଜାକ ଉପଦେଶ୍‍ ଇତ୍‌ତଣ୍ଡ୍‌‍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ମେଣ୍ଡେଅନ୍‌ ଦିନ୍ ଅଣ୍ଡ୍‌ ଆଦ୍ ପଡ଼୍‍ୟେ ୱିଡ଼୍‍ସାନଙ୍କ୍ ଆଞ୍ଜମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ବେନ୍ ପରତ୍‍ ବାକ୍‍ଡ଼େତାଗ୍ ମାମ୍‍ମେ ମିଟିଙ୍ଗ୍‍ ମାଡ଼ି ମାତ୍‍ତମ୍, ଆଗେ ନାର୍‍ଗେ କୁପି ନିଡ଼୍‍ସ ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଆଗେ ଇଉଟିକସ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ଲେୟଣ୍ଡ୍ ଜର୍‍କାତାଗ୍‍ କୁଦି ମାତ୍‍ତଣ୍ଡ୍, ପାଉଲ୍ ଗଟି କେତ୍‍ତାନ୍ ୱେଲେ ଅଂକିଙ୍କ୍‌ ଉସ୍କାଡ଼୍ ୱାତ୍‍ତେ । ଅଣ୍ଡ୍‌ ଉସ୍କାଡ଼୍‍ତେ ମୁଣ୍ଡ୍ ମହଲାତାଗାଙ୍କ୍ ମଦଲ୍ ରାୟ୍‍ତଣ୍ଡ୍ । ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ତେଏତାନ୍ ୱେଲେ ଅଣ୍ଡ୍‌ ଡଲିମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ଇତ୍‍କେ ପାଉଲ୍ ମଦଲ୍ ଡିଗି ଅଂକିଙ୍କ୍‌ ଗାଡ଼୍‍ମ୍ଉର୍‍ଙ୍ଗି କେତ୍‍ତଣ୍ଡ୍, “ଦାନ୍ଦେ ଆୟ୍‍ମାଟ୍ । ଅଣ୍ଡ୍‌ ଜିୱୁଣ୍ଡ୍‍ ମିନ୍ଦେଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ତାନ୍‍ପେର୍କେ ଅଣ୍ଡ୍‌ ପର୍‍ର ମାଲ୍‍ସ୍ ଆଞ୍ଜ୍ ରୂଟି ଉହୁସ୍ ତିତ୍‍ତଣ୍ଡ୍ ନୁ ପଡ଼୍‍ଦ୍ ପେୟ୍‍ନା ଯାକ ଅଡ଼୍‌ ତଡ଼୍ ନାର୍‍ଗେ ଗଟି ତିର୍‍ୟି ଆଗାଙ୍କ୍ ଆତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ନାରୁଡ଼୍ ପିଲାନ୍ ଜିୱେ ମାନ୍ଦାନାଦ୍ ଉଡ଼ି ତାମ୍ ଲୋନ୍‌ ଆତ୍‍ତଡ଼୍ ନୁ ନାର୍‍ଗେ ୱେଡ଼୍‍କା ପାଏମ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ମାମ୍‍ମେ ମୁନେନ୍ ଏର୍‍ ଜାହାଜ୍‍ତାଗ୍ ତାରି ଆସୋସ୍‍ତାଗ୍ ଆତ୍‍ତମ୍ । ଆଗାଙ୍କ୍ ମାମ୍‍ମେ ପାଉଲ୍‍ତିଙ୍କ୍ ଏର୍‍ଜାହାଜ୍‍ତାଗ୍ ତାର୍‍ସ୍ପି ଆଦାନାଦ୍ ମାତ୍‍ତେ, ବାତେଙ୍କ୍ଇତ୍‍କେ ଅଣ୍ଡ୍‌ ବୁମ୍‌ତାଗା ଆଞ୍ଜ୍ ଆଗେ ହେୱୁଦ୍‍ତାନ୍ ଇଞ୍ଜ କେସ୍‍ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ଅଣ୍ଡ୍‌ ବେସୁଟ୍‌ ମାକିଂଙ୍କ୍ ଆସୋସ୍‍ତାଗ୍ କାଇଲ୍‍ତଣ୍ଡ୍, ମାମ୍‍ମେ ଅଂକିଙ୍କ୍‌ ଏର୍‍ଜାହାଜ୍‍ତାଗ୍ ତାର୍‍ସ୍ପି ମିତିଲିନୀତାଗ୍ ଆତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ଆଗାଙ୍କ୍ ଆଞ୍ଜ୍ ମେଣ୍ଡନ୍‍ଦିନେ ସାମୋସ୍‍ତାଗ୍ ହେୱୁତ୍‍ତମ୍ । ମେଣ୍ଡନ୍‍ଦିନେ ମାମ୍‍ମେ କିଆସ୍‍ତାଗ୍ ହେୱୁତମ୍, ତାନ୍ ମେଣ୍ଡନ୍‍ଦିନେ ମିଲୀଟସ୍‍ତାଗ୍ ହେୱୁତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ରୋମ୍‍ତେ ଏସିଆ ପ୍ରଦେଶ୍‍ତାଗ୍ ମେଣ୍ଡେ ନାର୍‍ଗେ ଦିନା ମାନକଟ୍ ଏପିସସ୍‍ ହାଞ୍ଚ୍‍ ହାଞ୍ଚ୍‍ ଏର୍‍ଜାହାଜ୍ ଚାଲାମାଡ଼ାଙ୍କ୍ ପାଉଲ୍ ମାନ୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ଯଦି ସମ୍ଭବ୍ ଆଦ୍‍ତେ, ପେଣ୍ଟିକଷ୍ଟ୍ ଦିନାତେ ଯିରୁଶାଲେମ୍‍ ହେୱୁଦାନଙ୍କ୍ ଅଣ୍ଡ୍‌ ଦାନ୍ଦେ ଆସମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ଏପିସସ୍‍ ମଣ୍ଡଲିତେ ବୟସ୍କା ନେତାଲଡ଼୍‍କ୍ ମିଲୀଟସ୍‍ ତଡ଼୍ କାଇଲାନଙ୍କ୍ ପାଉଲ୍ କାର୍‍ଙ୍ଗ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ଅଡ଼୍‌ ୱାସ୍ ହେୱୁତ୍‍ତାଙ୍କ୍ ପାଉଲ୍ କେତ୍‍ତଣ୍ଡ୍, “ରୋମ୍‍ତେ ଏସିଆ ପ୍ରଦେଶ୍‍ତାଗ୍ ହେୱୁତ୍‍ତେ ଦିନାକନ୍ସ୍ ନାନ୍ ବେଲା ମିଇ ତଡ଼୍ ନାର୍‍ଗେ ଦିନାମ୍ ମିନ୍ଦେନ୍ ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ଇହୁଦୀଡ଼୍ ଜୋଜନା ସେଙ୍ଗେ ନାନ୍ ବେନ୍‍ସାରେ ଦୁଃକକଷ୍ଟ ପାଏମ୍ ଆତ୍‍ତାନ୍, ଆଦିନ୍ ଲୋପେ ନାନ୍ ପ୍ରବୁନ୍‍ ଦାସତେ ଲେକାମ୍ କାଣ୍ଡେଡ଼ି ରାପି ନମ୍ରତଡ଼୍‍ ନାୱାଦ୍ ପାଡ଼୍‍ୟି ମାଡ଼୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍ ଯେ, ନାନ୍ ନାରୁଡ଼୍ ବକେତ୍ ପ୍ରଚାର୍ ମାଡ଼ାନ୍ ୱେଲେ ନୁ ମିଇ ଲୋନ୍‌ ଉପଦେଶ୍‍ ହିଦାନ୍ ସମୟ୍‍ତେ ମିୟାଦ୍ ଉପକାର୍ ଆଦାନ୍ ରକମ୍ ବାତ୍ ବିଷୟ୍ କେତାନଙ୍କ୍ ସିଗ୍‍ ଆୟ୍‍ୱେ ମାତ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ଇହୁଦୀ ନୁ ଅଣଇହୁଦୀଡ଼୍ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ନାନ୍ ଗାଟି ସତର୍କ ଗଟ୍ କେତ୍‍ତାନ୍, ଅଡ଼୍‌ ଅନୁତାପ୍‍ ମାଡ଼ି ପାପାମ୍‍ତାଗାଙ୍କ୍ ମାଲ୍‍ସ୍‍ମିକା ଇଶ୍ୱର୍‌ତେ ପାକେ ମନ୍ ମାଡ଼ିତଡ଼୍ ନୁ ପ୍ରବୁ ଜିସୁନାଗ୍ ବିଶ୍ୱାସ୍ ମାଡ଼ିତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ଇଞ୍ଜେ ପବିତ୍ର ଆତ୍ମାତେ ନିର୍ଦ୍ଦଶ୍ ପାଲନ୍ ମାଡ଼ି ନାନ୍ ଯିରୁଶାଲେମ୍‍ ଆଦୁତାନ୍ । ନାନ୍ ପୁନନ୍ ଆଗେ ନାୟାଦ୍ ବାତ୍ ଆଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ପବିତ୍ର ଆତ୍ମା ନାକିଂଙ୍କ୍ କେସ୍‍ ସତର୍କ ମାଡ଼ିସ୍‍ ମିନ୍ଦେ ଯେ ନାନ୍‍ନେ ସାରେ ଟାୱୁନ୍‌କିନାଗ୍‌ ବନ୍ଦି ଆଦ୍‌ତାନ୍ ନୁ ଆଗେ ମାଞ୍ଜ୍ କଷ୍ଟ ପାଏମ୍ ଆଦ୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ଇତ୍‍କେ ନା ସେଙ୍ଗେ ନାନ୍ ନାୟାଦ୍ ଜିୱୁଣ୍ଡ୍‍ତିଙ୍କ୍ ସୁଦୁର୍ ହେର୍କା ମାଡ଼ିତାନ୍ । ଇଶ୍ୱର୍‌ତେ ଅନୁଗ୍ରହ ବିଷୟ୍ ପ୍ରବୁ ଜିସୁ ବେନ୍ କବର୍ ସୁସମାଚାର୍ କେତ୍‍ତାନଙ୍କ୍ ନାକିଂଙ୍କ୍ ହିତ୍‍ତଣ୍ଡ୍, ଆଦ୍ ପୁରନ୍ ମାଡ଼ି ନାୟାଦ୍ ପ୍ରଚାର୍ ପାଡ଼୍‍ୟି ସାରେ ମାଡ଼ିତାନ୍; ଇସରେ ନାୟାଦ୍ ଇଚ୍ଛା ।” ");
INSERT INTO kff_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ଇଶ୍ୱର୍‌ତେ ରାଜ୍ୟ ବିଷୟ୍ ପ୍ରଚାର୍ ମାଡ଼ାନଙ୍କ୍ ନାନ୍ ମିଡ଼୍ ସାରେତଡ଼୍‍ତେ ବକେତ୍ ଆତ୍‍ତାନ୍ । ଇଞ୍ଜେ ଉଡ଼ାଟ୍‍, ନାନ୍ ପୁତ୍‍ତାନ୍ ଯେ, ମିଇ ଲୋପେଙ୍କ୍ ବେନ ନାକିଂଙ୍କ୍ ମେଣ୍ଡେ ଉଡ଼୍‍ୱିଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ଆଦିଙ୍କ୍ ନାନ୍ ନେଣ୍ଡ୍ ଲେକେତ୍‍ ମିଇ ଗାର୍‍ରେ ପ୍ରଚାର୍ ମାଡ଼ୁତାନ୍ ଯେ, ଯଦି ମିଇ ଲୋପେଙ୍କ୍ ବେନ ଦଂସ ଆଦ୍‍ତନ୍, ଆଦିନ୍ ସେଙ୍ଗେ ନାନ୍ ଦାୟି ଆୟନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ବାତେଙ୍କ୍ଇତ୍‍କେ ଇଶ୍ୱର୍‌ତେ ସାରେ ଉଦେଶ୍ୟ ମିଇ ଗାର୍‍ରେ କେତାନଙ୍କ୍ ନାନ୍ ସିଗ୍‍ ମାଡ଼ନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ଆଦିଙ୍କ୍ ମିଡ଼୍ ନେତା ଲେକାମ୍ ନିଜର୍‍ ବିଷୟ୍‍ତେ ନୁ ପବିତ୍ର ଆତ୍ମା ବେନ୍ ବିଶ୍ୱାସୀଡ଼୍‍କ୍ ମିଇ ଦାୟିତ୍ୱତେ ୱିଡ଼୍‍ସ୍‍ତଣ୍ଡ୍, ଆ ସାରେତଡ଼୍‌କିଂଙ୍କ୍ ଯତନ୍ ଆୟ୍‍ମୁଟ୍ । ମେଣ୍ଢାପଡ଼୍‍ପାନଡ଼୍ ଲେକାମ୍ ଇଶ୍ୱର୍‌ତେ ମଣ୍ଡଲିତିଙ୍କ୍ ଯତନ୍ ଆୟ୍‍ମୁଟ୍ । ଆଦ୍ ମଣ୍ଡଲିତିଙ୍କ୍ ଅଣ୍ଡ୍‌ ତାନ୍ ମାର୍‍ ଦଂସ ଆତ୍‍ତାଙ୍କ୍ ନିଜର୍‍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ନାନ୍ ପୁତ୍‍ତାନ୍, ନାନ୍ ଆତ୍‍ତେ ପେର୍‍କେ ମିୟାଗ୍ ବୟଙ୍କର୍ କୁକାଲି ୱାଦ୍‍ତା ନୁ ବିଶ୍ୱାସୀଡ଼୍‍କିଂଙ୍କ୍ ପୁଣ୍ଡ୍‍କ୍ ମାଡ଼ି ୱିଡ଼୍‍ସିତା । ");
INSERT INTO kff_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ଦିନାମ୍ ୱାଦ୍‍ତେ, ଆସୁଟେ ମିଇ ନିଜର୍‍ ମାନ୍ଦେତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍‌ ବୁସା ଗଟି କେସ୍ କାରାପ୍ ହାର୍‍ଦାଗ୍ ଆଦ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ଆସୁଟ୍‍ ସତର୍କ ମାନୁଟ୍, ନାନ୍ ଯେ ନାର୍‍କେ ପାୟାଲ୍ ନିଜର୍‍ କାଣ୍ଡେଡ଼ି ରାପି ମୁଣ୍ଡ୍ ହେଣ୍ଡ୍‍କ୍ ଯାକ ଶିକ୍ଷା ହିତ୍‍ତାନ୍, ଇଦ୍ ହେର୍କା ମାଡ଼ାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ଇଞ୍ଜେ ନାନ୍ ମିକିଂଙ୍କ୍ ଇଶ୍ୱର୍‌ତେ କାୟ୍‍ଦେ ପରିଷ୍କାର୍‍ ନୁ ଅନୁଗ୍ରହ ବାକ୍ୟ ଗାର୍‍ରେ ସମର୍‍ପନ୍ ମାଡ଼ୁତାନ୍; ଆଦ୍ ବାକ୍ୟ ମିକିଂଙ୍କ୍ ଡୁଟାଙ୍ଗ୍‍ ମାଡ଼ାନଙ୍କ୍ ନୁ ଇଶ୍ୱର୍‌ତେ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ଦର୍‍କାର୍ ସାରେ ଆର୍ଶିବାଦ୍ ମିକିଂଙ୍କ୍ ହିଦାନଙ୍କ୍ ପାର୍‍ଦ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ନାନ୍ ବେନନ୍ ରୁପା, ସୁନା ନୁ ବେନନ୍ ଚକା ପାଏମ୍ ଆଦାନଙ୍କ୍ ଆଶେ ମାଡ଼ନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ମିଡ଼୍ ପୁତ୍‍ତିଡ଼୍, ନାନ୍ ନା ଇୱୁ ରେଣ୍ଡ୍ କାୟ୍‍କିନ୍‍ ତଡ଼୍ ପାଡ଼୍‍ୟି ମାଡ଼ି ନିଜର୍‍ ନୁ ନା ତଡ଼୍ ପାଡ଼୍‍ୟି ମାଡ଼ାନଡ଼ାୱ୍ ସାରେ ଇଚ୍ଛା ସାଦନ୍ ମାଡ଼୍‍ତାନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‘ପାଏମ୍ ଆଦ୍‍ଦାନ୍ ନାଗାଙ୍କ୍ ଦାନ ମାଡ଼ାନାଗ୍ ଅଦିକ୍‌ ୱେଡ଼୍‍କେ ମାନ୍‍ତେ,’ ନିଜେ ପ୍ରବୁ ଜିସୁନାଦ୍ ଇଦ୍ ବାକ୍ୟତିଙ୍କ୍ ହେର୍କା ମାଡ଼ି ଇଦ୍ ରକମ୍ କଷ୍ଟ ପାଡ଼୍‍ୟି ମାଡ଼ି ମାନାଡ଼୍ ଗରିବ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ିକାଡ଼୍, ଇଦ୍ ବିଷୟ୍‍ତେ ନାନ୍ ସାରେଦାମ୍ ମିକିଂଙ୍କ୍ ଆଦର୍ଶ ତଅତ୍‍ତାନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଇଦ୍‍ ଗଟ୍‍ ତେର୍‍ତେ ପେର୍‍କେ ପାଉଲ୍ ଅଡ଼୍‌ ତଡ଼୍ ମର୍‍ମିଣ୍ଡା ଇସ୍‌ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ସାରେତଡ଼୍ କେୟି କେୟି ପାଉଲ୍‍ତିଙ୍କ୍ ଗାଡ଼୍‍ମ୍ ଉର୍‍ଙ୍ଗି ନମସ୍କାର୍‍ ମାଡ଼ି ରହତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ଅଡ଼୍‌ ମେଣ୍ଡେ ଅଂକିଙ୍କ୍‌ ଉଡ଼ାନଙ୍କ୍ ପାର୍‍ୱଡ଼୍ ଇଞ୍ଜ ଅଣ୍ଡ୍‌ କେତ୍‍ତାଙ୍କ୍ ଅଡ଼୍‌ ଗାଟି ଦୁଃକାମ୍ ଆସ୍ ମାତ୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ବିଦାୟ୍ ହିଦାନଙ୍କ୍ ଜାହାଜ୍‍ତେ ବକେତ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ମାମ୍‍ମେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରହସିସ୍ ଆଗାଙ୍କ୍ ମାଲ୍‍ସ୍ ଆତ୍‍ତମ୍ । ଏର୍‍ଦିଙ୍କ୍ ୱେଇସ୍ ମାମ୍‍ମେ କୋସ୍‍ ଦ୍ୱୀପତାଗ୍ ହେୱୁତ୍‍ତମ୍ । ମେଣ୍ଡେଅନ୍‌ ଦିନ୍ ରୋଡସ୍ ଆଞ୍ଚ୍ ଆଞ୍ଚ୍ ପାତାରାତାଗ୍ ଆତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ଆଗାଙ୍କ୍‍ ଫିନିସିଆତାକ୍ ଆଦାନ୍ ଜାହାଜ୍‍ ତାରି ଆତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ତାନ୍‍ପେର୍କେ ସାଇପ୍ରସ୍ ତଅନ୍‌ଦମାନ୍ଦାନ୍ ଅଣ୍ଡୟ୍‌ ପଡ଼୍‍ୟେତାଗ୍ ହେୱୁତ୍‍ତମ୍ । ଆଗାଙ୍କ୍ ଆଦିନ୍ ତିନ୍ଦେପାକ୍ ଇସ୍‌ ମାମ୍‍ମେ ସିରିଆତାଗ୍ ଆତ୍‍ତମ୍ । ମାମ୍‍ମେ ଟାୟର୍‍ ଟାୱୁନ୍‍ତାଗ୍ ଏର୍‍ଜାହାଜ୍‍ତାଗାଙ୍କ୍ ଡିଗ୍‍ତମ୍, ବାତେଙ୍କ୍ ଇତ୍‍କେ ଆଦ୍ ଏର୍‍ଜାହାଜ୍‍ତାଗାଙ୍କ୍ ଜିନିଷ୍‍ ଡିପାନ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ଆଗେ ମାମ୍‍ମେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ବଶ୍ୱାସୀ ଶିଷ୍ୟ ତଡ଼୍ କାଇଲି ଅଣ୍ଡୟ୍‌ ଆଟ୍ ମାତ୍‍ତମ୍ । ପବିତ୍ର ଆତ୍ମାତେ ନିର୍ଦ୍ଦେଶ୍ ପାଏମ୍ ଆସ୍ ଅଡ଼୍‌ ପାଉଲ୍‍ତିଙ୍କ୍ ଯିରୁଶାଲେମ୍‍ ଆଦାନଙ୍କ୍ ମନା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ଇତ୍‍କେ ଅଡ଼୍‌ ତଡ଼୍ ଅଣ୍ଡୟ୍‌ ଆଟ୍ ମାତ୍‍ତେ ପେର୍‍କେ ମାମ୍‍ମେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ୱିଡ଼୍‍ସି ନିଜର୍‍ ହାର୍ ଆତ୍‍ତମ୍ । ମାକିଂଙ୍କ୍ ୱିଡ଼୍‍ସାନଙ୍କ୍ ଅଡ଼୍‌ ସାରେତଡ଼୍ ନିଜର୍‍ ମୁତ୍‍ତେ ନୁ ପିଲାଙ୍କ୍ ପଇସ୍ ନାର୍ ବାୟିଦେ ମାନ୍ଦାନ୍ ଗଦାଡ଼୍ ଆଞ୍ଚ୍ ଯାକ ୱାତ୍‍ତଡ଼୍ । ଆଗେ ମାମ୍‍ମେ ସାରେତମ୍ ମର୍‍ମିଣ୍ଡା ଉୱୁସ୍ ପ୍ରାର୍ତନା ମାଡ଼୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ତାନ୍‍ପେର୍କେ ମାମ୍‍ମେ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ରହସିସ୍, ଏର୍‍ ଜାହାଜ୍‍ତାଗ୍ ୱାତ୍‍ତମ୍, ଅଡ଼୍‌ ଲୋନ୍‌ ମାଲ୍‍ସ୍ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ଟାୟର୍‍ତାଗାଙ୍କ୍ ପାଲଟ୍‍ ୱାଟି ମାମ୍‍ମେ ଆଞ୍ଜ ଆଞ୍ଜ ତାଲମେଇତାଗ୍ ହେୱୁତମ୍, ଆଗେ ବିଶ୍ୱାସୀଡ଼୍ ତଡ଼୍ ନମସ୍କାର୍‍ ମାଡ଼ି ଅଡ଼୍‌ ତଡ଼୍ ଅଣ୍ଡୟ୍‌ ଦିନ୍ ମାତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ମେଣ୍ଡନ୍ ଦିନ୍ ମାମ୍‍ମେ ଆଦ୍ ପଡ଼୍‍ୟେ ୱିଡ଼୍‍ସି କାଇସରିଆତାଗ୍ ହେୱୁତମ୍ । ମାମ୍‍ମେ ଆଗେ ପ୍ରଚାର୍‍ମାଡ଼ାନ୍‍ ଫିଲିପ୍‍ପନ୍ ଲୋନ୍‌ ମାତ୍‍ତମ୍, ଜିରୁଶାଲମ୍‍ତାଗ୍ ସାତ୍‍ଜାନ୍ ହେଞ୍ଚିମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍ ଲୋପେଙ୍କ୍ ଅଣ୍ଡ୍‌ ୱେରଣ୍ଡ୍ ମାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ଅନାୱୁ ନାଲୁ ପେଣ୍ଡୁଲ୍ଆୟ୍‍ୱା ମାୟାସ୍କ୍ ମାତ୍‍ତା ଆୱୁ ଇଶ୍ୱର୍‌ତେ ସୁସମାଚାର୍‍ ପ୍ରଚାର୍‍ ମାଡ଼ମାତ୍‍ତା । ");
INSERT INTO kff_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ମାମ୍‍ମେ ଆଗେ ନାର୍‍ଗେ ଦିନା ମାତ୍‍ତେ ପେର୍‍କେ, ଯିହୁଦା ଦେଶ୍‍ତାଗାଙ୍କ୍ ଆଗାବ୍ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ବାବବାଦୀ ଆଗେ ୱାତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ଅଣ୍ଡ୍‌ ମା ଗାର୍‍ରେ ୱାସ୍ ପାଉଲ୍‍ତେ ବେଲ୍‍ଟ୍‍ତିଙ୍କ୍ ଆତ୍‍ତଣ୍ଡ୍‍, ଆଦିନ୍ ତଡ଼୍ ଅଣ୍ଡ୍‌ ନିଜର୍‌ କାୟ୍‍କ୍ ନୁ ଡେକାଙ୍କ୍ ତଅସ୍ କେତ୍‍ତଣ୍ଡ୍, “ପବିତ୍ର ଆତ୍ମା ନାକିଂଙ୍କ୍ କେତୁତଣ୍ଡ୍ ଯେ, ଇଦ୍ ବେଲ୍‍ଟ୍‍ତେ ନାକିଂଙ୍କ୍ ଯିରୁଶାଲେମ୍‍ ଇହୁଦୀଡ଼୍ ଇଦ୍ ରକମ୍ ତଃଅସ୍ ଅଂକିଙ୍କ୍‌ ଅଣଇହୁଦୀଡ଼୍ କାୟ୍‍ଦାଗ୍ ପସ୍‍ପିତ୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଇଦ୍ କେଞ୍ଜି ମାମ୍‍ମେ ନୁ ଆଦ୍ ପଡ଼୍‍ୟେତାଗ୍ ମାନ୍ଦାନ୍ ବାଗାତ୍ ନାରୁଡ଼୍ ପାଉଲ୍‍ତିଙ୍କ୍ ଅନୁରଦ୍‌‍ ମାଡ଼ି ଯିରୁଶାଲେମ୍‍ ଆଦାନଙ୍କ୍ ମନା ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ପାଉଲ୍ ଉତ୍ତର୍ ହିତ୍‍ତଣ୍ଡ୍, “ମିଡ଼୍ ଇଦ୍ ବାତ୍ ମାଡ଼ୁତିଡ଼୍, ବାତେଙ୍କ୍ କେୟିମିକା ନା ହୃଦୟ୍‍ତିଙ୍କ୍ କେଇସ୍ପିଦୁତିଡ଼୍ ? ଯିରୁଶାଲେମ୍‍ତାଗ୍ ମାତର୍‍ ତଅତିତଡ଼୍ ଆଦିନ୍ ମାଇଦିଙ୍କ୍ ୱେର୍‍ୱନ୍, ଇତ୍‍କେ ପ୍ରବୁ ଜିସୁନ୍ ପେଦେର୍‍ତେ ସେଙ୍ଗେ ଡଲାନଙ୍କ୍ ମିକା ନାନ୍ ତିଆର୍ ମିନ୍ଦେନ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ମାମ୍‍ମେ ଅଂକିଙ୍କ୍‌ ବୁଜା ମାଡ଼ାନଙ୍କ୍ ପାର୍‍ୱମ୍ ଗାଲା କଟ ଆସ୍ ମାତ୍‍ତମ୍ ନୁ କେତ୍‍ତମ୍‍, “ପ୍ରବୁନାଦ୍ ଇଚ୍ଛା ସାରେ ପୁରା ଆୟି ।” ");
INSERT INTO kff_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ଆଗେ ବେସ୍‍କେ ଦିନାମ୍ ମାଞ୍ଜ୍ ମାମ୍‍ମେ ମାୱା ଜିନିଷ୍ ପଇସ୍ ଯିରୁଶାଲେମ୍‍ତାକ୍ ଆତ୍‍ତମ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","କାଇସରିଆତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଶିଷ୍ୟଡ଼୍ ନୁ ସାଇପ୍ରସ୍‍ତେ ମନାସୋନ ପେଦେର୍‍ତଣ୍ଡ୍ ୱେରଣ୍ଡ୍ ବିଶ୍ୱାସୀ ମିକା ମା ତଡ଼୍ ଆତ୍‍ତଣ୍ଡ୍ । ମନାସୋନତେ ଲୋନ୍‌ ମାମ୍‍ମେ ମାନ୍ଦାନାଦ୍ ବ୍ୟବସ୍ଥା ଆସ୍ ମାତ୍‍ତେ । ");
INSERT INTO kff_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ଯିରୁଶାଲେମ୍‍ତାଗ୍ ବିଶ୍ୱାସୀଡ଼୍ ମାକିଂଙ୍କ୍ ସାର୍‍ଦେତ୍ତେ ସ୍ୱାଗତ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ମେଣ୍ଡେଅନ୍‌ ଦିନ୍ ପାଉଲ୍ ମା ଯାକୁବ୍‍ ଉଡ଼ାନଙ୍କ୍ ଆତ୍‍ତଣ୍ଡ୍; ମଣ୍ଡଲିତେ ସାରେତଡ଼୍ ନେତାଲଡ଼୍ ଆଗେ ୱାସ୍‍ମାତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ପାଉଲ୍ ଅଡ଼୍‌‍କିଂଙ୍କ୍ ନମସ୍କାର୍ ମାଡ଼ି ତାନ୍ ସେବା ପାଡ଼୍‍ୟିତଡ଼୍ ଇଶ୍ୱର୍ ଅଣଇହୁଦୀଡ଼୍‌କିଂଙ୍କ୍ ବାତ୍ ମାଡ଼ିମାତ୍‍ତଣ୍ଡ୍; ଆଦିନାଦ୍ ସାରେ ବିଷୟ୍‍ କେତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ଅନ୍‌ ଗଟ୍ କେଞ୍ଜ୍‍ତେ ପେର୍‍କେ ଅଡ଼୍‌ ସାରେତଡ଼୍ ଇଶ୍ୱର୍‌ତିଙ୍କ୍ ପ୍ରସଂଶା ମାଡ଼୍‍ତଡ଼୍ । ତାନ୍ ପେର୍‍କେ ଅଡ଼୍‌ କେତ୍‍ତଡ଼୍, “ହଁ ଦାଦା ପାଉଲ୍, ନିମ୍‍ ଉଡ଼ୁତିନ୍, ବେଲା ଇଞ୍ଜେ ହଜାର୍‌ ହଜାର୍‌ ଇହୁଦୀ ଦାଦାଲଡ଼୍‍ ପ୍ରବୁ ଜିସୁନାଗ୍ ବିଶ୍ୱାସ୍‍ ମାଡ଼ୁତଡ଼୍ ନୁ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ମିକା ପାଲନ୍ ମାଡ଼ୁତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ଅଡ଼୍‌ କାବୁର୍ ପାଏମ୍ ଆତ୍‍ତଡ଼୍ ଯେ, ନିମ୍‍ ଅଣଇହୁଦୀଡ଼୍ ଦେଶ୍ ବାସେ ମାଡ଼ମାନ୍ଦାନ୍ ଇହୁଦୀଡ଼୍‍କ୍ ମୋଶାଲ୍‌‍ ନିୟମ୍ ୱିଡ଼୍‍ସାନଙ୍କ୍, ଅଡ଼ାୱୁ ପିଲାକିଙ୍କ୍ ସୁନ୍ନତ୍ ମାଡ଼୍‍ମାଟ୍ ଇଞ୍ଜ ନୁ ଇହୁଦୀଡ଼୍ ରୀତିନୀତି ପାଲନ୍ ମାଡ଼୍‍ମାଟ୍ ଇଞ୍ଜ ଶିକ୍ଷା ହିଦୁତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ନିମ୍‍ ଇଗେ ହେୱୁତ୍‍ତିନ୍ ଇଞ୍ଜ ଅଡ଼୍‌ ନିଜାମ୍ କେଞ୍ଜିତଡ଼୍ । ଆଲେକେ ବାତ୍ ମାଡ଼ାନଙ୍କ୍ ଆଦ୍‍ତେ ? ");
INSERT INTO kff_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ମାମ୍‍ମେ ହାଲ୍‍ସୁତମ୍, ନିମ୍‍ ଅଣ୍ଡୟ୍‌‍ ପାଡ଼୍‍ୟି ମାଡ଼େ । ଇଗେ ମାନ୍ଦାନ୍ ନାଲୁଜାନ୍ ନାରୁଡ଼୍ ଅଣ୍ଡୟ୍‌ ମାନତ୍‍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ଅଡ଼୍‌ ତଡ଼୍ ଅନ୍‌ । ଶୁଚିକରଣ ବିଦି ପାଲନ୍ ମାଡ଼ାନାଗ୍ ଅଡ଼୍‌ ତଡ଼୍ କାଇଲି ଅଡ଼ାୱୁ କର୍ଚ୍ଚ ହିମ୍ । ତାନ୍‍ପେର୍କେ ଅଡ଼୍‌ ନିଜର୍‍ ନିଜର୍‍ ତାଲାତିଙ୍କ୍ ଟାଙ୍ଗ୍‍ରୁ ମାଡ଼ିତଡ଼୍ । ଆଗାଙ୍କ୍ ପୁନ୍‍ତଡ଼୍ ଯେ, ନି ବିଷୟ୍‍ତେ ପେଇସ୍ ମାନ୍ଦାନ୍ ସାରେ କାବୁର୍ ସତ୍ ଆୟ୍‍ୟ, ମାତର୍ ନିମ୍‍ ମୋଶାନ୍‌‌ ନିୟମ୍‍ ଲେକାମ୍ ବାଦ୍‍କୁତିନ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ଇତ୍‍କେ ବେନ୍ ଅଣଇହୁଦୀଡ଼୍ ବିଶ୍ୱାସୀ ଆତ୍‍ତଡ଼୍, ଅଡ଼୍‌ ଗାର୍‍ରେ ଅଣ୍ଡୟ୍‌ ଚିଟି ଲେକି କେତିତମ୍ ଯେ, ମାୱାଦ୍ ନିଷ୍ପତ୍ତି ଲେକାମ୍ ଅଡ଼୍‌ ପୁତ୍‍ଲାମ୍‍ତିଙ୍କ୍ ଇତ୍‍ତେ କାଦି ତିନଡ଼୍, ନେତୁର୍‍ ଉନଡ଼୍, ପାପେତିଙ୍କ୍ ପଇସ୍ ହାୱ୍‍କ୍‍ତେ ପଶୁତ୍ ଆୱୁଙ୍ଗ୍ ତିନଡ଼୍ ନୁ ଯୌନ ପାପ୍‍ତାଗାଙ୍କ୍ ୱେରେ ମାନ୍‍ତଡ଼୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ମେଣ୍ଡନ୍ ଦିନ୍ ପାଉଲ୍ ଅଡ଼୍‌ ନାଲ୍‍ୱୁଡ଼୍ ତଡ଼୍ ଶୁଚିକରଣ ବିଦି ପାଲନ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ । ତାନ୍ ପେର୍‍କେ ଅଣ୍ଡ୍‌ ମନ୍ଦିର୍‍ତାଗ୍ ଆଞ୍ଜ୍ ଶୁଚିକରଣ ପାଡ଼୍‍ୟି ବେସୁଟ୍‌ ପୁରା ଆଦ୍‍ତେ ନୁ ବେନ୍ ସମୟ୍‍ତେ ପୁଜିତଡ଼୍, ଆଦ୍ ଅଂକିଙ୍କ୍‌ କେସିତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ଶୁଚିକରଣ୍ ପାଡ଼୍‍ୟି ସାତ୍ ଦିନ୍ ତେର୍‍ତେ ୱେଲେ ଏସିଆ ପ୍ରଦେଶ୍‍ତେ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ଇହୁଦୀଡ଼୍ ପାଉଲ୍‍ତିଙ୍କ୍ ମନ୍ଦିର୍‍ତାଗ୍ ଉଡ଼୍‍ତଡ଼୍ । ଅଡ଼୍‌ ଆଗେ ଗୁଡ଼ିମାନ୍ଦାନ୍ ନାରୁଡ଼୍‍କିଂଙ୍କ୍ ପୁସ୍‍କା ମାଡ଼ି ପାଉଲ୍‍ତିଙ୍କ୍ ପଇତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ଅଡ଼୍‌ କିଡ଼୍‍କି କେତ୍‍ତଡ଼୍, “ହଁ ଇସ୍ରାଏଲୀୟ ଦାଦାଲଡ଼ି, ମାକିଂଙ୍କ୍ ସାହାଯ୍ୟ ମାଡ଼ାଟ୍ ! ଇ ନାରୁଣ୍ଡ୍‍ ସାରେପାକ୍ ଆଞ୍ଜ୍ ଇଶ୍ରାଏଲୀୟ ନାରୁଡ଼୍ ବିରୁଦ୍ଦ୍‍ତେ, ମୋଶାନ୍‌‌ ନିୟମ୍‍ ନୁ ଇଦ୍ ମନ୍ଦିର୍‍ ବିରୁଦ୍ଦ୍‍ତେ ଶିକ୍ଷା ଇଦୁତଣ୍ଡ୍ । ଇଞ୍ଜେ ଅଣ୍ଡ୍‌ ମେଣ୍ଡେ ବେସ୍କ୍‍ତୁଡ଼୍‍ ଅଣଇହୁଦୀଡ଼୍‍କ୍ ମନ୍ଦିର୍ ଲୋପେ ତାସ୍ ଇଦ୍ ପବିତ୍ର ପଡ଼୍‍ୟେତିଙ୍କ୍ ଶୁଚି ମାଡ଼୍‍ତଣ୍ଡ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ଅଡ଼୍‌ ନାର୍‍ତାଗ୍ ଏଫିସିୟତେ ତ୍ରଫିମ୍‍ତିଙ୍କ୍ ପାଉଲ୍ ତଡ଼୍ ଉଡ଼୍‍ତାଙ୍କ୍ ହାଲ୍‍ସ୍‍ତଡ଼୍ ଯେ, ପାଉଲ୍ ଅଂକିଙ୍କ୍‌ ମନ୍ଦିର୍‍ତାଗ୍ ଆତ୍‍ତଣ୍ଡ୍‍ । ");
INSERT INTO kff_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ନଗର୍‍ତେ ସାରେତଡ଼୍ କପାମ୍ ଆତ୍‍ତଡ଼୍ । ନାରୁଡ଼୍ ପାଉଲ୍‍ତିଙ୍କ୍ ମନ୍ଦିର୍‍ତାଗାଙ୍କ୍ ବାୟିଦେ ଲାଗି ତାତ୍‍ତଡ଼୍ । ମନ୍ଦିର୍‍ତେ ମାର୍‍ ସାରେ ବନ୍ଦ୍ ମାଡ଼୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","କପାମ୍ ଆତ୍‍ତେ ମାନେୟ୍‍ ପାଉଲ୍‍ତିଙ୍କ୍ ହାୱ୍‍କାଙ୍କ୍ ତିଆର୍ ଆଦ୍‍ତଡ଼୍, ଇତ୍‍କେ ଟିକ୍ ଆଦେ ସମୟ୍‍ତେ ଯିରୁଶାଲେମ୍‍ତାଗ୍ ଇଂସାକାଣ୍ଡ ଗଟେମ୍ ଆଦୁତ୍‍ତେ ଇଞ୍ଜ ପୁଞ୍ଜ୍ ରୋମୀୟ ସୈନ୍ୟଡ଼୍ ମୁକ୍ୟାଲ୍ କବର୍ ପାଏମ୍ ଆସ୍, ");
INSERT INTO kff_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ଆଗାଙ୍କ୍‍ ବେସ୍‍କ୍‍ତୁଡ଼୍‍ ସେନାପତି ନୁ ସୈନ୍ୟଡ଼୍‍କ୍ ପଇସ୍ ଆଦ୍ ପଡ଼୍‍ୟେତାଗ୍ ୱାତ୍‍ତଣ୍ଡ୍ । ନାରୁଡ଼୍ ସୈନ୍ୟଡ଼୍ ମୁକ୍ୟାଙ୍କ୍ ନୁ ସୈନିକିଡ଼୍‍କ୍ ଉଡ଼ି ପାଉଲ୍‍ତିଙ୍କ୍ ମେଣ୍ଡେ ରେହେୱକଟ ୱିଡ଼୍‍ସ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ସୈନ୍ୟଡ଼୍ ମୁକ୍ୟାଲ୍ ପାଉଲ୍‍ତିଙ୍କ୍ ଗିରଫ୍ ମାଡ଼ି ଅଂକିଙ୍କ୍‌ ରେଣ୍ଡ୍ ଇକ୍‍ଲେମ୍ ତଡ଼୍ ତଅତ୍‍ତାନଙ୍କ୍ ଗଟ୍ ହିତ୍‍ତଣ୍ଡ୍ । ତାନ୍ ପେର୍‍କେ ଅଣ୍ଡ୍‌ ପାଚ୍ରାମାଡ଼୍‍ତଣ୍ଡ୍, “ଇଣ୍ଡ୍ ନାରୁଡ଼୍ ବେନ ନୁ ଅଣ୍ଡ୍‌ ବାତ୍ ମାଡ଼୍‍ତଣ୍ଡ୍ ?” ");
INSERT INTO kff_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ନାରୁଡ଼୍ ଗହଲିତାଗ୍ ବେନ ବାତ୍‍ବାତା କେସ୍ କିଡ଼୍‍କ୍‌ତଡ଼୍ । ଇଦ୍ ରକମ୍ ରାମ୍‍କ୍ ଆତ୍‍ତଡ଼୍ ଯେ, ସୈନ୍ୟଡ଼୍ ମୁକ୍ୟାଲ୍ ବାତ୍ ଗଟେମ୍ ଆତ୍‍ତେ, ଆଦ୍ ପୁନ୍ଦାନଙ୍କ୍ ପାର୍‍ୱଣ୍ଡ୍ । ଆଦିଙ୍କ୍ ପାଉଲ୍‍ତିଙ୍କ୍ ଦୁର୍ଗତାଗ୍ ଲୋପେ ଆଦାନଙ୍କ୍ ସୈନିକିଡ଼୍‍କ୍ ଆଦେଶ୍ ହିତ୍‍ତଣ୍ଡ୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ଅଡ଼୍‌ ଅଂକିଙ୍କ୍‌ ଆସ୍ ଦୁର୍ଗତେ ପାହାଚ ଗାର୍‍ରେ ହେୱୁଦାନ୍ ୱେଲେ ଅନ୍‌ ସାରେପାକ୍ ମାନ୍ଦାନ୍ ନାରୁଡ଼୍ ଗାଟି ବିଶୃଙ୍କଲା ଆତ୍‍ତାଙ୍କ୍ ସୈନିକିଡ଼୍ ପାଉଲ୍‍ତିଙ୍କ୍ କାଞ୍ଜୀ ଆତ୍‍ତଡ଼୍ । ");
INSERT INTO kff_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ନାରୁଡ଼୍ ସାରେତଡ଼୍ ଅନ୍‌ ପେର୍‍କେ ପେର୍‍କେ ୱାସ୍ କିଡ଼୍‍କି କେସମାତ୍‍ତଡ଼୍, “ଅଂକିଙ୍କ୍‌ ହାୱ୍‍କାଟ୍ ।” ");
INSERT INTO kff_vpl VALUES ("AC21_37","0